﻿USE sofia;
DROP TABLE IF EXISTS sofia.pioNT_vpl;
CREATE TABLE pioNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES pioNT_vpl WRITE;
INSERT INTO pioNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Yái cuyàluta icàlidaca Jesucristo yàawirináimi íipidená. Yái Jesucristoca yácata nataquérinámi, yái rey David, Abraham nacái. ");
INSERT INTO pioNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham ìiri íipidenáté Isaac. Isaac ìiri íipidenáté Jacob. Jacob ìiri íipidenáté Judá. Judá, nía nacái yéenánái once namanùbaca, níacata israelitanái yàawirináimi. ");
INSERT INTO pioNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judá yéenibe asìanái náipidenáté Fares, Zara nacái. Náatúa uípidenáté Tamar. Fares ìiri íipidenáté Esrom. Esrom ìiri íipidenáté Aram. ");
INSERT INTO pioNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram ìiri íipidenáté Aminadab. Aminadab ìiri íipidenáté Naasón. Naasón ìiri íipidenáté Salmón. ");
INSERT INTO pioNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmón ìiri íipidenáté Booz. Booz yáatúa uípidenáté Rahab. Booz ìiri íipidenáté Obed. Obed yáatúa uípidenáté Rut. Obed ìiri íipidenáté Isaí. ");
INSERT INTO pioNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Isaí ìiri íipidenáté rey David. Rey David ìiri íipidenáté Salomón. Salomón yáatúa, úacata Urías yàacawéetúami quéechatécáwa. ");
INSERT INTO pioNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomón ìiri íipidenáté Roboam. Roboam ìiri íipidenáté Abías. Abías ìiri íipidenáté Asa. ");
INSERT INTO pioNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa ìiri íipidenáté Josafat. Josafat ìiri íipidenáté Joram. Joram ìiri íipidenáté Uzías. ");
INSERT INTO pioNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzías ìiri íipidenáté Jotam. Jotam ìiri íipidenáté Acaz. Acaz ìiri íipidenáté Ezequías. ");
INSERT INTO pioNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezequías ìiri íipidenáté Manasés. Manasés ìiri íipidenáté Amón. Amón ìiri íipidenáté Josías. ");
INSERT INTO pioNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Abéeri néená Josías yéenibeca asìanái íipidenáté Jeconías, yáté camuí Babilonia yàasu cáli néeséeyéi náibàacaalíté israelitanái natécaténá nía presoíri iyú Babilonia néré. ");
INSERT INTO pioNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Néeseté idècunitàacá israelitanái ìyaca presoíri iyú Babilonia yàasu cáli íinata, Jeconías idènìacaté ìiriwa íipidenéeri Salatiel. Salatiel ìiri íipidenáté Zorobabel. ");
INSERT INTO pioNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zorobabel ìiri íipidenáté Abiud. Abiud ìiri íipidenáté Eliaquim. Eliaquim ìiri íipidenáté Azor. ");
INSERT INTO pioNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azor ìiri íipidenáté Sadoc. Sadoc ìiri íipidenáté Aquim. Aquim ìiri íipidenáté Eliud. ");
INSERT INTO pioNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud ìiri íipidenáté Eleazar. Eleazar ìiri íipidenáté Matán. Matán ìiri íipidenáté Jacob. ");
INSERT INTO pioNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jacob ìiri íipidenáté José. Yái José yeedácaté iríwa María, úái Jesús yáatúaca. Wáimaca Jesús ìwali Mesíascani, íimáanáca wacuèrinásàiri Dios ibànuèricaté walí, wía israelitaca, icùacaténá wía. ");
INSERT INTO pioNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Iná waputàaca catorce namanùbaca Abraham itaquénáinámi ìyéeyéicaté Abraham yàasu èeri idénáami, idènièyéicaté nacái yéenibewa àta rey David imusúacatalétaté iicá èeri. Néese rey David idénáami, nàyacaté catorce namanùbaca David itaquénáinámi ìyéeyéicaté David yàasu èeri idénáami, idènièyéicaté nacái yéenibewa àta Babilonia yàasu cáli néeséeyéi natécatalétaté israelitanái presoíri iyú Babilonia néré. Néeseté idécanáamité israelitanái nàyaca presoíri iyú Babilonia yàasu cáli íinata, néese Mesías yàawirináimi catorce namanùbaca nàyacaté, nadènìacaté nacái néenibewa àta Mesías imusúacatalétaté iicá èeri, yái wacuèrinásàiri íipidenéerica Jesucristo. ");
INSERT INTO pioNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Siùcade nucàlidaca Jesucristo iináwaná ìwali yái imusúanácaté iicá èeri: Yáatúa María idècunitàacá ucùaca ucásàanápinátéwa José yáapicha, càmíichúaca iimá yáapicha. Quéwa, udéerìcuca sùmài, Espíritu Santo íiwitáise iyú. ");
INSERT INTO pioNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Néese José, cayábéerica íiwitáise, càmitaté iwàwa ibáiniadaca úa áibanái yàacuésemi. Iná íináidacawa imàacáanápiná íichawa úa ibàacanéeri iyú càmicáiná ìiri yái udéerìcuírica. Càmitaté José iwàwa icháawàaca uináwaná ìwali ùyacàle mìnanái irí ipíchanáté nanúaca úa. ");
INSERT INTO pioNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Yá José íináidacatéwa imàacáanápiná íichawa úa, quéwa abéeri ángel Dios néeséeri yàanàaca José yàatalé. Yá ángel imàacaca yáawawa José iicácani yáamacani irìcuíse. Yá ángel íimaca José irí: “José, rey David itaquérinámi, picá cáalu peedáca María pìacawéetúapináca úara, udéerìcucáiná sùmài Espíritu Santo íiwitáise iyú. ");
INSERT INTO pioNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Sùmàiquéera yái imusuéripinácawa María íicha. Pimàni íipidená Jesús. Iipidenápiná cài yácáiná iwènúadapiná yàasu wenàiwicanái íiwitáisewa nabáyawaná íichawa, ipíchaná Dios yùuwichàidaca nía nabáyawaná ìwalíisewa”, íimaca yái ángelca. ");
INSERT INTO pioNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Càité ángel icàlidaca José iríni macáita ichàbáanápinátéwa càide iyúwaté profeta icàlidáanáté Dios itàacái wenàiwicanái irí. ");
INSERT INTO pioNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Bàaluitécáiná Dios yàasu profeta íimacaté nalí Dios inùmalìcuíse: “Abéechúa mànacàu càmíichúacáwaca iimá asìali yáapicha, udéerìcupinácawa. Imusúapinácawa uícha abéeri sùmài, namàníiripiná íipidená Emanuel”, íimacaté yái profetaca. (Yái íipidená Emanuel íimáanáca: “Dioscata wáapicha”). ");
INSERT INTO pioNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Néeseté José icawàacawa, yá imànicaté càide iyúwa Dios yàasu ángel ichùulìanáni. Yáté èerica yeedácaté úái Maríaca yàacawéetúapinácawa. ");
INSERT INTO pioNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Càmíiritàacá quéwa José iimá úapicha àta uìri imusúacatalétaté iicá èeri yái idàbáanéerica uìrica. Yá José imànicaté íipidená Jesús. ");
INSERT INTO pioNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Jesús imusúacaté iicá èeri Belén ìyacàlená irìcu, Judea yàasu cáli íinata, rey Herodes icùacaalíté yái cálica. Néenialíté abénaméeyéi asìanái cáalíacáiyéi nàanàaca Jerusalén ìyacàlená irìculé. Déecuíséeyéi nàanàaca, Oriente yàasu cáli néeséeyéi, yéewáidéeyéicawa nacái dùlupùta ìwali. ");
INSERT INTO pioNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Nasutáca néemìawa Jerusalén ìyacàlená mìnanái: —‍¿Alénásica judío icuèrinápiná siùquéerica tàacáwa imusúaca iicá èeri? Wáalíacawa idéca asáicani waicácáináté áiba dùlupùtaca íimáanáca idéca imusúaca iicá èeri, yái picuèrinápinácuéca, píacué judíoca. Iná wadéca wàanàaca wàacaténá icàaluíniná —‍náimaca. ");
INSERT INTO pioNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Yá rey Herodes yéemìaca cáalíacáiyéi iináwaná, íná máiní cáaluca íináidacawa, càmicáiná iwàwa áiba yeedáca íicha yái cálica. Jerusalén ìyacàlená mìnanái nacái cáaluca nía canánama, càmicáiná nawàwa Herodes yàasu úwinái namànica úwi náipunita ìwalíise yái nacuèrinápináca wàlisàica. ");
INSERT INTO pioNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Néese rey Herodes ìwacáidaca sacerdote íiwacanánái, nía nacái yéewáidéeyéica wenàiwica templo irìcu. Herodes imáidaca nía isutácaténá yéemìawa nía alénápinácaalíté Mesías imusúa iicá èeri, yái judío icuèrinápiná Dios ibànuèrica nalí. ");
INSERT INTO pioNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Yá náimaca Herodes irí: —‍Belén ìyacàlená néenipináca imusúa iicá èeri, Judea yàasu cáli íinata, yácáináté Dios yàasu profeta itànàaca càiri tàacáisi Dios inùmalìcuíse bàaluité. Dios íimacaté: ");
INSERT INTO pioNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Pía, Belén ìyacàlenáca, Judea yàasu cáli íinatéeri ìyaca, caináwanáca pía áiba yàcalé íicha canánama ìyéeyéica Judea yàasu cáli íinata, yácáiná Nacuèriná imusúapinácawa Belén ìyacàlená irìcu icuèripiná nùasu wenàiwica, níái Israel itaquénáinámica’, càité itànàaca tàacáisi yái profetaca Dios inùmalìcuíse —‍náimaca. ");
INSERT INTO pioNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Néese Herodes imáidaca cáalíacáiyéi ibàacanéeri iyú áibanái íicha. Imáida isutáca yéemìawa nía yáalíacaténáwa cayába càinácaalíté èeri idàbacaté naicáca úái dùlupùtaca uchanàacawa. ");
INSERT INTO pioNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Néese Herodes idécanáami yéemìacani, yá íimaca nalí: —‍Pìacuéwa picutáca cayábani, yáara sùmàica; néese pidécanáamicué pìanàacani, yá picàlidacué nulí iináwaná, yéewanápiná nùacawa néré nubàlùacawa nùuluì ipùata iyúwa irí nùacaténá nacái icàaluíniná —‍meedáta cài íimaca nalí, ichìwáidacáita nía meedá Herodesca. Yá ibànùaca nía Belén ìyacàlená nérépiná. ");
INSERT INTO pioNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Idécanáami néemìaca Herodes itàacái, yá nàacawa íicha níái cáalíacáiyéica. Yá néese, dùlupùta yàacawa napíchalépináta, úái dùlupùta naiquéechúacaté nàyacaalíté nàasu cáli néesewa. Yá uchanàacawa yàcalé iwicáu yái sùmài ìyacatáica. ");
INSERT INTO pioNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Néese naicácáiná dùlupùta, yá casíimáica nía manuísíwata. ");
INSERT INTO pioNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Yá nawàlùacatéwa capìi irìculé. Naicáca sùmài néré yáatúa María yáapichawa. Yá nabàlùacawa irí nàuluì ipùata iyúwa nàacaténá sùmài icàaluíniná. Néese nàacùaca nàasuwa nàacaténá irí oro, incienso nacái, mirra nacái, níái cawèníiyéi pumènica isàni. ");
INSERT INTO pioNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Néese Dios yàalàaca nía náamacani irìcuísewa ipíchaná nèepùacawa Herodes yàatanabàa. Ináté nèepùacawa áiba àyapu irìcubàata Herodes íicha nàasu cáli nérépináwa. ");
INSERT INTO pioNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Néese idécanáamité nàacawa níái cáalíacáiyéica, yá Dios ibànùaca ángel yàanápinátéwa José yàatalé. Yái ángel imàacaca yáawawa José iicácani yáamacani irìcuíse. Yá ángel íimaca irí: “Pimichàawa, pichùnìa pìasuwa pìanáwa, pitéca yái sùmàica yáatúa yáapichawa, pìacàatétawa Egipto yàasu cáli nérépiná. Pìya néréwa àta numáidacataléta píawa, Herodescáiná icutápiná inúawa yái sùmàica”, íimaca yái ángelca. ");
INSERT INTO pioNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Néese, José imichàacawa táiyápi, itécani yái sùmàica, yáatúa yáapichawa. Yá yàacàatécatawa náapicha Egipto yàasu cáli nérépiná. ");
INSERT INTO pioNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Nàyacaté néré àta Herodes yéetácatalétatéwa. Ináté macáita ichàbacawa càide iyúwaté Dios yàasu profeta icàlidáanáté tàacáisi Dios inùmalìcuíse: “Numáidaca Nuìriwa yàacaténáwa Egipto yàasu cáli íicha”, íimacaté yái Diosca. ");
INSERT INTO pioNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Néeseté Herodes yáalíacawa naináwaná ìwali níái cáalíacáiyéica càmitaté neebáida itàacái, yá calúaca báawanamani yái Herodesca. Iná Herodes ibànùaca yàasu úwináiwa nanúacaténá macái sùmanái asìanái Belén ìyacàlená irìcuíyéica, áiba yàcalé nacái ìyéeyéica mawiénibàa Belén irí. Nanúacaté macái sùmanái asìanái idènièyéica àta pucháiba camuí, níacáináté cáalíacáiyéica nacàlidacaté Herodes iríni nadàbacaté naicáca dùlupùta pucháiba camuí ipíchawáiseté nàanàaca Jerusalén ìyacàlená néré. ");
INSERT INTO pioNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Càité ichàbacawa càide iyúwaté profeta Jeremías itànàanáté tàacáisi Dios inùmalìcuíse. Jeremías íimacaté: ");
INSERT INTO pioNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Náicháanípiná cachàini manuísíwata níái Ramá ìyacàlená mìnanáica, Raquel itaquénáinámica. Náicháanípináca, máiní achúmaca nawàwa néenibe íinináwa. Canácata yáaliméeripiná isíimáidaca níawa, néenibemi yéetácáináwa náicha”, íimacaté yái profetaca Jeremías. ");
INSERT INTO pioNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Néese idécanáamité Herodes yéetácawa, Dios ibànùaca ángel yàacaténáwa José yàatalé Egipto yàasu cáli néré. Yá ángel imàacaca yáawawa José iicácani yáamacani irìcuíse. Yá ángel íimaca José irí: ");
INSERT INTO pioNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Pimichàawa, pité yái sùmàica yáatúa yáapichawa, pèepùawa Israel itaquénáinámi yàasu cáli nérépiná. Nadéca néetácawa níara iwàwéeyéicaté inúacani”, íimaca yái ángelca. ");
INSERT INTO pioNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Yá néeseca José imichàacatéwa, itécani yái sùmàica yáatúa yáapichawa Israel yàasu cáli nérépiná. ");
INSERT INTO pioNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Quéwa, José yéemìaca Arquelao iináwaná ìwali icùaca judíonái yàasu cáli yáanirimi Herodes yáamirìcubàamiwa, íná cáaluca José yàacawa néré. Yá nàacawa Galilea yàasu cáli néré ángel icàlidacáiná José iríni yáamacani irìcuíse nàanápináwa Galilea yàasu cáli néré. ");
INSERT INTO pioNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Nàanàacaté Galilea yàasu cáli néré, yá nàacawa nàyacaténá Nazaret ìyacàlená irìcu. Nàyacaté néré càide iyúwaté profetanái íimáanáté Jesús ìwali. Profeta íimacaté náimáanápináté Jesús ìwali Nazaret ìyacàlená néeséericani. ");
INSERT INTO pioNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Néeseté madécaná camuí idénáami, néenialíté Juan el Bautista idàbaca icàlidaca Dios itàacái alé manacúali yùucubàa càináwàiri ìyéerica Judea yàasu cáli íinata. ");
INSERT INTO pioNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Manùbéeyéi wenàiwica nàacatéwa Juan yàatalé, néemìacaténá itàacái. Yá íimaca nalí: “¡Piwènúadacué píiwitáisewa Dios irípiná, mesúnamáicáináta Dios icùapiná macáita!” íimaca yái Juanca. ");
INSERT INTO pioNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Yái Juan el Bautista, yácata yái asìalica profeta Isaías itànèericaté tàacáisi iináwaná ìwali Dios inùmalìcuíse. Isaías itànàacaté yái tàacáisica: “Abéeri asìali icàlidapiná nalíwani cachàiníiri iyú manacúali yùucubàa càináwàiri. Càipiná íimaca nalí: ‘Càide iyúwa wenàiwicanái ichùnìacaalí àyapu Náiwacali irípináwa, càitacué nacái iwàwacutácué pichùnìaca píiwitáisewa Wacuèriná Dios irípiná, pitàidacaténácué cayábéeri iyúni. Pichùnìacué píiwitáisewa yéewacaténá idàbaca yéewáidacuéca pìyaca machacàníiri iyú càide iyúwa iwàwáaná’, càipiná íimaca”, càité itànàaca tàacáisi yái profeta Isaíasca. ");
INSERT INTO pioNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Yái Juan idènìacaté ibàlewa wáluma cáucuíri camello ichùna iwálumalená. Idacùacaté nacái ìwalìabàawa pìrái íimamimi. Iyáa nacái iyáacaléwa wirìichu nacáiyéi, mába ituní nacái Juan yàanèerica manacúali yùucubàa càináwàiri. ");
INSERT INTO pioNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Néese manùbéeyéi Jerusalén ìyacàlená mìnanái, madécaná nacái Judea yàasu cáli néeséeyéi, Jordán inanába yàasu cáli néeséeyéi nacái nàacatéwa Juan el Bautista yàatalé néemìacaténá itàacái. ");
INSERT INTO pioNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Néese nacàlidaca náichawa yái báawéerica namàníirica, yá Juan ibautizáca nía Jordán inanába yáaculé. ");
INSERT INTO pioNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Quéwa Juan iicáca manùbéeyéi fariseo, saduceo nacái manùba nàanàaca yàatalé ibautizácaténá nía, yá Juan yáalíacawa càmitaté nawènúada náiwitáisewa báawéeri íicha báisíiri iyú, íná Juan yàalàaca nía cachàiníiri iyú. Iima nalí: “¡Píacué, càiyéide iyúwa àapi iculále! Manuíri yùuwichàacáisi yàanàapiná mesúnamáita, yùuwichàidacaténá wenàiwicanái. Piyúunáidacuéca píalimáaná pichúuliacawa íicha, yái yùuwichàacáisica, pibautizácaalícáitawa, éwitacué càmicáaníta piwènúada píiwitáisewa báisíiri iyú pibáyawaná íichacuéwa. ¡Càmitacué nucàlida pirí càiri chìwái! ");
INSERT INTO pioNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Iwàwacutácué pìyaca machacàníiri iyú càide iyúwa Dios iwàwáaná, yéewanápiná macái wenàiwica naicáca amaléeri iyú piwènúadacuéca píiwitáisewa báisíiri iyú Dios irípiná. ");
INSERT INTO pioNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Picácué píima piríwa: ‘Canácatáita Dios yùuwichàida wíawa, ¡Abraham itaquénáinámicáiná wía!’ picácué cài píima. Péemìacué cayábani, éwita Dios imáalàida macáitacué pía pibáyawaná ìwalíisewatá, càicáaníta Dios yáalimá iwènúadaca níái íbaca Abraham itaquénáinámipiná iyútá Dios yàasu wenàiwicapiná nía píamirìcubàamicuéwa. ");
INSERT INTO pioNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Máiní mawiénica yái yùuwichàacáisi Dios imàaquéeripináca yàanàaca báawéeyéi ìwali, càide iyúwa mawiénicaalí wenàiwica iwichùaca àicu ìwali chipàali iyú, càita nacái mawiénica yái Dios yàasu yùuwichàacáisica. Péemìacué comparación: Càide iyúwa wàucacaalí macái àicu canéeyéi irí ìyacaná cayába weemácaténá nía quichái irìcu, càita nacái Dios yùuwichàidapiná wenàiwica quichái irìcu cawinácaalí wenàiwica càmíiyéica imàni cayábéeri càide iyúwa Dios iwàwáaná. ");
INSERT INTO pioNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Báisíta nubautizácué pía úni yáaculé, píasáidacaténácué pidéca piwènúadaca píiwitáisewa Dios irípiná, quéwa mesúnamáita áiba yàanàaca núamirìcubàawa. Yátacué ibànùapiná Espíritu Santo abénaméeyéicué péená irí ibautizácaténá náiwitáise Espíritu Santo ichàini iyú cawinácaalí wenàiwica yeebáidéeyéica itàacái, yái yàanèeripináca. Aibanáicué péená quéwa càmíiyéica yeebáida itàacái, ibautizápináca níawa quichái iyúwa, nàuwichàacaténáwa càiripináta. Máiní cachàiníiri íiwitáise nuícha. Nuíwacalicani, yái yàanèeripináca; nuicáca núawawa iyúwa yàasu wenàiwica càmíiri cachàini náicha canánama, máinícáiná cayábéerica nuíchani. ");
INSERT INTO pioNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Péemìacué comparación: Càide iyúwa wenàiwica natécaalí nàasu palawa nacáapi irìcuwa masacàacaténá namànica nàasu trigo ituínáwa, náaláidacaténá nacái trigo iwìralèmi, càita nacái yái yàanèeripináca núamirìcubàa yàanàaca iwàlisàidacaténá yàasu wenàiwica íiwitáisewa, iseríacaténá nacái nía náicha áibanái càmíiyéica yàasu. Càide iyúwa wenàiwica yeedácaalí ibànacale trigo ituínáwa manuíri capìi irìculé ituínási yàaluca, càita nacái yái yàanèeripináca ìwacáidapiná yàataléwa yàasu wenàiwicanáiwa. Càide iyúwa wenàiwica yeemácaalí ituínási iwìralèmi manuíri quichái irìcu, càita nacái yái yàanèeripináca yùuwichàidapiná macáita càmíiyéica yàasu wenàiwica quichái irìcu, càmíirica ichacàwa càiripinéerita ìyaca”, íimaca yái Juanca. ");
INSERT INTO pioNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Néeseté Jesús yàacatéwa Galilea yàasu cáli íicha yàanàacaténá Juan yàatalé Jordán inanába néré, yéewacaténá Juan ibautizácani, yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Néese quéechatécáwa càmita Juan iwàwa ibautizáca Jesús, báicáiná iicáca yáawawa Jesús iwéré. Yá Juan íimaca Jesús irí: —‍Nuwàwacutáca pibànùaca nulí Espíritu Santo ibautizácaténá nuíwitáise. Càmita cayába nubautizá pía úni yáaculé meedá, máinícáiná cachàinica nuícha pía —‍íimaca yái Juanca, yáalíacáinátéwa canáca Jesús ibáyawaná. ");
INSERT INTO pioNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Quéwa Jesús íimaca irí: —‍Siùcade iwàwacutáca pibautizáca núa, cayábacáiná wamànica macáita càide iyúwa Dios ichùulìaná, yéewanápiná macáita náalíacawa nuebáidaca Dios itàacái —‍íimaca yái Jesúsca. Ináté Juan ibautizácani. ");
INSERT INTO pioNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Néeseté idécanáami Jesús ibautizácawa, yá imichàacawa úni yáacuíse. Yáta capìraléeri cáli yàacùacawa, yá Jesús iicáca Espíritu Santo iricùacawa ìwali Dios yàatanáise càide iyúwa unùcu iricùanáwa. ");
INSERT INTO pioNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Néese néemìaca Dios itàacái chènuníise. Dios íimaca: “Yácata Nuìri nuwàwéeri cáininéerica nuicáca. Cayábaca nuwàwa nuicácani”, íimaca yái Diosca. ");
INSERT INTO pioNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Néeseté Espíritu Santo itéca Jesús manacúali yùuculé càináwàiri yéewacaténá Satanás yáalimáidaca Jesús imàníinápiná ibáyawanáwa, quéwa Jesús càmita yeebá Satanás irí. ");
INSERT INTO pioNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Jesús ìyacaté néré cuarenta èeri, catá nacái. Canácata Jesús iyéeri iyáacaléwa. Yá máapicani. ");
INSERT INTO pioNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Néese Satanás yàacawa Jesús yàatalé yáalimáidacaténá Jesús imàníinápiná ibáyawanáwa. Yá íimaca Jesús irí: —‍Dios Iiricáiná pía, yá pichùulìa níái íbaca nawènúanápináwa pan iyú piyáacaténáni —‍íimaca yái Satanásca. ");
INSERT INTO pioNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Quéwa Jesús íimaca irí: —‍Càmíirita. Dios itàacái profeta itànèericaté íimaca walí: ‘Picácué wáináidawa yàacàsi ìwali Dios íicha. Néese iwàwacutácué weebáidaca macáita iyúwa Dios íimáaná yéewanápiná wàyaca machacàníiri iyú’, íimaca yái Dios itàacáica —‍íimaca yái Jesúsca, càmicáináté iwàwa imànica wawàsi meedá irípináwa Dios íiwitáise iyú. ");
INSERT INTO pioNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Néese Satanás itéca Jesús Jerusalén ìyacàlená néré, yái yàcalé cáininéerica Dios iicáca. Yá Satanás imichàidaca Jesús templo ipùata íinatalé chènuníiri náicha canánama. ");
INSERT INTO pioNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Néese Satanás yáalimáidaca Jesús imàníinápiná ibáyawanáwa. Satanás íimaca Jesús irí: —‍Dios Iiricáiná pía, pipisìawa templo íicha cáli íinatalépiná, yácáiná Dios yàasu profeta itànàacaté Dios itàacái piináwaná ìwali. Profeta íimacaté: ‘Dios ichùulìapináca yàasu ángelnáiwa nacùanápiná pía. Namichàidapiná nacái píawa nacáapi iyúwa ipíchaná pinúa píawawa íba iwéré’, càité profeta itànàaca Dios itàacái piináwaná ìwali —‍íimaca yái Satanásca. ");
INSERT INTO pioNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Néese Jesús íimaca Satanás irí: —‍¡Càmíiri! Dios itàacái profeta itànèericaté íimaca nacái walí: ‘Picá píalimáida piicáwa Picuèriná Dioswa asáisí icùacaalí pía’, càité profeta itànàaca Dios itàacái —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Néese àniwa Satanás itéca Jesús chènuníiri dúli íinatalé. Yá Satanás yáasáidaca Jesús iicá macái cáli èeri irìcuíyéi, nachàini yáapicha nacái, nàasu cawèníiri nacái. ");
INSERT INTO pioNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Néese Satanás íimaca Jesús irí: —‍Nùapináca piríwa macáitani pibàlùacaalíwa nulí piùluì ipùata iyúwa pìacaténá nucàaluíniná —‍íimaca yái Satanásca. ");
INSERT INTO pioNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Jesús íimaca irí: —‍¡Càmíiri! Pìawa nuícha, Satanás. Càmita nùa picàaluíniná, yácáiná Dios itàacái profeta itànèericaté íimaca walí: ‘Iwàwacutá pìaca Picuèriná Dios icàaluínináwa. Iwàwacutá nacái pìaca abéerita Dios iyéininá’, càité itànàaca yái profetaca —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Ináté Satanás yàacawa Jesús íicha, yá abénaméeyéi ángelnái yàanàaca néré nayúudàacaténá Jesús. ");
INSERT INTO pioNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Jesús yéemìacaté áibanái náucacaté Juan el Bautista presoíyéi ibànalìculé, íná Jesús yèepùacawa Galilea yàasu cáli nérépiná. ");
INSERT INTO pioNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Quéwa càmita iyamáawa Nazaret ìyacàlená irìcu, néese yàacatéwa ìyacaténá Capernaum ìyacàlená irìcu, ìyéerica Galilea icalìsaniná idùlepiré, Zabulón itaquénáinámi yàasu cáli íinata, Neftalí itaquénáinámi yàasu cáli nacái. ");
INSERT INTO pioNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Jesús imànicaté cài yéewacaténá macáita ichàbacawa càide iyúwa profeta Isaías itànàanáté tàacáisi Jesús iináwaná ìwali. Isaías íimacaté Dios inùmalìcuíse: ");
INSERT INTO pioNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Píacué israelita ìyéeyéica Zabulón itaquénáinámi yàasu cáli íinata, Neftalí itaquénáinámi yáapicha, yái cáli ìyéerica abéemàalé Jordán inanába íicha, Galilea icalìsaniná idùlepiré, alé càmíiyéi israelita ìyacataléca, Galilea yàasu cáli. ");
INSERT INTO pioNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Píacué catéeyéica íiwitáise, càmíiyéica yáalía Dios ìwali, áiba yàanàapinácué pìatalé amalácaténácué imànica píiwitáise. Yéewáidapinácué pía, pìyacaténácué Dios icamaláná irìcu, píacué canéeyéica icáuca càmíiri imáalàawa, ìyéeyéica siùcade iyúwa yéetáními”, íimacaté yái Isaíasca. ");
INSERT INTO pioNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Néeseté Jesús idàbaca yéewáidaca nía. Iimaca nalí: “Piwènúadacué píiwitáisewa Dios irípiná, mesúnamáicáináta Dios icùapiná macáita”, íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Néeseté Jesús yèepunícawa Galilea icalìsaniná icàinalená íinatabàa. Yá iicáca pucháiba asìanái. Ibèeri íipidená Simón, áibaalí íipidená Pedro nacái. Iméeréeri íipidená Andrés. Cubái inuérinánáica nía needácaténá nalíwa nàasu platawa. Náucaca nàacawa nàasu tarayawa nèepunícawa calìsáacubàa. ");
INSERT INTO pioNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Jesús íimaca nalí: —‍Aquialécué síisaara, pìacuéwa núapicha iyúwa nuéwáidacalénái. Pidécuéca píibaidaca píibàacaténácué cubái, quéwa siùcáisede nùacuéca pirí wàlisài píibaidacalépiná pìwacáidáanápinácué nulí wenàiwica yéewacaténá nuéwáidacaléca nía —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Yáta namàacaca náichawa nàasu tarayawa. Yá nàacawa Jesús yáapicha. ");
INSERT INTO pioNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Néese nàacawa àniwa calìsa idùlepiré, yá Jesús iicáca áibanái asìanái pucháiba: Ibèeri íipidená Santiago, iméeréeri íipidená Juan. Zebedeo yéenibeca nía. Nachùnìaca nàyaca nàasu chinchorrowa barca irìcu náaniri yáapichawa. Yá Jesús imáidaca nía, nàanápináwa yáapicha, iyúwa yéewáidacalénái. ");
INSERT INTO pioNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Yá caquialéta namàacaca barca, náaniri nacáiwa, yá nàacawa Jesús yáapicha. ");
INSERT INTO pioNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jesús ipáchiaca yèepunícawa macái Galilea yàasu cáli íinatabàa. Macái yàcalé irìcu nacái yéewáida yèepunícawa judíonái yéewáidacàalu irìcu. Yá icàlidaca nalí yái tàacáisi cayábéerica náalíacaténáwa càinácaalí iyú Dios icùaca yàasu wenàiwicawa. Yúucaca náicha nacái macái uláicái íiwitáaná. ");
INSERT INTO pioNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Macái Siria yàasu cáli néeséeyéi néemìaca Jesús iináwaná, yá natéca néenánáiwa Jesús yàatalé, macái yùuwichèeyéicawa uláicái iyú, cáiwíiri iyú nacái. Natéca nacái wenàiwica demonio idacuèyéica íiwitáise, naté nacái áibanái idènièyéica tèwacáimi nacái, máapinéeyéi nacái. Yá Jesús ichùnìaca nía macáita. ");
INSERT INTO pioNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Manùbéeyéi wenàiwica nàacawa Jesús yáapicha: Galilea yàasu cáli néeséeyéi, áibanái nacái yàanèeyéica diez namanùbaca yàcalé néese Decápolis yàasu cáli íinatéeyéica ìyaca, áibanái nacái Jerusalén ìyacàlená mìnanái, Judea yàasu cáli néeséeyéi nacái, áibanái nacái ìyéeyéica abéemàalé Jordán inanába íicha. ");
INSERT INTO pioNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Néeseté Jesús iicáca manùbéeyéi wenàiwica ìwacáidáyaquéeyéiwa yàatalé néemìacaténá itàacái, yá yàacawa dúli íinatalé, yá yáawinacawa néré. Yéewáidacalénái nàacawa yàatalé. ");
INSERT INTO pioNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Yá idàbaca yéewáidaca nía. Iimaca nalí: ");
INSERT INTO pioNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Cawinácaalí wenàiwica càmíiyéica cachàini iicáca yáawawa, yáaliéyéi nacáiwa nawàwacutáaná Dios iyúudàaca nía, casíimáica nía Dios icùacáiná nía. ");
INSERT INTO pioNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","“Cawinácaalí wenàiwica achúméeyéica iwàwa ibáyawaná ìwaliwa siùcade, èeri mìnanái ibáyawaná ìwali nacái, casíimáipináca nía yácáiná Dios isíimáidapiná nía. ");
INSERT INTO pioNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","“Cawinácaalí wenàiwica càmíiyéica cáimacái iicáca yáawawa, itàaníiyéi nacái casalíníiri tàacáisi iyú éeréeri iyú nacái, casíimáipináca nía, yácáiná Dios imàacapiná nacùaca yáapicha èeri irìcuíri macáita. ");
INSERT INTO pioNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","“Cawinácaalí wenàiwica máiníiyéica iwàwa imànica abéerita cayábéeri càide iyúwa Dios iwàwáaná, casíimáica nía, yácáiná Dios imànipiná nalí macáita yái cayábéerica nawàwéerica imànica nalí. ");
INSERT INTO pioNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","“Cawinácaalí wenàiwica iiquéeyéica áibanái ipualé, casíimáica nía, yácáiná Dios iicápiná napualé nacái. ");
INSERT INTO pioNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","“Cawinácaalí wenàiwica masaquèeyéica íiwitáise, casíimáica nía, níacáiná iicápiná Dios natuí iyúwa. ");
INSERT INTO pioNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","“Cawinácaalí wenàiwica iwènúadéeyéica áibanái íiwitáise nalíwáaca nàyacaténá matuíbanáiri iyú náapichawáaca, casíimáica nía, Dios yéenibecáiná nía. ");
INSERT INTO pioNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","“Cawinácaalí wenàiwica yùuwichèeyéicawa Dios irípiná neebáidacáiná itàacái, casíimáica nía yácáiná Dios imàacapiná nacùaca yáapicha macáita. ");
INSERT INTO pioNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Píacué nuéwáidacalénáica, áibanái icuísacaalícué pía peebáidacáinácué nutàacái, yá namànicaalícué pirí báawéeri nùwalíise, yá nacháawàacaalícué piináwaná ìwali macái íiwitáaná nachìwa báawéeri iyúwa, peebáidacáinácué nutàacái, néese casíimáipinácuéca píawa. ");
INSERT INTO pioNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Casíimáicué piwàwa, piyanídacué nacáiwa manuísíwata, yácáiná Dios imàacapinácué pirí cawèníiri manuísíwata pìanàapinácaalícué chènuniré. Casíimáicué piwàwa, nàawirináimicáiná namànicaté báawéeri Dios yàasu wenàiwica profetanái irí, níái pipíchaléeyéimicuéca íibaidéeyéicaté Dios irípiná càide iyúwacué pìyáaná”, íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Jesús íimaca yéewáidacalénái iríwa: “Péemìacué comparación: Càicuéca píade iyúwa iwidùma chái èeri irìcu. Yái iwidùma puìwaca imànica yàacàsi, yéewanápiná caséeca wenàiwica nayáacani. Néese càmicaalí quirínama puìwa iwidùmaca, yá càmita idé puìwaca àniwani, yái iwidùmaca. Yá canápinéerica meedáni. Wáucacani bàacháwalé, néese wenàiwica nàipìnáaníca íinatabàami. Càitacué nacái iwàwacutá pìyaca machacàníiri iyú, pimànicué cayábéeri nacái, yéewanápiná wenàiwica nawàwa neebáidaca yái báisíiri tàacáisica. ");
INSERT INTO pioNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Péemìacué áiba comparación: Càicuéca píade iyúwa camalási chái èeri irìcu. Càide iyúwa camalási icànacaalí catéeri irìculé, càita nacáicué iwàwacutá picàlidaca yái báisíiri tàacáisica èeri mìnanái irí amalácaténá náiwitáise, níái catéeyéica íiwitáise, càmíiyéica yáalía Dios ìwali. Iwàwacutácué pìyaca càide iyúwa manuíri yàcalé ìyéerica dúli ipùatalìcu. Càide iyúwa macáita náalimácaalí naicáca manuíri yàcalé, càita nacái iwàwacutácué pimàacaca áibanái iicáca pìyaca machacàníiri iyú càide iyúwa Dios itàacái íimáaná. ");
INSERT INTO pioNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Péemìacué áiba comparación: Watùcunìacaalí lámpara, càmita wabàani yàalusi irìculé. Néese wamàacaca icànaca chènunibàa, yá icànaca nàwali macáita ìyéeyéica capìi irìcu. ");
INSERT INTO pioNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Càita nacái iwàwacutácué pimàacaca picamalá icànaca áibanái íiwitalìcu: pìyacué machacàníiri iyú macái wenàiwica iicápiná, náalíacaténáwa ìwali yái cayábéerica pimàníiricuéca, yéewanápiná nacái nàaca icàaluíniná, Píaniri Diosca chènuníiséerica”, íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Jesús íimaca: “Picácué píináidawa nùanàaca numáalàidacaténá tàacáisi profeta Moisés itànèericaté Dios inùmalìcuíse, nía nacái profetanái icàlidéeyéicaté tàacáisi Dios inùmalìcuíse. Picácué cài píináidacawa nùwali. Càmita nùanàa numáalàidacaténá yái tàacáisica. Néese nudéca nùanàaca numànicaténá càide iyúwa íimáanáca yái tàacáisica icàlidéerica nuináwaná ìwali. ");
INSERT INTO pioNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Péemìacué cayábani: Máiní cachàiníiricani yái Dios itàacái bàaluisàimica profeta Moisés, áibanái profeta nacái natànèericaté Dios inùmalìcuíse. Macáita ichàbapinácawa càide iyúwaté Dios itàacái íimáaná. Aiba èeriwa Dios imáalàidapiná capìraléeri cáli, yá nacái èeriquéi. Quéwa canácatáita yúucawa yái itàacái bàaluisàimica, ibatàa abéeri letra achúméeríina piná, canácatáita imáalàawa. Macáita ichàbapináwa càiwade iyúwaté Dios itàacái íimáaná. ");
INSERT INTO pioNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Máinícáiná cachàiníirica macái tàacáisi natànèericaté Dios inùmalìcuíse, íná iwàwacutá wenàiwica neebáidaca macáitani. Canácata canéeri iwèni tàacáisi. Aibacaalí càmíiri yeebáida abéeri tàacáisi natànèericaté, càmicaalí nacái yéewáida áibanái neebáidáanápiná yái tàacáisica, yá canáca yéewanáwa iwàlùacawa Dios ìyacàle irìculé icùacatalé macáita chènuniré. Quéwa cawinácaalí yeebáidéerica yái tàacáisi Moisés, profetanái nacái natànèericaté Dios inùmalìcuíse, yá yéewáidacaalí wenàiwica neebáidáanápináni, yásí máiníiripiná cáimiétacanéeri yái wenàiwicaca Dios ìyacàle irìcu icùacataléca macáita chènuniré. ");
INSERT INTO pioNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Níara yéewáidéeyéica wenàiwica templo irìcu, nía nacái fariseoca nacàlidaca naináwaná ìwaliwa namàníinása macáita machacàníiri iyú càide iyúwa Dios ichùulìaná namànica. Báisíta namànica madécaná. Quéwa núumacué pirí: Iwàwacutácué pimànica càide iyúwa Dios iwàwáaná máiní cachàiníwanái náicha níái yéewáidéeyéica wenàiwica templo irìcu, náicha nacái fariseonáica. Càmicaalícué pimàni máiní cachàiníwanái náicha, yá càmitacué yéewa Dios yéenibeca pía, Dios icùacaténácué pía”, íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Jesús íimaca: “Pidécuéca péemìaca néewáidaca pía càide iyúwaté profeta Moisés íimáanáté Dios inùmalìcuíse. Iimacaté pìawirináimi irí: ‘Picá pinúa wenàiwica. Pinúacaalí wenàiwica, yá iwàwacutá péetácawa pibáyawaná ìwalíisewa’, íimacaté yái Moisésca. ");
INSERT INTO pioNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Siùcade núumacué pirí àniwa áibacaalí calúa iicáca áiba wenàiwica, yásí yéetápinácawa ibáyawaná ìwalíisewa. Aibacaalí itàaní báawéeri iyú áiba wenàiwica irí, yásí Dios yùuwichàida báawanamani, càide iyúwa Junta Suprema israelita íiwacanánái nàuwichàidáaná cabáyawanéeri wenàiwica. Aibacaalí icuísa íichawa áiba wenàiwica báawéeri iyú, yásí Dios yùuwichàidacani infierno irìcu, yái quichái càmíirica ichacàwa càiripinéerita ìyaca. ");
INSERT INTO pioNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","24","“Piwàwacaalí pité ofrenda altar néré pìacaténá Dios icàaluíniná, yá cayábéeriquéi pimàníináca cài. Quéwa ipíchawáise pìaca Dios icàaluíniná, píináidawa cayába asáisí cawàwanáta pimànicaalíté báawéeri áiba wenàiwica irí. Pimànicaalíté báawéeri áiba irí, yá pìacàatétawa yàatalé ipíchawáise pìaca Dios icàaluíniná. Yá pisutá wenàiwica íicha wawàsi imàacáanápiná iwàwawa íicha yái báawéerica pimàníiricaté irí. Néese píalimá pìaca Dios icàaluíniná matuíbanáiri iyú. Càmicaalí cài pimàni, yá caná iwèni Dios iicáca yái pìanáca icàaluíniná. ");
INSERT INTO pioNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Pisutá píawawa Dios íicha caquialéta imàacáanápiná iwàwawa pibáyawaná íicha, ipíchaná yùuwichàidaca pía. Càmicaalí cài pimàni, yásí Dios ìyaca pirí càide iyúwa piùwide. Péemìa comparación: Piùwide itécaalí pía icháawàacaténá piináwaná ìwali nacuèrinánái irí, yá iwàwacutá pitàaníca yáapicha éeréta àyapulìcubàa. Pisutá íicha wawàsi caquialéta imàacáanápiná iwàwawa pibáyawaná íicha ipíchaná itéca pía juez yàatalé; càmicaalí pisutá íicha cài, yásí juez imàacaca úwinái náibàaca pía, yá úwinái náucapiná píawa presoíyéi ibànalìculé, nacapèedáidacaténá píawa. ");
INSERT INTO pioNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Péemìa cayábani: Canácatáita namusúawa nàuwichàacái íichawa presoíyéi ibàna irìcuíse àta napáyaidacataléta náichawa namawènìacálewa macáita, àta abéeri centavo piná yái centavo namáalàidáaná canánama. Càita nacái càmita píalimá pimusúacawa Dios yàasu yùuwichàacáisi íicha càiripináta”, íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Jesús íimaca: “Pidécuéca péemìaca tàacáisi nacàlidéericaté: ‘Picá piimá áiba wenàiwica yáapicha càmíichúaca píinusíwa, càmíirica nacái pinìrisíwa’, càité náimaca. ");
INSERT INTO pioNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Siùcade quéwa núumacué pirí áibacaalí iicáida inanái irí, yá capicùlecaalíni iwàwacáiná iimáca úapicha, yá idéca imànica ibáyawanáwa úapicha iwàwalìcuísewa, íná cabáyawanáca Dios iicácani. ");
INSERT INTO pioNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","“Iná piwàwacaalí pimànica pibáyawanáwa pituí yéewápuwáiséechúa iyúwa, piicáanápiná wawàsi càmíirica Dios iwàwa piicáca, néese piúca píichawa píiwitáise báawéeriwa, ipíchaná pimànica pibáyawanáwa, càide iyúwa wenàiwica imusúadacaalí íichawa ituíwa, ipíchaná imànica ibáyawanáwa ituí iyúwa. Càita nacái iwàwacutá piúcaca píichawa píiwitáise báawéeriwa, yéewanápiná pidènìaca picáucawa càmíiri imáalàawa, ipíchaná nacái Dios yúucaca pía infierno irìculé, yái manuíri quicháica. ");
INSERT INTO pioNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Càita nacái piwàwacaalí pimànica pibáyawanáwa picáapi yéewápuwáiséechúa iyúwa, néese piúca píichawa píiwitáise báawéeriwa, ipíchaná pimànica pibáyawanáwa, càide iyúwa wenàiwica iwichùacaalí íichawa icáapiwa ipíchaná imànica ibáyawanáwa icáapi iyúwa. Càita nacái iwàwacutá piúcaca píichawa píiwitáise báawéeriwa, yéewanápiná pidènìaca picáucawa càmíiri imáalàawa, ipíchaná nacái Dios yúucaca pía infierno irìculé, yái manuíri quicháica càmíirica ichacàwa càiripinéerita ìyaca”, íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Jesús íimaca: “Pidécuéca péemìaca tàacáisi nacàlidéericaté íiméerica: ‘Aibacaalí iwàwa imàacaca íichawa íinuwa, iwàwacutá yàaca ulí cuyàluta icàlidéerica áibanái irí imàacacaté uèpunícawa íicha’, càité náimaca. ");
INSERT INTO pioNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Quéwa siùcade núumacué pirí càmicaalí uimá áiba asìali yáapicha càmíirica unìrisíwa, càmita yéewa unìri imàacaca íichawa úa. Quéwa yúucacaalí meedá úa, yá imàacaca umànica ubáyawanáwa idàbáanéeri unìri iríwa, uedácaalí ulíwa áiba asìali unìripinácawa àniwa. Aiba asìali yeedácaalí íinupináwa abéechúa náuquéechúami, yá imànica ibáyawaná nacáiwa, iimácáiná áiba asìali íinu yáapicha”, íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Jesús íimaca: “Pidécuéca nacái péemìaca tàacáisi nacàlidéericaté pìawirináimi irí íiméerica: ‘Pimàni macáita machacàníiri iyú càide iyúwa picàlidáaná báisí báisísíwata Dios yáaliéricawa pimàníinápinása’, càité náimaca. ");
INSERT INTO pioNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Quéwa núumacué pirí, picácué píima: ‘Báisí báisísíwata Dios yáaliéricawa’. Picácué nacái cài píimaca capìraléeri cáli íipidená ìwali, Dios ìyacáiná chènuniré. ");
INSERT INTO pioNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Picácué nacái cài píimaca cáli íipidená ìwali, Dios ìyacáiná chái èeri irìcu nacái. Picácué nacái cài píimaca Jerusalén ìyacàlená íipidená ìwali, yácáiná Wacuèriná Dios cachàiníiri yàasu yàcalécani. ");
INSERT INTO pioNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Picácué nacái cài píimaca píiwita ìwaliwa yácáiná abéerita Dios yáaliméeri imàacaca píiwita ibáiná iwènúacawa cúulíiri iyú, cabalèeri iyú áiba. ");
INSERT INTO pioNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Píimacaalícué ‘báisíta’, néese iwàwacutácué báisíca pitàacáica. Píimacaalícué ‘càmita’, néese iwàwacutácué báisíca pitàacáica. Báawéeriquéi píimáanácuéca ‘Báisí báisísíwata Dios yáaliéricawa’ ”, íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Jesús íimaca: “Pidécuéca péemìaca tàacáisi nacàlidéericaté pìawirináimi irí, íiméerica: ‘Cawinácaalí imusúadéerica áiba wenàiwica ituí, iwàwacutácué pimusúadaca ituí, yái imàníirica báawéeri áiba irí, càita nacái cawinácaalí imalèeri áiba iyéi, iwàwacutácué pimalàaca iyéi nacái, yái imàníirica báawéeri áiba irí’, càité náimaca. ");
INSERT INTO pioNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Quéwa siùcade núumacué pirí: Picácué pipélia íipunita cawinácaalícué imàníirica pirí báawéeri. Aiba inúacaalí pinàni ìwali, yá pimàaca inúaca pinàni ìwali abéemàawáise àniwa. ");
INSERT INTO pioNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Aibacaalí iwàwa icháawàaca piináwaná ìwali pimawènìacáinása íicha camisa, yá pimàaca iríni, yái camisaca. Yá pimàaca irí nacái pìasu ruanawa. ");
INSERT INTO pioNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Uwinái nachùulìacaalí pitéca nàasu abéeri kilómetro idècuni, yá pité nàasu pucháiba kilómetro idècuni, nawàwacaalí cài pimànica. ");
INSERT INTO pioNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Cawinácaalí isutéerica píicha wawàsi, pimàaca iríni. Picá piwènúawa íicha cawinácaalí isutéerica pìanápiná ichàba wawàsi. Pìa ichàbani”, íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Jesús íimaca: “Pidécuéca péemìaca tàacáisi áibanái icàlidéericaté pìawirináimi irí, íiméerica: ‘Cáininá piicáca pìacawéeyéináwa. Báawa nacái piicáca piùwidenáiwa’, càité náimaca. ");
INSERT INTO pioNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Quéwa núumacué pirí: Cáininácué nacái piicáca piùwidenáiwa. Pisutácué nalí Dios imàníinápiná nalí cayábéeri, cawinácaalícué ibànuèyéica pìwali chàwicùli. Pimànicué cayábéeri nalí cawinácaalícué báawéeyéica iicáca pía. Pisutácué nalí Dios mamáalàacata cawinácaalícué icháawèeyéica piináwaná ìwali báawanama nachìwa iyúwa, cawinácaalícué nacái imàníiyéica pirí báawéeri nùwalíise, peebáidacáinácué nutàacái. ");
INSERT INTO pioNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Càipiná pimàacacué náalíacawa Wáaniri Dios chènuníiséeri yéenibecuéca pía. Iwàwacutácué pimànica càide iyúwa Dios imàníiná: Dios imàacaca èeri icànaca báawéeyéi ìwali, cayábéeyéi ìwali nacái. Imàaca nacái unía yúuwàacawa nabànacale ìwali, níái imàníiyéica cayábéeri, nía nacái imàníiyéica ibáyawanáwa. ");
INSERT INTO pioNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Cáininácaalícué piicáca níawamita wenàiwica cáininéeyéicuéca iicáca pía, néese Dios càmita imàacacué pirí cawèníiri chènuniré, níacáiná macái èeri mìnanái namànica cài. Nía nacái báawéeyéica íiwitáise yeedéeyéica plata yéenánái íichawa Roma ìyacàlená yàasu gobierno irípiná, cáinináca naicáca cawinácaalí wenàiwica cáininéeyéica iicáca nía. Iná càmitacué máiní cayábéeyéi náicha pía. ");
INSERT INTO pioNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Pitàidacaalícué nacái cayábéeri iyú níawamita péenánáiwa, néese càmitacué pimàni pìyaca cayábéeri wawàsica áibanái íicha, níacáiná macái èeri mìnanái namàni cài. Nía nacái càmíiyéica judío, càmíiyéica yáalía Dios ìwali, nía nacái namànica cài. Iná càmitacué máiní cayábéeyéi náicha pía. ");
INSERT INTO pioNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Báisícaalícué Dios yéenibeca pía, néese iwàwacutácué cayábéeyéi píiwitáise náicha canánama èeri mìnanái. Iwàwacutácué pìyaca càide iyúwa Wáaniri Dios chènuníiséeri ìyáaná, imàníirica cayábéeri nalí canánama, níái cáininéeyéica iicáca Dios, nía nacái càmíiyéica cáininá iicáca Dios”, íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Néeseté Jesús íimaca nalí àniwa, níái yéewáidacaléca: “Picácué píibaida Dios irípiná wenàiwica iicápiná meedá náináidacaténácué pìwali cayábanaméeyéicuéca píiwitáise. Pimànicaalícué cài, néese Wáaniri Dios chènuníiséeri càmita yàapiná pirícué pìasu cawèníiri chènuniré, canásíwa. ");
INSERT INTO pioNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Iná piyúudàacué catúulécanéeyéi, quéwa picácué picàlida áibanái irí ìwali yái pimàníináca. Aibanái pucháibéeyéi íiwitáise nacàlidaca naináwanáwa manùbéeyéi wenàiwica yàacuésemi, náimaca nadécasa nayúudàaca catúulécanéeyéi. Aibanái nacái nabàlùacawa bàacháwalé, yá nàaca plata catúulécanéeyéi irí macái wenàiwica iicápiná, yéewacaténá wenàiwicanái icàlidaca naináwaná cayábéeri iyú. Péemìacué cayábani, cawinácaalí imàníiyéica cài, èeri mìnanái nacàlidapiná naináwaná ìwali cayábéeri tàacáisi iyú, quéwa Dios càmita imàacapiná nalí báisíiri cawèníirica ìyéerica chènuniré. ");
INSERT INTO pioNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Néese píacué nuéwáidacaléca, piyúudàacué catúulécanéeyéi, quéwa picácué picàlida áibanái iríni, ibatàa irípiná yái pìacawéerináca cayábéeri náicha canánama, picácué picàlida iríni. ");
INSERT INTO pioNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Piyúudàacué catúulécanéeyéi ibàacanéeri iyú. Yásí Wáaniri Dios, yái iiquéerica càinácaalícué pimàníináca ibàacanéeri iyú, imàacapinácué pirí pìasu cawèníiri pìanàacaalípiná chènuniré”, íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Jesús íimaca: “Pisutácué píawawa Dios íicha, quéwa picácué pimàni càide iyúwa pucháibéeyéi íiwitáise imàníiná. Nawàwa wenàiwicanái iicáca nía meedá idècunitàacá nasutáca Dios íicha. Iná máiní nawàwa nabàlùacawa manùbéeyéi yàacuésemi judíonái yéewáidacàalu irìcu, bàacháwalé nacái wenàiwicanái yàacuésemi nasutácaténáwa Dios íicha wenàiwicanái iicápiná meedá. Péemìacué cayába, cawinácaalí imàníiyéica cài, èeri mìnanái nacàlidapiná naináwaná ìwali cayábéeri tàacáisi iyú quéwa Dios càmita imàacapiná nalí báisíiri cawèníirica ìyéerica chènuniré. ");
INSERT INTO pioNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Néese pisutá píawawa Dios íicha, quéwa piwàlùawa picapèe imàdáaná irìculéwa, yá pibàlìa inùma, néese pisutá píawawa Wáaniri Dios íicha ìyéerica píapicha néré. Néese Wáaniri Dios yái iiquéerica macáita pimàníirica ibàacanéeri iyú, yàapiná pirí pìasu cawèníiri chènuniré. ");
INSERT INTO pioNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Pisutá Dios íicha, quéwa picá píima canéeri iwèni tàacáisi madécaná yàawiría càide iyúwa càmíiyéi judío imàníiná càmíiyéica yáalía Dios ìwali, nía nacái iyúunáidéeyéica Dios yéemìaca nalí nasutácáiná íicha déecuíri iyú. ");
INSERT INTO pioNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Picácué píináidawa cài, Dios yáalíacáináwa pìwalicué càinácaalí pimáapuèrica ipíchawáise pisutácuéca íichani. ");
INSERT INTO pioNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Iwàwacutácué pisutáca Dios cài: ‘Pía, Wáaniri Dios chènuníiséeri, pimàaca macái wenàiwica yàaca picàaluíniná. ");
INSERT INTO pioNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Pimàaca péenáiwaná yàanàaca caquialéta yái èerica pidàbacatáipináta picùaca macáita. Pimàaca èeri mìnanái namànica càide iyúwa piwàwáaná chái èeri irìcu càide iyúwa neebáidáaná pitàacái, níara ìyéeyéica chènuniré. ");
INSERT INTO pioNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Pìa wayáapiná wamáapuèrica siùcade. ");
INSERT INTO pioNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Pimàaca piwàwawa wabáyawaná íicha, yái báawéerica wamàníirica càide iyúwa wamàacáaná wawàwawa nabáyawaná íicha cawinácaalí imàníiyéica walí báawéeri. ");
INSERT INTO pioNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Picá pimàaca áibanái yáalimáidaca wía ipíchaná wamànica wabáyawanáwa, néese piwasàa wía báawéeri Satanás íicha. Píacáiná icuèripináca macáita, pía cachàiníirica íiwitáise náicha canánama, icànéerica mèlumèluíri iyú càiripináta. Báisíta, amén’, cài pisutácué píawawa Dios íicha. ");
INSERT INTO pioNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Pimàacacaalícué piwàwawa nabáyawaná íicha cawinácaalícué imàníiyéica pirí báawéeri, néese Wáaniri Dios chènuníiséeri imàacapinácué iwàwawa pibáyawaná íichawa. ");
INSERT INTO pioNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Quéwa, càmicaalícué pimàaca piwàwawa áibanái ibáyawaná íicha, néese càmitacué nacái Wáaniri Dios imàacapiná iwàwawa pibáyawaná íicha”, íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Jesús íimaca: “Pimàacacaalícué píichawa piyáacaléwa pisutácaténácué píawawa Dios íicha manuísíwata, picácué cáimiétaquéeri iyú pimànica píawawa wenàiwica iicápiná meedá càide iyúwa pucháibéeyéi íiwitáise imàníiná. Nawàwa áibanái wenàiwica naicáca nía cáimiétaquéeri iyú, íná cáimiétaquéeri iyú namànica níawawa wenàiwica iicápiná meedá yéewacaténá macáita náalíacawa namàacaca náichawa nayáacaléwa nasutácaténá níawawa Dios íicha. Péemìacué cayábani, cawinácaalí imàníiyéica cài, èeri mìnanái nacàlidapiná naináwaná ìwali cayábéeri tàacáisi iyú quéwa Dios càmita imàacapiná nalí báisíiri cawèníirica ìyéerica chènuniré. ");
INSERT INTO pioNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Quéwa pía pimàacacaalí píichawa piyáacaléwa pisutácaténá píawawa Dios íicha manuísíwata, yá pipìa cayába píiwita ibáináwa aceite iyú, píiba nacái pinàniwa. ");
INSERT INTO pioNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Càita pimàni, ipíchaná áibanái náalíacawa pimàacaca píichawa piyáacaléwa pisutácaténá píawawa Dios íicha. Abéerita Wáaniri Dios, yái ìyéerica píapicha, yáalíacawa pimàacaca píichawa piyáacaléwa, íná Dios yàapiná pirí pìasu cawèníiri chènuniré”, íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Jesús íimaca: “Picácué pìwacáida piríwa manùba cawèníiri wawàsi chái èeri irìcu. Cuwée iyáaca meedá cawèníiri bàlesi. Aiba wawàsi nacái namáalàacáitacué píichawa. Cayéedéeyéi nacái nawàlùacawa needácaténácué píichani. ");
INSERT INTO pioNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Cayába cachàini pirícuéni pimàníinácuéca càide iyúwa Dios iwàwáaná pidènìacaténácué pìasu báisíiri cawèníiriwa ìyéerica chènuniré, aléera càmicatalé cuwée iyáacué píichani, càmicatalé nacái cawèníiri imáalàawa, càmita nacái cayéedéeri iwàlùawa néré. ");
INSERT INTO pioNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Pimàacacaalícué piwàwawa pìasu ìwaliwa chái èeri irìcuírica, yásí píináidapinácuécawa ìwali mamáalàacata. Quéwa piicácaalícué iyúwa cawèníiri yái cayábéeri wawàsica Dios yèeripinácuéca piríwa chènuniré áiba èeriwa, yásí píináidapinácuécawa ìwali mamáalàacata. Iná pimànicué càide iyúwa Dios iwàwáaná peedácaténácué piríwani yái cawèníirica ìyéerica chènuniré. Càita píináidapinácuécawa ìwali mamáalàacata”, íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Jesús íimaca: “Pituí ìyaca pirí càide iyúwa lámpara pituícáiná imàacaca piicáca. Cayábacaalí pituí, yásí amalánamaca piicáca. ");
INSERT INTO pioNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Quéwa báawacaalí pituí, yásí catáca piicáidaca. Néese yái píináidéericawa piwàwalìcuísewa ìyaca càide iyúwa catuíri íiwitáise. Iná picùa cayába piwàwawa masaquèeri iyú, picá cáininá piicáca áiba wawàsi Dios íicha, ipíchaná catáca píiwitáise. Néese báawacaalí píiwitáise, yái píináidéericawa piwàwalìcuísewa, yásí ¡máiní catáca píiwitáise báawanama! Càmita píalíapiná cayábéeri ìwali báawéeri íichaná”, íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Jesús íimaca: “Péemìacué comparación: Canácata wenàiwica yáaliméeri imànica machacàníiri iyú càide iyúwa íiwacanánái pucháiba ichùulìaná imànica, báawacáiná iicáca abéeri íiwacaliwa, cáinináta quéwa iicáca íiwacaliwa áiba. Càmicaalí nacái, néese yàapiná íiwacali áiba icàaluínináwa, quéwa caná iwèni meedá iicápiná íiwacali áibawa. Càita nacái càmitacué pidé píibaidaca cayába Píiwacali Dios irípináwa càide iyúwa iwàwáaná cáininácaalícué piicáca plata”, íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Jesús íimaca: “Péemìacué cayábani: Picácué achúma píináidáanícawa piwàwawa càinácaalícué iyú yéewanápiná peedáca piyáacaléwa, pìyacaténácué, càinácaalícué iyú yéewanápiná nacái peedáca pibàlepináwa, pìwalicaténácué pibàlewa. Máiníiri cawènica wacáuca yàacàsi íicha. Wainá nacái máiníiri cawènica bàlesi íicha. Dios idéca yàaca wacáuca, wainá nacái cawèníiri, íná wáalíacawa yàanápiná walí yái càmíirica máiní cawènica chái èeri irìcu, yái yàacàsica, yái bàlesica nacái. ");
INSERT INTO pioNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Piicáidacué nacái nalí, níái màsibèe yáaléeyéicawa chènunibàa. Càmita nabàna nabànacalewa. Càmita nacái needá nabànacalewa. Canáca nacái nacapèe nadènìacatalépiná nabànacale ìyacanáwa. Quéwa Wáaniri Dios chènuníiséeri yàaca nayáacalépiná. Néeni, ¡máinícuéca cawèníiyéica pía náicha níái màsibèeca! Iná iwàwacutácué píalíacawa Dios icùanácué pía nacái. ");
INSERT INTO pioNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Néese, éwitacué píináidáanícaalíwa piwàwawa báawanama, càicáaníta càmitacué píalimá cáala pimànicuéca picáucawa pidènièrica pìyacaténácué mamáalàacata chái èeri irìcu, ibatàa abéeri horapiná càmitacué píalimá cài. Càmicáinácué píalimá pimànica càiri achúméeri wawàsi, ínácué canéeri iwèni meedá píináidáaníinácawa piwàwawa báawanama yàacàsi ìwali, bàlesi nacái. ");
INSERT INTO pioNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“¿Cánácué píináidawa piwàwawa mamáalàacata ìwali càinácaalícué iyú yéewanápiná peedáca pibàlepináwa? Piicáidacué càinácaalí iyú íiwinási nadàwinàacawa manacúalibàa: càmita náibaida, càmita nacái needá sáawáli namàníiripiná nabàlewa. ");
INSERT INTO pioNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Quéwa núumacué pirí nadènìaca náiwináwa cayábéeri iicácanáwa rey Salomón ibàle íicha, éwitaté máinícáaníta càasuca Salomón. ");
INSERT INTO pioNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Dios idéca imàacaca masicái ibàlepiná cayábéeri iicácanáwa, éwita masicái nàyacáaníta maléená èeri meedá manacúalibàa, néese táwicha, yá wenàiwica neemácani quichái iyú. Dios imànica cayábéeri irí yái masicái waiquéerica iyúwa canéeri iwèni, íná iwàwacutácué píalíacawa Dios icùanácué píawa nacái. ¿Cánácué càmita manuí píináidacawa piwàwawa Dios ìwali icùanápinácué pía? ");
INSERT INTO pioNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Iná picácué píináidawa piwàwawa mamáalàacata. Picácué cài pisutá péemìawa píawáaca: ‘¿Cawiná wayáa? ¿Cawiná wabàle wàwalíiripiná?’ picácué píima. ");
INSERT INTO pioNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Macái èeri mìnanái càmíiyéica yáalía Dios ìwali, achúmaca náináidáanícawa nawàwawa nàwali macáita yái wawàsica. Quéwa pidènìacué Wáaniri Dios chènuníiséeri yáaliéricawa càiríinácaalícué wawàsi pimáapuèrica. ");
INSERT INTO pioNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Iná píalimáidacué pimànica càide iyúwacué Dios ichùulìaná pimànica macái pichàini iyúwa, yásí Dios imàacacué pirí macáita yái pimáapuèrica. ");
INSERT INTO pioNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Siùca èeri, picácué achúma píináidáaníwa piwàwawa mamáalàacata pipíchaléwa, táwichacáiná pidènìacué áiba èeri píináidáanápináwa táwichéeri wawàsi ìwali. Macái èeri idènìaca yàasu wawàsi càulenéeriwa”, íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Néeseté Jesús íimaca yéewáidacalénái iríwa: “Picácué máiní picháawàa áibanái iináwaná ìwali mamáalàacata ipíchanácué Dios yùuwichàidaca pía. ");
INSERT INTO pioNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Piwàwacaalícué piùwichàidaca áibanái caquialéta manuísíwata, yásí Dios yùuwichàidacué píawa manuísíwata. Néese piicácaalícué áibanái ipualé, yásí Dios iicácué pipualé nacái. ");
INSERT INTO pioNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Pía idènièrica ibáyawaná manuíriwa, picá píináidawa máiní cayábaca pía áiba wenàiwica íicha idènièrica ibáyawanáwa achúméeri meedá. Péemìacué comparación: Pibáyawaná manuíri, càicanide iyúwa manuíri àicu idéca nacáicaalí yúuwàacawa pituí irìculé. Néese áiba achúméeríwanái ibáyawaná, càicanide iyúwa imuluísi achúméeri yúuwàacaalíwa ituí irìculé. ");
INSERT INTO pioNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Càmicáiná píalíawa cabáyawanáca pía manuísíwata, íná canáca yéewaná báawaca piicáca píichawa áiba wenàiwica idènièrica ibáyawanáwa achúméeri meedá. Péemìacué comparación: Manuíri àicu yúuwàacaalíwa pituí irìculétá, yá càmita pidé piicáca cayába pimusúadacaténá imuluísi áiba wenàiwica ituí irìcuísetá. Càita nacái cabáyawanácaalí pía, picá píima áiba wenàiwica irí: ‘Nuénásàiri, pimàaca nucàlidaca pirí pibáyawaná ìwali, nuyúudàacaténá pimàacaca píichawani’, picá cài píimaca irí. ");
INSERT INTO pioNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Píacáiná pucháibaca píiwitáise pìyaca. ¡Pidéca piimáichaca meedá pibáyawanáwa! Iwàwacutá pimàacaca píichawa quéechacáwa yái pibáyawanáwa manuírica. Yásí pidéca pìalàaca áiba wenàiwica imàacáanápiná íichawa ibáyawaná achúméeriwa”, íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Picácué picàlida mamáalàacata Dios itàacái mabáyawanéeri áibanái irí áuli nacáiyéi íiwitáise máiníiyéica báawaca iicáca Dios. Péemìacué comparación: Wàacaalí cayábéeri wawàsi áulinái irí, yásí nawènúa naamíaca wía, namàdáida nacái wainá. Wáucacaalí nacái perla cawèníiri íba marranonái irí, yásí nabawàida meedáni nàabàli yáapiréwa. Càita nacái, picácué picàlida mamáalàacata mabáyawanéeri Dios itàacái áuli nacáiyéi íiwitáise irí, marrano nacáiyéi íiwitáise nacái, níara wenàiwica máiníiyéica báawaca iicáca Dios, casaquèeyéica íiwitáise nacái, ipíchanácué máiní calúaca nía píapicha, néese namànicuéca pirí báawéeri”, íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Jesús íimaca: “Pisutácué píawawa mamáalàacata Dios íicha, yásí imànicuéca piríwani. Péemìacué comparación: Picutácué mamáalàacatani, yásí pìanàacuécani. Pimáidacué mamáalàacata capìi inùma néeni, yásí yàacùacuéca piríwani. ");
INSERT INTO pioNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Yácáiná cawinácaalí isutéerica mamáalàacata, yeedápináca iríwani. Cawinácaalí icutéerica mamáalàacatani, yàanàapinácani. Cawinácaalí imáidéerica mamáalàacata capìi inùma néeni, nàacùaca irí capìi inùma. Càita nacái cawinácaalí wenàiwica isutéerica mamáalàacata Dios íicha, Dios imànipiná iríwa càide iyúwa isutáaná. ");
INSERT INTO pioNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“Péemìacué comparación: Pidènìacaalícué pìiriwa, càmitacué pìa irí íba isutácaalí píicha pan iyáapináwa. ");
INSERT INTO pioNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Càmitacué pìa iyáapiná àapi isutácaalí píicha cubái. ");
INSERT INTO pioNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Ewitacué báawéeyéicáaníta íiwitáiseca pía, càicáaníta cáininácuéca piicáca péenibewa, píalimácué nacái pìaca nalí cayábéeri wawàsi. Néeni, ¿càmitasicué píalíawa cayábéeri íiwitáise yái Wáaniri Dios chènuníiséerica? ¡Iná iwàwacutácué píalíacawa Dios imàníinápinácué pirí cayábéeri, pisutácaalícué íicha mamáalàacata! ");
INSERT INTO pioNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Iná pimànicué áibanái irí cayábéeri càide iyúwa piwàwáaná namànica pirícué cayábéeri. Pimànicaalícué cài, yásí pimànipinácué machacàníiri iyú càide iyúwaté profeta Moisés ichùulìaná pìawirináimi Dios inùmalìcuíse, càide iyúwaté nacái profetanái natànàaná tàacáisi Dios inùmalìcuíse”, íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Néeseté Jesús íimaca nalí: “Píalimáidacué macái pichàini iyúwa peebáidacaténá nulí yéewacaténá nùasu wenàiwicacuéca pía. Càulenáca wenàiwica neebáidaca nutàacái, nawàlùacaténáwa Dios ìyacàle irìculé, càide iyúwa càulenácaalí nawàlùacawa máucuíri capìi inùma irìcubàa. Yácáiná èeri mìnanái íiwitáise báawéeri ìyaca càide iyúwa cáucuíri capìi inùma, cáucuíri àyapu nacái, màulenácatalé manùbéeyéi wenàiwica nàacawa irìcubàa. Quéwa èeri mìnanái íiwitáise báawéeri itéca wenàiwica yéetácáisi irìculé, aléera infierno irìculé. Màulenáca nàyaca càide iyúwa èeri mìnanái íiwitáise ìyáaná chái èeri irìcu, íná yéewa manùbéeyéi nàyaca èeri mìnanái íiwitáise ìwali càide iyúwa manùbéeyéi nawàlùacaalíwa cáucuíri capìi inùma irìcubàa, cáucuíri àyapu nacái. ");
INSERT INTO pioNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Quéwa càica núade iyúwa capìi inùma máucuíri. Nutàacái nacái càicanide iyúwa máucuíri àyapu, máinícáiná càulenáca neebáidaca nulí, càulenáca nacái nàyaca càide iyúwa núumáaná nawàlùacaténáwa Dios ìyacàle irìculé. Iná càmita máiní madécaná yàawa néré”, íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Néeseté Jesús íimaca nalí àniwa: “Picácué píichawa áibanái cachìwéeyéica. Náimaca nàwaliwa nacàlidacasa tàacáisi Dios inùmalìcuíse. Càica níade iyúwa caluéyéi cuwèesi lobo ìwalíiyéica oveja íimamimi nachìwáidacaténá ovejanái nanúacaténá níái ovejaca. Níái cachìwéeyéica natàaníca càide iyúwacué pitàaníiná nawàlùacaténácuéwa pèewiré, nawàwacáiná naméeràidacuéca pía Dios íicha, namáalàidacaténácué pía. ");
INSERT INTO pioNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Píalimápinácué píalíacawa cachìwéeyéica nía piicácaalícué càinácaalí namànica. Péemìacué comparación: Wáalíacawa macái àicu ìwali waicácaalí ìyacaná, cayábéericaalíni, càmicaalí nacái, néese báawéericani. Càmita weedá cayábéeri uva ìyacaná áwa yúuba íicha. Càmita nacái weedá cayábéeri higuera ìyacaná tuíri íicha. ");
INSERT INTO pioNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Macái cayábéeri àicu idènìaca ìyacanáwa cayábéeriwa, yá nacái macái báawéeri àicu idènìaca ìyacanáwa báawéerita nacái. ");
INSERT INTO pioNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Canáca cayábéeri àicu yáaliméeri idènìaca ìyacanáwa báawéeri. Canáca nacái báawéeri àicu yáaliméeri idènìaca ìyacanáwa cayábéeri. Càita nacái píalimácué píalíacawa báawaca náiwitáise, níara cachìwéeyéica, piicácáinácué càinácaalí namànica. ");
INSERT INTO pioNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Càide iyúwa wàucacaalí macái àicu canéeyéica irí ìyacaná cayába, weemácaténá nía quichái irìcu, càita nacái Dios yùuwichàidapiná nía quichái irìcu cawinácaalí wenàiwica càmíiyéica imàni cayábéeri càide iyúwa Dios iwàwáaná. ");
INSERT INTO pioNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Càitacué píalimápiná píalíacawa báawaca náiwitáise, níara cachìwéeyéica, piicácáinácué càinácaalí namànica”, íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Jesús íimaca: “Madécaná wenàiwica náimaca nulí: ‘Wáiwacali’, quéwa càmita macáita nawàlùapináwa Dios ìyacàle irìculé Dios icùacatalé macáita chènuniré. Cawinácaalí wenàiwica imàníiyéica càide iyúwa Núaniri Dios chènuníiséeri iwàwáaná níawamita yáalimápiná iwàlùacawa néré. ");
INSERT INTO pioNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Imáalàacaalípináwa yái èeriquéi, yá madécaná náimapiná nulí: ‘Wáiwacali, wacàlidacaté nalí pitàacái. Wáucacaté demonio wenàiwica íicha píipidená ìwali. Wamànicaté nacái píipidená ìwali madécaná wawàsi càmíiri wenàiwica idé imànica’, càipiná náimaca nulí. ");
INSERT INTO pioNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Quéwa núumapiná nalí: ‘Càmita núalíacué nuicáca pía. Pìacuéwa nuícha, píacué imàníiyéica ibáyawanáwa’, càipiná núumaca nalí”, íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Jesús íimaca: “Péemìacué comparación: Cawinácaalí wenàiwica yéemièrica nutàacái, imànicaalí nacái càide iyúwa núumáaná, yái wenàiwica ìyaca càide iyúwa cáalíacáiri asìali imàníirica icapèewa. Quéechacáwa íicaca depuíwalé. Yá asìali yàanàaca manuíri íba ìyéerica depuíwalé cáli irìcu ibàlùadacaténá icapèewa íinata. Yá imànica icapèewa íba íinata. ");
INSERT INTO pioNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Néese unía yúuwàacawa àta inanába yéesacatalétawa. Yá yéesacái yàacawa cachàiníiri iyú capìi ìwali, yá cachàiníiri cáuli ipùaca ìwali yái capìica. Càmíiri quéwa yúuwàawa yái capìica ibàlùacáináwa íba íinata. Càide iyúwa capìi ibàlùacaalíwa mamáalàacata, càita nacái cawinácaalí wenàiwica yeebáidéeyéica nutàacái nadènìapiná nacáucawa càmíiri imáalàawa. ");
INSERT INTO pioNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Néese cawinácaalí yéemièrica nutàacái, quéwa càmita imàni càide iyúwa núumáaná, yá càicanide iyúwa máiwitáiséeri wenàiwica imàníirica icapèewa càina íinata meedá. ");
INSERT INTO pioNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Yá unía yúuwàacawa. Néese inanába yéesacawa, yá yéesacái yàacawa cachàiníiri iyú capìi ìwali, yá cachàiníiri cáuli ipùaca ìwali yái capìica. Néese yúuwàacawa yái capìica, yá imáalàacawa macáita. Càide iyúwa capìi imáalàacaalíwa, càita nacái cawinácaalí wenàiwica càmíiyéica yeebáida nutàacái, canáca nacáuca càmíiri imáalàawa”, íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Idécanáamité Jesús imáalàidaca icàlidaca nalíni, yá macáita wenàiwica ìyéeyéica néeni náináidacawa néemìaca itàacái manuísíwata yéewáidacáiná nía cáalíacáiri iyú. ");
INSERT INTO pioNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Jesús yéewáidacáiná nía càide iyúwa wenàiwica idènièrica Dios íiwitáise icàlidacaténá tàacáisi Dios inùmalìcuíse. Càmita yéewáida nía càide iyúwa néewáidáaná, níara yéewáidéeyéica wenàiwica templo irìcu Dios itàacái ìwali, yái tàacáisi profeta Moisés itànèericaté. ");
INSERT INTO pioNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Jesús iricùacatéwa dúli íinatáise, yá madécaná wenàiwica yàacawa yáapicha. ");
INSERT INTO pioNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Néese abéeri asìali cacháunéeri íimami lepra iyú yàacawa Jesús yàatalé. Yá ibàlùacawa yùuluì ipùata iyúwa Jesús irí yàacaténá Jesús icàaluíniná, yéewacaténá catúulécanáca Jesús iicácani. Yá íimaca Jesús irí: —‍Nuíwacali, núalíacawa píalimá pichùnìaca núa, piwàwacaalí quéwa pichùnìaca núa —‍íimaca. ");
INSERT INTO pioNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Néese Jesús imàacaca icáapiwa cacháunéeri ìwali. Jesús íimaca irí: —‍Nuwàwaca nuchùnìaca pía. ¡Cayábaca píawa! —‍íimaca yái Jesúsca. Yáta icháuná lepra yáawacawa íicha. ");
INSERT INTO pioNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Jesús íimaca irí: —‍Péemìa cayába. Picá picàlida áibanái iríni, nuchùnìaná pía. Néese pìawa caquialéta sacerdote yàatalé píasáidacaténá iicá píimamiwa, yáalíacaténáwa cayábaca pía picháuná íichawa. Pité nacái ofrenda profeta Moisés ichùulièricaté wenàiwica namàacáanápiná Dios irí nachùnìacaalíwa lepra íicha, yéewacaténá macái wenàiwica yáalíacawa cayábaca pía —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Néeseté Jesús iwàlùacawa Capernaum ìyacàlená irìculé, yá abéeri romanonái yàasu úwi íiwacaliná yàacawa Jesús yàatalé isutácaténá Jesús íicha wawàsi imàníinápiná irí cayábéeri. ");
INSERT INTO pioNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Yá íimaca Jesús irí: —‍Nuíwacali, nùasu wenàiwica irìawa nucapèe irìcu. Càmíiri yéewa imichàanícawa. Yùuwichàacawa manuísíwata cáiwíiri iyú —‍íimaca. ");
INSERT INTO pioNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Jesús íimaca irí: —‍Uwé, wàawa. Nuchùnìacaténáni —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Quéwa úwi íiwacaliná íimaca Jesús irí: —‍Nuíwacali, canáca yéewanáwa nuedáca nùataléwa pía, máinícáiná cayábéerica nuícha pía, íná báica nuicáca núawawa piwéré. Pichùulìacáita ichùnìanápináwa pitàacái iyúwa, yáara nùasu wenàiwicaca, yásí ichùnìacawa. ");
INSERT INTO pioNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Núalíacawa píalimá pichùnìacani pitàacái iyúwa, níacáiná nuíwacanánái nachùulìa nacái núa. Núa nacái nuchùulìa nùasu úwináiwa. Nuchùulìacaalí abéeri yèepùacawa, yáta yèepùacawa. Numáidacaalí abéeri, yáta yàanàaca. Nuchùulìacaalí àniwa nùasu wenàiwicawa imàníinápiná áiba wawàsi, yáta imànicani. Iná yéewa núalíacawa píalimá pichùnìaca nùasu wenàiwica nacái pitàacái iyúwa —‍íimaca. ");
INSERT INTO pioNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Idécanáami Jesús yéemìacani, yá cayábaca íináidacawa yéemìaca úwi íiwacaliná itàacái. Néese Jesús iwènúacawa, yá íimaca nalí, níái wenàiwicaca yèeyéicawa yáamiwáise: —‍Péemìacué cayábani, canácata nùanèeri càirica yeebáidéeri nulí manuísíwata, ibatàa Israel itaquénáinámi yéenápináta, càmitàacá nùanàa càiri. ");
INSERT INTO pioNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Núumacué nacái pirí, manùbaca áibanái wenàiwica íiwitáaná nàanàapiná áiba cáli néese. Nàwacáidáyacacawa nawàlùacaténáwa Dios ìyacàle irìculé icùacataléca macáita chènuniré. Néré nàyapináca pìawirináimicué yáapichawa, níái Abraham, Isaac nacái, Jacob nacái. ");
INSERT INTO pioNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Píatacué quéwa, Dios imáidéeyéicaté quéechatécáwa, càmitacué pìyapiná Dios yáapicha chènuniré, éwitacué Abraham itaquénáinámicáanítacué pía, càmicáinácué peebáida nulí. Dios yúucacué íichawa píawa catácatalé. Néré píicháanípinácuéca, piamíapinácuéca piyéiwa piùwichàacái iyúwa —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Néese Jesús íimaca úwi íiwacaliná irí: —‍Pèepùa picapèe néréwa, yácáiná idéca ichùnìacawa pìasu wenàiwicaca iyúwa peebáidáaná nulí —‍íimaca yái Jesúsca. Yáta idéca cayábacani, yái úwi íiwacaliná yàasu wenàiwicaca. ");
INSERT INTO pioNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Néeseté Jesús yàacawa Pedro icapèe irìculé. Iicáca néré Pedro iyéeru iculuéchúawa mecuní iyú, irièchúawa yàalubái íinatawa. ");
INSERT INTO pioNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Iná Jesús imàacaca icáapiwa ucáapi ìwali, yáta mecuní ichàbacawa uícha. Yá umichàacawa, udàbaca ùaca nayáapiná. ");
INSERT INTO pioNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Néeseté catácaalí yàacawa, yáta yàcalé mìnanái natéca néenánáiwa Jesús yàatalé, manùbéeyéi wenàiwica demonio idacuèyéica íiwitáise. Jesús ichùulìacáita demonionái abéeri palabra iyú nàanápináwa wenàiwica íicha. Càita Jesús yúucaca demonio wenàiwica íicha. Ichùnìaca nacái macáita níái cáuláiquéeyéica. ");
INSERT INTO pioNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Iná Jesús imànica càide iyúwaté profeta Isaías icàlidáanáté tàacáisi Dios inùmalìcuíse. Isaías íimacaté Dios yàasu wenàiwica ìwali: “Ichùnìaca wía, wía machawàaquéeyéica, yeedáca wáicha uláicái”, íimacaté yái profeta Isaíasca. ");
INSERT INTO pioNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Néeseté Jesús iicáca manùbéeyéi wenàiwica ìwacáidáyaquéeyéicawa itéese, íná ichùulìaca yéewáidacalénáiwa itéenápináni Galilea icalìsaniná abéemàalé barca irìcu. ");
INSERT INTO pioNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ipíchawáiseté nawàlùacawa barca irìculé, abéeri yéewáidéeri wenàiwica templo irìcu yàacawa Jesús yàatalé. Yá íimaca Jesús irí: —‍Pía, yéewáidéerica wía, nuwàwa nùacawa píapicha àta alénácaalí pìawa yéewacaténá péewáidacaléca núa —‍íimaca yái wenàiwicaca. ");
INSERT INTO pioNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Néese Jesús íimaca irí: —‍Píináidawa cayába quéechacáwa asáisí píalimácaalí nuéwáidacaléca pía, càulenácáiná wenàiwica nàyaca càide iyúwa nùyáaná. Péemìa comparación: Yàlidunái idènìaca ibànawa, cuìpìranái nacái nadènìaca namùlubèwa, núacata quéwa, yái asìali Dios néeséerica, càmita nudènìa nuimácatáipináwa —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Néese áiba néená, níái Jesús yéewáidacaléca, íimaca Jesús irí: —‍Nuíwacali, pimàaca nùyaca nuénánái yáapichawa àta núaniri yéetácatalépinátawa, néese idécanáami nubàlìacani, yásí nùacawa píapicha iyúwa péewáidacalé —‍íimaca irí. ");
INSERT INTO pioNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Néese Jesús íimaca irí: —‍Pìawa núapicha iyúwa nuéwáidacalé. Pimàaca nabàlìaca níawáacata, cawinácaalí ìyéeyéica matuíbanáita Dios íicha càide iyúwa yéetáními —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Néeseté Jesús iwàlùacawa barca irìculé yéewáidacalénái yáapichawa. Yá nadàbaca nàacawa abéemàalé Galilea icalìsaniná íicha. ");
INSERT INTO pioNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Jesús iimáca íichawa barca irìcu. Yáta manuíri cáuli idàbaca ipùaca calìsa ìwali. Máiníiri cachàinica yái cáulica. Màladàca nacái yúuwàacawa barca irìculé, yá úni ipuníadaca yàacawa barca. Quéwa Jesús iimáca mamáalàacata. ");
INSERT INTO pioNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Iná yéewáidacalénái nacawàidacani, yái Jesúsca, yá náimaca irí: —‍¡Wáiwacali, piyúudàa wía! ¡Wasawíaca wàacawa! —‍náimaca Jesús irí. ");
INSERT INTO pioNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Néese Jesús íimaca nalí: —‍¿Cánácué máiní cáaluca pía? ¿Cánácué càmita manuí píináidacawa piwàwawa nùwali? —‍íimaca nalí. Idécanáami icàlidaca nalíni, yá ibàlùacawa, ichùulìaca cáuli, màladàca nacái wiúnápináni. Yá wiúca macáita màladàca. ");
INSERT INTO pioNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Néese níái yéewáidacaléca náináidacawa manuísíwata naicáidaca irí. Yá nasutáca néemìawa níawáaca. Náimaca: —‍¿Cawinásica yái asìalica ichùulièrica cáuli, màladàca nacái, yásí neebáidaca càide iyúwa ichùulìaná nía? —‍náimaca nalíwáaca. ");
INSERT INTO pioNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Néeseté Jesús yàanàaca abéemàalé Galilea icalìsaniná íicha, Gadara yàasu cáli néré, yéewáidacalénái yáapichawa. Idécanáami yàanàaca néré, yá pucháiba asìanái demonio idacuèyéi íiwitáise nàacawa yéetáními icàliculèená néese. Máiníiyéi calúaca nía iyúwa caluéyéi cuwèesi, càmita nabatàa áiba wenàiwica ichàbacawa néenibàa àyapulìcubàa. Yá nàacawa Jesús yàatalé. ");
INSERT INTO pioNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Yá demonionái nadàbaca néemíanícawa asìanái isàna iyú: —‍¡Picá pisàiwica walí wawàsi, Jesús, yái Dios Iirica! ¿Pìanàasica piùwichàidacaténá wía ipíchawáise wéenáiwaná yàanàaca? —‍náimaca. ");
INSERT INTO pioNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Mawiénita nalí manùbéeyéi marranonái yèepuníwa. Nayáaca nèepunícawa nayáacaléwa néenibàa. ");
INSERT INTO pioNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Néese demonionái nasutáca Jesús íicha wawàsi. Náimaca: —‍Piúcacaalí wía asìanái íicha, yá pimàaca wàacawa marranonái idèerìculé —‍náimaca. ");
INSERT INTO pioNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Jesús íimaca nalí: —‍Pìacuéwa —‍íimaca yái Jesúsca. Yá demonionái yàacawa asìanái íicha, yá nawàlùacawa marranonái idèerìculé. Yáta macáita marranonái nadàbaca napìacawa iyúwa máiwitáiséeyéi demonio íiwitáise iyú. Napìacawa nacaláacawa quìratàli íinatáise. Yá nacaláacawa calìsa yáaculé, nàisicùmacawa macáita, níái pìráica càmíiyéica Dios imàaca wadènìaca, wía judíoca, casacàacáiná walí marrano iiná. ");
INSERT INTO pioNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Néese níái icuèyéicaté marranonáimi napìacawa yàcalé nérépiná. Nàanàacaté néré, yá nadàbaca nacàlidaca yàcalé mìnanái iríni, macáita yái nàyáanáca, níái asìanái demonio idacuèyéicaté íiwitáise. ");
INSERT INTO pioNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Iná macáita yàcalé mìnanái namusúacawa yàcalé íicha, yá nàacawa Jesús yàatalé. Naicácani, yá nasutáca Jesús íicha wawàsi manuísíwata yèepùanápináwa nàasu cáli íicha. ");
INSERT INTO pioNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Néeseté, Jesús iwàlùacawa barca irìculé yéewáidacalénái yáapichawa, yá nachàbacawa abéemàalé Galilea icalìsaniná íicha. Yá nàanàaca Capernaum ìyacàlená néré, yái Jesús ìyacàleca. ");
INSERT INTO pioNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Yá abénaméeyéi wenàiwica natéca cáuláiquéeri asìali Jesús yàatalé, abéeri máapinéeri iiná macáita, càmíirica yáalimá imichàanícawa, irièricawa yàalubái íinatawa, iiméerica íinata. Néese Jesús yáalíacáiná náiwitáise manuíca náináidacawa nawàwawa Jesús ìwali ichùnìanápináni, íná Jesús íimaca cáuláiquéeri irí: —‍Pía, nùacawéerináca, picá achúma piwàwa. Nudéca numàacaca nuwàwawa pibáyawaná íicha cayábacaténá píapicha Dios —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Abénaméeyéi yéewáidéeyéi wenàiwica templo irìcu nàyaca néré. Néemìaca Jesús itàaníca cáuláiquéeri irí, íná nadàbaca náináidacawa Jesús ìwali cài: “Yái asìali Jesús itàaníca báawéeri iyú Dios ìwali, yácáiná abéerita Dios yáaliméeri imàacaca iwàwawa wenàiwicanái ibáyawaná íicha cayábacaténá náapicha Dios”, náimaca náináidacawa nalíwa nawàwalìcuísewa. ");
INSERT INTO pioNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Quéwa Jesús yáalíacawa náináidáanácawa. Iná isutáca yéemìawa nía: —‍¿Cánácué yéewa píináidacawa cài máiní báawéeri iyú? ");
INSERT INTO pioNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Máiní màulenáca wáimaca máapinéeri irí: ‘Nudéca numàacaca nuwàwawa pibáyawaná íicha cayábacaténá píapicha Dios’, càmicáiná áibanái yáalimá iicáca asáisí báisícaalí cayábaca yáapicha Dios. Quéwa máiní càulenáca wáimaca máapinéeri irí: ‘Pimichàawa, pìipìna’, áibanái wenàiwica náalimácáiná naicáca asáisí wadécaalí wachùnìacani watàacái iyúwa, yái máapinéerica. ");
INSERT INTO pioNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Iná núa, asìali Dios néeséerica, nuchùnìapiná yái máapinéerica píalíacaténácuéwa Dios idéca ichùulìaca núa numàacáanápiná nuwàwawa wenàiwicanái ibáyawaná íicha chái èeri irìcu cayábacaténá náapicha Dios —‍íimaca yái Jesúsca. Néeseca Jesús íimaca máapinéeri irí: —‍Pimichàawa, peedá pìalubáiwa, pèepùawa picapèe néréwa —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Néese yái máapinéeri imichàacawa, yá yàacawa icapèe néréwa. ");
INSERT INTO pioNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Níái wenàiwica ìyéeyéica néré, naicáca iyúwa ìyáaná, yá cáaluca nía. Nàaca Dios icàaluíniná imàacacáiná ichàiniwa abéeri wenàiwica irí ichùnìacaténá cáuláiquéeyéi. ");
INSERT INTO pioNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Jesús yàacatéwa capìi íicha, yá iicáca núa, núa Mateoca, yáawinéericawa aléera nuedácatalécaté plata nuénánái judío íichawa Roma ìyacàlená yàasu gobierno irípiná. Néese Jesús íimaca nulí: —‍Aquialé, pìawa núapicha, iyúwa nuéwáidacalé —‍íimaca nulí yái Jesúsca. Yá numichàa nùacawa Jesús yáapicha. ");
INSERT INTO pioNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Néese Jesús idècunitàacá iyáaca iyáacaléwa nucapèe irìcu, yá madécaná wenàiwica nàanàaca néré, áibanái yeedéeyéica plata néenánái judío íichawa Roma ìyacàlená yàasu gobierno irípiná, áibanái cabáyawanéeyéi nacái. Yá náawinacawa Jesús yáapicha, wáapicha nacái, wía Jesús yéewáidacaléca, nayáacaténá nayáacaléwa wáapicha. ");
INSERT INTO pioNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Néese fariseonái naicáca nía, íná náimaca walí, wía Jesús yéewáidacaléca: —‍Yái yéewáidéericuéca pía, ¿cáná iyáa iyáacaléwa náapicha níái yeedéeyéica wáicha plata romanonái yàasu gobierno irípiná, nía nacái cabáyawanéeyéica wenàiwicaca? —‍náimaca. ");
INSERT INTO pioNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Quéwa Jesús yéemìacani, yá íimaca fariseonái irí: —‍Péemìacué comparación: Máuláicacaalí wenàiwica, yá càmita nawàwacutá abéeri ichùnièripiná nía. Quéwa áibanái idènièyéica uláicái nawàwacutácani, yái ichùnièripináca nía. Càita nacái wenàiwica íináidéeyéica mabáyawanáca, càmita nacutá abéeri ichùnièripiná náiwitáise nabáyawaná íichawa. Quéwa áibanái wenàiwica yáaliéyéiwa cabáyawanáca, níata icutáca abéeri iwènúadéeripiná náiwitáise báawéeri íicha. ");
INSERT INTO pioNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Càmitacué péewáidawa cayába Dios itàacái ìwali. Pìacué péewáidacawa càinácaalí íimáaná yái tàacáisi profeta itànèericaté Dios inùmalìcuíse. Dios íimacaté: ‘Ewitacué pinúacáaníta madécaná pipìrawa iyúwa sacrificio pìacaténácué nucàaluíniná, càicáaníta caná iwèni meedá nuicáca culto pimàníiricuéca càmicaalícáwa piicáca áibanái wenàiwica ipualé, piyúudàacaténácué nía’, íimaca yái Diosca. Iná cayábaca nàwacáidáyacacawa nùatalé níái cabáyawanéeyéica, nuicácaténá napualé. Càmicáiná nùanàa numáidacaténá wenàiwica íináidéeyéica mabáyawanáca, néese nudéca nùanàaca numáidacaténá wenàiwica yáaliéyéiwa cabáyawanáca nawènúadáanápiná náiwitáisewa nabáyawaná íichawa —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Néeseté Juan el Bautista yéewáidacalénái nàanàaca Jesús yàatalé. Yá nasutáca néemìawa Jesús. Náimaca irí: —‍Wamàacaca wáichawa wayáacaléwa manùba yàawiría, fariseonái nacái, wasutácaténá wíawawa Dios íicha manuísíwata. ¿Cáná càmita namàaca náichawa nayáacaléwa, níái péewáidacaléca, nasutácaténá níawawa Dios íicha? —‍náimaca. ");
INSERT INTO pioNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Néese Jesús íimaca nalí: —‍Péemìacué comparación: Asìali icásàacaalíwa, yá imáidaca yàacawéeyéináwa asìanái naicácaténá icásàacawa casíimáiri iyú. Idècunitàacá ìyaca náapicha, càmita yéewa achúmaca nawàwa. Iná càmita namàaca náichawa nayáacaléwa. Quéwa áiba èeriwa, áibanái itéca náichawani. Néese namàacapiná náichawa nayáacaléwa, níái yàacawéeyéinámica achúmacáiná nawàwa néenialípiná. Càita nacái nuéwáidacalénáica, càmita yéewa achúmaca nawàwa idècunitàacá nùyaca náapicha. Iná càmita namàaca náichawa nayáacaléwa, nùyacáiná náapicha. ");
INSERT INTO pioNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Péemìacué áiba comparación: Càmita wadé wachanàidaca éwisàimi wabàlewa wàlisài wáluma yéemami iyú. Wamànicaalí cài, yásí wàlisài wáluma yéemami imàacacawa, yá icacanáidaca éwisàimi bàlesi, yá quéwanáta manuíca icháuná. ");
INSERT INTO pioNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Càita nacái càmita wadé wàucùaca wàlisài uva ituní éwisàimi íimamisi irìculé. Wamànicaalí cài, yásí uva ituní idàbaca isáacawa dàchidàchiwaca inànìacubàa, néese éwisàimi íimamisi icacanácawa, càmicáiná yáalimá imulacàacawa yàacawa. Yá yúucacawa wáicha macáita uva ituníca, íimamisi nacái. Iná wàucùaca wàlisài uva ituní wàlisài íimamisi irìculé. Yásí wacùaca nía cayába, yái uva ituníca, íimamisi nacái. Càita nacái nuéwáidacalénái yeebáidéeyéica nutàacái wàlisài, càmita nàya càide iyúwa fariseonái yàasu bàaluisàimi tàacáisi íimáaná”, íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Idècunitàacá Jesús itàaníca nalí, yá abéeri judío íiwacaliná yàanàacaté Jesús yàatalé, yá ibàlùacawa yùuluì ipùata iyúwa Jesús irí yàacaténá Jesús icàaluíniná. Néese judío íimaca Jesús irí: —‍Nuídu idéca yéetácawa siùcasíwatàacáwa. Quéwa pìacaalíwa ùatalé pimàacacaténá picáapiwa ùwali, yásí cáuca úa àniwa —‍íimaca. ");
INSERT INTO pioNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Jesús yàacawa yáapicha, wía nacái yéewáidacalénái wàacatéwa Jesús yáapicha. ");
INSERT INTO pioNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Abéechúa inanái ùacawa manùbéeyéi wenàiwica yèewi. Cáuláicacaté úa doce camuí, uíraná yàacawa uícha mamáalàacata. Uái inanáica ùacawa Jesús yáamiwáise mawiénita irí, manùbéeyéi wenàiwica yèewi. Yá udunùaca ibàle ipùata ìwali. ");
INSERT INTO pioNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Umànica cài uínáidacáináwa ùacawa: “Nudunùacaalí ìwali, éwita ibàle ìwalicáaníta meedáni, yásí báisíta cayábaca núatá”, cài úumaca uínáidacawa ulíwa uwàwalìcuísewa. ");
INSERT INTO pioNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Quéwa Jesús iwènúa iicáidaca ulí, yá íimaca ulí: —‍Picá achúma piwàwa. Pidéca pichùnìacawa pimàacacáiná piwàwawa nùwali —‍íimaca yái Jesúsca. Yáta cayábaca úa uláicái íicha. ");
INSERT INTO pioNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Néeseté Jesús yàanàaca judío íiwacaliná icapèe néré, yá iicáca áibanái ipùlièyéi íwa. Nàwacáidáyacacatéwa nabàlìacaténá yéetéechúamiwa. Aibanái nacái náicháaníca uíwitáisemi, néemíaníca nacáiwa cachàiníiri iyú càide iyúwa judío íiwitáise ìyáaná. ");
INSERT INTO pioNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Jesús yáalíacawa icáucàidáanápináté úái yéetéechúamicawa, íná íimaca nalí: —‍Pimusúacuéwa macáita, úacáiná sùmàuca càmíichúata yéetáwa, uimácáicata ùyaca —‍íimaca yái Jesúsca, yáalíacáináwa icáucàidáanápináté úa. Néese níái wenàiwicaca naicáaníca Jesús iquíniná, náalíacáináwa báisíiri iyúcani uétácatéwa. ");
INSERT INTO pioNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Quéwa Jesús imusúadaca nía canánama capìi íicha. Néese iwàlùacawa sùmàumi irìacatalécawa. Yá íibàaca ucáapi ìwali úái yéetéechúamicawa, yá umichàacawa, cáuca úa àniwa. ");
INSERT INTO pioNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Néesetécáwa macáita wenàiwica ìyéeyéica mawiénita irí yái yàcaléca néemìacaté uináwaná ìwali Jesús imichàidáanáté úa yéetácáisi íicha. ");
INSERT INTO pioNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Jesús imusúacatéwa nacapèe íicha, yá pucháiba matuíyéi nàacawa yáamíise. Yá náimaca irí cachàiníiri iyú: —‍¡Pía rey David itaquérinámica, Dios ibànuèrica walí wacuèrinápiná, wía judíoca, piicá wapualé! —‍náimaca irí. ");
INSERT INTO pioNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Jesús iwàlùacawa capìi irìculé, néese níái matuíyéica nàacawa yàatalé. Yá Jesús isutáca yéemìawa nía: —‍¿Peebáidasicué núalimá catuíca numànicuéca pía? —‍íimaca yái Jesúsca. Náimaca irí: —‍Báisíta, Wáiwacali, weebáida cài —‍náimaca. ");
INSERT INTO pioNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Néese Jesús imàacaca icáapiwa natuí ìwali. Yá íimaca nalí: —‍Pichùnìacuéwa càide iyúwa peebáidáanácué —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Yásí cayábaca natuí. Yá Jesús yàalàaca nía cachàiníiri iyú. Iimaca nalí: —‍Picácué pimàaca áibanái náalíacawa cawinácaalícué ichùnìaca pituí —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Quéwa namusúacanacáitawa capìi íicha, yáta nacàlidaca Jesús iináwaná ichùnìaca nía nalí níái nayaquewéeyéicawa. ");
INSERT INTO pioNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Néeseté idècunitàacá matuíyéimi namusúaca nàacawa capìi íicha, yá áibanái natéca matàacáiri asìali Jesús yàatalé. Demonio idacùaca matàacáiri íiwitáise, íná càmita yáalimá itàaníca. ");
INSERT INTO pioNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Yá Jesús yúucaca demonio asìali iwàwalìcuíse. Néese matàacáiri idàbaca itàaníca. Yá áibanái wenàiwica ìyéeyéica néeni náináidacawa manuísíwata naicáidaca Jesús irí. Yá náimaca nalíwáaca: —‍¡Canácaté waiquéericáwa càiri wawàsi chái wàasu cáli Israel néenibàa! —‍náimaca. ");
INSERT INTO pioNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Quéwa abénaméeyéi fariseo náimaca Jesús ìwali: —‍Demonio íiwacalináquéi idacùaca íiwitáise yái asìalica Jesús. Iná yéewa yúucaca demonio wenàiwica íicha demonio íiwacaliná íiwitáise iyú —‍náimaca Jesús ìwali. ");
INSERT INTO pioNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jesús yàacaté ipáchiaca macái manuíri yàcalé irìculé, púubéeri yàcalé irìculé nacái. Yá yéewáidaca wenàiwicanái macái judíonái imanùbaca yéewáidacàalu irìcu. Yá icàlidaca nalí càinácaalí iyú Dios icùaca yàasu wenàiwicawa. Ichùnìa nacái cáuláiquéeyéi wenàiwica, cáiwíiri íicha nacái, macái íiwitáaná. ");
INSERT INTO pioNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Catúulécanáca Jesús iicáca nía máinícáiná achúmaca nawàwa nàuwichàacáinátéwa madécaná yàawiría. Càica níade iyúwa ovejanái canéeyéica icuèriná, iméerèeyéicawa meedá, canácáináté abéeri yéewáidéeripiná nía Dios ìwali, níái wenàiwicaca. ");
INSERT INTO pioNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Iná Jesús íimaca walí, wía yéewáidacaléca: —‍Báisíta, madécaná wenàiwica nawàwa neebáidaca nutàacái. Péemìacué comparación: Càica níade iyúwa bànacalé ituíná quíiréeri yéenáiwaná yàanàacaalí wenàiwica needácatáipiná nabànacalewa. Quéwa máisibáanatacué pía, icàlidéeyéipiná nalí nutàacái. ");
INSERT INTO pioNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Iná pisutácué Dios íicha, yái càiride iyúwa bànacalé íiwacali, ibànùanápiná yàasu wenàiwicawa íibaidéeyéipiná irí, nacàlidacaténá wenàiwicanái irí nuináwaná ìwali, yéewacaténá neebáidaca nulí. Yásí wàwacáidaca nía Dios yàasu wenàiwicanáipiná càide iyúwa wenàiwica needácaalí nabànacale ìyacanáwa —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Néeseté Jesús imáidaca yàataléwa wía, wía docéeyéica imanùbaca yéewáidacaléca. Yá imàacaca walí íiwitáisewa wáucacaténá demonio wenàiwicanái íicha, wáucacaténá náicha nacái macái uláicái íiwitáaná, cáiwíiri nacái. ");
INSERT INTO pioNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Wía docéeyéica imanùbaca apóstolca íipidenéeyéica cài: quéecha Simón, íipidenéeri nacái Pedro; yá nacái iméeréeri íipidenéeri Andrés; nía nacái Zebedeo yéenibeca, ibèeri íipidenéeri Santiago, yá nacái iméeréeri íipidenéeri Juan; ");
INSERT INTO pioNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","yá nacái Felipe; Bartolomé nacái; Tomás nacái; núa nacái Mateo, núa yái yeedéericaté plata nuénánái judío íichawa Roma ìyacàlená yàasu gobierno irípiná; yá nacái Santiago, yái Alfeo ìirica; Tadeo nacái; ");
INSERT INTO pioNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","yá nacái Simón, íipidenéeri nacái celote; yá nacái Judas Iscariote, yái itéeripinácaté Jesús yùuwidenái náibàacaténáni, nanúawani. ");
INSERT INTO pioNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Jesús ibànùacaté wía doce wamanùbaca wacàlidacaténá itàacái. Cài yàalàaca wía: “Picácué pìawa càmíiyéi judío yàasu cáli íinatalé, picácué nacái piwàlùawa yàcalé irìculé ìyéeyéica Samaria yàasu cáli íinata. ");
INSERT INTO pioNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Pìacué nàatalé níawamita Israel itaquénáinámica ìyéeyéica càide iyúwa ovejanái iméerèeyéiwa, canéeyéica icuèriná, nawènúadacáiná náiwitáisewa Nacuèriná Dios íichawa, canáca nacái abéeri yéewáidéeripiná nía Dios ìwali. ");
INSERT INTO pioNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Pìacué picàlidaca nalíni Dios icùanápiná macáita mesúnamáita. ");
INSERT INTO pioNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Pichùnìacué cáuláiquéeyéi wenàiwica, pimichàidacué nacái yéetéeyéimiwa yéetácáisi íicha, pichùnìacué nacái cacháunéeyéi íimami lepra iyú, piúcacué demonio wenàiwica íicha. Nudéca numàacacuéca pirí nuíwitáisewa mawèníiri iyú, íná picácué picobra nía cawinácaalí wenàiwica pichùnièyéica. ");
INSERT INTO pioNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","“Picácué pité iwèni pìasu bolsa irìcuwa, orocáaníta, plata nacái, cobre nacái. ");
INSERT INTO pioNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Picácué pité saco, pucháiba bàlesi nacái; picácué peedá piríwa wàlisài costiza nacáiri, àicu nacái. Cawinácaalí wenàiwica piyúudèeyéipinácuéca iwàwacutá nàaca piyáapinácuéwa. ");
INSERT INTO pioNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Pìacuéwa yàcalé irìculé, picutácué abéeri cáimiétacanéeri iwàwéerica yéemìaca picàlidáanácué nalí nutàacái. Yá piyamáacuéwa icapèe irìcu àta pèepùacatalétacuéwa yàcalé irìcuíse. ");
INSERT INTO pioNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Piwàlùacuéwa icapèe irìculé, yá pitàidacué wenàiwicanái ìyéeyéica néré, pisutácué nalí Dios imàníinápiná nalí cayábéeri. ");
INSERT INTO pioNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Cayábacaalí náiwitáise níái capìi irìcuíyéica, yásí Dios imànica nalí cayábéeri càide iyúwacué pisutáaná íicha. Quéwa, càmicaalí cayába náiwitáise, néese Dios càmita imànipiná nalí cayábéeri. ");
INSERT INTO pioNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Quéwa, càmicaalícué nawàwa needáca nàataléwa pía, càmita nacái nawàwa néemìaca picàlidáanácué nalí nutàacái, néese pimusúacuéwa capìi irìcuíse, yàcalé irìcuíse nacái, yá pichùpìacué cáli ichùmalé pìabàli íichawa naicápiná, càide iyúwa wáiwitáise ìyáaná, wía judíoca, píasáidacaténácué nalí Dios yùuwichàidáanápiná nía. ");
INSERT INTO pioNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Péemìacué cayábani, èeri imáalàacaalípináwa, Dios yùuwichàidapiná báawéeyéi wenàiwica, yásí yùuwichàidapiná níawa càmíiyéicué yeedáca yàataléwa pía máiní yáwanái Sodoma ìyacàlená mìnanáimi íicha, Gomorra ìyacàlená mìnanáimi nacái”, íimaca walí yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Néeseté Jesús íimaca walí, wía yéewáidacaléca: “¡Péemìacué cayába! Nubànùacué pía nèewiré níara èeri mìnanáica cuwèesi lobo nacáiyéi íiwitáise, báawéeyéica iicáca Dios, báawéeyéi nacái iicáca Dios yàasu wenàiwica. Pìyapinácuéca nèewibàa càide iyúwa oveja càmíiyéi yáalimá ipéliaca caluéyéi cuwèesi lobo íipunita iwàwéeyéica iyáaca oveja. Iná iwàwacutácué cáalíacáica píiwitáise, piicácué píichawa piùwidenáicawa, càide iyúwa cáalíacáiri àapi iicáaná íichawa yùuwidenáiwa ipíchaná áibanái ichìwáidacuéca pía. Quéwa iwàwacutácué mabáyawanáca pía, càmitacué nacái pimàni áibanái irí báawéeri. Pìyacué càide iyúwa unùcu càmíichúa imàni áibanái irí báawéeri. ");
INSERT INTO pioNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Picácué píichawa áibanáicáiná náibàapinácuéca píawa nacháawàacaténácué piináwaná ìwali yàcalé íiwacanánái irí, nacapèedáidacaténácué nacái píawa judíonái yéewáidacàalu irìcu. ");
INSERT INTO pioNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Yá natépinácuéca píawa nacháawàacaténácué piináwaná ìwali nacuèrinánái iríwa, náiwacanánái irí nacáiwa, níái icuèyéica cáli, peebáidacáinácué nutàacái. Càita píalimápinácué picàlidaca nalí nuináwaná ìwali, níái èeri mìnanái icuèrinánáica, nía nacái càmíiyéica judío. ");
INSERT INTO pioNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Náibàapinácué natéwa pía nacháawàacaténácué piináwaná ìwali nacuèrinánái iríwa, quéwa picácué achúma píináidacawa piwàwawa ìwali yái tàacáisi iwàwacutéericuéca picàlidaca nalí, càinácaalí iyú nacái yéewanápiná picàlidaca piináwaná ìwaliwa. Néesecué péenáiwaná yàanàacaalíwa picàlidáanápiná piináwaná ìwaliwa, yásí Dios imàacacué píalíacawa càinácaalí iyú iwàwacutáaná picàlidaca nalíni. ");
INSERT INTO pioNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Càmicáinácué pía yái cài icàlidéeripinácani, néese Espíritu Santo Wáaniri Dios ibànuèrica imàacapinácué pitàaníca Dios inùmalìcuíse. ");
INSERT INTO pioNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Néenialípiná wenàiwicanái nacháawàapiná néenánáisíwawa áibanái irí néetáanápináwa neebáidacáiná nutàacái. Aibanái nasèenái nacái nacháawàapiná néenibewa néetáanápináwa neebáidacáiná nutàacái. Aibanái néenibe nacái nawènúadapiná náiwitáisewa nasèenái íichawa, yá nanúaca nasèenáiwawa. ");
INSERT INTO pioNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Macái èeri mìnanái báawapinácué naicáca píawa peebáidacáiná nutàacái, quéwa cawinácaalí wenàiwica yeebáidéeyéica nutàacái mamáalàacata àta néetácatalétawa, Dios iwasàapiná níawa yàasu yùuwichàacáisi íichawa. ");
INSERT INTO pioNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Namànicaalícué pirí báawéeri abéeri yàcalé irìcu, néese pipìacuéwa áiba yàcalé irìculé. Péemìacué cayába, núa asìali Dios néeséerica nùanàapiná ipíchawáise pimáalàidacué picàlidaca nuináwaná ìwali macái yàcalé irìcu ìyéeyéica Israel yàasu cáli íinata. ");
INSERT INTO pioNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Péemìacué comparación: Abéeri yéewáidacalé càmita yéewa cachàinica íicha yái yéewáidéericani, càmita yéewa nacái áiba íibaidéeri cachàinica íiwacali íichawa. Càitacué nacái càmita yéewa cachàinica pía nuícha. Wenàiwica náináidacawa pìwalicué càide iyúwa náináidáanáwa nùwali. ");
INSERT INTO pioNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Píacué nuéwáidacaléca, iwàwacutácué piwàwaca pìyaca càide iyúwa nùyáaná, yái yéewáidéericuéca pía, càide iyúwa yàasu wenàiwica iwàwáaná ìyaca càide iyúwa íiwacali ìyáaná. Aibanái càmíiyéi yeebáida nutàacái náimaca nùwali Beelzebúcasa núa, yái demonio íiwacalináca. Iná nùalàacuéca pía náicha, náimáanápinácué pìwali càiri báawéeri tàacáisi nacái, pìyacáinácué càide iyúwa nucapèe irìcuíyéica, nuénánáisíwa”, íimaca walí yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Jesús íimacaté walí: “Iná picácué cáalu pía èeri mìnanái íicha, càmicáiná náalimá nabàaca nabáyawanáwa càiripináta. Aiba èeriwa macáita náalíacawa ìwali. ");
INSERT INTO pioNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Càita nacái, picácué pibàaca náicha nutàacái. Yái nucàlidéericuéca pirí ibàacanéeri iyú, iwàwacutácué picàlidaca nalíni amalánama. Yái nucàlidéericuéca pirí ìwali méetàuculé áibanái íicha, pìacué picàlidaca cachàiníiri iyúni àta macái néemìacatalétani. ");
INSERT INTO pioNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Picácué cáalu pía èeri mìnanái íicha yáaliméeyéica inúacuéca pía quéwa càmitacué náalimá nanúacuéca piwàwa cáuri. Néese, iwàwacutácué cáaluca pía Dios íicha, yái yáaliméerica yeedácuéca picáuca, yúucacaténácué pía nacái infierno irìculé, yái quichái càmíirica ichacàwa càiripinéerita ìyaca. ");
INSERT INTO pioNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Péemìacué comparación: Aibanái nawéndaca pucháiba màsibèe púubéeyéi abéeri moneda ìwaliná càmicáiná cawèni màsibèe púubéeyéica. Quéwa éwita càmíiyéicáaníta cawèni nía, càicáaníta Wáaniri Dios yáalíacawa nàwali, icùa nacái nía. Càmita yéewa abéeri màsibèe achúméeri yéetácawa càmicaalícáwa Dios imàacaca yéetácawa. ");
INSERT INTO pioNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Càita nacái Dios icùacuéca pía. Yáalíacuéca macáita pìwali, àta càisimalénácaalícué píiwita ibáiná, yáalía nacáiwa Dioscáiná idéca iputàaca nía abéerinamata; càita Dios yáalíacawa pìwalicué. ");
INSERT INTO pioNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Iná picácué cáalu pía wenàiwicanái íicha, cawènicáiná Dios iicácuéca pía náicha níái màsibèe púubéeyéica manùbéeyéica”, íimaca walí yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Jesús íimacaté walí, wía yéewáidacaléca: “Cawinácaalí wenàiwica icàlidéerica iináwanáwa yeebáidaca nutàacái wenàiwicanái yàacuésemi, yásí núa nacái nucàlidapiná iináwaná ìwali nùasu wenàiwicacani Núaniri Dios chènuníiséeri iríwa. ");
INSERT INTO pioNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Quéwa cawinácaalí càmíirita icàlida iináwanáwa yeebáidaca nutàacái wenàiwicanái yàacuésemi, yásí núa nacái nucàlidapiná iináwaná ìwali, càmita nùasu wenàiwicacani Núaniri Dios chènuníiséeri iríwa”, íimaca walí yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Jesús íimacaté walí nacái: “Picácué píináidawa wenàiwicanái nàyapiná matuíbanáita náapichawáaca nudécáaníta nùanàaca. ¡Càmíirita! Néese, càmitapiná abédanama náiwitáise nùwali. ");
INSERT INTO pioNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Nudéca nùanàaca, íná asìanái nàuwideca namànipináca náaniriwa, inanái nacái nàuwideca namànipiná náatúawa, nayéeru nacáiwa. ");
INSERT INTO pioNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Càita macáita nàuwideca namànipiná néenánáisíwawa, níacáiná abénaméeyéi neebáidapiná nulí, quéwa áibanái càmita neebáida nulí. ");
INSERT INTO pioNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Cawinácaalí cáininéerica iicáca nuícha yáaniri, yáatúa nacáiwa nuícha, càmita yéewa nùasu wenàiwicacani. Aibacaalí nacái cáininéerica iicáca nuícha ìiriwa, íidu nacáiwa nuícha, càmita yéewa nùasu wenàiwicacani. ");
INSERT INTO pioNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Iwàwacutá nùasu wenàiwica matuíbanáiri iyú imàaca áibanái nàuwichàidacani nùwalíise, naicáaní nacái iquíniná, éwita nanúacaalíni cruz ìwali yeebáidacáiná nutàacái. Iwàwacutá nacái imànica macáita càide iyúwa nuchùulìaná. Cawinácaalí càmíirica imàni cài, càmita yéewa nùasu wenàiwicacani. ");
INSERT INTO pioNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Aibacaalí càmíirica iwàwa yeebáida nutàacái ipíchaná yùuwichàacawa nulípiná, canáca irí icáuca càmíiri imáalàawa. Quéwa cawinácaalí yeebáidéerica mamáalàacata nutàacái, éwita nanúacaalíni, yácata idènièripiná icáucawa càmíiri imáalàawa”, íimaca walí yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Néeseté Jesús íimaca walí àniwa: “Cawinácaalí yeebáidéericuéca pitàacái, yeebáidapiná nacái nutàacái. Néese nacái, cawinácaalí yeebáidéerica nutàacái, yeebáidapiná nacái itàacái, yái Dios ibànuèrica núa aléi. ");
INSERT INTO pioNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Aibacaalí wenàiwicanái yeebáida Dios yàasu profeta itàacái, namànicaalí nacái profeta irí cayábéeri profeta icàlidacáiná nalí Dios itàacái, yásí Dios yàapiná nalí cawèníiri càiride iyúwa Dios yàaná cawèníiri yàasu profeta iríwa. Aibanái wenàiwica neebáidacaalí itàacái cayábéeri íiwitáise, namànicaalí nacái irí cayábéeri cayábacáiná íiwitáise, yásí Dios yàapiná nalí cawèníiri càiride iyúwa Dios yàaná cawèníiri cayábéeri íiwitáise irí. ");
INSERT INTO pioNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Cawinácaalí imàníirica cayábéeri nuéwáidacalénái càmíiyéi cachàini irí, nùasunáicáiná nía, Dios yàapiná irí cawèníiri iyúudàacáiná níái yeebáidéeyéica nutàacái. Ewita yáalimácáaníta yàaca nàiraca meedá casalíníiri úni, càicáaníta Dios yàapiná irí cawèníiri iyúudàacáiná nùasunái”, íimaca walí yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Néeseté Jesús idécanáamité yàalàaca wía docéeyéi yéewáidacaléca, yá yàacawa yéewáidacaténá wenàiwicanái áibanái ìyacàle irìcu, yáara cálica, icàlidaca nacái nalí yái cayábéeri tàacáisica. ");
INSERT INTO pioNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Néenialíté Juan el Bautista, ìyéerica presoíyéi ibànalìcu, yéemìaca ìwali yái Cristo imàníirica. Néese Juan ibànùaca yéewáidacalénáiwa abénaméeyéi nàacaténáwa Jesús yàatalé. ");
INSERT INTO pioNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Juan iwàwacaté nasutáca néemìawa Jesús asáisí báisícaalí Dios néeséericani, yái wenàiwica Dios ibànuèripinácaté judío icuèrinápiná, néese càmicaalí yáníi, yá iwàwacutá nacùaca áibata yàanàaca. ");
INSERT INTO pioNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Néese Jesús íimaca nalí: “Pèepùacuéwa Juan yàatalé. Picàlidacué Juan iríni pidéenácuéca piicáca numànica, pidéenácuéca nacái péemìaca nucàlidaca wenàiwicanái irí. ");
INSERT INTO pioNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Picàlidacué Juan iríni matuíyéimi idéca iicáidaca, éeruíyéimi yàabàli nacái nadéca nàipìnáaníca, cacháunéeyéimi íimami lepra iyú nacái, idéca cayábaca nía uláicái íicha, màuwíiyéimi nacái nadéca néemìaca, yéetéeyéimiwa nacái nadéca namichàacawa yéetácáisi íicha, catúulécanéeyéi nacái nadéca néemìaca nuwàwaca nuwasàaca nía Dios yàasu yùuwichàacáisi íicha. Picàlidacué Juan iríni yáalíacaténáwa idéca nùanàaca, núa Dios néeséerica. ");
INSERT INTO pioNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","¡Casíimáica cawinácaalí wenàiwica yeebáidéeyéica nutàacái mamáalàacata!” íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Néese idécanáamité Juan yéewáidacalénái yèepùacawa Jesús íicha, yá Jesús idàbaca icàlidaca Juan el Bautista iináwaná ìwali. Jesús íimaca wenàiwicanái irí: “Bàaluité pìacatécué piicáca wenàiwica yèepuníiricawa chuìri cáli íinata, yáara Juanca. Càmíiritaté machawàaca íiwitáise yái asìali piiquéericatécué, càide iyúwa masicái cáuli yáawiadáidéerica meedá. ");
INSERT INTO pioNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","¿Càinásicué piicáté néré? Càmíiritaté asìali cawèníiri ibàle yái piiquéericatécué. Píalíacuécawa cawinácaalí cawèníiyéica ibàle ìyéeyéica nacái càasuíri iyú, nàyaca cayábéeri capìi irìcu càide iyúwa reynái ìyáaná, icuèyéica manùbéeyéi wenàiwica. ");
INSERT INTO pioNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Néese pìacuécawa bàaluité manacúali yùuculé càináwàiri piicácaténáté profeta icàlidéerica tàacáisi Dios inùmalìcuíse. Báisíta profetacani, yái Juanca, quéwa máiníiri cachàinica áibanái profeta íicha canánama. ");
INSERT INTO pioNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Yái Juanca, yácata yáara nacàlidéericaté ìwali tàacáisi Dios inùmalìcuíse. Dios yàasu profeta itànàacaté tàacáisi Dios íiméericaté Iiri iríwa. Dios íimacaté: ‘Nuchùulìapiná pipíchalé nùasu wenàiwicawa icàlidéerica nutàacáiwa. Yá yàapinácawa pipíchalé yàalàacaténá wenàiwica nachùnìanápiná náiwitáisewa yéewanápiná natàidaca pía cayába pìanàacaalíwa nàatalé’, íimacaté yái Diosca. ");
INSERT INTO pioNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Péemìacué cayába, canácata áiba wenàiwica cachàiníiri Juan íicha nèewíise macái èeri mìnanái. Quéwa cawinácaalí wenàiwica yeebáidéeyéica Dios itàacái siùcáisede, yéewanápiná Dios icùaca nía, máiní cachàinipináca nía Juan íicha, éwita càmicáaníta máiní cachàinica nía Dios ìyacàle irìcu Dios icùacataléca macáita chènuniré. ");
INSERT INTO pioNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","“Bàaluité Juan el Bautista idàbacaalíté icàlidaca Dios itàacái àta siùca nacáide, èeri mìnanái namànica báawéeri Dios yàasu wenàiwicanái irí, yá náalimáidaca namáalàidaca cawinácaalí yeebáidéeyéica Dios itàacái, iwàwéeyéica Dios icùaca nía. ");
INSERT INTO pioNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Macái tàacáisi profetanái icàlidéericaté Dios inùmalìcuíse, áiba tàacáisi nacái Dios ichùulièricaté profeta Moisés itànàanápiná, macáita yái tàacáisica icàlidacaté walíni càinácaalí iyú Dios icùanápináté yàasu wenàiwicawa. Càité nacàlidaca Dios itàacái àta Juan el Bautista yàanàacatalétaté. ");
INSERT INTO pioNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Cawàwanátacué píalimá peebáidaca yái tàacáisica: Juan el Bautista, yácata profeta Elías nacáiri, yái iwàwacutéericaté yàanàaca ipíchawáise israelita icuèrinápiná yàanàaca. ");
INSERT INTO pioNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Càuwíiyéicaalícué pía, péemìacué nutàacái. ");
INSERT INTO pioNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Nucàlidacué pirí càiná píiwitáise, píacué wenàiwicaca ìyéeyéica siùca. Péemìacué comparación: Càicuéca píade iyúwa sùmanái yáawinéeyéicawa àyapulìcubàa bamuchúamibàa yàcalé. Néese namáidaca nanacáiyéi iríwa: ");
INSERT INTO pioNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Wadéca wapùlìacuéca pirí íwa, quéwa càmitacué pilabàa; néese wadéca wacántàacuéca pirí canción càide iyúwa nacántàaná yéetéeyéimiwa ìwali, quéwa càmitacué píicháaní’, cài náimaca. ");
INSERT INTO pioNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Càita nacái pidécuéca pimànica. Juan el Bautista yàanàacaté, yá imàacaca íichawa iyáacaléwa isutácaténá yáawawa Dios íicha manuísíwata, càmita nacái ìira uva ituní. Quéwa píimacatécué Juan ìwali demoniosa ìyaca iwàwalìcu. ");
INSERT INTO pioNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Siùcade nudéca nùanàaca, núa asìali Dios néeséerica. Nuyáaca nuyáacaléwa, nuìra nacái uva ituní. Néese píimacuéca nùwali camùníiricasa núa, cáanáirisa iyáaca iyáacaléwa núa, casíimáicasa nacái nucàmaca, nùacawéeridáanása nacái cabáyawanéeyéi wenàiwica, nía nacái yeedéeyéica plata néenánái judío íichawa Roma ìyacàlená yàasu gobierno irípiná. Càita píimacuéca nùwali càmicáinácué piwàwa peebáidaca nutàacái. Quéwa cawinácaalí yeebáidéeyéica Juan yàasu tàacáisi, nutàacái nacái, náasáidaca Dios idéca imàacaca cáalíacáica nía báisíiri iyú”, íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Néese Jesús yàalàaca nía cachàiníiri iyú níái yàcalé mìnanáica aléera Jesús imànicatalécaté batéwa macáita yái càmíirica wenàiwica idé imànica. Yàalàaca nía cachàiníiri iyú càmicáináté nawènúada náiwitáisewa Dios irípiná. Yá Jesús íimaca nàwali: ");
INSERT INTO pioNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“¡Máinícué piùwichàapinácawa, píacué israelitaca ìyéeyéica Corazín ìyacàlená irìcu, Betsaida ìyacàlená irìcu nacái! Ewitacué piicácáaníta numànica pèewibàa madécaná yái càmíirica wenàiwica idé imànica, càicáanítacué càmita piwènúada píiwitáisewa pibáyawaná íichawa. Piyúunáidacuéca máiníiyéica cayábaca pía náicha níara càmíiyéica israelitami ìyéeyéicaté Tiro ìyacàlená irìcu, Sidón ìyacàlená irìcu nacái, ìyéeyéica méetàuculé Israel yàasu cáli íicha. Quéwa càmitaté máiní báawaca nía píichacué. Càmitaté naicá áiba imànica nèewibàa càide iyúwa numàníiná pèewibàa. Quéwa naicácaalíté càiritá, yá nawènúadacaté náiwitáisewatá caquialéta Dios irípinátá, càmicáináté máiní báawéeyéica nía iyúwacué pía, yá nacái nàwalicaté nabàlesíamiwa báawéeri iicácanáwatá, napusúa nacái nàwalíisewa catáli náasáidacaténáté achúmaca nawàwa nabáyawaná ìwaliwatá. ");
INSERT INTO pioNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Quéwa núumacué pirí, áiba èeriwa Dios yùuwichàidapiná báawéeyéi wenàiwica, yásí piùwichàapinácuécawa máiní cachàiníwanái náicha, níara càmíiyéica israelita ìyéeyéicaté Tiro ìyacàlená irìcu, Sidón ìyacàlená irìcu nacái, máinícáinácué báawéeyéica náicha pía. ");
INSERT INTO pioNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Píacué nacái Capernaum ìyacàlená mìnanáica, piyúunáidacuéca máinípiná cáimiétacanáca pía, càide iyúwa Dios ìyáaná chènuniré. ¡Càmíirita! ¡Néese Dios yúucapinácué píawa irìculé yáara utàwi máiníiri depuíwaca, máinícatalé depuíwaca náicha canánama! Ewitacué piicácáaníta numànica pèewibàa madécaná yái càmíirica wenàiwica idé imànica, càicáanítacué càmita piwènúada píiwitáisewa pibáyawaná íichacuéwa. Piyúunáidacuéca máiníiyéica cayábaca pía náicha níara càmíiyéica israelita ìyéeyéicaté Sodoma ìyacàlená irìcu. Quéwa càmitaté máiní báawa nía píichacué. Càmitaté naicá áiba imànica nèewibàa càide iyúwa numàníiná pèewibàacué. Quéwa naicácaalíté càiritá, yá nawènúadacaté náiwitáisewatá caquialéta Dios irípinátá, càmitaté nacái Dios imáalàidaca níatá, yá nacái nàyacàlemi Sodoma ìyacaté mamáalàacatatá àta siùca nacáide, càmicáináté máiní báawéeyéi nía iyúwacué pía. ");
INSERT INTO pioNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Iná núumacué pirí, áiba èeriwa Dios yùuwichàidapiná báawéeyéi wenàiwica, yásí piùwichàapinácuécawa máiní cachàiníwanái náicha níara càmíiyéica israelita ìyéeyéicaté Sodoma ìyacàlená yàasu cáli íinata, máinícáinácué báawéeyéica náicha pía”, íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Néenialíté Jesús íimaca Yáaniri Dios iríwa: “Pía, Núaniri Dios, nùaca pirí cayábéeri, pía Nacuèrinásàirica macáita níái ìyéeyéica chènuniré, chái èeri irìcuíyéica nacái. Nùaca pirí cayábéeri pimàacacáiná nalí píiwitáisewa, níái yeebáidéeyéica pitàacái càide iyúwa sùmanái púubéeyéi neebáidáaná, yéewanápiná áiba èeri mìnanái iyúunáidéeyéi cáalíacáica càmita náalimá náalíacawa píiwitáise ìwali. ");
INSERT INTO pioNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Báisíta, Núaniri, pidéca pimànica càide iyúwaté piwàwáaná pimànica”, íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Néese Jesús íimaca wenàiwicanái irí: “Núaniri Dios idéca imàacaca núalíacawa macáita. Abéerita Núaniri yáaliéri báisíiri iyú nùwali, yái Iirica. Abéerita núa, yái Iirica, yáaliéri báisíiri iyú Núaniri ìwali, abéerita nacái cawinácaalí wenàiwicanái numàaquéeyéica yáalíaca Núaniri ìwali, càide iyúwa nuwàwáaná, yái Iirica. ");
INSERT INTO pioNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Aquialécué nùatalé, peebáidacué nutàacái, píacué macáita chamàléeyéica. Pidécuéca píibaidaca cachàiníiri iyú pimànicaténácué macáita càide iyúwa áibanái ichùulìanácué pimànica càulenéeri wawàsi Dios irípiná. Píacué nacái achúméeyéica íináidacawa iwàwawa ibáyawaná ìwaliwa, aquialécué nùatalé, yá numàacacué piyamáidaca píawawa càulenéeri wawàsi íicha, numàacacué nacái nuwàwawa pibáyawaná íicha. ");
INSERT INTO pioNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Peebáidacué nutàacái, pimànicué nacái càide iyúwa nuchùulìanácué pía. Pimàacacué nuéwáidaca pía, pìyacaténácué càide iyúwa nùyáaná, núa càmíirica caluéri íiwitáise, núa càmíirica cáimacái iicá yáawawa. Nùacawéeridapinácué pía, wáibaida nacái wáapichawáaca. Càitacué píalimápiná piyamáidacawa pibáyawaná íichawa, íicha nacái yái càulenéeri wawàsi áibanái ichùulièricuéca pimànica Dios irípiná. ");
INSERT INTO pioNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Càmita máiní càulenácué píicha peebáidáanápinácué nutàacái, pimàníinápinácué nacái càide iyúwa nuchùulìanácué pía, nùacawéeridacáinácué pía, numàacapinácué nacái casíimáica pía”, íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Néenialíté áiba sábado judíonái iyamáidacatáicawa Jesús yèepunícawa àyapulìcubàa bànacalé yèewibàa, wáapicha wía yéewáidacaléca. Yá máapica wía, íná weedáca achúmáanata trigo ituíná bànacalé íicha wayáapináwa, judío íiwitáise imàacacáiná wenàiwica needáca nayáapináwani achúmáanata ìyacaná áibanái ibànacale yéená, máapicaalí nía. ");
INSERT INTO pioNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Fariseonái naicácaté weedáca bànacalé ìyacaná, yá naicáca yái wamàníirica iyúwa íibaidacalési ínáté náimaca Jesús irí: —‍Piicácá yái namàníináca. Péewáidacalénái náibaidaca siùca sábado wayamáidacatáicawa. Dios càmita imàaca wáibaidaca siùca èeri —‍náimaca irí. ");
INSERT INTO pioNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Néese Jesús íimaca nalí: —‍Pidécuéca piimáichaca tàacáisi piléericuéca Dios itàacái irìcuíse wàawirimi rey David ìwali, bàaluité máapicaalíténi, áibanái nacái yáapichéeyéi asìanáica. ");
INSERT INTO pioNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","David iwàlùacatéwa Dios yàasu manuíri capìima íimamisíiri irìculé, yái israelitanái isutácatáipiná Dios íicha. Yá iyáaca pan namàníiricaté Dios irí ofrenda piná sacerdotenái iyáapiná. Ewita Dios imàacacáaníta níawamita sacerdotenái iyáaca yái panca, càicáaníta càmitaté yùuwichàida David, nía nacái asìanái yèepuníiyéicatéwa yáapicha, máapicáináté nía, ínáté catúulécanáca Dios iicáca nía. ");
INSERT INTO pioNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Pidécuéca piimáichaca nacái áiba tàacáisi profeta Moisés itànèericaté Dios inùmalìcuíse. Moisés íimacaté sacerdotenái càmita namàni nabáyawanáwa éwita náibaidacáaníta templo irìcu sábado wayamáidacatáicawa. Máiní iwàwacutáca náibaidaca Dios irípiná templo irìcu namànicaténá macáita càide iyúwa Dios iwàwáaná. Cachàinica templo sábado íicha iwàwacutácáiná wenàiwica nàaca Dios icàaluíniná èeri imanùbaca, sábado nacái. ");
INSERT INTO pioNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Quéwa núumacué pirí, núa ìyéerica chái pèewi, cachàiníirica núa templo íicha. ");
INSERT INTO pioNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Càmitacué péemìa càinácaalí íimáaná áiba tàacáisi profeta Oseas itànèericaté Dios inùmalìcuíse. Dios íimacaté: ‘Ewitacué pinúacáaníta madécaná pipìrawa iyúwa sacrificio pìacaténácué nucàaluíniná, càicáaníta caná iwèni meedá nuicáca yái culto pimàníiricuécasa nulí càmicaalícáwa piicáca áibanái ipualé, piyúudàacaténá nía’, íimaca yái Diosca. Báisícaalícué péemìacaté càinácaalí íimáaná yái tàacáisicatá, yá càmitacué picháawàa naináwaná ìwali báawéeri iyútá, níái nuéwáidacaléca càmíiyéica imàni ibáyawanáwa. ");
INSERT INTO pioNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Iná Dios idéca ichùulìaca núa, asìali Dios néeséerica, numàacáanápiná nùasu wenàiwica namànica càide iyúwa nuwàwáaná, èeri imanùbaca, yái sábado nacái wayamáidacatáicawa, wía judíoca —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Néeseté Jesús yàacawa, yá iwàlùacawa judíonái yéewáidacàalu irìculé, ìyéerica néré. ");
INSERT INTO pioNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Iyacaté néeni abéeri asìali icáapi ituwièricawa íicha. Abénaméeyéi fariseo naicáidaca Jesús irí naicácaténá asáisí imànicaalípináté áiba wawàsi náaliméerica nacháawàaca iináwaná ìwali ìwalíise, fariseonái náimacáináté íibaidacalésicani yái Jesús ichùnìanáca wenàiwicanái. Iná nasutáca néemìawani, náalimáidacaténá naicáwani. Yá náimaca Jesús irí: —‍Wawàwa wáalíacawa càinácaalí píináidacawa. ¿Dios imàacasica wachùnìaca cáuláiquéeyéi wenàiwica sábado irìcu wayamáidacatáicawa? —‍náimaca náalimáidaca naicáwa Jesús. ");
INSERT INTO pioNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Néese Jesús íimaca nalí: —‍Péemìacué comparación: Pidènìacaalícué pipìrawa oveja, néese yúuwàacaalíwa utàwi nacáichúa irìculé namusúadacatáise úni, ¿càmitasicué pimusúadacani caquialéta, éwita sábado irìcucáaníta, yái èeri wayamáidacatáicawa? ");
INSERT INTO pioNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Néeni, máiníiri cawènica wenàiwica oveja íicha. Iná ¿cánácué càmita píalíawa Dios imàacaca wamànica cayábéeri áibanái irí siùca sábado irìcu? —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Néese Jesús íimaca irí yái asìali icáapi ituwièricawa íicha: —‍Piducúa picáapiwa —‍íimaca yái Jesúsca. Yá asìali iducúaca icáapiwa, yáta cayábaca icáapi càide iyúwa abéemàa icáapi. ");
INSERT INTO pioNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Quéwa fariseonái namusúacanacáitawa judíonái yéewáidacàalu íicha, yá nadàbacaté náináidacawa càinápinácaalíté iyú náalimáaná nanúaca Jesús. ");
INSERT INTO pioNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Néeseté Jesús yáalíacawa náiwitáise nawàwáanáté nanúacani, yá Jesús yàacawa náicha, manùba quéwa wenàiwica yàacawa yáamiwáise. Jesús ichùnìaca macáita cáuláiquéeyéi wenàiwica yàanèeyéicaté yàatalé. ");
INSERT INTO pioNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Yá yàalàaca nía cachàiníiri iyú ipíchaná nacàlidaca iináwaná ìwali manùbéeyéi wenàiwica irí ichùnìanáté nía. ");
INSERT INTO pioNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Càité Jesús imànica càide iyúwaté profeta Isaías icàlidáanáté tàacáisi Jesús iináwaná ìwali Dios inùmalìcuíse. Dios íimacaté: ");
INSERT INTO pioNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Yácata nùasu wenàiwica íibaidéerica nulípiná, nuedéerica íibaidáanápiná nulí. Yácata cáininéerica nuicáca, yácata casíimáirica nuicáca. Yá numàacapiná irí Espíritu Santo icùacaténá íiwitáise. Yá icàlidapiná nutàacái càmíiyéi israelita irí, náalíacaténáwa nuwàwaca nàyaca machacàníiri iyú. ");
INSERT INTO pioNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Càmita itàanípiná ùuléeri tàacáisi iyú, càmita nacái yéemíanícawa. Canáca nacái yéemièri itàacái imáidáidáaná cachàiníiri iyú calle irìcubàa bamuchúami yàcalé. ");
INSERT INTO pioNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Imànipiná cayábéeri machawàaquéeyéi irí, iicápiná nacái napualé, cawinácaalí iwàwéeyéica yéetácawa, àta imawènìadacataléta macáita báawéeri. ");
INSERT INTO pioNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Càmíiyéi israelita yeebáidapiná itàacái, yàasu wenàiwica nacái nía”, íimaca yái Diosca. ");
INSERT INTO pioNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Néeseté natéca matuíri asìali Jesús yàatalé, abéeri matuíri, matàacáiri, demonio idacùacáiná íiwitáise. Yá Jesús yúucaca demonio asìali íicha, íná catuíca àniwani, itàaní nacái àniwa. ");
INSERT INTO pioNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Néese macáita wenàiwica náináidacawa manuísíwata naicáidaca Jesús irí. Yá nasutáca néemìawa níawáaca: “¿Yátasica rey David itaquérinámi, Dios ibànuèrica wacuèrinápiná, wía judíoca?” náimaca nalíwáaca. ");
INSERT INTO pioNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Néese fariseonái néemìacáináni, yá náimaca nalí: “Yái asìali Jesúsca idènìaca Beelzebú íiwitáise, yái demonio íiwacalináca. Iná yéewa Jesús yúucaca demonio wenàiwica íicha Beelzebú íiwitáise iyú”, náimaca Jesús ìwali. ");
INSERT INTO pioNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Jesús yáalíacawa náináidáanáwa. Iná íimaca fariseonái irí: “Péemìacué comparación: Wenàiwicanái ipéliacaalí íipunitawáaca, yásí nàasu cáli imáalàacawa. Càita nacái yàcalé mìnanái, áibanái néenánái nacái napéliacaalí náipunitawáaca, néese càmita náalimá nàyaca náapichawáaca. ");
INSERT INTO pioNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Càita nacái, canácatáita Satanás yúuca yàasu demonionáiwa wenàiwica íicha. Satanás yúucacaalí demonio wenàiwica íichatá, yá ipéliaca meedá yáawatá. Yásí imáalàacawa nacái yái ichàinicatá, yái Satanásca. Iná ¿cánácué càmita píalíawa càmita núuca demonio wenàiwica íicha Satanás íiwitáise iyú? ");
INSERT INTO pioNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Pidécuéca píimaca núucacasa demonio wenàiwica íicha Beelzebú íiwitáise iyú. Picháawàacaalícué nuináwaná ìwali cài mamáalàacata, yásí iwàwacutácué picàlidaca nulíni cawinácaalí ichàini iyú péewáidacalénáicué náucaca demonio wenàiwicanái íicha. Píalíacuéwa càmita náuca demonio Beelzebú íiwitáise iyú. Iná níata péewáidacalécuéca náasáidaca càmitacué picàlida nuináwaná ìwali báisíiri iyú. ");
INSERT INTO pioNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Núucaca demonio wenàiwica íicha Espíritu Santo íiwitáise iyú, íná nudéca núasáidacuéca pirí Dios icùaca abéechúanaméeyéi wenàiwica pèewibàa. ");
INSERT INTO pioNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Núucaca demonio wenàiwica íicha nuíwitáise iyúwa, cachàinicáiná núa Satanás íicha. Péemìacué áiba comparación: Càide iyúwa cayéedéeri ìyáaná, càmita cayéedéeri yáalimá iwàlùacawa irìculé áiba cachàiníiri asìali icapèeca iyéedùacaténá íicha yàasu, càmicaalícáwa cayéedéeri idacùa íichawa yái cachàiníiri asìalica quéechacáwa. Iwàwacutá cayéedéeri imànica cài, yéewacaténá iyéedùaca cachàiníiri asìali yàasu. Càita nacái núalimá nudacùaca nuíchawa Satanás nuwasàacaténá íicha wenàiwica. Pidécuéca pitàaníca báawéeri iyú Espíritu Santo ìwali. ");
INSERT INTO pioNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Píacué càmíiyéica abédanamata íiwitáise núapicha, piùwidecuéca pimànica núa; càmitacué piyúudàa nùwacáidaca wenàiwica Dios irípiná, néese piyúudàacuéca Satanás iméeràidacaténá wenàiwica Dios íicha meedá. ");
INSERT INTO pioNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","“Iná péemìacué cayába. Dios imàacapiná iwàwawa íichéi macái íiwitáaná báawéerica wenàiwica imàníirica, itàaníirica nacái Dios ìwali báawéeri iyú, nawènúadacaalí náiwitáisewa nabáyawaná íichawa. Quéwa wenàiwica itàanícaalí báawéeri iyú Espíritu Santo ìwali, yá canácatáita Dios imàaca iwàwawa ibáyawaná íicha. ");
INSERT INTO pioNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Aibacaalí itàaní báawéeri iyú nùwali, núa asìali Dios néeséerica, néese iwènúadacaalí íiwitáisewa Dios irípiná àniwa, yásí Dios imàacaca iwàwawa ibáyawaná íicha. Quéwa itàanícaalí báawéeri iyú Espíritu Santo ìwali, néese càmita quirínama Dios imàaca iwàwawa ibáyawaná íicha chái èeri irìcu, càmita nacái wàlisàipiná èeri irìcu”, íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Jesús íimacaté fariseonái irí: “Péemìacué comparación: Cayábéeri àicu yàaca walí cayábéeri yàacàsi. Báawéeri àicu idènìaca ìyacanáwa báawéeri. Càita wáalíacawa macái àicu ìwali. Càita nacái píalimácué píalíacawa nùwali piicácáiná càinácaalí numànica. ");
INSERT INTO pioNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","¡Píacué càiyéide iyúwa àapi iculále! Càide iyúwa àapi imusúadáaná iculálewa inùma irìcuísewa, càita nacái càmitacué píalimá pitàaníca cayábéeri wawàsi ìwali báawacáinácué píiwitáise. Iná yái báawéeri tàacáisi pitàaníiricuéca, pidécuéca pimusúadacani piwàwalìcuísewa, yácáinácué piwàwa idéca ipuníacawa báawéeri tàacáisi iyú. ");
INSERT INTO pioNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Cayábacaalí wenàiwica íiwitáise, yásí itàaníca nacái cayábéeri wawàsi ìwali, yácáiná íiwitáise cayábéeri ìyaca iwàwalìcu. Càita nacái báawacaalí wenàiwica íiwitáise, yásí itàaníca báawéeri wawàsi ìwali, yácáiná íiwitáise báawéeri ìyaca iwàwalìcu. ");
INSERT INTO pioNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Núumacué pirí, Dios yùuwichàidapiná báawéeyéi wenàiwica èeri imáalàacaalípináwa, yá yùuwichàidapiná nía ìwalíise macái tàacáisi canéerica iwèni náiméericaté. ");
INSERT INTO pioNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Càide iyúwa pitàaníiná, yásí Dios iicáanáca pía, yácáiná pitàacái yáasáidaca càinácaalí píiwitáise. Pitàanícaalí cayábéeri wawàsi ìwali, yásí cayábaca Dios iicáca pía iyúwa mabáyawanéeri, cayábacáiná píiwitáise, yá càmita Dios yùuwichàidapiná pía. Quéwa pitàanícaalí báawéeri wawàsi ìwali, yá báawaca Dios iicáca pía, cabáyawanéeri, báawacáiná píiwitáise, yá Dios yùuwichàidapiná pía”, íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Néeseté abénaméeyéi fariseo, áibanái nacái yéewáidéeyéica wenàiwica templo irìcu náimaca Jesús irí: —‍Pía, yéewáidéerica wenàiwica, wawàwa waicáca pimànica wawàsi càmíirica wenàiwica idé imànica —‍náimaca. ");
INSERT INTO pioNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Jesús íimaca nalí: —‍Píacué báawéeyéica íiwitáise, píacué nacái iwènúadéeyéica íiwitáisewa Dios íicha, pidécuéca pisutáca nuícha numàníinápiná piicá yái càmíirica wenàiwica idé imànica, quéwa càmita numànicué pirí càiri wawàsi. Numàacacáita piicáca numàníinápiná càide iyúwaté profeta Jonás ìyáanáté. ");
INSERT INTO pioNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Càide iyúwaté Jonás iyamáanátéwa manuíri cubái idèerìcu máisiba èeri, càita nacái núa asìali Dios néeséerica nùyapiná cáli irìcu máisiba èeri. ");
INSERT INTO pioNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Níara càmíiyéica israelita ìyéeyéicaté Nínive ìyacàlená irìcu namichàapinácawa yéetácáisi íicha èeri imáalàacaalípináwa Dios yùuwichàidacaalípiná báawéeyéi wenàiwica. Nabàlùapináwa Dios íipunita yéewacaténá Dios icàlidaca naináwaná ìwali, càinácaalí báawéeri namàníiricaté. Píacué israelita ìyéeyéica siùcade pimichàapinácué nacáiwa. Yásí Nínive ìyacàlená mìnanáimi nacháawàacuéca piináwaná ìwali, bàaluitécáiná Nínive mìnanái nawènúadaca náiwitáisewa Dios irípiná néemìacáináté profeta Jonás icàlidaca nalí tàacáisi Dios inùmalìcuíse. Néese, éwita nùyacáaníta pèewibàa siùcade, núa cachàiníirica íiwitáise profeta Jonás ichàini íicha, càicáaníta càmitacué peebáida nulí. Iná cabáyawanácuéca Dios iicáca pía. ");
INSERT INTO pioNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Ua nacái Sur yàasu cáli íiwacalumi càmíichúa israelita umichàapinácawa yéetácáisi íicha ucháawàacaténácué piináwaná ìwali, píacué israelitaca èeri imáalàacaalípináwa Dios yùuwichàidacaalípiná báawéeyéimi. Bàaluitécáiná ùanàaca máiní déecuíse chái wàasu cáli íinatalépiná uémìacaténáté rey Salomón itàacái máiní cáalíacáica, úalíacáinátéwa Dios imàacacaté Salomón icàlidaca tàacáisi cáalíacáiri iyú. Quéwa éwita nùyacáanítacué pèewibàa, núa cachàiníirica íiwitáise rey Salomón ichàini íicha, càicáaníta càmitacué peebáida nulí. Iná cabáyawanácuéca Dios iicáca pía —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Jesús íimaca nalí: “Demonio yàacaalíwa wenàiwica íicha, yásí demonio iméeràacawa chuìri cáli íinata, yá icutáca iyamáacatáipináwa. Càmicaalí demonio yàanàa iyamáacatáipináwa, yásí íimaca íináidacawa iríwa: ");
INSERT INTO pioNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","‘Nuèpùacawa àniwa nucapèe néréwa yáara wenàiwica nudécatáiseca nùacawa íicha’, íimaca iríwa. Néese demonio yèepùacawa àniwa, yásí demonio yàanàaca wenàiwica cáiwitáiséeri càide iyúwa cayábéeri capìi máiséeri natunuérica, nachùnièrica nacái cayába. ");
INSERT INTO pioNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Néese demonio yàaca ìwacáidaca yáapichawa siete namanùbaca demonio máiníiyéi báawaca íicha. Yá macáita nawàlùacawa wenàiwica iwàwalìculé, nadacùacaténá íiwitáise. Yásí namànica irí báawéeri máiní íicha yái báawéerica idàbáanéeri demonio imàníiricaté irí quéechacáwa. Càita nacái píacué wenàiwicaca báawéeyéica piùwichàapinácuécawa máiní cachàiníiri íicha yái quéechéericaté piùwichàanácuécawa”, íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Idècunitàacá Jesús icàlidaca wenàiwicanái iríni, néese yáatúa yàanàaca néré, Jesús yéenánái yáapicha nacái, nawàwacáináté natàaníca Jesús yáapicha. Quéwa nabàlùacawa bàacháwáise capìi íicha. ");
INSERT INTO pioNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Iná áiba íimaca Jesús irí: —‍Píatúa, péenánái nacái nabàlùacawa bàacháwáise. Nawàwa natàaníca píapicha —‍íimaca. ");
INSERT INTO pioNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Quéwa Jesús íimaca irí yái asìali icàlidéerica irí naináwaná: —‍Péemìa yái núumáanáca núatúa ìwaliwa, nuénánái ìwali nacáiwa —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Néese Jesús iicáidaca walí wía yéewáidacaléca ìyéeyéica yáapicha, yá imichàidaca icáapiwa wapualé. Yá íimaca: —‍Níái wenàiwicaca nuicáca nía iyúwa núatúanáiwa, nuénánái nacáiwa. ");
INSERT INTO pioNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Yácáiná cawinácaalí wenàiwica imàníirica càide iyúwa Núaniri Dios chènuníiséeri iwàwáaná, yácata nuiquéerica càide iyúwa nuénásàiriwa, nuénásàatúa nacáiwa, núatúa nacáiwa —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Néeseté yáta èericaté Jesús imusúacawa capìi íicha yàacaténáwa Galilea icalìsaniná néré. Yá yáawinacawa càina íinata. ");
INSERT INTO pioNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Yá máiní manùbaca wenàiwicanái nàwacáidáyacacawa yàatalé, íná Jesús iwàlùacawa barca irìculé, yá yáawinacawa barca irìcu. Níái manùbéeyéi wenàiwicaca nayamáacawa càina íinatata. ");
INSERT INTO pioNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Néese Jesús yéewáidaca nía manùba comparación iyú. Yá íimaca nalí: “Abéeri asìali ibàna yàacawa ituínási. Yá yàacawa càide iyúwa náiwitáise nabànáaná ituínási, yá yàaca icasáaca yàacawa bànacalé. ");
INSERT INTO pioNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Yàaca icasáaca yàacawa, yá abénaméeyéi ituínási yúuwàacawa àyapulìcubàa, yá màsibèe yàanàaca néré, yá nayáaca íimi. ");
INSERT INTO pioNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Aiba ituínási yéená yúuwàacawa cáli íinata íba yèewiré, canácatáica cayába cáli ibaníiri. Yá bànacalé íimi ibacácawa ráunamáita, càmicáiná ibaní néeni cáli. ");
INSERT INTO pioNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Néese èeri imusúacawa, yá icànaca cachàini, yeemáca yái bànacalé, yá chuìcani canácáiná ipìchu cayába cáaléeri, íná yéetácawa. ");
INSERT INTO pioNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Aiba ituínási yéená yúuwàacawa tuíri yèewiré. Yá idàwinàacawa tuíri yáapicha, quéwa tuíri idàwinàacawa dàalawaca bànacalé yèewibàa, càmita ibatàa bànacalé idàwinàacawa cayába. ");
INSERT INTO pioNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Quéwa áiba ituínási yéená yúuwàacawa cayábéeri cáli íinata. Idàwinàacanáamiwa, yá idènìaca ìyacanáwa manùba. Abénaméeyéi yéetaná nadènìaca natuínáwa cien namanùbaca, áibanái yéetaná nadènìaca natuínáwa sesenta namanùbaca, áibanái nacái nadènìaca treinta namanùbaca ituíná. ");
INSERT INTO pioNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Càuwíiyéicaalícué pía, péemìacué nutàacái”, íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Néeseté wía Jesús yéewáidacaléca wàacawa Jesús yàatalé, yá wasutáca wéemìawani cáná yéewa icàlidaca wenàiwicanái iríni comparación iyú. ");
INSERT INTO pioNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Jesús íimaca walí: “Dios imàacacué píalíacawa càinácaalí iyú icùaca yàasu wenàiwicawa. Càmita imàaca áibanái yáalíacawa, níái manùbéeyéi càmíiyéica yeebáida itàacái. ");
INSERT INTO pioNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Wenàiwica íináidacaalíwa cayába nutàacái ìwali, yá nacái yéemìacaalí càinácaalí íimáaná, yásí Dios imàacaca yáalíacawa mamáalàacata. Quéwa áibacaalí wenàiwica càmita íináidawa cayába nutàacái ìwali, yásí iimáicha nacái yái achúméerica yáaliéricatéwa ìwali. ");
INSERT INTO pioNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Iná nuéwáidacáita nía comparación iyú, níacáiná éwita naicácáaníta numànica yái càmíirica wenàiwica idé imànica, càicáaníta càmita nawàwa náalíacawa nùwali, cawinácaalí núa. Ewita néemìacáaníta nutàacái nàuwi iyúwa, càicáaníta càmita nawàwa néemìaca càinácaalí íimáaná yái nutàacáica. ");
INSERT INTO pioNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Iná nàyaca càide iyúwaté profeta Isaías icàlidáaná tàacáisi Dios inùmalìcuíse. Dios íimacaté israelitanái irí: ‘Ewitacué péemìacáaníta mamáalàacata piùwi iyúwa, càicáanítacué canácatáita píalíapinácuéwa càinácaalí íimáaná. Ewitacué piicácáaníta madécaná wawàsi pituí iyúwa, càicáanítacué canácatáita píalíapináwa càinácaalí íimáaná yái piiquéericuéca’, íimaca yái Diosca. ");
INSERT INTO pioNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Néeseté Dios íimaca israelitanái ìwali: ‘Níái wenàiwicaca, Israel itaquénáinámi, cadapùleca náiwitáise, cadapùleca neebáca nutàacái. Màuwica nía, càmíiyéi iwàwa yéemìaca nutàacái. Nadéca naimáidaca natuíwa, càmíiyéi iwàwa yáalíacawa càinácaalí íimáaná yái nutàacáica, ipíchaná nawènúadaca náiwitáisewa báawéeri íicha nuwasàacaténá nía nùasu yùuwichàacáisi íichawa’, íimaca yái Diosca. ");
INSERT INTO pioNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Quéwa píacué nuéwáidacaléca, Dios imànicuéca pirí cayábéeri manuísíwata píalíacáinácué piicáca yái piiquéericuéca pituí iyúwa, pidécué nacái péemìaca càinácaalí íimáaná yái tàacáisi péemièricuéca piùwi iyúwa. ");
INSERT INTO pioNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Péemìacué cayába, madécaná profetanái, áibanái nacái cayábéeyéi íiwitáise nawàwacaté naicáca núa, yái piiquéericuéca, quéwa càmitaté naicá núa. Nawàwacaté nacái néemìaca yái nutàacái péemièricuéca, quéwa càmitaté néemìani”, íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Jesús íimaca walí: “Péemìacué yái íimáanáca, yái comparación ibànéeri ìwali. ");
INSERT INTO pioNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Cawinácaalí wenàiwica yéemièyéica càinácaalí iyú Dios icùaca yàasu wenàiwicawa, quéwa càmita neebáidani, càica níade iyúwa bànacalé yúuwèericawa àyapulìcubàa. Yá Satanás yàanàaca, yá imàacaca naimáichaca Dios itàacái. ");
INSERT INTO pioNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Yái ituínási yúuwèericawa cáli íinata íba yèewiré íimáanáca càicanide iyúwa wenàiwica néemìacaalí Dios itàacái, yá neebáidacani casíimáiri iyú. ");
INSERT INTO pioNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Néeseta quéwa, càmicáiná neebáida Dios itàacái báisíiri iyú, macái nachàini iyúwa, càide iyúwa canácaalí bànacalé ipìchu cayába, íná neebáida itàacái maléená èeri, càide iyúwa bànacalé yéetácaalíwa ráunamáita. Iná nadàbacaalí nàuwichàacawa Dios irípiná, neebáidacáiná itàacái, Satanás nacái yáalimáidacaalí nía namàníinápiná nabáyawanáwa, yásí nayamáidaca neebáidaca Dios itàacái. ");
INSERT INTO pioNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Yái bànacaléca yúuwèericawa tuíri yèewiré íimáanáca càicanide iyúwa wenàiwica néemìacaalí Dios itàacái, náináidacawa nacái ìwali, quéwa báawaca náináidacawa nawàwawa báawanama abéerita nàasu ìwaliwa, chái èeri irìcuírica. Cáininá nacái naicáca nàasu cawèníiriwa, nawàwacáiná càasuca nía. Macáita yái chái èeri irìcuírica ichìwáidaca nía, càmita ibatàa namànica càide iyúwa Dios iwàwáaná. Càide iyúwa bànacalé idàwinàacaalíwa báawata, quéwa canácatáita cayàcanáni, càita nacái níái wenàiwicaca. Neebáca Dios itàacái báawatata, càmíirita quéwa nawàwalìcuísewa, íná càmita máiní namàni cayábéeri càide iyúwa Dios iwàwáaná. ");
INSERT INTO pioNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Quéwa yái bànacaléca yúuwèericawa cayábacatái cáli íimáanáca càicanide iyúwa wenàiwica néemìacaalí Dios itàacái, yá neebáidacani tài íiméeri iyú. Yá namànica cayábéeri càide iyúwa bànacalé idènìacaalí mamáalàacata ìyacanáwa cayábéeri. Abénaméeyéi namànica cayábéeri manuísíwata càide iyúwa bànacalé idènìacaalí cien namanùbaca ìyacanáwa, macái yéetaná imanùbaca. Aibanái namànica cayábéeri càide iyúwa bànacalé idènìacaalí sesenta namanùbaca ìyacanáwa, macái yéetaná imanùbaca. Aibanái namànica cayábéeri càide iyúwa bànacalé idènìacaalí treinta namanùbaca ìyacanáwa, macái yéetaná imanùbaca”, íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Néeseté Jesús yéewáidaca nía àniwa comparación iyú. Iimaca nalí: “Péemìacué càinácaalí iyú Dios icùaca yàasu wenàiwicawa. Iyaca càide iyúwa asìali ibànacaalí yèepunícawa ibànacalewa. Ibànaca cayábanaméerita trigo ituíná. ");
INSERT INTO pioNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Néese táiyápi, yái bànacalé íiwacali yùuwide yàanàaca trigo ibànacalená yùuculé, yá ibànaca manùba báawéeri masicái íimi trigo nacáiri iicácanáwa, cayábéeri trigosíwa íinatabàa. Yá yèepùacawa íicha, yái yùuwideca. ");
INSERT INTO pioNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Iná yéewa macáita nadàwinàacawa, néese nadènìacaalí nàyacanáwa, átata báawanaméeri masicái yáasáidaca ìyacanáwa báawéeri meedá. ");
INSERT INTO pioNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Néese bànacalé íiwacali yàasu wenàiwica naicáca báawéeri masicái, yá nàacawa náiwacali yàataléwa nacàlidacaténá iríni yàasu bànacalé iináwaná ìwali. Náimaca irí: ‘Wáiwacali, pibànacaté cayábanaméerita ituínási. ¿Síisáaná yàanàa yái báawéeri bànacaléca imusuéricawa yèewibàa?’ náimaca. ");
INSERT INTO pioNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Yá náiwacali íimaca nalí: ‘Nùuwidequéera cài ibànaca néenibàa báawanaméeri ituínási trigosíwa yèewibàa’, íimaca nalí. Néese yàasu wenàiwicanái íimaca irí: ‘¿Piwàwasica wàaca wacacàaca íicha yái báawéerica?’ náimaca irí. ");
INSERT INTO pioNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","30","Quéwa náiwacali íimaca nalí: ‘Càmíirita. Picácué picacàa yái báawanaméerica, ipíchanácué picacàaca yáapichata yái cayábéeri trigoca. Tàacá idàwinàacawa abédanamata trigo yáapicha àta weedácatalépináta yái bànacaléca trigoca. Néese yàasu èeri tàacáwa, nuchùulìapiná nùasu wenàiwicawa yeedéeyéi bànacalé ìyacaná needáanápiná yái báawéerica bànacaléca quéechacáwa, nadacùadáanápiná ibàpi iyúnama nía, yéewanápiná weemáca nía. Néese nuchùulìapináca needáanápiná yái cayábéeri trigoca nùasu manuíri capìi irìculé, trigo ituíná yàalu’, íimaca yái bànacalé íiwacalica”, íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Néeseté Jesús yéewáidaca wenàiwicanái áiba comparación iyú. Yá íimaca nalí: “Péemìacué càinácaalí iyú Dios icùaca yàasu wenàiwicawa: Yái Dios icùanáca yàasu wenàiwicawa, càicanide iyúwa mostaza íimi, asìali ibànéerica ibànacale yèewiwa. ");
INSERT INTO pioNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Ewita achúméeríinacáaníta yái mostaza íimica, càicáaníta idécanáami idàwinàacawa, yá manuícani macái bànacalé íicha, yá idàwinàacawa manuícani iyúwa àicusíwa. Iná yéewa màsibèe nàanàaca namànica namùlubèwa mostaza yéetaná yàana íinata”, íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Jesús yéewáidaca nía àniwa comparación iyú. Yá íimaca nalí: “Yái Dios icùanáca yàasu wenàiwicanáiwa càicanide iyúwa levadura ìyáaná. Inanái yèewìadaca levadura máisibàawiríacatái harina yèewi, àta macáita íbesi inísàacawa”, íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Jesús yéewáidaca wenàiwicanái macái wawàsi ìwali comparación iyú. Yéewáidaca níái manùbéeyéi wenàiwicaca comparación yáawami iyúta. ");
INSERT INTO pioNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Jesús yéewáidaca nía cài imànicaténá càide iyúwaté Dios yàasu profeta icàlidáanáté tàacáisi Jesús inùmalìcuíse. Yáté Jesús íimaca: “Nucàlidapiná nalíwani comparación iyúwa; nucàlidapiná nalí manùba wawàsi ìwali, càmíiyéicáwa wenàiwica yéemìa iináwaná ìwali, Dios idàbacatáiseté èeriquéi àta siùca nacáide”, íimaca. ");
INSERT INTO pioNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Néeseté Jesús isutáca náicha wawàsi nèepùanápináwa nacapèe néréwa, níái manùbéeyéi wenàiwicaca. Yá Jesús iwàlùacawa capìi irìculé wáapicha, wía yéewáidacaléca. Néese wàacawa Jesús yàatalé. Wasutáca wéemìawani càinácaalí íimáaná yái tàacáisi icàlidéerica walí báawéeri masicái ìwali. ");
INSERT INTO pioNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Yá Jesús íimaca walí: “Núa, asìali Dios néeséerica, núacata yái ibànéerica cayábéeri ituínási. ");
INSERT INTO pioNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Yái bànacalé yàalupináca íimáanáca càicanide iyúwa chái èeriquéi. Yái cayábéeri ituínásica íimáanáca càicanide iyúwa Dios yàasu wenàiwica, yeebáidéeyéica itàacái. Yái báawéeri masicáica íimáanáca càicanide iyúwa báawéeri Satanás yàasu wenàiwica. ");
INSERT INTO pioNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Yái nùuwide ibànéerica báawéeri masicái, yácata Satanás. Yáta nacái èerica needácatáipináca bànacalé ìyacaná, yácata èeripiná imáalàacatáipinácawa yái èeriquéi. Níái yeedéeyéica bànacalé ìyacaná, níacata Dios yàasu ángelnái. ");
INSERT INTO pioNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Càide iyúwa needácaalí báawéeri masicái, neemáanápiná nía quichái irìcu, càipiná nacái ìyaca imáalàacaalípináwa yái èeriquéi. ");
INSERT INTO pioNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Núa, asìali Dios néeséerica, nuchùulìapiná nùasu ángelnáiwa nàwacáidáanápiná nùasu wenàiwicanái nèewíise macáita ichìwáidéeyéica wenàiwica namàníinápiná nabáyawanáwa, nía nacái imàníiyéica ibáyawanáwa mamáalàacata. ");
INSERT INTO pioNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Néese nùasu ángelnáiwa yúucapiná báawéeyéi wenàiwica manuíri quichái irìculéwa. Néré wenàiwica náicháanípiná, yá naamíapiná nayéiwa nàuwichàacái iyúwa. ");
INSERT INTO pioNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Cawinácaalí imàníiyéica cayábéeri càide iyúwa Dios ichùulìaná, nacànapináwa mèlumèluíri iyú càide iyúwa èeri icamaláná Wáaniri Dios ìyacàle irìcuwa. Càuwíiyéicaalícué pía, péemìacué cayába nutàacái”, íimaca walí yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Jesús yéewáidacaté wía àniwa comparación iyú. Yá íimaca walí: “Yái Dios icùanáca yàasu wenàiwicawa ìyaca càide iyúwa cawèníiri wawàsi, áibanái wenàiwica ibèericaté cáli irìculé. Néese asìali yàanàacani, yá ibàlìaca àniwani. Néese, casíimáiri iyú, yàaca iwéndaca macáita yàasumiwa, yá iwènìaca iríwa yái cáli bànacalé yàalupináca”, íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Jesús yéewáidaca wía àniwa comparación iyú. Yá íimaca walí: “Yái Dios icùanáca yàasu wenàiwicawa ìyaca càide iyúwa cacharrerosàiri, icutéerica yàacawa perla púubéeyéi íba cayábanaméeyéi cawèníiyéi. ");
INSERT INTO pioNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Néese asìali yàanàaca perla máiní yáwanáichúa cawènica, yá yàaca iwéndaca macáita yàasumiwa, néese iwènìaca iríwa úái perla cawèníichúa yáwanáica”, íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Néeseté Jesús yéewáidaca wía àniwa comparación iyú. Iimaca walí: “Yái Dios icùanáca yàasu wenàiwicawa ìyaca càide iyúwa chinchorro náibèeri iyú cubái. Yá asìanái yúucaca chinchorro manuíri úni yáaculé. Yá náibàaca macái cubái íiwitáaná. ");
INSERT INTO pioNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Idécanáami ipuníacawa yái chinchorroca, yá asìanái iwatàidacani úni yáacuíse càina íinatalépiná. Yá náawinacawa nacutáca nèewíise níái cayábanaméeyéi cubáica. Needáca cayábanaméeyéi cubái nàalu irìculéwa. Quéwa náucaca náichawa méetàuculé níái báawanaméeyéica cubáica. ");
INSERT INTO pioNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Càita nacái èeri imáalàacaalípináwa, yásí ángelnái namusúacawa chènuníise naseríacaténá báawanaméeyéi wenàiwica cayábéeyéi wenàiwica íicha. ");
INSERT INTO pioNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Yá náucapiná báawéeyéi wenàiwica manuíri quichái irìculé. Néré wenàiwica náicháanípináca, naamíapiná nacái nayéiwa nàuwichàacái iyúwa”, íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Néeseté Jesús isutáca yéemìawa wía: —‍¿Péemìasicué càinácaalí íimáaná yái tàacáisi nucàlidéericuéca pirí? —‍íimaca walí yái Jesúsca. Néese wáimaca irí: —‍Báisíta, Wáiwacali, wáalíacawa càinácaalí íimáaná —‍wáimaca irí. ");
INSERT INTO pioNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Néese Jesús íimaca walí: —‍Péemìacué comparación: Abéeri yéewáidéeri wenàiwica templo irìcu, idécanáami yéewáidacawa càinácaalí iyú Dios icùaca yàasu wenàiwicawa, càide iyúwa nucàlidáaná, yásí yáalimá yéewáidaca wenàiwica Dios itàacái bàaluisàimi iyú, wàlisài iyú nacái, càide iyúwa capìi íiwacali imusúadacaalí yàasu cawèníiriwa icuèrica icapèe irìcuwa, yái cawèníiri bàaluisàimica, yá nacái cawèníiri wàlisàica —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Néeseté Jesús idécanáamité icàlidaca níái comparaciónca, yá yàacawa. ");
INSERT INTO pioNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Yá yàanàaca yàasu cáli néréwa, Nazaret ìyacàlenáca. Néese idàbaca yéewáidaca wenàiwicanái judíonái yéewáidacàalu irìcu, ìyéerica Nazaret ìyacàlená irìcu. Níái wenàiwicaca náináidacawa manuísíwata néemìaca icàlidáaná nalíni. Yá náimaca nalíwáaca: —‍Canáca yéewaná yéewáidaca wía. Càmita báisí imàni yái càmíirica wenàiwica idé imànica. ");
INSERT INTO pioNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Yácata ìirimi meedá yámide yàalubáisi imàníirinámica. María ìirica meedáni. Nabèerica meedáni, níái Santiago, José nacái, Simón nacái, Judas nacái. ");
INSERT INTO pioNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Yéenánái inanái nàyaca wèewibàa meedá. Icàlidacáita áibanái yàasu tàacáisi meedá, càmicáiná yáalíawa cayába —‍náimaca. ");
INSERT INTO pioNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ináté càmita nawàwa neebáidaca Jesús itàacái. Quéwa Jesús íimaca nalí: —‍Batéwa macái wenàiwica naicáca profeta cáimiétaquéeri iyú icàlidéerica tàacáisi Dios inùmalìcuíse. Níawamita yàasu cáli néeséeyéi, yéenánái nacái, icapèe irìcuíyéi nacái, níawamita càmita nawàwa neebáidaca itàacái. Càita nacái nùasu cáli néeséeyéi, nuénánái nacái, nucapèe irìcuíyéi nacái, càmita nawàwa neebáidaca nutàacái —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Càmitaté Jesús imàni néré madécaná yái càmíirica wenàiwica idé imànica, càmicáináté neebáida itàacái. ");
INSERT INTO pioNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Néenialíté rey Herodes, yái romanosàiri icuèricaté Galilea yàasu cáli, yéemìaca wenàiwicanái icàlidaca Jesús iináwaná ìwali. ");
INSERT INTO pioNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Yá Herodes íimaca yáapichéeyéi iríwa: “Yácata Juan el Bautistami, Juancáiná idéca imichàacawa yéetácáisi íicha. Iná yéewa yáalimá imànica yái càmíirica wenàiwica idé imànica”, íimaca yái rey Herodesca, iyúunáidacáiná Juan el Bautistamicani, yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Càica Herodes íimaca ichùulìacáináté yàasu úwináiwa náibàanápináté Juan nadacùacaténáni cadena iyú, yá natéca náucacani presoíyéi ibànalìculé. Herodes imànicaté cài isíimáidacaténá yàacawéetúawa Herodías, caluéchúa iicáca Juan. Uái Herodíasca, úacata Herodes yéenásàiri Felipe yàacawéetúa quéechatécáwa, quéwa Herodes imelùdacaté úa yéenásàiri íichawa. ");
INSERT INTO pioNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Ináté Juan yàalàaca rey Herodes. Juan íimacaté: “Báawéeriquéi peedáanáca péenásàiri yàacawéetúawa”, íimaca yái Juanca. ");
INSERT INTO pioNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Yá rey Herodes iwàwacaté inúaca Juan isíimáidacaténá yàacawéetúawa Herodías, quéwa cáaluca Herodes iicáca wenàiwicanái iiquéeyéicaté Juan iyúwa profeta itàaníirica Dios inùmalìcuíse. ");
INSERT INTO pioNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Quéwa áiba èerité rey Herodes imànica manuíri fiesta iwàwalicaténá yàasu èeriwa asáicatáicaténi. Yá Herodías íidu iwàlùacawa asìanái iyáacàalu irìculé. Yá ulabàaca báawéeri iyú abéechúata asìanái yàacuésemi naicácaténá úa, níái asìanái rey Herodes imáidéeyéica fiesta néré. Herodes iicácáiná ulabàaca, yá usíimáidaca Herodes iwàwa manuísíwata. ");
INSERT INTO pioNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Iná Herodes íimaca ulí báisí báisísíwatasa Dios yáaliéricawa Herodes yàanápináté ulí càinácaalí wawàsi usutéerica íicha. ");
INSERT INTO pioNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Néese ùacawa utàaníca úatúa Herodías yáapichawa quéechacáwa. Néese úái mànacàuca uèpùacawa rey Herodes yàatalé. Yá úumaca irí: —‍Pìa nulí Juan el Bautista íiwita quírápieli irìcu —‍úumaca, úacáiná úatúa Herodías uwàwacaté uicáca Juan íiwita utuí iyúwa úalíacaténáwa báisíiri iyúcani idéca yéetácawa, yái Juanca. ");
INSERT INTO pioNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Yá achúmaca rey Herodes iwàwa, quéwa iwàwacutácaté imànica càide iyúwa íimáanáté mànacàu irí, níacáiná yáapichéeyéi néemìacaté íimáaná ulí báisí báisísíwatasa Dios yáaliéricawa. Yá Herodes ichùulìaca úwinái nanúanápináté Juan nàacaténáté ulí íiwitami. ");
INSERT INTO pioNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Herodes ichùulìacaté abéeri úwi yàaca iwichùaca Juan íicha íiwita presoíyéi ibànalìcu. Càité Juan yéetácawa. ");
INSERT INTO pioNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Yá natéca Juan íiwitami quírápieli irìcu. Yá nàaca ulíni úái mànacàuca. Néese utécani úatúa yàataléwa. ");
INSERT INTO pioNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Néese Juan yéewáidacalénáimi yàanàaca presoíyéi ibàna néré natécaténá Juan ichéecami. Yá nabàlìacani. Néeseté nàaca nacàlidaca Jesús iríni. ");
INSERT INTO pioNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Idécanáamité Jesús yéemìaca Herodes iyúunáidaca Juan el Bautistamicani, yái Jesúsca, yá Jesús yàacawa barca irìcu abéemàalé Galilea icalìsaniná íicha. Wía yéewáidacaléca wàacawa nacái yáapicha áibalé canácatalé wenàiwica. Quéwa madécaná wenàiwica yáalíacawa Jesús iináwaná ìwali yàanáwa néré, íná nàacawa cáli íinatabàa nérépiná manùba yàcalé íicha. ");
INSERT INTO pioNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Néese Jesús imichàacawa barca íicha, yá iicáca madécaná wenàiwica néré. Catúulécanáca iicáca nía, yá ichùnìaca cáuláiquéeyéi wenàiwica natéeyéica yàatalé. ");
INSERT INTO pioNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Catáca yàacawa wàwali íná wía yéewáidacaléca wáimaca Jesús irí: —‍Catáca yàacawa wàwali chái canácatáica yàcalé. Iná pichùulìa nèepùanápináwa nawènìacaténá nayáapináwa yàcalé irìcu —‍wáimaca irí. ");
INSERT INTO pioNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Jesús íimaca walí: —‍Càmita iwàwacutá nèepùacawa. Píatacué yàa nayáapiná —‍íimaca walí. ");
INSERT INTO pioNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Néese wáimaca irí: —‍Canáca walí nayáapiná. Wadènìaca cinco namanùbaca pan, pucháiba cubái imìdecaná meedá —‍wáimaca irí. ");
INSERT INTO pioNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Jesús íimaca walí: —‍Pitécué nulí nía —‍íimaca walí. ");
INSERT INTO pioNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Yá néese Jesús ichùulìaca náawinacawa masicái íinata macáita níái wenàiwicaca manùbéeyéi. Néese yeedáca cinco namanùbaca pan icáapi irìculéwa, pucháiba cubái imìdecaná nacái. Néese iicáida chènuniré, yàaca Dios irí cayábéeri ìwali yái yàacàsica. Néese isubèriadacani, yàaca walíni wía yéewáidacaléca, yái yàacàsica. Néese wawacùaca nalíni, níái wenàiwicaca. ");
INSERT INTO pioNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Néese macáita nayáaca cadénamani. Yá weedáca doce mapíiri imanùbaca yàacàsi yéenáimi imàaquéericawa. ");
INSERT INTO pioNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Níái iyéeyéicaté yái yàacàsica, cinco mil namanùbaca asìanái. Càmita waputàa inanái, sùmanái nacái iyéeyéicaté iyáacaléwa náapicha. ");
INSERT INTO pioNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Néeseté Jesús ichùulìaca wawàlùanápináwa barca irìculé wía yéewáidacaléca, wachàbacaténáwa ipíchalépiná abéemàalé Galilea icalìsaniná íicha. Iwàwacaté wàacawa ipíchalépiná idècunitàacá imàacaca wenàiwicanái yèepùanápináwa íicha. ");
INSERT INTO pioNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Néese idécanáamité ibànùaca íichawa nía, yá yàacawa dúli íinatalé abéerita isutácaténá yáawawa Dios íicha. Catácanáami ìwali, yá iyamáacawa abéerita néré. ");
INSERT INTO pioNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Quéwa wía yéewáidacaléca wàyaca barca irìcu déeculé cáli íicha. Màladàca yàacawa wàasu barca iwéré cachàini, cáulicáiná ipùa wáipunita. ");
INSERT INTO pioNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Néese táiyápíwanái, amalácaalí yàacawa wawicáu, Jesús yàacawa mawiénita walí, yèepuníiriwa úni inànìacubàa. ");
INSERT INTO pioNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Néese wía yéewáidacaléca waicáca yàacawa úni inànìacubàa, yá cáaluca wía báawanama, càmicáináté wáalía waicácani, yá wéemíanícawa wacalùniwa: —‍¡Iwàwanásimica! —‍wáimaca. ");
INSERT INTO pioNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Yáta Jesús itàaníca walí. Iimaca walí: —‍¡Cayábacani, núaquéi, picácué cáalu pía! —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Néese Pedro íimaca irí: —‍Nuíwacali, báisícaalí píacani, yá pimáida núa nùacaténáwa pìatalé úni inànìacubàa —‍íimaca yái Pedroca. ");
INSERT INTO pioNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Néese Jesús íimaca irí: —‍Aquialé —‍íimaca yái Jesúsca. Néese Pedro imusúacawa barca irìcuíse, yá idàbaca yàacawa yèepunícawa úni inànìacubàa Jesús yàatalépiná. ");
INSERT INTO pioNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Quéwa ipíchawáiseté Pedro yàanàaca Jesús yàatalé, yá iicáca cachàiníiri cáuli ipùaca ìwali, íná cáaluca Pedro íináidacawa iwàwawa. Cáalucanacáitani, yá idàbaca isawíacawa. Iná yéemíanícawa icalùniwa Jesús irí: —‍¡Nuíwacali, piyúudàa núa! —‍íimaca yái Pedroca. ");
INSERT INTO pioNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Yáta Jesús iducúa icáapiwa Pedro irí, yá íibàaca Pedro icáapi ìwali, imichàidacani úniácuíse. Yá íimaca Pedro irí: —‍¿Cáná càmita píibàa piwàwawa nuwéré tài íiméeri iyú? Pidàbacanacáitaté píináidacawa piwàwawa càmíinápináté nuyúudàa pía, yáta pidàbacaté pisawíacawa —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Nawàlùacanacáitawa barca irìculé, yáta wiúca cáuli canánama, Jesúscáiná iwàlùacatéwa wàatalé barca irìculé. ");
INSERT INTO pioNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Néese wía ìyéeyéica barca irìcu, wabàlùacawa wàuluì ipùata iyúwa Jesús irí, wàacaténá icàaluíniná. Wáimaca irí: —‍¡Báisíta Dios Iirica pía! —‍wáimaca irí. ");
INSERT INTO pioNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Wachàbacatéwa abéemàalé Galilea icalìsaniná íicha, yá wàanàaca Genesaret yàasu cáli néré. ");
INSERT INTO pioNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Genesaret yàasu cáli néeséeyéi náalía naicáca Jesús, íná nàaca nacàlidaca iináwaná ìwali macái néenánái iríwa ìyéeyéica macái yàcalé irìcu Genesaret yàasu cáli. Yá natéca macái cáuláiquéeyéi wenàiwica Jesús yàatalé. ");
INSERT INTO pioNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Yá nasutáca íicha wawàsi imàacáanápiná nadunùacáita ibàle ipùata ìwali nachùnìacaténáwa. Yá macáita idunuèyéica ibàle ìwali, yá cayábaca nía uláicái íicha. ");
INSERT INTO pioNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Abénaméeyéi yéewáidéeyéi wenàiwica templo irìcu nàanàacaté Jerusalén ìyacàlená néese. Nàwacáidáyacacawa fariseonái yáapicha. Néese macáita nàacawa Jesús yàatalé, yá nasutáca néemìawani. Náimaca Jesús irí: ");
INSERT INTO pioNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","—‍¿Cáná péewáidacalénái càmita namàni càide iyúwa wàawirináimi judío yéewáidáaná? Càmita namàni culto nacáiri náibacaténá nacáapiwa éeréeri iyú càide iyúwa wàawirináimi íiwitáise íimáaná ipíchawáise nayáaca nayáacaléwa íná casacàaca Dios iicáca níái péewáidacaléca —‍náimaca. ");
INSERT INTO pioNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Néese Jesús íimaca nalí: —‍Báisíta càmita namàni yáara canéeri iwèni wawàsi càide iyúwaté pìawirináimicué yéewáidáaná, càmíirica Dios ichùulìaca wamànica. Quéwa pimànicuéca áiba wawàsi báawéeri cachàiníwanái: Pidécuéca pimàacaca píichawa Dios itàacái pimànicaténácué meedá iyúwa píiwitáise íimáaná. ");
INSERT INTO pioNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Bàaluitécáiná Dios íimaca: ‘Pìa píaniri íimiétacanáwa, píatúa nacáiwa’, cài íimaca yái Diosca. Yá nacái íimacaté: ‘Aibacaalí itàaníca báawéeri iyú yáaniri ìwaliwa, càmicaalí nacái, yáatúa ìwaliwata, yásí iwàwacutácué pinúacani’, cài íimaca yái Diosca. ");
INSERT INTO pioNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Quéwa píacué fariseoca péewáidacuéca wenàiwica cayábacasa cài náimaca náaniri iríwa, náatúa irí nacáiwa: ‘Càmita núalimá nuyúudàaca pía; nudéca nucùaca Dios irípináni, yái nuèripinámica pirí, íná canáca nulí cayába nuyúudèeripiná iyú pía’, cài náimaca nasèenái iríwa. ");
INSERT INTO pioNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Càita péewáidacuéca wenàiwica càmitasa iwàwacutá nayúudàaca náaniriwa, náatúa nacáiwa idécanáami cài náimaca nasèenái iríwa. Iná píacué fariseoca píasáidacuéca piúcaca píichawa Dios itàacái pimànicaténácué iyúwa píiwitáise íimáaná meedá. ");
INSERT INTO pioNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","¡Píacué pucháibéeyéica íiwitáise meedá! Profeta Isaías icàlidacatécué pìwali machacàníiri iyú Dios inùmalìcuíse. Dios íimacaté: ");
INSERT INTO pioNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Níái israelitaca náimacáita meedá nàacasa nucàaluíniná, quéwa càmita cáininá naicáca núa nawàwalìcuísewa. ");
INSERT INTO pioNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Caná iwèni nuicáca nàasu culto namàníiricasa nulí. Càmita néewáida wenàiwicanái nutàacái iyú, néese néewáidacáita nía náiwitáise iyúwa’, cài íimaca yái Diosca —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Néese Jesús imáidaca yàataléwa áibanái wenàiwicanái ìyéeyéica néeni. Yá íimaca nalí: —‍Péemìacué nutàacái, píacué macáita. Píalimáidacué píalíacawa péemìaca càinácaalí íimáaná yái núuméeripinácuéca pirí: ");
INSERT INTO pioNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Càinácaalí yàacàsi iwàluèricawa wenàiwica inùmalìculé, càmita yéewa casacàaca imànica wenàiwica íiwitáise Dios íicha. Quéwa tàacáisi báawéeri imusuéricawa nanùmalìcuíse, yácata casaquèeri imànica náiwitáise Dios íicha —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Néese wía Jesús yéewáidacaléca wàacawa yàatalé. Yá wáimaca irí. —‍¿Càmitasica píalíawa máiní báawaca fariseonái néemìaca yái píimáanáca? —‍wáimaca. ");
INSERT INTO pioNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Quéwa Jesús íimaca walí: —‍Péemìacué comparación: Càide iyúwa bànacalé íiwacali iwatàacaalí báawéeri yéetaná imusuéricawa ibànacale yèewi, càita nacái Núaniri Dios chènuníiséeri yúucapiná íichawa cawinácaalí càmíiyéica itàaní Dios inùmalìcuíse báisíiri iyú, càmicáiná Dios ibànùa nía. Dios imáalàidapiná nacái nàasu tàacáisi cachìwéeri. ");
INSERT INTO pioNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Picácué píináidawa piwàwawa fariseonái itàacái ìwali. Níacata matuíyéi íiwitáise meedá, càmíiyéi yáalíawa báisíiri tàacáisi, íná càmita náalimá néewáidaca wenàiwica machacàníiri iyú Dios ìwali. Néewáidacáita áibanái càmíiyéi yáalíawa, íná càica níade iyúwa matuíri itéerica áiba matuíri. Néese pucháibanama náuwàacawa utàwi irìculé. Càita nacái níara fariseoca naméeràidaca áibanái càmíiyéi yáalíawa —‍íimaca walí yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Néese Pedro íimaca Jesús irí: —‍Picàlida walí càinácaalí íimáaná yái tàacáisica picàlidéerica yàacàsi ìwali —‍íimaca yái Pedroca. ");
INSERT INTO pioNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Yá Jesús íimaca walí: —‍¿Néeni, càmitasicué nacái píalía péemìaca càinácaalí íimáaná? ");
INSERT INTO pioNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","¿Càmitasicué píalíawa macáita yàacàsi iwàluèricawa wenàiwica inùma irìculé yàanàaca idèerìculé, néese imusúacawa íicha? ");
INSERT INTO pioNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Quéwa tàacáisi báawéeri imusuéricawa wenàiwica inùma irìcuíse, imusúacawa iwàwa irìcuíse. Yácata casaquèerica imànica wenàiwica íiwitáise Dios íicha. ");
INSERT INTO pioNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Yácáiná macáita báawéeri íiwitáisesi imusúacawa wenàiwica iwàwa irìcuíse. Càita báawéeri íiwitáisesi: Nanúaca wenàiwica; naimáca áiba yáapicha càmíichúaca náinusíwa, càmíirica nanìrisíwa nacái; naimáca áibanái yáapicha ipíchawáise needáca nalíwa nía; namànica nainá iyúwa càide iyúwa càmíiná Dios ibatàa wenàiwica imànica; nayéedùaca áibanái yàasu; nachìwáidaca wenàiwica, nacàlida nacái nachìwawa; natàaníca báawéeri iyú áibanái ìwali. ");
INSERT INTO pioNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Yái báawéeri wawàsica wenàiwicanái imàníirica, yácata casaquèerica imànica wenàiwica íiwitáise Dios íicha; néese, càmicaalí wamàni culto nacáiri wáibáaná wacáapiwa éeréeri iyú càide iyúwa fariseo íiwitáise íimáaná ipíchawáise wayáaca wayáacaléwa, càmita casacàa imànica wáiwitáise Dios íicha —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Yá Jesús yàacatéwa náicha yàacaténáwa Tiro ìyacàlená yàasu cáli néré, Sidón ìyacàlená nacái. ");
INSERT INTO pioNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Néese inanái yàanàaca néré, cananeasàatúa, càmíichúa israelita, ìyéechúa néré. Uacawa Jesús yàatalé. Yá umáidaca, úumaca Jesús irí: —‍¡Nuíwacali, rey David itaquérinámi, Dios ibànuèrica israelita icuèrinápiná, piicá nupualé! ¡Uacáiná nuíduca ùuwichàacawa demonio ìyacáiná uwàwalìcu! —‍úumaca. ");
INSERT INTO pioNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Jesús quéwa masànata uíchani. Néese wía, Jesús yéewáidacaléca wàacawa yàatalé. Yá wáimaca irí: —‍Pichùulìa úa wáicha meedá, uémíanícáiná ùacawa wáamiwáise —‍wáimaca. ");
INSERT INTO pioNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Jesús íimaca: —‍Dios idéca ibànùaca núa nuyúudàacaténá níawamita Israel itaquénáinámi iwènúadéeyéica íiwitáisewa Dios íicha càide iyúwa ovejanái naméeràacaalíwa náucacawa canácaalí nacuèriná. Nudéca nùanàaca numáidacaténá nía, nawènúadacaténá náiwitáisewa Dios irípiná —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Quéwa úái inanáica ùacawa Jesús yàatalé. Yá ubàlùacawa ùuluì ipùata iyúwa Jesús irí ùacaténá icàaluíniná, yá úumaca irí: —‍¡Nuíwacali, piyúudàa núa! —‍úumaca. ");
INSERT INTO pioNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Jesús íimaca ulí: —‍Péemìa comparación: Càmita wáuca sùmanái iyáacalé áulinái iyáapiná; càita nacái iwàwacutá nuyúudàaca quéechacáwa nuénánáicawa, níái israelitaca. Càmita cayába nuyúudàaca píacué càmíiyéica israelita —‍íimaca ulí, yáalimáidacaténá iicáwa úa, asáisí uebáidacaalí Dios imàníinápiná ulí cayábéeri éwita càmicáaníta israelita úa. ");
INSERT INTO pioNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Néese úumaca irí: —‍Báisíta, Nuíwacali, quéwa càide iyúwa áulinái iyáacaalí yàacàsi yéenáimi yúuwèericawa náiwacali yàasu mesa yáapiré, càita nacái nuwàwa Dios imànica nulí cayábéeri éwita càmicáaníta israelita núa —‍úumaca. ");
INSERT INTO pioNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Néese Jesús íimaca ulí: —‍¡Pía inanái, pidéca peebáidaca nulí manuísíwata! Yá nudéca numànica càide iyúwa pisutáaná nuícha —‍íimaca yái Jesúsca. Yáta cayábaca úái inanái íiduca, demoniocáiná yàacatéwa uícha. ");
INSERT INTO pioNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Néeseté Jesús yàacawa náicha, yá yàanàaca Galilea icalìsaniná icàinalená néré. Néesecáwa yàacawa dúli íinatalé, yá yáawinacawa néré. ");
INSERT INTO pioNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Manùba wenàiwica yàanàaca yàatalé, natéca náapichawa wenàiwica éeruíyéi yàabàli, matuíyéi nacái, cacháunéeyéi nacái, matàacáiyéi nacái, áibanái cáuláiquéeyéi nacái manùbéeyéi. Yá natéca nía, namàacaca nía cáli íinata Jesús íipunita. Yá Jesús ichùnìaca nía macáita. ");
INSERT INTO pioNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Iná níái manùbéeyéi wenàiwicaca náináidacawa manuísíwata naicáidaca Jesús irí, imànicáináté cayábéeri wawàsi íiwitáise iyúwa. Néemìaca matàacáiyéimi itàaníca cayába. Naicáca nacái cacháunéeyéimi iiná cayábaca nía; níái éeruíyéimi yàabàli nacái nàipìnáaníca cayába; nía nacái matuíyéimica naicáidaca cayába. Yá nadàbaca nàaca Dios irí cayábéeri, yái Dios Israel itaquénáinámi yèerica icàaluíniná. ");
INSERT INTO pioNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Néeseté Jesús imáidaca yàataléwa wía yéewáidacaléca. Yá íimaca walí: —‍Catúulécanáca nuicáca níái wenàiwicaca. Nadéca nàyaca núapicha máisiba èeri, idéca nacái imáalàacawa náicha nayáacalé. Càmita nuwàwa nubànùaca nía máapíiyéica nacapèe néréwa, ipíchaná nawàwachàbacawa àyapulìcubàa namáapicawa —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Néese wáimaca irí: —‍Quéwa, càmita wáalimá weedáca yàacàsi cayába nayáapináwa, níái manùbéeyéica chái, canácatáica yàcalé —‍wáimaca. ");
INSERT INTO pioNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Néese Jesús isutáca yéemìawa wía: —‍¿Càisimalénácué pan ìya pirí? —‍íimaca walí. Néese wáimaca irí: —‍Siete namanùbaca pan, máisibáanata cubái imìdecaná púubéeyéi nacái —‍wáimaca. ");
INSERT INTO pioNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Néese Jesús ichùulìaca náawinacawa cáli íinata níái wenàiwicaca. ");
INSERT INTO pioNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Néese yeedáca siete namanùbaca pan icáapi irìculéwa, cubái nacái. Yàaca Dios irí cayábéeri yàacàsi ìwali. Néese isubèriadacani, yàaca walíni, wía yéewáidacaléca. Néese wawacùaca wenàiwicanái iríni. ");
INSERT INTO pioNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Néese macáita nayáaca cadénamani, yá weedáca siete mapíiri imanùbaca yàacàsi yéenáimi imàaquéericawa. ");
INSERT INTO pioNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Níái iyéeyéicaté yái yàacàsica, cuatro mil namanùbaca asìanáica. Càmita waputàa inanái, sùmanái nacái iyéeyéicaté iyáacaléwa asìanái yáapicha. ");
INSERT INTO pioNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Néeseté Jesús imàacaca wenàiwicanái nèepùacawa íicha. Yá iwàlùacawa wáapicha barca irìculé. Néese wàacawa Magadán yàasu cáliré, ìyéerica abéemàalé Galilea icalìsaniná íicha. ");
INSERT INTO pioNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Néeseté abénaméeyéi fariseo nàacawa Jesús yàatalé saduceonái yáapicha. Yá nadàbaca natàaníca Jesús yáapicha, càmíiyéi yeebáida Dios néeséericani yái Jesúsca. Yá nawàwacaté náalimáidaca naicáwani imànicaténá áiba wawàsi náaliméerica nacháawàaca iináwaná ìwali ìwalíise. Yá nasutáca íicha imàníinápiná naicá áiba wawàsi ichàini iyúwa, áiba wawàsi càmíirica wenàiwica idé imànica, yáasáidacaténá báisíiri iyúcani Dios néeséericatani. ");
INSERT INTO pioNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Quéwa Jesús íimaca nalí: “Péemìacué comparación: Táicacaalícué pìwali chái Israel yàasu cáli íinata, yá píimacuéca: ‘Táwicha cayába èeri waicácáiná quíiréeri acalèe siùca èeri’, càicué píimaca. ");
INSERT INTO pioNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Néese áibaalícué amalácaalí piwicáu, yá píimacuéca: ‘Siùcata báawéeri èeri waicácáiná quíiréeri acalèe chái Israel yàasu cáli íinata’, càicué píimaca. ¡Píacué pucháibéeyéica íiwitáise!, píalíacuécawa càinácaalí íimáaná yái capìraléeri cáli iicácanáwa. Iná iwàwacutácué píalíaca nacáiwa càinácaalí íimáaná yái numàníináca siùcade pèewibàa, quéwa picàlidacáitacué pichìwawa càmitasa píalíacuéwa cawinácaalí núa. ");
INSERT INTO pioNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Píacué báawéeyéica íiwitáise, píacué nacái iwènúadéeyéica íiwitáisewa Dios íicha, pidécuéca pisutáca nuícha numàníinápiná piicá yái càmíirica wenàiwica idé imànica, quéwa càmita numànicué pirí càiri wawàsi. Numàacapinácué piicá abéerita numàníiná càide iyúwaté profeta Jonás ìyáanáté”, íimaca yái Jesúsca. Néese Jesús yèepùacawa náicha. ");
INSERT INTO pioNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Néeseté wía Jesús yéewáidacaléca, watéca wàacawa Jesús Galilea icalìsaniná abéemàalé, quéwa waimáichacaté watéca pan wayáapináwa. ");
INSERT INTO pioNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Yá Jesús íimaca walí: —‍Péemìacué cayába comparación: Piicácué píichawa fariseonái yàasu levadura, saduceonái yàasu levadura nacái —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Néese wía yéewáidacaléca càmita wéemìa càinácaalí íimáaná yái comparación Jesús icàlidéerica walí íná wáimaca walíwáaca: —‍¡Idéca cài íimaca walí càmicáiná waté pan wayáapináwa! —‍wáimaca. ");
INSERT INTO pioNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Jesús yáalíacawa wáináidáanáwa, íná íimaca walí: —‍¿Cánácué píima canácasa pirí pan? Càmita nutàaní pan ìwali. ¡Cánácué càmita píibàa piwàwawa nuwéré! ");
INSERT INTO pioNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Cánácué càmita peebáida nulí núalimáca nùacuéca piyáapiná càinácaalícué pimáapuèrica? Iwàwacutácué piwàwalica càinácaalíté ìyáaná nuwacùacaalíté wenàiwicanái irí pan nayáapiná. Idécanáamité nuwacùaca nalí cinco namanùbaca pan nayáapiná níái cinco mil namanùbaca asìanáica, yácué pìwacáidacaté madécaná mapíiri yàacàsi yéenáimi imàaquéericawa. ");
INSERT INTO pioNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Néese àniwa idécanáamité nuwacùaca nalí siete namanùbaca pan nayáapiná níái báinúaca mil namanùbaca asìanáica, yá pìwacáidacatécué madécaná mapíiri yàacàsi yéenáimi imàaquéericawa. Iná ¿cánácué càmitàacáwa píalíawa núalimáca nùaca piyáapiná? ");
INSERT INTO pioNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Cánácué càmita píalíawa càmita nutàaní pan ìwali? Péemìacué comparación: Piicácué píichawa fariseonái yàasu levadura, saduceonái yàasu levadura nacái, ipíchanácué báawaca namànica píiwitáise nacái —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Ináté átata wáalíacawa Jesús càmita yàalàa wía pan yàasu levadura íichaná. Néese yàalàaca wía íichaná yái fariseonái yàasu tàacáisi cachìwéerica, saduceonái yéewáidáaná nacái. Yái tàacáisi néewáidéerica iyú wenàiwica, càicanide iyúwa levadura. Càide iyúwa levadura imàníiná ibàacanéeri iyú, imàacaca macáita íbesi inísàacawa, càita nacái fariseonái, saduceonái nacái néewáidaca wenàiwica nachìwa iyúwa, quéwa ibàacanéeri iyúta. Wenàiwicanái càmita náalíawa cachìwéerica nàasu tàacáisi. Càita fariseonái iméeràidaca madécaná wenàiwica Dios íicha namànicaténá nabáyawanáwa. ");
INSERT INTO pioNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Jesús idécanáamité yàanàaca Cesarea de Filipo ìyacàlená itéese, yá isutáca yéemìawa wía, wía yéewáidacaléca. Yá íimaca walí: —‍¿Càiná náimaca nùwali níara áibanái wenàiwicaca? ¿Cawinása núa, núa asìali Dios néeséerica? —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Yá wáimaca irí: —‍Abénaméeyéi íimaca pìwali Juan el Bautistamicasa pía, náimacáiná Juan idécasa icáucàacawa. Aibanái íimaca profeta Elíascasa pía, yèepuèricasa yàanàaca àniwa, yái profeta Dios íiméericaté ìwali ibànùanápináté àniwani. Aibanái íimaca profeta Jeremíascasa pía, imichèericasawa yéetácáisi íicha, càmicaalí nacái, náimaca áiba profetaca pía nacái, itàaníiricaté Dios inùmalìcuíse bàaluité —‍wáimaca. ");
INSERT INTO pioNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Néese Jesús íimaca walí: —‍Néenicué pía, ¿càinácué nacái píimaca nùwali? ¿Cawiná núa? —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Néese Simón Pedro íimaca irí: —‍Mesíasca pía, yái cáuri Dios Iirica, yái icuèripináca wía, Dios ibànuèrica walí, wía israelitaca —‍íimaca yái Pedroca. ");
INSERT INTO pioNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Néese Jesús íimaca Pedro irí: —‍Dios idéca imànica pirí cayábéeri, Simón, Jonás ìirica. Canácata wenàiwica yáaliméeri imàacaca píalíacawa nùwali cawinácaalí núa. Abéerita Núaniri Dios chènuníiséeri idé imàacaca píalíacawa nùwali. ");
INSERT INTO pioNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Siùcade núumaca pirí Pedrocata píipidenáca íimáanáca “achúméeri íba”. Quéwa péemìa comparación: Yái tàacáisi siùquéerica tàacáwa píimaca nùwali ìyaca càide iyúwa cachàiníiri íba manuíri nabàlùadéeripiná íinata manuíri capìi. Cawinácaalí yeebáidéeyéica nutàacái nàyapiná càide iyúwa manuíri capìi ibàlùacaalíwa, abédanamapináta náiwitáise neebáidaca iyúwa píimáaná nùwali Mesíasca núa, yái Dios Iirica. Péemìa comparación: Càide iyúwa canáaná yáaliméeri imáalàidaca manuíri capìi ibàluèricawa cachàiníiri íba íinata, càita nacái canácata yáaliméeri imawènìadaca càiripináta nùasu wenàiwica yeebáidéeyéica nutàacái, éwita yéetácáisi piná, canácata yáaliméeri imáalàidaca nía, canásíwata. ");
INSERT INTO pioNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Numàacapiná picàlidaca nutàacái wenàiwicanái irí, nawènúadacaténá náiwitáisewa Dios irípiná, yéewanápiná nawàlùacawa Dios ìyacàle irìculé Dios icùacataléca macáita chènuniré. Pìalàapiná nùasu wenàiwicanái namàníinápiná chái èeri irìcu càide iyúwa Dios iwàwáaná, yái ìyéerica chènuniré —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Néese Jesús yàalàaca wía, wía yéewáidacaléca ipíchaná wacàlidaca áibanái irí Mesíascani, yái wacuèrinápináca Dios ibànuèrica walí, wía israelitaca. ");
INSERT INTO pioNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Néenialíté Jesús idàbaca icàlidaca walíni, wía yéewáidacaléca, iwàwacutáanáté yàacawa Jerusalén ìyacàlená néré. Jesús íimaca israelita icuèrinánái, sacerdote íiwacanánái nacái, nía nacái yéewáidéeyéica wenàiwica templo irìcu nàuwichàidáanápináté manuísíwatani, yá nanúanápináténi yái Jesúsca. Quéwa Jesús íimaca imichàanápinátéwa yéetácáisi íicha máisiba èeri irìcu. ");
INSERT INTO pioNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Néese Pedro itéca Jesús méetàucuta wáicha, yá idàbaca yàalàaca Jesús cachàiníiri iyú ipíchaná icàlidaca càiri. Yá Pedro íimaca irí: —‍¡Nuíwacali, Dios càmita iwàwa picàlidaca càiri wawàsi! ¡Canácatáita yéewa piùwichàacawa cài! —‍íimaca yái Pedroca. ");
INSERT INTO pioNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Quéwa Jesús iwènúacawa Pedro íicha. Yá íimaca Pedro irí: —‍¡Pìawa nuícha, pía nùuwide Satanás nacáiri íiwitáise, píalimáidacáiná núa, numàníinápiná nubáyawanáwa! Càmita píináidawa iyúwa Dios iwàwáaná. Píináida meedáwa càide iyúwa èeri mìnanái íiwitáise ìyáaná —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Néesecáwa Jesús íimaca walí macáita, wía yéewáidacaléca: —‍Abéericaalí péenácué iwàwa yàacawa núapicha iyúwa nuéwáidacalé, néese càmita yéewa pimànica yái piwàwéerica pimànica. Iwàwacutá nacái pimànica mamáalàacata càide iyúwa nuchùulìaná pía. Iwàwacutá matuíbanáiri iyú pimàaca áibanái yùuwichàidaca pía, éwita naicáanícaalí nacái piquíniná, éwita nanúacaalí píawa cruz ìwali peebáidacáiná nutàacái. ");
INSERT INTO pioNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Níacáiná cawinácaalí càmíiyéica iwàwa yeebáidaca nutàacái ipíchaná nàuwichàacawa nulípiná, canáca nalí nacáuca càmíiri imáalàawa. Quéwa cawinácaalí yeebáidéeyéica nutàacái mamáalàacata, éwita áibanái inúacaalí nía, nadènìapiná nacáucawa càmíiri imáalàawa. ");
INSERT INTO pioNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Ewita wenàiwica yeedácaalí iríwa macáita chái èeri yàasu cawèníirica, quéwa yúuca íichawa icáucawa càmíiri imáalàawa càmicáiná yeebáida nutàacái, yá canéerica iwèni meedá iríni, macáita yái cawèníirica yeedéerimica iríwa. Canácáiná áiba wawàsi wenàiwica yáaliméeri yàaca yeedácaténá iríwa icáucawa càmíiri imáalàawa, idécanáami yúucaca íichawani. ");
INSERT INTO pioNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Núacáiná, asìali Dios néeséerica, nùanàapiná àniwa Núaniri Dios íiwitáise yáapichawa mèlumèluíri iyú, Dios yàasu ángelnái yáapicha nacáiwa. Yá nùapiná macái èeri mìnanái iwèni ìwalíise yái namàníirica. ");
INSERT INTO pioNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Péemìacué cayábani, abénaméeyéicué péená ìyéeyéica chái siùcade, càmita néetápináwa ipíchawáise numàacaca núawawa naicáca núa càide iyúwa abéeri nacuèrinásàiri, núa asìali Dios néeséerica —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Néeseté seis èeri natàanícadénáami cài, yá Jesús itéca yáapichawa Pedro, Santiago nacái, Juan nacái yái Santiago iméeréerica. Yá Jesús yàacawa wáicha dúli chènuníiri íinatalépiná, itéca máisiba wéená. ");
INSERT INTO pioNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Néré naicáca Jesús iwènúacawa áibawaca naicápiná. Yá mèlumèluwaca inàni icànaca càide iyúwa èeri icànáaná, ibàle nacái iwènúacawa cabalèewaca càide iyúwa camalási. ");
INSERT INTO pioNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Yáta níái máisiba wéenáca ìyéeyéica néré naicáca profeta Moisés, profeta Elías nacái natàaníca Jesús yáapicha. ");
INSERT INTO pioNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Néese Pedro íimaca Jesús irí: —‍Wáiwacali, ¡cayábéeriquéi wàyáanáca chái! Piwàwacaalí, yásí numànica máisiba capìi yáana wawàwalíinápinácué pía, abéeri pirípiná, áiba nacái Moisés irípiná, áiba nacái Elías irípiná —‍íimaca yái Pedroca. ");
INSERT INTO pioNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Néese idècunitàacá Pedro itàaníca, yá mèlumèluíri acalèe ibàlìaca nía catámèeri iyú. Yá néemìaca Dios itàacái acalèe yèewíise. Cài íimaca: “Yácata Nuìri nuwàwéeri cáininéerica nuicáca. Cayábaca nuwàwa nuicácani. Péemìacué itàacái”, íimaca yái Diosca. ");
INSERT INTO pioNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Néemìacanacáitani níái yéewáidacaléca máisiba, yá náuwàa nalìacawa nanùmáawawa cáli iwéré Jesús íipunita nàacaténá icàaluíniná. Yá cáaluca nía báawanama. ");
INSERT INTO pioNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Néese Jesús yàacawa nàatalé. Yá imàacaca icáapiwa nàwali. Iimaca nalí: —‍Pimichàacuéwa; picácué cáalu pía —‍íimaca nalí. ");
INSERT INTO pioNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Naicáidaca néré, yá canácata naiquéeri áibanáica, abéerita Jesús naicá. ");
INSERT INTO pioNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Néese idècunitàacá nalicùacawa dúli íinatáise, Jesús yàalàaca nía. Iimaca nalí: —‍Picácué picàlida áibanái iríni yái péemièricuéca, piiquéericuéca nacái, yái yéenáiwanási nacáirica àta numichàacatalépinátawa yéetácáisi íicha, núa asìali Dios néeséerica —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Néese Jesús yéewáidacalénái máisiba nasutáca néemìawani. Náimaca irí: —‍Níara yéewáidéeyéica wenàiwica templo irìcu náimaca iwàwacutáanása profeta Elías yèepùa yàanàaca quéechacáwa aléi èeri irìculé àniwa ipíchawáise israelita icuèrinápiná yàanàaca, yái wacuèrináca Dios ibànuèripináca walí. ¿Cáná yéewa cài náimaca, níái yéewáidéeyéica wenàiwica templo irìcu? —‍náimaca. ");
INSERT INTO pioNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Néese Jesús icàlidaca nalí Juan el Bautistami iináwaná ìwali: —‍Báisíta, iwàwacutácaté profeta Elías nacáiri yàanàaca quéechatécáwa. Yá iwènúadaca wenàiwicanái íiwitáise Dios irípiná àniwa, yéewanápiná néemìaca itàacái yái israelita icuèrinápináca Dios ibànuèrica nalí. ");
INSERT INTO pioNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Quéwa núumacué pirí abéeri profeta Elías nacáirimi idéca yàanàaca, yái Juan el Bautistamica, quéwa càmitaté náalía ìwali Elías nacáiricaténi. Yáté namànica irí báawéeri càide iyúwaté nawàwáaná. Càita nacái núa, asìali Dios néeséerica, nùuwichàapinácawa namànicaalípiná nulí báawéeri —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Néese Jesús yéewáidacalénái náalíacatéwa Jesús icàlidaca ìyaca nalí Juan el Bautistami iináwaná ìwali. ");
INSERT INTO pioNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Nàanàacaté wenàiwicanái yàatalé, yá abéeri asìali yàacawa Jesús yàatalé. Yá ibàlùacawa yùuluì ipùata iyúwa Jesús irí yàacaténá Jesús icàaluíniná. Yá íimaca Jesús irí: ");
INSERT INTO pioNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","—‍Nuíwacali, piicácáwa nuìri ipualé, demoniocáiná idacùaca íiwitáise cachàiníiri iyú, yá yùuwichàacawa báawanama, yái nuìrica. Madécaná yàawiría yúuwàacawa quichái irìculé, úni yáaculé nacái. ");
INSERT INTO pioNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Nudéca nutécani péewáidacalénái yàatalé nachùnìacaténáni, quéwa càmita nadé náucaca íicha demonio —‍íimaca. ");
INSERT INTO pioNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Néese Jesús íimaca nalí: —‍¡Píacué càmíiyéica yeebáida Dios ìwali, báawéeyéi nacái íiwitáise meedá! ¿Càinácué èeri iwàwacutá nùyacuéca píapicha quiríta? ¿Càinácué èeri iwàwacutá numànicuéca pirí quiríta? Pìanàidacué cháni, yái ùuculìirica —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Néese Jesús yàalàaca demonio cachàiníiri iyú. Yá yúucaca demonio ùuculìiri íicha. Yáta cayábaca yái ùuculìirica. ");
INSERT INTO pioNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Néesetécáwa wía Jesús yéewáidacaléca watàaníca Jesús yáapicha méetàucuta wenàiwicanái íicha. Yá wasutáca wéemìawani: —‍¿Cánácáwa càmita wadé wáucaca demonio? —‍wáimaca. ");
INSERT INTO pioNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Néese Jesús íimaca walí: —‍Càmicáinácué peebáida Dios macái pichàini iyúwa. Péemìacué cayába, peebáidacaalícué Dios, éwita achúmacáaníta càide iyúwa achúméeríina mostaza íimi, yásí píalimácué pichùulìaca dúli isirùacawa méetàuculéta cài: ‘Pimichàawa, pìa pibàlùacawa áibacatalé’, yásí dúli yàacawa. Báisícaalícué peebáidaca Dios, yásí píalimácué pimànica macáita. ");
INSERT INTO pioNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Quéwa máinícué càulenáca piúcaca yái demonio íiwitáanáca. Iwàwacutácué pisutá Dios quéechacáwa, pimàacacué píichawa nacái piyáacaléwa, pidéenápinácué piúcacani wenàiwica íicha —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Néeseté idècunitàacá Jesús yèepunícawa wáapicha, wía yéewáidacaléca Galilea yàasu cáli íinatabàa, yá icàlidaca walí yái tàacáisica. Iimaca walí: —‍Aiba wenàiwica presopináca namànica núa namàacacaténá áibanái asìanái inúaca núa, núa asìali Dios néeséerica. ");
INSERT INTO pioNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Yá nanúapináca núa. Quéwa máisiba èeri irìcu yásí nucáucàacawa àniwa —‍íimaca yái Jesúsca. Néese wéemìacanáami yái tàacáisica, yá achúmaca wawàwa manuísíwata. ");
INSERT INTO pioNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Néeseté Jesús, wía nacái yéewáidacaléca wàanàaca Capernaum ìyacàlená néré. Nàyaca néré abénaméeyéi ìwacáidéeyéica plata camuí imanùbaca nachùnìacaténá judíonái yàasu templo. Yá nàacawa natàaníca Pedro yáapicha. Yá nasutáca néemìawani: —‍Yáara yéewáidéerica pía, ¿càmitasica ipáyaida íichawa camuí imanùbaca nachùnìacaténá templo? —‍náimaca. ");
INSERT INTO pioNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","—‍Báisíta, ipáyaidéeri —‍íimaca yái Pedroca. Néese Pedro iwàlùacanacáitawa capìi irìculé, yáta Jesús cài íimaca irí quéechacáwa: —‍Simón, ¿càinásica píináidacawa? ¿Cawiná íicha needá plata níara icuèyéica cáli chái èeri irìcu? ¿Needásica plata néenibe íichawa, áibanái íichatasica? —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Pedro íimaca irí: —‍Aibanái íicha —‍íimaca. Néese Jesús íimaca irí: —‍Iná néenibe càmita iwàwacutá napáyaidaca náichawa. Càita nacái càmita iwàwacutá nupáyaidaca nachùnìacaténá Núaniri Dios icapèewa, yái temploca, Iiricáiná núa. ");
INSERT INTO pioNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Quéwa càmita wawàwa báawaca wamànica nawàwa. Pìawa Galilea icalìsaniná néré. Piúca néré puìwi. Peedá yái idàbáanéerica pibaláca cubáica. Yásí pìanàaca moneda cubái inùmalìcu, abéechúa moneda cawèníichúa pipáyaidacaténá nalí nulípináni, pirípiná nacáiwa. Pidécanáami pìanàaca yái plataca, yá pitéca nàataléni pipáyaidacaténá nía —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Néenialíté, wía Jesús yéewáidacaléca, wàacawa Jesús yàatalé. Yá wasutáca wéemìawani: —‍¿Cawinásica wéená máiní cachàinipiná náicha canánama icùacaténá macáita èeri mìnanái píapicha? —‍wáimaca. ");
INSERT INTO pioNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Néese Jesús imáidaca yàataléwa abéeri sùmài ibàlùacaténáwa wèewi. ");
INSERT INTO pioNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Yá Jesús íimaca walí: —‍Càmitacué píináidawa machacàníiri iyú. Péemìacué cayába, càmicaalícué piwènúada píiwitáisewa àniwa píináidacaténáwa càide iyúwa sùmài íináidáanáwa, càmíiri cáimacái iicáca yáawawa, néese canácatáita yéewa Dios yéenibecuéca pía, Dios icùacaténácué pía. ");
INSERT INTO pioNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Cawinácaalí wenàiwica iwènúadéerica íiwitáisewa íináidacaténáwa càide iyúwa yái sùmài yáana íináidáanáwa, càmíiri cáimacái iicáca yáawawa, yácata máiníiripiná cachàini náicha canánama áiba èeriwa Dios ìyacàle irìcu Dios icùacataléca macáita chènuniré. ");
INSERT INTO pioNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Pimànicaalícué cayábéeri nuípidená ìwali sùmài irí, càiride iyúwa yái sùmàica peebáidacáiná nutàacái, yásí nuicáca yái cayábéerica pimàníirica sùmài irí càide iyúwa pidéca nacáicaalí pimànica nulí cayábéeri —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Jesús íimaca: “Aibacaalí iméeràidaca nùasu wenàiwica namànicaténá nabáyawanáwa, níái púubéeyéica yeebáidéeyéica nutàacái, yásí Dios yùuwichàidapiná manuísíwatani. Cayába cachàini irítáni yéetácaalíwatá ipíchawáise iméeràidaca sùmanái. Aibanái idacùacaalí manuíri íba icanápi ìwalíise, náucacaténáni manuíri úni yáaculé isawíacaténáwa, yásí ìisicùmacawa. Quéwa ìyacaalí mamáalàacata chái èeri irìcu, néese iméeràidacaalí sùmanái namànicaténá nabáyawanáwa, yá máiní cachàiníwanái yùuwichàapinácawa áibanái íicha infierno irìcu. Iná cayába cachàini irítáni yéetácaalíwatá ipíchawáise iméeràidaca púubéeyéi. ");
INSERT INTO pioNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","¡Máiní nàuwichàapinácawa níái èeri mìnanáica, nàyacáiná madécaná wawàsi chái èeri irìcu imàaquéerica wenàiwica íináidacawa namàníinápiná nabáyawanáwa! Macái èeri imanùbaca ìyaca càiri wawàsi, quéwa ¡máiní Dios yùuwichàidapiná cawinácaalí wenàiwica yáalimáidéerica áibanái namàníinápiná nabáyawanáwa! ");
INSERT INTO pioNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Iná piwàwacaalí pimànica pibáyawanáwa picáapi iyúwa, pìabàli iyú nacáiwa pìanápináwa aléera càmicatalé Dios iwàwa pìacawa, yá piúca píichawa píiwitáise báawéeriwa, ipíchaná pimànica pibáyawanáwa, càide iyúwa wenàiwica iwichùacaalí icáapiwa, yàabàli nacáiwa, ipíchaná imànica ibáyawanáwa icáapi iyúwa, yàabàli iyú nacáiwa. Càita nacái iwàwacutá piúcaca píichawa píiwitáise báawéeriwa, yéewanápiná pidènìaca picáucawa càmíiri imáalàawa, ipíchaná nacái Dios yúucaca pía infierno irìculé, yái manuíri quicháica, càmíirica ichacàwa, càiripinéerita ìyaca. ");
INSERT INTO pioNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Piwàwacaalí pimànica pibáyawanáwa pituí iyúwa, piicáanápiná wawàsi càmíirica Dios iwàwa piicáca, yá piúca píichawa píiwitáise báawéeriwa, ipíchaná pimànica pibáyawanáwa, càide iyúwa wenàiwica imusúadacaalí ituíwa, ipíchaná imànica ibáyawanáwa ituí iyúwa. Càita nacái iwàwacutá piúcaca píichawa píiwitáise báawéeriwa, yéewanápiná pidènìaca picáucawa càmíiri imáalàawa, ipíchaná nacái Dios yúucaca pía infierno irìculé, yái manuíri quicháica”, íimaca walí yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Jesús íimaca walí: “Picácué piicá níái sùmanáica càiyéide iyúwa canéeyéi iwèni meedá, picácué nacái pimàni nalí báawéeri. Núumacué pirí Dios yùuwichàidapiná cawinácaalí cài imàníirica, níacáiná Dios yàasu ángelnái icuèyéica níái sùmanáica náalimá nàacawa Núaniri Dios chènuníiséeri yàatalé chácatáinápinácaalí nawàwa naicácani, natàanícaténá Dios yáapicha. ");
INSERT INTO pioNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Iwàwacutácué cawènica piicáca sùmanái, núacáiná, asìali Dios néeséerica, nudéca nùanàaca aléi èeri irìculé nuwasàacaténá nía Dios yàasu yùuwichàacáisi íicha, níái iméerèeyéicawa Dios íicha. ");
INSERT INTO pioNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“¿Càinácué píináidacawa ìwali yái comparaciónca? Asìali idènìacaalí cien namanùbaca ipìra ovejanáiwa, yá abéeri oveja iméeràacaalíwa íiwacali íichawa, yásí náiwacali imàacaca ipìranáiwa noventa y nueve namanùbaca dúli inàliméeri yèewiré, yásí yàaca icutáca yái yúuquéericawa íicha. ");
INSERT INTO pioNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Yàanàacaalíni, yásí iyanídacawa ipìra ìwaliwa manuísíwata íicha yái iyanídáanácawa noventa y nueve namanùbaca ìwali, níái càmíiyéica iméeràawa íicha. ");
INSERT INTO pioNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Càitacué nacái Píaniri Dios chènuníiséeri cáinináca iicáca níái púubéeyéica. Càmita iwàwa áiba yúucacawa íicha, ibatàa abéeripináta”, íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Jesús íimaca walí àniwa: “Aibacaalí imàni pirí báawéeri, pìa pitàaníca yáapicha abéerita. Picàlida iríni machacàníiri iyú, yái imàníirica pirí báawéeri. Yeebácaalí pitàacái, yásí abédanamata íiwitáise píapicha àniwa. ");
INSERT INTO pioNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Quéwa yái imàníirica pirí báawéeri, càmicaalí yeebá pirí, yá pimáida áiba wenàiwica, cawàwanáta pucháiba wenàiwica nacái, nàacaténáwa píapicha yàatalé náalíacaténáwa ibáyawaná ìwali. ");
INSERT INTO pioNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Néese càmicaalí nacái yeebá nalí, yái imàníirica pirí báawéeri, néese picàlida iináwaná nalí níái ìwacáidáyaquéeyéicawa yéemièyéica Dios itàacái. Néese càmicaalí yeebá mamáalàacata, yá iwàwacutá piicácani càiride iyúwa wenàiwica càmíiri yeebáida Dios itàacái, càita nacái càiride iyúwa wenàiwica yeedéeri plata yéenánái judío íichawa Roma ìyacàlená yàasu gobierno irípiná. Iná iwàwacutá càmita pìwacáidáyacacawa yáapicha. ");
INSERT INTO pioNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Péemìacué cayábani, càinácaalí wawàsi càmíiricuéca pimàaca namànica chái èeri irìcu, yáta nacái Dios chènuníiséeri càmíiri imàaca namànica. Càinácaalí wawàsi nacái pimàaquéericuéca namànica chái èeri irìcu, yáta nacái Dios chènuníiséeri imàaquéerica namànica. ");
INSERT INTO pioNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Núumacué pirí pucháibacaalícué pía chái èeri irìcu abédanamacaalícué píiwitáise píapichawáaca pisutáanápinácué Dios íicha iyúudàanápiná pìalàaca péenásàiriwa, yásí Núaniri Dios chènuníiséeri imànicué pirí càide iyúwa pisutáanácué Dios íicha. ");
INSERT INTO pioNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Ata alénácaalí nàyaca pucháiba yeebáidéeyéica nutàacái, ìwacáidáyaquéeyéicawa nuípidená ìwali, áibaalí nacái máisiba nàwacáidáyacacawa nuípidená ìwali, yásí nùyaca néré náapicha, íná Núaniri Dios yéemìacué pisutáaná íicha”, íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Néese Pedro isutáca yéemìawa Jesús: —‍Nuíwacali, ¿càisimaléná yàawiría iwàwacutá numàacaca nuwàwawa ibáyawaná íicha càinácaalí báawéeri áiba wenàiwica imàníirica nulí? ¿Numàacasica nuwàwawa ibáyawaná íicha siete yàawiríasica? —‍íimaca yái Pedroca. ");
INSERT INTO pioNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jesús íimaca irí: —‍Càmita núuma pirí pimàacáanápiná piwàwawa ibáyawaná íicha siete yàawiría. Néese núuma pirí, pimàaca piwàwawa ibáyawaná íicha siete yàawiría setenta imanùbaca íimáanáca cuatrocientos noventa imanùbaca yàawiría iwàwacutá pimàacaca piwàwawa íicha càinácaalí báawéerica imàníirica pirí —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Jesús íimaca walí: “Yái Dios icùanáca yàasu wenàiwicawa ìyaca càide iyúwa abéeri nacuèrinásàiri imàníiná. Yái nacuèriná iwàwacaté yàasu wenàiwicanái ipáyaidaca íichawa imawènìacálecawa. ");
INSERT INTO pioNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Néese idàbáanéeri asìali needéerica nacuèriná yàataléwa, imawènìaca icuèriná íichawa manùba millones. ");
INSERT INTO pioNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Néese càmicáiná yáalimá ipáyaidaca íichawani, íná nacuèriná ichùulìaca nawéndaca asìali áibanái irí, yàacawéetúa yáapichawa nacái, yéenibe yáapichawa nacái, macáita yàasumi nacái yéewanápiná nacuèriná yeedáca iríwa àniwa achúmáanata yéená yái platami yàasu wenàiwica imawènièrica íicha. ");
INSERT INTO pioNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Néese yái íibaidéerica yéemìacaalíni, yá ibàlùacawa yùuluì iyúwa yàacaténá icuèriná icàaluínináwa, yéewanápiná icuèriná iicáca ipualé. Yá isutáca icuèriná íichawa manuísíwata cài: ‘Nuíwacali, picùacáwa quiríta matuíbanáitàacáwa, nupáyaidapiná tàacáwa nuíchawa macáita’, íimaca. ");
INSERT INTO pioNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Néese catúulécanáca icuèriná iicácani. Yá iwasàacani, imàaca nacái iwàwawa asìali imawènìacále íicha, yéewanápiná càmita quirínama iwàwacutá ipáyaidaca íichawani. Néese icuèriná imàacaca asìali yàacawa matuíbanáita. ");
INSERT INTO pioNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Yái íibaidéerica idécanáami yàacawa icuèriná íichawa, yá yàanàaca inacáiriwa íibaidéeri imawènièrica íicha achúmáanata plata. Néese idàbáanéeri asìali íibàaca inacáiriwa icanápi ìwalíise cachàiníiri iyú, batéwa inúacani. Yá íimaca inacáiri iríwa: ‘Pìa nulí nùasu plata yái pimawènièrica nuícha’, íimaca irí. ");
INSERT INTO pioNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Néese yái inacáiri ibàlùacawa yùuluì ipùata iyúwa yàacaténá icàaluíniná, yái idàbáanéeri asìalica, isutácaténá iicáanápiná ipualé. Yá íimaca: ‘Picùacáwa quiríta matuíbanáitàacáwa, nupáyaidapiná tàacáwa nuíchawa macáita’, íimaca irí. ");
INSERT INTO pioNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Quéwa yái idàbáanéeri íibaidéerica càmíirita iwàwa cài, yá yúucaca inacáiriwa presoíyéi ibànalìculé àta ipáyaidacataléta íichawa yái imawènìacálecawa. ");
INSERT INTO pioNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Aibanái íibaidéeyéi naicácaté càinácaalí ìyáaná, yá máiní achúmaca nawàwa ìwalíise. Yá nàaca nacàlidaca iináwaná ìwali nacuèriná iríwa. ");
INSERT INTO pioNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Iná nacuèriná imáidacani yàataléwani yái idàbáanéerica yàasu wenàiwicaca. Yá nacuèriná íimaca irí: ‘Pía nùasu wenàiwica báawéeri íiwitáise meedá. Numàacacaté nuwàwawa íicha macáita yái pimawènìacálemica, pisutácáináté nuícha manuísíwata. ");
INSERT INTO pioNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Nuicácaté pipualé, íná iwàwacutáca piicáca áibanái ipualé nacái, càide iyúwa nùyáaná’, íimaca yái nacuèrináca. ");
INSERT INTO pioNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Yá máiní calúaca yái nacuèrináca, yá yúucaca asìali presoíyéi ibànalìculé nàuwichàidacaténáni mamáalàacata ipáyaidacaténá íichawa càiripináta yái imawènìacálemicawa”, íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Néese Jesús íimaca: —‍Càita nacái Núaniri Dios chènuníiséeri yùuwichàidapinácué pía canánama càmicaalícué pimàaca piwàwawa nabáyawaná íicha báisíiri iyú, càinácaalí báawéerica áibanái imàníiricuéca pirí —‍íimaca walí yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Idécanáamité Jesús icàlidaca nalíni, yá yàacawa Galilea yàasu cáli íicha wáapicha, wía yéewáidacaléca. Yá wàanàaca Judea yàasu cáli íinatalé, yái cáli ìyéerica oriente iwéré èeri imusúacatáisewa, abéemàalé Jordán inanába íicha. ");
INSERT INTO pioNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Yá madécaná wenàiwica yàacawa yáamíise, nàwacáidáyacacawa yàatalé. Yá ichùnìaca cáuláiquéeyéi wenàiwica néré. ");
INSERT INTO pioNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Néese abénaméeyéi fariseo nàacawa Jesús yàatalé náalimáidacaténá naicáwani itàaníinápiná báawéeri iyú yéewanápiná nacháawàaca iináwaná ìwali itàacái ìwalíise. Yá nasutáca néemìawani: —‍¿Pimàacasica asìali imàacaca íichawa íinuwa àta càinácaalí wawàsi ìwalíise iwàwéerica imàacaca úa meedá? —‍náimaca náalimáidaca naicáwa Jesús. ");
INSERT INTO pioNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Néese Jesús íimaca nalí: —‍Pidécuéca piléeca Dios itàacái profeta itànèericaté, quéwa càmitacué piwàwa peebáidacani. Profeta itànàacaté tàacáisi íiméerica Dios idàbacaté wenàiwicanái quéechatécáwa. Dios ‘idàbacaté idàbáanéeri asìali, idàbáanéechúa inanái nacái’, cài itànàaca yái profetaca. ");
INSERT INTO pioNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Dios íimaca nacái: ‘Iná asìali yàacawa yáaniri íichawa, yáatúa íicha nacáiwa ìyacaténá abédanamata íinu yáapichawa, yásí nuicáca níái pucháibaca iyúwa abéeri wenàiwica’, íimacaté yái Diosca. ");
INSERT INTO pioNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Iná idécanáami asìali iimáca úapicha, yá càmita quirínama Dios iicáca nía iyúwa pucháiba wenàiwica, néese Dios iicáca nía iyúwa abéeri wenàiwica. Iná càmita cayába wenàiwica nèepùadaca náichawáaca nía, níái Dios imàaquéeyéica ìyaca càide iyúwa abéeri wenàiwica —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Néese nasutáca néemìawa Jesús àniwa: —‍Quéwa, Dios imàacaca asìali yúucaca íichawa íinuwa, yácáiná profeta Moisés ichùulìacaté asìali yàanápiná cuyàluta íinu iríwa, abéeri cuyàluta icàlidéerica áibanái irí idéca yúucaca úa, náalíacaténáwa manìrica úa. Yá idécanáami yàaca ulíni, yá yáalimá ibànùaca íichawa úa —‍náimaca. ");
INSERT INTO pioNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Jesús íimaca nalí: —‍Yái profeta Moisés càmitaté ichùulìa náucáanápiná náichawa náinuwa, néese bàaluité imàacacué pibànùaca píichawa píinuwa máinícaalí báawaca piicáca úa, ipíchanácué pimànica ulí báawéeri cachàiníwanái mamáalàacata máinícáinácué báawaca píiwitáise píacué israelitaca. Quéwa quéechatécáwa Dios idàbacaalíté wenàiwica, càmitaté ibatàa namàacaca náichawa náinuwa, íná báawacuéca Dios iicáca yái piúcáanácuéca píinuwa siùcade. ");
INSERT INTO pioNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Siùcade núumacué pirí, asìali imàacacaalí íichawa íinuwa càmíichúacáwa iimá áiba asìali yáapicha càmíirica unìrisíwa, yá yeedácaalí áiba íinupináwa, imànica ibáyawanáwa idàbáanéechúa íinu iríwa. Aiba nacái yeedácaalí íinupináwa abéechúa náuquéechúami, imànica ibáyawaná nacáiwa, iimácáiná úapicha, úái áiba asìali íinuca —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Néese wía Jesús yéewáidacaléca wáimaca irí: —‍Càmicaalí Dios ibatàa asìali yúucaca íichawa íinuwa, yá máiní càulenáca náichani. Cayába cachàini nalítáni càmicaalí needá náinupináwa —‍wáimaca. ");
INSERT INTO pioNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Jesús íimaca walí: —‍Báisíta, quéwa càmita macái wenàiwica náalimá nàyaca abéerita, níawamita Dios imàaquéeyéica ìyaca cài casíimáiri iyú. ");
INSERT INTO pioNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Abénaméeyéi càmita náalimá naduìca, namusúacáináwa cài, íná càmita needá nalíwa. Aibanái nacái càmita náalimá naduìca, áibanáicáiná náiríadacaté nía báawéeri iyú. Aibanái nacái nadéca náináidacawa nàyáanápiná càiripináta càide iyúwa wenàiwica càmíiyéi yáalimá iduìca yéewacaténá nàyaca matuíbanáiri iyú èeri íicha, náibaidáanápiná abéerita Dios irípiná. Cawinácaalí yáaliméeyéica ìyaca cài abéerita casíimáiri iyú íibaidacaténá càiripináta Dios irípiná, yá cayábéeriquéi ìyáanáca cài —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Néeseté áibanái natéca néenibewa Jesús yàatalé imàacacaténá icáapiwa nàwali, isutácaténá nalí Dios imàníinápiná nalí cayábéeri. Quéwa wía Jesús yéewáidacaléca, wadàbaca wacuísaca níái itéeyéica yéenibewa, wáimaca sùmanái nasàiwicasa Jesús irí wawàsi. ");
INSERT INTO pioNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Néese Jesús íimaca walí: —‍Pimàacacué sùmanái yàacawa nùatalé. Picácué pimáisanìa nàanàaca, Dios icùacáiná wenàiwica yeebáidéeyéica itàacái càide iyúwa sùmanái yeebáidáaná náaniri itàacáiwa —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Yá Jesús imàacaca icáapiwa nàwali, isutáca nalí Dios. Néesecáwa yàacawa áibalé wáapicha wía yéewáidacaléca. ");
INSERT INTO pioNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Néeseté abéeri ùuculìiri yàacawa Jesús yàatalé, yá isutáca yéemìawa Jesús: —‍Pía, cayábéeri yéewáidéerica wía, ¿càiríinásica cayábéeri iwàwacutá numànica nùyacaténá càiripináta Dios yáapicha chènuniré? —‍íimaca. ");
INSERT INTO pioNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Jesús íimaca irí: —‍Iwàwacutá píináidacawa cayába ìwali yái píimáanáca, càinácaalí íimáaná yái tàacáisi íiméerica cayábéericasa núa, canácáiná áiba wenàiwica cayábéeri, abéericata Dios cayábéeri —‍íimaca irí yái Jesúsca, iwàwacáináté asìali yeebáidaca ìwali, Dioscani yái Jesúsca. Néese Jesús íimaca irí àniwa: —‍Piwàwacaalí pìyaca càiripináta Dios yáapicha, yá iwàwacutá pìyaca càide iyúwa profeta Moisés ichùulìaná wàawirináimi bàaluité Dios inùmalìcuíse —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Néese yái ùuculìiri íimaca Jesús irí: —‍Moisés ichùulìacaté namànica madécaná wawàsi. ¿Càiríiná wawàsi pitàaní ìwali? —‍íimaca yái ùuculìirica. Néese Jesús íimaca irí: —‍Dios itàacái íimaca: ‘Picá pinúa wenàiwica, picá piimá áiba inanái yáapicha càmíichúaca píinusíwa, áiba asìali yáapicha nacái càmíirica pinìrisíwa, picá piyéedùa, picá picàlida pichìwawa, picá nacái pichìwáida áibanái. ");
INSERT INTO pioNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Néese pìa píaniri íimiétacanáwa, píatúa nacáiwa, cáininá piicáca áibanái wenàiwica càide iyúwa cáinináaná piicáca píawawa, pimànicaténá nalí cayábéeri’, cài íimaca Dios —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Néese ùuculìiri íimaca: —‍Nudéca numànica macáita càiri wawàsi càide iyúwa Dios ichùulìaná wía. ¿Càinásica áiba iwàwacutá numànica quiríta? —‍íimaca. ");
INSERT INTO pioNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Néese Jesús íimaca irí: —‍Piwàwacaalí pìyaca càide iyúwa Dios iwàwáaná, pìa piwénda macáita pìasuwa, pìacaténá iwènináami catúulécanéeyéi irí. Càita pidènìapiná pìasu cawèníiriwa chènuniré. Néese pèepùawa pìacaténáwa núapicha iyúwa nuéwáidacalé —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Yái ùuculìiri idécanáami yéemìacani, yá achúmaca iwàwa, càasucáináni, yá yàacawa Jesús íicha, càmicáináté iwàwa yàaca macáita yàasuwa áibanái irí. ");
INSERT INTO pioNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Néese Jesús íimaca walí, wía yéewáidacaléca: —‍Péemìacué cayábani, máiní càulenáca càasuíri yeebáidaca Dios itàacái, Dios icùacaténáni. ");
INSERT INTO pioNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Núumacué pirí àniwa, càide iyúwa camello càmíiná yáalimá iwàlùacawa siduwíapi ituí yáapuí irìcubàa, càita nacái máiní càulenáca càasuíri yeebáidaca Dios itàacái, Dios icùacaténáni, máinícáiná cáinináca càasuíri iicáca yàasuwa Dios íicha —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Wía yéewáidacaléca idécanáami wéemìacani, yá wáináidacawa manuísíwata wéemìacani, càmicáiná wáalíawa càinácaalí íimáaná. Yá wasutáca wéemìawani: —‍Néeni, ¿cawinápinásica yáalimá iwasàaca yáawawa Dios yàasu yùuwichàacáisi íicha? —‍wáimaca. ");
INSERT INTO pioNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Néese Jesús iicáidaca walí, yá íimaca walí: —‍Càmita yéewa wenàiwicanái nawasàaca níawawa Dios yàasu yùuwichàacáisi íicha nachàini iyúwa meedá, quéwa Dios yáaliméeri iwasàaca nía —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Néese Pedro íimaca irí: —‍Wadéca wamàacaca macáita wàasuwa, yá wadéca wàacawa píapicha yéewacaténá péewáidacaléca wía. Néeni, ¿càinásica wadènìapiná chènuniré? —‍íimaca. ");
INSERT INTO pioNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Néese Jesús íimaca walí: —‍Péemìacué cayábani, áiba èeriwa Dios iwàlisàidapiná macáita. Néese núa, asìali Dios néeséerica, núawinapináwa nùasu yàalubáisi mèlumèluíri íinatawa, nucùacaténá macáita. Píacué nacái nuéwáidacaléca, píawinapinácuécawa doce namanùbaca yàalubáisi íinata picùacaténácué doce namanùbaca Israel itaquénáinámi yàawiría. ");
INSERT INTO pioNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Numáidacué abénaméeyéi péená nàanápináwa nacapèe íichawa nacàlidacaténá áibanái irí nutàacái. Aibanái péenácué nacái nàapináwa néenánái íichawa, càmicaalí nacái néenánái inanái íichawa, càmicaalí nacái náaniri íichawa, càmicaalí nacái náatúa íichawa, càmicaalí nacái néenibe béeyéi íichawa, càmicaalí nacái nabànacale yàaluná íichawa nacàlidacaténá nutàacái. Quéwa Dios yàapinácué pirí cien imanùbaca yàawiríapiná cayábéeri wawàsi. Pidènìapinácué nacái picáucawa càmíiri imáalàawa. ");
INSERT INTO pioNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Quéwa manùbéeyéi wenàiwica áibanái iiquéeyéica iyúwa máiníiyéica cachàinica siùcade, càmita máiní cachàini níawa áiba èeriwa. Manùbéeyéi nacái wenàiwica áibanái iiquéeyéica iyúwa càmíiyéica máiní cachàini siùcade, áiba èeriwa yásí máiní cachàiníwanái cachàinica níawa áibanái íicha —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Néeseté Jesús íimaca walí, wía yéewáidacaléca: “Dios imànipiná nalí cayábéeri, cawinácaalí íibaidéeyéica irípiná. Péemìacué yái tàacáisi comparaciónca: Yái Dios icùanáca yàasu wenàiwicawa ìyaca càide iyúwa bànacalé íiwacali imàníiná. Yái íiwacalica yàacawa mapisáisíwata icutácaténá wenàiwica íibaidéeyéipiná yàasu uva ibànacalená yèewiré. ");
INSERT INTO pioNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Néese idécanáami itàaníca abénaméeyéi wenàiwica yáapicha ipáyaidacaténá nía abé èeri iwènicatái, yá ibànùaca nía náibaidáanápiná yàasu uva ibànacalená yèewiré. ");
INSERT INTO pioNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Néese a las nueveta mapisáita, yàacawa àniwa, yá iicáca áibanái ibàluèyéicawa bàacháwáise nacùaca nàyaca néré íibaidacalési. ");
INSERT INTO pioNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Yá íimaca nalí: ‘Pìacué píibaidaca nacái nùasu uva ibànacalená yèewiré, yásí nupáyaidacué pía cayába càide iyúwa píibaidáaná’, íimaca nalí. Iná nàacawa náibaidaca irí. ");
INSERT INTO pioNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Néese machacànicaalí èeri, yá bànacalé íiwacali yàacawa àniwa. Yá itàaníca áibanái yáapicha íibaidéeyéipiná irí. Yá nàacawa náibaidaca irí bànacalé yèewiré. Yá néese a las tresta táicalé, yá itàaníca áibanái yáapicha àniwa náibaidacaténá irí bànacalé yèewiré nacái. Yá nàacawa néré. ");
INSERT INTO pioNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Néese a las cincota táicalé àniwa, yá yèepùa iicáca áibanái icutéeyéica íibaidacalési. Yá íimaca nalí: ‘¿Cánácué pibàlùawa èeríapinama chái canéeyéi meedá íibaidéeri?’ íimaca nalí. ");
INSERT INTO pioNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Náimaca irí: ‘Wàya chái canácáiná imáidéeri wía wáibaidacaténá’, náimaca irí. Néese íimaca nalí: ‘Pìacué nacáiwa píibaidaca nulí nubànacale yèewiré’, íimaca nalí. Yá nàaca náibaidaca. ");
INSERT INTO pioNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Catácaalí nàwali, yái bànacalé íiwacali íimaca yàasu wenàiwica iríwa ipáyaidéerica wenàiwica: ‘Pimáida níara íibaidéeyéica, pipáyaidáaná níawa. Pipáyaida quéecha níái yàanèeyéica náamiwáise macáita, néese pipáyaida níái yàanèeyéicaté napíchalécáwa, àta níara idàbáanéeyéicaté yàanàaca’, íimaca yái íiwacalica. ");
INSERT INTO pioNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Néese nàanàaca néré níái idàbéeyéicaté íibaidaca a las cincota táicalé, yá ipáyaidaca nía abé èeri iwènicatái. ");
INSERT INTO pioNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Néese napáyaida nàacawa macáita àta nàanàacataléta néré níái idàbéeyéicaté íibaidaca mapisáisíwata, yá nayúunáidaca ipáyaidapináca nía manuí yáwanáita. Càita quéwa ipáyaidaca nía macáita abé èeri iwènicatáita. ");
INSERT INTO pioNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Needácanáami yái plataca, yá nadàba natàaníca báawéeri iyú bànacalé íiwacali ìwali. ");
INSERT INTO pioNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Náimaca irí: ‘Níacata yàanèeyéicaté a las cinco táicalé, nadéca náibaidaca abéeri hora meedá. Yá pipáyaidaca nía abédanamata wáapicha, wía yùuwichèeyéicawa íibaidaca ùuléeri yáapiré èeríapinama’, náimaca irí. ");
INSERT INTO pioNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Yá bànacalé íiwacali itàaníca àniwa yáapicha abéeri néená íibaidéeyéicaté èeríapinama. Yá íimaca irí: ‘Pía, nùacawéerináca, càmita numàni pirí báawéeri. Mapisáita bàwina nutàanícaté píapicha, yá abédanamata wáiwitáise wáapichawáaca nupáyaidacaténá pía abé èeri iwènicatái. ");
INSERT INTO pioNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Peedá pìasu platawa pìacaténáwa matuíbanáita. Nuwàwa nùaca irí yái yàanèericaté a las cincota táicalé càitade iyúwa nupáyaidáaná pía. ");
INSERT INTO pioNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Núalimá numànica nùasu yáapichawa càide iyúwa nuwàwáaná. Picá báawa piicáca núa ìwalíise yái numàníináca cayábéeri áibanái irí mawèníiri iyú’, íimaca yái bànacalé íiwacalica. ");
INSERT INTO pioNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","“Càita nacái, píacué idàbéeyéicaté íibaidaca nulí quéechatécáwa, áibanái nacái íibaidéeyéipiná nulí píamiwáise, numànipiná canánama irí cayábéeri càide iyúwa nuwàwáaná numànica nalí cayábéeri”, íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Jesús idéca idàbaca yàacawa Jerusalén ìyacàlená nérépiná. Iná itéca wía yéewáidacalécawa doce wamanùbaca méetàucuta áibanái íicha. Yá íimaca walí: ");
INSERT INTO pioNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","—‍Càide iyúwacué piicáaná, wàacawa wàyaca Jerusalén ìyacàlená nérépiná. Aibanái presopináca namànica núawa, núa asìali Dios néeséerica, natécaténá núa sacerdote íiwacanánái yàatalé, nía nacái yéewáidéeyéica wenàiwica templo irìcu. Yá nachùulìaca áibanái nanúanápiná núa. ");
INSERT INTO pioNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Yá natépiná núa presoíri iyú càmíiyéi judío yàatalé naicáanícaténá nuquíniná, yá nacapèedáidapiná núa, yá natàtàapiná núa cruz ìwali nuétácaténáwa. Quéwa máisiba èeri irìcu, yá numichàapinácawa yéetácáisi íicha —‍íimaca walí yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Néeseté Zebedeo yéenibe yáatúa ùacawa Jesús yàatalé uénibe yáapichawa níái Santiago, Juan nacái. Yá ubàlùacawa ùuluì ipùata iyúwa Jesús irí usutácaténá íicha wawàsi imàníinápiná ulí cayábéeri. ");
INSERT INTO pioNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Yá Jesús íimaca ulí: —‍¿Càinásica piwàwa numànica pirí? —‍íimaca yái Jesúsca. Néese úumaca irí: —‍Pimàaca nuénibe pucháiba náawinacawa píapicha nacùacaténá píapicha macái wenàiwica áiba èeriwa picùacaalípiná macáita píiwitáise cachàiníiri iyúwa. Pimàaca náawinacawa píapicha, abéeri yáawinacaténáwa péewápuwáise, abéeri nacái yáawinacawa apáulìcuíse pirí nacùacaténá píapicha macái èeri mìnanái —‍úumaca. ");
INSERT INTO pioNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Quéwa Jesús íimaca nalí níái Santiago, Juan nacái: —‍Càmitacué píalíawa càinácaalí iwàwacutáanápiná pimànica Dios imàacacaténácué pirí yái pisutéericuéca nuícha, picùanápinácué núapicha macái wenàiwica. ¿Píalimásicué piùwichàacawa càide iyúwa nùuwichàanápináwa yéewacaténácué cachàiníiyéica pía càide iyúwacué pisutáaná nuícha? —‍íimaca yái Jesúsca. Néese náimaca Jesús irí: —‍Báisíta, Wáiwacali, wáaliméeri wamànica —‍náimaca. ");
INSERT INTO pioNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Néese Jesús íimaca nalí: —‍Báisítacué piùwichàapinácawa càide iyúwa nùuwichàanápináwa, quéwa Dios càmita ibatàa numàacapinácué píawinacawa núapicha abéericué péená yáawinacaténáwa nuéwápuwáise, áibacué péená nacái yáawinacawa apáulìcuíse nulí, picùacaténácué núapicha macái wenàiwicata, yácáináta Núaniri Dios imàacapiná nalíni, cawinácaalí wenàiwicanái Dios íináidéeyéicatéwa náawináanápináwa núapicha wacùacaténá macái wenàiwica —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Wía, Jesús yéewáidacaléca diez wamanùbaca, wéemìacaté yái nasutáanáca Jesús íicha wawàsi, yá calúaca wía náapicha, níái pucháiba Zebedeo yéenibeca. ");
INSERT INTO pioNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Quéwa Jesús imáidaca yàataléwa wía. Yá íimaca walí: —‍Píalíacuécawa càinácaalí iyú càmíiyéi judío imànica icuèyéica yàasu cáli néeséeyéiwa; casíimáica nacùaca wenàiwica cachàiníiri iyú. Píalíacuéwa nacái casíimáica náiwacanánái nachùulìaca macái wenàiwica. ");
INSERT INTO pioNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Quéwa iwàwacutácué càmita pìya càide iyúwa nàyáaná. Néese cawinácaalícué péená iwàwéerica Dios iicácani càiride iyúwa cachàiníirica íiwitáise, iwàwacutá iyúudàacuéca pía macáita. ");
INSERT INTO pioNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Cawinácaalícué péená iwàwéerica Dios iicácani càiride iyúwa cachàiníirica áibanái íicha, iwàwacutá íibaidacuéca pirí macáita càide iyúwa yàasu wenàiwica íibaidáaná íiwacali iríwa. ");
INSERT INTO pioNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Iwàwacutácué cài pimànica, núacáiná, núa asìali Dios néeséerica, éwitacué Píiwacalicáaníta núa, càicáaníta càmita nùanàa náibaidacaténá nulí meedá. Néese nudéca nùanàaca nuíbaidacaténá áibanái wenàiwica irípiná, numàacacaténá nacái nucáucawa nuwasàacaténá manùba wenàiwica Dios yàasu yùuwichàacáisi íicha, yái yàanèeripináca nàwali nabáyawaná ìwalíisewa —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Néeseté wamusúacawa Jericó ìyacàlená íicha, yá manùbéeyéi wenàiwica nàacawa Jesús yáamíise. ");
INSERT INTO pioNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Yá pucháiba matuíyéi nàyaca néeni, yáawinéeyéicawa àyapu idùlepi isutéeyéica plata náicha níái wenàiwicaca ichàbéeyéicawa néenibàa. Matuíyéi isutáca náicha plata yéewanápiná nawènìaca nayáapináwa. Náalíacáináwa Jesús iináwaná ichàbáanáwa chábài, yá namáidaca Jesús irí: —‍¡Wáiwacali, rey David itaquérinámi, Dios ibànuèricaté walí wacuèrinápiná, piicá wapualé! —‍náimaca. ");
INSERT INTO pioNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Manùbéeyéi wenàiwica nacuísaca níái matuíyéica masànáanápiná nía, quéwa namáida quéwanáta mamáalàacata cachàiníiri iyú. Náimaca: —‍¡Wáiwacali, rey David itaquérinámi, Dios ibànuèricaté walí wacuèrinápiná, piicá wapualé! —‍náimaca. ");
INSERT INTO pioNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Iná Jesús iyamáaca ibàlùacawa, yá imáidaca níái matuíyéica. Néese isutáca yéemìawa nía: —‍¿Càinásicué piwàwa numànica pirí? —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Náimaca irí: —‍Wáiwacali, wawàwa pimàaca catuíca wía —‍náimaca. ");
INSERT INTO pioNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Catúulécanáca Jesús iicáca nía, yá imàacaca icáapiwa natuí ìwali. Yáta matuíyéimi iicáidaca àniwa, yá nàacawa Jesús yáapicha. ");
INSERT INTO pioNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Wàanàacaté mawiénita Jerusalén ìyacàlená irí; quéechatécáwa wàanàaca Betfagé ìyacàlená néré, ìyéerica dúli ìwali íipidenéechúa Olivos, yái olivo inàlimanáca. Yá Jesús ibànùaca ipíchalépináwa pucháiba wéená wía yéewáidacaléca. ");
INSERT INTO pioNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Ipíchawáise Jesús ibànùaca nía, yá íimaca nalí: —‍Pìacuéwa irìculé yái yàcaléca ìyéerica wapíchalé. Nérécué pìanàapináca burro nadacuèchúa néré, ibàluèchúawa uìri yáapichawa. Piwasàacué úa, pitécué nulí níawa. ");
INSERT INTO pioNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Aibacaalícué isutá yéemìawa píawa càinácaalícué pimàni, picàlidacué iríwani nuwàwacutáca níái burroca, núa Píiwacalicuéca, nubànùanápiná nacái wenàiwica natécaténá irí nía àniwa caquialéta —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Càité Jesús imànica càide iyúwaté Dios yàasu profeta itànàanáté tàacáisi Dios inùmalìcuíse. Dios íimacaté: ");
INSERT INTO pioNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Picàlidacué nalíni níái ìyéeyéica Jerusalén ìyacàlená irìcu, áibaalí íipidenácatalé Sión: ‘Piicácué, Picuèriná yàanàaca pìatalécué, càmíiri cáimacái iicáca yáawawa, cáimiétacanéeri, matuíbanáiri iyú nacái, yáawinéeriwa burro wàlisài íinata, uìrica abéechúa pìrái itéechúa yàasusi’, càicué píimaca nalíwa”, íimacaté yái Diosca. ");
INSERT INTO pioNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Níái pucháiba yéewáidacaléca nàacawa, yá namànicaté càide iyúwa Jesús íimáanáté nalí. ");
INSERT INTO pioNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Natéca úái burroca, uìri nacái. Yá walìadaca wàasu ruana nacáiriwa nawaalírìcubàa, yéewanápiná Jesús yàalubáicani. Yá Jesús imichàa yáawinacawa burro íinata. ");
INSERT INTO pioNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Manùbéeyéi wenàiwica ìyaca néré wáapicha. Abénaméeyéi natéca nàasu ruana nacáiriwa náuquéeri nàwalíisewa, yá nalìadaca nía àyapulìcubàa Jesús ipíchalé, burro ìipìnacaténá íinatabàa càide iyúwaté judío íiwitáise nàaná nacuèriná icàaluínináwa. Aibanái nacái nawichùaca wisìri nacáiri ibáiná, yá nalìadaca nía àyapulìcubàa Jesús ipíchalé, náasáidacaténá casíimáica naicácani. ");
INSERT INTO pioNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Níái yèeyéicawa Jesús ipíchalé, níái nacái yèeyéicawa yáamiwáise namáidáidaca casíimáicáiná nía. Náimaca: —‍¡Wàacué irí cayábéeri, yái rey David itaquérinámica, Dios ibànuèrica walí wacuèrinápiná! ¡Cayábéeriquéi Wacuèrináca, Dios ibànuèrica walí, icùacaténá wía! ¡Wàaca pirí cayábéeri, pía Dios chènuníiséerica! —‍náimaca. ");
INSERT INTO pioNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Jesús iwàlùacawa Jerusalén ìyacàlená irìculé, yá macáita wenàiwica namusúacawa nacapèe íichawa naicácaténáni. Manùbéeyéi nasutáca néemìawa wenàiwica yèeyéicawa Jesús yáapicha. Yá náimaca: —‍¿Cawinásica yái wenàiwicaca? —‍náimaca. ");
INSERT INTO pioNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Néese níái wenàiwicaca yèeyéicawa Jesús yáapicha náimaca nalí: —‍Yácata profeta Jesús, yái Nazaret ìyacàlená néeséerica, yàanèerica Galilea yàasu cáli néese, itàaníirica Dios inùmalìcuíse —‍náimaca. ");
INSERT INTO pioNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Néeseté Jesús iwàlùacawa templo ibàacháwalená irìculé. Yá imusúadaca wenàiwicanái templo ibàacháwalená irìcuíse, macáita iwéndéeyéicaté yàasusi, áibanái nacái iwènièyéica yàasusi templo ibàacháwalená irìcu. Itamàaca yúucawa náicha nàasu mesa canánama, níái icambiéyéica plata wenàiwica íicha needácaténá nalíwa plata. Jesús itamàaca yúucawa náicha nàalubáica níái iwéndéeyéica unùcu sacrificio pinéerica. ");
INSERT INTO pioNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Yá Jesús íimaca nalí: —‍Pidécuéca péemìaca tàacáisi profeta itànèericaté Dios inùmalìcuíse. Dios íimacaté yàasu templo ìwaliwa: ‘Yái nucapèeca nasutácàalupináca nuícha’, íimacaté yái Diosca. Quéwa, pidécuéca piwènúadacani cayéedéeyéi icapèe iyú, yái temploca, piyéedùacáinácué plata wenàiwica íicha pichìwa iyúwa —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Néese abénaméeyéi matuíyéi, áibanái nacái éeruíyéi yàabàli nàacawa Jesús yàatalé templo irìcu. Yá ichùnìaca nía. ");
INSERT INTO pioNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Quéwa sacerdote íiwacanánái, nía nacái yéewáidéeyéica wenàiwica templo irìcu báawaca naicáca Jesús imàníináca yái càmíirica wenàiwica idé imànica, cayábacáiná wenàiwicanái iicáca náicha Jesús. Néemìaca nacái sùmanái isàna imáidéeyéica casíimáiri iyú templo irìcu; sùmanái íimaca Jesús ìwali: “¡Wàacué irí cayábéeri, yái rey David itaquérinámica, Dios ibànuèrica walí Wacuèrinápiná!” náimaca níái sùmanáica. Iná calúaca sacerdote íiwacanánái, nía nacái yéewáidéeyéica wenàiwica templo irìcu, yácáiná yái tàacáisi sùmanái icàlidéerica íimáanáca Mesíascani yái Jesúsca, judío icuèrinápiná Dios ibànuèrica nalí. ");
INSERT INTO pioNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Néese sacerdotenái íimaca Jesús irí: —‍Picá pimàaca nacàlidaca pìwali yái tàacáisica. Pichùulìa masànáanápiná nía, ipíchaná áibanái nayúunáidaca Mesíasca pía —‍náimaca. Yá Jesús íimaca nalí: —‍Casíimáica nuémìaca yái náimáanáca. Pidécuéca piléeca tàacáisi Dios yàasu profeta itànèericaté nuináwaná ìwali, íiméerica sùmanái nacàlidáanápináté nuináwaná cayábéeri iyú. Profeta íimacaté: ‘Pía Wacuèriná Dios, pidéca pimàacaca púubanaméeyéi sùmanái, quìrasìinái nacái nàaca pirí cayábéeri’, cài íimacaté nùwali yái profetaca. ¿Cánácué càmita péemìa càinácaalí íimáaná yái Dios itàacái piléericuéca? —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Néeseté Jesús yàacawa náicha. Yá imusúacawa wáapicha Jerusalén ìyacàlená íicha, wía yéewáidacaléca. Néese macáita wàacawa Betania ìyacàlená néré, yá waimáca néré. ");
INSERT INTO pioNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Néeseté mapisáináami àniwa Jesús, wía nacái yéewáidacaléca, idècunitàacá wàacawa Jerusalén ìyacàlená nérépiná àniwa, yá máapicani, yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Néese iicáca higuera yéetaná ibàluèricawa àyapu idùlepi. Yá Jesús yàacawa higuera yéetaná yàatalé icutácaténá ìyacaná. Quéwa canáca ìyacaná, iicá ibáiná meedá. Néese Jesús íimaca àicu irí: —‍¡Càmita quirínama càyacanáca píawa! —‍íimaca yái Jesúsca, yáasáidacaténá walí Dios yùuwichàidáanápináté israelitanái. Yáta ichuìdacawa macáita yái higuera yéetanámica, yá yéetácawa. ");
INSERT INTO pioNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Néese wía, Jesús yéewáidacalénái waicácáináni, yá wáináidacawa manuísíwata waicáidaca higuera yéetanámi irí. Yá wasutáca wéemìawa Jesús: —‍¿Càiná yéewaná ichuìdacawa abéerìcuíseta, chuìcani yái higueraca yéetanámica? —‍wáimaca. ");
INSERT INTO pioNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Néese Jesús íimaca walí: —‍Iwàwacutácué peebáidaca tài íiméeri iyú Dios imàníinápinácué pirí càinácaalícué cayábéeri pisutéerica íicha imàníinápinácué pirí. Péemìacué cayába, píibàacaalícué piwàwawa Dios iwéré tài íiméeri iyú, yásí píalimácué pimànica càide iyúwa núumáaná higuera yéetanámi irí. Píalimápinácué nacái pimànica cachàiníwanái. Píimacaalícué yái dúli irí: ‘Pimichàawa, picaláawa manuíri úni yáaculé’, càicaalícué píima, yásí yàacawa càide iyúwacué píimáaná irí, báisícaalícué peebáidaca Dios imàníinápinácué piríni. ");
INSERT INTO pioNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Núumacué pirí nacái, macáita càinácaalí cayábéeri pisutéericuéca Dios íicha imàníinápinácué pirí, yá peebáidacaalícué tài íiméeri iyú Dios imàníinápinácué piríni, yásí Dios imànicuéca piríwani —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Néeseté Jesús iwàlùacawa templo irìculé. Yá idàbaca yéewáidaca wenàiwica néré. Néese sacerdote íiwacanánái, nía nacái judío íiwacanánái béeyéica nàacawa Jesús yàatalé. Yá nasutáca néemìawani: —‍¿Cawiná ibànùa pía pimusúadáanápiná wenàiwica templo ibàacháwalená irìcuíse níái iwéndéeyéica yàasusi? ¿Cawiná ichùulìa pía pimusúadáanápiná nía? —‍náimaca Jesús irí. ");
INSERT INTO pioNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","25","Néese Jesús íimaca nalí: —‍Núa nacái nuwàwa nusutácuéca nuémìawa pía: ¿Cawiná ichùulìaté Juan ibautizáanápiná wenàiwica, Diossica? ¿Wenàiwicanáisica? Píimacué nulí càiríinácaalí náicha ichùulièricaté Juan ibautizáanápiná wenàiwica. Picàlidacué nulíni. Picàlidacaalícué nulíni, yásí nucàlidacué nacái piríwani cawinácaalí ichùulìaca núa numusúadáanápiná wenàiwica templo ibàacháwalená irìcuíse níái iwéndéeyéica yàasusi —‍íimaca yái Jesúsca. Néese nadàbaca natàaníca nalíwáaca. Náimaca: “Wáimacaalí irí Dios ichùulièriquéera Juan, yásí isutáca yéemìawa wíatá: ‘Néeni, ¿cánácué càmitaté peebáidani?’ càipiná íimaca walí. ");
INSERT INTO pioNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Càmita nacái wawàwa wáimaca irí wenàiwica ichùulièriquéera Juan, cáalucáiná wía wenàiwicanái íicha, macáita wenàiwica neebáidacáiná Juan itàanícaté Dios inùmalìcuíse”, cài náimaca nalíwáaca. ");
INSERT INTO pioNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Iná náimaca Jesús irí: —‍Càmita wáalíawa —‍náimaca. Néese Jesús íimaca nalí: —‍Càita nacái càmitacué nucàlida piríni cawinácaalí ichùulìaca núa numusúadáanápiná wenàiwica templo ibàacháwalená irìcuíse, níái iwéndéeyéica yàasusi —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Jesús isutáca yéemìawa judío íiwacanánái, sacerdote íiwacanánái nacái: —‍¿Càinácué píináidacawa ìwali yái comparaciónca? Péemìacuéni. Abéeri asìali idènìacaté yéenibewa pucháiba asìanái. Yá íimaca abéeri néená irí, yái idàbáanéerica: ‘Nuìri, siùcade pìa píibaidaca nùasu uva ibànacalená yèewiré’, íimaca yái náanirica. ");
INSERT INTO pioNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Néese ìiri íimaca yáaniri iríwa: ‘Càmita nuwàwa nuíbaidaca’, íimaca. Néeseta quéwa iwènúadaca íiwitáisewa, yá yàaca íibaidaca néré. ");
INSERT INTO pioNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Néese náaniri yàacawa imáidacaténá ìiri áibawa. Yá ichùulìaca íibaidaca uva ibànacalená yèewiré. Néese ìiri íimaca yáaniri iríwa: ‘Iyá, pápa. Yáca nùacawéera’, íimaca. Quéwa càmita yàawa néré —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Néese Jesús isutáca yéemìawa judío íiwacanánái, nía nacái sacerdote íiwacanánáica. Yá íimaca nalí: —‍¿Càiríiná náicha níái asìali yéenibe pucháiba imànica càide iyúwa yáaniri iwàwáaná? —‍íimaca yái Jesúsca. Néese náimaca irí: —‍Yái idàbáanéerica —‍náimaca. Néese, Jesús yèepùa íimaca nalí: —‍Péemìacué cayába yái nutàacáica. Báisíta áibanái yeedéeyéicaté plata yéenánái íichawa romanonái yàasu gobierno irípiná, nía nacái inanái iiméeyéicaté asìanái yáapicha plata ìwalinápiná, nadéca nawènúadaca náiwitáisewa Dios irípiná, yá idéca Dios yàasu wenàiwicaca nía, Dios icùacaténá nía. Quéwa, píatacué càmita Dios yàasunáica. ");
INSERT INTO pioNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Yácáiná Juan el Bautistami yàanàacaté yéewáidacaténácué pía pìyáanápinácué càide iyúwa Dios iwàwáaná. Càmitacué quéwa peebáida iríni. Néese áibanái yeedéeyéicaté plata yéenánái íichawa romanonái yàasu gobierno irípiná, nía nacái inanái iiméeyéicaté asìanái yáapicha plata ìwalinápiná, níata yeebáidacaté Juan el Bautista itàacáimi. Yáté nawènúadaca náiwitáisewa nabáyawaná íichawa. Quéwa píacué, éwita piicácáanítacué neebáidaca, néese càmitacué quéwa piwènúada píiwitáisewa Dios irípiná peebáidacaténá càide iyúwaté Juan el Bautistami icàlidáaná Dios itàacái —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Néeseté Jesús yéewáidaca wenàiwica comparación iyú. Iimaca nalí: “Péemìacué comparación: Abéeri asìali idènìacaté ibànacale yàalunáwa uva yàalupiná. Yá ibànaca uva. Néese imànica iwáiná ibànacale itéesebàawa. Ichùnìaca nacái utàwi nacáichúa uva ìyacaná yàalupiná, napisùacatalépiná uva ituní. Néese imànica chènuníiri capìi naicáidacatáisepiná macáita uva ibànacalená yàalu. Yá imàacaca áibanái icuèyéipiná irí yái yàasu uva ibànacalená yàalunáca, quéwa iwàwacutácaté nabànùaca irí yàasu uva ìyacaná yéenápiná, yàasu èerita needácatáipináté ìyacaná. Idécanáamité imànica náapicha càiri wawàsi, yá néese yàacawa náicha áibalépiná. ");
INSERT INTO pioNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Uva yàasu èeri yàanàacaté needácaténá ìyacaná, yá bànacalé íiwacali ibànùaca yàasu wenàiwicanáiwa néré nacutácaténá icuèyéi íicha bànacalé íiwacali yàasu uva ìyacaná yéenápiná. ");
INSERT INTO pioNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Quéwa níái icuèyéica bànacalé náibàaca nía; nacapèedáidaca abénaméeyéi, nanúaca áibanái, néese nanúaca abénaméeyéi wenàiwica íba iyú. ");
INSERT INTO pioNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Yá bànacalé íiwacali ibànùaca nàatalé àniwa yàasu wenàiwicanáiwa áibanái, manùba yáwanái idàbáanéeri yàawiría íicha. Quéwa càita nacái níái icuèyéica bànacalé namànica nalí báawéeri mamáalàacata. ");
INSERT INTO pioNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","“Néese bànacalé íiwacali ibànùaca nàatalé ìiriwa, íináidacáináwa iríwa yái bànacalé íiwacalica: ‘Báisíta nàaca nuìri íimiétacanáwa’, íimaca íináidacawa iríwa. ");
INSERT INTO pioNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Quéwa níái icuèyéica bànacalé naicáca ìiri yàacawa napualé, yá náimaca nalíwáaca: ‘Yáara bànacalé íiwacalica yéetácaalípináwa, yá yàaca bànacalé ìiri iríwa. Ara, wàacuéwa wanúanáni. Yásí wíacata bànacalé íiwacanánái’, náimaca. ");
INSERT INTO pioNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Càita náibàacani, yá nawatàidacani bànacalé yèewíise, yá nanúacani. ");
INSERT INTO pioNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“Siùcade píimacué nulí: Yái uva ibànacalená íiwacalica, yàanàacaalípiná nàatalé, ¿càinásica imànipiná nalí, níái icuèyéicaté bànacalé?” íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Néese níái wenàiwica ìyéeyéica templo irìcu náimaca Jesús irí: —‍Inúapiná níái báawéeyéica, càmita nacái catúulécaná iicáca nía. Néese imàacapiná áibanái cayábéeyéi íiwitáise icuèyéipiná irí yái uva ibànacalenáca, ibànuèyéipiná irí yàasu uva ìyacaná yéenápiná needácaalí bànacalé ìyacaná —‍náimaca. ");
INSERT INTO pioNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Néese Jesús íimaca nalí: —‍Báisíta. Pidécuéca piléeca nacái comparación Dios yàasu profeta itànèericaté Dios inùmalìcuíse. ¿Cánácué càmita peebáida itàacái? Itànàacaté tàacáisi íiméerica Dios ibànùanápináté nacuèrinápiná, níái israelitaca, quéwa báawáanápináté naicácani. Càité profeta íimaca: ‘Níái imàníiyéica íba icapèená, nadéca náucaca abéeri íba méetàuculé náichawa, caná iwènicáiná naicácani. Quéwa Wacuèriná Dios idéca imàacaca máiníiri iwàwacutácawa capìi irípináni yái íba náuquéericaté. Càita Dios idéca imànica, íná wàaca Dios irí cayábéeri’, càité profeta íimaca nùwali, núa càiride iyúwa íba, núa israelita icuèrinápináca. ");
INSERT INTO pioNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Iná núumacué pirí, càicuéca píade iyúwa báawéeyéi icuèyéica bànacalé. Càmitacué picùa cayába israelitanái càide iyúwa Dios iwàwáaná, càmitacué nacái péewáida nía, íná càmita namàni cayábéeri. Siùcáisede Dios càmita quirínama ibatàacué picùaca yàasu wenàiwica, níái israelitaca. Yá Dios imàacapiná áibanái íibaidaca irípiná, yéewáidéeyéipiná nía cayába, namànicaténá cayábéeri càide iyúwa Dios iwàwáaná. ");
INSERT INTO pioNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Iyaca nacái áiba comparación íba ìwali: Cawinácaalí wenàiwica yúuwèeyéicawa iwéré yái íbaca, yásí wenàiwica isubèriacawa. Néese íba yúuwàacaalíwa áibanái íinatabàa, yásí náalacawa ichùmalési iyú —‍íimaca yái Jesúsca, náalíacaténáwa Dios yùuwichàidáanápiná manuísíwata cawinácaalí càmíiyéica yeebáida Jesús itàacái. ");
INSERT INTO pioNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Níái sacerdote íiwacanánáica, fariseonái nacái, idécanáami néemìaca comparación Jesús icàlidéerica, yá náalíacawa icàlidacaténi nàwali yái tàacáisica. ");
INSERT INTO pioNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ináté nawàwaca náibàacani náucacaténáni presoíyéi ibànalìculé. Quéwa cáaluca nía manùbéeyéi wenàiwicanái íicha, níacáiná manùbéeyéi wenàiwica neebáidaca Jesús itàaníca Dios inùmalìcuíse. Iná càmita nadé náibàaca Jesús. ");
INSERT INTO pioNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Néeseté Jesús idàbaca yéewáidaca nía àniwa comparación iyú. Yá íimaca nalí: ");
INSERT INTO pioNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Péemìacué comparación: Yái Dios icùanáca wenàiwica càicanide iyúwa abéeri nacuèriná imàníiná iwàwéerica imànica manuíri fiesta ìiri irípináwa, yàasu casamientopináwa, ìiri yeedácáiná iríwa yàacawéetúapináwa. ");
INSERT INTO pioNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Yá nacuèriná ibànùaca yàasu wenàiwicanáiwa nàaca namáidacaténá wenàiwica nacuèriná icàlidéeyéicaté iríni quéecha. Quéwa càmita nawàwa nàwacáidáyacacawa néré. ");
INSERT INTO pioNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Néese nacuèriná ibànùaca yàasu wenàiwicanáiwa áibanái. Ipíchawáise nàacawa, yá íimaca nalí: ‘Pìacué picàlidaca nalíni, níara numáidéeyéica, nudéca nuchùnìaca yái nayáapináca. Nùasu wenàiwica nadéca nanúaca nupìra pacá walíibèeyéi, áiba nacái nupìra walíibèeyéi. Macáicata idécawa canánama yái nayáapináca. Pisutácué nàanápináwa aléi fiesta casamiento nérépiná’, íimaca yái nacuèrináca. ");
INSERT INTO pioNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Néese nacuèriná yàasu wenàiwica namáidaca nía àniwa quéwa caná iwèni wenàiwicanái iicáca nacuèriná itàacáiwa. Abéeri néená yàaca iicáca ibànacalewa. Aiba yàacawa yàcalé néré iwéndacaténá yàasuwa. ");
INSERT INTO pioNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Yá áibanái náibàaca nacuèriná yàasu wenàiwicawa. Yá nacuísaca nía, namànica nalí báawéeri, àta nanúacataléta nía nacái. ");
INSERT INTO pioNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Yá néese máiní calúacani yái nacuèrináca. Yá ibànùaca néré yàasu úwináiwa, yá úwinái nanúaca níái inuéyéicaté meedá nacuèriná yàasu wenàiwicawa, yá úwinái yeemáca nàyacàlemi. ");
INSERT INTO pioNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Néese àniwa nacuèriná íimaca yàasu wenàiwicanái iríwa: ‘Macáicata idéca ichùnìacanáca canánama fiesta casamientopiná quéwa níara numáidéeyéicaté quéechatécáwa, canáca yéewaná nàanàaca, càmicáináté neebá numáidáaná nía. ");
INSERT INTO pioNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Iná pìacué picutáca mamáalàacata wenàiwicanái bamuchúamibàa yàcalé, àyapulìcubàa nacái pimáidacaténácué nía macáita pìanèeyéica’, íimaca yái nacuèrináca. ");
INSERT INTO pioNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Néese níái yàasu wenàiwicanái nàacawa bamuchúamibàa yàcalé àyapulìcubàa, yá nàwacáidaca macáita wenàiwica nàanèeyéica néenibàa, cayábanaméeyéi, báawanaméeyéita nacái. Iná yéewa idéca capìi ipuníacawa madécaná wenàiwica iyú, yái manuíri capìi imàdáaná casamiento yàaluca. ");
INSERT INTO pioNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Néeseta quéwa yái nacuèriná iwàlùacawa néré itàidacaténá wenàiwicanái yàanèeyéica néré nayáacaténá nayáacaléwa, yá iicáca abéeri asìali nèewi ibàlesíami yáapichawa meedá. Càmitaté ìwali ibàlewa wàlisàiwa, yái bàlesi cayábéerica nacuèriná iwacuèricaté macái wenàiwica irí, fiesta casamiento ibàlenápiná. ");
INSERT INTO pioNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Yá nacuèriná íimaca irí: ‘¿Néeni? ¿Cánásica yéewaná piwàlùacawa aléi, éwita càmicáaníta pìwali pibàlewa fiesta casamiento ibàlenápiná, yái bàlesica nuèrica nalí?’ íimaca yái nacuèrináca. Yá masànacani icalùniwa nacuèriná íicha, yái asìalica. ");
INSERT INTO pioNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Néese nacuèriná íimaca yàasu wenàiwicanái iríwa, níái iwacuèyéica yàacàsi wenàiwicanái irí: ‘Caquialéta, pidacùacué yái asìalica icáapi nacái, yàabàli nacái. Yá piúcacué wáichani aléera catéeri irìculé. Wenàiwicanái náicháanípiná manuísíwata néré, yá naamíapiná nayéiwa nàuwichàacái iyúwa’, íimaca yái nacuèrináca. ");
INSERT INTO pioNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Dios imáidacáiná manùbéeyéi wenàiwica, quéwa càmita yeedá macáita yàasu wenàiwicapináwa nía”, íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Néesetécáwa, abénaméeyéi fariseo nàwacáidáyacacawa natàaníca náapichawáaca, yá abédanamata namànica náiwitáisewa náalimáidáanápiná naicáwa Jesús icàlidacaténá áiba wawàsi báawéeri yéewanápiná nacháawàaca iináwaná ìwali romanonái yàasu gobiernonái irí. ");
INSERT INTO pioNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Iná nabànùaca abénaméeyéi néenáwa Jesús yàatalé náapicha nacái áibanái cayábéeyéi iicáca rey Herodes íiwitáise. Yá náimaca Jesús irí: —‍Pía, yéewáidéerica wenàiwica, wáalíacawa pitàaníca báisíiri iyú, péewáidaca nacái wenàiwica báisíiri iyú nàyacaténá machacàníiri iyú càide iyúwa Dios ichùulìaná nàyaca. Wáalíacawa nacái piicáca macái wenàiwica abédanamata, íná càmita pibatàa áiba wenàiwica caináwanéeyéi iwènúadaca píiwitáise cayábéeri íicha. ");
INSERT INTO pioNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Iná picàlida walíni càinácaalí píináidacawa: ¿Cayábasica wapáyaidacaalí wáichawa plata iyú níara emperador romanosàiri yàasu gobiernonái icuèyéica wàasu cáli? —‍náimaca. ");
INSERT INTO pioNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Quéwa Jesús yáalíaca náiwitáise báawéeri nawàwáaná nacháawàaca iináwaná ìwali itàacái ìwalíisewa. Yá íimaca nalí: —‍Píacué pucháibéeyéica íiwitáise, ¿cánácué píalimáida piicáwa núa picháawàacaténá nuináwaná ìwali nutàacái ìwalíise? ");
INSERT INTO pioNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Néeni, píasáidacué nuicá moneda càichúaca nachùulìacuéca pipáyaidaca iyú nía —‍íimaca yái Jesúsca. Yá natéca irí denario, yái cawèníiri monedaca abé èeri iwènicatáica. ");
INSERT INTO pioNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Néese Jesús isutáca yéemìawa nía: —‍¿Cawiná yéenáiwaná ichanàawa moneda ìwali? ¿Cawiná nacái íipidená ichanàawa ìwali? —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Yá náimaca irí: —‍Emperador íipidenáquéi ichanàawa ìwali, yéenáiwaná nacái ichanàawa ìwali, yáara romano íiwacaliná, icuèrica macái èeri mìnanái —‍náimaca. Iná Jesús íimaca nalí: —‍Pipáyaidacué píichawa emperador plata iyú càide iyúwa ichùulìanácué pipáyaidacani. Pimànicué nacái càide iyúwa Dios iwàwáanácué pimànica —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Yá náináidacawa manuísíwata néemìaca Jesús íimáaná, càmicáiná náalimá nacháawàaca iináwaná ìwali itàacái ìwalíisewa. Néese namàacacani, yá nàacawa íicha. ");
INSERT INTO pioNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Néese yáté èerica àniwa abénaméeyéi saduceo nàacawa Jesús yàatalé. Níái saduceo náimaca yéetéeyéimiwa càmitasa nacáucàawa áibaalípiná. Saduceonái iwàwaca wenàiwicanái iicáaníca Jesús iquíniná, íná nasutáca néemìawa Jesús, náalimáidacaténá naicáwani. Yá nacàlidaca irí tàacáisi. Náimaca irí: ");
INSERT INTO pioNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","—‍Pía, yéewáidéerica wenàiwica, profeta Moisés itànàacaté tàacáisi íiméerica Dios ichùulìanácué wía judíoca wamàníinápiná cài: Asìali yéetácaalíwa méenibeta, yásí iwàwacutá yéenásàiri yeedáca iríwa yéenásàiri íinumiwa yàacawéetúapináwa yéewacaténá idènìaca úapicha yéenibewa naiquéeyéipiná iyúwa yéetéerimiwa yéenibemi, yéewanápiná nàyaca wenàiwica icuèyéipiná yéetéerimiwa yàasu cáli. ");
INSERT INTO pioNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Uwé, áibaalíté nàyaca wèewi siete namanùbaca yéenánái. Nabèeri yeedáca abéechúa íinupináwa, quéwa yéetácawa uícha méenibeta. Méenibecáináni, íná iméeréeri yeedáca úái ibèeri íinumicawa. ");
INSERT INTO pioNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Càita nacái iméeréerimi yéetácawa uícha méenibeta. Néese iméeréeri yeedáca úa, càita nacái yéetácawa uícha méenibeta. Càité níái sietéeyéicaté imanùbaca needáca úa. Yá néetácawa uícha macáita méenibeta. ");
INSERT INTO pioNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Néese úanama yéetácawa náami nacái. ");
INSERT INTO pioNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Uwé, báisícaalí yéetéeyéimiwa idé icáucàacawa áibaalípinátá, càide iyúwa áibanái íináidáanáwa, néese ¿càinápinásica unìri náicha níara sietéeyéimica? Càmita náalimápiná náalíacawatá macáicáináta náinuca úa —‍náimaca, naicáaníca Jesús iquíniná. ");
INSERT INTO pioNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Néese Jesús íimaca nalí: —‍Pidécuéca piméeràacawa báisíiri tàacáisi íicha càmicáinácué píalíawa càinácaalí íimáaná Dios itàacái profetanái itànèericaté Dios inùmalìcuíse. Càmitacué nacái píalíawa Dios íiwitáise cachàiníiri ìwali imichàidáanápiná wenàiwica yéetácáisi íicha. ");
INSERT INTO pioNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Aiba èeriwa yéetéeyéimiwa nacáucàapinácawa, quéwa càmita nacásàapináwa, níái asìanáica, inanái nacái, nàyapinácáiná càide iyúwa chènuníiséeyéi ángel ìyáaná càmíiyéica icásàawa. ");
INSERT INTO pioNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Aiba wawàsi nacái, piyúunáidacuéca càmita Dios icáucàidapiná wenàiwica áiba èeriwa, quéwa pidécuéca piléeca cuyàluta profeta Moisés itànèericaté Dios inùmalìcuíse, íná ¿cánácué càmita péemìa càinácaalí íimáaná? ");
INSERT INTO pioNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Dios íimacaté: ‘Núacata yái Dios icuèrica Abraham, Isaac nacái, Jacob nacái’, càité íimaca yái Diosca. ¡Dios càmita icùa yéetéeyéimiwa ichéeca meedá! ¡Néese Dios icùaca cáuyéi wenàiwica! Iná iwàwacutácué píalíacawa cáuca nía Dios yáapicha siùcade, níái Abraham, Isaac, Jacob nacái, éwita néetácáanítatéwa madécaná camuí ipíchawáiseté Moisés ìyaca. Iná yéewa wáalíacawa Dios icáucàidáanápiná yéetéeyéimiwa áiba èeriwa —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Néese wenàiwicanái nadécanáami néemìacani, yá náináidacawa manuísíwata néemìaca Jesús yéewáidáaná nía. ");
INSERT INTO pioNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Néeseté fariseonái idécanáami néemìaca Jesús iináwaná imawènìadacaté saduceonái yàasu tàacáisi, yá fariseonái nàwacáidáyacacawa. ");
INSERT INTO pioNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Néese abéeri fariseo yéewáidéeri wenàiwica templo irìcu, íináidacawa yáalimáidáanápiná iicáwa Jesús icàlidáanápiná áiba wawàsi báawéeri nacháawàacaténá iináwaná ìwali ìwalíise. Yá íimaca Jesús irí: ");
INSERT INTO pioNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","—‍Pía yéewáidéerica wenàiwica, nàyaca madécaná wawàsi Dios ichùulièrica wamàníinápináca. ¿Càiríiná wawàsi máiníiri cachàinica náicha canánama wamàníinápiná? —‍íimaca. ");
INSERT INTO pioNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","38","Néese Jesús íimaca irí: —‍Yái Dios ichùulìanáca máiníirica cachàinica náicha canánama wamàníinápiná cài íimaca: ‘Cáininá piicáca Picuèriná Dios macái piwàwalìcuísewa, macái picáuca iyú nacáiwa, macái píiwitáise iyú nacáiwa’, cài íimaca. ");
INSERT INTO pioNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Iyaca walí áiba inacáiri nacái, yái pucháibáanáca. Yá íimaca: ‘Cáininá piicáca áibanái wenàiwica càide iyúwa cáinináaná piicáca píawawa’, cài íimaca yái Diosca. ");
INSERT INTO pioNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Canáca áiba tàacáisi cachàiníiri náicha níái pucháiba ichùulìacanásica. Macáita tàacáisi profeta Moisés itànèericaté Dios inùmalìcuíse, profetanái nacái icàlidéericaté Dios inùmalìcuíse, macáita yái tàacáisica yéewáidaca wía cáinináanápiná waicáca Dios, áibanái wenàiwica nacái —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Néese idècunitàacá fariseonái ìyaca Jesús íipunita, yá Jesús isutáca yéemìawa nía. ");
INSERT INTO pioNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","Iimaca nalí: —‍¿Càinácué píináidacawa Mesías ìwali, yái picuèrinápinácuéca Dios ibànuèripinácuéca pirí, píacué israelitaca? ¿Cawiná itaquérinámini? —‍íimaca yái Jesúsca. Néese náimaca Jesús irí: —‍Rey David itaquérinámicani, yái Mesíasca —‍náimaca. ");
INSERT INTO pioNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Néese Jesús íimaca nalí: —‍Báisíta rey David itaquérinámicani yái Mesíasca. Quéwa rey Davidcaté íimaca áiba wawàsi nacái Mesías ìwali, yái israelita icuèrinápináca. David icàlidacaté Espíritu Santo inùmalìcuíseni, yá David íimacaté Mesías ìwali ‘Nuíwacali’. Càité David íimaca: ");
INSERT INTO pioNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Nucuèriná Dios íimacaté Nuíwacali irí: Píawinawa nuéwápuwáise picùacaténá núapicha macáita, idècunitàacá numawènìadaca píicha macái piùwidenáiwa, íimaca yái Diosca’, càité íimaca yái Davidca. ");
INSERT INTO pioNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Yái rey Davidca íimacaté Mesías ìwali ‘Nuíwacali’, íná éwita rey David itaquérinámicáanítani, yái Mesíasca, càicáaníta iwàwacutá náimaca ìwali rey David Iiwacali nacáicani —‍íimaca yái Jesúsca, icàlidaca nalí ìwaliwa, yái Mesíasca. ");
INSERT INTO pioNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Canácata néená yáaliéri áiba tàacáisi náaliméerica namawènìadaca iyú Jesús, ibatàa abéeri tàacáisi piná, càmita náalíawa, canásíwata. Iná cáaluca nasutáca néemìawa Jesús àniwa, ipíchaná báica nía nacái wenàiwicanái yàacuésemi. ");
INSERT INTO pioNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Néeseté Jesús icàlidaca walíni, wía yéewáidacaléca, áibanái nacái wenàiwicanái ìyéeyéica néeni. ");
INSERT INTO pioNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Yá íimaca walí: “Níái yéewáidéeyéica wenàiwica templo irìcu, nía nacái fariseoca nacàlidacuéca pirí tàacáisi profeta Moisés itànèericaté bàaluité Dios inùmalìcuíse. Néewáidacuéca pía píalíacaténácuéwa càinácaalí íimáaná yái Dios itàacáica. ");
INSERT INTO pioNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Iná néewáidacaalícué pía Dios itàacái iyú, néese peebáidacué yái nacàlidáanáca, pimànicué nacái macáita càide iyúwa nacàlidáaná Dios itàacái irìcuíse. Quéwacué picá pimàni càide iyúwa namàníiná, nacàlidacáinácué pirí cayábéeri wawàsi, quéwa namànica áiba wawàsi méetàuculéeri, báawéeri meedá. ");
INSERT INTO pioNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Nadènìaca nàasu tàacáisi nacáiwa, méetàuculéeri Dios itàacái íicha. Iná nachùulìaca wenàiwicanái namànica wawàsi máiníiri càulenáca náicha, náimacáiná Dios iwàwacasa wenàiwicanái imànicani. Quéwa càmita wenàiwica yáalimá ìidenìacani, néese níái yéewáidéeyéica wenàiwica càmita nawàwa nayúudàaca nía, càmita nacái namàni càide iyúwa nachùulìaná áibanái imànica. ");
INSERT INTO pioNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Macáita yái namàníirica, yá namànicani wenàiwicanái iicápiná meedá, yéewacaténá wenàiwica nàaca náimiétacaná meedá. Nawàwacué piyúunáidaca cáinináca naicáca Dios itàacái níái yéewáidéeyéica wenàiwica templo irìcu. Iná nadacùaca nàwaliwa Dios itàacái yéená napùdàlìcuwa, nàanàa ìwali nacáiwa, càide iyúwa Dios ichùulìaná wamànica, wía israelitaca, quéwa nadacùacani cáucuíri iwaalíbapi iyú yéewacaténácué piicácani ráunamáita, íná piyúunáidacuéca cáinináca naicáca Dios itàacái, níái yéewáidéeyéica wenàiwica templo irìcu. Cáalaca namànica nàasu chílanásiwa nasucuéri nabàle ipùata ìwaliwa yéewacaténácué piyúunáidaca nàaca Dios icàaluíniná macái nawàwalìcuísewa. ");
INSERT INTO pioNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Nawàwa náawinacawa cayábéeri yàalubáisi íinata cáimiétacanéeyéi yáawinacatáicawa macái wenàiwicanái yàacuésemi nayáacaalí nayáacaléwa náapicha, namànicaalí culto nacái judíonái yéewáidacàalu irìcu, yéewacaténá áibanái naicáca nía iyúwa máiníiyéica cachàinica. ");
INSERT INTO pioNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Nawàwa macái wenàiwica natàidaca nía cáimiétaquéeri iyú bamuchúamibàa yàcalé manùbéeyéi naicácaténá nía. Máiní fariseonái iwàwacué pitàidaca nía cài: Píamisícawa yéewáidéerica wía”, íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Néese Jesús íimaca walí, wía yéewáidacaléca: “Quéwa píacué nuéwáidacaléca, picácué piwàwa áibanái íimáaná pirí ‘pía, yéewáidéerica wía’, nuwàwacáinácué macáita piicáyacacawa càide iyúwa abémisana. Núacata yái abéericata yéewáidéericuéca pía. ");
INSERT INTO pioNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Picácué píima áiba irí ‘Pía, Wáaniri, icuèrica wía’ chái èeri irìcu pidènìacáinácué abéerita Píaniriwa Dios ìyéerica chènuniré. ");
INSERT INTO pioNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Picácué piwàwa áibanái íimaca pirí ‘pía, Wáiwacali, yéewáidéerica wía’, abéericáináta núa Cristo Píiwacalicué. ");
INSERT INTO pioNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Cawinácaalícué péená iwàwéerica Dios iicácani iyúwa cachàiníirica áibanái íicha, iwàwacutácué íibaidaca pirí macáita càide iyúwa yàasu wenàiwica íibaidáaná íiwacali iríwa. ");
INSERT INTO pioNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Níacáiná macáita cachàiníiyéica iicáca yáawawa, níacata Dios imàaquéeyéipiná báica nía, càmíiyéica nacái cachàini. Néese cawinácaalí càmíiyéica cachàini iicáca yáawawa, níacata Dios imàaquéeyéipiná cachàinica nía”, íimaca walí yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Néese Jesús yàalàaca fariseonái cachàiníiri iyú, áibanái nacái yéewáidéeyéica wenàiwica templo irìcu. Iimaca nalí: “¡Píacué fariseoca, píacué nacái yéewáidéeyéica wenàiwica templo irìcu, Dios yùuwichàidapinácué píawa, píacué pucháibéeyéica íiwitáise meedá! Péemìacué comparación: Càicuéca píade iyúwa wenàiwica ibàlièyéica capìi inùma, néese càmita nawàlùawa capìi irìculé, càmita nacái namàaca áibanái iwàlùacawa. Càitacué pía, éwitacué píalíacáanítawa càinácaalí Dios itàacái íimáaná, càicáaníta càmitacué piwènúada píiwitáisewa peebáidáanápináni, càmita nacái pimàaca áibanái yeebáidacani, ipíchaná Dios yàasu wenàiwicaca nía. ");
INSERT INTO pioNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","¡Píacué fariseoca, píacué nacái yéewáidéeyéica wenàiwica templo irìcu, Dios yùuwichàidapinácué píawa, píacué pucháibéeyéica íiwitáise!, piyéedùacáinácué náicha nacapèemi, nàasumi nacái, níái catúulécanéeyéi inanáica inìrimi yéetéeyéimicawa íicha. Néese, pisutácuéca Dios déecuíri iyú, yéewacaténá áibanái iyúunáidacuéca cayábaca píiwitáise. Dios yùuwichàidapinácué píawa cachàiníiri iyú náicha áibanái cabáyawanéeyéica. ");
INSERT INTO pioNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“¡Píacué fariseoca, píacué nacái yéewáidéeyéica wenàiwica templo irìcu, Dios yùuwichàidapinácué píawa, píacué pucháibéeyéica íiwitáise!, pìacáinácuéwa áiba cáli néré manuíri úni abéemàalé piwènúadacaténácué abéeri wenàiwica íiwitáise yeebáidacaténá càide iyúwa péewáidáaná nía. Néese pidécanáamicué piwènúadaca íiwitáise pìasu tàacáisi iyúwa, yásí péewáidacuéca imànica ibáyawanáwa pucháiba yàawiriéricatái yáwanái íicha yái báawéerica pimàníiricuéca, píacué yèeyéipináwa infierno irìculé, yái quichái càmíirica ichacàwa càiripinéerita ìyaca. ");
INSERT INTO pioNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“¡Dios yùuwichàidapinácué píawa! Càicuéca píade iyúwa matuíyéi itéeyéica áiba wenàiwica, píimacáinácué pìwaliwa píalimáanása péewáidaca wenàiwica Dios ìwali, quéwa càmitacué báisí píalíacawa Dios ìwali. ¡Cáanáica péewáidacuéca wenàiwica chìwái iyú nachìwáidacaténá áibanái! Píacué fariseoca, pidécuéca cài píimaca nalí: ‘Píimacaalí báisí báisísíwatasa templo íipidená ìwali pimàníinápiná áiba wawàsi, néese càmicaalí piwàwa pimànicani machacàníiri iyú càide iyúwaté píimáaná, néese càmita iwàwacutá pimànicani, càmicáiná máiní cachàiníirica yái templo íipidenáca; quéwa picàlidacaalíni templo yàasu oro íipidená ìwali, yásí iwàwacutá pimànica macáita càide iyúwaté píimáaná, ipíchaná Dios yùuwichàidaca pía, máinícáiná cachàiníirica oro templo íicha’, cài péewáidacuéca wenàiwica pichìwa iyúwa nachìwáidáanápiná áibanái. ");
INSERT INTO pioNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","¡Píacué fariseoca, càmíiyéica yáalíawa, matuíyéi nacái íiwitáise! ¿Càmitasicué píalíawa cachàinica templo oro íicha? Bàaluitécáiná Dios ichùulìaca wàawirináimi namàníinápináté irípiná yái temploca, íná yéewa cachàinica templo imànica oro. Iná iwàwacutácué pimànica macáita càide iyúwaté píimáaná, ipíchanácué Dios yùuwichàidaca pía. ");
INSERT INTO pioNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Càita nacái, píacué fariseoca, pidécuéca cài píimaca altar ìwali: ‘Píimacaalí báisí báisísíwatasa altar íipidená ìwali pimàníinápiná áiba wawàsi, néese càmicaalí piwàwa pimànicani machacàníiri iyú càide iyúwaté píimáaná, néese càmita iwàwacutá cài pimànicani, càmicáiná máiní cachàiníirica altar íipidená; quéwa picàlidacaalíni ofrenda íipidená ìwali, yái pìrái nanuérimica iyúwa sacrificio nàacaténá Dios icàaluíniná, yásí iwàwacutá pimànica macáita càide iyúwaté píimáaná, ipíchaná Dios yùuwichàidaca pía, máinícáiná cachàinica ofrenda altar íicha’, cài péewáidacuéca wenàiwica pichìwa iyúwa nachìwáidáanápiná áibanái, píacué fariseoca. ");
INSERT INTO pioNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","¡Píacué fariseo matuíyéica íiwitáise! ¿Càmitasicué píalíawa cachàinica altar ofrenda íicha? Bàaluitécáiná Dios ichùulìaca wàawirináimi namàníinápináté irípiná yái altarca, íná yéewa cachàinica altar imànica ofrenda. Iná iwàwacutácué pimànica macáita càide iyúwaté píimáaná, ipíchanácué Dios yùuwichàidaca pía. ");
INSERT INTO pioNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Píacué fariseoca. Càmitacué péewáida wenàiwica báisíiri tàacáisi iyú. Núumacué pirí cawinácaalí íiméerica ‘báisí báisísíwata altar íipidená ìwali’, yá idéca nacái cài íimaca náipidená ìwali cawinácaalí ofrenda ìyéerica altar íinata. Iná iwàwacutá yái wenàiwicaca imànica macáita càide iyúwa íimáanáté áibanái irí. ");
INSERT INTO pioNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Yá nacái cawinácaalí íiméerica ‘báisí báisísíwata templo íipidená ìwali’, yá idéca nacái cài íimaca Dios íipidená ìwali, Dios imàacacáiná íiwitáise iyamáanápináwa templo irìcu. Iná iwàwacutá yái wenàiwicaca imànica macáita càide iyúwa íimáanáté áibanái irí. ");
INSERT INTO pioNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Yá nacái cawinácaalí íiméerica ‘báisí báisísíwata capìraléeri cáli íipidená ìwali’, yá idéca nacái cài íimaca Dios yàalubái íipidená ìwali ìyéerica chènuniré, idéca nacái cài íimaca Dios íipidená ìwali, Dios ìyacáiná chènuniré. Iná iwàwacutá yái wenàiwicaca imànica macáita càide iyúwa íimáanáté áibanái irí. Canáta yéewaná ichìwáidaca áibanái càide iyúwacué péewáidáaná nía pichìwa iyúwa, píacué fariseoca. ");
INSERT INTO pioNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“¡Píacué fariseoca, píacué nacái yéewáidéeyéica wenàiwica templo irìcu, Dios yùuwichàidapinácué píawa, píacué pucháibéeyéica íiwitáise! Pimàacacuéca bànacalé ofrenda iyú Dios irí, abéerinama néená níái diéyéica imanùbaca pibànacaleca púubéeyéica, níái menta, anís nacái, comino nacái, càide iyúwaté Dios ichùulìanácué pimàacaca irí bànacalé ofrenda iyú sacerdotenái iyáapiná. Quéwa, càmitacué picùa wenàiwicanái machacàníiri iyú, càmitacué nacái piicá áibanái ipualé, càmitacué nacái pìaca Dios icàaluíniná. Iwàwacutácué cài pimànica, quéwa picácué piyamáida pimàaca pìasu cawèníiriwa ofrenda iyú Dios irípiná. ");
INSERT INTO pioNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","¡Càicuéca píade iyúwa matuíyéi itéeyéica áiba wenàiwica, píacué fariseoca, píimacáinácué pìwaliwa píalimáanása péewáidaca wenàiwica Dios ìwali, quéwa càmitacué báisí píalíacawa Dios ìwali! Péemìacué comparación: Càicuéca píade iyúwa wenàiwica ichàbáidéerica ìirapináwa úni wáluma yèewibàa imàacacaténáwa néeni awàsa, ipíchaná ìiraca iríwa casaquèeri única, néese ráunamáita meedá iwetúaca manuíri camello casaquèeri. Càitacué pía, pimànicáinácué cáalíacáiri iyú púubéeri wawàsica iyúwa pìawirináimi íiwitáise íimáaná, quéwa matuíbanáiri iyú meedá piimáichacuéca Dios itàacái máiníirica iwàwacutáca weebáidaca. ");
INSERT INTO pioNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“¡Píacué fariseoca, píacué nacái yéewáidéeyéica wenàiwica templo irìcu, Dios yùuwichàidapinácué píawa, píacué pucháibéeyéica íiwitáise! Pimànicuéca madécaná wawàsi cáalíacáiri iyú càide iyúwaté pìawirináimi yéewáidáaná, yá macái wenàiwica nayúunáidaca masacàacuéca píiwitáise. Péemìacué comparación: Càicuéca píade iyúwa bacàa, quírápieli nacái wáibéeyéica íinatabàawa. Quéwa máinícué báawaca píiwitáise piwàwalìcu càide iyúwa bacàa ipuniéchúacawa casaquèeri iyú, peedácáinácué piríwa manùba wawàsi piyéede iyúwa, iyú nacái yái báawéerica pimàníiricuéca. ");
INSERT INTO pioNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","¡Píacué fariseo matuíyéica íiwitáise! Iwàwacutácué masacàaca pimànica píiwitáisewa piwàwalìcuísewa quéechacáwa. Masacàacaalícué pimànica píiwitáisewa, yásí masacàaca Dios iicápiná macáita yái pimàníiricuéca. ");
INSERT INTO pioNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“¡Píacué fariseoca, píacué nacái yéewáidéeyéica wenàiwica templo irìcu, Dios yùuwichàidapinácué píawa, píacué pucháibéeyéica íiwitáise! Péemìacué comparación: Càicuéca píade iyúwa càliculìimi nabàdéerica íinatabàa cayábawa cabalèeri iyú. Cayábéeyéi iicácanáwa íinatabàawa càliculìimica, quéwa ipuníacawa yéetáními yáapi iyú, macái íiwitáaná casaquèeri iyú nacái. ");
INSERT INTO pioNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Càitacué pía nacái píacué fariseoca: Macái wenàiwica nayúunáida cayábacuéca píiwitáise, quéwa máinícué píiwitáise pucháibéeri idéca ipuníadacuéca piwàwa báawéeri iyú. ");
INSERT INTO pioNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“¡Píacué fariseoca, píacué nacái yéewáidéeyéica wenàiwica templo irìcu, Dios yùuwichàidapinácué píawa, píacué pucháibéeyéica íiwitáise! Pidécuéca pimànica cayábanaméeyéi capìi profetanáimi yàasu càliculìimi iwicáulé piwàwalicáinásacué níái Dios yàasu profetamica, icàlidéeyéicaté tàacáisi Dios inùmalìcuíse. Pidécuéca pichùnìaca cayábéeri iyú nacái nàasu càliculìimica áibanái cayábéeyéimica íiwitáise. ");
INSERT INTO pioNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Néese pidécuéca cài píimaca: ‘Wàyacaalíté bàaluité wàawirináimi yàasu èerimité, yá càmitaté wayúudàa nanúaca Dios yàasu profetanáimicatá’, càicué pidéca píimaca. ");
INSERT INTO pioNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Iná pidécuéca picàlidaca piináwanáwa píalíacawa pìawirináimicuéca nía, níara inuéyéicaté Dios yàasu profetanáimica. ");
INSERT INTO pioNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","¡Siùca nacáide mesúnamáita pimáalàidapinácué pimànica yái báawéerica pìawirináimi idàbéericaté imànica! ");
INSERT INTO pioNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“¡Píacué àapi nacáiyéica íiwitáise! ¡Píacué caculáléeyéica íiwitáise! ¡Càmitacué píalimá pichúuliacawa íicha yái yùuwichàacáisi ìyéerica infierno irìcu! ");
INSERT INTO pioNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Iná nubànùapinácué pìataléwa nùasu wenàiwicawa icàlidéeyéipiná tàacáisi nunùmalìcuíse, nùasunái profetanái, nùasunái cáalíacáiyéi nacái, nùasunái yéewáidéeyéi wenàiwica nacái. Quéwa, núalíacawa pinúapinácuéca abénaméeyéi néená, pitàtàapinácué abénaméeyéi néená cruz ìwali, picapèedáidapinácué abénaméeyéi nacái judíonái yéewáidacàalu irìcu, pipìadáidapinácué nía yàcalé íicha áiba yàcalé nérépiná. ");
INSERT INTO pioNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Iná Dios yùuwichàidapinácué píawa, píacué israelitaca, nàwalíise macáita cayábéeyéimica íiwitáise pìawirináimicué inuéyéicaté, nanúacatáiseté Abel, yái cayábéerimica íiwitáise, àta nanúacatalétaté nacái Dios yàasu profeta Zacarías, yái Berequías ìirimicaté, pìawirináimicué inuéricaté templo ibàacháwalená irìcubàa, bamuchúamibàa náicha altar, templo nacái. ");
INSERT INTO pioNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Péemìacué cayábani, Dios yùuwichàidapinácué píawa, píacué israelitaca ìyéeyéica siùcade ìwalíise macáita yái báawéerica pimàníiricuéca nalí, níái nùasu wenàiwicaca”, íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Néese Jesús íimaca: “¡Píacué Jerusalén ìyacàlená mìnanáica, píacué inuéyéica Dios yàasu profetanái, pinúacuéca áibanái nacái íba iyú, níái wenàiwica Dios ibànuèyéica icàlidaca pirícué tàacáisi inùmalìcuíse! ¡Manùba yàawiría nuwàwacaté nùwacáidacuéca nucùaca pía càide iyúwa cawámai ùwacáidacaalí ucùaca uénibewa ubáiná yáapiréwa! Quéwa càmitacué piwàwa nucùaca pía. ");
INSERT INTO pioNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Iná péemìacué cayába, máiséeyéipiná picapèemicuéca, idécanáami piùwidenái imànicuéca ùwicái píipunita. ");
INSERT INTO pioNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Yá núumacué nacái pirí, siùcáisede càmitacué piicá núa quirínama àta píimacatalépinátacué nùwali: ‘¡Cayábéericani yái yàanèerica Wacuèriná Dios íipidená ìwali, Dios ibànuèrica walí!’ càipinácué píimaca nùwali”, íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Néeseté Jesús yàacawa templo íicha. Idècunitàacá yàacawa, wía yéewáidacaléca wàacawa yáapicha mawiénita irí. Yá wadàbaca watàaníca irí templo ìwali, nàwali nacái cayábanaméeyéi capìica ìyéeyéica templo itéese. ");
INSERT INTO pioNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Quéwa Jesús íimaca walí: —‍Péemìacué cayába yái núuméeyéicuéca pirí ìwali, níái capìica. Báisíta áiba èeriwa canácata capìi yàasu íba yáawinéeripinácawa áiba íba íinata. Macáita níái temploca itéeséeyéica namáalàapináta nacáiwa —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Néese Jesús yàacawa dúli néré íipidenéechúa Olivos, yái olivo inàlimanáca. Yá Jesús yáawinacawa néré. Néese wía yéewáidacaléca wàacawa yàatalé watàanícaténá yáapicha méetàucuta áibanái íicha. Yá wáimaca irí: —‍Wawàwaca picàlidaca walí chácatáinácaalí ichàbapináwa yái picàlidéerica walí templo ìwali. ¿Càinásica iyú wadépiná wáalíacawa mawiénica péenáiwaná pìanàanápiná àniwa, èeri nacái imáalàanápinácawa? —‍wáimaca. ");
INSERT INTO pioNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Néese Jesús íimaca walí: “Piicácué píichawa cayába ipíchaná áibanái ichìwáidacuéca pía ipíchawáise èeri imáalàapinácawa. ");
INSERT INTO pioNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Manùbacáiná wenàiwica nàanàapiná icàlidéeyéipiná ichìwawa. Náimapiná núacasa níata. Yá nacàlidapiná nachìwawa. Càipiná náimaca: ‘Núacata yái Mesíasca íipidenéerica Jesucristo, israelita icuèrinápináca’, càipiná náimaca namànica nachìwawa. Yá nachìwáidapiná manùba wenàiwica. ");
INSERT INTO pioNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Nacàlidapinácué pirí madécaná ùwicái iináwaná ìwali, áibanái imàníinása úwi mawiénita, déecubàata nacái. Quéwacué, picácué cáalu píawa iwàwacutácáiná cài namànica, quéwa càmitàacá imáalàapináwa yái èeriquéi. ");
INSERT INTO pioNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Manùbacáiná áiba cáli néeséeyéi ipéliapiná áiba cáli néeséeyéi íipunitawa, áibanái gobierno namànipináca ùwicái áibanái gobierno íipunitawa. Yá manùbéeyéi wenàiwica néetápinácawa máapicái iyú, cáli nacái icusúapinácawa madécaná cáliwa. ");
INSERT INTO pioNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Quéwa macáita yái yùuwichàacáisica, yátanica idàbáanéerica yùuwichàacáisica meedá, càide iyúwa inanái idàbacaalí ùuwichàacawa ùasu èeri umusúadacaténá iicá èeri. ");
INSERT INTO pioNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Néese náibàapinácué píawa nacháawàacaténácué piináwaná ìwali náiwacanánái iríwa peebáidacáinácué nutàacái. Yá namànipinácué pirí báawéeri, yá nanúapinácué píawa. Macái èeri mìnanái báawacuéca naicápiná píawa peebáidacáinácué nutàacái. ");
INSERT INTO pioNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Néenialípiná manùbéeyéi wenàiwica nawènúadapiná nuícha náiwitáisewa namànicaténá nabáyawanáwa. Yá báawapiná naicáyacacawa, nacháawàayacacawa. ");
INSERT INTO pioNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Madécaná iwicùlidéeyéi cachìwéeyéi yàanàapináca icàlidéeyéi ichìwawa. Náimapiná natàaníinása nacái Dios inùmalìcuíse, yásí nachìwáidapiná madécaná wenàiwica. ");
INSERT INTO pioNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Néenialípiná ìyaca madécaná báawéeriwa, íná batéwa macáita càmitapiná cáininá naicáyacacawa. ");
INSERT INTO pioNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Quéwa cawinácaalí yeebáidéeyéica nutàacái mamáalàacata àta néetácatalétawa, nuwasàapiná níawa Dios yàasu yùuwichàacáisi íicha. ");
INSERT INTO pioNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Yá nàapinácawa macái cáli íinatalé nacàlidacaténá yái tàacáisi cayábéerica íiméerica Dios icùaca yàasu wenàiwicawa yéewacaténá macái èeri mìnanái néemìacani; néese èeri imáalàapinácawa macáita. ");
INSERT INTO pioNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Bàaluité profeta Daniel itànàacaté tàacáisi Dios inùmalìcuíse icàlidéerica walí áiba báawéeri casaquèeri wawàsi iináwaná ìwali abéeri wenàiwica imàníiripináca templo irìcu, aléde càmicataléca Dios ibatàa wenàiwica imànica càiri wawàsi, casacàacaténá imànica templo Dios íicha. Piicácaalípinácué yái báawéerica ìyéeripináca templo irìcu—‍píacué iléeyéica yái tàacáisica, péemìacué cayábani—‍íná piicácaalípinácué yái wenàiwica ìyaca néré, yásí iwàwacutácué pipìacawa Jerusalén ìyacàlená íicha. ");
INSERT INTO pioNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Yásí cawinácaalí ìyéeyéica chái Judea yàasu cáli íinata, iwàwacutá napìacawa dúli inàliméeri nérépiná. ");
INSERT INTO pioNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Cawinácaalí wenàiwica iyamáidéeyéicawa ìyaca icapèe ipùata sàabadéeri íinatawa néenialípiná, iwàwacutá càmita nèepùa nawàlùacawa nacapèe irìculéwa needácaténá nàasuwa ipíchawáise napìacawa Jerusalén ìyacàlená íicha. ");
INSERT INTO pioNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Cawinácaalí ìyéeyéica manacúaliré, iwàwacutá càmita nèepùawa nacapèe néréwa, ibatàa needáanápiná nabàlewata, iwàwacutá càmita nèepùawa ipíchawáise napìacawa Jerusalén ìyacàlená íicha. ");
INSERT INTO pioNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","¡Nàuwichàapináwa manuísíwata cawinácaalí inanái idéerìcuíyéica, nía nacái inanáica yèeyéica quìrasìi ìira ìinisi, càmicáiná náalimá napìacawa ráunamáita, naicápiná nacái néenibewa nàuwichàacawa! ");
INSERT INTO pioNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Pisutácué Dios íicha ipíchanácué iwàwacutá pipìacawa unìabépi, máinícáinácué càulenáca pìacawa, càmita nacái sábado irìcu judíonái iyamáidacatáicawa, ipíchaná nabàlìacuéca píicha yàcalé iwáiná inùma pimusúacatáisepináwa yàcalé íicha. ");
INSERT INTO pioNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Néenialípiná wenàiwica yùuwichàapinácawa báawanama. Canácaté áiba yùuwichàacáisi báawéeríwanái íicha, Dios idàbacatáiseté yái èeriquéi, àta siùca nacáide. Càmíiripináta nacái áiba yùuwichàacáisi báawéeri íicha càiripinátawa chái èeri irìcu. ");
INSERT INTO pioNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Càmicaalí Dios imàaca maléenéeripináni yái yùuwichàacáisicatá, yásí macái èeri mìnanái yéetápinácawatá. Quéwa Dios idéca imàacaca maléenéeripinácani cáininácáiná iicáca yàasu wenàiwicawa, níái wenàiwicaca Dios yeedéeyéica yàasunáipináwa. ");
INSERT INTO pioNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Néese néenialípiná áibanái íimapiná piríwa: ‘Aquialécué piicáca, chácata ìyaca yái Mesíasca’, càipiná náimaca; áibanái nacái náimapinácué piríwa: ‘Piicácué Mesías ìyaca néré, yái judío icuèrináca’, càipiná náimaca. Quéwa, picácué peebáida nalíwani. ");
INSERT INTO pioNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Manùbacáiná cachìwéeyéi yàanàapiná, icàlidéeyéipiná ichìwawa Mesíascasa nía, judío icuèrinápinása; áibanái iwicùlidéeyéi nacái nàanàaca icàlidéeyéipiná ichìwawa. Náimapiná natàaníinása Dios inùmalìcuíse. Yá namànipiná yái càmíirica wenàiwica idé imànica. Càita náasáidapiná nachàiniwa nachìwáidacaténá èeri mìnanái. Náalimáidapiná nachìwáidaca nacái Dios yàasu wenàiwica, níái Dios yeedéeyéica yàasunáipináwa. Càmicaalí Dios yàasunái iicá íichawa cayábani, yásí cachìwéeyéi náalimá nachìwáidaca nía nacái. ");
INSERT INTO pioNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Nudéca nùalàacuéca pía náicha, ipíchawáise ichàbapinácawa. ");
INSERT INTO pioNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Iná náimacaalícué pirí: ‘Aquialécué piicáca Cristo ìyaca manacúali yùucubàa càináwàiri’, picácué pìawa néré. Náimacaalícué nacái pirí: ‘Piicácué chácataníira Cristo ìyaca capìi imàdáaná irìcu, ibàacawa’, picácué peebáidani. ");
INSERT INTO pioNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Núacáiná nùacaalípináwa néese àniwa, yásí macái èeri mìnanái naicáca nucànacawa amaláwaca, càide iyúwa énu icànáaná macáita capìraléeri cáli ìwali chènuniré èeri imusúacatáisewa àta èeri iwàlùacataléwa. Càicata nacái nùapinácawa néese àniwa nuénáiwaná yàanàacatáiwa, núa asìali Dios néeséerica. Càmita nùawa ibàacanéeri iyúwa. ");
INSERT INTO pioNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Màulenéeri iyú piicápinácué chábàanácaalí nùacawa càide iyúwacué píalíanáwa alénácaalí yéetéerimiwa irìawa piicácáinácué manùbéeyéi wáchuli nàwacáidáyacacawa”, íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Jesús íimaca walí: “Néenialípiná ichàbacanacáitawa yái yùuwichàacáisica, yá catápináca èeri icamaláná, yá nacái quéeri càmitapiná amalá icànaca. Dùlupùta nacái nacaláapináwa chènuníise. Yásí cachàiníiyéi wawàsi ìyéeyéica chènuniré nacusúacawa macáiwa. ");
INSERT INTO pioNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Néese macái èeri mìnanái iicápiná abéeri wawàsi chènuníise imàaquéeripináca náalíacawa nùanàanápiná, núa asìali Dios néeséerica. Yá náicháanípiná nacalùniwa níái macáita èeri mìnanáica. Néese naicápiná núa, núa asìali Dios néeséerica, nùanàapiná acalèe yèewíise cachàiníiri nuíwitáise iyúwa, mèlumèluíri iyú nucùacaténá macáita. ");
INSERT INTO pioNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Yá nubànùapiná nùasu ángelnáiwa napùlìacaténá trompeta cachàiníiri iyú nàwacáidacaténá macáita wenàiwica nuedéeyéica nùasunáipináwa. Càipiná nùwacáidaca nulíwa nía àta alénácaalí nàyaca macái cáli imanuíca chái èeri irìcu, èeri imusúacatáisewa àta èeri iwàlùacatalécawa. ");
INSERT INTO pioNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Péemìacué cayába comparación higuera yéetaná ìwali: Càisinàacaalí higuera yàana, yá imusúadacaalí ibáináwa, yá píalíacuécawa mawiénica camuí. ");
INSERT INTO pioNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Càita nacái piicácaalípinácué ichàbacawa macáita yái nucàlidéericuéca pirí ìwali, yásí píalíacuécawa mawiénica núa, nùanápináwa néese àniwa, núa asìali Dios néeséerica, càide iyúwa wenàiwica ibàlùacaalíwa capìi inùma irìcu, iwàlùanápináwa capìi irìculé. ");
INSERT INTO pioNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Péemìacué cayábani, macáita yái siùquéerica tàacáwa nucàlidacuéca pirí ìwali, macáita ichàbáanápinácawa ipíchawáise néetácawa macáita wenàiwica ìyéeyéipináca néenialíwa. ");
INSERT INTO pioNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Yái capìraléeri cáli, èeriquéi nacái namáalàapinácawa áibaalípiná, néese nutàacái càmita imáalàapináwa. Macáita ichàbapinácawa càiwade iyúwa nucàlidáaná piríni. ");
INSERT INTO pioNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Quéwa canácata yáaliériwa chácatáinápinácaalí yái èerica, chènuníiséeyéi ángel nacái càmita náalíawa, núa nacái Dios Iirica, càmita núalíawa chácatáinápinácaalí èeri, hora nacái. Abéericata Núaniri Dios yáaliériwa. ");
INSERT INTO pioNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","“Mawiénicaalípiná nuénáiwaná nùanàacatáipináta àniwa, núa asìali Dios néeséerica, yásí wenàiwicanái nàyapináca càide iyúwaté èeri mìnanái ìyáanáté Noé yàasu èerité. ");
INSERT INTO pioNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Bàaluité èeri ipíchawáiseté úni yéesacawa macáita cáliquéi, macái èeri mìnanái nàyacaté matuíbanáita Dios íicha; nayáacaté nayáacaléwa, nàiracaté nacái nàiracaléwa. Needácaté nacái náinupináwa. Càité namànica àta Noénái iwàlùacatalétatéwa arca irìculé. ");
INSERT INTO pioNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Càmitaté èeri mìnanái yeebáida mawiénicani yái yùuwichàacáisica. Néeseté yáta manuíri yéesacái yàanàaca, yá macáita néetácawa càmíiyéicaté iwàlùawa arca irìculé Noénái yáapicha. Càita nacái yùuwichàacáisi yàanàapináwa ráunamáita èeri mìnanái ìwali áiba èeriwa nùanàacatáipináta àniwa, núa asìali Dios néeséerica. ");
INSERT INTO pioNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Néenialípiná pucháiba asìanái yèepuníiyéipinácawa manacúalibàa. Angelnái itépiná abéeri asìali, abéeripiná nacái imàacawa néenita. ");
INSERT INTO pioNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Yá pucháiba inanái namulúapináca nàyaca ituínási. Angelnái itépiná abéechúa, abéechúapiná nacái imàacawa néenita. ");
INSERT INTO pioNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Picùacáitacué nùanàaca, càmicáinácué píalíawa nuénáiwaná nùanàacatáipiná, núa Píiwacalicuéca, chácatáinápinácaalí nùanàaca àniwa. ");
INSERT INTO pioNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Péemìacué cayába comparación: Capìi íiwacali yáalíacaalíwa càinácaalípiná hora irìcu cayéedéeri yàanàa táiyápitá, yá càmita capìi íiwacali iimácatá, càmita nacái ibatàa nawàlùacawa icapèe irìculé nayéedùacaténá yàasutá. Càmita quéwa capìi íiwacali yáalíawa càinácaalípiná hora irìcu cayéedéeri yàanàa. ");
INSERT INTO pioNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Càicata nacáicué pía. Pichùnìacué píiwitáisewa picùacaténácué nùacawa néese, núa asìali Dios néeséerica, nùacáináwa néese àniwa càmicatáipinátacué picùa nùanàa”, íimaca walí yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Néese Jesús íimaca walí, wía yéewáidacaléca: “Péemìacué comparación: Iwàwacutácué pìyaca càide iyúwa capìi íiwacali yàasu wenàiwica. Cáibaidacáiricani, yái yàasu wenàiwicaca, yeebáidéerica nacái íiwacali itàacáiwa machacàníiri iyú. Iná yái capìi íiwacalica, ipíchawáise yàacawa icapèe íichawa, yá ichùulìaca yàasu wenàiwicawa icùanápiná yàasu wenàiwica áibanái, yàacaténá nacái nayáapiná èeri imanùbaca. ");
INSERT INTO pioNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Néesecáwa capìi íiwacali yèepùacaalípináwa néese àniwa, yá casíimáica yàasu wenàiwica imànicaalícáwa càide iyúwa íiwacali íimáanáté irí. ");
INSERT INTO pioNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Péemìacué cayábani, capìi íiwacali imàacapiná yàasu wenàiwicawa icùaca macáita yàasu, yácáiná yàasu wenàiwica íibaidacaté cayába íiwacali irípináwa, idècunitàacá canáca yái íiwacalica. ");
INSERT INTO pioNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","50","Quéwa capìi íiwacali yàasu wenàiwica báawacaalí íiwitáise, yá iyúunáidacaalí íiwacali idècunìacawa càiripináta, yá nacái idàbacaalí icapèedáidaca inacáiyéiwa íibaidéeyéi, yá iyamáidaca íibaidaca iyáacaténá manuí iyáacaléwa, ìiraca nacái, icàmáanápiná nacái icàméeyéi yáapicha, yáta íiwacali yèepùapináca yàanàaca yáta èerica yàasu wenàiwica càmicatáita icùa yàanàaca, abéeri hora nacái càmíiri yáalíawa ìwali íiwacali yàanàanápiná. ");
INSERT INTO pioNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Yásí capìi íiwacali idalúaca yèewi pucháibawaca, yái yàasu wenàiwica báawéerica. Yá yùuwichàacawa càide iyúwa pucháibéeyéi íiwitáise nàuwichàanáwa infierno irìcu. Yásí náicháanípiná báawanama, naamíapináca nayéiwa nàuwichàacái iyúwa”, íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Néeseté Jesús yéewáidaca wía comparación iyú, yá íimaca walí: “Néenialípiná, ipíchawáise Dios icùaca macáita wenàiwicanái, yá abénaméeyéi nacùapiná nùacawa néese, quéwa áibanái càmita nacùa nùacawa néese. Càica níade iyúwa diez namanùbaca mànacanái. Péemìacué comparación: Mànacanái needáca nàasu lámparawa nàacaténáwa fiesta casamiento néré. Yá nabàlùacawa bàacháwáise capìi íicha, nacùaca abéeri asìali yàanàaca idécanáami yeedáca iríwa yàacawéetúawa, yéewanápiná nawàlùacawa náapicha fiesta irìculé. ");
INSERT INTO pioNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Cinco namanùbaca mànacanái máiwitáiséeyéi. Aibanái cinco namanùbaca cáalíacáiyéi nacái. ");
INSERT INTO pioNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Níái máiwitáiséeyéica meedá natéca nàasu lámparawa, quéwa càmita naté lámpara ituní napuníadáanápiná àniwa nàasu lámparawa. ");
INSERT INTO pioNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Níái cáalíacáiyéica natéca ituní yàalupiná nàasu lámpara yáapichawa. ");
INSERT INTO pioNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Néese idècunìacatéwa yái asìali yeedéericaté yàacawéetúawa, íná iwàwacutá mànacanái icùaca nía máadáiní. Yá cadapùleca macáita mànacanáica. Néese naimáca náichawa. ");
INSERT INTO pioNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Néeseta quéwa catá bamuchúami yáta mànacanái yéemìaca áibanái imáidaca nalí cachàiníiri iyú. Yá náimaca mànacanái irí: ‘Aca níara, pìacué píipunitáidaca nía’, náimaca. ");
INSERT INTO pioNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Yá nacawàacawa macáita níái mànacanáica. Yá nachùnìaca nàasu lámparawa. ");
INSERT INTO pioNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Níái máiwitáiséeyéica meedá náimaca cáalíacáiyéi irí: ‘Piùcùacué walí achúmáana ituní, wàasu lámparacáiná ichacàca yàacawa’, náimaca. ");
INSERT INTO pioNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Quéwa cáalíacáiyéi íima nalí: ‘Càmíirita, canácáiná walí cayába wàasupiná, pirípinácué nacái. Pìacué picutáca piríwa aléera nawéndacataléca’, náimaca nalí. ");
INSERT INTO pioNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Néese idècunitàacá máiwitáiséeyéi nàacawa nawènìacaténá nalíwa lámpara ituní, yá asìali yàanàaca yái yeedéericaté yàacawéetúawa. Néese níái cáalíacáiyéica mànacanáica ichùnièyéicaté yàasuwa, nawàlùacawa náapicha fiesta casamiento néré. Yá nabàlìaca capìi inùma. ");
INSERT INTO pioNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Néese níái máiwitáiséeyéica nàanàaca néré. Yá namáidaca capìi inùma néeni. Náimaca: ‘Wáiwacali, pìacùa walíni yái capìi inùmaca’, náimaca irí. ");
INSERT INTO pioNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Néese quéwa íimaca nalí: ‘Péemìacué cayábani, càmitacué núalía nuicáca pía’, íimaca nalí”, íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Néese Jesús íimaca walí ìyéeyéica yáapicha: “Càita nacái iwàwacutácué picùaca nùanàaca néese àniwa. Picùacué cayába nùanàaca néese àniwa, núa, asìali Dios néeséerica, càmicáinácué píalíawa chácatáinápinácaalí èeri nùawa, càinácaalípiná hora irìcu nacái, càmitacué píalíawa”, íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Néeseté Jesús yéewáidaca wía áiba comparación iyú. Yá íimaca walí: “Néenialípiná ipíchawáise Dios icùaca macáita, càicanide iyúwa càasuíri asìali idènièrica yàasu wenàiwicanáiwa. Péemìacué comparación: Ipíchawáise càasuíri asìali yàacawa áiba cáli nérépiná, yá imáidaca yàasu wenàiwicanáiwa. Yá yàaca nachàba yàasu platawa nacùanápiná iríni. ");
INSERT INTO pioNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Yá náiwacali yàaca abéeri ichàba cinco mil namanùbaca moneda máiníiyéi cawènica. Yàaca nacái áiba ichàba pucháiba mil namanùbaca. Yàaca nacái áiba ichàba abéeri mil namanùbaca. Yái náiwacali yàaca nachàba càide iyúwa náalimáaná náibaidaca, namànicaténá nàasu wawàsiwa náiwacali yàasu plata iyúwa. Yá yàacawa náicha áiba cáli néré. ");
INSERT INTO pioNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Yái asìali idènièrica cinco mil namanùbaca, yàacawa caquialéta imànicaténá yàasu wawàsiwa íiwacali yàasu plata iyúwa. Yá yeedáca áiba cinco mil namanùbaca moneda íiwacali irípináwa ipualé yái plata íiwacali yèericaté ichàba. ");
INSERT INTO pioNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Càita nacái imànica yái áiba asìalica idènièrica pucháiba mil namanùbaca imàníiripiná iyú yàasu wawàsiwa. Yá yeedáca áiba pucháiba mil àniwa íiwacali irípináwa. ");
INSERT INTO pioNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Quéwa yái asìali idènièrica abéeri mil meedá yàacawa, yá íicaca cáli yèewiré, yá ibàlìaca plata cáli irìculé. Càita ibàacaca íiwacali yàasu platawa. ");
INSERT INTO pioNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Madécaná èeri idénáami, yá yèepùacawa néese àniwa yái náiwacalica. Néese imáidaca yàataléwa yàasu wenàiwicanáiwa, níái yeedéeyéicaté íicha plata, yáalíacaténáwa náicha càisimalénácaalí needá náiwacali irípináwa. ");
INSERT INTO pioNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Quéechacáwa yái asìali yàanàaca íiwacali yàataléwa, yái idènièricaté cinco mil namanùbaca moneda, yá yàaca diez mil namanùbaca moneda íiwacali iríwa. Yá íimaca íiwacali iríwa: ‘Nuíwacali, pìacaté nuchàba cinco mil namanùbaca. Siùcade pidènìaca áiba cinco mil namanùbaca àniwa nuedéerica pirípiná’, íimaca irí. ");
INSERT INTO pioNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Néese íiwacali íimaca irí: ‘Cayábéericani. Pidéca píibaidaca nulí cayába, machacàníiri iyú càide iyúwa nuwàwáaná. Pidéca píibaidaca nulí machacàníiri iyú achúméeríina iyú, íná numàaca picùaca madécaná àniwa. Yá peedá piríwa nùasu casíimáicaténá pía núapicha’, íiwacali íimaca irí. ");
INSERT INTO pioNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Néese àniwa, yái asìali yàanàaca nacái íiwacali yàataléwa, yái náiwacali yèericaté ichàba pucháiba mil namanùbaca moneda, yá yèepùadaca báinúaca mil namanùbaca íiwacali iríwa. Yá íimaca íiwacali iríwa: ‘Nuíwacali, pìacaté nuchàba pucháiba mil namanùbaca. Nudéca nuedáca pirípiná pucháiba mil namanùbaca àniwa’, íimaca irí. ");
INSERT INTO pioNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Néese íiwacali íimaca irí: ‘Cayábéericani. Pidéca píibaidaca nulí cayába, machacàníiri iyú càide iyúwa nuwàwáaná. Pidéca píibaidaca nulí machacàníiri iyú achúméeríina iyú, íná numàacaca picùaca madécaná àniwa. Yá peedá piríwa nùasu casíimáicaténá pía núapicha’, íiwacali íimaca irí. ");
INSERT INTO pioNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","25","“Néese nacái yái asìali yàanàaca íiwacali yàataléwa, yái náiwacali yèericaté ichàba abéeri mil namanùbaca moneda. Yá íimaca íiwacali iríwa: ‘Nuíwacali, núalíacawa pìwali caluérica píiwitáise, peedácáiná piríwa yàacàsi càmicataléca pibàna, pìwacáida nacái piríwa càmicataléca píibaida. Iná cáaluca núa, yá nùaca nubàlìaca pìasu plata cáli irìculé. Siùcade nuèpùada pirí àniwa pìasu plataca’, íimaca. ");
INSERT INTO pioNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","27","Néese íiwacali íimaca irí: ‘Báawéeri píiwitáise, càmita píibaida nulí cayába, ínuca pía nacái. Píináidacaalíwa nùwali nuedáaná yàacàsi càmicataléca nubàna, nùwacáidáaná nacái nulíwa càmicataléca nuíbaida, néese ¿cánáté càmita pimàaca nùasu plata caja néré, yéewanápiná inísàacawa nulípiná achúmáana quirítatá àniwa?’ íiwacali íimaca irí. ");
INSERT INTO pioNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Néese náiwacali íimaca yàasu wenàiwicanái iríwa: ‘Peedácué íicha níái abéeri mil namanùbaca monedaca. Pìacué iríni yái idènièrica diez mil namanùbaca’, íimaca yái náiwacalica. ");
INSERT INTO pioNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","‘Níacáiná macáita íibaidéeyéica cayába nulípiná, yá numàacáanápiná nacùaca madécaná mamáalàacata. Quéwa cawinácaalí càmíiyéica íibaida cayába, càmita numàaca náibaidaca nulípiná quirínama. ");
INSERT INTO pioNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Pìacué piúcaca yái wenàiwica canéerica iwèni méetàuculé máiníiri catácatalé. Wenàiwicanái náicháanípiná manuísíwata, yá naamíapiná nayéiwa nàuwichàacái iyúwa’ ”, íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Néeseté Jesús íimaca walí àniwa: “Núa asìali Dios néeséerica, nùanàapiná cachàiníiri iyú, nucamalá irìcuwa, cáimiétaquéeri iyú nacái, cachàiníiri nuíwitáise nacái nucùacaténá macáita èeri mìnanái. Yá nùanàapiná macái ángelnái yáapichawa. Yá núawinacawa nùasu yàalubáisi mèlumèluíri íinatawa nucùacaténá macáita. ");
INSERT INTO pioNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Nàwacáidapiná nùatalé macái èeri mìnanái. Yá nùwacáidapiná náichawáaca nía pucháiba yàalusipiná càide iyúwa pìrái icuèriná ìwacáidacaalí ipìra ovejanáiwa cabranái íicha. ");
INSERT INTO pioNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Yá nùwacáidapiná nulípináwa nùasunái ovejaca nuéwápuwáise mawiénita nulí, quéwa nùwacáidaca cabranái nuíchawa apáuwáisepiná meedá. ");
INSERT INTO pioNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Néese núa, yái icuèrica macáita, núumapiná nalí ìyéeyéica núapicha nuéwápuwáise. Yá núumapiná nalí: ‘Aquialécué núapicha, píacué Núaniri Dios yàasunáica, Dios imàaquéeyéica casíimáica. Peedácué piríwa yái cayábéeri yàcaléca wamàníiricatécué pirípiná wadàbacaalíté èeriquéi, yái yàcalé picùacatalépinácuéca macáita wenàiwica. ");
INSERT INTO pioNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Bàaluitécáiná, máapicaalíté núa, pìacatécué nuyáapiná. Macàlacaalíté nuwàwa, pìacatécué nuìrapiná úni. Nùacaalítéwa déecuíse nùasu cáli íichawa, peedácatécué pìataléwa núa. ");
INSERT INTO pioNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Canácaalíté nubàle, pìatécué nubàlepiná. Cáuláicacaalíté núa, picùacatécué núa. Náucacaalíté núa presoíyéi ibànalìculé, pìanàacatécué pisíimáidaca núa’, càipiná núumaca nalí. ");
INSERT INTO pioNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Néese níái cayábanaméeyéica íiwitáise náimapiná nulí: ‘Wáiwacali, ¿càicaalínáté waicá máapica pía, yáté wàaca piyáapiná? ¿Càicaalínáté waicá macàlaca piwàwa, yáté wàaca pìiraca úni? ");
INSERT INTO pioNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Càicaalínáté waicá pìacawa déecuíse pìasu cáli íichawa, yáté weedáca wàataléwa pía? ¿Càicaalínáté waicá canáca pibàle, yáté wàaca pibàlepiná? ");
INSERT INTO pioNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Càicaalínáté nacái waicá cáuláicaca pía, yáté wacùaca pía? ¿Càicaalínáté nacái pìyaca presoíyéi ibànalìcu, yáté wàaca wasíimáidaca pía?’ càipiná náimaca nulí. ");
INSERT INTO pioNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Néese núa, yái icuèrica macáita, núumapiná nalí: ‘Péemìacué cayába. Pimànicáinátécué cayábéeri nuénánái irí, éwita nalípiná níái càmíiyéica cachàini náicha canánama, ínáté nuicáca yái pimàníiricuéca nalí càide iyúwacué pidéca nacáicaalí pimànica nulíni’, càipiná núumaca nalí. ");
INSERT INTO pioNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Néese núumapiná nalí níái ìyéeyéica apáuwáise nuícha: ‘Pìacuéwa nuícha, píacué báawéeyéica Dios iicáca íiwitáise. Pìacuéwa quichái irìculé càmíirica ichacàwa càiripinéerita ìyaca Dios imàníirica nalípiná, yái Satanásca, nía nacái Satanás yàasu ángelnáica. ");
INSERT INTO pioNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Bàaluitécáiná máapicaalíté núa, càmitatécué pìa nuyáapiná. Macàlacaalíté nuwàwa, càmitatécué pìa nuìra úni. ");
INSERT INTO pioNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Nùacaalíté déecuíse nùasu cáli íichawa, càmitatécué peedá pìataléwa núa. Canácaalíté nubàle, càmitatécué pìa nubàlepiná. Cáuláicacaalíté núa, càmitatécué picùa núa. Náucacaalíté núa presoíyéi ibànalìculé, càmitatécué pìa pisíimáidaca núa’, càipiná núumaca nalí. ");
INSERT INTO pioNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Néese náimapiná nulí: ‘Wáiwacali, ¿càicaalínáté waicá máapicaté pía, macàlacaalíté piwàwa nacái, cáuláicacaalíté pía nacái? ¿Càicaalínáté waicá pìacawa déecuíse pìasu cáli íichawa? ¿Càicaalínáté waicá pìyaca presoíyéi ibànalìcu nacái? ¿Càicaalínáté waicá canáca pibàle? ¿Càicaalínáté càmita wayúudàa pía?’ càipiná náimaca nulí. ");
INSERT INTO pioNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Néese núumapiná nalí: ‘Péemìacué cayába, càmicáináté pimàni cayábéeri nuénánái irí, éwita nalípiná níái càmíiyéica cachàini náicha canánama, ínáté nuicáca yái càmíinácuéca pimànica nalí cayábéeri càide iyúwacué càmicaalí nacái pimàni nulítáni’, càipiná núumaca nalí. ");
INSERT INTO pioNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Néese níái báawéeyéica íiwitáise nàapinácawa Dios yàasu yùuwichàacáisi irìculé, yái yùuwichàacáisi càmíirica imáalàawa. Níata quéwa cayábanaméeyéica íiwitáise nawàlùapinácawa yàcalé irìculé nadènìacataléca nacáucawa càmíiri imáalàawa”, íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Idécanáamité Jesús icàlidaca walíni, wía yéewáidacaléca, yá íimaca walí: ");
INSERT INTO pioNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","—‍Píalíacuécawa ìyaca wapíchalé pucháiba èeri ipíchawáise namànica Pascua yàasuná culto. Yánica abénaméeyéi wenàiwica presopináca namànica núawa namàacacaténá áibanái natàtàaca núa cruz ìwali, núa asìali Dios néeséerica —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Néenialíté sacerdote íiwacanánái nàwacáidáyacacawa judío íiwacanánái yáapicha Caifás icapèe manuíri irìculé, yái sacerdote íiwacaliná íipidenéericaté Caifás. ");
INSERT INTO pioNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Yá náináidacawa, natàaníca nacái, namànica wawàsi náapichawáaca náibàanápináté Jesús ibàacanéeri iyú nanúacaténáni. ");
INSERT INTO pioNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Quéwa macáita náimaca nalíwáaca: —‍Iwàwacutá càmita wáibàani Pascua yàasuná culto yaalí, ipíchaná calúaca wáapicha níái manùbéeyéi wenàiwicaca, ipíchaná namànica ùwicái yàcalé irìcu —‍náimaca. ");
INSERT INTO pioNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Néeseté Jesús ìyaca Betania ìyacàlená irìcu, Simón icapèe irìcu, yái Simón ichùnièricatéwa cháunási lepra íicha. ");
INSERT INTO pioNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Néese abéechúa inanái ùacawa Jesús yàatalé. Udènìaca achúméechúa catùa cawèníiri íba alabastro icatùalená, ipuniéchúawa séenási pumèníiri iyú, máiníiri cawènica. Idècunitàacá Jesús iyáaca iyáacaléwa, yá ùucùaca yái séenási pumèníirica Jesús íiwita ìwali. ");
INSERT INTO pioNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Néese wía, Jesús yéewáidacaléca, waicácáiná yái umàníirica, yá calúaca wía. Yá wadàbaca wáimaca: —‍Máiní báawéeriquéi úucáanáca meedá canéeri iwèni iyú yái pumèníirica isàni cawèníirimica. ");
INSERT INTO pioNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","¿Cánáté càmita uwéndani, manùba platapinácáinátani, uyúudàanápiná catúulécanéeyéi wenàiwicatá? —‍wáimaca. ");
INSERT INTO pioNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Jesús yéemìaca yái wáimáanáca, yá íimaca walí: —‍Picácué pisàiwica ulí wawàsi. Yái umàníirica nulí máiníiri cayábacani. ");
INSERT INTO pioNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Catúulécanéeyéi wenàiwica nàyapinácué píapicha mamáalàacata càiripináta íná yéewacué píalimá piyúudàaca nía piwàwacatáicacué piyúudàaca nía. Núa quéwa càmíirita ìyapiná píapichacué càiripináta chái èeri irìcu. ");
INSERT INTO pioNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Udéca ùucùaca perfume nùwali, nusànipiná nabàlìacaténá nuinámi, càide iyúwa judío íiwitáise ìyáaná. ");
INSERT INTO pioNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Péemìacué cayábani, àta alénácaalí wenàiwica nacàlidaca nutàacái chái èeri irìcu íiméerica nuwàwaca nuwasàaca wenàiwica Dios yàasu yùuwichàacáisi íicha, yá nacàlidapiná uináwaná ìwali úái inanáica, umànicáiná nulí cayábéeri, yá nawàwalipiná úa —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Néeseté abéeri wéená wía Jesús yéewáidacaléca docenácaté wamanùbaca, íipidenéerica Judas Iscariote, yàaca itàaníca sacerdote íiwacanánái yáapicha. ");
INSERT INTO pioNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Judas íimaca nalí: —‍¿Càinácué imanùbaca pìa nulí nutécaalícué pía Jesús yàatalé píibàacaténácuéni? —‍íimaca yái Judas Iscarioteca. Néese nacàlidaca iríni nàanápináté irí treinta namanùbaca moneda, níái plata cawèníiyéica, báinúaca quéeri iwènicatái. ");
INSERT INTO pioNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Néese Judas idàbaca icutáca wawàsi càinácatáinápiná yáalimá itéca nía Jesús yàatalé náibàacaténáni. ");
INSERT INTO pioNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Idàbáanéeri èeri yàanàacaté judíonái yàasu culto Pascua yaalí, nayáacatáica pan càmíiri idènìa levadura. Yáté èerica, wía Jesús yéewáidacaléca wasutáca wéemìawa Jesús. Yá wáimaca irí: —‍¿Alénásica piwàwa wàacawa wachùnìacaténá piyáapiná nacáiwa yàacàsi Pascua pinéerica piyáacaténá wáapichani? —‍wáimaca. ");
INSERT INTO pioNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Yá íimaca walí: —‍Pìacuéwa Jerusalén ìyacàlená irìculé, abéeri asìali icapèe néré, càide iyúwacué núumáanáté pirí. Píimacué irí: ‘Yáara Yéewáidéerica wía íima pirí: Mawiénica nùasu èeri nuétáanápináwa. Yá nùacawa picapèe néré nuyáacaténá yàacàsi Pascua pinéerica nuéwáidacalénái yáapichawa, cài íimaca pirí’, càicué píimaca iríwa —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Néese abénaméeyéi wéená wía yéewáidacaléca nàacawa néré, yá namànica càide iyúwa Jesús ichùulìanáté nía. Yá nachùnìaca yàacàsi Pascua pinéerica. ");
INSERT INTO pioNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Néese catáca wàwali, yá Jesús ìyaca mesa iwéré wáapicha wía yéewáidacaléca doce wamanùbaca. ");
INSERT INTO pioNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Idècunitàacá wayáaca wayáacaléwa, yá íimaca walí: —‍Péemìacué cayábani, abéeri péenácué itépiná nùuwidenái náibàacaténá núa —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Yá idàbaca achúmaca wawàwa manuísíwata, yá wadàbaca wasutáca wéemìawani abéerinamata: —‍Nuíwacali, ¿núasica? —‍wáimaca. ");
INSERT INTO pioNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Jesús íimaca walí: —‍Yái yáapúadéerica núapicha pan quírápieli irìculé, yácata itéeripináca nùuwidenái náibàacaténá núa. ");
INSERT INTO pioNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Iwàwacutá nuétácawa càide iyúwaté profetanái itànàanáté tàacáisi nuináwaná ìwali Dios inùmalìcuíse, núa asìali Dios néeséerica; quéwa, ¡máiníiripiná yùuwichàacawa yái asìalica itéeripináca nùuwidenái náibàacaténá núa! Cayábatésica irítáni càmicaalíté imusúa iicá èeritá —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Néese Judas yái íináidéericatéwa itéenápiná Jesús yùuwidenái náibàacaténáni, yá isutáca yéemìawa Jesús: —‍Nuíwacali, ¿núasica? —‍íimaca yái Judasca. Néese Jesús íimaca irí: —‍Báisíta, píacatani —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Néese idècunitàacá wayáaca wayáacaléwa, Jesús yeedáca pan icáapi irìculéwa, yá yàaca Dios irí cayábéeri ìwali yái panca. Néese isubèriadacani, iwacùaca walíni. Iimaca walí: —‍Peedácué piyáawani, yácata nuiná yái —‍íimaca walí. ");
INSERT INTO pioNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Néese yeedáca copa icáapi irìculéwa, abéechúa copa idènièchúa irìcuwa uva ituní. Yá yàaca Dios irí cayábéeri ìwali yái uva ituníca. Néese ichàbáidaca walíni, yá íimaca walí: —‍Macáitacué pìiracuéni. ");
INSERT INTO pioNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Yácáiná yái uva ituníca, yácata nuíraná imusuéripinácawa nuíchawa cruz ìwali manùbéeyéi wenàiwica irípináwa, imàaquéerica nacái báisíiricani yái wàlisài wawàsi Dios imàníirica wenàiwicanái yáapicha iwasàanápiná níawa Dios yàasu yùuwichàacáisi íicha. Nuétácawa yéewacaténá Dios imàacaca iwàwawa nabáyawaná íicha. ");
INSERT INTO pioNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Quéwa núumacué pirí càmita nuèpùa nuìrapináca quirínamani yái uva ituníca àta áiba èeripiná nuìracataléta wàlisài uva ituní píapichacué yàcalé irìcu Núaniri Dios icùacataléca macáita chènuniré —‍íimaca walí yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Néese idécanáamité wacántàaca máisibáwanáita salmos, yá wàacawa dúli néré íipidenéechúa Olivos, yái olivo inàlimanáca. ");
INSERT INTO pioNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Jesús íimaca walí: —‍Macáitacué piwènúadapiná nuícha píiwitáisewa yáta catáquéi, néese pimàacapinácué núa abéerita, càide iyúwaté Dios yàasu profeta itànàaná tàacáisi Dios íiméericaté nùwali. Dios íimacaté: ‘Nunúapiná yái icuèrica nupìra ovejanáiwa, néese nupìra ovejanái napìapinácawa nacàlàlìacawa’, íimacaté yái Diosca. ");
INSERT INTO pioNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Quéwa nudécanáami numichàacawa yéetácáisi íicha, yá nùapinácuécawa pipíchalé Galilea yàasu cáli néré, yásí nuípunitáidacuéca pía néréwa —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Néese Pedro íimaca irí: —‍Ewita macáita áibanái iwènúadacaalí píicha íiwitáisewa, càicáaníta càmita cài numànica —‍íimaca yái Pedroca. ");
INSERT INTO pioNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Jesús íimaca irí: —‍Péemìa cayába, yáta catáquéi, ipíchawáise cawámai itàaca, yá pimànipiná pichìwawa máisiba yàawiría càmíináca píalíawa nùwali, ipíchaná nanúaca pía núapicha —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Quéwa Pedro íimaca: —‍Ewita iwàwacutácaalí nacái nuétácawa píapichawa, càicáaníta càmitanica nucàlida nuchìwawa càmíináca núalíawa pìwali —‍íimaca yái Pedroca. Yá macáita wía Jesús yéewáidacaléca cài wáimaca nacái Jesús irí. ");
INSERT INTO pioNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Néese Jesús yàanàaca wáapicha wía yéewáidacaléca bànacalé inàlimaná néré íipidenácatalé Getsemaní. Yá íimaca walí: —‍Píawinacuéwa chái idècunitàacá nùaca néré nusutáca núawawa Dios íicha —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Yá Jesús itéca yáapichawa Pedro, nía nacái Zebedeo yéenibeca pucháiba íipidenéeyéica Santiago, Juan nacái. Yá Jesús yùuwichàacawa manuísíwata achúmacáiná iwàwa, cáalucáiná íináidacawa, yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Néese íimaca nalí: —‍Máiní achúmaca nuwàwa nuínáidacawa nuwàwalìcuísewa càide iyúwa wenàiwica iwàwéeri yéetácawa aquialéta. Chátacué píara. Picácué piimá pìyaca. Nuwàwacué pìacawéeridaca núa —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Néese Jesús yàacawa napíchalé achúmáanata. Yá Jesús yúuwàa irìacawa inùmáawawa cáli iwéré. Yá íimaca Dios irí: “Núaniri, cayábacaalí piwasàanáca núa íicha yái manuíri nùuwichàanápinácawa, yá piwasàaca núa. Quéwa càmicaalí cayába piwasàaná núa, yá picá pimàni càide iyúwa nuwàwáaná, néese pimàni càide iyúwa piwàwáanáwa”, íimaca isutáca yáawawa Dios íicha yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Néesecáwa Jesús yèepùacawa àniwa yéewáidacalénái yàataléwa. Yá yàanàaca nía iiméeyéicáita. Yá Jesús íimaca Pedro irí: —‍¿Cánácué càmita yéewa picawàacawa ibatàa abéeri horapiná pìacawéeridacaténácué núa? ");
INSERT INTO pioNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Picácué piimá pìyaca. Pisutácué píawawa Dios íicha ipíchaná Satanás yáalimáidacuéca pía pimàníinápinácué pibáyawanáwa. Piwàwacuéca pimànica càide iyúwa nuwàwáaná, quéwa machawàacáicatacué piiná meedá —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Néese àniwa Jesús yàacawa náicha pucháibáaná yàawiríapiná. Yá isutáca yáawawa Dios íicha. Iimaca: “Núaniri, càmicaalí cayába piwasàaná núa íicha yái yùuwichàacáisica, yásí pimàni nulí càide iyúwa piwàwáaná”, íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Néese Jesús yèepùa yéewáidacalénái yàataléwa àniwa, yá iicáca nía iiméeyéica àniwa máinícáiná cadapùleca nía báawanama. ");
INSERT INTO pioNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Yásí Jesús imàacaca nía càita, yá yàacawa náicha àniwa isutácaténá yáawawa Dios íicha máisiba yàawiríanápiná àniwa càide iyúwa idéenáté isutácáwaca. ");
INSERT INTO pioNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Néese yèepùacawa yéewáidacalénái yàataléwa àniwa. Yá Jesús isutáca yéemìawa nía: —‍¿Cánácué piimá pìyaca mamáalàacata? ¿Cánácué piyamáidacáitacuéwa? Idéca nùasu èeri yàanàaca, núa asìali Dios néeséerica, presocatáipiná namànica núa namàacacaténá cabáyawanéeyéi inúaca núa. ");
INSERT INTO pioNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Pimichàacuéwa wàanácuéwa. Aca néese yái asìalica itéerica nùuwidenái náibàacaténá núa —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Idècunitàacá Jesús itàaníca, yá Judas yàanàaca, yái abéeri yéewáidacaléca, docenámica wía. Yàanàaca madécaná wenàiwica yáapicha cacáapisèeyéi. Naté espada machete nacáiri, àicu nacái áiba. Sacerdote íiwacanánái, judío íiwacanánái nacái nabànùacaté wenàiwica Judas yáapicha íibèeyéipináca Jesús. ");
INSERT INTO pioNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Judas, yái itéeripinácaté Jesús yùuwidenái náibàacaténáténi, icàlidacaté nalí quéecha càinápinácaalí iyú yáasáida Jesús. Càité Judas íimaca nalí quéechatécáwa: “Yái asìali nutàidéeripináca nusùsuèripináca nacái inàni ìwali, yácata Jesús. Yá píibàacuéni”, càité íimaca nalí yái Judasca. ");
INSERT INTO pioNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Iná Judas yàacawa Jesús yàatalé. Yá Judas íimaca Jesús irí: —‍¡Catámiquéera, Nuíwacali! —‍íimaca yái Judasca. Néese Judas isùsùaca Jesús inàni ìwali càide iyúwa wáiwitáise iyáaná watàidáaná wenàiwica cáininéerica waicáca, wía judíoca. ");
INSERT INTO pioNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Jesús íimaca irí: —‍Pía nùacawéerináca, pimàni caquialéta yái piwàwéerica pìanàaca pimànica —‍íimaca yái Jesúsca. Néese níái yèeyéicawa Judas yáapicha nàacawa Jesús yàatalé, yá náibàacani. Yá nacùacani presoíri iyú. ");
INSERT INTO pioNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Néese abéeri wéená wía Jesús yáapichéeyéica iwatàaca yàasu espadawa machete nacáiri. Yá yáalimáidaca ipéliacatatá, yá inúacatatáni espada iyú abéeri sacerdote íiwacaliná yàasu wenàiwica. Quéwa isasàacáita yùuwi abéemàa. ");
INSERT INTO pioNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Néese Jesús íimaca yéewáidacalé iríwa: —‍Píiyàa pìasu espadawa yàalu irìculéwa. Càmita cayába cài pimàníináca, níacáiná macáita wenàiwica ipéliéyéica espada machete nacáiri iyú néetápiná nacáiwa espada iyúwa. ");
INSERT INTO pioNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Càmita píalíawa nuwàwacaalí nusutáca Núaniri Dios íichawa iyúudàanápiná núatá, yásí ibànùaca nulí sesenta mil ichàbaníiseta ángelnáicatá iyúudèeyéipiná núatá? ");
INSERT INTO pioNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Quéwa nupéliacaalí, nusutácaalí nacái Dios íicha yàasu ángelnái, yá càmita núalimá nùuwichàacawa càide iyúwaté profetanái itànàanáté tàacáisi nuináwaná ìwali bàaluité Dios inùmalìcuíse —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Néese Jesús isutáca yéemìawa níái wenàiwicaca: —‍¿Cánácué pìanàa nùatalé cacáapisàiwaca espada, àicu nacái píibàacaténá núa presoíri iyúpiná càide iyúwa piicáaná cayéedéerimi? Càmitacué iwàwacutá cài pimànica càmicáinácué nupéliapiná píipunita. Macái èeri imanùbaca nudéca nùyaca templo irìcu, nuéwáidacaalíté wenàiwica, yáté càmitacué píibàa núa néeni. ");
INSERT INTO pioNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Quéwa píalimácué píibàaca núa siùcade yéewanápiná macáita ichàbacawa càide iyúwaté profetanái itànàaná tàacáisi nuináwaná ìwali bàaluité Dios inùmalìcuíse —‍íimaca yái Jesúsca. Néese macáita wía Jesús yéewáidacaléca wamàacaca Jesús abéerita. Yá wapìacawa náicha. ");
INSERT INTO pioNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Níái íibèeyéicaté Jesús natécani Caifás icapèe néré, yái sacerdote íiwacalináca. Nía nacái yéewáidéeyéica wenàiwica templo irìcu, judío íiwacanánái nacái nàwacáidáyacacatéwa Caifás icapèe irìculé. ");
INSERT INTO pioNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pedro yàacawa náamiwáise déecuíseta. Yá iwàlùacawa bàacháwa irìculé yái sacerdote íiwacaliná icapèe ibàacháwalenáca. Yá yáawinacawa úwinái yèewi, níái icuèyéica templo. Pedro iyamáacawa néré iicácaténá càinácaalí ichàbacawa yái Jesús. ");
INSERT INTO pioNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Sacerdote íiwacanánái, nía nacái Junta Supremanái israelita íiwacanánáica nacutáca cachìwéeri wawàsi Jesús ìwali, namàacáanápiná úwinái nanúaca Jesús. ");
INSERT INTO pioNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Quéwa canáta nàanèeri ìwali wawàsi nanúanápiná Jesús éwita madécaná nacàlidacáaníta nachìwawa nacháawàacaténá Jesús iináwaná ìwali. Atata nàanàaca pucháiba wenàiwica icàlidéeyéipináté ichìwawa. ");
INSERT INTO pioNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Náimaca: —‍Yái asìali íimacaté: ‘Núalimá numáalàidaca Dios yàasu templo, yásí nubàlùadapináni àniwa máisiba èeri irìcu’, cài íimaca —‍náimaca. ");
INSERT INTO pioNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Néese yái sacerdote íiwacaliná imichàa ibàlùacawa. Yá íimaca Jesús irí: —‍¿Cáná càmita pitàaní? ¿Càiná píimaca ìwali yái nacàlidéerica pìwali nacháawàanáca piináwaná ìwali? —‍íimaca. ");
INSERT INTO pioNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Quéwa, éwita càmicáaníta cabáyawanáca yái Jesúsca, càicáaníta masànata náichani mamáalàacata, canáca icàlidáaná iináwanáwa nalí. Néese sacerdote íiwacaliná íimaca irí àniwa: —‍Nuchùulìa pía cáuri Dios íipidená ìwali picàlidáanápiná walí báisíiri iyúni. Picàlida walíni, ¿píatasica yái Mesíasca, judío icuèrinápináca, yái Dios Iirica? —‍íimaca. ");
INSERT INTO pioNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jesús íimaca irí: —‍Yáca núa yái càide iyúwa píimáaná. Núumacué nacái pirí áibaalípiná piicápinácuéca núa, núa asìali Dios néeséerica. Piicápinácuéca núa yáawinéericawa Dios yéewápuwáise, yái Dios cachàiníirica náicha canánama nucùacaténá yáapicha macáita. Yá piicápinácuéca nacái nùanàaca àniwa acalèe yèewíise chènuníise —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Néese yái sacerdote íiwacaliná icacanáidaca ibàlewa càide iyúwaté judío íiwitáise ìyáaná yáasáidacaténá báawaca yéemìaca yái Jesús íimáanáca Dios ìwali. Yá sacerdote íiwacaliná íimaca nalí: —‍¡Yái asìali itàaníca báawéeri iyú Dios ìwali! ¡Càmita iwàwacutá wéemìaca áibanái icàlidáaná iináwaná ìwali! Pidécuéca péemìaca itàaníca báawéeri iyú Dios ìwali, icàlidaca ìwaliwa Dios Iiricasani. ");
INSERT INTO pioNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Càinásicué wamànica irí? —‍íimaca. Néese náimaca: —‍Cabáyawanácani. Iwàwacutá yéetácawa —‍náimaca. ");
INSERT INTO pioNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Néese abénaméeyéi nàapìsáidaca Jesús inàni. Nacapèedáidacani nacái. Aibanái nanúadáidaca nacái inàni ìwali. ");
INSERT INTO pioNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Nabàlìa nacái ituí, yá náimaca irí: —‍Píasa Mesíasca, yái wacuèrinása Dios ibànuèrisa walí, ¡piwicùlida, picàlida walíni cawinácaalí níái inúadáidéeyéica pía! —‍náimaca naicáaníca iquíniná. ");
INSERT INTO pioNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Pedro yáawinacawa ìyaca bàacháwáise, yá inanái íibaidéechúa néré ùacawa Pedro yàatalé. Yá úumaca irí: —‍Pía nacái yèepuníiritéwa Jesús yáapicha, yái Galilea néeséerica —‍úumaca. ");
INSERT INTO pioNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Quéwa Pedro icàlidaca ichìwawa nèewi macáita níái wenàiwicaca. Yá íimaca: —‍Càmita núalíawa ìwali yái pitàaníirica nulí ìwali —‍íimaca yái Pedroca, cáalucáináni, ipíchaná nanúacani Jesús yáapicha. ");
INSERT INTO pioNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Néesecáwa Pedro yàacawa náicha iwáiná inùma néré, yái iwáiná bàacháwa itéeséerica. Yá áiba uicáca néréni, yá úumaca áibanái irí níái ìyéeyéica néré: —‍Yái asìaliquéi yèepunítéwa Jesús yáapicha, yái Nazaret néeséerica —‍úumaca nalí. ");
INSERT INTO pioNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Yá Pedro icàlidaca ichìwawa àniwa báisí báisícata càmíinása yáalía iicáca Jesús. Iimaca: —‍¡Càmita núalía nuicácani yái asìalica! —‍íimaca yái Pedroca, ipíchaná náibàacani. ");
INSERT INTO pioNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Achúmáana tàacáwa àniwa, áibanái ìyéeyéica néré nàacawa Pedro yàatalé. Yá náimaca irí: —‍Báisíta píaca néená níái Jesús yéewáidacaléca pitàanícáiná càide iyúwa Galilea yàasu cáli néeséeyéi —‍náimaca irí. ");
INSERT INTO pioNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Néese Pedro idàbaca icàlidaca ichìwawa báawéeri tàacáisi iyú báawanama báisí báisísíwata Dios yáaliériwa. Pedro íimaca: —‍¡Càmita núalía nuicácani yái asìalica! —‍íimaca yái Pedroca, cáalucáináni. Yáta cawámai itàaca. ");
INSERT INTO pioNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Yá Pedro iwàwalica tàacáisi Jesús íiméericaté irí: ‘Ipíchawáise cawámai itàaca, yá pimànipiná pichìwawa máisiba yàawiría càmíináca píalíawa nùwali’, càité íimaca yái Jesúsca. Yá Pedro yàacawa náicha. Yá íicháaníca cachàiníiri iyú. ");
INSERT INTO pioNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Amalácaalíté nawicáu, yá macáita sacerdote íiwacanánái abédanamata náiwitáise náapicha níái judío íiwacanánái béeyéica nanúanápiná Jesús. ");
INSERT INTO pioNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Yá nadacùaca náichawa Jesús. Néese natécani Pilato yàatalé, yái gobernador romanosàiri icuèricaté Judea yàasu cáli. ");
INSERT INTO pioNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Néeseté Judas, yái itéericaté nía Jesús yàatalé náibàacaténáni, yá Judas iicáca natéca Jesús nadacuèrimi, gobernador romanosàiri yàatalé nasutácaténá gobernador ichùulìanápiná úwinái inúaca Jesús. Iná Judas, iicácáiná nanúanápináté Jesús, yá achúmaca Judas íináidacawa iwàwawa, báawaca iicáca yái imàníinácaté. Yá Judas iwàlùacawa nàatalé níái sacerdote íiwacanánáica, nía nacái judío íiwacanánái béeyéica. Yá Judas iwàwacaté yèepùadaca nalí yái plataca nèericaté irí itéenácaté nía Jesús yàatalé náibàacaténáni, níái treinta namanùbaca moneda plata cawèníiyéi báinúaca quéeri iwènicatáica. ");
INSERT INTO pioNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Judas íimaca nalí: —‍Nuèpùadacué pirí yái plataca ipíchaná cabáyawanáca núa ìwalíise. Nudéca numànica nubáyawanáwa nutéenácué pía yàatalé píibàacaténáni pinúanápinácuéni, yáara asìali mabáyawanéerica —‍íimaca yái Judasca. Quéwa náimaca Judas irí: —‍¡Canápináta walíni cabáyawanáanáca pía! ¡Pìasu wawàsicatéera! —‍náimaca. ");
INSERT INTO pioNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Iná Judas yúucaca íichawa níái monedaca templo irìculé. Néese yàacawa. Yá idacùaca icanápi ìwalíisewa yéenúlusi iyú idacuèricaté chènuníise. Yá ipisìacawa chènuníise, yéewacaténá yéenúlusi isidùa icanápi, yá yéetácawa. ");
INSERT INTO pioNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Néese sacerdote íiwacanánái ìwacáidaca níái monedaca Judasmi yúuquéericaté íichawa templo irìculé. Yá náimaca: —‍Idéca yeedáca iríwa yái plata imàacacaténá nanúaca asìali, íná casacàaca Dios iicáca yái plataca. Canátacué yéewaná wamàacaca Dios iríni ofrenda iyú —‍náimaca. ");
INSERT INTO pioNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Iná náináidacawa nawènìanápiná cáli Judasmi yàasu plata iyú, abéeri cáli íipidenéeri Campo del Alfarero (íimáanáca “yàasu cáli, asìali imàníirica mapuwáa”). Néese nadécanáami nawènìacani, yá namàacaca yái cáli nabàlìacatalépiná yéetéeyéimiwa càmíiyéica judío. ");
INSERT INTO pioNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Iná Jerusalén ìyacàlená mìnanái néemìacáináté càinácaalíté namànica Judas yàasu platami iyú, yá nàaca íipidená yái cálica Campo de Sangre (íimáanáca “Irái yàalu”) Judasmi yeedácáináté iríwa yái plataca imàacacaténáté nanúaca asìali. Mamáalàacata cài náimaca ìwali yái cálica, àta siùca nacáide. ");
INSERT INTO pioNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Càité macáita ichàbacawa càide iyúwaté profeta itànàanáté tàacáisi Dios inùmalìcuíse, abéeri néená níái profeta ìyéeyéicaté profeta Jeremías yéetácadénáamitéwa. Yái profeta íimacaté: “Needáca treinta namanùbaca moneda plata cawèníiyéi, yái asìali iwènináami càide iyúwa israelita íiwacanánái ipáyaidáaná nawènìacaténá asìali nàasu wenàiwicapinácawa. ");
INSERT INTO pioNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Yá nawènìaca cáli platami iyú, yàasu cáli yái asìali imàníirica mapuwáa, càide iyúwa Wacuèriná Dios ichùulìaná núa”, cài íimacaté yái profetaca Dios inùmalìcuíse. ");
INSERT INTO pioNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Néeseté natéca Jesús gobernador romanosàiri yàatalé, yá gobernador isutáca yéemìawa Jesús. Gobernador íimaca Jesús irí: —‍¿Píatasica judío icuèrinápiná? —‍íimaca. Néese Jesús íimaca: —‍Báisíta, núacani, pidéca cài píimaca —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Néese sacerdote íiwacanánáica, nía nacái judío íiwacanánái béeyéica idècunitàacá nacháawàaca Jesús iináwaná ìwali mamáalàacata, yá masànacata náicha Jesús, éwita càmicáanítaté imàni ibáyawanáwa iyúwa nacháawàaná iináwaná ìwali. ");
INSERT INTO pioNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Iná yái Pilato gobernadorca isutáca yéemìawa Jesús. Yá íimaca Jesús irí: —‍¿Cáná càmita picàlida nulí piináwanáwa? Péemìa nacháawàaná piináwaná ìwali manùba wawàsi ìwalíise —‍íimaca yái Pilatoca. ");
INSERT INTO pioNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Masànata quéwa yái Jesúsca, càmita icàlida iináwanáwa gobernador irí, ibatàa abéeri tàacáisi pináta. Iná yái Pilato gobernadorca íináidacawa manuísíwata iicáidaca Jesús irí. ");
INSERT INTO pioNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Camuí imanùbaca judíonái imànicaalíté Pascua yàasuná culto, yáté gobernador romanosàiri iwasàaca abéeri presoíri judíonái irípiná càiríinácaalí presoíri nawàwéeri. ");
INSERT INTO pioNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Néenialíté ìyaca caináwanéeri presoíri íipidenéericaté Jesús Barrabás. ");
INSERT INTO pioNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Néese idécanáami judíonái nàwacáidáyacacawa Pilato yàatalé, yá Pilato isutáca yéemìawa nía: —‍¿Càiríinácaalícué náicha piwàwa nuwasàaca pirí, Barrabástasica, càmicaalí nacái, Jesús áibatasica, yái náiméerica ìwali Mesíascani, yái nacuèrinásàirica Dios ibànuèrica nalí? —‍cài íimaca yái Pilatoca. ");
INSERT INTO pioNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pilato icàlidaca nalíni, yáalíacáinátéwa báawaca judío íiwacanánái iicáca Jesús, máinícáiná cayábaca macái wenàiwica naicáca Jesús, íná judío íiwacanánái náibàacaté Jesús nacháawàacaténá iináwaná ìwali gobernador irí. ");
INSERT INTO pioNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Néese idècunitàacá Pilato yáawinacawa ìyaca néré yàasu manuíri yàalubáisi íinatawa, yá Pilato yàacawéetúa ibànùaca irí tàacáisi. Yá úumaca irí: “Piwasàa caquialéta yáara asìali mabáyawanéerica, núamacanicáiná táiyápi bàwina. Yá núamacani irìcuíse máiní cáaluca núa manuísíwata Jesús ìwalíise, ipíchaná pimànica irí báawéeri”, cài ubànùaca tàacáisi ùacawéeri Pilato iríwa. ");
INSERT INTO pioNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Quéwa sacerdote íiwacanánái, nía nacái judío íiwacanánáica nawènúadaca manùbéeyéi wenàiwicanái íiwitáise nasutáanápiná Pilato íicha iwasàacaténá nalípiná Barrabás, ichùulìaca nacái yàasu úwináiwa nanúanápiná Jesús. ");
INSERT INTO pioNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Néese gobernador Pilato isutáca yéemìawa nía àniwa: —‍¿Càiríiná asìali pucháibéeyéica íicha piwàwacué numàaca yèepunícawa pirícué? —‍íimaca. Néese náimaca: —‍¡Piwasàa walí Barrabás! —‍náimaca. ");
INSERT INTO pioNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilato isutáca yéemìawa nía: —‍Néeni, nuwasàacaalícué pirí Barrabás, ¿càinásicué piwàwa numànica Jesús irí, yái píiméericuéca ìwali, Mesíascani, yái picuèrinápináca? —‍íimaca. Néese macáita náimaca: —‍¡Pitàtàacuéni cruz ìwali! —‍náimaca. ");
INSERT INTO pioNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Néese Pilato isutáca yéemìawa nía: —‍¿Cáná? ¿Càinásica báawéeri idé imànica? —‍íimaca yái Pilatoca. Quéwa nèepùa néemíanícawa: —‍¡Pitàtàacuéni cruz ìwali! —‍náimaca. ");
INSERT INTO pioNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Atata Pilato yáalíacawa càmita yáalimá iwènúadaca náiwitáise, iicáca nacái máiní calúaca nía cachàiníwanái mamáalàacata nawàwáanápináté namànica ùwicái gobierno íipunita yàcalé irìcu. Iná Pilato ichùulìaca yàasu wenàiwicawa itéenápiná irí úni. Yá Pilato íibaca icáapiwa manùbéeyéi wenàiwica naicápiná yáasáidacaténá nalí yáawawa càide iyúwa canáca nacáiri ibáyawaná Jesús ìwalíise, quéwa cabáyawanéeri mamáalàacatani yái Pilatoca. Yá Pilato íimaca nalí: —‍Canáca nubáyawaná pinúanácué yái asìalica. Pìasu wawàsitacué pinúani —‍íimaca yái Pilatoca. ");
INSERT INTO pioNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Macáita wenàiwicanái náimaca irí: —‍¡Wía cabáyawanéeyéica ìwalíise, wéenibe nacái! —‍náimaca. ");
INSERT INTO pioNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Iná Pilato iwasàaca nalí Barrabás. Néese ichùulìaca yàasu úwináiwa nacapèedáidaca Jesús mabàleta cachàiníiri cabèesi iyú. Nadécanáami nacapèedáidaca Jesús báawanama àta íimami ichalàacatalétawa íicha, yá Pilato yèepùadacani úwinái irí natàtàanápináni cruz ìwali. ");
INSERT INTO pioNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Néese gobernador yàasu úwinái natéca Jesús Pilato icapèe manuíri néré, bàacháwa irìculé. Yá namáidaca macáita néenánáiwa úwináica nàwacáidáyacacaténáwa Jesús itéese. ");
INSERT INTO pioNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Needáca Jesús ibàle. Yá náucaca ìwalíise cáaléeri ruana nacáiri quíiréeri càiride iyúwa romano icuèriná ibàle, nacuèriná naicácaténásatáni, quéwa naicáanícáita meedá Jesús iquíniná. ");
INSERT INTO pioNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Néese namànica tuíri culèpi nacáiri icàyuwaniná càiride iyúwa romano icuèriná yàasu corona. Yá náiyàaca corona Jesús íiwita ìwali. Namàacaca sitùa Jesús icáapi yéewápuwáiséeri irìculé càide iyúwaté romano icuèriná idènìaná yàasu àicu oroíriwa. Néese nabàlùacawa nàuluì ipùata iyúwa Jesús irí càide iyúwa nàaca nacáicaalí icàaluíniná quéwa naicáanícáita meedá iquíniná. Càmita báisíiri iyú nàa icàaluíniná. Yá náimaca irí: —‍¡Casíimái piwàwa, pìyaca manùba èeri, píasa judío icuèrinásàirica! —‍náimaca, càide iyúwaté romano íiwitáise natàidáaná nacuèrináwa, naicáanícaténá meedá Jesús iquíniná. ");
INSERT INTO pioNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Nàapìsáidacani, yá needáca sitùa icáapi íicha, yá nanúadáidaca íiwita ìwali sitùa iyú. ");
INSERT INTO pioNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Idécanáami cài naicáaníca Jesús iquíniná, yá needáca íicha yái ruana nacáiri quíiréerica. Néese náiyàaca ìwali ibàle, yá natéca natàtàacaténáni cruz ìwali. ");
INSERT INTO pioNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Nàacanáamiwa capìi íicha, càmita yéewa Jesús iwáacutaca yàasu cruz, canácáiná quirínama ichàini, úwináicáiná icapèedáidacani báawanama. Iná úwinái íibàaca asìali íipidenéerica Simón, Cirene ìyacàlená néeséeri. Yá nachùulìaca Simón iwáacutaca cruz Jesús irípiná. ");
INSERT INTO pioNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Natéca Jesús méetàuculé Jerusalén ìyacàlená íicha. Nàanàacaté Gólgota néré (íimáanáca “Iiwitasi yáapimi ìyacatalé”). ");
INSERT INTO pioNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Yá nawàwacaté nàaca Jesús ìira uva ituní ipuíri, nèewìadéerica dabé yèewi íipidenéeri hiel wéebacaténá Jesús iiná ipíchaná máiní yùuwichàacawa cruz ìwali. Quéwa, idécanáami yáalimáidaca achúmáanata, yá càmíirita ìira náichani. ");
INSERT INTO pioNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Idécanáami úwinái natàtàaca Jesús cruz ìwali, yá náibàaca ibàlemi, náucaca náichawa suerte naseríacaténá nalíwáaca Jesús ibàlemi. ");
INSERT INTO pioNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Néese úwinái iyamáa yáawinacawa néré nacùacaténáni ipíchaná áibanái yàanàaca yàatalé. ");
INSERT INTO pioNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Nachanàidaca tàacáisi cruz ìwali Jesús íiwita iwicáubàa. Yái tàacáisi icàlidacaté cáná yéewa nanúacani. Yá tàacáisi íimaca: “Yácata Jesús, yái judío icuèrináca”, íimacaté yái tàacáisica. ");
INSERT INTO pioNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Natàtàaca nacái pucháiba cayéedéeyéi cruz ìwali mawiénita Jesús irí. Abéeri cruz ibàlùacawa Jesús yéewápuwáise, áiba cruz nacái ibàlùacawa apáuwáise Jesús irí. ");
INSERT INTO pioNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Níái ichàbéeyéicawa néenibàa àyapulìcubàa natàaníca Jesús ìwali báawéeri iyú, nacusúadaca náiwitawa irí naicáanícaténá iquíniná. ");
INSERT INTO pioNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Yá náimaca irí: —‍¡Píata imáalàidéeripinása templo, imichàidéeripinása nacái àniwani máisiba èeri irìcu, pichàiniada píawawa yéetácáisi íicha ipíchaná péetácawa! ¡Báisícaalí Dios Iirica pía, yá piricùawa cruz íicha! —‍náimaca naicáaníca Jesús iquíniná. ");
INSERT INTO pioNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Càita nacái naicáaníca Jesús iquíniná níái sacerdote íiwacanánáica, nía nacái yéewáidéeyéica wenàiwica templo irìcu, nía nacái judío íiwacanánái béeyéica. Náimaca nalíwáaca: ");
INSERT INTO pioNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","—‍Ichùnìacaté áibanái ipíchanáté néetácawa, quéwa càmita yáalimá ichàiniadaca yáawawa yéetácáisi íicha. Báisícaalí Israel itaquénáinámi icuèrinácatáni, ¡yásí yáalimá iricùacawa cruz íichatá, weebáidacaténá itàacái! ");
INSERT INTO pioNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Iimacaté manuícasa íináidacawa iwàwawa Dios ìwali, íibàacaténása nacái iwàwawa Dios iwéré Dios icùanápináténi báawéeri íicha. Quéwa báisícaalí cáinináca Dios iicácatáni, ¡yá Dios ichàiniadacatáni yéetácáisi íicha ipíchaná yéetácawa! ¡Iná càmita yéewa Dios Iiricani càide iyúwaté icàlidáaná ichìwawa! —‍náimaca naicáaníca Jesús iquíniná. ");
INSERT INTO pioNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Nía nacái cayéedéeyéica natàtèeyéica cruz ìwali mawiénita Jesús irí, natàaníca nacái ìwali báawéeri iyú. ");
INSERT INTO pioNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Néeseté machacànicaalíté èeri, yá catáca macáita chái èeri irìcu máisiba horapiná catáca, àta las tresta táicalé. ");
INSERT INTO pioNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Yásí horaquéi a las tres Jesús imáidaca cachàiníiri iyú itàacái iyúwa. Yá íimaca Dios irí: “Elí, Elí, ¿lema sabactani?”, íimaca yái Jesúsca. (Yái tàacáisi íimáanáca: “Nucuèriná Dios, Nucuèriná Dios, ¿cánásica pimàaca núa abéerita?” cài íimáanáca.) ");
INSERT INTO pioNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Abénaméeyéi néená níái ibàluèyéicawa néré néemìacáináni, yá náimaca nalíwáaca: —‍Yái asìali imáidaca ìyaca profeta Elías —‍náimaca. ");
INSERT INTO pioNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Yá abéeri náicha yàaca yeedáca esponja wáluma nacáiri íisapiadacaténáni uva ituní iyú càaméeri ìiracaná. Yá idacùaca esponja isàbéerica sitùa ipùatalìcu. Néese imichàidacani mawiénita Jesús inùma irí, yéewacaténá Jesús ibèrùacani. ");
INSERT INTO pioNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Aibanáita quéwa yáapichéeyéi náimaca irí: —‍Tàacáwa, wacùacuécani waicáwa Elías yàanàacaalí yeedácani cruz íicha —‍náimaca naicáaníca Jesús iquíniná. ");
INSERT INTO pioNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Néese àniwa Jesús imáidaca cachàiníiri iyú, yá imàacaca icáucawa yàacawa iiná íichawa. ");
INSERT INTO pioNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Jesús yéetácanacáitawa, yáta manuíri yáawàanáca templo irìcuírica icacanácawa bamuchúamibàa cáli iwérénama, pucháibawaca yèewi, yái yáawàanáca ibàlièrica mabáyawanéeri Dios ìyacatáica wenàiwicanái ituí íicha. Yá icacanácawa chènuníise cáli iwérénama, yái yáawàanáca. Cáli icusúaca nacáiwa. Yá íba manuínaméeyéi nacái nasubèriacawa cáli icusúacái iyú. ");
INSERT INTO pioNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Yáta madécaná càliculìi inùma nàacùacatéwa, yá nacáucàacawa madécaná yeebáidéeyéicaté Dios itàacái, níái yéetéeyéimicatéwa. ");
INSERT INTO pioNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Néesetécáwa namusúacawa càliculìi irìcuíse idécanáamité Jesús imichàacawa yéetácáisi íicha. Yá nawàlùacatéwa Dios yàasu yàcalé irìculé, yái Jerusalén ìyacàlenáca, yáté madécaná wenàiwica naicáca nía néré. ");
INSERT INTO pioNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Néese úwi íiwacaliná, nía nacái yáapichéeyéica icuèyéicaté Jesús, naicácáiná cáli icusúacawa, yái áiba wawàsi ichàbáaná nacáiwa, yá cáaluca nía báawanama. Yá náimaca nalíwáaca: —‍¡Báisícata yái asìalica Dios Iirica! —‍náimaca. ");
INSERT INTO pioNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Nàyaca nacái néré manùba inanái iicáidéeyéica ìyaca Jesús irí déecuíseta quéwa. Níái inanáica nayúudàacaté Jesús yèepunícaalítéwa Galilea yàasu cáli íicha Jerusalén ìyacàlená nérépiná. ");
INSERT INTO pioNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Uyaca nèewi María Magdalenaca. Aiba María nacái ìya néré úái náatúaca, níái Santiago, José nacái. Aiba inanái nacái ìya néré úái Zebedeo yéenibe yáatúaca. ");
INSERT INTO pioNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Néeseté catáca yàacawa, yá abéeri càasuíri yàanàaca íipidenéerica José, Arimatea ìyacàlená mìnali. Yái Joséca yeebáidacaté Jesús itàacái. ");
INSERT INTO pioNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Yá José yàaca iicáca Pilato gobernador yàatalé. Yá isutáca Jesús iinámi Pilato íicha. Néese Pilato ichùulìaca namàacaca José itéca Jesús iinámi. ");
INSERT INTO pioNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Ináté José yàacawa cruz néré, yeedáca Jesús iinámi, yá yéepùacani masaquèeri wáluma linoíri iyú, càide iyúwa wáiwitáise ìyáaná, wía judíoca. ");
INSERT INTO pioNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Yái José idènìaca yàasu càliculìi wàlisàiwa. Yá irìadaca Jesús iinámi càliculìi irìculé. Yái càliculìica áibanái íiquéericaté dúli ibàlài irìcu, yéewacaténá càliculìicani, càide iyúwa capìi imàdáaná. José, áibanái nacái idécanáami nabàlìaca càliculìi inùma manuíri íba iyú, yá nàacawa íicha. ");
INSERT INTO pioNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Quéwa María Magdalena, áiba María nacái nayamáacawa néré, náawinacáwacawa abéemàawáise càliculìi íicha. ");
INSERT INTO pioNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Néeseté mapisáita àniwa, yái sábado judíonái iyamáidacatáicawa, sacerdote íiwacanánái, fariseonái nacái nàacawa Pilato gobernador yàatalé, yái romanosàiri icuèricaté nàasu cáli. ");
INSERT INTO pioNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Yá náimaca irí: —‍Wáiwacali, pía icuèrica wía, wadéca wawàwalica yái íimáanácaté yáara cachìwéerica idècunitàacá cáucani. Iimacaté imichàanápinácatéwa yéetácáisi íicha máisiba èeri irìcu. ");
INSERT INTO pioNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Iná pichùulìa úwinái nacùaca cayábani yái càliculìica àta imáalàacatáitawéi máisiba èeri ipíchaná yéewáidacalénái yàanàaca táiyápi yá nayéedùaca iinámi càliculìi irìcuíse, ipíchaná nacái nacàlidaca nachìwawa wenàiwicanái irí idéenáca imichàacawa yéetácáisi íicha. Níacáiná yéewáidacalénái nacàlidacaalí iináwaná idécasa imichàacawa yéetácáisi íicha, yásí máiní yáawanáica báawaca íichani yái quéechéeri chìwáica yái nacàlidáanácaté nachìwawa ìwali Mesíascasani, yái judío icuèrinápináca —‍náimaca. ");
INSERT INTO pioNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Néese Pilato íimaca nalí: —‍Pidènìacuéca úwinái pichùulièyéipiná icùaca càliculìi. Pìacué pibàlìacani picùacué píalimáanáta cayábani, yái càliculìica, ipíchaná áibanái yàanàaca néré —‍íimaca yái Pilatoca. ");
INSERT INTO pioNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Néese nàacawa càliculìi néré. Yá nachanàidaca sello íyanási nacáiri íba ìwali, yái manuíri íba nabàlièrica iyú càliculìi inùma. Canáca yéewaná wenàiwica iwàlùacawa càliculìi irìculé càmicaalícáwa imàdáida sello quéechacáwa, yái sello íyanási nacáiri nachanàidéerica càliculìi inùma ìwali. Yá namàacaca néré nacái úwinái icuèyéipináca càliculìi ipíchaná áiba wenàiwica iwàlùacawa néré. ");
INSERT INTO pioNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Néese sábado ichàbacatéwa judíonái iyamáidacatáicawa. Yáté amaláca yàacawa domingo, yá María Magdalena, áiba María úapicha nacái nàaca naicáca càliculìi nérépiná. ");
INSERT INTO pioNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Yáta cáli icusúacawa cachàiníiri iyú, ángel Wáiwacali néeséeri yàanàacáiná chènuníise. Yàanàaca càliculìi néré, yá yeedáca manuíri íba càliculìi inùma íicha, yá yáawinacawa íba íinata. ");
INSERT INTO pioNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Yái ángel icànaca càide iyúwa énu icamaláná icànáaná. Idènìaca nacái ibàlewa cabalèeri, mèlumèluíri càide iyúwa nieve. ");
INSERT INTO pioNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Uwinái naicácani, yá natatácawa nacalùniwa, yá náuwàa nalìacawa cáli íinatalé càide iyúwa yéetéeyéimiwa. ");
INSERT INTO pioNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Néese ángel íimaca inanái irí: —‍Picácué cáalu pía nuícha. Núalíacawa picutácuéca pìacawa Jesús iinámi, yái natàtèericaté cruz ìwali. ");
INSERT INTO pioNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Canáca cháníi, idéca imichàacawa yéetácáisi íicha càide iyúwaté íimáaná. Aquialécué pìacuéwa piicáca aléi càliculìi irìculé nalìadacatáimicani. ");
INSERT INTO pioNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Néese pìacàatétacuéwa picàlidaca yéewáidacalénái iríni. Càicué píimaca nalí: “Wáiwacali idéca imichàacawa yéetácáisi íicha. Siùcade yàacawa pipíchalécué Galilea yàasu cáli néré. Nérépinácué piicáni”, càicué píimaca yéewáidacalénái iríwa. Yácata tàacáisi iwàwacutéericuéca nucàlidaca pirí —‍íimaca yái ángelca. ");
INSERT INTO pioNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Néese níái inanáica napìacawa càliculìi íicha, yá cáaluca nía quéwa casíimáica nawàwa manuísíwata. Yá napìacawa nàacaténá nacàlidaca walíni, wía Jesús yéewáidacaléca. ");
INSERT INTO pioNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Yáta Jesús imàacaca yáawawa naicácani, yá itàidaca nía. Yá nàacawa Jesús yàatalé, náuwàa nalìacawa nanùmáawawa cáli iwéré Jesús íipunita, náibàaca yàabàli ìwali nàacaténá icàaluíniná, càide iyúwa wáiwitáise ìyáaná, wía judíoca. ");
INSERT INTO pioNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Yá Jesús íimaca nalí: —‍Picácué cáalu pía. Pìacué picàlidaca nuénánái iríni nàacaténáwa Galilea yàasu cáli néré, yásí néréca naicápiná núawa —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Néeseté níái inanáica idècunitàacá nèepùaca nàacawa càliculìi íicha, yá abénaméeyéi néená níái úwináica icuèyéicaté càliculìi nèepùacawa Jerusalén ìyacàlená irìculé. Yá nacàlidaca sacerdote íiwacanánái iríni macáita yái ichàbáanácatéwa. ");
INSERT INTO pioNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Néese sacerdote íiwacanánái nàaca natàaníca judío íiwacanánái béeyéi yáapicha. Yáté abédanamacata náiwitáise. Néese nàaca madécaná plata úwinái irí masànacaténá níái úwináica. ");
INSERT INTO pioNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Yáté náimaca úwinái irí: —‍Picàlidacué áibanái iríni, táiyápi bàwina idècunitàacá piimácuéca pìyaca, yásasí níái Jesús yéewáidacalénáimica nàanàacaté needáca ichéecami, càicué píimaca wenàiwicanái iríwa. ");
INSERT INTO pioNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Néese gobernador yéemìacaalícué piináwaná ìwali càmíinácué picùa cayába yái càliculìimica, yásí watàanícuéca yáapicha piwicáu ipíchanácué inúaca pía —‍náimaca nachùulìaca úwinái nacàlidáanápiná nachìwawa. ");
INSERT INTO pioNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Néeseté úwinái needáca nalíwa yái plataca, yá nàacawa nacàlidaca nachìwawa càide iyúwa sacerdotenái ichùulìanáté nía. Càita nacái madécaná judíonái nacàlidaca càiri cachìwéeri tàacáisi Jesús ìwali àta siùca nacáide. ");
INSERT INTO pioNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Ináté wía Jesús yéewáidacaléca once wamanùbaca, wàacatéwa Galilea yàasu cáli néré, áiba dúli néré Jesús icàlidéericaté walí ìwali, wàwacáidáyacacatáipinácawa. ");
INSERT INTO pioNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Waicácaté Jesús, yá wàaca icàaluíniná, quéwa abénaméeyéi wéená càmitatécáwa neebáida báisíca Jesús yái naiquéerica. ");
INSERT INTO pioNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Néese Jesús yàacawa wàatalé. Yá íimaca walí: —‍Dios idéca imàacaca nulí íiwitáisewa nucùanápiná macáita ìyéerica chènuniré, chái èeri irìcu nacái. ");
INSERT INTO pioNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Pìacuéwa macái cáli íinatalé, péewáidacué macái wenàiwicanái neebáidáanápiná nutàacái. Pibautizácué nacái cawinácaalí yeebáidéeyéica Wáaniri Dios, núa nacái yái Dios Iirica, Espíritu Santo nacái. ");
INSERT INTO pioNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Péewáidacué wenàiwica namànicaténá macáita càide iyúwa nuchùulìanácué pía. Núatacué nacái píapicha, nùacawéeridapinácué píawa càiripináta àta yái èeriquéi imáalàacatalépinátawa, nùanàapinácaalí àniwa —‍íimaca yái Jesúsca.");
INSERT INTO pioNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Yácata cayábéeri tàacáisi icàlidéerica walí Jesucristo ìwali, yái Dios Iirica. Yái tàacáisica idàba cài: ");
INSERT INTO pioNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Profeta Isaías itànàacaté tàacáisi Dios íiméericaté Iiri iríwa. Dios íimacaté: “Péemìa cayába, nubànùapiná pipíchalé nùasu wenàiwicawa icàlidéerica nutàacáiwa. Yá yàapinácawa pipíchaléwa yàalàacaténá wenàiwica nachùnìanápiná náiwitáisewa yéewanápiná natàidaca pía cayábéeri iyú pìanàacaalípiná nàataléwa. ");
INSERT INTO pioNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Icàlidapiná nalíwani cachàiníiri iyú manacúali yùucubàa càináwàiri. Càipiná íimaca nalí: ‘Càide iyúwa wenàiwicanái ichùnìacaalí àyapu Náiwacali irípináwa, càitacué nacái iwàwacutácué pichùnìaca píiwitáisewa Wacuèriná Dios irípiná, pitàidacaténácué cayábéeri iyúni. Pichùnìacué píiwitáisewa yéewacaténá idàbaca yéewáidacuéca pìyaca machacàníiri iyú càide iyúwa iwàwáaná’, càipiná íimaca yái nùasu wenàiwicaca”, íimacaté yái Diosca. ");
INSERT INTO pioNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Ináté macáita ichàbacawa càide iyúwaté profeta Isaías icàlidáanáté tàacáisi Dios inùmalìcuíse. Juan el Bautista yàanàacaté manacúali yùuculé càináwàiri, yá ibautizáca yàacawa wenàiwicanái néenibàa. Yàalàaca nía nawènúadáanápiná náiwitáisewa Dios irípiná, nabautizáanápiná nacáiwa, náasáidacaténá namàacacaté náichawa yái báawéerica namàníirica, yéewacaténá Dios imàacaca iwàwawa nabáyawaná íicha. ");
INSERT INTO pioNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Néese manùbéeyéi wenàiwica nàacatéwa Juan yàatalé néemìacaténá itàacái, madécaná Judea yàasu cáli néeséeyéi, Jerusalén ìyacàlená mìnanái nacái. Néese nacàlidaca náichawa yái báawéerica namàníirica, yá Juan ibautizáca nía Jordán inanába yáaculé. ");
INSERT INTO pioNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Yái Juan idènìaca ibàlewa cáucuíri wáluma camello ichùna iwálumalená. Idènìaca nacái ìwalìabàawa pìrái íimamimi. Iyáa nacái iyáacaléwa wirìichu nacáiyéi, mába ituní nacái Juan yàanèerica manacúali yùucubàa càináwàiri. ");
INSERT INTO pioNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Càité Juan icàlidaca yèepunícawa nalíni: “Mesúnamáita áiba yàanàaca núamirìcubàa, máiníiri cachàinica íiwitáise nuícha. Nuíwacalicani, yái yàanèeripináca; nuicáca núawawa iyúwa yàasu wenàiwica càmíiri cachàini náicha canánama máinícáiná cayábéerica nuíchani. ");
INSERT INTO pioNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Nudéca nubautizácuéca pía úni yáaculé, yáta quéwa ibànuèripinácué pirí Espíritu Santo ibautizácaténácué píiwitáise Espíritu Santo ichàini iyú”, íimaca nalí yái Juanca. ");
INSERT INTO pioNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Néenialíté Jesús yàanàaca Nazaret ìyacàlená néese, ìyéerica Galilea yàasu cáli íinata. Jesús yàanàaca Juan yàatalé. Néese Juan ibautizáca Jesús Jordán inanába yáaculé. ");
INSERT INTO pioNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Idécanáami Jesús imichàacawa úni yáacuíse, yáta iicáca capìraléeri cáli yàacùacawa. Yá iicáca Espíritu Santo iricùacawa ìwali càiride iyúwa unùcu iricùanáwa. ");
INSERT INTO pioNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Yá néemìaca Dios itàacái chènuníise. Dios íimaca Jesús irí: “Píacata Nuìri nuwàwéeri cáininéerica nuicáca. Cayábaca nuwàwa nuicáca pía”, íimaca yái Diosca. ");
INSERT INTO pioNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Yáta Espíritu Santo itéca Jesús manacúali yùuculé càináwàiri. ");
INSERT INTO pioNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Jesús ìyaca néré cuarenta èeri manacúali yùucubàa. Néréca Satanás yáalimáida Jesús imàníinápiná ibáyawanáwa, quéwa càmita Jesús yeebá. Yá Jesús ìyaca cuwèesinái yèewibàa. Angelnái nacái yàacawéeridaca néréni, nayúudàacani. ");
INSERT INTO pioNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Néeseté áibanái wenàiwica náucaca Juan el Bautista presoíyéi ibànalìculé. Néese Jesús yàacawa Galilea yàasu cáli néré. Yá icàlidaca yèepunícawa yái tàacáisi cayábéerica Dios inùmalìcuíse. ");
INSERT INTO pioNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Jesús íimaca: “Idéca yàanàaca yéenáiwaná Dios icùacaténá canánama mesúnamáita. Iná piwènúadacué píiwitáisewa pibáyawaná íichawa, peebáidacué nacái yái tàacáisi cayábéerica”, íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Néese Jesús yèepunícawa Galilea icalìsaniná icàinalená íinatabàa. Yá iicáca pucháiba asìanái. Ibèeri íipidená Simón, iméeréeri íipidená Andrés. Yúuquéeyéi yàasu tarayawa yèepunícawa calìsáacubàa, náibàacáiná cubái needácaténá nalíwa nàasu platawa. ");
INSERT INTO pioNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Yá Jesús íimaca nalí: —‍Aquialécué síisaara, pìacuéwa núapicha yéewacaténá nuéwáidacalénáicuéca pía. Pidécuéca píibàaca cubái pìwacáidacaténácué nía, quéwa siùcáisede nuéwáidapinácué píawa pìwacáidáanápiná nulí wenàiwica yéewanápiná nuéwáidacaléca nía —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Yáta namàacaca náichawa nàasu tarayawa. Yá nàacawa yáapicha. ");
INSERT INTO pioNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Néese nèepunícawa nàacawa àniwa calìsa idùlepiré, yá Jesús iicá nacái Zebedeo yéenibe pucháiba asìanái, íipidenéeyéi Santiago, Juan nacái, ichùnièyéi yàasu chinchorrowa, nàasu barca irìcuwa. ");
INSERT INTO pioNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Jesús iicácanacáita nía, yá imáidaca nía. Yá caquialéta namàacaca náaniriwa barca irìcu, yàasu wenàiwicanái yáapichawa íibaidéeyéica Zebedeo irí. Yá Santiago, Juan nacái nàacawa Jesús yáapicha. ");
INSERT INTO pioNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Yá nàanàaca Capernaum ìyacàlená néré. Néese áiba sábado judíonái iyamáidacatáicawa, yá Jesús iwàlùacawa judíonái yéewáidacàalu irìculé, yá idàbaca yéewáidaca wenàiwica. ");
INSERT INTO pioNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Yá náináidacawa néemìaca yéewáidáaná nía, yéewáidacáiná nía càide iyúwa wenàiwica idènièrica Dios íiwitáise icàlidacaténá tàacáisi Dios inùmalìcuíse. Càmita yéewáida nía càide iyúwa judíonái yéewáidáaná wenàiwica, níái yéewáidéeyéica wenàiwica templo irìcu, Dios itàacái ìwali, profeta Moisés itànèericaté. ");
INSERT INTO pioNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Néese ìyaca nàasu néewáidacàalu irìcu abéeri asìali idènièrica demonio iwàwalìcuwa, abéeri demonio casaquèeri íiwitáise. Yái demonio idacùaca asìali íiwitáise. ");
INSERT INTO pioNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Yáta demonio idàbaca yéemíanícawa asìali isàna iyú. Yá demonio íimaca Jesús irí: —‍¿Cáná pisàiwica walí wawàsi, pía Jesús Nazaret ìyacàlená néeséerica? ¿Pìanàasica pimáalàidacaténá wía? Núalíacawa nuicáca pía, núalíacawa pìwali, Dios néeséeri mabáyawanéerica pía —‍íimaca. ");
INSERT INTO pioNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Quéwa Jesús yàalàaca demonio cachàiníiri iyú. Yá íimaca demonio irí: —‍¡Masànata pía! ¡Pimusúawa íicha yái asìalica! —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Néese demonio casaquèeri íiwitáise itatáidaca asìali cachàiníiri iyú, yá demonio yàacawa asìali íicha, yá demonio íicháaníca yàacawa cachàiníiri iyú. ");
INSERT INTO pioNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Néese macáita ìyéeyéica néré nacalùadacawa manuísíwata, íná nasutáca néemìawa níawáaca, náimaca nalíwáaca: —‍¿Càinásica yái wàlisài yéewáidáanáca? Yéewáidaca wenàiwica, ichùulìaca demonio nacái íiwitáise cachàiníiri iyúwa. Ichùulìaca demonio casaquèeyéica íiwitáise, yá namànica càide iyúwa ichùulìaná nía —‍náimaca nalíwáaca. ");
INSERT INTO pioNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Néese ráunamáita macái Galilea yàasu cáli néeséeyéi náalíacawa Jesús iináwaná ìwali. ");
INSERT INTO pioNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Idécanáamité namusúacawa judíonái yéewáidacàalu irìcuíse, Jesús yàacawa Santiago yáapicha, Juan nacái. Yá nawàlùacawa Simón icapèe irìculé, Andrés ìyacatalé ibèeri Simón yáapichawa. ");
INSERT INTO pioNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Néenialíté Simón iyéeru uculúacawa mecuní iyú. Jesús iwàlùacadénáamiwa nacapèe irìculé, yáta nacàlidaca irí uculúanáwa. ");
INSERT INTO pioNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Néese Jesús yàacawa ùatalé, íibàaca ucáapi, imichàidaca úa, yáta mecuní ichàbacawa uícha. Néese ùaca nayáapiná. ");
INSERT INTO pioNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Néeseté catáca yàacawa, èeri idénáami iwàlùacawa, yáté yàcalé mìnanái natéca macái néenánáiwa cáuláiquéeyéi Jesús yàatalé, áibanái wenàiwica nacái demonio idacuèyéi íiwitáise. ");
INSERT INTO pioNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Yá macáita nàwacáidáyacacawa capìi inùma néeni Jesús ìyacatái. ");
INSERT INTO pioNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Jesús ichùnìacaté madécaná cáuláiquéeyéi macái uláicái íiwitáaná íicha. Jesús yúucaca madécaná demonio wenàiwicanái íicha, càmita quéwa ibatàa demonionái icàlidaca iináwaná ìwali, náalíacáiná naicácani, yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Néese táiyápicáwa, cáala èeri ipíchawáise èeri imusúacawa, yá Jesús imichàacawa, yàacawa imusúacawa yàcalé irìcuíse yàacaténáwa canácatalé wenàiwica. Yá néré isutáca yáawawa Dios íicha. ");
INSERT INTO pioNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Néese Simón yàacawa yàacawéeyéiná yáapichawa nacutáca Jesús. ");
INSERT INTO pioNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Néese nàanàacani, yá náimaca Jesús irí: —‍Macáita nacutáca nàyaca pía —‍náimaca. ");
INSERT INTO pioNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Yá Jesús íimaca nalí: —‍Wàacuéwa áibanái ìyacàle néré ìyéeyéica mawiénibàa nucàlidacaténá nalíni yái tàacáisi cayábéerica. Nudéca nùanàaca nucàlidacaténá nalíni —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Iná Jesús yàacawa macái yàcalé ìyéeyéica Galilea yàasu cáli íinata. Icàlidaca nalíni nàasu néewáidacàalu imanùbaca irìcu. Yá yúucaca demonio wenàiwicanái íicha. ");
INSERT INTO pioNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Néeseté áiba asìali, cacháunéeri íimami lepra iyú, yàacawa Jesús yàatalé. Yá ibàlùacawa yùuluì ipùata iyúwa Jesús irí, yàacaténá Jesús icàaluíniná, yéewacaténá catúulécanáca Jesús iicácani. Yá íimaca Jesús irí: —‍Núalíacawa píalimá pichùnìaca núa, piwàwacaalí quéwa pichùnìaca núa —‍íimaca. ");
INSERT INTO pioNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Yá catúulécanáca Jesús iicáca cáuláiquéeri, yá imàacaca icáapiwa ìwali, yá Jesús íimaca irí: —‍Nuwàwaca nuchùnìaca pía. ¡Cayábaca píawa! —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Yáta icháuná lepra ichàbacawa asìali íicha. Yáta cayábaquéi asìalica. ");
INSERT INTO pioNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Quéwa Jesús ichùulìaca asìali yèepùanápináwa íicha caquialéta. Yá nacái yàalàaca asìali cachàiníiri iyú. ");
INSERT INTO pioNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Jesús íimaca asìali irí: —‍Péemìa cayába. Picá picàlida áibanái iríni nuchùnìaná pía. Néese, pìawa caquialéta píasáida sacerdote iicá píimamiwa, yáalíacaténáwa cayábaca pía picháuná íichawa. Pimàaca nacái ofrenda Dios irí càide iyúwaté profeta Moisés ichùulìaná, cayábacáiná pía, yéewanápiná macái wenàiwica yáalíacawa pidéca pichùnìacawa —‍íimaca Jesús. ");
INSERT INTO pioNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Quéwa yái asìalica idàbaca icàlidaca macái wenàiwica irí Jesús iináwaná ichùnìanáni. Iná càmita quirínama Jesús yéewa iwàlùacawa asáiwaca áiba yàcalé irìculé madécanácáiná wenàiwica nawàwa naicácani. Iná yèepunícawa náicha manacúali yùucubàa càináwàiri canácatalé wenàiwicanái. Quéwa macái yàcalé mìnanái nàacawa yàatalé naicácaténáni. ");
INSERT INTO pioNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Néeseté cawàwanáta máisiba èeri idénáami, yá Jesús yèepùa iwàlùacawa Capernaum ìyacàlená irìculé. Quéwa manùbéeyéi yáalíaca iináwaná ìyaca capìirìcu. ");
INSERT INTO pioNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Yá madécaná wenàiwica ìwacáidáyacacawa yàatalé íná napuníadaca capìi, inùma nérénamata. Yá Jesús icàlidaca nalí Dios itàacái. ");
INSERT INTO pioNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Néese báinúaca asìanái yàanàaca itéeyéica asìali máapinéeri iiná macáita, càmíirica yáalimá imichàanícawa, irièricawa yàalubái íinatawa, iiméeri irìcu. ");
INSERT INTO pioNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Càmita náalimá nawàlùacawa Jesús nérépiná dàalacáiná máiní wenàiwicanái néré, íná náiríacawa escalera ìwalibàa capìi íinatalé, sàabadéeri, canéerica ipùata chènuniré. Néréca nawatàaca capìi ibáiná Jesús iwicáu. Yá nalicùadaca néenibàani, yéenúlusi ìwali, yái máapinéerica iiná yàalubái íinatawa. ");
INSERT INTO pioNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Néese Jesús yáalíacawa náiwitáise manuíca náináidacawa nawàwawa Jesús ìwali ichùnìanápináni, yá Jesús íimaca cáuláiquéeri irí: —‍Pía, nùacawéerináca, nudéca numàacaca nuwàwawa pibáyawaná íicha cayábacaténá píapicha Dios —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","7","Yá abénaméeyéi yéewáidéeyéica wenàiwica templo irìcu nàyaca néré, yáawinéeyéicawa. Yá náináidacawa: “¿Cáná itàaní cài yái asìali Jesúsca? Itàaníca ìyaca Dios ìwali báawéeri iyú, canácáiná asìali yáaliméeri imàacaca iwàwawa wenàiwicanái ibáyawaná íicha cayábacaténá náapicha Dios. Abéericata Dios yáaliméeri imànica càiri wawàsi”, náimaca náináidacawa nalíwa nawàwalìcuísewa. ");
INSERT INTO pioNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Yáta Jesús yáalíacawa náináidáanáwa. Yá íimaca nalí: —‍¿Cánácué yéewa píináidacawa cài? ");
INSERT INTO pioNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Máiní màulenáca wáimaca máapinéeri irí: ‘Nudéca numàacaca nuwàwawa pibáyawaná íicha cayábacaténá píapicha Dios’, càmicáiná áibanái yáalimá iicáca asáisí báisícaalí cayábaca yáapicha Dios. Quéwa máiní càulenáca wáimaca máapinéeri irí: ‘Pimichàawa, pìipìna’, áibanái wenàiwica náalimácáiná naicáca asáisí wadécaalí wachùnìacani watàacái iyúwa, yái máapinéerica. ");
INSERT INTO pioNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Iná núa, asìali Dios néeséerica, nuchùnìapiná yái máapinéerica, píalíacaténácuéwa Dios idéca ichùulìaca numàacáanápiná nuwàwawa wenàiwicanái ibáyawaná íicha chái èeri irìcu, cayábacaténá náapicha Dios —‍íimaca yái Jesúsca. Néese íimaca máapinéeri irí: ");
INSERT INTO pioNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","—‍Pía asìalica, pimichàawa, peedá pìalubáiwa, pèepùawa picapèe néréwa —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Néese yái cáuláiquéerica imichàacawa. Yá itéca yàalubáiwa. Imusúacawa náicha idècunitàacá naicáidaca irí. Iná macáita náináidacawa naicáidaca manuísíwata Jesús irí. Nàaca nacái Dios irí cayábéeri. Yá náimaca nalíwáaca: —‍¡Canácataté waiquéeri càiri wawàsica! —‍náimaca nalíwáaca. ");
INSERT INTO pioNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Néeseté Jesús yàacawa àniwa Galilea icalìsaniná idùlepiré. Yá wenàiwicanái nàacawa yàatalé. Néese yéewáidaca nía. ");
INSERT INTO pioNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Néesecáwa idècunitàacá yèepunícawa àniwa, yá iicáca Leví, yái Alfeo ìirica. Yái Leví yáawinéericawa aléera yeedácatalécaté plata yéenánái judío íichawa romanonái yàasu gobierno irípiná. Yá Jesús íimaca irí: —‍Aquialé. Pìawa núapicha, yéewacaténá nuéwáidacaléca pía —‍íimaca yái Jesúsca. Yá Leví imichàa yàacawa Jesús yáapicha. ");
INSERT INTO pioNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Néese Jesús iyáaca iyáacaléwa Leví icapèe irìcu. Nàyaca néré nacái mesa iwéré manùbéeyéi wenàiwica yeedéeyéica plata néenánái judío íichawa romanonái yàasu gobierno irípiná, manùbéeyéi nacái cabáyawanéeyéica wenàiwica. Macáita nayáaca nayáacaléwa Jesús yáapicha, yéewáidacalénái yáapicha nacái, madécanácáiná wenàiwica nèepunícawa Jesús yáapicha. ");
INSERT INTO pioNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Néese abénaméeyéi fariseo, áibanái nacái yéewáidéeyéica wenàiwica templo irìcu, naicáca Jesús iyáaca iyáacaléwa náapicha níái macáita cabáyawanéeyéica wenàiwicaca. Néese náimaca Jesús yéewáidacalénái irí: —‍Yái yéewáidéericuéca pía, ¿cáná iyáa iyáacaléwa náapicha níái cabáyawanéeyéica wenàiwicaca, náapicha nacái níái yeedéeyéica wáicha plata romanonái yàasu gobierno irípiná? —‍náimaca. ");
INSERT INTO pioNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Quéwa Jesús yéemìacani, yá íimaca fariseonái irí: —‍Péemìacué comparación: Máuláicacaalí wenàiwica, yá càmita nawàwacutá abéeri ichùnièripiná nía. Quéwa áibanái cáuláiquéeyéi nawàwacutácani, yái ichùnièripináca nía. Càita nacái wenàiwica íináidéeyéica mabáyawanáca, càmita nacutá abéeri ichùnièripiná náiwitáise nabáyawaná íichawa. Quéwa áibanái wenàiwica yáaliéyéicawa cabáyawanáca, níata icutáca abéeri iwènúadéeripiná náiwitáise báawéeri íicha. Càita nacái núa, càmita nùanàa numáidacaténá wenàiwica íináidéeyéica mabáyawanáca, néese nudéca nùanàaca numáidacaténá wenàiwica yáaliéyéicawa cabáyawanáca, nawènúadáanápiná náiwitáisewa nabáyawaná íichawa. Iná cayábaca nàwacáidáyacacawa nùatalé níái cabáyawanéeyéica nuwènúadacaténá náiwitáise nabáyawaná íichawa —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Aiba èeri càide iyúwaté náiwitáise ìyáaná, Juan el Bautista yéewáidacalénái, nía nacái fariseoca namàacacaté náichawa nayáacaléwa nasutácaténá níawawa Dios íicha manuísíwata. Néese wenàiwicanái nàacawa Jesús yàatalé. Yá náimaca irí: —‍Juan yéewáidacalénái namàacaca náichawa nayáacaléwa càide iyúwa náiwitáise ìyáaná nasutácaténá níawawa Dios íicha manuísíwata, càita nacái fariseonái namànica càita. Néeni, ¿cáná càmita péewáidacalénái namàaca náichawa nayáacaléwa nasutácaténá níawawa Dios íicha? —‍náimaca. ");
INSERT INTO pioNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Jesús íimaca nalí: —‍Péemìacué comparación: Asìali icásàacaalíwa, yá imáidaca yàacawéeyéináwa asìanái naicácaténá icásàacawa casíimáiri iyú. Idècunitàacá ìyaca náapicha, yá casíimáica nía, íná càmita namàaca náichawa nayáacaléwa. ");
INSERT INTO pioNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Quéwa áibaalípiná, áibanái itéca náichawani. Idécanáami natéca náichawani, yásí namàaca náichawa nayáacaléwa, achúmacáiná nawàwa. Càita nacái nuéwáidacalénáica, càmita yéewa achúmaca nawàwa idècunitàacá nùyaca náapicha. Iná càmita namàaca náichawa nayáacaléwa, nùyacáiná náapicha. ");
INSERT INTO pioNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Péemìacué áiba comparación: Càmita wadé wachanàidaca éwisàimi wabàlewa wàlisài wáluma yéemami iyú. Wachanàidacaalí cài, yásí wàlisài wáluma yéemami imàacacawa, yá icacanáidaca éwisàimi bàlesi, yá quéwanáta manuíca icháuná. ");
INSERT INTO pioNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Péemìacué áiba comparación: Càmita wadé wàucùaca wàlisài uva ituní éwisàimi íimamisi irìculé. Wamànicaalí cài, néese uva ituní isáacawa dàchidàchiwaca inànìacubàa, yásí éwisàimi íimamisi icacanácawa, càmicáiná yáalimá imulacàacawa yàacawa. Yásí yúucacawa wáicha macáita uva ituníca, íimamisi nacái. Iná iwàwacutá wàucùaca wàlisài uva ituní wàlisài íimamisi irìculé. Càita nacái nuéwáidacalénái yeebáidéeyéica nutàacái wàlisài, càmita nàya fariseonái yàasu bàaluisàimi tàacáisi ìwali —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Aiba sábado judíonái iyamáidacatáicawa Jesús yèepunícawa àyapulìcubàa yéewáidacalénái yáapichawa bànacalé yèewibàa. Néese yéewáidacalénái nadàbaca needáca achúmáanata trigo ituíná nayáapináwa, yácáiná judío íiwitáise imàacaca wenàiwica needáca nayáapináwani achúmáanata ìyacaná áibanái ibànacale yéená, máapicaalí nía. ");
INSERT INTO pioNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Néese abénaméeyéi fariseo naicácani iyúwa íibaidacalési, yái Jesús yéewáidacalénái imàníirica, íná fariseonái íimaca Jesús irí: —‍Péemìa, ¿cáná péewáidacalénái íibaida siùca sábado wayamáidacatáicawa? Dios càmita imàaca wáibaidaca siùca èeri —‍náimaca. ");
INSERT INTO pioNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Yá Jesús íimaca fariseonái irí: —‍Pidécuéca piimáichaca tàacáisi piléericuéca Dios itàacái irìcuíse wàawirimi rey David ìwali. Bàaluité David iwàwacutáca yàacàsi, máapicáináni, áibanái nacái asìanái ìyéeyéica yáapicha. ");
INSERT INTO pioNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Abiatar yàasu èerité, yái sacerdote íiwacalináca, néese David iwàlùacatéwa Dios yàasu manuíri capìima íimamisíiri mabáyawanéeri irìculé, israelitanái isutácatáipiná Dios íicha. Yá David iyáaca pan namàníiricaté Dios irí ofrenda piná sacerdotenái iyáapiná. Dios itàacái imàacacaté níawamita sacerdotenái iyáaca yái panca. Davidta quéwa iyáacani. Yàaca nacái yáapichéeyéi iríwa nayáacaténá nacái. Dios càmita yùuwichàida nía, máapicáiná nía, íná catúulécanáca Dios iicáca nía —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Jesús íimaca fariseonái irí nacái: —‍Dios idéca imàacaca walí yái èeri sábado wayamáidacatáicawa iyúudàacaténá wenàiwicanái, catúulécanácáiná Dios iicáca wenàiwica. Dios càmíiritaté idàba wenàiwica sábado irípiná. ");
INSERT INTO pioNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Iná Dios idéca ichùulìaca núa, asìali Dios néeséerica, numàacáanápiná nùasu wenàiwica namànica càide iyúwa nuwàwáaná èeri imanùbaca, yái èeri sábado nacái wayamáidacatáicawa, wía judíoca —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Néese àniwa Jesús iwàlùacawa judíonái yàasu yéewáidacàalu irìculé. Iyaca néeni abéeri asìali icáapi ituwièricawa íicha. ");
INSERT INTO pioNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Abénaméeyéi fariseo naicáidaca Jesús irí naicácaténá asáisí Jesús ichùnìacaalípináté asìali sábado irìcu nayamáidacatáicawa, yéewanápiná nacháawàaca Jesús iináwaná ìwali, ìwalíise yái imàníináca sábado irìcu Dios ichùulìacáináté judíonái iyamáidacawa macái sábado imanùbaca. Néese fariseonái náimacaté íibaidacalésicani yái Jesús ichùnìanáca wenàiwicanái. ");
INSERT INTO pioNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Néese Jesús íimaca irí yái asìalica icáapi ituwièricawa íicha: —‍Pimichàawa, pibàlùawa nàacuésemi —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Idécanáami asìali ibàlùacawa, yá Jesús isutáca yéemìawa fariseonái: —‍Siùcata nusutácué nuémìawa pía: ¿Càinásica Dios imàaca wamànica siùca èeri sábado wayamáidacatáicawa? ¿Imàacasica wamànica cayábéeri, càmicaalí nacái báawéerisica? ¿Imàacasica wacáucàidaca wenàiwica, wamàacasica néetácawa? —‍íimaca yái Jesúsca. Quéwa masànata nía Jesús íicha. ");
INSERT INTO pioNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Iná Jesús iicáidaca nalí, níái ìyéeyéica itéesebàa. Máiní maséeca íináidacawa iwàwawa, yái Jesúsca, báawacáiná iicáca náiwitáise. Achúmaca iwàwa nacái càmicáiná fariseonái iwàwa yeebáidaca itàacái. Yá Jesús íimaca asìali irí: —‍Piducúa picáapiwa —‍íimaca yái Jesúsca. Yá asìali iducúaca icáapiwa, yáta cayábaca icáapi. ");
INSERT INTO pioNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Quéwa fariseonái namusúacanacáitawa judíonái yéewáidacàalu íicha, yá nàacawa caquialéta nàwacáidáyacacawa áibanái judío yáapicha, cayábéeyéi iicáca rey Herodes, yái romanosàiri icuèrica Galilea yàasu cáli. Yá natàaníca náapicha càinápinácaalí iyú náalimáaná nanúaca Jesús. ");
INSERT INTO pioNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Néeseté Jesús yàacawa náicha yéewáidacalénái yáapichawa Galilea icalìsaniná idùlepiré. Yá manùba wenàiwica Galilea yàasu cáli néeséeyéi nàacawa Jesús yáamiwáise. ");
INSERT INTO pioNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Aibanái néemìacáiná iináwaná imàníiná madécaná yái càmíirica wenàiwica idé imànica, yá nàacawa Jesús yàatalé nacái naicácaténáni. Manùbéeyéi Judea yàasu cáli néeséeyéi yàacawa, Jerusalén ìyacàlená néeséeyéi nacái, Idumea yàasu cáli néeséeyéi nacái, áiba cáli néeséeyéi nacái ìyéerica abéemàise Jordán inanába íicha, Tiro ìyacàlená néeséeyéi nacái, Sidón ìyacàlená néeséeyéi nacái, nía nacái yàcalé ìyéeyéica natéesebàa. ");
INSERT INTO pioNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Manùbacáiná wenàiwica néré, íná Jesús ichùulìaca yéewáidacalénáiwa icùanápiná barca yàacaténáwa úni yáacubàa wenàiwicanái íicha déecuísetatá calìsa icàinalená íicha, ipíchaná wenàiwicanái iwesíaca iwéré. ");
INSERT INTO pioNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Iwàwacutá cài imànica ichùnìacáináté manùba wenàiwica, íná madécaná cáuláiquéeyéi nawesíaca Jesús iwéré, namàacacaténá nacáapiwa ìwali, yéewacaténá nachùnìacawa. ");
INSERT INTO pioNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Demonionái naicácaté Jesús, yá namàacaca wenàiwica demonio idacuèyéica íiwitáise nabàlùacawa nàuluì ipùata iyúwa Jesús irí nàacaténá icàaluíniná. Yá demonionái náimaca cachàiníiri iyú Jesús irí: —‍¡Píacata yái Dios Iirica! —‍náimaca irí. ");
INSERT INTO pioNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Quéwa Jesús yàalàaca demonionái cachàiníiri iyú, ipíchaná nacàlidaca cawinácaalíni. ");
INSERT INTO pioNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Néeseté Jesús yàacawa dúli íinatalé, yá imáidaca yàataléwa yéewáidacalénáiwa cayábéeyéi Jesús iicáca íiwitáise. Néese nàanàaca yàatalé. ");
INSERT INTO pioNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Néese Jesús yeedáca néená doce namanùbaca nàacaténáwa yáapicha, yéewacaténá nacái ibànùaca nía nacàlidáanápiná Dios itàacái. Yàaca náipidenápiná apóstolnái. ");
INSERT INTO pioNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Imàaca nacái nalí íiwitáisewa náucacaténá demonio wenàiwicanái íicha. ");
INSERT INTO pioNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Níái docéeyéica imanùbaca íipidenéeyéica cài: Simón, yái asìali Jesús yàaca íipidenápiná wàlisài, Pedro. ");
INSERT INTO pioNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Nía nacái Zebedeo yéenibe pucháiba, ibèeri íipidená Santiago, iméeréeri nacái íipidená Juan. Jesús yàaca wàlisài náipidenápiná Boanerges (íimáanáca “Caluéyéi íiwitáise càide iyúwa énu isàna”, cài íimáanáca). ");
INSERT INTO pioNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","19","Andrés nacái, Felipe nacái, Bartolomé nacái, yá nacái Mateo, Tomás nacái, Santiago nacái, yái Alfeo ìirica, Tadeo nacái, yá nacái Simón, áibaalí íipidenéeri nacái celote, yá nacái Judas Iscariote, yái itéeripinácaté Jesús yùuwidenái náibàacaténáni, nanúawani. ");
INSERT INTO pioNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Néese Jesús iwàlùacawa capìi irìculé yéewáidacalénái yáapichawa. Néese àniwa madécaná wenàiwica nàwacáidáyacacawa néré, yá dàalaca wenàiwica capìi irìcu, íná càmita náalimá nayáaca nayáacaléwa, yái Jesús, nía nacái yéewáidacaléca. ");
INSERT INTO pioNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Néese Jesús yéenánái yéemìaca iináwaná ìwali, yá nàacawa Jesús yàatalé needácaténá náichani, náimacáiná ìwali máiwitáisecasani, yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Nàyaca néré nacái abénaméeyéi yéewáidéeyéica wenàiwica templo irìcu, yàanèeyéicaté Jerusalén ìyacàlená néese. Yá náimaca Jesús ìwali: “Beelzebúca, yái demonio íiwacalináca, yáquéi idacùaca íiwitáise yái asìalica Jesús. Iná yéewa Jesús yúucaca demonio wenàiwica íicha Beelzebú íiwitáise iyú”, náimaca Jesús ìwali. ");
INSERT INTO pioNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Iná Jesús imáidaca yàataléwa nía. Yá icàlidaca nalí comparación yéewáidacaténá nía. Iimaca nalí: “Satanás canácatáita iwàwa yúucaca yàasu demonionáiwa wenàiwica íicha. ");
INSERT INTO pioNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Càide iyúwa wenàiwicanái ìyáaná, napéliacaalí náipunitawáaca, yásí nàasu cáli imáalàacawa. ");
INSERT INTO pioNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Néese àniwa áibanái néenánái napéliacaalí náipunitawáaca, néese càmita náalimá nàyaca abéeri capìi irìcu. ");
INSERT INTO pioNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Càita nacái, Satanás yàasu demonionái napéliacaalí náipunitawáacatá, néese càmita yáalimá cachàini quirínamatáni, yái Satanásca. Yá imáalàacawa ichàinicatá. Iná iwàwacutácué píalíacawa càmita núuca demonio wenàiwica íicha Satanás íiwitáise iyú. ");
INSERT INTO pioNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Nudé quéwa núucaca demonio wenàiwica íicha nuíwitáise iyúwa, cachàinicáiná núa Satanás íicha. Péemìacué comparación: Càide iyúwa cayéedéeri imàníiná, càmita cayéedéeri yáalimá iwàlùacawa irìculé áiba cachàiníiri asìali icapèeca iyéedùacaténá íicha yàasu, càmicaalícáwa cayéedéeri idacùaca íichawa yái cachàiníiri asìalica quéechacáwa. Iwàwacutá cayéedéeri cài imànica, yéewacaténá iyéedùaca cachàiníiri asìali yàasu. Càita nacái núalimá nudacùaca nuíchawa Satanás nuwasàacaténá wenàiwica Satanás íicha. Pidécuéca pitàaníca báawéeri iyú Espíritu Santo ìwali. ");
INSERT INTO pioNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Péemìacué cayába, Dios imàacapiná iwàwawa íichéi macái íiwitáaná báawéerica wenàiwica imàníirica, itàaníirica nacái Dios ìwali, nawènúadacaalí náiwitáisewa nabáyawaná íichawa. ");
INSERT INTO pioNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Quéwa wenàiwica itàanícaalí báawéeri iyú Espíritu Santo ìwali, yá canácatáita Dios imàaca iwàwawa ibáyawaná íicha, néese cabáyawanáca càiripinátani èeri càmíiri imáalàawa”, íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Càita Jesús íimaca nalí níái yéewáidéeyéica wenàiwica templo irìcu, náimacáináté Jesús ìwali demoniosa idacùaca íiwitáise. ");
INSERT INTO pioNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Néeseté Jesús yáatúa yàanàaca yàatalé, yéenánái nacái. Quéwa nabàlùacawa bàacháwáise capìi íicha. Yá nachùulìaca áiba imáidacaténá Jesús. ");
INSERT INTO pioNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Néese áibanái yáawinéeyéiwa mawiénita Jesús irí náimaca irí: —‍Píatúa, péenánái nacái, péenánái inanái nacái nabàlùacawa bàacháwáise. Nawàwacutáca pía —‍náimaca. ");
INSERT INTO pioNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Néese Jesús íimaca nalí ìyéeyéica itéesebàa: —‍Péemìacué yái núumáanáca núatúa ìwaliwa, nuénánái ìwali nacáiwa —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Néese Jesús iicáidaca nalí níái yéewáidacaléca yáawinéeyéicawa itéese. Yá íimaca: —‍Piicácué, níái wenàiwicaca nuicáca nía càiyéide iyúwa núatúanáiwa, nuénánái nacáiwa. ");
INSERT INTO pioNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Cawinácaalí wenàiwica imàníirica càide iyúwa Dios iwàwáaná, yácata nuiquéeri càiride iyúwa nuénásàiriwa, nuénásàatúa nacáiwa, núatúa nacáiwa —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Jesús idàbaca yéewáidaca wenàiwica àniwa Galilea icalìsaniná idùlepiré. Idècunitàacá yéewáidaca nía, yá manùbéeyéi wenàiwica nàwacáidáyacacawa Jesús itéese. Iná Jesús iwàlùacawa barca irìculé ìyéechúa calìsa yáacu. Yá yáawinacawa yéewáidacaténá wenàiwica iyaméeyéicawa calìsa icàinalená íinata. ");
INSERT INTO pioNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Néese idàbaca yéewáidaca nía madécaná wawàsi ìwali. Icàlidaca nalí comparación yéewáidacaténá nía. Iimaca nalí: ");
INSERT INTO pioNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Péemìacué comparación: Abéeri asìali ibànacaté yàacawa ituínási. Yá yàacawa càide iyúwa náiwitáise nabànáaná ituínási, yàaca icasáaca yàacawa bànacalé. ");
INSERT INTO pioNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Iná yàaca icasáaca yàacawani, yá abénaméeyéi ituínási yúuwàacawa àyapulìcubàa, yá màsibèenái yàanàaca néré, yá nayáaca bànacalé íimi. ");
INSERT INTO pioNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Aiba ituínási yéená yúuwàacawa cáli íinata íba yèewiré, canácatáica cayába cáli ibaníiri. Yá bànacalé íimi ibacácawa ráunamáita, càmicáiná ibaní néeni cáli. ");
INSERT INTO pioNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Néese quéwa èeri yàacáináwa chènuniré mamáalàacata, yá yeemáca púubéeyéi bànacalé, néese chuìca nía, canácáiná napìchu cayába cáaléeri, íná néetácawa. ");
INSERT INTO pioNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Aiba ituínási yéená yúuwàacawa tuíri yèewiré. Néese tuíri idàwinàacawa dàalawaca bànacalé yèewibàa, íná yái bànacaléca càmita idàwinàawa cayába, canáca nacái bànacalé ìyacaná. ");
INSERT INTO pioNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Aiba ituínási yéená yúuwàacawa cayábéeri cáli íinata. Yá idàwinàacawa cayába, idènìaca nacái ìyacanáwa manùba. Abénaméeyéi yéetaná idènìaca ìyacanáwa treinta namanùbaca. Abénaméeyéi yéetaná idènìaca ìyacanáwa sesenta namanùbaca. Abénaméeyéi yéetaná idènìaca cien namanùbaca ìyacaná”, íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Jesús íimaca nacái: “Càuwíiyéicaalícué pía, péemìacué nutàacái”, íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Néesetécáwa Jesús ìyaca abéerita, yá níái yáapichéeyéica, nía nacái doce namanùbaca yéewáidacaléca nasutáca néemìawani càinácaalí íimáaná yái comparaciónca. ");
INSERT INTO pioNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Yá Jesús íimaca nalí: “Dios imàacacué píalíacawa càinácaalí iyú Dios icùaca yàasu wenàiwicawa. Càmita imàaca áibanái yáalíacawa. Néese áibanái càmíiyéica yeebáida Dios itàacái, nucàlidaca nalíni yáawami comparación iyú, ipíchaná náalía néemìaca càinácaalí íimáaná. ");
INSERT INTO pioNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Iná éwita naicácáaníta yái numàníirica, càicáaníta càmita náalíawa ìwali càinácaalí íimáaná. Ewita néemìacáaníta nutàacái, càicáaníta càmita náalíawa néemìaca càinácaalí íimáaná. Iná càmita nawènúada náiwitáisewa Dios irípiná yéewanápiná Dios imàacaca iwàwawa nabáyawaná íicha”, íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Jesús íimacaté nalí: “¿Cánásicué càmita píalía péemìaca càinácaalí íimáaná yái comparaciónca? Càmicaalícué píalíawa péemìacani, yásí càulenápinácuéca píichawa macáita comparación nucàlidéeripinácué piríwa. ");
INSERT INTO pioNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Yá íimáanáquéera yái comparaciónca: Yái yèerica icasáaca yàacawa ituínási íimáanáca càicanide iyúwa wenàiwica icàlidacaalí Dios itàacái áibanái irí. ");
INSERT INTO pioNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Abénaméeyéi wenàiwica càica níade iyúwa ituínási yúuwèericawa àyapulìcubàa: Néemìaca Dios itàacái, quéwa idécanáami néemìacani, yá Satanás yàanàacàatécata imàacaca naimáichaca Dios itàacái ibànacanéerimica nawàwalìculé. ");
INSERT INTO pioNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Aibanái wenàiwica, càica níade iyúwa ituínási yúuwèericawa íba yèewiré: Néemìaca Dios itàacái, yá neebáidaca casíimáiri iyúni. ");
INSERT INTO pioNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Néese quéwa, càmicáiná neebáida Dios itàacái tài íiméeri iyú, macái nachàini iyúwa, càide iyúwa canácaalí bànacalé ipìchu cayába, íná neebáidaca Dios itàacái maléená èeri meedá, càide iyúwa bànacalé yéetácaalíwa ráunamáita. Iná idàbacaalí áibanái yùuwichàidaca nía Dios ìwalíise, neebáidacáiná itàacái, Satanás nacái yáalimáidacaalí nía namàníinápiná nabáyawanáwa, yásí naméyáacawa neebáidaca Dios itàacái. ");
INSERT INTO pioNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Aibanái wenàiwica, càica níade iyúwa ituínási ibànacanéerimica tuíri yèewiré; néemìaca Dios itàacái. ");
INSERT INTO pioNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Quéwa báawaca náináidacawa nawàwawa báawanama abéerita nàasu cawèníiri ìwaliwa, yái èeri irìcuírica wawàsi meedá. Cáinináca naicáca cawèníiri, yái ichìwáidéerica wenàiwica. Nawàwa nacái needáca nalíwa macái cawèníiri nàasupináwa. Iná náináidacáináwa ìwali macáita yái cawèníirica, yá naimáichaca Dios itàacái. Càide iyúwa tuíri càmicaalí ibatàa bànacalé idènìaca ìyacanáwa, càita nacái níái wenàiwicaca. Náináidacawa nawàwawa báawanama nàasu cawèníiri ìwaliwa, íná càmita namàni cayábéeri càide iyúwa Dios iwàwáaná. ");
INSERT INTO pioNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Quéwa áibanái wenàiwica, càica níade iyúwa ituínási ibànacanéerimica cayábéeri cáli irìculé. Néemìaca Dios itàacái, yá neebáidacani, yá namànica cayábéeri manuísíwata càide iyúwa bànacalé idènìacaalí ìyacanáwa manùba. Abénaméeyéi namànica cayábéeri càide iyúwa bànacalé idènìacaalí ìyacanáwa treinta namanùbaca macái yéetaná imanùbaca. Aibanái namànica cayábéeri manuísíwata náicha càide iyúwa bànacalé idènìacaalí ìyacanáwa sesenta namanùbaca macái yéetaná imanùbaca. Aibanái nacái namànica cayábéeri náicha mamáalàacata càide iyúwa bànacalé idènìacaalí ìyacanáwa cien namanùbaca macái yéetaná imanùbaca”, íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Jesús íimacaté nalí nacái: “Péemìacué comparación: Càmita watùcunìa lámpara watécaténáni capìi irìculé wabàacaténáni yàalusi irìculé, càmita nacái wabàa lámpara wàasu cama yáapiréwa yái waiméerica íinata. Càmita cài wamàni. Néese watéca lámpara capìi irìculé, yá wamàacaca chènunibàani, icànacaténá capìi irìcuíyéi ìwali. ");
INSERT INTO pioNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Yái lámparaca íimáanáca càicanide iyúwacué pìyáaná, píacué nuéwáidacaléca. Dios iwàwacué péewáidaca wenàiwica Dios itàacái iyú, yái tàacáisi ibàacanéeri píaliéricuécawa ìwali, càide iyúwa lámpara icànacaalí wenàiwica ìwali, naicácaténá cayába. Dios iwàwa náalíacawa ìwali macáita yái tàacáisi càmíiricáwa náalíawa ìwali. ");
INSERT INTO pioNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Càuwíiyéicaalícué pía, yá péemìacué nutàacái”, íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Jesús íimaca nalí nacái: “Píináidacuéwa cayába ìwali yái nucàlidéericuéca pirí. Cayábacaalícué píináidawa nutàacái ìwali, yásí Dios imàacacué píalíacawa cayába ìwali, yái núuméericuéca pirí. Yá imàacapinácué píalíacawa áiba wawàsi ìwali mamáalàacata. ");
INSERT INTO pioNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Wenàiwicacáiná íináidacaalíwa cayába nutàacái ìwali, yá nacái yáalíacaalí yéemìaca càinácaalí íimáaná, yásí Dios imàacaca yáalíacawa áiba wawàsi ìwali mamáalàacata. Quéwa áibacaalí wenàiwica càmita íináidawa cayába nutàacái ìwali, yá iimáichapiná nacái càinácaalí achúméeri wawàsi yáaliéricatéwa ìwali”, íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Néeseté Jesús yéewáidaca nía comparación iyú àniwa. Iimaca nalí: “Yái Dios icùanáca yàasu wenàiwicawa càicanide iyúwa asìali ibànacaalí ituínási cáli yèewiré. ");
INSERT INTO pioNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Idécanáami ibànaca ibànacalewa, yá yàacawa icapèe néréwa iimácaténá. Eeri imanùbaca icawàacawa. Catá imanùbaca iimáca. Canácata imàníiri ituínási irí, quéwa yái ituínási ibacácawa, néese bànacalé idàwinàacawa cayába, éwita asìali càmicáaníta yáalíawa càinácaalí iyú ibànacale idàwinàanáwa. ");
INSERT INTO pioNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Càita cáli imànica yàasu wawàsitawa meedá: Quéechacáwa cáli imàacaca ituínási ibacácawa, néese cabáinácani yái bànacaléca, néese capùutunácani, néese càyacanácani. ");
INSERT INTO pioNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Néese quéwa míisicaalíni, yá asìali yeedáca ìyacaná, yácáiná ibànacale ìyacaná yàasu èeri idéca yàanàaca”, íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Jesús íimacaté nalí nacái: “Siùcade nucàlidacué pirí càinácaalí iyú Dios icùaca yàasu wenàiwicawa. Nuéwáidacué pía comparación iyú. ");
INSERT INTO pioNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Yái Dios icùanáca yàasu wenàiwicawa càicanide iyúwa mostaza íimi wenàiwica ibànéerica cáli yèewiré. Yái mostaza íimica máiní achúméeríinacani. ");
INSERT INTO pioNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Ewita achúméeríinacáanítani yái mostaza íimica, càicáaníta idécanáami nabànacani, yásí idàwinàacawa manuíripiná náicha canánama bànacaléca. Idènìaca yàanawa manuínaméeyéi, yásí màsibèe náalimá namànica namùlubèwa catámàacatalé”, íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Càité Jesús yéewáidaca wenàiwica Dios ìwali manùba comparación iyú càide iyúwa yái tàacáisica. Yéewáidaca wenàiwica càide iyúwa náalimáaná néemìaca. ");
INSERT INTO pioNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Jesús yéewáidaca wenàiwica comparación yáawami iyúta. Néeseta idècunitàacá ìyaca abéerita yéewáidacalénái yáapichawa, yá icàlidaca nalí macáita càinácaalí náimáaná níái comparaciónca canánama. ");
INSERT INTO pioNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Yáté èerica catácáiná yàacawa, íná Jesús íimaca yéewáidacalénái iríwa: —‍Wachàbacuéwa abéemàalé Galilea icalìsaniná íicha —‍íimaca nalí. ");
INSERT INTO pioNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Néese yéewáidacalénái nàacawa manùbéeyéi wenàiwica íicha. Nawàlùacawa barca irìculé, natéca Jesús yáawinacawa náapicha barca irìcu. Aibanái wenàiwica nàacawa náamiwáise barca irìcu, máisibáwanáita quéwa barcaca. Néesecáwa Jesús iimáca íichawa. ");
INSERT INTO pioNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Néese manuíri cáuli ipùaca nàwali. Máiníiri cachàinica yái cáulica. Màladàca nacái yúuwàacawa barca irìculé, yá úni ipuníadaca yàacawa barca. ");
INSERT INTO pioNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Jesús iimácáita quéwanáta. Abéeri íimamisi irìacawa barca yàapùa néese, Jesús irièri yàacawa íinata. Néese nacawàidacani, náimaca irí: —‍¡Wáiwacali! ¿Cáná pimàaca wasawíacawa? —‍náimaca Jesús irí. ");
INSERT INTO pioNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Yá Jesús imichàacawa, yàalàaca cáuli cachàiníiri iyú, yá íimaca nacái màladàca irí: —‍¡Wiú pía! —‍íimaca yái Jesúsca. Yáta wiúca yái cáulica, màladàca nacái. ");
INSERT INTO pioNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Néese Jesús íimaca yéewáidacalénái iríwa: —‍¿Cánácué máiní cáaluca pía? ¿Cánácué càmita manuí píináidacawa piwàwawa nùwali? —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Máiní cáaluca nía. Yá náimaca nalíwáaca: —‍¿Cawinásica yái asìalica ichùulièrica cáuli, màladàca nacái, yásí neebáidaca càide iyúwa ichùulìaná nía? —‍náimaca nalíwáaca. ");
INSERT INTO pioNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Néeseté nàanàaca abéemàalé Galilea icalìsaniná íicha, Gerasa yàasu cáli néré. ");
INSERT INTO pioNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Néese idècunitàacá Jesús imichàacawa barca irìcuíse cáli íinatalépiná, yáta asìali yàanàaca Jesús yàatalé, abéeri asìali demonio idacuèri íiwitáise. Yái asìali yàacawa yéetáními icàliculèená néese. ");
INSERT INTO pioNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Yái asìali ìyacaté yéetáními icàliculèená yèewi. Canácata yáaliméeri idacùacani, ibatàa cadena iyú piná, càmita náalimá. ");
INSERT INTO pioNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Ewitaté yàcalé mìnanái nadacùacáanítani madécaná yàawiría, yàabàli, icáapi nacái cadena iyú, càicáaníta macái èerita imàdáidacaté íichawa cadena, yá nacái iwaaléminamata imànica cadena. Iná canácata yáaliméeri idacùacani, canásíwata. ");
INSERT INTO pioNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Yái asìali yèepunícawa yéemíanícawa táiyápinama, èeríapinama nacái yéetáními icàliculèená yèewiré, dúli yèewiré nacái. Yá inúadáidaca yáawawa íba iyú. ");
INSERT INTO pioNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Quéwa iicácáiná Jesús déecuíse, yá ipìacawa Jesús yàatalé. Ibàlùacawa yùuluì ipùata iyúwa Jesús irí yàacaténá Jesús icàaluíniná. ");
INSERT INTO pioNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Yá demonio yéemíanícawa asìali isàna iyú. Iimaca Jesús irí: —‍¡Picá pisàiwica nulí wawàsi, Jesús Dios Iirica yái Dios chènuníiséeri náicha canánama. Nusutáca píicha wawàsi Dios íipidená ìwali picá piùwichàida núa! —‍íimaca yái demonioca. ");
INSERT INTO pioNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Cài demonio íimaca, Jesús íimacáináté irí: —‍Pía, demonio casaquèeri íiwitáiseca, pìawa asìali íicha —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Néese Jesús íimaca demonio irí: —‍¿Cawiná píipidená? —‍íimaca yái Jesúsca. Yá demonio íimaca Jesús irí: —‍Nuípidená Legión, íimáanáca “Cawàwanáta cinco mil namanùbaca”, máinícáiná madécanáca wía —‍íimaca yái demonioca. ");
INSERT INTO pioNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Néese demonionái isutáca Jesús íicha wawàsi manuísíwata ipíchaná ibànùaca nía méetàuculé íicha yái cálica. ");
INSERT INTO pioNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Mawiénita nalí dúli ìwali madécaná marranonái yèepuníwa. Nayáaca nèepunícawa nayáacaléwa. ");
INSERT INTO pioNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Iná demonionái nasutáca Jesús íicha wawàsi manuísíwata: —‍Pichùulìacaténá wàanápináwa marranonái yàatalé, yá pimàaca wawàlùacawa marranonái idèerìculé —‍náimaca. ");
INSERT INTO pioNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Càita Jesús imàacaca nàacawa. Yá demonionái yàacawa asìali íicha. Yá nawàlùacawa marranonái idèerìculé. Níái marranonái dos mil namanùbaca cawàwanáta. Napìacawa máiwitáisewaca demonio íiwitáise iyú, àta nacaláacatalétawa quìratàli íinatáise calìsa yáaculé, yá nàisicùmacawa macáita, níái pìráica càmíiyéica Dios imàaca judíonái idènìaca, casacàacáiná nalí marrano iiná. ");
INSERT INTO pioNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Néese níái icuèyéicaté marranonáimi napìacawa, yá nàaca nacàlidaca marrano iináwanámi manuíri yàcalé irìcu, yàcalé púubéeyéi irìcu nacái ìyéeyéica mawiénibàa. Iná madécaná wenàiwica nàacawa néré naicácaténá càinácaalí ìyáaná. ");
INSERT INTO pioNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Néese nàanàaca Jesús yàatalé. Yá naicáca yái asìali madécanéeyéi demonio idacuèricaté íiwitáise. Yáawinéericawa ìyaca, ibàle yáapichawa mawiénita Jesús irí, cáiwitáise nacáicani. Yá cáaluca níái wenàiwicaca. ");
INSERT INTO pioNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Néese níái icuèyéicaté marranonáimi, iiquéeyéicaté macáitani, nacàlidaca yàcalé mìnanái iríni, càinácaalíté iyú Jesús ichùnìacani, yái asìalica demonio idacuèricaté íiwitáise. Nacàlidaca nalí nacái marranonáimi iináwaná ìwali. ");
INSERT INTO pioNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Iná nadàbaca nasutáca Jesús íicha wawàsi manuísíwata yèepùanápináwa nàasu cáli íicha. ");
INSERT INTO pioNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Yá Jesús yèepùacawa barca yàatalé, néese yái asìali demonionái idacuèricaté íiwitáise isutáca Jesús íicha wawàsi manuísíwata imàacáanápiná yàacawa yáapicha. ");
INSERT INTO pioNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Quéwa Jesús càmita imàaca asìali yàacawa yáapicha. Néese Jesús íimaca asìali irí: —‍Pèepùawa picapèe néréwa, péenánái yàataléwa. Picàlida nalíni macáita yái cayábéerica Wacuèriná Dios imàníirica pirí, iicá nacái pipualé manuísíwata —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Néese yái asìali yàaca icàlidacani diez namanùbaca yàcalé irìcu ìyéeyéica Decápolis yàasu cáli íinata. Icàlidaca Jesús imànicaté irí cayábéeri, yá macáita néemìacaalíténi, yá náináidacawa manuísíwata néemìacani. ");
INSERT INTO pioNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Néeseté idécanáami Jesús ichàbacawa àniwa abéemàalé Galilea icalìsaniná íicha barca irìcu yéewáidacalénái yáapichawa, yá manùba wenàiwica ìwacáidáyacacawa yàatalé. Yá Jesús iyamáacawa calìsa icàinalená íinata. ");
INSERT INTO pioNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Néese áiba asìali yàanàaca, abéeri néená níái judíonái yéewáidacàalu íiwacanánái, íipidenéerica Jairo. Yá Jairo iicáca Jesús. Yá yúuwàa irìacawa inùmáawawa Jesús irí, yàacaténá Jesús icàaluíniná, yéewanápiná Jesús iicáca ipualé. ");
INSERT INTO pioNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Yá isutáca Jesús íicha wawàsi manuísíwata. Jairo íimaca Jesús irí: —‍Nuídu iculúacawa, uwàwa uétácawa nuícha. Iná nuwàwacutáca pía nucapèe néréwa, pimàaca picáapiwa ùwali, ipíchaná uétácawa —‍íimaca. ");
INSERT INTO pioNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Néese Jesús yàacawa Jairo yáapicha yéewáidacalénái yáapichawa. Madécaná wenàiwicanái nacái nàacawa yáamiwáise. Máinícáiná manùbaca wenàiwica, íná nacàbadàayacacawa nàacawa Jesús iwéré. ");
INSERT INTO pioNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Abéechúa inanái ùacawa manùbéeyéi wenàiwica yèewi. Cáuláicacaté úa doce camuí, uíraná imusúacawa uícha mamáalàacata. ");
INSERT INTO pioNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Uuwichàacatéwa báawanama idècunitàacá manùba cadèpìacáiyéi idèpìaca úa. Ewitaté úucacáaníta ùasu platawa macáita upáyaidacaténá cadèpìacáiyéi, càicáaníta càmita cayába úa, mamáalàacata quéwanáta cáuláicaca yáwanái úa. ");
INSERT INTO pioNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Uémìacaté Jesús iináwaná ichùnìaná wenàiwica, íná ùaca nacáiwa manùbéeyéi wenàiwica yáapicha. Yá ùacawa Jesús yáamiwáise mawiénita irí manùbéeyéi wenàiwica yèewi, yá udunùaca Jesús ibàle ìwali. ");
INSERT INTO pioNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Umànica cài uínáidacáináwa ùacawa: “Nudunùacaalí ìwali, éwita ibàle ìwalicáaníta meedáni, yásí báisíta cayábapináca núawa”, cài úumaca uínáidacawa ulíwa uwàwalìcuísewa. ");
INSERT INTO pioNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Udécanacáita udunùaca ibàle ìwali, yáta uíraná iyamáacawa uícha, yá úalíacawa uwàwalìcuísewa udéca uchùnìacawa uláicái íicha. ");
INSERT INTO pioNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Yáta Jesús yáalíacawa iwàwalìcuísewa ichùnìacaté áiba wenàiwica íiwitáise iyúwa. Iná iwènúacawa iicáidacaténá manùbéeyéi wenàiwica irí. Néese Jesús isutáca yéemìawa nía. Iimaca nalí: —‍¿Cawiná idunùa nubàle ìwali? —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Néese yéewáidacalénái íimaca irí: —‍¿Càmita piicá níái madécanéeyéi wenàiwicaca nacàbadàayacacawa nàacawa piwéré? ¿Cánásica yéewa pisutá péemìawa cawinácaalí idunùa pìwali? —‍náimaca Jesús irí. ");
INSERT INTO pioNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Quéwa Jesús iicáida itéesewa mamáalàacata iicácaténá yái wenàiwica idunuèricaté ìwali. ");
INSERT INTO pioNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Iná úái inanáica umusúacawa wenàiwicanái yèewíise. Yá ùanàaca itatéechúawa icalùniwa, úalíacawa uchùnìacatéwa. Yá ubàlùacawa ùuluì ipùata iyúwa Jesús irí ùacaténá icàaluíniná. Yá ucàlidaca irí macáita uináwanáwa báisíiri iyú. ");
INSERT INTO pioNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Néese Jesús íimaca ulí: —‍Pía, inanáica, pimàacacáiná piwàwawa nùwali, íná yéewa pidéca pichùnìacawa. Pìawa matuíbanáita. Pidéca pimusúacawa càiripináta íicha yái uláicáica —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Idècunitàacá Jesús icàlidaca ulíni, yá áibanái nàanàaca judíonái yéewáidacàalu íiwacali icapèe néese. Yá náimaca Jairo irí: —‍Píidumica yéetáwa. Picá pisàiwica quirínama irí wawàsi, yái yéewáidéerica wenàiwica —‍náimaca. ");
INSERT INTO pioNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Jesús yéemìaca natàaníiná, quéwa càmita itàaní náapicha. Jesús itàanícáita abéerita Jairo yáapicha, yái judíonái yéewáidacàalu íiwacalica. Jesús íimaca irí: —‍Picá cáalu pía. Peebáidacáita nulí mamáalàacata —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Néese càmita Jesús imàaca áibanái nàacawa náapicha Jairo icapèe nérépiná. Imàaca nàacawa náapicha níawamicata Pedro, Santiago nacái, Santiago iméeréeri nacái, íipidenéeri Juan. ");
INSERT INTO pioNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Yá néese nàanàaca judíonái yéewáidacàalu íiwacali icapèe néré, yá Jesús iicáca manùbéeyéi wenàiwica cachàiníiyéi isàna, íicháaníiyéica báawanama, nacántàa canción cachàiníiri iyú yéetáními ìwali, càide iyúwa judío íiwitáise ìyáaná. ");
INSERT INTO pioNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Jesús yáalíacawa icáucàidáanápiná úa yéetéechúamicawa. Yá iwàlùacawa nacapèe irìculé, íimaca nalí: —‍¿Cánácué pimàni pisànawa báawanama, píicháanícué nacái máiní? Uara sùmàuca càmíichúata yéetáwa, uimácáicata ùyaca —‍íimaca yái Jesúsca, yáalíacáináwa icáucàidáanápináté úa. ");
INSERT INTO pioNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Néese naicáaníca Jesús iquíniná, náalíacáináwa báisíiri iyúcani uétácatéwa. Quéwa Jesús imusúadaca nía canánama capìi íicha. Néese itéca yáapichawa yéetéechúami yáaniri, úatúami nacái, nía nacái yéewáidacaléca ìyéeyéica yáapicha. Yá nawàlùacawa sùmàumi irìacatalécawa. ");
INSERT INTO pioNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Néese íibàaca ucáapi ìwali, úái yéetéechúamicawa, yá íimaca ulí: —‍Talita, cum (íimáanáca judíonái itàacái iyú: “Pía, mànacàuca, núuma pirí, pimichàawa”, cài íimáanáca) —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Yáta úái sùmàuca, idènièchúaca doce camuí, umichàacawa, yá uìpìna nacái. Yá náináidacawa manuísíwata naicáidaca ulí, níái wenàiwicaca ìyéeyéica néré. ");
INSERT INTO pioNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Quéwa Jesús yàalàaca nía cachàiníiri iyú ipíchaná nacàlidaca áibanái iríni, icáucàidáanáté úa. Néese ichùulìaca nacái nàaca uyáapiná, úái sùmàuca. ");
INSERT INTO pioNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Néeseté Jesús yàacawa Capernaum ìyacàlená yàasu cáli íicha, yá yàanàaca yàasu cáli néréwa, Nazaret ìyacàlenáca. Yéewáidacalénái nàaca nacáiwa yáapicha. ");
INSERT INTO pioNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Yá sábado irìcu judíonái iyamáidacatáicawa, Jesús idàbaca yéewáidaca wenàiwica judíonái yéewáidacàalu irìcu. Manùbéeyéi wenàiwica yéemìacáináni, yá báawaca náináidacawa nawàwalìcuísewa. Náimaca nalíwáaca: —‍Canáca yéewaná yéewáidaca wía. Icàlidacáita áibanái yàasu tàacáisi meedá, càmicáiná yáalíawa cayába. Càmita báisí imàni yái càmíirica wenàiwica idé imànica. ");
INSERT INTO pioNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Yácata ìirimi meedá yámide yàalubáisi imàníirinámica. María ìirica meedáni. Nabèerica meedáni, níái Santiago, José nacái, Judas nacái, Simón nacái. Yéenánái inanái nacái nàyaca wèewibàa meedá —‍náimaca nalíwáaca. Iná càmita nawàwa neebáidaca Jesús itàacái. ");
INSERT INTO pioNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Quéwa Jesús íimaca nalí: —‍Batéwa macái wenàiwica naicáca profeta cáimiétaquéeri iyú icàlidéerica tàacáisi Dios inùmalìcuíse. Quéwa yàasu cáli néeséeyéi, yéenánái nacái, icapèe irìcuíyéi nacái, níawamita càmita nawàwa neebáidaca itàacái. Càita nacái nùasu cáli néeséeyéi, nuénánái nacái, nucapèe irìcuíyéi nacái, càmita nawàwa neebáidaca nutàacái —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Càmita Jesús imàni néré yái càmíirica wenàiwica idé imànica, càmicáiná neebáida itàacái. Quéwa imàacaca icáapiwa abénaméeyéi cáuláiquéeyéi ìwali, cawàwanáta máisiba, yá ichùnìaca nía. ");
INSERT INTO pioNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Yá achúmaca íináidacawa iwàwawa manuísíwata càmicáiná neebáida itàacái. Néeseté Jesús yèepuníca yéewáidaca wenàiwica áiba yàcalé irìcubàa ìyéeyéica mawiénita Nazaret ìyacàlená irí. ");
INSERT INTO pioNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Jesús imáida yàataléwa níái doce namanùbaca yéewáidacalécawa. Néese idàbaca ibànùaca nía pucháibanamata nàacaténáwa yàcalé imanùbaca. Ichàiniadaca nía náucáanápiná demonio wenàiwicanái íicha. ");
INSERT INTO pioNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Càmita imàaca natéca wawàsi nàasu àyapu imàluwenáwa. Imàacaca natéca abéerita nàasu àicuwa natéeripiná àyapulìcubàa. Càmita imàaca natéca saco, yàacàsi nacái, plata nacái. ");
INSERT INTO pioNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Imàacaca nàwalica nàasu costiza nacáiriwa nàabàli ìwaliwa, quéwa càmita imàaca nadènìaca pucháiba nabàlepináwa, abéerita meedá. ");
INSERT INTO pioNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Yá Jesús íimaca nalí: —‍Piwàlùacuéwa abéeri capìi irìculé, yá piimácué néréta àta pèepùacatalétacuéwa yàcalé irìcuíse. ");
INSERT INTO pioNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Aibalé càmicaalícué namàaca piwàlùacawa, càmicaalí nacái nawàwa néemìaca picàlidacuéca nalí nutàacái, yá iwàwacutácué pìacawa náicha. Pichùpìacué cáli ichùmalé pìabàli íichawa naicápiná càide iyúwa wáiwitáise ìyáaná, wía israelitaca, píasáidacaténácué nalí Dios yùuwichàidáanápiná níawa —‍íimaca yéewáidacalénái iríwa, yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Iná yéewáidacalénái nàacawa nàalàacaténá wenàiwica nawènúadáanápiná náiwitáisewa Dios irípiná. ");
INSERT INTO pioNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Yá náucaca nacái madécaná demonio wenàiwicanái íicha. Nàucùaca olivo iséená manùbéeyéi cáuláiquéeyéica ìwali, yá nachùnìaca nía. ");
INSERT INTO pioNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Néeseté rey Herodes yéemìaca wenàiwica icàlidaca Jesús iináwaná ìwali, manùbacáiná wenàiwica nacàlidaca nàyaca ìwali, yái Jesús imàníináca, càinácaalí iyú yéewáidaca wenàiwica nacái. Yá Herodes íimaca Jesús ìwali: —‍Juan el Bautistami idéca icáucàacawa, íná yéewa yáalimá imànica yái càmíirica wenàiwica idé imànica —‍íimaca yái rey Herodesca, iyúunáidacáiná Juan el Bautistamicani yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Aibanái íimaca Jesús ìwali: —‍Yácata profeta Elías yàanèerica àniwa —‍náimaca. Aibanái íima: —‍Yácata áiba profeta càiride iyúwaté profetanáimi wapíchaléeyéimi —‍náimaca. ");
INSERT INTO pioNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Quéwa rey Herodes yéemìacaalíté nacàlidaca Jesús iináwaná, yá Herodes íimaca: —‍Yácata Juanmi, yái nuchùulièricaté nawichùaca íicha íiwita. Idéca icáucàacawa —‍íimaca yái rey Herodesca. ");
INSERT INTO pioNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Càica Herodes íimaca ichùulìacáináté yàasu úwináiwa náibàanápináté Juan calúacáiná Herodes yàacawéetúa iicáca Juan, úái Herodes yàacawéetúa íipidenéechúaca Herodías. Yá úwinái nadacùacaté Juan cadena iyú presoíyéi ibànalìcu. Uái Herodíasca, úacata Herodes yéenásàiri Felipe yàacawéetúa quéechatécáwa, quéwa Herodes imelùdacaté úa yéenásàiri íichawa. ");
INSERT INTO pioNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Iná Juan íimacaté rey Herodes irí: “Báawéeriquéi peedáanáca péenásàiri yàacawéetúawa”, íimacaté yái Juanmica. ");
INSERT INTO pioNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","20","Iná báawacaté Herodías uicáca Juan, yá uwàwacaté unúacani, quéwa càmita úalimá unúacani, cáalucáiná rey Herodes iicáca Juan, yáalíacáináwa cayábéericani, yái Juanca, mabáyawanéeri nacái. Iná Herodes icùaca Juan ipíchaná Herodes yàacawéetúa Herodías inúacani. Ewita rey Herodes càmicáaníta yáalíawa càinácaalí iwàwacutáaná imànica macái èerita idécanáamité yéemìaca Juan icàlidaca irí Dios itàacái, càicáaníta casíimáica rey Herodes yéemìaca Juan itàacái. ");
INSERT INTO pioNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Quéwa áiba èerité Herodías úalimáca umànica Juan irí càide iyúwaté uwàwáaná. Rey Herodes imànica manuíri fiesta iwàwalicaténá yàasu èeriwa asáicatáicaténi. Yá imáidaca yáapichéeyéiwa iyúudèeyéica Herodes icùaca Galilea yàasu cáli, nía nacái yàasu úwi íiwacanánáica, nía nacái yàacawéeyéináca asìanáica caináwanéeyéica Galilea yàasu cáli néeséeyéica, nayáacaténá nayáacaléwa yáapicha, namànicaténá yáapicha nacái manuíri fiesta. ");
INSERT INTO pioNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Yá Herodías uídu iwàlùacawa asìanái iyáacàalu irìculé. Yá ulabàaca báawéeri iyú abéechúata asìanái yàacuésemi naicácaténá úa. Naicácáiná ulabàaca, íná usíimáidaca nawàwa macáita rey Herodes, nía nacái yáapichéeyéica iyéeyéica iyáacaléwa yáapicha. Iná rey Herodes íimaca mànacàu irí: —‍Pisutá nuícha càinácaalí piwàwéerica. Yásí nùaca piríwani —‍íimaca ulí. ");
INSERT INTO pioNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Yá Herodes íimaca ulí àniwa pucháiba yàawiríata báisí báisísíwatasa Dios yáaliéricawa Herodes yàanápináté ulí càinácaalí wawàsi uwàwéerica íicha, éwitasa uwàwacaalíté íicha cáli yéema, yái Galilea yàasu cálica Herodes icuèrica, yásí yàanápinása ulítáni báisíta, íimaca. ");
INSERT INTO pioNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Yá ùacawa náicha, úumaca úatúa iríwa: —‍¿Càiríinásica wawàsi nusutá íicha? —‍úumaca úatúa iríwa. Yá Herodías úumaca ulí: —‍Pisutá íicha Juan el Bautista íiwita —‍úumaca ulí úái Herodíasca, uwàwacáináté uicáca Juan íiwita utuí iyúwa úalíacaténáwa báisíiri iyúcani Juan yéetácawa. ");
INSERT INTO pioNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Néese úái mànacàuca uèpùa uwàlùacàatétawa àniwa rey Herodes yàatalé. Yá úumaca irí: —‍Siùcata nuwàwa pìaca nulí Juan el Bautista íiwita quírápieli irìcu —‍úumaca irí. ");
INSERT INTO pioNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Néese, éwita achúmacáaníta manuísíwata rey Herodes iwàwa, yéemìacáiná usutáaná íicha, càicáaníta càmita Herodes idé imáisanìaca uíchani, íimacáináté ulí nàacuésemi níái wenàiwicaca yàanápinása ulí càinácaalí wawàsi usutéerica íicha. ");
INSERT INTO pioNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Yá rey Herodes ichùulìaca úwisàiri iwichùanápiná Juan íicha íiwita, itécaténáni rey Herodes irí. ");
INSERT INTO pioNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Néese úwisàiri yàacawa presoíyéi ibàna néré. Yá iwichùaca Juan íicha íiwita. Càité Juan yéetácawa. Yá úwisàiri itéca íiwitami quírápieli irìcu. Yá yàaca íiwitami ulí úái mànacàuca. Néese úái mànacàuca utécani úatúa iríwa, uicácaténá báisíiri iyúcani Juan yéetácatéwa. ");
INSERT INTO pioNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Néese Juan yéewáidacalénáimi yéemìaca iináwanámi, yá nàacawa presoíyéi ibàna néré needácaténá Juan ichéecami. Yá natéca nabàlìawani. ");
INSERT INTO pioNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Néeseté apóstolnái yèepùa ìwacáidáyacacawa Jesús yàatalé, idécanáami nacàlidaca Dios itàacái wenàiwicanái irí. Néese nacàlidaca Jesús irí macáita namàníiricaté, néewáidéerica iyú wenàiwicanái nacái. ");
INSERT INTO pioNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Jesús íimaca nalí: —‍Wàacuéwa wàanácuéwa walínáamitawa áibalé canácatalé wenàiwica, yéewanápiná wayamáidacawa achúmáanacáwa —‍íimaca nalí, madécanácáiná wenàiwica yàanàaca yàacawa nàatalé, áibanái nacái yèepùacawa yàacawa náicha, íná càmita yéewa nayamáidacawa, ibatàa nayáanápiná nayáacaléwa, càmita náalimá. ");
INSERT INTO pioNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Iná Jesús yàacawa barca irìcu yàasu apóstolnái yáapichawa abéemàalé Galilea icalìsaniná íicha, canácataléca wenàiwica. ");
INSERT INTO pioNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Quéwa madécaná wenàiwica iicáca nàanáwa, náalía nacái naicáca nía. Iná wenàiwicanái imusúacawa macái yàcalé íicha, yá napìacawa néré. Yá manùbéeyéi wenàiwica nàanàaca napíchalé néré. ");
INSERT INTO pioNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Néese Jesús imichàacawa barca irìcuíse néré, yá iicáca madécaná wenàiwica. Canáca nalí abéeri yéewáidéeripiná nía Dios ìwali, íná catúulécanáca Jesús iicáca nía, càide iyúwa waicácaalí canéeyéi icuèriná ovejaca. Yá idàbaca yéewáidaca nía madécaná wawàsi ìwali. ");
INSERT INTO pioNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Néese catáca yàacawa nàwali, yá yéewáidacalénái yàacawa Jesús yàatalé, yá náimaca irí: —‍Catáca yàacawa wàwali chái canácatáica yàcalé. ");
INSERT INTO pioNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Pichùulìa nèepùanápináwa nàacawa bànacalé yèewiré, yàcalé irìculé nacái ìyéeyéica mawiénita nawènìacaténá nayáapináwa —‍náimaca. ");
INSERT INTO pioNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Quéwa Jesús íimaca nalí: —‍Píatacué yàa nayáapiná —‍íimaca nalí. Néese yéewáidacalénái íimaca irí: —‍¿Càmita píalíawa canáca walí doscientos namanùbaca denario ocho quéeri iwènicatái? Ewita wadènìacaalí yáara platatá, càicáaníta càmita wáalimá wawènìaca cayába pan wèeripináca nayáapinátá, níái manùbéeyéi wenàiwicaca —‍náimaca. ");
INSERT INTO pioNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Jesús íimaca nalí: —‍¿Càisimalénácué pan pidènìa? Picutácuécáwani —‍íimaca nalí. Néese idécanáami náalíacawa, yá náimaca irí: —‍Cinco namanùbaca pan, pucháiba cubái imìdecaná nacái —‍náimaca. ");
INSERT INTO pioNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Néese ichùulìaca nía manùbéeyéi wenàiwicaca náawináanápináwa nàwacacawa ipuléeri masicái íinata. ");
INSERT INTO pioNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Néese náawinacawa nàwacacawa manùbéeyéi yàalusipiná, cien namanùbaca abénaméeyéi, cincuenta namanùbaca áibanái nacái. ");
INSERT INTO pioNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Néese Jesús yeedáca cinco imanùbaca pan icáapi irìculéwa, pucháiba cubái imìdecaná nacái. Yá iicáida chènuniré, yàaca Dios irí cayábéeri ìwali yái yàacàsica. Néese isubèriadacani, iwacùaca pan yéewáidacalénái iríwa nawacùacaténá wenàiwicanái iríni. Néese iwacùaca cubái imìdecaná nacái yéewáidacalénái iríwa macáita. ");
INSERT INTO pioNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Yá macáita wenàiwicanái iyáaca cadénamani. ");
INSERT INTO pioNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Néese yéewáidacalénái needáca doce mapíiri imanùbaca pan yéenáimi, cubái nacái imàaquéericawa. ");
INSERT INTO pioNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Níái wenàiwica iyéeyéica pan, cinco mil namanùbaca asìanái. Càmita naputàa càisimalénácaalí inanái, sùmanái nacái. ");
INSERT INTO pioNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Yáta Jesús ichùulìaca yéewáidacalénáiwa nawàlùanápináwa caquialéta barca irìculé nachàbacaténáwa ipíchalépiná abéemàalé Galilea icalìsaniná íicha nàanàacaténá Betsaida ìyacàlená néré. Iwàwa nàacawa ipíchalé idècunitàacá imàacaca wenàiwicanái yèepùacawa íicha. ");
INSERT INTO pioNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Néeseté idécanáami ibànùaca wenàiwicanái yèepùanápináwa íicha canánama, yá Jesús yàacawa dúli íinatalé isutácaténá yáawawa Dios íicha. ");
INSERT INTO pioNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Néese idécanáami catáca nawicáu, Jesús yéewáidacalénái nàyaca barca irìcu bamuchúami calìsa. Yá Jesús ìyaca abéerita cáli íinatáisecáwa. ");
INSERT INTO pioNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Néese iicáca máadáiní natenáca cachàiníiri iyú cáulicáiná ipùaca náipunita, íná càmita náalimá nachàbacawa abéemàalé. Amalácaalí yàacawa nawicáu, yá Jesús yàacawa mawiénita nalí yèepuníiriwa úni inànìacubàa. Iwàwaca ichàbacawa náicha machacàníiri iyú. ");
INSERT INTO pioNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Quéwa naicáca ìipìnáaníca úni inànìacubàa, yá nayúunáidaca wenàiwica iwàwanámicani. ");
INSERT INTO pioNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Yá néemíanícawa macáicáiná naicácani. Cáaluca nía báawanama, càmicáiná náalía naicácani. Yáta quéwa Jesús íimaca nalí: —‍¡Matuíbanáicué pía, núaquéi, picácué cáalu pía! —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Néese Jesús iwàlùacawa nàatalé barca irìculé. Yáta wiúca cáuli, Jesús iwàlùacáináwa nàatalé barca irìculé. Yá náináidacawa manuísíwata naicáidaca irí. ");
INSERT INTO pioNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Càmitàacáwa nadé náalíacawa cayába Jesús íiwitáise ìwali, éwitaté naicácáaníta imàníiná pan iyú yái càmíirica wenàiwica idé imànica, càulenácáiná náicha náalíanápináwa néemìaca càinácaalí íimáaná. ");
INSERT INTO pioNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Nachàbacatéwa abéemàalé Galilea icalìsaniná íicha, yá nàanàaca Genesaret yàasu cáli néré. Yá nadacùaca barca calìsa idùlepiré. ");
INSERT INTO pioNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Namichàacanacáitawa barca irìcuíse, yá wenàiwicanái náalía naicáca Jesús. ");
INSERT INTO pioNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Yá wenàiwicanái napìacawa macái yàcalé irìculé ìyéeyéica néré nacàlidacaténá nalí Jesús yàanàaca. Néese manùbéeyéi wenàiwica nadàbaca natéca cáuláiquéeyéi wenàiwica yàalubái íinatawa náalíacataléca Jesús ìyaca. ");
INSERT INTO pioNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Néese àta alénácaalí Jesús yàawa achúméeri yàcalé irìculé, manuíri yàcalé irìculé nacái, manacúaliré nacái, yá natéca nalìadaca cáuláiquéeyéi wenàiwica àyapulìcubàa Jesús ichàbacatabàapináwa. Yá cáuláiquéeyéi nasutáca Jesús íicha imàacáanápiná nadunùaca ìwali, càmicaalí nacái, ibàle ipùata ìwalita. Yá macáita idunuèyéica Jesús ìwali, yá cayábaca nía uláicái íicha. ");
INSERT INTO pioNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Abénaméeyéi yéewáidéeyéi wenàiwica templo irìcu nàanàacaté Jerusalén ìyacàlená néese. Nàwacáidáyacacawa abénaméeyéi fariseo yáapicha. Néese macáita nàacawa Jesús yàatalé. ");
INSERT INTO pioNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Naicácaté abénaméeyéi Jesús yéewáidacaléca nayáaca nayáacaléwa càmíiyéicáwa íiba icáapiwa éeréeri iyú càide iyúwa fariseo íiwitáise íimáaná. Càmita Jesús yéewáidacalénái imàni culto nacáiri náibacaténá nacáapiwa éeréeri iyú ipíchawáise nayáaca nayáacaléwa càide iyúwa fariseonái imàníiná. Iná fariseonái itàaníca Jesús yéewáidacalénái ìwali, náimaca casacàacasa Dios iicáca Jesús yéewáidacalénái. ");
INSERT INTO pioNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Níái fariseoca, áibanái judío nacái macáita namànica càide iyúwaté nàawirináimi imàníiná. Càmicaalícáwa náiba nacáapiwa éeréeri iyú nayáacalé ipíchawáise, càmitàacá nayáa nayáacaléwa, canásíwata. Càmita nayáa nayáacaléwa càmicaalícáwa namàni culto nacáiri náibacaténá nacáapiwa éeréeri iyú càide iyúwa fariseo íiwitáise íimáaná. ");
INSERT INTO pioNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Idécanáami nacái nawènìaca yàacàsi yàcalérìcu, yá nèepùacawa nacapèe néréwa namànicaténá culto nacáiri nàapìdáanápiná náichawa ipíchawáise nayáa nayáacaléwa. Neebáidaca nacái madécaná càide iyúwaté nàawirináimi yéewáidáaná, íná namànica culto nacáiri náibacaténá éeréeri iyú macái íiwitáaná bacàa, catùa nacái, mapuwáa nacái, nàasu cama nacái, naiméerica íinata.) ");
INSERT INTO pioNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Iná fariseonái, nía nacái yéewáidéeyéica wenàiwica templo irìcu náimaca Jesús irí: —‍Níái péewáidacaléca, ¿cáná càmita namàni càide iyúwaté wàawirináimi yéewáidáaná? Càmita namàni culto nacáiri náibacaténá nacáapiwa éeréeri iyú càide iyúwa wàawirináimi ichùulìanáté wía wamàníinápiná ipíchawáise wayáaca wayáacaléwa, íná casacàaca Dios iicáca níái péewáidacaléca —‍náimaca. ");
INSERT INTO pioNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Jesús íimaca nalí: —‍Profeta Isaías itànàacaté tàacáisi machacàníiri iyú pìwalicué, píacué pucháibéeyéica íiwitáise. Isaías itànàacaté tàacáisi piináwaná ìwalicué Dios inùmalìcuíse. Dios íimacaté: ‘Níái israelitaca náimacáita meedá nàacasa nucàaluíniná, quéwa càmita cáininá naicáca núa báisíiri iyú nawàwalìcuísewa. ");
INSERT INTO pioNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Caná iwèni nuicáca nàasu culto namàníiricasa nulí. Càmita néewáida wenàiwica nutàacái iyú, néese néewáidacáita wenàiwica náiwitáise iyúwa’, càica íimaca yái Diosca. ");
INSERT INTO pioNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Pidécuéca meedá pimàacaca píichawa Dios itàacái, peebáidacaténácué wenàiwicanái yàasu tàacáisi meedá —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Néese Jesús íimaca nalí àniwa: —‍Pidécuéca pimànica máiní báawéeri wawàsi, pimàacacáinácué píichawa Dios itàacái, pimànicaténácué meedá iyúwa píiwitáise íimáaná. ");
INSERT INTO pioNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Profeta Moisés íimacaté Dios inùmalìcuíse: ‘Pìa píaniri íimiétacanáwa, píatúa nacáiwa’, íimaca yái Diosca. Yáté íimaca nalí àniwa: ‘Aibacaalí itàaníca báawéeri iyú yáaniri ìwaliwa, càita nacái itàanícaalí báawéeri iyú yáatúa ìwaliwa, yá iwàwacutácué pinúacani’, íimacaté yái Diosca. ");
INSERT INTO pioNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Quéwa píacué fariseoca, pidécuéca péewáidaca wenàiwicanái cayábacasa cài náimaca náaniri iríwa, náatúa irí nacáiwa: ‘Càmita núalimá nuyúudàaca pía. Nudéca nucùaca Dios irípiná yái plataca, yái nuèripinámica pirí, íná canáca nulí cayába nuyúudèeripiná iyú pía’, cài náimaca nasèenái iríwa. ");
INSERT INTO pioNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Càita pidécuéca péewáidaca wenàiwica càmitasa iwàwacutá nayúudàaca náaniriwa, náatúa nacáiwa, náimacaalí cài nasèenái iríwa. ");
INSERT INTO pioNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Iná pidécuéca píasáidaca piúcaca píichawa Dios itàacái, peebáidacáinácué pìawirináimi íiwitáisewa, yái péewáidéericuéca iyú wenàiwicanái Dios itàacái íicha. Pimànicuéca mamáalàacata madécaná càiyéi wawàsi —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Néese Jesús imáidaca yàataléwa níái wenàiwicaca ibàluèyéicawa mawiénita irí. Yá íimaca nalí: —‍Péemìacué nutàacái píacué macáita. Píalimáidacué píalíaca péemìaca càinácaalí íimáaná yái tàacáisi nucàlidéeripinácuéca piríwa. ");
INSERT INTO pioNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","16","Macái yàacàsi iwàluèriwa wenàiwica idèerìculé, canáca yéewaná casacàaca imànica wenàiwica íiwitáise Dios íicha. Abéerita wenàiwica ibáyawaná, yá nacái itàacái báawéerica imusuéricawa iwàwalìcuíse, yácata casaquèerica imànica wenàiwica íiwitáise Dios íicha —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Néese Jesús yàacawa wenàiwicanái íicha, yá iwàlùacawa capìi irìculé yéewáidacalénái yáapichawa. Néese yéewáidacalénái nasutáca néemìawani càinácaalí íimáaná yái tàacáisica Jesús icàlidéerica yàacàsi ìwali. ");
INSERT INTO pioNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Yá Jesús íimaca nalí: —‍¿Néeni, càmitasicué nacái píalía péemìacani yái nucàlidéerica? ¿Càmitacué píalíawa canácata yàacàsi yáaliméeri casacàaca imànica wenàiwica íiwitáise Dios íicha? ");
INSERT INTO pioNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Yái yàacàsi càmita iwàlùawa wenàiwica iwàwa irìculé. Iwàlùacáitawa idèerìculé. Néese yàacawa íicha meedá —‍íimaca nalí yái Jesúsca. Càita Jesús yéewáidaca nía yàacàsi ìwali, Dios imàacaca wenàiwica iyáaca macái íiwitáaná yàacàsica, masacàacáiná macáita nía. ");
INSERT INTO pioNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Néese Jesús íimaca nalí àniwa: —‍Yái nabáyawaná namàníirica, yá nacái tàacáisi báawéerica imusuéricawa wenàiwica iwàwa irìcuíse, yácata casaquèerica imànica wenàiwicanái íiwitáise Dios íicha. ");
INSERT INTO pioNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Macáita íiwitáisesi báawéeri imusúacawa wenàiwica iwàwa irìcuíse. Càita báawéeri íiwitáisesi: Namànica náalaniwa; namànica nainá iyúwa càide iyúwa càmíiná Dios imàaca wenàiwica imànica; nayéedùaca áibanái yàasu; nanúaca wenàiwica; ");
INSERT INTO pioNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","naimáca áiba wenàiwica yáapicha càmíichúaca náinusíwa, càmíirica nacái nanìrisíwa; máiní nawàwa needáca nalíwa manùba wawàsi; namànica áibanái irí báawéeri; nachìwáidaca áibanái wenàiwica; mabáiníiri iyú namànica báawéeri nainá iyúwa máaléquéeri iyú áibanái wenàiwica yàacuésemi; báawaca naicáca áibanái wenàiwica ìwalíise yái cawèníirica áibanái idènièrica; natàaníca báawéeri iyú áibanái ìwali; máiní cachàinica naicáca níawawa; càmita náalía cayábéeri ìwali báawéeri íichaná. ");
INSERT INTO pioNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Macáita yái íiwitáaná báawéerica imusúacawa wenàiwica iwàwa irìcuíse. Yácata casaquèerica imànica wenàiwicanái íiwitáise Dios íicha —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Néeseté Jesús yàacawa Galilea yàasu cáli íicha yàanàacaténá Tiro ìyacàlená yàasu cáli néré. Yá iwàlùacawa capìi irìculé. Idècunitàacá ìyaca néré, càmita iwàwa yàcalé mìnanái náalíacawa alénácaalí ìyaca. Càmita quéwa yáalimá ibàaca iináwanáwa. ");
INSERT INTO pioNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Ráunamáita abéechúa inanái uémìaca iináwaná ìwali ìyaca capìi irìcu. Udènìa uíduwa demonio idacuèchúa íiwitáise. Uái inanáica ùacàatécatawa Jesús yàatalé. Yá ubàlùacawa ùuluì ipùata iyúwa Jesús íipunita, usutácaténá iicáanápiná upualé. ");
INSERT INTO pioNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Càmíichúata israelita úái inanáica. Néese Sirofenicia yàasu cáli néeséechúaca úa. Yá ùanàaca usutácaténá Jesús íicha wawàsi yúucáanápiná demonio uídu íicha. ");
INSERT INTO pioNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Quéwa Jesús íimaca ulí: —‍Péemìa comparación: Càmita wáuca sùmanái iyáacalé áulinái iyáapiná, càita nacái iwàwacutá nuyúudàaca quéechacáwa nuénánáicawa, níái israelitaca. Càmita cayába nuyúudàaca píacué càmíiyéica israelita —‍íima ulí, yáalimáidacaténá iicáwa úa, asáisí uebáidacaalí Dios imàníinápiná ulí cayábéeri éwita càmicáaníta israelita úa. ");
INSERT INTO pioNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Yá úumaca irí: —‍Báisíta, Nuíwacali, quéwa càide iyúwa áulinái yáawinacaalíwa mesa yáapíise, sùmanái yúucacaténá nayáapiná yàacàsi yéenáimi, càita nacái nuwàwaca Dios imànica nulí cayábéeri éwita càmicáaníta israelita núa —‍úumaca. ");
INSERT INTO pioNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Néese Jesús íimaca ulí: —‍Pidéca píasáidaca nulíni pitàacái iyúwa peebáidaca nulí, íná càmita iwàwacutá pisutáca nuícha quirínama nuyúudàanápiná píawa. Yá numàaca pèepùacawa picapèe néréwa, demoniocáiná idéca yàacawa píidu íicha —‍íimaca ulí yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Néese uèpùacawa ucapèe néréwa, yá ùanàaca uíduwa irièchúawa matuíbanáita uimácataléca. Quéwa demonio yàacatéwa uícha. ");
INSERT INTO pioNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Néeseté Jesús yèepùa yàacawa Tiro ìyacàlená yàasu cáli íicha. Yá ichàbacawa Sidón ìyacàlená yèewibàa. Yá ichàbaca nacái diez namanùbaca yàcalé Decápolis yàasu cáli íinatéeyéica ìyaca. Yá yàanàaca Galilea icalìsaniná néré. ");
INSERT INTO pioNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Néese áibanái natéca asìali Jesús yàatalé, abéeri asìali màuwíiri, càmíiri yáalimá itàaníca machacàníiri iyú. Yá nasutáca Jesús íicha wawàsi imàacáanápiná icáapiwa màuwíiri ìwali ichùnìacaténáni. ");
INSERT INTO pioNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Jesús itéca màuwíiri méetàucuta wenàiwicanái íicha, yá Jesús iwàlùadaca báipunitácanama icáapi ipùatawa asìali yùuwíapuná irìculé pucháibanama. Néese Jesús yàapìsaca icáapi ipùata ìwaliwa, yá idunùaca asìali inène ìwali icáapi ipùata iyúwa. ");
INSERT INTO pioNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Néese Jesús iicáidaca chènuniré, yá yeedáca icalésawa. Yá íimaca asìali irí: “¡Efata!” (íimáanáca hebreo itàacái iyú: “¡Yàacùacawéi piùwica!” íimáanáca.) ");
INSERT INTO pioNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Yá yáalimá yéemìaca cayába yái asìalica, yá cayábaca nacái inène, yáalimá itàaníca machacàníiri iyú. ");
INSERT INTO pioNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Néese Jesús yàalàaca níái wenàiwicaca ipíchaná nacàlidaca áibanái irí iináwaná ichùnìanáni, quéwa éwita ichùulìacáaníta nía manùba yàawiría, càicáaníta nacàlidaca iináwaná mamáalàacata. ");
INSERT INTO pioNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Macái wenàiwica yéemièyéica Jesús iináwaná ìwali náináidacawa manuísíwata néemìacani. Yá náimaca nalíwáaca: “Imànica macáita cayábéeri iyú. ¡Imàacaca màuwíiyéi yéemìaca! ¡Imàacaca nacái matàacáiyéi itàaníca!” náimaca Jesús ìwali. ");
INSERT INTO pioNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Aiba èerité madécaná wenàiwica nàwacáidáyacacawa àniwa Jesús yàatalé. Néese canáca nayéeripiná néeni. Yá Jesús imáidaca yàataléwa yéewáidacalénáiwa. Yá íimaca nalí: ");
INSERT INTO pioNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","—‍Catúulécanáca nuicáca níái wenàiwicaca. Nadéca nàyaca núapicha máisiba èeri. Siùcade canáca nalí nayáapiná. ");
INSERT INTO pioNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Nubànùacaalí nía máapíiyéica nacapèe nérépináwa, cawàwanáta nawàwachàbacawa àyapulìcubàa namáapicawa, abénaméeyéi nàanàacáiná déecuíse —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Néese yéewáidacalénái náimaca irí: —‍Canácata yáaliméeri yàaca nayáapiná chái, canácatáica wenàiwicanái ibànacale —‍náimaca. ");
INSERT INTO pioNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Jesús isutáca yéemìawa yéewáidacalénáiwa: —‍¿Càisimalénácué pan ìya pirí? —‍íimaca yái Jesúsca. Yá náimaca irí: —‍Iyaca walí siete namanùbaca pan —‍náimaca. ");
INSERT INTO pioNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Néese Jesús ichùulìaca wenàiwicanái yáawinacawa cáli íinata. Yá yeedáca níái siete namanùbaca panca icáapi irìculéwa. Yá yàaca Dios irí cayábéeri ìwali, yái yàacàsica. Yá isubèriadacani, yàaca yéewáidacalénái iríwani. Néese, yéewáidacalénái iwacùaca pan wenàiwicanái irí. ");
INSERT INTO pioNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Iyaca nacái nalí cawàwanáta máisiba cubái imìdecaná púubéeyéi. Jesús yàaca Dios irí cayábéeri ìwali, yái cubáica. Yá ichùulìaca nacái yéewáidacalénáiwa iwacùanápináni wenàiwicanái irí. Yá nawacùaca nalíni. ");
INSERT INTO pioNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Yá macáita nayáaca cadénamani, yái yàacàsica. Néese Jesús yéewáidacalénái needáca siete mapíiri namanùbaca yàacàsi yéenáimi imàaquéericawa. ");
INSERT INTO pioNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Batéwa báinúaca mil namanùbaca asìanái iyáacaté yái yàacàsica. Càmita naputàa inanáinái, sùmanái nacái. Néese Jesús imàacaca nèepùacawa íicha, níái manùbéeyéi wenàiwicaca. ");
INSERT INTO pioNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Yá Jesús iwàlùacàatétawa barca irìculé yéewáidacalénái yáapichawa. Néese nàacawa abéemàalé Galilea icalìsaniná íicha, yá nàanàaca Dalmanuta yàasu cáli néré. ");
INSERT INTO pioNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Néeseté abénaméeyéi fariseo nàanàaca Jesús yàatalé. Yá nadàbaca natàaníca cachàiníiri iyú Jesús yáapicha. Nawàwa náalimáidacani imàníinápiná áiba wawàsi báawéeri. Yá nasutáca íicha imàníinápiná naicáca wawàsi íiwitáise iyúwa càmíirica wenàiwica idé imànica, yáasáidacaténá báisíta Dios néeséericatani. ");
INSERT INTO pioNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Yá Jesús yeedáca icalésawa cachàiníiri iyú máinícáiná báawaca íináidacawa iwàwawa. Yá íimaca nalí: —‍¿Cánácué pisutá numàníinápiná cài? Pidécuéca piicáca numànica manùba, quéwa càmitacué peebáida nutàacái. Péemìacué cayába, càmitacué núasáida piicáca càiri wawàsi —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Néese Jesús yèepùacawa náicha, yá iwàlùacawa àniwa barca irìculé yéewáidacalénái yáapichawa. Yá nàacawa àniwa abéemàalé Galilea icalìsaniná íicha. ");
INSERT INTO pioNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Jesús yéewáidacalénái naimáichacaté natéca náapichawa nayáapináwa. Nadènìacáita abéeri pan meedá náapichawa barca irìcu. ");
INSERT INTO pioNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Néese Jesús yàalàaca nía ipíchaná nàyaca càide iyúwa báawéeyéi íiwitáise fariseo ìyáaná, rey Herodes nacái. Iimaca nalí: —‍Péemìacué cayába comparación: Piicácué píichawa fariseonái yàasu levadura, yá nacái rey Herodes yàasu levadura —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Yá yéewáidacalénái càmita náalíawa Jesús yàalàaná nía fariseonái yàasu tàacáisi íicha, rey Herodes íiwitáise íicha nacái. Iná yéewáidacalénái náimaca nalíwáaca: —‍Idéca cài íimaca walí canácáiná walí pan —‍náimaca. ");
INSERT INTO pioNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Jesús yáalíacawa náináidáanáwa, íná íimaca nalí: —‍¿Cánácué píima canácasa pirí pan? Càmita nutàaní pan ìwali. ¿Cánácué càmita peebáida nulí núalimáca nùacuéca piyáapiná càinácaalícué pimáapuèrica? ¿Néenicué, máinísica càulenáca píichani? ");
INSERT INTO pioNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Pidènìatacué pituíwatatá. ¿Cánácué càmita píalía péemìaca ìwali yái piiquéerica? Pidènìatacué nacái piùwiwatatá. ¿Cánácué càmita píalía péemìaca càinácaalí íimáaná yái núuméericuéca pirí? Báisíta iwàwacutácué piwàwalica càinácaalíté ìyáaná nuwacùacaalíté pan wenàiwicanái irí nayáapiná. ");
INSERT INTO pioNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Idécanáamité nuwacùaca nalí cinco namanùbaca pan nayáapiná, níái cinco mil namanùbaca asìanáica, ¿càisimaléná mapíiri imanùbaca iyamáatéwa yéenáimi pìwacáidéericatécué? —‍íimaca yái Jesúsca. Néese náimaca irí: —‍Doceca mapíiri imanùbaca iyamáacatéwa —‍náimaca. ");
INSERT INTO pioNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Néese íimaca nalí: —‍Néeni, idécanáamité nuwacùaca nalí siete namanùbaca pan nayáapiná, níái cuatro mil namanùbaca asìanáica, ¿càisimaléná mapíiri imanùbaca iyamáawa yéenáimi pìwacáidéericatécué? —‍íimaca yái Jesúsca. Yá náimaca irí: —‍Sietecaté mapíiri imanùbaca yái imàaquéericawa —‍náimaca. ");
INSERT INTO pioNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Néese Jesús íimaca nalí: —‍¿Néeni, cánácué càmitàacáwa píalíawa núalimá nùaca piyáapiná? —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Néeseté nàanàaca Betsaida ìyacàlená néré. Yá Betsaida mìnanái natéca matuíri asìali Jesús yàatalé. Yá nasutáca Jesús íicha wawàsi manuísíwata ichùnìanápináni. ");
INSERT INTO pioNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Néese Jesús itéca matuíri icáapi ìwali, yá imusúadacani yàcalé irìcuíse. Jesús yàapìsáidaca icáapi irìculéwa, néese ipusúa yáawiruníwa matuíri ituí íimami ìwali. Yá Jesús imàacaca icáapiwa matuíri ìwali. Yá isutáca yéemìawa matuíri asáisí yáalimácaalí iicáidaca. ");
INSERT INTO pioNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Néese yái matuírica idàbaca iicáidaca, yá íimaca Jesús irí: —‍Nuiquéeyéitatá wenàiwica càide iyúwa waicácaalí àicu, ìipìnáaníiyéi quéwa —‍íimaca. ");
INSERT INTO pioNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Néese Jesús imàacaca icáapiwa àniwa matuíri ituí ìwali. Asáita iicáca cayába yái asìalica, idéca ichùnìacawa, íná idé iicáca macáita cayába ituí iyúwa. ");
INSERT INTO pioNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Néese Jesús ichùulìaca asìali yèepùanápináwa icapèe néréwa. Yá íimaca asìali irí: —‍Picá piwàlùawa yàcalé irìculé —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Néeseté Jesús yàacawa Betsaida ìyacàlená íicha yéewáidacalénái yáapichawa nachàbacaténá naicáca yàcalé ìyéeyéica mawiénita Cesarea de Filipo ìyacàlená irí. Ipíchawáise nàanàaca néré, idècunitàacá nèepunícawa àyapulìcubàa, yá Jesús isutáca yéemìawa yéewáidacalénáiwa. Iimaca nalí: —‍¿Càiná náimaca nùwali níara wenàiwicaca? ¿Cawinása núa? —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Yá náimaca irí: —‍Abénaméeyéi íimaca pìwali Juan el Bautistamicasa pía, náimacáiná Juanmi idécasa icáucàacawa. Aibanái íimaca profeta Elíascasa pía, yèepuèricasa yàanàaca àniwa, yái profeta Dios íiméericaté ìwali ibànùanápináté àniwani. Aibanái àniwa náimaca pìwali áiba profetanái yéenácasa pía, níái icàlidéeyéicaté tàacáisi bàaluité Dios inùmalìcuíse —‍náimaca. ");
INSERT INTO pioNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Néese Jesús íimaca nalí: —‍Néenicué pía, ¿cawinácué nacái píimaca nùwali? ¿Cawiná núa? —‍íimaca yái Jesúsca. Néese Pedro íimaca irí: —‍Mesíasca pía, yái Dios icàlidéericaté ìwali wàawirináimi israelitanái irí, Dios ibànùanápináté walí wacuèrinápiná —‍íimaca yái Pedroca. ");
INSERT INTO pioNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Quéwa Jesús yàalàaca nía ipíchaná nacàlidaca iináwaná áibanái irí, Mesíascani. ");
INSERT INTO pioNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Néeseté Jesús idàbaca yéewáidaca yéewáidacalénáiwa náalíacaténátéwa iwàwacutáanáté yùuwichàacawa manuísíwata, yái Jesúsca, yái asìali Dios néeséerica. Iwàwacutácaté nacái yùuwidenái iicácani iyúwa canéeri iwèni, càmita nacái neebáida itàacái, níái israelita icuèrinánáica, nía nacái sacerdote íiwacanánái, nía nacái yéewáidéeyéica wenàiwica templo irìcu. Jesús icàlidaca yéewáidacalénái iríwani náalíacaténátéwa iwàwacutáanápináté yùuwidenái inúacani, quéwa máisiba èeri irìcu, yá icáucàanápinátéwa. ");
INSERT INTO pioNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Càita Jesús icàlidaca nalí amaléeri iyúni. Néese Pedro itéca Jesús méetàucuta náicha. Yá Pedro yàalàaca Jesús cachàiníiri iyú, ipíchaná icàlidaca càiri wawàsi. ");
INSERT INTO pioNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Quéwa Jesús iwènúa iicáidaca yéewáidacalénái áibanái iríwa. Yá Jesús yàalàaca Pedro cachàiníiri iyú. Jesús íimaca Pedro irí: —‍¡Pìawa nuícha, pía nùuwide Satanás nacáiri íiwitáise! Càmita píináidawa iyúwa Dios iwàwáaná. Píináida meedáwa càide iyúwa èeri mìnanái íiwitáise ìyáaná —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Néese Jesús imáidaca yàataléwa yéewáidacalénáiwa, áibanái nacái wenàiwica yèepuníiyéicawa náapicha. Yá íimaca nalí: —‍Abéericaalí péenácué iwàwa yàacawa núapicha iyúwa nuéwáidacalé, yá càmita yéewa pimànica yái piwàwéerica pimànica. Iwàwacutá matuíbanáiri iyú pimàaca áibanái yùuwichàidaca pía, éwita naicáanícaalí nacái piquíniná, éwita nanúacaalí píawa cruz ìwali peebáidacáiná nutàacái. Iwàwacutá nacái pimànica mamáalàacata càide iyúwa nuchùulìaná pía. ");
INSERT INTO pioNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Níacáiná cawinácaalí càmíiyéica iwàwa yeebáidaca nutàacái ipíchaná nàuwichàacawa nulípiná, canáca nalí nacáuca càmíiri imáalàawa. Quéwa cawinácaalí yeebáidéeyéica nutàacái mamáalàacata, nacàlida nacái nutàacái áibanái irí, éwita áibanái inúacaalí nía, nadènìapiná nacáucawa càmíiri imáalàawa. ");
INSERT INTO pioNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Ewita wenàiwica yeedácaalí iríwa macáita chái èeri yàasu cawèníirica, quéwa yúuca íichawa icáucawa càmíiri imáalàawa càmicáiná yeebáida nutàacái, yá canéerica iwèni meedá iríni, macáita yái cawèníirica yeedéerimica iríwa. ");
INSERT INTO pioNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Canácáiná áiba wawàsi wenàiwica yáaliméeri yàaca yeedácaténá iríwa icáucawa càmíiri imáalàawa, idécanáami yúucaca íichawani. ");
INSERT INTO pioNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Cawinácaalí wenàiwica báiyéica icàlidaca cayábéeri nùwali, nutàacái ìwali nacái èeri mìnanái irí, níái èeri mìnanái iwènúadéeyéica íiwitáisewa Dios íicha, cabáyawanéeyéi nacái, néese càmita núumapiná nàwaliwa nùasunáica nía, núa asìali Dios néeséerica, nùanàapinácaalí Núaniri Dios íiwitáise iyúwa icamaláná mèlumèluíri irìcu, mabáyawanéeyéi ángel yáapicha nacáiwa, nucùacaténá macáita —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Jesús íimacaté nalí nacái: —‍Péemìacué cayába, abénaméeyéicué péená ìyéeyéica chái siùca, càmita néetápináwa ipíchawáise naicáca càinácaalípiná iyú Dios icùaca yàasu wenàiwicawa íiwitáise iyúwa —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","3","Néesetécáwa seis èeri Jesús icàlidacadénáami nalíni, yá itéca yáapichawa Pedro, Santiago nacái, Juan nacái. Yá yàacawa náapicha dúli chènuníiri íinatalé. Yá néré naicáca Jesús iwènúacawa áibawaca naicápiná. Máiníiri mèlumèluwaca ibàleca cabalèeri máiní íicha chái èeriquéi caná idéeri íibaca cài. ");
INSERT INTO pioNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Naicáca nacái pucháiba profetanái ìyéeyéicaté bàaluité, yái Elías, Moisés nacái, itàaníiyéica ìyaca Jesús yáapicha. ");
INSERT INTO pioNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Néese Pedro íimaca Jesús irí: —‍Wáiwacali, ¡máiní cayábéeriquéi wàyáanáca chái! Siùcade wamànica máisiba capìi yáana wawàwalíinápinácué pía, abéeri pìasupiná, áiba nacái Moisés irípiná, áiba nacái Elías irípiná —‍íimaca yái Pedroca. ");
INSERT INTO pioNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Càica Pedro íimaca máinícáiná cáaluca níái yéewáidacaléca máisiba, íná Pedro càmita yáalíawa càinácaalí iwàwacutáaná íimaca Jesús irí. ");
INSERT INTO pioNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Yáta acalèe iricùacawa, yá ibàlìaca nía catámèeri iyú. Néese néemìaca Dios itàacái acalèe yèewíise. Iimaca nalí: “Yácata Nuìri nuwàwéeri cáininéerica nuicáca: Péemìacué itàacái”, íimaca yái Diosca. ");
INSERT INTO pioNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Yáta naicáidaca natéesewa, níái yéewáidacaléca. Yá canácata naiquéeri áibanáica. Naicá abéerita Jesús ibàluèricawa néeni. ");
INSERT INTO pioNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Néesetécáwa idècunitàacá nalicùacawa dúli íinatáise, Jesús yàalàaca nía ipíchaná nacàlidaca áibanái iríni, yái naiquéericaté dúli íinatalé, àta Jesús imichàacatalétawa yéetácáisi íicha, yái asìali Dios néeséerica. ");
INSERT INTO pioNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Iná càmita nacàlida áibanái iríni, quéwa nasutáca néemìawa níawáaca ìwali càinácaalí íimáaná yái tàacáisi íiméerica icáucàanápinásawa. ");
INSERT INTO pioNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Néese nasutáca néemìawa Jesús: —‍Níara yéewáidéeyéica wenàiwica templo irìcu náimaca iwàwacutáanása profeta Elías yèepùa yàanàaca quéechacáwa aléi èeri irìculé àniwa ipíchawáise israelita icuèrinápiná yàanàaca, yái wacuèrináca Dios ibànuèripináca walí. ¿Cáná yéewa cài náimaca, níái yéewáidéeyéica wenàiwica templo irìcu? —‍náimaca. ");
INSERT INTO pioNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Néese Jesús icàlidaca nalí Juan el Bautistami ìwali: —‍Báisíta, iwàwacutáca profeta Elías nacáiri yàanàaca quéechacáwa. Yá iwènúadaca wenàiwicanái íiwitáise Dios irípiná àniwa, yéewanápiná néemìaca itàacái yái israelita icuèrinápináca Dios ibànuèrica nalí. Aiba wawàsi nacái israelita icuèrinápiná ìwali, iwàwacutácué píináidacawa ìwali yái tàacáisi profetanái itànèericaté nuináwaná ìwali, núa asìali Dios néeséerica. Natànàacaté tàacáisi nuináwaná ìwali píalíacaténácuéwa iwàwacutáanápiná nùuwichàacawa manuísíwata, israelitanái nacái caná nuwèni naicáanápiná núa, báawapiná nacái naicáca núa. ");
INSERT INTO pioNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Quéwa núumacué pirí, abéeri profeta Elías nacáirimi idéca yàanàaca, yái Juan el Bautistamica. Yá namànicaté irí báawéeri iyúwaté nawàwáaná, càide iyúwaté profetanái itànàanáté tàacáisi iináwaná ìwali càinácaalíté ìyáanápiná —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Néeseté Jesús, nía nacái yáapichéeyéica, nèepùacawa Jesús yéewáidacalénái áibanái yàatalé. Yá naicáca manùba wenàiwica Jesús yéewáidacalénái itéese. Nàyaca nacái néré abénaméeyéi yéewáidéeyéica wenàiwica templo irìcu. Níái yéewáidéeyéica wenàiwica, nía nacái Jesús yéewáidacaléca natàaníca nàyaca nalíwáaca ùuléeri wawàsi iyú. ");
INSERT INTO pioNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Néese wenàiwicanái iicáca Jesús, yá macáita napìacawa íipunita natàidacaténáni, máiníiyéi íináidacawa iicáidaca Jesús irí. ");
INSERT INTO pioNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Néese Jesús isutáca yéemìawa yéewáidacalénáiwa: —‍¿Càinácué ìwali pitàaní piríwáaca chàinisíiri iyú, píacué nacái nía nacáide? —‍íimaca nalí. ");
INSERT INTO pioNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Yá abéeri néená níái wenàiwica ìyéeyéica néré íimaca Jesús irí: —‍Nuíwacali, nudéca nutéca pìatalé nuìriwa demonio idacuèri íiwitáise. Yái demonioca masànaca imànica nuìri. ");
INSERT INTO pioNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Ata alénácaalí nuìri ìyaca, yá demonio yàaca irí tèwacáimi, yá yúucaca nuìri cachàiníiri iyú cáli íinatalé, yá cacàlica inùmalìcuíse yái nuìrica, yá nacái yaamíadaca iyéiwa, yá pumùluca iiná macáita. Nudéca nusutáca péewáidacalénái íicha wawàsi náucáanápiná demonio nuìri íicha, quéwa càmita náalimá náucaca íichani —‍íimaca yái yáanirica. ");
INSERT INTO pioNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Néese Jesús íimaca: —‍¡Píacué càmíiyéica yeebáida Dios! ¿Càinácué èeri iwàwacutá nùyacuéca píapicha quiríta? ¿Càinácué èeri iwàwacutá numànicuéca pirí quiríta? Pìanàidacué nùataléni yái ùuculìirica —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Yá natéca ùuculìiri Jesús yàatalé. Quéwa demonio iicácanáami Jesús, yá demonio yàaca tèwacáimi ùuculìiri irí. Yá ùuculìiri yúuwàacawa cáli íinatalé. Yá italíanícawa, cacàlica inùmalìcuíse. ");
INSERT INTO pioNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Néese Jesús isutáca yéemìawa ùuculìiri yáaniri: —‍¿Càisimaléná èeri idé idènìacani íisacadénáamini? —‍íimaca yái Jesúsca. Néese yáaniri íimaca Jesús irí: —‍Sùmàicaalítàacáwani idàbaca íisacani bàaluité. ");
INSERT INTO pioNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Manùba yàawiría nacái demonio yúucacani quichái irìculé, úni yáaculé nacái inúacaténáni. Quéwa, pidécaalísica pichùnìacani, néese piicá watúulécaná, yá piyúudàaca wía —‍íimaca yái yáanirica. ");
INSERT INTO pioNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jesús íimaca irí: —‍¡Picá cài píimaca ‘pidécaalísica’! Iwàwacutá manuíca píináidacawa piwàwawa nùwali. Aibacaalí yeebáida nulí, Dios imànipiná irí macái íiwitáaná cayábéerica —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Yá ùuculìiri yáaniri íimaca cachàiníiri iyú Jesús irí: —‍Nuebáidaca pirí. ¡Piyúudàa nuebáidacaténá pirí cachàiníiri iyú mamáalàacata! —‍íimaca yái yáanirica. ");
INSERT INTO pioNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Néese Jesús iicácáiná madécaná wenàiwica nàwacáidáyacacawa yàatalé caquialéta, íná yàalàaca demonio cachàiníiri iyú. Jesús íimaca demonio irí: —‍Pía demonio, matàacáirica màuwíirica nacái imànica wenàiwica, pìawa íicha yái ùuculìirica. Picá pèepùa piwàlùacawa àniwa iwàwalìculé —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Yá demonio yéemíanícawa, yàaca tèwacáimi ùuculìiri irí àniwa, yá imàacaca ùuculìiri itatácawa cachàiníiri iyú àniwa. Néese yàacawa ùuculìiri íicha, yá ùuculìiri irìacáitawa cáli íinatalé càide iyúwa yéetéerimiwa. Iná madécaná náimaca ùuculìiri yéetácasawa. ");
INSERT INTO pioNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Quéwa Jesús íibàaca icáapi ìwali imichàidacaténáni. Yá ibàlùacawa yái ùuculìirica. ");
INSERT INTO pioNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Néesetécáwa Jesús iwàlùacawa capìi irìculé yéewáidacalénái yáapichawa méetàucuta áibanái íicha. Yá nasutáca néemìawa Jesús: —‍¿Cánácáwa càmita wadé wáucaca demonio? —‍náimaca. ");
INSERT INTO pioNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Yá Jesús íimaca nalí: —‍Máinícué càulenáca piúcaca yái demonio íiwitáanáca. Iwàwacutácué pisutáca píawawa Dios íicha quéechacáwa, pimàacacué píichawa nacái piyáacaléwa, pidéenápinácué piúcacani wenàiwica íicha —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Néese Jesús yàacatéwa náicha yéewáidacalénái yáapichawa. Yá nèepunícawa Galilea yàasu cáli íinatabàa. Jesús càmita iwàwa áibanái yáalíacawa alénácaalíni. ");
INSERT INTO pioNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Jesús yéewáidacáiná yàacawa yéewáidacaléwa. Yá icàlidaca nalíni: —‍Abénaméeyéi wenàiwica presopináca namànica núawa namàacacaténá áibanái asìanái inúaca núa, núa asìali Dios néeséerica. Yá nanúapiná núawa. Quéwa máisiba èeri irìcu, yásí nucáucàacawa àniwa —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Quéwa níái yéewáidacaléca càmita náalía néemìaca càinácaalí íimáaná yái tàacáisi Jesús icàlidéerica nalí. Yá cáaluca nasutáca néemìawani ìwali. ");
INSERT INTO pioNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Néeseté nàanàaca Capernaum ìyacàlená néré. Yá nawàlùacanáamiwa capìi irìculé, yá Jesús isutáca yéemìawa nía: —‍¿Càiná wawàsi ìwalicué pitàaní siùcatàacáwa idècunitàacá pèepunícawa àyapulìcubàa? —‍íimaca nalí. ");
INSERT INTO pioNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Masànata quéwa nía Jesús íicha báicáiná nía náiwitáise báawéeri ìwalíisewa, natàanícáináté chánácaalí néená máiníiri cachàinica áibanái íicha canánama. ");
INSERT INTO pioNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Néese Jesús yáawinacawa, yá imáidaca yàataléwa yéewáidacalénáiwa. Yá íimaca nalí: —‍Aibacaalí iwàwa Dios iicácani iyúwa cachàiníirica áibanái íicha canánama, iwàwacutá yái wenàiwica iicáca yáawawa iyúwa càmíiri cachàini náicha canánama. Iwàwacutá nacái iyúudàaca nía áibanái canánama —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Néese Jesús yeedáca sùmài ibàlùadacaténáni nèewi. Yá Jesús yeedáca sùmài yàanalìculéwa. Yá íimaca yéewáidacalénái iríwa: ");
INSERT INTO pioNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","—‍Cawinácaalí wenàiwica yeebáidéerica nutàacái, imànicaalí cayábéeri sùmài irí nuípidená ìwali, càiride iyúwa yái sùmàica, yásí nuicáca yái cayábéerica imàníirica sùmài irí càide iyúwa idéca nacáicaalí imànica nulí cayábéeri. Càmita imàni abéerita nulí cayábéeri, néese imànica nacái irí cayábéeri yái Diosca ibànuèrica núa —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Néeseté Juan íimaca Jesús irí: —‍Wáiwacali, wadéca waicáca áiba yúuquéeri demonio wenàiwica íicha píipidená ìwali íimacáiná pimàacasaca cài imànica, quéwa càmita yèepuníwa wáapicha, íná wadéca wàalàacani cachàiníiri iyú ipíchaná yúucaca demonio wenàiwica íicha —‍íimaca yái Juanca. ");
INSERT INTO pioNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Néese Jesús íimaca nalí: —‍Picácué pìalàa wenàiwica càmíinápiná namàni cayábéeri, canácáiná yáaliméeri itàaníca báawéeri iyú nùwali idécanáami imànica nuípidená ìwali yái càmíirica wenàiwica idé imànica, icàlidacaalí nacái iináwanáwa imàníinása cài nuíwitáise iyú. ");
INSERT INTO pioNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Macáicáiná càmíiyéita yùuwideca imànica wía, nayúudàaca wía. ");
INSERT INTO pioNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Péemìacué cayába, áibacaalícué iyúudàaca pía peebáidacáiná nutàacái, núa Cristoca, éwita yáalimácaalí yàaca pìiraca úni yáawami, càicáaníta Dios imànipiná irí cayábéeriwa —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Jesús íimacaté: “Aibacaalí iméeràidaca nùasu wenàiwica namànicaténá nabáyawanáwa, níái púubéeyéica yeebáidéeyéica nutàacái, yásí Dios yùuwichàidapináca manuísíwatani. Cayába cachàini irítáni yéetácaalíwatá ipíchawáise iméeràidaca sùmanái. Aibanái idacùacaalí manuíri íba icanápi ìwalíise náucacaténáni manuíri úni yáaculé isawíacaténáwa, yásí ìisicùmacawa. Quéwa ìyacaalí mamáalàacata chái èeri irìcu, néese iméeràidacaalí sùmanái namànicaténá nabáyawanáwa, yá máiní cachàiníwanái yùuwichàapinácawa áibanái íicha infierno irìcu, yái manuíri quicháica. Iná cayába cachàini irítáni yéetácaalíwatá ipíchawáise iméeràidaca púubéeyéi. ");
INSERT INTO pioNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Iná piwàwacaalí pimànica pibáyawanáwa picáapi iyúwa, yá piúca píichawa píiwitáise báawéeriwa, ipíchaná pimànica pibáyawanáwa, càide iyúwa wenàiwica iwichùacaalí icáapiwa ipíchaná imànica ibáyawanáwa icáapi iyúwa. Càita nacái iwàwacutá piúcaca píichawa píiwitáise báawéeriwa, yéewanápiná pidènìaca picáucawa càmíiri imáalàawa, ipíchaná nacái pìacawa infierno irìculé, yái manuíri quicháica càmíirica ichacàwa càiripinéerita ìyaca. ");
INSERT INTO pioNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Infierno irìcu canácatáita cáwi yéetáwa néré, níái cáwi iyéeyéica nainá yáaséerica, càmicatalé nacái quichái ichacàwa càiripináta. ");
INSERT INTO pioNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Piwàwacaalí pimànica pibáyawanáwa pìabàli iyúwa, pìanápináwa áibalé càmicataléca Dios iwàwa pìacawa, yá piúca píichawa píiwitáise báawéeriwa, ipíchaná pimànica pibáyawanáwa, càide iyúwa wenàiwica iwichùacaalí yàabàliwa ipíchaná imànica ibáyawanáwa yàabàli iyúwa. Càita nacái iwàwacutá piúcaca píichawa píiwitáise báawéeriwa, yéewanápiná pidènìaca picáucawa càmíiri imáalàawa, ipíchaná nacái Dios yúucaca pía infierno irìculé, yái manuíri quicháica càmíirica ichacàwa càiripinéerita ìyaca. ");
INSERT INTO pioNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Infierno irìcu canácatáita cáwi yéetáwa néré, níái cáwi iyéeyéica nainá yáaséerica, càmicatalé nacái quichái ichacàwa càiripináta. ");
INSERT INTO pioNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Piwàwacaalí pimànica pibáyawanáwa pituí iyúwa, piicáanápiná wawàsi càmíirica Dios iwàwa piicáca, yá piúca píichawa píiwitáise báawéeriwa, ipíchaná pimànica pibáyawanáwa, càide iyúwa wenàiwica imusúadacaalí ituíwa ipíchaná imànica ibáyawanáwa ituí iyúwa. Càita nacái iwàwacutá piúcaca píichawa píiwitáise báawéeriwa, yéewanápiná pidènìaca picáucawa càmíiri imáalàawa, ipíchaná nacái Dios yúucaca pía infierno irìculé, yái manuíri quicháica càmíirica ichacàwa càiripinéerita ìyaca. ");
INSERT INTO pioNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Infierno irìcu canácatáita cáwi yéetáwa néré, níái cáwi iyéeyéica nainá yáaséerica, càmicatalé nacái quichái ichacàwa càiripináta. ");
INSERT INTO pioNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Dios icasáapiná quichái nàwali macáita. ");
INSERT INTO pioNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Péemìacué comparación: Cayábéeri iwidùma piyáacalé yáapichacué, quéwa càmicaalí quirínama puìwa yái iwidùmaca, yá càmitacué píalimá cayábéerica pimànica àniwani. Càita nacái iwàwacutácué cáinináca piicáyacacawa, càide iyúwa cayábéeri iwidùma puìwacaalí imànica walí wayáacalé. Cáininácué piicáyacawa yéewanápinácué pìyaca matuíbanáiri iyú píapichawáaca”, íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Néeseté Jesús yàacawa Capernaum ìyacàlená íicha yéewáidacalénái yáapichawa. Yá nàacawa Judea yàasu cáli néré, áiba cáli néré nacái ìyéerica oriente iwéré èeri imusúacatáisewa, abéemàalé Jordán inanába íicha. Néré manùbéeyéi wenàiwica ìwacáidáyacacawa àniwa Jesús yàatalé, yá idàbaca yéewáidaca nía àniwa càide iyúwaté íiwitáise ìyáaná. ");
INSERT INTO pioNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Néese abénaméeyéi fariseo nàacawa Jesús yàatalé náalimáidacaténá naicáwani, icàlidáanápiná áiba wawàsi báawéeri, yéewacaténá nacháawàaca iináwaná ìwali itàacái ìwalíisewa. Yá nasutáca néemìawani asáisí cayábacaalí asìali imàaca íichawa íinuwa. ");
INSERT INTO pioNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Jesús íimaca nalí: —‍Picàlidacué nulí càinácaalíté profeta Moisés ichùulìaca pìawirináimi imàníinápiná bàaluité —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Néese náimaca irí: —‍Profeta Moisés imàacacaté asìali yúucaca íichawa íinuwa. Càité iwàwacutá namànica. Quéechacáwa asìali itànàaca cuyàluta irìcu cáná yéewaná iwàwa yúucaca íichawa úa. Néese yàaca ulí yái cuyàlutaca, yéewacaténá úasáidaca áibanái iríni, náalíacaténáwa manìrica úa. Yá ichùulìaca ùanápináwa íicha —‍náimaca irí. ");
INSERT INTO pioNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Néese Jesús íimaca nalí: —‍Bàaluité profeta Moisés imàacacué pimànica cài máinícáinácué báawaca píiwitáise, píacué israelitaca, càmíiyéica iwàwa imànica cayábéeri càide iyúwa Dios ichùulìanácué pía. Imàacacatécué pibànùaca píichawa píinuwa báawacaalícué piicáca úa, ipíchanácué piùwichàidaca úa cachàiníwanái mamáalàacata. ");
INSERT INTO pioNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Quéwa bàaluité Dios càmitaté ibatàa wenàiwicanái imànica cài. Iná báawaca Dios iicáca yái piúcáanácuéca píinuwa siùcade. Profeta Moisés itànàacaté càinácaalíté ìyáaná bàaluité Dios idàbacaalíté wenàiwica. Moisés itànàacaté: ‘Dios idàbacaté idàbáanéeri asìali, idàbáanéechúa inanái nacái. ");
INSERT INTO pioNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Iná siùcade, asìali iwàwacaalí icásàacawa, yásí yàacawa yáaniri íichawa, yáatúa íicha nacáiwa, ìyacaténá abédanamata íinu yáapichawa. ");
INSERT INTO pioNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Iná idécanáami asìali iimáca úapicha, càmita quirínama Dios iicáca nía iyúwa pucháiba wenàiwica, néese Dios iicáca nía iyúwa abéeri wenàiwica’, càité itànàaca yái profeta Moisésca. Iná càmita quirínama pucháibaca nía, néese abéericata nía. ");
INSERT INTO pioNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Iná càmita cayába wenàiwica nèepùadaca náichawáaca nía, níái Dios imàaquéeyéica ìyaca càide iyúwa abéeri wenàiwica —‍íimaca nalí yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Néeseté nàyaca capìi irìcu, yá Jesús yéewáidacalénái nasutáca néemìawani ìwali àniwa yái tàacáisica. ");
INSERT INTO pioNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Néese Jesús íimaca nalí: —‍Asìali imàacacaalí íichawa íinuwa, yá yeedácaalí nacái iríwa íinupináwa áibata, yásí imànica ibáyawanáwa ulí, úái idàbáanéechúaca íinucawa, iimácáiná áiba inanái yáapicha càmíichúaca íinusíwa. ");
INSERT INTO pioNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Càita nacái inanái umàacacaalí uíchawa unìriwa, yá uedácaalí unìripináwa áibata, yásí umànica nacái ubáyawanáwa irí yái idàbáanéeri unìricawa, uimácáiná áiba asìali yáapicha càmíirica unìrisíwa —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Néese wenàiwica natéca néenibewa Jesús yàatalé imàacacaténá icáapiwa nàwali, isutáca nalí Dios íicha imàníinápiná nalí cayábéeri. Quéwa Jesús yéewáidacalénái nadàbaca nacuísaca wenàiwica itéeyéica sùmanái, yéewáidacalénái íimaca sùmanái nasàiwicasa Jesús irí wawàsi. ");
INSERT INTO pioNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Jesús iicáca yái yéewáidacalénái imàníináca, íná báawaca iicáca náiwitáise. Yá íimaca yéewáidacalénái iríwa: —‍Pimàacacué sùmanái yàacawa nùatalé. Picácué pimáisanìa nàanàaca, Dios icùacáiná wenàiwica neebáidacaalí itàacái càide iyúwa sùmanái yeebáidáaná náaniri itàacáiwa. ");
INSERT INTO pioNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Péemìacué cayába, iwàwacutá wenàiwica neebáidaca Dios itàacái càide iyúwa púubéeyéi sùmanái yeebáidáaná náaniri itàacáiwa. Càmicaalí cài wenàiwica neebáida, yá canácatáita Dios yéenibeca nía —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Néese Jesús yeedáca níái sùmanáica yàanalìculéwa. Imàacaca icáapiwa nàwali, yá isutáca nalí Dios íicha imàníinápiná nalí cayábéeri. ");
INSERT INTO pioNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Jesús idàbacaté yèepunícawa àniwa, yá abéeri asìali yàanàaca ipìacawa Jesús yàatalé. Yá ibàlùacawa yùuluì ipùata iyúwa Jesús irí yàacaténá Jesús icàaluíniná. Yá isutáca yéemìawa Jesús: —‍Pía cayábéeri yéewáidéerica wía, ¿càinásica iwàwacutá numànica nùyacaténá càiripináta Dios yáapicha chènuniré? —‍íimaca. ");
INSERT INTO pioNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jesús íimaca irí: —‍Iwàwacutá píináidacawa cayába ìwali yái píimáanáca, càinácaalí íimáaná yái tàacáisi íiméerica cayábéericasa núa, canácáiná áiba wenàiwica cayábéeri, abéericata Dios cayábéeri —‍íimaca irí yái Jesúsca, iwàwacáiná asìali yeebáidaca ìwali, Dioscani yái Jesúsca. Néese Jesús íimaca irí àniwa: ");
INSERT INTO pioNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","—‍Píalíacawa Dios itàacái ìwali profeta Moisés itànèericaté Dios inùmalìcuíse. Càité ichùulìaca nía: ‘Picá pinúa wenàiwica, picá piimá áiba inanái yáapicha càmíichúaca píinusíwa, áiba asìali yáapicha nacái càmíirica pinìrisíwa, picá piyéedùa, picá picàlida pichìwawa, picá nacái pichìwáida áibanái, néese pìa píaniri íimiétacanáwa, píatúa nacáiwa’, cài itànàacaté yái Moisésca —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Néese asìali íimaca Jesús irí: —‍Pía yéewáidéerica wía, nudéca numànica macáita càide iyúwa Dios ichùulìaná wamànica sùmàicatáiseté núa àta siùca nacáide —‍íimaca. ");
INSERT INTO pioNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yá Jesús iicáidaca irí, cáinináca nacái Jesús iicácani, yá Jesús íimaca irí: —‍Iyaca abéeri wawàsi iwàwacutéericáwaca pimànica: Pìa piwéndaca macáita pìasuwa. Néese pìa iwènináami catúulécanéeyéi irí. Càita pidènìapiná pìasu cawèníiriwa chènuniré. Néese pèepùawa pìacaténáwa núapicha iyúwa nuéwáidacalé —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Yái asìalica, idécanáami yéemìacani, yá máiní achúmaca iwàwa, íná yàacawa Jesús íicha, máinícáiná càasucani, càmicáináté nacái iwàwa yàaca áibanái irí macáita yàasuwa. ");
INSERT INTO pioNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Néese Jesús iicáidaca wenàiwica irí ibàluèyéicawa itéese, néese íimaca yéewáidacalénái iríwa: —‍¡Máiní càulenáca càasuíyéi yeebáidaca Dios itàacái, Dios yéenibecaténá nía! —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Yá yéewáidacalénái máiní náináidacawa néemìaca Jesús itàacái, càmicáinátécáwa néemìa càiri tàacáisi, quéwa Jesús íimaca nalí àniwa: —‍Píacué nuénánáica, ¡máiní càulenáca neebáidaca Dios itàacái Dios yéenibecaténá nía, cawinácaalí imàaquéeyéica iwàwawa yàasu cawèníiri ìwaliwa! ");
INSERT INTO pioNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Càide iyúwa camello càmíiná yáalimá iwàlùacawa siduwíapi ituí yáapuí irìcubàa, càita nacái máiní càulenáca càasuíri yeebáidaca Dios itàacái, Dios isùmàirecaténáni, máinícáiná cáinináca càasuíri iicáca yàasuwa Dios íicha —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Idécanáami yéewáidacalénái yéemìacani, yá máiní cachàiníwanái náináidacawa Jesús itàacái ìwali, yá nasutáca néemìawa níawáaca. Yá náimaca nalíwáaca: —‍Néeni, ¿cawinápiná yáalimá iwasàaca yáawawa Dios yàasu yùuwichàacáisi íicha? —‍náimaca nalíwáaca. ");
INSERT INTO pioNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Néese Jesús iicáidaca nalí, yá íimaca nalí: —‍Càmita yéewa wenàiwicanái nawasàaca níawawa Dios yàasu yùuwichàacáisi íicha nachàini iyúwa meedá, quéwa Dios yáaliméeri iwasàaca nía, Dios yáalimácáiná imànica macáita —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Néese Pedro íimaca irí: —‍Wadéca wamàacaca macáita wàasuwa, yá wadéca wàacawa píapicha iyúwa péewáidacalénái —‍íimaca yái Pedroca. ");
INSERT INTO pioNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","30","Jesús íimaca nalí: —‍Péemìacué cayába, píacué nuéwáidacaléca yeebáidéeyéica nutàacái. Numáidacué abénaméeyéi péená nàanápináwa nacapèe íichawa nacàlidacaténá yái cayábéeri tàacáisica èeri mìnanái irí. Aibanái péenácué nacái nàapinácawa néenánái íichawa, càmicaalí nacái náatúa íichawa, càmicaalí nacái néenibenái béeyéi íichawa, càmicaalí nacái náaniri íichawa, càmicaalí nacái nabànacale yàaluná íichawa, neebáidacáiná nutàacái, nacàlidacaténá nacái yái tàacáisi cayábéerica. Quéwa Dios yàapinácué pirí chái èeri irìcu cien imanùbaca yàawiríapiná àniwa picapèepinácué, manùbéeyéi nacái wenàiwica ìyéeyéipinácué pirí càide iyúwa péenánái, píatúanái nacái, péenibe nacái, pidènìapinácué nacái pibànacale yàaluná nacái. Ewita áibanái yùuwichàidacaalícué píawa chái èeri irìcu, peebáidacáinácué nutàacái, càicáaníta áiba èeriwa pìyapinácué càiripináta èeri imáalàacanáamiwa. ");
INSERT INTO pioNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Quéwa manùbéeyéi wenàiwica áibanái iiquéeyéica iyúwa máiníiyéica cachàinica siùcade, càmita máiní cachàini níawa áiba èeriwa. Manùbéeyéi wenàiwica nacái áibanái iiquéeyéica iyúwa càmíiyéica máiní cachàini siùcade, áiba èeriwa yásí máiní cachàiníwanái cachàinica níawa áibanái íicha —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Néeseté nadàbaca nàacawa Jerusalén ìyacàlená nérépiná, yá Jesús yàacawa yéewáidacalénái ipíchaléwa. Jesús yéewáidacalénái icalùadacawa manuísíwata, yá nacái áibanái wenàiwica yèeyéicawa náamiwáise, cáaluca náináidacawa ìwali yái yùuwichàacáisica yàanèeripinácatéwa nàwali Jerusalén ìyacàlená irìcu. Néese Jesús iwènúacawa, imáidaca yàataléwa níái yéewáidacalécawa doce namanùbaca méetàucuta áibanái wenàiwica íicha. Yá idàbaca icàlidaca nalíni càinácaalíté yùuwidenái imàníinápináté irí Jerusalén ìyacàlená irìcu. Yá íimaca nalí: ");
INSERT INTO pioNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Càide iyúwacué piicáaná, wàacawa wàyaca Jerusalén ìyacàlená nérépiná. Aibanái presopináca namànica núawa natécaténá núa sacerdote íiwacanánái yàatalé, nàatalé nacái níái yéewáidéeyéica wenàiwica templo irìcu, núa asìali Dios néeséerica. Yá nachùulìapiná càmíiyéi judío nanúanápiná núa. ");
INSERT INTO pioNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Néese naicáanípiná nuquínináwa, yá nacái nàapìsáidapiná núawa, nacapèedáidapiná núa, yá nanúapináca núa. Quéwa máisiba èeri irìcu, yá numichàapinácawa yéetácáisi íicha”, íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Néeseté Zebedeo yéenibe íipidenéeyéi Santiago, Juan nacái nàacawa Jesús yàatalé. Yá náimaca irí: —‍Wáiwacali, wawàwaca pimànica walí cayábéeri càide iyúwa wasutáanápiná píichawa wawàsi siùcade —‍náimaca. ");
INSERT INTO pioNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Néese Jesús isutáca yéemìawa nía: —‍¿Càinásicué piwàwa numànicuéca pirí? —‍íimaca. ");
INSERT INTO pioNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Náimaca irí: —‍Wawàwaca pimàacaca wáawinacawa píapicha wacùacaténá macái wenàiwica píapicha áiba èeriwa picùacaalípiná macáita píiwitáise cachàiníiri iyúwa. Wawàwaca wáawinacawa píapicha, abéeri yáawinacaténáwa péewápuwáise, abéeri nacái yáawinacawa apáulìcuíse pirí wacùacaténá píapicha macái èeri mìnanái —‍náimaca. ");
INSERT INTO pioNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Néese Jesús íimaca nalí: —‍Càmitacué píalíawa càinácaalí iwàwacutáanápiná pimànica Dios imàacacaténácué pirí yái pisutéericuéca nuícha, picùanápinácué núapicha macái wenàiwica. ¿Píalimásicué piùwichàacawa càide iyúwa nùuwichàanápináwa, iyúwa nacái nuétáanápináwa yéewacaténácué cachàiníiyéica pía càide iyúwacué pisutáaná nuícha? —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Yá náimaca: —‍Wáiwacali, wáaliméerica wamànica —‍náimaca. Néese Jesús íimaca nalí: —‍Báisítacué piùwichàapinácawa càide iyúwa nùuwichàanápináwa, péetápinácuéwa càide iyúwa nuétáanápináwa. ");
INSERT INTO pioNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Quéwa Dios càmita ibatàa numàacapinácué píawinacawa núapicha abéericué péená yáawinacaténáwa nuéwápuwáise, áibacué péená nacái yáawinacawa apáulìcuíse nulí, picùacaténápinácué núapicha macái wenàiwicata, yácáináta Dios imàacapiná nalíni, cawinácaalí wenàiwicanái Dios íináidéeyéicatéwa náawináanápináwa núapicha wacùacaténá macái wenàiwica —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Néese yéewáidacalénái áibanái diez namanùbaca, néemìacaalíté càinácaalí nasutáaná Jesús íicha wawàsi, yá calúaca nía pucháiba asìanái yáapicha, níái Santiago, Juan nacái. ");
INSERT INTO pioNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Quéwa Jesús imáidaca yàataléwa nía macáita. Yá íimaca nalí: —‍Píalíacuécawa naináwaná ìwali, níái càmíiyéica judío icuèyéica yàasu cáli néeséeyéiwa, casíimái nacùaca wenàiwica cachàiníiri iyú. Píalíacué nacáiwa casíimáica náiwacanánái nachùulìaca áibanái wenàiwica. ");
INSERT INTO pioNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Quéwa iwàwacutácué càmita pìya càide iyúwa nàyáaná. Néese cawinácaalí péenácué iwàwéerica Dios iicácani càiride iyúwa cachàiníirica íiwitáise, iwàwacutá iyúudàacuéca pía macáita. ");
INSERT INTO pioNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Cawinácaalí péenácué iwàwéerica Dios iicácani càiride iyúwa cachàiníirica áibanái íicha, iwàwacutá íibaidacuéca pirí macáita càide iyúwa yàasu wenàiwica íibaidáaná íiwacali iríwa. ");
INSERT INTO pioNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Iwàwacutácué cài pimànica, núacáiná, núa asìali Dios néeséerica, éwitacué Píiwacalicáaníta núa, càicáaníta càmita nùanàa náibaidacaténá nulí meedá. Néese nudéca nùanàaca nuíbaidacaténá áibanái wenàiwica irípiná, numàacacaténá nacái nucáucawa nuwasàacaténá manùba wenàiwica Dios yàasu yùuwichàacáisi íicha yàanèeripinácawa nàwali nabáyawaná ìwalíisewa —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Nàanàacaté Jericó ìyacàlená néré. Néesetécáwa Jesús yàacawa yàcalé irìcuíse, yá yéewáidacalénái yàacawa yáamiwáise, manùbéeyéi wenàiwica nacái nàacawa náapicha. Matuíri asìali ìyaca néeni, íipidenéeri Bartimeo, íimáanáca Timeo ìiri, yáawinéericawa àyapu idùlepi isutéerica plata wenàiwicanái íicha ichàbéeyéicawa néenibàa, yéewanápiná iwènìaca iyáapináwa. ");
INSERT INTO pioNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Bartimeo yéemìaca náimaca Jesús Nazaret ìyacàlená néeséerica yái cài ichàbacawa chábài, yá matuíri idàbaca imáidaca Jesús irí: —‍¡Jesús, rey David itaquérinámi, Dios ibànuèrica walí wacuèrinápiná, piicá nupualé! —‍íimaca. ");
INSERT INTO pioNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Madécaná wenàiwica icuísacani yái matuírica masànáanápináni, quéwa imáidaca quéwanáta mamáalàacata cachàiníiri iyú: —‍¡Pía, rey David itaquérinámica, Dios ibànuèrica walí wacuèrinápiná, piicá nupualé! —‍íimaca. ");
INSERT INTO pioNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Iná Jesús iyamáaca ibàlùacawa, yá íimaca wenàiwicanái irí: —‍Pimáidacué nùataléni —‍íimaca yái Jesúsca. Iná namáidaca matuíri, yá náimaca irí: —‍Picá achúma piwàwa, pimichàawa, pìanáwa yàatalé; imáidaca ìyaca pía —‍náimaca. ");
INSERT INTO pioNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Yáta matuíri yúucaca íichawa yàasu ruana nacáiriwa yúuquéeri ìwalíisewa, yéewacaténá ipìacawa, yá ipisìaca ibàlùacawa, yàacawa Jesús yàatalé. ");
INSERT INTO pioNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Jesús isutáca yéemìawani: —‍¿Càinásica piwàwa numànica pirí? —‍íimaca yái Jesúsca. Yá matuíri íimaca: —‍Nuíwacali, nuwàwaca pimàacaca catuíca núa —‍íimaca. ");
INSERT INTO pioNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Jesús íimaca irí: —‍Pìawa matuíbanáita, Dios idéca ichùnìaca pía peebáidacáiná nuchùnìanápiná pía —‍íimaca yái Jesúsca. Yáta matuírimi iicáidaca àniwa, yá yàacawa Jesús yáapicha àyapulìcubàa. ");
INSERT INTO pioNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Jesús yàanàacaté néré yéewáidacalénái yáapichawa mawiénita Jerusalén ìyacàlená irí. Nàyacaté bamuchúamibàa náicha pucháiba yàcalé íipidenéeyéica Betfagé, Betania nacái, ìyéeyéica mawiénita dúli irí íipidenéechúa Olivos, yái olivo inàlimanáca. Jesús ibànùaca ipíchaléwa pucháiba yéewáidacaléwa, idécanáami cài íimaca nalí: ");
INSERT INTO pioNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","—‍Pìacuéwa irìculé yái yàcaléca ìyéerica wapíchalé. Piwàlùacuéwa néré, yá pìanàapinácué burro nadacuèrica néré, canéeritàacáwa wenàiwica yèeriwa íinata. Piwasàacuéni, pitécué nulíwani. ");
INSERT INTO pioNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Aibacaalícué isutá yéemìawa píawa cánácué yéewa piwasàacani, picàlidacué iríwani nuwàwacutácani, núa Píiwacalicuéca, nubànùanápiná nacái wenàiwica natécaténá burro nàatalé àniwa caquialéta —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Néese níái yéewáidacaléca pucháiba nàacawa yàcalé irìculé, yá nàanàaca burro nadacuèrica ibàlùacawa bàacháwalé calle irìcubàa, mawiénita capìi inùma irí. Yá nawasàacani. ");
INSERT INTO pioNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Abénaméeyéi wenàiwica ìyéeyéica néeni nasutáca néemìawa nía: —‍¿Càinácué pimàni chái? ¿Cánácué piwasàa burro? —‍náimaca. ");
INSERT INTO pioNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Yá yéewáidacalénái icàlidaca nalíni càide iyúwa Jesús íimáanáté nalí, íná wenàiwica imàacaca natéca burro. ");
INSERT INTO pioNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Nalìada nàasu ruana nacáiriwa burro iwaalírìcubàa, yéewanápiná Jesús yàalubáicani, yá natéca burro Jesús yàatalé. Néese Jesús imichàa yáawinacawa burro íinata. ");
INSERT INTO pioNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Idècunitàacá Jesús yàacawa Jerusalén ìyacàlená nérépiná, yá manùbéeyéi wenàiwica nalìada nàasu ruana nacáiriwa Jesús ipíchalé àyapulìcubàa nàacaténá Jesús icàaluíniná. Aibanái nacái irìada wisìri nacáiri ibáiná àyapulìcubàa, yái báinási nawichuèrica manacúalibàa, burrocaténá ìipìna íinatabàa càide iyúwaté náiwitáise nàanápiná nacuèriná icàaluínináwa. ");
INSERT INTO pioNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Yá macáita wenàiwica yèeyéicawa Jesús ipíchalé, áibanái nacái yèeyéicawa yáamiwáise namáidaca casíimáiri iyú: —‍¡Wàacué Dios irí cayábéeri! ¡Cayábéeriquéi Wacuèrináca, yái wenàiwica Dios ibànuèrica walí, icùacaténá wía! ");
INSERT INTO pioNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","¡Dios imànica irí cayábéeri yái yàanèerica icùacaténá wía càide iyúwaté wàawirimi rey David icùanáté wàasu cáli! ¡Wàacué irí cayábéeri, yái Dios chènuníiséerica! —‍náimaca namáidaca nàacawa casíimáica nía. ");
INSERT INTO pioNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Jesús iwàlùacawa Jerusalén ìyacàlená irìculé, yá yàacawa templo néré. Iicáca macáita yái namàníináca templo irìcu. Néese yàacawa Betania ìyacàlená néré yéewáidacalénái yáapichawa doce namanùbaca, táicacáináté yàacawa. ");
INSERT INTO pioNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Néese mapisáita àniwa, Jesús yàacawa Betania ìyacàlená íicha yéewáidacalénái yáapichawa, yá máapicani yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Yá iicáca déecuíse higuera yéetaná idènièrica ibáináwa. Yá Jesús yàacawa néré icutácaténá ìyacaalí higuera ìyacaná nacái. Quéwa canáca ìyacaná, idènìacáita ibáiná meedáwa, càmicáiná higuera yàasu èeri càyacanáanápinátáni. ");
INSERT INTO pioNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Néese Jesús íimaca àicu irí: —‍¡Càmita quirínama càyacanáca píawa! —‍íimaca yái Jesúsca, yáasáidacaténá yéewáidacalénái iríwa Dios yùuwichàidáanápináté israelitanái. Yá yéewáidacalénái yéemìaca tàacáisi Jesús icàlidéerica àicu irí. ");
INSERT INTO pioNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Nàanàacaté Jerusalén ìyacàlená irìculé, yá Jesús iwàlùacawa templo ibàacháwalená irìculé. Yá idàbaca imusúadaca wenàiwica templo ibàacháwalená irìcuíse, macáita iwéndéeyéicaté yàasusi, áibanái nacái iwènièyéica yàasusi templo ibàacháwalená irìcu. Itamàaca yúucawa náicha nàasu mesa canánama, níái icambiéyéica plata wenàiwica íicha needácaténá nalíwa plata. Jesús itamàaca yúucawa náicha nàalubáica áibanái iwéndéeyéica unùcu sacrificio pinéerica. ");
INSERT INTO pioNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Càmita nacái ibatàa wenàiwica yèepunídaca iwéndawa yàasusi templo ibàacháwalená irìcubàa. ");
INSERT INTO pioNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Yá idàbaca yéewáidaca wenàiwica néré. Iimaca nalí: —‍Píalíacuécawa tàacáisi ìwali profeta itànèericaté Dios inùmalìcuíse. Dios íimacaté yàasu templo ìwaliwa: ‘Yái nucapèeca nasutácàalupináca nuícha, macái èeri mìnanáica’, íimacaté yái Diosca. Quéwa, pidécuéca piwènúadaca cayéedéeyéi icapèe iyúni, yái temploca, piyéedùacáinácué plata wenàiwica íicha pichìwa iyúwa —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Néese sacerdote íiwacanánái, nía nacái yéewáidéeyéica wenàiwica templo irìcu néemìacáiná yái tàacáisi Jesús icàlidéerica nàwali, yá nawàwa nanúacani. Yáté nadàbaca náináidacawa càinápinácaalí iyú náalimáaná nanúaca Jesús, cáalucáiná naicácani, máinícáiná cayába macái wenàiwica yéemìaca Jesús yéewáidáanáca nía íiwitáise cachàiníiri iyúwa. ");
INSERT INTO pioNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Quéwa catácáináté yàacawa, íná Jesús imusúacawa yàcalé irìcuíse yéewáidacalénái yáapichawa. ");
INSERT INTO pioNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Néeseté amaláca nawicáu mapisáináami àniwa, yá nàaca nachàbacawa mawiénita higuera yéetanámi irí. Yá naicáca àicumica chuìcani báawanama macáita, ipìchumi nacái. ");
INSERT INTO pioNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Yá Pedro iwàwalica tàacáisi Jesús icàlidéericaté higuera yéetaná irí, yá Pedro íimaca Jesús irí: —‍Wáiwacali, piicá higuera yéetanámi piùwichàidéerimica. Idéca chuìcani —‍íimaca yái Pedroca. ");
INSERT INTO pioNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Néese Jesús íimaca nalí: —‍Iwàwacutácué peebáidaca Dios irí imàníinápinácué pirí càinácaalícué cayábéeri pisutéericuéca íicha. ");
INSERT INTO pioNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Péemìacué cayába, cawinácaalí cài íimaca yái dúli irí: ‘Pimichàawa, picaláawa manuíri úni yáaculé’, íimacaalí, yeebáidacaalí nacái manuísíwata macáita ichàbáanápináwa càide iyúwa isutáaná Dios íicha wawàsi, yásí Dios imànica iríwani. ");
INSERT INTO pioNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Iná núumacué pirí càinácaalí cayábéeri wawàsi pisutéericuéca Dios íicha imàníinápinácué pirí, yá peebáidacaalícué manuísíwata càide iyúwa Dios idéca nacáicaalí imànicuéca piríni, yásí Dios imànicuéca piríwani. ");
INSERT INTO pioNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Pisutácaalícué pìacawa Dios íicha, yá áiba wenàiwica imànicaalíté pirí báawéeri, pimàacacué piwàwawa íicha yái báawéerica imàníiricaté pirí, yéewanápinácué Píaniri Dios chènuníiséeri imàacaca iwàwawa pibáyawaná íichacuéwa. ");
INSERT INTO pioNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Quéwa, càmicaalícué pimàaca piwàwawa íicha yái báawéerica áibanái imàníiricuéca pirí, càmitacué nacái Wáaniri Dios chènuníiséeri imàaca iwàwawa pibáyawaná íichawa —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Néeseté nèepùacawa Jerusalén ìyacàlená néré. Yá idècunitàacá Jesús ìipináaníca templo irìcu, yá sacerdote íiwacanánái, nía nacái yéewáidéeyéica wenàiwica templo irìcu, nía nacái judío íiwacanánái béeyéica nàacawa Jesús yàatalé, yá nasutáca néemìawa Jesús. ");
INSERT INTO pioNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Yá náimaca irí: —‍¿Cawiná ibànùa pía pimusúadáanápiná wenàiwica templo ibàacháwalená irìcuíse, níái iwéndéeyéica yàasusi? ¿Cawiná ichùulìa pía pimusúadáanápiná nía? —‍náimaca. ");
INSERT INTO pioNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","30","Néese Jesús íimaca nalí: —‍Núa nacái nuwàwa nusutácuéca nuémìawa pía: ¿Cawiná ichùulìaté Juan ibautizáanápináté wenàiwica, Diossica? ¿Wenàiwicanáisica? Píimacué nulí càiríinácaalí náicha ichùulìacaté Juan ibautizáanápiná wenàiwica. Picàlidacué nulíni. Picàlidacaalícué nulíni, yásí nucàlidacué nacái piríwani cawinácaalí ichùulìaca núa numusúadáanápiná wenàiwica templo ibàacháwalená irìcuíse, níái iwéndéeyéica yàasusi —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Néese nadàbaca natàaníca nalíwáaca. Náimaca: “Wáimacaalí irí Dios ichùulièriquéera Juan, yásí isutáca yéemìawa wíatá: ‘Néeni, ¿cánácué càmita peebáidani?’ càipiná íimaca walí. ");
INSERT INTO pioNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Càmita nacái wawàwa wáimaca irí wenàiwica ichùulièriquéera Juan”, cài náimaca nalíwáaca, cáalucáiná nía wenàiwicanái íicha, macáita wenàiwica neebáidacáiná Juan itàanícaté báisíiri iyú Dios inùmalìcuíse. ");
INSERT INTO pioNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Iná nacàlidaca Jesús iríni: —‍Càmita wáalíawa —‍náimaca. Néese Jesús íimaca nalí: —‍Càita nacái càmitacué nucàlida piríni cawinácaalí ichùulìaca núa numusúadáanápiná wenàiwica templo ibàacháwalená irìcuíse níái iwéndéeyéica yàasusi —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Néeseté Jesús yéewáidaca nía comparación iyú. Yá íimaca nalí: “Abéeri asìali idènìacaté ibànacale yàalunáwa uva ibànacalená yàalupiná. Yá ibànaca uva. Néese imànica iwáiná ibànacale itéesebàawa. Yá íicaca íba irìculé imànicaténá utàwi nacáichúa uva ìyacaná yàalupiná, napisùacatalépiná uva ituní. Néese imànicaté chènuníiri capìi naicáidacatáisepiná macáita uva ibànacalená yàalu, ipíchaná cayéedéeri iwàlùacawa néré. Yá imàacaca áibanái icuèyéipiná irí yàasu uva ibànacalená yàalunáca, quéwa iwàwacutá nabànùaca irí yàasu uva ìyacaná yéenápiná yàasu èerita, needácatáipináté ìyacaná. Idécanáami imànica náapicha càiri wawàsi, néese yàacawa náicha áibalépiná. ");
INSERT INTO pioNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Néeseté uva yàasu èeri yàanàaca needácaténá uva ìyacaná, yá bànacalé íiwacali ibànùaca yàasu wenàiwicawa néré. Ibànùaca néréni icutácaténá icuèyéi íicha bànacalé íiwacali yàasu uva ìyacaná yéenápiná. ");
INSERT INTO pioNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Quéwa níái icuèyéica bànacalé yàaluná náibàacani, nacapèedáidacani, yá nachùulìaca yàacawa náicha, càmita nabànùa yáapicha uva ìyacanáca. ");
INSERT INTO pioNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Yá bànacalé íiwacali ibànùaca nàatalé àniwa yàasu wenàiwicawa áibata. Yá náibàacani. Yá namànica icháuná íiwita ìwali. Yá namànica irí báawéeri manuísíwata. ");
INSERT INTO pioNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Yá bànacalé íiwacali ibànùaca yàasu wenàiwicawa áibata àniwa. Yá nanúacani. Néesecáwa íiwacali ibànùaca mamáalàacata yàasu wenàiwicawa áibanái àniwa manùbéeyéi. Yá níái icuèyéica uva ibànacalená nacapèedáidaca abénaméeyéi, nanúacaté nacái áibanái. ");
INSERT INTO pioNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“Néeseté yái bànacalé íiwacalica idènìacaté ìiriwa abéerita, yáta máiní cáininéerica yáaniri iicáca. Atata bànacalé íiwacali ibànùaca nàatalé ìiriwa, íimacáiná íináidacawa iríwa yái bànacalé íiwacalica: ‘Báisíta nàapináca nuìri íimiétacanáwa’, íimaca íináidacawa iríwa. ");
INSERT INTO pioNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Quéwa níái icuèyéica uva ibànacalená náimacaté nalíwáaca: ‘Yáara bànacalé íiwacalica yéetápinácaalíwa, yásí yàaca uva ibànacalená ìiri iríwa. Ara, wàacuéwa wanúanáni. Yásí wíacata bànacalé íiwacanánái’, náimaca nalíwáaca. ");
INSERT INTO pioNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Càita náibàacani, yá nanúacani. Yá náucacaté ichéecami uva ibànacalená yèewíise. ");
INSERT INTO pioNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“Siùca nucàlidacué pirí càinácaalí bànacalé íiwacali imàníinápiná nalí, níái icuèyéicaté bànacalé. Yàanàapiná nàataléwa, yá inúapiná níawa. Néese imàacapiná áibanái icùaca irí uva ibànacalená. ");
INSERT INTO pioNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","“Pidécuéca piléeca áiba comparación Dios yàasu profeta itànèericaté Dios inùmalìcuíse. ¿Cánácué càmita peebáida itàacái? Itànàacaté Dios ibànùanápináté israelita icuèrinápiná, quéwa íimaca báawáanápináté naicácani. Càité profeta itànàaca: ‘Níái imàníiyéica íba icapèená, nadéca náucaca abéeri íba méetàuculé náichawa, caná iwènicáiná naicácani. Quéwa Wacuèriná Dios idéca imàacaca máiníiri iwàwacutácawa capìi irípiná yái íba náuquéericaté. ");
INSERT INTO pioNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Dios imànicáiná cài, íná wàaca Dios irí cayábéeri’, càité profeta íimaca nùwali”, íimaca yái Jesúsca, icàlidaca nalí iináwanáwa, yái càiride iyúwa íba, israelita icuèrinápináca. ");
INSERT INTO pioNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Néeseté abénaméeyéi néená níái judío íiwacanánáica nawàwa náibàaca Jesús náucacaténáni presoíyéi ibànalìculé, náalíacáináwa icàlidacaté nàwali yái comparaciónca. Càmíirita quéwa nadé náibàacani, cáalucáiná naicáca níái manùbéeyéi wenàiwicaca cayábéeyéica iicáca Jesús. Iná nàacawa Jesús íicha. ");
INSERT INTO pioNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Néeseté judío íiwacanánái ibànùaca abénaméeyéi fariseo nàacaténáwa Jesús yàatalé, áibanái nacái cayábéeyéi iicáca rey Herodes íiwitáise. Nawàwacaté nasutáca néemìawa Jesús càulenéeri wawàsi ìwali, náalimáidacaténá naicáwani icàlidáanápiná báawéeri iyúni yéewanápiná nacháawàaca iináwaná ìwali romanonái yàasu gobierno íiwacanánái irí. ");
INSERT INTO pioNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Yá nàacawa Jesús yàatalé, yá náimaca irí cáimiétaquéeri iyúta: —‍Pía, yéewáidéerica wenàiwica, wáalíacawa pitàaníca báisíiri iyú, càmita nacái cáalu pía wenàiwica íicha càmicáiná pimàaca áiba wenàiwica caináwanéeyéi iwènúadaca píiwitáise cayábéeri íicha, néese péewáidaca wenàiwica báisíiri iyú nàyacaténá càide iyúwa Dios ichùulìaná nàyaca. Iná picàlida walíni báisíiri iyú ìwali yái wasutéeripináca wéemìawa píawa: ¿Cayábasica wapáyaida wáichawa nía plata iyú níara emperador romanosàiri yàasu gobierno íiwacanánái icuèyéica wàasu cáli, càmicaalí nacái báawasicani? ¿Iwàwacutásica wapáyaidaca wáichawa níara romanoca, càmitasica iwàwacutá wapáyaidaca wáichawa nía? —‍náimaca. ");
INSERT INTO pioNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Quéwa Jesús yáalíacawa càmita báisí nawàwa náalíacawa, nawàwacáita nacháawàaca iináwaná ìwali meedá itàacái ìwalíise. Iná íimaca nalí: —‍¿Cánácué píalimáida piicáwa núa picháawàacaténá nuináwaná ìwali ìwalíise yái núuméerica? Néeni, pitécué nulí moneda nuicácaténáni —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Yá natéca iríni. Néese Jesús íimaca nalí: —‍¿Cawiná yéenáiwaná ichanàawa, cawiná nacái íipidená ichanàawa moneda ìwali? —‍íimaca yái Jesúsca. Náimaca irí: —‍Emperador íipidenáquéi ichanàawa, yéenáiwaná nacái ichanàawa ìwali, yái romano íiwacalináca, icuèrica macái èeri mìnanái —‍náimaca. ");
INSERT INTO pioNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Iná Jesús íimaca nalí: —‍Pipáyaidacué píichawa emperador plata iyú càide iyúwa ichùulìanácué pipáyaidaca. Pimànicué nacái càide iyúwa Dios iwàwáanácué pimànica —‍íimaca yái Jesúsca. Yá máiní náináidacawa néemìaca manuísíwata Jesús íimáaná, càmicáiná náalimá nacháawàaca iináwaná ìwali itàacái ìwalíise. ");
INSERT INTO pioNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Néeseté abénaméeyéi saduceo nàaca naicáca Jesús. Saduceonái náimaca yéetéeyéimiwa càmitasa nacáucàawa áibaalípiná. Saduceonái iwàwacaté wenàiwicanái iicáaníca Jesús iquíniná, íná nasutáca néemìawa Jesús, náalimáidacaténá naicáwani. Yá nacàlidaca irí tàacáisi. Náimaca irí: ");
INSERT INTO pioNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","—‍Pía yéewáidéerica wenàiwica, profeta Moisés itànàacaté tàacáisi Dios inùmalìcuíse íiméerica wíacué judíoca iwàwacutáca cài wamànica: Asìali yéetácaalíwa méenibeta, yásí iwàwacutá yéenásàiri yeedáca iríwa yéenásàiri íinumiwa yàacawéetúapináwa yéewacaténá idènìaca úapicha yéenibewa naiquéeyéipiná iyúwa yéetéerimiwa yéenibemi yéewanápiná nàyaca wenàiwica icuèyéipiná yéetéerimiwa yàasu cáli. ");
INSERT INTO pioNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Uwé, áibaalíté nàyaca siete namanùbaca yéenánái. Yá nabèeri yeedáca íinupináwa. Yá yéetácawa uícha méenibeta. ");
INSERT INTO pioNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Yá iméeréerimi yeedáca úa íinupináwa. Yá yéetácawa uícha méenibeta. Càita nacái iméeréerimi àniwa yeedáca iríwa úa, yá yéetácawa uícha méenibeta. ");
INSERT INTO pioNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Càité níái sietéeyéica imanùbaca needáca úa quéwaté méenibecata néetácawa uícha macáita. Néese uétácawa átata náami. ");
INSERT INTO pioNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Uwé, báisícaalí yéetéeyéimiwa icáucàacawa áibaalípinátá càide iyúwa áibanái íináidáanáwa, néese ¿càinápinásica unìri náicha níái sietéeyéimica? Càmita náalimápiná náalíacawa macáicáináta náinucaté úa —‍náimaca naicáaníca Jesús iquíniná. ");
INSERT INTO pioNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Néese Jesús íimaca nalí: —‍Pidécuéca piméeràacawa báisíiri tàacáisi íicha càmicáinácué píalíawa càinácaalí íimáaná Dios itàacái profetanái itànèericaté Dios inùmalìcuíse. Càmitacué nacái píalíawa Dios íiwitáise ìwali, yái yáaliméerica imichàidaca wenàiwica yéetácáisi íicha. ");
INSERT INTO pioNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Aibaalípiná yéetéeyéimiwa nacáucàapinácawa, quéwa càmita nacásàapináwa, níái asìanáica, inanái nacái, nàyapinácáiná càiwade iyúwa chènuníiséeyéi ángel ìyáaná càmíiyéica icásàawa. ");
INSERT INTO pioNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Aiba wawàsi nacái, piyúunáidacuéca càmita Dios icáucàidapiná wenàiwica áibaalípiná, quéwa pidécuéca piléeca cuyàluta profeta Moisés itànèericaté Dios inùmalìcuíse, íná ¿cánácué càmita píalía péemìaca càinácaalí íimáaná? Moisés ibàlùacatéwa Dios íipunita mawiénita maléenéeri àicu irí yeeméericawa quichái iyú, yá Dios íimacaté Moisés irí: ‘Núacata yái Dios icuèrica Abraham, Isaac nacái, Jacob nacái’, càité íimaca yái Diosca. ");
INSERT INTO pioNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","¡Dios càmita icùa yéetéeyéimiwa ichéeca meedá! ¡Néese Dios icùaca cáuyéi wenàiwica! Iná iwàwacutácué píalíacawa cáuca nía Dios yáapicha, níái Abraham, Isaac, Jacob nacái, éwita néetácáanítatéwa madécaná camuí ipíchawáiseté Moisés ìyaca. Iná yéewa wáalíacawa Dios icáucàidáanápiná yéetéeyéimiwa áibaalípiná. Pidécuéca piméeràacawa máiní déeculé báisíiri tàacáisi íicha —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Abéeri néená níái yéewáidéeyéica wenàiwica templo irìcu yéemìacaté saduceonái isutáaná yéemìawa Jesús, yá nacái yáalíacawa Jesús icàlidacaté nalíni cayábéeri iyú. Néese yàacawa Jesús yàatalé, yá isutáca yéemìawa Jesús: —‍Nàyaca madécaná wawàsi Dios ichùulièrica wamàníinápináca. ¿Càiríiná náicha máiníiri cachàinica náicha canánama wamàníinápiná? —‍íimaca. ");
INSERT INTO pioNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Néese Jesús íimaca irí: —‍Yái Dios ichùulìanáca máiníirica cachàinica náicha canánama wamàníinápiná cài íimaca: ‘Péemìacué, píacué israelitaca. Iyaca abéerita Wacuèrinásàiri, yái Wacuèriná Dios. ");
INSERT INTO pioNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Cáininá piicáca Picuèrináwa Dios macái piwàwalìcuísewa, macái picáuca iyú nacáiwa, macái píiwitáise iyú nacáiwa, macái pichàini iyú nacáiwa’, cài íimaca yái Dios ichùulìanáca máiníirica cachàinica náicha canánama wamàníinápináca. ");
INSERT INTO pioNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Yá pucháibáaná tàacáisi Dios ichùulìanáca máiníiri cachàinica náicha canánama wamàníinápiná cài íima: ‘Cáininá piicáca áibanái wenàiwica càide iyúwa cáinináaná piicáca píawawa’, cài íimaca yái Diosca. Canáca áiba tàacáisi cachàiníiri náicha níái pucháiba tàacáisica —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Néese yái yéewáidéerica wenàiwica templo irìcu íimaca Jesús irí àniwa: —‍Cayábéeri yái picàlidéerica walí, pía yéewáidéerica wía. Pidéca picàlidaca walí báisíiri iyúni. Iyaca abéerita Dios. Canácata íicha áiba. ");
INSERT INTO pioNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Yá nacái cáininácaalí waicáca Dios macái wawàwalìcuísewa, macái wáiwitáise iyú nacáiwa, macái wachàini iyú nacáiwa, yá nacái cáininácaalí waicáca áibanái wenàiwica càide iyúwa cáinináaná waicáca wíawawa, yásí máiní cawènica Dios iicácani náicha macái pìrái íiwitáaná wanuéyéica Dios irí iyúwa sacrificio, macái ofrenda íiwitáaná nacái wamàaquéerica Dios irí neemácaténá sacrificio altar íinata —‍íimaca yái yéewáidéerica wenàiwica templo irìcu. ");
INSERT INTO pioNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Cayábaca Jesús yéemìaca icàlidáanácani, yái yéewáidéerica wenàiwica icàlidacáináténi cáalíacáiri iyú, íná Jesús íimaca irí: —‍Yá batéwata pimàaca Dios icùaca pía —‍íimaca yái Jesúsca. Néese cáaluca macáita níái Jesús yùuwideca. Càmita nawàwa nasutáca néemìawa quirínamani, yái Jesúsca, náalimáidacaténá naicáwani, yéewanápiná nacháawàaca iináwaná ìwali itàacái ìwalíisewa. Cáaluca nasutáca néemìawani, ipíchaná báica nía nacái wenàiwicanái yàacuésemi. ");
INSERT INTO pioNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Idècunitàacá Jesús yéewáidaca wenàiwicanái templo irìcu, yá íimaca nalí: —‍Níara yéewáidéeyéica wenàiwica templo irìcu càmita néewáida nía macái tàacáisi iyú Dios itàacái icàlidéerica Mesías ìwali, yái Picuèrinápinácuéca Dios ibànuèripinácuéca pirí, píacué judíoca. Náimacáita rey David itaquérinámicani. Quéwa rey David íimacaté áiba wawàsi nacái Mesías ìwali. ");
INSERT INTO pioNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Espíritu Santo imàacacaté David itànàaca yái tàacáisica: ‘Nucuèriná Dios íimacaté Nuíwacali irí: Píawinawa nuéwápuwáise picùacaténá núapicha macáita, idècunitàacá numawènìadaca píicha macái piùwidenáiwa, íimaca yái Diosca’, càité íimaca yái Davidca. ");
INSERT INTO pioNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Yái rey David íimacaté Mesías ìwali ‘Nuíwacali’, íná éwita rey David itaquérinámicáanítani, yái Mesíasca, càicáaníta iwàwacutá náimaca ìwali rey David Iiwacali nacáicani —‍íimaca yái Jesúsca, icàlidaca nalí iináwanáwa, yái Mesíasca. ");
INSERT INTO pioNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Idècunitàacá Jesús yéewáidaca nía, yá íimacaté nalí: “Piicácué píichawa níái yéewáidéeyéica wenàiwica templo irìcu. Picácué pìyaca càide iyúwa nàyáaná. Casíimáica nèepunícawa nanáawani cáaléeri yáapichawa, náasáidacaténá nadéca néewáidacawa madécaná èeri, nayúunáidacáiná casíimáica Dios iicáca nía. Nawàwa wenàiwicanái itàidaca nía cáimiétaquéeri iyú bamuchúamibàa yàcalé manùbéeyéi wenàiwica naicácaténá nía. ");
INSERT INTO pioNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Máiní nawàwa náawinacawa cayábéeri yàalubáisi íinata cáimiétacanéeyéi wenàiwica yáawinacatáicawa macái wenàiwica yàacuésemi judíonái yéewáidacàalu irìcu. Nacutá nacái cayábanaméeyéi yàalubáisi cáimiétacanéeri yáawinacatáicawa macái wenàiwica yàacuésemi nayáacaténá nayáacaléwa náapicha, yéewacaténá áibanái naicáca nía iyúwa máiníiyéica cachàinica. ");
INSERT INTO pioNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Níái yéewáidéeyéica wenàiwica templo irìcu nayéedùaca nacái nacapèemi, nàasumi nacái, náicha níái catúulécanéeyéi inanái inìrimi yéetéeyéimicawa íicha. Néese nasutáca Dios íicha déecuíri iyú, yéewacaténá áibanái iyúunáidaca cayábaca náiwitáise. Níacata Dios yùuwichàidéeyéipiná cachàiníiri iyú náicha áibanái cabáyawanéeyéica”, íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Aiba èerité Jesús yáawinacawa templo irìcu, abéemàalé ofrenda yàalu íicha wenàiwica iwàlùadacataléca plata namàaquéerica Dios irí. Yá iicáca wenàiwicanái irìadaca yàasu platawa ofrenda yàalu irìculé namàacacaténáni Dios irí. Yá iicáca madécaná càasuíyéi nalìadaca néré manùba plata. ");
INSERT INTO pioNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Néese inanái yàanàaca néré, catúulécanéechúa, inìrimi yéetéechúamicawa íicha. Yá ulìadaca moneda ofrenda yàalu irìculé, pucháiba moneda cobréeyéi púubéeyéi, càmíiyéica máiní cawènica. ");
INSERT INTO pioNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Néese Jesús imáidaca yàataléwa yéewáidacalénáiwa. Yá íimaca nalí: —‍Péemìacué cayába, úái manìríichúami catúulécanéechúaca udéca umàacaca ùasu ofrendawa Dios iiquéeri iyúwa manuíri iwèni náicha canánama yúuquéeyéica plata ofrenda yàalu irìculé. ");
INSERT INTO pioNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Macáita níái áibanái nàacaté ichàbéericawa meedá, máisibáwanáita nàasu cawèníiri íichawa, quéwa úái catúulécanéechúaca, udéca umàacaca ofrenda Dios irí macáita yái udènièrimica uwènìanápináca uyáacaléwa —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Jesús imusúacatéwa templo íicha, yá abéeri yéewáidacalé íimaca irí: —‍Wáiwacali, ¡piicácáwa níái templo yàasu íba cayábanaméeyéica, nía nacái capìi manuínaméeyéica, cayábanaméeyéi iicácanáwa templo itéeséeyéica! —‍íimaca. ");
INSERT INTO pioNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Quéwa Jesús íimaca irí: —‍Péemìa cayába yái núuméeyéica pirí ìwali, níái capìi manuínaméeyéica. Aibaalípiná canácata capìi yàasu íba yáawinéeripinácawa áiba íba íinata. Macáita níái capìi templo itéeséeyéica namáalàapináta nacáiwa —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Néeseté Jesús yàacawa yéewáidacalénái yáapichawa dúli néré íipidenéechúa Olivos, íimáanáca olivo inàlimaná. Uái dúli ìyéechúaca abéemàise templo íicha. Yá Jesús yáawinacawa. Néese Pedro, Santiago nacái, Juan nacái, Andrés nacái nàacawa yàatalé méetàucuta áibanái íicha. ");
INSERT INTO pioNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Nasutáca néemìawa Jesús càicaalínápinácaalí ichàbawa yái wawàsi Jesús icàlidéericaté nalí templo ìwali, càinácaalí iyú nacái nadépináté náalíacawa templo imáalàanápinácatéwa mesúnamáita. ");
INSERT INTO pioNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Néese Jesús íimaca nalí: “Piicácué píichawa cayába ipíchaná áibanái ichìwáidacuéca pía ipíchawáise èeri imáalàapinácawa. ");
INSERT INTO pioNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Manùbacáiná wenàiwica nàanàapiná icàlidéeyéipiná ichìwawa. Náimapiná núacasa níata. Yá nacàlidapiná nachìwawa. Càipiná náimaca: ‘Núacata yái Mesíasca, íipidenéerica Jesucristo, israelita icuèrinápináca’, càipiná náimaca namànica nachìwawa. Yá nachìwáidapiná manùba wenàiwica. ");
INSERT INTO pioNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","“Picácué cáalu piwàwa péemìapinácaalícué áibanái itàaníca ùwicái iináwaná ìwali, namàníinása ùwicái mawiénita, déecubàata nacái. Càita iwàwacutá namànica, quéwa càmitàacá imáalàapináwa yái èeriquéi. ");
INSERT INTO pioNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Manùbacáiná áiba cáli néeséeyéi ipéliapiná áiba cáli néeséeyéi íipunitawa, áibanái gobierno namànipiná ùwicái áibanái gobierno íipunitawa. Yá canánama cáli icusúapinácawa. Yá nacái manùbéeyéi wenàiwica néetápináwa máapicái iyú. Quéwa macáita yái yùuwichàacáisica, yátanica idàbáanéeri yùuwichàacáisica meedá, càide iyúwa inanái idàbacaalí ùuwichàacawa ùasu èeri umusúadacaténá iicá èeri. ");
INSERT INTO pioNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Piicácué píichawa áibanáicáiná judíonái náibàapinácué píawa nacháawàacaténácué piináwaná ìwali nàyacàle icuèrinánái iríwa. Aibanái icapèedáidapinácué píawa judíonái yéewáidacàalu irìcu. Yá áibanái náibàapinácué píawa nacháawàacaténá piináwaná ìwali càmíiyéi judío icuèrinánái irí, reynái irí nacáiwa peebáidacáinácué nutàacái. Càipiná Dios imàacacué namànica pirí, yéewanápiná picàlidaca nalí nutàacái. ");
INSERT INTO pioNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Ipíchawáise imáalàapinácawa yái èeriquéi, yá iwàwacutápiná macái èeri mìnanái yéemìaca nutàacái cayábéeri. ");
INSERT INTO pioNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Néenialípiná náibàapinácué píawa nacháawàacaténácué pía náiwacanánái iríwa, quéwa picácué achúma píináidacawa piwàwawa ìwali càinácaalí iyú píalimá picàlidaca nalí nutàacái. Pibàlùapinácué náipunita, yá picàlidacué nalí càinácaalí tàacáisi Dios ichùulièripinácuéca picàlidaca nalí, càmicáinácué picàlidapiná nalí pìasu tàacáisiwa meedá, néese picàlidapinácué nalí nutàacái Espíritu Santo imàaquéeripinácuéca píalíacawa. ");
INSERT INTO pioNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Néenialípiná wenàiwicanái nacháawàapiná néenánáisíwawa áibanái irí, néenánái néetáanápináwa neebáidacáiná nutàacái. Aibanái nacái nasèenái nacháawàapiná néenibewa néetáanápináwa neebáidacáiná nutàacái. Aibanái néenibe nacái nawènúadapiná náiwitáisewa nasèenái íichawa, yá nanúaca nasèenáiwawa. ");
INSERT INTO pioNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Macái èeri mìnanái báawacuéca naicápiná píawa peebáidacáiná nutàacái, quéwa cawinácaalí yeebáidéeyéica nutàacái mamáalàacata àta néetácatalétawa, níacata nuwasèeyéipiná Dios yàasu yùuwichàacáisi íichawa. ");
INSERT INTO pioNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Aibaalípiná piicápinácué wenàiwica imànica áiba báawéeri casaquèeri wawàsi templo irìcu, aléde càmicataléca Dios imàaca wenàiwica imànica càiri wawàsi, casacàacaténá imànica templo Dios íicha —‍píacué iléeyéica yái tàacáisica, péemìacué cayábani—‍íná piicápinácaalícué yái wenàiwica ìyaca néré, yásí macáita wenàiwica ìyéeyéica chái Judea yàasu cáli iwàwacutá napìacawa dúli inàliméeri nérépiná. ");
INSERT INTO pioNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Cawinácaalí wenàiwica iyamáidéeyéicawa ìyaca icapèe ipùata sàabadéeri íinatawa néenialípiná, iwàwacutá càmita nèepùa nawàlùacawa nacapèe irìculéwa needácaténá nàasuwa ipíchawáise napìacawa Jerusalén ìyacàlená íicha. ");
INSERT INTO pioNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Cawinácaalí ìyéeyéica manacúaliré, iwàwacutá càmita nèepùawa nacapèe néréwa, ibatàa needáanápiná nabàlewata, iwàwacutá càmita nèepùawa ipíchawáise napìacawa Jerusalén ìyacàlená íicha. ");
INSERT INTO pioNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","¡Nàuwichàapinácawa manuísíwata cawinácaalí inanái idéerìcuíyéica, nía nacái inanáica yèeyéica quìrasìi ìira ìinisi!, càmicáiná náalimá napìacawa ráunamáita, naicápiná nacái néenibewa nàuwichàacawa. ");
INSERT INTO pioNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Pisutácué Dios íicha ipíchanácué iwàwacutá pipìacawa unìabépi, máinícáinácué càulenáca pìacawa. ");
INSERT INTO pioNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Néenialípiná wenàiwicanái yùuwichàapinácawa báawanama. Canácaté áiba yùuwichàacáisi báawéeríwanái íicha, Dios idàbacatáiseté yái èeriquéi, àta siùca nacáide. Càmíiripináta nacái áiba yùuwichàacáisi báawéeríwanái íicha càiripináta chái èeri irìcu. ");
INSERT INTO pioNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Càmicaalí Wacuèriná Dios imàaca maléenéeripinátáni yái yùuwichàacáisica, yásí macái èeri mìnanái yéetápinácawatá. Quéwa Dios idéca imàacaca maléenéeripinácani cáininácáiná iicáca yàasu wenàiwicawa, níái wenàiwica Dios yeedéeyéica yàasunáipináwa. ");
INSERT INTO pioNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Néese néenialípiná áibanái íimapinácué piríwa: ‘Aquialécué, piicáca chácata ìyaca yái Mesíasca’, càipiná náimaca; áibanái nacái náimapinácué piríwa: ‘Piicácué Mesías ìyaca néré, yái judío icuèrináca’, càipiná náimaca. Quéwa picácué peebáida nalíwani. ");
INSERT INTO pioNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Manùbacáiná cachìwéeyéi yàanàapináca, icàlidéeyéipiná ichìwawa, náimapiná Mesíascasa nía, judío icuèrinápiná; áibanái iwicùlidéeyéi nacái nàanàapiná icàlidéeyéi ichìwawa. Náimapiná natàaníinása Dios inùmalìcuíse. Namànipiná yái càmíirica wenàiwica idé imànica. Càipiná náasáidaca nachàiniwa nachìwáidacaténá èeri mìnanái. Náalimáidapiná nachìwáidaca Dios yàasu wenàiwica, Dios yeedéeyéica yàasunáipináwa. Càmicaalí Dios yàasunái iicá íichawa cayábani, yásí cachìwéeyéi náalimá nachìwáidaca nía nacái. ");
INSERT INTO pioNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Iná ¡piicácué píichawa cayábani! Nudéca nucàlidacuéca piríni, macáita yái iwàwacutéericuéca píalíacawa ipíchanácué nachìwáidaca pía. Nudéca nùalàacuéca pía náicha, ipíchawáise ichàbapinácawa”, íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Jesús íimacaté nalí àniwa: “Néenialípiná idécanáami ichàbacawa yái yùuwichàacáisica, yá catápináca èeri, quéeri nacáiwa càmita amalá icànaca. ");
INSERT INTO pioNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Dùlupùta nacái nacaláapináwa chènuníise. Yásí cachàiníiyéi wawàsi ìyéeyéica chènuniré nacusúacawa macáiwa. ");
INSERT INTO pioNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Néese macái èeri mìnanái iicápiná núa, núa asìali Dios néeséerica, nùanàapiná acalèe yèewíise cachàiníiri nuíwitáise iyúwa, nucamaláná mèlumèluíri irìcuwa nucùacaténá macáita. ");
INSERT INTO pioNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Nubànùapiná nùasu ángelnáiwa, yá nàwacáidapiná nulí nùasunái nuedéeyéica èeri mìnanái yèewíise àta alénácaalí nàyaca macái cáli imanùbaca chái èeri irìcu. ");
INSERT INTO pioNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Péemìacué cayába comparación higuera yéetaná ìwali: Càisinàacaalí higuera yàana, yá imusúadacaalí ibáináwa, yá píalíacuécawa mawiénica camuí. ");
INSERT INTO pioNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Càita nacái piicápinácaalícué ichàbacawa macáita yái nucàlidéericuéca pirí ìwali, yásí píalíacuécawa mawiénica núa, nùanápináwa néese àniwa, núa asìali Dios néeséerica, càide iyúwa wenàiwica ibàlùacaalíwa capìi inùma irìcu, iwàlùanápináwa capìi irìculé. ");
INSERT INTO pioNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Péemìacué cayábani, macáita yái siùquéerica tàacáwa nucàlidacuéca pirí ìwali, macáita ichàbáanápinácawa ipíchawáise néetácawa macáita wenàiwica ìyéeyéipináca néenialíwa. ");
INSERT INTO pioNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Yái capìraléeri cáli, èeriquéi nacái namáalàapinácawa áiba èeriwa, néese nutàacái càmita imáalàapináwa. Macáita ichàbapinácawa càiwade iyúwa nucàlidáanácué piríni. ");
INSERT INTO pioNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Quéwa canácata yáaliériwa chácatáinápinácaalí yái èerica, chènuníiséeyéi ángelnái nacái càmita náalíawa, núa nacái Dios Iirica, càmita núalíawa chácatáinápinácaalí yái èerica, hora nacái. Abéericata Núaniri Dios yáaliériwa. ");
INSERT INTO pioNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","“Iná picùacué pìyacani, yái èeripináca, pisutácué nacái Dios íicha, càmicáinácué píalíawa chácatáinápinácaalí nuénáiwaná yàanàaca. ");
INSERT INTO pioNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Péemìacué comparación: Nuénáiwanápiná ìyaca càide iyúwa asìali yàacaalíwa ipáchiacaténá déeculé. Ipíchawáise imusúacawa icapèe íichawa, yá imáidaca yàasu wenàiwicanáiwa. Yá ichùulìaca nacùanápiná icapèe, yàasu nacái. Macái icàlida nalí náibaidéeripináca. Yá ichùulìaca yàasu wenàiwicawa icuèripiná capìi inùma ipíchaná iimáca, ituíyàanápiná mamáalàacata àta náiwacali yàanàacataléta àniwa. ");
INSERT INTO pioNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Iná núumacué pirí, picùacué cayába nùanàaca àniwa, càmicáinácué píalíawa nuénáiwaná, núa ìyéerica càide iyúwa capìi íiwacali, chácatáinápinácaalí nùanàaca àniwa, nùanàapinácaalí táicalé, càmicaalí nacái catá bamuchúami, càmicaalí nacái cawámai itàacaalí, càmicaalí nacái mapisáita. ");
INSERT INTO pioNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Picùacué cayába nùanàaca ipíchanácué nuèpùapinácaalí nùanàaca àniwa, yáta nùanàacuéca pía meedá càmíiyéica íibaida nulí cayába, càide iyúwa wenàiwica iiméeyéica meedá. ");
INSERT INTO pioNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Yái núuméericuéca pirí, núuma nacái macáita nùasu wenàiwica iríwa: Picùacué cayába nùanàaca àniwa”, íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Iwàwacutácaté pucháiba èeri ipíchawáise judíonái yàasu culto íipidenéeri Pascua, nayáacaalíté pan càmíiri idènìa levadura. Sacerdote íiwacanánái, áibanái nacái yéewáidéeyéica wenàiwica templo irìcu nacutáca càinápinácaalí iyú yéewanápiná náibàaca Jesús ibàacanéeri iyú nanúanápináni. ");
INSERT INTO pioNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Abénaméeyéi náimaca: —‍Iwàwacutá càmita wáibàani Pascua yàasuná culto yaalí, ipíchaná calúaca wáapicha níái manùbéeyéi wenàiwicaca, ipíchaná namànica ùwicái yàcalé irìcu —‍náimaca. ");
INSERT INTO pioNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Jesús yàacatéwa Betania ìyacàlená néré, yá iwàlùacawa Simón icapèe irìculé, yái Simón ichùnièricatéwa cháunási lepra íicha. Néese idècunitàacá Jesús ìyaca mesa idaní iyáacaténá iyáacaléwa, yá abéechúa inanái yàanàaca itéechúaca catùa ucáapi irìcuwa, abéechúa catùa cawèníiri íba alabastro icatùalená, ipuniéchúawa séenási pumèníiri isàni iyú, íipidenéeri nardo, máiníiri cawènica. Yá ubacáca catùa inùma, yá ùucùaca séenási Jesús íiwita ìwali, yái séenási pumèníirica isàni. ");
INSERT INTO pioNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Néese abénaméeyéi néená níái ìyéeyéica néeni, yá calúaca nía ìwalíise yái umàníináca. Náimaca nalíwáaca: —‍Máiní báawéeriquéi úucáanáca meedá yái pumèníirica isàni cawèníirimica. ");
INSERT INTO pioNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Yái pumèníirica isàni iwèníiri trescientos ichàbaníiseta denario, cawèníiyéi plata abéeri camuí iwènicatái. Iná ¿cánácáwa càmita uwéndani ùacaténá iwènináami catúulécanéeyéi irí? —‍náimaca nalíwáaca. Yá nacuísaca náichawa úái inanáica. ");
INSERT INTO pioNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Quéwa Jesús íimaca nalí: —‍Pimàacacué umànica càide iyúwa uwàwáaná. Picácué pisàiwica ulí wawàsi. Udéca umànica nulí cayábéeri. ");
INSERT INTO pioNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Catúulécanéeyéi wenàiwica nàyacuéca pèewi càiripináta, íná yéewa píalimá piyúudàaca nía càinácaalí èeri piwàwacatáicatacué piyúudàaca nía. Núa quéwa càmíirita ìyapiná píapichacué càiripináta chái èeri irìcu. ");
INSERT INTO pioNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Uara inanáica udéca umànica nulí yái cayábéerica úaliméerica umànica. Udéca ùucùaca nùwali perfume nusànipiná ipíchawáise nuétácawa, yéewanápiná nabàlìaca núa, càide iyúwa judíonái imàníiná yéetéeyéimiwa irí. ");
INSERT INTO pioNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Péemìacué cayába, àta alénácaalí wenàiwica nacàlidaca nutàacái chái èeri irìcu, yái tàacáisi íiméerica nuwasàaca wenàiwica Dios yàasu yùuwichàacáisi íicha, yásí nacái nacàlidaca uináwaná ìwali càinácaalí iyú úái inanáica umàníináté nulí cayábéeri. Càipiná nawàwalica úawa —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Néeseté Judas Iscariote, abéeri néená níái docéeyéica imanùbaca Jesús yéewáidacaléca, yàaca itàaníca sacerdote íiwacanánái yáapicha, itéenápiná nía Jesús yàatalé náibàacaténáni. ");
INSERT INTO pioNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Níái sacerdote íiwacanánáica néemìacaalíni, yá máiní casíimáica nawàwa. Yá nacàlidaca Judas irí nàanápináté irí plata itéenápináca nía Jesús yàatalé náibàacaténáni. Néese Judas idàbaca icutáca wawàsi càicaalínácatáipináta yáalimá itéca nía Jesús yàatalé náibàacaténáni. ");
INSERT INTO pioNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Idàbáanéeri èeri yàanàacaté judíonái yàasu culto yaalí íipidenéerica Pascua nayáacaalíté pan càmíiri idènìa levadura. Yáté èerica nanúacaté oveja wàlisài iyúwa sacrificio càide iyúwaté náiwitáise ìyáaná nayáacaténá oveja iiná Pascua yàasuná culto yaalí. Yáté èerica Jesús yéewáidacalénái isutáca yéemìawani. Náimaca irí: —‍¿Alénásica piwàwa wàacawa wachùnìacaténá piyáapiná nacáiwa yàacàsi Pascua pinéerica piyáacaténáni wáapicha? —‍náimaca irí. ");
INSERT INTO pioNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Iná Jesús imáidaca yàataléwa pucháiba yéewáidacaléwa ibànùacaténá nía. Yá íimaca nalí: —‍Pìacuéwa Jerusalén ìyacàlená irìculé. Abéeri asìali íipunitáidapinácué píawa, itéerica úni catùalìcu. Pìacuéwa yáamiwáise, ");
INSERT INTO pioNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","àta iwàlùacatalétawa capìirìculé, néese píimacué capìi íiwacali irí: ‘Yáara Yéewáidéerica wía iwàwaca isutáca yéemìawa pía alénácaalí capìi imàdáaná ìya iyáacatáipiná iyáacaléwa Pascua pinéerica yéewáidacalénái yáapichawa’, píimacué irí. ");
INSERT INTO pioNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Néese yáasáidapinácué piríwani, capìi imàdáaná manuíri ìyéerica chènunibàa cáli inàni íicha, nachùnièrica cayába. Pichùnìacué walíni néré wayáapiná Pascua piná —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Néese nàacawa Jesús íicha níái yéewáidacaléca, yá nawàlùacawa Jerusalén ìyacàlená irìculé. Yá nàanàaca macáita càide iyúwa Jesús íimáanáté nalí. Néese nachùnìaca yàacàsi Pascua pinéerica. ");
INSERT INTO pioNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Néeseté catáca yàacawa, yá Jesús yàanàaca néré doce namanùbaca yéewáidacalé yáapichawa. ");
INSERT INTO pioNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Néese idècunitàacá nayáaca nayáacaléwa mesa iwéré, Jesús íimaca nalí: —‍Péemìacué cayába, abéeri péenácué, iyéerica iyáacaléwa núapicha siùcade, itépiná nùuwidenái náibàacaténá núa —‍íimaca nalí. ");
INSERT INTO pioNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Yá idàbaca achúmaca nawàwa, íná nadàbaca nasutáca néemìawani abéerinamata. Náimaca Jesús irí: —‍¿Núasica? —‍náimaca. ");
INSERT INTO pioNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Jesús íimaca nalí: —‍Abéeri péenácué docenácué pimanùbaca pía, yái yáapúadéerica pan núapicha quírápieli irìculé, yácata itéeripináca nùuwidenái náibàacaténá núa. ");
INSERT INTO pioNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Báisíta núa, asìali Dios néeséerica, nuétápinácawa càide iyúwaté profetanái itànàanáté tàacáisi nùwali Dios inùmalìcuíse; quéwa ¡máiníiripiná yùuwichàacawa yái asìalica itéeripináca nùuwidenái náibàacaténá núa! Cayába cachàinitésica irítáni càmicaalíté imusúa iicáca èeritá —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Néese idècunitàacá nayáaca nayáacaléwa, Jesús yeedáca pan icáapi irìculéwa, yá yàaca Dios irí cayábéeri ìwali yái panca. Néese isubèriadacani, iwacùaca nalíni. Iimaca nalí: —‍Peedácué piyáawani, yácata nuiná yái —‍íimaca nalí. ");
INSERT INTO pioNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Néese yeedáca copa icáapi irìculéwa, abéechúa copa idènièchúa irìcuwa uva ituní. Yá yàaca Dios irí cayábéeri ìwali yái uva ituníca. Néese ichàbáida nalíni, yá macáita nàiracani. ");
INSERT INTO pioNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Jesús íimaca nalí: —‍Yái uva ituníca, yácata nuíraná imusuéripinácawa nuíchawa cruz ìwali manùbéeyéi wenàiwica irípináwa, imàaquéeri nacái báisíiricani yái wàlisài wawàsi Dios imàníirica wenàiwicanái yáapicha iwasàacaténá níawa Dios yàasu yùuwichàacáisi íicha. ");
INSERT INTO pioNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Péemìacué cayába, càmita nuèpùa nuìrapináca quirínamani yái uva ituníca àta áiba èeripiná nuìracataléta wàlisài uva ituní yàcalé irìcu Dios icùacataléca macáita chènuniré —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Néeseté idécanáami nacántàaca salmos, yá nàacatéwa dúli nérépiná íipidenéechúa Olivos, íimáanáca olivo inàlimaná. ");
INSERT INTO pioNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Jesús íimaca nalí: —‍Macáitacué piwènúadapiná nuícha píiwitáisewa, yá pimàacapinácué núa abéerita, càide iyúwaté Dios yàasu profeta itànàaná tàacáisi Dios icàlidéericaté nùwali. Dios íimacaté: ‘Nunúapiná yái icuèrica nupìra ovejanáiwa, néese nupìra ovejanái napìapiná nacàlàlìacawa’, íimacaté yái Diosca. ");
INSERT INTO pioNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Quéwa idécanáami numichàacawa yéetácáisi íicha, yásí nùacuéwa pipíchalé Galilea yàasu cáli néré, yá nuípunitáidapinácué pía néréwa —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Néese Pedro íimaca irí: —‍Ewita macáita áibanái iwènúadacaalí píicha íiwitáisewa, càicáaníta càmita numànipiná cài —‍íimaca yái Pedroca. ");
INSERT INTO pioNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Jesús íimaca irí: —‍Péemìa cayába, yáta catáquéi, ipíchawáise cawámai itàaca pucháibáaná yàawiríapiná, yá pimànipiná pichìwawa máisiba yàawiría, píimapiná càmitasa píalía nùwali, ipíchaná nanúaca pía núapicha —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Quéwa Pedro íimaca irí cachàiníiri iyú mamáalàacata: —‍Ewita iwàwacutácaalí nacái nuétácawa píapichawa, càicáaníta càmita nucàlida nuchìwawa càmíinása núalía pìwali —‍íimaca yái Pedroca. Yá macáita níái áibanái cài náimaca nacái Jesús irí. ");
INSERT INTO pioNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Néeseté nàanàaca bànacalé inàlima néré íipidenácataléca Getsemaní. Yá Jesús íimaca yéewáidacalénái iríwa: —‍Píawinacuéwa chái idècunitàacá nùaca néré nusutáca núawawa Dios íicha —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Yá itéca yáapichawa Pedro, Santiago nacái, Juan nacái. Yá Jesús idàbaca icalùadacawa báawanama, máiní achúmaca iwàwa íináidacawa icalùniwa. ");
INSERT INTO pioNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Yá íimaca nalí: —‍Máiní achúmaca nuwàwa nuínáidacawa nuwàwalìcuísewa càide iyúwa wenàiwica iwàwéeri yéetácawa aquialéta. Chátacué píara. Picácué piimá pìyaca —‍íimaca nalí. ");
INSERT INTO pioNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Néese Jesús isirùacawa napíchalé achúmáanata. Jesús yúuwàa irìacawa inùmáawawa cáli iwéré. Yá isutáca Dios íicha wawàsi asáisí cayábacaalí iwasàanápiná Jesús yùuwichàacáisi íicha, yái yùuwichàacáisica yàanèeripinácatéwa ìwali mesúnamáitaté. ");
INSERT INTO pioNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Càité Jesús isutáca yáawawa Dios íicha: “Núaniri, píacata yáaliméerica imànica macái wawàsi. Iná piwasàaca núa íicha yái nùuwichàanápinácawa yàanèeripinácawa nùwali siùcade; quéwa, càmicaalí cayábani yái piwasàanáca núa, yá picá pimàni càide iyúwa nuwàwáaná, néese pimàni càide iyúwa piwàwáaná”, íimaca isutáca Dios íicha yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Néese yèepùacawa yéewáidacalénái yàataléwa. Yá yàanàaca nía iiméeyéicáita. Néese íimaca Pedro irí: —‍Simón, ¿cáná piimá? ¿Cáná càmita yéewa picawàacawa ibatàa abéeri horapiná? ");
INSERT INTO pioNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Picácué piimá pìyaca, pisutácué nacái píawawa Dios íicha yéewacaténácué pimawènìadaca píichawa báawéeri, Satanáscáiná yáalimáidapinácué pía pimàníinápiná pibáyawanáwa. Piwàwacuéca pimànica càide iyúwa nuwàwáaná, quéwa machawàacáicatacué piiná meedá —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Néese Jesús yèepùa yàacawa náicha àniwa. Yá yèepùa isutáca Dios íicha càide iyúwa idéenáté isutácáwaca. ");
INSERT INTO pioNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Néese yèepùacawa yéewáidacalénái yàataléwa àniwa, yásí yàanàaca nía iiméeyéicáita àniwa, máinícáiná cadapùleca nía báawanama. Idécanáami icawàidaca nía, yá báica naicáca níawawa iwéré. ");
INSERT INTO pioNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Yá Jesús yèepùa iwènúacawa náicha àniwa, yá isutáca yáawawa Dios íicha àniwa. Néese yèepùa yàacawa nàatalé àniwa máisiba yàawiríanápiná. Yá Jesús íimaca nalí: —‍¿Cánácué piimá pìyaca? ¿Cánácué piyamáidacáitacuéwa meedá nacái? Pidécuéca piimáca, íná pimichàacuéwa, nuénáiwanácáiná idéca yàanàaca presocatáipináca namànica núa namàacacaténá cabáyawanéeyéi wenàiwica inúaca núa, núa asìali Dios néeséerica. ");
INSERT INTO pioNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Pimichàacuéwa, wàanácuéwa; áca néese yái asìalica itéerica nùuwidenái náibàacaténá núa —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Idècunitàacá Jesús itàaníca, yáté Judas yàanàaca, yái abéeri yéewáidacaléca, docenámica nía. Yàanàaca madécaná wenàiwica yáapicha cacáapisèeyéi. Natéca espada machete nacáiri, wacàba nacái áiba. Sacerdote íiwacanánái, nía nacái yéewáidéeyéica wenàiwica templo irìcu, judío íiwacanánái nacái nabànùacaté wenàiwica Judas yáapicha íibèeyéipináca Jesús. ");
INSERT INTO pioNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Judasca, yái itéeripinácaté Jesús yùuwidenái náibàacaténáténi, icàlidacaté nalíni quéechacáwa càinápinácaalí iyú yáasáida Jesús. Càité Judas íimaca nalí quéechatécáwa: “Yái asìali nutàidéeripináca, nusùsuèripináca nacái inàni ìwali, yácata Jesús. Iná píibàacuéni, pitécué pìacawa cachàiníiri iyúni”, càité íimaca nalí yái Judasca. ");
INSERT INTO pioNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Ináté Judas yàacawa Jesús yàatalé. Yá íimaca Jesús irí: —‍¡Nuíwacali! —‍íimaca yái Judasca. Néese Judas isùsùaca Jesús inàni ìwali càide iyúwa judío íiwitáise ìyáaná natàidáaná wenàiwica cáininéerica naicáca. ");
INSERT INTO pioNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Néese níái manùbéeyéi wenàiwicaca náibàaca Jesús, nacùacani presoíri iyú. ");
INSERT INTO pioNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Quéwa abéerita néená níái yéewáidacaléca ìyéeyéica néré Jesús yáapicha iwatàaca yàasu espada machete nacáiriwa. Yá yáalimáidaca ipéliacatatá, yá inúacatatá abéeri asìali ìwali espada iyú, quéwa isasàacáita meedá yùuwi abéemàa, yái sacerdote íiwacaliná yàasu wenàiwicaca. ");
INSERT INTO pioNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Néese Jesús isutáca yéemìawa níái wenàiwicaca: —‍¿Cánácué pìanàa nùatalé cacáapisàiwaca espada machete nacáiri, wacàba nacái píibàacaténácué núa presoíri iyúpiná càide iyúwa piicáaná cayéedéerimi? Càmitacué iwàwacutá cài pimànica, càmicáinácué nupéliapiná píipunita. ");
INSERT INTO pioNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Macái èeri imanùbaca, nùyacatécué pèewi idècunitàacá nuéwáidaca wenàiwica templo irìcu, yá càmitatécué píibàa núa néenibàa. Quéwa píalimácué píibàaca núa siùcade yéewanápiná macáita ichàbacawa càide iyúwaté profetanái itànàaná tàacáisi nuináwaná ìwali Dios inùmalìcuíse —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Néese macáita Jesús yéewáidacalénái namàacaca Jesús abéerita néré. Yá napìacawa. ");
INSERT INTO pioNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Núa Marcos quéwa, ùuculìiricaté núa, nùacatéwa Jesús yáamiwáise. Nudènìacaté nùwaliwa manuíri wáluma meedá, núuquéericaté nùwalíisewa. Néese níái wenàiwica náibàaca núa. ");
INSERT INTO pioNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Quéwa numusúacàatécatawa nùasu wálumami íichawa, yá nupìacawa náicha mabàleta meedá. ");
INSERT INTO pioNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Néeseté natéca Jesús sacerdote íiwacaliná icapèe néré. Néese nàwacáidáyacacawa macáita sacerdote íiwacanánái, judío íiwacanánái nacái, nía nacái yéewáidéeyéica wenàiwica templo irìcu. ");
INSERT INTO pioNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Yá Pedro yàacawa Jesús yáamiwáise déecuíseta. Yá iwàlùacawa bàacháwa irìculé, yái sacerdote íiwacaliná icapèe ibàacháwalenáca. Yá Pedro yáawinacawa úwinái yèewi, níái icuèyéica templo. Pedro yáawinacawa mawiénita quichái irí yàanabàcaténá néeni. ");
INSERT INTO pioNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Néese sacerdote íiwacanánái, nía nacái macáita Junta Supremanái israelita íiwacanánái nacutáca wawàsi Jesús ìwali namàacáanápiná úwinái inúacani. Quéwa càmitaté náalimá nàanàaca báisíiri wawàsi ìwali. ");
INSERT INTO pioNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Yácáiná éwita manùbéeyéi wenàiwica nacàlidacáaníta nachìwawa Jesús ìwali, càicáaníta càmita abédanama natàaníca. ");
INSERT INTO pioNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Aibanái nabàlùacawa nacàlidacaténá nachìwawa. Yá náimaca: ");
INSERT INTO pioNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","—‍Wadéca wéemìaca cài íimaca: ‘Numáalàidapiná yái temploca asìanái imàníirica, néese máisiba èeri irìcu, yá numichàidapiná áiba templo càmíirita asìanái imàni’, cài íimaca —‍náimaca nacháawàaca Jesús iináwaná ìwali. ");
INSERT INTO pioNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Quéwa éwita nacàlidacáaníta càiri chìwái, càicáaníta càmita abédanama natàaníca àniwa. ");
INSERT INTO pioNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Néese sacerdote íiwacaliná imichàacawa ibàlùacawa nàacuésemi. Yá isutáca yéemìawa Jesús: —‍¿Cáná càmita picàlida piináwanáwa? ¿Càiná píimaca ìwali yái nacàlidéerica pìwali nacháawàanáca piináwaná ìwali? —‍íimaca Jesús irí. ");
INSERT INTO pioNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Quéwa, éwita càmicáaníta cabáyawanáca yái Jesúsca, càicáaníta masànata náicha mamáalàacatani, canáca icàlidáaná iináwanáwa nalí. Néese sacerdote íiwacaliná isutáca yéemìawa àniwani. Yá íimaca Jesús irí: —‍¿Píatasica yái Mesíasca, yái judío icuèrinápináca, yái cayábéeri Dios Iirica? —‍íimaca. ");
INSERT INTO pioNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Jesús íimaca irí: —‍Báisíta, yáca núa yái. Yá áibaalípiná piicápinácué núawa, asìali Dios néeséerica. Piicápinácué núawinacawa nùyaca Dios yéewápuwáise, yái Dios cachàiníirica náicha canánama nucùacaténá yáapicha macáita. Yá piicápinácué nacái nùanàaca àniwa acalèe yèewíise chènuníise —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Néese sacerdote íiwacaliná icacanáidaca ibàlewa càide iyúwaté judío íiwitáise ìyáaná yáasáidacaténá báawaca yéemìaca yái tàacáisi Jesús íiméerica Dios ìwali. Yá sacerdote íiwacaliná íimaca nalí: —‍¡Càmita iwàwacutá wéemìaca áibanái icàlidáaná iináwaná ìwali! ");
INSERT INTO pioNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Pidécuéca péemìaca itàaníca báawéeri iyú Dios ìwali, icàlidaca ìwaliwa Dios Iiricasani. ¿Càinásicué wamànica irí? —‍íimaca. Yá abédanamata náiwitáise macáita cabáyawanáca naicácani, iwàwacutáanása nacái yéetácawa, náimaca. ");
INSERT INTO pioNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Néese abénaméeyéi néená nadàbaca nàapìsáidaca Jesús inàni, nabàlìa nacái ituí, yá nacapèedáidacani, náimaca irí: —‍¡Piwicùlida, picàlida walíni cawinácaalí yái inúadáida pía! —‍náimaca irí, naicáaníca iquíniná. Yá nacái úwinái icuèyéica templo nanúadáidaca Jesús inàni ìwali. ");
INSERT INTO pioNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Pedro ìyacaté capìi yàapumàalìcubàa, bàacháwáise. Néese inanái yàanàaca néré, sacerdote íiwacaliná yàasu wenàiwicaca. ");
INSERT INTO pioNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Uicáca Pedro yàanabàca quichái, yá uicáidaca irí. Néese úumaca irí: —‍Pía nacái yèepuníiritéwa Jesús yáapicha, yái Nazaret ìyacàlená néeséerica —‍úumaca. ");
INSERT INTO pioNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Pedro quéwa imànica ichìwawa, íimaca càmitasa yáalía Jesús ìwali. Yá íimaca ulí: —‍Càmíirita núalía ìwali. Càmita nacái núalía càinácaalí ìwali pitàaníca pìyaca —‍íimaca icàlidaca ichìwawa yái Pedroca, cáalucáináni. Yá Pedro yàacawa náicha iwáiná inùma néré, yái iwáiná bàacháwa itéeséerica. Néese cawámai itàaca. ");
INSERT INTO pioNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Néese úái íibaidéechúaca uicáca Pedro àniwa. Yá udàbaca ucàlidaca Pedro iináwaná ìwali wenàiwicanái irí ìyéeyéica néeni. Yá úumaca nalí: —‍Yá asìaliquéi abéeri néená níái Jesús yáapichéeyéica —‍úumaca. ");
INSERT INTO pioNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Quéwa Pedro icàlidaca ichìwawa àniwa càmíinása yáalía Jesús ìwali ipíchaná náibàacani nacái, yái Pedroca. Néese achúma yáwanáitàacáwa àniwa áibanái ìyéeyéica néeni náimaca Pedro irí àniwa: —‍Báisíta píaca abéeri néená níái Jesús yáapichéeyéica, Galilea yàasu cáli néeséericáiná nacái pía —‍náimaca. ");
INSERT INTO pioNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Néese Pedro idàbaca icàlidaca ichìwawa cachàiníiri tàacáisi iyú, báawéeri nacái báawanama báisí báisísíwata Dios yáaliéricawa. Yá íimaca nalí: —‍¡Càmita núalía ìwalíira asìali pitàaníiricuéca ìwali! —‍íimaca icàlidaca ichìwawa yái Pedroca, ipíchaná náibàacani, cáalucáináni, yái Pedroca. ");
INSERT INTO pioNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Yáta cawámai itàaca àniwa pucháibáaná yàawiríapiná. Néese Pedro iwàwalica tàacáisi Jesús íiméericaté irí: ‘Ipíchawáise cawámai itàaca pucháibáaná yàawiríapiná, yá pimànipiná pichìwawa máisiba yàawiría, píimapiná càmitasa píalía nùwali’, càité idéca íimaca yái Jesúsca. Yá Pedro íicháaníca cachàiníiri iyú. ");
INSERT INTO pioNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Néeseté amalácaalí nawicáu, yá nàwacáidáyacacawa, níái sacerdote íiwacanánáica, judío íiwacanánái nacái, nía nacái yéewáidéeyéica wenàiwica templo irìcu, nía macáita Junta Supremanái, israelita íiwacanánáica, náináidacaténáwa càinácaalí namàníinápináté Jesús irí. Yá nadacùaca náichawa Jesús. Yá natécani presoíri iyú Pilato gobernador yàatalé, yái romanosàiri icuèricaté Judea yàasu cáli, yéewacaténá Pilato yéemìaca Jesús iináwaná ìwali, ichùulìanápiná úwinái inúaca Jesús. ");
INSERT INTO pioNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Néese Pilato isutáca yéemìawa Jesús: —‍¿Báisísica judío icuèrinásàirica pía? —‍íimaca. Néese Jesús íimaca irí: —‍Báisíta, núacani. Pidéca cài píimaca —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Néese sacerdote íiwacanánái nacháawàaca Jesús iináwaná ìwali. Náimaca Jesús imànicasa madécaná wawàsi báawéeri. ");
INSERT INTO pioNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Iná Pilato isutáca yéemìawa Jesús àniwa. Yá íimaca Jesús irí: —‍¿Cáná càmita picàlida nulí piináwanáwa càinácaalí pidéená pimànica? Péemìa nacháawàaná piináwaná ìwali manùba wawàsi ìwali —‍íimaca yái Pilatoca. ");
INSERT INTO pioNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Canácata quéwa Jesús íimáaná irí, íná Pilato íináidacawa manuísíwata iicáidaca Jesús irí, càmita Pilato yáalíawa íináidéeripináwa Jesús ìwali. ");
INSERT INTO pioNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Camuí imanùbaca judíonái imànicaalíté Pascua yàasuná culto, yá Pilato gobernador romanosàiri iwasàaca abéeri presoíri judíonái irípiná, càiríinácaalí presoíri nawàwéerica. ");
INSERT INTO pioNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Néenialíté ìyaca asìali íipidenéerica Barrabás presoíyéi ibànalìcu, náapicha áibanái wenàiwica inuéyéicaté wenàiwica ùwicái irìcuná, namànicaalíté ùwicái romanonái yàasu gobierno íipunita. ");
INSERT INTO pioNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Iná áibanái wenàiwica yàanàaca, yá nadàbaca nasutáca Pilato íicha wawàsi iwasàanápiná nalí abéeri presoíri càide iyúwaté íiwitáise ìyáaná. ");
INSERT INTO pioNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Yá Pilato íimaca nalí: —‍¿Piwàwasicué nuwasàaca pirí Jesús, yái judío icuèrináca? —‍íimaca yái Pilatoca Jesús ìwali. ");
INSERT INTO pioNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Càica Pilato isutáca yéemìawa nía, Pilato yáalíacáinátéwa báawaca sacerdote íiwacanánái iicáca Jesús, máinícáiná cayábaca macái wenàiwica naicáca náicha Jesús, íná sacerdote íiwacanánái náibàacaté Jesús nacháawàacaténá iináwaná ìwali Pilato irí. ");
INSERT INTO pioNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Quéwa sacerdote íiwacanánái nawènúadaca wenàiwicanái íiwitáise Jesús íicha nasutácaténá Pilato íicha wawàsi iwasàanápiná nalí Barrabás. ");
INSERT INTO pioNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilato isutáca yéemìawa nía: —‍Néeni, nuwasàacaalícué pirí Barrabás, ¿càinásicué piwàwa numànica Jesús irí, yái píiméericuéca ìwali judío icuèrinásàirica? —‍íimaca yái Pilatoca. ");
INSERT INTO pioNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Yá náimaca Pilato irí néemíanícawa: —‍¡Pitàtàacuéni cruz ìwali! —‍náimaca madécaná yàawiría. ");
INSERT INTO pioNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilato íimaca nalí: —‍¿Cáná? ¿Càinásica báawéeri imàni? —‍íimaca yái Pilatoca. Quéwanáta néemíanícawa àniwa: —‍¡Pitàtàacuéni cruz ìwali! —‍náimaca. ");
INSERT INTO pioNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Iná Pilato iwàwacáiná cayábaca nía yáapicha, níái judíoca, íná iwasàaca nalí Barrabás. Yá ichùulìaca yàasu úwináiwa icapèedáidáanápiná Jesús mabàleta cachàiníiri cabèesi iyú. Idécanáami nacapèedáidaca Jesús báawanama àta íimami ichalàacatalétawa íicha, yá Pilato yèepùadacani úwinái irí natàtàacaténáni cruz ìwali. ");
INSERT INTO pioNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Néese úwinái natéca Jesús bàacháwáise capìi íicha, yái Pilato icapèe manuírica. Yá namáidaca macáita néenánáiwa úwinái nàwacáidáyacacaténáwa Jesús itéese. ");
INSERT INTO pioNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Néese náucaca ruana Jesús ìwalíise, abéeri ruana nacáiri cáaléeri, quíiréeri càiride iyúwa romano icuèriná ibàle. Néese namànica tuíri culèpi nacáiri icàyuwaniná càiride iyúwa romano icuèriná yàasu corona. Yá náiyàaca corona Jesús íiwita ìwali, nacuèrinásàiri naicácaténásatáni, quéwa naicáanícáita meedá Jesús iquíniná. ");
INSERT INTO pioNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Yá nadàbaca néemíanícawa irí. Náimaca: —‍¡Casíimái piwàwa, pìyaca manùba èeri, píasa judío icuèrinásàirica! —‍náimaca, càide iyúwaté romano íiwitáise natàidáaná nacuèrináwa, naicáanícaténá meedá Jesús iquíniná. ");
INSERT INTO pioNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Néese nanúadáidaca Jesús íiwita ìwali àicu iyú. Yá nàapìsáidacani. Néese nabàlùacawa nàuluì iyúwa Jesús irí càide iyúwa nàacaalí icàaluíninátá, quéwa naicáanícáita Jesús iquíniná meedá. Càmita báisíiri iyú nàa icàaluíniná. ");
INSERT INTO pioNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Idécanáami cài naicáaníca Jesús iquíniná, yá nawatàaca íicha ruana nacáiri cáaléeri quíiréerica. Néese nàwalica Jesús ìwali ibàle àniwa. Yá natécani yàcalé íicha, natàtàacaténáni cruz ìwali. ");
INSERT INTO pioNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Néeseté abéeri asìali Cirene ìyacàlená néeséeri yàanàaca manacúali néese, íipidenéerica Simón, yái náanirica níái Alejandro, Rufo nacái. Yàacawa àyapulìcubàa yái Simónca, néese úwinái íibàacani, nachùulìaca iwáacutaca cruz Jesús irípiná, càmicáináté Jesús yáalimá iwáacutacani, canácáiná quirínama ichàini, úwináicáiná nacapèedáidacaté báawanamani. ");
INSERT INTO pioNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Natéca Jesús Gólgota néré méetàuculé Jerusalén ìyacàlená íicha. (Yái íipidená Gólgota íimáanáca: “Iiwitasi yáapimi ìyacatalé”.) ");
INSERT INTO pioNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Yá nawàwa nàaca Jesús ìira uva ituní ipuíri, nèewìadéerica dabé yèewi íipidenéeri mirra wéebacaténá Jesús iiná ipíchaná máiní yùuwichàacawa cruz ìwali. Quéwa càmíirita ìira náichani. ");
INSERT INTO pioNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Néese natàtàaca Jesús cruz ìwali. Yá úwinái ibàlùadaca cruz utàwi irìculé. Yá úwinái náucaca náichawa suerte náalíacaténá chánácaalí néená yeedápiná iríwa Jesús ibàle yéenámica, càiyéinácaalí néená úwinái namanùbaca nawàwacani, yái ibàlemica. ");
INSERT INTO pioNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Mapisái yáwanái tàacáwa a las nueveta mapisáita, yáté natàtàaca Jesús cruz ìwali. ");
INSERT INTO pioNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Nachanàidacaté tàacáisi Jesús yàasu cruz ìwali icàlidéerica cáná yéewa nanúacani. Yá tàacáisi íimaca: “Judío icuèriná”, íimaca yái tàacáisica. ");
INSERT INTO pioNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Natàtàaca nacái pucháiba cayéedéeyéi mawiénita Jesús irí. Abéeri cruz ibàlùacawa Jesús yéewápuwáise, áiba cruz nacái ibàlùacawa apáulìcuíse Jesús irí. ");
INSERT INTO pioNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Càité macáita ichàbacawa càide iyúwaté profeta itànàanáté tàacáisi Dios inùmalìcuíse Jesús yéetáanápinátéwa. Càité profeta itànàacaté: “Yá nàuwichàidapinácani báawéeyéi yáapicha”, íimacaté yái profetaca. ");
INSERT INTO pioNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","30","Aibanái wenàiwica ichàbéeyéicawa néenibàa àyapulìcubàa natàaníca Jesús ìwali báawéeri iyú, nacusúadaca náiwitawa irí naicáanícaténá iquíniná. Yá náimaca irí: —‍¿Néeni?, píata imáalàidéeripinása templo, pimichàidéeripinása nacái àniwani máisiba èeri irìcu, ¿cáná càmita pichàiniada píawawa yéetácáisi íicha ipíchaná péetácawa, yá piricùawa cruz íicha? —‍náimaca, naicáaníca Jesús iquíniná. ");
INSERT INTO pioNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Càita nacái naicáaníca iquíniná níái sacerdote íiwacanánáica, nía nacái yéewáidéeyéica wenàiwica templo irìcu. Náimaca nalíwáaca: —‍Ichùnìacaté áibanái ipíchanáté néetácawa, quéwa càmíirita yáalimá ichàiniadaca yáawawa yéetácáisi íicha ipíchaná yéetácawa —‍náimaca naicáaníca Jesús iquíniná. ");
INSERT INTO pioNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Náimaca nacái Jesús irí: —‍¡Piricùawa cruz íicha, píasa Mesíasca, yái Israel itaquénáinámi icuèrinácasa, yéewacaténá waicáca, yásí weebáidaca pitàacái! —‍náimaca naicáaníca iquíniná. Nía nacái pucháiba asìanái natàtèeyéica cruz ìwali mawiénita Jesús irí, natàaníca ìwali báawéeri iyú. ");
INSERT INTO pioNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Machacànicaalíté èeri, yáté catáca macáita chái èeri irìcu máisiba hora, catáca èeri àta las tresta táicalé. ");
INSERT INTO pioNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Yá horaquéi a las tresta, táicaca yàacawa, yá Jesús imáidaca cachàiníiri iyú itàacái iyúwa. Yá íimaca Dios irí: “Eloi, Eloi, ¿lema sabactani?” íimaca yái Jesúsca. (Yái tàacáisi íimáanáca: “Nucuèriná Dios, Nucuèriná Dios, ¿cánásica pimàaca núa abéerita?” cài íimáanáca.) ");
INSERT INTO pioNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Abénaméeyéi ibàluèyéiwa néré néemìaca isàna. Yá náimaca nalíwáaca, naicáaníca Jesús iquíniná: —‍Péemìacué, imáidaca ìyaca profeta Elías —‍náimaca naicáaníca iquíniná. ");
INSERT INTO pioNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Iná abéerita néená ipìaca íisapiadaca esponja wáluma nacáiri uva ituní iyú càaméeri ìiracaná. Yá idacùaca esponja sitùa ipùatalìcu, yái wáluma nacáiri isàbéerica. Néese imichàidacani mawiénita Jesús inùma irí, yéewacaténá Jesús ibèrùacani. Néese yái asìalica íimaca yáapichéeyéi iríwa: —‍Wacùacué waicáwa Elíasmi yàanàacaalí yeedácaténáni cruz íicha —‍íimaca, iicáaníca Jesús iquíniná. ");
INSERT INTO pioNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Quéwa Jesús imáidaca cachàiníiri iyú, yá imàacaca icáucawa yàacawa iiná íichawa. Càité yéetácawa. ");
INSERT INTO pioNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Yáta manuíri yáawàanáca templo irìcuírica icacanácawa bamuchúamibàa cáli iwérénama pucháibawaca yèewi, yái yáawàanáca ibàlièrica mabáyawanéeri Dios ìyacatáica wenàiwicanái ituí íicha. Yáta icacanácawa chènuníise cáli iwérénama, yái yáawàanámica. ");
INSERT INTO pioNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Néese úwi íiwacaliná romanosàiri ibàluèricawa Jesús yàasu cruz íipunita iicácáináté càinácaalí iyú Jesús yéetáanátéwa, ínáté íimaca: —‍Báisíiricata Dios Iiricaténi yái asìalica —‍íimaca yái úwi íiwacalináca. ");
INSERT INTO pioNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Nàya nacái néré abénaméeyéi inanái, iicáidéeyéica ìyaca Jesús irí déecuíseta quéwa. Nàyaca nèewi níái íipidenéeyéica María Magdalena, áiba María nacái, úái náatúaca ùuculìiri Santiago, José nacái. Aiba inanái nacái ubàlùacawa néeni, íipidenéechúaca Salomé. ");
INSERT INTO pioNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Níái inanáica, Jesús yéewáidacaléca nacái nía, nayúudàacaté Jesús yèepunícaalítéwa Galilea yàasu cáli íinata. Nàyaca náapicha néré nacái manùba inanái yàanèeyéicaté Jesús yáapicha Jerusalén ìyacàlená néré. ");
INSERT INTO pioNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Catáca yàacawa yáté èerica iwàwacutácaalíté namáalàidaca náibaidaca ipíchawáise judíonái yàasu sábado idàbaca, nayamáidacatáicawa. Yáté iwàwacutá nabàlìaca yéetéeyéimiwa sábado ipíchawáise. ");
INSERT INTO pioNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Aiba asìali yàanàaca íipidenéerica José, Arimatea ìyacàlená mìnali. Yái Joséca, abéeri néená nacáicani, níái Junta Supremaca, israelita íiwacanánáica. Máiní cáimiétaquéeri iyú wenàiwica iicáca yái Joséca, iwàwéerica nacái Dios icùaca macáita. Yá José yàacawa macàaluínináta Pilato yàatalé. Yá isutáca Pilato íicha Jesús iinámi. ");
INSERT INTO pioNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Yá Pilato yéemìacáiná Jesús yéetácatéwa, íná Pilato imáidaca úwi íiwacaliná isutácaténá yéemìawani, asáisí báisícaalíté Jesús yéetáwa. ");
INSERT INTO pioNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Yá úwi íiwacaliná icàlidaca iríni báisícani Jesús yéetácatéwa, ínáté Pilato imàacaca José yeedáca Jesús iinámi cruz íicha. ");
INSERT INTO pioNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Néese José iwènìaca manuíri wáluma lino yáawamíirica. Yá yeedáca Jesús iinámi cruz íicha. Yá yéepùacani wáluma linoíri iyú, càide iyúwaté judío íiwitáise ìyáaná. Néese irìadaca Jesús iinámi càliculìi irìculé. Yái càliculìica áibanái íicacaténi dúli íbéeri ibàlài irìcu, yéewacaténá càliculìicani càide iyúwa capìi imàdáaná. Yá José ibàlìaca càliculìi inùma manuíri íba iyú. ");
INSERT INTO pioNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","María Magdalena, áiba María nacái, úái José yáatúaca, naicácaté alénácaalí nalìada Jesús iinámi. ");
INSERT INTO pioNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Néeseté sábado idénáami, judíonái iyamáidacatáicawa, catáca yàacawa yáté sábadoca, yá María Magdalena, áiba María nacái, úái Santiago yáatúaca, áiba inanái nacái íipidenéechúaca Salomé, nawènìaca pumèníiri isàni nacàlàlìacaténáni Jesús iinámi ìwalíise, càide iyúwaté judío íiwitáise ìyáaná. ");
INSERT INTO pioNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Yá domingo mapisáisíwa tàacáwa, níái inanáica nàacawa càliculìi nérépiná mapisáisíwata idécanáamité èeri imusúacawa. ");
INSERT INTO pioNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Yá náimaca nalíwáaca idècunitàacá nàacawa àyapulìcubàa: —‍¿Cawinásica iyúudàapiná wía weedácaténá manuíri íba càliculìi inùma íicha? —‍náimaca nalíwáaca. ");
INSERT INTO pioNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Quéwa nàanàaca néré, yá naicáca manuíri íba càmíiri ibàlùawa inùma irìcu. Náináidacawa manuísíwata naicáidaca íba irí máinícáiná manuíricani yái íbaca. ");
INSERT INTO pioNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Yá nawàlùacawa naicáwa càliculìi irìculé. Naicáca néré ùuculìiri yáawinéericawa néewápuwáise cabalèeri ináawani cáaléeri. Yá cáaluca naicácani, níái inanáica. ");
INSERT INTO pioNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Quéwa íimaca nalí: —‍Picácué cáalu pía nuícha. Núalíacawa picutácuéca pìacawa Jesús, Nazaret ìyacàlená néeséericaté, yái natàtèericaté cruz ìwali. Yáta idéca icáucàacawa. Canáca cháníi. Piicácuéca chái nalìadacatáimicani. ");
INSERT INTO pioNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Pìacué picàlidaca yéewáidacalénái iríni, Pedro irí nacái. Càicué píimaca nalí: ‘Jesús yàapinácuéwa pipíchalé Galilea yàasu cáli néré. Yá piicápinácué néréni càide iyúwaté icàlidáanácué piríni’, càicué píimaca nalí —‍íimaca yái ángelca. ");
INSERT INTO pioNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Néese níái inanáica namusúacawa napìacawa càliculìi íicha, cáalucáiná nía. Yá quéechacáwa càmita nacàlida áibanái iríni, cáalucáináté nía. ");
INSERT INTO pioNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Jesús imichàacatéwa yéetácáisi íicha domingo irìcu amalácaalíté yàacawa. Yáté èerica, quéechacáwa imàacaca yáawawa María Magdalena iicácani, úái inanái Jesús yúuquéechúacaté íicha siete namanùbaca demonio idacuèyéicaté uíwitáise. ");
INSERT INTO pioNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Néese uicácanáamité Jesús, yá ùacawa ucàlidaca nalíni níái yèepuníiyéicatéwa Jesús yáapicha, achúméeyéica iwàwa, íicháaníiyéica ìyaca nacái. ");
INSERT INTO pioNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Néemìaca ucàlidáaná cáuca Jesús, uicácani nacái quéwa càmita neebáida utàacái. ");
INSERT INTO pioNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Néeseté àniwa Jesús imàacaca yáawawa áiba iicácanásita pucháiba yéewáidacalénái iicácani, pucháiba wenàiwica yèepuníiyéicatéwa ìyaca àyapulìcubàa Jerusalén ìyacàlená íicha, manacúalibàa. ");
INSERT INTO pioNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Nadécadénáami naicácani, yá nèepùacawa Jerusalén ìyacàlená irìculé, nacàlidaca Jesús yéewáidacalénái iríni. Càmita quéwa Jesús yéewáidacalénái yeebáida nàasu tàacáisi. ");
INSERT INTO pioNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Néeseté àniwa Jesús imàacaca yáawawa naicácani, níái once namanùbaca yéewáidacaléca idècunitàacá nayáaca nayáacaléwa. Yàalàaca nía cachàiníiri iyú càmicáináté neebáidacáwa icáucàacatéwa, càmicáináté nacái nawàwa néewáidacawa, càmicáináté nacái neebáida néenánái itàacáiwa, níái iiquéeyéicaté Jesús idécanáamité icáucàacawa. ");
INSERT INTO pioNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Néese Jesús íimaca nalí: “Pìacuéwa macái cáli íinatalé. Picàlidacué tàacáisi macái wenàiwica irí, yái tàacáisi íiméerica nuwasàaca wenàiwica Dios yàasu yùuwichàacáisi íicha. ");
INSERT INTO pioNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Cawinácaalí yeebáidéeyéica nutàacái, ibautizéeyéica nacáiwa, níacata nuwasèeyéipináca Dios yàasu yùuwichàacáisi íichawa. Aibanái càmíiyéica iwàwa yeebáidaca nutàacái, Dios yùuwichàidapiná níawa nabáyawaná ìwalíisewa. ");
INSERT INTO pioNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Níái yeebáidéeyéica nutàacái namànipiná yái càmíirica wenàiwica idé imànica, náasáidacaténá báisíiricani, yái tàacáisica nacàlidéerica nalí nùwali. Càipiná namànica nuíwitáise iyúwa nasutácáiná níawawa nuícha: Náucapiná demonio wenàiwica íichawa nuípidená ìwali; natàanípiná áiba tàacáisi iyú, càmíiyéicáwa náalíawa ìwali. ");
INSERT INTO pioNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Yá namàacacaalí nacáapiwa àapi ìwali, nàuwidenái nàacaalí nàiraca iculále, càmita néetáwa iyú. Namàacapiná nacái nacáapiwa cáuláiquéeyéi ìwali nasutácaténá nalí Dios íicha, yá nachùnìapiná cáuláiquéeyéi, nuípidená ìwali”, íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Néeseté Wáiwacali Jesús idécanáamité icàlidaca nalí yái tàacáisica, yá Dios itécani náicha chènuniré. Yá Jesús yáawinacawa Dios yéewápuwáise icùacaténá yáapicha macáita. ");
INSERT INTO pioNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Néesetécáwa Jesús yéewáidacalénái nàacatéwa Jerusalén ìyacàlená íicha, nacàlidacaténáté Jesús itàacái macái cáli íinata. Yá Wáiwacali iyúudàaca nía, imàacaca namànica yái càmíirica wenàiwica idé imànica, náasáidacaténáté áibanái irí báisíiricani yái Dios itàacáica.");
INSERT INTO pioNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Manùbéeyéi wenàiwica nadéca natànàaca tàacáisi nacàlidacaténá càinácaalíté Jesucristo ìyáaná wèewi yèepunícaalítéwa chái èeri irìcu. ");
INSERT INTO pioNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Jesús yáapichéeyéi naicácaté natuí iyúwani macáita yái Jesucristo imàníirica. Néese Dios ichùulìacaté nía nacàlidáanápiná áibanái iríni yái báisíiri tàacáisica Jesucristo ìwali iyúwaté naicáaná macáita. Néeseté néewáidaca wía. Iná madécaná wenàiwica nadéca natànàaca tàacáisi càide iyúwaté Jesús yáapichéeyéi yéewáidáanáté nía. ");
INSERT INTO pioNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Núa, Lucas, nubànùa pirí cuyàluta, Teófilo, nùacawéeriná máiní cáimiétacanéeri. Nudéca nuéwáidacawa Jesucristo iináwaná ìwali macáita cayábéeri iyú. Yá nuínáidacawa cawàwanáta cayábaca nutànàacaalí pirí tàacáisi Jesucristo iináwaná ìwali machàcaníiri iyú. ");
INSERT INTO pioNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Iná nutànàaca pirí yái cuyàlutaca yéewanápiná píalíacawa cayába yái báisíiri tàacáisica Jesucristo ìwali càide iyúwaté áibanái yéewáidáaná pía. ");
INSERT INTO pioNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Bàaluité rey Herodes icùacaalíté Judea yàasu cáli, néenialí ìyacaté sacerdote íipidenéeri Zacarías, abéeri Abías itaquénáinámi yéená, Aarón itaquérinámi nacái. Sacerdotenáica níái Abías itaquénáinámica íibaidéeyéicaté Dios irípiná templo irìcu. Zacarías yàacawéetúa uípidená Elisabet, abéechúa Aarón itaquétúanámica nacái úa. ");
INSERT INTO pioNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Zacarías, Elisabet nacái nàyacaté machacàníiri iyú càide iyúwa Dios iwàwáaná, namàni nacái macáita càide iyúwaté Dios ichùulìaná israelitanái imànica, íná canácata yáaliméeri icháawàaca naináwaná ìwali. ");
INSERT INTO pioNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Quéwa méenibeca nía càmicáiná yéewa quéenibeca Elisabet. Máiní nacái béeyéica nía. ");
INSERT INTO pioNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Yái sacerdote Zacaríasca íibaidacaté Dios irípiná imanùbaca yáapichawa templo irìcu. Aiba èerité iwàwacutá namànica culto Dios irípiná templo irìcu nàacaténá Dios icàaluíniná. ");
INSERT INTO pioNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Càide iyúwaté sacerdote íiwitáise ìyáaná, náucaca náichawa suerte náalíacaténátéwa chánácaalí néená iwàluèripináwa templo irìculé. Yá needáca Zacarías iwàlùanápináwa yeemácaténá pumèníiri isàni Dios yàasu templo irìcu. ");
INSERT INTO pioNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Iná Zacarías iwàlùacawa templo irìculé. Idècunitàacá yeemáca pumèníiri isàni, manùba wenàiwica nasutáca Dios íicha templo ibàacháwalená irìcu. ");
INSERT INTO pioNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Néese abéeri ángel Dios ibànuèri chènuníise imàacaca yáawawa Zacarías iicácani. Yái ángel ibàlùacawa altar yéewápuwáise, yái altar neemácatáica íinata pumèníiri isàni. ");
INSERT INTO pioNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Iicácáiná ángel, yá Zacarías íináidacawa iicáidaca irí manuísíwata, máiní cáalu nacáicani, yái Zacaríasca. ");
INSERT INTO pioNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Quéwa ángel íimaca irí: —‍Picá cáalu pía nuícha, Zacarías, Dioscáiná idéca yéemìaca pisutáaná íicha. Pìacawéetúa Elisabet quéenibéechúapiná piríwa abéeri sùmàiwa; pimàni íipidená Juan. ");
INSERT INTO pioNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","15","Imusúacaalípiná iicá èeriwa, yá máiní casíimáica piwàwa, cayábasíwata piicácani. Casíimáipiná nacái nawàwa áibanáica madécaná, máinícáiná cachàiníirica pìiri íiwitáise Dios ìwali. Càmíiripináta ìira ipuíri, uva ituní nacái, canásíwata. Espíritu Santo icùapiná íiwitáise càiripináta, icùapiná íiwitáise nacái ipíchawáise imusúaca iicá èeri. ");
INSERT INTO pioNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Néese iwènúadapiná náiwitáise àniwa Nacuèriná Dios irípináwa, níái manùbéeyéi Israel itaquénáinámica, neebáidacaténá àniwa Nacuèriná Dios itàacáiwa. ");
INSERT INTO pioNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Yái pìirica Juanca icàlidapiná nalíwa Wáiwacali iináwaná ìwali ipíchawáise Wáiwacali yàanàaca. Máiní cachàiníiri íiwitáise yái pìirica, càide iyúwaté profeta Elías bàaluité. Iwènúadapiná nasèenái íiwitáise cáininácaténá naicáca néenibewa. Iwènúadapiná nacái náiwitáise, níái càmíiyéica yeebáida Dios itàacái, náalíacaténáwa càinácaalí iwàwacutáaná namànica nàyacaténá càide iyúwa Dios iwàwáaná. Càita pìiri iwènúadapiná wenàiwicanái íiwitáise yéewacaténá neebáidaca Wáiwacali itàacái yàanàacaalípiná nàatalé —‍íimaca yái ángelca. ");
INSERT INTO pioNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Néese Zacarías isutáca yéemìawa ángel: —‍¿Càinásica yéewaná núalíacawa asáisí báisícaalí yái tàacáisi picàlidéerica nulí? Máinícata béerica núa, càita nacái nùacawéetúa béeruta nacái úa —‍íimaca yái Zacaríasca. ");
INSERT INTO pioNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Yá ángel íimaca irí: —‍Núacata Gabriel, nuíbaida nacái Dios irípiná. Dios idéca ibànùaca núa nutàanícaténá píapicha nucàlidacaténá pirí yái tàacáisi cayábéerica. ");
INSERT INTO pioNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Quéwa siùcade càmita yéewa pitàaníca àta pìiri imusúacatalétawa, yásí yéewa pitàaníca àniwa, càmicáiná peebáida yái núumáanáca pirí. Néese, yái núumáanáca pìiri ìwali piiquéeripinácawa yéenáiwaná yàanàacaalíwa —‍íimaca yái ángelca. Néese ángel yàacawa Zacarías íicha. ");
INSERT INTO pioNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Idècunitàacá Zacarías itàaníca ángel yáapicha, áibanái wenàiwica bàacháwáiséeyéica nacùaca Zacarías imusúacawa. Náináidacawa manuísíwata cáná yéewa càmita imusúacàatétawa templo irìcuíse. ");
INSERT INTO pioNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Atata Zacarías imusúacawa, yáté càmita yéewa itàaníca náapicha, íná náalíacawa iicácaté yéenáiwanási nacáiri Dios néeséeri templo irìcu, itàanícáiná náapicha icáapi iyúwa, càmicáiná yéewa itàaníca. Yá matàacáica mamáalàacatani. ");
INSERT INTO pioNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Idécanáamité imáalàidaca imànica íibaidacaléwa Dios irípiná templo irìcu, yá Zacarías yèepùacawa icapèe néréwa. ");
INSERT INTO pioNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Néesecáwa yàacawéetúa Elisabet udéerìcuca sùmài. Yá cinco quéeri càmíichúata imusúawa icapèe irìcuísewa. Uumaca uínáidacawa ulíwa: ");
INSERT INTO pioNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Dios idéca iicáca nupualé yéewanápiná càmita quirínama wenàiwicanái iicáaníca nuquíniná méenibéenáca núa”, úumaca. ");
INSERT INTO pioNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Elisabet udènìacaté seis quéeri udéerìcúuná, yáté Dios ibànùaca ángel íipidenéeri Gabriel yàanápináwa Nazaret ìyacàlená néré, ìyéerica Galilea yàasu cáli íinata. ");
INSERT INTO pioNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Dios ibànùacaté Gabriel icàlidacaténá tàacáisi abéechúa mànacàu irí, íipidenéechúa María, càmíichúacáwa iimá asìali yáapicha, quéwa imàníichúacaté matrimonio ùyacàle mìnanái yàacuésemi. Uacawéeripiná íipidená José, abéeri rey David itaquérinámi. ");
INSERT INTO pioNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Yái ángel yàanàaca María yàatalé, yá íimaca ulí: —‍Péemìa cayába, Dios imànipiná pirí cayábéeri manuí. Dios ìyaca píapicha. Dios iyúudàapiná píawa manuísíwata áibanái inanái íicha canánama —‍íimaca yái ángelca. ");
INSERT INTO pioNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","María iicácaalí ángel, yá ucalùadacawa manuísíwata uémìaca íimáaná ulí. Yá uínáidacawa càinácaalísica íimáaná yái tàacáisi ángel itàidéerica iyú úa. ");
INSERT INTO pioNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Néese ángel íimaca ulí àniwa: —‍María, picá cáalu pía nuícha, cayábacáiná Dios iicáca píiwitáise. ");
INSERT INTO pioNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Iná péemìa cayábani, mesúnamáita pidéerìcuca. Pidènìapiná pìiriwa. Pimàni íipidená Jesús. ");
INSERT INTO pioNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Nacuèrinápinácani, cachàiníiri íiwitáise, icùapiná níawa. Náimapiná ìwali Dios chènuníiséeri Iiricani. Wacuèriná Dios imàacapiná pìiri icùaca Israel itaquénáinámi càide iyúwaté yàawirimi rey David icùanáté nía. ");
INSERT INTO pioNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Icùapiná nía càiripináta, níái Israel itaquénáinámica. Càmíiripináta iyamáida icùaca nía —‍íimaca yái ángelca. ");
INSERT INTO pioNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","María íimaca ángel irí: —‍¿Càinásica yéewaná quéenibeca núa càmíichúacáwa ìya asìali yáapicha? —‍úumaca úái Maríaca. ");
INSERT INTO pioNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Yá ángel íimaca ulí: —‍Espíritu Santo yàanàapiná pìataléwa. Dios chènuníiséeri íiwitáise iyamáapinácawa piwicáulé iyúwa acalèe. Iná yéewa yái sùmài pimusúadéeripináca iicá èeri íipidená Mabáyawanéeri. Iipidená nacái Dios Iiri. ");
INSERT INTO pioNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ua nacái péenásàatúaná íipidenéechúaca Elisabet udènìapiná uìriwa, éwita máinícáaníta béeruca úa. Uái nacàlidéechúacaté ìwali càmíichúasa yáalimá quéenibeca, úata udéca udéerìcuca sùmài seis quéeri siùcade udécadénáami udéerìcuca. ");
INSERT INTO pioNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Dios yáalimácáiná imànica macáita, íná canácata máiníiri càulenáca Dios íicha —‍íimaca yái ángelca. ");
INSERT INTO pioNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Iná María íimaca: —‍Núacata yái Wacuèriná Dios yàasu wenàiwicaca. Yá numàacaca Dios imànica nulí càide iyúwa píimáaná nulí —‍úumaca úái Maríaca. Néese, ángel yèepùacawa uícha. ");
INSERT INTO pioNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Néenialíté María ùacàatécatawa áiba yàcalé néré ìyéerica Judea yàasu cáli dúlinaméeri íinata. Zacarías, Elisabet nacái nàyacaté néré. ");
INSERT INTO pioNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Yá María uwàlùacawa nacapèe irìculé, níái Zacaríasnáica. Yá utàidaca Elisabet. ");
INSERT INTO pioNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Elisabet uémìacanacáita María itàidaca úa, yá mùlimùlicani yái sùmài achúméeríinaca Elisabet idéerìcuírica. Yá Espíritu Santo icùaca Elisabet íiwitáise. ");
INSERT INTO pioNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Néese Elisabet úumaca cachàiníiri iyú María irí Espíritu Santo inùmalìcuíse: —‍¡Dios idéca imànica pirí cayábéeri áibanái inanái íicha canánama! ¡Idéca nacái imànica cayábéeri pìiri irí! ");
INSERT INTO pioNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Càmita núalíawa cáná yéewa Dios imànica nulí yái cayábéerica imàacáaná Nuíwacali yáatúa ùanàaca nùatalé upáchiaca núa. ");
INSERT INTO pioNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Nuémìacanacáita pitàidaca núa, yáta nuìri imùlimùliacawa nudèerìcu casíimáicáináni. ");
INSERT INTO pioNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","¡Dios imàacaca casíimáica piwàwa peebáidacáináté imàníinápiná pirí cayábéeri càide iyúwa íimáaná pirí! —‍úumaca úái Elisabetca. ");
INSERT INTO pioNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Néese María íimaca: “Nucàlidaca manuísíwata Wacuèriná Dios iináwaná ìwali, máiní cayábéericani; ");
INSERT INTO pioNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Casíimáica nuwàwa Dios yáapicha, yái iwasèerica núa yàasu yùuwichàacáisi íichawa. ");
INSERT INTO pioNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Casíimáica nuwàwa Dios yáapicha, Dioscáiná idéca iicáca nupualé, núa yàasu wenàiwica càmíichúa máiní cachàini. Yá siùcáisede macái wenàiwica nacàlidapiná nuináwaná ìwali Dios idéca imàacaca casíimáica núa. ");
INSERT INTO pioNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Casíimáica núa, yácáiná yái Dios Cachàiníirica náicha canánama idéca iyúudàaca núa manuísíwata. ¡Yácata yái Mabáyawanéerica, yái Diosca! ");
INSERT INTO pioNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Dios iicáca napualé càiripináta cawinácaalí wenàiwica yèeyéica icàaluíniná. ");
INSERT INTO pioNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Dios imànipiná madécaná ichàini manuíri iyúwa. Imawènìadapiná wenàiwica cachàiníiyéica iicáca yáawawa. ");
INSERT INTO pioNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Níái icuèyéica èeri mìnanái, Dios yúucapiná níawa nàalubái íinatáisewa, yá càmita ibatàa nacùaca wenàiwicanái quirínama. Yá Dios imichàidapiná áibanái càmíiyéi máiní cachàini icuèyéipináca wenàiwica náamirìcubàami. ");
INSERT INTO pioNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Dios yàapiná madécaná cayábanaméeri wawàsi máapíiyéi wenàiwica irí. Ichùulìapiná càasuíyéi wenàiwica nèepùanápináwa íicha. Yásí nèepùacawa íicha canéeyéi irí wawàsi icáapi irìcuwa. ");
INSERT INTO pioNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Dios iyúudàapináca wíawa, wía yàasu wenàiwicaca, Israel itaquénáinámica. Càmíiripináta iimáicha iicáca wapualé icùacaalípiná wía. ");
INSERT INTO pioNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Dios icàlidacaté càiri tàacáisi wàawirináimi irí, yá imànipiná càiripináta càide iyúwaté íimáaná nalí, yái Abrahamca, wía nacái itaquénáinámica”, úumaca úái Maríaca. ");
INSERT INTO pioNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","María iyamáacawa Elisabet yáapicha máisiba quéeri, néese máisiba quéeri idénáami, yá María uèpùacawa ucapèe néréwa. ");
INSERT INTO pioNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Néeseté yàanàaca Elisabet yéenáiwaná umusúadáanápiná iicá èeri, yá umusúadaca uìriwa. ");
INSERT INTO pioNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Néese uyaquewéeyéi, uénánái nacái néemìaca uináwaná ìwali Dios iicácaté upualé manuísíwata. Iná nàaca napáchiaca úa, nàacawéeridacaténá úa casíimáiri iyú. ");
INSERT INTO pioNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Néeseté yái sùmàica idènìacanáamité ocho èeri, yá natécani namànicaténáté irí circuncisión. Yá néese nawàwa namànica íipidená Zacarías càide iyúwa yáaniri íipidená. ");
INSERT INTO pioNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Quéwa yáatúa íimaca nalí: —‍Càmíirita, néese íipidenápiná Juan —‍úumaca nalí. ");
INSERT INTO pioNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Yá náimaca ulí: —‍¿Cáná? Canámita péenánái càiri íipidená —‍náimaca. ");
INSERT INTO pioNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Néese natàaníca nacáapi iyúwa sùmài yáaniri irí nasutácaténá néemìawani càinácaalí iwàwáaná yàaca íipidená. ");
INSERT INTO pioNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Yá yáaniri isutáca náicha achúméeri tablero itànàacatáipiná sùmài íipidená. Yá itànàacani: “Iipidenápiná Juan”, íimaca itànàaca. Yá macáita náináidacawa naicáidaca manuísíwata Zacarías irí. ");
INSERT INTO pioNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Yáta yéewa itàaníca yái Zacaríasca. Yá idàbaca yàaca Dios irí cayábéeri. ");
INSERT INTO pioNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Néese cáaluca náináidacawa macáita níái nayaquewéeyéica. Yá macái wenàiwica ìyéeyéicaté Judea yàasu cáli dúlinaméeri íinata nacàlidaca nalíwáaca càinácaalíté Zacaríasnái ichàbáanáwa. ");
INSERT INTO pioNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Yá macáita yéemièyéica naináwaná ìwali náináidacawa nawàwalìcuísewa manuísíwata, náimaca nalíwa: “¿Càinásica imànipiná béericaalíni, yái sùmàica?” cài náináidacawa. Báisícáináta mamáalàacata Dios iyúudàacani manuísíwata íiwitáise cachàiníiri iyúwa. ");
INSERT INTO pioNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Néeseté Espíritu Santo icùaca Zacarías íiwitáise, yái sùmài yáanirica. Yá Zacarías icàlidaca tàacáisi Dios inùmalìcuíse. Yá íimaca: ");
INSERT INTO pioNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“¡Wàacué irí cayábéeri, yái Wacuèriná Dios, yái icuèrica wía, wía Israel itaquénáinámica, yàanàapinácáiná wàatalé iwasàacaténá wía yàasu yùuwichàacáisi íichawa, wía yàasu wenàiwicaca! ");
INSERT INTO pioNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Dios ibànùapiná walí abéeri cachàiníiri íiwitáise iwasèeripiná wía Dios yàasu yùuwichàacáisi íicha. Yái yàanèeripináca wàatalé, yácata rey David itaquérinámica, yái David Dios yàasu wenàiwicaca bàaluité. ");
INSERT INTO pioNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Dios idéca imànica walí càide iyúwaté yàasu profetanái icàlidáaná tàacáisi Dios inùmalìcuíse. ");
INSERT INTO pioNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Nacàlidacaté Dios iwasàanápináté wía wàuwidenái íichawa, náicha nacái macáita wenàiwica báawéeyéica iicáca wía. ");
INSERT INTO pioNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Profetanái icàlidacaté nacái Dios iicáanápináté wàawirináimi itúulécaná, yá nacái càmita iimáicha wawàsi mabáyawanéerica imàníiricaté wàawirináimi yáapicha. ");
INSERT INTO pioNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Yácata tàacáisi Dios icàlidéericaté máiní cáimiétacanéeri iyú wàawirimi Abraham irí: ");
INSERT INTO pioNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Iwasàapiná wíawa wàuwidenái íichawa wáibaidacaténá irípiná macàaluínináta, ");
INSERT INTO pioNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","wàyacaténá nacái Dios iicápiná machacàníiri iyú, mabáyawanéeri iyú nacái macái èeri idècunitàacá wàyaca chái èeri irìcu. ");
INSERT INTO pioNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Néese pía, nuìrica, béericaalípiná pía, yásí Dios chènuníiséeri, cachàiníiri náicha canánama, íimapiná pìwali yàasu profetaca pía, picàlidacáiná wenàiwicanái irí Wáiwacali iináwaná ìwali ipíchawáise yàanàaca, pimichàidacaténá irípiná wenàiwicanái íiwitáise, nacùanápiná Wáiwacali yàanàaca nàatalé, neebáidáanápiná Wáiwacali itàacái. ");
INSERT INTO pioNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Péewáidapiná Wáiwacali yàasu wenàiwica náalíacaténáwa Dios imàacáanápiná iwàwawa nabáyawaná íicha, iwasàanápiná nía nacái yàasu yùuwichàacáisi íichawa. ");
INSERT INTO pioNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Yácáiná Wacuèriná Dios iicáca wapualé manuísíwata, yá nacái ibànùapiná walíni chènuníise yái ichàiniadéeripináca wawàwa càide iyúwa èeri icamaláná isíimáidacaalí wawàwa èeri imusúacanáamiwa amalácaténá wawicáu àniwa. ");
INSERT INTO pioNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Yácata yàanèeripiná amalácaténá imànica wáiwitáise wía catéeyéica íiwitáise, cáaluíyéica iicáca yéetácáisi. Yàanàaca yéewáidacaténá wía wàyacaténá machacàníiri iyú yéewanápiná matuíbanáica wía”, íimaca yái Zacaríasca. ");
INSERT INTO pioNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Néese yái sùmàica idàwinàacawa, cachàinica nacái íiwitáise Dios ìwali. Néese béericanáami yái Juanca, yáté ìyaca manacúali yùucubàa càináwàiri canácatalé wenàiwica, àta Dios ichùulìacataléta icàlidaca tàacáisi Dios inùmalìcuíse israelitanái irí. ");
INSERT INTO pioNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","2","Néenialíté, Cirenio icùacaalíté Siria yàasu cáli, néese emperador Agusto idàbacaté ichùulìaca natànàaca náipidenáwa, macái èeri mìnanái imanùbaca, yéewacaténá romanonái iputàaca nía. ");
INSERT INTO pioNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Iwàwacutá macáita nèepùacawa nàawirináimi ìyacàle néréwa àniwa natànàacaténá náipidenáwa néenibàata. ");
INSERT INTO pioNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Ináté José yàaca nacáiwa Nazaret ìyacàlená íicha, Galilea yàasu cáli néese, yàacaténáwa Judea yàasu cáli néré, Belén ìyacàlená irìculé, rey David imusúacatáicaté iicá èeri. Rey David itaquérinámica yái Joséca, ínáté yèepùacawa néré àniwa. ");
INSERT INTO pioNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Yá yàacawa Belén ìyacàlená néré yái Joséca itànàacaténá íipidenáwa María yáapicha úái yàacawéetúapináca. Idéerìcuíchúacáwa úái Maríaca. ");
INSERT INTO pioNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Néese idècunitàacá nàyaca Belén ìyacàlená néré, yáté yàanàaca María yéenáiwaná umusúadáanápiná iicá èeri. ");
INSERT INTO pioNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Canáca nalí naimácatáipiná, manùbacáiná wenàiwica yàanàacaté Belén ìyacàlená irìculé. Atata nàanàaca pìrái yàalu, naimácatáipiná. Yá umusúadaca iicá èeri yái idàbáanéerica uìrica. Yá uépùacani wáluma iyú. Néese ulìadaca uìriwa pìrái iyáacàalu irìculé, canácáiná áiba naimácatáipiná. ");
INSERT INTO pioNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Mawiénita Belén ìyacàlená irí nàyacaté abénaméeyéi asìanái icuèyéicaté ipìranáiwa oveja. Nàyaca manacúalibàa táiyápinama, nacùacaténá napìranái ovejawa. ");
INSERT INTO pioNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Yáta Dios yàasu ángel imàacaca yáawawa naicácani. Yá Dios icamaláná icànaca natéese, yá máiní cáaluca nía. ");
INSERT INTO pioNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Quéwa ángel íimaca nalí: —‍Picácué cáalu pía nuícha, nutécáinácué pirí cayábéeri tàacáisi, isíimáidéeripiná manuísíwata macái wenàiwica: ");
INSERT INTO pioNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Siùca èeri idéca imusúaca iicá èeri, yái iwasèeripinácuéca píawa Dios yàasu yùuwichàacáisi íicha. Belén ìyacàlená irìcu rey David imusúacatáicaté iicá èeri, idéca asáica yái Wáiwacalica, yái Mesíasca, judío icuèrinápináca. ");
INSERT INTO pioNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Pìanèeripinácué néepuèri wáluma iyú, irìacawa pìrái iyáacàalu irìcu, píalíacaténácuéwa càiríinácaalíni yáara quìrasìica —‍íimaca nalí yái ángelca. ");
INSERT INTO pioNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Yáta madécaná ángelnái namàacaca níawawa chènuníise asìanái iicácaténá nía ángel yáapicha, yèeyéica Dios irí cayábéeri. Náimaca: ");
INSERT INTO pioNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“¡Pìacué Dios chènuníiséeri irí cayábéeri! ¡Máiní matuíbanáiri iyú nàyaca cawinácaalí èeri mìnanái casíimáiyéica Dios iicáca íiwitáise!” náimaca ángelnáica. ");
INSERT INTO pioNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Idécanáamité ángelnái nèepùacawa náicha chènuniré, néese níái icuèyéica ovejanái náimaca nalíwáaca: —‍Wàacuéwa Belén ìyacàlená néré waicácaténá càinácaalí ìyáaná, Wacuèriná Dios icàlidéerica walí iináwaná ìwali —‍náimaca nalíwáaca níái icuèyéica ovejanái. ");
INSERT INTO pioNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Yáté nàacàatécatawa néré. Yá nàanàaca María, José nacái, quìrasìi nacái irièriwa pìrái iyáacàalu irìcu. ");
INSERT INTO pioNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Néese naicácáináni, íná nacàlidaca áibanái iríni yái tàacáisi ángel icàlidéericaté nalí quìrasìi ìwali. ");
INSERT INTO pioNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Yá macáita wenàiwica yéemièyéica quìrasìi iináwaná, náináidacawa manuísíwata càinácaalí íimáaná yái tàacáisi nacàlidéerica quìrasìi ìwali, níái icuèyéica ovejanái. ");
INSERT INTO pioNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Maríata quéwa, canácatáita uimáicha quirínama càinácaalíté náimáaná uìri ìwali, uínáidacawa mamáalàacata nàasu tàacáisi ìwali. ");
INSERT INTO pioNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Néese níái icuèyéica ovejanái nèepùacawa náicha napìranái yàatalépináwa. Casíimáiri iyú nacàlidaca Dios iináwaná ìwali cayábéericani, nàaca nacái Dios irí cayábéeri ìwali macáita yái naiquéerica, néemìaca nacái, macáicáináta ichàbacatéwa càide iyúwaté ángel íimáaná nalí. ");
INSERT INTO pioNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Ocho èeri imusúacadénáamiwa yái sùmàica, yáté namànica irí circuncisión. Yá nàaca íipidená Jesús, càide iyúwaté ángel icàlidáanáté María irí íipidenápiná, ipíchawáiseté udéerìcuca sùmài. ");
INSERT INTO pioNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Néese cuarenta èeri imusúacadénáamiwa, yáté iwàwacutá namànica càide iyúwaté profeta Moisés ichùulìanáté israelitanái imànica Dios inùmalìcuíse, masacàacaténá Dios iicáca nía àniwa, nasutáanápiná Dios íicha àniwa templo irìcu. Iná natéca sùmài Jerusalén ìyacàlená néré, yáasáidacaténáni Dios irí. ");
INSERT INTO pioNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Càité namànica yácáiná profeta Moisés itànàacaté càiri tàacáisi Dios inùmalìcuíse: “Asìalicaalí idàbáanéerica uìrica, yásí Dios yàasu wenàiwicapinácani yái sùmàica”, cài itànàacaté profeta Moisés. ");
INSERT INTO pioNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Ináté nàacawa namànicaténá sacrificio Dios irípiná, nanúanápiná pucháiba unùcu, càide iyúwaté Dios ichùulìaná judíonái imànica catúulécanácaalí nía. Iwàwacutá nàaca pucháiba unùcu púubéeyéi, càmicaalí nacái, nàaca pucháiba unùcu manuínaméeyéi yéenibe. Ináté José, María nacái namàacaca pucháiba unùcu Dios irípiná ofrenda iyú catúulécanácáiná nía. ");
INSERT INTO pioNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Néenialíté ìyaca asìali Jerusalén ìyacàlená mìnali íipidenéeri Simeón. Yái asìali máiníiri cayábaca íiwitáise, ìyéerica machacàníiri iyú, yèeri nacái Dios icàaluíniná, icùa nacái Dios iwasàaca Israel itaquénáinámi nàuwichàacái íichawa. Espíritu Santo nacái yàacawéeridaca Simeón. ");
INSERT INTO pioNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Espíritu Santo imàacacaté Simeón yáalíacawa càmíinápináté yéetáwa àta idécataléta iicáca Mesías, yái asìali Dios ibànuèripinácaté israelita icuèrinápináca. ");
INSERT INTO pioNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Néese Espíritu Santo ichùulìaca Simeón yàanápináwa templo néré. Yáté Simeón ìyaca templo irìcu nàanàacaalíté néré níái sùmài isèenáica, yái sùmàica íipidenéerica Jesús. Natécaté Jesús templo néré namànicaténá càide iyúwaté profeta Moisés itànàaná Dios itàacái israelitanái imàníinápiná néenibe asìanái iríwa. ");
INSERT INTO pioNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simeón yeedáca Jesús yàanalìculéwa, yá Simeón yàaca Dios irí cayábéeri. Néese Simeón íimaca: ");
INSERT INTO pioNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Pía, Nucuèriná Dios, siùca pidéca pimànica càide iyúwa píimáanáté nulí; yásí cayábaca pimàacaca nuétácawa matuíbanáiri iyú, núa pìasu wenàiwicaca. ");
INSERT INTO pioNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Nudéca nuicácani nutuí iyúwa, yái iwasèeripináca wenàiwicanái Dios yàasu yùuwichàacáisi íicha, ");
INSERT INTO pioNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","càide iyúwa pichùulìaná imànica macái èeri mìnanái yàacuésemi. ");
INSERT INTO pioNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Amaláca imànipiná náiwitáise, níara càmíiyéica israelitaca, náalíacaténáwa càinácaalí iwàwacutáaná namànica nàyacaténá càide iyúwa piwàwáaná. Cáimiétacanápiná nacái imànica wíawa, wía pìasu wenàiwicaca, Israel itaquénáinámica”, íimaca yái Simeónca. ");
INSERT INTO pioNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Néese José, úa nacái Jesús yáatúaca náináidacawa néemìaca manuísíwata yái tàacáisica Simeón icàlidéerica sùmài ìwali. ");
INSERT INTO pioNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","35","Néese Simeón isutáca nalí Dios íicha imàníinápiná nalí cayábéeri. Yá íimaca María irí àniwa úái Jesús yáatúaca: —‍Péemìa cayábani Dios idéca ibànùaca yái sùmàica yéewanápiná Israel itaquénáinámi néemìacani. Quéwa néemìacaalípináni, yá manùbéeyéi nacaláapinácawa Dios íicha càmicáiná neebáida itàacái, yái sùmàica. Quéwa áibanái manùbéeyéi nawènúadapiná náiwitáisewa Dios irípiná, neebáidacáiná itàacái, yái pìirica. Dios idéca ibànùacani yáasáidacaténá nalí càinácaalí Dios iwàwáaná nàyaca íná manùbéeyéi wenàiwica nàuwideca namànipinácani. Càita yáasáidapiná càinácaalí ìwali manùbéeyéi wenàiwica náináidacawa nawàwalìcuísewa. Quéwa pía, piicápiná iyúwa macáita ichàbáanáwa, yásí achúmaca piwàwa manuísíwata càide iyúwa espada machete nacáiri idéca nacáicaalí isutàaca pía —‍íimaca yái Simeónca. ");
INSERT INTO pioNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Uyaca nacái inanái templo irìcu icàlidéechúa tàacáisi Dios inùmalìcuíse íipidenéechúa Ana. Uanirimi íipidenáté Fanuel, abéeri Aser itaquérinámi. Máiní béeruca úái Anaca. Ucáasàacatéwa mànacàucaalíté úa. Yáté ùyaca siete camuí ùacawéerimi yáapichawa. ");
INSERT INTO pioNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Néeseté yéetácawa uícha ùacawéerimica, yáté ùyaca templo irìcu ochenta y cuatro camuí idécanáamité ùacawéerimi yéetácawa uícha. Càmita umusúawa templo íicha, uíbaida quéwanáta èeríapinama, táiyápinama nacái Dios irípiná. Umàacaca uíchawa uyáacaléwa, usutá nacái úawawa Dios íicha, ùacaténá icàaluíniná. ");
INSERT INTO pioNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Yáté Ana yàanàaca néré. Uicácanacáita yái sùmài Jesúsca, yá udàbaca ùaca Dios irí cayábéeri ìwali. Yá ucàlidaca áibanái irí Jesús iináwaná ìwali, cawinácaalí wenàiwica icuèyéicaté Dios iwasàanápiná Jerusalén ìyacàlená mìnanái nàuwichàacái íichawa. ");
INSERT INTO pioNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Néese isèenái namáalàidacaté namànica macáita càide iyúwaté Dios ichùulìaná israelitanái imànica, yá nèepùacawa Galilea yàasu cáli néré, nàyacàle nérépináwa, íipidenácatalé Nazaret. ");
INSERT INTO pioNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Néese yái sùmài idàwinàacawa cachàiníiripiná, cáalíacáiri yáwanái nacái. Dios nacái imànica irí cayábéeri. ");
INSERT INTO pioNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Càide iyúwaté Jesús isèenái íiwitáise ìyáaná, nàacawa napáchiaca camuí imanùbaca Jerusalén ìyacàlená néré naicácaténá néré náapicha judíonái yàasu culto íipidenéeri Pascua. ");
INSERT INTO pioNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Jesús idènìacáináté doce camuí, yá nàacawa macáita Jerusalén ìyacàlená néré càide iyúwaté náiwitáise ìyáaná Pascua yàasuná culto ìwali. ");
INSERT INTO pioNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Néese Pascua yàasuná culto idénáami nèepùacawa nàyacàle nérépináwa. Yái sùmài Jesús iyamáacawa Jerusalén ìyacàlená irìcuta. Isèenái quéwa càmita náalíawa iyamáanátéwa náicha. ");
INSERT INTO pioNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Nayúunáidaca Jesús yàacawa imanùbaca yáapichawa, íná nàacawa èeríapinama. Néese nacutáca Jesús namanùbacanái yèewibàawa, néenánái yèewibàa nacáiwa. ");
INSERT INTO pioNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Néese, càmicáináté nàanàa Jesús, yá nèepùaca nàacaténá nacutácani Jerusalén ìyacàlená néré. ");
INSERT INTO pioNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Néese máisiba èeri irìcu, yá nàanàaca Jesús átata templo irìcu. Yái Jesús yáawinéeriwa nèewi níái yéewáidéeyéicaté wenàiwica Dios itàacái iyú templo irìcu. Yéemìaca ìyaca néewáidáaná wenàiwica. Isutáca yéemìawa nía nacái. ");
INSERT INTO pioNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Néese macáita yéemièyéica Jesús íimáaná, yá náináidacawa néemìacani manuísíwata, máinícáiná cáalíacáicani, yáalíacáiná nacái icàlidaca nalíni cáalíacáiri iyú, nasutácaalí néemìawani Dios itàacái ìwali. ");
INSERT INTO pioNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Néese, isèenái nàanàacani, yá náináidacawa manuísíwata naicáidaca irí. Yá María íimaca Jesús irí: —‍Nuìri, ¿cáná pidé cài pimànica walí? Píaniri, núa nacái wadéca wacutáca pía máadáiní, máiní nacái achúmaca wawàwawa wáináidacawa pìwali —‍úumaca. ");
INSERT INTO pioNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Jesús íimaca nalí: —‍¿Cánásicué picutá núa áibalé? ¿Càmitasicué píalíawa iwàwacutáaná nuíbaidaca Núaniri irípináwa icapèe irìcu? —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Càmita quéwa náalía néemìaca càinácaalí íimáaná yái tàacáisi Jesús icàlidéerica nalí. ");
INSERT INTO pioNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Néese, Jesús yèepùacawa náapicha Nazaret ìyacàlená néré. Yá imànica macáita càide iyúwa nachùulìanáni. Quéwa yáatúa íináidacawa mamáalàacata uwàwalìcuísewa ìwali, yái wawàsica. ");
INSERT INTO pioNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Jesús idàwinàacawa yàacawa, cáalíacáica yáwanái nacáicani. Casíimái nacái Dios iicáca íiwitáise. Yá macáita wenàiwica cayábaca naicáca Jesús. ");
INSERT INTO pioNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Idécanáamité emperador Tiberio icùaca macái cáli catorce camuí, néese yàasu quincéená camuí irìcu, yá gobernador Poncio Pilato icùaca ìyaca Judea yàasu cáli. Herodes icùaca ìyaca Galilea yàasu cáli. Herodes yéenásàiri íipidenéeri Felipe icùaca ìyaca Iturea yàasu cáli, Traconite yàasu cáli nacái. Gobernador Lisanias icùaca ìyaca Abilinia yàasu cáli. ");
INSERT INTO pioNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Sacerdote Anás, sacerdote Caifás nacái, níacata sacerdote íiwacanánáica. Néenialíté Dios ichùulìaca Juan el Bautista icàlidáanápiná itàacái wenàiwicanái irí. Iyacaté manacúali yùucubàa càináwàiri yái Juanca, Zacarías ìirimica. ");
INSERT INTO pioNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Ináté Juan yèepunícawa yàacawa mawiénibàa Jordán inanába irí. Yá icàlidaca wenàiwicanái irí iwàwacutáaná nawènúadaca náiwitáisewa Dios irípiná, namàacáanápiná náichawa yái báawéerica namàníirica, nabautizáca nacáiwa neebáidacaténá Dios itàacái, yéewanápiná Dios imàacaca iwàwawa nabáyawaná íicha, yái báawéerica namàníiricaté. ");
INSERT INTO pioNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Bàaluité profeta Isaías itànàacaté tàacáisi Dios inùmalìcuíse Juan el Bautista ìwali. Càité Isaías itànàaca: “Abéeri asìali icàlidapiná nalíwani cachàiníiri iyú manacúali yùucubàa càináwàiri. Càipiná íimaca nalí: ‘Càide iyúwa wenàiwicanái ichùnìacaalí àyapu Náiwacali irípináwa, càita nacái iwàwacutácué pichùnìaca píiwitáisewa Wacuèriná Dios irípiná pitàidacaténácué cayábéeri iyúni. Pichùnìacué píiwitáisewa yéewacaténá yéewáidacuéca pìyaca machacàníiri iyú càide iyúwa Dios iwàwáaná. ");
INSERT INTO pioNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Pichùnìacué píiwitáisewa Wacuèriná Dios irípiná càide iyúwa wenàiwica nachùnìacaalí àyapu Náiwacali irípináwa yéewacaténá yàanàaca nàatalé. Napuníadaca macái manuínaméeyéi utàwi cáli iyú. Náicaca macái dúli, sàabadacaténá nía. Machacànica namànica macái éeruíri àyapu. Cayábaca namànica báawéeri àyapu. ");
INSERT INTO pioNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Yá macái èeri mìnanái naicápiná yái wenàiwica Dios ibànuèrica aléi èeri irìculé iwasàacaténá èeri mìnanái Dios yàasu yùuwichàacáisi íicha’, càipiná íimaca”, íimacaté yái profeta Isaíasca. ");
INSERT INTO pioNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Manùbéeyéi wenàiwica namusúacawa nàyacàle imanùbaca néesewa, yá nasutáca Juan íicha ibautizáanápiná nía. Quéwa Juan yáalíacawa abénaméeyéi càmita nawènúada náiwitáisewa nabáyawaná íichawa báisíiri iyú, ínáté Juan yàalàaca nía cachàiníiri iyú. Iimaca nalí: “¡Píacué, càiyéide iyúwa àapi iculále! Manuíri yùuwichàacáisi yàanàaca mesúnamáita yùuwichàidacaténá wenàiwicanái. Piyúunáidacuéca píalimáaná pichúuliacawa íicha, yái yùuwichàacáisica, pibautizácaalícáitawa, éwitacué càmicáaníta piwènúada píiwitáisewa báisíiri iyú pibáyawaná íichacuéwa. ¡Càmita nucàlidacué pirí càiri chìwái! ");
INSERT INTO pioNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Iwàwacutácué pìyaca machacàníiri iyú càide iyúwa Dios iwàwáaná, yéewanápiná macái wenàiwica naicáca amaléeri iyú piwènúadacuéca píiwitáisewa báisíiri iyú Dios irípiná. Picácué cài píima piríwáaca: ‘Canácatáita Dios yùuwichàida wíawa, ¡Abraham itaquénáinámicáiná wía!’ picácué píima. Péemìacué cayába, éwita Dios imáalàida macáitacué pía pibáyawaná ìwalíisewatá, càicáaníta Dios yáalimá iwènúadaca níái íbaca Abraham itaquénáinámipiná iyútá, Dios yàasu wenàiwicapiná nía píamirìcubàacué. ");
INSERT INTO pioNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Máiní mawiénica yái yùuwichàacáisica Dios imàaquéeripiná yàanàaca báawéeyéi ìwali, càide iyúwa mawiénicaalí wenàiwica iwichùaca àicu ìwali chipàali iyú, càita nacái mawiénica yái Dios yàasu yùuwichàacáisica. Péemìacué comparación: Càide iyúwa wàucacaalí macái àicu canéeri ìyacaná cayába weemácaténá nía quichái irìcu, càita nacái Dios yùuwichàidapiná wenàiwica quichái irìcu, cawinácaalí wenàiwica càmíiyéica imàni cayábéeri càide iyúwa Dios iwàwáaná”, íimaca yái Juanca. ");
INSERT INTO pioNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Ináté manùbéeyéi wenàiwica yàanèeyéicaté Juan el Bautista yàatalé, nasutáca néemìawa Juan. Náimaca irí: —‍¿Càinásica iwàwacutá wamànica? —‍náimaca irí. ");
INSERT INTO pioNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Juan íimaca nalí: —‍Pidènìacaalícué pucháiba bàlesi, pìacué abéeri bàlesi áiba wenàiwica irí canéerica ibàle. Pidènìacaalícué yàacàsi, pìacué nayáapiná, canéeyéica irí yàacàsi —‍íimaca yái Juanca. ");
INSERT INTO pioNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Nàyaca néeni abénaméeyéi yeedéeyéica plata néenánái judío íichawa Roma ìyacàlená yàasu gobierno irípiná. Nàacatéwa néré nabautizácaténáwa. Nasutáca néemìawa Juan: —‍Pía yéewáidéerica wía, ¿càinásica iwàwacutá wamànica? —‍náimaca. ");
INSERT INTO pioNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Juan íimaca nalí: —‍Picácué picobra nía ichàbanamawa. Peedácué náicha càitade iyúwa romanonái ichùulìaná peedáca —‍íimaca yái Juanca. ");
INSERT INTO pioNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Abénaméeyéi úwinái nacái nasutáca néemìawa Juan: —‍Wía nacái, ¿càinásica iwàwacutá wamànica? —‍náimaca. Juan íimaca nalí: —‍Picácué pibáulia pinúaca wenàiwica piyéedùacaténá nàasu. Picácué picháawàa naináwaná ìwali pichìwa iyúwa, peedácaténá piríwa nàasu. Casíimáicué nacái piicáca piwèniwa romanonái yàasu gobierno yèericuéca pirí —‍íimaca yái Juanca. ");
INSERT INTO pioNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Níái wenàiwicaca náináidacawa cawàwanáta Dios imàníinápináté naicá áiba wawàsi máiníiri cachàinica. Náináida nacáiwa nawàwalìcuísewa Juan ìwali cawàwanáta Mesíascani, yái judío icuèrinápináca, Dios ibànuèrica nalí. ");
INSERT INTO pioNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Quéwa Juan íimaca macái wenàiwicanái irí: “Báisíta nubautizácuéca pía úni yáaculé. Quéwa mesúnamáita áiba yàanàaca. Yáta ibànùapiná Espíritu Santo abénaméeyéi péenácué irí ibautizácaténá náiwitáise Espíritu Santo ichàini iyú, cawinácaalí wenàiwica yeebáidéeyéica itàacái, yái yàanèeripináca. Quéwa áibanái péenácué càmíiyéica yeebáida itàacái, ibautizápiná níawa quichái iyú nàuwichàacaténáwa càiripináta. Máiní cachàiníirica íiwitáise nuícha. Nuíwacalicani, yái yàanèeripináca; nuicáca núawawa càiride iyúwa yàasu wenàiwica càmíirica cachàini náicha canánama, máinícáiná cayábéerica nuíchani. ");
INSERT INTO pioNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Càide iyúwa wenàiwicanái itécaalí yàasu palawa nacáapi irìcuwa, masacàacaténá namànica nàasu trigo ituínáwa, náaláidacaténá nacái trigo iwìralèmi, càita nacái yái yàanèeripináca núamirìcubàa yàanàaca iwàlisàidacaténá yàasu wenàiwica íiwitáisewa, iseríacaténá nacái nía náicha áibanái càmíiyéica yàasu. Càide iyúwa wenàiwica yeedácaalí ibànacale trigo ituínáwa manuíri capìi irìculé, ituínási yàaluca, càita nacái yái yàanèeripináca ìwacáidapiná yàataléwa yàasu wenàiwicanáiwa. Càide iyúwa wenàiwica yeemácaalí ituíná iwìralèmi manuíri quichái irìcu, càita nacái yái yàanèeripináca yùuwichàidapiná nía quichái irìcu, càmíiyéica yàasu wenàiwica; yùuwichàidapiná nía quichái irìcu càmíirica ichacàwa càiripinéerita ìyaca”, íimaca yái Juanca. ");
INSERT INTO pioNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Càité Juan icàlidaca nalíni. Yàalàaca nía déecuíri iyú icàlidacaténá wenàiwicanái irí cayábéeri tàacáisi Dios ichùulièrica icàlidaca nalí. ");
INSERT INTO pioNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Juan yàalàaca gobernador rey Herodes nacái cachàiníiri iyú, Herodes imelùdacáináté yéenásàiri Felipe íinuwa, íipidenéechúa Herodías, Herodes imànicáináté nacái manùba báawéeri. ");
INSERT INTO pioNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Herodes quéwa imànica áiba wawàsi máiníiri báawaca náicha canánama: Herodes yúucaca Juan presoíyéi ibànalìculé. ");
INSERT INTO pioNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Quéwa ipíchawáiseté Herodes yúucaca Juan presoíyéi ibànalìculé, Juan ibautizácaté manùbéeyéi wenàiwica. Juan ibautizá nacái Jesús. Yái Jesúsca, idècunitàacá isutáca yáawawa Dios íicha, yáta capìraléeri cáli yàacùacawa. ");
INSERT INTO pioNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Yá Espíritu Santo iricùacawa Jesús ìwali càiride iyúwa waicáaná unùcu iricùanáwa. Néese néemìaca Dios itàacái chènuníise. Dios íimaca Jesús irí: —‍Píacata Nuìri nuwàwéeri cáininéeri nuicáca. Cayábaca nuwàwa nuicáca pía —‍íimaca yái Diosca. ");
INSERT INTO pioNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jesús idènìacaté cawàwanáta treinta camuí idàbacaalíté yéewáidaca wenàiwicanái. Abénaméeyéi wenàiwica nayúunáidaca José ìirimicaténi, yái Jesúsca. José yàacawéetúa yáaniri íipidenáté Elí. ");
INSERT INTO pioNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Elí yáaniri íipidenáté Matat. Matat yáaniri íipidenáté Leví. Leví yáaniri íipidenáté Melqui. Melqui yáaniri íipidenáté Jana. Jana yáaniri íipidenáté José. ");
INSERT INTO pioNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","José yáaniri íipidenáté Matatías. Matatías yáaniri íipidenáté Amós. Amós yáaniri íipidenáté Nahúm. Nahúm yáaniri íipidenáté Esli. Esli yáaniri íipidenáté Nagai. ");
INSERT INTO pioNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai yáaniri íipidenáté Maat. Maat yáaniri íipidenáté Matatías. Matatías yáaniri íipidenáté Semei. Semei yáaniri íipidenáté Josec. Josec yáaniri íipidenáté Judá. ");
INSERT INTO pioNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Judá yáaniri íipidenáté Joanán. Joanán yáaniri íipidenáté Resa. Resa yáaniri íipidenáté Zorobabel. Zorobabel yáaniri íipidenáté Salatiel. Salatiel yáaniri íipidenáté Neri. ");
INSERT INTO pioNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri yáaniri íipidenáté Melqui. Melqui yáaniri íipidenáté Adi. Adi yáaniri íipidenáté Cosam. Cosam yáaniri íipidenáté Elmadam. Elmadam yáaniri íipidenáté Er. ");
INSERT INTO pioNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er yáaniri íipidenáté Josué. Josué yáaniri íipidenáté Eliezer. Eliezer yáaniri íipidenáté Jorim. Jorim yáaniri íipidenáté Matat. ");
INSERT INTO pioNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Matat yáaniri íipidenáté Leví. Leví yáaniri íipidenáté Simeón. Simeón yáaniri íipidenáté Judá. Judá yáaniri íipidenáté José. José yáaniri íipidenáté Jonam. Jonam yáaniri íipidenáté Eliaquim. ");
INSERT INTO pioNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliaquim yáaniri íipidenáté Melea. Melea yáaniri íipidenáté Mena. Mena yáaniri íipidenáté Matata. Matata yáaniri íipidenáté Natán. ");
INSERT INTO pioNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Natán yáaniri íipidenáté rey David. Rey David yáaniri íipidenáté Isaí. Isaí yáaniri íipidenáté Obed. Obed yáaniri íipidenáté Booz. Booz yáaniri íipidenáté Sala. Sala yáaniri íipidenáté Naasón. ");
INSERT INTO pioNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Naasón yáaniri íipidenáté Aminadab. Aminadab yáaniri íipidenáté Admin. Admin yáaniri íipidenáté Arni. Arni yáaniri íipidenáté Esrom. Esrom yáaniri íipidenáté Fares. Fares yáaniri íipidenáté Judá. ");
INSERT INTO pioNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Judá yáaniri íipidenáté Jacob. Jacob yáaniri íipidenáté Isaac. Isaac yáaniri íipidenáté Abraham. Abraham yáaniri íipidenáté Taré. Taré yáaniri íipidenáté Nacor. ");
INSERT INTO pioNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nacor yáaniri íipidenáté Serug. Serug yáaniri íipidenáté Ragau. Ragau yáaniri íipidenáté Peleg. Peleg yáaniri íipidenáté Heber. Heber yáaniri íipidenáté Sala. ");
INSERT INTO pioNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sala yáaniri íipidenáté Cainán. Cainán yáaniri íipidenáté Arfaxad. Arfaxad yáaniri íipidenáté Sem. Sem yáaniri íipidenáté Noé. Noé yáaniri íipidenáté Lamec. ");
INSERT INTO pioNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamec yáaniri íipidenáté Matusalén. Matusalén yáaniri íipidenáté Enoc. Enoc yáaniri íipidenáté Jared. Jared yáaniri íipidenáté Mahalaleel. Mahalaleel yáaniri íipidenáté Cainán. ");
INSERT INTO pioNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Cainán yáaniri íipidenáté Enós. Enós yáaniri íipidenáté Set. Set yáaniri íipidenáté Adán, yái asìali Dios idàbéericaté. ");
INSERT INTO pioNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Néeseté Espíritu Santo icùaca Jesús íiwitáise. Jesús yèepùacawa Jordán inanába íicha, yá Espíritu Santo itéca Jesús manacúali yùuculé càináwàiri. ");
INSERT INTO pioNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Jesús ìyacaté néré cuarenta èeri. Satanás yáalimáidaca Jesús imàníinápiná ibáyawanáwa quéwa càmita Jesús imàni cài. Canácata Jesús iyéeri iyáacaléwa cuarenta èeri, yáté máapicani. ");
INSERT INTO pioNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Néese, Satanás íimaca Jesús irí: —‍Dios Iiricáiná pía, piwènúada yái íbaca pan iyú piyáacaténáni —‍íimaca yái Satanásca. ");
INSERT INTO pioNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Jesús íimaca irí: —‍Càmíirita. Dios itàacái profeta itànèericaté íimaca walí: ‘Picácué wáináidawa yàacàsi ìwali Dios íicha. Néese iwàwacutá weebáidaca macáita iyúwa Dios íimáaná yéewanápiná wàyaca machacàníiri iyú’, íimaca yái Dios itàacáica —‍íimaca yái Jesúsca, càmicáiná iwàwa imànica wawàsi meedá irípináwa Dios íiwitáise iyú. ");
INSERT INTO pioNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Néese, Satanás itéca Jesús chènuníiri dúli íinatalé. Yá Satanás yáasáidaca Jesús iicá aquialénamata macái cáli èeri irìcuírica. ");
INSERT INTO pioNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Yá Satanás íimaca Jesús irí: —‍Nùapiná piríwa macáita ìyéerica chái èeri irìcu cawèníirica, yá picùapiná macái cáliwa; núacata yèeri canánama nuwàwéeyéi iríwa núacáináta icuèrica macáitani. ");
INSERT INTO pioNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Iná pibàlùacaalíwa nulí piùluì ipùata iyúwa pìacaténá nucàaluíniná, yásí pìasupiná macáitani —‍íimaca yái Satanásca. ");
INSERT INTO pioNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Jesús íimaca irí: —‍Núa, càmíirita yàa picàaluíniná, yácáiná Dios itàacái profeta itànèericaté íimaca: ‘Iwàwacutá pìaca Picuèriná Dios icàaluínináwa. Iwàwacutá nacái pìaca abéerita Dios iyéininá’, càité itànàaca yái profetaca —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Néese Satanás itéca Jesús Jerusalén ìyacàlená néré. Yá Satanás imichàidaca Jesús templo ipùata íinatalé chènuníiri náicha canánama. Néese Satanás íimaca Jesús irí: —‍Dios Iiricáiná pía, pipisìawa templo íicha cáli íinatalépiná. ");
INSERT INTO pioNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Yácáiná Dios itàacái profeta itànèericaté cài íimaca pìwali: ‘Dios ichùulìapiná yàasu ángelnáiwa nacùanápiná pía. ");
INSERT INTO pioNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Namichàidapiná nacái píawa nacáapi iyúwa ipíchaná pinúaca píawawa íba iwéré’, càité profeta itànàaca Dios itàacái piináwaná ìwali —‍íimaca yái Satanásca. ");
INSERT INTO pioNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Quéwa Jesús íimaca Satanás irí: —‍¡Càmíiri! Dios itàacái profeta itànèericaté cài íimaca walí: ‘Picá píalimáida piicáwa Picuèriná Dios asáisí icùacaalípiná pía’, càité profeta itànàaca Dios itàacái —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Ináté idécanáami Satanás yáalimáidaca Jesús imàníinápiná macái íiwitáaná báawéeri, yáté Satanás yàacawa Jesús íicha àta áiba èeripináta àniwa. ");
INSERT INTO pioNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Néeseté Jesús yèepùacawa Galilea yàasu cáli néré. Espíritu Santo icùaca Jesús íiwitáise. Néese macáita Galilea yàasu cáli néeséeyéi néemìaca Jesús iináwaná ìwali. ");
INSERT INTO pioNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Jesús yèepunícatéwa yéewáidaca wenàiwica judíonái yéewáidacàalu irìcubàa yàcalé imanùbaca. Macáita wenàiwica nacàlidaca Jesús iináwaná ìwali cayábéerica íiwitáise. ");
INSERT INTO pioNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Jesús yàacatéwa Nazaret ìyacàlená néré, yái yàcalé isèenái idàwinàacatáicaténi. Yá sábado irìcu judíonái iyamáidacatáicawa, Jesús iwàlùacawa judíonái yéewáidacàalu irìculé càide iyúwaté íiwitáise ìyáaná. Néese ibàlùacawa wenàiwicanái yàacuésemi iléecaténá nalí Dios itàacái. ");
INSERT INTO pioNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Nàaca irí cuyàluta yéewacaténá iléeca nalíni, yái cuyàluta idènièricaté itànàawa profeta Isaías yàasu tàacáisi itànèericaté Dios inùmalìcuíse. Jesús yàacùaca cuyàluta iwawanèericawa, yá yàanàaca tàacáisi Jesús íimáanápinácaté ìwaliwa, yái Dios yàasu wenàiwicaca. Càita íimaca ìwaliwa: ");
INSERT INTO pioNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Espíritu Santo, Dios ibànuèrica nulí, yàacawéeridaca núa siùca, ichùulìacáiná nucàlidáanápiná cayábéeri tàacáisi catúulécanéeyéi irí. Idéca ibànùaca núa nucàlidacaténá wenàiwicanái iríni Dios iwàwaca iwasàaca nía nabáyawaná íichawa. Ibànùaca núa catuícaténá numànica matuíyéi, nuwasàacaténá wenàiwica nàuwichàacái íichawa nacái, ");
INSERT INTO pioNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","nucàlidacaténá nacái nalíni Dios iwàwaca iyúudàaca nía siùcade”, càité profeta Isaías itànàaca tàacáisi Jesús ìwali. ");
INSERT INTO pioNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Néese idécanáamité Jesús iléeca nalíni, yá iwawanàacani yái cuyàlutaca, yá yèepùadaca cuyàluta asìali irí icuèrica cuyàluta. Néese Jesús yáawinacawa nèewi yéewáidacaténá nía. Macáita ìyéeyéica néré naicáidaca irí mamáalàacata. ");
INSERT INTO pioNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Néese Jesús íimaca nalí: —‍Siùca idéca yàanàaca pèewiré yái wenàiwicaca Dios itàacái icàlidéericaté iináwaná ìwali profeta Isaías yàasu cuyàluta irìcu —‍íimaca yái Jesúsca, icàlidaca iináwaná ìwaliwa. ");
INSERT INTO pioNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Macáita níái wenàiwicaca natàaníca cayábéeri iyú ìwali. Náináidacawa manuísíwata néemìaca icàlidaca nalíni máiní cáalíacáiri iyú. Náimaca nalíwáaca: —‍¿Cánásica yéewaná cài icàlidacani? José ìirimi meedá yái —‍náimaca. ");
INSERT INTO pioNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Ináté Jesús íimaca nalí: —‍Báisíta piwàwacué picàlidaca nulí yái tàacáisica: ‘Báisícaalí píalimá pichùnìaca cáuláiquéeyéi, néese pichùnìa píawawa waicápiná, yásí weebáidaca pitàacái’, cài piwàwacué píimaca nulí, piwàwacáinácué piicáca numànica yái càmíirica wenàiwica idé imànica. Piwàwacué nacái píimaca nulí: ‘Báisícaalí pimànicaté yái càmíirica wenàiwica idé imànica Capernaum ìyacàlená néenibàa càide iyúwa wéemìaná nacàlidaca piináwaná ìwali, néese pimàni nacái càiri wawàsi chái, pìasu cáli íinatawa, yásí weebáidaca pitàacái’, cài piwàwacué píimaca nulí, càmicáinácué piwàwa peebáidaca nutàacái báisíiri iyú —‍íimaca nalí yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Néese Jesús íimaca nalí àniwa: —‍Báisíta, núalíacawa càmíinápinácué peebáida nutàacái, càmicáiná wenàiwica nawàwa néemìaca profeta itàacái nàasu cáli néeséericaalíni. ");
INSERT INTO pioNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","26","Quéwa, péemìacué cayába, Dios imànipiná cayábéeri áibanái wenàiwica irí báawéeyéicuéca piicáca, níara càmíiyéica judío, neebáidapinácáiná nutàacái, càide iyúwaté Dios imàníiná nalí cayábéeri bàaluité profeta Elías yàasu èerité. Càmitaté unía yúuwàawa máisiba camuí y mediopináté, ìyacaté nacái manuíri máapicái chái Israel yàasu cáli imanuíca. Ewitaté nàyacáaníta manùbéeyéi inanái inìrimi yéetéeyéimicawa íicha chái Israel yàasu cáli íinata, càicáaníta Dios càmitaté ibànùa profeta Elías iyúudàacaténá nía. Néese, Dios ibànùacaté Elías iyúudàacaténá abéechúa inanái inìrimi yéetéechúamiwa íicha, càmíichúa israelita, Sarepta ìyacàlená mìnalu, ìyéechúacaté mawiénita Sidón ìyacàlená irí, méetàuculé Israel yàasu cáli íicha. ");
INSERT INTO pioNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Càita nacái profeta Eliseo yàasu èerité nàyacaté nacái manùbéeyéi cacháunéeyéi íimami lepra iyú chái Israel yàasu cáli íinata, quéwa Dios càmitaté ichùnìa nía, ibatàa abéeri pináta, càmitaté ichùnìa nía. Néese ichùnìacaté áiba càmíiri israelita, íipidenéeri Naamán, Siria yàasu cáli néeséeri. Càita nacái Dios imànipiná cayábéeri nalíwa áibanái wenàiwica báawéeyéicuéca piicáca, càmíiyéica judío, neebáidapinácáiná nutàacái —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Níái israelitaca, néemìaca Jesús íimáaná càmíiyéi israelita ìwali, yá calúaca nía báawanama canánama, níái ìyéeyéica judíonái yéewáidacàalu irìcu, báawacáináté naicáca càmíiyéi israelita. ");
INSERT INTO pioNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Yá namichàacawa náibàaca Jesús, natécani cachàiníiri iyú yàcalé íicha. Nawatàidaca Jesús quìratàli ipùata nérépiná, yái quìratàli nàyacàle ìyéerica íinata, nawàwacáiná náucaca Jesús chènuníiri quìratàli íinatáise, yéetácaténáwa. ");
INSERT INTO pioNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Quéwa Jesús iwatàa yáawawa náicha, yá ichàbacawa nèewibàa, yá yàacawa náicha. ");
INSERT INTO pioNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Néeseté, Jesús yàacawa Capernaum ìyacàlená néré ìyéerica Galilea yàasu cáli íinata. Aiba sábado judíonái iyamáidacatáicawa, yá Jesús yéewáidaca wenàiwicanái judíonái yéewáidacàalu irìcu. ");
INSERT INTO pioNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Yá náináidacawa manuísíwata néemìaca yéewáidáaná nía, yéewáidacáiná nía iyúwa abéeri cachàiníiri íiwitáise, Dios ibànuèrica yéewáidacaténá wenàiwicanái. ");
INSERT INTO pioNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Iyacaté áiba asìali néewáidacàalu irìcu. Yái asìali demonio idacuèrica íiwitáise. Yá demonio yéemíanícawa asìali isàna iyú. Yá íimaca cachàiníiri iyú Jesús irí: ");
INSERT INTO pioNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","—‍¡Pèepùa píichawa! ¡Picá pisàiwica walí wawàsi, pía Jesúsca, Nazaret ìyacàlená néeséeri! ¿Pìanàasica pimáalàidacaténá wía? Núalía nuicáca pía, núalíacawa pìwali, Dios néeséeri mabáyawanéerica pía —‍íimaca. ");
INSERT INTO pioNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Quéwa Jesús yàalàaca demonio cachàiníiri iyú. Yá Jesús íimaca demonio irí: —‍¡Masànata pía! ¡Pimusúawa íicha yái asìalica! —‍íimaca yái Jesúsca. Yá demonio yúucaca asìali cáli íinatalé macái wenàiwicanái yàacuésemi, néese yàacawa asìali íicha. Canáta demonio imàníiná asìali irí. ");
INSERT INTO pioNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Macáita wenàiwica ìyéeyéica néeni, náináidacawa manuísíwata naicáidaca Jesús irí. Yá náimaca nalíwáaca: —‍¿Càinásica yái yéewáidáanáca? ¡Yái asìali Jesús yàalàaca demonionái cachàiníiri iyú íiwitáise cachàiníiri iyúwa, yá ichùulìacaalí nía nàanápináwa wenàiwica íicha, yáta nàacawa! —‍náimaca nalíwáaca. ");
INSERT INTO pioNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Yá macáita Galilea yàasu cáli néeséeyéi nacàlidaca Jesús iináwaná ìwali. ");
INSERT INTO pioNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Néeseté Jesús imusúacawa néewáidacàalu irìcuíse, yá yàaca iwàlùacawa Simón icapèe irìculé. Yá Simón iyéeru iculuéchúawa cáiwíiri mecuní iyú. Yá nasutáca ulí Jesús íicha ichùnìanápiná úa. ");
INSERT INTO pioNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Néese Jesús yàacawa ùatalé, yá yáawiaca iicáidaca ulí. Jesús yàalàaca mecuní cachàiníiri iyú. Yá mecuní ichàbacawa uícha. Yáta umichàacawa, yá udàbaca umànica nayáapiná. ");
INSERT INTO pioNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Néese idècunitàacá èeri iwàlùacawa, yá macáita idènièyéica cáuláiquéeyéi néenánáiwa natéca nía Jesús yàatalé. Natéca néenánáiwa idènièyéica macái uláicái íiwitáaná. Jesús imàacaca icáapiwa nàwali macáita, yá ichùnìaca nía. ");
INSERT INTO pioNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Demonionái nàacawa nacái manùbéeyéi cáuláiquéeyéi íicha. Yá demonionái náimaca néemíanícawa cachàini: —‍¡Píacata yái Dios Iirica! —‍náimaca. Quéwa Jesús yàalàaca nía cachàiníiri iyú, níái demonioca, càmita ibatàa natàaníca, náalíacáináwa ìwali Mesíascani, yái judío icuèrinápiná Dios ibànuèrica nalí. ");
INSERT INTO pioNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Amalácaalíté nawicáu àniwa, Jesús imusúacatéwa yàcalé irìcuíse, yá yàacawa canácatalé wenàiwica. Néese madécaná wenàiwica icutácani. Yá nàanàaca yàatalé. Càmita nawàwa namàacaca yàacawa náicha. ");
INSERT INTO pioNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Quéwa Jesús íimaca nalí: —‍Iwàwacutá nucàlidaca nalí cayábéeri tàacáisi áibanái ìyacàle néenibàa nacái, yái tàacáisi íiméerica càinácaalí iyú Dios icùaca yàasu wenàiwicanáiwa, Dioscáiná ibànùaca núa numànicaténá cài —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Càité Jesús yàaca icàlidaca yái tàacáisica judíonái yéewáidacàalu irìcubàa, ìyéeyéica Judea yàasu cáli íinata. ");
INSERT INTO pioNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Aiba èerité Jesús ibàlùacawa Genesaret icalìsaniná yàasu càina íinatalé, áibaalí íipidenéeri Galilea icalìsaniná. Madécaná wenàiwica nàyaca néré nawàwacáiná néemìaca Jesús icàlidaca nalí Dios itàacái. Máiní manùbaca wenàiwica, yá nacàbadàayacacawa Jesús iwéré. ");
INSERT INTO pioNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Néese Jesús iicáca pucháiba barca mawiénita iríwa càina íinatalé. Canáca wenàiwica barca irìcu namusúacáinátéwa barca irìcuíse níái asìanái íibèeyéica cubái, náibacaténá nàasu chinchorrowa. ");
INSERT INTO pioNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Jesús iwàlùacawa barca irìculé, Simón yàasu barcaca. Néese isutáca Simón íicha wawàsi iwesíanápiná barca àanama íicha. Néese Jesús yáawinacawa barca irìcu, yá yéewáidaca wenàiwica barca irìcuíse. ");
INSERT INTO pioNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Néese idécanáamité yéewáidaca nía, yá Jesús íimaca Simón irí: —‍Piwesía barca depuíwacatalé calìsa. Piúcacué pìasu chinchorrowa píibàacaténá cubái —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Néese Simón íimaca Jesús irí: —‍Nuíwacali, wadéca wacamáaca táiyápinama, canácata weedéeri, quéwa pìalàacáiná núa, íná nuchùulìaca náucaca chinchorro àniwa —‍íimaca yái Simónca. ");
INSERT INTO pioNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Néese idécanáami namànica càide iyúwa Jesús íimáaná nalí, yá náibàaca madécaná cubái. Nàasu chinchorro icacanácawa yàacawa. ");
INSERT INTO pioNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Iná náucaca nacáapiwa namáidacaténá nàacawéeyéináwa ìyéeyéica áiba barca irìcu nàacaténá nayúudàaca nía. Néese nàanàaca Simónnái yàatalé, yá napuníadaca pucháibanama nàasu barcawa cubái iyú àta nawàwacataléta napulùnacawa cubái iyú, níái barcaca. ");
INSERT INTO pioNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Quéwa Simón Pedro iicácáiná madécaná cubái, yá cáaluca íináidacawa ibáyawaná ìwalíisewa, yá ibàlùacawa yùuluì iyúwa yàacaténá Jesús icàaluíniná. Yá íimaca Jesús irí: —‍¡Iwàwacutá pìacawa nuícha, Nuíwacali, cabáyawanácáiná núa! —‍íimaca yái Simón Pedroca. ");
INSERT INTO pioNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Càica Simón íimaca Jesús irí cáalucáiná Simón ibáyawaná ìwalíisewa, yáalíacáináwa Jesús idènìaca Dios íiwitáise. Cáaluca nacái níái Simón Pedro yáapichéeyéica, naicácáiná madécaná cubái needéeyéica. ");
INSERT INTO pioNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Cáaluca nacái Simón imanùbacanáica nabáyawaná ìwalíisewa níái íipidenéeyéica Santiago, Juan nacái, níái Zebedeo yéenibeca, náalíacáináwa Jesús idènìaca Dios íiwitáise. Quéwa Jesús íimaca Simón irí: —‍Picá cáalu pía nuícha. Pidéca peedáca cubái. Siùcáisede quéwa pìwacáidapiná nulíwa wenàiwicanái yéewacaténá nuéwáidacaléca nía —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Iná natéca nàasu barcawa cáli iwéré. Yá namàacaca macáita nàasuwa, yá nàacawa Jesús yáapicha, yéewacaténá yéewáidacaléca nía. ");
INSERT INTO pioNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Aiba èerité, Jesús ìyacaté áiba yàcalé irìcu, néese asìali yàanàaca néré cacháunéeri íimami lepra iyú. Iicáca Jesús, yá yúuwàa irìacawa inùmáawawa Jesús irí yàacaténá Jesús icàaluíniná, yéewacaténá catúulécanáca Jesús iicácani. Yá isutáca Jesús íicha wawàsi manuísíwata: —‍Nuíwacali, núalíacawa píalimá pichùnìaca núa, piwàwacaalí quéwa pichùnìaca núa —‍íimaca yái asìalica. ");
INSERT INTO pioNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Néese Jesús imàacaca icáapiwa ìwali. Yá Jesús íimaca irí: —‍Nuwàwaca nuchùnìaca pía. ¡Cayábaca píawa! —‍íimaca yái Jesúsca. Yáta icháuná lepra yáawacawa íicha. ");
INSERT INTO pioNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Néese Jesús ichùulìacani. Iimaca irí: —‍Picá picàlida áibanái iríni nuchùnìaná pía. Néese pìawa caquialéta sacerdote yàatalé píasáidacaténá iicá píimamiwa, yáalíacaténáwa cayábaca pía picháuná íichawa. Pité nacái ofrenda profeta Moisés ichùulièricaté wenàiwica namàacáanápiná Dios irí ofrenda iyú nachùnìacaalíwa lepra íicha, yéewacaténá macái wenàiwica yáalíacawa cayábaca pía —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Quéwa éwita Jesús ichùulìacáanítani cài, càicáaníta manùbéeyéi wenàiwica nacàlidaca Jesús iináwaná ìwali mamáalàacata macái wenàiwica irí. Yá madécaná wenàiwica nàwacáidáyacacawa néemìacaténá Jesús itàacái, ichùnìacaténá nía nacái. ");
INSERT INTO pioNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Quéwa áibaalíté Jesús yàacawa méetàuculé wenàiwicanái íicha isutácaténá yáawawa Dios íicha. ");
INSERT INTO pioNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Aiba èerité Jesús yéewáidaca wenàiwicanái. Abénaméeyéi fariseo, áibanái nacái yéewáidéeyéica wenàiwica templo irìcu nàanàacaté néré, madécaná yàcalé mìnanái nacái ìyéeyéicaté Galilea yàasu cáli íinata, Judea yàasu cáli íinata nacái. Aibanái nàanàaca Jerusalén ìyacàlená néese nacái. Náawinacatéwa néré Jesús yéewáidacatalé wenàiwicanái. Yá Jesús ichùnìaca cáuláiquéeyéi wenàiwica Dios íiwitáise cachàiníiri iyú. ");
INSERT INTO pioNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Néese áibanái asìanái nàanàaca néré itéeyéica máapinéeri asìali irièricawa yàalubái íinatawa iiméerica íinata. Nawàwa natéca asìali capìi irìculé, nalìadacaténáni Jesús íipunita, Jesús ichùnìacaténáni. ");
INSERT INTO pioNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Càmita quéwa náalimá nawàlùacawa Jesús yàatalépiná dàalacáiná máiní wenàiwicanái néré. Iná náiríacawa escalera ìwalibàa capìi íinatalé, sàabadéeri, canéeri ipùata chènuniré. Néese nawatàaca capìi ibáiná Jesús iwicáu. Yá nalicùadaca cáuláiquéeri asìali yàalubái íinatawa yéenúlusi ìwali Jesús yàatalé, nàacuésemi macáita wenàiwica ìyéeyéica néeni. ");
INSERT INTO pioNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Jesús yáalíacawa náiwitáise manuíca náináidacawa nawàwawa Jesús ìwali ichùnìanápináni, yá Jesús íimaca cáuláiquéeri irí: —‍Pía, nùacawéerináca, nudéca numàacaca nuwàwawa pibáyawaná íicha cayábacaténá píapicha Dios —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Néese níái yéewáidéeyéica wenàiwica templo irìcu, nía nacái fariseonái nadàbaca náináidacawa. Náimaca náináidacawa nalíwa nawàwalìcuísewa: “¿Cáná yéewa itàaní cài yái asìali Jesúsca? Itàaníca ìyaca Dios ìwali báawéeri iyú, canácáináta asìali yáaliméeri imàacaca iwàwawa wenàiwicanái ibáyawaná íicha cayábacaténá náapicha Dios. Abéerita Dios yáaliméeri imànica cài”, cài náimaca náináidacawa nalíwa. ");
INSERT INTO pioNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Quéwa Jesús yáalíacawa náináidáanácawa. Yá isutáca yéemìawa nía: —‍¿Cánácué píináidawa cài? ");
INSERT INTO pioNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Máiní màulenáca wáimaca máapinéeri irí: ‘Nudéca numàacaca nuwàwawa pibáyawaná íicha cayábacaténá píapicha Dios’, càmicáiná áibanái yáalimá iicáca asáisí báisícaalí cayábaca yáapicha Dios. Quéwa máiní càulenáca wáimaca máapinéeri irí: ‘Pimichàawa, pìipìna’, áibanái wenàiwica náalimácáiná naicáca asáisí wadécaalí wachùnìacani watàacái iyúwa, yái máapinéerica. ");
INSERT INTO pioNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Iná núa, asìali Dios néeséerica, nuchùnìapiná yái máapinéerica píalíacaténácuéwa Dios idéca ichùulìaca núa numàacáanápiná nuwàwawa wenàiwicanái ibáyawaná íicha chái èeri irìcu cayábacaténá náapicha Dios —‍íimaca nalí yái Jesúsca. Néeseca Jesús íimaca máapinéeri irí: —‍Pía, nùacawéerináca, núuma pirí, pimichàawa, peedá pìalubáiwa, pèepùawa picapèe néréwa —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Yáta yái asìalica imichàacawa nàacuésemi, yá yeedáca yàalubáiwa irièricatéwa íinata, néese yàacawa icapèe nérépináwa, casíimáiri iyú, yàaca Dios irí cayábéeri idècunitàacá yèepunícawa. ");
INSERT INTO pioNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Macáita ìyéeyéica néré náináidacawa manuísíwata naicáidaca Jesús irí, nàaca nacái Dios irí cayábéeri. Cáaluca nacái náináidacawa, yá náimaca: —‍Siùca èeri wadéca waicáca cayábéeri wawàsi Dios imàníirica càmíiricáwaca waicá quéechacáwa —‍náimaca. ");
INSERT INTO pioNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Néesetécáwa Jesús imusúacawa capìi irìcuíse. Yá iicáca asìali íipidenéeri Leví, yeedéericaté plata yéenánái judío íichawa Roma ìyacàlená yàasu gobierno irípiná. Yái Leví yáawinéericawa aléera yeedácatalécaté plata wenàiwica íicha. Néese Jesús íimaca irí: —‍Aquialé, pìawa núapicha yéewacaténá nuéwáidacaléca pía —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Yái Leví imàacaca yàasuwa macáita, yá imichàacawa, yàacawa Jesús yáapicha. ");
INSERT INTO pioNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Néese Leví ichùulìaca yàasu wenàiwicanáiwa nachanàacaténá manùba yàacàsi icapèe irìcu. Imáidaca yàataléwa Jesús iyáacaténá iyáacaléwa Leví yáapicha, Leví iwàwacáiná yàaca Jesús íimiétacaná. Leví imáida nacái manùbéeyéi yeedéeyéi plata yéenánái judío íichawa Roma ìyacàlená yàasu gobierno irípiná. Aibanái nacái nayáaca nayáacaléwa náapicha néré. ");
INSERT INTO pioNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Néese abénaméeyéi fariseo, áibanái nacái yéewáidéeyéi wenàiwica templo irìcu natàaníca báawéeri iyú Jesús yéewáidacalénái ìwali. Yá náimaca Jesús yéewáidacalénái irí: —‍¿Cánácué piyáa piyáacaléwa náapicha, níái cabáyawanéeyéica, náapicha nacái níái yeedéeyéica wáicha plata romanonái yàasu gobierno irípiná? —‍náimaca. ");
INSERT INTO pioNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Quéwa Jesús íimaca fariseonái irí: —‍Péemìacué comparación: Máuláicacaalí wenàiwica, yá càmita nawàwacutá abéeri ichùnièripiná nía. Quéwa áibanái idènièyéica uláicái nawàwacutáca abéeri ichùnièripiná nía. ");
INSERT INTO pioNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Càita nacái wenàiwica íináidéeyéica mabáyawanáca, càmita nacutá abéeri ichùnièripiná náiwitáise nabáyawaná íichawa. Quéwa áibanái wenàiwica yáaliéyéiwa cabáyawanáca, níata icutáca abéeri iwènúadéeripiná náiwitáise báawéeri íicha. Càita nacái núa, càmita nùanàa numáidacaténá wenàiwica íináidéeyéica mabáyawanáca, néese nudéca nùanàaca numáidacaténá wenàiwica yáaliéyéicawa cabáyawanáca, nawènúadáanápiná náiwitáisewa nabáyawaná íichawa. Iná yéewa cayábaca nàwacáidáyacacawa nùatalé níái cabáyawanéeyéica nuwènúadacaténá náiwitáise nabáyawaná íichawa —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Néese fariseonái nasutáca néemìawa Jesús. Yá náimaca irí: —‍Juan el Bautista yéewáidacalénái, nía nacái wéewáidacaléca, wía fariseoca, namàacaca náichawa nayáacaléwa manùba yàawiría nasutácaténá Dios íicha manuísíwata. ¿Cáná càmita péewáidacalénái namàni cài? Nayáaca nayáacaléwa mamáalàacata —‍náimaca. ");
INSERT INTO pioNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Jesús íimaca nalí: —‍Péemìacué comparación: Asìali icásàacaalíwa, yá imáidaca yàacawéeyéináwa asìanái naicácaténá icásàacawa casíimáiri iyú. Càmita nawàwa namàacaca náichawa nayáacaléwa idècunitàacá ìyaca náapicha, yái nàacawéeriná imàníirica matrimonio, casíimáicáiná nawàwa. ");
INSERT INTO pioNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Quéwa áiba èeriwa, áibanái itépiná náichawani. Néenialípiná namàaca náichawa nayáacaléwa, achúmacáiná nawàwa. Càita nacái nuéwáidacalénái, càmita yéewa achúmaca nawàwa idècunitàacá nùyaca náapicha. Iná càmita namàaca náichawa nayáacaléwa —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Jesús icàlidaca nalí nacái áiba comparación yéewáidacaténá nía: —‍Càmita wadalúa wáluma yéemami wàlisài bàlesi íicha wachanàidacaténá iyú éwisàimi bàlesita. Wamànicaalí cài, yásí báawaca wamànica wàlisài bàlesimi. Yá nacái wàlisài yéemami càmita abédanama éwisàimi bàlesi yáapichani. ");
INSERT INTO pioNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Péemìacué áiba comparación: Càmita wàucùa wàlisài uva ituní éwisàimi íimamisi irìculé yácáiná wàlisài uva ituní idàbaca isáacawa dàchidàchiwaca inànìacubàa, yásí éwisàimi íimamisi icacanácawa, càmicáiná yáalimá imulacàacawa yàacawa. Wamànicaalí cài, yá yúucacawa wáicha macáita uva ituníca, íimamisi nacái. ");
INSERT INTO pioNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Iná iwàwacutá wàucùaca wàlisài uva ituní wàlisài íimamisi irìculé. Càita nacái níái nuéwáidacaléca yeebáidéeyéica nutàacái wàlisài, càmita nàya pìasu bàaluisàimi tàacáisi ìwali, píacué fariseoca. ");
INSERT INTO pioNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Aiba wawàsi nacái, péemìacué comparación: Idécanáami wenàiwica ìiraca éwisàimi uva ituní ipuíri, yá càmita iwàwa ìiraca wàlisài uva ituní càmíirica ipuí íimacáiná: ‘Cayábéeri yáwanái yái ipuírica’, cài íimaca. Càita nacái píacué: Pìyacáinácué éwisàimi tàacáisi ìwali, íná piyúunáidacuéca cayábéericani wàlisài tàacáisi íicha. Iná càmitacué piwàwa peebáidaca yái nutàacái wàlisàica —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Néeseté áiba sábado judíonái nayamáidacatáicawa, Jesús yèepunícawa àyapulìcubàa yéewáidacalénái yáapichawa bànacalé yèewibàa. Yá yéewáidacalénái needáca achúmanamata trigo ituíná nayéeripiná. Yá naquiría trigo ituíná nacáapi irìcuwa needácaténá íicha íimi nayáacaténáni, yácáiná judío íiwitáise imàacaca wenàiwica needáca nayáapináwani achúmanamata ìyacaná áibanái ibànacale yéená máapicaalí nía. ");
INSERT INTO pioNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Abénaméeyéi fariseo iicáca Jesús yéewáidacalénái imàníiná, yá fariseonái iicácani iyúwa íibaidacalési. Iná fariseonái íimaca Jesús yéewáidacalénái irí: —‍¿Cánácué píibaida siùca sábado wayamáidacatáicawa? Dios càmita imàaca wáibaidaca siùca èeri —‍náimaca. ");
INSERT INTO pioNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Néese Jesús íimaca nalí: —‍Pidécuéca piimáichaca tàacáisi piléericuéca Dios itàacái irìcuíse wàawirimi rey David ìwali, bàaluité máapicaalíténi, áibanái nacái yáapichéeyéi asìanáica. ");
INSERT INTO pioNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","David iwàlùacatéwa Dios yàasu íimamisíiri capìima mabáyawanéeri irìculé, yái israelitanái isutácatáipiná Dios íicha. Yá David yeedácaté pan namàníiricaté Dios irí ofrenda piná sacerdotenái iyáapináwa. David iyáaca pan, néese yàaca yáapichéeyéi iyáapináwa nacái, éwita Dios imàacacáaníta níawamita sacerdotenái iyáaca yái panca. Dios càmitaté yùuwichàida Davidnái, máapicáiná nía, ínáté catúulécanáca Dios iicáca nía —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Néese Jesús íimaca fariseonái irí àniwa: —‍Dios idéca ichùulìaca núa, núa asìali Dios néeséerica, numàacáanápiná nùasu wenàiwica namànica càide iyúwa nuwàwáaná èeri imanùbaca, siùca èeri sábado nacái wayamáidacatáicawa, wía judíoca —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Aiba sábado judíonái iyamáidacatáicawa, Jesús iwàlùacatéwa néewáidacàalu irìculé, yá idàbaca yéewáidaca nía néré. Iyaca néeni abéeri asìali icáapi yéewápuwáiséeri ituwièricawa íicha. ");
INSERT INTO pioNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Nàyaca nacái néeni abénaméeyéi yéewáidéeyéica wenàiwica templo irìcu, áibanái nacái fariseonái. Naicáidaca Jesús irí mamáalàacata naicácaténá asáisí ichùnìacaalípiná asìali, sábado irìcu, nayamáidacatáicawa, yéewanápiná nacháawàaca Jesús iináwaná ìwali, fariseonáicáiná náimacaté íibaidacalésicani yái Jesús ichùnìanáca wenàiwicanái. ");
INSERT INTO pioNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Quéwa Jesús yáalíacawa náináidáanáwa. Yá Jesús íimaca asìali irí icáapi ituwièricawa íicha: —‍Pimichàawa, pibàlùawa nàacuésemi —‍íimaca yái Jesúsca. Yá asìali imichàa ibàlùacawa. ");
INSERT INTO pioNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Néese Jesús íimaca fariseonái irí: —‍Siùcata nusutácué nuémìawa pía: ¿Càinásica Dios ibatàa wamànica siùca èeri sábado wayamáidacatáicawa? ¿Imàacasica wamànica cayábéeri, càmicaalí nacái, báawéerisica? ¿Imàacasica wacáucàidaca wenàiwica, càmicaalí wéetáidasica wenàiwica? —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Néese iicáidaca nalí macáita ìyéeyéica itéese. Yá néeseca iwènúacawa asìali irí àniwa, yái báawéerica icáapi. Yá Jesús íimaca irí: —‍Piducúa picáapiwa —‍íimaca yái Jesúsca. Yá asìali imànica iyúwa Jesús íimáaná irí. Yáta cayábaca icáapi. ");
INSERT INTO pioNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Quéwa fariseonái máiní calúaca nía. Nadàbaca nasutáca néemìawa níawáaca càinácaalí náalimáanápináté namànica Jesús irí. ");
INSERT INTO pioNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Néenialíté Jesús yàacawa dúli íinatalé. Iyamáacawa néenibàa isutácaténá Dios íicha táiyápinama abéeri catá. ");
INSERT INTO pioNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Amalácanáami yàacawa, yá imáidaca yàataléwa yéewáidacalénáiwa canánama. Yeedáca nèewíise doce namanùbaca Jesús yèeyéica íipidenápiná apóstolnái. ");
INSERT INTO pioNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Níái docéeyéica náipidená cài: Simón, yái asìali Jesús yèerica íipidenápiná nacái Pedro; yá nacái Andrés, yái Simón iméeréerica; Santiago nacái; Juan nacái; Felipe nacái; Bartolomé nacái. ");
INSERT INTO pioNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Yá nacái Mateo; Tomás nacái; Santiago nacái, yái Alfeo ìirimica; yá nacái Simón, áibaalí íipidenéeri celote; ");
INSERT INTO pioNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Yá nacái Judas, yái Santiago yéenásàirica; yá nacái Judas Iscariote, yái itéeripinácaté Jesús yùuwidenái náibàacaténáténi, nanúawani. ");
INSERT INTO pioNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Néeseté Jesús iricùacawa dúli íinatáise yéewáidacalénái yáapichawa. Yá iyamáaca ibàlùacawa néeni manacúalibàa. Idéca nàwacáidáyacacawa néré madécaná Jesús yéewáidacaléca áibanái, madécaná nacái wenàiwica yàanèeyéica macái Judea yàasu cáli néese, Jerusalén ìyacàlená néeséeyéi nacái, Tiro ìyacàlená néeséeyéi nacái, Sidón ìyacàlená néeséeyéi nacái, níái yàcalé ìyéeyéica manuíri úni idùlepi. Níái manùbéeyéi wenàiwicaca nàanàacaté néré néemìacaténá Jesús itàacái, yúucacaténá náicha nacái uláicái. Yáté ichùnìaca nía. ");
INSERT INTO pioNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Aibanái nacái yùuwichèeyéicawa demonio idacùacáiná náiwitáise, Jesús ichùnìaca nía nacái. ");
INSERT INTO pioNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Iná macáita wenàiwica nawàwaca namàacaca nacáapiwa Jesús ìwali ichùnìacáiná nía canánama íiwitáise iyúwa, níái cáuláiquéeyéica. ");
INSERT INTO pioNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Néese Jesús iicáidaca yéewáidacalénái iríwa. Yá íimaca nalí: “Casíimáipinácuéca piwàwa, píacué catúulécanéeyéica, pimàacacáinácué Dios icùaca pía siùcáisede. ");
INSERT INTO pioNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","“Casíimáipinácuéca nacái píawa, píacué máapíiyéica siùca, Dioscáiná yàapinácué piyáapiná cadénama. “Casíimáipinácuéca nacái píawa, píacué achúméeyéica iwàwa siùca, Dioscáiná imàacapinácué casíimáica píawa. ");
INSERT INTO pioNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“Casíimáipinácuéca nacái píawa, báawacaalícué wenàiwica iicáca pía, náucacaalícué nacái pía náichawa, nacuísacaalícué pía nacái, natàanícaalícué báawéeri iyú pìwali, peebáidacáinácué nutàacái, núa asìali Dios néeséerica. ");
INSERT INTO pioNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Casíimáicué piwàwa manuísíwata, piyanídacuéwa casíimáiri iyú namànicaalícué pirí cài, yácáiná Dios imàacapinácué pirí manuísíwéeri cawèníiri pìanàacaalípinácué chènuniré, bàaluitécáiná níái wenàiwica yàawirináimica namànicaté báawéeri nacái profetanái irí, níái Dios yàasu wenàiwica profetanái íibaidéeyéicaté Dios irípiná càide iyúwacué pìyáaná”, íimaca yái Jesúsca yéewáidacalénái iríwa. ");
INSERT INTO pioNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Néese Jesús íimaca áibanái wenàiwica irí: “Quéwa, ¡máinícué piùwichàapinácawa, píacué càasuíyéica! Yácáiná Dios yùuwichàidapinácué píawa, néese càmitacué quirínama casíimái piwàwa pìasu cawèníirimi ìwaliwa, yái pidènièricuéca siùca. ");
INSERT INTO pioNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","“¡Máinícué piùwichàapinácawa, píacué ìyéeyéica iyáacaléwa cadénama, mesúnamáicáináta piùwichàapinácué máapicái! “¡Máinícué piùwichàapinácawa píacué iicáaníiyéica siùca. Aiba èeriwa píicháanípinácuéca achúmacáiná piwàwa! ");
INSERT INTO pioNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“¡Máinícué piùwichàapinácawa pitàanícáinácué méetàuculéeri tàacáisi ìwali, càmíiri Dios itàacái, íná yéewa macái èeri mìnanái càmíiyéica iwàwa Dios natàanícuéca pìwali cayábéeri iyú. Càité nacái pìawirináimicué itàanícaté cayábéeri iyú áibanái cachìwéeyéi iwicùlidéeyéi ìwali itàaníiyéicasa Dios inùmalìcuíse, quéwa nachìwáidacaté wenàiwica meedá!”, íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Néese Jesús íimaca yéewáidacalénái iríwa: “Quéwa núumacué nacái pirí píacué yéemièyéica nulí: Iwàwacutácué cáinináca piicáca piùwidenáiwa. Pimàni nacái nalí cayábéeri cawinácaalícué báawéeyéica iicáca pía. ");
INSERT INTO pioNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Pisutácué nalí Dios íicha imàníinápiná nalí cayábéeri, cawinácaalícué ibànuèyéica pìwali chàwicùli. Pisutácué nalí Dios íicha cawinácaalícué icuíséeyéica pía. ");
INSERT INTO pioNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Aiba inúacaalí pinàni ìwali, pimàaca inúaca pinàni ìwali abéemàawáise àniwa. Aiba yeedácaalí píicha pìasu ruana nacáiri, pimàaca yeedáca picamisani nacái. ");
INSERT INTO pioNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Aiba isutácaalí píicha wawàsi, pimàaca iríni; imelùdacaalí píicha pìasu, picá pisutá yèepùadáanápiná piríni. ");
INSERT INTO pioNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Pimànicué áibanái irí cayábéeri, càide iyúwacué piwàwáaná namànica pirí cayábéeri. ");
INSERT INTO pioNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Cáininácaalícué piicáca níawamita cáininéeyéicuéca iicáca pía, càmitacué pimàni pìyaca cayábéeri wawàsica áibanái íicha, macái èeri mìnanái namànicáiná cài, nía nacái báawéeyéica íiwitáise namànica cài. Iná càmitacué máiní cayábéeyéi náicha pía. ");
INSERT INTO pioNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Càita nacái pimànicaalícué cayábéeri nalí níawamita imàníiyéicuéca pirí cayábéeri, càmitacué pimàni pìyaca cayábéeri wawàsica áibanái íicha, macái èeri mìnanái namànicáiná cài, nía nacái báawéeyéica íiwitáise namàni cài. Iná càmitacué máiní cayábéeyéi náicha pía. ");
INSERT INTO pioNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Pìacaalícué nacái áibanái ichàba pìasuwa níawamita píináidéeyéicuéca nèepùadáanápiná pirí cawèníiri àniwa, càmitacué pimàni pìyaca cayábéeri wawàsica áibanái íicha macái èeri mìnanái namànicáiná cài, nía nacái báawéeyéica íiwitáise nàaca áibanái báawéeyéi ichàba wawàsi needácaténá náicha cawèníiri àniwa. Iná càmitacué máiní cayábéeyéi náicha pía. ");
INSERT INTO pioNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Iwàwacutácué cáinináca piicáca piùwidenáiwa, pimànicué nacái nalí cayábéeri, pìacué nacái nachàba pìasuwa, éwita càmicaalí nèepùada pirícuéni. Yásí Dios imàacapinácué pirí cawèníiri manuísíwata chènuniré, yá nacái Wáaniri Dios yéenibepinácuéca píawa, yái Wáaniri Dios chènuníiséerica, imàníirica cayábéeri èeri mìnanái irí, éwita càmicáaníta nàaca irí cayábéeri, níái báawéeyéica íiwitáise. ");
INSERT INTO pioNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Iwàwacutácué catúulécanáca piicáca áibanái wenàiwica càide iyúwacué Wáaniri Dios catúulécanáaná iicáca pía”, íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Jesús íimaca yéewáidacalénái iríwa: “Picácué máiní picháawàaca áibanái iináwaná ìwali mamáalàacata, néese Dios càmitacué yùuwichàida píawa. Picácué píináidawa piùwichàidáanápiná áibanái imàníiyéica pirí báawéeri, néese Dios càmitacué yùuwichàida píawa. Pimàacacué piwàwawa nabáyawaná íicha, yásí Dios imàacacué iwàwawa pibáyawaná íicha. ");
INSERT INTO pioNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Pìacué áibanái irí càinácaalí wawàsi namáapuèrica píicha, yásí Dios yàacuéca piríwa càinácaalí wawàsi pimáapuèrica. Péemìacué comparación: Càide iyúwa wenàiwica cayábéeri íiwitáise ipuníadacaalícué cayába pìasu saco ituínási iyú, icusúa nacáicani, icàbadàa nacái néréni yéewanápiná ipuníadaca saco àta ituínási itúadacatalétawa saco inùma irìcuíse, càita nacái Dios imànicuéca piríwa cayábéeri manuísíwata. Pimànicaalícué áibanái irí cayábéeri manuísíwata, yásí Dios imànicuéca piríwa cayábéeri àniwa manuísíwata. Quéwa pimànicaalícué áibanái irí cayábéeri achúméeri meedá, néese Dios imànicuéca nacái pirí cayábéeri achúmáana meedá”, íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Jesús yéewáidaca nía áiba comparación iyú. Yá íimaca nalí: “Matuíri wenàiwica càmita idé itéca áiba matuíri àyapulìcubàa, ipíchaná pucháibanama náuwàacawa utàwi irìculé. Càita nacái càmitacué yéewa matuíyéica píiwitáise, iwàwacutácáiná péewáidaca wenàiwica matuíyéi íiwitáise náalíacaténá càinácaalí iyú náalimá nàyaca machacàníiri iyú. ");
INSERT INTO pioNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Cawinácaalícué wenàiwica péewáidéeyéica, càmitacué yéewa cáalíacáica píicha nía, néese idécanáamicué péewáidaca nía, yásí náalíacawa abéerita yái píaliéricuécawa. Iná iwàwacutácué máiní cáalíacáica pía yéewacaténá piyúudàaca nía cayába. ");
INSERT INTO pioNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Pía, idènièrica ibáyawaná manuíriwa, picá píináidawa máiní cayábaca pía áiba wenàiwica íicha idènièrica ibáyawanáwa achúméeri meedá. Péemìacué comparación: Pibáyawaná manuíri càicanide iyúwa manuíri àicu idéca nacáicaalí yúuwàacawa pituí irìculé. Néese áiba achúméeríwanái ibáyawaná càicanide iyúwa achúméeri imuluísi yúuwàacaalíwa ituí irìculé. ");
INSERT INTO pioNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Máinícáiná cabáyawanáca pía manuísíwata, íná canáca yéewaná báawaca piicáca píichawa áiba wenàiwica idènièrica ibáyawanáwa achúméeri meedá. Péemìacué comparación: Manuíri àicu yúuwàacaalíwa pituí irìculétá, yá càmita pidé piicáca cayába pimusúadacaténá imuluísi áiba wenàiwica ituí irìcuísetá. Càita nacái cabáyawanácaalí pía, picá cài píima áiba wenàiwica irí: ‘Nuénásàiri, pimàaca nucàlidaca pirí pibáyawaná ìwali, nuyúudàacaténá pimàacaca píichawani’, picá cài píimaca irí; pucháibaca píiwitáise pìyaca. ¡Pidéca piimáichaca meedá pibáyawanáwa! Iwàwacutá pimàacaca píichawa quéechacáwa yái báawéeri manuírica pimàníirica. Yásí pidéca pìalàaca áiba wenàiwica imàacáanápiná íichawa achúméeri báawéeri imàníirica”, íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Jesús yéewáidaca nía comparación iyú. Iimaca nalí: “Canáca cayábéeri àicu yáaliméeri idènìaca ìyacanáwa báawéeri. Canáca nacái báawéeri àicu yáaliméeri idènìaca ìyacanáwa cayábéeri. ");
INSERT INTO pioNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Càita wáalíacawa macái àicu ìwali, waicácaalí ìyacaná, cayábéericaalíni, càmicaalí nacái, yá báawéericani. Càmita weedá cayábéeri higuera ìyacaná tuíri íicha. Càmita nacái weedá cayábéeri uva ìyacaná áwa yúuba íicha. ");
INSERT INTO pioNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Càita nacái wáalimá wáalíacawa wenàiwicanái íiwitáise ìwali nacái: Cayábacaalí wenàiwica íiwitáise, yásí itàaníca cayábéeri tàacáisi iyú, yácáiná íiwitáise cayábéeri ìyaca iwàwalìcu. Càita nacái báawacaalí wenàiwica íiwitáise, yásí itàaníca báawéeri tàacáisi iyú, yácáiná íiwitáise báawéeri ìyaca iwàwalìcu. Wáalimá wáalíacawa wenàiwicanái íiwitáise ìwali wéemìacaalí càinácaalí wawàsi natàaníca ìwali yácáiná nawàwa idéca ipuníacawa iyú, yái cayábéerica, càmicaalí nacái, yá báawéerica meedáni. Iná iwàwacutácué cayábéeri píiwitáise piwàwalìcuísewa, yéewanápinácué péewáidaca wenàiwicanái báisíiri tàacáisi iyú”, íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Jesús íimaca: “Canéeri iwèni meedá píimáanácuéca nùwali ‘Wáiwacali’, càmicaalícáwa pimànicué càide iyúwa núumáaná pirí. ");
INSERT INTO pioNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Siùcade nucàlidacué pirí comparación píalíacaténáwa càinácaalí wenàiwica ìyaca yeebáidéerica nulí, yéemièrica nacái nutàacái, imàníirica nacái càide iyúwa nuchùulìanáni. ");
INSERT INTO pioNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Yái wenàiwicaca càicanide iyúwa asìali imàníirica capìi. Quéechacáwa íicaca depuíwalé. Yá asìali yàanàaca manuíri íba ìyéerica depuíwalé cáli irìcu, ibàlùadacaténá icapèewa íinata. Idécanáami imànica icapèewa íba íinata, yá inanába yéesacawa. Yái yéesacái yàacawa cachàiníiri iyú asìali icapèe ìwali. Càmita idé quéwa yéesacái icusúadaca capìi, asìali imànicáináté dàalawaca icapèewa. Càide iyúwa capìi ibàlùacaalíwa mamáalàacata, càita nacái cawinácaalí wenàiwica yeebáidéeyéica nutàacái nadènìapiná nacáucawa càmíiri imáalàawa. ");
INSERT INTO pioNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Aiba wenàiwica quéwa yéemìacaalí nutàacái, néese càmita imàni càide iyúwa núumáaná irí. Yái wenàiwicaca càicanide iyúwa wenàiwica imàníirica icapèewa cáli íinata, canéeri irí íba ibàluèripináwa íinata, yái capìica. Inanába yéesacawa, yá yéesacái yàacawa cachàiníiri iyú capìi ìwali. Yá caquialéta capìi yúuwàacawa, imáalàacawa macáita. Càide iyúwa capìi imáalàanáwa, càita nacái cawinácaalí wenàiwica càmíiyéica yeebáida nutàacái, canáca nacáuca càmíiri imáalàawa”, íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Idécanáamité Jesús icàlidaca wenàiwicanái iríni, yáté yàacawa Capernaum ìyacàlená néré. ");
INSERT INTO pioNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Iyaca néré abéeri romanonái yàasu úwi íiwacaliná, idènièrica yàasu wenàiwicawa cáininéerica iicáca. Cáuláicaca úwi íiwacaliná yàasu wenàiwica, iwàwéeri yéetácawa íiwacali íichawa. ");
INSERT INTO pioNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Néese úwi íiwacaliná yéemìaca Jesús iináwaná ìwali ichùnìaná wenàiwica, yá ibànùaca abénaméeyéi judío íiwacanánái nasutácaténá Jesús íicha wawàsi manuísíwata yàanàanápiná ichùnìaca yàasu wenàiwica. ");
INSERT INTO pioNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","5","Néese judío íiwacanánái nàacawa Jesús yàatalé. Yá nasutáca íicha wawàsi manuísíwata, náimaca Jesús irí: —‍Cayábaca piyúudàacani, yáara úwi íiwacalináca, cáininácáiná iicáca wía judíoca. Ipáyaidacáináténi namànicaténá walí wàasu wéewáidacàalu —‍náimaca. ");
INSERT INTO pioNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Néese Jesús yàacawa náapicha, quéwa mawiénicaalíté Jesús ìyaca úwi íiwacaliná icapèe irí, yá úwi íiwacaliná ibànùaca yàacawéeyéináwa náimacaténá Jesús irí: “Nuíwacali, càmita nuwàwa nusàiwicaca pirí wawàsi, canácáiná yéewaná nuedáca pía nùataléwa máinícáiná cayábéerica nuícha pía, íná báica nuicáca núawawa piwéré. ");
INSERT INTO pioNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Báica nuicáca núawawa piwéré, íná càmitaté nùa nucutáca pía, máinícáiná cayábéerica nuícha pía. Pichùulìacáita ichùnìanápináwa yái nùasu wenàiwicaca, yásí ichùnìacawa. ");
INSERT INTO pioNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Núalíacawa píalimá pichùnìacani pitàacái iyúwa, níacáiná nuíwacanánái nachùulìa nacái núa. Núa nacái nuchùulìa nùasu úwináiwa. Nuchùulìacaalí abéeri yèepùacawa, yáta yèepùacawa. Numáidacaalí abéeri, yáta yàanàaca. Nuchùulìacaalí àniwa nùasu wenàiwicawa imàníinápiná áiba wawàsi, yáta imànicani. Iná yéewa núalíacawa píalimá pichùnìacani nacái pitàacái iyúwa yái nùasu wenàiwicaca”, íimaca yái úwi íiwacalináca. ");
INSERT INTO pioNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Yá cayábaca Jesús íináidacawa yéemìaca úwi íiwacaliná itàacái. Néese Jesús iwènúacawa, yá íimaca nalí, níái manùbéeyéi wenàiwicaca yèeyéicawa yáamíise. —‍Péemìacué cayába, canácata nùanèeri càirica yeebáidéeri nulí manuísíwata, ibatàa Israel itaquénáinámi yéenápináta, càmitàacá nùanàa càiri —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Néese níái wenàiwicaca úwi íiwacaliná ibànuèyéicaté nèepùacawa úwi íiwacaliná icapèe néré, yá nàanàaca yàasu wenàiwica idéená cayábacani. ");
INSERT INTO pioNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Néeseté àniwa, Jesús yàacawa Naín ìyacàlená nérépiná. Yàacawa yéewáidacalénái yáapichawa, madécaná nacái áibanái wenàiwica yáapicha. ");
INSERT INTO pioNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Jesús ìyacaalíté mawiénita yàcalé irí, yá iicáca manùba wenàiwica namusúacawa íipunita yàcalé irìcuíse. Nawáacutáida nàacawa yéetéerimiwa. Nàacawa nabàlìacaténáni. Yácata abéerita uìrica úái yáatúaca inìrimi yéetéechúamicawa íicha. Madécaná wenàiwica namusúacawa yàcalé irìcuíse nacái nàacawéeridacaténá úa. ");
INSERT INTO pioNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Yá Wáiwacali iicáca uícháaníca, yá catúulécanáca iicáca úa. Yá íimaca ulí: —‍Picá píicháaní —‍íimaca ulí yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Néese Jesús yàacawa nàatalé, níái itéeyéica yéetéerimiwa. Yá Jesús imàacaca icáapiwa yàalubái ìwali, chéecáisi irièriwa íinata. Yá wenàiwicanái nayamáa nabàlùacawa. Yá néese Jesús íimaca yéetéerimi iríwa: —‍Pía ùuculìirica, núuma pirí: ¡Pimichàawa! —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Néese yái ùuculìirica imichàa yáawinacawa, cáuca àniwani. Yá idàbaca itàaníca àniwa. Néese Jesús itéca ùuculìiri yáatúa yàataléwa yèepùadacaténá ulí àniwani. ");
INSERT INTO pioNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Macáita naicáca cáucani, yá cáaluca nía, náalíacáináwa Jesús idènìaca Dios íiwitáise cachàiníiri. Yá nàaca Dios irí cayábéeri. Náimaca nalíwáaca: —‍Idéca yàanàaca wàatalé cachàiníiri profeta icàlidéerica Dios itàacái —‍náimaca Jesús ìwali. Yá náimaca nacái: —‍Dios idéca yàanàaca yàacawéeridacaténá wía —‍náimaca. ");
INSERT INTO pioNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Néese macáita ìyéeyéica Judea yàasu cáli íinata, nía nacái ìyéeyéica áiba yàcalé irìcu mawiéníiyéica néemìaca Jesús iináwaná ìwali, icáucàidacaté yéetéerimiwa. ");
INSERT INTO pioNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Juan el Bautista ìyacaté mamáalàacata presoíyéi ibànalìcu. Néese yéewáidacalénái nacàlidaca irí macáita yái Jesús imàníirica. Yáté Juan imáidaca pucháiba yéewáidacaléwa. ");
INSERT INTO pioNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Juan ibànùaca nía Jesús yàatalépiná nasutácaténá néemìawa Jesús asáisí báisícaalí Dios néeséericani, yái wenàiwica Dios ibànuèripinácaté judío icuèrinápiná, néese càmicaalí yáníi, yá iwàwacutá nacùaca áiba yàanàaca. ");
INSERT INTO pioNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Níái Juan ibànuèyéica nàacatéwa Jesús yàatalé. Yá náimaca irí: —‍Juan el Bautista ibànùaca wía wasutácaténá wéemìawa pía, asáisí Dios néeséericaalí pía, yái iwàwacutéericaté yàanàapináca, quéwa càmicaalí píani, ¿iwàwacutásica wacùaca áiba yàanàaca? —‍náimaca. ");
INSERT INTO pioNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Idécanáamité Jesús yéemìaca natàacái, yáta èerica Jesús ichùnìaca madécaná cáuláiquéeyéi nàuwichàacái íichawa, idècunitàacá Juan yéewáidacalénái ìyaca néré. Jesús yúucaca demonio abénaméeyéi wenàiwica íicha. Imàaca nacái manùbéeyéi matuíyéi iicáidaca nacái. ");
INSERT INTO pioNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Néese Jesús íimaca nalí níái Juan ibànuèyéica: —‍Pèepùacué picàlidaca Juan iríni pidéenácuéca piicáca, péemìaca nacái. Picàlidacué iríni matuíyéimi idéca iicáidaca, éeruíyéimi yàabàli nacái nadéca nàipìnáaníca, cacháunéeyéimi íimami lepra iyú nacái, idéca cayábaca nía uláicái íicha, màuwíiyéimi nacái nadéca néemìaca, yéetéeyéimiwa nacái nadéca namichàacawa yéetácáisi íicha, catúulécanéeyéi nacái nadéca néemìaca nuwàwaca nuwasàaca nía Dios yàasu yùuwichàacáisi íicha. Picàlidacué Juan iríni yáalíacaténáwa idéca nùanàaca, núa Dios néeséerica. ");
INSERT INTO pioNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","¡Casíimáica cawinácaalí wenàiwica yeebáidéeyéica nulí mamáalàacata! —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Néese idécanáamité Juan yéewáidacalénái yèepùacawa Jesús íicha, yá Jesús idàbaca icàlidaca Juan el Bautista iináwaná ìwali. Jesús íimaca: “Bàaluité pìacatécué piicáca wenàiwica ìyéericaté manacúali yùucubàa càináwàiri, yáara Juanca. Càmíiritaté machawàaca íiwitáise yái asìali piiquéericatécué, càide iyúwa masicái cáuli yáawiadáidéerica meedá. ");
INSERT INTO pioNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","¿Càinásicué piicá néré bàaluité? Càmíiritaté asìali cawèníiri ibàle yái piiquéericatécué. Píalíacuéwa cawinácaalí cawèníiyéica ibàle, ìyéeyéica nacái càasuíri iyú, nàyaca cayábéeri capìi irìcu càide iyúwa reynái ìyáaná, icuèyéica manùbéeyéi wenàiwica. ");
INSERT INTO pioNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Bàaluité pìacuécawa manacúali yùuculé càináwàiri piicácaténáté profeta icàlidéerica tàacáisi Dios inùmalìcuíse. Báisíta profetacani, yái Juanca, quéwa máiníiri cachàinica áibanái profeta íicha canánama. ");
INSERT INTO pioNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Yái Juanca, yácata yáara nacàlidéericaté ìwali tàacáisi Dios inùmalìcuíse. Profeta itànàacaté tàacáisi Dios íiméericaté Iiri iríwa. Dios íimacaté: ‘Nuchùulìapiná pipíchalé nùasu wenàiwicawa icàlidéerica nutàacáiwa. Yá yàapinácawa pipíchalé yàalàacaténá wenàiwica nachùnìanápiná náiwitáisewa yéewanápiná natàidaca pía cayába pìanàacaalíwa nàatalé’, íimacaté yái Diosca. ");
INSERT INTO pioNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Péemìacué cayába, canácata áiba wenàiwica cachàiníiri Juan íicha nèewíise macái wenàiwica imusuéyéicawa inanái íicha. Quéwa cawinácaalí wenàiwica yeebáidéeyéica Dios itàacái siùcáisede, yéewanápiná Dios icùaca nía, máiní cachàinipináca nía Juan íicha, éwita càmicáaníta máiní cachàinica nía Dios ìyacàle irìcu Dios icùacataléca macáita chènuniré. ");
INSERT INTO pioNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","“Manùbéeyéi wenàiwica yéemièyéicaté Juan itàacái, abénaméeyéi nacái yeedéeyéica plata néenánái judío íichawa Roma ìyacàlená yàasu gobierno irípiná, nawènúadacaté náiwitáisewa nabáyawaná íichawa, yá namàacaca Juan ibautizáca nía. Càité náasáidaca náalíacawa Dios icùaca wenàiwica machacàníiri iyú. ");
INSERT INTO pioNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Quéwa fariseonái, nía nacái yéewáidéeyéica wenàiwica templo irìcu, càmitaté namàaca Juan ibautizáca nía, càmicáináté nawènúada náiwitáisewa Dios irípiná. Càité caná iwèni meedá naicáca yái cayábéerica Dios iwàwéericaté imànica nalí. ");
INSERT INTO pioNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","“Nucàlidacué pirí càiná píiwitáise, píacué wenàiwicaca ìyéeyéica siùca. ");
INSERT INTO pioNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Péemìacué comparación: Càicuéca píade iyúwa sùmanái yáawinéeyéicawa àyapulìcubàa bamuchúamibàa yàcalé. Néese namáidaca nanacáiyéi iríwa, ‘Wadéca wapùlìacuéca pirí íwa, quéwa càmitacué pilabàa; néese wadéca wacántàaca pirícué canción càide iyúwa nacántàaná yéetéeyéimiwa ìwali, quéwa càmitacué píicháaní’, cài náimaca. ");
INSERT INTO pioNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Càita nacái pimànicuéca. Juan el Bautista yàanàacaté, yá imàacacaté íichawa iyáacaléwa isutácaténá Dios íicha manuísíwata, càmita nacái ìira uva ituní. Quéwa píimacuéca Juan ìwali demoniosa ìyaca iwàwalìcu. ");
INSERT INTO pioNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Siùca nudéca nùanàaca, núa asìali Dios néeséerica. Nuyáaca nuyáacaléwa, nuìra nacái uva ituní. Néese píimacuéca nùwali camùníiricasa núa, cáanáirisa iyáaca iyáacaléwa núa, casíimáicasa nacái nucàmaca, nùacawéeridáanása nacái cabáyawanéeyéi wenàiwica, nía nacái yeedéeyéica plata néenánái judío íichawa Roma ìyacàlená yàasu gobierno irípiná. Càita píimacuéca nùwali càmicáinácué piwàwa peebáidaca nutàacái. ");
INSERT INTO pioNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Quéwa cawinácaalí yeebáidéeyéica Juan yàasu tàacáisi nutàacái nacái, náasáidaca Dios imàacaca cáalíacáica nía báisíiri iyú”, íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Abéeri fariseo íipidenéeri Simón imáidaca yàataléwa Jesús iyáanápiná iyáacaléwa yáapicha, íná Jesús yàacawa fariseo icapèe irìculé, yá yáawinacawa iyáacaténá iyáacaléwa. ");
INSERT INTO pioNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Néese inanái ùanàaca néré, ìyéechúa yàcalé irìcu, iiméechúacaté nacái asìanái yáapicha plata ìwalinápiná. Uémìacaté Jesús iináwaná ìwali iwàlùanáwa fariseo icapèe irìculé iyáacaténá iyáacaléwa. Iná ùanàaca néré utéca catùa ucáapi irìcuwa, abéechúa catùa cawèníichúa alabastro icatùalená, ipuniéchúawa perfume pumèníiri isàni iyú. ");
INSERT INTO pioNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Uícháaníca ùacawa ubáyawaná ìwaliwa, yá ùacawa Jesús yàatalé. Uawinacawa mawiénita yàabàli irí. Néese udàbaca uíbaca Jesús yàabàli utuíyáa iyúwa. Néese uchuìdaca yàabàli uíwita ibáiná iyúwa, usùsùaca nacái Jesús yàabàli càide iyúwaté judío íiwitáise nàanáté náiwacali icàaluínináwa. Néese ùucùaca perfume pumèníirica isàni yàabàli ìwali. ");
INSERT INTO pioNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Néese yái fariseo imáidéerica yàataléwa Jesús, iicácáiná inanái imàníirica Jesús irí, íná fariseo íimaca íináidacawa iríwa iwàwalìcuísewa: “Báisícaalí profetasíwa yái asìalitá, yá yáalíacawa càinácaalí uíwitáisetá úái imàaquéechúaca icáapiwa ìwali, úái imàníichúaca ibáyawanáwa”, íimaca íináidacawa iríwa yái fariseo Simónca. Quéwa Jesús yáalíacawa Simón íináidáanáwa iwàwalìcuísewa. ");
INSERT INTO pioNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Iná Jesús íimaca fariseo irí: —‍Simón, nuwàwaca nucàlidaca pirí wawàsi —‍íimaca yái Jesúsca. Néese fariseo íimaca: —‍Picàlida nulíni, pía yéewáidéerica wenàiwica —‍íimaca yái fariseoca. ");
INSERT INTO pioNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","42","Néese Jesús íimaca fariseo irí: —‍Péemìa comparación. Iyacaté asìali yèerica plata áibanái ichàba maléená èeripiná. Néesetécáwa iwàwacutá nèepùadaca irí àniwani. Nàyacaté pucháiba asìanái imawènièyéica íicha plata. Abéeri imawènìaca íicha quinientos namanùbaca denario. Aiba imawènìaca íicha cincuenta namanùbaca denario. Càmicáiná náalimá napáyaidaca náichawa yái namawènìacálecawa, íná catúulécanáca iicáca nía, yá imàacaca iwàwawa namawènìacále íicha, yéewacaténá càmita iwàwacutá napáyaidaca náichawani. Picàlida nulíni, Simón, ¿cawiná náicha cáininéeripiná yáwanái iicáca asìali yèerica wenàiwica ichàba plata? —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Néese Simón íimaca Jesús irí: —‍Cawàwanáta yáara asìali imawènièricaté íicha manùba plata íicha áiba asìali imawènièricaté. Yácata cáininéerica yáwanái iicácani, cawàwanáta —‍íimaca yái Simónca. Néese Jesús íimaca irí: —‍Pidéca picàlidaca cayábani —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Néese Jesús iwènúacawa, iicáca upualé, úái inanáica, yá íimaca Simón irí: —‍¿Piicásica úái inanáica? Nudéca nùanàaca pìatalé picapèe irìculé, quéwa càmita pité nulí úni nuíbacaténá nùabàliwa, néese úái inanáica udéca uíbaca nùabàli utuíyáa iyúwa, yá uchuìdacani uíwita ibáiná iyúwa. ");
INSERT INTO pioNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Càmita pisùsùa nunàni ìwali pitàidacaténá cayába núa càide iyúwa wáiwitáise ìyáaná, wía judíoca; quéwa úái inanáica, nudécanáami nuwàlùacawa capìi irìculé, càmita uyamáida usùsùaca nùabàli ùacaténá nucàaluíniná, càide iyúwa judío íiwitáise ìyáaná. ");
INSERT INTO pioNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Càmita piùcùa mawèníiri olivo iséená nuíwita ìwali píasáidacaténá casíimáica piicáca núa càide iyúwa judío íiwitáise ìyáaná; quéwa úái inanáica udéca ùucùaca cawèníiri perfume pumèníiri isàni nùabàli ìwali. ");
INSERT INTO pioNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Iná núuma pirí nudéca numàacaca nuwàwawa ubáyawaná íicha, yái ubáyawanáca manuírica, máinícáiná cáinináca uicáca núa; quéwa pía iyúunáidéerica càmita máiní cabáyawanáca càmita máiní cáinináca piicáca núa —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Néese Jesús íimaca ulí úái inanáica: —‍Nudéca numàacaca nuwàwawa pibáyawaná íicha cayábacaténá píapicha Dios —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Néese áibanái wenàiwica fariseo imáidéeyéica néré, nadàbaca náimaca nalíwáaca: —‍Càmíirita Dios yái, íná canéerica iwèni meedá imàacáanácasa iwàwawa ubáyawaná íicha —‍náimaca náináidacawa nalíwa. ");
INSERT INTO pioNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Quéwa Jesús íimaca ulí, úái inanáica: —‍Nudéca nuwasàaca pía Dios yàasu yùuwichàacáisi íicha, peebáidacáiná nulí. Pìawa matuíbanáita —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Néeseté Jesús yàaca ipáchiaca yèepunícawa yàcalé manùbéeri irìculé, manuíri yàcalé, púubéeri nacái. Yá icàlidaca nalí Dios itàacái cayábéeri náalíacaténátéwa càinácaalí iyú Dios icùaca yàasu wenàiwicawa. Níái doce namanùbaca apóstolca nàacawa Jesús yáapicha. ");
INSERT INTO pioNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Abénaméeyéi inanái nàacawa náapicha nacái, Jesús yúuquéeyéica íicha demonio, uláicái nacái. Abéechúa néená íipidenéechúa María Magdalena, úái Jesús yúuquéechúacaté íicha siete namanùbaca demonio. ");
INSERT INTO pioNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Uacawa náapicha nacái Cuza yàacawéetúa íipidenéechúa Juana. Uacawéeri Cuza ichùulìaca rey Herodes yàasu wenàiwica íibaidéeyéica Herodes icapèerìcu; áiba inanái íipidenéechúa Susana ùacawéeridaca nía nacái; áibanái nacái manùbéeyéi inanái nàacawa náapicha nayúudàacaténá nía nàasu iyúwa. ");
INSERT INTO pioNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Néeseté manùbéeyéi wenàiwica nàwacáidáyacacawa naicácaténá Jesús. Namusúacawa mamáalàacata manùba yàcalé néese, yá nàanàaca Jesús yàatalé. Yá Jesús icàlidaca nalí comparación yéewáidacaténá nía. Yá íimaca nalí: ");
INSERT INTO pioNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Péemìacué comparación: Abéeri asìali ibàna yàacawa ituínási. Yá yàacawa càide iyúwa náiwitáise nabànáaná ituínási, yàaca icasáaca yàacawa bànacalé. Abénaméeyéi ituínási yúuwàacawa àyapulìcubàa, néese áibanái wenàiwica nabawàidaca ituínási. Néese màsibèenái yàanàaca néré, yá nayáaca íimi. ");
INSERT INTO pioNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Aiba ituínási yéená yúuwàacawa cáli íinata íba yèewiré. Néese ituínási ibacácaalíwa, yá yéetácawa chuìcáiná cáli. ");
INSERT INTO pioNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Aiba ituínási yéená yúuwàacawa tuíri yèewiré. Yá idàwinàacawa tuíri yáapicha. Quéwa tuíri idàwinàacawa dàalawaca bànacalé yèewibàa, càmita ibatàa bànacalé idàwinàacawa cayába. ");
INSERT INTO pioNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Aiba ituínási yéená yúuwàacawa cayábéeri cáli íinata. Idàwinàacanáamiwa, yá idènìaca ìyacanáwa manùba. Madécaná yéetaná nadènìaca natuínáwa cien namanùbaca”, càité Jesús yéewáidaca nía. Néese Jesús íimaca nalí cachàiníiri iyú: “¡Càuwíiyéicaalícué pía, péemìacué nutàacái!” íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Néese Jesús yéewáidacalénái nasutáca néemìawani càinácaalí íimáaná yái comparaciónca. ");
INSERT INTO pioNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Yá Jesús íimaca nalí: “Dios imàacacué píalíacawa càinácaalí iyú icùaca yàasu wenàiwicawa. Càmita imàaca áibanái yáalíacawa. Nucàlida quéwa áibanái iríni comparación iyú, yéewanápiná càmita náalimá náalía néemìacani càinácaalí íimáaná. Ewita naicácáaníta yái numàníirica, càicáaníta càmita náalía ìwali càinácaalí íimáaná. Ewita néemìacáaníta nutàacái, càicáaníta càmita náalíawa néemìaca càinácaalí íimáaná”, íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","12","Jesús íimaca nalí: “Yácata íimáanáca yái comparaciónca. Yái ituínásica íimáanáca càicanide iyúwa Dios itàacái. Yá ituínásica yúuwèericawa àyapulìcubàa íimáanáca càicanide iyúwa wenàiwica yéemìacaalí Dios itàacái, quéwa Satanás yàanàaca imàacaca naimáichaca Dios itàacái ipíchaná neebáidacani, ipíchaná nacái namusúacawa Dios yàasu yùuwichàacáisi íicha. ");
INSERT INTO pioNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Yái ituínásica yúuwèericawa íba yèewiré íimáanáca càicanide iyúwa wenàiwica néemìacaalí Dios itàacái, yá neebáidaca casíimáiri iyúni, quéwa neebáidaca maléená èeri meedáni. Càide iyúwa ituínási ibacácaalíwa, yá idàwinàacawa maléená èeri, néese yéetácawa canácáiná ipìchu cayába cáaléeri, càita nacái abénaméeyéi wenàiwica yéemièyéica Dios itàacái. Neebáidaca Dios itàacái maléená èeri. Néese nadàbacaalí nàuwichàacawa Dios irípiná, neebáidacáiná itàacái, càmicaalí nacái, Satanás yáalimáidacaalí nía namàníinápiná nabáyawanáwa, yásí nacaláacawa Dios itàacái íicha, yá nawènúadaca náiwitáisewa Dios íicha. ");
INSERT INTO pioNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Yái ituínásica yúuwèericawa tuíri yèewiré, yácata íimáanáca càicanide iyúwa wenàiwica néemìacaalí Dios itàacái, náináidacawa nacái ìwali, quéwa càmita máiní namàni cayábéeri càide iyúwa Dios iwàwáaná. Càide iyúwa càmicaalí bànacalé idàwinàawa cayába dàalacáiná tuíri ìyaca itéesebàa, càita nacái abénaméeyéi wenàiwica. Náináidacawa nawàwawa nàasu ìwaliwa, yái èeri irìcuírica. Náináidacawa nacái plata ìwali meedá càasucaténá nía. Náináidacawa nacái nàwali macái wawàsi isíimáidéeripináca níawa chái èeri irìcu. Càide iyúwa bànacalé idàwinàacaalíwa báawata, quéwa canácatáita càyacanáni, càita nacái abénaméeyéi wenàiwica. Neebáca Dios itàacái báawatata, càmíirita quéwa nawàwalìcuísewa, íná càmita máiní namàni cayábéeri càide iyúwa Dios iwàwáaná. ");
INSERT INTO pioNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Néese yái ituínásica yúuwèericawa cayábéeri cáli íinata íimáanáca càicanide iyúwa wenàiwica cayábéeri íiwitáise néemìacaalí Dios itàacái, yá neebáidaca Dios itàacái tài íiméeri iyú náiwitáise cayábéeri yáapichawa machìwéeri nacái. Néese namànica cayábéeri manuísíwata càide iyúwa bànacalé idènìacaalí mamáalàacata cayábéeri ìyacanáwa manùba”, íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Néese Jesús yéewáidaca nía àniwa comparación iyú: “Càmita watùcunìa lámpara wabàacaténáni yàalusi irìculé, càmita nacái wabàa lámpara wàasu cama yáapiréwa, yái waiméerica íinata. Néese wamàacaca lámpara icànaca chènunibàa yéewacaténá icànaca wenàiwica ìwali iwàluèyéicawa capìi irìculé. ");
INSERT INTO pioNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Yái lámpara íimáanáca càicanide iyúwacué pìyáaná, píacué nuéwáidacaléca. Dios iwàwacué péewáidaca wenàiwica Dios itàacái iyú, yái tàacáisi ibàacanéeri píaliéricuécawa ìwali, càide iyúwa lámpara icànacaalí wenàiwica ìwali, naicácaténá cayába. Dios iwàwaca náalíacawa ìwali macáita yái tàacáisi càmíiricáwaca náalíawa ìwali. ");
INSERT INTO pioNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“Iná péemìacué cayába nutàacái. Píináidacuéwa cayába ìwali yái péemièricuéca nucàlidaca pirí. Píináidacaalícuéwa cayábéeri iyú nutàacái ìwali, yásí Dios imàacacué píalíacawa mamáalàacata. Quéwa càmicaalícué píináidawa cayába nutàacái ìwali, yásí piimáichacuéca nacái àta càinácaalí wawàsi piyúunáidéericuéca píalíacawa ìwali”, íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Néeseté Jesús yáatúa yàanàaca yàatalé, Jesús yéenánái yáapicha. Càmita quéwa náalimá nawàlùacawa capìi irìculé manùbacáiná wenàiwica néré. ");
INSERT INTO pioNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Aiba wenàiwica icàlidaca Jesús iríni. Yá íimaca Jesús irí: —‍Píatúaca úara ibàlùawa bàacháwáise péenánái yáapicha. Nawàwa naicáca pía —‍íimaca. ");
INSERT INTO pioNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Quéwa Jesús íimaca: —‍Cawinácaalí wenàiwica yéemièyéica Dios itàacái, imàníiyéica nacái càide iyúwa Dios íimáaná, nuicáca nía càide iyúwa núatúanáiwa, nuénánái nacáiwa —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Aiba èerité Jesús iwàlùacawa barca irìculé yéewáidacalénái yáapichawa. Yá íimaca nalí: —‍Wachàbacuéwa abéemàalé Galilea icalìsaniná íicha —‍íimaca. Iná nàacawa. ");
INSERT INTO pioNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Idècunitàacá nachàbacawa calìsa ìwalìabàa, yá Jesús iimáca íichawa. Yáta manuíri cáuli idàbaca ipùaca nàwali. Yá màladàca idàbaca ipuníadaca barca úni iyú, yá nasawíaca nàacawa. ");
INSERT INTO pioNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Iná nacawàidaca Jesús, yá náimaca irí: —‍¡Wáiwacali! ¡Wasawíaca wàacawa! —‍náimaca Jesús irí. Néese Jesús imichàaca ibàlùacawa, yá ichùulìaca cáuli, màladàca nacái wiúnápináni. Yá wiúca macáita màladàca. ");
INSERT INTO pioNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Néesecáwa Jesús íimaca yéewáidacalénái iríwa: —‍¿Cánácué càmita manuí píináidacawa piwàwawa nùwali? —‍íimaca. Quéwa cáaluca nía, náináidacawa manuísíwata naicáidaca Jesús irí nacái. Yá nasutáca néemìawa níawáaca: —‍¿Cawinásica yái asìalica, ichùulièrica cáuli, màladàca nacái, yásí neebáidaca càide iyúwa ichùulìaná nía? —‍náimaca nalíwáaca. ");
INSERT INTO pioNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Atata nàanàacaté abéemàalé Galilea icalìsaniná íicha, aléera Gerasa yàasu cáli néré, ìyéerica abéemàise Galilea yàasu cáli íicha. ");
INSERT INTO pioNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Jesús iricùacawa barca irìcuíse cáli íinatalé, yá asìali imusúacawa yàcalé íicha, demonio idacuèrica íiwitáise, yá yàacawa Jesús yàatalé. Madécaná camuí yèepunícawa mabàleta yái asìalica. Càmita ìya capìirìcu. Néese ìyaca yéetáními icàliculèená yèewibàa. ");
INSERT INTO pioNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Néese asìali iicáca Jesús, yá ibàlùacawa yùuluì ipùata iyúwa Jesús irí, yá demonio yéemíanícawa asìali isàna iyú: —‍¡Picá pisàiwica nulí wawàsi, pía Jesús, yái Dios chènuníiséeri Iirica! Nusutáca píicha wawàsi, picá piùwichàida núa —‍íimaca. ");
INSERT INTO pioNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Isutáca Jesús íicha cài, yácáiná Jesús ichùulìaca ìyaca demonio yàanápináwa asìali íicha. Demonio idacùacaté asìali íiwitáise manùba yàawiría. Yá éwita áibanái idacùacáaníta asìali cadena iyú, icáapi, yàabàli nacái ipíchaná imusúacawa, càicáaníta imàdáidacaté íichawani yái cadenaca. Yá demonio ipìadáidaca asìali manacúali yùuculépiná càináwàiri canácatalé wenàiwica. ");
INSERT INTO pioNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Néese, Jesús isutáca yéemìawa demonio: —‍¿Càiná píipidená? —‍íimaca yái Jesúsca. Néese demonio íimaca: —‍Nuípidená Legión, íimáanáca “cawàwanáta cinco mil namanùbaca” —‍íimaca yái demonioca. Càité íimaca madécanácáiná demonio nawàlùacatéwa iwàwalìculé, yái asìalica. ");
INSERT INTO pioNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Néese, demonionái isutáca Jesús íicha wawàsi manuísíwata ipíchaná ichùulìaca nàacawa depuíwéeri utàwi irìculé nàuwichàacatalépinácawa. ");
INSERT INTO pioNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Mawiénita nalí manùbéeyéi marranonái yèepuníwa. Nayáaca nèepunícawa nayáacaléwa dúli ìwali. Iná demonionái isutáca Jesús íicha wawàsi imàacáanápiná nawàlùacawa marranonái idèerìculé. Yá Jesús imàacaca nàacawa. ");
INSERT INTO pioNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Iná demonionái yàacawa asìali íicha. Yá nawàlùacawa marranonái idèerìculé. Néese macáita marranonái napìacawa iyúwa máiwitáiséeyéi demonio íiwitáise iyú, nacaláacawa quìratàli íinatáise calìsa yáaculé. Yá macáita nàisicùmacawa, níái pìráica càmíiyéica Dios imàaca judíonái idènìaca, casacàacáiná nalí marrano iiná. ");
INSERT INTO pioNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Néese níái icuèyéicaté marranonáimi naicácaalíté marranonái yéetáanáwa, yá napìacawa, nacàlidaca nalíni yàcalé irìcu, nalí nacái áibanái wenàiwica ìyéeyéica yàcalé itéese. ");
INSERT INTO pioNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Néese wenàiwicanái namusúacawa yàcalé íicha naicácaténá nàyáaná. Yá nàacawa Jesús yàatalé. Naicáca asìali demonio yèericatéwa íicha. Yáawinéeriwa Jesús yàabàli néenibàa, cabàleta, cáiwitáisewaca. Yá cáaluca níái yàcalé mìnanáica. ");
INSERT INTO pioNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Néese níái icuèyéicaté marranonáimi iiquéeyéicaté macáitani, nacàlidaca yàcalé mìnanái irí Jesús ichùnìacaté asìali demonionái ìyéericaté iwàwalìcu. ");
INSERT INTO pioNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Néese macáita Gerasa yàasu cáli néeséeyéi nasutáca Jesús íicha wawàsi manuísíwata yèepùanápináwa náicha, máinícáiná cáaluca naicácani. Iná Jesús iwàlùacawa barca irìculé, yèepùacaténáwa náicha, yéewáidacalénái yáapichawa. ");
INSERT INTO pioNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Yái asìali demonio yèericatéwa íicha isutáca Jesús íicha wawàsi manuísíwata imàacáanápiná yàacawa yáapicha. Quéwa Jesús ichùulìacani iyamáanápináwa. Yá Jesús íimaca irí: ");
INSERT INTO pioNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","—‍Pèepùawa picapèe néréwa, picàlida péenánái iríwa ìwali yái cayábéerica Dios imàníirica pirí —‍íimaca yái Jesúsca. Néese, yái asìali yàaca icàlidaca macáita ìyacàle mìnanái iríwani, Jesús imàníináté irí cayábéeri manuísíwata. ");
INSERT INTO pioNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Néese Jesús idécanáamité ichàbacawa àniwa abéemàalé Galilea icalìsaniná íicha barca irìcu, yá madécaná wenàiwica itàidacani casíimáiri iyú, nacùacáináté Jesús yàanàaca néré. ");
INSERT INTO pioNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Néese áiba asìali yàanàaca Jesús yàatalé, íipidenéeri Jairo. Judíonái yéewáidacàalu íiwacalicani, yái Jairoca. Yá yúuwàa irìacawa inùmáawawa Jesús irí yàacaténá Jesús icàaluíniná, yéewanápiná Jesús iicáca ipualé. Yá isutáca Jesús íicha wawàsi manuísíwata yàanápináwa icapèe néré. ");
INSERT INTO pioNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Jairo idènìacáiná abéechúata íiduwa, idènièchúa doce camuí, iculuéchúawa, iwàwéechúa yéetácawa Jairo íicha. Yá Jesús yàacawa Jaironái yáapicha madécaná wenàiwica yèewi. Máinícáiná manùbaca wenàiwica, íná nacàbadàayacacawa nàacawa Jesús iwéré. ");
INSERT INTO pioNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Abéechúa inanái ùacawa manùbéeyéi wenàiwica yèewi. Cáuláicaca úa doce camuí, uíraná yàacawa uícha mamáalàacata. Uucacaté macáita ùasu platawa upáyaidacaténá cadèpìacáiyéi quéwa canácata yáaliméerité ichùnìaca úa. ");
INSERT INTO pioNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Uái inanáica ùacawa Jesús yáamíise mawiénita irí. Yá udunùaca ibàle ipùata ìwali. Yáta uíraná iyamáacawa uícha. ");
INSERT INTO pioNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Néese Jesús isutáca yéemìawa níái wenàiwicaca: —‍¿Cawiná idunùa nùwali? —‍íimaca nalí. Yá macáita náimaca càmitasa nadunùa ìwali. Iná Pedronái íimaca Jesús irí: —‍Wáiwacali, dàalaca wenàiwica yèeyéicawa wáapicha, nawesíaca nàacawa pía macái pìwalíiseta. ¿Cáná pisutáca péemìawa cài? —‍íimaca yái Pedroca. ");
INSERT INTO pioNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Quéwanáta Jesús íimaca mamáalàacata: —‍Aibanáica níara idunùa nùwali. Núalíacawa nuchùnìaná wenàiwica nuíwitáise iyúwa cawinácaalí idunuèrica nùwali —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Néese úái inanáica uémìacani, yá úalíacawa càmita udé ubàacawa uináwanáwa Jesús íicha. Néese ùanàaca itatéechúawa icalùniwa, yá ubàlùacawa ùuluì ipùata iyúwa Jesús irí ùacaténá icàaluíniná. Yá ucàlidacani nàacuésemi macái níái ìyéeyéica néeni cáná yéewa udunùaca Jesús ìwali. Yá ucàlidaca nacái uchùnìanáwa udécanacáita udunùaca ibàle ìwali. ");
INSERT INTO pioNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Néese Jesús íimaca ulí: —‍Pía inanáica, pidéca pichùnìacawa pimàacacáiná piwàwawa nùwali. Pìawa matuíbanáita —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Idècunitàacáwa Jesús icàlidaca inanái iríni, yá áiba wenàiwica yàanàaca nàatalé, itéerica tàacáisi Jairo irí, yái judíonái yéewáidacàalu íiwacalica. Yá asìali íimaca Jairo irí: —‍Píidumica yéetáwa. Picá pisàiwica quirínama irí wawàsi, yái yéewáidéerica wenàiwica —‍íimaca. ");
INSERT INTO pioNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Quéwa, Jesús yéemìacani, yá íimaca Jairo irí: —‍Picá cáalu pía. Peebáidacáita nulí mamáalàacata, yásí cayábaca píidu àniwa —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Néese nàanàacaté Jairo icapèe néré, yá canácata Jesús imàaquéeri iwàlùacawa yáapicha. Níawamicata iwàlùacawa Jesús yáapicha, yái Pedro, Santiago nacái, Juan nacái, úanirimi nacái, úatúami nacái, úái sùmàu yéetéechúamicawa. ");
INSERT INTO pioNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Nàyaca capìi irìcu madécaná wenàiwica íicháaníiyéica báawanama yéetéechúamiwa íiwitáise, càide iyúwa judío íiwitáise ìyáaná. Quéwa Jesús yáalíacawa icáucàidáanápináté úa, íná Jesús íimaca nalí: —‍Càmita iwàwacutácué píicháaníca. Uái mànacàuca, càmíichúata yéetáwa. Uimácáita ùyaca —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Néese naicáaníca Jesús iquíniná, náalíacáináwa báisícata uétácatéwa. ");
INSERT INTO pioNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Néese Jesús íibàaca ucáapi ìwali úái yéetéechúamicawa. Yá íimaca ulí: —‍¡Pía, mànacàuca, pimichàawa! —‍íimaca ulí. ");
INSERT INTO pioNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Yáta uwàwa cáuri yèepùacawa uiná irìculé àniwa. Yáta upisìaca ubàlùacawa. Néese Jesús ichùulìaca nàaca uyáapiná. ");
INSERT INTO pioNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Néese usèenái náináidacawa naicáidaca ulí manuísíwata naicácáiná cáuca úa, quéwa casíimáica nawàwa manuísíwata. Jesústa quéwa yàalàaca nía ipíchaná nacàlidaca áibanái irí icáucàidacaté úa. ");
INSERT INTO pioNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Néeseté Jesús imáidaca yàataléwa níái doce namanùbaca yéewáidacalécawa. Yá imàaca nalí ichàiniwa náucacaténá macái demonio íiwitáaná wenàiwicanái íicha, náucacaténá nacái náicha macái uláicái. ");
INSERT INTO pioNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Jesús ibànùaca nía nacàlidacaténá wenàiwicanái irí càinácaalí iyú Dios icùaca yàasu wenàiwicawa, nachùnìacaténá nacái cáuláiquéeyéi. ");
INSERT INTO pioNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Jesús íimaca yéewáidacalénái iríwa: —‍Picácué peedá piríwa wàlisài àicu, saco nacái, yàacàsi nacái, iwèni nacái. Picácué pité pucháiba bàlesi. ");
INSERT INTO pioNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Pìacuéwa yàcalé irìculé, néese càiríinácaalícué capìi piwàlùawa irìculé, piimácué néenibàata, àta pèepùacatalétacuéwa yàcalé irìcuíse. ");
INSERT INTO pioNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Aibalé càmicaalícué nabatàa piwàlùacawa yàcalé irìculé, néese pìacuéwa íicha. Pichùpìacué cáli ichùmalé pìabàli íichawa naicápiná càide iyúwa judío íiwitáise ìyáaná, píasáidacaténácué nalí Dios yùuwichàidáanápiná nía —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Néese nàacawa Jesús íicha. Yá nàacawa macái yàcalé. Nacàlidaca nàacawa yái tàacáisica íiméerica Jesús iwàwaca iwasàaca wenàiwicanái Dios yàasu yùuwichàacáisi íicha. Nachùnìaca nàacawa cáuláiquéeyéi wenàiwica nacái. ");
INSERT INTO pioNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Néeseté rey Herodes yéemìaca abénaméeyéi wenàiwica icàlidaca Jesús iináwaná ìwali, macáita nacái Jesús imàníirica. Iná càmita Herodes yáalíawa íináidéeripináwa, máiní càulenáca íichani; abénaméeyéi wenàiwica náimacáiná Jesús ìwali Juan el Bautistamicani, náináidacawa Juanmi icáucàacatéwa. ");
INSERT INTO pioNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Aibanái nacái náimaca Jesús ìwali profeta Elíascani, yèepuèricasa yàanàaca àniwa; áibanái nacái náimaca Jesús ìwali bàaluisàimi profetanáimi yéenácani, imichèericasawa yéetácáisi íicha. ");
INSERT INTO pioNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Quéwa Herodes íimaca: —‍Nuchùulìacaté nùasu úwináiwa nawichùanápiná Juan íicha íiwita yéetácaténátéwa. ¿Cawinásica yáara asìalica nuémièrica nacàlidaca ìwali madécaná? —‍íimaca yái Herodesca. Ináté Herodes iwàwa iicáca Jesús. ");
INSERT INTO pioNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Néeseté apóstolnái nèepùacawa Jesús yàatalé àniwa, yá nacàlidaca Jesús irí ìwali yái namàníiricaté. Néese Jesús itéca nía méetàuculé áibanái wenàiwica íicha, Betsaida ìyacàlená néré. ");
INSERT INTO pioNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Quéwa madécaná wenàiwica yáalíacawa Jesús yàanàaná néré, yá nàacawa yàatalé. Jesús itàidaca nía cayába. Icàlidaca nalí càinácaalí iyú Dios icùaca yàasu wenàiwicanáiwa. Ichùnìa nacái cáuláiquéeyéi wenàiwica. ");
INSERT INTO pioNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Néese táicaca yàacawa, íná yéewáidacalénái doce namanùbaca nàacawa Jesús yàatalé, yá náimaca irí: —‍Pichùulìa wenàiwicanái nèepùanápináwa nacutácaténá naimácatáipiná, nayáacatáipiná nacái yàcalé irìculé, bànacalé ìyacatalé nacái ìyéeyéica mawiénita. Wàyacáiná chái canácatái wenàiwicanái iyáapiná —‍náimaca. ");
INSERT INTO pioNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Quéwa Jesús íimaca nalí: —‍Píatacué yàa nayáapiná —‍íimaca yái Jesúsca. Néese náimaca irí: —‍Canáca walí nayáapiná. Wadènìa cinco namanùbaca pan meedá, pucháiba cubái imìdecaná nacái. ¡Càmita wáalimá wàaca wawènìaca nayáapiná, níái madécanéeyéi wenàiwicaca! —‍náimaca. ");
INSERT INTO pioNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Nàyacáiná néeni cawàwanáta cinco mil namanùbaca asìanái. Càmita naputàa inanái, sùmanái nacái. Quéwa Jesús íimaca yéewáidacalénái iríwa: —‍Pichùulìacué náawinacawa cincuentanama nàwacaca náawinacawa —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Néese nachùulìaca cài nía, yá macáita náawinacawa. ");
INSERT INTO pioNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Néese Jesús yeedáca cinco namanùbaca pan icáapi irìculéwa, pucháiba cubái imìdecaná nacái. Yá iicáidaca chènuniré, yàaca Dios irí cayábéeri yàacàsi ìwali. Néese isubèriadaca nía, yàaca yéewáidacalénái iríwani, yéewacaténá nawacùaca yàacàsi wenàiwicanái irí. ");
INSERT INTO pioNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Néese macáita nayáaca cadénamani. Yá needáca doce namanùbaca mapíiri yàacàsi yéenáimi imàaquéericawa. ");
INSERT INTO pioNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Aiba èerité Jesús isutáca yáawawa Dios íicha méetàuculé wenàiwicanái íicha. Yéewáidacalénái nàyaca yáapicha. Yá isutáca yéemìawa nía: —‍¿Càiná náimaca nùwali níara áibanái wenàiwicaca? ¿Cawinása núa? —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Néese yéewáidacalénái íimaca irí: —‍Abénaméeyéi íimaca pìwali Juan el Bautistamicasa pía, náimacáiná Juanmi idécasa icáucàacawa. Aibanái íimaca profeta Elíascasa pía, yèepuèricasa yàanàaca àniwa, yái profeta Dios íiméericaté ìwali ibànùanápináté àniwani. Aibanái íimaca nacái pìwali bàaluisàimi profetanái yéenácasa pía, imichèericasawa yéetácáisi íicha, níái profetami itàaníiyéicaté Dios inùmalìcuíse —‍náimaca. ");
INSERT INTO pioNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Néese Jesús isutáca yéemìawa nía: —‍Néenicué pía, ¿càinácué nacái píimaca nùwali? ¿Cawiná núa? —‍íimaca yái Jesúsca. Yá Pedro íimaca irí: —‍Píacata yái Mesíasca, yái wacuèrinápiná Dios icàlidéericaté iináwaná ìwali wàawirináimi israelitanái irí, ibànùanápináté walí wacuèrinápiná —‍íimaca yái Pedroca. ");
INSERT INTO pioNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Quéwa Jesús yàalàaca nía cachàiníiri iyú ipíchaná nacàlidaca iináwaná áibanái irí, Mesíascani. ");
INSERT INTO pioNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Néese Jesús íimaca nalí: —‍Iwàwacutá nùuwichàacawa manuísíwata, núa asìali Dios néeséerica. Yá wenàiwica íiwacanánái, sacerdote íiwacanánái nacái, nía nacái yéewáidéeyéica wenàiwica templo irìcu, náucapiná náichawa núa iyúwa canéeri iwèni. Yá nanúapiná núawa, quéwa máisiba èeri irìcu nucáucàapináwa —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Néese Jesús íimaca nalí macáita wenàiwica ìyéeyéica néré: —‍Abéericaalí péenácué iwàwa yàacawa núapicha iyúwa nuéwáidacalé, càmita yéewa pimànica abéerita yái piwàwéerica pimànica. Macái èeri imanùbaca iwàwacutá matuíbanáiri iyú pimàaca áibanái yùuwichàidaca pía, éwita naicáanícaalí nacái piquíniná, éwita nanúacaalí píawa cruz ìwali peebáidacáiná nutàacái. Iwàwacutá nacái pimànica mamáalàacata càide iyúwa nuchùulìaná pía. ");
INSERT INTO pioNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Níacáiná cawinácaalí càmíiyéica iwàwa yeebáidaca nutàacái ipíchaná nàuwichàacawa nulípiná, canáca nalí nacáuca càmíiri imáalàawa. Néese cawinácaalí yeebáidéeyéica nutàacái mamáalàacata éwita áibanái inúacaalí nía, nadènìapiná nacáucawa càmíiri imáalàawa. ");
INSERT INTO pioNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Ewita wenàiwica yeedácaalí iríwa macáita chái èeri yàasu cawèníirica, quéwa yúuca íichawa icáucawa càmíiri imáalàawa càmicáiná yeebáida nutàacái, yá canéerica iwèni meedá iríni macáita yái cawèníirica yeedéerimica iríwa. ");
INSERT INTO pioNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Aibacaalí wenàiwica báica icàlidaca cayábéeri nùwali áibanái irí, nutàacái ìwali nacái, càmita núumapiná ìwali nùasu wenàiwicacani, núa asìali Dios néeséerica, nùanàacaalípiná áiba èeriwa cachàiníiri iyú nacamalá irìcu, yái Núaniri Dios, nía nacái mabáyawanéeyéi ángel, nucùacaténá macáita èeri mìnanái. ");
INSERT INTO pioNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Péemìacué cayába, abénaméeyéi péenácué ìyéeyéica chái siùca èeri, càmita néetápináwa ipíchawáise naicáca càinácaalí iyú Dios icùaca yàasu wenàiwicawa —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Néeseté abéeri semana natàanícadénáami cài, yáté Jesús yàacawa dúli íinatalé isutácaténá yáawawa Dios íicha. Máisiba asìanái nàacawéeridaca Jesús, yái Pedro, Santiago nacái, Juan nacái. ");
INSERT INTO pioNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Idècunitàacá Jesús isutáca Dios íicha, yá mèlumèluwaca inàni icànaca áibata iicácanáwa. Ibàle nacái cabalèeri icànaca, icànéeri mèlumèluwaca. ");
INSERT INTO pioNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Yá pucháiba asìanái namàacaca níawawa apóstolnái iicácaténá nía. Pucháiba nabàlùa natàaníca Jesús yáapicha, níacata profeta Moisés, profeta Elías nacái. ");
INSERT INTO pioNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Níái pucháiba asìanáica cacamalánáca nía chènuníiséeri camalási iyú. Natàaníca nalíwáaca Jesús yáapicha càinácaalí iyú Jesús yùuwichàanápinátéwa, yéetáanápináté nacáiwa Jerusalén ìyacàlená néeni. ");
INSERT INTO pioNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Ewita cadapùlecáaníta Pedro, nía nacái yàacawéeyéináca, càmitàacá máiní naimásíwaca, yá naicáca Jesús icamaláná chènuníiséerica. Naicá nacái níái pucháiba asìanáica ibàluèyéicawa yáapicha. ");
INSERT INTO pioNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Néese idécanáamité nàacawa Jesús íicha níái pucháiba asìanáica, yá Pedro íimaca Jesús irí: —‍Wáiwacali, ¡cayábéeriquéi wàyáanáca chái! Siùcata wamànica máisiba capìi yáana wawàwalíinápinácué pía, abéeri pìasupiná, áiba nacái Moisés irípiná, áiba nacái Elías irípiná —‍íimaca yái Pedroca. Quéwa Pedro càmita íináidawa cayába ipíchawáise itàaníca. ");
INSERT INTO pioNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Yá idècunitàacá Pedro itàaníca, yáta acalèe yàanàaca nàatalé. Yá acalèe ibàlìaca nía. Cáaluca nía manuísíwata acalèe yèewi, níái Pedronáica. ");
INSERT INTO pioNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Néese néemìaca Dios itàacái acalèe yèewíise, yá íimaca nalí: “Yácata Nuìri nuwàwéeri cáininéerica nuicáca. Cayábaca nuwàwa nuicácani. Péemìacué itàacái”, íimaca yái Diosca. ");
INSERT INTO pioNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Idécanáami néemìaca yái tàacáisica, yá naicáca Jesús ibàluèricawa néenibàa abéerita. Néese masànacata níái Pedronáica. Néenialíté càmíiyéi icàlida áibanái iríni, yái naiquéericaté. ");
INSERT INTO pioNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Néeseté mapisáináami àniwa idécanáami nalicùacawa dúli íinatáise, yá madécaná wenàiwica yàacawa náipunitáidacaténá Jesús. ");
INSERT INTO pioNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Yá áiba asìali ìyaca manùbéeyéi wenàiwica yèewi. Iimaca cachàiníiri iyú Jesús irí: —‍Pía, yéewáidéerica wía, pimàni nulí cayábéeri, pìa piicá nuìri, yácáináta abéerita nuìricani. ");
INSERT INTO pioNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Demonio idacùaca nuìri íiwitáise, yàaca irí tèwacáimi, yá imàaca yéemíanícawa, yá itatáidacani àta cacàlicataléta inùmalìcuíse. Imàaca nacái nuìri inúadáidaca yáawawa cachàiníiri iyú, càmíiri iwàwa iwasàaca nuìri. ");
INSERT INTO pioNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Nudéca nusutáca péewáidacalénái íicha wawàsi náucáanápiná demonio nuìri íicha, quéwa càmita náalimá nachùnìacani —‍íimaca. ");
INSERT INTO pioNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Yá Jesús íimaca: —‍¡Píacué càmíiyéica yeebáida Dios ìwali, báawéeyéi nacái íiwitáise meedá! ¿Càinácué èeri iwàwacutá nùyacuéca píapicha quiríta? ¿Càinácué èeri iwàwacutá numànicuéca pirí quiríta? —‍íimaca yái Jesúsca. Yá Jesús íimaca asìali irí: —‍Pìanàida cháni, yái pìirica —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Yái ùuculìiri yàacawa Jesús yàatalé, yá demonio yúucaca ùuculìiri cáli íinatalé itatáidacani. Quéwa Jesús yàalàaca demonio cachàiníiri iyú, ichùulìaca demonio yàacawa ùuculìiri íicha. Càita Jesús ichùnìaca yái ùuculìirica, yèepùadacani yáaniri iríwa nacái. ");
INSERT INTO pioNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Yá macáita ìyéeyéica néeni náináidacawa manuísíwata naicáidaca Jesús irí idènìacáiná Dios íiwitáise manuíri. Macáita ìyéeyéica néré náináidacawa manuísíwata naicáidaca Jesús irí mamáalàacata, natàaníca nàyaca náapichawáaca ìwali yái Jesús imàníirica, quéwa Jesús itàanícaté yéewáidacalénái yáapichawa méetàucuta wenàiwicanái íicha. Iimaca nalí: ");
INSERT INTO pioNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","—‍Péemìacué cayábani, picácué piimáichani: Abénaméeyéi wenàiwica presopináca namànica núawa namàacacaténá áibanái asìanái inúaca núa, núa asìali Dios néeséerica —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Càmita quéwa náalía néemìaca càinácaalí íimáaná yái tàacáisica Jesús icàlidéerica nalí càmicáiná Dios imàaca náalíaca néemìaca càinácaalí íimáaná. Yá cáaluca nasutáca Jesús íicha wawàsi icàlidáanápiná nalíni càinácaalí íimáaná. ");
INSERT INTO pioNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Néenialíté Jesús yéewáidacalénái nadàbaca natàaníca náapichawáaca ùuléeri wawàsi iyú, chánácaalí néená máiníiri cachàini áibanái íicha canánama. ");
INSERT INTO pioNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Quéwa Jesús yáalíacawa náináidáanáwa. Yá yeedáca sùmài, yá ibàlùadaca sùmài mawiénita iríwa. ");
INSERT INTO pioNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Yá Jesús íimaca nalí: —‍Pimànicaalí cayábéeri nuípidená ìwali sùmài irí, càiride iyúwa yái sùmàica peebáidacáiná nutàacái, yásí nuicáca yái cayábéerica pimàníirica sùmài irí càide iyúwa pidéca nacáicaalí pimànica nulí cayábéeri. Càmita pimàni abéerita nulí cayábéeri, néese pimànica nacái irí cayábéeri yái Diosca ibànuèrica núa. Yái péená piiquéericuéca càiride iyúwa càmíiri cachàini náicha canánama càide iyúwa yái sùmàica, yácata Dios iiquéerica càiride iyúwa máiníiri cachàinica náicha canánama níái péenáca. Iná yéewa yái cayábéerica pimàníiricuéca sùmài irí càmíiri cachàini náicha canánama, yá nuicápiná càinide iyúwa pidéca nacáicaalí pimànica nulíni, yái cayábéerica —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Néese Juan íimaca Jesús irí: —‍Wáiwacali, wadéca waicáca áiba asìali yúuquéeri demonio wenàiwica íicha píipidená ìwali íimacáiná pimàacasa cài imànica, quéwa càmita yèepuníwa wáapicha, íná wadéca wàalàacani cachàiníiri iyú ipíchaná yúucaca demonio wenàiwica íicha —‍íimaca yái Juanca. ");
INSERT INTO pioNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Néese Jesús íimaca nalí: —‍Picácué pichùulìa càmíinápiná imàni cayábéeri, macáicáiná càmíiyéica yùuwide imànica wía, nayúudàaca wía —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Mawiénicaté Jesús yéenáiwaná yàanàaca imichàacatáipinátéwa chènuniré, ínáté Jesús íináidacawa iwàwalìcuísewa yàanápináwa Jerusalén ìyacàlená nérépiná. ");
INSERT INTO pioNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Yá ibànùaca ipíchaléwa tàacáisi asìanái yáapicha. Yá nawàlùacawa yàcalé irìculé Samaria yàasu cáli íinata nacutácaténá irí naimácatáipiná. ");
INSERT INTO pioNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Quéwa, báawaca samaritanonái iicáca judíonái íná níái samaritanoca càmita nabatàa Jesús iwàlùacawa nàyacàle irìculé náalíacáináwa Jesús yàanápinátéwa Jerusalén ìyacàlená nérépiná. ");
INSERT INTO pioNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Néese Jesús yéewáidacalénái Santiago, Juan nacái néemìacani, yá náimaca Jesús irí: —‍Wáiwacali, ¿piwàwasica wachùulìaca quichái yúuwàanápináwa chènuníise nàwali imáalàidacaténá nía càide iyúwaté profeta Elías imáidáanáté quichái yúuwàanápináwa chènuníise imáalàidacaténáté báawéeyéi wenàiwica? —‍náimaca. ");
INSERT INTO pioNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Quéwa Jesús iwènúa iicáidaca nalí, yá yàalàaca nía cachàiníiri iyú. Yá íimaca nalí: —‍Càmitacué píináidawa càide iyúwa Dios iwàwáaná. ");
INSERT INTO pioNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Càmita nuwàwa nùuwichàidaca nía, núa asìali Dios néeséerica, càmicáiná nùanàa numáalàidacaténá wenàiwicanái, néese nùanàaca nuwasàacaténá nía Dios yàasu yùuwichàacáisi íicha —‍íimaca yái Jesúsca. Néese nàacawa áiba yàcalé irìculé. ");
INSERT INTO pioNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Idècunitàacá nèepunícawa àyapulìcubàa, áiba asìali íimaca Jesús irí: —‍Nuíwacali, nuwàwa nùacawa píapicha àta alénácaalí pìawa yéewacaténá péewáidacaléca núa —‍íimaca. ");
INSERT INTO pioNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Jesús íimaca irí: —‍Píináidawa cayába quéechacáwa asáisí píalimácaalí nuéwáidacaléca pía, càulenácáiná wenàiwica nàyaca càide iyúwa nùyáaná. Péemìa comparación: Yàlidunái idènìaca ibànawa, cuìpìranái nacái nadènìaca namùlubèwa, núacata quéwa, yái asìali Dios néeséerica, càmita nudènìa nuimácatáipináwa —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Néese Jesús íimaca áiba irí: —‍Pìawa núapicha, iyúwa nuéwáidacalé —‍íimaca yái Jesúsca. Quéwa yái asìali íimaca Jesús irí: —‍Nuíwacali, pimàaca nùyaca nuénánái yáapichawa àta núaniri yéetácatalépinátawa, néese idécanáami nubàlìacani, yásí nùacawa píapicha iyúwa péewáidacalé —‍íimaca irí. ");
INSERT INTO pioNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Néese Jesús íimaca irí: —‍Pimàaca nabàlìaca níawáacata, cawinácaalí ìyéeyéica matuíbanáita Dios íicha. Píata quéwa, pìa picàlidaca Dios itàacái wenàiwicanái irí náalíacaténáwa càinácaalí iyú Dios icùaca yàasu wenàiwicawa —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Néese áiba íimaca Jesús irí: —‍Nuíwacali, nuwàwa nùacawa píapicha iyúwa péewáidacalé. Quéwa pimàni nulí cayábéeri, pimàacaca nuèpùacawa quéechacáwa nucapèe néréwa, nucàlidacaténá nùanáwa nuénánái iríwa. Yásí nùacawa néese nùacaténáwa píapicha —‍íimaca irí. ");
INSERT INTO pioNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Néese Jesús íimaca irí: —‍Péemìa comparación: Aibacaalí idàbaca íibaidaca ibànacale yàalunápináwa, néese íináidacaalíwa imàníinápiná áiba wawàsi, yá iwènúacawa íibaidacalé íichawa, yásí canéerica iwèni meedáni yái wenàiwicaca, càmita íibaida machacàníiri iyú. Càita nacái cawinácaalí wenàiwica iwènuéyéicawa nuícha idécanáami nadàbaca náibaidaca nulípiná, canáca yéewanáwa Dios yéenibeca nía, Dios icùacaténá nía —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Néeseté Wáiwacali yeedáca yéewáidacalénáiwa áibanái setenta y dos namanùbaca. Yá ibànùaca nía ipíchaléwa pucháibanamata. Yá ibànùaca nía nàacaténáwa macái yàcalé irìculé, wenàiwicanái ìyacatái nacái, níái yàcaléca iwàwacutácataléca Jesús ipáchiaca. ");
INSERT INTO pioNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Yá íimaca yéewáidacalénái iríwa: “Báisíta, madécaná wenàiwica nawàwa neebáidaca nutàacái. Péemìacué comparación. Càica níade iyúwa bànacalé ituíná yàasu èeri yàanàacaalí wenàiwica needácatáipiná nabànacale ìyacanáwa, quéwa máisibáanatacué pía, icàlidéeyéipiná nalí nutàacái. Iná pisutácué Dios íicha, yái càiride iyúwa bànacalé íiwacali, ibànùanápiná yàasu wenàiwicawa íibaidéeyéipiná irí, nacàlidacaténá nalí nuináwaná ìwali, yéewacaténá neebáidaca nutàacái, yásí wàwacáidaca nía Dios yàasunáipiná, càide iyúwa wenàiwica yeedácaalí bànacalé ìyacaná quíiracaalíni. ");
INSERT INTO pioNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Pìacuéwa. Péemìacué cayába áiba comparación: Nubànùacué pía èeri mìnanái yèewiré cuwèesi lobo nacáiyéi íiwitáise, báawéeyéica iicáca Dios. Càicuéca píade nèewi iyúwa ovejanái yéenibe, càmíiyéica yáalimá ipéliaca caluéyéi cuwèesi lobo íipunita iwàwéeyéica iyáaca oveja yéenibe. ");
INSERT INTO pioNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Picácué pité saco, moneda yàalu nacái, áiba pìasu costizapiná nacáiwa. Pìacàatétacuéwa, picácué piyamáa pibàlùacawa déecuíri iyú àyapulìcubàa pitàanícaténá áibanái yáapicha. ");
INSERT INTO pioNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Piwàlùacuéwa nacapèe irìculé, yá pitàidacué nía quéechacáwa. Càicué píimaca nalíwa: ‘¡Nusutáca Dios íicha imàníinápinácué pirí cayábéeri, píacué ìyéeyéica capìi irìcu!’ càicué pitàidaca níawa. ");
INSERT INTO pioNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Cayábacaalí náiwitáise níái capìi irìcuíyéica, yásí Dios imànica nalíwa cayábéeri càide iyúwacué pisutáaná íicha. Quéwa, càmicaalí cayába náiwitáise, néese Dios càmita imànipiná nalí cayábéeri. ");
INSERT INTO pioNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Piimácué nacapèe irìcu. Piyáacué nacái piyáacaléwa náapicha àta càiríinácaalí yàacàsi nadènièrica nawacùacaténácué pìasu, yácáiná cawinácaalí wenàiwica íibaidéerica, iwàwacutá namàacaca yeedáca iríwa íibaidacalé iwèniwa. Picácué pichàbawa áibanái icapèe irìculé, picutácaténácué cayábéeri yáwanái yàacàsi, pìyacatáipiná nacái. ");
INSERT INTO pioNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Pìacuéwa áiba yàcalé irìculé, needácatalécué nàataléwa pía, yá piyáacué piyáacaléwa náapicha àta càiríinácaalícué yàacàsi nèerica piyáapiná. ");
INSERT INTO pioNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Pichùnìacué nacái cáuláiquéeyéi wenàiwica ìyéeyéica néenibàa. Càicué píimaca nalíwa: ‘Dios icùaca wenàiwica ìyéeyéica mawiénita pirícué’, càicué píimaca nalíwa. ");
INSERT INTO pioNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Quéwa, pìanàacaalícué áiba yàcalé irìculé, néese càmita nawàwa néemìaca pitàacái, pimusúacuéwa capìi irìcuíse calle irìculé. ");
INSERT INTO pioNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","Yá píimacué nalí: ‘¡Càmita wawàwa wàyaca píapichacué, ipíchaná Dios yàasu yùuwichàacáisi yàanàaca wàwali nacái! ¡Iná wàacuécawa píicha, wachùpìaca cáli ichùmalé wàabàli íichawa, yái pìyacàle yàasu calle ichùmaléca, càide iyúwacué wáiwitáise ìyáaná, wía judíoca, wáasáidacaténácué pirí Dios yùuwichàidáanápinácué píawa! Quéwa péemìacué cayába quiríta, Dios icùaca wenàiwica ìyéeyéica mawiénita pirícué’, càicué píimaca nalíwa. ");
INSERT INTO pioNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Núumacué pirí, èeri imáalàacaalípináwa, Dios yùuwichàidapiná báawéeyéi wenàiwica, yásí yùuwichàidapiná níawa càmíiyéicué yeedáca yàataléwa pía máiní yáwanái Sodoma ìyacàlená mìnanáimi íicha”, íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Jesús íimaca: “¡Máinícué piùwichàapinácawa, píacué israelitaca ìyéeyéica Corazín ìyacàlená irìcu, Betsaida ìyacàlená irìcu nacái! Ewitacué piicácáaníta numànica pèewibàa madécaná yái càmíirica wenàiwica idé imànica, càicáanítacué càmita piwènúada píiwitáisewa pibáyawaná íichacuéwa. Piyúunáidacuéca máiníiyéica cayábaca pía náicha níara càmíiyéica israelitami ìyéeyéicaté Tiro ìyacàlená irìcu, Sidón ìyacàlená irìcu nacái, ìyéeyéica méetàuculé Israel yàasu cáli íicha. Quéwa càmitaté máiní báawaca nía píichacué. Càmitaté naicá áiba imànica nèewibàa càide iyúwa numàníiná pèewibàa. Quéwa naicácaalíté càiritá, yá nawènúadacaté náiwitáisewatá caquialéta Dios irípinátá, càmicáináté máiní báawéeyéica nía iyúwacué pía, càita nacái nàwalica nabàlesíamiwa báawéeri iicácanáwatá, náawinaca nacáiwa catáli yèewirétá náasáidacaténáté achúmaca nawàwa nabáyawaná ìwaliwatá. ");
INSERT INTO pioNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Quéwa áiba èeriwa Dios yùuwichàidapiná báawéeyéi wenàiwica, yásí piùwichàapinácuéwa máiní cachàiníwanái náicha níara càmíiyéica israelita ìyéeyéicaté Tiro ìyacàlená irìcu, Sidón ìyacàlená irìcu nacái, máinícáinácué báawéeyéica náicha pía. ");
INSERT INTO pioNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Píacué nacái Capernaum ìyacàlená mìnanáica, piyúunáidacuéca máinípiná cáimiétacanáca pía, càide iyúwa Dios ìyáaná chènuniré. ¡Càmíirita! ¡Néese Dios yúucapinácué píawa irìculé yáara utàwi máiníiri depuíwaca, máinícatalé depuíwaca náicha canánama!” cài yàalàaca nía cachàiníiri iyú yái Jesúsca, càmicáináté neebáida itàacái. ");
INSERT INTO pioNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Néese Jesús íimaca yéewáidacalénái iríwa: “Cawinácaalí yeebéeyéicuéca pitàacái, nuicápiná níawa càide iyúwa nadéca nacáicaalí neebáidaca nutàacái. Quéwa cawinácaalí iiquéeyéicuéca pía iyúwa canéeri iwèni, nuicápiná níawa càide iyúwa nadéca nacáicaalí naicáca núa càiride iyúwa canéeri iwèni nacái. Cawinácaalí iiquéeyéica núa càiride iyúwa canéeri iwèni, Dios iicápiná níawa càide iyúwa nadéca nacáicaalí caná iwèni naicáca Dios, yái Dios ibànuèrica núa”, íimaca yái Jesúsca. Néese níái setenta y dos namanùbaca nàaca nacàlidaca Jesús iináwaná ìwali wenàiwicanái irí. ");
INSERT INTO pioNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Néeseté idécanáami nacàlidaca wenàiwicanái iríni, yáté Jesús yéewáidacalénái setenta y dos namanùbaca nèepùacawa Jesús yàatalé, casíimáica nawàwa manuísíwata. Yá náimaca irí: —‍¡Wáiwacali, Dios idéca iyúudàaca wía manuísíwata, imàacacaté nacái demonio yàacawa wenàiwicanái íicha, wachùulìacáináté demonio píipidená ìwali nàanápináwa wenàiwica íicha! —‍náimaca. ");
INSERT INTO pioNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Jesús íimaca nalí: —‍Núalíacatéwa pimawènìadáanápinácué Satanás, piúcacaténácué yàasu demonionái wenàiwica íicha, bàaluitécáiná nuicáca Satanás icaláacawa chènuníise càide iyúwa énu icamaláná icaláanáwa Dios yúucacáináté Satanás chènuníise. ");
INSERT INTO pioNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Nudéca nuchàiniadacuéca pía, píalimáanápinácué pìipìnaca àapi íinatabàa, chália íinatabàa nacái, canátacué picháuná. Nudéca nuchàiniadacuéca pía pimawènìadáanápiná macáita wàuwidesàiri Satanás ichàini macháunéeri iyú. ");
INSERT INTO pioNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Quéwa, picácué piyanídawa ìwali yái píalimáanáca piúcaca demonio wenàiwica íicha. Néese, piyanídacuéwa Dios itànàacáináté píipidená yàasu cuyàluta irìcuwa yái cuyàluta ìyéerica chènuniré —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Yáté Espíritu Santo imàacaca casíimáica Jesús iwàwa manuísíwata. Jesús íimaca Dios irí: “Pía, Núaniri Dios, nùaca pirí cayábéeri, pía Nacuèrinásàirica macáita ìyéeyéica chènuniré, chái èeri irìcuíyéica nacái. Nùaca pirí cayábéeri pimàacacáiná nalí píiwitáisewa, níái yeebáidéeyéica pitàacái càide iyúwa púubéeyéi sùmanái neebáidáaná, yéewanápiná áibanái èeri mìnanái iyúunáidéeyéi cáalíacáica, càmita náalimá náalíacawa píiwitáise ìwali. Báisíta, Núaniri, pidéca pimànica càide iyúwaté piwàwáaná pimànica”, íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Néese Jesús íimaca wenàiwicanái irí: “Núaniri Dios idéca imàacaca núalíacawa macáita. Abéerita Núaniri yáaliéri báisíiri iyú nùwali, yái Iirica. Abéerita núa, yái Iirica, yáaliéri báisíiri iyú Núaniri ìwali, níawamita nacái cawinácaalí wenàiwicanái numàaquéeyéica yáalíaca Núaniri ìwali, càide iyúwa nuwàwáaná, yái Iirica”, íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Néesecáwa Jesús iwènúacawa, icàlidaca yéewáidacalénái iríwani, méetàucuta áibanái íicha. Jesús íimaca nalí: “Dios idéca imànicuéca pirí cayábéeri manuísíwata, imàacacáinácué piicáca yái numàníirica. ");
INSERT INTO pioNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Péemìacué cayába, bàaluité madécaná profetanái, madécaná nacái nacuèrinánái nawàwacaté naicáca yái piiquéericuéca, quéwa càmitaté naicáni. Nawàwacaté néemìaca yái péemièricuéca, quéwa càmitaté néemìani”, íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Néese ìyacaté abéeri yéewáidéeri wenàiwica templo irìcu. Yá yàacawa Jesús yàatalé itàanícaténá yáapicha, yáalimáidacaténá iicáwa Jesús. Yá íimaca Jesús irí: —‍Pía, yéewáidéerica wenàiwica, ¿càinásica iwàwacutá numànica nùyacaténá càiripináta Dios yáapicha chènuniré? —‍íimaca. ");
INSERT INTO pioNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Néese Jesús íimaca irí: —‍Pidéca piléeca Dios itàacái profeta Moisés itànèericaté Dios inùmalìcuíse. Picàlidaca nulí càinácaalí íimaca yáara —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Yái yéewáidéerica wenàiwica templo irìcu íimaca: —‍Yái tàacáisi Moisés itànèericaté, cài íimaca: “Iwàwacutá cáinináca piicáca Picuèriná Dios macái piwàwalìcuísewa, macái picáuca iyú nacáiwa, macái pichàini iyú nacáiwa, macáita píiwitáise iyú nacáiwa. Iwàwacutá nacái cáinináca piicáca áibanái wenàiwica càide iyúwa cáinináaná piicáca píawawa”, íimaca yái tàacáisi Moisés itànèericaté —‍íimaca yái yéewáidéerica wenàiwica. ");
INSERT INTO pioNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Néese Jesús íimaca irí: —‍Pidéca picàlidaca cayábani. Pimànicaalí mamáalàacata càide iyúwa yái tàacáisica íimáaná, yá pidènìapiná picáucawa càmíiri imáalàawa —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Néese quéwa yái yéewáidéerica wenàiwica templo irìcu iwàwacaté cayábaca áibanái iicácani, níái áibanái wenàiwicaca ìyéeyéica néeni. Iná isutáca yéemìawa Jesús: —‍¿Néeni, cawinásica níara áibanái wenàiwicaca iwàwacutéeyéicasa cáinináca nuicáca? —‍íimaca. ");
INSERT INTO pioNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Iná Jesús icàlidaca iríni comparación iyú. Jesús íimaca irí: “Abéeri asìali judío yàacatéwa àyapulìcubàa Jerusalén ìyacàlená íicha yàanàacaténá Jericó ìyacàlená néréwa. Néese quéwa abénaméeyéi cayéedéeyéi náibàacani. Yá namelùdaca íicha yàasu macáita, ibàle nacái macáita. Yá nacapèedáidacani báawanama. Yá nàacawa íicha, namàacaca batéwéeri yéetácawa, yái judíoca. ");
INSERT INTO pioNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Néesecáwa àniwa áiba judíosàiri sacerdote yàanàaca irìcu yái àyapuca àniwa. Quéwa idécanacáita iicáca inacáiriwa judíoca, yái asìalica máiníirica, yá sacerdote ichàbaca yàacawa íicha déecubàata abéemàabàa àyapu íicha. ");
INSERT INTO pioNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Càita nacái áiba judíosàiri levita íibaidéerica templo irìcu yàanàaca néré, yá iicácani, yái inacáiricawa judíoca máiníirica, néese levita ichàbaca yàacawa abéemàabàa àyapu íicha. ");
INSERT INTO pioNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Néese áiba asìali Samaria yàasu cáli néeséeri, abéeri néená níái wenàiwicaca judíonái iiquéeyéi iyúwa báawéeyéi, yácata càmíiri judío yàacawa nacái irìcubàa yái àyapuca. Yái asìalica samaritanosàiri iicáca judío máiníirica, yá catúulécanáca iicácani. ");
INSERT INTO pioNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Yá yàacawa máiníiri yàatalé. Yá idèpìaca íicha icháuná olivo iséená iyú, uva ituní iyú nacái, dabé nacáirica. Yá ibàlìaca icháuná wáluma iyú. Néese samaritanosàiri imichàidacani ipìra íinataléwa. Yá itécani áiba capìi néré, naimácatáipiná. Yá icùacani táiyápinama. ");
INSERT INTO pioNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Néese mapisáináami àniwa, yái Samaria yàasu cáli néeséerica ipáyaidaca capìi íiwacali pucháiba moneda dracma iyú, cawèníiyéi yáawami plata quírameníiri, pucháiba èeri iwènicatáica. Yá samaritanosàiri íimaca capìi íiwacali irí: ‘Picùa cayába yái máiníirica. Piúcacaalí plata mamáalàacata íicha yái nuèrica pirí picùanápinátani, yásí nupáyaidaca pía àniwa yái piúquéerica nùanàacatáipináta àniwa’, íimaca yái Samaria yàasu cáli néeséerica”, íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Néese Jesús íimaca irí yái yéewáidéerica wenàiwica: —‍Máisiba asìanái iicáca yái máiníirica asìalica àyapulìcubàa. ¿Chánácaalí néená cáinináca iicáca áiba wenàiwica, yái asìali cayéedéeyéi imàníirica irí báawéeri? —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Néese yái yéewáidéerica wenàiwica íimaca Jesús irí: —‍Yáara asìalica iiquéericaté ipualé —‍íimaca. Néese Jesús íimaca irí: —‍Pìawa, pimàni mamáalàacata càita, áibanái irí nacái càmíiyéica péenánái —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Néeseté Jesús yèepùa yèepunícawa àniwa yéewáidacalénái yáapichawa. Yá nàanàaca áiba yàcalé irìculé. Inanái ùyacaté néré íipidenéechúa Marta. Uedáca nía ucapèe irìculéwa, ùacaténá nayáapiná uénánái yáapichawa. ");
INSERT INTO pioNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Marta idènìaca yùuchawa íipidenéechúa María. Uái Maríaca úawinacawa mawiénita Jesús yàabàli irí uémìacaténá yéewáidáaná yéewáidacalénáiwa. ");
INSERT INTO pioNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Martata quéwa máiní càulenáca úa, uíbaidacáiná nayáacalé. Máadáiní uíbaidaca nayáapiná. Néese ùacawa Jesús yàatalé. Yá úumaca irí: —‍Nuíwacali, ¿cáná pibatàa nùucha umàaca nuíbaidaca nulínáamitawa macáita wayáapiná? Pichùulìa uyúudàanápiná núa —‍úumaca úái Martaca. ");
INSERT INTO pioNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Quéwa Jesús íimaca ulí: —‍Marta, péemìa cayába, ¿cáná máiní maséeca píináidacawa piwàwawa, achúma nacái piwàwa manùba wawàsi ìwalíise? ");
INSERT INTO pioNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Iyaca abéerita wawàsi iwàwacutéeriwa wenàiwicanái irí, yái nutàacáica. Piùcha María udéca uínáidacawa uémìanápiná yái nutàacáica, cayábéeri áiba wawàsi íicha canánama. Canácata yáaliméeri yeedáca uíchani —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Aiba èerité Jesús ìyaca áibalé, yá isutáca yáawawa Dios íicha. Idécanáami isutáca Dios íicha, néese abéeri yéewáidacalé íimaca irí: —‍Wáiwacali, péewáida wía wasutáanápiná Dios íicha càide iyúwaté Juan el Bautista yéewáidáanáté yéewáidacalénáiwa nasutáanápináté Dios. ");
INSERT INTO pioNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Jesús íimaca nalí: —‍Pisutácué Dios íicha, yá càicué píimaca pisutácawa: ‘Pía, Wáaniri Dios chènuníiséeri, pimàaca macái wenàiwica yàaca picàaluíniná. Pimàaca péenáiwaná yàanàaca caquialéta yái èerica pidàbacatáipináta picùaca macáita. Pimàaca èeri mìnanái namànica càide iyúwa piwàwáaná chái èeri irìcu càide iyúwa neebáidáaná pitàacái, níara ìyéeyéica chènuniré. ");
INSERT INTO pioNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Pìa wayáapiná wamáapuèrica èeri imanùbaca. ");
INSERT INTO pioNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Pimàaca piwàwawa wabáyawaná íicha, wíacáiná nacái wamàacaca wawàwawa nabáyawaná íicha cawinácaalí imàníiyéica walí báawéeri. Picá pimàaca áibanái yáalimáidaca wía ipíchaná wamànica wabáyawanáwa, néese piwasàa wía báawéeri Satanás íicha’, càicué píimaca Dios iríwa”, íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","6","Jesús íima nacái yéewáidacalénái iríwa: —‍Péemìacué comparación: Aiba asìali idènìaca yàacawéerináwa, yá yàanàaca icapèe néré catá bamuchúami. Yá isutáca íicha mamáalàacata: ‘Pía nùacawéeriná, pìa nuchàba máisiba pan yácáiná áiba nùacawéeriná idéca yàanàaca nucapèe néré, idéca yàacawa déecuíse. Canáca nulí nuèripiná iyáapiná’, íimaca irí. ");
INSERT INTO pioNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Néese yái ìyéerica capìi irìcu càmita íima irí: ‘Picá pisàiwica nulí wawàsi. Nudéca nubàlìaca capìi inùma. Nuénibe nadéca nacùacawa, waimácaténá íná càmita núalimá numichàacawa nùacaténá pirí quirínamatani’, càmita cài íima irí. ");
INSERT INTO pioNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Néese núumacué pirí, éwita càmicáaníta imichàawa yàacaténá iríni yàacawéerinácáanítani, càicáaníta yàaca irí macáita yái imáapuèrica, isutácáiná íicha mamáalàacata cachàiníiri iyú. ");
INSERT INTO pioNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Càita nacái núumacué pirí: Pisutácué mamáalàacata Dios íicha, yásí imànicuéca piríwani. Càide iyúwa comparación íimáaná, picutácué mamáalàacatani, yásí pìanàacuécani. Pimáidacué mamáalàacata capìi inùma néeni, yásí yàacùacuéca piríwani. ");
INSERT INTO pioNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Yácáiná cawinácaalí isutéerica mamáalàacata, yeedápináca iríwani. Cawinácaalí icutéerica mamáalàacatani, yàanàapinácani. Cawinácaalí imáidéerica mamáalàacata capìi inùma néeni, nàacùaca iríni. Càita nacái cawinácaalí isutéerica mamáalàacata Dios íicha, Dios imànica iríwa càide iyúwa isutáaná. ");
INSERT INTO pioNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Péemìacué comparación: Pidènìacaalícué pìiriwa, càmitacué pìa irí íba isutácaalí píicha pan iyáapináwa. Càmitacué pìa iyáapiná àapi isutácaalí píicha cubái. ");
INSERT INTO pioNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Càmitacué pìa iyáapiná chália isutácaalí píicha cawámai yéewé. ");
INSERT INTO pioNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Ewitacué báawéeyéicáaníta íiwitáiseca pía, càicáaníta cáininácuéca piicáca péenibewa, píalimácué nacái pìaca nalí cayábéeri wawàsi. Néeni, ¿càmitasicué píalíawa cayábáaná íiwitáise yái Wáaniri Dios chènuníiséerica? ¡Iná iwàwacutácué píalíacawa Dios ibànùanápiná nalí Espíritu Santo, cawinácaalí isutéeyéica Dios íichani! —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Aiba èerité Jesús yúucaca demonio asìali íicha. Yái demonio matàacáica imànicaté asìali. Néese demonio yàacadénáamiwa asìali íicha, yáta asìali yáalimá itàaníca àniwa. Níái wenàiwica ìyéeyéica néeni náináidacawa manuísíwata naicáidaca Jesús irí ìwalíise yái imàníináca. ");
INSERT INTO pioNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Quéwa abénaméeyéi náimaca: “Yái asìali Jesúsca idènìaca Beelzebú íiwitáise, yái demonio íiwacalináca. Iná yéewa Jesús yúucaca demonio wenàiwica íicha Beelzebú íiwitáise iyú”, náimaca Jesús ìwali. ");
INSERT INTO pioNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Aibanái nawàwa náalimáidaca naicáwa Jesús asáisí idènìacaalí Dios íiwitáise, íná nasutáca íicha imàníinápiná yái càmíirica wenàiwica idé imànica. ");
INSERT INTO pioNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Yá Jesús yáalíacawa náináidáanáwa nawàwáaná náalimáidaca naicáwani. Yá íimaca nalí: “Péemìacué comparación: Wenàiwicanái ipéliacaalí íipunitawáaca, yásí nàasu cáli imáalàacawa. Néese àniwa áibanái néenánái napéliacaalí náipunitawáaca, càmita náalimá nàyaca abéeri capìi irìcu. ");
INSERT INTO pioNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Càita nacái Satanás yàasu demonionái napéliacaalí náipunitawáacatá, néese càmita yáalimá cachàini Satanás quirínamatá. Càicuéca núumaca pirí píimacáinácué nùwali núucáanása demonio wenàiwica íicha Beelzebú íiwitáise iyú, yái demonio íiwacalináca. ");
INSERT INTO pioNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Quéwa picháawàacaalícué nuináwaná ìwali mamáalàacata núucáanása demonio wenàiwica íicha Beelzebú íiwitáise iyú, néese iwàwacutácué picàlidaca nulí cawinácaalí ichàini iyú péewáidacalénáicué yúucaca demonio wenàiwica íicha. Píalíacawa càmita náuca demonio Beelzebú íiwitáise iyú. Iná péewáidacalénái nadéca náasáidaca càmitacué picàlida nuináwaná ìwali báisíiri iyú. ");
INSERT INTO pioNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Nudéca núucaca demonio wenàiwica íicha Dios íiwitáise iyú. Iná nudéca núasáidacuéca pirí Dios icùaná abéechúanaméeyéi wenàiwica pèewibàa. ");
INSERT INTO pioNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","22","“Núucaca demonio wenàiwica íicha nuíwitáise iyúwa, cachàinicáiná núa Satanás íicha. Péemìacué comparación: Cachàinicaalí asìali, idènìacaalí cayába icáapisàiwa, yásí icùaca icapèewa cachàiníiri iyú, yàasu nacáiwa ìyéerica icapèe irìcu, ipíchaná cayéedéeri yàanàaca imelùdacaténá íichani. Quéwa cawàwanáta áiba asìali yàanàaca cachàiníirica capìi íiwacali íicha, néese imawènìadaca íichawa capìi íiwacali, yásí imelùdaca íicha icáapisàimi, yàasumi nacái yàacaténá yáapichéeyéi iríwani. Càita nacái Satanás idacùaca wenàiwica íiwitáise, cachàiníiri iyú ipíchaná namusúacawa íicha. Quéwa núata iwasàaca wenàiwica Satanás íicha cachàinicáiná núa Satanás íicha. ");
INSERT INTO pioNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Píacué càmíiyéica abédanama íiwitáise núapicha, piùwidecuéca pimànica núa; càmitacué piyúudàa nùwacáidaca wenàiwica Dios irípiná, néese piyúudàacuéca Satanás iméeràidacaténá wenàiwica Dios íicha meedá”, íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Jesús íimaca nalí: “Demonio yàacaalíwa wenàiwica íicha, yásí demonio iméeràacawa chuìri cáli íinata, yá icutáca iyamáacatáipináwa. Càmicaalí demonio yàanàa iyamáacatáipináwa, néese íimaca íináidacawa iríwa: ‘Nuèpùacawa àniwa nucapèe néréwa yáara wenàiwicaca nùacatáisecatéwa íicha’, íimaca iríwa yái demonioca. ");
INSERT INTO pioNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Néese demonio yèepùacawa àniwa, yásí demonio yàanàaca wenàiwica cáiwitáiséeri càide iyúwa cayábéeri capìi natunuérica, nachùnièrica nacái cayába. ");
INSERT INTO pioNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Néese demonio yàaca ìwacáidaca yáapichawa siete namanùbaca demonio máiníiyéi báawaca íicha. Néese macáita nawàlùacawa wenàiwica iwàwalìculé nadacùacaténá íiwitáise. Yásí namànica wenàiwica irí báawéeri máiní íicha yái idàbáanéerica demonio imàníiricaté irí quéechacáwa”, íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Idècunitàacá Jesús icàlidaca nalíni, yá abéechúa inanái úumaca cachàiníiri iyú: —‍¡Casíimáica pìwali úara inanáica imàaquéechúacaté pimusúaca piicá èeri, úara idàwinèechúacaté pía! —‍úumaca. ");
INSERT INTO pioNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Quéwa Jesús íimaca ulí: —‍¡Báisíta, quéwa cachàini yáwanái casíimáica uícha nía, cawinácaalí wenàiwica yeebáidéeyéica Dios itàacái, namànica nacái càide iyúwa íimáaná! —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Néeseté manùba wenàiwica nàwacáidáyacacawa mamáalàacata Jesús itéese. Yá Jesús idàbaca icàlidaca nalíni: “Báawaca náiwitáise níái wenàiwicaca ìyéeyéica siùcade; nasutáca nuícha numàníinápiná naicá yái càmíirica wenàiwica idé imànica. Càmita quéwa numànipiná nalí càiri wawàsi. Numàacacáita naicáca numàníinápiná càide iyúwaté profeta Jonás ìyáaná. ");
INSERT INTO pioNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Càide iyúwaté Nínive ìyacàlená mìnanáimi náalíanáwa Dios ibànùacaté nàatalé profeta Jonás, càita nacái numàacapiná wenàiwica náalíacawa nùwali, núa asìali Dios néeséerica, numànipinácáiná càide iyúwaté profeta Jonás ìyáanáté. ");
INSERT INTO pioNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Aiba èeriwa, Dios yùuwichàidapiná báawéeyéi wenàiwica, yásí níái wenàiwicaca ìyéeyéica siùcade nabàlùapináwa Dios íipunita yéewacaténá Dios icàlidaca naináwaná ìwali, càinácaalí báawéeri namàníiricaté. Néese Sur yàasu cáli icuèchúami càmíichúa israelita umichàapinácawa ucháawàacaténá naináwaná ìwali níái israelitaca ìyéeyéica siùca. Bàaluitécáiná ùanàaca máiní déecuíse wàasu cáli íinatalépiná uémìacaténáté rey Salomón itàacái máiní cáalíacáica, úalíacáinátéwa Dios imàacacaté Salomón icàlidaca tàacáisi cáalíacáiri iyú. Quéwa éwita nùyacáaníta nèewibàa, níái israelitaca, núa cachàiníirica íiwitáise rey Salomón ichàini íicha, càicáaníta càmita neebáida nutàacái. Iná cabáyawanáca Dios iicáca nía. ");
INSERT INTO pioNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Nía nacái càmíiyéica israelita ìyéeyéicaté Nínive ìyacàlená irìcu namichàapinácawa èeri imáalàacaalíwa Dios yùuwichàidapinácaalí báawéeyéi wenàiwica. Néese níái israelitaca ìyéeyéica siùca nabàlùapináwa Dios íipunita yéewacaténá Dios icàlidaca naináwaná ìwali, càinácaalí báawéeri namàníiricaté. Yásí Nínive ìyacàlená mìnanáimi nacháawàapiná israelitanái iináwaná ìwali, bàaluitécáiná Nínive ìyacàlená mìnanáimi nawènúadaca náiwitáisewa Dios irípiná néemìacáináté profeta Jonás icàlidaca nalíni Dios inùmalìcuíse. Néese, éwita nùyacáaníta nèewibàa siùcade, níái israelitaca, núa cachàiníirica íiwitáise profeta Jonás ichàini íicha, càicáaníta càmita neebáida nutàacái. Iná máiní cabáyawanáca Dios iicáca nía”, íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Jesús íimaca nalí: “Péemìacué comparación: Watùcunìacaalí lámpara, càmita wabàani catácatalé, càmita nacái yàalusi irìculé. Néese wamàacaca lámpara icànaca chènunibàa amalácaténá wenàiwicanái irí iwàluèyéicawa néré. ");
INSERT INTO pioNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Pituí nacái ìyaca pirí càide iyúwa lámpara pituícáiná imàacaca piicáca. Cayábacaalí pituí, yásí amalánamaca piicáca. Quéwa, báawacaalí pituí, néese catáca piicáidaca. ");
INSERT INTO pioNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Néese, yái píináidéericawa piwàwalìcuísewa ìyaca càide iyúwa catuíri íiwitáise. Iná picùa cayába piwàwawa, masaquèeri iyú, picá cáininá piicáca áiba wawàsi Dios íicha, ipíchaná catáca píiwitáise. ");
INSERT INTO pioNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Amalácaalí píiwitáise, canásíwacaalí catá píiwitáise, yásí píalíaca piicáca cayábéeri báawéeri íichaná, càide iyúwa lámpara icànacaalí pìwali”, íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Idécanáamité Jesús icàlidacani wenàiwicanái irí, yá abéeri fariseo imáidaca Jesús iyáacaténá iyáacaléwa. Ináté Jesús iwàlùacawa fariseo icapèe irìculé, yá yáawinacawa mesa iwéré. ");
INSERT INTO pioNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Yái fariseo íináidacawa manuísíwata iicáidaca Jesús irí iicácáiná Jesús càmita imàni culto nacáiri íibacaténá icáapiwa éeréeri iyú, iyúwa fariseonái íiwitáise ìyáaná ipíchawáise iyáaca iyáacaléwa. ");
INSERT INTO pioNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Quéwa Wáiwacali íimaca irí: —‍Píacué fariseoca, pimànicuéca madécaná wawàsi éeréeri iyú càide iyúwaté pìawirináimi yéewáidáanácué pía, yá macái wenàiwica nayúunáidaca masacàacuéca píiwitáise. Péemìacué comparación: Càicuéca píade iyúwa bacàa, quírápieli nacái wáibéeyéica íinatabàa. Quéwa máiní báawaca píiwitáise piwàwalìcuísewa càide iyúwa bacàa ipuniéchúacawa casaquèeri iyú, peedácáinácué piríwa manùba wawàsi piyéede iyúwa, iyú nacái yái báawéerica pimàníiricuéca. ");
INSERT INTO pioNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","¡Píacué càmíiyéica yáalíawa! ¿Càmitacué píalíawa Dios yáalimá iicáca piwàwalìculéwa càide iyúwa iicáaná nacái macái wawàsi wenàiwica yáaliméerica iicáca ituí iyúwa? ");
INSERT INTO pioNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Quéwa, iwàwacutácué masacàaca pimànica píiwitáisewa piwàwalìcuísewa quéechacáwa yéewanápinácué pìaca catúulécanéeyéi irí cayábéeri ofrenda Dios irípiná. Masacàacaalícué pimànica píiwitáisewa, yásí masacàaca Dios iicácué macáita yái pimàníiricuéca. ");
INSERT INTO pioNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“¡Dios yùuwichàidapinácué píawa, píacué fariseoca! Pimàacacuéca bànacalé ofrenda iyú Dios irí abéerinama néená níái diéyéica imanùbaca pibànacaleca púubéeyéica, níái menta ibáiná, ruda ibáiná nacái, macái bànacalé íiwitáaná nacái, càide iyúwaté Dios ichùulìanácué pimàacaca irí nía ofrenda iyú sacerdotenái iyáapiná. Quéwa, càmitacué picùa wenàiwicanái machacàníiri iyú, càmitacué nacái cáininá piicáca Dios. Máinícué iwàwacutá cài pimànica, quéwa picácué piyamáida pimàaca pìasu cawèníiriwa Dios irípiná ofrenda iyú. ");
INSERT INTO pioNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“¡Dios yùuwichàidapinácué píawa, píacué fariseoca!, iwàwéeyéica máiní yáawinacawa macái wenàiwica yàacuésemi chènunibèeri yàalubáisi íinata néewáidacàalu irìcu pimànicaténácué culto, yéewacaténácué naicáca pía iyúwa máiníiyéica cachàinica. Casíimáicuéca piwàwa nacái natàidacáinácué pía máiní cáimiétaquéeri iyú bamuchúamibàa yàcalé áibanái wenàiwica naicácaténácué natàidaca pía. ");
INSERT INTO pioNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“¡Dios yùuwichàidapinácué píawa! Péemìacué comparación: Càicuéca píade iyúwa càliculìi càmíiyéi wenàiwica yáalíawa alénácaalí càliculìi ìyaca, néese wenàiwica nàipìnaca càliculìi íinatabàa, quéwa càmita náalíawa nàipìnaca casaquèeri íinatabàa. Càita nacái áibanái néemìaca péewáidáanácué nía quéwa càmita náalíawa casacàacuéca píiwitáise”, íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Iná abéeri yéewáidéeri wenàiwica templo irìcu íimaca Jesús irí: —‍Pía, yéewáidéerica wenàiwica, picàlidacáiná càiri tàacáisi fariseonái irí, íná pitàaníca pìyaca wàwali nacái báawéeri iyú, wía yéewáidéeyéica wenàiwica templo irìcu —‍íimaca. ");
INSERT INTO pioNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Quéwa Jesús íimaca: —‍¡Dios yùuwichàidapinácué pía nacái, píacué yéewáidéeyéica wenàiwica templo irìcu! Péemìacué comparación: Càicuéca píade iyúwa náiwacanánái ichùulièyéica wenàiwica iwáacutáidaca máiní imiéri wawàsi, néese càmita nayúudàa iwáacutáidacani, ibatàa nacáapi ipùata achúméeríina iyúpináta, càmita nayúudàa iwáacutáidacani. Càita nacái pichùulìacuéca wenàiwica namàníinápiná madécaná càulenéeri wawàsi píimacáinácué Dios iwàwacasa cài namànica, néese càmitacué pimàni càide iyúwa pichùulìaná áibanái imànica. ");
INSERT INTO pioNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“¡Dios yùuwichàidapinácué píawa!, píacué imàníiyéica cayábanaméeyéi iicácanáwa capìi profetanáimi yàasu càliculìimi iwicáubàa, piwàwacáinásacué piwàwalica nía, Dios yàasu wenàiwica profetanáimica pìawirináimi inuéyéicaté. ");
INSERT INTO pioNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Iná píasáidacuéca abédanama píiwitáise pìawirináimi yáapichawa, cayábaca piicácuéca yái namàníiricaté; nanúacáináté profetanái, néese cayábacuéca pimànica profetanáimi yàasu càliculìimi. ");
INSERT INTO pioNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","“Iná Dios íimaca cáalíacáiri iyú: ‘Nubànùapiná profetanái, apóstolnái nacái nacàlidacaténá nutàacái israelitanái irí. Néese israelitanái namànipiná báawéeri abénaméeyéi irí, nanúapiná nacái áibanái néená’, càité íimaca yái Diosca. ");
INSERT INTO pioNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Yácáiná Dios yùuwichàidapinácué píawa, píacué israelitaca ìyéeyéica siùca ìwalíise yái pìawirináimicué inúanácaté Dios yàasu wenàiwica profetanái, Dios idàbacatáisecaté èeriquéi àta siùca nacáide. ");
INSERT INTO pioNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Yáara idàbáanéerica nanúacaté íipidenéericaté Abel. Néese nanúacaté áibanái manùbéeyéi. Yáara nanuéricaté namáalàidáaná canánama íipidenáté Zacarías, yái profeta nanuéricaté templo ibàacháwalená irìcu, bamuchúamibàa náicha altar, templo nacái. Iná núumacué pirí, Dios yùuwichàidapinácué píawa, píacué israelitaca ìyéeyéica siùca ìwalíise yái pìawirináimicué inúanácaté profetanái, icàlidéeyéicaté tàacáisi Dios inùmalìcuíse. ");
INSERT INTO pioNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“¡Dios yùuwichàidapinácué píawa, píacué yéewáidéeyéica wenàiwica templo irìcu! Péemìacué comparación: Càicuéca píade iyúwa wenàiwica iyéeduèyéica capìi yàasu llave, néese càmita nawàlùawa capìi irìculé, càmita nacái nabatàa áibanái iwàlùacawa. Càita nacái píacué: Ewitacué píalíacáanítawa càinácaalí Dios itàacái íimáaná, càicáaníta càmitacué piwènúada píiwitáisewa peebáidacaténáni, càmita nacái pibatàa áibanái yeebáidacani”, íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Idécanáami cài Jesús íimaca nalí, yá calúaca nía báawanama, níái yéewáidéeyéica wenàiwica templo irìcu, nía nacái fariseoca. Néese nadàbaca nasutáca néemìawa Jesús manùba wawàsi ìwali nasàiwicacaténá irí wawàsi. ");
INSERT INTO pioNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Náalimáidaca naicáwani íimáanápiná áiba wawàsi báawéeri yéewanápiná nacháawàaca iináwaná ìwali itàacái ìwalíisewa. ");
INSERT INTO pioNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Néenialíté madécaná mil namanùbaca wenàiwica nàwacáidáyacacawa Jesús yàatalé naicácaténáni. Máinícáiná dàalaca néré wenàiwica, íná nabawàidáyacacawa. Yá Jesús idàbaca icàlidaca quéechacáwa yéewáidacalénái iríwani. Yá íimaca nalí: “Picácué píichawa fariseonái yàasu levadura. Yái levadura íimáanáca càicanide iyúwa náiwitáise pucháibéeri, ipíchanácué nacái pucháibacuéca píiwitáise. ");
INSERT INTO pioNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Càmitacué píalimá pibàaca pibáyawanáwa càiripináta. Aibaalípiná macáita náalíacawa ìwali. ");
INSERT INTO pioNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Iná macáita wawàsi pitàaníiricuéca ìwali catéeri irìcu, áibaalípiná macáita néemìapináca amalánama ìwali. Macáita wawàsi pitàaníiricuéca ìwali ibàacanéeri iyú áibanái íicha, picapèe imàdáaná irìcuwa, yásí áiba èeriwa náiríacawa capìi ipùatalìculé, yá nacàlidapinácani cachàiníiri iyú macái yàcalé mìnanái irí”, íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Jesús íimaca yéewáidacalénái iríwa: “Píacué nùacawéeyéiná, núumacuéca pirí, càmita iwàwacutá cáalucuéca pía náicha èeri mìnanái yáaliméeyéica inúacuéca pía, quéwa idécanáamicué nanúaca pía, néese càmita quirínama náalimá namànica pirí báawéeri. ");
INSERT INTO pioNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Quéwa nucàlidacuéca pirí ìwali cawinácaalí iwàwacutá cáalucuéca pía íicha: Iwàwacutácué cáaluca pía Dios íicha, yái yáaliméerica yeedácuéca picáuca, yúucacaténácué pía infierno irìculé. Báisíta, iwàwacutácué cáaluca pía íicha manuísíwata, ipíchanácué pimànica pibáyawanáwa, pìacaténácué nacái icàaluíniná. ");
INSERT INTO pioNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Péemìacué comparación: Nawénda cinco namanùbaca púubéeyéi màsibèe pucháiba moneda ìwalinápiná càmicáiná máiní cawènica màsibèe. Quéwa Dios càmita iimáicha nía ibatàa abéeripiná, càmita Dios iimáichani, yái màsibèeca. ");
INSERT INTO pioNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Càita nacái Dios icùacuéca pía. Dios yáalíacuécawa macáita pìwali, àta càisimalénácaalícué píiwita ibáiná, yáalía nacáiwa Dioscáiná idéca iputàaca nía abénamata. Iná picácué cáalu píináidacawa piwàwawa, Dioscáiná iicácuéca pía iyúwa cawèníiri yáwanái náicha macái púubéeyéi màsibèe manùbéeyéi”, íimaca nalí yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Jesús íimaca nalí: “Núumacué pirí, cawinácaalí wenàiwica icàlidéerica iináwanáwa yeebáidaca nutàacái wenàiwicanái yàacuésemi, yásí núa nacái, asìali Dios néeséerica, nucàlidapiná iináwaná ìwali nùasu wenàiwicacani Dios yàasu ángelnái yàacuésemi. ");
INSERT INTO pioNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Aibacaalí quéwa càmita icàlida iináwanáwa yeebáidaca nutàacái wenàiwicanái yàacuésemi, néese nucàlidapiná iináwaná ìwali, càmita nùasu wenàiwicani Dios yàasu ángelnái yàacuésemi. ");
INSERT INTO pioNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Aibacaalí itàaní báawéeri iyú nùwali, núa asìali Dios néeséerica, néese iwènúadacaalí íiwitáisewa báawéeri íicha, yásí Dios imàacapiná iwàwawa ibáyawaná íicha. Quéwa áibacaalí itàaní báawéeri iyú Espíritu Santo ìwali, néese càmita Dios imàaca iwàwawa ibáyawaná íicha. ");
INSERT INTO pioNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Náibàapinácué píawa nacháawàacaténácué piináwaná ìwali judíonái yéewáidacàalu irìcu, jueznái yàatalé nacái, yàcalé íiwacanánái yàatalé nacái, quéwa picácué achúma píináidawa piwàwawa ìwali càinácaalí iyú yéewanápiná picàlidaca piináwaná ìwaliwa, ìwali nacái yái tàacáisi iwàwacutéericuéca picàlidaca nalí. ");
INSERT INTO pioNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Iwàwacutácaalípiná picàlidaca piináwanáwa, yásí Espíritu Santo yéewáidacué píawa, càinácaalícué iwàwacutáanápiná picàlidaca nalíni”, íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Néeseté áiba asìali ibàluèricawa wenàiwicanái yèewi íimaca Jesús irí: —‍Pía, yéewáidéerica wía, pichùulìa nuénásàiri yàaca nulí nùasupiná wáaniri yàasumi yéená —‍íimaca. ");
INSERT INTO pioNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Jesús íimaca irí: —‍Pía, nùacawéerináca, càmita nùanàa càide iyúwa juez imàníiná nuémìacaténá wenàiwicanái nacháawàaca áibanái iináwaná ìwali, càmita nacái nùanàa nuseríacaténá náaniri yàasumi yèewi —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Néese Jesús íimaca nacái: —‍Piicácué píichawa cayába. Picácué piwàwa peedáca piríwa mamáalàacata cawèníiri wawàsi. Wáalimáca wàyaca casíimáiri iyú éwita canácaalí walí manùba cawèníiri. Ewita wenàiwica idènìacaalí yàasuwa madécaná cawèníiri, càicáaníta càmita yáalimá yáalíacawa asáisí ìyacaalípiná madécaná camuí —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Néese Jesús yéewáidaca nía. Yá íimaca nalí: “Péemìacué comparación: Iyacaté càasuíri asìali, idènièricaté madécaná ibànacalewa. Néese áiba camuíté càasuíri yeedáca manùba ìyacanási ibànacale íichawa. ");
INSERT INTO pioNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Néese càasuíri íináidacawa, yá íimaca iríwa: ‘¿Càinásica iwàwacutá numànica? Canáca nulí cayába capìi imanùbaca nùwacáidacatalépiná yàacàsi yái nuedéerica nubànacale íichawa’, íimaca iríwa. ");
INSERT INTO pioNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","19","Néese íimaca iríwa àniwa: ‘Siùca núalíacawa càinácaalí numàníinápiná. Nucàlàlìapiná nucapèewa nuchùnìacaténá àniwa manuínaméeyéi iyú nabàlùacawa yéewanápiná nucùaca nalìcu macáita yái nubànacaleca nuedéerica, macáita nùasu nacáiwa. Néesecáwa, yásí núumaca nulíwa: Pía, nùacawéerináca, siùcade pidènìaca manùba cawèníiri picuèrica pirípináwa pìyacaténá iyú madécaná camuípiná. Iná piyamáida píawawa, piyáa piyáacaléwa, pìira nacái, casíimái nacái piwàwa’, íimaca iríwa yái càasuírica. ");
INSERT INTO pioNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Quéwa Dios íimaca irí: ‘Pía asìali máiwitáiséerica. Yáta catáquéi péetáwa. Néese macáita yái pìwacáidéerica pirípináwa, áibanái needápiná nalíwani macáita, áibanái wenàiwica càmíiyéica píalía ìwali’, íimaca yái Diosca. ");
INSERT INTO pioNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Càita ìyaca cawinácaalí wenàiwica ìwacáidéericáita iríwa meedá cawèníiri yàasupináwa, càmíiri quéwa imàni càide iyúwa Dios iwàwáaná”, íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Néeseté Jesús íimaca yéewáidacalénái iríwa: “Péemìacué cayába: Picácué achúma píináidáanícawa piwàwawa ìwali càinácaalícué iyú yéewanápiná peedáca piyáacaléwa, pìyacaténácué, càinácaalícué iyú yéewanápiná nacái peedáca pibàlepináwa, pìwalicaténácué pibàlewa. ");
INSERT INTO pioNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Máiníiri cawènica wacáuca yàacàsi íicha. Wainá nacái máiníiri cawènica bàlesi íicha. Dios idéca yàaca wacáuca chái èeri irìcu, wainá nacái cawèníiri íná yéewa wáalíacawa yàanápiná walí wawàsi càmíirica máiní cawènica, yái yàacàsica, yái bàlesica nacái. ");
INSERT INTO pioNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Piicáidacué nalí níái cuìpìraca. Càmita nabàna nabànacalewa. Càmita nacái needá nabànacalewa. Canáca nacái nacapèe nadènìacatalépiná nabànacale ìyacanáwa. Quéwa Diosta yàaca nayáapiná. Néeni, ¡máinícuéca cáinináca Dios iicáca pía náicha níái màsibèeca! Iná iwàwacutácué píalíacawa Dios icùanácué pía nacái. ");
INSERT INTO pioNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Néese, éwitacué píináidáanícaalíwa piwàwawa báawanama, càicáaníta càmitacué píalimá cáala pimànicuéca picáucawa, ibatàa abéeri hora piná, càmitacué píalimá cài. ");
INSERT INTO pioNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Càmicáinácué píalimá pimànica càiri achúméeri wawàsi, íná canéeri iwèni meedá píináidacaalícuéwa piwàwawa báawanama yàacàsi ìwali, bàlesi nacái. ");
INSERT INTO pioNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Piicáidacué càinácaalí íiwinási nadàwinàacawa: Càmita náibaida. Càmita nacái needá sáawáli namàníiripiná nabàlewa. Quéwa núumacué pirí nadènìaca náiwináwa cayábéeri iicácanáwa rey Salomón ibàle íicha, éwitaté máinícáaníta càasuca Salomónca. ");
INSERT INTO pioNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Dios idéca imàacaca masicái ibàlepiná cayábéeri iicácanáwa, éwita masicái nàyacáaníta maléená èeri meedá manacúalibàa, néese táwicha, yá wenàiwica neemácani quichái iyú. Dios imànica cayábéeri masicái irí waiquéerica càiride iyúwa canéeri iwèni, íná iwàwacutácué píalíacawa Dios yàanápinácué pibàlepiná nacái. ¿Cánácué càmita manuí píináidacawa piwàwawa Dios ìwali icùanápinácué pía? ");
INSERT INTO pioNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Picácué píináidáaníwa mamáalàacata càinácaalícué iyú yéewanápiná peedáca piyáacaléwa. Picácué máiní achúmaca píináidacawa piwàwawa ìwali mamáalàacata. ");
INSERT INTO pioNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Níacáiná macái èeri mìnanái càmíiyéica Dios yéenibeca náináidáanícawa nawàwawa ìwali, yái wawàsica. Quéwa ìyacué pirí Wáaniri Dios yáaliéricawa càiríinácaalí wawàsi pimáapuèricuéca. ");
INSERT INTO pioNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Píalimáidacué pimànica càide iyúwacué Dios ichùulìaná pimànica, macái pichàini iyúwa, yásí Dios yàacué pirí nacái macáita càinácaalícué pimáapuèrica”, íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Jesús íimaca yéewáidacalénái iríwa: “Picácué cáalu pía, píacué nùasu ovejanáica; máisibáwanáitacué pía, quéwa Wáaniri Dios idéca yeedácuéca pía imàacáanápinácué yàasunáica pía, icùacaténácué pía. ");
INSERT INTO pioNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Piwéndacué pìasuwa. Pìacué iwènináami catúulécanéeyéi irí. Yásí pidènìapinácué cawènisíwéeri càmíirica imáalàawa Dios yèeripinácué pirí chènuniré, aléera càmicataléca éwisàimipinácué píichani, càmicatalé cayéedéeri yáalimá iwàlùacawa, càmita nacái cuwée imáalàidacuéca píichani. ");
INSERT INTO pioNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Yásí pìasucué cawèníirisíwa ìyapiná chènuniré, íná piwàwapinácué pìyaca chènuniré”, íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Néeseté Jesús íimaca yéewáidacalénái iríwa: “Pichùnìacué píiwitáisewa picùacaténácué nùacawa néese. Péemìacué comparación: Pìyacué càide iyúwa wenàiwica idécanáami ìwalica ibàlewa, ipucúadaca nacái yàasu lámparawa. ");
INSERT INTO pioNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Picùacué nùacawa néese càide iyúwa áibanái íibaidéeyéica nacùacaalí náiwacaliwa yèepùacawa casamiento néese, áibanái imànicatalé fiesta nacásàacadénáamiwa. Nacùaca náiwacaliwa yàacawa néese àta yàanàacataléta casamiento néese, yéewanápiná nàacùaca irí capìi inùma ráunamáita yàanàacaalípiná imáidaca. ");
INSERT INTO pioNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Yái náiwacali yàanàacaalípiná, yá yàanàacaalí nía càmíiyéica iimá, yásí casíimáica yàasu wenàiwicanái. Péemìacué cayába, yái náiwacali ichùnìapináca yàasuwa iwacùacaténá nalí nayáapiná. ");
INSERT INTO pioNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Casíimáica níawa, náiwacali yàanàacaalí nía càmíiyéi iimá, éwita yàanàacaalí néré catá bamuchúami, càmicaalí nacái, cacámalaléwa nacái. ");
INSERT INTO pioNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Péemìacué comparación: Capìi íiwacali yáalíacaalítéwa càinácaalípiná hora irìcu cayéedéeri yàanàacatá, néese càmita ibatàa nàacùaca capìinùma nayéedùanápiná íicha yàasutá. Càmita quéwa capìi íiwacali yáalíawa càinácaalípiná hora irìcu cayéedéeri yàanàa. ");
INSERT INTO pioNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Càita nacáicué pía. Pichùnìacué píiwitáisewa picùacaténácué nùacawa néese, núa asìali Dios néeséerica, nùacáináwa néese càmicatáipinátacué picùa nùanàa”, íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Néeseté Pedro isutáca yéemìawa Jesús: —‍Wáiwacali, ¿picàlidasica yái comparaciónca péewáidacaténá wíawamita wía péewáidacaléca, càmicaalí nacái, péewáidasica canánama wenàiwica? —‍íimaca yái Pedroca. ");
INSERT INTO pioNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Néese Wáiwacali íimaca: “Péemìacué comparación: Iwàwacutácué pìyaca càide iyúwa capìi íiwacali yàasu wenàiwica. Cáibaidacáiricani, yái yàasu wenàiwicaca, yeebáidéeri nacái íiwacali itàacáiwa machacàníiri iyú. Iná yái capìi íiwacalica, ipíchawáise yàacawa icapèe íichawa, yá ichùulìaca yàasu wenàiwicawa icùanápiná yàasu wenàiwica áibanái, yàacaténá nacái nayáapiná èeri imanùbaca. ");
INSERT INTO pioNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Néesecáwa íiwacali yàanàacaalípiná àniwa, yá casíimáica yàasu wenàiwica imànicaalícáwa ìyaca càide iyúwa íiwacali íimáanáté irí. ");
INSERT INTO pioNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Péemìacué cayába, yái íiwacali imàacapiná yàasu wenàiwicawa icùaca macáita yàasu, yácáiná yàasu wenàiwica íibaidaca cayába íiwacali iríwa, idècunitàacá canáca yái íiwacalica. ");
INSERT INTO pioNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","46","Quéwa yái íiwacali yàasu wenàiwicaca iyúunáidacaalí íiwacali idècunìacawa mamáalàacata, yá nacái idàbacaalí icapèedáidaca inacáiyéiwa íibaidéeyéica, yá iyamáidaca íibaidaca iyáacaténá manuí iyáacaléwa, ìiraca nacái, icàmáanápiná nacái, yáta íiwacali yàanàapináca yáta èerica yàasu wenàiwica càmicatáita icùa yàanàaca, áiba hora nacái càmíiri yáalíawa ìwali íiwacali yàanàanápiná. Yásí íiwacali idalúaca yèewi pucháibawaca, yái yàasu wenàiwica báawéerica, càide iyúwa yùuwichàidáaná wenàiwica càmíiyéica yeebáida itàacái. ");
INSERT INTO pioNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Cawinácaalí yàasu wenàiwicanái yáaliéyéicawa càinácaalí náiwacali iwàwáaná namànica, quéwa càmíiyéica icùa íiwacali yàanàaca, càmíiyéica yeebáida nacái íiwacali itàacáiwa, yá náiwacali icapèedáidapiná níawa manùba yàawiría cachàiníiri cabèesi iyú. ");
INSERT INTO pioNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Néeseta quéwa cawinácaalí yàasu wenàiwica càmíirica yáalíawa cayába càinácaalí íiwacali iwàwáaná yàasu wenàiwica imànica, néese imànicaalí ibáyawanáwa, yásí íiwacali icapèedáidaca báawatatàani. Cawinácaalí yáaliéyéicawa cayába, iwàwacutá namànica máiní machacàníiri iyú. Cawinácaalí yàasu wenàiwica íiwacali imàaquéeyéica icùaca manùba, iwàwacutá nacùaca nía máiní cayábéeri iyú náicha áibanái càmíiyéica icùa manùba”, íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Néeseté Jesús íimaca yéewáidacalénái iríwa: “Nudéca nùanàaca aléi èeri irìculé, íná càulenéeri wawàsi yàanàapináca macái èeri mìnanái ìwali càide iyúwa quichái yeemácaalí wenàiwica; yá ¡máiní nuwàwa quichái idàbaca ipucúacawa ráunamáita! ");
INSERT INTO pioNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","¡Iwàwacutápiná nùuwichàacawa cáiwíiri yùuwichàacáisi iyú, yá máiní báawaca nuínáidacawa nuwàwawa siùcade àta numáalàidacatalépináta nùuwichàacawa! ");
INSERT INTO pioNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Picácué píináidawa wenàiwicanái nàyapiná matuíbanáita náapichawáaca nùanàacáaníta aléi èeri irìculé. ¡Càmíirita! Néese, càmita abédanama náiwitáise nùwali. ");
INSERT INTO pioNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Siùcáisede nàyacaalí cinco namanùbaca néenánái, yásí máisiba càmita abédanama náiwitáise pucháiba yáapicha, càita nacái, càmita abédanama pucháiba íiwitáise máisiba yáapicha. ");
INSERT INTO pioNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Asìali yùuwideca imànipináca ìiriwa. Iiri nacái yùuwideca imànipiná yáaniriwa. Inanái ùuwideca umànipináca uíduwa. Uídu nacái ùuwideca umànipiná úatúawa. Ua nacái ucuíruca ùuwideca umànipiná uinìruwa. Uinìru nacái ùuwideca umànipiná ucuíruwa, níacáiná abénaméeyéi néená neebáidapiná nutàacái, quéwa áibanái càmita neebáidapiná nutàacái”, íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Yá Jesús íimaca wenàiwicanái irí: “Péemìacué comparación: Chái Israel yàasu cáli íinata, piicácaalícué manùba acalèe namichàacawa èeri iwàlùacatáisewa, yásí píimacuéca piríwáaca: ‘Aca uníara wàatalé’. Yásí yúuwàacawa. ");
INSERT INTO pioNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Néese cáuli ipùacaalí sur néese, yásí píimacuéca ùuleca cáminá walíwa. Yásí ùulecani. ");
INSERT INTO pioNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","¡Píacué pucháibéeyéica íiwitáise! Píalíacuécawa càinácaalí íimáaná yái acalèe iicácanáwa, chái cáli nacái. Iná píalíacuéca nacáiwa càinácaalí íimáaná yái Dios imàníirica siùca, quéwa picàlidacáitacué pichìwawa càmitasacué píalíawa cawinácaalí núa”, íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Jesús íimaca nalí: “¿Cánácué càmita píináidawa machacàníiri iyú pimàníinápinácué cayábéeri? ");
INSERT INTO pioNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Pisutá Dios íicha caquialéta imàacáanápiná iwàwawa pibáyawaná íicha, ipíchaná yùuwichàidaca pía. Càmicaalí cài pimàni, yásí Dios ìyaca pirí càiride iyúwa piùwide. Péemìa comparación: Piùwide itécaalí pía icháawàacaténá piináwaná ìwali nacuèrinánái irí, yá iwàwacutá pitàaníca yáapicha éeréta àyapulìcubàa. Pisutá íicha wawàsi caquialéta imàacáanápiná iwàwawa pibáyawaná íicha ipíchaná itéca pía juez yàatalé; càmicaalí pisutá íicha cài, yásí juez imàacaca úwinái náibàaca pía, yá úwinái náucapiná píawa presoíyéi ibànalìculé, nacapèedáidacaténá píawa. ");
INSERT INTO pioNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Péemìa cayába. Canácatáita namusúawa nàuwichàacái íichawa presoíyéi ibàna irìcuíse àta napáyaidacataléta náichawa namawènìacálewa macáita, àta abéeri centavo piná, yái centavo namáalàidáaná canánama. Càita nacái càmita píalimá pimusúacawa Dios yàasu yùuwichàacáisi íicha càiripináta”, íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Néenialíté abénaméeyéi wenàiwica nàacawa Jesús yàatalé, yá nacàlidaca Jesús iríni, Pilato gobernador imàacacaté yàasu úwináiwa inúaca wenàiwica Galilea yàasu cáli néeséeyéi. Yáté Galilea néeséeyéi íiranámi yèewìacawa napìra íiranámi yèewiwa, níái pìráimica nanuéyéicaté sacrificio piná nàacaténá Dios icàaluíniná. Uwinái inúacáiná nía mawiénita irí yáni nanúacatái napìrawa, íná yéewa náiranámi yèewìacawa napìra íiranámi yèewiwa. ");
INSERT INTO pioNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Néese Jesús íimaca nalí: “Níara Galilea yàasu cáli néeséeyéica néetácatéwa máiní báawéeri iyú. Iná cawàwanátacué piyúunáidaca cabáyawanácaté nía náicha canánama ìyéeyéica nàasu cáli íinata. ");
INSERT INTO pioNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Núumacué pirí, càmitaté cabáyawaná nía áibanái íicha. Néese càmicaalícué piwènúada píiwitáisewa Dios irípiná, yásí péetápinácué nacáiwa méetàuculé Dios íicha. ");
INSERT INTO pioNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Péemìacatécué nacái naináwaná ìwali áibanái dieciocho namanùbaca yéetéeyéicatéwa Siloé néré chènuníiri capìi yúuwàacáinátéwa náinatabàa. Picácué píináidawa cabáyawanéeyéica nía náicha macáita Jerusalén ìyacàlená mìnanáica. ");
INSERT INTO pioNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Núumacué pirí, càmitaté cabáyawaná nía áibanái íicha. Néese càmicaalícué piwènúada píiwitáisewa Dios irípiná, yásí macáita péetápinácué nacáiwa méetàuculé Dios íicha”, íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Néeseté Jesús yéewáidaca nía comparación iyú àniwa, náalíacaténáwa mesúnamáita Dios yùuwichàidáanápináté israelitanái. Yá íimaca nalí: “Aiba asìali idènìacaté higuera yéetaná yàasu uva ibànacalená yèewiréwa. Yàaca iicácaténá idènièricaalí ìyacanáwa yái àicuca, quéwa canáca yàanèeri ìyacanáca. ");
INSERT INTO pioNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Iná bànacalé íiwacali íimaca yàasu wenàiwica iríwa icuèrica uva ibànacalená: ‘Piicá yái àicuca. Nudéca nucutáca ìyacaná máisiba camuí imanùbaca. Yá canáca ìyacaná. Iná piùcani. Canápináta meedá wamàaca ibàlùacawa chái màyacanéeri’, íimaca. ");
INSERT INTO pioNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Quéwa yái icuèrica bànacalé íimaca íiwacali iríwa: ‘Nuíwacali, pimàaca ibàlùacawa chái quirítàacáwa abéeri camuípiná. Yá nubàsabàsáidaca itéesebàa cáli, nùwacáidapiná nacái pìrái ìyami cayábacaténá irí cáli. ");
INSERT INTO pioNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Yá cawàwanáta càyacanácani. Néese quéwa màyacanácaalí mamáalàacatani, yásí piùcacani’, íimaca íiwacali iríwa”, íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Aiba sábado judíonái iyamáidacatáicawa, Jesús yéewáidacaté nía néewáidacàalu irìcu. ");
INSERT INTO pioNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Uyaca néeni cáuláiquéechúa inanái. Demonio yùuwichàidacaté úa dieciocho camuí. Càmita demonio ibatàa ubàlùacawa machacànita, canásíwa, cawaalíca úa mamáalàacata. ");
INSERT INTO pioNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Néese Jesús iicáca úa, yá imáidaca yàataléwa úa. Iimaca ulí: —‍Pía inanái, nuwasàaca pía uláicái íicha —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Néese Jesús imàacaca icáapiwa ùwali úái inanáica. Yáta cayábaca úa. Yá úalimáca ubàlùacawa machacànita. Yá udàbaca ùaca Dios irí cayábéeri. ");
INSERT INTO pioNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Quéwa yái néewáidacàalu íiwacali iicáca Jesús ichùnìaná úa càide iyúwa íibaidacalési, íná calúacani Jesús yáapicha Jesús ichùnìacáiná úa sábado irìcu nayamáidacatáicawa. Yá néewáidacàalu íiwacali íimaca wenàiwicanái irí: —‍Iyaca walí seis èerita wáibaidacatáipiná. Iwàwacutácué pìanàaca quéechacáwatá ichùnìacaténácué píatá, càmita siùca èeri sábado wayamáidacatáicawa —‍íimaca. ");
INSERT INTO pioNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Néese Jesús íimaca nalí: —‍Píacué pucháibéeyéica íiwitáise, péemìacué comparación: Macáitacué piwasàaca pipìranáiwa pacá itéeyéica yàasusi, burro nacái pitécaténácué nàiraca úni siùca èeri wayamáidacatáicawa. ");
INSERT INTO pioNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Néeni, ¿cánácué càmita pibatàa uèpunícawa cayába siùca èeri wayamáidacatáicawa úái Abraham itaquétúanámica, úái inanái Satanás idacuèchúa uláicái iyú dieciocho camuí? —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Idécanáami Jesús icàlidaca nalíni, yá báica yùuwidenái wenàiwicanái yàacuésemi. Quéwa macáita wenàiwica casíimáica nawàwa naicácáináté yái Jesús imàníirica íiwitáise cachàiníiri iyúwa, yái càmíirica áibanái wenàiwica idé imànica. ");
INSERT INTO pioNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Jesús íimaca nalí nacái: “Siùcade nucàlidacué pirí càinácaalí iyú Dios icùaca yàasu wenàiwicawa. Nuéwáidacué pía comparación iyú. ");
INSERT INTO pioNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Yái Dios icùaná yàasu wenàiwicawa ìyaca càide iyúwa achúméeríina mostaza íimi, asìali ibànéerica ibànacale yèewiwa. Máiní achúméeríinaca yái íimica, quéwa idàwinàacawa manuíripiná mamáalàacata càiride iyúwa àicusíwa. Máiníiri manuícani, íná yéewa màsibèe nàanàaca namànica namùlubèwa mostaza yéetaná yàana íinata”, íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Jesús íimaca nalí nacái: “Siùcade nuéwáidacué pía comparación iyú píalíacaténácuéwa càinácaalí iyú Dios icùaca yàasu wenàiwicawa. ");
INSERT INTO pioNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Càicanide iyúwa levadura ìyáaná. Inanái yèewìadaca levadura máisibàawiríacatái harina yèewi, yéewanápiná macáita íbesi inísàacawa”, íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Néeseté idècunitàacáwa Jesús yèepunícawa Jerusalén ìyacàlená nérépiná, yá ichàbacawa áibanái ìyacàle irìcubàa imanùbaca, manuínaméeri, púubéeri nacái yàcaléca. Yá yéewáidaca wenàiwicanái néenibàa nacái. ");
INSERT INTO pioNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Aiba wenàiwica isutáca yéemìawa Jesús: —‍Wáiwacali, ¿máisibáwanáitasica wenàiwica níara Dios iwasèeyéipináca yàasu yùuwichàacáisi íichawa? —‍íimaca. ");
INSERT INTO pioNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Jesús íimaca irí: —‍Píalimáidacué macái pichàini iyúwa peebáidacaténá nutàacái. Máiní càulenáca wenàiwica neebáidaca nutàacái, nawàlùacaténáwa Dios ìyacàle irìculé, càide iyúwacué càulenáaná wawàlùacawa máucuíri capìi inùma irìcubàa. Núumacué pirí madécaná wenàiwica nawàwapiná nawàlùacawa Dios ìyacàle irìculé ìyéerica chènuniré Dios icùacataléca macáita, quéwa càmita náalimápiná, càmicáináté neebáida nutàacái báisíiri iyú. ");
INSERT INTO pioNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Numànipiná càide iyúwa capìi íiwacali imàníiná. Nudécanáami nubàlìaca capìi inùma chènuniré, yásí píacué ìyéeyéica méetàuculé capìi íicha, pìanàapinácuéca inùma néré, yá pimáidapinácuéca nulíwa: ‘Wáiwacali, pìacùa walíni’, càipinácué píimaca nulí. Quéwa núumacuéca piríwa: ‘Càmitacué núalía nuicáca pía síisáanéeyéicaalícué pía’, cài núumacuéca pirí. ");
INSERT INTO pioNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Néese píimapinácuéca nulí: ‘Wayáacaté wayáacaléwa píapicha. Péewáidacaté wía wàyacàle yàasu calle irìcubàawa’, càipinácué píimaca nulí. ");
INSERT INTO pioNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Quéwa núumapinácué pirí àniwa: ‘Nudéca núumacuéca pirí, càmitacué núalía nuicáca pía síisáanéeyéicaalícué pía. Pìacuéwa nuícha macáita píacué imàníiyéica ibáyawanáwa’, càipinácué núumaca pirí. ");
INSERT INTO pioNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Yá píicháanípinácuéca néenibàawa, piamíadapinácuéca piyéiwa piùwichàacái iyúwa, piicácáinácué pìawirináimi Abraham, Isaac nacái, Jacob nacái, macái profetanái nacái nàyaca Dios ìyacàle irìcu, icùacataléca macáita chènuniré, píacué quéwa piúcapinácuécawa méetàuculé. ");
INSERT INTO pioNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Madécanácáiná wenàiwica nàanàapiná néréwa, macái cáli néeséeyéica, norte néeséeyéi, sur néeséeyéi nacái, este néeséeyéi nacái, oeste néeséeyéi nacái, nayáacaténá nayáacaléwa Dios ìyacàle irìcu Dios icùacataléca macáita chènuniré. ");
INSERT INTO pioNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Néese abénaméeyéi càmíiyéica máiní cachàini siùcade chái èeri irìcu áiba èeriwa máiní cachàinica níata áibanái íicha. Aibanái nacái cachàiníiyéica siùcade, áiba èeriwa càmita máiníiyéi cachàinica níata èeri imáalàacaalípináwa —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Yáté èerica abénaméeyéi fariseonái nàanàaca Jesús yàatalé. Yá náimaca Jesús irí: —‍Ara, pìacàatétawa, rey Herodes iwàwacáiná inúaca pía —‍náimaca. ");
INSERT INTO pioNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Quéwa Jesús íimaca nalí: —‍Pìacuéwa rey Herodes yàatalé, yáara cachìwéerica. Píimacué irí cài: ‘Péemìa cayába, maléená èeri quirítàacáwa núuca demonio wenàiwicanái íicha, nuchùnìa nacái cáuláiquéeyéi. Néese mesúnamáita numáalàidaca numànica nuíbaidacaléwa’, cài píimacué iríwa. ");
INSERT INTO pioNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Quéwa iwàwacutá nuèpunícawa maléená èeri quirítàacáwa àta nùanàacataléta Jerusalén ìyacàlená irìculé, níacáiná israelitanái nanúacaté batéwa macáita Dios yàasu profetanái Jerusalén ìyacàlená irìcu. Iná iwàwacutá núa nacái nuétácawa néenibàa. ");
INSERT INTO pioNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“¡Píacué Jerusalén ìyacàlená mìnanáica, píacué inuéyéica Dios yàasu profetanái, inuéyéica nacái wenàiwica íba iyú, níái wenàiwica Dios ibànuèyéica icàlidacaténácué pirí tàacáisi inùmalìcuíse! ¡Manùba yàawiría nuwàwacaté nùwacáidacuéca nucùaca pía càide iyúwa cawámai ùwacáidacaalí uénibewa ubáiná yáapíisewa! Quéwa càmitacué piwàwa nucùaca pía. ");
INSERT INTO pioNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Iná péemìacué cayába, máiséeyéipiná picapèemicuéca idécanáami piùwidenái imànicuéca píipunita ùwicái; núumacué nacái pirí, càmitacué piicá núa quirínama àta píimacatalépinátacué nùwali: ‘¡Cayábéericani yái yàanèerica Wacuèriná Dios íipidená ìwali, Dios ibànuèrica walí!’ càipinácué píimaca nùwali —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Aiba sábado judíonái iyamáidacatáicawa, Jesús yàacawa iyáacaténá iyáacaléwa abéeri fariseo íiwacaliná icapèe irìcu. Nàyaca néenibàa áibanái fariseo nacái iicáidéeyéica ìyaca Jesús irí, naicácaténá asáisí imànicaalí áiba wawàsi nacháawèeripiná iináwaná ìwali ìwalíise. ");
INSERT INTO pioNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Iyaca abéeri cáuláiquéeri nacái Jesús íipunita. Yái cáuláiquéerica yéenéeriwa macáita ìwalíisewa. ");
INSERT INTO pioNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Néese Jesús isutáca yéemìawa níái yéewáidéeyéica wenàiwica templo irìcu, nía nacái fariseonái. Yá íimaca nalí: —‍¿Càinácué píináidacawa? ¿Dios imàacasica wachùnìaca cáuláiquéeyéi wenàiwica siùca èeri sábado wayamáidacatáicawa? —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Quéwa masànata íicha nía meedá. Néese Jesús imàacaca icáapiwa ìwali yái cáuláiquéerica, yá ichùnìacani. Yá Jesús imàacaca asìali yèepùacawa náicha matuíbanáiri iyú. ");
INSERT INTO pioNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Néese Jesús íimaca fariseonái irí: —‍Nucàlidacué pirí comparación: Abéericaalícué pìiri, càmicaalí nacái, pipìra pacá, yúuwàacaalíwa utàwi nacáichúa irìculé namusúadacatáise úni, ¿càmitasicué pimusúada caquialétani, éwita sábadocáaníta, yái èeri wayamáidacatáicawa? Iná ¿cánácué càmita píalíawa Dios imàacaca wachùnìaca cáuláiquéeyéi wenàiwica macái èeri imanùbaca, sábado nacái? —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Néese báica nía, càmita náalimá nacàlidaca iríni, Jesús imawènìadacáináté nía. ");
INSERT INTO pioNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Níái asìanái fariseo imáidéeyéicaté néré nacutáca náawinacatáipináwa cáimiétacanéeyéi yàasu yàalubáisi íinata, cáimacáicáiná naicáca níawawa, nawàwacáiná nacái áibanái naicáca nía cáimiétaquéeri iyú. Jesús iicácáiná namàníiná, íná yàalàaca nía comparación iyú. Iimaca nalí: ");
INSERT INTO pioNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","—‍Aiba imáidacaalí pía fiesta casamiento nérépiná, picá píawinawa cáimiétacanéeyéi yàasu yàalubáisi íinata yácáiná cawàwanáta áiba wenàiwica yàanàaca, capìi íiwacali imáidéerica néré, cachàiníirica píicha. ");
INSERT INTO pioNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Néese capìi íiwacali, yái imáidéericuéca pía pucháiba, yàanàapiná pìatalé, yá íimapináca piríwa: ‘Pimàaca áiba yáawinacawa pìatalé’, càipiná íimaca pirí. Néese báica pía meedá naicácáiná piwàwacutáaná pìaca píawinacawa yàalubáisi íinata namáalàidáaná canánama, càmíiyéi cáimiétacaná yáawinacatáiwa, déeculé capìi íiwacali íicha. ");
INSERT INTO pioNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Iwàwacutá cài pimànica: Namáidacaalí pía, yá píawinawa yàalubáisi íinata namáalàidáaná canánama, càmíiyéi cáimiétacaná yáawinacatáiwa, yéewanápiná capìi íiwacali yàanàaca néré, yásí íimaca pirí: ‘Nùacawéeriná, pichàbawa áibacatalé cáimiétacanéeyéi yáawinacatáicawa’, càipiná íimaca pirí. Càita áibanái yáawinéeyéicawa píapicha mesa iwéré naicápiná capìi íiwacali iicáca pía cáimiétaquéeri iyú. ");
INSERT INTO pioNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Cawinácaalí wenàiwica cáimacáiyéica iicáca yáawawa, Dios imàacapiná báica nía, càmíiyéi nacái cachàini. Néese cawinácaalí wenàiwica càmíiyéica cáimacái iicáca yáawawa, Dios imàacapiná cáimiétacanáca nía, cachàini nacái —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Néese Jesús íimaca capìi íiwacali irí imáidéericaté Jesús néré: —‍Pimáidacaalí áibanái nayáacaténá nayáacaléwa píapicha, picá pimáida pìacawéeyéináwa, nía nacái péenánáiwa, nía nacái pìawiría yéenáca, nía nacái càasuíyéica ìyéeyéica mawiénita pirí; níacáiná áibaalípiná náalíacawa iwàwacutáaná namáidaca nàataléwa pía nacái piyáacaténá piyáacaléwa náapicha. Càita napáyaidaca pía yàacàsi ìwaliná pièricaté nalí. Quéwa càmita cayába cài pimànica. ");
INSERT INTO pioNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Néese pichùnìacaalí manùba yàacàsi áibanái iyáapiná, yá pimáida catúulécanéeyéi wenàiwica, báawéeyéi iiná nacái, éeruíyéi yàabàli nacái, matuíyéi nacái. ");
INSERT INTO pioNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Yásí casíimáipináca piwàwa càmicáiná náalimá napáyaidaca pía àniwa. Yásí Dios imàaca piríwa cayábasíwéeri cawèníiri chènuníiséerica áiba èeriwa namichàacaalípináwa yéetácáisi íicha macáita wenàiwicanáimi cayábéeyéica íiwitáise —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Néeseté idécanáami Jesús icàlidaca nalíni, yá áiba yáawinéericawa néenibàa iyáacaténá iyáacaléwa náapicha íimaca Jesús irí: —‍¡Casíimáipinácani cawinácaalí wenàiwica iyéeripináca iyáacaléwa manùbéeyéi yáapicha Dios ìyacàle irìcu Dios icùacataléca macáita chènuniré! —‍íimaca. ");
INSERT INTO pioNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Néese Jesús íimaca irí: —‍Péemìa comparación: Càasuíri asìali ichùnìacaté madécaná yàacàsi icapèe irìcuwa iwacùacaténá manùbéeyéi wenàiwica yèewi nayáapináni. Yá imáidaca néré manùba wenàiwica. ");
INSERT INTO pioNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Néese yéenáiwaná yàanàaca nayáanápiná nayáacaléwa, yá ibànùaca yàasu wenàiwicawa icàlidacaténá nalíni níái wenàiwicaca càasuíri asìali imáidéeyéicaté. Yá íimaca nalí: ‘Aquialécué macái, nudéca nuchùnìaca macáita’, íimaca nalí. ");
INSERT INTO pioNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Néeseta quéwa macáita nacàlidaca càmitasa náalimá nàacawa néré. Yái idàbáanéerica íimaca: ‘Nudéca nuwènìaca cáli bànacalé yàalupiná. Iwàwacutá nùacawa néré nuicácaténá néréni. Pimàni nulí cayábéeri picàlidaca píiwacali iríwani càmita núalimá nùacawa icapèe néré’, íimaca irí. ");
INSERT INTO pioNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Aiba íimaca irí nacái: ‘Nudéca nuwènìaca diez namanùbaca pacá íibaidéeyéipiná. Iwàwacutá nùacawa néré núalimáidacaténá nía asáisí náibaidacaalí cayába. Pimàni nulí cayábéeri, picàlidaca píiwacali iríwani càmita núalimá nùacawa icapèe néré’, íimaca irí. ");
INSERT INTO pioNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Aiba íimaca irí àniwa: ‘Nudéca nuedáca nùacawéetúapináwa, íná càmita núalimá nùacawa néré’, íimaca irí. ");
INSERT INTO pioNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Néese yái yàasu wenàiwicaca yèepùacawa íiwacali yàataléwa. Yá icàlidaca irí naináwaná. Néese calúaca yái íiwacalica. Yá íimaca yàasu wenàiwica iríwa: ‘Pìacàatétawa yàcalé néré. Picutáca wenàiwica carretera manuínaméeyéi irìcubàa, àyapu púubanaméeyéi irìcubàa nacái. Pimáida catúulécanéeyéi yàanàacaténá nucapèe néré, nía nacái éeruíyéi yàabàli, nía nacái yàana ituwièyéicawa íicha, nía nacái macàwéeyéica’, íimaca yái íiwacalica. ");
INSERT INTO pioNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Néese yàasu wenàiwica imáidaca nía. Yá íimaca íiwacali iríwa: ‘Nuíwacali, nudéca numànica càide iyúwa píimáaná nulí, quéwa càmitàacá ipuníawa yái picapèeca’, íimaca irí. ");
INSERT INTO pioNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Néese íiwacali íimaca irí: ‘Pìawa macái àyapu imanùbaca chuìtaliré yàcalé íicha, ànalìmalé nacái àta alénácaalí nàyaca wenàiwica. Pité néese wenàiwica nawàlùanápináwa, yéewanápiná ipuníacawa yái nucapèeca’, íimaca yái íiwacalica. ");
INSERT INTO pioNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Níacáiná idàbáanéeyéica wenàiwicaca numáidéeyéicaté quéecha, núumacuéca pirí, canácata néená iyáapiná iyáacaléwa nuchùnièrica nucapèe irìcuwa”, íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Madécaná wenàiwica yèepunícatéwa Jesús yáapicha, yéewáidacalécaténá nía. Yá Jesús iwènúa iicáidaca nalí. Iimaca nalí: ");
INSERT INTO pioNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Piwàwacaalícué nuéwáidacaléca pía, néese iwàwacutácué cáinináca piicáca núa íicha yái cáinináanáca piicáca píaniricuéwa, píatúa nacáiwa, pìacawéetúa nacáiwa, péenibe nacáiwa, péenánái nacáiwa, íichacué nacái yái cáinináanáca piicáca picáucawa. Càmicaalícué cáininá piicáca núa íicha yái cáinináanáca piicáca nía, néese càmitacué yéewa nuéwáidacalécuéca pía. ");
INSERT INTO pioNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Piwàwacaalícué pìacawa núapicha iyúwa nuéwáidacalé, iwàwacutácué matuíbanáiri iyú pimàacaca áibanái yùuwichàidaca pía, éwita naicáanícaalícué piquíniná, éwita nanúacaalícué píawa peebáidacáiná nutàacái, càide iyúwa iwàwacutácaalí nawáacutáidaca nàasu cruzwa cawinácaalí yéetéeyéipinácawa cruz ìwali. Iwàwacutácué nacái pimànica mamáalàacata càide iyúwa nuchùulìanácué pía. Càmicaalícué cài pimànica, néese càmitacué píalimá nuéwáidacalécuéca pía. Iná iwàwacutácué píináidacawa cayába quéechacáwa asáisí píalimácaalícué nuéwáidacaléca pía. ");
INSERT INTO pioNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Péemìacué comparación: Abéericaalí péenácué iwàwa imànica chènuníiri capìi, quéechacáwa yáawinacawa iputàaca cayába capìi iwènipiná yáalíacaténáwa asáisí idènìacaalí iwènipiná imáalàidacaténá imànica capìi. ");
INSERT INTO pioNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Néese, càmicaalí cài imàni, néese idécanáami dàalaca imànica cáli ibàlùadacaténá capìi íba íinata, càmita yáalimá imáalàidaca imànica capìi. Yásí macáita wenàiwica iiquéeyéica capìi yéenámi, nadàbapiná naicáaníca asìali iquíniná. ");
INSERT INTO pioNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Yá náimapináca ìwali: ‘Yái asìali idàbacaté imànica chènuníiri capìi, néese càmita yáalimá imáalàidaca imànicani’, càipiná náimaca, naicáaníca iquíniná. ");
INSERT INTO pioNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Péemìacué áiba comparación: Aiba nacuèrinásàiri iwàwacutácaalí imànica ùwicái áiba cáli íipunita, quéechacáwa yáawinacawa íináidacaténáwa cayába asáisí yàasu úwinái diez mil namanùbaca náalimácaalí namawènìadaca náichawa áiba cáli icuèriná yàasu úwinái veinte mil namanùbaca. ");
INSERT INTO pioNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Néese càmicaalí yáalimá imawènìadaca íichawa nía, yásí ibànùaca yàasu wenàiwicanáiwa áiba cáli icuèriná yàatalé, ipíchawáise yàanàaca mawiénita, nasutácaténá néemìawani càisimalénácaalí iyú iwàwacutá ipáyaidaca íichawani, yéewanápiná imàacaca nàyaca matuíbanáita. ");
INSERT INTO pioNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Càita nacái iwàwacutácué píináidacawa cáalíacáiri iyú asáisí píalimácaalícué pimànica càide iyúwa nuchùulìaná pía, yácáiná, càmicaalícué pimàaca piwàwawa íicha macáita pìasumica, néesecué canáca yéewanáwa nuéwáidacaléca pía”, íimaca nalí yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Jesús íimaca nalí: “Péemìacué comparación: Nuéwáidacalénái nàyaca machacàníiri iyú, namàni nacái cayábéeri. Càica níade iyúwa cayábéeri iwidùma, puìwéerica imànica yàacàsi yéewanápiná caséeca wenàiwica nayáacani. Néese càmicaalí quirínama puìwa iwidùmaca, yá càmita yáalimá puìwaca àniwani. ");
INSERT INTO pioNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Canéeri iwèni meedáni yái iwidùmaca. Càmita cayába cáli iríni. Càmita cayába irí nacái yáníi nàwacáidacataléca pìrái ìyami. Wáuca meedáni, yái iwidùmamica. Càita nacái iwàwacutácué pìyaca machacàníiri iyú, pimànicué cayábéeri nacái, píacué nuéwáidacaléca, yéewanápiná wenàiwica nawàwa neebáidaca yái báisíiri tàacáisica. Càuwíiyéicaalícué pía, péemìacué nutàacái”, íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Néenialíté madécaná yeedéeyéicaté plata néenánái judío íichawa Roma ìyacàlená yàasu gobierno irípiná, áibanái nacái báawéeyéi íiwitáise, nàacawa Jesús yàatalé, néemìacaténá itàacái. ");
INSERT INTO pioNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Néese abénaméeyéi fariseo, áibanái nacái yéewáidéeyéica wenàiwica templo irìcu, natàaníca báawéeri iyú Jesús ìwali. Náimaca Jesús ìwali: —‍Yái asìalica itàidaca cayába báawéeyéi íiwitáise, yá iyáaca iyáacaléwa náapicha —‍náimaca. ");
INSERT INTO pioNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Iná Jesús yéewáidaca nía comparación iyú. Yá íimaca nalí: ");
INSERT INTO pioNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Péemìacué comparación: Abéeri péenácué idènìacaalí cien namanùbaca ipìra ovejanáiwa, yá abéeri oveja iméeràacaalíwa, yásí náiwacali imàacaca ipìranáiwa noventa y nueve namanùbaca manacúalibàa yàacaténá icutáca oveja yúuquéericawa íicha àta yàanàacatalétani. ");
INSERT INTO pioNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Néese yàanàacaalíni, yásí casíimáiri iyú imichàidaca oveja iwáacutaléwa. ");
INSERT INTO pioNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Néese yàanàaca icapèe néréwa, yá ìwacáidaca yàacawéeyéináwa, áibanái nacái iyaquewéeyéicawa. Yá íimaca nalí: ‘Casíimáicué piwàwa núapicha, nudéca nùanàaca yái nupìra ovejawa yúuquéericatéwa nuícha’, càipiná íimaca yái oveja íiwacalináca”, íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Néese Jesús íimaca nalí: “Péemìacué cayába. Càita nacái abéeri wenàiwica iwènúadacaalí íiwitáisewa báawéeri íicha, yásí ángelnái ìyéeyéica chènuniré nayanídacawa abéeri wenàiwica ìwali manuísíwata íicha yái nayanídáanácawa noventa y nueve namanùbaca ìwali íináidéeyéicawa mabáyawanáca, íináidéeyéica nacáiwa càmita iwàwacutá nawènúadaca náiwitáisewa báawéeri íicha càide iyúwacué píináidáanáwa pìwaliwa. Iná yéewa cayábacata nàwacáidáyacacawa nùatalé níái yáaliéyéicawa cabáyawanáca nawènúadacaténá náiwitáisewa nabáyawaná íichawa”, íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Néeseté Jesús yéewáidaca nía comparación iyú. Yá íimaca nalí: “Inanái idènìacaalí diez namanùbaca moneda máiníiyéi cawènica yáawamíiyéi plata quírameníiri, néese abéechúa monedacaalí yúucawa uícha, yásí upucúadaca lámpara ucutácaténá moneda yúuquéechúacawa uícha. Yá utunúaca ucapèe irìcubàawa éeréeri iyú àta ùanàacataléta moneda cawèníichúaca. ");
INSERT INTO pioNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Néese ùanàacanáami úa, yá ùwacáidaca uyaquewéeyéiwa inanái, áibanái nacái ùacawéeyéináca inanáica. Yá úumaca nalí: ‘Casíimáicué piwàwa núapicha, nudéca nùanàaca cawèníichúa moneda yúuquéechúacatéwa nuícha’, úumaca nalí. ");
INSERT INTO pioNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Núumacué pirí, càita nacái casíimáica Dios yàasu ángelnái abéeri wenàiwica ìwali, cawinácaalí báawéericaté íiwitáise iwènúadéerica íiwitáisewa báawéeri íicha Dios irípiná”, íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Néeseté Jesús yéewáidaca nía àniwa comparación iyú. Yá íimaca nalí: “Càasuíri asìali idènìacaté yéenibewa pucháiba asìanái. ");
INSERT INTO pioNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Néese iméeréeri íimaca yáaniri iríwa: ‘Pápa, pìa nùasu yéená yái pìasucawa pièripináca nulí péetácaalípináwa’, íimaca yáaniri iríwa. Yá néese náaniri iwacùaca macáita yàasu yèewiwa nalí. ");
INSERT INTO pioNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Néesecáwa cawàwanáta máisiba èeri idénáami, iméeréeri iwéndaca íichawa yáaniri yàasuwa, yá itéca iwènináami, néese yàacawa déeculé áiba cáli néré. Yá yúucaca macáita yàasu platawa ìyacaténá máiní máiwitáiséeri iyú. ");
INSERT INTO pioNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Néese idécanáami yúucaca macáita, yá idàbaca canáca nayáacalé cachàiníiri iyú néenibàa. Yá iméeréeri idàbaca máapicani. ");
INSERT INTO pioNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Yá icutáca íibaidacalépináwa áiba asìali yáapicha yái cáli néeséeri. Yái asìali ichùulìaca iméeréeri yàacawa yàasu manacúaliré yàacaténá ipìra marranonái iyáapiná. ");
INSERT INTO pioNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Máiní iméeréeri iwàwaca iyáaca marranonái iyáacalé yéenáca anáica, quéwa càmita wenàiwica ibatàa iyáaca nía, ibatàa abéeri pináta, càmita nàa iyáapiná. ");
INSERT INTO pioNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Atata ùuculìiri idàbaca íináidacawa cáalíacáiri iyú àniwa. Yá íimaca iríwa: ‘Núaniri idènìaca yàasu wenàiwicawa manùbéeyéi. Nadènìa nayáacaléwa cayábata, imàacaca nacáiwa nalí manuí. Quéwa, núa chái nuétácawa máapicái iyú. ");
INSERT INTO pioNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","19","Siùcade nuèpùacawa núaniri icapèe néréwa àniwa. Yá núumapiná iríwa: Pápa, nudéca numànica Dios irí báawéeri, pirí nacái. Siùcade càmita quirínama cayábaca nuíwitáise, íná canáca yéewaná quirínama núumáanápiná pirí núanirica píata. Pimàaca nùyaca càide iyúwa pìasu wenàiwica, yásí nuíbaidaca pirí, càipiná núumaca núaniri iríwa’, íimaca íináidacawa iríwa yái iméeréerica. ");
INSERT INTO pioNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Iná yàacawa, yèepùacawa yáaniri icapèe néréwa. “Quéwa déecuísecaalí tàacáwani, yá yáaniri iicácani. Yá catúulécanáca iicáca ìiriwa. Yá yáaniri ipìacawa íipunitáidaca ìiriwa. Yá yàanalìcuca ìiriwa itàidaca cayábani. Isùsùaca ìiri inàni ìwaliwa càide iyúwa náiwitáise natàidáaná wenàiwica cáininéerica naicáca. ");
INSERT INTO pioNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Néese yái ìiri iméeréeri íimaca yáaniri iríwa: ‘Pápa, nudéca numànica Dios irí báawéeri, pirí nacái. Siùcade càmita quirínama cayába nuíwitáise, íná canáca yéewaná quirínama núumáanápiná pirí núanirica píata’, íimaca. ");
INSERT INTO pioNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Yáanirita quéwa íimaca yàasu wenàiwicanái iríwa: ‘Caquialétacué, peedácué ibàlepiná cayábanaméeri áiba bàlesi íicha. Pìwalicué ìwalini. Pìwalicué anillo icáapi íiduná ìwali. Pìwalicué nacái izapatonipiná yàabàli ìwali. ");
INSERT INTO pioNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Peedácué nacái pacá íidu walíibèechúaca. Pinúacué wayáapináni. Siùcade wamànicué fiesta. ");
INSERT INTO pioNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Yácáiná nuìrica, nuyúunáidéericaté yéetácatéwa nuícha, siùca quéwade idéca yèepùacawa nùatalé àniwa. Yúucacatéwa nuícha, quéwa siùca nudéca nùanàaca àniwani’, íimaca nalí yái yáanirica. Néese nadàbaca namànica fiesta. ");
INSERT INTO pioNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Idècunitàacá namànica fiesta, yá ìiri béeri íibaidaca yèepunícawa yáaniri yàasu manacúali néenibàawa. Yá yèepùaca yàacawa capìi nérépiná, yásí yéemìaca namànica música, abénaméeyéi nacái nalabàaca casíimáiri iyú. ");
INSERT INTO pioNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Yái ìiri béerica imáidaca yàataléwa abéeri íibaidéeri. Yá isutáca yéemìawa càinácaalí namàníiná capìi irìcu. ");
INSERT INTO pioNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Yá íibaidéeri íimaca irí: ‘Idéca yèepùacawa néese àniwa piméeréerica, íná píaniri idéca ichùulìaca nanúanápiná wayáapiná pacá íidu walíibèechúa yáwanái, yácáiná piméeréeri idéca yàanàaca cayábata’, íimaca irí. ");
INSERT INTO pioNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Néese calúacani, yái ìiri béerica. Càmita iwàwa iwàlùacawa capìi irìculé, íná iwàwacutá yáaniri imusúacawa isutácaténá íicha iwàlùanápináwa néré náapicha. ");
INSERT INTO pioNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Quéwa ìiri béeri càmita yeebá, yá íimaca yáaniri iríwa: ‘Nudéca nuíbaidaca pirí madécaná camuí. Nudéca numànica mamáalàacata càide iyúwa pichùulìaná numànica. Canácatáita pìa nulí ibatàa abéeri cabra achúméeríinapináta, numànicaténá fiesta nùacawéeyéiná yáapichawa. ");
INSERT INTO pioNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Siùca idéca yàanàaca yái pìirica, yúuquéericaté macáita pìasu platami máaléquéeri iyú nalípiná inanáica iiméeyéica asìanái yáapicha plata ìwalinápiná, yá pidéca pinúaca irí iyáapiná pacá íidu walíibèechúa’, íimaca yái ìiri béerica. ");
INSERT INTO pioNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Néese yáaniri íimaca irí: ‘Nuìri. Pidéca piyamáacawa núapicha càiripináta. Pìasucata macáita yái nudènièrica. ");
INSERT INTO pioNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Siùcade quéwa máiní cayábaca wamàníináca fiesta, casíimáica nacái wía. Piméeréericáiná idéca yàanàaca, yái ìyéericaté càide iyúwa yéetéerimiwa, quéwa idéca yèepùacawa wàatalé càide iyúwa idéca nacáicaalí yèepùacawa cáuca àniwani; yúucacatéwa nuícha, yá wadéca wàanàaca àniwani’, íimaca yái yáanirica. Càita nacái Dios itàidaca cayába cawinácaalí wenàiwica iwènúadéerica íiwitáisewa ibáyawaná íichawa”, íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Néeseté Jesús yéewáidaca yéewáidacalénáiwa comparación iyú. Iimaca nalí: “Iyacaté abéeri náiwacali càasuíri. Idènìaca yàasu wenàiwicawa icuèrica càasuíri yàasu cawèníiri. Yá áibanái nàanàaca nacháawàaca yàasu wenàiwica iináwaná ìwali yái wenàiwicaca icuèrica íiwacali yàasuwa. Náimaca yúucáanása meedá íiwacali yàasu platawa máiwitáiséeri iyú. ");
INSERT INTO pioNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Néese íiwacali imáidaca yàataléwani. Yá íiwacali íimaca irí: ‘Nudéca nuémìaca piináwaná piúcaca nùasu plata. Siùcade pichùnìa nùasuwa picàlidacaténá nulí macáita píibaidacalé ìwaliwa càmicáiná nubatàa picùaca nùasu quirínama’, íimaca yái íiwacalica. ");
INSERT INTO pioNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Néese yái asìali yàacawa íiwacali íichawa. Yá íimaca iríwa: ‘¿Càinásica numàni siùcade nuíwacali iwàwacáiná yúucaca núa? Canáca nuchàini nubànacaténá nubànacalewa. Báica nacái nusutáca plata áibanái íicha nuwènièripiná iyú nuyáapináwa. ");
INSERT INTO pioNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Uwé, siùca núalíacawa càinácaalí numàníinápiná àniwa yéewanápiná áibanái yeedáca yàataléwa núa, idécanáami nuíwacali yúucaca núa’, íimaca iríwa. ");
INSERT INTO pioNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Néese yái asìali imáidaca wenàiwica imawènièyéica íiwacali íicha plata nàanàanápiná abéerinamata namanùbaca iyúwa. Yá íimaca idàbáanéeri irí: ‘¿Càisimaléná pimawènìa nuíwacali íicha?’ íimaca. ");
INSERT INTO pioNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Néese idàbáanéeri wenàiwica íimaca: ‘Numawènìa píiwacali íicha cien namanùbaca yàalu olivo iséená’, íimaca. Néese íiwacali yàasu wenàiwica íimaca irí: ‘Cháta ìyaca pimawènìacáleca cuyàluta ibáiná irìcu. Piúca meedáni. Ara, píawinacàatétawa pitànàa àniwa áiba cuyàluta ibáiná irìcu cincuenta namanùbaca pimawènìanápiná nuíwacali íicha meedá. Yásí iwàwacutá pèepùadaca irí cincuenta namanùbaca meedá’, íimaca irí. ");
INSERT INTO pioNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Néese yái íiwacali yàasu wenàiwicaca íimaca áiba irí: ‘¿Néeni pía? ¿Càisimaléná pimawènìa?’ íimaca irí. Yái áiba asìali íimaca irí: ‘Cien namanùbaca yàalu trigo ituíná’, íimaca irí. Néese íiwacali yàasu wenàiwica íimaca irí: ‘Cháta ìyaca pimawènìacáleca cuyàluta ibáiná irìcu. Piúca meedáni. Pitànàa áiba cuyàluta ibáiná irìcu àniwa ochenta namanùbaca pimawènìanápiná íicha meedá. Yásí iwàwacutá pèepùadaca irí ochenta namanùbaca meedá’, íimaca irí. Càita imànica náapicha macáita wenàiwica imawènièyéica íiwacali íicha yàasusi. ");
INSERT INTO pioNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Néese yái íiwacali yáalíacawa bàsabàsaca yàasu wenàiwica íiwita, yái báawéerica íiwitáise icuèricaté íiwacali yàasuwa, iwènúadacáiná namawènìacále. Nudéca nucàlidacuéca pirí yái comparaciónca píalíacaténáwa máiníiyéi cáalíacáica èeri mìnanáica càmíiyéica yeebáida Dios itàacái namànicaalí wawàsi nanacáiyéi yáapichawa, cáalíacáica nía píichacué, píacué yeebáidéeyéica Dios itàacái. ");
INSERT INTO pioNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","“Iná nùalàacuéca pía pimàníinápinácué cayábéeri áibanái irí pìasu plata iyúwa, yéewanápinácué cáinináca naicáca píawa. Néesecáwa, plata imáalàacaalípináwa píichacué, yásí needácué nàataléwa pía aléera chènuniré nàyacatalé càmíirica imáalàawa. ");
INSERT INTO pioNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Aiba wenàiwica icùacaalí achúméeri wawàsi machacàníiri iyú, yá icùapináca cayába nacái manùba wawàsi. Quéwa imànicaalí ibáyawanáwa idènìacaalí achúmanamata, yá imànipináca ibáyawanáwa nacái idènìacaalí manùba. ");
INSERT INTO pioNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Iná càmicaalícué pimàni cayábéeri pìasu plata iyúwa chái báawéeri èeri irìcu, néese càmitacué namàacapiná picùaca báisíiri cawèníirica ìyéerica chènuniré. ");
INSERT INTO pioNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Néese àniwa càmicaalícué picùa áibanái yàasu machacàníiri iyú, néese càmita nàacué pirí pìasusíwapináwa. ");
INSERT INTO pioNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Péemìacué comparación: Canácata yàasu wenàiwica yáaliméeri imànica machacàníiri iyú càide iyúwa íiwacanánái pucháiba ichùulìaná imànica, báawacáiná iicáca abéeri íiwacaliwa, cáinináta quéwa iicáca íiwacaliwa áiba. Càmicaalí nacái, néese yàapiná íiwacali áiba icàaluínináwa, quéwa caná iwèni meedá iicápiná íiwacali áibawa. Càita nacái càmitacué pidé píibaidaca cayába Píiwacali Dios irípináwa càide iyúwa iwàwáaná cáininácaalícué piicáca plata”, íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Néese abénaméeyéi fariseo cáininéeyéica iicáca plata, néemìacáiná macáita Jesús íimáaná plata ìwali, íná naicáaníca Jesús iquíniná. ");
INSERT INTO pioNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Quéwa Jesús íimaca nalí: “Pidécuéca picàlidaca piináwaná ìwaliwa wenàiwicanái irí cayábáanása píiwitáise. Neebáidacué nacái pichìwa. Quéwa Dios yáalíacuécawa píiwitáise ìwali, càinácaalí ìyáaná. Casíimáica èeri mìnanái iicácuéca píiwitáise báawéeri, quéwa Dios iicácuéca píiwitáise iyúwa yáaséerimi isàni meedá”, íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Jesús íimaca: “Bàaluité iwàwacutá wenàiwica neebáidaca iyúwa profeta Moisés itànàanáté tàacáisi Dios inùmalìcuíse, iyúwa nacái profetanái itànàanáté Dios itàacái. Càité ìyaca àta Juan el Bautista yàanàacatalétaté. Néese Juan, núa nacái wadéca wacàlidaca wenàiwicanái iríni yái cayábéeri tàacáisica náalíacaténáwa càinácaalí iyú Dios icùaca yàasu wenàiwicawa. Siùca madécaná wenàiwica nawàwa nàuwichàidaca Dios yàasu wenàiwica yeebáidéeyéica yái tàacáisica. ");
INSERT INTO pioNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","“Quéwa máiníiri cayábacani yái Dios itàacái bàaluisàimica profeta Moisés, áibanái profeta nacái natànèericaté Dios inùmalìcuíse. Macáita ichàbapinácawa càiwade iyúwaté Dios itàacái íimáaná. Aibaalípiná Dios imáalàidapiná capìraléeri cáli, yá nacái èeriquéi. Néese càmíiripináta itàacái bàaluisàimi imáalàapináwa, ibatàa abéeri letra achúméeríina pináta, canácatáita imáalàawa. Macáita ichàbapinácawa càiwade iyúwaté Dios itàacái íimáaná”, íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Jesús íimaca: “Asìali imàacacaalí íichawa íinuwa, néese yeedácaalí iríwa áiba, imànica ibáyawanáwa, iimácáiná áiba inanái yáapicha càmíichúaca íinusíwa. Aiba asìali yeedácaalí íinupináwa abéechúa namàaquéechúami, imànica ibáyawaná nacáiwa, iimácáiná úapicha, úara áiba asìali íinuca”, íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Néeseté Jesús yéewáidaca nía àniwa. Yá íimaca nalí: “Iyacaté càasuíri asìali. Cayábanaméeri ibàle iicácanáwa cawèníiri nacái. Macái èeri imanùbaca imànica fiesta máiníiri cawènica. ");
INSERT INTO pioNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Iyacaté nacái catúulécanéeri asìali cacháunéeri ìwalíise íipidenéeri Lázaro. Yái Lázaro yáawinacawa càasuíri icapèe inùmalìcu. ");
INSERT INTO pioNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Yái catúulécanéerica iwàwacaté iyáaca àta càinácaalí yàacàsi ituériwa càasuíri yàasu mesa íinatáise. Aulinái nacái nàanàaca Lázaro yàatalé nabèrùacaténá icháuná ituí yái catúulécanéerica. ");
INSERT INTO pioNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Aiba èerité, catúulécanéeri yéetácawa. Yá ángelnái itécani ìyacaténá paraíso irìcu, aléera Abraham yàatalé Dios yáapicha. Yá nacái càasuíri yéetácawa. Yá nabàlìacani, yái càasuírimica. ");
INSERT INTO pioNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","“Yái càasuírimica yùuwichàacawa mamáalàacata néenibàa báawéeyéimi nàacatalépinácawa néetácaalíwa, íipidenácatalé infierno. Càasuírimi iicáidaca déeculé, yá iicáca Abraham, Lázaro nacái, ìyéeyéica Dios yáapicha paraíso irìcu. ");
INSERT INTO pioNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Iná yái càasuírimica imáidaca cachàiníiri iyú Abraham irí. Yá íimaca Abraham irí: ‘¡Nùawiri, Abraham, piicá nupualé! Pibànùa síisa Lázaro nùatalé idupíadacaténá úni nunène ìwali icáapi iyúwa, nùuwichàacáináwa báawanama chái quichái irìcu’, íimaca. ");
INSERT INTO pioNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Quéwa Abraham íimaca irí: ‘Pía nutaquérinámica, iwàwacutá piwàwalica pìyáanáté máiní cayábéeri iyú idècunitàacá cáuca pía, quéwa yái Lázaroca ìyacaté máiní catúulécanéeri iyú, idècunitàacá cáucani. Siùca Lázaro ìyaca cayába chái, píata quéwa yùuwichèeriwa ìyaca néenibàa. ");
INSERT INTO pioNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Càmita núalimá nubànùaca pìatalé Lázaro, ìyacáiná manuíri yàawa nacáiri depuíwéeri béecaná chái bamuchúamicué wáicha, pía, wía nacái. Iná canáta yéewaná náalimá nachàbacawa aléera. Píacué nacái síisaara, càmitacué píalimá pìacawa síisa nacáira’, íimaca yái Abrahamca. ");
INSERT INTO pioNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","28","“Néese càasuírimi íimaca àniwa: ‘Uwé, néese pimàni nulí cayábéeri, pía nùawiri Abraham, pimàaca Lázaro imichàacawa yéetácáisi íicha, yá pibànùa Lázaro núaniri icapèe nérépiná. Nàyaca néeni cinco namanùbaca nuénánái. Pichùulìa Lázaro yàalàanápiná nuénánái ipíchaná nàacawa aléi yùuwichàacáisi irìculé’, íimaca yái càasuírimica. ");
INSERT INTO pioNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Quéwa Abraham íimaca irí: ‘Péenánái nadènìaca Dios itàacái profeta Moisés itànèericaté bàaluité, profetanái itànèericaté nacái Dios inùmalìcuíse. Iwàwacutá péenánái yeebáidaca natàacái’, íimaca yái Abrahamca. ");
INSERT INTO pioNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Néese yái càasuírimica íimaca: ‘Báisíta, quéwa iwàwacutácawa nalí áiba wawàsi quiríta. Lázaro imichàacaalíwa yéetácáisi íicha imàacacaténá yáawawa naicácani, yásí nawènúadaca náiwitáisewa báawéeri íicha’, íimaca yái càasuírimica. ");
INSERT INTO pioNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Quéwa Abraham íimaca irí: ‘Càmicaalí neebáida Dios itàacái càide iyúwa Moisés, profetanái nacái natànàanáté, néese càmita nacái neebáidapiná Dios itàacái, éwita yéetéerimiwa imichàacaalíwa yéetácáisi íicha yàalàacaténá nía’, íimaca yái Abrahamca”, íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Néeseté Jesús íimaca yéewáidacalénái iríwa: “Macái èeri imanùbaca ìyaca madécaná wawàsi imàaquéerica wenàiwica nawàwaca namànica nabáyawanáwa. Quéwa, ¡máiní Dios yùuwichàidapiná cawinácaalí wenàiwica yéewáidéerica áibanái namànicaténá nabáyawanáwa! ");
INSERT INTO pioNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Aibacaalí wenàiwica iméeràidaca áibanái namànicaténá nabáyawanáwa, yásí Dios yùuwichàidapiná manuísíwatani. Cayába cachàini irítáni yéetácaalíwatá ipíchawáise iméeràidaca wenàiwica. Aibanái idacùacaalí manuíri íba icanápi ìwalíise, náucacaténáni manuíri úni yáaculé isawíacaténáwa, yásí ìisicùmacawa. Quéwa ìyacaalí mamáalàacata chái èeri irìcu, néese iméeràidacaalí sùmanái namànicaténá nabáyawanáwa, yá máiní cachàiníwanái yùuwichàapinácawa áibanái íicha infierno irìcu. Iná cayába cachàini irítáni yéetácaalíwatá ipíchawáise iméeràidaca púubéeyéi. ");
INSERT INTO pioNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","¡Piicácué píichawa cayába piméeràidacáichacué púubéeyéi Dios íicha namànicaténá nabáyawanáwa! “Aibacaalí imàni pirí báawéeri, pitàaní yáapicha ìwali. Néese iwènúadacaalí íiwitáisewa báawéeri íicha, pimàaca piwàwawa íicha yái báawéerica imàníirica pirí. ");
INSERT INTO pioNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ewita imànicaalí pirí báawéeri siete imanùbaca yàawiría abé èeri irìcu, yá yàanàacaalí pìatalé siete imanùbaca yàawiría nacái, yá íimacaalí pirí: ‘Càmita quirínama numàni pirí báawéeri àniwa’, càicaalí íima pirí, iwàwacutá pimàacaca piwàwawa íicha yái báawéerica imàníirica pirí”, íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Néese apóstolnái nasutáca Wáiwacali íicha wawàsi. Náimaca irí: —‍Piyúudàa wía manuícaténá wáináidacawa wawàwawa pìwali cachàiníiri iyú mamáalàacata —‍náimaca. ");
INSERT INTO pioNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Néese Wáiwacali íimaca nalí: —‍Càmitàacáwacué manuí píináidacawa piwàwawa nùwali, ibatàa achúméeríina iyúpináta. Manuícaalícué píináidacawa nùwali achúméeríina iyútá, càide iyúwa mostaza íimíinaca achúméeríina ìyáaná, yásí yéewanápinácué cài píimaca irí yái manuíri morera yéetanácatá: ‘Piwatàa píawawa cáli íicha, néese pibàna píawawa manuíri úni yáaculé’, yásí àicu imànica càide iyúwacué píimáaná irítá —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Néeseté Jesús yéewáidaca nía àniwa comparación iyú, yá íimaca nalí: “Abéeri náiwacali idènìacaalí yàasu wenàiwicawa ichùnièrica bànacalé yáapíise, cawàwanáta nacái icùaca íiwacali ipìrawa, néese idécanáami íibaidaca, yá yèepùacawa bànacalé néese, yá iwàlùacawa íiwacali icapèe irìculéwa. Néese, íiwacali càmita íima yàasu wenàiwica iríwa: ‘Caquialéta, píawinawa, piyáa piyáacaléwa’, càmita cài íima. ");
INSERT INTO pioNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Néese íiwacali íimapiná irí meedá: ‘Pichùnìa nuyáapiná. Pìwali cayába pibàlewa pitécaténá nulí nuyáapiná, idècunitàacá nuyáaca nuyáacaléwa. Néesecáwa idécanáami nuyáaca nuyáacaléwa, yásí numàaca piyáaca piyáacaléwa’, càipiná íimaca yái íiwacalica yàasu wenàiwica iríwa. ");
INSERT INTO pioNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Càmita nacái íiwacali yàaca cayábéeri tàacáisi yàasu wenàiwica iríwa idécanáami imànica càide iyúwa íiwacali ichùulìanáni, yàasu wenàiwicacáiná meedáni, íná iwàwacutá íibaidaca íiwacali iríwa càide iyúwa ichùulìaná imànica. ");
INSERT INTO pioNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Càita nacái idécanáamicué pimànica macáita càide iyúwa Dios ichùulìanácué pía, picácué cáimacái piicáca píawawa ìwalíise, néese píimacué Dios irí: ‘Wíacata pìasu wenàiwicanái canéeyéica iwèni meedá. Wadéca wamànica càide iyúwa iwàwacutáaná wamànica, càide iyúwa pichùulìaná wamànica’, càicué píima Dios iríwa”, íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Néeseté Jesús idècunitàacá yàacawa Jerusalén ìyacàlená nérépiná, yá yèepunícawa bamuchúamibàa náicha Samaria yàasu cáli, Galilea yàasu cáli nacái. ");
INSERT INTO pioNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Jesús yàanàacaté mawiénita áiba yàcalé irí, yá diez namanùbaca asìanái cacháunéeyéi íimami lepra iyú nàanàaca Jesús íipunita. Déecuíseta quéwa nabàlùacawa Jesús íicha, càmicáiná judíonái ibatàa nàanàaca mawiénita áibanái irí. ");
INSERT INTO pioNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Yá namáidaca cachàiníiri iyú Jesús irí: —‍¡Pía Jesús, Wáiwacali, catúulécaná piicáca wía! —‍náimaca Jesús irí. ");
INSERT INTO pioNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Jesús iicáca nía, yá íimaca nalí: —‍Pìacué pimàacaca sacerdotenái iicáca píimami náalíacaténáwa pidécuéca pichùnìacawa —‍íimaca nalí. Yá idècunitàacá nàacawa, yá ichàbacawa náicha yái uláicáica. ");
INSERT INTO pioNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Yá abéeri néená níái cacháunéeyéimica iicácáiná masacàaca íimami lepra íicha, íná yèepùacawa Jesús yàatalé. Idècunitàacá yèepùacawa, yàaca cayábéeri Dios irí cachàiníiri iyú. ");
INSERT INTO pioNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Yàanàaca Jesús yàatalé, yá ibàlùacawa yùuluì ipùata iyúwa Jesús irí. Yáawiada inàniwa cáliaculé yàacaténá Jesús icàaluíniná, yàacaténá nacái irí cayábéeri. Yái asìali Samaria yàasu cáli néeséerica, càmíirica judío. ");
INSERT INTO pioNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Yá néeseca Jesús íimaca yéewáidacalénái iríwa: —‍Nudéca nuchùnìacáwa diez namanùbaca cacháunéeyéi. Níara nueve namanùbacaca càmita nèepùawa, éwita israelitacáaníta nía, nàacaténá cayábéeri Dios irí. ");
INSERT INTO pioNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Abéerita yái càmíirica judío yèepùacawa nùatalé yàacaténá cayábéeri Dios irí —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Néese Jesús íimaca Samaria yàasu cáli néeséeri irí: —‍Pimichàawa. Pìawa. Uláicái idéca ichàbacawa píicha, peebáidacáiná nulí —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Fariseonái nasutáca néemìawa Jesús càicaalínápinácaalí Dios icùa macáita wenàiwicanái. Néese Jesús íimaca nalí: —‍Càmitacué píalimá piicáca càinácaalí iyú Dios icùaca wenàiwicanái. ");
INSERT INTO pioNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Càmita náimapiná: ‘Piicácué, Dios icùaca wenàiwica chái cáli’; càmita nacái náimapiná: ‘Aiba cáli íinata nacái Dios icùaca wenàiwica’, càmita náimapiná càmicáiná náalimá naicáca natuí iyúwani càinácaalí iyú Dios icùaca yàasu wenàiwicanáiwa, icùacáiná náiwitáise, icùa nacái abéechúanaméeyéi wenàiwica pèewibàa —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Néese Jesús icàlidacaté yéewáidacalénái iríwani: —‍Máadáinícuéca piwàwa piicáca núa áiba èeriwa, éwitasica píalimácaalí piicáca núa abé èeri piná meedátá, piwàwapinácuéca piicáca núa, núa asìali Dios néeséerica. Máinícué piwàwapiná piicáca nùanàaca nucùacaténá macáita, quéwacué càmitàacá piicápiná núa. ");
INSERT INTO pioNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Aibanái nacàlidapiná nachìwawa, náimapiná nudécasa nùanàaca. Náimapináca: ‘Mesías idéca yàanàaca chái’; áibanái náimapinácué pirí: ‘Mesías idéca yàanàaca néré’. Quéwa picácué pìawa néré, picácué nacái pìawa náapicha. ");
INSERT INTO pioNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Péemìacué, nùacaalípináwa néese àniwa, yásí macái èeri mìnanái naicápiná nucànacawa amaláwaca, càide iyúwa énu icànáaná macáita capìraléeri cáli ìwali chènuniré èeri imusúacatáisewa àta èeri iwàlùacataléwa. Càipiná nacái nùacawa néese àniwa nuénáiwaná yàanàacatáiwa, núa asìali Dios néeséerica. Càmita nùawa ibàacanéeri iyúwa. ");
INSERT INTO pioNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Quéwa iwàwacutá nùuwichàacawa manuísíwata quéechacáwa, yá iwàwacutá èeri mìnanái ìyéeyéica siùca báawaca naicáca núa càiride iyúwa canéeri iwèni meedá. ");
INSERT INTO pioNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Mawiénicaalípiná nuénáiwaná nùanàacatáipiná àniwa, núa asìali Dios néeséerica, yásí wenàiwicanái nàyapiná càide iyúwaté èeri mìnanái ìyáaná Noé yàasu èerité. ");
INSERT INTO pioNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Matuíbanáicaté nàyaca Dios íicha bàaluité. Nayáacaté nayáacaléwa, néese nàiraca nacái, needácaté náinupináwa, àta Noénái iwàlùacatalétawa arca irìculé. Yáté manuíri yéesacái yàanàaca, yá néetácatéwa macáita wenàiwica càmíiyéicaté iwàlùawa Noénái yáapicha arca irìculé. ");
INSERT INTO pioNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Càité nacái Lot yáapichéeyéimi Sodoma ìyacàlená mìnanái nàyacaté matuíbanáita Dios íicha. Nayáacaté nayáacaléwa, nàiraca nacái nàiracaléwa. Nawènìa nacái nàasupináwa. Nabànacaté nabànacalewa, nawénda nacái nàasuwa. Namànicaté nacái nacapèewa. ");
INSERT INTO pioNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Quéwa idécanáamité Lotnái namusúacawa Sodoma ìyacàlená íicha, yáté quichái yèewièricawa azufre yèewi yúuwàacatéwa chènuníise Sodoma mìnanái ìwali. Yáté néetácawa macáita. ");
INSERT INTO pioNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Càita nacái yùuwichàacáisi yàanàapináwa ráunamáita èeri mìnanái ìwali áibaalípiná numàacacaalípiná núawawa naicáca núa, núa asìali Dios néeséerica. ");
INSERT INTO pioNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Néenialípiná áibacaalí iyamáidapináwa ìyaca icapèe ipùata sàabadéeri íinatabàawa, idènìacaalí nacái yàasuwa capìi irìcu, iwàwacutá càmita yèepùa iwàlùacawa icapèe irìculéwa yeedácaténá yàasuwa ipíchawáise ipìacawa Jerusalén ìyacàlená íicha. Aibacaalí nacái yèepunípináwa manacúalibàa, iwàwacutá càmita yèepùawa icapèe néréwa ipíchawáise ipìacawa Jerusalén ìyacàlená íicha. ");
INSERT INTO pioNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Piwàwalicué càinácaalíté Lot íinumi yéetácawa, cáininéechúacaté iicáca yàasumiwa èeri irìcuírica, úái yéetéechúamicatéwa càmicáináté upìacawa yàcalé íicha càide iyúwaté Dios yàalàaná úa. ");
INSERT INTO pioNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Cawinácaalí càmíirica yeebáida nutàacái iwàwacáiná icùaca icáucawa chái èeri irìcu, yúucapiná icáucawa càmíiri imáalàawa, quéwa cawinácaalí yeebáidéerica nutàacái mamáalàacata éwita áibanái inúacaalíni, idènìapiná icáucawa càmíiri imáalàawa. ");
INSERT INTO pioNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","“Néese núumacué pirí nùanàacaalí táiyápi, yá pucháiba wenàiwica naimápiná nàyaca cama irìcu. Angelnái itépiná abéeri wenàiwica, áibapiná nacái imàacawa néenita. ");
INSERT INTO pioNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Yá pucháiba inanái namulúapináca nàyaca ituínási. Angelnái itépiná abéechúa inanái, abéechúapiná nacái imàacawa néenita. ");
INSERT INTO pioNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Pucháiba asìanái yèepuníiyéipinácawa manacúalibàa. Angelnái itépiná abéeri asìali, abéeripiná nacái imàacawa néenita —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Néese yéewáidacalénái nasutáca néemìawa Jesús: —‍Wáiwacali, ¿chábàanásica nàanàa needácaténá nía? —‍náimaca. Néese Jesús íimaca nalí: —‍Màulenéeri iyú piicápinácué chábàanácaalí nàacawa càide iyúwacué píalíanáwa chábàanácaalí yéetéerimiwa irìawa piicácaalí manùbéeyéi wáchuli nàwacáidáyacacawa —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Néeseté Jesús yéewáidaca nía comparación iyú náalíacaténáwa iwàwacutáaná nasutáca Dios íicha mamáalàacata, yàalàacaténá nía nacái ipíchaná naméyáacawa nasutáca Dios íicha. ");
INSERT INTO pioNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Yá Jesús íimaca nalí: “Iyacaté juez áiba yàcalé irìcu. Càmita yàa Dios icàaluíniná. Càmita nacái yàa wenàiwica íimiétacaná. ");
INSERT INTO pioNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Uyacaté nacái yàcalé irìcu abéechúa inanái inìrimi yéetéechúamicatéwa íicha. Aiba wenàiwica iwàwacaté yeedáca uícha ùacawéeri yàasumi. Iná usutáca juez íicha wawàsi manùba yàawiría iyúudàanápiná úa. Yá úumaca juez irí: ‘Piyúudàa núa. Pichùulìa nàuwichàidáanápiná nuícha nùuwideca yeedéerica nuícha nùacawéeri yàasumi’, úumaca juez irí. ");
INSERT INTO pioNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","5","Manùba èeri càmita juez yeebá usutáaná íicha. Néese maséeca iwàwa idècuni yéemìaca usàna. Yá íimaca iríwa: ‘Ewita càmicáaníta nùa Dios icàaluíniná, éwita nacái càmicáaníta nùa wenàiwicanái íimiétacaná, càicáaníta siùcade nuyúudàaca úara inanáica, nùuwichàidaca uícha ùuwide, máinícáiná usàiwicaca nulí wawàsi, ipíchaná ùanàaca mamáalàacata, yá usàiwica nulí wawàsita àta nuétácatalétawa’, càica íimaca iríwa yái juez báawéerica íiwitáise”, íimaca nalí yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Yá Wáiwacali íimaca nalí àniwa: “Pidécuéca péemìaca itàacái yái juez báawéerica íiwitáiseca. Ewita báawéericáaníta íiwitáiseni, càicáaníta átata iyúudàaca manìríichúami. ");
INSERT INTO pioNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Néeni, ¿càmitasicué píalíawa cayábéeri Dios íiwitáise? Iná iwàwacutácué píalíacawa Dios iyúudàapiná cawinácaalí wenàiwica Dios yeedéeyéica yàasunáipináwa, cawinácaalí isutéeyéica yáawawa íicha manuísíwata mamáalàacata èeríapinama, táiyápinama nacái. Yá Dios imawènìadapiná náicha nacái nàuwidenái. Càmita Dios idècunìapináwa déecuíri iyú iyúudàanápiná nía. ");
INSERT INTO pioNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Núumacué pirí, Dios iyúudàapiná níawa caquialéta, imawènìadapiná náicha nàuwidenái. Núa asìali Dios néeséerica, nùanàapiná àniwa aléi èeri irìculé, quéwa càmita nùanàapiná manùbéeyéi yeebáidéeyéica nutàacái mamáalàacata”, íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Néeseté Jesús yéewáidaca abénaméeyéi wenàiwica comparación iyú, níara cachàiníiyéica iicáca yáawawa nayúunáidacáiná mabáyawanéeyéica nía, íná báawaca naicáca náichawa áibanái wenàiwica. Jesús íimaca nalí: ");
INSERT INTO pioNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Pucháiba asìanái nàacatéwa templo irìculé nasutácaténá níawawa Dios íicha. Abéeri fariseo, áiba asìali nacái yeedéeri plata yéenánái judío íichawa Roma ìyacàlená yàasu gobierno irípiná. ");
INSERT INTO pioNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","12","Yái fariseo ibàlùacawa abéerita méetàucuta áibanái íicha, isutáca yáawawa Dios íicha. Cài íimaca: ‘Pía Dios, nùaca pirí cayábéeri núacáiná càmíirica iyúwa áibanái wenàiwica canánama. Núa nacái càmita nuyéedùa. Càmita báawa nuíwitáise nacái. Càmita nuimá áiba inanái yáapicha càmíichúaca nuínusíwa. Càmita numàni nubáyawanáwa càide iyúwa imàníiná yái asìali yeedéerica wáicha plata romanonái yàasu gobierno irípiná. Núa nacái numàaca nuíchawa nuyáacaléwa pucháiba èeri semana ìwali nusutácaténá Dios íicha. Macái néená níái diéyéica wawàsi nuedéerica nulíwa, numàaca abéeri néená Dios irípiná ofrenda iyú’, cài íimaca ìwaliwa yái fariseoca. ");
INSERT INTO pioNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Néeseta quéwa yái asìalica yeedéerica plata yéenánái judío íichawa romanonái yàasu gobierno irípiná, yáta ibàlùacawa déecuíseta fariseo íicha. Máinícáiná báica iicáca yáawawa Dios iwéré ibáyawaná ìwalíisewa, íná càmita iicáida chènuniré. Néese, ibàbàida yùucutawa mamáalàacata icáapi iyúwa máinícáiná achúmaca iwàwa ibáyawaná ìwaliwa. Yá íimaca mamáalàacata Dios irí: ‘Pía Dios, piicá nupualé, cabáyawanéerica núaquéi’, cài íimaca isutáca Dios íicha”, íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Néese Jesús íimaca nalí àniwa: “Núumacué pirí, Dios imàacacaté iwàwawa ibáyawaná íicha, yái asìali yeedéerica plata yéenánái íichawa romanonái yàasu gobierno irípiná, néese asìali yèepùacawa matuíbanáita icapèe néréwa. Quéwa yái fariseoca, càmita Dios imàaca iwàwawa ibáyawaná íicha, níacáiná cawinácaalí wenàiwica icàlidéeyéica iináwaná ìwaliwa máiníinása cayábaca nía áibanái íicha, Dios imàacapiná báica nía. Cawinácaalí quéwa icàlidéeyéica íichawa ibáyawanáwa, Dios imànipiná irí cayábéeriwa”, íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Néeseté àniwa áibanái natéca néenibewa púubéeyéi Jesús yàatalé yéewacaténá Jesús imàacaca icáapiwa nàwali, isutácaténá nalí Dios íicha imàníinápiná nalí cayábéeri. Quéwa, Jesús yéewáidacalénái naicáca nía, yá nadàbaca nacuísaca náichawa wenàiwica itéeyéica yéenibewa Jesús yàatalé, yéewáidacalénái náimaca sùmanái nasàiwicasa Jesús irí wawàsi. ");
INSERT INTO pioNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Quéwa Jesús imáidaca sùmanái nàanápináwa yàatalé. Yá íimaca yéewáidacalénái iríwa: —‍Pimàacacué sùmanái yàacawa nùatalé, picácué pimáisanìa nàanàaca, Dioscáiná icùaca wenàiwica yeebáidéeyéica itàacái càide iyúwa sùmanái yeebáidáaná náaniri itàacáiwa. ");
INSERT INTO pioNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Péemìacué cayába, iwàwacutá wenàiwica neebáidaca Dios itàacái càide iyúwa púubéeyéi sùmanái yeebáidáaná náaniri itàacáiwa. Càmicaalí wenàiwica neebáida cài, néese canácatáita Dios yéenibeca nía —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Néeseté abéeri judío íiwacaliná isutáca yéemìawa Jesús. Yá íimaca Jesús irí: —‍Pía cayábéeri yéewáidéerica wía, ¿càinásica iwàwacutá numànica nùyacaténá càiripináta Dios yáapicha chènuniré? —‍íimaca. ");
INSERT INTO pioNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Jesús íimaca irí: —‍Iwàwacutá píináidacawa cayába ìwali yái píimáanáca, càinácaalí íimáaná yái tàacáisica íiméerica cayábéericasa núa, canácáiná áiba wenàiwica cayábéeri, abéericata Dios cayábéeri —‍íimaca yái Jesúsca, iwàwacáiná asìali yeebáidaca Dioscani yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Néese Jesús íimaca irí àniwa: —‍Píalíacawa Dios itàacái ichùulìaná wía: ‘Picá piimá áiba inanái yáapicha càmíichúaca píinusíwa, áiba asìali yáapicha nacái càmíirica pinìrisíwa; picá pinúa wenàiwica; picá piyéedùa; picá nacái pichìwáida áibanái; pìa náimiétacaná píaniri, píatúa nacái’ —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Néese asìali íimaca irí: —‍Nudéca numànica macáita càide iyúwa Dios íimáaná sùmàicatáiseté núa àta siùca nacáide —‍íimaca. ");
INSERT INTO pioNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Jesús yéemìacani, yá íimaca irí: —‍Iyaca abéeri wawàsi iwàwacutéeri pimànica quiríta: Pìa piwéndaca macáita pìasuwa, pìa nacái iwènináami catúulécanéeyéi irí. Càipiná pidènìaca pìasu cawèníiriwa chènuniré. Néese pèepùawa pìacaténáwa núapicha nuéwáidacalécaténá pía —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Yái asìali quéwa, yéemìacanáami, yá máiní achúmaca iwàwa máinícáiná càasucani, càmicáiná nacái iwàwa yàaca áibanái irí macáita yàasuwa. ");
INSERT INTO pioNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Jesús yáalíacáináwa achúmaca iwàwa yái asìalica, íná Jesús íimaca yáapichéeyéi iríwa: —‍¡Máiní càulenápináca càasuíyéi yeebáidaca Dios itàacái, Dios yéenibecaténá nía! ");
INSERT INTO pioNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Càide iyúwa camello càmíiná yéewa iwàlùacawa siduwíapi ituí yáapuí irìcubàa, càita nacái càulenáca càasuíri wenàiwica yeebáidaca Dios itàacái Dios icùacaténáni —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Níái yéemièyéica Jesús íimáaná, náimaca Jesús irí: —‍Néeni, ¿cawinápiná yáalimá iwasàaca yáawawa Dios yàasu yùuwichàacáisi íicha? —‍náimaca. ");
INSERT INTO pioNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Jesús íimaca nalí: —‍Canáca yéewaná wenàiwicanái nawasàaca níawawa Dios yàasu yùuwichàacáisi íicha nachàini iyúwa meedá, quéwa Dios yáaliméeri iwasàaca nía, Dios yáalimácáiná imànica macáita —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Néese Pedro íimaca Jesús irí: —‍Wáiwacali, wadéca wamàacaca wàasuwa macáita wàacaténáwa píapicha yéewacaténá péewáidacaléca wía —‍íimaca. ");
INSERT INTO pioNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Yá Jesús íimaca nalí: —‍Péemìacué cayába, píacué nuéwáidacaléca yeebáidéeyéica nutàacái. Numáidacué abénaméeyéi péená nàanápináwa nacapèe íichawa namànicaténá càide iyúwa Dios iwàwáaná. Aibanái péenácué nacái nàapináwa maléená èeri nàacawéeri íichawa, càmicaalí nacái néenánái íicha nacáiwa, càmicaalí nacái nasèenái íicha nacáiwa, càmicaalí nacái néenibenái béeyéi íicha nacáiwa, namànicaténá càide iyúwa Dios iwàwáaná. ");
INSERT INTO pioNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","Yásí Dios yàapinácué pirí madécaná wenàiwica piiquéeyéipiná càiyéide iyúwa péenánáiwa chái èeri irìcu. Néese, èeri imáalàacaalípináwa, yásí Dios yàacué picáuca càmíiri imáalàawa chènuniré —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yáté Jesús imáidaca yàataléwa yéewáidacalénáiwa doce namanùbaca méetàucuta áibanái íicha. Yá íimaca nalí: —‍Siùcade wàacawa Jerusalén ìyacàlená nérépiná. Namànipiná nulí macáita càide iyúwaté profetanái itànàaná tàacáisi nuináwaná ìwali, núa asìali Dios néeséerica. ");
INSERT INTO pioNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Yá presopináca namànica núawa namàacacaténá càmíiyéi judío inúaca núa, yá naicáanípiná nuquíniná, yá natàanípiná báawéeri iyú nùwali, yá nàapìsáidaca núawa. ");
INSERT INTO pioNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Nanúadáidapiná nacái núawa, yásí nanúaca núa. Quéwa máisiba èeri irìcu nucáucàapináwa —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Quéwa, Jesús yéewáidacalénái càmita náalía néemìaca càinácaalí íimáaná yái tàacáisica, càmita nacái náalimá náalíacawa ìwali. ");
INSERT INTO pioNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Néeseté, Jesús ìyaca mawiénita Jericó ìyacàlená irí, yá matuíri asìali ìyaca néeni, yáawinéericawa àyapu idùlepi isutéerica plata wenàiwicanái íicha ichàbéeyéicawa néenibàa. Isutáca náicha plata yéewanápiná iwènìaca iyáapináwa. ");
INSERT INTO pioNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Yái matuírica yéemìaca manùbéeyéi isàna nachàbáanáwa, yá isutáca yéemìawa nía, cawinácaalí yàawa náapicha néeni. ");
INSERT INTO pioNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Nacàlidaca iríni Jesús Nazaret ìyacàlená néeséericani yái cài ichàbacawa chábài. ");
INSERT INTO pioNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Iná yái matuírica imáidaca: —‍¡Jesús, rey David itaquérinámi, Dios ibànuèrica walí wacuèrinápiná, piicá nupualé! —‍íimaca. ");
INSERT INTO pioNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Néese áibanái yèeyéicawa Jesús ipíchalé nacuísaca náichawani, yái matuírica, masànáanápináni. Imáidaca quéwanáta mamáalàacata cachàiníiri iyú: —‍¡Pía, rey David itaquérinámica, Wacuèrinápiná, piicá nupualé! —‍íimaca. ");
INSERT INTO pioNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Néese Jesús iyamáaca ibàlùacawa. Yá Jesús ichùulìaca natéenápiná matuíri Jesús yàatalé. Néese matuíri yàacawa néré, yá Jesús íimaca irí: ");
INSERT INTO pioNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","—‍¿Càinásica piwàwa numànica pirí? —‍íimaca yái Jesúsca. Néese matuíri íimaca: —‍Nuíwacali, pimàaca catuíca núa —‍íimaca. ");
INSERT INTO pioNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Jesús íimaca irí: —‍Catuíca píawa, peebáidacáiná nuchùnìanápiná pía. Iná yéewa cayábaca píawa —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Yáta matuírimi iicáidaca àniwa. Yá yàacawa Jesús yáapicha. Yàaca nacái Dios irí cayábéeri. Néese áibanái iiquéeyéicani, nàaca nacái Dios irí cayábéeri. ");
INSERT INTO pioNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Néeseté, Jesús iwàlùacawa Jericó ìyacàlená irìculé. Ichàbacáitawa néenibàa. ");
INSERT INTO pioNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Abéeri asìali càasuíri ìyaca néeni, abéeri Jericó mìnali, íipidenéeri Zaqueo. Yái Zaqueo, náiwacalicani, níái yeedéeyéica plata yéenánái judío íichawa Roma ìyacàlená yàasu gobierno irípiná. ");
INSERT INTO pioNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Yái Zaqueo iwàwa iicáca Jesústàatá, yáalíacaténá iicáca Jesús. Quéwa, càmita yáalimá iicácani, manùbacáiná wenàiwica Jesús itéesebàa. Maléenéeri nacái yái Zaqueoca, íná càmita yáalimá iicáca Jesús. ");
INSERT INTO pioNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Iná yái Zaqueo ipìacawa Jesús ipíchalépiná. Yá íiríacawa sicómoro yéetaná yàana ìwalibàa yéewanápiná idéca iicáca Jesús. Yái àicu ibàluèricawa àyapu idùlepita, Jesús ichàbacatabàapinácawa. ");
INSERT INTO pioNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Quéwa, Jesús ichàbaca yàacawa sicómoro yéetaná yáwibabàa, yá iicáidaca chènuniré. Iicáca Zaqueo yáawinéeriwa àicu yàanalìcu. Néese Jesús íimaca Zaqueo irí: —‍Zaqueo, piricùawa caquialéta, siùcacáináta iwàwacutá nuyamáacawa picapèe néré —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Yá Zaqueo iricùacàatétawa néese. Yá casíimáiri iyú yeedáca Jesús yàataléwa. ");
INSERT INTO pioNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Néese áibanái, naicácáiná Jesús iwàlùacawa néré, yá natàaníca báawéeri iyú Jesús ìwali. Yá náimaca nalíwáaca Jesús iwàlùacasawa icapèerìculé asìaliquéi báawéerica, cáanáiricasa ibáyawaná, yái Zaqueoca. ");
INSERT INTO pioNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Néesecáwa Zaqueo imichàa ibàlùacawa nàacuésemi. Yá Zaqueo íimaca Jesús irí: —‍Péemìacáwa, Nuíwacali, macáita yái nudènièrica, nùapináca yéema catúulécanéeyéi iríwa. Níara wenàiwica nucobréeyéica ichàbanamawa nuchìwa iyúwa, nuèpùadapiná nalíwani báinúaca yàawiriéricatái yáwanái íicha yái platami nuedéericaté náicha ichàbanamawa —‍íimaca. ");
INSERT INTO pioNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Yá Jesús íimaca irí: —‍Siùca èeri Dios idéca iwasàaca pía yàasu yùuwichàacáisi íichawa —‍íimaca yái Jesúsca. Néese, Jesús iwènúacawa íimaca áibanái irí: —‍Yácáiná asìalica, Abraham itaquérinámiquéi nacái, éwitaté iméeràacáanítawa Dios íicha. ");
INSERT INTO pioNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Núacáiná, núa asìali Dios néeséerica, nudéca nùanàaca nucutácaténá níái cabáyawanéeyéica, nuwasàacaténá nía Dios yàasu yùuwichàacáisi íicha —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Néeseté idécanáami wenàiwicanái yéemìaca Jesús íimáaná, yá Jesús yéewáidaca nía comparación iyú. Icàlidaca nalíni yái comparaciónca Jesús ìyacáináté mawiénita Jerusalén ìyacàlená irí ínáté nayúunáidaca Jesús icuèyéipináté israelitanái caquialétatá. ");
INSERT INTO pioNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Yá íimaca nalí: “Péemìacué comparación: Iyacaté abéeri náiwacali, yèeripinácatéwa áiba cáli néré déeculé, yéewanápiná icuèriná imàacaca náiwacali icùaca yàasu cáli néeséeyéiwa, yásí yèepùanápinátéwa néese icùacaténá nía. ");
INSERT INTO pioNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ipíchawáise náiwacali yàacawa, yá imáidaca yàataléwa diez namanùbaca yàasu wenàiwicawa. Yá yàaca nachàba manùba plata náalimáwanama. Yá íimaca nalí: ‘Pìacué pimànicaténá pìasu wawàsiwa iyú yái plataca àta nùanàacataléta àniwa’, íimaca nalí. Néese yàacawa náicha. ");
INSERT INTO pioNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Aibanáita quéwa náiwacali yàasu cáli néeséeyéi máiní báawaca naicácani. Yá nabànùaca áibanái wenàiwica náiwacali yáamiwa néré nacàlidacaténá nacuèriná iríwani. Náimaca: ‘Càmita wawàwa wacuèrinápiná yái asìalica’, náimaca. ");
INSERT INTO pioNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Quéwa, idéca nacuèriná imàacaca náiwacali icùaca yàasu cáli néeséeyéiwa, yá náiwacali yàanàaca néese àniwa. Yá imáidaca yàataléwa yàasu wenàiwicanáiwa, níái yeedéeyéicaté íicha plata, yáalíacaténáwa náicha càisimalénácaalí needá náiwacali irípináwa. ");
INSERT INTO pioNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Yái yàasu wenàiwicaca idàbáanéerica yàanàaca íiwacali yàataléwa. Yá íimaca íiwacali iríwa: ‘Nuíwacali, nudéca numànica nùasu wawàsiwa iyú yái pìasu plataca. Nuedácaté pirípiná diez namanùbaca yàawiría ipualé yái plata pièricaté nuchàba’, íimaca. ");
INSERT INTO pioNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Néese náiwacali íimaca irí: ‘Cayábacáani. Cayábéeri nùasu wenàiwicaca pía. Pimànicáiná machacàníiri iyú achúméeríina iyú càide iyúwa nuwàwáaná, íná yéewa siùcade numàaca picùaca diez namanùbaca yàcalé mìnanái’, íimaca yái náiwacalica. ");
INSERT INTO pioNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Néese yàasu wenàiwica áiba yàanàaca yàatalé. Yá íimaca íiwacali iríwa: ‘Nuíwacali, nudéca numànica nùasu wawàsiwa iyú yái pìasu plataca. Nuedácaté pirípiná cinco namanùbaca yàawiría ipualé yái plata pièricaté nuchàba’, íimaca. ");
INSERT INTO pioNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Néese náiwacali íimaca irí nacái: ‘Numàaca picùaca cinco namanùbaca yàcalé mìnanái’, íimaca yái náiwacalica. ");
INSERT INTO pioNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","21","“Néeseta quéwa náiwacali yàasu wenàiwica áiba yàanàaca yàatalé. Yá íimaca íiwacali iríwa: ‘Nuíwacali, yáca pìasu platéi. Nuépùacaténi wáluma iyú nucáapica cayábani, cáalucáiná nuicáca pía, máinícáiná caluéri píiwitáise, peedáca yái càmíiricaté píibaida piríwa. Peedáca piríwa nacái áibanái ibànacale, càmíiricaté pibàna piríwa’, íimaca. ");
INSERT INTO pioNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","23","Iná náiwacali íimaca irí: ‘Pía, nùasu wenàiwica báawéerica íiwitáise, pitàacái iyúwa nucháawàaca piináwaná ìwali nùuwichàidacaténá píawa. Píalíacaalítéwa caluérisa nuíwitáise, píalíacaalíté nacáiwa nuedáaná nulíwa yái càmíiricaté nuíbaida nulíwa, nuedáaná nacái áibanái íicha nabànacale càmíiricaté nubànacaleta, néese, ¿cáná càmita pimàaca nùasu plata caja néré inísàacaténátéwa nulípiná quirítatá àta nùanàacatalétaté àniwa?’ íimaca yái náiwacalica. ");
INSERT INTO pioNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Néese náiwacali íimaca áibanái irí ìyéeyéica néeni: ‘Peedácué íicha yái plataca. Pìacué iríni yái asìalica idènièrica diez namanùbaca yàawiría ipualé yái plataca’, íimaca nalí yái náiwacalica. ");
INSERT INTO pioNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Yá náimaca náiwacali iríwa: ‘Wáiwacali, ¿cánásica cài pimàni? Yái asìali idéca idènìaca diez namanùbaca yàawiría ipualé yái plataca’, náimaca. ");
INSERT INTO pioNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","27","Néese náiwacali íimaca nalí: ‘Péemìacué cayába. Cawinácaalí íibaidéeyéica nulí cayába, numàacáanápiná náibaidaca nulí mamáalàacata. Quéwa cawinácaalí càmíiyéica íibaida cayába, nuedápiná náicha náibaidacalémica. Níata quéwa, nùuwidenáica càmíiyéicaté iwàwa núa nacuèrinápináwa, pìacué píibàaca nía. Peedácué nía nùatalé cháta, yá pinúacué nía’, íimaca nalí yái nacuèrináca”, íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Idécanáamité cài Jesús íimaca nalí, yá yàacawa Jerusalén ìyacàlená nérépiná, yéewáidacalénái yáapichawa. ");
INSERT INTO pioNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Yá batéwata nàanàaca ìyacatái pucháiba yàcaléca. Abéeri yàcalé íipidenéeri Betfagé, áiba nacái íipidená Betania. Iyaca nacái néeni abéechúa dúli íipidenéechúa Olivos, yái olivo inàlimanáca. Yá Jesús ibànùaca ipíchaléwa pucháiba yéewáidacaléwa idécanáami cài íimaca nalí: ");
INSERT INTO pioNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","—‍Pìacuéwa irìculé yái yàcaléca ìyéerica wapíchalé. Piwàlùacuéwa néré, yá pìanàapinácué burro nadacuèrica néeni, canéeritàacáwa wenàiwica yèeriwa íinata. Piwasàacuéni, pitécué nulíwani. ");
INSERT INTO pioNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Aibacaalícué isutá yéemìawa píawa cánácué yéewa piwasàacani, néese picàlidacué iríwani nuwàwacutácani, núa Píiwacalicuéca —‍íimaca nalí yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Néese níái pucháiba yéewáidacaléca nàacawa íicha. Yá nàanàaca macáita càide iyúwa Jesús íimáanáté nalí. ");
INSERT INTO pioNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Idàbaca nawasàaca burro, yá burro íiwacanánái isutáca yéemìawa nía: —‍¿Cánácué piwasàa wapìra? —‍náimaca. ");
INSERT INTO pioNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Náimaca nalí: —‍Wáiwacalica iwàwacutáni —‍náimaca. ");
INSERT INTO pioNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Néese yéewáidacalénái irìadaca yàasu ruana nacáiriwa burro iwaalírìcubàa, yéewanápiná Jesús yàalubáicani, yá natéca burro Jesús yàatalé. Néese Jesús imichàa yáawinacawa burro íinata. ");
INSERT INTO pioNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Idècunitàacá Jesús yàacawa burro íinata Jerusalén ìyacàlená nérépiná, manùbéeyéi nalìada nàasu ruana nacáiriwa Jesús ipíchalé àyapulìcubàa burrocaténá ìipìna íinatabàa càide iyúwaté náiwitáise nàanápiná nacuèrinásàiri icàaluínináwa. ");
INSERT INTO pioNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Yàacawa Jerusalén ìyacàlená nérépiná Olivos yàasu dúli yàasu yàawa irìculé, yá canánama nía Jesús yéewáidacaléca, níái nacái yèepuníiyéicawa yáapicha, macáita nadàbaca namáidaca casíimáiri iyú. Nàaca nacái Dios irí cayábéeri naicácáináté Jesús imànica madécaná íiwitáise iyúwa yái càmíirica wenàiwica idé imànica. ");
INSERT INTO pioNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Nacàlidaca nèepunícawa: —‍¡Cayábéeriquéi Wacuèrináca, Dios ibànuèrica walí icùacaténácué wía! ¡Píacué canánama ìyéeyéica chènuniré, casíimáicué piwàwa! ¡Wàaca pirí cayábéeri, pía Dios chènuníiséerica! —‍náimaca. ");
INSERT INTO pioNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Néese abénaméeyéi fariseo yèepuníiyéicawa náapicha wenàiwicanái yèewi náimaca Jesús irí: —‍Pía, yéewáidéerica wenàiwica, pìalàa nía cachàiníiri iyú níái péewáidacalécawa, masànáanápiná nía, nacàlidacáiná piináwaná ìwali Dios inacáiricasa pía —‍náimaca. ");
INSERT INTO pioNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Yá Jesús íimaca nalí: —‍Péemìacué cayába, masànacaalí níái nuéwáidacalécatá, yáta níái íbaca nacàlidaca nuináwaná ìwali Diosca núatá —‍íimaca nalí yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Néese Jesús iyamáa ibàlùacawa mawiénita Jerusalén ìyacàlená irí, yá iicáca Jerusalén, néese íicháaníca manuísíwata ìwali yái yàcaléca, catúulécanácáiná iicáca yàcalé mìnanái, yácáiná Jesús yáalíacatéwa manuíri yùuwichàacáisi yàanàanápináté nàwali. ");
INSERT INTO pioNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Yá íimaca: “¡Máiní nuwàwa píalíacuécawa siùca èeri càinácaalícué iwàwacutáaná pimànica cayábacaténácué píapicha Dios! Cayábacaalícué píapicha Diostá, néese càmitacué yàanàa pìwali yàasu yùuwichàacáisitá. Quéwa càmitacué píalíawa càinácaalí iwàwacutáaná pimànica. ");
INSERT INTO pioNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Yàanàapinácué pirí báawéeri èeri. Piùwidenáicué namànipinácué iwáiná pìyacàle itéesebàa macáita, ipíchanácué pimusúacawa yàcalé íicha. Macáitacué náawapinácuéca píawa. Yá namànipiná ùwicái píipunitacué pitéesebàa macáita. ");
INSERT INTO pioNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Yásí namáalàidacué pìyacàle macái, nanúapiná macáita wenàiwica ìyéeyéica yàcalé irìcu. Nacàlàlìapinácué picapèe. Càmita namàacapiná capìi yàasu íba yáawinacawa áiba íba íinata, yá nacàlàlìacuéca macáita yái pìyacàlecuécawa. Piicácáinácué càiride iyúwa canéeri iwèni pirí yái nuénáiwanáca siùca èeri Dios ibànùacatáita núa pìatalécué, nuwasàacaténácué pía yàasu yùuwichàacáisi íicha”, íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Néeseté Jesús iwàlùacawa templo ibàacháwalená irìculé. Yá idàbaca imusúadaca macáita wenàiwica iwéndéeyéicaté yàasusi templo ibàacháwalená irìcu. ");
INSERT INTO pioNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Yá íimaca nalí: —‍Pidécuéca péemìaca tàacáisi profeta itànèericaté Dios inùmalìcuíse; Dios íimacaté yàasu templo ìwaliwa: ‘Yái nucapèeca nasutácàalupináca nuícha’, íimacaté yái Diosca. Quéwa, pidécuéca piwènúadacani cayéedéeyéi icapèe iyú, yái temploca, piyéedùacáinácué plata wenàiwica íicha pichìwa iyúwa —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Néese èeri imanùbaca Jesús yéewáidaca wenàiwicanái templo irìcu. Sacerdote íiwacanánái, nía nacái yéewáidéeyéica wenàiwica templo irìcu, judío íiwacanánái nacái, náináidacawa nàyaca càinápinácaalí iyú náalimá nanúaca Jesús. ");
INSERT INTO pioNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Càmitàacá quéwa náalimá náibàacani, níacáiná canánama wenàiwica cayábaca néemìaca Jesús itàacái. ");
INSERT INTO pioNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Aiba èerité Jesús ìyaca templo irìcu. Yá yéewáidaca ìyaca wenàiwicanái, icàlidaca nalí nacái Dios itàacái cayábéerica, yái tàacáisi íiméerica Jesús iwàwa iwasàaca wenàiwica Dios yàasu yùuwichàacáisi íicha. Yá sacerdote íiwacanánái, áibanái nacái yéewáidéeyéica wenàiwica templo irìcu, nía nacái judío íiwacanánái béeyéica nàacawa Jesús yàatalé. ");
INSERT INTO pioNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Yá náimaca irí: —‍¿Cawiná ibànùa pía pimusúadáanápiná nía templo ibàacháwalená irìcuíse, níái iwéndéeyéica yàasusi? ¿Cawiná ichùulìa pía pimusúadáanápiná nía? —‍náimaca. ");
INSERT INTO pioNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Néese Jesús íimaca nalí: —‍Nuwàwa nusutácuéca nuémìawa pía nacái. Picàlidacué nulíni: ");
INSERT INTO pioNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿Cawiná ichùulìaté Juan ibautizáanápináté wenàiwica; Diossica, wenàiwicanáisica? Píimacué nulí càiríinácaalí náicha ichùulìaca Juan ibautizáanápináté wenàiwica —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Nadàbaca natàaníca nalíwáaca. Yá náimaca nalíwáaca: “¿Càinásica wáimaca? Wáimacaalí irí, ‘Dioscaté ichùulìacani’, yásí isutáca yéemìawa wía, ‘¿Cánácué càmita peebáidani?’ càipiná íimaca walí. ");
INSERT INTO pioNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Néese wáimacaalí irí, ‘Wenàiwicacaté ichùulìaca meedáni’, yásí wenàiwica macáita nanúaca wía íba iyú, níacáiná macáita neebáidaca tài íiméeri iyú Juan itàanícaté Dios inùmalìcuíse”, cài natàaníca nalíwáaca. ");
INSERT INTO pioNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Néese nacàlidaca Jesús iríni càmitasa náalíawa cawinácaalí ichùulìaté Juan ibautizáanápináté wenàiwica. ");
INSERT INTO pioNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Néese Jesús íimaca nalí: —‍Càita nacái càmita nucàlidacué piríwani cawinácaalí ichùulìaca núa numusúadáanápiná nía templo ibàacháwalená irìcuíse, níái iwéndéeyéica yàasusi —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Néeseté Jesús idàbaca yéewáidaca wenàiwicanái comparación iyú. Yá íimaca nalí: “Abéeri asìali ibànacaté uva ibànacalená. Yá imàacaca áibanái icuèyéipiná irí yàasu uva ibànacalená, quéwa iwàwacutá nabànùaca irí yàasu uva ìyacaná yéenápiná, yàasu èeripiná needácatáita ìyacaná. Idécanáamité imànica náapicha càiri wawàsi, yá yàacawa náicha áibalé madécaná èeri. ");
INSERT INTO pioNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Uva yàasu èeri yàanàacaté needácaténá ìyacaná, yá bànacalé íiwacali ibànùaca yàasu wenàiwicawa néré icutácaténá náiwacali yàasu uva ìyacaná yéenápináwa icuèyéi íicha. Quéwa níái icuèyéica bànacalé nacapèedáidacani, yái náiwacali yàasu wenàiwicaca. Yá nachùulìaca yàacawa náicha, càmita nabànùa yáapicha uva ìyacanáca. ");
INSERT INTO pioNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Néese bànacalé íiwacali ibànùaca nàatalé yàasu wenàiwicawa áibata. Quéwa àniwa natàaníca irí báawéeri iyú, nacapèedáidacani. Yá nachùulìaca yàacawa náicha, càmita nabànùa yáapicha uva ìyacanáca. ");
INSERT INTO pioNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Néese bànacalé íiwacali yèepùa ibànùaca áibata àniwa. Yá àniwa níái icuèyéica uva ibànacalená cacháunáca namànicani. Yá náucacani méetàuculé bànacalé yàaluná íicha. ");
INSERT INTO pioNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Néese yái uva ibànacalená íiwacali íimaca íináidacawa iríwa: ‘¿Càinásica numàni? Siùcade nubànùa nuìriwa, yái cáininéerica nuicáca. Cawàwanáta nàaca íimiétacaná’, íimaca íináidacawa iríwa. ");
INSERT INTO pioNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Quéwa níái icuèyéica uva ibànacalená naicácani, yá náimaca nalíwáaca: ‘Yácata yái yeedéeripiná iríwa uva ibànacalená yáaniri yéetácaalípináwa. Ara, wàacuéwa wanúanáni weedácaténá walíwa yàasu bànacalé’, náimaca nalíwáaca. ");
INSERT INTO pioNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Iná náibàacani, yá nawatàida náucacani méetàucuta bànacalé yàaluná íicha. Yá nanúacani”, íimaca nalí yái Jesúsca. Néese Jesús íimaca nalí níái wenàiwicaca: “¿Càinásicué píináidacawa? ¿Càinásica uva ibànacalená íiwacali imànipiná nalí níái icuèyéicaté irípiná bànacalé? ");
INSERT INTO pioNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Siùcade nucàlidacué piríni: Yàanàapiná nàatalé, yá inúapiná níawa. Yásí imàaca áibanái icùaca irípiná yàasu uva ibànacalená —‍íimaca yái Jesúsca. Néese wenàiwicanái idécanáami néemìacani, yá náimaca Jesús irí: —‍¡Càmíirita, canácatáita Dios imànipiná walí cài! —‍náimaca. ");
INSERT INTO pioNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Quéwa Jesús iicáidaca nalí, yá íimaca: —‍Néeni, càmicaalícué piwàwa Dios yùuwichàidacuéca pía, néese iwàwacutácué píináidacawa cayába càinácaalí íimáaná yái tàacáisi profeta itànèericaté Dios inùmalìcuíse. Icàlidacaté Dios ibànùanápináté israelitanái irí nacuèrinápiná, quéwa báawáanápináté naicácani. Càité íimaca: ‘Níái imàníiyéica íba icapèená, nadéca náucaca abéeri íba méetàuculé náichawa, caná iwènicáiná naicácani. Quéwa siùcade máiníiri iwàwacutácawa capìi irípiná yái íba náuquéericaté’, cài itànàacaté profetaca”, íimaca nalí yái Jesúsca, yéewacaténá náalíacawa yái íba íimáanáca càicanide iyúwa Jesús, yái nacuèrinápiná Dios ibànuèrica judíonái irí. ");
INSERT INTO pioNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Néese Jesús íimaca nalí àniwa: —‍Péemìacué áiba comparación íba ìwali: Cawinácaalí wenàiwica yúuwèeyéicawa iwéré yái íbaca, yásí wenàiwica isubèriacawa. Néese íba yúuwàacaalíwa áibanái íinatabàa, yásí náalacawa ichùmalési iyú —‍íimaca yái Jesúsca, náalíacaténáwa Dios yùuwichàidáanápináté manuísíwata cawinácaalí càmíiyéica yeebáida Jesús itàacái. ");
INSERT INTO pioNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Néese sacerdote íiwacanánái, nía nacái yéewáidéeyéica wenàiwica templo irìcu, nawàwaca náibàaca Jesús yáté èerica náucacaténáni presoíyéi ibànalìculé, náalíacáináwa icàlidacaté nàwali yái comparaciónca. Càmíiri nadé náibàaca quéwani cáalucáiná naicáca wenàiwicanái, manùbacáiná níái yéemièyéica Jesús itàacái casíimáiri iyú. ");
INSERT INTO pioNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Néeseté sacerdote íiwacanánái nachùulìaca áibanái asìanái nàacawa Jesús yàatalé, natàanícaténá cáimiétaquéeri iyú Jesús yáapicha, iyúwa cayábéeyéi íiwitáise iwàwéeyéica yéemìadaca Dios itàacái. Quéwa cachìwéeyéica nía meedá, nàacawa néré náalimáidacaténá Jesús itàaníinápiná báawéeri iyú romanonái yàasu gobierno ìwali yéewanápináta meedá náibàacani nacháawàacaténá iináwaná ìwali gobernador romanosàiri irí. ");
INSERT INTO pioNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Iná nasutáca néemìawa Jesús. Yá náimaca irí: —‍Pía, yéewáidéerica wenàiwica, wáalíacawa pitàaníca báisíiri iyú, péewáidaca wenàiwica nacái báisíiri tàacáisi iyú càiripináta. Wáalíaca nacáiwa piicáca macái wenàiwica abédanamata, péewáida nacái wenàiwica nàyacaténá càide iyúwa Dios ichùulìaná nàyaca. ");
INSERT INTO pioNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Siùcade picàlida walíni: ¿Cayábasica wapáyaidacaalí wáichawa plata iyú níara emperador romanosàiri yàasu gobiernonái icuèyéica wàasu cáli? —‍náimaca. ");
INSERT INTO pioNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Quéwa Jesús yáalíaca náiwitáise báawéeri nawàwáaná nacháawàaca iináwaná ìwali itàacái ìwalíise. Yá íimaca nalí: ");
INSERT INTO pioNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","—‍Píasáidacué nuicá abéechúa moneda. ¿Cawiná yéenáiwaná ichanàawa moneda ìwali? ¿Cawiná nacái íipidená ichanàawa ìwali? —‍íimaca yái Jesúsca. Yá náimaca Jesús irí: —‍Emperador íipidenáquéi ichanàawa ìwali, yéenáiwaná nacái ichanàawa ìwali, yáara romano íiwacaliná, icuèrica macái èeri mìnanái —‍náimaca. ");
INSERT INTO pioNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Yá Jesús íimaca nalí: —‍Pipáyaidacué píichawa emperador plata iyú càide iyúwa ichùulìanácué pipáyaidacani. Pimànicué nacái càide iyúwa Dios iwàwáanácué pimànica —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Iná canácata báawéeri tàacáisi Jesús íiméerica wenàiwicanái yàacuésemi yéewanápiná nacháawàaca iináwaná ìwali. Néese náináidacawa néemìaca manuísíwata Jesús íimáaná, yá masànacáicata nía íicha. ");
INSERT INTO pioNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Néeseté abénaméeyéi saduceo nàaca naicáca Jesús. Saduceonái náimaca càmitasa yéetéeyéimiwa nacáucàawa áibaalípiná. Saduceonái iwàwaca wenàiwicanái iicáaníca Jesús iquíniná, íná nasutáca néemìawa Jesús, náalimáidacaténá naicáwani. Yá nacàlidaca irí tàacáisi. Náimaca irí: ");
INSERT INTO pioNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","—‍Pía, yéewáidéerica wenàiwica, profeta Moisés itànàacaté tàacáisi íiméerica Dios ichùulìanácué wía judíoca wamàníinápiná cài: Asìali yéetácaalíwa méenibeta, néese iwàwacutá yéenásàiri yeedáca iríwa yéenásàiri íinumiwa yàacawéetúapináwa yéewacaténá idènìaca úapicha yéenibewa naiquéeyéipiná càiyéide iyúwa yéetéerimiwa yéenibemi, yéewanápiná nàyaca wenàiwica icuèyéipiná yéetéerimiwa yàasu cáli. ");
INSERT INTO pioNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Uwé, áibaalíté nàyaca siete namanùbaca yéenánái. Nabèeri yeedáca abéechúa íinupináwa, quéwa yéetácawa uícha méenibeta. ");
INSERT INTO pioNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Ináté iméeréerimi yeedáca ibèeri íinumicawa. Néese yéetácawa uícha méenibeta. ");
INSERT INTO pioNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Néese iméeréerimi àniwa yeedáca úa, càita nacái yéetácawa uícha méenibeta. Càité níái sietéeyéicaté imanùbaca needáca úa. Yá néetácawa uícha macáita méenibeta. ");
INSERT INTO pioNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Néese úanama yéetáwa náami nacái. ");
INSERT INTO pioNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Uwé, báisícaalí yéetéeyéimiwa icáucàacawa áibaalípinátá càide iyúwa áibanái íináidáanáwa, ¿càinápinásica unìri náicha níara sietéeyéimica? Càmita náalimápiná náalíacawatá, macáicáináta náinuca úa —‍náimaca, naicáaníca Jesús iquíniná. ");
INSERT INTO pioNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Néese Jesús íimaca nalí: —‍Chái èeri irìcu, asìanái, inanái nacái nacásàacawa. ");
INSERT INTO pioNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Quéwa cawinácaalí wenàiwicanái Dios imàaquéeyéipináca icáucàacawa áiba èeriwa nàacaténáwa chènuniré, asìanái, inanái nacái, càmita nacásàapináwa. ");
INSERT INTO pioNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Càmita nacásàapináwa càmicáiná náalimá néetácawa quirínama, nàyapinácáiná càide iyúwa ángelnái ìyáaná. Níacáiná Dios yéenibepináca nía, Dios imichàidacáiná nía yéetácáisi íicha. ");
INSERT INTO pioNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Profeta Moisés nacái yáasáidacaté walí yéetéeyéimiwa nacáucàanápinácawa áiba èeriwa. Moisés itànàacaté tàacáisi wáalíacaténáwa maléenéeri àicu ìwali yeeméericatéwa ìyaca quichái iyú, Dios ìyacáináté néré, yáté Moisés yéemìaca tàacáisi íiméerica: Yái Wacuèriná Dios, yácata Nacuèrináca, níái wàawirináimica Abraham, Isaac nacái, Jacob nacái. ");
INSERT INTO pioNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","¡Dios càmita icùa yéetéeyéimi ichéeca meedá! ¡Néese Dios icùaca cáuyéi wenàiwica! Iná iwàwacutácué píalíacawa cáuca nía Dios yáapicha siùca, níara Abraham, Isaac, Jacob nacái, éwita néetácáanítatéwa madécaná camuí ipíchawáiseté Moisés ìyaca, cáucáiná macáita wenàiwica Dios icuèyéica. Iná yéewa wáalíacawa Dios icáucàidáanápiná yéetéeyéimiwa áiba èeriwa —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Néese áibanái yéewáidéeyéi wenàiwica templo irìcu náimaca Jesús irí: —‍Pidéca picàlidaca cayábani, pía yéewáidéerica wenàiwica —‍náimaca. ");
INSERT INTO pioNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Yá cáaluca níái Jesús yùuwidenáica. Càmita nawàwa nasutáca néemìawani quirínama, ipíchaná báica nía wenàiwicanái yàacuésemi. ");
INSERT INTO pioNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Jesús íimaca nalí: —‍Càmitacué píalíawa cayába Mesías ìwali, yái picuèrinápinácuéca Dios ibànuèripinácuéca pirí, píacué judíoca. Píimacáitacué rey David itaquérinámica meedáni. Quéwa rey David íimacaté nacái áiba wawàsi Mesías ìwali. ");
INSERT INTO pioNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","David itànàacaté tàacáisi Dios inùmalìcuíse, yái tàacáisi waléerica cuyàluta Salmos irìcuíse. Càité David íimaca: ‘Nucuèriná Dios íimacaté Nuíwacali irí: Píawinawa nuéwápuwáise picùacaténá núapicha macáita, ");
INSERT INTO pioNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","idècunitàacá numawènìadaca píicha macái piùwidenáiwa, íimaca yái Diosca’, càité íimaca yái Davidca. ");
INSERT INTO pioNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Yái rey Davidca íimacaté Mesías ìwali ‘Nuíwacali’, íná éwita rey David itaquérinámicáanítani, yái Mesíasca, càicáaníta iwàwacutá náimaca ìwali rey David Iiwacali nacáicani —‍íimaca nalí yái Jesúsca, icàlidaca nalí ìwaliwa, yái Mesíasca. ");
INSERT INTO pioNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Macái wenàiwicanái ìyéeyéica néeni néemìaca nàyaca Jesús itàacái, yá Jesús íimaca yéewáidacalénái iríwa: ");
INSERT INTO pioNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Piicácué píichawa níái yéewáidéeyéica wenàiwica templo irìcu. Picácué pìyaca càide iyúwa nàyáaná. Casíimáica nèepunícawa nanáawani cáaléeri yáapichawa, náasáidacaténá nadéca néewáidacawa madécaná èeri, nayúunáidacáiná nasíimáidaca Dios. Nawàwa wenàiwicanái itàidaca nía cáimiétaquéeri iyú bamuchúamibàa yàcalé manùbéeyéi wenàiwica naicácaténá nía. Máiní nawàwa náawinacawa yàalubáisi íinata náawinacatáicawa níara cáimiétacanéeyéica wenàiwicaca judíonái yéewáidacàalu irìcu. Nacutá nacái yàalubáisi cayábanaméeyéi macái wenàiwica yàacuésemi nayáacaténá nayáacaléwa náapicha, yéewacaténá áibanái naicáca nía càiyéide iyúwa máiníiyéica cachàinica. ");
INSERT INTO pioNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Nayéedùa nacái náicha nacapèemi, nàasumi nacái níái catúulécanéeyéi inanáica manìríiyéimica. Néese nasutáca Dios déecuíri iyú, yéewacaténá áibanái iyúunáidaca cayábaca náiwitáise. Níacata Dios yùuwichàidéeyéipiná cachàiníiri iyú yáwanái náicha áibanái cabáyawanéeyéica”, íimaca nalí yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Jesús ìyacaté templo irìcu, yá iicáidaca wenàiwica irí irìadéeyéica yàasu platawa ofrenda yàalu irìculé namàacacaténá Dios iríni. Yá iicáca càasuíyéi nalìadaca plata. ");
INSERT INTO pioNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Néese Jesús iicáca inanái yàanàaca néré, máiní catúulécanéechúa, inìrimi yéetéechúamicatéwa íicha. Yá ulìadaca ùasu ofrendawa ofrenda yàalu irìculé, pucháiba moneda cobréeyéi púubéeyéi, càmíiyéica máiní cawènica. ");
INSERT INTO pioNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Néese Jesús íimaca yéewáidacalénái iríwa: —‍Péemìacué cayába, úái catúulécanéechúa manìríichúamica udéca umàacaca plata Dios irípiná ofrenda iyú Dios iiquéeri càiride iyúwa manuíri iwèni náicha canánama, níái yúuquéeyéica plata ofrenda yàalu irìculé. ");
INSERT INTO pioNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Macáita níái áibanái nàaca ichàbéericawa meedá, máisibáwanáita nàasu cawèníiri íichawa; úata quéwa éwita catúulécanácáaníta úa, càicáaníta ùaca macáita yái udènièrimica uwènìanápináca uyáacaléwa —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Aibanái natàaníca nàacawa templo ìwali cayábéeri iicácanáwani, yàasu cawèníiyéi íba ìwali nacái, áiba cawèníiri wawàsi nacái wenàiwica imàaquéerica Dios irípiná ofrenda iyú. Néese Jesús íimaca nalí: ");
INSERT INTO pioNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","—‍Aibaalípiná imáalàacawa macáitacué piiquéerica yái temploca. Yásí canácata capìi yàasu íba yáawinéeripinácawa áiba íba íinata. Namáalàidapiná macáita —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Néese nasutáca néemìawa Jesús. Yá náimaca irí: —‍Wáiwacali, ¿chácaalínásica ichàbapináwa yái picàlidéerica walí templo ìwali? ¿Càinásica iyú wadépiná wáalíacawa mawiénica yéenáiwaná, yái templo imáalàacatáipinácawa? —‍náimaca. ");
INSERT INTO pioNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Néese Jesús íimaca nalí: “Piicácué píichawa cayába ipíchaná áibanái ichìwáidacuéca pía ipíchawáise èeri imáalàacawa. Manùbacáiná wenàiwica nàanàapiná icàlidéeyéi ichìwawa. Náimapiná núacasa níata. Yá nacàlidapiná nachìwawa. Càipiná náimaca: ‘Núacata yái Mesíasca, íipidenéeri Jesucristo, israelita icuèrinápináca’, càipiná náimaca namànica nachìwawa. Aibanái nacái náimapiná: ‘Idéca Jesucristo yàanàaca icùacaténá macáita’, càipiná náimaca. Quéwa picácué peebáida nalíwani. ");
INSERT INTO pioNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Nacàlidapinácué pirí ùwicái iináwaná ìwali, náimapiná nacái namàníinása ùwicái nacuèrinánái íipunitawa, quéwa picácué cáalu píawa. Càita iwàwacutápiná namànica quéechacáwa, quéwa càmitàacá imáalàapináwa yái èeriquéi”, íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Néese Jesús íimaca nalí àniwa: “Aiba cáli néeséeyéi napéliapiná áiba cáli néeséeyéi íipunitawa. Aibanái gobierno namànipiná ùwicái áibanái gobierno íipunitawa. ");
INSERT INTO pioNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Yá cáli icusúapináwa cachàiníiri iyú madécaná yàcalé. Manùbéeyéi wenàiwica néetápináwa máapicái iyú, uláicái iyú nacái, madécaná cáli néeséeyéi. Capìraléeri cáli irìcuwa naicáwa wawàsi icalùadéeripiná naicáca, áiba wawàsi nacái manuínaméeyéi yáasáidéeyéipináca èeri mìnanái irí mawiénica yái èeriquéi imáalàanápinácawa. ");
INSERT INTO pioNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Quéwa ipíchawáise naicáca càiri wawàsi, yá áibanái náibàapinácué píawa, namànipinácué pirí báawéeri peebáidacáinácué nutàacái. Nawatàidapinácué píawa judíonái yéewáidacàalu néréwa nacháawàacaténácué piináwaná ìwali. Yá náucapinácué píawa presoíyéi ibànalìculé. Natépinácué píawa nacháawàacaténácué piináwaná ìwali nacuèrinánái iríwa, náiwacanánái irí nacáiwa peebáidacáinácué nulí. ");
INSERT INTO pioNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Càita Dios imàacapinácué picàlidaca nalí nuináwaná ìwali, peebáidacuéca nutàacái. ");
INSERT INTO pioNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Ipíchawáise náibàacuéca pía, picácué péewáidawa càinácaalípinácué picàlidáaná nalí piináwanáwa. ");
INSERT INTO pioNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Néenialícáiná numàacapinácué pitàaníca máiní cáalíacáiri iyú, yéewanápiná càmitacué piùwidenái nadé namawènìadacuéca pìasu tàacáisi. ");
INSERT INTO pioNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Quéwa, pisèenáicué, péenánáisíwacué nacái, pìawiría yéenánái nacái, pìacawéeyéiná nacái, nacháawàapinácué piináwaná ìwali nacuèrinánái iríwa. Nanúapinácué abénaméeyéi péenáwa. ");
INSERT INTO pioNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Yásí macái èeri mìnanái báawacuéca naicáca píawa peebáidacáinácué nutàacái. ");
INSERT INTO pioNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Quéwa càmitacué yúucapináwa nuícha abéeri péená, ibatàa achúméeríina pináta, càmita yúucapináwa nuícha. ");
INSERT INTO pioNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","¡Peebáidacué mamáalàacata tài íiméeri iyú, pìidenìacué piùwichàanáwa nacái matuíbanáiri iyú, yéewacaténácué peedáca piríwa picáucawa càmíiri imáalàawa! ");
INSERT INTO pioNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Piicácaalípinácué úwinái ibàlùacawa Jerusalén ìyacàlená itéese, yásí píalíacuécawa mesúnamáita namáalàidáanápiná yái Jerusalénca. ");
INSERT INTO pioNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Iná iwàwacutápiná cawinácaalí wenàiwica ìyéeyéica chái Judea yàasu cáli íinata napìacawa dúli inàliméeri nérépiná. Cawinácaalí ìyéeyéica Jerusalén ìyacàlená irìcu iwàwacutápiná napìacawa yàcalé irìcuíse. Cawinácaalí nacái ìyéeyéica manacúalibàa, iwàwacutápiná càmita nèepùawa Jerusalén ìyacàlená irìculé. ");
INSERT INTO pioNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Néenialícáiná Dios yàasu manuíri yùuwichàacáisi yàanàapiná israelitanái ìwali. Macáita ichàbapinácawa càide iyúwaté profetanái itànàaná tàacáisi Dios inùmalìcuíse. ");
INSERT INTO pioNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","¡Néenialípiná inanái nàuwichàapináwa manuísíwata, cawinácaalí idéerìcuíyéica, nía nacái inanáica yèeyéica quìrasìi ìiraca ìinisi!, càmicáiná náalimá napìacawa ráunamáita, naicápiná nacái néenibewa nàuwichàacawa. Yá nàuwichàapinácawa báawanama níái Israel yàasu cáli néeséeyéica, yácáiná Dios yàasu yùuwichàacáisi yàanàapiná nàwali. ");
INSERT INTO pioNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Abénaméeyéi néetápináwa espada machete nacáiri iyú. Uwinái íibàapiná áibanái, yá natépiná níawa macái cáli imanùbaca íinatalépiná. Néese càmíiyéi judío namáalàidapiná Jerusalén ìyacàlená, yá nacùapinácani àta imáalàacatalépinátawa nàasu èeri Dios imàaquéeripiná nalí nacùanápináni, ipíchawáise yèepùadacani judíonái irí àniwa, yái Jerusalénca”, íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Jesús íimaca nalí: “Néese wenàiwica naicápiná wawàsi capìraléeri cáli irìcuwa, manuínaméeyéi wawàsi nacalùadéeripiná naicáca, èeri ituírìcu, quéeri nacáiwa, dùlupùta nacáiwa náalíacaténáwa mawiénica yái èeriquéi imáalàanápinácawa. Chái èeri irìcu nacái, èeri mìnanái máiní cáaluca náináidapináwa, càmita náalíawa càinácaalí iwàwacutáanápiná namànica, manuíri únicáiná imànipiná isànawa cachàini, manuínaméeyéi màladàca nacái ipìapinácawa cachàiníiri iyú. ");
INSERT INTO pioNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Néenialípiná achúma wenàiwica néetápináwa nacalùniwa, cáalucáiná náináidapinácawa idècunitàacá nacùaca yàanàaca yái manuíri yùuwichàacáisi yàanèeripinácawa èeri mìnanái ìwali. Níacáiná cachàiníiyéi wawàsi ìyéeyéica chènuniré, nacusúacawa macáiwa. ");
INSERT INTO pioNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Néese macái èeri mìnanái iicápiná núa, núa asìali Dios néeséerica, nùanàapiná acalèe yèewíise cachàiníiri nuíwitáise iyúwa, nucamaláná mèlumèluíri irìcuwa nucùacaténá macáita. ");
INSERT INTO pioNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Idàbacaalípiná ichàbacawa macáita yái wawàsica, yásí pichàiniadacué piwàwawa, pimichàidacué píiwitáisewa nuípunita, piicáidacué chènuniré, caquialécáináta nùanàapináca nuwasàacuéca pía”, íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Néese Jesús icàlidaca nalí comparación yéewáidacaténá nía. Yá íimaca nalí: “Piicácué higuera yéetaná, áibanái àicu íiwitáaná nacái ìyéeyéica chái Israel yàasu cáli íinata. ");
INSERT INTO pioNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Piicácaalícué àicu imusúadaca ibáináwa, yásí píalíacuécawa mawiénica camuí. ");
INSERT INTO pioNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Càita nacáicué piicácaalípiná ichàbacawa yái nucàlidéericuéca pirí ìwali, yásí píalíacuécawa mawiénica Dios yàasu èeri icùacaténá macáita. ");
INSERT INTO pioNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Péemìacué cayába, macáita yái siùquéerica tàacáwa nucàlidacuéca pirí ìwali, macáita ichàbáanápináwa ipíchawáise néetácawa macáita wenàiwica ìyéeyéica néenialíwa. ");
INSERT INTO pioNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Yái capìraléeri cáli, èeriquéi nacái namáalàapináwa áibaalípiná, néese nutàacái càmita imáalàapináwa. Macáita ichàbapinácawa càide iyúwa nucàlidáanácué piríni. ");
INSERT INTO pioNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Piicácué píichawa cayába ipíchaná piwènúadacuéca nuícha píiwitáisewa pimàníinápinácué pibáyawanáwa, picàmáanápiná nacái, píináidáanápiná nacáiwa mamáalàacata èeri irìcuíri wawàsi ìwali. Picácué cài pimànica, néese picùacué nùanàaca àniwa. ");
INSERT INTO pioNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Yácáiná yùuwichàacáisi yàanàapiná ráunamáita macái èeri mìnanái ìwali càide iyúwa trampa íibàaná cuwèesi isicúasíwata. ");
INSERT INTO pioNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Pichùnìacué cayába píiwitáisewa. Pisutácué Dios íicha mamáalàacata cachàinicaténácué píiwitáise pìidenìanápinácué macáita yái ichàbáanápinácawa, yéewacaténácué pìanàaca pibàlùacawa nuípunita, núa asìali Dios néeséerica”, íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Néenialíté Jesús yéewáidaca wenàiwica èeríapinama templo irìcu. Néese catá imanùbaca yàaca iyamáacawa dúli néré íipidenácatalé Olivos, yái olivo inàlimanáca. ");
INSERT INTO pioNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Yá èeri imanùbaca macáita wenàiwica nàanàaca templo irìculé mapisáisíwata néemìacaténá Jesús itàacái. ");
INSERT INTO pioNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Mawiénicaté judíonái yàasu culto íipidenéeri Pascua nayáacaalíté pan càmíiri idènìa levadura. ");
INSERT INTO pioNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Sacerdote íiwacanánái, nía nacái yéewáidéeyéica wenàiwica templo irìcu nacutáca càinápinácaalí iyú yéewanápiná nanúaca Jesús, ibàacanéeri iyúta quéwa cáalucáiná nía wenàiwicanái íicha. ");
INSERT INTO pioNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Néese Satanás iwàlùacawa Judas iwàwalìculé, ichùulìaca Judas imànicaténá càide iyúwa Satanás iwàwáaná, yái íipidenéerica Judas Iscariote, abéeri Jesús yéewáidacaléca docenácaté nía. ");
INSERT INTO pioNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Néese Judas yàacawa itàaníca sacerdote íiwacanánái yáapicha, náapicha nacái úwi íiwacanánái templo néeníiyéica. Yá Judas itàaníca náapicha Jesús ìwali yéewanápiná itéca nía Jesús yàatalé náibàacaténáni. ");
INSERT INTO pioNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Yá casíimáica nawàwa, náimaca irí nàanápináté irí plata itéenápiná nía Jesús yàatalé náibàacaténáni. ");
INSERT INTO pioNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Cayábaca Judas yéemìaca náimáaná irí. Yá Judas idàbaca icutáca wawàsi càinácaalícatáipináta yáalimá itéca nía Jesús yàatalé náibàacaténáni, càmicataléta máiní manùba wenàiwica ìyaca Jesús yáapicha. ");
INSERT INTO pioNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Néeseté yéenáiwaná yàanàaca judíonái imànicatáica yàasu cultowa íipidenéeri Pascua, nayáacatáita pan càmíiri idènìa levadura. Yáté èerica iwàwacutá nanúaca oveja wàlisài nayáacaténá oveja iiná Pascua yàasuná culto yaalí. Càita judíonái iwàwalica càinácaalíté iyú Dios iwasàaca nàawirináimi Egipto yàasu cáli íicha. ");
INSERT INTO pioNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Néese, Jesús ichùulìaca Pedro, Juan nacái, yá íimaca nalí: —‍Pìacué pichùnìa walípiná yàacàsi Pascua pinéerica wayáacaténáni —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Yá nasutáca néemìawani: —‍¿Alénásica piwàwa wachùnìacani? —‍náimaca. ");
INSERT INTO pioNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Jesús íimaca nalí: —‍Piwàlùacuéwa Jerusalén ìyacàlená irìculé, yá pìanàapinácuéca asìali iwáacutéeri úni catùalìcu. Pìacuéwa asìali yáamíise aléera iwàlùacatalécawa. ");
INSERT INTO pioNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Píimacué capìi íiwacali irí: ‘Yáara Yéewáidéerica wía iwàwaca isutáca yéemìawa pía, alénácaalí capìi imàdáaná ìya iyáacatáipiná iyáacaléwa Pascua pinéerica yéewáidacalénái yáapichawa’, píimacué irí. ");
INSERT INTO pioNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Néese yáasáidapinácué piríwani, manuíri capìi imàdáaná ìyéerica chènunibàa cáli inàni íicha, nachùnièrica cayába. Pichùnìacué walí wayáapiná néeni Pascua piná —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Iná nàacawa, yá nàanàaca macáita càide iyúwa Jesús íimáanáté nalí. Néese nachùnìaca yàacàsi Pascua pinéerica. ");
INSERT INTO pioNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Néesecáwa catácanáami nàwali, iwàwacutácaalíté nayáaca, yá Jesús yàanàaca yáawinacawa mesa iwéré apóstolnái yáapicha. ");
INSERT INTO pioNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Néese, Jesús íimaca nalí: —‍¡Máadáiní nuwàwacatécué nuyáaca píapicha yái yàacàsi Pascua pinéerica ipíchawáise nuétácawa! ");
INSERT INTO pioNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Càmicáiná nuyáapiná quirínamani àta ichàbacatalétawa macáita càide iyúwa Pascua íimáaná, yásí nuyáapiná àniwani píapichacué, Dios ìyacàle irìcu Dios icùacataléca macáita chènuniré —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Néese Jesús yeedáca abéechúa copa icáapi irìculéwa, idènièchúa irìcuwa uva ituní. Idécanáami yàaca Dios irí cayábéeri, yá íimaca nalí: —‍Peedácuéni, pìiracuéni, piwacùacué pìwaliwáacawani; ");
INSERT INTO pioNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","càmicáiná nuìrapiná quirínamani yái uva ituníca àta Dios idàbacatalépináta icùaca macáita —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Néese Jesús yeedáca pan icáapi irìculéwa. Idécanáami yàaca Dios irí cayábéeri, yá isubèriadacani, yá iwacùaca nalíni. Néese íimaca nalí: —‍Yácata nuiná yái, yéetéeripinácuécawa píichawalíná ipíchaná Dios yùuwichàidacuéca pía pibáyawaná ìwalíisewa. Piyáacué yái panca piwàwalicaténácué nuétáanácuéwa píichawalíná —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Néesecáwa idécanáami nayáaca yái yàacàsi Pascuaca, Jesús yeedáca copa icáapi irìculéwa, abéechúa copa idènièchúa irìcuwa uva ituní. Yá íimaca nalí: —‍Yái uva ituníca, yácata nuíraná imusuéripinácawa nuíchawa cruz ìwali pirípinácuéwa, ipíchanácué Dios yùuwichàidacuéca pía pibáyawaná ìwalíisewa. Yái uva ituníca yáasáidacuéca pirí báisíiricani yái wàlisài wawàsi Dios imàníirica wenàiwicanái yáapicha nuwasàanápiná níawa Dios yàasu yùuwichàacáisi íicha, nuíranácáiná imusúapinácawa nuíchawa nalípináwa. ");
INSERT INTO pioNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Quéwa, siùcata yái asìalica itéeripináca nùuwidenái náibàacaténá núa, yácata yái yáawinéericáwacawa iyáaca iyáacaléwa núapicha. ");
INSERT INTO pioNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Núacáiná, núa asìali Dios néeséerica, nuétápinácawa càide iyúwaté profetanái itànàaná tàacáisi nuináwaná ìwali. ¡Quéwa máiní yùuwichàapinácawa yái asìalica itéeripináca nùuwidenái náibàacaténá núa! —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Néese Jesús yéewáidacalénái nadàbaca nasutáca néemìawa níawáaca chánácaalísica néená yái cài itéeripinácaté Jesús yùuwidenái náibàacaténáni, càmicáinátécáwa náalíawa càinácaalí Judas imàníinápináté. ");
INSERT INTO pioNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Néese níái yéewáidacaléca natàaníca nalíwáaca ùuléeri wawàsi iyú chánácaalí néená wenàiwicanái iiquéeripináté càiride iyúwa máiníiri cachàini áibanái íicha canánama. ");
INSERT INTO pioNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Quéwa Jesús íimaca nalí: “Chái èeri irìcu, càmíiyéi judío icuèrinánái nacùaca nàasu cáli néeséeyéiwa cachàiníiri iyú, nachùulìa nacái nàasu wenàiwicawa nacàlidáanápiná nàwali: ‘Cayábéeriquéi wacuèrinásàirica, imàníirica walí cayábéeri’, cài nachùulìaca nàasu wenàiwicawa nacàlidáanápiná. ");
INSERT INTO pioNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Quéwa, iwàwacutácué càmita pìya càide iyúwa nàyáaná. Cawinácaalícué péená iwàwéerica Dios iicácani càiride iyúwa cachàiníirica náicha canánama, néese iwàwacutá iicáca yáawawa càiride iyúwa máiníiri càmita cachàini náicha canánama, iyúwa piméeréericué, íibaidáanápiná áibanái irí canánama. Cawinácaalícué péená nacái iwàwéerica Dios imàacaca ichùulìaca áibanái wenàiwica, iwàwacutá íibaidacuéca pirí canánama càide iyúwacué pìasu wenàiwica imàníiná. ");
INSERT INTO pioNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Chái èeri irìcu níara máiníiyéica cachàini áibanái íicha náawinacawa mesa iwéré nayáacaténá nayáacaléwa, néese áibanái càmíiyéi cachàini náibaidaca nalí, natéca nalí nayáapináwa. Quéwa càmitacué nuwàwa pimànica càide iyúwa èeri mìnanái icuèrinánái imàníiná. Nudéca núasáidacuéca pirí càinácaalí iwàwacutáanácué pìyaca. Núa, Píiwacalicuéca, nudéca nùyaca pèewibàa càide iyúwa càmíiri cachàini, iyúwa wenàiwica íibaidéerica áibanái irí canánama. ");
INSERT INTO pioNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Pidécuéca pìyaca núapicha mamáalàacata, pìidenìacuéca nacái núapicha nùuwichàacái. ");
INSERT INTO pioNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Iná numàacapinácué picùaca núapicha wenàiwicanái càide iyúwa Núaniri Dios imàacáanáté nucùanápiná wenàiwicanái. ");
INSERT INTO pioNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Yá piyáapinácuéca piyáacaléwa núapicha Dios ìyacàle irìcu nucùacatalépináca macáita. Néenialípiná píawinacuécawa pìasu yàalubáisi íinatawa picùacaténácué doce namanùbaca Israel itaquénáinámi yàawiríaca”, íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Néese àniwa Jesús íimaca Pedro irí: —‍Simón, péemìa cayábani. Satanás idéca isutáca Dios íicha wawàsi imàacáanápiná Satanás yáalimáidacuéca iicáwa pía cachàiníiri iyú. ");
INSERT INTO pioNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Quéwa, nudéca nusutáca pirí Dios íicha, imàacáanápiná peebáidaca nulí mamáalàacata. Néese idécanáami piwènúadaca píiwitáisewa nulípiná àniwa, yá pichàiniada nawàwa, níái péenánáicawa neebáidacaténá nulí tài íiméeri iyú —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Néese Simón íimaca Jesús irí: —‍Nuíwacali, abédanama nuíwitáise píapicha nùanápiná presoíyéi ibànalìculé píapicha, éwita iwàwacutácaalí nuétácawa nacái píapichawa —‍íimaca yái Simón Pedroca. ");
INSERT INTO pioNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Jesús íimaca Pedro irí: —‍Pedro, péemìa cayába, ipíchawáise cawámai itàaca yáta catáquéi, yá pimànipiná pichìwawa máisiba yàawiría, píimapiná càmitasa píalía nùwali ipíchaná nanúaca pía núapicha —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Néese Jesús isutáca yéemìa nía: —‍Bàaluité nubànùacué pía picàlidacaténá nalí nutàacái, yáté càmitacué nubatàa pitéca saco, plata yàalu nacái, áiba costiza nacáiripiná nacái. Néeni, ¿iwàwacutéerisícuéwa pirí quirítani néenialíté? —‍íimaca yái Jesúsca. Néese náimaca irí: —‍Càmíiri —‍náimaca irí. ");
INSERT INTO pioNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Néese Jesús íimaca nalí àniwa: —‍Quéwa, siùca péemìacué comparación: Siùcade cawinácaalí idènièrica saco, iwàwacutá itéca yáapichawani, itéca nacái plata yàalu. Cawinácaalí canéerica irí espada machete nacáiri, iwàwacutá iwéndaca yàasu ruana nacáiriwa yúuquéeri ìwalíisewa, iwènìacaténá iríwa espada. ");
INSERT INTO pioNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Nudéca nucàlidacuéca pirí yái comparaciónca píalíacaténácuéwa càulenápináca píicha yái ichàbáanápinácawa mesúnamáita iwàwacutácáiná namànica nulí macáita iyúwaté profetanái itànàanáté tàacáisi Dios inùmalìcuíse. Abéeri profeta íimacaté nùwali: ‘Yá nàuwichàidapinácani báawéeyéi yáapicha’, càité itànàaca tàacáisi nuináwaná ìwali. Macáita tàacáisi natànèericaté nùwali Dios inùmalìcuíse, iwàwacutá ichàbacawa càitade iyúwaté natànàaná —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Néese náimaca Jesús irí: —‍Wáiwacali, ìyaca walí pucháiba espada machete nacáiri —‍náimaca. Yá Jesús íimaca nalí: —‍Yácata, wadéca watàaníca —‍íimaca yái Jesúsca, càmicáináté náalía néemìaca càinácaalíté íimáaná yái comparación Jesús icàlidéerica nalí. ");
INSERT INTO pioNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Néesetécáwa Jesús imusúacawa Jerusalén ìyacàlená irìcuíse. Càide iyúwaté íiwitáise ìyáaná néenialíté, yàacawa táiyápi dúli néré, íipidenéechúa Olivos, yái olivo inàlimanáca. Yéewáidacalénái nàacawa yáamiwáise. ");
INSERT INTO pioNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Jesús yàanàaca néré, yá íimaca nalí: —‍Pisutácué píawawa Dios íicha, càmíinápiná imàaca Satanás yáalimáidacuéca pía ipíchanácué pimànica pibáyawanáwa —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Néese Jesús yàacawa náicha càita meedá idècuni iyúwa asìali yúucacatalé íba. Yá ibàlùacawa yùuluì ipùata iyúwa néeni isutácaténá Dios íicha. ");
INSERT INTO pioNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Yá Jesús íimaca Dios irí: “Núaniri, piwàwacaalí, yá piwasàaca núa íicha yái nùuwichàanápinácawa. Quéwa, càmicaalí piwàwa piwasàaca núa, yá picá pimàni càide iyúwa nuwàwáaná, néese pimàni càide iyúwa piwàwáanáwa”, íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Yáta abéeri ángel chènuníiséeri imàacaca yáawawa Jesús iicácani. Yá ángel ichàiniadaca Jesús iwàwa. ");
INSERT INTO pioNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Máiní Jesús yùuwichàacawa manuísíwata idècunitàacá isutáca Dios íicha manuísíwata. Yá isìabèdeca imusúacawa íicha iyúwa irái idupíacaalíwa cáli iwéré. ");
INSERT INTO pioNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Idécanáami Jesús isutáca Dios íicha, yá imichàa ibàlùacawa, yàacawa yéewáidacalénái yàataléwa. Yá yàanàaca nía iiméeyéicáita máinícáiná achúmaca nawàwa, ínáté naimáca nàyaca. ");
INSERT INTO pioNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Néese Jesús íimaca nalí: —‍¿Cánácué piimá pìyaca? Pimichàacuéwa pidapùle íichawa. Pisutácué píawawa Dios íicha, càmíinápiná imàaca Satanás yáalimáidaca pía ipíchanácué pimànica pibáyawanáwa —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Idècunitàacá Jesús itàaníca nalí, yá madécaná wenàiwica yàanàaca nàatalé. Judas yàacawa náiwitápu, yái abéeri yéewáidacaléca, docenámica nía. Néese Judas yàacawa Jesús yàatalé isùsùacaténá Jesús inàni ìwali càide iyúwaté náiwitáise ìyáaná natàidáanáté wenàiwica cáininéerica naicáca. Càica Judas imànica yáasáidacaténá nalí cawinácaalíni, yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Néese Jesús íimaca irí: —‍Judas, ¿cáná picháawàa núa nùuwidenái iríwa iyú yái pisùsùanáca nunàni ìwali, càide iyúwa cáinináca nacáicaalí piicá núa, núa asìali Dios néeséerica? —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Níái yéewáidacaléca ìyéeyéica Jesús yáapicha naicácáiná càinácaalí Judas imàníinápináté, ínáté náimaca Jesús irí: —‍Wáiwacali, ¿piwàwasica wanúaca nía espada iyú? —‍náimaca. ");
INSERT INTO pioNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Néese abéeri néená níái yéewáidacaléca iwatàaca yàasu espada machete nacáiriwa. Yá yáalimáidaca ipéliacatatá, yá inúacatàatáni espada iyú sacerdote íiwacaliná yàasu wenàiwica. Quéwa isasàacáita asìali yùuwi yéewápuwáiséechúa. ");
INSERT INTO pioNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Quéwa Jesús íimaca yéewáidacalénái iríwa: —‍Pimàacacuéni, picácué pipélia —‍íimaca yái Jesúsca. Yá Jesús imàacaca icáapiwa yùuwi ìwali yái asìalica, yá ichùnìacani. ");
INSERT INTO pioNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Néese Jesús isutáca yéemìawa sacerdote íiwacanánái, nía nacái úwinái icuèyéica templo, nía nacái judío íiwacanánái béeyéica yàanèeyéicaté náibàacaténáni. Jesús íimaca nalí: —‍¿Cánácué pìanàa nùatalé cacáapisàiwaca, espada, wacàba nacái, càide iyúwa piicáaná cayéedéerimi? Càmitacué iwàwacutá cài pimànica càmicáinácué nupéliapiná píipunita. ");
INSERT INTO pioNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Macái èeri imanùbaca nùyacatécué píapicha templo irìcu, quéwa càmitatécué píibàa núa, ibatàa pidunùanápinácué nùwalita, càmitacué píibàa núa. Quéwa, siùcade Dios imàacacué píibàaca núa, yácata nacái Satanás yàasu èeri ichùulìacatáicuéca píiwitáise catéeri —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Néese náibàaca Jesús. Yá natéca Jesús sacerdote íiwacaliná icapèe néré. Pedro yàacawa náamiwáise déecuíseta. ");
INSERT INTO pioNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Ipíchawáiseté nàanàaca néré áibanái napucúadacaté quichái bamuchúami bàacháwalìcu. Níái úwinái náawinaca nàanabàca quichái. Néese Pedro yàanàaca néré yáawinaca nacáiwa yàanabàca náapicha. ");
INSERT INTO pioNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Néese inanái íibaidéechúa néeni uicáca Pedro yáawinacawa ìyaca yàanabàca quichái, yá uicáidaca irí. Néese úumaca nalí: —‍Yá asìaliquéi Jesús yáapichéeri —‍úumaca nalí. ");
INSERT INTO pioNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Quéwa, Pedro icàlidaca ichìwawa, íimaca càmitasa yáalía Jesús ìwali. Yá Pedro íimaca ulí: —‍Pía, inanái, càmita núalía ìwali —‍íimaca yái Pedroca, cáalucáináni. ");
INSERT INTO pioNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Néese áiba iicácani, yá íimaca Pedro irí: —‍Pía nacái néená, níara yáapichéeyéica —‍íimaca. Quéwa Pedro íimaca irí: —‍Càmíirita, asìali, càmíirica néená núaquéi —‍íimaca yái Pedroca, ipíchaná náibàacani. ");
INSERT INTO pioNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Néese batéwa abéeri hora idénáami àniwa áiba íimaca nalí àniwa cachàiníiri iyú: —‍Báisíta, yáapichéerimicani yái asìalica, yácáiná Galilea yàasu cáli néeséeri nacáicani —‍íimaca nalí Pedro ìwali. ");
INSERT INTO pioNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Quéwa Pedro íimaca irí: —‍Pía, asìali, càmita núalíawa càinácaalí íimáanáca yái píiméerica —‍íimaca yái Pedroca. Idècunitàacá Pedro itàaníca nalí, yáta cawámai itàaca. ");
INSERT INTO pioNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Néese Jesús iwènúa iicáidaca Pedro irí, yáta Pedro iwàwalica tàacáisi Jesús icàlidéericaté irí: “Ipíchawáise cawámai itàaca yáta catáquéi, yá pimànipiná pichìwawa máisibàawiría, píimapiná càmitasa píalía nùwali”, càité Jesús íimaca Pedro irí. ");
INSERT INTO pioNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Yá Pedro imusúacawa náicha, yá íicháaníca cachàiníiri iyú. ");
INSERT INTO pioNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Néese níái úwica icuèyéica Jesús, naicáaníca iquíniná, nanúadáidaca nacái Jesús. ");
INSERT INTO pioNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Nabàlìaca Jesús ituí, yá nanúadáidaca inàni ìwali. Néese náimaca Jesús irí: —‍Piwicùlida, picàlida walíni, ¿cawinásica níara inúadáidéeyéica pía? —‍náimaca, naicáaníca iquíniná. ");
INSERT INTO pioNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Yá natàaníca ìwali madécaná báawéeri iyú, mamáalàacata naicáaníca Jesús iquíniná, nabáiniadacaténáni. ");
INSERT INTO pioNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Néeseté amaláca yàacawa nawicáu, yá úwinái natéca Jesús Junta Suprema yàatalé ìwacáidáyaquéeyéicawa, judío íiwacanánái, sacerdote íiwacanánái nacái, nía nacái yéewáidéeyéica wenàiwica templo irìcu. Yá nasutáca néemìawa Jesús: ");
INSERT INTO pioNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","—‍Picàlida walíni, ¿píatasica yái Mesíasca, judío icuèrináca Dios ibànuèripinácaté walí? —‍náimaca. Néese Jesús íimaca: —‍Nucàlidacaalícué pirí núacatáni, néese càmitacué peebáida nulítáni. ");
INSERT INTO pioNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Nusutácaalícué nuémìawa píatá, càmitacué picàlida nulítáni. ");
INSERT INTO pioNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Mesúnamáita quéwa núa, asìali Dios néeséerica, núawinapináwa yéewápuwáise yái Dios cachàiníirica náicha canánama, nucùacaténá macáita Dios yáapicha chènuniré —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Yá macáita nasutáca néemìawani: —‍Néeni, ¿Dios Iirisica pía? —‍náimaca. Néese Jesús íimaca nalí: —‍Yáca núa yái càide iyúwacué píimáaná —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Yá náimaca nalíwáaca: —‍¡Canácata iwàwacutáaná wéemìaca áiba icháawèeri iináwaná ìwali quirínama! ¡Wadéca wéemìaca itàacái báawéeri, icàlidaca ìwaliwa Dios Iiricasani! —‍náimaca nalíwáaca. ");
INSERT INTO pioNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Néese macáita namichàacawa natéca Jesús Pilato gobernador yàatalé, yái romanosàiri icuèricaté Judea yàasu cáli. ");
INSERT INTO pioNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Néese nadàbaca nacháawàaca Jesús iináwaná ìwali Pilato irí, yá náimaca Pilato irí: —‍Wadéca wàanàaca yái asìalica báawéerica imànica wàasu cáli néeséeyéi íiwitáise namàníinápiná ùwicái gobierno íipunita. Iimaca càmitasa cayába wapáyaidaca wáichawa emperador plata iyú, yái romano icuèrinásàirica. Iiméerica ìwaliwa nacái Mesíascani, yái judío icuèrinácasa —‍náimaca. ");
INSERT INTO pioNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Néese Pilato íimaca Jesús irí: —‍¿Píatasica judío icuèrinásàirica? —‍íimaca. Néese Jesús íimaca irí: —‍Báisíta, núacani, càide iyúwa píimáaná —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Néese Pilato íimaca sacerdote íiwacanánái irí, áibanái nacái ìyéeyéica néeni: —‍Càmita nuicá ìwali ibáyawaná, yái asìalica —‍íimaca yái Pilatoca. ");
INSERT INTO pioNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Náimaca quéwa cachàiníiri iyú mamáalàacata: —‍Báawaca imànica macái wenàiwica íiwitáise náináidáanápiná namànica ùwicái gobierno íipunita. Idéca yéewáidaca macáita Judea yàasu cáli néeséeyéi. Idàbacaté yéewáidaca wenàiwica Galilea yàasu cáli néré. Siùcade iwàwa yéewáidaca wenàiwica chái Jerusalén ìyacàlená irìcu —‍náimaca. ");
INSERT INTO pioNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Néese Pilato yéemìaca nalíni, íná isutáca yéemìawa nía asáisí Galilea yàasu cáli néeséericaalíni, yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Néese idécanáami Pilato yáalíacawa Galilea néeséericani, yá Pilato ichùulìaca natéca Jesús rey Herodes yàatalépiná, Herodes icùacáináté Galilea yàasu cáli. Néenialíté Herodes ìyaca Jerusalén ìyacàlená irìcu iicácaténá náapicha Pascua yàasuná culto. Iná natéca Jesús Herodes yàatalé. ");
INSERT INTO pioNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Néese Herodes iicácáiná Jesús, yá casíimáica Herodes iwàwa, madécaná èericáináté Herodes iwàwaca iicáca Jesús. Herodes yéemìacáináté Jesús iináwaná ìwali, ínáté iwàwa iicáca Jesús imànica áiba wawàsi íiwitáise iyúwa, càmíirica wenàiwica idé imànica. ");
INSERT INTO pioNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Néese Herodes isutáca yéemìawa Jesús madécaná yàawiría. Quéwa Jesús càmíirita itàaní. ");
INSERT INTO pioNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Néese sacerdote íiwacanánái, nía nacái yéewáidéeyéica wenàiwica templo irìcu ìyéeyéica néeni, nacháawàaca Jesús iináwaná ìwali mamáalàacata cachàiníiri iyú. ");
INSERT INTO pioNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Néese Herodes, nía nacái yàasu úwinái yáapichéeyéica namànica Jesús irí báawéeri nabáiniadacaténáni, natàaníca nacái ìwali báawéeri iyú. Néese náucaca cayábéeri bàlesi Jesús ìwalíise, cawèníiri nacái càide iyúwa romano icuèriná ibàle, nacuèrinásàiri naicácaténásatáni, yái Jesúsca. Càité úwinái imànica naicáanícaténá Jesús iquíniná. Néese Herodes ichùulìaca natéca Jesús àniwa Pilato yàatalépiná. ");
INSERT INTO pioNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Quéechatécáwa Pilato, Herodes nacái nàuwideca namàníiyéicacawa. Yáté èerica Pilato, Herodes imànica yàacawéeriná iyúwani. ");
INSERT INTO pioNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Néeseté Pilato ìwacáidaca sacerdote íiwacanánái, judío íiwacanánái nacái, madécanáca áibanái wenàiwica náapicha néeni. ");
INSERT INTO pioNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Yá Pilato íimaca nalí: —‍Pidécuéca pitéca nùatalé yái asìalica. Pidécuéca picàlidaca nulí iináwaná. Pidécuéca picháawàaca iináwaná ìwali píimacáinácué yéewáidacasa wenàiwica namàníinápiná ùwicái gobierno íipunita. Quéwa, nudécata nusutáca nuémìawani pìacuésemicué, yá canácata nuiquéeri ìwali ibáyawanáca càide iyúwacué picháawàaná iináwaná ìwali. ");
INSERT INTO pioNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Herodes nacái canácata iiquéeri ìwali ibáyawaná, íná Herodes idéca ibànùacani néese àniwa wàataléta. Pidécuéca piicáca canácata ìwali ibáyawaná wanúanápinátáni. ");
INSERT INTO pioNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Iná siùcata nuchùulìaca nacapèedáidáanápináni. Idécanáami nacapèedáidacani, yásí numàaca yèepunícawa —‍íimaca yái Pilatoca. ");
INSERT INTO pioNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Càide iyúwaté náiwitáise Pascua yàasuná culto imanùbacata, iwàwacutá Pilato iwasàaca nalí abéeri presoíri yèepunícaténáwa casíimáicaténá judíonái. Ináté Pilato iwàwaca imàacaca Jesús yàacawa. ");
INSERT INTO pioNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Quéwa, macáita néemíanícawa macáita namanùbaca iyúwa: —‍¡Pinúacuéni! Pimàacacué Barrabás yèepunícawa —‍náimaca. ");
INSERT INTO pioNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Iyacáináté presoíri íipidenéerité Barrabás imàníiricaté ùwicái yàcalé irìcu gobierno íipunita, íná náibàacaténi, inúacáináté nacái wenàiwica. ");
INSERT INTO pioNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Néese Pilato itàaníca judíonái yáapicha àniwa iwàwacáiná imàacaca Jesús yèepunícawa. ");
INSERT INTO pioNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Néemíanícawa quéwanáta máiní cachàiníiri nasàna iyúwa. Càica náimaca: —‍¡Pinúacuéni! ¡Pitàtàacuéni cruz ìwali! —‍náimaca. ");
INSERT INTO pioNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Néese Pilato itàaníca náapicha máisiba yàawiríanápiná itàaníca náapicha. Iimaca nalí: —‍Néeni, ¿càinásica ibáyawanácué pirí? Canácata nuiquéeri ibáyawanáca numàacáanápiná nanúacatáni. Siùcata nuchùulìa nacapèedáidacani. Idécanáami nacapèedáidacani, yásí numàaca yèepunícawa —‍íimaca yái Pilatoca. ");
INSERT INTO pioNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Néemíanícawa àniwa lúasi iyú, nasutáca Pilato íicha ichùulìanápiná úwinái inúanápiná Jesús. Máinícáiná néemíanícawa mamáalàacata, íná Pilato imàacaca nalíni átata, càide iyúwa nasutáaná íichani. ");
INSERT INTO pioNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Càité Pilato iwènúadaca íiwitáisewa imàacáanápiná nanúaca Jesús càide iyúwa nasutáaná íichani. ");
INSERT INTO pioNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Iná Pilato imàacaca Barrabás yèepunícawa, yái presoíri nasutéerica Pilato íicha, ìyéericaté presoíyéi ibànalìcu imànicáináté ùwicái yàcalé irìcu, inúacáináté nacái wenàiwica. Quéwa, Pilato yèepùadaca nalí Jesús namànicaténá irí càide iyúwa nawàwáaná. ");
INSERT INTO pioNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Néese, idècunitàacá úwinái itéca Jesús nanúacaténáni, yá náibàaca asìali Cirene ìyacàlená néeséerica, íipidenéerica Simón, yèeriwa manacúali néese. Nachùulìaca Simón iwáacutaca Jesús yàasu cruz yàacaténáwa Jesús yáamiwáise, canácáiná quirínama Jesús ichàini, úwinái icapèedáidacáináté báawanamani. ");
INSERT INTO pioNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Madécaná wenàiwica, inanái nacái manùbéeyéi, nàacawa Jesús yáamiwáise. Níái inanái náicháaníca manuísíwata Jesús ìwali, máinícáiná achúmaca nawàwa. ");
INSERT INTO pioNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Néese, Jesús iwènúa iicáidaca nalí, níái inanáica. Yá íimaca nalí: —‍Píacué inanái Jerusalén ìyacàlená mìnanái. Picácué píicháaní nùwali. Néese píicháanícué pìwaliwata, péenibe ìwali nacáiwa. ");
INSERT INTO pioNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Aibaalípiná piùwichàacuéwa báawanama. Yá píimapinácué piríwáaca: ‘Casíimáica cawinácaalí inanái càmíiyéica yáalimá quéenibeca. Casíimáica nacái cawinácaalí càmíiyéicaté idéerìcuca. Casíimáica nacái cawinácaalí càmíiyéicaté yàaca quìrasìi ìira ìinisi’, càipiná píimacuéca piríwáaca, níacáiná inanái quéenibéeyéica náicháanípináca néenibemi ìwaliwa. ");
INSERT INTO pioNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Néese áibanái péenácué náimapiná manuínaméeyéi dúli irí: ‘¡Picaláawa wáinatabàa, yéewacaténá wéetácawa ráunamáita!’, càipiná náimaca. Néese àniwa náimaca áiba dúli irí: ‘¡Pibàlìacué wía!’ càipiná náimaca. ");
INSERT INTO pioNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Nanúaca núa mabáyawanéerica siùca èeri càmicatái namàni úwi. ¡Cáanáica nàuwichàidapinácué píawa namànicaalípiná ùwicái píipunitacué! —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Níái úwinái natéca pucháiba cabáyawanéeyéi nanúacaténá nía Jesús yáapicha. ");
INSERT INTO pioNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Néese nàanàaca aléera íipidenácataléca La Calavera, íimáanáca “Iiwitasi yáapimi ìyacatalé”. Yá natàtàaca Jesús cruz ìwali. Natàtàaca nacái pucháiba báawéeyéi íiwitáise. Néese úwinái nabàlùadaca máisiba cruz nàasu utàwi irìculéwa. Abéeri cruz ibàlùacawa Jesús yéewápuwáise. Aiba cruz nacái ibàlùacawa apáulìcuíse Jesús irí. ");
INSERT INTO pioNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Idècunitàacá úwinái natàtàaca Jesús, yá Jesús íimaca Dios irí: —‍Núaniri, pimàaca piwàwawa nabáyawaná íicha càmicáiná náalíawa cawinácaalí núa yái nanuérica —‍íimaca yái Jesúsca. Néese úwinái náucaca náichawa suerte naseríacaténá nalíwáaca Jesús ibàlemi. ");
INSERT INTO pioNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Madécaná wenàiwica nabàlùa naicáidaca Jesús irí. Níata nacái judío íiwacanánái iicáaníca Jesús iquíniná. Yá náimaca nalíwáaca: —‍Ichàiniadacaté áibanái yéetácáisi íicha ipíchanáté néetácawa. Báisícaalí Mesíascani, yái wacuèrinápináca Dios ibànuèrica walí, néese ¿cáná càmita ichàiniada yáawawa ipíchaná yéetácawa? —‍náimaca nalíwáaca, naicáaníca Jesús iquíniná. ");
INSERT INTO pioNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Nía nacái úwináica naicáaní nacái iquíniná, nabáiniadacaténáni. Nàa nabàlùacawa mawiénita irí, namichàidaca mawèníiri uva ituní càaméeri ìiracaná mawiénita inùma irí náimacáiná nàacasa icàaluíniná iyúwa nacuèriná nacáiricasani. Càita namànica naicáanícaténá Jesús iquíniná meedá, bàaluitécáiná romanonái yàaca icuèrináwa ìirapiná uva ituní. ");
INSERT INTO pioNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Náimaca Jesús irí: —‍¡Báisícaalí judío icuèrináca pía, yá pichàiniada píawawa yéetácáisi íicha ipíchaná péetácawa! —‍náimaca Jesús irí, naicáaníca iquíniná. ");
INSERT INTO pioNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Nachanàidaca tàacáisi Jesús íiwita iwicáubàa. Máisiba tàacáisi íiwitáaná ichanàawa néeni, griego itàacái iyú, latín itàacái iyú nacái, hebreo itàacái iyú nacái. Yái tàacáisi íimáanáca: “Yái ibàluèricawa chái, yácata judío icuèrináca”, íimáanáca yái tàacáisica. ");
INSERT INTO pioNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Néese abéeri báawéeri íiwitáise natàtèerica nacái yàasu cruz ìwaliwa, mawiénita Jesús yàasu cruz irí, itàaníca báawéeri iyú Jesús irí. Iimaca Jesús irí: —‍Báisícaalí Mesíasca pía, yái judío icuèrinápináca, néese pichàiniada píawawa yéetácáisi íicha. Pichàiniada nacái wía yéetácáisi íicha ipíchaná wéetácawa —‍íimaca. ");
INSERT INTO pioNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Néese áiba báawéeri íiwitáise natàtèerica nacái yàalàaca yáapichéeriwa cachàiníiri iyú. Iimaca: —‍¿Cáná càmita cáalu piicá Dios?, pía nàuwichàidéerica càide iyúwa nàuwichàidáaná yái asìalica. ");
INSERT INTO pioNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Wàuwichàacawa wàyaca wabáyawaná ichùulìacawa wamànicáináté wabáyawanáwa. Quéwa, yái asìaliquéi, mabáyawanéerita —‍íimaca. ");
INSERT INTO pioNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Néese isutáca Jesús íicha wawàsi: —‍Jesús, piwàwali núa nùyacaténá píapicha pidàbacaalípiná picùaca canánama wenàiwica —‍íimaca. ");
INSERT INTO pioNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Néese Jesús íimaca irí: —‍Péemìa cayába, siùca èeri pìyapináca núapicha paraíso irìcuwa —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Néese machacànicaalíté èerica, yá catáca báawanama èeri icamaláná macái chái èeri irìcu. Máisiba horaca catáca, àta las tresta táicalé. ");
INSERT INTO pioNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Yái èeri icamalánáca càmita icàna. Yá nacái manuíri yáawàanáca templo irìcuírica icacanácawa bamuchúamibàa cáli iwérénama pucháibawaca yèewi, yái yáawàanáca ibàlièrica mabáyawanéeri Dios ìyacatáica wenàiwica ituí íicha. Yá icacanácawa chènuníise cáli iwérénama yái manuíri yáawàanáca. ");
INSERT INTO pioNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Néese Jesús íimaca cachàiníiri iyú Dios irí: —‍¡Núaniri, nubànùa nucáucawa pirí aléera picáapi irìculé! —‍íimaca yái Jesúsca. Idécanáami cài íimaca, yá imàacaca icáucawa yàacawa, yá yéetácawa. ");
INSERT INTO pioNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Yái úwi íiwacalináca romanosàiri iicácáináté càinácaalí ichàbáanáwa, yá yàaca Dios irí cayábéeri. Néese íimaca: —‍Báisícata mabáyawanéerica yái asìalimica —‍íimaca. ");
INSERT INTO pioNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Macáita wenàiwica ìyéeyéica néeni idécanáami naicáca yéetácawa, yá nèepùacawa néese, máiní achúmaca nawàwa, cáaluca nía nacái. ");
INSERT INTO pioNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Macáita quéwa níái yáaliéyéica Jesús ìwali, nía nacái inanáica yèeyéicatéwa yáapicha Galilea yàasu cáli néese, nabàlùaca naicáidaca irí déecuíseta naicácaténá càinácaalí ichàbáanápinátéwa. ");
INSERT INTO pioNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Iyacaté áiba asìali cayábéeri íiwitáise, yeebáidéerica Dios itàacái, íipidenéeri José, Arimatea ìyacàlená mìnali, yái yàcalé ìyéerica Judea yàasu cáli íinata. Yái José abéeri néenáca, níái judío íiwacanánáica, Junta Supremanáica. José iwàwacaté Dios icùaca macáita. Ináté càmita yéewa abédanama José íiwitáise judío íiwacanánái yáapicha iwàwéeyéicaté inúaca Jesús. ");
INSERT INTO pioNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Iná José yàacawa Pilato gobernador yàatalé. Isutáca Pilato íicha wawàsi yàanápiná irí Jesús iinámi. Yá Pilato imàacaca José iríni. ");
INSERT INTO pioNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Néese José yàacawa cruz yàatalé. Yá iricùadaca Jesús iinámi cruz ìwalíise, yá yéepùacani linoíri wáluma iyú, càide iyúwa judío íiwitáise ìyáaná. Néese iwàlùadaca Jesús iinámi càliculìi irìculé. Yái càliculìi áibanái náicacaténi dúli ibàlàirìcu yéewanápiná càliculìicani, iyúwa capìi imàdáaná. Yái càliculìi wàlisàicatàacáwa, canácatái nabàlièricáwa. ");
INSERT INTO pioNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Yáté èerica viernesca nachùnìacatáipiná yàacàsi sábado piná, ipíchawáise sábado judíonái iyamáidacatáicawa. Catácalìcubàa yàacawa, yá idàba sábado nayamáidacatáipináwa. Ináté iwàwacutá nawàlùadaca Jesús iinámi caquialéta càliculìi irìculé. ");
INSERT INTO pioNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Abénaméeyéi inanái yèeyéicatéwa Jesús yáapicha Galilea yàasu cáli néese, nàaca naicáca càliculìi, yá naicáca càinácaalí iyú nawàlùadaca Jesús iinámi càliculìi irìculé. ");
INSERT INTO pioNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Néese nèepùacawa nacapèe néréwa, yá nachùnìaca pumèníiri isàni, pomada nacáiri nacái napusúadacaténáni Jesús iinámi ìwali, càide iyúwa judíonái imàníiná yéetéerimiwa irí. Néese nayamáidacawa sábado irìcu càide iyúwaté Dios ichùulìaná judíonái. ");
INSERT INTO pioNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Néeseté, domingo irìcu, níái inanáica nàacatéwa càliculìi nérépiná mapisáisíwata. Natéca pumèníiri isàni nachùnièricaté. Aibanái inanái nacái nàacawa náapicha. ");
INSERT INTO pioNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Nàanàaca càliculìi néré, yá naicáca íba ibàluèricawa méetàucuta càliculìi inùma íicha, nabàlìanáca càliculìi inùma. ");
INSERT INTO pioNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Yá nawàlùacawa néré, yá canáta naiquéeri néeni Wáiwacali Jesús iinámica. ");
INSERT INTO pioNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Cáaluca nía, càmita náalíawa càinácaalí íimáaná. Yáta naicáca pucháiba asìanái mèlumèluíyéi ibàle ibàluèyéicawa mawiénita nalí. ");
INSERT INTO pioNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Máiní cáaluca níái inanáica, yá naicáidaca cáliaculé. Quéwa níái asìanáica náimaca nalí: —‍¿Cánácué picutá yáara cáuri wenàiwicaca chái yéetáními yèewiré? ");
INSERT INTO pioNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Canáca cháníi. Idéca icáucàacawa. Piwàwalicué yái tàacáisi icàlidéericatécué pirí idècunitàacá ìyaca Galilea yàasu cáli néese. ");
INSERT INTO pioNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Iimacatécué pirí iwàwacutáanápináté presoca namànicani namàacacaténáté cabáyawanéeyéi wenàiwica natàtàacani cruz ìwali yéetácaténátéwa, yái asìali Dios néeséerica. Iimacatécué pirí nacái icáucàanápinátéwa máisiba èeri irìcu —‍náimaca. ");
INSERT INTO pioNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Yá inanái nawàwalica yái tàacáisica Jesús icàlidéericaté nalí. ");
INSERT INTO pioNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Néese nèepùacawa càliculìi íicha. Nacàlidaca nalíni níái oncéeyéica imanùbaca apóstolca, áibanái irí nacái náapichéeyéica. ");
INSERT INTO pioNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Níái inanái icàlidéeyéica tàacáisi Jesús yéewáidacalénái irí náipidená María Magdalena, Juana nacái, Santiago yáatúa nacái, íipidenéechúa María, áibanái inanái náapichéeyéi nacái. ");
INSERT INTO pioNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Quéwa, apóstolnái càmita neebáida nalíni, nayúunáidacáita canéeri iwèni tàacáisica meedáni. ");
INSERT INTO pioNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Quéwa Pedro ipìacawa càliculìi néré. Néese yáawiaca iicáidaca càliculìi imàdáaná irìculé, yá iicáca níawamita ibàlemi néepùanáté Jesús iinámi. Néese Pedro yèepùacawa icapèe néréwa. Iináidacawa iwàwalìcuísewa càinácaalísica ichàbáanátéwa. ");
INSERT INTO pioNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Yáté èericaté pucháiba Jesús yéewáidacalénái nèepùacawa nàyacàle nérépináwa, íipidenácatalé Emaús. Once namanùbaca kilómetro idècuni ìyaca Jerusalén ìyacàlená íicha. ");
INSERT INTO pioNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Natàaní nàacawa nalíwáaca ìwali yái Jesús yéetáanácawa. ");
INSERT INTO pioNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Idècunitàacá natàaníca nàacawa nalíwáaca Jesús iináwaná ìwali, yá Jesús yàacawa mawiénita nalí àyapulìcubàa. Yá yàacawa náapicha. ");
INSERT INTO pioNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Ewita naicácáanítani, càicáaníta càmita náalía Jesúscani. ");
INSERT INTO pioNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Néese Jesús isutáca yéemìawa nía: —‍¿Càiná ìwalicué pitàaní pìacawa àyapulìcubàa? —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Yá nayamáa nabàlùacawa, achúmaca nawàwa. Abéeri néená íipidenéeri Cleofas íimaca Jesús irí: —‍Macáita Jerusalén ìyacàlená mìnanái náalíacawa ìwali yái namàníiricaté Jerusalén ìyacàlená irìcu áténama, siùca nacáide. ¿Abéeritasica pía càmíirita yáalíawa nèewíise macáita ìyéeyéica Jerusalén ìyacàlená néeni? —‍íimaca. ");
INSERT INTO pioNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Jesús isutáca yéemìawa nía: —‍¿Càináté ìyaca néeni? —‍íimaca yái Jesúsca. Yá náimaca Jesús irí: —‍Wadéca watàaníca walíwáaca Jesús iináwaná ìwali yái Nazaret ìyacàlená néeséerica, abéeri profeta icàlidéerica Dios itàacái cáimiétacawaca macái wenàiwica irí, imàníirica nacái nalí yái càmíirica wenàiwica idé imànica. ");
INSERT INTO pioNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Watàaníca nacái sacerdote íiwacanánái ìwali, judío íiwacanánái ìwali nacái, yái presonáca namànicani namàacacaténá romanonái inúacani, yéewanápiná nanúacani cruz ìwali. ");
INSERT INTO pioNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Quéwa, wíacaté nacái watuíyàacaté Jesús iwasàanápináté wía, wía Israel itaquénáinámica, wàuwidenái íichawa. Siùca èeri idéca idènìaca máisiba èeri nanúacadénáamini. ");
INSERT INTO pioNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Quéwa abénaméeyéi inanái ìyéeyéica wèewi siùca èeri nacalùadaca wía bàwinacáiná mapisáisíwata nàaca naicácaténá càliculìi néré. ");
INSERT INTO pioNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Canáta quéwa nàanèeri Jesús iinámica néeni. Yá nèepùacawa nacapèe néréwa. Néese nacàlidacaté walíni naicácasa ángelnái yéenáiwanási nacáiri irìcuíse. Angelnái náimaca inanái irí cáucasa Jesús. ");
INSERT INTO pioNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Néese áibanái asìanái wáapichéeyéi nàacawa càliculìi néré, yá nàanàaca néeni càide iyúwa inanái icàlidáanáté walíni, càmíiritàacá quéwa naicá Jesús —‍náimaca Jesús irí. ");
INSERT INTO pioNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Néese Jesús íimaca nalí: —‍¡Càmíiyéicué yáalíawa pía, máinícué càulenáca píichani, peebáidáanápinácué macáita tàacáisi profetanái icàlidéericaté Dios inùmalìcuíse! ");
INSERT INTO pioNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Nacàlidacatécué piríni machacàníiri iyú iwàwacutáanápináté Mesías yùuwichàacawa ipíchawáiseté wenàiwica nàaca icàaluíniná, yái judío icuèrinápináca —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Néese Jesús idàbaca icàlidaca nalíni macáita iyúwaté profetanái itànàaná tàacáisi Dios inùmalìcuíse. Quéechacáwa icàlidaca nalí tàacáisi profeta Moisés itànèericaté Jesús ìwali, áibanái profeta nacái icàlidéeyéicaté tàacáisi Jesús ìwali Dios inùmalìcuíse. Yéewáidaca nía náalíacaténá néemìaca càinácaalí íimáaná macáita tàacáisi profetanái itànèericaté Mesías ìwali, yái judío icuèrinápináca. ");
INSERT INTO pioNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Néeseté nàanàaca nàyacàle néréwa. Quéwa Jesús iwàwacaté yàacawa áibaléta. ");
INSERT INTO pioNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Yá nasutáca íicha wawàsi iyamáanápináwa náapicha nacapèe irìculé. Yá náimaca irí: —‍Piyamáawa wáapicha máinícáiná catáca yàacawa —‍náimaca. Yá Jesús iwàlùacawa nacapèe irìculé náapicha iyamáacaténáwa. ");
INSERT INTO pioNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Néese náawinacawa mesa iwéré nayáacaténá nayáacaléwa, yá Jesús yeedáca pan icáapi irìculéwa, yá yàaca Dios irí cayábéeri, néese isubèriadacani, yá iwacùaca nalíni, yái panca. ");
INSERT INTO pioNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Yáta náalíaca naicácani, yá náalíacawa Jesúscani. Yáta ichalíacawa natuí íicha. ");
INSERT INTO pioNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Yá náimaca nalíwáaca: —‍Báisícata Jesúscani. Yácata Jesús yái cài icàlidéerica walíni càinácaalí íimáaná Dios itàacái àyapulìcubàa, íná yéewa wawàwa yáalanícatéwa ìyaca —‍náimaca nalíwáaca. ");
INSERT INTO pioNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Yá càmita nayamáawa nacapèe irìcuwa, néese nèepùacàatécatawa Jerusalén ìyacàlená néré àniwa. Nàacawa once namanùbaca apóstolnái yàatalé ìwacáidáyaquéeyéicawa, áibanái yáapicha. ");
INSERT INTO pioNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Néese apóstolnái náimaca nalí, níái pucháiba yàanèeyéica nàatalé: —‍Báisíta, Wáiwacali idéca icáucàacawa. Simón Pedro idéca iicácani —‍náimaca nalí. ");
INSERT INTO pioNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Néese níái pucháiba Emaús ìyacàlená néeséeyéica nacàlidaca nalí càinácaalíté ichàbáanáwa àyapulìcubàa. Nacàlidaca nacái nalíni náalíacatéwa Jesúscani isubèriadacaalíté pan. ");
INSERT INTO pioNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Idècunitàacá natàaníca, yáta Jesús yàanàaca ìyaca nèewi. Yá íimaca nalí: —‍¿Néenicué? Matuíbanáicué pía —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Cáaluca nía manuísíwata nayúunáidacáiná iwàwanásicani yái cài naicáca. ");
INSERT INTO pioNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Yá Jesús íimaca nalí: —‍¿Cánácué cáalu pía? ¿Cánácué càmita peebáida núacani? ");
INSERT INTO pioNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Piicácué yái nucáapica, nùabàli nacái, útuwi yáami, núacata yái. Pimàacacué picáapiwa nùwali piicáwa. Canáca wenàiwica icáucami iiná, yáapi nacái, quéwa núa, cáapica núa, caináca nacái núa, ínácué yéewa píalimá píalíacawa cáuca núa —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Idécanáami icàlidaca nalíni, yá yáasáidaca naicá icáapiwa, yàabàli nacáiwa, útuwi yáami. ");
INSERT INTO pioNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Càmitàacá neebáida Jesúscani máinícáiná nayanídacawa casíimáicáiná nía. Néese Jesús íimaca nalí: —‍¿Pidènìasicué yàacàsi? —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Yá nàaca irí cubái imìdecaná yéená, mába ituní nacái nàaca irí. ");
INSERT INTO pioNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Yá yeedáca yàacàsica, yá naicáca iyáacani. ");
INSERT INTO pioNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Néese Jesús íimaca nalí: —‍Idècunitàacá nùyaca píapichacué, nucàlidacatécué pirí macáitani càinácaalíté nuchàbáanápinátéwa. Iwàwacutáté numànica càitade iyúwaté profetanái itànàaná tàacáisi nuináwaná ìwali. Profeta Moisés itànàacaté tàacáisi nùwali càide iyúwa Dios ichùulìanáté itànàaca. Profetanái nacái, áibanái nacái itànèeyéicaté Salmos nacàlidacaté tàacáisi nuináwaná ìwali. Yá macáita idéca ichàbacawa càide iyúwaté natànàaná —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Néese Jesús imàacaca náalíacawa cayába càinácaalí íimáaná yái Dios itàacáica. ");
INSERT INTO pioNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Yá íimaca nalí àniwa: —‍Natànàacaté tàacáisi íiméerica iwàwacutáanápináté nuétácawa, núa Mesíasca, judío icuèrinápináca. Quéwa, náimacaté numichàanápinátéwa yéetácáisi íicha máisiba èeri irìcu. Bàaluité profetanái itànàacaté nacái tàacáisi íiméerica iwàwacutáanápinácué picàlidaca nuináwaná ìwali canánama èeri mìnanái irí. ");
INSERT INTO pioNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Quéechacáwa iwàwacutácué picàlidaca nalíni chái Jerusalén ìyacàlená irìcu. Picàlidacué nacái macáita wenàiwicanái iríni neebáidacaténá nutàacái, namàacacaténá náichawa nacái yái báawéerica namàníirica yéewacaténá Dios imàacaca iwàwawa nabáyawaná íicha. ");
INSERT INTO pioNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Píacué nuéwáidacaléca, pidécuéca piicáca macáita yái numàníirica. ");
INSERT INTO pioNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Aibaalípiná nubànùacuéca Espíritu Santo piwàwa irìculé càide iyúwa Núaniri Dios íimáanátécué pirí, pimànicaténácué càide iyúwa Dios iwàwáaná. Piyamáacuéwa cháta Jerusalén ìyacàlená irìcu. Picácué pimusúawa íicha àta Espíritu Santo yàanàacatalépináta iwàlùacawa piwàwalìculécué, yèeripinácué pichàini chènuníiséerica —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Néesetécáwa Jesús itéca nía méetàuculé Jerusalén ìyacàlená íicha. Yá nàanàaca Betania ìyacàlená néré. Yá imichàidaca icáapiwa napualé. Yá isutáca nalí Dios íicha imàníinápiná nalí cayábéeri. ");
INSERT INTO pioNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Idècunitàacá isutáca nalí Dios íicha, yá yàacawa náicha, imichàacawa náicha chènuniré. ");
INSERT INTO pioNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Nàaca icàaluíniná, néese nèepùacawa Jerusalén ìyacàlená irìculé casíimáiri iyú. ");
INSERT INTO pioNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Yá nàyaca èeri imanùbaca templo irìcu, yèeyéica Dios irí cayábéeri.");
INSERT INTO pioNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Jesucristo ìyacaté bàaluité ipíchawáise idàbacawa yái èeriquéi. Yái Jesucristoca, yácata Tàacáisi imàaquéerica wáalíacawa Dios ìwali. Iyacaté abédanaméeri íiwitáise Dios yáapicha, yái Dios yáapichéerica Jesucristo. Yácata Wacuèriná Dioscani, yái Jesucristoca, bàaluité èeri, siùca nacáide. ");
INSERT INTO pioNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Yái Jesucristoca, yáté ìyaca Dios yáapicha èeri ipíchawáise. ");
INSERT INTO pioNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Dios imàacacaté Jesucristo idàbaca macái wawàsi. Canácata wawàsi ìyéerica càmíirité Jesucristo idàba, canásíwa. Yácata imàníiricaté macáita. ");
INSERT INTO pioNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Yái Jesucristoca, yácata yèerica nacáuca, macáita yái ìyéerica. Yái Jesucristo yèerica macái wawàsi icáuca, yácata nacái imàaquéerica wenàiwica náalíacawa càinácaalí iwàwacutáaná namànica nàyacaténá machacàníiri iyú báisíiri tàacáisi ìwali càide iyúwa camalási imàacacaalí waicáca amaláwaca. ");
INSERT INTO pioNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Yái Jesucristoca imàacaca wáalíacawa ìyaca càide iyúwa camalási icànéeri catéeri irìculé. Yàanàacaté aléi èeri irìculé amalácaténá imànica wenàiwicanái íiwitáise yéewanápiná càmita quirínama namàni càide iyúwa catéeri íiwitáise Satanás ichùulìaná nía. Satanás càmitaté idé imawènìadaca íichawa Jesucristo. ");
INSERT INTO pioNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Néeseté idècunitàacá Jesucristo ìyaca chái èeri irìcu, néenialíté ìyaca asìali Dios ibànuèricaté íipidenéeri Juan el Bautista. ");
INSERT INTO pioNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Dios ibànùacaté Juan icàlidacaténá tàacáisi Dios inùmalìcuíse, icàlidacaténá nacái wenàiwicanái irí Jesucristo yàanàacaté, yái amaléerica imànica wenàiwicanái íiwitáise náalíacaténáwa càinácaalí iyú náalimá nàyaca machacàníiri iyú. Dios ibànùacaté Juan, yéewacaténá wenàiwicanái neebáidaca Jesucristo itàacái idécanáamité néemìaca Juan icàlidaca Jesucristo iináwaná ìwali. ");
INSERT INTO pioNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Yái Juanca càmitaté amalá imànica wenàiwica íiwitáise. Quéwa Dios ibànùacaté Juan icàlidacaténá Jesucristo iináwaná ìwali, yái imàaquéerica wenàiwica náalíacawa càinácaalí iyú náalimá nàyaca machacàníiri iyú. ");
INSERT INTO pioNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Yái Jesucristoca, yácata abéerita amaléerica imànica macái wenàiwica íiwitáise yeebáidéeyéica itàacái náalíacaténáwa càinácaalí iwàwacutáaná namànica nàyacaténá machacàníiri iyú; yácata yàanèericaté aléi èeri irìculé. ");
INSERT INTO pioNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Yái báisíiri Tàacáisica íipidenéerica Jesucristo yèepunícatéwa chái èeri irìcu. Ewita Dios imàacacáanítaté Jesucristo idàbaca canánama chái èeri irìcuírica, càicáaníta èeri mìnanái càmitaté náalíawa cawinácaalíni, càmita nacái cayába naicácani. ");
INSERT INTO pioNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Jesucristo yàanàacaté aléi èeri irìculé idàbéericaté irípináwa, néese níái wenàiwica Jesucristo imàníiyéicaté càmitaté natàida cayábani. ");
INSERT INTO pioNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Quéwa cawinácaalí wenàiwica iwàwéeyéica Jesucristo, yeebáidéeyéi nacái itàacái, yá Jesucristo imàacaca Dios yéenibeca nía. ");
INSERT INTO pioNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Dios yéenibeca nía, quéwa càmita càide iyúwa wenàiwica imàníiná yéenibewa, càmita nacái iyúwa wenàiwica iwàwáaná imànica iiná iyúwa. Dios càmíiri imàni càide iyúwa wenàiwica imàníiná. Dios yeedácáita nía yéenibepináwa iyúwata iwàwáaná imànica. ");
INSERT INTO pioNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Yái báisíiri Tàacáisica íipidenéerica Jesucristo, yàanàacaté aléi èeri irìculé, yá yèepunícatéwa iyúwa asìali. Yá yèepunícatéwa wáapicha achúma èeríinata, idènièri abéerita cayábéeri íiwitáisewa, icàlidéeri nacái abéerita yái báisíiri tàacáisica. Wadéca waicáca máiníiri cachàinica íiwitáise, icànéeri icamaláná chènuníiséeri iyúwa, yácáináta abéerita Dios Iirica, yái Jesucristoca. ");
INSERT INTO pioNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Juan el Bautista icàlidacaté cachàiníiri iyúni Jesucristo iináwaná ìwali. Juan íimaca: “Yácata nucàlidéericatécué pirí ìwali núumacaalíté áiba máiníiri cachàinica nuícha yàanàanápináté núamirìcubàa. Cachàiníirica nuíchani, ìyacáináté bàaluitésíwa nupíchawáise, ipíchawáiseté numusúaca nuicá èeri”, íimaca yái Juanca. ");
INSERT INTO pioNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Máiní cayábéeri íiwitáise, yái Jesucristoca, yá imànica walí madécaná cayábéeri quéwanáta mamáalàacata, macáita wía yeebáidéeyéica itàacái. ");
INSERT INTO pioNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Dios imàacacaté profeta Moisés yéewáidaca wàawirináimi israelitanái namànicaténáté càide iyúwa Dios ichùulìaná nía quéwa Jesucristo idéca yáasáidaca walí cáinináca Dios iicáca wenàiwica. Jesucristo yéewáida wía nacái macái Dios itàacái báisíiri iyú. ");
INSERT INTO pioNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Canácatàacá áiba Jesucristo íicha iiquéeri Dios, quéwa Jesucristo, yái Dios Iiri abéerita, yácata Wacuèriná Dioscani, yái Jesucristoca, cáininéerica Dios iicáca; yái Jesucristo yácata abéerita imàaquéerica wáalíaca Wáaniri Dios ìwaliwa, càinácaalí Dios íiwitáise ìyaca. ");
INSERT INTO pioNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Bàaluité Juan el Bautista icàlidacaté Dios itàacái wenàiwicanái irí. Néese judío íiwacanánái ìyéeyéica Jerusalén ìyacàlená irìcu nabànùaca wenàiwica Juan yàatalé, abénaméeyéi sacerdote, levita nacái íibaidéeyéica templo irìcu. Nabànùaca nía nasutácaténá néemìawa Juan cawinácaalíni. ");
INSERT INTO pioNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Yá Juan icàlidaca nalí iináwanáwa machacànita báisíiri iyú. Iimaca nalí: —‍Càmita Mesías núaquéi, yái wacuèrinápináca Dios ibànuèripiná walí, wía israelitaca —‍íimaca yái Juanca. ");
INSERT INTO pioNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Néese nasutáca néemìawa àniwani: —‍Néeni, ¿cawiná pía? ¿Profeta Elíassica pía yàanèerica àniwa càide iyúwaté áiba profeta íimáaná? —‍náimaca. Néese Juan íimaca nalí: —‍Càmita núa yái —‍íimaca yái Juanca. Néese náima irí mamáalàacata: —‍Néese, ¿píasica profeta Dios ibànuèripináca walí càide iyúwaté profetanái íimáaná wàawirináimi irí? —‍náimaca. Néese Juan íimaca: —‍Càmíiri —‍íimaca yái Juanca. ");
INSERT INTO pioNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Néese náimaca irí: —‍Néeni, ¿cawiná pía? Iwàwacutá wáalíacawa machacàníiri iyú wacàlidacaténá nalíni, níái ibànuèyéica wía. ¿Càiná píimaca pìwaliwa? —‍náimaca irí. ");
INSERT INTO pioNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Néese Juan íimaca nalí: —‍Núaca yái asìali icàlidéerica nalí cachàiníiri iyúni, manacúali yùucubàa càináwàiri, càide iyúwaté profeta Isaías itànàaná tàacáisi Dios inùmalìcuíse. Yá núumaca nalí: ‘Càide iyúwa wenàiwicanái ichùnìacaalí machacàníiri àyapu Náiwacali irípináwa, càitacué nacái iwàwacutácué pichùnìaca píiwitáisewa Wacuèriná Dios irípiná, pitàidacaténácué cayábéeri iyúni’, cài núumaca nalí —‍íimaca yái Juanca. ");
INSERT INTO pioNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Níái wenàiwica yèeyéicatéwa Juan yàatalé, fariseonái ibànùacaté nía. ");
INSERT INTO pioNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Yá nasutáca néemìawa Juan: —‍Néeni, càmicaalí Mesías pía, yái wacuèrinápiná Dios ibànuèripináca walí, wía israelitaca, càmicaalí nacái profeta Elías pía, yàanèerica àniwa, càmicaalí nacái profeta pía Dios ibànuèripinácaté walí càide iyúwaté profeta Moisés íimáaná wàawirináimi irí, néese, ¿cáná pibautizá wenàiwica? —‍náimaca. ");
INSERT INTO pioNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Juan íimaca nalí: —‍Nubautizá wenàiwica úni yáaculé, quéwa ìyaca pèewi áiba càmíiricuéca píalía ìwali. ");
INSERT INTO pioNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Yàanàaca núamirìcubàawa. Máiní cachàiníiri íiwitáise nuícha. Nuíwacalicani, yái yàanèeripináca; nuicáca núawawa càiride iyúwa yàasu wenàiwica càmíiri cachàini náicha canánama, máinícáiná cayábéerica nuíchani —‍íimaca yái Juanca. ");
INSERT INTO pioNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Càité Juan icàlidaca nalíni aléera íipidenácataléca Betania, ìyéerica abéemàalé Jordán inanába íicha, Juan ibautizácatalé wenàiwica. ");
INSERT INTO pioNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Néeseté mapisáináami àniwa Juan iicáca Jesús yàacawa ipualé. Juan íimaca Jesús ìwali: “¡Piicácué Dios yàasu Cordero, yéetéeripináwa càide iyúwa nanúacaalí oveja wàlisài iyúwa sacrificio nabáyawaná ìwalíisewa. Yácata yùuwichèeripinácawa Dios yàasu yùuwichàacáisi iyú èeri mìnanái ibáyawaná ìwalíise! ");
INSERT INTO pioNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Nudéca nucàlidacuéca pirí iináwaná ìwali núumacaalítécué pirí: ‘Aiba yàanàapinácawa núamirìcubàawa, yácata cachàiníiri nuícha, ìyacáináté bàaluité nupíchawáise ipíchawáiseté numusúaca nuicá èeri’, càité núumacué pirí. ");
INSERT INTO pioNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Núa nacái càmitaté núalía càiríinácaalíni, yái Dios ibànuèripinácaté walí, quéwa nudéca nùanàaca nubautizácaténá wenàiwica úni yáaculé yéewanápiná Israel itaquénáinámi náalía naicácani”, íimaca yái Juanca. ");
INSERT INTO pioNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Néese Juan el Bautista íimaca àniwa: “Nudéca nuicáca Espíritu Santo iricùacawa chènuníise càiride iyúwa unùcu iicácanáwa, yá Espíritu Santo iyamáacawa ìwali. ");
INSERT INTO pioNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Néese càmitàacáwa núalíawa mamáalàacata cawinácaalíni, quéwa Dios, yái ibànuèrica núa nubautizáanápiná wenàiwica úni yáaculé íimaca nulí: ‘Piicápiná Espíritu Santo iricùacawa iyamáacawa abéeri asìali ìwali, yásí píalíacawa yácata yái ibànuèripináca Espíritu Santo wenàiwicanái irí, yái Espíritu yàacawéeridéeripináca níawa, ibautizácaténá náiwitáise Espíritu Santo ichàini iyú’, cài íimaca nulí yái Diosca. ");
INSERT INTO pioNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Nudéca nuicáca càide iyúwa Dios íimáanáté nulí ìwali, íná nucàlidacué piríni, Dios Iiricani”, íimaca yái Juanca. ");
INSERT INTO pioNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Néeseté mapisáináami àniwa, Juan el Bautista ìyaca néeni àniwa pucháiba yéewáidacalé yáapichawa. ");
INSERT INTO pioNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Juan iicáca Jesús yèepunícawa néenibàa, yá Juan íimaca yéewáidacalénái iríwa: —‍¡Piicácué Dios yàasu Cordero yéetéeripináwa càide iyúwa nanúacaalí oveja wàlisài iyúwa sacrificio nabáyawaná ìwalíisewa! —‍íimaca yái Juanca. ");
INSERT INTO pioNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Néese níái pucháiba Juan yéewáidacaléca idécanáami néemìaca Juan íimáaná nalí, yá nàacawa Jesús yáamíisewa. ");
INSERT INTO pioNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Néese Jesús iwènúa iicáidaca nalí, nàacawa yáamíisewa, yá íimaca nalí: —‍¿Càinásicué piwàwa? —‍íimaca nalí. Néese náimaca irí: —‍Pía yéewáidéerica wía, ¿alénásica picapèe? —‍náimaca irí. ");
INSERT INTO pioNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Néese Jesús íimaca nalí: —‍Wàacué waicáca —‍íimaca nalí. Iná nàacawa yáapicha, yá naicáca alénácaalí ìya. Yá nayamáacawa yáapicha yáté èerica déecucáiná èeri a las cuatrota táica nàanàacaalíté néré. ");
INSERT INTO pioNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Abéeri néená íipidená Andrés, níái pucháiba yéemièyéica Juan el Bautista íimáaná néese nàacawa Jesús yáamíisewa. Yái Andrésca, yácata Simón Pedro iméeréerica. ");
INSERT INTO pioNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Néese Andrés yàacawa caquialéta icutáca ibèeriwa Simón. Yá Andrés íimaca Simón irí: —‍Wadéca wàanàaca yái Mesíasca (íimáanáca “Cristo” griego itàacái iyú), yái wacuèrinápiná Dios ibànuèrica walí, wía israelitaca —‍íimaca yái Andrésca. ");
INSERT INTO pioNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Néese Andrés itéca Simón Jesús yàatalé. Yá Jesús iicáidaca Simón irí, yá íimaca irí: —‍Píacata Simón, Juan ìiri. Quéwa siùcade numàaca píipidená Cefas (íimáanáca Pedro griego itàacái iyú) —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Néeseté mapisáináami àniwa Jesús iwàwa yàacawa Galilea yàasu cáli néré, yá Jesús yàanàaca Felipe. Yá íimaca Felipe irí: —‍Aquialé, pìawa núapicha, yéewacaténá nuéwáidacaléca pía —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Yái Felipe Betsaida ìyacàlená néeséeri alé nacáide Andrés, Pedronái ìyacataléca. ");
INSERT INTO pioNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Néese Felipe yàaca icutáca Natanael, yá Felipe íimaca Natanael irí: —‍Wadéca wàanàaca yái asìali profeta Moisés itànèericaté iináwaná ìwali. Yácata Jesús, yái Nazaret ìyacàlená néeséerica náiméerica ìwali José ìirimica —‍íimaca. ");
INSERT INTO pioNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Néese Natanael íimaca: —‍Canáca cayábéeri wenàiwica Nazaret ìyacàlená irìcu —‍íimaca yái Natanaelca. Quéwa Felipe íimaca irí: —‍Aquialé, pìaca piicácani —‍íimaca. ");
INSERT INTO pioNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Néese Jesús iicáca Natanael yàacawa ipualé, yá Jesús íimaca Natanael ìwali: —‍Aca néese israelitasíwa, ìyéerica machacàníiri iyú càide iyúwa Dios iwàwáaná, canácatáita ichìwáida áibanái —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Néese Natanael íimaca Jesús irí: —‍¿Càinásica pidéená píalía nùwali? —‍íimaca. Néese Jesús íimaca irí: —‍Nuicácaté pía ipíchawáise Felipe imáidaca pía pìyacaalíté higuera yéetaná yáamibàa —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Néese Natanael íimaca irí: —‍Nuíwacali, ¡Dios Iirica pía! ¡Píacata yái icuèripináca wía, wía Israel itaquénáinámica! —‍íimaca. ");
INSERT INTO pioNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Jesús íimaca irí: —‍¿Peebáidasica nutàacái núumacáinácáita pirí nuicácaté pía higuera yéetaná yáamibàa? Mesúnamáita piicápiná áiba wawàsi cachàiníwanái —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Jesús íimaca nacái: —‍Péemìacué cayába, áibaalípiná piicápiná capìraléeri cáli yàacùacawa, yásí Dios yàasu ángelnái namichàacawa nuícha, nalicùacawa àniwa nùwali, núa asìali Dios néeséerica —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Néesetécáwa máisibáaná èeri irìcu, abéeri asìali icásàacawa áiba yàcalé irìcu íipidenácatalé Caná, Galilea yàasu cáli íinata. Yá namànica irí fiesta. Jesús yáatúa ìyaca fiesta néré. ");
INSERT INTO pioNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Néese Jesús ìyaca nacái néeni wáapicha, wía yéewáidacaléca, namáidacáiná wía wàacaténá waicáca náapicha fiesta. ");
INSERT INTO pioNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Néese uva ituní imáalàacawa náicha, yá Jesús yáatúa úumaca irí: —‍Idéca imáalàacawa náicha uva ituníca —‍úumaca. ");
INSERT INTO pioNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Quéwa Jesús íimaca ulí: —‍Núatúa, ¿cánásica cài píimaca nulí? Càmitàacá nuénáiwaná yàanàa —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Quéwa Jesús yáatúa íimaca nalí níái iwacuèyéica nalí yàacàsi: —‍Pimànicué macáita iyúwata ichùulìanácué pía —‍úumaca. ");
INSERT INTO pioNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Nàyacaté néré seis namanùbaca catùa manuínaméeyéi íba icatùalená, nàucùacaténá nalìculé úni, càide iyúwa judío íiwitáise ìyáaná, iwàwacutácáiná judíonái imànica culto nacáiri náibacaténá nàasuwa, nacáapi nacáiwa ipíchawáise nayáaca nayáacaléwa masacàacaténá Dios iicáca nía. Abénaméeyéi catùa manuínaméeyéi náalimá napuníacawa cincuenta litro imanùbaca úni iyú, áibanái setenta litro imanùbaca iyú náalimá nacái napuníacawa. ");
INSERT INTO pioNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Néese Jesús íimaca nalí níái íibaidéeyéica néré: —‍Pipuníadacué níái catùa úni iyú —‍íimaca yái Jesúsca. Yá napuníadaca nía macáita, àta catùa inùma nérénama. ");
INSERT INTO pioNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Néese Jesús íimaca nalí: —‍Siùca peedácué achúmanamata catùa irìcuíse, yá pitécuéni fiesta íiwacali irí, yáalimáidacaténáni —‍íimaca yái Jesúsca. Yá namànica iyúwata Jesús íimáaná. ");
INSERT INTO pioNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Yá fiesta íiwacali yáalimáidaca úni iwènuéricatéwa uva ituní iyú, quéwa càmita yáalíawa síisáanácaalíté needá yái uva ituníca. Níawamita íibaidéeyéica néré náalíacawa ìwali napuníadacáináté catùa yáawami úni iyú. Néese fiesta íiwacali imáidaca yàataléwa yái asìali wàlisàiri cáinuca imàníiricaté matrimonio. ");
INSERT INTO pioNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Yá fiesta íiwacali íimaca irí: —‍Aibanái namànicaalí fiesta, yá nàaca nàirapiná quéechacáwa cayábéeri yáwanái uva ituní, néese idécanáami nàiraca madécaná, yá yàaca nàirapiná áiba báawatéerita. Quéwa pidéca pidènìaca yái cayábéeri yáwanái àta siùca nacáide —‍íimaca. ");
INSERT INTO pioNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Yái cayábéeri wawàsi Jesús imàníirica nalí Caná ìyacàlená néré Galilea yàasu cáli íinata, yácata idàbáanéeri cayábéeri imàníirica càmíirica wenàiwica idé imànica. Càita yáasáidaca nalí íiwitáise chènuníiséeriwa. Ináté wía yéewáidacaléca weebáidaca itàacái cachàiníwanái. ");
INSERT INTO pioNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Néesecáwa Jesús yàacawa Capernaum ìyacàlená néré. Jesús yáatúa ùacawa yáapicha, yéenánái nacái, wía nacái yéewáidacaléca wàacawa yáapicha. Yá wàyaca néeni máisiba èeritasica. ");
INSERT INTO pioNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Néenialíté mawiénica judíonái yàasu culto íipidenéeri Pascua wawàwalicaténá càinácaalíté iyú Dios iwasàaca wàawirináimi Egipto yàasu cáli íicha. Wàacawa Jesús yáapicha Jerusalén ìyacàlená néré. ");
INSERT INTO pioNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Néese Jesús iwàlùacawa templo ibàacháwalená irìculé, yá iicáca wenàiwicanái iwéndéeyéica pacá, oveja nacái, unùcu nacái. Nawéndaca pìrái wenàiwica irí iwàwéeyéica imànica sacrificio Dios irí nabáyawaná ìwalíisewa, ofrenda piná nacái. Nàyaca nacái áibanái icambiéyéica plata wenàiwica íicha. Yáawinéeyéicawa yàasu mesa iwéréwa nacambiacaténá náicha plata. ");
INSERT INTO pioNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Néese Jesús ìwacáidaca íyanási, yá imànica cabèesi nacáiri, yá icalùadaca namusúawa macáita wenàiwica templo ibàacháwalená irìcuíse, nàasu pìrái yáapichawa, ovejanái, pacá nacái. Néese níái icambiéyéica plata wenàiwica íicha needácaténá nalíwa plata, yá Jesús yúucaca nàasu moneda canánama cáli íinatalé, yá nacái itamàaca yúucawa náicha nàasu mesa canánama. ");
INSERT INTO pioNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Néese Jesús yàalàaca nía cachàiníiri iyú níái iwéndéeyéica unùcu: —‍¡Pitécué yái yàasusi templo íicha! ¡Picácué pimàni Núaniri Dios icapèe iyúwa nawéndacàalu! —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Néese wía yéewáidacaléca wawàwalicaté tàacáisi rey David itànèericaté Dios Iiri inùmalìcuíse cuyàluta Salmos irìcu. Iimacaté: “Máiní báawa nuicáca yái namàníináca báawéeri wawàsi pìasu templo irìcu, pía Nucuèriná Dios; namànipiná nulí báawéeri máinícáiná cáinináca nuicáca picapèe”, íimacaté yái Dios Iirica. ");
INSERT INTO pioNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Néese abénaméeyéi judío íiwacanánái ibàluèyéicawa néeni náimaca Jesús irí: —‍¡Canáca yéewaná pimusúadaca nía templo ibàacháwalená íicha! Báisícaalí Mesíasca pía, yái wacuèrinápináca Dios ibànuèrica walí, wía israelitaca, néese pimàni waicá áiba wawàsi càmíirica wenàiwica idé imànica píasáidacaténá pidènìaca Dios íiwitáise —‍náimaca. ");
INSERT INTO pioNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Jesús íimaca nalí: —‍Ewitanica pimáalàidacáanítacué yái temploca, càicáaníta numichàidapiná ibàlùawa àniwani máisiba èeri irìcuwa —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Néese níái judío íiwacanánái náimaca irí: —‍Nadéca náibaidaca cuarenta y seis camuí namànicaténá yái temploca. Càmita pidé pimichàidaca ibàlùawa àniwani máisiba èeri irìcu —‍náimaca irí. ");
INSERT INTO pioNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Quéwa Jesús itàanícaté ìyaca ìwaliwata iyúwa templo. ");
INSERT INTO pioNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Iná idécanáamité Jesús imichàacawa yéetácáisi íicha, néese wía yéewáidacaléca wawàwalicaté yái tàacáisi Jesús icàlidéericaté nalí, ínáté weebáidaca manuísíwata Dios itàacái profetanái itànèericaté Jesús ìwali. Weebáidacaté nacái Jesús itàacái. ");
INSERT INTO pioNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Idècunitàacá Jesús ìyaca Jerusalén ìyacàlená néeni iicácaténá náapicha judíonái yàasu culto Pascua, yáté madécaná neebáidaca Mesíascani, yái Jesúsca, israelita icuèrinápiná Dios ibànuèrica nalí, naicácáináté Jesús imànica yái càmíirica wenàiwica idé imànica. ");
INSERT INTO pioNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Quéwa Jesús yáalíacawa càmita neebáida itàacái báisíiri iyú yáalíacáiná macáita náiwitáise. ");
INSERT INTO pioNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Càmitaté iwàwacutá áibanái icàlidaca Jesús irí nàwali níái wenàiwicaca, yácáiná Jesús yáalíacawa macáita wenàiwica íiwitáise. ");
INSERT INTO pioNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Iyacaté fariseo íipidenéeri Nicodemo, abéeri judío íiwacanánái yéená máiníiri cáimiétacanáca. ");
INSERT INTO pioNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Yái Nicodemo yàacawa ipáchiaca Jesús yàatalé táiyápi itàanícaténá yáapicha. Nicodemo yàacawa néré táiyápicáwa ipíchaná yàacawéeyéiná fariseo náalíacawa ìwali ipáchianá Jesús. Yá Nicodemo íimaca Jesús irí: —‍Pía yéewáidéerica wía, wáalíacawa pìwali Dios idéca ibànùaca pía péewáidáanápiná wía. Cài wáalíacawa càmicáiná yáalimá áiba imànica yái càmíirica wenàiwica idé imànica, càide iyúwa pimàníiná, càmicaalí Dios yàacawéerida nía —‍íimaca yái Nicodemoca. ");
INSERT INTO pioNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Néese Jesús íimaca irí: —‍Péemìa cayábani, càmicaalí Dios imàaca wenàiwica imusúaca iicá èeri àniwa wàlisài iyú, néese càmita yéewa yáalíacawa càinácaalí iyú Dios icùaca yàasu wenàiwicawa —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Néese Nicodemo isutáca yéemìawa Jesús: —‍¿Càinásica béeri asìali yáalimá imusúacawa wàlisài iyú àniwa? ¿Yáalimásica iwàlùacawa yáatúa idèerìculéwa imusúacaténá iicá èeri wàlisài iyú àniwa? —‍íimaca yái Nicodemoca. ");
INSERT INTO pioNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Jesús íimaca irí: —‍Péemìa cayábani, macái wenàiwica namusúaca naicá èeri idàbáanéeri yàawiría úni nacáiri yèewi. Néeseta quéwa iwàwacutá Espíritu Santo imàacaca wàlisài náiwitáise, nadènìacaténá nacáucawa chènuníiséeri Espíritu Santo yèerica nalí. Càita yéewa Dios yàasunáica nía, Dios icùanápiná nía. ");
INSERT INTO pioNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Cawinácaalí wenàiwica imusuéricawa inanái íicha, idènìaca iináwa chái èeri irìcuírica, quéwa cawinácaalí wenàiwica Espíritu Santo imàaquéerica wàlisài íiwitáise, idènìaca Espíritu Santo. ");
INSERT INTO pioNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Píalimáida péemìaca càinácaalí íimáaná yái tàacáisi núuméerica pirí: ‘Iwàwacutá Dios imàacaca wenàiwica imusúaca iicá èeri àniwa wàlisài iyú’, cài núumaca pirí. ");
INSERT INTO pioNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Péemìa comparación: Cáuli ipùaca àta alénácaalí Dios imàacaca cáuli yàacawa. Yá péemìaca cáuli isàna quéwa càmita píalíawa síisáanácaalí yàawa yái cáulica. Càmita nacái píalía ìwali alénácaalí yàawa. Càita nacái càmita píalimá píalíacawa càinácaalí iyú Espíritu Santo wàlisài imànica wenàiwica íiwitáise, nadènìacaténá nacáucawa chènuníiséeri Espíritu Santo yèerica nalí —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Néese Nicodemo isutáca yéemìawa Jesús àniwa: —‍Néeni, ¿càinásica yéewaná càicani? —‍íimaca. ");
INSERT INTO pioNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Jesús íimaca irí: —‍Píacata caináwanéeri yéewáidéerica Israel itaquénáinámi, ¿cáná càmita píalíawa ìwali yái núumáanáca? ");
INSERT INTO pioNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Péemìa cayábani, watàaníca ìwali yái wáaliérica ìwali, wacàlidacué nacái piríni, yái waiquéerica, quéwa càmitacué peebáida watàacái. ");
INSERT INTO pioNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Càmicaalícué peebáida nucàlidacaalícué pirí ìwali yái Dios imàníirica chái èeri irìcu, néese, ¿càinásicué píalimá peebáidaca nucàlidacaalícué pirí ìwali yái Dios imàníirica chènuniré? ");
INSERT INTO pioNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","“Canáca áiba nuícha chái èeri irìcu ìyéericaté chènuniré icàlidacaténá càinácaalí ìyáaná néré, abéerita núa yái iricuèricatéwa chènuníise, núa asìali Dios néeséerica, núa chènuníiséerica. ");
INSERT INTO pioNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Péemìacáwa comparación: Bàaluité madécaná wàawirináimi iwàwacaté yéetácawa àapi iyú àapinái yaamíacáináté nía manacúali yùucubàa càináwàiri. Néese profeta Moisés imànicaté àapi yéenáiwaná bronce imànicaná. Néeseté Moisés imichàidaca àapi yéenáiwaná àicu cáaléeri ìwali yéewanápináté macáita wenàiwica naicáidaca irí, níái àapi yaamiéyéicaté. Naicáidacaalíté yéenáiwanási irí, yáté cáuca nía iculále íicha. Càita nacái iwàwacutá wenàiwicanái imichàidaca núa chènuniré cruz ìwali, núa asìali Dios néeséerica, yéewanápiná macái wenàiwica naicáidaca nulí. ");
INSERT INTO pioNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Càita Dios imàacapiná namànica nulí yéewanápiná macáita cawinácaalí wenàiwica yeebáidéeyéica nutàacái càmita náucawa Dios íicha càiripináta, néese nadènìaca nacáucawa càmíiri imáalàawa Dios yáapicha —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","“Máiní cáinináca Dios iicáca macái èeri mìnanái íná cài imànica nalí: ibànùaca nalí Iiriwa abéerita yéewanápiná macáita cawinácaalí wenàiwica yeebáidéeyéica Dios Iiri itàacái càmita náucawa Dios íicha càiripináta, néese nadènìaca nacáucawa càmíiri imáalàawa Dios yáapicha. ");
INSERT INTO pioNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Càmicáináté Dios ibànùa Iiriwa aléi èeri irìculé yùuwichàidacaténá èeri mìnanái nabáyawaná ìwalíise. Néese Dios ibànùacaté Iiriwa iwasàacaténá nía Dios yàasu yùuwichàacáisi íicha. ");
INSERT INTO pioNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","“Càmita Dios yùuwichàidapiná càiripináta cawinácaalí wenàiwica yeebáidéeyéica Dios Iiri itàacái. Quéwa Dios idéca íináidacawa yùuwichàidáanápiná càiripináta cawinácaalí càmíiyéica yeebáida Dios Iiri itàacái, yái Dios Iirica abéerita, càmicáiná neebáidani. ");
INSERT INTO pioNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Dios idéca íináidacawa yùuwichàidáanápiná nía, cawinácaalí càmíiyéica yeebáida Dios Iiri itàacái. Péemìa comparación: Yái Dios Iiri ìyaca càide iyúwa camalási chái èeri irìcu, imàaquéeri waicáca cayába yácáiná Dios Iiri yáasáidaca wenàiwicanái irí cabáyawanáca nía. Quéwa níái èeri mìnanáica càmíiyéica yeebáida Dios Iiri itàacái casíimáica namànica nabáyawanáwa catácáiná náiwitáise, íná càmita cayába naicá Dios Iiri yáasáidéerica cabáyawanáca nía. ");
INSERT INTO pioNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Péemìa comparación: Cawinácaalí wenàiwica imàníiyéica ibáyawanáwa càmita nàawa camalási yàatalé ipíchaná áibanái naicáca yái báawéerica namàníirica, càita nacái cawinácaalí càmíiyéica yeebáida Dios Iiri itàacái báawaca naicáca Dios Iiri manuísíwata, náuca nacái náichawani, ipíchaná yáasáidaca áibanái iicá nabáyawaná. ");
INSERT INTO pioNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Quéwa cawinácaalí yeebáidéeyéica báisíiri tàacáisi càmita cài namàni. Néese, namàacaca áibanái iicáca macáita namàníirica yéewacaténá áibanái náalíacawa namànica càide iyúwa Dios iwàwáaná”, íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Néeseté Jesús yàacawa wáapicha, wía yéewáidacaléca Judea yàasu cáli íinatalé. Yá wàyaca néeni máisibáwanái èeri. Yá Jesús imàacaca wabautizáca wenàiwicanái, náasáidacaténá nawènúadacaté náiwitáisewa Dios irípiná. ");
INSERT INTO pioNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Juan el Bautista ibautizácaté yàacawa wenàiwica nacái Enón ìyacàlená néré mawiénita Salim ìyacàlená irí ìyacáiná néeni manùba úni. Ináté wenàiwica yàanàaca néré. Yá Juan ibautizáca nía. ");
INSERT INTO pioNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Càité imànica ipíchawáiseté romanonái icuèyéicaté wàasu cáli náucaca Juan el Bautista presoíyéi ibànalìculé. ");
INSERT INTO pioNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Néese abénaméeyéi néená Juan yéewáidacalénái, abéeri judío nacái nadàbaca natàaníca nalíwáaca ùuléeri wawàsi iyú, ìwali càiríinácaalí ibautizá cayábáwanái, Juan el Bautistasica, càmicaalí nacái Jesús yéewáidacalénáisica. ");
INSERT INTO pioNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Iná Juan yéewáidacalénái yàacawa Juan yàatalé. Yá náimaca irí: —‍Pía yéewáidéerica wía, yáara asìali ìyéericaté píapicha abéemàalé Jordán inanába íicha, yái picàlidéericaté walí ìwali, siùca macáita nàacawa yàatalé nabautizácaténáwa, yá nàacawa yáapicha, yéewáidacalécaténá nía —‍náimaca. ");
INSERT INTO pioNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Néese Juan íimaca nalí: —‍Dios imàacaca walí íibaidacalési iyúwata iwàwáaná imàacaca wáibaidacalépiná, íná yéewa wáalíacawa Dios idéca imàacaca cachàiníirica nuíchani, yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Bàaluité péemìacuéca nucàlidáanáté nalí machacàníiri iyúni càmíirita Mesías núa, yái wacuèrinápináca Dios ibànuèrica walí, wía israelitaca. Néese, núumacatécué pirí núata yái wenàiwica Dios ibànuèrica Mesías ipíchalé. ");
INSERT INTO pioNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Péemìacué comparación: Asìali yeedácaalí yàacawéetúapináwa, yá natéca úa ùacawéeri yàataléwa, yá casíimáica iwàwa, itàaníca casíimáiri iyú náapicha. Néese yái asìali yàacawéeriná ibàluèricawa néeni, máiní casíimáica yéemìaca yàacawéeriná itàacáiwa. Yá casíimáica íináidacawa yàacawéeriná ìwaliwa mànacàu yàanàacáiná ùyacaténá ùacawéeri yáapichawa. Càita nacái núa. Casíimáica nuínáidacawa wenàiwica nàacáináwa Jesús yàatalé, yàasunáicaténá nía. ");
INSERT INTO pioNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Iwàwacutá macáita nuéwáidacalé manùbéeyéi nàacawa nuícha nàacaténá Jesús icàaluíniná cachàinicáiná nuícha càiripinátani —‍íimaca yái Juanca. ");
INSERT INTO pioNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Juan el Bautista íimaté nacái: “Yái Dios Iiri yàanèerica chènuníise, yácata cachàiníiri náicha canánama. Quéwa núa, imusuéricaté iicá èeri càide iyúwa macái wenàiwica ìyáaná, nùyaca chái èeri irìcu càide iyúwa asìali ìyáaná meedá, nucàlida nacái ìwali yái wawàsi Dios imàaquéerica núalíacawa ìwali chái èeri irìcu. Quéwa yái Dios Iiri yàanèerica chènuníise, yácata cachàiníiri náicha canánama. ");
INSERT INTO pioNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Icàlida nacái ìwali yái iiquéerica chènuniré, yá nacái yéemièrica quéwa máisibáwanáita nía cài yeebáidéeyéica itàacái. ");
INSERT INTO pioNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Quéwa cawinácaalí yeebáidéerica Dios Iiri itàacái, yái wenàiwicaca yáasáidaca yeebáidaca Dios itàaníca báisíiri iyú. ");
INSERT INTO pioNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Yái Jesús Dios ibànuèrica itàaníca Dios inùmalìcuíse, Dioscáiná idéca yàaca irí Espíritu Santo manuísíwata, càmita Dios imáisanìa Espíritu Santo Jesús íicha. ");
INSERT INTO pioNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Cáinináca Wáaniri Dios iicáca Iiriwa, idéca nacái Dios imàacaca Iiri icùanápiná macáita. ");
INSERT INTO pioNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Cawinácaalí yeebáidéerica Dios Iiri itàacái, idènìaca icáucawa càmíiri imáalàawa Dios yáapicha, quéwa cawinácaalí càmíirica iwàwa yeebáidaca Dios Iiri itàacái, canáca icáuca càmíiri imáalàawa, néese yùuwichàapinácawa manuísíwata Dios yàasu yùuwichàacáisi iyú”, íimaca yái Juanca. ");
INSERT INTO pioNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","2","Néeseté fariseonái náalíacawa Jesús idènìaca yéewáidacalénáiwa manùbéeyéi Juan el Bautista íicha: Náalíacaté nacáiwa Jesús imàacaca wabautizáca manùbéeyéi wenàiwica Juan el Bautista íicha. Jesús càmitaté ibautizá wenàiwica, néese imàacaca wabautizáca nía. ");
INSERT INTO pioNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Jesús yáalíacawa fariseonái íináidacawa caluéri iyú ìwali, íná Jesús yàacawa Judea yàasu cáli íicha. Yá yèepùacawa yàacawa Galilea yàasu cáli nérépiná. ");
INSERT INTO pioNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Jesús iwàwacutácaté ichàbacawa Samaria yàasu cáli íinatalé. ");
INSERT INTO pioNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Iná yàanàaca wáapicha, wía yéewáidacaléca, Sicar ìyacàlená néré Samaria yàasu cáli íinata. Yái yàcaléca ìyaca mawiénita Jacob yàasu cáli irí, yái cálica Jacob yèericaté ìiri iríwa íipidenéericaté José. ");
INSERT INTO pioNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Iyaca néeni utàwi nacáiri nàisèeri irìcuíse úni íipidenéeri Jacob yàasumi. Jesús yàanàaca néré chamàléeri yàacawa àyapu iyú, yá yáawinacawa mawiénita utàwi nacáiri irí, yái nàisèerica irìcuíse úni. Wàanàacaté néré batéwacaalíté machacànica èeri. ");
INSERT INTO pioNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Néese wàacawa yàcalé irìculé, wía Jesús yéewáidacaléca, wawènìacaténá wayáapináwa. Néese inanái Samaria yàasu cáli néeséechúa ùanàaca uìsàacaténá úni. Yá Jesús íimaca ulí: —‍Pìa nuìra úni —‍íimaca ulí. ");
INSERT INTO pioNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Quéwa càmita cayába judíonái, samaritanonái nacái naicáyacacawa. Càmita nacái nàira náapichawáaca bacàa irìcuíse úni. Iná úái Samaria yàasu cáli néeséechúaca úumaca Jesús irí: —‍Píacata judíosàiri, ¿cáná pisutá nuícha úni, núa Samaria yàasu cáli néeséechúaca? —‍úumaca. ");
INSERT INTO pioNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Néese Jesús íimaca ulí: —‍Càmita píalíawa ìwali yái cayábéerica Dios iwàwéerica imànica pirí. Càmita nacái píalíawa cawinácaalí núa, núa isutéerica píicha úni. Píalíacaalí cawinácaalí núatá, yásí pisutáca nuícha únitá, yá nùaca pirí cáuri únitá —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Néese úumaca irí: —‍Néeni, canáca pirí úni yàalu peedácaténá úni, máiní depuíwalécani yái única. ¿Síisáaná peedápiná cáuri úni? ");
INSERT INTO pioNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Wàawirimi Jacob imàacacaté walí yái utàwica wàisèeripiná irìcuíse úni. Yeedácatáicaté ìirapináwa úni. Càita nacái Jacob yéenibe, ipìranái nacái nàiracaté úni chái. ¿Píasica cachàiníiri wàawirimi Jacob íicha? —‍úumaca. ");
INSERT INTO pioNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Néese Jesús íimaca ulí: —‍Cawinácaalí wenàiwica ìiréeyéica yái única ìyéerica chái, mamáalàacata nèepùaca macàlaca nawàwa àniwa. ");
INSERT INTO pioNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Quéwa cawinácaalí ìiréerica úni nuèrica irí càmita quirínama yèepùa macàlaca iwàwa àniwa. Néese úni nuèrica irí, imichàapinácawa mamáalàacata iwàwalìcu yàacaténá irí icáuca càmíiri imáalàawa —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Uái inanáica úumaca Jesús irí: —‍Uwé, pìa nulí única yéewanápiná càmita nuèpùawa macàlaca nuwàwa àniwa, càmita nacái iwàwacutá nuèpùaca nuìsàaca úni àniwa —‍úumaca. ");
INSERT INTO pioNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Jesús íimaca ulí: —‍Pìa pimáidaca pìacawéeriwa. Pité néeseni —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Néese úumaca irí: —‍Canácata nunìri —‍úumaca. Néese Jesús íimaca ulí: —‍Pidéca picàlidaca nulí báisíiri iyúni canáca pinìri. ");
INSERT INTO pioNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Pidéca pidènìaca cinco namanùbaca pinìrináiwa, yá pidéca piúcaca píichawa macáita nía. Asìali pìyéerica yáapicha càmíirita pinìri. Iná pidéca picàlidaca nulí báisíiri iyúni —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Néese úái inanáica idécanáami uémìacani, yá úumaca irí: —‍Siùca nuínáidacawa cawàwanáta profetaca pía, icàlidéerica tàacáisi Dios inùmalìcuíse. ");
INSERT INTO pioNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Wàawirináimi samaritano nàacaté Dios icàaluíniná chái manuíri dúli íinata, quéwa píacué judíoca, píimacuéca iwàwacutáanása macái wenàiwica nàaca Dios icàaluíniná Jerusalén ìyacàlená néenibàata —‍úumaca. ");
INSERT INTO pioNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Néese Jesús íimaca ulí: —‍Péemìa nulí cayába, peebáida nutàacái. Mesúnamáitacué pìapiná Wáaniri Dios icàaluíniná, quéwa càmitacué iwàwacutápiná pìanàaca aléi dúli íinatalé, càmitacué nacái iwàwacutá pìacawa Jerusalén ìyacàlená irìculé. ");
INSERT INTO pioNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Píacué samaritanoca càmitacué píalía Dios ìwali pièricuéca icàaluíniná. Quéwa wía judíoca wáalíaca Dios ìwali yái wèerica icàaluíniná, yácáiná judíosàiricani yái iwasèeripináca wenàiwica Dios yàasu yùuwichàacáisi íicha. ");
INSERT INTO pioNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Quéwa máiní mesúnamáita, siùca èeri nacái, cawinácaalí báisíiyéica iwàwa yàaca Wáaniri Dios icàaluíniná nàapiná icàaluíniná báisíiri iyú manuísíwata macái nawàwalìcuísewa càide iyúwa Espíritu Santo iwàwáaná, yácáiná Wáaniri Dios iwàwa cài wenàiwica yàaca icàaluíniná. ");
INSERT INTO pioNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Canáca Dios iiná càide iyúwa wenàiwica iiná èeri irìcuírica íná càmita idé wenàiwica iicáca Dios. Càita nacái càmita wáalimá waicáca watuí iyúwa càinácaalí iyú wenàiwica yàaca Dios icàaluíniná, nàacáiná icàaluíniná nawàwalìcuísewa. Iwàwacutá wenàiwica nàaca Dios icàaluíniná báisíiri iyú macái nawàwalìcuísewa, càide iyúwa Espíritu Santo iwàwáaná —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Néese úái inanáica úumaca: —‍Núalíacawa Mesías yàanàanápiná (íimáanáca “Cristo” griego itàacái iyú), yái wacuèrinápináca Dios ibànuèripiná walí. Mesías yàanàacaalípiná, yásí icàlidaca walíwa macáita, wáalíacaténá wéemìaca cayába —‍úumaca. ");
INSERT INTO pioNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Jesús íimaca ulí: —‍Núacata yái, itàaníirica píapicha —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Idécanacáita cài Jesús íimaca, wíacata Jesús yéewáidacaléca wàanàaca néré, yá wáináidacawa waicáidaca Jesús irí itàanícáiná inanái yáapicha. Quéwa cáaluca wasutáca wéemìawani íná canáca wéená isutéeri yéemìawa Jesús cáná yéewaná itàaní úapicha. ");
INSERT INTO pioNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Néese úái inanáica umàacaca ùasu úni yàaluwa, yá uèpùacàatécatawa yàcalé irìculé. Yá úumaca wenàiwicanái irí: ");
INSERT INTO pioNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","—‍Aquialécué, piicá abéeri asìaliquéi icàlidéerica nulí macáita nudéená numànica. ¿Píináidasicué cawàwanáta Mesíascani, yái wacuèrinápiná Dios ibànuèrica walí? —‍úumaca. ");
INSERT INTO pioNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Néese namusúacawa yàcalé irìcuíse, yá nàacawa Jesús yàatalépiná. ");
INSERT INTO pioNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Quéwa ipíchawáiseté yàcalé mìnanái nàanàaca Jesús yàatalé, yá wía, yéewáidacaléca wasutáca Jesús íicha wawàsi manuísíwata. Yá wáimaca irí: —‍Wáiwacali, piyáa piyáacaléwa —‍wáimaca. ");
INSERT INTO pioNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Quéwa Jesús íimaca walí: —‍Nudènìa nuyáapináwa áibata càmíiricuéca píalíawa ìwali —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Néese wía yéewáidacaléca wáimaca walíwáaca: —‍¿Cawàwanáta áibanái idéca yàaca iyáapiná? —‍wáimaca. ");
INSERT INTO pioNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Quéwa Jesús íimaca walí: —‍Casíimáipináca núa idécanáami numànica càide iyúwa Dios iwàwáaná, yái ibànuèrica núa, idécanáami numáalàidaca numànica yái íibaidacalésica Dios ichùulièricaté numànica, càide iyúwacué casíimáiná pía pidécanáamicué piyáaca piyáacaléwa. ");
INSERT INTO pioNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Péemìacué comparación: Picácué píima piríwáaca: ‘Iwàwacutéeri báinúaca quéeri àta needácataléta bànacalé ìyacaná’, picácué píima. Núumacué pirí, piicácué macáita níái wenàiwicaca yàanèeyéica wàatalépiná. Càica níade iyúwa bànacalé ìyacaná quíiréeri, mesúnamáicáináta neebáidapiná nutàacái, yásí wàwacáidaca nía nulípiná nùasunáicaténá nía, càide iyúwa wenàiwica yeedácaalí bànacalé ìyacaná. ");
INSERT INTO pioNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Cawinácaalí ìwacáidéerica nulí wenàiwica nùasunáipiná, càipiná nùaca iwèniwa: Numàacaca casíimáicani iicácáiná wenàiwica neebáidaca nutàacái. Cawinácaalí wenàiwica yeebáidéeyéica nutàacái needápiná nalíwa nacáucawa càmíiri imáalàawa. Péemìacué comparación: Bànacalé íiwacali ichùulìaca yàasu wenàiwicanáiwa náibaidáanápiná bànacalé yùucubàa. Abéeri wenàiwica ibànacaalí ituíná, yásí casíimáipinácani áiba íibaidéeri yáapicha yeedéeripiná ìyacanási quíiracaalíni. Càita nacái cawinácaalí icàlidéerica nutàacái idàbáanéeri yàawiría wenàiwicanái irí, yá nacái áiba wenàiwica iwènúadéerica nulípiná náiwitáise, yá casíimáica nawàwa abédanamata, níái pucháibaca íibaidéeyéica nulí. ");
INSERT INTO pioNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Báisíta ìyaca càide iyúwa comparación íimáaná watàacái iyú: ‘Abéeri náiwacali yàasu wenàiwica ibàna ituíná, néese náiwacali yàasu wenàiwicanái áibanái needáca bànacalé ìyacaná quíiracaalíni’, íimaca yái comparaciónca. ");
INSERT INTO pioNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Càita nacái nudéca nubànùacuéca pía piwènúadáanápiná nulí wenàiwica íiwitáise nùasunáicaténá nía, càide iyúwa náiwacali yàasu wenàiwicanái yeedácaalí bànacalé ìyacaná aléera náiwacali yàasu wenàiwica áibanái ibànacatalécaté. Càide iyúwa comparación íimáaná: Náiwacali yàasu wenàiwica idéca ibànaca ituínási, néese náiwacali yàasu wenàiwicanái áibanái needápiná bànacalé ìyacaná quíiracaalíni. Càita nacái píacué: Uái inanáica udéca ucàlidaca yàcalé mìnanái irí nuináwaná ìwali, càide iyúwa udéca nacáicaalí ubànaca ituínási, néesecué piwènúadapiná nulíwa náiwitáise, níái yàcalé mìnanáica. Yásí pìwacáidacué nulí níawa nùasunáipiná càide iyúwa wenàiwica yeedácaalí bànacalé ìyacaná quíiracaalíni —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Uái inanáica ucàlidacaté Jesús iináwaná ìwali nalí níái ìyéeyéica yàcalé irìcu ìyéerica Samaria yàasu cáli íinata. Uumaca nalí: “Idéca icàlidaca nulí macáita nudéená numànica”, úumaca. Iná yéewa madécaná wenàiwica neebáidaca Jesús itàacái Mesíascani, yái nacuèrinápiná Dios ibànuèripinácaté nalí. ");
INSERT INTO pioNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Ináté níái samaritanoca idécanáami nàanàaca Jesús yàatalé, yá nasutáca íicha wawàsi iyamáanápináwa náapicha. Jesús ìyacaté náapicha pucháiba èeri. ");
INSERT INTO pioNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Yá madécaná áibanái yeebáidaca Jesús itàacái néemìacáiná icàlidáaná nalíni. ");
INSERT INTO pioNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Yá náimaca ulí úái inanáica: —‍Siùca weebáidaca Jesús itàacái càmíirita abé pitàacái ìwalíise, néese wadéca wéemìaca itàacái. Yá wáalíacawa báisíiri iyú Jesús ìwali Mesíascani, yái wacuèrinápiná Dios ibànuèrica walí, yái iwasèeripináca èeri mìnanái Dios yàasu yùuwichàacáisi íicha —‍náimaca. ");
INSERT INTO pioNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Néeseté idécanáami Jesús ìyaca náapicha pucháiba èeri, yá yàacawa Samaria yàasu cáli íicha, yá idàbaca yàacawa àniwa Galilea yàasu cáli nérépiná. ");
INSERT INTO pioNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Jesús íimacáiná: Profeta yàasu cáli néeséeyéi càmita neebáida profeta itàacái, yái itàaníirica Dios inùmalìcuíse, càmita nacái naicácani cáimiétaquéeri iyú. ");
INSERT INTO pioNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Jesús yàanàacaté Galilea yàasu cáli néré, yá níái ìyéeyéica néeni natàidaca Jesús cayábéeri iyú nàyacáináté Jerusalén ìyacàlená néeni naicácaténá Pascua yàasuná culto, íná yéewa naicácaté macáita yái Jesús imàníiricaté néenibàa, yái càmíirica áiba wenàiwica idé imànica. ");
INSERT INTO pioNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Néese Jesús yàanàaca áiba yàcalé néré íipidenácatalé Caná, Galilea yàasu cáli íinatalé imàacacataléca úni iwènúacawa uva ituní iyú. Aiba yàcalé íipidenácatalé Capernaum ìyaca mawiénita Caná ìyacàlená irí. Iyacaté Capernaum ìyacàlená mìnali, gobierno yàasu wenàiwica máiníiri cachàinica íibaidéerica rey irí, yái reyca icuèricaté nàasu cáli. Yá cáuláicaca gobierno yàasu wenàiwica ìiri. ");
INSERT INTO pioNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Yái gobierno yàasu wenàiwica yéemìacanacáita Jesús iináwaná ìwali yàanàanáté Galilea yàasu cáli néré Judea yàasu cáli íicha, yá yàaca iicáca Jesús. Isutáca Jesús íicha wawàsi yàanápináwa icapèe néré ichùnìacaténá ìiri iwàwéeri yéetácawa. ");
INSERT INTO pioNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Néese Jesús íimaca irí: —‍Iwàwacutácué peebáidaca nutàacái éwita càmicáaníta piicá numànica yái càmíirica wenàiwica idé imànica. Quéwa, càmitacué piwàwa peebáidaca nulí àta piicácaalítacué numànica áiba wawàsi imàaquéericuéca píináidacawa piicáidaca nulí —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Quéwa gobierno yàasu wenàiwica íimaca Jesús irí: —‍Nuíwacali, pìacàatétawa nucapèe néré ipíchaná nuìri yéetácawa —‍íimaca. ");
INSERT INTO pioNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Néese Jesús íimaca irí: —‍Pèepùawa picapèe néréwa. Cáuca pìirica. Idéca mecuní ichàbacawa íicha —‍íimaca yái Jesúsca. Yá asìali yeebáidaca Jesús itàacái, íná yèepùacawa icapèe nérépináwa. ");
INSERT INTO pioNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Néese mawiénicaalíténi icapèe iríwa, yá yàasu wenàiwicanái namusúacawa icapèe irìcuíse náipunitáidacani. Yá náimaca irí: —‍¡Cayábaca pìirica! ¡Cáucáani! —‍náimaca. ");
INSERT INTO pioNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Néese isutáca yéemìawa nía càinácaalíté hora irìcu idé mecuní ichàbacawa íicha. Yá náimaca irí: —‍Táquicha a la unata táicalé mecuní ichàbacawa íicha —‍náimaca. ");
INSERT INTO pioNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Néese yáaniri yáalíacawa hora ìwali, yáta horaca Jesús íimacatáicata irí: “Cáuca pìirica. Idéca mecuní ichàbacawa íicha”, càité íimaca yái Jesúsca. Yá yeebáidaca Jesús itàacái, macái yéenánái yáapichawa. ");
INSERT INTO pioNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Yácata pucháibáaná wawàsi Jesús imàníirica, yái càmíirica wenàiwica idé imànica idécanáamité yèepùacawa Judea yàasu cáli íicha Galilea yàasu cáli néré. ");
INSERT INTO pioNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Néeseté àniwa judíonái namànica áiba culto Jerusalén ìyacàlená irìcu, íná Jesús yàacawa néré àniwa. ");
INSERT INTO pioNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Jerusalén ìyacàlená néeni ìyacaté abéeri úni yàalu manuíri náiquéericaté cáli yèewiré mawiénita Jerusalén iwáiná inùma irí, abéeri inùma íipidenéeri Ovejanái yàasu. Yái úni yàalu manuírica íipidenéeri Betzata hebreo itàacái iyú idènièri itéesewa cinco namanùbaca capìima nacáiyéi manuínaméeyéi. ");
INSERT INTO pioNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Madécaná cáuláiquéeyéi wenàiwica nàyaca macái capìima irìcu mawiénita úni yàalu manuíri irí. Nàyaca néeni matuíyéi, éeruíyéi yàabàli nacái, máapinéeyéi nacái. Yá nalìacawa cáli íinata natuíyàacaténá úni icusúanícawa. ");
INSERT INTO pioNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Yácáiná áibaalíté ángel iricùacawa chènuníise yèewìadacaténá úni. Néese cawinácaalí idàbáanéeri cáuláiquéeri iricùacawa úni yáaculé, yásí cayábacani, yá uláicái ichàbacawa íicha càinácaalí uláicái wenàiwica idènièrica. ");
INSERT INTO pioNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Néese ìyaca cáuláiquéeri asìali cáuláiquéeyéi yèewi. Cáuláicacaténi treinta y ocho camuí. ");
INSERT INTO pioNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Néeseté Jesús yàanàaca néré, yá iicáca yái cáuláiquéeri irièricawa néenibàa. Jesús yáalíacáinátéwa iináwaná ìwali yái cáuláiquéerica yùuwichàacatéwa madécaná camuí, íná Jesús íimaca irí: —‍¿Piwàwasica cayábaca pía àniwa? —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Yái cáuláiquéerica íimaca irí: —‍Néeni, canáca nulí áibanái itéenápiná núa úni yáaculé icusúacaalíwa yái única. Macái yàawiríata nuwàwacaalí nulicùacawa néré, yá áiba iricùacawa nupíchalé —‍íimaca. ");
INSERT INTO pioNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Néese Jesús íimaca irí: —‍Pimichàawa. Pichùnìa pìalubáiwa, pìanáwa —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Yáta cayábaca yái asìalica. Néese yeedáca yàalubáiwa, yá idàbaca yèepunícawa. Quéwa Jesús ichùnìacani sábado irìcu judíonái iyamáidacatáicawa. ");
INSERT INTO pioNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Iná abénaméeyéi judío íiwacanánái náimaca irí yái cáuláiquéerimica: —‍Siùca sábado wayamáidacatáicawa, íná càmita wàawirináimi íiwitáise imàaca pèepunídaca pìalubáiwa —‍náimaca. ");
INSERT INTO pioNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Néese yái asìali íimaca nalí: —‍Yáara ichùnièrica núa íimaca nulí: ‘Pichùnìa pìalubáiwa, pìanáwa’, íimaca nulí —‍íimaca yái cáuláiquéerimica. ");
INSERT INTO pioNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Néese nasutáca néemìawani: —‍¿Cawiná ichùulìa pichùnìaca pìalubáiwa, pìanápináwa? ¿Cawiná cài íimaca pirí? —‍náimaca. ");
INSERT INTO pioNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Quéwa yái asìali càmita yáalíawa cawinácaalíni yái ichùnièricaténi madécanácáiná wenàiwica ìyaca néeni, Jesús nacái yàacatéwa íicha. ");
INSERT INTO pioNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Néesecáwa Jesús yàanàaca yái asìalica templo irìcu. Yá Jesús íimaca irí: —‍Péemìa cayába. Idéca cayábaca pía uláicái íicha. Picá pimàni pibáyawanáwa quirínama ipíchaná áiba yùuwichàacáisi báawéeríwanái yàanàaca pìwali —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Néese yái asìali yàacawa icàlidaca judío íiwacanánái irí Jesús iináwaná ìwali ichùnìacaténi. ");
INSERT INTO pioNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Iná níái judío íiwacanánáica nàuwideca namànica Jesús, nasàiwicaca irí wawàsi nacái mamáalàacata ichùnìacáináté wenàiwica sábado irìcu judíonái iyamáidacatáicawa. ");
INSERT INTO pioNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Quéwa Jesús íimaca nalí: —‍Núaniri Dios íibaidaca mamáalàacata, càita nacái nuíbaidaca —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Iná níái judío íiwacanánáica máiní cachàiníwanái nawàwaca nanúacani. Yá báawaca naicácani ichùnìacáiná wenàiwica sábado irìcu judíonái iyamáidacatáicawa. Icàlidaca nacái iináwaná ìwaliwa càide iyúwa abéeri Dios inacáiri, íimacáiná Dios ìwali yáaniricani. ");
INSERT INTO pioNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Néeseté Jesús íimaca judío íiwacanánái irí: “Péemìacué cayábani, núaquéi Dios Iiri càmita yéewa numàni wawàsi nulínáamitawa. Numànica abéerita yái nuiquéerica Núaniri Dios imànica. Macáita yái Núaniri Dios imàníirica, càita nacái numànica, núa Dios Iirica. ");
INSERT INTO pioNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Cáininácáiná Núaniri Dios iicáca núa, íná yáasáidaca nulí macáita yái imàníirica. Yáasáidapiná nacái nuicá wawàsi cachàiníwanái, imàaquéeripinácué píináidacawa piicáidaca nulí. ");
INSERT INTO pioNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Càide iyúwa Núaniri Dios imichàidáaná wenàiwica yéetácáisi íicha yàacaténá nacáuca àniwa, càita nacái numànica, núa Dios Iirica: Nùaca nacáuca cawinácaalí nuwàwéeyéica idènìaca icáucawa. ");
INSERT INTO pioNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Canácatáita Núaniri icàlida wenàiwica iináwaná ìwali yùuwichàidáanápiná nía nabáyawaná ìwalíisewa, Dioscáiná idéca imàacaca nucàlidáanápiná naináwaná ìwali macáita wenàiwica báawéeyéica, nùuwichàidáanápiná nía nabáyawaná ìwalíisewa, núa Dios Iirica. ");
INSERT INTO pioNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Idé cài Núaniri Dios imànica yéewacaténá macái wenàiwica nàaca nucàaluíniná, núa Dios Iirica, càide iyúwa nàaná Núaniri Dios icàaluíniná. Cawinácaalí wenàiwica càmíirica yàa nucàaluíniná, càmita nacái nàaca Núaniri Dios icàaluíniná, yái ibànuèrica núa. ");
INSERT INTO pioNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Péemìacué cayábani, cawinácaalí yéemièrica nutàacái cayábéeri iyú, yeebáida nacái Dios itàacái, yái ibànuèrica núa, yái wenàiwicaca idènìaca siùcáisede icáucawa càmíiri imáalàawa, yá ìyapiná càiripináta Dios yáapicha. Iná càmita iwàwacutápiná nuémìaca áibanái icháawàanáca iináwaná ìwali càinácaalíté imàni ibáyawanáwa, ìyacáiná càide iyúwa wenàiwica imichèericawa yéetácáisi íicha, idènìacáiná siùcáisede icáucawa càmíiri imáalàawa. ");
INSERT INTO pioNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Péemìacué cayábani, máiní mesúnamáita wenàiwicanái canéeyéi icáuca càmíiri imáalàawa néemìanápiná nutàacái. Yá néemìaca nàyaca nutàacái siùca, núa Dios Iirica. Cawinácaalí yeebáidéeyéica nutàacái, nadènìapiná nacáucawa càmíiri imáalàawa Dios yáapichawa. ");
INSERT INTO pioNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Càide iyúwa Núaniri Dios idènìaná ichàiniwa yàacaténá nacáuca càmíiri imáalàawa, càita nacái idéca imàacaca nudènìaca nuchàiniwa, núa Iirica, nùacaténá nacáuca càmíiri imáalàawa. ");
INSERT INTO pioNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Núaniri Dios idéca ichùulìaca nucàlidaca èeri mìnanái iináwaná nùuwichàidáanápiná nía nabáyawaná ìwalíisewa, núa Dios Iirica, wenàiwicacáiná nacái núa, núa asìali Dios néeséerica. ");
INSERT INTO pioNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Picácué píináidawa máiní càulenéericani yái tàacáisi nucàlidéericuéca pirí, yácáiná áiba èeriwa macáita yéetéeyéimiwa néemìapiná nutàacái, núa Dios Iirica, numáidacaalípiná níawa. ");
INSERT INTO pioNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Néemìacaalípiná numáidáaná nía, yásí namichàacawa càliculìi irìcuíse. Cawinácaalí imàníiyéicaté cayábéeri, namichàapinácawa nàyacaténá càiripináta Dios yáapicha, quéwa cawinácaalí imàníiyéicaté ibáyawanáwa, namichàapinácawa nàuwichàacaténáwa càiripináta”, íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Jesús íimacaté judío íiwacanánái irí: “Càmita yéewa numànica wawàsi nulínáamitawa. Nucàlidapiná wenàiwicanái iináwaná ìwali nùuwichàidáanápiná nía nabáyawaná ìwalíisewa càide iyúwa Núaniri Dios ichùulìaná. Nucàlidapiná nacái naináwaná ìwali machacàníiri iyú nùuwichàidáanápiná níawa, càmicáiná numàni càide iyúwa nuwàwáaná. Néese numànica càide iyúwa Núaniri Dios iwàwáaná yái ibànuèrica núa aléi èeri irìculé. ");
INSERT INTO pioNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Nucàlidacaalí nuináwaná ìwaliwa máiníiná cachàinica núatá, yásí yéewaná piyúunáidacuéca canéerica iwèni meedátáni, yái nutàacáica. ");
INSERT INTO pioNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Quéwa ìyacaté áiba icàlidéericaté nuináwaná ìwali cawinácaalí núa, yácata Juan el Bautistami. Yá núalíacawa icàlidacaté nùwali báisíiri iyú. ");
INSERT INTO pioNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Pibànùacatécué wenàiwica nasutácaténáté néemìawa Juan el Bautista càinácaalíté íimaca nùwali. Yáté icàlidaca nuináwaná ìwali báisíiri iyú. ");
INSERT INTO pioNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Quéwa càmíiri máiní iwàwacutéeriwa nulí wenàiwicanái itàacái. Nucàlidacáitacué pirí ìwali yái tàacáisi Juan icàlidéericaté nùwali yéewanápinácué peebáidaca nutàacái nuwasàacaténácué pía Dios yàasu yùuwichàacáisi íicha. ");
INSERT INTO pioNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Péemìacué comparación: Juan ìyacaté càide iyúwa lámpara ipucuéricawa, icànéeri wenàiwicanái ìwali. Càita Juan yéewáidacatécué pía amalácaténácué píiwitáise pìyáanápinácué machacàníiri iyú. Yáté achúma èerita casíimáicatécué piwàwa péemìaca Juan itàacái. ");
INSERT INTO pioNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Quéwa ìyaca áiba wawàsi cawèníiri Juan itàacái íicha. Yái numàníirica càmíirica áiba wenàiwica idé imànica, càide iyúwa Núaniri Dios ichùulìaná numànica, yácata yáasáidaca báisíiri iyúcani Dios idéca ibànùaca núa. ");
INSERT INTO pioNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Núaniri Dios, yái ibànuèrica núa, yácata nacái imàaquéericaté profetanái itànàaca tàacáisi nuináwaná ìwali bàaluité Dios imàacacáináté natànàaca itàacái, éwitacué càmicáaníta píalimá péemìaca Núaniri Dios itàaníca, càmitacué nacái píalimá piicácani. ");
INSERT INTO pioNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Quéwa càmitacué piwàwa peebáidaca Dios itàacái Dios ibànuèricatécué pirí, càmicáinácué piwàwa peebáidaca nutàacái, núa asìali Dios ibànuèrica. ");
INSERT INTO pioNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Pidécuéca péewáidacawa cayábéeri iyú Dios itàacái ìwali profetanái itànèericaté Dios inùmalìcuíse piyúunáidacáinácué pìyapináca càiripináta ìwalíise yái péewáidáanácuécawa meedá Dios itàacái ìwali, quéwa Dios itàacái icàlidaca nuináwaná ìwali. ");
INSERT INTO pioNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Quéwa éwita Dios itàacái icàlidacáaníta nùwali, càicáanítacué càmita piwàwa peebáidaca nulí pidènìacaténácué picáucawa càmíiri imáalàawa Dios yáapicha. ");
INSERT INTO pioNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Càmita nucutá mamáalàacata wenàiwicanái naicáanápiná núa càiride iyúwa máiníirica cachàinica chái èeri irìcu. ");
INSERT INTO pioNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Núalíacuéca nuicá píiwitáise. Yá núalíacawa càmitacué cáininá piicáca Dios. ");
INSERT INTO pioNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Núaniri Dios idéca ibànùacuéca nùa pìatalé, quéwa càmitacué pitàida núa cayába, càmitacué nacái peebáida nutàacái. Quéwa áibacaalí péenácué yàanàa icàlidéeri yàasu tàacáisiwa meedá, yásí peebáidacuéca itàacái nutàacái íicha. ");
INSERT INTO pioNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Càmitacué píalimá peebáidaca nutàacái, piwàwacáinácué meedá pimànica iyúwa pinacáiyéi iwàwáaná cayábacaténácué naicáca pía. Càmitacué piwàwa pimànica càide iyúwa Dios iwàwáaná, yái abéerita Diosca, yéewacaténácué casíimáica iicáca pía. ");
INSERT INTO pioNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Picácué píináidawa nucháawàanápinácué piináwaná ìwali Núaniri Dios iríwa. Càmita iwàwacutá nucháawàacuéca piináwaná ìwali, ìyacáiná áiba icháawèericuéca piináwaná ìwali, yái profeta Moisés itànèericaté tàacáisi pibáyawaná ìwalicué, éwitacué piyúunáidacáaníta Moisés yàasu tàacáisi iwasàanápinácué pía Dios yàasu yùuwichàacáisi íicha. ");
INSERT INTO pioNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Profeta Moisés itànàacaté tàacáisi nuináwaná ìwali Dios inùmalìcuíse. Quéwa càmitacué peebáida Moisés yàasu tàacáisi báisíiri iyú. Báisícaalícué peebáidaca Moisés yàasu tàacáisitá, yá peebáidacuéca nutàacái nacáitá Moiséscáiná itànàacaté nuináwaná ìwali. ");
INSERT INTO pioNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Quéwa càmitacué peebáida tàacáisi profeta Moisés itànèericaté nuináwaná ìwali, íná càmita nacáicué peebáidapiná yái tàacáisi nucàlidéeripinácuéca pirí”, íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Néesetécáwa, Jesús yàacawa abéemàalé Galilea icalìsaniná íicha, áibaalí íipidenéeri Tiberias. Wía yéewáidacaléca wàacawa yáapicha. ");
INSERT INTO pioNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Manùbéeyéi wenàiwica nàacawa Jesús yáamiwáise àta alénácaalí yàawa, naicácáináté imànica madécaná yái càmíirica wenàiwica idé imànica ichùnìacaténá cáuláiquéeyéi. ");
INSERT INTO pioNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Néese Jesús yàacawa dúli íinatalé, yá yáawinacawa wáapicha wía yéewáidacaléca. ");
INSERT INTO pioNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Mawiénicaté Pascua yàasu èeri judíonái imànicatáicaté yàasu cultowa máiníiri iwàwacutácawa nalí íipidenéeri Pascua. ");
INSERT INTO pioNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Néese Jesús iicáidaca nalí níái manùbéeyéi wenàiwicaca yèeyéicawa yàatalépiná. Iná Jesús íimaca Felipe irí: —‍¿Alénásica yéewa wawènìaca nayáapiná níái manùbéeyéi wenàiwicaca? —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Jesús isutáca yéemìawani yáalimáidacaténá iicáwa Felipe, yáalíacaténáwa càinácaalí Felipe íináidáanáwa, Jesúscáiná yáalíacatéwa càinácaalí imàníinápináté wàacaténá wenàiwica iyáapiná. ");
INSERT INTO pioNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Néese Felipe íimaca: —‍Càmita wáalimá wàaca nayáapiná. Ewita wadènìacaalí doscientos denario imanùbacatá, yái doscientos èeri iwènicatái, càicáaníta caná yéewanáwa wawènìaca pan cayába yáaliméeripiná wàaca nayáatá, ibatàa púubanamáanápinátá —‍íimaca. ");
INSERT INTO pioNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Néese abéeri wéená, wía yéewáidacaléca, íipidenéeri Andrés, yái Simón Pedro iméeréerica, íimaca Jesús irí: ");
INSERT INTO pioNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","—‍Iyaca chái abéeri sùmài idènièri cinco namanùbaca cebadéeri panca, pucháiba cubái imìdecaná nacái, quéwa càmita náalimá níái manùbéeyéi wenàiwicaca —‍íimaca yái Andrésca. ");
INSERT INTO pioNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Néese Jesús íimaca walí: —‍Pichùulìacué náawinacawa canánama —‍íimaca yái Jesúsca. Iyacatái madécaná masicái, yá náawinacawa. Nàyaca cawàwanáta cinco mil namanùbaca asìanái. Càmita waputàa càisimalénácaalí inanái, sùmanái nacái. ");
INSERT INTO pioNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Néese Jesús yeedáca níái panca icáapi irìculéwa, yá yàaca Dios irí cayábéeri. Néese isubèriadaca nía, yàaca walíni, wía yéewáidacaléca, yéewacaténá wawacùaca wenàiwicanái iríni, níái yáawinéeyéicawa néeni. Càita nacái Jesús imànica cubái imìdecaná yáapicha, yá wawacùaca nalíni, càinácaalíté imanuíca nawàwa nayáaca. ");
INSERT INTO pioNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Idécanáami nayáaca cadénama, yá Jesús íimaca walí, wía yéewáidacaléca: —‍Pìacué peedá yéenáimi imàaquéericawa, ipíchaná yúucacawa —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Iná wàaca weedáca pan yéenáimi imàaquéericawa, yá wapuníadaca doce namanùbaca mapíiri pan yéenáimi iyú, yái imàaquéericawa cinco namanùbaca cebadéeri pan íicha. ");
INSERT INTO pioNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Níái wenàiwicaca naicácáiná Jesús imànica yái càmíirica áiba wenàiwica idé imànica, íná náimaca nalíwáaca: —‍Báisíta yácata yái profeta icàlidéerica tàacáisi Dios inùmalìcuíse, yái wacuèrinápiná càide iyúwaté profeta Moisés itànàanáté tàacáisi ìwali yàanèeripinácaté aléi èeri irìculé —‍náimaca. ");
INSERT INTO pioNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Quéwa Jesús yáalíacawa nawàwáaná náibàacani cachàiníiri iyú namàacacaténá Jesús iyúwa nàasu rey icùanápiná nía, íná Jesús yàacawa náicha dúli íinatalé ìyacaténá abéerita. ");
INSERT INTO pioNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Táicacaalíté yàacawa, néese wía yéewáidacaléca walicùa wàacawa Galilea icalìsaniná néré. ");
INSERT INTO pioNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Néese wawàlùacawa barca irìculé, yá wadàbaca wachàbaca wàacawa abéemàalé calìsa íicha wàanàacaténá Capernaum ìyacàlená nérépiná. Idé catáca wàwali quéwa Jesús càmíiritàacá yàanàa wàatalé. ");
INSERT INTO pioNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Néese manuíri màladàca imichàacawa cáulicáiná ipùa wía cachàini. ");
INSERT INTO pioNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Néese máadáiní watenácaté cawàwanáta cinco kilómetro, seis kilómetro idècuni cawàwanáta, yá waicáca Jesús yèepuníiriwa úni inànìacubàa, mawiénita yàacawa wàasu barca irí. Yá cáaluca wía báawanama, càmicáiná wáalía waicácani. ");
INSERT INTO pioNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Quéwa Jesús íimaca walí: —‍¡Núaquéi, picácué cáalu pía! —‍íimaca walí. ");
INSERT INTO pioNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Néese casíimáiri iyú weedáca Jesús barca irìculé, yáta barca yàanàaca wawàwacataléca wàacawa. ");
INSERT INTO pioNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Mapisáita àniwa níái manùbéeyéi wenàiwicaca wamàaquéeyéicaté abéemàalé Galilea icalìsaniná íicha nawàwacaté nacutáca Jesús. Náalíacawa càmitaté Jesús yàawa wáapicha, wía yéewáidacaléca táicalémi watécaalíté yái abéeri barcaca ìyéericaté néeni. ");
INSERT INTO pioNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Quéwa abénaméeyéi wenàiwica Tiberias ìyacàlená néeséeyéi nàanàaca barca irìcu mawiénita cáli irí yái cálica wenàiwica iyáacatáicaté pan idécanáamité Wáiwacali yàaca Dios irí cayábéeri. ");
INSERT INTO pioNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Néese wenàiwicanái càmicáináté nàanàa Jesús, càmicáiná nacái nàanàa wía, wía Jesús yéewáidacaléca, ínáté nawàlùacawa madécaná barca irìculé nachàbacaténá calìsa nàanàanápiná Capernaum ìyacàlená néré nacutácaténáni, yái Jesúsca. Yá nachàbaca calìsa. ");
INSERT INTO pioNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Idécanáamité nàanàaca abéemàalé calìsa íicha, yá nàanàaca Jesús. Náimaca irí: —‍Pía, yéewáidéerica wía, ¿càicaalínáté pìanàa aléi? —‍náimaca. ");
INSERT INTO pioNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Quéwa Jesús íimaca nalí: —‍Péemìacué cayába, càmitàacáwa píalía péemìaca càinácaalí íimáaná yái numàníirica càmíirita áiba wenàiwica idé imànica. Píalíacáitacuéwa piyáacaté piyáacaléwa cadénama meedá, íná picutácuéca núa yàacàsi ìwalinápiná meedá. ");
INSERT INTO pioNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Picácué máiní cáinináca piicáca piyáacaléwa chái èeri irìcu imáalàapinácáináwa meedá caquialéta yái yàacàsica. Néese, iwàwacutácué cawèníirica piicáca yái yàacàsica yèerica picáuca càmíiri imáalàawa, yái Dios yúuleca nuèripinácuéca pirí, núa asìali Dios néeséerica. Yácáiná Núaniri Dios idéca imàacaca nudènìaca nuchàiniwa nùacaténácué picáuca càmíiri imáalàawa —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Néese náimaca Jesús irí: —‍¿Càinásica iwàwacutá wamànica wamànicaténá càide iyúwa Dios iwàwáaná? —‍náimaca. ");
INSERT INTO pioNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Jesús íimaca nalí: —‍Dios iwàwacué peebáidaca nutàacái, núa wenàiwica Dios ibànuèrica —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Néese nasutáca néemìawani: —‍¿Càiríiná wawàsi áiba wenàiwica càmíiri idé imànica pimàníiripiná waicá yéewanápiná weebáidaca pitàacái? ¿Càinásica píalimá pimànica? ");
INSERT INTO pioNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Wàawirináimi nayáacaté pan nacáiri èeri imanùbaca íipidenéericaté maná nèepunícaalítéwa manacúali yùucubàa càináwàiri, càide iyúwaté profeta itànàaná Dios itàacái Salmos irìcu: ‘Imàacacaté pan nacáiri yúuwàacawa chènuníise èeri imanùbaca nayáapiná’, cài profeta itànàacaté Moisés iináwaná ìwali —‍náimaca. ");
INSERT INTO pioNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Jesús íimaca nalí: —‍Péemìacué cayába, Moisés càmitaté yàa nayáapiná pan chènuníiséeri. Yácata Núaniri Dios yèericaté nalíni, èeri imanùbaca, quéwa siùcáisede yàacué pirí yái báisíiri yàacàsi chènuníiséerica. ");
INSERT INTO pioNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Núacata yái Dios yúule cáurica Dios yèericuéca pirí, núa iricuèricawa chènuníise, yá nùaca nacáuca càmíiri imáalàawa níái èeri mìnanáica —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Néese nasutácani: —‍Uwé, pìa wayáa yái yàacàsica mamáalàacata —‍náimaca. ");
INSERT INTO pioNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Jesús íimaca nalí: —‍Núacata yái yàacàsica yèerica wenàiwicanái icáuca càmíiri imáalàawa. Ewita piyáacáanítacué piyáacaléwa èeri irìcuíri yàacàsi, càicáaníta máapitacué pía àniwa, macàlacué nacái piwàwa àniwa. Quéwacué peebáidacaalí nulí, pimànicaalícué nacái càide iyúwa nuwàwáaná, yásí matuíbanáicuéca piwàwa Dios yáapicha càiripináta, càide iyúwa casíimáiná wenàiwica càmíiyéica máapi, càmíiyéi nacái macàla iwàwa. ");
INSERT INTO pioNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Quéwa nudéca nucàlidacuéca piríni, éwitacué piicácáaníta yái numàníirica, càicáanítacué càmita peebáida nutàacái mamáalàacata. ");
INSERT INTO pioNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Cawinácaalí Núaniri Dios imàaquéeyéica nùasunáipiná, níata yeebáidapiná nutàacái. Néese macáita yeebáidéeyéica nutàacái, canácatáita núuca nuíchawa nía. ");
INSERT INTO pioNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Càmita nùanàa chènuníise numànicaténá meedá iyúwa nuwàwáaná. Néese nudéca nùanàaca numànicaténá càide iyúwa Núaniri Dios iwàwáaná, yái ibànuèrica núa. ");
INSERT INTO pioNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Núaniri Dios yái ibànuèrica núa càmita iwàwa yúucacawa nuícha abéeri nùasu wenàiwicanái yéená, Dios imàaquéeyéica yeebáidaca nutàacái. Néese Dios iwàwa numichàidaca nía yéetácáisi íicha èeri imáalàacaalípináwa. ");
INSERT INTO pioNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Yácáiná Núaniri Dios iwàwa nadènìaca nacáucawa càmíiri imáalàawa Dios yáapicha macáita wenàiwica yeebáidéeyéica Dios Iirica núa, yeebáidéeyéi nacái nutàacái. Néese numichàidapiná níawa yéetácáisi íicha èeri imáalàacaalípináwa —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Néese níái judío íiwacanánáica nadàbaca natàaníca báawéeri iyú Jesús ìwali íimacáináté: “Núacata yái Dios yúuleca chènuníiséeri Dios yèericuéca pirí, nùacaténácué picáuca càmíiri imáalàawa”, íimaca. ");
INSERT INTO pioNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Yá náimaca nalíwáaca: —‍¡Yácata Jesús meedá, yái José ìirimica! Wáalíaca waicáca isèenái, yáanirimi, yáatúa nacái. ¡Ichìwaca meedá yái icàlidacáiná iricùacasawa chènuníise! —‍náimaca. ");
INSERT INTO pioNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Néese Jesús íimaca nalí: —‍Picácué cài pitàaní piríwáaca. ");
INSERT INTO pioNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Abéerita Núaniri Dios imàaquéeri wenàiwica neebáidaca nutàacái, yéewanápiná nùasu wenàiwicaca nía. Yá numichàidapiná níawa yéetácáisi íicha èeri imáalàacaalípináwa. ");
INSERT INTO pioNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Profeta Isaías itànàacaté tàacáisi Dios inùmalìcuíse. Càité íimaca: ‘Dios yéewáidapiná macái wenàiwica’, cài itànàaca. Iná yéewa macáita yéemièyéica Núaniri Dios itàacái, yéewáidéeyéi nacáiwa ìwali, neebáidapiná nutàacáiwa. ");
INSERT INTO pioNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","“Canácatàacá áiba nuícha iiquéeri Núaniri Dios. Abéerita núa, yái Dios ibànuèrica chènuníise, nudéca nuicácani. ");
INSERT INTO pioNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Péemìacué cayába, cawinácaalí yeebáidéerica nutàacái idènìaca siùcáisede icáucawa càmíiri imáalàawa. ");
INSERT INTO pioNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Núacata yái yàacàsica yèerica wenàiwica icáuca càmíiri imáalàawa. ");
INSERT INTO pioNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Pìawirináimicué nayáacaté nayáacaléwa èeri imanùbaca, yái pan nacáirica íipidenéericaté maná Dios ibànuèricaté nalí chènuníise idècunitàacá nèepunícawa manacúali yùucubàa càináwàiri. Nayáacaté maná èeri imanùbaca, quéwa béeyéicaalíté nía, yáté néetácawa càide iyúwa macái èeri mìnanái yéetáanáwa. ");
INSERT INTO pioNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Quéwa nucàlidacué pirí nùwaliwa, núacata yái yàacàsica iricuèricawa chènuníise: Cawinácaalí wenàiwica iyéerica yái yàacàsica, ìyapiná càiripináta Dios yáapicha. ");
INSERT INTO pioNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Núacata yái yàacàsi cáurica iricuèricawa chènuníise: Cawinácaalí iyéerica yái yàacàsi cáurica, idènìapiná icáucawa càmíiri imáalàawa Dios yáapicha. Yái yàacàsi nuèripináca nalí, yácata nuiná yái. Yá numàacapiná nuináwa nuétácaténáwa yéewanápiná èeri mìnanái nadènìaca nacáucawa càmíiri imáalàawa Dios yáapicha —‍íimaca yái Jesúsca yéewáidacaténá nía imàacáanápináté icáucawa. ");
INSERT INTO pioNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Néese níái judío íiwacanánáica nadàbaca natàaníca nalíwáaca chàinisíiri iyú. Yá néemíanícawa, náimaca nalíwáaca: —‍¡Canáca yéewaná yàaca wayáa iináwa yái asìalica! —‍náimaca. ");
INSERT INTO pioNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Jesús íimaca nalí: —‍Péemìacué cayábani, càmicaalícué piyáa nuiná, núa asìali Dios néeséerica, càmicaalícué nacái pìira nuíraná, càmitacué pidènìapiná picáucawa càmíiri imáalàawa. ");
INSERT INTO pioNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Cawinácaalí iyéerica nuiná, ìiréeri nacái nuíraná, idènìaca siùcáisede icáucawa càmíiri imáalàawa; néese numichàidapinácani yéetácáisi íicha èeri imáalàacaalípináwa. ");
INSERT INTO pioNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Cayábéeri yàacàsi yái nuináca. Cayábéeri nacái nuíraná wenàiwica ìirapiná. ");
INSERT INTO pioNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Cawinácaalí iyéeri nuiná, ìiréeri nacái nuíraná, ìyaca abédanamata núapicha, núa nacái nùyaca abédanamata yáapicha. ");
INSERT INTO pioNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Núaniri Dios yái ibànuèrica núa ìyaca càiripináta. Núa nacái nùyaca càiripináta Núaniricáiná yàaca nucáuca. Càita nacái cawinácaalí iyéerica nuiná, yá nùaca nacái icáuca càmíiri imáalàawa. ");
INSERT INTO pioNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Nucàlidacué pirí nùwaliwa yái yàacàsica iricuèricawa chènuníise. Yái yàacàsica càmíiricata càide iyúwa maná yái pan nacáirica pìawirináimi iyéericatécué, quéwaté béeyéicaalí nía, yá néetácatéwa càmicáiná yéewa maná yàaca nacáuca càmíiri imáalàawa. Quéwa cawinácaalí iyéerica yái yàacàsica nuèripináca irí, idènìapiná icáucawa càmíiri imáalàawa —‍cài Jesús icàlidaca nalí comparación, yéewáidacaténá nía iwàwacutáanápináté imàacaca icáucawa yéewacaténá yàasu wenàiwica nadènìaca nacáucawa càmíiri imáalàawa. ");
INSERT INTO pioNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Càité Jesús yéewáidaca judíonái nàwacáidáyacacaalítéwa néewáidacàalu irìcuwa Capernaum ìyacàlená néeni. ");
INSERT INTO pioNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Néeseté manùbéeyéi néená níái yèepuníiyéicatéwa Jesús yáapicha quéechatécáwa, idécanáamité néemìaca Jesús itàacái yéewáidéerica iyú nía, yá náimaca nalíwáaca: —‍Máiní càulenáca weebáidaca yái tàacáisi icàlidéerica walí. ¡Càmita wawàwa weebáidaca itàacái! —‍náimaca. ");
INSERT INTO pioNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Quéwa Jesús yáalíacawa natàaníca báawéeri iyú itàacái ìwali. Yá íimaca nalí: —‍¿Cánácué báawa péemìacani, yái nucàlidéericuéca pirí? ");
INSERT INTO pioNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Néese, ¿càinásicué píináidacawa piicácaalícué núa, asìali Dios néeséerica, numichàacawa chènuniré àniwa, aléera nùyacataléca bàaluité? ");
INSERT INTO pioNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Abéerita Espíritu Santo yèeri wenàiwica icáuca càmíiri imáalàawa. Canácaalí Espíritu Santotá, yásí canéerica iwèni meedá yái nuinácatá. Yái comparación nucàlidéericuéca pirí yàacàsi ìwali íimáanáca Espíritu Santo yàacuéca picáuca càmíiri imáalàawa peebáidacaalícué nutàacái báisíiri iyú. Càmita íimáaná iwàwacutácué piyáaca nuinásíwa. ");
INSERT INTO pioNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Quéwa nàyaca abénaméeyéi pèewi càmíiyéipiná idènìa icáucawa càmíiri imáalàawa càmicáiná neebáida nutàacái —‍íimaca yái Jesúsca. Cài Jesús íimaca yácáiná idàbacatáiseté imáidaca yéewáidacalénáiwa quéechatécáwa, yáté yáalíacawa cawinácaalí nía càmíiyéipinácaté yeebáida itàacái, yáalía nacáiwa chánácaalí wéená itéeripinácaté Jesús yùuwidenái náibàacaténáni. ");
INSERT INTO pioNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Néese Jesús íimaca nalí nacái: —‍Iná nudéca nucàlidacuéca piríni canácata yáaliméeri nùasu wenàiwicapiná càmicaalícáwa Núaniri Dios imàaca yeebáidaca nutàacái —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Néese madécaná néená níái yèepuníiyéicatéwa quéechatécáwa Jesús yáapicha nèepùacawa íicha. Càmita quirínama nàacawa yáapicha. ");
INSERT INTO pioNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Néese Jesús isutáca yéemìawa wía, wía yéewáidacaléca, doce wamanùbaca. Yá íimaca walí: —‍¿Néenicué nacái pía yèeyéipináta nacáiwa? —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Quéwa Simón Pedro íimaca irí: —‍Wáiwacali, canácata áiba yéewáidéeri wía. Abéerita pía icàlidéeri walí càinácaalí iwàwacutáaná wamànica wadènìacaténá wacáucawa càmíiri imáalàawa. ");
INSERT INTO pioNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Weebáidaca pitàacái. Wáalíaca nacái mabáyawanéeri Mesíasca pía, yái wacuèrináca, yái cáuri Dios Iirica —‍íimaca yái Pedroca. ");
INSERT INTO pioNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Jesús íimaca walí: —‍Nudéca nuedácuéca pía, píacué docéeyéica imanùbaca. Quéwa abéeri péenácué Satanás yàasu —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Càité Jesús icàlidaca Judas ìwali, yái Simón Iscariote ìirimi. Ewita abéeri wéenácáanítani, wía yéewáidacaléca doce wamanùbaca, càicáaníta Judas itéenápinácaté Jesús yùuwidenái náibàacaténáni. ");
INSERT INTO pioNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Néese Jesús yèepunícatéwa Galilea yàasu cáli íinatabàa. Càmitaté iwàwa ìyaca Judea yàasu cáli íinata, níacáiná judío íiwacanánái nawàwacaté nanúacani. ");
INSERT INTO pioNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Quéwa mawiénicaté judíonái yàasu culto abéeri semanéerica íipidenéeri Enramadas, nàyacaténáté capìima irìcu. ");
INSERT INTO pioNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Iná Jesús yéenánái náimaca irí: —‍Picá piyamáawa chái, néese pìawa Judea yàasu cáli néré yéewacaténá pìasu wenàiwica ìyéeyéica néeni naicáca yái pimàníiricasa càmíirica áiba wenàiwica idé imànica. ");
INSERT INTO pioNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Aiba iwàwacaalí manùba wenàiwica náalía naicácani, néese càmita imàni wawàsi ibàacanéeri iyú. Báisícaalí píalimá pimànica yái càmíirica wenàiwica idé imànica, yá iwàwacutá pimànicani manùba wenàiwica yàacuésemi —‍náimaca. ");
INSERT INTO pioNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Càica Jesús yéenánái icàlidaca iríni, càmicáiná nacái neebáida irí. ");
INSERT INTO pioNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Néese Jesús íimaca nalí: —‍Càmitàacá nuénáiwaná yàanàa, quéwacué píalimá píibaidaca pìasu wawàsiwa macái èeri imanùbaca. ");
INSERT INTO pioNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Aibanái èeri mìnanái càmíiyéica yeebáida nutàacái càmitacué yéewa báawaca naicáca pía, quéwa báawaca naicáca núa numàacacáiná náalíacawa nabáyawaná ìwaliwa. ");
INSERT INTO pioNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Pìacuéwa culto néré, núa quéwa càmitàacá nùawa siùca, càmicáinátàacá nuénáiwaná yàanàa cayába —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Néese idécanáami cài icàlidaca nalíni, yá Jesús iyamáacawa náicha Galilea yàasu cáli néré. ");
INSERT INTO pioNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Néeseté idécanáami Jesús yéenánái yàacawa, yá Jesús yàacawa nacái Jerusalén ìyacàlená nérépiná. Càmita quéwa yàawa manùba wenàiwica yáapicha; yàacawa batéwa ibàacanéeri iyú. ");
INSERT INTO pioNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Néese judío íiwacanánái nacutácani culto yaalí, Jerusalén ìyacàlená irìcu. Yá nasutáidaca néemìawa wenàiwicanái: —‍¿Alénásica yáara asìalica? —‍náimaca. ");
INSERT INTO pioNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Nía nacái wenàiwicaca natàaníca ibàacanéeri iyú nalíwáaca Jesús ìwali: “Cayábéeri íiwitáise”, náimaca. Quéwa áibanái náimaca: “Càmíirita cayába, ichìwáidacáiná wenàiwica meedá”, náimaca. ");
INSERT INTO pioNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Quéwa macáita natàaníca Jesús ìwali ibàacanéeri iyú cáalucáiná naicáca judío íiwacanánái, níái báawéeyéica iicáca Jesús. ");
INSERT INTO pioNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Idècunitàacá namànica culto semana ìwalìabàacatái, yáté Jesús iwàlùacawa templo irìculé. Yá idàbaca yéewáidaca wenàiwica néré. ");
INSERT INTO pioNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Níái judío íiwacanánáica náináidacawa manuísíwata néemìaca Jesús yéewáidáaná. Yá náimaca ìwali: —‍¡Canéeri iwèni meedá yàasu tàacáisi càmicáináté yéewáidawa wàasu escuela irìcu! —‍náimaca nawènúadacaténá wenàiwica íiwitáise Jesús íicha. ");
INSERT INTO pioNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Néese Jesús íimaca nalí: —‍Yái nuéwáidéericuéca pía ìwali càmíirita nùasu tàacáisi. Nucàlidacué pirí yàasu tàacáisi yái Núaniri Dios, yái ibànuèrica núa. ");
INSERT INTO pioNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Aibacaalí iwàwa imànica càide iyúwa Dios iwàwáaná, yásí yáalíacawa nuéwáidaca nía Dios yàasu tàacáisi iyú; náalía nacáiwa càmita nuéwáida nía nùasu tàacáisi iyúwa meedá. ");
INSERT INTO pioNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Cawinácaalí itàaníirica íiwitáise iyúwa meedá iwàwa wenàiwicanái yàaca íimiétacaná, quéwa núa iwàwéeri wenàiwicanái yàaca Núaniri Dios íimiétacaná, yái ibànuèrica núa. Iná nutàaníca báisíiri iyú, núacáináta yái báisíirica, càmita nacái nuchìwa. ");
INSERT INTO pioNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","“Profeta Moisés icàlidacaté pìawirináimicué iríni càinácaalí Dios iwàwáanácué pimànica. Quéwa canácatacué pèewi áiba imàníirica càide iyúwa Dios iwàwáaná. ¿Cánácué piwàwa pinúaca núa? —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Néese níái wenàiwicanáica náimaca irí: —‍¡Demonio ìyaca piwàwalìcu idacuèri píiwitáise, íná máiwitáiseca pía meedá! ¡Canácata iwàwéeri inúaca pía! —‍náimaca. ");
INSERT INTO pioNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Néese Jesús íimaca nalí: —‍Macáitacué píináidacawa manuísíwata piicáidaca yái numàníiricaté áiba sábado bàaluité piyamáidacatáicuécawa, nuchùnìacaalíté cáuláiquéeri asìali, íná báawacuéca piicáca núa numànicáiná yái wawàsi píiméericuéca ìwali càmíiricasa Dios imàaca wamànica sábado irìcu judíonái iyamáidacatáicawa. ");
INSERT INTO pioNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Quéwa Dios imàacaca wáibaidaca sábado irìcu iwàwacutácaalí wamànica áiba cayábéeri wawàsi Dios ichùulièrica wamànica. Càita ìyaca circuncisiónca. Profeta Moisés yéewáidacaté nía circuncisión ìwali, càide iyúwaté wàawirináimi imàníináté circuncisión néenibe asìanái iríwa madécaná camuí Moisés ipíchawáise. Yái Moisés yéewáidacaté nía iwàwacutáanácué pimànica circuncisión sùmài irí abéeri semana idénáami imusúaca iicá èeri éwita ìyacáaníta sábado piyamáidacatáicuécawa. Iná pimànicuéca circuncisión péenibe asìanái iríwa càinácaalí èeri iwàwacutácatáicué pimànicani, yéewacaténácué pimànica machacàníiri iyú càide iyúwa Dios ichùulìaná. ");
INSERT INTO pioNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Càita pimànicuéca càide iyúwa profeta Moisés ichùulìaná wàawirináimi Dios inùmalìcuíse, yá pimànicuéca circuncisión péenibe asìanái iríwa éwitacué iwàwacutácáaníta pimànicani sábado irìcu wayamáidacatáicawa, idènìacaalí abéeri semana yái sùmàica. Néese, ¿cánácué báawa piwàwa núapicha ìwalíise yái nuchùnìanáca macái iiná yáara asìalica cáuláiquéerimica sábado piyamáidacatáicuécawa? ");
INSERT INTO pioNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Picácué picháawàa wenàiwica iináwaná ìwali ipíchawáisecué píalía nàwali cayába càinácaalí namàníiná. Iwàwacutácué píináidacawa cáalíacáiri iyú ipíchawáise picàlidacuéca naináwaná ìwali. Néese, pitàanícué báisíiri iyú —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Idécanáamité néemìaca Jesús íimáaná, néese abénaméeyéi ìyéeyéica Jerusalén ìyacàlená néeni nadàbaca náimaca nalíwáaca: —‍¡Yácata Jesús, yái asìali judío íiwacanánái nacutéerica nanúacaténáni! ");
INSERT INTO pioNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Piicácué yái, itàaníca iyúwa iwàwáaná itàaníca macái wenàiwica yàacuésemi, quéwa wáiwacanánái càmita nàalàa cachàiníiri iyúni. Cawàwanáta wáiwacanánái náináidacawa ìwali Mesíascani, wacuèrinápiná wía judíoca, Dios ibànuèrica walí. ");
INSERT INTO pioNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Quéwa càmita yéewa Mesíascani, wáalíacáináwa ácatáiséericaalí yái asìalica, quéwa Mesías yàanàacaalípiná, yá canáca yáaliéripiná ìwali síisáanéericaalíni —‍náimaca. ");
INSERT INTO pioNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Idècunitàacá Jesús yéewáidaca wenàiwica templo irìcu, yá yéemìaca yái náiméerica ìwali. Néese Jesús íimaca cachàiníiri iyú: —‍Piyúunáidacuéca píalíacawa nùwali. Piyúunáidacué nacái píalíacawa síisáanéericaalí núa. Quéwa càmita nùanàa numànicaténá càide iyúwa nuwàwáaná, néese nudéca nùanàaca Dios ibànùacáiná núa, yái Dios báisíirica, càmíiricué píalía ìwali. ");
INSERT INTO pioNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Núalíaca Dios ìwali nùanàacáiná yàatanáise. Ibànùa nacái núa néese —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Néese judío íiwacanánái nawàwa náucaca Jesús presoíyéi ibànalìculé, quéwa càmitaté náibàani càmicáinátàacá Jesús yéenáiwaná yàanàa nanúacatáipinácaténi. ");
INSERT INTO pioNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Quéwa madécaná wenàiwica neebáidaca Mesíascani, yái judío icuèrinápináca Dios ibànuèrica nalí. Yá náimaca nalíwáaca: —‍Iwàwacutá Mesíascani yái asìalica imànicáiná macái íiwitáaná yái càmíirica áiba wenàiwica idé imànica càide iyúwaté profetanái itànàaná tàacáisi Mesías ìwali Dios inùmalìcuíse, yái Mesías yàanèeripinácaté icùacaténá wía, wía israelitaca —‍náimaca. ");
INSERT INTO pioNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Néeseté abénaméeyéi fariseo néemìaca wenàiwicanái itàaníca ibàacanéeri iyú nalíwáaca Jesús ìwali. Iná fariseonái, sacerdote íiwacanánái yáapicha nabànùaca nàasu úwináiwa icuèyéica templo náibàacaténá Jesús náucáanápináni presoíyéi ibànalìculé. ");
INSERT INTO pioNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Iná Jesús íimaca: —‍Nùyacué pèewi achúma èerita. Néese nuèpùacawa Dios yàataléwa yái ibànuèricaté núa. ");
INSERT INTO pioNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Néese picutápinácué núawa, quéwacué càmita pidé pìanàaca núawa càmicáinácué yéewa pìanàaca néré nùyacatalépináca —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Néese judíonái náimaca nasutáca néemìawa níawáaca: —‍¿Alénásica yàawa yái asìalica càmicatalépinácasa wadé wàanàacani? Cawàwanáta yàacawa wéenánái yàatalé ìyéeyéica càmíiyéi judío yèewiré yéewáidacaténá càmíiyéi judío. Quéwa canápináta meedá yàacawa, càmicáiná neebáida itàacái. ");
INSERT INTO pioNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿Càinásica íimáaná? ‘Picutápinácué núawa quéwacué càmita pidé pìanàaca núawa càmicáinácué yéewa pìanàaca néré nùyacatalépináca’, cài íimaca —‍náimaca, naicáaníca Jesús iquíniná. ");
INSERT INTO pioNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Aiba èerité namáalàidáanápiná namànica culto, máiníiri iwàwacutácawa nalí yái èerica. Yá Jesús ibàlùacawa nàacuésemi, yá íimaca cachàiníiri iyú, icàlidaca nalí comparación: —‍Piwàwacaalícué picáucawa càmíiri imáalàawa càide iyúwa macàléeyéi iwàwa nawàwacaalí úni, néese peebáidacué nutàacái. Yásí nùacué picáuca càmíiri imáalàawa, càide iyúwa wàacaalí nàiraca úni, cawinácaalí macàléeyéica iwàwa. ");
INSERT INTO pioNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Càide iyúwa Dios itàacái íimáaná profeta itànèericaté Dios inùmalìcuíse, cawinácaalí wenàiwica yeebáidéerica nutàacái, idènìapiná cáuri úni iwàwalìcuwa, yái úni cáurica yèerica icáuca càmíiri imáalàawa càide iyúwa cayábéeri únibàa depuíwéeri canácatáita chuìni —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Jesús icàlidaca nalí yái comparaciónca yéewáidacaténá nía Espíritu Santo ìwali, yái icuèripinácaté náiwitáise cawinácaalí yeebáidéeyéica Jesús itàacái. Yái úni cáurica íimáanáca càicanide iyúwa Espíritu Santo. Quéwa néenialíté càmitàacá Espíritu Santo yàanàaca aléi èeri irìculé càmicáinátécá Jesús yéetáwa, càmicaalítécá nacái imichàawa chènuniré ìyacaténá cáimiétacanéeri iyú Dios yáapicha. Ináté càmitàacá yéewa Espíritu Santo yàanàaca aléi èeri irìculé. ");
INSERT INTO pioNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Néeseté abénaméeyéi néená níái wenàiwicaca idécanáami néemìaca Jesús itàacái, yá náimaca: —‍Báisícata profetacani yái Jesúsca, càide iyúwa profeta Moisés itànàanáté tàacáisi profeta ìwali yàanèeripinácaté yéewáidacaténá wía —‍náimaca. ");
INSERT INTO pioNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Aibanái íimaca: —‍Mesíascani, yái wacuèrinápiná Dios ibànuèrica walí, wía judíoca —‍náimaca. Quéwa áibanái íima: —‍Càmita yéewa wacuèrinápiná Mesías yàanàaca Galilea yàasu cáli néese. ");
INSERT INTO pioNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Iwàwacutá rey David itaquérinámicani yái Mesíasca, càide iyúwaté Dios itàacái íimáaná profetanái itànèericaté. Iwàwacutá nacái imusúaca iicá èeri Belén ìyacàlená irìcu, yái yàcaléca David imusúacatalécaté iicá èeri. Quéwa yái asìalica Jesús, Nazaret ìyacàlená néeséeri meedá. Iná càmita yéewa Mesíascani —‍náimaca, càmicáináté néemìa Jesús iináwaná ìwali imusúacaté iicá èeri Belén ìyacàlená irìcu, rey David itaquérinámi nacáicani, yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Càita náináidacawa Jesús ìwali, íná càmita abédanama náiwitáise náapichawáaca níái wenàiwicaca. ");
INSERT INTO pioNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Aibanái nawàwa náibàacani quéwa càmitaté náibàani. ");
INSERT INTO pioNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Néeseté úwinái icuèyéica templo nèepùacawa fariseonái yàatalé, sacerdote íiwacanánái nacái. Yá náimaca úwinái irí: —‍¿Cánácué càmita pité néeseni? —‍náimaca. ");
INSERT INTO pioNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Néese úwinái íimaca nalí: —‍¡Canátàacá áiba wenàiwica itàaníirica àta siùca nacáide càide iyúwa itàaníiná yáara asìalica! —‍náimaca. ");
INSERT INTO pioNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Néese fariseonái náimaca nalí: —‍¿Pimàacasicué ichìwáidaca pía nacái càide iyúwa ichìwáidáaná áibanái? ");
INSERT INTO pioNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Canácata wéená wía náiwacanánáica, wía nacái fariseoca, canácata wéená yeebáidéeri itàacái. ");
INSERT INTO pioNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Quéwa áibanái wenàiwica yeebáidéeyéica itàacái, canéeyéica iwèni meedá nía, càmíiyéi yáalíawa Dios itàacái ìwali, Dios yúuquéeyéipiná íichawa meedá —‍náimaca. ");
INSERT INTO pioNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Néese Nicodemo yái fariseo ipáchiéricaté Jesús yàatalé áiba catá ìyaca néeni fariseonái yèewi, judío íiwacanánái nacái. Yá Nicodemo íimaca nalí: ");
INSERT INTO pioNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","—‍Dios itàacái càmita ibatàa wanúaca wenàiwica àta wéemìacataléta icàlidaca iináwanáwa, wáalíacaténáwa ìwali yái imàníináca —‍íimaca yái Nicodemoca. ");
INSERT INTO pioNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Néese náimaca Nicodemo irí: —‍¿Píatasica Galilea yàasu cáli néeséeri nacái? Pitàaníca máiwitáiséeri iyú meedá càide iyúwa canéeyéi iwèni Galilea yàasu cáli néeséeyéica. Pìa péewáidacawa Dios itàacái ìwali profetanái itànèericaté, yásí píalíacawa canáca profeta imusuéricatéwa Galilea yàasu cáli néese —‍náimaca naimáichacáináté abénaméeyéi profeta nàanàacaté Galilea yàasu cáli néese. ");
INSERT INTO pioNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Néese nèepùacawa macáita nacapèe néréwa. ");
INSERT INTO pioNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Quéwa Jesús yàacatéwa dúli néré íipidenéechúa Olivos, íimáanáca olivo inàlimaná. ");
INSERT INTO pioNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Néese mapisáita àniwa amalácaalí yàacawa nawicáu, yá Jesús yèepùacawa templo néré. Manùbéeyéi wenàiwica nàacawa yàatalé, yá Jesús yáawinacawa yéewáidacaténá nía. ");
INSERT INTO pioNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Néese abénaméeyéi yéewáidéeyéi wenàiwica templo irìcu, fariseonái nacái natéca inanái Jesús yàatalé, abéechúa inanái canìríichúa. Nàanàacaté úa idècunitàacá uimáca áiba asìali yáapicha càmíirica unìrisíwa. Yá nabàlùadaca úa nàacuésemi níái ìyéeyéica néeni. ");
INSERT INTO pioNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Yá náimaca Jesús irí: —‍Pía yéewáidéerica wenàiwica, wadéca wàanàaca úái inanáica idècunitàacá uimáca áiba asìali yáapicha càmíirica unìrisíwa. ");
INSERT INTO pioNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Dios itàacái profeta Moisés itànèericaté Dios inùmalìcuíse íimaca iwàwacutáanápiná wanúaca úa íba iyú cawinácaalí inanái iiméechúaca áiba asìali yáapicha càmíirica unìrisíwa. Néeni pía, ¿càinásica píimaca ùwali úái inanáica? —‍náimaca. ");
INSERT INTO pioNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Nasutáca néemìawa Jesús yéewanápiná náalimáidaca naicáwa Jesús nacháawàacaténá iináwaná ìwali itàacái ìwalíisewa. Néese Jesús yáawiacawa itànàaca cáli ìwali icáapi ipùata iyúwa. ");
INSERT INTO pioNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Quéwa nasutáca néemìawa Jesús mamáalàacata. Néese Jesús ibàlùacawa machacànita àniwa, yá íimaca nalí: —‍Néeni, cawinácaalícué péenáquéi mabáyawanéeri, yásí iwàwacutá idàbaca inúaca úa íba iyú —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Néese Jesús yáawiacawa itànàaca cáli ìwali àniwa icáapi ipùata iyúwa. ");
INSERT INTO pioNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Quéwa idécanáami néemìacani, yá nadàbaca nawàwalica macái báawéeri namàníirica, Dios imàacacáiná nawàwalica nabáyawanáwa. Yá nàacawa náicha abéerinamata namanùbaca iyúwa. Níái béeyéica náicha canánama, yá idàbaca nàacawa náicha quéechacáwa, néese ùuculìiyéi nàacawa náicha. Idécanáamité fariseonái macáita nèepùacawa náicha, yá Jesús ibàlùacawa machacànita àniwa. Yá iicáca úái inanáica ibàluèchúacawa abéechúata. ");
INSERT INTO pioNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Néese Jesús isutáca yéemìawa úa: —‍¿Néeni níái icháawèeyéica piináwaná ìwali? ¿Canátasica iwàwéeri inúaca pía pibáyawaná ìwalíisewa? —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Néese úumaca Jesús irí: —‍Nuíwacali, canácata iwàwéeri yùuwichàidaca núa —‍úumaca. Néese Jesús íimaca ulí: —‍Uwé, núa nacái càmita nùuwichàida pía. Siùcade pìawa, picá pimàni pibáyawanáwa àniwa —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Néeseté wenàiwicanái ìwacáidáyacacawa Jesús yàatalé àniwa, yá íimaca nalí: —‍Péemìacué comparación: Càica núade iyúwa camalási chái èeri irìcu nuéwáidacáiná èeri mìnanái náalíacaténá Dios ìwali. Cawinácaalí yeebáidéeyéica nutàacái càmita nèepuníwa catéeri náiwitáise yáapichawa iyúwa wenàiwica càmíiyéica yáalía Dios ìwali, íná càmita namàni mamáalàacata nabáyawanáwa. Néese, amaláca numànica náiwitáise, náalíacaténá Dios ìwali, nùacáiná nacáuca càmíiri imáalàawa —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Néese fariseonái náimaca Jesús irí: —‍Canéeri iwèni meedá pitàacái picàlidacáiná piináwaná ìwaliwata, íná caná yéewaná wenàiwica yáalíacawa asáisí báisícaalíni —‍náimaca. ");
INSERT INTO pioNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Jesús íimaca nalí: —‍Cawèníiriquéi yái nucàlidéerica éwita nucàlidacáaníta nuináwaná ìwaliwani, núalíacáináwa síisáanácaalí nùanàa, núalía nacáiwa alénácaalípiná nùawa. Quéwa càmitacué píalíawa síisáanácaalí nùanàaca, alénácaalí nacái nùapináwa. ");
INSERT INTO pioNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Pidécuéca píimaca áibanái ìwali iwàwacutáanása Dios yùuwichàidaca nía nabáyawaná ìwalíisewa. Quéwa píináidacuéca meedáwa èeri mìnanái íiwitáise iyú. Néese càmita cài nuínáidacawa. Càmita nacái nuémìa naináwaná ìwali chái èeri irìcu nùuwichàidacaténá nía. ");
INSERT INTO pioNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Quéwa núumacaalí siùca nàwalitá iwàwacutáaná nùuwichàidaca níatá, yásí nùuwichàidaca nía machacàníiri iyútá, càmicáiná nuínáidawa nulínáamitawa nùuwichàidáanápiná níatá, néese nuínáidacawa abédanamata Núaniri Dios yáapichawa càide iyúwa iwàwáaná. ");
INSERT INTO pioNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Dios itàacái profeta Moisés itànèericaté bàaluité íimaca: Abédanamacaalí pucháiba wenàiwica íiwitáise náapichawáaca nacàlidáanápiná áibanái iináwaná ìwali, yásí cawènica natàacái. ");
INSERT INTO pioNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Uwé, nàyaca pucháiba icàlidéeyéica nuináwaná ìwali cawinácaalí núa: Núacata icàlidéerica nuináwaná ìwaliwa, yácata nacái Núaniri Dios, yái ibànuèrica núa, icàlida nacái nuináwaná ìwali cawinácaalí núa. Yá abédanamacata wáiwitáise wáapichawáaca, íná yéewa cawèníirica watàacái pucháibacáiná wía —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Néese náimaca Jesús irí: —‍Wadéca wéemìaca piináwaná ìwali càmita píalíawa cawinácaalíté píanirimica —‍náimaca. Néese Jesús íimaca nalí: —‍Núalíacawa càmitacué píalíawa cawinácaalí núa, càiná nacái nuíwitáise. Núalíacawa nacái càmitacué píalía Núaniri Dios ìwali. Píalíacaalícuéwa cawinácaalí núatá, yá píalíacuécawa nacái Núaniri Dios ìwalitá —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Càité Jesús íimaca idècunitàacá yéewáidaca wenàiwicanái templo irìcu, mawiénita ofrenda yàalu irí náucacataléca nàasu platawa namàaquéericaté Dios irípiná ofrenda iyú. Quéwa càmitaté náibàani càmicáinátécáwa Jesús yéenáiwaná yàanàa nanúacatáipináténi. ");
INSERT INTO pioNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Néeseté Jesús íimaca nalí àniwa, níái judío íiwacanánáica: —‍Yá nùacawa mesúnamáita, néese picutápinácué núawa, nuwasàacaténácué pía yùuwichàacáisi íicha, quéwa càmitacué pidé pìanàaca núa, íná péetápinácuécawa méetàuculé Dios íicha pibáyawaná yáapichacuéwa. Nùacawa aléera canácatalépináca yéewanácué piwàlùacawa —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Néese judío íiwacanánái náimaca nalíwáaca: —‍Cawàwanáta inúapináca yáawawa íná cài íimaca yàanápináwa alénácaalí caná yéewaná wawàlùacawa —‍náimaca naicáaníca Jesús iquíniná. ");
INSERT INTO pioNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Néese Jesús íimaca nalí: —‍Eeri mìnanáicuéca pía, quéwa núaquéi chènuníiséeri. Pìyacuéca chái èeri irìcu quéwa càmita èeri mìnali núa. ");
INSERT INTO pioNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Iná nudéca núumacuéca pirí péetáanápinácawa méetàuculé Dios íicha pibáyawaná yáapichawa. Càmicaalícué peebáida iyúwa núumáanácué pirí cawinácaalí núa, yásí péetácuécawa pibáyawaná yáapichawa —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Néese náimaca Jesús irí: —‍¿Cawiná pía? —‍náimaca. Néese Jesús íimaca nalí: —‍Nudàbacaalíté nuéwáidaca wenàiwica, nucàlidacatécué piríni mamáalàacata nuináwanáwa cawinácaalí núa. Siùcade canápináta meedá nutàanícuéca píapicha càmicáinácué piwàwa peebáidaca nutàacái. ");
INSERT INTO pioNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Iyaca madécaná wawàsi nucàlidacaténácué pirí péemìacaténácué pibáyawaná ìwaliwa. Quéwa yái ibànuèrica núa itàaníca báisíiri iyú, yá nacái tàacáisi nucàlidéerica èeri mìnanái irí yácata tàacáisi nuémièrica icàlidaca, yái ibànuèrica núa —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Quéwa níái judío íiwacanánáica càmita náalíawa Jesús icàlidaca ìyaca Yáaniri Dios ìwaliwa. ");
INSERT INTO pioNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Iná Jesús íimaca nalí: —‍Pimichàidacaalípinácué núa cruz ìwali pinúacaténácué núa, núa asìali Dios néeséerica, yásí píalíacuécawa nùwali núacata yái càide iyúwacué núumáaná pirí. Píalíapinácué nacáiwa càmita numàni wawàsi nulínáamitawa, néese, nucàlidaca càide iyúwa Núaniri Dios yéewáidáaná núa. ");
INSERT INTO pioNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Yái Núaniri Dios ibànuèrica núa ìyaca núapicha. Càmita Núaniri imàaca núa abéerita numànicáiná mamáalàacata càide iyúwa iwàwáaná —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Jesús idécanáami cài íimaca, yá madécaná wenàiwica neebáidaca itàacái. ");
INSERT INTO pioNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Néeseté Jesús íimaca nalí abénaméeyéi judío icàlidéeyéica neebáidáanása itàacái: —‍Peebáidacaalícué mamáalàacata nutàacái pimànicaténácué càide iyúwa nuchùulìanácué pía, yásí nuéwáidacalécuéca pía báisíiri iyú. ");
INSERT INTO pioNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Yásí píalíacuécawa ìwali yái nutàacái báisíirica. Yá nutàacái báisíirica iwasàapinácué píawa —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Náimaca irí: —‍Wíaquéi Abraham itaquénáinámi, canácatáita áibanái yàasu wenàiwica wía. ¡Canáca yéewaná píimaca walí piwasàanápinása wíawa! —‍náimaca. ");
INSERT INTO pioNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Jesús íimaca nalí: —‍Péemìacué cayába, cawinácaalí imàníiyéica ibáyawanáwa mamáalàacata, namànica meedá càide iyúwa nabáyawaná ichùulìaná nía, càide iyúwa áibanái wenàiwica íibaidáaná mawèníiri iyú náiwacali iríwa, yàasu wenàiwicacáiná nía. ");
INSERT INTO pioNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Náiwacali càmita íima yàasu wenàiwica ìwaliwa: ‘Nuénásàiriquéi’, càmita íima. Néese íimaca yéenibe ìwaliwa: ‘Nuìrica yái’, cài íimaca. ");
INSERT INTO pioNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Iná núa Dios Iirica, nuwasàacaalícué pía pibáyawaná íichawa, yásí càmitacué iwàwacutá pimànica càide iyúwa pibáyawaná ichùulìanácué pía, Dios yéenibecáinácué pía báisíta. ");
INSERT INTO pioNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Núalíacawa Abraham itaquénáinámicuéca pía, quéwa piwàwacué pinúaca núa càmicáinácué peebáida nutàacái. ");
INSERT INTO pioNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Nucàlidacué pirí ìwali yái báisíiri tàacáisica Núaniri Dios yáasáidéerica nulí. Quéwa núalíacawa pimànicuéca càide iyúwa píaniri íimáanácué pirí —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Náimaca Jesús irí: —‍Abrahamquéi wàawirimica, canáca áiba wáaniri —‍náimaca. Quéwa Jesús íimaca nalí: —‍Báisícaalícué Abraham itaquénáinámica pía piwàwalìcuísewatá, yá pimànicuéca càide iyúwaté Abraham imàníinátá. ");
INSERT INTO pioNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Quéwa éwita nucàlidacáanítacué pirí báisíiri iyúni càide iyúwa Dios yéewáidáaná núa, càicáaníta piwàwacué pinúaca núa meedá. ¡Càmitaté Abraham iwàwa inúaca wenàiwica Dios ibànuèyéicaté Abraham yàatalé! ");
INSERT INTO pioNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Pimànicuéca meedá càide iyúwa píaniri imàníiná —‍íimaca yái Jesúsca. Néese náimaca Jesús irí: —‍Càmíiyéica wáatúa yéenibe úalani irìcuíse wíaquéi. Wadènìa abéerita Wáaniriwa wèerica icàaluíniná, yái Diosca. Càmita wáuca wáichawani wàacaténá ídolo cuwáinái yéenáiwaná icàaluíniná —‍náimaca. ");
INSERT INTO pioNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Néese Jesús íimaca nalí: —‍Báisícaalícué Diosquéi píaniricatá, yásí cáininácuéca piicáca núatá, Dios néeséericáiná núa, ìyéerica chái. Càmita nùanàa nùasu wawàsi ìwaliwa meedá, néese Dioscata yái ibànuèrica núa numànicaténá càide iyúwa iwàwáaná. ");
INSERT INTO pioNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿Cánácué càmita píalimá píalíaca péemìaca yái nucàlidéericuéca pirí? Núalíacawa càmitacué meedá piwàwa peebáidaca nutàacái, íná càmitacué píalimá píalíaca péemìaca càinácaalí íimáaná. ");
INSERT INTO pioNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Píaniricué yácata Satanásca. Píacué nacái yàasu wenàiwicaca. Piwàwacué nacái pimànica càide iyúwa iwàwáaná. Satanás idéca iwàwaca inúaca wenàiwica mamáalàacata èeri idàbacatáisewa àta siùca nacáide. Càmita íináidawa báisíiri tàacáisi ìwali, báawacáiná Satanás iicácani. Itàaníca yáawamita chìwái mamáalàacata càide iyúwa íiwitáise iyáaná, cachìwéericáiná meedáni. Yácata chìwái yáanirica, yái Satanásca, imàacacáiná wenàiwica itàaníca chìwái. ");
INSERT INTO pioNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Quéwa nucàlidacáinácué pirí báisíiri tàacáisi, íná càmitacué peebáida nutàacái. ");
INSERT INTO pioNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Macáitacué píalíacawa nùwali mabáyawanéerica núa. Nucàlidacué pirí báisíiri iyúni, íná ¿cánácué càmita peebáida nutàacái? ");
INSERT INTO pioNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Dios yéenibe neebáidaca itàacái quéwa càmitacué Dios yéenibe pía, íná càmitacué piwàwa peebáidaca itàacái —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Néese judío íiwacanánái náimaca Jesús irí: —‍Báisíta wacàlidacaté pìwali machacàníiri iyúni wáimacaalíté pìwali samaritanosàirica pía, càmíiri judío ìiri meedá. Iyaca nacái demonio piwàwalìcu idacuèrica píiwitáise, íná máiwitáiseca pía meedá —‍náimaca. ");
INSERT INTO pioNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Jesús íimaca nalí: —‍Canáca demonio nuwàwalìcu. Yái numàníirica numànicani núasáidacaténá cayábéerica Núaniri Dios yéewanápiná wenàiwicanái yàaca icàaluíniná. Quéwa càmitacué piicá núa cáimiétaquéeri iyú. ");
INSERT INTO pioNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Càmita nucutá wenàiwica nacàlidacaténá cayábéeri nùwali, quéwa Núaniri Dios iwàwaca wenàiwicanái yàaca nulí cayábéeri, yá Dios yáasáidapiná cawinácaalí cabáyawanéeyéi. ");
INSERT INTO pioNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Péemìacué cayábani, cawinácaalí wenàiwica imàníirica càide iyúwa nutàacái íimáaná, idènìaca siùcáisede icáucawa càmíiri imáalàawa —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Néese judío íiwacanánái íimaca irí: —‍Siùca wáalíacawa báisíiri iyú demonio ìyaca piwàwalìcu. Néetácatéwa macáita profetaca icàlidéeyéicaté tàacáisi Dios inùmalìcuíse bàaluité, Abraham nacái yéetácatéwa. Néese, ¿cáná cài píimaca: ‘Cawinácaalí imàníirica càide iyúwa nutàacái íimáaná, idènìaca siùcáisede icáucawa càmíiri imáalàawa’, cáná cài píimaca? ");
INSERT INTO pioNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¡Pía càmíiri cachàini íicha yái wàawirimi Abrahamca! Abraham yéetácatéwa, nía nacái profetaca néetácatéwa nacái. Càmita yéewa cachàiníiri náicha pía. ¡Càmita máiní cachàiníirica pía càide iyúwa piyúunáidáaná! —‍náimaca. ");
INSERT INTO pioNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Jesús íimaca nalí: —‍Nucàlidacaalí nuináwaná ìwaliwa cayábéerica núatá, yásí canéerica iwèni meedátáni, yái nutàacáica. Quéwa Núaniri Dios icàlidaca nùwali cayábéerica núa, yácata Dios picàlidéericué ìwali Picuèrinásacué Dioscani. ");
INSERT INTO pioNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Quéwa càmitacué píalía Dios ìwali càinácaalí íiwitáise ìyaca. Núacata yái yáaliérica Dios ìwali. Núumacaalí càmitasa núalía Dios ìwalitá, yásí nucàlidaca nuchìwawatá càide iyúwacué pía. Quéwa núalíaca Dios ìwali báisíiri iyú, nuebáida nacái càide iyúwa íimáaná. ");
INSERT INTO pioNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Pìawirimicué Abraham casíimáica iwàwa bàaluité Dios imàacacáináté Abraham yáalíacawa nuénáiwanápiná ìwali, nùanàacatáipináté aléi èeri irìculé. Yáté Abraham yáalíacawa nùanàanápináté, íná yéewa casíimáicaté Abraham iwàwa manuísíwata —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Néese judío íiwacanánái náimaca Jesús irí: —‍Càmitàacá pidènìa cincuenta camuí. Càmita yéewa pidé piicáca wàawirimi Abraham, Abrahamcáiná ìyacaté néese siùca dos mil camuí —‍náimaca. ");
INSERT INTO pioNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Jesús íimaca nalí: —‍Péemìacué cayábani, núacata yái ìyéericaté càiripináta ipíchawáiseté Abraham imusúaca iicá èeri, núacáiná yái Diosca —‍íimaca yái Jesúsca icàlidacaténá iináwanáwa Dioscani, yái càmíirica imáalàawa. ");
INSERT INTO pioNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Néese náibàaca íba nanúacaténá Jesús íba iyú quéwa Jesús ibàacawa náicha. Yá imusúacawa templo irìcuíse. Yá yàacawa manùbéeyéi wenàiwica yèewibàa; càité Jesús ichàbacawa náicha. ");
INSERT INTO pioNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Néeseté Jesús idècunitàacá yèepunícawa áibalépiná wáapicha wía yéewáidacaléca, yá iicáca matuíri asìali. Quéwa yáta asáináni matuírita. ");
INSERT INTO pioNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Néese wasutáca wéemìawa Jesús, wía yéewáidacaléca. Wáimaca irí: —‍Wáiwacali, ¿cánásica imusúawa matuíri iyú yái asìalica? ¿Isèenái ibáyawaná ìwalíisesica cài matuíca yái asìalica, càmicaalí nacái, ibáyawaná ìwalíisetasicawa? —‍wáimaca. ");
INSERT INTO pioNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Néese Jesús íimaca walí: —‍Càmita ibáyawaná ìwalíisewéera, càmita nacái isèenái ibáyawaná ìwalíisewéera. Yái asìalica imusúacawa matuíri iyú yéewanápiná macái wenàiwica yáalíacawa Dios ichùnìacani, naicácaténá Dios cáimiétaquéeri iyú. ");
INSERT INTO pioNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Péemìacué comparación: Iwàwacutá wenàiwica náibaidaca èeríapi idècunitàacá amaláca nawicáu. Catácaalí nàwali, yá càmita náalimá náibaidaca. Càita nacái iwàwacutácué wamànica cayábéeri siùca èeri càide iyúwa Dios iwàwáaná, yái ibànuèrica núa. Nuénáiwaná yàanàaca mesúnamáita nuétácatáipináwa, néese càmita yéewa nuíbaidaca. ");
INSERT INTO pioNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Idècunitàacá nùyaca chái èeri irìcu, yá càica núade iyúwa camalási icànéeri wenàiwica ìwali, amalácáiná numànica náiwitáise náalíacaténá Dios ìwali —‍íimaca yái Jesúsca. ");
INSERT INTO pioNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Néese Jesús idécanáami cài íimaca, néese yàapìsáidaca cáli yèewiré. Yá yèewìadaca cáli isàbecaténáni. Néese ipusúaca cáli matuíri ituí íimami ìwali. ");
INSERT INTO pioNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Néese Jesús íimaca irí: —‍Pìa píibaca pituíwa úni yáaculé namusúadacatáiseca úni íipidenéeri Siloé náiquéericaté cáli yèewiré —‍íimaca yái Jesúsca. (Yái íipidenéerica Siloé íimáanáca: “Ibànuèri”.) Néese matuíri yàaca íibaca yáawawa néré. Néese idécanáami yèepùacawa icapèe néréwa, yá catuícani. ");
INSERT INTO pioNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Néese áibanái wenàiwica matuírimi imanùbacanái naicácani. Aibanái nacái náalíaca naicácani naicácáináté isutáca plata wenàiwica íicha iwènìacaténáté iyáapináwa. Néese níái yáaliéyéica iicácani nasutáca néemìawa níawáaca: —‍¿Càmitasica yái asìalica matuíri yáawinéericatéwa àyapu idùlepi isutácaténá plata wenàiwica íicha yéewanápiná iwènìaca iyáapináwa? —‍náimaca. ");
INSERT INTO pioNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Abénaméeyéi íima: —‍Yácata yái —‍náimaca. Aibanái náima: —‍Càmíiri, áibacata yái, quéwa càiride iyúwa iicácanáwa —‍náimaca. Quéwa yái asìali íimaca: —‍Núacata yái matuírimica —‍íimaca. ");
INSERT INTO pioNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Néese náimaca irí: —‍¿Néeni? ¿Cáná yéewa catuíca pía? —‍náimaca. ");
INSERT INTO pioNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Yá íimaca nalí: —‍Yáara asìali íipidenéerica Jesús yèewìadaca cáli yáawiruní yèewiwa. Yá ipusúaca cáli nutuí íimami ìwali, yá íimaca nulí: ‘Pìawa úni yàalu néré namusúadacatáiseca úni íipidenéeri Siloé, yái manuíri yàaluca náiquéericaté cáli yèewiré. Píiba pituíwa úni iyú’, íimaca nulí. Yá nùacawa néré. Yá idécanáami nuíbaca nutuíwa, yá nuicáidaca —‍íimaca yái asìalica. ");
INSERT INTO pioNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Néese nasutáca néemìawani: —‍¿Alénásica yáara asìalica? —‍náimaca. Yá íimaca nalí: —‍Càmita núalíawa —‍íimaca. ");
INSERT INTO pioNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","14","Sábado yáté èerica, judíonái iyamáidacatáicawa Jesús yèewìadacaalíté cáli catuícaténá imànica matuíri. Iná abénaméeyéi wenàiwica natéca matuírimi fariseonái yàatalé. ");
INSERT INTO pioNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Néese fariseonái nasutáca néemìawa matuírimi cáná yéewaná iicáidaca. Yá íimaca nalí: —‍Idéca ipusúaca cáli nutuí íimami ìwali. Néese nuíbaca nutuíwa, yá nuicáidaca —‍íimaca. ");
INSERT INTO pioNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Néese abénaméeyéi fariseo náimaca irí: —‍Yáara asìali imàníirica cài càmita yéewa Dios néeséericani, íibaidacáiná sábado wayamáidacatáicawa, wía judíoca —‍náimaca. Quéwa áibanái fariseo náimaca: —‍Cabáyawanácaalítáni, néese càmita yéewa imàniquéi càmíirica wenàiwica idé imànicatá —‍náimaca. Iná càmita abédanama náiwitáise Jesús ìwali, níái fariseoca. ");
INSERT INTO pioNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Yá nasutáca néemìawa matuírimi àniwa. Yá náimaca irí: —‍¿Néeni pía? ¿Càiná píimaca ìwali yáara asìali catuírica imànica pía? —‍náimaca irí. Néese íimaca nalí: —‍Núumacué pirí profetacani, icàlidéerica tàacáisi Dios inùmalìcuíse —‍íimaca. ");
INSERT INTO pioNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Quéwa judío íiwacanánái càmita neebáida matuínáani, néese catuícani íná namàacaca matuírimi yàacawa náicha, néese namáidaca matuírimi isèenái. ");
INSERT INTO pioNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Nasutáca néemìawa matuírimi isèenái: —‍¿Pìirisica yáara asìalica? ¿Idésica imusúacawa matuíwaca? Néeni, ¿cáná yéewa catuí siùcanide? —‍náimaca. ");
INSERT INTO pioNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Néese isèenái náimaca nalí: —‍Wáalíacawa wàiriquéera. Wáalíaca nacáiwa imusúacatéwa matuíwaca. ");
INSERT INTO pioNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Quéwa càmita wáalíawa càinácaalí iyú yéewaná catuíca siùcanide. Càmita nacái wáalíawa cawinácaalí ichùnìa ituí. Pisutácué péemìawani. Béericáináni íná yáalimá icàlidacuéca piríni —‍náimaca. ");
INSERT INTO pioNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Càité isèenái náimaca, cáalucáiná naicáca judío íiwacanánái. Níái judío íiwacanánáica abédanamata náiwitáise náucacaténá wenàiwica judíonái yéewáidacàalu íicha, cawinácaalí icàlidéerica Jesús ìwali Mesíascani yái judío icuèrinápináca Dios ibànuèrica. ");
INSERT INTO pioNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Iná matuírimi isèenái náimaca: “Pisutácué péemìawani béericáináni”, cài náimaca. ");
INSERT INTO pioNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Néese judíonái namáidaca matuírimi àniwa. Náimaca irí: —‍Picàlida walí báisíiri iyúni Dios iicápiná. Wáalíacawa cabáyawanéerica yáara asìalica Jesús —‍náimaca. ");
INSERT INTO pioNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Néese íimaca nalí: —‍Càmita núalíawa ìwali cabáyawanéericasicani mabáyawanéericaalíni. Abéerita núalíawa báisíiri iyú matuíricaté núa quéwa siùcade catuíca núa —‍íimaca. ");
INSERT INTO pioNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Néese náimaca irí àniwa: —‍¿Càiná imàni pirí? ¿Càiná imàni ichùnìacaténá pituí? —‍náimaca. ");
INSERT INTO pioNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Yá íimaca nalí: —‍Nudéca nucàlidacuéca piríni, néese càmitacué peebáida. ¿Cánácué piwàwa nucàlidaca pirícué iináwaná ìwali àniwa? Cawàwanáta piwàwacué pìacawa yáapicha nacái yéewáidacalénáipiná —‍íimaca iicáaníca naquíniná. ");
INSERT INTO pioNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Néese nacuísaca náichawa matuírimi báawéeri iyú, yá náimaca irí: —‍¡Píacata yáara asìali yéewáidacaléca meedá! Wía quéwa, profeta Moisés yéewáidacaléca wía. ");
INSERT INTO pioNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Wáalíacawa Dios itàaníca Moisés yáapicha bàaluité, quéwa càmita wáalíawa síisáanéericaalí yáara Jesúsca, cawinácaalí íiwitáise iyú nacái imàni wawàsi, íná càmita yéewa idé yàanàaca Dios néese —‍náimaca. ");
INSERT INTO pioNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Néese yái matuírimi íimaca nalí, iicáaníca naquíniná: —‍¡Yée, caná