﻿USE sofia;
DROP TABLE IF EXISTS sofia.pibNT_vpl;
CREATE TABLE pibNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES pibNT_vpl WRITE;
INSERT INTO pibNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Tyenwa rushpakinri Geso Kristopirana. Tawiklopishni Geso, ga wa Gawraklopishni Tawi. ");
INSERT INTO pibNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Gawra wugenetlu Gisaaka. Gisaaka wugenetlu Gakowo. Gakowo wugenetna Gota ga wa gimolene. ");
INSERT INTO pibNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Gota Tamara wugenetyana Pare ga wa Sara. Pare wugenetlu Gesromo. Gesromo wugenetlu Gara. ");
INSERT INTO pibNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Gara wugenetlu Gaminata. Gaminata wugenetlu Naasoni. Naasoni wugenetlu Salmo. ");
INSERT INTO pibNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmo Racha wugenetyalu Poosi. Poosi Rota wugenetyalu Gowe. Gowe wugenetlu Gesi. ");
INSERT INTO pibNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Gesi wugenetlu pogirchi Tawi. Pogirchi Tawi, wa Goriyasu ganunronanni wugenetyalu Salomo. ");
INSERT INTO pibNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomo wugenetlu Rowowa. Rowowa wugenetlu Gawi. Gawi wugenetlu Gasa. ");
INSERT INTO pibNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Gasa wugenetlu Gosapata. Gosapata wugenetlu Gora. Gora wugenetlu Gosuya. ");
INSERT INTO pibNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Gosuya wugenetlu Gowata. Gowata wugenetlu Gacha. Gacha wugenetlu Gesechi. ");
INSERT INTO pibNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Gesechi wugenetlu Manasese. Manasese wugenetlu Gamonu. Gamonu wugenetlu Gosiyasu. ");
INSERT INTO pibNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Gosiyasu wugenetna Gechoni ga wa gimolene, gajriikaklugogne, wa Wawilonya yinitkana. ");
INSERT INTO pibNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Gajrikapkalunenanu Wawilonya satokyatkana. Gechoni wugenetlu Salatili. Salatili wugenetlu Sorowawili. ");
INSERT INTO pibNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Sorowawili wugenetlu Gawiyo. Gawiyo wugenetlu Geliyachi. Geliyachi wugenetlu Gasoro. ");
INSERT INTO pibNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Gasoro wugenetlu Satose. Satose wugenetlu Gachimi. Gachimi wugenetlu Giliyo. ");
INSERT INTO pibNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Giliyo wugenetlu Geleyasa. Geleyasa wugenetlu Matana. Matana wugenetlu Gakowo. ");
INSERT INTO pibNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Gakowo wugenetlu Gosi, Mariya gnuru. Wala rushpakya Geso, wa Kristo chinkaluru. ");
INSERT INTO pibNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Giyagni wane pejnuklopisha gwashle, Gawrakluyakawa ga wa Tawiklupotunanuko, pamole gepkoxamkoje gwashlu. Tawikluyakawa ga wa Wawilonya yinriklupotunanuko pamole gepkoxamkoje gwashlu. Wa Wawilonya yinrikluyakawa ga wa Kristoklupotunanuko, pamole gepkoxamkoje gwashlu wane. ");
INSERT INTO pibNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Wane rixa gishpakleta Geso Kristo. Wa runro Mariya, Gosi galuka gnunrotletinitkalo, mawakanuwalo, tetkatka kamshiro tixinritka Giwekikaluru Kpashiri chinanu. ");
INSERT INTO pibNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Ga wa tganurupa Gosi, gi rixanu poyagkakachrini gi raluka pogitlepiranatlo, rushinika giknoklemtlo pochkeruko. ");
INSERT INTO pibNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Yanshinikanyeginatinri, Gitsrukaachitowreru gipgujewnayegitlu rupnawleya. Wane chinru, “Gosi, Tawiklopisha, gi pika gwaletanro pganunropa Mariya. Gi rixanu wala gwiyachri Giwekikaluru Kpashiri chinanni. ");
INSERT INTO pibNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Tushpakawgenetanu toturu. Geso pgiwakatanru. Gi rixanu Wale gognetkakanna rayinerutene mukochireyna.” ");
INSERT INTO pibNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Pejnuruko tye wane gixka poyagkakikolupa Gitsrukaachi tokanu, tokanchi geneklewatachriya. Wane china: ");
INSERT INTO pibNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Waneplo sato makloji mapnokatowa kamshiropni. Toturu tushpakawgenetanu. Rutakgiwakatanruna Gemanwuru. Walenwa yokaakaluru: Wixaymalu Goyakalu. ");
INSERT INTO pibNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Yotunotinitka rumkanatinriya, wane rixatka Gitsrukaachi towreru towtapyawakatkalu. Rawatkalo ganunro. ");
INSERT INTO pibNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Gi wa retawalo tushpakawgenetinpotunanuko muchinanu toturu. Giwakatlu Geso. ");
INSERT INTO pibNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Wane rixa. Wetle Pokchi Gotechijne rushpakini Geso, wa pogirchi Giroreklu, kgimatkalerune tkachi gishpatyawaka sreta runyana. Gerosale rapokna. ");
INSERT INTO pibNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Wane chinna, “¿Ginaklu wa Goteyone Pogire gishpakachritka? Gi rixanu tkachi gishpatyawaka sreta wetyalo katagirite. Wuna wyoptsojityentapyaplu.” ");
INSERT INTO pibNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Pogirchi Girore jempiranyegitinitkalu, kojwakanshinikanuta, pejnuruneko Gerosale gajeneymananuko. ");
INSERT INTO pibNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Rapatna pejnuruneko tsrukakalune sasertotene ga wa yonchikgapine yinenu. Repomgana ginaka rushpakini Kristopa. ");
INSERT INTO pibNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Wanna wane china, “Wetle, Gotechijne. Gi rixanu wane chinyongatka tokanchi geneklewatachriya: ");
INSERT INTO pibNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Ga wa pixa, Wetle Pokchi, Gotachijne, Galikakni gi wa mturpotyi, Gota gitsrukatene getanu, Gi rixanu pixa yegi rushpakini Gitsrukaachi. Wale girukotanna nayinerutene Gisrayiline.” ");
INSERT INTO pibNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Giyagni Girore pochkeruko tomgana wa kgimatkalerune. Repomsapotutna tegipgujewnalgognetka katagiri. ");
INSERT INTO pibNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Wetle yokanatna. Wane china, “Gajewa. Gepomsapotutanna wa mturu pirana. Wa gikshikiniplu ginkakapanno, gita koxa yoptsojityentapyaplu.” ");
INSERT INTO pibNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Pogirchi yijnakotinitkana, yatkana. Waneklu katagiri wa tkachi gishpatyawaka sreta retinrona, kosekananumtna, tapokinpotuko; mturu gwiyawaka ginaple tutuka. ");
INSERT INTO pibNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Retinitkalona katagiri, rumuwatna. Rumuwpotutna. ");
INSERT INTO pibNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Jiglokapjimtatkana, retluna mturu runroyegi, Mariya. Yoptsojityegitatkaluna. Kotpukatkalona ponikowatinrina yegi. Ranikyegitatkaluna genekashlukaka: kori ga wa pgamlupagiri yochpiikalurupa, ga wa mirmunga. ");
INSERT INTO pibNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Yokanatkana rupnawleyna Girore yegi ma satokinitpatkana, gichijnena yatkana. Pagapoko yapamtatkana. ");
INSERT INTO pibNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Yinitkana kgimatkalerune, Gitsrukaachi towreru gipgujewnagipnayegitlu Gosi. Wane chinru, “Palnanutka. Panikanutkalu mturu ga wa runro. Pasukanutka. Gigipto pyanutka. Wane pwanatanutka wane nchininpotukyi Gita. Gi rixanu Giroremka gijganru mturu ruylatyaplu.” ");
INSERT INTO pibNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Yotunotinitka wale, goyechno ranikatkalu mturu ga wa runro. Gigipto yatka. ");
INSERT INTO pibNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Rupninipotunanuko Girore wane rawa, poyagkakikolupa Gitsrukaachi tokanu wa tokanchi geneklewatachriya. Wane china: Gigipto ntomgiylu Noturu. ");
INSERT INTO pibNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Giyagni Girore getnawa gapnokatkaluru kgimatkaleruneya, rumtuwnapotuta. Ruylajixanna pejnurunniko mturunni Wetle gwachinni ga wa psolu sretako wale sreta gwachinni, gepi walapuyegirunni, wanepnute mturunpotni walegognepotuko rixa jemletyawakna kgimatkalerune. ");
INSERT INTO pibNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Giyagni poyagkaakatka tokanchi geneklewatachri Geremiya tokanu. Wane china: ");
INSERT INTO pibNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Ramachijne jemika tsru wamonchi: chiyaglu, saplewjekteru. Rache twugenenni tuchiyagata. Gi taluka gimnanuukota, gi rixanu maleshanatkana. ");
INSERT INTO pibNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Ga wa rupnininatka Girorni, Gitsrukaachi towreru gipgujewnagipnayegitatnaklu Gosi Gigiptoya. ");
INSERT INTO pibNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Wane chinru, “Puyokanutka. Panikanutkalu mturu ga wa runro, ga wa Gisrayilinchijne pyanutka. Gi rixanu rupnanatkana mturu galuka giylaletachinni.” ");
INSERT INTO pibNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Giyagni yotunomtatka. Ranikatkalu mturu ga wa runro. Gisrayilichijne yatka. ");
INSERT INTO pibNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Giyagni Gosi yijnakyegitlu Garchelawo pogirewatinritka Goteya, rurni Girorni kashriglutka, pika wane yaleta. Yokangipnatkatka. Kalilesreta yatka. ");
INSERT INTO pibNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Wane yatka. Pokchi rawatka, Nasare chinkaluru, poyagkakikolupa tokanchi geneklewatachri tokanu: Nasare gajeru chinikolupa. ");
INSERT INTO pibNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Walegognekaka runa Gwa Katlewakleru. Gotechijne yineru mwiyawakanu runkaklewatya. ");
INSERT INTO pibNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Wane china, “Genshinikanutanu, gi rixanu tengogne pogirewatyawaka gi gowukatka. ");
INSERT INTO pibNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Gi rixanu tyenwa runkakyegitanru tokanchi geneklewatachri Gisayiya. Wane china: Yineru mwiyawakanu pogimewatya tokanchi: Galpokotanru Gitsrukaachi gatnugapote; Mpotukatanru gigapkaka.” ");
INSERT INTO pibNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Kameyopixi kamrutikaluru rutaka Gwa. Pamta gipchiji rushrika. Ga wa tsetskaka nikjeta. Ga wa wrolga gosha gajero rura. ");
INSERT INTO pibNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Giyagni yayegitluna Gerosale gajene, ga wa pejnuruneko Gote gajene, ga wa pejnuruneko Gortagasreta gajene. ");
INSERT INTO pibNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Gortagapga katikna waleya. Rupgujtamukochiretnawana. ");
INSERT INTO pibNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Gixo Gwariseyone ga wa Sariseyone retinitka Gwa katlewatyawaka ginachine, wane chinna, “¡Gimnu pixkalungi! ¿Katu yimakgi gasukyegityawaklu jgekanchipa? ");
INSERT INTO pibNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Giyagni genshinikanuwlu kamrure gkamruretpotutanu. ");
INSERT INTO pibNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Gi gkagwaka wane chinkakletinwa, ‘Waneywu wutsrukatni Gawrani.’ Gi rixanu gita wane chingi, Goyakalu gimkata gipgujewnakakletanna Gawraklopishanemka tyekaka sotlukakaya. ");
INSERT INTO pibNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Gagmunasko rapokatka gepchi. Pejnuruko gagmuna kiglejiru mwanutu kayiikalurupni. Xirnachri ruknookona.” ");
INSERT INTO pibNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Wane koxa china Gwa, “Gita galikakni katgi gonuya genshinikanutinri chinanu. Ga wa najxigi ginachri gita pnute muchkonurutu. Gi wa gita gimukluni nanikyaplu yoshmaklejixi. Wale katangi Giwekikaluru Kpashiriya ga wa xirnachriya. ");
INSERT INTO pibNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ruplokapre kashicha. Powratpotutanru giylakaajetikowaka. Rapatjetanru trikneji rumretyawakaplu, ga wa yoxikanru gichicha xirniyawaka gike rixiniko muwnakatupa.” ");
INSERT INTO pibNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Giyagni Kalile runyatka Geso. Gorta gapga Gwa yegi ya, wale katyaplu. ");
INSERT INTO pibNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Seyni Gwa gaalipotutmaklu. Wane china, “Gita gimkata katkota Pixaya, ¿ga wa Pixa ginyegitno nkatyapyi?” ");
INSERT INTO pibNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Giyagni rugita Geso. Wane chinru, “Puchichanno xani. Gi rixanu kigleru wane wixinri, psolpotuyako wpoyagkaklewatinripa.” Waneklu rugitatkalu. ");
INSERT INTO pibNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Giyagni rali katkoklunutka Geso, waneklu gonu rushpakyatka. Retlu tengogne gitpukachri ga wa Giwekikaluru Goyakalunu gijrukachri motkoko pixka. Rapyegitatkalu. ");
INSERT INTO pibNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Waneklu satu tokanchi tengogneya, wane china, “Tyenwa Noturu nushinikanru potu. Wale giglenshinikanutno.” ");
INSERT INTO pibNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Giyagni yineru mwiyawakanu Giwekikaluru ganiklu Geso, yantaletikolupa tsru kamchiya. ");
INSERT INTO pibNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Geso, rali gogajirewatinitka gepkoxamkojmolegogne ga wa gepkoxamkojmoleyechno, wanepnute nachlu. ");
INSERT INTO pibNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Rapyegitinitkalu kyantaletlewakleru, wane chinru, “Goyakalu Wgene pixinipa, wane pchinanru tye sotlukaka jimapro rixinwa.” ");
INSERT INTO pibNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Seyni Wale gigita. Wane china, “Wane chinayongayegitkalurutkani: Gi wa niikalurupje ruwekya yineru, Seyni pejnuruko tokanchi Goyakalu chinyawaka.” ");
INSERT INTO pibNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Giyagni tsru kamchi kpashiri pokchi raniklu. Kpashiwakapji gwachri tenoptaji potu rutaklu. ");
INSERT INTO pibNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Wane chinru, “Goyakalu Wgene pixinipa, gewi pakaxikamtini. Gi rixanu wane chinayongayegitkalurutkani: Gitowrene towutanu Pixa chinanu. Kashichanyina gimyoyna, gi pagogneko sotlu putspejixitinripa.” ");
INSERT INTO pibNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Geso wane chinru, “Wanekoxa chinyongayegitkalurutkani: Gi pyantaletanru Gitsrukaachi Poyakalute.” ");
INSERT INTO pibNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Magka tenolu potu ranikatnaklu tsru kamchi. Psolchijiko rekakgityalu pejnuruko pogirewatyawaakaka ga wa ruglenkaka. ");
INSERT INTO pibNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Wane chinru, “Pejnuruko tyekaka nenekanyi pyoptsojityegitinipno.” ");
INSERT INTO pibNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Giyagni Geso wane chinru, “Pyanutka, Satanasyo. Gi rixanu wane chinayongayegitkalurutkani: Gitsrukaachi Poyakalute pyoptsojityegitanu. Walepje pyonogyegitanu.” ");
INSERT INTO pibNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Giyagni tsru kamchi giknokamtatkalu. Goyakalutowrerune yayegitatkalu. Rupxakatkaluna. ");
INSERT INTO pibNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Geso yijnakotatka Gwa samyookatka. Satokatka. Kalile yatka. ");
INSERT INTO pibNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ruknokamtatkalu Nasare. Kapernawo yatka. Wane rawatka, tsru wenuspuwnaga gwachri pokchi, Sapolonosreta ga wa Neptalisreta, ");
INSERT INTO pibNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","poyagkakikolupa tokanchi geneklewatachri Gisayiya tokanu chinyawaka: ");
INSERT INTO pibNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Sapolonchijne ga wa Neptalchijne gajene, tsru wengapo, Gorta wakanute, Kalile payinchijne, ");
INSERT INTO pibNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Yine mapshagawaka tuplatachine Retluna tsru pokamlalu. Gipnalusreta, gipnalchikle tuplatachine pokamlalu gipgujewnayegitna. ");
INSERT INTO pibNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Wanekluyakawa yinuwaka ginkaklewleta Geso. Wane china, “Genshinikanutanu, gi rixanu tengogne pogirewatyawaka gi gowukatkalu.” ");
INSERT INTO pibNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Kalile Wennespuwnaga yapanata Geso. Retna gepi moletkakachine: Simo, Petro giwakatletachri, ga wa repuru Gantirishi. Tsru wenu chaluganatna gi rixanu kshimagaklerunni. ");
INSERT INTO pibNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Wane chinna, “Tekali. Gwagajxigitanno. Yine gwapjetachine nixkakanutkagi.” ");
INSERT INTO pibNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Waneklu rutakamtatkaluna chalnekakna. Romkagitatkaluna. ");
INSERT INTO pibNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Wane yapamtna. Wane retyana pimrine gepi moletkakachine, Sewereyo wgenene: Santiyako ga wa repuru Gwa. Kanawa rawanatna, ruruymana Sewereyo. Ramtanatluna chalnena. Wane tomgiyna. ");
INSERT INTO pibNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Waneklu ruknokamtatkalona kanawa. Ga wa rurna ruknokamtna. Geso romkagitatkana. ");
INSERT INTO pibNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Psoluko Kalile yapamta Geso. Runkaklewawaklepjikakayna runkaklewatya. Kiglerpotunanu Tokanchi runkakleta pogirewatyawakapirana. Pejnuruko yayixlu ga wa pejnuruko gagijewnalu Wale gituukakyana yine. ");
INSERT INTO pibNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Psoluko Suri poshalpiranamta. Ranikyegitluna pejnuruneko yayixachine, pnumnu gixa yayixletachine, salewnachine, ga wa kamchichachine, ga wa popukalerune, ga wa giktegachine. Rutuukakna. ");
INSERT INTO pibNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Gixoluru yineru gomkagitlu, Kalile gajene, ga wa Ntekapoli gajene, ga wa Gerosale gajene, ga wa Gota gajene, ga wa Gorta wakanute gajene. ");
INSERT INTO pibNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Gixolune yine reta. Magka kanika. Tuplata. Yayegitluna yimaklene. ");
INSERT INTO pibNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Yinuwaka yanumsaleta. Runkaklewyegitna. Wane china: ");
INSERT INTO pibNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Giglenshinikanyegitkalunni kwamonurune Goyakalu munangachine, gi rixanu wannani tengogne pogirewatyawaka. ");
INSERT INTO pibNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Giglenshinikanyegitkalunni wamonuwatachine, gi rixanu gimnanuukalunepni. ");
INSERT INTO pibNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Giglenshinikanyegitkalunni mayogone, gi rixanu wanna yoptotanru psolchijneko. ");
INSERT INTO pibNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Giglenshinikanyegitkalunni nachgimane poyagkaklewluya, ga wa gonunnagatewatachine poyagkaklewluya, gi rixanu wannanwa jinanurunepa. ");
INSERT INTO pibNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Giglenshinikanyegitkalunni kgetwamonrerune gi rixanu getwamonutkalunepni wanna. ");
INSERT INTO pibNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Giglenshinikanyegitkalunni powragajirune, gi rixanu wanna getanru Goyakalu. ");
INSERT INTO pibNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Giglenshinikanyegitkalunni maluukakane gipoyikgayegkakachine, gi rixanu wanna Goyakalu wgenene chinkona. ");
INSERT INTO pibNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Giglenshinikanyegitkalunni kojwakjetkalune poyagkaklewlena chinanu, gi rixanu wannanni tengogne pogirewatyawaka. ");
INSERT INTO pibNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Giglenshinikanyegitkalungi yangingina, kojwakingina, psolpotuyako rektutetingina Gita chinanu, rayloklewashatinrina. ");
INSERT INTO pibNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Gimuwatanu. Gimjikpotutanu, gi rixanu tsrupotupni gwenutikolupa tengogneya, gi rixanu wane rixa kojwaakotnina tokanchi geneklewatachinni muchinanu gwachinni gixaya. ");
INSERT INTO pibNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Gixni wa tye psolchijneko tuwnegi. Gi wa mro rixinitka tuwu, ¿klu tuwutka? Gike kigleyatkalu, seyni maleka ruknokanruna yineya rakatooko. ");
INSERT INTO pibNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Gixni wa pokamlalu tye psolchijneko pokamlachijnetachingi. Magka rogote gwachri pokchi gi rumkata yogimatkota. ");
INSERT INTO pibNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Ga wa yineru gikoxa yochpiklo katalo ga wa gimatumpuko rutaklo, seyni wa katalo kgapi tutaako, pejnuruneko panchi gwachine tpokamlatyegitinripa. ");
INSERT INTO pibNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Giyagni wane gixa pokamlatletanu yine getanuya, reta kamruretyapgina kigleru rixinri gkamrure, rumalwutyapluna gixa Giru tengogne Gajeru. ");
INSERT INTO pibNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Gi gkagwakanru wa nuninri nuknokapyaplu Tokanchi Yokanatkaluru, gi wa tokanchi geneklewatachine kirukateko. Gi wa nuna nuknokyaplu, seyni npoyagkakyaplu. ");
INSERT INTO pibNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Gi rixanu galikakni wane nchingi, Nikawninpotunanuko tengogne ga wa tye chiji, gi pajina, gi satuna yotmokle nikawninri Tokanchi Yokanatkaluruya, pejnurpotunanuko ma mixkanuwpotunanuko. ");
INSERT INTO pibNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Giyagni gi gixachrikokta kaspukiniplu satu tye yokanru mtserutu potu ga wa yimakna yine ma kamrutyanupluna tye mtserutu potu yokanru, walepni mturu potu chinkona tengogne pogirewatyawakaya. Seyni gi gixachrikokta kamrutlu ga wa wane rixa yimakletna yine, walepni wa tsru chinko tengogne pogirewatyawakaya. ");
INSERT INTO pibNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Gi rixanu wane nchingi, mpoyagkaklewle tsru ma mixkanupa yonchikgapine poyagkaklewle ga wa Gwariseyone poyagkaklewle pnute, gi gapokanuna tengogne pogirewatyawaka.” ");
INSERT INTO pibNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Wane china, “Gixa yijnakotlu wa tsrunni wane chinikowaka, ‘Gi puylatanru yineru,’ ga wa ‘Girukokta giylatlu yineru rumkata giklukanuwnayegjixkota.’ ");
INSERT INTO pibNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ga wa Gita wane chingi, girukokta gimtuwnayegitlu gimole maleshawaka rumkata giklukanuwnayegjixkota. Girukokta wane chininri gimole, ‘Manshinikanutyi,’ jemanshinikankakjetikowaka rumkata ganikletlu tsrukakalune. Girukokta wane chininri, ‘Seprolokachriyi,’ rumkata Gigena xirnachri yaleta. ");
INSERT INTO pibNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Giyagni panikinri penekashle Goyakalu getanu, ga wa wane pushinkapinri pumole pwamontakinri, wane pixanu: ");
INSERT INTO pibNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Genekashjetikowakakwa ginaple putkapanru penekashle. Gajewa. Muchinanu gapka pumatletapanutkalu pumole. Waneklu wane pyanutka. Putakanru penekashle. ");
INSERT INTO pibNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Giyampotu pumatletanutkalu payegixjeru gatnugapo puyapinikopshinri, ma samyookanpakyi payegixjeru wa kgiklukanuwnayegjixlewakleru yegi. Ga wa kgiklukanuwnayegjixlewakleru ma samyookanpakyi gitowereru yegi, yoshmakjetikowaka pma yoshmakikotupa. ");
INSERT INTO pibNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Galikakni wane nchinyi, gi wane pushpakini pma wenutkanuwalo talipre mchataajpotunanuko.” ");
INSERT INTO pibNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Geso gomkagi wane chinretna, “Gixa yijnakotlu wa tsrunni chinikowaka: Gi pumopatlewatanu. ");
INSERT INTO pibNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Gita wane chingi, katukokta sato suxo getini, retsotanutinro, rumopatlewatatka walaya rajiya. ");
INSERT INTO pibNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","“Giyagni wa potukleygale mukochirewkakinipyi, pkoshpakanru. Puknokanru pixyegiya. Gi rixanu kigleyyi pixinripa satupje pumane psojite pamginri, psolumaneko Gigena xirnachri pma muknokikotupa. ");
INSERT INTO pibNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ga wa potuklemyo mukochirewkakinipyi pustakanru. Puknokanru pixyegiya. Gi rixanu kigleyyi pixinripa satupje pumane psojite pamginri, psolmaneko Gigena xirnachri pma mamginitipa.” ");
INSERT INTO pibNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Wane chinna, “Girukokta giknokagnunrota, renekanro kiruka ma ganunrotyanpatkalo. ");
INSERT INTO pibNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ga wa Gita wane chingi: Girukokta giknokagnunrota gapoklewlumigjeya, gimopatlewatachro rixkakanro. Ga wa girukokta gnunrotlo giknookaluro, rumopatlewatatka. ");
INSERT INTO pibNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Gyijnakotatnaklu wa tsrunni wane chinikowaka: Gi wa maleshawaka Goyakalu kawchinanu pchinanu. Poyagkakanru Gitsrukaachi chinanu, wa pupiratanru Wale kawchinanu pchinre. ");
INSERT INTO pibNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ga wa Gita wane chingi, giketsotaji Wale kawchinanu nchinanu: gi wa tengogne kawchinanuko, gi rixanu walenwa Goyakalu tuplapijere; ");
INSERT INTO pibNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","gi wa chijiko, gi rixanu rutspanjixgapreni; gi wa Gerosale kawchinanuko, gi rixanu tsru Pogirchi pokchini; ");
INSERT INTO pibNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","gi pujiwu kawchinanuko, gi rixanu gi pumkata klatalu gixkakletlu pajiwutsapje, gi ksajiruko. ");
INSERT INTO pibNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Wane nchintokanutanu, gigi: ‘Gigi;’ gike: ‘Gike.’ Gi rixanu wanepnutetka mugletu ruyakatyatka wale. ");
INSERT INTO pibNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Gyijnakotlu wane chinikowaka, ‘Ygalchi, ygalchi chinanu. Ygichi, ygichi chinanu.’ ");
INSERT INTO pibNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ga wa Gita wane chingi, gi psatkakyegitanru mugletu, seyni gi gixachrikokta giptagojityi potuklesretgoji, pasretgoji koxa puprotakgojyegitanru. ");
INSERT INTO pibNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Paluka jigyegletjeru kgiklukanuwnayegjixlewakleru yegi, paluka gwamkaletjeru puchichankoxlu pumkaluchrata. ");
INSERT INTO pibNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Gi gixachrikokta yakakinyi gepi kilometro waleyma pyinripa, gepkoxamkoje kilometro pyanu waleyma. ");
INSERT INTO pibNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Penekanru pagjitjeru. Girukokta galuka ganikleshatyayi, gi paalixanru. ");
INSERT INTO pibNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Gyijnakpiranatlu wane chinikowaka, ‘Pushinikanru pumwastsitanru ga wa payegixanru pkamnixjeru.’ ");
INSERT INTO pibNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ga wa Gita wane chingi, gishinikanna gkamnixjene. Gagjitanru ruglenshinikanyegitikolupna gkamakpirjetjene. Kigle getle gixanna gayegixjene. Gagjigogneyegitanna gyenetjene ga wa gkojwakjene, ");
INSERT INTO pibNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","tengogne Gajeru Giru wgenene gixinripa. Gi rixanu Wale gishpakaklu tkachite muglene chinanu ga wa kiglerune chinanu. Gina rixyegitna poyagkakachine ga wa mpoyagkaakane koxa. ");
INSERT INTO pibNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Gi rixanu gishinikinipna wa gishinikjene, ¿klu gimapnutko? ¿Gi ge waneko pixka rixna gijgawenutachine? ");
INSERT INTO pibNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ga wa gimolenepje galukini, ¿klu gkamruta gixa pimrine pnute? ¿Gi ge waneko pixka rixkoxna payineko? ");
INSERT INTO pibNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Giyagni mmagatikanepgi, gixa Giru pixka tengogne Gajeru mmagatikatni.” ");
INSERT INTO pibNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Geso gomkagi wane chinretna, “Ggirukotinwa yine getanuya. Gi wa poyagkakachinepgi wanna getyapgi. Wane gixini, gi wa rapnutanungi Giru tengogne Gajeru. ");
INSERT INTO pibNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Giyagni petwamonrewle penekashlewatinipa, gi wa pkowjixanu pixa penute, wa sanowashatachine pixka kowjixjetna ginkaklewakapjikakaya ga wa gatnugapkakaya, yine gimalwutyapna. Galikakni wane nchingi rapnutkatkana. ");
INSERT INTO pibNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Wa petwamonrewle peneklewashatini, gi wa pkegnetesretatemyoko gimatanru wa potuklesretatemyo pkamrutinri, ");
INSERT INTO pibNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","wa yogimatikowaka penekashlewatinripa. Ga wa Puru, yogimatikowaka getyachri, pgujewaka rapnutinyi. ");
INSERT INTO pibNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Wa gagjigognetini gi wa sanowashatachine pixka gixanu. Gi rixanu wanna galuka gagjigognereta tunwatachine ginkaklewakapjikakaya ga wa gipututsojriykaka, wa yine getyapna. Galikakni wane nchingi, rapnutkatkana. ");
INSERT INTO pibNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ga wa pixa gagjigognetini, pjiglokanu pugruko. Pushyatanru pupgyaptote. Pagjitanru Puru yogimatikowaka gwachri. Ga wa Puru yogimatikowaka getyachri pgujewaka rapnutinyi. ");
INSERT INTO pibNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Gagjigognetini gi wa goyanumsaleshatachinepgi payine pixka. Gi rixanu wanna kagwaklu gixo tokanchiya yijnakotikolupna. ");
INSERT INTO pibNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Gi wa wanna pixka gixanu gixa. Gi rixanu gixa Giru gimata kluneru gmagatya gma magjitkanuwalu. ");
INSERT INTO pibNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","“Wane gixa gagjigogneretanu: Wuru, tengogne Gajeru, gipashichgiwakatkalurupyi. ");
INSERT INTO pibNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Runanutka Pixa pogirewatyawaka. Pixa galukyawaka wane gixkalurupni; tengogneko pixka rixko tyechijne. ");
INSERT INTO pibNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Penekanwu xawakni wnikanrupa tyegogne chinanupa. ");
INSERT INTO pibNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Pkaspukinwu wmukochire wixa pixka wkaspukyana pnu wixjene. ");
INSERT INTO pibNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Gi wa yantaletikowakako putakanwu, seyni pushatkapanunwu galikaka mugletuya. ");
INSERT INTO pibNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Gi rixanu gixa kaspukinna yine pnu gixjene, Giru tengogne gajeru, kaspukinkoxgi gixa. ");
INSERT INTO pibNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Seyni gma kaspukinna yine pnu gixjene, Giru koxa gi kaspukmukochiretanungi.” ");
INSERT INTO pibNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Geso gomkagi wane chinretna, “Wa gogajirewatinipa gi wa sanowashatachine pixka gixgojitanu wamonuwnagojitachine. Gi rixanu gektu rixgojitnawana wa yine getyapna gogajirewatachine gixyawakako. Galikakni wane nchingi rapnutkatkana. ");
INSERT INTO pibNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Ga wa pixa gogajirewatinipa, ringi psagjiwutanu, ga wa perkagojitanu. ");
INSERT INTO pibNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Pma metikotupa yine yegi wa pogajirewatinri, seyni Puru yegi yogimatikowaka gwachri. Ga wa Puru yogimatikowaka getyachri pgujewaka rapnutinyi. ");
INSERT INTO pibNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Gi wa tye chiji mponikowatini, wa kochopa ga wa puchowlu gimtukyawaka, ga wa kachowguru kotamgiyawaka, chowguwatinripa. ");
INSERT INTO pibNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Seyni tengogne mponikowatini galikaka, mumtuklewatikowaka gi wa kochopako, gi wa puchowluko, mkotamgikowakanu kachowguru, mchowguwatikowakanu. ");
INSERT INTO pibNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Gi rixanu ginakaktaplu mponikowle wanekoxaplu gaji. ");
INSERT INTO pibNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Wumane katalote walenwa wuygale. Giyagni potukaygale pixinipa, psoluko pumane pokamlapa. ");
INSERT INTO pibNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Seyni puygale mugletu rixinipa, psoluko pumane mapshagalupni. Giyagni pokamlalu pumane gwachri mapshagalu rixini, ¡gi pamapshagnunanuktalu! ");
INSERT INTO pibNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Gi satuna gimkata wayegrechri gixleta gepi gitsrukaachine yegi. Gi rixanu waka rayegixanru satu, satu rushinikanu. Waka satu rupxaletanu, satu reyikanu. Gi gimkata gipxaletletlu Goyakalu ga wa ponikowlu. ");
INSERT INTO pibNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Giyagni wane nchingi, gi gkojwakanshinikanutinwa giwekinriya, klu gnikanuna ga wa klu giranuna. Gi koxa gimaneya, klu gmakatanu. ¿Gi ge tsrupotni giwekinri niikaluru pnute, ga wa manchi gitaakaluru pnute? ");
INSERT INTO pibNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Getpotutanna tengogne yapachine koshichine mutaklewatkanni. Gi jirgana. Gi rawluna wa gignantakjetikwakaya. Ga wa Giru tengogne Gajeru goglutna. ¿Gi ge kiglepotgi gixa wanna pnute? ");
INSERT INTO pibNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","¿Katu gixa gimkata yognikletlu giwekinriya pshinitsonuji gkojwakanshinkanrewleya? ");
INSERT INTO pibNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“¿Klu koxa gkojwakanshinikanutnawa gmakatanruya? Getjetanru kagwuru chiji gajeru, gi rixpoko tseruwnaleta. Gi kamrurewpotuta. Gi jiweta. ");
INSERT INTO pibNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Seyni wane nchingi gi wa Salomoko psolu pogirewleyako makawata satu tyegwukaka pixka. ");
INSERT INTO pibNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Ga wa Goyakalu wane gixa makatletinri kshana xawakni gwachri, yechikawa xirnachri ruknookonatka, ¿gi ge wale pnute makatangi gixa? Psotsotaji galixachingi. ");
INSERT INTO pibNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Giyagni gi wa gkojwakanshinikanutinwa, wane nchininri, ‘¿Klu wnikanuna? ¿Klu wuranuna? ¿Klu wutakanuna?’ ");
INSERT INTO pibNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Gi rixanu payine pejnuruko tyekaka rujgana. Ga wa Giru tengogne Gajeru gimatlu tyekaka pejnuruko galukanru. ");
INSERT INTO pibNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Seyni muchinanu gapka gijganru Goyakalu pogirewatyawaka, ga wa Wale poyagkaklewle. Pejnuruko tyekaka gyognikiko. ");
INSERT INTO pibNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Giyagni gi wa gkojwakanshinikanutinwa yechikawa chinanu. Gi rixanu waneplu kojwakanshinikanrewlu yechikawapa. Poyagotatka pagognekaka wa gektutu.” ");
INSERT INTO pibNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Geso gomkagi wane chinretna, “Gi wa ruklukanuwna nchinyegitanru satu, gma muklukanuwnayegjixikotupa. ");
INSERT INTO pibNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Gi rixanu gikta gixpoko giklukanuwnayegjixletna pimrine, waneko pixka gixa giklukanuwnayegjixkotanu gixa. Waneko pixka rixa: Wa yantapi gixa yantajetinri, walako gyantatiko. ");
INSERT INTO pibNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","“Ga wa waneko pixka rixatnaka. Wutakashatanru: Pixa getlu kapopejiru pumoleygale gwachri, ga wa ¿puygaleko gwachri kaknalu gi peta? ");
INSERT INTO pibNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Ga wa wane pchinanru pumole, ‘Gichikaka. Nwanruchi puygale gajeru kapopejiru.’ ¡Ga wa petanru pixako puygale gwachri kaknalu! ");
INSERT INTO pibNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","¡Sanowashatachriyi! Muchinanu gapka puknokanruchi kaknalu puygale gajeru. Waneklu petpotutanutkalu puknokyaplu pumoleygale gwachri kapopejiru. ");
INSERT INTO pibNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Gi wa kewene penekanru wa kpashiri. Gi giknokanru katajiroji perlaji gixanu kochine yegi, ma makatokyanupluna gijixiya, ma muprotkapyegityanupgi, ma suskatyanupgi. ");
INSERT INTO pibNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Gagjitanu ga wa geneeko. Gijganu ga wa gikshikanu. Giylaylagipgyaptotetanu, gkotpukyegitko. ");
INSERT INTO pibNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Gi rixanu girukokta gagjita, yoptota. Ga wa gijgachri rukshika. Ga wa giylaylagipgyaptotetachri kotpukyegitko. ");
INSERT INTO pibNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“Ga wa gixa, ¿giru jeji wa gituru gagjitinri jimapro, renekanru sotlu? ");
INSERT INTO pibNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ga wa shima ragjitini, ¿gimnurge renekanru? ");
INSERT INTO pibNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Giyagni wa gixa muglenmakgi gimata genekawgenreta kigleru genekashle, pnutlu Giru tengogne Gajeru kiglerkaka renekanna ragjitjene. ");
INSERT INTO pibNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Giyagni pejnurkakako gixa galukanru wa yine wane gixyapgi, waneko pixkapotuko gixankoxna wanna. Gi rixanu tyenwa tokanchi yokanatkaluru ga wa tokanchi geneklewatachine tokanu. ");
INSERT INTO pibNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Gjiglokanu mtsergipgyaptotetu. Gi rixanu tsru gipgyaptoteru, tsrugapolu wa gamgikowakgapo. Gi gepikanna walegapo jiglokachinena. ");
INSERT INTO pibNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Gi rixanu mtsergipgyaptotetu, mtsergapotni giweklugapo. Gi gixo gikshiklu.” ");
INSERT INTO pibNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Geso gomkagi wane chinretna, “Ggirukotinwa wannaya tokanchi geneklewatachine gixashatachine, ginyegitjene gowegane pixka gixamkatachine, seyni gitokoya kewetnane kmatsurune pixkalunni. ");
INSERT INTO pibNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Kamrurna gimatinna. ¿Kawshipirege jirgiylona gowaji? Ga wa ¿kawshisureruylege jirgiylona gikersagi? ");
INSERT INTO pibNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Wane rixa pejnuruko kigleru gagmuna, kiglejiwlerni. Seyni wa gektutu gagmuna muglejiwletni. ");
INSERT INTO pibNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Gi rumkata kigleru gagmuna muglenjiwleta. Gi koxa rumkata mugletu gagmuna kiglejiwleta. ");
INSERT INTO pibNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Pejnuruko gagmuna kiglejiru mwanutu kayiikalurni. Xirnachri ruknooka. ");
INSERT INTO pibNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Giyagni kamrurna gimatinna. ");
INSERT INTO pibNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Gi pejnuruneko ‘Gitsrukaachi, Gitsrukaachi’ nchinjene gapokanru tengogne pogirewatyawaka. Seyni Nuru tengogne Gajeru gishinikanru kamrutachri, jiglokanru. ");
INSERT INTO pibNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Walegognepa gi gepika wane chinanno, ‘Gitsrukaachi, Gitsrukaachi ¿gi ge tokanchi geneklewatachinwu Pixa giwakaya? ¿Gi ge pgiwakaya maleka wuknokna kamchine?’ ¿Gi ge pgiwaka wkamrutyalu gixo giyaklukaka? ");
INSERT INTO pibNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Giyagni nunkakpotutanna, ‘Gi pagogneko numatgi. Knanu gyanutka Gityegiya, mukochri kamruklerungi.’ ");
INSERT INTO pibNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Giyagni girukokta yijnakotlu tye ntokanu, ga wa wane rixlu, jeji kshinikanuru pixkalutu, sotlumta gogo kamrupjitachri. ");
INSERT INTO pibNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Gina gijruka. Rapogata. Kannipgyalu gajpopokannipgyata. Yantamuchkonupjitlu wale panchi. Gi wa yawna, gi rixanu sotlumta gogo poyegitanruni. ");
INSERT INTO pibNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Giyagni girukokta yijnakotlu tye ntokanu, gi wane rixa, jeji manshinikanutu pixkalutu, ksatu gogo kamrupjitachri. ");
INSERT INTO pibNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Gina gijruka. Rapogata. Kannipgyalu gajpopokannipgyata. Yantamuchkonupjitlu wale panchi. Yawnamtana. Tsru yawnalu rixana.” ");
INSERT INTO pibNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Wane rixa. Wa Geso tye tokanchi rali ginkakletinitka, wa gixolune yine giglajita runkakaklewleya. ");
INSERT INTO pibNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Gi rixanu tsru gitaakaluru pixka rixa ginkaklewleta. Gi wanna yonchikgapine pixka rixa. ");
INSERT INTO pibNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Magka yopikyatka. Gixolune yine gomkagitlu. ");
INSERT INTO pibNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Wane satu gijirgitutachri yayegityalu. Yoptsojityegitlu. Wane chinru, “Gitsrukaachi, palukiniplu pumkata powratletanunno.” ");
INSERT INTO pibNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Romyokyegitlu. Kamruklu. Wane china, “Naluklu powra pixinripa.” Waneklu rujirgitle rutukyatka. ");
INSERT INTO pibNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Geso wane chinru, “Petanu. Gike punkakanu. Seyni pyanu. Pekakgitinwa sasertote yegi. Penekanru genekashlu wa Moysisi yokanatanru. Walepni gipgujtalewlu wanna chinanu.” ");
INSERT INTO pibNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Kapernawo rapokinitka, satu ksolaloteru ginyegitlu. Ragjitlu. ");
INSERT INTO pibNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Wane china, “Gitsrukaachi, nopji ruklugana ntseruwakleni. Giktegachrina. Salewnachripotuna.” ");
INSERT INTO pibNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Wane china, “Wane nyanu Gita. Nutuukakapanru.” ");
INSERT INTO pibNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ksolaloteru gigita. Wane china, “Gitsrukaachi, gi numukluyi wa nopji washrempuko papokinripa. Seyni wane pchinatokanushatanu. Ntseruwakle gitukanutka. ");
INSERT INTO pibNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Gi rixanu gita koxa jejno tsru gitaakalune rapukote gwachrino. Gita koxa solalone gitakika. Wane nchinru wa tye, ‘Pyanutka.’ Yatka. Satu wane nchina, ‘Punanu.’ Runa. Wane nchinru nwayegreru, ‘Pkamrutanru wa tye.’ Kamrutlu.” ");
INSERT INTO pibNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Geso yijnakotinri, ruglajita. Wane chinna romkagitjene: “Galikaka wane nchingi, gi satuna Gisrayiline yegi nukshikyalu tye pixkalutu galixlewlu. ");
INSERT INTO pibNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Wane nchingi, runanna gixo tkachi gishpatyawakasreta gajene ga wa tkachi gimxityawakasreta gajene. Tengogne pogirewatyawaka tuplatanna Gawrayma, Gisaaka, ga wa Gakowoyma. ");
INSERT INTO pibNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Seyni wa pogirewatyawaka gwachinemka giknookalunenapni mapshagawaka maleka. Waneplu chiyaglu ga wa gashkaygitlu.” ");
INSERT INTO pibNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Geso wane chinru ksolaloteru, “Pyanutka. Palixyawakpotuko pkamrutikatka.” Rutuukakatka tseruwakle wanekluyakawa. ");
INSERT INTO pibNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Petropji ya Geso. Retlo Petro gimajiro. Tukluganatana, tpachwatana. ");
INSERT INTO pibNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Kamrukamyotlo. Tupachwalgatka. Tyotunomtatka. Wala gipxakatkalu. ");
INSERT INTO pibNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Kayi rixinitka ranikyegitluna gixo kamchichachine. Maleka ruknokna kamchine tokanuya. Rutuukakna pejnuruneko yayixachine, ");
INSERT INTO pibNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","poyagkakikolupa tokanchi geneklewatachri Gisayiya tokanu. Wane china: Waleko gwalu wugroklewle. Raniklu wyayixlekaka. ");
INSERT INTO pibNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Geso getna gixo yine Wale yegi. Yokanrewata wakanu yinripna. ");
INSERT INTO pibNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Satu yonchikgapri gapyegitlu. Wane chinru, “Yimaklewatachri, nomkagitanyi ginakakokta pyinipa.” ");
INSERT INTO pibNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Geso wane chinru, “Kewnechrone waneyna kapna. Ga wa koshichine tengogne yapachine waneyna rawyawakna. Ga wa Gita Yineru Wgenno maleshayno nutspanjiwutyawaka.” ");
INSERT INTO pibNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Satu yimakleru wane chinru, “Gitsrukaachi puchichanno muchinanu gapkachi wane nyanu, nuruchi gipnini, ga wa nkapnamtanu.” ");
INSERT INTO pibNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Geso wane chinru, “Pomkagitanno. Petashatanna gipnachine kapnaletanna wannanunekni gipnachine.” ");
INSERT INTO pibNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Kanawa ruptekatka. Yimaklene gomkagitlu. ");
INSERT INTO pibNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Waneklu tsru yowjereshpurga rixa tsru wenu. Wa kanawa tuygajetlo gishpurga. Seyni Wale gimkananumta. ");
INSERT INTO pibNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Yimaklene yayegitlu. Komyekluna. Wane chinruna, “¡Gitsrukaachi, pognetkakanwu! ¡Wamginripatka!” ");
INSERT INTO pibNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Wale wane chinna, “¿Klu chinanu pikachingi? Psotsotaji galixachingi.” Giyagni yotunota. Chigetjetlu kannipgyalu ga wa tsru wenu. Tsru mayegixgalu rixatka. ");
INSERT INTO pibNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Giyagni jejine giglajita. Wane chinna, “¿Gi gixachri jejnige wa tye? Wa kannipgyalu ga wa tsru wenu yijnakotanru.” ");
INSERT INTO pibNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Wakanu rapoka Gergesenonesreta. Yoptotapluna gepi kamchichachine, yomlechi yegi ginyachine. Kmatsurunpotni. Wane rixkalchinanna gike gimkata giknoglegapotlu walegapo. ");
INSERT INTO pibNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Wane saplewatyana. Wane chinna, “¿Gi rixwu wixa ga wa pixa, Geso, Goyakalu Wgene? ¿Punge gewi psaletpotutyapwu ma mapookanuwa gipapko?” ");
INSERT INTO pibNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Gowukako rawanatikna gixo kochine. Nikanatna. ");
INSERT INTO pibNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Ga wa kamchine ragjitluna. Wane chinruna, “Puknokinipwu, puchichanwu kochinemane wjiglokinripa.” ");
INSERT INTO pibNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Wane chinna Geso, “Gajewa.” Wanna gishpakamtatka. Kochine yegi yatkana. Waneklu pejnurunniko gixolunni kochinni pagakaxikamtkalunenni gitawakapjita rujrukamtyanna. Tsru wenu rapokanna. Gonu rupniyanna. ");
INSERT INTO pibNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Kochi kogluklerune gasukamta. Pokchi yana. Runkaklewatna pejnurpiranako kamchichachineya. ");
INSERT INTO pibNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Giyagni pejnuruneko pokchi gajene yayegitluna. Yoptotapluna Geso. Retluna. Ragjitluna pnusretako yinripatka. ");
INSERT INTO pibNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Kanawa ruptekatka Geso, koprugatatka. Gipokchi yatka. ");
INSERT INTO pibNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Waneklu satu giktegachri ranikyegitluna, gijeko giklugachri. Geso geta galixletna wanna. Wane chinru giktegachri, “Kiglenshinikanupyi, Wiwi. Kaspukmukochiretkalurutkayi.” ");
INSERT INTO pibNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Wa pimrine yonchikgapine wane chinanshinikanutna, “Tyenwa mupashiregnuchi china.” ");
INSERT INTO pibNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Rumatanshinikanutinna Geso, wane chinna, “¿Klu chinau mugletu gyanshinikanuta gajiya? ");
INSERT INTO pibNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Gi rixanu ¿girni wa myapretu wane chinikolu, waka, ‘Kaspukmukochiretkalurutkayi,’ waka wane chinru, ‘Palnanutka. Pyanamtanutka’? ");
INSERT INTO pibNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Seyni wa gimatyaplu wa Gita Yineru Wgenno tyechijne gitaakalurno kaspukmukochirewlewatachripno” —giyagni wane chinru giktegachri, “Palnanutka. Pwanutkalu pujeko. Pyanutka pupji.” ");
INSERT INTO pibNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Giyagni wale palnatka. Gipji yatka. ");
INSERT INTO pibNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Gixolune getanatlu. Pikna. Rumalwutluna Goyakalu, gi rixanu renekyana yine wane rixa gitakletikolupa. ");
INSERT INTO pibNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Wane yiyatka Geso. Retlu satu jeji, girukotlewatachine gijgawenjetikowaka tuplanatachri. Matiyo giwakni. Wane chinru, “Pomkagitanno.” Palnamtatka. Romkagitatkalu. ");
INSERT INTO pibNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Wane rixa. Panchi nikjetikowaka tuplanata. Wanena gi gepika gijgawenutachine ga wa kmukochirerune gapokachine. Tuplatna nikjetikowaka Gesoyma ga wa yimaklene. ");
INSERT INTO pibNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Gwariseyone getinna. Wane chinkanna yimaklenni, “¿Klu chinanu gijgawenutachine ga wa kmukochirerune rumnika gyimakjeru?” ");
INSERT INTO pibNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Yijnakotinitka Geso, wane china, “Wa gichkolune gi ralukluna kpinrewakleru, seyni wa yayixachinena galikaka. ");
INSERT INTO pibNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Gajewa. Gimatanutkalu klunerpiranni. Naluklu getwamonrewlu. Gi wa genekashlu giylatkaluru naluka. Gi rixanu gi nuna ntomgiyapna poyagkakachine seyni kmukochirerune.” ");
INSERT INTO pibNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Giyagni Gwa yimaklene yayegitlu Geso. Wane chinruna, “¿Klu chinanu wixa ga wa Gwariseyone gixo kata gogajirewata; ga wa Pixa yimaklene gi gogajirewata?” ");
INSERT INTO pibNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Geso wane chinna, “Gi rumkata wamonuwnaletna wa kashimyolu getachine wannayma rawinikopshini gnunrowatachri, wa xani pixka Gita gimwakopshinna nyimaklene. Seyni runanu pagogne wa gnunrowatachri konkoklunpatka wannayegiya. Waneklu rogajirewatanna wanna. ");
INSERT INTO pibNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Gike gamatlu muchkirgasamatkatuwa mkachritsole. Gi rixanu waleko ramle sama jiprojiklu mkachri. Pnute rixa giskakletanatka. ");
INSERT INTO pibNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Gi koxa wa tsrutsoleji nikchimtamapa rutakgatlona winga gerotga. Wane rixkoklunu tsapkaka gipshekgata. Ga wa wingani tuyokgatana. Salewnanatka tsapni koxa. Seyni gerotmapa rutakgatlona gerotga winga. Gepiko gimretka.” ");
INSERT INTO pibNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Runkakiniwana tyepirana, runyegitlu satu gitsrukaachi. Yoptsojityegitlu. Wane chinru, “Nshichni gajerya tupnanawa. Seyni punanu. Putakamyogontapanro. Tuwekanu.” ");
INSERT INTO pibNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Palnamta Geso. Romkagimtlu yimakleneyma. ");
INSERT INTO pibNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Wanero sato suxo pamole gepi walapu gigragalewatachro. Gitjimne tyapamtyalu, tkamrukamkaptostsitaplu. ");
INSERT INTO pibNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Gi rixanu wane china walananuko, “Nkamrukamkatyapjeplu nutukanu.” ");
INSERT INTO pibNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Wa Geso giprotaka. Retanatlo. Wane chinro, “Kiglenshinikanupyi, Wiwi. Palixle gitskalakyi.” Wanekluyakawa tutskalga suxo. ");
INSERT INTO pibNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Geso gapokatkalu gitsrukaachipji. Retna tumlejitachine ga wa gixolune sejrewnachine. ");
INSERT INTO pibNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Wane china, “Gixrikanu. Wa mturo gi wa tupna, seyni tumkanata.” Ruxpiranatluna. ");
INSERT INTO pibNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Wa gixolune maleka koshpaaka. Jiglokamtatka. Kamrukamyotlo. Tyotunotatka mturo. ");
INSERT INTO pibNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Pogitpiranamtkatka psolchijneko walechijne. ");
INSERT INTO pibNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Wane yiyatnaka Geso. Romkagimtluna gepi maygalene. Saplewjenanumtna. Wane chinna, “¡Petwamonutanunwu, Tawiklopisha!” ");
INSERT INTO pibNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Panchi rapokinitka, maygalene ginyegitlu. Ga wa Geso wane chinna, “¿Galixge numkata wane gixleta?” Wane chinruna, “Gigi, Gitsrukaachi.” ");
INSERT INTO pibNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Giyagni kamrukaygaletatkana. Wane chinna, “Galixyawakpotuko gkamrutikotka.” ");
INSERT INTO pibNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Rumrekgatatkana. Ga wa Geso rujretpotutna. Wane chinna, “Ggirukotinwa gike gimatanru.” ");
INSERT INTO pibNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Seyni yatkana. Poshalpiranamtluna psolchijneko walechijne. ");
INSERT INTO pibNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Yinitkana, satu jeji ranikyegitluna myanumatkatu, kamchichachrina. ");
INSERT INTO pibNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Maleka ruknoklu kamchi. Wa myanumanatkatu yanumsatatka. Gixolune giglajita. Wane chinna, “Gi pagogne Gisrayilichijne retika tye pixkalutu.” ");
INSERT INTO pibNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Seyni wa Gwariseyone wane china, “Kamchi gitsrukate giyakleya maleka ruknokna kamchine.” ");
INSERT INTO pibNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Papokchimnunanuka yapa Geso, tsru pokchikaka ga wa mtserutu pokchikaka. Runkaklewawaklepjikakna runkaklewananumtya. Runkakletananumtlu Kiglerupotunanu Tokanchi pogirewatyawakapirana. Rutuukakananumtlu pejnuruko yayixlukaka, ga wa pejnuruko gagijewakchi yinyegiya. ");
INSERT INTO pibNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Retna gixolune yine. Retwamonutna, gi rixanu kojwakanshinikanutnawana. Giknookalurune gowegane pixka, girukotapratachri waneyamigjene. ");
INSERT INTO pibNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Giyagni wane chinna yimaklene, “Galikakni gixlu jirgakalurupa. Seyni wa kamrurewaklerune gi gixna. ");
INSERT INTO pibNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Giyagni gagjitanru jirgakalurupa Gitsrukate jirgalyegipa yokanatyapna kamrurewaklerune.” ");
INSERT INTO pibNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Pamole gepi yimaklene tomga. Rutakna kamchine puchotlewatachine chinanu maleka ruknokyapna, pejnuruko yayixlukaka rutuukakinripna ga wa pejnuruko gagijewakchi ");
INSERT INTO pibNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Pamole gepi yokanatanune giwakna walenwa: muchinanu Simo wa Petro chinkaluru, ga wa repuru, Gantirishi, ga wa Santiyako, Sewereyo wgene ga wa repuru Gwa; ");
INSERT INTO pibNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Wilipi ga wa Wartolo, Tomasu ga wa Matiyo gijgawenutachri, Santiyako, Galgweyo wgene, ga wa Tateyo. ");
INSERT INTO pibNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simo Kanani gajeru ga wa Gota Giskaryote samyokjerupa. ");
INSERT INTO pibNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Geso yokanatatkana nyi pamole gepi. Wane china yokanretna, “Gi wa payingapoko gyanu. Gi wa Samaritane pokchiko gapokanu. ");
INSERT INTO pibNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Seyni gowegane gamgachine yegi galikaka gyanu, Gisrayiliklopishane yegi. ");
INSERT INTO pibNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Gyinipa ginkaklewananumtanu. Wane nchinanu, ‘Tengogne pogirewatyawaka gi gowukatka.’ ");
INSERT INTO pibNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Gituukakananumtanna yayixachine. Gyotunkakananumtanna gipnachine. Mpowratananumtanna gijirgitutachine. Maleka giknokanna kamchine. Genekashatkaluru gyoptota. Genekashlewatanu koxa gixa. ");
INSERT INTO pibNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Gi wa koriko ntapgatanu, gi wa sroschiko; gi wa sintawoko giskotatanu. ");
INSERT INTO pibNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Gi tsapako yagaplu chinanu, gi gepimkaluko, gi yoshmakjixrechishpatako, gi wa kanojerchiko. Gi rixanu wa kamrurewakleru rumkata yoptoletlu nikanru. ");
INSERT INTO pibNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Girukokta pokchi gapokanu tsru pokchi ga wa mturu pokchi, gepomlewatanu ginaklu kiglepiranyegirupji. Wane gwanu gyinpotunanuko. ");
INSERT INTO pibNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Wa panchi gapokinipa galukanna wane gajene. ");
INSERT INTO pibNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Wa panchi gajene rumukane rixinrina, waneyapna gixa giglenunshinikanu. Seyni ma mumuklunu rixinrina giglenunshinikanu satokyegitangi. ");
INSERT INTO pibNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Katukokta gi yoptotangi, gi yijnaktokanutangi, walepji gyinpatka ga wa wale pokchiya, giplokjiximtanu gistapjixipagi, rumatikolupna. ");
INSERT INTO pibNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Galikakni wane nchingi wa gakotkalurupa Sotomachijne, Komorachijne gajenniya wale pokchi gajenni pnute wa giklukanuwnalgognepatka. ");
INSERT INTO pibNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Xawakni Gita yokanatgi gowegane pixkalungi kewetnanetskala. Giyagni galpokonshinikanutanu gimnune pixka, ga wa myokwirenepgi motkokone pixka. ");
INSERT INTO pibNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","“Ggirukotinwa yineya. Gi rixanu samyokangina jemanshinikankakjetikowaka. Runkaklewawaklepjikakayna kochipjetingina. ");
INSERT INTO pibNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Girukotlewatachine yegi ga wa pogirchine yegi ganiiko Gita chinanupa, gipgujtalewlu chinanu wanna yegi ga wa payine yegi. ");
INSERT INTO pibNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Wa nsamyookoklunupa gi wa gkojwakanshinikanutinwa gi nchina yanumsaletinripa. Gi rixanu waneklupapko geneeko wane nchinanrupa. ");
INSERT INTO pibNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Gi rixanu gi wa gixapni yanumsatachinepgi, seyni Giwekikaluru gixa Girunu gixa gitokote yanumsatini. ");
INSERT INTO pibNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Molchi samyokanru gimoleko rupninripa, ga wa girchi gituru. Ga wa wgenchine kamnixanna rurunna ruylatikolupna. ");
INSERT INTO pibNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Gayegixkalunepgi pejnuruneyako Gita giwaka chinanu, seyni wa kashnantakanshinikanutachri yoptukyawakpotunanuko wale gognetkaako. ");
INSERT INTO pibNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Tye pokchiya kojwakingina gasukanu. Papokchi gyanu. Gi rixanu galikakni wane nchingi, gi gnikawna wane yaletanu papokchimnunanuka Gisrayilichijne nma munkanupachi Gita Yineru Wgenno. ");
INSERT INTO pibNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Yimaklechi gi wa tsrunwa yimaklewatachri pnute. Gi wa wayegrechriko, rutsrukate pnute. ");
INSERT INTO pibNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Poyagotyalu yimaklechi wa yimakjeru pixka rixinripa, ga wa wayegrechri wa rutsrukate pixka rixinripa. Welsewo chinmakluna kapjiru pnutenapna gipji gajenepni. ");
INSERT INTO pibNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Giyagni gi mpikanna. Gi rixanu maleshlu giyogimatkaluru gi wa mupgujetkotpakni. Maleshlu pochkeruko mumatkotupa. ");
INSERT INTO pibNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Wane nchinyagi Gita mapshagawakaya, pokamlawakaya wane nchininri gixa. Gijnakpotuko gyijnakotinri, panchi gayiji ginkakletinri. ");
INSERT INTO pibNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Gi mpikanna manchi giylatachine seyni giweklu gi rumkata giylaletna. Seyni Wale galikaka mpikanu giweklu gimkata gamgakakletachri ga wa manchi Gigena xirnachriya. ");
INSERT INTO pibNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","¿Gi ge wa ganikajiproji chinanu rushankaka gepi koshichine? Ga wa gi satuna wanna chiji gijruka gixa Giru mwaknu. ");
INSERT INTO pibNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Gijiwtsako pejnuruko yantatkalurni. ");
INSERT INTO pibNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Giyagni gi mpikanu. Kiglepotgi gixa gixo koshichine pnute. ");
INSERT INTO pibNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Giyagni girukokta gipgujtatanno yineyegiya, Gita koxa gipgujtatanru Nuru tengogne Gajeru yegi. ");
INSERT INTO pibNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Girukokta ginutatanno yinyegiya, Gita koxa ginutatanru Nuru tengogne Gajeru yegi. ");
INSERT INTO pibNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Gi gkagwakanru nuninri wa tyechijne nutakyaplu kiglegwashle. Gi wa nuna kiglewashle nutakinripa seyni yoglolewapi. ");
INSERT INTO pibNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Gi rixanu nuna nkotspalatyapna: Jeji wa ruru kamnixinripa, Ga wa tshicho tunro tkamnixinripa, Ga wa tomekanunro tgimajiro tkamnixinripa. ");
INSERT INTO pibNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Wa jeji kamnixjene, walepji gajeneko kamnixanru. ");
INSERT INTO pibNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Girukta gi wa galukpotutno ruru, runro pixka pnute, gi wa rumukluno Gita. Girukta gi wa galukpotutno gituru, rushicho pixka pnute, gi wa rumukluno Gita. ");
INSERT INTO pibNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Girukta gi gwanro koroshiteshkita, gi rawgajxigitanno, gi rumukluno Gita. ");
INSERT INTO pibNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Girukta gikshika giwekleta, ruwekinri ramginina. Girukta gamtakanru ruwekinri Gita chinanu, rukshika giwekletanu. ");
INSERT INTO pibNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Gixa yoptotachri, Gita yoptota. Wa Gita yoptotachri nyokanatjeru yoptota. ");
INSERT INTO pibNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Tokanchi geneklewatachri giwakaya tokanchi geneklewatachri yoptotachri, wale yoptotanru tokanchi geneklewatachri gapnutikolu. Poyagkakachri giwakaya poyagkakachri yoptotachri, wale yoptotanru poyagkakachri gapnutikolu. ");
INSERT INTO pibNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Girukokta genekanru girapistonopje kachiklegalu satu mturu wanna nyi mturune nyimakleru giwakaya, galikakni wane nchingi, gi wa ramga gapnutkotanu.” ");
INSERT INTO pibNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Wane rixa. Geso rali towutletatkana pamole gepi yimaklene, wane yiyatka, papokchikaka wannanu yimaklewatinripa ga wa runkaklewatinripa. ");
INSERT INTO pibNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Yoshmakikowaka Gwa yijnakpiranyegityalu Kristo kamrure. Giyagni yokanatna yimaklene Gesyegi. ");
INSERT INTO pibNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Wane chinruna, “¿Pixaklege ginachripyi, waka wkagwakerge satu?” ");
INSERT INTO pibNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Rugita Geso. Wane chinna, “Gajewa. Ginkakapanru Gwa gyijnakotanrukakaya ga wa getanrukakaya. ");
INSERT INTO pibNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Maygalenenanu getatka. Ga wa myankanenanu yanatka. Ga wa gijirgitunatachine powratkatka. Ga wa majnakonenanu jemashatatka. Ga wa gipnachine yotunkaaka. Ga wa kwamonurune yegi runkakletika Kiglerpotunanu Tokanchi. ");
INSERT INTO pibNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Giglenshinikanyegitkaluru mutspetkatu Gitaya.” ");
INSERT INTO pibNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Yanananumtinna, Geso yinuwaka ginkakletna gixolune yine Gwapirana, “¿Kluneru getapa yineru mwiyawakanuya? ¿Satu kapanrege kannipgyalu kowshikanrurge? ");
INSERT INTO pibNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Seyni ¿kluneru getapa? ¿Satu jeji popchimkalurege gitakachri? Gike. Pogirchinepji rawna popchimkalu gitakachine. ");
INSERT INTO pibNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Seyni ¿klu chinanu wane gyapa? ¿Satu tokanchi geneklewatachrirge getapinripa? Gigi, wane nchingi. Tokanchi geneklewatchri pnute. ");
INSERT INTO pibNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Gi rixanu walenwa yonpiranyegitkaluru: Petanu. Gita yokanatlu notowreru pixa penute. Wale galpokotanru patnugapote pixa penute. ");
INSERT INTO pibNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","“Galikakni wane nchingi, gi wa rupgujewna satu suxo gishpakyachri, Gwa Katlewakleru pnute tsru. Seyni wa mtserutu potu tengogne pogirewatyawakaya tsruni Gwa pnute. ");
INSERT INTO pibNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Gwa Katlewaklerukluyakawa ga wa xanigognenanu tengogne pogirewatyawaka muchkowyegitka. Muchkowatachine kashichlu. ");
INSERT INTO pibNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Gi rixanu pejnuruneko tokanchi geneklewatachine ga wa tokanchi yokanatkaluru Gwaklupotunanuko runkakletpiranatluna. ");
INSERT INTO pibNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Galuka yoptoletiniplu walenwa Giliya wa ginachripa. ");
INSERT INTO pibNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Girukokta kajnakopnapa wa yijnakotinripa, yijnakotanu.” ");
INSERT INTO pibNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Geso gomkagi wane chinretna, “¿Giru pixka nutakanna nyi gimuweekakgognenatachine? Mturune pixka, giputu tuplanatachine, rupxalunna tomsanatachine. ");
INSERT INTO pibNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Wane chinna: Wtumlejyegitgi. Gi wa gansata gixa. Wamonuwata gixa yegi. Gi wa nchiyagjeta gixa. ");
INSERT INTO pibNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Gi rixanu runa Gwa. Gi wa nika. Gi wa rura. Wane chinna, ‘Kamchi waneylu.’ ");
INSERT INTO pibNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Nuna Gita Yineru Wgenno, nikachrino ga wa girachrino. Wane chinna, ‘Getanru. Satu jeji tsru nikalu. Winga kgirakleru. Gijgawenutachine ga wa kmukochirerune gipxaalu.’ “Wa gimatkalewlu potukalu gekakgitka kamrureya.” ");
INSERT INTO pibNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Giyagni Geso yinuwaka chigetjeretna pokchikaka gajene. Wale chinanu chigetjetna gi rixanu wanna getanmaklu gixo potu ruyaklewle kamrujetyawaka. Ga wa retmakluna, gi waleko renshinikanutyana. Wane china chigetjeretyana, ");
INSERT INTO pibNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“¡Gi waneni pixa Korasi pokchi! ¡Gi waneni pixa Wetsayta! Gi rixanu Tiro pokchiniya ga wa Sito pokchiniya wanepmaklu giyaklewlukaka nkamruyegityagi gixa, wannanimka muchikawako renshinikanutannimkana. Kawshistugalu mkachrimka rutakmanetinnimkawanna ga wa chichipagimka rutakmanetinnimkawana. ");
INSERT INTO pibNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Ga wa wane nchingi, Tiro ga wa Sito pnute salewnalenapgi gixapni giklukanuwnalugognepa. ");
INSERT INTO pibNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ga wa pixa Kapernawo, tengognepotunanuko pixka putaaka. Ga wa gipnachine gwiyawakapotunanuko pixka putaako. Gi rixanu wa Sotoma gajene yegi kamrutikomka giyaklewlu pixa yegi kamrutikaluru, xanigognenanumka rutukna. ");
INSERT INTO pibNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ga wa wane nchingi wa gakotkalurupa Sotomachijne gajenniya gixa pnute wa giklukanuwnalgognepatka.” ");
INSERT INTO pibNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Walegogne Geso wane china, “Numalwutyi, Nuru, tengogne Gitsrukate ga wa chiji, tyepirankaka Pixa yogimatyana kgimatkalerune ga wa kanshinikanurune, ga wa mturune pekakgita. ");
INSERT INTO pibNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Gigi, Nuru, gi rixanu wane Pixa gigleretle getletlu. ");
INSERT INTO pibNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“Ptowruko samyokno Nuru. Gikena gimatlu Gituru, seyni Girchipje gimatlu. Gikena gimatkoxlu Girchi, seyni Giturupje ga wa girukokta raluka gekakgireta Gituru. ");
INSERT INTO pibNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Ginanu Gita yegi, pejnurunekgi gama kamrurewletachingi, gitjitachingi. Gita gapnankakanutkagi. ");
INSERT INTO pibNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Gikamrurewatinno. Gimatinno. Gi rixanu mayogotno Gita. Mturu gixnachriwano najiya. Ga wa gikshikanru gapnanunshinikanutinripa. ");
INSERT INTO pibNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Gi rixanu myapretni gikamrurewatinipno. Ga wa nutjitanru munotni.” ");
INSERT INTO pibNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Walegognekaka sana yapanata Geso gapnanutikalurugogne. Yimaklene nachi. Yinuwaka sustakagwuremtluna gitaklugwu. Nikluna. ");
INSERT INTO pibNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Gwariseyone getanata. Wane chinruna, “Petanna. Gapnanutikalurugogneko ginanshichkalurni kamrutna pyimaklene.” ");
INSERT INTO pibNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Wale wane chinna, “¿Gi ge getyongapiranyegitlu Tawi kamrutanru? Wa nachichini wale ga wa waleymalune koxa. ");
INSERT INTO pibNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Gi rixpoko jiglokletlu Goyakalupji. Niklu jimaprokaka gekakgitkaluru. Walenwa ginanshichkaluru wale nikyaplu, ga wa waleymalune koxa. Sasertotenepje nikanruni. ");
INSERT INTO pibNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","¿Gi ge getyongatkoxlu Tokanchi Yokanatkaluruya wa gapnanutikalurgognekaka kpashiwakapji, sasertotene gimuteru pixka gixkaklu gapnanutikalurgogne? Gi wale chinanu ruklukanuwnanna. ");
INSERT INTO pibNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Gita wane china, gewlu kpashiwakapji pnute tsru. ");
INSERT INTO pibNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Gimka giklukanuwnayegjixanna muklukanuwnakane, gimatinmaka klunerni tyepirana: Naluklu getwamonrewlu. Gi wa genekashlu giylatkaluru naluka. ");
INSERT INTO pibNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Gi rixanu gapnanutikalurugogne Gitsrukatno Gita wa Yineru Wgenno.” ");
INSERT INTO pibNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Wane yiyatka. Wanna ginkaklewawaklepji yatka. ");
INSERT INTO pibNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Waneru satu jeji giprigamyotachri. Repomgaluna. Wane chinruna, “¿Munanshichkotlege wa gapnanutikalurugogne pinitikolu?” Wane chinna gepomgaletluna jigyegityapluna. ");
INSERT INTO pibNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Geso wane chinna, “¿Giru jeji wane gixa yegi, sato gowega waneyalutu? Walamka gijrukanu kapna gapnanutikalurgogneko. ¿Gi ge kashichanro ga wa koschekanro? ");
INSERT INTO pibNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","¿Gi ge kiglepotlu yineru gowega pnute? Giyagni munanschichkotni gapnanutikalurugogne kigleru kamruruya.” ");
INSERT INTO pibNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Giyagni wane chinru jeji, “Pomyokanu.” Romyokatka. Ruglewamyotatka. Kigletkalu pasretako pixka. ");
INSERT INTO pibNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Yatkana Gwariseyone. Jemanshinikankakyegitluna ruylatyapluna. ");
INSERT INTO pibNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Rumatinitka Geso, wane yiyatka. Gixolune yine gomkagimtlu. Pejnuruneko rutuukaka. ");
INSERT INTO pibNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Rujretna ma pogijetyapluna, ");
INSERT INTO pibNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","poyagkakikolupa tokanchi geneklewatachri chinyawaka Gisayiya. Wane china: ");
INSERT INTO pibNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Getanru nupxakjeru Gita tsomitanru. Nushinikanru potu. Wale gigletanshinikanutno. Giwekikaluru Gitanu nutakanru payine yegi runkakletinri gitakyagoklewlupirana. ");
INSERT INTO pibNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Gi wa yangalewatanu. Gi wa saplewjetanu. Gike yijnaktokanutanru gatnugapoya. ");
INSERT INTO pibNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Wa katsluksu gischokachri gi wa sustonganu. Wa yochpiikalurchopa gimoliinatachri gi wa ruwakanu, koshpakinpotuklu giklukanuwnayegjixlu raalirewatinripa, ");
INSERT INTO pibNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","payine kagwaklewatinripa Wale giwakaya. ");
INSERT INTO pibNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Giyagni Wale yegi raniika satu kamchichachri. Walenwa maygaletu, myanumatkatu. Rutuukaklu. Giyagni wa maygaletu myanumatkatu yanumsatatka, retatka. ");
INSERT INTO pibNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Pejnuruneko gixolune giglajita. Wane chinna, “¿Gi ge Tawiklopishakni wa Tye?” ");
INSERT INTO pibNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Wa Gwariseyone yijnakotinri, wane chinna, “Wa Tye gi wa maleka giknokna kamchine, seyni Welsewoyapje chinanu, wa kamchine gitsrukate.” ");
INSERT INTO pibNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Geso gimatanshinikanutanna wanna. Wane chinna, “Pejnuruko pogirewatikowaka wa wane gajene kotspalanshinikankakmaka wannakakluko, giknookalurupni pogirewatikowaka. Pejnuruko pokchikaka ga wa panchikaka wa wane gajene kotspalanshinikankakmaka wannakakluko, gi rumkata gwagognereta. ");
INSERT INTO pibNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Satanasyokaklukmaka maleka giknoklu Satanasyo, walenanuko kotspalkakanshinikanutinmakwa. Giyagni ¿gi rixpoko gwagogneretanu wale pogirewatyawaka? ");
INSERT INTO pibNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ga wa Gita Welsewo chinanumka maleka nuknokanna kamchine, gwugenene ¿katu chinanu maleka ruknokna? Giyagni gwugenenepni gixa gitakyagokachinepni. ");
INSERT INTO pibNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Wa Giwekikaluru Goyakalunu chinanu Gita maleka giknokinna kamchine, galikakni gixyegitkalu Goyakalu pogirewatyawaka. ");
INSERT INTO pibNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“¿Gi rixpoko satu gimkata jiglokapjiretlu gichkolu, chowgutyaplu rejnunkate, ma mostutkanuwalu wa gichkolu? Waneklu chowgutyalu gipji gajeru. ");
INSERT INTO pibNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Gitasreta mwakatu, walenwa nkamnixjeru. Gitayma mapatjetkatu, kotspalewata. ");
INSERT INTO pibNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Giyagni wane nchingi, pejnuruko mukochri ga wa mupashiregnuchi kaspuukalurupni yinyegiya. Seyni ginnakokta yine Giwekikaluru mupashichkane, gi wa kaspukikna. ");
INSERT INTO pibNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Girukokta gapatno Gita Yineru Wgenno kaspukikalurupni. Seyni girukokta gapatlu Giwekikaluru Kpashiri gi wa kaspukiko, gi wa tyegogneyako, gi wa ginachripgogneko. ");
INSERT INTO pibNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Waka gagmuna kigleru rixa ga wa giji koxa kiglejiru, waka mugletu rixa gagmuna, ga wa giji koxa muglejitu. Gi rixanu gijiya rumatika gagmuna. ");
INSERT INTO pibNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Gimnu pixkalungi. ¿Gi gixpoko gimkata yanumsaletlu kigleru, muglenekgi gixini? Gi rixanu klunerutka yineru gaji tsepowniyachri, wale yanumatya ginamaya. ");
INSERT INTO pibNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Kigleru yineru, raji ponikowle kigleru, kiglekakalu koshpakya. Mugletu yineru raji gixolewniyachri mugletu, mugletkaka koshpakya. ");
INSERT INTO pibNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Ga wa wane nchingi, pejnuruko tokanchi yanumsashatinrina yine, rugyegitanruna giklukanuwnalgognepa. ");
INSERT INTO pibNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Gi rixanu ptokanu chinanu muklukanuwnakaakotupyi, ga wa ptokanu chinanu koxa giklukanuwnayegjixkalurupyi.” ");
INSERT INTO pibNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Giyagni pimrine yonchikgapine ga wa Gwariseyone gigita. Wane chinna, “Yimaklewatachri, waluka getletlu pixa kamrutanru getkaluru.” ");
INSERT INTO pibNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Rugita Geso. Wane chinna, “Gimuweekakgognenatachine muglene, kgimopataklerunni ragjitluna getkaluru, seyni getkaluru gi wa reneekona, seyni Gonasu tokanchi geneklewatachri getkalurutepje. ");
INSERT INTO pibNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Gi rixanu tsro potu tsru wenu gajeronanwaka rawanata Gonasu mapgogne, mapyechno, waneko pixka nixanu Gita Yineru Wgenno. Mapgogne, mapyechno chiji gitokote nwanatanu. ");
INSERT INTO pibNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Giklukanuwnalgognepa jejinni, Niniwe gajenni, yotunotanu nyi gimuweekakgognenatachineyma. Wannani giklukanuwnakakanna nyi gimuweekakgognenatachine. Gi rixanu wannani genshinikanuta Gonasu ginkaklewle chinanu. Ga wa xani gewru Gonasu pnuterutu. ");
INSERT INTO pibNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Giklukanuwnalgognepa tyotunotanu tkachi kegnetesreta gajerni pogirewatachroni nyi gimuweekakgognenatachineyma. Tuklukanuwnakakanna, gi rixanu yoptukyawakchijiko tunya tyijnakotyaplu Salomo gimatkalewle. Ga wa getanru. Gewru Salomo pnuterutu. ");
INSERT INTO pibNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Kamchi puchotlewatachri yineru rushpakamtinika, pnumnu yapanatatka, popriwaakaka. Rujgalu rapnanutyawakapa. Gi wa rukshiklu. ");
INSERT INTO pibNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Giyagni wane china, ‘Nsatokanutka nopji nuyakatyawaka.’ Wane rapokinitka rukshiklu malepjiru, saxritkaluru ga wa galpokotkaluru. ");
INSERT INTO pibNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Giyagni wane ya. Waleyma ranikna pimrine payokgipre kamchine wale pnuterune muglene. Jiglokna. Wane rawna. Ralipretka gektutu giknogatkalu tye jeji muchinanu pnute. Waneko pixka rixanna nyi gimuweekakgognenatachine muglene.” ");
INSERT INTO pibNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Gixolune yine runkaklewyeginatiniwa, runro ga wa repurune maleka tunwatachine, raluka giynumsaletluna. ");
INSERT INTO pibNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Satu wane chinru, “Gewna punro ga wa pepurune, maleka tunwatachine. Raluka giynumsaletyina.” ");
INSERT INTO pibNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Rugitlu wane chinjeru. Wane chinru, “¿Katni wa nunro? ¿Katni wa nepurune?” ");
INSERT INTO pibNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Romyokyegitna yimaklene. Wane china, “Ga ga nyinwa nunro, ga wa nepurune. ");
INSERT INTO pibNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Gi rixanu girukokta kamrutlu tengogne Gajeru Nuru gishinikanru, walenwa nepuru, ga wa nepuro, ga wa nunro.” ");
INSERT INTO pibNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Walegogne panchi rushpakamtya Geso. Tsru wenuspuwnaga tuplata. ");
INSERT INTO pibNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Rapatyegitluna gixolune yine. Kanawa ruptekatka. Wane tuplata. Ga wa pejnuruneko gixolune yine wanga gwa. ");
INSERT INTO pibNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Gi gepikapirana runkakna yapkakluya. Wane china, “Wane rixa. Wa kgitaklewakleru gitaklewtapanu. ");
INSERT INTO pibNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Kopalajitini pimriji gatnugapostsi gapokajita. Runna koshichine. Niklokajitluna. ");
INSERT INTO pibNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Pimriji sotlu gwiyawaka gapokajita mwiyawakanu potu kajpa. Waneklumka rupchekni. Mpixnuwakapotni chiji. ");
INSERT INTO pibNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Ga wa rushpakini tkachi jimanatkalu. Ma matskinu chinanu rupriganatka. ");
INSERT INTO pibNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Pimriji kona yegi gapokajita. Tseruwna konkaka. Kapotanatkalu. ");
INSERT INTO pibNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Pimriji kiglewaka chiji gapokajita. Wane jiwatya. Rawa satu satpachaji, satu patsrujirmoleji, satu mapmoleji. ");
INSERT INTO pibNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Kajnakopnalu wa yijnakotinripa, yijnakotanu.” ");
INSERT INTO pibNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Runyegitluna yimaklene. Wane chinruna, “¿Klu chinanu yapkaklu punkaklewyegityana?” ");
INSERT INTO pibNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Rugita Geso. Wane chinna, “Gi rixanu wa gixa geneeka gimatyaplu giyogimanatkaluru tokanchi tengogne pogirewatyawakapirana, seyni wanna gi wa geneeka. ");
INSERT INTO pibNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Wa waneyalutu wanepnute reneeka. Waneyamigjetu wane rixle konikona. ");
INSERT INTO pibNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Giyagni yapkaklu nunkaklewyegityana, retinmakna ma metinitipna, yijnakotinmakna ma yijnakotinitipna, ma mumata jeminitipna. ");
INSERT INTO pibNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Wane rixa poyagkakikolupa wannaya Gisayiya tokanchi geneklewatchri ginkakle. Wane china: Gijnakopna gyijnakotini, gi gimata jemanru. Getini getinmaka, gi gimatanru. ");
INSERT INTO pibNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Gi rixanu shikowgajkaakana nyi yine. Ga wa gijnakopnayna kyapreru yijnakotyana. Ga wa rushyaygaletna ma giygalna metinitipna; gi wa gijnakopnayna yijnakotinripna; gi rajiyakna rumata jemyana; ma kashrijetikotupna, nma mutuukakyanupna. ");
INSERT INTO pibNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Seyni giglenshinikanyegitkalurni giygale gi rixanu geta, ga wa gijnakopna gi rixanu gyijnakota. ");
INSERT INTO pibNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Gi rixanu galikaka wane nchingi, wa tsru galuklu rixmakluna gixo tokanchi geneklewatachine ga wa poyagkakachine. Raluka getletmakluna wa gixa getanru. Gi retluna. Raluka yijnakletmakluna wa gixa yijnakotanru. Gi wa yijnakotluna. ");
INSERT INTO pibNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Giyagni gjemanru gixa kgitaklewakleru yapkaklepirana. ");
INSERT INTO pibNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Girukokta yijnakotlu tokanchi pogirewatyawakapirana, ga wa gi rumata jemlu, runa mugletu. Kashichlu raji gitaakaluru. Walenwa gatnugapostsi gitaakaluru. ");
INSERT INTO pibNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ga wa sotlu gwiyawaka gitaakaluru, walenwa yijnakotlu tokanchi. Waneklu rumuwlepotuko yoptotlu. ");
INSERT INTO pibNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Seyni gi katskiri. Pshinitsonu gwachripa. Wa runini salewakchi ga wa kojwawakchi tokanchi chinanu, waneklu rutspekaaka. ");
INSERT INTO pibNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ga wa kona gwiyawaka gitaakaluru wale yijnakotlu tokanchi. Wa kojwakanshinikanrukaka tyegogneya, ga wa ponikowlu yokwire kapotlu tokanchi. Gi wa jiwatanatka. ");
INSERT INTO pibNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Wa kiglewaka chiji gitaakaluru walenwa yijnakotlu. Rumatjemlu tokanchi. Jiwata: satu, satupachaji; satu, patsrujiremoleji; satu, mapmoleji.” ");
INSERT INTO pibNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Satu yapkaklu runkakyana. Wane chinna, “Tengogne pogirewatyawaka satu jeji pixka rixa, kiglejiru gitakachri rusanate. ");
INSERT INTO pibNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Seyni rumkakopshinna yine runa kamnixjeru. Rutkaplu triko pixkalutu kshana, triko ganikajite. Yatka. ");
INSERT INTO pibNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Giyagni wa gitaakaluru gipchekinitka, kaji rixinitka, waneklu koxa rupgujewna triko pixkalutu kshana. ");
INSERT INTO pibNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","“Wayegrechine gapyegitlu kwangixleru. Wane chinruna, ‘Gitsrukaachi, ¿gi ge kiglejiru putaklu wa pusanate? Giyagni ¿ginaka ruyakatya triko pixkalutu kshana?’ ");
INSERT INTO pibNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“Wale wane chinna, ‘Satu jeji nkamnixjeru wane gixlu.’ “Ga wa wayegrechine wane chinruna, ‘Giyagni ¿gi ge paluklu wa woplipchetapyaplu?’ ");
INSERT INTO pibNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“Wale wane china, ‘Gike. Wa goplipchetinri gma moplityakoxaplu triko. ");
INSERT INTO pibNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Getasha tseruwnaletanru gepiko, jirgakoklunpotunanuko. Jirgakoklunpatka, wane nchinanna wa jirgachinepa, “Muchinangapka goplitanru triko pixkalutu kshana. Gostuptajetanru yoxikikolpatka. Ga wa triko gapatjetanu. Rumretikowakapji gitakanru.” ’ ” ");
INSERT INTO pibNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Satu yapkaklu runkakatnakna. Wane chinna, “Tengogne pogirewatyawaka mostasaji pixka rixa. Satu jeji ganiklo. Rusanate rutaklo. ");
INSERT INTO pibNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Walenwa galikaka ptowruko kajiruji mtserujitu potu. Seyni wa tseruwninitka walenwa tsru potu kshana gitaakaluru pnute. Gagmuna pixka rixa. Giyagni teno yapachine koshichine gina. Waleplu shalewatna.” ");
INSERT INTO pibNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Satu yapkaklu runkakatnakna: “Tengogne pogirewatyawaka gisekachri pixka rixa. Sato suxo gwalu. Gepmole masu yaglu trikopagi tyapjetlu, psoluko rusekinpotunanuko.” ");
INSERT INTO pibNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Pejnuruko tyekaka yapkakluya Geso ginkakna yine. Wa yapkaklu migje gike runkakna, ");
INSERT INTO pibNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","wa poyagkakikolupa tokanchi geneklewatachri chinyawaka. Walenwa china: Nyanumatanu yapkakluya. Rekamrutkoklunuyakawa tye psolchijneko yogimanatkalurkaka nunkakletanu. ");
INSERT INTO pibNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Giyagni rungatkana gixolune. Panchi yatka Geso. Yimaklene ginyegitlu. Wane chinruna, “Punkakpokowakatanwu wa sana gajeru triko pixkalutu kshana yapkaklupirana.” ");
INSERT INTO pibNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Rugita Geso. Wane china, “Wa kiglejiru gitakachri walekno Gita Yineru Wgenno. ");
INSERT INTO pibNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Sanni wa tye psolu chijiko. Ga wa kiglejirni wa pogirewatyawaka gajenni. Ga wa triko pixkalutu kshana walenwa muglene. ");
INSERT INTO pibNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Ga wa kamnixjeru walenwa tsru kamchi, triko pixkalutu kshana gitakachri. Wa jirgalni walenwa ralipregognepa. Ga wa jirgachinepa wannanwa Goyakalutowrerune. ");
INSERT INTO pibNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","“Giyagni wa kshana triko pixkalutu wane rixa goplitkotanu. Yochpiikotanu. Wane rixanu ralipregognepatka: ");
INSERT INTO pibNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Gita wa Yineru Wgenno nyokanatanna notowrene, pogirewatyawaka rapatinrina pejnuruko gitspetkalurkaka. Ginanshichkaluru kamrutachine koxa rapatanna. ");
INSERT INTO pibNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Wanna xirnachri giknooko. Waneplu chiyaglu ga wa gashkaygitlu. ");
INSERT INTO pibNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Giyagni poyagkakachine gatajiwnanu, tkachi pixka, Rurna pogirewatyawakaya. Kajnakopnalu wa yijnakotinripa yijnakotanu. ");
INSERT INTO pibNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Tengogne pogirewatyawaka ponikowlu pixka rixa sana yogimatkaluru. Satu jeji rukshikinitkalu, yogimatatnaklu. Rumuwle chinanu rushankaplu pejnuruko wane rixle. Ragjitanru wale sana. ");
INSERT INTO pibNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Wanepnutetnaka tengogne pogirewatyawaka kmarnewakleru pixka rixa, kigle katajiroji perlaji gijgachri. ");
INSERT INTO pibNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Rukshiklo sato kwenuro potu perlaji. Rushankaplu pejnuruko wane rixle. Ragjitatkalo. ");
INSERT INTO pibNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Wanepnutetnaka tengogne pogirewatyawaka tsru chalu pixka rixa. Tsru wenu ruknokgatka. Rawlo pnumnu gixachro shima. ");
INSERT INTO pibNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Wa katsepo rixinitka chalu, wanga koshpatyatkalona. Tuplatna. Tsomitatkalona kiglero. Kojita rutakna. Ga wa gektuto shima maleka ruknokanatkalona. ");
INSERT INTO pibNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Wane rixanu ralipregognepa. Rushpakamtanna Goyakalutowrerune. Konanna muglene poyagkakachinetskalaya. ");
INSERT INTO pibNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Towrechine xirnachri giknokanunna. Waneplu chiyaglu ga wa gashkaygitlu.” ");
INSERT INTO pibNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Wane chinna Geso, “¿Gi ge gimata jemlu wa tye pejnurkakakopirana?” Rugitluna, “Gigi.” ");
INSERT INTO pibNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Wale wane chinna, “Giyagni pejnuruko yonchikagapri ginkaakaluru tengogne pogirewatyawakaya, satu jeji pixka rixa kapjiru. Ponikolewle koshpakyalu gerotkaka ga wa kapokotkaka.” ");
INSERT INTO pibNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Wane rixa. Rali ginkakletinitkalu tyekaka yapkaklu, wane yiyatka. ");
INSERT INTO pibNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Gichijne yatka. Wanna ginkaklewawaklepji runkakjetyana. Wane rixa. Wanna giglajita. Wane chinna, “¿Ginaka rawyalu tye gimatkalewlu ga wa tye giyaklukaka? ");
INSERT INTO pibNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","¿Gi ge kyosokokleru wgenekni wa Tye? ¿Gi ge Mariya chinkalurokni wa runro? ¿Ga wa repurune Santiyako ga wa Gosi, ga wa Simo, ga wa Gota chinkalune? ");
INSERT INTO pibNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","¿Gi ge pejnuroneko repurone wixa yegi? ¿Giyagni ginaka pguta rukshikyalu pejnuruko tyekaka gimatkalewlu ga wa ruyaklewle?” ");
INSERT INTO pibNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Wale pupjetyana. Seyni Geso wane china, “Maleshlu tokanchi geneklewatachri Goyakalunni mkagwakpiratkotu ga wa gichijnepjeya, gipjiya.” ");
INSERT INTO pibNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Gi wa gixo giyaklu kamruta waneya ma malixlena chinanna. ");
INSERT INTO pibNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Walegognekaka Girore pasreta girukotlewatyachri yijnakpogiwletlu Geso. ");
INSERT INTO pibNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Wane chinna wayegrene, “Walenwa Gwa Katlewakleru. Gipnachinetskala yotunomtyatka. Giyagni kgiyaklewaklerni.” ");
INSERT INTO pibNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","5","Gi rixanu Gwa giykotlu Girore. Wane chinru, “Ginanchichkalurni pepuru gnunro pwayegitinripa.” Wale chinanu raluka giylaletmaklu. Seyni yine pika wale, gi rixanu tokanchi geneklewatachri kagwakyaluna. Giyagni Girore kashichjixatkalu Gwa. Rostujixlu. Yoshmakjetikowaka rutakjixatkalu Giroryana, Wilipi repuru gnunro, chinanu. ");
INSERT INTO pibNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Meyiwlu kamrutka Girore poyagkakle walapute chinanu. Wanna ganikajite tansatya Giroryana nshicho. ");
INSERT INTO pibNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Tmeyitlu Girore. Giyagni rupiratyalo Wale kawchinanu renekyaplo klunerukokta tagjityaplu. ");
INSERT INTO pibNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Wa wala jigetkaluro tunroya. Wane china, “Penekanno gewiya satu kotajipi Gwa Katlewaklerujiwu.” ");
INSERT INTO pibNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Giyagni wa pogirchi wamonuwata. Wa Wale kawchinanu chinre ga wa waleyma gwanatachine nikawakakwale renekjixatkalo. ");
INSERT INTO pibNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Yokanrewatatka. Rustaknoojixatkalu Gwa yoshmakjetikowakaya. ");
INSERT INTO pibNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Kotajipi ranikjiwutikatka. Makloji geneekatka. Tunro yegi taniklu. ");
INSERT INTO pibNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Rapokna Gwani yimaklene. Ranikmanetatkaluna. Kapnatatkaluna. Runkakpatkaluna Geso. ");
INSERT INTO pibNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Geso yijnakpiranyegitanatkalu, wane kanawa yiyatka. Yineru mwiyawakanu yatkana wanna mkoje. Wa gixolune jeminitka, pokchikaka ruyakatyatkana. Romkagitluna. Chiji yapamtna. ");
INSERT INTO pibNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Ruptekinitka Geso, retna gixolune yine. Retwamonutna. Rutuukakna yayixachine. ");
INSERT INTO pibNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Wa kayi rixinitka yimaklene gapyegitlu. Wane chinna, “Gewni yineru mwiyawakanu. Wa kayitkani. Giyagni pyokanatanna gixolune pokchikaka yinripna, ragjityapluna nikanrupna.” ");
INSERT INTO pibNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Geso wane chinna, “Gi wa magatyana wane yinripna. Genekanna nikanrupna.” ");
INSERT INTO pibNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Wane chinruna, “Maleshaywu gewi, seyni pamyo jimapropje ga wa gepi shima.” ");
INSERT INTO pibNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Wale wane china, “Ganikyegitanno gewi.” ");
INSERT INTO pibNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Peklomta gogo tuplajixatkana gixolune yine. Rawlu pamyo jimapro ga wa gepi shima. Teno yigata. Ruglenshinikanyegitlu. Jiknajrotlu. Renekna yimaklene. Ga wa yimaklene geneksatna gixolune yine. ");
INSERT INTO pibNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Pejnuruneko nikatka. Jinanutkana. Koschekatkaluna gixetachri psojkaka, pamole gepi kojita katsepo. ");
INSERT INTO pibNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Wa nikachine pamyo waragka jejine. Gi wa kyagna suxone. Gi wa mturuneko. ");
INSERT INTO pibNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Waneklu kanawa ratskojixatkana yimaklene, wakanu kosekinripatkana, rungakopshinna yine. ");
INSERT INTO pibNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Rali gingaletinitkana gixolune yine, magka kanika Walepje, ragjigognetinripa. Kayi rixinitka wane rawanatatka Walepje. ");
INSERT INTO pibNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Ganikajgatkalo kanawa. Rutwatjekakanro gishpurga, gi rixanu kannipgyalu satkakanro. ");
INSERT INTO pibNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Rumrereekastsitkani, Geso yayegitatkana. Tsru wenumta yapananumta. ");
INSERT INTO pibNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Yimaklene getinri tsru wenumta yapananumtini, kojwakanshinikanutna. Wane chinna, “¡Pagixanutkani!” Piklena saplewatna. ");
INSERT INTO pibNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Waneklu ruynumatatkana Geso. Wane chinna, “Kiglenshinikanupgi. Gitni. Gi wa mpikanu.” ");
INSERT INTO pibNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Giyagni Petro gigitlu. Wane chinru, “Gitsrukaachi, Pixa pixinipa ptomganno Pixa yegi nyinripa. Gonumta nyapamtanu.” ");
INSERT INTO pibNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Wale wane china, “Punanu.” Kanawa ruptekamtya Petro. Gonumta yapamta, Geso yegi yinripa. ");
INSERT INTO pibNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Retinitkalu gichkonnipgyalu, pikana. Yinuwaka gimxiklemtanatka. Saplewatana. Wane china, “Gitsrukaachi, pognetkakanno.” ");
INSERT INTO pibNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Waneklu Geso gomyokyegitlu. Kashichlu. Wane chinru, “Psotsotaji galixachriyi. ¿Klu chinanu maponshinikanukletyi?” ");
INSERT INTO pibNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Kanawa ruptekinitkana, rutukannipgyamtatka. ");
INSERT INTO pibNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Giyagni kanawa gwanatachine yoptsojityegitluna. Wane chinna, “Galikakpotunanni Pixni wa Goyakalu Wgenyi.” ");
INSERT INTO pibNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Koprugatinitkana, Genesarechijne rapokna. ");
INSERT INTO pibNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Yine gimatatkalu wane gajene. Yokanrewatna psolusretako walesreta. Yayixachine pejnuruneko ranikyegitluna. ");
INSERT INTO pibNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ragjitluna gimkaluptostsipje kamrukinripna. Pejnuruneko kamrukjene wanna gitskalgatka. ");
INSERT INTO pibNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Giyagni Gwariseyone, yonchikgapine Gerosale giyakatyachine gapyegitlu Geso. Wane chinruna, ");
INSERT INTO pibNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“¿Klu chinanu pyimaklene giknoklu gitsrukaachinni giykole? Gi rixanu gi rerkamyotna wa jimapro nikinna.” ");
INSERT INTO pibNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Wale gigitna. Wane chinna, “¿Klu chinanu koxa gixa giknoklu Goyakalu yokanatanru giykole chinanu? ");
INSERT INTO pibNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Gi rixanu Goyakalu wane china, ‘Pkagwakpiratanru puru, punro’ ga wa ‘Girukta kamakpirjetlu ruru, runro walepni gipnanuna.’ ");
INSERT INTO pibNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Ga wa gixa wane china, ‘Girukokta wane chinru ruru ga wa runro, “Nenekashle gixanupmaka Goyakalu nenekashatanutka, wa nenekashle gixa gipxakikolupmaka.” ");
INSERT INTO pibNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Wane gixachri gi kagwakpiratanutkalu ruru, runro.’ Wane gixa giknoklejetlu Goyakalu yokanatanru gixa giykole chinanu. ");
INSERT INTO pibNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Sanowashatachingi. Goyakalu tokanu kigle reneklewata Gisayiya gixapirana. Wane china: ");
INSERT INTO pibNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Nyi yine gispuyna kagwakpiratnona seyni rajiyna wajra yanna Gitaya. ");
INSERT INTO pibNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Magijeru yonogleyegitnona. Runkakletluna yokanrekakna yine wa Goyakalu tokanu pixkalutu.” ");
INSERT INTO pibNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Tomgana gixolune yine. Wane chinna, “Gyijnakotanu. Gimata jemanu. ");
INSERT INTO pibNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Gi wa ginama jiglokyachri puchotlu wa yineru. Seyni wa ginama gishpakyachri, walenwa puchotlu yineru.” ");
INSERT INTO pibNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Giyagni yimaklene yayegitlu. Wane chinruna, “¿Gi ge pumata wa Gwariseyone yijnakotinri wa tye tokanchi jigekanuwatna?” ");
INSERT INTO pibNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Seyni rugitna. Wane chinna, “Pejnuruko gitaakaluru ma mutakanutu Nuru tengogne Gajeru goplitkalurupni. ");
INSERT INTO pibNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Getashatanna. Maygalenkakluko koseekakachinni. Wa maygaletu kosekinmaklu maygaletu kapna rumujruukakanna.” ");
INSERT INTO pibNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Petro gigita. Wane china, “Punkakpokowakatanwu tye yapkaklu.” ");
INSERT INTO pibNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Geso wane china, “¿Wane koxa gixge gixa mumatjemkangi? ");
INSERT INTO pibNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","¿Gi ge gimata jema wa pejnuruko ginama jiglokyachri, ginanwaka ya? Rushpaka gichkajetyawaka. ");
INSERT INTO pibNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Seyni wa ginama gishpakyachri raji ruyakatya. Walenwa puchotlu yineru. ");
INSERT INTO pibNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Gi rixanu yineru gaji rushpakya mugletu shinikanchi, giylalewlu, gimopatlewlu, gapoklewlu, chowguchkaka, gixasha gipgujtalewlu, mupashiregnuchi. ");
INSERT INTO pibNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Tyekakni wa puchotlu wa yineru. Ga wa meromyogkatu nikini gi wa puchotlu yineru.” ");
INSERT INTO pibNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Wane yiyatka Geso. Tirosreta ga wa Sitosreta yatka. ");
INSERT INTO pibNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Wanero sato suxo Kanani gajero, walesreta giyakatyachro. Tsaplewjeta. Wane china, “¡Gitsrukaachi, Tawiklopisha, petwamonutanunno! Nshichni kamchichachropotuna.” ");
INSERT INTO pibNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Seyni gi satu tokanchi rugityalo. Wa yimaklene yayegitlu. Ragjitluna. Wane chinruna, “Pyokanatanro, gi rixanu tsaplewjegajxigiyakatwu.” ");
INSERT INTO pibNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Wale gigita. Wane china, “Gi wa nyokanatka, seyni wa gowegane chinanupje gamgachine Gisrayiliklopishane.” ");
INSERT INTO pibNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Giyagni tapoka. Tyoptsojityegitlu. Wane chinru, “Gitsrukaachi, pupxakanunno.” ");
INSERT INTO pibNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Rugita Wale. Wane china, “Gi kigleru wa kashichikolupa yine wgenene nikanru, kewe wgenene ruknokyegitkomka.” ");
INSERT INTO pibNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Wala wane china, “Gigi, Gitsrukaachi. Seyni wa kewene niklu rutsrukatna nikawakakwale gijrukyachripopeji.” ");
INSERT INTO pibNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Giyagni Geso gigita. Wane chinro, “¡Suxo, tsruni palixle! Wane pixikolupa palukyawaka.” Wanekluyakawa tutukawgenetatka. ");
INSERT INTO pibNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Wane yiyatka Geso. Kalile Wennespuwnaga yapa. Magka kanika. Wane tuplata. ");
INSERT INTO pibNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Rapyegitluna gixolune yine. Wannaymana myankane, maygalene, myanumatkane, mastsine, ga wa pimrine gixo. Gesojixistsi rutaakana. Wale gituukakna. ");
INSERT INTO pibNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Wane rixini ruglajitna gixolune yine, reta yanumletkana myanumatkane, ga wa mastsine kigletka, myankane yanatka, ga wa maygalene getatka. Rumalwutluna Gisrayiline Goyakalute. ");
INSERT INTO pibNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Geso tomgana yimaklene. Wane chinna, “Netwamonutna gixolune yine, gi rixanu waneyatkana mapgogne Gitayma. Maleshayna nikanruna. Gi naluka yokanretna mniikane ma mujxipakgapotinitipna.” ");
INSERT INTO pibNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Yimaklene wane chinru, “¿Ginaka gawinri wixa wane pejnu niikaluru yineru mwiyawakanuya, wunanutyapna wane pejnu gixolune yine?” ");
INSERT INTO pibNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Geso wene china, “¿Gi pejnu jimapro waneygi?” Wanna wane china, “Payokgipre ga wa psotsotaji kopaji.” ");
INSERT INTO pibNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Towutna wa gixolune yine tuplatinripna chiji. ");
INSERT INTO pibNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Kashichatkalu payokgipre jimapro ga wa shima. Poyagnutlu. Jiknajrotlu. Renekna yimaklene, ga wa yimaklene geneksatna gixolune yine. ");
INSERT INTO pibNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Pejnuruneko nikatka. Jinanutkana. Ga wa gixetachripsojkaka koshchekna payokgipre kojita katsepo. ");
INSERT INTO pibNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Wane nikyachine gepkoxamkoje waragka jejine. Gi wa kyagna suxone, gi wa mturuneko. ");
INSERT INTO pibNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Rungatkana gixolune yine. Kanawa ruptekatka. Maktalasreta yatka. ");
INSERT INTO pibNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Gwariseyone gapyegitlu ga wa Sariseyone rumlukanutyapluna. Ragjitluna rekakgityapna getkaluru tengogne gajeru chinanu. ");
INSERT INTO pibNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Seyni Wale gigitna. Wane chinna, “Wa kayi rixinitka, wane nchina gixa, ‘Kiglegogneru gi rixanu gasergogneru.’ ");
INSERT INTO pibNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ga wa goyechnokawa, ‘Xawakni ginapni,’ nchina, ‘gi rixanu gasergogneru ga wa kwamongognetaa rixa.’ Sanowashatachingi. Gimata getgogneretlu tengogne ga wa ¿gi ge gimkata gimata getletlu gipapko gimaxiklechi? ");
INSERT INTO pibNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Gimuweekakgognenatachine muglengi, kgimopatakleruneko gagjitlu getkaluru, seyni getkaluru gi wa rekakgitkona seyni Gonasu tokanchi geneklewatchri getikalurutepje.” Ruknokamtna. Yatka Geso. ");
INSERT INTO pibNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Wakanu rapokinitkana yimaklene. Ramtaka ganikletluna jimapro. ");
INSERT INTO pibNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Geso wane chinna, “Xako ggirukotinwa wa gisekachriya Gwariseyonenu ga wa Sariseyonenu.” ");
INSERT INTO pibNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Wannananuko gishinikanuwata. Wane chinna, “Gi rixanu gi waniklu jimapro.” ");
INSERT INTO pibNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Geso gimata. Wane china, “¿Klu chinanu gixnanuko gishinikanuwata wa jimapro gma manikiniti chinanu? Psotsotaaji galixachingi. ");
INSERT INTO pibNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Gi ge gimata jemawa? ¿Gi ge gishiniikoxlu wa pamyo jimapro wa pamyo waragkane chinanu, ga wa gi pejnu kojita gkoschekyalu? ");
INSERT INTO pibNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","¿Gi ge gishiniikoxlu wa payokgipre jimpro wa gepkoxamkoje waragkane chinanu, ga wa gi pejnu kojita gkoschekyalu? ");
INSERT INTO pibNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Gi gixge gi gimata jema gi wa jimapropiranni wane nchinyagi? Gimretinwa gisekachriya Gwariseyonenu ga wa Sariseyonenu.” ");
INSERT INTO pibNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Giyagni rumata jemluna gi wane chinna wa gisekachriya jimapro chinanu rumretinwana, seyni wa Gwariseyone ginkaklewleya ga wa Sariseyonenu. ");
INSERT INTO pibNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Susari Wiliponusreta yinitka, Geso gepomgana yimaklene. Wane chinna, “Wa yine ¿katu wane chinna wa Gita Yineru Wgenno nixinri?” ");
INSERT INTO pibNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Wanna wane china, “Pimrine wane china, ‘Gwa Katlewakleru.’ Ga wa pimrine, ‘Giliya.’ Ga wa pimrine, ‘Geremiya.’ Waka satu tokanchi geneklewatachri kagwakyayina.” ");
INSERT INTO pibNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Wale wane china, “Ga wa gixa, ¿katu wane chinno?” ");
INSERT INTO pibNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Rugita Simo Petro. Wane china, “Pixni Kristoyi. Goyakalu giwekachri Wgenyi.” ");
INSERT INTO pibNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Giyagni rugita Geso. Wane chinru, “Giglenshinikanyegitkaluryi Simo, Gonasu wgenyi, gi rixanu gi wa kamaneru, gi wa kagragalu gekakgityi, seyni wa Nuru tengogne Gajeru gekakgityi. ");
INSERT INTO pibNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Seyni Gita koxa wane nchinyi, pixni Petroyi, ga wa tye tsru sotlu gogotemta nkamrutanru gapatjetikowaka Gitanu. Gi wa gipnachine gishyatikowaakaako gichkolu gapatjetachine pixka. ");
INSERT INTO pibNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Pixa nenekanru kotpukapi tengogne pogirewatyawaka chinanu. Klunerukokta pixa gostutanru tyechijneya, tengogne koxa rostutiko. Klunerukokta pkaspuka tyechijneya, tengogne koxa kaspukiko.” ");
INSERT INTO pibNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Giyagni rujretna yimaklene gikena ma munkakinitipna wa Kristo rixinri. ");
INSERT INTO pibNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Wanekluyakawa Geso Kristo yinuwaka gekakgiretna yimaklene, rumkata Gerosale yaletinripa. Wane gixo salewninripa tsruneya, tsrukakalune sasertoteneya, ga wa yonchikgapineya; ruylatikolupa ga wa mapgogne rixinri yotunkakikolupa. ");
INSERT INTO pibNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Petro ganiklu. Yinuwaka chigetjeretlu. Wane chinru, “Gitsrukaachi, kigle gwalepyi. Gike pixiniko wane pixanu.” ");
INSERT INTO pibNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Giyagni Wale giprotakyegitlu. Wane chinru Petro, “Najxigi pyanutka, Satanasyo. Nutspekakjermakyi. Gi pushiniklu wa Goyakalupirana, seyni wa yinepirana galikaka.” ");
INSERT INTO pibNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Giyagni Geso wane chinna yimaklene, “Katukokta galuka gwa gajxigletno raalixinwa walenanuko. Rawanro koroshishkitate. Romkagitanno. ");
INSERT INTO pibNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Gi rixanu girukokta galuka gishatkapletlu ruwekinri, ruwekinri ramginina. Girukokta gamtakanru ruwekinri Gita chinanu, rukshikanru ruwekinri. ");
INSERT INTO pibNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Gi rixanu ¿klu gaprini wa yineru psolu chijikmaka wane rixletanu, seyni ruwekinri ramginina? Ga wa ¿klu rupekotanru yineru ruwekinripa? ");
INSERT INTO pibNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Gi rixanu nunanu Gita wa Yineru Wgenno Nuru goyaknuyma, notowreruneyma. Waneklu satkaka rixpoko kamruretyawaka napnutinitkalu. ");
INSERT INTO pibNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Galikaka wane nchingi, pimrine gewi gwachine gi getumganru gipnalu ma metkanuwalunachi Gita Yineru Wgenno ginachripatkano npogirewatyawakaya.” ");
INSERT INTO pibNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Patsrujirgogne giknoginitka, Geso ganikna Petro ga wa Santiyako, ga wa repuru Gwa. Satu magka tenolu ranikna wannapje. ");
INSERT INTO pibNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Wane wanna getanu satuko kogetkogatka. Yochiigojita tkachi pixka. Ga wa gimkalu klatpotlu pokamlalu pixka. ");
INSERT INTO pibNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Moysisi ga wa Giliya gipgujewnayegitna ruynumsanatjene. ");
INSERT INTO pibNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Rugita Petro. Wane chinru Geso, “Gitsrukaachi, kigleru gewi gawinri. Palukiniplu, wkamrutanru mapa gimajechri. Pixanupa satu, Moysisinupa satu, ga wa Giliyanupa satu.” ");
INSERT INTO pibNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Wa yanumsanatiniwa, satu kyachgapererumko katajiru chikletyegitna. Waneylu satu tokanchi kyachgapererumkoya wane chinachri, “Tyenwa Noturu nushinikanru potu. Wale gigletanshinikanutno. Wale gyijnakotanu.” ");
INSERT INTO pibNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Yijnakotinitkaluna yimaklene tye tokanchi, chiji rapokgojitna. Pikpotutna. ");
INSERT INTO pibNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Geso yayegitna. Kamrukna. Wane chinna, “Gyotunotanutka. Gi wa mpikanu.” ");
INSERT INTO pibNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Tunogitinitkana, gike retatkana. Gesopjetkani. ");
INSERT INTO pibNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Wa magka yopikinitkana, rujretna Geso. Wane china, “Gi satuna ginkakanu wa getanruya nma yotunotkanuwa Gita Yineru Wgenno gipnachinetskalaya.” ");
INSERT INTO pibNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Yimaklene gepomgalu. Wane chinruna, “¿Gi chinkoxna wa yonchikgapine wa Giliya gingapkatanu?” ");
INSERT INTO pibNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Rugita Geso. Wane chinna, “Giliya galikakni rungapkatanu rugletyaplu ptowruko. ");
INSERT INTO pibNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Seyni wane nchingi, Giliya ginpatka. Gi rumatluna. Seyni wane rixluna klunerukokta ralukyawakna. Waneko pixka rixannona Gita Yineru Wgenno. Wannaya nsalewnanu.” ");
INSERT INTO pibNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Wa yimaklene gimata jematkalu wa Gwa Katlewaklerupirana runkakletinri. ");
INSERT INTO pibNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Wa gixolune yegi rapokinitkana, runa satu jeji. Yoptsojityegitlu. ");
INSERT INTO pibNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Wane china, “Gitsrukaachi, petwamonutanru noturni. Gi rixanu popukalerunni. Yayixachrinni. Gixo kata xirnachri yana. Gixo kata gonu yana. ");
INSERT INTO pibNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Pyimaklenyegimka nanikniri. Gi rumkata gituukakletanruna.” ");
INSERT INTO pibNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Rugita Geso. Wane china, “¡Ya nyi gimuweekakgognenatachine malixkane, mpotukane! ¿Gi pejnugognenanukta numwanutkagi? ¿Gi pejnugognenanukta nakotangi? Ganikyegitanno.” ");
INSERT INTO pibNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Geso chigetjetlu kamchi. Rushpakamtatka kamchi waleya. Ga wa mturu gitukatka wanekluyakawa. ");
INSERT INTO pibNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Giyagni yimaklene gapyegitlu Geso. Wannapje rixinrina, wane chinruna, “¿Klu chinanu wixa gi gimkata giknokletlu maleka?” ");
INSERT INTO pibNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Geso wane chinna, “Gi rixanu psotsotaji galixa. Gi rixanu galikaka wane nchingi, waneygi gixkamka galixle mostasajipso pixka, wane nchinanru tye magka, ‘Wane pushpakinitka. Pnu pyanutka.’ Ga wa pnumka yanu. Gikenapmakni gma mumkatanutupmaka. ");
INSERT INTO pibNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Wa tye pixkalutu gi gishpaka seyni gagjigognerupjeya ga wa gogajirewlupjeya.” ");
INSERT INTO pibNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Kalile rapatanatinna, Geso wane chinna, “Samyookalurupno Gita wa Yineru Wgenno, yine kashichyapno. ");
INSERT INTO pibNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Ruylatannona. Mapgogne rixinri nyotunkaako.” Wanna wamonuwnapotutanna. ");
INSERT INTO pibNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Kapernawo rapokatkana. Girukotlewatachine gijgawenyegitachine ginyegitlu Petro. Wane chinruna, “¿Gyimakjeru gi ge wenutanru wa girukotlewatachine gijgawenre?” ");
INSERT INTO pibNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Petro wane china, “Gigi.” Jiglokapjimtini, Geso gapka yanumata. Wane china, “¿Gi pixka getle pixlu Simo? Tyechijne pogirene, ¿katu yoptotyalona sroschi marnewlu girukotikolu chinanu, ga wa satkaka yineru chinanu? ¿Gimolenyegiyna waka pnu gajenyegiya?” ");
INSERT INTO pibNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Petro wane china, “Pnu gajeneyegiya.” Geso wane chinru, “Giyagni gimolene gishpaka. ");
INSERT INTO pibNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Seyni wma jigekyapna, tsru wenu pyanu. Pkowchontapanu. Wa muchinanu gapka pkosetanropa, wala shima pkoschekanu. Pkomchaknamatanro. Pukshikanro sroschiproji. Wala pwanu. Penekanna Gita chinanu ga wa pixa chinanu.” ");
INSERT INTO pibNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Waneklu yimaklene gapyetitlu Geso. Wane chinna, “Giyagni ¿girni wa tsru potu wa tengogne pogirewatyawakaya?” ");
INSERT INTO pibNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Tomgalu satu mturu. Wanna ganikajite rutaklu. ");
INSERT INTO pibNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Wane china, “Galikaka wane nchingi, gma kashrijetkoklunupa, mturune pixka gma mixkanupa, gi gapokanuna tengogne pogirewatyawaka. ");
INSERT INTO pibNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Giyagni girukokta mturu rixnawa tye mturu pixka, walepni wa tsrupotupa tengogne pogirewatyawakaya. ");
INSERT INTO pibNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Girukta yoptotlu satu tye pixkalutu mturu Gita giwakaya, Gita yoptota. ");
INSERT INTO pibNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Girukokta gitspekaklu wa satu wa nyi mturune wa nalixjene Gita, kiglemkalu waleya rushriknojitikolupa wa tsru sotlu ginripiya, tsru wenu ruknokikolupa. ");
INSERT INTO pibNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","“¡Gi waneni tye psolchijne gajeneko gitspekaklu chinanu! Gi rixanu galikakni waneplu gitspekaklu, seyni ¡Gi waneni wale jeji wale chinanu runa gitspeeru! ");
INSERT INTO pibNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Giyagni wa pumyo ga wa pujixi gitspeekakinipyi pustakanru. Puknokanru pixyegiya. Kigleyyi mastsi ga wa yokmatachriyi puwekinri pjiglokinripa wanepnute gepimyo pixini ga wa gepjixi pixini, puknookona xirnachri yegi gike rixini mnikawnakatu. ");
INSERT INTO pibNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Wa puygale gitspeekakinipyi pkoshpakanru. Puknokanru pixyegiya. Kigleyyi wa puwekinri pjiglokinripa paygalepjeya wanepnute gepiygale pixini puknookona Gigena xirnachri. ");
INSERT INTO pibNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Xako gi geyikanru satu nyi mturune, gi rixanu wane nchingi Goyakalutowrerune tengogne gajene wanna chinanu psolgogneko retgojitluna Nuru tengogne Gajeru. ");
INSERT INTO pibNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Gi rixanu nuna Gita Yineru Wgenno nognetkakapyaplu gamganatachri. ");
INSERT INTO pibNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“¿Gi pixka getle gixlu gixa? Waneyapmkalu satu yineru satu pacha gowegane ga wa tamganmaka sato gowega, ¿gi ge magka ruknokamtna wa mturujmole mturuji gowegane, ga wa rujgaplo wa gamgachro? ");
INSERT INTO pibNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Wa rukshikinro, galikaka wane nchingi rumuwpotuta wala chinanu, wa mturujmole mturuji mamgakane pnute. ");
INSERT INTO pibNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Wane rixa. Giru tengogne Gajeru gi raluklu wa satu nyi mturune gamginri. ");
INSERT INTO pibNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Giyagni wa pumole mukochirewyegitinyi, pyayegitanru. Pekakgi giklukanuwnayegletanru gixapje gixini, pixa ga wa wale. Wa yijnakotinipyi, pukshikmoletatka. ");
INSERT INTO pibNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ma yijnakotkamkayi satumka ga wa gepimka panikanu pixayma, wa gepi getachine ga wa mapa pejnuruko tokanchi poyegitko. ");
INSERT INTO pibNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Wa ma yijnakotkanupna wanna, punkakanna gapatjetachine. Ga wa gapatjetachine gi yijnakotanu waneklu mjemkatu pixka ga wa gijgawenutachri pixka pixa getletanru. ");
INSERT INTO pibNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Klunerukokta gixa gostutanru tyechijneya, tengogne koxa rostutiko. Klunerukokta gkaspuka tyechijneya, tengogne koxa kaspukiko. ");
INSERT INTO pibNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Galikakni wane nchinatnakgi, wa gepi gixa wanerutu nchinanshinikanutini tyechijneya, klunerukoktapirana gagjitini, Nuru tengogne Gajeru wane gixingi. ");
INSERT INTO pibNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Gi rixanu ginakaktana gepi, mapa ngiwaka chinanu gapatachine, wanna ganikajitkoxno Gita.” ");
INSERT INTO pibNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Giyagni Petro yayegitlu. Wane chinru, “Gitsrukaachi, ¿gi pejnu kata mukochirewyegitanno nomole, ga wa gita kaspukinri? ¿Payokgipre katpotunanrege nkaspukinri?” ");
INSERT INTO pibNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Geso wane chinru, “Gi wane nchinyi wa payokgipre katpotunanuko, seyni payokgipremole payokgipre. ");
INSERT INTO pibNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Giyagni tengogne pogirewatyawaka satu jeji pixka rixa, pogirchi. Raluka giglepokletlu wayegreneyma riwishkatna. ");
INSERT INTO pibNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Yinuwaka giglepokletlu riwishkatna. Wale yegi raniika satu riwishkatachri. Gixo potu waragkaproji riwishkatachri. ");
INSERT INTO pibNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Maleshaylu wenutyaplu. Giyagni gitsrukaachi yokanatlu rushagkikolupa wale, ga wa ganunro, ga wa wugenene, ga wa pejnuruko wane rixle, wenutikolupa. ");
INSERT INTO pibNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","“Giyagni yoptsojityegitlu wayegrechri. Wane chinru, ‘Gitsrukaachi, ma pognanutupyi gitaya. Nwenutanyi pejnuruko.’ ");
INSERT INTO pibNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Giyagni gitsrukaachi getwamonutlu wayegrechri. Rushotatkalu. Kaspukyegitatkalu riwishkatyalu. ");
INSERT INTO pibNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Yatka wale wayegrechri. Rukshiklu satu waleyma wayegrechri, wale riwishkatjeru, satu pachaproji riwishkatachri. Kashiplajitanru. Kachinekanru. Wane chinru, ‘Pwenutanutkano wa priwishkatyano.’ ");
INSERT INTO pibNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","“Giyagni wa rixje wayegrechri gijixistsi yoptsojityegitlu. Ragjitlu. Wane chinru, ‘Ma pognanutupyi gitaya. Nwenutanyi pejnuruko.’ ");
INSERT INTO pibNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","“Maka wale gi galuklu. Seyni wane ya. Yoshmakikowaka rutaklu wenutinpotunanuklu riwishkatyalu. ");
INSERT INTO pibNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Giyagni retinrina rixje wayegrechine, wamonuwnapotutna. Runkakapluna rutsrukatna pejnuruko wane gixkaluruya. ");
INSERT INTO pibNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","“Giyagni repuklu rutsrukate. Wane chinru, ‘Mugletu wayegrechriyi. Pejnuruko wa tye priwishkate nkaspukyegityi gi rixanu pagjitno. ");
INSERT INTO pibNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","¿Gi ge pumkatkoxlu pixa petwamonutyalu pixje wayegrechri, wa gita pixka wane nixa getwamonretyi pixa?’ ");
INSERT INTO pibNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","“Rutsrukate gimtuwnayegitlu. Saletlewatachine yegi samyoklu wenutinpotunanuklu pejnuruko riwishkanatanru. ");
INSERT INTO pibNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","“Waneko pixka rixangi gixa Nuru tengogne Gajeru, gma kaspukiniplu satkaka gixa gajiya gimole mukochirewyegitingi.” ");
INSERT INTO pibNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Wane rixa, rali ginkakletinitka Geso tye tokanchikaka, Kalile yiyatka. Gotesreta, Gorta wakanute yatka. ");
INSERT INTO pibNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Romkagitluna gixolune yine. Wane rutuukakyana. ");
INSERT INTO pibNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Rapyegitluna Gwariseyone. Rumlukanutanruna. Wane chinruna, “¿Munanshichkotlege wa yineru ruknokagnunrotini kluneru chinanukokta?” ");
INSERT INTO pibNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Wale gigita. Wane china, “¿Gi ge getyongatlu wa kgiyaklewakleru, yinuwakyawakpotunanuko jeji, suxo kamrutna? ");
INSERT INTO pibNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Wane china, ‘Giyagni jeji rutspalitinitkana ruru ga wa runro. Rupxaletanrotkani ganunro. Wa gepinanna pamanepje rixanutkana.’ ");
INSERT INTO pibNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Giyagni gi gepitkana, seyni pamanepjetkana. Giyagni wa Goyakalu gapatanru ma mutspalkakinitipa wa yineru.” ");
INSERT INTO pibNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Wane chinruna, “¿Gi rixkoxge Moysisi yokanrewata kiruka geneekaluropa ma ganunrotyanpatkalo, ruknokyaplo?” ");
INSERT INTO pibNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Wane chinna, “Wa nshiknu gaji chinanu Moysisi gichichgi giknokagnunrotinripa. Seyni wa yinuwakyawakpotunanuko gi wane rixa. ");
INSERT INTO pibNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Gita wane china, girukokta giknokagnunrota gapoklewlumigjeya, sato ganunrotinitnaka, rumopatlewatatka. Girukokta gnunrotlo giknookaluro rumopatlewatatka.” ");
INSERT INTO pibNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Wane chinruna yimaklene, “Wane rixini jeji ganunro chinanu, gi wa kigleylu ganunrowatinri.” ");
INSERT INTO pibNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Giyagni Wale wane chinna, “Gi wa pejnuruneko gimkata yoptoletlu tye tokanchi, seyni wannapje wa geneekalunepje. ");
INSERT INTO pibNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Gi rixanu wanena mumkata gnunrowletkane runronanwakna rushpakinyakawna. Wanena mumkata gnunrowletkane wa yine wane gixkakanune. Wanena mganunrowashatkane tengogne pogirewatyawaka chinanu. Gimkata yoptoletachri yoptotanru.” ");
INSERT INTO pibNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Giyagni Geso yegi raniikana mturune rutakamyogogotyapna, ga wa ragjigognetinripa. Ga wa yimaklene chigetjetna. ");
INSERT INTO pibNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ga wa Geso wane china, “Getashatanna mturune runyegitannona. Gi gimaletanna. Wa wanna pixkalune wannanni wa Goyakalu pogirewatyawaka.” ");
INSERT INTO pibNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Rutakamyogogotna. Wane yiyatka. ");
INSERT INTO pibNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Wane rixa. Satu ginyegitlu. Wane chinru, “Yimaklewatachri kigleru, ¿klu kigleru nkamrutanu nyoptotyaplu wa nuwekinri gike rixiniko mnikawnakatupa?” ");
INSERT INTO pibNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Wane chinru, “¿Klu chinanu pepomgano kiglerupirana? Gi satuna waneru kigleru; satupjeru: Goyakalu. Wa paluka jiglokletinri giweklu, pkamrutanru yokanrukaka.” ");
INSERT INTO pibNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Wane chinru, “¿Girni?” Geso wane chinru, “Gi puylalewatanu. Gi pumopatlewatanu. Gi pchowguwatanu. Gi maleshawaka pupgujtalewashatanu. ");
INSERT INTO pibNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Pkagwakpiratanru puru, punro. Pushinikanru pumole pixananuko pixka.” ");
INSERT INTO pibNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Wane chinru makluji, “Pejnuruko tyekaka nkamrutatka nmaklutinyakawa. ¿Kluneru wanepnute nmagatya?” ");
INSERT INTO pibNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Wane chinru Geso, “Palukiniplu wa mmagatikatu pixinripa, pyanu. Pushankanru ptowruko wane pixle. Penekanna wa kwamonurune. Waneyapyi ponikowle tengogneyapa. Punanu. Pomkagitanno.” ");
INSERT INTO pibNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Wale tokanchi yijnakotinitka, ralimta wamonuwatachri, wa waneyanru gixo wane rixle. ");
INSERT INTO pibNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Giyagni Geso wane chinna yimaklene, “Galikaka wane nchingi, wa ponikolu kyaprepotlu tengogne pogirewatyawaka rapokinripa. ");
INSERT INTO pibNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Wane nchinatnakgi, myapretmakni kameyo tsapujripna tjiglokinripa, wa ponikolu pnute jiglokyaplu Goyakalu pogirewatyawaka.” ");
INSERT INTO pibNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Wa yimaklene yijnakotinri, ruglajpotutna. Wane chinruna, “Giyagni ¿katni gimkata gognetkaakota?” ");
INSERT INTO pibNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Yopukgatna Geso. Wane chinna, “Wa yineya mumkatkotni wa tye, seyni Goyakalu pejnuruko gimkata.” ");
INSERT INTO pibNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Giyagni rugita Petro. Wane chinru, “Wixa giknokamtatkalu pejnuruko. Womkagitatkayi. Giyagni ¿klu waneyapwu?” ");
INSERT INTO pibNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Geso wane chinna, “Galikaka wane nchina, wa ptowruko gerotewatinipa, wa noyaknu ntuplapijere ntuplatini Gita Yineru Wgenno, waneklu gixa koxa wa nomkagitjengi pamole gepi tuplapije, pguru tuplapijerkaka, ntuplatanu. Pamole gepinerune Gisrayiline gitakyagokanu gixa. ");
INSERT INTO pibNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Pejnuruneko girukokta giknokamtatkalu panchi, yegwakane ga wa repurune, ga wa ruru, ga wa runro, ga wa ganunro, ga wa wugenene, ga wa gichijne Gita giwaka chinanu, yoptotanru satu pacha kata pnute. Wanepnute yoptotanru ruwekinri gike rixiniko mnikawnakatu. ");
INSERT INTO pibNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Seyni gixo muchichachine gapkatpotutanu. Gapkatpotutachine wannapni wa muchichachinepa. ");
INSERT INTO pibNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Gi rixanu wa tengogne pogirewatyawaka satu yineru pixka rixa, kwangixleru. Goyechnokawpotuko yayegitna rusanate rowashate kamrurewatachinepa, kamrurewjixyapna. ");
INSERT INTO pibNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Rupiratyana wale ga wa kamrurewatachineyma pamoleprojipni pagogne. Yokanatatkana rusanate rowashate. ");
INSERT INTO pibNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","“Tenotkalu tkachi yatnaka. Retna pimrine giputu tunwanatachine, wa mkamrurewatkane. ");
INSERT INTO pibNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Wale wane chinna, ‘Gajewa. Gixa koxa nusanate gyanu. Nenekangi poyagotyawaka.’ ");
INSERT INTO pibNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","“Giyagni wanna wane ya. Tumananu kwanjixleru rumepe yaletatnaka. Ga wa kayinwaka koxa yatnaka. Waneko pixka rixatnaka. ");
INSERT INTO pibNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Rumxiikastsi tkachi yatnaka. Rukshikna pimrine tunwanatachine, mkamrurewatkane. Wane chinna, ‘¿Klu chinanu gewi psolgogneko ntunwashgognenata?’ ");
INSERT INTO pibNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“Wane chinruna, ‘Gi rixanu gi satuna kamrurewjixwu.’ “Wane chinna, ‘Gajewa gixa koxa. Nusanate gyanu.’ ");
INSERT INTO pibNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Wa kayi rixinitka kgisanateru wane chinru girukotlewjixanru, ‘Ptomganna kamrurewatachine. Pwenutanutkana kamrurna wenru. Gapkatatachine pyinuwaka wenutletanu, ga wa muchichachinpotunanuko.’ ");
INSERT INTO pibNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","“Rapokna wa rumxiikastsitka tkachi yinuwaka kamruretachine. Pamoleproji satkaka yoptota. ");
INSERT INTO pibNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Rapookoxna muchi kamrurewletachine. Kagwaka yoptoretluna wanna pnute. Ga wa wanna koxa satkaka pamoleproji yoptota. ");
INSERT INTO pibNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Rawatkalona. Kegemgayegitluna wa kgisanateru. ");
INSERT INTO pibNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Wane chinna, ‘Wa nyi gapkatatachine pshinitsonu kamrurewtapna. Ga wa wixako pixka pixna, wa gakota salewnalgognenatachinwu ga wa gemeru.’ ");
INSERT INTO pibNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Wa wale gigita. Wane chinru satu wannate, ‘Nomole, gi wa mpoyagkaakotu nixyi. ¿Gi ge pupiratyano pamoleproji chinanu? ");
INSERT INTO pibNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Ga ga pixanu pwanutka. Pyanutka. Naluka genekletkoxlu wa tye gapkatatachri pixako pixka. ");
INSERT INTO pibNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","¿Gi ge munanshichkotni wa nkamrutanru wa nalukyawaka gita wa gitanuya? ¿Waka ksotanuygalegolyi gi rixanu kiglerno gita?’ ");
INSERT INTO pibNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","“Wane rixanna muchichachine. Wannapni gapkatatachinpatka. Ga wa gapkatatachine, wannapni wa muchichachinpatka. Gi rixanu gixolunni wa tomgakalune, ga wa gi gixpotna wa tsomitkalune.” ");
INSERT INTO pibNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Gerosale kanikinpatka Geso, pamole gepi yimaklene kegnetetamnugapo ranikna. Wane chinna, ");
INSERT INTO pibNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Xani Gerosale wkanikanutka, ga wa Gita Yineru Wgenno samyookalurpatkano tsrukakalune sasertotene yegi, ga wa yonchikgapine yegi. Ruklukanuwnayegjixannona nupninripa. ");
INSERT INTO pibNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Payineko yegi samyokannona yenetyapnona, kochipjetyapnona, koroshishkita rutakyapnona. Seyni mapgogne chininri nyotunkaako.” ");
INSERT INTO pibNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Giyagni tyayegitlu Sewereyo wgenene ginro twugeneneyma. Tyoptsojityegitlu. Pagixanu tagjitlu. ");
INSERT INTO pibNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Wale wane chinro, “¿Klu paluka?” Wala wane chinru, “Wane pchinanu tuplatinripna nyi gepi nwugenene satu potuklesretate ga wa satu pkegnetesretate pogirewatyawakaya.” ");
INSERT INTO pibNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Wane chinna Geso, “Gi gimata wa gixa gagjitanru. ¿Gimkatge giiretyalo wa girapistono wa Gita girinro? ¿Gimkatge gkatletikolu wa katlu wa Gita katikolu?” Wanna wane chinru, “Wumkatlu.” ");
INSERT INTO pibNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Wane chinna, “Wa girapistono nurapre girini. Wa katlu wa Gita katikolu wale koxa gkatikolupa. Seyni wa tuplalu npotuklesretate, wa nkegnetesretate gi wa Gitanni nenekyaplu, ga wa wannanupni galpokyegitkalunepni Nuru chinanu.” ");
INSERT INTO pibNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Wa pamole yijnakotinri, rumtuwnana wa gepi moletkakachine chinanu. ");
INSERT INTO pibNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Geso tomgana. Wane chinna Wale, “Gimata wa tsrukakalune payineko yegi towutlewpotutna. Wanna gitsrukatene tsru gitaaka wanna chinanu. ");
INSERT INTO pibNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Seyni gi wane gixkakanu, seyni girukokta galuka tsru gixletnachriwa gixyegkakluko walepni wa gipxakjerupa. ");
INSERT INTO pibNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Girukokta gixyegkakluko galuka muchinanu gixletnawa, walepni gwayegrerupa. ");
INSERT INTO pibNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Gita pixka wa Yineru Wgenno gi nuna nupxakikolupa, seyni nupxaklewatinripa, nenekyaplu nuwekinri nwenutyaplu ruspakinripna gixolune yine.” ");
INSERT INTO pibNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Geriko yamtyatkana. Gixolune yine gomkagitlu. ");
INSERT INTO pibNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Gepi maygalene gatnugapostsi tuplatachine, wa yijnakotinitkana wa Geso giknoginritka, wane china sapletna, “Gitsrukaachi, Tawiklopisha, petwamonutanunwu.” ");
INSERT INTO pibNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Gixolune yine chigetjetna pochke rixinripna, seyni wanepnute saplewjetna, “Gitsrukaachi Tawiklopisha, petwamonutanunwu.” ");
INSERT INTO pibNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Wa Geso tunwata. Tomgana maygalene. Wane chinna, “¿Klu galukatka wa nixyapgi?” ");
INSERT INTO pibNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Wane chinruna, “Gitsrukachi, Wumrekgatinripa.” ");
INSERT INTO pibNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Giyagni Geso getwamonutna. Kamrukaygaletna. Wanekluyakawa retatkana. Romkagitatkaluna. ");
INSERT INTO pibNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Kayegikatkaluna Gerosale. Wetpage yana, Goliwa Magkateya. Giyagni Geso yokanatna gepi yimaklene. ");
INSERT INTO pibNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Wale wane chinna, “Tujra pokchi wunaple gyanu. Wane gikshikinro mporo kwugenero tsatkaluro, twugeneyma. Gkoshpirokanro. Ganikyegitanno. ");
INSERT INTO pibNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Girukokta wane chininipgi, ‘¿Klu chinanu gkoshpiroklo?’ Wane nchinanu, ‘Gitsrukaachi galukna. Waneklutka satkakjixanna mporone.’ ” ");
INSERT INTO pibNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Ptowruko wa tye wane gixkalurni wa poyagkakikolupa wa tokanchi geneklewatachri chinyawaka. Wane china: ");
INSERT INTO pibNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Wane pchinanro Gerosale, wa Siyo nshicho, Petanru Pogire punyegitjeru. Mayogotu, mporotji tuplatachri, ga wa mporo wgenetji. Walenwa prachi kgitjiklero wgene. ");
INSERT INTO pibNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ga wa yimaklene wane ya. Wa Geso china towutyawakpotukna rixna. ");
INSERT INTO pibNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Rawpatkalona wa mporo ga wa twugene. Sapowakatjitatkalona gimkaluyma. Wanna gogo tuplamta. ");
INSERT INTO pibNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Gixolune yine potu gikwekamkata gatnugapoya. Pimrine gistaklu gagmunasurkaka. Rukwekluna gatnugapo ");
INSERT INTO pibNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Gixolune kosekamtachine ga wa kaptomtachine saplewjenanumta. Wane chinananumtna: “¡Wuya, Tawiklopisha! ¡Gimalwutkaluru ginachri Gitsrukaachi giwakaya! ¡Wuya tengognepotuya!” ");
INSERT INTO pibNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Wa Gerosale rapokamtinitka, psolu pokchi gajeneko gimyeka. Wane chinna, “¿Katni wa tye?” ");
INSERT INTO pibNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ga wa gixolune wane china, “Tyenwa Geso, Nasare Kalilesreta giyakatyachri, tokanchi geneklewatachri.” ");
INSERT INTO pibNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Geso jiglokamta kpashiwakapji Goyakalunu. Ruknokna pejnuruneko kgishanrewaklerunni gagjijetachinni kpashiwakapjiya. Yawnajkaklo kwalkaka gipekoserojiprojitachinni, motkoko gishanretachinni tuplapijere koxa. ");
INSERT INTO pibNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Wane chinna, “Yonatkalurni: Wa nopji gagjigognewakapji chinkalurupni. Ga wa gixa wane gixatkalu gitawakapna kachowgurune gwiyawakapna.” ");
INSERT INTO pibNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Giyagni kpashiwakapji runyegityaluna maygalene, ga wa myankane. Rutuukakna. ");
INSERT INTO pibNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Tsrukakalune sasertotene ga wa yonchikgapine getlu giglajrukaka Wale kamrutanru. Ga wa mturune retna saplewjetachine kpashiwakapjiya, wane chinachine, “¡Wuya, Tawiklopisha!” Rumtuwnana. ");
INSERT INTO pibNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Wane chinruna, “¿Gi ge pjemna wane chinyawakna?” Geso wane china, “Gigi. ¿Gi ge pagogne getyongatlu: Wa mturunenamaya ga wa gashichachinenamaya puglepotutlu gimalwuru?” ");
INSERT INTO pibNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Ruknokamtna. Tsru pokchi ruyakatya. Wetaniya ya. Wane rawamta. ");
INSERT INTO pibNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Goyechnokawpotuko tsru pokchi satokatka. Nachneru. ");
INSERT INTO pibNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Retlo satopje gikera gatnugapostsi gwachro. Yayegitlo. Gike rukshikyalo. Tosurepjeni. Wane chinro, “Gi pagogneko kajpatkayi.” Wanekluyakawa tuprigamtanatka gikerni. ");
INSERT INTO pibNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Yimaklene getlo. Ruglajitna. Wane chinna, “¡Ge! ¡Wanekluyakawa tuprigamtanatka gikerni!” ");
INSERT INTO pibNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Rugita Geso. Wane chinna, “Galikakni wane nchingi, wa kalixlegi gixinipa, gi wa gnutanshinikanutini, gi wa tyepjeni wa gikerapirana wane gixanu, seyni koxa wa tye magka wane nchininiplu gixa, ‘Puxrikanu. Tsru wenu puknokinwa,’ wane rixanu. ");
INSERT INTO pibNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Wa gagjigognetinipa pejnuruko girukokta gagjita galixinri, gyoptotanru.” ");
INSERT INTO pibNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Wa kpashiwakapji yinitka, wa runkaklewanatini, rapyegitluna tsrukakalune sasertotene ga wa yine tsrutene. Wane chinruna, “¿Katu gitakyi tyeya?” ");
INSERT INTO pibNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Giyagni Geso gigitna. Wane chinna, “Gita koxa gepomgangi satu tokanchiya. Wa ginkakinipno Gita koxa ginkakangi klu nutakika tyekaka nkamrutinri. ");
INSERT INTO pibNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Wa Gwa katlewle ¿ginaka giyakatyachrini? ¿Tengogne waka yinyegiyakla?” Giyagni wannananuko gishinikanuwata. Wane chinna, “Wane wchininipmaka: Tengogne giyakatyachrini, wane chinanunwu, ‘¿Klu chinanu koxa gi galixlu?’ ");
INSERT INTO pibNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Wa wane wchininipmaka: Yine yegi giyakatyachrini, gixolune yine wpikanuna. Gi rixanu pejnuruneko kagwaklu Gwa tokanchi geneklewatachri Goyakalunu rixinri.” ");
INSERT INTO pibNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Rugitluna Geso. Wane chinruna, “Gi wumata.” Wale koxa wane chinna, “Gi Gitako ginkakangi klu nutakika tyekaka nkamrutinri.” ");
INSERT INTO pibNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“Seyni ¿gi pixka getle gixlu gixa? Gepi wgenru satu jeji. Tsru gituru rapyegita. Wane chinru, ‘Wiwi, nusanate nowashate pyanu. Tyegogne wane pkamrurewatini.’ ");
INSERT INTO pibNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","“Wale gigita. Wane china, ‘Gi jmerno.’ Seyni gowukshini renshinikanuta. Wane yatka. ");
INSERT INTO pibNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","“Gapkatatachri rapyegitatnaka. Waneko pixka chinatnaklu wale. Wale gigita. Wane china, ‘Gitapni, papa.’ Seyni gi wane ya. ");
INSERT INTO pibNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","“¿Giru wa nyi gepi ruru gishinikanru kamruta?” Wanna wane china, “Tsru gituru.” Geso wane chinna, “Galikakni wane nchingi wa gijgawenutachinni, kapoklewaklerone gixa pnute jiglokanna Goyakalu pogirewatyawaka. ");
INSERT INTO pibNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Gwa ginyegitgi poyagkaklewlugapoya. Gi wa galixlu. Ga wa gijgawenutachine ga wa kapoklewaklerone galixlu. Ga wa gixa getinri gi wa waneklu genshinikanuta wa galixyaplu.” ");
INSERT INTO pibNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Gyijnakotanru satu yapkaklu. Waneru satu jeji kgisanateru. Wale gitaklu sana gowasha. Pirijeretjetlo. Tapgatyawakapa jitota. Tenopjiru kamruta. Renekamtna sana girukotachine. Pnu yatka wajra. ");
INSERT INTO pibNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Tjirgikolustsitka wayegrene yokanyegitna sana girukotachine yegi rawapyapluna sana gwiyachritka. ");
INSERT INTO pibNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","“Ga wa sana girukotachine kashichna wayegrene. Satu kochipjetna, ga wa satu ruylatna, ga wa satu sotlujetna. ");
INSERT INTO pibNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Rumepe yokanretatnakna pimrine wayegrene muchichachine pnute. Waneko pixka rixkanna wannani. ");
INSERT INTO pibNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Gapkatatachri potu gituru yokanyegitna. Wane china, ‘Kagwakpiratanruna noturu.’ ");
INSERT INTO pibNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Wa sana girukotachine retinitkaluna gituru, wane chinkakna wannakakluko, ‘Tyenwa yoptotachripa. Wuya. Wuylaganru. Waneyapwu wa yoptotanrupmaka.’ ");
INSERT INTO pibNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","“Kashichanruna. Gowasha ruknokyanruna. Wane ruylatyanruna. ");
INSERT INTO pibNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“Giyagni wa kgisanateru gininitka, ¿gi rixanutkana wa wanna sana girukotachine?” ");
INSERT INTO pibNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Wane chinruna, “Wa gektune ruylapotutanna. Pimrine girukotachine renekamtanutnaklu sana. Wanna genekanru sana gwiyachritka topapko gapokinitka.” ");
INSERT INTO pibNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Geso wane chinna, “¿Gi ge pagogne getyongatlu wa Tokanchi Yonatkaluruya? Wa sotlu myoptotkotu kamrupjitachineya Wale gitaaka yoptowaka gitsejita. Gitsrukaachi chinanu kamrutka wa tye. Rakaglajiygaletwu. ");
INSERT INTO pibNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Giyagni wane nchingi, wa Goyakalu pogirewatyawaka konkalurupni gixyegiya. Panerune reneeko wa pogirewatyawaka kamrure kamrutachinepa. ");
INSERT INTO pibNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Katupnikta tye sotlu gitspetanuna rumlokpotutanuna, ramgapotutanuna. Ga wa tye sotlu gijrukgogotanrunapa ramgapotutanuna.” ");
INSERT INTO pibNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Wa tsrukakalune sasertotene ga wa Gwariseyone yijnakotinitkalu yapkaklukaka Wale chinyawaka, rumatluna wannapirana china yanumsaletinri. ");
INSERT INTO pibNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Rujgaluna gi rixpoko kashretyapluna, seyni gixolune yine pikna, gi rixanu tokanchi geneklewatachri kagwakyaluna. ");
INSERT INTO pibNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Rugita Geso. Yapkaklu runkakyatnakna. Wane china, ");
INSERT INTO pibNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Tengogne pogirewatyawaka satu jeji pixka rixa pogirchi. Kashimyolu kamrutyalu gituru. ");
INSERT INTO pibNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Wayegrene yokanata tomgiyapna chanixkalune kashimyolu yegi. Seyni gi raluka ginretna. ");
INSERT INTO pibNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","“Rumepe yokanretatnakna pimrine wayegrene. Wane china, ‘Ginkakapanna chanixkalune, “¡Getanru xani! Ralixatka nnijitu nwakate jejine ga wa nuxowaakakanune giylatkalunetka. Pejnuruko galpokotkalurutkani. Ginanu kashimyolu yegi.” ’ ");
INSERT INTO pibNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","“Wanna gi jemlu, seyni ralimtna. Satu rusanate ya. Ga wa satu marnewjetyawaka ya. ");
INSERT INTO pibNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Pimrine kashwayegretanruna wale wayegrene. Rektutetkanna ga wa ruylatkanna. ");
INSERT INTO pibNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Ga wa pogirchi yijnakotinri wa tyepirana, jigekanuwata. Yokanatna solalotene. Ruylajixanna wa nyi kgiylalewaklerunni. Yochpikpokchitanna. ");
INSERT INTO pibNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“Giyagni wane chinna wayegrene, ‘Wa kashimyolu galikaka galpokotkalurni, seyni wa chanixkalune gi wa rumuklunina. ");
INSERT INTO pibNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Giyagni gajewa. Rutspalgapotyawaka gyanu. Nchanixanna ginnakokta gikshikanune, kashimyolu yegi yinripna.’ ");
INSERT INTO pibNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Yatkana wanna wayegrechine. Wa gatnugapkaka yana. Rapatjemtkana pejnuruneko rukshikanunna mugleneymananuko ga wa kiglerune. Ga wa kashimyolu yegi yomitna nachnewatachine. ");
INSERT INTO pibNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Jiglokamta pogirchi retyapna wa nachnewatachine. Wane retyalu satu jeji kashimyolu getachinemkalu mutaakatu. ");
INSERT INTO pibNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Wane chinru, ‘Nomole, ¿gi pixpoko jigloklemta gewi wa kashimyolu getachrimkalu mutaakatyi?’ “Seyni wale pochke. ");
INSERT INTO pibNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Giyagni pogirchi wane chinna wa kamrurewyegitjene, ‘Gostujixitanru, ga wa gostumyotanru. Maleka giknokaganru mapshagawaka.’ Waneplu chiyaglu ga wa gashkaygitlu. ");
INSERT INTO pibNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","“Gi rixanu gi gepikna chanixkalune, ga wa gi gixna tsomitkalune.” ");
INSERT INTO pibNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Giyagni wane yana Gwariseyone. Jemanshinikankakna wa kashtokanutyapluna. ");
INSERT INTO pibNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Yimaklenna yokanyegitluna Giroreyoneyma. Wane chinna, “Yimaklewatachri, wumatyi Pixni mayrokletu. Galikaka potu punkaklewata Goyakalu gatnugapotepirana. Gike pkagwakpirata, gi rixanu gi putakyagokna jejine. ");
INSERT INTO pibNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Giyagni punkakanwu. ¿Gi pixka getle pixlu Pixa? ¿Wa munanshichkotnige Goteyone genekyaplu wenrukaka wa Pogirchi Susa waka gike?” ");
INSERT INTO pibNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Seyni Geso gimatlu wanna muglenu. Wane china, “Sanowashatachingi, ¿klu chinanu gimlukanutno? ");
INSERT INTO pibNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Gekakgitanno wa sroschiproji Susa wenutikolupa.” Ranikyegitluna paproji. ");
INSERT INTO pibNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Wane chinna Wale, “¿Katunni wa tye yaglu ga wa toyonga?” ");
INSERT INTO pibNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Wane chinruna, “Susa yagluni ga wa Susa yongani.” Giyagni wane chinna, “Giyagni genekanru Susa Susanni, ga wa Goyakalu Goyakalunu.” ");
INSERT INTO pibNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Yijnakotinitkaluna, ruglajitna. Kaspukamtatkaluna. Yatkana. ");
INSERT INTO pibNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Walegogne rapyegitluna Sariseyone, wane chinachine maleshlu yotunrupa gipnachineya. Repomgaluna. ");
INSERT INTO pibNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Wane chinna, “Yimaklewatachri, Moysisi wane china: Mwugenetniko gipninina satu, wa repuru gwanro wale gnunronanni, ruxolewnakakinripa giklopishapa yegwakluni chinanupa. ");
INSERT INTO pibNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Wixa yegi wanena payokgiprerune moletkakachine. Muchinanu tsru gnunrowata. Waleni gipnanuna muknokawgenetkatniko. Repuru gwatnaklo. ");
INSERT INTO pibNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Waneko pixka rixana gapkatatachrini, ga wa mapa rixinrini, ga wa payokgiprepotunanniko. ");
INSERT INTO pibNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Pejnurunniko gipnanatka. Tapkata gipukatanatka suxni. ");
INSERT INTO pibNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Giyagni wa yotunruklupa ¿giru gnunropni wa payokgiprenni gnunronanni? Gi rixanu pejnurunenniko gnunronanni.” ");
INSERT INTO pibNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Giyagni rugita Geso. Wane chinna, “Gixa pupjeta gi rixanu gi gimatlu wa tokanchi yonatkaluru gi wa Goyakalu giyaklewleko. ");
INSERT INTO pibNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Gi rixanu yotunruklupa gi wa jejineko gnunrowatanu. Gi wa suxoneko gnuruwatanu, seyni tengogne gajene Goyakalutowrerune pixka rixanutkana. ");
INSERT INTO pibNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Wa yotunotachinepa gipnachinepirana, ¿gi ge getyongatlu wa tokanchi Goyakalu chinyawakgi? ");
INSERT INTO pibNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Gitni wa Gawra Goyakalute, Gisaka koxa Goyakalute, ga wa Gakowo koxa Goyakalute.’ Gi wa gipnachine Goyakalutni, seyni giwekachine Goyakalute.” ");
INSERT INTO pibNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Wa yijnakotinitkaluna gixolune yine, ruglajitna wa runkakyana. ");
INSERT INTO pibNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Giyagni wa Gwariseyone yijnakotinri Wale kochrokna Sariseyone, rapatjetna wanna mkoje. ");
INSERT INTO pibNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Satu wannanyi yonchikgapine gepomgalu. Rumlukanutyaplu, repomgalu. Wane chinru, ");
INSERT INTO pibNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Yimaklewatachri, ¿girni wa tsru potu Yokanatkaluru Tokanchi pejnuruko pnute?” ");
INSERT INTO pibNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Rugitlu. Wane chinru, “Pushinikanru Gitsrukaachi Poyakalute psolpotuyako pajiya, psolpotuyako punshinikanuya, psolpotuyako pushinikanutletanruya. ");
INSERT INTO pibNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Tyenwa tsru potu ga wa muchinanu yokanru. ");
INSERT INTO pibNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ga wa gepi chininri tye pixka rixa: Pushinikanru pumole pixnanuko pixka. ");
INSERT INTO pibNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Wa tye gepi yokanru chinanni pejnuruko Tokanchi Yokanatkaluru ga wa tokanchi geneklewatachine chinyawaka.” ");
INSERT INTO pibNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Rapatanatinna Gwariseyone, Geso gepomganna. ");
INSERT INTO pibNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","Wane chinna, “¿Gi nchina gixa wa Kristoya? ¿Katuklopishni?” Wane chinruna, “Tawinu.” ");
INSERT INTO pibNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Wane chinna Wale, “Giyagni ¿gi rixa Tawi wa Giwekikaluruya wane chinru Gitsrukaachi? Wane china: ");
INSERT INTO pibNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Gitsrukaachi wane chinru Nutsrukate, ‘Ptuplatanu npotuklesretate, wa nutakinpotukna Pixa kamnixjene pujixipta rapukote.’ ");
INSERT INTO pibNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Giyagni waleko Tawi wane chininri Gitsrukaachi, ¿gi rixpokotyawaka giklopishayapni?” ");
INSERT INTO pibNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Gi satuna gimkata gigletokanutlu. Walegognekakayakawa gi satuna tserpiranawata gepomgaletlu wanepnute. ");
INSERT INTO pibNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Giyagni gixolune yine yanumyegita Geso, ga wa yimaklene koxa. ");
INSERT INTO pibNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Wane chinna, “Moysisi tuplapijere tuplatna yonchikgapine ga wa Gwariseyone. ");
INSERT INTO pibNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Giyagni pejnuruko chinyawakgina gkamrutyaplu, wale gkamrutanu. Seyni gi wa kamrutyawakna gkamrutanu gixa. Gi rixanu wane chinna, seyni gi wane rixa kamruretluna. ");
INSERT INTO pibNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Gi rixanu rumlutluna ginolu, kyapre ganikolu. Wale rutjikaakana yine. Seyni wannako gi wa gimyojiyakna raluka komyekletyaluna. ");
INSERT INTO pibNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","“Ga wa pejnuruko kamrurna wane rixna wa retikolupa yineya. Gi rixanu tserutamtapotutlona yoptoyegitjerna yonchimta. Tserutluna gimkaluptostsimta gwachri. ");
INSERT INTO pibNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ralukluna tsrukakalune tuplapijere meyiwluya, ga wa tsrune tuplapijere ginkaklewawakapji gajerkaka. ");
INSERT INTO pibNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Ralukluna giputuya ralukikolna, ga wa yine wane chinyapna, ‘Rawii, Rawii.’ ");
INSERT INTO pibNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Ga wa gixa gi wa ‘Rawi’ nchinko, gi rixanu satupjeru gyimakjeru wa Kristo ga wa pejnurunekgi gixa moletkakachingi. ");
INSERT INTO pibNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Gi satuna gixa ‘nuru’ nchinanu tye chijiya, gi rixanu satupjeru Giru tengogne Gajeru. ");
INSERT INTO pibNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Gi wa kgiykolewaklerune nchinko gi rixanu satupjeru giykotjeru. Walenwa Kristo. ");
INSERT INTO pibNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Wa tsru potu gixa yegi gajeru, gipxakjerupni wale. ");
INSERT INTO pibNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Gi rixanu girukokta tsru potu gixnawa, walepni wa mturupotupa. Girukokta walenanuko mturu potu gixnawa walepni wa tsru gitaako. ");
INSERT INTO pibNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“¡Gi waneni gixa yonchikgapingi, ga wa gixa Gwariseyone, sanowashatachingi! Gi rixanu gixni wa gishyatlu wa tengogne pogirewatyawaka yinyegiya. Gi rixanu gi wa gixako jigloka. Gi koxa gichi jiglookakletna jiglokachinmaka. ");
INSERT INTO pibNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","¡Gi waneni yonchikgapingi, ga wa gixa Gwariseyone sanowashatachingi! Gi rixanu gkonapjijetanna gipnagnurutachronni. Gixashleya gogagjirgognerkakgi. Giyagni giklukanuwnapotutanuna. ");
INSERT INTO pibNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“¡Gi waneni yonchikgapingi ga wa Gwariseyone, sanowashatachingi! Gi rixanu tsru wenu ga wa popriwaka chiji gyotaljeta gixa, satupje Goteyo gitaknachriwa gixkakyapa. Ga wa wane rixkoklunu, wane gixkaklu Gigena xirnachri gajeru pixkalutu gixa pnute gepi kata rixanu. ");
INSERT INTO pibNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“¡Gi waneni gixa! Maygalenekgi kosekachingi. Wane chinachingi, ‘Girukokta wa kpashiwakpotugruko kawchinanu koschekachri, gike rixa. Seyni girukokta wa kpashiwaka potu gajero kori kawchinanu koschekachri walenwa giklukanuwnachrini.’ ");
INSERT INTO pibNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","¡Seprolokachingi ga wa maygalengi! Gi rixanu ¿girni wa tsrupotu? ¿Waka kori waka kpashiwaka potu wa kori kpashiri rixikowaka? ");
INSERT INTO pibNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ga wa, Girukokta gima wa genekashlu yochpikjetikowakakwa kawchinanu koschekachri, gike rixa. Seyni gima girukokta wale gogo gwachri genekashlu kawchinanu koschekachri, walenwa giklukanuwnachrini. ");
INSERT INTO pibNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Maygalengi, ¿girni wa tsru potu: genekashlu waka yochpikjetikowakakwa wa genekashlu kpashiri rixikowaka? ");
INSERT INTO pibNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Wa yochpikjetikowakakwa kawchinanu koschekachri, gikwa kawchinanu koscheka ga wa waleymananuko pejnuruko walekwa gwachri kawchinanu. ");
INSERT INTO pibNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Kpashiwakapji kawchinanu koschekachri, walepji kawchinanu koscheka ga wa walepji Gwachri kawchinanu. ");
INSERT INTO pibNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Tengogne kawchinanu koschekachri, Goyakalu tuplapijere kawchinanu koscheka ga wa wale gogo Tuplatachri kawchinanu. ");
INSERT INTO pibNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“¡Gi wanengi gixa, yonchikgapingi ga wa Gwariseyongi! Gi rixanu pamolete gwenutyalu pgamlusureru, ga wa ganisiji, ga wa kominoji, ga wa gkaspuklu wa tsru potu yokanru Yokanatkaluru Tokanchi chinyawaka. Walenwa poyagkaklewlu, getwamonrewlu, ga wa galixlewlu. Tyekaka gimkata kamrureta. Gi wa pimri koxa gkaspuka kamruretanu. ");
INSERT INTO pibNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","¡Maygalenekgi kosekachingi! ¡Yosla gixirikachine pixkagi gixa, ga wa kameyo gnikloka! ");
INSERT INTO pibNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“¡Gi wanengi gixa, yonchikgapingi, Gwariseyongi! Sanowashatachingi. Gi rixanu mpowratlu kolpeto rogote ga wa kajpapago rogote, seyni gitokoya katsepoylu chowguchi ga wa makotnachinwa. ");
INSERT INTO pibNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Gwariseyo maygaletyi, muchinanu gapka powratanru kolpeto gitokote ga wa kajpapago gitokote, wa rogo gajeru koxa powra rixinripa. ");
INSERT INTO pibNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“¡Gi wanengi gixa yonchikgapingi ga wa Gwariseyongi! Sanowashatachingi. Gi rixanu wane pixka gixachingi, yomlechkaka galatawnachri. Maleka galikaka retika kiglepotlu. Ga wa gitoko katseplu gipnachrigapu ga wa pejnuruko kapcholu. ");
INSERT INTO pibNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Waneko pixka gixa gixa koxa. Maleka galikaka yine getyawakgi poyagkakachinepgutgi. Seyni wa gitokoteya katsepoygi nsanowashle ga wa gmukochire. ");
INSERT INTO pibNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“¡Gi wanengi gixa, yonchikgapingi ga wa Gwariseyongi! Sanowachatachingi. Gi rixanu gixa kamrutlu wa Goyakalu tokanu geneklewatachinni kapnatikowaka. Gigletlu poyagkakachinni yomle. ");
INSERT INTO pibNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Wane chinachingi, ‘Wutsrukatenniklu gawkamka koxa wixa, gi wa wupxakmakna Goyakalu tokanu geneklewatchinni giylatikolu.’ ");
INSERT INTO pibNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Wane gixa gipgujtaletnawa wa Goyakalu tokanu geneklewatachinni giylatachineklopishangi. ");
INSERT INTO pibNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Gixa koxa poyagkakanru gitsrukatenni yaglu. ");
INSERT INTO pibNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“¡Gimnu pixkalungi! ¿Gi gixpoko gasukletinri Gigena xirnachri giklukanuwnayegjixikolupa? ");
INSERT INTO pibNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Giyagni Gita yokanyegitgi Goyakalu tokanu geneklewatachine, ga wa kgimatkalerune, ga wa yonchikgapine. Pimrine wanna giylatanu gixa. Koroshishkita gitakanna. Pimrine wanna gkochipjetanu ginkaklewawaklepjiya. Papokchimnunanuka gkojwakinna. ");
INSERT INTO pibNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Wa gixa giklukanuwninripa pejnuruneko poyagkakachinegraga, chiji gipkaakalurugraga, wa Gawili poyagkakachrigragakluyakawa Sakariygragaklupotunanuko, Warachi wgene, wa gixa giylatanruna kpashiwakpotugruko ga wa yochpikikowakakwa ganikajiteswa. ");
INSERT INTO pibNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Galikaka wane nchingi, wa nyi gimuweekakgognenatachine giklukanuwna pejnuruko tyekakaya. ");
INSERT INTO pibNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“¡Gerosale, Gerosale! Goyakalu tokanu geneklewatachinni giylatachriyi. Ga wa pyokanyegitikolunni sotlujetachriyi. ¡Gi pejnu katananukta naluka gapatjewgenretyi, gaxawripa pixka tapatjewgeneta! Tomejimpuko tutakna. Ga wa pixa Gesosale gajengi gi galuklu. ");
INSERT INTO pibNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Gwiyawakapjikaka giknokamtanuna gixapni. ");
INSERT INTO pibNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Gi rixanu wane nchingi, xaniyakawa gi getanutkanno wa gixa wane chininpotunanuko: Giglenshinikanyegitkalurni Gitsrukaachi giwaka ginyachri.” ");
INSERT INTO pibNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Kpashiwakapji rushpakamtya Geso. Yatka. Rapyegitluna yimaklene, rekakgityapluna kpashiwakapjikaka. ");
INSERT INTO pibNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Geso wane chinna. “¿Getluge tyekaka? Galikaka wane nchingi, gi wa rutukanuna sotlu rogotkakinripa, gi wa mujroleekatunpakni.” ");
INSERT INTO pibNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Goliwa Magkate tuplata. Yayegitluna yinaklene wanna mkoje. Wane chinruna, “Punkakanwu. ¿Giklupni wa tyekakapa? ¿Klu getkaluru wanepa wa puninipa ga wa yoptukgognetyawakapa?” ");
INSERT INTO pibNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Rugita Geso. Wane chinna, “Xako gi satunako yokwitangi. ");
INSERT INTO pibNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Gi rixanu gixo ginanu ngiwakaya. Wane chinachinepa, ‘Gitni wa Kristo.’ Gixopni yokwitanna. ");
INSERT INTO pibNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Gyijnakotanutkalu giylalupirana ga wa pogiwlesha giylalupirana. Gi gkegeknanuwatanu. Rumkata wane gixleta, seyni gi wa yoptukyawakapnichi. ");
INSERT INTO pibNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Gi rixanu yotunyegkakanna pachijne gajene pachijne gajene yegi ruylakakinripna. Ga wa pogirewatyawaka gajene yotunyegkakanna pogirewatyawaka gajene. Waneplu nachlukaka ga wa giyolikchijrukaka pachijnemnunanukaya. ");
INSERT INTO pibNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Tyekakapni pejnuruko muchichachripa wa kachinolkakapa. ");
INSERT INTO pibNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Wanepnute gixapni samyokalunenapgi nsaletikolupa ga wa giylatikolupa. Ga wa gayegixko payinemnunanukoya Gita giwaka chinanu. ");
INSERT INTO pibNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Giyagni gixopni gitspekaakona. Samyookakanna. Rayegixkakanna. ");
INSERT INTO pibNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Rupgujewnanna wanna migje Goyakalu tokanu geneklewatachine. Yokwitanunna gixoni. ");
INSERT INTO pibNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Mukochri gixolewnakalu chinanupa, gixopni masata galuklewletannatka. ");
INSERT INTO pibNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Seyni wa kashnantakanshinikanutachripa yoptukyawakapotunanuko wale gognetkaako. ");
INSERT INTO pibNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Muchinanu ptowruneko payinerumnunanuka runkakikolupna Kiglerpotunanu Tokanchi pogirewatyawakapirana. Waneklupatkani yoptukyawakapa. ");
INSERT INTO pibNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Giyagni getinpatkalu gagnanutkaluru gimtuklewatachri potu, Ntanyili, Goyakalu tokanu geneklewatachri chinyawaka, kpashiwakapji rawanatini, ");
INSERT INTO pibNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","(Wa getyongatachripa gimata jemanru), waneklu Gote gwachinepni gasukanuna. Magkakaka yanna. ");
INSERT INTO pibNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Panchi gogoshrichi gwanatachripa gi gijrukanuna ranikyaplu gipji gajeru. ");
INSERT INTO pibNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Wa sana gwachri gi wa satkapanu rawapyaplu gimkalu. ");
INSERT INTO pibNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","¡Gi waneni wa kamshironepni wa gashichakachinepni wale gognekakpatka! ");
INSERT INTO pibNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Gagjigognetanu gi waneyapgi ginapuklu gasuktalu, gi wa gapnanutikalurgogneko. ");
INSERT INTO pibNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Gi rixanu wanepatkalu tsru salewakchi wa mwajejetkatu reyinuwakletinitkalu tye psolchijneko ga wa xanigognenanu salewakchi. Gi wane rixanu. ");
INSERT INTO pibNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Wa Gitsrukaachi ma sustakanmaklu walegognekaka gi pamanenupnikmaka gishatkapkona, seyni tsomitkalune chinanu sustaklu walegognekaka. ");
INSERT INTO pibNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Giyagni satu wane chininipgi, ‘Gewru Kristo,’ ga wa wane chininipgi, ‘Ga ga waneru,’ gi wa galixanu. ");
INSERT INTO pibNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Gi rixanu rupgujewnanna wale migje Kristone, ga wa wanna migje Goyakalu tokanu geneklewatachine. Kamrutanruna tsru getkalurkakapa ga wa koglajrukakapa yokwitikolupmakna tsomitkalune wa rumkatmaka wane gixleta. ");
INSERT INTO pibNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Xani nunkakatkagi ma mapookanuwa. ");
INSERT INTO pibNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Giygani girukokta wane chininipgi, ‘Wane rawa, yineru mwiyawakanumka,’ Gi wane gyanu. Ga wa ‘Gitokogruko rawa,’ gi galixanru. ");
INSERT INTO pibNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Gi rixanu, wa rawrakle pixka rixanu, tkachi gishpatyawakasreta rawrakini pixka ga wa rumxityawakasretpotunanuko pokamlata, wane pixka nixa ginretanu Gita wa Yineru Wgenno nuninipa. ");
INSERT INTO pibNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Gi rixanu ginakakokta rawmanetanu gipnachri, wane rapatjetinna klatatalune. ");
INSERT INTO pibNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Wa ruknoginitka tyegogne gajeru salewakchi, waneklu: Ruchpokanu tkachi. Ga wa ksuru gi wa pokamlatanu. Ga wa tengogne tujirotini katagirkaka. Wa gichkolkaka tengogne gajeru kowshiwshitko ");
INSERT INTO pibNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","“Wanepnute tengogne rupgujewninitka Gita Yineru Wgenno yigapkakle. Giyagni kegeknanuwatanna payinerumnunanuko tye psolchijne gajeruko. Retinpatkanona Gita Yineru Wgenno ginachripatkano. Tengogne gajeru kyachgapererumko numunanu. Tsru nuyakle, tsru noyaknu numunanu. ");
INSERT INTO pibNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Nyokanatanna notowrene. Tsro pogimnupotuplo kowgimayma nyokanatanna. Wanna gapatjetanna ntsomitanune gepkoxamkojesretayako, yoptukyawakapotunanuko tengogne ga wa pasreta yoptukyawakpotunanuko. ");
INSERT INTO pibNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Gimatanru yapkaklu gikerapiranaya. Wa tyosnuygalejiplutinitka, tupcheksuretinpatka, gimatanutkalu wa walapustsitkani. ");
INSERT INTO pibNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Waneko pixka gixanu gigognepirana. Getinpatkalu wane gixlutkani tyekaka, gimatanutkalu gi gowukpatkalu. Gipgyaptostsitkalu. ");
INSERT INTO pibNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Galikaka wane nchingi, gi ruknoganu tye gimuweekakgognenatachinesha wa ptowruko tyekaka ma mixkanuwa. ");
INSERT INTO pibNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Wa tengogne ga wa chiji giknoganu, seyni wa ntokanu gi giknoganu. ");
INSERT INTO pibNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Seyni walegogne, wale gipapko, gike gimata, gi wa Goyakalu towreruneko tengogne gajene, gi wa Gituruko, ga wa Girchipje galikaka gimata. ");
INSERT INTO pibNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Gi rixanu Nowgogneklu pixka nixa gapokletanu Gita Yineru Wgenno. ");
INSERT INTO pibNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Gi rixanu wa gonnewlu ma mapookanuwagognekaka wane rixa nikletna, rurna, ganunrowatna, ga wa ganuruwatna wa Nowe jiglokingognepotunanuklo pumlekwa. ");
INSERT INTO pibNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Gi rumatna rapokinipotunanuko gonnewlu ga wa ranikanna pejnurunniko. Wane pixka rixanu napokinipa Gita Yineru Wgenno. ");
INSERT INTO pibNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Giyagni gepi jejine sana gwanatanu. Satu ganiika ga wa satupni giknokamtkona. ");
INSERT INTO pibNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Gepi suxone ginripagita satu ginripiya. Sato ganiika. Satopni giknokamtkona. ");
INSERT INTO pibNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Giyagni gixa giyokanu. Gi rixanu gi gimata girugogne runanu Gitsrukate. ");
INSERT INTO pibNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ga wa gimatanru wa tye. Wa kwangixlerupji gimatkamka girpapko runinripa kachowguru, ruyokanmaka. Gi retashatanmaklu kotamgiyaplu gipji. ");
INSERT INTO pibNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Giyagni galpokotinwa gixa koxa, gi rixanu gi gimata gixa girpapko nunanu Gita Yineru Wgenno. ");
INSERT INTO pibNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Giyagni ¿girupni wa wayegrechri gaponshinikanutkaluru ga wa kshinikanuru? Wale rutakamta rutsrukate gipji gajene chinanu, wale geneka nikletyapna nikjetinnapapko. ");
INSERT INTO pibNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Giglenshinikanyegitkaluru wale wayegrechri wa runini rutsrukate rukshikyaplu wane gixanatachri. ");
INSERT INTO pibNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Galikaka wane nchingi pejnuruko wane rixle chinanu rutakanru. ");
INSERT INTO pibNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Ga wa gektutu wayegrechri wane chinanutka rajiya, ‘Ramga ginreta Nutsrukate,’ ");
INSERT INTO pibNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Yinuwaka giylakletletna ruwayegretkone. Nika, ga wa rura gimetachineyma. ");
INSERT INTO pibNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Wale wayegrechri gitsrukate ginanu. Ma kagwakgognetinitgogne, runanu. Ma mumatinpapko runanu. ");
INSERT INTO pibNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Kochipjepotutanru. Sanowashatachineyma rutakanru walenupa. Waneplu chiyaglu ga wa gashkaygitlu. ");
INSERT INTO pibNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Giyagni tengogne pogirewatyawaka pamole maklojine pixka rixanu. Wanna koscheklo yochpiikalurkaka wannanuko. Rushpakamtna yoptotapyapatkaluna gnunrowatachripa. ");
INSERT INTO pibNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Pamyona manshinikanurone, ga wa pamyo koxa kanshinikanurone. ");
INSERT INTO pibNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Giyagni wa manshinikanurone koscheklo yochpikjetanrona, seyni gi ranikluna ringi. ");
INSERT INTO pibNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Seyni wa kanshinikanurone ganiklu ringi pastonoya yochpikjetkaluroyma. ");
INSERT INTO pibNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Ramganatinikopshini gnunrowatachripa ruxapnewanatna, rutnonatna pejnuroneko. Rumkanatna. ");
INSERT INTO pibNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Ganikajyechno jemka saplechi wane chinachri, ‘¡Tyepatkani! Gnunrowatachripatkani. Gishpakanu. Gyoptotapanru.’ ");
INSERT INTO pibNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","“Giyagni pejnuroneko maklojine yotunota. Ruglepokotlona yochpikjetanrona. ");
INSERT INTO pibNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Giyagni manshinikanurone wane chinna kanshinikanurone, ‘Psoji genekanunwu gringite. Wa wyochpikjetanro giwniyanatkawu.’ ");
INSERT INTO pibNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","“Seyni wa kanshinikanurone gigitna. Wane chinna, ‘Gike. Gi getko poyagotanu wixa chinanupa ga wa gixa chinanu koxa. Seyni gagjitapangonuklu gixanupa wa ragjijetikowakaya.’ ");
INSERT INTO pibNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","“Ragjitapakopshinruna rapokatka gnunrowatachripa. Ga wa galpokonatachinetka jiglokamtatkaluna kashimyolu yegi. Rushyatkatka gipgyapto. ");
INSERT INTO pibNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Gowukshini pimrone gina maklojine. Wane chinna, ‘Gitsrukaachi, gitsrukaachi, pkotpukyegitanunwu.’ ");
INSERT INTO pibNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","“Rugita wale. Wane china, ‘Galikaka wane nchingi, gi numatgi.’ ");
INSERT INTO pibNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","“Giyagni giyokanu. Gi rixanu gi gimatlu gigogne, gi wa gipapkoko. ");
INSERT INTO pibNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Gi rixanu tengogne pogirewatyawaka satu jeji pixka rixa wajra yachri. Tomgana wayegrene. Renekamtna wane rixle. ");
INSERT INTO pibNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Satu reneka satu pacha waragkaproji, ga wa satu gepkoxamkojemole waragkaproji, ga wa satu gepmole waragkaproji. Satkaka rumkatyawaka renekna. Wajra yatka. ");
INSERT INTO pibNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Wa satu pacha waragka yoptotachri ralimta. Marnewatatka. Walaya satu pacha waragkatnaka yoptotatnaka. ");
INSERT INTO pibNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Waneko pixka rixa wa gepkoxamkojemole waragkaproji waneyalutu. Gepkoxamkojmole waragkatnaka yoptotatnaka. ");
INSERT INTO pibNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ga wa gepmole waragkaproji yoptotachri ralimta. Jitotlu chiji. Yogimatatkalo rutsrukate serojiprojite. ");
INSERT INTO pibNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Gowukshini potu runa wanna wayegrechine gitsrukate. Ruglepokotluna kwentatna. ");
INSERT INTO pibNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Rapoka satu pacha waragkaproji yoptotachri. Raniklo pimro satu pacha waragkaprojitnaka. Wane china, ‘Gitsrukaachi, satu pacha waragka penekamtno. Petanu. Pimro satu pacha waragkaproji nyoptotatnaka walaya.’ ");
INSERT INTO pibNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","“Rutsrukate wane chinru, ‘Poyagnu, wayegrechri kigleryi ga wa poyagkakachriyi. Psotsotaji putakika poyagkakachriyi. Gixo potu chinanu nutakinyi. Putsrukate gimuwatyawaka pjiglokanu.’ ");
INSERT INTO pibNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Rapoka koxa gepkoxamkojmole waragkaproji yoptotachri. Wane china, ‘Gitsrukaachi, gepkoxamkojmole waragkaproji penekamtno. Petanu. Pimro gepkoxamkojmole waragkaproji nyoptotatnaka walaya.’ ");
INSERT INTO pibNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","“Rutsrukate wane chinru, ‘Poyagnu, wayegrechri kigleryi ga wa poyagkakachriyi. Psotsotaji putakika poyagkakachriyi. Gixo potu chinanu nutakinyi. Putsrukate gimuwatyawaka pjiglokanu.’ ");
INSERT INTO pibNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Rapoka koxa gepimole waragkaproji yoptotachri. Wane china, ‘Gitsrukaachi, numatyi jeji shiko gajiryi. Pma mutaklewatyawakanu pjirgiya. Pma muknokajityawakanu papatjetya. ");
INSERT INTO pibNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Npika. Nalimta. Nyogimatlo pserojiprojite chiji gitokote, wa gepmole waragkaproji. Waneyyi wa pixanu.’ ");
INSERT INTO pibNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Rugita rutsrukate. Wane chinru, ‘Wayegrechri mugletyi ga wa ma mernuwatachriyi. ¿Pumatmakge wa nma mutaklewatyawakanu njirgiya, nma muknokajityawakanu napatjetya? ");
INSERT INTO pibNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Giyagni pumkata gitakletlo nserojiprojite kgipekoklerune yegi, wa napokini nyoptotanmaklo gitanuko ga wa gixolewnachroymananuko.’ ");
INSERT INTO pibNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","“ ‘Giyagni gkonanro waleya gepimole waragkaproji. Wa satu pacha waragkaproji waneyalutu genekanro. ");
INSERT INTO pibNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Gi rixanu waneyalutu psoluko reneeko. Ruxolewnayegitanru. Ga wa waneyamigjetu, wane rixleko koniko. ");
INSERT INTO pibNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ga wa wayegrechri gike gapri migje maleka mapshagawaka giknokanru. Waneplu chiyaglu ga wa gashkaygitlu.’ ");
INSERT INTO pibNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Wa noyaknu numuninipa Gita wa Yineru Wgenno ga wa pejnuruneko notowreneyma, natajiwniyawaka ntuplapijere ntuplatanu. ");
INSERT INTO pibNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Gita getanu rapatjekaakona payinemnunanuka. Nkotspalatanna. Wa gowegane girukotachri pixka kotspalatna gowegane chiwo wgeneneyegiya. ");
INSERT INTO pibNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Potuklesretate galikaka nutakanna gowegane. Kegnetesretate nutakanna chiwo wgenene. ");
INSERT INTO pibNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“Giyagni Gita pogirchino wane nchinanna npotuklesretate gajene, ‘Ginanu, Nuru giglenshinikanutanune. Gyoptotanru pogirewatyawaka gixa chinanupa galpokotkaluru ma mutaakonuwa tye psolchijneko. ");
INSERT INTO pibNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Gi rixanu nachinanno. Geneka nikletno. Nonunnagatewanata. Geneka giiretno. Pnu giyakatyachrino. Gyoptotno. ");
INSERT INTO pibNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Mamkatno. Gmakatno. Nyayixa. Nsalwayegitno. Yoshmakjetikowakananno. Ginyegitno.’ ");
INSERT INTO pibNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Giyagni poyagkakachine gigitanno. Wane chinannona, ‘Gitsrukaachi, ¿giklu wetyi pnachinatini ga wa woglutyi, waka gonunnagatewatachriyi ga wa weneka giiretyi? ");
INSERT INTO pibNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Giklu wetyi pnu giyakatyachriyi ga wa wyoptotyi, waka mamkatyi ga wa wmakatyi? ");
INSERT INTO pibNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Giklu wetyi pyayixanatini ga wa yoshmakikowaka pwini pixa, ga wa wunyegityi pixa?’ ");
INSERT INTO pibNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Wa Gita pogirchino gigitanna. Wane nchinanna, ‘Galikakni wane nchingi, girukokta wa mturu potu wa nyi nomole wane gixini, wane gixno Gita.’ ");
INSERT INTO pibNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Wanepnute wane nchinankoxna wa nkegnetesreta gwachine, ‘Gixrikinno, kamakpiratkalungi. Xirnachri gyanu gike rixiniko muwnakatu, tsru kamchi chinanu galpokotkaluru ga wa gitowrenenupa. ");
INSERT INTO pibNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Gi rixanu nachi nixinina, gi geneka nikletanno. Nonunnagatewanatinina, gi geneka giiretanno. ");
INSERT INTO pibNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Pnu nuyakatinina, gi wa gyoptotanno. Mamkatu nixini, gi wa gmakatanno. Nyayixinina ga wa yoshmakikowaka nwini, gi wa nsalwayegitanno.’ ");
INSERT INTO pibNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Giyagni wanna koxa gigitanno. Wane chinannona, ‘Gitsrukachi, ¿giklu wetyi wa pnachinatini ga wa ponunnagatewatini ga wa pnu puyakatini, mamkatu, ga wa yayixachriyi ga wa yoshmakikowaka pwini, waneklu gi wa wupxakyi?’ ");
INSERT INTO pibNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Gita gigitanna. Wane nchinanunna, ‘Galikaka wane nchingi, gi rixanu gi wane gixlu satu nyi mturpotune, gi wa Gita wane gixa.’ ");
INSERT INTO pibNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","“Wane yanunna saletikowakapna gike rixiniko mnikawnakatu. Ga wa poyagkakachine wane yanna giwekikowaka gike rixiniko mnikawnakatu.” ");
INSERT INTO pibNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Wane rixa. Rali ginkakletinitkalu Geso pejnuruko tyekakapirana, wane chinna yimaklene, ");
INSERT INTO pibNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Gixa gimatlu wa gepigogne giknoginpatka, waneplu Tsru Giknoglushgogne ga wa Gita Yineru Wgenno samyooko, koroshishkita nutakikopatka.” ");
INSERT INTO pibNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Giyagni tsrukakalune sasertotene, ga wa yine tsrutene gapata. Sasertotene gitsrukatpotupji rapatyana. Kaygwasu giwakni. ");
INSERT INTO pibNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Jemanshinikankakna kashichyapluna Geso yokwireyna, ga wa ruylatyapluna. ");
INSERT INTO pibNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Wane chinna, “Gi wa tsrugogneklupni. Ma mejnugimalewatinitipna yine.” ");
INSERT INTO pibNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Wetani rawanata Geso, gijirgitutpachri Simopji. ");
INSERT INTO pibNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Tapyegitlu sato suxo. Waneylo pastono klatalo, pgamlugalu yegi. Kwenuru potu. Nikawaka tuplanatini Geso, tuyokjiwutlu. ");
INSERT INTO pibNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Wale retna yimaklene. Rumtuwnana. Wane chinna, “¿Klu chinanu wane tixa salewnaleta? ");
INSERT INTO pibNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Gi rixanu tumkata gishankakotmaka tsru wenruya, renekikolupna kwamonurune.” ");
INSERT INTO pibNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Geso gimatlu. Wane chinna, “¿Klu chinanu nsalewnakaklo twu suxo? Gi rixanu kigleru kamrurchi tkamrutyano. ");
INSERT INTO pibNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Gi rixanu waneygognenanupgi wa kwamonurune gixayma, seyni Gita gi wa gimwagognenanutanutkagi. ");
INSERT INTO pibNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Gi rixanu tuyokmanetno pgamlugalo, wa nkapnatikolupa tkamrutyano. ");
INSERT INTO pibNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Galikaka wane nchingi, ginakakokta runkakletiko Kiglerupotunanu Tokanchi wa psolchijneko wa tye koxa tkamrutanru wala wane chinkalurupa wa tushinikikolupa wala.” ");
INSERT INTO pibNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Giyagni satu pamole gepi rixinri, Gota Giskaryote giwakatletachri tsrukakalune sasertotene yegi ya. ");
INSERT INTO pibNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Wane chinna, “¿Klu galuka genekletno, gita samyokangi Wale?” Rupiratyaluna mapmoleproji. ");
INSERT INTO pibNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Wanekluyakawa rujgalu ruglepoktapinri samyokyaplu. ");
INSERT INTO pibNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Muchinangogne jimaprojpa gisekachri myapjetkotugognekaka yimaklene ginyegitlu Geso. Wane chinruna, “¿Ginaka paluka galpoklejixwu wa Tsru Giknoglushgogne pnikyawakapa?” ");
INSERT INTO pibNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Wale wane china, “Pokchi gyanu wale jeji yegi. Wane nchinanru, ‘Yimaklewatachri wane china, “Nogognestsitkani. Pixa yegi Tsru Giknoglushgogne nkamrutinri nyimamkleneyma” ’ ” ");
INSERT INTO pibNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ga wa yimaklene Geso chinyawakna kamrutna. Ralpokotluna Tsru Giknoglushgogne chinanu. ");
INSERT INTO pibNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Kayimnu chininitka nikawaka tuplatatka pamole gepi yimakleneyma. ");
INSERT INTO pibNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Wa nikanatinna, Geso wane china, “Galikaka wane nchingi, satu gixate rixinri samyokanutkano.” ");
INSERT INTO pibNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Wamonuwnapotutna. Yinuwaka wane chinretna satkaka, “¿Gitgetkopni, Gitsrukaachi?” ");
INSERT INTO pibNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Giyagni rugitna Wale. Wane chinna, “Girpaktanwa Gitayma gigakachri kolpetoya gimyoya, walepni wa samyokanno. ");
INSERT INTO pibNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Galikaka Gita wa Yineru Wgenno wane nyanu chinyawaka wa yonchi Gitapiranaya. ¡Gi waneni wa tye jeji, wale chinanu Gita wa Yineru Wgenno samyooko! Kiglemkalu tye jeji chinanu ma mushpaakannimka.” ");
INSERT INTO pibNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Giyagni rugita Gota wa samyokjeru. Wane chinru, “¿Gitgetkoni, Rawi?” Wane chinru, “Pixa chinyawaka.” ");
INSERT INTO pibNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Nikanatinna wanna, Geso kashichlu jimapro. Ruglenshinikanyegitlu. Jiknaglu. Renekna yimaklene. Wane chinna, “Gyoptotanru. Gnikanru. Tyenwa nomane.” ");
INSERT INTO pibNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Kashichlo girapistono. Poyagnutyegitlo. Renekna. Wane chinna, “Giranu walaya pejnurunekgi. ");
INSERT INTO pibNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Gi rixanu tyenwa nograga wa gerotu tokanchi gipiratkaluru chinanu, gixoluru yineru chinanu giyookaluru, wa mukochri kaspukikolupa. ");
INSERT INTO pibNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ga wa wane nchingi, xaniyakawa gi wa nuranutkalo twu gowajga wa walegognepotuko wa nuranro geroto wa Goyakalu pogirewatyawakaya.” ");
INSERT INTO pibNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Wa wanna shikaletinitkalu gimalwuru, rushpakamtatkana. Goliwa Magkate yana. ");
INSERT INTO pibNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Giyagni Geso wane chinna, “Tye yechno pejnurunekgi gixapni gitspeekaakona Gita chinanu. Gi rixanu kayongalutkani: Nuylakanru girukotapratachri, ga wa gowegane gapatyawaka gajene kotspalkaakona. ");
INSERT INTO pibNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Wa nyotunotinpatka, Gita gapka kosekanu gixaya. Kalile nyanu.” ");
INSERT INTO pibNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Petro gigita. Wane chinru, “Pejnurunekmaka gitspetanu Pixa chinanu, gike nixiniko nutspetanu gita.” ");
INSERT INTO pibNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Geso wane chinru, “Galikaka wane chinyi, tye yechno ma yanumatkanugnapuwa gaxawripa, mapa kata pnutatanno.” ");
INSERT INTO pibNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Petro wane chinru, “Numkata gipnaletankoxmaka Pixayma, gi nnutatanyi.” Ga wa pejnuruneko yimaklene wane china. ");
INSERT INTO pibNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Giyagni sana ya Geso wannayma. Getsemani chinikowaka sana yana. Wane chinna yimaklene, “Gewi ntuplatanu, nagjigognetapinikopshini.” ");
INSERT INTO pibNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ranikna Petro ga wa gepi Sewereyo wgenene. Yinuwaka wamonuwnaleta. Ga wa kojwakanshinikanutka. ");
INSERT INTO pibNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Giyagni wane chinna, “Nonshinikanu nwamonuwnapotutya gipukchi pixka potuko. Gkagwakanu gewi. Giyokanu Gitayma.” ");
INSERT INTO pibNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Wane rajrinya psotsotaaji. Yoptsojita. Yonoogojpotuta. Ragjigogneta. Wane china, “Nuru, rumkatini wane gixletikolupa, ruknoganu tye salewakchi Gitaya, seyni gi wa Gita galukyawakapni, seyni Pixa galukyawakapni.” ");
INSERT INTO pibNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Yimaklene yegi ya. Retamtna gimkanatachine. Wane chinru Petro, “Giyagni ¿gi gimkata giyokletge Gitayma pshinitsonu? ");
INSERT INTO pibNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Giyokanu. Gagjigognetanu gma yantaletikotupa. Wa jmerenshinikanurungi galikakni, seyni gimane muchkotni.” ");
INSERT INTO pibNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Rumepe wane yaletatnaka. Ragjigognetapa salewnalepirana. Wane china, “Nuru, nma murkanuwalo gi tumkata giknogletini Gitaya wa twu girapistono, wane gixkalurupni palukyawaka.” ");
INSERT INTO pibNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Rumepe yayegletatnakna. Retamtna gimkanatachine, gi rixanu ruxapnewlena chinanu gi rumkata gimrekaygaletna. ");
INSERT INTO pibNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Rajrinatnaka. Ragjigognetapa mapa kata rixinri. Waneko pixka chintokanutatnaka. ");
INSERT INTO pibNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Wanepnute yimaklene yegi yatnaka. Wane chinna, “Gimkapanuchi. Gapnanutanutka. Nopapkostsitkani Gita wa Yineru Wgenno samyookotka kmukochirerunemyoya. ");
INSERT INTO pibNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Gyotunotanutka. Gayanutka. Gi gowukatkalu nsamyokjerupa.” ");
INSERT INTO pibNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Wa yanumsanatiniwa, runatka Gota satu wa pamole gepi rixinrina. Waleymana gixolune yine kyoglolewaprerune, kgagajererune. Runna tsrukakalune sasertotene ga wa tsrunekoxasreta gajene. ");
INSERT INTO pibNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Wa samyokjerupa genekna saturutu gimaxiklechi. Wane china, “Girukta namlutanu gita, Walepakni. Gkashichanru.” ");
INSERT INTO pibNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Rapyegitinitkalu Geso, waneklu wane chinru, “¡Rawi!” Ralukatkalu ga wa ramlutlu. ");
INSERT INTO pibNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Geso wane chinru, “Nomole, ¿klu chinanu puna?” Giyagni rapyegitluna. Geso. Kashichatkaluna. ");
INSERT INTO pibNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ga wa satu Gesoymalutu koshpaklu yoglolewapre. Rustaklu sasertotene gitsrukate potu wayegreru. Yostakjepitlu. ");
INSERT INTO pibNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Giyagni Geso wane chinru, “Pumretanru pyoglolewapre. Rawyawaka putakanru. Gi rixanu pejnuruneko yoglolewapi koschekachri, yoglolewapiko ruylatiko. ");
INSERT INTO pibNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Waka gkagwakluge gi numkata gagjiretlu Nuru; Walemka gitakyegitanutkano yokgipimole waragka pnute solalone gitowrene? ");
INSERT INTO pibNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","¿Seyni gi rixpoko poyagkaakotanmaka Tokanchi Yonatkaluru wane chinachri rumkata wane gixleta?” ");
INSERT INTO pibNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Waneklu Geso wane chinna wa gixolune yine, “¿Ginyegitno gixa yoglolewapiyma gagajeyma, kachowguru pixka gixa kashretnoge? Pagognemnunanuka gixayma ntuplanata. Nunkaklewata kpashiwakapjiya. Gi wa wane gkashichyano. ");
INSERT INTO pibNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Seyni pejnuruko tyekaka wane gixkaluru poyagkakikolupa wa yonchi, Goyakalu tokanu geneklewatachine yonga.” Ruknokamtluna pejnuruneko yimaklene. Rasukatkana. ");
INSERT INTO pibNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Ga wa Geso kashichachine ganiklu. Sasertotene gitsrukate potu Kaygwasu yegi ranikatkaluna, rapatyawakatkana yonchikgapine ga wa tsrune. ");
INSERT INTO pibNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Wa Petro gomkagitlu gogajxigiyako. Sasertotene gitsrukatpotupjipotunanuko romkagitlu. Gitoko jigloka. Tuplanata towrechineyma retyaplu rushinityawakapa. ");
INSERT INTO pibNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Wa tsrukakalune sasertotene, pejnuruneko jemanshinikankakjetikowakaya rujgaluna gipujtalewlusha galikaka migje Geso chinanu ruylajixyapluna. ");
INSERT INTO pibNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Gimka gepikna gipgujtalewashatachine gapokachine, seyni gi rukshikluna. Gapkatamtachine gepi gapoka, ");
INSERT INTO pibNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","wane chinachine, “Wale wane china, ‘Numkata jijrolekletlu kpashiwaka potu Goyakalunu, ga wa mapgogne nkamrupjitanutnaklu.’ ” ");
INSERT INTO pibNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Palna sasertotene gitsrukate potu. Wane chinru, “¿Gike pugita? ¿Klu rupgujtatyayina wa nyi?” ");
INSERT INTO pibNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Seyni Geso pochkeru. Sasertotene gitsrukate potu wane chinru, “Goyakalu giwekachri kawchinanu nkoschekjixyi. Punkakanwu, ¿Pixlege wa Kristo, Goyakalu Wgenyi?” ");
INSERT INTO pibNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Geso wane chinru, “Pixa chinyawaka. Seyni wane nchinyi, Xaniyakawa gixa getanno Gita wa Yineru Wgenno tuplatyawakapa giyaklu potuklesretate, nuninkoxapa kyachgapererumkoya tengogne.” ");
INSERT INTO pibNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Giyagni wa sasertote gitsrukate potu suskamkata. Wane china, “Mupashiregnuchi china. ¿Klu wanepnute magatyawu gipgujtalewatachine? Getanu wa xani. Gyijnakotatkalu ma mupashiregnuya. ¿Gi pixka getle gixlu?” ");
INSERT INTO pibNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Rugitna. Wane chinna, “Ruklukanuwna rupninripa.” ");
INSERT INTO pibNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Giyagni rutskagjegojitluna. Yotmutluna. Pimrine giptagojitlu. ");
INSERT INTO pibNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Wane chinna, “Kristo, Goyakalu chinanu punkakanwu: ¿Katu giylakyi?” ");
INSERT INTO pibNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Malekputu tuplanata Petro. Wane tapyegityalu sato wayegrechro. Wane china, “Pixa koxa Geso Kalile gajeruymananyi.” ");
INSERT INTO pibNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Seyni pejnuruneko getanuya nutata. Wane china, “Gi numata gikta pchina.” ");
INSERT INTO pibNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Rushpaka. Maleka gajeru gipgyaptote ya. Satu getatnaklu. Wane chinna wa wane gwanatachine, “Tye koxa Geso Nasare gajeruymananu.” ");
INSERT INTO pibNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Wale kawchinanu nutatatnaka. Wane china, “Gi numatlu wa jeji.” ");
INSERT INTO pibNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Pshinitsonu rapyegitluna wane gwanatachine. Wane chinruna Petro, “Galikakni pixa koxa wannaymananyi. Gi rixanu ptokanu pumatika wa wane pixinri.” ");
INSERT INTO pibNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Giyagni yinuwaka kamakpiirewleta. Yinuwaka Wale kawchinanu chinreta, “Gi numatlu wa jeji.” Waneklu gaxawripa yanumatatka. ");
INSERT INTO pibNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Rushinkaplu Petro wa Geso tokanu, wane chininri, “Ma yanumatkanuwa gaxawripa, mapa kata pnutatanno,” chinyalu. Rushpakamtatka. Maleka ya. Chiyampotuta. ");
INSERT INTO pibNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Goyechnokawpotuko jemanshinikankakjetikowaka jiglokna tsrukakalune sasertotene ga wa yine tsrutene Geso chinanu, wa ruylatyapluna. ");
INSERT INTO pibNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Rostutluna. Ranikatkaluna. Pilato girukotlewatachri yegi samyokluna. ");
INSERT INTO pibNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Giyagni Gota wa samyokjeru retatkalu wa ruklukanuwnayegjixikolutka, kashrijetanshinikanuta. Satkaklo wa mapamoleproji tsrukakalune sasertotene ga wa tsrune yegi. ");
INSERT INTO pibNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Wane china, “Gita mukochirewatatka. Nsamyoklu muklukanuwnakatugraga.” Wa wanna wane chinru, “¿Gi rixwu wixa? Petanru pixa.” ");
INSERT INTO pibNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Ruknokamtlo sroschiproji kpashiwakaya. Ralimta. Rushriknojitnanatkawa. ");
INSERT INTO pibNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Tsrukaklune sasertotene gwalo sroschi. Wane chinna, “Ginanshichkalurni tuknokikolu wa kpashiri gignantakikowaka, gi rixanu granchi wenroni.” ");
INSERT INTO pibNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Jemanshinikankakna. Walaya ragjitluna kajpa kamgakleruchijne, pnu giyakatyachine kapnatikowakapa. ");
INSERT INTO pibNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Giyagni wane chinkaluru Granchichijne xanigognenanu. ");
INSERT INTO pibNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Waneklu poyagkakatkalu Goyakalu tokanu geneklewatachri Geremiya wane chinyawaka: Rawlona mapmoleproji sroschi wa rutakwenutikolu wenru, wa pimrine Gisrayiliklopishane gitakwenutanru. ");
INSERT INTO pibNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Reneklona kajpa kamgakleruchijne chinanu, Gitsrukaachi chinyawakno. ");
INSERT INTO pibNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Girukotlewatachri getanu tunwata Geso. Ga wa girukotlewatachri gepomgalu. Wane china, “¿Pixlege wa Goteyone Pogiryi?” Geso wane china, “Pixa chinyawaka.” ");
INSERT INTO pibNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Wa jigyegitkoklunu tsrukakalune sasertoteneya ga wa tsruneya koxa, gike rugita. ");
INSERT INTO pibNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Giyagni Pilato wane chinru, “¿Gi ge pjema gi pejnupiranananukta jigyegityayina Pixa?” ");
INSERT INTO pibNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Gi satuna tokanchi rugityalu. Giyagni girukotlewatachri giglajpotuta. ");
INSERT INTO pibNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Wa tsrugogneklu satu yineru rushyegjetna gostutkaluru girukokta ralukanruna. ");
INSERT INTO pibNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Giyagni waneyananna gostutkaluru kpogiru, Warawasu giwakatletachri. ");
INSERT INTO pibNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Giyagni rapatinitkana, Pilato wane chinna, “¿Giru galuka wa nkaspukyegityapgi? ¿Warawaslege waka Geso wa Kristo chinkaluru?” ");
INSERT INTO pibNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Gi rixanu wale gimata wa ranxalna chinanu samyokluna. ");
INSERT INTO pibNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Gitakyagoklewatikowaka tuplanatini wale, ganunro yokantokanyegitlu. Wane chinru, “Petashatanru Wale poyagkakachri. Gi rixanu xawakni gixo nsalewna Wale chinanu nupnawleya.” ");
INSERT INTO pibNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ga wa tsrukakalune sasertotene ga wa tsrune gishinikanutna gixolune yine wa Warawasu galikaka ragjitinripna, ga wa Geso ruylajixinripna. ");
INSERT INTO pibNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Rugita girukotlewatachri. Wane china, “¿Giru galuka wa nyi gepi wa nkaspukyegityapgi?” Wanna wane china, “Warawasupni.” ");
INSERT INTO pibNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilato wane chinna, “Giyagni ¿gi nixyaplu Geso wa Kristo chinkaluru?” Pejnuruneko wane china, “¡Koroshishkita gitaakalurupa!” ");
INSERT INTO pibNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Girukotlewatachri wane china, “¿Klu gektutu kamruta?” Wanepnute potu tsaplewatna. Wane chinna, “Koroshishkita gitaakalurupni.” ");
INSERT INTO pibNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Giyagni Pilato getinri gike rumkata, seyni wanepnute galikaka rixa gejnugima, gonu koscheka. Reromyoga gixolune yine getanu. Wane china, “Muklukanuwnakatno tyegragaya. Gixa getanutkalu.” ");
INSERT INTO pibNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Pejnuruneko yine gigita. Wane chinna, “Wixa chinanupni gigragaya, ga wa wwugenene chinanupni.” ");
INSERT INTO pibNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Giyagni kaspukyegitna Pilato Warawasu. Rali kochipjetjixletinitkalu Geso, samyokatkalu koroshishkita rutakikolupa. ");
INSERT INTO pibNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Giyagni girukotlewatachri solalotene ganikatkalu Geso. Tsrupji Pretoryopji ranikluna. Pejnuruneko solalone gapatyegitlu. ");
INSERT INTO pibNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Giyagni Waleko gimkalu komkagatkaluna. Pakni yoshmookaluru pixkalutu mkachri yoshmakatkaluna. ");
INSERT INTO pibNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Kona kamgikaluru sagyeta yoshmakjiwutatkaluna. Katsluksu samyokluna, potuklemyo. Yoptsojityegitluna. Ruxpiranatluna. Wane chinruna, “¡Wuya, Goteyone pogire!” ");
INSERT INTO pibNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Rutskagjetluna. Kashichluna katsluksu. Ruylajiwutluna. ");
INSERT INTO pibNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Rali gixpiranatletinikaluna, komkagatkaluna mkachri. Waleko gimkalu yoshmakatnakluna. Ranikatkaluna, koroshishkita rutakyapatkaluna. ");
INSERT INTO pibNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Rushpakamtinitkana. Retluna Surene gajeru, Simo giwakatletachri. Wale rutjijixlona Geso koroshishkitate. ");
INSERT INTO pibNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Rapokluna Kolkota chinikowaka. Walenwa Gijiwuswaga yegi chinikowaka. ");
INSERT INTO pibNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Reneka giiretmakluna winga shepichlega yapjetkaluro. Retumgamkalo. Gi raluka giiretlo. ");
INSERT INTO pibNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Koroshishkita rutakatkaluna. Kotspaltamkatluna. Gipenoklu rutakluna gimkalu. ");
INSERT INTO pibNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Tuplatna. Wane retanatyaluna. ");
INSERT INTO pibNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Gijiwu gogwakate rutakyaluna jigyegitikolu yonga, wane chinachri: Tyenwa Geso Goteyone Pogire. ");
INSERT INTO pibNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Giyagni Waleyma koroshshkita rutaakana gepi kachowgurune, satu potuklesreta, satu kegnetesreta. ");
INSERT INTO pibNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Wa giknogachine mupashiregnuchi chinruna. Ruwnownojiwutna. ");
INSERT INTO pibNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Wane chinruna, “Pixni wa kpashiwakapji jijrolekachripyi, mapagogne pkamrupjitanutnaklu. Pixnanuko gognetkakinwa. Goyakalu Wgene pixinipa, koroshishkita pujrukini.” ");
INSERT INTO pibNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Waneko pixka china gixpiranatletluna tsrukakalune sasertotene, ga wa yonchikgapine, ga wa tsrune. Wane chinna, ");
INSERT INTO pibNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Pimrine rognetkaka. Walenanuko gi rumkata gognetkakletnawa. Goteyone Pogirmaka, koroshishkita rujrukini xani. Walixanmaklu. ");
INSERT INTO pibNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Raponshinikanutkamkalu Ruru Goyakalu. Rushatkapanru xani ralukiniplu. Gi rixanu wane china, ‘Goyakalu Wgenno.’ ” ");
INSERT INTO pibNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Waneko pixka rixa yangaletluna kachowgurune Waleyma koroshishkita gitaakalune. ");
INSERT INTO pibNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Tumananutkani ruchpokatka tkachi psolchijnepotunanuyako. Kayinwakasreta rapokinpotunanuko rumrekatka. ");
INSERT INTO pibNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Kayinwakpapko Geso saplewata. Tsru plaji rixa. Wane china, “Geloyi, Geloyi, ¿Lama sawajtani?” Walenwa, “Noyakalute, Noyakalute, ¿klu chinanu puknokatkano?” ");
INSERT INTO pibNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Jeminrina pimrine wane gwanatachine, wane chinna wanna, “Pete. Wale tomgalu Giliya.” ");
INSERT INTO pibNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Waneklu rasukamta satu wannate. Rawlo katsopi. Kachgalu shichponkaklu. Katsluksu rutaklu. Reneka giiretlu. ");
INSERT INTO pibNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Pimrine wane china, “Getashatanru. Wetkoxewa gikta runanu Giliya rognetkakapyaplu.” ");
INSERT INTO pibNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Rumepe saplewletatnaka Geso. Tsru saple rixa. Kaspukatkalu ruwekinri. ");
INSERT INTO pibNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Waneklutka mkachrichrata gimaletanatachri kpashiwaka gajeru giskakamtatka. Gepichratatkalu. Teno rumuyaka giskakletyatka chijiina. ");
INSERT INTO pibNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Ruyolikchijita. Sotlukaka gitspatjeta. Rutpukamta yomlechkaka. Gi gepika kpashirinni gapnanutachinnimane yotunota. ");
INSERT INTO pibNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Wa yotunotinitka Wale, waneklu yomlechi rushpakyatkana. Kpashiri pokchi yatkana. Gixolune yegi rupgujewnayegitna. ");
INSERT INTO pibNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Ga wa ksolaloteru ga wa waleymalune Geso girukotanatachine getlu wa giyolikchijru, ga wa wane gixkalurkaka. Tsru piklu rixanna. Wane chinna, “Galikakni Goyakalu Wgenni wa tye.” ");
INSERT INTO pibNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Wane rawanatna gixo suxone gowuka getanatyachine. Kalile romkagityaluna Geso. Rupxakanatluna. ");
INSERT INTO pibNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Wannaymana Mariya Maktala gajero, ga wa Santiyako, Gosi ginro Mariya, ga wa Sewereyo wgenene ginro. ");
INSERT INTO pibNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Kayi rixinitka runa satu jeji ponikolu, Garimate gajeru. Gosi giwakatletachri. Wa Geso yimaklerkoxni wale. ");
INSERT INTO pibNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Wale yayegitlu Pilato. Gesnimane ragjita. Giyagni Pilato genekjixmanetlu. ");
INSERT INTO pibNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Gosi gwamanetatkalu. Powrachratalu poyitatkalu. ");
INSERT INTO pibNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Waleko giyomlepmaka gerotupna rutaklu, sotlu yomlechi gipgyaptote gakanokachri. Wane yiyatka. ");
INSERT INTO pibNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Wane rawanatna Mariya Maktala gajero, ga wa sato Mariya. Tuplanatna yomlechi ginaple. ");
INSERT INTO pibNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Waleprikgogne, walenwa gapnanutikalurgogne, Pilato yegi rapatyana tsrukakalune sasertotene ga wa Gwariseyone. ");
INSERT INTO pibNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Wane chinna, “Gitsrukaachi, wushiniklu wa wale kyokwirewaklerni wane china, ‘Mapagogne giknoginpatka nyotunotanu.’ ");
INSERT INTO pibNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Giyagni pyokanrewatanu girukotayomletikolupa mapgogne rixinpotunanuko, ma chowgutapyapluna yimaklene goyechno, ma wane chinyanupna yine, ‘Yotunomtatka gipnachinetskalaya.’ Gapkatatachri pupjeru muchinanu pnute ma mixinitipa.” ");
INSERT INTO pibNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilato wane chinna, “Waneygi girukowatachine. Gajewa. Gignantakanru gimatyawaka.” ");
INSERT INTO pibNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Wane yatkana. Rugnantakluna yomlechi. Rupitluna sotlu, girukowatachineymananuko. ");
INSERT INTO pibNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Ruknoginitka gapnanutikalurgogne, rumrerekamtinitka muchinangogne wa simana, wane yana Mariya Maktala gajero ga wa sato Mariya, yomlechi retapyapna. ");
INSERT INTO pibNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Waneklu waneru tsru giyolikchijru. Gi rixanu Gitsrukaachitowreru gijruka tengogneya. Rapoka. Rakaprurutlu sotlu yomlechi gajeru. Wale gogo tuplanatatka. ");
INSERT INTO pibNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Rawrakle pixka rixgojita. Gimkalu klataa rixpotuta giwru pixka. ");
INSERT INTO pibNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Wale piklena chinanu wa girukowatachine giypiypitana. Gipnachine pixka rixanna. ");
INSERT INTO pibNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Goyakalutowreru gigita. Wane chinna suxone, “Gi mpikanu gixa. Gi rixanu numatgi Geso gijga, wa koroshishkita gitakanatkaluru. ");
INSERT INTO pibNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Gi wa gewitkalu. Yotunomtatka wa Wale chinyawaka. Ginanu. Getapanru rutakanatikowaka. ");
INSERT INTO pibNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Gajewa. Nteyakawamtanu. Ginkakapanna wa yimaklene yotunomtinritka gipnachinetskalaya. Kosekatkagi. Kalile yatka. Wane getinitkalu. Nunkakatkagi.” ");
INSERT INTO pibNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Giyagni wanna yomlechi teyakawamtyatkana. Pikachine ga wa gimuwatachine potu. Rasukamtna yimaklene runkakapyapna. ");
INSERT INTO pibNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Makakta Gesokni wa yoptotapna. Wane chinna, “Kiglenshinikanupgi.” Rapyegitluna. Kashjixitluna. Yoptsojityegitluna. ");
INSERT INTO pibNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Giyagni Geso wane chinna, “Gi mpikanu. Gajewa. Ginkakapanna nomolene wa Kalile yinripatkana. Wane retinnona.” ");
INSERT INTO pibNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Wane yakopshinna, pimrine girukowatachine pokchi yatkana. Tsrukakalune sasertotene runkakapna pejnuruko retanrutkana wane gixachritka. ");
INSERT INTO pibNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Rapatjetna tsruneyma. Jemanshinikankakna. Gixo sroschi reneekana solalone. ");
INSERT INTO pibNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Wane chinkana, “Wane nchinanu, ‘Yimaklene goyechno ginapa. Chowgutpatkaluna, wumkanatni wixni.’ ");
INSERT INTO pibNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Wale yijnakotinipa girukotlewatachri, wixa giglepokyegitangi. Mkojwakanshinikanutkane wixkakangi.” ");
INSERT INTO pibNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Wanna yoptotlo sroschi. Wane rixna wa runkakikowakna. Giyagni poshalpiranatka Goteyone yegi xanigognenanu. ");
INSERT INTO pibNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Giyagni pamole satupje yimaklene Kalile yatkana, satu magka yegi wa Geso chinyawakpotukna. ");
INSERT INTO pibNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Retinitkaluna yoptsojityegitluna. Seyni pimrine nutanshinikanyegitlu. ");
INSERT INTO pibNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Rapyegitinitkana Geso, ruynumsatna. Wane chinna, “Psolpotuko nutakika tengogne ga wa chiji. ");
INSERT INTO pibNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Giyagni gyanu. Gyimakanna payinemnunanuka. Gkatanna Girchi giwakaya, ga wa Gituru giwakaya, ga wa Giwekikaluru Kpashiri giwakaya. ");
INSERT INTO pibNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Ginkakanna kamrutyapluna pejnuruko nyokanatyagi. Gjemanu: Gixayma nwanu psolgogneko yoptukgogneshatyawakpotunanuko.”");
INSERT INTO pibNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Tyenwa yinuwakikolu Kiglerpotunanu Tokanchi Geso Kristopirana Goyakalu Wgene. ");
INSERT INTO pibNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Wane rixa yokanatkaluru Gisayiya Goyakalu tokanu geneklewatachri. Wane china: Gita yokanatlu notowreru pixa penute. Wale galpokotanru patnugapote. ");
INSERT INTO pibNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Yineru mwiyawakanu saplewatyachri wane china: Galpokotanru Gitsrukachi gatnugapote. Mpotukatanru gigapkaka. ");
INSERT INTO pibNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Gwa katlewata yineru mwiyawakanuya. Wane runkakyana yine genshinikanutachinepa katinripna. Ga wa kaspukamukochiretikolupapirana runkakna. ");
INSERT INTO pibNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Rushpakyegitluna pejnuruneko Gotesreta gajene ga wa Gerosale gajene koxa. Wanna ptowruneko katka Gorta gapgaya. Rupgujtamukochiretnawana. ");
INSERT INTO pibNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Wa Gwa makatlu kameyopixi. Wa pamta gipchiji rushrika. Wale niklu tsetse ga wa wrolga gosha gajeru. ");
INSERT INTO pibNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Runkaklewata. Wane china, “Runa najxigi Gita pnute muchkonurutu. Gi wa Gita gimukluni nyomshokinri nkoshpirokyaplu yoshmaklejixitsa. ");
INSERT INTO pibNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Gita galikakni katgi gonuya. Wa Wale katangi Giwekikaluru Kpashiriya.” ");
INSERT INTO pibNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Wane gixlutkani walegognekaka. Nasare Kalilechijne runyatka Geso. Wane Gorta gapga Gwa katyalu Geso. ");
INSERT INTO pibNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Waneklu wa gonu yotunotyatka. Retlu gitpukachri tengogne, wa Giwekikaluru motkoko pixka rixa, Wale gogwaka gijrukyachri. ");
INSERT INTO pibNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Tengogne runya satu tokanchi wane chinachri, “Pixni Noturyi nalukanruyi. Pixa gigletanshinikanutno.” ");
INSERT INTO pibNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Waneklu wa Giwekikaluru ganiklu yineru mwiyawakanu. ");
INSERT INTO pibNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Wane rawanata yineru mwiyawakanuya gepkoxamkojemolgogne. Wane rumlukanutyalu Satanasyo. Wane rawanata kmatsurunetskala. Goyakalutowrerune tengogne gajene gipxaklu. ");
INSERT INTO pibNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Waneklu kashichkoklunutka wa Gwa. Wanepnute Geso wane ya, Kalile ya. Runkaklewata Kiglerpotunanu Tokanchi pogirewatyawakapirana. ");
INSERT INTO pibNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Wane china, “Gigogne poyagkakatka. Goyakalu pogirewatyawaka gi gowukatkalu. Genshinikanutanu. Galixanru Kiglerpotunanu Tokanchi.” ");
INSERT INTO pibNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Tsru wenustsi Kalile yapamta. Retlu Simo repuruyma Gantirishi, chalugjetachine tsru wenuya, wa kshimagaklerune. ");
INSERT INTO pibNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Wane chinna Geso, “Ginanu gwagajxigitanno. Yine gwapjetachine nixkakanutkagi.” ");
INSERT INTO pibNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Waneklutka ruknokamtatkaluna chalnena. Romkagitatkaluna. ");
INSERT INTO pibNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Wane rajrinya. Retlu Santiyako, Sewereyo wgene repuruyma Gwa. Wanna koxa kanawa gwanata. Ramtatluna chalkaka. ");
INSERT INTO pibNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Waneklutka tomgana Wale. Ruknokamtluna rurna Sereweyo kanawaya kamrurewakleruneyma. Wane yana. Rawgajxigitluna. ");
INSERT INTO pibNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Kapernawo rapokinitkana, gapnanutikalurugognekaka jiglokjeta ginkaklewawakapji. Wane runkaklewlejetya. ");
INSERT INTO pibNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ruglajitna wa runkaklewleya. Gi rixanu runkakna tsru gitaakaluru pixkako rixa. Gi wa yonchikgapine pixka rixa. ");
INSERT INTO pibNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Waneru runkaklewawaklepjiyna jeji wa kamchi puchotlewatachri waneyalutu. Wale saplewata. ");
INSERT INTO pibNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Wane china, “¡Ya! ¿Gi pixannatkawu Geso Nasare gajeru? ¿Puna pumtukpotutapyapwu? Numatyi Kpashiryi Goyakalunu.” ");
INSERT INTO pibNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Geso chigetjetlu. Wane china, “Pochkepyi. Pushpakanutka waleya.” ");
INSERT INTO pibNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Wa kamchi puchotlewatachri shipchojtakakanru jejni. Saplewjetana tsruplaji. Rushpakamtatka wa waleya. ");
INSERT INTO pibNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Pejnuruneko giglajita. Giyagni repomgakakna. Wane chinna, “¿Klunerni wa tye? ¿Klu gerotu ginkaklewlutkani wa tye? ¡Waleni wa tsru gitaakaluru pixka rixa! Wale yokanatna kamchine puchotlewatachine. Jemluna Wale.” ");
INSERT INTO pibNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Waneklu pogiwata psolchijnepotunanuko Kalilesretaya. ");
INSERT INTO pibNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Wanepnute rushpakamtinitkana ginkaklewawakapjiya, wanna wane yana Simo, Gantirishipji, Santiyakoyma, Gwa koxa. ");
INSERT INTO pibNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Wa Simo gimajiro gikluga. Tpachwata. Giyagni walapirana runkakluna. ");
INSERT INTO pibNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Giyagni rapokinitka kosemyotlo, yotunkaklo. Tupachwalgamtatka. Wala gipxakatkana. ");
INSERT INTO pibNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Wa kayi rixinitka wa rumxikinitka tkachi ranikyegitluna pejnuruneko yayixachine, kamchichachine. ");
INSERT INTO pibNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Wa pejnuruneko tsru pokchi gajene gapatjeta gipgyaptoya. ");
INSERT INTO pibNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Geso gituukakna gixo yayixachine pnumnunanuka gixachri yayixluya. Wale giknokna maleka gixo kamchine. Gi ruchi yanumsaletna kamchine, gi rixanu rumatluna. ");
INSERT INTO pibNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Yotunomta goyechnokawpotuko, ma mumrereekanuwa. Rushpakamta. Wane ya yineru mwiyawakanu. Wane ragjigognetya. ");
INSERT INTO pibNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simo, waleymalune gijgalu. ");
INSERT INTO pibNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Rukshikluna. Wane chinruna, “Pejnuruneko gijgayi.” ");
INSERT INTO pibNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Wane chinna Geso, “Wane gayanu papokchikaka gawastsitanune yegi. Wane koxa nunkaklewatini. Wale chinanukni nuna.” ");
INSERT INTO pibNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Wane ya. Runkaklewananumta runkaklewawaklepjikakayna psoluko Kalileya. Ruknokyana maleka kamchine. ");
INSERT INTO pibNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Satu gijirgitutachri ginyegitlu. Ragjipotutlu. Yoptsojityegitlu. Wane chinru, “Palukiniplu pumkata powratletno.” ");
INSERT INTO pibNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Geso getwamonutlu. Romyokyegitlu. Kamruklu. Wane chinru, “Naluklu. Powra pixinripa.” ");
INSERT INTO pibNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Waneklutka gijirgitlu gitukyegitatkalu. Powratkalu. ");
INSERT INTO pibNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Rujretlu. Yokanatatkalu. ");
INSERT INTO pibNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Wane chinru, “Gike punkakanu. Seyni pyanu. Sasertote pekakgitapinwa. Penekashatanru powranuya wa Moysisi yokanatanru. Walepni gipgujtalewlu wanna chinanu.” ");
INSERT INTO pibNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Wa wale gishpakamtatka. Yinuwaka ginkakletletlu gixo. Poshalpiranamtlu. Giyagni wa Geso gi wa gimkata gapokletlu gipgujewnaleta tsru pokchiya, seyni maleka rawanata yineru mwiyawakanuya. Runyegitluna Wale pnumnunanuka gajene. ");
INSERT INTO pibNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Gi gixogogne giknoginiwa, Kapernawo rapokatka. Yijnakyegitinitka panchitkalu, ");
INSERT INTO pibNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","rapatjekakna gixolune. Gi wa gipgyaptoko poyagotatka. Geso ginkakna wa tokanchi. ");
INSERT INTO pibNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Runna. Ranikyegitluna giktegachri. Ranikjene gepkoxamkoje. ");
INSERT INTO pibNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Gi wa rumkata gapyegletluna gixo yine chinanu. Suswakluna wa washre Wale ginaple. Wane rixa kotpukleswatluna. Wane jijrukyaluna gijeko wa giktegachri giklugyawaka. ");
INSERT INTO pibNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Geso getlu wanna galixle. Wane chinru giktegachri, “Wiwi, pmukochirkaka pkaspukikatka.” ");
INSERT INTO pibNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Wane koxa tuplanatna pimrine yonchikgapine. Wanna gishinikanuwata rajiyna. ");
INSERT INTO pibNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","Wane chinna wanna, “¿Klu chinanu wane china yanumsaleta wa tye? Mupashiregnuchi china. Gike gimkata kaspukmukochirewleta. Satupjeru Goyakalupje.” ");
INSERT INTO pibNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Giyagni rumata Geso Walenanuko wane rixanshinikanutinrina. Wane china, “¿Klu chinanu wane gixanshinikanuta tyekaka wa gajiya? ");
INSERT INTO pibNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","¿Girni wa myapretu potu? Wane chinikolu giktegachri, ‘Wa pmukochirkaka pkaspukikatka,’ ga wa wane chinikolu, ‘Pyotunotanu. Pkoschekjekotanu. Pyanutka.’ ");
INSERT INTO pibNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Wa gimatyaplu wa Gita Yineru Wgenno tyechijneya gitaakalurno kaspukmukochiretjerupno,” wane chinru giktegachri, ");
INSERT INTO pibNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Pixa wane nchina, Pyotunotanu. Pkoschekjekomtanu. Pyanutka pupji.” ");
INSERT INTO pibNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Yotunomtatka. Waneklutka koschekjekomtatka. Rushpakamtatka pejnuruneko getanu. Giyagni pejnuruneko giglajita. Rumalwutluna Goyakalu. Wane chinna wanna, “¡Gi pagogneko wane pixkalutu weta!” ");
INSERT INTO pibNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Rumepe gishpakleta. Tsru wenu yatka. Pejnuruneko yine ginyegitlu. Wale ginkaklewyegitna. ");
INSERT INTO pibNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ruknogamta. Retlu Rewi Galgweyo wgene. Tuplanata girukotlewatachri wenutikowaka. Wane chinru, “Pomkagitanno.” Palnamtatka. Romkagitatkalu. ");
INSERT INTO pibNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Waneklu wane rawanatini Geso wa nikawakakwa Rewipji, gixna gijgawenutachine ga wa kmukochirerune nikawakakwa koxa rawanatna Gesoyma, yimaklene koxa. Gi rixanu gixolunni yine. Romkagitluna. ");
INSERT INTO pibNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Wanena yonchikgapine. Wannanwa Gwariseyone koxa. Retanatluna nikyawaka wannayma kmukochirerune ga wa gijgawenutachine. Wane chinkanna wa yimaklenni Gwariseyoneya ga wa yonchikgapineya, “¿Gi rixatka wa wannayma nika, rura, wanna gijgawenutachine ga wa kmukochirerune?” ");
INSERT INTO pibNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Geso yijnakotlu. Wane chinna Wale, “Wa gichkolune gi galuklu kpinrewakleru, seyni yayixachine galuklu. Gi wa nuna ntomgiyapna poyagkakachine, seyni wanna kmukochirerune ntomginripni.” ");
INSERT INTO pibNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Wa Gwa yimaklene ga wa Gwariseyonenu gogajirewata. Runna. Wane chinruna, “¿Klu chinanu wanna Gwa yimaklene wa Gwariseyone yimaklene koxa gogajirewata, ga wa Pixa yimaklene gi wa gogajirewata?” ");
INSERT INTO pibNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Wane chinna Geso, “Gi rumkata gogajirewletna wanna kashimyolu getachine gnunrowatachri wannaymalutuwa, Gita pixka nyimakleneymano. Wa wannayma rawanatini gnunrowatachri gi rumkata gogajirewletna, xani pixka wa Gita gimwakopshinna nyimaklene. ");
INSERT INTO pibNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Runinpatka pagogne wa gnunrowatachri konikolgognepatka wannayegiya. Waneklu rogajirewatanna wanna. ");
INSERT INTO pibNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Gikena gamatlu wa muchkirgakatu mkachri gitsole. Wane rixkoklunu, waleko gerotu sama suskaklu gitsole. Wanepnuteyaka rixa giskakletanatka. ");
INSERT INTO pibNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Gikena giyokgatlu winga gerotu, tsapkaka tsrutsoleji. Wane rixkoklunutka, winga suskakanru tsapkakni. Tuyokgata wino. Tsapkaka salewna. Seyni wa winga gerotu tsapa gerotu tutakgatka.” ");
INSERT INTO pibNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Wane rixa. Sana yapanata gapnanutikalurgogne. Yimaklene yanananumta. Yinuwaka sustakagwuremtluna gitaklugwu. ");
INSERT INTO pibNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Giyagni Gwariseyone wane chinru, “Petanu. ¿Klu chinanu wane rixna gapnanutikalurgogne wa ginanshichkalurgogne?” ");
INSERT INTO pibNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Wane chinna Geso, “¿Gi ge pagogne getyongatlu wa gi rixpokota Tawi, magatini wa nachichini wale ga wa waleymalune? ");
INSERT INTO pibNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Gi rixpoko jiglokletlu wa Goyakalupji, wa Gawiyatari walenwa sasertote gitsrukatpotu. Niklu jimaprokaka gekakgitkaluru. Wa walenwa ginanshichkaluru niklu. Sasertotenepje niklu. Reneekoxna rumotsane.” ");
INSERT INTO pibNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Wane koxa chinna Geso, “Wa gapnanutikalurgogne yine chinanu kamrutka. Wa yine gi kamrutka gapnanutikalurgogne chinanu. ");
INSERT INTO pibNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Giyagni wa gapnanutikalurgogne koxa gitsrukatno Gita wa Yineru Wgenno.” ");
INSERT INTO pibNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Jiglokatnaklu ginkaklewawakapji. Waneru satu jeji giprigamyotachri. ");
INSERT INTO pibNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Giruktatluna Geso wa gapnanutikalurgogne rutuukaklewatinri wa jigyegityapluna. ");
INSERT INTO pibNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Wane chinru wa jeji giprigamyotachri, “Pyotunotanu ganikajiya.” ");
INSERT INTO pibNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Wane chinatnakna Geso, “¿Girni wa gapnanutikalurgogne muklukanutu kamrutkalurupa: waka kiglerge waka gektutlege? ¿Gognetkaklurge giweklu waka giylalu?” Ga wa wanna pochke. ");
INSERT INTO pibNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Reknojtayegitna. Jigekanuwata. Wamonuwna wa shikgaji rixinrina. Wane chinru jeji, “Pomyokanu.” Romyoka. Ruglewamyotatka. ");
INSERT INTO pibNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Rushpakamtna Gwariseyone. Waneklutka Giroreyoneyma jemanshinikankakyegitluna Wale ruylatyapluna. ");
INSERT INTO pibNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Geso gitspalamta. Tsru wenu ya yimakleneyma. Romkagimtluna gixolune yine Kalile gajene Gote gajene koxa, ");
INSERT INTO pibNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Gerosale gajene, Gitome gajene, ga wa pasreta Gorta gajene, Tirostsi gwachine, Sitostsi gwachine, gixolune yine. Jemyegitluna gi pixkalutukokta kamruta. Runyegitluna Wale. ");
INSERT INTO pibNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Wane chinna Geso wa yimaklene galpokjixanutkalo kanawa gixolune yine chinanu ma machpakyanupluna. ");
INSERT INTO pibNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Gi rixanu gi gepika rutuukaka. Giyagni rujirkojetna Wale gogo yayixachine pejnunanuka kamrukyapluna. ");
INSERT INTO pibNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ga wa kamchine puchotlewatachine getinri yoptsojityegitluna. Saplewatna. Wane chinna wanna, “Pixni wa Goyakalu Wgenyi.” ");
INSERT INTO pibNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Geso gijretna gixo gi rupgujetanruna. ");
INSERT INTO pibNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Kanika magka. Tomgana Wale gishinikanune. Runyegitluna. ");
INSERT INTO pibNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Geso gitakna pamole gepi Waleyma gwachinepa, wa yokanatanunepa ginkaklewatachinepa, ");
INSERT INTO pibNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","wa kamchine maleka ruknokyapna. ");
INSERT INTO pibNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Rutakna pamole gepi: Simo; wale rutakgiwakata Petro; ");
INSERT INTO pibNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","wa Santiyako, Sewereyo wgene; Gwa, wa Santiyako gepuru (Giwakatna Wowanerge; walenwa rutlogle pixkalune), ");
INSERT INTO pibNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","wa Gantirishi, wa Wilipi, wa Wartolo, wa Matiyo, wa Tomasu, wa Santiyako Galgweyo wgene, wa Tateyo, wa Simo Muchkopiranawatachri; ");
INSERT INTO pibNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","wa Gota Giskaryote samyokjerupa. ");
INSERT INTO pibNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Panchi rapokinitkana, rapatjetatnakna yine. Giyagni wa wanna gi gimkata nikletna. ");
INSERT INTO pibNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Wa jempiranyegitluna wa Wale gimwanune. Runna kashichyapmakluna. Wane chinna wanna, “Sepronachrinatkani.” ");
INSERT INTO pibNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Gerosale yopikyana yonchikgapine. Wanna wane china wa waneylu Welsewo, wa tsru potu kamchiyma ruknokna kamchine maleka. ");
INSERT INTO pibNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Wa tomginitkana Geso, wane china yapkakluya, “¿Gi rixpoko maleka giknokletinwa Satanasyokakluko? ");
INSERT INTO pibNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Wa pogirewatikowaka gajene wannakakluko kotspalanshinikankakmaka, gi rumkata gwagogneretna wa wale pogirewatikowaka gajene. ");
INSERT INTO pibNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Panchi gajene wannakakluko kotspalanshinikankakmaka gi rumkata gwagognereta wa wale panchi gajene. ");
INSERT INTO pibNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Wa Satanasyo yagotinmakwa walenanuko wa, kotspalanshinikanutinmakwa gi rumkata gwaleta seyni nikawnanu. ");
INSERT INTO pibNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Gike gimkata jiglokletlu gipji gichkolu, chowgutyaplu rejnunkate ma mostutkanuwalu wa gichkolu. Waneklu chowgutyalu gipji gajeru. ");
INSERT INTO pibNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Galikaka wane nchingi, kaspuukalurupni wanna yine wgenene pejnuruneko mukochirkakna, mupashiregnuchi girukokta mupashiregnuchi yanumatini. ");
INSERT INTO pibNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Seyni girukokta wa Giwekikaluru Kpashiri mupashichkatu, gike rixiniko kaspukiko seyni giklukanuwnachri mukochri gike rixiniko mnikawnakatupa.” ");
INSERT INTO pibNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Gi rixanu wanna wane china, “Waneylu kamchi puchotlewatachri.” ");
INSERT INTO pibNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Tuna runro, repurune koxa. Maleka rawna. Repukmakluna. ");
INSERT INTO pibNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Wa gixolune yine ruxiplatjene wane chinruna, “Petanu. Malekna punro, pepurune. Rujgayina.” ");
INSERT INTO pibNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Wa Wale gigitna. Wane china, “¿Katni wa nunro, wa nepurune?” ");
INSERT INTO pibNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Retjetna ruxiplatanune. Wane china, “Getanna nunro nepurune. ");
INSERT INTO pibNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Wa girukokta kamrutlu Goyakalu galukanru, ga ga walenwa nepuru, nepuro, nunro.” ");
INSERT INTO pibNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Rumepe yinuwaka ginkaklewleta tsru wenustsiya. Rapatyegitluna gixo potu yine. ¡Gi pejnunanukta! Giyagni ratskotatka kanawa. Wane tuplatatka tsru wenuya. Pejnuruneko yine chiji gwa, tsru wenuwnaga. ");
INSERT INTO pibNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Runkaklewyegitna Geso yapkakluya gi gepikapirana. Wane chinna Geso runkaklewleya, ");
INSERT INTO pibNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Gjemanu. Satu kgitaklewakleru gishpakamta rutaklewtapanu. ");
INSERT INTO pibNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Wane rixa kopalajreta. Pimriji gatnugapostsi gapokajita. Runna koshichine teno yapachine. Niklokajitluna. ");
INSERT INTO pibNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Pimriji sotlu gwiyawaka gapokajita mawiyawakanu potu kajpa. Waneklu rupcheknimka gi rixanu gi wa tenru kajpa. ");
INSERT INTO pibNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Ga wa rushpakini tkachi jimanatkalu. Ma matskinu chinanu rupriganatka. ");
INSERT INTO pibNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Pimriji kona yegi gapokajita. Tseruwna konkaka. Kapotanatkalu. Gi kajinatkalu. ");
INSERT INTO pibNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Pimriji kiglewaka chiji, gapokajita. Wane jiwatya. Tseruwna. Ruxolewna. Rawa satu mapamoleji, satu patsrujirmoleji, satu satu pachaji.” ");
INSERT INTO pibNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Wane chinna Geso, “Kajnakopnalu wa yijnakotinripa, yijnakotanu.” ");
INSERT INTO pibNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Walepje rixini repomgaluna rawastsitanune pamole gepiyma wa yapkaklupiranaya. ");
INSERT INTO pibNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Wane chinna Geso, “Ga wa gixa geneeka gimatyaplu giyogimanatkaluru Goyakalu pogirewatyawakapirana. Wa maleka gajene ginkaaka yapkaklupjeya pejnurukopirana. ");
INSERT INTO pibNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Retinna retanmakna, ma mumatinitipna. Jeminna, jemanmakna, ma mumata jeminitipna, ma kashrijetikotupna, ma kaspukmukochiretkanupna.” ");
INSERT INTO pibNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Wane chinna Geso, “¿Gi ge gimatlu tye yapkaklu? ¿Gi gixpoko gimatletanru ptowruko yapkaklu? ");
INSERT INTO pibNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Wa kgitaklewakleru gitaklu tokanchi. ");
INSERT INTO pibNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ga ga wannanwa gatnugapostsi gwachine. Rutakikna tokanchi. Wa jeminitkana waneklu runa Satanasyo. Konyanna tokanchi rajna gitaakaluru. ");
INSERT INTO pibNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Waneko pixka rixna wa gitaakalurune sotlu gwiyawaka. Wa jeminitkaluna tokanchi waneklu yoptotluna rumuwleyna. ");
INSERT INTO pibNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Gi wa waneyna gitskina wanna. Wa pshinitsonu gwachinepa. Wa runini salewakchi, wa kojwawakchi tokanchi chinanu waneklu rutspekaakana. ");
INSERT INTO pibNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Pimrine gitaakalune wannanwa konyegirune wa tokanchi jemachine. ");
INSERT INTO pibNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Wa kojwakanshinikanrukaka tyegogneya ga wa ponikolewlu yokwire ga wa getsotanrewlu pagixankakaya jigloka. Kapotlu tokanchi. Gi wa jiwatanatka. ");
INSERT INTO pibNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Wannanwa gitaakaluru kiglewaka chiji, wa jemachine tokanchi. Wanna yoptotlu. Jiwatna, satu mapamoleji, satu patsrujirmoleji, satu satu pachaji.” ");
INSERT INTO pibNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Wane koxa chinna Geso, “¿Taniikege yochpikjetkalurompuko wa gimatumpuko ga wa shechimpuko tutakikolupa? ¿Gi ge katalo kgapiko tutakikolupni, wa tpokamlatinripa? ");
INSERT INTO pibNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Gi rixanu maleshlu wa yogimatkaluru ma mupgujetikotupa. Gi wa pochkeruko mpogijetkotupni. ");
INSERT INTO pibNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Girukokta kajnakopnalu wa yijnakotinripa, yijnakotanu.” ");
INSERT INTO pibNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Wane koxa chinna Geso, “Xakoka gyijnakotanru. Wa yantapi gixa yantajetinro, walako yantatingina gixanuko. Gyognikyegitko gixapa. ");
INSERT INTO pibNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Wa waneyalutu wanepnute reneeka. Waneyamigjetu wane rixle konikona.” ");
INSERT INTO pibNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Wane china Geso, “Wane rixa Goyakalu pogirewatyawaka wa satu jeji gitaklu giji chijiya. ");
INSERT INTO pibNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Rumka, yotunota, goyechno ga wa gogi. Wa kajiruji gipcheka. Tseruwna. Gi rumata gi rixpokota. ");
INSERT INTO pibNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Walenanuko jiwkaknawa wa chiji. Muchinanu yosnukapcheta; wanepnute gigwutka, wanepnute giji galixachri gigwuya. ");
INSERT INTO pibNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Wa ralijitinitka waneklutka gistakapi rustajikatka gi rixanu rapokatka gipapko jirgikolupa.” ");
INSERT INTO pibNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Wane china Geso, “¿Giru wutakanru wale pixkalutu pogirewatyawaka Goyakalu? ¿Giru yapkaklu wutakanru? ");
INSERT INTO pibNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Wa mostasaji pixka rixa. Wa chiji rutaakoklunu walenwa mtserutu ptowruko kajiruji giyagokolutu wa chijiya. ");
INSERT INTO pibNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Wa rali gitakletkoklunutka. Rupcheka. Tseruwna tsru potu ptowru kshana gitaakaluru pnute. Tsruplukakni. Giyagni koshichine tengogne gajene gimkata gwaleta gichiklempuko.” ");
INSERT INTO pibNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Gixo tye pixkalutu yapkakluya Wale ginkakna tokanchi wa rumkata jemletyawakna. ");
INSERT INTO pibNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ga wa yapkaklu migje gi wa runkakna Geso, seyni Waleko yimaklene wannapje rixini runkakpokowakatna ptowruko. ");
INSERT INTO pibNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Wa walegogne wa kayi rixinitka wane chinna Geso, “Wakanu gayanu.” ");
INSERT INTO pibNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Wa yokanatkatkana gixolune yine. Waneklu ranikatkaluna yimaklene kanawaya. Wane koxa yana pimro kanawkaka Waleyma. ");
INSERT INTO pibNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Yopyoka tsru kannipgyalu. Tuygajetlo gishpurga kanawa. Giyagni katsepgatkalo kanawa. ");
INSERT INTO pibNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Tostsi rawananumta. Rumkananumta rutspannojreya. Komyekluna. Wane chinruna, “Yimaklewatachri, ¿gikenna rixyi wa wupninripatka?” ");
INSERT INTO pibNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Wa yotunotinitka chigetjetlu kannipgyalu. Wane chinru wa tsru wenu, “Pochke. Pushyanamatanu.” Rutuka wa kannipgyalu. Mayegixgataa rixanatka. ");
INSERT INTO pibNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Wa wane chinna Geso, “¿Klu chinanu mpikatka? ¿Klu chinanu gi galixgognenatawa?” ");
INSERT INTO pibNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Pikna tsru piklu. Wane chinkakna wannakakluko, “¿Katni wa Tye? Wa kannipgyalu wa tsru wenu jemyawaklu.” ");
INSERT INTO pibNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Wakanu yana tsru wenuya Gerasenonesreta. ");
INSERT INTO pibNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Wa ruptekinitka kanawaya, waneklutka yoptotaplu satu jeji yomlechi gajeru. Kamchi puchotlewatachri waneyalutu. ");
INSERT INTO pibNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Yomlechi yegi gwachrini wale. Gikeko gimkata gosturetatkalu, gi wa yowumatsayakoxapa. ");
INSERT INTO pibNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Wa gi gepi kata wane rostutkamkatka supoya yowumatskoxaya. Wa yowumatsni rustonjemtana waleya. Wa supni tutskinjemtana. Gikena poyago gipuchkakletlu. ");
INSERT INTO pibNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Psolyechnoko psolgogneko wane rixa saplewjenanumta magkaya yomlechkakaya. Rustajitnawa sotluya. ");
INSERT INTO pibNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Wa retinitkalu wa Geso gowukayako rasukamta. Yoptsojityegitlu. ");
INSERT INTO pibNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Saplewata. Tsruplaji rixa. Wane china, “¿Gi pixanutkano Geso, Goyakalu teno potu Gajeru Wgene? Kachingagjire nixyi Goyakalu kawchinanu, gi wa psaletpotutanno.” ");
INSERT INTO pibNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Gi rixanu Geso wane chinatkalu, “Pushpakyegitanru tye jeji, kamchi puchotlewatachri.” ");
INSERT INTO pibNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Geso gepomgalu, “¿Klu giwakyi?” Rugitlu. Wane china, “Ngiwaka Gixoluru, wa gixolurunpotwu.” ");
INSERT INTO pibNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Wa ragjitlu maleka ma yokanatyaplu tyesretaya. ");
INSERT INTO pibNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Wanenanru magkastsi gixoluru kochi. Nikanatna. ");
INSERT INTO pibNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Ragjitluna pejnuruneko kamchine. Wane chinna, “Kochi yegi pyokanatanunwu wa wanna wjiglokyapa.” ");
INSERT INTO pibNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Geso gichichna. Rushpakamtatkana kamchine puchotlewatachine. Kochinni jiglokamtatkana. Gixolunni kochinni gipjita gijrukyanatka. Tsru wenu rapokanna. Wanegetkonna gepi waragka. Tsru wenu gagyekyachinena. ");
INSERT INTO pibNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Wanna kochi girukotachine gasukamta. Runkaklewtapna tsru pokchiya, ga wa sana gajene koxa. Runatkana retapyapluna klunerukta wane gixkaluru. ");
INSERT INTO pibNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Runyegitluna Geso. Retluna wa kamchitpachri wa gixoluru gwanatanru. Tuplanatatka. Kamkatkalu. Kanshinikanutkalu. Pikanna. ");
INSERT INTO pibNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Retanatjene ginkakna gikta rixpokonatka wa kamchitpachri, wa kochinepirana. ");
INSERT INTO pibNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Yinuwaka gagjiretluna Geso wa rushpakinripa wannasretaya. ");
INSERT INTO pibNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Ratskota kanawa. Wa kamchitpachri gagjitlu wa Wale yegi rawinripatka. ");
INSERT INTO pibNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Geso gi galuka ganikletlu. Wane chingonuklu, “Pupji pyanutka pumwanune yegi. Punkakanna gikta rixpokotatkayi Gitsrukaachi. Wale punkakanna retwamonutyayi.” ");
INSERT INTO pibNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ralimta. Yinuwaka ginkaklewletatka Ntekapoliya gikta rixpokotatkalu Geso. Pejnuruneko gimyeka. ");
INSERT INTO pibNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Koprugatatnaka Geso kanawaya. Wakanu ya. Rapatyegitluna gixo yine. Tsru wenuwnaga rawa. ");
INSERT INTO pibNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Runa satu wa tsru gitaakalurune ginkaklewawakapji gajenyegiya, Gayro giwakatletachri. Retinitkalu yoptsojityegitlu Gesojixistsiya. ");
INSERT INTO pibNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Wane chinru, “Wuya wanepnawakla nshicho wgeneji. Petapanunro. Tupnakastsinatkani. Putakamyogogotanunro tutskalginripa. Tuwekanu.” ");
INSERT INTO pibNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Geso waleymamnutka. Romkagimtluna gixolune yine. Rachpakluna. ");
INSERT INTO pibNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Sato suxo gigragalewatachrona. Pamole gepi walapu gigragalewatachrona. ");
INSERT INTO pibNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Gixo kpinrewaklerunyegimka tyanitka. Wanna chinanu tsalewna gixo. Tnikatlewatanatka ptowruko walanuko tixinri. Gikena gipxakanro. Seyni taalinanumtana. ");
INSERT INTO pibNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Tjempiranyegitinitkalu Geso, tuna Wale gajxigiya wa gixolune yine yegi. Tkamrukamkatlu. ");
INSERT INTO pibNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Wa wane china wala, “Nkamrukamkashatinri nutskalganu.” ");
INSERT INTO pibNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Waneklutka tograga gitskikatka. Tumatnawa tomaneya tuglewatinritka wa tsalewnanatinri. ");
INSERT INTO pibNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Waneklutka Geso gimatatka Walenanuko rushpakamtyatka giyaklu. Ruprotaka wa gixolune yine yegi. Wane china, “¿Katu kamrukamkatno?” ");
INSERT INTO pibNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Wane chinruna wa yimaklene, “Gi ge petna wa gixolune yine gachpakyawakyi. Seyni wane pchina, ‘¿Katu kamrukno?’ ” ");
INSERT INTO pibNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Wale geknojtata retyaplo katukta wane gixlu. ");
INSERT INTO pibNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Wa suxo pika. Tutatata. Tumata wa wala gixyawaka. Tuna. Tyoptsojityegitlu Wale. Tunkaklu ptowruko galikaka. ");
INSERT INTO pibNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Wale wane chinro, “Wiwi, palixle gitskalakyi. Pyanu. Kiglenshinikanpatkayi. Kiglepatkayi wa psalewninrinanutka.” ");
INSERT INTO pibNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Yanumsatiniwa Wale, ginkaklewawakapji gitsrukatepji runyana pimrine. Wane chinna, “Pshichni tupnanatka. ¿Klu chinanu pkojwakawalu Yimaklewatachri?” ");
INSERT INTO pibNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Seyni Geso jemashatlu tye tokanchi wane chinkaluru. Wane chinru tsru gitaakaluru ginkaklewawakapji gajeru, “Gi pumyekanu. Palixashatanu.” ");
INSERT INTO pibNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Gi wa ruchichlu wa satu gininripa Wale gajxigi ga wa Petro, wa Santiyako, wa Gwa, repuru wa Santiyako ");
INSERT INTO pibNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Wane ya gipjiya ginkaklewawakapji gitsrukate. Retlu sejrechi, chiyagatachine, saplewjepotutachine. ");
INSERT INTO pibNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Jiglokamta. Wane chinna Geso, “¿Klu chinanu nsejrewna nchiyaganata? Wa mturo gi tupna seyni tumkanata.” ");
INSERT INTO pibNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ruxpiranatluna. Wale maleka giknokna pejnuruneko. Ranikna wa mturni giru ga wa tunro, ga wa Waleymalune koxa. Jigloka mturni gwiyawaka. ");
INSERT INTO pibNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ga wa kosemyotinitkalo mturni, wane chinro, “Talita komi.” Walenwa yokaakaluru: “Mturo, pixa wane nchinyi, pyotunotanu.” ");
INSERT INTO pibNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Waneklutka mturo yotunotatka. Tyanatka, gi rixanu waneyatkalo pamole gepi walapu. Waneklutka ruglajitna. Tsru giglajru rixna. ");
INSERT INTO pibNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Wale gijretna gikena gimatanru. Wane china teneeko tnikanru. ");
INSERT INTO pibNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Rushpakamta waneya. Rapoka gichijne. Romkagitluna yimaklene. ");
INSERT INTO pibNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Rapokinitka, gapnanutikalurgogne yinuwaka ginkaklewleta wa ginkaklewawakapjiya. Gi gepika yijnakotlu. Ruglajitna. Wanna wane china, “¿Ginaka rumatyalu Wale tyekaka? ¿Klu gimatkalewlunwa tye renekikolu wa Wale? ¿Gi pixkalutunanni ruyaklekaka kamrutkalurni gimyoya? ");
INSERT INTO pibNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","¿Gi ge kyosokoklerukni tye, wa Mariya wgene, wanna Gosi, wa Gota, Simo wanna yegwaklu? ¿Gi wa gewna wixayma repurone?” Wale rutspenshinikanutyana. ");
INSERT INTO pibNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Wa Geso wane china, “Goyakalu tokanu geneklewatachine kagwakpiratkalunni, seyni gichijnepjeya, ga wa gimolenyegisretaya, ga wa gipjiya mkagwakpiratkotni.” ");
INSERT INTO pibNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Gi wa rumkata kamruretlu waneya wa satu ruyakleya. Rutuukakna psotsotajiko yayixachine, walepje. Wanna gogo rutakamyota. ");
INSERT INTO pibNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ruglajita wa ma malixleyna. Sajrukamta papokchikaka walesreta. Runkaklewata. ");
INSERT INTO pibNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Tomgana Geso wa pamole gepi. Wa yinuwaka yokanretna gepkaka. Tsru rutakna wa kamchine puchotlewatachine chinanu. ");
INSERT INTO pibNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Yokanatatkana gikena ranikanna wa gatnugapoya, satupjeru kanojerna; gi wa nikanruna, gi wa tsapako, gi wa sroschiko tsapaneyna. ");
INSERT INTO pibNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Wa rutakanrona yoshmakjixrechishpatapje. Gi wa gepimkalu rutakanna. ");
INSERT INTO pibNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Wane chinna Wale, “Ginakakokta gjiglokanu satu panchi, wanepji gwanu gishpakamtinpotunanuko waneya. ");
INSERT INTO pibNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Wa pejnuruneko wa gma yoptotjenepa, gma jemjenepa, gishpakamtinpatka wa waneya giplokjiximtanu gistapjixipagi wa rumatikolupa wanna chinanu.” ");
INSERT INTO pibNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Rushpakamtatkana. Runkaklewatna wa yine genshinikanutanu. ");
INSERT INTO pibNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Gixo kamchine maleka ruknokna. Ruyookana ringi gixo yayixachine. Rutukna. ");
INSERT INTO pibNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Pogirchi Girore jemyegitlu. Gi rixanu rumatkatka Geso giwaka. Wane china, “Gwa wa katlewatachri yotunota gipnachineya. Giyagni kgiyaklewaklerni Wale.” ");
INSERT INTO pibNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Pimrine wane china, “Giliyni.” Pimrine wane china, “Goyakalu tokanu geneklewatachrini. Satu tokanchi geneklewatachri pixka rixa.” ");
INSERT INTO pibNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Jeminitka Girore wane china, “Gwakni wale wa nustaknoojixanru. Yotunotatka.” ");
INSERT INTO pibNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Gi rixanu muchikawako Girore towyegitanru. Kashijixlu Gwani. Rostujixlu wa yoshmakwaka wa Giroryana chinanu repuru gnunro Wilipi. Wa wala ganunrota Girore. ");
INSERT INTO pibNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Gi rixanu wa Gwa wane chinatkalu Girore, “Ginanshichkalurni wa pepuru gnunro waneyyi pixinri.” ");
INSERT INTO pibNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Giyagni Giroryana gayegixlu. Taluka giylajixletlu. Gi tumkatlu. ");
INSERT INTO pibNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Gi rixanu wa Girore piklu wa Gwa. Rumatlu wa wale jeji poyagkakachrini wa kpashirni. Girukotlu. Giyagni jeminri gi rumatanshinikanuta. Yijnakotlu rumuwleya. ");
INSERT INTO pibNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Runa pagogne ruglepoktapini wa Girore wa poyagkakawalaputetini. Meyiwlu nachnewlupa kamruta wa tsrukakalune, tsru gitaakalune, wa wanna potu Kalile gajene chinanu. ");
INSERT INTO pibNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Tjiglokamta Giroryana nshicho. Tansata. Tmeyitlu Girore ga wa waleyma gwanatachine nikawakakwa. Pogirchi wane chinro makloji, “Pagjitanno klunerukokta paluka. Gita genekanyi.” ");
INSERT INTO pibNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Wale kawchinau wane chinro, “Pagjitanru pejnunanuka nenekanyi. Ganikajiko npogirewatyawakaya nenekanyi.” ");
INSERT INTO pibNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Tushpakamta wala. Wane chinro tunro, “¿Klu nagjitanu?” Wala wane china, “Wa Gwa katlewatachrijiwu pagjitanu.” ");
INSERT INTO pibNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Waneklutka giyampotu tjiglokyegitlu pogirchi. Tagjitlu. Wane chinru, “Naluklu xawakniko, penekyapno satu kotajipi Gwa Katlewaklerujiwu.” ");
INSERT INTO pibNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Wa pogirchi wamonuwnapotuta, seyni Wale kawchinanu chinrekaka, waleyma gwanatachine nikawakakwaya chinanu, gi raluka giknokakletokanuta. ");
INSERT INTO pibNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Waneklutka pogirchi yokanatlu satu girukotjeru. Yokanatlu ranikjiwutikolupa. Wa wale wane ya. Rustaknojitlu yoshmakawakaya. ");
INSERT INTO pibNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Ranikjiwutatkalu kotajipiya. Reneklo makloji. Wa makloji geneklo tunro. ");
INSERT INTO pibNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Jeminitkana wa yimaklene, runna. Ranikluna gimane. Yomlechi rutakluna. ");
INSERT INTO pibNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Yokanatanune rapatjetna Geso yegi. Runkaklewyegitluna ptowruko klunerukta kamrutanrunapirana, wa runkaklewtapinrina. ");
INSERT INTO pibNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Geso wane china, “Ginanu gixa mkoje yineru mwiyawakanuya. Gapnanutanu pshinitsonu.” Gi rixanu gi gepikna wane ginachine yachine. Gi wa kagognena nikinripna. ");
INSERT INTO pibNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ralimtna wanna mkoje sato kanawaya yineru mwiyawakanu. ");
INSERT INTO pibNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Gixo geta yaletna. Rumatkana. Wane rasukyegitluna chijiya ptowruko tsru pokchikaka gajene. Wanna gapka gapoka. Rapatyegitluna Geso. ");
INSERT INTO pibNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Ruptekamta Geso. Retna gixolune yine. Retwamonutna gi rixanu gowegane pixka rixna gi waneyna girukotjerna. Yinuwaka ginkaklewyegitna gixopirana. ");
INSERT INTO pibNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Wa kayi rixinitka yimaklene gapyegitlu. Wane chinna, “Gewni yineru mwiyawakanu. Wa kayitkani. ");
INSERT INTO pibNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Pyokanatanna yine wa sana yinripna, wa pokchikaka tyesretaya wa ragjityapluna nikanrupna.” ");
INSERT INTO pibNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Rugita Wale. Wane china, “Gixa genekanna nikanropna.” Wane chinruna, “¿Wanerge gayanu? ¿Wagjitanro jimapro gepi pachproji wenroloto, wenekyapna nikinropna?” ");
INSERT INTO pibNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Wale wane china, “¿Gi pejnu jimapro waneygi? Getapanro.” Rumatinitkana. Wane chinna wanna, “Pamyo. Gepi shima.” ");
INSERT INTO pibNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Towutna wanna tuplatinripna pejnuruneko paptogkaka peklomta poleru. ");
INSERT INTO pibNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Tuplatna paptogkaka satu pachkaka ga wa pamyomolkaka koxa. ");
INSERT INTO pibNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Geso kashichlo pamyo jimapro ga wa gepi shima. Tengogne yigata. Ruglenshinikanyegitlu. Wa jiknajrotlu jimapro. Renekna yimaklene rutspamtinripna. Raneksatkana wa pejnuruneko wa gepiroto shima koxa. ");
INSERT INTO pibNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Nikatkana pejnuruneko. Jinanutkana. ");
INSERT INTO pibNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Koschekluna psojkaka pamole gepi kojita katsepo, ga wa shima koxa. ");
INSERT INTO pibNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Wa nikachine pamyo waragka jejine. ");
INSERT INTO pibNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Waneklutka kanawa ratskojixatkana yimaklene wa Wetsayta gapka yinripna wakanu. Wane yakopshinna yokanatna gixolune yine. ");
INSERT INTO pibNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Rali gingaletinitkana wane ya magka. Ragjigognetapa. ");
INSERT INTO pibNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Wa kayi rixinitka wa kanawa ganikajgatkalo tsru wenuya. Walepje chiji gwatka. ");
INSERT INTO pibNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Retna kegeknanuwatna ranikgatyawakna. Wa kannipgyalu satkakanna. Wa goyechnokawpotuko Geso ginyegitna. Tsru wenumta yapananumta. Raluka giknoglemtna. ");
INSERT INTO pibNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Retinitkaluna wa tsru wenumta yanamtyawaka. Kagwakluna pagixanu. Saplewatanna. ");
INSERT INTO pibNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Gi rixanu pejnuruneko getlu. Rumyekanna. Waneklutka Geso giynumatna. Wane china, “Kiglenshinikanupgi. Gitni. Gi wa mpikanu.” ");
INSERT INTO pibNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Ratskota kanawa wanna yegi. Rutukamta kannipgyalu. Ruglajpotutanna. ");
INSERT INTO pibNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Gi rixanu gi rumata jemluna wa jimaprokakapirana. Shikowgajitna wane rixinrina. ");
INSERT INTO pibNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Wa koprugatinitkana, wane yana Genesarchijne. Rutspakatkana. ");
INSERT INTO pibNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Ruptekinitkana wa kanawaya, waneklutka rumatkatka Geso. ");
INSERT INTO pibNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Rasuktatna psoluko walesretaya. Yinuwaka gwapletkana pnumnu gajene yayixachine gijekoyna ginakakta jemyegityawakluna. ");
INSERT INTO pibNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Ginakakokta rapoka pokchikaka, tsru pokchikaka, sana, rutaakana giputkaka yayixachine. Ragjitluna wa kamrukashatyapluna gimkaluptostsiya. Wa pejnuruneko wa kamrukachine wanna gitskalgatka. ");
INSERT INTO pibNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Rapatyegitluna Gwariseyone, pimrine koxa yonchikgapine wa Gerosale giyakatyachine. ");
INSERT INTO pibNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Wanna getinna wa pimrine Wale yimaklene nikyawakna gimyoyna gimuteru, walenwa merkakotu yangakanna. ");
INSERT INTO pibNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Wa Gwariseyone, pejnuruneko Gote gajene waneyna giykolu rutsrukateynina wa gixo kata ma meromyogkanna ma merkakanotkanna gi wa nikanna. ");
INSERT INTO pibNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Giputu ruyakatyana ma powratkannuwana gi nikanna. Gixo pimripirana wa yoptotanruna kamrutanruna, wa gerkikaluro wa girapkaka, gashgajkaka, yowumaswagkaka.) ");
INSERT INTO pibNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Repomgaluna Gwariseyone ga wa yonchikgapine, “¿Klu chinanu wa pyimaklene gi wa wane rixna wa gitsrukaachinni giykole, seyni nikna wa gimyoyna gimuteru?” ");
INSERT INTO pibNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Geso wane china, “Sanowashatachingi. Goyakalu tokanu kigle reneklewata Gisayiya gixapirana. Wane rixa yonatkaluru: Nyi yine gispuyna kagwakpiratno seyni rajiyna wajra yanna Gitaya. ");
INSERT INTO pibNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Magijeru yonogleyegitnona. Runkaklewatna wa Goyakalu tokanu pixkalutu wa yokanrekakna wa yine. ");
INSERT INTO pibNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Wa gixa giknoklu Goyakalu yokanatanru tokanchi. Waneygi wa yine giykole.” ");
INSERT INTO pibNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Wane chinkoxna Geso, “Kigle giknokle gixlu wa Goyakalu yokanatanru tokanchi wa gomkagityaplu wa gixako giykole. ");
INSERT INTO pibNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Wa Moysisi wane china, ‘Pkagwakpiratanru puru punro.’ Wane koxa china, ‘Girukta gogimtukaklu ruru, runro walepni wa gipnanu.’ ");
INSERT INTO pibNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Ga wa gixa wane china, ‘Wa satu jeji wane chininri wa ruru ga wa runro, “Ptowruko gitanu wa wale gipxakyapmakyi, korwani” ’ (Walenwa genekashlu Goyakalunupa). ");
INSERT INTO pibNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Gixa gi gichichanutkalu pagixanu kamrutinripa ruru, runro chinanu. ");
INSERT INTO pibNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Gixa kaspuklu wa Goyakalu tokanu wa giykole chinanu wa gixako genekanru. Gixo wale pixkalutu gkamruta.” ");
INSERT INTO pibNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Wa tomgatnakna gixolune yine. Wane chinna Geso, “Gyijnakotanno pejnurunekgi. Gimata jemanu. ");
INSERT INTO pibNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Gike wane wa yineru malekate wa jiglokinripa rumkata puchotletyaplu, seyni wa yineruyako gishpakyachri walenwa puchotlu wa yineru. ");
INSERT INTO pibNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Girukokta kajnakopnapa wa yijnakotinripa, yijnakotanu.” ");
INSERT INTO pibNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Rutspalamtinitka wa gixolune yine yegi, jiglokinitka panchi, repomgaluna yimaklene wa yapkaklupiranaya. ");
INSERT INTO pibNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Wane chinna Geso, “¿Gixa koxa wane gixa mumatjemkangi? ¿Gi ge gimata jemlu wa pejnuruko maleka gwachri wa jigloklu yineru gi rumkata puchotletlu? ");
INSERT INTO pibNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Gi rixanu gi wa jigloklu wa raji seyni ginanwakapje. Rushpaka gichkajetyawaka.” Wale powratlu ptowruko niikaluru. ");
INSERT INTO pibNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Wane china, “Wa yineruya gishpakyachri, ga ga walenwa puchotlu yineru. ");
INSERT INTO pibNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Wa gitoko rajiyna yine rushpakya gektutu shinikanchi, gimopatlewlu, gapoklewlu, giylalewlu, ");
INSERT INTO pibNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","chowguchkaka, gimkapnuglu, muglenchi, yokwikaklu, mpogijpatnuchi, sotanugnuchiygale, mupashiregnuchi, tserpiranawlu walenanuko, sepronchi. ");
INSERT INTO pibNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Ptowruko wa tye muglenchi gishpaka gitokoya. Ga ga walenwa puchotlu yineru.” ");
INSERT INTO pibNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Wane yiyatka Geso. Tirosreta ga wa Sitoya yatka. Jiglokamta panchi. Wale galuklu gike ma mumatyanupa, seyni gi rumkata yogimleta. ");
INSERT INTO pibNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Seyni waneklutka tjemyegitlu sato suxo. Tshicho wgenejni waneyanro kamchi puchotlewatachri. Tuna. Tyoptsojityegitlu gijixistsi. ");
INSERT INTO pibNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Wa suxni Kriyko, Sirogwenisanemole. Tagjitlu ruknokyaplu maleka kamchi tshichoya. ");
INSERT INTO pibNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Geso wane chinro, “Petashgapkatanna jinanu rixinripna yine wgenene. Gi kigleru kashichikolupa wa nikanruna wgenchine, ruknokikolupa kewene yegi.” ");
INSERT INTO pibNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Tugitlu wala. Wane chinru, “Gigi, Gitsrukaachi, seyni wa wanna keweneko nikawakakwa rapukote nikyaluna wa mturune gipopejre.” ");
INSERT INTO pibNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Wale wane chinro, “Tye tokanchi chinanu pyanutka. Wa kamchi gishpakyatkalo wa pshicho.” ");
INSERT INTO pibNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Talimta topji. Tetamtatkalo tshicho tukluganatatka tojeko, wa kamchi gishpakyatkalo. ");
INSERT INTO pibNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Wane yiyatnaka wa Tirosretaya. Sito yapamta. Tsru wenu Kalile ya, Ntekapoli ganikajite. ");
INSERT INTO pibNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ranikyegitluna satu majnakotu, myanumatkatu. Ragjitluna rutakamyogogotyaplu. ");
INSERT INTO pibNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Geso ganiklu yine mwiyawakanu Walepje. Yoshmakamyojita gijnakopnakakaya. Rutskagata. Kamrukannutlu. ");
INSERT INTO pibNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Tengogne yigata. Kosennipgyapotuta. Wane chinru, “Gegwata.” (Walenwa: Putpukanu.) ");
INSERT INTO pibNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Rutpukajnakopnatatka. Waneklutka rushpirokatka wa kashinatjeru wa ginnu. Yanumpotutatka. ");
INSERT INTO pibNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Yokanatatkana Geso gikena runkakanna, seyni gixkatmaka wane china wanepnuteko runkaklewamtna. ");
INSERT INTO pibNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Tsru giglajru rixna. Wane chinna wanna, “Kiglepotlu ptowruko kamruta. Jemkakna majnakone. Wa myanumatkane yanumkaka.” ");
INSERT INTO pibNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Wa walegognekaka wanetnakna gixolune yine. Gi wa waneyanna nikanruna. Geso tomgana yimaklene. Wane chinna, ");
INSERT INTO pibNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Netwamonutna gixolune yine, gi rixanu waneyatkana mapgogne Gitayma. Maleshayna nikanruna. ");
INSERT INTO pibNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Wa nyokanatinnatkana ma niikanna wa gipjina, rujxipakgapotanunna. Wa pimrinni gowuka giyakatyana.” ");
INSERT INTO pibNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Rugitluna yimaklene, “¿Ginaka giyakatyachro jimapro wa satu gimkata ginanuwkakletanunna gewi yineru mwiyawakanuya?” ");
INSERT INTO pibNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Geso gepomgana. Wane chinna, “¿Gi pejnu jimapro waneygi?” Wanna wane china, “Payokgipre.” ");
INSERT INTO pibNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Yokanatna wa gixolune yine tuplatinripna chiji. Kashichlu wa payokgiprerutu jimapro. Poyagnutatka. Jiknajrotlu. Wa renekna yimaklene rutspamtinripna. Reneksatna gixolune yine. ");
INSERT INTO pibNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Waneyna psotsotaji shima wgenkaka. Wale giglenshinikanyegitlo. Wa yokanatna rutspamtinripna. Rutspamtna gixolune yine yegi. ");
INSERT INTO pibNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Nikatkana. Jinanna. Koschekluna wa gixetachri psojkaka payokgipre kojitaya. ");
INSERT INTO pibNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Wanegetkona gepkoxamkoje waragka yine. Yokanatatkana. ");
INSERT INTO pibNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Waneklutka ratskota wa kanawa yimakleneyma. Wane ya Talmanutasreta. ");
INSERT INTO pibNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Runna Gwariseyone. Yinuwaka yoptopiiretluna. Rujgaluna Waleya getkaluru tengogne gajeru. Yantaletluna. ");
INSERT INTO pibNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Wamonuwnalenshinikanuya kosennipgyapotuta. Wane china, “¿Klu chinanu rujgaluna getkaluru tye gimuweekakgognenatachine? Galikaka wane nchingi, gi wa reneekona getkaluru tye gimuweekakgognenatachine.” ");
INSERT INTO pibNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Kaspukatkana. Kanawa ratskotatnaka. Wakanu ya. ");
INSERT INTO pibNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Ramtaka gwalemtluna nikanruna. Maleshayna. Satupje jimapro waneyna wa kanawa. ");
INSERT INTO pibNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Yokanatna Geso. Wane china, “Xako. Ggirukotinwa wa gisekachriya wa Gwariseyonenu, wa gisekachri koxa Girorenenu.” ");
INSERT INTO pibNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Yoptopirkakna wannakakluko. Wane chinkakna, “Jimapro maleshaywu.” ");
INSERT INTO pibNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Geso gimatlu. Wane chinna Wale, “¿Klu gyoptopirkakya wa maleshaygi jimapro? ¿Gi ge gishinikanuwatawa? ¿Gi ge gimata jemanatawa? ¿Waneygi shikolu gaji? ");
INSERT INTO pibNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Kaygalmakgi ¿gi ge geta? Kajnakmakgi ¿gi ge gjema? ¿Gi ge gishinika? Wa njiknajrotinitkalu pamyo jimapro wa pamyo waragkaneya ¿gi pejnu kojita katsepo wa psojkaka gkoschekyatkalu gixa?” ");
INSERT INTO pibNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Wanna wane chinru, “Pamole gepi kojita.” ");
INSERT INTO pibNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Wa payokgipre jimapro wa gepkoxamkoje waragkaneya ¿gi pejnu kojita katsepo wa psojkaka gkoschekyatkalu gixa?” Wanna wane china, “Payokgipre kojita.” ");
INSERT INTO pibNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Wane chinna Geso, “¿Gi ge gimata jemawalu?” ");
INSERT INTO pibNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Rapokna Wetsayta. Rawapluna Wale yegi satu maygaletu. Ragjitluna kamrukyaplu. ");
INSERT INTO pibNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Geso kanjimtlu wa maygaletu. Raniklu pokchi kegneteya. Gitskaga sagaygaletlu. Rogwaka rutakamyoyegitlu. Repomgalu, “¿Gi ge petlu pa gixanu?” ");
INSERT INTO pibNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Rumrekgata. Wane china, “Netna yine, wa yanachine wa gagmuna pixka gixachine neta.” ");
INSERT INTO pibNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Rumepe gitakamyoyegletatnaklu wa giygale. Waneklu retatka. Ruglewatatka. Retashpotutatka gowuka ptowrupotuko. ");
INSERT INTO pibNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Geso yokanatatkalu gipji. Wane chinru, “Gi wa pokchiko pyanu.” ");
INSERT INTO pibNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Yatkana Geso wa yimakleneyma. Pokchikaka ya Susari Wiliponu yegi. Wa gatnugapoya repomgiyna wa yimaklene. Wane chinna Wale, “Wa yine ¿katu wane chinna Gita nixinri?” ");
INSERT INTO pibNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Wanna gigitlu. Wane chinruna, “ ‘Gwa Katlewakleru;’ pimrine, ‘Giliya;’ pimrine, ‘Satu Goyakalu tokanu geneklewatachine.’ ” ");
INSERT INTO pibNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Wa Wale gepomgana, “¿Ga wa gixa katu wane chinno?” Rugita Petro. Wane chinru, “Pixni Kristoyi.” ");
INSERT INTO pibNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Rujretna ma yanumsatinitipna Walepirana gikena. ");
INSERT INTO pibNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Yinuwaka ginkakletna wa Yineru Wgene salewninripa gixo, ma yoptotikotupa tsruneya, tsrukakalune sasertoteneya, ga wa yonchikgapineya. Ruylatikolupa. Yotunotanu mapgogne chininri. Wane chinru tye tokanchi gipgujetkaluru. ");
INSERT INTO pibNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Wa Petro ganiklu. Yinuwaka chigetjeretlu. ");
INSERT INTO pibNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Geso giprotakyegitna. Retjetna yimaklene. Chigetjetlu Petro. Wane chinru, “Najxigi pyanutka, Satanasyo. Gi rixanu gi pushiniklu wa Goyakalupirana, seyni wa yinepirana galikaka pushinika.” ");
INSERT INTO pibNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Tomgana Geso wa gixolune yine yimakleneyma. Wane china, “Katukokta galuka gwagajxigletno raalixinwa walenanuko. Rawanro koroshishkitate. Romkagitanno. ");
INSERT INTO pibNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Girukokta galuka gishatkapletlu wa ruwekinri, ruwekinri ramginina. Girukokta gamtakanru ruwekinri Gita chinanu, Kiglerpotunanu Tokanchi chinanu, rushatkapanru ruwekinri. ");
INSERT INTO pibNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Gi rixanu ¿klu kigleyanaplu wa yinerupni psolchijnekmaka waneyapmaklu wane rixle, seyni ruwekinri ramgapotutinina? ");
INSERT INTO pibNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Gi rixanu ¿klu rupekotanru yineru ruwekinripa? ");
INSERT INTO pibNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Katukokta gipatewatanno ga wa ntokanuya koxa wa nyi gimuweekakgognenatachine yegi, kgimopataklerune ga wa kmukochirerunni, Gita wa Yineru Wgenno koxa gipatewatanru wale, wa nuninipa Nuru goyaknuya, wanna kpashirine Goyakalutowrerune tengogne gajene numuninipa.” ");
INSERT INTO pibNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Wane chinkoxna Geso, “Galikaka wane nchingi, pimrine gewi gwachine gi wa getumganru gipnalu ma metkanuwalunachi Goyakalu pogirewatyawaka ginachripa giyakluyma.” ");
INSERT INTO pibNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Patsrujirgogne rixinri, Geso ganikna Petro, Santiyako, Gwa. Ranikna wannapje satu magka tenolu. Wanna getanu satuko kogetkogatka. ");
INSERT INTO pibNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Ga wa gimkalu yochigatatka klatpotlu. Wa giwru pixka rixa. Giyagni gi satuna kgerkakleru tye chiji gwachri gimkata klataa gixkakletlu tye pixka. ");
INSERT INTO pibNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Wanna yegi rupgujewniyna Giliya ga wa Moysisi, Geso giynumsatachine. ");
INSERT INTO pibNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Petro, wane chinru Geso, “Yimaklewatachri, poyagnu gewi gawinri. Gewi wkamrutanru mapa gimajechri. Pixanupa satu, Moysisinupa satu, wa Giliyanupa satu.” ");
INSERT INTO pibNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Gi rumata yanumatana, ga wa pikanna. ");
INSERT INTO pibNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Runa kyachgapererumko. Wale chikletyegitna. Waneylu tokanchi kyachgapererumkoya, wane chinachri, “Tyenwa Noturu nalukanru. Wale gyijnakotanu.” ");
INSERT INTO pibNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Pshinitsonu potu retanatinna, gikena retatkana wannayma. Gesopjetkani. ");
INSERT INTO pibNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Magka yopikyatkana. Yokanatna Geso gike runkakinripna wa retanruna, ma yotunotkanuwa wa Yineru Wgene gipnachineya. ");
INSERT INTO pibNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Rushinikluna wa tokanu. Rugjekakna wannakakluko, “¿Klunerni wa tye, wa gipnachinyegiya yotunotini?” ");
INSERT INTO pibNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Repomgaluna. Wane chinruna, “¿Klunerni wa yonchikgapine chinanru wa Giliya gapkamka ginanu?” ");
INSERT INTO pibNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Rugitna Wale. Wane china, “Giliya galikakni rungapkatanu rugletyaplu ptowruko. ¿Gi chinpiranata koxa wa yonchi wa Gita Yineru Wgenno gixo nsalewninripa, ga wa gi nkagwakpiratko? ");
INSERT INTO pibNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Seyni wane nchingi Giliya ginpatka. Wane rixluna klunerukokta ralukyawakna chinyawaka yonchi walepirana.” ");
INSERT INTO pibNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Runinitkana wa yimaklene yegi. Retna gixolune yine wanna yegi. Wa yonchikgapine yoptopiratna wanna. ");
INSERT INTO pibNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Waneklutka pejnuruneko gixolune yine getlu. Ruglajitna. Rasukyegitluna. Ralukluna. ");
INSERT INTO pibNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Geso gepomgana, “¿Klu gyoptopiratyana wanna?” ");
INSERT INTO pibNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Gixolune satute gigitlu. Wane china, “Yimaklewatachri, nanikyegityi noturu. Waneyanru kamchi myanumatkatu rixkakjeru. ");
INSERT INTO pibNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Ginakakokta kashichyanru shipchojtakakjetanru. Soliwanamjetana. Raskereygitana. Ruprigananumtana. Wane nchinna pyimaklene ruknokyapluna maleka, seyni gi rumkatluna.” ");
INSERT INTO pibNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Rugita. Wane chinna Wale, “¡Ya nyi gimuweekakgognenatachine malixkane! ¿Gi pejnugognenanukta numwanutkagi? ¿Gi pejnugognenanukta nakotangi? Ganikyegitanno.” ");
INSERT INTO pibNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ranikyegitluna. Retinitkalu waneklutka wa kamchi shipchojtakakpotutanru mturni. Chiji rapokamtana. Ruprurutana. Rushpaksolnamatana. ");
INSERT INTO pibNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Geso gepomgalu ruru, “¿Gipshini wane gixlenatkalu?” Wale wane china, “Mturuyakawa rixini. ");
INSERT INTO pibNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Gixo kata ruknoklu xirnachri, wa gonga koxa ruylatyapmaklu, seyni pumkatiniplu pupxakanunwu. Petwamonutanunwu.” ");
INSERT INTO pibNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Geso wane chinru, “Pumkata galixletinipa, ptowruko gimkata gixkota wa galixachri chinanu.” ");
INSERT INTO pibNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Waneklutka mturu giru saplewata. Wane china, “Nalixa. Pupxakanno nma malixlenuya.” ");
INSERT INTO pibNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Geso getna gixolune yine. Rasukamtna. Potowurutna. Chigetjetlu kamchi. Wane chinru, “Kamchi myanumatkatu majnakotu, Gita yokanatyi pushpakyegitanru wale. Gi wanepnuteko pjiglokanutkalu.” ");
INSERT INTO pibNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Saplewatana. Shipchojtakakpotutanru mturni. Rushpakamtatka. Walenitka gipnachri pixka rixanatka. Giyagni gixo wane china, “Rupnanatka.” ");
INSERT INTO pibNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Seyni Geso kosemyotlu. Tunwakaklu. Yotunota. ");
INSERT INTO pibNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Wa jiglokinitka wa panchi yimaklene gepomgalu wannapje rixini, “¿Klu chinanu wixa gi wumkata giknokletlu maleka?” ");
INSERT INTO pibNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Wane chinna Geso, “Wa tye pixkalutu gi gimkata gishpakleta seyni gagjigognerupjeya.” ");
INSERT INTO pibNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Wa rushpakinitkana waneya, Kalile yapamtna. Gi raluka gimatkota. ");
INSERT INTO pibNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Wa runkaklewyegitna Geso yimaklene. Wane chinna, “Gita wa Yineru Wgenno samyookalurupno yinemyoya. Ruylatannona. Nupnanu. Nyotunotanu mapgogne rixinri.” ");
INSERT INTO pibNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Seyni wanna gi gimata jemlu wa tokanu. Pika gepomgaletluna. ");
INSERT INTO pibNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Rapokna Kapernawo. Panchi rawinitka, Geso gepomgana, “¿Klu gyoptopirkakananumtya gatnugapoya?” ");
INSERT INTO pibNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Wa pochkena. Wannakakluko yoptopirkakananumtna wa gatnugapoya katni wa tsru potu. ");
INSERT INTO pibNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Tuplata Geso. Tomgana pamole gepi. Wane chinna Wale, “Girukokta galuka muchinanu gixleta, walepni wa gapkatpotutachri pejnuruneyapa. Pejnuruneko gipxakjetachrinapni.” ");
INSERT INTO pibNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Koscheklu mturu. Wanna ganikajite rutaklu. Kampuklu. Wane chinna Wale, ");
INSERT INTO pibNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Girukta yoptotlu satu tye pixkalutu mturu Gita giwakaya, Gita yoptota. Girukta yoptotno, gi Gita yoptota seyni wa nyokanatjeru galikaka.” ");
INSERT INTO pibNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Wane chinru Gwa, “Yimaklewatachri, wetlu satu wa pgiwakaya ruknokyana maleka kamchine. Wale gi gomkagitwu. Wujretlu gi rixanu gi romkagitwu.” ");
INSERT INTO pibNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Geso wane china, “Gi wa gijretanru. Wa gikena wane gixa giyakleta ngiwakaya wa rumkata pshinitsonu gektuchinretno. ");
INSERT INTO pibNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Wa wma kamnixjetni wixasretni wale. ");
INSERT INTO pibNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Girukokta genekangi sato girapistonoya gonu ngiwakaya gi rixanu Kristonungi, galikaka wane nchingi gi ramgini wenutikolupa. ");
INSERT INTO pibNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Girukokta gitspeekaklu wa satu wa nyi mturune wa nalixjene Gita, kiglemkalu waleya rushriknojitikolupa wa tsru sotlu ginripiya, tsru wenu ruknokikolupa. ");
INSERT INTO pibNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Wa pumyo gitspeekakinipyi pustakanru. Kigleyyi wa pjiglokinripa wa puwekinri mastsi, wanepnute gepimyoyi pixinipa wane pyanuna Gigena wa xirnachri muwnakatupa. ");
INSERT INTO pibNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Wanna tsomne ma mupniyawaka. Wa xirnachri gike rixini ruwnanu. ");
INSERT INTO pibNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Wa pujixi gitspeekakinipyi, pustakanru. Kigleyyi wa pjiglokinripa wa puwekinri yokmatachriyi, wanepnute gepijixyi pixinipa puknookona Gigena wa xirnachri muwnakatupa. ");
INSERT INTO pibNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Wanna tsomne ma mupniyawaka. Wa xirnachri gike rixini ruwnanu. ");
INSERT INTO pibNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Wa puygale gitspeekakinipyi, puknokanru. Kigleyyi wa pjiglokinripa Goyakalu pogirewatyawaka paygalepjeya wanepnute gepiygaleyi pixinipa puknookona Gigena. ");
INSERT INTO pibNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Wanna tsomne ma mupniyawaka. Wa xirnachri gike rixini ruwnanu. ");
INSERT INTO pibNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Wa pejnuruneko tuwutkalurupa xirnachriya. ");
INSERT INTO pibNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Kiglerni wa tuwu, seyni wa tuwu mushi rixinitka ¿klu gmorotanu? Waneyapgi gixnanuko tuwu. Kigle gimwakaklepgi.” ");
INSERT INTO pibNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Wane yiyatka. Gotesreta ya, Gorta wakanute. Rapatyegitatnakluna gixolune yine. Rumepe ginkaklewyegitatnakna wa rixjetyawaka. ");
INSERT INTO pibNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Rapyegitluna Gwariseyone. Repomgaluna wa muklukanutlege giknokagnunrolu wa gnurchi. Rumlukanatluna. ");
INSERT INTO pibNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Wale gigitna. Wane china, “¿Klu yokanyegitgi Moysisi?” ");
INSERT INTO pibNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Wane chinruna, “Moysisi gichichlu kiruka yonatyapa ma ganunrotyanpatkalo. Ruknokanrotka.” ");
INSERT INTO pibNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Wane chinna Geso, “Nshiknu gaji chinanu yonyegitgi wa tye Tokanchi Yokanatkaluru. ");
INSERT INTO pibNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Seyni yinuwakyawaka giyaklewlu, jeji, suxo kamrutna Goyakalu. ");
INSERT INTO pibNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Giyagni jeji giknokanna ruru, runro. Rupxaletanrotkani ganunro. ");
INSERT INTO pibNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Wa gepinanna pamanepje rixanutkana. Giyagni gi gepimanetkana, seyni pamanepjetkana. ");
INSERT INTO pibNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Giyagni wa Goyakalu gapatanru ma mutspalkakinitipa wa yineru.” ");
INSERT INTO pibNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Wa panchiya repomgatnakluna yimaklene walekotnaka. ");
INSERT INTO pibNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Wane chinna Geso, “Girukokta giknoklo wa ganunro, sato ganunrotinitnaka rumopatlewata wala chinanu. ");
INSERT INTO pibNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Wa suxo giknokinri tganuru wa satu tganurutini, tumopatlewata.” ");
INSERT INTO pibNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ranikyegitluna mturune wa kamrukyapna. Wa yimaklene chigetjetna wa ranikjerna. ");
INSERT INTO pibNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Retinri Geso jigekanuwata. Wane chinna Wale, “Getashatanna mturune runyegitannona. Gi gimaletanna. Gi rixanu wanna pixkalune wannanni wa Goyakalu pogirewatyawaka. ");
INSERT INTO pibNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Galikakni wane nchingi, girukokta gi yoptotanru Goyakalu pogirewatyawaka mturu pixka gi wa jiglokanruna.” ");
INSERT INTO pibNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Kampukna. Wanna gogo rutakamyota. Ruglenshinikanyegitna. ");
INSERT INTO pibNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Gatnugapo yapananumtini, runyegitlu satu gasukamtachri. Yoptsojityegitlu. Repomgalu, “Yimaklewatachri kigleru ¿Klu nkamrutanu nyoptotyaplu wa nuwekinri gike rixiniko mnikawnakatupa?” ");
INSERT INTO pibNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Geso wane chinru, “¿Klu chinanu wane pchinno kigleru? Gi satuna waneru kigleru. Satupjeru, Goyakalupje. ");
INSERT INTO pibNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Wa Tokanchi Yokanatkaluru pumata: Gi pumopatlewatanu. Gi puylalewatanu. Gi pchowguwatanu. Gi wa maleshawaka pupgujtalewashatanu. Gi pyokwirewatanu. Pkagwakpiratanru puru ga wa punro.” ");
INSERT INTO pibNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Rugitlu. Wane chinru, “Yimaklewatachri, pejnuruko tyekaka nkamrutatka nmaklutinyakawa.” ");
INSERT INTO pibNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Geso yopukgatlu. Raluklu. Wane chinru, “Satupje pmagatya. Pyanu. Pushankanru ptowruko wane pixle. Penekanna wa kwamonurune. Waneyapyi ponikolewlu tengogneyapa. Punanu. Pomkagitanno. Panikanru pkoroshishkitate.” ");
INSERT INTO pibNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Seyni wale yanshinikanpotutana tye tokanchiya. Ralimta wamonuwatachri gi rixanu waneyanru ponikowle gixo wane rixle. ");
INSERT INTO pibNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Geso geknokyegitna. Wane chinna Wale wa yimaklene, “Kyaprepotlu jiglokinripna Goyakalu pogirewatyawaka wa ponikolune.” ");
INSERT INTO pibNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Wa yimaklene giglajita wa tokanuya, seyni Geso gigitatnaka. Wane chinna Wale, “Wiwine, ¡gi payaprenanutkalu wa jiglokyapluna wa Goyakalu pogirewatyawaka wanna serojiproji gaponshinikanutachine! ");
INSERT INTO pibNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Myapretmakni kameyo tsapujripna tjiglokinripa wa ponikolu pnute jiglokyaplu Goyakalu pogirewatyawaka.” ");
INSERT INTO pibNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Wanna giglajpotuta. Wane chinkakna wannakakluko, “¿Katu gimkata gognetkaakotanu?” ");
INSERT INTO pibNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Geso yopukgatna. Wane china, “Wa yineru mumkatanutu, wale rumkata Goyakalu. Wa ptowruko rumkata Goyakalu.” ");
INSERT INTO pibNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Petro yinuwaka wane chinretlu, “Petanu. Wixa giknokamtlu ptowruko. Womkagitatkayi.” ");
INSERT INTO pibNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Giyagni Geso wane china, “Galikaka wane nchingi, girukokta giknokapjimta, yegwakane, repurune, repurone, wa ruru, runro, wugenene, wa rusanatkaka giknokachri Gita chinanu, wa Kiglerpotunanu Tokanchi chinanu, ");
INSERT INTO pibNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","wale geneeko satu pacha kata pnute xani tyegognekaka, panchikaka, yegwakane, repurune, repurone, runrone, wugenene, rusanatkaka, kojwawakchi koxa. Pagognesha ginachripa reneeko ruwekinri mnikawnakatupa. ");
INSERT INTO pibNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Seyni gixo muchichachine gapkatpotutanu. Gapkatpotutachine wannapni wa muchichachinpatka.” ");
INSERT INTO pibNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Wanena gatnugapo. Gerosale kanikna. Kosekamtna Geso. Ruglajitna. Romkagitluna pikachineko. Ranikatnakna wa pamole gepine. Yinuwaka Wale wane chinretna wane rixikolpatka: ");
INSERT INTO pibNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Xani Gerosale wkanika. Wa Gita Yineru Wgenno samyookotka wa tsrukakalune sasertotene, wa yonchikapine yegi. Ruklukanuwnayegjixannona nupninripa. Samyokannona payinyegiko. ");
INSERT INTO pibNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Rapnokatannona. Kochipjetannona. Rutskagjetannona. Ruylatannona. Wa mapgogne giknoginpatka nyotunotanu.” ");
INSERT INTO pibNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Wa Santiyako Gwa, Sewereyo wgenene, rapyegitluna. Wane chinruna, “Yimaklewatachri, waluklu klunerukokta wagjityayi wane pixanwu.” ");
INSERT INTO pibNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Wane chinna Geso, “¿Kluneru galuka wa nixyapgi?” ");
INSERT INTO pibNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Wanna wane chinru, “Penekanwu Pixa wuxiplatanyi poyaknu yegi, satu potuklesretate, satu pkegnetesretate.” ");
INSERT INTO pibNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Wane chinna Geso, “Gi gimata wa gixa gagjitanru. ¿Gimkatge giiretyalo wa girapistono wa Gita girinro? ¿Gimkatge gkatletikolu wa katlu wa Gita katikolu?” ");
INSERT INTO pibNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Wanna wane chinru, “Wumkatlu.” Wane chinna Geso, “Wa girapistono nurapre girini. Wa katlu wa Gita katikolu wale koxa gkatikolupa. ");
INSERT INTO pibNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Seyni tuplalu npotuklesretate, wa nkegnetesretate gi wa Gitanni nenekyaplu, ga wa wannanupni galpokyegitkalunepni.” ");
INSERT INTO pibNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Wa jeminitkaluna, wa pamole yinuwaka gimtuwnaleta Santiyakoya ga wa Gwaya ");
INSERT INTO pibNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Geso tomgana. Wane chinna Wale, “Gimata wa tsrukakalune kagwakikalune payinetskalaya towutlewpotutna. Wanna gitsrukatene tsru gitaaka wanna chinanu. ");
INSERT INTO pibNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Seyni gi wane gixkakanu, seyni girukokta galuka tsru gixletnachriwa gixayegkakluko walepni wa gipxakjerupa. ");
INSERT INTO pibNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Girukokta gixayegkakluko galuka muchinanu gixletnawa, walepni pejnurune wayegreru. ");
INSERT INTO pibNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Gi rixanu Gita wa Yineru Wgenno gi nuna nupxakikolupa, seyni nuna nupxaklewatinripa, nenekyaplu nuwekinri nwenutyaplu rushpakinripna gixolune yine.” ");
INSERT INTO pibNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Geriko yana. Geriko yiyatka Wale, ga wa yimaklene, ga wa gixolune yine. Wartimeyo wa maygaletu, Timeyo wgene, tuplanata wa gatnugapostsi, ragjigognenatlo sroschi. ");
INSERT INTO pibNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Jemyegitlu Walenwa Geso Nasare gajeru. Yinuwaka saplewleta. Wane china, “Geso, Tawiklopisha, petwamonutanno.” ");
INSERT INTO pibNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Gixolune yine chigetjetlu pochke rixinripa, seyni wanepnuteyaka saplewjeta, “Tawiklopisha, petwamonutanno.” ");
INSERT INTO pibNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Geso tunwata. Wane china, “Ntomganru.” Tomgaluna wa maygaletu. Wane chinruna, “Kiglenshinikanupyi. Palnanu. Tomgayi.” ");
INSERT INTO pibNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Ruknoksapowlechratamta. Rupteka palnaleta. Yayegitatkalu Geso. ");
INSERT INTO pibNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Geso gepomgalu. Wane chinru, “¿Klu palukatka wa nixyapyi?” Maygaletu wane chinru, “Yimaklewatachri, netinripa.” ");
INSERT INTO pibNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Geso wane chinru, “Pyanu. Palixle gitskalakyi.” Waneklutka retatka. Romkagitatkalu Geso wa gatnugapoya. ");
INSERT INTO pibNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Goliwa Magkatetkana. Gi gowukatkana Gerosalestsi, ga wa Wetpage ga wa Wetani. Wane yokanatyana gepi yimaklene. ");
INSERT INTO pibNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Wane chinna Wale, “Gyanu tujra pokchi gixa ginaple gajeru. Pokchipotuko gapokinpatka wane gikshikinri mporo wgene tsatkaluru, gi satuna yineru mtuplatjitanutuwa. Gkoshrikanru. Ganikanru. ");
INSERT INTO pibNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Girukokta wane chininipgi, ‘¿Klu chinanugkoshpiroklu?’ wane nchinanu, ‘Gitsrukaachi galuklu. Waneklutka yokanatanutnaklu gewi.’ ” ");
INSERT INTO pibNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Wane yana. Rukshikluna mporo wgene tsatkaluru gipgyapto maleka rutspalgapotyawaka. Koshpirokluna. ");
INSERT INTO pibNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Pimrine wane gwanatachine wane chinna, “¿Klu chinanu gkoshpirjetlu mporo wgene?” ");
INSERT INTO pibNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Wanna wane china Geso chinyawakna. Retashatkatkana. ");
INSERT INTO pibNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ranikatkaluna mporo wgene Geso yegi. Gimkalna sapwakatjitluna. Wale gogo tuplamtatka Geso. ");
INSERT INTO pibNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Gi gepikna gikwekamkatachine gatnugapo. Pimrine gagmunasurkaka gistakamta. Rukwekamtluna gatnugapo. ");
INSERT INTO pibNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Kosekamtachine ga wa kaptomtachine saplewjenanumtna. Wane china sapletna: ¡Wuya! ¡Gimalwutkaluru ginachri Gitsrukaachi giwakaya! ");
INSERT INTO pibNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","¡Gimalwutkaluru wutsrukatni Tawi pogirewtapyawakni! Waneplu pogirewatyawaka. ¡Wuya tengognepotuya! ");
INSERT INTO pibNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Geso gapokamtatkalu Gerosale. Kpashiwakapji ya. Retjetinitkalu ptowrunanuka, kayi rixinitka rushpaka. Wa Wetani ya wa pamole gepiymananuko. ");
INSERT INTO pibNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Waleprika Wetani yamtyatkana. Nachlu. ");
INSERT INTO pibNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Retlu gowukaya gikera kasureru. Yayegimtlu, wane getko rukshikinri pagixanu. Rapyegitinri gike rukshika. Gisurepjeni. Gi gipapkoni wa sagiwatinri wa gikera. ");
INSERT INTO pibNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Geso wane chinanru gikerni, “Gikena niksagitanutkayi gike pixiniko.” Jemluna yimaklene. ");
INSERT INTO pibNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Wane yana Gerosale. Jiglokamta kpashiwakapji. Yinuwaka maleka giknokletna kgishanrewaklerunni ga wa gagjijetachinni wa kpashiwakapjiya. Yawnajkaklo kwalkaka gipekoserojiprojitachineni, motkoko gishanretachinni tuplapijere koxa. ");
INSERT INTO pibNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Gi ruchichna Wale wa satuna ganikyalo kastonolo wa kpashiwakapji. ");
INSERT INTO pibNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Runkaklewyegitna. Wane chinna Wale, “¿Gi ge yonatkaluru: Wa nopji gagjigognewakapji chinkalurupni ptowruko payinerumnunanuko yegi? Ga wa gixa wane gixatkalu gitawakapna kachowgurune gwiyawaka pixka.” ");
INSERT INTO pibNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Yijnakotluna wa tsrukakalune sasertotene wa yonchikgapine. Rujgaluna gi rixpoko giylaletanruna gi rixanu pikluna. Wa ptowruko yine giglajita runkaklewleya. ");
INSERT INTO pibNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Wa kayi rixinitka tsru pokchiya yiyatka Geso. ");
INSERT INTO pibNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Ruknoginna goyechnokawa, retluna gikera rupriganatka gitskiymananuko. ");
INSERT INTO pibNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Petro gishinkapatka. Wane chinru, “Yimaklewatachri, petanru gikera pkamakpiratanruna rupriganatka.” ");
INSERT INTO pibNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Geso, wane chinna, “Galixanru Goyakalu. ");
INSERT INTO pibNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Galikaka wane nchingi, katukokta wane chinru tye magka, ‘Puxrikanu. Wa tsru wenu puknokinwa.’ Gi wa shikpokwakgajitachriko, seyni ralixa wane rixanu chinyawaka, wanepotuko rixanu wale chinanupa. ");
INSERT INTO pibNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Giyagni wane nchingi, ptowruko girukokta gagjitanu gagjigognetini, galixinri gyoptotanru, waneyapgi gixinripa. ");
INSERT INTO pibNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Wa ntunwa gagjigogneretini, gkaspukinri wa waneygi gixinipa pnu gixjeru, wa gixa Giru tengogne gajeru koxa kaspukmukochiretyapgi wa gmukochirkaka. ");
INSERT INTO pibNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Ga wa gixa gma kaspukinri, wa Giru koxa tengogne gajeru gi wa kaspukmukochiretanungi.” ");
INSERT INTO pibNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Satokna Gerosale. Yotaljeta kpashiwakapjiya. Runyegitluna wa tsrukakalune sasertotene, wa yonchikgapine, wa tsrune. ");
INSERT INTO pibNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Wane chinruna, “¿Klu putakika pixa tyekaka pkamrutinri? ¿Katu gitakyi tyekaka pkamrutinri?” ");
INSERT INTO pibNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Wane chinna Geso, “Nepomgangi gixa satu tokanchi. Gigitanno. Wanepnute nunkakyapatkagi klu nutakika tyekaka nkamrutinri. ");
INSERT INTO pibNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Wa Gwa katlewle, ¿tengogne giyakatyachrirge? ¿waka yinenukla? Gigitanno.” ");
INSERT INTO pibNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Yoptopirkakna wannakakluko. Wane chinna, “Wane wchininipmaka tengogne giyakatyachrini, Wale wane chinanunwu, ‘¿Klu chinanu koxa gi galixlu?’ ");
INSERT INTO pibNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ga wa wane wchiniplu, ‘Yinenni’ ”—wanna pikna gixolune yine, gi rixanu pejnuruneko kagwaklu wa Gwa walenwa Goyakalu tokanu geneklewatachri. ");
INSERT INTO pibNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Rugitluna Geso. Wane chinruna, “Gi wumata.” Wane chinna Geso, “Gita koxa gi ginkakangi klu nutakika tyekaka nkamrutinri.” ");
INSERT INTO pibNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Yinuwaka Geso yanumsayegletna yapkakluya: “Satu jeji gitaklu sana gowasha. Pirijeretjetlo. Tapgatyawakapa jitota. Tenopjiru kamruta. Renekamtna sana girukotachine. Pnu yatka. Wajra ya. ");
INSERT INTO pibNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Talixinipapko yokanatlu wayegrechri sana girukotachine yegi rawapyaplo wa sana girukotachinyegiya wa gwachrotka gowashaya. ");
INSERT INTO pibNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Kashichluna. Kochipjetluna. Yokanatanruna maleshalni. ");
INSERT INTO pibNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Rumepe yokanreyegitna satu wayegrechri. Ruylajiwutanruna. Rektutetluna. ");
INSERT INTO pibNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Rumepe yokanretatnaklu satu. Waleni ruylatna. Pimrinnikoxni gixni. Kochipjetkanna pimrinni. Ruylatkanna pimrinni. ");
INSERT INTO pibNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“Waneyawalu satu gituru ralukanru potu. Yokanyegitna waleni koxa gapkatpotutachritka. Wane china, ‘Kagwakpiratanruna noturu.’ ");
INSERT INTO pibNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","“Wa sana girukotachine wane chinna wannakakluko, ‘Tyenwa yoptotachripatka. Ginanu. Wuylaganru. Yoptotanrupmaka wixanpatkani.’ ");
INSERT INTO pibNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Kashichluna. Ruylatluna. Ruknokluna maleka gowashaya. ");
INSERT INTO pibNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“¿Gi rixpokotanu wa kgowashateru? Runanu. Ruylatanunna wa sana girukotachinepni. Renekanna gowasha pimrine. ");
INSERT INTO pibNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","¿Gi ge tye yonchiga getyongata? Wa sotlu myoptotkotu kamrupjitachineya, Wale gitaaka yoptowaka gitsejita. ");
INSERT INTO pibNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Gitsrukaachi chinanu kamrutka wa tye. Rakaglajiygaletwu.” ");
INSERT INTO pibNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Raluka kashretluna. Wanna tsrukakalune pikna gixolune yine. Rumata jemluna wa wannapirana wa yapkaklu. Kaspukluna. Yatkana. ");
INSERT INTO pibNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Yokanyegitluna pimrine Gwariseyone ga wa Giroreyone wa kashtokanutyapluna. ");
INSERT INTO pibNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Runna wanna. Wane chinruna, “Yimaklewatachri, wumatyi Pixni mayrokletyi. Gike pkagwakpirata. Gi petlu wa yinermanewle giglenu, seyni galikaka potu punkakwu Goyakalu gatnugapotepirana ¿Wa munanshichkotnige renekikolupa wenrukaka wa Susa waka gike? ¿Wenekerge waka gi wa wenekanru?” ");
INSERT INTO pibNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Wa Wale gimatlu rixashleyna. Wane chinna Wale, “¿Klu chinanu gimlukanutno? Ganikinno sroschiproji netyaplo.” ");
INSERT INTO pibNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Wanna ganikyegitlu. Wane chinna Wale, “¿Katu yaglunwa tye, ga wa katunni toyonga?” Wanna wane chinru, “Susanni.” ");
INSERT INTO pibNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Wane chinna Geso, “Genekanru Susa wa Susanuko, ga wa Goyakalu genekanru wa Goyakalunu.” Ruglajitna Waleya. ");
INSERT INTO pibNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Runyegitluna Sariseyone. Wanna wane china maleshaplu gipnachine yotunre. Repomgaluna. Wane chinruna, ");
INSERT INTO pibNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Yimaklewatachri, Moysisi yonyegitwu wa satu yegwakluko gipnini, ruknokagnunrotana, gi ruknokawgenetana wa repuru gwanro wale gnunronanni, ruxolewkakinripa giklopishapa yegwakluni chinanu. ");
INSERT INTO pibNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Wanenannina payokgiprerune moletkakachine. Muchinanu tsru gnunrowata. Rupnana. Gi ruknokawgenetana. ");
INSERT INTO pibNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Gapkatatachri gwatnaklo. Rupnana koxa waleni. Gi waleniko giknokawgenetana. Mapa rixinrini waneko pixka rixana. ");
INSERT INTO pibNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Payokgipre gwalo. Gi wannaniko giknokawgenetana. Suxni gapkata potu gipnaletanatka. ");
INSERT INTO pibNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Yotunruklupa yotunotinipna, ¿katu gnunropni wa wannaya? Gi rixanu payokgipreni gnunronitka wa wala.” ");
INSERT INTO pibNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Rugitna Geso. Wane china, “¿Gi ge mpupjeta gi rixanu gi gimatlu wa Tokanchi Yonatkaluru, gi wa Goyakalu giyaklewleko? ");
INSERT INTO pibNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Wa yotunotinipna wa gipnachineya gi ganunrowatanutkana, gi kashimyokaakotkana, seyni wa Goyakalutowrerune tengogne gajene wannako pixka rixanutkana. ");
INSERT INTO pibNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Wa yotunotachinepa gipnachinepirana, ¿gi ge getyongatlo wa Moysisi kirukate, wa Goyakalu giynumatyawaklu kawshipiriya? Wane china: Gitni wa Gawra Goyakalute, Gisaaka koxa Goyakalute, ga wa Gakowo koxa Goyakalutno. ");
INSERT INTO pibNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Gi wa gipnachine Goyakalutni, seyni giwekachine Goyakalute. Giyagni gixni gamtakanshinikanpotutana.” ");
INSERT INTO pibNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Rapoka satu yonchikgapri koxa. Yijnakotna rugjekakyawakna. Rumata kigle gigle Geso gixna. Repomgalu, “¿Girni wa tsru potu Yokanatkaluru Tokanchi pejnuruko pnute?” ");
INSERT INTO pibNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Geso gigitlu, “Wa muchinanu walenwa: Pjemanu, Gisrayili. Wa Gitsrukaachi Woyakalute, wa Gitsrukaachi satupjeru. ");
INSERT INTO pibNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Pushinikanru Gitsrukaachi Poyakalute psolpotuyako pajiya, psolpotuyako punshinikanuya, psolpotuyako pmuchkonuya. Ga ga walenwa muchinanu Yokanatkaluru Tokanchi. ");
INSERT INTO pibNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Gepi chininri tye pixka rixa: Pushinikanru pumole pixnanuko pixka. Maleshlu satu Yokanatkaluru Tokanchi tyekaka pnute tsru.” ");
INSERT INTO pibNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Wa yonchikgapri wane chinru, “Kigleru, Yimaklewatachri. Galikaka wane pchina, Satupjeru Goyakalu. Maleshlu satu. Walepjeni. ");
INSERT INTO pibNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Wushinikanru psolpotuyako wajiya, psolpotuyako wunshinikanuya, psolpotuyako wmuchkonuya. Wushinikanru wumole wixnanuko pixka, tyekaka ptowruko genekashlu yoxiikalurupa wa genekashlu giylatkalurupa pnute tsru.” ");
INSERT INTO pibNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Geso getinri wa yonchikgapri gigitlu rumatleya, wane chinru, “Gi wa gowukyi pogirewatyawaka Goyakalu.” Gi satuna tserpiranawanshinikanyegitlu repomgiyatkalu. ");
INSERT INTO pibNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Kpashiwakapji runkaklewatya. Geso wane china, “¿Gi chinna wa yonchikgapine wa Tawiklopisha rixinri wa Kristo? ");
INSERT INTO pibNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Wa waleko Tawi wane china wa Giwekikaluru Kpashiriya: Gitsrukaachi wane chinru Nutsrukate, Ptuplatanu npotuklesretate, Wa nutakinpotukna pkamnixjene pujixipta rapukote. ");
INSERT INTO pibNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Waleko Tawi wane chinru Gitsrukaachi. ¿Gi rixpokotyawaka giklopishayapni?” Gixolune yine rumuwleyna yijnakotluna. ");
INSERT INTO pibNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Wane china Geso wa runkaklewleya, “Ggirukotinwa wanna yonchikgapineya, galuka yanretachine gowuukalkaka gimkaluyna. Ralukluna ralukikolupna giputuya. ");
INSERT INTO pibNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Ralukluna wa tsrukakalune tuplapijere ginkaklewawakapjikakaya, muchinanu tuplapijkaka koxa nikjetikowakaya. ");
INSERT INTO pibNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Konapjijetkanna gipnagnurutachronni. Rixashleyna gogagjirgognerkakna. Tsru potu ruklukanuwnayegjixikolupna.” ");
INSERT INTO pibNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Tuplanata Geso tugnantakikowaka genekashlukaka ginaple. Retjetna yine gi rixpoko gitakletyaplona sroschi gignantakikowaka. Gixna ponikolune gitaklo gixo. ");
INSERT INTO pibNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Tuna sato suxo gipnagnurutachro kwamonuro. Tutaklo gepi mturomchataaji. Walanwa satopje sintawo. ");
INSERT INTO pibNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Tomgana Geso wa yimaklene. Wane china, “Galikaka wane nchingi, wa twu suxo gipnagnurutachro kwamonuro wala gitaklo pejnurune pnute gitakachine gignantakikowaka. ");
INSERT INTO pibNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Pejnuruneko gitaklo ruxetanrona. Wa twu suxo twamonnupoga tutaklo pejnuroko walanu, pejnuruko tuwekinripa.” ");
INSERT INTO pibNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Wa rushpakamtini kpashiwakapjiya, satu yimakleru wane chinru, “Yimaklewatachri, ¡petanru gi pixka sotlerutkakananni, ga wa gi pixkapjirutunanni!” ");
INSERT INTO pibNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Geso wane chinru, “¿Petlu tyekaka tsru panchikaka? Gi wa rutukanu sotlu rogotkakinripa, gi wa mujrolekatunpakni.” ");
INSERT INTO pibNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Tuplatini wa Goliwa Magkateya kpashiwakapji ginaple, repomgaluna wanna mkoje rixinna, Petro, Santiyako, Gwa, Gantirishi, ");
INSERT INTO pibNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Punkakanwu. ¿Giklupni wa tyekakapa? ¿Klu getkaluru wanepa wa tye pejnuruko wa poyagkakinpatka?” ");
INSERT INTO pibNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Yinuwaka Geso wane chinretna, “Xako gi satunako yokwitangi. ");
INSERT INTO pibNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Gi rixanu runanna gixo ngiwakaya, wane chinachinepa, ‘Gitni wa Kristono.’ Yokwitanunna gixopni. ");
INSERT INTO pibNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","“Seyni wa gixa jeminiplu wa giylalupirana ga wa pogiwlesha giylalupirana, gi gkegeknanuwatanu. Rumkata wane gixleta, seyni gi wa yoptukyawakapnichi. ");
INSERT INTO pibNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Gi rixanu ruylakakanna pachijne gajene ga wa pachijne gajeneyma, ga wa pogirewatyawaka giylakakanu pogirewatyawakayma. Waneplu giyolikchijrukaka pachijnemnunanukaya. Waneplu nachlukaka. Tyekakapni muchichachripa wa kachinolkakapa. ");
INSERT INTO pibNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Gixako getinwa gixnanuko. Wa samyokangina jemanshinikankakyawakapna. Ginkaklewawakapjikakaya gkochipjetiko. Gitsrukaachine, pogirchine getanu gixapni tunwatanuna Gita chinanupa gipgujtalewlu waneyapna. ");
INSERT INTO pibNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Muchinanu ptowruneko payinerumnunanuka runkakikolupna Kiglerpotunanu Tokanchiya. ");
INSERT INTO pibNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Wa ganiikoklunpatka gixa wa nsamyookoklunupa gma mapookanupachi gi gkojwakinwa wa gixa chinyawakapa. Gi waleko gyanshinikanutanu, seyni wa genekikolupa gixa walepapkopa, wane nchinyawakapa. Gi wa gixni yanumsatachinepgi seyni Giwekikaluru Kpashiripni. ");
INSERT INTO pibNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“Gimole samyokanru rupninripa gimoleko ga wa ruru samyokanru gituru rupninripa. Wa wugenenna gimtuwnayegitanuna rurunepnina. Ruylajixanunna rurunepni. ");
INSERT INTO pibNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Gayegixkalunepgi pejnuruneyako Gita giwaka chinanu, seyni wa kashnantakanshinikanutachripa yoptukyawakpotunanukopa walepni wa gognetkaako. ");
INSERT INTO pibNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Wa getyongatachripa gimata jemanru: Wa getiniplu gagnanutkaluru gimtukpotlewatachri wane rawinri mawiyawakanupmaka, waneklu Gote gwachine gasukanu. Magkakaka yanna. ");
INSERT INTO pibNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Panchi gogo gwanatachri wa rujrukanmaka, gi jiglokapjitanu ranikyaplu gipji gajeru. ");
INSERT INTO pibNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Wa sana gwanatachri gi wa satkapanu rawapyaplu gimkalu. ");
INSERT INTO pibNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","¡Gi waneni wa kamshironepni ga wa gashichakachinepni walegognekakpatka! ");
INSERT INTO pibNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Gagjigognetanu gi waneyapgi ginapuklu gasuktatinripa. ");
INSERT INTO pibNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Wa walegognekakapa waneplu salewakchi wa mwajejetkatu wa muchi giyakletinitkalu wa Goyakalu giyakle, ga wa xanigognenanu. Gi wane rixanu. ");
INSERT INTO pibNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Wa Gitsrukaachi ma sustakanmaklu walegognekaka gi pamanenapnikmaka gognetkaakona seyni tsomitkalune chinanu wa Wale tsomitanune sustaklu walegognekaka. ");
INSERT INTO pibNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Giyagni satu wane chininipgi, ‘¡Gewru Kristo!’ ga wa wane chiningi, ‘¡Getanru. Waneru!’ gi wa galixanu. ");
INSERT INTO pibNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Rupgujewnanna wale migje Kristone, wa wanna migje Goyakalu tokanu geneklewatachine. Kamrutanruna getkalurkakapa ga wa koglajrukakapa, yokwitikolupmakna tsomitkalune wa rumkatmaka wane gixleta. ");
INSERT INTO pibNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Xako gixa. Nunkakatkagi psoluko ma mapookanuwa. ");
INSERT INTO pibNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Seyni walegognekakpatka ruknoginpatka wale salewakchi, wa tkachi gichpokanu. Wa ksuru gi wa pokamlatanu. ");
INSERT INTO pibNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Wa katagirkaka gijirotanu tengogneyapa. Wa gichkolkaka tengogne gajeru kowshiwshitko. ");
INSERT INTO pibNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Wanepnute retannona Gita wa Yineru Wgenno kyachgapererumkoya ginachripno. Tsru nuyakle ga wa noyaknu numunanu. ");
INSERT INTO pibNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Waneklu nyokanatanna notowrene tengogne gajene rapatjetikolupna ntsomitanune. Wa gepkoxamkojesretkakayako yoptukyawakpotuko chiji, yoptukyawakpotuko tengogne rapatjerewatinna. ");
INSERT INTO pibNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Gimatanru yapkaklu gikerapiranaya. Wa tyosnuygalejiplutinitka, tupcheksuretinpatka, gimatanutkalu wa walapustsitkani. ");
INSERT INTO pibNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Waneko pixka gixa getinpatkalu wane gixlutkani tyekaka, gimatanutkalu gi gowukpatkalu. Gipgyaptostsitkalu. ");
INSERT INTO pibNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Galikaka wane nchingi, gi ruknoganu tye gimuweekakgognenatachinesha wa ptowruko tyekaka ma mixkanuwa. ");
INSERT INTO pibNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Wa tengogne ga wa chiji giknoganu, seyni wa ntokanu gi giknoganu. ");
INSERT INTO pibNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Seyni walegogne, wale gipapko gike gimata, gi wa Goyakalu towreruneko tengogne gajene, gi wa Gituruko, ga wa Girchipje galikaka gimata. ");
INSERT INTO pibNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Giyagni giyokanu. Gagjigognetanu. Gi gimatlu giklupaktani gipapkopa. ");
INSERT INTO pibNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Waneko pixka rixa wa jeji wajra yachri. Ruknokamtlu gipji. Rutakamtna wayegrene. Satkaka renekamta kamrure. Gipgyapto gwachri towutamta ruyokinripa. ");
INSERT INTO pibNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","“Giyagni gixa giyokanu. Gi rixanu gi gimata giklu runanu wa kwangixlerupji, patako kayi, patako ganikajyechno, patako gaxawripa yanumatini, patako goyechnokawpotuko. ");
INSERT INTO pibNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Wa rawraka ginretinipa ma mukshiikyanupgi gimkanatachingi. ");
INSERT INTO pibNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Wa gixa nchinyagi wane koxa nchinna pejnuruneko: Giyokanu.” ");
INSERT INTO pibNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Gepigogne magatiniwa Tsru Giknoglushgogne wa Tsrugogne jimapro gisekachri myapjetkotu, rujgaluna tsrukakalune sasertotene, ga wa yonchikgapine gi rixpoko kashichyapluna gayroklewluya ruylatyapluna. ");
INSERT INTO pibNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Wane chinna wanna, “Gi wa tsrugogne wkashichanru, ma mejnugimalewatinitipna yine.” ");
INSERT INTO pibNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Wetani rawanata Geso Simopji gijirgitutpachri. Tuplanata nikjetikowakaya. Tuna sato suxo. Waneylo pastono pgamlugalo nartogapje kwenuru potu. Tupokastonotlo. Tuyokjiwutlu. ");
INSERT INTO pibNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Wanena pimrine gimtuwnachine wannananuko. Wane chinna wanna, “¿Klu chinanu wane tixa saletletatkalo pgamlugalo? ");
INSERT INTO pibNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Wa tumkata gishankakotmaka wa twu pgamlugalo, wa mapa pachaproji pnute. Walamka kwamonurunni geneeko.” ");
INSERT INTO pibNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Geso wane china, “Getashatanro. ¿Klu chinanu nsalewnakaklo? Kigleru kamrurchi tkamrutyano. ");
INSERT INTO pibNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Gi rixanu waneygognenangi wa kwamonurune gixayma. Wa galukiniplu gimkata kigleru kamruyegletna, seyni gi waneygognenanupgi Gita. ");
INSERT INTO pibNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Wa wala kamrutlu tumkatyawaka. Tuyokagnaputlo pgamlugalo nomane wa nkapnatikolupa. ");
INSERT INTO pibNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Galikaka wane nchingi, ginakakokta runkakletiko Kiglerpotunanu Tokanchi wa psolchijneko wa tye koxa tkamrutanru wala wane chinkalurupa wa tushinikikolupa wala.” ");
INSERT INTO pibNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Gota Giskaryote satu pamole gepi rixinri yayegitna tsrukakalune sasertotene samyokyaplu Geso wanna yegi. ");
INSERT INTO pibNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Wanna jeminitkalu, rumuwatna. Rupiratyaluna renekyapluna sroschiproji. Rujgaluna ruglepoktapinri gi rixpoko samyokletyapluna. ");
INSERT INTO pibNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Muchinangogne jimapro gisekachri myapjetkotu wa renekashatinrina giylatkalurupa wa Tsru Giknoglushgogne chinanu, yimaklene wane chinru, “¿Ginaka paluka yokanretwu wa walpokotyaplu wa pnikanrupa Tsru Giknoglushgogne chinanupa?” ");
INSERT INTO pibNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Yokanatna gepi yimaklene. Wane chinna Wale, “Tsru pokchi gyanu. Wane yoptotingi satu jeji wa gashgaji gonu gwanru ganikachri. Gomkagitanru. ");
INSERT INTO pibNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Ginakakta jigloka wane nchinanru wa kapjiru, ‘Yimaklewatachri wane china, “¿Ginaklu wa napokagrukowakle wa nnikyawakapa Tsru Giknoglushgogne nyimakleneyma?” china.’ ");
INSERT INTO pibNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Wale gekakgitangi satu teno gajeru tsrugruko gali galpokletkalurutka. Wane galpokotinri wixanupa.” ");
INSERT INTO pibNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Wane yatkana yimaklene. Tsru pokchi yatkana. Rukshikluna Wale chinyawakpotukna. Ralpokotluna Tsru Giknoglushgognenupa. ");
INSERT INTO pibNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Wa kayi chininitka wane ya wa pamole gepiyma. ");
INSERT INTO pibNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Wa tuplatinitkana nikawakakwa, nikna. Wane china Geso, “Galikaka wane nchingi, wa satu gixate numnikjeru, wale samyokanno.” ");
INSERT INTO pibNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Wa wanna yinuwaka wamonuwleta. Wane chinna wanna satkaka, “¿Gitgetkopni?” Satu koxa, “¿Gitgetkopni?” ");
INSERT INTO pibNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Wane chinna Geso, “Wa satu pamole gepi rixinri, wa gigakachri Gitayma kolpetoya. ");
INSERT INTO pibNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Galikaka Gita wa Yineru Wgenno wane nyanu chinyawaka wa yonchi Gitapiranaya. ¡Gi waneni wa tye jeji, wale chinanu Gita wa Yineru Wgenno samyooko! Kiglemkalu tye jeji chinanu ma mushpaakanmaka.” ");
INSERT INTO pibNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Wa nikanatinna wanna, Wale kashichlu jimapro. Ruglenshinikanyegitlu. Jiknaglu. Wane gixachri renekna. Wane china, “Gyoptotanru. Tyenwa nomane.” ");
INSERT INTO pibNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Wale kashichlo girapistono. Poyagnutatkalo. Renekna. Rurna walaya pejnuruneko. ");
INSERT INTO pibNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Wane chinna Wale, “Tyenwa nograga wa gerotu tokanchi gipiratkaluru chinanu, gixoluru yineru chinanu giyookaluru. ");
INSERT INTO pibNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Galikaka wane nchingi, gi wa nuranutkalo gowajiga wa walegognepotuko wa nuranro geroto wa Goyakalu pogirewatyawakaya.” ");
INSERT INTO pibNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Wa wanna shikaletlu gimalwuru. Rali shikaletinitkaluna, Goliwa Magkate yana. ");
INSERT INTO pibNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Wane chinna Geso, “Pejnurunepnikgi gixapni gitspeekaakona. Yonatkalurutkani: Nuylakanru wa girukotapratachri. Rupalatanna wa gowegane. ");
INSERT INTO pibNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Nyotunotanu. Nali yotunkakletkoklunpatka, Gita gapka kosekanu gixaya. Kalile nyanu.” ");
INSERT INTO pibNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Petro wane chinru, “Wa pejnurunekmaka gitspeekaako, ga wa gita gike.” ");
INSERT INTO pibNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Geso wane chinru, “Galikaka wane nchinyi, wa pixa xani tye yechno ma yanumatkanu gnapu wa gaxawripa gepi kata, pnutatanno mapa kata.” ");
INSERT INTO pibNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Seyni wale psolmuchkonuko tokanuwna. Wane china, “Wa nupnanmaka koxa Pixayma, gi wa nnutatanyi.” Pejnuruneko waneko pixka china. ");
INSERT INTO pibNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Wane yana Getsemani giwakatletyawaka. Wane chinna Wale wa yimaklene, “Ntuplatanu gewi. Nagjigognetkakopshini.” ");
INSERT INTO pibNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ranikna Waleyma Petro, Santiyako, Gwa. Yinuwaka giglajreta, wamonuwnaleta. ");
INSERT INTO pibNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Wane chinna Wale, “Nonshinikanu nwamonuwnapotutya gipukchi pixkapotuko. Gkagwakanu gewi. Giyokanu.” ");
INSERT INTO pibNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Psotsotaaji wajrayaka ya. Wane yoptsojita chijiya. Ragjigogneta wa rumkata wane gixletikolupmaka, ruknoganu Waleya wale salewakchi. ");
INSERT INTO pibNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Wane china, “Gagwa, Nuru, ptowru gimkatachriyi Pixa. Pkoshripatinno twu girapistono, seyni gi wa Gita galukyawakapni, seyni Pixa galukyawakapni.” ");
INSERT INTO pibNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Runa. Retamtna gimkanatachine. Wane chinru Petro, “¿Simo, pumkanatge? ¿Gi ge pumkata giyokleta pshinitsonu? ");
INSERT INTO pibNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Giyokanu. Gagjigognetanu gma jiglokinitipa yantaletikowakapa. Wa ginshinikanu galikakni jmererni, seyni manchi muchkotni.” ");
INSERT INTO pibNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Rumepe yaletinitnaka ragjigognetyawaka, waneko pixka chintokanutatnaka. ");
INSERT INTO pibNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Satokatnaka. Retamtatnakna gimkanatachine. Ruxapnewatna. Gi rumata gigretluna. ");
INSERT INTO pibNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Runa mapa kata rixinritka. Wane chinna Wale, “Gimkanutka. Gapnanutanu. Wanekotka. Nopapko gapokatka. Xani Gita wa Yineru Wgenno samyookatka kmukochirerunemyoya. ");
INSERT INTO pibNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Gyotunotanutka. Gayanutka. Gi gowukatkalu nsamyokjerupa.” ");
INSERT INTO pibNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Waneklutka yanumsanatiniwa Geso, runatka Gota. Walenwa pamole gepi rixinri. Waleymana gixolune yine kyoglolewaprerune, kgagajererune. Wannanwa tsrukakalune sasertotene gayinerutene, yonchikgapineyegirune koxa, tsrunyegirune koxa. Gotaymamnutkana. ");
INSERT INTO pibNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Wa samyokjeru genekagnaputatkana saturutu gimaxiklechi. Wane chinna wale, “Girukta namlutanu gita, Walepakni. Gkashichanru. Ganikanru. Ggirukotpotumtanru.” ");
INSERT INTO pibNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Runinitka, waneklutka runyegitlu. Wane chinru, “¡Yimaklewatachri! ¡Yimaklewatachri!” Ramlutlu. ");
INSERT INTO pibNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Romyokyegimtluna. Kashichluna. ");
INSERT INTO pibNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Wa satu wane gwanatachri koshpakyoglolewapreta. Rustaklu wa sasertote gitsrukate potu wayegreru. Yostakjepitlu. ");
INSERT INTO pibNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Geso wane china, “¿Gishpakamta gixa yoglolewapiyma gagajeyma, kachowguru pixka gixa kashretnoge? ");
INSERT INTO pibNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Pagognemnunanuka gixayma nwanata, nunkaklewanata wa kpashiwakapjiya. Gi wa wane gkashichyano, seyni wa poyagkakikolupa wa yonatkalurkaka, wane gixyatkano.” ");
INSERT INTO pibNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ruknokamtluna pejnuruneko. Rasukatkana. ");
INSERT INTO pibNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Satu jeji gomkagitlu sapwakmanetachri gichrataya. Jejine kashichlu. ");
INSERT INTO pibNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Wa wale ruknokachratamtlu. Rasukyana mamkatni. ");
INSERT INTO pibNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Ranikluna Geso sasertotene gitsrukate potu yegi. Rapatna Walyegiya pejnuruneko tsrukakalune sasertotene, tsrune, yonchikgapine. ");
INSERT INTO pibNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Wa Petro gomkagitlu gogajxigiyako. Sasertote gitsrukatpotupjipotunanuko romkagitlu. Tuplanata towrechineyma. Rolkanata chichpawa. ");
INSERT INTO pibNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Wa tsrukakalune sasertotene, pejnuruneko jemanshinikankakjetikowakaya rujgaluna gipgujtalewlumka Gesoya rupninripa, seyni gi rukshikluna. ");
INSERT INTO pibNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Gi rixanu gixo gipgujtatlu maleshawaka, seyni wa rupgujtalewlena gi wa pixkakakluni. ");
INSERT INTO pibNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Pimrine gapoka. Rupgujtatluna maleshawaka. Wane chinna wanna, ");
INSERT INTO pibNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Wixa jemlu wane chininri, ‘Gita yotkakanunru wa tye kpashiwakapji myochi kamrutikaluru. Wa mapagogne chininri satu nkamrutanu myochi mkamrutikotpatka.’ ” ");
INSERT INTO pibNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Seyni rupgujtalna wanna koxa gi pixkakakluni. ");
INSERT INTO pibNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Wa sasertote gitsrukate potu tunwata ganikajitskalaya. Repomgalu wa Geso. Wane chinru, “¿Gikeko pugityano? ¿Klu rupgujtatyayina wanna nyi Pixaya?” ");
INSERT INTO pibNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Seyni Wale pochkeru. Gike rugita. Sasertote gitsrukate potu rumepe gepomgaletatnaklu. Wane chinru, “¿Pixlege wa Kristoyi Gimalwutkaluru Wgenyi?” ");
INSERT INTO pibNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Geso wane china, “Gitakni. Gixa getanno Gita, Yineru Wgenno, tuplatyawakapa potuklesreta ruyakle Goyakalu, nuninkoxapa kyachgapererumkoya tengogneya.” ");
INSERT INTO pibNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Giyagni wa sasertote gitsrukate potu suskakamkata. Wane china, “¿Klu wanepnute magatyawu gipgujtalewatachine? ");
INSERT INTO pibNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Gjematkalu wa mupashiregnuchi china. ¿Gi pixka getle gixlu?” Wa wanna pejnuruneko wane chinyegitluna wa Wale giklukanuwna rupninripa. ");
INSERT INTO pibNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Pimrine yinuwaka gitskagjeretanru, rushyagojitanruna, yotmutanruna. Wane chinruna, “Goyakalu tokanu peneklewatkoxewa.” Towrechine giptagojitlu. ");
INSERT INTO pibNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Rapuko rawanata Petro panchiya. Tuna sato rupxakjero wa sasertote gitsrukate potu. ");
INSERT INTO pibNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Wa tetinri wa Petro rolkanatini, tyopukgatlu. Wane china, “Pixni Waleymalutyi, Geso Nasare gajeru.” ");
INSERT INTO pibNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Seyni wale nutata. Wane china, “Gi numatlu. Gi koxa numatjemlu wa pchinyawaka.” Rushpaka. Maleka ya. Yanumatatka gaxawripa. ");
INSERT INTO pibNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Wa gipxaklewatachro getinri, tyinuwaka wane chinretatnakna wane gwanatachine, “Tyenwa satu wannate.” ");
INSERT INTO pibNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Seyni wale nutatatnaka. Gowukshini wane gwanatachine wane chinruna Petro, “Galikakni pixni satu wannatyi. Gi rixanu Kalile gajeryi.” ");
INSERT INTO pibNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Yinuwaka kamakpiirewleta, wane chinreta Wale kawchinanu, “Gi numatpotunatlu wa tye jeji wa Walepirana gyanumsatinri.” ");
INSERT INTO pibNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Waneklu gaxawripa yanumatatka gepi kata chininri. Petro gishiniklu wa tokanu Geso chinyawaklu, “Ma yanumatkanugnapu gaxawripa gepi kata, pnutatanno mapa kata.” Yanshinikanunatlu wa wale, chiyagatatka. ");
INSERT INTO pibNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Waneklutka wa goyechnokawa jemanshinikankakatkana wa tsrukakalune sasertotene, wa tsruneyma, wa yonchikgapineyma, wa ptowruneko jemanshinikankakachineyma. Rostutluna Geso. Ranikatkaluna. Pilato samyokatkaluna. ");
INSERT INTO pibNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilato gepomgalu, “¿Pixlege wa Goteyone Pogiryi?” Rugitlu. Wane china, “Pixa chinyawaka.” ");
INSERT INTO pibNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Wa tsrukakalune sasertotene jigyegitlu gixo. ");
INSERT INTO pibNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Repomgatnaklu Pilato. Wane chinru, “¿Gi ge pugita? Petanu. ¡Gi pajigyeglenanukta rixyegityina!” ");
INSERT INTO pibNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ga wa Geso gi wa waleko rugitya. Giyagni ruglajita Pilato. ");
INSERT INTO pibNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Wa tsrugogneklu rushyegjetna gostutkaluru girukokta ragjitna. ");
INSERT INTO pibNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Wane rawanata satu Warawasu giwakatletachri gostutkaluru yagotkakachineyma, giylalewatachine yagotkakluya. ");
INSERT INTO pibNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Runna gixolune yine. Yinuwaka gagjiretluna rixjetyawakna. ");
INSERT INTO pibNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pilato gigitna. Wane china, “¿Gi ge galuklu gita gishyegityapgi wa Pogirna Goteyone?” ");
INSERT INTO pibNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Rumata ranxalna chinanu samyokluna tsrukakalune sasertotene. ");
INSERT INTO pibNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Seyni wa tsrukakalune sasertotene komyekanshinikanutna gixolune yine rushyegityapna Warawasu galikakapni. ");
INSERT INTO pibNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Rugitatnakna Pilato. Wane china, “¿Klu nixyalu galuka wa gixa giwakatyalu Goteyone Pogire?” ");
INSERT INTO pibNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Wanna saplewatatnaka, “¡Koroshishkita putakjixaganru!” ");
INSERT INTO pibNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Wane chinna Pilato, “¿Klu gektutu kamruta?” Wanna saplewpotuta, “¡Koroshishkita putakjixaganru!” ");
INSERT INTO pibNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilato galuka giglenshinikanretna yine. Giyagni rushyegitna Warawasu. Kochipjetka Geso. Rali kochipjeretkoklunutka, samyoklu koroshishkita rutakikolupa. ");
INSERT INTO pibNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Wa solalone ganiklu wa tsru panchi gitokote. Walenwa Pretoryo. Tomgana ptowruneko wa solalone. ");
INSERT INTO pibNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Yoshmakluna pakni yoshmookaluru pixkalutu mkachri. Yoshmakluna sagyeta kona kamgikolu. ");
INSERT INTO pibNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Yinuwaka galukletluna, “¡Wuya, Goteyone Pogire!” ");
INSERT INTO pibNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ruylakjiwutluna katsluksuya. Rutskagjetluna. Yonogyegitluna. Yoptsojityegitluna. ");
INSERT INTO pibNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Wa rali gapnokatletinitkaluna, komkagatkaluna wa pakni yoshmookaluru pixkalutu mkachri. Waleko gimkalu yoshmakatkaluna. Ranikatkaluna koroshishkita rutakyapatkaluna. ");
INSERT INTO pibNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Rutjikakluna satu giknogamtachri, Simo, Surene gajeru, Galegantro, Rogwo giru, wa sana ginyachri wa ranikyaplo wa Geso koroshishkitate. ");
INSERT INTO pibNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Kolkota chinikowaka ranikatkaluna. Walenwa yokaakaluru, Jiwchiswaga yegi. ");
INSERT INTO pibNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Renekluna winga smurna yapjetkalurga, seyni gi wa yoptotlo. ");
INSERT INTO pibNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Koroshishkita rutakluna. Kotspaltamkatluna. Rutakluna rupenookaklena ranikyapluna satkaka. ");
INSERT INTO pibNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Wa goyechnokawasreta koroshishkita rutakatkaluna. ");
INSERT INTO pibNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Wa tokanu rogwaka gwachri yonatkaluru wa jigyegitikolu, wane china, “Wa Goteyone Pogire.” ");
INSERT INTO pibNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Waleyma koroshishkita rutaakana gepi kachowgurune, satu potuklesreta, satu kegnetesreta. ");
INSERT INTO pibNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Poyagkaakatka Tokanchi Yonatkaluru, wane chinachri: Mugleneyma kagwakikolupa Wale koxa. ");
INSERT INTO pibNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Mupashiregnuchi chinruna giknogachine. Ruwnownojiwutna. Wane chinna, “¡Gaga! Wa Pixni wa kpashiwakapji yotkakachripyi, mapgogne chininri pkamrupjitanru. ");
INSERT INTO pibNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Pixnanuko gognetkakinwa. Pujrukanu wa koroshishkitaya.” ");
INSERT INTO pibNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Waneko pixka rixna wa tsrukakalune sasertotene gapnokatletlu. Wane chinkakna yonchikgapineyma, “Pimrine rognetkaka. Walenanuko gi rumkata gognetkakletnawa. ");
INSERT INTO pibNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Kristo, Gisrayiline Pogire gijrukanu wa xani wa koroshishkitaya. Wetyaplu. Walixyaplu.” Wa Waleyma koroshishkita gitaakalune koxa yangalu. ");
INSERT INTO pibNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Tumananutkani ruchpokatka psolchijnepotunanuyako kayinwakasreta rapokinpotunanuko. ");
INSERT INTO pibNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Kayinwakpapko Geso saplewata. Tsruplaji rixa. Wane china, “Geloyi, Geloyi, ¿Glama sawajtani?” Walenwa yokaakaluru: “Noyakalute, Noyakalute, ¿klu chinanu puknokatkano?” ");
INSERT INTO pibNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Jeminrina pimrine wane gwanatachine, wane chinna wanna, “Gjemanru. Tomgalu Giliya.” ");
INSERT INTO pibNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Rasukamta satu. Katsopi kotsgatapyaluna kachgalu. Katsluksu rutaklu. Reneklu ruranrupa. Wane china, “Getashatanru. Wetkoxewa gikta runanu Giliya koshpakapyaplu.” ");
INSERT INTO pibNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Geso tsruplaji rixa. Rupnanatka. ");
INSERT INTO pibNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Waneklutka mkachrichrata gimaletanatachri kpashiwaka potu gajeru giskakamtatka gepichratatkalu. Teno rumuyaka giskakletyatka chijiina. ");
INSERT INTO pibNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Wale ginaple tunwanata satu ksolaloteru. Retanata wane rixa gipnaletinri. Wane china, “Galikakpotunanni tye jejni Goyakalu Wgenni.” ");
INSERT INTO pibNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Wane koxa tunwanatna suxone. Retanatna gowukayako. Wa wannatskala rawanatna Mariya Maktala gajero, Mariya Santiyako mturu wa Gosi ginro, ga wa Salome koxa. ");
INSERT INTO pibNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Wa wanna Kalile rawanatiniwa romkagjenatluna. Rupxakjenatluna. Wa pimrone gixo waneklu koxa, Waleyma kanikachine wa Gerosale. ");
INSERT INTO pibNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Wa kayi rixinitka wa galpokotikolgogne, walenwa gapnanutikalurgognestsi. ");
INSERT INTO pibNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Gosi Garimate gajeru, jemanshinikankakjetikowaka gajeru kagwakpiratkaluru. Wale koxa kagwaklu pogirewatyawaka Goyakalu. Wane ya. Mpiikatu jiglokyegitlu Pilato. Ragjitlu Gesnimane. ");
INSERT INTO pibNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Wa Pilato giglajita wa rupninrinatka. Repuklu ksolaloteru. Repomgalu wa muchikawako rupninrinatka. ");
INSERT INTO pibNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Runkaklu wa ksolaloteru. Reneklu gimanetka Gosi. ");
INSERT INTO pibNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Wale gagjitlu mkachrichrata. Jijrukatkalu. Poyitatkalu mkachrichrata. Rutaklu yomlechi wa sotlu jitotikalurupna. Rakaprurjixlu sotlu wa giyomle gipgyaptote. ");
INSERT INTO pibNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Wa Mariya Maktala gajero, wa Mariya Gosi ginro, getanatna ginakakta rutakanunruna. ");
INSERT INTO pibNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Wa ruknoginitka wa gapnanutikalurgogne, Mariya Maktala gajero, wa Mariya Santiyako ginro, wa Salome, ragjitlona pgamlugalo wa ruyogatyapluna. ");
INSERT INTO pibNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Goyechnokawpotuko muchinangogne simana wane yana yomlechi yegi. Tkachi gishpakatka. ");
INSERT INTO pibNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Wane chinkakananumtna wannakakluko, “¿Katmakla gakaprurutyanwure sotlu yomlechi gipgyaptote gajeru?” ");
INSERT INTO pibNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Wa retinitkaluna, retluna wa sotlu gajritkalurutka. Gi rixanu tsrupotunanu sotlu. ");
INSERT INTO pibNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Jiglokatkana yomlechi. Retluna jeji tuplanatachri potuklesreta, gimkalu gowukalu gitakachri klatalu. Ruglajpotutna. ");
INSERT INTO pibNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Wane chinna wale, “Gi wa giglajitanu. Gijgalu Geso, Nasare gajeru, wa koroshishkita gitakanatkaluru. Yotunomtatka. Gi gewitkalu. Getanru rutakikowaka. ");
INSERT INTO pibNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Seyni gyanutka. Ginkakanna wa yimaklene, Petro koxa, Wale gapka wane kosekingi. Kalile yanu. Wane getinitkalu chinyawakpotukgi.” ");
INSERT INTO pibNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Wane yiyatkana. Rasukamtna yomlechiya. Wa rutatatna. Ruglajitna. Giketsotaji runkakna, piklena chinanu. ");
INSERT INTO pibNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Wa yotunotinitka wa goyechnokawpotuko muchinangogne wa simanatka, rupgujewnayegitlo muchinanu wa Mariya Maktala gajero. Walanwa ruknokakamchitetanro payokgipre kamchine. ");
INSERT INTO pibNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Tyinitka wala. Tunkakna wa Waleymalunenanu, wa wamonuwnanatachine, chiyaganatachine. ");
INSERT INTO pibNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Wa wanna jemyegitinitkalu ruwekinritka, wa retikolutka walaya, gi ralixna. ");
INSERT INTO pibNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Wanepnute gepi wa wanna yanananumta sana yachine. Geso wane gipgujewnayegitna. Satuko kogetkogatka. ");
INSERT INTO pibNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Wane yiyatkana. Runkakna pimrine. Gi wannako ralixna. ");
INSERT INTO pibNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Ralipretka rupgujewnayegitna Geso pamole satupjene wa tuplanatinna nikawakakwaya. Chigetjetanna wa ma malixleyna shikowgajitinriyna, gi rixanu gi ralixkana retjene yotunomtinritka. ");
INSERT INTO pibNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Wane chinna Wale, “Psolchijneko gyanu. Ginkakletanru Kiglerpotunanu Tokanchi pejnurunenanuko giyakotkalune yegi. ");
INSERT INTO pibNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Wa galixachripa katko wale gognetkaako, seyni wa malixakletu giklukanuwnayegjixko. ");
INSERT INTO pibNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Tyekaka getkalurkaka kamrujetanna wa galixachine. Gita giwakaya ruknokinrina kamchine. Gerotu patokanchikaka yanumatinna. ");
INSERT INTO pibNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Koschekanruna gimnukaka. Rurinrina kamakalu gi wa rumtukanna. Wa yayixachine gogo rutakamyotanna. Ruglewatanna.” ");
INSERT INTO pibNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Wa Gitsrukaachi gali yanumsayegletinitkana, tengogne yoptotikatka. Tuplatatka Goyakalu potuklesretate. ");
INSERT INTO pibNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Wanna gishpakamtatka. Runkaklewatna pasretamnunanukaya. Wa Gitsrukaachi gikamrurewatna. Wannaya Goyakalu kamrujetlu getkalurkaka. Gitsrukaachi poyegitlu tokanu wa getkalurkakayma. Wane gixkalurupa.");
INSERT INTO pibNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Wane rixa. Gi gepika yagota yonretlu wixa yegi kamrutikalurutkapirana. Yagota ginkakpokwakletluna. ");
INSERT INTO pibNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Waneko pixka rixna reyinuwaklewayakawa getachine. Wannanwa tokanchi kamruklerune. Ga wa wanna samyokwu tyekakapirana. ");
INSERT INTO pibNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Giyagni kigle getle nixlu gita koxa nyonyegityi, kshinikanuru potu Teyogwilo. Rixpokotyawaka nunkakyi. Gi rixanu reyinuwakayakawa nomkaginshinikanpiranpotutlu, ");
INSERT INTO pibNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","pumatpotutyaplu koxa pixa poyegitkalurni wa tokanchi punkakikolu. ");
INSERT INTO pibNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Gotechijne pogire Giroreklunanu, waneru satu sasertote, Sakariya giwakatletachri, Gawiyaklopishaneyma gitaakaluru. Ganunronwa Gaaroklopisha. Gilisawetinwa tgiwaka. ");
INSERT INTO pibNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ga wa gepiko poyagkakachinni Goyakalu getanuya. Muklukanuwnakane. Romkagitluna pejnuruko Gitsrukaachi yokanatanru, Wale gitakanru. ");
INSERT INTO pibNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Gi kwugenna gi rixanu migatni Gilisaweti, ga wa gepiko gi gepika walapu waneyanatkana. ");
INSERT INTO pibNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Wa gipapko gapokinpatka sasertote kamrure kamrutinri Goyakalu getanu, wane rixa. ");
INSERT INTO pibNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Sasertotene gixjetyawaka, wale gitaaka yochpikyaplu pgamlupagiri. Kpashiwaka potu Gitsrukaachinu jigloka. ");
INSERT INTO pibNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Pejnuruneko gixolune yine maleka gagjigognenatya yochpiikakopshini pgamlupagiri. ");
INSERT INTO pibNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Gitsrukaachitowreru gipgujewnayegitlu. Pgamlupagiri yochpikjetikowakakwa potuklesretate tunwata. ");
INSERT INTO pibNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Wa retinitkalu Sakariya, kojwakanshinikanutnanwa. Tsru piklu rixa. ");
INSERT INTO pibNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ga wa Goyakalutowreru wane chinru, “Sakariya, gi pikanu. Gi rixanu pagjigognere jemka. Ga wa pganunro Gilisaweti gishpaakakanru puturu. Gwa pgiwakatanru. ");
INSERT INTO pibNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Pumuwatanu. Pumjikanu. Gixo yine gimuwatanu rushpakinri chinanupa. ");
INSERT INTO pibNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Gi rixanu tsrupni Goyakalu getanu. Gi wa wingako ruranu. Gi wa kapsagaluko ruranu. Giwekikaluru Kpashiri gwagajitanru potu rixanu, runronanwakyakawa. ");
INSERT INTO pibNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Gixo Gisrayiliklopishane satkakanu puturupa Gitsrukaachi Royakalutna yegi. ");
INSERT INTO pibNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Giwekikaluruya, Giliya pixka, ga wa ruyakleya runanu. Ma mapookanuwa Gitsrukaachi, wale gapka kosekanu. Wale satkakgajinshinikanutanna girchine wugenenna yegi; ga wa kaalirerune satkakyapa kanshinikanurune rixinripna poyagkakachine pixka. Yine galpokotachripni Gitsrukaachi chinanu giglepokotkalunepa.” ");
INSERT INTO pibNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Sakariya wane chinru Goyakalutowreru, “¿Gi nixpoko gimatletanru? Gi rixanu tsrutsolejinatkano. Ga wa nganunro koxa gi gepika walapu waneyatkalo.” ");
INSERT INTO pibNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Goyakalutowreru gigitlu. Wane chinru, “Gitni Kawrilno. Goyakalustsi tunwatachrino. Gitni yokanatkalurno nuynumsatyapyi, ga wa nunkakyapyi tye kiglerupirana. ");
INSERT INTO pibNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Ga wa xani myanumatkatupyi. Gi pumkata yanumletannuna wale wane gixkoklugognepotunanukopa, pma malixtokanutkalchinanno. Gigogne poyagkaakalurupni ntokanu.” ");
INSERT INTO pibNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Ga wa yine kagwakanatlu Sakariya. Ruglajitna wa kpashiwaka ramginritka chinanu. ");
INSERT INTO pibNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Ga wa rushpakamtinitka, gi rumkata yanumletanatka. Rumatna wa pagixanu retinrinatka getkaluru kpashiwakaya. Rutsejrigjeyegishatatkana. Myanumatkatunannatkani. ");
INSERT INTO pibNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Wane rixa. Poyagkaklu wa sasertote kamrure. Rali poyagkakletinitkalu, gipji yatka. ");
INSERT INTO pibNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Ruknoginitka walegognekaka, kamshirotkani ganunro Gilisaweti. Pamyo ksuru tyogimatnawa. Wane china, ");
INSERT INTO pibNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Giyagni wane rixno Gitsrukaachi, wa walegogne retyano konpatetyapatkano yine getanuya.” ");
INSERT INTO pibNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Patsrujire ksuru chininri Goyakalu yokanatlu gitowreru Kawrili. Satu pokchi Nasare giwakatletachri, Kalilesreta, yokanatlu. ");
INSERT INTO pibNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Makloji jeji metkatowa yegi yokanatlu. Satu jeji gipiratanrotka, Gosi giwakatletachri, Tawiklopisha. Wala makloji giwaka Mariyni. ");
INSERT INTO pibNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Wala yegi jigloka Goyakalutowreru. Wane china, “Mariya, gimutkalurpotyi. Pixaymalu Gitsrukaachi.” ");
INSERT INTO pibNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Tkojwakanshinikanutnanwa wale tokanu chinanu. Tnutanshinikanuta gi pixkalutuknige wa tye galuklewlu. ");
INSERT INTO pibNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Giyagni wa Goyakalutowreru wane chinro, “Mariya, gi pikanu. Gi rixanu Goyakalu gimutatkayi. ");
INSERT INTO pibNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Xani pmushiwatanu. Pushpaakakanru puturu. Pgiwakatanru Geso. ");
INSERT INTO pibNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Tyepni wa tsru. Teno potu Gajeru Wgene chinko. Gitsrukaachi Goyakalu genekanru rutsrukatni Tawi pogirewatyawaka. ");
INSERT INTO pibNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Gakowniklopishane yegi pogirewgognenatini. Pogirewatyawaka gike rixiniko nikawnanu.” ");
INSERT INTO pibNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Giyagni Mariya wane chinru Goyakalutowreru, “¿Gi rixpokotanu wa tye? Gi rixanu gi jeji numatawa.” ");
INSERT INTO pibNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Goyakalutowreru gigita. Wane chinro, “Giwekikaluru Kpashiri ginyegitanyi. Teno potu Gajeru giyakle chikletyegitanyi. Giyagkoxni kpashiripni gishpakachripa wane chinko Goyakalu Wgene. ");
INSERT INTO pibNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ga wa petanro. Pumole koxa Gilisaweti wala koxa tutsroginiko tmushiwata. Toturupni. Patsrujire ksuryegitkalo wa migato chinkaluronanu. ");
INSERT INTO pibNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Gi rixanu Goyakalu gi satuna ma mumkatanutni.” ");
INSERT INTO pibNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Giyagni Mariya wane china, “Gitsrukaachi wayegrerno. Wane nixikolupa pixa chinyawakpotuko.” Wala yegi yiyatka Goyakalutowreru. ");
INSERT INTO pibNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Walegognekaka tpalnamta Mariya. Kmagkatewaka tya. Teyakawamta. Gotechijne gajeru pokchi tya. ");
INSERT INTO pibNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Sakariyapji tjiglokamta. Taluklo Gilisaweti. ");
INSERT INTO pibNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Wane tixatka. Wa Gilisaweti yijnaka galukletinitkalo wa Mariya, wa mturu tonanwaka gajeru ruptekapa. Wa Gilisaweti Giwekikaluru Kpashiri gwagajitanro potu gixachrotkani. ");
INSERT INTO pibNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Tsru saple tixa. Wane china sapleta, “Giglenshinikanyegitkaluryi pixje suxonyegiya. Giglenshinikanyegitkaluru punanwaka gishpakyachripa. ");
INSERT INTO pibNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","¿Gi nixge gita wa tye giknogyapno, wa Nutsrukate ginro ginyegityawakno? ");
INSERT INTO pibNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Gi rixanu neyijnako galukletiniyakawayi, wa mturu nonanwaka gajeru ruptekapa rumuwle chinanu. ");
INSERT INTO pibNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Giglenshinikanyegitkaluro galixachro, gi rixanu poyagkakikolupa wa tunkakikolupirana, wa Gitsrukaachi ginkakjixyalo.” ");
INSERT INTO pibNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Mariya wane china, Numalwutlu Gitsrukaachi nonshinikanuya. ");
INSERT INTO pibNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Ga wa numuwyegitlu Goyakalu, Nognetkakjeru. ");
INSERT INTO pibNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Gi rixanu mpogireto retyano wayegrerno. Xaniyakawa giglenshinikanyegitkalurno Wane chinannona pejnurune gimuweekakgognenatachinepa gapkatatachineshaklumnunanukapa. ");
INSERT INTO pibNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Gi rixanu wa Kgiyaklewakleru tsrupirana kamruyegitno. Kpashiri giwakni. ");
INSERT INTO pibNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Retwamonunanumtna pagwashlukaka gimuweekakgognenatachinmnunanuka wa pikjene. ");
INSERT INTO pibNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Muchkowamyota. Galixkotnachinewa rajiyna ga wa ginshinikanuyna kopalatna. ");
INSERT INTO pibNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Pogirewatyawakna tsrukakalune ruknokya. Mpogirene tsrune rutaka. ");
INSERT INTO pibNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Kiglerkakaya jinanu rixkakna nachichachine. Ga wa ponikolune maleshayalune yokanatna. ");
INSERT INTO pibNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Rupxaklu wayegreru Gisrayili, gi rixanu rushiniklu retwamonrewle, ");
INSERT INTO pibNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Chinyawakpotukna wutsrukatenni, Gawra ga wa giklopishane rushinityawakpotuko. ");
INSERT INTO pibNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Mapa ksuru Gilisawetiyma wane twa Mariya. Wanepnute topji tsatokatnaka. ");
INSERT INTO pibNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Ga wa Gilisaweti poyagkakatkalu togogne tushpakawgenetinripatka, rushpakatka toturu. ");
INSERT INTO pibNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Yijnakotinitkana tumwastsitanune ga wa tomolene wa tsru getwamonre rixyalo Gitsrukaachi, rumuwatna walayma. ");
INSERT INTO pibNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Wane rixatka. Yokgipgogne chininri runna wa sajruka gistakletyapatkaluna wa mturu. Ruru giwakmaka rutakluna, Sakariya. ");
INSERT INTO pibNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Tugita runro. Wane china, “Gike. Seyni Gwa giwakatko.” ");
INSERT INTO pibNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Wane chinrona, “Gi satuna pumole wane tye giwaka giwakatletachri.” ");
INSERT INTO pibNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Rutsejrigjeyegitluna ruru klu giwaka ralukyalu wale. ");
INSERT INTO pibNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Ragjitlu pamta. Yonatlu. Wane china, “Gwanwa giwaka.” Pejnuruneko giglajita. ");
INSERT INTO pibNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Waneklu Sakariya kotpuknamatka ga wa ginnu. Yanumatatka. Rumalwutlu Goyakalu. ");
INSERT INTO pibNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Tsru piklu rixanna pejnuruneko rumwastsitanune. Ga wa psoluko Gotechijne gajeru kmagkatewaka pogiwatya pejnuruko tyepirankaka. ");
INSERT INTO pibNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Pejnuruneko yijnakotachine gimretpiranatlu rajiyna. Wane chinna, “¿Gi gixachrini: xani tye mturu? Gi rixanu waleymalu Goyakalu.” ");
INSERT INTO pibNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Ga wa Sakariyni ruru, Giwekikaluru Kpashiri gwagajitanru potu. Goyakalu tokanu reneklewata. Wane china: ");
INSERT INTO pibNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Gimalwutkalurni Gitsrukaachi, Gisrayiline Goyakalute. Salwayegitna rayinerutene koshpakapna. ");
INSERT INTO pibNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Wixa yegi rupgujewnakakyalu Gognetkaklewatachri potu, satu wayegrerni Tawniklopisha. ");
INSERT INTO pibNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Reyinuwakleyakawa wane chinjetyawakpotuko pejnurunniko kpashirinni tokanchi geneklewatachinniya, ");
INSERT INTO pibNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Gognewatikalurupapirana, wkamnixjeneyegiya, ga wa pejnuruneko wayegixjeneyegiya. ");
INSERT INTO pibNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Gi rixanu retwamonutna wutsrukatenni ga wa rushiniklu kpashiri tokanu rupiratanru. ");
INSERT INTO pibNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Wutsrukatni Gawrani rupiratya Wale kawchinanu renekyapwu ");
INSERT INTO pibNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Mpiikonepwu wushatkapko wkamnixjenyegiya, Wale yegi wkamrurewatinripa, ");
INSERT INTO pibNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Kpashirinepwu, poyagkakachinepwu Goyakalu getanu psolgogneko wugogne. ");
INSERT INTO pibNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ga wa pixa, mturu, teno potu Gajeru tokanu geneklewatachri pchinko Gi rixanu Gitsrukaachi kosekachripyi palpokgapotyaplu. ");
INSERT INTO pibNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Rayinerutene pumatkakanu gognewatikalurupirana kaspukmukochiretikolupna, ");
INSERT INTO pibNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Woyakalute gishiniklewle ga wa retwamonrewle chinanu, Wa wale chinanu salwayegitwu pokamlatachri tengogne potu gishpakyachri. ");
INSERT INTO pibNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Wane rixa pokamlatyegityapna mapshagwaka gwachine, ga wa gipnalchikle tuplanatachinena, wkosekikolupa, giglewanshinikanrugapo gayinripa. ");
INSERT INTO pibNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ga wa mturu tseruwna. Muchkowata Giwekikaluruya. Yineru mwiyawakanu rawanata walegognepotunanuko wa Gisrayiline yegi rupgujewnini. ");
INSERT INTO pibNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Wane rixatka walegognekaka. Susa Gakosto yokanrewata psolchijne gajeneko gitakgiwakatikolupa. Walepirana pogiwata. ");
INSERT INTO pibNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Tye muchinanu gapka gitakgiwakatikolu wane gixka wa Surchijne girukotlewatyachri rixini Surino. ");
INSERT INTO pibNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Satkaka waleko gipokchi ya, rutakgiwakatikolupna pejnuruneko. ");
INSERT INTO pibNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Giyagni Kalilchijne gajeru pokchi Nasare yiyatka Gosi. Gotchijne kanika. Tawi pokchi ya Wele chinikowaka. Tawiklopishni wale. Tawnineru. ");
INSERT INTO pibNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Wa rutakgiwakatikolupa Mariyayma rupiratanro. Kamshirni wala. ");
INSERT INTO pibNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Wane rixatka. Wane rawanatinna tpoyagkakatkalu togogne tushpakawgenetinripatka. ");
INSERT INTO pibNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Tushpaakakatkalu muchinanu toturu. Mkachrichrata tpoyitatkalu. Prachine wakane nikjetyawaka tuklukakatkalu, gi rixanu maleshayna pagruko pnu giyakatyachine gwajetyawaka. ");
INSERT INTO pibNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Walesretako wanena girukotapratachine, maleka gwachine, girukotaprayechnotachine. ");
INSERT INTO pibNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Goyakalutowreru gapyegitna wanna. Gitsrukaachi gatajiwnale yochigyegitna. Pikpotutna. Tsru piklu rixna. ");
INSERT INTO pibNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ga wa Goyakalutowreru wane chinna, “Gi mpikanu. Gi rixanu kigleru tokanchi nunkakapgi, tsru gimuwlupirana, pejnuruneko yinenupni. ");
INSERT INTO pibNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Tawi pokchi rushpakya xani gixa chinanu Gognetkaklewatachri. Walenwa Kristo Gitsrukaachi. ");
INSERT INTO pibNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Waleko rumatikolupa: Gikshikanru mturu mkachrichrata poyitkaluru; prachine nikjetyawaka giklugachri.” ");
INSERT INTO pibNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Walegnapunanu Goyakalutowreruymatkana gixolune solalone tengogne gajene. Goyakalu gimalwutachine. Wane chinachine: ");
INSERT INTO pibNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Goyakalu gimalwutkaluru teno potu Gajeru. Ga wa tyechijne gajene yinenupa giglewanshinikanrewlu, wa giglenshinikanutachinenupa. ");
INSERT INTO pibNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Wane rixatka. Wanna yegi yiyatkana Goyakalutowrerune. Tengogne yatkana. Ga wa girukotapratachine wane chinkakna, “Wele gayanu xani. Wetapanru tyepirana wa giknogachri wa Gitsrukaachi ginkakjixyawu.” ");
INSERT INTO pibNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Giyampotu wane yatkana. Rukshiklona Mariya, ga wa Gosi, ga wa mturu prachine nikjetyawaka giklugachritka. ");
INSERT INTO pibNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Wa retinitkaluna, pogitatkaluna wa mturupirana, wa chinikowakna. ");
INSERT INTO pibNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ga wa pejnuruneko yijnakotachine giglajita wa girukotapratachine chinyawakna. ");
INSERT INTO pibNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Ga wa Mariya pejnuruko tyekakapirana tumreta tajiya. Tyanshinikanpiranatlu. ");
INSERT INTO pibNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Satokatkana girukotapratachine. Ralixkotluna Goyakalu ga wa rumalwutluna pejnurukopiranaya, wa yijnakotanruna ga wa retanruna, wa chinikowakpotukna. ");
INSERT INTO pibNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Yokgipgogne chininitka wa sajruka gistakletikolpatka wa mturu, giwakatka Geso, wa Goyakalutowreru giwakatyawaklu, ma nanwakchi mawakanuwa giwakatlu. ");
INSERT INTO pibNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Wa poyagkakgognetkatka powralu rutakikolupna, wa Moysisi Tokanu Yokanatkaluru chinyawakpotuko, Gerosale ranikatkaluna, wa Gitsrukaachi renekyapatkaluna. ");
INSERT INTO pibNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Wa rixyongatyawaka Gitsrukaachi Tokanu Yokanatkaluru: Pejnuruneko jejine kotpukawugenewlemapatini kpashirine chinkalunepni Gitsrukaachi chinanupa. ");
INSERT INTO pibNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Wa genekashlu giylatkalurupa renekanna wa Gitsrukaachi Tokanu Yokanatkaluru chinyawaka: Gepirine kamowane, waka gepi motkoko wgenene. ");
INSERT INTO pibNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Gerosale waneru satu jeji, Simo giwakatletachri. Walenwa jeji poyagkakachri ga wa kgipashiregolu. Wale kagwaklu rumnanukikolupna Gisrayiline. Waleymalu Giwekikaluru Kpashiri. ");
INSERT INTO pibNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Giwekikaluru Kpashiriya runkaaka gichi rupnanu ma metkanuwalu Gitsrukaachi Kristote. ");
INSERT INTO pibNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Giwekikaluruya kpashiwakapji yatka. Wa kpashiwakapji ranikinitkaluna rurune wa mturu Geso, wane rixyapatkaluna wa rixjetyawakna wa Tokanchi Yokanatkaluru chinanu. ");
INSERT INTO pibNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Giyagni wale kampukatkalu. Rumalwutlu Goyakalu. Wane china: ");
INSERT INTO pibNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Xani, Gitsrukaachi, petasha yaletanutkalu pwayegreru giglewanshinikanutachri pchintokanutyawaka. ");
INSERT INTO pibNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Gi rixanu noygalpotuko netyatkalu gognewatikaluru Pixanu, ");
INSERT INTO pibNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Wa pejnuruneko yine getanu palpokotanru. ");
INSERT INTO pibNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Pokamlatachripni payinyegiya gipgujewnakakachripa. Ga wa payinerutene Gisrayiline yochigyegitachripni.” ");
INSERT INTO pibNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Ga wa ruru, runro giglajita wa wale wane chinikowaka. ");
INSERT INTO pibNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simo giglenshinikanyegitna. Wane chinro runro Mariya, “Pjemanu. Wa Tye gitaaka rujrukinripna, ga wa yotunomtinripna gixolune Gisrayiline. Rutaaka rumatikolupa rixinripa. Gapatkalurupni Wale, ");
INSERT INTO pibNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","rupgujewninripa gixolunenshinikangaji. Ga wa yoglolewapi yoglonshinikanutanyi pixako.” ");
INSERT INTO pibNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Wane koxa twanata Gana, tokanchi geneklewatachro, Panwuri nshicho. Gaseriklopishni. Gixo potu walapu waneyatkalo. Talixinitka, payokgipre walapu tganuru yegi twanata. ");
INSERT INTO pibNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Gipnagnurutachrotkani, ga wa yokgipimole gepkoxamkoje walapu waneyatkalo. Goyechno ga wa gogi gi tushpaka kpashiwakapjiya. Togajirewatinri ga wa tagjigognetinri Gitsrukaachi yegi tkamrurewatya. ");
INSERT INTO pibNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Walepapko tapoka. Wala koxa gipgujtatlu Goyakalu. Walepirana tunkakleta pejnuruneko kagwakachinyegiya, gognewatikaluru Gerosale chinanu kagwakachine. ");
INSERT INTO pibNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Wa poyagkakinitkaluna wa pejnurkakakopirana wa Gitsrukaachi Tokanu Yokanatkaluru chinyawaka, satokatkana. Kalilechijne gajeru pokchi, Nasare, yatkana. ");
INSERT INTO pibNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Ga wa mturu tseruwna. Ga wa muchkowananumta. Kgimatkaleru potu rixinri. Ga wa Goyakalu gimutlewle waneylutni. ");
INSERT INTO pibNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Pawalapkaka Gerosale yana rurune, wa meyiwlu yegi, Tsru Giknoglushgogne. ");
INSERT INTO pibNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Wa pamole gepi walapu chininitka, Gerosale kanikna meyiwlugogneklu, rixjetyawakna. ");
INSERT INTO pibNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Nikawnagognetinitka, satokatkana. Ga wa mturu Geso Gerosale rutukatka. Gi rumatna rurune rutukinritka. ");
INSERT INTO pibNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Kagwakluna rumotsananumtjene yegi rawamtinri. Pagogne yanru yinitkana, rujgatkaluna gimolenna yegi ga wa rumatanunna yegi. ");
INSERT INTO pibNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Wa ma mukshiikanutkaluna, Gerosale satokna. Rujgananumtluna. ");
INSERT INTO pibNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Wane rixatka. Mapgogne giknoginitka, kpashiwakapji rukshikyatkaluna. Kgimatkalerune ganikajite tuplanata. Jemanatna, ga wa repomgana. ");
INSERT INTO pibNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Pejnuruneko wa yijnakotjene giglajita rushinikanuwleya ga wa Wale gigityawakna. ");
INSERT INTO pibNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Wa retinitkaluna, ruglajitna. Runro wane chinru, “Noturu, ¿klu chinanu wane pixwu? Gi rixanu, gita ga wa puru gijgayi. Kachingajpotwu.” ");
INSERT INTO pibNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Giyagni Wale wane chinna, “¿Klu chinanu gijgano? ¿Gi ge gimata wa Nuru kamrure numkata kamruretatka?” ");
INSERT INTO pibNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Gi rumata jemluna wale tokanu wa chinyawakna. ");
INSERT INTO pibNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Wannayma yopikatka. Nasare yatka. Yijnakotna. Runro taji gimretpiranatlu pejnuruko tyijnakotanru ga wa tetanrupirana. ");
INSERT INTO pibNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Ga wa Geso tseruwnagimatkalewleta. Ya tseruwnaleta. Pnuteyaka Goyakalu gigleretyawaka kamruta, ga wa yine gigleretyawaka koxa. ");
INSERT INTO pibNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Pamole pamyo walapu girukotlewwatinitka Tiweryo Susa, Ponsyo Pilato girukotlewata Gotesretaya. Ga wa Girore girukotlewata Kalilesretaya. Ga wa repuru Wilipi girukotlewata Gitorisretaya ga wa Trakonitesretaya. Ga wa Lisani girukotlewata Gawilinisretaya. ");
INSERT INTO pibNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Sasertotene gitsrukatene potu rixanatinna Ganasu ga wa Kaygwasu, Goyakalu tokanu ginyegitlu Gwa, Sakariya wgene, yineru mwiyawakanuya. ");
INSERT INTO pibNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Psoluko Gorta Gapgasretchijne yamta. Runkakletananumtlu katlupirana renshinikanutinripna yine, ga wa kaspukmukochiretikolupna. ");
INSERT INTO pibNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Wane rixa chinyongatyawaka Gisayiya tokanchi geneklewatachri kirukate: Yineru mwiyawakanu saplewatyachri tokanu: Galpokotanru Gitsrukaachi gatnugapote. Mpotukatanru gigapkaka. ");
INSERT INTO pibNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Pejnuruko magkachpalkaka tsepotkalurupni. Pejnuruko magkamriji ga wa mturu magka patenkaklutkalurupni. Ga wa katpagapkakalu potukatgapotkalurupni. Ga wa kamlojgapolu pgayamta rixgapotko. ");
INSERT INTO pibNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Ga wa pejnuruko yineru getanru gognewatikaluru Goyakalunu. ");
INSERT INTO pibNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Ga wa Gwa wane chinna gixolune yine gishpakamtachine wale katyapna, “Gimnu pixkalungi. ¿Katu ginkakgi gasukyegityawaklu Goyakalu jgekanupa? ");
INSERT INTO pibNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Giyagni gkamrutanru genshinikanrewlu gimuknu kamrure. Gi wa gyinuwaka wane chinkakletanu, ‘Waneywu wutsrukatni Gawrani.’ Gi rixanu gita wane chingi, Goyakalu gimkata gipgujewnakakletanna Gawraklopishanemka tyekaka sotlukakaya. ");
INSERT INTO pibNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Xani koxa gagmunasko rapokatka gepchi. Pejnuruko gagmuna kiglejiru mwanutu kayiikalurni. Xirnachri ruknookona. Waneko pixka rixko yineru kigleru kamrurchi ma kamrutkanupa.” ");
INSERT INTO pibNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Ga wa gixolune yine gepomgalu. Wane chinruna, “Giyagni ¿klu wkamrutanu?” ");
INSERT INTO pibNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Rugita Gwa. Wane chinna, “Wa gepi mkachri waneyalutu, renekanru waneyamigjetu. Ga wa nikchi waneyalutu waneko pixka rixanu.” ");
INSERT INTO pibNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Runkoxna gijgawenutachine katikolupna. Wane chinruna, “Yimaklewatachri, ¿klu wkamrutanu?” ");
INSERT INTO pibNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Wale wane chinna, “Gi wa gitaakaluru pnute gijganu.” ");
INSERT INTO pibNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Solalone koxa gepomgalu. Wane chinruna, “¿Ga wa wixa klu wkamrutanu?” Wane chinna wanna, “Gi satuna mpiikakanu sroschi gijginriya. Gi koxa gapatlewatanu. Mpoyagnutanru gwenutikolu.” ");
INSERT INTO pibNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Kagwakanatna yine. Pejnuruneko rajiyna gishinikanuwyegitlu Gwa, gikta Kristoni. ");
INSERT INTO pibNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Pejnuruneko rugita Gwa. Wane chinna, “Gita galikakni katgi gonuya. Ga wa runa gita pnute muchkonurutu. Gi wa gita gimuluni nkoshpirokyaplu yoshmaklejixitsa. Wale katangi Giwekikaluru Kpashiriya ga wa xirnachriya. ");
INSERT INTO pibNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ruplokapre gimyo gwa. Triko powratpotutanru giylakaajetikowaka. Rapatjetanru trikneji rumretyawakaplu, ga wa yoxikanru gichicha xirniywaka gike rixiniko muwnakatupa. Waneko pixka rixanunna yinepni. Genshinikanutachine rumretanu, ga wa menshinikanutkane xirnachri ruknokanu.” ");
INSERT INTO pibNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Giyagni gixo giykolu ga wa pimripirana giykolu kigleru galikakni runkakletna yine. ");
INSERT INTO pibNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Giyagni Gwa gijretlu Girore pasreta girukotlewatyachri wa Giroryana repuru Wilipi gnunro chinanu, ga wa pejnuruko mugletu kamrutanru Girore chinanu. ");
INSERT INTO pibNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Pejnuruko tyekaka pnute potu rixyatka. Yoshmakikowaka rushyayegitlu Gwa. ");
INSERT INTO pibNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Ma yoshmaakonuwa Gwa wane rixatka. Pejnuruneko yine katkatka, ga wa Geso koxa katkatka. Ga wa ragjigognetini tengogne kotpuuka. ");
INSERT INTO pibNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Wale yegi Giwekikaluru Kpashiri gijrukatka, kamanemnuru. Motkoko pixka rixmanemta. Waneylu tokanchi tengogneya wane chinachri, “Pixni Noturyi nalukanruyi. Pixa gigletanshinikanutno.” ");
INSERT INTO pibNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Waleko Geso mapamole walapustsitka. Gosi wgene kagwakikaluru. ");
INSERT INTO pibNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Ga wa Gosni wa Gili wgene. Walenwa Mata wgene. Walenwa Rewi wgene. Walenwa Melchi wgene. Walenwa Ganasu wgene. Walenwa Gosi wgene. ");
INSERT INTO pibNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Walenwa Matati wgene. Walenwa Gamo wgene. Walenwa Nawomo wgene. Walenwa Gesli wgene. Walenwa Naaka wgene. ");
INSERT INTO pibNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Walenwa Mati wgene. Walenwa Matati wgene. Walenwa Simi wgene. Walenwa Gosi wgene. Walenwa Gota wgene. ");
INSERT INTO pibNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Walenwa Gowana wgene. Walenwa Resa wgene. Walenwa Sorowawil wgene. Walenwa Salatili wgene. Walenwa Neri wgene. ");
INSERT INTO pibNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Walenwa Melchi wgene. Walenwa Gawti wgene. Walenwa Kosami wgene. Walenwa Gelmotami wgene. Walenwa Geri wgene. ");
INSERT INTO pibNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Walenwa Geso wgene. Walenwa Giliyase wgene. Walenwa Goreyi wgene. Walenwa Matati wgene. Walenwa Rewi wgene. ");
INSERT INTO pibNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Walenwa Simo wgene. Walenwa Gota wgene. Walenwa Gosi wgene. Walenwa Gonani wgene. Walenwa Giliyachi wgene. ");
INSERT INTO pibNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Walenwa Meleya wgene. Walenwa Maynani wgene. Walenwa Nata wgene. Walenwa Tawi wgene. ");
INSERT INTO pibNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Walenwa Gesi wgene. Walenwa Gowe wgene. Walenwa Poosi wgene. Walenwa Salmo wgene. Walenwa Naasoni wgene. ");
INSERT INTO pibNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Walenwa Gaminata wgene. Walenwa Gatni wgene. Walenwa Pare wgene. Walenwa Gota wgene. ");
INSERT INTO pibNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Walenwa Gakowo wgene. Walenwa Gisaaka wgene. Walenwa Gawra wgene. Walenwa Tara wgene. Walenwa Nachori wgene. ");
INSERT INTO pibNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Walenwa Sarochi wgene. Walenwa Rakawo wgene. Walenwa Paleka wgene. Walenwa Gewre wgene. Walenwa Sala wgene. ");
INSERT INTO pibNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Walenwa Kaanani wgene. Walenwa Garpaksa wgene. Walenwa Seme wgene. Walenwa Nowe wgene. Walenwa Lamechi wgene. ");
INSERT INTO pibNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Walenwa Matosala wgene. Walenwa Genochi wgene. Walenwa Gare wgene. Walenwa Malereri wgene. Walenwa Kaanani wgene. ");
INSERT INTO pibNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Walenwa Genoso wgene. Walenwa Seti wgene. Walenwa Gata wgene. Walenwa Goyakalu wgene. ");
INSERT INTO pibNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Ga wa Geso Gorta satokyatka. Giwekikaluru Kpashiri gwagajitanrupotni. Yineru mwiyawakanu raniika Giwekikaluru chinanu. ");
INSERT INTO pibNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Gepkoxamkojmolgogne tsru kamchi yantaletlu. Gike nika walegognekaka. Ruknoogognetinitka, nachneru. ");
INSERT INTO pibNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Giyagni tsru kamchi wane chinru, “Goyakalu Wgene pixinipa, wane pchinanru tye sotlu jimapro rixinwa.” ");
INSERT INTO pibNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Geso gigitlu, “Wane chinyongayegitkalurutkani: Gi wa niikalurupje ruwekya yineru.” ");
INSERT INTO pibNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Tenolu potu magka raniklu. Pshinitsonuji rekakgitlu pejnuruko pogirewatyawaakaka psolchijiko. ");
INSERT INTO pibNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Tsru kamchi wane chinru, “Nutakanyi tye ptowruko chinanu. Ptowruko pogirewle nenekanyi. Gi rixanu gita samyookalurni, ga wa katukta naluka nenekanru. ");
INSERT INTO pibNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Wa pyoptsojityegitinipno pejnuruko pixanpatkani.” ");
INSERT INTO pibNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Geso gigitlu, wane chinru, “Yonatkalurutkani: Gitsrukaachi Poyakalute pyoptsojityegitanu. Walepje pkamrurewyegitanu.” ");
INSERT INTO pibNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Giyagni Gerosale raniklu. Kpashiwakapji gwachri tenoptaji potu rutaklu. Wane chinru, “Goyakalu Wgene pchininipa, gewi pakaxikamtini. ");
INSERT INTO pibNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Gi rixanu wane chinyongayegitkalurutkani: Gitowrene towutyegitanyi wanna girukotyapyi. ");
INSERT INTO pibNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Ga wa: Kashichanyina gimyoyna, gi pagogneko sotlu putspejixitinripa.” ");
INSERT INTO pibNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Geso gigita. Wane chinru, “Kapiranalutkani: Gi pyantaletanru Gitsrukaachi Poyakalute.” ");
INSERT INTO pibNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Rali yantaletletinitkalu pejnuruko yantaletlewluya, Wale yegi yiyatka tsru kamchi. Wanepshini retashatlu. ");
INSERT INTO pibNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Ga wa Giwekikaluru giyakleyma satokatka Geso. Kalile yatka. Psolchijiko walesreta pogiwapiranatyatka. ");
INSERT INTO pibNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Wanna ginkaklewawaklepjikaka runkaklewatya. Gimalwutkalurni pejnuruneyako. ");
INSERT INTO pibNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Nasare yatka, wa tseruwakikwaka. Rixjetyawaka gapnanutikalurgogne jiglokjetlu ginkaklewawakapji. Palna. Retyongata. ");
INSERT INTO pibNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Tokanchi geneklewatachri Gisayiya kirukate reneeka. Koprakatkalo kiruka. Rukshiklu wane china yongatyawaka: ");
INSERT INTO pibNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Gita rawa Gitsrukaachinu Giwekikaluru. Gi rixanu Wale tsomitno Kiglerpotunanu Tokanchi nenekyapna kwamonurune. Wale yokanatno kashikanotkalune yegi nunkakletyaplu gishpakikolupirana. Ga wa maygalene yegi, gimrekgalupirana. Nkoshpakyapna kapsakletkalune. ");
INSERT INTO pibNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Nunkakletyaplu Gitsrukaachi gimutlewle walapute. ");
INSERT INTO pibNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Saprurutatkalo kiruka. Kamrurewatachri renekatkalo. Tuplatatka. Pejnuruneko ginkaklewawakapji gwanatachine yopukgapotutlu. ");
INSERT INTO pibNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Yinuwaka wane chinretna, “Xawakni poyagkaakatka tye Tokanchi Yonatkaluru gixa jemanu.” ");
INSERT INTO pibNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Pejnuruneko pogitlu. Ruglajyegitluna rumutlewle tokanuya, wa yanumatinri. Wanna wane china, “¿Gi ge Gosi wgenekni wa Tye?” ");
INSERT INTO pibNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Wane chinna Geso, “Pejnurunekgi gixa tye yapkaklu nchinanno, ‘Kpinrewakleru, putuukakinwa pixnanuko. Klunerukta wyijnakpiranyegitanru Kapernawo kamrutikaluruya, gewi koxa puchijneya pkamrutinri.’ ” ");
INSERT INTO pibNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Wane china, “Galikakni wane nchingi, gi satuna tokanchi geneklewatachri galuukalurni gichijneya. ");
INSERT INTO pibNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Galikakni wane nchingi, Giliyaklunanu tengogne gishyatkalurunanni. Mapa walapu ga wa patsrujire ksuru rushyanatka, ga wa tsru nachinanni psolchijneko. Waleklu gi gepikananna gipnagnurutachrone Gisrayilichijneya. ");
INSERT INTO pibNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Seyni gi satona wanna yegi yokanatka Giliya, seyni Sarepta Pokchi, Sitosreta yokanatka, sato suxo gipnagnurutachro yegi. ");
INSERT INTO pibNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Giliseyo tokanchi geneklewatachriklunanu gi gepikananna gijirgitutachine Gisrayilchijne gwachine. Seyni gi satuna wa nyi powratka. Ga wa Naama galikakni Suri gajeru powratka.” ");
INSERT INTO pibNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Giyagni pejnuruneko ginkaklewawakapji gwachine ramewnapotutna, tyepirana yijnakotinna. ");
INSERT INTO pibNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Palnamtna. Pokchi malekate ranikluna. Pokchi magkatetajgapotuko ranikluna, yotkakyapmakluna gitskata. ");
INSERT INTO pibNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Seyni Wale wanna ganikajite yapamta. Yatka. ");
INSERT INTO pibNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Yopikamtatka. Kapernawo yatka, Kalilesreta gajeru pokchi. Gapnanutikalurgognekaka runkakaklewjeta. ");
INSERT INTO pibNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Runkaklewle koglajejetna, gi rixanu tsru gitaakaluru tokanni. ");
INSERT INTO pibNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ginkaklewawakapji waneru satu jeji kamchi puchotlewatachri waneyalutu. Wale tsru saple gixa. ");
INSERT INTO pibNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","Wane china, “¡Ya! ¿Gi pixannatkawu Geso Nasare gajeru? ¿Puna pumtukpotutapyapwu? Numatyi katyi Pixa Kpashiryi Goyakalunu.” ");
INSERT INTO pibNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Geso chigetjetlu. Wane china, “Pochkepyi. Pushpakanutka waleya.” Giyagni wa kamchi ganikajitskalaya yawnakaklu. Wale rushpakamtyatka. Gi wa rumtukamtlu. ");
INSERT INTO pibNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Tsru giglajru rixna pejnuruneko. Wannakakluko giynumsakaka. Wane chinkakna, “¿Klu tokanchinwa tye, gi rixanu tsru gitaakaluru ga wa kgiyaklewaklerni rixa yokanretna kamchine puchotlewatachine? Rushpakamtna.” ");
INSERT INTO pibNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Pogita piranamtkatka psoluko walesreta sajrukleya. ");
INSERT INTO pibNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Palnamta Geso. Ginkaklewawakapji yiyatka. Simopji jigloka. Simo gimajirni tsru pachwalu kashichanro. Wala chinanu ragjitluna. ");
INSERT INTO pibNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Walastsi tunwata. Chigetjetlu pachwalu. Kaspukatkalo pachwalu. Waneklu tpalnamtatka. Tupxakatkana. ");
INSERT INTO pibNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Wa rumxikinitka tkachi, pejnuruneko yayixmoletachine ga wa pimrine yayixachine waneyalune, satumnunanuka gagijewnalkakaya ranikyegitluna. Satkaka rutakamyogogota. Rutuukakna. ");
INSERT INTO pibNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Kamchi gishpakyegitna gi gepiko koxa. Saplewamtachine wane china saplemtna, “Pixni Goyakalu Wgenyi.” Seyni rujretna. Gi retasha yanumsaletanna tyepirankakaya, gi rixanu rumatluna Walenwa Kristo. ");
INSERT INTO pibNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Gogi rixinitka rushpakamta. Yineru mwiyawakanu ya. Ga wa gixolune yine gijgalu. Yayegitluna. Chipetmakluna wa wanna yegi ma yinitipachi. ");
INSERT INTO pibNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Seyni Wale wane chinna, “Numkata papokchikaka Kiglerpotunanu Tokanchi ginkaklewletya, Goyakalu pogirewatyawakapirana. Gi rixanu wale chinanukni nyokanatka.” ");
INSERT INTO pibNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ginkaklewawakapjikakaya runkaklewananumtya Gotechijneya. ");
INSERT INTO pibNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Wane rixatka. Genesare Powgawnaga rawanata. Gixolune yine gachpaklu, Goyakalu tokanu yijnakotinripna. ");
INSERT INTO pibNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Retlo gepi kanawa, gipowgawnaga gwanatachro. Chalugjetachine gitspakamtanrotka. Rerkachalnetna. ");
INSERT INTO pibNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Sato kanawa rupteka, Simo kanawate. Simo ragjita ganikajgayaka ranikyaplu. Kanawa tuplata. Runkaklewyegitna gixolune yine. ");
INSERT INTO pibNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Rutuka ginkaklewletinitka, wane chinru Simo, “Tengawaka gyanu. Giknokchalnetanu shima gkashichinripa.” ");
INSERT INTO pibNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simo gigitlu. Wane chinru, “Gitsrukaachi, psolyechnoko wkamrurewpotuta. Giketsotaaji wkashichana. Seyni Pixa tokanu chinanu, wuknokanru chalu.” ");
INSERT INTO pibNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Wane rixinitkana gixo potu shimni sajikna. Ruskatana chalnenina. ");
INSERT INTO pibNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Rupxaalunna repnomyoyegitna wa sato kanawa gwanatachine wa rupxakapyapna. Runna. Gepi kanawa tsepotna. Wane tixa gimxiklepotutana kanawni. ");
INSERT INTO pibNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Wa Simo Petro getinitkalu, Gesosoji rapokamta Petro. Wane china, “Puxrikyegitanno, Gitsrukaachi. Gi rixanu gitni jejno kmukochirerno.” ");
INSERT INTO pibNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Gi rixanu ruglajpotutana ga wa pejnuruneko waleymalune gixoluro shima chinanu wa kashichanrona. ");
INSERT INTO pibNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Waneko pixka rixna Gakowo ga wa Gwa, Sewereyo wgenene, wa Simo gipxaalune. Ga wa Geso wane chinru Simo, “Gi pikanu. Xaniyakawa kyinegaklerpatkayi.” ");
INSERT INTO pibNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Chiji kosepowamtatkalona kanawkaka. Pejnuruko ruknokamtatkana. Romkagitatkaluna. ");
INSERT INTO pibNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Wane rixatka. Satu pokchi rawanatini, waneru satu jeji gijirgitutachripotuna. Geso reta. Yoptsojityegitlu. Chiji yonogita. Ragjitlu. Wane chinru, “Gitsrukaachi, palukiniplu pumkata powratletanunno.” ");
INSERT INTO pibNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Giyagni romyokyegitlu. Kamruklu. Wane chinru, “Naluklu. Powrapatkayi.” Wanekluyakawa gijirgitlu gitukyegitatkalu wale. ");
INSERT INTO pibNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Ga wa Geso gijretatkalu gi satuna runkakinripa, seyni, “Pyanu,” chinru. “Sasertote pekakgitapinwa. Penekashatanru powranuya wa Moysisi yokanatanru. Walepni nupgujtatjeru wanna chinanu.” ");
INSERT INTO pibNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Seyni pnute pogitka Walepirana. Giyagni gixolune yine gapatyegitlu wa yijnakotyapluna, wa rutuukakikolupna yayixleyna. ");
INSERT INTO pibNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Seyni Wale gixrikamta. Yineru mwiyawakanu ya. Wane ragjigognetya. ");
INSERT INTO pibNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Pagogne wane rixatka. Wale ginkaklewanata. Wane tuplanatna Gwariseyone ga wa Tokanchi Yokanatkaluru yimaklewatachine. Wanna papokchimnunanuka ruyakatyana, Kalilesreta, Gotesreta, ga wa Gerosale koxa. Waneru Gitsrukaachi giyakle rutuukakyapna. ");
INSERT INTO pibNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Giyagni pimrine jejine ganiklu satu jeji gijekoya. Walenwa giktegachri. Rujgaluna wa gitoko yoshmakletanruna, Gesostsi rutakyapluna. ");
INSERT INTO pibNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Gi rukshikluna gi rixpoko yoshmakletluna gixolune yine chinanu. Panchi gogo ratskotatkana. Washreswa jijrukyaluna gijekoya. Ganikaji Gesostsi rutakluna. ");
INSERT INTO pibNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Geso getlu wanna galixle. Wane china, “Jeji, pmukochirkaka kaspuukatkayi.” ");
INSERT INTO pibNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Giyagni wa yonchikgapine ga wa Gwariseyone yinuwaka yanshinikanretna. Wane chinna, “¿Gi gixachrinwa Tye wa mupashiregnuchi china yanumsaleta? ¿Katu gimkata kaspukmukochiirewleta? Satupjeru, Goyakalupje.” ");
INSERT INTO pibNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Giyagni Geso gimata wane rixanshinikanutinrina. Rugita. Wane chinna, ");
INSERT INTO pibNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","“¿Klu chinanu wane gixanshinikanuta tyekaka wa gajiya? ¿Girni wa myapretpotu, wane chinyalu giktegachri, ‘Wa pmukochirkaka kaspuukatkayi,’ ga wa wane chinyalu, ‘Pyotunotanu. Pyanutka?’ ");
INSERT INTO pibNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Wa gimatyaplu wa Gita Yineru Wgenno gitaakalurno tye chijiya kaspukmukochirewletachripa,” wane chinru giktegachri, “Pixa wane nchina, Pyotunotanu. Pkoschekjekomtanu. Pyanutka pupji.” ");
INSERT INTO pibNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Waneklu yotunomtatka wa pejnurune wanna getanu. Koscheklu rukluganatyawakamta. Gipji yatka. Rumalwumtlu Goyakalu. ");
INSERT INTO pibNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Pejnurunniko giglajitana, ga wa rumalwutluna Goyakalu. Tsru piklu rixna. Wane chinna, “Koglajlewatachri weta xawakni.” ");
INSERT INTO pibNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Wanepnute rushpakamta. Retlu satu gijgawenutachri. Rewi giwakatletachri, gijgawenutikwaka tuplanatachri. Wane chinru, “Pomkagitanno.” ");
INSERT INTO pibNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Ruknokamtlu pejnurkakako. Palnamta. Romkagitatkalu. ");
INSERT INTO pibNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Rewi tsru nachnewlu kamruta gipjiya. Gi gepikna wane gijgawenutachine ga wa pimrine koxa wannayma tuplanatachine nikikowakaya. ");
INSERT INTO pibNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Gwariseyone ga wa yonchikgaprenna kegemgana Geso yimaklenyegiya. Wane chinna, “¿Gi rixatka wa wannayma nika, rura, wanna gijgawenutachine, wanna kmukochirerune?” ");
INSERT INTO pibNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Rugita Geso. Wane chinna, “Wa gichkolune gi galuklu kpinrewakleru, seyni yayixachine galuklu. ");
INSERT INTO pibNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Gi wa nuna ntomgiyapna poyagkakachine seyni wanna kmukochirerune ntomginripni renshinikanutinripna.” ");
INSERT INTO pibNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Giyagni wanna wane chinru, “Wa Gwa yimaklene gogajirewata gixo kata ga wa ragjigognetkoxna. Waneko pixka rixna wa Gwariseyone yimaklene. Ga wa Pixa yimaklene nikna ga wa rurna.” ");
INSERT INTO pibNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Wane chinna Geso, “Gi rumkata gogajirewletna kashimyolu getachine, wanna yegi rawinikopshini gnunrowatachri, xani pixka Gita gimwakopshinna nyimaklene. ");
INSERT INTO pibNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Runinpatka pagogne wa gnunrowatachri konikolgognepatka wannaya. Waneklugogne rogajirewatanna wanna.” ");
INSERT INTO pibNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Yapkaklu koxa runkakna. Wane china, “Gikena gamatlu gerotsama wa mkachritsole. Wane rixkoklunu wa gerotsama suskaktsoletlu. Gi koxa pixkakakluni gitsole ga wa gerotsamayma. ");
INSERT INTO pibNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Gikena giyokgatlu winga gerotu tsapkaka tsrutsoleji. Wane rixkoklunutka winga gerotu suskakanru tsapkakni. Tuyokgata wino. Tsapkaka salewna. ");
INSERT INTO pibNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Seyni wa winga gerotu tsapa gerotu tuyokgatka. ");
INSERT INTO pibNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Gi satuna kapokotga girachri galuklu gerotga. Gi rixanu wane china, ‘Kapokotga galikaka kiglepotlu.’ ” ");
INSERT INTO pibNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Wane rixatka. Sana yapanatna Gesoyma gapnanutikalurgogne. Ga wa yimaklene sustakagwumtluna gitaklugwu. Gimyoyna jipekamtluna. Nikamtluna. ");
INSERT INTO pibNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Pimrine Gwariseyone wane china, “¿Klu chinanu wane rixna gapnanutikalurgogne wa ginanshichkalurgogne?” ");
INSERT INTO pibNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Rugita Geso. Wane chinna, “¿Gi ge pagogne getyongapiranyegitlu Tawi kamrutanru wa nachichini wale ga wa waleymalune koxa? ");
INSERT INTO pibNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Gi rixpoko jiglokletlu Goyakalupji. Jimaprokaka gekakgitkalurkaka koscheka. Niklu. Ga wa waleymalune koxa reneka. Walenwa ginanshichkaluru niklu. Sasertotenepje nikanruni.” ");
INSERT INTO pibNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Wane chinna, “Gapnanutikalurgogne koxa Gitsrukatno Gita wa Yineru Wgenno.” ");
INSERT INTO pibNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Wane rixa koxa satu gapnanutikalurgogne. Ginkaklewwakapji jigloka. Wane runkaklewatya. Wane rawanata satu jeji potuklemyo giprigamyotyachri. ");
INSERT INTO pibNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Giruktatluna yonchikgapine ga wa Gwariseyone, wa gapnanutikalurgogne rutuukaklewjetinri. Rujgaluna wa jigyegityapluna. ");
INSERT INTO pibNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Seyni Wale gimatlu yanshinikanutanruna. Wane chinru wa jeji giprigamyotachri, “Pyotunotanu. Ganikaji ptunwatanu.” Giyagni yotunomtatka. Ganikaji tunwata. ");
INSERT INTO pibNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Giyagni Geso wane chinna, “Nepomgangi, ¿girni wa gapnanutikalurgogne muklukanutu kamrutkalurupa, waka kiglerge waka gektutlege? ¿Gognetkaklurge giweklu waka giylalu?” ");
INSERT INTO pibNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Geso geknokyegitna pejnuruneko. Wane chinru, “Pomyokanu.” Wane rixa. Ruglewamyotatka. ");
INSERT INTO pibNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Seprolokpotutatkana. Yanumsayegkakna wannakakluko gi rixpokotanruna Geso. ");
INSERT INTO pibNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Wane rixatka walegognekaka. Magka ya. Ragjigognetapa. Psolu yechnoko ruynumatlu Goyakalu. ");
INSERT INTO pibNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Gogi rixinitka, tomgana yimaklene. Tsomitna pamole gepi wanna. Yokanatanune chinkoxna. ");
INSERT INTO pibNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Wa Simo. Wale rutakgiwakata Petro. Ga wa repuru Gantirishi, ga wa Santiyako, ga wa Gwa, ga wa Wilipi, ga wa Wartolo. ");
INSERT INTO pibNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Ga wa Matiyo, ga wa Tomasu, ga wa Santiyako, Galgweyo wgene, ga wa Simo wa Muchkopiranawatachri chinkaluru. ");
INSERT INTO pibNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Ga wa Gota, Santiyako wgene. Ga wa Gota Giskaryote. Walenwa samyokjerupa. ");
INSERT INTO pibNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Wannayma yopikatka. Wa gimta chiji rawna ga wa gixolune yimaklene ga wa gixolune potu yine, psoluko Gotesreta gajene, ga wa Gerosale gajene, ga wa tsru wenustsi Tiro ga wa Sitosreta gajene. ");
INSERT INTO pibNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Runna yijnakotyapluna, ga wa ragijewnalna rutuukakikolupna. Ga wa kamchine puchotlewatachine kojwakanunena gituukaakalunetkani. ");
INSERT INTO pibNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Pejnuruneko gixolune yine galuka kamrukletlu Geso, gi rixanu Waleya rushpaka giyaklu. Pejnuruneko rutuukaka. ");
INSERT INTO pibNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Tunogyegitna yimaklene. Wane china: Giglenshinikanyegitkalungi kwamonurungi, gi rixanu gixanni Goyakalu pogirewatyawaka. ");
INSERT INTO pibNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Giglenshinikanyegitkalungi xani nachichachingi, gi rixanu jinanurunepgi. Giglenshinikanyegitkalungi chiyagatachingi xani, gi rixanu gitsolguwatachinepgi. ");
INSERT INTO pibNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“Giglenshinikanyegitkalunepgi wa yine gayegixinipgi, ga wa ruxrikyegitinipgina, ga wa yanginipgina, ga wa ma maluka yijnaklegiwakatinipgina wa mugletu pixka, Gita wa Yineru Wgenno chinanupa. ");
INSERT INTO pibNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","“Walgogne gimuwatachinepgi. Giptetanu gimuwleya. Gi rixanu tsrupotni gapnutikolupa tengogneya. Gi rixanu tokanchi geneklewatachine wane gixka rutsrukatenniyna. ");
INSERT INTO pibNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Seyni ¡gi wanengi gixa ponikolungi! gi rixanu waneyatkagi psoluko gimnanukikolu. ");
INSERT INTO pibNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","¡Gi wanengi gixa jinanurungi xani! gi rixanu nachichachinepgi. ¡Gi wanengi gixa xawakni gitsolguwatachingi! gi rixanu wamonuwatachinepgi, chiyagatachinepgi. ");
INSERT INTO pibNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“¡Gi wanengi gixa wa pejnuruneko yine kiglerune chinanungi! gi rixanu tokanchi geneklewatachine migjene wane gixka rutsrukatenniyna. ");
INSERT INTO pibNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Seyni wane nchingi gixa, yijnakotachingi, gishinikanna gkamnixjene. Kigle getle gixanna gayegixjene. ");
INSERT INTO pibNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Gagjitanru Goyakalu ruglenshinikanyegitanna gkamakpiratjene. Gagjigogneyegitanna gektutetjene. ");
INSERT INTO pibNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Ga wa puptagojitjeru pasretgoji koxa penekanru. Ga wa pkonpatatjeru gi wa pumkalu koxa pchipetinri. ");
INSERT INTO pibNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Katukta gagjitinipyi, penekanru. Ga wa wane pixle konachripa, gi wa psatkakjixanru. ");
INSERT INTO pibNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Gikta gixpoko galuka gixkota gixa wa yineya, waneko pixka pixanna wanna. ");
INSERT INTO pibNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Gi rixanu wa gishinikjene gishinikinipa, ¿kluneruya mpoyagnutiko? Gi rixanu kmukochirewaklerune koxa gishinikna wa rushinikjenna. ");
INSERT INTO pibNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ga wa kigle getle gixinipna wa kigle getle gixjene, ¿kluneruya mpoyagnutiko? Gi rixanu kmukochirewaklerune waneko pixka gixa. ");
INSERT INTO pibNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Wa nserojiprojite genekinna wa gkagwaka nsatkakletjenepa wane pejnupotuko, ¿kluneruya mpoyagnutiko? Wa kmukochirewaklerune koxa sroschi genekjetna wa wane pejnu kagwaka satkakjenepa. ");
INSERT INTO pibNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Seyni gishinikanna gkamnixjene. Kigle getle gixanna. Nserojiprojite genekanu mkagwaka satkakletkoto. Tsru potu gapnutikolupa. Teno potu Gajeru wgenenepgi. Gi rixanu retwamonutna wa poyagnu mchinkane ga wa muglene. ");
INSERT INTO pibNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Kgetwamonuklerunepgi, Giru pixka kgetwamonuklerni Wale. ");
INSERT INTO pibNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Gi gitakyagoklewatanu, gma mutakyagokikotkoxapgi gixa. Gi wa kgiklukanuru nchinanru satu, wa gixa koxa kgiklukanurune gma chinikotkoxapa gixa. Gkaspukinna pimrine, gixa koxa kaspukikalunepgi. ");
INSERT INTO pibNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Geneklewashatanu, ga wa gixa koxa genekashatko. Yagotkaluru pnute, salyatkaluru, yoshkishkitkaluru, yomitachrinatka yine genekangi. Wa yantapi gixa yantajetinri, walako gyantatiko.” ");
INSERT INTO pibNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Satu yapkaklu runkakna. “¿Rumkatge maygaletu kosekletlu maygaletu? ¿Gi ge kapna rumujruukakanna? ");
INSERT INTO pibNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Yimaklechi gi wa tsrunwa yimaklewatachri pnute. Seyni galpokotkaluru yimakjeruko pixka rixanu. ");
INSERT INTO pibNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“¿Klu chinanu petlu kapopejiru pumoleygale gwachri, ga wa puygaleko gwachri kaknalu gi peta? ");
INSERT INTO pibNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","¿Gi pchinru pumole, ‘Gichikaka. Nwanruchi puygale gajeru kapopejiru’? Gi petlu wa puygale gwaknatachri. Sanowashatachriyi. Muchinanu gapka puknokanruchi kaknalu puygale gajeru. Waneklu petpotutanutkalu puknokyaplu pumoleygale gwachri kapopejiru. ");
INSERT INTO pibNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Gi rixanu maleshlu kigleru gagmuna muglejiwletu. Maleshkoxlu mugletu gagmuna kiglejiwleru. ");
INSERT INTO pibNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Gi rixanu gijiya rumatika satkaka gagmuna. Gi rixanu gi wa kawshipiri tjirgika gikersagi. Gi koxa kawshiri tjirgika gowaji. ");
INSERT INTO pibNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Kigleru yineru raji ponikowle kigleru, kiglekakalu koshpakya. Mugletu yineru ponikowle mugletu mugletkaka koshpakya. Gi rixanu gixo potu rajgajeru yanumsatya ginamaya. ");
INSERT INTO pibNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“¿Klu chinanu wane nchinno, ‘Gitsrukaachi, Gitsrukaachi,’ Ga wa gi wa nchinyawakgi gkamruta? ");
INSERT INTO pibNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Girukokta nunyegitjeru, wa ntokanu yijnakotachri ga wa wane rixlu, nekakgitangi giru pixka rixa. ");
INSERT INTO pibNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Jeji pixkalutni kamrupjitachri. Wale jitotlu. Teno rixlu. Sotlumta gogo ruglepokotlu. Rapompotutini wenu, yoshkigamtlu walepji. Gi rumkata kowjewjeretlu, gi rixanu giglepokotikwaka rutaaka. ");
INSERT INTO pibNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Giyagni girukokta yijnakotlu gi wane rixa, jeji pixkalutu kamrupjitachri. Mshikowakanu chiji rutaklu muglepokotikowakanu chiji. Yoshkigamtlu gonu. Waneklu yawnamtanatka. Tsru yawnalu rixana walepji.” ");
INSERT INTO pibNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Wa rali ginkakletinitka pejnuruko tokanu ga wa yine yijnakotlu. Giyagni Kapernawo yatka. ");
INSERT INTO pibNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Satu ksolaloteru wayegreru ralukanru potu yayixyana. Rupnakastsinatkani. ");
INSERT INTO pibNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Yijnakpiranyegitlu Geso. Goteyone tsrutene yokanata Wale yegi. Ragjijixlu rutskalatyaplu wayegreru. ");
INSERT INTO pibNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Rapyegitinitkaluna Geso, ragjipotutluna. Wane chinruna, “Rumukluni wale wane rixikolupa. ");
INSERT INTO pibNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Gi rixanu rushinikanerutwu. Wale kamrupjijixlu wunkaklewawaklepji.” ");
INSERT INTO pibNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Geso wannayma wane ya. Seyni gi gowukatkalu gipji, ksolaloteru yokanyegitlu rumatletanune. Wane chinruna, “Gi pkojwakinwa, Gitsrukaachi. Gi rixanu gi numukluyi wa nopji washrempuko pjiglokinripa. ");
INSERT INTO pibNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Tye chinanu koxa gi wa numukluyi netyayi wa nyayegityapyi. Seyni wane pchintokanushatanu. Nwayegreru gitukanutka. ");
INSERT INTO pibNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Gi rixanu gita koxa jejno tsru gitaakalune rapukote gwachrino. Gita koxa solalone gitakika. Wane nchinru wa tye, ‘Pyanutka.’ Yatka. Satu wane nchina, ‘Punanu,’ Runa. Wane nchinru nwayegreru, ‘Pkamrutanru wa tye,’ Kamrutlu.” ");
INSERT INTO pibNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Geso yijnakotinri, ruglajita waleya. Ruprotakyegitna. Wane chinna gixolune yine romkagitjene, “Galikaka wane nchingi, gi satuna Gisrayiline yegi nukshikyalu tye pixkalutu galixlewlu.” ");
INSERT INTO pibNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Panchi satokinitkana wa yokanatkalune, retatkaluna wayegrechri gitukachritka. ");
INSERT INTO pibNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Wanepnute wane rixatka. Pokchi yatka Nayi chinikowaka. Waleymamnuna yimaklene ga wa gixolune yine. ");
INSERT INTO pibNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Pokchi gipgyaptotestsi rapokinitkana, maleka koshpaaka satu gipnachri satupjerutu toturu runro. Gipnagnurutachroni wala. Gixolune yine pokchi gajene gimotsatlo. ");
INSERT INTO pibNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Wa Gitsrukaachi getinro, retwamonutlo. Wane chinro, “Gi pchiyagatanu.” ");
INSERT INTO pibNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Kayegiklu. Kamruklu ruklugyawakamta. Ranikjene tunwata. Wane china, “Makluji, pixa wane nchina, pyotunotanu.” ");
INSERT INTO pibNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Giyagni tuplata wa gipnapachritka. Yinuwaka yanumsaleta. Giyagni runro renekatkalu. ");
INSERT INTO pibNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Giyagni pejnuruneko pikana. Rumalwutluna Goyakalu. Wane chinna, “Tsru tokanchi geneklewatachri Goyakalunu gipgujewnayegitwu. Goyakalu salwayegitna rayinerutene.” ");
INSERT INTO pibNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Pogiwata tyepirana psolchijnepotuko Gotechijneya ga wa psolusretayako. ");
INSERT INTO pibNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Gwa yimaklene ginkaklu wa pejnuruko Walepirana. Giyagni Gwa tomsatna gepi yimaklene. ");
INSERT INTO pibNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Gitsrukaachi yegi yokanatna. Wane chinjixlu, “¿Pixlege wa ginachripyi, waka satlachi wkagwakanu?” ");
INSERT INTO pibNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Giyagni wa jejine yayegitlu Wale. Wane chinruna, “Gwa Katlewakleru yokanatwu Pixa yegi. Wane chinjixwu, ‘¿Pixlege wa ginachripyi, waka satlachi wkagwakanu?’ ” ");
INSERT INTO pibNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Wale pshinitsonu rutuukakna gixolune ragijewnalkakayna, ga wa salewnakakjerna, ga wa kamchineya. Ga wa gixo maygalene rumrekgakakna. ");
INSERT INTO pibNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Rugita Geso. Wane chinna, “Gajewa. Ginkakapanru Gwa getanrukakaya ga wa gyijnakotanrukakaya: Maygalenenanu getatka. Ga wa myankanenanu yanatka. Ga wa gijirgitunatachine powratkatka. Ga wa majnakonenanu jemashatatka. Ga wa gipnachine yotunkaaka. Ga wa kwamonurune yegi runkakletika Kiglerpotunanu Tokanchi. ");
INSERT INTO pibNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Giglenshinikanyegitkaluru mutspetkatu Gitaya.” ");
INSERT INTO pibNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Wa yinitkana wa Gwatowrene, Geso yinuwaka ginkakletna gixolune yine Gwapirana, “¿Kluneru wa yineru mwiyawakanuwa getapa? ¿Satu katslu kannipgyalu kowshikanrurge? ");
INSERT INTO pibNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Seyni ¿kluneru getapa? ¿Satu jeji popchimkalurege gitakachri? Gi rixanu pogirchinepji rawna wale potu mkachri ga wa popchimkalu gitakachine. ");
INSERT INTO pibNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Seyni ¿klu chinanu wane gya getletapa? ¿Satu tokanchi geneklewatachrirge getapinripa? Gigi, wane nchingi. Tokanchi geneklewatachri pnute. ");
INSERT INTO pibNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Gi rixanu walenwa yonpiranyegitkaluru: Petanu. Gita yokanatlu notowreru Pixa penute. Wale galpokotanru patnugapote Pixa penute. ");
INSERT INTO pibNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","“Gi rixanu wane nchingi, maleshlu satu suxo gishpakyachri Gwa Katlewakleru pnute tsru. Seyni wa mtserutu potu tengogne pogirewatyawakaya tsruni wale pnute.” ");
INSERT INTO pibNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Giyagni pejnuruneko yine ga wa gijgawenutachine yijnakonatlu. Poyagkakachri chinruna Goyakalu, gi rixanu katkana Gwa katlewleya. ");
INSERT INTO pibNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Seyni wa Gwariseyone ga wa yonchikgapine ruknokluna Goyakalu gishinikyawaka wannayako, gi rixanu gi katkana waleya. ");
INSERT INTO pibNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Wane china Gitsrukaachi, “Giyagni ¿giru pixka nutakanna nyi gimuweekakgognenatachine? ¿Kluneru pixka rixna? ");
INSERT INTO pibNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Mturune pixka, giputu tuplanatachine. Tomgakakna. Wane chinna: Wtumlejyegitgi. Gi wa gansata gixa. Wamonuwata gixa yegi. Gi wa nchiyagata. ");
INSERT INTO pibNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","“Gi rixanu runa Gwa Katlewakleru. Gi niklu jimapro. Gi ruuro winga. Wane nchina, ‘Kamchi waneylu.’ ");
INSERT INTO pibNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Nuna Gita Yineru Wgenno. Nikachrino ga wa girachrino. Wane nchina gixa, ‘Getanu. Satu jeji tsru nikalu. Winga kgirakleru. Gijgawenutachine ga wa kmukochirerune gipxaalu.’ ");
INSERT INTO pibNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Wa gimatkalewlu potukalu gekakgitka pejnuruneko wugenene chinanu.” ");
INSERT INTO pibNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Chanixlu satu Gwariseyo waleyma nikinripa. Giyagni Gwariseyopji jigloka. Nikjetikowaka tuplata. ");
INSERT INTO pibNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Wane tixa. Tsru pokchi wanero sato suxo kmukochirewaklero. Tumatinitka wa Gwariseyopji tuplanatini, pastono pgamlugalo tanika. ");
INSERT INTO pibNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Gitjimne twanata gijixistsi. Chiyaganata. Tyinuwaka gigakajixletlu toktegaya. Tojiwutsa tsheyityalu. Tamlujixitlu. Ga wa tuyokgatlu wa pgamlugalo. ");
INSERT INTO pibNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Wa Gwariseyo getinri, wa tomgajeru wane china ginanwakaya, “Goyakalu tokanu geneklewatachri rixkamka wa tye, rumatanmaklo girni wa twu suxo ga wa gi pixkalotni wa kamrukjero. Kmukochirewaklerni.” ");
INSERT INTO pibNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Giyagni rugita Geso. Wane chinru, “Simo. Satu tokanchi naluka ginkakletyi.” Wale gigita, “Wane pchinanu, Yimaklewatachri,” china. ");
INSERT INTO pibNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Wane china Geso, “Satu sroschi marnewatyachri waneylu gepi riwishkatjene. Satu riwishkatlu pamyo pachaproji. Ga wa satu, pamyomoleproji riwishkatlu. ");
INSERT INTO pibNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Maleshayna wa wenutyapluna. Giyagni kaspukyana gepiko. Giyagni ¿giru wa gepi rixinrina gishinikpotutlu?” ");
INSERT INTO pibNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Rugitlu Simo. Wane chinru, “Goo. Wale getko wa gixo potu kaspukikaluru.” Giyagni wane chinru, “Wane potuko pchina gigleta.” ");
INSERT INTO pibNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Reknokyegitlo wa suxo. Wane chinru Simo, “Petlo twu suxo. Njiglokapjityi. Gi penekno gonu nojixi chinanu. Seyni wa twu tugaklu nojixi toktegaya ga wa tojiwutsaya tsheyitlu. ");
INSERT INTO pibNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Gi wa pamlutno. Seyni wa wala njiglokiniyakawa gi tkaspuka gamlujixletno. ");
INSERT INTO pibNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Gi wa ringi puyokjiwutno, seyni wa twu pgamlugalo tuyokjixitno. ");
INSERT INTO pibNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Giyagni wane nchinyi, gixoluru tmukochire tkaspukika. Giyagni tushinikpotutno. Ga wa ptsotsotajiko kaspukikaluru ptsotsotaji rushiniklewata.” ");
INSERT INTO pibNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Wane chinro wala, “Pmukochirkaka pkaspukikatka.” ");
INSERT INTO pibNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Giyagni Waleyma tuplanatachine yinuwaka wane chinanshinikanretna, “¿Gi gixachringe wa Tye, wa mukochri koxa kaspukachri?” ");
INSERT INTO pibNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Giyagni wane chinro suxo, “Palixle gognetkakyi. Pyanutka. Kiglenshinikanpatkayi.” ");
INSERT INTO pibNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Wanepnute wane rixatka. Papokchimnunanuka, tsru pokchi ga wa mturu pokchiya runkaklewananumta. Kiglerpotunanu Tokanchi runkakletananumta Goyakalu pogirewatyawakapirana. Ga wa pamole gepi Waleyma. ");
INSERT INTO pibNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Ga wa pimrone suxone gituukaakalune kamchineya ga wa yayixlukakaya. Mariya wa Maktala gajero chinkaluro. Walaya payokgipre kamchine giknokikaluro. ");
INSERT INTO pibNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Ga wa Gwana, Chosa gnunro, Girore gitakanru, ga wa Sosana, ga wa pimrone gixo. Wanna gipxakna wane rixleyna. ");
INSERT INTO pibNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Gixolune potu yine Waleyma papokchimnunanuka giyakatyachinni. Wale yegi yatkana. Wane china yapkakluya, ");
INSERT INTO pibNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Satu kgitaklewakleru gishpakamta. Kopalajtapa. Kopalajitini, pimriji gatnugapostsi gapokajita. Rakatooka. Ga wa teno yapachine koshichine niklokajitlu. ");
INSERT INTO pibNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Pimriji sotlu gwiywaka gapokajita. Rupcheknimka. Ruprigana gi rixanu gi kgachijiyeginru. ");
INSERT INTO pibNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Pimriji kona yegi gapokajita. Konaymananuko tseruwna. Ga wa kona kapotanatkalu. ");
INSERT INTO pibNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ga wa pimriji kiglewaka chiji rapokajita. Rupchekatka. Jiwatatka. Ruxolewnapotuta.” Wane chininitkalu tyepirana, wane china sapleta, “¡Girukokta kajnakopnalu wa yijnakotinripa, yijnakotanu!” ");
INSERT INTO pibNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Yimaklene gepomgalu klunerni wa tye yapkaklu. ");
INSERT INTO pibNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Wane china, “Gixa geneeka gimatyaplu giyogimanatkaluru Goyakalu pogirewatyawakapirana. Seyni wa pimrine, yapkakluya, Wa retinna ma metkanupna. Ga wa jeminna ma mumatjeminitipna. ");
INSERT INTO pibNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Ga wa tyenwa yapkaklu. Wa kajirujni wa Goyakalu tokanu. ");
INSERT INTO pibNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ga ga wannanwa gatnugapostsi gwachine, wa yijnakotachine. Gowukshini runa tsru kamchi. Rajgajerna tokanchi konanna, ma malixinitipna, ma mognetkakikotupna. ");
INSERT INTO pibNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ga wa sotlu gwiywaka gwachine, wa yijnaktokanutinitkaluna, rumuwleyna yoptotluna tokanchi. Seyni gi wa waneyna gitskina. Wa pshinitsonu galixachinepa, wa yantaletlewlupapko gapokini ruxrikinrina. ");
INSERT INTO pibNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ga wa kona yegi gapokajitachine, wannanwa yijnakotachine. Wa wane yinina, kojwakanshinikanrukaka, ga wa ponikowlu, ga wa meyiwlukaka tye gwashluya kapotlu tokanchi. Gi wa jiwatanatkana. ");
INSERT INTO pibNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ga wa kiglewaka chiji gapokajitachine, wannanwa potukgajirune, kigle gajirune. Yijnakotluna tokanchi. Kamrutluna. Kashnantakgognenatinrina. Jiwatinrina. ");
INSERT INTO pibNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Gike yochpiklo katalo yantapistono yogimatyaplo, waka shechi rapukote rutakyaplo. Seyni wa katalo kgapi tutaako, wa jiglokachine getyaplu tpokamlanu. ");
INSERT INTO pibNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Gi rixanu maleshlu wa yogimatkaluru ma mupgujetikotupa. Gi wa pochkeruko mumatkotupni ga wa mpogijetkotupni. ");
INSERT INTO pibNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Xakoka wa gyijnakotanru. Gi rixanu wa waneyalutu reneeka. Ga wa waneyamigjetu, waneyapgutlu konikona.” ");
INSERT INTO pibNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Runro ginyegitlu ga wa repurune. Gi rumkata gapyegletluna gixo yine chinanu. ");
INSERT INTO pibNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Runkaaka. Wane chinruna, “Punro, pepurune maleka rawna. Raluka getletyina.” ");
INSERT INTO pibNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Giyagni rugitna. Wane chinna, “Nunro ga wa nepurune wannanwa yijnaktokanutlu Goyakalu, ga wa kamrutluna Wale chinyawaka.” ");
INSERT INTO pibNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Wane rixatka pagogne. Sato kanawa rupteka yimakleneyma. Wane chinna, “Tsru wenu wakanute gayanu.” Rutspegatkana. ");
INSERT INTO pibNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Koprugatinikopshinna Wale gimkamta. Ga wa yopyoka tsru kannipgyalu tsru wenuya. Tuygajetlo kanawa. Kyowikolni. ");
INSERT INTO pibNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Yayegitluna Wale. Komyekluna. Wane chinruna, “Gitsrukaachi, Gitsrukaachi, wupnannatka.” Giyagni yotunota. Chigetjetlu kannipgyalu ga wa gishpurga. Rutukatka. Mayegixgataa rixanatka. ");
INSERT INTO pibNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Wane chinna, “¿Ginakatkalu galixle?” Pikanna. Ruglajitanna. Wane chinkakna wannakakluko, “¿Gi gixachrikoxnige wa Tye, wa kannipgyaluymawaka towuta ga wa gonu? Ga wa yijnakotka.” ");
INSERT INTO pibNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Gerasenonechijne rutspakna. Walenwa Kalile wenne wakanute. ");
INSERT INTO pibNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Wa ruptekinitka kanawaya, yoptotaplu satu jeji pokchi gajeru, kamchine waneyalutu. Gowukshini potu mamkatunatka. Gi panchiko rawa, seyni yomlechi rawa. ");
INSERT INTO pibNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Wale getinri Geso, saplewata. Chiji rapokamta Walestsi. Tsruplaji rixa. Wane china saplewleta, “¿Gi pixanutkano Geso, Goyakalu teno potu Gajeru Wgene? Nagjityi gi wa psaletpotutanno.” ");
INSERT INTO pibNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Gi rixanu Wale yokanatatkalu kamchiya wa jeji rushpakinripatka. Gi rixanu gixkatmaka kashichkatka. Rostutka. Yowumatsa rostutikamka. Ga wa supo yoshmakjixitka. Seyni sustonganru yowumatsni. Kamchi yokmentatlu yine mwiyawakanu yinripa. ");
INSERT INTO pibNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Geso gepomgalu, “¿Klu giwakyi?” Wale wane china, “Gixoluru.” Gi rixanu gixo potu kamchine jigloklu wale. ");
INSERT INTO pibNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ragjitluna gitskata potu ma yinitipna. ");
INSERT INTO pibNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Wanenanru magka gixoluru kochi. Nikanatna. Ragjitluna Wale yokanatyapna kamchine kochine jiglokinripna. Giyagni yokanatna. ");
INSERT INTO pibNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Giyagni jeji rushpakamtyatkana kamchine. Kochine jiglokamtatkana. Gixoluru kochi gipjita gijrukya. Tsru wenu rapokanna. Wane ragyekyanna. ");
INSERT INTO pibNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Wa kochine girukotachine, wa retinitkaluna wane rixinitka, rasukamtna. Runkaklewatna tsru pokchiya, ga wa sana gajene koxa. ");
INSERT INTO pibNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Runatkana retapyapluna wane gixachritka. Ga wa Geso yegi yana. Retamtluna wa jeji kamchine gishpakamtinritka. Tuplanatatka wa Gesojixistsi. Kamkatkalu. Kanshinikanutkalu. Pikanna. ");
INSERT INTO pibNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Runkaklewatna wa getanatachine gi rixpoko gigletkotatka wa kamchitpachritka. ");
INSERT INTO pibNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Giyagni pejnuruneko gixolune Gerasenonesreta gajene gagjitlu yinripatka wannayegiya gi rixanu tsru piklu rixanna. Wa Wale kanawa ruptekatka. Satokatka. ");
INSERT INTO pibNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Ga wa wale jeji wa kamchine gishpakinritka ragjitlu Waleyma rixinripatka. Seyni Wale yokanatlu. Wane chinru, ");
INSERT INTO pibNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Psatokanu. Pupji pyanutka. Punkakletanru Goyakalu gixyawakatkayi.” Wale yatka. Psolpokchiko runkakletamtyatkalu Geso gixyawakatkalu. ");
INSERT INTO pibNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Wa Geso satokinitka kigle yoptole rixluna gixolune yine, gi rixanu pejnuruneko kagwakanatlu. ");
INSERT INTO pibNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Rapoka satu jeji Gayro giwakatletachri. Walenwa ginkaklewawakapji gitsrukate. Gesojixistsi yoptsojitamta. Ragjitlu gipji yinripa. ");
INSERT INTO pibNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Gi rixanu waneylu satopjeroto rushicho. Wala pamole gepi walapu waneyatka. Tupnakastsinatkani. Yanananumtiniwa gixolune yine gachpaklu. ");
INSERT INTO pibNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Sato suxo gigragalewatachrona. Pamole gepi walapu gigragalewatachrona. Gixo kpinrewaklerune chinanu tnikatlewatanatka ptowruko walanuko tixinri. Gikena gimkata gituukakletanro. ");
INSERT INTO pibNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Gitjimne tyapamta. Tkamrukamkaptostsitaplu. Wanekluyakawa tutskikagragatatka. ");
INSERT INTO pibNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Giyagni Geso wane china, “¿Katu kamrukapno?” “Goo,” chinna pejnuruneko. Giyagni wane chinna Petro ga wa waleymalune, “Gitsrukaachi, gixolune yine gachpakyi ga wa kachinekyina.” ");
INSERT INTO pibNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Seyni Geso wane china, “Satu kamrukapno. Gi rixanu Gita gimata wa giyaklu gishpakamta Gityegiya.” ");
INSERT INTO pibNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Giyagni wa suxo getnawa gi wa tyogimatnawa, gitatachro gina. Tyoptsojityegitlu. Pejnuruneko getanu tunkakletnawa klu chinanu tkamruklu, ga wa wanekluyakawa tutukinritka. ");
INSERT INTO pibNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Wale wane chinro, “Wiwi, palixle gitskalakyi. Pyanu. Kiglenshinikanpatkayi.” ");
INSERT INTO pibNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Yanumsatiniwa Wale, ginkaklewawakapji gitsrukatepji runya satu. Wane china, “Pshichni tupnanatka. Gi pkojwakanutkalu Yimaklewatachri.” ");
INSERT INTO pibNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Yijnakotinitkalu Geso, rugitlu. Wane chinru, “Gi pumyekanu. Palixashatanu. Ga wa tutskalganu.” ");
INSERT INTO pibNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Panchi yatka. Gi satuna retasha jiglokleta Waleyma, seyni Petro ga wa Gwa ga wa Santiyako, ga wa mturo giru ga wa tunro wannapje. ");
INSERT INTO pibNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Pejnuruneko chiyaganata, ga wa kegeknanuwatna. Wale wane china, “Gi nchiyagatanu. Gi wa tupna seyni tumkanata.” ");
INSERT INTO pibNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Ruxpiranatluna gi rixanu rumatna wa tupninrinatka. ");
INSERT INTO pibNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Ga wa Wale kosemyotlo. Tomgalo. Wane china, “Mturo, pyotunotanutka.” ");
INSERT INTO pibNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Giyagni satokatka tuwekinri. Waneklu tyotunotatka. Renekjixatkalo tnikanru. ");
INSERT INTO pibNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Turune giglajinatachine. Wale gijretna gi satuna ma munkakinitipna wa wane gixkalurutka. ");
INSERT INTO pibNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Tomsatna pamole gepi yimaklene. Renekna giyaklu. Rutaakoxna wa rutuukakyapna satumnunanuka yayixlu, ga wa pejnuruneko kamchine chinanu. ");
INSERT INTO pibNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Yokanatna Goyakalu pogirewatyawaka runkakletinripna, ga wa rutuukaklewatinripna. ");
INSERT INTO pibNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Wane chinna, “Gikena ganikanu wa gatnugapoya, gi wa kanojerchiko, gi wa tsapako, gi wa gnikanruko, gi wa sroschiko, gi wa gepimkaluko ganikanu. ");
INSERT INTO pibNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ginakakokta gjiglokanu satu panchi, wane gwanu, ga wa wane gishpakamtinpotunanuko. ");
INSERT INTO pibNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Wa pejnuruneko wa gma yoptotjenepa, gishpakamtinpatka wa wane pokchiya, giplokjiximtanu gistapjixipagi wa rumatikolupna.” ");
INSERT INTO pibNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Giyagni rushpakamtna. Papokchimnunanuka yana. Runkakletluna Kiglerpotunanu Tokanchi. Pasretamnunanuka rutuukaklewatyana. ");
INSERT INTO pibNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Giyagni Girore pasreta girukotlewatyachri yijnakotinitkalu pejnuruko wane gixkalurutka, gi rumatanshinikanuta, gi rixanu pimrine wane china, “Gwa gipnachinetskalaya yotunomtyatka.” ");
INSERT INTO pibNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Pimrine, “Giliya gipgujewnatka,” china. Ga wa pimrine, “Satu wa tokanchi geneklewatachinni muchikawlurunniyegiya yotunotatka.” ");
INSERT INTO pibNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Wane china Girore, “Gwa nustaknoojixanru. Giyagni ¿katni xani wa tyekaka njempiranyegitanru?” Giyagni raluka getletlu. Satokatkana yokanatanune. Pejnuruko runkakluna wa kamrutanruna. ");
INSERT INTO pibNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Ranikna. Rutspalamta wannayma. Papokchi Wetsayta chinikowaka yana, wanna mkoje. ");
INSERT INTO pibNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Wa rumatinitkana wa gixolune, romkagitluna. Ga wa Wale yoptotna. Goyakalu pogirewatyawakapirana runkakna. Rutuukakna wa galuka pinitkalune. ");
INSERT INTO pibNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Rumxiikastsitkani, pamole gepi yayegitatkalu. Wane chinruna, “Pyokanatanna wa gixolune yine papokchikaka yinripna ga wa sankaka tyesretaya. Wane ruknokakyapluna goyechno. Rukshikanruna nikanrupna. Gi rixanu gewwu wa yineru mwiyawakanu.” ");
INSERT INTO pibNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Wane chinna Geso, “Gixa genekanna wa nikanrupna.” Wane chinruna, “Maleshayanwu. Pamyo jimapropje waneywu, ga wa gepi shima. ¿Waka wixlege yanu wagjitapyaplu niikaluru nyi pejnuruneko yine chinanu?” ");
INSERT INTO pibNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Gi rixanu wanegetkona pamyo waragka jejine. Giyagni wane chinna yimaklene, “Ntuplajixanna paptogkaka pamyomolkaka.” ");
INSERT INTO pibNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Wane rixna. Pejnuruneko tuplata. ");
INSERT INTO pibNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Geso gwalu pamyo jimapro ga wa gepi shima. Tengogne yigata. Ruglenshinikanyegitlu. Wa jiknajrotlu. Renekna yimaklene rutspamtinripna gixolune yine yegi. ");
INSERT INTO pibNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Nikatkana pejnuruneko. Jinanna. Koschekluna gixetachritka psojkaka pamole gepi kojita katsepo, ga wa shima koxa. ");
INSERT INTO pibNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Wane rixatka. Walepje chininitka ragjigogneta. Wanestsi rawna yimaklene. Repomgana. Wane chinna, “¿Wa gixolune yine katu wane chinna Gita nchininri?” ");
INSERT INTO pibNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Wanna gigitlu. Wane chinna, “Gwa Katlewakleru. Pimrine, Giliya. Pimrine, satu Goyakalu tokanu geneklewatachinni muchikawlurunni yotunotyachritka.” ");
INSERT INTO pibNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Ga wa Wale wane chinna, “Ga wa gixa ¿katu wane chinno?” Rugita Petro. Wane chinru, “Goyakalu Kristotyi.” ");
INSERT INTO pibNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Rujretna ma yanumsatinitipna Walepirana gikena. Wane china, ");
INSERT INTO pibNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","“Numkata Gita Yineru Wgenno salewnaleta gixo, nma yoptotikotupa tsruneya, tsrukakalune sasertoteneya, ga wa yonchikgapineya; nuylatikolupa. Nyotunotanu mapagogne rixinri.” ");
INSERT INTO pibNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Geso wane chinna pejnuruneko, “Katukokta galuka gwagajxigletno raalixinwa walenanuko. Pagognemnunanuka rawanro koroshishkitate. Romkagitanno. ");
INSERT INTO pibNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Girukokta galuka gishatkapletlu wa ruwekinri, ruwekinri ramginina. Girukokta gamtakanru ruwekinri Gita chinanu rushatkapanru. ");
INSERT INTO pibNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Gi rixanu ¿klu gaprini wa yineru psolchijikmaka wane rixletanu, seyni ramginina ga wa salewninina? ");
INSERT INTO pibNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Katukokta gipatewatanno ga wa ntokanuya koxa, Gita Yineru Wgenkoxno gipatewatanru wale wa nuninipa natajiwnaleyma ga wa Nurunu, ga wa kpashirine Goyakalutowrerunenuyma. ");
INSERT INTO pibNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Galikaka wane nchingi, pimrine gewi gwachine gi wa getumganru gipnalu ma metkanuwalunachi Goyakalu pogirewatyawaka.” ");
INSERT INTO pibNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Wane rixatka. Rali chinretokanuta. Wanepnute yokgipgogne giknoginitka, ranikna Petro ga wa Gwa ga wa Santiyako. Magka kanikna, ragjigognetapa. ");
INSERT INTO pibNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Wane rixa. Ragjigognenatini satuko kogetkogatka. Ga wa gimkalu klatalu, katajiru. ");
INSERT INTO pibNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Waneklu gepi jejine giynumsatlu Wale. Wannanwa Moysisi ga wa Giliya. ");
INSERT INTO pibNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Goyaknu rumupgujewnana. Rupnalepapirana ruynumsatna, wa Gerosaleya poyagkakanrupa. ");
INSERT INTO pibNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Ga wa Petro ga wa waleymalune ruxapnewpotutanna. Wa ruyokanatinna retluna royaknu ga wa gepi jejine Waleyma tunwanatachine. ");
INSERT INTO pibNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Wane rixatka. Rutspalyegimtinitkaluna, Petro wane chinru wa Geso, “Gitsrukaachi, kigleru gewi gawinri. Wkamrutanru mapa gimajechri. Pixanupa satu, Moysisinupa satu, wa Giliyanupa satu.” Gi rumatanshinikanutinna Petroni wa wane chininri. ");
INSERT INTO pibNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Tyekaka wane chinanatiniwa, runa kyachgapererumko. Wale chikletyegitna. Pikanna wa kyachgapererumko jiglokamtininna. ");
INSERT INTO pibNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Waneylu tokanchi kyachgapererumkoya, wane chinachri, “Tyenwa Noturu ntsomitanru. Wale gyijnakotanu.” ");
INSERT INTO pibNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Wa tokanuwninitka, Gesopje retatkana. Ruchrokanna. Walegognekaka gi satuna runkakna wa retanruyna. ");
INSERT INTO pibNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Wane rixatka. Waleprikgogne magka yopikinitkana, gixolune potu yine yoptotaplu. ");
INSERT INTO pibNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Waneru satu jeji wa gixolune yineymalutu. Saplewata. Wane china, “Yimaklewatachri, nagjityi noturu petinripa. Satupjerutu noturni. ");
INSERT INTO pibNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Petanru. Kamchi kashjetanru. Walegnapunanu saplewjejetana. Shipchojtakakjetanru. Ratpotposolnamjetana. Gi raluka kaspukletmaklu. Saletjetanru. ");
INSERT INTO pibNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Nagjitna pyimaklene maleka ruknokyapluna. Gi rumkatluna.” ");
INSERT INTO pibNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Rugita Geso. Wane china, “¡Ya nyi gimuweekakgognenatachine malixkane, mpotukane! ¿Gi pejnugognenanukta numwanutkagi? ¿Gi pejnugognenanukta nakotyagi? Panikanru puturu gewi.” ");
INSERT INTO pibNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Ranikiniwalu, kamchi yotkakanru. Shipchojtakakpotutanru. Ga wa Geso chigetjetlu kamchi puchotlewatachri. Rutuukaklu mturu. Ruru renekatkalu. ");
INSERT INTO pibNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Pejnurunniko giglajitana gi rixanu retluna tsru potu kamrutanrukaka Goyakalu. Ga wa ruglajinatinna pejnuruneko wa pejnuruko kamrutanruya, wane chinna yimaklene, ");
INSERT INTO pibNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Tyepirankaka gajnakokpotutanu gixa. Gi rixanu Gita Yineru Wgenno samyookalurupno yinemyoya.” ");
INSERT INTO pibNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Seyni wanna gi rumata jemlewatanna tye tokanchi. Wannaya yogimatkaluru ma mumata jemyanupluna wanna. Pika gepomgaletluna tye tokanchiya. ");
INSERT INTO pibNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Giyagni rugjekakna girni wa wanna tsrupotu. ");
INSERT INTO pibNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Giyagni Geso gimatlu wa yanshinikanutanruna rajiyna. Koscheklu satu mturu. Walestsi tunwakaklu. ");
INSERT INTO pibNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Wane chinna, “Girukta yoptotlu satu tye pixkalutu mturu, Gita giwakaya, Gita yoptota. Girukta yoptotno nyokanatjeru yoptota. Gi rixanu wa mturu potu gixa yegi, walenwa tsru potu.” ");
INSERT INTO pibNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Giyagni rugita Gwa. Wane chinru, “Gitsrukaachi, wetlu satu wa pgiwakaya ruknokyana maleka kamchine. Wujretlu gi rixanu gi romkagitwu wixa.” ");
INSERT INTO pibNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Geso wane chinru, “Gi wa gijretanru. Gi rixanu wma kamnixjetni wixasretni wale.” ");
INSERT INTO pibNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Wane rixatka. Wa poyagkakastsitkalu gigogne wa teno ranikolpatka muchkotanshinikanutnawa Gerosale yinripa. ");
INSERT INTO pibNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Yokanatna gepi ginkaklewatachinepa Wale penute. Yatkana. Samarya gajene pokchi rapokna wa ralpokotyapluna Wale chinanu. ");
INSERT INTO pibNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Gi yoptotluna gi rixanu Gerosalesreta yigata. ");
INSERT INTO pibNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Retinitkaluna yimaklene Gakowo ga wa Gwa, wane chinna, “Gitsrukaachi, ¿gi ge paluklu wtowutyaplu xirnachri gijrukanu tengogneya, nikatyapna?” ");
INSERT INTO pibNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Giyagni Geso satkapyegitna. Chigetjetna. ");
INSERT INTO pibNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Papokchi yatkana. ");
INSERT INTO pibNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Gatnugapo yapamtini, satu wane chinru, “Nomkagitanyi ginakakta pyanu.” ");
INSERT INTO pibNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Geso wane chinru, “Kewnechrone waneyna kapna. Ga wa koshichine tengogne yapachine waneyna rawyawakna. Ga wa Gita Yineru Wgenno maleshayno nutspanjiwutyawaka.” ");
INSERT INTO pibNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Wane chinru satu, “Pomkagitanno.” Ga wa wale wane china, “Gitsrukaachi, puchichanno muchinanu gapkachi wane nyanu. Nuruchi nkapnamtanu.” ");
INSERT INTO pibNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Giyagni wane chinru, “Gipnachinni. Giyagni petashatanna wannananukni gipnachine kapnatikolupa wannaya. Ga wa pixa pyanu. Punkakletananumtanru Goyakalu pogirewatyawakapirana.” ");
INSERT INTO pibNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Giyagni satu koxa wane china, “Nomkagitanyi, Gitsrukaachi. Seyni petashgapkatanno nungiyapna nopji gajene.” ");
INSERT INTO pibNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Geso wane chinru, “Girukokta tsru jitlolopagipi kashichachritka, gi wa rajxigiyaka reknoka. Waneko pixka rixmaka satu nkamrurewyegitjeru; wa yinuwaka gikamrurewletno ga wa rajxigiyaka reknoka, gi rumukluni Goyakalu pogirewatyawaka kamrurewatinripa.” ");
INSERT INTO pibNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Wanepnute Gitsrukaachi yokgijtatna pimrine payokgipremole. Wanna yokanata gepkaka Wale penute psolpokchikakako ginakakta rushinika yaleta. ");
INSERT INTO pibNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Wane chinna, “Galikakni gixlu jirgakalurupa. Seyni wa kamrurewaklerune gi gixna. Giyagni gagjitanru jirgakalurupa Gitsrukate jirgalyegipa yokanatyapna kamrurewaklerune. ");
INSERT INTO pibNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Gajewa. Gita yokanatgi gowegane pixka kewetnanetskala. ");
INSERT INTO pibNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Gi wa sroschigapimapa ganikanu, gi wa tsapako, gi wa yoshmakjixreko. Gi satuna galukamtanu gatnugapoya. ");
INSERT INTO pibNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","“Girupjikokta gjiglokinipa, muchinanu gapka wane nchinanu, ‘Giglewanshinikanrewlu wanepa tyepji.’ ");
INSERT INTO pibNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ga wa wane rawanatini satu giglewanshinikanrewlu wgene, gixa giglewanshinikanre wale yegi rawanu. Ga wa malesha chinini, satokanu gixa yegi. ");
INSERT INTO pibNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Walepjiko gwanu. Wane gnikini. Wane girini klunerukta waneyna wanna. Gi rixanu wa kamrurewakleru rumkata yoptoletlu kamrure gipekole. Gi wa papjimnu gyanu. ");
INSERT INTO pibNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Girpokchikokta gapokinipa ga wa gyoptotko, gnikanru klunerukokta gitspakikolupa. ");
INSERT INTO pibNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Wane gwachine yayixachine gituukakanu. Wane nchinanna, ‘Kayegikatkagi gixa Goyakalu pogirewatyawaka.’ ");
INSERT INTO pibNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","“Giru pokchikokta gapokinipa, gma yoptotkoklunupa, wanepji gishpakamtinitka, pokchi gapka gyanu. Wane nchinanu, ");
INSERT INTO pibNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Gixa pokchichijnepagi wupxakjixitjeru gixa yegi wsheyitanru. Seyni wa tye gimatanu, wa kayegikmakatkagi gixa Goyakalu pogirewatyawaka.’ ");
INSERT INTO pibNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Seyni gixa wane nchina, wa gakotkalurupa Sotomachijne gajenniya wale pokchi gajene pnute wa walegognepatka. ");
INSERT INTO pibNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“¡Gi waneni pixa Korasi Pokchi! ¡Gi waneni pixa Wetsayta! Gi rixanu Tiroya ga wa Sitoya wanepmaklu giyaklewlu wa gixa yegi wane gixikaluru, muchikawamka renshinikanutanmakna kawshistugalu mkachri gitakachine, ga wa chichipagi tuplanatachine. ");
INSERT INTO pibNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Seyni gakotkalurupa Tiro ga wa Sito gajenniya gixa pnute wa giklukanuwnalgognepatka. ");
INSERT INTO pibNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ga wa pixa, Kapernawo, tengognepotunanuko pixka putaaka. Ga wa gipnachine gwiywakpotunanuko pixka putaako. ");
INSERT INTO pibNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Wa gixa nyokanatanune yijnakotachine, Gita yijnakotna. Ga wa gixa giknokachine, Gita ruknokna. Ga wa Gita giknokachine, nyokanatjeru ruknokna.” ");
INSERT INTO pibNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Satokatkana payokgipremolene. Gimuwatachine. Wane chinna, “Gitsrukaachi, kamchineko yijnakotwu wixa pgiwakaya.” ");
INSERT INTO pibNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Geso wane chinna, “Gita getlu Satanasyo rawrakle pixka tengogne gijrukyachri. ");
INSERT INTO pibNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Nutakatkagi gakatsretyapna gimnune ga wa geklone, ga wa geyikyaplu pejnuruko kamnixlewatachri giyakle. Gike gimtukangi. ");
INSERT INTO pibNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Seyni gi wa gimuwatanu wa tyeya wa kamchine yijnakotyagi, seyni gimuwatanu tengogne gitakgiwakatikolutka.” ");
INSERT INTO pibNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Waneklu koxa rumuwpotuta Giwekikaluru Kpashiriya. Wane china, “Numalwutyi, Nuru, tengogne Gitsrukate ga wa chiji Gitsrukate. Gi rixanu tyekaka pyogimatyana kgimatkalerune ga wa kanshinikanerune. Ga wa mturune pupgujetyana. Gigi, Nuru, gi rixanu palukyawakni. ");
INSERT INTO pibNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","“Ptowrunanuka Nuru genekyano. Gike gimatlu girni wa Gituru seyni Girchipje gimatlu. Gike gimatlu girni wa Girchi, seyni Giturupje gimatlu ga wa katukta koxa Gituru galuka gimatkakletlu.” ");
INSERT INTO pibNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Yimaklene yegi ruprotaka, wannapje rixinna. Wane china, “Katukta getlu wa gixaygale getanru, giglenshinikanyegitkalurni waleygale. ");
INSERT INTO pibNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Gi rixanu wane nchingi wa gixo Goyakalu tokanu geneklewatachinni ga wa pogirchinni galuka getletmaklu wa gixa getanrutka. Gi wa retluna. Raluka yijnakletmakluna wa gixa yijnakotanrutka. Gi wa yijnakotluna.” ");
INSERT INTO pibNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Wane rixaka. Satu yonchikgapri palna rumlukanutyaplu. Wane chinru, “Gitsrukaachi, ¿klu nkamrutanu wa nuwekgognenatinripa?” ");
INSERT INTO pibNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Wale wane chinru, “¿Gi china yongata wa Tokanchi Yokanatkaluru? ¿Gi pixpoko getyongaletlu?” ");
INSERT INTO pibNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Wale gigita. Wane china, “Pushinikanru Gitsrukaachi Poyakalute psolpotuyako pajiya, psolpotuyako punshinikanuya, psolpotuyako pmuchkonuya, psolpotuyako pushinikanutletanruya. Pushinikanru pumole pixnanuko pixka.” ");
INSERT INTO pibNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Geso wane chinru, “Wane potuko pchina gigleta. Wane pixanu ga wa puwekanu.” ");
INSERT INTO pibNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Walemka galuka muklukanuwnakatu chinretnawa. Wane chinru Geso, “¿Katni wa nomole?” ");
INSERT INTO pibNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Rugita Geso. Wane chinru, “Satu jeji Gerosale yopikyachri Geriko yachripa kachowgurune yegi rapokana. Komkaganruna. Ruylakanruna. Yatkana. Rupnakastsinatkani ruknokamtatkaluna. ");
INSERT INTO pibNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Ma kagwakamtyawakanu wane rixatka. Satu sasertote walegapo yopikya. Retamtanru. Pasreta yapamta. Ruknogamtlu. ");
INSERT INTO pibNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Waneko pixka rixa satu Rewiklopisha. Wane rapokamta. Retamtanru. Pasreta ruknogamta koxa wale. ");
INSERT INTO pibNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Seyni satu Samarya gajeru, yagapotachri gapyegitatnaklu. Retlu. Retwamonutlu. ");
INSERT INTO pibNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Wale yegi ya. Poyitlu gitre. Ruyoklu ringi ga wa winga. Gipratji rutakatkalu. Pnu giyakatyachine gwajetyawaka ranikatkalu. Girukotlu. ");
INSERT INTO pibNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Waleprika gepiproji koshpaka. Reneklu wa kapjiru. Wane chinru, ‘Pgirukotanru. Klunerukta wanepnute pwenutyalu, wa nsatokinipa nsatkakinyi gita.’ ");
INSERT INTO pibNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","“¿Giru pkagwaka pixa wa mapa chininrinwa gimole wa kachowgurune yegi yachrini?” ");
INSERT INTO pibNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Wale wane china, “Wa retwamonutjeru.” Giyagni Geso wane chinru, “Pyanu. Waneko pixka pixanu pixa.” ");
INSERT INTO pibNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Wa wane yinitkana, satu pokchi yatkana. Sato suxo Marta giwakatletachro topji tyoptotyalu. ");
INSERT INTO pibNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Wala waneya wa tepuro. Mariya giwakatletachro. Gitsrukaachijixistsi tuplata. Tyijnaktokanutlu. ");
INSERT INTO pibNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Giyagni Marta shiretanshinikanuta gixo tkamrureya. Tapyegitlu. Wane china, “Gitsrukaachi, ¿gike pixa Pixa wa tuknokamtanno nepuro, gitapje nkamrurewatanatka? Giyagni punkakanro tupxakapyapno.” ");
INSERT INTO pibNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Gitsrukaachi gigitlo. Wane chinro, “Marta, Marta, kojwakanshinikanutachroyi, mumatanshinikanutkatyi gixo chinanu. Satupje galuukaluru. ");
INSERT INTO pibNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Ga wa Mariya kigleru tsomita walanupa. Gi wa tkoniko.” ");
INSERT INTO pibNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Wane rixatka. Wane ragjigognetya. Rali gagjigogneretini, satu yimakleru wane chinru, “Gitsrukaachi, pyimaka gagjigogneretanwu, wa Gwa pixka yimaklene yimaka.” ");
INSERT INTO pibNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Wane chinna, “Wa gagjigognetinipa, wane nchinanu: Wuru, gipashichgiwakatkalurupyi. Runanutka Pixa pogirewatyawaka. ");
INSERT INTO pibNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Penekanwu xawakni wnikanrupa tyegogne chinanupa. ");
INSERT INTO pibNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Pkaspukinwu wmukochire, wixa pixka wkaspukyana pejnuruneko wriwishkatjene. Gi wa yantaletikowakako putakanwu.” ");
INSERT INTO pibNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Wane koxa chinna, “¿Gi gixpokota gixa wa satu gimatanru gapyegitingi ganikajyechno? Wane chinangi, ‘Nomole, mapa jimaprochi penekanno. ");
INSERT INTO pibNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Gi rixanu satu numatanru, pnu kyakleru, ginyegitno. Maleshayno nenekyaplu.’ ");
INSERT INTO pibNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","“Gitokmaka gigitinri. Wane nchinanmaka, ‘Gi pkojwakanno. Gipgyapto rushyatka. Gitaymana mturune shechi. Gi numkata tunreta nenekyapyi.’ ");
INSERT INTO pibNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","“Wane nchingi gixa, gimka gyotunotanu wa genekyaplu gimatatkalchinanru. Seyni gma mapatewatinitipa chinanu gyotunota. Genekanru psoluko ralukanru. ");
INSERT INTO pibNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Gita wane chingi, gagjitanu ga wa geneeko. Gijganu ga wa gikshikanu. Giylaylagipgyaptotetanu. Gkotpukyegitko. ");
INSERT INTO pibNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Gi rixanu girukokta gagjita, yoptota. Ga wa gijgachri rukshika. Ga wa giylaylagipgyaptotetachri kotpukyegitko. ");
INSERT INTO pibNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Ga wa gixa ¿satu girchi wa gituru gagjitinri jimapro renekanru sotlu? ¿Ga wa shima ragjitini, gimnurge renekanru? ");
INSERT INTO pibNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","¿Ga wa tonaji ragjitini, geklorge renekanru? ");
INSERT INTO pibNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Giyagni wa gixa muglenmakgi gimata genekawgeneta kigleru genekashle, pnutlu Giru tengogne Gajeru Giwekikaluru Kpashiri renekanna ragjitjene.” ");
INSERT INTO pibNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Maleka ruknokamtlu kamchi. Myanumatkatni. Wane rixatka. Maleka rushpakatka kamchi, wa myanumatkatunanu yanumatatka. Giyagni gixolune yine giglajita. ");
INSERT INTO pibNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Pimrine wanna wane china, “Kamchine gitsrukate Welsewoyma ruknokna kamchine maleka.” ");
INSERT INTO pibNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Pimrine gimlukanutlu. Ragjitluna Geso rekakgityapna getkaluru Goyakalu kamrutanru. ");
INSERT INTO pibNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Geso gimatanshinikanutanna wanna. Wane china, “Pejnuruko pogirewatikwaka wa wane gajene kotspalanshinikankakmaka wannakakluko, nikawnana pogirewatikwakna. Pejnuruko panchi, wa wane gajene kotspalanshinikankakmaka wannakakluko, maleshpatkalu. ");
INSERT INTO pibNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ga wa Satanasyo walenanuko kotspalkakanshinikanutinmakwa, ¿gi rixpoko gwagogneretanu wale pogirewatyawaka? Gi rixanu gixa wane china wa Welsewo giyakleya maleka nuknokna kamchine. ");
INSERT INTO pibNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ga wa Gita Welsewo giyakleyamka maleka nuknokanna kamchine, ¿katu giyakleyamka maleka ruknokna gwugenene? Giyagni gwugenenepni gixa gitakyagokjenepa. ");
INSERT INTO pibNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ga wa Goyakalumyojiya Gita maleka giknokinna kamchine, galikakni wane rixa gapkapletgi Goyakalu pogirewatyawaka. ");
INSERT INTO pibNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Wa gichkolu kashreru girukotinri gipji, kigle gwashleru wane rixle. ");
INSERT INTO pibNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Seyni satu wale pnute muchkonurutu gapyegitinri, raalixanru, konyanru kashri raponshinikanutanrunanu. Rushankiyanru rejnunkakate. ");
INSERT INTO pibNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Wa yineru Gitasreta mwakatu walenwa nkamnixjeru. Gitayma mapatkatu, kotspalewata. ");
INSERT INTO pibNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Kamchi puchotlewatachri yineru rushpakamtinitka pnumnu yapanata, popriwaakaka. Rujgalu rapnanutyawakapa. Gi wa rukshiklu. Giyagni wane china, ‘Nsatokanutka nopji nuyakatyawaka.’ ");
INSERT INTO pibNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","“Wane rapokinitka rukshiklu saxritkaluru ga wa galpokotkaluru. ");
INSERT INTO pibNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Giyagni wane ya. Waleyma ranikna pimrine payokgipre kamchine wale pnuterune muglene. Jiglokna. Wane rawna. Ralipretka gektutu giknogatkalu tye jeji muchinanu pnute.” ");
INSERT INTO pibNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Wane rixatka. Wa tyepirana runkakletanatini sato suxo gixolune yine yegi tsaplewata. Wane china, “Giglenshinikanyegitkalurni wugenewlumapa pwanatyawaka, ga wa tnuchi pashichyawaka.” ");
INSERT INTO pibNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Wale wane china, “Wanna galikakni giglenshinikanyegitkalune wa Goyakalu tokanu yijnakotachine ga wa kamrutachine.” ");
INSERT INTO pibNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Rapatjetna gixolune yine. Yinuwaka wane chinreta, “Nyi gimuweekakgognenatachine muglenni getkaluru rujgana. Seyni getkaluru gi wa reneekona, seyni Gonasu tokanchi geneklewatachri getikolupje. ");
INSERT INTO pibNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Gi rixanu wa Gonasu pixka walenwa getkaluru Niniwe gajenyegiya, waneko pixka nixa Gita Yineru Wgenno nyi gimuweekakgognenatachinyegiya. ");
INSERT INTO pibNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Giklukanuwnalgognepa tyotunotanu tkachi kegnetesretate gajerni pogirewatachroni wa jejine nyi gimuweekakgognenatachineyma. Tuklukanuwnakakanna, gi rixanu yoptukyawakchijiko tunya tyijnakotyaplu Salomo gimatkalewle. Ga wa gewru Salomo pnuterutu. ");
INSERT INTO pibNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Giklukanuwnalgognepa jejinni, Niniwe gajenni, yotunotanu nyi gimuweekakgognenatachineyma. Wannani giklukanuwnakakanna nyi gimuweekakgognenatachine. Gi rixanu wannani genshinikanuta Gonasu ginkaklewle chinanu. Ga wa getanru gewru Gonasu pnuterutu. ");
INSERT INTO pibNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Gike yochpiklo katalo yogimatyaplo, gi wa yantapistono rapukote rutakyaplo. Seyni wa katalo kgapi tutaako, wa jiglokachine getyaplu tpokamlanu. ");
INSERT INTO pibNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Pumane katalote walenwa puygale. Giyagni potukaygale pixinipa, psoluko pumane pokamlapa. Seyni puygale mugletu rixinipa, psoluko pumane mapshagalupni. ");
INSERT INTO pibNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Giyagni pgirukotinwa wa pokamlalu pixa gwachri ma muchpokinitipa. ");
INSERT INTO pibNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Giyagni psoluko pumane pokamlatyawaka rixini, maleshni mapshagasretwaka, psoluko pokamlawatyawakni, katalo pixka rixa gatajiwnaletanu pixa yegi.” ");
INSERT INTO pibNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Wa yanumsatinitka, satu Gwariseyo gagjitlu rumnikyaplu. Giyagni jiglokamta. Nikjetyawaka tuplata. ");
INSERT INTO pibNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Ga wa Gwariseyo retinri, ruglajita gi rixanu gi wa reromyogapkata wa nikinipa. ");
INSERT INTO pibNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Giyagni wa Gitsrukaachi wane chinru, “Gixni wa Gwariseyongi mpowratlu kolpeto rogote ga wa kajpapago rogote, seyni wa gixa gitokote katseplu makotnachinwa ga wa muglenchi. ");
INSERT INTO pibNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Mshinikanungi. ¿Wa rogote kamrutachri gi ge gitoko koxa kamruta? ");
INSERT INTO pibNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Seyni gishiniklewle geneklewashatini, ga wa getanu, ptowruko powrayapgi. ");
INSERT INTO pibNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Seyni ¡gi wanengi gixa Gwariseyongi! Gi rixanu pamolete gwenutyalu pgamlusureru, ga wa rotasure, ga wa pejnuruko giputu gitaakaluru, seyni Goyakalu poyagkaklewle ga wa rushiniklewle giknogashamta. Tyekaka gimkata kamrureta. Gi wa pimri koxa giknogashamtanu. ");
INSERT INTO pibNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“¡Gi wanengi gixa Gwariseyongi! Gi rixanu galuklu tsrukakalune tuplapijere ginkaklewwakapji gajerkaka. Galuklu giputuya galukikolu. ");
INSERT INTO pibNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","¡Gi wanengi gixa! Kapna pixkalungi, metapnatkotu, ga wa yine rogo yapanatna. Gi rumatna.” ");
INSERT INTO pibNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Giyagni wa satu yonchikgapri gigita. Wane chinru, “Yimaklewatachri, wa wane pchininri, wixa koxa gektutu pchina.” ");
INSERT INTO pibNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Wale wane china, “¡Gi wanengi gixa koxa yonchikgapingi! Gi rixanu gitjikakna yine kyapre ganiikolu. Ga wa gixa gi wa pamyojiko gijtukyalu gitjitkalurkaka. ");
INSERT INTO pibNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“¡Gi wanengi gixa! Gi rixanu gixa kamrutlu wa Goyakalu tokanu geneklewatachinni kapnatikowaka. Ga wa gitsrukatenni giylatanna. ");
INSERT INTO pibNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Giyagni gixni wa gipgujtatnachinwagi gigleretlu wa gitsrukatenni kamrutanru. Gi rixanu wanna giylatanna, ga wa gixa kamrutlu giyomlena. ");
INSERT INTO pibNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Giyagkoxni rumatkalewleya Goyakalu tokanu wane china, ‘Nyokanyegitanna wanna ntokanu geneklewatachine ga wa nyokanatanune. Pimrinepni ruylatanna. Ga wa pimrinepni kojwakanna.’ ");
INSERT INTO pibNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","“Nyi gimuweekakgognenatachine gepomsatko wa pejnurunniko Goyakalu tokanu geneklewatachinnigraga chinanu, gipkaakalurugraga, rekamrutikowaka tye psolchijneko ga wa xangognenanu. ");
INSERT INTO pibNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Rugitanna pejnurunniko chinanu, wa Gawiligragakluyakawa ga wa Sakariyagragaklupotunanuko, wa giylatkaluru kpashiwakpotugruko ga wa yochpikikowakakwa ganikajiteswa. Gigi. Nyi gimuweekakgognenatachine gepomsatko wale chinanupa. ");
INSERT INTO pibNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“¡Gi waneni gixa yonchikgapingi! Gi rixanu gixa konru wa gimatyawaka kotpukapre. Gi wa gixako jigloka. Ga wa jiglokachinmaka gimaleta.” ");
INSERT INTO pibNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Wa Geso wane gishpakamtinitka, wa yonchikgapine ga wa Gwariseyone yinuwaka tsru jgekanchi gixleta. Gixopirana repomsatluna. ");
INSERT INTO pibNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Rutsekletmakluna, wa kashtokanutyapluna wa yanumsatinri. ");
INSERT INTO pibNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Wa rapatinitkana gixolune yine, gixo waragkane, wane rixa gakatookakletna. Muchinanu gapka Geso yinuwaka giynumsaletna yimaklene, “Ggirukotinwa wa gisekachri, walenwa sanowashlena, wa Gwariseyonenu. ");
INSERT INTO pibNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Gi rixanu maleshlu wa gishyatkaluru ma mupgujetikotupa. Gi wa pochkeruko gi wa mumatkotupni. ");
INSERT INTO pibNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Klunerukokta wa mapshagwaka nchintokanutinri, pokamlawaka jemiko. Klunerukokta gitokogruko potu gixaxa nchintokanutinri, panchi gogote runkakletiko. ");
INSERT INTO pibNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Ga wa wane nchingi, numatanune, gi mpikanna manchi giylatachine. Ga wa wanepnute gike rumkata kamruretatkana. ");
INSERT INTO pibNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Seyni nekakgitangi katu mpikanu. Wale mpikanu, wa kgiyaklewakleru wa rali giylaletinitkagi Gigena xirnachri ruknokyapgi. Gigi, wane nchingi, Goyakalu mpikanu. ");
INSERT INTO pibNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","¿Gi ge wa ganikajproji chinanu rushankaaka pamyo koshichi? Ga wa gi satuna wanna gimuslawatka Goyakalu getanu. ");
INSERT INTO pibNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Seyni gijiwutsako pejnuruko yantatkalurni. Giyagni gi mpikanu. Kiglepotgi gixa gixo koshichine pnute. ");
INSERT INTO pibNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Wane nchingi, girukokta gipgujtatno yine getanu, Gita Yineru Wgenkoxno gipgujtatanru wale Goyakalutowrerune getanu. ");
INSERT INTO pibNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Wa nnutatjeru yine getanuya, Goyakalutowrerune getanu nutatkalurupni. ");
INSERT INTO pibNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Girukokta gapatno Gita Yineru Wgenno kaspukikalurupni. Seyni girukokta mupashiregnuchi chinru Giwekikaluru Kpashiri gi wa kaspukiko. ");
INSERT INTO pibNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Wa ginkaklewawakapjikaka gwapikoklunupa, ga wa tsrukakalune ga wa tsru gitaakalune yegi, gi wa gkojwakanshinikanutinwa gi gixpoko giykoyegletinwa ga wa nchinyawakapa. ");
INSERT INTO pibNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Gi rixanu Giwekikaluru Kpashiri waneklupapko ginkakangi wa gimkata chinretyawakapa.” ");
INSERT INTO pibNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Wane chinru satu gixolune yine yegi, “Yimaklewatachri, wane pchinanru nyegwaklu wa kotspalatininno yoptotanrupa.” ");
INSERT INTO pibNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Ga wa Wale wane chinru, “Jeji, ¿katu gitakno gitakyagokachri ga wa kotspaltatachri nixinripa gixa chinanu?” ");
INSERT INTO pibNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Wane chinna, “Getinwa. Psolpotuyako ggirukotinwa gixo gejnu galukachine gma mixinitipa. Gi rixanu gi wa gixo rejnunkate gigletlu yineru gwashle.” ");
INSERT INTO pibNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Yapkaklu runkakna. Wane chinna, “Satu jeji ponikolchijne gixo potu rawyalu. ");
INSERT INTO pibNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Wale gishinikanuwata ginanwakaya. Wane china, ‘¿Gi nixanutka? Gi rixanu maleshayatkano nutakyaplu njirganru.’ ");
INSERT INTO pibNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","“Wane china, ‘Wane nixanu. Nugnantakyawaakaka nkoshganu. Tsrupotu nixanutkalu. Wane nutakanru pejnuruko ntrikoteji ga wa wane nixle. ");
INSERT INTO pibNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Wane nchininwa gitnanuko, Gixo wane nixle waneyatkano gignantaakaluru gixo walapu chinanupa. Napnanutanutka. Nnikanu. Nuranu. Numjikanu.’ ");
INSERT INTO pibNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","“Goyakalu wane chinru, ‘Mshinikanutyi. Tyeyechno kashichko puwekinri. ¿Ga wa palpokotanru katunpatkani?’ ");
INSERT INTO pibNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","“Wane rixa ponikolewlu gapotachri, seyni wa Goyakaluya gi wa ponikolni.” ");
INSERT INTO pibNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Geso wane chinna yimaklene, “Giyagni wane nchingi, gi gkojwakanshinikanutanu giwekinriya, klu gnikanuna. Gi koxa gimaneya, klu gmakatanu. ");
INSERT INTO pibNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Gi rixanu giweklu wa niikaluru pnutni wale, ga wa manchinwa gitaakaluru pnutni wale. ");
INSERT INTO pibNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Getpotutanna pokotune mutaklewatkanni. Gi jirgana. Maleshayna rapotyawakagrukna, gi wa rugnantakyawakagrukokna. Ga wa Goyakalu goglutna. ¡Gi psonanukta kigleygi gixa koshichine pnute! ");
INSERT INTO pibNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","¿Katu gixa gimkata yognikletlu pshinitsonuji ruwekinriya kojwakanshinikanrewleya? ");
INSERT INTO pibNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Giyagni gi gimkata wa mturu potu kamruretini, ¿klu chinanu koxa wanepnute gkojwakanshinikanutnawa? ");
INSERT INTO pibNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Getjetanru kagwuru, gi rixpoko tseruwnaleta. Gi kamrurewpotuta. Gi jiweta. Seyni wane nchingi gi wa Salomoko psolpogirewleyako makawata satu tye gwukaka pixka. ");
INSERT INTO pibNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Ga wa Goyakalu wane gixa makatletinri kshana xawakni gwachri, yechikawa xirnachri ruknookonatka ¿gi ge wale pnute makatangi gixa, ptsotsotaji galixachingi? ");
INSERT INTO pibNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Ga wa gixa gi gijganru klu gnikanu, ga wa klu giranu. Gi gkojwakanshinikanutinwa. ");
INSERT INTO pibNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Gi rixanu payine tye psolchijneko gajene pejnuruko tyekaka rujgana. Ga wa Giru tengogne Gajeru gimatlu tyekaka galukanru. ");
INSERT INTO pibNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Seyni muchinanu gapka gijganru Goyakalu pogirewatyawaka, ga wa Wale poyagkaklewle. Pejnuruko tyekaka koxa waneyapgi. ");
INSERT INTO pibNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Gi mpikanu muxone gowegane gapatachingi. Gi rixanu gixa Giru gigleretlu pogirewatyawaka renekyapgi. ");
INSERT INTO pibNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Gishankanru wane gixle. Kwamonurune genekashatanu. Wane gixanu wa gixa ponikolewle gignantakikowaakakapa tengogne gajerupa mutsrunkatupa, mnikawnakatupa, kachowguru ma mapokyawakanupa, gi wa kochopako gimtuklewatyawakapa. ");
INSERT INTO pibNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Gi rixanu ginakaktaplu mponikowle wanekoxaplu gaji. ");
INSERT INTO pibNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Giyagni galpokmanetinwa, waneyapgi gkatalote yochpiikaluro. ");
INSERT INTO pibNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Ga wa gixa jejine pixkalunepgi, wa rutsrukatna kagwakachine, giklu kashimyolu yegi rushpakini rutsrukatna. Wa runinipa ga wa ruylaylagipgyaptotetinipa, giyampotu kotpukyegityapluna. ");
INSERT INTO pibNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Giglenshinikanyegitkalunepni wanna wayegrechine wa runinipa rutsrukatna giyokanatachine rukshikinipa. Galikakni wane nchingi, wa ralpokotinwa. Tuplajixanna. Ga wa wale gipxakanna. ");
INSERT INTO pibNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Goprikmaka runinipa ga wa gogistsi runinipmaka ga wa retamtanna wane gixanatachine, giglenshinikanyegitkalunepni wanna. ");
INSERT INTO pibNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Seyni gimatanru wa tye: wa kwangixlerupji gimatkamka gipapko runanu wa kachowguru, gimka retasha kotamgaletikolupa wa gipji. ");
INSERT INTO pibNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Giyagni gixa koxa gali galpokletachinepgi, gi rixanu gma kagwakinpapko Gita Yineru Wgenno ginanu.” ");
INSERT INTO pibNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Giyagni Petro wane chinru, “Gitsrukaachi ¿tye yapkaklu wixapiranrege pchina, waka pejnurunekopiranra?” ");
INSERT INTO pibNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Gitsrukaachi wane china, “Giyagni ¿katni wa girukotapjitachri poyagkakachri ga wa kanshinikanuru, wa rutsrukate gitakanru wa gipji kamrurewatyachine chinanu, wa renekyapna nikanruna kyagolu niklupapkokaka? ");
INSERT INTO pibNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Giglenshinikanyegitkalurni wa wale wayegrechri, wa rutsrukate ginini retamtlu wane gixanatachri. ");
INSERT INTO pibNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Galikakni wane nchingi, pejnuruko wane rixle chinanu rutakanru. ");
INSERT INTO pibNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Ga wa wale wayegrechri wane chinmaka rajiya, ‘Ramga ginreta nutsrukate.’ Yinuwaka giylakletletna wayegrechine ga wa wayegrechrone; nika ga wa rura gimetachineyma. ");
INSERT INTO pibNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Wale wayegrechri gitsrukate ginanu. Ma kagwakgognetinitgogne runanu. Ma mumatinpapko runanu. Kochipjepotutanru. Malixkane yoptotanruymapa rutakanru walenupa. ");
INSERT INTO pibNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Wa wale wayegrechri wa rutsrukate gishinikanru gimatachri seyni gi wa ralpokota, gi wa rushinikyawaka kamruta, gixo kata ruylaakona. ");
INSERT INTO pibNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Seyni wa mumatkatu girukokta kamruta wale rumupgotka, gi gixo kata potu ruylaako. Wa girukokta gixo reneeka, gixo koxa rujgiko. Wa gixo gitakikaluru, gixo ragjitanruna. ");
INSERT INTO pibNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Nuna tye psolchijneko nutakyaplu xirnachri. ¡Gi pagaluklenanukta nixlu wa yochpikikolpatka! ");
INSERT INTO pibNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Katlewlu waneyno nkatikolupa. ¡Gi pagerutkonanukta nixka ma poyagkaakanukopshini! ");
INSERT INTO pibNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","¿Gkagwakluge wa tyechijne nuninri kigle gwashle nenekyapna tye psolchijne gajeneko? Wane nchingi, gike. Seyni kotspalkakikolu galikakni. ");
INSERT INTO pibNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Gi rixanu xaniyakawa wanepna pamyo papji gajene kotspalanshinikankakachinepa. Mapa kamnixanna gepi, ga wa gepi kamnixanna mapa. ");
INSERT INTO pibNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Girchi kamnixanru gituru, ga wa gituru kamnixanru ruru. Ga wa ginrochi kamnixanro tshicho, ga wa tshicho kamnixanro tunro. Ga wa gimajichro kamnixanro tomekanunro, ga wa mekanunrochi kamnixanro tgimajiro.” ");
INSERT INTO pibNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Wane chinkoxna gixolune yine, “Wa kyachgapererumko getini wa tkachi gimxityawakasreta ruyakatini, waneklu wane nchina, ‘Ginpatkani.’ Ga wa wane rixa. ");
INSERT INTO pibNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ga wa tkachi kegnetesretate giyakannipgyatyachri rapokannipgyatini, wane nchina, ‘Gemerpatkani.’ Wane rixa. ");
INSERT INTO pibNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","¡Sanowashatachingi! Gimata getgogneretlu chiji ga wa tengogne. ¿Gi gixpoko gi gimata getletlu tyepapkopirana? ");
INSERT INTO pibNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“¿Klu chinanu gixnanuko gi gitakyagoklu wa potukalu? ");
INSERT INTO pibNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Wa pkamnixjeruyma gitsrukaachi yegi pyini, pujgapotutanru pkaspukikolupa walyegiya, ma kotlolomtyanupyi kgitakyagoklewakleru yegi. Ga wa kgitakyagoklewakleru ma samyookanpakyi gitowreru yegi. Ga wa gitowreru ma yoshmakyanupyi yoshmakjetikowaka. ");
INSERT INTO pibNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Wane nchinyi, gi wane pushpakini pma wenutkanuwalo talipremchataajpotunanuko.” ");
INSERT INTO pibNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Walgogne koxa wanena pimrine. Runkakluna Kalile gajenepirana, wa wannagraga Pilato yapjetjixlu renekashlekakna giylatkalurkakagraga. ");
INSERT INTO pibNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Geso gigita. Wane chinna, “¿Gkagwakluge wa nyi Kalile gajene kmukochirewaklerune pejnuruneko Kalile gajene pnute gi rixanu wane rixa salewnaletna? ");
INSERT INTO pibNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Wane nchingi, gike. Seyni gma menshinikanutkanu gixa, pejnurunekgi waneko pixka gixa giylatkotanuna. ");
INSERT INTO pibNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Ga wa wanna pamole yokgipi, wa Silowe gajeru tenopjiru yawnayegitanune. Ruylatanna. ¿Gkagwakluge wa wanna magatya wa pejnuruneko yine Gerosale gajene pnute? ");
INSERT INTO pibNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Wane nchingi, gike. Seyni gma menshinikanutkanu gixa, pejnurunekgi waneko pixka gixa giylatkotanuna.” ");
INSERT INTO pibNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Wane china tye yapkaklu, “Satu waneylu gikeramuna rusanate gowasha gitaakaluro. Wane ya rujgasantaplo. Gi rukshiksagitlo. ");
INSERT INTO pibNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Wane chinru gowasha girukotachri, ‘Petanro. Mapa walapu nuna. Nujgasagjetlo wa twu gikera. Gi nukshiksagitlo. Pustakaganro. ¿Klu chinanu tumaletashatatkalu chiji?’ ");
INSERT INTO pibNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","“Wale gigita. Wane chinru, ‘Gitsrukaachi, tye walapuchi petashatanro. Wa nyopagiskotanrochi ga wa npojitaskotanrochi. ");
INSERT INTO pibNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Tsagiwatinipa, kigleru. Ga wa wane tma mixkanupa, pustakjixaganutkalo.’ ” ");
INSERT INTO pibNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Satu ginkaklewawakapji gapnanutikalurgogne runkaklewatya Geso. ");
INSERT INTO pibNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Wanenanro sato suxo kamchi yayixkaklewatachri waneyaluto. Pamole yokgipi walapu tyayixa. Satpokachroni. Giketsotaji tumkata potukawletyana. ");
INSERT INTO pibNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Wa Geso getinro, tomgalo. Wane chinro, “Suxo, pkaspukikatka pyayixinriya.” ");
INSERT INTO pibNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Rutakamyogogotlo. Waneklu tpotukawamtatka. Tumalwutlu Goyakalu. ");
INSERT INTO pibNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Giyagni ginkaklewwakapji gitsrukate gimtuwna gi rixanu Geso gapnanutikalurgogne pinrewata. Rugita ginkaklewwakapji gitsrukate. Wane chinna wa gixolune yine, “Waneru patsrujirgogne rumkata kamrurewatikolu. Giyagni walegognekaka ginanu mpinitikolupa. Gi wa gapnanutikalurgogneko.” ");
INSERT INTO pibNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Giyagni Gitsrukaachi Geso gigita. Wane china, “¡Sanowashatachingi! ¿Gi ge satkakgi gixa wa gapnanutikalurgogne goglujetyawakna gkoshpirokyana gwakate ga wa mporote gipra? Ganiklu rurapinripa. ");
INSERT INTO pibNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ga wa twu Gawraklopisha, getanro, wa Satanasyo gostutanrona pamole yokgipi walapu, ¿gi ge tumkata koshpirookotana wa tye tostutikolu wa gapnanutikalurgogneko?” ");
INSERT INTO pibNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Wa wane chininitka, pejnuruneko patewatana kamnixjene. Ga wa pejnuruneko gixolune yine gimjika wa pejnurkakayako Wale kamrutanru gimalwutkaluru. ");
INSERT INTO pibNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Giyagni wane china Geso, “¿Kluneru pixka rixa Goyakalu pogirewatyawaka? ¿Giru pixka nutakanru? ");
INSERT INTO pibNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Mostasaji pixka rixa. Satu jeji ganiklo. Rusanate rutaklo. Tseruwna. Gagmuna tixnawa. Giyagni tenyapachine koshichine gina. Walaplu shalewatna.” ");
INSERT INTO pibNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Wane chinatnaka, “¿Giru pixka nutakanru Goyakalu pogirewatyawaka? ");
INSERT INTO pibNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Gisekachri pixka rixa. Sato suxo gwalu. Gepimole masu yaglu trikopagi tyapjetlu, psoluko gisekinpotunanuko.” ");
INSERT INTO pibNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Papokchimnu yapananumta. Tsru pokchi, mturu pokchi runkaklewananumtya. Gerosale rushinika. ");
INSERT INTO pibNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Satu wane chinru, “Gitsrukaachi, ¿gi gixo potu gognetkaako?” Wale wane chinna, ");
INSERT INTO pibNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Gyagota jiglokletanru mtsergipgyaptotetu, gi rixanu wane nchingi, gixo gijga jiglokletanu. Gi rumkatanruna. ");
INSERT INTO pibNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Wa kwangixlerupji palninpatka, rushyatanutkalu gipgyapto, gyinuwaka maleka gwaletanuna. Giylaylagipgyaptotetanuna. “Wane nchinanuna, ‘Gitsrukaachi, Gitsrukaachi, pkotpukyegitanunwu.’ “Ga wa rugitanu. Wane chinanu, ‘Gi numatgi, ginaka giyakatyachinektagi.’ ");
INSERT INTO pibNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","“Giyagni gyinuwaka wane chinretanu, ‘Pixa getanu wnikanata ga wa wuranata. Ga wa wuputreya punkaklewatya.’ ");
INSERT INTO pibNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","“Wane chintokanyegitangi, ‘Gi numatgi ginaka giyakatyachinektagi. Gitspalatinno gixa pejnurunekgi mpoyagkaknuchi kamrurewatyachingi.’ ");
INSERT INTO pibNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","“Waneplu chiyaglu ga wa gashkaygitlu, wa Goyakalu pogirewatyawaka gixa geta tuplaletanna Gawra, ga wa Gisaaka, ga wa Gakowo, ga wa pejnuruneko Goyakalu tokanu geneklewatachine, ga wa gixapni maleka giknookona. ");
INSERT INTO pibNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Runanna tkachi gishpatyawakasreta gajene, ga wa tkachi gimxityawakasreta gajene, ga wa tkachi potuklesretate gajene, ga wa tkachi kegnetesretate gajene. Goyakalu pogirewatyawaka tuplatanna nikjetikowakaya. ");
INSERT INTO pibNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Ga wa wanena kaptotachine. Wannapni muchichachinpatka. Ga wa muchichachinenanu wannapni kaptotachinpatka.” ");
INSERT INTO pibNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Walgogne koxa yayegitluna pimrine Gwariseyone. Wane chinruna Geso, “Pasukanutka. Pyanutka gewiya. Gi rixanu Girore galuka giylaletyi.” ");
INSERT INTO pibNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Wale wane chinna, “Gajewa. Ginkakapanru wale kewnechro pixkalutu, ‘Petanu. Maleka nuknokna kamchine ga wa nutuukaklewata xawakni ga wa yechikawa. Ga wa yechikawapnutgogne, nali kamruretanu. ");
INSERT INTO pibNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Seyni wa xawakni ga wa yechikawa ga wa yechikawpnutgogne numkata yaleta, gi rixanu Goyakalu tokanu geneklewatachri gi gimkata gipnaleta Gerosale mwakatu.’ ");
INSERT INTO pibNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“¡Gerosale, Gerosale! Goyakalu tokanu geneklewatachinni giylatachriyi. Ga wa pyokanyegitjenni sotlujetachriyi. ¡Gi pejnu katananukta naluka gapatjewgenretyi gaxawripa pixka tapatjewgeneta! Tomejimpuko tutakna. Ga wa pixa gi galuklu. ");
INSERT INTO pibNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Giyagni gipji giknokamtkalurupni gixa chinanu. Gi rixanu wane nchingi, xaniyakawa gi getanutkano wa gixa wane chininpotunanuko: Giglenshinikanyegitkalurni Gitsrukaachi giwaka ginyachri.” ");
INSERT INTO pibNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Wane rixatka Geso. Satu gitsrukaachi Gwariseyopji jigloka gapnanutikalurgogne nikinripa. Giruktatluna. ");
INSERT INTO pibNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Waneru satu jeji gankajetachri Wale yegi. ");
INSERT INTO pibNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Yonchikgapine ga wa Gwariseyone wane china Geso, “¿Ginanshichkalurege wa gapnanutikalurgogne gituukaklewlu waka gike?” ");
INSERT INTO pibNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Wanna pochke. Giyagni Wale kosetlu. Rutuukaklu. Yokanatatkalu. ");
INSERT INTO pibNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Wane chinna Wale, “¿Giru jeji wane gixa yegi, wa gituru ga wa mporote wa kapna rujrukinna, gi ge koschekanna waneklu wa gapnanutikalurgogneko?” ");
INSERT INTO pibNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Gi rumkata yoptopiiretluna wa tyepiranaya. ");
INSERT INTO pibNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Retanatna wa tsrukakalune tuplapijere tsomityawakna nikjetikowakaya. Chanixkalune runkaka satu yapkaklu. Wane chinna, ");
INSERT INTO pibNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Wa satu chanixinipyi kashimyolu yegi, gi wa tsrukakalune tuplapijere ptuplatanu. Patako gonra satu kagwakpiratkaluru wa pixa pnute chanixkaluru waleya. ");
INSERT INTO pibNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Ga wa yayegitinipyi nchanixjeru pixa ga wa wale, wane chininipyi, ‘Penektuplapijeretanru tye.’ Giyagni patewatachriyi pyinuwaka gimuteru potu tuplapijere tuplaleta. ");
INSERT INTO pibNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","“Seyni wa pchanixkoklunupa, wane pyanu. Gimuteru potu tuplapijere ptuplatanu, wa runinipa wa pchanixjeru, wane chininipyi, ‘Nomole, kiglewaka pyanu.’ Waneklu gimalwutkalurupyi wa pejnuruneko pumnikjenyegiya. ");
INSERT INTO pibNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Gi rixanu girukokta wa tsru gitaknachriwa mturu rutaako wale. Ga wa mturu gitaknachriwa tsru rutaako wale.” ");
INSERT INTO pibNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Wane koxa chinru wa chanixjeru, “Wa niikaluru pkamrutini ga wa tsru nachnewlu, gi pchanixanna pumatanune, gi wa pumunanwakaneko, gi wa pumoleneko, gi wa pumwastsitanune ponikoluneko, wanna ma mupeko chanixletyanupyi, pma mapnutikotupa. ");
INSERT INTO pibNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Wa nachnewlu pkamrutinipa pixa, pchanixanna kwamonurune, mastsine, yokmatachine, ga wa maygalene. ");
INSERT INTO pibNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Ga wa giglenshinikanyegitkalurupyi, gi rixanu maleshayna rapnutyapyina. Seyni yotunkoklunupna poyagkakachine, waneklu gapnutkalurupyi.” ");
INSERT INTO pibNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Satu rumnikjeru yijnakonatlu tyepirana. Wane chinru, “Giglenshinikanyegitkalunepni wa Goyakalu pogirewatyawaka nikyachinepa.” ");
INSERT INTO pibNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Wale wane chinru, “Satu jeji tsru nachnewlu kamruta. Gixo chanixa. ");
INSERT INTO pibNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Nachnewlupapko chininitka, yokanatlu wayegreru, runkakapyapna chanixkalune, ‘Ginanutka. Gi rixanu pejnuruko galpokotkalurutkani.’ ");
INSERT INTO pibNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","“Pejnuruneko pixkakaklu rixanshinikanutna. Yinuwaka gaalirewletna. Muchinanu chanixkaluru wane china, ‘Nagjitatkalu chiji. Numkata wane yaleta, netapyaplu. Nagjityi petashjixa yaletanno.’ ");
INSERT INTO pibNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","“Satu wane china, ‘Pamole wakane nagjita gepirinkaka. Nyantatapanna. Nagjityi petashjixa yaletanno.’ ");
INSERT INTO pibNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","“Satu wane china, ‘Nganunrowatatka. Giyagni gi numkata wane yaleta.’ ");
INSERT INTO pibNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Satokatka wayegrechri. Walepirana runkaklu rutsrukate. Giyagni rumtuwna kwangixlerupji. Wane chinru wayegreru, ‘Giyampotu tsru pokchiputu pyanu ga wa gatnugapkaka. Pwapanna gewi kwamonurune, ga wa mastsine, ga wa maygalene, ga wa yokmatachine.’ ");
INSERT INTO pibNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","“Wane china wayegrechri, ‘Gitsrukaachi, wane gixkalurutkani wa pchinyawaka, ga wa kaswajiwalu.’ ");
INSERT INTO pibNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","“Giyagni gitsrukaachi wane chinru wayegrechri, ‘Gatnugapo pyanu ga wa prijertamnu. Pertapanna jiglokinripna, tsepowninripa nopji. ");
INSERT INTO pibNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Gi rixanu wane nchingi, gi satuna wa nyi jejine wa chanixkalune getumganru wa nnijitu.’ ” ");
INSERT INTO pibNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Gixolune yine Waleymamnuna. Ruprotakyegitna. Wane chinna, ");
INSERT INTO pibNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Girukokta ginyegitinipno ga wa ma mayegixkanuplu ruru, gi wa runroko, ga wa ganunroko, ga wa wugeneneko, ga wa gimoleneko, ga wa gimoleroneko, ga wa ruwekleko, gi rumkata nyimakleru gixleta. ");
INSERT INTO pibNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Girukokta gi gwalo koroshishkitate, gi wa Gita gajxigi rawa, gi rumkata nyimakleru gixleta. ");
INSERT INTO pibNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Gi rixanu wa satu gixa yegi galuka tenopjiru kamruretachri, ¿gi ge muchinanu gapka tuplanatanu ga wa rutakyagokwenutanru, gikta waneylu wa nikatyaplu? ");
INSERT INTO pibNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Rawiyawakapa tenopjiru ralpokoshata, gi rumkata nikatletinripa wane ma mixinitipa, pejnuruneko getachine ma yinuwaka gixpiranatletyapluna. Wane chinna, ");
INSERT INTO pibNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","‘Tye jeji yinuwakasha kamruretlu panchi. Gi rumkata nikatletlu.’ ");
INSERT INTO pibNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Ga wa pogirchi giylalu yegi yachri satu pogirchi yoptotachripa, ¿gi ge muchinanu gapka tuplatanu jemanshinikanrewatachri rixinripa gikta rumkata pamole waragkayma yoptoletlu wa gepmole waragka waneyalutu wa runyegitjerupa? ");
INSERT INTO pibNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ga wa ma mumkatkanru, wajra rawiniwa pogirchi runyegitjeru, yokanatna tsrune, repomgiyapluna rawashletnapirana. ");
INSERT INTO pibNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Giyagni waneko pixka rixa. Girukokta gixa gma kaspuukanru wa pejnuruko wa wane gixle gi rumkata nyimakleru gixleta. ");
INSERT INTO pibNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Kiglerni wa tuwu. Seyni wa mushi rixinitka tuwu ¿kluneru morotkatka? ");
INSERT INTO pibNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Gi wa chijiko pojitikolu kigleylu, seyni maleka giknookalurutkani. “Girukokta kajnakopnalu wa yijnakotinripa, yijnakotanu.” ");
INSERT INTO pibNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Yayegitluna pejnuruneko gijgawenutachine ga wa kmukochirerune yijnakotyapluna. ");
INSERT INTO pibNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Kegemgana Gwariseyone ga wa yonchikgapine. Wane chinna, “Wa Tye kmukochirerune yoptota. Ga wa wannayma nika.” ");
INSERT INTO pibNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Giyagni Wale ginkakna tye yapkaklu. Wane chinna, ");
INSERT INTO pibNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Satu jeji wa gixa yegi satu pacha gowega waneyalutu, sato gamgini ¿gi ge yineru mwiyawakanu ruknokamtna wa mturujmole mturuji ga wa gamgachro chinanu wane ya rukshikinpotunanuko? ");
INSERT INTO pibNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Rukshikinro, rutjimtatkalo gimuwatachri. ");
INSERT INTO pibNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Gipji rapokinitka tomgana rumatanune ga wa rumwastsitanune. Wane chinna, ‘Gimumuwatanno. Gi rixanu nukshikatkalo nowegate gamganatachro.’ ");
INSERT INTO pibNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Wane nchingi, wa tengogne waneplu tsru potu gimuwlu wa satupje kmukochireru renshinikanutinri chinanu, mturujmole mturuji poyagkakachine chinanu pnute, genshinikanru mmagatikane. ");
INSERT INTO pibNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Ga wa sato suxo pamoleproji waneyaloto, wa paproji tamgini ¿gi ge tyochpiklo katalo, ga wa tsaxritlu panchi, ga wa tujgapotutlo tukshikinpotunanuklo? ");
INSERT INTO pibNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Wa tukshikinitkalo, waneklu tunkakna tumatanune ga wa tumwastsitanune. Wane chinna, ‘Gimumuwatanno. Gi rixanu nukshikatkalo gamganatachro nserojiproji.’ ");
INSERT INTO pibNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","“Wane nchingi, waneko pixka rixa. Waneplu gimuwlu Goyakalu towrerunyegiya wa satupje kmukochireru chinanu renshinikanutini.” ");
INSERT INTO pibNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Wane china, “Gepi wgenru satu jeji. ");
INSERT INTO pibNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Mturu wane chinru ruru, ‘Papaa, penekanno wane wixle psojite wa gitanu nixinripa.’ “Giyagni kotspalatyatkana wane rixlena. ");
INSERT INTO pibNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","“Gi gixgogne potu giknoginitka, gituru mturu gwatkalo pejnuroko. Wajrachijne yatka. Wane saletyalo wane rixle mgirukotnachriwa. ");
INSERT INTO pibNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Wa pejnuroko nikatininatka, rapoka tsru nachi walechijne. Yinuwaka magletyanatka. ");
INSERT INTO pibNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Wane ya. Rupxaklu satu walechijne gajeru. Wale yokanatlu peklomtate yegi kochine roglutinripa. ");
INSERT INTO pibNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Raluka ginanuwkakletnawa galkarowajiya wa kochine nikanru. Gikena genekanru. ");
INSERT INTO pibNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Ga wa rushinikanuwpotutinitka, wane china, ‘¡Gi pejnunanukta nuru yegi kamrurewatyachine gixetlu niikaluru! Ga wa gitni gewi nachi kamakatininno. ");
INSERT INTO pibNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Npalnamtanutka. Nuru yegi nyanutka. Wane nchinanru, “Papaa, tengogne getanu nmukochirewata ga wa pixa getanu. ");
INSERT INTO pibNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Gi wa numuklutkani wa puturu nchinikolpatka. Satu pkamrurewyegitjeru pixkakanutkano.” ’ ");
INSERT INTO pibNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","“Giyagni palnamta. Yayegitlu ruru. Ga wa ruru gowukako retyalu. Retwamonutlu. Rasukyegitlu. Kanopatlu ga wa ramlutlu. ");
INSERT INTO pibNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Giyagni wa gituru wane chinru, ‘Papaa, tengogne getanu nmukochirewata ga wa pixa getanu. Gi wa numuklutkani wa puturu nchinikolpatka. Satu pkamrurewyegitjeru pixkakanutkano.’ ");
INSERT INTO pibNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","“Giyagni ruru wane chinna wayegrene, ‘Giyampotu gwapanru wale potu mkachri. Gyoshmakanru. Yoshmakamyojrechi genekanru. Gyoshmakjixitanru yoshmakjixrechi. ");
INSERT INTO pibNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Waka wgene gwapanu gixowaakaakaluru. Giylatanru. Wnachnewatanu. Wmeyiwatanu. ");
INSERT INTO pibNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Gi rixanu tye noturu gipnachrinanni. Ruwekamtatka. Gamgachrinanu ga wa rukshiikatka.’ Yinuwaka meyiwletna. ");
INSERT INTO pibNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Ga wa tsru gituru sanananru. Wa panchistsi rapokinitka, yijnakotlo gitlotkalurkaka ga wa gansalu. ");
INSERT INTO pibNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Satu wayegrechri tomga. Repomgalu klunerni. ");
INSERT INTO pibNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Wale wane chinru, ‘Pepuru gapokatka, ga wa puru waka wgenni gixowaakaakalurni giylajixa. Gi rixanu gichkolu yoptotlu.’ ");
INSERT INTO pibNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Giyagni yegwaklu gimtuwna. Gi raluka jiglokleta. Rushpakamta ruru rumnanukyaplu. ");
INSERT INTO pibNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Giyagni wale gigita. Wane chinru ruru, ‘Papa, ¡gi pejnu walapunanukta pwayegreru nixnawa! Gi pagogneko nkaspuklu pyokanatyano. Gi pagogneko penekno chiwo wgene numatanune numeyiwatinripa. ");
INSERT INTO pibNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Seyni wa tye puturu wa pnikata wane gixletjeru suxone kjejigeroneya, wa runinitka, puylatlu waka wgenpotuko gixowaakaakaluru wale chinanu.’ ");
INSERT INTO pibNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Giyagni wale wane chinru, ‘Noturu, pixa gimwagognenatno. Pejnuruko wane nixle pixanni. ");
INSERT INTO pibNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Giyagni wumkata meyiwleta ga wa gimuwleta wa pepuru chinanu. Gi rixanu tye pepuru gipnachri pixkalutunanni, ga wa ruwekatka. Gamganatachrini ga wa gikshiikalurutkani.’ ” ");
INSERT INTO pibNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Geso wane chinkoxna yimaklene, “Waneru satu jeji ponikolu. Waneylu gipji girukotachri. Wa wale jigyegitkalurni waleyegiya, wa saletlu wane rixle. ");
INSERT INTO pibNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Giyagni tomgalu. Wane chinru, ‘¿Klunerni wa tye wa nyijnakyegityawakyi? Puglepokotanru pgirukotanru kwentate. Gi rixanu gi pumkata girukowletatka.’ ");
INSERT INTO pibNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Giyagni girukowatachri wane china gitoknanwakaya, ‘¿Klu nkamrutanu? Gi rixanu nutsrukate giknokanno ngirukowatinriya. Gi numkata jitleta. Npatewata sroschi nagjityapmaka. ");
INSERT INTO pibNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Numatatka klu nkamrutanu wa nushpakinipa ngirukowatinri, wannapji yoptotinipnona.’ ");
INSERT INTO pibNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Giyagni tomgana satkaka rutsrukate riwishkatachri. Wane chinru muchinanu gapokachri, ‘¿Gi pejnu priwishkatlu nutsrukate?’ ");
INSERT INTO pibNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","“Wale wane china, ‘Gepkoxamkoje waragka pamyo pachaksu ringi.’ “Giyagni wane chinru, ‘Ga ga pkwentate. Ptuplatanu. Giyampotu pyonatanru gepi waragka gepi pacha pamyomoleksu ringi.’ ");
INSERT INTO pibNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","“Satu wane chinatnaka, ‘¿Ga wa pixa? ¿Gi pejnu priwishkata?’ “Wale wane china, ‘Satpacha shiwate trikoji.’ “Giyagni wane chinru, ‘Ga ga pkwentate. Yokgipmole pyonatinri.’ ");
INSERT INTO pibNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Ralixkotlu gitsrukaachi wa girukowatachri mpoyagkaakatu, gi rixanu kgimatkaleru rixa. Gi rixanu tyegogne gajene wa wanna gimuweekakgognenatachineklusha kgimatkalerune rixna pokamlawaka gajene pnute. ");
INSERT INTO pibNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Gita wane chingi, wane gixa gimatletkakanna gyokwireya, wa sroschi yoptotinripna. Wane pixini gnikawnagognenatini, waneklu wanna yoptotangi Gigena rawiyawakapna gike rixiniko mnikawnakatupa. ");
INSERT INTO pibNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Girukokta poyagkakachri ptsotsotaji chinanu, gixo koxa chinanu poyagkakanu. Ga wa mpoyagkaakatu ptsotsotaji chinanu, gixo koxa chinanu gi poyagkakanu. ");
INSERT INTO pibNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Giyagkoxni wa mugletu ponikolewleya gi wa poyagkakachingi, ¿katu gaponshinikanutangi wa galikaka potu ponikolewluya? ");
INSERT INTO pibNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Wa pimrine wane gixleya mpoyagkaakane gixini, ¿katu genekangi gixanupa? ");
INSERT INTO pibNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Gi satuna gimkata panchi kamrurewatya gepi gitsrukaachinyegiya, gi rixanu waka rayegixanru satu, satu rushinikanu; waka satu rupxaletanu, satu reyikanu. Gi gimkata wayegrechri gixleta Goyakalu chinanu ga wa ponikowlu chinanu.” ");
INSERT INTO pibNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Ga wa Gwariseyone sroschi galukachine potu yijnakonatlu pejnuruko Walepirana. Ruxpiranatluna Wale. ");
INSERT INTO pibNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Wane chinna Wale, “Gixni wa gixnanuko poyagkakachine gixashatnawa wa yine getanuya. Seyni wa Goyakalu gimatgajitgi. Gi rixanu wa kiglepotlu yine getanuya, walenwa gagnanutkaluru Goyakalu getanu. ");
INSERT INTO pibNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Tokanchi Yokanatkaluru ga wa Goyakalu tokanu geneklewatachine waneyanangi Gwaklupotunanuko. Wanekluyakawa runkakletka Goyakalu pogirewatyawakapirana. Pejnuruneko muchkowyegitlu. ");
INSERT INTO pibNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Myapretpotni tengogne nikawninripa ga wa psolchijneko, wa satu yotmokle pnute nikawninripa Tokanchi Yokanatkaluruya. ");
INSERT INTO pibNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Girukokta giknoklo ganunro ga wa sato ganunrotatnaka, rumopatlewjixatka. Ga wa girukta ganunrotlo wa jeji giknokanro rumopatlewata. ");
INSERT INTO pibNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Waneru satu jeji ponikolu. Pakni yoshmookaluru pixkalutu mkachri ga wa wale potu klatalu mkachri gitakachri. Pagognemnunanuka meyiwlu ponikpoturu rutaka. ");
INSERT INTO pibNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Satu kwamonuru, Lasaro giwakatletachri, rupgyaptotestsi rutaaka. Katreru. ");
INSERT INTO pibNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Raluka ginanuwleta ponikolu nikjetyawaka gijrukyachriya. Kewene koxa gina. Ga wa remrotretluna. ");
INSERT INTO pibNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Wane rixatka. Rupnana kwamonurni. Goyakalutowrene ganikatkalu. Gawrasta rutakluna. Rupnana koxa ponikolni. Kapnatkana. ");
INSERT INTO pibNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Ga wa gipnachine gwiywaka salewnapotutinri, wane yigatya. Wajra retyalu Gawra, ga wa Lasaro walesta gwanatachritka. ");
INSERT INTO pibNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Giyagni wale saplewpotuta. Wane china, ‘¡Papa Gawra, petwamonutanno! Lasaro pyokanyegitanno, gonu rugakaptomyojimtanu. Ruyalkapannutanunno. Gi rixanu tye xirnachri nsalewnapotutyanatka.’ ");
INSERT INTO pibNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Gawra wane china, ‘Wiwi, pushinkapanru wa puwekanatini pyoptojenatanru kigleru wane pixle. Ga wa Lasaro koxa gektutu yoptojenatanru. Giyagni wa xani gewi gimnanukikalurni wale, ga wa pixa salewnagognenatachripatkayi. ");
INSERT INTO pibNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ga wa tyekaka pejnuruko pnute, wixa ga wa gixa ganikajite rawgognenatyawaka tsru gitskata. Giyagni wixa yegi galuka kopruretachine gixa yegi rixinripmakna, gi rumkatluna. Ga wa wane gajeneko gi gimkata koprureta wa wixa yegi rixinripmakna.’ ");
INSERT INTO pibNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Giyagni wane china, ‘Xani koxa nagjityi, papa. Nurupji pyokanatanru wale. ");
INSERT INTO pibNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Gi rixanu waneyno pamyo nomolene. Rupgujtayegityapna wale, wa gewi tye salewnikowaka ma muninitipkoxna wanna.’ ");
INSERT INTO pibNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Ga wa Gawra wane china, ‘Wanna waneya Moysisi kirukate ga wa Goyakalu tokanu geneklewatachine. Wanna yijnakotanna.’ ");
INSERT INTO pibNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“Giyagni wale wane china, ‘Gike, papa Gawra, seyni satu gipnachinyegiya yayegitinna, renshinikanutanna.’ ");
INSERT INTO pibNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","“Ga wa Gawra wane chinru, ‘Ma yijnakotkanruna Moysisi ga wa Goyakalu tokanu geneklewatachine, gi koxa rushinikanutkona wa satu gipnachinetskalaya yotunotini.’ ” ");
INSERT INTO pibNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Wane chinna yimaklene, “Gi rumkata gimaletkota wa gitspetkalurkaka chininripa. Seyni ¡gi waneni girukokta jijruklu yineru! ");
INSERT INTO pibNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Kiglemkalu waleya rushriknojitikolupa wa tsru sotlu ginripiya, tsru wenu ruknokikolupa, wanepnute wa tye satu mturpotu jijrukinri. ");
INSERT INTO pibNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","“Gixnanuko ggirukotinwa. Wa pumole mukochirewatini punkakanru wa ruklukanuwninri. Ga wa renshinikanutinipa, pkaspukinri wale. ");
INSERT INTO pibNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ga wa payokgipre kata pagogne mukochirewatini pixaya, ga wa payokgipre kata satkakyegitinyi wane chinachri, ‘Nenshinikanuta,’ pkaspukinri wale.” ");
INSERT INTO pibNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Giyagni yokanatanune wane chinru Geso, “Gitsrukaachi, pyognika galixletanwu.” ");
INSERT INTO pibNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Giyagni wa Gitsrukaachi wane china, “Waneygi gixkamka galixle mostasaji pixka, wane nchinanru tye sukomormuna, ‘Pkopkolikinwa. Tsru wenu putakinwa.’ Yijnakotangi. ");
INSERT INTO pibNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“¿Satu wa gixa yegi waneya wayegreru tsru jitlolepagitachri ganikachri ga wa gowegane girukotachri, wa sana ruyakatini, gi koxa wane nchinru, ‘Punanu. Nikjetikowaka ptuplatanu?’ ");
INSERT INTO pibNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","“¿Gi ge wane nchinangonuklu, ‘Pkamrutanru nnikanrupa. Palpokotinwa. Pupxakanno nnikakopshini ga wa nurini. Wanepnute pixa nikanutka ga wa puranu’? ");
INSERT INTO pibNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","“¿Poyagnutanruge wa wayegrechri gi rixanu wale kamrutlu towutikowaka waka gike? ");
INSERT INTO pibNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Waneko pixka gixanu gixa. Wa gixa kamrutinitkalu wa pejnuruko ntowutikwaka, wane nchinanu, ‘Wayegrechine gimuterunwu, gi rixanu wutakikolupje wkamrutatka.’ ” ");
INSERT INTO pibNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Wane rixatka. Gerosale yini, Samari koprumta ga wa Kalilechijne koxa koprumta. ");
INSERT INTO pibNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Satu pokchi rapokamtinitka, pamole jejine yoptotaplu gijirgitutachine. Wajra tunwatna. ");
INSERT INTO pibNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Saplewatna. Wane chinna, “Geso, Gitsrukaachi, petwamonutanunwu wixni.” ");
INSERT INTO pibNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Wa retinitkana wane chinna, “Gajewa. Sasertotene gekakgitapinitkawa.” Wane rixatka. Wane yakopshinna powratkana. ");
INSERT INTO pibNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Giyagni satu wa wannate retnatkawa wa rutukinritka, satkapa. Tsru saple rixa gimalwuretlu Goyakalu. ");
INSERT INTO pibNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Chiji yoptsojitamta gijixistsi. Poyagnutlu. Samarya gajerni wale. ");
INSERT INTO pibNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Ga wa rugita Geso. Wane china, “¿Gi ge pamolna powratkalune? Ga wa mturuji ¿ginakatkana? ");
INSERT INTO pibNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Gi satuna geta satkapletka wa Goyakalu rumalwutyapa, seyni tye pnu gajeru galikakni.” ");
INSERT INTO pibNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Wane chinru, “Palnanutka. Pyanutka. Palixle gitskalakyi.” ");
INSERT INTO pibNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Repomsatka Geso Gwariseyoneya gikluplu Goyakalu pogirewatyawaka. Wale gigitna. Wane chinna, “Gi wa getkaluru runini Goyakalu pogirewatyawaka. ");
INSERT INTO pibNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Gi wane koxa chinanna, ‘Getanu. Gewru.’ Gi koxa, ‘Waneru.’ Gi rixanu, Goyakalu pogirewatyawaka gixa gitokote rawa.” ");
INSERT INTO pibNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Giyagni wane chinna yimaklene, “Pagognekaka ginanu wa gixa galukpotu getletanmaklu pagogne wa Gita Yineru Wgennogognekaka. Gi wa getanru. ");
INSERT INTO pibNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Wane chinangina, ‘Ga ga waneru.’ ‘Ga ga gewru.’ Gi wane gyanu. Gi gomkagitanru. ");
INSERT INTO pibNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Gi rixanu rawrakle pixka rixanu pasreta teno rapukotgogne rawrakini pixka ga wa pasreta teno rapukotgognepotunanuko pokamlata. Wane pixka nixanu Gita Yineru Wgenno nogognepa. ");
INSERT INTO pibNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Seyni muchinanu numkata salewnaleta gixo, nma yoptotikotupa nyi gimuweekakgognenatachineya. ");
INSERT INTO pibNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Gi rixanu Nowegogneklu pixka rixanu nogogneklupa wa napokinipa Gita Yineru Wgenno. ");
INSERT INTO pibNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Niknina, rurnina, ganunrowatnina ga wa ganuruwatnina, wa Nowe jiglokingognepotunanuklo pumlekwa. Runatka gonnewlu. Nikatanna pejnurunniko. ");
INSERT INTO pibNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","“Waneko pixka rixa Lotgogneklu. Niknina, rurnina, marnewatnina, rushanrewatnina, rutaklewatnina, panawatnina. ");
INSERT INTO pibNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Wa Lote gasukingognepotuko Sotomaya, tengogne gina pixka rixa gijrukleta xirnachri ga wa gasogre. Pejnurunniko nikata. ");
INSERT INTO pibNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","“Waneko pixka rixanu nogognepa, wa Gita Yineru Wgenno nupgujewninigognepa. ");
INSERT INTO pibNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Walegognepa panchi gogo gwanatachri ga wa panchi rawa rejnunkate, gi rujrukanu rawapyaplu. Waneko pixka rixanu wa sana gwanatachri, gi wa satkapanu rajxigiyaka. ");
INSERT INTO pibNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Gishinkapanro Lote gnunroni. ");
INSERT INTO pibNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","“Girukokta gijga chipetlegiwekletanu ruwekinri ramginina. Ga wa girukokta gamtakanru, rushatkapgiwekletanu. ");
INSERT INTO pibNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Wane nchingi, wale yechnopa, satu shechi gepi gwanatanu. Satu ganiiko, ga wa satupni giknokamtkona. ");
INSERT INTO pibNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Gepi suxone gimunripagkakanatachinepa. Sato ganiiko, ga wa satopni giknokamtkona.” ");
INSERT INTO pibNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Rugitna. Wane chinruna, “¿Ginaka, Gitsrukaachi?” ");
INSERT INTO pibNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Wale wane chinna, “Ginakakokta rawmanetanu gipnachri wane rapatjetinna klatatalune.” ");
INSERT INTO pibNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Satu yapkaklu runkaakoxna wa ma mamanga gagjigogneretinitipna. ");
INSERT INTO pibNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Wane china, “Papokchi waneru kgitakyagoklewakleru. Wale gi piklu Goyakalu. Gi koxa kagwakpiratna yine. ");
INSERT INTO pibNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Wale pokchi koxa wanero sato gipnagnurutachro. Wale yegi tya. Wane chinru, ‘Puglepokyegitanno nkamnixjeruya.’ ");
INSERT INTO pibNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","“Seyni gixgogne gi raluklu. Wanepnutetka wane china ginanwakayatka, ‘Gimka npiklu Goyakalu. Gi koxa nkagwakpiratlu yineru. ");
INSERT INTO pibNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Seyni twu gipnagnurutachro kojwakalchinanno nugnapokyegitanutkalo. Nma maalinanumtinitipa wala kojwakle chinanu wa ginjetachro.’ ” ");
INSERT INTO pibNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Wane china Gitsrukaachi, “Gyijnakotanru wa chinyawaka wa kgitakyagoklewakleru. Walenwa mpoyagkaakatu yineru. ");
INSERT INTO pibNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Ga wa Goyakalu ¿gi ge gapnuyegitanna tsomitanune wa gogi ga wa goyechno ragjitjene? Ga wa ma pognanutupni wannayegiya. ");
INSERT INTO pibNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Wane nchingi, giyampotu rapnuyegitanna. Seyni wa Gita Yineru Wgenno gininipa tye chijiya ¿nukshikinri galixlu?” ");
INSERT INTO pibNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Wane koxa chinna tye yapkakluya pimrine gaponshinikanutnachinwa wa poyagkakachine rixinrina; pimrine reyikna: ");
INSERT INTO pibNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Gepi jejine kpashiwakapji kanikna ragjigognetinripna. Satu Gwariseyni, ga wa satu gijgawenutachri. ");
INSERT INTO pibNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Wa Gwariseyo tunwata. Walenanuko wane china gagjigogneyegletnawa, ‘Goyakalu, npoyagnutyi gi wa pimrine jejine pixkalutno, kachowgurune, mpoyagkaakane, kgimopataklerune. Gi koxa wa tye gijgawenutachri pixka gixachrino. ");
INSERT INTO pibNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Satu simankaka gepi kata nogajirewjeta. Pejnuruko nyoptotanro pamolete nenekjeta.’ ");
INSERT INTO pibNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Ga wa wajra tunwata gijgawenutachri. Gi raluka tengogne yigleta. Seyni ruylakastata. Wane china, ‘Goyakalu, petwamonutanno gita kmukochirerno.’ ");
INSERT INTO pibNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","“Wane nchingi, tye yopikachritka gipji muklukanuwnakaakotutkani satu pnute. Gi rixanu girukokta wa tsru gitaknachriwa mturu rutaako wale. Ga wa mturu gitaknachriwa tsru rutaako wale.” ");
INSERT INTO pibNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Ranikyegitluna gajerya maturewnachinewa kamrukyapna. Wale retna yimaklene. Chigetjetkana ranikjenna. ");
INSERT INTO pibNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Wa Geso tomgana. Wane chinna Wale, “Getashatanna mturune runyegitannona. Gi gimaletanna. Gi rixanu wanna pixkalune wannanni wa Goyakalu pogirewatyawaka. ");
INSERT INTO pibNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Galikaka wane nchingi, girukokta gi wa mturu pixka rixyoptoletanru Goyakalu pogirewatyawaka gi wa jiglokanru.” ");
INSERT INTO pibNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Satu gitsrukaachi gepomgalu. Wane chinru, “Yimaklewatachri kigleru, ¿klu nkamrutanu nyoptotyaplu nuwekinri gike rixiniko mnikawnakatupa?” ");
INSERT INTO pibNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Geso wane chinru, “¿Klu chinanu wane pchinno kigleru? Gi satuna waneru kigleru. Satupjeru, Goyakalupje. ");
INSERT INTO pibNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Wa Yokanatkaluru Tokanchi pumata: Gi pumopatlewatanu. Gi puylalewatanu. Gi pchowguwatanu. Gi wa maleshawaka pupgujtalewashatanu. Pkagwakpiratanru puru ga wa punro.” ");
INSERT INTO pibNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ponikolu wane china, “Pejnuruko tyekaka nkamrutatka nmaklutinwakawa.” ");
INSERT INTO pibNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Ga wa Geso yijnakotlu tye. Wane china, “Satupje pmagatya. Pushankanru ptowruko wane pixle. Penekanna wa kwamonurune. Waneyapyi ponikole tengogneyapa. Punanu. Pomkagitanno.” ");
INSERT INTO pibNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Giyagni ponikolu, walepirana yijnakotinitka, wamonuwnapotutatka gi rixanu ponikolpotni. ");
INSERT INTO pibNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Retinri Geso, wane china, “¡Gi pakyaprenunanuktalu Goyakalu pogirewatyawaka jiglokinripna wa kserojiprojirune!” ");
INSERT INTO pibNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Geso wane china koxa, “Myapretmakni kameyo tsapujripna tjiglokinripa wa ponikolu pnute jiglokyaplu Goyakalu pogirewatyawaka.” ");
INSERT INTO pibNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ga wa yijnakonatachine wane china, “Giyagni ¿katu gimkata gognetkaakotanu?” ");
INSERT INTO pibNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Geso wane china, “Wa yineya mumkatanutu, wale rumkata Goyakalu.” ");
INSERT INTO pibNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Giyagni Petro wane china, “Petanu. Wixa giknokamtlu wane wixle. Ga wa womkagitatkayi.” ");
INSERT INTO pibNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Wale wane chinna, “Galikakni wane nchingi, girukokta giknokapjimta, ga wa ganunro, ga wa gimolene, ga wa rurune, ga wa wugenene Goyakalu pogirewatyawaka chinanu, ");
INSERT INTO pibNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","wale yoptotanru gixo kata pnute xani tyegognekaka, ga wa pagognesha ginachripa waneyaplu ruwekinri mnikawnakatupa.” ");
INSERT INTO pibNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Wa Geso ganikna pamole gepi. Wane chinna, “Xani Gerosale wkanikanutka, poyagkakikolupa pejnuruko Goyakalu tokanu geneklewatachine chinyongatyawaka wa Gita Yineru Wgennopirana. ");
INSERT INTO pibNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Gi rixanu samyookalurupno payine yegi. Gapnokatkalurupno. Gektutetkalurupno. Ga wa gitskagjetkalurupno. ");
INSERT INTO pibNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Kochipjetannona. Ruylatannona. Ga wa mapgogne chininri nyotunotanu.” ");
INSERT INTO pibNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ga wa wanna gi gimata jemlu tyepirana. Wanna yogimatika tyepirana. Gi rumatluna wa chinyawaka. ");
INSERT INTO pibNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Wane rixatka. Gerikostsi rapokinitka, waneru satu maygaletu. Gatnugapostsi tuplanatachri. Sroschi gagjijetachri. ");
INSERT INTO pibNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Wale yijnako giknogletinna gixolune yine. Repomlewata klunerni. ");
INSERT INTO pibNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Runkakluna wa Geso Nasare Gajeru giknogamta. ");
INSERT INTO pibNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Giyagni saplewjeta. Wane china, “Geso, Tawiklopisha, petwamonutanunno.” ");
INSERT INTO pibNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Wa kosekamtachine chigetjetlu pochke rixinripa. Seyni wanepnute saplewjepotuta, “Tawiklopisha, petwamonutanunno.” ");
INSERT INTO pibNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Giyagni Geso tunwata. Rawapjixlu Wale yegi. Wa rapyegitinitkalu, repomgalu. ");
INSERT INTO pibNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","Wane chinru, “¿Klu palukatka wa nixyapyi?” Wale wane china, “Gitsrukaachi, netinripa.” ");
INSERT INTO pibNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Ga wa Geso wane chinru, “Petanutka. Palixle gitskalakyi.” ");
INSERT INTO pibNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Waneklu retatka. Romkagitatkalu. Rumalwumtlu Goyakalu. Ga wa pejnuruneko yine getinri rumalwutluna Goyakalu. ");
INSERT INTO pibNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Geriko Pokchi rapokamtinitka Geso. Koprupokchimtlu. ");
INSERT INTO pibNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Waneru satu jeji Sakeyo giwakatletachri. Walenwa gijgawenutachine gitsrukate. Ponikolni wale. ");
INSERT INTO pibNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Raluka getletlu Geso gi gixachrini. Gi rumkata getletlu wa gixolune yine chinanu ma tennu chinanu. ");
INSERT INTO pibNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Penute ya gasukleta. Sukomormuna ratskota retyaplu. Gi rixanu wane yapamtanu. ");
INSERT INTO pibNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Wane rapokinitka Geso, yopukgatlu. Wane chinru, “Sakeyo, giyampotu pujrukanutka. Gi rixanu xawakni pupji numkata gapokleta.” ");
INSERT INTO pibNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Giyagni giyampotu rujruka wale. Gimuwatachri yoptotlu. ");
INSERT INTO pibNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Pejnuruneko getanatachine kegemga. Wane chinna wa satu jeji kmukochireru yegi jiglokinri wane rawinripa. ");
INSERT INTO pibNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Giyagni tunwata Sakeyo. Wane chinru Gitsrukaachi, “Petanu, Gitsrukaachi. Ganikaji wane nixle nenekna kwamonurune. Ga wa girukokta nyokwire nujgiylo sroschi, gepkoxamkoje kata pnute nsatkaklo.” ");
INSERT INTO pibNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Geso wane chinru, “Xawakni tyepji rapokatka gognewatikaluru, gi rixanu Gawraklopishkoxni wale. ");
INSERT INTO pibNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Gi rixanu Gita Yineru Wgenno gina nujgiyaplu gamganatachri ga wa nognetkakyaplu.” ");
INSERT INTO pibNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Wale tokanchi yijnakotinitkana, satu yapkaklu wane chinyatnakna Geso, gi rixanu gi gowukatkalu Gerosale, ga wa wanna kagwaklu waneklu rupgujewnanu Goyakalu pogirewatyawaka. ");
INSERT INTO pibNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Giyagni wane china, “Satu jeji wale potu pnu chiji ya, pogirewatyawaka yoptotinripa ga wa satokinripa. ");
INSERT INTO pibNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Pamole wayegrene tomga. Satkaka gepi pachaproji reneka. Wane chinna, ‘Gmarnewatanu napokinpotunanuko.’ ");
INSERT INTO pibNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","“Ga wa gichijne gajene gayegixlu. Yokanatkana tsrune wale gajxigi, wane chinanna, ‘Gi waluklu wixa yegi pogirewatinripa wa tye.’ ");
INSERT INTO pibNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Wane rixatka. Wa yoptotinitkalu pogirewatyawaka. Satokinitka tomgajixatkana wanna wayegrechine wa sroschi renekamtanune, rumatyapna satkaka marnewatinrina. ");
INSERT INTO pibNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","“Muchinanu rapyegitlu satu. Wane chinru, ‘Gitsrukaachi, petanu. Gepi pacha pserojiprojite yogniklo gepi waragkaproji.’ ");
INSERT INTO pibNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","“Wale wane chinru, ‘Poyagnu, kigleru wayegrechriyi. Ptsotsotaji chinanu poyagkakinri. Giyagni pamole pokchi putakiko.’ ");
INSERT INTO pibNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Satu ginatnaka. Wane china, ‘Gitsrukaachi, gepi pacha pserojiprojite tyogniklo satu waragkaproji.’ ");
INSERT INTO pibNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","“Wale koxa wane china, ‘Pixa koxa pamyo pokchi putakiko.’ ");
INSERT INTO pibNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Satu ginatnaka. Wane china, ‘Gitsrukaachi, petanro gepi pacha pserojiprojite. Numretlo mkachrisama poyitkaluro. ");
INSERT INTO pibNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Npikyi. Gi rixanu jeji shikgajiryi. Pma mutaklewatyawakanu pwiya. Pma muknokajityawakanu papatjetya.’ ");
INSERT INTO pibNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","“Giyagni wale wane chinru, ‘Mugletu wayegrechriyi. Pixako ptokanu nuklukanuwnayegjixinyi. ¿Pumatnoge wa shikgajiru jeji nixinri? ¿Nma mutaklewatyawakanu nwini, ga wa nma muknokajityawakanu napatjetya? ");
INSERT INTO pibNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","¿Klu koxa gi putakyalo nserojiprojite kgipekoklerune yegi, wa napokini nyoptotanmaklo gitanuko ga wa gixolewnachroymananuko?’ ");
INSERT INTO pibNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Wane chinna wane tunwanatachine, ‘Gkonanro gepi pachaproji waleyegiya. Genekanru wa gepi waragkaproji waneyalutu.’ ");
INSERT INTO pibNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","“Wanna wane chinru, ‘Gitsrukaachi, waneyatkalu gepi waragkaproji.’ ");
INSERT INTO pibNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“Giyagni wane nchingi, waneyalutu psoluko reneeko. Ga wa waneyamigjetu, wane rixleko koniko. ");
INSERT INTO pibNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ga wa nkamnixjene koxa wa nma maluka pogirewletjene wannayegiya, ganikanna gewi. Giylaganna gita getanu.” ");
INSERT INTO pibNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Tyepirana rali wane chinremtinitka Geso, yatka. Kosekamtatka. Gerosale kanikatka. ");
INSERT INTO pibNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Wane rixatka. Gi gowuka chininitka Wetpage ga wa Wetani. Magkastsitkani, wa Goliwa Magkate chinikowaka. Gepi yimaklene yokanata. ");
INSERT INTO pibNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Wane chinna Wale, “Gyanu tujra pokchi ginaple gajeru. Gapokinpatklu, waneklupa gikshikanro mporo wgene tsatkaluru, yineru mtuplatanutowa. Gkoshrikanru. Ganikanru. ");
INSERT INTO pibNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Girukokta gepomginipgi, ‘¿Klu chinanu wane gixa koshpirokletlo?’ wane nchinanu, ‘Gitsrukaachi galuklu.’ ” ");
INSERT INTO pibNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Wane yatkana yokanatkalune. Rukshikluna chinyawakpotukna. ");
INSERT INTO pibNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Koshpirokatkaluna mporo wgene. Kwangixleru wane chinna, “¿Klu chinanu gkoshpiroklu mporo wgene?” ");
INSERT INTO pibNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Wanna wane china, “Gi rixanu Gitsrukaachi galuklu.” ");
INSERT INTO pibNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Ranikatkaluna Geso yegi. Sapwakatjitatkaluna gimkaluymana mporo wgene. Gitji rutakatkaluna Geso. ");
INSERT INTO pibNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Yamtini Wale, rukwekamkatna gatnugapo. ");
INSERT INTO pibNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Gi gowuka rixininitka, Goliwa Magkate yojrigle rapokiniwa, pejnuruneko gixolune yimaklene gimuwata. Yinuwaka gimalwuretluna Goyakalu. Saplee gimalwuretluna wa pejnuruko retanruyna, wa giyaklukakaya. ");
INSERT INTO pibNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Wane chinna: ¡Gimalwutkaluru Pogirchi, Gitsrukaachi giwaka ginyachri! ¡Kigle gwashle rixanu tengogneya! ¡Tenowaka potu waneplu goyaknu! ");
INSERT INTO pibNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Giyagni pimrine Gwariseyone gixolune yine yegi gwachine wane chinruna, “Yimaklewatachri, pchigetjetanna pyimaklene.” ");
INSERT INTO pibNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Wale gigita. Wane china, “Wane nchingi, wa nyi pochke rixinmakna, sotlumka saplewatanu.” ");
INSERT INTO pibNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Gi gowuka tixininitka, retlu tsru pokchi. Chiyagata wale chinanu. Wane china, ");
INSERT INTO pibNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","“¡Pumatkamkalu xani pugogneya, kluneru chinanmaka kigle gwashlepmakyi! Seyni xani puygale yogimatika. ");
INSERT INTO pibNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Gi rixanu runanu pagognekaka, pkamnixjene chiji pirijeretinyina. Sajrukanyina. Pejnurusretako rerutanyina. ");
INSERT INTO pibNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Chiji jijrukanyina, ga wa pwugenene gitoko gwachine. Gi wa rutukanu sotlu rogotkakinripa, gi rixanu gi pumatlu wa psalwayegitikolgogne.” ");
INSERT INTO pibNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Kpashiwakapji jiglokamtatka. Yinuwaka giknokletna maleka gishanrewanatachine. ");
INSERT INTO pibNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Wane chinna, “Kayongalutkani: Nopji gagjigognewakapjipni. Ga wa gixa wane gixatkalu gitawakapna kachowgurune gwiywaka.” ");
INSERT INTO pibNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Pagognemnunanuka kpashiwakapji runkaklewatya. Ga wa tsrukakalune sasertotene ga wa yonchikgapine, ga wa wanna potu yine gijga giylaletluna. ");
INSERT INTO pibNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Gi rukshikluna gikta rixpokotyapluna. Gi rixanu pejnuruneko yine Walepje kagwakna wa jemyapluna. ");
INSERT INTO pibNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Pagogne wane rixatka. Yine runkakanata kpashiwakapjiya. Runkakletlu Kiglerpotunanu Tokanchi. Rapyegitluna tsrukakalune sasertotene, ga wa yonchikgapine tsruneyma. ");
INSERT INTO pibNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Ruynumsatluna. Wane chinruna, “Punkakanwu klu putakika Pixa tyekaka pkamrutinri. ¿Katu gitakyi wa tyeya?” ");
INSERT INTO pibNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Giyagni rugita Geso. Wane chinna, “Gita koxa gepomgangi satu tokanchiya. Ginkakanno. ");
INSERT INTO pibNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Wa Gwa katlewle ¿tengogne giyakatyachrirge? ¿Waka yinenukla?” ");
INSERT INTO pibNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Yoptopirkakna wannakakluko. Wane chinna, “Wane wchininipmaka, tengogne giyakatyachrini, Wale wane chinanunwu, ‘¿Klu chinanu koxa gi galixlu?’ ");
INSERT INTO pibNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Wane wchinininapa yinenni, pejnuruneko yine sotlujetanunwu. Gi rixanu rushinikanutkana Goyakalu tokanu geneklewatachritkani Gwani.” ");
INSERT INTO pibNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Giyagni rugitna wa gi rumatna ginakakta giyakatyachri. ");
INSERT INTO pibNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Giyagni Geso wane chinna, “Gi Gitako ginkakangi klu nutakika tyekaka nkamrutinri.” ");
INSERT INTO pibNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Yinuwaka ginkakletna yine tye yapkakluya, “Satu jeji sana gowasha rutaka. Renekamtna sana girukotachine. Pnu yatka. Gixgogne ramga. ");
INSERT INTO pibNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Topapkotka satu wayegrechri yokanata girukotachine yegi, wa renekyapluna wa sana gwiyachritka. Seyni wa girukowatachine kochipjetanru. Maleshalni yokanatna. ");
INSERT INTO pibNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Rumepe yokanretatnaklu satu wayegrechri. Seyni wale koxa kochipjetna. Rektutetanruna. Maleshalni yokanatna. ");
INSERT INTO pibNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Wanepnute mapa rixinri yokanatatnaka. Waleni rustakna. Ruknokanruna. ");
INSERT INTO pibNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Giyagni wa kgisanateru wane china, ‘¿Klu nkamrutanutka? Nyokanatanru nalukanru noturu. Kagwakpirgetkotanruna wale.’ ");
INSERT INTO pibNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","“Wa sana girukotachine wa retinitkaluna, wane chinna wannakakluko, ‘Tyenwa yoptotachripatka. Ginanu. Wuylaganru. Yoptotanrupmaka wixanpatkani.’ ");
INSERT INTO pibNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","“Kashichanruna. Gowasha ruknokyanruna. Wane ruylatyanruna. “Giyagni ¿gi rixanutkana kgisanateru wa wanna sana girukotachine? ");
INSERT INTO pibNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Runanu. Ruylatanunna wa nyipni sana girukotachinepni. Pimrine renekanu gowasha.” Wa wanna yijnakotinitkalu, wane chinna, “Gike rixiniko.” ");
INSERT INTO pibNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Wa Wale retanatna. Wane china, “¿Klunerkoxni wa tye yonatkaluru? Wa sotlu myoptotkotu kamrupjitachineya, wale gitaaka yoptowaka gitsejita. ");
INSERT INTO pibNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","“Katupnikta tye sotlu gitspetanuna, rumlokpotutanuna, ramgapotutanuna. Ga wa tye sotlu gijrukgogotanrunapa ramgapotutanuna.” ");
INSERT INTO pibNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Waneklu yonchikgapine ga wa tsrukakalune sasertotene galuka kashretlu Geso, gi rixanu rumata jemluna wa wannapirana chinyalu tye yapkaklu. Seyni yine pikna. ");
INSERT INTO pibNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Giruktatluna. Yokanyegitluna yimlewashatachine, wa poyagkakachine pixka rixashatinripna, wa kashtokanutyapluna, samyokyapluna gitsrukaachi yegi, wa tsru potu gitaakaluru girukotlewatyawaka. ");
INSERT INTO pibNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Repomgaluna. Wane chinruna, “Yimaklewatachri, wumatlu wanepotuko pchinjeta ga wa punkaklewjeta. Gi wa manewle giglenu chinanu pyoptotlu yineru. Seyni galikaka potu punkakletpiranatlu Goyakalu gatnugapote. ");
INSERT INTO pibNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","¿Wa munanshichkotnige wenrukaka wenekyaplu Susa waka gike? ¿Wenekerge waka gi wa wenekanru?” ");
INSERT INTO pibNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Seyni Wale gimatlu wanna sanowashle. Wane chinna, ");
INSERT INTO pibNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Gekakgitanno wa sroschiproji. ¿Katu yaglu waneylo, ga wa katunni toyonga?” Wane chinruna, “Susanni.” ");
INSERT INTO pibNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Giyagni Geso wane chinna, “Giyagni genekanru Susa Susanni, ga wa Goyakalu Goyakalunni.” ");
INSERT INTO pibNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Gi rumkata kashretokanutluna yine getanu. Ruglajitanna wa rugityana. Pochkenna. ");
INSERT INTO pibNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Rapokna pimrine Sariseyone. Wane chinachine maleshlu yotunrupa gipnachineya. Repomgaluna. ");
INSERT INTO pibNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Wane chinruna, “Moysisi yonyegitwu, satu yegwakluni kganunronru gipninina gi kwugenniri, wa repuru gwanro wale gnunronanni ruxolewkakinripa giklopishapa yegwakluni chinanu. ");
INSERT INTO pibNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Giyagni wanena payokgiprerune moletkakachine. Muchinanu tsru gnunrowata. Rupnana. Mwugenetniko. ");
INSERT INTO pibNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Waneko pixka rixana gapkatatachri. ");
INSERT INTO pibNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Mapa chininrina gwalo. Waneko pixka rixanna pejnurunniko payokgipreni. Rupnanna. Gi ruknokawgenetanna. ");
INSERT INTO pibNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Suxni gapkata potu gipnaletanatka. ");
INSERT INTO pibNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Giyagni yotunruklupa, ¿giru gnunropni wa wannaya? Gi rixanu payokgipreni gnunronitka wa wala.” ");
INSERT INTO pibNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Geso wane chinna, “Tyegogne gajene ganunrowata ga wa ganuruwatna. ");
INSERT INTO pibNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Seyni wa rumuknu getkonina rapkapyapluna tujragogne mnikawnakatupa ga wa yotunru gipnachinetskalaya wanna gi ganunrowatanutka. Gi koxa ganuruwatanutkana. ");
INSERT INTO pibNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Gi rumkata gipnaletanutkana. Gi rixanu Goyakalutowrene pixka rixanutkana. Goyakalu wgenenpatkani, gi rixanu yotunru wgenenpatkani. ");
INSERT INTO pibNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Wa yotunotachinepa gipnachinepirana, Moysisi ginkakpokowaklewata kawshipiripirana runkakletinri, wane rixinri Gitsrukaachi, Gawra Goyakalutni, ga wa Gisaaka koxa Goyakalutni, ga wa Gakowo koxa Goyakalutni. ");
INSERT INTO pibNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Gi wa gipnachine Goyakalutni, seyni giwekachine Goyakalute. Gi rixanu pejnuruneko giweka Wale chinanu.” ");
INSERT INTO pibNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Giyagni pimrine yonchikgapine gigita. Wane chinna, “Yimaklewatachri, kigleru wane pchinre.” ");
INSERT INTO pibNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Gi rixanu wanekluyakawa gi tserpiranawa gepomgaletatkaluna. ");
INSERT INTO pibNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Giyagni Wale wane chinna, “¿Gi chinna wa Tawiklopisha rixinri wa Kristo? ");
INSERT INTO pibNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Gi rixanu waleko Tawi wane china Shikalchi kirukateya: Gitsrukaachi wane chinru Nutsrukate: ‘Ptuplatanu npotuklesretate, ");
INSERT INTO pibNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Nutakinpotukna pkamnixjene putspanjixgapre rixinripna.’ ");
INSERT INTO pibNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","“Giyagni waleko Tawi wane chinru Gitsrukaachi, ¿gi rixpokotyawaka giklopishayapni?” ");
INSERT INTO pibNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Pejnuruneko yine yijnakonatinri, wane chinna yimaklene, ");
INSERT INTO pibNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Ggirukotinwa wanna yonchikgapineya. Galuka yanretachine gimkaluyna gowukalu. Ralukluna ralukikolupna giputuyna. Ralukluna wa tsrukakalune tuplapijere ginkaklewawakapjikakaya, muchinanu tuplapijkaka koxa nikjetikowakaya. ");
INSERT INTO pibNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Nikatapjijetkanna gipnagnurutachronni. Rixashleyna gogagjirgognerkakna. Wanna giklukanuwnakakalunpotupni.” ");
INSERT INTO pibNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Geso getanata. Retna ponikolune, wa genekashlu gignantakikowaka gitakachine. ");
INSERT INTO pibNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Sato gipnagnurutachro reta kwamonuro. Tutaklo gepi mturomchataaji. ");
INSERT INTO pibNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Wane china, “Galikaka wane nchingi, wa twu kwamonuro gipnagnurutachro wala gitaka pejnurune pnute. ");
INSERT INTO pibNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Gi rixanu nyi pejnuruneko ruxetanrona rutakna renekashlena Goyakalunupa. Seyni wa twu magatyachro potu tutaklo tseyomchataaji, pejnuruko tuwekinripa.” ");
INSERT INTO pibNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Pimrine kpashiwakapjipirana yanumsanatna, wa kiglepotkaklu sotlu ga wa giglewlukaka genekashatkaluru. Geso wane china, ");
INSERT INTO pibNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Wa tyekaka getanru. Pagogne ginanu gi wa rutukanu sotlu rogotkakinripa, gi wa mujrolekatunpakni.” ");
INSERT INTO pibNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Giyagni repomgaluna. Wane chinruna, “Yimaklewatachri, ¿giklupni wa tyekakapa? ¿Klu getkaluru wanepa wa tyekaka wane gixinripatka?” ");
INSERT INTO pibNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Giyagni wane china Geso, “Ggirukotinwa gi wa yokwitkalunepgi. Gi rixanu gixo ginanu ngiwakaya. Wane chinanna, ‘Gitni. Kayegikatkalu gigogne,’ chinanna. Giyagni gi wa gomkajigitanna. ");
INSERT INTO pibNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Seyni wa gixa jeminiplu wa giylalupirana ga wa yawroptajrukakapirana, gi gimyekanu. Gi rixanu rumkata muchinanu wane gixleta, seyni gi wa yoptukyawakapnichi.” ");
INSERT INTO pibNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Giyagni Geso wane chinna, “Yotunyegkakanna pachijne gajene pachijne gajene yegi, ga wa pogirewatyawaka yotunyegkaka pogirewatyawaka. ");
INSERT INTO pibNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Waneplu tsru giyolikchijrukaka pachijnemnunanukaya. Ga wa waneplu yayixlukaka, ga wa nachlukaka, ga wa gimyeklukaka, ga wa tsru getkalurkaka tengogneya. ");
INSERT INTO pibNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Ga wa ma mapookanupachi tyekaka, gkashichkona. Kojwakangina. Ginkaklewawakapjikakaya ga wa yoshmakikwaka nsamyooko. Ga wa pogirchine yegi ga wa gitsrukaachine yegi ganiiko Gita giwaka chinanu. ");
INSERT INTO pibNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Rushpakanu gipgujtalewle chinanu. ");
INSERT INTO pibNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Giyagni gaji gitakanru tye shinikanchi xani, gi wa gyanshinikanyegitanru gikta nchina giykoyegletinwa. ");
INSERT INTO pibNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Gi rixanu Gita genektokanutangi ga wa gimatkalewle ma mumkata satkakletanruna, gi koxa rumkata yoptopiiretanruna pejnuruneko gkamnixjene. ");
INSERT INTO pibNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Gixa samyooko giruneyako, ga wa gimunanwakaneyako, ga wa gimoleneyako, ga wa gimatanuneyako. Ga wa gixa pimringi ruylatanna. ");
INSERT INTO pibNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Gayegixkalunepgi pejnuruneyako Gita giwaka chinanu. ");
INSERT INTO pibNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Ga wa gixjiwutsa gi wa patsapjeko gamgingi. ");
INSERT INTO pibNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Gakotanshinikanutinri, giwekanu. ");
INSERT INTO pibNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Wa gixa getiniplu solalone sajrukiniplu Gerosale, waneklu gimatanutkalu kayegikatkalu mwakotu rixinripatka pokchi. ");
INSERT INTO pibNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Waneklu wa Gote gwachine magkakaka ya gasukletanna. Ga wa pokchi ganikajite gwachine wane rushpakinna. Ga wa pokchi malekate gwachine gi wa pokchi yanutkana. ");
INSERT INTO pibNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Gi rixanu walegognekakapa saletikolupna Gerosale gwachine, wa poyagkakikolupa pejnurkakako yonatkalurkaka. ");
INSERT INTO pibNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","¡Gi waneni wa kamshironepni ga wa gashichakachinepni walegognekakpatka! Gi rixanu waneplu tsru kegeknanuwlu tye chijiya, ga wa jgekanchi nyi yinyegiya. ");
INSERT INTO pibNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Yawnanna yoglolewapi gistakikalune. Payinemnunanuka ganikanna kashikanotkalunenapa. Ga wa Gerosale gakatooko payineya poyagkakikolpotunanuko payingognesha. ");
INSERT INTO pibNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Waneplu getkalurkaka tkachiya, ga wa ksuruya, ga wa katagirkakaya, ga wa tye psolchijneyako payinemnunanuka salewnale. Wa tsru wenu sejrewnale ga wa gishpurga yowjere nutanshinikankakinna. ");
INSERT INTO pibNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Rupnagoojetanunna yinepni piklena chinanu, ga wa kagwakanruna chinanu tye psolchijneko ginachripa chinanu. Gi rixanu wa gichkolkaka tengogne gajeru kowshiwshitko. ");
INSERT INTO pibNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Wanepnute retannona wa Gita yineru Wgenno ginachripa kyachgapereruyma. Tsru nuyakle ga wa noyaknu numunanu. ");
INSERT INTO pibNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Wa tyekaka yinuwaka wane gixletinpatka, mpotukawatanu. Ntunogitanu. Gi rixanu gi gowukatkalu gkoshpakikolpatka.” ");
INSERT INTO pibNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Satu yapkaklu wane chinyana, “Getanro gikera ga wa pejnurmunako. ");
INSERT INTO pibNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Wa gixa getinitkalo tupchekaygalejitinitka, gixnanuko gimatatkalu gi gowukatkalu walapu. ");
INSERT INTO pibNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Waneko pixka rixanu gixa getinpatkalu wane gixlutkani tyekaka, gimatanutkalu gi gowukpatkalu Goyakalu pogirewatyawaka. ");
INSERT INTO pibNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Galikaka wane nchingi, gi ruknoganu tye gimuweekakgognenatachinesha, wa ptowruko tyekaka ma mixkanuwa. ");
INSERT INTO pibNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Wa tengogne ga wa chiji nikawnanu, seyni wa ntokanu gi nikawnanu. ");
INSERT INTO pibNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Ga wa gixa girukotinwa gixnanuko, gi wa ginjiwujpa gixkalchinanu, gi wa gimru chinanu, gi wa gkojwakanshinikanutinri tyegogne gajeruya, mkagwaakotupa rapyegityapgi nogogne gitseklu pixka. ");
INSERT INTO pibNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Gi rixanu wane rixa gapyegletanna pejnuruneko tye psolchijnemtako gwachine. ");
INSERT INTO pibNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Giyagni psolgogneko giyokanu. Gagjigognetanu pejnuruko ginachripa gimkata gasukletinripa, ga wa Gitastsi, Yineru Wgennostsi gimkata tunwaletinripa.” ");
INSERT INTO pibNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Ga wa gogikaka, wa kpashiwakapji runkaklewjetya. Ga wa goyechno Goliwa Magkate chinikowaka yajeta. Wane rawjejeta. ");
INSERT INTO pibNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ga wa pejnuruneko yine goyechnokawpotuko yotunjeta. Kpashiwakapji yayegityaluna wa yijnakotyapluna. ");
INSERT INTO pibNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Gi gowukatkalu meyiwlugogne, wa jimapro gisekachri myapjetkotu niikalurupa, wa Giknoglushgogne chinkaluru. ");
INSERT INTO pibNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Ga wa tsrukakalune sasertotene ga wa yonchikgapine gigjalu gi rixpoko giylaletanruna Geso, gi rixanu yine pikna. ");
INSERT INTO pibNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Satanasyo jiglokatkalu Gota, Giskaryote chinkaluru. Walenwa pamole gepi rixinrina. ");
INSERT INTO pibNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Wane ya. Ruynumsatapna tsrukakalune sasertotene ga wa kpashiwakapji girukotachine gi rixpoko samyokletyaplu wanna yegi. ");
INSERT INTO pibNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Wanna gimuwata. Rupiratyaluna renekyapluna sroschiproji. ");
INSERT INTO pibNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Giyagni wale gipiratyana. Rujgalu ruglepoktapinri gi rixpoko samyokletyaplu wa gixolune yine mwiyawakanu. ");
INSERT INTO pibNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Rapokatka jimapro gisekachri myapjetkotu nikikolgogne. Rumkata giylaletluna Tsru Giknoglushgogne genekashatkaluru. ");
INSERT INTO pibNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Giyagni Petro ga wa Gwa yokanata. Wane chinna, “Gajewa. Galpokotanru wixanupa wa Tsru Giknoglushgogne wnikanrupa.” ");
INSERT INTO pibNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Wane chinruna, “¿Ginaka paluka galpoklejixwu?” ");
INSERT INTO pibNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Wale wane chinna, “Wa tsru pokchi gyinipa, wane yoptotingi satu jeji wa gashgaji gonu gwanru ganikachri. Gomkagitanru panchipotunanuko ginakakta jigloka. ");
INSERT INTO pibNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Wane nchinanru wa kapjiru, ‘Yimaklewatachri wane china, “¿Ginaklu wa napokagrukwakle wa nnikyawaka Tsru Giknoglushgogne nyimakleneyma?” china.’ ");
INSERT INTO pibNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","“Wale gekakgitangi satu tsru teno gajerugruko gali galpokletkalurutka. Wane galpokotinri.” ");
INSERT INTO pibNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Giyagni wane yatkana. Rukshikluna Wale chinyawakpotukna. Ralpokotluna Tsru Giknoglushgognenupa. ");
INSERT INTO pibNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Wa gipapko gapokinitka, nikjetikwaka tuplata. Ga wa Waleymana yokanatanune. ");
INSERT INTO pibNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Wane chinna Wale, “Naluka gimniklepotutgi tye Giknoglushgogne nma salewnagnapuwa. ");
INSERT INTO pibNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Gi rixanu wane nchingi, gi wanepnuteko nnikanutkalu ma poyagkaakanuwa wale Goyakalu pogirewatyawakaya.” ");
INSERT INTO pibNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Rawlo girapistono. Poyagnutatkalo. Wane china, “Gyoptotanro wa twu. Gimurkakanu. ");
INSERT INTO pibNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Gi rixanu wane nchingi, gi nuranutkalo wanepnute gowajga ma mapookanuwa Goyakalu pogirewatyawaka.” ");
INSERT INTO pibNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Kashichlu jimapro. Poyagnutinitkalu, jiknajrotlu. Reneksatna. Wane china, “Tyenwa nomane gixa chinanu geneekaluru. Wane gixjetanu gishinikyapno Gita.” ");
INSERT INTO pibNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Rali nikletinitkana, waneko pixka rixlo girapistono. Wane china, “Twu girapistono walanwa gerotu gipiratkaluru nogragaya, gixa chinanu giyookaluru. ");
INSERT INTO pibNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“Seyni getanru nsamyokjerumyopa Gitayma nikjetikowakaya. ");
INSERT INTO pibNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Gi rixanu galikakni Gita wa Yineru Wgenno galimtanu nutakikowaka, seyni ¡gi waneni wa tye jeji, wale chinanu Gita wa Yineru Wgenno samyooko!” ");
INSERT INTO pibNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Giyagni wanna yinuwaka gepomsakakleta wannakakluko girupni wale wane gixachripa. ");
INSERT INTO pibNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Yoptopirkakna wannakakluko giru yimaklelrupni wannate tsru kagwaakaluru. ");
INSERT INTO pibNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Giyagni Geso wane chinna, “Payineko pogirene girukotanna wanna, wanna chinanu gitaakalune kigleru gixjene chinkalune. ");
INSERT INTO pibNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Ga wa gixa gi wane gixanu. Seyni wa tsru potu gixachri gixyegiya, mturu potu pixka rixanu. Ga wa gitsrukaachi, satu kamrurewatachri pixka rixanu. ");
INSERT INTO pibNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Gi rixanu, ¿girni wa tsrupotu, wa nikjetikwaka tuplatachri waka kamrurewatachri? ¿Gi ge wa nikjetikwaka tuplatachri? Seyni wa gixyegiya, Gitni wa kamrurewatachri pixkalutno. ");
INSERT INTO pibNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Ga wa gixni wa Gitaymalunenangi nyantaletikowaakakaya. ");
INSERT INTO pibNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Giyagni Gita gipiratyagi. Nuru pixka pogirewatyawaka rupiratyano. ");
INSERT INTO pibNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Wa numnikjenepgi ga wa numurjenepgi wa nnikjetyawaka npogirewatyawakaya. Ga wa pamole gepi pogirchi tuplapijere ntuplatanu. Gixa gitakyagokanna pamole gepinerune wa Gisrayiline.” ");
INSERT INTO pibNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","“Simo, Simo, petanu. Satanasyo gagjiyegitgi trikoji pixka gixirikajitkalunepgi. ");
INSERT INTO pibNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Ga wa Gita gagjigogneyegityi wa palixle mmagatinitipa. Ga wa pixa penshinikanutinpatka, pmuchkotanshinikanutanna pumolene.” ");
INSERT INTO pibNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Giyagni Petro wane chinru, “Gitsrukaachi, galpokotachrino yoshmakikwaka nyinripa Pixayma waka gipnalu yegi.” ");
INSERT INTO pibNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Geso wane chinru, “Petro, wane nchinyi, ma yanumatkanuwa gaxawripa xawakni, pnutatanno mapa kata pma mumatyanupno.” ");
INSERT INTO pibNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Wane chinatnakna, “Wa nyokanatingi wa sroschimapa maniikangi, ga wa mtsapanengi ga wa myoshmakjixlengi, ¿pagixanrege gmagatya?” Wanna wane china, “Gi satuna wmagatya.” ");
INSERT INTO pibNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Geso wane chinna, “Seyni wa xani wa sroschimapa waneyalutu ranikanru, ga wa tsapa koxa. Ga wa yoglolewapi waneyamigjetu, rushankanru gimkaluko. Ragjitanru. ");
INSERT INTO pibNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Gi rixanu wane nchingi rumkata poyagkakletinripachi wa tye yonatkaluru Gitapirana. Wane china: Mugleneyma kagwakikolupa Wale koxa, Gi rixanu wa yonatkaluru Gitapirana poyagkakpotutkalurupni.” ");
INSERT INTO pibNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Giyagni wanna wane chinru, “Gitsrukaachi, petanru. Gewru gepi yoglolewapi.” Wale wane chinna, “Gigiyatka.” ");
INSERT INTO pibNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Giyagni wane yiyatka. Wa rixjetyawaka Goliwa Magkate ya. Ga wa yimaklene koxa gomkagitlu. ");
INSERT INTO pibNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Wa wane rapokinitkana, Wale wane chinna, “Gagjigognetanu gma yantaletikotupa.” ");
INSERT INTO pibNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Ga wa Wale gitspalatyana wa sotlu gimkata giknokikwakapshini. Yoptsojita. Wane ragjigognetya salewnalepapirana. ");
INSERT INTO pibNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Wane china, “Nuru, palukiniplu tuknoganu twu girapistono Gitaya, seyni gi wa Gita galukyawakapni, seyni Pixa galukyawakapni.” ");
INSERT INTO pibNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Satu Goyakalutowreru tengogne giyakatyachri gipgujewnayegitlu. Muchkotlu. ");
INSERT INTO pibNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Tsru chingajiwlu rixinri, wanepnute muchkowa gagjigognereta. Wane rixa runkokle wa tsru rutspigle pixka rixagragata wa chiji gapokachri. ");
INSERT INTO pibNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Wa ragjigognetyawaka palnamtinitka. Yayegitna yimaklene. Retamtna gimkanatachine wamonnupogna chinanu. ");
INSERT INTO pibNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Wane chinna, “¿Klu chinanu gimkanata? Gyotunotanu. Ga wa gagjigognetanu wa yantaletikowakapa gma jiglokinitipa.” ");
INSERT INTO pibNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Wa Geso yanumsanatiniwa, getanu, gixolune yine. Ga wa Gota chinkaluru, wa pamole gepi chininri, wanna kosekamta. Wa Geso yegi rapokatka. Ramlutlu. ");
INSERT INTO pibNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Giyagni Geso wane chinru, “Gota, ¿pamlurege psamyokyatkano Gita wa Yineru Wgenno?” ");
INSERT INTO pibNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Ga wa Waleymalune getanatlu giknogachripa. Wane chinruna, “Gitsrukaachi, ¿yoglolewaplege wustaklewatini?” ");
INSERT INTO pibNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Satu wannaymalutu wa sasertotene gitsrukate potu wayegreru ruylaka. Potuklejepi yostakyalu. ");
INSERT INTO pibNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Ga wa rujretlu Geso. Wane china, “Wanpotunanuko getashatanu.” Kamrukjepitlu. Rutuukaklu. ");
INSERT INTO pibNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Geso gepomgana sajrukjene, wannanwa tsrukakalune sasertotene, ga wa kpashiwakapji girukotachine, ga wa tsrune; wane chinna, “¿Kachowguru gishinikachine pixkagi gixa gishpaklemta yoglolewapiyma ga wa gagajeyma? ");
INSERT INTO pibNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Pagognemnunanuka kpashiwakapji gixayma nwanata. Gi wa wane gomyokyegityano. Seyni tyenwa gipapkotkani gixa, ga wa mapshagwaka girukotachripapkotkani.” ");
INSERT INTO pibNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Kashichatkaluna. Ranikluna. Sasertotene gitsrukatpotupji ranikluna. Ga wa Petro gowukayako gomkagitlu. ");
INSERT INTO pibNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Ganikajputu pawatna. Wane ruxiplakakyana. Wanna yegi tuplata koxa Petro. ");
INSERT INTO pibNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Sato wayegrechro getlu wa chichpawastsi tuplanatyawaka. Tetpotutlu. Wane china, “Wa tye Waleymalutunanu.” ");
INSERT INTO pibNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Giyagni wale nutatlu. Wane china, “Suxo, gi numatlu.” ");
INSERT INTO pibNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Gowukshiniyaka satu getatnaklu. Wane china, “Pixa wannaymalutunanyi.” Ga wa Petro wane china, “Jeji, gi wa gitni.” ");
INSERT INTO pibNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Gowukshini giknoginitka, satu psolmuchkonuko wane chinatnaka, “Galikakni wa tye koxa Waleymananu. Gi rixanu Kalile gajerni.” ");
INSERT INTO pibNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Ga wa Petro wane china, “Jeji, gi numata gikta pchina.” Waneklu, wa yanumsatiniwa, gaxawripa yanumatatka. ");
INSERT INTO pibNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Giyagni Gitsrukaachi geknokyegitlu. Retlu Petro. Ga wa Petro gishinkaplu Gitsrukaachi tokanu, wa chinyawaklu, “Ma yanumatkanuwa gaxawripa xawakni, pnutatanno mapa kata.” ");
INSERT INTO pibNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Giyagni maleka rushpaka Petro. Chiyampotuta. ");
INSERT INTO pibNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Geso kashichachine jejine gixpiranatlu. Kochipjetluna. ");
INSERT INTO pibNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Rushyagojitluna. Repomsatluna. Wane chinruna, “Goyakalu tokanu peneklewatkoxewa. ¿Katu giylakyi?” ");
INSERT INTO pibNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Wanepnute tye pixkalutu mupashiregnuchi gi gepika chinruna Geso. ");
INSERT INTO pibNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Gogi rixinitka rapatjetna yine tsrutene, ga wa tsrukakalune sasertotene, ga wa yonchikgapine. Jemanshinikankakjetyawakna ranikluna. ");
INSERT INTO pibNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Wane chinna, “¿Pixlege wa Kristoyi? Punkakanwu.” Wale wane chinna, “Wa nunkakingi gi galixanno. ");
INSERT INTO pibNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Wa nepomginkoxgi, gi wa gigitanno. ");
INSERT INTO pibNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Ga wa xaniyakawa Goyakalu kgiyaklewakleru potuklesretate ntuplatanu Gita Yineru Wgenno.” ");
INSERT INTO pibNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Ga wa pejnuruneko wane china, “Giyagni ¿Pixlege wa Goyakalu Wgene?” Wale wane china, “Gixa chinyawaka Gitakni.” ");
INSERT INTO pibNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Giyagni wanna wane china, “¿Klu wanepnute gipgujtalu walukatka? Gi rixanu wixa yijnakotokanutatkalu Walepotuko.” ");
INSERT INTO pibNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Giyagni palnamtatkana pejnuruneko gixolune yine. Pilato yegi ranikatkaluna. ");
INSERT INTO pibNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Yinuwaka jigyeglejetatkaluna. Wane chinna, “Tye wukshika wa wumolene pupjekakachri. Rujretna wa Susa genekikolupa wenru. Wane china Walegimni wa Kristo, Pogirchi.” ");
INSERT INTO pibNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Giyagni Pilato gepomgalu. Wane chinru, “¿Pixnige wa Goteyone Pogiryi?” Rugitlu Wale. Wane chinru, “Pixa chinyawaka.” ");
INSERT INTO pibNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Pilato wane chinna tsrukakalune sasertotene ga wa gixolune yine, “Gi satuna giklukanuwnalu nukshikyalu tye jeji.” ");
INSERT INTO pibNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ga wa wanna muchkotnawana. Wane chinna, “Komyekanshinikanutna yine. Runkaklewata psoluyako Gotechijneya. Kalile rumuyaka ginkaklewletya gewina.” ");
INSERT INTO pibNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Giyagni Pilato yijnakotinitkalu, repomgalewata gikta Kalile gajerni tye jeji. ");
INSERT INTO pibNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Wa rumatinitka wa Girore girukowasretatyawaka gajerni, yokanatlu Girore yegi, gi rixanu walegognekaka Gerosale rawanata Girore. ");
INSERT INTO pibNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Ga wa Girore getinitkalu Geso, rumuwpotuta. Gi rixanu gi pomshinikmaka raluka getletlu. Gi rixanu yijnakpiranyegitlu. Kagwaka getletlu satu getkaluru Wale kamrutanru. ");
INSERT INTO pibNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Gixo tokanchi repomgiylu, seyni Wale gike rugityalu. ");
INSERT INTO pibNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Wanna koxa tunwanatna tsrukakalune sasertotene ga wa yonchikgapine. Muchkowa jigyegletluna. ");
INSERT INTO pibNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Ga wa Girore solaloteneyma geyiklu. Rapnokatluna. Ponikolu mkachri yoshmakluna. Pilato yegi yokanatatnaklu. ");
INSERT INTO pibNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Walegogne rumatkakatkana Girore ga wa Pilato. Gi rixanu muchikawa kamnixkakapna. ");
INSERT INTO pibNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Giyagni Pilato tomgana tsrukakalune sasertotene ga wa tsrukakalune ga wa yine. Wane chinna, ");
INSERT INTO pibNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","“Wa tye jeji ganikyegitno wa yine pupjekakachri pguta. Ga wa nepomsatlu gixa getanu. Gi satuna nukshika giklukanuwnaletlu tye jeji wa gjigyegityalu. ");
INSERT INTO pibNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Gi wa Giroreko. Gi rixanu wale yokanatlu wixa yegi. Ga wa gi satuna kamruta rupninri chinanupa. ");
INSERT INTO pibNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Giyagni nkochipjejixanru. Wane gixachri nkaspukanru.” ");
INSERT INTO pibNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Wa satkaka meyiwlugognekaka rumkata kaspuklejetlu satu. ");
INSERT INTO pibNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Ga wa pejnuruneko gixolune yine pasaplewatkalunni wane chinna, “Puxriikakanru wa Tye. Ga wa Warawasu pkaspukinwu.” ");
INSERT INTO pibNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Walenwa yagotkaklu chinanu wa pokchi kamrutikaluru yagotkaklu, ga wa ruylale chinanu yoshmaaka. ");
INSERT INTO pibNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Rumepe tomgaletatnakna Pilato. Raluka kaspukletmaklu Geso. ");
INSERT INTO pibNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Seyni wanna saplewatatnaka. Wane chinna, “¡Koroshishkita putakaganru! ¡Koroshishkita putakaganru!” ");
INSERT INTO pibNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Wale wane chinna mapa kata chininri, “Seyni ¿klu gektutu kamruta wa Tye? Gi satuna nukshikyalu rupninri chinanupa. Giyagni nkochipjejixanru. Nkaspukanru.” ");
INSERT INTO pibNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Seyni wanna gichko saplewlepotutatnaka. Ragjitluna koroshishkita rutakikolupa. Giyagni wanna tokanu gaalirewata. ");
INSERT INTO pibNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Giyagni Pilato towuwatatka wa ragjityawakna rixikolpatka. ");
INSERT INTO pibNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Giyagni kaspukjixatkalu Warawasu wa yoshmaakaluru, yagotkaklu chinanu ga wa ruylale chinanu yoshmaakaluru, wa wanna gagjitanru. Ga wa Geso samyokatka wanna galukyawaka. ");
INSERT INTO pibNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Ranikatkaluna. Surene gajeru Simo kashichna, sana giyakatyachri. Wale rutjikaklona koroshishkita, Geso gajxigi ranikyaplo. ");
INSERT INTO pibNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Romkagitluna gixolune potu yine, ga wa suxone koxa, kegeknanuwatachine, wamonuwatachine Wale chinanu. ");
INSERT INTO pibNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Ruprotakyegitna Geso. Wane chinna, “Gerosale gajerone, gi wa gichiyagatanno. Seyni gixnanuko gichiyagatinwa, ga wa gwugenene chinanu. ");
INSERT INTO pibNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Gi rixanu runanu pagognepa, wane chininripna, ‘Giglenshinikanyegitkalune migatone, ga wa nanwakchikaka mmushiwatkane, ga wa tnuchkaka ma mashichkotu.’ ");
INSERT INTO pibNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Waneklupa yinuwaka wane chinretanruna magkakaka: Wixa gogo pujrukanu. Ga wa mturu magkakaka: Pushyatanwu. ");
INSERT INTO pibNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Gi rixanu wa tyekaka kamrutna wa yinuwakikoluya, ¿gi rixpokotanna pagogne?” ");
INSERT INTO pibNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Raniikakoxna Waleyma gepi gektutu kamruklerune giylatkalunepa. ");
INSERT INTO pibNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Rapokluna Kolkota chinikowaka. Walenwa Gijiwuswaga yegi chinikowaka. Wane koroshishkita rutakyaluna, ga wa gepi gektutu kamruklerune koxa, satu potuklesreta, ga wa satu kegnetesreta. ");
INSERT INTO pibNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Geso wane china, “Nuru, pkaspukinna wanna. Gi rixanu gi rumatna kluneru kamrutna.” Kotspaltamkatluna. Rutakluna rupenokalkakna. ");
INSERT INTO pibNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Wane tunwanatna yine. Retanatna. Tsrukakaluneyma ruxpiranatluna. Wane chinna, “Pimrine rognetkaka. Walenanuko gognetkakinwa wa xani Goyakalu Kristote rixinpakni, ga wa tsomitanru.” ");
INSERT INTO pibNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Wa solalone yayegitlu. Rapnokatluna. Renekmakluna kachgalu. ");
INSERT INTO pibNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Wane chinna, “Wa Goteyone pogire pixinipa, pognetkakinwa Pixnanuko.” ");
INSERT INTO pibNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Wanekoxlu jigyegitikoluyonga Wale gogwaka wane chinachri: Tyenwa Goteyone Pogire. ");
INSERT INTO pibNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Wanenna gepi gektutu kamruklerune, wa gixripatachinni. Satu mupashiregnuchi chinru. Wane china, “¿Gi ge Kristokyi pixa? Pixnanuko pognetkakinwa ga wa wixni koxa gognetkakanu.” ");
INSERT INTO pibNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Rugita wa satu. Chigetjetlu. Wane chinru, “¿Gi ge piklu Goyakalu? Waneko pixka giklukanuwnayegjixkaluryi pixa. ");
INSERT INTO pibNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Ga wa wixa galikakni wanepotuko wixka. Gi rixanu wkamrutyawaka pixkapotuko wyoptota. Seyni wa Tye gi satuna mugletu kamruta.” ");
INSERT INTO pibNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Giyagni wale wane china, “Geso, pushinikanno gita wa pogirewatyawaka pjiglokinipa.” ");
INSERT INTO pibNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Giyagni Geso wane chinru, “Galikakni wane nchinyi, xawakni Gitaymapyi gigletikowaka tengogneya.” ");
INSERT INTO pibNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Tumananutkani ruchpokatka psolchijnepotunanuyako, kayinwakasreta rapokinpotunanuko. ");
INSERT INTO pibNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Tkachi giwnamtatka. Mkachrichrata gimaletachri kpashiwaka potu gajeru gitlalakamtatka ganikajpotunanuko. ");
INSERT INTO pibNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Giyagni Geso tsru saple potu rixa. Wane china, “Nuru, pumyo nutaklu nuwekinri.” Wane rixatka, rupnanatka. ");
INSERT INTO pibNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Wa ksolaloteru getinri wane rixinritka, rumalwutlu Goyakalu. Wane china, “Galikakpotunanni tye jejni poyagkakachrini.” ");
INSERT INTO pibNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ga wa pejnuruneko gixolune yine wane gapatjetyachine getpachine, wa retinitkaluna wane rixinitka, ruylakastatna. Satokna. ");
INSERT INTO pibNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Ga wa pejnuruneko rumatanune ga wa suxone, Kalileya romkagitjene, gowuka tunwanatna. Retanatluna wa tyekaka. ");
INSERT INTO pibNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Ga wa satu jeji Gosi giwakatletachri. Walenwa jemanshinikankakjetikowaka gajeru, jeji kigleru ga wa poyagkakachri. ");
INSERT INTO pibNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Wale gi gigitlu wanna gishinikyawaka, gi wa wanna kamrutanru. Garimate gajerni, Gotesreta gwapokchitachri. Wale koxa Goyakalu pogirewatyawaka kagwaka. ");
INSERT INTO pibNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Wale Pilato yegi ya. Gesnimane ragjita. ");
INSERT INTO pibNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Jijrukatkalu. Pachrata poyitatkalu. Rutaklu yomlechi sotlu jitotikalurupna, gi satuna mutakikowakanuwa. ");
INSERT INTO pibNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Walegognenwa Tsrugognestsitka. Ga wa gapnanutikalurgogne gimrerekamtinpatka. ");
INSERT INTO pibNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Ga wa suxone, Kalile rumuninine, gomkagitlu retapyapluna kapnatikowaka, ga wa gi rixpoko gitakamanretanruna. ");
INSERT INTO pibNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Ga wa satokatkana. Ralpokotluna pgamlungiru ga wa pgamlugalu. Gapnanutikalurgogne rapnanutna wa yokanru chinyawaka. ");
INSERT INTO pibNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Goyechnokawpotuko muchinangogne simana wane yana yomlechi yegi. Raniklona pgamlugalo wa ralpokotanrona. ");
INSERT INTO pibNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Retluna wa sotlu gakaprurutkalurutka yomlechi gajeru. ");
INSERT INTO pibNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Jiglokapnatluna. Gi wa rukshikmanetatkaluna Gitsrukaachmane Geso. ");
INSERT INTO pibNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Wane rixatka. Ma mumatanshinikanutkana wa tyeya, waneklu gepi jejine gapyegitna katajimkalune. ");
INSERT INTO pibNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Pikanna. Chiji yonogimtna. Wane chinkana, “¿Klu chinanu gijgalu wa giwekachri wa gipnachinetskalaya? ");
INSERT INTO pibNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Gi wa gewitkalu seyni yotunomtatka. Gishinkapanru wa runkakyagi wa Kalile rawanatiniwa, ");
INSERT INTO pibNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","wa wane chininri, ‘Numkata Gita, Yineru Wgenno kmukochirerunemyo samyookalurupno. Numkata koroshishkita nutakikolupa, ga wa mapgogne rixinri nyotunotanu.’ ” ");
INSERT INTO pibNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Giyagni wanna gishinkaplu wa tokanu. ");
INSERT INTO pibNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Yomlechi satokyatkana. Pejnuruko wa tyekaka runkaakana pamole satupje ga wa pejnuruneko pimrine. ");
INSERT INTO pibNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Wannanwa Mariya Maktala gajero, ga wa Gwana, ga wa Mariya Santiyako ginro, ga wa pimrone wannaymalone ginkakna yokanatkalune tyekakapirana. ");
INSERT INTO pibNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Ga wa wanna yanumsalesha pixka rixa jemletluna. Ga wa gi ralixkana. ");
INSERT INTO pibNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Palnamta Petro. Rasukamta. Yomlechi yegi ya. Rujnoka. Retlu mkachrichrata kotnuukaluru. Gipji satokatka giglajitachri wa giknogachriyatka retinri. ");
INSERT INTO pibNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Walegogneko gepi wanna papokchi yana. Pamole gepi kilometroni Gerosaleya, Gemawo chinikowaka. ");
INSERT INTO pibNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Ruynumsakakananumtna wannakakluko wa pejnurukopirana giknogachriyatka. ");
INSERT INTO pibNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Wane rixatka. Wa ruynumsakakananumtinna, repomsakakananumtinna, Waleko Geso kayegikna. Wannaymamnutkalu. ");
INSERT INTO pibNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Ga wa wanna gimaletaygaletka ma mumatyanupluna. ");
INSERT INTO pibNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Ga wa Wale wane chinna, “¿Klupirana nchinkakananumta gixkakluko gyanananumtyawaka wamonuwgojitachingi?” ");
INSERT INTO pibNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Satu wa Kleyopa giwakatletachri gigitlu. Wane chinru, “¿Gerosale gapkapachripjeraygi pixa? ¿Gi ge pumatlu pixa wa wane rixanatinitka tyegognekaka?” ");
INSERT INTO pibNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Giyagni Wale wane chinna, “¿Klunernige?” Ga wa wanna wane chinru, “Wa Gesni Nasare gajernipirana. Walenwa jejni Goyakalu tokanu geneklewatachrini. Kgiyaklewaklerni kamrureya ga wa tokanuya, Goyakalu getanu ga wa pejnuruneko yine getanu. ");
INSERT INTO pibNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Ga wa wane rixa samyokletluna wa tsrukakalune sasertotene, ga wa wutsrukateneya giklukanuwnayegjixkalurni rupninripa. Ga wa koroshishkita rutakluna. ");
INSERT INTO pibNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Ga wa wixa kagwaklu Walepni wa Gisrayiline koshpakachripmaka. Ga wa tyekaka pnutetkani xawaknitkani mapgognetkani wane rixinritka. ");
INSERT INTO pibNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Ga wa pimrone suxone koxa wa wixanune koglajitwuna. Wa goyechnokawpotuko yomlechi yana. ");
INSERT INTO pibNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Gi rukshikmanetluna. Giyagni runatkana. Wane chinna klugimkoxakta retna, Goyakalutowrene. Wanna gima wane china ruwekgimataka. ");
INSERT INTO pibNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Wane koxa yapna pimrine wixaymalunenanu yomlechi yegi. Wa chinyawakpotukna suxone rixa getletluna. Seyni Wale gi retapna.” ");
INSERT INTO pibNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Giyagni Wale wane chinna, “Gaa mumata jemkangi. Mshinikangajingi wa galixinripa wa pejnuruko wa Goyakalu tokanu geneklewatachine chinyawaka. ");
INSERT INTO pibNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","¿Gi ge tyekaka rumkata salewnaletya wa Kristo, ga wa royaknu jiglokinripa?” ");
INSERT INTO pibNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Moysisi kirukate yinuwakya ga wa pejnuruneko tokanchi geneklewatachine kirukate, yokakyegitna pejnuruko yonpiranyegitkalurni Wale. ");
INSERT INTO pibNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Kayegikatkaluna pokchi rushinikyawakna. Wane rixa wa pnu yaletanutka. ");
INSERT INTO pibNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Ga wa wanna chipetlu. Wane chinruna, “Wixyempakyichi, gi rixanu kayistsitkani; nikawnagognemtanutka.” Giyagni jigloka. Wannayma rutukamta. ");
INSERT INTO pibNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Wane rixatka. Wannayma tuplanatini nikjetikowakaya, rawlo jimapro. Ruglenshinikanyegitlu. Jiknaglu. Reneksatna. ");
INSERT INTO pibNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Giyagni rumrekgatatkana. Rumatatkaluna. Ga wa Wale gamgamtatka wannaygaleya. ");
INSERT INTO pibNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Wane chinkakna wannakakluko, “¿Gi wixpokonshinikanunanumta wa gatnugapo ruynumsananumtinitkawu ga wa runkakpokowakatyawu wa yonatkalurkaka?” ");
INSERT INTO pibNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Walepapkoyakawa palnamtna. Gerosale satokna. Rukshiikana gapatanatachine pamole satupjene ga wa wannaymalune. ");
INSERT INTO pibNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Wane chinna, “Galikakni yotunomtatka Gitsrukaachi. Simo yegi rupgujewniyatka.” ");
INSERT INTO pibNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Giyagni wanna ginkaklewata wa gatnugapoya retanrukaknapirana, ga wa gi rixpoko gimatletatkaluna wa jimapro jiknajrotinritka. ");
INSERT INTO pibNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Wa yanumsatiniwana tyepirana, wanna ganikajite tunwatatka Geso. Wane chinna, “Kiglenshinikanupgi.” ");
INSERT INTO pibNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Giyagni wanna gimyeka. Pikanna. Samenru kagwakyaluna wa retyawakluna. ");
INSERT INTO pibNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Wale wane chinna, “¿Klu chinanu gkojwakanshinikanuta? ¿Klu chinanu wane gixa gishinikanuwgajreta? ");
INSERT INTO pibNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Getamyotanno ga wa nojixi, wa Gitakni. Gkamrukanno ga wa getanno. Gi rixanu wa samenchi gi kagitlu, gi kagaplu wa gixa getyawakno.” ");
INSERT INTO pibNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Wane rixinitka, rekakgimyotatkana ga wa gijixi. ");
INSERT INTO pibNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Gi ralixawana wa rumuwleyna ga wa ruglajreyna. Wane chinna, “¿Gi ge waneygi gewi pagixanu niikaluru?” ");
INSERT INTO pibNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Giyagni wanna psoji shima jimkaluro ganikyegitlu. ");
INSERT INTO pibNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Ga wa Wale yoptotlo. Wanna getanu nikatka. ");
INSERT INTO pibNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ga wa Wale wane chinna, “Tyenwa ntokanu nunkakyagi wa gixa yegi nwanatiniwa. Wa rumkata poyagkaakota pejnurkakako Gitapirana yonatkaluru, wa Moysisi Tokanu Yokanatkaluruya, ga wa Goyakalu tokanu geneklewatachine kirukateya, ga wa Shikalchi kirukateya.” ");
INSERT INTO pibNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Giyagni kotpukanshinikanutatkana wa rumata jemyapluna yonatkalurkaka. ");
INSERT INTO pibNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Ga wa wane chinna, “Wane rixyongata, wa Kristo salewninripa ga wa mapgogne chininripa yotunotinripa gipnachinetskalaya. ");
INSERT INTO pibNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Ga wa payinemnunanuka yegi runkakletikolupa giwakaya renshinikanutinripna kaspukmukochiretikolupna. Ga wa Gerosale yinuwakini. ");
INSERT INTO pibNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Gixni wa gipgujtatachinepgi tyepirana. ");
INSERT INTO pibNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Gixa yegi nyokanatanru Nuru gipiratanru. Ga wa gixa Gerosale Pokchi gitukanu, wa gitaakoklunpotunanuko tsru giyaklewlu potu tengogne giyakatyachri.” ");
INSERT INTO pibNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Wetanistsipotuko ranikna. Yotukamyota. Ruglenshinikanyegitna. ");
INSERT INTO pibNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Wane rixatka. Wa ruglenshinikanyeginatinitkana, wanna yegi konikatka. Tengogne raniikatka. ");
INSERT INTO pibNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Giyagni wanna yoptsojityegitlu. Wanepnute Gerosale satokatkana. Gimuwpotumtachinetka. ");
INSERT INTO pibNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Psolgogneko kpashiwakapji rawna. Goyakalu rumalwutna.");
INSERT INTO pibNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Yinuwakikolu wane rawa Tokanchi. Ga wa Tokanchi Goyakaluymananru. Ga wa Tokanchinwa Goyakalu. ");
INSERT INTO pibNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Yinuwakikolu Tyenwa Goyakaluyma. ");
INSERT INTO pibNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Ptowrunanuka kamrutka Waleya. Wale mwaknu gikenna kamrutka wa gwachritka. ");
INSERT INTO pibNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Wale rawa giweklu. Ga wa giweklunwa yine pokamlatyegitachri. ");
INSERT INTO pibNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Pokamlalu mapshagawaka pokamlatachri. Wa mapshagawaka gi gakagloklu. ");
INSERT INTO pibNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Waneru satu jeji Goyakalu yokanatanru. Gwa giwakatletachri. ");
INSERT INTO pibNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Wale gina rupgujtalewatinripa, rupgujtatyaplu pokamlalu, ralixinripna pejnuruneko wale chinanu. ");
INSERT INTO pibNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Gi wa pokamlalni wale, seyni runa rupgujtatyaplu pokamlalu. ");
INSERT INTO pibNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Tokanchinwa pokamlalu galikakpotunanu. Wa pejnuruko yineru pokamlatachri tye psolchijneko gapokachri. ");
INSERT INTO pibNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Tyechijne rawanata. Tye psolchijneko kamrutka Waleya. Tyechijne gajene gi gimatlu. ");
INSERT INTO pibNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Walenu runyegita Wale. Ga wa Walenune gi wa yoptotluna. ");
INSERT INTO pibNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Seyni pejnuruneko yoptotjene Wale gitakna Goyakalu wgenene rixinripna, wa ralixgiwakatjene. ");
INSERT INTO pibNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Wanna gi wa granchiko wugenetikna, gi wa manchi galukyawaka, gi wa jeji galukyawakako, seyni Goyakaluya wugenetikna. ");
INSERT INTO pibNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Tokanchiko manewata. Wixatskala rawanatapa. Wetlu royaknu. Girchi satupjerutu Gituru goyaknu waneylu. Kgimutlewaklerpotni. Galikakpotni. ");
INSERT INTO pibNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Gwa gipgujtatlu. Wane china sapleta, “Tyenwa nchinjenatanru, ‘Najxigi ginachripa, muchichachri gitaya, gi rixanu muchinanu gwachrini gitaya.’ ” ");
INSERT INTO pibNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Gi rixanu wane rixle gixoluruya wyoptojeta pejnurunekwu. Ga wa rumutlewle wanepnute rumutlewle potu wyoptota. ");
INSERT INTO pibNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Gi rixanu Moysisiya reneeka Tokanchi Yokanatkaluru. Wa Geso Kristo chinanu rawa gimutlewlu ga wa galikakpotunanu tokanchi. ");
INSERT INTO pibNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Gikena getlu Goyakalu gi pagogneko. Girchistsi gwachri, satupjerutu Gituru, Wale ginkakletlu. ");
INSERT INTO pibNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Tyenwa Gwa gipgujtale, wa Goteyone yokanatinitkana Gerosaleya sasertotene ga wa Rewinane repomgiyapluna, “¿Giryi pixa?” ");
INSERT INTO pibNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Rupgujetnawa Gwa. Gi wa nutatnawa. Rupgujetnawa, “Gi wa Kristono gita.” ");
INSERT INTO pibNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Repomgaluna, “¿Klunerkoxni? ¿Giliyaklayge pixa?” Wane china, “Gi waleno.” “¿Wa tokanchi geneklewatachrirayge?” Rugita, “Gike. Gi waleno.” ");
INSERT INTO pibNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Giyagni wane chinruna, “¿Gi gixachriyi? wunkakyapna wyokanatjene. ¿Gi pchinnawa pixnanuko?” ");
INSERT INTO pibNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Wane china: “Gitni giplaji yineru mwiyawakanu saplewatyachrino, wane chinachrino: Mpotukatanru Gitsrukaachigapo, wa Gisayiya tokanchi geneklewatachri chinyawaka.” ");
INSERT INTO pibNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Wa yokanatkalune, Gwariseyonenu. ");
INSERT INTO pibNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Repomgaluna. Wane chinruna, “¿Klu koxa pkatlewatya, wa Kristomigjekyi, gi wa Giliyyi, gi wa tokanchi geneklewatachrikoxyi?” ");
INSERT INTO pibNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Gwa gigitna. Wane chinna, “Gita katlewata gonuya. Seyni gixatskala rawa wa gixa mumatanutu. ");
INSERT INTO pibNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Walenwa gita gajxigi ginachri. Gi wa gita gimukluni wa nkoshpirokyaplu yoshmaklejixitsa.” ");
INSERT INTO pibNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Tyekaka wane gixkaluru Wetawara Pokchi, Gorta wakanute, wa Gwa katlewjetyawaka. ");
INSERT INTO pibNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Waleprikgogne Gwa getlu Geso wale yegi yachri. Wane china, “Getanru Gowega Wgene Goyakalunu, tye psolchijneko gajene konmukochiretachri. ");
INSERT INTO pibNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Tyenwa nchinjenatanru, satu jeji najxigi ginachripa, Walenwa muchichachri gitaya, gi rixanu muchinanu gwachrini gitaya. ");
INSERT INTO pibNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Gi numatanatlu. Seyni wa rumatikolupa Gisrayiline yegi, giyagni nuna gita nkatlewatinripa gonuya.” ");
INSERT INTO pibNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Wa Gwa gipgujtalewata. Wane china, “Netlu Giwekikaluru tengogne gijrukyachri. Motkoko pixka rixa Geso gogo gwachri. ");
INSERT INTO pibNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Gi numatanatlu, seyni wa nyokanatjeru gonu nkatlewatinripa, Wale wane chinno, ‘Wa Giwekikaluru peta gijruklegogwakatanru, Wale gogwaka gwachri, Walenwa Giwekikaluru Kpashiri katlewatyachri.’ ");
INSERT INTO pibNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Gita getlu. Nunkakletlu Tyenwa Goyakalu Wgene.” ");
INSERT INTO pibNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Waleprikgogne rumepe tunwaleta Gwa, ga wa gepi yimaklene. ");
INSERT INTO pibNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Rushinga yaletinri Geso, wane china, “Getanru gowega Wgene Goyakalunu.” ");
INSERT INTO pibNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Gepi yimaklene yijnako yanumsaletlu. Romkagitatkaluna Geso. ");
INSERT INTO pibNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Ruprotaka Geso. Retna rawgajxigitjene. Wane chinna, “¿Klu gijga?” Wa wanna wane chinru, “Rawi (walenwa yokaakaluru, Yimaklewatachri), ¿ginaka pwa?” ");
INSERT INTO pibNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Wane chinna Wale, “Ginanu. Getapanru.” Wane yana. Retluna ginakakta rawa. Walgogne rutukna Wale yegi. Kayinwakpapkotkani. ");
INSERT INTO pibNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Wa gepi Gwa yijnakotachine, romkagitjene, satni Gantirishi Simo Petro gepuru. ");
INSERT INTO pibNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Gantirishi gikshikgapkatlu waleko yegwaklu Simo. Wane chinru, “Wukshikatkalu Mesiya.” Walenwa yokaakaluru Kristo. ");
INSERT INTO pibNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Geso yegi raniklu. Geso getlu. Wane china, “Pixni wa Simo, Gona wgene. Pixa giwakatko Sega. (Walenwa yokaakaluru Sotlu.)” ");
INSERT INTO pibNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Waleprikgogne Kalile raluka yaleta Geso. Rukshiklu Wilipi. Wane chinru, “Pomkagitanno.” ");
INSERT INTO pibNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Wetsayta Pokchi gajerni Wilipi. Walenwa Gantirishi ga wa Petro pokchi. ");
INSERT INTO pibNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Wilipi gikshiklu Natanayli. Wane chinru, “Wukshikatkalu Moysisi yonyegitanru Tokanchi Yokanatkaluruya, ga wa tokanchi geneklewatachine koxa yonyegitanru. Gesni, wa Gosi wgene, Nasare Gajeru.” ");
INSERT INTO pibNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Natanayli wane chinru, “¿Nasarege rumkata giyakletya pagixanu kigleru?” Wilipi wane chinru, “Punanu. Petapanru.” ");
INSERT INTO pibNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Geso getanataplu Natanayli. Wane chinyegitlu, “Getanru satu galikakotunanu Gisrayili. Walenwa mayrokletu.” ");
INSERT INTO pibNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Natanayli wane chinru, “¿Ginaka pumatyano?” Geso gigita. Wane chinru, “Wilipi ma tomgakanuwayi, wa gikera rapukote pwanatini, netyi.” ");
INSERT INTO pibNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Rugita Natanayli. Wane chinru, “Rawi, Pixni Goyakalu Wgenyi. Pixni wa Gisrayiline Pogiryi.” ");
INSERT INTO pibNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Geso gigitlu. Wane chinru, “Gi rixanu wane nchinyi, ‘Netyi wa gikerampukoya,’ ¿palixge? Tyekaka pnute tsru petanu.” ");
INSERT INTO pibNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Wane chinru, “Galikakni, galikakni wane nchingi, xanikakayakawa getanru tengogne gitpukinri, ga wa Goyakalutowrene gatskomtachine, gijrukamtachine Gita Yineru Wgenno yegi.” ");
INSERT INTO pibNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Waleprika pnutgogne waneru kashimyolu Kana Pokchiya, Kalilesreta. Wanero Geso ginro. ");
INSERT INTO pibNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Chanixka koxa Geso ga wa yimaklene kashimyolu yegi. ");
INSERT INTO pibNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Winga magata. Wa Geso ginro wane chinru, “Winga maleshayna.” ");
INSERT INTO pibNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Wane chinro Geso, “¿Gi rixno Gita ga wa pixa, suxo? Gi rapokawa nopapko.” ");
INSERT INTO pibNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Runro wane chinna gipxaklewatachine, “Gkamrutanru klunerukokta runkakyagi.” ");
INSERT INTO pibNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Wanenanru patsrujire sotlu gashgaji, wa powratjetyawakna Goteyone. Gepi, mapa yokmajtagapi jigloklu satkaka. ");
INSERT INTO pibNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Wane chinna Geso, “Ntseptagatanru gonu tyekaka gashgaji.” Tsepotgapotutluna. ");
INSERT INTO pibNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Wane chinna Wale, “Nsajikgatanru xani. Nikikwaka chinanuwatyachri ganikyegitanru.” Ranikyegitluna. ");
INSERT INTO pibNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Wa retumginitkalo chinanuwatachri gonu kamrutikaluro winga, gi rumata ginaka tuyakatya, seyni wa gipxaklewatachine gonga saajegatachine gimata. Wa chinanuwatachri tomgalu gnunrowatachri. ");
INSERT INTO pibNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Wane chinru, “Pejnuruko yineru muchinanu rutaklo kiglero winga. Wa rumetinitkana rutakatkalo mugletotka. Ga wa pixa gimretlo xangognenanu kiglero winga.” ");
INSERT INTO pibNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Tyenwa muchinanu getkaluru kamruta Geso Kanaya, Kalilesretaya. Rekakgigoyaknuta. Ga wa yimaklene galixlu. ");
INSERT INTO pibNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Wale gowukshini yopika. Kapernawo yatka Wale ga wa runro, ga wa repurune, ga wa yimaklene. Gi gixgogne wane rawna. ");
INSERT INTO pibNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Gi gowukatkalu Tsru Giknoglushgogne Goteyonenu. Gerosale kanika Geso. ");
INSERT INTO pibNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Kpashiwakapji retyana wakane gishanretjetachine, ga wa gowegane gishanretjetachine, ga wa motkokone gishanretjetachine, wanepnute gipekserojiprojkakachine tuplatachine. ");
INSERT INTO pibNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Kochipjerewapitsa kamruta. Kpashiwakapji rerutyana pejnuruneko, ga wa gowegane, ga wa wakane. Rupkakyanna serojiprojna wa kgipekoklerune. Yawnajkaklo gikwalna. ");
INSERT INTO pibNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Motkoko gishanretjetachine wane china, “Gkoshpakanro wala gewiya. Gi wa Nurupjiko marnewakapji gkamrutini.” ");
INSERT INTO pibNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Giyagni yimaklene gishinkaplu yonatkalurni: Wane nixa jmerpotno pupji chinanu. ");
INSERT INTO pibNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Wa Goteyone wane chinru, “¿Klu getkaluru pekakgitwu wa tye pkamrutinri?” ");
INSERT INTO pibNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Rugita Geso. Wane chinna, “Gnikatanru tye kpashiwaka potu, ga wa mapgogne chininri ntunotakanru.” ");
INSERT INTO pibNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Giyagni wane chinna wa Goteyone, “Gepkoxamkojmole patsrujire walapu kamrupjinatkaluru tye kpashiwaka potu, ga wa Pixa ¿mapgognepje ptunotakanru?” ");
INSERT INTO pibNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Seyni Wale wane chinyegitlu gimanepirana kpashiwaka potu. ");
INSERT INTO pibNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Giyagni wa yotunotinitka gipnachinetskalaya, yimaklene gishinkaplu wa wane chinjenatinri. Ralixluna wa yonatkaluru, ga wa Geso chinyawaka. ");
INSERT INTO pibNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Tsru Giknoglushgogne, meyiwlugogne, Gerosale rawanatini gixo galixgiwakatlu. Retanatluna wa getkalurkaka kamrutini. ");
INSERT INTO pibNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Waleko Geso gi gaponshinikanyegitnawa wannayegiya, gi rixanu Wale gimatna pejnuruneko. ");
INSERT INTO pibNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Gi wa magatya wa satu gipgujtatyaplu yineru, gi rixanu Waleko gimatlu yineru gaji gwachri. ");
INSERT INTO pibNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Wanenanru jeji satu Gwariseyo, Nikotemo giwakatletachri. Goteyone gitsrukate. ");
INSERT INTO pibNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Tyenwa goyechno yayegitlu Geso. Wane chinru, “Rawi, wumatyi Goyakalu yegi ginyachriyi yimaklewatachri pixinripa. Gi rixanu gike gimkata kamruretlu tyekaka getkaluru wa Pixa kamrutanrukaka waleyma ma mixkanumka Goyakalu.” ");
INSERT INTO pibNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Rugita Geso. Wane chinru, “Galikakni, galikakni wane nchinyi, wa mumepe gishpakletkatu gi rumkata getletlu Goyakalu pogirewatyawaka.” ");
INSERT INTO pibNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikotemo wane chinru, “¿Gi rixpoko gishpakletatnaka satu jeji tsrutsolejinatka? ¿Rumkatge gimepe jiglokletanutnaklu runronanwaka, rushpakinripatnaka?” ");
INSERT INTO pibNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Rugita Geso, “Galikakni, galikakni wane nchinyi, satu ma wugenetikmaka gonuya ga wa Giwekikaluruya, gi rumkata jiglokletanru Goyakalu pogirewatyawaka. ");
INSERT INTO pibNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Ga wa manchi gishpakyachri manchini wale, ga wa Giwekikaluru gishpakyachri, giwekikalurni wale. ");
INSERT INTO pibNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Gi wa puglajitanu wa wane nchinyayi, gimkata gimepe gishpakletanutnaka. ");
INSERT INTO pibNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Wa kannipgyalu ginakakta raluka wane yannipgyata. Pyijnakpogimnutlu, seyni gi pumata ginakakta runya, ga wa ginakakta yanu. Wane rixa pejnuruko Giwekikaluru gishpakyachri.” ");
INSERT INTO pibNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Rugita Nikotemo. Wane chinru, “¿Gi rixpoko wane gixkotanu?” ");
INSERT INTO pibNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Rugita Geso. Wane chinru, “¿Pixni wa Gisrayiline yimakachriyi, ga wa gi ge pumatlu tyekaka? ");
INSERT INTO pibNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Galikakni, galikakni wane nchinyi, wa wumatanru wane wchina, ga wa wetanru wupgujtata. Gi gyoptotlu wupgujtatanru. ");
INSERT INTO pibNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Wa nunkakingi tyechijne gajerupirankaka, gi galixa, ¿gi gixpokotyawaka galixini wa tengogne gajerupirankaka nunkakingi? ");
INSERT INTO pibNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Gike gatskotlu tengogne, seyni wa tengogne gijrukyachripje, Gita wa Yineru Wgenno tengognerutno. ");
INSERT INTO pibNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Moysisi pixka yotunkakinri wa gimnu yineru mwiyawakanuya, waneko pixka nixa: numkata yotunkaakotanu Gita Yineru Wgenno. ");
INSERT INTO pibNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Wa pejnuruneko nalixjene ma mamginitipa, seyni waneyapna ruwekinrina gike rixiniko mnikawnakatu. ");
INSERT INTO pibNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","“Wane rixa galuklepotutna Goyakalu tye psolchijne gajeneko, giyagni renekna satupjerutu Gituru, wa pejnuruneko ralixjene ma mamginitipa, wa waneyapna ruwekinrina gike rixiniko mnikawnakatupa. ");
INSERT INTO pibNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Gi rixanu Goyakalu gi yokanatlu Gituru tyechijne ruklukanuwnayegjixyapna tye psolchijne gajeneko, seyni wa tye psolchijne gajeneko gognetkakikolupa Wale chinanu. ");
INSERT INTO pibNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Wa Gita galixachri gi ruklukanuwnayegjixko. Seyni malixakletu ruklukanuwnayegjixkanatka gi rixanu gi ralixgiwakatno Gita Goyakalu Wgenno satupjerutu. ");
INSERT INTO pibNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Tye chinanu Goyakalu giklukanuwnayegjixanru yineru, wa tye psolchijneko runa pokamlalu, ga wa yine galukpotutlu mapshagwaka pokamlalu pnute, gi rixanu mugletni wa kamrurna. ");
INSERT INTO pibNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Wa pejnuruneko mugletu kamrutachine gagnanutlu pokamlalu. Gi wa pokamlalu yegi yana ma mekakgi giklukanuwnaletikotupna kamrurna. ");
INSERT INTO pibNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Wa poyagkakachrii yayegitlu pokamlawaka, rekakgi kamruretikolupa Goyakaluya wane gixka.” ");
INSERT INTO pibNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Wanepnute Gotechijne ya Geso yimakleneyma. Wane rawjenatini wannayma. Katlewjixa. ");
INSERT INTO pibNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Katlewata koxa Gwa Genoya, Sali Pokchistsi, gi rixanu wane rawa gixo gonu. Wane yana. Katkalune. ");
INSERT INTO pibNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Gi rixanu gi wa yoshmaklewjetikwaka rutaakawa Gwa. ");
INSERT INTO pibNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Gwa yimaklene gigjekaka satu Goteyoyma powratjetikwakapiranaya. ");
INSERT INTO pibNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Yayegitluna wa Gwa. Wane chinruna, “Rawi, wa Gorta wakanute pixaymalutunanu, wa pupgujtajenatanru, petanru, katlewjixa. Ptowrunpotunanuko yayegitlu.” ");
INSERT INTO pibNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Rugitna Gwa. Wane china, “Gike rumkata yoptoleta yineru, seyni walepje wa Goyakalu genekyalu. ");
INSERT INTO pibNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Gixakni wa nupgujtatjengi wane nchinre, ‘Gi wa Kristono gita,’ seyni gitni wa yokanatkalurno Kristo penutete. ");
INSERT INTO pibNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Wa gnunrowatachri walenwa kganunrolu, Kristo pixka waneylu ralixjene. Wa gnunrowatachri galukjeru, walestsi gwachri, pixka nixa gita. Ralukjeru yijnakotlu gnunrowatachri tokanu, ga wa rumuwpotuta tokanu chinanu. Waneko pixka nixa gita. Numuwpotuta Kristo chinanu. ");
INSERT INTO pibNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Rumkata tsru gixleta Wale, ga wa gita giyagokananumtanu. ");
INSERT INTO pibNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“Ga wa teno giyakatyachri pejnuruneko pnute tsruni Wale. Ga wa chiji giyakatyachri, chiji gajerni wale. Tye chiji gajerupirana runkakleta. Ga wa tengogne giyakatyachri pejnurune pnute tsruni Wale. ");
INSERT INTO pibNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ga wa retanru, ga wa yijnakotanru Wale rupgujtata. Gike yopto gipgujtaletlu. ");
INSERT INTO pibNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Yopto gipgujtaletjeru runkakpokowakyegitlu wa Goyakalni wa poyagkakachri. ");
INSERT INTO pibNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Gi rixanu wa Goyakalu yokanatanru, Kristo, Goyakalu tokanu runkakleta. Gi rixanu gi reneklu Goyakalu Giwekikaluru kyagolu. ");
INSERT INTO pibNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Ruru galuklu Gituru. Ptowrunanuka reneklu gimyoya. ");
INSERT INTO pibNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Wa Goyakalu Wgene galixachri waneylu ruwekinri gike rixiniko mnikawnakatu. Seyni wa Goyakalu Wgene malixkatu gi retanru ruwekinri, seyni Goyakalu jigekanuwyeegognenatlu.” ");
INSERT INTO pibNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Giyagni wa Geso gimatlu wa Gwariseyone yijnakyegitlu Gwa pnute rixna yimaklene Geso. Katlewjixna. ");
INSERT INTO pibNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Gimka katlewata Geso, seyni yimaklenepje katlewata. ");
INSERT INTO pibNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Giyagni Gote rushpakya. Kalile satokanutnaka. ");
INSERT INTO pibNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Samarya rumkata yaplemta. ");
INSERT INTO pibNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Giyagni wane rapoka papokchi Samarisreta, Sicha chinkaluru pokchi, wanestsi wa Gakowo genekchijityalu gituru Gosi. ");
INSERT INTO pibNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Waneru Gakowni jitotkomgale. Giyagni Geso gama yagapleta. Wane tuplata gitkomgastsi. Tumananutkani. ");
INSERT INTO pibNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Samari gajero sato suxo gina sajkapgatachropa. Wa Geso wane chinro, “Putanno.” ");
INSERT INTO pibNT_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Gi rixanu yimaklene pokchi yatkana. Ragjitapluna niikaluru. ");
INSERT INTO pibNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Samari gajero wane chinru, “¿Gi pixkatge Pixni Goteyyi pagjitno wa nutyapyi, gitni wa Samari gajerno?” Gi rixanu Samaritanoneyma gi rumatletkakna Goteyone. ");
INSERT INTO pibNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Rugita Geso. Wane chinro, “Pixamka gimatanru Goyakalu genekashle ga wa Girni wa wane pchinjeru, ‘Putanno,’ pixa gagjitanmaklu Waleya. Walemka genekanyi gonu giwekachri.” ");
INSERT INTO pibNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Suxo wane chinru, “Gitokopna rawatkomgata. ¿Ginaka pguta waneyyi wa gonu giwekachri? ");
INSERT INTO pibNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","¿Pixlege wa wutsrukatni Gakowni pnute tsrurayge, wa tyetkomga wenekjerni, waleni koxa giiru, ga wa wugenene, ga wa giprane?” ");
INSERT INTO pibNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Rugita Geso, “Pejnuruneko tye gonu girachine, rumepe gonunnagatlewletanatnakna. ");
INSERT INTO pibNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Wa girukta girinri wa gonu Gita genekyaplu gi pagogneko ronunnagatewatanutnaka. Seyni wa gonu Gita genekyaplu gonutkomga pixka rixnanwakatanu, rushpakgatinri ruwekinri chinanu gike rixiniko mnikawnakatupa.” ");
INSERT INTO pibNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Suxo wane chinru, “Nutsrukate, penekanno tye gonu, gikekni gi nonunnagatewatanutka. Gi koxa gewi nsajkapinitka.” ");
INSERT INTO pibNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Geso wane chinro, “Ptomgapanru pganuru. Ginanu gewi.” ");
INSERT INTO pibNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Suxo gigita. Wane china, “Gi kganurno.” Geso wane chinro, “Wanepotuko pchina, ‘Gi kganurno,’ ");
INSERT INTO pibNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Gi rixanu pamyo pganurtapa. Ga wa xani wanerutu pganurmaka, gi wa pganurni. Galikakpotunanu wane pchinno.” ");
INSERT INTO pibNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Wane chinru suxo, “Nutsrukate, netyi tokanchi geneklewatachriyi. ");
INSERT INTO pibNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Wutsrukatenni tye magkate yonogyegitni. Wa gixa wane china, Gerosale gimkata yonogjetikwaka rixinripa.” ");
INSERT INTO pibNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Wane chinro Geso, “Suxo, palixanno, gipapko ginanu, gi wa tye magkateko, gi wa Gerosaleko gixa yonogyegitanru Girchi. ");
INSERT INTO pibNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Gixa yonogyegitlu gma mumatanutu. Wixa yonogyegitlu wumatanru. Gi rixanu Goteyone yegi ruyakatya gognewatikaluru. ");
INSERT INTO pibNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Seyni gipapko ginanu, xawaknitkani, wa galikakpotunanu kyonogiklerune yonogyegitanruna Girchi psolu rajyakoyna, galikakpotunanu. Gi rixanu Girchi gijgakoxna wane gixachine yonogyegityapluna. ");
INSERT INTO pibNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Goyakalni Giwekikaluru, ga wa yonogyegitjene Giwekikaluruya galikakpotunanu, rumkata yonogyegletluna.” ");
INSERT INTO pibNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Wane chinru wa suxo, “Numata gita wa Mesiya gininripa—Walenwa Kristo chinkaluru—wa Wale gininipa runkakanwu ptowrukopirana.” ");
INSERT INTO pibNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Geso wane chinro, “Walekno Gita giynumsatyi.” ");
INSERT INTO pibNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Wane rixanatawa rapokna yimaklene. Ruglajitna wa suxo ruynumsanatinri. Seyni gi satuna wane china, “¿Klu paluka?” waka “¿Klu puynumsatyalo wala?” ");
INSERT INTO pibNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Giyagni wa suxo tuknokgashgajremtatka. Pokchi tyatka. Wala wane chinna jejine, ");
INSERT INTO pibNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Ginanu. Getapanru satu jeji, wa pejnuruko nixyawaka nchinjeru. ¿Kristo getkokatkanwa Wale?” ");
INSERT INTO pibNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Giyagni pokchi yiyatkana. Yayegitluna Wale. ");
INSERT INTO pibNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Wanekopshini ragjitluna yimaklene. Wane chinruna, “Rawi, pnikanutka.” ");
INSERT INTO pibNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Wale wane chinna, “Waneyno nnijitu nnikanrupa wa gixa mumatanutu.” ");
INSERT INTO pibNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Giyagni wa yimaklene wane chinkakna, “¿Satu getko gwapnijitutlu?” ");
INSERT INTO pibNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Wane chinna Geso, “Nnijitni wa nkamrutanru nyokanatjeru gishinikanru, ga wa nnikatyaplu kamrure. ");
INSERT INTO pibNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","¿Gi ge wane nchina gixa, wa gepkoxamkoje ksuru magatiniwa rapokinripa wa jirgikolu? Giyagni Gita wane chinyagi, ntunogitanu. Getanru trikosha. Rutlikagwutatka jirgikolpatka. ");
INSERT INTO pibNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Jirgachri yoptotlu wenutikolu. Rapatjetlu wenutikolu gike rixiniko mnikawnakatupa, wa gitakachri koxa ga wa jirgachri koxa rumuwatinripna. ");
INSERT INTO pibNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Gi rixanu tye chinanu galikakpotunanni wa tokanchi, ‘Satni wa gitaklewatachri, ga wa satni wa jirgachri.’ ");
INSERT INTO pibNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Wa Gitni wa yokanatgi gjirgiyaplu wa gixa ma kamruretanutu. Pimrine yaprewpotuta, ga wa gixa kashrigna wanna kamrurenanu.” ");
INSERT INTO pibNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Wa gixo Samari gajene wale pokchi gajene galixlu suxo tokanu chinanu, gipgujtalewatachro. Wane china, “Runkakyano pejnuruko nixyawaka.” ");
INSERT INTO pibNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Giyagni Samari gajene runyegitinitkaluna, ragjitluna wane rutukinripachi. Wane rutuka gepgogne. ");
INSERT INTO pibNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Gixo wanepnute galixa Geso tokanuya. ");
INSERT INTO pibNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Wane chinrona suxo, “Gi wa ptokanuya walixatka, gi rixanu wixpotuko jematkalu. Wumata galikakpotunanu rixinri Tyenwa wa tye psolchijne gajeneko gognetkakachripatka.” ");
INSERT INTO pibNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Gepgogne chininri wane rushpakya. Kalile yatka. ");
INSERT INTO pibNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Gi rixanu Waleko Geso gipgujtatlu wa tokanchi geneklewatachine gichijneyna gi wa kagwakpiratikna. ");
INSERT INTO pibNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Giyagni Kalile rapokinitka, wa Kalile gajene yoptotlu, gi rixanu wa Gerosaleya retjetluna pejnurkakako wa tsrugogne kamrutanru. Gi rixanu wanna koxa wane ya meyiwlu yegi. ");
INSERT INTO pibNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Giyagni Kana yatnaka Geso, Kalilesreta, wa gonga winga kamrutyawaka. Kapernawo rawanata satu pogirchi gitakanru. Wale wgene yayixa. ");
INSERT INTO pibNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Wale yijnakyegitinitkalu Geso Gote ruyakatyatka. Kalile rapokatka. Geso yegi ya. Ragjitlu yopikinripa rutuukakyaplu gituru, gi rixanu rupnakastsinatkani. ");
INSERT INTO pibNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Giyagni Geso wane china, “Gma metkamkalu getkalurkaka, ga wa koglajrukaka, gi galixanu.” ");
INSERT INTO pibNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Pogirchi gitakanru wane chinru, “Nutsrukate, pyopikanu ma mupnakanuwa noturu.” ");
INSERT INTO pibNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Wane chinru Geso, “Pyanutka. Puturu giweka.” Wa jeji galixlu wa tokanchi Geso wane chinyalu. Yatka. ");
INSERT INTO pibNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Wa yopikamtinitka wayegrene gishpakamta yoptotpatkaluna. Runkakluna. Wane chinruna, “Puturu giweka.” ");
INSERT INTO pibNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Giyagni repomgana gipapko yinuwaka giglewleta. Wane chinruna, “Kapetgogne rutmayitini, rupachwalgatka.” ");
INSERT INTO pibNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Giyagni ruru gimatlu wanepapkonwa Geso wane chinru, “Puturu giweka.” Ralixa wale, ga wa pejnuruneko gipji gajene. ");
INSERT INTO pibNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Wa tye gepi chininri getkaluru kamrutatnaka Geso, Gote ruyakatinitka. Kalile yinitka. ");
INSERT INTO pibNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Wanepnute meyiwlugognetnakni Goteyonenu. Gerosale kanika Geso. ");
INSERT INTO pibNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Wa Gerosale, gowegane gipgyaptotestsi, waneru kawjetikwaka. Gewreyone tokanu wane chinika Wetesta. Wale waneya pamyotamnukaka. ");
INSERT INTO pibNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Wane ruklugna gixolune yayixachine, maygalene, yokmatachine, giprigmanetachine. Kagwakluna rakaykokgatikolupa gonu. ");
INSERT INTO pibNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Gi rixanu gipapko gapokini Gitsrukaachitowreru gijrukini kawjetikwaka. Rakaykokgatlu wa gonu. Rali gakaykokgatkoklunutka wa gonu, muchinanu gijrukgatachri kawjetikowakaya, wale gituka gi gixachrikokta yayixlu chinanu. ");
INSERT INTO pibNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Wanenanru satu jeji mapamole yokgipi walapu yayixachrinatka. ");
INSERT INTO pibNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Wa Geso getinri tye giklugachri, wa rumatinri gowukshini potu wane rawinri, wane chinru, “¿Paluka giglewletge?” ");
INSERT INTO pibNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Rugitlu wa yayixachri, “Gitsrukaachi, maleshayanno jeji nyoshmakjerupmaka wa kawjetikowaka wa rakaykokgatkoklunupa gonu. Wa nunakopshini gita satu gijrukgata muchinanu gitaya.” ");
INSERT INTO pibNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Wane chinru Geso, “Pyotunotanu. Pkoschekjekotanu. Pyanutka.” ");
INSERT INTO pibNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Waneklu ruglewatatka jeji. Koschekjekotatka. Yanamtatka. Gapnanutikalurgognenwa walegogne. ");
INSERT INTO pibNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Giyagni wa Goteyone wane chinru wa gigletkalurutka, “Gapnanutikalurugognewani. Ginanshichkalurni wa panikjekotinripa.” ");
INSERT INTO pibNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Wale gigitna, “Nugletjeru Walepotuko wane chinno, ‘Pkoschekjekotanu. Pyanutka.’ ” ");
INSERT INTO pibNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Giyagni repomgaluna, “¿Giru jejni wa wane chinyi, ‘Pkoschekjekotanu. Pyanutka?’ ” ");
INSERT INTO pibNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Wa gigletkalurutka gi gimatlu gi gixachritkani. Gi rixanu Geso gixrikamta, gi rixanu gi gepikna yine wane. ");
INSERT INTO pibNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Wanepnute kpashiwakapji Geso gikshikyalu. Wane chinru, “Petinwa. Pugletikolutka. Gi wa wanepnuteko pmukochirewatanutka, wane pnuterutu ma munyegityanpatkayi.” ");
INSERT INTO pibNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Wa jeji galimta. Runkakapna Goteyone, Gesoktanwa rugletjeru. ");
INSERT INTO pibNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Wale chinanu wa Goteyone kojwakananumtlu Geso. Raluka giylaletluna, gi rixanu wa tyekaka kamruta gapnanutikalurgogneko. ");
INSERT INTO pibNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Wa Geso wane chinna, “Xangognenanu kamrurewata Nuru, ga wa Gita koxa kamrurewata.” ");
INSERT INTO pibNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Giyagni wale chinanu pnute raluka giylaletluna Goteyone, gi rixanu gi wa gapnanutikalurgognepje gi rapnanuta, seyni wane china Ruru potu rixinri Goyakalu. Goyakaluko pixka rixnawa. ");
INSERT INTO pibNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Giyagni Geso gigita. Wane chinna, “Galikakni, galikakni, wane nchingi, gike rumkata kamrureta Walepje rixini Gituru, seyni wale rumkata wa Ruru reta kamruretanru, gi rixanu klunerukta kamruta Goyakalu, Gituru koxa waneko pixka gixa kamruretlu. ");
INSERT INTO pibNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Gi rixanu Girchi galuklu Gituru. Rekakgitlu pejnurkakako Wale kamrutanru. Tyekaka pnute tsru kamrurchi rekakgitanru wa gixa giglajitinripa. ");
INSERT INTO pibNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Gi rixanu Girchi wane gixa yotunkakletna gipnachine. Ruweekakna. Waneko pixka koxa rixa Gituru. Girukokta raluka giweekakleta, ruweekaklu. ");
INSERT INTO pibNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Gi rixanu Girchi gikena ruklukanuwnayegjixa. Seyni pejnuruko giklukanuwnayegjixlewlu reneklu Gituru. ");
INSERT INTO pibNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Kagwakpiratyapluna Ruruko pixka wa Gituru wa pejnuruneko. Wa Gituru mkagwakpiratkatu, gi koxa kagwakpiratlu Girchi wa yokanatjeru. ");
INSERT INTO pibNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Galikakni, galikakni wane nchingi, ntokanu yijnakotachri, nyokanatjeru galixachri waneylu ruwekinri gike rixiniko mnikawnakatu. Maleshayaplu ruklukanuwninripa. Gipnaluya rushpakamtya. Jigloklu giweklu. ");
INSERT INTO pibNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Galikakni, galikakni wane nchingi, rapokanu gigogne, xawaknini wa gipnachine yijnaktokanutinipno Gita Goyakalu Wgenno. Yijnakotachine giwekanu. ");
INSERT INTO pibNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Gi rixanu Girchi waneylu giweklu Walenanuko. Reneekoxlu Gituru waneko pixka nixinripa wa waneyapno giweklu Gitananuko. ");
INSERT INTO pibNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Rutaakoxno nuklukanuwnayegjixlewatinripa gi rixanu Yineru Wgenno. ");
INSERT INTO pibNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","“Gi giglajitanu tyeya, gi rixanu rapokanu gigogne wa pejnuruneko yomlechi gwachine yijnaktokanutanno. ");
INSERT INTO pibNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Kigleru kamrutachine gishpakanu yotunruyapa ruwekinripna. Wa gektutu kamrutachine yotunotanna ruklukanuwnayegjixikolupna. ");
INSERT INTO pibNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“Gike numkata kamrureta Gitapje nixini. Nyijnakotyawaka waneko pixka nixa giklukanuwnayegjixlewleta. Wanepotukni wa nuklukanuwnayegjixlewle. Gi rixanu gi nujgalu Gitako nushinikanru, seyni wa nyokanatjeru gishinikanru. ");
INSERT INTO pibNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Wa Gitnanuko gipgujtatinwa, wa nupgujtalewle gi wa galikakpotunanni. ");
INSERT INTO pibNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Satni wa gipgujtatno. Numata Gita wa rupgujtatanru Gitaya wanepotukni wale. ");
INSERT INTO pibNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","“Gixa yokanatna yine Gwa yegi. Wale gipgujtatlu galikakpotunanu tokanchi. ");
INSERT INTO pibNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Gi wa nyoptotlu wa yineru gipgujtalewle. Seyni tyekaka nchina wa gixa gognetkakikolupa. ");
INSERT INTO pibNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Gwanwa katalu xirnachri, pokamlatachri. Wa gixa galuka gimuwlepotuta pshinitsonu pokamlanuya. ");
INSERT INTO pibNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","“Waneyno Gita tsru potu gipgujtalewlu Gwanu pnute. Gi rixanu Girchi genekyano kamrurchi npoyagkakinripa. Waleko kamrurchi nkamrutanru, waleko gipgujtatno wa Girchi yokanatno. ");
INSERT INTO pibNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Wa nyokanatjeru Girchi Walekni gipgujtatno Gita. Gi pagogneko gjemaplajitlu gixa. Gi koxa getgetkowakatlu. ");
INSERT INTO pibNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Gi koxa waneygi tokanu gaji gwachri. Gi rixanu Goyakalu yokanatanruno, wa Gita gixa ma malixanutno. ");
INSERT INTO pibNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Getjepotutanru yonatkaluru tokanchi, gi rixanu gixa kagwaka waleya waneyapgi giwekinri gike rixiniko mnikawnakatu. Wale tokanchinwa gipgujtatno Gita. ");
INSERT INTO pibNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Gixa gi galuka ginyegletno waneygi gixinripa giwekinripa. ");
INSERT INTO pibNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Gi nyoptotlu gimalwuru yineya. ");
INSERT INTO pibNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","“Seyni Gita gimatyegitgi wa maleshaygi Goyakalu galuklewle gixa gwachri. ");
INSERT INTO pibNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Gita gina Nuru giwakaya. Gi gyoptotno. Satumka ginanu waleko giwakaya, wale gyoptotanu. ");
INSERT INTO pibNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","¿Gi gixpoko galixleta gixa, gixkakluko gimalwukakinri? Gi gijgalu wa satupjerutu Goyakalu kigle getle rixyapgi. ");
INSERT INTO pibNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","“Gi wa gyanshinikanutanru wa Gita jigyegitangi Girchiyegiya. Waneru gjigyegitjerupa. Moysisni wa gixa kagwakanshinikanutanru. ");
INSERT INTO pibNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Gi rixanu gixa galixanmaklu Moysisi, gitkoxmaka galixanu. Gi rixanu Gitapirana yonyegita wale. ");
INSERT INTO pibNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Gma malixiniplu wale yonatanru ¿gi rixyawaka galixtokanutinno?” ");
INSERT INTO pibNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Wanepnute Kalile tsru wenne wakanute yatka Geso. Walenwa Tiwerya wenne. ");
INSERT INTO pibNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Gixolune yine gomkagitlu, gi rixanu getkalurkaka retna, Wale kamrujetanru yayixachineya. ");
INSERT INTO pibNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Magka kanika Geso. Wane tuplata yimakleneyma. ");
INSERT INTO pibNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Gi gowukatkalu Tsru Giknoglushgogne, Goteyone meyiwatinrigogne. ");
INSERT INTO pibNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Giyagni tunogiygaleta Geso. Retna gixolune yine ginyegityawaklu. Geso wane chinru Wilipi, “¿Ginaka wagjitapinro jimapro wa nikinripna wanna?” ");
INSERT INTO pibNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Yantaletyalu wane chintokanuta, gi rixanu Wale gimatlu kamrutanrupa. ");
INSERT INTO pibNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Wilipi gigitlu, “Gepi pacha wenroluto jimapro gi poyagotanu satkaka ptsotsotajkaka yoptotinripna.” ");
INSERT INTO pibNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Satu yimakleru Gantirishi, Simo Petro gepuru, wane chinru, ");
INSERT INTO pibNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Gewlu satu mturu waneylu pamyo jimapro triko pixkalutu kamrutikaluru, ga wa gepi shima. Seyni ¿klu kigleylu wane pejnurune chinanu?” ");
INSERT INTO pibNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Giyagni Geso wane china, “Ntuplakakanna yine.” Waneru tsru peklomta. Tuplatna. Pamyo waragka getko jejine. ");
INSERT INTO pibNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Giyagni Geso gwalo jimapro. Rali poyagnutletinri, Wale geneksatna yimaklene. Wa yimaklene geneksatna tuplatachine. Waneko pixka rixlo shima ralukyawakpotukna. ");
INSERT INTO pibNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Wa jinanu rixinitkana, wane chinna yimaklene, “Gapatjetanru wa gixetachri psojkaka gike ma salewninitipa.” ");
INSERT INTO pibNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Giyagni rapatjetluna. Pamole gepi kojita tsepotna psojkaka wa pamyo jimapro triko pixkalutu kamrutikaluru, ruxetanruna nikanatachine. ");
INSERT INTO pibNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Giyagni wa jejine getinri getkaluru wa Geso kamrutanru, wane chinna, “Tyenwa galikakpotunanu tokanchi geneklewatachri tyechijne ginachripa.” ");
INSERT INTO pibNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Giyagni rumatini Geso wa rushinika kashretyapluna pogirna rutakyapluna, ruxrikamtatnaka. Magka ya Walepje. ");
INSERT INTO pibNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Kayi chininitka. Yopikamtna. Wenu yana yimaklene. ");
INSERT INTO pibNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Kanawa ruptekna. Tsru wenu wakanute, Kapernawosreta, yanna. Mapshagatkalu. Gi wa runyegitawana Geso. ");
INSERT INTO pibNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","¡Gi psoshpurgananuktalu tsru wenu, tsru rawokannipgyale chinanu! ");
INSERT INTO pibNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Giyagni ranikgatnimkatkana. Gepi waragkastsi, mapa waragkastsi getko gowuknu yatkana. Retluna Geso. Tsru wenu gogote yapamta. Gi gowukatkalu kanawa yegi. Pikanna. ");
INSERT INTO pibNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Wa Wale wane chinna, “Gitni. Gi mpikanu.” ");
INSERT INTO pibNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Giyagni raluka yoptoltapluna kanawaya. Wanekluyakawa tutspaka kanawa rushinikyawakna chiji. ");
INSERT INTO pibNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Waleprika gixolune yine tsru wenu wakanute gwachine getlo maleshlo sato wanepnute kanawa. Satopjero. Ga wa Geso gi gipteklo wala yimakleneyma. Wa yimaklenepje yatka. ");
INSERT INTO pibNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Seyni wa Gitsrukaachi gali poyagnutletlo jimapro, Tiweryawnaga tuknogamtya kanawkaka. Tiwerya giyakatyachrokaka. ");
INSERT INTO pibNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Giyagni wa gixolune yine geta gi wa Gesoko wanetka, gi wa yimakleneko. Wane retinitkana gixolune yine, kanawa ruptekatkana. Kapernawo yatkana. Wane rujgiyatkaluna Geso. ");
INSERT INTO pibNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Tsru wenu wakanute rukshikinitkaluna, wane chinruna, “Rawi, ¿Giklu papokatka gewi?” ");
INSERT INTO pibNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Rugitna Geso. Wane china, “Galikakni, galikakni wane nchingi, gi wa gijgano getkalurkaka getinri chinanu, seyni wa jimapro gnikinri ga wa jinangi gixinri chinanu gijgano. ");
INSERT INTO pibNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Gkamrurewatanu gi wa niikaluru gamgachri chinanu, seyni wa waneyapgi gwagognenatachri giwekinri mnikawnakatupa niikaluru chinanu gkamrurewatanu. Walenwa Gita Yineru Wgenno genekangi. Gi rixanu Girchi, Goyakaluko gimaxikoletno Gita.” ");
INSERT INTO pibNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Giyagni wane chinruna, “¿Klu wkamrutanu wa Goyakalu kamrure wkamruretinripa?” ");
INSERT INTO pibNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Rugita Geso. Wane chinna, “Tyenwa Goyakalu kamrure, wa gixa galixyaplu Wale yokanatanru.” ");
INSERT INTO pibNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Giyagni wane chinruna, “¿Klu getkaluru koxa pkamruta Pixa wa wetyaplu, wa walixyapyi? ¿Klu pkamruta? ");
INSERT INTO pibNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Wutsrukatenni niklo mana yineru mwiyawakanuya, yonchi chinyawaka: Jimapro tengogne giyakatyachro roglutna.” ");
INSERT INTO pibNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Wane chinna Geso, “Galikakni, galikakni wane nchingi, gi wa Moysisi genekgi wa tengogne giyakatyachro jimapro, seyni Nuru genekgi wa galikakpotunanu tengogne giyakatyachri jimapro. ");
INSERT INTO pibNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Gi rixanu Goyakalu jimapre Walenwa tengogne gijrukyachri, tye psolchijne gajeneko genekgiwekletachri.” ");
INSERT INTO pibNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Giyagni wane chinruna, “Gitsrukaachi, penekjetanwu tye jimapro.” ");
INSERT INTO pibNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Wane chinna Geso, “Gitni wa jimapro giwekikalurno. Nunyegitjeru gi pagogneko nachiplu. Nalixjerupa gi pagogneko ronunnagatewatanu. ");
INSERT INTO pibNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Seyni wane nchingi gixa, getmakno. Gi galixa. ");
INSERT INTO pibNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Pejnuruneko Girchi genekyano ginyegitanno. Wa nunyegitjeru gi wa maleka nuknoklu. ");
INSERT INTO pibNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Gi rixanu tengogne gijrukyachrino gi wa Gitako nushinikanru nkamrutinripa, seyni wa nyokanatjeru gishinikanru. ");
INSERT INTO pibNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Tyenwa nyokanatjeru Girchi gishinikanru, wa pejnuruneko renekyano gi satuna gamganu, seyni nyotunkakanru ralipregognepatka. ");
INSERT INTO pibNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Gi rixanu tyenwa nyokanatjeru gishinikanru, wa pejnuruneko Gituru getachine, Wale galixachine waneyapna ruwekinrina gike rixiniko mnikawnakatu. Gita yotunkakanna ralipregognepatka.” ");
INSERT INTO pibNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Giyagni Goteyone kegemgayegitlu wane chinre chinanu, “Gitni jimaprono tengogne gijrukyachrino.” ");
INSERT INTO pibNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Wane chinna, “¿Gi ge Gesokni wa tye, wa Gosi wgene, wa ruru, ga wa runro wumatna? ¿Gi rixkoxge wane china wa Tye, ‘Tengogne gijrukyachrino?’ ” ");
INSERT INTO pibNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Geso gigita. Wane chinna, “Gi gkegemganu Gitaya gixkakluko. ");
INSERT INTO pibNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Gi satuna gimkata ginyegletno Gita wa Girchi nyokanatjeru ma kosetanutu. Gita yotunkakanru ralipregognepatka. ");
INSERT INTO pibNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","“Yonatkalurni tokanchi geneklewatachine kirukateya: Goyakalu yimakanna pejnuruneko. Wa pejnuruneko Girchi yijnakotachine, yimaakalune runyegitnona. ");
INSERT INTO pibNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Gi wa satu getyalu chinanru Girchi, seyni Gitapje Goyakalu yegi giyakatyachrino netlu Girchi. ");
INSERT INTO pibNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Galikakni, galikakni wane nchingi, nalixjeru wale waneya ruwekinri gike rixiniko mnikawnakatu. ");
INSERT INTO pibNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Gitni wa jimapro giwekikalurno. ");
INSERT INTO pibNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Gitsrukatenni niklo mana yineru mwiyawakanuya, ga wa rupnanatkana. ");
INSERT INTO pibNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Gitni wa jimapro tengogne gijrukyachrino, wa tye nikachripa ma mupninitipa. ");
INSERT INTO pibNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Gitni wa jimapro giwekachrino, tengogne gijrukyachrino. Girukokta nikiniplu tye jimapro ruwekgognenatanu. Wa jimapro Gita geneklepa walenwa nogitu neneklepa ruwekinripna psolchijne gajene.” ");
INSERT INTO pibNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Giyagni Goteyone gejnugimyegkaka. Wane chinna, “¿Gi rixpoko genekletanwu Tye gigitu wnikyaplu?” ");
INSERT INTO pibNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Wane chinna Geso, “Galikakni, galikakni wane nchingi, gma niikanuplu nogitu, Gita Yineru Wgenno ga wa gma muragragatkanuplu nograga, maleshayapgi giwekinri gixa gwachri. ");
INSERT INTO pibNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Wa nnikgitutjeru, nuragragatjeru waneylu ruwekinri gike rixiniko mnikawnakatu. Gita yotunkakanru ralipregognepatka. ");
INSERT INTO pibNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Gi rixanu nogitni wa galikakpotunanu niikalurni, ga wa nograga galikakpotunanu girkalurni. ");
INSERT INTO pibNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Wa nnikgitutjeru, ga wa nuragragatjeru Gita rawa. Wale Gita gwa. ");
INSERT INTO pibNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Wane rixa yokanretno Girchi giwekachri, ga wa Girchi chinanu nuweka, waneko pixka rixa wa nnikjeru. Wale koxa giwekanu Gita chinanu. ");
INSERT INTO pibNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Tyenwa jimapro tengogne gijrukyachri. Gi wa gitsrukatenni pixka rixa, wa mana nikna. Wa gipnachinenatkani. Wa tye jimapro nikachri giwekgognenatanu gike rixiniko mnikawnakatu.” ");
INSERT INTO pibNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Tyekaka wane china ginkaklewwakapjiya, Kapernawo Pokchi runkaklewanatya. ");
INSERT INTO pibNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Wa gixo yimaklene yijnakonatinri, wane chinna, “Kgimlu tye tokanchi. ¿Katu gimkata yijnakletlu?” ");
INSERT INTO pibNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Wa rumatini Geso Walenanuko wa yimaklene kegemginri tye tokanchi chinanu, wane chinna Wale, “¿Tyerge gitspeekakgi? ");
INSERT INTO pibNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","¿Gi gixpokotanu wa getinipno Gita Yineru Wgenno teno nyinipa muchinanu nwanatyawaka? ");
INSERT INTO pibNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Wa Giwekikaluru Walenwa geneka giweklerewatachri. Wa manchi gike gaprini. Wa tokanchikaka Gita ginkakyagi, walenwa giwekikaluru ga wa giweklu. ");
INSERT INTO pibNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Seyni wanena pimrine gixate wa malixkane.” Gi rixanu Geso gimata yinuwakikoluyakawa ginnaktanwa malixkane, katupni wa samyokjerupa. ");
INSERT INTO pibNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Wane china, “Wale chinanu wane nchingi, gi satuna gimkata ginreta Gita yegi ma muchichkanru Girchi.” ");
INSERT INTO pibNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Wanepnute gixo yimaklene satkapa. Gi wa Waleyma yanatkana. ");
INSERT INTO pibNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Giyagni wane chinna Geso wa pamole gepi, “¿Gi ge galuka yaleta gixa?” ");
INSERT INTO pibNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simo Petro gigitlu, “Gitsrukaachi, ¿katyegmaka gayanu? Pixa waneya tokanchi giweklu mnikawnakatupirana. ");
INSERT INTO pibNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Wixa galixa. Wumatyi wa Kristoyi pixinri, Goyakalu giwekachri Wgenyi.” ");
INSERT INTO pibNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Geso gigitlu, “¿Gi ge ntsomitgi gixa wa pamole gepirungi? Ga wa gixa satu kamchini.” ");
INSERT INTO pibNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Gota Giskaryote wa Simo wgenepiranni wane china, gi rixanu walepni wa samyokjerupa. Walenwa pamole gepirune rixinrina. ");
INSERT INTO pibNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Wa wanepnute Kalile yapanata Geso. Gote gi raluka yapleta, gi rixanu Goteyone galuka giylaletlu. ");
INSERT INTO pibNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Gi gowukatkalu Goteyone meyiwatinrigogne, wa Gimajechrigogne. ");
INSERT INTO pibNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Repurune wane chinru, “Pyanutka gewiya. Gote pyanutka. Wa pyimaklene koxa getyaplu pkamrujetanru. ");
INSERT INTO pibNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Girukokta galuka kpogiru gixleta gi yogimatlu kamrure. Tyekaka pkamrutinri, pupgujetinwa psolchijne gajeneko yegi.” ");
INSERT INTO pibNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Gi rixanu gi wa repuruneko galixlu. ");
INSERT INTO pibNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Giyagni wane chinna Geso, “Nopapko gi wa rapokawa. Seyni waneygognenangi wa gipapko. ");
INSERT INTO pibNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Tye psolchijne gajeneko gi gimkata gayegixletgi gixa. Seyni Gita rayegixna. Gi rixanu Gita gipgujtatna wanna wa mugletu kamruretinrina. ");
INSERT INTO pibNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Gixa kanikanu tye meyiwlu yegi. Gichi nkanikanu Gita tye meyiwlu yegi. Gi rixanu gi wa poyagkaakawa nopapko.” ");
INSERT INTO pibNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Wane chininitkana, Kalile rutukatka. ");
INSERT INTO pibNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Wa meyiwlu yegi kanikinitkana repurune, gowukshini kanikatka Geso koxa. Gi wa gipgujewnachri, seyni pochkeru pixkako. ");
INSERT INTO pibNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Giyagni rujgaluna Goteyone meyiwluyegiya. Wane chinna, “¿Ginaklu wa Wale?” ");
INSERT INTO pibNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Tsru gixaxkaklu rixna gixolune yine Gesoya. Wa pimrine wane china, “Kiglerni.” Pimrine wane china, “Gike. Seyni Wale yokwitna yine.” ");
INSERT INTO pibNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Seyni gi satuna pgujetanwaka yanumsayegitlu Goteyone piklena chinanu. ");
INSERT INTO pibNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Ganikaji meyiwlu kanika Geso. Kpashiwakapji ya. Wane runkaklewatya. ");
INSERT INTO pibNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Giyagni ruglajitna Goteyone. Wane chinna, “¿Gi rixpoko gimatletlu wa Tye wa yonchi? Gi wa yimaakalurni.” ");
INSERT INTO pibNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Geso gigitna. Wane china, “Nunkaklewle gi wa Gitanukni, seyni wa nyokanatjerunni. ");
INSERT INTO pibNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Girukta galuka kamruretlu nyokanatjeru gishinikanru rumatanru nunkaklewlepirana, Goyakalunrege waka Gitako ntokanra. ");
INSERT INTO pibNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Waleko tokanu ginkakletachri, waleko rumalwutikolu rujga. Seyni wa yokanatjeru gimalwutikolu gijgachri, walenwa galikakpotunanu. Maleshaylu wale mpoyagkaknuchi. ");
INSERT INTO pibNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","¿Gi ge Tokanchi Yokanatkaluru renekgi Moysisi, ga wa gixa gi satuna kamrutlu Tokanchi Yokanatkaluru? ¿Kluneru chinanu galuka giylaletno?” ");
INSERT INTO pibNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Yine gigita. Wane chinna, “Kamchi waneyyi. ¿Katu galuka giylaletyi?” ");
INSERT INTO pibNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Geso gigitna. Wane chinna, “Satu kamrurchi nkamruta. Wa pejnurunekgi gixa giglajita. ");
INSERT INTO pibNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Galikakni Moysisi genekgi wa sajruku gistaklewlu (seyni gi wa Moysisi runya, seyni wa gitsrukaachinni runya) ga wa gapnanutikalurgogne gixa sajruka gistakletlu jeji. ");
INSERT INTO pibNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Wa gapnanutikalurgogne sajruka gistakikolupa jeji wa Tokanchi Yokanatkaluru Moysisinu ma kaspukikotupa, ¿gimtuwnayegitnoge gixa wa gapnanutikalurgogne nutuukakpotutyalu satu jeji? ");
INSERT INTO pibNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Gi gitakyagoklewatanu rixa getletikwaka chinanu, seyni wanepotuko gitakyagoklewatanu.” ");
INSERT INTO pibNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Giyagni wane chinna pimrine Gerosale gajene, “¿Gi ge Walekni wa Tye wa raluka giylaletanruna? ");
INSERT INTO pibNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Getanu. Gipgujewnachri yanumsata. Gike chinruna. ¿Rumatatkaluna xani galikakpotunanu tsrukakalune wa Kristo rixinri? ");
INSERT INTO pibNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Seyni wa Tye wumatlu ginaka giyakatyachrini. Seyni wa Kristo gininipa gike gimata ginakakta ruyakatini.” ");
INSERT INTO pibNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Giyagni kpashiwakapji runkaklewanatini Geso, saplewata. Wane china, “Gimatno Gita. Ginaka giyakatyachrino gimata. Gi wa Gitako nushinikanu nuna. Seyni wa nyokanatjeru galikakpotunanni Wale, wa gixa mumatanutu. ");
INSERT INTO pibNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Gita gimatlu, gi rixanu Walenno. Ga wa Wale yokanatno.” ");
INSERT INTO pibNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Giyagni raluka kashretluna, seyni gi satuna gomyokyegitlu gi rixanu gi wa gipapko gapokawa. ");
INSERT INTO pibNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Gixo Wale galixachine wane gixolunetskala. Wane chinna, “¿Wa Kristo gininipa, getkalurkakapa wa Tye kamrutanrupnutlege kamrutanu Wale? Gike.” ");
INSERT INTO pibNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Wa Gwariseyone yijnakotna gixolune yine kegemgiyawakna Walepirankakako. Tsrukakalune sasertotene ga wa Gwariseyone yokanatna gitowrenna wa kashichyapluna. ");
INSERT INTO pibNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Geso wane china, “Pshinitsonuchi numwamtangichi. Nyokanatjeru yegi nyanutka. ");
INSERT INTO pibNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Gijganmakno. Gi gikshikanutkano. Wa nwiyawakapa gixa gi gimkata yaletanu.” ");
INSERT INTO pibNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Giyagni wa Goteyone wane chinkaka wannakakluko, “¿Ginaka rushinika yaletge wa Tye wma mukshikyanpatkalu? ¿Rushinika yaletge gitspalatachine, Kriykonetskala gwachine yegi, runkaklewyegityapna Kriykone? ");
INSERT INTO pibNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿Klupiranni wa tye wa Wale wane chinya? Wa, ‘Gijganmakno. Gi gikshikanutkano. Wa nwiyawakapa gixa gi gimkata yaletanu.’ ” ");
INSERT INTO pibNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Ralipregogne, tsru meyiwlugogne potu, Geso tunwata. Saplewata. Wane china, “Girukokta gonunnagatewata runyegitanno. Ruranu. ");
INSERT INTO pibNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Yonchi chinyawaka, Gonu giwekachri yapgatyawaka pixka rixa gishpakletanu ginanwakaya nalixjeru.” ");
INSERT INTO pibNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Giwekikalurupiranni china wa tye tokanchi, wa ralixjenepa yoptotanrupni Wale. Gi rixanu gi rapyegitawana Giwekikaluru Kpashiri, gi rixanu Geso gi wa royakawatyawaka jiglokawa. ");
INSERT INTO pibNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Giyagni gixolune yijnakotinri tyepirana, pimrine wane china, “Galikakpotunanni Tyenwa tokanchi geneklewatachri.” ");
INSERT INTO pibNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Pimrine wane china, “Kristokni wa Tye.” Pimrine wane china, “¿Kalilege ruyakatini Kristo? Gike. ");
INSERT INTO pibNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","¿Gi ge wanekni china yonchi wa Tawiklopisha, Wetle Pokchirge, Tawi gwanatyawaka, wane ruyakatinripa Kristo?” ");
INSERT INTO pibNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Giyagni wannakakluko kotspalanshinikankakna gixolune Geso chinanuya. ");
INSERT INTO pibNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Wa pimrine galuka kashretlu, seyni gikena gomyokyegitlu. ");
INSERT INTO pibNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Giyagni towrechine gapyegitna tsrukakalune sasertotene ga wa Gwariseyone. Wane chinkana towrechine, “¿Klu chinanu gi ganiklu?” ");
INSERT INTO pibNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Wa towrechine gigita, “Gi pagogneko Wale pixka rixa ginkakleta satu yineru tye jeji pixka.” ");
INSERT INTO pibNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Giyagni wa Gwariseyone gigitna. Wane chinkana, “¿Gixkoxnirge yokwitkanatka? ");
INSERT INTO pibNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","¿Ralixluge satu tsrukakalu, ga wa satu Gwariseyo? Gi ralixluna. ");
INSERT INTO pibNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Seyni wa nyi gixolune, Tokanchi Yokanatkaluru mumatkane, kamakpiratkalunni.” ");
INSERT INTO pibNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Wane chinna Nikotemo (Goyechno yayentapjeru. Walenwa Gwariseyone satute). ");
INSERT INTO pibNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Tokanchi Yokanatkaluru wixanu gi giklukanuwnayegjixlu yineru ma muchinanu jempiranyegitkanuwalu, rumatikolupa wale kamrutanru.” ");
INSERT INTO pibNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Rugitluna Nikotema. Wane chinruna, “¿Kalile gajerkoxlayge pixa? Petjetanru. Pumatanru. Gi pagogneko Kalile rupgujewnini tokanchi geneklewatachri.” ");
INSERT INTO pibNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Satkaka gipji yatka. ");
INSERT INTO pibNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Wa Geso Goliwa Magkate yatka. ");
INSERT INTO pibNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Goyechnokawpotuko kpashiwakapji yatnaka Geso. Pejnuruneko yine ginyegitlu. Tuplata Geso. Runkaklewyegitna. ");
INSERT INTO pibNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Wa yonchikgapine ga wa Gwariseyone ganiklo sato suxo Wale yegi. Tkashichka tumopatlewanatyawakaya. Ganikaji rutaklona. ");
INSERT INTO pibNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Wane chinruna, “Yimaklewatachri, twu suxo kashichka tumopatlewanatyawakpotukoya. ");
INSERT INTO pibNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Wa Tokanchi Yokanatkaluruya, Moysisi towutwu sotlujetikolupna wane gixachrone. Ga wa Pixa, ¿gi pchina Pixa?” ");
INSERT INTO pibNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Wane chinna yantaletyaluna rumkata jigyegletyapluna. Geso yonogimta. Chiji yonawata gimyojiya. ");
INSERT INTO pibNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Romkaga gepomsaletinitkaluna, potukawata. Wane chinna, “Girukokta gixa satu mmukochiretu, wale gapka ginkaganro sotluya.” ");
INSERT INTO pibNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Rumepe yonogletatnaka. Chiji yonawatatnaka. ");
INSERT INTO pibNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Wa yijnakotinitkana, yatkana. Satkaka yananumta. Muchinanu tsrutsoleji potu ga wa gapkatatachripotunanuko. Gesopje giknokamtkatka, ga wa suxo ganikaji gwanatachro. ");
INSERT INTO pibNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Potukawatatnaka Geso. Gi satuna retatka. Suxopjetkani. Wane chinro, “Suxo, ¿ginakatkana pjigyegitjene? ¿Gikena giklukanuwnayegjixyi?” ");
INSERT INTO pibNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Wala wane china, “Gi satuna, Gitsrukaachi.” Geso wane chinro, “Gi Gitako giklukanuwnayegjixyi. Pyanutka. Gi wanepnuteko pmukochirewatanutka.” ");
INSERT INTO pibNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Wa Geso yanumyegitatnakna. Wane china, “Gitni tye psolchijne gajeneko pokamlatyegitachri. Wa nomkagitjeru gi wa mapshagwaka yananu, seyni waneyaplu pokamlalu giweekaklewatachri.” ");
INSERT INTO pibNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Giyagni Gwariseyone wane chinru, “Pixnanuko gipgujtatnawa. Wa pupgujtalewle gi wa galikakpotunanni.” ");
INSERT INTO pibNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Rugita Geso. Wane chinna, “Gitnanukmaka gipgujtatnawa. Nupgujtalewle galikakpotunanni. Gi rixanu numata Gita ginaka nuyakatya ga wa ginaka nyanu. Wa gixa gi gimata ginaka nuyakatya ga wa ginaka nyanu. ");
INSERT INTO pibNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Wa gixa giklukanuwnajixlewata rixpokmanetyawaka. Gita gi satuna nuklukanuwnayegjixa. ");
INSERT INTO pibNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Gita giklukanuwnajixlewatini nuklukanuwnajixlewle galikakpotunanni, gi rixanu gi wa Gitapjeni, seyni Gita ga wa nyokanatjeru, Girchi. ");
INSERT INTO pibNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Wa Tokanchi Yokanatkaluru gixanu wane yonatika: Gepi jejine gipgujtalewle galikakpotunanni. ");
INSERT INTO pibNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Gitni wa Gitnanuko gipgujtatnachriwano, ga wa nyokanatjeru Girchi gipgujtatno Gita.” ");
INSERT INTO pibNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Wane chinruna, “¿Ginaklu Puru?” Geso gigita, “Gi gimatno Gita, gi wa Nuruko. Gitamka gimatanu, Nurkoxmaka gimatanu.” ");
INSERT INTO pibNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Tye tokanchikaka wane chinya Geso sroschi gignantakikwaka, kpashiwakapji runkaklewatini. Gi satuna kashichlu gi rixanu gi wa gipapko gapokawa. ");
INSERT INTO pibNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Giyagni rumepe wane chinretatnakna Geso, “Nyanutka. Gijganmakno, seyni gixapni gmukochire gimupnanuna. Nyiyawakapa Gita gixa gi gimkata wane yaletanu.” ");
INSERT INTO pibNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Giyagni wane chinna Goteyone, “¿Walenanuklege giylatinwa? Giyagoka gonra wane china, ‘Nyiyawakapa Gita, gixa gi gimkata wane yaletanu.’ ” ");
INSERT INTO pibNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Wane chinna Geso, “Gi wa teno gajengi gixa. Gitni wa teno gajerno. Gixni wa tyechijne gajengi. Gi wa tyechijne gajerno Gita. ");
INSERT INTO pibNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Giyagni wane nchingi wa gmukochire gimupnanuna. Gi rixanu, gma malixkanupmakno Gita nixinri gmukochire gimupnanuna.” ");
INSERT INTO pibNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Giyagni wane chinruna, “¿Gi gixachriyi Pixa?” Wane chinna Geso, “Wa muchinanu nunkakyagi. ");
INSERT INTO pibNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Waneyno gi gepika nunkakletpiranatyapgi, nuklukanuwnayegjixapgi, seyni wa nyokanatjeru galikakpotunanni. Wa Waleya nyijnakotinri Gita, wale nunkakleta tyechijneya.” ");
INSERT INTO pibNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Wa Girchipirana runkakyana. Gi rumata jemluna ");
INSERT INTO pibNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Giyagni Geso wane chinna, “Wa gixa yotukinpatkano Gita wa Yineru Wgenno, waneklu gimatanutkano wa Gita nixinri, ga wa gike nkamruta Gitnanuko, seyni wa Girchi yegi numatinri wale nunkakleta. ");
INSERT INTO pibNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Gitaymalu wa nyokanatjeru. Gi rutspaltapyano Gitapje nixinri Girchi. Gi rixanu Gita kamrujetlu rugleretjetyawaka.” ");
INSERT INTO pibNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Tyepirana runkakletini, gixo galixlu Wale. ");
INSERT INTO pibNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Giyagni wane chinna Goteyone ralixjenetka, “Wa ntokanu gomkayegitini, galikakpotunanu nyimaklenepgi. ");
INSERT INTO pibNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Gixa gimatanru galikakpotunanu tokanchi. Galikakpotunanu tokanchi koshpakangi wayegrechine gma mixinitipa.” ");
INSERT INTO pibNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Rugitluna, “Gawraklopishanwu wixa. Gike wayegrenenanwu, gi pagogneko. ¿Gi pchinkoxge Pixa, ‘Gishpakachinepgi?’ ” ");
INSERT INTO pibNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Rugitna Geso, “Galikakni, galikakni, wane nchingi, wa pejnuruneko mukochri kamrutachine, mukochri wayegrenni. ");
INSERT INTO pibNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Wa wayegrechri gi wa panchi rawgognenatanu. Wgenchi gwagognenatanru. ");
INSERT INTO pibNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Giyagni wa Gituru koshpakinipgi, galikakpotunanu gishpakachinepgi. ");
INSERT INTO pibNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Numatgi Gawraklopishangi gixinri, seyni galuka giylaletno, gi rixanu wa ntokanu gi wa gwagi. ");
INSERT INTO pibNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Gita ginkakletlu wa Girchistsi netinri, ga wa gixa kamrutlu wa girustsi gjeminri.” ");
INSERT INTO pibNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Rugitluna. Wane chinruna, “Wurni Gawrani.” Wane chinna Geso, “Gawra wgenengi gixkamka, Gawra kamrujetanrumka gkamrutanu. ");
INSERT INTO pibNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Ga wa xani galuka giylaletno, jeji tokanchi galikakpotunanu ginkakjerno. Wale tokanchi Goyakalu yegi njeminri. Gi wale kamruta Gawra. ");
INSERT INTO pibNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Gixa kamrutlu girni kamrure.” Wane chinruna, “Wixa gi wa gapoklewlu chinanu wushpakya. Pagirupje waneywu. Walenwa Goyakalu.” ");
INSERT INTO pibNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Wane chinna Geso, “Wa Goyakalu girutkamka, galukanmakno galikaka. Gi rixanu Goyakalu yegi nuyakatya Gita. Gewi napoka. Gi rixanu koxa gi wa Gitako nushinikanu nuna, seyni Wale yokanatno. ");
INSERT INTO pibNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿Klu chinanu gi gimata jemlu nunkakletjetanru? Gi rixanu gi gimkata yijnakletlu ntokanu. ");
INSERT INTO pibNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","“Gixni wa giru giyakatyachingi. Walenwa tsru kamchi. Giru getsotanrewle galuka kamrureta. Reyinuwakleyakawa kgiylalewaklerni wale. Galikakpotunanu tokanchiya mwakatni wale. Gi rixanu maleshaylu wale galikakpotunanu. Rayroklewatini, waleko rushinikanu china, gi rixanu kayroklerni. Gayroklu girni. ");
INSERT INTO pibNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Gixa gi galixno, gi rixanu Gita galikakpotunanu nchina. ");
INSERT INTO pibNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","¿Katu wa gixa gimkata gekakgi giklukanuwnaletyano wa nmukochirewatinritka? Galikakpotunanu nchinini, ¿klu chinanu gi galixno? ");
INSERT INTO pibNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Goyakalu yegi giyakatyachri yijnakotlu Goyakalu tokanu. Giyagni gi gyijnakotlu gixa, gi rixanu gi wa Goyakalu yegi giyakatyachingi.” ");
INSERT INTO pibNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Rugitluna Goteyone. Wane chinruna, “¿Gi ge wanepotuko wchina wixa, wa Pixni wa Samari gajeryi, ga wa waneyyi kamchi?” ");
INSERT INTO pibNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Rugita Geso, “Maleshayno kamchi, seyni nkagwakpiratlu Nuru, ga wa gixa mkagwakpiratkotu gixno. ");
INSERT INTO pibNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Gi wa nujgalu numalwutikolupa. Waneru wa nujga gimalwuretjeru. Waneru kgitakyagoklewakleru. ");
INSERT INTO pibNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Galikakni, galikakni wane nchingi, ntokanu gomkagitachri gike rixiniko retanru gipukchi.” ");
INSERT INTO pibNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Wane chinruna Goteyone, “Xawakni wumatanatkayi waneyyi kamchi. Gawrani gipnana ga wa tokanchi geneklewatachinni. Ga wa Pixa wane china, ‘Wa ntokanu gimretachri gike rixiniko retumganru gipukchi.’ ");
INSERT INTO pibNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿Pixlege wa wutsrukatni Gawrani pnutepgutyi? Wale gipnachrinatka. Ga wa tokanchi geneklewatachinni gipnana. ¿Katu pixnawa Pixnanuko?” ");
INSERT INTO pibNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Rugita Geso, “Gitnanuko gimalwutinwa, gike gaprini numalwure. Nuru genekno numalwutikolupa. Walenwa wa gixa Goyakalute nchinanru. ");
INSERT INTO pibNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Gixa gi gimatlu, ga wa Gita gimatlu. Gi numatlu, nchinanmaka Gita, gixa pixkamka nixanu kayroklerupmakno. Seyni numatlu. Numretatokanutlu. ");
INSERT INTO pibNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Gawrani gitsrukatni rumuwatni retgognetinno nogogne. Retlu ga wa rumuwatni.” ");
INSERT INTO pibNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Giyagni wane chinruna Goteyone, “Gi pamyomole walapuunawayi. ¿Petnirge Gawrani?” ");
INSERT INTO pibNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Wane chinna Geso, “Galikakni, galikakni wane nchingi, Gawrani mwakanuwa, nwatka Gita.” ");
INSERT INTO pibNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Giyagni koscheksotletna sotlujetyapluna. Wa Geso yogimata. Kpashiwakapji rushpakamtya. ");
INSERT INTO pibNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Wane yapamtini Geso retlu satu jeji rushpakiniyakawa maygaletu. ");
INSERT INTO pibNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Yimaklene gepomgalu. Wane chinruna, “Rawi, ¿katu mukochirewata, waleko waka rurune, wa maygaletu rushpakinriya?” ");
INSERT INTO pibNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Rugita Geso, “Gi tyeko mukochirewata, gi wa ruruneko, seyni wa Goyakalu kamrure gipgujewninripa waleya. ");
INSERT INTO pibNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Numkata kamrurewleta wa nyokanatjeru kamrurkaka gogikopshini. Goyechno gina. Waneklu gikeko gimkata kamrurewleta. ");
INSERT INTO pibNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Tyechijne nwakopshini, tye psolchijneko pokamlatachrino.” ");
INSERT INTO pibNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Wane chininitka, chiji rutskagata. Rugakajpatlu gitskagaya. Maygaletuygale sagajpatlu kajpa. ");
INSERT INTO pibNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Wane chinru, “Gajewa. Kawjetikwaka Silowega perkapinwa.” Silowe walenwa yokaakaluru, Yokanatkaluru. Giyagni wane ya. Rerkinawa. Getachri ginatka. ");
INSERT INTO pibNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Giyagni wa rumwastsitanune, ga wa muchikawa retanatjene wa maygaletu rixanatini, wane chinna, “¿Gi ge walekni wa tye, wa tuplajenatachri gagjijenatachri?” ");
INSERT INTO pibNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Pimrine wane china, “Walekni.” Ga wa pimrine wane china, “Gike, seyni wale pixka rixa.” Waleko wane china, “Gitakni.” ");
INSERT INTO pibNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Giyagni wane chinruna, “¿Gi pixpoko gimrekgaletatka?” ");
INSERT INTO pibNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Rugita wale. Wane china, “Wa jeji Geso giwakatletachri, kamrujpatlu kajpa. Sagaygaletno. Wane chinno, ‘Gajewa. Silowega perkapinwa.’ Wane nya. Nerkinawa. Netatka.” ");
INSERT INTO pibNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Wane chinruna, “¿Ginaklu Wale?” Wale wane china, “Goo. Gi numata.” ");
INSERT INTO pibNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Gwariseyone yegi ranikluna maygaletunanu. ");
INSERT INTO pibNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Gapnanutikalurgognenwa Geso kamrujpatlu kajpa, rumrekgakakatkalu. ");
INSERT INTO pibNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Giyagni rumepe gepomgaletatnakluna Gwariseyone gi rixpoko getletatka. Wale wane chinna, “Kajpa sagaygaletno. Nerkinawa. Netatka.” ");
INSERT INTO pibNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Giyagni pimrine Gwariseyone wane china, “Tye jeji gi wa Goyakalu yegi giyakatyachrini, gi rixanu gi wa gapnanutikalurgogne rapnanuta.” Pimrine wane china, “¿Gi rixpoko gimkata kamruretlu tyekaka getkalurkaka satu jeji kmukochireru?” Wannakakluko kotspalanshinikankakna. ");
INSERT INTO pibNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Giyagni rumepe wane chinretatnakluna maygaletu, “Ga wa pixa, ¿gi pchina pixa Waleya, gi rixanu rumrekgakakyi?” Wale wane china, “Tokanchi geneklewatachrini.” ");
INSERT INTO pibNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Giyagni gi ralixpiranyegitluna Goteyone wa maygaletu rixanatinri, ga wa retinritka. Gi ralixluna tomginpotunanukna rurune rugletaygaletikolutka. ");
INSERT INTO pibNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Repomgakna. Wane chinkana, “¿Tyenwa gituru, wa gixa wane chinanru maygaletu gishpakyachri? ¿Ga gi rixpoko getletatka?” ");
INSERT INTO pibNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Giyagni rugitna rurune. Wane chinna, “Wumatlu tyenwa wixa wgene wa maygaletu gishpakyachri. ");
INSERT INTO pibNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Gikta rixpoko getletatka gi wumata. Katukta gimrekgakaklu gi wumata. Gepomganru wale. Tsrutkani wale. Walenanuko ginkakletinwa.” ");
INSERT INTO pibNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Wane chinna rurune gi rixanu Goteyone pikanna. Gi rixanu Goteyone yijnaakakatkana wa satu gipgujtatinri wa Mesiya rixinri, ruknooko maleka ginkaklewawakapjiya. ");
INSERT INTO pibNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Giyagni rurune wane china, “Tsrutkani. Gepomganru wale.” ");
INSERT INTO pibNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Giyagni rumepe tomgaletatnakluna wa jeji maygaletunanu. Wane chinruna, “Pumalwutanru Goyakalu. Wixa gimatlu tye jeji kmukochirerni.” ");
INSERT INTO pibNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Giyagni wale gigita. Wane china, “Kmukochireru rixinri, gi numata. Satupje numata, wa maygaletu nixanatinri, xawakni netatka.” ");
INSERT INTO pibNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Giyagni rumepe wane chinretatnakluna, “¿Gi rixpokotyi? ¿Gi rixpoko gimrekgakakletyi?” ");
INSERT INTO pibNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Rugitna, “Nunkakatkagi. Gi wa gjemno. ¿Klu chinanu galuka yijnakletatnaklu? ¿Gixkoxlege galuklu wa yimaklengi gixinripa?” ");
INSERT INTO pibNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Yangaluna. Wane chinruna, “Pixni wa yimakleryi, ga wa wixa Moysisi yimaklenwu wixa. ");
INSERT INTO pibNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Wixa gimata wa Moysisi ruynumsata Goyakalu. Ga wa Tye, gi wumata ginaka runya.” ");
INSERT INTO pibNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Rugita wa jeji. Wane chinna, “Galikakni giglajruni wa gixa gi gimatlu ginakakta runya, ga wa rumrekgakakno. ");
INSERT INTO pibNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Wumata wa Goyakalu gi yijnakotna kmukochirerune, seyni wa satu Goyakalu yonogyegitachri, ga wa Wale gishinikanru kamrutachri, wale yijnakota. ");
INSERT INTO pibNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Gi pagogneko jempiranyegitka wa satu gimrekgakakyawakatkalu wa maygaletu gishpakyachri. ");
INSERT INTO pibNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Goyakalu yegi ma muyakatkanumka wa Tye gikemka rumkata kamruretanu.” ");
INSERT INTO pibNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Rugitluna. Wane chinruna, “Psolpotuyako mukochri gimushpakachriyi, ¿ga wa pixa ginkaklewyegitwu wixa?” Maleka ruknokluna. ");
INSERT INTO pibNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Yijnakota Geso wa maleka ruknokyawakluna. Rukshiklu. Wane chinru, “¿Palixluge wa Goyakalu Wgene?” ");
INSERT INTO pibNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Rugita wale. Wane china, “¿Katni Wale, Gitsrukaachi, wa nalixyaplu Wale?” ");
INSERT INTO pibNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Wane chinru Geso, “Petatkalu. Walekni giynumsatyi.” ");
INSERT INTO pibNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Wale wane china, “Nalixa, Gitsrukaachi.” Yoptsojityegitlu. ");
INSERT INTO pibNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Wane china Geso, “Giklukanuwnayegjixlewlu chinanu, Gita gina tye psolchijneko, retinripna metkane, ga wa maygalene rixinripna getachine.” ");
INSERT INTO pibNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Wa pimrine Gwariseyone Wale yegi gwanatachine yijnakotlu Wale. Wane chinruna, “¿Wixkoxlege maygalenwu?” ");
INSERT INTO pibNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Wane chinna Geso, “Maygalengi gixkamka, gimka kmukochirepgi. Ga wa xani gi rixanu gixa wane china, ‘Weta,’ giyagni gmukochire waneygi. ");
INSERT INTO pibNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","“Galikakni, galikakni, wane nchingi, wa gowegane prijere gipgyaptotpotuko mjiglokikatu, seyni pnusretako ratskomtya, walenwa kachowguru. ");
INSERT INTO pibNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Wa gipgyaptopotuko jiglokyachri, Walenwa gowegane girukotachri. ");
INSERT INTO pibNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Wale chinanu kotpukgipgyaptoteta wa gipgyapto gajeru. Gowegane yijnaktokanutlu. Rowegatene tomga satkaka tgiwakaya. Koshpakna. ");
INSERT INTO pibNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Wa pejnuruneko Walenune koshpakinitkana, kosekamtatkana. Gowegane gomkagitlu gi rixanu rumatatokanutluna. ");
INSERT INTO pibNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Gi wa romkagitanruna pnu gajeru, seyni rasukinrina wale, gi rixanu gowegane gi gimatatokanutna maleka gajene.” ");
INSERT INTO pibNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Tye yapkaklu tokanchi Geso ginkakna, seyni wanna gi gimata jemlu klunwa wane chinyana. ");
INSERT INTO pibNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Giyagni Geso gimepe wane chinretatnaka, “Galikakni, galikakni wane nchingi, Gitni wa gowegane gipgyaptotno. ");
INSERT INTO pibNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Pejnuruneko muchinanu ginachine Gitaya kachowgurunni, seyni wa gowegane gi yijnakotna. ");
INSERT INTO pibNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Gitni wa gipgyaptono. Gitaya jiglokyachri rognetkaako. Jiglokjetanu. Rushpakjetanu. Rukshikjetanru nikyawakapa. ");
INSERT INTO pibNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Wa kachowguru gina walepje chinanu, chowguwatinripa, ga wa ruylalewatinripa, ga wa nikatlewatinripa. Gita gina waneyna rixinripna ruwekinrina, ga wa ponikowa giwekletinripna. ");
INSERT INTO pibNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Gitni wa kigleru kgirukotapraklerno. Kigleru girukotapratachri ruwekinri rutaka gowegane chinanu. ");
INSERT INTO pibNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Wa wenutkalurni, wa girukotapratachri migje, kgowegateru migje, retapinri kewetna ginachri, ruknokamtna gowegane. Rasukatka. Kewetna kashichanna. Rakapalatna gowegane. ");
INSERT INTO pibNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Wa wenutkaluru gasuka gi rixanu wa wenutkalurni. Gike rixluna wa wale wa gowegane. ");
INSERT INTO pibNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","“Gitni wa kigleru kgirukotapraklerno. Numatna nowegatene. Wa Gitanune gimatno. ");
INSERT INTO pibNT_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Waneko pixka rixa gimatletno Gita Girchi, ga wa Gita gimatlu Girchi. Nutaklu nuwekinri gowegane chinanu. ");
INSERT INTO pibNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Pimrone koxa waneyno gowegane, tye prijere mwakane. Wanna koxa numkata gwapleta. Yijnaktokanutannona. Waneplu satupje rapatyawakapna gowegane, ga wa satupje girukotapratachri. ");
INSERT INTO pibNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Giyagni Girchi gishinikno gi rixanu nuwekinri nutaka numepe yoptoletyapatnaklu. ");
INSERT INTO pibNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Gike konanno nuwekinri, seyni Gitako gitaklu Gitanuko. Nutaaka nutakyaplu. Nutaaka numepe yoptoletyapatnaklu. Wane rixa yokanretno Nuru.” ");
INSERT INTO pibNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Wanetnaklu kotspalanshinikankaklu Goteyonkakluko tye tokanchi chinanu. ");
INSERT INTO pibNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Gixolune wane china, “Kamchi waneylu. Seprolokachrini. ¿Klu chinanu gyijnakotlu?” ");
INSERT INTO pibNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Pimrine wane china, “Gi wa kamchichachri tokanni wa tye. ¿Kamchirge gimkata gimrekgakakletlu satu maygaletu?” ");
INSERT INTO pibNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Gerosale waneru meyiwlugogne, wa kpashiwakapji gitaakoklungogne. Ginapukluni. ");
INSERT INTO pibNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Kpashiwakapji yotaljeta Geso, gitamnu Salomonu. ");
INSERT INTO pibNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Giyagni sajrukluna Goteyone. Wane chinruna, “¿Giklunanu pali kojwakanshinikanretanwu? Wa Kristo pixinipa, punkakanwu pgujetanwaka.” ");
INSERT INTO pibNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Rugitna Geso, “Nunkakatkagi. Gi galixa. Wa nkamrurkaka Nuru giwakaya, waleko gipgujtatno Gita. ");
INSERT INTO pibNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Seyni gixa gi galixa gi rixanu gi wa nowegatengi. ");
INSERT INTO pibNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Nowegatene jematokanutno. Gita gimatna. Romkagitnona. ");
INSERT INTO pibNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Gita genekna ruwekinrina gike rixiniko mnikawnakatu. Gi pagogneko ramganna. Gikena koshripatanna nomyoya. ");
INSERT INTO pibNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Nuru, nenekjeru, pejnurune pnute tsruni Wale. Gikena gimkata koshripletna Nurumyoya. ");
INSERT INTO pibNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Gita ga wa Girchi satupjerunwu.” ");
INSERT INTO pibNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Rumepe koscheksotleretna Goteyone sotlujetyapluna. ");
INSERT INTO pibNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Rugitna Geso, “Gixo kigleru kamrurchi nekakgitgi Girchiya. ¿Giru kamrurchi tyekaka chinanu nsotlujetanmakno?” ");
INSERT INTO pibNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Rugitluna Goteyone, “Wa kigleru kamrurchi chinanu, gi wa wsotlujetyi, seyni wa mupashiregnuchi chinanu wsotlujetanmakyi, gi rixanu Pixa yinerukyi Goyakalu putaknawa.” ");
INSERT INTO pibNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Rugitna Geso, “¿Gi ge yonatka wa Tokanchi Yokanatkaluruya gixanu: Gita wane china, goyakalungi? ");
INSERT INTO pibNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","“Wane chininna goyakalune wanna Goyakalu tokanu genekikolune, ga wa yonchi gi rumkata kaspukletko, ");
INSERT INTO pibNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","wa Gita Girchi kpashiri gitakanruno, tyechijne yokanatanru, gixa wane china, ‘Mupashiregnuchi pchina,’ gi rixanu wane nchina, ‘Gitni Goyakalu Wgenno.’ ");
INSERT INTO pibNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Gimka Nuru kamrure nkamrutanu, gi galixanno. ");
INSERT INTO pibNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Wa nkamrutinri, gimka galixanno Gita, galixanru kamrurchi, gimatyapatkalu, gimatgognenatinripa wa Girchi gwano Gita, ga wa Gita Girchi nwa.” ");
INSERT INTO pibNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Giyagni rumepe galuka kashretmakluna, ga wa Wale gishpakamta wannayegiya. ");
INSERT INTO pibNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Rumepe Gorta wakanute yaletatnaka, wa Gwa muchinanu katlewjenatyawaka. Wane rawanata. ");
INSERT INTO pibNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Gixo yayegitlu. Wane chinna, “Gwa galikakni gi satuko getkaluru kamruta. Seyni Gwa ginkakletjenatanru wa Tye ptowruko galikakni.” ");
INSERT INTO pibNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Gixo galixlu waneya. ");
INSERT INTO pibNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Yayixana Lasarni, Wetani gajerni, Mariya gwiyawaka pokchi, ga wa tyegwaklo Marta. ");
INSERT INTO pibNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Mariya, wa Gitsrukaachi pgamlugalo giyokachro, ga wa tsheyjixitlu tojiwutsaya ga ga walanwa yayixyegwakatachro Lasarni. ");
INSERT INTO pibNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Repurone yokanrewata Wale yegi. Wane chinjixluna, “Gitsrukaachi, petanu, wa palukanruni yayixanatka.” ");
INSERT INTO pibNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Wa yijnakotinitka Geso wane china, “Tye yayixlu, gi wa gipukchipni seyni rumalwutikolupa Goyakalu, wa Goyakalu Wgene gimalwutikolupa Wale chinanuya.” ");
INSERT INTO pibNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Geso gishinikna Marta, ga wa tepuro, ga wa Lasaro. ");
INSERT INTO pibNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Giyagni wa jeminitka wa yayixinrinatka, wane rutukawa gepgogne wa rawanatyawaka. ");
INSERT INTO pibNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Giyagni wanepnute wane chinna yimaklene, “Gote gayanutnaka.” ");
INSERT INTO pibNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Yimaklene wane chinru, “Rawi, tyegognekakniko, raluka sotlujeretanyina Goteyone. ¿Waneklege pyanutnaka?” ");
INSERT INTO pibNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Rugita Geso, “Waneylu pagogne pamole gepi gora. Gogi yanini satu, gi wa rutspeta, gi rixanu tyechijne pokamlatachini reta. ");
INSERT INTO pibNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Wa satu goyechno yanini rutspeta, gi rixanu maleshlu pokamlalu waleya.” ");
INSERT INTO pibNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Rali wane chinretinitka, wane chinna, “Lasarni, walukanru, rapnanutatka. Seyni wane nyanu. Nkomyekapanru.” ");
INSERT INTO pibNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Giyagni wane chinruna yimaklene, “Gitsrukaachi, rapnanutini, rutukanu.” ");
INSERT INTO pibNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Wa Geso wane chinre wale gipnaleya. Wa wanna kagwaklu wa rapnanushatinri rumkinriyapirana, china. ");
INSERT INTO pibNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Giyagni Geso wane chinatkana pgujetanwaka, “Lasarni gipnanatka. ");
INSERT INTO pibNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Numuwata gixa chinanu, gi wa wane nwanata, galixinripa. Seyni gayanutka wale yegi.” ");
INSERT INTO pibNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Giyagni Tomasu wa Gepirutu chinkaluru wane chinna ruyimakikolune, “Wane koxa gayanu wixa Waleyma wupninripa.” ");
INSERT INTO pibNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Giyagni rapokinitka Geso, rumatatkalu gepkoxamkojgognetkani kapnatikolutka. ");
INSERT INTO pibNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Wa Wetani gi gowukayatkalu Gerosale, mapa getko kilometroni. ");
INSERT INTO pibNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Gixo Goteyone ginyegitlo Marta ga wa Mariya yegwakluniyna rumnankapkana. ");
INSERT INTO pibNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Giyagni Marta jeminitka Geso gininritka, tyoptotaplu. Ga wa Mariya panchi tuplanata. ");
INSERT INTO pibNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Giyagni Marta wane chinru Geso, “Gitsrukaachi, gewi pwanatkamka, gimka rupnanni nyegwakluni. ");
INSERT INTO pibNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Xani koxa numatlu wa pejnuruko pagjityaplu Goyakalu, Goyakalu genekanyi.” ");
INSERT INTO pibNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Wane chinro Geso, “Yotunotanu pyegwaklupa.” ");
INSERT INTO pibNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Marta wane chinru, “Numatlu yotunotinripa yotunkoklunchipa ralipregognepa.” ");
INSERT INTO pibNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Wane chinro Geso, “Gitni wa yotunru ga wa giweklu. Wa nalixjeru rupnanmaka, ruwekanu. ");
INSERT INTO pibNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Pejnuruneko giwekachine nalixjene gi pagogneko rupnanna. ¿Gi ge palixlu tye?” ");
INSERT INTO pibNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Wane chinru, “Gigi, Gitsrukaachi. Nalixatka gita Pixni wa Kristoyi, Goyakalu Wgenyi, tyechijne ginachriyi.” ");
INSERT INTO pibNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Tali wane chinretinitka, talimta. Pochkeroko tomgalo tepuro Mariya. Wane chinro, “Gewitkalu Yimaklewatachri. Repukyi.” ");
INSERT INTO pibNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Wala jeminitka, giyampotu tpalnamta. Tyayegitlu. ");
INSERT INTO pibNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Gi wa pokchi rapokawa Geso, seyni wa Marta yoptotapyawakaklu rawanata. ");
INSERT INTO pibNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Giyagni Goteyone panchi gwanatachine walayma tumnanukanatjene, wa retinitkalona Mariya tunwamtinritka giyampotu, tushpakamtatka, romkagimtlona. Kagwakna wa yomlechi tyinripa wane chiyamtapinripa. ");
INSERT INTO pibNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Giyagni Mariya tapyegitinitkalu Geso, tetinri, chiji tapokamta gijixistsi. Wane chinru, “Gitsrukaachi, gewi pwanatkamka, gimka rupnanni nyegwakluni.” ");
INSERT INTO pibNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Giyagni Geso wa retinro chiyagatachro, ga wa walayma ginachine Goteyone chiyaganatachine jigekanuwata ginshinikanuya. Kojwakanshinikanuta. ");
INSERT INTO pibNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Wane china, “¿Ginaka gitakanru?” Wane chinruna, “Gitsrukaachi, punanu. Petapanru.” ");
INSERT INTO pibNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Chiyagata Geso. ");
INSERT INTO pibNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Giyagni wane chinna Goteyone, “¡Getanru! ¡Gi pagaluklenanukta rixlu!” ");
INSERT INTO pibNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Wanna pimrine wane china, “¿Gi ge rumkatlu wa Tye wa maygaletu gimrekgakakachri, gituukakletlu wale ma mupninitipa?” ");
INSERT INTO pibNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Giyagni Geso jigekanuwatatnaka Walenanuko. Yomlechi yegi rapoka. Gitawakapnani, sotlu gishyatkaluru. ");
INSERT INTO pibNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Wane china Geso, “Gkoschekanru sotlu.” Marta, wa gipnachri gepuro wane chinru, “Gitsrukaachi posunatkalu, gi rixanu gepkoxamkojgognetkani.” ");
INSERT INTO pibNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Geso wane chinro, “¿Gi ge wane nchinyi, palixini petanru Goyakalu goyaknu?” ");
INSERT INTO pibNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Giyagni koschekluna wa sotlu wa gipnachri gitakikowakaya. Wa Geso teno yigata. Wane china, “Nuru, npoyagnutyi Pixa yijnakotyawakno. ");
INSERT INTO pibNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Numata pyijnakjetno. Seyni gixolune yine chinanu wa sajrukachine, wane nchina, wa ralixinripna Pixa yokanatyano.” ");
INSERT INTO pibNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Rali wane chinretinitka, saplewata. Tsru tokanu rixa, “Lasaroo, tekali. Pushpakanu.” ");
INSERT INTO pibNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Wa gipnanatachri rushpakatka, gostumyotkaluru, ga wa gijixi mkachrichrataya. Ga wa gigoji sapwakgojitka kasamalu. Wane chinna Geso, “Gkaspukanru. Getasha yaletanru.” ");
INSERT INTO pibNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Giyagni gixo Goteyone wa Mariya yegi ginachine, ga wa Geso kamrutanru getachine ralixluna Wale. ");
INSERT INTO pibNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Wa wanna pimrine Gwariseyone yegi ya. Runkaakana wa Geso kamrutanrupirana. ");
INSERT INTO pibNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Giyagni wa tsrukakalune sasertotene ga wa Gwariseyone gapatjetna jemanshinikankakjetikwaka gajene. Wane chinna, “¿Gi wixanutka? Gi rixanu wa tye jeji kamrutlu gixo getkalurkaka. ");
INSERT INTO pibNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Wetasha wane gixletinri pejnuruneko galixanru. Runanna Romanone. Konanunwuna gawiywaka ga wa wgirukotlewatyawaka.” ");
INSERT INTO pibNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Wa Kaygwasu, satu wannate, wale walapu sasertotene gitsrukate potu rixinri, wane chinna, “Gixa gike gimata. ");
INSERT INTO pibNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Gi waleko gyanshinikanuta wa rupxakyapwu wa satu jeji gipninripa yine chinanu, ma mamginitipna pejnuruneko yine.” ");
INSERT INTO pibNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Gi wa waleko rushinikanu wane china, seyni wa sasertotene gitsrukate potu rixinri wale walapu, tokanchi reneklewata. Wane china wa Geso gipninripatka yine chinanu. ");
INSERT INTO pibNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Gi wa wannanerupje chinanu, seyni koxa wanerutupje rapatyawakapna Goyakalu wgenene wa gipalanatachine. ");
INSERT INTO pibNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Giyagni walgogneyakawa jemanshinikankakna ruylatyapluna. ");
INSERT INTO pibNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Giyagni Geso gi wane yapatka pgujetanwaka Goteyonetskalaya, seyni wane yiyatka. Yineru mwiyawakanustsi gwachijnetachri ya, satu pokchi Giprayi giwakatletachri. Wane rawanata yimakleneyma. ");
INSERT INTO pibNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Wa Tsru Giknoglushgogne Goteyonenu gi gowukatkalu. Walesreta rushpakyana gixo. Gerosale kanikna, Tsru Giknoglushgogne ma mapookanuwa, kpashirine rutakikolupna. ");
INSERT INTO pibNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Giyagni rujgaluna Geso. Kpashiwakapjiya tunwatachine wane chinkakna, “¿Gi pixka getle gixlu? ¿Gi wa meyiwatikwaka runanu?” ");
INSERT INTO pibNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Tsrukakalune sasertotene ga wa Gwariseyone yokanrewatna, wa katukokta gimata ginaka rawa, runkaklewatinripa wa kashichyapluna. ");
INSERT INTO pibNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Giyagni patsrujirgogne magatiniwa Tsru Giknoglushgogne, Wetani rapoka Geso, wa Lasaro gwiywaka, wa gipnapachri wa yotunkakanru gipnachinetskalaya. ");
INSERT INTO pibNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Giyagni wane ralpokotyaluna nachnewlupa. Marta gitspaprota. Lasaro walenwa ruxiplatjeru nikikowakaya. ");
INSERT INTO pibNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Giyagni Mariya wa pgamlugalo ganikaji ginnu twapa, nartogapje kwenuru potu. Tuyokjixitlu Geso. Tsheyjixitlu tojiwutsaya. Psolupjiko tyapa pogamlunuta. ");
INSERT INTO pibNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Satu yimakleru Gota Giskaryote, Simo wgene, wa samyokjerupa, wane china, ");
INSERT INTO pibNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“¿Klu chinanu gi tushankaka twu pgamlugalo wa mapa pachaproji chinanu, kwamonurunnimka teneeko?” ");
INSERT INTO pibNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Gi wa retwamonutya chinanna wa kwamonurune, seyni gi rixanu kachowgurni wale. Sroschimapa ranika. Rawjetlu tsapatkaluru. ");
INSERT INTO pibNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Giyagni Geso wane china, “Petashatanro. Nkapnatikolgogne chinanu tumretlo wa twu. ");
INSERT INTO pibNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Gi rixanu wa kwamonurune gimwagognenata gixa, ga wa Gita gi wa gimwagognenatanu.” ");
INSERT INTO pibNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Giyagni gixolune Goteyone gimata wa wane rawinri Wale. Gi wa Geso chinanupje runna, seyni Lasaro koxa retapinripna wa yotunkakanru gipnachinetskalaya. ");
INSERT INTO pibNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Jemanshinikankakna tsrukakalune sasertotene, Lasaro koxa ruylatinripna. ");
INSERT INTO pibNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Gi rixanu wale chinanu gixo Goteyone wane ya. Ralixluna Geso. ");
INSERT INTO pibNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Waleprikgogne gixolune yine gina meyiwlu yegi, gi rixanu yijnakotluna Geso Gerosale yinripa. ");
INSERT INTO pibNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Rawluna kasureru. Yoptotapluna. Saplewatna: ¡Poyagnu! ¡Giglenshinikanyegitkaluru Gitsrukaachi giwaka ginyachri, Gisrayiline Pogire! ");
INSERT INTO pibNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Geso gikshiklu mporo. Waletji tuplata. Yonchi chinyawaka: ");
INSERT INTO pibNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Gi pikanu, Siyo nshicho. Petanru. Pogire gina, mporo wgenetji tuplatachri. ");
INSERT INTO pibNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Muchinanu yimaklene gi gimata jemlu tyekakapirana, seyni royaknu jiglokinitka Geso, waneklu rushinkapluna tyekaka yonatkaluru Walepirana, ga wa wane rixluna tyekaka. ");
INSERT INTO pibNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Giyagni wa gixolune Wale yegi gwanatachine, wanna gipgujtatlu tomgiyawaklu Lasaro kapnaya. Gipnachinetskalaya yotunkaklu. ");
INSERT INTO pibNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Wale koxa chinanu yoptotapluna gixolune yine, gi rixanu jempiranyegitluna Wale getkaluru kamrutinri. ");
INSERT INTO pibNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Giyagni Gwariseyone wannakakluko wane chinkaka, “Getlu. Gikegapri gkamruta. Getanru. Psolchijne gajeneko gwagajxigitlu.” ");
INSERT INTO pibNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Kanikachine meyiwlu yoptsojityentapachinepaymana pimrine Kriykone. ");
INSERT INTO pibNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Giyagni wa nyi gapyegitlu Wilipi, Wetsayta, Kalilesreta gajerunanu. Ragjitluna. Wane chinruna, “Wumole, waluka getletlu Geso.” ");
INSERT INTO pibNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Wilipi ginkakaplu Gantirishi. Gantirishi ga wa Wilipi ginkaklu Geso. ");
INSERT INTO pibNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Geso gigitna. Wane china, “Nopapko gapokanu noyaknu njiglokinripa Gita, Yineru Wgenno. ");
INSERT INTO pibNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Galikakni, galikakni wane nchingi, Chiji ma mujrukini trikoji, ma mupnakanu, walepje gituka. Wa rupninina, gixoji rawini. ");
INSERT INTO pibNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Ruwekinri galukachri, ramginina ruwekinri, ga wa ruwekinri gayegixachri tyechijneya, wale gimretanru ruwekinripa gike rixiniko mnikawnakatupa. ");
INSERT INTO pibNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Satu kamrurewyegitinno, romkagitanno. Ginakpaktano, wane koxa rawanu nkamrurewyegitjeru. Satu kamrurewyegitinno, Nuru gitakanru kagwakpiratikolupa. ");
INSERT INTO pibNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Xani nkojwakanshinikanuta. ¿Gi nchinanu? ¿Nuru, pognetkakanno tyepapkoya? Seyni tye chinanukni tyepapko nuna. ");
INSERT INTO pibNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Nuru, pgiwaka gimalwutikolupa Pixa chinanu.” Giyagni tengogne ruyakatya tokanchi, “Rumalwutikolutka Gita chinanu. Rumepe gimalwutikolupa Gita chinanupa.” ");
INSERT INTO pibNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Giyagni wa gixolune wane gwanatachine, yijnakonatachine, wane chinna, “Rutlogleni.” Pimrine wane china, “Goyakalutowreru giynumsatlu.” ");
INSERT INTO pibNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Rugita Geso. Wane china, “Gi wa Gita chinanni runa tye tokanchi, seyni gixa chinanu. ");
INSERT INTO pibNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Xani ruklukanuwnayegjixikolna tye psolchijne gajeneko. Xani tye psolchijne gajeneko gitsrukate, Satanasyo, giknookalurupni maleka. ");
INSERT INTO pibNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Wa yotukinpatkanona chijiya, pejnuruneko nkosetanu Gita yegi.” ");
INSERT INTO pibNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Wane china rumatkakyapna gi pixkalutu gipukchi rupninripa. ");
INSERT INTO pibNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Giyagni rugitluna gixolune, “Wixa jemlu Tokanchi Yokanatkaluruya wa Kristo gwagognenatanu. ¿Gi pchinkoxge Pixa: ‘Rumkata yotunkaakota Yineru Wgene?’ ¿Gi gixachringe wa tye Yineru Wgene?” ");
INSERT INTO pibNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Giyagni Geso wane chinna, “Pshinitsonu gixa yegi rawanu pokamlalu. Pokamlalu waneyakopshingi gyananu, ma kashichkanupgi wa mapshagalu. Wa mapshagwaka yanachri gi wa rumata ginakakta ya. ");
INSERT INTO pibNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","“Pokamlalu waneyakopshingi galixanru pokamlalu, wa pokamlalu wgenene gixinripa.” Walekakapirana yanumsata Geso. Ralimta. Yogimatyana. ");
INSERT INTO pibNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Gixomka getkaluru kamrugetanutna. Gi ralixluna Wale, ");
INSERT INTO pibNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","poyagkakikolupa wa tokanchi Gisayiya tokanchi geneklewatachri chinyawaka: Gitsrukaachi, ¿katu galixlu wunkakletanru? ¿Katu gekakgitka wa Gitsrukaachimyo? ");
INSERT INTO pibNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Wale chinanu gi rumkata galixletna, gi rixanu rumepe wane chinretatnaka Gisayiya: ");
INSERT INTO pibNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Maygalene rixkakna. Shikowgajkakna. Giygaleyna ma metinitipna. Ma mumata jemgajitinipna ma kashrijetikotupna. Nma mutskalakyanupna. ");
INSERT INTO pibNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Tyekaka chinjeta Gisayiya wa retinri wa royaknu, Walepirana ruynumsatinri. ");
INSERT INTO pibNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Wane gixkamka, seyni wa tsrukakaluneko gixo galixlu Wale, seyni wa Gwariseyone chinanu gi wa rupgujtatluna, ginkaklewwakapji ma muknokikotupna. ");
INSERT INTO pibNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Gi rixanu ralukpotutluna yine gimalwure Goyakalu gimalwure pnute. ");
INSERT INTO pibNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Saplewata Geso. Wane china, “Nalixjeru gi Gita ralixa seyni wa nyokanatjeru galikaka. ");
INSERT INTO pibNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Wa netjeru retkoxlu wa nyokanatjeru. ");
INSERT INTO pibNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Gitni pokamlalno tye chiji ginachrino wa pejnuruneko nalixjene mapshagwaka mawinitipna. ");
INSERT INTO pibNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","“Satu jeminri ntokanu, gi wa ralixanru, gi wa Gita giklukanuwnayegjixanru. Gi rixanu gi wa nuna nuklukanuwnayegjixyapna tyechijne gajene, seyni nognetkakyapna tyechijne gajene. ");
INSERT INTO pibNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Nuknokjeru, gi wa yoptotokanutno, waneru wa ruklukanuwnayegjixjerupa. Wa tokanchi nunkakletanru, wale giklukanuwnakakanru ralipregognepa. ");
INSERT INTO pibNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Gi rixanu gi wa Gitako nushinikanu nunkaklewata, seyni wa nyokanatjeru Girchi, Wale yokanatno wane nchinyawakapa, ga wa nunkakletanrupa. ");
INSERT INTO pibNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Numatlu Wale yokanatyawaka Walenwa giweklu gike rixiniko mnikawnakatu. Giyagni wa Gita ginkakletanru wa Girchi chinyawakno, wane nchina ginkakleta.” ");
INSERT INTO pibNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Ma mapookanuwa meyiwlu Tsru Giknoglushgogne, rumata Geso wa gipapko gapokinritka, tyechijne rushpakinripatka, Girchi yegi yinripatka. Wane rixa gishinikletna Walenune tyechijne gwanatachine, yoptukyawakpotuko rushinikna. ");
INSERT INTO pibNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Rali nachinewletinitkana kamchi gajitletkakatkalu Gota, wa Simo Giskaryote wgene, samyokyapatkalu. ");
INSERT INTO pibNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Rumata Geso wa Girchi genekyalu pejnurkakako, ga wa Goyakalu yegi giyakatyachri, ga wa Goyakalu yegi ya. ");
INSERT INTO pibNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Palnatka nachnewluyegiya. Komkaga. Sheyipisama rawa. Saprikapchijitnawa. ");
INSERT INTO pibNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Wanepnute gerkapi rutakgatlu gonu. Yinuwaka gerkajixletna yimaklene. Sheyipisama saprikapchijitanruya sheyityana. ");
INSERT INTO pibNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Giyagni Simo Petro yegi runini, Petro wane chinru, “Gitsrukaachi, ¿Pixlege gerkajixitanno?” ");
INSERT INTO pibNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Rugita Geso. Wane chinru, “Wa Gita kamrutanru, gi wa xani pumata jemlu. Wa gowukshiniyaka pumata jemanru.” ");
INSERT INTO pibNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Wane chinru Petro, “Gike pixiniko perkajixitanno.” Geso gigitlu, “Nma merkakanyi maleshayapyi Gitanuya.” ");
INSERT INTO pibNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Wane chinru Simo Petro, “Gitsrukaachi, gi wa nojixipje, seyni nomyo koxa ga wa nojiwu koxa.” ");
INSERT INTO pibNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Wane chinru Geso, “Wa gerkakalurutka, gi wa magatatka. Satupjetkalu wa gijixipje gerkako, seyni psoluyako powratka. Ga wa gixa powralungi, seyni gi wa pejnurunekgi.” ");
INSERT INTO pibNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Gi rixanu rumatlu samyokjerupa. Giyagni wane china, “Gi wa pejnurunekgi powra.” ");
INSERT INTO pibNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Giyagni rali gerkajixitletinitkana, wa rawamkatinitka, tuplatatnaka nikikowakaya. Wane chinna, “¿Gi ge gimatlu wa nixyawakgi? ");
INSERT INTO pibNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Gixa wane chinjetno, ‘Yimaklewatachri ga wa Gitsrukaachi.’ Wanepotuko nchina, gi rixanu Gitakni. ");
INSERT INTO pibNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Maka Gita wa Gitsrukaachino ga wa Yimaklewatachrino nerkajixitgi, gixa koxa gimkata gerkajixkakleta. ");
INSERT INTO pibNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Gi rixanu gyimanrupa nekakgitgi, gixa koxa kamrutyaplu nkamrutyagi. ");
INSERT INTO pibNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Galikakni, galikakni wane nchingi, wa wayegrechri gi wa rutsrukate pnute tsruni wale. Wa yokanatkaluru gi wa yokanatjeru pnute tsruni wale. ");
INSERT INTO pibNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Tyekaka gimatini, giglenshinikanyegitkalunepgi wa wane gixinipa. ");
INSERT INTO pibNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Gi wa pejnurunekgi gixapirana wane nchina. Gita gimatna ginnanwa ntsomitanune, seyni poyagkaakalurupa satu tokanchi yonatkaluru, wane chinachri: Wa Gitayma jimapro nikachri rumtukno yokwireya. ");
INSERT INTO pibNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","“Xanigognenanu nunkakgi ma mapookanuwa, wa rapokinipa galixanno Gita nixinri. ");
INSERT INTO pibNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Galikakni, galikakni wane nchingi, wa nyokanatanru yoptotachri Gita yoptota. Ga wa Gita yoptotachri nyokanatjeru yoptota.” ");
INSERT INTO pibNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Wane chininitka Geso, kojwakanshinikanuta. Rupgujtalewata. Wane china, “Galikakni, galikakni wane nchingi, satu gixa nchininri wale samyokanno.” ");
INSERT INTO pibNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Giyagni yimaklene getjekaka. Gi rumatanshinikanutna katupiranni wane china. ");
INSERT INTO pibNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Waneru satu yimakleru Geso gishinikanru, Geso gitspanostatachri. ");
INSERT INTO pibNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Giyagni Simo Petro gitnoyegitlu tye, wa repomgiyaplu katupiranni wane china. ");
INSERT INTO pibNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Geso gitspanostatachri wane chinru, “Gitsrukaachi, ¿katni wale?” ");
INSERT INTO pibNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Giyagni rugita Geso, “Waleni Gita genekanrupa psoji gigakachri.” Wale gigaklu psoji. Reneklu Gota Giskaryote, wa Simo wgene. ");
INSERT INTO pibNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Psoji niklokinitka, Satanasyo jiglokatkalu. Giyagni Geso wane chinru, “Pkamrutanru giyampotu pkamrutanru.” ");
INSERT INTO pibNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Gi satuna nikikowakaya tuplanatachine gimata klu chinanu wane chinru. ");
INSERT INTO pibNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Gi rixanu pimrine kagwaklu wa Gota ktsapane rixinri, Geso wane chinru, “Pagjitanru wa walukanru meyiwlu chinanu, waka kwamonurune renekanu pagixanu.” ");
INSERT INTO pibNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Giyagni wale yoptotinitkalu psoji, waneklu rushpakamtatka. Goyechnotkani. ");
INSERT INTO pibNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Giyagni rushpakamtinitka, wane china Geso, “Xanitkani njiglokanutka noyaknu Gita Yineru Wgenno. Ga wa Goyakalu gimalwutikolpatka Gita chinanu. ");
INSERT INTO pibNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Goyakalu gimalwutikolupa Gita chinanu, Goyakalu chinanu koxa Gita gimalwutikolupa. Xaniyakawa numalwutikolupa Goyakalu chinanu. ");
INSERT INTO pibNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","“Wiwine, pshinitsonu numwanutkagi. Gijganmakno. Wa Goteyone nchinyawaka, wa nyiyawakapa Gita, gixa gi gimkata wane yaletanu. Wane koxa nchingi gixa xani. ");
INSERT INTO pibNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","“Satu yokanru gerotu nenekgi, wa gishiniikakinripa. Gita gishinikinikopixkagi, waneko pixka gixa gishiniikakletanu. ");
INSERT INTO pibNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Wale chinanu pejnuruneko gimatanu gixni wa nyimaklengi, wa gixkakluko gishiniikakinripa.” ");
INSERT INTO pibNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simo Petro wane chinru, “Gitsrukaachi, ¿ginaka pyanu?” Geso gigitlu, “Wa nyiyawakapa Gita gi pumkata gomkagletanno wa xani. Wa gowukshini pomkagitanno.” ");
INSERT INTO pibNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Petro wane chinru, “Gitsrukaachi, ¿klu chinanu gi numkata gomkagletanyi wa xani? Pixa chinanu nutakanru nuwekinri.” ");
INSERT INTO pibNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Geso gigitlu, “¿Gita chinanu putakanru puwekinri? Galikakni, galikakni, wane nchinyi, ma yanumatkanuwa gaxawripa, mapa kata pnutatanno. ");
INSERT INTO pibNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","“Gi gkojwakanshinikangajitinwa. Galixlu Goyakalu. Galixankoxno Gita. ");
INSERT INTO pibNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Nurupji gixo gwikwaka wane. Wane ma mixkanumka, nunkakanmakgi. Giyagni nyanuchi. Nalpoktapingi gwiyawakapa gixanupa. ");
INSERT INTO pibNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Nyinpatka, nalpokotiniplu gwikowakapa gixanupa, nunanutnaka. Gitako gwapanutkagi. Nwiyawaka koxa Gita, wane koxa gwanu gixa. ");
INSERT INTO pibNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Gimatlu ginaka nyanu. Gimatgapotlu.” ");
INSERT INTO pibNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tomasu wane chinru, “Gitsrukaachi, gi wumata ginaka pyanu. ¿Gi wixpoko gimatletanru wa gatnugapo?” ");
INSERT INTO pibNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Geso wane chinru, “Gitni wa gatnugapo, ga wa tokanchi galikakpotu, ga wa giweklu. Gike yayegitlu Girchi, seyni Gitapje chinanu yayegitka Girchi. ");
INSERT INTO pibNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Gimatinno, Nuru koxa gimatanu. Xaniyakawa gimatlu. Getatkalu.” ");
INSERT INTO pibNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Wilipi wane chinru, “Gitsrukaachi, pekakgitanwu wa Girchi. Poyagota wixa chinanu.” ");
INSERT INTO pibNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Geso wane chinru, “Gi pomshiniko numwatkagi, ¿gi ge pumatno, Wilipi? Wa netjeru retkoxlu Girchi. ¿Gi pchinkoxge pixa, ‘Pekakgitanwu Girchi?’ ");
INSERT INTO pibNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿Gi ge palixno wa Gita Girchi nwinri, ga wa Girchi Gita rawa? Wa tokanchi nunkakyagi, gi wa Gitako nonshinikanu wane nchina. Seyni wa Girchi Gita gwachri Wale kamrutlu wa kamrurchikaka. ");
INSERT INTO pibNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Galixanno Girchi nwinri, ga wa Girchi Gita rawa. Gma wane gixkanupa, galixanno kamrurchiyako. ");
INSERT INTO pibNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","“Galikakni, galikakni wane nchingi, wa kamrurchikaka nkamrutanru nalixjeru koxa kamrutanru. Ga wa tyekaka pnute kamrutanu nalixjeru, gi rixanu Girchi yegi nyanu. ");
INSERT INTO pibNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Klunerukokta gagjitanru Girchi ngiwakaya, wale nkamrutanu, Girchi gimalwutikolupa Gituru chinanu. ");
INSERT INTO pibNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Klunerukokta gagjitinipa ngiwakaya, Gita kamrutanru. ");
INSERT INTO pibNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Gishinikinipno gkamrutanru nyokanatanrukaka. ");
INSERT INTO pibNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Gita gagjitanru Girchi ga wa satu Kgimnanukakleru renekangi, gixa yegi gwagognenatachripa. ");
INSERT INTO pibNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Walenwa Giwekikaluru galikakpotunanu. Wale tyechijne gajene gi gimkata yoptoletanru, gi rixanu gi retluna. Gi koxa rumatluna. Gixa gimatlu gi rixanu gixa yegi rawa, ga wa gixa gitokote rawanu. ");
INSERT INTO pibNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Gi wa murungi nuknokamtanu. Nyayegitangi. ");
INSERT INTO pibNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Pshinitsonu tyechijne gajene gi getanutkano, ga wa gixa getanno, gi rixanu Gita giweka, ga wa gixa koxa giwekanu. ");
INSERT INTO pibNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Walegogne gimatanu wa Girchi nwinri, ga wa Gita gwa gixa, ga wa gixa nwa Gita. ");
INSERT INTO pibNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Nyokanrekaka waneyalutu, ga wa wale kamrutachri, walenwa nushinikjeru. Nushinikjeru Nuru gishinikanrupa. Gita gishinikanru. Nupgujetinwa wale yegi.” ");
INSERT INTO pibNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Gota gi wa Giskaryotni wale, wane chinru, “Gitsrukaachi, ¿klunerni wa tye wa wixa yegi pupgujetinwa, gi wa tye psolchijne gajeneko yegi?” ");
INSERT INTO pibNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Geso gigitlu. Wane chinru, “Girukokta gishinikinipno rumretatokanutanno. Nuru gishinikanru wale. Wale yegi gayanu. Wale yineru yegi gawgognenatanu. ");
INSERT INTO pibNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Nma mushinikjetu gi gimretanru ntokanu. Ga wa tokanchi gyijnakotanru gi wa Gitanni, seyni Girchi wa nyokanatjeru tokanni. ");
INSERT INTO pibNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Tyekaka nunkakgi gixa yegi nwanatini. ");
INSERT INTO pibNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Wa Kgimnanukakleru, Giwekikaluru Kpashiri, wa Girchi yokanatanru Gita giwakaya, Wale gimatkakangi pejnurukopirana. Rushiniikakangi pejnurupiranako nunkakyagi. ");
INSERT INTO pibNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Giglewanshinikanru nuknokyegimtgi. Nuglenunshinikanu nenekgi. Gi wa tyechijne gajene genekle pixka, Gita genekyagi. Gi wa gkojwakanshinikanutinwa. Gi wa kpiklegolunepgi. ");
INSERT INTO pibNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","“Gyijnakotlu wa nunkakyawakgi: ‘Nyanu, ga wa nunanutnaka gixa yegi.’ Gishinikinipno, gimuwatanmaka, gi rixanu wane nchina, Girchi yegi nyanu. Gi rixanu Girchinwa Gita pnute tsru. ");
INSERT INTO pibNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Ga wa xani nunkakatkagi ma mapookanuwa, wa wane rixinpatka galixinripa. ");
INSERT INTO pibNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Gi wa gixo potu nuynumsatanutkagi, gi rixanu runatka kamchi, tyechijne gitsrukate. Gike waneylu wa Gitaya. ");
INSERT INTO pibNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Seyni rumatinripna tyechijne gajene Girchi nushinikinri, ga wa Girchi yokanatyawakno wane nixa kamrureta. “Ntunwatanu. Gewi gayinitka. ");
INSERT INTO pibNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“Gitni wa gowatsno galikakpotu. Nurni wa kgisanateru. ");
INSERT INTO pibNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Pejnuruko giplutsa Gita gwachri, gi kajru, Wale konanru. Ga wa pejnuruko kajiru Wale powratanru jiwpotutinripatka. ");
INSERT INTO pibNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Ga wa gixa powralunetkagi tokanchi chinanu wa nunkakyagi. ");
INSERT INTO pibNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Gita gwanu gixa. Gixa nwanu Gita. Wa giplutsa pixka gi rumkata gwaleta walenanuko, wa gowatsa mwakatu rixini, waneko pixka gixa, Gita gmawakanu. ");
INSERT INTO pibNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Gitni wa gowatsno. Gixni wa giplutsa. Gita gwachri, wa wale nwini Gita, wale gixoji gwiylu. Gi rixanu Gita mwakatu gike gimkata kamrureta gixa. ");
INSERT INTO pibNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Girukta gi gwinno, maleka giknookalurupa wa giplutsa pixka. Rupriganu. Rawanruna. Xirnachri ruknokanruna, ga wa xirnanu. ");
INSERT INTO pibNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Gita gwini. Gixa rawini ntokanu, galukanru pejnunanuka gagjitanu. Waneyapgi. ");
INSERT INTO pibNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Waleya rumalwutika Nuru, wa gixa gixo Wale kamrure gwinri. Wane gixinipa nyimaklenepgi. ");
INSERT INTO pibNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","“Girchi gishinikinikopixkano, wane nixa gishinikletgi. Nushiniklewle gomkagitanu. ");
INSERT INTO pibNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Gkamrutiniplu nyokanrekaka nushiniklewle gomkagita. Gita pixka Nuru yokanrekaka nkamruta ga wa rushiniklewle nomkagita. ");
INSERT INTO pibNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Tyepirana nunkakgi, numuwle waneyapgi, ga wa gixa gimuwle tseruwnapotutinripa. ");
INSERT INTO pibNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","“Tyenwa nyokanre, wa gishiniikakinripa, Gita gishinikinikopixkagi. ");
INSERT INTO pibNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Gikena waneya rushiniklewle tye pnute tsru, wa rutakyaplu ruwekinri rumatanune chinanu. ");
INSERT INTO pibNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Gixni wa numatanungi wa gkamrutinri nyokanatyagi. ");
INSERT INTO pibNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Gi wa wayegrechine nchinanutkagi, gi rixanu wa wayegrechri gi rumata kluneru kamruta wa rutsrukate. Seyni numatanune nchinatkagi, gi rixanu ptowrukakapirana nyijnakotanru Nuru yegi, numatkakgi. ");
INSERT INTO pibNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Gi wa gixa tsomitno Gita, seyni Gita tsomitgi gixa. Nutakgi gyinripa, kiglerkaka gkamrutinripa, ga wa gkamrutanrupa gwagognenatinripa, wa klunerukokta gagjityaplu Girchi ngiwakaya Wale genekangi. ");
INSERT INTO pibNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Tyenwa nyokanyegitgi, gishiniikakinripa. ");
INSERT INTO pibNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Tyechijne gajene gayegixinipgi, gimatanru Gita gapka rayegixna ma mayegixkanuwagina gixa. ");
INSERT INTO pibNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Tyechijne gajene gixkamka, tyechijne gajene galukmakna wannanune. Seyni gi rixanu gi wa tyechijne gajengi ga wa Gita tsomitgi tyechijneya, giyagni rayegixgina tyechijne gajene. ");
INSERT INTO pibNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Gishinikanru wa tokanchi wa nchinyagi: Wayegrechri gi wa rutsrukate pnute tsruni. Gitpotuko kojwakinitkana, kojwakankoxgina gixa. Wa ntokanu rumretkamkana, gixanu koxa rumretanna. ");
INSERT INTO pibNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Seyni wa tye pejnunanuka kamrutingina ngiwaka chinanu, gi rixanu gi rumatluna wa nyokanatjeru. ");
INSERT INTO pibNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Nuna. Nunkaklewywgitna gkojwakjenepa. Nma munkanumka, gimka nunkaklewyegitanna, gimka kmukochirepna, seyni nunkakna. Giyagni xani maleshayna rushyamukochiretinrina. ");
INSERT INTO pibNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Nayegixjeru Nuru koxa rayegixa. ");
INSERT INTO pibNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Wane nma mixkanupa wanna yegi, satu mkamrutanutu, gimka waneyapna mukochirna. Ga wa xani Gita koxa ga wa Nuru koxa retna. Rayegixnona Gita ga Nuru koxa. ");
INSERT INTO pibNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Seyni poyagkakikolupa yonchi chinyawaka Tokanchi Yokanatkaluruya wannanu: Gike chinanu rayegixnona. ");
INSERT INTO pibNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Ga wa runanu Kgimnanukakleru, Wale Girchi yegi nyokanyegitangi, wa Giwekikaluru galikakpotu, wa Girchi yegi gishpakyachri. Wa runinipa, Wale gipgujtatanno. ");
INSERT INTO pibNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Wa gixa koxa gipgujtalewatanu gi rixanu nyinuwakinyakawa gimwano. ");
INSERT INTO pibNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Tyekaka nunkakgi gma pupjetinitipa. ");
INSERT INTO pibNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Ginkaklewwakapjikaka giknokikolupa. Runanu gipapko wa katukokta giylatangi kagwakanru Goyakalu chinanu kamrurewatinri. ");
INSERT INTO pibNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Tyekaka kamrutingina gi rixanu gi rumatluna Girchi, gi wa Gitako. ");
INSERT INTO pibNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Seyni wa tyekaka nunkakgi, wa rapokinipa walepapko gishinkapanru wa wane nchinyagi. Seyni tyekaka gi nunkakgi muchinanu, gi rixanu gixa yegi nwa. ");
INSERT INTO pibNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Ga wa xani nyokanatjeru yegi nyanutka, ga wa gixa gi satuna gepomgano, ‘¿Ginaka pyanu?’ ");
INSERT INTO pibNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Seyni gi rixanu nunkakgi tyekakapirana gwamonnu mpachikgajita. ");
INSERT INTO pibNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","“Seyni galikaka nunkakgi gipxakikolupni nyinripa, gi rixanu wane nma yakanu Kgimnanukakleru gi ginanmaka gixa yegi. Ga wa Gita wane yinipa, Wale nyokanyegitangi. ");
INSERT INTO pibNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Wa Kgimnanukakleru gininipa rushinikanutanna tyechijne gajene mukochripirana, ga wa poyagkaklewlupirana, ga wa giklukanuwlupirana. ");
INSERT INTO pibNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Mukochripirana galikaka rushinikanutanna, gi rixanu gi ralixnona Gita. ");
INSERT INTO pibNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Wa poyagkaklewlupirana rushinikanutanna, gi rixanu Girchi yegi nyanu. Gi wa getanutkano. ");
INSERT INTO pibNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Ga wa giklukanuwlupirana rushinikanutanna, gi rixanu tyechijne gitsrukate giklukanuwnayegjixkalurupa. ");
INSERT INTO pibNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Gi gepika waneyawano nunkakyapgi, seyni xani gi gimkata kashnantakletlu. ");
INSERT INTO pibNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Wa runinipa galikaka potu Giwekikaluru Wale kosekangi pejnuruko Galikakpotunanu Tokanchi yegi. Gi rixanu gi Waleko rushinikanu runkakletanu, seyni wa yijnakotyalu pejnunanuka runkakletanu. Runkakangi ginachrikakapapirana. ");
INSERT INTO pibNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Wale chinanu numalwutikolupa, gi rixanu Gitanu rawanu. Walepirana runkakangi. ");
INSERT INTO pibNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Klunerukta Girchinu walekoxni Gitanu. Giyagni wane nchina wa Gitanu rawini, runkakangi. ");
INSERT INTO pibNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Pshinitsonu gi getanutkano. Wanepnute pshinitsonu, getanutnakno.” ");
INSERT INTO pibNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Giyagni wane chinkakna pimrine yimaklene, “¿Klunerni wa tye wa wane chinyawu, ‘Pshinitsonu gi getanutkano. Wanepnute pshinitsonu getanutnakno.’ Ga wa ‘gi rixanu Girchi yegi nyanutka?’ ” ");
INSERT INTO pibNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Giyagni wane chinna, “¿Klunerni china, wa ‘pshinitsonu?’ Gi wumata jemlu wa wane chinre.” ");
INSERT INTO pibNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Rumata Geso raluka gepomgaletyaluna. Wane chinna, “¿Gixkakluko gepomgakaka wane nchininri, ‘Pshinitsonu gi getanutkano. Wanepnute pshinitsonu, getanutnakno?’ ");
INSERT INTO pibNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Galikakni, galikakni wane nchingi, wa gixapa chiyagatanu, ga wa gwamonuwatanu. Tyechijne gajene gimuwatanu. Gixa gwamonuwatanu, seyni gwamonnu gimuwlu gixkalurupni. ");
INSERT INTO pibNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Wa suxo tushpakawugenetini, kachinolu teta gi rixanu rapokatka topapko. Wa rushpakinitka mturu gi wa tushinikatkalu tsalewninrinanu, tumuwle chinanu wa tyechijne rushpakinriyatka satu yineru. ");
INSERT INTO pibNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Giyagni xani gixa koxa galikakni kachinolu geta. Seyni netanutnakgi ga wa gimuwgajitanu. Gikeko koningi gimuwle. ");
INSERT INTO pibNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Walegognepa gike gagjitanno gixa. Galikakni, galikakni wane nchingi, klunerukokta gagjitanru Girchi ngiwakaya Wale genekangi. ");
INSERT INTO pibNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Xanigognenanu gike gagjitawa ngiwakaya. Gagjitanru ga wa gyoptotanru tseruwninripa gimuwle. ");
INSERT INTO pibNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Tyekaka yapkaklu tokanchiya nunkakgi. Wa gipapko ginanu, gi wa yapkaklu tokanchiya nunkakangi. Seyni pgujetanwaka nunkakangi Girchipirana. ");
INSERT INTO pibNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Walegogne gixa gagjitanu ngiwakaya. Gi wane nchingi Gita gagjitanru Girchi gixa chinanupa. ");
INSERT INTO pibNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Gi rixanu Girchiko galukgi gi rixanu gixa galukno, ga wa galixno Goyakalu yegi nuyakatya. ");
INSERT INTO pibNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Girchi yegi nushpakamtya. Tyechijne nuna. Nuknokamtanutnaklu tyechijne. Girchi yegi nyanutka.” ");
INSERT INTO pibNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Wane chinruna yimaklene, “Petanu. Xani pgujetanuwaka pchina yanumsaleta. Gi satuna yapkaklu pchina. ");
INSERT INTO pibNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Xawakni wumata Pixa gimatlu ptowrunanuka. Gi pmaga gepomgakota. Tye chinanu walixa Goyakalu yegi puyakatya.” ");
INSERT INTO pibNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Rugitna Geso, “¿Xawakni galixge? ");
INSERT INTO pibNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Gipapko ginanu, runatka, gitspalkakanu. Satkaka rawyawaka yanu. Gitapje giknokamtanu. Seyni gi Gitapjeni, gi rixanu Gitaymalu Girchi. ");
INSERT INTO pibNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","“Tyekaka nunkakgi waneygi nchininripa giglewanshinikanru Gita chinanu. Tyechijne waneyapgi salewakchi. Seyni kiglenshinikanupgi. Gita gaalixaplu tye psolchijneko.” ");
INSERT INTO pibNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Tyekaka wane china Geso. Teno yigata. Wane china, “Nuru, nopapko gapokatka. Puturu gimalwutikolupa Pixa chinanu, wa Pixa koxa gimalwutikolupa Puturu chinanu. ");
INSERT INTO pibNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Wane pixa gitakletno pejnurune yine chinanu, wa pejnuruneko penekyano, Gita genekyapna ruwekinrina gike rixiniko mnikawnakatupa. ");
INSERT INTO pibNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Tyenwa giweklu gike rixiniko mnikawnakatu, wa rumatyapyina, satupjeru Goyakalu galikakpotunanu, ga wa Geso Kristo wa pyokanatanruno. ");
INSERT INTO pibNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Gita chinanu pumalwutikolutka tyechijneya. Nnikatatkalu kamrurchi penekyano nkamrutyaplu. ");
INSERT INTO pibNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Ga wa xani, Nuru, penekanno noyaknu, wa Pixastsi nwini noyaknunanu tye psolchijneko mawanatkanuwa. ");
INSERT INTO pibNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Wa nyi yine tyechijne gajene penekyano, nekakgigiwakatyi. Pixanune, ga wa Gita penekatka. Rumretatokanutyina. ");
INSERT INTO pibNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Xawakni rumatatkaluna pejnurkakako penekyano Pixa ruyakatya. ");
INSERT INTO pibNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Gi rixanu wa tokanchi wa penekyano, nenekatkana. Yoptotatkaluna. Rumatatkaluna galikakpotunanu Pixa yegi nuyakatinri. Ga wa ralixna Pixa yokanatyano. ");
INSERT INTO pibNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Wanna chinanu nagjita. Gi wa tye psolchijne gajeneko chinanu nagjita, seyni penekyano chinanu, gi rixanu Pixanunni. ");
INSERT INTO pibNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Wa pejnuruko wane nixle, Pixa wane gixleni. Pixa wane gixle Gitankoxni. Gimalwutkalurno waleya. ");
INSERT INTO pibNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Gi wa tyechijnetkano, ga wa wanna tyechijne gwawa. Pixa yegi nyanu Gita. Nuru kpashiri, pgiwakaya pumretanna wa penekyano, satupjerune rixinripna, Wixa pixka. ");
INSERT INTO pibNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Wanna yegi nwanatini, Gita gimretanatna pgiwakaya. Wa penekyano numretanatna. Gi satuna gamgiyna wanna, seyni kamchi jiglokanrunapjeni gamgana, poyagkakikolupa wa yonatkaluru. ");
INSERT INTO pibNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“Ga wa xani Pixa yegi nya, ga wa tye wane nchina tyechijneya, waneyna rixinripna numuwle tseruwnapotutachri. ");
INSERT INTO pibNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Gita genekna ptokanu, ga wa tyechijne gajene gayegixna, gi rixanu gi wa tyechijne gajenni, Gitako pixka, gi wa tyechijne gajerno. ");
INSERT INTO pibNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Gi wa nagjita wa Pixa gwapyapna tyechijneya, seyni Pixa girukotyapna mugletuya. ");
INSERT INTO pibNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Gi wa tyechijne gajenni, Gita pixka; gi wa tyechijne gajerno. ");
INSERT INTO pibNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Kpashirine pixkakanna galikaka potu ptokanuya. Galikakpotni ptokanu. ");
INSERT INTO pibNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Wa tye psolchijneko Pixa yokanatno, waneko pixka nixa tye psolchijneko yokanretna. ");
INSERT INTO pibNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Wanna chinanu Gitnanuko kpashiri nixnawa, kpashirine rixinrikoxapna wanna galikaka potu tokanchiya. ");
INSERT INTO pibNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Gi wannapje chinanu nagjita, seyni koxa wa nalixjenepa wanna tokanu chinanu. ");
INSERT INTO pibNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Satupjerune rixinripna pejnuruneko, Pixa pixka, Nuru, Gita pwinri, ga wa Gita Pixa nwinri; wanna koxa satupjerunepa Wixa rawinripna, wa tyechijne gajene galixinripa Pixa yokanatyano. ");
INSERT INTO pibNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Wa noyaknu penekyano, wale nenekatkana. Wa satupjerune rixinripna, Wixa pixka satupjerunwu. ");
INSERT INTO pibNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Wanna nwinri Gita ga wa Pixa Gita pwinri, satupjerune rixpotutinripna, wa tye psolchiijneko gajene gimatinripa Pixa yokanatyano, ga wa pushinikyana Gita pushinikiniko pixka. ");
INSERT INTO pibNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Nuru, wa wanna penekyano naluklu ginakaktanwa Gita, wanna koxa Gita yegi gwanu, wa retyapluna noyaknu penekyano. Gi rixanu Pixa gishinikno tyechijne ma mutaakanuwa. ");
INSERT INTO pibNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","“Nuru poyagkakachri, tyechijne gajene gi gimatyi, seyni Gita gimatyi. Ga wa nyi gimata wa Pixa yokanatyano. ");
INSERT INTO pibNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Gita gimatkakna pgiwaka, ga wa numatkakanna, wa gishiniklewlu wa pushinikyano wanna rawinripa, ga wa wanna nwinripa.” ");
INSERT INTO pibNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Wane chininitka Geso, yatka yimakleneyma. Setro Gapga wakanute yatka, wa sana gwiywaka. Geso jiglokamtlu sana yimakleneyma. ");
INSERT INTO pibNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Ga wa Gota koxa wa samyokjerupa rumatlu sana. Gi rixanu gixo kata wane rapatjetyana Geso ga wa yimakleneyma. ");
INSERT INTO pibNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Giyagni Gota ganikna solalone, wa tsrukakalune sasertotene ga wa Gwariseyonetowrerune. Wane yana yochpiikaluroyma, kataluyma, giylalewapiyma. ");
INSERT INTO pibNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Giyagni Geso gimatlu ptowrunanuka wa ruknogjerupa. Potukle ya. Wane chinna, “¿Katu gijga?” ");
INSERT INTO pibNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Rugitluna, “Geso, Nasare gajeru.” Wane chinna Wale, “Gitni.” Wannaymakoxlu Gota samyokjeru. ");
INSERT INTO pibNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","“Gitni,” chinanna Geso, ruxririkamtanna. Nakgamtanna. ");
INSERT INTO pibNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Giyagni rumepe gepomgaletatnakna, “¿Katu gijga?” Wanna wane china, “Geso Nasare gajeru.” ");
INSERT INTO pibNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Rugita Geso, “Nunkakatkagi Gitni. Giyagni Gita gijgini getasha yaletanna nyi,” ");
INSERT INTO pibNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","poyagkakikolupa tokanchi Wale chinyawaka, “Wa penekyano, gi satuna gamgiyno.” ");
INSERT INTO pibNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Giyagni Simo Petro kyoglolewapreru, koshpaklu. Rustaklu sasertotene gitsrukate potu wayegreru, ga wa rustakjepitlu. Potuklejepi rustakyalu. Wayegrechri giwaka Malko. ");
INSERT INTO pibNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Giyagni Geso wane chinru, “Petro, gipata pyoshmakanru yoglolewapi. Wa Girchi genekyano wa girapistono, ¿gi ge nurinro?” Wane china salewnalepapirana. ");
INSERT INTO pibNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Giyagni solalone, ga wa ksolaloteru, ga wa Goteyonetowrerune, wanna kashichlu Geso. Rostutluna. ");
INSERT INTO pibNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Ganasa yegi gapka ranikluna. Gi rixanu Kaygwasu gimatjirni. Walenwa wale walapu sasertotene gitsrukatpotu. ");
INSERT INTO pibNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Walenwa Kaygwasu wa Goteyone giykotachri, wa wane chinachri wa rupxakyapna wa satu jeji gipninripa yine chinanu. ");
INSERT INTO pibNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simo Petro gomkagitlu Geso, ga wa satu yimakleru. Wa tye yimakleru rumata sasertotene gitsrukatpotu. Gesoyma jigloklu sasertotene gitsrukatpotupji. ");
INSERT INTO pibNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Maleka, gipgyaptostsi rawanata Petro. Giyagni rushpaka wa satu yimakleru wa sasertotene gitsrukate potu gimatanru. Ruynumsatlo gipgyapto gajero. Gitoko raniklu Petro. ");
INSERT INTO pibNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Giyagni wa gipxaklewatachro gipgyapto gajero wane chinru Petro, “¿Gi ge tye jeji yimaklerkoxyi pixa?” Wale wane china, “Gi wa gitni.” ");
INSERT INTO pibNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Wane tunwanatna wayegrechine ga wa towrechine, yoshikpawatachine. Gi rixanu kachikleru. Rolkana. Petro koxa wannastsi tunwata. Rolka koxa wale. ");
INSERT INTO pibNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Giyagni wa sasertotene gitsrukate potu gepomgalu Geso, yimaklenepiranaya, ga wa runkaklewleya. ");
INSERT INTO pibNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Geso gigitlu, “Pgujetanuwaka potu nchina yanumsayegletna psolchijneko gajene. Gita ginkaklewjeta ginkaklewwakapjiya, wa rapatjejetyawakna pejnuruneko Goteyone. Gi wa yogimawakako nunkaklewatya. ");
INSERT INTO pibNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿Klu pepomgiyno Gita? Pepomganna wa yijnakotachine wa nchinyawakna. Petanu. Wanna gimata wa nchinyawaka.” ");
INSERT INTO pibNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Wa wane chininitka, satu towrechri wane tunwanatachri giptagojitlu Geso. Wane china, “¿Wane pixa gigletlu sasertotene gitsrukate potu?” ");
INSERT INTO pibNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Rugitlu Geso, “Wa gektutu nyanumsatini, pupgujetanru gektutu, ga wa kigleru, ¿klu chinanu puylakno?” ");
INSERT INTO pibNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Giyagni sasertotene gitsrukate potu Kaygwasu yegi yokanatlu Ganasu gostutkaluru. ");
INSERT INTO pibNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Wa Simo Petro tunwa golkalenatachri. Wane chinruna, “¿Gi ge satu yimaklerkoxyi pixa?” Wale nutata. Wane china, “Gi wa gitni.” ");
INSERT INTO pibNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Satu sasertotene gitsrukate potu wayegreru, wa Petro gistakjepmoletanru, wane chinru, “¿Gi ge sana netyayi Waleyma?” ");
INSERT INTO pibNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Giyagni rumepe nutletatnaklu Petro. Waneklu yanumatatka gaxawripa. ");
INSERT INTO pibNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Giyagni Kaygwasu yegi ranikyatkaluna Geso. Tsrupji, Pretoryopji ranikluna. Goyechnokawni. Wannako gi jigloklu Pretoryopji ma puchowninripna, seyni wa Tsru Giknoglushgogne nachnewlu nikinripna. ");
INSERT INTO pibNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Giyagni maleka rushpakyegitna Pilato. Wane china, “¿Klu gijigyegitlu tye jeji?” ");
INSERT INTO pibNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Rugitluna. Wane chinruna, “Gektutu ma kamrutkanumka wa Tye, gimka wsamyokanyi.” ");
INSERT INTO pibNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Giyagni Pilato wane chinna, “Ganikanru gixa. Giklukanuwnayegjixanru Tokanchi Yokanatkaluru gixanu chinyawaka.” Wane chinruna Goteyone, “Ginanshichkaluru wuylatyaplu satu.” ");
INSERT INTO pibNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Wane rixa wa poyagkakikolupa Geso wane chinre, wa rumatkakyana gi pixkalutu gipukchi rupninripa. ");
INSERT INTO pibNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Giyagni Pilato rumepe jiglokletlu Pretoryopji. Tomsatlu Geso. Wane chinru, “¿Pixni Goteyone Pogiryi?” ");
INSERT INTO pibNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Rugita Geso, “¿Pixako pushinikanrerge wane pchina, waka pimrinra ginkakyi wa Gitaya?” ");
INSERT INTO pibNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Rugita Pilato, “¿Gitlege wa Goteyo? Pumolene ga wa tsrukakalune sasertotene gita samyokyina. ¿Kluneru pkamruta?” ");
INSERT INTO pibNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Rugita Geso, “Wa npogirewatyawaka gi wa tyechijne rawa. Tyechijne rawkamka npogirewatyawaka, ntowrerune yagotkakanmaka nma samyokikotupmaka Goteyone yegi. Ga wa xani npogirewatyawaka gi wa gewi rawa.” ");
INSERT INTO pibNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Giyagni wane chinru Pilato, “Giyagni ¿pogirchiklayge Pixa?” Rugita Geso, “Pixa wane chinyawaka pogirchi nixinri. Wale chinanukni nushpaka, ga wa wale chinanukni nuna tyechijne, nupgujtatyaplu tokanchi galikakpotunanu. Pejnuruko galikakpotunanu gixachri yijnaktokanutno.” ");
INSERT INTO pibNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilato wane chinru, “¿Klunerni wa galikakpotunanu?” Wa wane chininitka rushpakatnaka Goteyone yegi. Wane chinna, “Gi satuna nukshikyalu ruklukanuwninri. ");
INSERT INTO pibNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Wa gixa gixjetyawaka satu nkoshpakyegityagi tsru Giknoglushgogne. ¿Giyagni gi ge galuklu gita koshpakyegityapgi Goteyone Pogire?” ");
INSERT INTO pibNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Giyagni pejnuruneko gimepe saplewletatnaka. Wane chinna, “Gi wa Tyepni, seyni Warawasu galikakapni.” Ga wa Warawasni kachowgurni. ");
INSERT INTO pibNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Giyagni Pilato gwapatkalu Geso. Kochipjejixlu. ");
INSERT INTO pibNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Solalone kona kamgiylona sagyeta. Yoshmakjiwutluna. Pakniga yoshmookaluru pixkalutu mkachri yoshmakluna. ");
INSERT INTO pibNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Wane chinna, “¡Galu, Goteyone Pogire!” Ruylakluna. ");
INSERT INTO pibNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilato gishpakatnaka maleka. Wane chinna, “Getanu. Nanikyegitgi maleka, wa gimatinripa gi satuna ruklukanuwninri nukshikyalu.” ");
INSERT INTO pibNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Giyagni rushpaka Geso maleka. Sagyeta kona kamgikolo rutaka, ga wa pakniga yoshmookaluru pixkalutu mkachri. Wane chinna Pilato, “Getanru wa jeji.” ");
INSERT INTO pibNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Giyagni retinitkaluna tsrukakalune sasertotene ga wa towrechine, saplewatna. Wane chinna, “¡Koroshishkita putakaganru! ¡Koroshishkita putakaganru!” Pilato wane chinna, “Gixako ganikanutkalu. Koroshishkita gitakanru. Gi rixanu gita gi gikshikyalu wa ruklukanuwninri.” ");
INSERT INTO pibNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Rugitluna Goteyone, “Wixa waneya Tokanchi Yokanatkaluru. Tokanchi Yokanatkaluru wixanu chinyawaka rumkata gipnaleta, gi rixanu Goyakalu Wgene rixnawa.” ");
INSERT INTO pibNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Tye tokanchi jeminitka Pilato, pnute pikletkalu. ");
INSERT INTO pibNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Rumepe jiglokletatnaklu Pretoryopji. Wane chinru Geso, “¿Ginaka giyakatyachriyi?” Seyni Geso gi gigitlu. ");
INSERT INTO pibNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Giyagni wane chinru Pilato, “¿Gita gi wa puynumsata? ¿Gi ge pumata wa gita gitaaka koroshishkita nutakyapyi, ga wa nutaaka nkoshpakyapyi?” ");
INSERT INTO pibNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Rugita Geso, “Tengogne pma mutaakikamka gimka putaako Gita chinanu. Giyagni pixa yegi nsamyokjeru pixa pnute tsru mukochri waneylu wale.” ");
INSERT INTO pibNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Wanekluyakawa Pilato galukmaka koshpakletlu. Seyni Goteyone saplewata. Wane chinna, “Wa Tye pkoshpakinipa, gi wa Susa gimatjerpatkayi. Girukokta pogirchi rixnawa yoptopiratlu Susa.” ");
INSERT INTO pibNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Giyagni Pilato tye tokanchi yijnakotinri, maleka ranikatkalu Geso. Gitakyagoklewjetikwaka tuplata, wa Sotlumta chinikwaka, ga wa Gewreyone tokanu, Kawata. ");
INSERT INTO pibNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Tsru Giknoglushgognestsitkani. Tumananutkani. Wale wane chinna Goteyone, “Getanru Mpogire.” ");
INSERT INTO pibNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Giyagni wanna saplewata, “¡Puxriikakanru! ¡Puxriikakanru! ¡Koroshishkita putakaganru!” Wane chinna Pilato, “¿Wa koroshishkita nutakanru mpogire?” Rugitluna tsrukakalune sasertotene, “Maleshaywu wpogire. Susapjeni.” ");
INSERT INTO pibNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Giyagni samyoklu koroshishkita rutakyapluna. Yoptotluna Geso. Ranikatkaluna. ");
INSERT INTO pibNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Rutjitakoroshiteshkitatatka. Ralimta. Jiwchiswaga yegi chinikowaka ya. Gewreyone tokanu wane chinka Kolkota. ");
INSERT INTO pibNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Wane koroshishkita rutakyaluna, ga wa Waleyma pimrine gepi. Satkaka pasretkaka. Geso ganikaji gwa. ");
INSERT INTO pibNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Yonatkoxlu Pilato jigyegitikolupirana. Koroshishkitaptostsi rutaklu. Wane chinyongata: ");
INSERT INTO pibNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Giyagni gixo Goteyone getyongatlu tye jigyegitikolu, gi rixanu koroshishkita rutakikwaka Geso, gi gowuklu tsru pokchi. Gewreyone tokanu yonatika, ga wa Ratinane tokanu, ga wa Kriykone tokanu. ");
INSERT INTO pibNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Giyagni tsrukakalune sasertotene Goteyonenu wane chinru Pilato, “Gi wa ‘Goteyone pogire’ pchinkakyongatanru, seyni, ‘Wale wane china, “Goteyone Pogirno” ’ ” ");
INSERT INTO pibNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Rugita Pilato, “Nyonatanrutkani nyonatatka.” ");
INSERT INTO pibNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Giyagni solalone koroshishkita gitakinitkalu Geso, rawamkatatkaluna. Gepkoxamkoje kotspaltatyatkaluna, satkaka solalonenupa. Ga wa gimkaluchrata. Wa gimkaluchrata myotsgakotni. Teno ruyaka saxpaletika psoluko. ");
INSERT INTO pibNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Giyagni wannakakluko wane chinkaka, “Gi wa wsuskakanru, seyni wupenokatanru galikaka katunpaktani wa mkachri.” Wane rixa poyagkakikolupa wa yonchi wane chinachri: Kotspalatluna nomkalu wannanupa rixinripa. Nomkalu chrata rupenokotna. Giyagni wane rixna solalone. ");
INSERT INTO pibNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Geso koroshishkitatestsi koxa tunwanatna runro, ga wa runro gepuro, ga wa Mariya wa Kleyogwa gnunro, ga wa Mariya Maktala gajero. ");
INSERT INTO pibNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Giyagni Geso getinna runro ga wa yimakleru rushinikanru wane gwanatachri, wane chinro runro, “Suxo petanru puturu.” ");
INSERT INTO pibNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Wanepnute wane chinru yimakleru, “Petanro punro.” Wanekluyakawa yimakleru ganiklo waleyma tixinripa. ");
INSERT INTO pibNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Wanepnute gi rixanu rumata Geso pejnurkakako poyagkaakalurutkani wa yonchiko poyagkakikolupa, wane china, “Nonunnagatewata.” ");
INSERT INTO pibNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Wanenanro pastono kachgalu gwanro katsepolo. Giyagni wanna shichpongakaklu katsopi kachgalu. Gisopoje rutakluna. Ginama rapookakluna. ");
INSERT INTO pibNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Giyagni kachgalu rurinitka Geso, wane china, “Nikatkalurutkani.” Yonogjiwumta. Reneklu ruwekinri. ");
INSERT INTO pibNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Tsru Giknoglushgognestsitkani, ga wa tsrupotgognenwa wale gapnanutikalurgogne. Giyagni koroshishkita ma mutukmanetinitipna gapnanutikalurgogne, Pilato ragjitna Goteyone jiknagatpalitikolupna, wa koroshishkita koshpakikolpatkana. ");
INSERT INTO pibNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Giyagni solalone wane ya. Yoptowaka gwachrigapkani jiknagatpalitna. Waneko pixka rixanruna wa satni wa Waleyma koroshishkita gitaakalurni. ");
INSERT INTO pibNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Seyni wa Gesni yegi rapokinna gi rixanu retluna gipnachritka, gi wa jiknagatpalitatkaluna. ");
INSERT INTO pibNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Seyni satu solalo yoglokwanapatlu chokorujeya. Waneklu rushpaka gigraga, gonu koxa. ");
INSERT INTO pibNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Wa getachri gipgujtatlu, ga wa rupgujtale galikaka potu. Wale gimata wa galikaka potu china, wa gixa koxa galixinripa. ");
INSERT INTO pibNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Gi rixanu tyekaka wane gixka poyagkakikolupa wa yonchi chinikwaka: Gi jiknagaputko Wale. ");
INSERT INTO pibNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Ga wa satu yonchi koxa wane chinatnaka: Retanruna yoglotanruna. ");
INSERT INTO pibNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Wanepnute Gosi Garimate gajeru, Geso yimaklerni seyni giyogimatnachriwa Goteyone pikle chinanu. Pilato ragjita wa Gesnimane koshpakinripa. Ruchichlu Pilato. Giyagni wane ya. Koshpakmanetlu Geso. ");
INSERT INTO pibNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikotemo koxa wane ya, wa muchikawa goyechno yayegitjeru Geso. Raniklo miramunga ga wa galowemunga yapjetkaluro, gepkoxamkojmole patsrujire getko ginnu. ");
INSERT INTO pibNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Ranikmanetatkaluna Gesni. Poyitatkaluna mkachrichrata. Pgamlugalo rupoyitluna wa Goteyone gixjetyawaka kapnatikolupa. ");
INSERT INTO pibNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Wa koroshishkita rutakikwaka waneru sana. Wa sana waneru gerotu yomlechi, satuna ma mutakikowakanuwa. ");
INSERT INTO pibNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Giyagni gi rixanu Tsru Giknoglushgognestsitkani Goteyonenu, ga wa gi gowuklu yomlechi, wane rutakluna Gesni. ");
INSERT INTO pibNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Muchinangogne wa simana, goyechnokawpotuko mapshagakowalu yomlechi tya Mariya Maktala gajero. Tetlu sotlu gajriikaluru yomlechiya. ");
INSERT INTO pibNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Giyagni tasukamta. Simo Petro yegi tya, ga wa satu yimakleru Geso galukanru. Wane chinna, “Kapna ranikyatkaluna Gitsrukaachini. Gi wumata ginaka rutakanruna.” ");
INSERT INTO pibNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Ralimta Petro ga wa satu yimakleru. Yomlechi yegi yana. ");
INSERT INTO pibNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Pagasukamtkalunni gepi. Wa satu yimakleru kapnugamtlu Petro. Wale gapka gapoklu yomlechi. ");
INSERT INTO pibNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Rujnoka getletlu. Retlu mkachrichrata wane gwanatachri. Seyni gi wa jigloka. ");
INSERT INTO pibNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Giyagni rapoka romkagitjeru, Simo Petro. Jiglokamtlu kapna. Retlu mkachrichrata wane gwanatachri. ");
INSERT INTO pibNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Ga wa kasamalu wa gijiwu sapwakanatachri gi wa mkachrichratayma rawanata, seyni sapruruukaluru pasretako gitaakaluru. ");
INSERT INTO pibNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Giyagni jiglookoxatka satu yimakleru wa yomlechi gapokgapkatachri. Retlu. Ralixa. ");
INSERT INTO pibNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Giyagni gi rumatawaluna yonchi chinyawaka, wa rumkata yotunretinripa gipnachinetskalaya. ");
INSERT INTO pibNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Giyagni satokatnakna yimaklene gimolenyegna. ");
INSERT INTO pibNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Wa Mariya maleka tunwanata. Yomlechistsi chiyaganatya. Wa chiyaganatini tujnoka tetyaplu kapna. ");
INSERT INTO pibNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Tetna gepi Goyakalutowrene klatamkalune tuplanatachine, satu gijiwusretananu, ga wa satu gijixisretananu Gesomane gwanatyawaka. ");
INSERT INTO pibNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Wane chinrona, “Suxo, ¿klu kachokyi?” Wane chinna wala, “Gi rixanu ranikluna Nutsrukatni. Gi numata ginakakta rutakanruna.” ");
INSERT INTO pibNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Wane chininitka tuprotaka. Tetlu Geso. Wane rawanata. Gi tumatlu wa Geso rixinri. ");
INSERT INTO pibNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Wane chinro Geso, “¿Suxo, klu kachokanatyi? ¿Katu pujga?” Wala kagwaklu sana girukotachrini. Wane chinru, “Gitsrukaachi, Pixa ganikiniplu punkakanno ginaka putakniri. Gita ganikanutkalu.” ");
INSERT INTO pibNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Wane chinro Geso, “¡Mariya!” Tuprotaka. Wane chinru wala, “¡Rawoni!” Wane chinreni, “Yimaklewatachri.” ");
INSERT INTO pibNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Wane chinro Geso, “Gi pkamrukanno, gi rixanu gi wa teno nyawa Gita, Nuru yegi. Seyni nomolene yegi pyanu. Punkakanna, ‘Teno nyanu Nuru yegi ga wa Giru yegi, Noyakalute yegi, wa Goyakalute yegi.’ ” ");
INSERT INTO pibNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Talimta Mariya Maktala gajero. Tunkakna yimaklene wa tetyawakatkalu Gitsrukaachi, ga wa tyepirana wane chinro. ");
INSERT INTO pibNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Wa muchinangogne simana kaynotka, tushyatka gipgyaptokaka wa yimaklene gapatyawaka Goteyone pikle chinanna, runa Geso. Wanna ganikajite tunwata. Wane chinna, “Kiglenshinikanupgi.” ");
INSERT INTO pibNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Wane chininitka rekakgimyotna ga wa gikwanapa. Giyagni yimaklene gimuwata retyawakluna Gitsrukaachi. ");
INSERT INTO pibNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Giyagni rumepe wane chinretatnakna Geso, “Kiglenshinikanupgi. Wa Girchi yokanatiniko pixkano Gita, waneko pixka nixa yokanretgi.” ");
INSERT INTO pibNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Wane chininitka, runnipgyayegitna. Wane chinna, “Gyoptotanru Giwekikaluru Kpashiri. ");
INSERT INTO pibNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Wa gixa kaspukmukochiretanune, kaspukyegitkalunepni. Wa gimretmukochiretanune gimretyegitkalunepni.” ");
INSERT INTO pibNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Wa Tomasu, satu wa pamole gepi rixinrina, wa Gepirutu chinkaluru, gi wannayma wane rawanata wa Geso gapkapini. Giyagni wane chinruna pimrine yimaklene, “Gitsrukaachi wetatka.” ");
INSERT INTO pibNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Wane chinna wale, “Nma metkanuplu wa gimyo wa klawopchole, nma yoshmaakanuplu nomyoji klawopna, nma yoshmaakanuplu nomyo gikwanapa, gi nalixanu.” ");
INSERT INTO pibNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Yokgipgogne giknoginitka, gitoko rawanatatnakna yimaklene. Wannaymakoxlu Tomasu. Runa Geso. Gipgyaptokaka gishyatka. Ganikaji tunwata. Wane china, “Kiglenshinikanupgi.” ");
INSERT INTO pibNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Wane chinatkalu Tomasu, “Pomyokyegitanno pumyoji. Petamyotanno. Pomyokyegitanno. Nokwanapa pyoshmakanru. Gi wa malixakletupyi, seyni galixachripyi.” ");
INSERT INTO pibNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Wa Tomasu gigitlu. Wane chinru, “¡Nutsrukate! ¡Noyakalute!” ");
INSERT INTO pibNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Wane chinru Geso, “Gi rixanu petno, palixa. Giglenshinikanutkalunni nmametjene ga wa galixachine.” ");
INSERT INTO pibNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Giyagni gi gepi pimrikaka getkalurkaka kamruta Geso, yimaklene getanu, twu kiruka mutakyongatkotu. ");
INSERT INTO pibNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Tyekakni yonatkaluru galixinripa Gesonwa Kristo Goyakalu Wgene, ga wa galixinri waneyapgi giwekinri giwakaya. ");
INSERT INTO pibNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Wanepnute Tiwerya Wenne rupgujewnayegitatnakna yimaklene Geso. Wane rixa gipgujewnaleta. ");
INSERT INTO pibNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Rapatanatna Simo Petro, ga wa Tomasu wa Gepirutu chinkaluru, ga wa Natanayli, Kana gajeru Kalilesreta, ga wa Sewereyo wgenene, ga wa pimrine gepi yimaklene. ");
INSERT INTO pibNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Wane china Simo Petro, “Nchaluntapanu.” Wane chinruna, “Gapakapwu pixayma.” Wane yana. Kanawa ruptekna. Wale yechno, gi satona kashichna. ");
INSERT INTO pibNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Goyechnokawa chininitka, wanga tunwanata Geso. Seyni wa yimaklene gi rumatluna Geso rixinri. ");
INSERT INTO pibNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Wane chinna, “Wiwine, ¿gi ge waneygi gnikanrupa?” Rugitluna, “Malesha.” ");
INSERT INTO pibNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Wale wane chinna, “Kanawa potuklesretate giknokanru chalu. Gikshikanro.” Giyagni ruknokluna. Gi rumkata kosletatkaluna, gi rixanu gi gepiklo shima. ");
INSERT INTO pibNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Giyagni wa yimakleru Geso gishinikanru wane chinru Petro, “Gitsrukaachikni Wale.” Giyagni wa Simo Petro wa yijnakotinitka Gitsrukaachi rixinri, gimkalu sapwaknawa gi rixanu mamkatunanni. Tsru wenu ruptekgamtatka. ");
INSERT INTO pibNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Ga wa pimrine yimaklene kanawa yapamta, gi rixanu gi gowuklu chiji, seyni pamyomolestsi getko gowuknuni. Kosemtluna chalu shimayma. ");
INSERT INTO pibNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Giyagni chiji ruptekinitkana, retluna chichpawa giglepokotkaluru, ga wa shima gitaakaluro, ga wa jimapro. ");
INSERT INTO pibNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Wane chinna Geso, “Ganikanro shima, wa gkashichanronatka xani.” ");
INSERT INTO pibNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Ratskotlota Simo Petro. Chiji kosemtlu chalu. Katsepomnuro tsrokaka shima. Satu pacha pamyomole mapa shima. Wane pejnumkalo, seyni gi ruskaka chalu. ");
INSERT INTO pibNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Wane chinna Geso, “Ginanutka. Gnikanutka.” Gi satuna yimakleru tserpiranawata wa repomgiyaplu, “¿Katyi Pixa?” Rumatluna wa Gitsrukaachi rixinri. ");
INSERT INTO pibNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Runa Geso. Koscheklu jimapro. Renekna. Waneko pixka rixlo shima. ");
INSERT INTO pibNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Tyenwa mapa kata chininri rupgujewna Geso yimaklene yegi wa gipnachinetskalaya rali yotunretinitka. ");
INSERT INTO pibNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Giyagni rali nikaprikletinitkana Geso wane chinru Simo Petro, “Simo Gonasu wgene, ¿gi ge pushinikno wa nyi pnute?” Wane chinru, “Gigi, Gitsrukaachi. Pixa gimata nalukyayi.” Wane chinru, “Peneka nikletanna noprane gowega wgenene.” ");
INSERT INTO pibNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Rumepe wane chinretatnaklu, “Simo, Gonasu wgene, ¿gi ge pushinikno?” Wane chinru, “Gigi, Gitsrukaachi. Pixa gimata nalukyayi.” Wane china, “Peneka nikletanna nowegatene.” ");
INSERT INTO pibNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Mapa kata chininri wane chinru, “Simo, Gonasu wgene, ¿Gi ge palukno?” Wamontaklu Petro wa mapa kata chininri wane chinru, “¿Gi ge palukno?” Wane chinru, “Gitsrukaachi, Psoluko pumata. Pixa gimata nalukyayi.” Wane chinru Geso, “Peneka nikletanna nowegatene. ");
INSERT INTO pibNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Galikakni, galikakni wane nchinyi wa makluji pixini pushrikapchijitnawa. Palukyawaka pya. Wa tsrutsoleji pixini pkanrakanu. Satu gishrikapchijitanyi. Ranikanyi pma maluka yaletyawakanu.” ");
INSERT INTO pibNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Tyenwa china rumatkakyaplu gi pixkalutu gipukchi chinanu rumalwutikolupa Goyakalu. Wane chininitka wane chinru, “Pomkagitanno.” ");
INSERT INTO pibNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Ruprotaka Petro. Retlu wa yimakleru wa Geso gishinikanru romkagitjerna, wa rutspanostatkoxjeru nikikowakaya, wa wane chinachri, “Gitsrukaachi, ¿katupni wa psamyokjerupa?” ");
INSERT INTO pibNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Giyagni Petro getlu wale. Wane chinru Geso, “Gitsrukaachi, ¿ga wa tye, gi rixanu?” ");
INSERT INTO pibNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Wane chinru Geso, “Nalukiniplu rutukanu wale nuninpotunanuko, ¿gi pixanru pixa? Pomkagitanno pixa.” ");
INSERT INTO pibNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Giyagni rushpaka tye tokanchi wa moletkakachinkakluko, wa tye yimakleru gi wa rupnanu. Seyni wa Geso gi wane chinru, “Gi rupnanu,” seyni, “Nalukiniplu rutukanu wale nuninpotunanuko, ¿gi pixanru pixa?” ");
INSERT INTO pibNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Tyenwa yimakleru gipgujtatachri tyekakapirana. Wale yonatlu tyekakapirana. Wumatlu wa rupgujtalewle galikakpotunanni. ");
INSERT INTO pibNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Gi gepiikoxlu wa Geso kamrutanru. Satkaka yonatkamka walepje rixinri, nkagwaklu gi wa tye psolchijneko poyagotlo kiruukaka yonatkalurupmaka.");
INSERT INTO pibNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Teyogwilo, muchinanu tokanchi nunkakyayi pejnurukopirana wa Geso kamrurewatinitka ga wa runkaklewatinitka. ");
INSERT INTO pibNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Psoluko nunkakatkayi yinuwakleyakawa ga wa tengogne yoptotikolgognepotunanuko. Wa tengogne ma yoptotikonuwa towutamtna yokanatanune wa tsomitanune. Giwekikaluru Kpashiriya towutamtna. ");
INSERT INTO pibNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Muchinanu salewnanata Geso. Rali salewnaletinitka, gepkoxamkojmolgogne rupgujewnayegitatkana wanna giwekachritka. Gixo waneylu rumatpotutikolu. Goyakalu pogirewatyawaka runkakleta. ");
INSERT INTO pibNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Waleyma rapatanatinna, Wale yokanatna Gerosale ma mushpakinitipnachi, seyni wane kagwakinrina Girchi gipiratanru “wa gixa yijnakotyano,” china, ");
INSERT INTO pibNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","“Gi rixanu Gwa katlewata galikakni gonuya, ga wa Giwekikaluru Kpashiri gkatikolupa gixa. Gi gixogogne potu magatatka.” ");
INSERT INTO pibNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Giyagni wa gapatanatachine gepomgalu. Wane chinruna, “Gitsrukaachi, ¿gi ge xawakni pugletanutnaklu Gisrayiline pogirewatyawaka muchinanu pixka?” ");
INSERT INTO pibNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Wale wane chinna, “Gi gimkata gimatletlu walegognekaka, gi wa gipapkoko wa Girchi gitakanru Waleko girukotyaplu. ");
INSERT INTO pibNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Seyni gyoptotanru giyaklu Giwekikaluru Kpashiriya, gixa gogo gapokachripa. Nupgujtatjenepgi Gerosaleya, ga wa psoluko Goteya, ga wa Samaryakoxaya, ga wa yoptukyawakpotunanuko tyechijne.” ");
INSERT INTO pibNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Rali wane chinretinitka tyekakapirana, retanatinrina ruxenownakakamtkatka. Kyachgapererumko yoptotlu ma metikotpatka. ");
INSERT INTO pibNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Teno yiganatna yinikopshini. Gepi jejine tunwastsitna, klatalu mkachri gitakachine. ");
INSERT INTO pibNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Wanna wane chinkoxna, “Jejine, Kalile gajene, ¿klu wane ntunwanatya, tengogne gyiganata? Waleko Geso tengogne yoptotikaluru gixyegiya, waneko pixka rixa ginretanu gishingatiniko pixkalu tengogne yinitka.” ");
INSERT INTO pibNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Giyagni Goliwa Magkate chinikowaka satokyatkana. Gerosale yana. Gi gowuklu Gerosaleya, wa gapnanutikalurgogne gimkata yanretikowaka. ");
INSERT INTO pibNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Rapokna. Ratskotna. Tenogruko yana, rawjetyawakna Petro, ga wa Gwa, ga wa Santiyako, ga wa Gantirishi; Wilipi ga wa Tomasu; Wartolo ga wa Matiyo; Santiyako, Galgweyo wgene, ga wa Simo Muchkopiranawatachri, ga wa Gota, Santiyako gepuru. ");
INSERT INTO pibNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Pejnuruneko wanna panshinikanerune gomkagi gagjigognereta, suxoneyma, Mariyayma Geso ginro, ga wa repuruneyma. ");
INSERT INTO pibNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Walegognekaka Petro tunwata moletkakachine ganikajiteya. Wane pejnu getko: satu pacha gepimole gapatjetachine. Wane china, ");
INSERT INTO pibNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Jejine, nomolene, rumkata poyagkakletikolutka wa yonchi Gotnipirana, wa muchikawa chinyawaka Giwekikaluru Kpashiri Tawinamaya. Gotni wa kosekna wa Geso kashichachine. ");
INSERT INTO pibNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Wixayma gitakgiwakatkalurni. Rutaaka tye kamrurchi chinanu. ");
INSERT INTO pibNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","“Giyagni galikakni waleni wenutlu chiji muglenchi wenru chinanu. Rakaxikamta. Rupsheksatumtana. Psoluko rupkakgichkapimtana. ");
INSERT INTO pibNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Kpoginru pejnuruneko Gerosale gwachinyegiya. Wane rixa tyechijne Gaseltama chinkaluru wanna tokanuya. Walenwa Granchichijne. ");
INSERT INTO pibNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Gi rixanu Shikalchi Kirukate wane yonatkalurutkani: Yineru mwiyawakanupni rawyawaka. Gike gwanutkalu. Ga wa: Satu rupekole jiglokanru waleni girukowatyawakmaka. ");
INSERT INTO pibNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","“Giyagni satu nyi jejine wixaymalune gitakikolupa, gi rixanu psolgogneko wixayma rawna ginakakokta wa Wutsrukate Geso jiglokjenatini ga wa rushpakjenatini wixaymananuko. ");
INSERT INTO pibNT_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Gwa katlewatiniyakawa wa wixyegiya tengogne yoptotikolgognepotunanuko. Satu nyi jejine rumkata gitakletikolupa Geso yotunotinri gipgujtatachripa.” ");
INSERT INTO pibNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Rutaakana gepi: Gosi, Warsawa chinkaluru, Poyagkakachri yoklegiwakatachri, ga wa waleyma Matiya. ");
INSERT INTO pibNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Ragjigognetna. Wane chinna, “Gitsrukaachi, Pixni pejnurune gimatgajitachriyi. Pekakgitanwu girni ptsomita wa nyi gepi. ");
INSERT INTO pibNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Walepni tye kamrurewatyawaka ga wa tye yokanatanru kamrure yoptotanu. Wane rutskikyanatka Gotni rawyawakako yinripa.” ");
INSERT INTO pibNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Rutakluna gipenoklu wanna chinanu, ga wa rujruka Matiya chinanu gipenoklu. Rutaaka pamole satupjeyma yokanatanune. ");
INSERT INTO pibNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Poyagkakatkalu pamyomolegogne, Jirgikolpatkagogne. Pejnuruneko panshinikanurune gapatjekaka. ");
INSERT INTO pibNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Walegnapunanu waneru rakagnenekle tengogne giyakatyachri gichkonnipgyalu pixka. Giyampotu rajpokokannipgyata. Wa tuplanatyawakapjina tsepownapogimnuta psolupjipotuko. ");
INSERT INTO pibNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Rupgujewnayegitna katmerolkaka pixkalutu gitspaljemtachri. Satkaka wannatseptagi rapoka. ");
INSERT INTO pibNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Giwekikaluru Kpashiri gwagajpotutatkana pejnuruneko. Yinuwaka yanumletyaluna panerunemnu tokanu wa Giwekikaluru yanumsakakyawakna. ");
INSERT INTO pibNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Gerosale rawna Goteyone jejine kgipashiregolune, pachijnemnunanuka giyakatyachine tengogne rapukote gwachijnejetachri. ");
INSERT INTO pibNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Rakagnenekle gwinitka rapatjetna gixolune. Gi rumatanshinikanutanna gi rixanu satkakneru tokanu yijnako yanumsaletkana. ");
INSERT INTO pibNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Rumyekna. Ruglajitna. Wane chinna, “Getanna. ¿Gi ge Kalile gajenni wa nyi pejnuruneko yanumsatachine? ");
INSERT INTO pibNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","¿Gi wixpoko wixa satkakwu wixako tokanuya wa wumushpakanru wtokanu wyijnako yanumletna? ");
INSERT INTO pibNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Wixni Partone, ga wa Metone, ga wa Gelamitane, ga wa Mesopotami gajene, Gote gajene, ga wa Kapatosi gajene, Ponto gajene, ga wa Gasya gajene. ");
INSERT INTO pibNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Prigi gajene, ga wa Pampiri gajene, Gigipto gajene, ga wa pasretkaka Liwya, Surene tukasreta gajene, ga wa Roma giyakatyachine, ");
INSERT INTO pibNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Goteyone ga wa Goteyo gitaknawachine koxa. Krete gwachine, Garawa gwachine, wyijnako yanumsaletna wixako wtokanuya tsru ruyaklekaka Goyakalupirana.” ");
INSERT INTO pibNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Rumyekna pejnuruneko. Gi rumatanshinikanutna. Wane chinkakna, “¿Klunerutkange?” ");
INSERT INTO pibNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Pimrine kgixpiranataklerune. Wane chinna, “Jinanunatkana winga.” ");
INSERT INTO pibNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Giyagni Petro tunwata wa pamole satupjeneyma. Gichko tokanru runkaklewyegitna. Wane chinna, “Jejine, Goteyone, ga wa pejnuruneko Gerosale gwachingi, gimatanru tye. Gyijnakotokanutanno. ");
INSERT INTO pibNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Gi rixanu gi wa gimetachinni wa nyi wa nchinanshinikanutyawaka. Gi rixanu tumananustsiwani. ");
INSERT INTO pibNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Seyni tye kgonutkala wa tokanchi geneklewatachri Gowele chinyawaka: ");
INSERT INTO pibNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Wane china Goyakalu: Wane rixanu ralipregognepatka. Giwekikaluru Gitanu napookakpotutanru pejnuruneko gaji. Tokanchi geneklewatachinepni pwugenene jejine ga wa suxone. Gmaklutene getanru kaygawlukaka. Gixa tsrutene gipnawatanu gipnawlukaka. ");
INSERT INTO pibNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Galikakni walgognepatka nwayegrene, nwayegrerone yegi nyokanatanru Giwekikaluru Gitanu. Tokanchi geneklewatachinepni. ");
INSERT INTO pibNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Koglajrukaka nenekanu tengogneya, ga wa tengognempuko getkalurkaka tyechijneya, jralu, ga wa xirnachri, ga wa chichipgya gimomopgyatachri. ");
INSERT INTO pibNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Kashrijewnanu tkachi. Ruchpokanu. Ga wa ksuru jraplu, ma mapookanuwachi Gitsrukaachi tsru koglajrugogne. ");
INSERT INTO pibNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Wane rixanu girukokta Gitsrukaachi giwaka tomsatanu, wale gognetkaako. ");
INSERT INTO pibNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“Jejine, Gisrayiline gyijnakotanru tye tokanchi: Geso, Nasare gajeru, Walenwa jeji Goyakalu kiglepiranyegiru rixkakanru gixyegiya ruyaklekakaya, ga wa koglajrekakaya, ga wa getkalurkakaya. Tyenwa Goyakalu kamrutanru Waleya gixatskalaya, gimatyawaka koxa gixa. ");
INSERT INTO pibNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Walenwa samyookaluru Goyakalu giglepokotyawaka wa rushinikanru, ga wa muchikawako rumatgognenatanru. Wale gixa gixripkakanru ga wa giylatanru wa kmukochirerunemyoya. Koroshishkita gitakjixanru. ");
INSERT INTO pibNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Wale Goyakalu yotunkaka. Gipukchichino kaspukyalu. Gi rixanu gi rumkata chipetkotatka gipukchiya. ");
INSERT INTO pibNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","“Gi rixanu Tawi wane chinpiranyegitlu: Netlu Gitsrukaachi gita ginaple rawgognenatinri. Gi rixanu npotuklesretate rawa, Gi wa nkomyemyetko. ");
INSERT INTO pibNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Wale chinanu numuwgajita, ga wa numuwleymananuka nyanumata. Ga wa xani nomane koxa gapnanutanu kagwakikolupa chinanu. ");
INSERT INTO pibNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Gi rixanu gi puknokamtanno gipnachine gwiyawaka. Gi koxa puchichanru wa Pixanu mmukochiretu rujpaginripa. ");
INSERT INTO pibNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Pumatkakno giweklugapkaka. Pomjikpotutanno Pixa yegi nixinri. ");
INSERT INTO pibNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Jejine, nomolene, gichichanno nunkakyapgi pgujetanuwaka tsrupotni gitsrukaachini Tawipirana. Wa gipnachrinatka. Kapnatkana. Ga wa giyomle wixyeglu xanigognenanu. ");
INSERT INTO pibNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Giyagni tokanchi geneklewatachri rixinri, Tawi gimatlu wa Wale kawchinanu Goyakalu wane chinru wa Tawiklopishaneya gixmanetyawaka Goyakalu gipgujewnakakanru Kristo pogirewatinripa Tawi pogirewatyawakaya. ");
INSERT INTO pibNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Ma mapookanuwa retinitkalu, runkakletlu Kristo yotunotinripa. Gi wa ruknooko gipnachine gwiyawaka. Gi wa gigituko jpaggianu ");
INSERT INTO pibNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Wa tye Geso yotunkaka Goyakalu. Walepirana pejnurunekwu gipgujtatachinwu. ");
INSERT INTO pibNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Giyagni pogirchi rutaaka Goyakalu potuklesretate. Girchi yegi rawyalu gipiratkaluru Giwekikaluru Kpashiripirana. Rawinitkalu rupkakatkalu wa tye gixa getanru ga wa gyijnakotanru. ");
INSERT INTO pibNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Gi rixanu Tawi gi wa tengogne ya, seyni wale wane china: Gitsrukaachi wane chinru wa Nutsrukate, Npotuklesretate ptuplatanu, ");
INSERT INTO pibNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","Nutakinpotukna pkamnixjene putspanjixgapre rixinripna. ");
INSERT INTO pibNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Gimatankoxlu pejnuruneko Gisrayiliklopishangi wa tyeko Geso wa koroshishkita gitakanru, Goyakalu galikakni gitakatkalu Gitsrukaachi ga wa Kristo rixinripa.” ");
INSERT INTO pibNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Giyagni yijnakotinrina tyepirana, kachingajinatkana. Wane chinkana Petro ga wa pimrine yokanatanune, “Jejine, wumolene, ¿gi wixanutka xani?” ");
INSERT INTO pibNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Ga wa Petro wane chinna, “Genshinikanutanu. Gkatikolupa wa gixa satkakgi Geso Kristo giwakaya, gkaspukmukochiretikolupa. Gyoptotanru Giwekikaluru Kpashiri geneekaluru. ");
INSERT INTO pibNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Gi rixanu gixanupni wa gipiratkaluru, ga wa gwugenenenupkoxapa, ga wa gyoptukaklopishatyawakpotunanuka, gi pejnukta wa Gitsrukaachi Woyakalute tomganunepa.” ");
INSERT INTO pibNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Gixo pimri tokanchi rupgujtalewata. Ruykolewata. Wane china, “Gognetkakikolupa gixa tyegogne gimuweekakanatachine mpotukanyegiya.” ");
INSERT INTO pibNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Giyagni wa yoptotokanutjene katka. Yogniikalunni walegogne mapa waragka getko yine. ");
INSERT INTO pibNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Yokanatkalune ginkaklewle romkagitna. Romkagi gimatkakletna. Romkagi jiknajroletlona jimapro. Romkagi gagjigogneretna. ");
INSERT INTO pibNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Pejnuruneko yine pika. Gixo koglajru ga wa getkaluru kamrutka wanna yokanatkaluneya. ");
INSERT INTO pibNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Pejnuruneko galixachine gimwakaka. Ptowrunanuka rejnunkatna pejnurune wane gixleni. ");
INSERT INTO pibNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Rushankaluna rejnunkatna, wane rixlena. Kotspalkakyana pejnuruneko wa satkaka magatyawaka. ");
INSERT INTO pibNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Wane rixjegognenatna kpashiwakapjiya panshinikanurune pagognemnunanuka. Jiknajrojetlona jimapro panchikakaya. Paniikalunni gimuwatachine, myokwirgajine. ");
INSERT INTO pibNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Rumalwutluna Goyakalu. Kiglepiranyegirune pejnuruneko yinyegiya, ga wa Gitsrukaachi yognikananumtna pagognemnunanuka gognetkaakalunepa gapatjetachine yegi. ");
INSERT INTO pibNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Petro ga wa Gwa kayinwaka gagjigognepapko kanikna. Kpashiwakapji yana. ");
INSERT INTO pibNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Satu jeji rushpakinyakawa myankatu gwapjetka. Pagognemnunanuka kpashiwakapji gipgyaptotestsi rutakluna, wa Kigleru potu Gipgyapto chinikowaka. Wa kpashiwakapji jiglokachine ragjitinripa sroschi. ");
INSERT INTO pibNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Wale getna Petro ga wa Gwa kpashiwakapji jiglokachinepa. Sroschi ragjitna renekyapluna. ");
INSERT INTO pibNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Ga wa Petro Gwayma yopukgatluna. Wane chinru, “Petanwu.” ");
INSERT INTO pibNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Wa wale getpotutna. Kagwakanata pagixanu yoptotinripa, wanna genekashatyaplu. ");
INSERT INTO pibNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Petro wane china, “Maleshayno sroschi, gi wa koriko. Seyni satu waneyno. Wale nenekyi. Geso Kristo Nasare gajeru giwakaya, palnanu. Pyananu.” ");
INSERT INTO pibNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Potuklemyo kashichyalu. Palnakaklu. Waneklu gichko rixkatka gijixi ga wa giygaleji. ");
INSERT INTO pibNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Rupteka tunwaleta. Yanatka. Wannayma jiglokamtatkalu kpashiwakapji. Yanamtatka. Ruptemta. Rumalwumtlu Goyakalu. ");
INSERT INTO pibNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Pejnuruneko yine geta yanretlu ga wa rumalwumtlu Goyakalu. ");
INSERT INTO pibNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Rumatluna wa kpashiwakapji Kigleru Gipgyaptotestsi tuplajetachri sroschi gagjijetachri. Ruglajpotutanna. Rumyekpotutanna wa wane rixinritka. ");
INSERT INTO pibNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Wa myankatunanu gigletkalurutka kashichna Petro ga wa Gwa. Pejnuruneko yine potogiwnayegitna Salomotamnu chinikowakaya. Giglajitachine. ");
INSERT INTO pibNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Petro getlu. Wane chinna yine, “Jejine, Gisrayiline, ¿gi gixge giglajita wa tyeya? ¿Klu chinanu gyopukgapotutwu, wixako wuyaklepgutlege, wixako wupashirenupgutlege wyankakyalu wa tye? ");
INSERT INTO pibNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Gawra Goyakalute, Gisaakanu, Gakowonu, wutsrukatenni Goyakalute tsru pogirewlu renekanru Gituru Geso, wa gixa samyokanru ga wa ginutatanru Pilatyegiya. Giklukanuwnayegjixlu wa kaspuukalurupmaka. ");
INSERT INTO pibNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Gixa ginutatlu wa Kpashiri ga wa Poyagkakachri. Gixa gagjitlu genekikolupa kgiylalewakleru. ");
INSERT INTO pibNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Giylatanru giweklu genekachri wa Goyakalu yotunkakanru gipnachine tskalaya. Walenwa gipgujtatachinwu wixa. ");
INSERT INTO pibNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Ralixgiwakatko chinanu, giwaka gichko rixkaklu wa tye, gixa getanru ga wa gimatanru. Wa galixlu Wale chinanu, tye gituukakpotutlu gixa pejnurunekgi getanu. ");
INSERT INTO pibNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Ga wa xani, nomolene, numatlu wa gma mumatkanchinanu wane gixlu, gitsrukatene pixka koxa. ");
INSERT INTO pibNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Giyagni Goyakalu poyagkaklu wa muchikawa runkaklewjixanru pejnurunniko tokanchi geneklewatachinninamaya, wa Kristote salewninripa. ");
INSERT INTO pibNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Giyagni genshinikanutanu. Gkashrijetko, powratkalunepgi gmukochireya, ");
INSERT INTO pibNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Gitsrukaachyegiya runinipa giyalganshinikanrugogne, ga wa Geso Kristo yokanyegityapgi, wa muchikawa gixa chinanu gitaakaluru. ");
INSERT INTO pibNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Galikakni rumkata tengogne chipetletlu wa rugletkoklungognepotunanuko ptowruko. Wale runkakleta Goyakalu, Walenune kpashirine tokanchi geneklewatachinnamaya, muchikawa potu gwapachinni. ");
INSERT INTO pibNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Gi rixanu Moysisi wane china, ‘Gitsrukaachi Goyakalute gipgujewnakakyegitangi Tokanchi Geneklewatachri satu gimolepa gita pixka. Wale gyijnakotanu pejnurkakako Wale ginkakangi. ");
INSERT INTO pibNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Wane rixanu: Girukokta yineru gi yijnakotanru Wale Tokanchi Geneklewatachri, nikatkalurupni yinyegiya.’ ");
INSERT INTO pibNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","“Pejnuruneko tokanchi geneklewatachine, Samoyroni muchichachri ga wa gapkatamtachine, pejnuruneko ginkaklewatachine ginkakletpiranatlu tyegognekaka. ");
INSERT INTO pibNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Gixni wa tokanchi geneklewatachinniklopishangi. Gixa chinanni wa gipiratkaluru wa Goyakalu gipiratyana wutsrukatenni. Wane chinru Gawrani, ‘Puklopisha chinanu giglenshinikanyegitkalunepni payinemnunanuka tye psolchijneko gwachine.’ ");
INSERT INTO pibNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","“Rali yotunkakletinitkalu Gituru Goyakalu gixa yegi gapka yokanatlu ruglenshinikanyegityapgi gkashrijetikolupa satkaka gma muglenuya.” ");
INSERT INTO pibNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Wanna Petro ginkaklewyeginatinna yine, sasertotene gapyegitna kpashiwakapji gitsrukateyma ga wa Sariseyone. ");
INSERT INTO pibNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Kojwakanshinikanutkana wa Goyakalupirana runkakikolutkana yine, ga wa Geso chinanu yotunkoklunchipa gipnachinetskalaya runkaakana. ");
INSERT INTO pibNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Kashichkana. Yoshmakikowaka rutaakana waleprikpotunanuko, gi rixanu kayitkani. ");
INSERT INTO pibNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Seyni gixo tokanchi yijnakonatachine galixa. Wane pejnugetkona jejine pamyo waragka. ");
INSERT INTO pibNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Wane rixatka waleprikgogne Gerosale rapatjetyana rutsrukatenna, ga wa tsrune, ga wa yonchikgapine. ");
INSERT INTO pibNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Ga wa Ganasu Sasertotene Gitsrukatpotu, ga wa Kaygwasu, ga wa Gwa, ga wa Galegantro, ga wa pejnuruneko Sasertotene Gitsrukatpotumolene. ");
INSERT INTO pibNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Wanna ganikajite tunwakaakana. Repomsatkana, “¿Klu giyakluya, katu giwakaya wane gixyalu wa tye?” ");
INSERT INTO pibNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Giyagni Petro Giwekikaluru Kpashiri gwagajitanru potu wane chinna, “Yine gitsrukatengi ga wa Gisrayiline tsrutengi, ");
INSERT INTO pibNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","xawakni gepomsatkalunwu wixinri, satu kigleru chinanu, jeji yayixachri kamrutikoluya, gi rixpoko gituukakota. ");
INSERT INTO pibNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Pejnurunekgi gixa ga wa pejnuruneko Gisrayilinerune gimatanrupa tye: wa Geso Kristo giwakaya rutuka tye yineru. Geso Nasare gajerunwa gixa koroshishkita gitakanru, ga wa Goyakalu yotunkakanru gipnachinetskalaya. Gesoya wa tye jeji gixa getanu gitukachritka tunwatachri. ");
INSERT INTO pibNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Gesonwa Tye: Sotlu myoptotkotu gixaya sotlupji kamrupjitachingi Wale gitaaka yoptowaka gitsejita. ");
INSERT INTO pibNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","“Gi satuna rawa gognewatikaluru. Gi rixanu maleshlu pagiwaka tengogne rapukote renekikolna yine, wa wale chinanu wumkata gognetletikolupa.” ");
INSERT INTO pibNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Retkana pgujetanuwaka china ginkakletna Petro ga wa Gwa. Rumatkana jejine kiruka myimaakone, mumatkanni. Giyagni rumatkana wa Gesoyma rawanatinrina. Tsrukakalune giglajita. ");
INSERT INTO pibNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Retanatluna jeji gituukaakaluru wannayma tunwatachri. Gike rumkata chinretna. ");
INSERT INTO pibNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Yokanatkatkana maleka rushpakinitkana jemanshinikankakjetikowakaya. Jemanshinikankakna wannakakluko. ");
INSERT INTO pibNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Wane chinkakna, “¿Gi wixanutkana wa nyi jejine? Gi rixanu getkaluru pgujetanuru kamrutkaluru wannaya. Pejnuruneko Gerosale gwachine yegi rumatika. Gi wumkata ginutletlu. ");
INSERT INTO pibNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Seyni ma poshalpiranyegitikotupa yinyegiya, wkawgutanna xaniyakawa gikena ma munkakinitpatkana tye giwakaya.” ");
INSERT INTO pibNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Tomgakatnakna. Towutkana ma munkaklewatinitpatkana giketsotaji, gi wa yimaklewatanna Geso giwakaya. ");
INSERT INTO pibNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Wa Petro ga wa Gwa gigitna. Wane chinna, “Gitakyagokanru poyagkakachri chininipa Goyakalu getanu, wa Goyakalu pnute gyijnakotko gixa. ");
INSERT INTO pibNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Gi rixanu gi wumkata kaspukle ginkakletletlu wa wetanru ga wa wyijnakotanru.” ");
INSERT INTO pibNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Giyagni yokanatkatkana. Pnute kawgutkatkana, gi rixanu gi wa rukshiika saletikolupna wa yine chinanu. Gi rixanu pejnuruneko Goyakalu gimalwuta wa wane rixikolutka. ");
INSERT INTO pibNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Gi rixanu wa jeji wa gituukaakalurutka tye getkaluruya, wale waneya gepkoxamkojmole pnute walapu. ");
INSERT INTO pibNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Wa kaspuukana. Wannanune yegi yana. Runkakletluna wa pejnuruko wa tsrukakalune sasertotene ga wa tsrune chinyawakna. ");
INSERT INTO pibNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Rali yijnakletinitkana, panshinikanurune muchkowtokanutna. Wane chinruna Goyakalu, “Gitsrukaachi potu, Pixni wa Goyakalyi, wa tengogne kamrutachriyi, ga wa chiji, ga wa tsru wenu, ga wa ptowrunanuka wanerutu kamrutachriyi. ");
INSERT INTO pibNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Wa putowreru Tawinamaya wane pchina: ¿Klu chinanu matsuwatna payinemnunanuka, Ga wa yine gike gapri rushinikna? ");
INSERT INTO pibNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Tyechijne gajene pogirchine gimalpookakatka, Ga wa tsrukakalune potowruta Gitsrukaachi kamnixachine, Ga wa Kristote kamnixachine. ");
INSERT INTO pibNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","“Gi rixanu galikakpotunanu kpashiri Puturu Geso ptsomitanru chinanu, tye pokchi rapatyana Girore ga wa Ponsyo Pilato, ga wa payinemnunanuka, ga wa Gisrayilinerune. ");
INSERT INTO pibNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Wane rixinripa puyakleya ga wa pushinikanruya muchikawako putakanru wane rixikolupa. ");
INSERT INTO pibNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Ga wa xani, Gitsrukaachi, petanru kawgurna. Penekanna pwayegrene psolpotuyako pgujetanwaka china ginkakletyapluna ptokanu. ");
INSERT INTO pibNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Giyagni wixyempotupyi wane gixkalurkakapa gitskalgalkaka, ga wa getkalurkaka, ga wa koglajrukaka wa kpashiri Puturu Geso giwakaya.” ");
INSERT INTO pibNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Rali gagjigogneretinitkana, rapatjetyawakapjina gimyemyeta. Giwekikaluru Kpashiri psolmuchkonuko jiglokgajpotutna pejnuruneko. Goyakalu tokanu runkakletna pgujetanuwaka. ");
INSERT INTO pibNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Wa gixolune galixachine panshinikanurunni. Gi satuna wane china, “Gitanupjeni,” wa wane rixlemka, seyni ptowrunanuka rejnunkatna pejnurune gejnunkatni. ");
INSERT INTO pibNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Ga wa yokanatanune gipgujtatlu Gitsrukaachi Geso yotunotinri tsru giyaklewluya. Gimutlewatachinpotni pejnuruneko wanna. ");
INSERT INTO pibNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Gi satuna magatyachri wanna. Gi rixanu katukokta kwangixleru sankaka ga wa panchikaka, rushankalu. Raniklu wa rushankanru wenru. ");
INSERT INTO pibNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Yokanatanunejixistsi rutakluna. Reneksatkana satkaka wane rixa magletyawakna. ");
INSERT INTO pibNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Giyagni Gosi, wa yokanatanune wane chinanru yoklegiwaka Wirnawisi (walenwa yokaakaluru Gimnanuklewatachri) Rewineru, Supro giyakatyachri. ");
INSERT INTO pibNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Waneyananru chiji. Giyagni rushankalu. Raniklu wenru. Yokanatkalunejixistsi rutakwenutlu. ");
INSERT INTO pibNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Waneru satu jeji Ganani giwakatletachri. Sagirni ganunro. Rushankalu wane rixlena. ");
INSERT INTO pibNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Psoji kotnukwenutyaluna. Tumata koxa ganunro. Psoji ranika. Yokanatkalunjixistsi rutaklo. ");
INSERT INTO pibNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Petro wane china, “Ganani, ¿klu chinanu Satanasyo tsepotgajityi pyokwitmaklu Giwekikaluru Kpashiri, pkotnukyalu puchijne wenru? ");
INSERT INTO pibNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Pumretanatinri ¿gi ge waneyananyi? Wa pushankinitkalu ¿gi ge pixa chinanni? ¿Klu chinanu pyanshinikangaji kamruretlu? Gi wa yine pyokwita seyni Goyakalu pyokwitmaka.” ");
INSERT INTO pibNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Giyagni Ganani jeminitkalu tye tokanchi, yawnamtanatka. Rupnanatka. Tsru piklu rixna pejnuruneko jempiranyegitachine. ");
INSERT INTO pibNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Palnamtna maklujine. Poyitanatkaluna. Koshpakanatkaluna. Kapnatanatkaluna. ");
INSERT INTO pibNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Gowukshini tjigloka ganunro. Gi tumata wane rixinrinatka. ");
INSERT INTO pibNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Giyagni Petro wane chinro, “Punkakanno. ¿Wane pejnurge gishankiylu wa chiji?” Wala wane china, “Gigi. Wane pejnu.” ");
INSERT INTO pibNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Ga wa Petro wane chinro, “¿Klu chinanu wanerutu nchinanshinikanuta gyantaletyaplu Giwekikaluru Gitsrukaachinu? Petanna gipgyaptostsi rapokatkana pganurni kapnatpachine. Koshpakankoxyina pixa.” ");
INSERT INTO pibNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Waneklu tyawnamtanatka walejixistsiya. Tupnanatka. Jiglokamtna maklujine. Gipnachroni rukshikatkana. Koshpakanatkalona. Tganurustsi kapnatanatkalona. ");
INSERT INTO pibNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Tsru piklu rixna pejnuruneko gapatjetachine, pejnuruneko tyepirana yijnakotachine. ");
INSERT INTO pibNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Yokanatkalune kamrujetlu gixo getkalurkaka, koglajrukaka yinetskalaya. Pejnuruneko panshinikanurune Salomotamnu rawanatna. ");
INSERT INTO pibNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Gi pimrineko tserpiranawata gipxaletletna wanna, seyni wa yine gimalwupotutna. ");
INSERT INTO pibNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Gitsrukaachi galixachine gixolewnananumta wanepnute gixo potu jejine, ga wa suxone koxa. ");
INSERT INTO pibNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Giyagokni gatnugapkaka raniikana yayixachine. Gijeekakayna ga wa shechimtakakaya rutaakana, wa Petro gininipa mayawlepjeko chikletyegimtyapmaklu satu wa wanna. ");
INSERT INTO pibNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Gerosale potowrurutyana gixolune Gerosalesputa gwapokchijetachine. Raniikana yayixachine ga wa kamchine kojwakanune. Pejnuruneko wanna gituukaakalunetkani. ");
INSERT INTO pibNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Wane rixna wa Sasertotene Gitsrukate potu ga wa pejnuruneko waleymalune. Wannanwa Sariseyone mkoje. Ranxatna. ");
INSERT INTO pibNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Kashichkana yokanatanune. Yoshmakikowaka pejnurunenu rutaakana. ");
INSERT INTO pibNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Wa Gitsrukaachitowreru goyechno kotpukaplu yoshmakikowaka gipgyaptote. Koshpakna. Wane china, ");
INSERT INTO pibNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Gyanutka. Kpashiwakapji ntunwatanu. Ginkakanna yine pejnupiranako tye giweklupirana.” ");
INSERT INTO pibNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Wa yijnakotinitkaluna goyechnokawpotuko jiglokluna kpashiwakapji. Wane runkaklewatyana. Ga wa rapatna sasertotene gitsrukate potu ga wa waleymalune. Repuukana jemanshinikankakjetikowaka gajene, ga wa pejnuruneko tsrune mkoje Gisrayiliklopishane. Yoshmakikowaka rawapjixikna. ");
INSERT INTO pibNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Yoshmakikowaka rapokna towrechine. Gi rukshiikana. Satokna wa towrechine. Runkaklewatna. ");
INSERT INTO pibNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","Wane china, “Yoshmakikowaka wukshika gishyatkaluru poyegishyaleru, ga wa girukowatachine gipgyapto ginaple tunwatachine. Wa wkotpukinitkalu gi satuna wukshika gitokogrukoya.” ");
INSERT INTO pibNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Tyepirana yijnakotinna wa sasertotene gitsrukate potu ga wa kpashiwakapji gitsrukate, ga wa tsrukakalune sasertotene gi rumatanshinikanutanna kluneru giknoganutka. ");
INSERT INTO pibNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Satu gapoka. Runkakna, “Wa yoshmakikowaka gitakanune jejine, kpashiwakapji tunwanatatkana. Yine runkaklewyeginatkana.” ");
INSERT INTO pibNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Giyagni kpashiwakapji gitsrukate ga wa towrechineyma wane yana. Wale gwapna. Gi wa psolmuchkonuko, gi rixanu pika sotlujetkotna yineya. ");
INSERT INTO pibNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Rawapkana. Jemanshinikankakjetikowaka tunwakaakana. Sasertotene gitsrukate potu gepomgana. Wane china, ");
INSERT INTO pibNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Gachi wujretpotutatkagi wa tye giwaka gma munkakletinitpatka. Psolpotuko Gerosale mposhalpiranatatkalu ginkaklewle. Galuka giklukletwu tye jejigragaya.” ");
INSERT INTO pibNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Rugitna Petro ga wa pimrine Geso yokanatanune. Wane chinna, “Gi wa yine gimkata galixkota. Goyakalu galikakni. ");
INSERT INTO pibNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","“Wutsrukatenni Goyakalute yotunkaklu Geso, wa gixa giylatanru. Gagmunashkita gixripkakanru. ");
INSERT INTO pibNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Wale Goyakalu potuklesretate tsru potu rutakanru Gitsrukaachi rixinripa ga wa Gognetkaklewatachri, renshinikankakyapna Gisrayiline kaspukamukochiretikolupna. ");
INSERT INTO pibNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Wixni ga wa Giwekikaluru Kpashiri gipgujtatachinwu tyepirana. Wale Goyakalu genekna ralixjene.” ");
INSERT INTO pibNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Wanna yijnakotinri kegeknanuwatna. Jemanshinikankakna ruylatikolupna. ");
INSERT INTO pibNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Giyagni jemanshinikankakjetikowakaya tunwata satu Gwariseyo, Kamalye giwakatletachri. Tokanchi Yokanatkaluru yimaklewatachri. Pejnuruneko yine kagwakpiratanru. Wale maleka koshpakjixna pshinitsonu yokanatkalune. Wane chinna wale, ");
INSERT INTO pibNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","“Jejine, Gisrayiline, ggirukotinwa nyi jejineya wa gkamrutanruyapa. ");
INSERT INTO pibNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Gi rixanu muchikawako rupgujewna Teyota. Tsru chinashatnachriwa. Wane pejnu getko gepkoxamkoje pacha jejine gapatyegitlu. Giylatkalurni. Pejnuruneko ralixjene gipalata. Gikeenanatkanina. ");
INSERT INTO pibNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Wanepnute gitakgiwaakaklugogneni Gota Kalile giyakatyachri gipgujewna. Rawapna gixo yine rawgajxigitjenepa. Walekoxni gipnana. Ga wa pejnuruneko ralixjene rakapalatkana. ");
INSERT INTO pibNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Xawakni wane nchingi, getashatanutkana nyi jejine. Gkaspukanutkana. Gi rixanu tye shinikanchi, wa tye kamrurchi yinenu rixinipa nikawnanu. ");
INSERT INTO pibNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Wa Goyakalunu chininipa gi gimkata nikatletanru, gma mukshikikotupa Goyakalu gyagotinri.” Wane rixa gishinikanutletna Kamalye. ");
INSERT INTO pibNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Tomgakatkana yokanatkalune. Muchinanu kochipjetkana. Rali kochipjeretkoklunutkana, rujretkana wa Geso giwaka ma munkakletinitpatkana. Kaspuukatkana. ");
INSERT INTO pibNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Giyagni wanna jemanshinikankakjetikowaka gajenyegiya yatkana gimuwamtachine, gi rixanu rutaka yagookana rumuknina salewninrina, reyiikana Geso giwaka chinanu. ");
INSERT INTO pibNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Psolgogneko kpashiwakapjiya ga wa papjikakaya gi kaspuka ginkaklewletna Geso Kristopirana, gi kaspuka yimaklewletna. ");
INSERT INTO pibNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Walegognekaka ruxolewnatkana yimaklene, Kriykone tokanu yanumatyachine yegi kegemgayegitna Gewreyone chinanu, gi rixanu wannanu gipnagnurutachrone gi gislagika geneksajetikowakaya pagognemnunanuka. ");
INSERT INTO pibNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Giyagni wa pamole gepine rapatkakna gixolune yimaklene. Wane chinna, “Gi kigleru wa wixa giknokamtyalu Goyakalu tokanu wkamrurewatinripa wa nikikowaka chinanu. ");
INSERT INTO pibNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Giyagni, nomolene, gijganna payokgipre jejine gixkaklukoya kiglepiranyegirune, Giwekikaluru Kpashiri gwagajpotutanunetka ga wa kgimatkalerune. Wanna wutakanu tye kamrurchi chinanupa. ");
INSERT INTO pibNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Ga wa wixa gomkagitanru wagjigognere ga wa wkamrure tokanchi chinanu.” ");
INSERT INTO pibNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Pejnuruneko gixolune yine gigleretlu tye tokanchi. Ga wa tsomitkana Gishtuwa, jeji galixachri potu Giwekikaluru Kpashiri gwagajitanru potu ga wa Wilipi, ga wa Prokoro, ga wa Nikanoro, ga wa Timo, ga wa Parmena, ga wa Nikolasu, Goteyo gitaknachriwa, Gantiyoki giyakatyachri. ");
INSERT INTO pibNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Wa wanna yokanatkalune ginaple tunwakaakana. Yokanatkalune gagjigogneyegitna. Wannatseptagi rutakamyotna. ");
INSERT INTO pibNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Gitsrukaachi tokanu tseruwna. Ruxolewnana yimaklene Gerosaleya. Sasertotene koxa gixolune galixlu tokanchi. ");
INSERT INTO pibNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Wa Gishtuwa kgimutlewakleru potu ga wa kgiyaklewakleru potu rixkaklu Goyakalu. Giyagni wale kamrutlu tsru koglajrukaka, tsru getkalurkaka yinetskalaya. ");
INSERT INTO pibNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Giyagni wane rixna pimrine ginkaklewawakapji gajene Gishpakachinenu, ga wa Sureyone, ga wa Galegantrinone, ga wa Surisyane, ga wa Gasya giyakatyachine. Yoptopiratluna Gishtuwa. ");
INSERT INTO pibNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Gi wa rumkata gaaliretluna rumatkaleya, gi wa Giwekikaluru koxa yanumkakjeru. ");
INSERT INTO pibNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Giyagni yokshatkana jejine wane chininripna, “Wjema wane chinretlu tokanchi mupashiregnuchi Moysisipirana ga wa Goyakalupirana.” ");
INSERT INTO pibNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Komyekanshinikanutkana yine ga wa tsrune koxa, ga wa yonchikgapine. Rapyegitluna. Rakapgogomtluna. Jemanshinikankakjetikowaka ranikluna. ");
INSERT INTO pibNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Tunwakaakana gipgujtalewashatachine kayroklewaklerune. Wane chinna, “Tye jeji gi wa kaspuka gapatletlu tye kpashiwaka ga wa Tokanchi Yokanatkaluru. ");
INSERT INTO pibNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Gi rixanu wyijnako wane chinretlu, ‘Wa tye Geso Nasare gajeru nikatanru tyepji. Kashrijetgimatanru wa Moysisi genekyawu wixjetyawaka.’ ” ");
INSERT INTO pibNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Giyagni pejnuruneko jemanshinikankakjetikowaka tuplatachine yopukgapotutlu. Retgojitluna. Wa Goyakalutowreru pixka rixgojita. ");
INSERT INTO pibNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Sasertotene Gitsrukate potu wane chinru Gishtuwa, “¿Wane gixachrirge?” ");
INSERT INTO pibNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Wale wane china, “Jejine, nomolene, ga wa tsrune, Gyijnakotanu. Goyakalu gimalwutkaluru gipgujewnayegitlu wutsrukatni Gawrani. Mesopotami rawanatini. Chara mawakanniwa. ");
INSERT INTO pibNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Goyakalu wane chinru Gawra, ‘Puchijne pushpakinitka, ga wa pumolenyegiya. Nekakgichijnetyawakapyi pyanutka.’ ");
INSERT INTO pibNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","“Giyagni Kalteyonchijne rushpakamtyatka. Chara rawanatatka. Rupnanatka rurni. Wane Goyakalu ganikyatnaklu Gawra. Tyechijne rapoka wa gixa gwiyawaka wa xani. ");
INSERT INTO pibNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Waneya gi renekchijnetlu, gi psojiswajinako rutakjixityawakapmaka. Seyni rupiratyalu renekchijnetyaplu walenu chininripa, ga wa giklopishanenupa wanepnute. Gi wa kwugenewalu. ");
INSERT INTO pibNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Wane chinru Goyakalu wa waleklopishanepni pnu gajenenapni payinchijneya. Wayegrechine rutaakonna. Gepkoxamkoje pacha walapupa gi yigleko retkona. ");
INSERT INTO pibNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","“Wane china Goyakalu, ‘Gita giklukanuwnayegjixanna wa payine wanna wayegretlewanatachine. Wanepnute rushpakanna waleklopishane. Gewiya yonogyegitinnona.’ ");
INSERT INTO pibNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","“Tokanchi gipiratkaluru reneklu, sajruka gistaklewlupirana. Gawra wugenetlu Gisaaka. Yokgipgogne chininri sajruka gistakletlu. Gisaaka wugenetlu Gakowo. Ga wa Gakowo wugenetna pamole gepi tsrupotunni gitsrukaachinni. ");
INSERT INTO pibNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Ga wa tsrupotunni gitsrukaachinni kanxalerune rushankanruna Gosni Gigipto yinripa. ");
INSERT INTO pibNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Seyni Goyakalu waleyma. Koshpaklu pejnuruko salewninriya. Goyakalu gipxaklu rumutyaplu Gwarawo, Gigipsyone pogire. Kgimatkaleru rixkaklu Gwarawo getanu. Wale gitaklu girukotlewatinripa Gigiptoya ga wa pejnuruko gipji gajeruya. ");
INSERT INTO pibNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“Runa tsru nachi psolchijnepotunanuko Gigiptoya, ga wa Kana koxa. Tsru salewakchi. Wutsrukatenni gi rukshikluna nikanruna. ");
INSERT INTO pibNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Giyagni Gakowo jempiranyegitinri wa Gigipto rawinri triko, yokanatna wutsrukatenni muchinanu kata. ");
INSERT INTO pibNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Gepi kata rapkapinitkana yegwakane. Gosi ginkakatkana wa repurna rixinrina. Gwarawo gimatanerutatkalu Gosi. ");
INSERT INTO pibNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Gosi gepuklu ruru Gakowo ga wa pejnuruneko gimolene, payokgipremole pamyo yineru. ");
INSERT INTO pibNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","“Yopikatka Gakowo. Gigipto rapoka. Wane rupniyanatka waleni ga wa wutsrukatenni. ");
INSERT INTO pibNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Wannani Suche ganiikana. Kapna rutaakanatkana wa Gawrani gagjityawakapna sroschi wenruya. Wa Gemoro wgenene, Suche gajene ragjityalu. ");
INSERT INTO pibNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Konapu chininitka wa gogi wa Wale kawchinanu Goyakalu gipiratyalu Gawra Gigipto ruxolewnananumtna yine. ");
INSERT INTO pibNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Gigipto jiglokinpotunanuko satu pogirchi Gosi mumatkatu. ");
INSERT INTO pibNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Wale yokwitna wumolenni. Gi yigleko retanna wutsrukatenni. Maleka rutakjixinpotukna gegishpaklunniwa ma muweekananumtinitipna. ");
INSERT INTO pibNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","“Walegognekaka rushpaka Moysisi. Goyakalu gigleretanru. Mapa ksuru rurupji tseruwakika. ");
INSERT INTO pibNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Wa maleka rutaakoklunutka, Gwarawonshicho gwapatkalu. Tseruwakatkalu. Toturu pixka tixlu. ");
INSERT INTO pibNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Psolpotuyako Gigipto gajene gimatkale yimaaka Moysisi. Tokanchi ga wa kamrurchi gixo gimkatachrini. ");
INSERT INTO pibNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Gepkoxamkojemole walapu poyagkakinitka rushinika salwayegletna gimolene, Gisrayiliklopishane. ");
INSERT INTO pibNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Wa retinitkalu wa satu yenetkaluru, yoptoyegitlu. Ruylatanru Gigipto gajerni. Rapnuyegitlu yenetkaluru. ");
INSERT INTO pibNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Wale kagwaklu gimolene gimata jemyaplu wa Goyakalu gognetkakanna waleya. Seyni wanna gi gimata jemlu. ");
INSERT INTO pibNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Waleprika yagotkakna. Wale gapyegitna. Ruykotmakna kigle gimwakakle rixinripna. Wane china, ‘Jejine, moletkakachingi. ¿Klu chinanu gyenetkaka?’ ");
INSERT INTO pibNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","“Giyagni rumwastsitanru yenetachri satkaklu. Wane china, ‘¿Katu gitakyi wutsrukate ga wa wuklukanuwnayegjixjeru pixinripa? ");
INSERT INTO pibNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","¿Paluka giylaletno kapetgogne puylatanruna pixka Gigipto gajerni pixka?’ ");
INSERT INTO pibNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","“Tye tokanchi chinanu rasukatka Moysisi. Pnu gajeru rixnatkawa Matiychijne ya. Wane gepi wugenetya. ");
INSERT INTO pibNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Gepkoxamkojmole walapu poyagkakatnaka. Goyakalutowreru gipgujewnayegitlu xirnalmero kawshipiriya, yineru mwiyawakanuya Sina Magkatestsiya. ");
INSERT INTO pibNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Giyagni Moysisi giglajita retyawaklu wa xirnachri. Kayegiklu rumata getyaplu. Gitsrukaachi tokanu jema, ");
INSERT INTO pibNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Gitni putsrukatenni Goyakalutno, Gawra Goyakalute, ga wa Gisaaka Goyakalute, ga wa Gakowo Goyakalute.’ “Rutatatana pikle Moysisi. Gi rumkata getleta. ");
INSERT INTO pibNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Wane chinru Gitsrukaachi, ‘Pkoshpakanro pyoshmaklejixi. Gi rixanu kpashiwakchijne ptunwatyawaka. ");
INSERT INTO pibNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Netpotutlu nayinerutene Gigipto gwachine ma yigleko ma metikolna. Nyijnakotlu wanna gochgire. Nujruka nkoshpakyapna. Punanu wa xani. Gigipto nyokanatanyi.’ ");
INSERT INTO pibNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Waleko Moysisi wanna ma yoptotanutu—wane chinanruna, ‘¿Katu gitakyi gitsrukaachi ga wa giklukanuwnayegjixlewatachri pixinripa?’ chinanruna. Waleko yokanata Goyakalu, wanna Gisrayilini gitsrukate rixinripa, ga wa koshpakjerepni Goyakalutowreru chinanu. Walenwa gitowreru, kawshipiri gipgujewniyachri. ");
INSERT INTO pibNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Wale koshpakna, koglajrukaka getkalurkaka kamrutinri Gigiptochijneya, ga wa Tsru Wenuya Sergalu, ga wa yineru mwiyawakanuya gepkoxamkojmole walapu. ");
INSERT INTO pibNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Tyenwa Moysisi wa Gisrayiliklopishane wane chinachri, ‘Gitsrukaachi Goyakalute gipgujewnakakyegitangi Tokanchi Geneklewatachri satu gimolepa gita pixka.’ ");
INSERT INTO pibNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Walekni wa gapatikowaka gwachri yineru mwiyawakanuya, wa Goyakalu towreruyma, wa Sina Magkate ruynumsatjeru, ga wa wutsrukatenni giynumsatachri. Wale yoptotokanuta tokanchi giwekachri renekyapwu. ");
INSERT INTO pibNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Walekni wutsrukatenni ma maluka yijnakletanutu, seyni satkakmakluna. Rajiyna raluka satokletyatnakna, Gigipto yinripatnakna. ");
INSERT INTO pibNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","“Wane chinruna Gaaro, ‘Pkamrutinwu goyakalune wkosekjenepa. Gi rixanu tye Moysisi wa Gigiptochijne wkoshpakapjeru, gi wumata gikta rixanatka.’ ");
INSERT INTO pibNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Walegognekaka kamrutlona waka wgene. Ranikyegitlona yaglusha genekashlukaka giylatkalurupa. Rumeyiwakatluna gimyona kamrutinrina. ");
INSERT INTO pibNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","“Giyagni Goyakalu katjitna. Samyokna gixolurkaka tengogne gajerkaka yonogyegityapna. Wa tokanchi geneklewatachine kirukate chinyongatyawaka: Gisrayiliklopishangi, ¿Ganikyegitnoge Gita giylatkalunepa ga wa genekashlukaka giylatkalurupa wa gepkoxamkojmole walapu wa yineru mwiyawakanuya? ");
INSERT INTO pibNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Gkoscheklu mkachripji Molochopji. Wane gixno, ga wa gkoscheklo katagiri koxa, Rempanni goyakalute. yagluchkaka wa gkamrutanru gyoptsojityegitanrupa. Giyagni najriikanungi Wawilonya tukasretate. ");
INSERT INTO pibNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Wutsrukatenni waneya mkachripji Goyakalu gipgujewnajetyawakapji pochkewakaya. Goyakalu towutyawakpotuko. Wa Moysisi chinyawaka wa retyawakpotuko, wane rixa kamruretanruna. ");
INSERT INTO pibNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Wutsrukatenni yoptopjitatkalu. Goswuyma rutakluna payine gwanatyawakaya. Wannani panenni ruknoka Goyakalu wutsrukatenniyegiya, Tawigognepotunanuko. ");
INSERT INTO pibNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Goyakalu gimutlu. Tawi gagjitlu retyaplu, kamrujixyaplu wa Gakowo Goyakalute gwapjityawaka. ");
INSERT INTO pibNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Seyni Salomo kamrutlu panchi Walenupa. ");
INSERT INTO pibNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Seyni wa tengajeru potu gi wa myochi kamrupjitikaluru rawa. Tokanchi geneklewatachri chinyawaka: ");
INSERT INTO pibNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Tengognenwa ntuplapijere. Chijni wa nutspanjixgapre. ¿Gi pixkapjirutu gkamrutinno?’ china Gitsrukaachi. ‘¿Ga wa ginakapni wa napnanutyawakapa? ");
INSERT INTO pibNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","¿Gi ge nomyo nkamrutyalu pejnurkakako tyekaka?’ ");
INSERT INTO pibNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","“Shikonshinikanurungi. Gixni msajruka gistaakongajgi ga wa gijnakopnaya koxa. Giwekikaluru Kpashiri gyagotgognenata, gitsrukatenniko pixka. Waneko pixka gixa gixa. ");
INSERT INTO pibNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Pejnurunniko tokanchi geneklewatachinni kojwaknina gitsrukatenni. Ga wa wanna giylatanna Poyagkakachri gininripapirana ginkakletachinni. Wale Poyagkakachri samyokachingi gixa xani. Wale giylatachingi. ");
INSERT INTO pibNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Gixni wa gyoptotlu Tokanchi Yokanatkaluru Goyakalutowrerune gitakyawaka. Gi wa gkamrutlu.” ");
INSERT INTO pibNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Yijnakotinitkaluna kegeknanuwatna. Rashkaygityegitluna. ");
INSERT INTO pibNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Seyni wa wale, Giwekikaluru Kpashiri gwagajitanru potu, teno yigata. Retpotuta. Retlu Goyakalu goyaknu, ga wa Geso Goyakalu potuklesretate gwachri. ");
INSERT INTO pibNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Wane china, “Netlu tengogne gitpukachri, ga wa Yineru Wgene Goyakalu potuklesretate tunwatachri.” ");
INSERT INTO pibNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Giyagni saplewpotumtna. Kachpokajnakopnamtna. Pagakapgogomtkalune rixanruna. ");
INSERT INTO pibNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Koshpakluna pokchiya. Sotlujetanatkaluna. Getashanatachine satu maklujijixistsi rutakamkatluna. Sawolo giwakatletachrini wale. ");
INSERT INTO pibNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Gishtuwni sotlujetanruna. Ragjigogneta. Wane china, “Nutsrukate Geso, pyoptotanno.” ");
INSERT INTO pibNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Yoptsojitamta. Tsru saple rixa. Wane china sapleta, “Nutsrukate, gi puklukjixanna tye mukochriya.” Wane chintokanutinitka rapnanutatka. Sawolo gigleretlu ruylatikolu. ");
INSERT INTO pibNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Walgogne tsru kojwawakchi rixkana gapatjetachine, Gerosale gwanatachine. Pejnuruneko gipalata Gotechijneya, ga wa Samarchijneya. Yokanatkalunepje gixeta. ");
INSERT INTO pibNT_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Ranikanatkaluna Gishtuwni jejine kgipashiregolune. Tsru chiyaglu rixna wale chinanni. ");
INSERT INTO pibNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Giyagni Sawolo yenetpotutna gapatjetachine. Papjimnu jigloka. Kosepowjixna jejine, suxone. Samyokjixna yoshmakikolupna. ");
INSERT INTO pibNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Giyagni gipalatachine pasretamnunanuka yana. Runkakletananumtluna tokanchi. ");
INSERT INTO pibNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Giyagni Wilipi yopika. Samari Pokchi rapoka. Runkaklewyegitna Kristopirana. ");
INSERT INTO pibNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Panshinikanurune yine yijnakpotutlu Wilipi chinyawaka. Yijnakonatna, ga wa retanatluna wa getkalurkaka kamrutanru. ");
INSERT INTO pibNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Gi rixanu kamchine puchotlewatachine gishpakyana gixo kamchichachine. Tsru saple rixna kamchine. Gixo giktegachine, ga wa myankane gituukaakalunetka. ");
INSERT INTO pibNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Giyagni waneru tsru gimuwlu wale pokchi. ");
INSERT INTO pibNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Wanenanru satu jeji Simo giwakatletachri. Muchikawa kagonchinanni wale pokchiya. Rumyekna Samari gajene. Satu tsru chinnachriwa. ");
INSERT INTO pibNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Pejnuruneko yijnakpotutlu, mturune ga wa tsruneymananuko. Wane chinna, “Tyenwa tsru ruyakle Goyakalu chinkaluru.” ");
INSERT INTO pibNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Yijnakpotutluna gi rixanu wa kagonchitinri rumyekyana muchikawgognenanuyakawa. ");
INSERT INTO pibNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Seyni wa ralixinitkaluna Wilipi Kiglerpotunanu Tokanchi runkakletini Goyakalu pogirewatyawakapirana, Geso Kristo giwakapirana, katkana jejine ga wa suxone. ");
INSERT INTO pibNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Wale koxa Simo galixa. Katka. Wilipiyma rawa. Tsru getkalurkaka, ruyaklekaka wane gixkaluru reta. Rumyeka. ");
INSERT INTO pibNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Wa yokanatkalune Gerosale gwanatachine yijnakyegitluna Samari gajene yoptotyawakatkalu Goyakalu tokanu. Giyagni wanna yegi yokanatkana Petro ga wa Gwa. ");
INSERT INTO pibNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Wanna yopika. Rapokinitkana ragjigognetna Samari gajene chinanu wa yoptotyapluna Giwekikaluru Kpashiri. ");
INSERT INTO pibNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Gi rixanu gi satuna rapokawa. Katashatkana Geso giwakaya. ");
INSERT INTO pibNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Giyagni rutakamyotseptagitkana. Yoptotatkaluna Giwekikaluru Kpashiri. ");
INSERT INTO pibNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Wa retinitka Simo wa rutakamyotseptaglewatinrina yokanatkalune, Giwekikaluru Kpashiri geneekatka, sroschi ranikyegitmakna. ");
INSERT INTO pibNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Wane china, “Gitakankoxno gita tye chinanu, wa gi gixachrikokta nutakamyotseptagitanu, yoptotanru Giwekikaluru Kpashiri.” ");
INSERT INTO pibNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Giyagni Petro wane chinru, “Pixaymaplo pserojiprojite gamgikowaka, gi rixanu pkagwaklu Goyakalu genekashle sroschi yoptotikalurni. ");
INSERT INTO pibNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Maleshayyi pixa tyepirana. Gi putaaka. Gi rixanu gi potukgajyi Goyakalu getanu. ");
INSERT INTO pibNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Giyagni penshinikanutanu tye gektutuya. Gitsrukaachi pagjitanu gikta pkaspukmukochirgajitko pyanshinikanutanru. ");
INSERT INTO pibNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Gi rixanu pachikgajitachriyi, gektutu gostutanruyi wane nixa getletyi.” ");
INSERT INTO pibNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Giyagni rugita Simo. Wane china, “Gitsrukaachi gagjiyegitanunno gixa, gi satuna wa gixa wane chinyawaka ma munyegitkanupno.” ");
INSERT INTO pibNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Giyagni wanna gipgujtatinri. Goyakalu tokanu rali ginkakletinrina, satokna. Gerosale yana. Papokchimnunanuka Samaritane pokchi wane runkakletyaluna Kiglerpotunanu Tokanchi. ");
INSERT INTO pibNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Gitsrukaachitowreru giynumatlu Wilipi. Wane chinru, “Palnanu. Tkachi kegnetesretate pyanu, Gerosale yopikgapotyachri. Kasa gapokgapotachri. Wanenwa yineru mwiyawakanu.” ");
INSERT INTO pibNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Palnatka. Wane yatka. Wanenanru satu Getyope gajeru, suxone girukotachri, tsru jiglokachri Kanrasa yegi Getyope gajene pogirewatyachro. Wale gitaaka pejnuruko tponikole chinanu. Wane ya, Gerosale yoptsojtapinripa. ");
INSERT INTO pibNT_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Rali yoptsojityentapinitkalu, satoka. Chijiyapachrote tuplananumta. Retyongananumtlo Gisayiya tokanchi geneklewatachri kirukate. ");
INSERT INTO pibNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Giwekikaluru wane chinru Wilipi, “Pyayegitanro. Twu chijiyapachrostsi pyanu.” ");
INSERT INTO pibNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Wilipi gasukyegitlo. Yijnako getyongaletlo tokanchi geneklewatachri Gisayiya kirukate. Wane china, “Giyagni ¿pumata jemluge wa peta yongatanru?” ");
INSERT INTO pibNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Wale wane china, “¿Gi rixyawaka numata jeminri gi satuna ginkakpokowakatanno?” Ragjitlu Wilipi ratskotinripa, waleyma tuplamta. ");
INSERT INTO pibNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Tyepiranyegiktani retyongananumta: Gowega pixka giylajetikowaka raniika. Gowega wgene myanumatkato tjiwjitjeru yegi, waneko pixka rixa Wale. Gi yanumata. ");
INSERT INTO pibNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Kamturetkoklunu gi wanepotuko rixluna girukotlewatachine. ¿Katu ginkakletanna walegogne gajene? Gi rixanu chiji konikaluru ruwekinri. ");
INSERT INTO pibNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Suxone girukotachri gepomgalu Wilipi. Wane chinru, “Nepomganyi. ¿Katupiranni wane china tokanchi geneklewatachri? ¿Walenanuklege waka satupiranra?” ");
INSERT INTO pibNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Giyagni Wilipi tyepiranako yonatkaluru yinuwaka ginkakpokowakletyaplu. Runkaklu Kiglerpotunanu Tokanchi Gesopirana. ");
INSERT INTO pibNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Gatnugapo yapananumtna. Gongastsi rapokna. Wane china suxone girukotachri, “Petanru gonu. ¿Klu gimaletlu nkatikolupa?” ");
INSERT INTO pibNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Wilipi wane chinru, “Psolpotuyako pajiya palixini, pumkatlu.” Giyagni rugita. Wane china, “Nalixlu wa Geso Kristo Goyakalu Wgene rixinri.” ");
INSERT INTO pibNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Tunwajixlo chijiyapachro. Ruptekgamtna Wilipi ga wa suxone girukotachri. Wilipi katlu. ");
INSERT INTO pibNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Kanikatkana. Giwekikaluru Gitsrukaachinu koschekamtatkalu Wilipi. Gi wanepnuteko suxone girukotachri getatkalu. Yatka gatnugapo gimuwamtachri. ");
INSERT INTO pibNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Gasoto retikatka Wilipi. Pnumnu ya. Pejnuru pokchiko runkakletyalu Kiglerpotunanu Tokanchi, Susari rapokinpotunanuko. ");
INSERT INTO pibNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","¡Gi pakawgurenanuktalu rixna Sawolo Gitsrukaachi yimaklene! Ruylalewlennaspuu rixa. Sasertotene gitsrukatpotyegi ya. ");
INSERT INTO pibNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Ragjitlu kiruka Tamasko gajene chinanu, wa ginkaklewawakapji gajene, wa rukshikinipna jejineko ga wa suxoneko tyepirana gomkagitachine Gerosale ranikyapna gostutkalune. ");
INSERT INTO pibNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Gatnugapo yapamta. Tamaskostsi rapokatka. Walegnapunanu yochigyegitanru tengogne gajeru yochigatachri. ");
INSERT INTO pibNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Chiji rapokamtana. Yijnakotlu satu tokanchi wane chinjeru, “Sawolo, Sawolo, ¿klu chinanu pkojwakno?” ");
INSERT INTO pibNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Wane china, “¿Katyi Pixa, Gitsrukaachi?” Wane chinru, “Gitni Geso, wa pixa kojwakanruno. ");
INSERT INTO pibNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Seyni palnanutka. Pokchi pyanu. Wane punkakiko pumkata kamruretanrupa.” ");
INSERT INTO pibNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Sawoloymalune jejine menuwatachine. Plaschi galikakni yijnakotna, seyni gikena retna. ");
INSERT INTO pibNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Giyagni Sawolo chiji palniyatka. Rumrekgatnimkatka. Gikena retanatka. Giyagni kanjimtanatkaluna. Tamasko Pokchi rutakatkaluna. ");
INSERT INTO pibNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Mapgogne wane rawa. Metkatuna. Mniikatuna. Murkatuna. ");
INSERT INTO pibNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Tamasko rawanata satu Gitsrukaachi yimakleru Ganani giwakatletachri. Kaygawleya wane chinru Gitsrukaachi, “Ganani.” Wale gigita, “Gewno, Gitsrukaachi.” ");
INSERT INTO pibNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Gitsrukaachi wane chinru, “Palnanu. Gatnugapo pyanu, Potukgapolu chinkaluru. Gotapji pujginri satu Sawolo giwakatletachri, Tarso gajeru. Gi rixanu wale gagjigogneta. ");
INSERT INTO pibNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Satu jeji reta kaygawleya, Ganani giwakatletachri, wa pixa. Reta jiglokletyi. Pixa gitaktseptagimyogogotanru retinripatka.” ");
INSERT INTO pibNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Giyagni Ganani gigitlu Gitsrukaachi, “Nutsrukate, gi gepika yine njempiranyegityalu tye jeji, gi pejnunanukta gektutu kamrutyana Pixanune kpashirine Gerosale gajene. ");
INSERT INTO pibNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Gewi koxa rutakika tsrukakalune sasertoteneya rostutyapna pejnuruneko Pixa giwaka koschekachine.” ");
INSERT INTO pibNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Gitsrukaachi wane chinru, “Wane pyanu. Gi rixanu walenwa nkamrurewapre ntsomitinri, ngiwaka ranikinripa payinyegiya, ga wa pogirchinyegiya, ga wa Gisrayiliklopishanyegiya. ");
INSERT INTO pibNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Gi rixanu Gita gekakgitanru gi pejnunanpaktalu rumkata salewnaletinripa ngiwakaya.” ");
INSERT INTO pibNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Giyagni Ganani wane ya. Panchi jigloka. Rutaktseptagimyogogotlu. Wane china, “Nepuru Sawolo, Gitsrukaachi Geso, wa gatnugapoya petinri wa puninitka, Wale yokanatno petinripa, wa Giwekikaluru Kpashiri gwagajpotutyapyi.” ");
INSERT INTO pibNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Waneklu rujruktataygalemtatka gitataji pixkalutu. Retatka. Palnatka. Katkatka. ");
INSERT INTO pibNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Wa nikinitka gichkonshinikanutkalu. Gi pejnugognekta Sawolo gimwana Gitsrukaachi yimaklene Tamasko gwachine. ");
INSERT INTO pibNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Waneklu ginkaklewawakapjikaka Kristopirana runkakleta. Wane chinjeta wa Gesonwa Goyakalu Wgene. ");
INSERT INTO pibNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Wa pejnuruneko yijnakonatachine gimyeka. Wane chinna, “¿Gi ge tyenwa Gerosale saletlewatyachri wa tye giwaka koschekachinni? Wale chinanu runa gewi, gostutkalune ranikyapna wa tsrukakalune sasertotene yegi.” ");
INSERT INTO pibNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Giyagni Sawolo wanepnute muchkotanshinikanutka. Gi rumatanshinikankakna Goteyone Tamasko gajene. Runkakpokowakatna Kristokni wa Geso. ");
INSERT INTO pibNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Gixgogne giknoginitka Goteyone jemanshinikankaka ruylatyapluna Sawolo. ");
INSERT INTO pibNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Wale gimata jemanshinikankakpiranyegitluna. Wanna girukotpotutlu gipgyaptokaka gogi ga wa goyechno ruylatyapluna. ");
INSERT INTO pibNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Giyagni wa Gitsrukaachi yimaklene pokchi prijere gogote rutakluna goyechno. Wane rujruukakyaluna. Wane kojita jijrukyaluna. ");
INSERT INTO pibNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Wa Gerosale rapokinitka raluka Gitsrukaachi yimaklene gipxaletleta. Seyni pejnuruneko pikanru. Gi ralixluna wa Gitsrukaachi yimakleru rixinri. ");
INSERT INTO pibNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Giyagni Wirnawisi gwaplu. Raniklu yokanatkalune yegi. Runkakna gi rixpoko Sawolo getletlu Gitsrukaachi gatnugapoya, ga wa Gitsrukaachi giynumatyawaklu. Runkaakoxna wa Tamasko Sawolo ginkaklewatya pgujetanuwaka Geso giwakaya. ");
INSERT INTO pibNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Rupxaletjetna. Wannayma yotaljeta Gerosaleya. Pgujetanuwaka china yanumsaleta Gitsrukaachi giwakaya. ");
INSERT INTO pibNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Wale gigjetna Kriykone tokanu yanumatyachine. Ruylatmakluna. ");
INSERT INTO pibNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Wa rumatinitkana moletkakachine ranikluna Susarpotuko. Wane Tarso yokanatyatkaluna. ");
INSERT INTO pibNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Giyagni gapatjetachine ruglewanshinikanutna psoluyako Gote, ga wa psoluyako Kalile, ga wa psoluyako Samari. Tseruwakanshinikanutkana. Kosekna Gitsrukaachi pikachine. Giwekikaluru Kpashiri gimnanukanune ruxolewnana. ");
INSERT INTO pibNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Wane rixa Petro. Pnumnu yapamta. Yopika koxa kpashirine Lita gwachinyegiya. ");
INSERT INTO pibNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Wane retyalu satu jeji Geneyasa giwakatletachri. Yokgipi walapu gijeko rukluganatka. Giktegachrinni. ");
INSERT INTO pibNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Wane chinru Petro, “Geneyasa, Geso Kristo gituukakyi. Pyotunotanutka. Puglepokjejekotanutka.” Waneklu yotunotatka. ");
INSERT INTO pibNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Retluna pejnuruneko Lita gwachine, ga wa Sarona gwachine. Wanna kashrijetka. Gitsrukaachinunepa. ");
INSERT INTO pibNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Gope twa sato Gitsrukaachi yimaklero, Tawita giwakatletachro. Walenwa yokaakaluru Kshotero. Kigleru kamrujetachro. Kwamonurune genekjetachro. ");
INSERT INTO pibNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Wane rixatka walegognekaka. Tyayixana. Tupnanatka. Rerkatkalona. Tenogruko rutakanrona. ");
INSERT INTO pibNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Litaya gi gowuklu Gope. Giyagni wa Gitsrukaachi yimaklene yijnakotlu wa Petro wane gwanata. Gepi jejine yokanyegitluna. Ragjityapluna, “Gi pyoxigikamtanu. Punyegitanwu.” ");
INSERT INTO pibNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Giyagni Petro palnamta. Wannayma wane ya. Rapokatka. Tenogruko ranikatkaluna. Walestsi tunwatna pejnuroneko gipnagnurutachrone. Chiyagatna. Rekakgitluna gitokoochi ga wa mkachri wa Kshoterni kamrurni wanna yegi twanatini. ");
INSERT INTO pibNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Giyagni pejnuruneko maleka yokanata Petro. Yoptsojita. Ragjigogneta. Ruprotakyegitlo tomane. Wane china, “Tawita, pyotunotanutka.” Tumrekgata. Tetlu Petro. Tuplata. ");
INSERT INTO pibNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Romyokyegitlo. Tunwakaklo. Giyagni tomgana kpashirine ga wa gipnagnurutachrone. Giwekachro rekakgitatka. ");
INSERT INTO pibNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Wale gimatka psoluyako Gopeya, ga wa gixo galixlu Gitsrukaachi. ");
INSERT INTO pibNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Wane rixa Petro. Gi gepikgogne Gope rawa Simopji, nikchimta yoshmojetachri. ");
INSERT INTO pibNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Susari rawanata satu jeji Kornelyo giwakatletachri, ksolaloteru gixolune solalone Gitalyanone chinkalune. ");
INSERT INTO pibNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Kgipashiregolu. Goyakalu pikachri pejnuruneko gipji gajeneymananuko. Kgetwamonreru. Renekashjetna yine. Goyakalu ragjigognejeta. ");
INSERT INTO pibNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Kayinwaka retpotutlu kaygawleya satu Goyakalu towreru. Reta jiglokleyegitlu. Wane chinru, “Kornelyo.” ");
INSERT INTO pibNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Retpotutlu. Pikanatka. Wane china, “¿Klunerni, Gitsrukaachi?” Wane chinru, “Pagjigognere ga wa petwamonrekaka Goyakalu getanu rushinikikolpatka. ");
INSERT INTO pibNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Ga wa xani pyokanatanna jejine Gope yinripna. Pepukanru satu Simo. Yoklegiwaka Petro. ");
INSERT INTO pibNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Wa Simopji rawanata, kyoshmomtakleru. Tsru wenustsi gwapjitachri,” china. ");
INSERT INTO pibNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Wa yinitka Goyakalutowreru Kornelyo giynumsatachri. Tomgana gepi kamrurewyegitjene, ga wa satu solalo kgipashiregolu, satu rupxaletjetanruymalutu. ");
INSERT INTO pibNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Runkakna pejnurukopirana. Yokanatatkana Gope. ");
INSERT INTO pibNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Waleprika yagaponatatkana wanna. Tsru pokchistsi rapokinitkana, Petro tenogruko ratskota, ragjigognetinripa. Tumananustsitkani. ");
INSERT INTO pibNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Wane rixa. Nachpotunru. Raluka nikletana. Ralpokokopshinna, rushpakanshinikanuta. ");
INSERT INTO pibNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Retlu tengogne gitpukachri. Reta gijrukletlu katlogamnuru. Tsru mkachrichrata pixka rixa. Gepkoxamkojetsojri gishrikikaluru. Jijruukaluru. ");
INSERT INTO pibNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Wane rawamtna ptowrunanuka nikchine gepkoxamkojejixirune, ga wa yosrolotachine chiji gajene, ga wa tengogne yapachine kamejirune. ");
INSERT INTO pibNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Satu tokanchi jema, “Palnanu, Petro. Puylatanru. Pnikanru.” ");
INSERT INTO pibNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Giyagni Petro wane china, “Gitsrukaachi, gike nixiniko. Gi rixanu gi pagogneko gimuteru, kapcholu nnikjejeta.” ");
INSERT INTO pibNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Gepi kata chininri jematnaklu tokanchi wale yegi: “Wa Goyakalu powratanru gi wa gimuteru pchinanutkalu.” ");
INSERT INTO pibNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Mapkata wane rixatka. Waneklu gitloga tengogne rawikatka. ");
INSERT INTO pibNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Petro gi rumatanshinikanunata walenanuko klunerni wa kaygawlu retyawaka. Waneklu wa Kornelyo yokanatanune jejine gipgyapto gapokatka. Repomsayeginanumtluna Simopji. ");
INSERT INTO pibNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Tomgana. Repomgana gikta xani wane rawanata Simo wa Petro yokletgiwakatletachri. ");
INSERT INTO pibNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Yanshinikanunatiniwa Petro wa kaygawleya, wane chinru Giwekikaluru, ");
INSERT INTO pibNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","“Pete. Mapa jejine gijgayi. Ga wa xani palnanutka. Pujrukanutka. Gi putakyagoka yaletanu. Wannayma pyanu. Gi rixanu Gita yokanatna.” ");
INSERT INTO pibNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Giyagni Petro gijrukyegitna jejine Kornelyo yokanatanune. Wane china, “Getanno. Gitni wa gijganruno. ¿Klu chinanu gina?” ");
INSERT INTO pibNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Wa wanna wane china, “Kornelyo wa ksolaloteru, jeji poyagkakachri, Goyakalu pikachri, kiglepiranyegirni pejnuruneko Goteyoneyegiya. Satu Goyakalutowreru kpashiri yokanatlu wale gwapjixapyapyi, gipji pyinripa. Yijnakotokanutanyi.” ");
INSERT INTO pibNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Giyagni chanixna jiglokinripna. Renekna rumkiyawakapna. Waleprikgogne yotunota. Wannayma wane yatka. Waleymamnuna pimrine Gope gajene moletkakachine. ");
INSERT INTO pibNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Pagognetnakni Susari rapokna. Kornelyo kagwakanatna. Rapatanunetka gimolene ga wa rumatletanune potu. ");
INSERT INTO pibNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Wane rixa. Petro jiglokamtinitka, Kornelyo yoptotaplu. Chiji rapokamta gijixistsi. Yoptsojityegitlu. ");
INSERT INTO pibNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Giyagni Petro palnakaklu. Wane china, “Palnanu. Yinerkoxno gita.” ");
INSERT INTO pibNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Ruynumsakakamtatkana waleyma. Jiglokamta. Retna gixo gapatanatachine. ");
INSERT INTO pibNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Wane chinna wale, “Gixa gimatlu ginanshichkaluru satu jeji Goteyo gipxaletyaplu payineru, yayegityaplu. Ga wa Goyakalu gekakgitno gi satuna yineru gimuteru, kapcholu chinkalurupa. ");
INSERT INTO pibNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Giyagni nepuuka pnumnu mchinkatno nuna. Giyagni nepomgayi, ¿klu chinanu pepukno?” ");
INSERT INTO pibNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Kornelyo wane china, “Gepkoxamkojegognetkani xanipapko nogajirewanata. Kayinwakpapko nagjigognenata nopjiya. Netlu satu jeji. Tunwaginapletno. Katajimkalu. ");
INSERT INTO pibNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Wane china, ‘Kornelyo, pagjigognere jemkalurni, ga wa petwamonre gishiniikalurni Goyakalu getanu. ");
INSERT INTO pibNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Giyagni Gope pyokanrewatanu,’ chinno. ‘Pepukanru satu Simo, Petro yokletgiwakatletachri. Simopji rawanata, kyoshmomtaklerupji, tsru wenustsi gwapjitachri.’ ");
INSERT INTO pibNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Giyagni waneklu nyokanrewata pixa yegi. Kigleru pkamruta punyawaka. Ga wa xani geewu pejnurunekwu wixa Goyakalu getanu, wyijnakotyapyi pejnuruko Gitsrukaachi yokanatyayi.” ");
INSERT INTO pibNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Giyagni Petro yanumata. Wane china, “Galikakni numatjematkalu gi wa manewle giglenu chinanu yoptotyaplu Goyakalu wa yineru. ");
INSERT INTO pibNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Seyni payinerumnunanuka Wale pikachri, poyagkakachri, walenwa Goyakalu gigleretanru. ");
INSERT INTO pibNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Gisrayilineklopishane yegi yokanatlu tokanchi. Tyenwa Kiglerpotunanu Tokanchi giglewanshinikanrupirana Geso Kristo chinanu. Walenwa pejnuruneko Gitsrukate. ");
INSERT INTO pibNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Gixa gimatlu tokanchi pogitkaluru psoluko Goteya. Kalile yinuwakya. Wane chininitka katlu wa Gwa runkakletanru. ");
INSERT INTO pibNT_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Wa Geso, Nasare gajeru, wa Goyakalu Giwekikaluru Kpashiri gipkakyegitanru, ga wa giyaklu koxa. Wa Wale pnumnu yapananumta. Kigleru kamrunanumta: rutuukakna pejnuruneko tsru kamchi kapsakletanune, gi rixanu Waleymalu Goyakalu. ");
INSERT INTO pibNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","“Wa wixni wa gipgujtatachinwu pejnurupirankakayako wa Gotechijne kamrutinri ga wa Gerosale. Wa Wale ruylatna. Ruxripkakluna gagmunashkitaya. ");
INSERT INTO pibNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Wa Wale Goyakalu yotunkaka mapgogne chininri. Ruchichlu rupgujewninripa. ");
INSERT INTO pibNT_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Gi wa pejnuruneko yine yegi rapoka, seyni gipgujtatachinyegipje, wa Goyakalu muchikawa tsomitanune, wa wixa Waleyma nikachinwu ga wa girachinwu rapyegita, rali yotunremtinitka gipnachinetskalaya. ");
INSERT INTO pibNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Yokanatwu wa yinyegiya wunkaklewatinripa ga wa wupgujtatyaplu; wane wchinanu wa Walenwa Goyakalu gitakanru gitakyagoklewatachripa giwekachineya ga wa gipnachineya. ");
INSERT INTO pibNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Pejnuruneko tokanchi geneklewatachine gipgujtajenatanruni wa Wale. Wane chinna wa pejnuruneko wa Wale galixachinepa kaspukmukochiretkalunepni giwakaya.” ");
INSERT INTO pibNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Wa yanumsatiniwa Petro tyepirana, wa Giwekikaluru Kpashiri gapokyegitna pejnuruneko wanna tokanchi yijnakonatachine. ");
INSERT INTO pibNT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Rumyekna galixachine sajrukgistaakalune Petro gimotsatachine gi rixanu payine koxa yegi rupkaaka genekashlu Giwekikaluru Kpashiri. ");
INSERT INTO pibNT_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Rumyekna gi rixanu yijnako yanumsaletkana payinerunemnuka tokanu ga wa rumalwutluna Goyakalu. Giyagni wane china Petro. ");
INSERT INTO pibNT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“¿Katu gimkata ginanshiretlu gonu wa ma katikotupna wa nyi Giwekikaluru Kpashiri yoptotachine wixako pixka?” ");
INSERT INTO pibNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Katjixatkana Geso Kristo giwakaya. Giyagni ragjitluna pimrigognechi wanna yegi rawinripa. ");
INSERT INTO pibNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Yokanatkalune ga wa moletkakachine Gote gwanatachine yijnakyegitna wa payineko koxa wa Goyakalu tokanu yoptotyawakatkana. ");
INSERT INTO pibNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Wa Gerosale kanikinitka Petro, yoptopiratluna wa sajruka gistaakotachine. ");
INSERT INTO pibNT_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Wane chinna, “Pixni jiglokyegitna jejine msajruka gistaakotkone. Wannayma pnika.” ");
INSERT INTO pibNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Giyagni Petro yinuwaka ginkakpokowaklepotutna. Wane china, ");
INSERT INTO pibNT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Gope Pokchi nwanatini, nagjigognenatini. Nushpakanshinikanuta. Kaygawleya netlu katlogamnuru gijrukachri. Tsru mkachrichrata pixka rixa. Gepkoxamkojetsojri jijrukikaluru tengogneya. Gita yegi rapoka. ");
INSERT INTO pibNT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Nyopukgatlu. Netpotutlu. Nikchine chiji gajene gepkoxamkoojixirune, ga wa kmatsurune, ga wa yosrolotachine, ga wa kamejirune tengogne yapachine neta. ");
INSERT INTO pibNT_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Nyijnakotlu satu tokanchi wane nchinjeru, ‘Palnanu, Petro. Puylatanru. Pnikanru.’ ");
INSERT INTO pibNT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","“Wane nchina, ‘Gitsrukaachi, gike nixiniko. Gi rixanu gi pagogneko gimuteru, kapcholu jigloknamatno.’ ");
INSERT INTO pibNT_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","“Giyagni gepi kata chininri tengogne giyakatyachri tokanchi gigitno, ‘Wa Goyakalu powratanru gi wa gimuteru pchinanutkalu.’ ");
INSERT INTO pibNT_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","“Mapkata wane rixatka, ga wa pejnuruko tengogne rawikatka. ");
INSERT INTO pibNT_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","“Waneklu rapokna mapa jejine wa nwapjitanru. Susari yokanatikna gita yegi. ");
INSERT INTO pibNT_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Giwekikaluru wane chinno nma mutakyagoka yaletinitipa wannayma. Giyagni nyatka. Gitaymalune koxa nyi patsrujire nomolene. Satu jejipji wjigloka. ");
INSERT INTO pibNT_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Wale ginkakwu gikta rixpoko getletlu Goyakalutowreru gipjiya. Wane gima tunwanata. Wane chinru, ‘Gope pyokanrewatanu. Pepukanru satu Simo, Petro yoklegiwakatletachri,’ chingimata. ");
INSERT INTO pibNT_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","‘Wale ginkakanyi tokanchi, wa wale tokanchi chinanu pognetkaako pixa ga wa pejnuruneko pupji gajene.’ ");
INSERT INTO pibNT_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","“Giyagni nyinuwaka ginkaklewyegletinna, rapyegitna Giwekikaluru Kpashiri wixa muchinanu pixka, wa rapyegitinitkawu. ");
INSERT INTO pibNT_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Giyagni nushinkaplu Gitsrukaachi tokanu. Wale chinyawaka, ‘Gwa katlewata galikakni gonuya, ga wa Giwekikaluru Kpashiri gkatikolupa gixa.’ ");
INSERT INTO pibNT_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Giyagni wa Goyakalu renekinna waleko genekashlu koxa wa wixako pixka, wa Gitsrukaachi Geso Kristo galixachinwu, ¿gi gixachripno gita numkata gimaletletyapmaklu Goyakalu?” ");
INSERT INTO pibNT_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Giyagni yijnakpiranatluna tyekaka, ruchkekna. Rumalwutluna Goyakalu. Wane china, “Giyagni Goyakalu geneekoxna payine renshinikanutinripna, ruwekinripna.” ");
INSERT INTO pibNT_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Giyagni wa gipalatachine salewakchiya Gishtuwni chinanu, pnumnu yapananumtna, Winisipotuko ga wa Supro, ga wa Gantiyoki. Gike runkakna wa tokanchi, ga wa Goteyonepje. ");
INSERT INTO pibNT_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Wanena pimrine wa nyi jejine Supriyone ga wa Surenensene, Gantiyoki rapokinitkana. Kriykone runkakna Kiglerpotunanu Tokanchi Gitsrukaachi Gesopirana. ");
INSERT INTO pibNT_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Wannaymalu Gitsrukaachi. Gixolune galixa. Wanna kashrijetka Gitsrukaachinunepa rixinripna. ");
INSERT INTO pibNT_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Gapatjetachine Gerosale gwachine yijnakotlu tyepirankaka. Wirnawisi yokanatna. Gantiyoki yinripa. ");
INSERT INTO pibNT_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Wa wale gapokinitka, retlu Goyakalu gimutyawakna. Rumjika. Ruykotna pejnuruneko psolgalukleya rajiyna Gitsrukaachi yegi rawgognenatinripna. ");
INSERT INTO pibNT_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Gi rixanu jeji kiglerni. Giwekikaluru Kpashiri gwagajitanrupotni ga wa kalixaklerpotni. Gixolune yogniwnananumtna Gitsrukaachi yegi. ");
INSERT INTO pibNT_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Tarso yatka Wirnawisi. Sawolo rujga. Rukshiklu. Gantiyoki raniklu. ");
INSERT INTO pibNT_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Psolwalapuko gapatjetachineymana. Gixolune yine runkakpokowakyegitna. Kristonune chinkana Gitsrukaachi yimaklene muchinanu gapka Gantiyokiya. ");
INSERT INTO pibNT_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Walegognekaka Gerosale yopikyana tokanchi geneklewatachine. Gantiyoki rapokna. ");
INSERT INTO pibNT_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Satu tokanchi geneklewatachri palna. Gakawo giwakatletachri. Runkakna Giwekikaluruya waneplu tsru nachi psolchijne gajenpotunanuko yegi. Klawtyoklunanu wane rixanata. ");
INSERT INTO pibNT_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Giyagni Gitsrukaachi yimaklene wane rixanshinikanutna yokana gipxakletinripna Gote gwachine moletkakachine yegi. ");
INSERT INTO pibNT_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Satkaka poyagotyawaka wane rixle yokanatanu. Wanepotuko rixna. Wirnawisi, Sawolo ganiklu tsrune yokanyegitikolu. ");
INSERT INTO pibNT_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Waneklu koxa pogirchi Girore kashichjixanna pimrine gapatjetachine yenetyapna. ");
INSERT INTO pibNT_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Gwa yegwakluni Santyakni yoglolewapi ruylajixya. ");
INSERT INTO pibNT_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Retlu Girore waleko rugleretkakna Goteyone, pnute rixa. Petro koxa kashicha. ");
INSERT INTO pibNT_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Wa jimapro gisekachri myapjetkotgognekakni. Wa kashichinitkalu Petro, yoshmakikowaka rutakjixlu. Gepkoxamkojeptogi solalone yegi samyoklu, rumretyapluna. Ruknoginitka Tsru Giknoglushgogne raluka koshpakletlu yine chinanu. ");
INSERT INTO pibNT_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Giyagni Petro yoshmakikowaka girukotika. Ga wa gapatjetachine psolmuchkonuko Goyakalu ragjigogneyegitluna. ");
INSERT INTO pibNT_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Wa Girore galuka koshpakletinitkalu, walyechno Petro gimkanata gepi solalone ganikajite. Gostutkaluru gepi yowumatsaya. Wa girukowatachine gipgyapto ginapleya girukotluna yoshmakikowaka. ");
INSERT INTO pibNT_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Gitsrukaachitowreru gapoka. Pokamlalu yoshmakikowaka gatajitya. Petrokwanapa ruylaka. Komyeklu. Wane china, “Giyampotu pyotunotanu.” Rujrukatsamtatka yowumatsa gimyo gajerni. ");
INSERT INTO pibNT_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Goyakalutowreru wane chinru, “Pushrikapchijitanu. Postutanru pyoshmakjixre.” Wane rixa. Wane chinru, “Pyoshmamkatanu. Pomkagitanno.” ");
INSERT INTO pibNT_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Rushpakamta. Romkagimtatkalu. Gi wa rumata wa galikaka rixinri wa Goyakalutowreru wane gixyawaka. Wale kagwaklu kaygawlu reta. ");
INSERT INTO pibNT_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Ruknogamtluna muchinanuptogi girukowatachine, ga wa gepi chininriptogi girukowatachine. Yowuma gipgyapto rapokna, maleka gishpakikowaka, pokchi ganikajite. Wa gipgyapto gitpukamta walenanuko wanna chinanu. Rushpakamtna. Ruknogamtluna pagapo. Waneklu Goyakalu towreru gitspalamtyatkalu. ");
INSERT INTO pibNT_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Rushinikpotutatka Petro. Wane china, “Xawakni numatatkalu galikakni wa Gitsrukaachi yokanatlu gitowreru; koshpakapno Giroremyoya, ga wa pejnurukoya Goteyone kagwakanatyatkano.” ");
INSERT INTO pibNT_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Rumata jematkalu. Mariyapji yatka. Gwa, Marko yokletgiwakatachri ginropji, gixo gapatanatyawaka. Ragjigognenatna. ");
INSERT INTO pibNT_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Maleka gajeru gipgyapto ruylaylata Petro. Tushpakamta sato tserowaklechi, Rote giwakatletachro, tyijnakotinripa. ");
INSERT INTO pibNT_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Tumat yijnakootokanutinitkalu Petro, tumuwlepoga gi tkotpuklu maleka gipgyaptote. Seyni gitokogruko tya gasukleta. Tunkaklewata wa Petro maleka gipgyaptote tunwatinritka. ");
INSERT INTO pibNT_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Wanna wane chinro, “Pseprolokana.” Seyni wala tupnaje ginkakleta wane rixinri. Giyagni wanna wane china, “Goyakalutowreru, Petro girukotachrini xani.” ");
INSERT INTO pibNT_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Seyni Petro gomkagi giylaylagipgyaptotleta. Kotpukyegitinitkaluna. Rumyekna. ");
INSERT INTO pibNT_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Seyni yotukamyoyegitna pochke rixinripna. Runkakna gi rixpoko koshpakletlu Gitsrukaachi yoshmakikowakaya. Wane china, “Ginkakanna Santiyako ga wa moletkakachine tye pirana.” Rushpakamtatka. Pnuko yatka. ");
INSERT INTO pibNT_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Wa gogi chininitka tsru kegeknanuwlu rixna solalone Petro chinanu klukta giknogyawakatkalu. ");
INSERT INTO pibNT_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Girore gijgapotutlu. Gi wa rukshiklu. Repomsapotutna girukowatachine. Rali gepomsaletinna ruylajixanna. Wanepnute Girore Gote yopikya. Susari ya. Wane rawanata. ");
INSERT INTO pibNT_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Ruylakakna Girore wa Tiro gajene ga wa Sito gajeneyma. Seyni panshinikanurunetkani wale yegi yana. Rushinikanutluna Plasto, pogirchi gimkiyawaka girukotachri. Rawashatinripna ragjitna, gi rixanu wa gichijnena gajene waneyna nikanruna pogirchichijneya. ");
INSERT INTO pibNT_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Rutakgognetka pagogne. Girore gitaklu pogirchimkalu. Pogirchi tuplapijere tuplata, ga wa runkaklewyegitna. ");
INSERT INTO pibNT_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Saplewatna yine, “Goyakalu tokanuktani. Gi wa yinerunni.” ");
INSERT INTO pibNT_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Waneklu Gitsrukaachitowreru giylatanru Girorni, gi rixanu gi wa Goyakalu rumalwujixa. Tsomi nikanru. Rupnana. ");
INSERT INTO pibNT_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Ga wa Gitsrukaachi tokanu tseruwna. Ruxolewna. ");
INSERT INTO pibNT_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Poyagkakinitkaluna kamrurna Gerosale satokyatkana Wirnawisi, Sawolo. Raniikoxluna Gwa, Marko yoklegiwakatletachri. ");
INSERT INTO pibNT_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Gantiyoki gajene gapatjetachinetskalaya wanena tokanchi geneklewatachine ga wa yimaklewatachine. Wirnawisi, ga wa Simo, Nigi giwakatletachri, ga wa Losyo, Surene gajeru, ga wa Manaya tseruwaakaluru Giroreyma, pasreta girukotlewatyachri, ga wa Sawolo. ");
INSERT INTO pibNT_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Wanna yonogyegitlu Gitsrukaachi, ga wa rogajirewatna. Wane china Giwekikaluru Kpashiri, “Gkotspalatinno Wirnawisi ga wa Sawolo kamrurchi chinanu. Wale chinanu ntomgana.” ");
INSERT INTO pibNT_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Giyagni rogajirewatna. Ragjigognetna. Wannatseptagi rutakamyotna. Yokanatkatkana. ");
INSERT INTO pibNT_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Giyagni wanna yokanatkalune wa Giwekikaluru Kpashiriya yopikna. Selesi rapokna. Wane yagapgatyana. Supro rapokna. ");
INSERT INTO pibNT_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Salamina rapokatnakna. Wane runkakletyaluna Goyakalu tokanu Goteyone ginkaklewawaklepjikaka. Waneyamnuna Gwa kamrurewyegitjerna. ");
INSERT INTO pibNT_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Koprutna psolu kniprekako, Papo rapokinpotukna. Wane retyaluna satu jeji kagonchi, tokanchi geneklewatachri wale potu migje. Goteyni. Wargeso giwakatletachri. ");
INSERT INTO pibNT_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Sergyo Pawlo girukotlewatachriymalu Wargeso. Jeji kgimatkalerni Sergyo Pawlo. Wale gepukna Wirnawisi ga wa Sawolo. Raluka yijnakletlu Goyakalu tokanu. ");
INSERT INTO pibNT_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Gilima kagonchimka gaalixna. Gilimni wa yokaakaluru Wargeso giwaka. Raluka satookakletmaklu girukotlewatachri ma malixinitipa. ");
INSERT INTO pibNT_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Giyagni Sawolo, walenwa Pawlo, Giwekikaluru Kpashiri gwagajitanru potu, retpotutlu. ");
INSERT INTO pibNT_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","Wane chinru, “Psolpotuyako kyokwirewakleryi, mshinikanutyi. Tsru kamchi wgenyi. Poyagkaklewlu gayegixachriyi. ¡Wuya! ¡Pkaspuka yoliwgapkakletanmaklu potukgapolu Gitsrukaachinu! ");
INSERT INTO pibNT_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Ga wa xani, Gitsrukaachimyo pixa yegi rapoka. Metashatkatunapyi. Gowukshinina gi petlewatanuna tkachi.” Waneklu rapyegitanatkalu yachgapere pixkalutu ga wa mapshagalu. Sajrurunatanatka. Rujgalu kanjitjerupa. ");
INSERT INTO pibNT_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Giyagni wa girukotlewatachri wane gixkaluru retinitka, ralixa. Ruglajitana Gitsrukaachi tokanuya. ");
INSERT INTO pibNT_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Papo rutspegyatkana wanna Pawlo. Perge yana Pampirisreta. Ga wa Gwa gitspalatyana. Gerosale satoka. ");
INSERT INTO pibNT_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Perge yagapgatyana. Rapokluna Gantiyoki, Pisirisreta. Gapnanutikalurgogne jiglokluna ginkaklewawakapji. Wane tuplatna. ");
INSERT INTO pibNT_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Retyongatka Tokanchi Yokanatkaluru ga wa tokanchi geneklewatachine kirukate. Rali getyongaletkoklunu yokanrewatna ginkaklewawakapji gitsrukatene wanna yegi. Wane chinjixkana, “Jejine, wumolene, waneygi nchininipa satu tokanchi yine giykotinripa, ginkaklewatanu.” ");
INSERT INTO pibNT_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Giyagni Pawlo palna. Yotukamyoyegitna pochke rixinripna. Wane china, “Jejine, Gisrayiline, wa Goyakalu pikachine, gyijnakotanu. ");
INSERT INTO pibNT_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Wutsrukatenni tsomita nyi Gisrayiline Goyakalute. Pnu gajene rixanatinna Gigiptoya, tsru potu rixkakna. Tsru ruyakle wane koshpakyana. ");
INSERT INTO pibNT_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Gepkoxamkojmole walapupshini Goyakalu gakotlu rixjetyawakna yineru mwiyawakanuya. ");
INSERT INTO pibNT_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Payokgipreneru nikata Goyakalu Kanachijneya. Payinnichijne renekna. ");
INSERT INTO pibNT_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","“Ruknoginitka gepkoxamkoje pacha pamyomole walapu, renekna gitakyagoklewatachine, Samoyro tokanchi geneklewatachriklupotunanuko. ");
INSERT INTO pibNT_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Wanepnute pogirchi renekikolupna ragjitna. Goyakalu genekna Sawolo, Susu wgene, jeji Wigamiklopisha, gepkoxamkojmole walapu rawinripa. ");
INSERT INTO pibNT_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Konkoklunutka wale. Tawi renekna Goyakalu pogirna rixinripa. Wane china gipgujtaletlu, Netlu Tawi, Gesi wgene, nugleretgajityawaka. Wale kamrutanru pejnuruko nalukanru. ");
INSERT INTO pibNT_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","“Rupiratyawakpotuko waleklopishaneya Goyakalu gipgujewnakaklu Geso, Gisrayiline Gognetkakachritka. ");
INSERT INTO pibNT_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Ma munkanuwa Geso, Gwa ginkakletlu katlu genshinikanrupirana pejnuruneko Gisrayiline chinanu. ");
INSERT INTO pibNT_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Wa poyagkaka kamrurenanumtinitka Gwa, wane china, ‘¿Giru gkagwakyano? Gi wa gitni gkagwakanru, seyni runa satu najxigi. Gi wa gita gimukluni nkoshpirokyaplu yoshmaklejixitsa.’ ");
INSERT INTO pibNT_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Jejine, nomolene, Gawraklopishane wgenengi, ga wa gixatskala gwachine. Goyakalu pikachingi, Goyakalu yokanyegitgi gixa tokanchi tye gognewatikalurupirana. ");
INSERT INTO pibNT_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Gi rixanu wa Gerosale gwachine ga wa rutsrukatenna gi rumatluna gognewatikalurupirana. Ga wa gi rumatluna wa tokanchi geneklewatachine tokanu pagapnanutikalurgognemnu retyongatka. Giyagni poyagkakluna tye tokanchi wa Geso ruklukanuwnayegjixyana. ");
INSERT INTO pibNT_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Gi rukshika giklukanuwnaletluna rupninripa, seyni Pilato ragjitna ruylatikolupa. ");
INSERT INTO pibNT_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Poyagkakinitkaluna pejnurkakako Walepirana yonatkaluru, gagmunashkitaya rawiyatkaluna. Yomlechi rutakluna. ");
INSERT INTO pibNT_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Seyni Goyakalu yotunkaklu gipnachinetskalaya. ");
INSERT INTO pibNT_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Gixgogne retkatnaka rukanikanuneya wa Kalileya kanikini Gerosale. Wannanwa yine yegi rupgujtatjene. ");
INSERT INTO pibNT_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","“Wixa koxa ginkaklewyegitgi Kiglerpotunanu Tokanchi wa gitsrukatenni gipiratyegitkalurupirana. ");
INSERT INTO pibNT_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Wanepotuko Goyakalu poyagkakatkalu wannaklopishane yegi: wixa yegi yotunkakatkalu Geso. Shikalchi gepi chininri chinyongatyawaka koxa: Pixni Noturyi. Xawakni nwugenetyi. ");
INSERT INTO pibNT_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","“Kapiranalni wa tye: wa gipnachinetskalaya yotunotinri Geso, gi pagogneko gijpagikowaka satokinripatka. Wane china: Nenekangi kpashirkaka gaponshinikanutkaluru Tawinu. ");
INSERT INTO pibNT_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","“Giyagkoxni wane china satu shikalchiya: Gi puchi gijpagletanru Pixa Wgene kpashiri. ");
INSERT INTO pibNT_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","“Gi rixanu Tawi galikakni gigogne gajene gipxaka. Rali gipxakletinitkana, rapnanutatka. Rutsrukatenni yegi rutaaka. Rujpaganatka. ");
INSERT INTO pibNT_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Ga wa Wale Goyakalu yotunkakanru gi gijpaga. ");
INSERT INTO pibNT_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","“Giyagni jejine, nomolene, gimatanru runkakletka gixa chinanu kaspuka mukochiretikolu Waleya. ");
INSERT INTO pibNT_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Moysisi Tokanu Yokanatkaluruya gi gimkata ptowruyako muklukanuwnakaakone gixletna yine, ga wa Gesoya ptowruyako muklukanuwnakaakonetka rixinritkana pejnuruneko galixachine. ");
INSERT INTO pibNT_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Giyagni getinwa ma munyegitinitipgi wa tokanchi geneklewatachine chinyawaka: ");
INSERT INTO pibNT_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Getanu kgeyikaklerune. Giglajitanu. Gisuptaganuna. Gi rixanu kamrurchi nkamrutanu gixagogneklu. Kamrurchi satumka ginkakpokowakatangi gi galixanru.” ");
INSERT INTO pibNT_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Goteyone ginkaklewawaklepji rushpakinitkana Pawlo ga wa Wirnawisi, payine gagjitna tujra gapnanutikalurgogne runkaklewyegitikolupna tyepirana. ");
INSERT INTO pibNT_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Rungakatkana gapatachine. Gixolune Goteyone ga wa Goteyone gitaknachinwa kyonogiklerune, Pawlo romkagitna ga wa Wirnawisi. Pawlo ga wa Wirnawisi giynumsatna. Rushinikanutkana Goyakalu yegi rawinripna Wale gimutyapna. ");
INSERT INTO pibNT_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Giyagni rapokinitka gapnanutikalurgogne psolu pokchi gajenenshinikanuko gapatjeta yijnakotyapluna Goyakalu tokanu. ");
INSERT INTO pibNT_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Ga wa Goteyone getna gixolune yine. Ranxapotutna. Giyagni Pawlo ginkaklewle yoptopiratna mupashiregone. ");
INSERT INTO pibNT_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Giyagni Pawlo ga wa Wirnawisi pgujetanuwaka china ginkakletna. Wane chinna, “Gixa muchinanu gapka wumkata ginkakleta Goyakalu tokanu. Seyni gi rixanu gixa giknoklu, ga wa gitakyagoknawa gi wa gimuknuni gyoptotyalu giwekinri mnikawnakatu, xanipatka pnuko gayanutka payine yegi. ");
INSERT INTO pibNT_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Gi rixanu wane rixa yokanretwu Gitsrukaachi: Nutakyi payine pokamlatyegitachripyi Gognewatikaluru chinanu pixinripa yoptukyawakpotunanuko chiji.” ");
INSERT INTO pibNT_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Payine yijnakotinri tyepirana, rumuwatna. Rumalwutluna Gitsrukaachi tokanu. Ralixna pejnuruneko wa gitaakalune waneyapna ruwekinrina gike rixiniko mnikawnakatupa. ");
INSERT INTO pibNT_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Wa Gitsrukaachi tokanu psoluko walesretaya raniika. ");
INSERT INTO pibNT_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Ga wa Goteyone yokshatna suxone kyonogiklerone wannapotune, ga wa tsrukakalune pokchi gajene. Pawlo, Wirnawisi chinanu kojwawakchi gixkaaka. Ruknookana wanechijneya. ");
INSERT INTO pibNT_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Giyagni wa wanna ruplokjiximtna gistapjixnapagi wannayegiya. Gikonyo yatkana. ");
INSERT INTO pibNT_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Giyagni Gitsrukaachi yimaklene gimuwaatachine potu ga wa Giwekikaluru Kpashiri gwagajitanune potu rixna. ");
INSERT INTO pibNT_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Wane gixlutkani Gikonyo yana. Pawlo, Wirnawisi jigloklu Goteyone ginkaklewawaklepji. Wane rixa ginkaklewletna wa gixolune yine galixatka, Goteyone ga wa Kriykone koxa. ");
INSERT INTO pibNT_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Ga wa Goteyone malixkane komyekanshinikanutna yine. Yokshatkana moletkakachine chinanu. ");
INSERT INTO pibNT_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Giyagni gi gepikgogne wane rawna. Pgujetanuwaka china ginkakletna Gitsrukaachi chinanu. Wale gipgujtajetlu tokanchi Gitsrukaachi gimutlewleyapirana. Renekna getkalurkaka, koglajrukaka. Wannamyoya wane rixika. ");
INSERT INTO pibNT_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Seyni gixolune pokchi gajene kotspalanshinikankaka: pimrine Goteyoneyma, pimrine yokanatkaluneyma. ");
INSERT INTO pibNT_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Payine giptekyegimtmakna ga wa Goteyone koxa, rutsrukateneymananukna. Yenetikolupmakna ga wa sotlujetikolupmakna. ");
INSERT INTO pibNT_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Wanna gimata. Rasukna. Listra, Terwe yana, pokchikaka Likayonisretaya ga wa sajrukyawaka chiji. ");
INSERT INTO pibNT_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Wane runkakletyaluna Kiglerpotunanu Tokanchi. ");
INSERT INTO pibNT_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Listra gajeru jeji muglejixitu tuplanata, myankatu rushpakinyakawa. Pagogne myanjejetkatu. ");
INSERT INTO pibNT_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Wale yijnaka yanumsaletlu Pawlo. Pawlo yopukgapotutlu. Retlu ralixinri rutuukakikolupa. ");
INSERT INTO pibNT_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Muchkowtokanuta. Wane china, “Palnanu. Potuktunwalepyi.” Ruptekapa. Yanamtatka. ");
INSERT INTO pibNT_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Giyagni yine getinri wa Pawlo kamrutanru, saplewatna. Likayoni gajene tokanu wane chinna, “Goyakalune, jejine pixkalune wixa yegi gijrukachine.” ");
INSERT INTO pibNT_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Giyagni Gopite chinruna Wirnawisi, ga wa Pawlo Merkoryo chinruna, gi rixanu walenwa tokanchi ginkakletjepotuta. ");
INSERT INTO pibNT_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Giyagni Gopite sasertotete pokchi ginaple gwachri, gipgyaptokaka ranikna wakane jejine ga wa giglegwutkaluru. Raluka genekashletlu giylatkaluru yineyma. ");
INSERT INTO pibNT_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Wanna yokanatkalune Pawlo, Wirnawisi yijnakotinitkalu suskakamkatna. Rakaxikamtna. Yine ganikajite rapokna. Saplewatna. ");
INSERT INTO pibNT_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","Wane chinna, “Jejine, ¿klu chinanu wane gixa? Yinkoxwu wixa. Gixa pixka geta salewnaletachinwu. Kiglerpotunanu Tokanchi wunkakleta gkashrijetikolupa tyekaka gike gaprimigjeya. Goyakalu giwekachrinunepgi. Tengogne kamrutachri, ga wa chiji, ga wa tsru wenu, ga wa ptowrunanuka wanerutu kamrutachri. ");
INSERT INTO pibNT_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Giknogachri gwashlukakatka Wale getashatna payinemnunanuka wannako gigapo yapinripna. ");
INSERT INTO pibNT_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Seyni koxa gi wa mupgujtatkotu retashyegitnawa. Seyni kigleru kamruta. Teno giyakatyachri gina renekgi, ga wa jirgalupapko. Poyampotutyawaka renekgi gnikjetanruya, ga wa gimuwleya.” ");
INSERT INTO pibNT_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Wane chinikopshinna kyapreru rumkata gituukakletna yine ma menekashatikotupna giylatkalurupmaka. ");
INSERT INTO pibNT_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Rapokna Gantiyoki ga wa Gikonyo giyakatyachine Goteyone. Rushinikanutkana gixolune. Sotlujetluna Pawlo. Gipnachri kagwakyaluna. Pokchi kotlolomtyatkaluna. Maleka rutakluna. ");
INSERT INTO pibNT_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Wa Gitsrukaachi yimaklene sajruklu. Yotunota. Pokchi satokatnaka. Waleprika Terwe yatkana Wirnawisiyma. ");
INSERT INTO pibNT_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Wane pokchi Kiglerpotunanu Tokanchi wanna ginkakletya. Gixo yimaklene rixkakna. Listra satokatkana, ga wa Gikonyo, ga wa Gantiyoki. ");
INSERT INTO pibNT_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Muchkotanshinikanutkana Gitsrukaachi yimaklene. Ruykotkana romkaga galixletinripna. Ruykotkana wa gixo salewakchiyma wumkata jiglokletyaplu Goyakalu pogirewatyawaka. ");
INSERT INTO pibNT_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Satkaka gapatjetikwaka rutaakana tsrune. Ragjigognetna gogajirewatachine. Gitsrukaachi raponshinikanutna wanna chinanu, wa ralixanrutkana. ");
INSERT INTO pibNT_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Pisiri yapa kopruremtna. Pampiri Pokchi rapokna. ");
INSERT INTO pibNT_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Perge runkakletyaluna tokanchi. Gatali yopikna. ");
INSERT INTO pibNT_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Wane rutspegyana. Gantiyoki rapokna, wa Goyakalu gimutlewle rumaponshinikanutikowakna kamrurchi chinanu, wa poyagkakapanrutkana. ");
INSERT INTO pibNT_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Rapokinitkana, wanna gapatjixna gapatjetachine. Runkaklewatna gi pejnunanukta Goyakalu gikamrurewatyawaknapirana, ga wa Goyakalu kotpukyegitna payine galixlu gipgyaptote. ");
INSERT INTO pibNT_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Gi gepikgogne wane rawna Gitsrukaachi yimakleneyma Pawlo ga wa Wirnawisi. ");
INSERT INTO pibNT_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Wa pimrine Goteya giyakatyachine ginkakna moletkakachine. Wane chinna, “Gma sajruka gistakletkonu wa Moysisi gixjixlewatyawaka, gi gimkata gognetkaakotanu.” ");
INSERT INTO pibNT_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Giyagni waneru tsru gigjekaklu, gepomsakaklu Pawloyma ga wa Wirnawisi wanna chinanu. Rutaakana Pawlo ga wa Wirnawisi Gerosale kanikinripna, pimrine wannayma, wa yokanatkalune ga wa tsrune yegi tye gepomsakaklu chinanu. ");
INSERT INTO pibNT_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Giyagni wanna gipxaletamtka gapatjetachineya. Winisi yapa kopruremtna ga wa Samari. Runkaklewananumtna payine kashrijetikolupirana. Tsru gimjiklu rixkakna moletkakachine. ");
INSERT INTO pibNT_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Gerosale rapokinitkana, yoptotkana gapatjetachineya ga wa yokanatkaluneya, ga wa tsruneya. Runkaklewatna gi pejnunanukta Goyakalu gikamrurewatyawaknapirana. ");
INSERT INTO pibNT_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Giyagni tunwatna pimrine Gwariseyone mkoje galixachinetka. Wane chinna, “Rumkata sajruka gistaakotkana. Rumkata kamrujixkotkana Moysisi Tokanu Yokanatkaluru.” ");
INSERT INTO pibNT_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Yokanatkalune gapatjeta ga wa tsrune rumatyapluna wa tyepirana. ");
INSERT INTO pibNT_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Tsru gepomsakaklu wane chininitka, palna Petro. Wane chinna, “Jejine, nomolene, gixa gimatlu wa muchikawako Goyakalu tsomitno gita tokanuya wa payine yijnakotyaplu Kiglerpotunanu Tokanchi, ralixinripna. ");
INSERT INTO pibNT_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Goyakalu gaschi gimatachri gipgujtatna, wa wane rixa genekletna Giwekikaluru Kpashiri wixako pixka. ");
INSERT INTO pibNT_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Psolpotuyako pixkakakanwu rixa getletwu wixa, wanna. Powratgajitna ralixleyna. ");
INSERT INTO pibNT_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Giyagni wa xani ¿klu chinanu gyantaletlu Goyakalu, Gitsrukaachi yimaklene gogo gitakyawaklu gitjipije? Gi wa wutsrukatenniko gimkata ganikletlu, gi wixako. ");
INSERT INTO pibNT_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Seyni walixlu Gitsrukaachi Geso gimutlewleya wognetkaaka wannako pixka.” ");
INSERT INTO pibNT_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Giyagni pejnuruneko gixolune gichkeka. Yijnakotluna Wirnawisi ga wa Pawlo runkaklewatinna gi pejnunanukta tsru getkalurkaka ga wa koglajrukaka Goyakalu wane gixkakyawakna payinetskalaya. ");
INSERT INTO pibNT_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Wa ruchkekinitkana wanna, Santiyako gigita. Wane china, ");
INSERT INTO pibNT_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","“Nomolene, gyijnakotanno. Simo ginkakletlu gikta rixpokotlu Goyakalu. Muchinanu salwayegitna payine, wa wannayegiya yoptotyapna rayinerutenepa. ");
INSERT INTO pibNT_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Waneko pixka chintokanutna tokanchi geneklewatachine, yonchi chinyawaka: ");
INSERT INTO pibNT_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","Wanepnute nsatokanutnaka. Nugletanutnaklu Tawnipji, wa yawnachrinatka. Nugletanutnaklu gimtutewnachritka. Ntunotakanutnaklu. ");
INSERT INTO pibNT_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Wa gixetachine yine gijgiyaplu Gitsrukaachi, ga wa pejnuruneko payinemnunanuka, ngiwakaya chinkalune. Wane china Gitsrukaachi tyekaka pejnuruko kamrutachri. ");
INSERT INTO pibNT_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Muchichyawakpotunanuko rumatkakatkalu Goyakalu tyekakapirana. ");
INSERT INTO pibNT_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","“Giyagni gita gitakyawaka mkojwaakonepni payine kashrijetkalune Goyakalunune rixinripna. ");
INSERT INTO pibNT_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Seyni yonyegitkalunepni rutspalatyapluna puchotlewatachri yagluchishaya, ga wa gapoklewluya, wa saprinojrurusha, ga wa granchiya. ");
INSERT INTO pibNT_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Gi rixanu muchikawa potu gwashluyakawa Moysisi waneya runkakletjene papokchikaka ginkaklewawakapjikakaya. Wane retyongapiranatika pagapnanutikalurgognemnu.” ");
INSERT INTO pibNT_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Giyagni kigle getle rixluna yokanatkalune, ga wa tsrune, ga wa pejnuruneko gapatjetachine tsomitikolupna pimrine jejine wannayegiruneko, Gantiyoki yokanatikolupna Pawlo Wirnawisiyma, wa Gota, wa Warsawa yokletgiwakatachri, ga wa Sura girukotlewatachine jejine moletkakachinyegiya. ");
INSERT INTO pibNT_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Kigle getle rixluna yonatkaluropa kiruka wanna ganikanropa. Wane chinachropa: “Wixa yokanatkalunwu ga wa tsrunwu, ga wa wumolene galukgiwakatgi, wumolengi, Gantiyoki gwachine, ga wa Suri gwachine, ga wa Surisya gwachine. ");
INSERT INTO pibNT_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Gi rixanu wyijnakyegitlu pimrine wixa yegi giyakatyachine kojwakgi tokanchiya. Rumtukanshinikanutgina. Gi wa wanna wyokanata. ");
INSERT INTO pibNT_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Panshinikanurunwu wixanatini kigle getle wixlu wtsomitkapna jejine ga wa wyokanatyapna gixa yegi: walukanune Wirnawisi ga wa Pawloyma. ");
INSERT INTO pibNT_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Giyagni wutakna jejine genekgiwekletachinemka Wutsrukate Geso Kristo giwaka chinanu. ");
INSERT INTO pibNT_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Giyagni wyokanatna Gota ga wa Sura. Waneko pixka china ginkakletangina. ");
INSERT INTO pibNT_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Kigle getle rixlu Giwekikaluru Kpashiri ga wa wixa koxa gi satuna kamrurchi gitakyegitko wanepnute. Tyekakapjetkani gimkata kamrutkaluru: ");
INSERT INTO pibNT_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Gitspalatinri wa yagluchisha geneekalurkaka, ga wa granchi, ga wa saprinojrurusha, ga wa gapoklewlu. Wale pejnunanukaya gkamrutini, kigleru gkamruta. ");
INSERT INTO pibNT_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Giyagni wanna yokanatkalune yopikna. Gantiyoki rapokna. Wanna gapatkakna gixolune. Kiruka yonatkaluro reneekana. ");
INSERT INTO pibNT_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Retyongatinitkalona rumuwatna giykolu chinanu. ");
INSERT INTO pibNT_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Gota koxa ga wa Sura tokanchi geneklewatachinkoxna wanna. Giyagni ruykolewatna gi gepika tokanchiya moletkakachine yegi. Muchkotanshinikanutkana. ");
INSERT INTO pibNT_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Pshinitsonu wane rawamtna. Yokanatkana moletkakachineya kiglenshinikanurune, yokanatjenna yegi yinripna. ");
INSERT INTO pibNT_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Seyni wa Sura kigle getle rixlu rutukinripa wane. Gotapje yatka. ");
INSERT INTO pibNT_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Pawlo ga wa Wirnawisi Gantiyoki rawanatna. Gitsrukaachi tokanu runkakletna. Kiglerpotunanu Tokanchi runkakletna pimrine gixoluneyma. ");
INSERT INTO pibNT_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Pagognetnakni Pawlo wane chinru Wirnawisi, “Wsatokanutnaka wsalwayegityapna moletkakachine papokchimnunanuka wa Gitsrukaachi tokanu wunkakletanatyawaka, gi pixkaktana.” ");
INSERT INTO pibNT_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Wirnawisi galuka ganikletmaklu Gwa, Marko yokletgiwakatachri. ");
INSERT INTO pibNT_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Seyni Pawlo gi kigle getle rixlu ranikikolupa wannayma rixinripa gi rixanu wa Pampiri Marko gitspalamtyana; kamrurchi yegi myakatutka wannayma. ");
INSERT INTO pibNT_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Jigeekakna. Wane rixlenanukna rutspalkakyana. Wirnawisi ganikatkalu Marko. Koprugatna. Supro yana. ");
INSERT INTO pibNT_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Ga wa Pawlo Sura tsomitatka. Yatka. Gitsrukaachi gimutlewleya rumaponshinikanyegitkana moletkakachineya. ");
INSERT INTO pibNT_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Suri ga wa Surisya yapananumtna. Muchkotanshinikanunanumtkana gapatjetachinkaka. ");
INSERT INTO pibNT_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Terwe rapoka Pawlo. Wanepnute Listra. Wane rawa satu Gitsrukaachi yimakleru Timotiyo giwakatletachri, galixachro Goteyo suxo wgene. Ga wa ruru Kriykoni. ");
INSERT INTO pibNT_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Listra ga wa Gikonyo gajene moletkakachine kiglepiranyegiru chinanruna. ");
INSERT INTO pibNT_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Walemka Pawlo galuka waleyma chininripa. Raniklu. Sajruka gistakletlu Goteyone chinanu wane pokchikaka gajene, gi rixanu pejnuruneko gimatlu Kriykoni wa ruru. ");
INSERT INTO pibNT_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Papokchimnu yapananumtna. Renekananumtkana rumretyapluna tokanchi poyagkaakalurupa wa yokanatkalune ga wa tsrune gitakanru Gerosale gwachine chinanu. ");
INSERT INTO pibNT_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Giyagni wa gapatjetachinkaka muchkotanshinikanutkana ralixleyna. Pagognemnunanuka ruxolewnananumtna. ");
INSERT INTO pibNT_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Prigi sreta koprutna. Wanepnute Kalatasreta. Giwekikaluru Kpashiri gijretna Gasya ma munkaklewatinitipna tokanchi. ");
INSERT INTO pibNT_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Misi rapokatnakna. Witinimka yana. Giwekikaluru Gesonu gi gichichna. ");
INSERT INTO pibNT_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Giyagni ruknogamtluna Misi. Yopikna. Trowa rapokna. ");
INSERT INTO pibNT_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Goyechno Pawlo getlu kayigawlu. Satu jeji Masetoni gajeru tunwastsitlu. Ragjitlu. Wane chinru, “Pkoprutgatanu. Masetoni punanu. Pupxakapanunwu.” ");
INSERT INTO pibNT_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Wa retinitkalu kaygawlu waneklu wupruka Masetoni gayinripa. Wale wumatyatkalu Goyakalu tomgawu Kiglerpotunanu Tokanchi wunkaklewyegityapna. ");
INSERT INTO pibNT_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Trowa wutspegyatka. Potuklega gaya. Samotrase wapoka. Waleprikgogne Neyapoli wapokatnaka. ");
INSERT INTO pibNT_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Waneya Wilipo wapoka. Walenwa tsru potu pokchi Masetonisretaya. Walenwa pnu giyakatyachine gwiyawaka. Wale pokchi gawanata gi pejnugognekta. ");
INSERT INTO pibNT_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Pagogne gapnanutikalurgogne pokchi gayiyatka gipgyaptoteya. Gonustsi gayiya wa ragjigognejetyawakna. Wane wtuplata. Wuynumsatna suxone wa gapatachine. ");
INSERT INTO pibNT_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Wanenanro sato suxo Litya giwakatletachro, Tiyatira Pokchi mkachri pakni yoshmookaluru pixkalutu gishanretjetachro. Goyakalu yonogyegitachro. Tyijnakota. Gitsrukaachi kotpukanshinikanutlo wala, tyijnakpotutyaplu Pawlo chinyawaka. ");
INSERT INTO pibNT_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Wala katka ga wa tomolene. Rali katkoklunutkana, tagjitwu. Wane china, “Gitakyagokinno wa Gitsrukaachi nalixinri, gjiglokapjitanno. Wane gwanu.” Chipetpotutwu. ");
INSERT INTO pibNT_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Wane rixatka. Gagjigognetikwaka gayamtini, tyoptotapwu sato makloji wayegrechro. Waneylo kamchi kagonchiwatinri. Gixo tkanashkatanru twapyegitna twayegitanune tkagonchitinri. ");
INSERT INTO pibNT_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Tomkagimtwu Pawlo ga wa wixa. Wane china saplenanumta, “Nyi jejine Goyakalu teno potu Gajeru wayegrenni. Wanna ginkaklewyegitgi gognewatikalurgapopirana.” ");
INSERT INTO pibNT_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Gi gepikgogne wane tixjeta. Seyni gi rugleretlu Pawlo. Ruprotaka. Wane chinru kamchi, “Geso Kristo giwaka nyokanatyayi, pushpakanutka walaya.” Wanekluyakawa rushpakamtatka. ");
INSERT INTO pibNT_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Retinitkana twayegitanune wa maleshatkalu kagwakanshinikanutanruna kanashkatinripna, kashichanatkaluna Pawlo ga wa Sura. Kosemtkanatkana. Tsrukakalune gapatjetyawaka raniikana. ");
INSERT INTO pibNT_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Girukotlewatachine yegi rutaakoklunutkana. Twayegitanune wane china, “Nyi jejine Goteyoneko. Tsru kojwaklu rixpokchitwuna. ");
INSERT INTO pibNT_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Runkakletluna gixjetikowaakaka ginanshichkalurni wyijnakotyaplu, wkamrutyaplu gi rixanu Romanonwu wixa.” ");
INSERT INTO pibNT_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Gixolune giptekyegimtna. Girukotlewatachine suskamkatna. Gagaje kochipjejixikna. ");
INSERT INTO pibNT_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Rali gipgoletkoklunutkana yoshmakikwaka yoshmaakana. Kyoshmaklewakleru yokanatka rumretpotutyapna. ");
INSERT INTO pibNT_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Wane rixa towutkota, gitokpotugruko yoshmakna. Yoshmakjixitkana. ");
INSERT INTO pibNT_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Ganikajyechno ragjigognetna Pawlo ga wa Sura. Goyakalu gimalwutikolu shikaletna. Wa gostutkalune yijnakotna. ");
INSERT INTO pibNT_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Walgnapunanu waneru tsru giyolikchijru. Wane rixlunanuko wa yoshmakwakapjistsigi gimyemyeta. Wanekluyakawa pejnuru gipgyaptoteko gitpukamta. Pejnuruneko gitkokgosturemtatka. ");
INSERT INTO pibNT_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Giyagni ruyoka kyoshmaklewakleru. Retlu yoshmakwaka gipgyaptotkaka rutpuukanatatka. Koshpaklu yoglolewapi. Ruylatinmakatkawa. Kagwaka gasukletatkana gostutkalune. ");
INSERT INTO pibNT_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Seyni Pawlo tsru saple rixnawa. Wane china, “Gi wa pumtukinwa, gi rixanu pejnurunekwu gewi.” ");
INSERT INTO pibNT_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Giyagni katalo ragjita. Rakaxikamta. Jiglokagrukomta. Gitatatachri chiji rapokamta Pawlojixistsi ga wa Sura. ");
INSERT INTO pibNT_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Maleka koshpakatkana. Wane chinna, “Tsrune, ¿klu numkata kamrureta nognetkakikolupa?” ");
INSERT INTO pibNT_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Wanna wane chinru, “Palixanru Gitsrukaachi Geso Kristo. Waneklu pognetkaako pixa ga wa pupji gajene.” ");
INSERT INTO pibNT_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Runkakluna Gitsrukaachi tokanu, ga wa pejnuruneko gipji gajene. ");
INSERT INTO pibNT_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Wanekluyakawa waleyechnoko ranikna. Rerkatkana wa rupgotikolna. Waneklu katkatka wale ga wa pejnuruneko walenune. ");
INSERT INTO pibNT_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Gipji ranikatkana. Ralpokotlu nikikwaka. Rumuwata gi rixanu pejnuruneko gipji gajeneymananuko ralixatkalu Goyakalu. ");
INSERT INTO pibNT_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Gogi chininitka girukotlewatachine yokanatna kashrewaklerune. Wane chinna, “Pkaspukanna wa nyi jejine.” ");
INSERT INTO pibNT_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Kyoshmaklewakleru ginkakatkalu Pawlo tye tokanchi. Wane china, “Wa girukotlewatachine yokanrewata gkaspukikolpatka gixa. Giyagni wa xani gyanutka. Kiglenshinikanurunemnupgi.” ");
INSERT INTO pibNT_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Giyagni Pawlo wane chinna, “Kochipjetwuna pejnurune getanu, muklukanuwnakanwu. Jejine Romanonekwu; yoshmakikwaka yoshmakwuna. ¿Ga wa xanimkalge ruknokanwuna giyogimatkalunwu? ¡Gike wixiniko! Seyni runanna wannako. Koshpakapanwuna.” ");
INSERT INTO pibNT_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Kashrewaklerune ginkakapna girukotlewatachine tye tokanchi. Pikanna wa yijnakotinrina Romanone rixinrina. ");
INSERT INTO pibNT_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Runna. Rumnanuukana. Koshpaakatkana. Ragjitkana wa pokchiya yinripna. ");
INSERT INTO pibNT_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Giyagni yoshmakikwaka rushpakamtyatkana. Lityapji jiglokna. Retatkana moletkakachine. Rumnanuukatkana. Wane yiyatkana. ");
INSERT INTO pibNT_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Gampipoli yapamtna, ga wa Gapoloni. Tesalonika rapokna. Wane rawa Goteyone ginkaklewawaklepji. ");
INSERT INTO pibNT_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Pawlo gixjetyawaka jiglokyegitna. Mapa kata gapnanutikalurgogne wale giynumsatna Tokanchi Yonatkalurupiranaya. ");
INSERT INTO pibNT_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Rekakgitna rumkata salewnaletinri Kristo. Rumkata gipnachinetskalaya yotunretinri. Wane china, “Geso wa nunkakletyegityagi Walenwa Kristo.” ");
INSERT INTO pibNT_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Pimrine wanna galixa. Pawlo, Surayma jiglokna. Wa Kriykone kyonogyegiklerune, gi gepikna wanna. Ga wa suxone wanna potu gixolune. ");
INSERT INTO pibNT_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Giyagni Goteyone wa malixaklene ganxata. Rawapkana pimrine jejine yaglotashatachine muglene. Potowurkaakana gixolune. Sejrewnananumtna pokchiya. Ruptekyegimtluna Gasopji. Koshpaakomkana Pawlo, Sura yinyegiya. ");
INSERT INTO pibNT_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Gi wa rukshiikana. Gasni kostapna, ga wa pimrine moletkakachine koxa. Pokchi girukotlewatachine yegi raniikana. Wane china sapletna, “Nyi psolchijne gajeneko komyekanshinikanutachine gewi koxa runna. ");
INSERT INTO pibNT_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Gaso yoptotatkana. Susa yokanrekaka mpoyagkaakane wanna Pawlo pejnuruneko. Wane chinna wanegimlu satu pogirchi Geso.” ");
INSERT INTO pibNT_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Kojwakanshinikanutkana yine ga wa pokchi girukotlewatyachine, tyepirana yijnakotinrina. ");
INSERT INTO pibNT_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Yoptomtlona sroschi satkapinripa Gaso ga wa pimrine koxa. Kaspuukatkana. ");
INSERT INTO pibNT_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Waneklu moletkakachine yokanatatkana Pawlo ga wa Sura goyechno, Were yinripna. Wane rapokinitkana, Goteyone ginkaklewawaklepji jiglokna. ");
INSERT INTO pibNT_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Tesalonika gajene pnute kshinikanna wanna Were gajene, gi rixanu yijnakotluna tokanchi psolgalukleyako. Pagognemnunanuka retjetluna yonchi wa galikaklege tyekakapirana. ");
INSERT INTO pibNT_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Giyagni wanna gixo galixa Kriyko suxone wanna potune, ga wa jejine gixolune. ");
INSERT INTO pibNT_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Giyagni Tesalonika gajene Goteyone gimatinitka Were koxa runkakletikatka Goyakalu tokanu Pawlo chinanu. Wane yana. Komyekanshinikanutkana gixolune yine. Kojwakanshinikanutkana. ");
INSERT INTO pibNT_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Giyagni waneklu wa moletkakachine yokanatatkalu Pawlo. Tsru wenusreta yinripa. Ga wa Sura ga wa Timotiyo waneko gituka. ");
INSERT INTO pibNT_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Wa Pawlo ganikjene Gatenpotuko ranikluna. Wanna ganiklu Pawlo tokanu giyampotu runinripna Sura ga wa Timotiyo. Yatkana. ");
INSERT INTO pibNT_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Kagwakinikopshinna Pawlo Gatenaya jigekanshinikanutka wa pokchi retinri gi gepiklu yagluchisha. ");
INSERT INTO pibNT_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Giyagni ginkaklewwakapjiya ruynumsatna Goteyone ga wa kyonogyegiklerune. Pagognemnunanuka giputuya ruynumsatna yoptotanunkaka. ");
INSERT INTO pibNT_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Pimrine galuka gimatletachine Gepikoreyone mkoje gajene ga wa Gestoyko mkoje gajene yoptopiratluna. Ga wa pimrine wane china, “¿Klu raluka chinreta tye kyanumsakleru?” Pimrine wane china, “Kginkaklewaklergetkoni pnuko gixachine goyakalunepirana.” Gi rixanu Gesopirana ga wa gipnachine yotunrepirana runkakletyegitna. ");
INSERT INTO pibNT_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Kashichanruna. Gareyo Magkate ranikluna. Wane chinna, “¿Gi ge wumkata gimatletlu tye gerotu ginkaklewlu, wa pixa ginkakletanru? ");
INSERT INTO pibNT_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Gi rixanu pnuko gixpiranatachri punkakwu. Giyagni waluka gimatletlu klupiranni wa tye.” ");
INSERT INTO pibNT_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Pejnuruneko Gatena gajene ga wa pnu gajene, walepiranapje ruknokakgognetyana, wane rixinrina yijnakotinrina gerotupirana. ");
INSERT INTO pibNT_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Gareyo Magkate ganikajite tunwata Pawlo. Wane china, “Jejine, Gatena gajene, psoluyako netgi yonogyegjeshpotutachingi. ");
INSERT INTO pibNT_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Gi rixanu wa nuknogamtini, netlu gyonogyegjetanrukaka. Netkoxlu satu genekashatikwakakwa, wane china yongatyawaka: Goyakalu Mumatkotu Chinanu. “Giyagni wa Wale wa gixa yonogyegitanru gma mumatanutuko, Wale nunkakletyegitangi. ");
INSERT INTO pibNT_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","“Tye psolchijneko ga wa ptowrunanuka tyechijne gajeru kamrutachri Goyakalu, wa tengogne, tyechijne Gitsrukate rixinri, gi wa myochi kamrutikaluru kpashiwakapji rawa. ");
INSERT INTO pibNT_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Gi wa yinemyo gipxakikaluru pagixanu magatyachri pixkalutu. Gi rixanu Wale pejnuruneko geneka giwekleta, ga wa runnipgyatinrina, ga wa pejnurkakako. ");
INSERT INTO pibNT_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","“Pagragapje kamrutyana panermnunanuka psolchijnemtako rawinripna. Wale gitakyegitna rushingognetyawakapna, ga wa yoptukyawaka rawyawakapna. ");
INSERT INTO pibNT_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Wa rujgiyapluna Goyakalu, wa kamrumrunshinikanutkamkaluna rukshikanmakluna. Gimka gowuklu wa satkaka wixa yegi. ");
INSERT INTO pibNT_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Gi rixanu Wale wuwekya, ga wa Wale wuyoljetya, ga wa Wale gawya. Wa pimrine kiglerupirana kamrutachine gixanune chinyawaka: Gi rixanu Wale gishpakyachinkoxwu. ");
INSERT INTO pibNT_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","“Giyagni Goyakalu gishpakyachinwu wixinri, gi wumkata kori pixkalutu kagwakletyalu Goyakalu, gi wa sroschi pixkalutuko, gi wa sotlu pixkalutuko, gi wa yaglu kamrutikolu gimatkalewluya, yinerushinikannuya. ");
INSERT INTO pibNT_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Giyagni mumatkonchiklushananu, retashlewata Goyakalu. Ga wa xani yokanatna pejnurunekoneru pachijnemnunanuka gajene renshinikanutinripna. ");
INSERT INTO pibNT_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Gi rixanu pagogne rutaka wanepotuko rutakyagokyapna psolchijne gajeneko tye jejiya Wale gitakanru. Renekna pejnuruneko ralixinripna gi rixanu gipnachinetskalaya yotunkaklu.” ");
INSERT INTO pibNT_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Giyagni wa yijnakotinrina wa gipnachine yotunrepirana, pimrine gixpiranawata. Pimrine wane china, “Wumepe yijnakletanutnakyi tyepirana.” ");
INSERT INTO pibNT_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Giyagni Pawlo wanna ganikajite rushpakamtyatka. ");
INSERT INTO pibNT_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Pimrine jejine galixa. Rupxaletluna. Wannaymakoxlu Tiyonisyo, Gareyo Magkate gajeru, ga wa sato suxo Tamari giwakatletachro, ga wa pimrine wannayma koxa. ");
INSERT INTO pibNT_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Wanepnute Gatena yiyatka Pawlo. Korinto rapoka. ");
INSERT INTO pibNT_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Wane retyalu satu Goteyo, Gakila giwakatletachri, Ponto gajeru, ga wa ganunro Presura. Gi gowukshini Gitalya giyakatyachri. Gi rixanu Klawtyo towuwata wa pejnuruneko Goteyone Roma gishpakinripa. Pawlo yayegitna. ");
INSERT INTO pibNT_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Wannapji rawa gi rixanu waleko kamrurchi koxa kamrujeta wale. Kamrurewata. Gi rixanu mkachripji kamrutachinni. ");
INSERT INTO pibNT_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Ruynumsalewjeta pejnuruko gapnanutikalurgogne ginkaklewwakapjiya. Rushinikanutna Goteyone ga wa Kriykone. ");
INSERT INTO pibNT_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Wa Masetoni ruyakatinitkana Sura ga wa Timotiyo, Pawlo gimupruklu tokanchi. Goteyoneyegiya rupgujtatlu wa Gesni wa Kristo. ");
INSERT INTO pibNT_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Raalixmakluna. Mupashiregnuchi chinna. Pawlo giplokamkaluta. Wane chinna, “Gixako chinanupni gamga giwekletanuna. Powrano gita. Xaniyakawa payine yegi nyanutka.” ");
INSERT INTO pibNT_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Wane yiyatka. Gosto giwakatletachri jiglokapjitatka. Goyakalu yonogyegitachri. Ginkaklewwakapjistsi rawapjita. ");
INSERT INTO pibNT_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Krispo wa ginkaklewwakapji gitsrukate galixlu Gitsrukaachi, pejnuruneko gipji gajeneymananuko. Ga wa gixo Korintyo gajene yijnakotlu. Ralixluna. Katkatkana. ");
INSERT INTO pibNT_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Giyagni Gitsrukaachi wane chinru goyechno Pawlo kaygawleya, “Gi pikanu. Seyni punkaklewatanu. Gi wa pochkepyi. ");
INSERT INTO pibNT_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Gi rixanu pixaymano. Gike giptekyegitanyi wa rumtukyapyi. Gi rixanu gi gepikayno yineru tye pokchi.” ");
INSERT INTO pibNT_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Satu walapu wanepnute patsrujire ksuru wane rawa. Goyakalu tokanu runkakna. ");
INSERT INTO pibNT_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Kalyo walenwa Gakayi girukotlewatyachri rixini Goteyone panshinikanurunni kamnixluna Pawlo. Gitaka yagoklewjetikowaka ranikluna. ");
INSERT INTO pibNT_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Wane chinna, “Tye gishinikanutna yine yonogyegityapluna Goyakalu, Tokanchi Yokanatkaluru ginanshichyawaka.” ");
INSERT INTO pibNT_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Yanumatkastsini Pawlo, Kalyo wane chinna Goteyone, “Satu mpoyagkaakatumka ga wa yokwirumka mugletu rixinri, numkata yijnakletanmakgi, Goteyone. ");
INSERT INTO pibNT_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Wa gepomsakaklusha chinini tokanchipirana, ga wa giwakchipirana, ga wa Gyokanyegitikolu Tokanchipirana, getanru gixa. Gi rixanu gi naluklu gitaka yagoklewatachri nixinri tyekakapirana.” ");
INSERT INTO pibNT_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Gitaka yagokjetikwakaya wane rakaxrijetyana. ");
INSERT INTO pibNT_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Pejnuruneko Kriykone kashichlu Sostenese wa ginkaklewwakapji gitsrukate. Gitaka yagokjetikowakaya ginaple ruylakyanruna. Ga wa Kalyo gike rixlu tyekaka. ");
INSERT INTO pibNT_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Wanepnute Pawlo gixgogne wane rawinitka, rungatkana moletkakachine. Rutspegatka. Suri ya, ga wa Presura ga wa Gakila. Senkre Pokchi jiwjitika, gi rixanu waneylu wa Pawlo Goyakalu rupiratinri. ");
INSERT INTO pibNT_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Gigwiso rapoka. Wane ruknokna Pawlo. Wale ginkaklewawakapji jigloka. Ruynumsatna Goteyone. ");
INSERT INTO pibNT_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Wanna gagjitlu wannayma rutukinripachi gowukshiniyaka. Seyni gi rugita. ");
INSERT INTO pibNT_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Rungagonukna. Wane china, “Goyakalu galukiniplu nsatokyegitanutnakgi.” Gigwiso yiyatka. ");
INSERT INTO pibNT_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Susari yinitka. Kanika. Ralkapna gapatjetachine. Gantiyoki ya. ");
INSERT INTO pibNT_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Rali wane gwaletinitka ralimta. Kalatasreta ga wa Prigisreta kopruta. Papokchimnunanuka rapokananumta. Muchkotanshinikanunanumtna pejnuruneko Gitsrukaachi yimaklene. ");
INSERT INTO pibNT_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Giyagni satu Goteyo Gigwiso gapoka, Gapolo giwakatletachri, Galegantri giyakatyachri, jeji gimata yanumsatachri potu, gimkatachri potu Tokanchi Yonatkalurupirana. ");
INSERT INTO pibNT_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Runkakpokowakatluna Gitsrukaachgapopirana. Muchkopiranawatachri ginshinikanuya. Runkaklewata ga wa yimaklewpotuta Gitsrukaachipiranaya. Gwa katlewlepiranapje rumata. ");
INSERT INTO pibNT_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Gapolo yinuwaka pgujetanwaka china ginkaklewleta ginkaklewwakapjiya. Presura ga wa Gakila yijnakotlu. Ranikluna. Runkakpokowakpotutluna Goyakalgapo. ");
INSERT INTO pibNT_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Raluka koprugleta, Gaka yinripa. Moletkakachine yonyegitna Gitsrukaachi yimaklene. Ruykotikolna yoptotyapluna. Wa wale gapokinitka, gixo rupxakna wa gimutlewluya galixyachine. ");
INSERT INTO pibNT_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Gi rixanu psolmuchkonuko rushinikanutna Goteyone pejnurune getanu. Tokanchi Yonatkaluru rekakgityana Kristo chininri wa Geso. ");
INSERT INTO pibNT_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Wane rixatka. Korinto rawanatinikopshini Gapolo, Pawlo gitokosha potu koprunata. Gigwiso rapoka. Retna pimrine Gitsrukaachi yimaklene. ");
INSERT INTO pibNT_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Wane chinna wale, “¿Gi ge gyoptotlu Giwekikaluru Kpashiri wa galixinitka?” Wanna wane chinru, “Giyaka wyijnakpiranyegitlu wa Giwekikaluru Kpashiri wane rixinri.” ");
INSERT INTO pibNT_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Wane china, “¿Giyagni klu gkatika?” Wanna wane china, “Gwa katlewleya.” ");
INSERT INTO pibNT_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Wane china Pawlo, “Gwa katlewata. Genshinikanrupirana katlewatya. Gwa wane chinna yine ralixyapluna rajxigi ginachripa. Walenwa Geso Kristo.” ");
INSERT INTO pibNT_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Wa yijnakotinitkaluna katkatkana Gitsrukaachi Geso giwakaya. ");
INSERT INTO pibNT_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Wa Pawlo gitakamyotseptaagogotinitkana, rapyegitna Giwekikaluru Kpashiri. Panerunmnu tokanu yanumatyana, ga wa Goyakalu tokanu reneklewatna. ");
INSERT INTO pibNT_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Wane pejnugetkona pamole gepi jejine. ");
INSERT INTO pibNT_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Mapa ksuru ginkaklewwakapji jiglokjeta. Pgujetanwaka china yanumsaleta. Ruynumsalewata. Rushinikanutlewata Goyakalu pogirewatywakapiranaya. ");
INSERT INTO pibNT_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Seyni pimrine shikowata. Gi ralixna. Rapatluna Gitsrukaachgapo gixolune jemanu. Pawlo gitspalatyana ga wa Gitsrukaachi yimaklene ranika. Pagognemnunanuka Tiranopji yimaklewatywaka ruynumsalewatya. ");
INSERT INTO pibNT_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Wane rixa gepi walapu. Giyagni pejnuruneko Gasya gwachine Goteyo ga wa Kriyko, yijnakotluna Gitsrukaachi tokanu. ");
INSERT INTO pibNT_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Metjejetkotu ruyaklekaka Goyakalu kamruta Pawloya. ");
INSERT INTO pibNT_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Giyagni mkachrisamkaka, gistatlechkaka gimane gajeru yayixachine yegi ranikna. Rutuka yayixlemtatkana. Kamchine gishpakamtyatkana. ");
INSERT INTO pibNT_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Wanena pimrine Goteyone kagonchine yapashawakle gwachine. Wa kamchine waneyalune chinanumka koschekmakluna Gitsrukaachi giwaka. Wane chinna, “Wa Pawlo ginkakletanru Geso kawchinanu nyokanatgi.” ");
INSERT INTO pibNT_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Wanena Sewa wgenene payokgipre, Goteyo, sasertotene gitsrukate. Wanna wane gixa. ");
INSERT INTO pibNT_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Kamchi gigita. Wane china, “Geso numata. Pawlo koxa numata. Ga wa gixa, ¿katgi gixa?” ");
INSERT INTO pibNT_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Wa jeji kamchi gwanru ruptekyegimtna. Raalixna. Gepi pnute muchkonru. Giyagni walepji rasukyana mamkane poletkalunena. ");
INSERT INTO pibNT_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Kapiranyeglu wa tye pejnuruneko Goteyone ga wa Kriykone yegi Gigwiso gwachine. Pikatkana pejnuruneko. Gitsrukaachi Geso giwaka tserutpiranyegitka. ");
INSERT INTO pibNT_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Gixna galixachinetka gapoka. Rupgujtatnawana. Runkaklewatna wa kamrutanruyna. ");
INSERT INTO pibNT_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Gixna wa kagonchiwanatachine kiruka rapatna. Yoxikanatkalona pejnuruneko getanu. Koshpakwenutlona. Wane pejnu rukshikwenrotyalona: pamole waragkaproji. ");
INSERT INTO pibNT_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Wane rixa muchkonpotuya tseruwnaleta Gitsrukaachi tokanu. Muchkowata raalirewatinri. ");
INSERT INTO pibNT_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Giyagni wane rixkatka, Giwekikaluru gishinikanutlu Pawlo Masetoni ga wa Gaka yinripa. Waneya Gerosale yinripatnaka. Wane china, “Nali wane gwaletinipa, Roma koxa numkata getleta.” ");
INSERT INTO pibNT_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Giyagni gepi rupxakjene Masetoni yokanata, Timotiyo ga wa Gerasto. Gasya rutukawa wale pshinitsonu. ");
INSERT INTO pibNT_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Walegognekaka tsru kegeknanuwlu wane Gitsrukaachgapo chinanu. ");
INSERT INTO pibNT_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Gi rixanu waneru satu sroschi pagixanu kamrujetyachri, Rimitri giwakatletachri. Wale sroschi kamrujetyalu kpashiwakapjiiji Tiyananupa. Gixo wenru rawyana kamrurewaklerune. ");
INSERT INTO pibNT_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Wale gapatjekakna kamrurewaklerune waleko kamrurchi kamrujetachine. Wane chinna, “Gixa gimatlu tye kamrurchi chinanu waneywu wponikowle. ");
INSERT INTO pibNT_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Gixa getlu ga wa gyijnakotlu wa tye Pawlo, gi wa Gigwisopje seyni psolunshinikanuko Gasya, rushinikanutananumtyana gixolune. Wale kashrijetjetna. Wane china wa gi gima goyakalunni wa myochi kamrutikaluru. ");
INSERT INTO pibNT_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Gi wa walepjeni wa tye kamrurchi gike gaprini chinanatko, seyni wanepnute wa kpashiwakapji wa tsro goyakalo Tiyanapji gike gapri rumkata gixkota. Yinuwaka nikatkotanu toyaknu. Walanwa yonogyegitka psolu Gasya gajeneyako, ga wa psolchijneko gajeneya.” ");
INSERT INTO pibNT_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Wa yijnakotinitkaluna tyepirana, ramewnapotutna. Saplewatna. Wane chinna, “Tsropotni wa Tiyana, Gigwiso gajenenu.” ");
INSERT INTO pibNT_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Pokchi gajene gixrijeptajitaa gixa. Panshinikanurune gakaxikamta. Pejnurune gapatjetyawakagruko yana. Kayo ga wa Garistarcho kashichna, Masetoni giyakatyachine, Pawlo gipxaaletanune. ");
INSERT INTO pibNT_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Pawlo galuka gishpakyegletna gixolune yine. Gitsrukaachi yimaklene gi gichichlu. ");
INSERT INTO pibNT_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Pimrine koxa tsrukakalune Gasya gajene, ralukjene, yokantokanyegitluna. Ragjitluna pejnurune gapatjetyawakagruko ma mutakinitipa. ");
INSERT INTO pibNT_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Pimrine saplewjeta, ga wa pimrine pnuko china sapleta. Gi rixanu gapatachine sejrewnashatachine. Gixo potu gi gimata klu chinanu rapatna. ");
INSERT INTO pibNT_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Gixolune yine ganikajite koshpakluna Galegantro. Goteyone gertamtanru. Giyagni Galegantro yotukamyoyegitna pochke rixinripna. Raluka giglepokleyegitnawa wa gixolune yegi. ");
INSERT INTO pibNT_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Wa rumatinitkaluna Goteyo rixinri, pejnuruneko pasaplewatkalune. Gepi goranshinikanu saplewjetna. Wane chinna, “Tsronwa Tiyana Gigwiso gajenenu.” ");
INSERT INTO pibNT_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Giyagni wa yonchikgapri kochrokatkana. Wane china, “Jejine, Gigwiso gajene, ¿girni wa jeji mumatkatu wa Gigwiso Pokchi gajene kpashiwakapji girukotachine wa tsro Tiyanapji, ga wa Gopite gijrukyachro. ");
INSERT INTO pibNT_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Giyagni gi rixanu gi rumkata nutatkota, gixa gimkata gitukletatka. Gike giyampotu wane gixanu. ");
INSERT INTO pibNT_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Gi rixanu gixa gwapna nyi jejine. Gi wa mupashiregonni. Gi koxa woyakalote kapataklerunni. ");
INSERT INTO pibNT_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Giyagni Rimitri ga wa waleymalune kamrurewaklerune waneyna rixinna jijyegitikolu papirana satu chinanu, gapatikowakapa rutakanna. Wanena girukotlewatachine. Runkakletkakanna. ");
INSERT INTO pibNT_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Ga wa gijginiplu satuyako, gapatjetikwaka gitaakaluru ruglepokotikolupa. ");
INSERT INTO pibNT_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","41","Gi rixanu gimkata tomgakota gixa yagotkakluyapa xawakni chinanu. Gi rixanu gike chinanni wugityaplu tye potowurushatyawakapirana.” Wane chininitka, yokanatatkana gapatachine. ");
INSERT INTO pibNT_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Wa rutukinitka gejnugima Gitsrukaachi yimaklene repuka Pawlo. Rumnanukatkana. Rungatkana. Yatka. Masetoni yinripatka. ");
INSERT INTO pibNT_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Wanesreta yapamtini, ruykonanumtna gixo tokanchi. Kresi rapoka. ");
INSERT INTO pibNT_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Mapa ksuru wane rawanata. Raluka yagapgaleta, Suri yinripmaka. Goteyone jemanshinikankakyegitlu. Wane rixa gishinikleta Masetoni satokinripa. ");
INSERT INTO pibNT_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Gasyapotuko rupxaaltapyaluna Sopate Were gajeru, wanepnute Tesalonika gajene Garistarcho ga wa Sekonto, wanepnute Kayo, Terwe gajeru, ga wa Timotiyo; wanepnute Gasya gajene, Tichiko ga wa Trogimo. ");
INSERT INTO pibNT_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Wanna koseka. Trowa kagwakyawuna. ");
INSERT INTO pibNT_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Wa jimapro gisekachri myapjetkotugognekaka giknoginitka, Wilipo wutspegya. Pamyogogne Trowa wapyegityatkana. Wane gawanata payokgipregogne. ");
INSERT INTO pibNT_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Muchinangogne simanaya, rapatna Gitsrukaachi yimaklene jiknajrotyapluna jimapro. Pawlo giynumsatna. Waleprikgogne raluka yaletatka. Goginkaklewleru ganikajyechnopotunanuko. ");
INSERT INTO pibNT_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Gi gepiklo katalo wa tenogruko wa rapatyawakna. ");
INSERT INTO pibNT_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Satu makluji Gewticho giwakatletachri gonotaswawaka tuplanatachri. Ruxapne gaalixanruna. Wa Pawlo gogiynumsalewle rixini, ruxapne gaalixanrunatka. Mapagruko chininriya ruyaka gijrukletyana. Gipnachrinatka gwapkanatka. ");
INSERT INTO pibNT_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Giyagni Pawlo yopikamta. Wale gogo rapokamta. Kanopatlu. Wane china, “Gi wa gejnugimalewatanu. Gi rixanu ruwekinri waneyawalu.” ");
INSERT INTO pibNT_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Giyagni ratskotatnaka. Jiknajrotatkalu jimapro. Niklu. Gixo ruynumsatna goyechnokawpotunanuko. Wane gixachri yatka. ");
INSERT INTO pibNT_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Ranikatkaluna makluji giwekachri. Rumnanukpotutkana. ");
INSERT INTO pibNT_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Wixa gatskotatkalo kanawa. Gaso gayatka. Wane wyoptotinri Pawlo. Gi rixanu wane rixa ginkakpokowakleta. Wale chiji yapamtanu. ");
INSERT INTO pibNT_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Wale yoptotinitkawu Gasoya. Wpokotatkalu. Mitirini gayatka. ");
INSERT INTO pibNT_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Wane wutspegya. Waleprikgogne wapoklu Chiyo ginaple. Pagognetnakni Samo yopjewakle wutspaka. Trogelyo gawamta. Waleprika wapoklu Mireto. ");
INSERT INTO pibNT_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Gi rixanu Pawlo gishinika giknoglemtlu Gigwiso, Gasya ma mamginitpatka. Gi rixanu shireta Gerosale rumkata giknokakletyaplu Tsru Jirgikolgognepatka. ");
INSERT INTO pibNT_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Mireto repukyana Gigwiso gajene gapatjetachine tsrutene. ");
INSERT INTO pibNT_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Rapyegitinitkaluna, wane chinna, “Gixa gimata wa nejigloklegogne Gasya wanekluyakawa, gi pixka gimwale nixanatgi. ");
INSERT INTO pibNT_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Gitsrukaachi wayegrerno nixa. Psolpotuyako malixkotnachriwano. Ga wa gixo noktegayma. Ga wa gixo nyantaletikolu Goteyone jemanshinikankakjetyawakno. ");
INSERT INTO pibNT_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Klunerukta gimkata gipxakjerupa gi wa nyoxigika ginkakletgi yimakletgi pejnurune getanu ga wa papjikakaya. ");
INSERT INTO pibNT_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Goteyone yegi ga wa Kriykone yegi nupgujtatlu genshinikanrupirana Goyakalu chinanu, ga wa Wutsrukate Geso Kristo galixikolupapirana. ");
INSERT INTO pibNT_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","“Ga wa xani gostutkalurno Giwekikaluruya, Gerosale nyanu. Gi numata klunerukta giknoganno waneya. ");
INSERT INTO pibNT_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Seyni papokchimnunanuka Giwekikaluru Kpashiri gipgujtayegitno. Wane china wa gosturewlu ga wa salewakchi waneyapno. ");
INSERT INTO pibNT_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Seyni gike rixno. Gi wa nutakyagoklu nuwekinri kigleypotno gita. Walepje, npoyagkakyaplu psoluko Goyakalu gitakyano numuwleypotuko, ga wa kamrurchi Gitsrukaachi Geso nyoptotinri, nupgujtatyaplu Kiglerpotunanu Tokanchi Goyakalu gimutlewlepirana. ");
INSERT INTO pibNT_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","“Ga wa xani, numata gita gi satuna gixa getgojitanutkano, pejnurunekgi wa gixatskalaya nyapanatini, nunkakletanatinri Goyakalu pogirewatyawakapirana. ");
INSERT INTO pibNT_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Giyagni tyegogne nupgujtatlu muklukanuwnakatno gita pejnuruneko giwekgognenatinripa chinanu. ");
INSERT INTO pibNT_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Gi rixanu gi wa nyoxigika ginkakletgi pejnuruko Goyakalu gishinikanru. ");
INSERT INTO pibNT_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Ggirukotinwa gixnanuko, ga wa ggirukotanna pejnuruneko rowegatene. Wa wanna girukotjene Giwekikaluru Kpashiri gitakgi, ggirukotuyapna Gitsrukaachi gapatjetanune, wenutanune Walenuko gigragaya. ");
INSERT INTO pibNT_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Gi rixanu numata gita, gitgajxigiyaka gixa yegi yoshmakinwana kewetnane kmatsurune, gowegane metashatkanepa. ");
INSERT INTO pibNT_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Pimrine wa gixa, jejine mpotukatupirana ginkakletjetachine gipgujewnanu. Gitsrukaachi yimaklene wanna gajxigimka rawkakanna. ");
INSERT INTO pibNT_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Giyagni giyokanu. Gishinikanru wa mapa walapu goyechno ga wa gogi gi nkaspuka giykoletgi satkaka gixa noktegayma. ");
INSERT INTO pibNT_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","“Ga wa xani Goyakalu naponshinikanyegitgi, ga wa tokanu rumutlewleya. Walenwa kgiyaklewakleru tokanchi, tseruwakyapgi, ga wa renekyapgi kiglerkakapa gyoptotanrupa pejnuruneko kpashirine gixkaluneyma. ");
INSERT INTO pibNT_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Gi satuna neta sotanserojipjojita, gi koriteko, gi gimkaluko. ");
INSERT INTO pibNT_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Gixa koxa gimata tye nomyo nkamrurewatya nalukanru chinanu ga wa gitaymalune koxa chinanu. ");
INSERT INTO pibNT_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Psolpotuyako nyimakgi, wane gixa kamrurewlepotletinripa gimkata gipxakletna gigrokachine. Gimkata gishinikletlu Gitsrukaachi Geso tokanu. Wale wane china, ‘Giglenshinikanyegitkaluru geneklewashatachri yoptotachri pnute.’ ” ");
INSERT INTO pibNT_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Wane chininitka, yoptsojita. Ragjigogneta pejnuruneko wannayma. ");
INSERT INTO pibNT_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Giyagni pejnuruneko tsru chiyaglu gixa. Kanopnojitluna Pawlo. Ramlutluna. ");
INSERT INTO pibNT_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Kachingajpotna wane chintokanutyawakna ma metgojityanpatkaluna. Rumotsamtatkaluna kanawyempotuko. ");
INSERT INTO pibNT_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Wutspalamtyatkana, wyagapgatatka. Potuklegapo gaya. Kowo wapoka. Waleprikgogne Rota wapoka. Wane gaya. Patara wapoka. ");
INSERT INTO pibNT_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Wukshiklo sato kanawa gitsroka. Winisi koprugatachropa. Wane wuptekatka. Wyagapgata. ");
INSERT INTO pibNT_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Pguje chininitka Supro. Wuknogamtlu. Wkegnetesretate rawa. Suri gaya. Wapokatkalu Tiro. Gi rixanu wa kanawa wane koschekwunutiko. ");
INSERT INTO pibNT_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Wane wukshikyana Gitsrukaachi yimaklene. Payokgipregogne wane wutuka. Wanna wane chinru Pawlo Giwekikaluruya Gerosale ma kanikinitipa. ");
INSERT INTO pibNT_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Wpoyagkakgognetinitka, wyiyatka. Pokchi suputalpotuko rumapwuna pejnuruneko suxone ga wa mturuneymananuko. Wanga wyoptsojitatka. Wagjigognetatka. ");
INSERT INTO pibNT_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Wungakakatka. Kanawa watskotatka. Wanna rawyawakna satokatka. ");
INSERT INTO pibNT_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Tiro wuyakatyatka. Wpoyagkaka yagapgaletatka. Tolemayta wapoka. Walukna moletkakachine. Wanna yegi pagogne wutuka. ");
INSERT INTO pibNT_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Waleprika gayatka. Susari wapoka. Wilipi Kiglerpotunanu Tokanchi ginkakletachripji wjigloka. Walenwa payokgipre chininri. Wale yegi wutuka. ");
INSERT INTO pibNT_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Gepkoxamkoje wgenru. Maklojine. Tokanchi geneklewatachine. ");
INSERT INTO pibNT_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Gi gepikgogne wane gawa. Gote yopikyana satu tokanchi geneklewatachri Gakawo giwakatletachri. ");
INSERT INTO pibNT_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Runyegitwu. Rawlo Pawlo gishrikapchijremta rawa. Waleko gijixi rostutnawa Gakawo, ga wa gimyo. Wane china, “Giwekikaluru Kpashiri wane china, ‘Goteyone Gerosale gajene wane rixa gosturejixanruna jeji tye gishrikapchijremta waneyalutu. Payinemyo samyokanruna.’ ” ");
INSERT INTO pibNT_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Wyijnakotinri, wagjitlu wixa wane gajene koxa Gerosale ma kanikinitipachi. ");
INSERT INTO pibNT_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Giyagni Pawlo gigita, “¿Gi gixanatge nchiyaganata, gwamontakgajitno? Gi rixanu galpokomtachritkano gi wa gostutkalurupjepno, seyni nupninrikoxapa numkata gixkota Gerosaleya Gitsrukaachi Geso giwakaya chinanu.” ");
INSERT INTO pibNT_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Gi wumkata gishinikanutletinitkalu, pochketkawu. Wane wchina, “Wane gixkalurupa Gitsrukaachi gishinikanru.” ");
INSERT INTO pibNT_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Walegognekaka giknoginitka, wuprukatka. Gerosale wkanikatka. ");
INSERT INTO pibNT_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Wixaymakoxna Susari gajene pimrine Gitsrukaachi yimaklene. Raniikoxluna satu Gitsrukaachi yimakleru kapokotu, Mnaso, Supro gajeru. Waleyma wane gawamta. ");
INSERT INTO pibNT_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Gerosale wapokinitka moletkakachine gimuwatachine yoptotwu. ");
INSERT INTO pibNT_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Waleprikgogne wixayma jigloka Pawlo Santiyako yegi. Pejnuruneko tsrune gina. ");
INSERT INTO pibNT_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Rali galukletinitkana, psolpotuko Pawlo ginkakna ptowruko wa Goyakalu gixyawaka payineyegiyako wale kamrureya. ");
INSERT INTO pibNT_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Wa yijnakotinitkana, rumalwutluna Goyakalu. Wane chinruna, “Petewa, wumole, gi pejnu waragkananukta Goteyone galixachinetka. Pejnuruneko muchkopiranawyegitlu Tokanchi Yokanatkaluru. ");
INSERT INTO pibNT_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Wanna ginkaaka pixapirana: pixa gima yimakna pejnuruneko Goteyone payinetskala gwachine wanna gitspalatyapatkalu Moysisinu. Wane pchingimata ma sajruka gistakletikotpatkana mturune; gixjetikwaka ma mixinitpatkana. ");
INSERT INTO pibNT_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Giyagni ¿klu wanepa? Wa gixolune gimkata gapatleta. Gi rixanu pejnuruneko yijnakyegitinipyi papokinritka. ");
INSERT INTO pibNT_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Giyagni wane pixanu wa wchinyawakyi. Wanena wixa yegi gepkoxamkoje jejine Goyakalu gipiryegitachine. ");
INSERT INTO pibNT_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Panikanna nyi. Kpashiri pixkaako wannayma. Wanna chinanu pwenutanu shishyajiwutikolupna. Pejnuruneko gimatanu wa pixapirana runkaakana gikeenani, seyni pixa koxa wanepotuko gixanata. Pkamrutlu Tokanchi Yokanatkaluru. ");
INSERT INTO pibNT_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Ga wa payine galixachine wyonyegita wa ginanshichkaluru yagluchisha geneekalurkakaya, ga wa granchiya, ga wa gapoklewluya.” ");
INSERT INTO pibNT_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Giyagni Pawlo ganikna jejine. Waleprikgogne kpashiri rixka wannayma. Kpashiwakapji jiglokatka. Runkakletyaplu poyagkakikolgognekakapa kpashirine rixikolpatkana, satkaka genekashle giylatkalurupa genekikolupa. ");
INSERT INTO pibNT_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Payokgipregogne nikawnakastsi, pimrine Goteyone Gasya gajene, wa retinrina kpashiwakapji, komyekanshinikanutkana pejnuruneko gixolune yine. Kashichluna. ");
INSERT INTO pibNT_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Saplewjetna, “Jejine, Gisrayiline, gipxakanunwu. Tyetkanwa jeji pasretmnunanuka pejnuruneko ginkaklewyegitachri, yine gapatachri, ga wa Tokanchi Yokanatkaluru koxa, ga wa tyepji koxa. Wanepnute Kriykone yoshmaka kpashiwakapji. Tye kpashiwaka gimuteru rixkaka.” ");
INSERT INTO pibNT_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Gi rixanu muchikawa retjejetanruna waleyma pokchiya Trogimo, Gigwiso gajeru. Wanna kagwaklu Pawlo jiglookakyawaklu kpashiwakapji. ");
INSERT INTO pibNT_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Giyagni pejnuruneko pokchi gajene yotaljeptaajitaa rixna. Potowurutna yine. Kashichanruna Pawloni. Kpashiwakapji koshpakyaluna. Waneklu gipgyaptokaka gishyatka. ");
INSERT INTO pibNT_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Ruylatanmakluna. Runkakapka solalone gitsrukate, “Psolpokchiko Gerosale yotaljeptaajitaa gixa.” ");
INSERT INTO pibNT_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Waneklu solalone gitsrukate ganikna solalone ga wa ksolaloterune. Rasukamtna. Gixolune yine yegi rapokna. Giyagni retkana, solalone gitsrukate ga wa solalone, kaspuka giylaklemtluna Pawlo. ");
INSERT INTO pibNT_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Giyagni rapokinitka solalone gitsrukate, kashjixlu. Rostujixanru gepitsa yowumatsaya. Repomgalu gi gixachrini, ga wa klu kamruta. ");
INSERT INTO pibNT_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Wa gixolune pnumnu china sapletna. Gi rumkata gimata jemletlu galikaka wa sejrewakchi chinanu. Giyagni gitoko ranikjixatkalu solalonepji. ");
INSERT INTO pibNT_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Gatskopije rapokinitka. Wane rixa koschekletatkaluna solalone psolmuchkonuko yine kamrutanru chinanu. ");
INSERT INTO pibNT_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Gi rixanu gixolune gwagajxigitna. Saplewananumtna, “¡Puylaganru!” ");
INSERT INTO pibNT_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Yoshmaakastsitkalu Pawlo solalonepji, wane chinru solalone gitsrukate, “¿Gi ge munanshichkotni wa papirana nunkakyapyi?” Wale wane china, “¿Pumatluge Kriyko tokanu? ");
INSERT INTO pibNT_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","¿Gi ge Gigipsyo gajerukyi pixa, wa muchikawako gepkoxamkoje waragka jejine kgiylalewaklerune pkomyekanshinikanuta; yineru mwiyawakanu panikna?” ");
INSERT INTO pibNT_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Wane china Pawlo, “Gita galikakni jeji Goteyno, Tarso gajerno, pokchi kapiranyegiru Surisyasretaya. Giyagni nagjityi puchichyapno yine nunkakinripa.” ");
INSERT INTO pibNT_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Giyagni wale gichichlu Pawlo. Gatskopije tunwata wale. Yotukamyota pochke rixinripna yine. Wa pochke potu rixinitkana, Gewreyone tokanu yanumatya. Wane china, ");
INSERT INTO pibNT_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“Jejine, nomolene, tsrune, gyijnakotanunno. Nuykoyegitnawa xani gixyegiya.” ");
INSERT INTO pibNT_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Jeminitkana Gewreyone tokanu yanumatinna, pochkepotutkana. Wane china, ");
INSERT INTO pibNT_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“Gita galikakni Goteyno. Tarso gishpakyachrino Surisyasretaya. Tye pokchi ntseruwakika Kamalyoyegiko. Wanepotuko yimaakalurno Tokanchi Yokanatkaluru wutsrukatenni chinyawaka. Muchkopiranawatachrino Goyakaluya, pejnurunekgi gixako pixka xani. ");
INSERT INTO pibNT_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Gita kojwakjenatna tyegapo yapachine rupninpotunanukna. Nostutna. Yoshmakjetikowaka nsamyokna jejine ga wa suxone. ");
INSERT INTO pibNT_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Wa wane nixatka sasertotene gitsrukate potu walenwa netjeru, ga wa pejnuruneko tsrune. Wanna yegi nagjityalo kiruka wumolene chinanu. Tamaskomka nyanu, Gerosalemka nanikyapna gostutkalune wane gwanatachine saletkalunepmaka. ");
INSERT INTO pibNT_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","“Wane rixatka, nyanatini, Tamaskostsi napokini, ganikajgogneni walegnapunanu yochigyegitno tengogne gajeru yochigatachri. ");
INSERT INTO pibNT_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Chiji napokana. Nyijnakotlu satu tokanchi wane nchinjeru, ‘Sawolo, Sawolo, ¿klu chinanu pkojwakno?’ ");
INSERT INTO pibNT_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","“Giyagni gita gigita, ‘¿Katyi Pixa, Gitsrukaachi?’ “Wane chinno, ‘Gitni Geso, Nasare gajeru, pixa kojwakanruno.’ ");
INSERT INTO pibNT_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Gitaymalune retluna galikakni yochigatachri. Pikanna. Seyni gi wa jemluna wa nuynumsatjeru tokanu. ");
INSERT INTO pibNT_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","“Wane nchina, ‘¿Klu nkamrutanu, Gitsrukaachi?’ “Gitsrukaachi wane chinno, ‘Palnanu. Tamasko pyanu. Wane punkakiko pejnuruko putakikolupa pkamrutanrupa.’ ");
INSERT INTO pibNT_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Ga wa gitnitka gi netanatka wale gatajnu yochigle chinanu. Gitaymalune kanjimtno. Tamasko napoka. ");
INSERT INTO pibNT_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","“Giyagni satu Ganani, jeji kgipashiregolu Tokanchi Yokanatkaluru chinyawakpotuko, kiglepiranyegiru pejnuruneko Goteyone yegi wane gwachine. ");
INSERT INTO pibNT_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Runyegitno. Tunwata. Wane chinno, ‘Nepuru, Sawolo, petanutka.’ Wanekluyakawa netatkalu. ");
INSERT INTO pibNT_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","“Wane china, ‘Wutsrukatenni Goyakalute muchikawako yokgitatkayi pumatyaplu Wale gishinikanru. Petyakoxaplu wa Poyagkakachri. Pyijnakotyakoxaplu tokanu ginamaya. ");
INSERT INTO pibNT_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Gi rixanu Wale gipgujtatachripyi payinmnunanuko yegi petanrupirana ga wa pyijnakotanrupirana. ");
INSERT INTO pibNT_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Ga wa xani ¿klu pyoxigikanatya? Palnanutka. Pkatkotka. Pmukochire gerkikalurpatkayi. Pkoschekgiwakatanutkalu.’ ");
INSERT INTO pibNT_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","“Wane nixatka. Gerosale nsatokatka. Kpashiwakapji nagjigognenatyatka. Nushpakanshinikanuta. ");
INSERT INTO pibNT_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Netlu wane nchinjeru, ‘Pshiretanu. Giyampotu pyanutka Gerosaleya. Gi rixanu wanna gi yopto gipgujtaletanyi Gitaya.’ ");
INSERT INTO pibNT_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","“Wane nchina, ‘Gitsrukaachi, wanna gimata yoshmakjetikwaka nyoshmakjenatna Pixa galixachine. Nkochipjetna ginkaklewakapjikakaya. ");
INSERT INTO pibNT_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Pupgujtatjerni Gishtuwni giylatkoklununa wane koxa ntunwanata gita. Nugleretlu. Numretamkatna wa ruylatjene.’ ");
INSERT INTO pibNT_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","“Wane chinno, ‘Pyanutka. Gi rixanu Gita yokanatanyi wajra payine yegi.’ ” ");
INSERT INTO pibNT_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Yijnakotluna wale tokanchi chininpotunanuko. Waneklu saplewpotutna. Wane chinna, “Tye chiji gkoninri wane gixachri. Gi rumkata giwekleta.” ");
INSERT INTO pibNT_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Saplewjetna. Ruknopxemkatna. Yoptepagitna. ");
INSERT INTO pibNT_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Solalone gitsrukate ranikjixlu solalonepjigruko. Wane china wa kochipjetikolupa, repomsatko, rumatikolupa klu chinanu wane rixa saplewjeyegitluna. ");
INSERT INTO pibNT_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Nikchimtatsaya kanraakakanatluna. Pawlo wane chinru ksolaloteru wane gwanatachri, “¿Munanshichkotlege gkochipjetyaplu satu jeji Romano muklukanuwnayegjixkotuko?” ");
INSERT INTO pibNT_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Giyagni ksolaloteru yijnakotinitkalu, wane ya. Runkakaplu solalone gitsrukate. Wane china, “¿Gi pixanu? Gi rixanu Romanni tye jeji.” ");
INSERT INTO pibNT_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Wane ya solalone gitsrukate. Wane chinru, “Punkakanno, ¿pixni Romanyi?” Wale wane china, “Gigi.” ");
INSERT INTO pibNT_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Solalone gitsrukate gigita, “Tsru wenru napkapyalu Romano nutakikolu.” Ga wa Pawlo wane china, “Seyni gita wane nixa gishpakleta.” ");
INSERT INTO pibNT_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Giyagni waneklu rutspalamtyatkaluna saletjenepmaka. Ga wa solalone gitsrukate koxa pika, rumatinri Romano rixinri, ga wa rostujixyalu. ");
INSERT INTO pibNT_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Waleprikgogne raluka gimatleta galikakni klu chinanu jigyegitluna Goteyone. Koshpirokjixatkalu rostutikolu. Repukatkana tsrukakalune sasertotene ga wa pejnuruneko jemanshinikankakjetikowaka gajene. Rawpatkalu Pawlo. Wanna yegi rutaklu. ");
INSERT INTO pibNT_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Giyagni Pawlo yopukgatna jemanshinikankakjetikowaka gajene. Wane china, “Jejine, nomolene, muklukanuwnanshinikanutkatno wa nixjetyawaka xanigognenanu Goyakalu getanu.” ");
INSERT INTO pibNT_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Sasertotene Gitsrukate potu Ganani towutna walestsi gwanatachine giylaknamatyaplu. ");
INSERT INTO pibNT_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Giyagni Pawlo wane china, “Goyakalu giylakanmakyi pixa, prijeru galatatkaluru pixkalutyi. ¿Pixa tuplanatachrirayge putakyagokyegitno Tokanchi Yokanatkaluru chinyawaka, ga wa Tokanchi Yokanatkaluru mchinyawakanu puylakjixnoge?” ");
INSERT INTO pibNT_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Wane gwanatachine wane china, “¿Pyangalge sasertotene gitsrukate potu Goyakalunu?” ");
INSERT INTO pibNT_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Giyagni Pawlo wane china, “Gi numata, nomolene, wa sasertotene gitsrukate potu rixinri. Gi rixanu yonatkalurni, Gi wa gektutu tokanchi pchinyegitanru punerune gitsrukate.” ");
INSERT INTO pibNT_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Giyagni Pawlo gimatinri pimrine Sariseyone rixinri, ga wa pimrine Gwariseyone jemanshinikankakjetikowaka saplewatya, “Jejine, nomolene, gitni Gwariseyno, ga wa Gwariseyone wgenno. Nalixkalchinanru yotunkakikolupna gipnachine, gitni wa giklukanuwnayegjixkalurno.” ");
INSERT INTO pibNT_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Wane chininitka rugjekaktokanutna Gwariseyone ga wa Sariseyone. Gixolune kotspalanshinikankaka. ");
INSERT INTO pibNT_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Sariseyone wane china maleshlu yotunru, gi wa Goyakalutowreruko, gi wa giwekikaluruko. Seyni Gwariseyone gipgujtatlu gepiko wane. ");
INSERT INTO pibNT_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Tsru saplechi rixna. Palnana yonchikgapine Gwariseyonesreta gwachine. Yawrotna. Wane chinna, “Gi satuna gektutu wukshikyalu tye jeji. Gikta xani wa giwekikaluru giynumatinri waka Goyakalutowreru.” ");
INSERT INTO pibNT_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Tsru yagotkaklu wane rixinri, solalone gitsrukate pikana kochnokakyapluna Pawlo. Giyagni repukna solalone. Kashjixlu wanna ganikajiteya. Solalonepjigruko ranikjixlu. ");
INSERT INTO pibNT_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Waleprikyechno Gitsrukaachi tunwastsitlu. Wane chinru, “Kiglenshinikanupyi Pawlo. Gi rixanu Gerosale pupgujtatiniko pixkano waneko pixka pumkata gipgujtaletno Romaya koxa.” ");
INSERT INTO pibNT_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Gogi chininitka pimrine Goteyone jiigkaka. Kamakpiratnamkawana. Wane chinna ma muylatkangimapluna Pawlo gi nikanna, gi ruranna. ");
INSERT INTO pibNT_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Gepkoxamkojmole pnutna jiigkakachine. ");
INSERT INTO pibNT_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Tsrukakalune sasertotene ga wa tsrune yegi yana. Wane chinna, “Wkamakpiratnamkawa gi ptsotsotajiko wnikloknijitutanu wma kamakatkanupluchi Pawlo. ");
INSERT INTO pibNT_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Giyagni wa xani gixa wa jemanshinikankakjetikowaka gajeneyma ginkakanru solalone gitsrukate, koshpakyegitangi wanepotuko galuka gimatlepgutatanru pagixanupirana waleya. Ga wa wixa ma mapookanuwa galpokotachinepwu wuylatyaplu.” ");
INSERT INTO pibNT_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Giyagni Pawlo palikleru yijnakyegitlu yogimagnaputyawakapluna. Wane ya. Solalonepji jiglokamta. Runkakatkalu Pawlo. ");
INSERT INTO pibNT_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Giyagni Pawlo tomgalu satu ksolaloteru. Wane china, “Panikanru tye makluji solalone gitsrukate yegi. Gi rixanu waneylu papirana runkakyaplu.” ");
INSERT INTO pibNT_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Giyagni yoptotlu. Raniklu solalone gitsrukate yegi. Wane china, “Wa gostutkaluru Pawlo tomgano. Ragjitno tye makluji nanikyegityapyi. Waneygimlu papirana runkakyapyi.” ");
INSERT INTO pibNT_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Wa solalone gitsrukate kanjimtlu. Kegnete ya wannapje. Repomgalu, “¿Klu waneyyi punkakyapno?” ");
INSERT INTO pibNT_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Wane china, “Wa Goteyone jemkaka ragjitanyina wa yechikawa pkoshpakyaplu Pawlo jemanshinikankakjetikowaka yegi. Wanepotuko raluka gimatlepgutgimatanruna pagixanupirana waleya. ");
INSERT INTO pibNT_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Giyagni gi palixanna pixa. Gi rixanu gepkoxamkojmole pnute jejine wannanune yogimagnaputlu. Wanna kamakpirjetnachinwa ma niikanupna, ma murkanupna ma muylatkanuplunachi. Xani ralpokotatkana. Kagwakluna ptokanu.” ");
INSERT INTO pibNT_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Giyagni solalone gitsrukate yokanatatkalu makluji. Rujretlu, “Gikena pma munkakinitipa wa punkakapyatkano tyepirana.” ");
INSERT INTO pibNT_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Gepi ksolaloterune tomga. Wane china, “Galpokjixanna gepi pacha solalone gokaynona Susari yinripna, ga wa payokgipremole kawalyo kyapaklerune, ga wa gepi pacha kchokorejerune. ");
INSERT INTO pibNT_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Gwapanna kawalyone Pawlo gwamtanropa. Kigle gapokle gixkakanru Gitsrukaachi Wilisi yegi.” ");
INSERT INTO pibNT_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Yonatlo kiruka wane chinyawaka: ");
INSERT INTO pibNT_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","Gitni Klawtyo Risyano. Wa kshinikanuru potu Gitsrukaachi chinanupa Wilisi. Nalukgiwakatyi. ");
INSERT INTO pibNT_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Tye jeji, Pawlo, Goteyone kashichanruna, ruylatanrupmakna. Solaloneyma napyegitlu. Nkoshpaklu. Gi rixanu numatatkalu Romano rixinri. ");
INSERT INTO pibNT_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Naluka gimatletinri klu chinanu jigyegitluna. Jemanshinikankakjetyawakna naniklu. ");
INSERT INTO pibNT_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Nukshiklu wa jigyegityaluna Goteyone gepomsalkakapiranaya Tokanchi Yokanatkaluruya wannanu. Gike jigyegityaluna rupninri chinanupa ga wa rostutikolupa. ");
INSERT INTO pibNT_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Wa nunkakapkoklunutka jemanshinikankakatkana waleya, wanekluyakawa nyokanatatkalu pixa yegi. Nunkakna jigyegitjene runkakyapyina waleya. ");
INSERT INTO pibNT_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Solalone ganikatkalu Pawlo rixa towutikowakna. Goyechno Gantipatri ranikluna. ");
INSERT INTO pibNT_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Waleprikgogne Pawloyma ruchi yaletkatkana kawalyo yapachine. Solalone satoka gipjigrukna. ");
INSERT INTO pibNT_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Susari rapokinitkana. Kiruka renekatkaluna gitsrukaachi. Wale yegi rutaakoxluna Pawlo. ");
INSERT INTO pibNT_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Gitsrukaachi getyongatatkalo kiruka. Repomgalu ginakasreta gajerunanni. Rumatinitka Surisa gajeru rixinri, ");
INSERT INTO pibNT_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","wane china, “Njemanyi runinipna wa pjigyegitjene.” Girorepji, tsrupji, girukotjixyatkalu. ");
INSERT INTO pibNT_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Pamyogogne giknoginitka yopikatka Sasertotene Gitsrukatpotu Ganani, pimrine tsruneyma, ga wa satu ktokanuwakleruyma, Tertolo. Runkakletluna Pawlopirana gitsrukaachyegiya. ");
INSERT INTO pibNT_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Tomgaka Tertolo. Yinuwaka jigyeglewleta. Wane china, ");
INSERT INTO pibNT_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","“Ga wa pixa chinanu kigle gwashlepotwu. Gixopirana giglepokotka yinyegiya pyanshinikanugnaplewle chinanu. Psolgogneko, pasretmnunanuka wyoptotyalu, psolpotuyako wpoyagnutjetyi, kanshinikanuru potu Wilisi. ");
INSERT INTO pibNT_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Ga wa nma mumaletpotutyanupyi, nagjityi pyijnakotyapwu pshinitsonu wa pixjetyawaka potukalyi. ");
INSERT INTO pibNT_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","“Gi rixanu wukshiklu tye jeji kojwakpotlewjetachri. Yagotkaklu palnakakjetachrini wa pejnuruneko Goteyoneyegkaka psolchijiyako. Walenwa Nasarenone mkoje chinkalune kosekachri ");
INSERT INTO pibNT_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Kpashwakapji gimuteru rixkakmaka. Wkashichanru. Waluka gitakyagokleyegitanru Tokanchi Yokanatkaluru wixanu chinyawaka. ");
INSERT INTO pibNT_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Ga wa solalone gitsrukate Risya gapyegitwu. Psolmuchkonuyako wumyo konyawu. Yokanatna jigyegitjene pixa yegi yinripna. ");
INSERT INTO pibNT_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Pixpotuko gepomsatanru, pumkata gimatletyaplu pejnuruko tyekakapiranaya wjigyegityalu.” ");
INSERT INTO pibNT_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Pajigyegitkolutu rixluna Goteyone. Wanepotuko chinruna tyepirana. ");
INSERT INTO pibNT_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Gitsrukaachi towutlu Pawlo yanumatinripa. Giyagni Pawlo gigita, “Gi rixanu numata gixo walapu kgitakyagoklewakleryi nyi yinyegiya, kiglenshinikanurno nuykoyegitinwa. ");
INSERT INTO pibNT_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Gi rixanu pixa gimkata gimata jemletlu gi wa pamole gepgognepnutewani Gerosale nkanikinri nyoptsojityeglewtapinripa. ");
INSERT INTO pibNT_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Gi wa rukshiknona satuyma nugjekaktokanutinri kpashiwakapjiya. Gi koxa rukshiknona yagotkaklu palnakakachrino, gi wa ginkaklewwakapjiyako, gi wa pokchiyako. ");
INSERT INTO pibNT_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Gi rumkata gimatkakletlu xani wa jigyegityanona. ");
INSERT INTO pibNT_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Tye nupgujtatnawa pixyegiya, rixgapotyawaka wane chinka pnuko gixachri yimaklewlu, wanepotuko nixa kamrurewyegletlu nutsrukatenni Goyakalute. Nalixlu ptowrukakako Tokanchi Yokanatkaluruya ga wa tokanchi geneklewatachine kirukateya yonatkaluru. ");
INSERT INTO pibNT_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Goyakalu nkagwakyalu waneplu yotunru gipnachine chinanu, poyagkakachine ga wa mpoyagkaakane. Wale koxa kagwakna wanna. ");
INSERT INTO pibNT_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Wale chinanu nmuchkotnawa psolpotuyako muklukanuwnanshinikanutkatupno Goyakalyegiya ga wa yinyegiya. ");
INSERT INTO pibNT_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","“Giyagni gixo walapu giknoginitka wane nya nenekashatyapna kwamonurune nonerune, ga wa genekashlukaka nanikinripa. ");
INSERT INTO pibNT_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Kpashiwakapji rukshikyanona pimrine Gasya gajene Goteyone. Kpashiri nixkaaka. Gi wa gixoluneyma, gi wa gejnugimalewanatachineyma rukshiknona. ");
INSERT INTO pibNT_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Wanna gimkata gewi gwaleta pixa yegi jigyegitannona waneyna chininipna gitapiranaya. ");
INSERT INTO pibNT_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Wannako gimkata ginkaklewleta wa pagixanu mpoyagkaakotu retinnona wa jemanshinikankakjetikowaka ntunwanatini. ");
INSERT INTO pibNT_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Walepje getko satu tokanchipje wa nsaplewatinri wanna ganikajite ntunwanatini. Wane nchina, ‘Yotunkakikolupna gipnachinepirana gitni wa giklukanuwnayegjixkalurno xani gixyegiya.’ ” ");
INSERT INTO pibNT_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Giyagni Wilisi yijnakpiranatinitkalu kagwakjixna, gi rixanu rumatpotutlu wanna Pawlo galixlepirana. Wane china, “Wa yopikinipa wa solalone gitsrukate Risya, numatpotutanu gixapirana.” ");
INSERT INTO pibNT_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Giyagni yokanatlu ksolaloteru Pawlo girukotinripa. Kayaagostureko rixatkaluna. Gi wa rumaletkona gimolene rupxakjenepa. ");
INSERT INTO pibNT_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Pagognetnakni runa Wilisi Trosilayma ganunro. Walanwa Goteyo. Pawlo tomga. Yijnakyegitlu galixlu Geso Kristoya. ");
INSERT INTO pibNT_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Poyagkaklupirana ruynumsatlu, ga wa girukotmanrewlupirana, ga wa giklukanuwnayeglupapirana. Pika Wilisi gitsrukaachi. Rugita, “Pyanutka xani. Kagogne nchininipa nepukanyi.” ");
INSERT INTO pibNT_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Kagwaakoxlu Wilisi renekikolupa sroschi Pawlo chinanu kaspukyaplu. Giyagni gi gepiko kata repuklu. Ruynumsatlu. ");
INSERT INTO pibNT_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Gepi walapu giknoginitka, Porsyo Wisto kashrigatkalu Wilisi. Ga wa Wilisi galuka gimutletna Goteyone. Giyagni ruknokamtatkalu gostutkaluru Pawlo. ");
INSERT INTO pibNT_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Giyagni walesreta rapokinitka Wisto. Mapgogne chininitka Susari kanikya. Gerosale rapoka. ");
INSERT INTO pibNT_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Runkakluna tsrukakalune sasertotene ga wa wanna potu Goteyone Pawlopirana. Ragjitluna. ");
INSERT INTO pibNT_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","Ragjitluna rupxakikolupna Pawlo chinanu. Gerosale ranikjixyaplu. Yogimagnaputyatkaluna gatnugapoya ruylatyapluna. ");
INSERT INTO pibNT_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Giyagni Wisto gigita wa Pawlo Susari girukotikaluru, ga wa waleko pshinitsonu yanutka. ");
INSERT INTO pibNT_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Wane china, “Giyagni wa gixa gimkatachine Susari giyopikanu. Gjigyegitanru wa waneya chininipa pagixanu mugletu wa tye jeji.” ");
INSERT INTO pibNT_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Wanna yegi rawanata yokgipgognepje ga wa pamolgogne getko. Yopika. Susari ya. Waleprikgogne gitakyagoklewjetikowaka tuplata. Rawapjixatkalu Pawlo. ");
INSERT INTO pibNT_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Rapokinitka wale, Gerosale giyakatyachine Goteyone sajruklu. Runkaksayempotutluna gektutpotupirana. Gi rumkata gipgujtaletluna galikaka rixinri. ");
INSERT INTO pibNT_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Ruykoyegitnawa Pawlo. Wane china, “Giketsotaji wa Tokanchi Yokanatkaluruko Goteyonenu, gi wa kpashiwakapjiko, gi wa Susako mugletu nkamrutya.” ");
INSERT INTO pibNT_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Wa Wisto galuka gimutletna Goteyone. Giyagni Pawlo rugita. Wane china, “¿Gi ge paluka kanikleta Gerosale? Wane nutakyagokinyi tyekakapirana.” ");
INSERT INTO pibNT_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Wane china Pawlo, “Wa Susa gitakyagoklewjetyawaka ntunwatanu. Wane numkata giglepokletikolupa nutakyagokikolupa. Gikena mugletu nkamrutkamka Goteyone, wa pixa gimatpotutyawaka. ");
INSERT INTO pibNT_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Gi rixanu wa mugletu nkamrutmaka ga wa pagixanu nupninri chinanupa, gi wa nkegemga nma mupninitipmaka. Seyni malesha chinini wa jigyegityanona gikena gimkata samyokletno wannayegi. Napguwyegitlu Susa.” ");
INSERT INTO pibNT_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Giyagni Wisto giynumsatna jemanshinikankakjetikowaka gajene. Rali giynumsaletinitkana, wane china, “¿Papguwyegitluge Susa? Susa yegi pyanu.” ");
INSERT INTO pibNT_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Pagognetnakni pogirchi Gakripa ga wa Wirnisa Susari rapokna. Wisto ralukinripna. ");
INSERT INTO pibNT_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Gixgogne wane rawinitkana, Wisto ginkaklu pogirchi Pawlopirana. Wane china, “Waneru satu jeji Wilisi giknokamtanru gostutkaluru. ");
INSERT INTO pibNT_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Gerosale nyini, tsrukakalune sasertotene ga wa tsrune Goteyone ginkakno walepirana. Ragjiyegitluna ruklukanuwnayegjixikolupa. ");
INSERT INTO pibNT_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","“Wanna nugita, gi wa rixjetyawakna Romanone wa satu yineru samyooko wale ma metgojitkanuwana jigyegitjene wuchichyaplu ruykoyegitinipwa jigyegitikoluya. ");
INSERT INTO pibNT_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Giyagni gewi runinitkana pejnurunemnuni, gi nkagwakjixajitna. Waleprikgogne gitakyagokikowaka ntuplata. Nwapjixlu jeji. ");
INSERT INTO pibNT_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Rapokinitkana jigyegitjene gi satuna jigyeglewlu mugletu ranikna, wa nkagwakanrumka. ");
INSERT INTO pibNT_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Satupjeru waneyna waleya gepomsalewlukaka rupashichanruyna, ga wa satu Gesopirana gipnachrinatka wa Pawlo gipgujtatyalu giwekachri rixinri. ");
INSERT INTO pibNT_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Gita gi numatanshinikanuta wane pixkalutu gepomsalewlupiranaya. Giyagni wane nchinru gikta Gerosale raluka yaleta ruglepokyegitikolupa, rutakyagokikolupa tyepirankaka. ");
INSERT INTO pibNT_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Wa Pawlo gapguwata rumretikolupa Pogirchi Gakosto gimata getjerewatinrigognepotunanuko. Giyagni numretjixlu Susa yegi yokanatkoklunpotunanuko.” ");
INSERT INTO pibNT_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Giyagni Gakripa wane chinru Wisto, “Gita koxa galuka yijnakletlu wale jeji.” Wale wane china, “Yechikawa pyijnakotanru.” ");
INSERT INTO pibNT_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Giyagni waleprikgogne runa Gakripa ga wa Wirnisi koxa. Tsru pogirewlu rumupgujewnana. Jiglokjetikwaka rapokna, solalone gitsrukateneymananuko, ga wa jejine wanna potu pokchi gajene. Wisto gwapjixlu Pawlo. ");
INSERT INTO pibNT_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Wane china Wisto, “Pogirchi Gakripa ga wa pejnurune jejine wixaymalune, getanru tye. Pejnuruneko gixolune Goteyone jigyegitluna gita yegi Gerosaleya ga wa gewi koxa. Wane china saplewjeretna ma muwekinitpatka. ");
INSERT INTO pibNT_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Ga wa gi satuna numata jema rupninri chinanupa, ga wa waleko gapguwyegitlu Gakosto. Giyagni wane nixa gishinikleta yokanatkalurupni. ");
INSERT INTO pibNT_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Gi wanepotuko waneyno walepiranaya nyonyegityaplu wa gitsrukaachi. Giyagni nkoshpaklu gixa yegi. Pixpotuko galikaka, pogirchi Gakripa, wa repomsatkoklunpatka waneyapno tokanchi nyonatanrupa. ");
INSERT INTO pibNT_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Gi rixanu gita goya seproloklunwa gostutkaluru yokanatkoklunchi munkaklewyegitkotuko klu chinanu jigyegitka.” ");
INSERT INTO pibNT_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Giyagni Gakripa wane chinru Pawlo, “Pumkata ginkakleyegitnawa.” Giyagni Pawlo yotukamyota. Ruykoyegitnawa, ");
INSERT INTO pibNT_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“Pogirchi Gakripa, npoyagnutlu wa pixyegiya nuykoyegitinwa xani ptowrukopirana wa Goteyone jigyegityano. ");
INSERT INTO pibNT_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Galikakakni. Gi rixanu pixni wa Goteyone gixjetyawaka ga wa repomsalewlekakna gimatachriyi. Giyagni nagjityi mapognanutupyi pyijnakotyapno. ");
INSERT INTO pibNT_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","“Gi rixanu nmaklutinyakawa nixjetyawaka muchikawayakawa nonerunetskalaya ga wa Gerosaleya, pejnurune Goteyone gimata. ");
INSERT INTO pibNT_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Muchikawayakawa rumatnona wanna, wa raluka gipgujtaletinipmaknona, wa wanepotuko gixa yonogletachine wixanune mkoje pixkalutunanno Gwariseyonanno. ");
INSERT INTO pibNT_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Ga wa xani kagwakikolu chinanu Goyakalu gipiratanru wutsrukatenniya nutunwata nutakyagokikolu. ");
INSERT INTO pibNT_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Wale kagwakikolu kagwaka gapkapletna wpamolegepinerutene, Goyakalu kamrurewyempotutachine gogi ga wa goyechno. Wale kagwakikolu chinanu Goteyone jigyegitno, Pogirchi Gakripa. ");
INSERT INTO pibNT_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","¡Gaa! ¿Gixa goya gayroklurge gixkaklukoya wa Goyakalu yotunkakanna gipnachine? ");
INSERT INTO pibNT_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","“Giyagni gita galikaka gishinikanuwtapa numkata kamrureta gixo nkamnixyaplu giwaka Nasare Gajeru Geso. ");
INSERT INTO pibNT_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Tye nkamrutapa Gerosaleya. Gitaakalurunanno tsrukakalune sasertoteneya. Yoshmakikwaka nushyayegityana gixo kpashirine. Ruylatkoklunutkana, nugita gita. ");
INSERT INTO pibNT_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Gi gepiko kata pejnuruko ginkaklewawakapjikakaya nsaletjetyana. Psolmuchkonuko nertatna mupashiregnuchi chininripmakna. Gimtuwnananumtachripotno wanna chinanu. Nkojwakananumtna pasreta gajerkaka pokchipotunanuko. ");
INSERT INTO pibNT_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","“Wane nixananumtini, Tamasko nyinitka. Nutaaka ga wa waneyno kiruka nyokanatikolu tsrukakalune sasertoteneya. ");
INSERT INTO pibNT_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Pogirchi, ganikajgognetkani gatnugapo netyalu tengogne gajeru yochigatachri, tkachi gatajnu pnute. Ratajiwnayegitwu gita ga wa numotsane. ");
INSERT INTO pibNT_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Giyagni chiji wapokana pejnurunnikwu wixni. Satu tokanchi nyijnakota Gewreyone tokanuya nuynumatjeru. Wane china, ‘Sawolo, Sawolo, ¿klu chinanu pkojwakno? Pixnanniko kachinolu pixnanwa pakaxjerewatana yowumajri pixka.’ ");
INSERT INTO pibNT_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","“Wane nchina, ‘¿Katyi Pixa, Gitsrukaachi?’ “Wane china Gitsrukaachi, ‘Gitni Geso wa pixa kojwakanruno. ");
INSERT INTO pibNT_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Seyni palnanutka. Ptunwatanu. Gi rixanu tye chinanu nupgujewnayegityi nutakyapyi notowrerupyi ga wa gipgujtalewatachripyi petanrukakapirana ga wa nupgujewnayegityapyipirana. ");
INSERT INTO pibNT_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Nkoshpakanyi yinyegiya ga wa payinyegiya, wa wanna yegi nyokanatanyi. ");
INSERT INTO pibNT_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","Rumrekgakakikolupna panene, ruprotakinripna, mapshagwaka rushpakinripna. Pokamlawaka yigatinripna; Satanasyo girukotlewatyawaka rushpakinripna; Goyakalu yegi yigatinripna; kaspukmukochiretikolupna, ga wa waneya rixinripna kpashirine gixkakaluneyma, gi rixanu ralixnona Gita.’ ");
INSERT INTO pibNT_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","“Giyagni, pogirchi Gakripa, gita gi wa malixkatno wa Goyakalu gekakgityano. ");
INSERT INTO pibNT_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Seyni wa Tamasko gwanatachine gapka, ga wa Gerosale gajene, ga wa psolusretako Gote gajene, ga wa payineko nunkaklewyegita renshinikanutinripna. Kashrijetikolupna Goyakalunune rixinripna, genshinikanutachine kamrure pixkapotuko kamrutinripna. ");
INSERT INTO pibNT_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Wale chinanu Goteyone kashichno kpashiwakapjiya. Ruylatmaknona. ");
INSERT INTO pibNT_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Giyagni Goyakalu gipxakalchinanno, xanigognenanu nomkagi gipgujtalewleyegitna mturune ga wa tsrune. Gikena nchina wanepnute. Tyepjeni tokanchi geneklewatachine chinyawaka ga wa Moysisi chinyawaka ginachripa. ");
INSERT INTO pibNT_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Tokanchi ginkakletachine ginkakletlu wa Kristo salewninripa. Walenwa muchinanu gapka yotunotachripa gipnachinetskalaya, yine yegi runkakletyaplu pokamlalu ga wa payinyegiya.” ");
INSERT INTO pibNT_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Wane china giykoyegletnawa. Giyagni Wisto tsru tokanu rixnawa. Wane china, “Seproluktayi, Pawlo. Gi gepika Tokanchi Yonatkaluru pumatinri seprolookakyi.” ");
INSERT INTO pibNT_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Wane china Pawlo, “Gi wa seproluno, kshinikanuru Wisto, seyni tokanchi galikakpotunanu kanshinikanuru nyanumatya. ");
INSERT INTO pibNT_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Gi rixanu, Pogirchi, pumatlu tyekakapirana. Pixa getanu koxa nyanumsata pgujetanwaka. Gi rixanu gi nkagwaklu yogimatika wale. Gi rixanu gi wa kegnete kamrutikalurni wa tye. ");
INSERT INTO pibNT_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Pogirchi Gakripa, ¿gi ge palixna tokanchi geneklewatachine? Numatyi palixinri.” ");
INSERT INTO pibNT_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Giyagni Gakripa wane chinru Pawlo, “Ptsotsotaji magata pushinikanutyano Kristonu nixinripa.” ");
INSERT INTO pibNT_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Wane china Pawlo, “Nagjitlu Goyakalu wa ptsotsotajiyako ga wa gixpotuyako pixa ga wa pejnuruneko nyijnakotjene wa xani, gitako pixka gixachinetkani, seyni tye gosturutsapje gi waneyapgi.” ");
INSERT INTO pibNT_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Rali wane chinretinitka Pawlo tyepirana, Pogirchi palnatka, ga wa gitsrukaachi, ga wa Wirnisa, ga wa wannayma tuplanatachine. ");
INSERT INTO pibNT_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Wa ruxrikamtinitkana, wannakakluko wane chinkakna, “Gi satuna kamruta tye jeji rupninri chinanupa, gi wa rostutikolupako.” ");
INSERT INTO pibNT_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Giyagni Gakripa wane chinru Wisto, “Tye jeji gimkata kaspukletkamka ma mapguwyegitkanumkalu Susa.” ");
INSERT INTO pibNT_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Giyagni wa rutaaka wyagapgatinripatka, Gitalya gayinripatka. Ksolaloteru Golyo giwakatletachri, Gakosto solalotene yegi gwachri, samyokatkaluna Pawlo, ga wa pimrine gostutkalune waleyma. ");
INSERT INTO pibNT_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Giyagni watskotatkalo sato tsro kanawa potu Gatromentina giyakatyachro. Gasya pokchikaka galuka yaletachro. Wutspegatka. Wixaymalu Garistarcho, Tesalonika, Masetonyasreta gajeru. ");
INSERT INTO pibNT_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Waleprika Sito wutspakatka. Golyo kigle getle rixlu Pawlo. Ruchi yaletlu, ralukanune yegi yinripa, rupxakyapluna. ");
INSERT INTO pibNT_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Wane wutspegyatka. Suproknipreka tukasretate gayapamta. Gi rixanu kannipgyalu gakaxrikamtwu. ");
INSERT INTO pibNT_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Surisya Wenne ga wa Pampiri Wenne gayapamtatka. Mira wapoka Lisyasreta pokchi. ");
INSERT INTO pibNT_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Ksolaloteru wane gikshikyalo sato tsro kanawa potu Galegantri giyakatyachro, Gitalya yachropa. Wala pokotwu. ");
INSERT INTO pibNT_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Gi gepikgogne wyagapgata yiglepotuko. Wixasha gapokleta Knito ginaple. Gi kaspukapanwu kannipgyalu. Kretatlapga wyapamta Salmostsi. ");
INSERT INTO pibNT_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Kyapre potu gayinri. Wapoklu Kigleru Yopjewaka chinikowaka. Wane gi gowukaylu Lase Pokchi. ");
INSERT INTO pibNT_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Gi gepikgogne wuknokakatka. Kyowiklu yagapgalu, gi rixanu ruknogatka wa gogajirewlugogne. Pawlo giykotna. ");
INSERT INTO pibNT_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","Wane chinna, “Jejine, netlu tye yagapgalu waneplu tsru gimtuklupa ga wa tsru gamgalupa, gi wa wunruchipjeni ga wa kanawa koxa, seyni wuwekinriko koxa.” ");
INSERT INTO pibNT_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Ga wa ksolaloteru galixna kanawa ganikachri tokanu ga wa kanawateru, wa Pawlo chinyawaka pnute. ");
INSERT INTO pibNT_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Gi kiglepokyopjewakleru wuknokakyaplu ginapu. Gixo gishinika yaleta waneya, gikta rumkata gapokletluna Winisi, wane wuknokakyaplu ginapu, Kretakniprekla yopjewakle, tkachi kegnetesretateswaji ga wa potuklesretateswaji giyakatyachrinnipgya gapokannipgyajetyawaka. ");
INSERT INTO pibNT_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Tkachi kegnetesretate ruyakannipgyatya. Yiglepotuko rajpopokannipgyata. Kagwakluna waneyatkana wa rushinikanruyna. Kosetatkaluna tsataprena. Kretakniprekawnaga yana. ");
INSERT INTO pibNT_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Gowukshini rapyegitlo kannipgyalu jiweylunnipgya pixkalutu, Geroklito giwakannipgyani. ");
INSERT INTO pibNT_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Tushatkapka kanawa. Gi tumkata yoptoretlu kannipgyalu. Wetashatatkalo. Gayashatatka. ");
INSERT INTO pibNT_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Satu mturu kanipreklu, Klawta giwakatletachri, wuknogamta. Wixasha gimkatle gishatkapletlo mturo kanawa pokotkaluro. ");
INSERT INTO pibNT_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Wala ranikinitkana. Wane rixa gigleretanutkalona tsro kanawa. Rapatlona. Surtesloji pika gapokletna. Jijrukluna mkachrichrata. Wane wixa gayashletatka. ");
INSERT INTO pibNT_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Giyagni wyowjeyempotutana. Waleprika ruknopjegawunnutanatkana. ");
INSERT INTO pibNT_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Waleprika potu wumyoypotuko wuknokgachratatyatkalu kanawa yaninri. ");
INSERT INTO pibNT_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Gixgogne gi pgujru tkachi, gi katagiriko. Wunnewgognenatana. Gike kagwaakatka wanepnute wushatkapikolupa. ");
INSERT INTO pibNT_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Gixgogne wogajirewatanatka. Giyagni Pawlo wanna ganikajite tunwata. Wane china, “Jejine, galikaka gixa gimkata galixletkamkano. Gimka Kreta wutspeginnichi, ma munyegitkanimkawu tye gimtuklu ga wa gamgalu. ");
INSERT INTO pibNT_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Ga wa xani nuykotgi kiglenshinikanupgi. Gi rixanu gi satuna gixa gamgagiwekletanu. Seyni kanawapje gamganu. ");
INSERT INTO pibNT_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Gi rixanu tyeyechnoni gita yegi rapoka Goyakalutowreru. Wa Walenno gita. Wale nkamrurewyegita. ");
INSERT INTO pibNT_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","Wane china, ‘Pawlo, gi pikanutka. Susa yegi pumkata gapokletinripa. Ga wa Goyakalu genekyi pejnuruneko puyagapgatanune.’ ");
INSERT INTO pibNT_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Giyagni, jejine, kiglenshinikanupgi. Gi rixanu gita galixlu Goyakalu, wanepotuko rixanu wa chinyawakno. ");
INSERT INTO pibNT_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Seyni wumkata satu kanipreklu gitaakota.” ");
INSERT INTO pibNT_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Pamole gepkoxamkojyechno chininri, Gatriyakoskitgatlapa gayashatanatka. Ganikajyechno kanawa ganikachine kagwaklu gi gowukatkalu chiji. ");
INSERT INTO pibNT_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Yantagatluna. Gepkoxamkojmolekano rukshikyaluna tennuga. Wanepnuteyaka yana. Rumepe yagotgaletatnakna. Mapmole patsrujire metro tennuga rukshikyatkaluna. ");
INSERT INTO pibNT_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Wanna piklu sotlu gwiywaka wyoxgiyegitinripa. Giyagni tostsi ruknokgatluna gepkoxamkoje tsataprena. Ragjigognetna rumrerekinripa. ");
INSERT INTO pibNT_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Giyagni tsro kanawamka rasukyamkana ganikachine. Jijrukgatatkalona kanawa mturo. Wala pguta rapgutanatna jijrukgatyapluna wa tojri gajeru tsataprena. ");
INSERT INTO pibNT_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Pawlo wane chinru ksolaloteru ga wa solalone “Tsro kanawa ma mutukinna wanna, gixa gi gimkata gishatkapkotanu.” ");
INSERT INTO pibNT_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Giyagni solalone gistakatsatatkalona mturo kanawa. Retasha gijrukletatkalona. ");
INSERT INTO pibNT_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Pawlo nikjixatkana pejnuruneko rumrerekastsipotunanuko. Wane china, “Pamole gepkoxamkojgognetkani tye gkagwakanata gogajirewatinri. Giketsotaji gnika. ");
INSERT INTO pibNT_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Giyagni nuykotgi gnikanutka. Gi rixanu tyenwa giwekinripa. Gi rixanu gi pajiwutsana gamgini pejnurunekgi gixa.” ");
INSERT INTO pibNT_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Wane chininitka, rawlo jimapro. Poyagnutlu Goyakalu pejnurune getanu. Jiknajrotlu. Yinuwaka nikletatkalu. ");
INSERT INTO pibNT_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Giyagni pejnuruneko kiglenshinikanutka. Niikoxatkana wanna. ");
INSERT INTO pibNT_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Wane pejnuwu tsro kanawa, gepi pacha payokgipremole patsrujire. ");
INSERT INTO pibNT_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Jinanutkana. Komlikayakatatkalona kanawa. Tsru wenu ruknokanatkaluna trikoji. ");
INSERT INTO pibNT_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Gogi rixinitka gi wa rumatluna chiji, seyni retluna ratlogkapyawaka. Kaksatewnaglu. Wane rushinika gitspaakakletlona kanawa rumkatiniplona. ");
INSERT INTO pibNT_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Koshpirokatsatatkaluna tsatapre. Tsru wenu kaspukatkaluna. Waneklu koxa kogrokatsatatkaluna potukatapretsna. Romukluna mkachrichrata teno gajeru kannipgyalu yegi. Wangasreta ya kownokletatkalona. ");
INSERT INTO pibNT_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Giskitga ganikajite, taschekatka kanawa. Taschekajritanatka. Gi tuyoljetatka. Ga wa tostsi tutspatgastsityatka gichkogalu chinanu. ");
INSERT INTO pibNT_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Giyagni solalone gishiniklu ruylatikolupna gostutkalune, gikena ma masuukanpakni ganogatachri. ");
INSERT INTO pibNT_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Seyni ksolaloteru galuka gognetkakletlu Pawlo. Rumaltayegitlu wanna gishinikle. Wale yokanatatkana gimkata ganogletachine muchinanu gapka ruptekgamtinripatkana, chiji rapokinripna. ");
INSERT INTO pibNT_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Ga wa gixetachine, pimrineko kanawashpata, ga wa pimrineko klunerukokta kanawa gajeru, yiyatkana. Wane rixkatka pejnuruneko chiji gapoka. Rognewatatkana. ");
INSERT INTO pibNT_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Wognewatinitka. Giyagni wumatatkalu kaniprekluni. Melita giwakni. ");
INSERT INTO pibNT_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Ga wa patokanchiko yanumatyachine retwamonpotutwuna. Pawatatkana. Kigle yoptole rixwuna pejnurunekwu gina chinanutka ga wa kachikleru chinanu. ");
INSERT INTO pibNT_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Giyagni rapatjepluta Pawlo. Xirnachri gogo rutaklu. Satu gimnu chichi gemnu rasukya. Saprikamyomtanru. ");
INSERT INTO pibNT_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Patokanchiko yanumatyachine getinri gimnu ruxripamyonatlu, wane chinkakna, “Tye jeji galikakni kgiylalewaklerni. Tsru wenu rognewatyani, seyni kgiklukanuwnalu chinanu gi retashatka ruwekinripa.” ");
INSERT INTO pibNT_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Giyagni wale giwlipatlu gimnu. Xirnachri rapokamtana. Giketsotaji yayixya. ");
INSERT INTO pibNT_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Kagwaka gankaletmakluna, ga wa walegnapunanu yawnamtinripa gipnachri. Seyni gowukshini potu kagwakinitkana, retluna wa gike giknoglu. Kashrijetanshinikanutna. Goyakaluktani chinruna. ");
INSERT INTO pibNT_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Waneru kachijneru, kanipreklu gitsrukate. Poplyo giwakatletachri. Kigle yoptole rixwu. Mapgogne gipji rutakwu. Rushinikanuwyegitwu. ");
INSERT INTO pibNT_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Wane rixatka. Poplyo giru yayixachrina. Pachwatana ga wa tserugatana, giklugachrina. Pawlo jiglokyegitlu. Ragjigogneta. Rutakamyogogotlu. Rutuukaklu. ");
INSERT INTO pibNT_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Wane rixinitka, pimrine koxa kanipreklu gwachine, yayixachine ginyegitlu. Rutuukaakana. ");
INSERT INTO pibNT_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Gixo renekashatwuna kagwakpiratyachinanwuna. Wutspeginpatka pokotyawuna walukanru. ");
INSERT INTO pibNT_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Mapa ksuru giknoginitka, sato kanawa Galegantrina giyakatyachro wutspegyatka, waneknipreka giknokakginaputetyachro. Wala waneya tumatikolu Gopite wgenene gepirune yaglu. ");
INSERT INTO pibNT_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Surakosa wapoka. Mapgogne wane wutuka. ");
INSERT INTO pibNT_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Waneya wsajruka. Wapokatkalu Rigyo. Waleprika tkachi kegnetesretate ruyakannipgyatya. Waleprika potu wapoklu Potewolo. ");
INSERT INTO pibNT_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Wane wukshikyana moletkakachine. Ragjitwuna payokgipregogne wumwiyapna. Wane wixa yaleta Roma. ");
INSERT INTO pibNT_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Wane gajene moletkakachine yijnakyegitinitkawu, yoptotapwuna. Gapyoputu Pokchipotunanuko ga wa Mapa Gwajetikwaka Pokchi rapokna. Pawlo getinitkana, Goyakalu poyagnuta. Kiglenshinikanutkalu. ");
INSERT INTO pibNT_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Roma wapokatka. Ksolaloteru gostutkalune samyokatkalu solalonepji gitsrukate. Ga wa ruchichka Pawlo waleko rawyawaka rawinripa, satu solaloyma girukotjerupa. ");
INSERT INTO pibNT_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Wane rixatka. Mapgogne giknoginitka, Pawlo gapatjixna tsrukakalune Goteyone. Rapatinitkana wane chinna, “Jejine, nomolene, gikeyaka nkamruyegitna yine. Gi wa wuneruneko gixjetyawaka nkotnuka. ");
INSERT INTO pibNT_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Seyni Gerosale nsamyokika gostutkalurno Romanonemyoya. Wanna gitakyagokinno, raluka kaspukletnona, gi rixanu maleshayno nuklukanuwnale nupninri chinanupa. ");
INSERT INTO pibNT_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Ga wa Goteyone yoptopiratno. Giyagni nerutka Susa napguwyegitinripa. Gi wa waneyno njigyegityapna nonerune. ");
INSERT INTO pibNT_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Giyagni tye chinanu nepukgi netyapgi ga wa nuynumsatyapgi. Gi rixanu Gisrayiline kagwakle chinanu gostutkalurno tye yowumatsaya.” ");
INSERT INTO pibNT_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Giyagni wane chinruna, “Gi Gote giyakatyachrotsotaji kiruka wyoptoyegityi. Gi satuna wane giyakatya wumole runkakletpiranyegityapyi, mugletu chinpiranyegityapyi. ");
INSERT INTO pibNT_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Walukmaka yijnakyegletyi pchinanshinikanutyawaka. Gi rixanu wixa gimatlu psolusretayako nyi pnuko gixa galixletachine mkoje gapatkalunni.” ");
INSERT INTO pibNT_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Pagogne rutakna. Gi gepika wanna yayegitlu rawyawaka. Runkakpokowakatna. Wanna yegi rupgujtatlu Goyakalu pogirewatyawakapirana. Rushinikanutna Gesopiranaya Moysisi Tokanu Yokanatkaluruya, ga wa tokanchi geneklewatachine kirukateya, goyechnokawpotuko wa kaypotunanuko. ");
INSERT INTO pibNT_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Giyagni pimrine gishinikanutka chinyawaka chinanu, ga wa pimrine gi galixa. ");
INSERT INTO pibNT_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Gi wa panshinikanurunni wannakakluko. Giyagni ralimtatkana. Pawlo wane china tye tokanchi, “Kigle yanumle rixa Giwekikaluru Kpashiri, tokanchi geneklewatachri Gisayiyaya. Wane chinna wutsrukatenni: ");
INSERT INTO pibNT_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","Nyi yine yegi pyanutka. Wane pchinanu: Gijnakopna gyijnakotini, gi gimata jemanuna. Getini getinmaka, gi gimata getanuna. ");
INSERT INTO pibNT_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Gi rixanu shikowgajitatkana nyi yine. Ga wa gijnakopnayna kyapreru yijnakotyana Ga wa rushyaygaletna. Giygalna ma metinitipna. Gi wa gijnakopnayna yijnakotinripna. Gi rajiyakna rumata jemyana, ma kashrijetikotupna, nma mutuukakyanupna. ");
INSERT INTO pibNT_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","Giyagni gixa gimatanru payineko yokanyegitkatka tye gognetkaklewlu Goyakalunu. Wanna yijnakotanru.” ");
INSERT INTO pibNT_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","Wane chininitka, Goteyone yatka. Repomsakakpotna. ");
INSERT INTO pibNT_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Giyagni Pawlo gepi walapu psolwalapuko gipji wenutkalurupji rawa. Yoptotna pejnuruneko runyegitjene. ");
INSERT INTO pibNT_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Goyakalu pogirewatyawakapirana runkakleta. Pgujetanwaka china ginkakletna Gitsrukaachi Geso Kristopirana. Gike gimaletlu.");
INSERT INTO pibNT_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Gitni Geso Kristo wayegrerno Pawlono, tomgakalurno yokanatanrupa, nutakikolupa Kiglerpotunanu Goyakalu Tokanu chinanu. ");
INSERT INTO pibNT_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","Tye tokanchinwa muchikawa rupiratanru tokanchi geneklewatachineya Goyakalunu, kpashiri yonchiya. ");
INSERT INTO pibNT_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","Tye tokanchinwa Giturupiranni. Walenwa Tawiklopisha gimaneya. ");
INSERT INTO pibNT_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","Walenwa gipgujetkaluru Goyakalu Wgene rixinri muchkonuyma. Gipgujetkaluru Giwekikaluru Kpashirpotuya, wa gipnachinetskalaya yotunomtyachritka wa Geso Kristo Wutsrukate. ");
INSERT INTO pibNT_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Geso gimutlewle chinanu yokanatanru nutakikolu, ralixyapluna Wale tokanu ptowruneko pachijnemnunanuka gajene wa giwakaya. ");
INSERT INTO pibNT_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","Wanna galixachinemkojenangi gixa. Geso Kristo tomganungi, ");
INSERT INTO pibNT_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","wa pejnurunekgi Roma gwachingi. Goyakalu galukanungi, tomgakalungi, kpashirinepgi, gimutkalunepgi gixa. Wa Goyakalu Wuru, Wutsrukate koxa Geso Kristo giglenshinikankakangi ga wa rumutangi. ");
INSERT INTO pibNT_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Muchinanu npoyagnutlu Noyakalute, Geso Kristoya pejnurunekgi gixa chinanu, wa gixa galixle psolchijneko pogitikolutka. ");
INSERT INTO pibNT_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Goyakalni nkamrurewyegitanru nonshinikanuya Kiglerpotunanu Tokanchi Giturunu. Walenwa netjeru, gi nutuka gishinikletgi wa gixa nagjigogneyeegognenatgi. ");
INSERT INTO pibNT_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","Nagjitlu patako waneplu pagogne, Goyakalu galukiniplu, kigleru yagapgalu gixa yegi nyinripa. ");
INSERT INTO pibNT_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","Gi rixanu gita galuka getlepotutgi wa nkotspaltayegityapgi Goyakalu genekashle Giwekikaluruya gmuchkotanshinikanutjerupa. ");
INSERT INTO pibNT_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","Walenwa wugleretanshinikanutikolupa gixaymananuko satkaka galixleya, gixanni wa gitanu koxa. ");
INSERT INTO pibNT_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Seyni gi naluklu, nomolene, gma mumatyanru, wa gixo katmaka wane nushinika gixa yegi nyinripa, seyni xanigognenanu wane nixa gimaletletkota. Naluklu wa gixatskalaya koxa waneyapno nkamrutanrupa, payinetskalaya pixka. ");
INSERT INTO pibNT_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Nriwishkatna Kriykone, kgimtokanurune koxa, wanepnute kgimatkalerune ga wa mumatkalene. ");
INSERT INTO pibNT_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Giyagkoxni gita pejnuruko numkatyawaka naluklu ginkaklewyegityapgi Kiglerpotunanu Tokanchi wa gixa koxa Roma gajengi. ");
INSERT INTO pibNT_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Gi rixanu gi nupatewatlu gita Kiglerpotunanu Tokanchi. Gi rixanu walenwa Goyakalu giyaklewle wa gognewatikaluru chinanu, pejnuruneko galixachine chinanu, wa Goteyone gapka chinanu, ga wa Kriykone koxa chinanu. ");
INSERT INTO pibNT_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Gi rixanu Kiglerpotunanu Tokanchi gekakgitlu Goyakalu poyagkaklewle yineru galixle chinanu. Ga wa pnuteyaka galixlu waneyaplu, Yonchi chinyawaka: Wa poyagkakachri giwekanu ralixleya chinanu. ");
INSERT INTO pibNT_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Pgujetanurni Goyakalu jgekanu tengogneya ptowruko makagwakpireyna, ma poyagkaklenuyna wanna yine chinanu wa rumretanruna galikakpotunanu tokanchi mpoyagkaakane rixinrina. ");
INSERT INTO pibNT_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","Gi rixanu wa Goyakaluya gimatikolutka wanna koxa gipgujetyegitka. Gi rixanu wa Goyakalu gipgujetlu. ");
INSERT INTO pibNT_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Gi rixanu wa mpogijetkaka wa Goyakalunu, walenwa gike rixiniko mnikawnakatu ruyakle, wa Goyakalu rixinri. Mpogijetkaka pgujetanru wa ruyakotiniyakawlu wa tye psolchijneko. Gimata jemkalurni wa kamrutkalurkaka chinanu. Giyagni wannako chinanupni, wanna mpoyagkaakane. ");
INSERT INTO pibNT_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","Gi rixanu rumatmakluna Goyakalu, gi rupashichluna Goyakalu rixinri. Gi koxa poyagnutluna, seyni maleshawaka nutanshinikanutna. Manshinikanugajine mapshaga rixgajitkana. ");
INSERT INTO pibNT_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Kgimatkalerune rixashatnawana. Seprolokanatkana. ");
INSERT INTO pibNT_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","Royaknu Goyakalu mpojpakatu rupekotluna yagluchi yineru pojpakalu pixkalutu, ga wa kamejirune pixkalutu, ga wa nikchine gepkoxamkojejixirune pixkalutu, ga wa gistako yosrolotyachrikaka ixkalutu. ");
INSERT INTO pibNT_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Giyagkoxni wa Goyakalu samyokna puchowninripatkana sotanugnuchi rajiyna, mpashmanene rixkakinripna wannakakluko. ");
INSERT INTO pibNT_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","Wanna gipekotlu galikakpotunanu tokanchi Goyakalunu gayroklu chinanu. Yonogyegitluna, giyakotkalunkaka wa Kgiyaklewakleru pnute. Walenwa gimalwugognenatkalurupa gike rixiniko mnikawnakatupa. Wane gixkalurupa. ");
INSERT INTO pibNT_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","Giyagni wa Goyakalu samyokna wa sotanugnuchi kapatmenuru waneyapna. Gi rixanu wa suxnena kashrijetluna rixjetyawakna rumumturetanruna wa ma mixyawakanna gimumturetkaluru. ");
INSERT INTO pibNT_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","Waneko pixka koxa rixna wa jejine. Ruknokluna rixjetyawakna rumumturetanruna wa suxoneya. Tsru sotanugnuchi rixna wa wannakakluko. Wane rixa mapatmennuchi kamrutna wa jejine jejinkakluko. Gimanekoyna saletikolupna rapnutikolupna pupjeyeginatanrunako pixkalutu. ");
INSERT INTO pibNT_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Gi wa rugleretluna rumatpotutyapluna Goyakalu. Waneko pixka Goyakalu samyokna satu shinikanchi mugletuya, wa kamrutyapluna maluukotu. ");
INSERT INTO pibNT_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","Ptowruko mpoyagkaknuchi, muglenchi, gimkapnuglu, gektutu gwagajpotutanunni. Ga wa wanepnute waneyna ranxalna, ruylalewlena, yoptopirkakleyna, yokwireyna, ma nshinikannuyna. Gixaxatachinni. ");
INSERT INTO pibNT_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","Kapataklerune, Goyakalu kamnixachinni, kgektutetaklerune, galixkotnachinwa, tsru gixashatnachinewa, gektutu koshpakachine, kaaligiruklerune. ");
INSERT INTO pibNT_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","Manshinikanune, mpoyagkaakane, rumumtureta galuklewle mixkane, maluka gishinikanuwyeglekaakane, metwamonrene. ");
INSERT INTO pibNT_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","Rumata jemanrukmaknina Goyakalu gitakanru, wa wale pejnuka kamrutachine poyagkakluna wa rupninripna. Gi wa walepje kamrutna, seyni rugleretluna pimrine koxa waneko pixka kamrutinripna. ");
INSERT INTO pibNT_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","Giyagni pixako pchinanupni, yineru, girukoktayi pixini wa ruklukanuwna pchinyegitlu satu. Gi rixanu wa klunerukokta ruklukanuwna pchinyegitlu, pukluknanwa pixnanniko. Gi rixanu waneko pixkalutunyi pixni, wa pixa wane china ruklukanuwninripa. ");
INSERT INTO pibNT_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","Seyni wumatlu wanepotuko ruklukanuwnayegjixanna Goyakalu wale pejnunanuka kamrutachinepni. ");
INSERT INTO pibNT_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","¿Gi ge pushiniklu pixa, yineryi, ruklukanuwnana pchinyegitna tyekaka kamrutachine, pkamrutlu waneko pixkalutu: pixlege kaspuwnanu wa giklukanuwnalupa Goyakaluya? ");
INSERT INTO pibNT_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","¿Peyikluge pixa wa Goyakalu makotkotu rumutlewle, tsru pogirewlu potu shinikannuya, ga wa rakotanshinikanrewle? ¿Gi putakyagoklu walekni, wa Goyakalu kosekanshinikanutyi penshinikanutinripa? ");
INSERT INTO pibNT_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Seyni pshiknugajiya, wa paji gi penshinikanutya, pumretanru pixanpako jgekanchi walegognepa jgekanchigogneklupa, rupgujewninrigognepa wa Goyakalu wanepotuko gitakyagoklewatinipa. ");
INSERT INTO pibNT_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","Wale gapnutanru satkaka rixpoko kamruretyawaka. ");
INSERT INTO pibNT_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","Kashnantakgognenatachine kigleru kamrutna, rujgaluna yochiglu, kagwakpiiru, mpojpaknuchi, Wale rapnutinna wanna ruwekinripna gike rixiniko mnikawnakatu. ");
INSERT INTO pibNT_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","Seyni kgimkapnugaklerune, gi wa ralixluna wa galikakpotunanu, seyni ralixluna wa mpoyagkaknuchi, Wale rapnutinna wannapni jgekanchi wanepnute gimtuwakchi. ");
INSERT INTO pibNT_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","Salewakchi, kachinolu koxa psolpotuko yineru giwekachri chinanu wa gektutu kamrukleru, wa Goteyonepni muchichachripa, ga wa Kriykonkoxapni. ");
INSERT INTO pibNT_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","Seyni pogirewlu, kagwakpiiru, giglewanshinikanru kigleru kamrutachinepa, muchinanu Goteyonupa, Kriykonekoxapni. ");
INSERT INTO pibNT_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","Gi wa manewle giglenu chinanu yoptotanru Goyakalu wa yineru. ");
INSERT INTO pibNT_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","Gi rixanu ptowruneko waneyamigjene Tokanchi Yokanatkaluru mukochirewatachine, Tokanchi Yokanatkaluru waneyamigjene koxa ramganna. Ga wa ptowruneko Tokanchi Yokanatkaluruya mukochirewatachine ruklukanuwnanna Tokanchi Yokanatkaluruya. ");
INSERT INTO pibNT_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","Gi rixanu gi wa poyagkakachine Goyakalu getanuya wa yijnakoshatachine, seyni Tokanchi Yokanatkaluru kamruklerune muklukanuwnakaakonetkani. ");
INSERT INTO pibNT_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","Gi rixanu wa payine gi waneyna Tokanchi Yokanatkaluru, rumumturetanruna kamrutluna wa Yokanatkaluru Tokanchiya, wanna Tokanchi Yokanatkaluru waneyamigjene, seynimka waneyna Tokanchi Yokanatkaluru wannayako. ");
INSERT INTO pibNT_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","Rekakgitluna wa Tokanchi Yokanatkaluru kamrurepa kayongalutkani rajiyna. Rupgujtanshinikanutnawana. Wanekopshini jigyegitnawana rushinikanuwnaleyna. Rapgutkakna panshinikanu wa satunshinikanu. ");
INSERT INTO pibNT_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","Wane rixanu walegognepa wa Geso Kristoya Goyakalu gitakyagokanru yine yogimatanru, wa chinyawaka Kiglerpotunanu Tokanchi gita ginkakletanru. ");
INSERT INTO pibNT_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","Petanu, pixni Goteyo chinnachriwayi, wa Tokanchi Yokanatkaluru munangachriyi. Ptserpiranatnawa Goyakaluya. ");
INSERT INTO pibNT_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","Pixa gimatlu Goyakalu gishinikanru, pumata getanru wa kiglerpotu. Yimaakaluryi Tokanchi Yokanatkaluruya. ");
INSERT INTO pibNT_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","Paponshinikanutnawa wa pixni wa maygalene kosekachriyi; pixni wa pokamlalyi mapshagawaka gwachineya. ");
INSERT INTO pibNT_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","Pyimakjetna manshinikanune. Mturune yimakachriyi. Waneyyi gimatkalewlu psoluko ga wa psoluko galikakpotunanu Tokanchi Yokanatkaluru. ");
INSERT INTO pibNT_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","Giyagni pixa koxa wa satu yineru yimakachriyi pixinipa, ¿gi ge pyimaknawa pixnanuko koxa? Pixa wa ginkaklewatachriyi ma chowguwatikotupa, seyni ¿pchowguwatawa pixa? ");
INSERT INTO pibNT_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","Pixa wane chinachriyi ma mumopatlewatikotupa, ¿pumopatlewatge pixako? Pixni wa yagluchkaka getnanutachriyi ¿mupashiregotyi? ");
INSERT INTO pibNT_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","Tserpiranatnachriwayi wa Yokanatkaluru Tokanchiya. Pma kamrutkalchinanu wa Tokanchi Yokanatkaluru, ¿gi ge pma mupashichyanru wa Goyakalu waka gike? ");
INSERT INTO pibNT_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","Gi rixanu mupashichkotu gixkaklu Goyakalu giwaka payinetskalaya, chinyawaka wa yonchi. ");
INSERT INTO pibNT_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","Gi rixanu sajruka gistaklewlu gipxaklewata galikakpotunanni, pkamrutiniplu wa Yokanatkaluru Tokanchi. Seyni pkaspukiniplu wa Tokanchi Yokanatkaluru, wa pixa sajruka gistakikolu kamrutka masajruka gistakikotpatka. ");
INSERT INTO pibNT_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","Giyagni wa msajruka gistakletkotu kamrutyaplu Tokanchi Yokanatkaluru chinyawaka, ¿gi ge wale ma sajruka gistakletkoklunu gitaako sajruka gistakletikolu chinanu? ");
INSERT INTO pibNT_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","Girukta wa mumumture sajruka gistakletkotu seyni kamrupotutlu wa Tokanchi Yokanatkaluru, wale giklukanuwnakakanyi pixa kapiranyegirutkayi, ga wa sajruka gistakletkaluryi, seyni pkaspukinri wa Tokanchi Yokanatkaluru. ");
INSERT INTO pibNT_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","Gi rixanu gi wa Goteyni, wa wane rixa gipgujewnaletachrini, gi waleni koxa wa sajruka gistaklewlu gipgujewnalu wa manchiya. ");
INSERT INTO pibNT_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","Seyni Goteyni wa gitokoya Goteyo, ga wa sajruka gistaklewlu walenwa gaschiya, wa giwekikaluruya gi wa Tokanchi Yonatkaluruya. Gi wa rumalwurni yineya seyni Goyakaluya. ");
INSERT INTO pibNT_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","¿Giyagni kluneru waneylu Goteyo panene pnute? ¿Klu rupxaklewata wa sajruka gistaklewlu? Gixo psoluyako. ");
INSERT INTO pibNT_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","Gi rixanu muchinanu Goyakalu tokanu galikakpotunanu gaponshinikanutka Goteyone yegi. ");
INSERT INTO pibNT_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","¿Gi rixkoxge wa pimrine wanna malixaklene rixinrina? ¿Wanna ma malixle chinanu gi ralixikolupa Goyakalu? ");
INSERT INTO pibNT_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","Gike rixiniko. Seyni wa Goyakalni myokwiretu ga wa ptowruko yineru kayloklerunmakni, wa tokanchi yonatkaluru chinyawaka: Wa Pixa, Goyakalu, muklukanuwnakaakotupyi pchina yanumsaletinri; Wa paalirewatinripa wa putakyagokikolupmaka. ");
INSERT INTO pibNT_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","Yineru ma poyagkaklenu chinanu pnute pgujpotlu Goyakalu poyagkaklewle. Wane rixini galikaka, ¿gi wchinanuna? ¿Mpoyagkaakatlege wa saletlewatinri Goyakalu? (Wa yineru gixyawakako nchina.) ");
INSERT INTO pibNT_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","Gike rixininanuko. Wa wane rixini ¿gi rixpoko giklukanuwnayegjixletanna tye psolchijneko gwachine wa Goyakalu? ");
INSERT INTO pibNT_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","Seyni naylokle chinanumka tsru rixinipa Goyakalu myokwirnu, rumalwutikolupa Goyakalu, ¿klu chinanu nuklukanuwnayegjixkota gita kmukochireru pixka? ");
INSERT INTO pibNT_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","¿Klu chinanu gi wane wchina, “Wkamrutanru gektutu runinripa wa kigleru”? wa pimrine wane chinyegitwu wa wane pguta wchinyawaka. Poyagkaaka ruklukanuwnayegjixikolupna wane chinachine. ");
INSERT INTO pibNT_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","Giyagni ¿klunerni? ¿Wanna pnutlege kiglewu wixa Goteyonwu? Gike rixininanuko. Muchinanu wunkakletanatkana Goteyone, ga wa payineko, pejnuruneko kmukochirerunni. ");
INSERT INTO pibNT_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","Wane chinyongatyawaka: Maleshlu poyagkakachri, gi satunako. ");
INSERT INTO pibNT_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","Maleshlu gimata jemachri. Maleshlu satu Goyakalu gijgachri. ");
INSERT INTO pibNT_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","Pejnuruneko gitspalata. Gike gapine rixkanna. Pawane gixkalunenatkanina. Maleshlu satu kigleru kamrutachri. ");
INSERT INTO pibNT_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","Yomlechi gitpukachri pixka rixaplajitna. Ginnuyna yokwirewatna. Gimnu kachingate pixkalutu waneyna gispuyna rapukote. ");
INSERT INTO pibNT_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","Ginamna katsepoyna kamakpiirewleyna, kapsakletlewleyna. ");
INSERT INTO pibNT_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","Teyaknanjixirunni wa ruyokyapluna granchi. ");
INSERT INTO pibNT_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","Gigapkaka rawa gimtuklewlu, tsru salewnalu. ");
INSERT INTO pibNT_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","Gi rumatluna gwashatikowakgapo. ");
INSERT INTO pibNT_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","Wannaygale getanu maleshayna pikyaluna Goyakalu. ");
INSERT INTO pibNT_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","Seyni wumatlu ptowruko Yokanatkaluru Tokanchi chinyawaka, wane china Tokanchi Yokanatkaluru waneyalune chinanu, wa pejnuruko yineru pokche rixinripa wa psolchijnepotunanuko gwachri giklukanuwnakaakalurupa Goyakalu getanu. ");
INSERT INTO pibNT_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","Gi rixanu wa Tokanchi Yokanatkaluru kamrutkalchinanu gi pamanennako muklukanuwnakaakonepni Wale yegi. Gi rixanu Tokanchi Yokanatkaluruya rumatika wa mukochri. ");
INSERT INTO pibNT_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","Ga wa xani Tokanchi Yokanatkaluru migje poyagkaklewle Goyakalu pgujetanurutkani. Gipgujtatkalurni wa Tokanchi Yokanatkaluruya ga wa tokanchi geneklewatachineya. ");
INSERT INTO pibNT_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","Poyagkaklewle Goyakalu, Geso Kristo galixikolu chinanu, wannanupni ralixjene pejnunanuka. Gi rixanu pixkakaklunni. ");
INSERT INTO pibNT_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","Gi rixanu pejnuruneko mukochirewata. Gi rapkapluna wa royaknu Goyakalu. ");
INSERT INTO pibNT_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","Ga wa rumutlewle chinanu Goyakalu muklukanuwnakaakone rixkakna. Walenwa renekashle, gi rixanu Kristo Geso wenutlu yine gognewatinripa. ");
INSERT INTO pibNT_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","Goyakalu galukyawaka, Geso chinanukni kaspuuka yineru mukochire ralixleya, Gesograga chinanu. Wane rixa gipgujewnakakletlu Goyakalu poyagkakachri rixinri, wa wane rixa getashletlu wmukochire wa muchikawa wkamrutanrukaka. ");
INSERT INTO pibNT_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","Pogetwamonrewlu rixkalchinanu Goyakalu, rumatyapluna yine wa galikakni poyagkakachrini Wale tyegognekakaya, gi rixanu tyegogneko poyagkakachrini Wale, ga wa poyagkakachri rutaklu yineru, Geso ralixinri chinanu. ");
INSERT INTO pibNT_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","¿Ginaakoxluge wa tserpiranawnalu? Ginanshichkaluru. ¿Giru Tokanchi Yokanatkaluru chinanu? ¿Kamrurchiylege? Gike. Seyni rixjetyawaka galixlu. ");
INSERT INTO pibNT_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","Giyagni wyanshinikanutlu muklukanuwnakaakotu rixinripa wa yineru ralixleya, wa Tokanchi Yokanatkaluru kamruremigjeya. ");
INSERT INTO pibNT_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","¿Wa Goteyonenupjerge wa Goyakalu? ¿Gi ge payine Goyakalutkoxni wa Goyakalu? Galikakpotunanni payine Goyakalutkoxni. ");
INSERT INTO pibNT_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","Gi rixanu satupjerutni Goyakalu. Walenwa muklukanuwnakane rutakanna sajruka gistaakotachine galixluya, ga wa msajruka gistaakotkone koxa galixlu chinanu. ");
INSERT INTO pibNT_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","¿Giyagni wutakashatlu maleshawaka wa Tokanchi Yokanatkaluru galixlu chinanu? Gike. Wmuchkotlu Tokanchi Yokanatkaluru. ");
INSERT INTO pibNT_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","¿Gi wchinankoxlu wa Gawra gikshikanru? Walenwa wutsrukatni wumaneya. ");
INSERT INTO pibNT_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","Wa Gawra muklukanuwnakaakotu rixinmaka wa kamrurchiya, ralixkotinmakwa, seyni gi wa Goyakalu getanu. ");
INSERT INTO pibNT_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","Gi rixanu ¿gi china wa yonchi? Wa ralixlu Goyakalu Gawrani. Rutakyegitka poyagkaklewle rixinri. ");
INSERT INTO pibNT_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","Seyni wa kamrurewatachriya gi wa genekashlu kagwaaka wa wenutikolu, seyni riwishkaachi. ");
INSERT INTO pibNT_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","Ga wa girukta gi kamrurewata seyni ralixlu Goyakalu wa mupashiregolune muklukanuwnakaakone gitakachri, wale galixle gitaaka poyagkakleyapa. ");
INSERT INTO pibNT_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","Tawi pixka koxa wane chinyegitlu giglenshinikanyegitkaluru wa yineru wa Goyakalu gitakyalu poyagkakle kamrurchi migje. ");
INSERT INTO pibNT_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","Wane china: Giglenshinikanyegitkalune wanna ruklukanuwnalna kaspukyegitkana, wa wanna gishyamukochiretkalune. ");
INSERT INTO pibNT_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","Giglenshinikanyegitkaluru wa jeji gi wa kmukochireru rutaaka Gitsrukaachiya. ");
INSERT INTO pibNT_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","Giyagni wa tye giglenshinikanyeglewlu ¿wa sajruka gistaakotkalunepjenuplege? ¿Waka msajruka gistaakotkonkoxaplege? Gi rixanu wane wchina, wa Gawra galixle gitaaka wale poyagkakle rixinripa. ");
INSERT INTO pibNT_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","¿Gi rixpoko poyagkakachri kagwaakota wale? ¿wa sajruka gistaakotkaluru, waka msajruka gistaakotuwa? Gi wa sajruka gistakletkaluru, seyni msajruka gistaakotu. ");
INSERT INTO pibNT_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","Sajruka gistaakikolu yaglu rixinripa, rumatikolupa poyagkakachri rixinri ralixleya chinanu. Wane rixa msajruka gistaakotuwa, rurna rixinripa pejnuruneko galixachine msajruka gistaakone, wanna koxa poyagkakachine gitakikolupa. ");
INSERT INTO pibNT_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","Rurna rixinrikoxapa sajruka gistaakotkalune, gi wanna sajruka gistaakotkalunepje, seyni koxa wa gomkagitachine galixlugapo wa wutsrukatni Gawrani msajruka gistaakonuwa waneylu. ");
INSERT INTO pibNT_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","Gi rixanu gi wa Tokanchi Yokanatkaluru chinanu, seyni wa poyagkaklewlu chinanu galixlewluya, Gawra ga wa giklopishane gipiryegitka wanna yoptotyaplu psolchijneko. ");
INSERT INTO pibNT_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","Gi rixanu wa Tokanchi Yokanatkaluru waneyalune wannapmakni yoptotachinepa, gike gaprimkatkani wa galixlu; giknookalurmakni wa gipiratkaluru tokanchi. ");
INSERT INTO pibNT_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","Gi rixanu wa Tokanchi Yokanatkaluru kamrutlu jgekanchi. Gi rixanu ginakakta maleshlu Tokanchi Yokanatkaluru, gi koxa wane kaspukika wa Yokanatkaluru Tokanchi. ");
INSERT INTO pibNT_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","Giyagni poyagkakachine gitaaka wa galixle chinanu, wa Goyakalu gimutlewleya rixinripa, poyegi rixinripa tokanchi gipiratkaluru pejnuruneko giklopishane chinanupa, gi wa wannapje chinanupni wa Tokanchi Yokanatkaluru waneyalune, seyni wanna koxa chinanupni, wa Gawra galixle waneyalune. Walenwa wutsrukatni pejnurunekwu wixa. ");
INSERT INTO pibNT_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","Wane chinyongatyawaka, Gita gitakyi gixo payinerumnunanuka gitsrukatni pixinripa. Wane rixa Gawra Goyakalu getanu. Walenwa Gawra galixanru. Walenwa gipnachine genekgiwekletachri. Walenwa wane gwachri pixka chinru wa mwakatuwa. ");
INSERT INTO pibNT_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","Mumkata kagwaakotupmaka, kagwaka Gawra. Ralixlu wa gixo payinerumnunanuka gitsrukatni rixinripa, chinyawakpotuko: Wane pixka rixanna puklopishane. ");
INSERT INTO pibNT_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","Gi wa rugroka galixluya. Gi rutakyagoknawa gimaneya gipnachritka. (Satu pacha walapustsitkani.) Gi koxa rutakyagoklu gipnachri twugenewlemapa Sara. ");
INSERT INTO pibNT_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","Gi koxa nutatlu Goyakalu gipiratanru ma malixlenuya. Seyni muchkotnawa ralixleya. Rumalwutlu Goyakalu. ");
INSERT INTO pibNT_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","Psolpotuyako rushinikanuwatya wa ptowruko rupiratanru Goyakalu, kgiyaklerni kamrutyaplu. ");
INSERT INTO pibNT_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","Giyagkoxni wa Gawra galixle rutakyegitlu poyagkaklewle rixinri. ");
INSERT INTO pibNT_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","Gi wa walepje chinanni yonatka wa rutakyegitikolu. ");
INSERT INTO pibNT_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","Seyni wixa koxa chinanu, wa wixa galixachinwu gitakyegitikolupa, gi rixanu walixlu wa Geso yotunkakachri Wutsrukate wixanu gipnachinetskalaya. ");
INSERT INTO pibNT_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","Walenwa samyookaluru wixa mukochire chinanu, ga wa yotunkaakaluru muklukanuwnakaakone wixinripa. ");
INSERT INTO pibNT_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","Giyagni muklukanuwnakaakonwu galixluya, kigle gwashletkawu Goyakaluyma Wutsrukate Geso Kristo chinanu. ");
INSERT INTO pibNT_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","Wale chinanu koxa wapkaplu tye gimutlewlu gawyegitanru galixluya. Wumuwata wkagwakinri Goyakalu goyaknu. ");
INSERT INTO pibNT_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","Gi wa walepjeni, seyni wumuwatanu koxa salewakchiya. Wumatlu wa salewakchi kamrutlu kashnantakgogneru. ");
INSERT INTO pibNT_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","Ga wa kashnantakgogneru kamrutlu gasruglewlu. Ga wa gasruglewlu kamrutlu kagwakikolu. ");
INSERT INTO pibNT_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","Ga wa kagwakikolu gi wa kapatmenurni. Gi rixanu Goyakalu gishiniklewle gipkaakalurni wajiya Giwekikaluru Kpashiriya, wenekikolu. ");
INSERT INTO pibNT_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","Gi rixanu wa Kristo muchkonwu wixanatini, gipapko rupnana mkagwakpiraklene chinanu. ");
INSERT INTO pibNT_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","Kyapreru satu gipnanmaka poyagkakachri chinanu, seyni patako satu mpiikatu rixnawa rupninripa kigleru chinanu. ");
INSERT INTO pibNT_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","Seyni Goyakalu gekakgi galuklewleta wixaya, gi rixanu, kmukochirerunwu wixanatini, Kristo gipna wixa chinanu. ");
INSERT INTO pibNT_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","Giyagni wanepnuteyaka muklukanuwnakaakonwu gigragaya; Waleya wognetkaako wa jgekanchiyegiya. ");
INSERT INTO pibNT_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","Giyagni wkamnixanatinrikopshini rupoyikgayegitinwu Goyakalu Gituru gipuka chinanu, wanepnuteyaka wupoyikgayegitikolutka, wognetkaako Wale giwekle chinanu. ");
INSERT INTO pibNT_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","Gi wa walepjeni, seyni wumuwata Goyakaluya, Wutsrukate wixanu Geso Kristo chinanu. Wale chinanu wupoyikgayegitikolutka. ");
INSERT INTO pibNT_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","Giyagni, wane rixa jiglokleta mukochri tye psolchijiko satupje yineru chinanu. Mukochri chinanni wa gipukchi. Giyagni wane rixa giknogletna gipukchi pejnuruneko yine. Gi rixanu pejnuruneko mukochirewata. ");
INSERT INTO pibNT_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","Wa ma mwanatkanuwa Yokanatkaluru Tokanchi, tye psolchijneko rawanatatka mukochri. Seyni Yokanataluru Tokanchi mwakanuwa gi wa ruklukanuwnakaaka yineru. ");
INSERT INTO pibNT_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","Seyni pogirewatatka gipukchi Gatakluyakawa wa Moysisiklupotunanuko, wanna koxa chinanu gi wa Gata ma mumretkale pixka rixa mukochirewletna. Gatanwa ginachripatka yaglu. ");
INSERT INTO pibNT_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","Seyni gi wa mukochri pixka rixa genekashlu. Gi rixanu satupje yineru mukochire chinanu rupninna gixni, pnuteyaklu wa Goyakalu gimutlewle gixo chinanu, ga wa genekashlu satupje yineru gimutlewle chinanu. Walenwa Geso Kristo. ");
INSERT INTO pibNT_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","Gi koxa wane pixka rixa wa genekashlu, wa satupje yineru mukochire pixka. Gi rixanu satupje mukochri runya giklukanuwnayegjixlu ruklukanuwnayegjixkolupna, seyni gixo mukochri runya gimutlewlu muklukanuwnakaakone rutakikolupna. ");
INSERT INTO pibNT_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","Gi rixanu satupje yineru mukochireya pogirewatinri gipukchi ga wa satupje yineru chinanu koxa, wanepnuteyaka pogirewatanna giwekachinepa satupje wa Geso Kristo chinanu, gixo gimutlewlu yoptotachinepa, wa poyagkaklewlu genekashatkaluru yoptotachinepa. ");
INSERT INTO pibNT_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","Giyagni waneko pixka rixanu satupje yineru mukochireya ruklukanuwnayegjixikolna pejnuruneko yine. Waneko pixka rixa: satupje yineru poyagkaklewleya, pejnuruneko yine muklukanuwnakaakone gitakikolu ruwekinripna. ");
INSERT INTO pibNT_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","Gi rixanu satupje yineru majnaknu chinanu rutaakana kmukochirerune gixolune. Waneko pixka satupje yineru yijnakle chinanu gixo gitaako poyagkakachinepa. ");
INSERT INTO pibNT_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","Wa Tokanchi Yokanatkaluru jigloka wa mukochri tseruwninripatka. Wa mukochri tseruwninitka tseruwnapotuta wa gimutlewlu koxa. ");
INSERT INTO pibNT_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","Wane rixa pogirewata mukochri rupninriyna yine, waneko pixka rixa poyagkaklewlu chinanu; pogirewata gimutlewlu ruwekinripna gike rixiniko mnikawnakatu Geso Kristo chinanu Wutsrukate wixanu. ");
INSERT INTO pibNT_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","¿Gi wchinanu koxa? ¿Womkagitanru wmukochirewatinri tseruwninripa gimutlewlu? ");
INSERT INTO pibNT_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","Gike wixiniko. Gi rixanu wixa gipniyanatkalu mukochrini. ¿Gi wixpoko satokleyegitanutnaklu wale? ");
INSERT INTO pibNT_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","¿Gi ge gimatlu gixa wa wixa girukokta katkaluru Geso Kristoya, katkaluru rupnaleya? ");
INSERT INTO pibNT_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","Gi rixanu katluya kapnatkalunwu. Waleyma gipnachinetkawu. Wa Kristo wane rixa yotunretinri gipnachinetskalaya Girchi goyaknuya, waneko pixka wixanu wixa: gawinripa gerotu giweklupa. ");
INSERT INTO pibNT_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","Waleyma pagipnakalunetkawu wixini Wale gipnale yagluya, waneko pixka rixa yotunotinri yaglu wixanu. ");
INSERT INTO pibNT_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","Wumatlu wa tye: wa kapokotmane wixinri Waleymananuko koroshishkita rutaaka, gike mumkatkatu rixikolupa wa mukochrimane, ma wayegretyanpatkawu mukochri. ");
INSERT INTO pibNT_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","Gi rixanu wa gipnachrinatka, gi wa mukochri giklukatkalu. ");
INSERT INTO pibNT_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","Kristoyma wupnini, walixlu wa wuwekinrikoxapa Waleyma. ");
INSERT INTO pibNT_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","Wumatlu wa Kristo yotunotinritka wa gipnachinetskalaya, gi rupnanutka. Waleya gi pogirewatanatka gipukchini. ");
INSERT INTO pibNT_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","Gi rixanu rupninri, pakatapje rupniyanatkalu mukochrini, seyni ruwekinri Goyakaluya ruwekatka. ");
INSERT INTO pibNT_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","Waneko pixkapotuko gixanu gixa. Gkagwakinwa galikakni gipniyanatkalu mukochrini, seyni Goyakaluya giweka wa Kristo Gesoya Wutsrukate wixanu. ");
INSERT INTO pibNT_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","Giyagni gi pogirewatanu mukochri gimaneya wa gimane gipnachripa, gma yijnakotyaplu gimane retsotanrewleya. ");
INSERT INTO pibNT_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","Gi koxa genekanru gimane psojite mukochri, mpoyagkaknuchi gapi rixinripa, seyni giwekachingi wa gipnapachine pixkalungi genekinwa Goyakalu. Goyakalu galikaka genekanru gimane psojite poyagkaklewlu gapi rixinripa. ");
INSERT INTO pibNT_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","Gi rixanu gi wa gitsrukatetanutkalu mukochri. Gi rixanu gi wa Tokanchi Yokanatkaluruyegitkagi, seyni gimutlewluyegitkagi. ");
INSERT INTO pibNT_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","Giyagni ¿klunerni? ¿Wmukochirewatewge gi rixanu gi wa Tokanchi Yokanatkaluryegwu, seyni gimutlewluyegwu? Gike wixiniko. ");
INSERT INTO pibNT_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","¿Gi ge gimata gixa wa girukokta wayegrene gitakinwa gyijnakotyaplu, wale wayegrene gixinitka wa gyijnakotanru? Waka mukochri wayegrengi gixinripa, waka yijnaklewlu wayegrengi poyagkakachine gixinripa. ");
INSERT INTO pibNT_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","Poyagnutkalurni Goyakalu, wa mukochrimka wayegretanatanungi, gyijnakotatkalu gajiya tye pixkalutu ginkaklewlu wa wale chinanu gitaaka gixa. ");
INSERT INTO pibNT_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","Mukochri yegi gishpakyatka. Poyagkaklewlu wayegretatkagi. ");
INSERT INTO pibNT_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","Gi rixanu yineru muchkotu gixyawakpotuko pixka nchingi. Wane gixa genekletlu gimane psojite gimuteru wayegreru rixinripa, mpoyagkaknuchi wayegreru rixinripa, waneko pixka gixanu xani. Genekanru gimane psojite poyagkaklewlu wayegretyaplu gipashiregnuyapa. ");
INSERT INTO pibNT_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","Gi rixanu mukochri wayegretanatingi, gi wa poyagkaklewlu wayegrenenangi. ");
INSERT INTO pibNT_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","¿Klu koxa waneyatkagi waleya, wa xawakni gipatewatanrutka? Gi rixanu gipnalni wale yoptukyawaka. ");
INSERT INTO pibNT_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","Ga wa xani mukochri gishpakyatka. Goyakalu wayegrenetkagi. Ga wa gkamrure koxa kpashiritka. Ga wa yoptukyawakapni giwekinri gike rixiniko mnikawnakatupa. ");
INSERT INTO pibNT_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","Ga wa mukochri wenutikolni wa gipnalpotu, seyni Goyakalu genekashle yoptotachri walenwa giweklu gike rixiniko mnikawnakatupa Kristoya Geso Wutsrukate wixanu. ");
INSERT INTO pibNT_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","Nomolene, gi wa mumatkangi, gi rixanu nuynumsatna Tokanchi Yokanatkaluru gimatachine. ¿Gi ge gimatlu wa Tokanchi Yokanatkaluru rutsrukateta yineru ruwekakopshini? ");
INSERT INTO pibNT_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","Gi rixanu kganururo, ruwekakopshini tganuru, Tokanchi Yokanatkaluru ginanshichawalo. Seyni rupnini tganuru, Tokanchi Yokanatkaluru gnurchipirana tushpakyatka. ");
INSERT INTO pibNT_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","Giyagni wa ruwekiniwa tganuru, gimopatlewatachro chinkaluropni wa satu jeji tganurutinipa. Seyni tupnagnurutinitka tushpakatka Tokanchi Yokanatkaluruya. Giyagni gi wa gimopatlewatachrotkani wa satu tganurutinitka. ");
INSERT INTO pibNT_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","Waneko pixka gixa, nomolene gitanune, gipniyanatkalu Tokanchi Yokanatkaluru Kristomaneya, satunuko gixinripatka, walenwa yotunotachritka gipnachinetskalaya, kigle kamrurewlepwu Goyakalu chinanu. ");
INSERT INTO pibNT_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","Gi rixanu manchi wixanatiniwa, mukochri getsotanrewle, Tokanchi Yokanatkaluruya, wumane psojitkaka kamrurewatya. Wale gwakakyaplu gipukchi. ");
INSERT INTO pibNT_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","Ga wa xani Tokanchi Yokanatkaluru wushpakyatka. Wupniyanatkalu wkashinatjerni, ga wa Giwekikaluruya wkamrurewatinripatka. Werotewatinritka. Gi wa yonchi kapokotewatinriya wkamrutanutka. ");
INSERT INTO pibNT_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","¿Gi wchinanu? ¿Tokanchi Yokanatkaluru mukochrirge? Gike rixiniko. Gi numatanatlu mukochri, seyni wa Tokanchi Yokanatkaluru chinanu numatlu mukochri. Gi rixanu gikoxmaka numatanru getsotanrewlu, wane ma chinkanumka Tokanchi Yokanatkaluru: Gi petsotanrewatanu. ");
INSERT INTO pibNT_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","Mukochri gikshiklu ruglepoktapinri yokanruya. Wane rixkakyano ptowruko getsotanugnuchi. Gi rixanu Tokanchi Yokanatkaluru migje mukochri gipnachrini. ");
INSERT INTO pibNT_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","Tokanchi Yokanatkaluru migje nuwekanata. Seyni wa Tokanchi Yokanatkaluru gininitka, mukochri giwekatnaka, ga wa gita gipnana. ");
INSERT INTO pibNT_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","Netatkalu yokanru giweklu chinanmaka, walenwa nupnale chinanu. ");
INSERT INTO pibNT_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","Gi rixanu mukochri gikshiklu ruglepoktapinri yokanruya. Yokwitanno. Waleya ruylatanno. ");
INSERT INTO pibNT_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","Giyagni galikakni Tokanchi Yokanatkaluru kpashirni, ga wa yokanru kpashirni, poyagkakachrini, kiglerni. ");
INSERT INTO pibNT_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","Giyagni ¿kiglerunanu gita chinanu gipnalu rixa? Gike rixiniko. Seyni mukochri mukochri gipgujewninripa wa kigleruya ruylatno, mukochripotunanu rixinripa mukochri Tokanchi Yokanatkaluru chinanu. ");
INSERT INTO pibNT_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","Gi rixanu wumatlu Tokanchi Yokanatkaluru Giwekikaluruyni. Ga wa gitni manchino, gishankakalurno mukochrinupno. ");
INSERT INTO pibNT_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","Gi rixanu wa nkamrutanru gi numata jemlu. Gi koxa wa nalukanru nkamruta. Seyni nayegixanru wale nkamruta. ");
INSERT INTO pibNT_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","Wa nma malukanutu wale nkamrutini, nupgujtatlu wa Tokanchi Yokanatkaluru kiglerni. ");
INSERT INTO pibNT_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","Giyagni xani gi wa gita kamrutlu, seyni mukochri gita gitokote gwachri kamrutlu. ");
INSERT INTO pibNT_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","Gi rixanu numatlu gitnanuko, walenwa nomaneya, gi rawa kigleru. Gi rixanu waneyno naluklewle, seyni gi nukshiklu kigleru nkamrutinri. ");
INSERT INTO pibNT_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","Gi rixanu gi nkamrutlu naluka kamruretanru kigleru. Seyni wa gektutu nma malukanutu wale nkamruta. ");
INSERT INTO pibNT_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","Ga wa nma malukanutu nkamrutini, gi wa nkamrutanutkalu gita, seyni mukochri kamrutanru gita gitokote gwachri. ");
INSERT INTO pibNT_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","Nukshiklu pnuko gixjetikowaka: wa naluka kigleru kamruretini, gektutu gwakoxno. ");
INSERT INTO pibNT_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","Gi rixanu wa gitoko gajeruya numjika Tokanchi Yokanatkaluruya Goyakalunu. ");
INSERT INTO pibNT_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","Seyni netlu nomane psojite pnuko gixpokotikowaka. Wale satkakmaklu nonshinikanu gixpokotyawaka. Raniikoxno gostutkalurno nkamrutyapmaklu mukochri gixpokotyawaka nomane psojiteya galukyawaka. ");
INSERT INTO pibNT_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","¡Kapsakletkalurno! ¿Katu koshpakanunno tye gipukchimaneya? ");
INSERT INTO pibNT_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","Npoyagnutlu Goyakalu, Geso Kristoya Wutsrukate wixanu. Giyagni nonshinikanu galukyawaka nkamrutini, Goyakalu yokanrekaka wayegrerno. Ga wa nomaneya galukyawaka nkamrutini, mukochri gixpokotyawaka wayegrerno. ");
INSERT INTO pibNT_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","Giyagni maleshpotutkalu ruklukanuwninritkana wa Kristo Geso gwachinetka, wa galixachinetka. ");
INSERT INTO pibNT_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","Gi rixanu Giwekikaluru yokanre giweklupirana Geso Kristoya wale koshpakno mukochri yokanreya, ga wa gipukchi yokanreya. ");
INSERT INTO pibNT_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","Gi rixanu wa Tokanchi Yokanatkaluru mumkatanatanutu, wumane gigroklewle chinanu, Goyakalu kamruta. Wane rixa yokanretlu Waleko Gituru kmukochirerunmane pixkalutu ga wa mukochri chinanu. Wane rixa nikatlepotutyaplu mukochri wumane gwachrini, ");
INSERT INTO pibNT_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","poyagkakikolupa wa kigleru yokanruya wixaya, wa manchi gixjetyawaka mixkanwu, ga wa Giwekikaluru gixyawaka. ");
INSERT INTO pibNT_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","Gi rixanu manchi pixka gixachine, manchipiranaya nshinikanutachinni; ga wa Giwekikaluru pixka gixachine, Giwekikalurupiranapje yanshinikanutachinni. ");
INSERT INTO pibNT_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","Gi rixanu manchinshinikanu gipnalni, ga wa Giwekikalurunshinikanu giwekluni, ga wa kiglenshinikangajirni. ");
INSERT INTO pibNT_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","Giyagni manchi gishinikyawaka walenwa kamnixikolu Goyakalu. Gi rixanu wane gixachri gi yijnakotlu Goyakalu yokanre. Gi koxa rumkatlu. ");
INSERT INTO pibNT_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","Giyagni manchi giyakatyachine gi rumkata giglenshinikanretluna Goyakalu. ");
INSERT INTO pibNT_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","Ga wa gi manchi giyakatyachingi, seyni Giwekikaluru giyakatyachingi, wa gixa gwinri Giwekikaluru Goyakalunu. Katukta Giwekikaluru Kristonumigjetu, gi Kristonni wale. ");
INSERT INTO pibNT_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","Seyni gixa gitokote rawini Kristo, gimane galikakni gipnachrini mukochri chinanu. Ga wa giwekikaluru giweka wa poyagkakikolu chinanu. ");
INSERT INTO pibNT_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","Wa gixa gitokote rawini Giwekikaluru, Geso yotunkakjerunu wa gipnachinetskalaya, wa yotunkakjeru Kristo Geso gipnachinetskalaya ruweekakankoxlu gixamane popukalu Giwekikaluruya Walenu, gixa gitokote gwachri. ");
INSERT INTO pibNT_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","Giyagni nomolene, riwishkatachinwu, gi wa manchiyni, giyagni gi wa manchi gixjetyawakako wixinripni. ");
INSERT INTO pibNT_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","Gi rixanu manchi gixyawakako gixininapa, gipnanuna. Seyni wa Giwekikaluruya gixa gipnakakanru wa manchi kamrure waneklu giwekanu. ");
INSERT INTO pibNT_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","Gi rixanu pejnuruneko Giwekikaluru Goyakalunu kosekanune, wannanwa Goyakalu wgenene. ");
INSERT INTO pibNT_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","Gi rixanu gi gyoptotlu wayegrechinshinikanu wa mpikyapatnaka. Seyni gyoptotlu wgenchi gitaakalurunshinikanu. Wale chinanu wsaplewata, “Gawwa, Nuru.” ");
INSERT INTO pibNT_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","Gi rixanu Giwekikaluruko wixanshinikanu gipgujtatlu Goyakalu wgenene wixinri. ");
INSERT INTO pibNT_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","Wale wgenene wixini, yoptotachinkoxapwu; yoptotachinepwu Goyakalunu; Kristoyma yoptotachinepwu. Waleyma salewnachinkoxapwu wixini, Waleymapotuko pogirewlu wenekikolupa. ");
INSERT INTO pibNT_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","Gi rixanu numatpotutlu wa tyegognekaka wsalewninri gi rumuknini pogirewlu ginachripa gipgujewnachripa wixaya. ");
INSERT INTO pibNT_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","Gi rixanu wa giyakotkaluru psolu galukleyako kagwakpotuta wa rupgujewninripna Goyakalu wgenene. ");
INSERT INTO pibNT_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","Gi rixanu moyakatu rixkaklu ruyakotanru Goyakalu, gi wa giyakotkaluru gishinikanru chinanu, seyni wane rixkakjeru wa Goyakalu chinanu. Wane rixlu wa Goyakalu wa kigleru kagwakyapna wa ruyakotanrutka. ");
INSERT INTO pibNT_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","Wa waleko giyakotkaluru koshpaakalurupni moyaknuchi wayegretlewatyawakaya. Rapkaplu gishpakikowaka katajiwaka Goyakalu wgenennu. ");
INSERT INTO pibNT_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","Gi rixanu wumatlu pejnuruko giyakotkaluru pagochgitkalune rixna, pakachinolu getkalunni xanigognenanu. ");
INSERT INTO pibNT_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","Gi walepjeni, seyni wannanuko, wa Giwekikaluru gekamrure waneyalune, wixa koxa ga wa wanna gitokoyako wochgita, wkagwakanatinri wa Wale wugenene gitakpotutikolupa, walenwa wumane gishpakleyapa, wenutikolutka chinanu. ");
INSERT INTO pibNT_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","Gi rixanu kagwakachinwu wognewatinri. Seyni wa kagwaakaluru getika, gi wa kagwaakalurni. Gi rixanu wa satu getkoklunu, ¿gi rixpoko kagwakletanru? ");
INSERT INTO pibNT_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","Seyni wma metanutu wkagwakini, wakotanshinikanreya wkagwakanru. ");
INSERT INTO pibNT_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","Waneko pixka rixa gipxakletwu Giwekikaluru wumenoklunshinikanruya. Gi rixanu gi wumata kluneru kigleru wagjitinripa. Seyni wa Giwekikaluruko gagjita wixa chinanu rochgiyle mumkata chinkotu. ");
INSERT INTO pibNT_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","Getjegajrewatachri gimatlu Giwekikaluru gishinikanru. Gi rixanu wanepotuko Goyakalu gishinikyawaka, ragjita kpashirine chinanu. ");
INSERT INTO pibNT_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","Wumatlu ptowrunanuka pakamrutkolutni kigleyapna Goyakalu galukachine, wannanwa tomgakalune Wale galukyawaka. ");
INSERT INTO pibNT_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","Gi rixanu muchikawako rumatanune rutakagnaputa, Gituru yaglu pixka rixkakikolupna, Wale muchinanu gishpakachri rixinripa gixo gimolenetskalaya. ");
INSERT INTO pibNT_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","Wa rutakagnaputanune wanna koxa tomga. Wa tomganune wanna koxa muklukanuwnakaakone rixna. Wa muklukanuwnakaakone rixanune wanna koxa royaknu reneka. ");
INSERT INTO pibNT_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","Giyagni ¿gi wchinanu wa tyeya? Wixa yegi rixini Goyakalu, ¿katu kamnixwu wixa? ");
INSERT INTO pibNT_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","Ga wa Wale gi chipetlu Giturpotuko, seyni samyoklu ptowruneko wixa chinanupa ¿gi rixpokotyawaka Gituruymananuko ma meneekanupwu ptowrunanuka? ");
INSERT INTO pibNT_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","¿Katu jigyegitna Goyakalu tsomitanune? Goyakalni muklukanuwnakaakone gixkaklewatachri ¿Katni wa giklukanuwnayegjixlewatachri? ");
INSERT INTO pibNT_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","Kristonwa gipnachri. Wanepnute Walenwa yotunkaakaluru. Walenwa Goyakalustsi potuklesreta gwachri. Wale koxa giykoyegitwu wixa. ");
INSERT INTO pibNT_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","¿Giru kotspalatinwu Kristo galuklewleya? ¿salewakchirge? ¿ga wa kachinolege? ¿ga wa kojwawakchirge? ¿ga wa nachlege? ¿ga wa mamkatutnuchlege? ¿ga wa kyowikolege? ¿ga wa yoglolewaprege? ");
INSERT INTO pibNT_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","Wa chinyawaka yonchi: Pixa chinanu psolgogneko gipnachinwu. Kagwaakalunwu gowegane pixka giylatkalunepa. ");
INSERT INTO pibNT_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","Seyni psoluyako tyekakaya wakagloklewpotuta walukjeruya. ");
INSERT INTO pibNT_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","38","Giyagni nalixa gita, gi wa gipukchiko, gi wa giwekluko, gi wa kamchineko, gi wa tsrukakaluneko, gi wa kgiyaklewakleruneko, gi wa xanirutuko, gi wa ginachripako, ");
INSERT INTO pibNT_vpl VALUES ("RM8_39","075_8_39","ROM","8","39","39","gi wa tenolu, gi wa gitokpotuko, gike giyakotkaluru gimkata kotspaletyawu Goyakalu galuklewleya, wa Kristo Geso gwachri, Wutsrukate wixanu. ");
INSERT INTO pibNT_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","Galikakni wa nchinanru Kristoya. Gi nayroklewata. Giwekikaluru Kpashiriya nonshinikanu gipgujtatno muklukanuwnanshinikanutkatno. ");
INSERT INTO pibNT_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","Wane nixa, tsru wamonchi nixa. Kachingajgognenanno. ");
INSERT INTO pibNT_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","Gi rixanu nalukmaklu gitakmaka kamakpiratko Kristoyegiya nomolene chinanu, nonerune nomaneya. ");
INSERT INTO pibNT_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","Wannanwa Gisrayiline. Wannanni wa wgenchine gitakikolu, ga wa pogirewlu, ga wa tokanchi gipiratkaluru. Wannanwa Tokanchi Yokanatkaluru geneekalune, wa Goyakalu kamrurewyegitachine. Wannanni wa Goyakalu gipiratanru. ");
INSERT INTO pibNT_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","Wannanni wa gitsrukachinni. Wannanni wa Kristo gimaneya. Walenwa Goyakalu pejnurkakayako gimalwutkalurgognenanu. Wane gixkalurupa. ");
INSERT INTO pibNT_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","Gi wane rixa magjeretmaka Goyakalu tokanu. Gi rixanu gi wa Gisrayiliklopishane pejnuruneko Gisrayilinni. ");
INSERT INTO pibNT_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","Gi wa Gawraklopishane rixinrina chinanu, pejnuruneko wale wugenetika. Seyni giklopishane chinikolupna Gisaakaya. ");
INSERT INTO pibNT_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","Wane chinyawaka, wa manchi wugenetikalune, wanna gi wa Goyakalu wgenene chinkana, seyni wa tokanchi gipiratkaluru wugenetikalune wannanwa kagwaaka Gawraklopishane. ");
INSERT INTO pibNT_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","Gi rixanu wa tokanchi gipiratkaluru wane china: “Xani topapko gapokinipa, nunanu. Waneypatkalo Sara toturu.” ");
INSERT INTO pibNT_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","Gi wa walepjeni, seyni Riwika koxa mushiwata satu Gisaakaya, wutsrukatni. ");
INSERT INTO pibNT_vpl VALUES ("RM9_11","075_9_11","ROM","9","11","11","Gi rixanu ma mushpaakanuwana, gi koxa kigleru kamrutawana, gi wa mugletuko, Goyakalu galukyawaka rawgognenatinripa, Wale tsomityawaka, gi wa kamrurchi chinanu, seyni tomgalewatachri chinanu, ");
INSERT INTO pibNT_vpl VALUES ("RM9_12","075_9_12","ROM","9","12","12","wane chinka wala, “Wa mturu wayegretanru wa tsru.” ");
INSERT INTO pibNT_vpl VALUES ("RM9_13","075_9_13","ROM","9","13","13","Yonchi chinyawaka: Gakowo naluka, ga wa Gisawo nayegixa. ");
INSERT INTO pibNT_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","¿Gi wchinanu koxa? ¿Wanerge Goyakalu mpoyagkaklewle? Gike rixiniko. ");
INSERT INTO pibNT_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","Gi rixanu Moysisi wane china: Nupxakanrupa nupxakanu, ga wa netwamonutanrupa netwamonutanu. ");
INSERT INTO pibNT_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","Giyagni wa Goyakalu tsomitinri gi wa wixa galuklewle chinanu, gi wa wmuchkowle chinanu, seyni Goyakalu getwamonrewle chinanu. ");
INSERT INTO pibNT_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","Gi rixanu wa yonchi wane chinru Gwarawo: Waleko chinanu nutakyi nekakgityaplu nuyaklewle pixaya, runkakletikolupa ngiwaka psolchijneyako. ");
INSERT INTO pibNT_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","Giyagni koxa girukta raluka getwamonreta Goyakalu, retwamonutlu. Girukta raluka shikowkakleta, shikowkaklu. ");
INSERT INTO pibNT_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","Giyagni wane pchinanno, “¿Klu koxa kegemgiya?” Gi rixanu ¿katu satkakakanru Goyakalu gishinikanru? ");
INSERT INTO pibNT_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","Ga wa ¿giryi pixa yineru pyoptopiratyaplu Goyakalu? ¿Kajpa kamrutikolu wanerge chinanru wa kamrutjeru,? “¿Klu chinanu wane pixa kamruretno?” ");
INSERT INTO pibNT_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","¿Gi ge rumkata kamrurewakleru walejpako kamrutyaplu pastono kigle getkolupa ga wa satu muglegetkotupa? ");
INSERT INTO pibNT_vpl VALUES ("RM9_22","075_9_22","ROM","9","22","22","Goyakalu galuka gekakgiretinri jigekanu, rumatikolu raluka gixkakletlu ruyakle, wane rixa wa mapognanutu rixa gakotletlu jgekanchiyegkaka galpokotkaluru ramginripa. ");
INSERT INTO pibNT_vpl VALUES ("RM9_23","075_9_23","ROM","9","23","23","Wane rixa rumatikolupa wa ponikolkaka royaknuya retwamonutanune chinanupa. Wannanwa ralpokotanune gimalwuru chinanu. ");
INSERT INTO pibNT_vpl VALUES ("RM9_24","075_9_24","ROM","9","24","24","Wanna koxa tomga, ga wa wixa. Gi wanna Goteyonepjeni, seyni koxa payinkaka. ");
INSERT INTO pibNT_vpl VALUES ("RM9_25","075_9_25","ROM","9","25","25","Wane koxa chinyawaka Goseyi tokanuya: Nayinerutene nchinanna nma gayinerutetanatanune koxa. Ga wa nma malukanatanro, nalukanro nchinanro. ");
INSERT INTO pibNT_vpl VALUES ("RM9_26","075_9_26","ROM","9","26","26","Wane rixanu: Wa chinikowakna: Gi wa nayinerutengi gixa, Waneya Goyakalu giwekachri wgenene chinikolupna. ");
INSERT INTO pibNT_vpl VALUES ("RM9_27","075_9_27","ROM","9","27","27","Wane koxa china sapleta Gisayiya Gisrayilinepirana: “Wane pejnumkana Gisrayiliklopishane tsru wenu ksatnepagi pixka pejnumkana, gixetachinepje gognetkaako.” ");
INSERT INTO pibNT_vpl VALUES ("RM9_28","075_9_28","ROM","9","28","28","Gi rixanu Gitsrukaachi kamrure nikatpotutanu, sustakanu tye chijiya. ");
INSERT INTO pibNT_vpl VALUES ("RM9_29","075_9_29","ROM","9","29","29","Muchikawa wane chinyawaka Gisayiya: Gitsrukaachi ksolaloteru gimka ruxetkaklopishatanunwu, Sotoma gajenniko pixkamka wixanuna, ga wa Komora gajenni pixkapotukmaka wixanuna. ");
INSERT INTO pibNT_vpl VALUES ("RM9_30","075_9_30","ROM","9","30","30","¿Gi wchinanu koxa? Wa payineko poyagkaklewlu momkagitkane rapkapluna poyagkaklewlu. Walenwa poyagkaklewlu galixluya. ");
INSERT INTO pibNT_vpl VALUES ("RM9_31","075_9_31","ROM","9","31","31","Ga wa Gisrayiline wa Tokanchi Yokanatkaluru poyagkaklewluya gomkagitachine, gi wa rapkapluna Tokanchi Yokanatkaluru poyagkaklewluya. ");
INSERT INTO pibNT_vpl VALUES ("RM9_32","075_9_32","ROM","9","32","32","¿Klu chinanu? Gi rixanu gi wa galixluya romkagitluna, seyni Tokanchi Yokanatkaluru kamrureya pixka. Giyagni rutspetanna sotlu gitspetkaluruya. ");
INSERT INTO pibNT_vpl VALUES ("RM9_33","075_9_33","ROM","9","33","33","Chinyongatyawaka: Siyo Magkate nutaklu sotlu gitspetkaluru, sotlu gijrukikowaka, Tye sotlu galixachri gi wa patmenuwatanu. ");
INSERT INTO pibNT_vpl VALUES ("RM10_1","075_10_1","ROM","10","1","1","Nomolene, galikakni, naji gishinikyawaka, ga wa Goyakalu nagjire wanna chinanu walenwa rognewatinripna. ");
INSERT INTO pibNT_vpl VALUES ("RM10_2","075_10_2","ROM","10","2","2","Gi rixanu gita gipgujtatna jmerpotna Goyakaluya, seyni gi wa gimatkalewluya. ");
INSERT INTO pibNT_vpl VALUES ("RM10_3","075_10_3","ROM","10","3","3","Gi rixanu gi rumatluna wa Goyakalu poyagkaklewle ga wa wannanuko retumga kamruretna. Gi wa yijnakotluna Goyakalu poyagkaklewle. ");
INSERT INTO pibNT_vpl VALUES ("RM10_4","075_10_4","ROM","10","4","4","Gi rixanu Tokanchi Yokanatkaluru poyagkakachri walenwa Kristo, poyagkaklewlupa pejnuruko galixachri chinanupa. ");
INSERT INTO pibNT_vpl VALUES ("RM10_5","075_10_5","ROM","10","5","5","Moysisi yonpiranyegitlu poyagkaklewlu Tokanchi Yokanatkaluruya. Wane china: wa Tokanchi Yokanatkaluru kamrutachri walenwa poyagkakachri, ga wa yineru tyekaka gixachripa ruwekanu waleya. ");
INSERT INTO pibNT_vpl VALUES ("RM10_6","075_10_6","ROM","10","6","6","Wa ralixleya poyagkakachri wane china: “Gi wane pchingajitanu, ‘¿Katu tengogne gatskotanu wa chiji rawapyaplu Kristo?’ ” ");
INSERT INTO pibNT_vpl VALUES ("RM10_7","075_10_7","ROM","10","7","7","Gi koxa wane pchingajitanu: “¿Katu gijrukanu gitskata potu rawapyapatnaklu Kristo gipnachinetskalaya?” ");
INSERT INTO pibNT_vpl VALUES ("RM10_8","075_10_8","ROM","10","8","8","Gike. Wane china ralixleya poyagkakachri, “Gi gowuklu Goyakalu tokanu. Punamaya rawa Wale tokanu, ga wa paji rawa.” Walenwa tokanchi galixluya, wunkakletanru. ");
INSERT INTO pibNT_vpl VALUES ("RM10_9","075_10_9","ROM","10","9","9","Wa punamaya pupgujtatinri Gitsrukaachi Geso, wa pajiya palixinri Goyakalu yotunkaklu gipnachinetskalaya, pognetkaako. ");
INSERT INTO pibNT_vpl VALUES ("RM10_10","075_10_10","ROM","10","10","10","Gi rixanu yineru rajiya ralixya waneyaplu poyagkaklewlu. Ga wa ginamaya rupgujtalewata rognetkakikolupa. ");
INSERT INTO pibNT_vpl VALUES ("RM10_11","075_10_11","ROM","10","11","11","Gi rixanu wane china yonchi: “Pejnuruko Goyakalu galixachripa gi wa patmenuwatanu.” ");
INSERT INTO pibNT_vpl VALUES ("RM10_12","075_10_12","ROM","10","12","12","Gi rixanu pixkakakanni Goteyone ga wa Kriykone. Gi rixanu Walekni pejnuruneko Gitsrukate ponikolni pejnuruneyako Wale tomgachine. ");
INSERT INTO pibNT_vpl VALUES ("RM10_13","075_10_13","ROM","10","13","13","Gi rixanu pejnuruneko Gitsrukaachi giwaka koschekachine ragjirgognereyna rognetkaakona. ");
INSERT INTO pibNT_vpl VALUES ("RM10_14","075_10_14","ROM","10","14","14","Giyagni ¿gi rixpoko koschekletanruna ma malixanatanutna? ¿Gi rixpoko galixletanruna ma yijnakpiranyegitanruna? ¿Gi rixpoko yijnakletanruna satu munkakletanutu? ");
INSERT INTO pibNT_vpl VALUES ("RM10_15","075_10_15","ROM","10","15","15","¿Gi rixpoko ginkaklewletanna myokanatkoneko rixinna? Yonchi chinyawaka, “¡Gi pagiglenjixinanuktana wa Kiglerpotunanu Tokanchi kigleruya ginkakletachine!” ");
INSERT INTO pibNT_vpl VALUES ("RM10_16","075_10_16","ROM","10","16","16","Seyni gi wa pejnuruneko yijnakotlu Kiglerpotunanu Tokanchi. Gi rixanu Gisayiya wane china, “Gitsrukaachi, ¿katu galixlu wunkakle?” ");
INSERT INTO pibNT_vpl VALUES ("RM10_17","075_10_17","ROM","10","17","17","Giyagni yijnaklu runya wa galixlu. Kristo tokanu runya yijnaklu. ");
INSERT INTO pibNT_vpl VALUES ("RM10_18","075_10_18","ROM","10","18","18","Seyni wane nchina, ¿Gi ge yijnakyegitluna? Galikakni. Psolchijneko pogiwatyana. Yoptukyawakpotunanuko tye psolu chijiko Pogiwatya wanna tokanu. ");
INSERT INTO pibNT_vpl VALUES ("RM10_19","075_10_19","ROM","10","19","19","Seyni wane nchina, ¿Gi ge rumatluna Gisrayiline? Muchinanu gapka Moysisi wane china: Netsotankakangi yine migjeya, ga wa payine manshinikanune numtuwnakakingi. ");
INSERT INTO pibNT_vpl VALUES ("RM10_20","075_10_20","ROM","10","20","20","Gisayiya mpiikotu wane china: Nukshiika nma mujgajeneya. Nekakgitnawa nma mepomgayegitjene yegi. ");
INSERT INTO pibNT_vpl VALUES ("RM10_21","075_10_21","ROM","10","21","21","Wa wanna Gisrayilinepirana wane china: Psolgogneko nomyokyegitna yine malixkane, majnakone. ");
INSERT INTO pibNT_vpl VALUES ("RM11_1","075_11_1","ROM","11","1","1","Giyagni wane nchina, ¿Ruknoknege Goyakalu rayinerutene? Gike rixiniko. Gi rixanu gitkoxni Gisrayili, Gawraklopishno, Migaminerno. ");
INSERT INTO pibNT_vpl VALUES ("RM11_2","075_11_2","ROM","11","2","2","Gi ruknokna Goyakalu wa rayinerutene, wa muchikawa rumatanune. ¿Gi ge gimata gixa Giliyapirana? Wa yonchi chinpiranyegityawaklu, wa Goyakalu runkaka Gisrayilinepirana. Wane china, ");
INSERT INTO pibNT_vpl VALUES ("RM11_3","075_11_3","ROM","11","3","3","“Gitsrukaachi, wanna giylatna ptokanu geneklewatachine. Jijrolekluna penekashatikowakakwakaka. Gitapje gitukatka. Retumga giylaletmaknona.” ");
INSERT INTO pibNT_vpl VALUES ("RM11_4","075_11_4","ROM","11","4","4","Seyni ¿gi china gigletlu Goyakalu? “Waneyawano payokgipre waragka jejine Waalistsi myoptsojitkane.” ");
INSERT INTO pibNT_vpl VALUES ("RM11_5","075_11_5","ROM","11","5","5","Waneko pixka rixa xawakni koxa, wanena gixetachine tsomitkalune gimutlewluya. ");
INSERT INTO pibNT_vpl VALUES ("RM11_6","075_11_6","ROM","11","6","6","Ga wa gimutlewluya chininri, gi wa kamrurchiyni. Wane ma mixkamka wa gimutlewlu gimka gimutlewlupni. ");
INSERT INTO pibNT_vpl VALUES ("RM11_7","075_11_7","ROM","11","7","7","Giyagni ¿klunerni? Gisrayiline gi gapkaplu rujganruna, ga wa tsomitkalune gapkaplu, ga wa pimrine shikpokwakatana. ");
INSERT INTO pibNT_vpl VALUES ("RM11_8","075_11_8","ROM","11","8","8","Chinyongatyawaka: Goyakalu genekna mshinikannuchi, giygalna ma metinitipna, gijnakna ma yijnakotinitipna xanigognenanu. ");
INSERT INTO pibNT_vpl VALUES ("RM11_9","075_11_9","ROM","11","9","9","Tawi wane chinpiranyegitanna: Nikawaklekwakna gitspekakanunna; gitseklutpo yanunna. Wane rixa gapnugognenatkotanunna. ");
INSERT INTO pibNT_vpl VALUES ("RM11_10","075_11_10","ROM","11","10","10","Mapshagaygalepna ma metinitipna. Satpokgayijgapgognenatanna. ");
INSERT INTO pibNT_vpl VALUES ("RM11_11","075_11_11","ROM","11","11","11","Giyagni wane nchina, ¿rutspetannage wa rujrukinripna? Gike rixiniko. Seyni wa rutspetinriyna wanna runya gognewatikaluru payineko chinanu, retsotankakikolupna Gisrayiline. ");
INSERT INTO pibNT_vpl VALUES ("RM11_12","075_11_12","ROM","11","12","12","Ga wa wanna mukochire chinanu ponikowatinrina psolchijneko gajene yine, ga wa masawatinrina chinanu ponikowatinrina payineko, wanepnute potu ponikowatanna galikakni wa katsepa potu rixa jiglokletinpatnakna Gisrayiline. ");
INSERT INTO pibNT_vpl VALUES ("RM11_13","075_11_13","ROM","11","13","13","Gixa nuynumsata, payinekgi. Giyagni npoyagnutlu nkamrure, gi rixanu gita galikaka yokanatanruno payineko chinanu. ");
INSERT INTO pibNT_vpl VALUES ("RM11_14","075_11_14","ROM","11","14","14","Giktako nixpoko getsotankakletinna nomolene nomaneya, wanna pimrine gognetkaako gita chinanu. ");
INSERT INTO pibNT_vpl VALUES ("RM11_15","075_11_15","ROM","11","15","15","Gi rixanu wa ramginrina wanna, rupoyikgayegitikolna tye psolchijneko gajene, ¿klunerupni yoptotikolupna? Walepjepni wa ruwekinripatkana gipnachinenanu. ");
INSERT INTO pibNT_vpl VALUES ("RM11_16","075_11_16","ROM","11","16","16","Rejiwle kpashiri rixini, pejnuruko kpashiri koxa. Ga wa gitski kpashiri rixini koxa, giplukaka koxa kpashiri. ");
INSERT INTO pibNT_vpl VALUES ("RM11_17","075_11_17","ROM","11","17","17","Wa pimriplukaka gistaakoklunu, ga wa pixa goliwa mutaakotmuna pixkalutyi gipxaakaluryi wanna kashrigle. Walerutu goliwamunatskiya, goliwamuna ponikolewle yoptotachri pixinri, gi palixkotinwa waleplukaka pnute. ");
INSERT INTO pibNT_vpl VALUES ("RM11_18","075_11_18","ROM","11","18","18","Wa palixkotinmakwa, gi wa pixa giweekaklu gitski, seyni gitski giweekakyi pixa. ");
INSERT INTO pibNT_vpl VALUES ("RM11_19","075_11_19","ROM","11","19","19","Giyagni wane pchinanu pixa, “Gistaakaluru giplukaka, nupxakikolupa gita wanna kashrigle.” ");
INSERT INTO pibNT_vpl VALUES ("RM11_20","075_11_20","ROM","11","20","20","Gwu. Ma malixlenuyna gistaakalunni, seyni pixa galixlu chinanu wane pwa. Gi wa pixnanuko tsru pkagwakinwa, seyni piklewatanu. ");
INSERT INTO pibNT_vpl VALUES ("RM11_21","075_11_21","ROM","11","21","21","Gi rixanu Goyakalu gi chipetinri rumaturewaplutanrukaka, pixa koxa gi wa chipetanu. ");
INSERT INTO pibNT_vpl VALUES ("RM11_22","075_11_22","ROM","11","22","22","Giyagni petanu kshinikanurni Goyakalu ga wa kgokolni. Galikaka potu kgokolni gijrukachine chinanu, seyni pixa chinanu kshinikanru wa pixa kshinikanuru gomkagletinri. Ga wa pnuko pixininapa pixkoxapni gistaakalurunapyi. ");
INSERT INTO pibNT_vpl VALUES ("RM11_23","075_11_23","ROM","11","23","23","Ga wa wannako gi wa romkagitinripna ma malixleyna rupxaakona. Gi rixanu kgiyaklewaklerni Goyakalu ruptaka gipxakletyapna. ");
INSERT INTO pibNT_vpl VALUES ("RM11_24","075_11_24","ROM","11","24","24","Gi rixanu pustaakoklunu mutaakotu goliwamunapu mumturetanrumuna, ga wa pma mumturetanutu pupxaaka kigleru goliwmuna, ¿gi ge wanepnuteyaka rumumtureplutanrukaka gipxaakalurupni roliwatmunna? ");
INSERT INTO pibNT_vpl VALUES ("RM11_25","075_11_25","ROM","11","25","25","Gi rixanu gi naluklu, nomolene, gixa mumatanutu tye giyogimanatkaluru tokanchi, gma malixkotinitipnawa. Wa ptsotsotaji shikgaji rixna Gisrayiline katsepa potu rixa jiglokletinipna payineko. ");
INSERT INTO pibNT_vpl VALUES ("RM11_26","075_11_26","ROM","11","26","26","Wane rixanna pejnuruneko Gisrayiline gognetkaako, chinyongatyawaka: Siyomriji ruyakatya yostamyoyeglewatachri. Wale koshripatinna Gakowoklopishane ma kagwakpirnukleyna. ");
INSERT INTO pibNT_vpl VALUES ("RM11_27","075_11_27","ROM","11","27","27","Nkonmukochiretinna walgogne. Tyenwa nupiratyana. ");
INSERT INTO pibNT_vpl VALUES ("RM11_28","075_11_28","ROM","11","28","28","Giyagni wa Kiglerpotunanu Tokanchipirana kamnixachine rixna gixa chinanu, ga wa tsomitkoklunupirana galuukalune rixna rutsrukatennina chinanu. ");
INSERT INTO pibNT_vpl VALUES ("RM11_29","075_11_29","ROM","11","29","29","Mkashrijetanshinikanutkatu Goyakalu genekashlekaka, tomgalewle. ");
INSERT INTO pibNT_vpl VALUES ("RM11_30","075_11_30","ROM","11","30","30","Gi rixanu gixa pixka gma malixanatkanru Goyakalu, ga wa xani gapkaplu getwamonrewlu wanna ma malixlenu chinanuya. ");
INSERT INTO pibNT_vpl VALUES ("RM11_31","075_11_31","ROM","11","31","31","Waneko pixka rixna xani. Gi ralixna. Rapkapyakoxapluna getwamonrewlu wanna, gixa getwamonutikoluya. ");
INSERT INTO pibNT_vpl VALUES ("RM11_32","075_11_32","ROM","11","32","32","Gi rixanu Goyakalu gishyatna pejnuruneko ma malixlenuyna, retwamonutyapna pejnuruneko. ");
INSERT INTO pibNT_vpl VALUES ("RM11_33","075_11_33","ROM","11","33","33","¡Tsrupotunanu ponikolu Goyakalunshinikanu, rumatkalewle! Mumata jemkotpotni rutakyagoklewle. Mukshikanshinikanutkotu ratnugapote. ");
INSERT INTO pibNT_vpl VALUES ("RM11_34","075_11_34","ROM","11","34","34","Gi rixanu gike gimatanshinikanutlu Gitsrukaachi. Gike giyakotlu. ");
INSERT INTO pibNT_vpl VALUES ("RM11_35","075_11_35","ROM","11","35","35","Ga wa ¿katu gapka geneklu Wale, Goyakalu gapnu genekletyaplu? ");
INSERT INTO pibNT_vpl VALUES ("RM11_36","075_11_36","ROM","11","36","36","Gi rixanu Waleya, ga wa Wale chinanu, ga wa Walenupa ptowrunanuka. Walenupa royaknu rixgognenatyawaka. Wane gixkalurupa. ");
INSERT INTO pibNT_vpl VALUES ("RM12_1","075_12_1","ROM","12","1","1","Giyagni, nomolene, nagjitgi Goyakalu getwamonrewle chinanu giylatkalurunepa pixkalungi genekmanetinwa genekashlupa giwekachri, kpashiri, Goyakalu gigleretanru. Walenwa gkamrure potukalu potu Goyakalu yegi. ");
INSERT INTO pibNT_vpl VALUES ("RM12_2","075_12_2","ROM","12","2","2","Gi wa tyegogne gajene pixka gixanu, seyni pnuko gixinwa gerotewanshinikankaakalungi nchininri, gimatyaplu klunerni Goyakalu galukanru kigleru gigleretkaluru mmagatikatu. ");
INSERT INTO pibNT_vpl VALUES ("RM12_3","075_12_3","ROM","12","3","3","Giyagni gimutlewlu nenekikoluya, wane nchingi satkaka gixa yegi gwachri, gi wane rixinri pnute ralixkotinwa, seyni kanshinikanurupni yanshinikanyegitinwa wa Goyakalu wane rixa yagotletyawaklu satkaka galixle. ");
INSERT INTO pibNT_vpl VALUES ("RM12_4","075_12_4","ROM","12","4","4","Gi rixanu wane rixpokota. Satkakmane waneywu gixo manchipsojitkaka, seyni gi wa pejnuruneko waneko pixka gixa kamrureta koxa. ");
INSERT INTO pibNT_vpl VALUES ("RM12_5","075_12_5","ROM","12","5","5","Waneko pixka wixa pamanepjewu Kristoya, ga wa pejnurunekwu pamanepjepsojitwu pimrineymananuko. ");
INSERT INTO pibNT_vpl VALUES ("RM12_6","075_12_6","ROM","12","6","6","Gi rixanu waneywu pnumnu gixachri genekashlu, rixyawakni wa gimutlewlu wenekikolu. Wa tokanchi geneklewatachinwu wixinri wane rixa yagotletka galixlu wixanupa, wanepotuko wixanu. ");
INSERT INTO pibNT_vpl VALUES ("RM12_7","075_12_7","ROM","12","7","7","Wa kamrurewatachri rixinri, wane rixa kamrurewletanu. Wa yimaklewatachri rixinri, wane rixa yimaklewletanu. ");
INSERT INTO pibNT_vpl VALUES ("RM12_8","075_12_8","ROM","12","8","8","Wa kgiykolewakleru wane rixa giykolewletanu. Geneka salewatachri machipetupni. Girukotlewatachri jmererupni. Kgetwamonreru rumuwleya renekashlewatanu. ");
INSERT INTO pibNT_vpl VALUES ("RM12_9","075_12_9","ROM","12","9","9","Gi gixasha galuklewletanu. Gagnanutanru mugletu. Kigleru gomkagitanu. ");
INSERT INTO pibNT_vpl VALUES ("RM12_10","075_12_10","ROM","12","10","10","Galuukakanu gixkakluko moletkakachine pixka. Satkaka gkagwakpirkakanu gixkakluko. ");
INSERT INTO pibNT_vpl VALUES ("RM12_11","075_12_11","ROM","12","11","11","Gi wa mmerenepgi. Xirnanshinikanutachinepgi. Gitsrukaachi wayegrenepgi. ");
INSERT INTO pibNT_vpl VALUES ("RM12_12","075_12_12","ROM","12","12","12","Gimjikachinepgi kagwaakaluruya. Gakotanshinikanutachinepgi nsalewninriya. Gomkagitanru gagjigognere. ");
INSERT INTO pibNT_vpl VALUES ("RM12_13","075_12_13","ROM","12","13","13","Gapikanna magatinrinwa kpashirine. Machipepjingognenanupgi. ");
INSERT INTO pibNT_vpl VALUES ("RM12_14","075_12_14","ROM","12","14","14","Giglenshinikanyegjixanna gkojwakjene. Giglenshinikanyegjixlewatanu. Gi gkamakpiirewatanu. ");
INSERT INTO pibNT_vpl VALUES ("RM12_15","075_12_15","ROM","12","15","15","Gimuwatanu wa gimuwatachineyma. Nchiyagatanu chiyagatachineyma. ");
INSERT INTO pibNT_vpl VALUES ("RM12_16","075_12_16","ROM","12","16","16","Panshinikanurunepgi. Gi galixkotinwa. Mpogireneymapgi. Gi wa kgimatkalewaklerune gkagwakanshinikanutinwa. ");
INSERT INTO pibNT_vpl VALUES ("RM12_17","075_12_17","ROM","12","17","17","Gi wa gapnutanru gektutu gixjeru gektutuya. Gkamrutanru kigleru pejnuruneko yine getanu. ");
INSERT INTO pibNT_vpl VALUES ("RM12_18","075_12_18","ROM","12","18","18","Rumkata wane gixkota, wa gixa gimkata wane gixletyawaka, kigle gwalepgi pejnuruneko yineyma. ");
INSERT INTO pibNT_vpl VALUES ("RM12_19","075_12_19","ROM","12","19","19","Nalukanune, gi gixananuko gapnuyegitinwa, seyni getashlewatanu jgekanchi waneyapa. Gi rixanu kayongalutkani, Gitanni gapnuuchipa. Gita gapnurewatanu, china wa Gitsrukaachi. ");
INSERT INTO pibNT_vpl VALUES ("RM12_20","075_12_20","ROM","12","20","20","Giyagni, wa nachichinipa wa pkamnixjeru peneka nikletanru. Ronunnagatewatinipa peneka giiretanru. Wane pixini chichmero pmoljiwutanru. ");
INSERT INTO pibNT_vpl VALUES ("RM12_21","075_12_21","ROM","12","21","21","Gi wa gektutu gaalixanyi seyni wa kigleruya paalixinri gektutu. ");
INSERT INTO pibNT_vpl VALUES ("RM13_1","075_13_1","ROM","13","1","1","Pejnuruneko yijnakotanna tsrukakalune gitaakalune. Gi rixanu maleshlu gitaakaluru, seyni Goyakalu gitakanrupjeni. Wanerune Goyakalu gitakna. ");
INSERT INTO pibNT_vpl VALUES ("RM13_2","075_13_2","ROM","13","2","2","Giyagni gitaakaluru yagotachri, Goyakalu gitakanru yagota. Ga wa yagotachine giklukanuwnayegkaknawa. ");
INSERT INTO pibNT_vpl VALUES ("RM13_3","075_13_3","ROM","13","3","3","Gi rixanu wa gitsrukaachine gi piikaklu kigleru kamrutachri, seyni gektutu kamrutachri galikaka. ¿Gi ge paluklu pma pikyanuplu tsru gitaakaluru? Kigleru pkamrutanu. Ralixkotanyi wale. ");
INSERT INTO pibNT_vpl VALUES ("RM13_4","075_13_4","ROM","13","4","4","Gi rixanu Goyakalu kamrurewyegitachrini kigleyyi pixinripa, seyni wa gektutu pkamrutini, pikanu. Gi rixanu gi wa maleshawaka raniklu yoglolewapi. Gi rixanu Goyakalu yegi kamrurewatyachrini. Wa gektutu kamrutachri kapnuklerni, saletikolupa gektutu kamrutachri. ");
INSERT INTO pibNT_vpl VALUES ("RM13_5","075_13_5","ROM","13","5","5","Giyagni gimkata yijnakletna gi wa jgekanchiyapje, seyni koxa muklukanuwnanshinikanutkane gixinripa. ");
INSERT INTO pibNT_vpl VALUES ("RM13_6","075_13_6","ROM","13","6","6","Gi rixanu waleya koxa gwenutlu girukotlewatachri gitakanru. Gi rixanu Goyakalu kamrurewyegitachine. Goyakalu koxa chinanu kamrurewatna wanna. ");
INSERT INTO pibNT_vpl VALUES ("RM13_7","075_13_7","ROM","13","7","7","Gapnutanna pejnuruneko gma mapnutanunnewa. Wa girukotlewatachine priwishkatini chiji chinanu, chiji gwenutinri, ga wa marnewlu chinanu, marnewlu gwenutinri. Katukta gmaga pikleta mpikanru. Katukta gmaga kagwakpiireta, gkagwakpiratanru. ");
INSERT INTO pibNT_vpl VALUES ("RM13_8","075_13_8","ROM","13","8","8","Gikeko griwishkatanu, seyni griwishka galuukakletanu gixkakluko. Gi rixanu rumwastsitanru galukachri poyagkaklu Tokanchi Yokanatkaluru. ");
INSERT INTO pibNT_vpl VALUES ("RM13_9","075_13_9","ROM","13","9","9","Gi rixanu: Gi pumopatlewatanu, gi puylalewatanu, gi pchowguwatanu, gi ksotanugopyi, ga wa wane chininipa satu yokanru koxa, tye tokanchi wanerutu rawa: Palukanru pumwastsitanru pixnanuko pixka. ");
INSERT INTO pibNT_vpl VALUES ("RM13_10","075_13_10","ROM","13","10","10","Wa galuklewlu gi wa gektutu rixlu rumwastsitanru. Giyagni galuklewlu poyagkaklu Tokanchi Yokanatkaluru. ");
INSERT INTO pibNT_vpl VALUES ("RM13_11","075_13_11","ROM","13","11","11","Wane gixanu gi rixanu gimatlu wa gogi, wa rapokatka gipapko wuyokinripa wumkinriya. Gi rixanu gi gowukatkalu xani wognewatinripa, walixinrigognepapko pnute. ");
INSERT INTO pibNT_vpl VALUES ("RM13_12","075_13_12","ROM","13","12","12","Goyechno giknogatka. Gogistsitkani. Giyagni koxa mapshagawaka kamrure wuknokanutka. Walpokotinwa pokamlalu kamrure chinanu. ");
INSERT INTO pibNT_vpl VALUES ("RM13_13","075_13_13","ROM","13","13","13","Gogi yanachine pixkawu wixa yanretanutka; kshinikanurunepwu; gi wa tsru niklu yegi gayanu, gi wa gimruyegiko, gi wa gapoklewluyempotunanuko, gi wa mpogijpatnuchyegiko, gi wa yangakakluyegiko, gi wa sotanugnuchiyegiko. ");
INSERT INTO pibNT_vpl VALUES ("RM13_14","075_13_14","ROM","13","14","14","Seyni Gitsrukaachi Geso Kristo gwanu. Gi wa galpokognaputanru giman