﻿USE sofia;
DROP TABLE IF EXISTS sofia.pga_vpl;
CREATE TABLE pga_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES pga_vpl WRITE;
INSERT INTO pga_vpl VALUES ("T11_1","084_1_1","1TI","1","1","1","Risala de min Bulus, rasul ta Yesuwa al Mesiya, aziluu be karar ta Rabuna mukalis ta nina wa Yesuwa al Mesiya al nina indu rajaa fogo uwo. ");
INSERT INTO pga_vpl VALUES ("T11_2","084_1_2","1TI","1","2","2","Risala de le Timoteo, jena tai al nesiya fi iman. Keli neima, rahama, wa salam min Rabuna al Abu wa Yesuwa al Mesiya, Sultan ta nina kun ma ita. ");
INSERT INTO pga_vpl VALUES ("T11_3","084_1_3","1TI","1","3","3","Ya Timoteo, zaman ana kaan gi ruwa fi Mudiriya ta Makedoniya, ana asalu ita ashan bi geni fi Efeso, ashan ita bi wodi karar le nas tanin ashan umon maa bi derisu deresa al maa sah. ");
INSERT INTO pga_vpl VALUES ("T11_4","084_1_4","1TI","1","4","4","Keli ita wori le umon ashan umon bi sibu gisat al maa min Rabuna wa kalamat ta judud al rusuu towil, al bes gi jibu afkar al maa indu faida wa munakasat. Kalamat al kida de maa gi saidu fi shokol ta Rabuna, al gi amuluu be iman. ");
INSERT INTO pga_vpl VALUES ("T11_5","084_1_5","1TI","1","5","5","Hadaf ta karar de yau muhaba, al gi ja min geliba nedif, wa fikra al kweis, wa iman al hagiga. ");
INSERT INTO pga_vpl VALUES ("T11_6","084_1_6","1TI","1","6","6","Nas tanin biga tala bara min kalamat del wa woduru sika ma wonusu kalamat al maa indu faida. ");
INSERT INTO pga_vpl VALUES ("T11_7","084_1_7","1TI","1","7","7","Umon deiru kun muderisin ta ganun ta Musa, lakin umon maa arufu kalam al umon gi derisu. Umon gi wonusu bidun kouf an kalamat al umon zatu maa arufu. ");
INSERT INTO pga_vpl VALUES ("T11_8","084_1_8","1TI","1","8","8","Nina arufu gali ganun kweis kan zol istamilu be teriga al kweis. ");
INSERT INTO pga_vpl VALUES ("T11_9","084_1_9","1TI","1","9","9","Nina kaman arufu gali ganun maa ashan bi hukumu nas al dukuri lakin did nas al gi kasuru ganun wa giladabin, nas al maa arufu Rabuna wa nas ta katiya, nas al maa kudusin wa nas al waskanin, nas al gi katulu abuhat wa umahat taumon, wa nas ta katulu nas. ");
INSERT INTO pga_vpl VALUES ("T11_10","084_1_10","1TI","1","10","10","Salau ganun did nas ta saalaga, rujal al gi num ma badun, nas al gi biyu insan bara, nas ta kidib, wa ta wodi suhuda al maa sah, au ay haja al maa wafigu ma deresa al hagiga. ");
INSERT INTO pga_vpl VALUES ("T11_11","084_1_11","1TI","1","11","11","Deresa de wafigu ma injil al Rabuna selimu le ana. Injil de gi wori shokol kebir ta Rabuna al mubarak. ");
INSERT INTO pga_vpl VALUES ("T11_12","084_1_12","1TI","1","12","12","Ana shukuru Yesuwa al Mesiya Sultan ta nina al wodi le ana guwa ashan bi amulu shokol tou. Uwo rudu ana zol al amin, wa uwo azilu ana ashan bi kadim le uwo. ");
INSERT INTO pga_vpl VALUES ("T11_13","084_1_13","1TI","1","13","13","Salakun ana kaan zol takiyan al taabu Yesuwa al Mesiya wa karabu suma bitou, lakin Rabuna amulu le ana rahama ashan ana kaan lisa maa aminu fi Yesuwa wa ana kaan maa arufu haja al ana gi amulu. ");
INSERT INTO pga_vpl VALUES ("T11_14","084_1_14","1TI","1","14","14","Wa Sultan ta nina wodi le ana neima bitou kifaya kalis ma iman wa muhaba fi Yesuwa al Mesiya. ");
INSERT INTO pga_vpl VALUES ("T11_15","084_1_15","1TI","1","15","15","Kalam de hagiga, keli nas kulu aminu fogo: Yesuwa al Mesiya ja fi duniya ashan kalisu nas ta katiya, wa ana yau zol ta katiya al futu umon kulu. ");
INSERT INTO pga_vpl VALUES ("T11_16","084_1_16","1TI","1","16","16","Lakin, ashan sabab de, Rabuna wori le ana rahama bitou. Uwo amulu zede ashan Yesuwa al Mesiya bi beinu sobur tou al azim be wasat tai, ana al katiya tai futu nas kulu. Ashan ana bi kun misal le nas kulu al baden bi aminu fi uwo wa ligo haya al abadiya. ");
INSERT INTO pga_vpl VALUES ("T11_17","084_1_17","1TI","1","17","17","Keli mejid wa ihtiram kun le Rabuna lel abad. Uwo yau melik al maa indu akir, al maa gi mutu, wa al maa gi ainuu. Uwo yau Rabuna al wahid bes. Amen. ");
INSERT INTO pga_vpl VALUES ("T11_18","084_1_18","1TI","1","18","18","Timoteo, jena tai, ana gi wodi le ita karar de hasab kalamat al anbiya kaan wonusu zamaan an ita, ashan be kalamat del ita bi agder amulu sakila al kweis. ");
INSERT INTO pga_vpl VALUES ("T11_19","084_1_19","1TI","1","19","19","Gobud iman taki gowi wa amulu haja al ita arufu gali uwo kweis fi gidam ta Rabuna. Nas tanin aba kalamat del wa umon demiru iman taumon. ");
INSERT INTO pga_vpl VALUES ("T11_20","084_1_20","1TI","1","20","20","Misal ta nas del yau Umenayo wa Alegzanda, al ana selimu umon le Shetan, de bi derisu umon ashan bi sibu wanasa al batal an Rabuna. ");
INSERT INTO pga_vpl VALUES ("T12_1","084_2_1","1TI","2","1","1","Gubal kulu haja, ana deiru ashan nas bi amulu salawat, wodi talab, kore ma geliba kulu, wa wodi shukur benyaba ta nas kulu. ");
INSERT INTO pga_vpl VALUES ("T12_2","084_2_2","1TI","2","2","2","Seli le muluk, wa le kulu nas al fi sulta. Seli ashan nina bi ish ma salam wa haya al birah, fi sika ta Rabuna wa be ihtiram nefsa. ");
INSERT INTO pga_vpl VALUES ("T12_3","084_2_3","1TI","2","3","3","Kalam de kweis, wa gi kutu Rabuna mukalis ta nina moksut. ");
INSERT INTO pga_vpl VALUES ("T12_4","084_2_4","1TI","2","4","4","Uwo deiru kulu nas ashan bi ligo kulasa wa ashan bi fahim haja al hagiga. ");
INSERT INTO pga_vpl VALUES ("T12_5","084_2_5","1TI","2","5","5","Leanu Rabuna fii wahid wa wahid zol al jibu salam bein Rabuna wa binadam, wa zol de uwo Yesuwa al Mesiya. ");
INSERT INTO pga_vpl VALUES ("T12_6","084_2_6","1TI","2","6","6","Uwo wodi nefsa tou ashan dafa taman ta huriya ta nas kulu. De suhuda al Rabuna wodi kalas fi zaman al uwo azilu. ");
INSERT INTO pga_vpl VALUES ("T12_7","084_2_7","1TI","2","7","7","Le sabab de, Rabuna azilu ana ashan bi kun mubashir wa rasul le nas al maa Yahudin. Ana muderis taumon wa ana gi derisu umon an iman wa hagiga ta injil. Ana gi wori kalam nesiya, ana maa gi kabasu. ");
INSERT INTO pga_vpl VALUES ("T12_8","084_2_8","1TI","2","8","8","Ashan kida, ana deiru rujal fi mahal kulu kede seli ma geliba nedif, bidun masakil au munakasat. ");
INSERT INTO pga_vpl VALUES ("T12_9","084_2_9","1TI","2","9","9","Be nefsa teriga, ana deiru nuswan kede libisu ma manzar al kweis, ma ihtiram, tamam wa aklag al kweis. Keli umon maa mesitu shaar ta dala, libisu alamat min dahab, au gumashat al gaali, wa hajat tanin ta dala. ");
INSERT INTO pga_vpl VALUES ("T12_10","084_2_10","1TI","2","10","10","Lakin keli nuswan al gi kelimu gali umon gi tabi sika ta Rabuna libisu nefsa taumon ma amail al kweis. ");
INSERT INTO pga_vpl VALUES ("T12_11","084_2_11","1TI","2","11","11","Keli mara alimu kalam birah wa asuma kalam. ");
INSERT INTO pga_vpl VALUES ("T12_12","084_2_12","1TI","2","12","12","Ana maa deiru mara ashan bi derisu au shilu sulta min rajil be guwa. Lakin keli hiya geni birah. ");
INSERT INTO pga_vpl VALUES ("T12_13","084_2_13","1TI","2","13","13","Ashan kalaguu Adam awal biga mara tou Hawa. ");
INSERT INTO pga_vpl VALUES ("T12_14","084_2_14","1TI","2","14","14","Wa maa kabasuu Adam lakin kabasuu mara tou wa hiya ja kun zol ta katiya. ");
INSERT INTO pga_vpl VALUES ("T12_15","084_2_15","1TI","2","15","15","Lakin mara bi ligo kulasa be wasat wilada ze Hawa, kan umon istemir fi iman, muhaba, wa haya ta kadasa, be hafizu nefsa. ");
INSERT INTO pga_vpl VALUES ("T13_1","084_3_1","1TI","3","1","1","Kalam de hagiga. Kan ay zol deiru kun zol kebir fi kenisa, uwo indu niya ta amulu shokol al kweis. ");
INSERT INTO pga_vpl VALUES ("T13_2","084_3_2","1TI","3","2","2","Ashan kida zol kebir ta kenisa lazim keli maa indu loum, keli uwo kun amin le mara tou, keli uwo geni birah, keli hafizu nefsa tou, indu ihtiram le nefsa tou, zol al gi rahibu nas, wa bi agder derisu. ");
INSERT INTO pga_vpl VALUES ("T13_3","084_3_3","1TI","3","3","3","Keli uwo maa kun sukuriji, au ta masakil, lakin zol ta salam, maa zol ta kore kore, au ta hibu gurush. ");
INSERT INTO pga_vpl VALUES ("T13_4","084_3_4","1TI","3","4","4","Lazim keli uwo ainu wara bet tou kweis, iyal tou keli asuma wa ihterem uwo. ");
INSERT INTO pga_vpl VALUES ("T13_5","084_3_5","1TI","3","5","5","Leanu kan zol maa agder ainu wara bet tou, uwo bi ainu wara kenisa ta Rabuna kef? ");
INSERT INTO pga_vpl VALUES ("T13_6","084_3_6","1TI","3","6","6","Keli uwo maa kun mesihi al jedid, ashan uwo maa bi kun indu kebir nefsa wa uwo bi ligo nefsa ikab ze Shetan. ");
INSERT INTO pga_vpl VALUES ("T13_7","084_3_7","1TI","3","7","7","Keli uwo kun zol al nas al bara min kenisa bi wonusu kalam kweis an uwo, ashan fadiya maa bi amulu uwo wa bi waga fi serik ta Shetan. ");
INSERT INTO pga_vpl VALUES ("T13_8","084_3_8","1TI","3","8","8","Be nefsa teriga, musaidin ta kenisa lazim keli indu ihtiram wa kun nesiya, keli maa asurubu merisa ketir, au garaman ma kalam ta gurush. ");
INSERT INTO pga_vpl VALUES ("T13_9","084_3_9","1TI","3","9","9","Keli umon hafizu deresa al hagiga ta injil ma fikra al kweis. ");
INSERT INTO pga_vpl VALUES ("T13_10","084_3_10","1TI","3","10","10","Shilu zaman ashan bi jeribu umon awal, wa biga kan umon najah kweis, keli umon istakal ze musaidin. ");
INSERT INTO pga_vpl VALUES ("T13_11","084_3_11","1TI","3","11","11","Be nefsa teriga, nuswan lazim kaman keli indu ihtiram, keli umon maa kun ta suwata, kun birah, wa nesiya fi ay haja. ");
INSERT INTO pga_vpl VALUES ("T13_12","084_3_12","1TI","3","12","12","Keli ay musaid ta kenisa kun amin le mara tou, keli uwo ainu wara iyal wa bet tou kweis. ");
INSERT INTO pga_vpl VALUES ("T13_13","084_3_13","1TI","3","13","13","Musaidin al gi amulu shokol fi kenisa kweis bi ligo ihtiram le nefsa taumon wa bi indu shuja ashan wonusu an iman taumon fi Yesuwa al Mesiya bidun kouf. ");
INSERT INTO pga_vpl VALUES ("T13_14","084_3_14","1TI","3","14","14","Ana deiru ja le ita guwam, lakin ana gi katibu le ita kalamat del ashan, ");
INSERT INTO pga_vpl VALUES ("T13_15","084_3_15","1TI","3","15","15","kan ana maa ja guwam, risala de bi saidu ita ashan arufu kef nas bi geni fi juwa ta Rabuna, al yau kenisa bita Rabuna al hai. Kenisa yau gi saidu hagiga ta injil ze amud wa asas ta juwa. ");
INSERT INTO pga_vpl VALUES ("T13_16","084_3_16","1TI","3","16","16","Nina kulu rudu gali deresa ta sika ta Rabuna uwo azim: Uwo ja fi shikil ta insan, roho wori uwo zol dukuri. Malaikat ainu uwo, nas bashiru kalam tou fi bilad kulu. Wa nas ta duniya aminu fi uwo, uwo futu fok fi mejid. ");
INSERT INTO pga_vpl VALUES ("T14_1","084_4_1","1TI","4","1","1","Roho al Kudus kaan kelimu wadi gali, fi akir zaman nas tanin bi waga min iman wa bi bada tabi aruwah al gi kabasu wa hajat al iblis gi derisu. ");
INSERT INTO pga_vpl VALUES ("T14_2","084_4_2","1TI","4","2","2","Deresa del gi ja min nas al gi wonusu kidib al saab, al afkar taumon meit ze araguu be hadid al sukun ashan umon maa indu fadiya. ");
INSERT INTO pga_vpl VALUES ("T14_3","084_4_3","1TI","4","3","3","Umon gi abusu nas min zawaj wa min akulu akil tanin al Rabuna kalagu ashan bi akuluu ma wodi shukur, be nas al aminu fi Rabuna wa arufu hagiga. ");
INSERT INTO pga_vpl VALUES ("T14_4","084_4_4","1TI","4","4","4","Leanu kulu akil al Rabuna kalagu umon kweis wa nedif. Keli nina maa aba akil tanin lakin keli nina akulu umon ma wodi shukur, ");
INSERT INTO pga_vpl VALUES ("T14_5","084_4_5","1TI","4","5","5","ashan kilima ta Rabuna wa salawat kutu uwo nedif. ");
INSERT INTO pga_vpl VALUES ("T14_6","084_4_6","1TI","4","6","6","Ya Timoteo, asuma kalam al ana gi wonusu le ita wa derisu kalam de le muminin. Kan ita amulu kida, ita bi kun kidam al kweis ta Yesuwa al Mesiya wa ita bi raba fi kilima bita iman wa deresa al kweis al ita bada tabi kalas. ");
INSERT INTO pga_vpl VALUES ("T14_7","084_4_7","1TI","4","7","7","Mata kutu bal fi gisat al maa min Rabuna wa wanasat al maa indu faida, lakin keli ita deribu nefsa taki fi teriga ta Rabuna. ");
INSERT INTO pga_vpl VALUES ("T14_8","084_4_8","1TI","4","8","8","Riaada ta gisim gi wodi faida sweya, lakin tedrib fi sika ta Rabuna gi wodi faida fi kulu hajat, ashan uwo indu faida le haya al hasa wa haya al jai. ");
INSERT INTO pga_vpl VALUES ("T14_9","084_4_9","1TI","4","9","9","Kalam de hagiga, keli nas kulu aminu fogo. ");
INSERT INTO pga_vpl VALUES ("T14_10","084_4_10","1TI","4","10","10","De yau sabab, nina gi istakal shedid wa gi derdeg, ashan nina kalas kutu rajaa ta nina fi Rabuna al hai. Uwo yau mukalis ta nas kulu wa kasatan nas al aminu. ");
INSERT INTO pga_vpl VALUES ("T14_11","084_4_11","1TI","4","11","11","Wodi le muminin karar wa derisu hajat del. ");
INSERT INTO pga_vpl VALUES ("T14_12","084_4_12","1TI","4","12","12","Keli zol tani maa alisu shokol shabab taki, lakin kun misal le muminin fi wanasa taki, aklag taki, muhaba taki, iman taki, wa haya taki al nedif. ");
INSERT INTO pga_vpl VALUES ("T14_13","084_4_13","1TI","4","13","13","Wodi nefsa taki ashan agara kitab al mukadas le nas, sheja nas, wa derisu lahadi fi zaman ana bi ja. ");
INSERT INTO pga_vpl VALUES ("T14_14","084_4_14","1TI","4","14","14","Mata alisu gudra al ita indu, al wodii le ita be wasat kilima ta anbiya wokit nas kubar ta kenisa kutu iden taumon fi ras taki. ");
INSERT INTO pga_vpl VALUES ("T14_15","084_4_15","1TI","4","15","15","Amulu hajat del wa wodi nefsa taki kulu fogo, ashan nas kulu bi agder ainu najah bitak. ");
INSERT INTO pga_vpl VALUES ("T14_16","084_4_16","1TI","4","16","16","Kutu bal kweis kef ita bi ish haya bitak wa deresa taki. Istemir ma kalam de, ashan kan ita amulu kida, ita bi ligo kulasa le nefsa taki wa nas al gi asuma ita. ");
INSERT INTO pga_vpl VALUES ("T15_1","084_5_1","1TI","5","1","1","Mata wonusu be zalan le rajil al ajus lakin wonusu le uwo birah ze abu taki. Wonusu le shabab ze ita bi wonusu le akwana taki. ");
INSERT INTO pga_vpl VALUES ("T15_2","084_5_2","1TI","5","2","2","Wonusu le nuswan al ajusin ze umahat taki, wa le nuswan al sukerin ze ikwat taki. Amulu ma geliba nedif. ");
INSERT INTO pga_vpl VALUES ("T15_3","084_5_3","1TI","5","3","3","Ainu wara ta aramil al nesiya maa indu zol. ");
INSERT INTO pga_vpl VALUES ("T15_4","084_5_4","1TI","5","4","4","Lakin kan armala tani indu iyal, keli umon ainu wara tou. Ashan kalam de kweis le Rabuna. Wa be teriga de, umon bi agder dafa wara le nas al weledu umon. De bi kutu Rabuna moksut. ");
INSERT INTO pga_vpl VALUES ("T15_5","084_5_5","1TI","5","5","5","Armala al nesiya, al maa indu ahal, gi kutu rajaa tou fi Rabuna. Hiya gi seli bilel wa nahar gi asalu Rabuna ashan musada. ");
INSERT INTO pga_vpl VALUES ("T15_6","084_5_6","1TI","5","6","6","Lakin armala al gi wodi nefsa tou le faraha ta duniya, hiya meit fi roho salakun hiya hai. ");
INSERT INTO pga_vpl VALUES ("T15_7","084_5_7","1TI","5","7","7","Wodi le nas ta kenisa kararat del, ashan umon maa bi amulu galat. ");
INSERT INTO pga_vpl VALUES ("T15_8","084_5_8","1TI","5","8","8","Ay zol al maa gi ainu wara ahal bitou, kasatan bet bitou, de be mana uwo aba iman wa uwo batal kalis min zol al maa mumin. ");
INSERT INTO pga_vpl VALUES ("T15_9","084_5_9","1TI","5","9","9","Mata sejilu ay mara al armala fi mojmou ta aramil al kenisa bi saidu, ile kan umur tou timu sitiin sena, wa hiya kaan amin le rajil tou, ");
INSERT INTO pga_vpl VALUES ("T15_10","084_5_10","1TI","5","10","10","wa arufuu hiya zol ta amulu hajat kweis: ze raba iyal, rahibu nas, saidu nas ta Rabuna, saidu nas al fi masakil, wa wodi nefsa fi amulu hajat al kweis. ");
INSERT INTO pga_vpl VALUES ("T15_11","084_5_11","1TI","5","11","11","Lakin mata sejilu aramil al lisa sukerin, ashan niya ta gisim taumon bi juru umon bara min Mesiya, wa umon bi deiru jouzu tani. ");
INSERT INTO pga_vpl VALUES ("T15_12","084_5_12","1TI","5","12","12","Wa umon bi kun galatin ashan umon kasaru waad al umon amulu bedri fi wokit ta tasjil ze armala. ");
INSERT INTO pga_vpl VALUES ("T15_13","084_5_13","1TI","5","13","13","Kan ita sejilu umon kaman, umon bi tala fadi shokol wa umon bi daya zaman taumon ma douru min bet le bet be wonusu suwata, dakalu fi kalamat ta nas tanin, wa wonusu kalamat al maa kweis. ");
INSERT INTO pga_vpl VALUES ("T15_14","084_5_14","1TI","5","14","14","Ashan kida, ana deiru aramil al sukerin kede jouzu, ashan umon bi weledu iyal, wa ainu wara biyut taumon. Kede umon maa sibu fursa le Shetan ashan bi wonusu hajat batal did nas ta Rabuna. ");
INSERT INTO pga_vpl VALUES ("T15_15","084_5_15","1TI","5","15","15","Ashan aramil tanin waga min iman kalas wa gi ruwa wara Shetan. ");
INSERT INTO pga_vpl VALUES ("T15_16","084_5_16","1TI","5","16","16","Kan ay mara al mumin indu ahal al armala, kede hiya ainu wara tou, kede maa kutu mosuliya tou fi ras kenisa, ashan kenisa bi ainu wara aramil al nesiya al maa indu ay zol. ");
INSERT INTO pga_vpl VALUES ("T15_17","084_5_17","1TI","5","17","17","Nas kubar ta kenisa al gi amulu shokol taumon kweis, kede wodii le umon ihtiram wa kede dafau umon kweis, kasatan del al gi bashiru wa gi derisu shedid. ");
INSERT INTO pga_vpl VALUES ("T15_18","084_5_18","1TI","5","18","18","Ashan kitab al mukadas kelimu gali, “Mata robutu kasma ta tor kan uwo gi nedifu dura,” wa “Zol al shakal kede dafau.” ");
INSERT INTO pga_vpl VALUES ("T15_19","084_5_19","1TI","5","19","19","Mata kutu bal le ay zol al gi isteki zol kebir ta kenisa ile kan fii “Itnin au talata suhudin.” ");
INSERT INTO pga_vpl VALUES ("T15_20","084_5_20","1TI","5","20","20","Lakin kan zol kebir ta kenisa al gi amulu katiya, adilu uwo fi gidam nas kulu, ashan tanin bi kafu. ");
INSERT INTO pga_vpl VALUES ("T15_21","084_5_21","1TI","5","21","21","Ana gi asalu ita, fi gidam ta Rabuna wa Yesuwa al Mesiya wa malaikat al aziluu, ashan bi hafizu gawanin del. Gata gediya dukuri, mata amulu tefriga au tegsim. ");
INSERT INTO pga_vpl VALUES ("T15_22","084_5_22","1TI","5","22","22","Mata kun mustajil ashan bi kutu iden fi ras zol ashan bi kun zol kebir ta kenisa. Kan ita amulu kida, ita bi dakalu fi katiya ta nas tanin. Ashan kida, hafizu geliba taki nedif. ");
INSERT INTO pga_vpl VALUES ("T15_23","084_5_23","1TI","5","23","23","Mata asurubu moya bes, lakin asurubu kamra sweya ashan bi saidu batna taki ashan ita bad marat ayan. ");
INSERT INTO pga_vpl VALUES ("T15_24","084_5_24","1TI","5","24","24","Katiya tanin gi beinu tawali wa gi shilu zol al amulu katiya de fi gediya. Lakin katiya tanin bi beinu baden. ");
INSERT INTO pga_vpl VALUES ("T15_25","084_5_25","1TI","5","25","25","Be nefsa teriga, amail tanin al kweis gi beinu tawali, wa amail tanin al kweis, salakun umon maa gi beinu, umon lisa bi beinu baden. ");
INSERT INTO pga_vpl VALUES ("T16_1","084_6_1","1TI","6","1","1","Abiid kulu kede wodi ihtiram kamil le seyid taumon ashan nas maa bi agder wonusu batal an isim ta Rabuna wa deresa bitou ");
INSERT INTO pga_vpl VALUES ("T16_2","084_6_2","1TI","6","2","2","Abiid al seyid taumon muminin lazim kede maa amulu adam ihtiram le umon, ashan umon akwana. Lakin kede umon kadim le seyid taumon shedid ashan nas al gi istefid min shokol taumon al kweis yau muminin al hibuu. Keli ita sheja wa derisu hajat del. ");
INSERT INTO pga_vpl VALUES ("T16_3","084_6_3","1TI","6","3","3","Kan ay muderis gi derisu deresa al maa sah wa kan uwo maa gi tifagu ma deresa al hagiga ta Sultan bita nina Yesuwa al Mesiya au ma deresa al fi sika ta Rabuna, ");
INSERT INTO pga_vpl VALUES ("T16_4","084_6_4","1TI","6","4","4","uwo maliyan ma dala wa maa gi fahim ay haja. Uwo indu niya batal ta munakasat wa kore kore an kilimat. Kalamat del gi jibu tama, masakil, sitima, wa fikra al batal. ");
INSERT INTO pga_vpl VALUES ("T16_5","084_6_5","1TI","6","5","5","Nas del daiman gi jibu masakil. Afkar taumon maa kweis, umon kalas tala bara min kalam al hagiga. Umon fekiru gali sika ta Rabuna yau teriga ta ligo mali. ");
INSERT INTO pga_vpl VALUES ("T16_6","084_6_6","1TI","6","6","6","Lakin haya fi sika ta Rabuna ma geliba kweis yau zatu mali al kebir. ");
INSERT INTO pga_vpl VALUES ("T16_7","084_6_7","1TI","6","7","7","Ashan nina maa jibu ay haja fi duniya, wa nina maa bi shilu ay haja min duniya. ");
INSERT INTO pga_vpl VALUES ("T16_8","084_6_8","1TI","6","8","8","Lakin kan nina indu akil wa gumash, del bi kun kifaya le nina. ");
INSERT INTO pga_vpl VALUES ("T16_9","084_6_9","1TI","6","9","9","Nas al deiru tala ganiyanin gi waga fi tejriba, serek, wa niya ta hajat al maa indu faida, al gi amulu umon batal wa gi shilu umon fi taab wa gi demiru haya taumon. ");
INSERT INTO pga_vpl VALUES ("T16_10","084_6_10","1TI","6","10","10","Hibuu gurush kalis yau sabab ta kulu no ta hajat batal. Nas al hibu gurush kalis, woduru min iman kalas wa gulub taumon gi taab ma waja ketir. ");
INSERT INTO pga_vpl VALUES ("T16_11","084_6_11","1TI","6","11","11","Lakin ita, ya Timoteo, ashan ita zol ta Rabuna, wasa bara min kulu hajat del, wa ruwa wara kalam al dukuri, sika ta Rabuna, iman, muhaba, sobur, wa kun birah. ");
INSERT INTO pga_vpl VALUES ("T16_12","084_6_12","1TI","6","12","12","Amulu sakila al kweis ta iman. Wogifu gowi fi sika bita haya al abadiya al Rabuna kaan nadi ita wokit ita wodi suhuda bitak al kweis fi gidam suhudin ketir. ");
INSERT INTO pga_vpl VALUES ("T16_13","084_6_13","1TI","6","13","13","Ana wodi le ita karar fi gidam ta Rabuna, al gi wodi haya le hajat kulu, wa gidam Yesuwa al Mesiya, al wodi suhuda kweis fi gidam Pontio Pilato: ");
INSERT INTO pga_vpl VALUES ("T16_14","084_6_14","1TI","6","14","14","Hafizu ganun ta Rabuna bidun wasaka au galat lahadi zaman Sultan ta nina, Yesuwa al Mesiya bi beinu. ");
INSERT INTO pga_vpl VALUES ("T16_15","084_6_15","1TI","6","15","15","Rabuna bi zahiru uwo fi zaman al munasib, uwo al mubarak wa haakim al wahid, Melik ta muluk wa Sultan ta salatin, ");
INSERT INTO pga_vpl VALUES ("T16_16","084_6_16","1TI","6","16","16","Uwo yau bes indu haya al bidun nihaya. Uwo gi ish fi nur al lama zol maa bi agder wosulu gerib ma nur de, Mafi zol ainu uwo gubal kida au bi agder ainu uwo. Ihtiram wa guwa kede kun le uwo lel abad, Amen! ");
INSERT INTO pga_vpl VALUES ("T16_17","084_6_17","1TI","6","17","17","Wori le nas al ganiyanin fi zaman al hasa gali, kede umon maa kebir nefsa taumon au kutu rajaa taumon fi hajat ta duniya, al maa indu damana. Lakin kede umon kutu rajaa taumon fi Rabuna, al yau gi wodi majani le nina ay haja ashan nina bi indu faraha. ");
INSERT INTO pga_vpl VALUES ("T16_18","084_6_18","1TI","6","18","18","Wori le nas al ganiyanin ashan bi amulu kalam al kweis, keli umon kun maliyanin be amail al kweis, keli umon wodi haja ma geliba kulu wa keli umon kun jahizin ashan bi isterik ma masakin. ");
INSERT INTO pga_vpl VALUES ("T16_19","084_6_19","1TI","6","19","19","Be teriga de umon bi kazinu mali al nesiya le nefsa taumon ze asas al gowi al indu damana le mustagbal, wa umon bi ligo haya al nesiya. ");
INSERT INTO pga_vpl VALUES ("T16_20","084_6_20","1TI","6","20","20","Ya Timoteo, hafizu haja al Rabuna selimu le ita kweis. Wasa bara min wanasat al maa indu faida wa munakasat al farik ma nas al gi aridu ita be kalam al umon gi nadi marafa, lakin uwo maa marafa al hagiga. ");
INSERT INTO pga_vpl VALUES ("T16_21","084_6_21","1TI","6","21","21","Nas del kalas gi tabi marafa de wa be teriga de umon waga min iman. Keli neima ta Rabuna kun ma itakum.");
INSERT INTO pga_vpl VALUES ("T21_1","085_1_1","2TI","1","1","1","Risala de min Bulus. Rabuna azilu ana ashan bi kun rasul bita Yesuwa al Mesiya, ashan ana bi wori le nas an haya al uwo waad fi Yesuwa al Mesiya. ");
INSERT INTO pga_vpl VALUES ("T21_2","085_1_2","2TI","1","2","2","Risala de le Timoteo, jena tai al ana hibu. Keli neima, rahama, wa salam min Rabuna al Abu wa Sultan ta nina Yesuwa al Mesiya kun ma ita. ");
INSERT INTO pga_vpl VALUES ("T21_3","085_1_3","2TI","1","3","3","Ana gi shukuru Rabuna ashan kalam bitak, Rabuna al ana gi kadim ma geliba nedif, ze judud tai kaan amulu. Ana daiman gi zekiru ita fi salawat tai bilel wa nahar. ");
INSERT INTO pga_vpl VALUES ("T21_4","085_1_4","2TI","1","4","4","Ana gi fekiru shedid ashan bi ainu ita wa ana gi zekiru kore taki wokit ana ferigu ma ita. Ana bi kun moksut kan nina limu tani. ");
INSERT INTO pga_vpl VALUES ("T21_5","085_1_5","2TI","1","5","5","Ana kaman zekiru iman bitak al hagiga, nefsa iman de abuba taki Lois wa uma taki Yunis indu. Wa ana mutaakid ita kaman indu iman de. ");
INSERT INTO pga_vpl VALUES ("T21_6","085_1_6","2TI","1","6","6","Le sabab de ana gi zekiru ita ashan bi istamil hadiya al Rabuna wodi le ita wa kutu hadiya de kun hai. Hadiya al ita ligo wokit ana kutu ida tai fi ras taki. ");
INSERT INTO pga_vpl VALUES ("T21_7","085_1_7","2TI","1","7","7","Ashan Rabuna maa wodi le nina roho ta kouf, lakin roho ta guwa, ta muhaba, wa ta hafizu nefsa. ");
INSERT INTO pga_vpl VALUES ("T21_8","085_1_8","2TI","1","8","8","Ashan kida mata kun ma fadiya ashan kalam ta Sultan ta nina au ana al mobus ashan kalam bitou. Lakin isterik ma ana fi taab ashan kalam ta injil be guwa al Rabuna wodi le ita. ");
INSERT INTO pga_vpl VALUES ("T21_9","085_1_9","2TI","1","9","9","Leanu Rabuna kalisu nina wa nadii nina ashan ish haya al kudus. Uwo amulu de, maa ashan amail al kweis ta nina lakin ashan kuta bitou wa neima, al uwo wodi le nina fi Yesuwa al Mesiya gubal maa kalagu duniya. ");
INSERT INTO pga_vpl VALUES ("T21_10","085_1_10","2TI","1","10","10","Lakin hasa uwo kalas zahiru kuta bitou le nina be wasat ja ta mukalis ta nina Yesuwa al Mesiya. Uwo demiru guwa ta mut, wa uwo kaman jibu haya al abadiya be wasat injil. ");
INSERT INTO pga_vpl VALUES ("T21_11","085_1_11","2TI","1","11","11","Rabuna azilu ana mubashir, rasul, wa muderis ta injil de. ");
INSERT INTO pga_vpl VALUES ("T21_12","085_1_12","2TI","1","12","12","Wa de sabab ana gi taab ini fi sijin. Lakin fadiya maa gi amulu ana ma kalam de, ashan ana arufu kweis zol al ana aminu fi uwo. Wa ana arufu gali uwo bi agder hafizu haja al ana wodi le uwo kweis lahadi yom dak. ");
INSERT INTO pga_vpl VALUES ("T21_13","085_1_13","2TI","1","13","13","Hafizu deresa al hagiga al ana derisu le ita ze misal, deresa al ita alimu min ana ma iman wa muhaba fi Yesuwa al Mesiya. ");
INSERT INTO pga_vpl VALUES ("T21_14","085_1_14","2TI","1","14","14","Hafizu kweis haja al Rabuna wodi le ita, be wasat guwa ta Roho al Kudus al gi ish fi nina. ");
INSERT INTO pga_vpl VALUES ("T21_15","085_1_15","2TI","1","15","15","Zema ita arufu, kulu nas al fi Mudiriya ta Asiya al Suker aba ana. Misal ta nas del yau Fugelo wa Erumogene. ");
INSERT INTO pga_vpl VALUES ("T21_16","085_1_16","2TI","1","16","16","Kede Sultan beinu rahama le bet bita Onesiforo, ashan uwo kaan daiman gi sheja ana, wa uwo maa indu fadiya ashan ana mobus ashan kalam ta Yesuwa. ");
INSERT INTO pga_vpl VALUES ("T21_17","085_1_17","2TI","1","17","17","Lakin wokit uwo wosulu fi Roma, uwo fetisu ana shedid wa uwo ligo ana. ");
INSERT INTO pga_vpl VALUES ("T21_18","085_1_18","2TI","1","18","18","Kede uwo ligo rahama min Sultan fi yom dak! Wa ita arufu kef uwo saidu ana fi Efeso. ");
INSERT INTO pga_vpl VALUES ("T22_1","085_2_1","2TI","2","1","1","Ashan kida Timoteo jena tai, kun gowi be wasat neima fi Yesuwa al Mesiya. ");
INSERT INTO pga_vpl VALUES ("T22_2","085_2_2","2TI","2","2","2","Ita asuma kalamat al ana derisu le nas ketir. Umon kaman bi agder wori kalam de. Min hasa keli ita derisu hajat del le nas al aminin al bi agder derisu nas tanin. ");
INSERT INTO pga_vpl VALUES ("T22_3","085_2_3","2TI","2","3","3","Dumu ma ana fi taab de, ze askeri al kweis ta Yesuwa al Mesiya. ");
INSERT INTO pga_vpl VALUES ("T22_4","085_2_4","2TI","2","4","4","Askeri al gi amulu shokol bitou, deiru kutu kaid bitou moksut wa uwo maa deiru lakbatu nefsa tou fi kalam ta muatinin. ");
INSERT INTO pga_vpl VALUES ("T22_5","085_2_5","2TI","2","5","5","Ay zol al gi jere sabak sabak maa bi ligo hadiya ile kan uwo ihtiram gawanin ta jere jere. ");
INSERT INTO pga_vpl VALUES ("T22_6","085_2_6","2TI","2","6","6","Muzare al gi istakal shedid uwo kede kun awal zol ashan bi akulu hajat ta jinena tou. ");
INSERT INTO pga_vpl VALUES ("T22_7","085_2_7","2TI","2","7","7","Fekir an kalam al ana gi kelimu, ashan Rabuna bi wodi le ita tafahim fi kulu kalam. ");
INSERT INTO pga_vpl VALUES ("T22_8","085_2_8","2TI","2","8","8","Zekiru Yesuwa al Mesiya, al min usra ta Dawud, uwo gum min mutu. De yau injil al ana gi bashiru. ");
INSERT INTO pga_vpl VALUES ("T22_9","085_2_9","2TI","2","9","9","Ashan kida, ana gi taab wa genziruu ana ze zol mujrim. Lakin kilima ta Rabuna maa bi genziruu. ");
INSERT INTO pga_vpl VALUES ("T22_10","085_2_10","2TI","2","10","10","Le sabab de, ana gi sobur fi kulu hajat ashan kalam bita nas ta Rabuna al aziluu, ashan umon kaman bi ligo kulasa fi Yesuwa al Mesiya wa mejid al maa indu nihaya. ");
INSERT INTO pga_vpl VALUES ("T22_11","085_2_11","2TI","2","11","11","Kalam de hagiga: Kan nina mutu ma uwo fi mamudiya, nina kaman bi ish ma uwo, ");
INSERT INTO pga_vpl VALUES ("T22_12","085_2_12","2TI","2","12","12","kan nina indu sobur, nina kaman bi hukumu ma uwo. Kan nina aba uwo, uwo kaman bi aba nina. ");
INSERT INTO pga_vpl VALUES ("T22_13","085_2_13","2TI","2","13","13","Kan nina maa aminin, uwo daiman amin, ashan uwo maa bi aba nefsa tou. ");
INSERT INTO pga_vpl VALUES ("T22_14","085_2_14","2TI","2","14","14","Zekiru umon an kalamat del. Wodi le umon inzar fi gidam Rabuna ashan bi sibu kore kore an kilimat, leanu uwo maa indu faida wa uwo gi demiru nas al gi asuma. ");
INSERT INTO pga_vpl VALUES ("T22_15","085_2_15","2TI","2","15","15","Hawil shedid ashan ita bi kutu Rabuna moksut, ashan fadiya maa bi amulu ita kan ita ja fi gidam tou. Wa fasir kalam ta Rabuna al hagiga be teriga al kweis. ");
INSERT INTO pga_vpl VALUES ("T22_16","085_2_16","2TI","2","16","16","Keli ita wasa bara min wanasa al waskan wa kalam farik, leanu nas al amulu zede gi ruwa beyid min sika ta Rabuna. ");
INSERT INTO pga_vpl VALUES ("T22_17","085_2_17","2TI","2","17","17","Deresat taumon del ze marad al saab gi setetu fi gisim ta zol kulu. Misal ta nas del yau Umenayo wa Fileto. ");
INSERT INTO pga_vpl VALUES ("T22_18","085_2_18","2TI","2","18","18","Umon sibu kalam al hagiga. Umon gi kelimu gali giyama ta nas al mutu hasil kalas, wa umon gi demiru iman bita nas tanin. ");
INSERT INTO pga_vpl VALUES ("T22_19","085_2_19","2TI","2","19","19","Lakin asas al sabit ta Rabuna wogif gowi. Katibuu fogo gali, “Sultan arufu nas bitou,” wa, “Nas kulu al gi nadi isim ta Sultan kede wasa bara min kalam batal.” ");
INSERT INTO pga_vpl VALUES ("T22_20","085_2_20","2TI","2","20","20","Fi juwa kebir fii afasat maa bes ta dahab wa fida, lakin kaman min kashab wa tin. Afas tanin ta shokol al mohim wa tanin ta shokol al adi. ");
INSERT INTO pga_vpl VALUES ("T22_21","085_2_21","2TI","2","21","21","Biga, kan ay zol gi kutu nefsa tou nedif min hajat al waskan, uwo bi kun ze afas ta shokol al mohim, uwo kudus kalas, mohim le seyid bitou wa jahiz le ay shokol al kweis. ");
INSERT INTO pga_vpl VALUES ("T22_22","085_2_22","2TI","2","22","22","Ya Timoteo, wasa bara min niyat al batal ta shokol shabab. Fetisu haya al adil, iman, muhaba wa salam, sawa ma nas al gi nadi Sultan min geliba al nedif. ");
INSERT INTO pga_vpl VALUES ("T22_23","085_2_23","2TI","2","23","23","Mata dakalu fi wanasat al maa indu faida wa kalam farik, ashan ita arufu umon gi jibu kore-kore. ");
INSERT INTO pga_vpl VALUES ("T22_24","085_2_24","2TI","2","24","24","Kadam bita Sultan kede maa kore kore lakin kede kun teib le nas kulu, wa bi agder derisu kweis, wa kede indu sobur ma nas al saabin. ");
INSERT INTO pga_vpl VALUES ("T22_25","085_2_25","2TI","2","25","25","Wonusu birah le nas al gi aridu hagiga, imkin Rabuna bi geiru gulub ta nas del, wa umon bi tub wa alimu kalam al hagiga. ");
INSERT INTO pga_vpl VALUES ("T22_26","085_2_26","2TI","2","26","26","Biga umon bi bada fekir kweis wa umon bi nofud min serik ta Shetan, al kaan gobudu umon mobus ashan amulu irada tou. ");
INSERT INTO pga_vpl VALUES ("T23_1","085_3_1","2TI","3","1","1","Ya Timoteo, ana deiru keli ita arufu gali fi ayam al akir taab bi kun ketir. ");
INSERT INTO pga_vpl VALUES ("T23_2","085_3_2","2TI","3","2","2","Nas bi hibu nefsa taumon, umon bi hibu gurush, umon bi dala, umon bi kun takiyanin, umon bi sitimu, umon maa bi ihterem nas al weledu umon, umon maa bi shukur, wa umon maa bi indu din. ");
INSERT INTO pga_vpl VALUES ("T23_3","085_3_3","2TI","3","3","3","Umon maa bi indu rahama, umon maa bi afi, umon bi amulu suwata, umon maa bi hafizu nefsa, umon maa bi indu maruf, wa umon maa bi hibu saidu nas. ");
INSERT INTO pga_vpl VALUES ("T23_4","085_3_4","2TI","3","4","4","Umon bi biyu akwana taumon bara, umon maa bi himu, umon bi indu kebir nefsa, wa umon bi hibu faraha ta duniya ziyada min Rabuna. ");
INSERT INTO pga_vpl VALUES ("T23_5","085_3_5","2TI","3","5","5","Umon gi zahiru ze nas al arufu Rabuna, lakin umon gi aba guwa tou ashan bi geiru haya taumon. Wasa bara min nas zede. ");
INSERT INTO pga_vpl VALUES ("T23_6","085_3_6","2TI","3","6","6","Nas tanin min umon gi dakalu fi biyut ta nas wa umon gi amulu shokol sabi sabi ma nuswan al deyifin, tabanin min tegila ta katiya taumon wa niyat ketir al batal gi shilu umon bara. ");
INSERT INTO pga_vpl VALUES ("T23_7","085_3_7","2TI","3","7","7","Nuswan al kida de daiman gi tabi deresa al jedid, lakin umon maa agder fahim kalam al hagiga. ");
INSERT INTO pga_vpl VALUES ("T23_8","085_3_8","2TI","3","8","8","Muderisin del gi aridu kalam al hagiga bes ze Yane wa Yambere kaan aridu Musa. Nas al fikra taumon maa gi istakal kweis wa umon maa indu iman al hagiga. ");
INSERT INTO pga_vpl VALUES ("T23_9","085_3_9","2TI","3","9","9","Muderisin del maa bi agder ruwa beyid, yom tani nas kulu bi arufu shokol belid taumon, bes ze kaan hasil le Yane wa Yambere. ");
INSERT INTO pga_vpl VALUES ("T23_10","085_3_10","2TI","3","10","10","Lakin ya Timoteo, ita arufu deresat bitai, aklag tai, hadaf ta haya tai, iman tai, muhaba tai, wa sobur tai. ");
INSERT INTO pga_vpl VALUES ("T23_11","085_3_11","2TI","3","11","11","Ita arufu kaman taab wa waja al ana ligo fi medina ta Antiokiya, Ikoniyo, wa Lustura. Ana kaan sobur fi taab de, wa Sultan nofud ana min umon kulu. ");
INSERT INTO pga_vpl VALUES ("T23_12","085_3_12","2TI","3","12","12","Nesiya, nas kulu al deiru ish haya ta Rabuna fi Yesuwa al Mesiya bi ligo taab ashan kalam ta injil. ");
INSERT INTO pga_vpl VALUES ("T23_13","085_3_13","2TI","3","13","13","Lakin nas al batalin wa al mumesilin bi ruwa min batal le batal kalis, umon gi kabasu badun. ");
INSERT INTO pga_vpl VALUES ("T23_14","085_3_14","2TI","3","14","14","Lakin ya Timoteo, keli ita istemir ma deresat al ita alimu wa al ita arufu gali umon nesiya, leanu ita arufu ita ligo deresat del min munu. ");
INSERT INTO pga_vpl VALUES ("T23_15","085_3_15","2TI","3","15","15","Ita ligo deresat min kitab al mukadas miin ita suker, wa kitab de gi wodi le ita hikma ashan ita bi ligo kulasa be wasat iman taki fi Yesuwa al Mesiya. ");
INSERT INTO pga_vpl VALUES ("T23_16","085_3_16","2TI","3","16","16","Kulu kalam al fi kitab al mukadas gi ja min Rabuna wa umon mohim ashan taalim, taadil, taadib, wa ta tedrib ta haya al dukuri. ");
INSERT INTO pga_vpl VALUES ("T23_17","085_3_17","2TI","3","17","17","Be teriga de, kadam ta Rabuna bi kun jahiz ashan bi istakal kulu shokol al kweis. ");
INSERT INTO pga_vpl VALUES ("T24_1","085_4_1","2TI","4","1","1","Ana gi asalu ita fi gidam ta Rabuna wa Yesuwa al Mesiya, al bi hukumu nas kulu al hai wa al mutu, wa de bi hasil fi yom al uwo bi rija fogo wa asisu malakut bitou: ");
INSERT INTO pga_vpl VALUES ("T24_2","085_4_2","2TI","4","2","2","Bashiru kilima ta Rabuna. Keli ita kun jahiz, kan fi wokit al kweis wa al batal. Adilu, adibu, wa sheja nas be deresa al kweis be sobur. ");
INSERT INTO pga_vpl VALUES ("T24_3","085_4_3","2TI","4","3","3","Leanu zaman bi ja al nas maa bi rudu asuma le deresa al hagiga. Lakin umon bi azilu muderisin hasab niyat taumon, muderisin de bi wori le umon kalam al adana taumon deiru asuma. ");
INSERT INTO pga_vpl VALUES ("T24_4","085_4_4","2TI","4","4","4","Umon bi aba asuma kalam al hagiga wa bi ruwa wara gisat al maa min Rabuna. ");
INSERT INTO pga_vpl VALUES ("T24_5","085_4_5","2TI","4","5","5","Lakin keli ita hafizu nefsa taki kweis fi kulu zaman, kun ma sobur fi taab, bashiru kabara al kweis le nas, kamilu kidma al Rabuna wodi le ita. ");
INSERT INTO pga_vpl VALUES ("T24_6","085_4_6","2TI","4","6","6","Leanu ana kalas wodi haya tai le Rabuna ze hadiya al bi asurubuu. Zaman ta mutu tai biga gerib. ");
INSERT INTO pga_vpl VALUES ("T24_7","085_4_7","2TI","4","7","7","Ana amulu sakila al kweis kalas, ana kalasu sabak sabak ta jere jere kalas, wa ana hafizu iman. ");
INSERT INTO pga_vpl VALUES ("T24_8","085_4_8","2TI","4","8","8","Wa hasa hadiya al ana bes gi istena de, yau taj ta shokol adil al Sultan, al gadi al dukuri, bi wodi le ana fi yom dak. Wa hadiya de maa bes le ana lakin le kulu nas al gi istena rija tou. ");
INSERT INTO pga_vpl VALUES ("T24_9","085_4_9","2TI","4","9","9","Timoteo, hawil ashan ita bi ja le ana guwam. ");
INSERT INTO pga_vpl VALUES ("T24_10","085_4_10","2TI","4","10","10","Leanu Dema sibu ana kalas ashan uwo hibu hajat ta duniya de wa uwo futu le Tesalonika. Kresekene futu le Galatiya wa Tito futu le Dalumatiya. ");
INSERT INTO pga_vpl VALUES ("T24_11","085_4_11","2TI","4","11","11","Luka yau bes ini ma ana. Taal sawa ma Marko ashan uwo bi saidu ana fi shokol. ");
INSERT INTO pga_vpl VALUES ("T24_12","085_4_12","2TI","4","12","12","Ana rasulu Tukiko le Efeso. ");
INSERT INTO pga_vpl VALUES ("T24_13","085_4_13","2TI","4","13","13","Kan ita gi ja, jibu kout al ana kaan sibu ma Karupo fi Turoasa. Kaman jibu awrag tai, kasatan kutub bitai. ");
INSERT INTO pga_vpl VALUES ("T24_14","085_4_14","2TI","4","14","14","Alegzanda zol ta sala hajat min hadid, amulu ana batal kalis, lakin Rabuna bi hukumu uwo hasab haja al uwo amulu. ");
INSERT INTO pga_vpl VALUES ("T24_15","085_4_15","2TI","4","15","15","Amulu hisab min uwo, leanu uwo did kulu kalam al nina gi derisu. ");
INSERT INTO pga_vpl VALUES ("T24_16","085_4_16","2TI","4","16","16","Awal yom al jibuu ana fi gidam gadi, mafi zol wogif ma ana, lakin nas kulu sibu ana barau. Keli Rabuna beinu rahama le umon. ");
INSERT INTO pga_vpl VALUES ("T24_17","085_4_17","2TI","4","17","17","Lakin Sultan wogifu ma ana wa wodi le ana guwa ashan bi agder bashiru kabara al kweis bel kamil le kulu nas al maa Yahudin ashan umon bi asuma. Wa Sultan nofud ana min kasma ta ased. ");
INSERT INTO pga_vpl VALUES ("T24_18","085_4_18","2TI","4","18","18","Sultan bi nofud ana min kulu hujum al batal wa jibu ana salim fi malakut bitou fi samawat. Kede mejid kun le Rabuna lel abad wa abad. Amen! ");
INSERT INTO pga_vpl VALUES ("T24_19","085_4_19","2TI","4","19","19","Wodi salam tai le Pirisila wa Akwila, wa bet ta Onesiforo. ");
INSERT INTO pga_vpl VALUES ("T24_20","085_4_20","2TI","4","20","20","Erasto lisa fi Korinto, ana sibu Trofimo ayan fi Mileto. ");
INSERT INTO pga_vpl VALUES ("T24_21","085_4_21","2TI","4","21","21","Hawil shedid ashan ita bi wosulu ini gubal jou maa tala batal. Eubulu, Pudento, Lino, Klaudiya, wa kulu akwana wa ikwat rasulu le ita salam. ");
INSERT INTO pga_vpl VALUES ("T24_22","085_4_22","2TI","4","22","22","Keli Sultan kun ma roho taki wa neima ta Rabuna kun ma itakum kulu.");
INSERT INTO pga_vpl VALUES ("TT1_1","086_1_1","TIT","1","1","1","Risala de min Bulus, kadam ta Rabuna wa rasul ta Yesuwa al Mesiya. Ana rasul ashan bi gowi iman ta nas al Rabuna azilu wa derisu marafa al nesiya al gi tifagu ma sika ta Rabuna. ");
INSERT INTO pga_vpl VALUES ("TT1_2","086_1_2","TIT","1","2","2","Ana kaman rasul ashan bi wori le nas an rajaa ta haya al abadiya, al Rabuna al maa gi kabasu waad gubal maa kalaguu duniya. ");
INSERT INTO pga_vpl VALUES ("TT1_3","086_1_3","TIT","1","3","3","Fi zaman al Rabuna azilu, uwo wori kilima tou be wasat tabashir. Wa uwo selimu kalam de le ana, hasab telimat al Rabuna Mukalis ta nina wodi. ");
INSERT INTO pga_vpl VALUES ("TT1_4","086_1_4","TIT","1","4","4","Risala de le Tito, jena tai al hagiga fi nefsa iman. Keli neima wa salam min Rabuna Abu bita nina wa Sultan Yesuwa al Mesiya, Mukalis ta nina kun ma ita. ");
INSERT INTO pga_vpl VALUES ("TT1_5","086_1_5","TIT","1","5","5","Ya Tito, ana kaan sibu ita fi Krete ashan sabab de, ashan ita bi nizamu hajat al fadulu wa resim nas kubar ta kenisa fi kulu medina zema ana kaan kelimu le ita. ");
INSERT INTO pga_vpl VALUES ("TT1_6","086_1_6","TIT","1","6","6","Zol kebir ta kenisa lazim keli maa kun indu lomu, keli uwo kun amin le mara tou, wa iyal bitou keli kun muminin. Keli umon maa amulu hajat sambala wa keli umon maa kun giladabin. ");
INSERT INTO pga_vpl VALUES ("TT1_7","086_1_7","TIT","1","7","7","Zol kebir ta kenisa, uwo zol mosul al gi ainu wara shokol ta Rabuna. Ashan kida, keli uwo lazim maa kun indu lomu. Keli uwo maa kun zol al gi kebir nefsa, au zol al gi zalan guwam, au sukuriji, au ta masakil wa tama ta gurush. ");
INSERT INTO pga_vpl VALUES ("TT1_8","086_1_8","TIT","1","8","8","Lakin keli uwo bi kun zol al gi rahibu nas, gi hibu saidu nas, gi hafizu nefsa tou. Keli uwo bi kun zol dukuri wa ish haya al kweis, wa indu ihtiram. ");
INSERT INTO pga_vpl VALUES ("TT1_9","086_1_9","TIT","1","9","9","Keli uwo wogif gowi fi risala al hagiga zema kaan derisuu. Ashan kida, uwo bi agder sheja nas ma deresa al hagiga wa kaman ashan bi aridu wa adilu nas al gi lakbatu deresa al hagiga. ");
INSERT INTO pga_vpl VALUES ("TT1_10","086_1_10","TIT","1","10","10","Ana wodi karar de le ita leanu nas al giladabin fii ketir. Umon gi wonusu kalam farik wa gi kabasu, kasatan Yahudin tanin al fekiru gali tahir bi jibu kulasa. ");
INSERT INTO pga_vpl VALUES ("TT1_11","086_1_11","TIT","1","11","11","Keli lazim wogifuu umon min deresat leanu umon gi kabasu usra ketir ma derisu hajat al umon kaan mafrud maa bi derisu, wa de bes ashan kalam ta gurush. ");
INSERT INTO pga_vpl VALUES ("TT1_12","086_1_12","TIT","1","12","12","Wahid zol min Krete, nebi taumon zatu kaan kelimu gali, “Nas ta Krete daiman nas ta kabasa, umon ze haiwanat al batal, nas al kaslanin wa ta geliba kebir.” ");
INSERT INTO pga_vpl VALUES ("TT1_13","086_1_13","TIT","1","13","13","Kalam de hagiga. Ashan kida, keli ita adilu umon tamam, ashan keli umon bi kun indu iman al hagiga. ");
INSERT INTO pga_vpl VALUES ("TT1_14","086_1_14","TIT","1","14","14","Keli umon maa asuma le gisat ta Yahudin tanin al maa min Rabuna wa gawanin an hajat al nedif wa al maa nedif min nas al sibu deresa al hagiga ta Injil. ");
INSERT INTO pga_vpl VALUES ("TT1_15","086_1_15","TIT","1","15","15","Hajat kulu nedif le nas al gulub taumon nedif, lakin mafi haja nedif le nas al gulub taumon maa nedif wa maa muminin. Ashan marafa wa afkar taumon wasaka. ");
INSERT INTO pga_vpl VALUES ("TT1_16","086_1_16","TIT","1","16","16","Umon gi mesil gali umon arufu Rabuna, lakin kalam maa gi beinu fi amail taumon. Umon waskanin, mukalifin, wa maa bi agder amulu ay shokol al kweis. ");
INSERT INTO pga_vpl VALUES ("TT2_1","086_2_1","TIT","2","1","1","Ya Tito, keli ita derisu kalam al gi tafigu ma deresa al hagiga. ");
INSERT INTO pga_vpl VALUES ("TT2_2","086_2_2","TIT","2","2","2","Rujal al kubar, keli geni birah, keli kun indu ihtiram, wa hafizu nefsa taumon. Keli umon indu iman, muhaba, sobur al hagiga. ");
INSERT INTO pga_vpl VALUES ("TT2_3","086_2_3","TIT","2","3","3","Nuswan al kubar, kaman keli kun indu aklag al kweis. Keli umon maa kun ta suwata au abid le merisa. Keli umon derisu hajat al kweis. ");
INSERT INTO pga_vpl VALUES ("TT2_4","086_2_4","TIT","2","4","4","Be teriga de, umon bi agder derisu nuswan al lisa sukerin ashan hibu rujal wa iyal taumon. ");
INSERT INTO pga_vpl VALUES ("TT2_5","086_2_5","TIT","2","5","5","Umon bi hafizu nefsa taumon, kun nedif, ainu wara bet kweis, wa asuma le rujal taumon. Ashan kida, nas maa bi agder wonusu kalam batal an deresa ta Rabuna al itakum gi tabi. ");
INSERT INTO pga_vpl VALUES ("TT2_6","086_2_6","TIT","2","6","6","Be nefsa teriga, sheja shabab ashan bi hafizu nefsa taumon ");
INSERT INTO pga_vpl VALUES ("TT2_7","086_2_7","TIT","2","7","7","fi kulu haja. Keli ita kun misal le umon be wasat amulu kalam al kweis. Fi deresa taki derisu be geliba kulu, wa be ihtiram. ");
INSERT INTO pga_vpl VALUES ("TT2_8","086_2_8","TIT","2","8","8","Derisu kalam al hagiga al maa bi ariduu. Be teriga de nas adu ta nina bi kun indu fadiya ashan umon maa bi kun indu ay haja batal al umon wonusu an nina. ");
INSERT INTO pga_vpl VALUES ("TT2_9","086_2_9","TIT","2","9","9","Wori le abiid ashan bi asuma kalam ta seyid taumon fi kulu hajat wa keli umon hawil ashan kutu seyid taumon moksut. Keli umon maa amulu munakisa ma seyid taumon. ");
INSERT INTO pga_vpl VALUES ("TT2_10","086_2_10","TIT","2","10","10","Keli umon maa seregu min seyid taumon, lakin keli umon kun nas al aminin wa ta hagiga fi hajat kulu. Ashan be wasat shokol taumon, nas kulu bi agder arufu deresa ta Rabuna mukalis ta nina de kweis fi ay haja al itakum gi amulu. ");
INSERT INTO pga_vpl VALUES ("TT2_11","086_2_11","TIT","2","11","11","Keli ita lazim derisu hajat de ashan neima ta Rabuna beinu kalas uwo wodi kulasa le nas kulu. ");
INSERT INTO pga_vpl VALUES ("TT2_12","086_2_12","TIT","2","12","12","Neima de derisu nina ashan aba niyat ta duniya wa haya al maa bi mejidu Rabuna. Ashan nina bi ish haya ta hafizu nefsa, geni dukuri wa fi haya ta Rabuna fi zaman ta hasa. ");
INSERT INTO pga_vpl VALUES ("TT2_13","086_2_13","TIT","2","13","13","Zema hasa, nina gi istena rajaa ta nina al mubarak, zaman Rabuna al kebir wa mukalis ta nina Yesuwa al Mesiya bi beinu fi mejid bitou. ");
INSERT INTO pga_vpl VALUES ("TT2_14","086_2_14","TIT","2","14","14","Uwo wodi nefsa tou fi mahal ta nina, ashan bi dafa taman ta kulu katiya ta nina, wa kasulu nina min katiya ashan bi kun nas bitou al kas, jahiz le shokol al kweis. ");
INSERT INTO pga_vpl VALUES ("TT2_15","086_2_15","TIT","2","15","15","Ita indu sulta min Rabuna ashan bi derisu hajat del le nas, shejau, wa adilu umon. Mata sibu fursa le ay zol ashan bi alisu ita. ");
INSERT INTO pga_vpl VALUES ("TT3_1","086_3_1","TIT","3","1","1","Ya Tito, zekiru muminin ashan bi asuma le nas al gi hakimu wa nas al indu sulta fi beled, keli umon kun indu ihtiram wa kun jahiz le ay shokol al kweis. ");
INSERT INTO pga_vpl VALUES ("TT3_2","086_3_2","TIT","3","2","2","Keli muminin maa wonusu kalam batal an ay zol, keli umon sibu kore kore, kun nas ta salam, wa wori shokol nezilu nefsa le nas kulu. ");
INSERT INTO pga_vpl VALUES ("TT3_3","086_3_3","TIT","3","3","3","Ashan nina zatu kaan belidin, maa bi asuma kalam, kaan kabasuu nina, abiid le niyat ta hajat ketir wa farah ta duniya. Nina kaan ish haya al batal wa ta geliba asut, nas kaan aba nina wa nina kaman aba umon. ");
INSERT INTO pga_vpl VALUES ("TT3_4","086_3_4","TIT","3","4","4","Lakin zaman maruf wa muhaba ta Rabuna mukalis ta nina beinu, ");
INSERT INTO pga_vpl VALUES ("TT3_5","086_3_5","TIT","3","5","5","uwo kalisu nina, maa ashan shokol al kweis nina amulu, lakin hasab rahama bitou. Uwo kalisu wa kasulu katiya ta nina be wasat Roho al Kudus, wa uwo wodi le nina wilada al jedid wa haya al jedid. ");
INSERT INTO pga_vpl VALUES ("TT3_6","086_3_6","TIT","3","6","6","Uwo kubu Roho al Kudus fi ras ta nina majani be wasat Yesuwa al Mesiya mukalis ta nina, ");
INSERT INTO pga_vpl VALUES ("TT3_7","086_3_7","TIT","3","7","7","ashan uwo kalas kutu nina dukuri be neima bitou wa nina biga indu hak ashan bi kun iyal bitou wa bi ligo haya al abadiya. ");
INSERT INTO pga_vpl VALUES ("TT3_8","086_3_8","TIT","3","8","8","Kalam de hagiga. Fa ana deiru ita bi derisu hajat del bidun kouf. Ashan nas al aminu fi Rabuna bi wodi nefsa taumon fi amulu shokol al kweis. Kalamat del kweis wa indu faida le nas. ");
INSERT INTO pga_vpl VALUES ("TT3_9","086_3_9","TIT","3","9","9","Lakin aba munakasat al maa indu faida, wanasa an tarik ta judud ta usra, sibu takum kore-kore, wa suwalat an ganun, ashan hajat del maa indu mana wa faida. ");
INSERT INTO pga_vpl VALUES ("TT3_10","086_3_10","TIT","3","10","10","Kan fii ay zol al gi gesimu nas fi nus takum, wodi takum le uwo inzar itnin marat. Bad dak, sibu takum uwo. ");
INSERT INTO pga_vpl VALUES ("TT3_11","086_3_11","TIT","3","11","11","Keli itakum arufu gali zol zede kalas tala bara min sika al hagiga wa gi amulu katiya. Uwo kalas gata gediya bitou. ");
INSERT INTO pga_vpl VALUES ("TT3_12","086_3_12","TIT","3","12","12","Kan ana rasulu Artema au Tukiko le ita, hawil shedid ashan bi ja le ana fi Nikopoli, leanu ana kalas katitu ashan bi geni inak be zaman besit. ");
INSERT INTO pga_vpl VALUES ("TT3_13","086_3_13","TIT","3","13","13","Hawil shedid ashan bi saidu Zena al muhami wa Apolo fi momoriya taumon. Kutu fi bal taki gali mafi haja nagis le umon. ");
INSERT INTO pga_vpl VALUES ("TT3_14","086_3_14","TIT","3","14","14","Keli nas ta nina lazim alimu ashan bi amulu shokol al kweis ashan umon bi agder saidu nas al maa indu haja. Keli umon maa kun ze shejera bidun fawaki. ");
INSERT INTO pga_vpl VALUES ("TT3_15","086_3_15","TIT","3","15","15","Nas kulu al fii ma ana gi selim ita. Selim kulu nas al ma ita al gi hibu nina fi iman. Keli neima ta Rabuna kun ma itakum kulu.");
INSERT INTO pga_vpl VALUES ("PM1_1","087_1_1","PHM","1","1","1","Risala de min Bulus wa Timoteo aku bita nina. Ana Bulus, mobus ashan kalam ta Yesuwa al Mesiya. Risala de le Filemona zemil bita nina al nina hibu shedid, ");
INSERT INTO pga_vpl VALUES ("PM1_2","087_1_2","PHM","1","2","2","wa okot bita nina Afiya, Arkipo askeri ta Yesuwa ze nina, wa muminin al gi seli fi bet bitak. ");
INSERT INTO pga_vpl VALUES ("PM1_3","087_1_3","PHM","1","3","3","Keli neima wa salam min Rabuna Abu bita nina wa Sultan Yesuwa al Mesiya kun ma itakum. ");
INSERT INTO pga_vpl VALUES ("PM1_4","087_1_4","PHM","1","4","4","Ya Filemona, ana gi shukur Rabuna tai daiman, kan ana gi seli le ita, ");
INSERT INTO pga_vpl VALUES ("PM1_5","087_1_5","PHM","1","5","5","ashan ana asuma an muhaba al ita indu le nas ta Rabuna kulu wa iman bitak fi Sultan Yesuwa. ");
INSERT INTO pga_vpl VALUES ("PM1_6","087_1_6","PHM","1","6","6","Ana gi seli gali, ita bi kun indu wehda aktar ma muminin tanin ashan ita arufu inu, nina indu kulu hajat al kweis fi Mesiya. ");
INSERT INTO pga_vpl VALUES ("PM1_7","087_1_7","PHM","1","7","7","Ya aku bitai, ana ligo faraha kebir wa teshji min muhaba bitak, leanu ita kutu gulub ta nas bita Rabuna murtah. ");
INSERT INTO pga_vpl VALUES ("PM1_8","087_1_8","PHM","1","8","8","Ashan kida, bidun kouf, ze zol mosul bitak fi Mesiya, ana bi agder wodi le ita karar ashan bi amulu haja al deiruu. ");
INSERT INTO pga_vpl VALUES ("PM1_9","087_1_9","PHM","1","9","9","Lakin ashan kalam bita muhaba ana bi asalu ita birah. Ya Filemona, ita arufu gali, ana rajil al ajus, wa hasa umon kutu ana fi sijin ashan ana gi bashiru kalam ta Yesuwa al Mesiya. ");
INSERT INTO pga_vpl VALUES ("PM1_10","087_1_10","PHM","1","10","10","Fa ana gi gedimu le ita talab ashan kalam ta Onesimo, al ana hibu ze jena tai, ashan uwo rudu Yesuwa wokit ana bashiru le uwo ligo ana fi sijin. ");
INSERT INTO pga_vpl VALUES ("PM1_11","087_1_11","PHM","1","11","11","Wokit uwo kaan ma ita, uwo amulu galat, lakin hasa uwo geiru kalas. Uwo biga indu faida le ita wa le ana. ");
INSERT INTO pga_vpl VALUES ("PM1_12","087_1_12","PHM","1","12","12","Salakun uwo mohim kalis le ana, ana gi rasulu uwo wara le ita. ");
INSERT INTO pga_vpl VALUES ("PM1_13","087_1_13","PHM","1","13","13","Ana kaan deiru ashan uwo bi geni ma ana ini, ashan uwo bi agder saidu ana benyaba bitak fi zaman al ana fi sijin ashan kalam ta injil. ");
INSERT INTO pga_vpl VALUES ("PM1_14","087_1_14","PHM","1","14","14","Lakin ana maa deiru amulu ay haja bidun raya bitak, ashan ay haja al kweis ita bi amulu kede maa kun ze asuruu ita, lakin min rudu bitak. ");
INSERT INTO pga_vpl VALUES ("PM1_15","087_1_15","PHM","1","15","15","Imkin le sabab de yau uwo kaan ferigu min ita ma zaman besit, ashan ita bi agder rahibu uwo wara lel abad. ");
INSERT INTO pga_vpl VALUES ("PM1_16","087_1_16","PHM","1","16","16","Hasa uwo biga maa abid bes, lakin aksen min abid, uwo aku al nina hibu, maa bes le ana barau, lakin uwo mohim kalis le ita. Uwo biga zol al kweis wa aku taki fi Sultan Yesuwa. ");
INSERT INTO pga_vpl VALUES ("PM1_17","087_1_17","PHM","1","17","17","Ashan kida, kan ita shilu ana ze aku bitak, rahibu uwo zema ita kaan bi rahibu ana. ");
INSERT INTO pga_vpl VALUES ("PM1_18","087_1_18","PHM","1","18","18","Kan uwo amulu galat le ita, au uwo indu dein bitak, hasibu le ana. ");
INSERT INTO pga_vpl VALUES ("PM1_19","087_1_19","PHM","1","19","19","Ana yau katibu kalam de, ana Bulus bi dafa dein taki. Ana kaman deiru zekiru ita gali, dein bitai le ita yau zatu nefsa bitak. ");
INSERT INTO pga_vpl VALUES ("PM1_20","087_1_20","PHM","1","20","20","Ashan kida ya aku tai, amulu le ana maruf fi Sultan Yesuwa. Kutu geliba tai murtah ashan nina akwana fi Mesiya. ");
INSERT INTO pga_vpl VALUES ("PM1_21","087_1_21","PHM","1","21","21","Ana arufu ita zol al indu ihtiram, fa ana gi katibu le ita. Ana arufu gali ita bi amulu aktar min kalam al ana asalu. ");
INSERT INTO pga_vpl VALUES ("PM1_22","087_1_22","PHM","1","22","22","Ziyada le de, jahizu le ana mahal, ashan ana indu fikra, Rabuna bi wosulu ana le itakum be wasat salawat takum. ");
INSERT INTO pga_vpl VALUES ("PM1_23","087_1_23","PHM","1","23","23","Epafra rasulu salam le ita, uwo kaman fi sijin ma ana ashan nina gi bashiru kalam ta Yesuwa al Mesiya. ");
INSERT INTO pga_vpl VALUES ("PM1_24","087_1_24","PHM","1","24","24","Marko, Aristareko, Dema, wa Luka akwana tai fi shokol ta Rabuna, kaman rasulu salam le ita. ");
INSERT INTO pga_vpl VALUES ("PM1_25","087_1_25","PHM","1","25","25","Keli neima bita Sultan Yesuwa al Mesiya kun ma roho bitakum.");
INSERT INTO pga_vpl VALUES ("JM1_1","089_1_1","JAS","1","1","1","Risala de min Yakub, kadam ta Rabuna wa Sultan Yesuwa al Mesiya, le nas ta Rabuna al setetu fi duniya. Salam le itakum. ");
INSERT INTO pga_vpl VALUES ("JM1_2","089_1_2","JAS","1","2","2","Ya akwana wa ikwat tai, kan ay no ta taab gi ligo itakum, keli itakum kun farahanin, ");
INSERT INTO pga_vpl VALUES ("JM1_3","089_1_3","JAS","1","3","3","leanu itakum arufu gali, haja al gi jeribu iman takum de gi kutu itakum kun indu sobur. ");
INSERT INTO pga_vpl VALUES ("JM1_4","089_1_4","JAS","1","4","4","Kede sobur de raba gowi ashan itakum bi agder kun kweis kalis wa kamil, mafi haja bi kun nagis. ");
INSERT INTO pga_vpl VALUES ("JM1_5","089_1_5","JAS","1","5","5","Kan ay zol min itakum maa indu hikma, keli uwo asalu Rabuna. Rabuna bi wodi. Rabuna gi wodi majani le kulu nas bidun neng-neng. ");
INSERT INTO pga_vpl VALUES ("JM1_6","089_1_6","JAS","1","6","6","Lakin keli uwo asalu ma iman bidun was-was, ashan ay zol al bi indu was-was, uwo ze moya bita bahar al hawa bi hizu wa arufa. ");
INSERT INTO pga_vpl VALUES ("JM1_7","089_1_7","JAS","1","7","7","Zol zede keli maa fekiru ashan bi ligo ay haja min Rabuna. ");
INSERT INTO pga_vpl VALUES ("JM1_8","089_1_8","JAS","1","8","8","Zol zede indu itnin afkar, maa sabit fi kulu haja al uwo gi amulu. ");
INSERT INTO pga_vpl VALUES ("JM1_9","089_1_9","JAS","1","9","9","Keli muminin al maa indu haja kun murtahin ashan Rabuna arufa umon fok. ");
INSERT INTO pga_vpl VALUES ("JM1_10","089_1_10","JAS","1","10","10","Wa muminin al ganiyanin kaman keli kun murtahin ashan Rabuna nezilu umon tehet. Nas al ganiyanin bi mutu ze zuhur. ");
INSERT INTO pga_vpl VALUES ("JM1_11","089_1_11","JAS","1","11","11","Shemis gi tala ma harara sukun wa gi nasifu zuhur. Zuhur de bi waga, wa giyafa taumon bi kalasu. Be nefsa teriga, zol al ganiyan bi mutu gubal uwo lisa maa kalasu shokol bitou. ");
INSERT INTO pga_vpl VALUES ("JM1_12","089_1_12","JAS","1","12","12","Zol al indu sobur fi zaman ta taab, uwo mubarak. Kan uwo wogif gowi, uwo bi ligo taj ta haya al abadiya al Rabuna waado le nas al hibu uwo. ");
INSERT INTO pga_vpl VALUES ("JM1_13","089_1_13","JAS","1","13","13","Kan tejiriba gi amulu zol, keli uwo maa kelimu gali, “Rabuna yau gi jeribu ana,” leanu Rabuna maa bi waga fi tejiriba, wa uwo maa bi kutu zol ashan waga fi tejiriba. ");
INSERT INTO pga_vpl VALUES ("JM1_14","089_1_14","JAS","1","14","14","Lakin tejiriba gi ja le zol min niyat tou, al bi kabasu uwo wa shilu uwo beyid. ");
INSERT INTO pga_vpl VALUES ("JM1_15","089_1_15","JAS","1","15","15","Kan niyat batal de dakalu fi geliba tou, uwo bi waga fi katiya. Wa kan uwo istemir fi katiya de, bi jibu le uwo mutu. ");
INSERT INTO pga_vpl VALUES ("JM1_16","089_1_16","JAS","1","16","16","Ya akwana wa ikwat tai, al ana hibu, keli zol tani maa kabasu itakum. ");
INSERT INTO pga_vpl VALUES ("JM1_17","089_1_17","JAS","1","17","17","Kulu hadiya al kweis wa tamam gi ja min Rabuna, Abu al kalagu anwar ta sama. Uwo maa ze dul al gi geiru. ");
INSERT INTO pga_vpl VALUES ("JM1_18","089_1_18","JAS","1","18","18","Min irada tou, uwo wodi le nina haya be wasat kilima al hagiga, ashan nina bi kun le Rabuna ze samar al awal min kulu hajat al uwo kalagu. ");
INSERT INTO pga_vpl VALUES ("JM1_19","089_1_19","JAS","1","19","19","Ya akwana wa ikwat tai al ana hibu, zekiru takum kalam de. Ay zol keli asuma kalam guwam, wa maa kun mustajil ashan bi wonusu, wa keli maa zalan guwam, ");
INSERT INTO pga_vpl VALUES ("JM1_20","089_1_20","JAS","1","20","20","leanu shokol zalan ta insan maa bi jibu haya al dukuri al Rabuna deiru. ");
INSERT INTO pga_vpl VALUES ("JM1_21","089_1_21","JAS","1","21","21","Ashan kida, sibu takum haya al wasaka kulu wa ay no ta hajat al batal. Rudu kilima al Rabuna zara fogo itakum ma geliba al birah. Kilima de indu guwa ashan kalisu itakum. ");
INSERT INTO pga_vpl VALUES ("JM1_22","089_1_22","JAS","1","22","22","Ashan kida, kutu takum kilima de fi shokol. Matakum asuma ma adana bes. Kan maa zede, itakum gi kabasu badun. ");
INSERT INTO pga_vpl VALUES ("JM1_23","089_1_23","JAS","1","23","23","Ay zol al gi asuma kilima de wa maa gi kutu fi shokol, uwo ze zol al gi ainu wusa tou fi miraya, ");
INSERT INTO pga_vpl VALUES ("JM1_24","089_1_24","JAS","1","24","24","wa uwo ligo muskila fii, lakin uwo maa hilu. Uwo tawali wasa min miraya, wa uwo nesitu muskila de kaan shunu. ");
INSERT INTO pga_vpl VALUES ("JM1_25","089_1_25","JAS","1","25","25","Lakin zol al gi ainu tamam fi ganun ta Rabuna, wa maa gi asuma ma adana bes, lakin gi kutu fi shokol, kan uwo istemir amulu kida, uwo bi ligo baraka fi shokol al uwo gi amulu de. Ashan ganun ta Rabuna kamil wa gi jibu huriya. ");
INSERT INTO pga_vpl VALUES ("JM1_26","089_1_26","JAS","1","26","26","Ay zol al gi fekiru gali uwo gi kadim le Rabuna wa maa gi hafizu lisan tou, uwo gi kabasu nefsa bitou, wa kidma tou de maa indu faida. ");
INSERT INTO pga_vpl VALUES ("JM1_27","089_1_27","JAS","1","27","27","Shokol al nedif wa hagiga gidam Rabuna Abu bita nina yau: Wodi musada le atimin wa aramil fi wokit al umon fi taab, wa hafizu nefsa min haya al wasaka ta duniya. ");
INSERT INTO pga_vpl VALUES ("JM2_1","089_2_1","JAS","2","1","1","Ya akwana wa ikwat tai, itakum indu iman fi Sultan bita nina Yesuwa al Mesiya, uwo Rabuna al Kebir. Ashan kida, matakum gesimu badun. ");
INSERT INTO pga_vpl VALUES ("JM2_2","089_2_2","JAS","2","2","2","Fekiru takum misal de: Zol al libisu katim min dahab wa gumash al giyafa ja fi mahal ta salawat takum, wa kaman zol al miskin libisu gumash waskan ja. ");
INSERT INTO pga_vpl VALUES ("JM2_3","089_2_3","JAS","2","3","3","Kan itakum kutu bal bes le zol al libisu gumash giyafa, wa kelimu le uwo gali, “Geni ini fi mahal al kweis de,” yala itakum kelimu le zol al miskin gali, “Wogif inak au geni tehet fi turab,” ");
INSERT INTO pga_vpl VALUES ("JM2_4","089_2_4","JAS","2","4","4","de bi mana itakum gi gesimu badun wa itakum gi gata gediya ma afkar al batal. ");
INSERT INTO pga_vpl VALUES ("JM2_5","089_2_5","JAS","2","5","5","Asuma takum, ya akwana wa ikwat tai al ana hibu, Rabuna azilu masakin fi duniya ashan bi kun gowi fi iman. Uwo wodi malakut bitou le umon, ze melik gi selimu malakut tou le jena bitou. Rabuna waado malakut bitou de le kulu nas al hibu uwo. ");
INSERT INTO pga_vpl VALUES ("JM2_6","089_2_6","JAS","2","6","6","Lakin itakum gi alisu nas al masakin. Musu nas al ganiyanin yau gi taabu itakum wa gi shilu itakum be guwa fi mahkama? ");
INSERT INTO pga_vpl VALUES ("JM2_7","089_2_7","JAS","2","7","7","Musu umon yau gi wonusu batal an isim al kweis ta Rabuna takum? ");
INSERT INTO pga_vpl VALUES ("JM2_8","089_2_8","JAS","2","8","8","Rabuna Melik ta nina wodi ganun ze katibuu fi Kitab al Mukadas gali, “Keli ita hibu jeran bitak ze nefsa taki.” Kan itakum gi amulu zede, de kweis. ");
INSERT INTO pga_vpl VALUES ("JM2_9","089_2_9","JAS","2","9","9","Lakin kan itakum gi gesimu badun, itakum gi amulu katiya. Itakum kasuru ganun ta Rabuna, wa ganun de bi hukumu itakum. ");
INSERT INTO pga_vpl VALUES ("JM2_10","089_2_10","JAS","2","10","10","Ay zol al gi hafizu ganun ta Rabuna lakin kasuru wahid min gawanin del bes, uwo kasuru ganun de kulu kalas. ");
INSERT INTO pga_vpl VALUES ("JM2_11","089_2_11","JAS","2","11","11","Ashan Rabuna kelimu gali, “Mata amulu zina,” wa uwo kaman kelimu, “Mata katulu zol.” Kan ita maa amulu zina lakin ita katulu zol, ita kalas kasuru ganun de kulu. ");
INSERT INTO pga_vpl VALUES ("JM2_12","089_2_12","JAS","2","12","12","Fa keli itakum ish haya ze nas al arufu gali, ganun al gi wodi huriya min katiya bi hukumu itakum. ");
INSERT INTO pga_vpl VALUES ("JM2_13","089_2_13","JAS","2","13","13","Ashan kan zol maa wori rahama le zol tani, Rabuna bi hukumu uwo bidun rahama kaman. Rahama gi gilibu hukumu. ");
INSERT INTO pga_vpl VALUES ("JM2_14","089_2_14","JAS","2","14","14","Ya akwana wa ikwat tai, kan zol tani kelimu gali uwo aminu fi Rabuna lakin maa gi amulu haja al Rabuna deiru, kweis tou shunu? Sei iman de bi agder kalisu uwo? ");
INSERT INTO pga_vpl VALUES ("JM2_15","089_2_15","JAS","2","15","15","Masalan, kan aku au okot maa indu gumash au akil ta yom, ");
INSERT INTO pga_vpl VALUES ("JM2_16","089_2_16","JAS","2","16","16","wa wahid min itakum bi kelimu le uwo gali, “Ruwa ma salam, libisu gumash wa akulu kweis,” lakin itakum maa wodi le uwo haja al gisim tou deiru, de sei kweis? ");
INSERT INTO pga_vpl VALUES ("JM2_17","089_2_17","JAS","2","17","17","Iman kaman kida. Kan maa kutuu fi shokol, iman de meit. ");
INSERT INTO pga_vpl VALUES ("JM2_18","089_2_18","JAS","2","18","18","Zol tani bi agder asalu ana gali, “Sei ita indu iman?” Nam, ana indu iman, wa ana kaman gi kutu iman de fi shokol. Wori le ana iman taki bidun shokol, wa ana bi wori le ita iman al hagiga be shokol tai. ");
INSERT INTO pga_vpl VALUES ("JM2_19","089_2_19","JAS","2","19","19","Musu ita aminu gali Rabuna fii wahid? De kweis! Aruwah al batal kaman arufu kalam de kweis, lakin umon gi kafu Rabuna shedid. ");
INSERT INTO pga_vpl VALUES ("JM2_20","089_2_20","JAS","2","20","20","Ya zol al belid, sei ita maa bi agder fahim gali iman bidun shokol maa indu faida? ");
INSERT INTO pga_vpl VALUES ("JM2_21","089_2_21","JAS","2","21","21","Musu Rabuna kaan nadi abu ta nina Abrahama zol dukuri ashan kalam al uwo amulu, wokit uwo wodi weled bitou Isaka ze zabiha le Rabuna? ");
INSERT INTO pga_vpl VALUES ("JM2_22","089_2_22","JAS","2","22","22","Ita ainu? Iman wa shokol al kweis ta Abrahama kaan gi istakal sawa. Shokol al kweis uwo amulu yau kutu iman tou kamil. ");
INSERT INTO pga_vpl VALUES ("JM2_23","089_2_23","JAS","2","23","23","Ashan kida, kalam de timu ze katibuu fi Kitab al Mukadas gali, “Abrahama aminu fi Rabuna, wa Rabuna nadi uwo zol dukuri ashan iman tou,” wa nas kaan gi nadii uwo sabi ta Rabuna. ");
INSERT INTO pga_vpl VALUES ("JM2_24","089_2_24","JAS","2","24","24","Itakum ainu? Rabuna gi nadi zol dukuri ashan shokol bitou, maa ashan iman barau. ");
INSERT INTO pga_vpl VALUES ("JM2_25","089_2_25","JAS","2","25","25","Wa be nefsa teriga, Rabuna kaan nadi Rahab al saramuta zol dukuri ashan kalam al kweis hiya amulu, wokit hiya hafizu jasusin ta Israil wa saidu umon ashan tefes min adu taumon. ");
INSERT INTO pga_vpl VALUES ("JM2_26","089_2_26","JAS","2","26","26","Ashan kida, ze gisim bidun roho uwo meit, iman kaman bidun shokol al kweis uwo meit. ");
INSERT INTO pga_vpl VALUES ("JM3_1","089_3_1","JAS","3","1","1","Ya akwana wa ikwat tai, keli ketir takum maa kun muderisin, ashan itakum arufu gali, Rabuna bi hukumu nina muderisin ma teriga al saab kalis. ");
INSERT INTO pga_vpl VALUES ("JM3_2","089_3_2","JAS","3","2","2","Nina kulu gi amulu galat fi kalamat ketir. Lakin kan fii zol al maa gi amulu galat fi kalam al uwo gi wonusu, uwo zol kweis kalis, uwo kaman bi agder hafizu gisim bitou kulu. ");
INSERT INTO pga_vpl VALUES ("JM3_3","089_3_3","JAS","3","3","3","Ainu, nina gi kutu habil fi kasma ta husan ashan uwo bi istakal ma kalam ta nina, wa be teriga de uwo bi ruwa fi tijah al nina deiru. ");
INSERT INTO pga_vpl VALUES ("JM3_4","089_3_4","JAS","3","4","4","Ainu babur kaman: Salakun uwo kebir wa hawa al tegil gi shilu uwo, sawag bi agder lifu dirikson al suker ashan sugu babur fi tijah al uwo deiru. ");
INSERT INTO pga_vpl VALUES ("JM3_5","089_3_5","JAS","3","5","5","Be nefsa teriga de, lisan uwo haja wahid al suker fi gisim ta nina, lakin uwo gi dala an kalamat al kubar. Ainu nar al suker gi aragu gaba kulu kef. ");
INSERT INTO pga_vpl VALUES ("JM3_6","089_3_6","JAS","3","6","6","Lisan kaman ze nar. Min kulu ada ta gisim ta zol, lisan yau gi amulu katiya ketir. Uwo gi waskan geliba ta zol wa gi demiru haya ta insan kulu ze nar, wa nar de gi ja min Jehenam. ");
INSERT INTO pga_vpl VALUES ("JM3_7","089_3_7","JAS","3","7","7","Insan bi agder hakim kulu no ta haiwanat, tiyur, hajat al fi bahar, wa kulu haiwanat al gi douru min tehet. Nam, hakimuu umon kulu kalas. ");
INSERT INTO pga_vpl VALUES ("JM3_8","089_3_8","JAS","3","8","8","Lakin mafi insan bi agder hakim lisan. Uwo maa gi wogifu min amulu kalam al batal. Uwo maliyan ma sim al gi katulu. ");
INSERT INTO pga_vpl VALUES ("JM3_9","089_3_9","JAS","3","9","9","Be lisan nina gi mejidu Rabuna Abu ta nina, wa be nefsa lisan nina gi lanu nas al Rabuna kalagu fi sura bitou. ");
INSERT INTO pga_vpl VALUES ("JM3_10","089_3_10","JAS","3","10","10","Min nefsa kasma de, mejid wa lana gi tala. Ya akwana wa ikwat tai, kalam de maa kweis. ");
INSERT INTO pga_vpl VALUES ("JM3_11","089_3_11","JAS","3","11","11","Sei moya al kweis wa moya al mile bi agder tala min nefsa bir? ");
INSERT INTO pga_vpl VALUES ("JM3_12","089_3_12","JAS","3","12","12","Ya akwana wa ikwat tai, sei shejera guafa bi agder weledu lulu, au shejera inab bi weledu guafa? Be nefsa teriga, bir al gi tala moya al mile maa bi agder tala moya al kweis. ");
INSERT INTO pga_vpl VALUES ("JM3_13","089_3_13","JAS","3","13","13","De munu bein itakum al indu hikma wa marafa? Keli uwo beinu be wasat hajat al uwo gi amulu. Keli uwo ish haya al kweis wa birah ze zol al indu hikma. ");
INSERT INTO pga_vpl VALUES ("JM3_14","089_3_14","JAS","3","14","14","Lakin kan geliba takum mur wa garman, matakum dala wa aba kalam al hagiga. ");
INSERT INTO pga_vpl VALUES ("JM3_15","089_3_15","JAS","3","15","15","Shikil haya de maa gi ja min hikma ta Rabuna. Uwo ta duniya, min fikra ta insan, wa min roho al batal. ");
INSERT INTO pga_vpl VALUES ("JM3_16","089_3_16","JAS","3","16","16","Kan nas indu geliba mur wa shokol garman, lakbata wa ay no ta amail al waskan bi kun fii inak. ");
INSERT INTO pga_vpl VALUES ("JM3_17","089_3_17","JAS","3","17","17","Lakin hikma ta Rabuna awal haja nedif, wa kaman indu salam wa sobur. Uwo jahiz ashan bi asuma kalam, indu rahama kifaya wa amail al kweis. Uwo maa gi gesimu nas au kabasu nas. ");
INSERT INTO pga_vpl VALUES ("JM3_18","089_3_18","JAS","3","18","18","Kan nas al hibu salam jibu salam bein nas, haya ta nas bi kun dukuri. ");
INSERT INTO pga_vpl VALUES ("JM4_1","089_4_1","JAS","4","1","1","Sunu yau gi jibu kore-kore wa sakila fi bein takum? Sei uwo maa gi ja min niyat ta gisim al gi sakila fogo itakum? ");
INSERT INTO pga_vpl VALUES ("JM4_2","089_4_2","JAS","4","2","2","Itakum deiru hajat lakin itakum maa gi ligo, biga itakum gi katulu. Itakum indu niyat le hajat lakin itakum maa gi ligo, biga itakum gi sakila wa gi kore-kore. Itakum maa indu haja, leanu itakum maa gi asalu Rabuna. ");
INSERT INTO pga_vpl VALUES ("JM4_3","089_4_3","JAS","4","3","3","Salakun itakum asalu Rabuna, itakum maa gi ligo, leanu afkar takum batal. Itakum deiru istamil hajat del le niyat ta gisim takum. ");
INSERT INTO pga_vpl VALUES ("JM4_4","089_4_4","JAS","4","4","4","Itakum ya nas al maa muminin! Sei itakum maa arufu gali kan itakum sabi ta duniya, itakum adu ta Rabuna? Ashan kida, ay zol al gi fekiru ashan bi kun sabi ta duniya gi kutu nefsa tou adu ta Rabuna. ");
INSERT INTO pga_vpl VALUES ("JM4_5","089_4_5","JAS","4","5","5","Itakum sei fekiru gali Kitab al Mukadas gi kabasu? Kitab de gi kelimu gali, “Rabuna indu niya shedid ashan roho al uwo wodi le nina de bi kadim le uwo bes.” ");
INSERT INTO pga_vpl VALUES ("JM4_6","089_4_6","JAS","4","6","6","Salakun kalam de gowi, Rabuna gi wodi le nina neima kifaya ashan nina bi kadim le uwo. Wa de yau sabab Kitab al Mukadas gi kelimu gali, “Rabuna gi aridu zol al gi kebir nefsa tou, lakin uwo gi wodi neima le zol al gi rija nefsa tou tehet.” ");
INSERT INTO pga_vpl VALUES ("JM4_7","089_4_7","JAS","4","7","7","Ashan kida, selimu nefsa takum le Rabuna kamil. Wogif gowi did Shetan, wa uwo bi jere min itakum. ");
INSERT INTO pga_vpl VALUES ("JM4_8","089_4_8","JAS","4","8","8","Taal takum gerib le Rabuna, wa uwo bi ja gerib le itakum. Kasulu takum iden takum, ya nas ta katiya, wa nedif takum gulub takum, ya nas al indu itnin afkar. ");
INSERT INTO pga_vpl VALUES ("JM4_9","089_4_9","JAS","4","9","9","Keli geliba takum waja! Keli geliba takum kasuru! Keli itakum kore! Ataku takum keli geiru le kore wa faraha takum le huzun ashan katiya takum. ");
INSERT INTO pga_vpl VALUES ("JM4_10","089_4_10","JAS","4","10","10","Rija takum nefsa takum tehet fi gidam ta Rabuna, wa uwo bi arufa itakum fok. ");
INSERT INTO pga_vpl VALUES ("JM4_11","089_4_11","JAS","4","11","11","Ya akwana wa ikwat, matakum wonusu batal an aku au okot tani. Zol al gi wonusu batal an aku au okot tani au gi gata gediya bitou, uwo gi wonusu batal an ganun ta Rabuna, wa uwo gi alisu ganun de. Kan ita gi alisu ganun, manatu ita maa gi hafizu ganun, lakin ita biga gadi. ");
INSERT INTO pga_vpl VALUES ("JM4_12","089_4_12","JAS","4","12","12","Rabuna yau bes gi wodi ganun, wa uwo yau gadi. Uwo yau bi agder afi au demiru zol. Ita munu ashan bi gata gediya ta jeran taki? ");
INSERT INTO pga_vpl VALUES ("JM4_13","089_4_13","JAS","4","13","13","Asuma, itakum nas al gi wonusu gali, “Alela au bukra nina bi ruwa fi medina tani wa geni inak wahid sena wa nina bi amulu tijara wa bi ligo ribe.” ");
INSERT INTO pga_vpl VALUES ("JM4_14","089_4_14","JAS","4","14","14","Sei itakum arufu haya takum bi kun kef bukra? Itakum ze dukan al gi beinu be zaman besit wa bi woduru. ");
INSERT INTO pga_vpl VALUES ("JM4_15","089_4_15","JAS","4","15","15","Lakin keli itakum kelimu gali, “Kan de irada ta Rabuna, nina bi ish, wa nina bi amulu haja de au dak.” ");
INSERT INTO pga_vpl VALUES ("JM4_16","089_4_16","JAS","4","16","16","Lakin hasa, itakum gi dala ashan itakum indu kebir nefsa. Shokol dala al kida de maa kweis. ");
INSERT INTO pga_vpl VALUES ("JM4_17","089_4_17","JAS","4","17","17","Ashan kida, ay zol al arufu kalam al kweis ashan uwo bi amulu, lakin maa amulu, de katiya le uwo. ");
INSERT INTO pga_vpl VALUES ("JM5_1","089_5_1","JAS","5","1","1","Asuma takum, ya nas al ganiyanin, kore takum shedid ashan taab al itakum gi ja ligo. ");
INSERT INTO pga_vpl VALUES ("JM5_2","089_5_2","JAS","5","2","2","Mali takum kalas afin, wa hasharat kalas akulu gumashat takum. ");
INSERT INTO pga_vpl VALUES ("JM5_3","089_5_3","JAS","5","3","3","Dahab wa fida takum segeru kalas, wa seger taumon de bi wori katiya takum wa bi aragu gisim takum ze nar. Itakum kazinu mali ketir, tarau akir ayam wosulu kalas. ");
INSERT INTO pga_vpl VALUES ("JM5_4","089_5_4","JAS","5","4","4","Itakum maa dafa mehiya bita nas al kaan istakal fi mahal zara takum, wa gurush al itakum maa deiru wodi de bi wori katiya takum. Asuma takum, kore ta umal del wosulu le Rabuna al Kebir. ");
INSERT INTO pga_vpl VALUES ("JM5_5","089_5_5","JAS","5","5","5","Itakum kalas ish haya al giyafa kalis fi duniya. Itakum indu ay haja al niya takum deiru. Itakum akulu ketir kalas, wa hasa yom ta gata gediya takum biga gerib. ");
INSERT INTO pga_vpl VALUES ("JM5_6","089_5_6","JAS","5","6","6","Itakum kalas gata gediya wa katulu nas al dukuri, wa umon maa difa badun. ");
INSERT INTO pga_vpl VALUES ("JM5_7","089_5_7","JAS","5","7","7","Ashan kida, ya akwana wa ikwat, keli itakum kun indu sobur lahadi yom al Rabuna bi ja fogo. Ainu, nas al gi kuruju maa gi tala taban ashan bi istena akil al kweis min mahal zara. Umon gi kun be sobur min bidaya ta matara lahadi fi nihaya tou. ");
INSERT INTO pga_vpl VALUES ("JM5_8","089_5_8","JAS","5","8","8","Itakum kaman keli kun indu sobur. Wogif takum gowi, ashan Rabuna gerib bi ja. ");
INSERT INTO pga_vpl VALUES ("JM5_9","089_5_9","JAS","5","9","9","Ya akwana wa ikwat, matakum neng-neng fi bein takum, ashan keli Rabuna maa gata gediya takum. Gadi yau hasa gi wogif fi bab. ");
INSERT INTO pga_vpl VALUES ("JM5_10","089_5_10","JAS","5","10","10","Ya akwana wa ikwat, zekiru takum anbiya al kaan bashiru fi isim ta Rabuna zamaan. Keli taab wa sobur taumon kun le itakum ze misal. ");
INSERT INTO pga_vpl VALUES ("JM5_11","089_5_11","JAS","5","11","11","Ainu, nas al gi sobur fi zaman ta taab, nina gi nadi umon mubarakin. Itakum asuma an sobur ta Ayub fi zaman al uwo kaan fi taab, wa itakum ainu haja al Rabuna amulu fi nihaya, ashan Rabuna indu maruf wa rahama. ");
INSERT INTO pga_vpl VALUES ("JM5_12","089_5_12","JAS","5","12","12","Lakin ziyada min de, ya akwana wa ikwat tai, keli itakum maa alifu be samawat au ard au ay haja tani. Lakin keli “nam” takum kun “nam” bes, wa “la” takum keli kun “la” bes, ashan keli Rabuna maa hukumu itakum. ");
INSERT INTO pga_vpl VALUES ("JM5_13","089_5_13","JAS","5","13","13","Kan fii zol fi nus takum al indu taab, keli uwo seli. Wa kan fii zol al moksut, keli uwo mejidu Rabuna. ");
INSERT INTO pga_vpl VALUES ("JM5_14","089_5_14","JAS","5","14","14","Kan fii zol fi nus takum ayan, keli uwo nadi nas kubar ta kenisa, wa keli umon seli le uwo wa masa uwo be zet fi isim ta Rabuna. ");
INSERT INTO pga_vpl VALUES ("JM5_15","089_5_15","JAS","5","15","15","Kan umon seli be iman, salawat taumon de bi aliju zol al ayan de, wa Rabuna bi gomu uwo fok. Wa kan uwo kaan amulu katiya, Rabuna bi afi uwo. ");
INSERT INTO pga_vpl VALUES ("JM5_16","089_5_16","JAS","5","16","16","Ashan kida, wori takum katiya takum le badun wa seli takum le badun ashan itakum bi ligo ilaj. Salawat ta zol al dukuri indu guwa wa gi istakal shedid. ");
INSERT INTO pga_vpl VALUES ("JM5_17","089_5_17","JAS","5","17","17","Eliya kaan insan ze nina. Uwo kaan seli ma geliba kulu gali, keli matara maa nezilu, wa matara kaan maa nezilu fi ard fi muda ta talata sena wa nus. ");
INSERT INTO pga_vpl VALUES ("JM5_18","089_5_18","JAS","5","18","18","Wa uwo kaan seli tani mara, wa matara nezilu min sama, wa ard tala akil. ");
INSERT INTO pga_vpl VALUES ("JM5_19","089_5_19","JAS","5","19","19","Ya akwana wa ikwat tai, kan fii ay zol fi nus takum woduru min sika al hagiga, wa itakum rija uwo wara, de kweis kalis. ");
INSERT INTO pga_vpl VALUES ("JM5_20","089_5_20","JAS","5","20","20","Zekir takum, kan zol amulu katiya wa woduru zede, wa itakum rija uwo wara, itakum kalas nofud zol de min nar, wa Rabuna bi afi katiya tou, salakun katiya de ketir.");
ALTER TABLE pga_vpl ADD FULLTEXT(verseText);
UNLOCK TABLES;
