﻿USE sofia;
DROP TABLE IF EXISTS sofia.pesopcb_vpl;
CREATE TABLE pesopcb_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES pesopcb_vpl WRITE;
INSERT INTO pesopcb_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","در آغاز، خدا آسمانها و زمین را آفرید. ");
INSERT INTO pesopcb_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","زمین، بی‌شکل و خالی بود، و تاریکی آبهای عمیق را پوشانده بود. و روح خدا بر سطح آبها در حرکت بود. ");
INSERT INTO pesopcb_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","خدا فرمود: «روشنایی بشود.» و روشنایی شد. ");
INSERT INTO pesopcb_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","خدا روشنایی را پسندید و آن را از تاریکی جدا ساخت. ");
INSERT INTO pesopcb_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","او روشنایی را «روز» و تاریکی را «شب» نامید. شب گذشت و صبح شد. این، روز اول بود. ");
INSERT INTO pesopcb_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","سپس خدا فرمود: «فضایی باشد بین آبها، تا آبهای بالا را از آبهای پائین جدا کند.» ");
INSERT INTO pesopcb_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","پس خدا فضایی به وجود آورد تا آبهای پائین را از آبهای بالا جدا کند. ");
INSERT INTO pesopcb_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","خدا این فضا را «آسمان» نامید. شب گذشت و صبح شد. این، روز دوم بود. ");
INSERT INTO pesopcb_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","پس از آن خدا فرمود: «آبهای زیر آسمان در یک جا جمع شوند تا خشکی پدید آید.» و چنین شد. ");
INSERT INTO pesopcb_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","خدا خشکی را «زمین» و اجتماع آبها را «دریا» نامید. و خدا دید که نیکوست. ");
INSERT INTO pesopcb_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","سپس خدا فرمود: «زمین نباتات برویاند، گیاهان دانه‌دار و درختان میوه‌دار که هر یک، نوع خود را تولید کنند.» و چنین شد. ");
INSERT INTO pesopcb_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","زمین نباتات رویانید، گیاهانی که برحسب نوع خود دانه تولید می‌کردند، و درختانی که برحسب نوع خود میوۀ دانه‌دار می‌آوردند. و خدا دید که نیکوست. ");
INSERT INTO pesopcb_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","شب گذشت و صبح شد. این، روز سوم بود. ");
INSERT INTO pesopcb_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","سپس خدا فرمود: «در آسمان اجسام نورافشانی باشند تا روز را از شب جدا کنند، و نشانه‌هایی باشند برای نشان دادن فصل‌ها، روزها، و سال‌ها. ");
INSERT INTO pesopcb_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","و این اجسام نورافشان در آسمان، بر زمین بتابند.» و چنین شد. ");
INSERT INTO pesopcb_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","پس خدا دو جسم نورافشان بزرگ ساخت: جسم نورافشان بزرگتر برای حکومت بر روز و جسم نورافشان کوچکتر برای حکومت بر شب. او همچنین ستارگان را ساخت. ");
INSERT INTO pesopcb_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","خدا آنها را در آسمان قرار داد تا زمین را روشن سازند، ");
INSERT INTO pesopcb_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","بر روز و شب حکومت کنند، و روشنایی و تاریکی را از هم جدا سازند. و خدا دید که نیکوست. ");
INSERT INTO pesopcb_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","شب گذشت و صبح شد. این، روز چهارم بود. ");
INSERT INTO pesopcb_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","سپس خدا فرمود: «آبها از موجودات زنده پر شوند و پرندگان بر فراز آسمان به پرواز درآیند.» ");
INSERT INTO pesopcb_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","پس خدا حیوانات بزرگ دریایی و انواع جانداران را که می‌جنبند و آبها را پر می‌سازند و نوع خود را تولید می‌کنند، و نیز همۀ پرندگان را که نوع خود را تولید می‌کنند، آفرید. و خدا دید که نیکوست. ");
INSERT INTO pesopcb_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","پس خدا آنها را برکت داده، فرمود: «بارور و زیاد شوید. حیوانات دریایی آبها را پُر سازند و پرندگان نیز بر زمین زیاد شوند.» ");
INSERT INTO pesopcb_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","شب گذشت و صبح شد. این، روز پنجم بود. ");
INSERT INTO pesopcb_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","سپس خدا فرمود: «زمین، انواع حیوانات را که هر یک نوع خود را تولید می‌کنند، به وجود آورد: چارپایان، خزندگان و جانوران وحشی را.» و چنین شد. ");
INSERT INTO pesopcb_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","خدا انواع جانوران وحشی، چارپایان، و تمام خزندگان را، که هر یک نوع خود را تولید می‌کنند، به وجود آورد. و خدا دید که نیکوست. ");
INSERT INTO pesopcb_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","سپس خدا فرمود: «انسان را به صورت خود و شبیه خودمان بسازیم، تا بر ماهیان دریا، پرندگان آسمان، و بر چارپایان و همۀ جانوران وحشی و خزندگان روی زمین حکومت کند.» ");
INSERT INTO pesopcb_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","پس خدا انسان را به صورت خود آفرید؛ ایشان را به صورت خدا آفرید؛ ایشان را مرد و زن آفرید. ");
INSERT INTO pesopcb_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","سپس خدا ایشان را برکت داده، فرمود: «بارور و زیاد شوید، زمین را پُر سازید، بر آن تسلط یابید، و بر ماهیان دریا و پرندگان آسمان و همۀ حیواناتی که بر زمین حرکت می‌کنند، فرمانروایی کنید.» ");
INSERT INTO pesopcb_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","آنگاه خدا گفت: «تمام گیاهان دانه‌دار روی زمین را و همۀ میوه‌های درختان را برای خوراک به شما دادم، ");
INSERT INTO pesopcb_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","و همۀ علفهای سبز را به همۀ جانوران وحشی، پرندگان آسمان و خزندگان روی زمین، یعنی به هر موجودی که جان در خود دارد، بخشیدم.» ");
INSERT INTO pesopcb_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","آنگاه خدا به آنچه آفریده بود نظر کرد و کار آفرینش را از هر لحاظ عالی دید. شب گذشت و صبح شد. این، روز ششم بود. ");
INSERT INTO pesopcb_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","به این ترتیب آفرینش آسمانها و زمین و هر چه در آنها بود، تکمیل گردید. ");
INSERT INTO pesopcb_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","با فرا رسیدن روز هفتم، خدا کار آفرینش را تمام کرد؛ پس در هفتمین روز، از همۀ کار خود بیاسود. ");
INSERT INTO pesopcb_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","خدا روز هفتم را برکت داده، آن را مقدّس اعلام فرمود، زیرا روزی بود که خدا پس از پایان کار آفرینش، آرام گرفت. ");
INSERT INTO pesopcb_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","این بود تاریخچۀ آسمانها و زمین. هنگامی که یهوه خدا آسمانها و زمین را ساخت ");
INSERT INTO pesopcb_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","هیچ بوته و گیاهی بر زمین نروییده بود، زیرا یهوه خدا هنوز باران نبارانیده بود، و همچنین آدمی نبود که روی زمین کِشت و زرع نماید؛ ");
INSERT INTO pesopcb_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","اما آب از زمین بیرون می‌آمد و تمام خشکی‌ها را سیراب می‌کرد. ");
INSERT INTO pesopcb_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","آنگاه یهوه خدا از خاکِ زمین، آدم را سرشت. سپس در بینی آدم روح حیات دمیده، به او جان بخشید و آدم، موجود زنده‌ای شد. ");
INSERT INTO pesopcb_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","پس از آن، یهوه خدا در سرزمین عدن که در شرق بود، باغی به وجود آورد و آدمی را که آفریده بود در آن باغ گذاشت. ");
INSERT INTO pesopcb_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","یهوه خدا انواع درختان زیبا در آن باغ رویانید تا میوه‌های خوش طعم دهند. او در وسط باغ، «درخت حیات» و همچنین «درخت شناخت نیک و بد» را قرار داد. ");
INSERT INTO pesopcb_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","از سرزمین عدن رودخانه‌ای به سوی باغ جاری شد تا آن را آبیاری کند. سپس این رودخانه به چهار رود کوچکتر تقسیم گردید. ");
INSERT INTO pesopcb_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","رود اول فیشون است که سراسر سرزمین حَویله را که در آنجا طلا یافت می‌شود، دور می‌زند. ");
INSERT INTO pesopcb_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","طلای آن سرزمین بسیار خالص است، و در آنجا صَمْغ خوشبو و سنگ جَزَع نیز یافت می‌شود. ");
INSERT INTO pesopcb_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","رود دوم جیحون است که از سرزمین کوش عبور می‌کند. ");
INSERT INTO pesopcb_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","سومین رود، دِجلِه است که به سوی شرق آشور جاری است و رود چهارم فرات است. ");
INSERT INTO pesopcb_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","یهوه خدا آدم را در باغ عدن گذاشت تا در آن کار کند و از آن نگهداری نماید. ");
INSERT INTO pesopcb_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","اما یهوه خدا به او گفت: «تو می‌توانی از همۀ میوه‌های درختان باغ آزادانه بخوری، ");
INSERT INTO pesopcb_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","به‌جز میوهٔ درخت شناخت نیک و بد. زیرا اگر از میوهٔ آن بخوری، مطمئن باش خواهی مرد.» ");
INSERT INTO pesopcb_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","یهوه خدا فرمود: «شایسته نیست آدم تنها بماند. باید برای او یار مناسبی به وجود آورم.» ");
INSERT INTO pesopcb_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","آنگاه یهوه خدا همهٔ حیوانات و پرندگانی را که از خاک سرشته بود، نزد آدم آورد تا ببیند آدم چه نامهایی بر آنها خواهد گذاشت. بدین ترتیب تمام حیوانات و پرندگان نامگذاری شدند. ");
INSERT INTO pesopcb_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","پس آدم تمام چارپایان و پرندگان آسمان و همۀ جانوران وحشی را نامگذاری کرد، اما برای او یار مناسبی یافت نشد. ");
INSERT INTO pesopcb_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","آنگاه یهوه خدا آدم را به خواب عمیقی فرو برد و یکی از دنده‌هایش را برداشت و جای آن را با گوشت پُر کرد. ");
INSERT INTO pesopcb_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","آنگاه یهوه خدا از آن دنده، زنی سرشت و او را پیش آدم آورد. ");
INSERT INTO pesopcb_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","آدم گفت: «این است استخوانی از استخوانهایم و گوشتی از گوشتم. نام او ”نسا“ باشد، چون از انسان گرفته شد.» ");
INSERT INTO pesopcb_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","به این سبب است که مرد از پدر و مادر خود جدا می‌شود و به زن خود می‌پیوندد، و از آن پس، آن دو یک تن می‌شوند. ");
INSERT INTO pesopcb_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","آدم و زنش هر چند برهنه بودند، ولی احساس شرم نمی‌کردند. ");
INSERT INTO pesopcb_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","مار از همهٔ حیواناتی که یهوه خدا ساخته بود، زیرکتر بود. روزی مار نزد زن آمده، به او گفت: «آیا حقیقت دارد که خدا شما را از خوردن میوهٔ تمام درختان باغ منع کرده است؟» ");
INSERT INTO pesopcb_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","زن در جواب گفت: «ما اجازه داریم از میوهٔ همهٔ درختان بخوریم، ");
INSERT INTO pesopcb_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","به‌جز میوهٔ درختی که در وسط باغ است. خدا فرموده است که از میوهٔ آن درخت نخوریم و حتی به آن دست نزنیم و گرنه می‌میریم.» ");
INSERT INTO pesopcb_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","مار گفت: «مطمئن باش نخواهید مُرد! ");
INSERT INTO pesopcb_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","بلکه خدا خوب می‌داند زمانی که از میوهٔ آن درخت بخورید، چشمان شما باز می‌شود و مانند خدا می‌شوید و می‌توانید خوب را از بد تشخیص دهید.» ");
INSERT INTO pesopcb_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","آن درخت در نظر زن، زیبا آمد و با خود اندیشید: «میوهٔ این درختِ دلپذیر، می‌تواند، خوش طعم باشد و به من دانایی ببخشد.» پس از میوهٔ درخت چید و خورد و به شوهرش هم که با او بود داد و او نیز خورد. ");
INSERT INTO pesopcb_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","آنگاه چشمانِ هر دو باز شد و ناگهان متوجۀ برهنگی خود شده، احساس شرم کردند. پس با برگهای درختِ انجیر پوششی برای خود درست کردند. ");
INSERT INTO pesopcb_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","عصر همان روز وقتی آدم و زنش، صدای یهوه خدا را که در باغ راه می‌رفت شنیدند، خود را لابلای درختان پنهان کردند. ");
INSERT INTO pesopcb_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","یهوه خدا آدم را ندا داد: «ای آدم، کجا هستی؟» ");
INSERT INTO pesopcb_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","آدم جواب داد: «صدای تو را در باغ شنیدم و ترسیدم، زیرا برهنه بودم؛ پس خود را پنهان کردم.» ");
INSERT INTO pesopcb_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","خدا فرمود: «چه کسی به تو گفت که برهنه‌ای؟ آیا از میوهٔ آن درختی خوردی که به تو گفته بودم از آن نخوری؟» ");
INSERT INTO pesopcb_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","آدم جواب داد: «این زن که یار من ساختی، از آن میوه به من داد و من هم خوردم.» ");
INSERT INTO pesopcb_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","آنگاه یهوه خدا از زن پرسید: «این چه کاری بود که کردی؟» زن گفت: «مار مرا فریب داد.» ");
INSERT INTO pesopcb_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","پس یهوه خدا به مار فرمود: «به سبب انجام این کار، از تمام حیوانات وحشی و اهلی زمین ملعونتر خواهی بود. تا زنده‌ای روی شکمت خواهی خزید و خاک خواهی خورد. ");
INSERT INTO pesopcb_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","بین تو و زن، و نیز بین نسل تو و نسل زن، خصومت می‌گذارم. نسلِ زنْ سر تو را خواهد کوبید و تو پاشنهٔ وی را خواهی زد.» ");
INSERT INTO pesopcb_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","آنگاه به زن فرمود: «درد زایمان تو را زیاد می‌کنم و تو با درد فرزندان خواهی زایید. مشتاق شوهرت خواهی بود و او بر تو تسلط خواهد داشت.» ");
INSERT INTO pesopcb_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","سپس خداوند به آدم فرمود: «چون گفتهٔ زنت را پذیرفتی و از میوهٔ آن درختی خوردی که به تو گفته بودم از آن نخوری، زمین زیر لعنت قرار خواهد گرفت و تو تمام ایام عمرت با رنج و زحمت از آن کسب معاش خواهی کرد. ");
INSERT INTO pesopcb_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","از زمین خار و خاشاک برایت خواهد رویید و گیاهان صحرا را خواهی خورد. ");
INSERT INTO pesopcb_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","تا آخر عمر به عرق پیشانی‌ات نان خواهی خورد و سرانجام به همان خاکی باز خواهی گشت که از آن گرفته شدی؛ زیرا تو از خاک سرشته شدی و به خاک هم برخواهی گشت.» ");
INSERT INTO pesopcb_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","آدم، زن خود را حَوّا (یعنی «زندگی») نامید، چون او می‌بایست مادر همهٔ زندگان شود. ");
INSERT INTO pesopcb_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","یهوه خدا لباسهایی از پوست حیوان تهیه کرد و آدم و زنش را پوشانید. ");
INSERT INTO pesopcb_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","سپس یهوه خدا فرمود: «حال که انسان مانند ما شده است و خوب و بد را می‌شناسد، مبادا دست خود را دراز کند و از میوهٔ ”درخت حیات“ نیز گرفته، بخورد و تا ابد زنده بماند.» ");
INSERT INTO pesopcb_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","پس یهوه خدا آنها را از باغ عدن بیرون راند، تا آدم برود و در زمینی که از خاکِ آن سرشته شده بود، کار کند. ");
INSERT INTO pesopcb_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","یهوه خدا پس از بیرون راندن آنها، در سمت شرقی باغ عدن کروبیانی قرار داد و نیز شمشیری آتشین در آن گذاشت که به هر طرف می‌چرخید، تا راه «درخت حیات» را محافظت کند. ");
INSERT INTO pesopcb_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","حوّا از آدم حامله شده، پسری زایید. آنگاه حوّا گفت: «به کمک خداوند مردی حاصل نمودم.» پس نام او را قائن گذاشت. ");
INSERT INTO pesopcb_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","حوّا بار دیگر حامله شده، پسری زایید و نام او را هابیل گذاشت. هابیل به گله‌داری پرداخت و قائن به کشاورزی مشغول شد. ");
INSERT INTO pesopcb_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","پس از مدتی، قائن هدیه‌ای از حاصلِ زمینِ خود را به حضور خداوند آورد. ");
INSERT INTO pesopcb_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","هابیل نیز چند رأس از نخست‌زادگان گلهٔ خود را ذبح کرد و بهترین قسمت گوشت آنها را به خداوند تقدیم نمود. خداوند هابیل و هدیه‌اش را پذیرفت، ");
INSERT INTO pesopcb_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","اما قائن و هدیه‌اش را قبول نکرد. پس قائن برآشفت و از شدت خشم سرش را به زیر افکند. ");
INSERT INTO pesopcb_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","خداوند از قائن پرسید: «چرا خشمگین شده‌ای و سرت را به زیر افکنده‌ای؟ ");
INSERT INTO pesopcb_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","اگر درست عمل کنی، آیا پذیرفته نمی‌شوی؟ اما اگر درست رفتار نکنی، بدان که گناه در کمین توست و می‌خواهد بر تو مسلط شود، ولی تو باید بر آن چیره شوی.» ");
INSERT INTO pesopcb_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","روزی قائن از برادرش هابیل خواست که با او به صحرا برود. هنگامی که آنها در صحرا بودند، ناگهان قائن به برادرش حمله کرد و او را کشت. ");
INSERT INTO pesopcb_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","آنگاه خداوند از قائن پرسید: «برادرت هابیل کجاست؟» قائن جواب داد: «از کجا بدانم؟ مگر من نگهبان برادرم هستم؟» ");
INSERT INTO pesopcb_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","خداوند فرمود: «این چه کاری بود که کردی؟ خون برادرت از زمین نزد من فریاد برمی‌آورد. ");
INSERT INTO pesopcb_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","اکنون ملعون هستی و از زمینی که با خون برادرت آن را رنگین کرده‌ای، طرد خواهی شد. ");
INSERT INTO pesopcb_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","از این پس، هر چه کار کنی، دیگر زمین محصول خود را آنچنان که باید، به تو نخواهد داد، و تو در جهان آواره و پریشان خواهی بود.» ");
INSERT INTO pesopcb_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","قائن گفت: «مجازات من سنگینتر از آن است که بتوانم تحمل کنم. ");
INSERT INTO pesopcb_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","امروز مرا از این سرزمین و از حضور خودت می‌رانی و مرا در جهان آواره و پریشان می‌گردانی، پس هر که مرا ببیند مرا خواهد کُشت.» ");
INSERT INTO pesopcb_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","خداوند به او گفت: «چنین نخواهد شد؛ زیرا هر که تو را بکشد، مجازاتش هفت برابر شدیدتر از مجازات تو خواهد بود.» سپس خداوند نشانی بر قائن گذاشت تا هرگاه کسی با او برخورد کند، او را نکشد. ");
INSERT INTO pesopcb_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","آنگاه قائن از حضور خداوند بیرون رفت و در زمین نُود (یعنی «سرگردانی») در سمت شرقی عدن ساکن شد. ");
INSERT INTO pesopcb_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","چندی بعد همسر قائن آبستن شده خَنوخ را به دنیا آورد. آنگاه قائن شهری ساخت و نام پسرش خنوخ را بر آن شهر گذاشت. ");
INSERT INTO pesopcb_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","خنوخ پدر عیراد، عیراد پدر محویائیل، محویائیل پدر متوشائیل و متوشائیل پدر لِمک بود. ");
INSERT INTO pesopcb_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","لِمک دو زن به نامهای عاده و ظله گرفت. ");
INSERT INTO pesopcb_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","عاده پسری زایید و اسم او را یابال گذاشتند. او کسی بود که خیمه‌نشینی و گله‌داری را رواج داد. ");
INSERT INTO pesopcb_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","برادرش یوبال اولین موسیقیدان و مخترع چنگ و نی بود. ");
INSERT INTO pesopcb_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","ظله، زنِ دیگر لمک هم پسری زایید که او را توبل قائن نامیدند. او کسی بود که کار ساختن آلات آهنی و مسی را شروع کرد. خواهر توبل قائن، نَعمه نام داشت. ");
INSERT INTO pesopcb_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","روزی لمک به همسران خود، عاده و ظله، گفت: «ای زنان به من گوش کنید. جوانی را که مرا مجروح کرده بود، کُشتم. ");
INSERT INTO pesopcb_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","اگر قرار است مجازات کسی که قائن را بکشد، هفت برابر مجازات قائن باشد، پس مجازات کسی هم که بخواهد مرا بکشد، هفتاد و هفت برابر خواهد بود.» ");
INSERT INTO pesopcb_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","پس از آن، آدم و حوّا صاحب پسر دیگری شدند. حوّا گفت: «خدا به جای هابیل که به دست برادرش قائن کشته شده بود، پسری دیگر به من عطا کرد.» پس نام او را شیث (یعنی «عطا شده») گذاشت. ");
INSERT INTO pesopcb_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","وقتی شیث بزرگ شد، برایش فرزندی به دنیا آمد که او را انوش نام نهادند. در زمان انوش بود که مردم به خواندن نام خداوند آغاز کردند. ");
INSERT INTO pesopcb_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","این است شرح پیدایش آدم و نسل او. هنگامی که خدا خواست انسان را بیافریند، او را شبیه خود آفرید. ");
INSERT INTO pesopcb_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","او آنها را مرد و زن خلق فرموده، برکت داد و از همان آغاز خلقت، ایشان را انسان نامید. ");
INSERT INTO pesopcb_vpl VALUES ("GN5_3‏","002_5_3‏","GEN","5","3‏","5","آدم: وقتی آدم ۱۳۰ ساله بود، پسرش شیث به دنیا آمد. او شبیه پدرش آدم بود. بعد از تولد شیث، آدم ۸۰۰ سال دیگر عمر کرد و صاحب پسران و دختران شد. آدم در سن ۹۳۰ سالگی مرد. ");
INSERT INTO pesopcb_vpl VALUES ("GN5_6‏","002_5_6‏","GEN","5","6‏","8","شیث: وقتی شیث ۱۰۵ ساله بود، پسرش انوش به دنیا آمد. بعد از تولد انوش، شیث ۸۰۷ سال دیگر عمر کرد و صاحب پسران و دختران شد. شیث در سن ۹۱۲ سالگی مرد. ");
INSERT INTO pesopcb_vpl VALUES ("GN5_9‏","002_5_9‏","GEN","5","9‏","11","انوش: وقتی انوش نود ساله بود، پسرش قینان به دنیا آمد. بعد از تولد قینان، انوش ۸۱۵ سال دیگر عمر کرد و صاحب پسران و دختران شد. انوش در سن ۹۰۵ سالگی مرد. ");
INSERT INTO pesopcb_vpl VALUES ("GN5_12‏","002_5_12‏","GEN","5","12‏","14","قینان: وقتی قینان هفتاد ساله بود، پسرش مهلل‌ئیل به دنیا آمد. بعد از تولد مهلل‌ئیل، قینان ۸۴۰ سال دیگر عمر کرد و صاحب پسران و دختران شد. او در سن ۹۱۰ سالگی مرد. ");
INSERT INTO pesopcb_vpl VALUES ("GN5_15‏","002_5_15‏","GEN","5","15‏","17","مهلل‌ئیل: وقتی مهلل‌ئیل شصت و پنج ساله بود، پسرش یارد به دنیا آمد. پس از تولد یارد، مهلل‌ئیل ۸۳۰ سال دیگر عمر کرد و صاحب پسران و دختران شد. او در سن ۸۹۵ سالگی مرد. ");
INSERT INTO pesopcb_vpl VALUES ("GN5_18‏","002_5_18‏","GEN","5","18‏","20","یارد: وقتی یارد ۱۶۲ ساله بود، پسرش خنوخ به دنیا آمد. بعد از تولد خنوخ، یارد ۸۰۰ سال دیگر عمر کرد و صاحب پسران و دختران شد. یارد در سن ۹۶۲ سالگی مرد. ");
INSERT INTO pesopcb_vpl VALUES ("GN5_21‏","002_5_21‏","GEN","5","21‏","24","خنوخ: وقتی خنوخ شصت و پنج ساله بود، پسرش متوشالح به دنیا آمد. بعد از تولد متوشالح، خنوخ ۳۰۰ سال دیگر با خدا زیست. او صاحب پسران و دخترانی شد و ۳۶۵ سال زندگی کرد. خنوخ با خدا می‌زیست و خدا او را به حضور خود به بالا برد و دیگر کسی او را ندید. ");
INSERT INTO pesopcb_vpl VALUES ("GN5_25‏","002_5_25‏","GEN","5","25‏","27","متوشالح: وقتی متوشالح ۱۸۷ ساله بود، پسرش لمک به دنیا آمد. بعد از تولد لمک، متوشالح ۷۸۲ سال دیگر زندگی کرد و صاحب پسران و دختران شد. متوشالح در سن ۹۶۹ سالگی مرد. ");
INSERT INTO pesopcb_vpl VALUES ("GN5_28‏","002_5_28‏","GEN","5","28‏","31","لمک: وقتی لمک ۱۸۲ ساله بود، پسرش نوح به دنیا آمد. لمک گفت: «این پسر، ما را از کار سختِ زراعت که در اثر لعنت خداوند بر زمین، دامنگیر ما شده، آسوده خواهد کرد.» پس لمک اسم او را نوح (یعنی «آسودگی») گذاشت. بعد از تولد نوح، لمک ۵۹۵ سال دیگر عمر کرد و صاحب پسران و دختران شد. او در سن ۷۷۷ سالگی مرد. ");
INSERT INTO pesopcb_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","نوح: نوح در سن ۵۰۰ سالگی صاحب سه پسر به نامهای سام، حام و یافث بود. ");
INSERT INTO pesopcb_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","وقتی تعداد انسانها روی زمین زیاد می‌شد، و دختران برای ایشان متولد می‌شدند، ");
INSERT INTO pesopcb_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","پسران خدا دیدند که دختران انسانها زیبا هستند، پس هر کدام را که پسندیدند، برای خود به زنی گرفتند. ");
INSERT INTO pesopcb_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","آنگاه خداوند فرمود: «روح من همیشه در انسان باقی نخواهد ماند، زیرا او موجودی است فانی و نفسانی. پس صد و بیست سال به او فرصت می‌دهم تا خود را اصلاح کند.» ");
INSERT INTO pesopcb_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","در آن روزها و نیز پس از آن، وقتی پسران خدا و دختران انسانها با هم وصلت نمودند، مردانی غول‌آسا از آنان به وجود آمدند. اینان دلاوران معروف دوران قدیم هستند. ");
INSERT INTO pesopcb_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","خداوند دید که شرارت انسان بر زمین چقدر زیاد شده است، و نیتهای دل او دائماً به بدی تمایل دارد. ");
INSERT INTO pesopcb_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","پس خداوند از آفرینش انسان متأسف شد و در دل محزون گشت. ");
INSERT INTO pesopcb_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","پس خداوند فرمود: «من نسل بشر را که آفریده‌ام از روی زمین محو می‌کنم. حتی چارپایان و خزندگان و پرندگان را نیز از بین می‌برم، زیرا از آفریدن آنها متأسف شدم.» ");
INSERT INTO pesopcb_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","اما در این میان نوح مورد لطف خداوند قرار گرفت. ");
INSERT INTO pesopcb_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","این است تاریخچۀ نوح و خاندانش: نوح در میان مردمان زمان خویش مردی صالح بود و با خدا راه می‌رفت. ");
INSERT INTO pesopcb_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","نوح سه پسر داشت به نامهای سام، حام و یافث. ");
INSERT INTO pesopcb_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","در این زمان، گناه و ظلم بسیار زیاد شده بود و از نظر خدا به اوج خود رسیده بود. ");
INSERT INTO pesopcb_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","خدا شرارت بشر بر روی زمین را مشاهده کرد، زیرا همۀ مردم دنیا فاسد شده بودند. ");
INSERT INTO pesopcb_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","پس خدا به نوح فرمود: «تصمیم گرفته‌ام تمام این مردم را هلاک کنم، زیرا زمین را از شرارت پُر ساخته‌اند. من آنها را همراه زمین از بین می‌برم. ");
INSERT INTO pesopcb_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","«اما تو، ای نوح، با چوب درخت سرو یک کشتی بساز و در آن اتاقهایی درست کن، و درون و بیرونش را با قیر بپوشان. ");
INSERT INTO pesopcb_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","آن را طوری بساز که طولش ۳۰۰ ذراع، عرضش ۵۰ ذراع و ارتفاع آن ۳۰ ذراع باشد. ");
INSERT INTO pesopcb_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","یک ذراع پایینتر از سقف، پنجره‌ای برای روشنایی کشتی بساز. در داخل آن سه طبقه بنا کن و درِ ورودی کشتی را در پهلوی آن بگذار. ");
INSERT INTO pesopcb_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","«به‌زودی من سراسر زمین را با آب خواهم پوشانید تا هر موجود زنده‌ای که در آن هست، هلاک گردد. ");
INSERT INTO pesopcb_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","اما عهد خود را با تو استوار خواهم ساخت، و تو وارد کشتی خواهی شد؛ تو و پسرانت و زنت و زنان پسرانت، همراه تو. ");
INSERT INTO pesopcb_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","از تمام حیوانات، یک جفت نر و ماده با خود به داخل کشتی ببر، تا از خطر این طوفان در امان باشند. ");
INSERT INTO pesopcb_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","جفتی از هر نوع پرنده، از هر نوع چارپا و از هر نوع خزنده نزد تو خواهند آمد تا آنها را زنده نگاه داری. ");
INSERT INTO pesopcb_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","همچنین خوراک کافی برای خود و برای تمام موجودات در کشتی ذخیره کن.» ");
INSERT INTO pesopcb_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","نوح تمام اوامر خدا را انجام داد. ");
INSERT INTO pesopcb_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","سپس خداوند به نوح فرمود: «تو و اهل خانه‌ات داخل کشتی شوید، زیرا در بین همهٔ مردمان این روزگار فقط تو را عادل یافتم. ");
INSERT INTO pesopcb_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","از همۀ حیوانات حلال گوشت، هفت جفت، نر و ماده، با خود بردار، و نیز از حیوانات نجس، یک جفت، نر و ماده، ");
INSERT INTO pesopcb_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","و از پرندگان هفت جفت، نر و ماده؛ تا بعد از طوفان، نسل آنها روی زمین باقی بماند. ");
INSERT INTO pesopcb_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","پس از یک هفته، به مدت چهل شبانه روز باران فرو خواهم ریخت و هر موجودی را که به وجود آورده‌ام، از روی زمین محو خواهم کرد.» ");
INSERT INTO pesopcb_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","پس نوح هر آنچه را که خداوند به او امر فرموده بود انجام داد. ");
INSERT INTO pesopcb_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","وقتی که آن طوفان عظیم بر زمین آمد، نوح ششصد ساله بود. ");
INSERT INTO pesopcb_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","او و همسرش به اتفاق پسران و عروسانش به درون کشتی رفتند تا از خطر طوفان در امان باشند. ");
INSERT INTO pesopcb_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","همه نوع حیوان، چه حلال گوشت چه حرام گوشت، و نیز پرندگان و خزندگان، ");
INSERT INTO pesopcb_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","همراه نوح به داخل کشتی رفتند. همان‌طوری که خدا فرموده بود، آنها جفت‌جفت، نر و ماده، در کشتی جای گرفتند. ");
INSERT INTO pesopcb_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","پس از هفت روز، آب طوفان زمین را فرا گرفت. ");
INSERT INTO pesopcb_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","وقتی نوح ششصد ساله بود، در روز هفدهم ماه دوم، همۀ آبهای زیرزمینی فوران کرد و باران به شدت از آسمان بارید. ");
INSERT INTO pesopcb_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","باران چهل شبانه روز بر زمین می‌بارید. ");
INSERT INTO pesopcb_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","اما روزی که طوفان شروع شد، نوح و همسر و پسرانش، سام و حام و یافث و زنان آنها داخل کشتی بودند. ");
INSERT INTO pesopcb_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","همراه آنان از هر نوع حیوان اهلی و وحشی، و پرنده و خزنده نیز در کشتی بودند. ");
INSERT INTO pesopcb_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","از هر نوع حیوان که نَفَس حیات در خود داشتند، دو به دو، داخل کشتی شدند. ");
INSERT INTO pesopcb_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","پس از آنکه حیوانات نر و ماده، طبق دستور خدا به نوح، وارد کشتی شدند خداوند درِ کشتی را از عقب آنها بست. ");
INSERT INTO pesopcb_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","به مدت چهل شبانه روز باران سیل‌آسا می‌بارید و به تدریج زمین را می‌پوشانید، تا اینکه کشتی از روی زمین بلند شد. ");
INSERT INTO pesopcb_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","رفته‌رفته آب آنقدر بالا آمد که کشتی روی آن شناور گردید. ");
INSERT INTO pesopcb_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","سرانجام بلندترین کوهها نیز به زیر آب فرو رفتند. ");
INSERT INTO pesopcb_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","باران آنقدر بارید که سطح آب به پانزده ذِراع بالاتر از قلهٔ کوهها رسید. ");
INSERT INTO pesopcb_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","همهٔ جاندارانِ روی زمین یعنی حیواناتِ اهلی و وحشی، خزندگان و پرندگان، با آدمیان هلاک شدند. ");
INSERT INTO pesopcb_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","هر موجودِ زنده‌ای که در خشکی بود، از بین رفت. ");
INSERT INTO pesopcb_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","بدین‌سان خدا تمام موجودات زنده را از روی زمین محو کرد، به‌جز نوح و آنانی که در کشتی همراهش بودند. ");
INSERT INTO pesopcb_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","آب تا صد و پنجاه روز همچنان روی زمین را پوشانیده بود. ");
INSERT INTO pesopcb_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","اما خدا، نوح و حیوانات درون کشتی را فراموش نکرده بود. او بادی بر سطح آبها وزانید و سیلاب کم‌کم کاهش یافت. ");
INSERT INTO pesopcb_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","آبهای زیرزمینی از فوران بازایستادند و باران قطع شد. ");
INSERT INTO pesopcb_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","آب رفته‌رفته از روی زمین کم شد. پس از صد و پنجاه روز، ");
INSERT INTO pesopcb_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","در روز هفدهم از ماه هفتم، کشتی روی کوههای آرارات قرار گرفت. ");
INSERT INTO pesopcb_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","دو ماه و نیم بعد، در حالی که آب همچنان پائین می‌رفت، قلۀ کوهها نمایان شد. ");
INSERT INTO pesopcb_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","پس از گذشت چهل روز، نوح پنجره‌ای را که برای کشتی ساخته بود، گشود ");
INSERT INTO pesopcb_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","و کلاغی رها کرد. کلاغ به این سو و آن سو پرواز می‌کرد تا آن که زمین خشک شد. ");
INSERT INTO pesopcb_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","پس از آن، کبوتری رها کرد تا ببیند آیا کبوتر می‌تواند زمین خشکی برای نشستن پیدا کند. ");
INSERT INTO pesopcb_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","اما کبوتر جایی را نیافت، زیرا هنوز آب بر سطح زمین بود. وقتی کبوتر برگشت، نوح دست خود را دراز کرد و کبوتر را گرفت و به داخل کشتی برد. ");
INSERT INTO pesopcb_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","نوح هفت روز دیگر صبر کرد و بار دیگر همان کبوتر را رها نمود. ");
INSERT INTO pesopcb_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","این بار، هنگام غروب آفتاب، کبوتر در حالی که برگ زیتون تازه‌ای به منقار داشت، نزد نوح بازگشت. پس نوح فهمید که در بیشتر نقاط، آب فرو نشسته است. ");
INSERT INTO pesopcb_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","یک هفته بعد، نوح باز همان کبوتر را رها کرد، ولی این بار کبوتر باز نگشت. ");
INSERT INTO pesopcb_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","در ششصد و یکمین سال از زندگی نوح، در اولین روز ماه اول، آب از روی زمین خشک شد. آنگاه نوح پوشش کشتی را برداشت و به بیرون نگریست و دید که سطح زمین خشک شده است. ");
INSERT INTO pesopcb_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","در روز بیست و هفتم از ماه دوم، سرانجام همه جا خشک شد. ");
INSERT INTO pesopcb_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","در این هنگام خدا به نوح فرمود: ");
INSERT INTO pesopcb_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","«اینک زمان آن رسیده که همه از کشتی خارج شوید. ");
INSERT INTO pesopcb_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","تمام حیوانات، پرندگان و خزندگان را رها کن تا تولید مثل کنند و بر روی زمین زیاد شوند.» ");
INSERT INTO pesopcb_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","پس نوح با همسر و پسران و عروسانش از کشتی بیرون آمد. ");
INSERT INTO pesopcb_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","و تمام حیوانات و خزندگان و پرندگان نیز دسته‌دسته از کشتی خارج شدند. ");
INSERT INTO pesopcb_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","آنگاه نوح مذبحی برای خداوند ساخت و از هر حیوان و پرندهٔ حلال گوشت بر آن قربانی کرد. ");
INSERT INTO pesopcb_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","خداوند از این عمل نوح خشنود گردید و با خود گفت: «من بار دیگر زمین را به خاطر انسان که دلش از کودکی به طرف گناه متمایل است، لعنت نخواهم کرد و اینچنین تمام موجودات زنده را از بین نخواهم برد. ");
INSERT INTO pesopcb_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","تا زمانی که جهان باقی است، کشت و زرع، سرما و گرما، زمستان و تابستان، و روز و شب همچنان برقرار خواهد بود.» ");
INSERT INTO pesopcb_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","خدا، نوح و پسرانش را برکت داد و به ایشان فرمود: «بارور و زیاد شوید و زمین را پُر سازید. ");
INSERT INTO pesopcb_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","همهٔ حیوانات و خزندگان زمین، پرندگان هوا و ماهیان دریا از شما خواهند ترسید، زیرا همهٔ آنها را زیر سلطهٔ شما قرار داده‌ام. ");
INSERT INTO pesopcb_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","من آنها را برای خوراک به شما داده‌ام، همان‌طور که گیاهان سبز را به شما بخشیدم. ");
INSERT INTO pesopcb_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","اما گوشت را با خونش که بدان حیات می‌بخشد نخورید. ");
INSERT INTO pesopcb_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","و من تاوان خون شما را باز می‌ستانم. آن را از هر جانوری باز می‌ستانم. تاوان جان انسان را از دست همنوعش نیز باز می‌ستانم. ");
INSERT INTO pesopcb_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","هر که خون انسانی را بریزد، خون او نیز به دست انسان ریخته خواهد شد؛ زیرا خدا انسان را به صورت خود آفرید. ");
INSERT INTO pesopcb_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","و اما شما، فرزندان زیاد تولید کنید و زمین را پُر سازید.» ");
INSERT INTO pesopcb_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","سپس خدا به نوح و پسرانش فرمود: ");
INSERT INTO pesopcb_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","«من با شما و با نسلهای آیندهٔ شما عهد می‌بندم، ");
INSERT INTO pesopcb_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","و نیز با تمام حیواناتی که با شما در کشتی بودند یعنی همۀ پرندگان، چارپایان و جانوران. ");
INSERT INTO pesopcb_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","بله، من با شما عهد می‌بندم که بعد از این هرگز موجودات زنده را به‌وسیلۀ طوفان هلاک نکنم و زمین را نیز دیگر بر اثر طوفان خراب ننمایم. ");
INSERT INTO pesopcb_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","این است نشان عهد جاودانی من: ");
INSERT INTO pesopcb_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","رنگین‌کمان خود را در ابرها می‌گذارم و این نشان عهدی خواهد بود که من با جهان بسته‌ام. ");
INSERT INTO pesopcb_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","وقتی ابرها را بالای زمین بگسترانم و رنگین‌کمان دیده شود، ");
INSERT INTO pesopcb_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","آنگاه قولی را که به شما و تمام جانداران داده‌ام به یاد خواهم آورد و دیگر هرگز تمام موجودات زنده به‌وسیلهٔ طوفان هلاک نخواهند شد. ");
INSERT INTO pesopcb_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","وقتی رنگین‌کمان را در ابرها ببینم، عهد جاودانی میان خدا و هر موجود زنده بر زمین را به یاد خواهم آورد.» ");
INSERT INTO pesopcb_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","سپس خدا به نوح گفت: «این رنگین‌کمان نشان عهدی است که من با تمام موجودات زندهٔ روی زمین می‌بندم.» ");
INSERT INTO pesopcb_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","سه پسر نوح که از کشتی خارج شدند، سام و حام و یافث بودند. (حام پدر قوم کنعان است.) ");
INSERT INTO pesopcb_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","همه قومهای دنیا از سه پسر نوح به وجود آمدند. ");
INSERT INTO pesopcb_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","نوح به کار کشاورزی مشغول شد و تاکستانی غرس نمود. ");
INSERT INTO pesopcb_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","روزی که شراب زیاد نوشیده بود، در حالت مستی در خیمه‌اش برهنه خوابید. ");
INSERT INTO pesopcb_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","حام، پدر کنعان، برهنگی پدر خود را دید و بیرون رفته به دو برادرش خبر داد. ");
INSERT INTO pesopcb_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","سام و یافث با شنیدن این خبر، ردایی روی شانه‌های خود انداخته عقب‌عقب به طرف پدرشان رفتند تا برهنگی او را نبینند. سپس او را با آن ردا پوشانیدند. ");
INSERT INTO pesopcb_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","وقتی نوح به حال عادی برگشت و فهمید که حام چه کرده است، ");
INSERT INTO pesopcb_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","گفت: «کنعان ملعون باد. برادران خود را بندهٔ بندگان باشد.» ");
INSERT INTO pesopcb_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","و نیز گفت: «متبارک باد یهوه، خدای سام! کنعان بندهٔ او باشد. ");
INSERT INTO pesopcb_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","خدا زمین یافث را وسعت بخشد، و او را شریک سعادت سام گرداند، و کنعان بندهٔ او باشد.» ");
INSERT INTO pesopcb_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","پس از طوفان، نوح ۳۵۰ سال دیگر عمر کرد ");
INSERT INTO pesopcb_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","و در سن ۹۵۰ سالگی وفات یافت. ");
INSERT INTO pesopcb_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","اینها هستند نسل سام و حام و یافث، پسران نوح، که بعد از طوفان متولد شدند: ");
INSERT INTO pesopcb_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","پسران یافث عبارت بودند از: جومر، ماجوج، مادای، یاوان، توبال، ماشَک و تیراس. ");
INSERT INTO pesopcb_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","پسران جومر: اَشکناز، ریفات و توجَرمِه. ");
INSERT INTO pesopcb_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","پسران یاوان: الیشه، ترشیش، کتیم و رودانیم. ");
INSERT INTO pesopcb_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","فرزندان این افراد به تدریج در سواحل و جزایر دنیا پخش شدند و اقوامی را با زبانهای گوناگون به وجود آوردند. ");
INSERT INTO pesopcb_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","پسران حام اینها بودند: کوش، مصرایم، فوط و کنعان. ");
INSERT INTO pesopcb_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","پسران کوش: سبا، حویله، سبته، رعمه، سبتکا. پسران رعمه: شبا و ددان. ");
INSERT INTO pesopcb_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","یکی از فرزندان کوش، شخصی بود به نام نمرود که در دنیا، دلاوری بزرگ و معروف گشت. ");
INSERT INTO pesopcb_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","او با قدرتی که خداوند به وی داده بود، تیرانداز ماهری شد؛ از این جهت، وقتی می‌خواهند از مهارتِ تیراندازی کسی تعریف کنند، می‌گویند: «خداوند تو را در تیراندازی مانند نمرود گرداند.» ");
INSERT INTO pesopcb_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","قلمرو فرمانروایی او ابتدا شامل بابِل، ارک، اَکَد و کَلنِه در سرزمین شنعار بود. ");
INSERT INTO pesopcb_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","سپس قلمرو خود را تا آشور گسترش داده، نینوا، رحوبوت عیر، کالح ");
INSERT INTO pesopcb_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","و ریسن (شهر بزرگی که بین نینوا و کالح واقع است) را بنا کرد. ");
INSERT INTO pesopcb_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","مصرایم، جد اقوام زیر بود: لودی‌ها، عنامی‌ها، لهابی‌ها، نفتوحی‌ها، ");
INSERT INTO pesopcb_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","فتروسی‌ها، کسلوحی‌ها (که فلسطینی‌ها از این قوم به وجود آمدند) و کفتوری‌ها. ");
INSERT INTO pesopcb_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","صیدون پسر ارشد کنعان بود و از کنعان اقوام زیر به وجود آمدند: حیتّی‌ها، ");
INSERT INTO pesopcb_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","یبوسی‌ها، اموری‌ها، جرجاشی‌ها، ");
INSERT INTO pesopcb_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","حوّی‌ها، عرقی‌ها، سینی‌ها، ");
INSERT INTO pesopcb_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","اروادی‌ها، صماری‌ها و حماتی‌ها. پس از آن، طوایف کنعانی منشعب شدند، ");
INSERT INTO pesopcb_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","و قلمرو کنعان از صیدون در شمال تا جرار و غزه در جنوب، و در شرق تا سدوم و عموره و ادمه و صبوئیم که نزدیک لاشع بود، می‌رسید. ");
INSERT INTO pesopcb_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","اینها نسل حام بودند که در قبایل و سرزمینهای خود زندگی می‌کردند و هر یک زبان خاص خود را داشتند. ");
INSERT INTO pesopcb_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","از نسل سام، که برادر بزرگ یافث بود، عابر به وجود آمد (عابر جد عبرانیان است). ");
INSERT INTO pesopcb_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","این است اسامی پسران سام: عیلام، آشور، ارفکشاد، لود و ارام. ");
INSERT INTO pesopcb_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","اینانند پسران ارام: عوص، حول، جاتر و ماشک. ");
INSERT INTO pesopcb_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","ارفکشاد پدر شالح، و شالح پدر عابر بود. ");
INSERT INTO pesopcb_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","عابر صاحب دو پسر شد. نام اولی فِلِج بود زیرا در زمان او بود که مردم دنیا متفرق شدند. برادر او یُقطان نام داشت. ");
INSERT INTO pesopcb_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","یُقطان جد الموداد، شالف، حضرموت، یارح، ");
INSERT INTO pesopcb_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","هدورام، اوزال، دقله، ");
INSERT INTO pesopcb_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","عوبال، ابیمائیل، شبا، ");
INSERT INTO pesopcb_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","اوفیر، حویله و یوباب بود. اینان همه از نسل یُقطان بودند. ");
INSERT INTO pesopcb_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","ایشان از نواحی میشا تا کوهستانهای شرقی سفاره پراکنده بودند و در آنجا زندگی می‌کردند. ");
INSERT INTO pesopcb_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","اینها بودند فرزندان سام که در قبایل و سرزمینهای خود زندگی می‌کردند و هر یک زبان خاص خود را داشتند. ");
INSERT INTO pesopcb_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","همهٔ افرادی که در بالا نام برده شدند، از نسل نوح بودند که بعد از طوفان، در دنیا پخش شدند و قومهای گوناگون را به وجود آوردند. ");
INSERT INTO pesopcb_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","در آن روزگار همهٔ مردم جهان به یک زبان سخن می‌گفتند. ");
INSERT INTO pesopcb_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","جمعیت دنیا رفته‌رفته زیاد می‌شد و مردم به طرف شرق کوچ می‌کردند. آنها سرانجام به دشتی وسیع و پهناور در بابِل رسیدند و در آنجا سکنی گزیدند. ");
INSERT INTO pesopcb_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","آنها با هم مشورت کرده، گفتند: «بیایید خشتها درست کنیم و آنها را خوب بپزیم.» (در آن منطقه خشت به جای سنگ و قیر به جای ملات به کار می‌رفت.) ");
INSERT INTO pesopcb_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","سپس گفتند: «بیایید شهری بزرگ برای خود بنا کنیم و برجی بلند در آن بسازیم که سرش به آسمان برسد تا نامی برای خود پیدا کنیم. این کار مانع پراکندگی ما خواهد شد.» ");
INSERT INTO pesopcb_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","اما خداوند فرود آمد تا شهر و برجی را که مردم بنا می‌کردند، ببیند. ");
INSERT INTO pesopcb_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","خداوند گفت: «مردم با هم متحد شده‌اند و همگی به یک زبان سخن می‌گویند. از این به بعد هر کاری بخواهند می‌توانند انجام دهند. ");
INSERT INTO pesopcb_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","پس بیایید به پائین برویم و زبان آنها را تغییر دهیم تا سخن یکدیگر را نفهمند.» ");
INSERT INTO pesopcb_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","این اختلافِ زبان موجب شد که آنها از بنای شهر دست بردارند؛ و به این ترتیب خداوند ایشان را روی زمین پراکنده ساخت. ");
INSERT INTO pesopcb_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","از این سبب آنجا را بابِل نامیدند، چون در آنجا بود که خداوند در زبان آنها اغتشاش ایجاد کرد و ایشان را روی زمین پراکنده ساخت. ");
INSERT INTO pesopcb_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","این است تاریخچۀ نسل سام: دو سال بعد از طوفان، وقتی سام ۱۰۰ ساله بود، پسرش ارفکشاد به دنیا آمد. ");
INSERT INTO pesopcb_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","پس از تولد ارفکشاد، سام ۵۰۰ سال دیگر زندگی کرد و صاحب پسران و دختران شد. ");
INSERT INTO pesopcb_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","وقتی ارفکشاد سی و پنج ساله بود، پسرش شالح متولد شد. ");
INSERT INTO pesopcb_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","پس از تولد شالح، ارفکشاد ۴۰۳ سال دیگر زندگی کرد و صاحب پسران و دختران شد. ");
INSERT INTO pesopcb_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","وقتی شالح سی ساله بود، پسرش عابر متولد شد. ");
INSERT INTO pesopcb_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","پس از تولد عابر، شالح ۴۰۳ سال دیگر زندگی کرد و صاحب پسران و دختران شد. ");
INSERT INTO pesopcb_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","وقتی عابر سی و چهار ساله بود، پسرش فِلِج متولد شد. ");
INSERT INTO pesopcb_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","پس از تولد فِلِج، عابر ۴۳۰ سال دیگر زندگی کرد و صاحب پسران و دختران شد. ");
INSERT INTO pesopcb_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","فِلِج سی ساله بود که پسرش رعو متولد شد. ");
INSERT INTO pesopcb_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","پس از تولد رعو، فِلِج ۲۰۹ سال دیگر زندگی کرد و صاحب پسران و دختران شد. ");
INSERT INTO pesopcb_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","وقتی رعو سی و دو ساله بود، پسرش سروج متولد شد. ");
INSERT INTO pesopcb_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","پس تولد سروج، رعو ۲۰۷ سال دیگر زندگی کرد و صاحب پسران و دختران شد. ");
INSERT INTO pesopcb_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","وقتی سروج سی ساله بود، پسرش ناحور به دنیا آمد. ");
INSERT INTO pesopcb_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","پس از تولد ناحور، سروج ۲۰۰ سال دیگر زندگی کرد و صاحب پسران و دختران شد. ");
INSERT INTO pesopcb_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","وقتی ناحور بیست و نه ساله بود، پسرش تارح، به دنیا آمد. ");
INSERT INTO pesopcb_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","پس از تولد تارح، ناحور ۱۱۹ سال دیگر زندگی کرد و صاحب پسران و دختران شد. ");
INSERT INTO pesopcb_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","تارح هفتاد ساله بود که صاحب سه پسر شد به نامهای ابرام، ناحور و هاران. ");
INSERT INTO pesopcb_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","این است تاریخچۀ نسل تارَح: تارح پدر ابرام و ناحور و هاران بود؛ و هاران پدر لوط. ");
INSERT INTO pesopcb_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","هاران در همان جایی که به دنیا آمده بود (یعنی اور کلدانیان) در برابر چشمان پدرش در سن جوانی درگذشت. ");
INSERT INTO pesopcb_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","ابرام و ناحور ازدواج کردند. نام زن ابرام سارای، و نام زن ناحور مِلکه بود. (مِلکه و خواهرش یسکه دختران برادر ناحور، یعنی هاران بودند.) ");
INSERT INTO pesopcb_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","سارای نازا بود و فرزندی نداشت. ");
INSERT INTO pesopcb_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","تارح پسرش ابرام، نوه‌اش لوط و عروسش سارای را با خود برداشت و اور کلدانیان را به قصد کنعان ترک گفت. اما وقتی آنها به شهر حران رسیدند در آنجا ماندند. ");
INSERT INTO pesopcb_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","تارح در سن ۲۰۵ سالگی در حران درگذشت. ");
INSERT INTO pesopcb_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","خداوند به ابرام فرمود: «ولایت، خانه پدری و خویشاوندان خود را رها کن و به سرزمینی که من تو را بدانجا هدایت خواهم نمود برو. ");
INSERT INTO pesopcb_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","من تو را پدر امت بزرگی می‌گردانم. تو را برکت می‌دهم و نامت را بزرگ می‌سازم و تو مایه برکت خواهی بود. ");
INSERT INTO pesopcb_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","آنانی را که تو را برکت دهند، برکت خواهم داد، و آنانی را که تو را لعنت کنند، لعنت خواهم کرد. همه مردم دنیا از تو برکت خواهند یافت.» ");
INSERT INTO pesopcb_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","پس ابرام طبق دستور خداوند، روانه شد و لوط نیز همراه او رفت. ابرام هفتاد و پنج ساله بود که حران را ترک گفت. ");
INSERT INTO pesopcb_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","او همسرش سارای و برادرزاده‌اش لوط، غلامان و تمامی دارایی خود را که در حران به دست آورده بود، برداشت و به کنعان کوچ کرد. ");
INSERT INTO pesopcb_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","وقتی به کنعان رسیدند، در کنار بلوطِ موره واقع در شکیم خیمه زدند. در آن زمان کنعانی‌ها در آن سرزمین ساکن بودند، ");
INSERT INTO pesopcb_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","آنگاه خداوند بر ابرام ظاهر شده، فرمود: «من این سرزمین را به نسل تو خواهم بخشید.» پس ابرام در آنجا مذبحی برای خداوند که بر او ظاهر شده بود، بنا کرد. ");
INSERT INTO pesopcb_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","سپس از آنجا کوچ کرده، به سرزمین کوهستانی که از طرف غرب به بیت‌ئیل و از طرف شرق به عای ختم می‌شد، رفت. ابرام در آن محل خیمه زد و مذبحی برای خداوند بنا کرده، او را پرستش نمود. ");
INSERT INTO pesopcb_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","بدین ترتیب ابرام با توقفهای پی‌درپی به سمت نِگب کوچ کرد. ");
INSERT INTO pesopcb_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","ولی در آن سرزمین قحطی شد، پس ابرام به مصر رفت تا در آنجا زندگی کند. ");
INSERT INTO pesopcb_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","وقتی به مرز سرزمین مصر نزدیک شدند، ابرام به همسرش گفت: «تو زن زیبایی هستی. ");
INSERT INTO pesopcb_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","وقتی مصری‌ها تو را ببینند، خواهند گفت: ”این زن اوست. او را بکشیم و زنش را تصاحب کنیم!“ ");
INSERT INTO pesopcb_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","پس به آنها بگو تو خواهر منی، تا به خاطر تو مرا نکشند و با من به مهربانی رفتار کنند.» ");
INSERT INTO pesopcb_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","وقتی وارد مصر شدند، مردم آنجا دیدند که سارای زن زیبایی است. ");
INSERT INTO pesopcb_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","عده‌ای از درباریانِ فرعون، سارای را دیدند و در حضور فرعون از زیبایی او بسیار تعریف کردند. فرعون دستور داد تا او را به قصرش ببرند. ");
INSERT INTO pesopcb_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","آنگاه فرعون به خاطر سارای، هدایای فراوانی از قبیل گوسفند و گاو و شتر و الاغ و غلامان و کنیزان به ابرام بخشید. ");
INSERT INTO pesopcb_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","اما خداوند، فرعون و تمام افراد قصر او را به بلای سختی مبتلا کرد، زیرا سارای، زن ابرام را به قصر خود برده بود. ");
INSERT INTO pesopcb_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","فرعونْ ابرام را به نزد خود فرا خواند و به او گفت: «این چه کاری بود که با من کردی؟ چرا به من نگفتی که سارای زن توست؟ ");
INSERT INTO pesopcb_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","چرا او را خواهر خود معرفی کردی تا او را به زنی بگیرم؟ حال او را بردار و از اینجا برو.» ");
INSERT INTO pesopcb_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","آنگاه فرعون به مأموران خود دستور داد تا ابرام و همسرش را با نوکران و کنیزان و هر آنچه داشتند روانه کنند. ");
INSERT INTO pesopcb_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","ابرام با زن خود سارای و لوط و هر آنچه که داشت به نِگِب، در جنوبِ، کنعان کوچ کرد. ");
INSERT INTO pesopcb_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","ابرام بسیار ثروتمند بود. او طلا و نقره و گله‌های فراوانی داشت. ");
INSERT INTO pesopcb_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","ابرام و همراهانش از نگب رهسپار شده، مرحله به مرحله، به سوی بیت‌ئیل رفتند، و میان بیت‌ئیل و عای، جایی که قبلاً اطراق کرده بودند، اردو زدند. ");
INSERT INTO pesopcb_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","این همان جایی بود که قبلاً ابرام در آنجا مذبحی ساخت و نام خداوند را خواند. ");
INSERT INTO pesopcb_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","لوط نیز گاوان و گوسفندان و غلامان زیادی داشت. ");
INSERT INTO pesopcb_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","ابرام و لوط به علّت داشتن گله‌های بزرگ نمی‌توانستند با هم در یک جا ساکن شوند، زیرا برای گله‌هایشان چراگاه کافی وجود نداشت ");
INSERT INTO pesopcb_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","و بین چوپانان ابرام و لوط نزاع در می‌گرفت. (در آن زمان کنعانی‌ها و فرّزی‌ها نیز در آن سرزمین ساکن بودند.) ");
INSERT INTO pesopcb_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","پس ابرام به لوط گفت: «ما قوم و خویش هستیم، و چوپانان ما نباید با یکدیگر نزاع کنند. ");
INSERT INTO pesopcb_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","مصلحت در این است که از هم جدا شویم. اینک دشتی وسیع پیش روی ماست. هر سمتی را که می‌خواهی انتخاب کن و من هم به سمت مقابل تو خواهم رفت. اگر به طرف چپ بروی، من به طرف راست می‌روم و اگر طرف راست را انتخاب کنی، من به سمت چپ می‌روم.» ");
INSERT INTO pesopcb_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","آنگاه لوط نگاهی به اطراف انداخت و تمام دره رود اردن را از نظر گذراند. همهٔ آن سرزمین تا صوغر، چون باغ عدن و مصر سرسبز بود. (هنوز خداوند شهرهای سدوم و عموره را از بین نبرده بود.) ");
INSERT INTO pesopcb_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","لوط تمام درهٔ اردن را برگزید و به طرف شرق کوچ کرد. بدین طریق او و ابرام از یکدیگر جدا شدند. ");
INSERT INTO pesopcb_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","پس ابرام در سرزمین کنعان ماند و لوط به طرف شهرهای درهٔ اردن رفت و در نزدیکی سدوم ساکن شد. ");
INSERT INTO pesopcb_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","مردمان شهر سدوم بسیار فاسد بودند و نسبت به خداوند گناه می‌ورزیدند. ");
INSERT INTO pesopcb_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","بعد از جدا شدن لوط از ابرام، خداوند به ابرام فرمود: «با دقت به اطراف خود نگاه کن! ");
INSERT INTO pesopcb_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","تمام این سرزمین را که می‌بینی، تا ابد به تو و نسل تو می‌بخشم. ");
INSERT INTO pesopcb_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","نسل تو را مانند غبار زمین بی‌شمار می‌گردانم. ");
INSERT INTO pesopcb_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","برخیز و در سراسر این سرزمین که آن را به تو می‌بخشم، بگرد.» ");
INSERT INTO pesopcb_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","آنگاه ابرام برخاست و خیمهٔ خود را جمع کرده، به بلوطستانِ ممری که در حبرون است کوچ نمود. در آنجا ابرام برای خداوند مذبحی ساخت. ");
INSERT INTO pesopcb_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","در آن زمان امرافل پادشاه بابِل، اریوک پادشاه الاسار، کَدُرلاعُمَر پادشاه عیلام و تدعال پادشاه قوئیم، ");
INSERT INTO pesopcb_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","با پادشاهان زیر وارد جنگ شدند: بارع پادشاه سدوم، برشاع پادشاه عموره، شنعاب پادشاه ادمه، شم‌ئیبر پادشاه صبوئیم، و پادشاه بالع (بالع همان صوغر است). ");
INSERT INTO pesopcb_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","پس پادشاهان سدوم، عموره، ادمه، صبوئیم و بالع با هم متحد شده، لشکرهای خود را در درۀ سدّیم که همان درۀ دریای مرده است، بسیج نمودند. ");
INSERT INTO pesopcb_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","ایشان دوازده سال زیر سلطهٔ کدرلاعمر بودند. اما در سال سیزدهم شورش نمودند و از فرمان وی سرپیچی کردند. ");
INSERT INTO pesopcb_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","در سال چهاردهم، کدرلاعمر با پادشاهان هم‌پیمانش به این قبایل حمله برده، آنها را شکست داد: رفائی‌ها در زمین عشتروت قرنین، زوزی‌ها در هام، ایمی‌ها در دشت قریتین، ");
INSERT INTO pesopcb_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","حوری‌ها در کوه سعیر تا ایل فاران واقع در حاشیهٔ صحرا. ");
INSERT INTO pesopcb_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","سپس به عین مشفاط (که بعداً قادش نامیده شد) رفتند و عمالیقی‌ها و همچنین اموری‌ها را که در حَصّون تامار ساکن بودند، شکست دادند. ");
INSERT INTO pesopcb_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","آنگاه لشکریان پادشاهان سدوم، عموره، ادمه، صبوئیم و بالع (صوغر) بیرون آمده، در وادی سِدّیم صف‌آرایی کردند. ");
INSERT INTO pesopcb_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","آنها با کدرلاعمر پادشاه عیلام، تدعال پادشاه گوییم، امرافل پادشاه بابِل، و اریوک پادشاه الاسار وارد جنگ شدند؛ چهار پادشاه علیه پنج پادشاه. ");
INSERT INTO pesopcb_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","درهٔ سدّیم پُر از چاههای قیر طبیعی بود. وقتی پادشاهان سدوم و عموره می‌گریختند، به داخل چاههای قیر افتادند، اما سه پادشاه دیگر به کوهستان فرار کردند. ");
INSERT INTO pesopcb_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","پس پادشاهان فاتح، شهرهای سدوم و عموره را غارت کردند و همهٔ اموال و مواد غذایی آنها را بردند. ");
INSERT INTO pesopcb_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","آنها لوط، برادرزادهٔ ابرام را نیز که در سدوم ساکن بود، با تمام اموالش با خود بردند. ");
INSERT INTO pesopcb_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","یکی از مردانی که از چنگ دشمن گریخته بود، این خبر را به ابرامِ عبرانی رساند. در این موقع ابرام در بلوطستانِ ممری اموری زندگی می‌کرد. (ممری اموری برادر اشکول و عانر بود که با ابرام همپیمان بودند.) ");
INSERT INTO pesopcb_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","چون ابرام از اسیری برادرزاده‌اش لوط آگاهی یافت، ۳۱۸ نفر از افراد کارآزمودهٔ خود را آماده کرد و سپاه دشمن را تا دان تعقیب نمود. ");
INSERT INTO pesopcb_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","شبانگاه ابرام همراهان خود را به چند گروه تقسیم کرده، بر دشمن حمله برد و ایشان را تار و مار کرد و تا حوبَه که در شمالِ دمشق واقع شده است، تعقیب نمود. ");
INSERT INTO pesopcb_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","ابرام، برادرزاده‌اش لوط و زنان و مردانی را که اسیر شده بودند، با همهٔ اموالِ غارت شده پس گرفت. ");
INSERT INTO pesopcb_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","هنگامی که ابرام کدرلاعمر و پادشاهان همپیمان او را شکست داده، مراجعت می‌نمود، پادشاه سدوم تا درهٔ شاوه (که بعدها درهٔ پادشاه نامیده شد) به استقبال ابرام آمد. ");
INSERT INTO pesopcb_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","همچنین مِلکیصِدِق، پادشاه سالیم که کاهن خدای متعال هم بود، برای ابرام نان و شراب آورد. ");
INSERT INTO pesopcb_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","آنگاه مِلکیصِدِق، ابرام را برکت داد و چنین گفت: «مبارک باد اَبرام از جانب خدای متعال، خالق آسمان و زمین. ");
INSERT INTO pesopcb_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","و متبارک باد خدای متعال، که دشمنانت را به دستت تسلیم کرد.» سپس ابرام از غنائم جنگی، به مِلکیصِدِق ده‌یک داد. ");
INSERT INTO pesopcb_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","پادشاه سدوم به ابرام گفت: «مردمِ مرا به من واگذار، ولی اموال را برای خود نگاه دار.» ");
INSERT INTO pesopcb_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","ابرام در جواب گفت: «قسم به یهوه خدا، خدای متعال، خالق آسمان و زمین، ");
INSERT INTO pesopcb_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","که حتی یک سر سوزن از اموال تو را برنمی‌دارم، مبادا بگویی من ابرام را ثروتمند ساختم. ");
INSERT INTO pesopcb_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","تنها چیزی که می‌پذیرم، خوراکی است که افراد من خورده‌اند؛ اما سهم عانر و اشکول و ممری را که همراه من با دشمن جنگیدند، به ایشان بده.» ");
INSERT INTO pesopcb_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","بعد از این وقایع، خداوند در رویا به ابرام چنین گفت: «ای ابرام نترس، زیرا من همچون سپر از تو محافظت خواهم کرد و اجری بسیار عظیم به تو خواهم داد.» ");
INSERT INTO pesopcb_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","اما ابرام در پاسخ گفت: «ای خداوند یهوه، این اجر تو چه فایده‌ای برای من دارد، زیرا که من فرزندی ندارم و این العازار دمشقی، غلام من، صاحب ثروتم خواهد شد. ");
INSERT INTO pesopcb_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","تو به من نسلی نبخشیده‌ای، پس غلامم وارث من خواهد شد.» ");
INSERT INTO pesopcb_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","سپس خداوند به او فرمود: «این غلام وارث تو نخواهد شد، زیرا تو خود پسری خواهی داشت و او وارث همه ثروتت خواهد شد.» ");
INSERT INTO pesopcb_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","خداوند شب هنگام ابرام را به بیرون خانه فرا خواند و به او فرمود: «ستارگان آسمان را بنگر و ببین آیا می‌توانی آنها را بشماری؟ نسل تو نیز چنین بی‌شمار خواهد بود.» ");
INSERT INTO pesopcb_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","آنگاه ابرام به خداوند ایمان آورد و خداوند این را برای او عدالت به شمار آورد. ");
INSERT INTO pesopcb_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","خدا به ابرام فرمود: «من همان خداوندی هستم که تو را از شهر اور کلدانیان بیرون آوردم تا این سرزمین را به تو دهم.» ");
INSERT INTO pesopcb_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","اما ابرام در پاسخ گفت: «خداوند یهوه، چگونه مطمئن شوم که تو این سرزمین را به من خواهی داد؟» ");
INSERT INTO pesopcb_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","خداوند به او فرمود: «یک گوسالهٔ مادهٔ سه ساله، یک بز مادهٔ سه ساله، یک قوچ سه ساله، یک قمری و یک کبوتر برای من بیاور.» ");
INSERT INTO pesopcb_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","ابرام همۀ اینها را نزد خداوند آورد و هر کدام را از بالا تا پایین دو نصف کرد و پاره‌های هر کدام از آنها را در مقابل هم گذاشت؛ ولی پرنده‌ها را نصف نکرد. ");
INSERT INTO pesopcb_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","و لاشخورهایی را که بر اجساد حیوانات می‌نشستند، دور نمود. ");
INSERT INTO pesopcb_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","هنگام غروب، ابرام به خواب عمیقی فرو رفت. در عالم خواب، تاریکی وحشتناکی او را احاطه کرد. ");
INSERT INTO pesopcb_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","آنگاه خداوند به ابرام فرمود: «یقین بدان که نسل تو مدت چهارصد سال در مملکت بیگانه‌ای بندگی خواهند کرد و مورد ظلم و ستم قرار خواهند گرفت. ");
INSERT INTO pesopcb_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","اما من آن قومی را که ایشان را اسیر سازند، مجازات خواهم نمود و سرانجام نسل تو با اموال زیاد از آنجا بیرون خواهند آمد. ");
INSERT INTO pesopcb_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","(تو نیز در کمال پیری در آرامش خواهی مُرد و دفن شده، به پدرانت خواهی پیوست.) ");
INSERT INTO pesopcb_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","آنها بعد از چهار نسل، به این سرزمین باز خواهند گشت، زیرا شرارت قوم اموری که در اینجا زندگی می‌کنند، هنوز به اوج خود نرسیده است.» ");
INSERT INTO pesopcb_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","وقتی آفتاب غروب کرد و هوا تاریک شد، تنوری پُر دود و مشعلی فروزان از وسط پاره‌های حیوانات گذشت. ");
INSERT INTO pesopcb_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","آن روز خداوند با ابرام عهد بست و فرمود: «من این سرزمین را از مرز مصر تا رود فرات به نسل تو می‌بخشم، ");
INSERT INTO pesopcb_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","یعنی سرزمین اقوام قینی، قِنِزّی، قَدمونی، ");
INSERT INTO pesopcb_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","حیتّی، فِرزّی، رِفایی، ");
INSERT INTO pesopcb_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","اَموری، کَنعانی، جِرجاشی و یِبوسی را.» ");
INSERT INTO pesopcb_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","اما سارای زن ابرام، فرزندی برای او به دنیا نیاورده بود. سارای کنیز مصری داشت به نام هاجر. ");
INSERT INTO pesopcb_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","پس سارای به ابرام گفت: «خداوند مرا از بچه‌دار شدن بازداشته است. پس تو با کنیزم همبستر شو، تا شاید برای من فرزندی به دنیا آوَرَد.» ابرام با پیشنهاد سارای موافقت کرد. ");
INSERT INTO pesopcb_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","پس سارای، همسر ابرام، کنیز مصری خود هاجر را گرفته، به ابرام به زنی داد. (این واقعه ده سال پس از سکونت ابرام در کنعان اتفاق افتاد.) ");
INSERT INTO pesopcb_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","ابرام با هاجر همبستر شد و او آبستن گردید. هاجر وقتی دریافت که حامله است، مغرور شد و از آن پس، بانویش سارای را تحقیر می‌کرد. ");
INSERT INTO pesopcb_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","آنگاه سارای به ابرام گفت: «تقصیر توست که این کنیز مرا حقیر می‌شمارد. خودم او را به تو دادم، ولی از آن لحظه‌ای که فهمید آبستن است، مرا تحقیر می‌کند. خداوند خودش حق مرا از تو بگیرد.» ");
INSERT INTO pesopcb_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","ابرام جواب داد: «او کنیز توست، هر طور که صلاح می‌دانی با او رفتار کن.» پس سارای بنای بدرفتاری با هاجر را گذاشت و او از خانه فرار کرد. ");
INSERT INTO pesopcb_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","فرشتهٔ خداوند هاجر را نزدیک چشمۀ آبی در صحرا که سر راه «شور» است، یافت. ");
INSERT INTO pesopcb_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","فرشته گفت: «ای هاجر، کنیز سارای، از کجا آمده‌ای و به کجا می‌روی؟» گفت: «من از خانهٔ بانویم سارای فرار می‌کنم.» ");
INSERT INTO pesopcb_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","فرشتهٔ خداوند به او گفت: «نزد بانوی خود برگرد و مطیع او باش.» ");
INSERT INTO pesopcb_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","و نیز گفت: «من نسل تو را بی‌شمار می‌گردانم.» ");
INSERT INTO pesopcb_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","فرشته ادامه داد: «اینک تو حامله هستی، و پسری خواهی زایید. نام او را اسماعیل (یعنی ”خدا می‌شنود“) بگذار، چون خداوند آه و نالهٔ تو را شنیده است. ");
INSERT INTO pesopcb_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","پسر تو مردی وحشی خواهد بود و با برادران خود سر سازگاری نخواهد داشت. او بر ضد همه و همه بر ضد او خواهند بود.» ");
INSERT INTO pesopcb_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","هاجر با خود گفت: «آیا براستی خدا را دیدم و زنده ماندم؟» پس خداوند را که با او سخن گفته بود «اَنتَ ایل رُئی» (یعنی «تو خدایی هستی که می‌بینی») نامید. ");
INSERT INTO pesopcb_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","به همین جهت چاهی که بین قادش و بارد است «بئرلَحَی رُئی» (یعنی «چاه خدای زنده‌ای که مرا می‌بیند») نامیده شد. ");
INSERT INTO pesopcb_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","پس هاجر برای ابرام پسری به دنیا آورد و ابرام او را اسماعیل نامید. ");
INSERT INTO pesopcb_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","در این زمان ابرام هشتاد و شش ساله بود. ");
INSERT INTO pesopcb_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","وقتی ابرام نود و نه ساله بود، خداوند بر او ظاهر شد و فرمود: «من اِل شَدّای، خدای قادر مطلق هستم. از من اطاعت کن و آنچه راست است بجا آور. ");
INSERT INTO pesopcb_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","با تو عهد می‌بندم که نسل تو را زیاد کنم.» ");
INSERT INTO pesopcb_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","آنگاه ابرام رو به زمین خم شد و خدا به وی گفت: ");
INSERT INTO pesopcb_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","«من با تو عهد می‌بندم که قومهای بسیار از تو به وجود آورم. ");
INSERT INTO pesopcb_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","از این پس نام تو ابرام نخواهد بود، بلکه ابراهیم؛ زیرا من تو را پدر قومهای بسیار می‌سازم. ");
INSERT INTO pesopcb_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","نسل تو را بسیار زیاد می‌کنم و از آنها قومها و پادشاهان به وجود می‌آورم. ");
INSERT INTO pesopcb_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","من عهد خود را تا ابد با تو و بعد از تو با فرزندانت، نسل اندر نسل برقرار می‌کنم. من خدای تو هستم و خدای فرزندانت نیز خواهم بود. ");
INSERT INTO pesopcb_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","تمامی سرزمین کنعان را که اکنون در آن غریب هستی، تا ابد به تو و به نسل تو خواهم بخشید و خدای ایشان خواهم بود.» ");
INSERT INTO pesopcb_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","آنگاه خدا به ابراهیم فرمود: «وظیفهٔ توست که عهد مرا نگاه داری، تو و فرزندانت و نسلهای بعد. ");
INSERT INTO pesopcb_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","این است عهدی که تو و نسلت باید نگاه دارید: تمام مردان و پسران شما باید ختنه شوند. ");
INSERT INTO pesopcb_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","باید گوشت قُلفۀ خود را ببرید تا بدین وسیله نشان دهید که عهد مرا پذیرفته‌اید. ");
INSERT INTO pesopcb_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","«در نسلهای شما، هر پسر هشت روزه باید ختنه شود. این قانون شامل تمام مردان خانه‌زاد و زرخرید هم می‌شود. ");
INSERT INTO pesopcb_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","همه باید ختنه شوند و این نشانی بر بدن شما خواهد بود از عهد جاودانی من. ");
INSERT INTO pesopcb_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","هر کس نخواهد ختنه شود، باید از قومِ خود منقطع شود، زیرا عهد مرا شکسته است.» ");
INSERT INTO pesopcb_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","خدا همچنین فرمود: «اما در خصوص سارای، زن تو: بعد از این دیگر او را سارای مخوان. نام او سارا (یعنی ”شاهزاده“) خواهد بود. ");
INSERT INTO pesopcb_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","من او را برکت خواهم داد و از وی به تو پسری خواهم بخشید. بله، او را بسیار برکت خواهم داد و از او قومهای بسیار به وجود خواهم آورد. از میان فرزندان تو، پادشاهان خواهند برخاست.» ");
INSERT INTO pesopcb_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","آنگاه ابراهیم سجده کرد و خندید و در دل خود گفت: «آیا برای مرد صد ساله پسری متولد شود و سارا در نود سالگی بزاید؟» ");
INSERT INTO pesopcb_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","پس به خدا عرض کرد: «خداوندا، همان اسماعیل را منظور بدار.» ");
INSERT INTO pesopcb_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","ولی خدا فرمود: «مطمئن باش خودِ سارا برای تو پسری خواهد زایید و تو نام او را اسحاق (یعنی ”خنده“) خواهی گذاشت. من عهد خود را با او و نسل وی تا ابد برقرار خواهم ساخت. ");
INSERT INTO pesopcb_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","اما در مورد اسماعیل نیز تقاضای تو را اجابت نمودم و او را برکت خواهم داد و نسل او را چنان زیاد خواهم کرد که قوم بزرگی از او به وجود آید. دوازده امیر از میان فرزندان او برخواهند خاست. ");
INSERT INTO pesopcb_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","اما عهد خود را با اسحاق که سارا او را سال دیگر در همین موقع برای تو خواهد زایید، استوار می‌سازم.» ");
INSERT INTO pesopcb_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","آنگاه خدا از سخن گفتن با ابراهیم بازایستاد و از نزد او رفت. ");
INSERT INTO pesopcb_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","سپس ابراهیم، فرزندش اسماعیل و سایر مردان و پسرانی را که در خانه‌اش بودند، چنانکه خدا فرموده بود ختنه کرد. ");
INSERT INTO pesopcb_vpl VALUES ("GN17_24‏","002_17_24‏","GEN","17","24‏","27","در آن زمان ابراهیم نود و نه ساله و اسماعیل سیزده ساله بود. هر دو آنها در همان روز با سایر مردان و پسرانی که در خانه‌اش بودند، چه خانه‌زاد و چه زرخرید، ختنه شدند. ");
INSERT INTO pesopcb_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","هنگامی که ابراهیم در بلوطستان ممری سکونت داشت، خداوند بار دیگر بر او ظاهر شد. شرح واقعه چنین است: ابراهیم در گرمای روز بر در خیمه خود نشسته بود. ");
INSERT INTO pesopcb_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","ناگهان متوجه شد که سه مرد به طرفش می‌آیند. پس از جا برخاست و به استقبال آنها شتافت. ابراهیم رو به زمین نهاده، ");
INSERT INTO pesopcb_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","گفت: «ای سَروَرم، تمنا می‌کنم اندکی توقف کرده، ");
INSERT INTO pesopcb_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","در زیر سایه این درخت استراحت کنید. من می‌روم و برای شستن پاهای شما آب می‌آورم. ");
INSERT INTO pesopcb_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","لقمه نانی نیز خواهم آورد تا بخورید و قوت بگیرید و بتوانید به سفر خود ادامه دهید. شما میهمان من هستید.» آنها گفتند: «آنچه گفتی بکن.» ");
INSERT INTO pesopcb_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","آنگاه ابراهیم با شتاب به خیمه برگشت و به سارا گفت: «عجله کن! چند نان از بهترین آردی که داری بپز.» ");
INSERT INTO pesopcb_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","سپس خودش به طرف گله دویده، یک گوسالهٔ خوب گرفت و به نوکر خود داد تا هر چه زودتر آن را آماده کند. ");
INSERT INTO pesopcb_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","طولی نکشید که ابراهیم مقداری کره و شیر و کباب برای مهمانان خود آورد و جلوی آنها گذاشت و در حالی که آنها مشغول خوردن بودند، زیر درختی در کنار ایشان ایستاد. ");
INSERT INTO pesopcb_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","مهمانان از ابراهیم پرسیدند: «همسرت سارا کجاست؟» جواب داد: «او در خیمه است.» ");
INSERT INTO pesopcb_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","آنگاه یکی از ایشان گفت: «سال بعد در چنین زمانی نزد تو خواهم آمد و سارا پسری خواهد زایید!» (سارا پشت درِ خیمه ایستاده بود و به سخنان آنها گوش می‌داد.) ");
INSERT INTO pesopcb_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","در آن وقت ابراهیم و سارا هر دو بسیار پیر بودند و دیگر از سارا گذشته بود که صاحب فرزندی شود. ");
INSERT INTO pesopcb_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","پس سارا در دل خود خندید و گفت: «آیا زنی به سن و سال من با چنین شوهر پیری می‌تواند بچه‌دار شود؟» ");
INSERT INTO pesopcb_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","خداوند به ابراهیم گفت: «چرا سارا خندید و گفت: ”آیا زنی به سن و سال من می‌تواند بچه‌دار شود؟“ ");
INSERT INTO pesopcb_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","مگر کاری هست که برای خداوند مشکل باشد؟ همان‌طوری که به تو گفتم سال بعد، در چنین زمانی نزد تو خواهم آمد و سارا پسری خواهد زایید.» ");
INSERT INTO pesopcb_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","اما سارا چون ترسیده بود، انکار نموده، گفت: «من نخندیدم!» گفت: «چرا خندیدی!» ");
INSERT INTO pesopcb_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","آنگاه آن سه مرد برخاستند تا به شهر سدوم بروند و ابراهیم نیز برخاست تا ایشان را بدرقه کند. ");
INSERT INTO pesopcb_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","اما خداوند گفت: «آیا نقشهٔ خود را از ابراهیم پنهان کنم؟ ");
INSERT INTO pesopcb_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","حال آنکه از وی قومی بزرگ و قوی پدید خواهد آمد و همهٔ قومهای جهان از او برکت خواهند یافت. ");
INSERT INTO pesopcb_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","من او را برگزیده‌ام تا فرزندان و اهل خانهٔ خود را تعلیم دهد که مرا اطاعت نموده، آنچه را که راست و درست است به جا آورند. اگر چنین کنند من نیز آنچه را که به او وعده داده‌ام، انجام خواهم داد.» ");
INSERT INTO pesopcb_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","پس خداوند به ابراهیم فرمود: «فریاد علیه ظلمِ مردم سدوم و عموره بلند شده است و گناهان ایشان بسیار زیاد گشته است. ");
INSERT INTO pesopcb_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","پس به پایین می‌روم تا به فریادی که به گوش من رسیده است، رسیدگی کنم.» ");
INSERT INTO pesopcb_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","آنگاه آن دو نفر به جانب شهر سدوم روانه شدند، ولی خداوند نزد ابراهیم ماند. ");
INSERT INTO pesopcb_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","ابراهیم به او نزدیک شده، گفت: «خداوندا، آیا عادلان را با بدکاران با هم هلاک می‌کنی؟ ");
INSERT INTO pesopcb_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","شاید پنجاه عادل در آن شهر باشند. آیا به خاطر آنها، از نابود کردن آنجا صرفنظر نخواهی کرد؟ ");
INSERT INTO pesopcb_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","یقین دارم که تو عادلان را با بدکاران هلاک نخواهی نمود. چطور ممکن است با عادلان و بدکاران یکسان رفتار کنی؟ آیا داور تمام جهان از روی عدل و انصاف داوری نخواهد کرد؟» ");
INSERT INTO pesopcb_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","خداوند در پاسخ ابراهیم فرمود: «اگر پنجاه عادل در شهر سدوم پیدا کنم، به خاطر آنها از نابود کردن آنجا صرفنظر خواهم کرد.» ");
INSERT INTO pesopcb_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","ابراهیم باز عرض کرد: «به منِ ناچیز و خاکی اجازه بده جسارت کرده، بگویم که ");
INSERT INTO pesopcb_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","اگر در شهر سدوم فقط چهل و پنج عادل باشند، آیا برای پنج نفر کمتر، شهر را نابود خواهی کرد؟» خداوند فرمود: «اگر چهل و پنج نفر آدم درستکار در آنجا باشند، آن را از بین نخواهم برد.» ");
INSERT INTO pesopcb_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","ابراهیم باز به سخنان خود ادامه داد و گفت: «شاید چهل نفر باشند!» خداوند فرمود: «اگر چهل نفر هم باشند آنجا را از بین نخواهم برد.» ");
INSERT INTO pesopcb_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","ابراهیم عرض کرد: «تمنا اینکه غضبناک نشوی و اجازه دهی سخن گویم. شاید در آنجا سی نفر پیدا کنی!» خداوند فرمود: «اگر سی نفر یافت شوند، من آنجا را از بین نخواهم برد.» ");
INSERT INTO pesopcb_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","ابراهیم عرض کرد: «جسارت مرا ببخش و اجازه بده بپرسم اگر بیست عادل در آنجا یافت شوند، آیا باز هم آنجا را نابود خواهی کرد؟» خداوند فرمود: «اگر بیست نفر هم باشند شهر را نابود نخواهم کرد.» ");
INSERT INTO pesopcb_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","ابراهیم بار دیگر عرض کرد: «خداوندا، غضبت افروخته نشود! این آخرین سؤال من است. شاید ده نفر عادل در آن شهر یافت شوند!» خداوند فرمود: «اگر چنانچه ده عادل نیز باشند، شهر را نابود نخواهم کرد.» ");
INSERT INTO pesopcb_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","خداوند پس از پایان گفتگو با ابراهیم، از آنجا رفت و ابراهیم به خیمه‌اش بازگشت. ");
INSERT INTO pesopcb_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","غروب همان روز وقتی که آن دو فرشته به دروازهٔ شهر سدوم رسیدند، لوط در آنجا نشسته بود. به محض مشاهدهٔ آنها، از جا برخاست و به استقبالشان شتافت و روی بر زمین نهاده، گفت: ");
INSERT INTO pesopcb_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","«ای سَروَرانم، امشب به منزل من بیایید و پاهایتان را بشویید و میهمان من باشید. فردا صبحِ زود هر وقت بخواهید، می‌توانید حرکت کنید.» ولی آنها گفتند: «در میدان شهر شب را به سر خواهیم برد.» ");
INSERT INTO pesopcb_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","اما لوط آنقدر اصرار نمود تا اینکه آنها راضی شدند و به خانهٔ وی رفتند. او نان فطیر پخت و شام مفصلی تهیه دید و به ایشان داد که خوردند. ");
INSERT INTO pesopcb_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","سپس در حالی که آماده می‌شدند که بخوابند، مردان شهر سدوم، پیر و جوان، از گوشه و کنار شهر، منزل لوط را محاصره کرده، ");
INSERT INTO pesopcb_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","فریاد زدند: «ای لوط، آن دو مرد را که امشب میهمان تو هستند، پیش ما بیرون بیاور تا آنها را بشناسیم.» ");
INSERT INTO pesopcb_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","لوط از منزل خارج شد تا با آنها صحبت کند و در را پشت سر خود بست. ");
INSERT INTO pesopcb_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","او به ایشان گفت: «نه، ای برادران من، خواهش می‌کنم چنین کار زشتی نکنید. ");
INSERT INTO pesopcb_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","ببینید، من دو دختر باکره دارم. آنها را به شما می‌دهم. هر کاری که دلتان می‌خواهد با آنها بکنید؛ اما با این دو مرد کاری نداشته باشید، چون آنها در پناه من هستند.» ");
INSERT INTO pesopcb_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","مردان شهر جواب دادند: «از سر راه ما کنار برو! ما اجازه دادیم در شهر ما ساکن شوی و حالا به ما امر و نهی می‌کنی. الان با تو بدتر از آن کاری که می‌خواستیم با آنها بکنیم، خواهیم کرد.» آنگاه به طرف لوط حمله برده، شروع به شکستن در خانهٔ او نمودند. ");
INSERT INTO pesopcb_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","اما آن دو مرد دست خود را دراز کرده، لوط را به داخل خانه کشیدند و در را بستند، ");
INSERT INTO pesopcb_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","و چشمان تمام مردانی را که در بیرون خانه بودند، کور کردند تا نتوانند درِ خانه را پیدا کنند. ");
INSERT INTO pesopcb_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","آن دو مرد از لوط پرسیدند: «در این شهر چند نفر قوم و خویش داری؟ پسران و دختران و دامادان و هر کسی را که داری از این شهر بیرون ببر. ");
INSERT INTO pesopcb_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","زیرا می‌خواهیم این شهر را نابود کنیم. فریاد علیه ظلمِ مردمِ این شهر به حضور خداوند رسیده و او ما را فرستاده است تا آن را ویران کنیم.» ");
INSERT INTO pesopcb_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","پس لوط با شتاب رفت و به نامزدان دخترانش گفت: «عجله کنید! از شهر بگریزید، چون خداوند می‌خواهد آن را ویران کند!» ولی این حرف به نظر آنها مسخره آمد. ");
INSERT INTO pesopcb_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","سپیده دم روز بعد، آن دو فرشته به لوط گفتند: «عجله کن! همسر و دو دخترت را که اینجا هستند بردار و تا دیر نشده فرار کن وگرنه شما هم با مردمِ گناهکار این شهر هلاک خواهید شد.» ");
INSERT INTO pesopcb_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","در حالی که لوط درنگ می‌کرد آن دو مرد دستهای او و زن و دو دخترش را گرفته، به جای امنی در خارج از شهر بردند، چون خداوند بر آنها رحم کرده بود. ");
INSERT INTO pesopcb_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","یکی از آن دو مرد به لوط گفت: «برای نجات جان خود فرار کنید و به پشت سر هم نگاه نکنید. به کوهستان بروید، چون اگر در دشت بمانید مرگتان حتمی است.» ");
INSERT INTO pesopcb_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","لوط جواب داد: «ای سَروَرم، تمنا می‌کنم از ما نخواهید چنین کاری بکنیم. ");
INSERT INTO pesopcb_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","تو در حق من خوبی کرده، جانم را نجات داده‌ای، و محبت بزرگی در حق من کرده‌ای. اما من نمی‌توانم به کوهستان فرار کنم، زیرا می‌ترسم قبل از رسیدن به آنجا این بلا دامنگیر من بشود و بمیرم. ");
INSERT INTO pesopcb_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","ببینید این دهکده چقدر نزدیک و کوچک است! اینطور نیست؟ پس بگذارید به آنجا بروم و در امان باشم.» ");
INSERT INTO pesopcb_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","او گفت: «بسیار خوب، خواهش تو را می‌پذیرم و آن دهکده را خراب نخواهم کرد. ");
INSERT INTO pesopcb_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","پس عجله کن! زیرا تا وقتی به آنجا نرسیده‌ای، نمی‌توانم کاری انجام دهم.» (به این دلیل آن دهکده را صوغر یعنی «کوچک» نام نهادند.) ");
INSERT INTO pesopcb_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","آفتاب داشت طلوع می‌کرد که لوط وارد صوغر شد. ");
INSERT INTO pesopcb_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","آنگاه خداوند از آسمان گوگرد مشتعل بر سدوم و عموره بارانید ");
INSERT INTO pesopcb_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","و آن دو شهر را با همهٔ شهرها و دهات آن دشت و تمام سکنه و نباتات آن به کلی نابود کرد. ");
INSERT INTO pesopcb_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","اما زن لوط به پشت سر نگاه کرد و به ستونی از نمک مبدل گردید. ");
INSERT INTO pesopcb_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","ابراهیم صبح زود برخاست و به سوی همان مکانی که در آن به حضور خداوند ایستاده بود، شتافت. ");
INSERT INTO pesopcb_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","او به سوی شهرهای سدوم و عموره و آن دشت نظر انداخت و دید که اینک دود از آن شهرها چون دود کوره بالا می‌رود. ");
INSERT INTO pesopcb_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","هنگامی که خدا شهرهای دشتی را که لوط در آن ساکن بود نابود می‌کرد، دعای ابراهیم را اجابت فرمود و لوط را از گرداب مرگ که آن شهرها را به کام خود کشیده بود، رهانید. ");
INSERT INTO pesopcb_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","اما لوط ترسید در صوغر بماند. پس آنجا را ترک نموده، با دو دختر خود به کوهستان رفت و در غاری ساکن شد. ");
INSERT INTO pesopcb_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","روزی دختر بزرگ لوط به خواهرش گفت: «در تمامی این ناحیه مردی یافت نمی‌شود تا با ما ازدواج کند. پدر ما هم به‌زودی پیر خواهد شد و دیگر نخواهد توانست نسلی از خود باقی گذارد. ");
INSERT INTO pesopcb_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","پس بیا به او شراب بنوشانیم و با وی همبستر شویم و به این طریق نسل پدرمان را حفظ کنیم.» ");
INSERT INTO pesopcb_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","پس همان شب او را مست کردند و دختر بزرگتر با پدرش همبستر شد. اما لوط از خوابیدن و برخاستن دخترش آگاه نشد. ");
INSERT INTO pesopcb_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","صبح روز بعد، دختر بزرگتر به خواهر کوچک خود گفت: «من دیشب با پدرم همبستر شدم. بیا تا امشب هم دوباره به او شراب بنوشانیم و این دفعه تو برو و با او همبستر شو تا بدین وسیله نسلی از پدرمان نگه داریم.» ");
INSERT INTO pesopcb_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","پس آن شب دوباره او را مست کردند و دختر کوچکتر با او همبستر شد. این بار هم لوط مثل دفعهٔ پیش چیزی نفهمید. ");
INSERT INTO pesopcb_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","بدین طریق آن دو دختر از پدر خود حامله شدند. ");
INSERT INTO pesopcb_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","دختر بزرگتر پسری زایید و او را موآب نامید. (قبیلهٔ موآب از او به وجود آمد.) ");
INSERT INTO pesopcb_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","دختر کوچکتر نیز پسری زایید و نام او را بِن‌عمّی گذاشت. (قبیله عمون از او به وجود آمد.) ");
INSERT INTO pesopcb_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","آنگاه ابراهیم به سوی سرزمین نِگِب در جنوب کوچ کرد و مدتی بین قادش و شور ساکن شد، و بعد به جرار رفت. وقتی ابراهیم در جرار بود، ");
INSERT INTO pesopcb_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","سارا را خواهر خود معرفی کرد. پس اَبیمِلِک، پادشاه جرار، کسانی فرستاد تا سارا را به قصر وی ببرند. ");
INSERT INTO pesopcb_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","اما همان شب خدا در خواب بر ابیملک ظاهر شده، گفت: «تو خواهی مُرد، زیرا زن شوهرداری را گرفته‌ای.» ");
INSERT INTO pesopcb_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","اَبیمِلِک هنوز با او همبستر نشده بود، پس عرض کرد: «خداوندا، من بی‌تقصیرم. آیا تو مرا و قوم بی‌گناهم را خواهی کشت؟ ");
INSERT INTO pesopcb_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","خودِ ابراهیم به من گفت که او خواهرش است و سارا هم سخن او را تصدیق کرد و گفت که او برادرش می‌باشد. من هیچگونه قصد بدی نداشتم.» ");
INSERT INTO pesopcb_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","خدا گفت: «بله، می‌دانم؛ به همین سبب بود که تو را از گناه باز داشتم و نگذاشتم به او دست بزنی. ");
INSERT INTO pesopcb_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","اکنون این زن را به شوهرش بازگردان. او یک نبی است و برای تو دعا خواهد کرد و تو زنده خواهی ماند. ولی اگر زن او را بازنگردانی، تو و اهل خانه‌ات خواهید مُرد.» ");
INSERT INTO pesopcb_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","روز بعد، اَبیمِلِک صبح زود از خواب برخاسته، با عجله تمامی خادمانش را فرا خواند و خوابی را که دیده بود برای آنها تعریف کرد و همگی بسیار ترسیدند. ");
INSERT INTO pesopcb_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","آنگاه پادشاه، ابراهیم را به حضور خوانده، گفت: «این چه کاری بود که با ما کردی؟ مگر من به تو چه کرده بودم که مرا و مملکتم را به چنین گناه عظیمی دچار ساختی؟ هیچ‌کس چنین کاری نمی‌کرد که تو کردی. ");
INSERT INTO pesopcb_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","چه دیدی که به من این بدی را کردی؟» ");
INSERT INTO pesopcb_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","ابراهیم در جواب گفت: «فکر کردم مردم این شهر ترسی از خدا ندارند و برای این که همسرم را تصاحب کنند، مرا خواهند کشت. ");
INSERT INTO pesopcb_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","درضمن، او خواهر ناتنی من نیز هست. هر دو از یک پدر هستیم و من او را به زنی گرفتم. ");
INSERT INTO pesopcb_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","هنگامی که خداوند مرا از زادگاهم به سرزمینهای دور و بیگانه فرستاد، از سارا خواستم این خوبی را در حق من بکند که هر جا برویم بگوید خواهر من است.» ");
INSERT INTO pesopcb_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","پس اَبیمِلِک گوسفندان و گاوان و غلامان و کنیزان به ابراهیم بخشید و همسرش سارا را به وی بازگردانید، ");
INSERT INTO pesopcb_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","و به او گفت: «تمامی سرزمین مرا بگرد و هر جا را که پسندیدی برای سکونت خود انتخاب کن.» ");
INSERT INTO pesopcb_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","سپس رو به سارا نموده، گفت: «هزار مثقال نقره به برادرت می‌دهم تا بی‌گناهی تو بر آنانی که با تو هستند ثابت شود و مردم بدانند که نسبت به تو به انصاف رفتار شده است.» ");
INSERT INTO pesopcb_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","آنگاه ابراهیم نزد خدا دعا کرد و خدا پادشاه و همسر و کنیزان او را شفا بخشید تا بتوانند صاحب اولاد شوند؛ ");
INSERT INTO pesopcb_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","زیرا خداوند به این دلیل که ابیملک، سارا زن ابراهیم را گرفته بود، همهٔ زنانش را نازا ساخته بود. ");
INSERT INTO pesopcb_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","خداوند به وعده‌ای که به سارا داده بود، وفا کرد. ");
INSERT INTO pesopcb_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","سارا در زمانی که خداوند مقرر فرموده بود، حامله شد و برای ابراهیم در سن پیری پسری زایید. ");
INSERT INTO pesopcb_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","ابراهیم پسرش را که سارا برای او به دنیا آورده بود، اِسحاق (یعنی «خنده») نام نهاد؛ ");
INSERT INTO pesopcb_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","و ابراهیم طبق فرمان خدا اسحاق را هشت روز بعد از تولدش ختنه کرد. ");
INSERT INTO pesopcb_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","هنگام تولدِ اسحاق، ابراهیم صد ساله بود. ");
INSERT INTO pesopcb_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","سارا گفت: «خدا برایم خنده و شادی آورده است. هر کس خبر تولد پسرم را بشنود با من خواهد خندید. ");
INSERT INTO pesopcb_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","چه کسی باور می‌کرد که روزی من بچهٔ ابراهیم را شیر بدهم؟ ولی اکنون برای ابراهیم در سن پیری او پسری زاییده‌ام!» ");
INSERT INTO pesopcb_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","اسحاق بزرگ شده، از شیر گرفته شد و ابراهیم به این مناسبت جشن بزرگی بر پا کرد. ");
INSERT INTO pesopcb_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","یک روز سارا متوجه شد که اسماعیل، پسر هاجر مصری، اسحاق را اذیت می‌کند. ");
INSERT INTO pesopcb_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","پس به ابراهیم گفت: «این کنیز و پسرش را از خانه بیرون کن، زیرا اسماعیل با پسر من اسحاق وارث تو نخواهد بود.» ");
INSERT INTO pesopcb_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","این موضوع ابراهیم را بسیار رنجاند، چون اسماعیل نیز پسر او بود. ");
INSERT INTO pesopcb_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","اما خدا به ابراهیم فرمود: «دربارهٔ پسر و کنیزت آزرده‌خاطر نشو. آنچه سارا گفته است انجام بده، زیرا توسط اسحاق است که تو صاحب نسلی می‌شوی که وعده‌اش را به تو داده‌ام. ");
INSERT INTO pesopcb_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","از پسر آن کنیز هم قومی به وجود خواهم آورد، چون او نیز پسر توست.» ");
INSERT INTO pesopcb_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","پس ابراهیم صبح زود برخاست و نان و مشکی پُر از آب برداشت و بر دوش هاجر گذاشت، و او را با پسر روانه ساخت. هاجر به بیابان بئرشِبَع رفت و در آنجا سرگردان شد. ");
INSERT INTO pesopcb_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","وقتی آب مشک تمام شد، هاجر پسرش را زیر بوته‌ها گذاشت ");
INSERT INTO pesopcb_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","و خود حدود صد متر دورتر از او نشست و با خود گفت: «نمی‌خواهم ناظر مرگ فرزندم باشم.» و زارزار بگریست. ");
INSERT INTO pesopcb_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","آنگاه خدا به ناله‌های پسر توجه نمود و فرشتهٔ خدا از آسمان هاجر را ندا داده، گفت: «ای هاجر، چه شده است؟ نترس! زیرا خدا ناله‌های پسرت را شنیده است. ");
INSERT INTO pesopcb_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","برو و او را بردار و در آغوش بگیر. من قوم بزرگی از او به وجود خواهم آورد.» ");
INSERT INTO pesopcb_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","سپس خدا چشمان هاجر را گشود و او چاه آبی در مقابل خود دید. پس به طرف چاه رفته، مشک را پر از آب کرد و به پسرش نوشانید. ");
INSERT INTO pesopcb_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","و خدا با اسماعیل بود و او در صحرا بزرگ شده، در تیراندازی ماهر گشت. ");
INSERT INTO pesopcb_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","او در صحرای فاران زندگی می‌کرد و مادرش دختری از مصر برای او گرفت. ");
INSERT INTO pesopcb_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","در آن زمان ابیملکِ پادشاه، با فرماندهٔ سپاهش فیکول نزد ابراهیم آمده، گفت: «خدا در آنچه می‌کنی با توست! ");
INSERT INTO pesopcb_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","اکنون به نام خدا سوگند یاد کن که به من و فرزندان و نواده‌های من خیانت نخواهی کرد و همان‌طوری که من با تو به خوبی رفتار کرده‌ام، تو نیز با من و مملکتم که در آن ساکنی، به خوبی رفتار خواهی نمود.» ");
INSERT INTO pesopcb_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","ابراهیم پاسخ داد: «سوگند می‌خورم چنانکه گفتید رفتار کنم.» ");
INSERT INTO pesopcb_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","سپس ابراهیم دربارهٔ چاهِ آبی که خدمتگزاران ابیملک به زور از او گرفته بودند، نزد وی شکایت کرد. ");
INSERT INTO pesopcb_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","ابیملکِ پادشاه گفت: «این اولین باری است که راجع به این موضوع می‌شنوم و نمی‌دانم کدام یک از خدمتگزارانم در این کار مقصر است. چرا پیش از این به من خبر ندادی؟» ");
INSERT INTO pesopcb_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","آنگاه ابراهیم، گوسفندان و گاوانی به ابیملک داد و با یکدیگر عهد بستند. ");
INSERT INTO pesopcb_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","سپس ابراهیم هفت بره از گله جدا ساخت. ");
INSERT INTO pesopcb_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","پادشاه پرسید: «چرا این کار را می‌کنی؟» ");
INSERT INTO pesopcb_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","ابراهیم پاسخ داد: «اینها هدایایی هستند که من به تو می‌دهم تا همه بدانند که این چاه از آنِ من است.» ");
INSERT INTO pesopcb_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","از آن پس این چاه، بئرشبع (یعنی «چاه سوگند») نامیده شد، زیرا آنها در آنجا با هم عهد بسته بودند. ");
INSERT INTO pesopcb_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","آنگاه ابیملک و فیکول فرماندهٔ سپاهش به سرزمین خود فلسطین بازگشتند. ");
INSERT INTO pesopcb_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","ابراهیم در کنار آن چاه درخت گزی کاشت و خداوند، خدای ابدی را عبادت نمود. ");
INSERT INTO pesopcb_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","ابراهیم مدت زیادی در سرزمین فلسطین در غربت زندگی کرد. ");
INSERT INTO pesopcb_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","مدتی گذشت و خدا خواست ایمان ابراهیم را امتحان کند. پس او را ندا داد: «ای ابراهیم!» ابراهیم جواب داد: «بله، خداوندا!» ");
INSERT INTO pesopcb_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","خدا فرمود: «یگانه پسرت یعنی اسحاق را که بسیار دوستش می‌داری برداشته، به سرزمین موریا برو و در آنجا وی را بر یکی از کوههایی که به تو نشان خواهم داد به عنوان هدیهٔ سوختنی، قربانی کن!» ");
INSERT INTO pesopcb_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","ابراهیم صبح زود برخاست و مقداری هیزم جهت آتش قربانی تهیه نمود، الاغ خود را پالان کرد و پسرش اسحاق و دو نفر از نوکرانش را برداشته، به سوی مکانی که خدا به او فرموده بود، روانه شد. ");
INSERT INTO pesopcb_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","پس از سه روز راه، ابراهیم آن مکان را از دور دید. ");
INSERT INTO pesopcb_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","پس به نوکران خود گفت: «شما در اینجا پیش الاغ بمانید تا من و پسرم به آن مکان رفته، عبادت کنیم و نزد شما برگردیم.» ");
INSERT INTO pesopcb_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","ابراهیم هیزمی را که برای قربانی سوختنی آورده بود، بر دوش اسحاق گذاشت و خودش کارد و وسیله‌ای را که با آن آتش روشن می‌کردند برداشت و با هم روانه شدند. ");
INSERT INTO pesopcb_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","اسحاق پرسید: «پدر، ما هیزم و آتش با خود داریم، اما برهٔ قربانی کجاست؟» ");
INSERT INTO pesopcb_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","ابراهیم در جواب گفت: «پسرم، خدا برهٔ قربانی را مهیا خواهد ساخت.» و هر دو به راه خود ادامه دادند. ");
INSERT INTO pesopcb_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","وقتی به مکانی که خدا به ابراهیم فرموده بود رسیدند، ابراهیم مذبحی بنا کرده، هیزم را بر آن نهاد و اسحاق را بسته او را بر هیزم گذاشت. ");
INSERT INTO pesopcb_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","سپس او کارد را بالا برد تا اسحاق را قربانی کند. ");
INSERT INTO pesopcb_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","در همان لحظه، فرشتهٔ خداوند از آسمان ابراهیم را صدا زده گفت: «ابراهیم! ابراهیم!» او جواب داد: «بله خداوندا!» ");
INSERT INTO pesopcb_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","فرشته گفت: «کارد را بر زمین بگذار و به پسرت آسیبی نرسان. اکنون دانستم که تو بسیار خداترس هستی، زیرا یگانه پسرت را از او دریغ نداشتی.» ");
INSERT INTO pesopcb_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","آنگاه ابراهیم قوچی را دید که شاخهایش در بوته‌ای گیر کرده است. پس رفته قوچ را گرفت و آن را در عوض پسر خود به عنوان هدیهٔ سوختنی قربانی کرد. ");
INSERT INTO pesopcb_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","ابراهیم آن مکان را «یهوه یری» (یعنی «خداوند تدارک می‌بیند») نامید که تا به امروز به همین نام معروف است. ");
INSERT INTO pesopcb_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","بار دیگر فرشتهٔ خداوند از آسمان ابراهیم را ندا داده، به او گفت: ");
INSERT INTO pesopcb_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","«خداوند می‌فرماید به ذات خود قسم خورده‌ام که چون مرا اطاعت کردی و حتی یگانه پسرت را از من دریغ نداشتی، ");
INSERT INTO pesopcb_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","به‌یقین تو را برکت خواهم داد و نسل تو را مانند ستارگان آسمان و شنهای دریا کثیر خواهم ساخت. آنها بر دشمنان خود پیروز شده، ");
INSERT INTO pesopcb_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","موجب برکت همهٔ قومهای جهان خواهند گشت، زیرا تو مرا اطاعت کرده‌ای.» ");
INSERT INTO pesopcb_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","پس ایشان نزد نوکران باز آمده، به سوی منزل خود در بئرشِبَع حرکت کردند. ");
INSERT INTO pesopcb_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","بعد از این واقعه، به ابراهیم خبر رسید که مِلْکَه همسر ناحور برادر ابراهیم، هشت پسر به دنیا آورده است. ");
INSERT INTO pesopcb_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","اسامی آنها از این قرار بود: پسر ارشدش عوص، و بعد بوز، قموئیل (جد ارامیان)، ");
INSERT INTO pesopcb_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","کاسد، حزو، فلداش، یدلاف و بتوئیل. ");
INSERT INTO pesopcb_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","(بتوئیل پدر ربکا بود). علاوه بر این هشت پسر که از مِلکه به دنیا آمده بودند، ");
INSERT INTO pesopcb_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","ناحور همچنین از کنیز خود به اسم رئومه، چهار فرزند دیگر داشت به نامهای طابح، جاحم، تاحش و معکه. ");
INSERT INTO pesopcb_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","وقتی سارا صد و بیست و هفت سال داشت، ");
INSERT INTO pesopcb_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","در حبرون واقع در سرزمین کنعان درگذشت و ابراهیم در آنجا برای او سوگواری کرد. ");
INSERT INTO pesopcb_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","سپس ابراهیم از کنار بدن بی‌جان سارا برخاسته، به بزرگان حیتّی گفت: ");
INSERT INTO pesopcb_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","«من در این سرزمین غریب و مهمانم و جایی ندارم که همسر خود را دفن کنم. خواهش می‌کنم قطعه زمینی به من بفروشید تا زن خود را در آن به خاک بسپارم.» ");
INSERT INTO pesopcb_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","حیتی‌ها به ابراهیم جواب دادند: ");
INSERT INTO pesopcb_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","«شما سَروَر ما هستید و می‌توانید همسر خود را در بهترین مقبرهٔ ما دفن کنید. هیچ‌یک از ما مقبرهٔ خود را از شما دریغ نخواهیم داشت.» ");
INSERT INTO pesopcb_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","ابراهیم در برابر آنها تعظیم نموده، ");
INSERT INTO pesopcb_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","گفت: «حال که اجازه می‌دهید همسر خود را در اینجا دفن کنم، تمنا دارم به عفرون پسر صوحار بگویید ");
INSERT INTO pesopcb_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","غار مکفیله را که در انتهای مزرعهٔ اوست، به من بفروشد. البته قیمت آن را تمام و کمال در حضور شاهدان خواهم پرداخت تا آن غار مقبرهٔ خانوادگی من بشود.» ");
INSERT INTO pesopcb_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","عفرون در حضور بزرگان حیتّی که در دروازهٔ شهر جمع شده بودند گفت: ");
INSERT INTO pesopcb_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","«ای سَروَرم، من آن غار و مزرعه را در حضور این مردم به شما می‌بخشم. بروید و همسر خود را در آن دفن کنید.» ");
INSERT INTO pesopcb_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","ابراهیم بار دیگر در برابر حیتّی‌ها سر تعظیم فرود آورد، ");
INSERT INTO pesopcb_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","و در حضور همه به عفرون گفت: «اجازه بده آن را از تو خریداری نمایم. من تمام بهای مزرعه را می‌پردازم و بعد همسر خود را در آن دفن می‌کنم.» ");
INSERT INTO pesopcb_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","عفرون در پاسخ گفت: ");
INSERT INTO pesopcb_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","«ای سرورم، قیمت آن چهارصد مثقال نقره است؛ ولی این مبلغ در مقابل دوستی ما چه ارزشی دارد؟ بروید و همسر خود را در آن دفن کنید.» ");
INSERT INTO pesopcb_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","پس ابراهیم چهارصد مثقال نقره، یعنی بهایی را که عفرون در حضور همه پیشنهاد کرده بود، تمام و کمال به وی پرداخت. ");
INSERT INTO pesopcb_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","این است مشخصات زمینی که ابراهیم خرید: مزرعه عفرون واقع در مکفیله نزدیک مِلک ممری با غاری که در انتهای مزرعه قرار داشت و تمامی درختان آن. ");
INSERT INTO pesopcb_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","این مزرعه و غاری که در آن بود در حضور بزرگان حیتّی که در دروازهٔ شهر نشسته بودند، به ملکیت ابراهیم درآمد. ");
INSERT INTO pesopcb_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","پس ابراهیم همسرش سارا را در غار زمین مکفیله در نزدیکی ممری، که همان حبرون است، در سرزمین کنعان دفن کرد. ");
INSERT INTO pesopcb_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","به این ترتیب، مالکیت آن زمین و غار به ابراهیم واگذار شد تا به عنوان مقبرهٔ خانوادگی از آن استفاده کند. ");
INSERT INTO pesopcb_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","ابراهیم اکنون مردی بود بسیار سالخورده و خداوند او را از هر لحاظ برکت داده بود. ");
INSERT INTO pesopcb_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","روزی ابراهیم به خادم خود که رئیس غلامانش بود، گفت: «دستت را زیر ران من بگذار ");
INSERT INTO pesopcb_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","و به خداوند، خدای آسمان و زمین قسم بخور که نگذاری پسرم با یکی از دختران کنعانی اینجا ازدواج کند. ");
INSERT INTO pesopcb_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","پس به زادگاهم نزد خویشاوندانم برو و در آنجا برای اسحاق همسری انتخاب کن.» ");
INSERT INTO pesopcb_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","خادم پرسید: «اگر هیچ دختری حاضر نشد زادگاه خود را ترک کند و به این دیار بیاید، آن وقت چه؟ در آن صورت آیا اسحاق را به آنجا ببرم؟» ");
INSERT INTO pesopcb_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","ابراهیم در جواب گفت: «نه، چنین نکن! ");
INSERT INTO pesopcb_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","خداوند، خدای آسمان، به من فرمود که ولایت و خانۀ پدری‌ام را ترک کنم و وعده داد که این سرزمین را به من و به فرزندانم به مِلکیت خواهد بخشید. پس خودِ خداوند فرشتهٔ خود را پیش روی تو خواهد فرستاد و ترتیبی خواهد داد که در آنجا همسری برای پسرم اسحاق بیابی و همراه خود بیاوری. ");
INSERT INTO pesopcb_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","اما اگر آن دختر نخواست با تو بیاید، تو از این قسم مبرا هستی. ولی به هیچ وجه نباید پسرم را به آنجا ببری.» ");
INSERT INTO pesopcb_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","پس خادم دستش را زیر ران سَرور خود ابراهیم گذاشت و قسم خورد که مطابق دستور او عمل کند. ");
INSERT INTO pesopcb_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","او با ده شتر از شتران ابراهیم و مقداری هدایا از اموالِ او به سوی شمالِ بین‌النهرین، به شهری که ناحور در آن زندگی می‌کرد، رهسپار شد. ");
INSERT INTO pesopcb_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","وقتی به مقصد رسید، شترها را در خارج شهر، در کنار چاه آبی خوابانید. نزدیک غروب که زنان برای کشیدن آب به سر چاه می‌آمدند، ");
INSERT INTO pesopcb_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","او چنین دعا کرد: «ای خداوند، خدای سَروَر من ابراهیم، التماس می‌کنم نسبت به سرورم لطف فرموده، مرا یاری دهی تا خواستهٔ او را برآورم. ");
INSERT INTO pesopcb_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","اینک من در کنار این چاه ایستاده‌ام، و دختران شهر برای بردن آب می‌آیند. ");
INSERT INTO pesopcb_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","من به یکی از آنان خواهم گفت: ”سبوی خود را پایین بیاور تا آب بنوشم.“ اگر آن دختر بگوید: ”بنوش و من شترانت را نیز سیراب خواهم کرد،“ آنگاه خواهم دانست که او همان دختری است که تو برای اسحاق در نظر گرفته‌ای و سرورم را مورد لطف خویش قرار داده‌ای.» ");
INSERT INTO pesopcb_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","در حالی که خادم هنوز مشغول راز و نیاز با خداوند بود، دختر زیبایی به نام رِبِکا که سبویی بر دوش داشت، سر رسید. او دختر بتوئیل، پسر مِلکه بود، و ملکه همسر ناحور، برادر ابراهیم بود. ");
INSERT INTO pesopcb_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","ربکا دختری بسیار زیبا و به سن ازدواج رسیده بود، و مردی با او همبستر نشده بود. او به چشمه پائین رفت و کوزۀ خود را پر کرده، بالا آمد. ");
INSERT INTO pesopcb_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","خادم نزد او شتافت و از وی آب خواست. ");
INSERT INTO pesopcb_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","دختر گفت: «سَروَرم، بنوش!» و فوری سبوی خود را پایین آورد و او نوشید. ");
INSERT INTO pesopcb_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","سپس افزود: «شترانت را نیز سیراب خواهم کرد.» ");
INSERT INTO pesopcb_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","آنگاه آب را در آبشخور ریخت و دوباره به طرف چاه دوید و برای تمام شترها آب کشید. ");
INSERT INTO pesopcb_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","خادم چشم بر او دوخته، چیزی نمی‌گفت تا ببیند آیا خداوند او را در این سفر کامیاب خواهد ساخت یا نه. ");
INSERT INTO pesopcb_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","پس از آنکه ربکا شترها را سیراب نمود، خادم یک حلقهٔ طلا به وزن نیم مثقال و یک جفت النگوی طلا به وزن ده مثقال به او داده، گفت: ");
INSERT INTO pesopcb_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","«به من بگو دختر که هستی؟ آیا در منزل پدرت جایی برای ما هست تا شب را به سر ببریم؟» ");
INSERT INTO pesopcb_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","او در جواب گفت: «من دختر بتوئیل و نوهٔ ناحور و مِلکه هستم. ");
INSERT INTO pesopcb_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","بله، ما برای شما و شترهایتان جا و خوراک کافی داریم.» ");
INSERT INTO pesopcb_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","آنگاه آن مرد خداوند را سجده کرده، گفت: ");
INSERT INTO pesopcb_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","«ای خداوند، خدای سَروَرم ابراهیم، از تو سپاسگزارم که نسبت به او امین و مهربان بوده‌ای و مرا در این سفر هدایت نموده، به نزد بستگان سرورم آوردی.» ");
INSERT INTO pesopcb_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","پس آن دختر دوان‌دوان رفته، به اهل خانهٔ خود خبر داد. ");
INSERT INTO pesopcb_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","ربکا برادری به نام لابان داشت. او دوان‌دوان بیرون آمد تا آن مردی را که سر چاه بود ببیند، ");
INSERT INTO pesopcb_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","زیرا حلقه و النگوها را بر دست خواهرش دیده بود و سخنان آن مرد را از خواهرش شنیده بود. پس بی‌درنگ سر چاه رفت و دید آن مرد هنوز پیش شترهایش ایستاده است. ");
INSERT INTO pesopcb_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","لابان به او گفت: «ای که برکت خداوند بر توست، چرا اینجا ایستاده‌ای؟ به منزل ما بیا. ما برای تو و شترهایت جا آماده کرده‌ایم.» ");
INSERT INTO pesopcb_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","پس آن مرد با لابان به منزل رفت و لابان بار شترها را باز کرده، به آنها کاه و علف داد. سپس برای خادم ابراهیم و افرادش آب آورد تا پاهای خود را بشویند. ");
INSERT INTO pesopcb_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","وقتی غذا را آوردند، خادم ابراهیم گفت: «تا مقصود خود را از آمدن به اینجا نگویم لب به غذا نخواهم زد.» لابان گفت: «بسیار خوب، بگو.» ");
INSERT INTO pesopcb_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","او گفت: «من خادم ابراهیم هستم. ");
INSERT INTO pesopcb_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","خداوند او را بسیار برکت داده است و او مردی بزرگ و معروف می‌باشد. خداوند به او گله‌ها و رمه‌ها، طلا و نقرهٔ بسیار، غلامان و کنیزان، و شترها و الاغهای فراوانی داده است. ");
INSERT INTO pesopcb_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","«سارا همسر سرورم در سن پیری پسری زایید، و سرورم تمام دارایی خود را به پسرش بخشیده است. ");
INSERT INTO pesopcb_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","سرورم مرا قسم داده که از دختران کنعانی برای پسرش زن نگیرم، ");
INSERT INTO pesopcb_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","بلکه به اینجا نزد قبیله و خاندان پدری‌اش آمده، زنی برای او انتخاب کنم. ");
INSERT INTO pesopcb_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","«من به سرورم گفتم: ”شاید نتوانم دختری پیدا کنم که حاضر باشد به اینجا بیاید؟“ ");
INSERT INTO pesopcb_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","او به من گفت: ”خداوندی که از او پیروی می‌کنم، فرشتهٔ خود را همراه تو خواهد فرستاد تا در این سفر کامیاب شوی و دختری از قبیله و خاندان پدری‌ام پیدا کنی. ");
INSERT INTO pesopcb_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","تو وظیفه داری به آنجا رفته، پرس و جو کنی. اگر آنها از فرستادن دختر خودداری کردند، آن وقت تو از سوگندی که خورده‌ای مبرا خواهی بود.“ ");
INSERT INTO pesopcb_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","«امروز که به سر چاه رسیدم چنین دعا کردم: ”ای خداوند، خدای سَروَرم ابراهیم، التماس می‌کنم که مرا در این سفر کامیاب سازی. ");
INSERT INTO pesopcb_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","اینک در کنار این چاه می‌ایستم و به یکی از دخترانی که از شهر برای بردن آب می‌آیند خواهم گفت: «از سبوی خود قدری آب به من بده تا بنوشم.» ");
INSERT INTO pesopcb_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","اگر آن دختر جواب بدهد: «بنوش و من شترانت را نیز سیراب خواهم کرد»، آنگاه خواهم دانست که او همان دختری است که تو برای اسحاق پسر سرورم در نظر گرفته‌ای.“ ");
INSERT INTO pesopcb_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","«هنوز دعایم تمام نشده بود که دیدم ربکا با سبویی بر دوش سر رسید و به سر چاه رفته، آب کشید و سبو را از آب پُر کرد. به او گفتم: ”کمی آب به من بده تا بنوشم.“ ");
INSERT INTO pesopcb_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","او فوراً سبو را پایین آورد تا بنوشم و گفت: ”شترانت را نیز سیراب خواهم کرد“ و چنین نیز کرد. ");
INSERT INTO pesopcb_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","«آنگاه از او پرسیدم: ”تو دختر که هستی؟“ «او به من گفت: ”دختر بتوئیل و نوه ناحور و مِلکه هستم.“ «من هم حلقه را در بینی او و النگوها را به دستش کردم. ");
INSERT INTO pesopcb_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","سپس سجده کرده خداوند، خدای سَروَرم ابراهیم را پرستش نمودم، چون مرا به راه راست هدایت فرمود تا دختری از خانوادۀ برادر سرور خود برای پسرش پیدا کنم. ");
INSERT INTO pesopcb_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","اکنون به من جواب بدهید؛ آیا چنین لطفی در حق سرور من خواهید کرد و آنچه درست است به جا خواهید آورد؟ به من جواب بدهید تا تکلیف خود را بدانم.» ");
INSERT INTO pesopcb_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","لابان و بتوئیل به او گفتند: «خداوند تو را به اینجا هدایت کرده است، پس ما چه می‌توانیم بگوییم؟ ");
INSERT INTO pesopcb_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","اینک ربکا را برداشته برو تا چنانکه خداوند اراده فرموده است، همسر پسر سرورت بشود.» ");
INSERT INTO pesopcb_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","به محض شنیدن این سخن، خادمِ ابراهیم در حضور خداوند به خاک افتاد و او را سجده نمود. ");
INSERT INTO pesopcb_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","سپس لباس و طلا و نقره و جواهرات به ربکا داد و هدایای گرانبهایی نیز به مادر و برادرانش پیشکش کرد. ");
INSERT INTO pesopcb_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","پس از آن او و همراهانش شام خوردند و شب را در منزل بتوئیل به سر بردند. خادم ابراهیم صبح زود برخاسته، به آنها گفت: «حال اجازه دهید برویم.» ");
INSERT INTO pesopcb_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","ولی مادر و برادر ربکا گفتند: «ربکا باید اقلاً ده روز دیگر پیش ما بماند و بعد از آن برود.» ");
INSERT INTO pesopcb_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","اما او گفت: «خواهش می‌کنم مرا معطل نکنید. خداوند مرا در این سفر کامیاب گردانیده است. بگذارید بروم و این خبر خوش را به سرورم برسانم.» ");
INSERT INTO pesopcb_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","ایشان گفتند: «بسیار خوب. ما از دختر می‌پرسیم تا ببینیم نظر خودش چیست.» ");
INSERT INTO pesopcb_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","پس ربکا را صدا کرده، از او پرسیدند: «آیا مایلی همراه این مرد بروی؟» وی جواب داد: «بله، می‌روم.» ");
INSERT INTO pesopcb_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","آنگاه با او خداحافظی کرده، دایه‌اش را همراه وی فرستادند. ");
INSERT INTO pesopcb_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","هنگام حرکت، ربکا را برکت داده، چنین گفتند: «خواهر، امیدواریم مادرِ فرزندان بسیاری شوی! امیدواریم نسل تو بر تمام دشمنانت چیره شوند.» ");
INSERT INTO pesopcb_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","پس ربکا و کنیزانش بر شتران سوار شده، همراه خادمِ ابراهیم رفتند. ");
INSERT INTO pesopcb_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","در این هنگام اسحاق که در سرزمین نِگِب سکونت داشت، به بئرلحی رُئی بازگشته بود. ");
INSERT INTO pesopcb_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","یک روز عصر هنگامی که در صحرا قدم می‌زد و غرق اندیشه بود، سر خود را بلند کرده، دید که اینک شتران می‌آیند. ");
INSERT INTO pesopcb_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","ربکا با دیدن اسحاق به شتاب از شتر پیاده شد ");
INSERT INTO pesopcb_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","و از خادم پرسید: «آن مردی که از صحرا به استقبال ما می‌آید کیست؟» وی پاسخ داد: «اسحاق، پسر سَروَر من است.» با شنیدن این سخن، ربکا با روبندِ خود صورتش را پوشانید. ");
INSERT INTO pesopcb_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","آنگاه خادم تمام داستان سفر خود را برای اسحاق شرح داد. ");
INSERT INTO pesopcb_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","اسحاق ربکا را به داخل خیمهٔ مادرش سارا آورد و او را به زنی گرفته به او دل بست و از غم مرگ مادرش تسلی یافت. ");
INSERT INTO pesopcb_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","ابراهیم بار دیگر زنی گرفت که نامش قِطوره بود. ");
INSERT INTO pesopcb_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","قِطوره برای ابراهیم چندین فرزند به دنیا آورد. اسامی آنها عبارت بود از: زمران، یُقشان، مدان، مدیان، یشباق و شوعه. ");
INSERT INTO pesopcb_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","شبا و ددان پسران یقشان بودند. ددان پدر اشوریم، لطوشیم و لئومیم بود. ");
INSERT INTO pesopcb_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","عیفه، عیفر، حنوک، ابیداع و الداعه، پسران مدیان بودند. ");
INSERT INTO pesopcb_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","ابراهیم تمام دارایی خود را به اسحاق بخشید، ");
INSERT INTO pesopcb_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","اما به سایر پسرانش که از کنیزانش به دنیا آمده بودند، هدایایی داده، ایشان را در زمان حیات خویش از نزد پسر خود اسحاق، به دیار مشرق فرستاد. ");
INSERT INTO pesopcb_vpl VALUES ("GN25_7‏","002_25_7‏","GEN","25","7‏","8","ابراهیم در سن صد و هفتاد و پنج سالگی، در کمال پیری، کامیاب از دنیا رفت و به اجداد خود پیوست. ");
INSERT INTO pesopcb_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","پسرانش اسحاق و اسماعیل او را در غار مکفیله، نزدیک مَمری، واقع در زمین عفرون پسر صوحارِ حیتّی، دفن کردند. ");
INSERT INTO pesopcb_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","این همان زمینی بود که ابراهیم از حیتی‌ها خریده و همسرش سارا را در آنجا دفن کرده بود. ");
INSERT INTO pesopcb_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","بعد از مرگ ابراهیم، خدا اسحاق را برکت داد. (در این زمان اسحاق نزدیک بئرلحی رُئی، واقع در نِگِب ساکن بود.) ");
INSERT INTO pesopcb_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","این است تاریخچۀ نسل اسماعیل، پسر ابراهیم، که از هاجر مصری، کنیز سارا به دنیا آمد. ");
INSERT INTO pesopcb_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","این است نامهای پسران اسماعیل به ترتیب تولدشان: نبایوت پسر ارشد اسماعیل، قیدار، ادبئیل، مِبسام، ");
INSERT INTO pesopcb_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","مشماع، دومه، مسا، ");
INSERT INTO pesopcb_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","حداد، تیما، یطور، نافیش و قدمه. ");
INSERT INTO pesopcb_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","هر کدام از این دوازده پسر اسماعیل، قبیله‌ای به نام خودش به وجود آوردند. محل سکونت و اردوگاه این قبایل نیز به همان اسامی خوانده می‌شد. ");
INSERT INTO pesopcb_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","اسماعیل در سن صد و سی و هفت سالگی مُرد و به اجداد خود پیوست. ");
INSERT INTO pesopcb_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","فرزندان اسماعیل در منطقه‌ای بین حویله و شور که در مرز شرقی مصر و سر راه آشور واقع بود، ساکن شدند. آنها در دشمنی با همۀ برادران خود زندگی می‌کردند. ");
INSERT INTO pesopcb_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","این است تاریخچۀ نسل اسحاق، پسر ابراهیم. ابراهیم اسحاق را آورد، ");
INSERT INTO pesopcb_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","و اسحاق چهل ساله بود که ربکا را به زنی گرفت. ربکا دختر بتوئیل و خواهر لابان، اهل فَدّان‌اَرام بود. ");
INSERT INTO pesopcb_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","ربکا نازا بود و اسحاق برای او نزد خداوند دعا می‌کرد. سرانجام خداوند دعای او را اجابت فرمود و ربکا حامله شد. ");
INSERT INTO pesopcb_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","به نظر می‌رسید که دو بچه در شکم او با هم کشمکش می‌کنند. پس ربکا گفت: «چرا چنین اتفاقی برای من افتاده است؟» و در این خصوص از خداوند سؤال نمود. ");
INSERT INTO pesopcb_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","خداوند به او فرمود: «از دو پسری که در رحم داری، دو قوم به وجود خواهد آمد. یکی از دیگری قویتر خواهد بود، و بزرگتر کوچکتر را بندگی خواهد کرد!» ");
INSERT INTO pesopcb_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","وقتی زمان وضع حمل ربکا رسید، او دوقلو زایید. ");
INSERT INTO pesopcb_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","پسر اولی که به دنیا آمد، سرخ رو بود و بدنش چنان با مو پوشیده شده بود که گویی پوستین بر تن دارد. بنابراین او را عیسو نام نهادند. ");
INSERT INTO pesopcb_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","پسر دومی که به دنیا آمد پاشنهٔ پای عیسو را گرفته بود! پس او را یعقوب نامیدند. اسحاق شصت ساله بود که این دوقلوها به دنیا آمدند. ");
INSERT INTO pesopcb_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","آن دو پسر بزرگ شدند. عیسو شکارچی‌ای ماهر و مرد بیابان بود، ولی یعقوب مردی آرام و چادرنشین بود. ");
INSERT INTO pesopcb_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","اسحاق، عیسو را دوست می‌داشت، چون از گوشت حیواناتی که او شکار می‌کرد، می‌خورد؛ اما ربکا یعقوب را دوست می‌داشت. ");
INSERT INTO pesopcb_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","روزی یعقوب مشغول پختن آش بود که عیسو خسته و گرسنه از شکار برگشت. ");
INSERT INTO pesopcb_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","عیسو گفت: «برادر، از شدت گرسنگی رمقی در من نمانده است، کمی از آن آش سرخ به من بده تا بخورم.» (به همین دلیل است که عیسو را ادوم نیز می‌نامند.) ");
INSERT INTO pesopcb_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","یعقوب جواب داد: «به شرط آنکه در عوض آن، حق نخست‌زادگی خود را به من بفروشی!» ");
INSERT INTO pesopcb_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","عیسو گفت: «من از شدت گرسنگی به حال مرگ افتاده‌ام، حق نخست‌زادگی چه سودی برایم دارد؟» ");
INSERT INTO pesopcb_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","اما یعقوب گفت: «قسم بخور که بعد از این، حق نخست‌زادگی تو از آن من خواهد بود.» عیسو قسم خورد و به این ترتیب حق نخست‌زادگی خود را به برادر کوچکترش یعقوب فروخت. ");
INSERT INTO pesopcb_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","سپس یعقوب آش عدس را با نان به عیسو داد. او خورد و برخاست و رفت. اینچنین عیسو حق نخست‌زادگی خود را بی‌ارزش شمرد. ");
INSERT INTO pesopcb_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","روزی قحطی شدیدی همانند قحطی زمان ابراهیم سراسر سرزمین کنعان را فرا گرفت. به همین دلیل اسحاق به شهر جرار نزد ابیملک، پادشاه فلسطین رفت. ");
INSERT INTO pesopcb_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","خداوند در آنجا به اسحاق ظاهر شده، گفت: «به مصر نرو. آنچه می‌گویم انجام بده. ");
INSERT INTO pesopcb_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","در این سرزمین همچون یک غریبه بمان، و من با تو خواهم بود و تو را برکت خواهم داد. من تمامی این سرزمینها را به تو و نسل تو خواهم بخشید، و بدین ترتیب به سوگندی که برای پدرت ابراهیم یاد کردم وفا خواهم کرد. ");
INSERT INTO pesopcb_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","نسل تو را چون ستارگان آسمان بی‌شمار خواهم گردانید و تمامی این سرزمین را به آنها خواهم داد و همۀ قومهای جهان از نسل تو برکت خواهند یافت. ");
INSERT INTO pesopcb_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","این کار را به خاطر ابراهیم خواهم کرد، چون او احکام و اوامر مرا اطاعت نمود.» ");
INSERT INTO pesopcb_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","پس اسحاق در جرار ماندگار شد. ");
INSERT INTO pesopcb_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","وقتی که مردم آنجا دربارهٔ ربکا از او سؤال کردند، گفت: «او خواهر من است!» چون ترسید اگر بگوید همسر من است، به خاطر تصاحب زنش او را بکشند، زیرا ربکا بسیار زیبا بود. ");
INSERT INTO pesopcb_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","مدتی بعد، یک روز ابیملک، پادشاه فلسطین از پنجره دید که اسحاق با همسرش رِبِکا شوخی می‌کند. ");
INSERT INTO pesopcb_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","پس ابیملک، اسحاق را نزد خود خوانده، به او گفت: «چرا گفتی ربکا خواهرت است، در حالی که زن تو می‌باشد؟» اسحاق در جواب گفت: «چون می‌ترسیدم برای تصاحب او مرا بکشند.» ");
INSERT INTO pesopcb_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","اَبیمِلِک گفت: «این چه کاری بود که با ما کردی؟ آیا فکر نکردی که ممکن است یکی از مردم ما با وی همبستر شود؟ در آن صورت ما را به گناه بزرگی دچار می‌ساختی.» ");
INSERT INTO pesopcb_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","سپس ابیملک به همه اعلام نمود: «هر کس به این مرد و همسر وی زیان رساند، کشته خواهد شد.» ");
INSERT INTO pesopcb_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","اسحاق در جرار به زراعت مشغول شد و در آن سال صد برابر بذری که کاشته بود درو کرد، زیرا خداوند او را برکت داده بود. ");
INSERT INTO pesopcb_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","هر روز بر دارایی او افزوده می‌شد و طولی نکشید که او مرد بسیار ثروتمندی شد. ");
INSERT INTO pesopcb_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","وی گله‌ها و رمه‌ها و غلامان بسیار داشت به طوری که فلسطینی‌ها بر او حسد می‌بردند. ");
INSERT INTO pesopcb_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","پس آنها چاههای آبی را که غلامان پدرش ابراهیم در زمان حیات ابراهیم کنده بودند، با خاک پُر کردند. ");
INSERT INTO pesopcb_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","ابیملکِ پادشاه نیز از او خواست تا سرزمینش را ترک کند و به او گفت: «به جایی دیگر برو، زیرا تو از ما بسیار ثروتمندتر و قدرتمندتر شده‌ای.» ");
INSERT INTO pesopcb_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","پس اسحاق آنجا را ترک نموده، در درهٔ جرار ساکن شد. ");
INSERT INTO pesopcb_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","او چاههای آبی را که در زمان حیات پدرش کَنده بودند و فلسطینی‌ها آنها را پُر کرده بودند، دوباره کَند و همان نامهایی را که قبلاً پدرش بر آنها نهاده بود بر آنها گذاشت. ");
INSERT INTO pesopcb_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","غلامان او نیز چاه تازه‌ای در درهٔ جرار کَنده، در قعر آن به آب روان رسیدند. ");
INSERT INTO pesopcb_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","سپس چوپانان جرار آمدند و با چوپانان اسحاق به نزاع پرداخته، گفتند: «این چاه به ما تعلق دارد.» پس اسحاق آن چاه را عِسِق (یعنی «نزاع») نامید. ");
INSERT INTO pesopcb_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","غلامانِ اسحاق چاه دیگری کَندند و باز بر سر آن مشاجره‌ای درگرفت. اسحاق آن چاه را سِطنه (یعنی «دشمنی») نامید. ");
INSERT INTO pesopcb_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","اسحاق آن چاه را نیز ترک نموده، چاه دیگری کَند، ولی این بار نزاعی درنگرفت. پس اسحاق آن را رحوبوت (یعنی «مکان وسیع») نامید. او گفت: «خداوند مکانی برای ما مهیا نموده است و ما در این سرزمین ترقی خواهیم کرد.» ");
INSERT INTO pesopcb_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","وقتی که اسحاق به بئرشبع رفت ");
INSERT INTO pesopcb_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","در همان شب خداوند بر وی ظاهر شد و فرمود: «من خدای پدرت ابراهیم هستم. ترسان مباش، چون من با تو هستم. من تو را برکت خواهم داد و به خاطر بندهٔ خود ابراهیم نسل تو را زیاد خواهم کرد.» ");
INSERT INTO pesopcb_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","آنگاه اسحاق مذبحی بنا کرده، خداوند را پرستش نمود. او در همان جا ساکن شد و غلامانش چاه دیگری کندند. ");
INSERT INTO pesopcb_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","روزی ابیملکِ پادشاه به اتفاق مشاور خود احوزات و فرماندهٔ سپاهش فیکول از جرار نزد اسحاق آمدند. ");
INSERT INTO pesopcb_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","اسحاق از ایشان پرسید: «چرا به اینجا آمده‌اید؟ شما که مرا با خصومت از نزد خود راندید!» ");
INSERT INTO pesopcb_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","پاسخ دادند: «ما آشکارا می‌بینیم که خداوند با توست؛ پس می‌خواهیم سوگندی در بین ما و تو باشد و با تو پیمانی ببندیم. ");
INSERT INTO pesopcb_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","قول بده ضرری به ما نرسانی همان‌طور که ما هم ضرری به تو نرساندیم. ما غیر از خوبی کاری در حق تو نکردیم و تو را با صلح و صفا روانه نمودیم. اکنون ببین خداوند چقدر تو را برکت داده است.» ");
INSERT INTO pesopcb_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","پس اسحاق ضیافتی برای آنها بر پا نمود و آنها خوردند و آشامیدند. ");
INSERT INTO pesopcb_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","صبح روز بعد برخاستند و هر یک از آنها قسم خوردند که به یکدیگر ضرری نرسانند. سپس اسحاق ایشان را به سلامتی به سرزمینشان روانه کرد. ");
INSERT INTO pesopcb_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","در همان روز، غلامان اسحاق آمدند و او را از چاهی که می‌کَندند خبر داده، گفتند که در آن آب یافته‌اند. ");
INSERT INTO pesopcb_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","اسحاق آن را شَبَع (یعنی «سوگند») نامید و شهری که در آنجا بنا شد، بئرشبع (یعنی «چاه سوگند») نامیده شد که تا به امروز به همان نام باقی است. ");
INSERT INTO pesopcb_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","عیسو پسر اسحاق در سن چهل سالگی یودیه، دختر بیری حیتّی و بسمه دختر ایلونِ حیتّی را به زنی گرفت. ");
INSERT INTO pesopcb_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","این زنان زندگی را بر اسحاق و ربکا تلخ کردند. ");
INSERT INTO pesopcb_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","اسحاق پیر شده و چشمانش تار گشته بود. روزی او پسر بزرگ خود عیسو را فراخواند و به وی گفت: «پسرم.» عیسو پاسخ داد: «بله، پدرم.» ");
INSERT INTO pesopcb_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","اسحاق گفت: «من دیگر پیر شده‌ام و پایان زندگی‌ام فرا رسیده است. ");
INSERT INTO pesopcb_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","پس تیر و کمان خود را بردار و به صحرا برو و حیوانی برایم شکار کن ");
INSERT INTO pesopcb_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","و از آن، خوراکی مطابق میلم آماده ساز تا بخورم و پیش از مرگم تو را برکت دهم.» ");
INSERT INTO pesopcb_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","اما ربکا سخنان آنها را شنید. وقتی عیسو برای شکار به صحرا رفت، ");
INSERT INTO pesopcb_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","ربکا، یعقوب را نزد خود خوانده، گفت: «شنیدم که پدرت به عیسو چنین می‌گفت: ");
INSERT INTO pesopcb_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","”مقداری گوشت شکار برایم بیاور و از آن غذایی برایم بپز تا بخورم. من هم قبل از مرگم در حضور خداوند تو را برکت خواهم داد.“ ");
INSERT INTO pesopcb_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","حال ای پسرم هر چه به تو می‌گویم انجام بده. ");
INSERT INTO pesopcb_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","نزد گله برو و دو بزغالهٔ خوب جدا کن و نزد من بیاور تا من از گوشت آنها غذایی را که پدرت دوست می‌دارد برایش تهیه کنم. ");
INSERT INTO pesopcb_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","بعد تو آن را نزد پدرت ببر تا بخورد و قبل از مرگش تو را برکت دهد.» ");
INSERT INTO pesopcb_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","یعقوب جواب داد: «عیسو مردی است پُر مو، ولی بدن من مو ندارد. ");
INSERT INTO pesopcb_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","اگر پدرم به من دست بزند و بفهمد که من عیسو نیستم، چه؟ آنگاه او پی خواهد برد که من خواسته‌ام او را فریب بدهم و به جای برکت، مرا لعنت می‌کند!» ");
INSERT INTO pesopcb_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","ربکا گفت: «پسرم، لعنت او بر من باشد. تو فقط آنچه را که من به تو می‌گویم انجام بده. برو و بزغاله‌ها را بیاور.» ");
INSERT INTO pesopcb_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","یعقوب دستور مادرش را اطاعت کرد و بزغاله‌ها را آورد و ربکا خوراکی را که اسحاق دوست می‌داشت، تهیه کرد. ");
INSERT INTO pesopcb_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","آنگاه بهترین لباس عیسو را که در خانه بود به یعقوب داد تا بر تن کند. ");
INSERT INTO pesopcb_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","سپس پوست بزغاله را بر دستها و گردن او بست، ");
INSERT INTO pesopcb_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","و غذای خوش طعمی را که درست کرده بود همراه با نانی که پخته بود به دست یعقوب داد. ");
INSERT INTO pesopcb_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","یعقوب آن غذا را نزد پدرش برد و گفت: «پدرم!» اسحاق جواب داد: «بله، کیستی؟» ");
INSERT INTO pesopcb_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","یعقوب گفت: «من عیسو پسر بزرگ تو هستم. همان‌طور که گفتی به شکار رفتم و غذایی را که دوست می‌داری برایت پختم. بنشین، آن را بخور و مرا برکت بده.» ");
INSERT INTO pesopcb_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","اسحاق پرسید: «پسرم، چطور توانستی به این زودی حیوانی شکار پیدا کنی؟» یعقوب جواب داد: «یهوه، خدای تو آن را سر راه من قرار داد.» ");
INSERT INTO pesopcb_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","اسحاق گفت: «نزدیک بیا تا تو را لمس کنم و مطمئن شوم که واقعاً عیسو هستی.» ");
INSERT INTO pesopcb_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","یعقوب نزد پدرش رفت و پدرش بر دستها و گردن او دست کشید و گفت: «صدا، صدای یعقوب است، ولی دستها، دستهای عیسو!» ");
INSERT INTO pesopcb_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","اسحاق او را نشناخت، چون دستهایش مثل دستهای عیسو پرمو بود. پس یعقوب را برکت داده، ");
INSERT INTO pesopcb_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","پرسید: «آیا تو واقعاً عیسو هستی؟» یعقوب جواب داد: «بله پدر.» ");
INSERT INTO pesopcb_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","اسحاق گفت: «پس غذا را نزد من بیاور تا بخورم و بعد تو را برکت دهم.» یعقوب غذا را پیش او گذاشت و اسحاق آن را خورد و شرابی را هم که یعقوب برایش آورده بود، نوشید. ");
INSERT INTO pesopcb_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","بعد گفت: «پسرم، نزدیک بیا و مرا ببوس.» ");
INSERT INTO pesopcb_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","یعقوب جلو رفت و صورتش را بوسید. وقتی اسحاق لباسهای او را بویید به او برکت داده، گفت: «بوی پسرم چون رایحهٔ خوشبوی صحرایی است که خداوند آن را برکت داده باشد. ");
INSERT INTO pesopcb_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","خدا باران بر زمینت بباراند تا محصولت فراوان باشد و غله و شرابت افزوده گردد. ");
INSERT INTO pesopcb_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","قومهای بسیاری تو را بندگی کنند، بر برادرانت سَروَری کنی و همهٔ خویشانت تو را تعظیم نمایند. لعنت بر کسانی که تو را لعنت کنند و برکت بر آنانی که تو را برکت دهند.» ");
INSERT INTO pesopcb_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","پس از این که اسحاق یعقوب را برکت داد، یعقوب از اتاق خارج شد. به محض خروج او، عیسو از شکار بازگشت. ");
INSERT INTO pesopcb_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","او نیز غذایی را که پدرش دوست می‌داشت، تهیه کرد و برایش آورد و گفت: «اینک غذایی را که دوست داری با گوشتِ شکار برایت پخته و آورده‌ام. برخیز؛ آن را بخور و مرا برکت بده.» ");
INSERT INTO pesopcb_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","اسحاق گفت: «تو کیستی؟» عیسو پاسخ داد: «من پسر ارشد تو عیسو هستم.» ");
INSERT INTO pesopcb_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","اسحاق در حالی که از شدت ناراحتی می‌لرزید گفت: «پس شخصی که قبل از تو برای من غذا آورد و من آن را خورده، او را برکت دادم چه کسی بود؟ هر که بود برکت را از آنِ خود کرد.» ");
INSERT INTO pesopcb_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","عیسو وقتی سخنان پدرش را شنید، فریادی تلخ و بلند برآورد و گفت: «پدر، مرا برکت بده! تمنّا می‌کنم مرا نیز برکت بده!» ");
INSERT INTO pesopcb_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","اسحاق جواب داد: «برادرت به اینجا آمده، مرا فریب داد و برکت تو را گرفت.» ");
INSERT INTO pesopcb_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","عیسو گفت: «بی‌دلیل نیست که او را یعقوب نامیده‌اند، زیرا دو بار مرا فریب داده است. اول حق نخست‌زادگی مرا گرفت و حالا هم برکت مرا. ای پدر، آیا حتی یک برکت هم برای من نگه نداشتی؟» ");
INSERT INTO pesopcb_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","اسحاق به عیسو پاسخ داد: «من او را سَروَر تو قرار دادم و همۀ خویشانش را غلامان وی گردانیدم. محصول غله و شراب را نیز به او دادم. دیگر چیزی باقی نمانده که به تو بدهم.» ");
INSERT INTO pesopcb_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","عیسو گفت: «آیا فقط همین برکت را داشتی؟ ای پدر، مرا هم برکت بده!» و زارزار گریست. ");
INSERT INTO pesopcb_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","اسحاق گفت: «باران بر زمینت نخواهد بارید و محصول زیاد نخواهی داشت. ");
INSERT INTO pesopcb_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","به شمشیر خود خواهی زیست و برادر خود را بندگی خواهی کرد، ولی سرانجام خود را از قید او رها ساخته، آزاد خواهی شد.» ");
INSERT INTO pesopcb_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","عیسو از یعقوب کینه به دل گرفت، زیرا پدرش او را برکت داده بود. او با خود گفت: «پدرم بزودی خواهد مُرد؛ آنگاه یعقوب را خواهم کُشت.» ");
INSERT INTO pesopcb_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","اما ربکا از نقشهٔ پسر بزرگ خود عیسو آگاه شد، پس به دنبال یعقوب پسر کوچک خود فرستاد و به او گفت که عیسو قصد جان او را دارد. ");
INSERT INTO pesopcb_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","ربکا به یعقوب گفت: «کاری که باید بکنی این است: به حران نزد دایی خود لابان فرار کن. ");
INSERT INTO pesopcb_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","مدتی نزد او بمان تا خشم برادرت فرو نشیند ");
INSERT INTO pesopcb_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","و کاری را که نسبت به او کرده‌ای فراموش کند؛ آنگاه برای تو پیغام می‌فرستم تا برگردی. چرا هر دو شما را در یک روز از دست بدهم؟» ");
INSERT INTO pesopcb_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","سپس ربکا نزد اسحاق رفته به او گفت: «از دست زنان حیتّی عیسو جانم به لب رسیده است. حاضرم بمیرم و نبینم که پسرم یعقوب یک دختر حیتّی را به زنی بگیرد.» ");
INSERT INTO pesopcb_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","پس اسحاق یعقوب را فرا‌خوانده، او را برکت داد و به او گفت: «با هیچ‌یک از این دختران کنعانی ازدواج نکن. ");
INSERT INTO pesopcb_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","بلکه بلند شو و به فَدّان‌اَرام، به خانهٔ پدر بزرگت بتوئیل برو و با یکی از دختران دایی خود لابان ازدواج کن. ");
INSERT INTO pesopcb_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","خدای قادر مطلق تو را برکت دهد و به تو فرزندان بسیار ببخشد تا از نسل تو قبایل زیادی به وجود آیند! ");
INSERT INTO pesopcb_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","او برکتی را که به ابراهیم وعده داد، به تو و نسل تو دهد تا صاحب این سرزمینی که خدا آن را به ابراهیم بخشیده و اکنون در آن غریب هستیم بشوی.» ");
INSERT INTO pesopcb_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","پس اسحاق یعقوب را روانه نمود و او به فَدّان‌اَرام، نزد دایی خود لابان، پسر بتوئیل ارامی رفت. ");
INSERT INTO pesopcb_vpl VALUES ("GN28_6‏","002_28_6‏","GEN","28","6‏","8","عیسو فهمید که پدرش اسحاق از دختران کنعانی بیزار است، و یعقوب را از گرفتن زن کنعانی برحذر داشته و پس از برکت دادن او، وی را به فَدّان‌اَرام فرستاده است تا از آنجا زنی برای خود بگیرد و یعقوب هم از پدر و مادر خود اطاعت کرده به فَدّان‌اَرام رفته است. ");
INSERT INTO pesopcb_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","پس عیسو هم نزد خاندان عمویش اسماعیل که پسر ابراهیم بود رفت و علاوه بر زنانی که داشت، محلت، دختر اسماعیل، خواهر نبایوت را نیز به زنی گرفت. ");
INSERT INTO pesopcb_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","پس یعقوب بئرشبع را به قصد حران ترک نمود. ");
INSERT INTO pesopcb_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","همان روز پس از غروب آفتاب، به مکانی رسید و خواست شب را در آنجا به سر برد. پس سنگی برداشت و زیر سر خود نهاده، همان جا خوابید. ");
INSERT INTO pesopcb_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","در خواب نردبانی را دید که پایهٔ آن بر زمین بود و سرش به آسمان می‌رسد و فرشتگان خدا از آن بالا و پایین می‌روند ");
INSERT INTO pesopcb_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","و خداوند بر بالای نردبان ایستاده است. سپس خداوند چنین فرمود: «من خداوند، خدای ابراهیم و خدای پدرت اسحاق هستم. زمینی که روی آن خوابیده‌ای از آن توست. من آن را به تو و نسل تو می‌بخشم. ");
INSERT INTO pesopcb_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","فرزندان تو چون غبار زمین، بی‌شمار خواهند شد! از مشرق تا مغرب، و از شمال تا جنوب را خواهند پوشانید. تمامی مردمِ زمین توسط تو و نسل تو برکت خواهند یافت. ");
INSERT INTO pesopcb_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","هر جا که بروی من با تو خواهم بود و از تو حمایت نموده، دوباره تو را به سلامت به این سرزمین باز خواهم آورد. تا آنچه به تو وعده داده‌ام به جا نیاورم تو را رها نخواهم کرد.» ");
INSERT INTO pesopcb_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","سپس یعقوب از خواب بیدار شد و گفت: «بدون شک خداوند در این مکان حضور دارد و من ندانستم!» ");
INSERT INTO pesopcb_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","پس ترسید و گفت: «این چه جای ترسناکی است! این است خانهٔ خدا و این است دروازهٔ آسمان!» ");
INSERT INTO pesopcb_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","پس یعقوب صبح زود برخاست و سنگی را که زیر سر نهاده بود، چون ستونی بر پا داشت و بر آن روغن زیتون ریخت. ");
INSERT INTO pesopcb_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","او آن مکان را بیت‌ئیل (یعنی «خانهٔ خدا») نامید. (نام این شهر پیش از آن لوز بود.) ");
INSERT INTO pesopcb_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","آنگاه یعقوب نذر کرده گفت: «اگر خدا در این سفر با من باشد و مرا محافظت نماید و خوراک و پوشاک به من بدهد، ");
INSERT INTO pesopcb_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","و مرا به سلامت به خانهٔ پدرم بازگرداند، آنگاه یهوه خدای من خواهد بود؛ ");
INSERT INTO pesopcb_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","و این ستونی که به عنوان یادبود بر پا کردم، مکانی خواهد بود برای عبادت خدا و ده‌یک هر چه را که او به من بدهد به وی باز خواهم داد.» ");
INSERT INTO pesopcb_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","یعقوب به سفر خود ادامه داد تا به سرزمین مردمان مشرق رسید. ");
INSERT INTO pesopcb_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","در صحرا چاهی دید که سه گلۀ گوسفند کنار آن خوابیده بودند، زیرا از آن چاه، به گله‌ها آب می‌دادند. اما سنگی بزرگ بر دهانۀ چاه قرار داشت. ");
INSERT INTO pesopcb_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","(رسم بر این بود که وقتی همهٔ گله‌ها جمع می‌شدند، آن سنگ را از سر چاه برمی‌داشتند و پس از سیراب کردن گله‌ها، دوباره سنگ را بر سر چاه می‌غلتانیدند.) ");
INSERT INTO pesopcb_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","یعقوب نزد چوپانان رفت و از آنها پرسید که از کجا هستند. گفتند از حران هستند. ");
INSERT INTO pesopcb_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","به ایشان گفت: «آیا لابان نوۀ ناحور را می‌شناسید؟» گفتند: «بله، او را می‌شناسیم.» ");
INSERT INTO pesopcb_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","یعقوب پرسید: «حالِ او خوب است؟» گفتند: «بله، حالش خوب است. اینک دخترش راحیل نیز با گله‌اش می‌آید.» ");
INSERT INTO pesopcb_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","یعقوب گفت: «هنوز تا غروب خیلی مانده است. چرا به گوسفندها آب نمی‌دهید تا دوباره بروند و بچرند؟» ");
INSERT INTO pesopcb_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","جواب دادند: «تا همهٔ گله‌ها سر چاه نیایند ما نمی‌توانیم سنگ را برداریم و گله‌هایمان را سیراب کنیم.» ");
INSERT INTO pesopcb_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","در حالی که این گفتگو ادامه داشت، راحیل با گلهٔ پدرش سر رسید، زیرا او نیز چوپان بود. ");
INSERT INTO pesopcb_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","وقتی یعقوب دختر دایی خود، راحیل را دید که با گله لابان می‌آید، سنگ را از سر چاه برداشت و گلهٔ او را سیراب نمود. ");
INSERT INTO pesopcb_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","سپس یعقوب، راحیل را بوسیده، با صدای بلند شروع به گریستن نمود! ");
INSERT INTO pesopcb_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","یعقوب خود را معرفی کرد و گفت که خویشاوند پدرش و پسر ربکاست. راحیل به محض شنیدن سخنان او، دوان‌دوان به منزل شتافت و پدرش را باخبر کرد. ");
INSERT INTO pesopcb_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","چون لابان خبر آمدن خواهرزادهٔ خود یعقوب را شنید به استقبالش شتافت و او را در آغوش گرفته، بوسید و به خانهٔ خود آورد. آنگاه یعقوب داستان خود را برای او شرح داد. ");
INSERT INTO pesopcb_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","لابان به او گفت: «تو از گوشت و استخوان من هستی!» یک ماه بعد از آمدن یعقوب، ");
INSERT INTO pesopcb_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","لابان به او گفت: «تو نباید به دلیل اینکه خویشاوند من هستی برای من مجانی کار کنی. بگو چقدر مزد به تو بدهم؟» ");
INSERT INTO pesopcb_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","لابان دو دختر داشت که نام دختر بزرگ لَیه و نام دختر کوچک راحیل بود. ");
INSERT INTO pesopcb_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","لیه چشمانی ضعیف داشت، اما راحیل زیبا و خوش‌اندام بود. ");
INSERT INTO pesopcb_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","یعقوب عاشق راحیل شده بود. پس به لابان گفت: «اگر راحیل، دختر کوچکت را به همسری به من بدهی، هفت سال برای تو کار خواهم کرد.» ");
INSERT INTO pesopcb_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","لابان جواب داد: «قبول می‌کنم. ترجیح می‌دهم دخترم را به تو که از بستگانم هستی بدهم تا به یک بیگانه.» ");
INSERT INTO pesopcb_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","یعقوب برای ازدواج با راحیل هفت سال برای لابان کار کرد، ولی به قدری راحیل را دوست می‌داشت که این سالها در نظرش چند روز آمد. ");
INSERT INTO pesopcb_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","آنگاه یعقوب به لابان گفت: «مدت قرارداد ما تمام شده و موقع آن رسیده است که راحیل را به زنی بگیرم.» ");
INSERT INTO pesopcb_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","لابان همهٔ مردم آنجا را دعوت کرده، ضیافتی بر پا نمود. ");
INSERT INTO pesopcb_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","وقتی هوا تاریک شد، لابان دختر خود لیه را به حجله فرستاد و یعقوب با وی همبستر شد. ");
INSERT INTO pesopcb_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","(لابان کنیزی به نام زلفه به لیه داد تا او را خدمت کند.) ");
INSERT INTO pesopcb_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","اما صبح روز بعد، یعقوب به جای راحیل، لیه را در حجلهٔ خود یافت. پس رفته، به لابان گفت: «این چه کاری بود که با من کردی؟ من هفت سال برای تو کار کردم تا راحیل را به من بدهی. چرا مرا فریب دادی؟» ");
INSERT INTO pesopcb_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","لابان جواب داد: «رسم ما بر این نیست که دختر کوچکتر را زودتر از دختر بزرگتر شوهر بدهیم. ");
INSERT INTO pesopcb_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","صبر کن تا هفتهٔ عروسی لیه بگذرد، بعد راحیل را نیز به زنی بگیر، مشروط بر اینکه قول بدهی هفت سال دیگر برایم کار کنی.» ");
INSERT INTO pesopcb_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","یعقوب قبول کرد و لابان پس از پایان هفتهٔ عروسی لیه، دختر کوچک خود راحیل را هم به یعقوب داد. ");
INSERT INTO pesopcb_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","(لابان کنیزی به نام بلهه به راحیل داد تا او را خدمت کند.) ");
INSERT INTO pesopcb_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","یعقوب با راحیل نیز همبستر شد و او را بیشتر از لیه دوست می‌داشت و به خاطر او هفت سال دیگر برای لابان کار کرد. ");
INSERT INTO pesopcb_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","وقتی خداوند دید که یعقوب لیه را دوست ندارد، لیه را مورد لطف خود قرار داد و او بچه‌دار شد، ولی راحیل نازا ماند. ");
INSERT INTO pesopcb_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","آنگاه لیه حامله شد و پسری زایید. او گفت: «خداوند مصیبت مرا دیده است و بعد از این شوهرم مرا دوست خواهد داشت.» پس او را رئوبین نامید، زیرا گفت: «خداوند مصیبت مرا دیده است، اکنون شوهرم مرا دوست خواهد داشت.» ");
INSERT INTO pesopcb_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","او بار دیگر حامله شده، پسری به دنیا آورد و او را شمعون نامید، زیرا گفت: «خداوند شنید که من مورد بی‌مهری قرار گرفته‌ام و پسر دیگری به من داد.» ");
INSERT INTO pesopcb_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","لیه باز هم حامله شد و پسری به دنیا آورد و او را لاوی نامید، زیرا گفت: «اینک مطمئناً شوهرم به من دلبسته خواهد شد، زیرا این سومین پسری است که برایش به دنیا آورده‌ام.» ");
INSERT INTO pesopcb_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","بار دیگر او حامله شد و پسری به دنیا آورد و او را یهودا نامید، زیرا گفت: «این بار خداوند را ستایش خواهم نمود.» آنگاه لیه از زاییدن بازایستاد. ");
INSERT INTO pesopcb_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","راحیل وقتی فهمید نازاست، به خواهر خود حسد برد. او به یعقوب گفت: «به من فرزندی بده، اگر نه خواهم مرد!» ");
INSERT INTO pesopcb_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","یعقوب خشمگین شد و گفت: «مگر من خدا هستم که به تو فرزند بدهم؟ اوست که تو را نازا گردانیده است.» ");
INSERT INTO pesopcb_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","راحیل به او گفت: «با کنیزم بلهه همبستر شو تا از طریق او صاحب فرزندان شوم.» ");
INSERT INTO pesopcb_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","پس کنیز خود بِلهه را به همسری به یعقوب داد و او با وی همبستر شد. ");
INSERT INTO pesopcb_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","بلهه حامله شد و پسری برای یعقوب زایید. ");
INSERT INTO pesopcb_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","راحیل گفت: «خدا دعایم را شنیده و به دادم رسیده و اینک پسری به من بخشیده است»، پس او را دان (یعنی «دادرسی») نامید. ");
INSERT INTO pesopcb_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","بلهه باز آبستن شد و دومین پسر را برای یعقوب زایید. ");
INSERT INTO pesopcb_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","راحیل گفت: «من با خواهر خود سخت مبارزه کردم و بر او پیروز شدم»، پس او را نفتالی نامید. ");
INSERT INTO pesopcb_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","وقتی لیه دید که دیگر حامله نمی‌شود، کنیز خود زلفه را به یعقوب به زنی داد. ");
INSERT INTO pesopcb_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","زلفه برای یعقوب پسری زایید. ");
INSERT INTO pesopcb_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","لیه گفت: «خوشبختی به من روی آورده است»، پس او را جاد نامید. ");
INSERT INTO pesopcb_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","سپس زلفه دومین پسر را برای یعقوب زایید. ");
INSERT INTO pesopcb_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","لیه گفت: «چقدر خوشحال هستم! اینک زنان مرا زنی خوشحال خواهند دانست.» پس او را اَشیر نامید. ");
INSERT INTO pesopcb_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","روزی هنگام درو گندم، رئوبین مقداری مِهرگیاه که در کشتزاری روییده بود، یافت و آن را برای مادرش لیه آورد. راحیل از لیه خواهش نمود که مقداری از آن را به وی بدهد. ");
INSERT INTO pesopcb_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","اما لیه به او جواب داد: «کافی نیست که شوهرم را از دستم گرفتی، حالا می‌خواهی مِهرگیاه پسرم را هم از من بگیری؟» راحیل گفت: «اگر مِهرگیاه پسرت را به من بدهی، من هم اجازه می‌دهم امشب با یعقوب بخوابی.» ");
INSERT INTO pesopcb_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","آن روز عصر که یعقوب از صحرا برمی‌گشت، لیه به استقبال وی شتافت و گفت: «امشب باید با من بخوابی، زیرا تو را در مقابل مِهر گیاهی که پسرم یافته است، اجیر کرده‌ام!» پس یعقوب آن شب با وی همبستر شد. ");
INSERT INTO pesopcb_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","خدا دعاهای وی را اجابت فرمود و او حامله شده، پنجمین پسر خود را زایید. ");
INSERT INTO pesopcb_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","لیه گفت: «چون کنیز خود را به شوهرم دادم، خدا به من پاداش داده است.» پس او را یساکار نامید. ");
INSERT INTO pesopcb_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","او بار دیگر حامله شده، ششمین پسر را برای یعقوب زایید، ");
INSERT INTO pesopcb_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","و گفت: «خدا به من هدیه‌ای نیکو داده است. از این پس شوهرم مرا احترام خواهد کرد، زیرا برایش شش پسر زاییده‌ام.» پس او را زبولون (یعنی «احترام») نامید. ");
INSERT INTO pesopcb_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","مدتی پس از آن دختری زایید و او را دینه نامید. ");
INSERT INTO pesopcb_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","سپس خدا راحیل را به یاد آورد و دعای وی را اجابت نموده، فرزندی به او بخشید. ");
INSERT INTO pesopcb_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","او حامله شده، پسری زایید و گفت: «خدا این ننگ را از من برداشته است.» ");
INSERT INTO pesopcb_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","سپس افزود: «ای کاش خداوند پسر دیگری هم به من بدهد!» پس او را یوسف نامید. ");
INSERT INTO pesopcb_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","بعد از آنکه راحیل یوسف را زایید، یعقوب به لابان گفت: «قصد دارم به وطن خویش بازگردم. ");
INSERT INTO pesopcb_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","اجازه بده زنان و فرزندانم را برداشته با خود ببرم، چون می‌دانی با خدمتی که به تو کرده‌ام بهای آنها را تمام و کمال به تو پرداخته‌ام.» ");
INSERT INTO pesopcb_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","لابان به وی گفت: «خواهش می‌کنم مرا ترک نکن، زیرا از روی فال فهمیده‌ام که خداوند به خاطر تو مرا برکت داده است. ");
INSERT INTO pesopcb_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","هر چقدر مزد بخواهی به تو خواهم داد.» ");
INSERT INTO pesopcb_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","یعقوب جواب داد: «خوب می‌دانی که طی سالیان گذشته با چه وفاداری به تو خدمت نموده‌ام و چگونه از گله‌هایت مواظبت کرده‌ام. ");
INSERT INTO pesopcb_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","قبل از اینکه پیش تو بیایم، گله و رمهٔ چندانی نداشتی ولی اکنون اموالت بی‌نهایت زیاد شده است. خداوند به خاطر من از هر نظر به تو برکت داده است. اما من الان باید به فکر خانوادهٔ خود باشم و برای آنها تدارک ببینم.» ");
INSERT INTO pesopcb_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","لابان بار دیگر پرسید: «چقدر مزد می‌خواهی؟» یعقوب پاسخ داد: «لازم نیست چیزی به من بدهی. فقط این یک کار را برای من بکن و من باز از گله‌هایت مراقبت خواهم کرد. ");
INSERT INTO pesopcb_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","اجازه بده امروز به میان گله‌های تو بروم و تمام گوسفندان ابلق و خالدار و تمام بره‌های سیاه رنگ و همهٔ بزهای ابلق و خالدار را به جای اجرت برای خود جدا کنم. اینها مزد من خواهد بود. ");
INSERT INTO pesopcb_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","از آن به بعد، اگر حتی یک بز یا گوسفند سفید در میان گلهٔ من یافتی، بدان که من آن را از تو دزدیده‌ام.» ");
INSERT INTO pesopcb_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","لابان گفت: «آنچه را که گفتی قبول می‌کنم.» ");
INSERT INTO pesopcb_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","پس همان روز لابان تمام بزهای نری که خطّدار و خالدار بودند و بزهای ماده‌ای که ابلق و خالدار بودند و تمامی بره‌های سیاه رنگ را جدا کرد و به پسرانش سپرد. ");
INSERT INTO pesopcb_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","آنگاه آنها را به فاصلهٔ سه روز راه از یعقوب دور کرد. درضمن، خود یعقوب در آنجا ماند تا بقیهٔ گلهٔ لابان را بچراند. ");
INSERT INTO pesopcb_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","آنگاه یعقوب شاخه‌های سبز و تازهٔ درختان بید و بادام و چنار را کَند و خطّهای سفیدی بر روی آنها تراشید. ");
INSERT INTO pesopcb_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","این چوبها را در کنار آبشخور قرار داد تا وقتی که گله‌ها برای خوردن آب می‌آیند، آنها را ببینند. وقتی گله‌ها برای خوردن آب می‌آمدند، و می‌خواستند جفتگیری کنند، ");
INSERT INTO pesopcb_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","جلوی چوبها با یکدیگر جفتگیری می‌کردند و بره‌هایی می‌زاییدند که خطّدار، خالدار و ابلق بودند. ");
INSERT INTO pesopcb_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","یعقوب، این برّه‌ها را از گلهٔ لابان جدا می‌کرد و به گلهٔ خود می‌افزود. به این ترتیب او با استفاده از گلهٔ لابان، گلهٔ خودش را بزرگ می‌کرد. ");
INSERT INTO pesopcb_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","در ضمن هرگاه حیوانات مادهٔ قوی می‌خواستند جفتگیری کنند، یعقوب چوبها را در آبشخور جلوی آنها قرار می‌داد تا کنار آنها جفتگیری کنند. ");
INSERT INTO pesopcb_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","ولی اگر حیوانات ضعیف بودند، چوبها را در آنجا نمی‌گذاشت. بنابراین حیوانات ضعیف از آنِ لابان و حیوانات قوی از آن یعقوب می‌شدند. ");
INSERT INTO pesopcb_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","بدین ترتیب یعقوب بسیار ثروتمند شد و صاحب کنیزان و غلامان، گله‌های بزرگ، شترها و الاغهای زیادی گردید. ");
INSERT INTO pesopcb_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","روزی یعقوب شنید که پسران لابان می‌گفتند: «یعقوب همهٔ دارایی پدر ما را گرفته و از اموال پدر ماست که اینچنین ثروتمند شده است.» ");
INSERT INTO pesopcb_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","یعقوب به‌زودی دریافت که رفتار لابان با وی مثل سابق دوستانه نیست. ");
INSERT INTO pesopcb_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","در این موقع خداوند به یعقوب فرمود: «به سرزمین پدرانت و نزد خویشاوندانت بازگرد و من با تو خواهم بود.» ");
INSERT INTO pesopcb_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","پس یعقوب، برای راحیل و لیه پیغام فرستاد که به صحرا، جایی که گله او هست، بیایند تا با آنها صحبت کند. ");
INSERT INTO pesopcb_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","وقتی آمدند یعقوب به آنها گفت: «من متوجه شده‌ام که رفتار پدر شما با من مثل سابق دوستانه نیست، ولی خدای پدرم مرا ترک نکرده است. ");
INSERT INTO pesopcb_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","شما می‌دانید که با چه کوشش طاقت فرسایی به پدرتان خدمت کرده‌ام، ");
INSERT INTO pesopcb_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","اما او بارها حق مرا پایمال کرده و مرا فریب داده است. ولی خدا نگذاشت او به من ضرری برساند؛ ");
INSERT INTO pesopcb_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","زیرا هر وقت پدرتان می‌گفت: ”حیواناتِ خالدار از آن تو باشند،“ تمامی گله بره‌های خالدار می‌آوردند و موقعی که از این فکر منصرف می‌شد و می‌گفت: ”تمام خط‌دارها مال تو باشند،“ آنگاه تمام گله بره‌های خط‌دار می‌زاییدند! ");
INSERT INTO pesopcb_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","بدین طریق خدا اموال پدر شما را گرفته و به من داده است. ");
INSERT INTO pesopcb_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","«هنگامی که فصل جفتگیری گله فرا رسید، در خواب دیدم قوچهایی که با میشها جفتگیری می‌کردند خط‌دار، خالدار و ابلق بودند. ");
INSERT INTO pesopcb_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","آنگاه فرشتۀ خدا در خواب به من گفت: ”یعقوب!“ و من گفتم: ”بله، امر بفرما!“ ");
INSERT INTO pesopcb_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","گفت: ”ببین، تمام قوچهایی که با میشها جفتگیری می‌کنند خط‌دار، خالدار و ابلق هستند، زیرا از آنچه که لابان به تو کرده است آگاه هستم. ");
INSERT INTO pesopcb_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","من همان خدایی هستم که در بیت‌ئیل به تو ظاهر شدم، جایی که ستونی از سنگ بر پا نموده بر آن روغن ریختی و نذر کردی که مرا پیروی کنی. اکنون این دیار را ترک کن و به وطن خود بازگرد.“» ");
INSERT INTO pesopcb_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","راحیل و لیه در جواب یعقوب گفتند: «در هر حال چیزی از ثروت پدرمان به ما نخواهد رسید، ");
INSERT INTO pesopcb_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","زیرا او با ما مثل بیگانه رفتار کرده است. او ما را فروخته و پولی را که از این بابت دریافت داشته، تماماً تصاحب کرده است. ");
INSERT INTO pesopcb_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","ثروتی که خدا از اموال پدرمان به تو داده است، به ما و فرزندانمان تعلق دارد. پس آنچه خدا به تو فرموده است انجام بده.» ");
INSERT INTO pesopcb_vpl VALUES ("GN31_17‏","002_31_17‏","GEN","31","17‏","21","روزی هنگامی که لابان برای چیدن پشم گلهٔ خود بیرون رفته بود، یعقوب بدون اینکه او را از قصد خود آگاه سازد، زنان و فرزندان خود را بر شترها سوار کرده، تمام گله‌ها و اموال خود را که در فَدّان‌اَرام فراهم آورده بود برداشت تا نزد پدرش اسحاق به زمین کنعان برود. پس با آنچه که داشت گریخت. او با خانواده از رود فرات عبور کرد و به سوی کوهستان جلعاد پیش رفت. (در ضمن راحیل بُتهای خاندان پدرش را دزدید و با خود برد.) ");
INSERT INTO pesopcb_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","سه روز بعد، به لابان خبر دادند که یعقوب فرار کرده است. ");
INSERT INTO pesopcb_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","پس او چند نفر را با خود برداشت و با شتاب به تعقیب یعقوب پرداخت و پس از هفت روز در کوهستان جلعاد به او رسید. ");
INSERT INTO pesopcb_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","همان شب، خدا در خواب بر لابان ظاهر شد و فرمود: «مراقب باش حرفی به یعقوب نزنی.» ");
INSERT INTO pesopcb_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","یعقوب در کوهستانِ جلعاد خیمه زده بود که لابان با افرادش به او رسید. او نیز در آنجا خیمۀ خود را بر پا کرد. ");
INSERT INTO pesopcb_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","لابان از یعقوب پرسید: «چرا مرا فریب دادی و دختران مرا مانند اسیران جنگی برداشتی و رفتی؟ ");
INSERT INTO pesopcb_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","چرا به من خبر ندادی تا جشنی برایتان بر پا کنم و با ساز و آواز شما را روانه سازم؟ ");
INSERT INTO pesopcb_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","لااقل می‌گذاشتی نوه‌ها و دخترانم را ببوسم و با آنها خداحافظی کنم! کار احمقانه‌ای کردی! ");
INSERT INTO pesopcb_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","قدرت آن را دارم که به تو صدمه برسانم، ولی شبِ گذشته خدای پدرت بر من ظاهر شده، گفت: ”مراقب باش حرفی به یعقوب نزنی.“ ");
INSERT INTO pesopcb_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","از همهٔ اینها گذشته، تو که می‌خواستی بروی و اینقدر آرزو داشتی که به زادگاه خویش بازگردی، دیگر چرا بُتهای مرا دزدیدی؟» ");
INSERT INTO pesopcb_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","یعقوب در جواب وی گفت: «علّت فرار پنهانی من این بود که می‌ترسیدم به زور دخترهایت را از من پس بگیری. ");
INSERT INTO pesopcb_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","اما در مورد بُتهایت، هر که از ما آنها را دزدیده باشد، کُشته شود. اگر از مال خودت چیزی در اینجا پیدا کردی، در حضور این مردان قسم می‌خورم آن را بدون چون و چرا به تو پس بدهم.» (یعقوب نمی‌دانست که راحیل بُتها را با خود آورده است.) ");
INSERT INTO pesopcb_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","لابان به جستجو پرداخت. اول خیمهٔ یعقوب، بعد خیمهٔ لیه و سپس خیمهٔ کنیزان یعقوب را جستجو کرد، ولی بُتها را نیافت. سرانجام به خیمهٔ راحیل رفت. ");
INSERT INTO pesopcb_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","راحیل که بُتها را دزدیده بود، آنها را زیر جهاز شتر پنهان نموده، روی آن نشسته بود! پس با این که لابان با دقت داخل خیمه را جستجو کرد چیزی پیدا نکرد. ");
INSERT INTO pesopcb_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","راحیل به پدرش گفت: «پدر، از این که نمی‌توانم در حضور تو بایستم مرا ببخش، چون عادت زنان بر من است.» ");
INSERT INTO pesopcb_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","یعقوب دیگر طاقت نیاورد و با عصبانیت به لابان گفت: «چه جرمی مرتکب شده‌ام که مرا اینچنین تعقیب کردی؟ ");
INSERT INTO pesopcb_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","حال که تمام اموالم را تفتیش کردی، چه چیزی یافتی؟ اگر از مال خود چیزی یافته‌ای آن را پیش همهٔ مردان خودت و مردان من بیاور تا آنها ببینند و قضاوت کنند که از آن کیست! ");
INSERT INTO pesopcb_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","در این بیست سال که نزد تو بوده‌ام و از گلهٔ تو مراقبت نموده‌ام، حتی یکی از بچه‌های حیواناتت تلف نشد و هرگز یکی از آنها را نخوردم. ");
INSERT INTO pesopcb_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","اگر حیوان درنده‌ای به یکی از آنها حمله می‌کرد و آن را می‌کشت، حتی بدون این که به تو بگویم، تاوانش را می‌دادم. اگر گوسفندی از گله در روز یا در شب دزدیده می‌شد، مرا مجبور می‌کردی پولش را بدهم. ");
INSERT INTO pesopcb_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","در گرمای سوزان روز و سرمای شدید شب، بدون این که خواب به چشمانم راه دهم، برای تو کار کردم. ");
INSERT INTO pesopcb_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","آری، بیست سال تمام برای تو زحمت کشیدم، چهارده سال به خاطر دو دخترت و شش سال برای به دست آوردن این گله‌ای که دارم! تو بارها حق مرا پایمال کردی. ");
INSERT INTO pesopcb_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","اگر رحمت خدای جدم ابراهیم و هیبت خدای پدرم اسحاق با من نمی‌بود، اکنون مرا تهیدست روانه می‌کردی. ولی خدا مصیبت و زحمات مرا دیده و به همین سبب دیشب بر تو ظاهر شده است.» ");
INSERT INTO pesopcb_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","لابان گفت: «زنان تو، دختران من و فرزندانت، فرزندان من و گله‌ها و هر آنچه که داری از آن من است. پس امروز چگونه می‌توانم به دختران و نوه‌هایم ضرر برسانم؟ ");
INSERT INTO pesopcb_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","حال بیا با هم عهد ببندیم و از این پس طبق آن عمل کنیم.» ");
INSERT INTO pesopcb_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","پس یعقوب سنگی برداشت و آن را به عنوان نشانهٔ عهد، به صورت ستونی بر پا کرد ");
INSERT INTO pesopcb_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","و به همراهان خود گفت که سنگها گرد آورند و آنها را به صورت توده‌ای بر پا کنند. آنگاه یعقوب و لابان با هم در پای تودهٔ سنگها غذا خوردند. ");
INSERT INTO pesopcb_vpl VALUES ("GN31_47‏","002_31_47‏","GEN","31","47‏","48","آنها آن تودهٔ سنگها را «تودهٔ شهادت» نامیدند که به زبان لابان یجرسهدوتا و به زبان یعقوب جَلعید خوانده می‌شد. لابان گفت: «اگر یکی از ما شرایط این عهد را رعایت نکند، این سنگها علیه او شهادت خواهند داد.» ");
INSERT INTO pesopcb_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","همچنین آن تودۀ سنگها را مِصفَه (یعنی «برج دیدبانی») نام نهادند، چون لابان گفت: «وقتی که ما از یکدیگر دور هستیم، خداوند بر ما دیدبانی کند. ");
INSERT INTO pesopcb_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","اگر تو با دخترانم با خشونت رفتار کنی یا زنان دیگری بگیری، من نخواهم فهمید، ولی خدا آن را خواهد دید.» ");
INSERT INTO pesopcb_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","لابان افزود: «این توده و این ستون را ببین که آن را میان ما برپا داشته‌ام. ");
INSERT INTO pesopcb_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","اینها شاهد عهد ما خواهند بود. هیچ‌یک از ما نباید به قصد حمله به دیگری از این توده بگذرد. ");
INSERT INTO pesopcb_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","خدای جد ما ابراهیم و خدای جد ما ناحور میان ما داوری کند.» سپس یعقوب به هیبت خدای پدرش اسحاق قسم یاد نمود که این عهد را نگه دارد. ");
INSERT INTO pesopcb_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","آنگاه یعقوب در همان کوهستان برای خداوند قربانی کرد و همراهانش را به مهمانی دعوت نموده، با ایشان غذا خورد و همگی شب را در آنجا به سر بردند. ");
INSERT INTO pesopcb_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","لابان صبح زود برخاسته، دختران و نوه‌هایش را بوسید و آنها را برکت داد و به خانهٔ خویش مراجعت نمود. ");
INSERT INTO pesopcb_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","یعقوب به سفر خود ادامه داد. در بین راه فرشتگان خدا بر او ظاهر شدند. ");
INSERT INTO pesopcb_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","یعقوب وقتی آنها را دید، گفت: «این است اردوی خدا.» پس آنجا را مَحَنایِم نامید. ");
INSERT INTO pesopcb_vpl VALUES ("GN32_3‏","002_32_3‏","GEN","32","3‏","4","آنگاه یعقوب، قاصدانی با این پیام نزد برادر خود عیسو به ادوم، واقع در سرزمین سعیر فرستاد: «بنده‌ات یعقوب تا چندی قبل نزد دایی خود لابان سکونت داشتم. ");
INSERT INTO pesopcb_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","اکنون گاوها، الاغها، گوسفندها، غلامان و کنیزان فراوانی به دست آورده‌ام. این قاصدان را فرستاده‌ام تا تو را از آمدنم آگاه سازند. ای سَروَرم، امیدوارم مورد لطف تو قرار بگیرم.» ");
INSERT INTO pesopcb_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","قاصدان پس از رساندن پیام، نزد یعقوب برگشته، به وی گفتند: «برادرت عیسو را دیدیم و او الان با چهارصد نفر به استقبال تو می‌آید!» ");
INSERT INTO pesopcb_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","یعقوب با شنیدن این خبر بی‌نهایت ترسان و مضطرب شد. او افراد خانوادهٔ خود را با گله‌ها و رمه‌ها و شترها به دو دسته تقسیم کرد ");
INSERT INTO pesopcb_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","تا اگر عیسو به یک دسته حمله کند، دستهٔ دیگر بگریزد. ");
INSERT INTO pesopcb_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","سپس یعقوب چنین دعا کرد: «ای خدای جدم ابراهیم و خدای پدرم اسحاق، ای خداوندی که به من گفتی به وطن خود نزد خویشاوندانم برگردم و قول دادی که مرا برکت دهی، ");
INSERT INTO pesopcb_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","من لیاقت این همه لطف و محبتی که به خادمت نموده‌ای ندارم. آن زمان که زادگاه خود را ترک کردم و از رود اردن گذشتم، چیزی جز یک چوبدستی همراه خود نداشتم، ولی اکنون مالک دو گروه هستم! ");
INSERT INTO pesopcb_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","خداوندا، التماس می‌کنم مرا از دست برادرم عیسو رهایی دهی، چون از او می‌ترسم. از این می‌ترسم که مبادا او این زنان و کودکان را هلاک کند. ");
INSERT INTO pesopcb_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","به یاد آور که تو قول داده‌ای که مرا برکت دهی و نسل مرا چون شنهای ساحل دریا بی‌شمار گردانی.» ");
INSERT INTO pesopcb_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","یعقوب شب را در آنجا به سر برد و از آنچه با خود داشت این هدایا را برای تقدیم به برادرش عیسو انتخاب کرد: ");
INSERT INTO pesopcb_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","دویست بز ماده، بیست بز نر، دویست میش، بیست قوچ، ");
INSERT INTO pesopcb_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","سی شتر شیرده با بچه‌هایشان، چهل گاو ماده، ده گاو نر، بیست الاغ ماده و ده الاغ نر. ");
INSERT INTO pesopcb_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","او آنها را دسته‌دسته جدا کرده، به خادمانش سپرد و گفت: «از هم فاصله بگیرید و جلوتر از من حرکت کنید.» ");
INSERT INTO pesopcb_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","به مردانی که دستهٔ اول را رهبری می‌کردند گفت که موقع برخورد با عیسو اگر عیسو از ایشان بپرسد: «کجا می‌روید؟ برای چه کسی کار می‌کنید؟ و این حیوانات مال کیست؟» ");
INSERT INTO pesopcb_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","باید بگویند: «اینها متعلق به بنده‌ات یعقوب می‌باشند و هدایایی است که برای سَروَر خود عیسو فرستاده است. خودش هم پشت سر ما می‌آید.» ");
INSERT INTO pesopcb_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","یعقوب همین دستورها را به افراد دستۀ دوم و سوم و به همۀ کسانی که بدنبال گله‌ها می‌آمدند داده، گفت: «وقتی به عیسو رسیدید، همین سخنان را به او بگویید. ");
INSERT INTO pesopcb_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","و نیز بگویید: ”بنده‌ات یعقوب نیز پشت سر ما می‌آید.“» یعقوب با خود فکر کرد: «با این هدایایی که جلوتر از خودم می‌فرستم او را نرم خواهم کرد. پس از آن وقتی او را ببینم شاید مرا بپذیرد.» ");
INSERT INTO pesopcb_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","پس او هدایا را جلوتر فرستاد اما خودش شب را در اردوگاه به سر برد. ");
INSERT INTO pesopcb_vpl VALUES ("GN32_22‏","002_32_22‏","GEN","32","22‏","24","شبانگاه یعقوب برخاست و دو همسر و کنیزان و یازده پسر و تمام اموال خود را برداشته، به کنار رود اردن آمد و آنها را از گذرگاه یبوق به آن طرف رود فرستاد و خود در همان جا تنها ماند. سپس مردی به سراغ او آمده، تا سپیدهٔ صبح با او کشتی گرفت. ");
INSERT INTO pesopcb_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","وقتی آن مرد دید که نمی‌تواند بر یعقوب غالب شود، مفصل لگن ران او را محکم گرفت، به طوری که لگن او از جا در رفت. ");
INSERT INTO pesopcb_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","سپس آن مرد گفت: «بگذار بروم، چون سپیده دمیده است.» اما یعقوب گفت: «تا مرا برکت ندهی نمی‌گذارم از اینجا بروی.» ");
INSERT INTO pesopcb_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","آن مرد پرسید: «نام تو چیست؟» جواب داد: «یعقوب.» ");
INSERT INTO pesopcb_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","به او گفت: «پس از این نام تو دیگر یعقوب نخواهد بود، بلکه اسرائیل، زیرا نزد خدا و مردم مقاوم بوده و پیروز شده‌ای.» ");
INSERT INTO pesopcb_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","یعقوب از او پرسید: «نام تو چیست؟» آن مرد گفت: «چرا نام مرا می‌پرسی؟» آنگاه یعقوب را در آنجا برکت داد. ");
INSERT INTO pesopcb_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","یعقوب گفت: «در اینجا من خدا را رو به رو دیدم و با وجود این هنوز زنده هستم.» پس آن مکان را فنی‌ئیل (یعنی «چهرهٔ خدا») نامید. ");
INSERT INTO pesopcb_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","یعقوب هنگام طلوع آفتاب به راه افتاد. او به خاطر صدمه‌ای که به رانش وارد شده بود، می‌لنگید. ");
INSERT INTO pesopcb_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","(بنی‌اسرائیل تا به امروز ماهیچهٔ عِرق النِساء را که در ران است نمی‌خورند، زیرا این قسمت از رانِ یعقوب بود که در آن شب صدمه دید.) ");
INSERT INTO pesopcb_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","آنگاه یعقوب از فاصلهٔ دور دید که عیسو با چهارصد نفر از افراد خود می‌آید. پس فرزندانش را بین لیه و راحیل و دو کنیز تقسیم کرد. ");
INSERT INTO pesopcb_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","بدین ترتیب خانواده‌اش را در یک صف به سه دسته تقسیم کرد. در دستهٔ اول دو کنیز او و فرزندانشان، در دستهٔ دوم لیه و فرزندانش و در دستهٔ سوم راحیل و یوسف قرار داشتند. ");
INSERT INTO pesopcb_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","خود یعقوب نیز در پیشاپیش آنها حرکت می‌کرد. وقتی یعقوب به برادرش نزدیک شد، هفت مرتبه او را تعظیم کرد. ");
INSERT INTO pesopcb_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","عیسو دوان‌دوان به استقبال او شتافت و او را در آغوش کشیده، بوسید و هر دو گریستند. ");
INSERT INTO pesopcb_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","سپس عیسو نگاهی به زنان و کودکان انداخت و پرسید: «این همراهان تو کیستند؟» یعقوب گفت: «فرزندانی هستند که خدا به بنده‌ات عطا فرموده است.» ");
INSERT INTO pesopcb_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","آنگاه کنیزان با فرزندانشان جلو آمده، عیسو را تعظیم کردند، ");
INSERT INTO pesopcb_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","بعد لیه و فرزندانش و آخر همه راحیل و یوسف پیش آمدند و او را تعظیم نمودند. ");
INSERT INTO pesopcb_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","عیسو پرسید: «این همه گله و رمه که در راه دیدم، چیستند؟» یعقوب گفت: «آنها را هدیۀ من است به تو، تا مورد لطف تو قرار گیرم.» ");
INSERT INTO pesopcb_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","عیسو گفت: «برادر، من خود گله و رمه به قدر کافی دارم. آنها را برای خودت نگاه دار.» ");
INSERT INTO pesopcb_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","یعقوب پاسخ داد: «اگر واقعاً مورد لطف تو واقع شده‌ام، التماس دارم هدیهٔ مرا قبول کنی. دیدن روی تو برای من مانند دیدن روی خدا بود! حال که تو با مهربانی مرا پذیرفتی، ");
INSERT INTO pesopcb_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","پس هدایایی را که به تو پیشکش کرده‌ام قبول فرما. خدا نسبت به من بسیار بخشنده بوده و تمام احتیاجاتم را رفع کرده است.» یعقوب آنقدر اصرار کرد تا عیسو آنها را پذیرفت. ");
INSERT INTO pesopcb_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","عیسو گفت: «آماده شو تا برویم. من و افرادم تو را همراهی خواهیم کرد.» ");
INSERT INTO pesopcb_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","یعقوب گفت: «چنانکه می‌بینی بعضی از بچه‌ها کوچکند و رمه‌ها و گله‌ها نوزادانی دارند که اگر آنها را به سرعت برانیم همگی تلف خواهند شد. ");
INSERT INTO pesopcb_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","ای سرورم، شما جلوتر از بنده‌ات بروید و ما هم همراه بچه‌ها و گله‌ها آهسته می‌آییم و در سعیر به شما ملحق می‌شویم.» ");
INSERT INTO pesopcb_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","عیسو گفت: «لااقل بگذار چند نفر از افرادم همراهتان باشند تا شما را راهنمایی و محافظت کنند.» یعقوب پاسخ داد: «لزومی ندارد، ما خودمان می‌آییم. از لطف سَروَرم سپاسگزارم.» ");
INSERT INTO pesopcb_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","عیسو همان روز راه خود را پیش گرفته، به سعیر مراجعت نمود، ");
INSERT INTO pesopcb_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","اما یعقوب با خانواده‌اش به سوکوت رفت و در آنجا برای خود خیمه و برای گله‌ها و رمه‌هایش سایبانها درست کرد. به همین دلیل آن مکان را سوکوت نامیده‌اند. ");
INSERT INTO pesopcb_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","سپس از آنجا به سلامتی به شکیم واقع در کنعان کوچ کردند و خارج از شهر خیمه زدند. ");
INSERT INTO pesopcb_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","او زمینی را که در آن خیمه زده بود از خانوادهٔ حمور، پدر شکیم به صد پاره نقره خرید. ");
INSERT INTO pesopcb_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","در آنجا یعقوب مذبحی ساخت و آن را «اِل الوهی اسرائیل» نامید. ");
INSERT INTO pesopcb_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","روزی دینه، دختر یعقوب و لیه، برای دیدن دخترانی که در همسایگی آنها سکونت داشتند بیرون رفت. ");
INSERT INTO pesopcb_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","وقتی شکیم پسر حمور، پادشاه حّوی، دینه را دید او را گرفته، به وی تجاوز نمود. ");
INSERT INTO pesopcb_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","شکیم سخت عاشق دینه شد و سعی کرد با سخنان دلنشین توجه او را به خود جلب نماید. ");
INSERT INTO pesopcb_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","شکیم این موضوع را با پدر خویش در میان نهاد و از او خواهش کرد که آن دختر را برایش به زنی بگیرد. ");
INSERT INTO pesopcb_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","چیزی نگذشت که این خبر به گوش یعقوب رسید، ولی چون پسرانش برای چرانیدن گله‌ها به صحرا رفته بودند، تا مراجعت آنها هیچ اقدامی نکرد. ");
INSERT INTO pesopcb_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","حمور، پدر شکیم، نزد یعقوب رفت تا با او صحبت کند. ");
INSERT INTO pesopcb_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","او وقتی به آنجا رسید که پسران یعقوب نیز از صحرا برگشته بودند. ایشان از شنیدن آنچه بر سر خواهرشان آمده بود به شدت خشمگین بودند، زیرا این عملِ زشت حیثیت آنها را پایمال کرده بود. ");
INSERT INTO pesopcb_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","حمور به یعقوب گفت: «پسرم شکیم دلباختۀ دختر شماست. خواهش می‌کنم وی را به زنی به او بدهید. ");
INSERT INTO pesopcb_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","علاوه بر این، می‌توانیم با هم وصلت کنیم، دختران خود را به پسران ما بدهید و دختران ما را برای پسران خود بگیرید. ");
INSERT INTO pesopcb_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","شما می‌توانید میان ما ساکن شوید؛ این سرزمین به روی شما باز است! در اینجا ساکن شوید و با ما تجارت کنید. می‌توانید در این سرزمین صاحب املاک شوید.» ");
INSERT INTO pesopcb_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","آنگاه شکیم به پدر و برادران دینه گفت: «خواهش می‌کنم در حق من این لطف را بکنید و اجازه دهید دینه را به زنی بگیرم. هر چه به من بگویید خواهم کرد. ");
INSERT INTO pesopcb_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","هر چقدر مهریه و پیشکش بخواهید به شما خواهم داد. فقط این دختر را به زنی به من بدهید.» ");
INSERT INTO pesopcb_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","برادران دینه به خاطر این که شکیم خواهرشان را رسوا کرده بود، به نیرنگ به شکیم و پدرش گفتند: ");
INSERT INTO pesopcb_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","«ما نمی‌توانیم خواهر خود را به یک ختنه نشده بدهیم. این مایهٔ رسوایی ما خواهد شد. ");
INSERT INTO pesopcb_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","ولی به یک شرط حاضریم این کار را بکنیم، و آن شرط این است که همهٔ مردان و پسران شما ختنه شوند. ");
INSERT INTO pesopcb_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","آنگاه دختران خود را به شما خواهیم داد و دختران شما را برای خود خواهیم گرفت و در بین شما ساکن شده، یک قوم خواهیم بود. ");
INSERT INTO pesopcb_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","اگر این شرط را نپذیرید و ختنه نشوید، دخترمان را برداشته از اینجا خواهیم رفت.» ");
INSERT INTO pesopcb_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","حمور و شکیم شرط آنها را پذیرفتند. ");
INSERT INTO pesopcb_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","شکیم که در خاندان خود بسیار مورد احترام بود، در انجام این کار درنگ ننمود، زیرا عاشق دختر یعقوب بود. ");
INSERT INTO pesopcb_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","پس او و پدرش به دروازهٔ شهر رفتند و به اهالی آنجا گفتند: ");
INSERT INTO pesopcb_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","«این مردم، دوستان ما هستند. اجازه دهید در میان ما ساکن شده، به کسب و کار خود مشغول شوند. زمین وسیع است و جای کافی برای آنها وجود دارد و ما و آنها می‌توانیم با هم وصلت کنیم. ");
INSERT INTO pesopcb_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","اما آنها فقط به این شرط حاضرند در اینجا بمانند و با ما یک قوم شوند که همۀ مردان و پسران ما مانند ایشان ختنه گردند. ");
INSERT INTO pesopcb_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","اگر چنین کنیم، اموال و گله‌ها و آنچه که دارند از آن ما خواهد شد. بیایید با این شرط موافقت کنیم تا آنها در اینجا با ما زندگی کنند.» ");
INSERT INTO pesopcb_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","اهالی شهر پیشنهاد شکیم و پدرش را پذیرفتند و ختنه شدند. ");
INSERT INTO pesopcb_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","ولی سه روز بعد، در حالی که آنها هنوز درد داشتند، شمعون و لاوی، برادران دینه، شمشیرهای خود را برداشته، بدون روبرو شدن با کوچکترین مقاومتی وارد شهر شدند و تمام مردان را از دمِ شمشیر گذرانیدند. ");
INSERT INTO pesopcb_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","آنها حمور و شکیم را کُشتند و دینه را از خانهٔ شکیم برداشته، با خود بردند. ");
INSERT INTO pesopcb_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","سپس پسران یعقوب رفتند و تمام شهر را غارت کردند، زیرا خواهرشان در آنجا رسوا شده بود. ");
INSERT INTO pesopcb_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","ایشان گله‌ها و رمه‌ها و الاغها و هر چه را که به دستشان رسید، چه در شهر و چه در صحرا، ");
INSERT INTO pesopcb_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","با زنان و اطفال و تمامی اموالی که در خانه‌ها بود غارت کردند و با خود بردند. ");
INSERT INTO pesopcb_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","یعقوب به شمعون و لاوی گفت: «شما مرا به دردسر انداخته‌اید؛ حال کنعانی‌ها و فرّزی‌ها و تمامی ساکنان این مرزوبوم دشمن من خواهند شد. عدهٔ ما در برابر آنها ناچیز است؛ اگر آنها بر سر ما بریزند، ما را نابود خواهند کرد.» ");
INSERT INTO pesopcb_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","آنها با خشم جواب دادند: «آیا او می‌بایست با خواهر ما مانند یک فاحشه رفتار می‌کرد؟» ");
INSERT INTO pesopcb_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","خدا به یعقوب فرمود: «حال برخیز و به بیت‌ئیل برو. در آنجا ساکن شو و مذبحی بساز و آن خدایی را که وقتی از دست برادرت عیسو می‌گریختی بر تو ظاهر شد، عبادت نما.» ");
INSERT INTO pesopcb_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","آنگاه یعقوب به تمامی اهل خانهٔ خود دستور داد که بُتهایی را که با خود آورده بودند، دور بیندازند و غسل بگیرند و لباسهایشان را عوض کنند. ");
INSERT INTO pesopcb_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","او به ایشان گفت: «به بیت‌ئیل می‌رویم تا در آنجا برای خدایی که به هنگام سختی، دعاهایم را اجابت فرمود و هر جا می‌رفتم با من بود، مذبحی بسازم.» ");
INSERT INTO pesopcb_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","پس همگی، بُتهای خود و گوشواره‌هایی را که در گوش داشتند به یعقوب دادند و او آنها را زیر درخت بلوطی در شکیم دفن کرد. ");
INSERT INTO pesopcb_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","سپس آنها بار دیگر کوچ کردند. و ترس خدا بر تمامی شهرهایی که یعقوب از آنها عبور می‌کرد قرار گرفت تا به وی حمله نکنند. ");
INSERT INTO pesopcb_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","سرانجام به لوز که همان بیت‌ئیل باشد و در سرزمین کنعان واقع است، رسیدند. ");
INSERT INTO pesopcb_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","یعقوب در آنجا مذبحی بنا کرد و آن را مذبح خدای بیت‌ئیل نامید (چون هنگام فرار از دست عیسو، در بیت‌ئیل بود که خدا بر او ظاهر شد.) ");
INSERT INTO pesopcb_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","چند روز پس از آن، دبوره دایهٔ پیر ربکا مُرد و او را زیر درخت بلوطی در درهٔ پایین بیت‌ئیل به خاک سپردند. از آن پس، درخت مذکور را بلوط گریه نامیدند. ");
INSERT INTO pesopcb_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","پس از آنکه یعقوب از فَدّان‌اَرام وارد بیت‌ئیل شد، خدا بار دیگر بر وی ظاهر شد و او را برکت داد ");
INSERT INTO pesopcb_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","و به او فرمود: «بعد از این دیگر نام تو یعقوب خوانده نشود، بلکه نام تو اسرائیل خواهد بود. ");
INSERT INTO pesopcb_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","من هستم خدای قادر مطلق. بارور و زیاد شو! قومهای زیاد و پادشاهان بسیار از نسل تو پدید خواهند آمد. ");
INSERT INTO pesopcb_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","سرزمینی را که به ابراهیم و اسحاق دادم، به تو و به نسل تو نیز خواهم داد.» ");
INSERT INTO pesopcb_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","سپس خدا از نزد او به آسمان صعود کرد. ");
INSERT INTO pesopcb_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","پس از آن، یعقوب در همان جایی که خدا بر او ظاهر شده بود، ستونی از سنگ بنا کرد و هدیهٔ نوشیدنی برای خداوند بر آن ریخت و آن را با روغن زیتون تدهین کرد. ");
INSERT INTO pesopcb_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","یعقوب آن محل را بیت‌ئیل (یعنی «خانۀ خدا») نامید، زیرا خدا در آنجا با وی سخن گفته بود. ");
INSERT INTO pesopcb_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","سپس او و خانواده‌اش بیت‌ئیل را ترک گفتند و به سوی افرات رهسپار شدند. اما هنوز به افرات نرسیده بودند که دردِ زایمانِ راحیل شروع شد. ");
INSERT INTO pesopcb_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","پس از زایمان بسیار سخت، سرانجام قابله گفت: «نترس، یک پسر دیگر به دنیا آوردی!» ");
INSERT INTO pesopcb_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","ولی راحیل در حال مرگ بود. او در حین جان سپردن، پسرش را بِن اونی نام نهاد، ولی بعد پدرش او را بِنیامین نامید. ");
INSERT INTO pesopcb_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","پس راحیل وفات یافت و او را در نزدیکی راه افرات که بیت‌لحم هم نامیده می‌شد، دفن کردند. ");
INSERT INTO pesopcb_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","یعقوب روی قبرش ستونی از سنگ بنا کرد که تا به امروز باقی است. ");
INSERT INTO pesopcb_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","آنگاه یعقوب از آنجا کوچ کرد و در آن طرف برج عیدر خیمه زد. ");
INSERT INTO pesopcb_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","در همین‌جا بود که رئوبین با بلهه کنیز پدرش همبستر شد و یعقوب از این جریان آگاهی یافت. ");
INSERT INTO pesopcb_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","یعقوب دوازده پسر داشت که اسامی آنها از این قرار است: پسران لیه: رئوبین (بزرگترین فرزند یعقوب)، شمعون، لاوی، یهودا، یساکار و زبولون. ");
INSERT INTO pesopcb_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","پسران راحیل: یوسف و بنیامین. ");
INSERT INTO pesopcb_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","پسران بلهه کنیز راحیل: دان و نفتالی. ");
INSERT INTO pesopcb_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","جاد و اشیر هم از زلفه، کنیز لیه بودند. همه پسران یعقوب در فَدّان‌اَرام متولد شدند. ");
INSERT INTO pesopcb_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","سرانجام یعقوب نزد پدر خود اسحاق به قریهٔ اربع واقع در مِلک ممری آمد. (آن قریه را حبرون نیز می‌گویند. حبرون همان جایی است که ابراهیم و اسحاق در آن در غربت به سر می‌بردند.) ");
INSERT INTO pesopcb_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","اسحاق ۱۸۰ سال زندگی کرد. ");
INSERT INTO pesopcb_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","آنگاه آخرین نفسش را برآورده، در کمال پیری وفات یافت و به اجداد خویش پیوست و پسرانش عیسو و یعقوب او را دفن کردند. ");
INSERT INTO pesopcb_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","این است تاریخچۀ نسل عیسو که همان ادوم است. ");
INSERT INTO pesopcb_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","عیسو از دختران کنعان دو زن گرفت: عاده دختر ایلون حیتّی، و اهولیبامه دختر عنا، نوه صبعون حّوی. ");
INSERT INTO pesopcb_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","او همچنین بسمه دختر اسماعیل، خواهر نبایوت را نیز به زنی گرفت. ");
INSERT INTO pesopcb_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","عاده، الیفاز را برای عیسو زایید و بسمه رعوئیل را. ");
INSERT INTO pesopcb_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","اهولیبامه، یعوش و یعلام و قورح را زایید. همهٔ پسران عیسو در سرزمین کنعان متولد شدند. ");
INSERT INTO pesopcb_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","عیسو، زنان و پسران و دختران و همهٔ اهل بیت و همۀ چارپایان و دارایی خود را که در سرزمین کنعان به دست آورده بود، برداشت و به سرزمینی دیگر دور از برادرش یعقوب رفت. ");
INSERT INTO pesopcb_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","زمین به اندازۀ کافی برای هر دوی آنها نبود، زیرا اموال و گله‌های زیادی به دست آورده بودند. ");
INSERT INTO pesopcb_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","پس عیسو (که همان ادوم است) در کوهستان سعیر ساکن شد. ");
INSERT INTO pesopcb_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","این است تاریخچۀ نسل عیسو، پدر ادومیان، که در کوهستان سعیر زندگی می‌کرد. ");
INSERT INTO pesopcb_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","این است نامهای پسران عیسو: الیفاز پسر عاده همسر عیسو؛ رعوئیل پسر بسمه همسر عیسو. ");
INSERT INTO pesopcb_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","پسران الیفاز: تیمان، اومار، صفوا، جعتام و قناز بودند. ");
INSERT INTO pesopcb_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","الیفاز، پسر عیسو، مُتعه‌ای به نام تمناع داشت که عمالیق را برای الیفاز به دنیا آورد. اینها هستند نوه‌های عاده، همسر عیسو. ");
INSERT INTO pesopcb_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","پسران رعوئیل نحت، زارح، شمه و مزه بودند. اینها هستند نوه‌های بسمه همسر عیسو. ");
INSERT INTO pesopcb_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","عیسو از اهولیبامه، دختر عنا و نوهٔ صبعون نیز پسران داشت به نامهای یعوش، یعلام و قورح. ");
INSERT INTO pesopcb_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","اینها هستند سران طایفه‌های نسل عیسو: نسل الیفاز پسر ارشد عیسو که از سران طایفه‌ها بودند: تیمان، اومار، صفوا، قناز، ");
INSERT INTO pesopcb_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","قورح، جعتام و عمالیق. قبایل نامبرده فرزندان الیفاز پسر ارشد عیسو و همسرش عاده بودند. ");
INSERT INTO pesopcb_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","سران این طایفه‌ها فرزندان رعوئیل پسر عیسو از همسرش بسمه بودند: نحت، زارح، شمه و مزه. ");
INSERT INTO pesopcb_vpl VALUES ("GN36_18‏","002_36_18‏","GEN","36","18‏","19","اینها هستند پسران اهولیبامه همسر عیسو که از سران طایفه‌ها بودند: یعوش، یعلام و قورح. اینها سران طایفه‌های اهولیبامه همسر عیسو بودند که دختر عَنا بود. ");
INSERT INTO pesopcb_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","این است نامهای طایفه‌هایی که از نسل سعیر حوری بودند. آنها در سرزمین ادوم زندگی می‌کردند: لوطان، شوبال، صبعون، عنه، ");
INSERT INTO pesopcb_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","دیشون، ایصر، دیشان. اینها هستند نسل سعیر که از سران طایفه‌های حوری در سرزمین ادوم بودند. ");
INSERT INTO pesopcb_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","حوری و هومام از نسل لوطان بودند. لوطان خواهری داشت به نام تمناع. ");
INSERT INTO pesopcb_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","اینها پسران شوبال بودند: علوان، مناحت، عیبال، شفو و اونام. ");
INSERT INTO pesopcb_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","پسران صبعون ایّه و عنا بودند. (عنا همان پسری بود که موقع چرانیدن الاغهای پدرش چشمه‌های آب گرم را در صحرا یافت.) ");
INSERT INTO pesopcb_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","فرزندان عنا دیشون و اهولیبامه بودند. ");
INSERT INTO pesopcb_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","پسران دیشون حمدان، اشبان، یتران و کران بودند. ");
INSERT INTO pesopcb_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","پسران ایصر بلهان، زعوان و عقان بودند. ");
INSERT INTO pesopcb_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","پسران دیشان عوص و اران بودند. ");
INSERT INTO pesopcb_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","پس اینها بودند سران طایفه‌های حوری: لوطان، شوبال، صبعون، عنا، ");
INSERT INTO pesopcb_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","دیشون، ایصر و دیشان. طایفه‌های حوری برحسب سران طایفه‌هایشان که در سرزمین سعیر زندگی می‌کردند نامیده شدند. ");
INSERT INTO pesopcb_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","اینها هستند پادشاهانی که در سرزمین ادوم سلطنت می‌کردند، قبل از آنکه پادشاهی بر بنی‌اسرائیل سلطنت کند: ");
INSERT INTO pesopcb_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","بالع، پسر بعور اهل دینهابه که در ادوم سلطنت می‌کرد. ");
INSERT INTO pesopcb_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","پس از مرگ بالع، یوباب، پسر زارح از شهر بصره به جای او پادشاه شد. ");
INSERT INTO pesopcb_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","پس از مرگ یوباب، حوشام، از سرزمین تیمانی‌ها به جای او پادشاه شد. ");
INSERT INTO pesopcb_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","پس از مرگ حوشام، هَدَد، پسر بِداد از شهر عَویت به جای او پادشاه شد. او همان بود که لشکر مدیانی‌ها را در سرزمین موآب شکست داد. ");
INSERT INTO pesopcb_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","پس از مرگ هدد، سمله از شهر مسریقه به جای او پادشاه شد. ");
INSERT INTO pesopcb_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","پس از مرگ سمله، شائول از شهر رحوبوت که در کنار رودخانه‌ای واقع بود، به جای او پادشاه شد. ");
INSERT INTO pesopcb_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","پس از مرگ شائول، بعل حانان، پسر عکبور به جای او پادشاه شد. ");
INSERT INTO pesopcb_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","پس از مرگ بعل حانان، هدد از شهر فاعو به جای او پادشاه شد. همسر هدد مهیطب‌ئیل دختر مطرد و نوهٔ میذهب بود. ");
INSERT INTO pesopcb_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","اینها هستند سران طایفه‌های نسل عیسو که در جاهایی زندگی می‌کردند که به نام خودشان بود: تمناع، علوه، یتیت، ");
INSERT INTO pesopcb_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","اهولیبامه، ایله، فینون، ");
INSERT INTO pesopcb_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","قناز، تیمان، مبصار، ");
INSERT INTO pesopcb_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","مجدی‌ئیل و عیرام. همهٔ اینها ادومی و از نسل عیسو بودند و هر یک نام خود را بر ناحیه‌ای که در آن ساکن بودند نهادند. ");
INSERT INTO pesopcb_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","یعقوب بار دیگر در کنعان یعنی سرزمینی که پدرش در آن اقامت کرده بود، ساکن شد. ");
INSERT INTO pesopcb_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","این است تاریخچۀ نسل یعقوب: وقتی یوسف هفده ساله بود، به برادران ناتنی خود که فرزندان بلهه و زلفه کنیزان پدرش بودند، در چرانیدن گوسفندان پدرش کمک می‌کرد. یوسف کارهای ناپسندی را که از آنان سر می‌زد به پدرش خبر می‌داد. ");
INSERT INTO pesopcb_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","یعقوب یوسف را بیش از سایر پسرانش دوست می‌داشت، زیرا یوسف در سالهای آخر عمرش به دنیا آمده بود، پس جامه‌ای رنگارنگ به یوسف داد. ");
INSERT INTO pesopcb_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","برادرانش متوجه شدند که پدرشان او را بیشتر از آنها دوست می‌دارد؛ در نتیجه آنقدر از یوسف متنفر شدند که نمی‌توانستند با ملایمت با او سخن بگویند. ");
INSERT INTO pesopcb_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","یک شب یوسف خوابی دید و آن را برای برادرانش شرح داد. این موضوع باعث شد کینهٔ آنها نسبت به یوسف بیشتر شود. ");
INSERT INTO pesopcb_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","او به ایشان گفت: «گوش کنید تا خوابی را که دیده‌ام برای شما تعریف کنم. ");
INSERT INTO pesopcb_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","در خواب دیدم که ما در مزرعه بافه‌ها را می‌بستیم. ناگاه بافهٔ من بر پا شد و ایستاد و بافه‌های شما دور بافهٔ من جمع شدند و به آن تعظیم کردند.» ");
INSERT INTO pesopcb_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","برادرانش به وی گفتند: «آیا می‌خواهی پادشاه شوی و بر ما سلطنت کنی!» پس خواب و سخنان یوسف بر کینۀ برادران او افزود. ");
INSERT INTO pesopcb_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","یوسف بار دیگر خوابی دید و آن را برای برادرانش چنین تعریف کرد: «خواب دیدم که آفتاب و ماه و یازده ستاره به من تعظیم می‌کردند.» ");
INSERT INTO pesopcb_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","این بار خوابش را برای پدرش هم تعریف کرد؛ ولی پدرش او را سرزنش نموده، گفت: «این چه خوابی است که دیده‌ای؟ آیا به راستی من و مادرت و برادرانت آمده، به تو تعظیم خواهیم کرد؟» ");
INSERT INTO pesopcb_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","برادرانش به او حسادت می‌کردند، ولی پدرش دربارۀ خوابی که یوسف دیده بود، می‌اندیشید. ");
INSERT INTO pesopcb_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","یک روز که برادران یوسف گله‌های پدرشان را برای چرانیدن به شکیم برده بودند ");
INSERT INTO pesopcb_vpl VALUES ("GN37_13‏","002_37_13‏","GEN","37","13‏","14","یعقوب به یوسف گفت: «برادرانت در شکیم مشغول چرانیدن گله‌ها هستند. برو و ببین اوضاع چگونه است؛ آنگاه برگرد و به من خبر بده.» یوسف اطاعت کرد و از درۀ حبرون به شکیم رفت. ");
INSERT INTO pesopcb_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","در آنجا شخصی به او برخورد و دید که وی در صحرا سرگردان است. او از یوسف پرسید: «در جستجوی چه هستی؟» ");
INSERT INTO pesopcb_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","یوسف گفت: «در جستجوی برادران خود و گله‌هایشان می‌باشم. آیا تو آنها را دیده‌ای؟» ");
INSERT INTO pesopcb_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","آن مرد پاسخ داد: «بله، من آنها را دیدم که از اینجا رفتند و شنیدم که می‌گفتند به دوتان می‌روند.» پس یوسف به دوتان رفت و ایشان را در آنجا یافت. ");
INSERT INTO pesopcb_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","همین که برادرانش از دور دیدند یوسف می‌آید، تصمیم گرفتند او را بکشند. ");
INSERT INTO pesopcb_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","آنها به یکدیگر گفتند: «خواب بیننده بزرگ می‌آید! ");
INSERT INTO pesopcb_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","بیایید او را بکشیم و در یکی از این چاهها بیندازیم و به پدرمان بگوییم جانور درنده‌ای او را خورده است. آن وقت ببینیم خوابهایش چه می‌شوند.» ");
INSERT INTO pesopcb_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","اما رئوبین چون این را شنید، به امید این که جان او را نجات بدهد، گفت: «او را نکشیم. ");
INSERT INTO pesopcb_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","خون او را نریزیم، بلکه وی را در این گودال بیندازیم. با این کار بدون این که دستمان را به خونش آلوده کنیم، خودش خواهد مرد.» (رئوبین در نظر داشت بعداً او را از چاه بیرون آورد و نزد پدرش بازگرداند.) ");
INSERT INTO pesopcb_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","به محض این که یوسف نزد برادرانش رسید، آنها بر او هجوم برده، جامهٔ رنگارنگی را که پدرشان به او داده بود، از تنش بیرون آوردند. ");
INSERT INTO pesopcb_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","سپس او را در چاهی که آب نداشت انداختند ");
INSERT INTO pesopcb_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","و خودشان مشغول خوردن غذا شدند. ناگاه از دور کاروان شتری را دیدند که به طرف ایشان می‌آید. آنها تاجران اسماعیلی بودند که کتیرا و ادویه از جلعاد به مصر می‌بردند. ");
INSERT INTO pesopcb_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","یهودا به برادرانش گفت: «از کشتن برادرمان و مخفی کردن این جنایت چه سودی عاید ما می‌شود؟ ");
INSERT INTO pesopcb_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","بیایید او را به این تاجران اسماعیلی بفروشیم. به هر حال او برادر ماست؛ نباید به دست ما کشته شود.» برادرانش با پیشنهاد او موافقت کردند. ");
INSERT INTO pesopcb_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","وقتی تاجران رسیدند، برادران یوسف او را از چاه بیرون آورده، به بیست سکۀ نقره به آنها فروختند. آنها هم یوسف را با خود به مصر بردند. ");
INSERT INTO pesopcb_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","رئوبین که هنگام آمدن کاروان در آنجا نبود، وقتی به سر چاه آمد و دید که یوسف در چاه نیست، از شدت ناراحتی جامهٔ خود را چاک زد. ");
INSERT INTO pesopcb_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","آنگاه نزد برادرانش آمده، به آنها گفت: «یوسف را برده‌اند! حالا من چه کنم؟» ");
INSERT INTO pesopcb_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","پس برادرانش بزی را سر بریده جامه زیبای یوسف را به خون بز آغشته نمودند. ");
INSERT INTO pesopcb_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","سپس جامهٔ آغشته به خون را نزد یعقوب برده، گفتند: «آیا این همان ردای پسرت نیست؟ آن را در صحرا یافته‌ایم.» ");
INSERT INTO pesopcb_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","یعقوب آن را شناخت و فریاد زد: «آری، این ردای پسرم است. به‌یقین جانور درنده‌ای او را دریده است.» ");
INSERT INTO pesopcb_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","آنگاه یعقوب لباس خود را پاره کرده، پلاس پوشید و روزهای زیادی برای پسرش ماتم گرفت. ");
INSERT INTO pesopcb_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","تمامی اهل خانواده‌اش سعی کردند وی را دلداری دهند، ولی سودی نداشت. او می‌گفت: «سوگوار پیش پسرم به قبر خواهم رفت.» این را می‌گفت و می‌گریست. ");
INSERT INTO pesopcb_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","اما تاجران مدیانی پس از این که به مصر رسیدند، یوسف را به فوطیفار، یکی از افسران فرعون فروختند. فوطیفار رئیس نگهبانان دربار بود. ");
INSERT INTO pesopcb_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","در همان روزها بود که یهودا خانهٔ پدر خود را ترک نموده، به عدولام رفت و نزد شخصی به نام حیره ساکن شد. ");
INSERT INTO pesopcb_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","در آنجا او دختر مردی کنعانی به نام شوعا را به زنی گرفت ");
INSERT INTO pesopcb_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","و از او صاحب پسری شد که او را عیر نامید. ");
INSERT INTO pesopcb_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","شوعا بار دیگر حامله شد و پسری زایید و او را اونان نام نهاد. ");
INSERT INTO pesopcb_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","وقتی آنها در کزیب بودند، زن یهودا پسر سوم خود را به دنیا آورد و او را شیله نامید. ");
INSERT INTO pesopcb_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","وقتی عیر، پسر ارشد یهودا، بزرگ شد پدرش دختری را به نام تامار برای او به زنی گرفت. ");
INSERT INTO pesopcb_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","اما چون عیر شخص شروری بود، خداوند او را کُشت. ");
INSERT INTO pesopcb_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","آنگاه یهودا به اونان برادر عیر گفت: «مطابق رسم ما، تو باید با زن برادرت تامار ازدواج کنی تا نسل برادرت از بین نرود.» ");
INSERT INTO pesopcb_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","اونان با تامار ازدواج کرد، اما چون نمی‌خواست فرزندش از آنِ کس دیگری باشد، هر وقت با او نزدیکی می‌کرد، جلوگیری نموده، نمی‌گذاشت تامار بچه‌ای داشته باشد که از آنِ برادر مرده‌اش شود. ");
INSERT INTO pesopcb_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","این کار اونان در نظر خداوند ناپسند آمد و خدا او را نیز کشت. ");
INSERT INTO pesopcb_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","یهودا به عروس خود تامار گفت: «به خانهٔ پدرت برو و بیوه بمان تا وقتی که پسر کوچکم شیله بزرگ شود. آن وقت می‌توانی با او ازدواج کنی.» (ولی یهودا قلباً راضی به این کار نبود، چون می‌ترسید شیله نیز مثل دو برادر دیگرش بمیرد.) پس تامار به خانۀ پدرش رفت. ");
INSERT INTO pesopcb_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","پس از مدتی، زن یهودا مُرد. وقتی که روزهای سوگواری سپری شد، یهودا با دوستش حیرهٔ عدولامی برای نظارت بر پشم‌چینی گوسفندان به تمنه رفت. ");
INSERT INTO pesopcb_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","به تامار خبر دادند که پدر شوهرش برای چیدنِ پشمِ گوسفندان به طرف تمنه حرکت کرده است. ");
INSERT INTO pesopcb_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","تامار لباس بیوگی خود را از تن درآورد و برای این که شناخته نشود چادری بر سر انداخته، دم دروازهٔ عینایم سر راه تمنه نشست، زیرا او دید که هر چند شیله بزرگ شده ولی او را به عقد وی در نیاورده‌اند. ");
INSERT INTO pesopcb_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","یهودا او را دید، ولی چون او روی خود را پوشانیده بود، او را نشناخت و پنداشت زن بدکاره‌ای است. ");
INSERT INTO pesopcb_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","پس به کنار جاده به طرف او رفته، به او پیشنهاد کرد که با وی همبستر شود، غافل از این که عروس خودش می‌باشد. تامار به او گفت: «چقدر می‌خواهی به من بدهی؟» ");
INSERT INTO pesopcb_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","یهودا گفت: «بزغاله‌ای از گله‌ام برایت خواهم فرستاد.» زن گفت: «برای این که مطمئن شوم که بزغاله را می‌فرستی باید چیزی نزد من گرو بگذاری.» ");
INSERT INTO pesopcb_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","یهودا گفت: «چه چیزی را گرو بگذارم؟» زن جواب داد: «مُهر و بند آن و عصایت را.» پس یهودا آنها را به او داد و با وی همبستر شد و در نتیجه تامار آبستن گردید. ");
INSERT INTO pesopcb_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","پس از این واقعه، تامار به خانه بازگشت و روبند خود را برداشت و دوباره لباس بیوِگی خود را پوشید. ");
INSERT INTO pesopcb_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","یهودا بزغاله را به دوستش حیرهٔ عدولامی سپرد تا آن را برای آن زن ببرد و اشیاء گرویی را پس بگیرد، اما حیره آن زن را نیافت. ");
INSERT INTO pesopcb_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","پس، از مردم آنجا پرسید: «آن روسپی بتکده که دمِ دروازه، سر راه نشسته بود کجاست؟» به او جواب دادند: «ما هرگز چنین زنی در اینجا ندیده‌ایم.» ");
INSERT INTO pesopcb_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","حیره نزد یهودا بازگشت و به او گفت: «او را نیافتم و مردمان آنجا هم می‌گویند چنین زنی را در آنجا ندیده‌اند.» ");
INSERT INTO pesopcb_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","یهودا گفت: «بگذار آن اشیاء مال او باشد، مبادا رسوا شویم. به هر حال من بزغاله را برای او فرستادم، ولی تو نتوانستی او را پیدا کنی.» ");
INSERT INTO pesopcb_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","حدود سه ماه بعد از این واقعه، به یهودا خبر دادند که عروسش تامار زنا کرده و حامله است. یهودا گفت: «او را بیرون آورید و بسوزانید.» ");
INSERT INTO pesopcb_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","در حالی که تامار را بیرون می‌آوردند تا او را بکشند این پیغام را برای پدر شوهرش فرستاد: «مردی که صاحب این مُهر و بند آن و عصا می‌باشد، پدر بچهٔ من است، آیا او را می‌شناسی؟» ");
INSERT INTO pesopcb_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","یهودا مُهر و عصا را شناخت و گفت: «او تقصیری ندارد، زیرا من به قول خود وفا نکردم و او را برای پسرم شیله نگرفتم.» یهودا دیگر با او همبستر نشد. ");
INSERT INTO pesopcb_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","چون وقت وضع حمل تامار رسید، دوقلو زایید. ");
INSERT INTO pesopcb_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","در موقع زایمان، یکی از پسرها دستش را بیرون آورد و قابله نخ قرمزی به مچ دست او بست و گفت: «این اول بیرون آمد.» ");
INSERT INTO pesopcb_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","اما او دست خود را عقب کشید و پسر دیگر، اول به دنیا آمد. قابله گفت: «چگونه بیرون آمدی؟» پس او را فارص نامیدند. ");
INSERT INTO pesopcb_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","اندکی بعد، پسری که نخ قرمز به دستش بسته شده بود متولد شد و او را زارح نامیدند. ");
INSERT INTO pesopcb_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","و اما یوسف به دست تاجران اسماعیلی به مصر برده شد. فوطیفار که یکی از افسران فرعون و رئیس نگهبانان دربار بود، او را از ایشان خرید. ");
INSERT INTO pesopcb_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","خداوند با یوسف بود و او را در خانهٔ اربابش بسیار برکت داد، به طوری که آنچه یوسف می‌کرد موفقیت‌آمیز بود. ");
INSERT INTO pesopcb_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","فوطیفار متوجۀ این موضوع شده و دریافته بود که خداوند با یوسف است و در هر آنچه می‌کند، خداوند او را کامیاب می‌سازد. ");
INSERT INTO pesopcb_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","از این رو یوسف مورد لطف اربابش قرار گرفت. طولی نکشید که فوطیفار او را ناظر خانه و کلیه امور تجاری خود ساخت. ");
INSERT INTO pesopcb_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","خداوند فوطیفار را به خاطر یوسف برکت داد به‌طوری که تمام امور خانهٔ او به خوبی پیش می‌رفت و محصولاتش فراوان و گله‌هایش زیاد می‌شد. ");
INSERT INTO pesopcb_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","پس فوطیفار مسئولیت ادارهٔ تمام اموال خود را به دست یوسف سپرد و دیگر او برای هیچ چیز فکر نمی‌کرد جز این که چه غذایی بخورد. یوسف جوانی خوش‌اندام و خوش‌قیافه بود. ");
INSERT INTO pesopcb_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","پس از مدتی، نظر همسر فوطیفار به یوسف جلب شد و از او خواست تا با وی همبستر شود. ");
INSERT INTO pesopcb_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","اما یوسف نپذیرفت و گفت: «اربابم آنقدر به من اعتماد دارد که هر آنچه در این خانه است به من سپرده ");
INSERT INTO pesopcb_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","و تمام اختیار این خانه را به من داده است. او چیزی را از من مضایقه نکرده جز تو را که همسر او هستی. پس چگونه مرتکب چنین عمل زشتی بشوم؟ این عمل، گناهی است بزرگ نسبت به خدا.» ");
INSERT INTO pesopcb_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","اما او دست بردار نبود و هر روز از یوسف می‌خواست که با وی همبستر شود. ولی یوسف به سخنان فریبندۀ او گوش نمی‌داد و تا آنجا که امکان داشت از وی دوری می‌کرد. ");
INSERT INTO pesopcb_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","روزی یوسف طبق معمول به کارهای منزل رسیدگی می‌کرد. آن روز کسی دیگر هم در خانه نبود. ");
INSERT INTO pesopcb_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","پس آن زن چنگ به لباس او انداخته، گفت: «با من همبستر شو!» ولی یوسف از چنگ او گریخت و از منزل خارج شد، اما لباسش در دست وی باقی ماند. ");
INSERT INTO pesopcb_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","آن زن چون وضع را چنین دید، ");
INSERT INTO pesopcb_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","با صدای بلند فریاد زده، خدمتکاران را به کمک طلبید و به آنها گفت: «شوهرم این غلام عبرانی را به خانه آورده، حالا او ما را رسوا می‌سازد! او به اتاقم آمد تا به من تجاوز کند، ولی فریاد زدم. ");
INSERT INTO pesopcb_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","وقتی شنید که فریاد می‌زنم، لباسش را جا گذاشت و فرار کرد.» ");
INSERT INTO pesopcb_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","پس آن زن لباس او را نزد خود نگاه داشت و وقتی شوهرش به منزل آمد ");
INSERT INTO pesopcb_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","داستانی را که ساخته بود، برایش چنین تعریف کرد: «آن غلامِ عبرانی که به خانه آورده‌ای می‌خواست به من تجاوز کند، ");
INSERT INTO pesopcb_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","ولی من با داد و فریاد، خود را از دستش نجات دادم. او گریخت، ولی لباسش را جا گذاشت.» ");
INSERT INTO pesopcb_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","فوطیفار چون سخنان زنش را شنید، بسیار خشمگین شد ");
INSERT INTO pesopcb_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","و یوسف را به زندانی که سایر زندانیان پادشاه در آن در زنجیر بودند، انداخت. ");
INSERT INTO pesopcb_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","اما در آنجا هم خداوند با یوسف بود و او را برکت می‌داد و وی را مورد لطف رئیس زندان قرار داد. ");
INSERT INTO pesopcb_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","طولی نکشید که رئیس زندان، یوسف را مسئول ادارهٔ زندان نمود، به‌طوری که همهٔ زندانیان زیر نظر او بودند و او بر همۀ امور نظارت می‌کرد. ");
INSERT INTO pesopcb_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","رئیس زندان در مورد کارهایی که به یوسف سپرده بود نگرانی نداشت، زیرا خداوند با یوسف بود و او را در انجام کارهایش موفق می‌ساخت. ");
INSERT INTO pesopcb_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","مدتی پس از زندانی شدن یوسف، رئیس ساقیان و رئیس نانوایان فرعون به سَروَر خود، پادشاه مصر، خیانت ورزیدند. ");
INSERT INTO pesopcb_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","فرعون بر این دو خدمتگزار خود خشمگین شده، ");
INSERT INTO pesopcb_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","آنها را به زندان رئیس نگهبانان دربار که یوسف در آنجا بود، انداخت. ");
INSERT INTO pesopcb_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","آنها مدت طولانی در زندان ماندند و رئیس نگهبانان یوسف را به خدمت آنها گماشت. ");
INSERT INTO pesopcb_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","یک شب هر دو آنها خواب دیدند. ");
INSERT INTO pesopcb_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","صبح روز بعد، یوسف دید که آنها ناراحت هستند. ");
INSERT INTO pesopcb_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","پس، از آنها که همراه او در زندان سَروَرش بودند، پرسید: «چرا امروز غمگین هستید؟» ");
INSERT INTO pesopcb_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","گفتند: «دیشب ما هر دو خواب دیدیم و کسی نیست که آن را تعبیر کند.» یوسف گفت: «تعبیر کردن خوابها کار خداست. به من بگویید چه خوابهایی دیده‌اید؟» ");
INSERT INTO pesopcb_vpl VALUES ("GN40_9‏","002_40_9‏","GEN","40","9‏","10","اول رئیس ساقیان خوابی را که دیده بود، برای یوسف تعریف کرد: «دیشب در خواب درخت انگوری را دیدم که سه شاخه داشت. ناگاه شاخه‌ها شکفتند و خوشه‌های زیادی انگور رسیده دادند. ");
INSERT INTO pesopcb_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","من جام شراب فرعون را در دست داشتم، پس خوشه‌های انگور را چیده، در جام فشردم و به او دادم تا بنوشد.» ");
INSERT INTO pesopcb_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","یوسف گفت: «تعبیر خواب تو این است: منظور از سه شاخه، سه روز است. ");
INSERT INTO pesopcb_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","تا سه روز دیگر فرعون تو را از زندان آزاد کرده، دوباره ساقی خود خواهد ساخت. ");
INSERT INTO pesopcb_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","پس خواهش می‌کنم وقتی دوباره مورد لطف او قرار گرفتی، مرا به یاد آور و سرگذشتم را برای فرعون شرح بده و از او خواهش کن تا مرا از این زندان آزاد کند. ");
INSERT INTO pesopcb_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","زیرا مرا که عبرانی هستم از وطنم دزدیده، به اینجا آورده‌اند. حالا هم بدون آنکه مرتکب جرمی شده باشم، مرا در زندان انداخته‌اند.» ");
INSERT INTO pesopcb_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","وقتی رئیس نانوایان دید که تعبیر خواب دوستش خیر بود، او نیز خواب خود را برای یوسف بیان کرده، گفت: «در خواب دیدم که سه سبد پر از نان روی سر خود دارم. ");
INSERT INTO pesopcb_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","در سبد بالایی چندین نوع نان برای فرعون گذاشته بودم، اما پرندگان آمده آنها را خوردند.» ");
INSERT INTO pesopcb_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","یوسف به او گفت: «تعبیر خواب این است: سه سبد، سه روز است. ");
INSERT INTO pesopcb_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","سه روز دیگر فرعون سرت را از تنت جدا کرده، بدنت را به دار می‌آویزد و پرندگان آمده گوشت بدنت را خواهند خورد.» ");
INSERT INTO pesopcb_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","سه روز بعد، جشن تولد فرعون بود و به همین مناسبت ضیافتی برای مقامات مملکتی ترتیب داد. او فرستاد تا رئیس ساقیان و رئیس نانوایان را از زندان به حضورش آورند. ");
INSERT INTO pesopcb_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","سپس رئیس ساقیان را به کار سابقش گمارد، ");
INSERT INTO pesopcb_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","ولی رئیس نانوایان را به دار آویخت، همان‌طور که یوسف گفته بود. ");
INSERT INTO pesopcb_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","اما رئیس ساقیان یوسف را به یاد نیاورد. ");
INSERT INTO pesopcb_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","دو سال بعد از این واقعه، شبی فرعون خواب دید که کنار رود نیل ایستاده است. ");
INSERT INTO pesopcb_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","ناگاه هفت گاو چاق و فربه از رودخانه بیرون آمده، شروع به چریدن کردند. ");
INSERT INTO pesopcb_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","سپس هفت گاو دیگر از رودخانه بیرون آمدند و کنار آن هفت گاو ایستادند، ولی اینها بسیار لاغر و استخوانی بودند. ");
INSERT INTO pesopcb_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","سپس گاوهای لاغر، گاوهای چاق را بلعیدند. آنگاه فرعون از خواب پرید. ");
INSERT INTO pesopcb_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","او باز خوابش برد و خوابی دیگر دید. این بار دید که هفت خوشهٔ گندم روی یک ساقه قرار دارند که همگی پُر از دانه‌های گندم رسیده هستند. ");
INSERT INTO pesopcb_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","سپس هفت خوشهٔ نازک دیگر که باد شرقی آنها را خشکانیده بود، ظاهر شدند. ");
INSERT INTO pesopcb_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","خوشه‌های نازک و خشکیده، خوشه‌های پُر و رسیده را بلعیدند. آنگاه فرعون از خواب بیدار شد و فهمید که همه را در خواب دیده است. ");
INSERT INTO pesopcb_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","صبح روز بعد، فرعون که فکرش مغشوش بود، تمام جادوگران و دانشمندان مصر را احضار نمود و خوابهایش را برای ایشان تعریف کرد، ولی کسی قادر به تعبیر خوابهای او نبود. ");
INSERT INTO pesopcb_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","آنگاه رئیس ساقیان پیش آمده، به فرعون گفت: «الان یادم آمد که چه خطای بزرگی مرتکب شده‌ام. ");
INSERT INTO pesopcb_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","مدتی پیش، وقتی که بر غلامان خود غضب نمودی و مرا با رئیس نانوایان به زندانِ رئیس نگهبانانِ دربار انداختی، ");
INSERT INTO pesopcb_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","هر دو ما در یک شب خواب دیدیم و خواب هر یک از ما تعبیر خاص خود داشت. ");
INSERT INTO pesopcb_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","ما خوابهایمان را برای جوانی عبرانی که غلامِ رئیس نگهبانان دربار و با ما همزندان بود، تعریف کردیم و او خوابهایمان را برای ما تعبیر کرد؛ ");
INSERT INTO pesopcb_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","و هر آنچه که گفته بود اتفاق افتاد. من به خدمت خود برگشتم و رئیس نانوایان به دار آویخته شد.» ");
INSERT INTO pesopcb_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","آنگاه فرعون فرستاد تا یوسف را بیاورند، پس با عجله وی را از زندان بیرون آوردند. او سر و صورتش را اصلاح نمود و لباسهایش را عوض کرد و به حضور فرعون رفت. ");
INSERT INTO pesopcb_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","فرعون به او گفت: «من دیشب خوابی دیدم و کسی نمی‌تواند آن را برای من تعبیر کند. شنیده‌ام که تو می‌توانی خوابها را تعبیر کنی.» ");
INSERT INTO pesopcb_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","یوسف گفت: «من خودم قادر نیستم خوابها را تعبیر کنم، اما خدا معنی خوابت را به تو خواهد گفت.» ");
INSERT INTO pesopcb_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","پس فرعون خوابش را برای یوسف اینطور تعریف کرد: «در خواب دیدم کنار رود نیل ایستاده‌ام. ");
INSERT INTO pesopcb_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","ناگهان هفت گاو چاق و فربه از رودخانه بیرون آمده، مشغول چریدن شدند. ");
INSERT INTO pesopcb_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","سپس هفت گاو دیگر را دیدم که از رودخانه بیرون آمدند، ولی این هفت گاو بسیار لاغر و زشت و استخوانی بودند. هرگز در تمام سرزمین مصر، گاوهایی به این زشتی ندیده بودم. ");
INSERT INTO pesopcb_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","این گاوهای لاغر آن هفت گاو چاقی را که اول بیرون آمده بودند، بلعیدند. ");
INSERT INTO pesopcb_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","پس از بلعیدن، هنوز هم گاوها لاغر و استخوانی بودند. در این موقع از خواب بیدار شدم. ");
INSERT INTO pesopcb_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","کمی بعد باز به خواب رفتم. این بار در خواب هفت خوشهٔ گندم روی یک ساقه دیدم که همگی پر از دانه‌های رسیده بودند. ");
INSERT INTO pesopcb_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","اندکی بعد، هفت خوشه که باد شرقی آنها را خشکانیده بود، نمایان شدند. ");
INSERT INTO pesopcb_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","ناگهان خوشه‌های نازک خوشه‌های پُر و رسیده را خوردند. همهٔ اینها را برای جادوگران خود تعریف کردم، ولی هیچ‌کدام از آنها نتوانستند تعبیر آنها را برای من بگویند.» ");
INSERT INTO pesopcb_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","یوسف به فرعون گفت: «معنی هر دو خواب یکی است. خدا تو را از آنچه که در سرزمین مصر انجام خواهد داد، آگاه ساخته است. ");
INSERT INTO pesopcb_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","هفت گاو چاق و فربه و هفت خوشهٔ پُر و رسیده که اول ظاهر شدند، نشانهٔ هفت سالِ فراوانی است. ");
INSERT INTO pesopcb_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","هفت گاو لاغر و استخوانی و هفت خوشهٔ نازک و پژمرده، نشانهٔ هفت سال قحطی شدید است که به دنبال هفت سال فراوانی خواهد آمد. ");
INSERT INTO pesopcb_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","همان‌طور که به فرعون گفتم، خدا آنچه را که می‌خواهد به‌زودی در این سرزمین انجام دهد، به فرعون آشکار ساخته است. ");
INSERT INTO pesopcb_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","طی هفت سال آینده در سراسر سرزمین مصر محصول، بسیار فراوان خواهد بود. ");
INSERT INTO pesopcb_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","اما پس از آن، هفت سال قحطی پدید خواهد آمد، و همۀ آن فراوانی در سرزمین مصر فراموش خواهد شد و قحطی این سرزمین را تباه خواهد کرد. ");
INSERT INTO pesopcb_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","این قحطی چنان سخت خواهد بود که سالهای فراوانی از خاطره‌ها محو خواهد شد. ");
INSERT INTO pesopcb_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","خوابهای دوگانه تو نشانهٔ این است که آنچه برایت شرح دادم، به‌زودی به وقوع خواهد پیوست، زیرا از جانب خدا مقرر شده است. ");
INSERT INTO pesopcb_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","من پیشنهاد می‌کنم که فرعون مردی دانا و حکیم بیابد و او را بر ادارهٔ امور کشاورزی این سرزمین بگمارد. ");
INSERT INTO pesopcb_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","سپس فرعون باید مأمورانی مقرر کند تا در هفت سال فراوانی، یک پنجم محصولات مصر را ذخیره کنند. ");
INSERT INTO pesopcb_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","و همۀ آذوقۀ این سالهای خوب را که در پیش است، جمع کرده، به انبارهای سلطنتی ببرند. ");
INSERT INTO pesopcb_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","بدین ترتیب، در هفت سال قحطی بعد از آن، با کمبود خوراک مواجه نخواهید شد. در غیر این صورت، سرزمین شما در اثر قحطی از بین خواهد رفت.» ");
INSERT INTO pesopcb_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","فرعون و همۀ افرادش پیشنهاد یوسف را پسندیدند. ");
INSERT INTO pesopcb_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","سپس فرعون گفت: «چه کسی بهتر از یوسف می‌تواند از عهده این کار برآید، مردی که روح خدا در اوست.» ");
INSERT INTO pesopcb_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","سپس فرعون رو به یوسف نموده، گفت: «چون خدا تعبیر خوابها را به تو آشکار کرده است، پس داناترین و حکیم‌ترین شخص تو هستی. ");
INSERT INTO pesopcb_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","هم اکنون تو را بر کاخ خود می‌گمارم، و تمامی قوم من مطیع فرمان تو خواهند بود. فقط بر تخت سلطنت از تو بالاتر خواهم بود.» ");
INSERT INTO pesopcb_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","سپس فرعون به یوسف گفت: «تو را بر سراسر سرزمین مصر می‌گمارم.» ");
INSERT INTO pesopcb_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","آنگاه فرعون انگشتری سلطنتی خود را از دستش بیرون آورده، آن را به انگشت یوسف کرد و لباس فاخری بر او پوشانیده، زنجیر طلا به گردنش آویخت، ");
INSERT INTO pesopcb_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","و او را سوار دومین ارابهٔ سلطنتی خود کرد. او هر جا می‌رفت جلوی او جار می‌زدند: «زانو بزنید!» بدین ترتیب یوسف بر تمامی امور مصر گماشته شد. ");
INSERT INTO pesopcb_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","فرعون به یوسف گفت: «من فرعون هستم، ولی بدون اجازۀ تو هیچ‌کس در سراسر سرزمین مصر حق ندارد حتی دست یا پای خود را دراز کند.» ");
INSERT INTO pesopcb_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","فرعون به یوسف، نام مصری صَفِنات فَعنیح را داد و اَسِنات دختر فوطی فارع، کاهن اون را به عقد وی درآورد. و یوسف در سراسر کشور مصر مشهور گردید. ");
INSERT INTO pesopcb_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","یوسف سی ساله بود که فرعون او را به خدمت گماشت. او دربار فرعون را ترک گفت تا به امور سراسر کشور رسیدگی کند. ");
INSERT INTO pesopcb_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","طی هفت سالِ فراوانی محصول، غله در همه جا بسیار فراوان بود. ");
INSERT INTO pesopcb_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","در این سالها یوسف محصولات مزارع را در شهرهای اطراف ذخیره نمود. ");
INSERT INTO pesopcb_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","یوسف غلۀ بسیار زیاد همچون ریگ دریا، ذخیره کرد، به طوری که حساب از دستش در رفت، زیرا که دیگر نمی‌شد آنها را حساب کرد. ");
INSERT INTO pesopcb_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","قبل از پدید آمدن قحطی، یوسف از همسرش اسنات، دختر فوطی فارع، کاهن اون صاحب دو پسر شد. ");
INSERT INTO pesopcb_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","یوسف پسر بزرگ خود را منسی نامید و گفت: «با تولد این پسر خدا به من کمک کرد تا تمامی خاطرهٔ تلخ جوانی و دوری از خانهٔ پدر را فراموش کنم.» ");
INSERT INTO pesopcb_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","او دومین پسر خود را اِفرایم نامید و گفت: «خدا مرا در سرزمینِ سختیهایم، پرثمر گردانیده است.» ");
INSERT INTO pesopcb_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","سرانجام هفت سالِ فراوانی به پایان رسید ");
INSERT INTO pesopcb_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","و همان‌طور که یوسف گفته بود، هفت سالِ قحطی شروع شد. در کشورهای همسایهٔ مصر قحطی بود، اما در انبارهای مصر غلهٔ فراوان یافت می‌شد. ");
INSERT INTO pesopcb_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","گرسنگی بر اثر کمبود غذا آغاز شد و مردمِ مصر برای طلب کمک نزد فرعون رفتند و فرعون نیز آنها را نزد یوسف فرستاده، گفت: «بروید و آنچه یوسف به شما می‌گوید انجام دهید.» ");
INSERT INTO pesopcb_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","پس در حالی که قحطی همه جا را فرا گرفته بود، یوسف انبارها را گشوده، غلهٔ مورد نیاز را به مصری‌ها می‌فروخت، زیرا قحطی در سرزمین مصر بسیار سخت بود. ");
INSERT INTO pesopcb_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","همچنین مردم از جاهای مختلف برای خرید غله نزد یوسف به مصر می‌آمدند، زیرا قحطی در سراسر زمین بسیار سخت بود. ");
INSERT INTO pesopcb_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","یعقوب چون شنید در مصر غله فراوان است، به پسرانش گفت: «چرا نشسته، به یکدیگر نگاه می‌کنید؟ ");
INSERT INTO pesopcb_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","شنیده‌ام در مصر غله فراوان است. قبل از این که همه از گرسنگی بمیریم، بروید و از آنجا غله بخرید.» ");
INSERT INTO pesopcb_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","بنابراین ده برادر یوسف برای خرید غله به مصر رفتند. ");
INSERT INTO pesopcb_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","ولی یعقوب، بنیامین برادر تنی یوسف را همراه آنها نفرستاد، چون می‌ترسید که او را هم از دست بدهد. ");
INSERT INTO pesopcb_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","پس پسران یعقوب هم با کسانی که برای خرید غله از سرزمینهای مختلف به مصر می‌آمدند وارد آنجا شدند، زیرا شدت قحطی در کنعان مثل همه جای دیگر بود. ");
INSERT INTO pesopcb_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","چون یوسف حاکم مصر و مسئول فروش غله بود، برادرانش نزد او رفته در برابرش به خاک افتادند. ");
INSERT INTO pesopcb_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","یوسف وقتی برادرانش را دید، فوری آنها را شناخت، ولی وانمود کرد که ایشان را نمی‌شناسد و با خشونت از آنها پرسید: «از کجا آمده‌اید؟» گفتند: «از سرزمین کنعان برای خرید غله آمده‌ایم.» ");
INSERT INTO pesopcb_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","هر چند یوسف برادرانش را شناخت، اما آنها او را نشناختند. ");
INSERT INTO pesopcb_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","در این لحظه یوسف خوابهایی را که مدتها پیش در خانهٔ پدرش دیده بود، به خاطر آورد. او به آنها گفت: «شما جاسوس هستید و برای بررسی سرزمین ما به اینجا آمده‌اید.» ");
INSERT INTO pesopcb_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","آنها گفتند: «ای سَروَر ما، چنین نیست. ما برای خرید غله آمده‌ایم. ");
INSERT INTO pesopcb_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","همهٔ ما برادریم. ما مردمی صادق هستیم و برای جاسوسی نیامده‌ایم.» ");
INSERT INTO pesopcb_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","یوسف گفت: «چرا، شما جاسوس هستید و آمده‌اید سرزمین ما را بررسی کنید.» ");
INSERT INTO pesopcb_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","آنها عرض کردند: «ای سَروَر، ما دوازده برادریم و پدرمان در سرزمین کنعان است. برادر کوچک ما نزد پدرمان است و یکی از برادران ما هم مرده است.» ");
INSERT INTO pesopcb_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","یوسف گفت: «از کجا معلوم که راست می‌گویید؟ ");
INSERT INTO pesopcb_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","فقط در صورتی درستی حرفهای شما ثابت می‌شود که برادر کوچکتان هم به اینجا بیاید و گرنه به حیات فرعون قسم که اجازه نخواهم داد از مصر خارج شوید. ");
INSERT INTO pesopcb_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","یکی از شما برود و برادرتان را بیاورد. بقیه را اینجا در زندان نگاه می‌دارم تا معلوم شود آنچه گفته‌اید راست است یا نه. اگر دروغ گفته باشید به جان فرعون سوگند که شما جاسوس هستید.» ");
INSERT INTO pesopcb_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","پس همهٔ آنها را به مدت سه روز به زندان انداخت. ");
INSERT INTO pesopcb_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","در روز سوم یوسف به ایشان گفت: «من مرد خداترسی هستم، پس آنچه به شما می‌گویم انجام دهید تا زنده بمانید. ");
INSERT INTO pesopcb_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","اگر شما واقعاً افراد صادقی هستید، از شما برادران یکی در زندان بماند و بقیه با غله‌ای که خریده‌اید نزد خانواده‌های گرسنه خود برگردید. ");
INSERT INTO pesopcb_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","ولی شما باید برادر کوچک خود را نزد من بیاورید. به این طریق به من ثابت خواهد شد که راست گفته‌اید و من شما را نخواهم کشت.» آنها این شرط را پذیرفتند. ");
INSERT INTO pesopcb_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","آنگاه برادران به یکدیگر گفتند: «همهٔ این ناراحتی‌ها به خاطر آن است که به برادر خود یوسف بدی کردیم و به التماس عاجزانهٔ او گوش ندادیم.» ");
INSERT INTO pesopcb_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","رئوبین به آنها گفت: «آیا من به شما نگفتم این کار را نکنید؟ ولی حرف مرا قبول نکردید. حالا باید تاوان گناهمان را پس بدهیم.» ");
INSERT INTO pesopcb_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","البته آنها نمی‌دانستند که یوسف سخنانشان را می‌فهمد، زیرا او توسط مترجم با ایشان صحبت می‌کرد. ");
INSERT INTO pesopcb_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","در این موقع یوسف از نزد آنها به جایی خلوت رفت و بگریست. سپس نزد آنها بازگشت و شمعون را از میان آنها انتخاب کرده، دستور داد در برابر چشمان برادرانش او را در بند نهند. ");
INSERT INTO pesopcb_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","آنگاه یوسف به خادمانش دستور داد تا کیسه‌های آنها را از غله پُر کنند، درضمن پولهایی را که برادرانش برای خرید غله پرداخته بودند، در داخل خورجینهایشان بگذارند و توشهٔ سفر به آنها بدهند. پس آنها چنین کردند ");
INSERT INTO pesopcb_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","و برادران یوسف غله را بار الاغهای خود نموده، روانهٔ سرزمین خویش شدند. ");
INSERT INTO pesopcb_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","هنگام غروب آفتاب، وقتی که برای استراحت توقف کردند، یکی از آنها خورجین خود را باز کرد تا به الاغها خوراک بدهد و دید پولی که برای خرید غله پرداخته بود، در دهانهٔ خورجین است. ");
INSERT INTO pesopcb_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","پس به برادرانش گفت: «ببینید! پولی را که داده‌ام در دهانۀ خورجینم گذاشته‌اند.» آنگاه از ترس لرزه بر اندام آنها افتاده، به یکدیگر گفتند: «این چه بلایی است که خدا بر سر ما آورده است؟» ");
INSERT INTO pesopcb_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","وقتی برادران به سرزمین کنعان نزد پدر خود یعقوب بازگشتند، آنچه را که برایشان اتفاق افتاده بود برای او تعریف کرده، گفتند: ");
INSERT INTO pesopcb_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","«آن مرد که حاکم آن سرزمین بود با خشونت زیاد با ما صحبت کرد و پنداشت که ما جاسوس هستیم. ");
INSERT INTO pesopcb_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","به او گفتیم که ما مردمانی درستکار هستیم و جاسوس نیستیم؛ ");
INSERT INTO pesopcb_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","ما دوازده برادریم از یک پدر. یکی از ما مرده و دیگری که از همهٔ ما کوچکتر است نزد پدرمان در کنعان می‌باشد. ");
INSERT INTO pesopcb_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","حاکم مصر در جواب ما گفت: ”اگر راست می‌گویید، یکی از شما نزد من به عنوان گروگان بماند و بقیه، غله‌ها را برداشته، نزد خانواده‌های گرسنهٔ خود بروید ");
INSERT INTO pesopcb_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","و برادر کوچک خود را نزد من آورید. اگر چنین کنید معلوم می‌شود که راست می‌گویید و جاسوس نیستید. آنگاه من هم برادر شما را آزاد خواهم کرد و اجازه خواهم داد هر زمانی که بخواهید به مصر آمده، غلهٔ مورد نیاز خود را خریداری کنید.“» ");
INSERT INTO pesopcb_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","آنها وقتی خورجینهای خود را باز کردند، دیدند پولهایی که بابت خرید غله پرداخته بودند، داخل خورجینهای غله است. آنها و پدرشان از این پیشامد بسیار ترسیدند. ");
INSERT INTO pesopcb_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","یعقوب به ایشان گفت: «مرا بی‌اولاد کردید. یوسف دیگر برنگشت، شمعون از دستم رفت و حالا می‌خواهید بنیامین را هم از من جدا کنید. چرا این همه بدی بر من واقع می‌شود؟» ");
INSERT INTO pesopcb_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","آنگاه رئوبین به پدرش گفت: «تو بنیامین را به دست من بسپار. اگر او را نزد تو باز نیاورم دو پسرم را بکُش.» ");
INSERT INTO pesopcb_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","ولی یعقوب در جواب او گفت: «پسر من با شما به مصر نخواهد آمد؛ چون برادرش یوسف مرده و از فرزندان مادرش تنها او برای من باقی مانده است. اگر بلایی بر سرش بیاید پدر پیرتان از غصه خواهد مُرد.» ");
INSERT INTO pesopcb_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","قحطی در کنعان همچنان ادامه داشت. ");
INSERT INTO pesopcb_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","پس یعقوب از پسرانش خواست تا دوباره به مصر بروند و مقداری غله بخرند، زیرا غله‌ای که از مصر خریده بودند، تمام شده بود. ");
INSERT INTO pesopcb_vpl VALUES ("GN43_3‏","002_43_3‏","GEN","43","3‏","5","ولی یهودا به او گفت: «آن مرد سخت به ما هشدار داده، گفت: ”اگر برادرتان همراه شما نباشد، روی مرا نخواهید دید.“ اگر بنیامین را با ما بفرستی ما به مصر می‌رویم تا برای تو غله بخریم.» ");
INSERT INTO pesopcb_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","یعقوب به آنها گفت: «چرا به او گفتید که برادر دیگری هم دارید؟ چرا با من چنین کردید؟» ");
INSERT INTO pesopcb_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","گفتند: «آن مرد تمام جزئیات زندگی ما و خانوادهٔ ما را به دقت از ما پرسید و گفت: ”آیا پدر شما هنوز زنده است؟ آیا برادر دیگری هم دارید؟“ ما مجبور بودیم به سؤالات او پاسخ بدهیم. ما از کجا می‌دانستیم به ما می‌گوید: ”برادرتان را نزد من بیاورید؟“» ");
INSERT INTO pesopcb_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","یهودا به پدرش گفت: «پسر را به من بسپار تا روانه شویم. در غیر این صورت ما و فرزندانمان از گرسنگی خواهیم مُرد. ");
INSERT INTO pesopcb_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","من تضمین می‌کنم که او را سالم برگردانم. اگر او را نزد تو باز نیاوردم و در حضورت حاضر نساختم، گناهش تا ابد به گردن من باشد. ");
INSERT INTO pesopcb_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","اگر موافقت کرده، او را همراه ما فرستاده بودی تا به حال به آنجا رفته و برگشته بودیم.» ");
INSERT INTO pesopcb_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","سرانجام یعقوب به ایشان گفت: «حال که اینچنین است از بهترین محصولاتی که در این سرزمین داریم، برای حاکم مصر به ارمغان ببرید. مقداری بلسان و عسل، کتیرا و مُر، پسته و بادام بار الاغهایتان نموده، به مصر بروید. ");
INSERT INTO pesopcb_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","دو برابر پولی را هم که دفعه پیش در کیسه‌هایتان گذاشته بودند با خودتان ببرید، شاید اشتباهی شده باشد. ");
INSERT INTO pesopcb_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","در ضمن، برادرتان بنیامین نیز همراه شما خواهد آمد. ");
INSERT INTO pesopcb_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","امیدوارم که خدای قادر مطلق شما را مورد لطف آن مرد قرار دهد تا شمعون و بنیامین را برگرداند. اگر خواستِ خدا چنین است که بی‌اولاد شوم، بگذار بی‌اولاد شوم.» ");
INSERT INTO pesopcb_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","پس ایشان هدایا و پولِ دو برابر برداشته، همراه بنیامین عازم مصر شدند و نزد یوسف رفتند. ");
INSERT INTO pesopcb_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","چون یوسف بنیامین را همراه آنها دید، به پیشکار خانهٔ خود گفت: «امروز ظهر این مردان با من نهار خواهند خورد. آنها را به خانه ببر و برای خوراک تدارک ببین.» ");
INSERT INTO pesopcb_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","پس آن مرد طبق دستور یوسف عمل کرده، ایشان را به قصر یوسف برد. ");
INSERT INTO pesopcb_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","پسران یعقوب وقتی فهمیدند آنها را به کجا می‌برند، بی‌نهایت ترسان شدند و به یکدیگر گفتند: «شاید به خاطر آن پولی که در خورجینهای ما گذاشته شده بود، می‌خواهند ما را بگیرند و به اسارت خود درآورند و الاغهای ما را نیز تصاحب نمایند.» ");
INSERT INTO pesopcb_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","برادران نزد پیشکار خانۀ یوسف رفتند و در درگاه خانه با او سخن گفتند: ");
INSERT INTO pesopcb_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","«ای آقا، دفعۀ اول که برای خرید غله به مصر آمدیم، ");
INSERT INTO pesopcb_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","هنگام مراجعت چون خورجینهای خود را گشودیم، پولهایی را که برای خرید غله پرداخته بودیم در آنها یافتیم. حال، آن پولها را آورده‌ایم. ");
INSERT INTO pesopcb_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","مقداری هم پول برای خرید این دفعه همراه خود آورده‌ایم. ما نمی‌دانیم آن پولها را چه کسی در خورجینهای ما گذاشته بود.» ");
INSERT INTO pesopcb_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","پیشکار به آنها گفت: «نگران نباشید. خدای شما و خدای اجدادتان این ثروت را در خورجینهایتان گذاشته است، چون من پول غله‌ها را از شما گرفتم.» پس آن مرد شمعون را از زندان آزاد ساخته، نزد برادرانش آورد. ");
INSERT INTO pesopcb_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","سپس آنها را به داخل قصر برده، آب به ایشان داد تا پاهای خود را بشویند و برای الاغهایشان نیز علوفه فراهم نمود. ");
INSERT INTO pesopcb_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","آنگاه آنها هدایای خود را آماده کردند تا ظهر که یوسف وارد می‌شود به او بدهند، زیرا به آنها گفته بودند که در آنجا نهار خواهند خورد. ");
INSERT INTO pesopcb_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","وقتی که یوسف به خانه آمد هدایای خود را به او تقدیم نموده، در حضور او تعظیم کردند. ");
INSERT INTO pesopcb_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","یوسف از احوال ایشان پرسید و گفت: «پدر پیرتان که دربارهٔ او با من صحبت کردید چطور است؟ آیا هنوز زنده است؟» ");
INSERT INTO pesopcb_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","عرض کردند: «بله، او هنوز زنده و سالم است.» و بار دیگر در مقابل او تعظیم کردند. ");
INSERT INTO pesopcb_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","یوسف چون برادر تنی خود بنیامین را دید پرسید: «آیا این همان برادر کوچک شماست که درباره‌اش با من صحبت کردید؟» سپس به او گفت: «پسرم، خدا تو را برکت دهد.» ");
INSERT INTO pesopcb_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","یوسف با دیدن برادرش آنچنان تحت تأثیر قرار گرفت که نتوانست از گریستن خودداری نماید؛ پس به جایی خلوت شتافت و در آنجا گریست. ");
INSERT INTO pesopcb_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","سپس صورت خود را شسته نزد برادرانش بازگشت و در حالی که بر خود مسلط شده بود، دستور داد غذا را بیاورند. ");
INSERT INTO pesopcb_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","برای یوسف جداگانه سفره چیدند و برای برادرانش جداگانه. مصری‌هایی هم که در آنجا بودند از سفرهٔ دیگری غذا می‌خوردند، زیرا مصری‌ها عبرانی‌ها را نجس می‌دانستند. ");
INSERT INTO pesopcb_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","یوسف برادرانش را برحسب سن ایشان بر سر سفره نشانید و آنها از این عمل او متعجب شدند. ");
INSERT INTO pesopcb_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","او از سفرهٔ خود به ایشان غذا داد و برای بنیامین پنج برابر سایرین غذا کشید. پس آن روز ایشان با یوسف خوردند و نوشیدند و شادی نمودند. ");
INSERT INTO pesopcb_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","وقتی برادران یوسف آمادهٔ حرکت شدند، یوسف به پیشکار خانه خود دستور داد که خورجینهای آنها را تا حدی که می‌توانستند ببرند از غله پُر کند و پول هر یک را در دهانهٔ خورجینش بگذارد. ");
INSERT INTO pesopcb_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","همچنین به پیشکار دستور داد که جام نقره‌اش را با پولهای پرداخت شده در خورجین بنیامین بگذارد. پیشکار آنچه که یوسف به او گفته بود انجام داد. ");
INSERT INTO pesopcb_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","برادران صبح زود برخاسته، الاغهای خود را بار کردند و به راه افتادند. ");
INSERT INTO pesopcb_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","اما هنوز از شهر زیاد دور نشده بودند که یوسف به پیشکار خانه‌اش گفت: «به دنبال ایشان بشتاب و چون به آنها رسیدی بگو: ”چرا به عوض خوبی بدی کردید؟ ");
INSERT INTO pesopcb_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","چرا جام مخصوص سَروَر مرا که با آن شراب می‌نوشد و فال می‌گیرد دزدیدید؟“» ");
INSERT INTO pesopcb_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","پیشکار چون به آنها رسید، هر آنچه به او دستور داده شده بود، به ایشان گفت. ");
INSERT INTO pesopcb_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","آنها به وی پاسخ دادند: «چرا سَروَر ما چنین می‌گوید؟ قسم می‌خوریم که مرتکب چنین عمل زشتی نشده‌ایم. ");
INSERT INTO pesopcb_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","مگر ما پولهایی را که دفعهٔ پیش در خورجینهای خود یافتیم نزد شما نیاوردیم؟ پس چطور ممکن است طلا یا نقره‌ای از خانهٔ اربابت دزدیده باشیم؟ ");
INSERT INTO pesopcb_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","جام را پیش هر کس که پیدا کردی او را بکش و بقیهٔ ما هم غلامان سَروَرمان خواهیم شد.» ");
INSERT INTO pesopcb_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","پیشکار گفت: «بسیار خوب، ولی فقط همان کسی که جام را دزدیده باشد، غلام من خواهد شد و بقیهٔ شما می‌توانید بروید.» ");
INSERT INTO pesopcb_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","آنگاه همگی با عجله خورجینهای خود را از پشت الاغ بر زمین نهادند و آنها را باز کردند. ");
INSERT INTO pesopcb_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","پیشکار جستجوی خود را از برادر بزرگتر شروع کرده، به کوچکتر رسید و جام را در خورجین بنیامین یافت. ");
INSERT INTO pesopcb_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","برادران از شدت ناراحتی لباسهای خود را پاره کردند و کیسه‌ها را بر الاغها نهاده، به شهر بازگشتند. ");
INSERT INTO pesopcb_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","وقتی یهودا و سایر برادرانش به خانه یوسف رسیدند، او هنوز در آنجا بود. آنها نزد او به خاک افتادند. ");
INSERT INTO pesopcb_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","یوسف از ایشان پرسید: «چرا این کار را کردید؟ آیا نمی‌دانستید مردی چون من با فالگیری می‌تواند بفهمد چه کسی جامش را دزدیده است؟» ");
INSERT INTO pesopcb_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","یهودا گفت: «در جواب سَروَر خود چه بگوییم؟ چگونه می‌توانیم بی‌گناهی خود را ثابت کنیم؟ خواست خداست که به سزای اعمال خود برسیم. اینک برگشته‌ایم تا همگی ما و شخصی که جام نقره در کیسه‌اش یافت شده، غلامان شما شویم.» ");
INSERT INTO pesopcb_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","یوسف گفت: «نه، فقط شخصی که جام را دزدیده است غلام من خواهد بود. بقیه شما می‌توانید به سلامت نزد پدرتان بازگردید.» ");
INSERT INTO pesopcb_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","یهودا جلو رفته، گفت: «سَروَرم، می‌دانم که شما چون فرعون مقتدر هستید، پس بر من خشمگین نشوید و اجازه دهید مطلبی را به عرضتان برسانم. ");
INSERT INTO pesopcb_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","«دفعه اول که به حضور شما رسیدیم، از ما پرسیدید که آیا پدر و برادر دیگری داریم؟ ");
INSERT INTO pesopcb_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","عرض کردیم: ”بله. پدر پیری داریم و برادر کوچکی که فرزندِ زمانِ پیری اوست. این پسر برادری داشت که مرده است و او اینک تنها پسر مادرش می‌باشد و پدرمان او را خیلی دوست دارد.“ ");
INSERT INTO pesopcb_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","دستور دادی که آن برادر کوچکتر را به حضورت بیاوریم تا او را ببینی. ");
INSERT INTO pesopcb_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","عرض کردیم که اگر آن پسر از پدرش جدا شود، پدرمان خواهد مرد. ");
INSERT INTO pesopcb_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","ولی به ما گفتی که دیگر به مصر برنگردیم مگر این که او را همراه خود بیاوریم. ");
INSERT INTO pesopcb_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","«پس نزد غلامت پدر خویش برگشتیم و آنچه به ما فرموده بودید، به او گفتیم. ");
INSERT INTO pesopcb_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","وقتی او به ما گفت که دوباره به مصر برگردیم و غله بخریم، ");
INSERT INTO pesopcb_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","گفتیم که نمی‌توانیم به مصر برویم مگر این که اجازه بدهی برادر کوچک خود را نیز همراه خود ببریم. چون اگر او را با خود نبریم حاکم مصر ما را به حضور نخواهد پذیرفت. ");
INSERT INTO pesopcb_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","پدرمان به ما گفت: ”شما می‌دانید که همسرم راحیل فقط دو پسر داشت. ");
INSERT INTO pesopcb_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","یکی از آنها رفت و دیگر برنگشت. بدون شک حیوانات وحشی او را دریدند و من دیگر او را ندیدم. ");
INSERT INTO pesopcb_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","اگر برادرش را هم از من بگیرید و بلایی بر سرش بیاید، پدر پیرتان از غصه خواهد مُرد.“ ");
INSERT INTO pesopcb_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","«حال، ای سَروَرم، ما نمی‌توانیم بدون این جوان نزد پدرمان برگردیم. جان پدرمان به جان او بسته است. ");
INSERT INTO pesopcb_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","اگر او ببیند که پسرش همراه ما نیست، از غصه خواهد مُرد. آن وقت ما مسئول مرگ پدر پیرمان خواهیم بود. ");
INSERT INTO pesopcb_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","من نزد پدرم ضامن جان این پسر شدم و به او گفتم که اگر او را سالم برنگردانم، گناهش تا ابد به گردن من باشد. ");
INSERT INTO pesopcb_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","«بنابراین التماس می‌کنم مرا به جای بنیامین در بندگی خویش نگاه دارید و اجازه دهید که او همراه سایرین نزد پدرش برود. ");
INSERT INTO pesopcb_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","زیرا چگونه می‌توانم بدون بنیامین نزد پدرم برگردم و بلایی را که بر سر پدرم می‌آید ببینم؟» ");
INSERT INTO pesopcb_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","یوسف دیگر نتوانست نزد کسانی که در حضورش بودند، خودداری کند، پس فریاد زد: «همه از اینجا خارج شوید!» وقتی همه رفتند و او را با برادرانش تنها گذاشتند او خود را به ایشان شناساند. ");
INSERT INTO pesopcb_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","سپس با صدای بلند گریست، به طوری که مصری‌ها شنیدند و این خبر به دربار فرعون رسید. ");
INSERT INTO pesopcb_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","او به برادرانش گفت: «من یوسف هستم. آیا پدرم هنوز زنده است؟» اما برادرانش که از ترس، زبانشان بند آمده بود، نتوانستند جواب بدهند. ");
INSERT INTO pesopcb_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","یوسف گفت: «جلو بیایید!» پس به او نزدیک شدند و او دوباره گفت: «منم، یوسف، برادر شما که او را به مصر فروختید. ");
INSERT INTO pesopcb_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","حال از این کار خود ناراحت نشوید و خود را سرزنش نکنید، چون این خواست خدا بود. او مرا پیش از شما به مصر فرستاد تا جان مردم را در این زمان قحطی حفظ کند. ");
INSERT INTO pesopcb_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","از هفت سال قحطی، دو سال گذشته است. طی پنج سال آینده کشت و زرعی نخواهد شد. ");
INSERT INTO pesopcb_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","اما خدا مرا پیش از شما به اینجا فرستاد تا برای شما بر روی زمین نسلی باقی بگذارد و جانهای شما را به طرز شگفت‌انگیزی رهایی بخشد. ");
INSERT INTO pesopcb_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","آری، خدا بود که مرا به مصر فرستاد، نه شما. در اینجا هم خدا مرا مشاور فرعون و سرپرست خانه او و حاکم بر تمامی سرزمین مصر گردانیده است. ");
INSERT INTO pesopcb_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","«حال، نزد پدرم بشتابید و به او بگویید که پسر تو، یوسف عرض می‌کند: ”خدا مرا حاکم سراسر مصر گردانیده است. بی‌درنگ نزد من بیا ");
INSERT INTO pesopcb_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","و در زمین جوشن ساکن شو تا تو با همهٔ فرزندان و نوه‌هایت و تمامی گله و رمه و اموالت نزدیک من باشی. ");
INSERT INTO pesopcb_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","من در آنجا از تو نگهداری خواهم کرد، زیرا هنوز پنج سالِ دیگر از این قحطی باقیست. اگر نزد من نیایی تو و همۀ فرزندان و بستگانت از گرسنگی خواهید مُرد.“ ");
INSERT INTO pesopcb_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","«همهٔ شما و برادرم بنیامین شاهد هستید که این من هستم که با شما صحبت می‌کنم. ");
INSERT INTO pesopcb_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","پدرم را از قدرتی که در مصر دارم و از آنچه دیده‌اید آگاه سازید و او را هر چه زودتر نزد من بیاورید.» ");
INSERT INTO pesopcb_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","آنگاه یوسف، بنیامین را در آغوش گرفته و با هم گریستند. ");
INSERT INTO pesopcb_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","بعد سایر برادرانش را بوسید و گریست. آنگاه جرأت یافتند با او صحبت کنند. ");
INSERT INTO pesopcb_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","طولی نکشید که خبر آمدن برادران یوسف به گوش فرعون رسید. فرعون و تمامی درباریانش از شنیدن این خبر خوشحال شدند. ");
INSERT INTO pesopcb_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","پس فرعون به یوسف گفت: «به برادران خود بگو که الاغهای خود را بار کنند و به کنعان بروند. ");
INSERT INTO pesopcb_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","و پدر و همهٔ خانواده‌های خود را برداشته به مصر بیایند. من حاصلخیزترین زمینِ مصر را به ایشان خواهم داد تا از محصولاتِ فراوانِ آن بهره‌مند شوند. ");
INSERT INTO pesopcb_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","برای آوردن پدرت و زنان و کودکان، چند ارابه به آنها بده که با خود ببرند. ");
INSERT INTO pesopcb_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","به ایشان بگو که دربارهٔ اموال خود نگران نباشند، زیرا حاصلخیزترین زمین مصر به آنها داده خواهد شد.» ");
INSERT INTO pesopcb_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","یوسف چنانکه فرعون گفته بود، ارابه‌ها و آذوقه برای سفر به ایشان داد. ");
INSERT INTO pesopcb_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","او همچنین به هر یک از آنها یک دست لباس نو هدیه نمود، اما به بنیامین پنج دست لباس و سیصد مثقال نقره بخشید. ");
INSERT INTO pesopcb_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","برای پدرش ده بارِ الاغ از بهترین کالاهای مصر و ده بارِ الاغ غله و خوراکی‌های دیگر به جهت سفرش فرستاد. ");
INSERT INTO pesopcb_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","به این طریق برادران خود را مرخص نمود و به ایشان تأکید کرد که در بین راه با هم دعوا نکنند. ");
INSERT INTO pesopcb_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","آنها مصر را به قصد کنعان ترک گفته، نزد پدر خویش بازگشتند. ");
INSERT INTO pesopcb_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","آنگاه نزد یعقوب شتافته، به او گفتند: «یوسف زنده است! او حاکم تمام سرزمین مصر می‌باشد.» اما یعقوب چنان حیرت‌زده شد که نتوانست سخنان ایشان را قبول کند. ");
INSERT INTO pesopcb_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","ولی وقتی چشمانش به ارابه‌ها افتاد و پیغام یوسف را به او دادند، روحش تازه شد ");
INSERT INTO pesopcb_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","و گفت: «باور می‌کنم! پسرم یوسف زنده است! می‌روم تا پیش از مردنم او را ببینم.» ");
INSERT INTO pesopcb_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","پس یعقوب با هر چه که داشت کوچ کرده، به بئرشبع آمد و در آنجا برای خدای پدرش اسحاق، قربانیها تقدیم کرد. ");
INSERT INTO pesopcb_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","شب هنگام، خدا در رویا به وی گفت: «یعقوب! یعقوب!» عرض کرد: «بله، خداوندا!» ");
INSERT INTO pesopcb_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","گفت: «من خدا هستم، خدای پدرت! از رفتن به مصر نترس، زیرا در آنجا از تو قوم بزرگی به وجود خواهم آورد. ");
INSERT INTO pesopcb_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","من با تو به مصر خواهم آمد و تو را به یقین باز خواهم آورد. تو در مصر خواهی مرد و یوسف با دست خود چشمانت را خواهد بست.» ");
INSERT INTO pesopcb_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","یعقوب از بئرشبع کوچ کرد و پسرانش او را همراه زنان و فرزندانشان با ارابه‌هایی که فرعون به ایشان داده بود، به مصر بردند. ");
INSERT INTO pesopcb_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","آنها گله و رمه و تمامی اموالی را که در کنعان اندوخته بودند، با خود به مصر آوردند. ");
INSERT INTO pesopcb_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","یعقوب با پسران و دختران و نوه‌های پسری و دختری خود و تمام خویشانش به مصر آمد. ");
INSERT INTO pesopcb_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","اسامی پسران و نوه‌های یعقوب که با وی به مصر آمدند از این قرار است: رئوبین پسر ارشد او ");
INSERT INTO pesopcb_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","و پسرانش: حنوک، فلو، حصرون و کرمی. ");
INSERT INTO pesopcb_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","شمعون و پسرانش: یموئیل، یامین، اوحد، یاکین، صوحر و شائول. (مادر شائول کنعانی بود.) ");
INSERT INTO pesopcb_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","لاوی و پسرانش: جرشون، قهات و مراری. ");
INSERT INTO pesopcb_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","یهودا و پسرانش: عیر، اونان، شیله، فارص و زارح. (اما عیر و اونان پیش از رفتن یعقوب به مصر در کنعان مردند.) پسران فارص، حصرون و حامول بودند. ");
INSERT INTO pesopcb_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","یساکار و پسرانش: تولاع، فوّه، یوب و شمرون. ");
INSERT INTO pesopcb_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","زبولون و پسرانش: سارد، ایلون و یاحل‌ئیل. ");
INSERT INTO pesopcb_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","اینها بودند پسران لیه که آنها را با دختر خود دینه، در فَدّان‌اَرام برای یعقوب به دنیا آورد. این پسران و دختران یعقوب در مجموع سی و سه نفر بودند. ");
INSERT INTO pesopcb_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","پسران جاد: صفیون، حجّی، شونی، اصبون، عیری، ارودی و ارئیلی. ");
INSERT INTO pesopcb_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","پسران اشیر: یمنه، یشوه، یشوی، بریعه و دخترش سِراح. پسران بریعه حابر و ملکی‌ئیل بودند. ");
INSERT INTO pesopcb_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","اینان بودند پسران یعقوب و زلفه، کنیزی که لابان به دخترش لیه داده بود. آنها در مجموع شانزده نفر بودند. ");
INSERT INTO pesopcb_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","پسران راحیل، همسر یعقوب: یوسف و بنیامین. ");
INSERT INTO pesopcb_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","پسران یوسف که در مصر متولد شدند: منسی و افرایم. مادرشان اسنات، دختر فوطی فارع، کاهن اون بود. ");
INSERT INTO pesopcb_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","پسران بنیامین: بالع، باکر، اشبیل، جیرا، نعمان، ایحی، رش، مفیّم، حفیّم و آرد. ");
INSERT INTO pesopcb_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","اینان بودند پسران راحیل و یعقوب. آنها در مجموع چهارده نفر بودند. ");
INSERT INTO pesopcb_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","پسر دان: حوشیم. ");
INSERT INTO pesopcb_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","پسران نفتالی: یحص‌ئیل، جونی، یصر و شلیّم. ");
INSERT INTO pesopcb_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","اینان بودند پسران یعقوب و بلهه، کنیزی که لابان به دخترش راحیل داده بود. در مجموع هفت نفر بودند. ");
INSERT INTO pesopcb_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","پس تعداد افرادی که از نسل یعقوب همراه او به مصر رفتند (غیر از زنان پسرانش) شصت و شش نفر بود. ");
INSERT INTO pesopcb_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","برای یوسف نیز دو پسر در مصر متولد شدند. پس جمع افراد خانوادهٔ یعقوب که در مصر بودند، هفتاد نفر می‌شد. ");
INSERT INTO pesopcb_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","یعقوب، پسرش یهودا را پیشاپیش نزد یوسف فرستاد تا از او بپرسد که از چه راهی باید به زمین جوشن بروند. وقتی به جوشن رسیدند، ");
INSERT INTO pesopcb_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","یوسف ارابهٔ خود را حاضر کرد و برای دیدن پدرش به جوشن رفت. وقتی در آنجا پدرش را دید، او را در آغوش گرفته، مدتی گریست. ");
INSERT INTO pesopcb_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","آنگاه یعقوب به یوسف گفت: «حال، مرا غم مُردن نیست، زیرا بار دیگر تو را دیدم و می‌دانم که زنده‌ای.» ");
INSERT INTO pesopcb_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","یوسف به برادرانش و تمامی افراد خانواده آنها گفت: «حال می‌روم تا به فرعون خبر دهم که شما از کنعان به نزد من آمده‌اید. ");
INSERT INTO pesopcb_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","به او خواهم گفت که شما چوپان هستید و تمامی گله‌ها و رمه‌ها و هر آنچه را که داشته‌اید همراه خویش آورده‌اید. ");
INSERT INTO pesopcb_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","پس اگر فرعون از شما بپرسد که شغل شما چیست، ");
INSERT INTO pesopcb_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","به او بگویید که از ابتدای جوانی تا به حال به شغل چوپانی و گله‌داری مشغول بوده‌اید و این کار را از پدران خود به ارث برده‌اید. اگر چنین به فرعون پاسخ دهید او به شما اجازه خواهد داد تا در جوشن ساکن شوید، چون مردم سایر نقاط مصر از چوپانان نفرت دارند.» ");
INSERT INTO pesopcb_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","یوسف به حضور فرعون رفت و به او گفت: «پدرم و برادرانم با گله‌ها و رمه‌ها و هر آنچه که داشته‌اند از کنعان به اینجا آمده‌اند، و الان در جوشن هستند.» ");
INSERT INTO pesopcb_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","یوسف پنج نفر از برادرانش را که با خود آورده بود، به فرعون معرفی کرد. ");
INSERT INTO pesopcb_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","فرعون از آنها پرسید: «شغل شما چیست؟» گفتند: «ما هم مثل اجدادمان چوپان هستیم. ");
INSERT INTO pesopcb_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","آمده‌ایم در مصر زندگی کنیم، زیرا در کنعان به علّت قحطی شدید برای گله‌های ما چراگاهی نیست. التماس می‌کنیم به ما اجازه دهید در جوشن ساکن شویم.» ");
INSERT INTO pesopcb_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","فرعون به یوسف گفت: «حال که پدرت و برادرانت نزد تو آمده‌اند، ");
INSERT INTO pesopcb_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","هر جایی را که می‌خواهی به آنها بده. بگذار در جوشن که بهترین ناحیهٔ مصر است ساکن شوند. اگر افراد شایسته‌ای بین آنها می‌شناسی، آنها را بر گله‌های من نیز بگمار.» ");
INSERT INTO pesopcb_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","سپس یوسف، پدرش یعقوب را نزد فرعون آورد، و یعقوب فرعون را برکت داد. ");
INSERT INTO pesopcb_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","فرعون از یعقوب پرسید: «چند سال از عمرت می‌گذرد؟» ");
INSERT INTO pesopcb_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","یعقوب جواب داد: «صد و سی سال دارم و سالهای عمرم را در غربت گذرانده‌ام. عمرم کوتاه و پر از رنج بوده است و به سالهای عمر اجدادم که در غربت می‌زیستند، نمی‌رسد.» ");
INSERT INTO pesopcb_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","یعقوب پیش از رفتن، بار دیگر فرعون را برکت داد. ");
INSERT INTO pesopcb_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","آنگاه یوسف چنانکه فرعون دستور داده بود بهترین ناحیهٔ مصر، یعنی ناحیهٔ رعمسیس را برای پدر و برادرانش تعیین کرد و آنها را در آنجا مستقر نمود، ");
INSERT INTO pesopcb_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","و یوسف برحسب تعدادشان خوراک کافی در اختیار آنها گذاشت. ");
INSERT INTO pesopcb_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","قحطی روز‌به‌روز شدت می‌گرفت به طوری که همۀ مردم مصر و کنعان گرسنگی می‌کشیدند. ");
INSERT INTO pesopcb_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","یوسف تمام پولهای مردم مصر و کنعان را در مقابل غله‌هایی که خریده بودند، جمع کرد و در خزانه‌های فرعون ریخت. ");
INSERT INTO pesopcb_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","وقتی پولِ مردم تمام شد، نزد یوسف آمده، گفتند: «دیگر پولی نداریم که به عوض غله بدهیم. به ما خوراک بده. نگذار از گرسنگی بمیریم.» ");
INSERT INTO pesopcb_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","یوسف در جواب ایشان گفت: «اگر پول شما تمام شده، چارپایان خود را به من بدهید تا در مقابل، به شما غله بدهم.» ");
INSERT INTO pesopcb_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","آنها چاره‌ای نداشتند جز این که دامهای خود را به یوسف بدهند تا به ایشان نان بدهد. به این ترتیب در عرض یک سال، تمام اسبها و الاغها و گله‌ها و رمه‌های مصر از آنِ فرعون گردید. ");
INSERT INTO pesopcb_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","سال بعد، آنها بار دیگر نزد یوسف آمده، گفتند: «ای سَروَر ما، پول ما تمام شده و تمامی گله‌ها و رمه‌های ما نیز از آن تو شده است. دیگر چیزی برای ما باقی نمانده جز خودمان و زمینهایمان. ");
INSERT INTO pesopcb_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","نگذار از گرسنگی بمیریم؛ نگذار زمینهایمان از بین بروند. ما و زمینهایمان را بخر و ما با زمینهایمان مالِ فرعون خواهیم شد. به ما غذا بده تا زنده بمانیم و بذر بده تا زمینها بایر نمانند.» ");
INSERT INTO pesopcb_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","پس یوسف تمامی زمین مصر را برای فرعون خرید. مصری‌ها زمینهای خود را به او فروختند، زیرا قحطی بسیار شدید بود. ");
INSERT INTO pesopcb_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","به این طریق مردمِ سراسر مصر غلامان فرعون شدند. ");
INSERT INTO pesopcb_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","تنها زمینی که یوسف نخرید، زمین کاهنان بود، زیرا فرعون خوراک آنها را به آنها می‌داد و نیازی به فروش زمین خود نداشتند. ");
INSERT INTO pesopcb_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","آنگاه یوسف به مردم مصر گفت: «من شما و زمینهای شما را برای فرعون خریده‌ام. حالا به شما بذر می‌دهم تا رفته در زمینها بکارید. ");
INSERT INTO pesopcb_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","موقع برداشت محصول، یک پنجم آن را به فرعون بدهید و بقیه را برای کشت سال بعد و خوراک خود و خانواده‌هایتان نگاه دارید.» ");
INSERT INTO pesopcb_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","آنها گفتند: «تو در حق ما خوبی کرده‌ای و جان ما را نجات داده‌ای، بنابراین غلامان فرعون خواهیم بود.» ");
INSERT INTO pesopcb_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","پس یوسف در تمامی سرزمین مصر مقرر نمود که از آن به بعد، هر ساله یک پنجم از تمامی محصول به عنوان مالیات به فرعون داده شود. محصول زمینهای کاهنان مشمول این قانون نبود. این قانون هنوز هم به قوت خود باقی است. ");
INSERT INTO pesopcb_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","پس بنی‌اسرائیل در سرزمین مصر در ناحیهٔ جوشن ساکن شدند و بر تعداد و ثروت آنها پیوسته افزوده می‌شد. ");
INSERT INTO pesopcb_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","یعقوب بعد از رفتن به مصر، هفده سال دیگر زندگی کرد و در سن صد و چهل و هفت سالگی درگذشت. ");
INSERT INTO pesopcb_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","او در روزهای آخر عمرش، یوسف را نزد خود خواند و به او گفت: «دستت را زیر ران من بگذار و سوگند یاد کن که مرا در مصر دفن نکنی. ");
INSERT INTO pesopcb_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","بعد از مردنم جسد مرا از سرزمین مصر برده، در کنار اجدادم دفن کن.» یوسف به او قول داد که این کار را بکند. ");
INSERT INTO pesopcb_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","یعقوب گفت: «برایم قسم بخور که این کار را خواهی کرد.» پس یوسف برایش قسم خورد و یعقوب بر سر بسترش سجده کرد. ");
INSERT INTO pesopcb_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","پس از چندی به یوسف خبر دادند که پدرش سخت مریض است. پس دو پسرش منسی و افرایم را برداشته، به دیدن پدر خود رفت. ");
INSERT INTO pesopcb_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","چون یعقوب خبر آمدن یوسف را شنید، نیروی خود را جمع کرده، در رختخواب نشست. ");
INSERT INTO pesopcb_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","او به یوسف گفت: «خدای قادر مطلق در ناحیه لوز کنعان به من ظاهر شد و مرا برکت داد. ");
INSERT INTO pesopcb_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","او به من فرمود: ”به تو فرزندان زیادی خواهم بخشید و از نسل تو قومهای بسیاری به وجود خواهم آورد و این سرزمین را به نسل تو خواهم داد تا مِلک دائمی ایشان باشد.“ ");
INSERT INTO pesopcb_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","اکنون دو پسرت منسی و افرایم که قبل از آمدن من، در مصر به دنیا آمده‌اند، مانند فرزندانم رئوبین و شمعون وارثان من خواهند بود. ");
INSERT INTO pesopcb_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","ولی فرزندانی که بعد از این برایت به دنیا بیایند متعلق به خودت بوده از سهم افرایم و منسی ارث خواهند برد. ");
INSERT INTO pesopcb_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","من این کار را به خاطر مادرت راحیل می‌کنم. پس از بیرون آمدنم از فَدّان‌اَرام او بین راه در نزدیکی افرات مُرد و من هم او را در آنجا، کنار راه افرات دفن کردم.» (افرات همان بیت‌لحم است.) ");
INSERT INTO pesopcb_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","وقتی یعقوب پسران یوسف را دید از او پرسید: «آیا اینها پسران تو هستند؟» ");
INSERT INTO pesopcb_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","یوسف گفت: «بله، اینها پسران من هستند که خدا آنها را در مصر به من بخشیده است.» یعقوب گفت: «آنها را نزد من بیاور تا برکتشان بدهم.» ");
INSERT INTO pesopcb_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","یعقوب بر اثر پیری چشمانش ضعیف و تار گشته بود و نمی‌توانست خوب ببیند. پس یوسف پسرانش را نزد او آورد. او آنها را بوسید و در آغوش کشید. ");
INSERT INTO pesopcb_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","یعقوب به یوسف گفت: «هرگز فکر نمی‌کردم دوباره تو را ببینم ولی حال خدا اجازه داده حتی فرزندانت را نیز ببینم.» ");
INSERT INTO pesopcb_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","یوسف پسرانش را از روی زانوان یعقوب برداشت و در مقابل پدرش سر تعظیم فرود آورد. ");
INSERT INTO pesopcb_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","سپس افرایم را در طرف چپ و منسی را در طرف راست یعقوب قرار داد. ");
INSERT INTO pesopcb_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","اما یعقوب دستهای خود را عمداً طوری دراز کرد و بر سر پسرها گذاشت که دست راست او بر سر افرایم، پسر کوچکتر، و دست چپ او بر سر منسی، پسر بزرگتر قرار گرفت. ");
INSERT INTO pesopcb_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","آنگاه یوسف را چنین برکت داد: «خدایی که پدرانم ابراهیم و اسحاق در حضورش زندگی می‌کردند، این دو پسرت را برکت دهد. خدایی که مرا در تمام عمرم شبانی کرده، ");
INSERT INTO pesopcb_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","آن فرشته‌ای که مرا از هر بدی محفوظ داشته، آنها را برکت دهد. باشد که این دو پسر نام من و نام پدرانم ابراهیم و اسحاق را زنده نگاه دارند و از آنها قوم عظیمی به وجود آید.» ");
INSERT INTO pesopcb_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","اما یوسف چون دست راست پدرش را روی سر افرایم دید ناراحت شد، پس دست راست او را گرفت تا آن را روی سر منسی بگذارد. ");
INSERT INTO pesopcb_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","یوسف گفت: «پدر، تو دستهایت را به اشتباه روی سر پسرها گذاشته‌ای! پسر بزرگتر من این یکی است. دست راست خود را روی سر او بگذار.» ");
INSERT INTO pesopcb_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","اما پدرش نپذیرفت و گفت: «پسرم، من می‌دانم چه می‌کنم. از منسی هم یک قوم بزرگ به وجود خواهد آمد، ولی برادر کوچکتر او افرایم، بزرگتر خواهد بود و از نسل او قومهای بسیاری به وجود خواهند آمد.» ");
INSERT INTO pesopcb_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","آنگاه یعقوب پسران یوسف را در آن روز برکت داده، گفت: «باشد که قوم اسرائیل با این کلمات یکدیگر را برکت داده، بگویند: خدا تو را مثل افرایم و منسی کامیاب و سعادتمند گرداند.» به این ترتیب یعقوب افرایم را بر منسی برتری بخشید. ");
INSERT INTO pesopcb_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","سپس یعقوب به یوسف گفت: «من به‌زودی می‌میرم، اما خدا با شما خواهد بود و شما را بار دیگر به سرزمین اجدادتان باز خواهد گردانید. ");
INSERT INTO pesopcb_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","من زمینی را که به کمان و شمشیر خود از اموری‌ها گرفتم، به تو که بر برادرانت برتری داری، می‌بخشم.» ");
INSERT INTO pesopcb_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","آنگاه یعقوب پسرانش را فرا خواند و به ایشان گفت: «دور من جمع شوید تا به شما بگویم که در آینده بر شما چه خواهد گذشت. ");
INSERT INTO pesopcb_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","ای پسران یعقوب به سخنان پدر خود اسرائیل گوش دهید. ");
INSERT INTO pesopcb_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","«رئوبین، تو پسر ارشد منی! توانایی من و نوبر قدرت من! تو در مقام و قدرت از همه برتری، ");
INSERT INTO pesopcb_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","ولی چون امواج سرکش دریا، خروشانی. پس از این دیگر برتر از همه نخواهی بود، زیرا با یکی از زنان من نزدیکی نموده، مرا بی‌حرمت کردی. ");
INSERT INTO pesopcb_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","«شمعون و لاوی، شما مثل هم هستید، مردانی بی‌رحم و بی‌انصاف. ");
INSERT INTO pesopcb_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","من هرگز در نقشه‌های پلید شما شریک نخواهم شد، زیرا از روی خشم خود انسانها را کُشتید و خودسرانه رگ پاهای گاوان را قطع کردید. ");
INSERT INTO pesopcb_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","لعنت بر خشم شما که اینچنین شدید و بی‌رحم بود. من نسل شما را در سراسر سرزمین اسرائیل پراکنده خواهم ساخت. ");
INSERT INTO pesopcb_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","«ای یهودا، برادرانت تو را ستایش خواهند کرد. تو دشمنانت را منهدم خواهی نمود. ");
INSERT INTO pesopcb_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","یهودا مانند شیر بچه‌ای است که از شکار برگشته و خوابیده است. کیست که جرأت کند او را بیدار سازد؟ ");
INSERT INTO pesopcb_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","عصای سلطنت از یهودا دور نخواهد شد و نه چوگان فرمانروایی از فرزندان او، تا شیلو که همهٔ قومها او را اطاعت می‌کنند، بیاید. ");
INSERT INTO pesopcb_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","الاغ خود را به بهترین درخت انگور خواهد بست و جامهٔ خود را در شراب خواهد شست. ");
INSERT INTO pesopcb_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","چشمان او تیره‌تر از شراب و دندانهایش سفیدتر از شیر خواهد بود. ");
INSERT INTO pesopcb_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","«زبولون در سواحل دریا ساکن خواهد شد و بندری برای کشتیها خواهد بود و مرزهایش تا صیدون گسترش خواهد یافت. ");
INSERT INTO pesopcb_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","«یساکار حیوان بارکش نیرومندی است که زیر بار خود خوابیده است. ");
INSERT INTO pesopcb_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","وقتی ببیند جایی که خوابیده دلپسند است، تن به کار خواهد داد و چون برده‌ای به بیگاری کشیده خواهد شد. ");
INSERT INTO pesopcb_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","«دان قبیلهٔ خود را چون یکی از قبایل اسرائیل داوری خواهد کرد. ");
INSERT INTO pesopcb_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","او مثل مار بر سر راه قرار گرفته، پاشنه اسبان را نیش خواهد زد تا سوارانشان سرنگون شوند. ");
INSERT INTO pesopcb_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","خداوندا، منتظر نجات تو می‌باشم. ");
INSERT INTO pesopcb_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","«جاد مورد یورش غارتگران واقع خواهد شد، اما آنها وقتی عقب نشینند، او بر آنها یورش خواهد آورد. ");
INSERT INTO pesopcb_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","«اشیر سرزمینی حاصلخیز خواهد داشت و از محصول آن برای پادشاهان خوراک تهیه خواهد کرد. ");
INSERT INTO pesopcb_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","«نفتالی غزالی است آزاد که بچه‌های زیبا به وجود می‌آورد. ");
INSERT INTO pesopcb_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","«یوسف درخت پرثمریست در کنار چشمهٔ آب که شاخه‌هایش به اطراف سایه افکنده است. ");
INSERT INTO pesopcb_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","دشمنان بر او هجوم آوردند و با تیرهای خود به او صدمه زدند. ");
INSERT INTO pesopcb_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","ولی کمان او پایدار ماند و بازوانش قوی گردید به دست خدای قادر یعقوب، شبان و صخرۀ اسرائیل. ");
INSERT INTO pesopcb_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","باشد که خدای قادر مطلق، خدای پدرت، تو را یاری کند و از برکات آسمانی و زمینی بهره‌مند گرداند و فرزندان تو را زیاد سازد. ");
INSERT INTO pesopcb_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","برکت پدر تو عظیم‌تر از وفور محصولات کوههای قدیمی است. تمام این برکات بر یوسف که از میان برادرانش برگزیده شد، قرار گیرد. ");
INSERT INTO pesopcb_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","«بنیامین گرگ درنده‌ای است که صبحگاهان دشمنانش را می‌بلعد و شامگاهان آنچه را که به غنیمت گرفته است، تقسیم می‌نماید.» ");
INSERT INTO pesopcb_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","این بود برکات یعقوب به پسران خود که دوازده قبیلهٔ اسرائیل را به وجود آوردند. ");
INSERT INTO pesopcb_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","سپس یعقوب چنین وصیت کرد: «من به‌زودی می‌میرم و به اجداد خود می‌پیوندم. شما جسد مرا به کنعان برده، در کنار پدرانم در غاری که در زمین عِفرون حیتّی است دفن کنید، ");
INSERT INTO pesopcb_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","همان غاری که در زمین مکفیله، نزدیک ممری است و ابراهیم آن را با مزرعه‌اش از عفرون حیتّی خرید تا مقبره خانوادگی‌اش باشد. ");
INSERT INTO pesopcb_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","در آنجا ابراهیم و همسرش سارا، اسحاق و همسر وی ربکا دفن شده‌اند. لیه را هم در آنجا به خاک سپردم. ");
INSERT INTO pesopcb_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","پدربزرگم ابراهیم آن غار و مزرعه‌اش را برای همین منظور از حیتّی‌ها خرید.» ");
INSERT INTO pesopcb_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","پس از آنکه یعقوب این وصیت را با پسرانش به پایان رساند، بر بستر خود دراز کشیده، جان سپرد و به اجداد خود پیوست. ");
INSERT INTO pesopcb_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","آنگاه یوسف خود را روی جسد پدرش انداخته، گریست و او را بوسید. ");
INSERT INTO pesopcb_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","سپس دستور داد تا جسد وی را مومیایی کنند. ");
INSERT INTO pesopcb_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","کار مومیایی کردن مرده چهل روز طول می‌کشید. پس از مومیایی کردن جسد یعقوب، مردمِ مصر مدت هفتاد روز برای او عزاداری کردند. ");
INSERT INTO pesopcb_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","بعد از اتمام ایام عزاداری، یوسف نزد درباریان فرعون رفته، از ایشان خواست که از طرف وی به فرعون بگویند: ");
INSERT INTO pesopcb_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","«پدرم مرا قسم داده است که پس از مرگش جسد وی را به کنعان برده، در قبری که برای خود آماده کرده است دفن کنم. درخواست می‌کنم به من اجازه دهید بروم و پدرم را دفن کنم. پس از دفن پدرم مراجعت خواهم کرد.» ");
INSERT INTO pesopcb_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","فرعون موافقت کرد و به یوسف گفت: «برو و همان‌طوری که قول داده‌ای پدرت را دفن کن.» ");
INSERT INTO pesopcb_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","پس یوسف روانه شد تا پدرش را دفن کند. تمام مشاوران فرعون، بزرگان خاندان فرعون، و همۀ بزرگان سرزمین مصر همراه وی رفتند. ");
INSERT INTO pesopcb_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","یوسف همچنین همۀ اهل خانۀ خود و برادرانش و اهل خانۀ پدرش را نیز با خود برد. اما بچه‌ها و گله‌ها و رمه‌هایشان در جوشن ماندند. ");
INSERT INTO pesopcb_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","ارابه‌ها و سواران نیز آنها را همراهی می‌کردند. به این ترتیب گروه عظیمی راهی کنعان شد. ");
INSERT INTO pesopcb_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","وقتی که به خرمنگاه اطاد در آن طرف رود اردن رسیدند، با صدای بلند گریستند و به نوحه‌گری پرداختند و یوسف برای پدرش هفت روز ماتم گرفت. ");
INSERT INTO pesopcb_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","کنعانی‌های ساکن اطاد چون این سوگواری را دیدند آن محل را آبِل مِصرایِم نامیدند و گفتند: «اینجا مکانی است که مصری‌ها ماتمی عظیم گرفتند.» ");
INSERT INTO pesopcb_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","بدین ترتیب، پسران یعقوب همان‌طور که او به ایشان وصیت کرده بود، عمل کردند: ");
INSERT INTO pesopcb_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","بدن او را به سرزمین کنعان برده، در غاری دفن کردند که در زمین مکفیله در نزدیکی ممری بود و ابراهیم آن را با مزرعه‌اش از عفرون حیتّی خریده بود تا مقبرۀ خانوادگی‌اش باشد. ");
INSERT INTO pesopcb_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","یوسف پس از دفن پدرش، با برادران و همهٔ کسانی که همراه او رفته بودند به مصر بازگشت. ");
INSERT INTO pesopcb_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","وقتی برادران یوسف دیدند که پدرشان مرده است، به یکدیگر گفتند: «حالا یوسف انتقام همهٔ بدیهایی را که به او روا داشتیم از ما خواهد گرفت.» ");
INSERT INTO pesopcb_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","پس این پیغام را برای یوسف فرستادند: «پدرت قبل از این که بمیرد چنین وصیت کرد: ");
INSERT INTO pesopcb_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","”به یوسف بگویید: از تو تمنا دارم از سر تقصیر برادرانت بگذری و گناهشان را ببخشی، زیرا که به تو بدی کرده‌اند.“ حال ما، بندگان خدای پدرت، التماس می‌کنیم که ما را ببخشی.» وقتی که یوسف این پیغام را شنید گریست. ");
INSERT INTO pesopcb_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","آنگاه برادرانش آمده، به پای او افتادند و گفتند: «ما غلامان تو هستیم.» ");
INSERT INTO pesopcb_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","اما یوسف به ایشان گفت: «از من نترسید. مگر من خدا هستم؟ ");
INSERT INTO pesopcb_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","هر چند شما به من بدی کردید، اما خدا عمل بد شما را برای من به نیکی مبدل نمود و چنانکه می‌بینید مرا به این مقام رسانیده است تا افراد بی‌شماری را از مرگِ ناشی از گرسنگی نجات دهم. ");
INSERT INTO pesopcb_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","پس نترسید. من از شما و خانواده‌های شما مواظبت خواهم کرد.» او با آنها به مهربانی سخن گفت و خیال آنها آسوده شد. ");
INSERT INTO pesopcb_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","یوسف و برادرانش و خانواده‌های آنها مثل سابق به زندگی خود در مصر ادامه دادند. یوسف صد و ده سال زندگی کرد. ");
INSERT INTO pesopcb_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","او توانست سومین نسل فرزندانِ افرایم را ببیند، و نیز شاهد تولد فرزندان ماخیر، پسر منسی که فرزندان یوسف محسوب می‌شدند، باشد. ");
INSERT INTO pesopcb_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","یوسف به برادران خود گفت: «من به‌زودی می‌میرم، ولی بدون شک خدا شما را از مصر به کنعان، سرزمینی که وعدهٔ آن را به نسل ابراهیم و اسحاق و یعقوب داده است، خواهد برد.» ");
INSERT INTO pesopcb_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","سپس یوسف برادرانش را قسم داده، گفت: «هنگامی که خدا شما را به کنعان می‌برد، استخوانهای مرا نیز با خود ببرید.» ");
INSERT INTO pesopcb_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","یوسف در سن صد و ده سالگی در مصر درگذشت و جسد او را مومیایی کرده در تابوتی قرار دادند.");
INSERT INTO pesopcb_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","این است نامهای پسران اسرائیل (همان یعقوب است) که با خانواده‌های خود همراه وی به مصر مهاجرت کردند: ");
INSERT INTO pesopcb_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","رئوبین، شمعون، لاوی، یهودا، ");
INSERT INTO pesopcb_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","یساکار، زبولون، بنیامین، ");
INSERT INTO pesopcb_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","دان، نفتالی، جاد و اشیر. ");
INSERT INTO pesopcb_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","کسانی که به مصر رفتند هفتاد نفر بودند. (یوسف پیش از آن به مصر رفته بود.) ");
INSERT INTO pesopcb_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","سالها گذشت و در این مدت یوسف و برادران او و تمام افراد آن نسل مردند. ");
INSERT INTO pesopcb_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","ولی فرزندانی که از نسل ایشان به دنیا آمدند به سرعت زیاد شدند و قومی بزرگ تشکیل دادند تا آنجا که سرزمین مصر از ایشان پر شد. ");
INSERT INTO pesopcb_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","سپس، پادشاهی در مصر روی کار آمد که یوسف را نمی‌شناخت و از خدمات او خبر نداشت. ");
INSERT INTO pesopcb_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","او به مردم گفت: «تعداد بنی‌اسرائیل در سرزمین ما روز‌به‌روز زیادتر می‌شود و ممکن است برای ما وضع خطرناکی پیش بیاورند. ");
INSERT INTO pesopcb_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","بنابراین بیایید چاره‌ای بیندیشیم و گرنه تعدادشان زیادتر خواهد شد و در صورت بروز جنگ، آنها به دشمنان ما ملحق شده بر ضد ما خواهند جنگید و از سرزمین ما فرار خواهند کرد.» ");
INSERT INTO pesopcb_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","پس مصری‌ها، قوم اسرائیل را بردهٔ خود ساختند و مأمورانی بر ایشان گماشتند تا با کار اجباری، آنها را زیر فشار قرار دهند. اسرائیلی‌ها شهرهای فیتوم و رَمِسیس را برای فرعون ساختند تا از آنها به صورت انبار آذوقه استفاده کند. ");
INSERT INTO pesopcb_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","با وجود فشار روزافزون مصری‌ها، تعداد اسرائیلی‌ها روز‌به‌روز افزایش می‌یافت. این امر مصری‌ها را به وحشت انداخت. ");
INSERT INTO pesopcb_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","بنابراین، آنها را بیشتر زیر فشار قرار دادند، ");
INSERT INTO pesopcb_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","به طوری که قوم اسرائیل از عذاب بردگی جانشان به لب رسید، چون مجبور بودند در بیابان کارهای طاقت‌فرسا انجام دهند و برای ساختن آن شهرها، خشت و گل تهیه کنند. ");
INSERT INTO pesopcb_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","از این گذشته، فرعون، پادشاه مصر، به شفره و فوعه، قابله‌های عبرانی دستور داده، ");
INSERT INTO pesopcb_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","گفت: «وقتی به هنگام زایمان زنان عبرانی به آنها کمک می‌کنید تا فرزندشان را به دنیا بیاورند، ببینید اگر پسر بود، او را بکشید؛ ولی اگر دختر بود زنده نگه دارید.» ");
INSERT INTO pesopcb_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","اما قابله‌ها از خدا ترسیدند و دستور فرعون را اطاعت نکردند و نوزادان پسر را هم زنده نگه داشتند. ");
INSERT INTO pesopcb_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","پس فرعون ایشان را احضار کرد و پرسید: «چرا از دستور من سرپیچی کردید؟ چرا پسران اسرائیلی را نکشتید؟» ");
INSERT INTO pesopcb_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","آنها جواب دادند: «ای پادشاه، زنان اسرائیلی مثل زنان مصری ناتوان نیستند؛ آنها پیش از رسیدن قابله وضع حمل می‌کنند.» ");
INSERT INTO pesopcb_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","پس لطف خدا شامل حال این قابله‌ها شد و تعداد بنی‌اسرائیل افزوده شد و قدرتشان نیز بیشتر شد. ");
INSERT INTO pesopcb_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","و چون قابله‌ها از خدا ترسیدند، خدا نیز آنان را صاحب خانواده ساخت. ");
INSERT INTO pesopcb_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","پس فرعون بار دیگر به قوم خود چنین دستور داد: «از این پس هر نوزاد پسر اسرائیلی را در رود نیل بیندازید؛ اما دختران را زنده نگه دارید.» ");
INSERT INTO pesopcb_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","در آن زمان مردی از قبیلهٔ لاوی، یکی از دختران قبیله خود را به زنی گرفت. ");
INSERT INTO pesopcb_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","آن زن حامله شده پسری به دنیا آورد. آن پسر بسیار زیبا بود، پس مادرش او را تا مدت سه ماه از دید مردم پنهان کرد. ");
INSERT INTO pesopcb_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","اما وقتی نتوانست بیش از آن او را پنهان کند، از نی سبدی ساخت و آن را قیراندود کرد تا آب داخل سبد نشود. سپس، پسرش را در آن گذاشت و آن را در میان نیزارهای رود نیل رها ساخت. ");
INSERT INTO pesopcb_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","ولی خواهر آن کودک از دور مراقب بود تا ببیند چه بر سر او می‌آید. ");
INSERT INTO pesopcb_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","در همین هنگام دختر فرعون برای شستشو به رود نیل آمد. دو کنیز او هم در کنارۀ رود می‌گشتند. دختر فرعون ناگهان چشمش به سبد افتاد، پس یکی از کنیزان را فرستاد تا آن سبد را از آب بگیرد. ");
INSERT INTO pesopcb_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","هنگامی که سرپوش سبد را برداشت چشمش به کودکی گریان افتاد و دلش به حال او سوخت و گفت: «این بچه باید متعلق به عبرانی‌ها باشد.» ");
INSERT INTO pesopcb_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","همان وقت خواهر کودک نزد دختر فرعون رفت و پرسید: «آیا می‌خواهید بروم و یکی از زنان شیرده عبرانی را بیاورم تا به این کودک شیر دهد؟» ");
INSERT INTO pesopcb_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","دختر فرعون گفت: «برو!» آن دختر به خانه شتافت و مادرش را آورد. ");
INSERT INTO pesopcb_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","دختر فرعون به آن زن گفت: «این کودک را به خانه‌ات ببر و او را شیر بده و برای من بزرگش کن، و من برای این کار به تو مزد می‌دهم.» پس آن زن، کودک خود را به خانه برد و به شیر دادن و پرورش او پرداخت. ");
INSERT INTO pesopcb_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","وقتی کودک بزرگتر شد، مادرش او را پیش دختر فرعون برد. دختر فرعون کودک را به فرزندی قبول کرد و او را موسی یعنی «از آب گرفته شده» نامید. ");
INSERT INTO pesopcb_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","سالها گذشت و موسی بزرگ شد. روزی او به دیدن قوم خود یعنی عبرانی‌ها رفت. هنگامی که چشم بر کارهای سخت قوم خود دوخته بود، یک مصری را دید که یکی از عبرانی‌ها را کتک می‌زند. ");
INSERT INTO pesopcb_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","آنگاه به اطراف خود نگاه کرد و چون کسی را ندید، مرد مصری را کشت و جسدش را زیر شنها پنهان نمود. ");
INSERT INTO pesopcb_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","روز بعد، باز موسی به دیدن قومش رفت. این بار دو نفر عبرانی را دید که با هم گلاویز شده‌اند. جلو رفت و به مردی که دیگری را می‌زد، گفت: «چرا برادر خود را می‌زنی؟» ");
INSERT INTO pesopcb_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","آن مرد گفت: «چه کسی تو را حاکم و داور ما ساخته است؟ آیا می‌خواهی مرا هم بکشی، همان‌طور که آن مصری را کشتی؟» وقتی موسی فهمید که کشته شدن آن مصری به دست او آشکار شده است، ترسید. ");
INSERT INTO pesopcb_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","هنگامی که خبر کشته شدن آن مصری به گوش فرعون رسید، دستور داد موسی را بگیرند و بکشند. اما موسی به سرزمین مدیان فرار کرد. روزی در آنجا سرچاهی نشسته بود. ");
INSERT INTO pesopcb_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","هفت دختر یترون، کاهن مدیان آمدند تا از چاه، آب بکشند و آبشخورها را پر کنند تا گلهٔ پدرشان را سیراب نمایند. ");
INSERT INTO pesopcb_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","ولی چند چوپان آمدند و دختران یترون را از سر چاه کنار زدند تا گله‌های خود را سیراب کنند. اما موسی جلو رفت و آنها را عقب راند و به دختران کمک کرد تا گوسفندانشان را آب دهند. ");
INSERT INTO pesopcb_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","هنگامی که دختران به خانه بازگشتند، پدرشان رِعوئیل پرسید: «چطور شد که امروز اینقدر زود برگشتید؟» ");
INSERT INTO pesopcb_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","گفتند: «یک مرد مصری به ما کمک کرد و چوپانان را کنار زد و برایمان از چاه آب کشید و گله را سیراب کرد.» ");
INSERT INTO pesopcb_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","پدرشان پرسید: «آن مرد حالا کجاست؟ چرا او را با خود نیاوردید؟ بروید و او را دعوت کنید تا با ما غذا بخورد.» ");
INSERT INTO pesopcb_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","موسی دعوت او را قبول کرد و از آن پس در خانهٔ آنها ماند. یَترون هم دختر خود صفوره را به عقد موسی درآورد. ");
INSERT INTO pesopcb_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","صفوره برای موسی پسری زایید و موسی که در آن دیار غریب بود، به همین دلیل او را جرشوم (یعنی «غریب») نامید. ");
INSERT INTO pesopcb_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","سالها گذشت و پادشاه مصر مرد. اما بنی‌اسرائیل همچنان در بردگی به سر می‌بردند و از ظلمی که به آنان می‌شد، می‌نالیدند و از خدا کمک می‌خواستند. ");
INSERT INTO pesopcb_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","خدا نالهٔ ایشان را شنید و عهد خود را با اجدادشان یعنی ابراهیم و اسحاق و یعقوب به یاد آورد. ");
INSERT INTO pesopcb_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","پس خدا از روی لطف بر ایشان نظر کرد و تصمیم گرفت آنها را از اسارت و بردگی نجات دهد. ");
INSERT INTO pesopcb_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","روزی هنگامی که موسی مشغول چرانیدن گلهٔ پدرزن خود یَترون، کاهن مدیان بود، گله را به آن سوی بیابان، به طرف کوه حوریب، معروف به کوه خدا راند. ");
INSERT INTO pesopcb_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","ناگهان فرشتهٔ خداوند از درون بوته‌ای مشتعل بر او ظاهر شد. موسی دید که بوته شعله‌ور است، ولی نمی‌سوزد. ");
INSERT INTO pesopcb_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","با خود گفت: «عجیب است! چرا بوته نمی‌سوزد؟» پس نزدیک رفت تا علّتش را بفهمد. ");
INSERT INTO pesopcb_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","وقتی خداوند دید که موسی به بوته نزدیک می‌شود، از میان بوته ندا داد: «موسی! موسی!» موسی جواب داد: «بله، می‌شنوم!» ");
INSERT INTO pesopcb_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","خدا فرمود: «بیش از این نزدیک نشو! کفشهایت را درآور، زیرا جایی که بر آن ایستاده‌ای، زمین مقدّس است. ");
INSERT INTO pesopcb_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","من هستم خدای اجدادت، خدای ابراهیم، خدای اسحاق و خدای یعقوب.» موسی روی خود را پوشاند، چون ترسید به خدا نگاه کند. ");
INSERT INTO pesopcb_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","خداوند فرمود: «من رنج و مصیبت قوم خود را در مصر دیده‌ام و ناله‌هایشان را برای رهایی از بردگی شنیده‌ام. بله، من از رنجشان آگاهم. ");
INSERT INTO pesopcb_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","اکنون نزول کرده‌ام تا آنها را از چنگ مصری‌ها آزاد کنم و ایشان را از مصر بیرون آورده، به سرزمین خوب و پهناوری که در آن شیر و عسل جاری است ببرم، سرزمینی که اینک قبایل کنعانی، حیتّی، اموری، فرزّی، حوّی و یبوسی در آن زندگی می‌کنند. ");
INSERT INTO pesopcb_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","آری، ناله‌های بنی‌اسرائیل به گوش من رسیده است و ظلمی که مصری‌ها به ایشان می‌کنند، از نظر من پنهان نیست. ");
INSERT INTO pesopcb_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","حال، تو را نزد فرعون می‌فرستم تا قوم من بنی‌اسرائیل را از مصر بیرون آوری.» ");
INSERT INTO pesopcb_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","موسی گفت: «خدایا، من کیستم که نزد فرعون بروم و بنی‌اسرائیل را از مصر بیرون آورم؟» ");
INSERT INTO pesopcb_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","خدا فرمود: «من با تو خواهم بود و وقتی بنی‌اسرائیل را از مصر بیرون آوردی، در همین کوه مرا عبادت خواهید کرد. این نشانه‌ای خواهد بود که من تو را فرستاده‌ام.» ");
INSERT INTO pesopcb_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","موسی عرض کرد: «اگر نزد بنی‌اسرائیل بروم و به ایشان بگویم که خدای اجدادشان، مرا برای نجات ایشان فرستاده است، و آنها از من بپرسند: ”نام او چیست؟“ به آنها چه جواب دهم؟» ");
INSERT INTO pesopcb_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","خدا فرمود: «هستم آنکه هستم! به ایشان بگو ”هستم“ مرا نزد شما فرستاده است.» ");
INSERT INTO pesopcb_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","و باز خدا به موسی گفت: «به بنی‌اسرائیل بگو: ”یهوه، خدای اجداد شما، خدای ابراهیم، خدای اسحاق و خدای یعقوب مرا نزد شما فرستاده است.“ «این نام جاودانهٔ من است و تمام نسلها مرا به این نام خواهند شناخت. ");
INSERT INTO pesopcb_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","«حال، برو و تمام مشایخ اسرائیل را جمع کن و به ایشان بگو: ”یهوه، خدای اجداد شما، خدای ابراهیم، اسحاق و یعقوب بر من ظاهر شد و فرمود: من از نزدیک مشاهده کرده و دیده‌ام چگونه مصری‌ها با شما رفتار کرده‌اند. ");
INSERT INTO pesopcb_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","من وعده داده‌ام که شما را از سختیهایی که در مصر می‌کشید، آزاد کنم و به سرزمینی ببرم که در آن شیر و عسل جاری است، سرزمینی که اینک کنعانی‌ها، حیتی‌ها، اموری‌ها، فرزی‌ها، حوی‌ها و یبوسی‌ها در آن زندگی می‌کنند.“ ");
INSERT INTO pesopcb_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","«مشایخ اسرائیل سخن تو را خواهند پذیرفت. تو همراه آنان به حضور پادشاه مصر برو و به او بگو: ”یهوه، خدای عبرانی‌ها، از ما دیدار کرده است. اجازه بده به فاصلهٔ سه روز راه، به صحرا برویم و در آنجا به یهوه، خدای خود قربانی تقدیم کنیم.“ ");
INSERT INTO pesopcb_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","«ولی من می‌دانم که پادشاه مصر اجازه نخواهد داد که بروید، مگر آن که دستی نیرومند او را مجبور سازد. ");
INSERT INTO pesopcb_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","پس من دست خود را بلند کرده، مصری‌ها را با انجام همه نوع معجزات در میانشان خواهم زد. پس از آن او شما را رها خواهد کرد. ");
INSERT INTO pesopcb_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","من کاری می‌کنم که مصری‌ها برای شما احترام قائل شوند، به طوری که وقتی آن سرزمین را ترک می‌گویید، تهیدست نخواهید رفت. ");
INSERT INTO pesopcb_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","هر زن اسرائیلی از همسایۀ مصری خود و از بانوی میهمان در خانه‌اش اجناسی از نقره و طلا و لباس خواهد خواست. شما آنها را بر پسران و دخترانتان خواهید پوشاند. به این ترتیب شما مصری‌ها را غارت خواهید کرد.» ");
INSERT INTO pesopcb_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","آنگاه موسی به خدا گفت: «اگر بنی‌اسرائیل سخنان مرا باور نکنند و به من گوش ندهند و بگویند: ”چگونه بدانیم که خداوند به تو ظاهر شده است؟“ من به آنان چه جواب دهم؟» ");
INSERT INTO pesopcb_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","خداوند از موسی پرسید: «در دستت چه داری؟» جواب داد: «عصا.» ");
INSERT INTO pesopcb_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","خداوند فرمود: «آن را روی زمین بینداز!» وقتی موسی عصا را بر زمین انداخت، ناگهان عصا به ماری تبدیل شد و موسی از آن فرار کرد! ");
INSERT INTO pesopcb_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","خداوند فرمود: «دستت را دراز کن و دمش را بگیر!» موسی دست خود را دراز کرد و دم مار را گرفت و مار دوباره در دستش به عصا تبدیل شد! ");
INSERT INTO pesopcb_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","آنگاه خداوند فرمود: «این کار را بکن تا سخنان تو را باور کنند و بدانند که خداوند، خدای اجدادشان ابراهیم، اسحاق و یعقوب بر تو ظاهر شده است.» ");
INSERT INTO pesopcb_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","سپس خداوند فرمود: «دستت را داخل ردایت ببر!» موسی دستش را داخل ردایش برد و همین که آن را بیرون آورد، دید که دستش بر اثر جذام مثل برف سفید شده است. ");
INSERT INTO pesopcb_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","او گفت: «حالا دستت را دوباره داخل ردایت ببر!» وقتی موسی بار دیگر دستش را داخل ردایش برد و آن را بیرون آورد، دید که دستش دوباره صحیح و سالم است. ");
INSERT INTO pesopcb_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","آنگاه خداوند به موسی فرمود: «اگر چنانچه مردم معجزهٔ اول را باور نکنند، دومی را باور خواهند کرد. ");
INSERT INTO pesopcb_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","اما اگر پس از این دو معجزه باز سخنان تو را قبول نکردند، آنگاه از آب رود نیل بردار و روی خشکی بریز. آب به خون تبدیل خواهد شد!» ");
INSERT INTO pesopcb_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","موسی گفت: «خداوندا، من هرگز سخنور خوبی نبوده‌ام، نه در سابق و نه اکنون که با من سخن گفته‌ای. گفتار و زبان من کند است.» ");
INSERT INTO pesopcb_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","خداوند فرمود: «چه کسی زبان به انسان بخشیده است؟ گنگ و کر و بینا و نابینا را چه کسی آفریده است؟ آیا نه من که خداوند هستم؟ ");
INSERT INTO pesopcb_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","بنابراین، برو و من به تو قدرت بیان خواهم داد و هر آنچه باید بگویی به تو خواهم آموخت.» ");
INSERT INTO pesopcb_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","اما موسی گفت: «خداوندا، تمنا می‌کنم کس دیگری را به جای من بفرست.» ");
INSERT INTO pesopcb_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","پس خداوند بر موسی خشمگین شد و فرمود: «برادرت هارونِ لاوی سخنور خوبی است و اکنون می‌آید تا تو را ببیند. او از دیدنت خوشحال خواهد شد. ");
INSERT INTO pesopcb_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","آنچه را که باید بیان کنی به هارون بگو تا از طرف تو بگوید. من به هر دوی شما قدرت بیان خواهم بخشید و به شما خواهم گفت که چه باید بکنید. ");
INSERT INTO pesopcb_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","او در برابر مردم سخنگوی تو خواهد بود و تو برای او چون خدا خواهی بود و هر چه را که به او بگویی بیان خواهد کرد. ");
INSERT INTO pesopcb_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","این عصا را نیز همراه خود ببر تا با آن معجزاتی را که به تو نشان دادم ظاهر سازی.» ");
INSERT INTO pesopcb_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","موسی نزد پدرزن خود یترون بازگشت و به او گفت: «اجازه بده تا به نزد بستگانم در مصر برگردم و ببینم آنها زنده‌اند یا نه.» یترون گفت: «برو به سلامت.» ");
INSERT INTO pesopcb_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","پیش از آنکه موسی سرزمین مدیان را ترک کند، خداوند به او گفت: «به مصر برو، چون کسانی که می‌خواستند تو را بکشند، دیگر زنده نیستند.» ");
INSERT INTO pesopcb_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","پس، موسی «عصای خدا» را در دست گرفت و زن و فرزندان خود را برداشت و آنان را بر الاغ سوار کرده، به مصر بازگشت. ");
INSERT INTO pesopcb_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","خداوند به او فرمود: «وقتی به مصر رسیدی، نزد فرعون برو و معجزاتی را که به تو نشان داده‌ام در حضور او ظاهر کن. ولی من قلب فرعون را سخت می‌سازم تا بنی‌اسرائیل را رها نکند. ");
INSERT INTO pesopcb_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","به او بگو که خداوند می‌فرماید: ”اسرائیل، پسر ارشد و نخستزادۀ من است؛ ");
INSERT INTO pesopcb_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","بنابراین، به تو دستور می‌دهم بگذاری او از مصر خارج شود و مرا عبادت کند. اگر سرپیچی کنی، پسر ارشد تو را خواهم کشت.“» ");
INSERT INTO pesopcb_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","پس موسی و خانواده‌اش به سوی مصر رهسپار شدند. در بین راه وقتی استراحت می‌کردند، خداوند به او ظاهر شد و او را به مرگ تهدید کرد. ");
INSERT INTO pesopcb_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","اما صفوره، زن موسی، یک سنگ تیز گرفت و پسرش را ختنه کرد و با پوست اضافی پای موسی را لمس کرد و گفت: «بدون شک تو برای من داماد خون هستی.» ");
INSERT INTO pesopcb_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","(«داماد خون» اشاره‌ای بود به ختنه). بنابراین، خدا از کشتن موسی چشم پوشید. ");
INSERT INTO pesopcb_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","آنگاه خداوند به هارون فرمود تا به استقبال برادرش موسی به صحرا برود. پس هارون به سوی کوه حوریب که به «کوه خدا» معروف است، روانه شد. وقتی آن دو به هم رسیدند، یکدیگر را بوسیدند. ");
INSERT INTO pesopcb_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","سپس، موسی برای هارون تعریف کرد که خداوند به او چه دستورهایی داده، و چه معجزاتی باید در حضور پادشاه مصر انجام دهد. ");
INSERT INTO pesopcb_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","سپس موسی و هارون به مصر بازگشتند و تمام مشایخ بنی‌اسرائیل را جمع کردند. ");
INSERT INTO pesopcb_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","هارون هر چه را که خداوند به موسی فرموده بود، برای ایشان تعریف کرد و موسی نیز معجزات را به آنها نشان داد. ");
INSERT INTO pesopcb_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","آنگاه قوم اسرائیل باور کردند که آنها فرستادگان خدا هستند، و هنگامی که شنیدند خداوند به مصیبتهای ایشان توجه فرموده و می‌خواهد آنها را نجات دهد، خم شده، خدا را عبادت کردند. ");
INSERT INTO pesopcb_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","پس از دیدار با بزرگان قوم، موسی و هارون نزد فرعون رفتند و به او گفتند: «ما از جانب یهوه خدای اسرائیل پیامی برای تو آورده‌ایم. او می‌فرماید: ”قوم مرا رها کن تا به بیابان بروند و مراسم عید را برای پرستش من بجا آورند.“» ");
INSERT INTO pesopcb_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","فرعون گفت: «یهوه کیست که من به حرفهایش گوش بدهم و بنی‌اسرائیل را آزاد کنم؟ من خداوند را نمی‌شناسم و بنی‌اسرائیل را نیز آزاد نمی‌کنم.» ");
INSERT INTO pesopcb_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","موسی و هارون گفتند: «خدای عبرانی‌ها ما را ملاقات کرده است. اکنون به ما اجازه بده که یک سفر سه روزه، به بیابان برویم و در آنجا برای خداوند خدای خود قربانی کنیم و گرنه او ما را به‌وسیله بلا یا شمشیر خواهد کشت.» ");
INSERT INTO pesopcb_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","پادشاه مصر به موسی و هارون گفت: «چرا بنی‌اسرائیل را از کارشان باز می‌دارید؟ به کار خود برگردید! ");
INSERT INTO pesopcb_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","حال که تعدادتان زیاد شده است، می‌خواهید دست از کار بکشید؟» ");
INSERT INTO pesopcb_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","در آن روز فرعون به سرکارگران مصری و ناظران اسرائیلی خود چنین دستور داد: ");
INSERT INTO pesopcb_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","«از این پس به اسرائیلی‌ها برای تهیه خشت، کاه ندهید؛ آنها باید خودشان کاه جمع کنند. ");
INSERT INTO pesopcb_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","اما تعداد خشتها نیز نباید کمتر شود. پیداست به اندازه کافی کار ندارند و گرنه فکر رفتن و قربانی کردن به سرشان نمی‌زد. ");
INSERT INTO pesopcb_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","چنان از آنها کار بکشید که فرصتی برای گوش دادن به حرفهای بیهوده نداشته باشند.» ");
INSERT INTO pesopcb_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","پس ناظران و سرکارگران به قوم اسرائیل گفتند: «به فرمان فرعون از این پس به شما برای تهیه خشت، کاه داده نخواهد شد. ");
INSERT INTO pesopcb_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","خودتان بروید و از هر جا که می‌خواهید کاه جمع کنید و از آن خشت بسازید. مقدار خشتها نیز نباید از گذشته کمتر باشد.» ");
INSERT INTO pesopcb_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","پس، بنی‌اسرائیل در سراسر مصر پراکنده شدند تا پوشال برای تهیۀ کاه جمع کنند. ");
INSERT INTO pesopcb_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","در این میان، ناظران مصری نیز بر آنها فشار می‌آوردند تا به همان اندازهٔ سابق خشت تولید کنند ");
INSERT INTO pesopcb_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","و سرکارگران اسرائیلی را می‌زدند و می‌گفتند: «چرا کارتان را مثل گذشته انجام نمی‌دهید؟» ");
INSERT INTO pesopcb_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","سرکارگران اسرائیلی نزد فرعون رفتند و شکایت کرده، گفتند: «چرا با ما اینچنین رفتار می‌شود؟ ");
INSERT INTO pesopcb_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","ناظران به ما کاه نمی‌دهند و انتظار دارند به اندازهٔ گذشته خشت تولید کنیم! آنها بی‌سبب ما را می‌زنند، در حالی که ما تقصیری نداریم، بلکه خودشان مقصرند.» ");
INSERT INTO pesopcb_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","فرعون گفت: «شما تنبلید! تنبل! و گرنه نمی‌گفتید: ”اجازه بده برویم و برای خداوند قربانی کنیم.“ ");
INSERT INTO pesopcb_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","حال به سر کارتان بازگردید، همان‌طور که دستور داده‌ام کاه به شما داده نخواهد شد و به اندازهٔ گذشته باید خشت تحویل بدهید.» ");
INSERT INTO pesopcb_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","سرکارگران اسرائیلی وقتی سخنان فرعون را شنیدند که نباید از تعداد خشتها چیزی کم شود، فهمیدند در وضع بدی گرفتار شده‌اند. ");
INSERT INTO pesopcb_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","وقتی آنها از قصر فرعون بیرون می‌آمدند، به موسی و هارون که بیرون قصر منتظر ایستاده بودند، برخوردند. ");
INSERT INTO pesopcb_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","پس به ایشان گفتند: «خداوند داد ما را از شما بگیرد که همهٔ ما را از چشم فرعون و درباریانش انداختید و بهانه‌ای به دست ایشان دادید تا ما را بکشند.» ");
INSERT INTO pesopcb_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","پس، موسی نزد خداوند آمد و گفت: «خداوندا، چرا قوم خود را با سختیها مواجه می‌کنی؟ آیا برای همین مرا فرستادی؟ ");
INSERT INTO pesopcb_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","از وقتی که پیغام تو را به فرعون رسانده‌ام، بر این قوم ظلم می‌کند و تو هم به داد ایشان نمی‌رسی.» ");
INSERT INTO pesopcb_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","خداوند به موسی فرمود: «اکنون خواهی دید که با فرعون چه می‌کنم! من او را چنان در فشار می‌گذارم که نه فقط قوم مرا رها کند، بلکه ایشان را به زور از مصر بیرون براند.» ");
INSERT INTO pesopcb_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","خدا همچنین به موسی گفت: «من یهوه هستم. ");
INSERT INTO pesopcb_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","من بر ابراهیم، اسحاق و یعقوب با نام خدای قادر مطلق ظاهر شدم، ولی خود را با نام یهوه به آنان نشناساندم. ");
INSERT INTO pesopcb_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","من با آنها عهد بستم که سرزمین کنعان را که در آنجا غریب بودند، به ایشان ببخشم. ");
INSERT INTO pesopcb_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","من ناله‌های بنی‌اسرائیل را که در مصر اسیرند، شنیدم و عهد خود را به یاد آوردم. ");
INSERT INTO pesopcb_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","پس برو و به بنی‌اسرائیل بگو: ”من یهوه هستم و شما را از ظلم و ستم رهایی خواهم داد. من شما را از بردگی در مصر نجات خواهم بخشید و با بازوی قدرتمند و داوری‌های عظیم شما را خواهم رهانید. ");
INSERT INTO pesopcb_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","شما را قوم خود خواهم ساخت و خدای شما خواهم بود. آنگاه خواهید دانست که من یهوه، خدای شما هستم که شما را از دست مصری‌ها نجات دادم. ");
INSERT INTO pesopcb_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","من شما را به سرزمینی خواهم برد که وعدهٔ آن را به اجدادتان ابراهیم و اسحاق و یعقوب دادم و آن سرزمین را میراث شما خواهم ساخت. من یهوه هستم.“» ");
INSERT INTO pesopcb_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","موسی آنچه را که خدا فرموده بود به بنی‌اسرائیل بازگفت، ولی ایشان که به سبب سختی کار طاقتشان به سر رسیده بود، به سخنان او اعتنا نکردند. ");
INSERT INTO pesopcb_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","آنگاه خداوند به موسی فرمود: ");
INSERT INTO pesopcb_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","«بار دیگر نزد فرعون برو و به او بگو که باید قوم اسرائیل را رها کند تا از این سرزمین بروند.» ");
INSERT INTO pesopcb_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","موسی در جواب خداوند گفت: «وقتی قوم اسرائیل به گفته‌هایم اعتنا نمی‌کنند، چطور انتظار داشته باشم که فرعون به سخنانم گوش دهد؟ من سخنور خوبی نیستم.» ");
INSERT INTO pesopcb_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","خداوند به موسی و هارون امر فرمود که پیش بنی‌اسرائیل و پادشاه مصر بروند و بنی‌اسرائیل را از مصر بیرون آورند. ");
INSERT INTO pesopcb_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","اینها سران برخی خاندانهای اسرائیل هستند: رئوبین، پسر ارشد یعقوب چهار پسر داشت به نامهای حنوک، فلو، حصرون و کرمی. از هر یک از این افراد، طایفه‌ای به وجود آمد. ");
INSERT INTO pesopcb_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","شمعون شش پسر داشت به نامهای یموئیل، یامین، اوهَد، یاکین، صوحر و شائول. (مادر شائول کنعانی بود.) از هر یک از این افراد نیز طایفه‌ای به وجود آمد. ");
INSERT INTO pesopcb_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","لاوی سه پسر داشت که به ترتیب سن عبارت بودند از: جرشون، قهات و مراری. (لاوی صد و سی و هفت سال عمر کرد.) ");
INSERT INTO pesopcb_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","جرشون دو پسر داشت به نامهای لبنی و شمعی. از هر یک از این افراد خاندانی به وجود آمد. ");
INSERT INTO pesopcb_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","قهات چهار پسر داشت به نامهای عمرام، یصهار، حبرون و عزی‌ئیل. (قهات صد و سی و سه سال عمر کرد.) ");
INSERT INTO pesopcb_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","مراری دو پسر داشت به نامهای محلی و موشی. همه کسانی که در بالا به ترتیب سن نامشان آورده شد، طایفه‌های لاوی را تشکیل می‌دهند. ");
INSERT INTO pesopcb_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","عمرام با عمهٔ خود یوکابد ازدواج کرد و صاحب دو پسر شد به نامهای هارون و موسی. (عمرام صد و سی و هفت سال عمر کرد.) ");
INSERT INTO pesopcb_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","یصهار سه پسر داشت به نامهای قورح، نافج و زکری. ");
INSERT INTO pesopcb_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","عزی‌ئیل سه پسر داشت به نامهای میشائیل، ایلصافان و ستری. ");
INSERT INTO pesopcb_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","هارون با الیشابع دختر عمیناداب و خواهر نحشون ازدواج کرد. فرزندان هارون عبارت بودند از: ناداب، ابیهو، العازار و ایتامار. ");
INSERT INTO pesopcb_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","قورح سه پسر داشت به نامهای اسیر، القانه و ابیاساف. این افراد سران خاندانهای طایفۀ قورح هستند. ");
INSERT INTO pesopcb_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","العازار پسر هارون با یکی از دختران فوتی‌ئیل ازدواج کرد و صاحب پسری به نام فینحاس شد. اینها بودند سران خاندانها و طایفه‌های لاوی. ");
INSERT INTO pesopcb_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","هارون و موسی که اسامی آنها در بالا ذکر شد، همان هارون و موسی هستند که خداوند به ایشان فرمود تا تمام بنی‌اسرائیل را از مصر بیرون ببرند ");
INSERT INTO pesopcb_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","و ایشان نزد فرعون رفتند تا از او بخواهند قوم اسرائیل را رها کند. ");
INSERT INTO pesopcb_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","وقتی خداوند در سرزمین مصر با موسی سخن گفت، ");
INSERT INTO pesopcb_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","به او فرمود: «من یهوه هستم. پیغام مرا به فرعون، پادشاه مصر، برسان.» ");
INSERT INTO pesopcb_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","اما موسی به خداوند گفت: «من سخنور خوبی نیستم، چگونه انتظار داشته باشم پادشاه مصر به سخنانم گوش دهد؟» ");
INSERT INTO pesopcb_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","خداوند به موسی فرمود: «به آنچه می‌گویم توجه کن: من تو را در برابر فرعون خدا ساخته‌ام و برادرت هارون، نبی تو خواهد بود. ");
INSERT INTO pesopcb_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","هر چه به تو می‌گویم به هارون بگو تا آن را به فرعون بازگوید و از او بخواهد تا قوم اسرائیل را رها کند. ");
INSERT INTO pesopcb_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","ولی بدان که من قلب فرعون را سخت می‌کنم، تا معجزات زیاد و علامات شگفت‌انگیز خود را در مصر ظاهر نمایم، ");
INSERT INTO pesopcb_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","او باز به سخنانتان گوش نخواهد داد. اما من با ضربه‌ای مهلک بر مصر دست خواهم نهاد و با داوری‌های بزرگ خود، قوم خود، بنی‌اسرائیل را از مصر بیرون خواهم آورد. ");
INSERT INTO pesopcb_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","وقتی قدرت خود را به مصری‌ها نشان دادم و بنی‌اسرائیل را از مصر بیرون آوردم، آنگاه مصری‌ها خواهند فهمید که من خداوند هستم.» ");
INSERT INTO pesopcb_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","پس موسی و هارون آنچه را که خداوند فرموده بود، انجام دادند. ");
INSERT INTO pesopcb_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","زمانی که آنها پیش پادشاه مصر رفتند، موسی هشتاد سال داشت و برادرش هارون هشتاد و سه سال. ");
INSERT INTO pesopcb_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","خداوند به موسی و هارون فرمود: ");
INSERT INTO pesopcb_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","«این بار پادشاه مصر از شما معجزه‌ای خواهد خواست، پس هارون باید عصای خود را در حضور فرعون به زمین اندازد و عصا به مار تبدیل خواهد شد.» ");
INSERT INTO pesopcb_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","موسی و هارون باز پیش فرعون رفتند و همان‌طور که خداوند فرموده بود، هارون عصای خود را پیش پادشاه و درباریان او بر زمین انداخت و عصا به مار تبدیل شد. ");
INSERT INTO pesopcb_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","اما فرعون حکیمان و جادوگران مصری را فرا خواند و آنها نیز به کمک افسونهای خود همین عمل را انجام دادند. ");
INSERT INTO pesopcb_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","آنها عصاهای خود را به زمین انداختند و عصاهایشان به مار تبدیل شد! اما مار هارون، همهٔ مارهای جادوگران را بلعید. ");
INSERT INTO pesopcb_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","با وجود این معجزه، دل پادشاه مصر همچنان سخت ماند و همان‌طور که خداوند فرموده بود، به سخنان موسی و هارون اعتنایی نکرد. ");
INSERT INTO pesopcb_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","خداوند به موسی فرمود: «دل فرعون همچنان سخت است و هنوز هم حاضر نیست قوم مرا رها کند. ");
INSERT INTO pesopcb_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","فردا صبح عصایی را که به مار تبدیل شده بود به دست بگیر و کنار رود نیل برو و در آنجا منتظر فرعون باش. ");
INSERT INTO pesopcb_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","آنگاه به او بگو: ”یهوه، خدای عبرانی‌ها مرا نزد تو فرستاده است که بگویم قوم مرا رها کنی تا به صحرا بروند و او را عبادت کنند. تا به حال از دستور خدا اطاعت نکرده‌ای، ");
INSERT INTO pesopcb_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","پس اکنون خداوند چنین می‌فرماید: «کاری می‌کنم که بدانی من خداوند هستم.» من به دستور او، با ضربهٔ عصای خود، آب رود نیل را تبدیل به خون می‌کنم. ");
INSERT INTO pesopcb_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","تمام ماهیها خواهند مرد و آب خواهد گندید، به طوری که دیگر نتوانید از آب رودخانه جرعه‌ای بنوشید.“» ");
INSERT INTO pesopcb_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","سپس خداوند به موسی گفت: «به هارون بگو که عصای خود را به سوی تمام رودخانه‌ها، چشمه‌ها، جویها و حوضها دراز کند تا آب آنها به خون تبدیل شود. حتی آبهایی که در ظرفها و کوزه‌های خانه‌هاست به خون تبدیل خواهد شد.» ");
INSERT INTO pesopcb_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","موسی و هارون همان‌طور که خداوند فرموده بود، عمل کردند. هارون در حضور پادشاه مصر و همراهان او، با عصای خود ضربه‌ای به رود نیل زد و آب تبدیل به خون شد. ");
INSERT INTO pesopcb_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","تمام ماهیها مردند و آب گندید، و از آن پس مردم مصر نتوانستند از آب رود نیل بنوشند. در سراسر مصر به جای آب، خون بود. ");
INSERT INTO pesopcb_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","ولی جادوگران مصری هم با افسون خود توانستند آب را به خون تبدیل کنند. پس دل فرعون همچنان سخت ماند و همان‌طور که خداوند فرموده بود، به گفته‌های موسی و هارون اعتنایی نکرد. ");
INSERT INTO pesopcb_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","او بدون اینکه تحت تأثیر این معجزه قرار گیرد، به کاخ خود بازگشت. ");
INSERT INTO pesopcb_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","از آن پس مصری‌ها در کنارهٔ رود نیل چاه می‌کندند تا آب برای نوشیدن پیدا کنند، چون در رود به جای آب، خون جاری بود. ");
INSERT INTO pesopcb_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","از زمانی که خداوند رود نیل را زد یک هفته گذشت. ");
INSERT INTO pesopcb_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","خداوند به موسی فرمود: «پیش فرعون برگرد و به او بگو که خداوند چنین می‌فرماید: بگذار قوم من بروند و مرا عبادت کنند؛ ");
INSERT INTO pesopcb_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","و گرنه سرزمینت را پر از قورباغه خواهم نمود. ");
INSERT INTO pesopcb_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","رود نیل پر از قورباغه خواهد شد. قورباغه‌ها از رود بیرون آمده، به کاخ تو هجوم خواهند آورد و حتی وارد خوابگاه و بسترت خواهند شد! نیز به خانه‌های درباریان و تمام قوم تو رخنه خواهند کرد. آنها حتی تغارهای خمیر و تنورهای نانوایی را پر خواهند ساخت. ");
INSERT INTO pesopcb_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","قورباغه‌ها از سر و روی تو و مردم و درباریانت بالا خواهند رفت.» ");
INSERT INTO pesopcb_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","سپس خداوند به موسی فرمود: «به هارون بگو که عصای خود را به سوی رودخانه‌ها، چشمه‌ها و حوضها دراز کند تا قورباغه‌ها بیرون بیایند و همه جا را پر سازند.» ");
INSERT INTO pesopcb_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","پس هارون دستش را به سوی آبهای مصر دراز کرد و قورباغه‌ها بیرون آمده، سرزمین مصر را پوشاندند. ");
INSERT INTO pesopcb_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","ولی جادوگران مصری هم با جادوی خود، همین کار را کردند و قورباغه‌های بسیار زیادی پدید آوردند. ");
INSERT INTO pesopcb_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","پس فرعون، موسی و هارون را فرا خواند و گفت: «از خداوند درخواست کنید این قورباغه‌ها را از ما دور کند و من قول می‌دهم بنی‌اسرائیل را رها کنم تا بروند و برای خداوند قربانی کنند.» ");
INSERT INTO pesopcb_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","موسی در جواب فرعون گفت: «زمانی را معین کن تا برای تو و درباریان و قومت دعا کنم و تمام قورباغه‌ها به‌جز آنهایی که در رود نیل هستند نابود شوند.» ");
INSERT INTO pesopcb_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","فرعون گفت: «فردا.» موسی جواب داد: «این کار را خواهم کرد تا تو بدانی که هیچ‌کس مانند خدای ما یهوه نیست. ");
INSERT INTO pesopcb_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","تمام قورباغه‌ها از تو و خانه‌ات، و از درباریان و قومت دور خواهند شد. آنها فقط در رود نیل باقی خواهند ماند.» ");
INSERT INTO pesopcb_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","موسی و هارون از دربار فرعون بیرون آمدند و موسی از خداوند خواهش کرد تا قورباغه‌ها را از بین ببرد. ");
INSERT INTO pesopcb_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","خداوند هم دعای موسی را اجابت فرمود و تمام قورباغه‌ها در سراسر مصر مردند. ");
INSERT INTO pesopcb_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","مردم آنها را جمع کرده، روی هم انباشتند، آنچنان که بوی تعفن همه جا را فرا گرفت. ");
INSERT INTO pesopcb_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","اما وقتی قورباغه‌ها از بین رفتند، فرعون باز هم دل خود را سخت کرد و همان‌طور که خداوند فرموده بود راضی نشد قوم اسرائیل را رها کند. ");
INSERT INTO pesopcb_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","آنگاه خداوند به موسی فرمود: «به هارون بگو که عصای خود را به زمین بزند تا گرد و غبار در سراسر مصر به پشه تبدیل شود.» ");
INSERT INTO pesopcb_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","موسی و هارون همان‌طور که خداوند به ایشان فرموده بود عمل کردند. وقتی هارون عصای خود را به زمین زد انبوه پشه سراسر خاک مصر را فرا گرفت و پشه‌ها بر مردم و حیوانات هجوم بردند. ");
INSERT INTO pesopcb_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","جادوگران مصر هم سعی کردند همین کار را بکنند، ولی این بار موفق نشدند. ");
INSERT INTO pesopcb_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","پس به فرعون گفتند: «دست خدا در این کار است.» ولی همان‌طور که خداوند فرموده بود، دل فرعون باز نرم نشد و به موسی و هارون اعتنایی نکرد. ");
INSERT INTO pesopcb_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","پس خداوند به موسی فرمود: «صبح زود برخیز و به کنار رودخانه برو و منتظر فرعون باش. وقتی او به آنجا آید به او بگو که خداوند می‌فرماید: قوم مرا رها کن تا بروند و مرا عبادت کنند، ");
INSERT INTO pesopcb_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","و گرنه خانهٔ تو و درباریان و تمام مردم مصر را از مگس پر می‌کنم و زمین از مگس پوشیده خواهد شد. ");
INSERT INTO pesopcb_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","اما در سرزمین جوشن که محل سکونت بنی‌اسرائیل است، مگسی نخواهد بود تا بدانی که من خداوند این سرزمین هستم ");
INSERT INTO pesopcb_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","و بین قوم تو و قوم خود فرق می‌گذارم. این معجزه فردا ظاهر خواهد شد.» ");
INSERT INTO pesopcb_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","خداوند به طوری که فرموده بود، قصر فرعون و خانه‌های درباریان را پر از مگس کرد و در سراسر خاک مصر ویرانی به بار آمد. ");
INSERT INTO pesopcb_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","پس فرعون، موسی و هارون را فراخواند و به آنها گفت: «بسیار خوب، به شما اجازه می‌دهم که برای خدای خود قربانی کنید، ولی از مصر بیرون نروید.» ");
INSERT INTO pesopcb_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","موسی جواب داد: «ما نمی‌توانیم در برابر چشمان مصری‌ها حیواناتی که آنها از کشتنشان کراهت دارند، برای خداوند، خدای خود قربانی کنیم؛ چون ممکن است ما را سنگسار کنند. ");
INSERT INTO pesopcb_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","ما باید با یک سفر سه روزه، از مصر دور شویم و طبق دستور خداوند، در صحرا برای خداوند، خدای خود قربانی کنیم.» ");
INSERT INTO pesopcb_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","فرعون گفت: «من به شما اجازه می‌دهم تا به صحرا بروید و برای خداوند، خدای خود قربانی تقدیم کنید؛ ولی زیاد دور نشوید. حال، برای من دعا کنید.» ");
INSERT INTO pesopcb_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","موسی گفت: «وقتی از اینجا خارج شوم، نزد خداوند دعا خواهم کرد و فردا این بلا از تو و درباریان و مردم مصر دور خواهد شد. اما مواظب باش بار دیگر ما را فریب ندهی، بلکه بگذاری قوم من برود و برای خداوند قربانی تقدیم کند.» ");
INSERT INTO pesopcb_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","پس موسی از حضور فرعون بیرون رفت و نزد خداوند دعا کرد. ");
INSERT INTO pesopcb_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","خداوند دعای موسی را اجابت فرمود و تمام مگسها را از فرعون و قومش دور کرد، به طوری که حتی یک مگس هم باقی نماند. ");
INSERT INTO pesopcb_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","ولی این بار نیز دل فرعون نرم نشد و اجازه نداد قوم اسرائیل از مصر بیرون بروند. ");
INSERT INTO pesopcb_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","آنگاه خداوند به موسی فرمود: «نزد فرعون بازگرد و به او بگو که خداوند، خدای عبرانی‌ها می‌فرماید: قوم مرا رها کن تا بروند و مرا عبادت کنند، ");
INSERT INTO pesopcb_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","اگر همچنان آنها را نگه‌داری و نگذاری بروند ");
INSERT INTO pesopcb_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","بدان که دست خداوند تمام دامهایتان را از گله‌های اسب، الاغ، شتر، گاو و گوسفند، به مرضی جانکاه دچار خواهد کرد. ");
INSERT INTO pesopcb_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","من بین گله‌های مصری‌ها و گله‌های اسرائیلی‌ها فرق خواهم گذاشت، به طوری که به گله‌های اسرائیلی‌ها هیچ آسیبی نخواهد رسید. ");
INSERT INTO pesopcb_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","من این بلا را فردا بر شما نازل خواهم کرد.» ");
INSERT INTO pesopcb_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","روز بعد، خداوند همان‌طور که فرموده بود، عمل کرد. تمام گله‌های مصری‌ها مردند، ولی از چارپایان بنی‌اسرائیل حتی یکی هم تلف نشد. ");
INSERT INTO pesopcb_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","پس فرعون مأموری فرستاد تا تحقیق کند که آیا صحت دارد که از چارپایان بنی‌اسرائیل هیچ‌کدام نمرده‌اند. با این حال وقتی فهمید موضوع حقیقت دارد باز دلش نرم نشد و قوم خدا را رها نساخت. ");
INSERT INTO pesopcb_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","پس خداوند به موسی و هارون فرمود: «مشتهای خود را از خاکستر کوره پر کنید و موسی آن خاکستر را پیش فرعون به هوا بپاشد. ");
INSERT INTO pesopcb_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","آنگاه آن خاکستر مثل غبار، سراسر خاک مصر را خواهد پوشانید و بر بدن انسان و حیوان دملهای دردناک ایجاد خواهد کرد.» ");
INSERT INTO pesopcb_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","پس آنها خاکستر را برداشتند و به حضور فرعون ایستادند. موسی خاکستر را به هوا پاشید و روی بدن مصری‌ها و حیواناتشان دملهای دردناک درآمد، ");
INSERT INTO pesopcb_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","چنانکه جادوگران هم نتوانستند در مقابل موسی بایستند، زیرا آنها و تمام مصریان به این دملها مبتلا شده بودند. ");
INSERT INTO pesopcb_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","اما خداوند همان‌طور که قبلاً به موسی فرموده بود، دل فرعون را سخت کرد و او به سخنان موسی و هارون اعتنا ننمود. ");
INSERT INTO pesopcb_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","آنگاه خداوند به موسی فرمود: «صبح زود برخیز و در برابر فرعون بایست و بگو که خداوند، خدای عبرانی‌ها می‌فرماید: قوم مرا رها کن تا بروند و مرا عبادت کنند، ");
INSERT INTO pesopcb_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","و گرنه این بار بلایای بیشتری بر سر تو و درباریان و قومت خواهم آورد تا بدانید در تمامی جهان خدایی مانند من نیست. ");
INSERT INTO pesopcb_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","من تا حالا می‌توانستم دست خود را دراز کنم و چنان بلایی بر سر تو و قومت بیاورم که از روی زمین محو شوید. ");
INSERT INTO pesopcb_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","ولی تو را به این منظور زنده نگاه داشتم تا قدرت خود را به تو ظاهر کنم و تا نام من در میان تمامی مردم جهان شناخته شود. ");
INSERT INTO pesopcb_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","آیا هنوز هم مانع قوم من می‌شوی و نمی‌خواهی رهایشان کنی؟ ");
INSERT INTO pesopcb_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","بدان که فردا در همین وقت چنان تگرگی از آسمان می‌بارانم که در تاریخ مصر سابقه نداشته است. ");
INSERT INTO pesopcb_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","پس دستور بده تمام حیوانات و آنچه را که در صحرا دارید جمع کنند و به خانه‌ها بیاورند، پیش از آنکه تگرگ تمام حیوانات و اشخاصی را که در صحرا مانده‌اند از بین ببرد.» ");
INSERT INTO pesopcb_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","بعضی از درباریان فرعون از این اخطار خداوند ترسیدند و چارپایان و نوکران خود را به خانه آوردند. ");
INSERT INTO pesopcb_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","ولی دیگران به کلام خداوند اعتنا نکردند و حیوانات و نوکران خود را همچنان در صحرا باقی گذاشتند. ");
INSERT INTO pesopcb_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","آنگاه خداوند به موسی فرمود: «دستت را به سوی آسمان دراز کن تا بر تمامی مصر تگرگ ببارد، بر حیوانات و گیاهان و بر تمامی مردمی که در آن زندگی می‌کنند.» ");
INSERT INTO pesopcb_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","پس موسی عصای خود را به سوی آسمان دراز کرد و خداوند رعد و تگرگ فرستاد و صاعقه بر زمین فرود آورد. ");
INSERT INTO pesopcb_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","در تمام تاریخ مصر کسی چنین تگرگ و صاعقهٔ وحشتناکی ندیده بود. ");
INSERT INTO pesopcb_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","در سراسر مصر، تگرگ هر چه را که در صحرا بود زد، انسان و حیوان را کشت، نباتات را از بین برد و درختان را در هم شکست. ");
INSERT INTO pesopcb_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","تنها جایی که از بلای تگرگ در امان ماند، سرزمین جوشن بود که بنی‌اسرائیل در آن زندگی می‌کردند. ");
INSERT INTO pesopcb_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","پس فرعون، موسی و هارون را به حضور خواست و به ایشان گفت: «من به گناه خود معترفم. حق به جانب خداوند است. من و قومم مقصریم. ");
INSERT INTO pesopcb_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","حال از خداوند درخواست کنید تا این رعد و تگرگ وحشتناک را بازدارد. دیگر بس است! من هم اجازه خواهم داد بروید؛ لازم نیست بیش از این اینجا بمانید.» ");
INSERT INTO pesopcb_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","موسی گفت: «بسیار خوب، به محض اینکه از شهر خارج شوم دستهای خود را به سوی خداوند دراز خواهم کرد تا رعد و تگرگ تمام شود تا بدانی که جهان از آن خداوند است. ");
INSERT INTO pesopcb_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","ولی می‌دانم که تو و افرادت باز هم از یهوه خدا اطاعت نخواهید کرد.» ");
INSERT INTO pesopcb_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","(آن سال تگرگ تمام محصولات کتان و جو را از بین برد، چون ساقهٔ جو خوشه کرده و کتان شکوفه داده بود، ");
INSERT INTO pesopcb_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","ولی گندم از بین نرفت، زیرا هنوز جوانه نزده بود.) ");
INSERT INTO pesopcb_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","موسی قصر فرعون را ترک کرد و از شهر بیرون رفت و دستهایش را به سوی خداوند بلند کرد و رعد و تگرگ قطع شد و باران بند آمد. ");
INSERT INTO pesopcb_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","ولی وقتی فرعون دید باران و تگرگ و رعد قطع شده، او و درباریانش باز گناه ورزیده، به سرسختی خود ادامه دادند. ");
INSERT INTO pesopcb_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","پس همان‌طور که خداوند توسط موسی فرموده بود، دل فرعون سخت شد و این بار هم بنی‌اسرائیل را رها نکرد. ");
INSERT INTO pesopcb_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","آنگاه خداوند به موسی فرمود: «ای موسی نزد فرعون بازگرد. من قلب او و درباریانش را سخت کرده‌ام تا این معجزات را در میان آنها ظاهر سازم، ");
INSERT INTO pesopcb_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","و تو بتوانی این معجزات را که من در مصر انجام داده‌ام برای فرزندان و نوه‌های خود تعریف کنی تا همهٔ شما بدانید که من خداوند هستم.» ");
INSERT INTO pesopcb_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","پس موسی و هارون باز نزد فرعون رفتند و به او گفتند: «خداوند، خدای عبرانی‌ها می‌فرماید: تا کی می‌خواهی از فرمان من سرپیچی کنی؟ بگذار قوم من بروند و مرا عبادت کنند. ");
INSERT INTO pesopcb_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","اگر آنها را رها نکنی، بدان که فردا سراسر سرزمینت را با ملخ می‌پوشانم. ");
INSERT INTO pesopcb_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","ملخها چنان روی زمین را خواهند پوشاند که زمین دیده نخواهد شد. آنها تمام گیاهانی را که از بلای تگرگ به جای مانده است، خواهند خورد، از جمله همۀ درختانی را که در صحرا می‌رویند. ");
INSERT INTO pesopcb_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","قصر تو و خانه‌های درباریان تو و همهٔ اهالی مصر پر از ملخ می‌شود. اجدادتان هرگز چنین بلایی را در تاریخ مصر ندیده‌اند.» سپس موسی روی برگردانیده، از حضور فرعون بیرون رفت. ");
INSERT INTO pesopcb_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","درباریان نزد پادشاه آمده، گفتند: «تا به کی باید این مرد ما را دچار مصیبت کند؟ مگر نمی‌دانی که مصر به چه ویرانه‌ای تبدیل شده است؟ بگذار این مردم بروند و خداوند، خدای خود را عبادت کنند.» ");
INSERT INTO pesopcb_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","پس درباریان، موسی و هارون را نزد فرعون برگرداندند و فرعون به ایشان گفت: «بروید و خداوند، خدای خود را عبادت کنید، ولی باید به من بگویید که چه کسانی می‌خواهند برای عبادت بروند.» ");
INSERT INTO pesopcb_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","موسی جواب داد: «همهٔ ما با دختران و پسران، جوانان و پیران، گله‌ها و رمه‌های خود می‌رویم، زیرا همگی باید در این جشن خداوند شرکت کنیم.» ");
INSERT INTO pesopcb_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","فرعون گفت: «به خداوند قسم هرگز اجازه نمی‌دهم که زنها و بچه‌ها را با خود ببرید، چون می‌دانم نیرنگی در کارتان است. ");
INSERT INTO pesopcb_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","فقط شما مردها بروید و خداوند را عبادت کنید، زیرا از اول هم خواست شما همین بود.» پس موسی و هارون را از حضور فرعون بیرون راندند. ");
INSERT INTO pesopcb_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","سپس خداوند به موسی فرمود: «دستت را بر سرزمین مصر دراز کن تا ملخها هجوم آورند و همهٔ گیاهانی را که پس از بلای تگرگ باقی مانده‌اند، بخورند و از بین ببرند.» ");
INSERT INTO pesopcb_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","وقتی موسی عصای خود را بر سرزمین مصر بلند کرد، خداوند در یک روز و یک شب کامل، بادی از مشرق بطرف مصر وزانید و وقتی صبح شد باد انبوهی از ملخ را با خود آورده بود. ");
INSERT INTO pesopcb_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","ملخها بر سراسر خاک مصر هجوم آورده، همه جا را پوشانیدند. چنین آفت ملخی را مصر نه دیده و نه خواهد دید. ");
INSERT INTO pesopcb_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","شدت هجوم ملخها به حدی زیاد بود که همه جا یکباره تاریک شد. ملخها تمام گیاهان و میوه‌هایی را که از بلای تگرگ باقی مانده بود، خوردند به طوری که در سراسر خاک مصر درخت و گیاه سبزی به جای نماند. ");
INSERT INTO pesopcb_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","فرعون با شتاب موسی و هارون را خواست و به ایشان گفت: «من به خداوند، خدای شما و خود شما گناه کرده‌ام. ");
INSERT INTO pesopcb_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","این بار هم مرا ببخشید و از خداوند، خدای خود درخواست کنید تا این بلای مرگ را از من دور کند.» ");
INSERT INTO pesopcb_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","آنگاه موسی از حضور فرعون بیرون رفت و از خداوند خواست تا ملخها را دور کند. ");
INSERT INTO pesopcb_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","خداوند هم از طرف مغرب، بادی شدید وزانید و وزش باد تمام ملخها را به دریای سرخ ریخت آنچنان که در تمام مصر حتی یک ملخ هم باقی نماند. ");
INSERT INTO pesopcb_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","ولی باز خداوند دل فرعون را سخت کرد و او بنی‌اسرائیل را رها نساخت. ");
INSERT INTO pesopcb_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","سپس خداوند به موسی فرمود: «دستهای خود را به سوی آسمان بلند کن تا تاریکی غلیظی مصر را فرا گیرد.» ");
INSERT INTO pesopcb_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","موسی چنین کرد و تاریکی غلیظی به مدت سه روز مصر را فرا گرفت، ");
INSERT INTO pesopcb_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","مصری‌ها نمی‌توانستند یکدیگر را ببینند و هیچ‌کس قادر نبود از جای خود تکان بخورد. اما در محل سکونت اسرائیلی‌ها همه جا همچنان روشن ماند. ");
INSERT INTO pesopcb_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","آنگاه فرعون بار دیگر موسی را احضار کرد و گفت: «بروید و خداوند را عبادت کنید. فرزندانتان را نیز ببرید، ولی گله‌ها و رمه‌های شما باید در مصر بماند.» ");
INSERT INTO pesopcb_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","اما موسی گفت: «ما گله‌ها و رمه‌ها را باید همراه خود ببریم تا برای یهوه خدایمان قربانی کنیم. ");
INSERT INTO pesopcb_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","از گلهٔ خود حتی یک حیوان را هم برجای نخواهیم گذاشت، زیرا تا به مذبح نرسیم معلوم نخواهد شد یهوه خدایمان چه حیوانی برای قربانی می‌خواهد.» ");
INSERT INTO pesopcb_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","خداوند دل فرعون را سخت کرد و این بار هم آنها را رها نساخت. ");
INSERT INTO pesopcb_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","فرعون به موسی گفت: «از حضور من برو و دیگر برنگرد. اگر بار دیگر با من روبرو شوی بدان که کشته خواهی شد.» ");
INSERT INTO pesopcb_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","موسی جواب داد: «همان‌طور که گفتی، دیگر مرا نخواهی دید.» ");
INSERT INTO pesopcb_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","آنگاه خداوند به موسی فرمود: «یک بلای دیگر بر پادشاه مصر و قومش نازل می‌کنم تا شما را رها سازد. این بار او خود از شما خواهد خواست تا مصر را ترک گویید. ");
INSERT INTO pesopcb_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","به تمام مردان و زنان قوم اسرائیل بگو که پیش از رفتن باید از همسایگان مصری خود اجناس طلا و نقره بخواهند.» ");
INSERT INTO pesopcb_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","(خداوند قوم اسرائیل را در نظر مصری‌ها محترم ساخته بود و درباریان و تمام مردم مصر موسی را مردی بزرگ می‌دانستند.) ");
INSERT INTO pesopcb_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","پس موسی به فرعون گفت: «خداوند می‌فرماید: حدود نیمه‌شب از میان مصر عبور خواهم کرد. ");
INSERT INTO pesopcb_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","همهٔ پسران نخست‌زادۀ خانواده‌های مصری خواهند مرد از پسر فرعون که جانشین اوست گرفته، تا پسر کنیزی که کارش دستاس کردن گندم است. حتی تمام نخست‌زاده‌های چارپایان مصر نیز نابود خواهند شد. ");
INSERT INTO pesopcb_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","چنان گریه و شیونی در سراسر مصر خواهد بود که نظیر آن تا به حال شنیده نشده و نخواهد شد. ");
INSERT INTO pesopcb_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","اما از میان قوم اسرائیل و حیواناتشان حتی یک سگ هم پارس نخواهد کرد. آنگاه خواهی دانست که خداوند میان قوم اسرائیل و قوم تو تفاوت قائل است. ");
INSERT INTO pesopcb_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","تمام درباریان تو در برابر من تعظیم کرده، التماس خواهند کرد تا هر چه زودتر بنی‌اسرائیل را از مصر بیرون ببرم. آنگاه من مصر را ترک خواهم گفت.» سپس موسی با عصبانیت از کاخ فرعون بیرون رفت. ");
INSERT INTO pesopcb_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","خداوند به موسی فرموده بود: «فرعون به حرفهای تو اعتنا نخواهد کرد و این به من فرصتی خواهد داد تا معجزات بیشتری در سرزمین مصر انجام دهم.» ");
INSERT INTO pesopcb_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","با اینکه موسی و هارون در حضور فرعون آن همه معجزه انجام دادند، اما او بنی‌اسرائیل را رها نساخت تا از مصر خارج شوند، زیرا خداوند دل فرعون را سخت ساخته بود. ");
INSERT INTO pesopcb_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","خداوند در سرزمین مصر به موسی و هارون فرمود: ");
INSERT INTO pesopcb_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","«از این پس باید این ماه برای شما اولین و مهمترین ماه سال باشد. ");
INSERT INTO pesopcb_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","پس به تمام قوم اسرائیل بگویید که هر سال در روز دهم همین ماه، هر خانواده‌ای از ایشان یک بره یا یک بزغاله تهیه کند. طوری که یک حیوان برای یک خانواده باشد. ");
INSERT INTO pesopcb_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","اگر تعداد افراد خانواده‌ای کم باشد می‌تواند با خانوادهٔ کوچکی در همسایگی خود شریک شود، یعنی هر خانواده به تعداد افرادش به همان مقداری که خوراکش می‌باشد، سهم قیمت بره را بپردازد. ");
INSERT INTO pesopcb_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","این حیوان، خواه گوسفند و خواه بز، باید نر و یک ساله و بی‌عیب باشد. ");
INSERT INTO pesopcb_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","«از این حیوان خاص تا عصر روز چهاردهم این ماه خوب مراقبت کنید. سپس همهٔ قوم اسرائیل بره‌های خود را ذبح کنند. ");
INSERT INTO pesopcb_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","و خون آنها را روی تیرهای عمودی دو طرف در و سر در خانه‌هایشان که در آن گوشت بره را می‌خورند، بپاشند. ");
INSERT INTO pesopcb_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","در همان شب، گوشت را بریان کنند و با نان فطیر (نان بدون خمیرمایه) و سبزیهای تلخ بخورند. ");
INSERT INTO pesopcb_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","گوشت را نباید خام یا آب‌پز بخورند، بلکه همه را بریان کنند حتی کله و پاچه و دل و جگر آن را. ");
INSERT INTO pesopcb_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","تمام گوشت باید تا صبح خورده شود، و اگر چیزی از آن باقی ماند آن را بسوزانند. ");
INSERT INTO pesopcb_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","«قبل از خوردن بره، کفش به پا کنید، چوبدستی به دست گیرید و خود را برای سفر آماده کنید، و بره را با عجله بخورید. این آیین، پِسَح خداوند خوانده خواهد شد. ");
INSERT INTO pesopcb_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","چون من که خداوند هستم، امشب از سرزمین مصر گذر خواهم کرد و تمام پسران نخست‌زادۀ مصری‌ها و همهٔ نخست‌زاده‌های حیوانات ایشان را هلاک خواهم نمود و خدایان آنها را مجازات خواهم کرد. ");
INSERT INTO pesopcb_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","خونی که شما روی تیرهای در خانه‌های خود می‌پاشید، نشانه‌ای بر خانه‌هایتان خواهد بود. من وقتی خون را ببینم از شما خواهم گذشت و فقط مصری‌ها را هلاک می‌کنم. ");
INSERT INTO pesopcb_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","«هر سال به یادبود این واقعه برای خداوند جشن بگیرید. این آیین تا ابد برای تمام نسلهای آینده خواهد بود. ");
INSERT INTO pesopcb_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","در این جشن که هفت روز طول می‌کشد باید فقط نان فطیر بخورید. در روز اول، خمیرمایه را از خانهٔ خود بیرون ببرید، زیرا اگر کسی در مدت این هفت روز نان خمیرمایه‌دار بخورد از میان قوم اسرائیل منقطع خواهد شد. ");
INSERT INTO pesopcb_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","در روز اول و هفتم این جشن، باید تمام قوم به طور دسته جمعی خدا را عبادت کنند. در این دو روز به‌جز تهیهٔ خوراک کار دیگری نکنید. ");
INSERT INTO pesopcb_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","«این عید که همراه نان فطیر جشن گرفته می‌شود، به شما یادآوری خواهد کرد که من در چنین روزی شما را از مصر بیرون آوردم. پس برگزاری این جشن بر شما و نسلهای آیندهٔ شما تا به ابد واجب خواهد بود. ");
INSERT INTO pesopcb_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","از غروب روز چهاردهم تا غروب روز بیست و یکم این ماه باید نان بدون خمیرمایه بخورید. ");
INSERT INTO pesopcb_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","در این هفت روز نباید اثری از خمیرمایه در خانه‌های شما باشد. در این مدت اگر کسی نان خمیرمایه‌دار بخورد، باید از میان قوم اسرائیل منقطع شود. رعایت این قوانین حتی برای غریبه‌ها نیز که در میان شما ساکن هستند واجب خواهد بود. ");
INSERT INTO pesopcb_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","باز تأکید می‌کنم که در این هفت روز نان خمیرمایه‌دار نخورید. فقط نان فطیر بخورید.» ");
INSERT INTO pesopcb_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","آنگاه موسی، مشایخ قوم را نزد خود خواند و به ایشان گفت: «بروید و بره‌هایی برای خانواده‌هایتان بگیرید و برای عید پِسَح آنها را قربانی کنید. ");
INSERT INTO pesopcb_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","خون بره را در یک تشت بریزید و بعد با گیاه زوفا خون را روی تیرهای دو طرف در و سر در خانه‌هایتان بپاشید. هیچ‌کدام از شما نباید در آن شب از خانه بیرون رود. ");
INSERT INTO pesopcb_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","آن شب خداوند از سرزمین مصر عبور خواهد کرد تا مصری‌ها را بکشد. ولی وقتی خون را روی تیرهای دو طرف در و سر در خانه‌هایتان ببیند از آنجا می‌گذرد و به ”هلاک کننده“ اجازه نمی‌دهد که وارد خانه‌هایتان شده، شما را بکشد. ");
INSERT INTO pesopcb_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","برگزاری این مراسم برای شما و فرزندانتان یک فریضۀ ابدی خواهد بود. ");
INSERT INTO pesopcb_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","وقتی به آن سرزمینی که خداوند وعدهٔ آن را به شما داده، وارد شدید، عید پِسَح را جشن بگیرید. ");
INSERT INTO pesopcb_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","هرگاه فرزندانتان مناسبت این جشن را از شما بپرسند، ");
INSERT INTO pesopcb_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","بگویید: عید پِسَح را برای خداوند به مناسبت آن شبی جشن می‌گیریم که او از مصر عبور کرده، مصری‌ها را کشت، ولی وقتی به خانه‌های ما اسرائیلی‌ها رسید از آنها گذشت و به ما آسیبی نرساند.» قوم اسرائیل روی بر خاک نهاده، خداوند را سجده نمودند. ");
INSERT INTO pesopcb_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","سپس همان‌طور که خداوند به موسی و هارون دستور داده بود، عمل کردند. ");
INSERT INTO pesopcb_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","نیمه‌شب، خداوند تمام پسران نخست‌زادۀ مصر را کشت، از پسر فرعون که جانشین او بود گرفته تا پسر غلامی که در سیاهچال زندانی بود. او حتی تمام نخست‌زاده‌های حیوانات ایشان را نیز از بین برد. ");
INSERT INTO pesopcb_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","در آن شب فرعون و درباریان و تمام اهالی مصر از خواب بیدار شدند و ناله سر دادند، به طوری که صدای ناله و شیون آنها در سراسر مصر پیچید، زیرا خانه‌ای نبود که در آن کسی نمرده باشد. ");
INSERT INTO pesopcb_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","فرعون در همان شب موسی و هارون را فرا خواند و به ایشان گفت: «هر چه زودتر از سرزمین مصر بیرون بروید و بنی‌اسرائیل را هم با خود ببرید. بروید و همان‌طور که خواستید خداوند را عبادت کنید. ");
INSERT INTO pesopcb_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","گله‌ها و رمه‌های خود را هم ببرید. ولی پیش از اینکه بروید برای من نیز دعا کنید.» ");
INSERT INTO pesopcb_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","اهالی مصر نیز به قوم اسرائیل اصرار می‌کردند تا هر چه زودتر از مصر بیرون بروند. آنها به بنی‌اسرائیل می‌گفتند: «تا همهٔ ما را به کشتن نداده‌اید از اینجا بیرون بروید.» ");
INSERT INTO pesopcb_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","پس قوم اسرائیل تغارهای پر از خمیر بی‌مایه را درون پارچه پیچیدند و بر دوش خود بستند، ");
INSERT INTO pesopcb_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","و همان‌طور که موسی به ایشان گفته بود از همسایه‌های مصری خود لباس و طلا و نقره خواستند. ");
INSERT INTO pesopcb_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","خداوند بنی‌اسرائیل را در نظر اهالی مصر محترم ساخته بود، به طوری که هر چه از آنها خواستند به ایشان دادند. به این ترتیب آنها ثروت مصر را با خود بردند. ");
INSERT INTO pesopcb_vpl VALUES ("EX12_37‏","003_12_37‏","EXO","12","37‏","38","در همان شب بنی‌اسرائیل از رَمِسیس کوچ کرده، روانهٔ سوکوت شدند. تعداد ایشان به غیر از زنان و کودکان قریب به ششصد هزار مرد بود که پیاده در حرکت بودند. از قومهای دیگر نیز در میان آنها بودند که همراه ایشان از مصر بیرون آمدند. گله‌ها و رمه‌های فراوانی هم به همراه ایشان خارج شدند. ");
INSERT INTO pesopcb_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","وقتی سر راه برای غذا خوردن توقف کردند، از همان خمیر فطیر که آورده بودند، نان پختند. از این جهت خمیر را با خود آورده بودند چون با شتاب از مصر بیرون آمدند و فرصتی برای پختن نان نداشتند. ");
INSERT INTO pesopcb_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","بنی‌اسرائیل مدت چهارصد و سی سال در مصر زندگی کرده بودند. ");
INSERT INTO pesopcb_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","در آخرین روز چهارصد و سی‌امین سال بود که لشکریان خداوند از سرزمین مصر بیرون آمدند. ");
INSERT INTO pesopcb_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","خداوند آن شب را برای رهایی آنها از سرزمین مصر در نظر گرفته بود و قوم اسرائیل می‌بایست نسل اندر نسل، همه ساله در آن شب به یاد رهایی خود از دست مصری‌ها، برای خداوند جشن بگیرند. ");
INSERT INTO pesopcb_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","آنگاه خداوند به موسی و هارون مقررات آیین پِسَح را چنین تعلیم داد: «هیچ بیگانه‌ای نباید از گوشت برهٔ پِسَح بخورد. ");
INSERT INTO pesopcb_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","اما غلامی که خریداری و ختنه شده باشد می‌تواند از آن بخورد. ");
INSERT INTO pesopcb_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","خدمتکار و میهمان غیریهودی نباید از آن بخورند. ");
INSERT INTO pesopcb_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","تمام گوشت بره را در همان خانه‌ای که در آن نشسته‌اید بخورید. آن گوشت را از خانه نباید بیرون ببرید. هیچ‌یک از استخوانهای آن را نشکنید. ");
INSERT INTO pesopcb_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","تمام قوم اسرائیل باید این مراسم را برگزار نمایند. ");
INSERT INTO pesopcb_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","«اگر غریبه‌هایی در میان شما زندگی می‌کنند و مایلند این آیین را برای خداوند نگاه دارند، باید مردان و پسران ایشان ختنه شوند تا اجازه داشته باشند مثل شما در این آیین شرکت کنند. اما شخص ختنه نشده هرگز نباید از گوشت برهٔ قربانی بخورد. ");
INSERT INTO pesopcb_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","تمام مقررات این جشن شامل حال غریبه‌هایی نیز که ختنه شده‌اند و در میان شما ساکنند، می‌شود.» ");
INSERT INTO pesopcb_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","قوم اسرائیل تمام دستورها خداوند را که توسط موسی و هارون به ایشان داده شده بود، به کار بستند. ");
INSERT INTO pesopcb_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","در همان روز خداوند تمام بنی‌اسرائیل را از مصر بیرون آورد. ");
INSERT INTO pesopcb_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","خداوند به موسی فرمود: ");
INSERT INTO pesopcb_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","«تمام نخست‌زادگان قوم اسرائیل را به من وقف کن، زیرا همۀ نخست‌زادگان، خواه انسان و خواه حیوان، به من تعلق دارند.» ");
INSERT INTO pesopcb_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","پس موسی به قوم گفت: «این روز را که روز رهایی شما از بردگی مصر است همیشه به یاد داشته باشید، زیرا خداوند با دست توانای خود، شما را از آن رها ساخت. به خاطر بسپارید که در این روزهای عید، باید نان بدون خمیرمایه بخورید. ");
INSERT INTO pesopcb_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","امروز در ماه ابیب شما از مصر خارج می‌شوید. ");
INSERT INTO pesopcb_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","خداوند به اجدادتان وعده داده است که، سرزمین کنعانی‌ها، حیتی‌ها، اموری‌ها، حوی‌ها و یبوسی‌ها را به شما واگذار کند، بنابراین، وقتی شما را به سرزمینی که به ”سرزمین شیر و عسل“ معروف است، داخل می‌کند، باید این روز را، هر ساله جشن بگیرید. ");
INSERT INTO pesopcb_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","به مدت هفت روز نان فطیر بخورید و در روز هفتم عیدی برای خداوند نگاه دارید. ");
INSERT INTO pesopcb_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","در این هفت روز، نان فطیر بخورید. در خانه‌های شما و حتی در سرزمین شما اثری از خمیرمایه پیدا نشود. ");
INSERT INTO pesopcb_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","«هر سال هنگام برگزاری این جشن، به فرزندان خود بگویید که این جشن به مناسبت آن کار بزرگی است که خداوند به خاطر شما انجام داد و شما را از مصر بیرون آورد. ");
INSERT INTO pesopcb_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","این جشن مانند علامتی بر دستتان یا نشانی بر پیشانی‌تان خواهد بود تا به شما یادآوری نماید که همیشه در شریعت خداوند تفکر کنید و از آن سخن بگویید، زیرا خداوند با قدرت عظیم خود، شما را از مصر بیرون آورد. ");
INSERT INTO pesopcb_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","«پس هر سال در موعد مقرر این عید را جشن بگیرید. ");
INSERT INTO pesopcb_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","«زمانی که خداوند، شما را به سرزمین کنعان که وعدهٔ آن را از پیش به اجداد شما داده بود بیاورد، به خاطر داشته باشید که ");
INSERT INTO pesopcb_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","پسران نخست‌زادۀ شما و همچنین نخست‌زادهٔ نر حیوانات شما از آنِ خداوند می‌باشند و باید آنها را وقف خدا کنید. ");
INSERT INTO pesopcb_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","به جای نخست‌زادهٔ الاغ، بره‌ای فدیه دهید. ولی اگر نخواستید آن را با بره عوض کنید، باید گردن الاغ را بشکنید. اما برای پسران نخست‌زادۀ خود حتماً باید فدیه بدهید. ");
INSERT INTO pesopcb_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","«در آینده وقتی فرزندانتان از شما بپرسند: ”این کارها برای چیست؟“ بگویید: ”خداوند با دست توانای خود ما را از بردگی مصری‌ها نجات بخشید. ");
INSERT INTO pesopcb_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","چون فرعون ما را از اسارت رها نمی‌کرد، برای همین، خداوند تمام پسران نخست‌زادۀ مصری‌ها و همچنین نخست‌زاده‌های نر حیوانات آنان را هلاک کرد تا ما را نجات دهد. به همین دلیل نخست‌زادهٔ نر حیوانات خود را برای خداوند قربانی می‌کنیم تا برای پسران نخست‌زادۀ خود فدیه دهیم.“ ");
INSERT INTO pesopcb_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","این جشن مانند علامتی بر دستتان و یا نشانی بر پیشانی‌تان خواهد بود تا به یاد شما آورد که خداوند با دست قوی خود ما را از مصر بیرون آورد.» ");
INSERT INTO pesopcb_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","وقتی سرانجام فرعون به قوم اسرائیل اجازه داد تا از مصر بروند، خدا آنان را از راه اصلی که از سرزمین فلسطینی‌ها می‌گذشت نبرد، هرچند آن راه نزدیکتر بود. خدا گفت: «اگر قوم با جنگ روبرو شوند، ممکن است پشیمان شده، به مصر برگردند.» ");
INSERT INTO pesopcb_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","پس خدا آنها را از طریق صحرایی که در حاشیهٔ دریای سرخ بود هدایت نمود. بدین ترتیب قوم اسرائیل مانند لشکری مسلح از مصر بیرون رفتند. ");
INSERT INTO pesopcb_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","موسی در این سفر استخوانهای یوسف را نیز همراه خود برد، چون یوسف در زمان حیات خود بنی‌اسرائیل را قسم داده، گفته بود: «وقتی خدا شما را برهاند، استخوانهای مرا هم با خود از اینجا ببرید.» ");
INSERT INTO pesopcb_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","پس قوم اسرائیل سوکوت را ترک کرده، در ایتام که در حاشیهٔ صحرا بود، خیمه زدند. ");
INSERT INTO pesopcb_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","در این سفر، خداوند ایشان را در روز به‌وسیلهٔ ستونی از ابر و در شب به‌وسیلۀ ستونی از آتش هدایت می‌کرد. از این جهت هم در روز می‌توانستند سفر کنند و هم در شب. ");
INSERT INTO pesopcb_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","ستونهای ابر و آتش لحظه‌ای از برابر آنها دور نمی‌شد. ");
INSERT INTO pesopcb_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","آنگاه خداوند این دستورها را به موسی داد: ");
INSERT INTO pesopcb_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","«به قوم من بگو که به سوی فی‌هاحیروت که در میان مِجدُل و دریای سرخ و مقابل بعل صفون است برگردند و در کنار دریا اردو بزنند. ");
INSERT INTO pesopcb_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","فرعون گمان خواهد کرد که چون روبروی شما دریا و پشت سر شما بیابان است، شما در میان دریا و صحرا محاصره شده‌اید، ");
INSERT INTO pesopcb_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","و من دل فرعون را سخت می‌سازم تا شما را تعقیب کند. این باعث می‌شود که من بار دیگر قدرت و بزرگی خود را به او و به تمام لشکرش ثابت کنم تا مصری‌ها بدانند که من خداوند هستم.» پس بنی‌اسرائیل در همان جا که خداوند نشان داده بود اردو زدند. ");
INSERT INTO pesopcb_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","وقتی به فرعون خبر رسید که اسرائیلی‌ها از مصر فرار کرده‌اند او و درباریانش پشیمان شده، گفتند: «این چه کاری بود که ما کردیم؟ برای چه به بردگان خود اجازه دادیم تا از اینجا دور شوند؟» ");
INSERT INTO pesopcb_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","پس پادشاه مصر ارابهٔ خود را آماده کرده، لشکر خود را بسیج نمود. ");
INSERT INTO pesopcb_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","سپس با ششصد ارابهٔ مخصوص خود و نیز تمام ارابه‌های مصر که به‌وسیلۀ سرداران رانده می‌شد، رهسپار گردید. ");
INSERT INTO pesopcb_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","خداوند دل فرعون را سخت کرد و او به تعقیب قوم اسرائیل که با سربلندی از مصر بیرون رفتند، پرداخت. ");
INSERT INTO pesopcb_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","تمام لشکر مصر با ارابه‌های جنگی و دسته‌های سواره و پیاده، قوم اسرائیل را تعقیب کردند. قوم اسرائیل در کنار دریا، نزدیک فی‌هاحیروت مقابل بعل صفون خیمه زده بودند که لشکر مصر به آنها رسید. ");
INSERT INTO pesopcb_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","وقتی قوم اسرائیل از دور مصری‌ها را دیدند که به آنان نزدیک می‌شوند دچار وحشت شدند و از خداوند کمک خواستند. ");
INSERT INTO pesopcb_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","آنها به موسی گفتند: «چرا ما را به این بیابان کشاندی؟ مگر در مصر قبر نبود که ما را آوردی در این بیابان بمیریم؟ چرا ما را مجبور کردی از مصر بیرون بیاییم؟ ");
INSERT INTO pesopcb_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","وقتی در مصر برده بودیم، آیا به تو نگفتیم که ما را به حال خودمان رها کن؟ ما می‌دانستیم که برده ماندن در مصر بهتر از مردن در بیابان است.» ");
INSERT INTO pesopcb_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","ولی موسی جواب داد: «نترسید! بایستید و ببینید چگونه خداوند امروز شما را نجات می‌دهد. این مصری‌ها را که حالا می‌بینید، از این پس دیگر هرگز نخواهید دید. ");
INSERT INTO pesopcb_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","آرام باشید، زیرا خداوند برای شما خواهد جنگید.» ");
INSERT INTO pesopcb_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","آنگاه خداوند به موسی فرمود: «دیگر دعا و التماس بس است. نزد قوم اسرائیل برو و بگو که حرکت کنند و پیش بروند. ");
INSERT INTO pesopcb_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","و تو عصای خود را بردار و دست خود را به سوی دریا دراز کن تا آب آن شکافته شود و قوم اسرائیل از راهی که در وسط دریا پدید می‌آید، عبور کنند. ");
INSERT INTO pesopcb_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","و من دل مصری‌ها را سخت می‌سازم تا در پی شما وارد راهی که در دریا پدید آمده، شوند. جلال پرشکوه من توسط فرعون و لشکرش و ارابه‌ها و سوارانش ظاهر خواهد شد. ");
INSERT INTO pesopcb_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","وقتی جلال من توسط آنها ظاهر شود، تمام مصری‌ها جلال مرا خواهند دید و خواهند دانست که من خداوند هستم.» ");
INSERT INTO pesopcb_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","آنگاه فرشتهٔ خدا که پیشاپیش بنی‌اسرائیل حرکت می‌کرد، رفت و در پشت سر آنها قرار گرفت. ستون ابر نیز به پشت سر آنها منتقل شد ");
INSERT INTO pesopcb_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","و در میان قوم اسرائیل و مصری‌ها قرار گرفت. وقتی شب فرا رسید، ابر به ستون آتش تبدیل شد، به طوری که مصری‌ها در تاریکی بودند و بنی‌اسرائیل در روشنایی. پس مصری‌ها تمام شب نمی‌توانستند به اسرائیلی‌ها نزدیک شوند. ");
INSERT INTO pesopcb_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","سپس موسی عصای خود را به طرف دریا دراز کرد و خداوند آب دریا را شکافت و از میان آب راهی برای عبور بنی‌اسرائیل آماده ساخت. تمام شب نیز از مشرق باد سختی وزیدن گرفت و این راه را خشک کرد. ");
INSERT INTO pesopcb_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","بنابراین، قوم اسرائیل از آن راه خشک در میان دریا گذشتند در حالی که آب دریا در دو طرف راه، همچون دیواری بلند بر پا شده بود. ");
INSERT INTO pesopcb_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","در این هنگام تمام سواران و اسبها و ارابه‌های فرعون در پی قوم اسرائیل وارد دریا شدند. ");
INSERT INTO pesopcb_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","در سپیده دم، خداوند از میان ابر و آتش بر لشکر مصر نظر انداخت و آنها را آشفته کرد. ");
INSERT INTO pesopcb_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","چرخهای همهٔ ارابه‌ها از جا کنده شدند چنانکه به سختی می‌توانستند حرکت کنند. مصری‌ها فریاد برآوردند: «بیایید فرار کنیم، چون خداوند برای اسرائیلی‌ها با ما می‌جنگد.» ");
INSERT INTO pesopcb_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","وقتی همهٔ قوم اسرائیل به آن طرف دریا رسیدند خداوند به موسی فرمود: «بار دیگر دست خود را به طرف دریا دراز کن تا آبها بر سر مصری‌ها و اسبها و ارابه‌هایشان فرو ریزند.» ");
INSERT INTO pesopcb_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","موسی این کار را کرد و سپیده دم آب دریا دوباره به حالت اول بازگشت. مصری‌ها کوشیدند فرار کنند، ولی خداوند همهٔ آنها را در دریا غرق کرد. ");
INSERT INTO pesopcb_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","پس آب برگشت و تمام ارابه‌ها و سواران را فرو گرفت، به طوری که از لشکر فرعون که به تعقیب بنی‌اسرائیل پرداخته بودند حتی یک نفر هم زنده نماند. ");
INSERT INTO pesopcb_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","به این ترتیب، بنی‌اسرائیل از میان راهی که بر دو طرف آن دیوارهای بلند آب بر پا شده بود، گذشتند. ");
INSERT INTO pesopcb_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","اینچنین، خداوند در آن روز بنی‌اسرائیل را از چنگ مصری‌ها نجات بخشید. اسرائیلی‌ها اجساد مصری‌ها را دیدند که در ساحل دریا افتاده بودند. ");
INSERT INTO pesopcb_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","وقتی قوم اسرائیل این معجزهٔ عظیم خداوند را به چشم دیدند، ترسیدند و به خداوند و به خدمتگزارش موسی ایمان آوردند. ");
INSERT INTO pesopcb_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","آنگاه موسی و بنی‌اسرائیل در ستایش خداوند این سرود را خواندند: «خداوند را می‌سراییم که شکوهمندانه پیروز شده است، او اسبها و سوارانشان را به دریا افکنده است. ");
INSERT INTO pesopcb_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","خداوند قوت و سرود من است، و نجات من گردیده. او خدای من است، پس او را سپاس خواهم گفت. او خدای نیاکان من است، پس او را برمی‌افرازم. ");
INSERT INTO pesopcb_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","او جنگاور است و نامش خداوند می‌باشد. ");
INSERT INTO pesopcb_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","خداوند، لشکر و ارابه‌های فرعون را به دریا سرنگون کرد. مبارزان برگزیدهٔ مصر در دریای سرخ غرق شدند. ");
INSERT INTO pesopcb_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","آبهای دریا آنها را پوشاندند، و آنها مانند سنگ به اعماق آب فرو رفتند. ");
INSERT INTO pesopcb_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","«دست راست تو ای خداوند، قدرت عظیمی دارد. به نیروی دستت، دشمنانت را در هم کوبیدی. ");
INSERT INTO pesopcb_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","با عظمت شکوهت دشمنان را نابود ساختی، آتش خشم تو، ایشان را همچون کاه سوزانید. ");
INSERT INTO pesopcb_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","تو بر دریا دمیدی و آن را شکافتی، آبها مانند دیوار ایستادند و عمق دریا خشک گردید. ");
INSERT INTO pesopcb_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","«دشمن گفت: ”آنها را تعقیب کرده، می‌گیرم و با شمشیرم هلاک می‌کنم، ثروتشان را تقسیم کرده، هر چه بخواهم برای خود برمی‌دارم.“ ");
INSERT INTO pesopcb_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","اما تو ای خداوند، چون بر دریا دمیدی موجها یکباره آنها را پوشانید، همگی مثل سرب در دریای خروشان غرق شدند. ");
INSERT INTO pesopcb_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","«کیست مانند تو ای خداوند در میان خدایان؟ کیست مثل تو عظیم در قدوسیت؟ کیست که مانند تو بتواند کارهای مهیب و عجیب انجام دهد؟ ");
INSERT INTO pesopcb_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","چون دست راست خود را دراز کردی، زمین، دشمنان ما را بلعید. ");
INSERT INTO pesopcb_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","«قوم خود را که بازخرید نموده‌ای با رحمت خود رهبری خواهی فرمود. تو آنها را با قدرت خود به سرزمین مقدّست هدایت خواهی کرد. ");
INSERT INTO pesopcb_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","قومها وقتی این را بشنوند مضطرب خواهند شد، ساکنان فلسطین از ترس خواهند لرزید، ");
INSERT INTO pesopcb_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","امیران ادوم وحشت خواهند کرد، بزرگان موآب خواهند لرزید. وحشت، مردم کنعان را فرو خواهد گرفت. ");
INSERT INTO pesopcb_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","ترس و دلهره بر ایشان غلبه خواهد کرد. ای خداوند از قدرت تو، آنها چون سنگ، خاموش خواهند ایستاد، تا قوم تو که آنها را خریده‌ای از کنار ایشان بگذرند. ");
INSERT INTO pesopcb_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","ای خداوند، تو ایشان را به کوه مقدّس خود بیاور و در همان جایی که برای سکونت خود انتخاب کرده‌ای و خانهٔ خود را در آن ساخته‌ای، ساکن ساز. ");
INSERT INTO pesopcb_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","خداوندا، تو تا ابد سلطنت خواهی کرد.» ");
INSERT INTO pesopcb_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","وقتی اسبهای فرعون با ارابه‌ها و سوارانش به دنبال اسرائیلی‌ها وارد دریا شدند، خداوند آب دریا را به سمت ایشان برگردانید، اما اسرائیلی‌ها از میان دریا به خشکی رسیدند. ");
INSERT INTO pesopcb_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","پس از خواندن این سرود، مریم نبیه، خواهر هارون دف به دست گرفت و به رقصیدن پرداخت و زنان دیگر نیز به دنبال وی چنین کردند، ");
INSERT INTO pesopcb_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","و مریم این سرود را خطاب به ایشان خواند: «خداوند را بسرایید که شکوهمندانه پیروز شده است، او اسبها و سوارانشان را به دریا افکنده است.» ");
INSERT INTO pesopcb_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","موسی قوم اسرائیل را از دریای سرخ حرکت داد و به طرف صحرای شور هدایت کرد. ولی در آن صحرا پس از سه روز راهپیمایی، قطره‌ای آب نیافتند. ");
INSERT INTO pesopcb_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","سپس آنها به ماره رسیدند، ولی از آب آنجا نیز نتوانستند بنوشند، چون تلخ بود. (از این جهت آن مکان را ماره یعنی «تلخ» نامیدند.) ");
INSERT INTO pesopcb_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","پس مردم غرغرکنان به موسی گفتند: «ما تشنه‌ایم؛ چه بنوشیم؟» ");
INSERT INTO pesopcb_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","موسی نزد خداوند دعا کرد و خداوند چوبی به او نشان داد و فرمود: «این چوب را در آب ماره بینداز تا آن را شیرین کند.» موسی چنین کرد و آب، شیرین شد. در ماره، خداوند دستورهایی به قوم اسرائیل داد تا اطاعت آنها را آزمایش کرده باشد. ");
INSERT INTO pesopcb_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","او فرمود: «اگر دستورها و احکام مرا که خداوند، خدای شما هستم اطاعت کنید و آنچه را که در نظر من پسندیده است بجا آورید، از تمام بیماریهایی که مصری‌ها را بدان دچار ساختم در امان خواهید ماند، زیرا من، خداوند، شفا دهندهٔ شما هستم.» ");
INSERT INTO pesopcb_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","سپس بنی‌اسرائیل به ایلیم آمدند. در آنجا دوازده چشمه و هفتاد درخت خرما بود؛ پس در کنار چشمه‌ها اردو زدند. ");
INSERT INTO pesopcb_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","قوم اسرائیل از ایلیم کوچ کردند و به صحرای سین که بین ایلیم و کوه سینا بود رفتند. روزی که به آنجا رسیدند، روز پانزدهم ماه دوم بعد از خروج ایشان از مصر بود. ");
INSERT INTO pesopcb_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","در آنجا همۀ جماعت بنی‌اسرائیل باز از موسی و هارون گله کرده، ");
INSERT INTO pesopcb_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","گفتند: «ای کاش در مصر می‌ماندیم و همان جا خداوند ما را می‌کشت. آنجا در کنار دیگهای گوشت می‌نشستیم و هر قدر نان می‌خواستیم می‌خوردیم، اما حالا در این بیابان سوزان که شما، ما را به آن کشانیده‌اید، به‌زودی از گرسنگی خواهیم مرد.» ");
INSERT INTO pesopcb_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","آنگاه خداوند به موسی فرمود: «حال از آسمان برای ایشان نان می‌فرستم. هر کس بخواهد می‌تواند بیرون برود و هر روز نان خود را برای همان روز جمع کند. به این وسیله آنها را آزمایش می‌کنم تا ببینم آیا از دستورهایم پیروی می‌کنند یا نه. ");
INSERT INTO pesopcb_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","به قوم اسرائیل بگو که روز ششم نان به اندازهٔ دو روز جمع کرده، آن را آماده نمایند.» ");
INSERT INTO pesopcb_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","پس موسی و هارون، بنی‌اسرائیل را جمع کردند و به ایشان گفتند: «امروز عصر به شما ثابت می‌شود که این خداوند بود که شما را از سرزمین مصر آزاد کرد. ");
INSERT INTO pesopcb_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","فردا صبح حضور پرجلال خداوند را خواهید دید، زیرا او گله و شکایت شما را که از وی کرده‌اید شنیده است. ما چه کرده‌ایم که از ما شکایت می‌کنید؟» ");
INSERT INTO pesopcb_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","سپس موسی اضافه کرد: «از این به بعد، خداوند عصر به شما گوشت خواهد داد تا بخورید و صبح نان خواهد داد تا سیر شوید، زیرا شکایتی را که از او کرده‌اید شنیده است. ما چه کرده‌ایم؟ شما نه از ما، بلکه از خداوند شکایت کرده‌اید.» ");
INSERT INTO pesopcb_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","آنگاه موسی به هارون گفت: «به تمامی جماعت اسرائیل بگو: ”به حضور خداوند بیایید، زیرا او شکایتهای شما را شنیده است.“» ");
INSERT INTO pesopcb_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","در حالی که هارون با قوم سخن می‌گفت آنها به طرف بیابان نگاه کردند، و ناگهان حضور پرجلال خداوند از میان ابر ظاهر شد. ");
INSERT INTO pesopcb_vpl VALUES ("EX16_11‏","003_16_11‏","EXO","16","11‏","12","خداوند به موسی فرمود: «شکایتهای بنی‌اسرائیل را شنیده‌ام. برو و به ایشان بگو: ”هنگام عصر گوشت خواهید خورد و صبح با نان سیر خواهید شد تا بدانید که من خداوند، خدای شما هستم.“» ");
INSERT INTO pesopcb_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","در غروب همان روز، تعداد زیادی بلدرچین آمدند و سراسر اردوگاه بنی‌اسرائیل را پوشاندند و در سحرگاه در اطراف اردوگاه شبنم بر زمین نشست. ");
INSERT INTO pesopcb_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","صبح، وقتی شبنم ناپدید شد، دانه‌های ریزی روی زمین باقی ماند که شبیه دانه‌های برف بود. ");
INSERT INTO pesopcb_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","وقتی قوم اسرائیل آن را دیدند، از همدیگر پرسیدند: «این چیست؟» زیرا چنین چیزی ندیده بودند. موسی به آنها گفت: «این نانی است که خداوند به شما داده تا بخورید. ");
INSERT INTO pesopcb_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","خداوند فرموده که هر خانواده به اندازهٔ احتیاج روزانهٔ خود از این نان جمع کند، یعنی برای هر نفر، یک عومر.» ");
INSERT INTO pesopcb_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","پس قوم اسرائیل بیرون رفتند و به جمع‌آوری نان پرداختند. بعضی زیاد جمع کردند و بعضی کم. ");
INSERT INTO pesopcb_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","اما وقتی نانی را که جمع کرده بودند با عومر اندازه گرفتند دیدند کسانی که زیاد جمع کرده بودند چیزی اضافه نداشتند و آنانی که کم جمع کرده بودند چیزی کم نداشتند، بلکه هر کس به اندازهٔ احتیاج خود جمع کرده بود. ");
INSERT INTO pesopcb_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","موسی به ایشان گفت: «چیزی از آن را نباید تا صبح نگه دارید.» ");
INSERT INTO pesopcb_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","ولی بعضی به حرف موسی اعتنا نکردند و قدری از آن را برای صبح نگه داشتند. اما چون صبح شد، دیدند پر از کرم شده و گندیده است. بنابراین، موسی از دست ایشان بسیار خشمگین شد. ");
INSERT INTO pesopcb_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","از آن پس، هر روز صبح زود هر کس به اندازهٔ احتیاج خود از آن نان جمع می‌کرد، و وقتی آفتاب بر زمین می‌تابید نانهایی که بر زمین مانده بود آب می‌شد. ");
INSERT INTO pesopcb_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","روز ششم، قوم اسرائیل دو برابر نان جمع کردند، یعنی برای هر نفر به جای یک عومر، دو عومر. آنگاه بزرگان بنی‌اسرائیل آمدند و این را به موسی گفتند. ");
INSERT INTO pesopcb_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","موسی به ایشان گفت: «خداوند فرموده که فردا روز استراحت و عبادت است. هر قدر خوراک لازم دارید امروز بپزید و مقداری از آن را برای فردا که ”شَبّات مقدّس خداوند“ است نگه دارید.» ");
INSERT INTO pesopcb_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","آنها طبق دستور موسی نان را تا روز بعد نگه داشتند و صبح که برخاستند دیدند همچنان سالم باقی مانده است. ");
INSERT INTO pesopcb_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","موسی به ایشان گفت: «این غذای امروز شماست، چون امروز ”شَبّاتِ خداوند“ است و چیزی روی زمین پیدا نخواهید کرد. ");
INSERT INTO pesopcb_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","شش روز خوراک جمع کنید، اما روز هفتم، شَبّات است و خوراک پیدا نخواهید کرد.» ");
INSERT INTO pesopcb_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","ولی بعضی از مردم در روز هفتم برای جمع کردن خوراک بیرون رفتند، اما هر چه گشتند چیزی نیافتند. ");
INSERT INTO pesopcb_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","خداوند به موسی فرمود: «این قوم تا کی می‌خواهند از احکام و اوامر من سرپیچی کنند؟ ");
INSERT INTO pesopcb_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","مگر نمی‌دانند که من در روز ششم، خوراک دو روز را به آنها می‌دهم و روز هفتم را که شَبّات باشد روز استراحت و عبادت معین کردم و نباید برای جمع کردن خوراک از خیمه‌های خود بیرون بروند؟» ");
INSERT INTO pesopcb_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","پس قوم اسرائیل در روز هفتم استراحت کردند. ");
INSERT INTO pesopcb_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","آنها اسم آن نان را مَنّا (یعنی «این چیست؟») گذاشتند و آن مثل دانه‌های گشنیز سفید بود و طعم نان عسلی را داشت. ");
INSERT INTO pesopcb_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","موسی بنی‌اسرائیل را خطاب کرده، گفت: «خداوند فرموده که از این نان به مقدار یک عومر به عنوان یادگار نگه داریم تا نسلهای آینده آن را ببینند و بدانند این همان نانی است که خداوند وقتی اجدادشان را از مصر بیرون آورد در بیابان به ایشان داد.» ");
INSERT INTO pesopcb_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","موسی به هارون گفت: «ظرفی پیدا کن و در آن به اندازهٔ یک عومر مَنّا بریز و آن را در حضور خداوند بگذار تا نسلهای آینده آن را ببینند.» ");
INSERT INTO pesopcb_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","هارون همان‌طور که خداوند به موسی فرموده بود عمل کرد. بعدها این نان در «صندوق عهد» نهاده شد. ");
INSERT INTO pesopcb_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","بنی‌اسرائیل تا رسیدن به کنعان و ساکن شدن در آن سرزمین، مدت چهل سال از این نانی که به مَنّا معروف بود، می‌خوردند. ");
INSERT INTO pesopcb_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","(عومر ظرفی بود به گنجایش دو لیتر که برای اندازه‌گیری به کار می‌رفت.) ");
INSERT INTO pesopcb_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","بنی‌اسرائیل به دستور خداوند از صحرای سین کوچ کردند و پس از چند توقف کوتاه، در رفیدیم اردو زدند. اما وقتی به آنجا رسیدند، دیدند که در آن مکان نیز آب برای نوشیدن پیدا نمی‌شود. ");
INSERT INTO pesopcb_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","پس گله و شکایت آغاز کردند و به موسی گفتند: «به ما آب بده تا بنوشیم.» موسی جواب داد: «چرا گله و شکایت می‌کنید؟ چرا خداوند را امتحان می‌نمایید؟» ");
INSERT INTO pesopcb_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","اما آنها که از تشنگی بی‌تاب شده بودند، علیه موسی فریاد زدند: «چرا ما را از مصر بیرون آوردی؟ آیا ما را به اینجا آوردی تا با فرزندان و دامهای خود از تشنگی بمیریم؟» ");
INSERT INTO pesopcb_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","موسی به حضور خداوند رفت و گفت: «من با این قوم چه کنم؟ هر آن ممکن است مرا سنگسار کنند.» ");
INSERT INTO pesopcb_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","خداوند در جواب موسی فرمود: «پیشاپیش قوم حرکت کن. عصایی را که با آن رود نیل را زدی به دست بگیر و برخی از مشایخ بنی‌اسرائیل را همراه خود بردار و روانه شو. ");
INSERT INTO pesopcb_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","من در آنجا پیش روی تو بر صخره‌ای که در کوه سینا است، می‌ایستم. تو با عصایت به صخره بزن که از آن آب جاری خواهد شد تا قوم بنوشند.» پس موسی همان‌طور که خداوند به او دستور داده بود، در برابر مشایخ به صخره زد و آب جاری شد. ");
INSERT INTO pesopcb_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","موسی اسم آنجا را مسّا (یعنی «قوم، خداوند را آزمایش کردند») گذاشت؛ ولی بعضی اسم آنجا را مِریبه (یعنی «محل بحث و مجادله») گذاشتند، چون در آنجا قوم اسرائیل به مجادله با خداوند پرداختند و گفتند: «آیا خداوند در میان ما هست یا نه؟» و به این ترتیب او را آزمایش کردند. ");
INSERT INTO pesopcb_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","عمالیقی‌ها به رفیدیم آمدند تا با بنی‌اسرائیل بجنگند. ");
INSERT INTO pesopcb_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","موسی به یوشع گفت: «افرادی از قوم انتخاب کن و فردا به جنگ عمالیقی‌ها برو. من عصای خدا را به دست گرفته بر فراز تپه خواهم ایستاد.» ");
INSERT INTO pesopcb_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","پس یوشع طبق دستور موسی به جنگ عمالیقی‌ها رفت و موسی و هارون و حور به بالای تپه رفتند. ");
INSERT INTO pesopcb_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","موسی دستهای خود را به طرف آسمان بلند کرد. تا زمانی که دستهای موسی بالا بود، جنگاوران اسرائیلی پیروز می‌شدند، اما هر وقت دستهای خود را از خستگی پایین می‌آورد، عمالیقی‌ها بر آنان چیره می‌گشتند. ");
INSERT INTO pesopcb_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","سرانجام موسی خسته شد و دیگر نتوانست دستهای خود را بالا ببرد. پس هارون و حور، او را روی سنگی نشاندند و از دو طرف دستهای او را تا غروب آفتاب بالا نگه داشتند. ");
INSERT INTO pesopcb_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","در نتیجه، یوشع و سپاهیان او، عمالیقی‌ها را به کلی تار و مار کردند. ");
INSERT INTO pesopcb_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","آنگاه خداوند به موسی فرمود: «شرح این پیروزی را در کتاب بنویس تا به یادگار بماند و به یوشع بگو که من نام و نشان مردم عمالیق را از روی زمین محو خواهم کرد.» ");
INSERT INTO pesopcb_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","موسی در آن مکان یک مذبح ساخت و آن را «یهوه نسی» (یعنی «خداوند پرچم پیروزی من است») نامید. ");
INSERT INTO pesopcb_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","سپس موسی به قوم اسرائیل گفت: «آنها مشتهایشان را بر ضد تخت خداوند بلند کرده‌اند، پس حال خداوند نسل اندر نسل با عمالیق در جنگ خواهد بود.» ");
INSERT INTO pesopcb_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","یترون، پدرزن موسی و کاهن مدیان شنید که خدا چه کارهایی برای موسی و قوم اسرائیل کرده و بخصوص اینکه چگونه خداوند آنها را از مصر رهانیده است. ");
INSERT INTO pesopcb_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","پیش از این، موسی زن خود صفوره را با دو پسرش نزد یترون فرستاده بود. ");
INSERT INTO pesopcb_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","(نام پسر اول موسی جرشوم بود زیرا به هنگام تولد او، موسی گفته بود: «من در سرزمین بیگانه، غریبم.» ");
INSERT INTO pesopcb_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","پسر دومش اِلعازار نام داشت، زیرا به هنگام تولد او، موسی گفته بود: «خدای پدرم یاورم بوده و مرا از شمشیر فرعون نجات داد.») ");
INSERT INTO pesopcb_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","پس یترون پدرزن موسی برای دیدن موسی به صحرا آمد. او پسران و زن موسی را نیز همراه خود آورده بود. در این وقت موسی و قوم نزدیک کوه خدا اردو زده بودند. ");
INSERT INTO pesopcb_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","یترون برای موسی پیام فرستاده بود که: «من، یترون، پدرزنت همراه زنت و دو پسرت می‌آییم تا تو را ببینیم.» ");
INSERT INTO pesopcb_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","پس موسی به استقبال یترون رفت، به او تعظیم کرد و صورت او را بوسید. پس از احوالپرسی، آنها به خیمهٔ موسی رفتند ");
INSERT INTO pesopcb_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","و موسی برای پدرزنش تعریف کرد که خداوند چه بلاهایی بر سر فرعون و مصری‌ها آورد تا بنی‌اسرائیل را رهایی دهد و چه مشقتی را در طول این سفر تحمل کردند تا به آنجا رسیدند و چگونه خداوند قوم خود را از خطرها و دشواریها نجات داد. ");
INSERT INTO pesopcb_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","یترون به سبب احسان خداوند بر بنی‌اسرائیل و آزادی آنها از مصر بسیار خوشحال شد ");
INSERT INTO pesopcb_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","و گفت: «متبارک باد خداوند که قوم خود را از دست فرعون و مصری‌ها نجات داد. ");
INSERT INTO pesopcb_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","اکنون می‌دانم که خداوند بزرگتر از همهٔ خدایان است، زیرا او قوم خود را از دست مصری‌های متکبر و بی‌رحم نجات داده است.» ");
INSERT INTO pesopcb_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","یترون قربانی سوختنی و قربانیهای دیگر به خدا تقدیم کرد، و هارون و همهٔ مشایخ قوم اسرائیل به دیدن او آمدند و در حضور خدا برای خوردن گوشت قربانی دور هم نشستند. ");
INSERT INTO pesopcb_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","روز بعد، موسی برای رسیدگی به شکایتهای مردم در جایگاه خود نشست و مردم از صبح تا غروب در حضور او ایستادند. ");
INSERT INTO pesopcb_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","یترون وقتی دید که رسیدگی به شکایتهای مردم، وقت زیادی را می‌گیرد، به موسی گفت: «چرا این کار را به تنهایی انجام می‌دهی؟ چرا مردم را تمام روز سر پا نگه می‌داری؟» ");
INSERT INTO pesopcb_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","موسی جواب داد: «من باید این کار را بکنم، زیرا مردم برای حل مشکلات خود پیش من می‌آیند تا نظر خدا را بدانند. ");
INSERT INTO pesopcb_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","وقتی بین دو نفر اختلافی پیش می‌آید، نزد من می‌آیند و من تشخیص می‌دهم که حق با چه کسی است و فرایض و شریعت خدا را به آنها تعلیم می‌دهم.» ");
INSERT INTO pesopcb_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","پدرزن موسی گفت: «این کار تو درست نیست. ");
INSERT INTO pesopcb_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","تو با این کار، خود را از پای در می‌آوری و قوم را نیز خسته می‌کنی. تو نمی‌توانی این کار سنگین را به تنهایی انجام دهی. ");
INSERT INTO pesopcb_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","حرف مرا گوش کن و نصیحت مرا بپذیر و خدا تو را برکت خواهد داد. تو در حضور خدا نمایندهٔ این مردم باش و مسائل و مشکلات ایشان را به او بگو. ");
INSERT INTO pesopcb_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","تو باید قوانین و شریعت خدا را به آنها تعلیم دهی و بگویی که چطور زندگی کنند و چه رفتاری داشته باشند. ");
INSERT INTO pesopcb_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","در ضمن از میان همۀ قوم مردانی کاردان و خداترس و درستکار که از رشوه متنفر باشند انتخاب کن تا آنها در گروه‌های هزار نفره، صد نفره، پنجاه نفر و ده نفره داور و رهبر باشند. ");
INSERT INTO pesopcb_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","آنها باید همیشه آماده باشند تا به مسائل جزئی مردم رسیدگی کنند اما مسائل مهم را نزد تو بیاورند. بگذار رهبران خودشان مسائل جزئی را حل کنند. بدین ترتیب آنها بار تو را سبکتر خواهند کرد. ");
INSERT INTO pesopcb_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","اگر این روش را در پیش‌گیری و خواست خدا نیز چنین باشد، آنگاه خسته نخواهی شد و قوم نیز در حالی که اختلافشان حل شده است، راضی به خانه‌های خویش باز خواهند گشت.» ");
INSERT INTO pesopcb_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","موسی نصیحت پدرزن خود را پذیرفت و مطابق پیشنهاد او عمل کرد. ");
INSERT INTO pesopcb_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","او مردان کاردانی را برگزید و از میان آنها برای هر هزار نفر، صد نفر، پنجاه نفر و ده نفر قضاتی تعیین کرد. ");
INSERT INTO pesopcb_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","آنها مرتب به کار قضاوت مشغول بودند و به مشکلات و اختلافات کوچکتر رسیدگی می‌کردند، ولی برای حل مسائل مهم و پیچیده نزد موسی می‌آمدند. ");
INSERT INTO pesopcb_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","پس از چند روز، موسی پدرزنش را بدرقه کرد و او به ولایت خود بازگشت. ");
INSERT INTO pesopcb_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","بنی‌اسرائیل در ماه سوم خروجشان از مصر، در همان نخستین روز ماه، به صحرای سینا رسیدند. ");
INSERT INTO pesopcb_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","آنان پس از ترک رفیدیم وارد بیابان سینا شدند و در مقابل کوه سینا اردو زدند. ");
INSERT INTO pesopcb_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","موسی برای ملاقات با خدا به بالای کوه رفت. خداوند از میان کوه خطاب به موسی فرمود: «این دستورها را به خاندان یعقوب بده؛ آنها را به بنی‌اسرائیل اعلان کن: ");
INSERT INTO pesopcb_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","”شما دیدید که من با مصری‌ها چه کردم و چطور مانند عقابی که بچه‌هایش را روی بالهای خود می‌برد، شما را برداشته، پیش خود آوردم. ");
INSERT INTO pesopcb_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","حال اگر مطیع من باشید و عهد مرا نگاه دارید، از میان همهٔ اقوام، شما قوم خاص من خواهید بود؛ زیرا سراسر جهان مال من است. ");
INSERT INTO pesopcb_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","شما برای من مملکتی از کاهنان و قومی مقدّس خواهید بود.“ این است آنچه باید به بنی‌اسرائیل بگویی.» ");
INSERT INTO pesopcb_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","پس موسی از کوه فرود آمد و مشایخ بنی‌اسرائیل را دور خود جمع کرد و هر چه را که خداوند به او فرموده بود به ایشان بازگفت. ");
INSERT INTO pesopcb_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","همهٔ قوم یکصدا جواب دادند: «هر آنچه خداوند از ما خواسته است، انجام می‌دهیم.» پس موسی نزد خداوند بازگشت تا آنچه قوم گفته بودند به او بازگوید. ");
INSERT INTO pesopcb_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","آنگاه خداوند به موسی فرمود: «من در ابر غلیظی نزد تو می‌آیم تا هنگامی که با تو گفتگو می‌کنم قوم به گوش خود صدای مرا بشنوند و از این پس گفتار تو را باور کنند.» موسی سخنان قوم را به خداوند عرض کرد ");
INSERT INTO pesopcb_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","و خداوند به موسی فرمود: «حال پایین برو و قوم را برای آمدن من آماده کن. ایشان را امروز و فردا تقدیس کن و به آنها بگو لباسهای خود را بشویند، ");
INSERT INTO pesopcb_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","و روز سوم آماده باشند، زیرا در آن روز خداوند در برابر چشمان همۀ قوم بر کوه سینا نزول خواهد کرد. ");
INSERT INTO pesopcb_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","حدودی دور تا دور کوه تعیین کن که قوم از آن جلوتر نیایند و به ایشان بگو که از کوه بالا نروند و حتی دامنۀ آن را لمس نکنند. هر که کوه را لمس کند کشته خواهد شد. ");
INSERT INTO pesopcb_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","او باید سنگسار گردد و یا با تیر کشته شود بدون اینکه کسی به او دست بزند. این قانون شامل حیوانات نیز می‌شود. پس به کوه نزدیک نشوید تا اینکه صدای شیپور برخیزد، آنگاه می‌توانید از کوه بالا بروید.» ");
INSERT INTO pesopcb_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","موسی از کوه فرود آمد و بنی‌اسرائیل را تقدیس نمود و آنها لباسهای خود را شستند. ");
INSERT INTO pesopcb_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","موسی به ایشان فرمود: «خود را برای روز سوم آماده کنید، و تا آن روز با زنان خود نزدیکی ننمایید.» ");
INSERT INTO pesopcb_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","صبح روز سوم، صدای هولناک رعد و برق شنیده شد و ابر غلیظی روی کوه پدید آمد. سپس صدای بسیار بلندی چون صدای شیپور برخاست. تمام قوم از ترس لرزیدند. ");
INSERT INTO pesopcb_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","آنگاه موسی آنها را برای ملاقات با خدا از اردوگاه بیرون برد. همه در پای کوه ایستادند. ");
INSERT INTO pesopcb_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","تمام کوه سینا از دود پوشیده شد، زیرا خداوند در آتش بر آن نزول کرد. از کوه دود برخاست و مانند دود کوره، در هوا بالا رفت و تمام کوه به شدت لرزید. ");
INSERT INTO pesopcb_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","در حالی که صدای کَرِنا هر لحظه بلندتر می‌شد، موسی با خدا سخن می‌گفت و خدا هم با صدایی نظیر صدای رعد به او جواب می‌داد. ");
INSERT INTO pesopcb_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","وقتی خداوند بر قلهٔ کوه سینا نزول کرده بود، موسی را فرا خواند و موسی نیز به قلهٔ کوه بالا رفت. ");
INSERT INTO pesopcb_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","خداوند به موسی فرمود: «پایین برو و به قوم هشدار بده که از حدود تعیین شده تجاوز نکنند و برای دیدن خداوند بالا نیایند و گرنه هلاک می‌شوند. ");
INSERT INTO pesopcb_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","حتی کاهنانی که به من نزدیک می‌شوند باید خود را تقدیس کنند تا خداوند بر ایشان غضبناک نشود.» ");
INSERT INTO pesopcb_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","موسی عرض کرد: «قوم نمی‌توانند از کوه سینا بالا بیایند، زیرا تو خود به ما هشدار داده، گفتی: ”حدودی دور تا دور کوه تعیین کن و آن را مقدّس بشمار.“» ");
INSERT INTO pesopcb_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","خداوند فرمود: «پایین برو و هارون را با خود بالا بیاور. در ضمن نگذار کاهنان یا قوم از آن حد تجاوز کنند تا نزد من بالا بیایند، زیرا آنها را در هم شکسته، نابود خواهم کرد.» ");
INSERT INTO pesopcb_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","پس موسی نزد قوم پایین رفت و آنچه خداوند به او فرموده بود به ایشان بازگفت. ");
INSERT INTO pesopcb_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","خدا با موسی سخن گفت و این احکام را صادر کرد: ");
INSERT INTO pesopcb_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","«من خداوند، خدای تو هستم، که تو را از اسارت و بندگی مصر آزاد کردم. ");
INSERT INTO pesopcb_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","«تو را خدایان دیگر غیر از من نباشد. ");
INSERT INTO pesopcb_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","«هیچگونه بُتی به شکل آنچه بالا در آسمان و آنچه بر زمین و آنچه در دریاست برای خود درست نکن. ");
INSERT INTO pesopcb_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","در برابر آنها زانو نزن و آنها را پرستش نکن، زیرا من که خداوند، خدای تو می‌باشم، خدای غیور هستم و کسانی را که با من دشمنی کنند، مجازات می‌کنم. این مجازات، شامل حال فرزندان آنها تا نسل سوم و چهارم نیز می‌گردد. ");
INSERT INTO pesopcb_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","اما بر کسانی که مرا دوست داشته باشند و دستورهای مرا پیروی کنند، تا هزار نسل رحمت می‌کنم. ");
INSERT INTO pesopcb_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","«از نام من که خداوند، خدای تو هستم به ناشایستگی استفاده نکن. اگر نام مرا با بی‌احترامی به زبان بیاوری یا به آن قسم دروغ بخوری، تو را مجازات می‌کنم. ");
INSERT INTO pesopcb_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","«روز شَبّات را به یاد داشته باش و آن را مقدّس بدار. ");
INSERT INTO pesopcb_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","در هفته شش روز کار کن، ");
INSERT INTO pesopcb_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","ولی در روز هفتم که شَبّات یهوه خدای توست هیچ کار نکن، نه خودت، نه پسرت، نه دخترت، نه غلامت، نه کنیزت، نه مهمانانت و نه چارپایانت. ");
INSERT INTO pesopcb_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","چون خداوند در شش روز، آسمان و زمین و دریا و هر آنچه را که در آنهاست آفرید و روز هفتم دست از کار کشید. پس او روز شَبّات را مبارک خواند و آن را تقدیس کرد. ");
INSERT INTO pesopcb_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","«پدر و مادر خود را گرامی بدار تا در سرزمینی که خداوند، خدای تو به تو خواهد بخشید، عمر طولانی داشته باشی. ");
INSERT INTO pesopcb_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","«قتل نکن. ");
INSERT INTO pesopcb_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","«زنا نکن. ");
INSERT INTO pesopcb_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","«دزدی نکن. ");
INSERT INTO pesopcb_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","«بر همنوع خود شهادت دروغ نده. ");
INSERT INTO pesopcb_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","«به خانۀ همسایه‌ات طمع نکن. به زن همسایه‌ات، یا غلام و کنیزش، یا گاو و الاغش، یا اموالش طمع نکن.» ");
INSERT INTO pesopcb_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","وقتی قوم اسرائیل رعد و برق و بالا رفتن دود را از کوه دیدند و صدای شیپور را شنیدند، از ترس لرزیدند. آنها در فاصله‌ای دور از کوه ایستادند ");
INSERT INTO pesopcb_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","و به موسی گفتند: «تو خود پیام خدا را بگیر و به ما برسان و ما خواهیم شنید. اما خدا مستقیم با ما صحبت نکند، چون می‌ترسیم بمیریم.» ");
INSERT INTO pesopcb_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","موسی گفت: «نترسید، چون خدا برای این آمده است که شما را امتحان کند تا از این پس، از او بترسید و گناه نکنید.» ");
INSERT INTO pesopcb_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","در حالی که همهٔ قوم آنجا ایستاده بودند، دیدند که موسی به ظلمت غلیظی که خدا در آن بود، نزدیک شد. ");
INSERT INTO pesopcb_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","آنگاه خداوند از موسی خواست تا به قوم اسرائیل چنین بگوید: «شما خود دیدید چگونه از آسمان با شما صحبت کردم، ");
INSERT INTO pesopcb_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","پس دیگر برای خود خدایانی از طلا و نقره نسازید و آنها را پرستش نکنید. ");
INSERT INTO pesopcb_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","«مذبحی که برای من می‌سازید باید از خاک زمین باشد. از گله و رمهٔ خود قربانیهای سوختنی و قربانیهای سلامتی روی این مذبح قربانی کنید. در جایی که من برای گرامیداشت نام خود تعیین می‌کنم، مذبح بسازید تا من آمده، شما را در آنجا برکت دهم. ");
INSERT INTO pesopcb_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","اگر خواستید مذبح را از سنگ بنا کنید، سنگها را با ابزار نشکنید و نتراشید، چون سنگهایی که روی آنها ابزار به کار رفته باشد مناسب مذبح من نیستند. ");
INSERT INTO pesopcb_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","برای مذبح، پله نگذارید مبادا وقتی از پله‌ها بالا می‌روید عریانی شما دیده شود. ");
INSERT INTO pesopcb_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","«سایر احکامی که باید اطاعت کنید، اینها هستند: ");
INSERT INTO pesopcb_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","«اگر غلامی عبرانی بخری فقط باید شش سال تو را خدمت کند. سال هفتم باید آزاد شود بدون اینکه برای کسب آزادی خود قیمتی بپردازد. ");
INSERT INTO pesopcb_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","اگر قبل از اینکه غلام تو شود مجرد بوده، باید مجرد هم از نزد تو برود، اما اگر همسر داشته، همسرش نیز باید همراه او آزاد شود. اما اگر قبل از اینکه غلام تو شود همسری داشته باشد، آنگاه هر دو آنها در یک زمان آزاد شوند. ");
INSERT INTO pesopcb_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","ولی اگر اربابش برای او زن گرفته باشد و او از وی صاحب پسران و دخترانی شده باشد، آنگاه فقط خودش آزاد می‌شود و زن و فرزندانش نزد اربابش باقی می‌مانند. ");
INSERT INTO pesopcb_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","«اگر آن غلام بگوید: ”من ارباب و زن و فرزندانم را دوست می‌دارم و آنها را بر آزادی خود ترجیح می‌دهم و نمی‌خواهم آزاد شوم،“ ");
INSERT INTO pesopcb_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","آنگاه اربابش او را پیش قضات قوم ببرد و در حضور همه گوش او را با درفشی سوراخ کند، و او همیشه غلام اربابش باقی خواهد ماند. ");
INSERT INTO pesopcb_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","«اگر مردی دختر خود را به‌عنوان کنیز بفروشد، آن کنیز مانند غلام در پایان سال ششم آزاد نمی‌شود. ");
INSERT INTO pesopcb_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","اگر اربابش که آن کنیز را خریده و نامزد خود کرده است، از او راضی نباشد، باید اجازه دهد تا وی بازخرید شود؛ ولی حق ندارد او را به یک غیراسرائیلی بفروشد، چون این کار در حق او خیانت شمرده می‌شود. ");
INSERT INTO pesopcb_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","اگر ارباب بخواهد کنیز را برای پسرش نامزد کند، باید مطابق رسوم دختران آزاد با او رفتار کند، نه به عنوان یک کنیز. ");
INSERT INTO pesopcb_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","اگر خودش با آن کنیز ازدواج کند و بعد زن دیگری نیز بگیرد، نباید از خوراک و پوشاک و حق همسری او چیزی کم کند. ");
INSERT INTO pesopcb_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","اگر ارباب در رعایت این سه نکته کوتاهی کند، آنگاه آن کنیز آزاد است و می‌تواند بدون پرداخت مبلغی، ارباب خود را ترک کند. ");
INSERT INTO pesopcb_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","«اگر کسی انسانی را طوری بزند که منجر به مرگ وی گردد، او نیز باید کشته شود. ");
INSERT INTO pesopcb_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","اما اگر او قصد کشتن نداشته و مرگ، تصادفی بوده باشد، آنگاه مکانی برایش تعیین می‌کنم تا به آنجا پناهنده شده، در امان باشد. ");
INSERT INTO pesopcb_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","ولی اگر شخصی، به عمد و با قصد قبلی به کسی حمله کند و او را بکشد، حتی اگر به مذبح من نیز پناه برده باشد، باید از بست بیرون کشیده، کشته شود. ");
INSERT INTO pesopcb_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","«هر که پدر یا مادرش را بزند، باید کشته شود. ");
INSERT INTO pesopcb_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","«هر کس انسانی را بدزدد، خواه او را فروخته و خواه نفروخته باشد، باید کشته شود. ");
INSERT INTO pesopcb_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","«هر کس پدر یا مادر خود را لعنت کند، باید کشته شود. ");
INSERT INTO pesopcb_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","«اگر دو نفر با هم گلاویز بشوند و یکی از آنها دیگری را با سنگ یا با مشت چنان بزند که او مجروح و بستری شود اما نمیرد، ");
INSERT INTO pesopcb_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","و بعد از اینکه حالش خوب شد بتواند با کمک عصا راه برود، آنگاه ضارب بخشیده می‌شود، به شرطی که تمام مخارج معالجه و تاوان روزهای بیکاری مجروح را تا وقتی که کاملاً خوب نشده بپردازد. ");
INSERT INTO pesopcb_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","«اگر کسی غلام یا کنیز خود را طوری با چوب بزند که منجر به مرگ او گردد، باید مجازات شود. ");
INSERT INTO pesopcb_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","اما اگر آن غلام یا کنیز چند روزی پس از کتک خوردن زنده بماند، اربابش مجازات نمی‌شود، زیرا آن غلام یا کنیز به او تعلق دارد. ");
INSERT INTO pesopcb_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","«اگر عده‌ای با هم درگیر شوند و در جریان این دعوا، زن حامله‌ای را طوری بزنند که بچۀ او پیش از موعد به دنیا بیاید، ولی آسیب جدی به خود او وارد نیاید، ضارب هر مبلغی را که شوهر آن زن بخواهد و قاضی آن را تأیید کند، باید جریمه بدهد. ");
INSERT INTO pesopcb_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","ولی اگر به خود آن زن صدمه‌ای وارد شود، باید همان صدمه به ضارب نیز وارد گردد: جان به عوض جان، ");
INSERT INTO pesopcb_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","چشم به عوض چشم، دندان به عوض دندان، دست به عوض دست، پا به عوض پا، ");
INSERT INTO pesopcb_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","داغ به عوض داغ، زخم به عوض زخم، و کبودی به عوض کبودی. ");
INSERT INTO pesopcb_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","«اگر کسی با وارد کردن ضربه‌ای به چشم غلام یا کنیزش او را کور کند، باید او را به عوض چشمش آزاد کند. ");
INSERT INTO pesopcb_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","اگر کسی دندان غلام یا کنیز خود را بشکند، باید او را به عوض دندانش آزاد کند. ");
INSERT INTO pesopcb_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","«اگر گاوی به مرد یا زنی شاخ بزند و او را بکشد، آن گاو باید سنگسار شود و گوشتش هم خورده نشود، اما صاحب آن گاو بی‌گناه شمرده می‌شود. ");
INSERT INTO pesopcb_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","ولی اگر آن گاو قبلاً سابقهٔ شاخ زنی داشته و صاحبش هم از این موضوع باخبر بوده، اما گاو را نبسته باشد، در این صورت باید هم گاو سنگسار گردد و هم صاحبش کشته شود. ");
INSERT INTO pesopcb_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","ولی اگر بستگان مقتول راضی شوند که خون‌بها را قبول کنند، صاحب گاو می‌تواند با پرداخت خونبهای تعیین شده، جان خود را نجات دهد. ");
INSERT INTO pesopcb_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","«اگر گاوی به دختر یا پسری شاخ بزند و او را بکشد، همین حکم اجرا شود. ");
INSERT INTO pesopcb_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","اما اگر گاو به غلام یا کنیزی شاخ بزند و او را بکشد، باید سی مثقال نقره به ارباب آن غلام یا کنیز داده شود و گاو هم سنگسار گردد. ");
INSERT INTO pesopcb_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","«اگر کسی چاهی بکند و روی آن را نپوشاند و گاو یا الاغی در آن بیفتد، ");
INSERT INTO pesopcb_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","صاحب چاه باید قیمت آن حیوان را به صاحبش بپردازد و حیوان مرده از آن او باشد. ");
INSERT INTO pesopcb_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","«اگر گاوی، گاو دیگری را بزند و بکشد، صاحبان آن دو گاو باید گاو زنده را بفروشند و قیمت آن را میان خود تقسیم کنند، و هر یک از آنها هم می‌تواند نیمی از گاو کشته شده را برای خود بردارد. ");
INSERT INTO pesopcb_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","ولی اگر گاوی که زنده مانده، سابقهٔ شاخ زنی داشته و صاحبش آن را نبسته باشد، باید گاو زنده‌ای به عوض گاو کشته بدهد و گاو کشته شده را برای خود بردارد. ");
INSERT INTO pesopcb_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","«اگر کسی گاو یا گوسفندی را بدزدد و بفروشد یا سر ببرد باید به عوض گاوی که دزدیده پنج گاو و به عوض گوسفند، چهار گوسفند پس بدهد. ");
INSERT INTO pesopcb_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","اگر دزدی در حال نَقب زدن گرفتار شود و او را بزنند به طوری که بمیرد، کسی که او را کشته مجرم نخواهد بود. ");
INSERT INTO pesopcb_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","اما اگر این کار در روز روشن واقع شود، کسی که او را کشته مجرم شناخته خواهد شد. «دزدی که گرفتار شود باید هر چه را دزدیده پس دهد. اگر نتواند پس بدهد، خود او را باید فروخت تا غرامت پرداخت شود. ");
INSERT INTO pesopcb_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","اگر کسی گاو یا الاغ یا گوسفندی بدزدد و آن حیوان در دست دزد زنده یافت شود، باید دو برابر قیمت حیوان غرامت پرداخت کند. ");
INSERT INTO pesopcb_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","«اگر کسی چارپایان خود را به داخل تاکستان شخص دیگری رها کند، و یا آنها را در مزرعهٔ شخص دیگری بچراند، باید از بهترین محصول خود، برابر خسارت وارده به صاحب تاکستان یا مزرعه غرامت بپردازد. ");
INSERT INTO pesopcb_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","«اگر کسی در مزرعه‌اش آتشی روشن کند و آتش به مزرعهٔ شخص دیگری سرایت نماید و بافه‌ها یا محصول درو نشده و یا تمام مزرعهٔ او را بسوزاند، آنکه آتش را افروخته است باید غرامت تمام خسارات وارده را بپردازد. ");
INSERT INTO pesopcb_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","«اگر کسی پول یا شیئی را پیش شخصی به امانت گذارد تا از آن نگهداری کند، و آن امانت دزدیده شود، اگر دزد دستگیر شود باید دو برابر آنچه را که دزدیده است خسارت دهد. ");
INSERT INTO pesopcb_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","ولی اگر دزد گرفتار نشود، آنگاه باید شخص امانتدار را نزد قضات ببرند تا معلوم شود آیا خود او در امانت خیانت کرده است یا نه. ");
INSERT INTO pesopcb_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","«هرگاه گاو، گوسفند، الاغ، لباس و یا هر چیز دیگری گم شود و صاحبش ادعا کند که گمشده‌اش پیش فلان شخص است، ولی آن شخص انکار کند، باید هر دو به حضور قضات بیایند و کسی که مقصر شناخته شد دو برابر مالی که دزدیده شده، تاوان دهد. ");
INSERT INTO pesopcb_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","«اگر کسی گاو یا الاغ یا گوسفند یا هر حیوان دیگری را به دست همسایه به امانت بسپارد و آن حیوان بمیرد، یا آسیب ببیند، و یا غارت شود بی‌آنکه شخصی ببیند، ");
INSERT INTO pesopcb_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","آنگاه آن همسایه باید به پیشگاه خداوند سوگند یاد کند که آن را ندزدیده است و صاحب مال باید سوگند او را بپذیرد و از گرفتن غرامت، خودداری کند. ");
INSERT INTO pesopcb_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","ولی اگر حیوان یا مال امانتی از نزد امانتدار دزدیده شود، امانتدار باید به صاحب مال غرامت دهد. ");
INSERT INTO pesopcb_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","اگر احیاناً جانوری وحشی آن را دریده باشد، شخص امانتدار باید لاشهٔ دریده شده را برای اثبات این امر نشان دهد، که در این صورت غرامت گرفته نمی‌شود. ");
INSERT INTO pesopcb_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","«اگر کسی حیوانی را از همسایهٔ خود قرض بگیرد و آن حیوان آسیب ببیند یا کشته شود، البته باید غرامت بپردازد. ");
INSERT INTO pesopcb_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","اما اگر صاحبش در آنجا حاضر بوده باشد، احتیاجی به پرداخت تاوان نیست. اگر حیوان کرایه شده باشد همان کرایه، غرامت را نیز شامل می‌شود. ");
INSERT INTO pesopcb_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","«اگر مردی، دوشیزه‌ای را که هنوز نامزد نشده اغفال کند، باید مهریهٔ او را پرداخته، وی را به عقد خود درآورد. ");
INSERT INTO pesopcb_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","ولی اگر پدر دختر با این ازدواج راضی نباشد، آن مرد باید فقط مهریهٔ تعیین شده را به او بپردازد. ");
INSERT INTO pesopcb_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","«زنی که جادوگری کند، باید کشته شود. ");
INSERT INTO pesopcb_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","«هر انسانی که با حیوانی نزدیکی نماید، باید کشته شود. ");
INSERT INTO pesopcb_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","«اگر کسی برای خدایی دیگر، غیر از خداوند قربانی کند، باید کشته شود. ");
INSERT INTO pesopcb_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","«به شخص غریب ظلم نکنید. به یاد آورید که شما نیز در سرزمین مصر غریب بودید. ");
INSERT INTO pesopcb_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","«از بیوه‌زن و یتیم بهره‌کشی نکنید. ");
INSERT INTO pesopcb_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","اگر بر آنها ظلمی روا دارید و ایشان پیش من فریاد برآورند، من به داد آنها می‌رسم، ");
INSERT INTO pesopcb_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","و بر شما خشمگین شده، شما را به شمشیر خواهم کشت تا زنان شما بیوه شوند و فرزندانتان یتیم گردند. ");
INSERT INTO pesopcb_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","«اگر به یکی از افراد قوم خود که محتاج باشد، پول قرض دادی، مثل یک رباخوار رفتار نکن و از او سود نگیر. ");
INSERT INTO pesopcb_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","اگر لباس همسایه‌ات را گرو گرفتی، قبل از غروب آفتاب آن را به او پس بده، ");
INSERT INTO pesopcb_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","چون ممکن است آن لباس تنها پوشش او برای خوابیدن باشد. اگر آن لباس را به او پس ندهی و او پیش من ناله کند من به داد او خواهم رسید، زیرا خدایی رئوف هستم. ");
INSERT INTO pesopcb_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","«به خدا ناسزا نگو و به رهبران قوم خود لعنت نفرست. ");
INSERT INTO pesopcb_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","«نوبر غلات و عصارۀ انگور خود را به موقع به حضور من بیاور. «پسران نخست‌زاده‌ات را به من تقدیم کن. ");
INSERT INTO pesopcb_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","«نخست‌زاده‌های نر گاوان و گوسفندان خود را به من بده. بگذار این نخست‌زاده‌ها یک هفته پیش مادرشان بمانند و در روز هشتم آنها را به من بده. ");
INSERT INTO pesopcb_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","«شما قوم مقدّس من هستید، پس گوشت حیوانی را که به‌وسیله جانور وحشی دریده شده، نخورید؛ آن را نزد سگان بیندازید. ");
INSERT INTO pesopcb_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","«خبر دروغ را منتشر نکنید و با دادن شهادت دروغ با خطاکار همکاری ننمایید. ");
INSERT INTO pesopcb_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","وقتی در دادگاه در مقام شاهد ایستاده‌اید دنباله‌رو جماعت در انجام کار بد نشوید و تحت تأثیر نظر اکثریت، عدالت را پایمال نکنید، ");
INSERT INTO pesopcb_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","و از کسی صرفاً به خاطر اینکه فقیر است طرفداری نکنید. ");
INSERT INTO pesopcb_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","«اگر به گاو یا الاغ گمشدهٔ دشمن خود برخوردید آن را نزد صاحبش برگردانید. ");
INSERT INTO pesopcb_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","اگر الاغ دشمنت را دیدید که در زیر بار افتاده است، بی‌اعتنا از کنارش رد نشوید، بلکه به او کمک کنید تا الاغ خود را از زمین بلند کند. ");
INSERT INTO pesopcb_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","«در دادگاه، حق شخص فقیر را پایمال نکنید. ");
INSERT INTO pesopcb_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","تهمت ناروا به کسی نزنید و نگذارید شخص بی‌گناه به مرگ محکوم شود. من کسی را که عدالت را زیر پا گذارد بی‌سزا نخواهم گذاشت. ");
INSERT INTO pesopcb_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","«رشوه نگیرید، چون رشوه چشمان بینایان را کور می‌کند و راستگویان را به دروغگویی وا می‌دارد. ");
INSERT INTO pesopcb_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","«به اشخاص غریب ظلم نکنید، چون خودتان در مصر غریب بودید و از حال غریبان آگاهید. ");
INSERT INTO pesopcb_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","«در زمین خود شش سال کشت و زرع کنید، و محصول آن را درو نمایید. ");
INSERT INTO pesopcb_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","اما در سال هفتم بگذارید زمین استراحت کند و آنچه را که در آن می‌روید واگذارید تا فقرا از آن استفاده کنند و آنچه از آن باقی بماند حیوانات صحرا بخورند. این دستور در مورد باغ انگور و باغ زیتون نیز صدق می‌کند. ");
INSERT INTO pesopcb_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","«شش روز کار کنید و در روز هفتم استراحت نمایید تا غلامان و کنیزان و غریبانی که برایتان کار می‌کنند و حتی چارپایانتان بتوانند استراحت نمایند. ");
INSERT INTO pesopcb_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","«از آنچه که به شما گفته‌ام اطاعت کنید. نزد خدایان غیر دعا نکنید و حتی اسم آنها را بر زبان نیاورید. ");
INSERT INTO pesopcb_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","«هر سال این سه عید را به احترام من نگاه دارید. ");
INSERT INTO pesopcb_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","اول، عید فطیر: همان‌طور که قبلاً دستور دادم در این عید هفت روز نان فطیر بخورید. این عید را به طور مرتب در ماه ابیب هر سال برگزار کنید، چون در همین ماه بود که از مصر بیرون آمدید. در این عید همهٔ شما باید به حضور من هدیه بیاورید. ");
INSERT INTO pesopcb_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","دوم، عید حصاد: آن وقتی است که شما باید نوبر محصولات خود را به من تقدیم کنید. سوم، عید جمع‌آوری: این عید را در آخر سال، هنگام جمع‌آوری محصول برگزار کنید. ");
INSERT INTO pesopcb_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","هر سال در این سه عید، تمام مردان بنی‌اسرائیل باید در حضور خداوند حاضر شوند. ");
INSERT INTO pesopcb_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","«خون حیوان قربانی را همراه با نان خمیرمایه‌دار به من تقدیم نکنید. نگذارید چربی قربانیهایی که به من تقدیم کرده‌اید تا صبح بماند. ");
INSERT INTO pesopcb_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","«بهترین نوبر هر محصولی را که درو می‌کنید، به خانهٔ یهوه خدایتان بیاورید. «بزغاله را در شیر مادرش نپزید. ");
INSERT INTO pesopcb_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","«من فرشته‌ای پیشاپیش شما می‌فرستم تا شما را در راه محافظت کند و شما را به سلامت به سرزمینی که برای شما آماده کرده‌ام، برساند. ");
INSERT INTO pesopcb_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","به سخنان او توجه کنید و از دستورهایش پیروی نمایید. از او تمّرد نکنید، زیرا گناهان شما را نخواهد بخشید، چرا که او نمایندهٔ من است و نام من بر اوست. ");
INSERT INTO pesopcb_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","اگر مطیع او باشید و تمام دستورهای مرا اطاعت کنید، آنگاه من دشمن دشمنان شما خواهم بود و مخالفِ مخالفانتان. ");
INSERT INTO pesopcb_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","فرشتهٔ من پیشاپیش شما خواهد رفت و شما را به سرزمین اموری‌ها، حیتی‌ها، فرزی‌ها، کنعانی‌ها، حوی‌ها و یبوسی‌ها هدایت خواهد کرد و من آنها را هلاک خواهم نمود. ");
INSERT INTO pesopcb_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","شما نباید خدایان آنها را پرستش کنید و مراسم ننگین آنها را انجام دهید. این اقوام را نابود کنید و بتهای ستونی آنها را بشکنید. ");
INSERT INTO pesopcb_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","«خداوند، خدای خود را عبادت کنید و او نان و آب شما را برکت خواهد داد و بیماری را از میان شما دور خواهد کرد. ");
INSERT INTO pesopcb_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","در میان شما سقط جنین و نازایی وجود نخواهد داشت. او به شما عمر طولانی خواهد بخشید. ");
INSERT INTO pesopcb_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","«من وحشت خود را پیش روی شما خواهم فرستاد تا به هر سرزمینی که هجوم برید، ترس خداوند بر مردمانش مستولی شود و آنها از برابر شما فرار کنند. ");
INSERT INTO pesopcb_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","من زنبورهای سرخ می‌فرستم تا قومهای حوی، کنعانی و حیتی را از حضور شما بیرون کنند. ");
INSERT INTO pesopcb_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","البته آن قومها را تا یک سال بیرون نخواهم کرد مبادا زمین خالی و ویران گردد و حیوانات درنده بیش از حد زیاد شوند. ");
INSERT INTO pesopcb_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","این قومها را به تدریج از آنجا بیرون می‌کنم تا کم‌کم جمعیت شما زیاد شود و تمام زمین را پر کند. ");
INSERT INTO pesopcb_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","مرز سرزمین شما را از دریای سرخ تا کرانهٔ فلسطین و از صحرای جنوب تا رود فرات وسعت می‌دهم و به شما کمک می‌کنم تا ساکنان آن سرزمین را شکست داده، بیرون کنید. ");
INSERT INTO pesopcb_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","«با آنها و خدایان ایشان عهد نبندید ");
INSERT INTO pesopcb_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","و نگذارید در میان شما زندگی کنند، وگرنه شما را به بت‌پرستی کشانده، به مصیبت عظیم گرفتار خواهند ساخت.» ");
INSERT INTO pesopcb_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","سپس خداوند به موسی فرمود: «تو و هارون و ناداب و ابیهو با هفتاد نفر از مشایخ اسرائیل به بالای کوه نزد من بیایید ولی به من نزدیک نشوید، بلکه از فاصلهٔ دور مرا سجده کنید. ");
INSERT INTO pesopcb_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","تنها تو ای موسی، به حضور من بیا، ولی بقیه نزدیک نیایند. هیچ‌یک از افراد قوم نیز نباید از کوه بالا بیایند.» ");
INSERT INTO pesopcb_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","پس موسی بازگشت و قوانین و دستورهای خداوند را به بنی‌اسرائیل بازگفت. تمام مردم یکصدا گفتند: «هر چه خداوند فرموده است، انجام خواهیم داد.» ");
INSERT INTO pesopcb_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","موسی تمام دستورهای خداوند را نوشت و صبح روز بعد، بامدادان برخاست و در پای آن کوه مذبحی بنا کرد و به تعداد قبایل بنی‌اسرائیل، دوازده ستون در اطراف آن بر پا نمود. ");
INSERT INTO pesopcb_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","آنگاه چند نفر از جوانان بنی‌اسرائیل را فرستاد تا قربانیهای سوختنی و قربانیهای سلامتی به خداوند تقدیم کنند. ");
INSERT INTO pesopcb_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","موسی نیمی از خون حیوانات قربانی شده را گرفت و در تشتها ریخت و نیم دیگر خون را روی مذبح پاشید. ");
INSERT INTO pesopcb_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","سپس کتابی را که در آن احکام خدا را نوشته بود یعنی کتاب عهد را برای بنی‌اسرائیل خواند و قوم بار دیگر گفتند: «ما قول می‌دهیم که از تمام احکام خداوند اطاعت کنیم.» ");
INSERT INTO pesopcb_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","پس موسی خونی را که در تشتها بود گرفت و بر مردم پاشید و گفت: «این است خون عهدی که خداوند با دادن این دستورها با شما بست.» ");
INSERT INTO pesopcb_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","موسی و هارون و ناداب و ابیهو با هفتاد نفر از بزرگان اسرائیل از کوه بالا رفتند، ");
INSERT INTO pesopcb_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","و خدای اسرائیل را دیدند که زیر پایش فرشی از یاقوت کبود به شفافی آسمان گسترده شده بود. ");
INSERT INTO pesopcb_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","هر چند بزرگان اسرائیل خدا را دیدند، اما آسیبی به ایشان وارد نشد. آنها در حضور خدا خوردند و آشامیدند. ");
INSERT INTO pesopcb_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","آنگاه خداوند به موسی فرمود: «نزد من به بالای کوه بیا و آنجا بمان و من قوانین و دستورهایی را که روی لوحهای سنگی نوشته‌ام به تو می‌دهم تا آنها را به بنی‌اسرائیل تعلیم دهی.» ");
INSERT INTO pesopcb_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","پس موسی و خادم او یوشع برخاستند تا از کوه خدا بالا بروند. ");
INSERT INTO pesopcb_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","موسی به مشایخ گفت: «در اینجا بمانید و منتظر باشید تا برگردیم. اگر در غیاب من مشکلی پیش آمد با هارون و حور مشورت کنید.» ");
INSERT INTO pesopcb_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","بنابراین، موسی از کوه سینا بالا رفت و ابری کوه را در خود فرو برد ");
INSERT INTO pesopcb_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","و حضور پرجلال خداوند بر کوه سینا قرار گرفت و آن ابر شش روز همچنان کوه را پوشانده بود و در روز هفتم، خداوند از میان ابر موسی را صدا زد. ");
INSERT INTO pesopcb_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","جلال خداوند بر فراز کوه بر مردمی که در پایین کوه بودند چون شعله‌های فروزان آتش به نظر می‌رسید. ");
INSERT INTO pesopcb_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","موسی به بالای کوه رفت و آن ابر، او را پوشانید و او چهل شبانه روز در کوه ماند. ");
INSERT INTO pesopcb_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","خداوند به موسی فرمود: ");
INSERT INTO pesopcb_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","«به بنی‌اسرائیل بگو که هدایا به حضور من بیاورند. از کسانی هدیه قبول کن که با میل و رغبت می‌آورند. ");
INSERT INTO pesopcb_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","هدایا باید از این نوع باشند: طلا، نقره و مفرغ؛ ");
INSERT INTO pesopcb_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","نخهای آبی، ارغوانی و قرمز؛ کتان ریزبافت؛ پشم بز؛ ");
INSERT INTO pesopcb_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","پوست قوچ که رنگش سرخ شده باشد و پوست خز؛ چوب اقاقیا؛ ");
INSERT INTO pesopcb_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","روغن زیتون برای چراغها؛ مواد خوشبو برای تهیه روغن مسح؛ بخور خوشبو؛ ");
INSERT INTO pesopcb_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","سنگهای جزع و سنگهای قیمتی دیگر برای ایفود و سینه‌پوش کاهن. ");
INSERT INTO pesopcb_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","«بنی‌اسرائیل باید خیمهٔ مقدّسی برایم بسازند تا در میان ایشان ساکن شوم. ");
INSERT INTO pesopcb_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","این خیمۀ عبادت و تمام لوازم آن را عیناً مطابق طرحی که به تو نشان می‌دهم بساز. ");
INSERT INTO pesopcb_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","«صندوقی از چوب اقاقیا بساز که درازای آن ۱۲۵ سانتی متر و پهنا و بلندی آن هر کدام ۷۵ سانتی متر باشد. ");
INSERT INTO pesopcb_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","بیرون و درون آن را با طلای خالص بپوشان و نواری از طلا دور لبهٔ آن بکش. ");
INSERT INTO pesopcb_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","برای این صندوق، چهار حلقه از طلا آماده کن و آنها را در چهار گوشهٔ قسمت پایین آن متصل نما یعنی در هر طرف دو حلقه. ");
INSERT INTO pesopcb_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","دو چوب بلند که از درخت اقاقیا تهیه شده باشد با روکش طلا بپوشان ");
INSERT INTO pesopcb_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","و آنها را برای حمل کردن صندوق در داخل حلقه‌های دو طرف صندوق بگذار. ");
INSERT INTO pesopcb_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","این چوبها درون حلقه‌های ”صندوق عهد“ بمانند و از حلقه‌ها خارج نشوند. ");
INSERT INTO pesopcb_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","وقتی ساختن صندوق عهد به پایان رسید، آن دو لوح سنگی را که دستورها و قوانین روی آن کنده شده به تو می‌سپارم تا در آن بگذاری. ");
INSERT INTO pesopcb_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","«سرپوش صندوق عهد را به درازای ۱۲۵ سانتی متر و پهنای ۷۵ سانتی متر از طلای خالص درست کن. این سرپوش، ”تخت رحمت“ است برای کفارهٔ گناهان شما. ");
INSERT INTO pesopcb_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","دو مجسمهٔ کروبی طلاکوب بساز، و آنها را در دو سر تخت رحمت بگذار. ");
INSERT INTO pesopcb_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","کروبیان را بر دو سر تخت رحمت طوری نصب کن که با آن یکپارچه باشد. ");
INSERT INTO pesopcb_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","مجسمهٔ کروبیان باید روبروی هم و نگاهشان به طرف تخت و بالهایشان بر بالای آن گسترده باشند. ");
INSERT INTO pesopcb_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","تخت رحمت را روی صندوق نصب کن و لوحهای سنگی را که به تو می‌سپارم در آن صندوق بگذار. ");
INSERT INTO pesopcb_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","آنگاه من در آنجا با تو ملاقات خواهم کرد و از میان دو کروبی که روی تخت رحمت قرار گرفته‌اند با تو سخن خواهم گفت و دستورهای لازم را برای بنی‌اسرائیل به تو خواهم داد. ");
INSERT INTO pesopcb_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","«یک میز از چوب اقاقیا درست کن که به درازای یک متر و به پهنای نیم متر و بلندی ۷۵ سانتی متر باشد. ");
INSERT INTO pesopcb_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","آن را با روکش طلای خالص بپوشان و قابی از طلا بر دور لبهٔ میز نصب کن. ");
INSERT INTO pesopcb_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","حاشیهٔ دور لبهٔ میز را به پهنای چهار انگشت درست کن و دور حاشیه را با قاب طلا بپوشان. ");
INSERT INTO pesopcb_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","چهار حلقه از طلا برای میز بساز و آنها را به چهار گوشهٔ بالای پایه‌های میز نصب کن. ");
INSERT INTO pesopcb_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","این حلقه‌ها برای چوبهایی است که به هنگام جابه‌جا کردن و برداشتن میز باید در آنها قرار بگیرند. ");
INSERT INTO pesopcb_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","این چوبها را از جنس درخت اقاقیا با روکشهای طلا بساز. ");
INSERT INTO pesopcb_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","همچنین بشقابها، کاسه‌ها، جامها و پیاله‌هایی از طلای خالص برای ریختن هدایای نوشیدنی درست کن. ");
INSERT INTO pesopcb_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","نان حضور باید همیشه روی میز در حضور من باشد. ");
INSERT INTO pesopcb_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","«یک چراغدان از طلای خالص که چکش‌کاری شده باشد، درست کن. پایه و بدنه آن باید یکپارچه و از طلای خالص ساخته شود و نقش گلهای روی آن که شامل کاسبرگ و غنچه است نیز باید از جنس طلا باشد. ");
INSERT INTO pesopcb_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","از بدنهٔ چراغدان شش شاخه بیرون آید سه شاخه از یک طرف و سه شاخه از طرف دیگر. ");
INSERT INTO pesopcb_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","روی هر یک از شاخه‌ها سه گل بادامی شکل باشد. ");
INSERT INTO pesopcb_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","خود بدنه با چهار گل بادامی تزیین شود. ");
INSERT INTO pesopcb_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","یک جوانه زیر هر جفت شاخه، جایی که شش شاخه از بدنه منشعب می‌شوند قرار گیرد. ");
INSERT INTO pesopcb_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","تمام این نقشها و شاخه‌ها و بدنه باید از یک تکه طلای خالص باشد. ");
INSERT INTO pesopcb_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","سپس هفت چراغ بساز و آنها را بر چراغدان بگذار تا نورشان به طرف جلو بتابد. ");
INSERT INTO pesopcb_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","انبرها و سینی‌های آن را از طلای خالص درست کن. ");
INSERT INTO pesopcb_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","برای ساختن این چراغدان و لوازمش ۳۴ کیلو طلا لازم است. ");
INSERT INTO pesopcb_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","«دقت کن همه را عیناً مطابق طرحی که در بالای کوه به تو نشان دادم، بسازی. ");
INSERT INTO pesopcb_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","«خیمۀ عبادت را با ده پرده از کتان ریزبافتِ تابیده و نخهای آبی، ارغوانی و قرمز درست کن. روی آنها نقش کروبیان با دقت گلدوزی شود. ");
INSERT INTO pesopcb_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","همه پرده‌ها به یک اندازه باشند، چهارده متر درازا و دو متر پهنا داشته باشند. ");
INSERT INTO pesopcb_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","ده پرده را پنج پنج به هم بدوز به طوری که دو قطعهٔ جداگانه تشکیل دهند. ");
INSERT INTO pesopcb_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","بر لبۀ آخرین پرده از دستۀ اول، حلقه‌هایی از پارچۀ آبی بساز و بر لبۀ آخرین پرده از دستۀ دوم نیز چنین کن. ");
INSERT INTO pesopcb_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","پنجاه حلقه بر یک پرده و پنجاه حلقه بر آخرین پرده از دستۀ دیگر بساز، به گونه‌ای که حلقه‌ها در برابر هم قرار داشته باشند. ");
INSERT INTO pesopcb_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","سپس پنجاه گیره از طلا بساز و پرده‌ها را با آنها به هم متصل کن تا پرده‌های دور خیمۀ عبادت به صورت یکپارچه درآیند. ");
INSERT INTO pesopcb_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","«پوشش سقف خیمۀ عبادت را از پشم بز به شکل چادر بباف. بر روی هم یازده قطعه پارچه. ");
INSERT INTO pesopcb_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","این یازده قطعه پارچه به یک اندازه باشند، هر کدام به درازای پانزده متر و به عرض دو متر. ");
INSERT INTO pesopcb_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","پنج تا از آن قطعه‌ها را به هم بدوز تا یک قطعهٔ بزرگ تشکیل شود. شش قطعهٔ دیگر را نیز به همین ترتیب به هم بدوز. (قطعهٔ ششم از قسمت بالای جلوی خیمهٔ مقدّس آویزان خواهد شد.) ");
INSERT INTO pesopcb_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","در حاشیهٔ آخرین پرده از یک دسته، پنجاه حلقه درست کن و در حاشیۀ آخرین پرده از دستۀ دیگر نیز پنجاه حلقه بساز. ");
INSERT INTO pesopcb_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","سپس پنجاه گیرۀ مفرغین بساز و آنها را در حلقه‌ها قرار بده تا پوشش خیمه به هم وصل شده، یکپارچه گردد. ");
INSERT INTO pesopcb_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","قسمت اضافۀ پرده‌های پوشش، یعنی نیم پرده‌ای که اضافه است، در پشت خیمه آویخته شود. ");
INSERT INTO pesopcb_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","پرده‌های پوشش خیمه در دو طرف نیم متر بلندتر خواهد بود؛ این قسمت اضافه از دو طرف خیمه آویزان خواهد بود تا آن را بپوشاند. ");
INSERT INTO pesopcb_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","دو پوشش دیگر درست کن یکی از پوست قوچ که رنگش سرخ شده باشد و دیگری از پوست خز، و آنها را به ترتیب روی پوشش اولی بینداز. بدین ترتیب سقف خیمۀ عبادت تکمیل می‌شود. ");
INSERT INTO pesopcb_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","«چوب‌بست خیمهٔ عبادت را از تخته‌های چوب اقاقیا بساز. ");
INSERT INTO pesopcb_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","درازای هر تخته پنج متر و پهنای آن ۷۵ سانتی متر باشد. ");
INSERT INTO pesopcb_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","در هر طرف تخته، زبانه‌ای باشد تا با تختهٔ پهلویی جفت شود. تمام تخته‌های خیمۀ عبادت را اینطور درست کن. ");
INSERT INTO pesopcb_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","برای طرف جنوبی خیمۀ عبادت بیست تخته بساز ");
INSERT INTO pesopcb_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","و برای زیر آنها چهل پایهٔ نقره‌ای، یعنی دو پایه برای دو زبانۀ هر تخته. ");
INSERT INTO pesopcb_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","برای طرف دیگر خیمۀ عبادت، یعنی طرف شمال بیست تخته بساز ");
INSERT INTO pesopcb_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","و چهل پایهٔ نقره‌ای برای زیر آنها، یعنی دو پایه برای هر تخته. ");
INSERT INTO pesopcb_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","برای قسمت آخر خیمۀ عبادت، یعنی آخر بخش غربی، شش تخته بساز ");
INSERT INTO pesopcb_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","و برای هر یک از گوشه‌های قسمت آخر خیمه، دو تخته. ");
INSERT INTO pesopcb_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","این دو تخته باید از بالا و پایین به‌وسیلۀ حلقه‌ها به تخته‌ها وصل شوند. ");
INSERT INTO pesopcb_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","پس جمعاً در انتهای خیمۀ عبادت باید هشت تخته با شانزده پایهٔ نقره‌ای باشد، زیر هر تخته دو پایه. ");
INSERT INTO pesopcb_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","«پشت‌بندهایی از چوب اقاقیا بساز تا به طور افقی تخته‌ها را نگه دارند: پنج تیر پشت‌بند برای تخته‌هایی که در سمت شمال قرار دارند، ");
INSERT INTO pesopcb_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","پنج تیر برای تخته‌های سمت جنوب و پنج تیر برای تخته‌هایی که در طرف غربی انتهای خیمه قرار دارند. ");
INSERT INTO pesopcb_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","تیر وسطی باید به طور سراسری از وسط تخته‌ها بگذرد. ");
INSERT INTO pesopcb_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","«روکش تمام تخته‌ها از طلا باشد. برای نگه داشتن تیرها، حلقه‌هایی از طلا بساز. تیرها را نیز با روکش طلا بپوشان. ");
INSERT INTO pesopcb_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","می‌خواهم این خیمه را درست همان‌طور بسازی که طرح و نمونهٔ آن را در بالای کوه به تو نشان داده‌ام. ");
INSERT INTO pesopcb_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","«در داخل خیمه، یک پرده از کتان ریز‌بافت تابیده و نخهای آبی، ارغوانی و قرمز درست کن و نقش کروبیان را با دقت روی آن گلدوزی نما. ");
INSERT INTO pesopcb_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","چهار ستون از چوب اقاقیا با روکش طلا که چهار قلاب طلا هم داشته باشد بر پا کن. ستونها باید در چهار پایهٔ نقره‌ای قرار گیرند. پرده را به قلابها آویزان کن. ");
INSERT INTO pesopcb_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","این پرده باید بین ”قدس“ و ”قدس‌الاقداس“ آویزان شود تا آن دو را از هم جدا کند. صندوق عهد را که دو لوح سنگی در آن است در پشت این پرده قرار بده. ");
INSERT INTO pesopcb_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","«صندوق عهد را با تخت رحمت که روی آن قرار دارد در قدس‌الاقداس بگذار. ");
INSERT INTO pesopcb_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","میز و چراغدان را در مقابل هم بیرون پرده قرار بده، به طوری که چراغدان در سمت جنوبی و میز در سمت شمالی قدس باشد. ");
INSERT INTO pesopcb_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","«یک پرده دیگر برای مدخل خیمۀ عبادت از کتان ریز‌بافت تابیده که با نخهای آبی، ارغوانی و قرمز گلدوزی شده باشد، تهیه کن. ");
INSERT INTO pesopcb_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","برای این پرده، پنج ستون از چوب اقاقیا با روکش طلا درست کن. قلابهایشان نیز از طلا باشد. برای آنها پنج پایهٔ مفرغین هم بساز. ");
INSERT INTO pesopcb_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","«مذبح را از چوب اقاقیا بساز، به شکل مربع که طول هر ضلع آن دو و نیم متر و بلندیش یک و نیم متر باشد. ");
INSERT INTO pesopcb_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","آن را طوری بساز که در چهار گوشهٔ آن چهار زائده به شکل شاخ باشد. تمام مذبح و شاخها، روکش مفرغین داشته باشند. ");
INSERT INTO pesopcb_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","لوازم آن که شامل سطلهایی برای برداشتن خاکستر، خاک‌اندازها، کاسه‌ها، چنگکها و آتشدانها می‌باشد باید همگی از مفرغ باشند. ");
INSERT INTO pesopcb_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","برای مذبح یک منقل مشبک مفرغین بساز که در هر گوشهٔ آن یک حلقه مفرغین باشد، ");
INSERT INTO pesopcb_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","این منقل را زیر لبۀ مذبح بگذار به طوری که در نیمۀ بلندی مذبح قرار گیرد. ");
INSERT INTO pesopcb_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","دو چوب از درخت اقاقیا با روکش مفرغین برای مذبح درست کن ");
INSERT INTO pesopcb_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","و چوبها را در حلقه‌هایی که در دو طرف مذبح نصب شده فرو کن تا هنگام حمل مذبح، در دو طرف آن قرار بگیرند. ");
INSERT INTO pesopcb_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","همان‌طور که در بالای کوه نشان دادم، مذبح باید درونش خالی باشد و از تخته درست شود. ");
INSERT INTO pesopcb_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","«حیاطی برای خیمۀ عبادت درست کن. طول پرده‌های سمت جنوب پنجاه متر و از کتان ریزبافت تابیده باشد ");
INSERT INTO pesopcb_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","با بیست ستون و بیست پایۀ مفرغین، و بر ستونها قلابها و پشت‌بندهای نقره‌ای باشد. ");
INSERT INTO pesopcb_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","برای سمت شمالی حیاط نیز همین کار را بکن. ");
INSERT INTO pesopcb_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","طول دیوار پرده‌های سمت غربی حیاط باید بیست و پنج متر باشد با ده ستون و ده پایه. ");
INSERT INTO pesopcb_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","طول دیوار پرده‌های سمت شرقی هم باید بیست و پنج متر باشد. ");
INSERT INTO pesopcb_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","در یک طرف مدخل، پرده‌هایی باشد به درازای هفت و نیم متر با سه ستون و سه پایه، ");
INSERT INTO pesopcb_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","و در طرف دیگر مدخل نیز پرده‌هایی باشد به درازای هفت و نیم متر با سه ستون و سه پایه. ");
INSERT INTO pesopcb_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","«برای مدخل حیاط یک پرده به طول ده متر از کتان ریزبافتِ تابیده تهیه کن و با نخهای آبی، ارغوانی و قرمز گلدوزی نما و آن را از چهار ستون که روی چهار پایه قرار دارند آویزان کن. ");
INSERT INTO pesopcb_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","تمام ستونهای اطراف حیاط باید به‌وسیلهٔ پشت‌بندها و قلابهای نقره‌ای به هم مربوط شوند. ستونها باید در پایه‌های مفرغین قرار گیرند. ");
INSERT INTO pesopcb_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","پس حیاط باید پنجاه متر طول و بیست و پنج متر عرض و دو و نیم متر بلندی داشته باشد. پرده‌های آن نیز از کتان ریز‌بافت تابیده و پایه‌های آن از مفرغ باشد. ");
INSERT INTO pesopcb_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","«تمام وسایل دیگری که در خیمه به کار برده می‌شوند و تمام میخهای خیمه و حیاط آن باید از مفرغ باشند. ");
INSERT INTO pesopcb_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","«به بنی‌اسرائیل دستور بده روغن خالص از زیتون فشرده برای ریختن در چراغدان بیاورند تا چراغها همیشه روشن باشند. ");
INSERT INTO pesopcb_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","در خیمۀ ملاقات، بیرونِ پرده‌ای که مقابل صندوق عهد قرار دارد، هارون و پسرانش این چراغدان را از شب تا صبح در حضور خداوند روشن نگاه دارند. این برای تمام نسلهای بنی‌اسرائیل یک قانون جاودانی است. ");
INSERT INTO pesopcb_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","«برادر خود هارون و پسرانش ناداب، ابیهو، العازار و ایتامار را از سایر مردم اسرائیل جدا کرده، به مقام کاهنی تعیین کن تا مرا خدمت کنند. ");
INSERT INTO pesopcb_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","لباسهای مخصوصی برای هارون تهیه کن تا معلوم باشد که او برای خدمت من جدا شده است. لباسهای او زیبا و برازندهٔ کار مقدّس او باشد. ");
INSERT INTO pesopcb_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","به کسانی که استعداد و مهارت دوزندگی داده‌ام دستور بده لباسهای هارون را تهیه کنند لباسهایی که با لباسهای سایر مردم فرق داشته باشد و معلوم شود که او در مقام کاهنی به من خدمت می‌کند. ");
INSERT INTO pesopcb_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","لباسهایی که باید دوخته شوند اینها هستند: سینه‌پوش، ایفود، ردا، پیراهن نقشدار، دستار و شال کمر. برای برادرت هارون و پسرانش هم باید از همین لباسها دوخت تا بتوانند در مقام کاهنی به من خدمت کنند. ");
INSERT INTO pesopcb_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","پس طلا و نخهای آبی، ارغوانی و قرمز، و نیز کتان ریزبافت به آنها بده. ");
INSERT INTO pesopcb_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","«صنعتگران باید ایفود را از کتان ریزبافت تابیده تهیه کرده، آن را ماهرانه با طلا، نخهای آبی، ارغوانی و قرمز گلدوزی کنند. ");
INSERT INTO pesopcb_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","«این جلیقهٔ بلند از دو قسمت، جلو و پشت، که روی شانه‌ها با دو بند به هم می‌پیوندند، تشکیل شود. ");
INSERT INTO pesopcb_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","بند کمر ایفود هم باید متصل به آن و از جنس خودش باشد، یعنی از رشته‌های طلا و کتان تابیده ریز‌بافت و نخهای آبی، ارغوانی و قرمز. ");
INSERT INTO pesopcb_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","«دو سنگ جزع تهیه کن و نامهای دوازده قبیلهٔ بنی‌اسرائیل را روی آنها حک کن. ");
INSERT INTO pesopcb_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","یعنی روی هر سنگ شش نام به ترتیب سن آنها. ");
INSERT INTO pesopcb_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","مثل یک خاتم‌کار و حکاک ماهر نامها را روی سنگها حک کن و آنها را در قابهای طلا بگذار. ");
INSERT INTO pesopcb_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","سپس آنها را روی شانه‌های ایفود نصب کن تا بدین ترتیب هارون نامهای قبایل بنی‌اسرائیل را به حضور من بیاورد و من به یاد آنها باشم. ");
INSERT INTO pesopcb_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","همچنین قابهای طلایی بساز ");
INSERT INTO pesopcb_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","و دو زنجیر تابیده از طلای خالص درست کن و آنها را به قابهای طلایی که روی شانه‌های ایفود است وصل کن. ");
INSERT INTO pesopcb_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","«برای کاهن یک سینه‌پوش جهت پی بردن به خواست خداوند درست کن. آن را مانند ایفود از کتان ریز‌بافت تابیده، نخهای آبی، ارغوانی و قرمز و رشته‌های طلا بساز و روی آن را با دقت گلدوزی کن. ");
INSERT INTO pesopcb_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","این سینه‌پوش باید دولا و مثل یک کیسه چهارگوش به ضلع یک وجب باشد. ");
INSERT INTO pesopcb_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","چهار ردیف سنگ قیمتی روی آن نصب کن. ردیف اول عقیق سرخ، یاقوت زرد و یاقوت آتشی باشد. ");
INSERT INTO pesopcb_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","ردیف دوم زمرد، یاقوت کبود و الماس. ");
INSERT INTO pesopcb_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","ردیف سوم فیروزه، عقیق یمانی و یاقوت بنفش. ");
INSERT INTO pesopcb_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","ردیف چهارم زبرجد، جزع و یشم. همهٔ آنها باید قابهای طلا داشته باشند. ");
INSERT INTO pesopcb_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","هر یک از این سنگها علامت یکی از دوازده قبیلهٔ بنی‌اسرائیل خواهد بود و نام آن قبیله روی آن سنگ حک خواهد شد. ");
INSERT INTO pesopcb_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","«برای وصل کردن سینه‌پوش به ایفود، زنجیرهایی تابیده از طلای خالص درست کن. ");
INSERT INTO pesopcb_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","سپس دو حلقۀ طلایی بساز و آنها را بر دو گوشۀ سینه‌پوش بگذار. ");
INSERT INTO pesopcb_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","دو زنجیر را در حلقه‌های دو گوشۀ سینه‌پوش بگذار، ");
INSERT INTO pesopcb_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","و دو سر دیگر زنجیرها را از جلو به قابهای طلای روی شانه‌ها وصل کن. ");
INSERT INTO pesopcb_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","دو حلقهٔ طلای دیگر نیز درست کن و آنها را به دو گوشهٔ پایینی سینه‌پوش، روی لایهٔ زیرین، ببند. ");
INSERT INTO pesopcb_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","دو حلقهٔ طلای دیگر هم درست کن و آنها را در قسمت جلوی ایفود و کمی بالاتر از بند کمر نصب کن. ");
INSERT INTO pesopcb_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","بعد حلقه‌های سینه‌پوش را با نوار آبی رنگ به حلقه‌های ایفود که بالاتر از بند کمر قرار دارد ببند تا سینه‌پوش از ایفود جدا نشود. ");
INSERT INTO pesopcb_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","«به این ترتیب وقتی هارون به قدس وارد می‌شود، نامهای تمام قبایل بنی‌اسرائیل را که روی سینه‌پوش کنده شده، با خود حمل خواهد کرد تا به این وسیله قوم همیشه در نظر خداوند باشند. ");
INSERT INTO pesopcb_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","اوریم و تُمّیم را داخل سینه‌پوش بگذار تا وقتی هارون به حضور من می‌آید آنها همیشه روی قلب او باشند و او بتواند خواست مرا در مورد قوم اسرائیل دریابد. ");
INSERT INTO pesopcb_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","«ردایی که زیر ایفود است باید از پارچهٔ آبی باشد. ");
INSERT INTO pesopcb_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","شکافی برای سر، در آن باشد. حاشیهٔ این شکاف باید با دست بافته شود تا پاره نگردد. ");
INSERT INTO pesopcb_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","با نخهای آبی، ارغوانی و قرمز، منگوله‌هایی به شکل انار درست کن و دور تا دور لبهٔ دامن ردا بیاویز و زنگوله‌هایی از طلا بین آنها قرار بده. ");
INSERT INTO pesopcb_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","زنگوله‌های طلا و انارها باید یکی در میان، دور تا دور لبۀ دامن ردا باشند. ");
INSERT INTO pesopcb_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","هارون در موقع خدمت خداوند باید ردا را بپوشد تا وقتی که به حضور من به قدس وارد می‌شود یا از آن بیرون می‌رود، صدای زنگوله‌ها شنیده شود، مبادا بمیرد. ");
INSERT INTO pesopcb_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","«یک نیم تاج از طلای خالص بساز و این کلمات را مانند مُهر، روی آن حک کن: ”مقدّس برای خداوند“. ");
INSERT INTO pesopcb_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","این نیم تاج را با یک نوار آبی رنگ به دستارِ هارون ببند به‌طوری که در جلوی دستار قرار گیرد. ");
INSERT INTO pesopcb_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","این نیم تاج باید بر پیشانی هارون باشد تا او بار هر خطایی را که ممکن است بنی‌اسرائیل در حین تقدیم قربانیهای مقدّس انجام دهند، بر خود حمل کند. هارون باید همیشه این نیم تاج را روی پیشانی خود داشته باشد تا آن قربانیها مقبول خداوند واقع شوند. ");
INSERT INTO pesopcb_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","«پیراهن هارون را از کتان ریزبافت بباف؛ همچنین دستار را. شال کمر گلدوزی شده نیز برای او درست کن. ");
INSERT INTO pesopcb_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","«برای پسران هارون نیز پیراهن، شال کمر و کلاه تهیه کن. این لباسها باید زیبا و برازنده کار مقدّس ایشان باشند. ");
INSERT INTO pesopcb_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","این لباسها را به هارون و پسرانش بپوشان. با روغن زیتون آنها را مسح کن و ایشان را برای خدمت کاهنی تعیین و تقدیس نما. ");
INSERT INTO pesopcb_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","برای پوشاندن برهنگی لگن تا ران ایشان، لباس زیر از جنس کتان بدوز که اندازهٔ آن از کمر تا بالای زانو باشد. ");
INSERT INTO pesopcb_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","هارون و پسرانش، وقتی به خیمۀ ملاقات داخل می‌شوند، یا نزدیک مذبح می‌آیند تا در قدس خدمت کنند، باید این لباسها را بپوشند، مبادا متحمل گناه شده، بمیرند. این آیین برای هارون و نسل او یک قانون جاودانی خواهد بود. ");
INSERT INTO pesopcb_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","«مراسم تقدیس هارون و پسرانش به مقام کاهنی به این ترتیب برگزار شود: یک گوساله و دو قوچ بی‌عیب، ");
INSERT INTO pesopcb_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","نان بدون خمیرمایه، قرصهای نان بدون خمیرمایهٔ روغنی و قرصهای نازک نان بدون خمیرمایهٔ روغن مالی شده، که از آرد نرم گندم مرغوب پخته شده باشد، فراهم‌آور. ");
INSERT INTO pesopcb_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","نانها را در یک سبد بگذار و آنها را با گوساله و دو قوچ، به دم در خیمۀ عبادت بیاور. ");
INSERT INTO pesopcb_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","سپس هارون و پسران او را دم مدخل خیمۀ ملاقات با آب غسل بده. ");
INSERT INTO pesopcb_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","آنگاه لباس کاهنی هارون را که شامل پیراهن، ردا، ایفود و سینه‌پوش است، به او بپوشان و بند کمر را روی ایفود ببند. ");
INSERT INTO pesopcb_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","دستار را با نیم تاج طلا بر سرش بگذار. ");
INSERT INTO pesopcb_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","بعد روغن مسح را بر سرش ریخته، او را مسح کن. ");
INSERT INTO pesopcb_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","سپس لباسهای پسرانش را به ایشان بپوشان ");
INSERT INTO pesopcb_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","و کلاهها را بر سر ایشان بگذار. بعد شال کمر را به کمر هارون و پسرانش ببند. مقام کاهنی همیشه از آن ایشان و فرزندانشان خواهد بود. بدین ترتیب هارون و پسرانش را برای کاهنی تقدیس کن. ");
INSERT INTO pesopcb_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","«گوساله را نزدیک خیمۀ ملاقات بیاور تا هارون و پسرانش دستهای خود را بر سر آن بگذارند ");
INSERT INTO pesopcb_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","و تو گوساله را در حضور خداوند در برابر در خیمۀ ملاقات ذبح کن. ");
INSERT INTO pesopcb_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","خون گوساله را با انگشت خود بر شاخهای مذبح بمال و بقیه را در پای آن بریز. ");
INSERT INTO pesopcb_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","سپس همهٔ چربیهای درون شکم گوساله، سفیدی روی جگر، قلوه‌ها و چربی دور آنها را بگیر و بر مذبح بسوزان، ");
INSERT INTO pesopcb_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","و بقیه لاشهٔ گوساله را با پوست و سرگین آن بیرون از اردوگاه ببر و همه را به عنوان قربانی گناهان در همان جا بسوزان. ");
INSERT INTO pesopcb_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","«آنگاه هارون و پسرانش دستهای خود را بر سر یکی از قوچها بگذارند. ");
INSERT INTO pesopcb_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","سپس آن قوچ را ذبح کرده، خونش را بر چهار طرف مذبح بپاش. ");
INSERT INTO pesopcb_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","قوچ را قطعه قطعه کن و قسمتهای درونی و پاچه‌هایش را بشوی و آنها را با کله و سایر قطعه‌های قوچ قرار بده. ");
INSERT INTO pesopcb_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","سپس قوچ را تماماً روی مذبح بسوزان. این قربانی سوختنی که به خداوند تقدیم می‌شود، هدیه‌ای خوشبو و مخصوص برای خداوند است. ");
INSERT INTO pesopcb_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","«بعد قوچ دوم را بگیر تا هارون و پسرانش دستهای خود را بر آن بگذارند. ");
INSERT INTO pesopcb_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","و آن را نیز ذبح کن و مقداری از خونش را بردار و بر نرمهٔ گوش راست هارون و پسرانش و بر شست دست راست و شست پای راست آنها بمال. بقیهٔ خون را بر چهار طرف مذبح بپاش. ");
INSERT INTO pesopcb_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","آنگاه مقداری از خونی که روی مذبح است بردار و با روغن مسح بر هارون و پسران او و بر لباسهایشان بپاش. بدین وسیله خود آنان و لباسهایشان تقدیس می‌شوند. ");
INSERT INTO pesopcb_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","«آنگاه چربی، دنبه، چربی داخل شکم، سفیدی روی جگر، قلوه‌ها و چربی دور آنها و ران راست قوچ را بگیر، ");
INSERT INTO pesopcb_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","و از داخل سبد نان بدون خمیرمایه که در حضور خداوند است یک نان و یک قرص نان روغنی و یک نان نازک بردار، ");
INSERT INTO pesopcb_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","و همهٔ آنها را به دستهای هارون و پسرانش قرار بده تا به عنوان هدیهٔ مخصوص در حضور خداوند تکان دهند. ");
INSERT INTO pesopcb_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","سپس آنها را از دست ایشان بگیر و بر مذبح همراه با قربانی سوختنی بسوزان. این قربانی هدیه‌ای خوشبو و مخصوص برای خداوند است. ");
INSERT INTO pesopcb_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","آنگاه سینهٔ قوچی را که برای انتصاب هارون است به دست بگیر و آن را به نشانهٔ هدیهٔ مخصوص در حضور خداوند تکان بده و آنگاه آن را برای خود بردار. ");
INSERT INTO pesopcb_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","«قسمتهایی از قوچ انتصابی را که مال هارون و پسرانش است، کنار بگذار، یعنی سینه و رانی را که به نشانهٔ هدیهٔ مخصوص در حضور خداوند تکان داده شد. ");
INSERT INTO pesopcb_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","در آینده، هرگاه بنی‌اسرائیل قربانیهای سلامتی تقدیم کنند، قسمتی از آن باید برای هارون و پسرانش کنار گذاشته شود. این است حق دائمی ایشان که هدیه‌ای مقدّس از جانب بنی‌اسرائیل به خداوند می‌باشد. ");
INSERT INTO pesopcb_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","«لباسهای مقدّس هارون باید برای پسرانش و نسلهای بعد که جانشین او هستند نگاهداری شوند تا هنگام برگزاری مراسم مسح و تقدیس آنها را بپوشند. ");
INSERT INTO pesopcb_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","فرزند پسری که به جای او به مقام کاهنی می‌رسد تا در خیمۀ ملاقات و قدس مشغول خدمت شود، باید هفت روز آن لباس را بر تن کند. ");
INSERT INTO pesopcb_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","«گوشت قوچ مخصوص مراسم تقدیس را بگیر و آن را در یک جای مقدّس در آب بپز. ");
INSERT INTO pesopcb_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","هارون و پسرانش باید گوشت قوچ را با نانی که در سبد است در مدخل خیمهٔ ملاقات بخورند. ");
INSERT INTO pesopcb_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","آنها باید تنها خودشان آن قسمتهایی را که در موقع اجرای مراسم، برای تقدیس و کفارهٔ ایشان منظور شده است، بخورند؛ افراد معمولی نباید از آن بخورند چون مقدّس است. ");
INSERT INTO pesopcb_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","اگر چیزی از این گوشت و نان تا صبح باقی بماند آن را بسوزان، نباید آن را خورد زیرا مقدّس می‌باشد. ");
INSERT INTO pesopcb_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","«به این طریق مراسم تقدیس هارون و پسرانش برای مقام کاهنی اجرا شود. مدت این مراسم باید هفت روز باشد. ");
INSERT INTO pesopcb_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","در این هفت روز، روزی یک گوساله برای کفارهٔ گناهان، روی مذبح قربانی کن. با این قربانی، مذبح را طاهر ساز و با روغن زیتون آن را تدهین کن تا مقدّس شود. ");
INSERT INTO pesopcb_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","برای مدت هفت روز، هر روز برای مذبح کفاره کن تا مذبح تقدیس شود. به این ترتیب، مذبح، جایگاه بسیار مقدّسی می‌شود و هر کسی نمی‌تواند به آن دست زند. ");
INSERT INTO pesopcb_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","«هر روز دو برهٔ یک ساله روی مذبح قربانی کن. ");
INSERT INTO pesopcb_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","یک بره را صبح و دیگری را عصر قربانی کن. ");
INSERT INTO pesopcb_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","با برهٔ اول یک کیلو آرد مرغوب که با یک لیتر روغن زیتون مخلوط شده باشد تقدیم کن. یک لیتر شراب نیز به عنوان هدیهٔ نوشیدنی تقدیم نما. ");
INSERT INTO pesopcb_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","برهٔ دیگر را هنگام عصر قربانی کن و با همان مقدار هدیۀ آردی و نوشیدنی تقدیم کن. این قربانی، هدیه‌ای خوشبو و مخصوص برای خداوند خواهد بود. ");
INSERT INTO pesopcb_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","«این قربانی سوختنی، همیشگی خواهد بود و نسلهای آیندهٔ شما نیز باید در کنار در خیمۀ ملاقات، آن را به حضور خداوند تقدیم کنند. در آنجا من شما را ملاقات نموده، با شما سخن خواهم گفت. ");
INSERT INTO pesopcb_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","در آنجا بنی‌اسرائیل را ملاقات می‌کنم و خیمۀ عبادت از حضور پرجلال من تقدیس می‌شود. ");
INSERT INTO pesopcb_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","بله، خیمۀ ملاقات، مذبح، و هارون و پسرانش را که کاهنان من هستند تقدیس می‌کنم. ");
INSERT INTO pesopcb_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","من در میان بنی‌اسرائیل ساکن شده، خدای ایشان خواهم بود ");
INSERT INTO pesopcb_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","و آنها خواهند دانست که من خداوند، خدای ایشان هستم که آنها را از مصر بیرون آوردم تا در میان ایشان ساکن شوم. من خداوند، خدای آنها هستم. ");
INSERT INTO pesopcb_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","«مذبحی از چوب اقاقیا برای سوزاندن بخور بساز. ");
INSERT INTO pesopcb_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","این مذبح باید به شکل چهارگوش و به طول و عرض نیم متر و بلندی یک متر باشد، و شاخهایش با مذبح یکپارچه باشد. ");
INSERT INTO pesopcb_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","روکش مذبح و شاخهای آن از طلای خالص باشد. قابی دور تا دور آن از طلا درست کن. ");
INSERT INTO pesopcb_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","در دو طرف مذبح، زیر قاب طلایی، دو حلقه از طلا برای قرار گرفتن چوبها بساز تا با آنها مذبح را حمل کنند. ");
INSERT INTO pesopcb_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","این چوبها باید از درخت اقاقیا تهیه شوند و روکش طلا داشته باشند. ");
INSERT INTO pesopcb_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","مذبح بخور را بیرون پرده‌ای که روبروی صندوق عهد قرار گرفته بگذار. من در آنجا با تو ملاقات خواهم کرد. ");
INSERT INTO pesopcb_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","هر روز صبح که هارون، روغن داخل چراغها می‌ریزد و آنها را آماده می‌کند، باید بر آن مذبح، بخور خوشبو بسوزاند. ");
INSERT INTO pesopcb_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","هر روز عصر نیز که چراغها را روشن می‌کند باید در حضور خداوند بخور بسوزاند. این عمل باید مرتب نسل اندر نسل انجام شود. ");
INSERT INTO pesopcb_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","بخور غیر مجاز، قربانی سوختنی و هدیهٔ آردی روی آن تقدیم نکنید و هدیهٔ نوشیدنی بر آن نریزید. ");
INSERT INTO pesopcb_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","«هارون باید سالی یکبار با پاشیدن خون قربانی گناه، بر شاخهای مذبح، آن را تقدیس نماید. این عمل باید هر سال مدام نسل اندر نسل انجام شود، چون این مذبح برای خداوند بسیار مقدّس است.» ");
INSERT INTO pesopcb_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","سپس خداوند به موسی فرمود: ");
INSERT INTO pesopcb_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","«هر موقع بنی‌اسرائیل را سرشماری می‌کنی هر کسی که شمرده می‌شود، باید برای جان خود به من فدیه دهد تا هنگام سرشماری بلایی بر قوم نازل نشود. ");
INSERT INTO pesopcb_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","فدیه‌ای که او باید بپردازد نیم مثقال نقره برحسب مثقال عبادتگاه است که باید به من تقدیم شود. ");
INSERT INTO pesopcb_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","تمام افراد بیست ساله و بالاتر باید سرشماری شوند و این هدیه را به من بدهند. ");
INSERT INTO pesopcb_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","کسی که ثروتمند است از این مقدار بیشتر ندهد و آن که فقیر است کمتر ندهد، چون این کفاره را برای جانهای خود به من می‌دهند. ");
INSERT INTO pesopcb_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","پول کفاره را که از بنی‌اسرائیل می‌گیری، برای تعمیر و نگهداری خیمهٔ ملاقات صرف کن. پرداخت این فدیه باعث می‌شود که من به یاد بنی‌اسرائیل باشم و جان ایشان را حفظ کنم.» ");
INSERT INTO pesopcb_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","سپس خداوند به موسی فرمود: ");
INSERT INTO pesopcb_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","«حوضی از مفرغ با پایه‌ای مفرغین برای شستشو بساز. آن را بین خیمهٔ ملاقات و مذبح بگذار و از آب پر کن. ");
INSERT INTO pesopcb_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","هارون و پسرانش باید دست و پای خود را با این آب بشویند. ");
INSERT INTO pesopcb_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","وقتی آنها می‌خواهند به خیمه ملاقات وارد شوند و نیز وقتی بر مذبح، هدیهٔ مخصوص به من تقدیم می‌کنند، باید با این آب شستشو کنند تا نمیرند. ");
INSERT INTO pesopcb_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","آنها باید دستها و پاهای خود را با این آب بشویند و گرنه خواهند مرد. هارون و پسرانش و نسلهای آیندهٔ آنها باید این دستورها را همیشه رعایت کنند.» ");
INSERT INTO pesopcb_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","خداوند به موسی فرمود: ");
INSERT INTO pesopcb_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","«این مواد خوشبوی مخصوص را تهیه کن: شش کیلوگرم مُر خالص، سه کیلوگرم دارچین خوشبو، سه کیلوگرم نی معطر، ");
INSERT INTO pesopcb_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","شش کیلوگرم سلیخه (که همگی به مثقال عبادتگاه وزن شده‌اند). آنگاه چهار لیتر روغن زیتون روی آنها بریز، ");
INSERT INTO pesopcb_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","و از ترکیب آنها روغن مقدّس مسح درست کن. ");
INSERT INTO pesopcb_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","سپس این روغن را برای مسح خیمهٔ ملاقات، صندوق عهد، ");
INSERT INTO pesopcb_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","میز با تمام ظروف آن، چراغدان با تمام وسایل آن، مذبح بخور، ");
INSERT INTO pesopcb_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","مذبح هدیهٔ سوختنی و هر چه که متعلق به آن است، حوض و پایه‌های آن به کار ببر. ");
INSERT INTO pesopcb_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","آنها را تقدیس کن تا کاملاً مقدّس شوند و هر کسی نتواند به آن دست بزند. ");
INSERT INTO pesopcb_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","با روغنی که درست می‌کنی هارون و پسرانش را مسح نموده، تقدیس کن تا کاهنان من باشند. ");
INSERT INTO pesopcb_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","به بنی‌اسرائیل بگو که این روغن در نسلهای شما روغن مسح مقدّس من خواهد بود. ");
INSERT INTO pesopcb_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","نباید این روغن را روی افراد معمولی بریزید و حق ندارید شبیه آن را درست کنید، چون مقدّس است و شما هم باید آن را مقدّس بدانید. ");
INSERT INTO pesopcb_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","اگر کسی از این روغن درست کند و یا اگر بر شخصی که کاهن نیست بمالد، از میان قوم اسرائیل منقطع خواهد شد.» ");
INSERT INTO pesopcb_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","سپس خداوند به موسی فرمود: «برای ساختن بخور از این مواد خوشبو به مقدار مساوی استفاده کن: میعه، اظفار، قنه و کندر خالص. ");
INSERT INTO pesopcb_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","با استفاده از روش سازندگان بخور، از ترکیب این مواد خوشبو با نمک، بخور خالص و مقدّس درست کن. ");
INSERT INTO pesopcb_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","قدری از آن را بکوب و در خیمۀ ملاقات پیش صندوق عهد، جایی که با تو ملاقات می‌کنم بگذار. این بخور کاملاً مقدّس خواهد بود. ");
INSERT INTO pesopcb_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","هرگز بخوری با این ترکیب برای خود درست نکنید، چون این بخور از آن من است و باید آن را مقدّس بشمارید. ");
INSERT INTO pesopcb_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","هر کس بخوری مانند این بخور برای خودش تهیه کند، از میان قوم اسرائیل منقطع خواهد شد.» ");
INSERT INTO pesopcb_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","سپس خداوند به موسی فرمود: ");
INSERT INTO pesopcb_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","«من بِصَلئیل را که پسر اوری و نوهٔ حور از قبیلهٔ یهودا است انتخاب کرده‌ام ");
INSERT INTO pesopcb_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","و او را از روح خود پر ساخته‌ام و به او حکمت، فهم، دانش و تجربه در همه زمینه‌ها بخشیده‌ام. ");
INSERT INTO pesopcb_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","او در ساختن ظروف طلا و نقره و مفرغ، ");
INSERT INTO pesopcb_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","همچنین در کار خراطی و جواهر سازی و هر صنعتی استاد است. ");
INSERT INTO pesopcb_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","«در ضمن اهولیاب، پسر اخیسامک از قبیلهٔ دان را نیز انتخاب کرده‌ام تا دستیار او باشد. علاوه بر این به تمام صنعتگرانی که با او کار می‌کنند، مهارت مخصوصی بخشیده‌ام تا بتوانند همهٔ آن چیزهایی را که به تو دستور داده‌ام بسازند ");
INSERT INTO pesopcb_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","خیمهٔ ملاقات، صندوق عهد با تخت رحمت که بر آن است، تمام ابزار و وسایل خیمهٔ عبادت، ");
INSERT INTO pesopcb_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","میز و ظروف آن، چراغدان طلای خالص و لوازم آن، مذبح بخور، ");
INSERT INTO pesopcb_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","مذبح قربانی سوختنی با لوازم آن، حوض و پایه‌اش، ");
INSERT INTO pesopcb_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","لباسهای مخصوص هارون کاهن و پسرانش برای خدمت در مقام کاهنی، ");
INSERT INTO pesopcb_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","روغن مسح و بخور معطر برای قدس. همهٔ اینها را باید درست مطابق آنچه به تو دستور داده‌ام بسازند.» ");
INSERT INTO pesopcb_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","سپس خداوند به موسی فرمود ");
INSERT INTO pesopcb_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","«به بنی‌اسرائیل بگو: ”روز شَبّات را که برای شما تعیین کرده‌ام نگاه دارید، زیرا این روز نشانی بین من و شما و تمام نسلهای شما خواهد بود تا بدانید من که خداوند هستم، شما را برای خود جدا ساخته‌ام. ");
INSERT INTO pesopcb_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","پس روز شَبّات را نگاه دارید، چون برای شما روز مقدّسی است. هر که احترام آن را بجا نیاورد، باید کشته شود؛ هر که در آن روز کار کند باید از میان قوم خود منقطع شود. ");
INSERT INTO pesopcb_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","در هفته فقط شش روز کار کنید و روز هفتم که روز مقدّس خداوند است استراحت نمایید. هر کسی در این روز کار کند کشته خواهد شد. ");
INSERT INTO pesopcb_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","این قانون، عهدی جاودانی است و رعایت آن برای بنی‌اسرائیل نسل اندر نسل واجب است. ");
INSERT INTO pesopcb_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","این نشانهٔ همیشگی آن عهدی است که من با بنی‌اسرائیل بسته‌ام، چون من در شش روز آسمان و زمین را آفریدم و در روز هفتم استراحت کردم.“» ");
INSERT INTO pesopcb_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","وقتی خدا در کوه سینا گفتگوی خود را با موسی به پایان رسانید، آن دو لوح سنگی را که با انگشت خود ده فرمان را روی آنها نوشته بود، به موسی داد. ");
INSERT INTO pesopcb_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","وقتی بازگشت موسی از کوه سینا به طول انجامید، مردم نزد هارون جمع شده، گفتند: «برخیز و برای ما خدایی بساز تا ما را هدایت کند، چون نمی‌دانیم بر سر موسی که ما را از مصر بیرون آورد، چه آمده است.» ");
INSERT INTO pesopcb_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","هارون در پاسخ گفت: «گوشواره‌های طلا را که در گوش زنان و دختران و پسران شماست، درآورده، نزد من بیاورید.» ");
INSERT INTO pesopcb_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","بنابراین، قوم گوشواره‌های طلای خود را که در گوشهای ایشان بود، به هارون دادند. ");
INSERT INTO pesopcb_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","هارون نیز گوشواره‌های طلا را گرفت و آنها را ذوب کرده، در قالبی که ساخته بود، ریخت و مجسمه‌ای به شکل گوساله ساخت. قوم اسرائیل وقتی گوساله را دیدند فریاد برآوردند: «ای بنی‌اسرائیل، این همان خدایی است که شما را از مصر بیرون آورد.» ");
INSERT INTO pesopcb_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","هارون با دیدن این صحنه، یک مذبح نیز جلوی آن گوساله ساخت و گفت: «فردا برای خداوند جشن می‌گیریم.» ");
INSERT INTO pesopcb_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","روز بعد، صبح زود، وقتی مردم برخاستند، پیش آن گوساله قربانیهای سوختنی و قربانیهای سلامتی تقدیم نمودند. آنگاه قوم برای خوردن و نوشیدن نشستند، و برای لهو و لَعِب به پا خاستند. ");
INSERT INTO pesopcb_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","خداوند به موسی فرمود: «بی‌درنگ به پایین برو، چون قومت که تو آنها را از مصر بیرون آوردی، فاسد شده‌اند. ");
INSERT INTO pesopcb_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","آنها به همین زودی احکام مرا فراموش کرده و منحرف گشته‌اند و برای خود گوساله‌ای ساخته، آن را پرستش می‌کنند و برایش قربانی کرده، می‌گویند: ای بنی‌اسرائیل، این همان خدایی است که تو را از مصر بیرون آورد.» ");
INSERT INTO pesopcb_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","خداوند به موسی فرمود: «من دیده‌ام که این قوم چقدر سرکشند. ");
INSERT INTO pesopcb_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","بگذار آتش خشم خود را بر ایشان شعله‌ور ساخته، همه را هلاک کنم. به جای آنها از تو قوم عظیمی به وجود خواهم آورد.» ");
INSERT INTO pesopcb_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","ولی موسی از خداوند، خدای خود خواهش کرد که آنها را هلاک نکند و گفت: «خداوندا چرا بر قوم خود این گونه خشمگین شده‌ای؟ مگر با قدرت و معجزات عظیم خود آنها را از مصر بیرون نیاوردی؟ ");
INSERT INTO pesopcb_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","آیا می‌خواهی مصری‌ها بگویند: ”خدا ایشان را فریب داده، از اینجا بیرون برد تا آنها را در کوهها بکشد و از روی زمین محو کند؟“ از تو خواهش می‌کنم از خشم خود برگردی و از مجازات قوم خود درگذری. ");
INSERT INTO pesopcb_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","به یاد آور قولی را که به خدمتگزاران خود ابراهیم، اسحاق و یعقوب داده‌ای. به یاد آور چگونه برای ایشان به ذات خود قسم خورده، فرمودی: ”فرزندان شما را مثل ستارگان آسمان بی‌شمار می‌گردانم و سرزمینی را که دربارهٔ آن سخن گفته‌ام به نسلهای شما می‌دهم تا همیشه در آن زندگی کنند.“» ");
INSERT INTO pesopcb_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","بنابراین، خداوند از تصمیم خود منصرف شد. ");
INSERT INTO pesopcb_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","آنگاه موسی از کوه پایین آمد، در حالی که دو لوح سنگی در دست داشت که بر دو طرف آن لوحها ده فرمان خدا نوشته شده بود. ");
INSERT INTO pesopcb_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","(آن ده فرمان را خدا روی لوحهای سنگی نوشته بود.) ");
INSERT INTO pesopcb_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","یوشع که همراه موسی بود، وقتی صدای داد و فریاد و خروش قوم را که از دامنهٔ کوه برمی‌خاست شنید، به موسی گفت: «از اردوگاه صدای جنگ به گوش می‌رسد.» ");
INSERT INTO pesopcb_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","ولی موسی گفت: «این صدا، فریاد پیروزی یا شکست نیست، بلکه صدای ساز و آواز است.» ");
INSERT INTO pesopcb_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","وقتی به اردوگاه نزدیک شدند، موسی چشمش به گوسالهٔ طلایی افتاد که مردم در برابرش می‌رقصیدند و شادی می‌کردند. پس موسی آنچنان خشمگین شد که لوحها را به پایین کوه پرت کرد و لوحها تکه‌تکه شد. ");
INSERT INTO pesopcb_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","سپس گوسالهٔ طلایی را گرفت و در آتش انداخته آن را ذوب کرد. سپس آن را کوبید و خُرد کرد و به صورت گَرد درآورد و روی آب پاشید و به بنی‌اسرائیل نوشانید. ");
INSERT INTO pesopcb_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","آنگاه موسی به هارون گفت: «این قوم به تو چه بدی کرده بودند که ایشان را به چنین گناه بزرگی آلوده ساختی؟» ");
INSERT INTO pesopcb_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","هارون گفت: «بر من خشم مگیر. تو خود این قوم را خوب می‌شناسی که چقدر فاسدند. ");
INSERT INTO pesopcb_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","آنها به من گفتند: ”خدایی برای ما بساز تا ما را هدایت کند، چون نمی‌دانیم بر سر موسی که ما را از مصر بیرون آورد، چه آمده است.“ ");
INSERT INTO pesopcb_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","من هم گفتم که گوشواره‌های طلای خود را پیش من بیاورند. گوشواره‌های طلا را در آتش ریختم و این گوساله از آن ساخته شد.» ");
INSERT INTO pesopcb_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","وقتی موسی دید که قوم افسار گسیخته شده‌اند و هارون آنها را واگذاشته تا از خود بیخود شده، خود را نزد دشمنان بی‌آبرو کنند، ");
INSERT INTO pesopcb_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","کنار دروازهٔ اردوگاه ایستاد و با صدای بلند گفت: «هر که طرف خداوند است پیش من بیاید.» تمام طایفهٔ لاوی دور او جمع شدند. ");
INSERT INTO pesopcb_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","موسی به ایشان گفت: «خداوند، خدای بنی‌اسرائیل می‌فرماید: شمشیر به کمر ببندید و از این سوی اردوگاه تا آن سویش بروید و برادر و دوست و همسایهٔ خود را بکشید.» ");
INSERT INTO pesopcb_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","لاویان اطاعت کردند و در آن روز در حدود سه هزار نفر از قوم اسرائیل کشته شدند. ");
INSERT INTO pesopcb_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","موسی به لاویان گفت: «امروز خود را وقف کردید تا خداوند را خدمت کنید. با اینکه می‌دانستید که اطاعت شما به قیمت جان پسران و برادرانتان تمام می‌شود، از فرمان خدا سرپیچی نکردید؛ پس خدا به شما برکت خواهد داد.» ");
INSERT INTO pesopcb_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","روز بعد موسی به قوم گفت: «شما مرتکب گناه بزرگی شده‌اید. حال، من به بالای کوه می‌روم تا در حضور خداوند برای شما شفاعت کنم. شاید خدا از گناهان شما درگذرد.» ");
INSERT INTO pesopcb_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","پس موسی به حضور خداوند بازگشت و چنین دعا کرد: «آه ای خداوند، این قوم مرتکب گناه بزرگی شده، برای خود بُتی از طلا ساختند. ");
INSERT INTO pesopcb_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","تمنا می‌کنم گناه آنها را ببخش و گرنه اسم مرا از دفترت محو کن.» ");
INSERT INTO pesopcb_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","خداوند به موسی فرمود: «چرا اسم تو را محو کنم؟ هر که نسبت به من گناه کرده است، اسم او را محو خواهم کرد. ");
INSERT INTO pesopcb_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","حال بازگرد و قوم را به جایی که گفته‌ام راهنمایی کن و فرشتهٔ من پیشاپیش تو حرکت خواهد کرد. ولی من به موقع، قوم را به خاطر این گناه مجازات خواهم کرد.» ");
INSERT INTO pesopcb_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","خداوند به خاطر پرستش بُتی که هارون ساخته بود، بلای هولناکی بر بنی‌اسرائیل نازل کرد. ");
INSERT INTO pesopcb_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","خداوند به موسی فرمود: «اینجا را ترک کنید، تو و این قوم که از سرزمین مصر بیرون آوردی، و به سوی سرزمینی بروید که وعدهٔ آن را به ابراهیم، اسحاق و یعقوب داده‌ام، چون به آنها سوگند یاد کردم که آن را به فرزندان ایشان ببخشم. ");
INSERT INTO pesopcb_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","من فرشته‌ای پیشاپیش تو خواهم فرستاد تا کنعانی‌ها، اموری‌ها، حیتی‌ها، فرزی‌ها، حوی‌ها و یبوسی‌ها را بیرون خواهم راند. ");
INSERT INTO pesopcb_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","به سرزمینی بروید که شیر و عسل در آن جاری است. اما من در این سفر همراه شما نخواهم آمد، چون مردمی سرکش هستید و ممکن است شما را در بین راه هلاک کنم.» ");
INSERT INTO pesopcb_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","وقتی قوم این سخنان را شنیدند ماتم گرفتند و هیچ‌کس زیورآلات بر خود نیاویخت. ");
INSERT INTO pesopcb_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","چون خداوند به موسی فرموده بود به قوم اسرائیل بگوید: «شما مردمی سرکش هستید. اگر لحظه‌ای در میان شما باشم، شما را هلاک می‌کنم. پس تا زمانی که تکلیف شما را روشن نکرده‌ام، هر نوع آلات زینتی و جواهرات را از خود دور کنید.» ");
INSERT INTO pesopcb_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","پس بنی‌اسرائیل بعد از عزیمت از کوه سینا، زیورآلات خود را کنار گذاشتند. ");
INSERT INTO pesopcb_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","از آن پس، موسی خیمهٔ مقدّس را که «خیمهٔ ملاقات» نامگذاری کرده بود، همیشه بیرون از اردوگاه بنی‌اسرائیل بر پا می‌کرد و کسانی که می‌خواستند با خداوند راز و نیاز کنند، به آنجا می‌رفتند. ");
INSERT INTO pesopcb_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","هر وقت موسی به طرف این خیمهٔ می‌رفت، تمام قوم دم در خیمه‌های خود جمع می‌شدند و او را تماشا می‌کردند. ");
INSERT INTO pesopcb_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","زمانی که موسی وارد خیمهٔ عبادت می‌شد، ستون ابر نازل شده بر مدخل خیمه می‌ایستاد و خدا با موسی صحبت می‌کرد. ");
INSERT INTO pesopcb_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","قوم اسرائیل وقتی ستون ابر را می‌دیدند، در برابر در خیمه‌های خود به خاک افتاده خدا را پرستش می‌کردند. ");
INSERT INTO pesopcb_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","خداوند مانند کسی که با دوست خود گفتگو کند، با موسی رو در رو گفتگو می‌کرد. سپس موسی به اردوگاه بازمی‌گشت، ولی دستیار جوان او یوشع، پسر نون، خیمه را ترک نمی‌کرد. ");
INSERT INTO pesopcb_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","موسی به خداوند عرض کرد: «تو به من می‌گویی این قوم را به سرزمین موعود ببرم، ولی نمی‌گویی چه کسی را با من خواهی فرستاد. گفته‌ای: ”تو را به نام می‌شناسم و مورد لطف من قرار گرفته‌ای.“ ");
INSERT INTO pesopcb_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","پس اگر حقیقت اینطور است مرا به راهی که باید بروم راهنمایی کن تا تو را آن طور که باید بشناسم و به شایستگی در حضورت زندگی کنم. این مردم نیز قوم تو هستند، پس لطف خود را از ایشان دریغ مدار.» ");
INSERT INTO pesopcb_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","خداوند در جواب موسی فرمود: «من خود همراه شما خواهم آمد و به شما آرامی خواهم بخشید.» ");
INSERT INTO pesopcb_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","آنگاه موسی به خداوند گفت: «اگر خودت با ما نمی‌آیی ما را نیز نگذار که از اینجا جلوتر رویم. ");
INSERT INTO pesopcb_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","اگر تو همراه ما نیایی از کجا معلوم خواهد شد که من و قوم من مورد لطف تو قرار گرفته‌ایم و با سایر قومهای جهان فرق داریم؟» ");
INSERT INTO pesopcb_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","خداوند فرمود: «در این مورد هم دعای تو را اجابت می‌کنم، چون تو مورد لطف من قرار گرفته‌ای و تو را به نام می‌شناسم.» ");
INSERT INTO pesopcb_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","موسی عرض کرد: «استدعا دارم جلال خود را به من نشان دهی.» ");
INSERT INTO pesopcb_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","خداوند فرمود: «من تمامی نیکویی خود را از برابر تو عبور می‌دهم و نام خود، یهوه را در حضور تو ندا می‌کنم. من خداوند هستم و بر هر کس که بخواهم رحم می‌کنم و بر هر کس که بخواهم شفقت می‌کنم. ");
INSERT INTO pesopcb_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","من نخواهم گذاشت چهرهٔ مرا ببینی، چون انسان نمی‌تواند مرا ببیند و زنده بماند. ");
INSERT INTO pesopcb_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","حال برخیز و روی این صخره، کنار من بایست. ");
INSERT INTO pesopcb_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","وقتی جلال من می‌گذرد، تو را در شکاف این صخره می‌گذارم و با دستم تو را می‌پوشانم تا از اینجا عبور کنم؛ ");
INSERT INTO pesopcb_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","سپس دست خود را برمی‌دارم تا مرا از پشت ببینی، اما چهرهٔ مرا نخواهی دید.» ");
INSERT INTO pesopcb_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","خداوند به موسی فرمود: «دو لوح سنگی مثل لوحهای اول که شکستی تهیه کن تا دوباره ده فرمان را روی آنها بنویسم. ");
INSERT INTO pesopcb_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","فردا صبح حاضر شو و از کوه سینا بالا بیا و بر قلهٔ کوه در حضور من بایست. ");
INSERT INTO pesopcb_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","هیچ‌کس با تو بالا نیاید و کسی هم در هیچ نقطهٔ کوه دیده نشود. حتی گله و رمه نیز نزدیک کوه چرا نکنند.» ");
INSERT INTO pesopcb_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","موسی همان‌طور که خداوند فرموده بود، صبح زود برخاست و دو لوح سنگی مثل لوحهای قبلی تراشید و آنها را به دست گرفته، از کوه سینا بالا رفت. ");
INSERT INTO pesopcb_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","آنگاه خداوند در ابر فرود آمد و آنجا با موسی ایستاد؛ و نام خود، یهوه را ندا کرد. ");
INSERT INTO pesopcb_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","خداوند از برابر موسی گذشت و چنین ندا کرد: «یهوه! خداوند! خدای رحیم و مهربان، خدای دیرخشم و پراحسان؛ خدای امین که ");
INSERT INTO pesopcb_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","به هزاران نفر رحمت می‌کنم و خطا و عصیان و گناه را می‌بخشم؛ ولی گناه را هرگز بی‌سزا نمی‌گذارم. انتقام گناه پدران را از فرزندان آنها تا نسل سوم و چهارم می‌گیرم.» ");
INSERT INTO pesopcb_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","موسی در حضور خداوند به خاک افتاد و او را پرستش کرده، ");
INSERT INTO pesopcb_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","گفت: «خداوندا، اگر واقعا مورد لطف تو قرار گرفته‌ام، استدعا می‌کنم که تو نیز همراه ما باشی. می‌دانم که این قوم سرکشند، ولی از سر تقصیرها و گناهان ما بگذر و بار دیگر ما را مثل قوم خاص خود بپذیر.» ");
INSERT INTO pesopcb_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","خداوند فرمود: «اینک با تو عهد می‌بندم و در نظر تمامی قوم کارهای عجیب می‌کنم کارهای عجیبی که نظیر آن در هیچ جای دنیا دیده نشده است. تمام بنی‌اسرائیل قدرت مهیب مرا که به‌وسیلۀ تو به آنها نشان می‌دهم، خواهند دید. ");
INSERT INTO pesopcb_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","آنچه را که امروز به شما امر می‌کنم، اطاعت کنید. من قبایل اموری، کنعانی، حیتی، فرزی، حوی و یبوسی را از سر راه شما برمی‌دارم. ");
INSERT INTO pesopcb_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","مواظب باشید هرگز با آن قبایل پیمان دوستی نبندید، مبادا شما را به راههای گمراه کننده بکشانند. ");
INSERT INTO pesopcb_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","بلکه باید بتها، مجسمه‌های شرم‌آور و مذبحهای آنها را ویران کنید. ");
INSERT INTO pesopcb_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","نباید خدای دیگری را عبادت نمایید، زیرا یهوه خدای غیوری است و پرستش خدای غیر را تحمل نمی‌کند. ");
INSERT INTO pesopcb_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","«هرگز نباید با ساکنان آنجا پیمان دوستی ببندید؛ چون آنها به جای پرستش من، بتها را می‌پرستند و برای آنها قربانی می‌کنند. اگر با ایشان دوست شوید شما را به خوردن خوراک قربانی خود خواهند کشانید. ");
INSERT INTO pesopcb_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","شما دختران بت‌پرست آنها را برای پسران خود خواهید گرفت و در نتیجه پسران شما هم از خدا برگشته بتهای زنان خود را خواهند پرستید. ");
INSERT INTO pesopcb_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","«برای خود هرگز بت نسازید. ");
INSERT INTO pesopcb_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","«عید فطیر را هر سال جشن بگیرید. همان‌طور که به شما دستور دادم، هفت روز نانِ بی‌خمیرمایه بخورید. این جشن را در وقت مقرر، در ماه ابیب برگزار کنید، چون در همین ماه بود که از بندگی مصری‌ها آزاد شدید. ");
INSERT INTO pesopcb_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","«تمام نخست‌زاده‌های نر گاو و گوسفند و بز شما به من تعلق دارند. ");
INSERT INTO pesopcb_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","در برابر نخست‌زادهٔ نر الاغ، یک بره به من تقدیم کنید و اگر نخواستید این کار را بکنید گردن الاغ را بشکنید. ولی برای تمام پسران ارشد خود حتماً باید فدیه دهید. «هیچ‌کس نباید با دست خالی به حضور من حاضر شود. ");
INSERT INTO pesopcb_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","«فقط شش روز کار کنید و در روز هفتم استراحت نمایید، حتی در فصل شخم و فصل درو. ");
INSERT INTO pesopcb_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","«عید هفته‌ها را که همان عید نوبر محصول گندم است، برگزار کن و همچنین عید جمع‌آوری را به هنگام تحویل سال. ");
INSERT INTO pesopcb_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","«سالی سه بار تمام مردان و پسران قوم اسرائیل باید برای عبادت به حضور خداوند، خدای اسرائیل بیایند. ");
INSERT INTO pesopcb_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","در این سه مرتبه‌ای که به حضور یهوه خدایتان می‌آیید، کسی دست طمع به سوی سرزمین شما دراز نخواهد کرد، زیرا تمام قبایل بیگانه را از میان شما بیرون می‌رانم و حدود سرزمین شما را وسیع می‌گردانم. ");
INSERT INTO pesopcb_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","«خون قربانی را هرگز همراه با نان خمیرمایه‌دار به حضور من تقدیم نکنید و از گوشت برهٔ عید پِسَح تا صبح چیزی باقی نگذارید. ");
INSERT INTO pesopcb_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","«بهترین نوبر هر محصولی را که درو می‌کنید، به خانهٔ یهوه خدایتان بیاورید. «بزغاله را در شیر مادرش نپزید.» ");
INSERT INTO pesopcb_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","خداوند به موسی فرمود: «این قوانین را بنویس، چون عهد خود را بر اساس این قوانین با تو و با قوم اسرائیل بسته‌ام.» ");
INSERT INTO pesopcb_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","موسی چهل شبانه روز بالای کوه در حضور خداوند بود. در آن مدت نه چیزی خورد و نه چیزی آشامید. در آن روزها بود که خداوند ده فرمان را روی دو لوح سنگی نوشت. ");
INSERT INTO pesopcb_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","وقتی موسی با دو لوح سنگی که بر آن مُفاد عهد نوشته شده بود، از کوه سینا فرود آمد، خبر نداشت که چهره‌اش بر اثر گفتگو با خدا می‌درخشید. ");
INSERT INTO pesopcb_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","پس وقتی هارون و بنی‌اسرائیل موسی را با آن صورت نورانی دیدند، ترسیدند به او نزدیک شوند. ");
INSERT INTO pesopcb_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","ولی موسی ایشان را به نزد خود خواند. آنگاه هارون و بزرگان قوم نزد او آمدند و موسی با ایشان سخن گفت. ");
INSERT INTO pesopcb_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","سپس تمام مردم نزد او آمدند و موسی دستورهایی را که خداوند در بالای کوه به او داده بود، به ایشان بازگفت. ");
INSERT INTO pesopcb_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","موسی پس از آنکه سخنانش تمام شد، نقابی بر صورت خود کشید. ");
INSERT INTO pesopcb_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","هر وقت موسی به خیمهٔ ملاقات می‌رفت تا با خداوند گفتگو کند، نقاب را از صورتش بر می‌داشت. وقتی از خیمه بیرون می‌آمد هر چه از خداوند شنیده بود برای قوم بازگو می‌کرد، ");
INSERT INTO pesopcb_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","و مردم صورت او را که می‌درخشید، می‌دیدند. سپس او نقاب را دوباره به صورت خود می‌کشید و نقاب بر صورت او بود تا وقتی که باز برای گفتگو با خداوند به خیمهٔ عبادت داخل می‌شد. ");
INSERT INTO pesopcb_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","موسی تمام قوم اسرائیل را دور خود جمع کرد و به ایشان گفت: «این است دستورهایی که خداوند به شما داده است تا از آن اطاعت کنید: ");
INSERT INTO pesopcb_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","فقط شش روز کار کنید و روز هفتم را که روز مقدّس خداوند است استراحت و عبادت نمایید. هر کس که در روز هفتم کار کند باید کشته شود. ");
INSERT INTO pesopcb_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","آن روز در خانه‌هایتان حتی آتش هم روشن نکنید.» ");
INSERT INTO pesopcb_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","سپس موسی به قوم اسرائیل گفت: «خداوند فرموده که ");
INSERT INTO pesopcb_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","از آنچه دارید برای او هدیه بیاورید. هدایای کسانی که از صمیم قلب به خداوند هدیه می‌دهند باید شامل این چیزها باشد: طلا، نقره، مفرغ؛ ");
INSERT INTO pesopcb_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","نخهای آبی، ارغوانی و قرمز؛ کتان ریزبافت؛ پشم بز؛ ");
INSERT INTO pesopcb_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","پوست قوچ که رنگش سرخ شده باشد و پوست خز؛ چوب اقاقیا؛ ");
INSERT INTO pesopcb_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","روغن زیتون برای چراغها؛ مواد خوشبو برای تهیهٔ روغن مسح؛ بخور خوشبو؛ ");
INSERT INTO pesopcb_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","سنگ جزع و سنگهای قیمتی دیگر برای ایفود و سینه‌پوش کاهن. ");
INSERT INTO pesopcb_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","«شما ای صنعتگران ماهر، بیایید و آنچه را که خداوند امر فرموده است، بسازید: ");
INSERT INTO pesopcb_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","خیمهٔ عبادت و پوششهای آن، تکمه‌ها، چوب‌بست خیمه، پشت‌بندها، ستونها و پایه‌ها؛ ");
INSERT INTO pesopcb_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","صندوق عهد و چوبهای حامل آن، تخت رحمت، پردهٔ حایل بین قدس و قدس‌الاقداس؛ ");
INSERT INTO pesopcb_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","میز و چوبهای حامل آن و تمام ظروف آن، نان حضور؛ ");
INSERT INTO pesopcb_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","چراغدان با چراغها و روغن و لوازم دیگر آن؛ ");
INSERT INTO pesopcb_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","مذبح بخور و چوبهای حامل آن، روغن تدهین و بخور خوشبو؛ پردهٔ مدخل خیمه؛ ");
INSERT INTO pesopcb_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","مذبح قربانی سوختنی، منقل مشبک مفرغین مذبح و چوبهای حامل با تمام لوازم آن؛ حوض مفرغین با پایهٔ آن؛ ");
INSERT INTO pesopcb_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","پرده‌های دور حیاط، ستونها و پایه‌های آنها، پردهٔ مدخل حیاط؛ ");
INSERT INTO pesopcb_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","میخهای خیمه و حیاط خیمه و طنابهای آن؛ ");
INSERT INTO pesopcb_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","لباسهای بافته شده برای خدمت در قدس یعنی لباس مقدّس هارون کاهن و لباسهای پسرانش.» ");
INSERT INTO pesopcb_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","پس تمام قوم اسرائیل از نزد موسی رفتند، ");
INSERT INTO pesopcb_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","اما کسانی که تحت تأثیر قرار گرفته بودند با اشتیاق بازگشتند و هدایایی برای آماده ساختن لباسهای مقدّس، خیمۀ ملاقات و وسایل مورد نیاز جهت خدمت در آن، با خود آوردند تا به خداوند تقدیم کنند. ");
INSERT INTO pesopcb_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","مردان و زنان با اشتیاق زیاد آمدند و جواهراتی از قبیل سنجاق، گوشواره، انگشتر، گردنبند و اشیاء دیگری از طلا را به خداوند تقدیم کردند. ");
INSERT INTO pesopcb_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","برخی نیز نخهای آبی، ارغوانی و قرمز؛ کتان ریزبافت؛ پشم بز؛ پوست سرخ شدهٔ قوچ و پوست خز آوردند. ");
INSERT INTO pesopcb_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","عده‌ای دیگر نقره و مفرغ به خداوند تقدیم کردند. بعضی هم چوب اقاقیا برای ساختن خیمه با خود آوردند. ");
INSERT INTO pesopcb_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","زنانی که در کار ریسندگی و بافندگی مهارت داشتند، نخهای آبی و ارغوانی و قرمز و کتان ریزبافت با خود آوردند. ");
INSERT INTO pesopcb_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","همۀ زنانی که مایل بودند مهارتشان را به کار برند، از پشم بز، نخ ریسیدند. ");
INSERT INTO pesopcb_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","بزرگان قوم، سنگ جزع و سنگهای قیمتی دیگر برای تزیین ایفود و سینه‌پوش کاهن آوردند، ");
INSERT INTO pesopcb_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","و نیز عطریات و روغن برای روشنایی و روغن مسح و بخور معطر. ");
INSERT INTO pesopcb_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","بدین ترتیب تمام مردان و زنان بنی‌اسرائیل که مشتاق بودند در کاری که خداوند به موسی امر فرموده بود کمک کنند، با خرسندی خاطر هدایای خود را به خداوند تقدیم کردند. ");
INSERT INTO pesopcb_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","سپس موسی به بنی‌اسرائیل گفت: «خداوند، بِصَلئیل (پسر اوری) را که نوهٔ حور و از قبیلهٔ یهودا است برگزیده ");
INSERT INTO pesopcb_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","و او را از روح خود پر ساخته است و حکمت و توانایی و مهارت بخشیده، تا خیمهٔ عبادت و تمام وسایل آن را بسازد. ");
INSERT INTO pesopcb_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","او در ساختن ظروف طلا و نقره و مفرغ، ");
INSERT INTO pesopcb_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","همچنین در کار حکاکی و نجاری و جواهر سازی و هر صنعتی استاد است. ");
INSERT INTO pesopcb_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","خدا به او و اهولیاب (پسر اخیسامک از قبیلهٔ دان) استعداد تعلیم دادن هنر به دیگران را عطا فرموده است. ");
INSERT INTO pesopcb_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","خداوند به آنها در کار طراحی، نساجی و طرازی پارچه‌های آبی، ارغوانی، قرمز و کتان ریزبافت مهارت خاصی بخشیده است. ایشان صنعتگران ماهری هستند. ");
INSERT INTO pesopcb_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","«خداوند به بِصَلئیل و اهولیاب و سایر صنعتگران ماهر استعداد و توانایی بخشیده است تا کارهای مربوط به ساخت خیمۀ عبادت را انجام دهند. آنها باید مطابق با طرح و فرمان خداوند ساخت و آراستن خیمه عبادت را به انجام رسانند.» ");
INSERT INTO pesopcb_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","پس موسی بِصَلئیل و اهولیاب و تمام صنعتگرانی را که خداوند به آنها مهارت بخشیده و مایل به خدمت بودند احضار کرد تا مشغول کار شوند. ");
INSERT INTO pesopcb_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","آنها تمام هدایایی را که بنی‌اسرائیل هر روز صبح برای بنای خیمهٔ عبادت می‌آوردند، از موسی تحویل می‌گرفتند. ");
INSERT INTO pesopcb_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","سرانجام صنعتگرانی ماهر که مشغول ساختن خیمه بودند دست از کار کشیدند. ");
INSERT INTO pesopcb_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","آنها نزد موسی رفتند و گفتند: «مردم برای کاری که خداوند دستور آن را داده است بیش از آنچه لازم است هدیه آورده‌اند.» ");
INSERT INTO pesopcb_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","پس موسی فرمود تا در اردوگاه اعلام کنند که دیگر کسی هدیه نیاورد. بدین ترتیب بنی‌اسرائیل از آوردن هدیه بازداشته شدند، ");
INSERT INTO pesopcb_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","چون هدایای موجود، برای اتمام کار خیمه بیش از حد مورد نیاز بود. ");
INSERT INTO pesopcb_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","صنعتگرانی که مشغول کار بودند، خیمهٔ عبادت را با ده پرده از کتان ریزبافت تابیده تهیه کردند. ");
INSERT INTO pesopcb_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","آنگاه بِصَلئیل با نخهای آبی، ارغوانی و قرمز پرده‌ها را تزئین کرده، نقش کروبیان را روی آنها با دقت گلدوزی کرد. ");
INSERT INTO pesopcb_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","سپس آن ده پرده را پنج پنج به هم دوخت تا دو قطعهٔ جداگانه تشکیل شود. ");
INSERT INTO pesopcb_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","برای وصل کردن این دو قطعهٔ بزرگ، در لبهٔ آخرین پردهٔ دستۀ اول و دستۀ دوم پنجاه حلقه از پارچۀ آبی ساخت. ");
INSERT INTO pesopcb_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","پنجاه حلقۀ لبۀ یک پرده با پنجاه حلقۀ پرده دیگر رو در روی هم قرار گرفت. ");
INSERT INTO pesopcb_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","سپس پنجاه گیره از طلا برای پیوستن این دو قطعه پرده به یکدیگر درست کردند تا پرده‌های دور خیمه به صورت یکپارچه درآیند. ");
INSERT INTO pesopcb_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","او برای پوشش سقف خیمۀ عبادت، یازده قطعهٔ دیگر از پشم بز بافت. ");
INSERT INTO pesopcb_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","طول هر یک از آنها پانزده متر و عرض هر یک دو متر بود. ");
INSERT INTO pesopcb_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","پنج قطعه را به هم وصل کردند به طوری که به صورت یک قطعهٔ بزرگ درآمد. شش قطعهٔ دیگر را نیز به هم دوختند. ");
INSERT INTO pesopcb_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","در حاشیهٔ هر یک از این دو قطعهٔ بزرگ پنجاه جاتکمه باز کردند ");
INSERT INTO pesopcb_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","و آنها را با پنجاه تکمهٔ مفرغین به هم وصل کردند تا بدین‌گونه دو قطعهٔ بزرگ به هم وصل شوند. ");
INSERT INTO pesopcb_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","دو پوشش دیگر درست کردند یکی از پوست قوچ که رنگش سرخ شده بود و دیگری از پوست خز، تا آنها را به ترتیب روی پوشش اولی بیندازند. ");
INSERT INTO pesopcb_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","چوب‌بست خیمهٔ عبادت را از تخته‌های چوب اقاقیا ساختند تا به طور عمودی قرار گیرد. ");
INSERT INTO pesopcb_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","درازای هر تخته پنج متر و پهنای آن هفتاد و پنج سانتی متر بود. ");
INSERT INTO pesopcb_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","هر طرف تخته دو زبانه داشت که آن را به تختهٔ پهلویی جفت می‌کرد. ");
INSERT INTO pesopcb_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","برای قسمت جنوبی خیمۀ عبادت بیست تخته ساخت. ");
INSERT INTO pesopcb_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","همچنین برای زیر آنها چهل پایۀ نقره‌ای، یعنی دو پایه برای دو زبانۀ هر تخته درست کرد. ");
INSERT INTO pesopcb_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","برای قسمت شمالی خیمۀ عبادت بیست تختۀ دیگر ساخت. ");
INSERT INTO pesopcb_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","همچنین برای زیر آنها چهل پایۀ نقره‌ای، یعنی دو پایه برای دو زبانۀ هر تخته درست کرد. ");
INSERT INTO pesopcb_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","برای قسمت آخر خیمۀ عبادت، یعنی آخر بخش غربی، شش تخته ساخت. ");
INSERT INTO pesopcb_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","سپس دو تختهٔ دیگر برای گوشه‌های پشت خیمه درست کردند. ");
INSERT INTO pesopcb_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","شش تختهٔ قسمت غربی از بالا و پایین به‌وسیلۀ حلقه‌ها به تخته‌های گوشه متصل می‌شد. ");
INSERT INTO pesopcb_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","پس در قسمت غربی، مجموعاً هشت تخته با شانزده پایهٔ نقره‌ای، یعنی زیر هر تخته دو پایه، قرار گرفت. ");
INSERT INTO pesopcb_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","سپس پشت‌بندهایی از چوب اقاقیا ساخت، پنج پشت‌بند برای تخته‌های یک طرف خیمۀ عبادت، ");
INSERT INTO pesopcb_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","و پنج پشت‌بند برای تخته‌های طرف دیگر و پنج پشت‌بند نیز برای تخته‌های سمت غربی انتهای خیمه. ");
INSERT INTO pesopcb_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","پشت‌بند وسطی را نیز ساخت تا بطور سراسری از وسط تخته‌ها بگذرد. ");
INSERT INTO pesopcb_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","سپس تخته‌ها و پشت‌بندها را با روکش طلا پوشاند و حلقه‌هایی از طلا جهت نگه داشتن پشت‌بندها روی تخته‌ها ساختند. ");
INSERT INTO pesopcb_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","پردهٔ مخصوص را که بین قدس و قدس‌الاقداس بود از کتان ریز‌بافت تابیده و نخهای آبی، ارغوانی و قرمز درست کردند و نقش کروبیان را با دقت روی آن گلدوزی نمودند. ");
INSERT INTO pesopcb_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","برای آویزان کردن پرده، چهار ستون از چوب اقاقیا با روکش طلا و قلابهایی از طلا ساختند و برای ستونها چهار پایهٔ نقره‌ای درست کردند. ");
INSERT INTO pesopcb_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","سپس یک پرده از کتان ریزبافت تابیده برای در خیمۀ عبادت تهیه نموده، آن را با نخهای آبی، ارغوانی و قرمز گلدوزی کردند. ");
INSERT INTO pesopcb_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","برای این پرده پنج ستون قلابدار ساختند. سپس سر ستونها و گیره‌ها را با روکش طلا پوشاندند و پنج پایهٔ مفرغین برای ستونها درست کردند. ");
INSERT INTO pesopcb_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","بِصَلئیل، صندوق عهد را از چوب اقاقیا که درازای آن یک متر و ۲۵ سانتی متر و پهنا و بلندی آن هر کدام هفتاد و پنج سانتی متر بود، ساخت. ");
INSERT INTO pesopcb_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","بیرون و درون آن را با طلای خالص پوشانید و نواری از طلا دور لبهٔ آن کشید. ");
INSERT INTO pesopcb_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","برای صندوق چهار حلقه از طلا آماده کرد و آنها را در چهار گوشهٔ قسمت پایین آن متصل نمود، یعنی در هر طرف دو حلقه. ");
INSERT INTO pesopcb_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","سپس دو چوب بلند از درخت اقاقیا ساخت و آنها را با طلا پوشاند. ");
INSERT INTO pesopcb_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","برای برداشتن و حمل صندوق، چوبها را در داخل حلقه‌های دو طرف صندوق گذاشت. ");
INSERT INTO pesopcb_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","سرپوش صندوق یعنی تخت رحمت را به درازای یک متر و ده سانتیمتر و پهنای هفتاد سانتیمتر، از طلای خالص درست کرد. ");
INSERT INTO pesopcb_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","سپس دو مجسمهٔ کروبی از طلا بر دو سر تخت رحمت ساخت. ");
INSERT INTO pesopcb_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","کروبی‌ها را بر دو سر تخت رحمت طوری قرار داد که با آن یکپارچه شد. ");
INSERT INTO pesopcb_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","مجسمهٔ کروبی‌ها، روبروی هم و نگاهشان به طرف تخت و بالهایشان بر بالای آن گسترده بود. ");
INSERT INTO pesopcb_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","آنگاه بِصَلئیل، میز نان حضور را از چوب اقاقیا به درازای یک متر و پهنای نیم متر و بلندی ۷۵ سانتی متر ساخت. ");
INSERT INTO pesopcb_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","آن را با روکشی از طلای خالص پوشانید و قابی از طلا بر دور تا دور لبهٔ آن نصب کرد. ");
INSERT INTO pesopcb_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","حاشیهٔ دور لبهٔ میز را به پهنای چهار انگشت درست کرد و دور حاشیه را با قاب طلا پوشانید. ");
INSERT INTO pesopcb_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","همچنین چهار حلقه از طلا برای میز ساخت و حلقه‌ها را به چهار گوشهٔ بالای پایه‌های میز نصب کرد. ");
INSERT INTO pesopcb_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","این حلقه‌ها برای چوبهایی بود که به هنگام برداشتن و جابه‌جا کردن میز می‌بایست در آنها قرار گیرد. ");
INSERT INTO pesopcb_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","این چوبها را از درخت اقاقیا با روکش طلا ساخت. ");
INSERT INTO pesopcb_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","همچنین بشقابها، کاسه‌ها، جامها و پیاله‌هایی از طلای خالص برای ریختن هدایای نوشیدنی درست کرد تا آنها را روی میز بگذارند. ");
INSERT INTO pesopcb_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","چراغدان را نیز از طلای خالص درست کرد. پایه و بدنهٔ آن را یکپارچه و از طلای خالص ساخت و نقش گلهای روی آن را نیز که شامل کاسبرگ و غنچه بود از طلا درست کرد. ");
INSERT INTO pesopcb_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","بر بدنهٔ چراغدان شش شاخه قرار داشت، یعنی در هر طرف سه شاخه. ");
INSERT INTO pesopcb_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","روی هر شش شاخه که از چراغدان بیرون می‌آمد، گلهای بادام با جوانه‌ها وغنچه‌های مربوط به آن قرار داشت. ");
INSERT INTO pesopcb_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","خود بدنه چراغدان با چهار گل بادامی شکل با جوانه‌ها و غنچه‌هایش تزیین شده بود. ");
INSERT INTO pesopcb_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","یک جوانه زیر هر جفت شاخه بود جایی که شش شاخه از بدنۀ چراغدان بیرون می‌آمد و همه یکپارچه بود. ");
INSERT INTO pesopcb_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","تمام این نقشها و شاخه‌ها و بدنه از یک تکه طلای خالص بود. ");
INSERT INTO pesopcb_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","هفت چراغ آن و انبرها و سینی‌هایش را از طلای خالص ساخت. ");
INSERT INTO pesopcb_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","برای ساختن این چراغدان و لوازمش سی و چهار کیلو طلا به کار رفت. ");
INSERT INTO pesopcb_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","مذبح بخور را به شکل مربع به ضلع نیم متر و بلندی یک متر از چوب اقاقیا درست کرد. آن را طوری ساخت که در چهار گوشهٔ آن چهار برجستگی به شکل شاخ بود. ");
INSERT INTO pesopcb_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","روکش مذبح و شاخهای آن از طلای خالص بود. قابی دور تا دور آن از طلا درست کرد. ");
INSERT INTO pesopcb_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","در دو طرف مذبح، زیر قاب طلایی، دو حلقه از طلا برای قرار گرفتن چوبها ساخت تا با آنها مذبح را حمل کنند. ");
INSERT INTO pesopcb_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","این چوبها از درخت اقاقیا تهیه شده بود و روکش طلا داشت. ");
INSERT INTO pesopcb_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","سپس روغن مسح مقدّس و بخور خالص معطر را با مهارت عطّاران تهیه کرد. ");
INSERT INTO pesopcb_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","مذبح قربانی سوختنی نیز با چوب اقاقیا به شکل چهارگوش ساخته شد. هر ضلع آن دو و نیم متر و بلندیش یک و نیم متر بود. ");
INSERT INTO pesopcb_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","آن را طوری ساخت که در چهار گوشه‌اش چهار برجستگی به شکل شاخ بود. تمام مذبح و شاخها روکشی از مفرغ داشت. ");
INSERT INTO pesopcb_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","لوازم آن که شامل سطلها، خاک‌اندازها، کاسه‌ها، چنگکها و آتشدانها بود، همگی از مفرغ ساخته شد. ");
INSERT INTO pesopcb_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","سپس یک منقل مشبک مفرغین برای مذبح ساخت و آن را تا نیمهٔ مذبح فرو برد تا روی لبه‌ای که در آنجا وجود داشت قرار گیرد. ");
INSERT INTO pesopcb_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","چهار حلقه برای چهار گوشۀ شبکۀ مفرغین ریخت تا چوبها را نگاه دارند. ");
INSERT INTO pesopcb_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","چوبهایی از درخت اقاقیا با روکش مفرغ ساخت. ");
INSERT INTO pesopcb_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","چوبها را در حلقه‌هایی که در دو طرف مذبح نصب شده بود، فرو کرد. مذبح، درونش خالی بود و از تخته ساخته شده بود. ");
INSERT INTO pesopcb_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","حوض مفرغین و پایهٔ مفرغین‌اش را از آیینه‌های زنانی که در کنار در خیمۀ ملاقات خدمت می‌کردند، ساخت. ");
INSERT INTO pesopcb_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","سپس بِصَلئیل برای خیمۀ عبادت حیاطی درست کرد که دیوارهایش از پرده‌های کتان ریزبافت تابیده بود. طول پرده‌های سمت جنوب پنجاه متر بود. ");
INSERT INTO pesopcb_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","بیست ستون مفرغین برای پرده‌ها ساخت و برای این ستونها پایه‌های مفرغین و قلابها و پشت‌بندهای نقره‌ای درست کرد. ");
INSERT INTO pesopcb_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","برای سمت شمالی حیاط نیز همین کار را کرد. ");
INSERT INTO pesopcb_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","طول دیوار پرده‌ای سمت غربی بیست و پنج متر بود. ده ستون با ده پایه برای پرده‌ها ساخت و برای هر یک از این ستونها قلابها و پشت‌بندهای نقره‌ای درست کرد. ");
INSERT INTO pesopcb_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","طول دیوار پرده‌ای سمت شرقی هم بیست و پنج متر بود. ");
INSERT INTO pesopcb_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","مدخل خیمۀ عبادت در انتهای جنوبی قرار داشت و از دو پرده تشکیل شده بود. پردۀ سمت راست هفت و نیم متر بود و بر سه ستون با سه پایه آویزان بود. ");
INSERT INTO pesopcb_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","پردۀ سمت چپ نیز هفت و نیم متر بود و بر سه ستون با سه پایه آویزان بود. ");
INSERT INTO pesopcb_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","تمام پرده‌های دیوار حیاط خیمه از کتان ریز‌بافت تابیده بود. ");
INSERT INTO pesopcb_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","پایه‌های ستونها از مفرغ، و قلابها و پشت‌بندها و روکش سر ستونها از نقره بود. تمام ستونهای اطراف حیاط با پشت‌بندهای نقره‌ای به هم مربوط شدند. ");
INSERT INTO pesopcb_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","پردهٔ مدخل خیمه از کتان ریزبافت تابیده تهیه گردید و با نخهای آبی، ارغوانی و قرمز گلدوزی شد. طول این پرده ده متر و بلندیش مانند پرده‌های دیوار حیاط، دو و نیم متر بود. ");
INSERT INTO pesopcb_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","چهار ستون برای پرده ساخت. پایه‌های ستونها از مفرغ، و قلابها و پشت‌بندها و روکش سر ستونها از نقره بود. ");
INSERT INTO pesopcb_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","تمام میخهایی که در بنای خیمه و حیاط آن به کار رفت، از مفرغ بود. ");
INSERT INTO pesopcb_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","این است صورت مقدار فلزی که در ساختن خیمهٔ عبادت به کار رفت. این صورت به دستور موسی، به‌وسیلۀ لاویان و زیر نظر ایتامار پسر هارون کاهن تهیه شد. ");
INSERT INTO pesopcb_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","(بِصَلئیل پسر اوری و نوهٔ حور از قبیلهٔ یهودا، آنچه را که خداوند به موسی دستور داده بود، ساخت. ");
INSERT INTO pesopcb_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","دستیار او در این کار اهولیاب پسر اخیسامک از قبیلهٔ دان بود که در کار طراحی، نساجی و طرازی پارچه‌های آبی، ارغوانی، قرمز و کتان ریزبافت مهارت داشت.) ");
INSERT INTO pesopcb_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","بنی‌اسرائیل جمعاً حدود هزار کیلوگرم طلا به مقیاس مثقال عبادتگاه هدیه کردند که تمام آن صرف ساختن خیمۀ عبادت شد. ");
INSERT INTO pesopcb_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","جماعت اسرائیل جمعاً سه هزار و چهارصد و سی کیلوگرم نقره که به مقیاس عبادتگاه وزن می‌شد، هدیه دادند. ");
INSERT INTO pesopcb_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","این مقدار نقره از همۀ کسانی که اسمشان در سرشماری نوشته شده بود، به عنوان مالیات دریافت گردید. (مالیات هر فرد یک بِکا بود که بر اساس مقیاس عبادتگاه، معادل ۶ گرم است). این مالیات از ۶۰۳٬۵۵۰ نفر که سنشان بیست سال به بالا بود، دریافت شده بود. ");
INSERT INTO pesopcb_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","برای پایه‌های چوب‌بست خیمهٔ عبادت و پایه‌های ستونهای پردهٔ داخل آن، سه هزار و چهارصد کیلوگرم نقره مصرف شد، یعنی برای هر پایه سی و چهار کیلوگرم. ");
INSERT INTO pesopcb_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","باقیماندهٔ نقره که سی کیلوگرم بود برای قلابهای ستونها، پشت‌بندها و روکش سر ستونها مصرف شد. ");
INSERT INTO pesopcb_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","بنی‌اسرائیل همچنین هدیۀ مخصوصی که دو هزار و چهارصد و بیست و پنج کیلوگرم مفرغ بود، آوردند. ");
INSERT INTO pesopcb_vpl VALUES ("EX38_30‏","003_38_30‏","EXO","38","30‏","31","این مقدار مفرغ برای پایه‌های ستونهای مدخل خیمۀ ملاقات، مذبح مفرغین، منقل مشبک و سایر لوازم مذبح، همچنین برای پایه‌های ستونهای دور حیاط و پایه‌های مدخل آن، و نیز برای میخهای خیمه و پرده‌های دور حیاط به کار رفت. ");
INSERT INTO pesopcb_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","سپس برای کاهنان از نخهای آبی، ارغوانی و قرمز لباسهایی بافتند. این لباسها را موقع خدمت در قدس می‌پوشیدند. لباس مقدّس هارون کاهن هم طبق دستوری که خداوند به موسی داده بود، تهیه شد. ");
INSERT INTO pesopcb_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","ایفود کاهن از کتان ریزبافت تابیده و نخهای آبی، ارغوانی و قرمز و رشته‌هایی از طلا درست شد. ");
INSERT INTO pesopcb_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","آنها ورقه‌های طلا را چکش زدند تا باریک شد، سپس آنها را بریده، به صورت رشته‌هایی درآوردند و با نخهای آبی، ارغوانی و قرمز و کتان ریزبافت در تهیه ایفود به کار بردند و روی ایفود را با دقت گلدوزی کردند. ");
INSERT INTO pesopcb_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","ایفود از دو قسمت، جلو و پشت، تهیه شد و با دو بند روی شانه‌ها، به هم وصل گردید. ");
INSERT INTO pesopcb_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","همان‌طور که خداوند به موسی دستور داده بود، بند کمر ایفود متصل به آن و از جنس خود ایفود بود، یعنی از رشته‌های طلا و کتان ریز‌بافت تابیده و نخهای آبی، ارغوانی و قرمز. ");
INSERT INTO pesopcb_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","دو سنگ جزع در قابهای طلا گذاشتند و نامهای قبیلهٔ بنی‌اسرائیل را با مهارتی خاص روی آن دو قطعه سنگ حک کردند. ");
INSERT INTO pesopcb_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","سپس آنها را روی بندهای شانه‌های ایفود نصب کردند تا نشان دهد که کاهن نمایندۀ بنی‌اسرائیل است. همهٔ این کارها طبق دستوری که خداوند به موسی داد، انجام گرفت. ");
INSERT INTO pesopcb_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","سینه‌پوش را مثل ایفود از کتان ریزبافت تابیده، نخهای آبی، ارغوانی و قرمز، و رشته‌های طلا تهیه نموده، روی آن را با دقت گلدوزی کردند. ");
INSERT INTO pesopcb_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","آن را دولا، مثل یک کیسهٔ چهارگوش دوختند که طول هر ضلعش یک وجب بود. ");
INSERT INTO pesopcb_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","چهار ردیف سنگ قیمتی روی آن نصب شد. در ردیف اول، عقیق سرخ و یاقوت زرد و یاقوت آتشی بود. ");
INSERT INTO pesopcb_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","در ردیف دوم، زمرد و یاقوت کبود و الماس بود. ");
INSERT INTO pesopcb_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","در ردیف سوم، فیروزه و عقیق یمانی و یاقوت بنفش ");
INSERT INTO pesopcb_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","و در ردیف چهارم، زبرجد و جزع و یشم نصب شد. همهٔ این سنگهای قیمتی را در قابهای طلا جای دادند. ");
INSERT INTO pesopcb_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","هر یک از این سنگها علامت یکی از دوازده قبیلهٔ بنی‌اسرائیل بود و نام آن قبیله روی آن سنگ حک شد. ");
INSERT INTO pesopcb_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","برای نصب سینه‌پوش به ایفود دو رشته زنجیر تابیده از طلای خالص درست کردند. ");
INSERT INTO pesopcb_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","همچنین دو قاب و دو حلقه از طلا ساختند و حلقه‌ها ");
INSERT INTO pesopcb_vpl VALUES ("EX39_17‏","003_39_17‏","EXO","39","17‏","18","و قسمت بالای سینه‌پوش را به‌وسیلۀ دو رشته زنجیر طلا به ایفود بستند. دو سر زنجیرها به حلقه‌های طلا که در گوشه‌های سینه‌پوش جاسازی شده بود، بسته شد، و دو سر دیگر زنجیرها را از جلو به قابهای طلای روی شانه‌ها وصل کردند. ");
INSERT INTO pesopcb_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","دو حلقهٔ طلای دیگر نیز درست کردند و آنها را به دو گوشهٔ پایین سینه‌پوش، روی لایهٔ زیرین بستند. ");
INSERT INTO pesopcb_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","دو حلقه طلای دیگر هم درست کردند و آنها را در قسمت جلوی ایفود و کمی بالاتر از بند کمر نصب کردند. ");
INSERT INTO pesopcb_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","بعد، همان‌طور که خداوند به موسی فرموده بود، حلقه‌های سینه‌پوش را با نوار آبی رنگ به حلقه‌های ایفود که بالاتر از بند کمر قرار داشت بستند تا سینه‌پوش از ایفود جدا نشود. ");
INSERT INTO pesopcb_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","ردایی که زیر ایفود پوشیده می‌شد، تمام از پارچهٔ آبی تهیه شد. ");
INSERT INTO pesopcb_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","شکافی برای سر در آن باز کردند و حاشیهٔ شکاف را با دست بافتند تا پاره نشود. ");
INSERT INTO pesopcb_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","با نخهای آبی، ارغوانی و قرمز و کتان ریزبافت منگوله‌هایی به شکل انار درست کردند و آنها را دور تا دور لبهٔ دامن ردا آویختند. ");
INSERT INTO pesopcb_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","زنگوله‌هایی از طلای خالص نیز ساختند و دور دامن ردا میان انارها بستند. ");
INSERT INTO pesopcb_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","زنگوله‌ها و انارها یکی در میان دور دامن ردایی بود که هنگام خدمت می‌پوشیدند؛ همان‌طور که خداوند به موسی فرموده بود. ");
INSERT INTO pesopcb_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","آنها از کتان ریزبافت برای هارون و پسرانش پیراهنها دوختند. ");
INSERT INTO pesopcb_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","دستار و کلاه‌ها از کتان ریزبافت تهیه کردند و لباسهای زیر نیز از کتان ریزبافت تابیده بود. ");
INSERT INTO pesopcb_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","شال کمر را از کتان ریزبافت تابیده تهیه نموده، آن را با نخهای آبی، ارغوانی و قرمز گلدوزی کردند، همان‌طور که خداوند به موسی فرموده بود. ");
INSERT INTO pesopcb_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","نیم تاج مقدّس را از طلای خالص ساختند و این کلمات را روی آن نقش کردند: «مقدّس برای خداوند.» ");
INSERT INTO pesopcb_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","همان‌طور که خداوند به موسی گفته بود، نیم تاج را با یک نوار آبی رنگ به قسمت جلوی دستار بستند. ");
INSERT INTO pesopcb_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","سرانجام تمام قسمتها و لوازم خیمهٔ ملاقات طبق آنچه خداوند به موسی فرموده بود به‌وسیلۀ بنی‌اسرائیل آماده شد. ");
INSERT INTO pesopcb_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","سپس ایشان قسمتهای ساخته شده خیمه و همهٔ لوازم آن را پیش موسی آوردند: تکمه‌ها، چوب‌بست خیمه، پشت‌بندها، ستونها، پایه‌ها؛ ");
INSERT INTO pesopcb_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","پوشش از پوست سرخ شدهٔ قوچ و پوشش از پوست خز، پردهٔ حایل بین قدس و قدس‌الاقداس؛ ");
INSERT INTO pesopcb_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","صندوق عهد و ده فرمان خدا که در آن بود و چوبهای حامل آن، تخت رحمت؛ ");
INSERT INTO pesopcb_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","میز و تمام وسایل آن، نان حضور؛ ");
INSERT INTO pesopcb_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","چراغدان طلای خالص با چراغها، روغن و همهٔ لوازم آن؛ ");
INSERT INTO pesopcb_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","مذبح طلایی، روغن تدهین و بخور معطر؛ پردهٔ مدخل خیمه؛ ");
INSERT INTO pesopcb_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","مذبح مفرغین با منقل مشبک مفرغین و چوبهای حامل و سایر لوازم آن؛ حوض و پایه‌اش؛ ");
INSERT INTO pesopcb_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","پرده‌های دور حیاط با ستونها و پایه‌های آنها، پردهٔ مدخل حیاط؛ طنابها و میخهای خیمۀ ملاقات، و تمام ابزارهایی که در ساختن خیمه به کار می‌رفت. ");
INSERT INTO pesopcb_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","آنها همچنین لباسهای بافته شده برای خدمت در قدس یعنی لباسهای مقدّس هارون کاهن و پسرانش را از نظر موسی گذراندند. ");
INSERT INTO pesopcb_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","به این ترتیب بنی‌اسرائیل تمام دستورهای خداوند را که برای ساختن خیمه به موسی داده بود، به کار بستند. ");
INSERT INTO pesopcb_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","موسی تمام کارهای انجام شده را ملاحظه کرد و به خاطر آن، قوم را برکت داد، چون همه چیز مطابق دستور خداوند ساخته شده بود. ");
INSERT INTO pesopcb_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","آنگاه خداوند به موسی فرمود: ");
INSERT INTO pesopcb_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","«در نخستین روز ماه اول، خیمهٔ ملاقات را بر پا کن ");
INSERT INTO pesopcb_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","و صندوق عهد را که ده فرمان در آن قرار دارد، در داخل خیمه بگذار و پردهٔ مخصوص را جلوی آن آویزان کن. ");
INSERT INTO pesopcb_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","سپس میز را در خیمه بگذار و لوازمش را روی آن قرار بده. چراغدان را نیز در خیمه بگذار و چراغهایش را روشن کن. ");
INSERT INTO pesopcb_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","«مذبح طلا را برای سوزاندن بخور روبروی صندوق عهد بگذار. پردهٔ مدخل خیمه را بیاویز. ");
INSERT INTO pesopcb_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","مذبح قربانی سوختنی را مقابل مدخل خیمۀ ملاقات بگذار. ");
INSERT INTO pesopcb_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","حوض را بین خیمهٔ ملاقات و مذبح قرار بده و آن را پر از آب کن. ");
INSERT INTO pesopcb_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","دیوار پرده‌ای حیاط اطراف خیمه را بر پا نما و پردهٔ مدخل حیاط را آویزان کن. ");
INSERT INTO pesopcb_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","«روغن مسح را بردار و خیمه و تمام لوازم و وسایل آن را مسح کرده، تقدیس نما تا مقدّس شوند. ");
INSERT INTO pesopcb_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","سپس مذبح قربانی سوختنی و وسایل آن را مسح نموده، تقدیس کن و مذبح، جایگاه بسیار مقدّسی خواهد شد. ");
INSERT INTO pesopcb_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","بعد، حوض و پایه‌اش را مسح نموده، تقدیس کن. ");
INSERT INTO pesopcb_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","«سپس هارون و پسرانش را کنار مدخل خیمهٔ ملاقات بیاور و آنها را با آب شستشو بده. ");
INSERT INTO pesopcb_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","لباس مقدّس را بر هارون بپوشان و او را مسح کرده تقدیس نما تا در مقام کاهنی مرا خدمت کند. ");
INSERT INTO pesopcb_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","سپس پسرانش را بیاور و لباسهایشان را به ایشان بپوشان. ");
INSERT INTO pesopcb_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","آنها را نیز مانند پدرشان مسح کن تا در مقام کاهنی مرا خدمت کنند. این مسح به منزلهٔ انتخاب ابدی آنها و نسلهای ایشان است به مقام کاهنی.» ");
INSERT INTO pesopcb_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","موسی هر چه را که خداوند به او فرموده بود بجا آورد. ");
INSERT INTO pesopcb_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","در نخستین روز ماه اول سال دوم، بعد از بیرون آمدن از مصر، خیمهٔ عبادت بر پا شد. ");
INSERT INTO pesopcb_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","موسی خیمهٔ عبادت را به این ترتیب بر پا کرد: اول پایه‌های آن را گذاشت، سپس تخته‌های چوب‌بست را در پایه‌ها نهاده، پشت‌بندهای آنها را نصب کرد و ستونها را بر پا نمود. ");
INSERT INTO pesopcb_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","آنگاه، همان‌طور که خداوند فرموده بود، پوشش داخلی سقف را روی چوبها کشید و پوششهای خارجی را روی آن گسترانید. ");
INSERT INTO pesopcb_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","بعد، دو لوح سنگی را که ده فرمان خدا روی آنها نوشته بود در صندوق عهد گذاشت و چوبهای حامل را درون حلقه‌ها قرار داد و سرپوش صندوق را که «تخت رحمت» بود، روی آن نهاد. ");
INSERT INTO pesopcb_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","آنگاه صندوق عهد را به درون خیمهٔ عبادت برد و پردهٔ مخصوص را جلو آن کشید، درست همان‌گونه که خداوند فرموده بود. ");
INSERT INTO pesopcb_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","سپس موسی میز را در سمت شمالی خیمهٔ ملاقات، بیرون پرده گذاشت، ");
INSERT INTO pesopcb_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","و همان‌طور که خداوند به او فرموده بود، نان حضور را روی میز در حضور خداوند قرار داد. ");
INSERT INTO pesopcb_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","چراغدان را مقابل میز در سمت جنوبی خیمۀ ملاقات گذاشت ");
INSERT INTO pesopcb_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","و مطابق دستور خداوند چراغهای چراغدان را در حضور خداوند روشن کرد. ");
INSERT INTO pesopcb_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","مذبح طلا را در خیمۀ ملاقات، بیرون پرده گذاشت ");
INSERT INTO pesopcb_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","و مطابق دستور خداوند بر آن بخور معطر سوزاند. ");
INSERT INTO pesopcb_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","موسی پردهٔ مدخل خیمهٔ عبادت را آویزان کرد. ");
INSERT INTO pesopcb_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","مذبح قربانی سوختنی را مقابل مدخل خیمۀ ملاقات گذاشت و روی آن قربانی سوختنی و هدیه آردی تقدیم کرد، درست همان‌طور که خداوند فرموده بود. ");
INSERT INTO pesopcb_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","حوض را بین خیمهٔ ملاقات و مذبح قرار داد و آن را پر از آب کرد. ");
INSERT INTO pesopcb_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","موسی، هارون و پسرانش از آن آب برای شستن دست و پایشان استفاده می‌کردند. ");
INSERT INTO pesopcb_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","آنها هر وقت می‌خواستند به داخل خیمۀ ملاقات بروند و یا به مذبح نزدیک شوند، مطابق دستور خداوند خود را می‌شستند. ");
INSERT INTO pesopcb_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","موسی دیوار پرده‌ای دور خیمه و مذبح را بر پا نموده پردهٔ مدخل حیاط را آویزان کرد. به این ترتیب او همهٔ کار را به پایان رسانید. ");
INSERT INTO pesopcb_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","آنگاه ابر، خیمهٔ ملاقات را پوشانید و حضور پرجلال خداوند آن را پر ساخت. ");
INSERT INTO pesopcb_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","موسی نتوانست وارد خیمۀ ملاقات شود، زیرا ابر بر آن نشسته بود و حضور پرجلال خداوند خیمۀ عبادت را پر ساخته بود. ");
INSERT INTO pesopcb_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","از آن پس، هر وقت ابر از روی خیمه برمی‌خاست قوم اسرائیل کوچ می‌کردند و به راهنمایی آن به سفر ادامه می‌دادند. ");
INSERT INTO pesopcb_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","اما تا وقتی که ابر روی خیمه باقی بود، قوم همچنان در جای خود می‌ماندند. ");
INSERT INTO pesopcb_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","در روز، ابر روی خیمهٔ عبادت قرار داشت و در شب، آتش در ابر پدیدار می‌شد و قوم می‌توانستند آن را ببینند. به این طریق، ابر خداوند بنی‌اسرائیل را در تمام سفرهایشان هدایت می‌کرد.");
INSERT INTO pesopcb_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","خداوند از خیمهٔ ملاقات با موسی سخن گفت و به او فرمود: ");
INSERT INTO pesopcb_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","«این دستورها را به بنی‌اسرائیل بده. وقتی کسی به خداوند قربانی تقدیم می‌کند، قربانی او باید گاو، گوسفند و یا بز باشد. ");
INSERT INTO pesopcb_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","اگر بخواهد برای قربانی سوختنی یک گاو قربانی کند، آن گاو باید نر و بی‌عیب باشد. گاو را دم مدخل خیمهٔ ملاقات بیاورد تا مورد قبول خداوند قرار گیرد. ");
INSERT INTO pesopcb_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","شخصی که آن را می‌آورد، باید دستش را روی سر حیوان بگذارد. به این ترتیب آن قربانی پذیرفته شده، گناهان شخص را کفاره می‌کند. ");
INSERT INTO pesopcb_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","بعد خود آن شخص حیوان را در حضور خداوند سر ببرد و پسران هارون که کاهنند، خون آن را بیاورند و بر چهار طرف مذبح که جلوی مدخل خیمهٔ ملاقات است، بپاشند. ");
INSERT INTO pesopcb_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","سپس آن شخص پوست گاو را بکند و آن را قطعه‌قطعه کند، ");
INSERT INTO pesopcb_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","و کاهنان هیزم روی مذبح بگذارند، آتش روشن کنند ");
INSERT INTO pesopcb_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","و قطعه‌ها و سر و چربی آن را روی هیزم قرار دهند. ");
INSERT INTO pesopcb_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","آنگاه آن شخص باید دل و روده و پاچه‌های گاو را با آب بشوید و کاهنان همه را روی مذبح بسوزانند. این قربانی سوختنی، هدیه‌ای خوشبو و مخصوص برای خداوند خواهد بود. ");
INSERT INTO pesopcb_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","«اگر گوسفند یا بز برای قربانی بیاورند، آن نیز باید نر و بی‌عیب باشد. ");
INSERT INTO pesopcb_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","شخصی که آن را می‌آورد باید در سمت شمالی مذبح در حضور خداوند سرش را ببرد و کاهنان که پسران هارونند، خونش را بر چهار طرف مذبح بپاشند. ");
INSERT INTO pesopcb_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","سپس، آن شخص حیوان قربانی شده را قطعه‌قطعه کند و کاهنان این قطعه‌ها را با سر و چربی آن روی هیزم مذبح بگذارند. ");
INSERT INTO pesopcb_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","آن شخص باید دل و روده و پاچه‌های گوسفند یا بز را با آب بشوید. سپس کاهنان همهٔ آنها را روی آتش مذبح بسوزانند. این قربانی سوختنی، هدیه‌ای مخصوص و خوشبو برای خداوند خواهد بود. ");
INSERT INTO pesopcb_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","«اگر کسی می‌خواهد برای قربانی سوختنی پرنده برای خداوند قربانی کند، آن پرنده باید قمری یا جوجه کبوتر باشد. ");
INSERT INTO pesopcb_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","کاهن، پرنده را بگیرد و جلوی مذبح سرش را بپیچاند و آن را بر مذبح بسوزاند. اما اول باید خونش را بر پهلوی مذبح بچلاند. ");
INSERT INTO pesopcb_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","چینه‌دان و محتویات داخل شکمش را درآورد و آنها را در طرف شرق مذبح در جایی که خاکستر مذبح ریخته می‌شود بیندازد. ");
INSERT INTO pesopcb_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","سپس بالهای پرنده را گرفته، آن را از وسط پاره کند بدون اینکه پرنده دو تکه شود. آنگاه کاهن آن را روی هیزم مذبح بسوزاند. این قربانی سوختنی، هدیه‌ای مخصوص و خوشبو برای خداوند خواهد بود. ");
INSERT INTO pesopcb_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","«هرگاه کسی برای خداوند هدیهٔ آردی آورد، هدیهٔ او باید از آرد مرغوب باشد. او باید روغن زیتون روی آن بریزد و کندر بر آن بگذارد. ");
INSERT INTO pesopcb_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","سپس یک مشت از آن را که نمونهٔ تمام هدیه است به یکی از کاهنان بدهد تا آن را بسوزاند. این هدیه، هدیه‌ای مخصوص و خوشبو برای خداوند خواهد بود. ");
INSERT INTO pesopcb_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","بقیهٔ هدیۀ آردی به هارون و پسرانش داده شود تا برای خوراک از آن استفاده کنند. قسمتی که به کاهنان داده می‌شود بسیار مقدّس است، زیرا از هدایای مخصوصی که به خداوند تقدیم می‌شوند، گرفته شده است. ");
INSERT INTO pesopcb_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","«هرگاه کسی نان پخته شده در تنور برای خداوند هدیه آورد، آن نان باید بدون خمیرمایه و از آرد مرغوب مخلوط با روغن زیتون تهیه شده باشد. از نان بدون خمیرمایه که روغن روی آن مالیده شده باشد نیز می‌توان به عنوان هدیه استفاده کرد. ");
INSERT INTO pesopcb_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","اگر کسی نان پخته شده روی ساج هدیه آورد، آن نان نیز باید از آرد مرغوب بدون خمیرمایه و مخلوط با روغن زیتون باشد. ");
INSERT INTO pesopcb_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","او باید آن را تکه‌تکه کند و رویش روغن بریزد. این نیز یک نوع هدیهٔ آردی است. ");
INSERT INTO pesopcb_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","اگر هدیهٔ شما در تابه پخته شود، آن هم باید از آرد مرغوب و روغن زیتون باشد. ");
INSERT INTO pesopcb_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","«این هدایای آردی را نزد کاهن بیاورید تا به مذبح ببرد و به خداوند تقدیم کند. ");
INSERT INTO pesopcb_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","کاهنان باید فقط مقدار کمی از هدیه را به عنوان نمونه بسوزانند. این هدیه، هدیه‌ای مخصوص و خوشبو برای خداوند است. ");
INSERT INTO pesopcb_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","بقیهٔ هدیۀ آردی به هارون و پسرانش داده شود تا برای خوراک از آن استفاده کنند. قسمتی که به کاهنان داده می‌شود بسیار مقدّس است، زیرا از هدایای مخصوصی که به خداوند تقدیم می‌شوند، گرفته شده است. ");
INSERT INTO pesopcb_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","«برای تهیهٔ هدیه آردی که به خداوند تقدیم می‌شود از خمیرمایه استفاده نکنید، زیرا به کار بردن خمیرمایه یا عسل در هدایای مخصوصی که به خداوند تقدیم می‌شوند، جایز نیست. ");
INSERT INTO pesopcb_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","هنگام تقدیم نوبر محصول خود به خداوند می‌توانید از نان خمیرمایه‌دار و عسل استفاده کنید، ولی این هدیه را نباید به عنوان هدیه‌ای خوشبو بر مذبح بسوزانید. ");
INSERT INTO pesopcb_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","«به تمام هدایا باید نمک بزنید، چون نمک یادآور عهد خداست. ");
INSERT INTO pesopcb_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","«هرگاه از نوبر محصول خود به خداوند هدیه می‌دهید دانه‌ها را از خوشه‌ها جدا کرده، بکوبید و برشته کنید. ");
INSERT INTO pesopcb_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","سپس روغن زیتون بر آن بریزید و کندر روی آن بگذارید، زیرا این نیز نوعی هدیهٔ آردی است. ");
INSERT INTO pesopcb_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","آنگاه کاهنان قسمتی از غلهٔ کوبیده شده و مخلوط با روغن را با تمام کندر به عنوان نمونه بر آتش بسوزانند و همچون هدیۀ مخصوص به خداوند تقدیم کنند. ");
INSERT INTO pesopcb_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","«هرگاه کسی بخواهد قربانی سلامتی به خداوند تقدیم کند، می‌تواند برای این کار از گاو نر یا ماده استفاده نماید. حیوانی که به خداوند تقدیم می‌شود باید سالم و بی‌عیب باشد. ");
INSERT INTO pesopcb_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","شخصی که حیوان را تقدیم می‌کند، باید دست خود را روی سر آن بگذارد و دم در خیمۀ ملاقات سرش را ببرد. پسران هارون خون آن را بر چهار طرف مذبح بپاشند. ");
INSERT INTO pesopcb_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","کاهن باید بخشی از این قربانی سلامتی را به عنوان هدیۀ اختصاصی به خداوند تقدیم کند. این هدیه شامل چربی داخل شکم، ");
INSERT INTO pesopcb_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","دو قلوه و چربی روی آنها در قسمت تهیگاه و سفیدی روی جگر خواهد بود. اینها باید همراه قلوه‌ها خارج شوند، ");
INSERT INTO pesopcb_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","و پسران هارون آنها را بر مذبح، روی قربانی سوختنی، بسوزانند. این هدیه، هدیه‌ای مخصوص و خوشبو برای خداوند است. ");
INSERT INTO pesopcb_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","«برای قربانی سلامتی می‌توان گوسفند و بز (نر یا ماده) که سالم و بی‌عیب باشند نیز به خداوند تقدیم کرد. ");
INSERT INTO pesopcb_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","اگر قربانی، گوسفند باشد، شخصی که آن را به خداوند تقدیم می‌کند باید آن را به حضور خداوند آورده، ");
INSERT INTO pesopcb_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","دستش را روی سر حیوان بگذارد و دم در خیمۀ ملاقات سرش را ببرد. سپس پسران هارون خون آن را بر چهار طرف مذبح بپاشند. ");
INSERT INTO pesopcb_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","کاهن باید چربی این قربانی سلامتی را به عنوان هدیۀ مخصوص به خداوند تقدیم کند. این چربی شامل دنبه که از نزدیکی ستون مهره‌ها جدا شده، و تمام چربی داخل شکم، ");
INSERT INTO pesopcb_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","دو قلوه و چربی روی آنها در قسمت تهیگاه، و سفیدی روی جگر می‌باشد. اینها همراه با قلوه‌ها باید جدا شوند ");
INSERT INTO pesopcb_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","و کاهن آنها را همچون هدیۀ مخصوص خوراکی به خداوند تقدیم کرده، بر آتش مذبح بسوزاند. ");
INSERT INTO pesopcb_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","«اگر قربانی، بز باشد، شخصی که آن را به خداوند تقدیم می‌کند، باید آن را به حضور خداوند آورده، ");
INSERT INTO pesopcb_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","دستش را روی سر حیوان بگذارد و دم در خیمۀ ملاقات سرش را ببرد. سپس پسران هارون خون آن را بر چهار طرف مذبح بپاشند ");
INSERT INTO pesopcb_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","کاهن باید قسمتی از این قربانی را به عنوان هدیۀ مخصوص به خداوند تقدیم کند. این شامل چربی داخل شکم، ");
INSERT INTO pesopcb_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","و قلوه و چربی روی آنها در قسمت تهیگاه، و سفیدی روی جگر می‌باشد. اینها همراه با قلوه‌ها باید جدا شوند. ");
INSERT INTO pesopcb_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","سپس کاهن این همه را به عنوان خوراک بر مذبح بسوزاند. این هدیه، هدیه‌ای مخصوص و خوشبو برای خداوند است. تمام چربی آن حیوان به خداوند تعلق دارد. ");
INSERT INTO pesopcb_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","هیچ‌یک از شما نباید خون یا چربی بخورید. این قانونی است ابدی برای شما و نسلهایتان، در هر جا که باشید.» ");
INSERT INTO pesopcb_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","خداوند به موسی فرمود: ");
INSERT INTO pesopcb_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","«این دستورها را به بنی‌اسرائیل بده. اگر کسی ناخواسته مرتکب گناهی شود و یکی از قوانین خداوند را زیر پا گذارد، باید طبق این مقررات عمل کند: ");
INSERT INTO pesopcb_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","«اگر گناه از کاهن اعظم سر زده باشد و بدین ترتیب قوم را نیز گناهکار ساخته باشد، برای گناه خود باید گوساله‌ای سالم و بی‌عیب به خداوند تقدیم کند. ");
INSERT INTO pesopcb_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","گوساله را دم در خیمۀ ملاقات بیاورد، دستش را روی سر آن بگذارد و همان جا در حضور خداوند سرش را ببرد. ");
INSERT INTO pesopcb_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","کاهن اعظم مقداری از خون گوساله را به داخل خیمۀ ملاقات ببرد، ");
INSERT INTO pesopcb_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","انگشت خود را در خون فرو برد و در حضور خداوند آن را هفت بار جلوی پردهٔ قدس‌الاقداس بپاشد. ");
INSERT INTO pesopcb_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","سپس در حضور خداوند قدری از خون را روی شاخهای مذبح بخور که داخل خیمه است، بمالد. باقیماندهٔ خون را به پای مذبح قربانی سوختنی که نزدیک در خیمۀ ملاقات است، بریزد. ");
INSERT INTO pesopcb_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","آنگاه تمام چربی داخل شکم، ");
INSERT INTO pesopcb_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","قلوه‌ها و چربی روی آنها، و سفیدی روی جگر را بردارد، ");
INSERT INTO pesopcb_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","و آنها را روی مذبح قربانی سوختنی بسوزاند، درست همان‌طور که چربی گاو قربانی سلامتی را می‌سوزاند. ");
INSERT INTO pesopcb_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","اما باقیماندهٔ گوساله، یعنی پوست، گوشت، کله، پاچه، دل و روده و سرگین را ");
INSERT INTO pesopcb_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","به مکان طاهری ببرد که در خارج از اردوگاه برای ریختن خاکستر مذبح مقرر شده است و در آنجا آنها را روی هیزم بسوزاند. ");
INSERT INTO pesopcb_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","«اگر تمام قوم اسرائیل ناخواسته مرتکب گناهی شوند و یکی از قوانین خداوند را زیر پا بگذارند، هر چند این کار را ندانسته انجام داده باشند، مقصر محسوب می‌شوند. ");
INSERT INTO pesopcb_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","وقتی آنها به گناه خود پی بردند، باید گوساله‌ای برای کفارهٔ گناه خود قربانی کنند. گوساله را به خیمۀ ملاقات بیاورند ");
INSERT INTO pesopcb_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","و در آنجا بزرگان قوم در حضور خداوند دستهای خود را روی سر حیوان بگذارند و آن را ذبح کنند. ");
INSERT INTO pesopcb_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","آنگاه کاهن اعظم مقداری از خون گوساله را به داخل خیمۀ ملاقات بیاورد ");
INSERT INTO pesopcb_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","و انگشت خود را در خون فرو برد و در حضور خداوند آن را هفت بار جلوی پردهٔ قدس‌الاقداس بپاشد. ");
INSERT INTO pesopcb_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","بعد در حضور خداوند قدری از خون را بر شاخهای مذبح بخور که در خیمۀ ملاقات است، بمالد و باقیماندهٔ خون را به پای مذبح قربانی سوختنی که نزدیک در خیمه است، بریزد. ");
INSERT INTO pesopcb_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","تمام چربی باید روی مذبح سوزانده شود. ");
INSERT INTO pesopcb_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","کاهن اعظم باید از همان روش قربانی گناه پیروی کند. به این طریق برای قوم خدا کفاره خواهد کرد و خطای آنان بخشیده خواهد شد. ");
INSERT INTO pesopcb_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","او گوسالهٔ قربانی شده را از اردوگاه بیرون ببرد و بسوزاند، همان‌طور که گوسالهٔ قربانی گناه خود را می‌سوزاند. این قربانی گناه تمام قوم اسرائیل است. ");
INSERT INTO pesopcb_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","«اگر یکی از رهبران ناخواسته مرتکب گناهی شود و یکی از قوانین خداوند، خدای خود را زیر پا گذارد، مقصر محسوب می‌شود. ");
INSERT INTO pesopcb_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","وقتی او به گناهش پی برد، باید یک بز نر سالم و بی‌عیب تقدیم کند. ");
INSERT INTO pesopcb_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","دست خود را روی سر بز بگذارد و در جایی که قربانیهای سوختنی را سر می‌برند آن را ذبح کند و به خداوند تقدیم نماید. این، قربانی گناه اوست. ");
INSERT INTO pesopcb_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","بعد کاهن قدری از خون قربانی گناه را بگیرد و با انگشت خود روی شاخهای مذبح قربانی سوختنی بمالد و بقیهٔ خون را به پای مذبح بریزد. ");
INSERT INTO pesopcb_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","تمام چربی باید مثل چربی قربانی سلامتی، روی مذبح سوزانده شود. به این ترتیب کاهن برای گناه رهبر کفاره خواهد کرد و او بخشیده خواهد شد. ");
INSERT INTO pesopcb_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","«اگر یک فرد عادی ناخواسته مرتکب گناهی شود و یکی از قوانین خداوند را زیر پا گذارد، مقصر محسوب می‌شود. ");
INSERT INTO pesopcb_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","وقتی او به گناه خود پی برد، باید یک بز مادهٔ سالم و بی‌عیب بیاورد تا آن را برای گناهش قربانی کند. ");
INSERT INTO pesopcb_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","بز را به مکانی بیاورد که قربانیهای سوختنی را سر می‌برند. در آنجا دست خود را روی سر حیوان بگذارد و آن را ذبح کند. ");
INSERT INTO pesopcb_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","کاهن با انگشت خود قدری از خون را روی شاخهای مذبح قربانی سوختنی بمالد و بقیهٔ خون را به پای مذبح بریزد. ");
INSERT INTO pesopcb_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","تمام چربی باید مثل چربی قربانی سلامتی، جدا شده، بر مذبح سوزانده شود، و این هدیه‌ای خوشبو برای خداوند خواهد بود. به این ترتیب کاهن گناه آن شخص را کفاره خواهد کرد و او بخشیده خواهد شد. ");
INSERT INTO pesopcb_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","«اگر آن شخص بخواهد برای کفارهٔ گناهش بره قربانی کند، باید آن بره، ماده و بی‌عیب باشد. ");
INSERT INTO pesopcb_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","او باید دست خود را روی سر بره بگذارد و آن را در مکانی که قربانیهای سوختنی را سر می‌برند، به عنوان قربانی گناه ذبح کند. ");
INSERT INTO pesopcb_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","کاهن با انگشت خود قدری از خون را بر شاخهای مذبح قربانی سوختنی بمالد و بقیهٔ خون را به پای مذبح بریزد. ");
INSERT INTO pesopcb_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","چربی آن مثل چربی برهٔ قربانی سلامتی روی مذبح سوزانده شود. کاهن آن را مانند قربانیهایی که بر آتش به خداوند تقدیم می‌شوند، بسوزاند. به این ترتیب کاهن گناه آن شخص را کفاره خواهد کرد و او بخشیده خواهد شد. ");
INSERT INTO pesopcb_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","«هرگاه کسی از وقوع جرمی اطلاع داشته باشد ولی در مورد آنچه که دیده یا شنیده در دادگاه شهادت ندهد، مجرم است. ");
INSERT INTO pesopcb_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","«هرگاه کسی لاشهٔ حیوان حرام گوشتی را لمس کند، حتی اگر ندانسته این کار را کرده باشد، نجس و مجرم است. ");
INSERT INTO pesopcb_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","هرگاه کسی نجاست انسان را لمس کند، حتی اگر ندانسته این کار را کرده باشد، وقتی متوجه شد چه کرده است، مجرم می‌باشد. ");
INSERT INTO pesopcb_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","«اگر کسی نسنجیده قولی دهد و قسم بخورد که آن را بجا آورد ولی بعد پی ببرد که قول بی‌جایی داده است، مجرم می‌باشد. ");
INSERT INTO pesopcb_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","در هر یک از این موارد، شخص باید به گناهش اعتراف کند ");
INSERT INTO pesopcb_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","و برای قربانی گناه خود یک بره یا بز ماده نزد خداوند بیاورد تا کاهن برایش کفاره کند. ");
INSERT INTO pesopcb_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","«اگر شخص مجرم تنگدست باشد و نتواند بره‌ای بیاورد، می‌تواند دو قمری یا دو جوجه کبوتر برای کفارهٔ گناه خود به خداوند تقدیم کند، یکی برای قربانی گناه و دیگری برای قربانی سوختنی. ");
INSERT INTO pesopcb_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","کاهن پرنده‌ای را که برای قربانی گناه آورده شده، بگیرد و سرش را ببرد، ولی طوری که از تنش جدا نشود. ");
INSERT INTO pesopcb_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","سپس قدری از خون آن را بر پهلوی مذبح بپاشد و بقیه را به پای مذبح بریزد. این، قربانی گناه است. ");
INSERT INTO pesopcb_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","پرندهٔ دیگر را به عنوان قربانی سوختنی طبق دستورالعملی که قبلا داده شده است قربانی کند. به این ترتیب کاهن برای گناه او کفاره خواهد کرد و گناه او بخشیده خواهد شد. ");
INSERT INTO pesopcb_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","«اگر او فقیرتر از آنست که بتواند دو قمری یا دو جوجه کبوتر برای کفارهٔ گناه خود قربانی کند، می‌تواند یک کیلو آرد مرغوب بیاورد. ولی نباید آن را با روغن زیتون مخلوط کند یا کندر بر آن بگذارد، زیرا این، قربانی گناه است. ");
INSERT INTO pesopcb_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","آرد را پیش کاهن بیاورد تا کاهن مشتی از آن را به عنوان نمونه بردارد و روی مذبح بسوزاند، درست مثل قربانیهایی که بر آتش به خداوند تقدیم می‌شود. این، قربانی گناه اوست. ");
INSERT INTO pesopcb_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","به این ترتیب کاهن برای گناه او در هر یک از این موارد، کفاره خواهد کرد و او بخشیده خواهد شد. در این قربانی نیز مثل هدیهٔ آردی، بقیهٔ آرد به کاهن تعلق می‌گیرد.» ");
INSERT INTO pesopcb_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","خداوند این دستورها را به موسی داد: ");
INSERT INTO pesopcb_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","«هرگاه کسی در دادن هدیه‌ای که در نظر خداوند مقدّس است ناخواسته قصور ورزد، باید یک قوچ سالم و بی‌عیب برای قربانی جبران به خداوند تقدیم نماید. قوچی که برای قربانی جبران اهدا می‌شود ارزش آن باید به مثقال نقره برحسب مثقال عبادتگاه برآورده شود. ");
INSERT INTO pesopcb_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","او باید علاوه بر باز پرداخت هدیه، یک پنجم ارزش آن را نیز به آن افزوده، همه را به کاهن بدهد. کاهن با آن قوچ قربانی جبران، برایش کفاره خواهد کرد و او بخشیده خواهد شد. ");
INSERT INTO pesopcb_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","«اگر کسی مرتکب گناهی شده، یکی از قوانین خداوند را زیر پا بگذارد، ولی نداند که چنین کاری از او سر زده است، باز مجرم است و باید تاوان گناهش را پس بدهد. ");
INSERT INTO pesopcb_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","او باید برای قربانی جبران یک قوچ سالم و بی‌عیب نزد کاهن بیاورد. قیمت قوچ باید مطابق قیمت تعیین شده باشد. کاهن با این قربانی برای او کفاره کند تا گناهش بخشیده شود. ");
INSERT INTO pesopcb_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","این قربانی جبران است برای جرمی که او نسبت به خداوند مرتکب شده است.» ");
INSERT INTO pesopcb_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","خداوند به موسی فرمود: ");
INSERT INTO pesopcb_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","«هرگاه کسی نسبت به شخصی گناه کرده، به خداوند خیانت ورزد، و از پس دادن چیزی که پیش او گرو گذاشته شده خودداری نماید یا در امانت خیانت ورزد، یا دزدی کند یا مال همسایه‌اش را غصب نماید، ");
INSERT INTO pesopcb_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","و یا اینکه در خصوص چیز گمشده‌ای که پیدا کرده است دروغ بگوید و قسم بخورد که پیش او نیست، یا مرتکب هر گناهی از این قبیل شود، ");
INSERT INTO pesopcb_vpl VALUES ("LV6_4‏","004_6_4‏","LEV","6","4‏","5","روزی که جرم او ثابت شود باید اصل مال را پس دهد و یک پنجم ارزش آن را نیز به آن افزوده، به صاحب مال بپردازد. ");
INSERT INTO pesopcb_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","او باید به عنوان قربانی جبران، یک قوچ بی‌عیب و با ارزش نزد کاهن به خیمۀ ملاقات بیاورد و به خداوند تقدیم کند. این قوچ باید مطابق معیار رسمی، ارزیابی شود. ");
INSERT INTO pesopcb_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","کاهن با این قربانی برای او در حضور خداوند کفاره خواهد کرد و گناه او بخشیده خواهد شد.» ");
INSERT INTO pesopcb_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","آنگاه خداوند به موسی فرمود: ");
INSERT INTO pesopcb_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","«این دستورها را در مورد قربانی سوختنی به هارون و پسرانش بده. قربانی سوختنی باید تمام شب بر روی مذبح باشد و آتش مذبح خاموش نشود. ");
INSERT INTO pesopcb_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","صبح روز بعد، کاهن لباس زیر و لباس کتانی خود را بپوشد و خاکستر قربانی سوختنی را برداشته، کنار مذبح بگذارد. ");
INSERT INTO pesopcb_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","سپس لباسش را عوض کند و خاکستر را بیرون از اردوگاه ببرد و در مکان طاهری که برای این کار مقرر شده است، بریزد. ");
INSERT INTO pesopcb_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","کاهن هر روز صبح هیزم تازه بر آن بنهد و قربانی سوختنی روزانه را روی آن بگذارد و چربی قربانی سلامتی را بر آن بسوزاند. ");
INSERT INTO pesopcb_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","آتش مذبح باید همیشه روشن بماند و هرگز خاموش نشود. ");
INSERT INTO pesopcb_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","«قوانین مربوط به هدیهٔ آردی از این قرار است: کاهن برای تقدیم هدیهٔ آردی به خداوند جلوی مذبح بایستد، ");
INSERT INTO pesopcb_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","سپس مشتی از آرد مرغوب آغشته به روغن زیتون را با کندری که بر آن است بردارد و به عنوان نمونه برای خداوند روی مذبح بسوزاند. این هدیه مورد پسند خداوند خواهد بود. ");
INSERT INTO pesopcb_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","بقیهٔ آرد، متعلق به هارون و پسرانش می‌باشد تا از آن برای خوراک خود استفاده کنند. این آرد باید بدون خمیرمایه پخته شود و در حیاط خیمۀ ملاقات خورده شود. ");
INSERT INTO pesopcb_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","این قسمت از هدیهٔ آردی را که بر آتش به خداوند تقدیم می‌شود، خداوند به کاهنان داده است. مانند قربانی گناه و قربانی جبران، این قسمت از هدیهٔ آردی نیز بسیار مقدّس می‌باشد. ");
INSERT INTO pesopcb_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","پسران هارون نسل اندر نسل می‌توانند این قسمت از هدیه را بخورند. این هدیه که بر آتش به خداوند تقدیم می‌شود، همیشه سهم کاهنان خواهد بود و کس دیگری حق ندارد به آن دست بزند.» ");
INSERT INTO pesopcb_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","سپس خداوند به موسی فرمود: ");
INSERT INTO pesopcb_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","«هارون و هر کدام از پسرانش در روزی که برای انتصاب به مقام کاهنی مسح می‌شوند باید یک کیلو آرد مرغوب، به اندازهٔ هدیهٔ آردی روزانه به حضور خداوند بیاورند و نصف آن را در صبح و نصف دیگر را در عصر به خداوند تقدیم کنند. ");
INSERT INTO pesopcb_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","این هدیه باید روی ساج با روغن زیتون پخته شود سپس تکه‌تکه شده، به عنوان هدیهٔ آردی به خداوند تقدیم گردد. این هدیه مورد پسند خداوند خواهد بود. ");
INSERT INTO pesopcb_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","هر کاهنی که به جای پدر خود، کاهن اعظم می‌شود باید در روز انتصاب خود همین هدیه را به خداوند تقدیم کند. این فریضه‌ای ابدی است. ");
INSERT INTO pesopcb_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","هر هدیۀ آردی کاهن باید تماماً سوزانده شود و چیزی از آن خورده نشود.» ");
INSERT INTO pesopcb_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","خداوند به موسی فرمود: ");
INSERT INTO pesopcb_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","«این دستورها را در مورد قربانی گناه به هارون و پسرانش بده. این قربانی بسیار مقدّس است و باید در حضور خداوند در جایی ذبح شود که قربانیهای سوختنی را سر می‌برند. ");
INSERT INTO pesopcb_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","کاهنی که قربانی را تقدیم می‌کند، گوشت آن را در حیاط خیمۀ ملاقات که جای مقدّسی است، بخورد. ");
INSERT INTO pesopcb_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","فقط کسانی که تقدیس شده‌اند، یعنی کاهنان، اجازه دارند به این گوشت دست بزنند. اگر خون آن قربانی به لباس ایشان بپاشد باید لباس خود را در مکانی مقدّس بشویند. ");
INSERT INTO pesopcb_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","ظرف سفالینی که گوشت در آن پخته می‌شود باید شکسته شود. اگر گوشت در یک ظرف مسی پخته شده باشد باید آن ظرف را کاملاً تمیز کنند و با آب بشویند. ");
INSERT INTO pesopcb_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","هر مردی از خانوادۀ کاهنان می‌تواند از این گوشت بخورد. این قربانی بسیار مقدّس است. ");
INSERT INTO pesopcb_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","اما در مواردی که خون قربانی گناه برای کفاره در قدس به داخل خیمۀ ملاقات برده می‌شود، گوشت قربانی را نباید خورد بلکه باید تماماً سوزاند. ");
INSERT INTO pesopcb_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","«قوانین قربانی جبران که قربانی بسیار مقدّسی است، از این قرار می‌باشد: ");
INSERT INTO pesopcb_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","حیوان قربانی باید در مکانی که قربانی سوختنی را سر می‌برند، ذبح شود و خونش بر چهار طرف مذبح پاشیده شود. ");
INSERT INTO pesopcb_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","کاهن تمام چربی آن را تقدیم کند، یعنی دنبه و چربی داخل شکم، ");
INSERT INTO pesopcb_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","دو قلوه و چربی روی آنها در قسمت تهیگاه، و نیز سفیدی روی جگر. اینها باید همراه قلوه‌ها جدا شوند. ");
INSERT INTO pesopcb_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","سپس، کاهن آنها را به عنوان قربانی جبران بر آتش مذبح برای خداوند بسوزاند. ");
INSERT INTO pesopcb_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","پسران کاهنان می‌توانند از این گوشت بخورند. این گوشت باید در جای مقدّسی خورده شود. این قربانی، بسیار مقدّس است. ");
INSERT INTO pesopcb_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","«قانونی که باید در مورد قربانی گناه و قربانی جبران رعایت شود این است: گوشت قربانی به کاهنی تعلق خواهد داشت که مراسم کفاره را اجرا می‌کند. ");
INSERT INTO pesopcb_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","(در ضمن پوست قربانی سوختنی نیز به آن کاهن تعلق دارد.) ");
INSERT INTO pesopcb_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","هر هدیهٔ آردی که در تنور یا در تابه یا روی ساج پخته می‌شود به کاهنی تعلق خواهد گرفت که آن را به خداوند تقدیم می‌کند. ");
INSERT INTO pesopcb_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","تمام هدایای آردی دیگر، خواه مخلوط با روغن زیتون و خواه خشک، به طور مساوی به پسران هارون تعلق دارد. ");
INSERT INTO pesopcb_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","«قوانین قربانی سلامتی که به خداوند تقدیم می‌شود از این قرار است: ");
INSERT INTO pesopcb_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","اگر قربانی به منظور شکرگزاری باشد، همراه آن باید این نانهای بدون خمیرمایه نیز تقدیم شوند قرصهای نان که با روغن زیتون مخلوط شده باشند، نانهای نازک که روغن مالی شده باشند، نانهایی که از مخلوط آرد مرغوب و روغن زیتون تهیه شده باشند. ");
INSERT INTO pesopcb_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","همچنین همراه قربانی باید قرصهای نان خمیرمایه‌دار نیز تقدیم شوند. ");
INSERT INTO pesopcb_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","از هر نوع نان باید یک قسمت به عنوان هدیهٔ مخصوص به خداوند تقدیم شود تا به کاهنی تعلق گیرد که خون حیوان قربانی را روی مذبح می‌پاشد. ");
INSERT INTO pesopcb_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","گوشت حیوان قربانی سلامتی باید در روزی که به عنوان هدیۀ شکرگزاری تقدیم می‌گردد، خورده شود و چیزی از آن برای روز بعد باقی نماند. ");
INSERT INTO pesopcb_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","«اگر قربانی، داوطلبانه یا نذری باشد، گوشت قربانی در روزی که آن را تقدیم می‌کنند، باید خورده شود. اگر از گوشت قربانی چیزی باقی بماند می‌توان آن را روز بعد نیز خورد. ");
INSERT INTO pesopcb_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","ولی هر چه تا روز سوم باقی بماند، باید کاملاً سوزانده شود. ");
INSERT INTO pesopcb_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","اگر در روز سوم چیزی از گوشت قربانی خورده شود، خداوند آن قربانی را قبول نخواهد کرد و به حساب نخواهد آورد زیرا آن گوشت نجس شده است. کسی هم که آن را بخورد مجرم می‌باشد. ");
INSERT INTO pesopcb_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","«گوشتی را که به چیزی نجس خورده است نباید خورد، بلکه باید آن را سوزاند. گوشت قربانی را فقط کسانی می‌توانند بخورند که طاهر هستند. ");
INSERT INTO pesopcb_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","هر که طاهر نباشد و گوشت قربانی سلامتی را که از آنِ خداوند است، بخورد باید از میان قوم منقطع شود. ");
INSERT INTO pesopcb_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","اگر کسی به چیزی نجس دست بزند، خواه نجاست انسان باشد، خواه حیوان نجس و یا هر چیز نجس دیگر، و بعد از گوشت قربانی سلامتی که از آنِ خداوند است، بخورد، باید از میان قوم خدا منقطع شود.» ");
INSERT INTO pesopcb_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","خداوند به موسی فرمود: ");
INSERT INTO pesopcb_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","«این دستورها را به بنی‌اسرائیل بده. هرگز چربی گاو و گوسفند و بز را نخورید. ");
INSERT INTO pesopcb_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","چربی حیوانی که مرده یا توسط جانوری دریده شده باشد هرگز خورده نشود بلکه از آن برای کارهای دیگر استفاده شود. ");
INSERT INTO pesopcb_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","هر کس چربی حیوانی را که بر آتش به خداوند تقدیم می‌شود بخورد باید از میان قوم منقطع شود. ");
INSERT INTO pesopcb_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","هر جا که ساکن باشید، هرگز خون نخورید، نه خون پرنده و نه خون چارپا. ");
INSERT INTO pesopcb_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","هر کس، در هر جا، خون بخورد، باید از میان قوم خدا منقطع شود.» ");
INSERT INTO pesopcb_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","سپس خداوند به موسی فرمود: ");
INSERT INTO pesopcb_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","«این دستورها را به بنی‌اسرائیل بده: هر کس بخواهد قربانی سلامتی به خداوند تقدیم کند باید قسمتی از آن قربانی را به عنوان هدیه نزد خداوند بیاورد. ");
INSERT INTO pesopcb_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","او باید به دست خود آن را همچون هدیۀ مخصوص به خداوند تقدیم کند. چربی حیوان را با سینه تقدیم کند و سینهٔ قربانی را به عنوان هدیهٔ مخصوص، در حضور خداوند تکان دهد. ");
INSERT INTO pesopcb_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","کاهن چربی را بر مذبح بسوزاند، ولی سینهٔ قربانی متعلق به هارون و پسرانش باشد. ");
INSERT INTO pesopcb_vpl VALUES ("LV7_32‏","004_7_32‏","LEV","7","32‏","33","ران راست قربانی، به عنوان هدیهٔ مخصوص، به کاهنی داده شود که خون و چربی قربانی را تقدیم می‌کند؛ ");
INSERT INTO pesopcb_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","زیرا خداوند سینه و ران قربانی سلامتی را از قوم اسرائیل گرفته و آنها را به عنوان هدیهٔ مخصوص به کاهنان داده است و همیشه به ایشان تعلق خواهند داشت. ");
INSERT INTO pesopcb_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","(این قسمت از هدایایی که بر آتش به خداوند تقدیم می‌شود در روز انتصاب هارون و پسرانش به خدمت خداوند، به ایشان داده شد. ");
INSERT INTO pesopcb_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","در روزی که ایشان مسح شدند، خداوند دستور داد که قوم اسرائیل این قسمت را به ایشان بدهند. این، قانونی برای تمام نسلهای ایشان می‌باشد.)» ");
INSERT INTO pesopcb_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","اینها قوانینی بود در مورد قربانی سوختنی، هدیهٔ آردی، قربانی گناه، قربانی جبران، قربانی انتصاب و قربانی سلامتی ");
INSERT INTO pesopcb_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","که خداوند در بیابان، در کوه سینا به موسی داد تا قوم اسرائیل بدانند چگونه قربانیهای خود را به خداوند تقدیم کنند. ");
INSERT INTO pesopcb_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","خداوند به موسی فرمود: ");
INSERT INTO pesopcb_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","«هارون و پسرانش را با لباسهای مخصوص ایشان و روغن تدهین، گوسالهٔ قربانی گناه، دو قوچ و یک سبد نان بدون خمیرمایه دم در خیمۀ ملاقات بیاور ");
INSERT INTO pesopcb_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","و تمام جماعت اسرائیل را در آنجا جمع کن.» ");
INSERT INTO pesopcb_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","موسی طبق فرمان خداوند عمل کرد. همهٔ قوم اسرائیل دم در خیمۀ ملاقات جمع شدند. ");
INSERT INTO pesopcb_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","سپس موسی به ایشان گفت: «آنچه اکنون انجام می‌دهم طبق فرمان خداوند است.» ");
INSERT INTO pesopcb_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","آنگاه موسی، هارون و پسرانش را فرا خواند و ایشان را با آب غسل داد. ");
INSERT INTO pesopcb_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","پیراهن مخصوص کاهنی را به هارون پوشانید و کمربند را به کمرش بست. سپس ردا را بر تن او کرد و ایفود را به‌وسیلۀ بند کمر آن بر او بست. ");
INSERT INTO pesopcb_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","بعد سینه‌پوش را بر او بست و اوریم و تُمّیم را در آن گذاشت، ");
INSERT INTO pesopcb_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","و چنانکه خداوند فرموده بود، دستار را بر سر هارون نهاد و نیم تاج مقدّس را که از طلا بود جلوی دستار نصب کرد. ");
INSERT INTO pesopcb_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","آنگاه موسی روغن مسح را گرفت و آن را بر خیمۀ عبادت و هر چیزی که در آن بود پاشید و آنها را تقدیس نمود. ");
INSERT INTO pesopcb_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","سپس مقداری از روغن را برداشت و آن را هفت مرتبه بر مذبح، لوازم آن، حوض و پایه‌اش پاشید و آنها را نیز تقدیس کرد. ");
INSERT INTO pesopcb_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","بعد قدری از روغن مسح را بر سر هارون ریخت و به این ترتیب او را برای خدمت کاهنی تقدیس نمود. ");
INSERT INTO pesopcb_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","سپس موسی به امر خداوند پسران هارون را فرا خواند و پیراهنها را به آنان پوشانید و شال به کمرشان بست و کلاهها را بر سرشان گذاشت. ");
INSERT INTO pesopcb_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","بعد گوسالهٔ قربانی گناه را جلو آورد و هارون و پسرانش دستهای خود را بر سر آن گذاشتند. ");
INSERT INTO pesopcb_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","موسی گوساله را ذبح کرد و قدری از خون آن را با انگشت خود بر شاخهای مذبح مالید تا آن را طاهر سازد. باقیماندهٔ خون را به پای مذبح ریخت. به این ترتیب مذبح را تقدیس کرده، برای آن کفاره نمود. ");
INSERT INTO pesopcb_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","سپس تمام چربی داخل شکم، سفیدی روی جگر، قلوه‌ها و چربی روی آنها را گرفت و همه را روی مذبح سوزانید، ");
INSERT INTO pesopcb_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","و همان‌طور که خداوند فرموده بود، لاشه و پوست و فضلۀ گوساله را در خارج از اردوگاه سوزانید. ");
INSERT INTO pesopcb_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","بعد قوچ قربانی سوختنی را جلو آورد و هارون و پسرانش دستهای خود را روی سر آن گذاشتند. ");
INSERT INTO pesopcb_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","موسی قوچ را ذبح کرد و خونش را بر چهار طرف مذبح پاشید. ");
INSERT INTO pesopcb_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","سپس قوچ را قطعه‌قطعه کرد و آنها را با کله و چربی حیوان سوزانید. ");
INSERT INTO pesopcb_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","دل و روده و پاچه‌ها را با آب شست و آنها را نیز بر مذبح سوزانید. پس همان‌طور که خداوند به موسی دستور داده بود تمام آن قوچ بر مذبح سوزانده شد. این قربانی سوختنی، هدیه‌ای خوشبو و مخصوص برای خداوند بود. ");
INSERT INTO pesopcb_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","سپس موسی قوچ دوم را که برای تقدیس کاهنان بود جلو آورد و هارون و پسرانش دستهای خود را روی سر آن گذاشتند. ");
INSERT INTO pesopcb_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","موسی قوچ را ذبح کرده، قدری از خونش را بر نرمهٔ گوش راست هارون و شست دست راست او و شست پای راستش مالید. ");
INSERT INTO pesopcb_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","بعد قدری از خون را بر نرمهٔ گوش راست و شست دست راست و شست پای راست پسران هارون مالید. بقیهٔ خون را بر چهار طرف مذبح پاشید. ");
INSERT INTO pesopcb_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","آنگاه چربی، دنبه، چربی داخل شکم، سفیدی روی جگر، قلوه‌ها و چربی روی آنها و ران راست قوچ را گرفت ");
INSERT INTO pesopcb_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","و از داخل سبد نان بدون خمیرمایه که در حضور خداوند بود، یک قرص نان بدون خمیرمایه، یک قرص نان روغنی و یک نان نازک برداشت و آنها را روی چربی و ران راست گذاشت. ");
INSERT INTO pesopcb_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","سپس، همهٔ اینها را بر دستهای هارون و پسرانش قرار داد تا به عنوان هدیهٔ مخصوص در حضور خداوند تکان دهند. ");
INSERT INTO pesopcb_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","پس از انجام این تشریفات، موسی آنها را از دست ایشان گرفت و با قربانی سوختنی بر مذبح سوزانید. این قربانی تقدیس، هدیه‌ای خوشبو و مخصوص برای خداوند بود. ");
INSERT INTO pesopcb_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","موسی سینهٔ قربانی را گرفت و آن را به عنوان هدیهٔ مخصوص تکان داده، به خداوند تقدیم کرد، درست همان‌طور که خداوند به او دستور داده بود. این سهم خود موسی از قوچی بود که برای مراسم تقدیس ذبح می‌شد. ");
INSERT INTO pesopcb_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","سپس موسی قدری از روغن مسح و قدری از خونی را که بر مذبح بود گرفت و بر هارون و لباسهای او و بر پسران او و لباسهای ایشان پاشید و به این ترتیب هارون و پسرانش و لباسهای آنها را تقدیس کرد. ");
INSERT INTO pesopcb_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","آنگاه موسی به هارون و پسرانش گفت: «همان‌طور که خداوند فرموده است، گوشت را دم در خیمۀ ملاقات بپزید و در آنجا آن را با نان مراسم تقدیس که در سبد است، بخورید. ");
INSERT INTO pesopcb_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","هر چه از گوشت و نان باقی ماند باید سوزانده شود. ");
INSERT INTO pesopcb_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","هفت روز از در خیمۀ ملاقات بیرون نروید تا روزهای تقدیس شما سپری شود، زیرا مراسم تقدیس شما هفت روز طول می‌کشد. ");
INSERT INTO pesopcb_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","آنچه امروز انجام شد به فرمان خداوند بود تا به این ترتیب برای گناه شما کفاره داده شود. ");
INSERT INTO pesopcb_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","شما باید هفت شبانه روز دم در خیمۀ ملاقات بمانید و آنچه را که خداوند فرموده است انجام دهید و گرنه خواهید مرد. این دستور خداوند است.» ");
INSERT INTO pesopcb_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","بنابراین هارون و پسرانش هر چه را که خداوند توسط موسی امر فرموده بود، انجام دادند. ");
INSERT INTO pesopcb_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","در روز هشتم، موسی هارون و پسرانش را با مشایخ اسرائیل جمع کرد ");
INSERT INTO pesopcb_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","و به هارون گفت: «یک گوسالهٔ نر سالم و بی‌عیب برای قربانی گناه و یک قوچ سالم و بی‌عیب برای قربانی سوختنی بگیر و آنها را به حضور خداوند تقدیم کن. ");
INSERT INTO pesopcb_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","بعد به قوم اسرائیل بگو که یک بزغالهٔ نر برای قربانی گناه خود و یک گوساله و یک بره که هر دو یک ساله و بی‌عیب باشند برای قربانی سوختنی بیاورند. ");
INSERT INTO pesopcb_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","همچنین قوم اسرائیل باید یک گاو و یک قوچ برای قربانی سلامتی، و آرد مخلوط با روغن زیتون برای هدیهٔ آردی به خداوند تقدیم کنند زیرا امروز خداوند بر ایشان ظاهر خواهد شد.» ");
INSERT INTO pesopcb_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","پس قوم آنچه را که موسی امر فرموده بود، جلوی خیمۀ ملاقات آوردند و تمام جماعت نزدیک شده، در حضور خداوند ایستادند. ");
INSERT INTO pesopcb_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","موسی به ایشان گفت: «خداوند فرموده دستورهای او را انجام دهید تا حضور پرجلال خود را بر شما ظاهر کند.» ");
INSERT INTO pesopcb_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","آنگاه موسی به هارون گفت: «نزدیک مذبح بیا و همان‌طور که خداوند فرموده است قربانی گناه و قربانی سوختنی خود را تقدیم کرده، برای خود کفاره کن و سپس قربانیهای قوم را تقدیم نموده، برای آنها کفاره نما.» ");
INSERT INTO pesopcb_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","بنابراین هارون به مذبح نزدیک شد و گوسالهٔ قربانی گناه خود را ذبح کرد. ");
INSERT INTO pesopcb_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","پسرانش خون گوساله را پیش وی آوردند و او انگشت خود را در خون فرو برد و بر شاخهای مذبح مالید و باقیماندهٔ خون را به پای مذبح ریخت. ");
INSERT INTO pesopcb_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","بعد همان‌طور که خداوند به موسی دستور داده بود، چربی، قلوه‌ها و سفیدی روی جگر قربانی گناه را بر مذبح، ");
INSERT INTO pesopcb_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","و گوشت و پوست آن را بیرون از اردوگاه سوزانید. ");
INSERT INTO pesopcb_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","پس از آن هارون قربانی سوختنی را ذبح کرد و پسرانش خون قربانی را آوردند و هارون آن را بر چهار طرف مذبح پاشید. ");
INSERT INTO pesopcb_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","ایشان کله و قطعه‌های دیگر حیوان را نزد هارون آوردند و او آنها را بر مذبح سوزانید. ");
INSERT INTO pesopcb_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","دل و روده و پاچه‌ها را شست و اینها را نیز به عنوان قربانی سوختنی بر مذبح سوزانید. ");
INSERT INTO pesopcb_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","سپس هارون قربانی قوم اسرائیل را تقدیم کرد. او بز قربانی گناه قوم را ذبح نموده، آن را مانند قربانی گناه خود برای گناه قوم تقدیم کرد. ");
INSERT INTO pesopcb_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","آنگاه مطابق قوانین، قربانی سوختنی ایشان را به خداوند تقدیم نمود. ");
INSERT INTO pesopcb_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","بعد هدیهٔ آردی را آورد و مشتی از آن را گرفت و بر مذبح سوزانید. (این قربانی غیر از قربانی سوختنی‌ای بود که هر روز صبح تقدیم می‌شد.) ");
INSERT INTO pesopcb_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","پس از آن هارون گاو و قوچ را به عنوان قربانی سلامتی قوم ذبح کرد. پسران هارون خون قربانی را نزد او آوردند و او آن را بر چهار طرف مذبح پاشید. ");
INSERT INTO pesopcb_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","سپس چربی گاو و قوچ را که شامل چربی داخل شکم و قلوه‌ها و سفیدی روی جگر گاو و قوچ می‌شد، گرفت ");
INSERT INTO pesopcb_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","و آنها را روی سینه‌های حیوان گذاشته، نزدیک مذبح آورد و تمام چربی را روی مذبح سوزانید. ");
INSERT INTO pesopcb_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","همان‌طور که موسی دستور داده بود، هارون سینه‌ها، و رانهای راست حیوان را به عنوان هدیهٔ مخصوص در حضور خداوند تکان داد. ");
INSERT INTO pesopcb_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","پس از تقدیم قربانیها، هارون دستهای خود را به طرف قوم اسرائیل دراز کرده، ایشان را برکت داد و از مذبح به زیر آمد. ");
INSERT INTO pesopcb_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","موسی و هارون به خیمۀ ملاقات رفتند. وقتی از آنجا بیرون آمدند قوم اسرائیل را برکت دادند. آنگاه حضور پرجلال خداوند بر تمام جماعت ظاهر شد ");
INSERT INTO pesopcb_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","و از حضور خداوند آتش فرود آمده، قربانی سوختنی و چربی روی مذبح را بلعید. بنی‌اسرائیل وقتی این را دیدند، فریاد برآورده، در حضور خداوند به خاک افتادند. ");
INSERT INTO pesopcb_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","ناداب و ابیهو پسران هارون، برخلاف امر خداوند، آتش غیر مجاز بر آتشدان خود نهاده، بر آن بخور گذاشتند و به حضور خداوند تقدیم کردند. ");
INSERT INTO pesopcb_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","ناگاه آتش از حضور خداوند بیرون آمده، آنها را سوزاند و آنها در همان جا، در حضور خداوند مردند. ");
INSERT INTO pesopcb_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","آنگاه موسی به هارون گفت: «منظور خداوند همین بود وقتی فرمود: کسانی که مرا خدمت می‌کنند باید حرمت قدوسیت مرا نگاه دارند تا تمام قوم، مرا احترام کنند.» پس هارون خاموش ماند. ");
INSERT INTO pesopcb_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","بعد موسی، میشائیل و الصافان (پسران عُزّیئیل، عموی هارون) را صدا زد و به ایشان گفت: «بروید و اجساد را از داخل خیمۀ ملاقات بردارید و به خارج از اردوگاه ببرید.» ");
INSERT INTO pesopcb_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","آنها رفتند و همان‌طور که موسی گفته بود ایشان را که هنوز پیراهنهای کاهنی خود را بر تن داشتند، از اردوگاه بیرون بردند. ");
INSERT INTO pesopcb_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","آنگاه موسی به هارون و پسرانش العازار و ایتامار گفت: «عزاداری ننمایید، موهای سرتان را باز نکنید و گریبان لباس خود را چاک نزنید. اگر عزاداری کنید خدا شما را نیز هلاک خواهد کرد و خشم او بر تمام قوم اسرائیل افروخته خواهد شد. ولی بنی‌اسرائیل می‌توانند برای ناداب و ابیهو که در اثر آتش هولناک خداوند مردند، عزاداری نمایند. ");
INSERT INTO pesopcb_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","شما از در خیمۀ ملاقات بیرون نروید مبادا بمیرید، چون روغن مسح خداوند بر شماست.» ایشان طبق دستور موسی عمل کردند. ");
INSERT INTO pesopcb_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","آنگاه خداوند به هارون گفت: ");
INSERT INTO pesopcb_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","«وقتی به خیمۀ ملاقات می‌روید، هرگز شراب یا نوشیدنیهای مست کنندهٔ دیگر ننوشید مبادا بمیرید. این فریضه‌ای است ابدی برای تو و پسرانت و تمام نسلهای آینده‌ات. ");
INSERT INTO pesopcb_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","شما باید فرق بین مقدّس و نامقدّس، و نجس و طاهر را تشخیص دهید. ");
INSERT INTO pesopcb_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","باید تمام دستورهای مرا که توسط موسی به قوم اسرائیل داده‌ام، به ایشان بیاموزید.» ");
INSERT INTO pesopcb_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","سپس موسی به هارون و دو پسر بازمانده‌اش، العازار و ایتامار گفت: «باقیماندهٔ هدیهٔ آردی را که بر آتش به خداوند تقدیم شده است بردارید و از آن، نان بدون خمیرمایه پخته، در کنار مذبح بخورید زیرا این هدیه، بسیار مقدّس است. ");
INSERT INTO pesopcb_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","همان‌گونه که خداوند به من فرموده است باید این را در جای مقدّسی بخورید، زیرا این سهم شما و پسرانتان از هدیه‌ای است که بر آتش به خداوند تقدیم می‌شود. ");
INSERT INTO pesopcb_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","شما و پسران و دخترانتان می‌توانید سینه و ران هدیهٔ مخصوص را که در حضور خداوند تکان داده می‌شود، در مکان طاهری بخورید. این هدایا که سهم شما از قربانی سلامتی قوم اسرائیل می‌باشد به شما و فرزندانتان داده شده است. ");
INSERT INTO pesopcb_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","«بنی‌اسرائیل باید ران و سینه را هنگام تقدیم چربی بر آتش، بیاورند و به عنوان هدیهٔ مخصوص در حضور خداوند تکان دهند. آن ران و سینه همیشه به شما و فرزندانتان تعلق خواهد داشت، همان‌طور که خداوند فرموده است.» ");
INSERT INTO pesopcb_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","موسی سراغ بز قربانی گناه را گرفت، ولی پی برد که سوزانده شده است. پس بر العازار و ایتامار خشمگین شده، گفت: ");
INSERT INTO pesopcb_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","«چرا قربانی گناه را در مکان مقدّس نخوردید؟ این قربانی، بسیار مقدّس می‌باشد و خدا آن را به شما داده است تا گناه قوم اسرائیل را در حضور خداوند کفاره نمایید. ");
INSERT INTO pesopcb_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","چون خون آن به داخل عبادتگاه برده نشد، باید حتماً آن را در محوطهٔ خیمۀ ملاقات می‌خوردید، به طوری که به شما دستور داده بودم.» ");
INSERT INTO pesopcb_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","ولی هارون به موسی گفت: «با وجودی که ایشان قربانی گناه و قربانی سوختنی خود را به حضور خداوند تقدیم کردند این واقعهٔ هولناک برای من پیش آمد. حال اگر از گوشت قربانی گناه می‌خوردیم، آیا خداوند خشنود می‌شد؟» ");
INSERT INTO pesopcb_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","موسی وقتی این را شنید، قانع شد. ");
INSERT INTO pesopcb_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","خداوند به موسی و هارون فرمود: ");
INSERT INTO pesopcb_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","«این دستورها را به بنی‌اسرائیل بدهید. از میان همۀ حیواناتی که روی خشکی‌اند، اینها را می‌توانید بخورید: ");
INSERT INTO pesopcb_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","هر حیوانی که شکافته‌سم باشد و نشخوار کند حلال گوشت است. ");
INSERT INTO pesopcb_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","ولی از میان حیوانات نشخوارکننده یا شکافته‌سُم، اینها را نمی‌توانید بخورید: شتر، زیرا هرچند نشخوار می‌کند ولی شکافته‌سم نیست؛ پس برای شما حرام است. ");
INSERT INTO pesopcb_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","گورکن، زیرا هرچند نشخوار می‌کند، اما شکافته‌سُم نیست؛ پس برای شما حرام است. ");
INSERT INTO pesopcb_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","خرگوش، زیرا هرچند نشخوار می‌کند، ولی شکافته‌سُم نیست، پس برای شما حرام است. ");
INSERT INTO pesopcb_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","و خوک، زیرا هرچند شکافته‌سُم است، ولی نشخوار نمی‌کند، پس برای شما حرام است. ");
INSERT INTO pesopcb_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","پس نباید این حیوانات را بخورید و یا حتی دست به لاشهٔ آنها بزنید، زیرا گوشت آنها حرام است. ");
INSERT INTO pesopcb_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","«از حیواناتی که در آب زندگی می‌کنند چه در رودخانه باشند و چه در دریا آنهایی را می‌توانید بخورید که باله و فلس داشته باشند. ");
INSERT INTO pesopcb_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","تمام جانوران آبزی دیگر برای شما حرامند؛ ");
INSERT INTO pesopcb_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","نه گوشت آنها را بخورید و نه به لاشهٔ آنها دست بزنید. ");
INSERT INTO pesopcb_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","باز تکرار می‌کنم، هر جانور آبزی که باله و فلس نداشته باشد برای شما حرام است. ");
INSERT INTO pesopcb_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","«از میان پرندگان اینها را حرام بدانید و گوشتشان را نخورید: عقاب، لاشخور، لاشخور سیاه، ");
INSERT INTO pesopcb_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","زَغَن و شاهین از هر نوع؛ ");
INSERT INTO pesopcb_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","کلاغ از هر نوع؛ ");
INSERT INTO pesopcb_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","شترمرغ، جغد، مرغ دریایی، و باز از هر نوع؛ ");
INSERT INTO pesopcb_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","بوم، قره غاز، جغد بزرگ، ");
INSERT INTO pesopcb_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","جغد سفید، جغد صحرایی؛ کرکس، ");
INSERT INTO pesopcb_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","لک‌لک، مرغ ماهیخوار از هر نوع؛ هدهد و خفاش. ");
INSERT INTO pesopcb_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","«همۀ حشرات بالدار که بر چهار پا راه می‌روند برای شما حرامند. ");
INSERT INTO pesopcb_vpl VALUES ("LV11_21‏","004_11_21‏","LEV","11","21‏","22","به‌جز آنهایی که می‌جهند، یعنی ملخ و انواع گوناگون آن. اینها را می‌توان خورد. ");
INSERT INTO pesopcb_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","اما سایر حشرات بالدار برای شما حرامند. ");
INSERT INTO pesopcb_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","«هر کس به لاشهٔ این حیوانات حرام گوشت دست بزند تا غروب نجس خواهد بود. ");
INSERT INTO pesopcb_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","هر کس لاشهٔ آنها را بردارد باید لباسش را بشوید؛ او تا غروب نجس خواهد بود. ");
INSERT INTO pesopcb_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","«اگر به حیوانی دست بزنید که سمش کاملاً شکافته نباشد و یا نشخوار نکند، نجس خواهید بود، زیرا حرام گوشت هستند. ");
INSERT INTO pesopcb_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","هر حیوان چهارپا که روی پنجه راه رود خوردنش حرام است. هر کس به لاشهٔ چنین حیوانی دست بزند تا غروب نجس خواهد بود. ");
INSERT INTO pesopcb_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","هر کس لاشهٔ آن را بردارد تا غروب نجس خواهد بود و باید لباس خود را بشوید. این حیوانات برای شما حرام هستند. ");
INSERT INTO pesopcb_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","«از میان حیواناتی که روی زمین می‌جنبند، اینها برای شما حرامند: راسو، موش، و هر نوع سوسمار ");
INSERT INTO pesopcb_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","از قبیل مارمولک، سوسمار زمینی، سوسمار معمولی، بُزمجه و آفتاب پرست. ");
INSERT INTO pesopcb_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","اینها از میان حیواناتی که روی زمین می‌جنبند برای شما حرامند. هر کس به لاشهٔ این جانوران دست بزند تا غروب نجس خواهد بود. ");
INSERT INTO pesopcb_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","اگر لاشهٔ آنها روی چیزی که از جنس چوب، پارچه، چرم یا گونی باشد بیافتد آن چیز نیز نجس خواهد شد؛ باید آن را در آب بگذارید و آن تا غروب نجس خواهد بود ولی بعد از آن، می‌توان دوباره آن را به کار برد. ");
INSERT INTO pesopcb_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","اگر لاشهٔ یکی از این جانوران در یک ظرف سفالین بیفتد، هر چیزی که در ظرف باشد نجس خواهد بود و باید ظرف را شکست. ");
INSERT INTO pesopcb_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","اگر آب چنین ظرفی روی خوراکی ریخته شود آن خوراک نیز نجس خواهد شد و هر آشامیدنی هم که در چنین ظرفی باشد، نجس خواهد بود. ");
INSERT INTO pesopcb_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","اگر لاشهٔ یکی از این جانوران روی تنور یا اجاقی بیفتد، آن تنور یا اجاق نجس خواهد شد و باید آن را شکست. ");
INSERT INTO pesopcb_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","اما اگر لاشه در چشمه یا آب انباری بیفتد، چشمه یا آب انبار نجس نخواهد شد ولی کسی که لاشه را بیرون می‌آورد نجس خواهد شد. ");
INSERT INTO pesopcb_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","اگر لاشه روی دانه‌هایی که قرار است کاشته شود بیفتد آن دانه‌ها نجس نخواهند شد، ");
INSERT INTO pesopcb_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","ولی اگر روی دانه‌های خیس کرده بیفتد دانه‌ها برای شما نجس خواهند بود. ");
INSERT INTO pesopcb_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","«اگر حیوان حلال گوشتی بمیرد، هر کس لاشهٔ آن را لمس کند تا غروب نجس خواهد بود. ");
INSERT INTO pesopcb_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","همچنین اگر کسی گوشت آن را بخورد و یا لاشهٔ آن را جابه‌جا کند باید لباس خود را بشوید و او تا غروب نجس خواهد بود. ");
INSERT INTO pesopcb_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","«همۀ جانورانی که روی زمین می‌جنبند، حرامند و نباید خورده شوند. ");
INSERT INTO pesopcb_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","هر جانوری که روی شکم می‌خزد، و جانوری که روی چهار دست و پا راه می‌رود یا پاهای زیاد دارد، حرام است و نباید خورده شود. ");
INSERT INTO pesopcb_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","با آنها خود را نجس نسازید. ");
INSERT INTO pesopcb_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","من خداوند، خدای شما هستم. پس خود را تقدیس نمایید و مقدّس باشید، چون من مقدّس هستم. پس با این جانورانی که روی زمین می‌خزند خود را نجس نکنید. ");
INSERT INTO pesopcb_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","من همان خداوندی هستم که شما را از سرزمین مصر بیرون آوردم تا خدای شما باشم. بنابراین باید مقدّس باشید، زیرا من مقدّس هستم. ");
INSERT INTO pesopcb_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","«این قوانین را باید در مورد حیوانات، پرندگان، جانوران آبزی و خزندگان رعایت کنید. ");
INSERT INTO pesopcb_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","باید در میان حیوانات نجس و طاهر، حرام گوشت و حلال گوشت، تفاوت قائل شوید.» ");
INSERT INTO pesopcb_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","خداوند به موسی فرمود: ");
INSERT INTO pesopcb_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","«این دستورها را به بنی‌اسرائیل بده: هرگاه زنی پسری بزاید، آن زن تا مدت هفت روز نجس خواهد بود، همان‌گونه که به هنگام عادت ماهانهٔ خود نجس است. ");
INSERT INTO pesopcb_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","روز هشتم، پسرش باید ختنه شود. ");
INSERT INTO pesopcb_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","آن زن باید مدت سی و سه روز صبر کند تا از خونریزی خود کاملاً طاهر گردد. در این مدت او نباید به هیچ چیز مقدّس دست بزند و یا وارد خیمۀ ملاقات شود. ");
INSERT INTO pesopcb_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","هرگاه زنی دختری بزاید، آن زن تا دو هفته نجس خواهد بود همان‌گونه که به هنگام عادت ماهانهٔ خود نجس است. او باید شصت و شش روز صبر کند تا از خونریزی خود کاملاً طاهر شود. ");
INSERT INTO pesopcb_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","«وقتی مدت طهارت تمام شود، نوزاد، خواه پسر باشد خواه دختر، مادرش باید یک برهٔ یک ساله برای قربانی سوختنی و یک جوجه کبوتر یا قمری برای قربانی گناه تقدیم کند. این هدایا را باید دم در خیمۀ ملاقات نزد کاهن بیاورد. ");
INSERT INTO pesopcb_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","کاهن آنها را برای خداوند قربانی نموده، برای مادر کفاره کند. آنگاه او از خونریزی زایمان طاهر خواهد شد. این است آنچه یک زن بعد از زایمان باید انجام دهد. ");
INSERT INTO pesopcb_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","ولی اگر آن زن فقیرتر از آن باشد که بتواند یک بره قربانی کند، می‌تواند دو قمری یا دو جوجه کبوتر بیاورد. یکی برای قربانی سوختنی و دیگری برای قربانی گناه. کاهن باید با تقدیم این قربانیها برایش کفاره کند تا دوباره طاهر شود.» ");
INSERT INTO pesopcb_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","خداوند این قوانین را به موسی و هارون داد: ");
INSERT INTO pesopcb_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","«اگر روی پوست بدن شخصی دمل، جوش یا لکهٔ براقی مشاهده شود، باید وی را نزد هارون یا یکی از کاهنان نسل او بیاورند، چون احتمال دارد آن شخص مبتلا به جذام باشد. ");
INSERT INTO pesopcb_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","کاهن لکه را معاینه خواهد کرد. اگر موهایی که در لکه است سفید شده باشد و اگر آن لکه از پوست گودتر باشد، پس مرض جذام است و کاهن باید او را نجس اعلام کند. ");
INSERT INTO pesopcb_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","اگر لکهٔ روی پوست سفید باشد اما گودتر از پوست نباشد و موهایی که در لکه است سفید نشده باشد، کاهن باید او را تا هفت روز جدا از دیگران نگه دارد. ");
INSERT INTO pesopcb_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","در روز هفتم، کاهن دوباره او را معاینه کند. اگر آن لکه تغییر نکرده باشد و بزرگ نیز نشده باشد، آنگاه کاهن باید هفت روز دیگر هم او را از مردم جدا نگه دارد. ");
INSERT INTO pesopcb_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","روز هفتم، کاهن دوباره او را معاینه کند. اگر نشانه‌های مرض کمتر شده و لکه بزرگ نشده باشد، کاهن او را طاهر اعلام کند، چون یک زخم معمولی بوده است. کافی است آن شخص لباسهایش را بشوید تا طاهر شود. ");
INSERT INTO pesopcb_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","ولی اگر پس از آنکه کاهن او را طاهر اعلام کرد، آن لکه بزرگ شود، باید دوباره نزد کاهن بیاید. ");
INSERT INTO pesopcb_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","کاهن باز به آن نگاه کند، اگر لکه بزرگ شده باشد آنگاه او را نجس اعلام کند، زیرا این جذام است. ");
INSERT INTO pesopcb_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","«شخصی را که گمان می‌رود بیماری جذام دارد باید نزد کاهن بیاورند ");
INSERT INTO pesopcb_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","و کاهن او را معاینه کند. اگر آماس چرکی سفیدی در پوست باشد و موهای روی آن نیز سفید شده باشد، ");
INSERT INTO pesopcb_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","این جذام مزمن است و کاهن باید او را نجس اعلام کند. دیگر نباید او را برای معاینات بیشتر نگه داشت، چون مرض وی قطعی است. ");
INSERT INTO pesopcb_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","ولی اگر جذام در پوست پخش شده باشد، به‌گونه‌ای که تا آنجا که کاهن می‌تواند ببیند، بدنش را از سر تا پا پوشانیده باشد، ");
INSERT INTO pesopcb_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","آنگاه کاهن باید او را معاینه کند، و اگر تمام بدن او که جذام آن را پوشانده سفید شده باشد، کاهن او را طاهر اعلام کند؛ او طاهر است. ");
INSERT INTO pesopcb_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","ولی اگر در جایی از بدنش گوشت تازه نمایان شود، او نجس است. ");
INSERT INTO pesopcb_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","وقتی کاهن گوشت تازه را ببیند، او را نجس اعلام خواهد کرد. گوشت تازه نجس است، زیرا نشانۀ جذام است. ");
INSERT INTO pesopcb_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","اگر گوشت تازه تغییر کند و سفید شود، او باید نزد کاهن بازگردد. ");
INSERT INTO pesopcb_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","کاهن او را معاینه کند و اگر زخم سفید شده باشد، آنگاه او را طاهر اعلام کند؛ او طاهر است. ");
INSERT INTO pesopcb_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","«اگر در پوست بدن کسی دملی به وجود بیاید و پس از مدتی خوب بشود، ");
INSERT INTO pesopcb_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","ولی در جای آن، آماسی سفید یا لکه‌ای سفید مایل به سرخی باقی مانده باشد، آن شخص باید برای معاینه نزد کاهن برود. ");
INSERT INTO pesopcb_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","اگر کاهن دید که لکه گودتر از پوست است و موهایی که در آن است سفید شده است، آنگاه باید او را نجس اعلام کند. این جذام است که در آن دمل بروز کرده است. ");
INSERT INTO pesopcb_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","ولی اگر کاهن ببیند که موهای سفیدی در لکه نیست و لکه نیز گودتر از پوست نیست و رنگ آن هم روشنتر شده است، آنگاه کاهن او را هفت روز از مردم جدا نگه دارد. ");
INSERT INTO pesopcb_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","اگر در آن مدت لکه بزرگ شد کاهن باید او را نجس اعلام کند، زیرا این جذام است. ");
INSERT INTO pesopcb_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","ولی اگر لکه بزرگ نشد، این لکه فقط جای دمل است و کاهن باید او را طاهر اعلام نماید. ");
INSERT INTO pesopcb_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","«اگر کسی دچار سوختگی شود و در جای سوختگی لکه سفید یا سفید مایل به سرخ به وجود آید، ");
INSERT INTO pesopcb_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","کاهن باید لکه را معاینه کند. اگر موهای روی آن لکه سفید شده و جای سوختگی گودتر از پوست بدن باشد، این مرض جذام است که در اثر سوختگی بروز کرده و کاهن باید او را نجس اعلام کند. ");
INSERT INTO pesopcb_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","ولی اگر کاهن ببیند که در لکه، موهای سفیدی نیست و لکه گودتر از پوست بدن به نظر نمی‌آید و کمرنگ شده، کاهن باید هفت روز او را از مردم جدا نگه داشته، ");
INSERT INTO pesopcb_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","روز هفتم دوباره او را معاینه کند. اگر لکه بزرگ شده باشد، کاهن باید او را نجس اعلام کند، زیرا این جذام است. ");
INSERT INTO pesopcb_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","ولی اگر لکه بزرگ نشده و کمرنگ شده باشد، این فقط جای سوختگی است و کاهن باید اعلام نماید که او طاهر است، زیرا این لکه فقط جای سوختگی است. ");
INSERT INTO pesopcb_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","«اگر مردی یا زنی روی سر یا چانه‌اش زخمی داشته باشد، ");
INSERT INTO pesopcb_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","کاهن باید او را معاینه کند. اگر به نظر آید که زخم گودتر از پوست است و موهای زرد و باریکی در زخم پیدا شود، کاهن باید او را نجس اعلام کند، زیرا این، جذامِ سر یا چانه است. ");
INSERT INTO pesopcb_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","ولی اگر معاینهٔ کاهن نشان دهد که زخم گودتر از پوست نیست و در ضمن موهای سیاه نیز در آن دیده نمی‌شود، آنگاه باید او را هفت روز از مردم جدا نگاه دارد ");
INSERT INTO pesopcb_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","و روز هفتم دوباره وی را معاینه کند. اگر زخم بزرگ نشده باشد و موهای زردی نیز در آن نمایان نشده باشد، و اگر لکه گودتر از پوست به نظر نیاید، ");
INSERT INTO pesopcb_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","آنگاه شخص باید موی اطراف زخمش را بتراشد (ولی نه روی خود زخم را) و کاهن هفت روز دیگر او را از مردم جدا نگه دارد. ");
INSERT INTO pesopcb_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","روز هفتم باز معاینه شود و اگر زخم بزرگ نشده باشد و از پوست گودتر به نظر نیاید، کاهن او را طاهر اعلام نماید. او بعد از شستن لباسهایش طاهر خواهد بود. ");
INSERT INTO pesopcb_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","ولی اگر پس از آنکه طاهر اعلام شد، زخم در پوست پخش شود، ");
INSERT INTO pesopcb_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","آنگاه کاهن باید دوباره او را معاینه کند و بی‌آنکه منتظر دیدن موهای زرد بشود، او را نجس اعلام کند. ");
INSERT INTO pesopcb_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","ولی اگر معلوم شود که زخم تغییری نکرده و موهای سیاهی نیز در آن دیده می‌شود، پس او شفا یافته و جذامی نیست و کاهن باید او را طاهر اعلام کند. ");
INSERT INTO pesopcb_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","«اگر مرد یا زنی لکه‌های سفیدی روی پوست بدنش داشته باشد ");
INSERT INTO pesopcb_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","کاهن باید او را معاینه کند. اگر این لکه‌ها سفید کمرنگ باشند، این یک لکهٔ معمولی است که در پوست بروز کرده است. بنابراین آن شخص طاهر است. ");
INSERT INTO pesopcb_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","«اگر موی سر مردی بریزد، او طاس شده اما طاهر است. ");
INSERT INTO pesopcb_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","اگر موهای مردی از اطراف پیشانی بریزد، او از پیشانی طاس شده، ولی طاهر است. ");
INSERT INTO pesopcb_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","اما چنانچه در سر طاس یا پیشانی او لکهٔ سفید مایل به سرخی وجود داشته باشد، ممکن است جذام باشد که در سر یا پیشانی او بروز کرده است. ");
INSERT INTO pesopcb_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","پس کاهن باید او را معاینه کند. اگر لکۀ روی سر یا پیشانی او که به رنگ سفید مایل به سرخ است، مانند بیماری جذام در پوست بدن به نظر برسد، ");
INSERT INTO pesopcb_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","او جذامی و نجس است. کاهن باید او را به سبب زخم سر نجس اعلام کند. ");
INSERT INTO pesopcb_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","«وقتی معلوم شود کسی جذامی است، او باید لباس پاره بپوشد و موهای سرش را باز کند و قسمت پایین صورت خود را پوشانیده، در حین حرکت فریاد بزند: ”جذامی! جذامی!“ ");
INSERT INTO pesopcb_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","تا زمانی که مرض باقی باشد، او نجس است و باید بیرون از اردوگاه، تنها به سر برد. ");
INSERT INTO pesopcb_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","«اگر لباسی، چه پشمی چه کتانی، کپک بزند، ");
INSERT INTO pesopcb_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","هر پارچۀ بافته یا دوخته شدۀ کتانی یا پشمی، و هر چرم یا هر چه از چرم تهیه شده باشد – ");
INSERT INTO pesopcb_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","اگر کپک لباس یا چرم، پارچۀ بافته یا دوخته، یا هر چیز چرمی، به سرخی یا سبزی بزند، کپک زیان‌آور است و باید به کاهن نشان داده شود. ");
INSERT INTO pesopcb_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","کاهن لکه را ببیند و آن پارچه یا شیء را مدت هفت روز نگه دارد ");
INSERT INTO pesopcb_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","و روز هفتم دوباره به آن نگاه کند. اگر کپک پخش شده باشد، چه در پارچۀ بافته شده یا دوخته شده، یا در چرم، کپکِ مضر است و نجس می‌باشد، ");
INSERT INTO pesopcb_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","و کاهن باید آن را بسوزاند، چون جذام مسری در آن است و باید در آتش سوخته شود. ");
INSERT INTO pesopcb_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","«ولی اگر کاهن معاینه کند و ببیند که کپک در لباس، چه بافته شده و چه دوخته شده، و یا در چرم، پخش نشده باشد، ");
INSERT INTO pesopcb_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","باید دستور دهد آنچه را کپک زده است بشویند. سپس هفت روز دیگر آن را جدا نگه دارند. ");
INSERT INTO pesopcb_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","اگر بعد از آن مدت، رنگ لکه تغییر نکرد، هر چند پخش هم نشده باشد، نجس است و باید سوزانده شود، خواه لکه روی آن و خواه زیر آن باشد. ");
INSERT INTO pesopcb_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","اما اگر کاهن ببیند که لکه بعد از شستن کمرنگتر شده، آنگاه قسمت لکه‌دار را از پارچه، چه بافته شده چه دوخته شده، و یا چرم جدا کند. ");
INSERT INTO pesopcb_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","ولی اگر لکه دوباره روی لباس ظاهر شود، چه بافته شده چه دوخته شده، و یا هر چیز چرمی، معلوم می‌شود کپک در حال پیشروی است. آنچه کپک زده است باید سوزانده شود. ");
INSERT INTO pesopcb_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","اما چنانچه بعد از شستن، دیگر اثری از لکه در لباس، چه بافته شده چه دوخته شده، و یا هر شئ چرمی که با شستشو کپک از آن زدوده می‌شود، نباشد، باید بار دیگر شسته شود، و طاهر خواهد بود.» ");
INSERT INTO pesopcb_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","این است قوانین مربوط به مرض جذام در لباس پشمی یا کتانی یا هر چیزی که از چرم درست شده باشد. ");
INSERT INTO pesopcb_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","خداوند به موسی فرمود: ");
INSERT INTO pesopcb_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","«این دستورها دربارهٔ شخصی است که از بیماریهای پوستی شفا یافته و برای تطهیرش او را نزد کاهن آورده‌اند: ");
INSERT INTO pesopcb_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","کاهن باید برای معاینهٔ او از اردوگاه بیرون رود. اگر دید که جذام برطرف شده است ");
INSERT INTO pesopcb_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","دستور دهد دو پرندهٔ زندهٔ حلال گوشت، چند تکه چوب سرو، نخ قرمز و چند شاخه از گیاه زوفا برای مراسم تطهیر شخص شفا یافته بیاورند. ");
INSERT INTO pesopcb_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","سپس دستور دهد که یکی از پرندگان را در یک ظرف سفالین که آن را روی آب روان گرفته باشند سر ببرند ");
INSERT INTO pesopcb_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","و چوب سرو، نخ قرمز، شاخهٔ زوفا و پرندهٔ زنده را در خون پرنده‌ای که بر آب روان سرش بریده شده فرو کند. ");
INSERT INTO pesopcb_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","سپس کاهن خون را هفت مرتبه روی شخصی که از جذام شفا یافته، بپاشد و او را طاهر اعلام کند و پرندهٔ زنده را هم در صحرا رها نماید. ");
INSERT INTO pesopcb_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","آنگاه شخصی که شفا یافته لباس خود را بشوید و تمام موی خود را بتراشد و خود را بشوید تا طاهر شود. سپس او می‌تواند به اردوگاه بازگشته، در آنجا زندگی کند؛ ولی باید تا هفت روز بیرون خیمه‌اش بماند. ");
INSERT INTO pesopcb_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","در روز هفتم دوباره تمام موی خود را که شامل موی سر، ریش، ابرو و سایر قسمتهای بدن او می‌شود، بتراشد و لباسهایش را بشوید و حمام کند. آنگاه آن شخص طاهر خواهد بود. ");
INSERT INTO pesopcb_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","«روز بعد، یعنی روز هشتم، باید دو برهٔ نر بی‌عیب و یک میش یک سالهٔ بی‌عیب با سه کیلو آرد مرغوب مخلوط با روغن زیتون به عنوان هدیهٔ آردی و یک سوم لیتر روغن زیتون نزد کاهن بیاورد. ");
INSERT INTO pesopcb_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","سپس کاهن آن شخص و هدیهٔ وی را دم در خیمۀ ملاقات به حضور خداوند بیاورد. ");
INSERT INTO pesopcb_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","کاهن باید یکی از بره‌های نر را با روغن زیتون گرفته، با تکان دادن آنها در جلوی مذبح، به عنوان قربانی جبران به خداوند تقدیم کند. (این قربانی جزو هدایای مخصوصی است که به کاهن تعلق می‌گیرد.) ");
INSERT INTO pesopcb_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","سپس کاهن در خیمۀ ملاقات در جایی که قربانی گناه و قربانی سوختنی ذبح می‌شوند، بره را سر ببرد. این قربانی جبران بسیار مقدّس است و باید مثل قربانی گناه برای خوراک به کاهن داده شود. ");
INSERT INTO pesopcb_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","کاهن، خون قربانی جبران را بگیرد و مقداری از آن را بر نرمهٔ گوش راست شخصی که طاهر می‌شود و روی شست دست راست او و روی شست پای راستش بمالد. ");
INSERT INTO pesopcb_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","پس از آن، کاهن مقداری از روغن زیتون را گرفته، آن را در کف دست چپ خود بریزد، ");
INSERT INTO pesopcb_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","و انگشت دست راست خود را در آن فرو برده، هفت بار روغن را به حضور خداوند بپاشد. ");
INSERT INTO pesopcb_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","سپس کاهن مقداری از روغن کف دست خود را روی نرمهٔ گوش راست آن شخص و روی شست دست راست و روی شست پای راست او بمالد. ");
INSERT INTO pesopcb_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","بعد روغن باقیمانده در کف دست خود را بر سر آن شخص بمالد. به این ترتیب کاهن در حضور خداوند برای او کفاره خواهد کرد. ");
INSERT INTO pesopcb_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","پس از آن، کاهن باید قربانی گناه را تقدیم کند و بار دیگر مراسم کفاره را برای شخصی که از جذام خود طاهر می‌شود به جا آورد. سپس کاهن قربانی سوختنی را سر ببرد، ");
INSERT INTO pesopcb_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","و آن را با هدیهٔ آردی بر مذبح تقدیم نموده، برای آن شخص کفاره کند تا طاهر محسوب شود. ");
INSERT INTO pesopcb_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","«اگر آن شخص فقیر باشد و نتواند دو بره قربانی کند، می‌تواند یک برهٔ نر به عنوان قربانی جبران بیاورد تا هنگام برگزاری مراسم کفاره جلوی مذبح تکان داده شود و به خداوند تقدیم گردد. همراه با آن یک کیلو آرد مرغوب مخلوط با روغن زیتون به عنوان هدیهٔ آردی و یک سوم لیتر روغن زیتون نیز باید تقدیم شود. ");
INSERT INTO pesopcb_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","آن شخص باید دو قمری یا دو جوجه کبوتر نیز بیاورد و یکی را برای قربانی گناه و دیگری را برای قربانی سوختنی تقدیم کند. ");
INSERT INTO pesopcb_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","روز هشتم آنها را دم در خیمۀ ملاقات نزد کاهن بیاورد تا در حضور خداوند برای مراسم طهارت او تقدیم شوند. ");
INSERT INTO pesopcb_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","کاهن بره را به عنوان قربانی جبران همراه با روغن بگیرد و آنها را جلوی مذبح تکان داده، به خداوند تقدیم کند. (این قربانی جزو هدایای مخصوصی است که به کاهن تعلق می‌گیرد.) ");
INSERT INTO pesopcb_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","سپس بره را به عنوان قربانی جبران ذبح کند و قدری از خون آن را روی نرمهٔ گوش راست شخصی که طاهر می‌شود و روی شست دست راست و روی شست پای راست او بمالد. ");
INSERT INTO pesopcb_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","سپس کاهن مقداری از روغن زیتون را در کف دست چپ خود بریزد ");
INSERT INTO pesopcb_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","و با انگشت راستش قدری از آن را هفت بار به حضور خداوند بپاشد. ");
INSERT INTO pesopcb_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","بعد قدری از روغن زیتون کف دستش را روی نرمهٔ گوش راست آن شخص و روی شست دست راست و روی شست پای راست وی بمالد. ");
INSERT INTO pesopcb_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","روغن باقیمانده در دست خود را بر سر شخصی که طاهر می‌شود بمالد. به این ترتیب کاهن در حضور خداوند برای او کفاره خواهد کرد. ");
INSERT INTO pesopcb_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","پس از آن، باید دو قمری یا دو جوجه کبوتری را که آورده است قربانی کند، ");
INSERT INTO pesopcb_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","یکی را برای قربانی گناه و دیگری را برای قربانی سوختنی. همراه آنها هدیهٔ آردی نیز تقدیم شود. به این ترتیب کاهن در حضور خداوند برای آن شخص کفاره خواهد کرد. ");
INSERT INTO pesopcb_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","این است قوانین مربوط به اشخاصی که از بیماری پوستی شفا یافته، ولی قادر نیستند قربانیهایی را که برای انجام مراسم طهارت لازم است بیاورند.» ");
INSERT INTO pesopcb_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","خداوند به موسی و هارون فرمود: ");
INSERT INTO pesopcb_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","«وقتی به سرزمین کنعان که من آن را به شما به ملکیت می‌بخشم، وارد شدید و من بر خانه‌ای در آن سرزمین کپک بفرستم ");
INSERT INTO pesopcb_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","هرگاه کسی در خانه‌اش متوجهٔ کپک شود، باید بیاید و به کاهن بگوید: ”به نظر می‌رسد در خانهٔ من نوعی کپک وجود دارد!“ ");
INSERT INTO pesopcb_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","کاهن پیش از اینکه خانه را مشاهده کند دستور بدهد که خانه تخلیه شود تا اگر تشخیص داد که مرض جذام در آنجا وجود دارد، هر چه در خانه است، نجس اعلام نشود. سپس کاهن وارد خانه شده ");
INSERT INTO pesopcb_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","آن را مشاهده کند. اگر رگه‌های مایل به سبز یا سرخ در دیوار خانه پیدا کرد که گودتر از سطح دیوار به نظر رسید، ");
INSERT INTO pesopcb_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","باید در خانه را تا هفت روز ببندد. ");
INSERT INTO pesopcb_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","روز هفتم کاهن برگردد و خانه را ملاحظه کند. اگر رگه‌ها در دیوار پخش شده باشند، ");
INSERT INTO pesopcb_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","آنگاه کاهن دستور بدهد آن قسمت رگه‌دار دیوار را کنده، سنگهای آن را در جای ناپاکی خارج از شهر بیندازند. ");
INSERT INTO pesopcb_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","سپس دستور بدهد دیوارهای داخل خانه را بتراشند و خاک تراشیده شده را نیز در جای ناپاکی خارج از شهر بریزند. ");
INSERT INTO pesopcb_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","بعد باید سنگهای دیگری بیاورند و به جای سنگهایی که کنده شده کار بگذارند و با ملاط تازه خانه را دوباره اندود کنند. ");
INSERT INTO pesopcb_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","«ولی اگر رگه‌ها دوباره نمایان شدند، ");
INSERT INTO pesopcb_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","کاهن باید دوباره بیاید و نگاه کند، اگر دید که رگه‌ها پخش شده‌اند، بداند که جذام مسری است و خانه نجس می‌باشد. ");
INSERT INTO pesopcb_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","آنگاه کاهن دستور دهد خانه را خراب کنند و تمام سنگها، تیرها و خاک آن را به خارج از شهر برده، در جای ناپاکی بریزند. ");
INSERT INTO pesopcb_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","وقتی در خانه بسته است، اگر کسی داخل آن شود، تا غروب نجس خواهد بود. ");
INSERT INTO pesopcb_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","هر که در آن خانه بخوابد یا چیزی بخورد، باید لباس خود را بشوید. ");
INSERT INTO pesopcb_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","«اما زمانی که کاهن دوباره برای ملاحظۀ خانه می‌آید، اگر ببیند که رگه‌ها دیگر پخش نشده‌اند، آنگاه اعلام کند که خانه طاهر است و جذام برطرف شده است. ");
INSERT INTO pesopcb_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","سپس برای طهارت خانه، دستور دهد دو پرنده، چند تکه چوب سرو، نخ قرمز و چند شاخه زوفا بیاورند. ");
INSERT INTO pesopcb_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","یکی از پرندگان را روی آب روان در یک ظرف سفالین سر ببرد ");
INSERT INTO pesopcb_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","و چوب سرو و شاخهٔ زوفا و نخ قرمز و پرندهٔ زنده را بگیرد و در خون پرنده‌ای که سربریده است و همچنین در آب روان فرو کند و هفت بار بر خانه بپاشد. ");
INSERT INTO pesopcb_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","به این طریق خانه طاهر می‌شود. ");
INSERT INTO pesopcb_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","سپس پرندهٔ زنده را بیرون شهر در صحرا رها کند. این است روش تطهیر خانه.» ");
INSERT INTO pesopcb_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","این است قوانین مربوط به بیماریهای پوستی، گری، ");
INSERT INTO pesopcb_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","و کپک در لباس یا در خانه ");
INSERT INTO pesopcb_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","و تاول یا آماس یا لک. ");
INSERT INTO pesopcb_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","این روش نشان خواهد داد که چه وقت چیزی نجس است و چه وقت طاهر. این است قوانین بیماریهای پوستی و کپک. ");
INSERT INTO pesopcb_vpl VALUES ("LV15_1‏","004_15_1‏","LEV","15","1‏","2","خداوند به موسی و هارون فرمود: «این دستورها را به بنی‌اسرائیل بدهید: هرگاه بدن مردی ترشح غیرطبیعی داشته باشد، او نجس خواهد بود. ");
INSERT INTO pesopcb_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","این مایع، چه از بدنش به بیرون ترشح کند و چه نکند، او را نجس می‌سازد. ");
INSERT INTO pesopcb_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","هر رختخوابی که او در آن بخوابد و هر چیزی که روی آن بنشیند نجس خواهد شد. ");
INSERT INTO pesopcb_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","هر کس به رختخواب او دست بزند، تا غروب نجس خواهد بود و باید لباس خود را بشوید و غسل کند. ");
INSERT INTO pesopcb_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","هر کس روی چیزی بنشیند که آن مرد هنگام آلودگی خود روی آن نشسته بود، تا غروب نجس خواهد بود و باید لباس خود را بشوید و غسل کند. ");
INSERT INTO pesopcb_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","هر کس به آن مرد دست بزند، باید همین دستورها را اجرا کند. ");
INSERT INTO pesopcb_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","به هر کس آب دهان بیفکند، آن شخص تا غروب نجس خواهد بود و باید لباس خود را بشوید و غسل کند. ");
INSERT INTO pesopcb_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","روی هر زینی که بنشیند، آن زین نجس خواهد بود. ");
INSERT INTO pesopcb_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","اگر کسی چیزی را که زیر این مرد بوده است بردارد یا به آن دست بزند، تا غروب نجس خواهد بود و باید لباس خود را بشوید و غسل کند. ");
INSERT INTO pesopcb_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","اگر این مرد نجس بی‌آنکه اول دستهای خود را بشوید، به کسی دست بزند، آن شخص باید لباس خود را بشوید و غسل کند و تا غروب نجس خواهد بود. ");
INSERT INTO pesopcb_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","اگر مرد نجس به یک ظرف سفالین دست بزند، آن ظرف باید شکسته شود؛ ولی اگر به ظرفی چوبی دست بزند آن ظرف را باید شست. ");
INSERT INTO pesopcb_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","«وقتی ترشح او قطع شود، باید هفت روز صبر کند و بعد لباسهایش را بشوید و در آب روان غسل نماید تا طاهر شود. ");
INSERT INTO pesopcb_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","روز هشتم باید دو قمری یا دو جوجه کبوتر دم در خیمۀ ملاقات به حضور خداوند بیاورد و آنها را به کاهن بدهد. ");
INSERT INTO pesopcb_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","کاهن باید یکی را برای قربانی گناه و دیگری را برای قربانی سوختنی ذبح کند. به این ترتیب کاهن در حضور خداوند برای آن مرد به سبب ترشحی که داشته است کفاره می‌نماید. ");
INSERT INTO pesopcb_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","«هر وقت از مردی منی خارج شود باید خود را کاملاً بشوید؛ او تا غروب نجس خواهد بود. ");
INSERT INTO pesopcb_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","هر پارچه یا چرمی که منی روی آن ریخته باشد باید شسته شود و آن پارچه یا چرم تا غروب نجس خواهد بود. ");
INSERT INTO pesopcb_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","زن و مرد بعد از نزدیکی باید غسل کنند و تا غروب نجس خواهند بود. ");
INSERT INTO pesopcb_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","«زن تا هفت روز بعد از عادت ماهانه‌اش نجس خواهد بود. در آن مدت هر کس به او دست بزند، تا غروب نجس خواهد شد، ");
INSERT INTO pesopcb_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","و او روی هر چیزی بخوابد یا بنشیند، آن چیز نجس خواهد شد. ");
INSERT INTO pesopcb_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","اگر کسی به رختخواب آن زن دست بزند باید لباس خود را بشوید و در آب غسل کند، و او تا غروب نجس خواهد بود. ");
INSERT INTO pesopcb_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","اگر کسی به چیزی که آن زن روی آن نشسته است، دست بزند، باید لباس خود را بشوید و در آب غسل کند، و او تا غروب نجس خواهد بود. ");
INSERT INTO pesopcb_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","پس خواه رختخواب باشد و خواه هرآنچه او بر آن می‌نشیند، چون کسی به آن دست بزند، تا غروب نجس خواهد بود. ");
INSERT INTO pesopcb_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","مردی که در این مدت با او نزدیکی کند، تا هفت روز نجس خواهد بود و هر رختخوابی که او روی آن بخوابد نجس خواهد بود. ");
INSERT INTO pesopcb_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","«اگر خونریزی عادت ماهانه بیش از حد معمول جریان داشته باشد یا در طول ماه، بی‌موقع عادت ماهانهٔ او شروع شود، همان دستورهای بالا باید اجرا گردد. ");
INSERT INTO pesopcb_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","بنابراین در آن مدت او روی هر چیزی که بخوابد یا بنشیند، درست مثل دورهٔ عادت ماهانهٔ عادی نجس خواهد بود. ");
INSERT INTO pesopcb_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","هر کس به رختخواب او یا به چیزی که او روی آن نشسته باشد دست بزند نجس خواهد شد و باید لباس خود را بشوید و غسل کند. او تا غروب نجس خواهد بود. ");
INSERT INTO pesopcb_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","هفت روز بعد از تمام شدن عادت ماهانه، او دیگر نجس نیست. ");
INSERT INTO pesopcb_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","روز هشتم باید دو قمری یا دو جوجه کبوتر دم در خیمۀ ملاقات پیش کاهن بیاورد ");
INSERT INTO pesopcb_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","و کاهن یکی را برای قربانی گناه و دیگری را برای قربانی سوختنی ذبح کند و در حضور خداوند برای نجاست عادت ماهانۀ آن زن کفاره نماید. ");
INSERT INTO pesopcb_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","به این ترتیب قوم اسرائیل را از ناپاکی‌هایشان طاهر کنید مبادا به خاطر آلوده کردن خیمۀ ملاقات من که در میان ایشان است بمیرند. ");
INSERT INTO pesopcb_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","«این است قوانین برای مردی که به سبب ترشح غیرطبیعی یا خارج شدن مَنی نجس شود، ");
INSERT INTO pesopcb_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","و همچنین برای دورهٔ عادت ماهانهٔ زن و در مورد هر شخصی است که با آن زن قبل از طهارت وی نزدیکی کند.» ");
INSERT INTO pesopcb_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","پس از آنکه دو پسر هارون به علّت سوزاندن بخور بر آتش غیر مجاز در حضور خداوند مردند، خداوند با موسی سخن گفته، ");
INSERT INTO pesopcb_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","فرمود: «به برادرت هارون بگو که غیر از وقت تعیین شده، در وقت دیگری به قدس‌الاقداس که پشت پرده است و صندوق عهد و تخت رحمت در آن قرار دارند داخل نشود، مبادا بمیرد؛ چون من در ابر بالای تخت رحمت حضور دارم. ");
INSERT INTO pesopcb_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","شرایط داخل شدن او به آنجا از این قرار است: او باید یک گوساله برای قربانی گناه و یک قوچ برای قربانی سوختنی بیاورد.» ");
INSERT INTO pesopcb_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","سپس خداوند این قوانین را داد: قبل از آنکه هارون به قدس‌الاقداس داخل شود، باید غسل نموده، لباسهای مخصوص کاهنی را بپوشد، یعنی پیراهن مقدّس کتانی، لباس زیر از جنس کتان، کمربند کتانی و دستار کتانی. ");
INSERT INTO pesopcb_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","آنگاه قوم اسرائیل دو بز نر برای قربانی گناهشان و یک قوچ برای قربانی سوختنی نزد او بیاورند. ");
INSERT INTO pesopcb_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","هارون باید اول گوساله را به عنوان قربانی گناه خودش به حضور خداوند تقدیم کند و برای خود و خانواده‌اش کفاره نماید. ");
INSERT INTO pesopcb_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","سپس دو بز نر را دم در خیمۀ ملاقات به حضور خداوند بیاورد. ");
INSERT INTO pesopcb_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","او باید یک بز را برای خداوند ذبح کند و دیگری را در بیابان رها سازد. ولی برای این کار لازم است اول قرعه بیندارد. ");
INSERT INTO pesopcb_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","آنگاه بزی را که به قید قرعه برای خداوند تعیین شده، به عنوان قربانی گناه ذبح کند ");
INSERT INTO pesopcb_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","و بز دیگر را زنده به حضور خداوند آورد و سپس به بیابان بفرستد تا گناه قوم اسرائیل را با خود ببرد. ");
INSERT INTO pesopcb_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","پس از اینکه هارون گوساله را به عنوان قربانی گناه برای خود و خانواده‌اش ذبح کرد، ");
INSERT INTO pesopcb_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","آتشدانی پر از زغالهای مشتعل از مذبح حضور خداوند برداشته، آن را با دو مشت بخور خوشبوی کوبیده شده به قدس‌الاقداس بیاورد ");
INSERT INTO pesopcb_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","و در حضور خداوند، بخور را روی آتش بریزد تا ابری از بخور، تخت رحمت روی صندوق عهد را بپوشاند. بدین ترتیب او نخواهد مرد. ");
INSERT INTO pesopcb_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","هارون مقداری از خون گوساله را آورده، با انگشت خود آن را یک مرتبه بر قسمت جلویی تخت رحمت، سپس هفت مرتبه جلوی آن روی زمین بپاشد. ");
INSERT INTO pesopcb_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","پس از آن، او باید بیرون برود و بز قربانی گناه قوم را ذبح کند و خون آن را به قدس‌الاقداس بیاورد و مانند خون گوساله بر تخت رحمت و جلوی آن بپاشد. ");
INSERT INTO pesopcb_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","به این ترتیب برای قدس‌الاقداس که به سبب گناهان قوم اسرائیل آلوده شده و برای خیمۀ ملاقات که در میان قوم واقع است و با آلودگی‌های ایشان احاطه شده، کفاره خواهد کرد. ");
INSERT INTO pesopcb_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","از زمانی که هارون برای کفاره کردن وارد قدس‌الاقداس می‌شود تا وقتی که از آنجا بیرون می‌آید هیچ‌کس نباید در داخل خیمۀ ملاقات باشد. هارون پس از اینکه مراسم کفاره را برای خود و خانواده‌اش و قوم اسرائیل بجا آورد، ");
INSERT INTO pesopcb_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","باید در حضور خداوند به طرف مذبح برود و برای آن کفاره کند. او باید خون گوساله و خون بز را بر شاخهای مذبح بمالد ");
INSERT INTO pesopcb_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","و با انگشت خود هفت بار خون را بر مذبح بپاشد، و به این ترتیب آن را از آلودگی گناهان بنی‌اسرائیل پاک نموده، تقدیس کند. ");
INSERT INTO pesopcb_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","وقتی هارون مراسم کفاره را برای قدس‌الاقداس، خیمۀ ملاقات و مذبح به انجام رسانید، بز زنده را بیاورد ");
INSERT INTO pesopcb_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","و هر دو دست خود را روی سر حیوان قرار داده، تمام گناهان و تقصیرات قوم اسرائیل را اعتراف کند و آنها را بر سر بز قرار دهد. سپس بز را به دست مردی که برای این کار انتخاب شده است بدهد تا آن را به بیابان برده در آنجا رهایش سازد. ");
INSERT INTO pesopcb_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","بدین ترتیب آن بز تمام گناهان بنی‌اسرائیل را به سرزمینی که کسی در آنجا سکونت ندارد می‌برد. ");
INSERT INTO pesopcb_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","پس از آن، هارون بار دیگر باید داخل خیمۀ ملاقات شده لباسهای کتانی را که هنگام رفتن به قدس‌الاقداس پوشیده بود از تن بیرون بیاورد و آنها را در خیمۀ ملاقات بگذارد. ");
INSERT INTO pesopcb_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","آنگاه در مکان مقدّسی غسل نموده، دوباره لباسهایش را بپوشد و بیرون رفته، قربانی سوختنی خود و قربانی سوختنی بنی‌اسرائیل را تقدیم کند و به این ترتیب برای خود و بنی‌اسرائیل کفاره کند. ");
INSERT INTO pesopcb_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","او باید چربی قربانی گناه را هم بر مذبح بسوزاند. ");
INSERT INTO pesopcb_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","مردی که بز را به بیابان برده است، باید لباس خود را بشوید و غسل کند و بعد به اردوگاه بازگردد. ");
INSERT INTO pesopcb_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","گوساله و بزی که به عنوان قربانی گناه ذبح شدند و هارون خون آنها را به داخل قدس‌الاقداس برد تا کفاره کند، باید از اردوگاه بیرون برده شوند و پوست و گوشت و فضلۀ آنها سوزانده شود. ");
INSERT INTO pesopcb_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","سپس شخصی که آنها را سوزانده، لباس خود را بشوید و غسل کند و بعد به اردوگاه بازگردد. ");
INSERT INTO pesopcb_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","این قوانین را همیشه باید اجرا کنید: در روز دهم ماه هفتم نباید کار بکنید، بلکه آن روز را در روزه بگذرانید. این قانون باید هم به‌وسیلهٔ قوم اسرائیل و هم به‌وسیلۀ غریبانی که در میان قوم اسرائیل ساکن هستند رعایت گردد، ");
INSERT INTO pesopcb_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","چون در آن روز، مراسم کفاره برای آمرزش گناهان انجام خواهد شد تا قوم در نظر خداوند طاهر باشند. ");
INSERT INTO pesopcb_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","این روز برای شما مقدّس است و نباید در این روز کار کنید بلکه باید در روزه به سر برید. این قوانین را همیشه باید اجرا کنید. ");
INSERT INTO pesopcb_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","این مراسم در نسلهای آینده به‌وسیلۀ کاهن اعظمی که به جای جد خود هارون برای کار کاهنی تقدیس شده، انجام خواهد شد. او باید لباسهای مقدّس کتانی را بپوشد، ");
INSERT INTO pesopcb_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","و برای قدس‌الاقداس، خیمۀ ملاقات، مذبح، کاهنان و قوم اسرائیل کفاره کند. ");
INSERT INTO pesopcb_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","شما باید سالی یک مرتبه برای گناهان قوم اسرائیل کفاره کنید و این برای شما یک قانون همیشگی است. هارون تمام دستورهایی را که خداوند به موسی داد بجا آورد. ");
INSERT INTO pesopcb_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","خداوند به موسی فرمود: ");
INSERT INTO pesopcb_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","«این دستورها را به هارون و پسرانش و به تمام بنی‌اسرائیل بده. این است آنچه خداوند فرموده است: ");
INSERT INTO pesopcb_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","هر اسرائیلی که گاو یا گوسفند یا بزی را در جایی دیگر غیر از داخل یا خارج اردوگاه ذبح کند، ");
INSERT INTO pesopcb_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","بجای اینکه آن را کنار در خیمۀ ملاقات بیاورد تا به عنوان هدیه به خداوند تقدیم کند، آن شخص خون ریخته و مجرم است و باید از میان قوم خود منقطع شود. ");
INSERT INTO pesopcb_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","هدف از این قانون این است که قوم اسرائیل دیگر در صحرا قربانی نکنند. قوم باید قربانیهای خود را دم در خیمۀ ملاقات پیش کاهن بیاورند و آنها را به عنوان قربانی سلامتی به خداوند تقدیم کنند. ");
INSERT INTO pesopcb_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","سپس کاهن خون آنها را بر مذبح خداوند که دم در خیمۀ ملاقات است بپاشد و چربی آنها را همچون عطر خوشبویی که مورد پسند خداوند است بسوزاند. ");
INSERT INTO pesopcb_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","قوم اسرائیل دیگر نباید در صحرا برای ارواح شریر قربانی کنند و به خداوند خیانت ورزند. این برای شما قانونی است همیشگی که باید نسل اندر نسل بجا آورده شود. ");
INSERT INTO pesopcb_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","«پس به آنها بگو: هرگاه یک اسرائیلی یا غریبی که در میان قوم ساکن است قربانی سوختنی یا قربانی‌های دیگر تقدیم کند، ");
INSERT INTO pesopcb_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","اما آن را در جایی غیر از دم در خیمۀ ملاقات برای خداوند قربانی کند، آن شخص باید از میان قوم منقطع شود. ");
INSERT INTO pesopcb_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","«هر کس خون بخورد، چه اسرائیلی باشد، چه غریبی که در میان شما ساکن است، روی خود را از او برگردانده او را از میان قوم منقطع خواهم کرد، ");
INSERT INTO pesopcb_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","زیرا جان هر موجودی در خون اوست و من خون را به شما داده‌ام تا برای کفارهٔ جانهای خود، آن را بر روی مذبح بپاشید. خون است که برای جان کفاره می‌کند. ");
INSERT INTO pesopcb_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","به همین دلیل است که به قوم اسرائیل حکم می‌کنم که نه خودشان خون بخورند و نه غریبی که در میان ایشان ساکن است. ");
INSERT INTO pesopcb_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","هر کس به شکار برود، خواه اسرائیلی باشد خواه غریبی که در میان شماست و حیوان یا پرندهٔ حلال گوشتی را شکار کند، باید خونش را بریزد و روی آن را با خاک بپوشاند، ");
INSERT INTO pesopcb_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","زیرا جان هر موجودی در خون اوست. به همین دلیل است که به قوم اسرائیل گفتم که هرگز خون نخورند، زیرا حیات هر موجود زنده‌ای در خون آن است. پس هر کس خون بخورد باید از میان قوم اسرائیل منقطع شود. ");
INSERT INTO pesopcb_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","«هر اسرائیلی یا غریبی که گوشت حیوان مرده یا دریده شده‌ای را بخورد، باید لباس خود را بشوید و غسل کند. او بعد از غروب طاهر خواهد بود. ");
INSERT INTO pesopcb_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","ولی اگر لباسهایش را نشوید و غسل نکند مجرم خواهد بود.» ");
INSERT INTO pesopcb_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","سپس خداوند به موسی فرمود: ");
INSERT INTO pesopcb_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","«این دستورها را به بنی‌اسرائیل بده: من یهوه خدای شما هستم. ");
INSERT INTO pesopcb_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","پس مانند بت‌پرستان رفتار نکنید یعنی مانند مصری‌هایی که در کشورشان زندگی می‌کردید و یا مانند کنعانی‌هایی که می‌خواهم شما را به سرزمینشان ببرم. ");
INSERT INTO pesopcb_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","شما باید از دستورهای من پیروی کنید و قوانین مرا نگاه دارید و آنها را بجا آورید، چون من یهوه، خدای شما هستم. ");
INSERT INTO pesopcb_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","پس دستورها و قوانین مرا نگاه دارید، زیرا از طریق اطاعت از احکام شریعت است که شخص از حیات برخوردار می‌شود. من یهوه هستم. ");
INSERT INTO pesopcb_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","«هیچ‌کس از شما نباید با محارمِ خود همبستر شود. من یهوه هستم. ");
INSERT INTO pesopcb_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","با مادر خود همبستر نشو، زیرا با این کار به او و به پدرت بی‌احترامی می‌کنی. ");
INSERT INTO pesopcb_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","با هیچ‌کدام از زنان پدرت همبستر نشو، چون با این کار به پدرت بی‌احترامی می‌کنی. ");
INSERT INTO pesopcb_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","همچنین با خواهر تنی یا با خواهر ناتنی خود، چه دختر پدرت باشد چه دختر مادرت، چه در همان خانه به دنیا آمده باشد چه در جای دیگر، همبستر نشو. ");
INSERT INTO pesopcb_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","«با دختر پسرت یا دختر دخترت همبستر نشو، چون با این کار خود را رسوا می‌کنی. ");
INSERT INTO pesopcb_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","با دختر زن پدرت همبستر نشو، چون او خواهر ناتنی توست. ");
INSERT INTO pesopcb_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","با عمهٔ خود همبستر نشو، چون از بستگان نزدیک پدرت می‌باشد. ");
INSERT INTO pesopcb_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","با خالهٔ خود همبستر نشو، چون از بستگان نزدیک مادرت است. ");
INSERT INTO pesopcb_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","با زن عموی خود همبستر نشو، چون او مثل عمهٔ توست. ");
INSERT INTO pesopcb_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","«با عروس خود همبستر نشو، چون زن پسر توست. ");
INSERT INTO pesopcb_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","با زن برادرت همبستر نشو، چون با این کار به برادرت بی‌احترامی می‌کنی. ");
INSERT INTO pesopcb_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","با یک زن و دختر او یا نوه‌اش همبستر نشو، چون آنها بستگان نزدیک همدیگرند و این عمل قبیحی است. ");
INSERT INTO pesopcb_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","مادامی که زنت زنده است نباید خواهر او را هم به زنی بگیری و با او همبستر شوی. ");
INSERT INTO pesopcb_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","«با زنی به هنگام عادت ماهانه‌اش همبستر نشو. ");
INSERT INTO pesopcb_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","با زنی که همسر مرد دیگری است همبستر نشو و خود را با او نجس نساز. ");
INSERT INTO pesopcb_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","«هیچ‌کدام از فرزندان خود را به بت مولک هدیه نکن و آنها را بر مذبح آن نسوزان زیرا با این کار نام خداوند، خدای خود را بی‌حرمت خواهی کرد. ");
INSERT INTO pesopcb_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","«هیچ مردی نباید با مرد دیگری نزدیکی کند، چون این عمل، بسیار قبیح است. ");
INSERT INTO pesopcb_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","هیچ مرد یا زنی نباید با هیچ حیوانی نزدیکی کند و با این کار خود را نجس سازد. این عمل، بسیار قبیح است. ");
INSERT INTO pesopcb_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","«با این کارها خود را نجس نسازید، چون این اعمالی است که بت‌پرستها انجام می‌دهند و به خاطر این کارهاست که می‌خواهم آنان را از سرزمینی که شما داخل آن می‌شوید بیرون کنم. ");
INSERT INTO pesopcb_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","تمامی آن سرزمین با این نوع اعمال، نجس شده است. به همین دلیل است که مردمانی را که در آنجا ساکنند مجازات می‌کنم، و سرزمینشان آنها را قی می‌کند. ");
INSERT INTO pesopcb_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","شما باید از تمام قوانین و دستورهای من اطاعت کنید و هیچ‌کدام از این اعمال قبیح را انجام ندهید. این قوانین هم شامل شما می‌شود و هم شامل غریبانی که در میان شما ساکنند. ");
INSERT INTO pesopcb_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","«آری، تمامی این اعمال قبیح به‌وسیلۀ مردمان سرزمینی که می‌خواهم شما را به آنجا ببرم به عمل آمده و آن سرزمین را نجس کرده است. ");
INSERT INTO pesopcb_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","شما این اعمال را انجام ندهید و گرنه شما را نیز مثل اقوامی که اکنون در آنجا ساکنند از آن سرزمین بیرون خواهم راند. ");
INSERT INTO pesopcb_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","هر کس مرتکب یکی از این اعمال قبیح گردد، از میان قوم منقطع خواهد شد. ");
INSERT INTO pesopcb_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","پس احکام مرا اطاعت کنید و هیچ‌یک از این عادات زشت را انجام ندهید. خود را با این اعمال قبیح نجس نکنید زیرا من یهوه، خدای شما هستم.» ");
INSERT INTO pesopcb_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","خداوند به موسی فرمود: ");
INSERT INTO pesopcb_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","«این دستورها را به تمامی جماعت اسرائیل بده. مقدّس باشید زیرا من یهوه، خدای شما قدّوسم. ");
INSERT INTO pesopcb_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","هر یک از شما باید به مادر و پدر خود احترام بگذارد و قانون روز شَبّات مرا اطاعت کند. من یهوه، خدای شما هستم. ");
INSERT INTO pesopcb_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","بت نسازید و بتها را پرستش نکنید. من یهوه، خدای شما هستم. ");
INSERT INTO pesopcb_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","«وقتی که قربانی سلامتی به حضور خداوند تقدیم می‌کنید آن را طوری هدیه کنید که مورد قبول واقع شوید. ");
INSERT INTO pesopcb_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","گوشتش را در همان روزی که آن را ذبح می‌کنید و یا روز بعد بخورید. هر چه را که تا روز سوم باقی مانده، بسوزانید، ");
INSERT INTO pesopcb_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","زیرا نجس است و اگر کسی آن را بخورد من آن قربانی را قبول نخواهم کرد. ");
INSERT INTO pesopcb_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","اگر در روز سوم از آن بخورید مقصرید، چون به قدوسیت خداوند بی‌احترامی کرده‌اید و باید از میان قوم منقطع شوید. ");
INSERT INTO pesopcb_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","«وقتی که محصول خود را درو می‌کنید، گوشه و کنار مزرعه‌های خود را درو نکنید و خوشه‌های گندم به جا مانده را برنچینید. ");
INSERT INTO pesopcb_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","در مورد حاصل انگور خود نیز همین‌طور عمل کنید خوشه‌ها و دانه‌های انگوری را که بر زمین می‌افتد، جمع نکنید. آنها را برای فقرا و غریبان بگذارید. من یهوه، خدای شما هستم. ");
INSERT INTO pesopcb_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","«دزدی نکنید، دروغ نگویید و کسی را فریب ندهید. ");
INSERT INTO pesopcb_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","به نام من قسم دروغ نخورید و به این ترتیب نام مرا بی‌حرمت نکنید. من یهوه هستم. ");
INSERT INTO pesopcb_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","«مال کسی را غصب نکن و به کسی ظلم ننما و مزد کارگران خود را به موقع بپرداز. ");
INSERT INTO pesopcb_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","«شخص کر را نفرین نکن و جلوی پای کور سنگ نیانداز. از خدای خود بترس؛ من یهوه هستم. ");
INSERT INTO pesopcb_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","«هنگام داوری، از فقیر طرفداری بیجا نکن و از ثروتمند ترسی نداشته باش، بلکه همیشه منصفانه داوری کن. ");
INSERT INTO pesopcb_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","«سخن‌چینی نکن و با پخش خبر دروغ باعث نشو کسی به مرگ محکوم شود. من یهوه هستم. ");
INSERT INTO pesopcb_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","«از برادرت کینه به دل نگیر. همسایه‌ات را رو در رو توبیخ کن مبادا به سبب گناه او تو هم شریک جرم محسوب شوی. ");
INSERT INTO pesopcb_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","از افراد قوم خود انتقام نگیر و از آنان کینه به دل راه نده، بلکه همسایه‌ات را همچون جان خویش دوست بدار. من یهوه هستم. ");
INSERT INTO pesopcb_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","«از قوانین من اطاعت کنید. حیوانات اهلی خود را به جفتگیری با حیوانات غیر همجنسشان وادار نکنید. در مزرعهٔ خود دو نوع بذر نکارید و لباسی را که از دو جنس مختلف بافته شده نپوشید. ");
INSERT INTO pesopcb_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","«اگر مردی با کنیزی که نامزد شخص دیگری است همبستر شود و آن کنیز هنوز بازخرید و آزاد نشده باشد، ایشان را نباید کشت بلکه باید تنبیه کرد، چون کنیز آزاد نبوده است. ");
INSERT INTO pesopcb_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","مردی که آن دختر را فریب داده، باید به عنوان قربانی جبران خود قوچی را دم در خیمۀ ملاقات به حضور خداوند بیاورد. ");
INSERT INTO pesopcb_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","کاهن باید با این قوچ برای گناه آن مرد نزد خداوند کفاره کند و به این ترتیب گناهش بخشیده خواهد شد. ");
INSERT INTO pesopcb_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","«وقتی به سرزمین موعود داخل شدید و انواع درختان میوه در آنجا کاشتید، سه سال از محصول آن نخورید، چون نجس به حساب می‌آید. ");
INSERT INTO pesopcb_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","در سال چهارم، تمامی محصول به‌عنوان ستایش و تشکر از خداوند، به او وقف خواهد شد. ");
INSERT INTO pesopcb_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","اما در سال پنجم می‌توانید محصول را برای خود بردارید. اگر این قانون را رعایت کنید، درختان شما پرثمر خواهند بود. من یهوه، خدای شما هستم. ");
INSERT INTO pesopcb_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","«گوشتی را که هنوز خون در آن است نخورید. فالگیری و جادوگری نکنید. ");
INSERT INTO pesopcb_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","مثل بت‌پرستها موهای شقیقه خود را نتراشید و گوشه‌های ریش خود را نچینید. ");
INSERT INTO pesopcb_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","هنگام عزاداری برای مردگان خود مثل بت‌پرستان بدن خود را زخمی نکنید و مانند آنها روی بدن خود خالکوبی ننمایید. من یهوه هستم. ");
INSERT INTO pesopcb_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","«حرمت دخترتان را با وادار کردن او به فاحشگی از بین نبرید مبادا سرزمین شما از شرارت و زنا پر شود. ");
INSERT INTO pesopcb_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","«قانون روز شَبّات مرا اطاعت کنید و خیمۀ ملاقات مرا محترم بدارید، زیرا من یهوه هستم. ");
INSERT INTO pesopcb_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","«به جادوگران و احضارکنندگان ارواح متوسل نشوید و با این کار خود را نجس نکنید. من یهوه، خدای شما هستم. ");
INSERT INTO pesopcb_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","«جلوی پای ریش‌سفیدان بلند شوید، به پیرمردان احترام بگذارید و از من بترسید. من یهوه، خدای شما هستم. ");
INSERT INTO pesopcb_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","با غریبانی که در سرزمینتان زندگی می‌کنند بدرفتاری نکنید. ");
INSERT INTO pesopcb_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","با آنها مانند یک اسرائیلی بومی رفتار کنید، و آنها را همچون خویشتن محبت کنید، زیرا نباید از یاد ببرید که خودتان نیز در سرزمین مصر غریب و بیگانه بودید. من یهوه، خدای شما هستم. ");
INSERT INTO pesopcb_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","«در اندازه‌گیری طول و وزن و حجم، تقلب نکنید. ");
INSERT INTO pesopcb_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","ترازو، وزنه‌ها، ظرفهای اندازه‌گیری جامدات و مایعات درست داشته باشید. من یهوه، خدای شما هستم که شما را از سرزمین مصر بیرون آوردم. ");
INSERT INTO pesopcb_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","از احکام و فرایض من به دقت اطاعت و پیروی کنید. من یهوه هستم.» ");
INSERT INTO pesopcb_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","خداوند به موسی فرمود: ");
INSERT INTO pesopcb_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","«این دستورها را به بنی‌اسرائیل بده: هر کسی، چه اسرائیلی باشد چه غریبی که در میان شما ساکن است، اگر فرزند خود را برای بت مولک قربانی کند، قوم اسرائیل باید او را سنگسار کنند. ");
INSERT INTO pesopcb_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","من خود بر ضد او برمی‌خیزم و او را از میان قوم اسرائیل منقطع کرده به سزای اعمالش خواهم رساند، زیرا فرزند خود را برای مولک قربانی کرده و بدین وسیله خیمۀ ملاقات مرا نجس نموده و نام مقدّس مرا بی‌حرمت ساخته است. ");
INSERT INTO pesopcb_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","اگر اهالی محل وانمود کنند که از کاری که آن مرد کرده، بی‌خبرند و نخواهند او را بکشند، ");
INSERT INTO pesopcb_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","آنگاه من بر ضد او و خانواده‌اش برمی‌خیزم و او را با تمامی اشخاص دیگری که از مولک پیروی نموده، به من خیانت ورزیده‌اند منقطع می‌کنم و به سزای اعمالشان می‌رسانم. ");
INSERT INTO pesopcb_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","«اگر کسی به جادوگران و احضارکنندگان ارواح متوسل شده، با این عمل به من خیانت ورزد من بر ضد او برمی‌خیزم و او را از میان قوم خود منقطع کرده، به سزای اعمالش می‌رسانم. ");
INSERT INTO pesopcb_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","پس خود را تقدیس نمایید و مقدّس باشید، چون من خداوند، خدای شما هستم. ");
INSERT INTO pesopcb_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","از فرامین من که خداوند هستم و شما را تقدیس می‌کنم، اطاعت کنید. ");
INSERT INTO pesopcb_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","«کسی که پدر یا مادرش را نفرین کند، باید کشته شود؛ و خونش بر گردن خودش خواهد بود. ");
INSERT INTO pesopcb_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","«اگر فردی با همسر شخص دیگری زنا کند، مرد و زن هر دو باید کشته شوند. ");
INSERT INTO pesopcb_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","اگر مردی با زن پدر خود همبستر شود به پدر خود بی‌احترامی کرده است، پس آن مرد و زن هر دو باید کشته شوند؛ و خونشان به گردن خودشان می‌باشد. ");
INSERT INTO pesopcb_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","اگر مردی با عروس خود همبستر شود، هر دو باید کشته بشوند، زیرا زنا کرده‌اند؛ و خونشان به گردن خودشان می‌باشد. ");
INSERT INTO pesopcb_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","اگر دو مرد با هم نزدیکی کنند، عمل قبیحی انجام داده‌اند و باید کشته شوند؛ و خونشان به گردن خودشان می‌باشد. ");
INSERT INTO pesopcb_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","اگر مردی با زنی و با مادر آن زن نزدیکی کند، گناه بزرگی کرده است و هر سه باید زنده‌زنده سوزانده شوند تا این لکهٔ ننگ از دامن شما پاک شود. ");
INSERT INTO pesopcb_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","«اگر مردی با حیوانی نزدیکی کند، آن مرد و آن حیوان باید کشته شوند. ");
INSERT INTO pesopcb_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","اگر زنی با حیوانی نزدیکی کند، آن زن و حیوان باید کشته شوند؛ و خونشان به گردن خودشان می‌باشد. ");
INSERT INTO pesopcb_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","«اگر مردی با خواهر خود ازدواج کند و با او همبستر شود، خواه دختر پدرش باشد، خواه دختر مادرش، عمل شرم‌آوری کرده است و هر دو باید در پیش چشمان مردم از میان قوم منقطع شوند و آن مرد باید به سزای گناه خود برسد، زیرا خواهر خود را بی‌عصمت کرده است. ");
INSERT INTO pesopcb_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","اگر مردی با زنی به هنگام عادت ماهانه‌اش همبستر شود، هر دو نفر باید از میان قوم اسرائیل منقطع شوند، زیرا مقررات مربوط به طهارت را رعایت نکرده‌اند. ");
INSERT INTO pesopcb_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","«اگر مردی با خاله یا عمهٔ خود همبستر شود، هر دو آنها باید به سزای گناه خود برسند، زیرا بستگان نزدیک یکدیگرند. ");
INSERT INTO pesopcb_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","اگر مردی با زن عموی خود همبستر شود، به عموی خود بی‌احترامی کرده است. آنها به سزای گناه خود خواهند رسید و بی‌اولاد خواهند مرد. ");
INSERT INTO pesopcb_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","اگر مردی زن برادر خود را به زنی بگیرد، کار قبیحی کرده است، زیرا نسبت به برادرش بی‌احترامی نموده است. هر دو ایشان بی‌اولاد خواهند مرد. ");
INSERT INTO pesopcb_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","«باید از تمامی قوانین و دستورهای من اطاعت کنید تا شما را از سرزمین جدیدتان بیرون نکنم. ");
INSERT INTO pesopcb_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","از رسوم مردمی که از پیش شما می‌رانم پیروی نکنید چون ایشان همهٔ اعمالی را که من شما را از آنها برحذر ساخته‌ام انجام می‌دهند و به همین دلیل است که از آنها نفرت دارم. ");
INSERT INTO pesopcb_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","قول داده‌ام سرزمینشان را به شما بدهم تا آن را به تصرف خود درآورده، مالک آن باشید. آنجا سرزمینی است که شیر و عسل در آن جاری است. من خداوند، خدای شما هستم که شما را از قومهای دیگر جدا کرده‌ام. ");
INSERT INTO pesopcb_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","«بین پرندگان و حیواناتی که گوشت آنها برای شما حلال است و آنهایی که حرام است فرق بگذارید. با خوردن گوشت پرندگان یا حیواناتی که خوردن آنها را برای شما حرام کرده‌ام خود را آلوده نکنید. ");
INSERT INTO pesopcb_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","برای من مقدّس باشید، زیرا من که خداوند هستم مقدّس می‌باشم و شما را از سایر اقوام جدا ساخته‌ام تا از آن من باشید. ");
INSERT INTO pesopcb_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","«احضارکنندهٔ روح یا جادوگر، چه مرد باشد چه زن، باید سنگسار شود. خون او بر گردن خودش است.» ");
INSERT INTO pesopcb_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","خداوند به موسی فرمود: «این دستورها را به کاهنان که از نسل هارون هستند بده. یک کاهن نباید با دست زدن به شخص مرده خودش را نجس کند، ");
INSERT INTO pesopcb_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","مگر اینکه مرده از بستگان نزدیک او باشد، مثل: مادر، پدر، پسر، دختر، برادر ");
INSERT INTO pesopcb_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","یا خواهر باکره‌اش که تحت سرپرستی او بوده است. ");
INSERT INTO pesopcb_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","اما کاهن نباید به خاطر افرادی که از بستگانش نیستند، خود را نجس سازد. ");
INSERT INTO pesopcb_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","«کاهنان نباید موی سر یا گوشه‌های ریش خود را بتراشند و یا بدن خود را زخمی کنند. ");
INSERT INTO pesopcb_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","ایشان باید برای خدای خود مقدّس باشند و به نام خدای خویش بی‌احترامی نکنند. آنها برای خداوند هدایای خوراکی بر آتش تقدیم می‌کنند، پس باید مقدّس باشند. ");
INSERT INTO pesopcb_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","کاهن نباید با یک فاحشه که خود را بی‌عصمت کرده و یا با زنی که طلاق گرفته، ازدواج کند؛ چون او برای خدای خویش مقدّس است. ");
INSERT INTO pesopcb_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","کاهنان را مقدّس بشمارید زیرا ایشان هدایای خوراکی به من تقدیم می‌کنند، و من که خداوند هستم و شما را تقدیس می‌کنم، مقدّس می‌باشم. ");
INSERT INTO pesopcb_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","اگر دختر کاهنی فاحشه شود به تقدس پدرش لطمه می‌زند و باید زنده‌زنده سوزانده شود. ");
INSERT INTO pesopcb_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","«کاهن اعظم که با روغن مخصوص، مسح و تقدیس شده و لباسهای مخصوص کاهنی را می‌پوشد، نباید هنگام عزاداری موی سر خود را باز کند یا گریبان لباس خود را چاک بزند. ");
INSERT INTO pesopcb_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","او نباید با نزدیک شدن به هیچ جنازه‌ای خود را نجس سازد، حتی اگر شخص مرده پدر یا مادرش باشد. ");
INSERT INTO pesopcb_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","او نباید با خارج شدن از قدس خدا به جهت وارد شدن به خانه‌ای که جنازه‌ای در آن هست، قدس را بی‌حرمت سازد، زیرا تبرک روغن مسح من که یهوه هستم بر سر اوست. ");
INSERT INTO pesopcb_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","او باید فقط با یک باکره ازدواج کند. ");
INSERT INTO pesopcb_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","او نباید با زن بیوه یا طلاق داده شده یا زنی که با فاحشه شدن خود را بی‌عصمت کرده است ازدواج کند، بلکه باید دختر باکره‌ای از قوم خود را به زنی بگیرد، ");
INSERT INTO pesopcb_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","تا باعث بدنامی نسل خود در میان قومش نشود، زیرا من که یهوه هستم او را برای کاهنی تقدیس کرده‌ام.» ");
INSERT INTO pesopcb_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","خداوند به موسی فرمود: ");
INSERT INTO pesopcb_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","«این دستورها را به هارون بده. در نسلهای آینده هر کدام از فرزندانت که عضوی از بدنش ناقص باشد نباید هدایای خوراکی را به حضور من تقدیم کند. ");
INSERT INTO pesopcb_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","کسی که نقصی در صورت داشته باشد و یا کور، شل، ناقص الخلقه، ");
INSERT INTO pesopcb_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","دست یا پا شکسته، ");
INSERT INTO pesopcb_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","گوژپشت یا کوتوله باشد، چشم معیوب یا مرض پوستی داشته یا بیضه‌هایش آسیب دیده باشد، ");
INSERT INTO pesopcb_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","به سبب نقص جسمی‌اش اجازه ندارد هدایای خوراکی را که بر آتش به خداوند تقدیم می‌شود، تقدیم کند. ");
INSERT INTO pesopcb_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","با وجود این باید از خوراک کاهنان که از هدایای تقدیمی به خداوند است به او غذا داده شود هم از هدایای مقدّس و هم از مقدّسترین هدایا. ");
INSERT INTO pesopcb_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","ولی او نباید به پردهٔ مقدّس خیمۀ ملاقات یا به مذبح نزدیک شود چون نقص بدنی دارد و این عمل او خیمۀ ملاقات مرا بی‌حرمت می‌کند، زیرا من که خداوند هستم آن را تقدیس کرده‌ام.» ");
INSERT INTO pesopcb_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","موسی این دستورها را به هارون و پسرانش و تمامی قوم اسرائیل داد. ");
INSERT INTO pesopcb_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","خداوند به موسی فرمود: ");
INSERT INTO pesopcb_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","«به هارون و پسرانش بگو که حرمت قربانیها و هدایای مقدّسی را که قوم به من وقف می‌کنند، نگه دارند و نام مقدّس مرا بی‌حرمت نسازند، زیرا من یهوه هستم. ");
INSERT INTO pesopcb_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","این دستورها را به آنها بده. در نسلهای شما اگر یک کاهن در حالی که نجس است به این هدایای مقدّسی که بنی‌اسرائیل به خداوند وقف کرده نزدیک شود، او باید از مقام کاهنی برکنار شود، زیرا من یهوه هستم. ");
INSERT INTO pesopcb_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","«کاهنی که جذام داشته باشد یا از بدنش مایع ترشح شود، تا وقتی که طاهر نشده، حق ندارد از قربانیهای مقدّس بخورد. هر کاهنی که به جنازه‌ای دست بزند یا در اثر خروج مَنی نجس گردد، ");
INSERT INTO pesopcb_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","و یا حیوان یا شخصی را که نجس است لمس کند، ");
INSERT INTO pesopcb_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","آن کاهن تا عصر نجس خواهد بود، و تا هنگام غروب که غسل می‌کند نباید از قربانیهای مقدّس بخورد. ");
INSERT INTO pesopcb_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","وقتی که آفتاب غروب کرد، او دوباره طاهر می‌شود و می‌تواند از خوراک مقدّس بخورد، چون خوراک او همین است. ");
INSERT INTO pesopcb_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","کاهن نباید گوشت حیوان مرده یا حیوانی را که جانوران وحشی آن را دریده باشند بخورد، چون این عمل او را نجس می‌کند. من یهوه هستم. ");
INSERT INTO pesopcb_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","کاهنان باید با دقت از این دستورها اطاعت کنند، مبادا به سبب سرپیچی از این قوانین به آن بی‌حرمتی کرده، مجرم شوند و در نتیجه بمیرند. من که یهوه هستم ایشان را تقدیس کرده‌ام. ");
INSERT INTO pesopcb_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","«هیچ‌کس غیر از کاهنان نباید از قربانیهای مقدّس بخورد. میهمان یا خدمتکار کاهن که از او مزد می‌گیرد نیز نباید از این خوراک بخورد. ");
INSERT INTO pesopcb_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","ولی اگر کاهن با پول خود غلامی بخرد، آن غلام می‌تواند از قربانیهای مقدّس بخورد. فرزندان غلام یا کنیزی نیز که در خانهٔ او به دنیا بیایند می‌توانند از آن بخورند. ");
INSERT INTO pesopcb_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","اگر دختر یکی از کاهنان با شخصی که کاهن نیست ازدواج کند، نباید از هدایای مقدّس بخورد؛ ");
INSERT INTO pesopcb_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","ولی اگر بیوه شده یا طلاق گرفته باشد و فرزندی هم نداشته باشد که از او نگهداری کند و به خانهٔ پدرش بازگشته باشد، می‌تواند مانند سابق از خوراک پدرش بخورد. پس کسی که از خانوادهٔ کاهنان نیست، حق ندارد از این خوراک بخورد. ");
INSERT INTO pesopcb_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","«اگر کسی ندانسته از قربانیهای مقدّس بخورد، باید همان مقدار را به اضافۀ یک پنجم به کاهن بازگرداند. ");
INSERT INTO pesopcb_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","کاهنان نباید نسبت به قربانیهای مقدّس که بنی‌اسرائیل به خداوند وقف می‌کنند بی‌حرمتی روا دارند، ");
INSERT INTO pesopcb_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","و با خوردن قربانیهای مقدّس ایشان، سبب شوند که آنها مجرم گردند، زیرا من یهوه هستم که آنها را تقدیس کرده‌ام.» ");
INSERT INTO pesopcb_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","خداوند به موسی فرمود: ");
INSERT INTO pesopcb_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","«این دستورها را به هارون و پسرانش و تمامی قوم اسرائیل بده: اگر یک نفر اسرائیلی یا غریبی که در میان شما ساکن است، به خداوند هدیه‌ای برای قربانی سوختنی تقدیم کند، خواه نذری باشد خواه داوطلبانه، ");
INSERT INTO pesopcb_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","فقط به شرطی مورد قبول خداوند خواهد بود که آن حیوان، گاو یا گوسفند یا بز، نر و بی‌عیب باشد. ");
INSERT INTO pesopcb_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","حیوانی که نقصی داشته باشد نباید تقدیم شود، چون مورد قبول خداوند نمی‌باشد. ");
INSERT INTO pesopcb_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","وقتی کسی از رمه یا گلهٔ خود حیوانی را به عنوان قربانی سلامتی به خداوند تقدیم می‌کند، خواه نذری باشد خواه داوطلبانه، آن حیوان باید سالم و بی‌عیب باشد و گرنه مورد قبول خداوند واقع نمی‌شود. ");
INSERT INTO pesopcb_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","حیوان کور، شل یا مجروح و یا حیوانی که بدنش پر از زخم است و یا مبتلا به گری یا آبله می‌باشد، نباید به خداوند هدیه شود. این نوع هدیه را بر آتش مذبح به خداوند تقدیم نکنید. ");
INSERT INTO pesopcb_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","اگر گاو یا گوسفندی که تقدیم خداوند می‌شود عضوِ بیش از حد بلند یا کوتاه داشته باشد، آن را به عنوان قربانی داوطلبانه می‌توان ذبح کرد ولی نه به عنوان نذر. ");
INSERT INTO pesopcb_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","حیوانی را که بیضه‌اش نقص داشته باشد یعنی کوفته یا بریده باشد هرگز نباید در سرزمین خود برای خداوند قربانی کنید. ");
INSERT INTO pesopcb_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","این محدودیت، هم شامل قربانیهای غریبانی است که در میان شما ساکنند و هم قربانیهای خود شما، چون هیچ حیوان معیوبی برای قربانی پذیرفته نمی‌شود.» ");
INSERT INTO pesopcb_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","خداوند به موسی فرمود: ");
INSERT INTO pesopcb_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","«وقتی گاو یا گوسفند یا بزی زاییده شود باید تا هفت روز پیش مادرش بماند ولی از روز هشتم به بعد می‌توان آن را بر آتش برای خداوند قربانی کرد. ");
INSERT INTO pesopcb_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","گاو یا گوسفند را با نوزادش در یک روز سر نبرید. ");
INSERT INTO pesopcb_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","وقتی که قربانی شکرگزاری به من که خداوند هستم تقدیم می‌کنید، باید طبق قوانین عمل کنید تا مورد قبول من واقع شوید. ");
INSERT INTO pesopcb_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","در همان روز تمام گوشت حیوان قربانی شده را بخورید و چیزی از آن را برای روز بعد باقی نگذارید. من یهوه هستم. ");
INSERT INTO pesopcb_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","«شما باید تمام فرمانهای مرا به جا آورید، چون من یهوه هستم. ");
INSERT INTO pesopcb_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","نام مقدّس مرا بی‌حرمت نکنید، زیرا من در میان بنی‌اسرائیل قدوسیت خود را ظاهر می‌سازم. من یهوه هستم که شما را تقدیس می‌کنم. ");
INSERT INTO pesopcb_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","این من بودم که شما را از سرزمین مصر نجات دادم تا خدای شما باشم. من یهوه هستم.» ");
INSERT INTO pesopcb_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","خداوند به موسی فرمود: ");
INSERT INTO pesopcb_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","«این دستورها را به بنی‌اسرائیل بده. برای برگزاری این اعیاد، تمام قوم باید برای عبادت خداوند جمع شوند. ");
INSERT INTO pesopcb_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","(در روز شَبّات نیز که هفتمین روز هفته می‌باشد، قوم باید برای عبادت خداوند جمع شوند. در هر جا که ساکن باشند باید در این روز دست از کار کشیده، استراحت کنند.) ");
INSERT INTO pesopcb_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","«اعیاد خداوند، یعنی محفلهای مقدّس که باید هر سال جشن گرفته شوند از این قرارند: ");
INSERT INTO pesopcb_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","«در غروب روز چهاردهم اولین ماه هر سال مراسم عید پِسَح را به احترام خداوند بجا آورید. ");
INSERT INTO pesopcb_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","از روز پانزدهم همان ماه، عید فطیر برای خداوند آغاز می‌شود و تا هفت روز باید فقط نان بدون خمیرمایه خورده شود. ");
INSERT INTO pesopcb_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","در روز اول این عید برای عبادت جمع شوید و از همهٔ کارهای معمول خود دست بکشید. ");
INSERT INTO pesopcb_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","هفت روز هدایای سوختنی به خداوند تقدیم نمایید و در روز هفتم نیز از کارهای معمول خود دست کشیده برای عبادت جمع شوید.» ");
INSERT INTO pesopcb_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","خداوند به موسی فرمود: ");
INSERT INTO pesopcb_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","«این دستورها را به بنی‌اسرائیل بده: وقتی به سرزمینی که من به شما می‌دهم داخل شدید و اولین محصول خود را درو کردید، بافه‌ای از نوبر محصول خود را نزد کاهن بیاورید. ");
INSERT INTO pesopcb_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","فردای روز شبّات، کاهن بافه را در حضور خداوند تکان دهد تا خداوند شما را بپذیرد. ");
INSERT INTO pesopcb_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","همان روز یک برهٔ یک سالهٔ سالم و بی‌عیب به عنوان قربانی سوختنی به خداوند تقدیم کنید. ");
INSERT INTO pesopcb_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","برای هدیهٔ آردی آن، دو کیلو آرد مرغوب مخلوط با روغن زیتون آورده، بر آتش به خداوند تقدیم کنید. این هدیه، هدیه‌ای مخصوص و خوشبو برای خداوند خواهد بود. یک لیتر شراب هم به عنوان هدیهٔ نوشیدنی تقدیم نمایید. ");
INSERT INTO pesopcb_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","تا این هدایا را به خدایتان تقدیم نکرده‌اید، نباید نان یا حبوبات تازه یا برشته بخورید. این قانونی است همیشگی برای تمام نسلهای شما در هر جایی که زندگی کنید. ");
INSERT INTO pesopcb_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","«هفت هفته بعد از روزی که اولین بافهٔ خود را به من تقدیم کردید، ");
INSERT INTO pesopcb_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","یعنی در روز پنجاهم که روز بعد از هفتمین شَبّات است هدیهٔ دیگری از محصول تازهٔ خود به حضور خداوند بیاورید. ");
INSERT INTO pesopcb_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","هر خانواده‌ای دو قرص نان که از دو کیلو آرد مرغوب همراه با خمیرمایه پخته شده باشد، بیاورد تا در حضور خداوند تکان داده شود و به عنوان هدیه‌ای از آخرین برداشت محصول به من تقدیم شود. ");
INSERT INTO pesopcb_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","همراه با این نانها، هفت برهٔ یک سالهٔ بی‌عیب، یک گوساله و دو قوچ به عنوان قربانی سوختنی با هدایای آردی و نوشیدنی آنها به خداوند تقدیم کنید. این هدایا، هدایای مخصوص و خوشبو برای خداوند خواهند بود. ");
INSERT INTO pesopcb_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","همچنین یک بز نر به عنوان قربانی گناه و دو برهٔ نر یک ساله به عنوان قربانی سلامتی ذبح کنید. ");
INSERT INTO pesopcb_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","«کاهن، این دو برهٔ ذبح شده را با نانهای پخته شده از آخرین برداشت محصول شما به عنوان هدیهٔ مخصوص در حضور خداوند تکان دهد. این هدایا برای خداوند مقدّسند و باید برای خوراک به کاهنان داده شوند. ");
INSERT INTO pesopcb_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","در آن روز اعلان شود که مردم از کارهای معمول خود دست کشیده، برای عبادت جمع شوند. این قانونی است همیشگی برای نسلهای شما در هر جا که باشید. ");
INSERT INTO pesopcb_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","«وقتی که محصولات خود را درو می‌کنید، گوشه‌های مزرعهٔ خود را تماماً درو نکنید و خوشه‌های بر زمین افتاده را جمع نکنید. آنها را برای فقرا و غریبانی که در میان شما ساکنند، بگذارید. من یهوه، خدای شما هستم.» ");
INSERT INTO pesopcb_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","خداوند به موسی فرمود: ");
INSERT INTO pesopcb_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","«این دستورها را به بنی‌اسرائیل بده: روز اول ماه هفتم هر سال، روز استراحت است و همهٔ قوم اسرائیل باید با شنیدن صدای شیپورها، برای عبادت جمع شوند. ");
INSERT INTO pesopcb_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","در آن روز هدیه‌ای بر آتش به خداوند تقدیم کنید و هیچ کار دیگری انجام ندهید.» ");
INSERT INTO pesopcb_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","خداوند به موسی فرمود: ");
INSERT INTO pesopcb_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","«روز دهم ماه هفتم هر سال، روز کفاره است. در آن روز تمام قوم باید برای عبادت جمع شوند و روزه بگیرند و هدیه‌ای بر آتش به خداوند تقدیم کنند. ");
INSERT INTO pesopcb_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","در روز کفاره کار نکنید، زیرا روزی است که باید برای گناهان خود از یهوه خدایتان طلب آمرزش نمایید. ");
INSERT INTO pesopcb_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","هر شخصی که آن روز را در روزه به سر نبرد، از میان قوم خود منقطع خواهد شد. ");
INSERT INTO pesopcb_vpl VALUES ("LV23_30‏","004_23_30‏","LEV","23","30‏","31","من هر کسی را که در آن روز دست به هرگونه کاری بزند، از میان شما هلاک خواهم ساخت. ");
INSERT INTO pesopcb_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","از غروب روز نهم ماه هفتم تا غروب روز بعد، روز مخصوص کفاره است و باید در آن روز روزه بگیرید و استراحت کنید.» ");
INSERT INTO pesopcb_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","خداوند به موسی فرمود: ");
INSERT INTO pesopcb_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","«این دستورها را به بنی‌اسرائیل بده. روز پانزدهم ماه هفتم، عید سایبانها آغاز می‌شود و باید تا مدت هفت روز در حضور خداوند جشن گرفته شود. ");
INSERT INTO pesopcb_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","در روز اول تمامی قوم اسرائیل را برای عبادت جمع کنید و از کارهای معمول خود دست بکشید. ");
INSERT INTO pesopcb_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","در هر هفت روز عید، هدیه‌ای بر آتش به خداوند تقدیم نمایید. در روز هشتم دوباره تمامی قوم را برای عبادت جمع کنید و هدیه‌ای بر آتش به خداوند تقدیم نمایید. این روز، آخرین روز عید است و نباید هیچ کاری انجام دهید. ");
INSERT INTO pesopcb_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","«(این است اعیاد مقدّسی که در آنها باید تمامی قوم برای عبادت جمع شده، قربانیهای سوختنی، هدایای آردی، هدایای نوشیدنی و سایر قربانیها را بر آتش به خداوند تقدیم کنند. ");
INSERT INTO pesopcb_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","این اعیاد مقدّس غیر از روزهای مخصوص شَبّات است. هدایایی که در این اعیاد تقدیم می‌کنید غیر از هدایای روزانه، نذری و داوطلبانه‌ای است که به خداوند تقدیم می‌کنید.) ");
INSERT INTO pesopcb_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","«از روز پانزدهم ماه هفتم که پایان برداشت محصول است، این عید هفت روزه را در حضور خداوند جشن بگیرید. به یاد داشته باشید که روزهای اول و آخر این عید، روزهای استراحت می‌باشند. ");
INSERT INTO pesopcb_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","در روز اول، از درختان خود میوه‌های خوب بچینید و شاخه‌های نخل و شاخه‌های درختان پربرگ و شاخه‌های بید را گرفته با آنها سایبان درست کنید و هفت روز در حضور یهوه خدایتان شادی کنید. ");
INSERT INTO pesopcb_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","برگزاری این عید هفت روزه در ماه هفتم برای خداوند، فریضه‌ای ابدی است که باید نسل اندر نسل انجام گیرد. ");
INSERT INTO pesopcb_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","در طول آن هفت روز همهٔ شما اسرائیلی‌ها باید در سایبانها به سر برید. ");
INSERT INTO pesopcb_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","هدف از این عید آن است که نسلهای شما بدانند هنگامی که من بنی‌اسرائیل را از مصر بیرون آوردم، آنها را در زیر سایبانها سکونت دادم. من خداوند، خدای شما هستم.» ");
INSERT INTO pesopcb_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","بدین ترتیب موسی قوانین اعیاد خداوند را به اطلاع قوم اسرائیل رسانید. ");
INSERT INTO pesopcb_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","خداوند به موسی فرمود: ");
INSERT INTO pesopcb_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","«به بنی‌اسرائیل دستور بده روغن خالص از زیتون فشرده برای ریختن در چراغدان بیاورند تا چراغها همیشه روشن باشند. ");
INSERT INTO pesopcb_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","هارون چراغدان را بیرونِ پرده صندوق عهد در خیمۀ ملاقات، از غروب تا صبح همیشه در حضور خدا روشن نگاه دارند. این یک قانون جاودانی برای نسلهای شماست. ");
INSERT INTO pesopcb_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","او باید چراغهای چراغدان طلای خالص را همیشه در حضور خداوند روشن نگاه دارد. ");
INSERT INTO pesopcb_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","«آرد مرغوب بردار و از آن دوازده قرص نان بپز؛ برای هر قرص، یک کیلو آرد مصرف کن. ");
INSERT INTO pesopcb_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","آنها را در دو ردیف شش تایی روی میزی که از طلای خالص است و در حضور خداوند قرار دارد بگذار. ");
INSERT INTO pesopcb_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","روی هر ردیف نان، کندر خالص بگذار، تا همراه نان، به عنوان یادگاری و هدیۀ مخصوص به خداوند تقدیم شود. ");
INSERT INTO pesopcb_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","هر روز شبّات، این نان باید در حضور خداوند چیده شود. این نان به عنوان عهدی ابدی باید از بنی‌اسرائیل دریافت شود. ");
INSERT INTO pesopcb_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","نانها به هارون و پسرانش و نسلهای او تعلق دارد و ایشان باید آنها را در جای مقدّسی که برای این منظور در نظر گرفته شده است بخورند، زیرا این هدیه از مقدّسترین هدایایی است که بر آتش به درگاه خداوند تقدیم می‌شود.» ");
INSERT INTO pesopcb_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","روزی در اردوگاه، مرد جوانی که مادرش اسرائیلی و پدرش مصری بود با یکی از مردان اسرائیلی به نزاع پرداخت. ");
INSERT INTO pesopcb_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","هنگام نزاع مردی که پدرش مصری بود به خداوند کفر گفت. پس او را نزد موسی آوردند. (مادر آن مرد، دختر دبری از قبیلهٔ دان بود و شلومیت نام داشت.) ");
INSERT INTO pesopcb_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","او را به زندان انداختند تا هنگامی که معلوم شود خواست خداوند برای او چیست. ");
INSERT INTO pesopcb_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","آنگاه خداوند به موسی فرمود: ");
INSERT INTO pesopcb_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","«کسی را که کفر گفته بیرون اردوگاه ببر و به تمام کسانی که کفر او را شنیدند، بگو که دستهای خود را بر سر او بگذارند. بعد تمام جماعت او را سنگسار کنند. ");
INSERT INTO pesopcb_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","به بنی‌اسرائیل بگو: هر که به خدای خود کفر و ناسزا بگوید باید سزایش را ببیند. ");
INSERT INTO pesopcb_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","هر که نام خداوند را کفر بگوید باید کشته شود؛ تمام جماعت باید او را سنگسار کنند. هر اسرائیلی یا غیراسرائیلی میان شما که به خداوند کفر بگوید، باید کشته شود. ");
INSERT INTO pesopcb_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","«هر که انسانی را بکشد، باید کشته شود. ");
INSERT INTO pesopcb_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","هر کس حیوانی را که مال خودش نیست بکشد، باید عوض دهد: جان در عوض جان. ");
INSERT INTO pesopcb_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","هر که صدمه‌ای به کسی وارد کند، باید به خود او نیز همان صدمه وارد شود: ");
INSERT INTO pesopcb_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","شکستگی به عوض شکستگی، چشم به عوض چشم و دندان به عوض دندان. ");
INSERT INTO pesopcb_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","پس، هر کس حیوانی را بکشد، باید برای آن عوض دهد، اما اگر انسانی را بکشد، باید کشته شود. ");
INSERT INTO pesopcb_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","این قانون هم برای غریبه‌ها و هم برای اسرائیلی‌هاست. من یهوه، خدای شما هستم.» ");
INSERT INTO pesopcb_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","پس آن جوان را که کفر و ناسزا گفته بود بیرون اردوگاه برده، همان‌طور که خداوند به موسی امر فرموده بود، سنگسار کردند. ");
INSERT INTO pesopcb_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","هنگامی که موسی بالای کوه سینا بود، خداوند به او فرمود: ");
INSERT INTO pesopcb_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","«این دستورها را به بنی‌اسرائیل بده: وقتی به سرزمینی که من به شما می‌دهم رسیدید، هر هفت سال یک بار بگذارید زمین در حضور خداوند استراحت کند. ");
INSERT INTO pesopcb_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","شش سال زمینهای زراعتی خود را بکارید، درختان انگورتان را هرس نمایید و محصولات خود را جمع کنید، ");
INSERT INTO pesopcb_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","ولی در طول سال هفتم زمین را وقف خداوند کنید و چیزی در آن نکارید. در تمام طول آن سال بذری نکارید و درختان انگورتان را هرس نکنید. ");
INSERT INTO pesopcb_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","حتی نباتات خودرو را برای خود درو نکنید و انگورها را برای خود نچینید، زیرا آن سال برای زمین، سال استراحت است. ");
INSERT INTO pesopcb_vpl VALUES ("LV25_6‏","004_25_6‏","LEV","25","6‏","7","هر محصولی که در آن سال بروید برای همه می‌باشد، یعنی برای شما، کارگران و بردگان شما، و هر غریبی که در میان شما ساکن است. بگذارید حیوانات اهلی و وحشی نیز از محصول زمین بخورند. ");
INSERT INTO pesopcb_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","«هر پنجاه سال یک بار، ");
INSERT INTO pesopcb_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","در روز کفاره که روز دهم از ماه هفتم است، در سراسر سرزمین‌تان شیپورها را با صدای بلند بنوازید. ");
INSERT INTO pesopcb_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","سال پنجاهم، سال مقدّسی است و باید برای تمام ساکنان سرزمینتان آزادی اعلام شود. در آن سال باید تمام مایملک فامیلی که به دیگران فروخته شده به صاحبان اصلی یا وارثان ایشان پس داده شود و هر کسی که به بردگی فروخته شده نزد خانواده‌اش فرستاده شود. ");
INSERT INTO pesopcb_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","سال پنجاهم، سال یوبیل است. در آن سال نه بذر بکارید، نه محصولاتتان را درو کنید، و نه انگورتان را جمع کنید، ");
INSERT INTO pesopcb_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","زیرا سال یوبیل برای شما سال مقدّسی است. خوراک آن سال شما از محصولات خودرویی باشد که در مزرعه‌ها می‌رویند. ");
INSERT INTO pesopcb_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","آری، در طول سال یوبیل هر کسی باید به ملک اجدادی خود بازگردد. اگر آن را فروخته باشد، دوباره از آن خودش خواهد شد. ");
INSERT INTO pesopcb_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","اگر زمینی به همسایۀ خود می‌فروشید یا زمینی از او می‌خرید، در معامله بی‌انصافی نکنید. ");
INSERT INTO pesopcb_vpl VALUES ("LV25_15‏","004_25_15‏","LEV","25","15‏","16","مبلغی که برای خرید زمین می‌پردازید باید با در نظر گرفتن تعداد سالهایی باشد که از سال یوبیل گذشته است. فروشنده نیز باید بر اساس تعداد سالهایی که تا سال یوبیل بعدی مانده، مبلغش را تعیین کند. ");
INSERT INTO pesopcb_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","از خدای خود بترسید و یکدیگر را فریب ندهید. من یهوه خدای شما هستم. ");
INSERT INTO pesopcb_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","اگر از احکام و قوانین خداوند اطاعت کنید در آن سرزمین، امنیت خواهید داشت ");
INSERT INTO pesopcb_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","و زمین محصول خود را خواهد داد و شما سیر و آسوده‌خاطر خواهید بود. ");
INSERT INTO pesopcb_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","شاید بپرسید: ”پس در سال هفتم که نه اجازه داریم چیزی بکاریم و نه محصولی جمع کنیم، چه بخوریم؟“ ");
INSERT INTO pesopcb_vpl VALUES ("LV25_21‏","004_25_21‏","LEV","25","21‏","22","من محصول سال ششم را به قدری برکت می‌دهم که تا زمان برداشت محصولی که در سال هشتم کاشته‌اید باقی بماند و شما از آن بخورید. ");
INSERT INTO pesopcb_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","«به یاد داشته باشید که زمین مال خداوند است، و نمی‌توانید آن را برای همیشه بفروشید. شما میهمان خداوند هستید و می‌توانید فقط از محصول زمین استفاده کنید. ");
INSERT INTO pesopcb_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","هنگام فروش زمین، باید قید شود که هر وقت فروشنده بخواهد، می‌تواند زمین را بازخرید نماید. ");
INSERT INTO pesopcb_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","اگر کسی تنگدست شد و مقداری از زمین خود را فروخت، آنگاه نزدیکترین خویشاوند او می‌تواند زمین را بازخرید نماید. ");
INSERT INTO pesopcb_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","اما اگر کسی را نداشته باشد که آن را بازخرید کند ولی خود او پس از مدتی به مقدار کافی پول به دست آورد، ");
INSERT INTO pesopcb_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","آنگاه، هر وقت که بخواهد می‌تواند با در نظر گرفتن مقدار محصولی که تا سال پنجاهم از زمین حاصل می‌شود، قیمت آن را بپردازد و زمین را پس بگیرد. ");
INSERT INTO pesopcb_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","ولی اگر صاحب اصلی نتواند آن را بازخرید نماید، زمین تا سال یوبیل از آن مالک جدیدش خواهد بود، ولی در سال یوبیل باید دوباره آن را به صاحبش برگرداند. ");
INSERT INTO pesopcb_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","«اگر مردی خانهٔ خود را که در شهر است بفروشد، تا یک سال فرصت دارد آن را بازخرید نماید. ");
INSERT INTO pesopcb_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","اگر در طی آن سال بازخرید نکرد آنگاه برای همیشه مال صاحب جدیدش خواهد بود و در سال یوبیل به صاحب اصلی‌اش پس داده نخواهد شد. ");
INSERT INTO pesopcb_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","اما خانه‌هایی را که در روستاهای بدون دیوار قرار دارند، می‌توان مثل زمین زراعتی در هر زمان بازخرید نمود و در سال یوبیل باید آنها را به صاحبان اصلی بازگردانید. ");
INSERT INTO pesopcb_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","«اما یک استثنا وجود دارد: خانه‌های لاویان، حتی اگر در شهر نیز باشند، در هر موقع قابل بازخرید خواهند بود ");
INSERT INTO pesopcb_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","و باید در سال پنجاهم به صاحبان اصلی پس داده شوند، چون به لاویان مثل قبیله‌های دیگر زمین زراعتی داده نمی‌شود، بلکه فقط در شهرهای خودشان به ایشان خانه داده می‌شود. ");
INSERT INTO pesopcb_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","لاویان اجازه ندارند مزرعه‌های حومهٔ شهر خود را بفروشند، زیرا اینها ملک ابدی ایشان است. ");
INSERT INTO pesopcb_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","«اگر یکی از هم نژادان اسرائیلی تو فقیر شد، وظیفهٔ توست که به او کمک کنی. پس از او دعوت کن تا به خانهٔ تو بیاید و مثل میهمان با تو زندگی کند. ");
INSERT INTO pesopcb_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","از او هیچ سود نگیر، بلکه از خدای خود بترس و بگذار برادرت با تو زندگی کند. ");
INSERT INTO pesopcb_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","برای پولی که به او قرض می‌دهی سود نگیر و بدون بهره به او خوراک بفروش، ");
INSERT INTO pesopcb_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","زیرا خداوند، خدایتان، شما را از سرزمین مصر بیرون آورد تا سرزمین کنعان را به شما بدهد و خدای شما باشد. ");
INSERT INTO pesopcb_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","«اگر یکی از هم نژادان اسرائیلی تو فقیر شد و خود را به تو فروخت، تو نباید با او مثل برده رفتار کنی، ");
INSERT INTO pesopcb_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","بلکه باید با او مثل کارگر روزمزد یا میهمان رفتار کنی و او فقط تا سال یوبیل برای تو کار کند. ");
INSERT INTO pesopcb_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","در آن سال او باید با پسرانش از پیش تو برود و نزد فامیل و املاک خود بازگردد. ");
INSERT INTO pesopcb_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","شما بندگان خداوند هستید و خداوند شما را از مصر بیرون آورد، پس نباید به بردگی فروخته شوید. ");
INSERT INTO pesopcb_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","با آنها با خشونت رفتار نکن و از خدای خود بترس. ");
INSERT INTO pesopcb_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","اما اجازه دارید بردگانی از اقوامی که در اطراف شما زندگی می‌کنند خریداری کنید ");
INSERT INTO pesopcb_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","و همچنین می‌توانید فرزندان غریبانی را که در میان شما ساکنند بخرید، حتی اگر در سرزمین شما به دنیا آمده باشند. ");
INSERT INTO pesopcb_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","آنان بردگان همیشگی شما خواهند بود و بعد از خودتان می‌توانید ایشان را برای فرزندانتان واگذارید. ولی با برادرانتان از قوم اسرائیل چنین رفتار نکنید. ");
INSERT INTO pesopcb_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","«اگر غریبی که در میان شما ساکن است ثروتمند شود و یک اسرائیلی، فقیر گردد و خود را به آن غریب یا به یکی از افراد خاندان او بفروشد، ");
INSERT INTO pesopcb_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","پس از فروخته شدن، حق بازخرید خواهد داشت. یکی از برادرانش می‌تواند او را بازخرید کند، ");
INSERT INTO pesopcb_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","یا عمو یا پسر عمویش یا یکی از اقوام نزدیکش می‌تواند او را بازخرید نماید. اگر خود او هم پولی به دست آورد، می‌تواند خود را بازخرید نماید. ");
INSERT INTO pesopcb_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","او با بازخریدکننده‌اش باید از سال برده شدنش تا سال یوبیل را حساب کند. بهای آزادی او باید برابر مزد یک کارگر در همان مدت باشد. ");
INSERT INTO pesopcb_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","اگر تا سال یوبیل مدت زیادی باقی مانده باشد، او باید پول بیشتری برای آزادی خود بپردازد ");
INSERT INTO pesopcb_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","و اگر سالهای کمی تا سال یوبیل مانده باشد، پول کمتری. ");
INSERT INTO pesopcb_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","اگر خود را به غریبه‌ای بفروشد آن غریبه باید با او مثل یک کارگر روزمزد رفتار کند؛ نباید با او با خشونت رفتار نماید. ");
INSERT INTO pesopcb_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","اگر پیش از فرا رسیدن سال یوبیل بازخرید نشود، باید در آن سال، خود و فرزندانش آزاد گردند، ");
INSERT INTO pesopcb_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","چون بنی‌اسرائیل به من تعلق دارند و بندگان من هستند، که آنها را از سرزمین مصر بیرون آوردم. من یهوه خدای شما هستم. ");
INSERT INTO pesopcb_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","«برای خود بت نسازید و مجسمه، ستونهای سنگی و سنگهای تراشیده شده برای پرستش بر پا نکنید، زیرا من یهوه، خدای شما هستم. ");
INSERT INTO pesopcb_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","قانون روز شَبّات مرا اطاعت کنید و خیمۀ ملاقات مرا محترم بدارید، زیرا من یهوه هستم. ");
INSERT INTO pesopcb_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","«اگر فرایض و فرامین مرا اطاعت کنید، ");
INSERT INTO pesopcb_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","به موقع برای شما باران خواهم فرستاد و زمین، محصول خود را و درختان، میوهٔ خود را خواهند داد. ");
INSERT INTO pesopcb_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","خرمن شما به قدری زیاد خواهد بود که کوبیدن آن تا هنگام چیدن انگور ادامه خواهد داشت و انگور شما به قدری فراوان خواهد بود که چیدن آن تا فصل کاشتن بذر طول خواهد کشید. خوراک کافی خواهید داشت و در سرزمین خود در امنیت زندگی خواهید کرد، ");
INSERT INTO pesopcb_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","زیرا من به سرزمین شما صلح و آرامش خواهم بخشید و شما با خاطری آسوده به خواب خواهید رفت. حیوانات خطرناک را از سرزمینتان دور خواهم نمود و شمشیر از زمین شما گذر نخواهد کرد. ");
INSERT INTO pesopcb_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","دشمنانتان را تعقیب خواهید کرد و ایشان را با شمشیرهایتان خواهید کشت. ");
INSERT INTO pesopcb_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","پنج نفر از شما صد نفر را تعقیب خواهند کرد و صد نفرتان ده هزار نفر را! تمام دشمنانتان را شکست خواهید داد. ");
INSERT INTO pesopcb_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","شما را مورد لطف خود قرار خواهم داد و شما را کثیر گردانیده، به عهدی که با شما بسته‌ام وفا خواهم کرد. ");
INSERT INTO pesopcb_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","به قدری محصول اضافی خواهید داشت که در وقت به دست آمدن محصول جدید ندانید با آن چه کنید! ");
INSERT INTO pesopcb_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","من در میان شما ساکن خواهم شد و دیگر شما را منقطع نخواهم کرد. ");
INSERT INTO pesopcb_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","در میان شما راه خواهم رفت و خدای شما خواهم بود و شما قوم من خواهید بود. ");
INSERT INTO pesopcb_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","من یهوه، خدای شما هستم که شما را از سرزمین مصر بیرون آوردم تا دیگر برده نباشید. زنجیرهای اسارت شما را پاره کردم و شما را سربلند نمودم. ");
INSERT INTO pesopcb_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","«ولی اگر به من گوش ندهید و مرا اطاعت نکنید، ");
INSERT INTO pesopcb_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","فرایض و قوانین مرا به جا نیاورید و عهدی را که با شما بسته‌ام بشکنید، ");
INSERT INTO pesopcb_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","آنگاه من شما را تنبیه خواهم کرد و وحشت و بیماریهای مهلک و تبی که چشمهایتان را کور کند و عمرتان را تلف نماید بر شما خواهم فرستاد. بذر خود را بیهوده خواهید کاشت، زیرا دشمنانتان حاصل آن را خواهند خورد. ");
INSERT INTO pesopcb_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","من بر ضد شما برخواهم خاست و شما در برابر دشمنان خود پا به فرار خواهید گذاشت. کسانی که از شما نفرت دارند بر شما حکومت خواهند کرد. حتی از سایهٔ خود خواهید ترسید. ");
INSERT INTO pesopcb_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","«اگر باز هم مرا اطاعت نکنید، هفت بار شدیدتر از پیش، شما را به خاطر گناهانتان مجازات خواهم کرد. ");
INSERT INTO pesopcb_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","قدرت شما را که به آن فخر می‌کنید، نابود خواهم کرد. آسمان شما بی‌باران و زمین شما خشک خواهد شد. ");
INSERT INTO pesopcb_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","نیروی خود را از دست خواهید داد، چون زمین شما بی‌حاصل خواهد شد و درختانتان میوهٔ خود را نخواهند داد. ");
INSERT INTO pesopcb_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","«اگر همچنان با من مخالفت کنید و به من گوش ندهید، آنگاه به خاطر گناهانتان هفت مرتبه بیشتر بلا بر سرتان خواهم فرستاد. ");
INSERT INTO pesopcb_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","جانوران وحشی را می‌فرستم تا فرزندانتان را بکشند و حیوانات شما را هلاک کنند. در نتیجه تعداد جمعیت شما کاسته خواهد شد و جاده‌هایتان بدون رهگذر و متروک خواهد گردید. ");
INSERT INTO pesopcb_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","«اگر با وجود این اصلاح نشوید و برخلاف خواست من رفتار کنید، ");
INSERT INTO pesopcb_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","آنگاه من هم برخلاف میل شما رفتار خواهم کرد و شما را به سبب گناهانتان هفت بار بیشتر از پیش تنبیه خواهم نمود. ");
INSERT INTO pesopcb_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","اگر عهد مرا بشکنید، از شما انتقام خواهم گرفت و علیه شما جنگ بر پا خواهم کرد. وقتی از دست دشمن به شهرهایتان بگریزید در آنجا وبا به میان شما خواهم فرستاد، و شما مغلوب دشمنانتان خواهید شد. ");
INSERT INTO pesopcb_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","ذخیرهٔ آرد شما را از بین خواهم برد به طوری که حتی یک تنور هم برای پختن نان ده خانواده زیاد باشد. وقتی سهم نان خود را بخورید، باز هم گرسنه خواهید ماند. ");
INSERT INTO pesopcb_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","«با وجود این اگر باز به من گوش ندهید و اطاعت نکنید، ");
INSERT INTO pesopcb_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","به شدت غضبناک خواهم شد و به سبب گناهانتان هفت مرتبه شدیدتر از پیش شما را تنبیه خواهم کرد، ");
INSERT INTO pesopcb_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","به حدی که از شدت گرسنگی پسران و دختران خود را خواهید خورد. ");
INSERT INTO pesopcb_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","بتخانه‌هایی را که در بالای تپه‌ها ساخته‌اید خراب خواهم کرد، مذبحهایی را که بر آنها بخور می‌سوزانید با خاک یکسان خواهم نمود، جسدهای شما را بر بتهای بی‌جانتان خواهم انداخت و از شما نفرت خواهم داشت. ");
INSERT INTO pesopcb_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","شهرهایتان را ویران و مکانهای عبادتتان را خراب خواهم کرد. قربانی‌هایتان را نخواهم پذیرفت. ");
INSERT INTO pesopcb_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","آری، سرزمین شما را خالی از سکنه خواهم کرد به طوری که دشمنانتان در آنجا ساکن خواهند شد و از بلایی که بر سر شما آورده‌ام، حیران خواهند شد. ");
INSERT INTO pesopcb_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","«بلای جنگ را بر شما خواهم فرستاد تا در میان قومها پراکنده شوید. سرزمین شما خالی و شهرهایتان خراب خواهند شد. ");
INSERT INTO pesopcb_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","سرانجام در تمام سالهایی که شما در سرزمین دشمن در اسارت به سر می‌برید، زمین بایر خواهد ماند و از سالهای شَبّات خود برخوردار خواهد شد و استراحت خواهد کرد. ");
INSERT INTO pesopcb_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","آری، زمین در تمام مدتی که متروک است استراحت خواهد کرد، استراحتی که در شَبّاتهای ایام سکونت شما از آن بی‌بهره بود. ");
INSERT INTO pesopcb_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","«کاری می‌کنم که آن عده از شما هم که به سرزمین دشمن به اسارت رفته‌اید، در آنجا پیوسته در ترس و وحشت به سر برید. از صدای برگ درختی که باد آن را بر روی زمین حرکت می‌دهد پا به فرار خواهید گذاشت. به گمان اینکه دشمن در تعقیب شماست، خواهید گریخت و بر زمین خواهید افتاد. ");
INSERT INTO pesopcb_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","آری، هر چند کسی شما را تعقیب نکند، پا به فرار خواهید گذاشت و در حین فرار روی هم خواهید افتاد، گویی از جنگ می‌گریزید؛ و توان مقابله با دشمن را نخواهید داشت. ");
INSERT INTO pesopcb_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","در میان قومها هلاک خواهید شد و در میان دشمنانتان از پای در خواهید آمد. ");
INSERT INTO pesopcb_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","آنهایی که باقی بمانند در سرزمین دشمن به خاطر گناهان خود و گناهان اجدادشان از بین خواهند رفت. ");
INSERT INTO pesopcb_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","«ولی اگر به تقصیرات خود و تقصیرات پدرانشان اعتراف کنند، یعنی به خیانتی که به من ورزیده و به مخالفت با من برخاسته‌اند ");
INSERT INTO pesopcb_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","و من نیز به مخالفت با ایشان برخاسته و ایشان را به سرزمین دشمنانشان تبعید کرده‌ام؛ پس اگر دل نامختونِ ایشان فروتن شود و تقصیرات خود را بپذیرند، ");
INSERT INTO pesopcb_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","آنگاه دوباره وعده‌های خود را با ابراهیم و اسحاق و یعقوب به یاد خواهم آورد و به یاد سرزمین آنها خواهم افتاد، ");
INSERT INTO pesopcb_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","سرزمینی که متروک مانده، کشت نشده و استراحت یافته است. هر چند ایشان به خاطر رد کردن قوانین من و خوار شمردن فرایض من مجازات خواهند شد، ");
INSERT INTO pesopcb_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","ولی با وجود این من ایشان را در سرزمین دشمنانشان ترک نخواهم کرد و به کلی از بین نخواهم برد و عهد خود را با آنها نخواهم شکست، چون من یهوه، خدای ایشان هستم. ");
INSERT INTO pesopcb_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","من عهدی را که با اجداد ایشان بستم به یاد خواهم آورد، زیرا من اجداد ایشان را پیش چشم تمام قومها از مصر بیرون آوردم تا خدای ایشان باشم. من یهوه هستم.» ");
INSERT INTO pesopcb_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","اینها احکام، قوانین و مقرراتی هستند که خداوند در کوه سینا توسط موسی به قوم اسرائیل داد. ");
INSERT INTO pesopcb_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","خداوند به موسی فرمود: ");
INSERT INTO pesopcb_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","«این دستورها را به قوم بنی‌اسرائیل بده: هرگاه شخصی به موجب نذری به خداوند وقف شود، می‌تواند مبلغ معینی بپردازد و خود را از وقف آزاد سازد. ");
INSERT INTO pesopcb_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","مردی که سنش بین بیست تا شصت سال باشد، پنجاه مثقال نقره برحسب مثقالِ عبادتگاه، بپردازد. ");
INSERT INTO pesopcb_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","زنی که سنش بین بیست تا شصت سال باشد سی مثقال نقره، ");
INSERT INTO pesopcb_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","پسران پنج تا بیست ساله باید بیست مثقال نقره و دختران پنج تا بیست ساله باید ده مثقال نقره بپردازند. ");
INSERT INTO pesopcb_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","برای پسر یک ماهه تا پنج ساله، پنج مثقال نقره و برای دختر یک ماهه تا پنج ساله، سه مثقال نقره پرداخت شود. ");
INSERT INTO pesopcb_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","مرد از شصت سال به بالا باید پانزده مثقال نقره و زن از شصت سال به بالا باید ده مثقال نقره بپردازد. ");
INSERT INTO pesopcb_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","ولی اگر کسی فقیرتر از آن باشد که بتواند این مبلغ را بپردازد، نزد کاهن آورده شود و کاهن مبلغی را تعیین کند که او قادر به پرداخت آن باشد. ");
INSERT INTO pesopcb_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","«اگر نذر او شامل دادن حیوانی است که به عنوان قربانی به خداوند تقدیم می‌شود، چنین هدیه‌ای به خداوند مقدّس خواهد بود. ");
INSERT INTO pesopcb_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","نذرکننده تصمیم خود را در خصوص چیزی که برای خداوند نذر کرده است نباید تغییر دهد و خوب را با بد یا بد را با خوب عوض نکند. اگر چنین کند، اولی و دومی، هر دو از آن خداوند خواهند بود. ");
INSERT INTO pesopcb_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","ولی اگر حیوانی که برای خداوند نذر شده آن نوع حیوانی نیست که برای قربانی مجاز می‌باشد، صاحبش آن را نزد کاهن بیاورد ");
INSERT INTO pesopcb_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","تا قیمتش را تعیین کند و او باید آن مبلغ را هر قدر که باشد، بپردازد. ");
INSERT INTO pesopcb_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","اگر حیوان از نوعی است که می‌توان آن را به عنوان قربانی تقدیم نمود ولی صاحبش می‌خواهد آن را بازخرید نماید، در آن صورت علاوه بر قیمتی که کاهن تعیین می‌کند، باید یک پنجم قیمت آن را نیز اضافه بپردازد. ");
INSERT INTO pesopcb_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","«اگر کسی خانهٔ خود را وقف خداوند کند، کاهن باید قیمت خانه را تعیین کند و نذرکننده، این مبلغ را هر قدر که باشد، بپردازد. ");
INSERT INTO pesopcb_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","اگر وقف کننده بخواهد خانۀ خود را بازخرید کند، باید یک پنجم بر قیمت آن اضافه کند، آنگاه خانه دوباره از آن خودش خواهد بود. ");
INSERT INTO pesopcb_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","«اگر کسی قسمتی از زمین خود را وقف خداوند کند، ارزش آن به تناسب مقدار بذری که در آن می‌توان کاشت تعیین شود. قطعه زمینی که صد کیلو جو در آن پاشیده شود، پنجاه مثقال نقره ارزش دارد. ");
INSERT INTO pesopcb_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","اگر شخصی در سال یوبیل مزرعهٔ خود را وقف خداوند کند، در آن صورت قیمت زمین برابر با قیمت محصول پنجاه سالهٔ آن خواهد بود. ");
INSERT INTO pesopcb_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","ولی اگر بعد از سال یوبیل باشد، آنگاه کاهن قیمت زمین را به تناسب تعداد سالهایی که به سال یوبیل بعدی باقی مانده است، تعیین خواهد کرد. ");
INSERT INTO pesopcb_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","اگر آن شخص تصمیم بگیرد آن مزرعه را بازخرید نماید، بایستی علاوه بر قیمتی که کاهن تعیین می‌نماید یک پنجم هم اضافه بپردازد و مزرعه دوباره مال خودش خواهد شد. ");
INSERT INTO pesopcb_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","ولی اگر مزرعه را بدون اینکه بازخرید نموده باشد، به دیگری بفروشد، دیگر هرگز حق بازخرید آن را نخواهد داشت. ");
INSERT INTO pesopcb_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","وقتی که در سال یوبیل آن مزرعه آزاد شود، به عنوان موقوفه متعلق به خداوند خواهد بود و باید به کاهنان داده شود. ");
INSERT INTO pesopcb_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","«اگر کسی مزرعه‌ای را که خریده است، وقف خداوند کند ولی آن مزرعه قسمتی از ملک خانوادگی او نباشد، ");
INSERT INTO pesopcb_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","کاهن باید ارزش آن را به تناسب مقدار سالهایی که تا سال یوبیل مانده، تعیین کند، و او هم باید همان روز مبلغ تعیین شده را بپردازد. این مبلغ به خداوند تعلق دارد. ");
INSERT INTO pesopcb_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","در سال یوبیل مزرعه به صاحب اصلی آن که از او خریداری شده، باز پس داده شود. ");
INSERT INTO pesopcb_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","تمام قیمت‌گذاری‌ها باید برحسب مثقال عبادتگاه که معادل بیست قیراط است، باشد. ");
INSERT INTO pesopcb_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","«نخست‌زادۀ هر حیوانی، خواه گاو و خواه گوسفند، متعلق به خداوند است، پس کسی نمی‌تواند آن را برای خداوند نذر کند. ");
INSERT INTO pesopcb_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","اما نوزاد حیوان حرام گوشت را که نمی‌توان برای خداوند قربانی کرد، می‌توان با پرداخت قیمتی که کاهن برای آن تعیین می‌کند به اضافهٔ یک پنجم، بازخرید نمود. اگر صاحبش نخواهد آن را بازخرید کند، کاهن می‌تواند آن را به شخص دیگری بفروشد. ");
INSERT INTO pesopcb_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","«اما چیزی که تماماً وقف خداوند شده باشد، چه انسان، چه حیوان و چه مزرعهٔ خانوادگی، هرگز فروخته یا بازخرید نشود چون برای خداوند بسیار مقدّس است. ");
INSERT INTO pesopcb_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","کسی که در دادگاه به مرگ محکوم شده باشد نمی‌تواند جان خود را بازخرید نماید، بلکه باید حتماً کشته شود. ");
INSERT INTO pesopcb_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","«ده‌یک محصول زمین، چه از غله و چه از میوه، از آن خداوند است و مقدّس می‌باشد. ");
INSERT INTO pesopcb_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","اگر کسی بخواهد این میوه یا غله را بازخرید نماید، باید یک پنجم به قیمت اصلی آن اضافه کند. ");
INSERT INTO pesopcb_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","ده‌یک گله و رمه از آن خداوند است. وقتی حیوانات شمرده می‌شوند، هر دهمین حیوان متعلق به خداوند است. ");
INSERT INTO pesopcb_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","صاحب گله نباید حیوانات را طوری قرار دهد که حیوانات بد برای خداوند جدا شوند و نباید جای حیوان خوب را با بد عوض کند. اگر چنین کند، هر دو حیوان متعلق به خداوند خواهند بود و دیگر هرگز حق بازخرید آنها را نخواهد داشت.» ");
INSERT INTO pesopcb_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","این است دستورهایی که خداوند در کوه سینا توسط موسی به قوم اسرائیل داد.");
INSERT INTO pesopcb_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","در روز اولِ ماه دوم از سال دوم، بعد از بیرون آمدن قوم اسرائیل از مصر، زمانی که قوم در بیابان سینا اردو زده بودند، خداوند در خیمهٔ ملاقات به موسی فرمود: ");
INSERT INTO pesopcb_vpl VALUES ("NU1_2‏","005_1_2‏","NUM","1","2‏","15","«تو و هارون به کمک رهبران هر قبیله، قوم اسرائیل را برحسب قبیله و خاندانشان سرشماری کنید و تمام مردان بیست ساله و بالاتر را که قادر به جنگیدن هستند بشمارید.» رهبرانی که از هر قبیله برای این کار تعیین شدند عبارت بودند از: الیصور (پسر شدی‌ئور)، از قبیلهٔ رئوبین؛ شلومی‌ئیل (پسر صوریشدای)، از قبیلهٔ شمعون؛ نحشون (پسر عمیناداب)، از قبیلهٔ یهودا؛ نتنائیل (پسر صوغر)، از قبیلهٔ یساکار؛ الی‌آب (پسر حیلون)، از قبیله زبولون؛ الیشمع (پسر عمیهود)، از قبیلهٔ افرایم، پسر یوسف؛ جملی‌ئیل (پسر فدهصور)، از قبیلهٔ منسی، پسر یوسف؛ ابیدان (پسر جدعونی)، از قبیلهٔ بنیامین؛ اخیعزر (پسر عمیشدای)، از قبیلهٔ دان؛ فجعی‌ئیل (پسر عکران)، از قبیلهٔ اشیر؛ الیاساف (پسر دعوئیل)، از قبیلهٔ جاد؛ اخیرع (پسر عینان)، از قبیلهٔ نفتالی. ");
INSERT INTO pesopcb_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","اینها رهبرانی بودند که از میان قوم اسرائیل برای این کار انتخاب شدند. ");
INSERT INTO pesopcb_vpl VALUES ("NU1_17‏","005_1_17‏","NUM","1","17‏","19","در همان روز موسی و هارون همراه رهبران قبایل، تمام مردان بیست ساله و بالاتر را برای اسم‌نویسی فرا خواندند و همان‌طور که خداوند به موسی امر فرموده بود هر مرد برحسب خاندان و خانواده‌اش اسم‌نویسی شد. ");
INSERT INTO pesopcb_vpl VALUES ("NU1_20‏","005_1_20‏","NUM","1","20‏","46","نتیجهٔ نهایی سرشماری از این قرار است: از قبیلهٔ رئوبین (پسر نخست‌زاده یعقوب) ۴۶٬۵۰۰ نفر، از قبیلهٔ شمعون ۵۹٬۳۰۰ نفر، از قبیلهٔ جاد ۴۵٬۶۵۰ نفر، از قبیلهٔ یهودا ۷۴٬۶۰۰ نفر، از قبیلهٔ یساکار ۵۴٬۴۰۰ نفر، از قبیلهٔ زبولون ۵۷٬۴۰۰ نفر، از قبیلهٔ افرایم (پسر یوسف) ۴۰٬۵۰۰ نفر، از قبیلهٔ منسی (پسر یوسف) ۳۲٬۲۰۰ نفر، از قبیلهٔ بنیامین ۳۵٬۴۰۰ نفر، از قبیلهٔ دان ۶۲٬۷۰۰ نفر، از قبیلهٔ اشیر ۴۱٬۵۰۰ نفر، از قبیلهٔ نفتالی ۵۳٬۴۰۰ نفر، جمع کل ۶۰۳٬۵۵۰ نفر. ");
INSERT INTO pesopcb_vpl VALUES ("NU1_47‏","005_1_47‏","NUM","1","47‏","49","این سرشماری شامل مردان لاوی نمی‌شد، چون خداوند به موسی فرموده بود: «تمام قبیلهٔ لاوی را از خدمت نظام معاف کن و ایشان را در این سرشماری منظور نکن؛ ");
INSERT INTO pesopcb_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","زیرا وظیفهٔ لاویان انجام امور خیمهٔ عبادت، و جابه‌جایی آن است. ایشان باید در اطراف خیمهٔ عبادت زندگی کنند. ");
INSERT INTO pesopcb_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","هنگام جابه‌جایی خیمهٔ عبادت لاویان باید آن را جمع کنند و دوباره آن را بر پا سازند. هر کس دیگری به آن دست بزند کشته خواهد شد. ");
INSERT INTO pesopcb_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","هر یک از قبایل اسرائیل باید دارای اردوگاه جداگانه‌ای بوده، پرچم خاص خود را داشته باشند. ");
INSERT INTO pesopcb_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","لاویان باید گرداگرد خیمهٔ عبادت خیمه زنند تا مبادا کسی به خیمهٔ عبادت نزدیک شده، سبب نازل شدن غضب خداوند بر جماعت بنی‌اسرائیل شود.» ");
INSERT INTO pesopcb_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","پس قوم اسرائیل آنچه را که خداوند به موسی امر فرموده بود، انجام دادند. ");
INSERT INTO pesopcb_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","خداوند به موسی و هارون فرمود: ");
INSERT INTO pesopcb_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","«قبایل بنی‌اسرائیل باید گرداگرد خیمهٔ ملاقات با فاصلهٔ معینی از آن اردو بزنند و هر یک پرچم و نشان ویژهٔ خود را داشته باشند.» ");
INSERT INTO pesopcb_vpl VALUES ("NU2_3‏","005_2_3‏","NUM","2","3‏","31","جایگاه قبیله‌ها به ترتیب زیر بود: قبیله رهبر تعداد یهودا نحشون (پسر عمیناداب) ‎ ۷۴٬۶۰۰ نفر یساکار نتنائیل (پسر صوغر) ‎ ۵۴٬۴۰۰ نفر زبولون الی‌آب (پسر حیلون) ‎ ۵۷٬۴۰۰ نفر بنابراین، تعداد کل افراد ساکن در بخش یهودا که در سمت شرقی اردوگاه قرار داشت، ۱۸۶٬۴۰۰ نفر بود. هرگاه بنی‌اسرائیل به مکان تازه‌ای کوچ می‌کردند، این سه قبیله به ترتیب، پیشاپیش آنها حرکت می‌کردند و راه را نشان می‌دادند. قبیله رهبر تعداد رئوبین الیصور (پسر شدی‌ئور) ‎ ۴۶٬۵۰۰ نفر شمعون شلومی‌ئیل (پسر صوریشدای) ‎ ۵۹٬۳۰۰ نفر جاد الیاساف (پسر دعوئیل) ‎ ۴۵٬۶۵۰ نفر بنابراین، تعداد کل افراد ساکن در بخش رئوبین که در سمت جنوبی اردوگاه قرار داشت، ۱۵۱٬۴۵۰ نفر بود. هر وقت بنی‌اسرائیل کوچ می‌کردند، این سه قبیله به ترتیب در ردیف بعدی قرار می‌گرفتند. پشت سر این دو ردیف، لاویان با خیمهٔ عبادت حرکت می‌کردند. هنگام کوچ، افراد هر قبیله زیر علم خاص خود، دسته جمعی حرکت می‌کردند، به همان ترتیبی که در اردوگاه، هر قبیله از قبیلهٔ دیگر جدا بود. قبیله رهبر تعداد افرایم الیشمع (پسر عمیهود) ‎ ۴۰٬۵۰۰ نفر منسی جملی‌ئیل (پسر فدهصور) ‎ ۳۲٬۲۰۰ نفر بنیامین ابیدان (پسر جدعونی) ‎ ۳۵٬۴۰۰ نفر بنابراین، تعداد کل افراد ساکن در بخش افرایم که در سمت غربی اردوگاه قرار داشت، ۱۰۸٬۱۰۰ نفر بود. موقع کوچ کردن، این سه قبیله به ترتیب در ردیف بعدی قرار داشتند. قبیله رهبر تعداد دان اخیعزر (پسر عمیشدای) ‎ ۶۲٬۷۰۰ نفر اشیر فجعی‌ئیل (پسر عکران) ‎ ۴۱٬۵۰۰ نفر نفتالی اخیرع (پسر عینان) ‎ ۵۳٬۴۰۰ نفر بنابراین تعداد کل افراد ساکن در بخش دان که در سمت شمالی اردوگاه قرار داشت، ۱۵۷٬۶۰۰ نفر بود. هنگام کوچ، این سه قبیله به ترتیب، پس از همه حرکت می‌کردند. ");
INSERT INTO pesopcb_vpl VALUES ("NU2_32‏","005_2_32‏","NUM","2","32‏","33","پس تعداد کل سپاهیان بنی‌اسرائیل، ۶۰۳٬۵۵۰ نفر بود (غیر از لاویان که به دستور خداوند سرشماری نشدند). ");
INSERT INTO pesopcb_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","به این ترتیب قوم اسرائیل طبق دستوری که خداوند به موسی داده بود، عمل کردند؛ آنان با خاندان و خانوادهٔ خود کوچ می‌کردند و زیر پرچم قبیلهٔ خود اردو می‌زدند. ");
INSERT INTO pesopcb_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","این است تاریخچۀ خاندان موسی و هارون در زمانی که خداوند در کوه سینا با موسی سخن گفت: ");
INSERT INTO pesopcb_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","هارون چهار پسر به نامهای ناداب (پسر نخست‌زاده)، ابیهو، العازار و ایتامار داشت. ");
INSERT INTO pesopcb_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","هر چهار نفر ایشان برای خدمت کاهنی انتخاب و تقدیس شدند تا در خیمهٔ عبادت خدمت کنند. ");
INSERT INTO pesopcb_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","ولی ناداب و ابیهو به علّت استفاده از آتش غیر مجاز در حضور خداوند، در صحرای سینا مردند و چون فرزندی نداشتند، فقط العازار و ایتامار باقی ماندند تا پدرشان هارون را در خدمت کاهنی یاری کنند. ");
INSERT INTO pesopcb_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","پس خداوند به موسی فرمود: ");
INSERT INTO pesopcb_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","«قبیلهٔ لاوی را فرا خوان و ایشان را به عنوان دستیاران هارون نزد او حاضر کن. ");
INSERT INTO pesopcb_vpl VALUES ("NU3_7‏","005_3_7‏","NUM","3","7‏","9","ایشان باید از دستورهای او پیروی نموده، به جای تمام قوم اسرائیل خدمات مقدّس خیمهٔ ملاقات را انجام دهند، زیرا ایشان به نمایندگی از طرف بنی‌اسرائیل تعیین شده‌اند تا زیر نظر هارون خدمت کنند. مسئولیت نگهداری خیمهٔ عبادت و تمام اسباب و اثاثیه آن بر عهدهٔ ایشان است. ");
INSERT INTO pesopcb_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","ولی فقط هارون و پسرانش باید وظایف کاهنی را انجام دهند؛ هر کس دیگری که بخواهد نزدیک بیاید باید کشته شود.» ");
INSERT INTO pesopcb_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","خداوند به موسی فرمود: ");
INSERT INTO pesopcb_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","«من لاویان را به جای تمام پسران نخست‌زادۀ قوم اسرائیل پذیرفته‌ام. لاویان از آن من هستند. ");
INSERT INTO pesopcb_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","آنها به جای تمام نخست‌زادگان بنی‌اسرائیل وقف من شده‌اند. از روزی که نخست‌زادگان مصری‌ها را کشتم، نخست‌زادگان بنی‌اسرائیل را، چه انسان و چه حیوان، از آن خود ساختم، پس آنها به من تعلق دارند. من خداوند هستم.» ");
INSERT INTO pesopcb_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","خداوند در صحرای سینا موسی را خطاب کرده فرمود: ");
INSERT INTO pesopcb_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","«قبیلهٔ لاوی را برحسب طایفه و خاندان سرشماری کن. پسران را از یک ماهه به بالا بشمار.» ");
INSERT INTO pesopcb_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","پس موسی طبق فرمان خداوند ایشان را شمرد: ");
INSERT INTO pesopcb_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","لاوی سه پسر داشت با نام های جرشون و قهات و مراری. ");
INSERT INTO pesopcb_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","نامهای پسران جرشون برحسب طایفه‌هایشان لبنی و شمعی بود. ");
INSERT INTO pesopcb_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","نامهای پسران قهات برحسب طایفه‌هایشان عمرام و یِصهار و حبرون و عُزیئیل بود. ");
INSERT INTO pesopcb_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","نامهای پسران مراری برحسب طایفه‌هایشان مَحلی و موشی بود. اینها طایفه‌های لاوی برحسب خاندانهایشان بودند. ");
INSERT INTO pesopcb_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","طایفه‌های جرشون، لبنیان و شمعیان بودند. ");
INSERT INTO pesopcb_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","تعداد همه مردان و پسران از یک ماهه به بالا در طایفه‌های جرشونیان ۷٬۵۰۰ نفر بود. ");
INSERT INTO pesopcb_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","اردوگاهی که برای چادر زدن آنها تعیین شده بود در سوی غربی خیمه عبادت بود. ");
INSERT INTO pesopcb_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","نام رهبر قبیله‌های جرشونی الیاساف پسر لاییل بود. ");
INSERT INTO pesopcb_vpl VALUES ("NU3_25‏","005_3_25‏","NUM","3","25‏","30","وظیفهٔ این دو طایفهٔ لاوی عبارت بود از: مراقبت از خیمهٔ ملاقات، که شامل خیمۀ عبادت و پوششهای آن، پردهٔ مدخل خیمۀ ملاقات، پرده‌های دیوار حیاطی که اطراف خیمه و مذبح است، پردهٔ مدخل حیاط و همهٔ طنابها و همچنین انجام کارهای مربوط به آنها. پسر لاوی : قهات نوادگان لاوی (نامهای طوایف) : عَمرام، یصها، حبرون، عزی‌ئیل تعداد : ‎ ۸٬۶۰۰ نفر رهبر : الیصافان (پسر عُزی‌ئیل) جایگاه اردو : سمت جنوبی خیمهٔ عبادت ");
INSERT INTO pesopcb_vpl VALUES ("NU3_31‏","005_3_31‏","NUM","3","31‏","35","وظیفهٔ این چهار طایفهٔ لاوی عبارت بود از: مراقبت از صندوق عهد خداوند، میز نان حضور، چراغدان، مذبحها، لوازم مختلفی که در خیمهٔ عبادت به کار می‌رفت، پردهٔ بین قدس و قدس‌الاقداس، و انجام کارهای مربوط به آنها. (العازار پسر هارون، رئیس رهبران لاویان بود و بر کار خدمتگزاران قدس نظارت می‌کرد.) پسر لاوی : مراری نوادگان لاوی (نامهای طوایف) : مَحلی، موشی تعداد : ‎ ۶٬۲۰۰ نفر رهبر : صوری‌ئیل (پسر ابیحایل) جایگاه اردو : سمت شمالی خیمهٔ عبادت ");
INSERT INTO pesopcb_vpl VALUES ("NU3_36‏","005_3_36‏","NUM","3","36‏","37","وظیفهٔ این دو طایفه عبارت بود از: مراقبت از چوب‌بست خیمهٔ عبادت، پشت‌بندها، ستونها، پایه‌های ستونها، و تمام لوازم بر پا سازی آن و انجام کارهای مربوط به آنها، و همچنین مواظبت از ستونهای گرداگرد حیاط و پایه‌ها و میخها و طنابها. ");
INSERT INTO pesopcb_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","خیمهٔ موسی و هارون و پسرانش می‌بایست در سمت شرقی خیمهٔ ملاقات، یعنی جلوی آن و رو به آفتاب بر پا شود. ایشان به جای قوم اسرائیل وظیفهٔ مراقبت از خیمهٔ عبادت را بر عهده داشتند. (هر کس که کاهن یا لاوی نبود و وارد خیمهٔ عبادت می‌گردید کشته می‌شد.) ");
INSERT INTO pesopcb_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","پس تعداد همهٔ پسران و مردان لاوی که موسی و هارون طبق دستور خداوند ایشان را شمردند، از یک ماهه به بالا ۲۲ هزار نفر بود. ");
INSERT INTO pesopcb_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","سپس خداوند به موسی فرمود: «حالا تمام پسران نخست‌زاده بنی‌اسرائیل را از یک ماهه به بالا بشمار و نام هر یک از آنها را ثبت کن. ");
INSERT INTO pesopcb_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","لاویان به عوض نخست‌زادگان بنی‌اسرائیل به من که خداوند هستم تعلق دارند، و حیوانات لاویان هم به جای نخست‌زاده‌های حیوانات تمام قوم اسرائیل از آن من هستند.» ");
INSERT INTO pesopcb_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","پس موسی همان‌طور که خداوند به او دستور داده بود، همۀ نخست‌زادگان بنی‌اسرائیل را شمرد ");
INSERT INTO pesopcb_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","و تعداد کل همۀ نخست‌زادگان از یک ماهه به بالا ۲۲٬۲۷۳ نفر بود. ");
INSERT INTO pesopcb_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","خداوند به موسی فرمود: ");
INSERT INTO pesopcb_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","«حال لاویان را به عوض نخست‌زادگان قوم اسرائیل و حیوانات ایشان را به جای نخست‌زاده‌های حیوانات بنی‌اسرائیل به من بده. آری، من خداوند هستم و لاویان از آن من می‌باشند. ");
INSERT INTO pesopcb_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","به منظور بازخرید ۲۷۳ نخست‌زادۀ بنی‌اسرائیل که اضافه بر تعداد لاویان هستند ");
INSERT INTO pesopcb_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","برای هر نفر پنج مثقال نقره برحسب مثقال عبادتگاه که بیست قیراط است، بگیر ");
INSERT INTO pesopcb_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","و آن را به عنوان وجه فدیۀ ایشان برای نخست‌زادگان اضافی، به هارون و پسرانش بده.» ");
INSERT INTO pesopcb_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","پس موسی مبلغ بازخرید ۲۷۳ پسر ارشدی را که اضافه بر تعداد لاویان بودند دریافت کرد. (بقیه پسران ارشد از پرداخت مبلغ بازخرید معاف بودند، چون لاویان به عوض ایشان وقف خداوند شده بودند.) ");
INSERT INTO pesopcb_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","کل مبلغ بازخرید معادل ۱٬۳۶۵ مثقال نقره برحسب مثقال عبادتگاه بود. ");
INSERT INTO pesopcb_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","موسی طبق دستور خداوند، آن را به هارون و پسرانش تحویل داد. ");
INSERT INTO pesopcb_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","سپس خداوند به موسی و هارون فرمود: ");
INSERT INTO pesopcb_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","«نسل قهات را که طایفه‌ای از قبیلهٔ لاوی می‌باشند، بشمار. ");
INSERT INTO pesopcb_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","این سرشماری از تمام مردان سی ساله تا پنجاه ساله که می‌توانند در خیمهٔ ملاقات خدمت کنند به عمل آید. ");
INSERT INTO pesopcb_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","«وظایف نسل قهات در خیمۀ ملاقات در خصوص اسبابِ بسیار مقدّس خواهد بود. ");
INSERT INTO pesopcb_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","وقتی که اردو بخواهد حرکت کند، ابتدا هارون و پسرانش باید به خیمهٔ عبادت داخل شوند و پردهٔ داخلی را پایین آورده، صندوق عهد را با آن بپوشانند. ");
INSERT INTO pesopcb_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","سپس پرده را با پوست بز پوشانیده، یک پارچهٔ آبی رنگ روی پوست بز بکشند و چوبهای حامل صندوق عهد را در حلقه‌های خود قرار دهند. ");
INSERT INTO pesopcb_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","«بعد ایشان باید یک پارچهٔ آبی روی میزی که نان حضور بر آن گذاشته می‌شود کشیده، بشقابها، قاشقها، کاسه‌ها، پیاله‌ها و نان حضور را روی آن پارچه بگذارند. ");
INSERT INTO pesopcb_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","سپس یک پارچهٔ ارغوانی روی آن کشیده، آنگاه پارچهٔ ارغوانی را با پوست بز بپوشانند و چوبهای حامل میز را در حلقه‌ها جای دهند. ");
INSERT INTO pesopcb_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","«پس از آن باید چراغدان، چراغها، انبرها، سینی‌ها و ظرف روغن زیتون را با پارچهٔ آبی رنگ بپوشانند. ");
INSERT INTO pesopcb_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","سپس تمام این اشیاء را در پوست بز پیچیده، بسته را روی یک چهار چوب حامل قرار دهند. ");
INSERT INTO pesopcb_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","«آنگاه یک پارچهٔ آبی روی مذبح طلایی بکشند و آن را با پوست بز پوشانیده، چوبهای حامل را در حلقه‌های مذبح بگذارند. ");
INSERT INTO pesopcb_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","کلیهٔ وسایل باقیماندهٔ خیمهٔ عبادت را در یک پارچهٔ آبی پیچیده، آن را با پوست بز بپوشانند و روی چهار چوب حامل بگذارند. ");
INSERT INTO pesopcb_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","«خاکستر مذبح را باید دور بریزند و خود مذبح را با یک پارچهٔ ارغوانی بپوشانند. ");
INSERT INTO pesopcb_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","تمام وسایل مذبح از قبیل آتشدانها، چنگکها، خاک‌اندازها، کاسه‌ها و ظروف دیگر را باید روی پارچه بگذارند و پوششی از پوست بز روی آنها بکشند. آنگاه چوبهای حامل را در جاهای خود قرار دهند. ");
INSERT INTO pesopcb_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","وقتی که هارون و پسرانش، کار جمع کردن اسباب قدس و کلیهٔ وسایل آن را تمام کردند، نسل قهات آمده، آنها را بردارند و به هر جایی که اردو کوچ می‌کند ببرند. ولی ایشان نباید به این اشیاء مقدّس دست بزنند مبادا بمیرند، پس وظیفهٔ مقدّس پسران قهات، حمل اشیاء خیمهٔ ملاقات است. ");
INSERT INTO pesopcb_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","«العازار پسر هارون، مسئول روغن برای روشنایی، بخور خوشبو، هدیهٔ آردی روزانه و روغن تدهین باشد. در واقع، نظارت بر تمامی خیمهٔ عبادت و هر چه که در آن است به عهدهٔ او خواهد بود.» ");
INSERT INTO pesopcb_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","سپس خداوند به موسی و هارون فرمود: ");
INSERT INTO pesopcb_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","«مواظب باشید طایفۀ قهاتیان از میان لاویان منقطع نشوند. ");
INSERT INTO pesopcb_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","آنچه باید بکنید تا ایشان به هنگام حمل مقدّسترین اشیاء خیمۀ عبادت نمیرند، این است: هارون و پسرانش با ایشان داخل خیمۀ عبادت شده، آنچه را که هر یک از آنان باید حمل کنند به ایشان نشان دهند. ");
INSERT INTO pesopcb_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","در غیر این صورت، ایشان نباید هرگز حتی برای یک لحظه داخل قدس بشوند، مبادا به اشیاء مقدّس آنجا نگاه کرده بمیرند.» ");
INSERT INTO pesopcb_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","خداوند به موسی فرمود: ");
INSERT INTO pesopcb_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","«افراد خاندانها و طایفه‌های جرشون از قبیلۀ لاوی را سرشماری کن. ");
INSERT INTO pesopcb_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","همۀ مردان سی ساله و بالاتر تا پنجاه ساله را که می‌توانند در خیمهٔ ملاقات خدمت کنند، بشمار. ");
INSERT INTO pesopcb_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","وظایف ایشان از این قرار است: ");
INSERT INTO pesopcb_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","«حمل پرده‌های خیمهٔ ملاقات، خود خیمه با پوششهای آن، پوشش پوست بز بالای آن، پردهٔ مدخل خیمه، ");
INSERT INTO pesopcb_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","حمل پرده‌های دیوار حیاط و پردهٔ مدخل حیاطی که در اطراف مذبح و خیمهٔ عبادت است، به اضافهٔ حمل طنابها و تمام لوازم دیگر. ایشان مسئول حمل و نقل این اشیاء هستند. ");
INSERT INTO pesopcb_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","هارون و پسران او، این خدمتها را برای جرشونی‌ها تعیین خواهند نمود. ");
INSERT INTO pesopcb_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","این است خدمت جرشونی‌ها در خیمۀ ملاقات؛ و ایتامار پسر هارون بر کار آنها نظارت خواهد کرد.» ");
INSERT INTO pesopcb_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","«حال افراد طایفه‌ها و خاندانهای مِراری از قبیلۀ لاوی را سرشماری کن. ");
INSERT INTO pesopcb_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","همۀ مردان سی ساله و بالاتر تا پنجاه ساله را که می‌توانند در خیمهٔ ملاقات خدمت کنند، بشمار. ");
INSERT INTO pesopcb_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","هنگام حمل و نقل خیمهٔ ملاقات، ایشان باید چوب‌بست خیمه، پشت‌بندها، ستونها، پایه‌ها، ");
INSERT INTO pesopcb_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","ستونهای اطراف حیاط با پایه‌ها، میخها، طنابها و هر چیز دیگری را که مربوط به استفاده و تعمیر آنها باشد، حمل کنند. «وظیفهٔ هر کس را با ذکر اسم، به او گوشزد نما. ");
INSERT INTO pesopcb_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","مردان مراری نیز باید تحت نظر ایتامار پسر هارون در خیمۀ ملاقات انجام وظیفه کنند.» ");
INSERT INTO pesopcb_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","پس موسی و هارون و رهبران دیگر، طایفهٔ قهات را برحسب طایفه‌ها و خاندانهایشان سرشماری کردند. ");
INSERT INTO pesopcb_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","مردان سی ساله تا پنجاه ساله که می‌توانستند در خیمۀ ملاقات خدمت کنند ");
INSERT INTO pesopcb_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","۲٬۷۵۰ نفر بودند. ");
INSERT INTO pesopcb_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","این بود کل افراد طایفه‌های قهاتی که در خیمۀ ملاقات خدمت می‌کردند. آنها بر اساس دستوری که خداوند به موسی داده بود، به دست موسی و هارون شمارش شدند. ");
INSERT INTO pesopcb_vpl VALUES ("NU4_38‏","005_4_38‏","NUM","4","38‏","40","تعداد مردان طایفهٔ جرشون که می‌توانستند در خیمۀ ملاقات خدمت کنند ۲٬۶۳۰ نفر بود. ");
INSERT INTO pesopcb_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","این سرشماری نیز بر اساس دستوری که خداوند به موسی داده بود، به دست موسی و هارون انجام شد. ");
INSERT INTO pesopcb_vpl VALUES ("NU4_42‏","005_4_42‏","NUM","4","42‏","44","تعداد مردان طایفهٔ مراری که می‌توانستند در خیمۀ ملاقات خدمت کنند ۳٬۲۰۰ نفر بود. ");
INSERT INTO pesopcb_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","این سرشماری نیز بر اساس دستوری که خداوند به موسی داده بود، به دست موسی و هارون انجام شد. ");
INSERT INTO pesopcb_vpl VALUES ("NU4_46‏","005_4_46‏","NUM","4","46‏","48","به این طریق موسی و هارون و رهبران قوم اسرائیل، تمام لاویان سی ساله تا پنجاه ساله را که قادر به خدمت و حمل و نقل خیمهٔ ملاقات بودند، شمردند. جمع کل آنها ۸٬۵۸۰ نفر بود. ");
INSERT INTO pesopcb_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","این سرشماری بر اساس دستوری که خداوند به موسی داده بود، صورت گرفت. ");
INSERT INTO pesopcb_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","خداوند به موسی فرمود: ");
INSERT INTO pesopcb_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","«به بنی‌اسرائیل دستور بده که تمام اشخاص جذامی و همهٔ کسانی را که عضو تناسلی‌شان جریان دائمی دارند و آنانی را که در اثر تماس با جنازه نجس شده‌اند، از اردوگاه بیرون کنند. ");
INSERT INTO pesopcb_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","خواه مرد باشند خواه زن، ایشان را بیرون کنند تا اردوگاه شما که من در آن ساکنم نجس نشود.» ");
INSERT INTO pesopcb_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","قوم اسرائیل طبق دستور خداوند عمل کرده، این اشخاص را بیرون راندند. ");
INSERT INTO pesopcb_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","سپس خداوند به موسی فرمود: ");
INSERT INTO pesopcb_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","«این دستورها را به بنی‌اسرائیل بده: هر کس، چه مرد باشد چه زن، هرگاه به خداوند خیانت کرده، خسارتی به کسی وارد آورد، ");
INSERT INTO pesopcb_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","باید به گناه خود اعتراف نموده، علاوه بر جبران کامل خسارت، یک پنجم خسارت وارده را نیز به شخص خسارت دیده بپردازد. ");
INSERT INTO pesopcb_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","ولی اگر شخصی که خسارت دیده است بمیرد و قوم و خویش نزدیکی نداشته باشد تا به او خسارت پرداخت شود، در آن صورت باید آن را برای خداوند به کاهن بپردازد. درضمن خطاکار باید یک قوچ نیز برای کفاره به کاهن بدهد. ");
INSERT INTO pesopcb_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","تمام هدایای مقدّس که بنی‌اسرائیل برای کاهن می‌آورند، مال کاهن خواهد بود. ");
INSERT INTO pesopcb_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","هر کاهنی می‌تواند تمام هدایای مقدّس را که می‌گیرد، برای خود نگه دارد.» ");
INSERT INTO pesopcb_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","و خداوند به موسی فرمود: ");
INSERT INTO pesopcb_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","«این دستورها را به بنی‌اسرائیل بده: اگر زنِ کسی از او برگشته، به وی خیانت ورزد، ");
INSERT INTO pesopcb_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","و با مردی دیگر همبستر شود، ولی شوهرش یا کسی دیگر از این ماجرا آگاه نشود، آن زن خود را نجس ساخته، هرچند که شاهدی نبوده و او در حین عمل گرفتار نشده باشد. ");
INSERT INTO pesopcb_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","اگر شوهرش غیرتی شده، به زنش شک کند و بخواهد بداند زنش خود را نجس ساخته یا نه، ");
INSERT INTO pesopcb_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","او باید برای روشن شدن حقیقت، زن خود را پیش کاهن بیاورد. در ضمن آن مرد باید یک کیلو آرد جو هم با خود بیاورد، ولی آن را با روغن یا کندر مخلوط نکند، چون این هدیهٔ بدگمانی است و برای تشخیص گناه تقدیم می‌شود. ");
INSERT INTO pesopcb_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","«کاهن، آن زن را به حضور خداوند بیاورد، ");
INSERT INTO pesopcb_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","و قدری آب مقدّس در کوزه‌ای سفالین بریزد و مقداری از غبار کف خیمۀ عبادت را با آن مخلوط کند. ");
INSERT INTO pesopcb_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","سپس زن را در حضور خداوند بر پا داشته، موی بافتهٔ سر او را باز کند و هدیهٔ بدگمانی را در دستهایش بگذارد تا معلوم شود که آیا بدگمانی شوهرش بجاست یا نه. کاهن در حالی که کوزهٔ آب تلخ لعنت را در دست دارد جلوی زن بایستد. ");
INSERT INTO pesopcb_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","آنگاه از آن زن بخواهد قسم بخورد که بی‌گناه است و به او بگوید: ”اگر غیر از شوهرت مرد دیگری با تو همبستر نشده است، و اگر در مدتی که زیر اقتدار شوهرت بوده‌ای، از شوهرت برنگشته‌ای و خود را نجس نساخته‌ای، از اثرات این آب تلخ لعنت مبرا باش. ");
INSERT INTO pesopcb_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","ولی اگر از او برگشته و به او خیانت کرده‌ای و با همبستر شدن با مردی دیگر خود را نجس ساخته‌ای…“ ");
INSERT INTO pesopcb_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","«در اینجا کاهن زن را وادارد تا سوگندِ لعنت بخورد و به زن بگوید: ”لعنت خداوند در میان قومت گریبانگیر تو شود و او رَحِمت را بخشکاند و شکمت را متورم سازد. ");
INSERT INTO pesopcb_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","و این آبِ لعنت به بدن تو داخل شده شکمت را متورم سازد و رَحِمت را بخشکاند.“ و زن باید بگوید: ”آری، اینچنین شود.“ ");
INSERT INTO pesopcb_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","بعد کاهن این لعنتها را در یک طومار بنویسد و آنها را در آب تلخ بشوید. ");
INSERT INTO pesopcb_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","سپس آن آب تلخ را به زن بدهد تا بنوشد. ");
INSERT INTO pesopcb_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","«سپس کاهن هدیهٔ بدگمانی را از دست زن بگیرد و آن را در حضور خداوند تکان داده، روی مذبح بگذارد. ");
INSERT INTO pesopcb_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","مشتی از آن را به عنوان نمونه روی آتش مذبح بسوزاند و بعد، از زن بخواهد آب را بنوشد. ");
INSERT INTO pesopcb_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","اگر او به شوهرش خیانت کرده باشد آب بر او اثر می‌کند و شکمش متورم شده، نازا می‌گردد و در میان قوم اسرائیل مورد لعنت قرار می‌گیرد ");
INSERT INTO pesopcb_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","ولی اگر او پاک بوده و زنا نکرده باشد، به او آسیبی نمی‌رسد و می‌تواند حامله شود. ");
INSERT INTO pesopcb_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","«این است قانون بدگمانی در مورد زنی که شوهرش نسبت به وی بدگمان شده باشد. ");
INSERT INTO pesopcb_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","همان‌طور که گفته شد در چنین موردی شوهر باید زن خود را به حضور خداوند بیاورد تا کاهن طی مراسمی قضیه را روشن سازد که آیا زن به شوهرش خیانت کرده یا نه. ");
INSERT INTO pesopcb_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","اگر زن مقصر شناخته شود، تاوان گناهش را پس خواهد داد، اما شوهرش در این مورد بی‌تقصیر خواهد بود، زیرا خود زن مسئول گناهش است.» ");
INSERT INTO pesopcb_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","خداوند به موسی فرمود: ");
INSERT INTO pesopcb_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","«این دستورها را به بنی‌اسرائیل بده: وقتی که زنی یا مردی به طریق خاص، نذر کرده، خود را وقف خدمت خداوند نماید، ");
INSERT INTO pesopcb_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","باید از مشروبات الکلی یا شراب و یا حتی شراب تازه، آب انگور، انگور یا کشمش اجتناب کند. ");
INSERT INTO pesopcb_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","درضمن در تمام ایام وقف خود، از هرآنچه که از درخت انگور به دست می‌آید، از هسته گرفته تا پوست آن، نخورد. ");
INSERT INTO pesopcb_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","«در تمامی ایام نذرِ وقف شدگی خود، هرگز نباید موی سرش را بتراشد، زیرا او مقدّس و وقف خداوند شده است. پس تا پایان روزهای وقف خود باید بگذارد موی سرش بلند شود. ");
INSERT INTO pesopcb_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","«در طول مدتی که وقف خداوند می‌باشد نباید به مرده‌ای نزدیک شود. ");
INSERT INTO pesopcb_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","حتی اگر جنازهٔ پدر، مادر، برادر یا خواهرش باشد، او نباید خود را نجس سازد، زیرا موی سرش نشان وقف او به خداست. ");
INSERT INTO pesopcb_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","او در تمام آن مدت وقف خداوند می‌باشد. ");
INSERT INTO pesopcb_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","اگر کسی ناگهان در کنار او بمیرد، او نجس می‌شود و باید بعد از هفت روز موی خود را بتراشد تا نجاستش پاک شود. ");
INSERT INTO pesopcb_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","روز هشتم باید دو قمری یا دو جوجه کبوتر پیش کاهن، دم در خیمهٔ ملاقات بیاورد. ");
INSERT INTO pesopcb_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","کاهن یکی از پرنده‌ها را به عنوان قربانی گناه و دیگری را به عنوان قربانی سوختنی تقدیم کرده، جهت نجاست او کفاره کند. در همان روز او باید نذر خود را تجدید نموده، بگذارد دوباره موی سرش بلند شود. ");
INSERT INTO pesopcb_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","روزهای نذرش که پیش از نجاستش سپری شده‌اند دیگر به حساب نیایند. او باید نذر خود را به خداوند از نو آغاز نموده، یک برهٔ نر یک ساله به عنوان قربانی جبران بیاورد. ");
INSERT INTO pesopcb_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","«در پایان دورهٔ نذر خود به خداوند، باید دم در خیمهٔ ملاقات بیاید ");
INSERT INTO pesopcb_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","و یک برهٔ نر یک سالهٔ بی‌عیب جهت قربانی سوختنی برای خداوند بیاورد. همچنین باید یک برهٔ مادهٔ یک سالهٔ بی‌عیب برای قربانی گناه، یک قوچ بی‌عیب به عنوان قربانی سلامتی، ");
INSERT INTO pesopcb_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","یک سبد نان فطیر که از آرد مرغوب مخلوط با روغن زیتون درست شده باشد و قرصهای فطیر روغنی همراه با هدیهٔ آردی و نوشیدنی آن تقدیم کند. ");
INSERT INTO pesopcb_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","کاهن باید این قربانیها و هدایا را از او گرفته، به حضور خداوند تقدیم نماید: قربانی گناه، قربانی سوختنی، ");
INSERT INTO pesopcb_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","و قوچ برای قربانی سلامتی همراه با یک سبد نان فطیر و هدیهٔ آردی و نوشیدنی آن. ");
INSERT INTO pesopcb_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","«پس از آن، شخص وقف شده موی بلند سر خود را که علامت نذر اوست بتراشد. این عمل را دم در خیمهٔ ملاقات انجام داده، موی تراشیده شده را در آتشی که زیر قربانی سلامتی است بیندازد. ");
INSERT INTO pesopcb_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","پس از تراشیده شدن موی سر آن شخص، کاهن سر دست بریان شدهٔ قوچ را با یک نان فطیر و یک قرص فطیر روغنی گرفته، همه را در دست او بگذارد. ");
INSERT INTO pesopcb_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","سپس، کاهن همهٔ آنها را بگیرد و به عنوان هدیهٔ مخصوص در حضور خداوند تکان دهد. تمامی اینها با سینه و ران قوچ که در حضور خداوند تکان داده شده بودند، سهم مقدّس کاهن است. سپس آن شخص می‌تواند دوباره شراب بنوشد، چون از قید نذر خود آزاد شده است. ");
INSERT INTO pesopcb_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","«این مقررات مربوط به کسی است که نذر می‌کند و خود را وقف خداوند می‌نماید و نیز مربوط به قربانیهایی است که باید در پایان دورهٔ نذر خود، تقدیم کند. علاوه بر اینها، او باید قربانیهای دیگری را که در ابتدای وقف کردن خود نذر کرده است تقدیم نماید.» ");
INSERT INTO pesopcb_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","سپس خداوند به موسی فرمود: ");
INSERT INTO pesopcb_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","«به هارون و پسرانش بگو که بنی‌اسرائیل را برکت داده، بگویند: ");
INSERT INTO pesopcb_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","«”خداوند شما را برکت دهد و از شما محافظت فرماید، ");
INSERT INTO pesopcb_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","خداوند روی خود را بر شما تابان سازد و بر شما رحمت فرماید، ");
INSERT INTO pesopcb_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","خداوند لطف خود را به شما نشان دهد و شما را سلامتی بخشد.“ ");
INSERT INTO pesopcb_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","«هارون و پسرانش باید به این طریق برای قوم اسرائیل برکات مرا بطلبند و من ایشان را برکت خواهم داد.» ");
INSERT INTO pesopcb_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","موسی در روزی که بر پا سازی خیمهٔ عبادت را به پایان رسانید تمامی قسمتهای آن و نیز مذبح و لوازم آن را تدهین و تقدیس نمود. ");
INSERT INTO pesopcb_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","آنگاه رهبران اسرائیل، یعنی سران قبایل که ترتیب سرشماری را داده بودند، هدایای خود را آوردند. ");
INSERT INTO pesopcb_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","ایشان شش ارابهٔ سر پوشیده (یک ارابه برای دو رهبر) که هر ارابه را دو گاو می‌کشیدند آورده، در برابر خیمهٔ عبادت به خداوند تقدیم کردند. ");
INSERT INTO pesopcb_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","آنگاه خداوند به موسی فرمود: ");
INSERT INTO pesopcb_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","«هدایای ایشان را قبول کن و از آنها برای کار خیمۀ ملاقات استفاده نما. آنها را به لاویان بده تا هر کس متناسب با خدمتش از آنها استفاده کند.» ");
INSERT INTO pesopcb_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","پس موسی، ارابه‌ها و گاوها را در اختیار لاویان گذاشت. ");
INSERT INTO pesopcb_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","دو ارابه و چهار گاو به طایفهٔ جرشون داد تا برای کار خود از آنها استفاده کنند ");
INSERT INTO pesopcb_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","و چهار ارابه و هشت گاو نیز به طایفهٔ مراری که تحت رهبری ایتامار پسر هارون بودند، داد تا برای کارشان از آنها استفاده کنند. ");
INSERT INTO pesopcb_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","به قهاتیان گاو یا ارابه داده نشد، چون قرار بود ایشان سهم بار خود را از اسباب مقدّس خیمهٔ عبادت، روی دوش حمل کنند. ");
INSERT INTO pesopcb_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","رهبران در روزی که مذبح تدهین شد هدایایی نیز برای تبرک آن تقدیم کردند و آنها را جلوی مذبح گذاشتند. ");
INSERT INTO pesopcb_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","خداوند به موسی فرمود: «هر روز یکی از رهبران، هدیهٔ خود را جهت تبرک مذبح تقدیم کند.» ");
INSERT INTO pesopcb_vpl VALUES ("NU7_12‏","005_7_12‏","NUM","7","12‏","83","پس رهبران، هدایای خود را به ترتیب زیر تقدیم نمودند: روز از قبیله اسم رهبر اول یهودا نحشون پسر عمیناداب دوم یساکار نتنائیل پسر صوغر سوم زبولون الیاب پسر حیلون چهارم رئوبین الیصور پسر شدی‌ئور پنجم شمعون شلومی‌ئیل پسر صوریشدای ششم جاد الیاساف پسر دعوئیل هفتم افرایم الیشمع پسر عمیهود هشتم منسی جملی‌ئیل پسر فدهصور نهم بنیامین ابیدان پسر جدعونی دهم دان اخیعزر پسر عمیشدای یازدهم اشیر فجعی‌ئیل پسر عکران دوازدهم نفتالی اخیرع پسر عینان هدایای تقدیمی هر یک از رهبران که کاملاً مشابه یکدیگر بود عبارت بودند از: یک سینی نقره‌ای به وزن ۱٫۵ کیلوگرم با یک کاسهٔ نقره‌ای به وزن هشتصد گرم (برحسب مثقال عبادتگاه)، که هر دو پر از آرد مرغوب مخلوط با روغن برای هدیهٔ آردی بودند؛ یک ظرف طلایی به وزن ۱۱۰ گرم پر از بخور خوشبو؛ یک گوسالۀ نر، یک قوچ و یک برهٔ نر یک ساله برای قربانی سوختنی؛ یک بز نر برای قربانی گناه؛ دو گاو نر، پنج قوچ، پنج بز نر و پنج برهٔ نر یک ساله برای قربانی سلامتی. ");
INSERT INTO pesopcb_vpl VALUES ("NU7_84‏","005_7_84‏","NUM","7","84‏","88","بنابراین، در روزی که مذبح تدهین شد آن را به‌وسیلۀ هدایایی که سران قبایل اسرائیل آورده بودند تبرک کردند. این هدایا عبارت بودند از: دوازده سینی نقره‌ای هر کدام به وزن تقریبی ۱٫۵ کیلوگرم؛ دوازده کاسهٔ نقره‌ای، هر کدام به وزن تقریبی ۸۰۰ گرم برحسب مثقال عبادتگاه (پس وزن تمام نقرهٔ اهدایی حدود ۲۸ کیلوگرم بود)؛ دوازده ظرف طلایی، هر یک به وزن تقریبی ۱۱۰ گرم که وزن کل آنها حدود ۱٫۳ کیلوگرم بود؛ دوازده گاو نر، دوازده قوچ، دوازده بز نر یک ساله (با هدایای آردی همراه آنها) برای قربانی سوختنی، دوازده بز نر برای قربانی گناه؛ بیست و چهار گاو نر جوان، شصت قوچ، شصت بز نر و شصت برهٔ نر یک ساله برای قربانی سلامتی. ");
INSERT INTO pesopcb_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","وقتی که موسی وارد خیمهٔ ملاقات شد تا با خدا گفتگو کند، از بالای تخت رحمت که روی صندوق عهد قرار داشت یعنی از میان دو کروبی، صدای خدا را که با او سخن می‌گفت شنید. ");
INSERT INTO pesopcb_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","خداوند به موسی فرمود: ");
INSERT INTO pesopcb_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","«به هارون بگو که وقتی چراغها را در چراغدان می‌گذارد طوری باشد که نور هفت چراغ، جلوی چراغدان بتابد.» ");
INSERT INTO pesopcb_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","پس هارون همین کار را کرد. او چراغها را طوری کار گذاشت که نور آنها جلوی چراغدان بتابد، همان‌طور که خداوند به موسی فرمان داده بود. ");
INSERT INTO pesopcb_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","چراغدان از تزیینات پایه گرفته تا شاخه‌هایش تمام از طلا ساخته شده بود. این چراغدان دقیقاً طبق همان طرحی ساخته شده بود که خداوند به موسی نشان داده بود. ");
INSERT INTO pesopcb_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","سپس خداوند به موسی فرمود: ");
INSERT INTO pesopcb_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","«اکنون لاویان را از بقیهٔ قوم اسرائیل جدا کن و آنها را تطهیر نما. ");
INSERT INTO pesopcb_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","این عمل را با پاشیدن آب طهارت بر آنها شروع نموده، سپس به آنان بگو که تمام موی بدن خود را تراشیده، لباسهایشان را بشویند و این‌گونه خود را تطهیر کنند. ");
INSERT INTO pesopcb_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","از ایشان بخواه که یک گوسالۀ نر و هدیهٔ آردی آن را که از آرد مرغوب مخلوط با روغن تهیه شده با یک گوسالۀ نر دیگر برای قربانی گناه بیاورند. ");
INSERT INTO pesopcb_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","بعد در حضور همۀ جماعت اسرائیل، لاویان را به کنار در خیمهٔ ملاقات بیاور. ");
INSERT INTO pesopcb_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","پس لاویان را به حضور خداوند بیاور و بنی‌اسرائیل دستهای خود را روی سر آنها بگذارند، ");
INSERT INTO pesopcb_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","و هارون آنان را به جای تمام قوم اسرائیل به عنوان هدیهٔ مخصوص، وقف خداوند نماید تا لاویان به جای تمامی قوم، خداوند را خدمت کنند. ");
INSERT INTO pesopcb_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","«سپس لاویان دستهای خود را بر سر گاوها بگذارند، و تو یکی را به‌عنوان قربانی گناه و دیگری را به‌عنوان قربانی سوختنی به حضور خداوند تقدیم کن تا برای لاویان کفاره شود. ");
INSERT INTO pesopcb_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","آنگاه لاویان باید به عنوان هدیهٔ مخصوص به خداوند تقدیم شده توسط هارون و پسرانش به خدمت گماشته شوند. ");
INSERT INTO pesopcb_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","به این طریق، لاویان را از میان بقیهٔ قوم اسرائیل جدا کن و ایشان از آن من خواهند بود. ");
INSERT INTO pesopcb_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","پس از آنکه لاویان را به این ترتیب تطهیر و وقف نمودی، ایشان خدمت خود را در خیمهٔ ملاقات آغاز خواهند کرد. ");
INSERT INTO pesopcb_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","«لاویان از میان تمام قوم اسرائیل به من تعلق دارند و من آنها را به جای همهٔ پسران ارشد بنی‌اسرائیل قبول کرده‌ام؛ ");
INSERT INTO pesopcb_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","زیرا همۀ نخست‌زادگان در میان قوم اسرائیل، خواه انسان و خواه حیوان، به من تعلق دارند. همان شبی که نخست‌زادگان مصری‌ها را کشتم اینها را به خود اختصاص دادم. ");
INSERT INTO pesopcb_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","آری، من لاویان را به جای تمام نخست‌زادگان بنی‌اسرائیل پذیرفته‌ام ");
INSERT INTO pesopcb_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","و من لاویان را به هارون و پسرانش هدیه می‌کنم. لاویان باید وظایف مقدّسی را که بر عهدهٔ قوم اسرائیل می‌باشد، در خیمهٔ ملاقات انجام داده، قربانیهای قوم را تقدیم نمایند و برای ایشان کفاره کنند تا وقتی بنی‌اسرائیل به قدس نزدیک می‌شوند بلایی بر سر آنها نیاید.» ");
INSERT INTO pesopcb_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","پس موسی و هارون و قوم اسرائیل با پیروی دقیق از دستورهایی که خداوند به موسی داده بود، لاویان را وقف نمودند. ");
INSERT INTO pesopcb_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","لاویان خود را طاهر ساخته، لباسهایشان را شستند و هارون آنان را به عنوان هدیهٔ مخصوص به خداوند تقدیم نمود. بعد به منظور تطهیر نمودن لاویان برای ایشان مراسم کفاره را بجا آورد. ");
INSERT INTO pesopcb_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","همه چیز درست طبق دستورهایی که خداوند به موسی داده بود، انجام گردید و به این ترتیب لاویان به عنوان دستیاران هارون و پسرانش، آمادهٔ خدمت در خیمهٔ ملاقات شدند. ");
INSERT INTO pesopcb_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","خداوند همچنین به موسی فرمود: ");
INSERT INTO pesopcb_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","«لاویان باید خدمت در خیمۀ ملاقات را از سن بیست و پنج سالگی یا بالاتر شروع کنند ");
INSERT INTO pesopcb_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","و در سن پنجاه سالگی بازنشسته شوند. ");
INSERT INTO pesopcb_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","پس از بازنشستگی می‌توانند در خیمهٔ ملاقات، برادران خود را در انجام وظایفشان یاری دهند، ولی خود، مستقیم مسئولیتی نخواهند داشت. به این ترتیب وظایف لاویان را به ایشان محول کن.» ");
INSERT INTO pesopcb_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","در ماه اول سال دوم پس از بیرون آمدن قوم اسرائیل از سرزمین مصر وقتی که موسی و قوم اسرائیل در صحرای سینا بودند، خداوند به موسی گفت: ");
INSERT INTO pesopcb_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","«به بنی‌اسرائیل بگو که مراسم پِسَح را در موعدش به جا آورند. ");
INSERT INTO pesopcb_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","در غروب روز چهاردهم همین ماه آن را به جا آورند. در اجرای این مراسم باید از تمام فرایض و قوانینی که من در این مورد داده‌ام پیروی کنند.» ");
INSERT INTO pesopcb_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","پس موسی به بنی‌اسرائیل گفت که مراسم عید پِسَح را به جا آورند. ");
INSERT INTO pesopcb_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","آنان عصر روز چهاردهم ماه اول، در صحرای سینا مراسم را آغاز کردند. بنی‌اسرائیل مطابق هر آنچه خداوند به موسی فرمان داده بود، عمل کردند. ");
INSERT INTO pesopcb_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","ولی عده‌ای از مردان در آن روز نتوانستند در مراسم پِسَح شرکت کنند، زیرا در اثر تماس با جنازه نجس شده بودند. ایشان نزد موسی و هارون آمده، مشکل خود را با آنان در میان گذاشتند ");
INSERT INTO pesopcb_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","و به موسی گفتند: «ما با دست زدن به بدن مرده نجس شده‌ایم. اما چرا ما نباید مثل سایر اسرائیلی‌ها در این عید به خداوند قربانی تقدیم کنیم؟» ");
INSERT INTO pesopcb_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","موسی جواب داد: «صبر کنید تا در این باره از خداوند کسب تکلیف کنم.» ");
INSERT INTO pesopcb_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","جواب خداوند از این قرار بود: ");
INSERT INTO pesopcb_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","«اگر فردی از افراد بنی‌اسرائیل، چه در حال حاضر و چه در نسلهای بعد، به هنگام عید پِسَح به سبب تماس با جنازه نجس شود، یا اینکه در سفر بوده، نتواند در مراسم عید حضور یابد، باز می‌تواند عید پِسَح را برای خداوند به جا آورد، ");
INSERT INTO pesopcb_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","ولی بعد از یک ماه، یعنی غروب روز چهاردهم از ماه دوم؛ در آن هنگام می‌تواند برهٔ پِسَح را با نان فطیر و سبزیجات تلخ بخورد. ");
INSERT INTO pesopcb_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","نباید چیزی از آن را تا صبح روز بعد باقی بگذارد و نباید استخوانی از آن را بشکند. او باید کلیه دستورهای مربوط به عید پِسَح را اجرا نماید. ");
INSERT INTO pesopcb_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","«ولی فردی که نجس نبوده و در سفر نیز نباشد و با وجود این از انجام مراسم عید پِسَح در موعد مقرر سر باز زند، باید به علّت خودداری از تقدیم قربانی به خداوند در وقت مقرر، از میان قوم اسرائیل رانده شود. او مسئول گناه خویش خواهد بود. ");
INSERT INTO pesopcb_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","اگر بیگانه‌ای در میان شما ساکن است و می‌خواهد مراسم عید پِسَح را برای خداوند به جا آورد، باید از تمامی این فرایض و قوانین پیروی نماید. این قانون برای همه است.» ");
INSERT INTO pesopcb_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","در آن روزی که خیمهٔ عبادت بر پا شد، ابری ظاهر شده، خیمه را پوشانید و هنگام شب، آن ابر به شکل آتش درآمد و تا صبح به همان صورت باقی ماند. ");
INSERT INTO pesopcb_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","این ابر همیشه خیمه را می‌پوشانید و در شب به شکل آتش در می‌آمد. ");
INSERT INTO pesopcb_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","وقتی که ابر حرکت می‌کرد، قوم اسرائیل کوچ می‌کردند و هر وقت ابر می‌ایستاد، آنها نیز توقف می‌کردند و در آنجا اردو می‌زدند. ");
INSERT INTO pesopcb_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","به این ترتیب، ایشان به دستور خداوند کوچ نموده، در هر جایی که ایشان را راهنمایی می‌کرد، توقف می‌کردند و تا زمانی که ابر ساکن بود در همان مکان می‌ماندند. ");
INSERT INTO pesopcb_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","اگر ابر مدت زیادی می‌ایستاد، آنها هم از دستور خداوند اطاعت کرده، به همان اندازه توقف می‌کردند. ");
INSERT INTO pesopcb_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","ولی اگر ابر فقط چند روزی می‌ایستاد، آنگاه ایشان هم طبق دستور خداوند فقط چند روز می‌ماندند. ");
INSERT INTO pesopcb_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","گاهی ابر آتشین فقط شب می‌ایستاد و صبح روز بعد حرکت می‌کرد؛ ولی، چه شب و چه روز، وقتی که حرکت می‌کرد، قوم اسرائیل نیز به دنبال آن راه می‌افتادند. ");
INSERT INTO pesopcb_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","اگر ابر دو روز، یک ماه، یا یک سال بالای خیمهٔ عبادت می‌ایستاد، بنی‌اسرائیل هم به همان اندازه توقف می‌کردند، ولی به مجردی که به حرکت در می‌آمد قوم هم کوچ می‌کردند، ");
INSERT INTO pesopcb_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","به این ترتیب بود که بنی‌اسرائیل به فرمان خداوند کوچ می‌کردند و اردو می‌زدند. آنها هر آنچه را که خداوند به موسی امر می‌کرد، بجا می‌آوردند. ");
INSERT INTO pesopcb_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","خداوند به موسی فرمود: ");
INSERT INTO pesopcb_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","«دو شیپور از نقره چکش‌کاری شده درست کن و آنها را برای جمع کردن قوم اسرائیل و نیز برای کوچ دادن اردو به کار ببر. ");
INSERT INTO pesopcb_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","هر وقت هر دو شیپور نواخته شوند، قوم بدانند که باید دم مدخل خیمهٔ ملاقات جمع شوند. ");
INSERT INTO pesopcb_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","ولی اگر یک شیپور نواخته شود، آنگاه فقط سران قبایل اسرائیل پیش تو بیایند. ");
INSERT INTO pesopcb_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","«وقتی شیپور کوچ نواخته شود، قبیله‌هایی که در سمت شرقی خیمهٔ عبادت چادر زده‌اند باید حرکت کنند. ");
INSERT INTO pesopcb_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","بار دوم که شیپور نواخته شود، قبیله‌های سمت جنوب راه بیفتند. برای کوچاندن قوم باید شیپور را با صدای تیز نواخت. ");
INSERT INTO pesopcb_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","اما وقتی برای جمع کردن جماعت شیپور را می‌نوازید باید با صدایی دیگر بنوازید. ");
INSERT INTO pesopcb_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","فقط کاهنان نسل هارون مجازند شیپور بنوازند. این یک حکم دائمی است که باید نسل اندر نسل آن را بجا آورند. ");
INSERT INTO pesopcb_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","«وقتی در سرزمین موعود، دشمن به شما حمله کند و شما در دفاع از خود با آنها وارد جنگ شوید، شیپورها را بلند بنوازید تا یهوه خدایتان شما را به یاد آورد و از چنگ دشمنانتان نجات دهد. ");
INSERT INTO pesopcb_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","در روزهای شاد خود نیز این شیپورها را بنوازید، یعنی در موقع برگزاری عیدها و اول هر ماه که قربانیهای سوختنی و قربانیهای سلامتی تقدیم می‌کنید و من شما را به یاد خواهم آورد. من خداوند، خدای شما هستم.» ");
INSERT INTO pesopcb_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","در روز بیستم ماه دوم از سال دوم، بعد از بیرون آمدن بنی‌اسرائیل از مصر، ابر از بالای خیمهٔ عبادت حرکت نمود. ");
INSERT INTO pesopcb_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","پس قوم اسرائیل از صحرای سینا کوچ کرده، به دنبال ابر به راه افتادند تا اینکه ابر در صحرای فاران از حرکت بازایستاد. ");
INSERT INTO pesopcb_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","پس از آنکه موسی دستورهای خداوند را در مورد کوچ قوم دریافت کرد این نخستین سفر ایشان بود. ");
INSERT INTO pesopcb_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","سربازان قبیلهٔ یهودا زیر پرچم بخش خود به رهبری نحشون پسر عمیناداب، پیشاپیش قوم اسرائیل حرکت می‌کردند. ");
INSERT INTO pesopcb_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","پشت سر آنها، سربازان قبیلهٔ یساکار به رهبری نتنائیل پسر صوعَر در حرکت بودند ");
INSERT INTO pesopcb_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","و بعد از آنها سربازان قبیلهٔ زبولون به رهبری الیاب پسر حیلون. ");
INSERT INTO pesopcb_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","مردان بنی‌جرشون و بنی‌مراری از قبیلهٔ لاوی، خیمهٔ عبادت را که جمع شده بود بر دوش گذاشتند و به دنبال قبیلهٔ زبولون به راه افتادند. ");
INSERT INTO pesopcb_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","پشت سر آنها، سربازان قبیلهٔ رئوبین زیر پرچم بخش خود به رهبری الیصور پسر شدیئور حرکت می‌کردند. ");
INSERT INTO pesopcb_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","در صف بعدی، سربازان قبیلهٔ شمعون به رهبری شلومی‌ئیل پسر صوریشدای ");
INSERT INTO pesopcb_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","و پس از آنها، سربازان قبیلهٔ جاد به رهبری الیاساف پسر دعوئیل قرار داشتند. ");
INSERT INTO pesopcb_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","به دنبال آنها بنی‌قهات که اسباب و لوازم قدس را حمل می‌کردند در حرکت بودند. (بر پا سازی خیمهٔ عبادت در جایگاه جدید می‌بایستی پیش از رسیدن قهاتیان انجام می‌شد.) ");
INSERT INTO pesopcb_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","در صف بعدی سربازان قبیلهٔ افرایم بودند که زیر پرچم بخش خود به رهبری الیشمع پسر عمیهود حرکت می‌کردند. ");
INSERT INTO pesopcb_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","قبیلهٔ منسی به رهبری جملی‌ئیل پسر فدهصور ");
INSERT INTO pesopcb_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","و قبیلهٔ بنیامین به رهبری ابیدان پسر جدعونی پشت سر آنها بودند. ");
INSERT INTO pesopcb_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","آخر از همه، سربازان قبایل بخش دان زیر پرچم خود حرکت می‌کردند. سربازان قبیلهٔ دان به رهبری اخیعزر پسر عمیشدای، ");
INSERT INTO pesopcb_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","سربازان قبیلهٔ اشیر به رهبری فجعی‌ئیل پسر عکران، ");
INSERT INTO pesopcb_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","و سربازان قبیلهٔ نفتالی به رهبری اخیرع پسر عینان به ترتیب در حرکت بودند. ");
INSERT INTO pesopcb_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","این بود ترتیب حرکت قبیله‌های اسرائیل با سربازانشان در هنگام کوچ کردن. ");
INSERT INTO pesopcb_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","روزی موسی به برادر زنش حوباب پسر رعوئیل مدیانی گفت: «ما عازم سرزمینی هستیم که خداوند وعدهٔ آن را به ما داده است. تو هم همراه ما بیا و ما در حق تو نیکی خواهیم کرد، زیرا خداوند وعده‌های عالی به قوم اسرائیل داده است.» ");
INSERT INTO pesopcb_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","ولی برادر زنش جواب داد: «نه، من باید به سرزمین خود و نزد خویشانم برگردم.» ");
INSERT INTO pesopcb_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","موسی اصرار نموده، گفت: «پیش ما بمان، چون تو این بیابان را خوب می‌شناسی و راهنمای خوبی برای ما خواهی بود. ");
INSERT INTO pesopcb_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","اگر با ما بیایی، در تمام برکاتی که خداوند به ما می‌دهد شریک خواهی بود.» ");
INSERT INTO pesopcb_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","پس از ترک کوه خداوند، مدت سه روز به سفر ادامه دادند در حالی که صندوق عهد پیشاپیش قبایل اسرائیل در حرکت بود تا مکانی برای توقف آنها انتخاب کند. ");
INSERT INTO pesopcb_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","هنگام روز بود که اردوگاه را ترک کردند و سفر خود را در پی حرکت ابر خداوند آغاز نمودند. ");
INSERT INTO pesopcb_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","هرگاه صندوق عهد به حرکت در می‌آمد موسی ندا سر می‌داد: «برخیز ای خداوند تا دشمنانت پراکنده شوند و خصمانت از حضورت بگریزند.» ");
INSERT INTO pesopcb_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","و هرگاه صندوق عهد متوقف می‌شد، موسی می‌گفت: «ای خداوند نزد هزاران هزار اسرائیلی بازگرد.» ");
INSERT INTO pesopcb_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","قوم اسرائیل به خاطر سختیهای خود لب به شکایت گشودند. خداوند شکایت آنها را شنید و غضبش افروخته شد. پس آتش خداوند از یک گوشهٔ اردو شروع به نابود کردن قوم کرد. ");
INSERT INTO pesopcb_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","ایشان فریاد سر داده، از موسی کمک خواستند و چون موسی برای آنان نزد خداوند دعا کرد، آتش متوقف شد. ");
INSERT INTO pesopcb_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","از آن پس آنجا را «تبعیره» (یعنی «سوختن») نامیدند، چون در آنجا آتش خداوند در میان ایشان شعله‌ور شده بود. ");
INSERT INTO pesopcb_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","آنگاه غریبانی که از مصر همراه ایشان آمده بودند در آرزوی چیزهای خوب مصر اظهار دلتنگی می‌کردند و این خود بر نارضایتی قوم اسرائیل می‌افزود به طوری که ناله‌کنان می‌گفتند: «ای کاش کمی گوشت می‌خوردیم! چه ماهی‌های لذیذی در مصر می‌خوردیم! ");
INSERT INTO pesopcb_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","یادِ آن ماهیها که در مصر مفت می‌خوردیم به خیر! چه خیارها و خربزه‌هایی! چه تره‌ها و سیرها و پیازهایی! ");
INSERT INTO pesopcb_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","ولی حالا قوتی برای ما نمانده است، چون چیزی برای خوردن نداریم جز این مَنّا!» ");
INSERT INTO pesopcb_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","(مَنّا به اندازهٔ تخم گشنیز و به رنگ سفید مایل به زرد بود. ");
INSERT INTO pesopcb_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","بنی‌اسرائیل آن را از روی زمین جمع کرده، می‌کوبیدند و به صورت آرد درمی‌آوردند، سپس، از آن آرد، قرصهای نان می‌پختند. طعم آن مثل طعم نانهای روغنی بود. ");
INSERT INTO pesopcb_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","مَنّا با شبنم شامگاهی بر زمین می‌نشست.) ");
INSERT INTO pesopcb_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","موسی صدای تمام خانواده‌هایی را که در اطراف خیمه‌های خود ایستاده گریه می‌کردند شنید. پس خشم خداوند سخت شعله‌ور گردید و موسی نیز از این امر بسیار ناراحت شد. ");
INSERT INTO pesopcb_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","موسی به خداوند گفت: «چرا با من که خدمتگزارت هستم چنین رفتار می‌کنی و مرا در این تنگنا گذاشته‌ای؟ به من رحم کن! مگر من چه کرده‌ام که بار این قوم را بر دوش من گذاشته‌ای؟ ");
INSERT INTO pesopcb_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","آیا اینها بچه‌های من هستند؟ آیا من آنها را زاییده‌ام که به من می‌گویی آنها را مانند دایه در آغوش گرفته، به سرزمینی که برای اجدادشان قسم خوردی، ببرم؟ ");
INSERT INTO pesopcb_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","برای این همه جمعیت چگونه گوشت تهیه کنم؟ زیرا نزد من گریه کرده، می‌گویند: ”به ما گوشت بده!“ ");
INSERT INTO pesopcb_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","من به تنهایی نمی‌توانم سنگینی بار این قوم را تحمل کنم. این باری است بسیار سنگین! ");
INSERT INTO pesopcb_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","اگر می‌خواهی با من چنین کنی، درخواست می‌کنم مرا بکشی و از این وضع طاقت‌فرسا نجات دهی!» ");
INSERT INTO pesopcb_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","پس خداوند به موسی فرمود: «هفتاد نفر از مردان اسرائیل را که به‌عنوان شیخ و رهبر شناخته شده‌اند به حضور من بخوان. آنها را به خیمهٔ ملاقات بیاور تا در آنجا با تو بایستند. ");
INSERT INTO pesopcb_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","من نزول کرده، در آنجا با تو سخن خواهم گفت و از روحی که بر تو قرار دارد گرفته، بر ایشان نیز خواهم نهاد تا با تو بار این قوم را بر دوش بکشند و تو تنها نباشی. ");
INSERT INTO pesopcb_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","«به بنی‌اسرائیل بگو: ”خود را طاهر سازید، چون فردا گوشت به شما خواهم داد تا بخورید. شما گریه کردید و خداوند ناله‌های شما را شنیده است که گفته‌اید: «ای کاش گوشت برای خوردن می‌داشتیم. وقتی در مصر بودیم وضع ما بهتر بود!» پس خداوند به شما گوشت خواهد داد تا بخورید ");
INSERT INTO pesopcb_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","نه برای یک روز، دو روز، پنج روز، ده روز، بیست روز، ");
INSERT INTO pesopcb_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","بلکه برای یک ماه تمام گوشت خواهید خورد به حدی که از دماغتان درآید و از آن بیزار شوید، زیرا خداوند را که در میان شماست رد نموده، از فراق مصر گریه کردید.“» ");
INSERT INTO pesopcb_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","ولی موسی گفت: «تنها تعداد سربازان پیادهٔ قوم ششصد هزار نفر است و آنگاه تو قول می‌دهی که یک ماه تمام گوشت به این قوم بدهی؟ ");
INSERT INTO pesopcb_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","اگر ما تمام گله‌ها و رمه‌های خود را سر ببریم باز هم کفاف این تعداد را نخواهد داد! و اگر تمام ماهیان دریا را هم بگیریم این قوم را نمی‌توانیم سیر کنیم!» ");
INSERT INTO pesopcb_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","خداوند به موسی فرمود: «آیا من ناتوان شده‌ام؟ به‌زودی خواهی دید که کلام من راست است یا نه.» ");
INSERT INTO pesopcb_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","پس موسی خیمهٔ ملاقات را ترک کرده، سخنان خداوند را به گوش قوم رسانید و هفتاد نفر از مشایخ بنی‌اسرائیل را جمع کرده، ایشان را در اطراف خیمه قرار داد. ");
INSERT INTO pesopcb_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","خداوند در ابر نازل شده، با موسی صحبت کرد و از روحی که بر موسی قرار داشت گرفته، بر آن هفتاد شیخ نهاد. وقتی که روح بر ایشان قرار گرفت نبوّت کردند، اما پس از آن دیگر نبوّت نکردند. ");
INSERT INTO pesopcb_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","دو نفر از آن هفتاد نفر به نامهای الداد و میداد، در اردوگاه مانده و به خیمۀ ملاقات نرفته بودند، ولی روح بر ایشان نیز قرار گرفت و در همان جایی که بودند نبوّت کردند. ");
INSERT INTO pesopcb_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","جوانی دویده، به موسی خبر داد: «اِلداد و میداد در اردوگاه نبوت می‌کنند.» ");
INSERT INTO pesopcb_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","یوشع پسر نون که یکی از دستیاران برگزیدۀ موسی بود اعتراض نموده، گفت: «ای سرور من، جلوی کار آنها را بگیر!» ");
INSERT INTO pesopcb_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","ولی موسی جواب داد: «آیا تو به جای من حسادت می‌کنی؟ ای کاش تمامی قوم خداوند نبی بودند و خداوند روح خود را بر همهٔ آنها می‌نهاد!» ");
INSERT INTO pesopcb_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","بعد موسی با مشایخ اسرائیل به اردوگاه بازگشت. ");
INSERT INTO pesopcb_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","خداوند بادی وزانید که از دریا بلدرچین آورد. بلدرچین‌ها اطراف اردوگاه را از هر طرف به مسافت یک روز راه در ارتفاعی نزدیک به یک متر از سطح زمین پر ساختند. ");
INSERT INTO pesopcb_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","بنی‌اسرائیل تمام آن روز و شب و روز بعد از آن، بلدرچین گرفتند. حداقل وزن پرندگانی که هر کس جمع کرده بود نزدیک به هزار کیلو بود. به منظور خشک کردن بلدرچین‌ها، آنها را در اطراف اردوگاه پهن کردند. ");
INSERT INTO pesopcb_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","اما گوشت هنوز زیر دندانهایشان بود که خشم خداوند بر قوم اسرائیل افروخته شد و بلایی سخت نازل کرده، عدهٔ زیادی از آنان را از بین برد. ");
INSERT INTO pesopcb_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","پس آن مکان را «قبروت هتاوه» (یعنی «قبرستان حرص و ولع») نامیدند، چون در آنجا اشخاصی را دفن کردند که برای گوشت و سرزمین مصر حریص شده بودند. ");
INSERT INTO pesopcb_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","قوم اسرائیل از آنجا به حضیروت کوچ کرده، مدتی در آنجا ماندند. ");
INSERT INTO pesopcb_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","روزی مریم و هارون موسی را به علّت اینکه زن او حبشی بود، سرزنش کردند. ");
INSERT INTO pesopcb_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","آنها گفتند: «آیا خداوند فقط به‌وسیلۀ موسی سخن گفته است؟ مگر او به‌وسیلهٔ ما نیز سخن نگفته است؟» خداوند سخنان آنها را شنید. ");
INSERT INTO pesopcb_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","موسی متواضع‌ترین مرد روی زمین بود. ");
INSERT INTO pesopcb_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","پس خداوند بی‌درنگ موسی و هارون و مریم را به خیمهٔ ملاقات فرا خوانده فرمود: «هر سه نفر شما به اینجا بیایید.» پس ایشان در حضور خداوند ایستادند. ");
INSERT INTO pesopcb_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","آنگاه خداوند در ستون ابر نازل شده، در کنار در خیمۀ عبادت ایستاد و فرمود: «هارون و مریم جلو بیایند» و ایشان جلو رفتند. ");
INSERT INTO pesopcb_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","خداوند به ایشان گفت، «سخنان مرا بشنوید: هرگاه یک نبی در میان شما باشد من که خداوندم، خود را در رویا به او آشکار می‌کنم و در خواب با وی سخن می‌گویم. ");
INSERT INTO pesopcb_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","ولی با موسی که خدمتگزار من است به این طریق سخن نمی‌گویم، چون او قوم مرا با وفاداری خدمت می‌کند. ");
INSERT INTO pesopcb_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","من با وی رو در رو و آشکارا صحبت می‌کنم، نه با رمز، و او تجلی خداوند را می‌بیند. چطور جرأت کردید او را سرزنش کنید؟» ");
INSERT INTO pesopcb_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","پس خشم خداوند بر ایشان افروخته شد و خداوند از نزد ایشان رفت. ");
INSERT INTO pesopcb_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","به محض اینکه ابر از روی خیمهٔ عبادت برخاست، بدن مریم از مرض جذام سفید شد. وقتی هارون این را دید، ");
INSERT INTO pesopcb_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","نزد موسی فریاد برآورد: «ای سرورم، ما را به خاطر این گناه تنبیه نکن، زیرا این گناه ما از نادانی بوده است. ");
INSERT INTO pesopcb_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","نگذار مریم مثل بچهٔ مرده‌ای که موقع تولد، نصف بدنش پوسیده است، شود.» ");
INSERT INTO pesopcb_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","پس موسی نزد خداوند دعا کرده، گفت: «ای خدا، به تو التماس می‌کنم او را شفا دهی.» ");
INSERT INTO pesopcb_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","خداوند به موسی فرمود: «اگر پدرش آب دهان به صورت او انداخته بود آیا تا هفت روز شرمنده نمی‌شد؟ حالا هم باید هفت روز خارج از اردوگاه به تنهایی به سر برد و بعد از آن می‌تواند دوباره بازگردد.» ");
INSERT INTO pesopcb_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","پس مریم مدت هفت روز از اردوگاه اخراج شد و قوم اسرائیل تا بازگشت وی به اردوگاه صبر نموده، پس از آن دوباره کوچ کردند. ");
INSERT INTO pesopcb_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","سپس از حضیروت کوچ کرده، در صحرای فاران اردو زدند. ");
INSERT INTO pesopcb_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","خداوند به موسی فرمود: ");
INSERT INTO pesopcb_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","«افرادی به سرزمین کنعان که می‌خواهم آن را به قوم اسرائیل بدهم بفرست تا آن را بررسی کنند. از هر قبیله یک رهبر بفرست.» ");
INSERT INTO pesopcb_vpl VALUES ("NU13_3‏","005_13_3‏","NUM","13","3‏","15","(در آن موقع بنی‌اسرائیل در صحرای فاران اردو زده بودند.) موسی طبق دستور خداوند عمل کرده، این دوازده رهبر را به سرزمین کنعان فرستاد. شموع پسر زکور، از قبیلهٔ رئوبین؛ شافاط پسر حوری، از قبیلهٔ شمعون؛ کالیب پسر یَفُنَه، از قبیلهٔ یهودا؛ یجال پسر یوسف، از قبیلهٔ یساکار؛ هوشع پسر نون، از قبیلهٔ افرایم؛ فلطی پسر رافو، از قبیلهٔ بنیامین؛ جدیئیل پسر سودی، از قبیلهٔ زبولون؛ جدی پسر سوسی، از قبیلهٔ منسی؛ عمیئیل پسر جملی، از قبیلهٔ دان؛ ستور پسر میکائیل، از قبیلهٔ اشیر؛ نحبی پسر وفسی، از قبیلهٔ نفتالی؛ جاوئیل پسر ماکی، از قبیلهٔ جاد. ");
INSERT INTO pesopcb_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","این بود نامهای کسانی که موسی برای بررسی سرزمین کنعان فرستاد. در همین موقع بود که موسی اسم هوشع را به یوشع تغییر داد. ");
INSERT INTO pesopcb_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","هنگامی که موسی آنها را برای بررسی سرزمین کنعان فرستاد، به ایشان گفت: «از اینجا به سمت شمال بروید و از صحرای نِگِب گذشته، خود را به سرزمین کوهستانی برسانید، ");
INSERT INTO pesopcb_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","و ببینید وضعیت سرزمین موعود چگونه است و مردمی که در آنجا ساکنند، چگونه‌اند قوی هستند یا ضعیف؟ بسیارند یا کم؟ ");
INSERT INTO pesopcb_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","زمینشان حاصلخیز است یا نه؟ شهرهایشان چگونه‌اند، حصار دارند یا بی‌حصارند؟ ");
INSERT INTO pesopcb_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","زمینشان بارور است یا بایر؟ در آنجا درخت زیاد است یا کم؟ هراس به خود راه ندهید و مقداری از محصولات آنجا را به عنوان نمونه با خود بیاورید.» (آن موقع فصل نوبر انگور بود.) ");
INSERT INTO pesopcb_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","پس ایشان رفته، وضع زمین را از بیابان صین تا رحوب نزدیک گذرگاه حمات بررسی کردند. ");
INSERT INTO pesopcb_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","در مسیر خود به سوی شمال، اول از صحرای نگب گذشته، به حبرون رسیدند. در آنجا قبایل اخیمان، شیشای و تلمای را که از نسل عناق بودند دیدند. (حبرون هفت سال قبل از صوعن مصر، بنا شده بود.) ");
INSERT INTO pesopcb_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","سپس به جایی رسیدند که امروزه به درهٔ اشکول معروف است و در آنجا یک خوشه انگور چیدند و با خود آوردند. این خوشهٔ انگور به قدری بزرگ بود که آن را به چوبی آویخته دو نفر آن را حمل می‌کردند! مقداری انار و انجیر نیز برای نمونه با خود آوردند. ");
INSERT INTO pesopcb_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","آن دره به سبب آن خوشهٔ انگوری که چیده شده بود اشکول (یعنی «خوشه») نامیده شد. ");
INSERT INTO pesopcb_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","پس از چهل روز ایشان از مأموریت خود بازگشتند. ");
INSERT INTO pesopcb_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","آنان به موسی، هارون و تمام قوم اسرائیل که در قادش واقع در صحرای فاران بودند، از وضعیت آنجا گزارش داده، میوه‌هایی را هم که با خود آورده بودند به آنها نشان دادند. ");
INSERT INTO pesopcb_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","گزارش ایشان از این قرار بود: «به سرزمینی که ما را جهت بررسی آن فرستادی، رفتیم، سرزمینی است حاصلخیز که شیر و عسل در آن جاری است. این هم میوه‌هایی است که با خود آورده‌ایم. ");
INSERT INTO pesopcb_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","اما ساکنان آنجا خیلی قوی هستند و شهرهایشان حصاردار و بسیار بزرگ است. از این گذشته غولهای عناقی را هم در آنجا دیدیم. ");
INSERT INTO pesopcb_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","عمالیقی‌ها در صحرای نگب، حیتی‌ها و یبوسی‌ها و اموری‌ها در نقاط کوهستانی، و کنعانی‌ها در ساحل دریای مدیترانه و کنارهٔ رود اردن سکونت دارند.» ");
INSERT INTO pesopcb_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","کالیب، بنی‌اسرائیل را که در حضور موسی ایستاده بودند ساکت کرده، گفت: «بیایید بی‌درنگ هجوم ببریم و آنجا را تصرف کنیم، چون می‌توانیم آن را فتح نماییم.» ");
INSERT INTO pesopcb_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","اما همراهان کالیب گفتند: «ما از عهدهٔ این اقوام نیرومند بر نمی‌آییم، چون از ما قویترند.» ");
INSERT INTO pesopcb_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","بنابراین، گزارش آنها منفی و حاکی از آن بود که آن سرزمین آنها را از پای در خواهد آورد. آنها گفتند: «اهالی آنجا قوی هیکل هستند. ");
INSERT INTO pesopcb_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","ما در آنجا مردمانی غول‌پیکر از نسل عناقیم دیدیم. چنان قد بلندی داشتند که ما در برابرشان همچون ملخ بودیم.» ");
INSERT INTO pesopcb_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","با شنیدن این خبر، قوم اسرائیل تمام شب با صدای بلند گریستند. ");
INSERT INTO pesopcb_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","آنها از دست موسی و هارون شکایت کرده، گفتند: «کاش در مصر مرده بودیم، یا در همین بیابان تلف می‌شدیم، ");
INSERT INTO pesopcb_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","زیرا مردن بهتر از این است که به سرزمینی که در پیش داریم برویم! در آنجا خداوند ما را هلاک می‌کند و زنان و بچه‌هایمان اسیر می‌شوند. بیایید به مصر بازگردیم.» ");
INSERT INTO pesopcb_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","پس به یکدیگر گفتند: «بیایید یک رهبر انتخاب کنیم تا ما را به مصر بازگرداند.» ");
INSERT INTO pesopcb_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","موسی و هارون در برابر قوم اسرائیل به خاک افتادند. ");
INSERT INTO pesopcb_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","یوشع پسر نون و کالیب پسر یَفُنّه که جزو کسانی بودند که به بررسی سرزمین کنعان رفته بودند، جامهٔ خود را چاک زدند ");
INSERT INTO pesopcb_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","و به همهٔ قوم خطاب کرده، گفتند: «سرزمینی که بررسی کردیم سرزمین بسیار خوبی است. ");
INSERT INTO pesopcb_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","اگر خداوند از ما راضی است، ما را به سلامت به این سرزمین خواهد رساند و آن را به ما خواهد داد، سرزمینی که به شیر و عسل در آن جاریست. ");
INSERT INTO pesopcb_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","پس بر ضد خداوند قیام نکنید و از مردم آن سرزمین نترسید، چون شکست دادن آنها برای ما مثل آب خوردن است. خداوند با ماست، ولی آنان پشتیبانی ندارند. از آنها نترسید!» ");
INSERT INTO pesopcb_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","ولی کل جماعت می‌گفتند که باید ایشان را سنگسار کرد. آنگاه حضور پرجلال خداوند در خیمهٔ ملاقات بر تمامی بنی‌اسرائیل نمایان گردید ");
INSERT INTO pesopcb_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","و خداوند به موسی فرمود: «تا به کی این قوم مرا اهانت می‌کنند؟ آیا بعد از همهٔ این معجزاتی که در میان آنها کرده‌ام باز به من ایمان نمی‌آورند؟ ");
INSERT INTO pesopcb_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","من ایشان را طرد کرده، با بلایی هلاک می‌کنم و از تو قومی بزرگتر و نیرومندتر به وجود می‌آورم.» ");
INSERT INTO pesopcb_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","موسی به خداوند عرض کرد: «اما وقتی مصری‌ها این را بشنوند چه خواهند گفت؟ آنها خوب می‌دانند که تو با چه قدرت عظیمی قوم خود را نجات دادی. ");
INSERT INTO pesopcb_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","مصری‌ها این موضوع را برای ساکنان این سرزمین تعریف خواهند کرد. آنها شنیده‌اند که تو، ای خداوند، با ما هستی، و ای خداوند، تو رو در رو به قومت آشکار می‌شوی و ابر تو بالای سر ما قرار می‌گیرد و با ستون ابر و آتش، شب و روز ما را هدایت می‌نمایی. ");
INSERT INTO pesopcb_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","حال اگر تمام قوم خود را بکشی، مردمی که شهرت تو را شنیده‌اند خواهند گفت: ");
INSERT INTO pesopcb_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","”خداوند ناچار شد آنها را در بیابان بکشد، چون نتوانست این قوم را به سرزمینی که سوگند خورده بود به آنها بدهد، برساند.“ ");
INSERT INTO pesopcb_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","«حال، ای خداوند، التماس می‌کنم قدرت عظیمت را به ما نشان دهی. زیرا خود فرموده‌ای: ");
INSERT INTO pesopcb_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","”یهوه دیرخشم است و پرمحبت، و آمرزندۀ گناه و عصیان. اما گناه را بدون سزا نمی‌گذارد و به خاطر گناه پدران، فرزندان را تا نسل سوم و چهارم مجازات می‌کند.“ ");
INSERT INTO pesopcb_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","خداوندا، از تو استدعا می‌کنم گناهان این قوم را به خاطر محبت عظیم خود ببخشی همچنانکه از روزی که سرزمین مصر را پشت سر گذاشتیم آنها را مورد عفو خود قرار داده‌ای.» ");
INSERT INTO pesopcb_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","پس خداوند فرمود: «من آنها را چنانکه استدعا کرده‌ای می‌بخشم. ");
INSERT INTO pesopcb_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","ولی به حیات خودم و به حضور پرجلال خداوند که زمین را پر کرده است سوگند که ");
INSERT INTO pesopcb_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","هیچ‌کدام از آنانی که جلال و معجزات مرا در مصر و در بیابان دیده‌اند و بارها از اطاعت کردن از من سر باز زده‌اند ");
INSERT INTO pesopcb_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","حتی موفق به دیدن سرزمینی که به اجدادشان سوگند خورده بودم به آنها بدهم، نخواهند شد. هیچ‌یک از آنها که مرا اهانت کردند سرزمین موعود را نخواهند دید. ");
INSERT INTO pesopcb_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","ولی خدمتگزار من کالیب شخصیت دیگری دارد و پیوسته از صمیم قلب مرا اطاعت کرده است. او را به سرزمینی که برای بررسی آن رفته بود خواهم برد و نسل او مالک آن خواهد شد. ");
INSERT INTO pesopcb_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","پس حال که عمالیقی‌ها و کنعانی‌ها ساکن این دره‌ها هستند، فردا از سمت دریای سرخ به بیابان کوچ کنید.» ");
INSERT INTO pesopcb_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","سپس خداوند به موسی و هارون گفت: ");
INSERT INTO pesopcb_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","«این قوم بدکار و شرور تا به کی از من شکایت می‌کنند؟ من شکایتهای بنی‌اسرائیل را که بر ضد من به عمل آورده‌اند، شنیده‌ام. ");
INSERT INTO pesopcb_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","به ایشان بگو خداوند چنین می‌فرماید: ”به حیات خود قسم که مطابق آنچه از شما شنیدم، انجام خواهم داد. ");
INSERT INTO pesopcb_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","همهٔ شما در این بیابان خواهید مرد، یعنی همۀ شما که سرشماری شده‌اید، از بیست ساله و بالاتر، و از دست من شکایت کرده‌اید. ");
INSERT INTO pesopcb_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","هیچ‌یک از شما وارد سرزمینی که سوگند خوردم به شما بدهم، نخواهید شد. فقط کالیب پسر یَفُنّه و یوشع پسر نون وارد آنجا خواهند شد. ");
INSERT INTO pesopcb_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","شما گفتید که فرزندانتان اسیر ساکنان آن سرزمین می‌شوند؛ ولی برعکس، من آنها را به سلامت به آن سرزمین می‌برم و ایشان مالک سرزمینی خواهند شد که شما آن را رد کردید. ");
INSERT INTO pesopcb_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","اما لاشه‌های شما در این بیابان خواهد افتاد. ");
INSERT INTO pesopcb_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","فرزندانتان به خاطر بی‌ایمانی شما چهل سال در این بیابان سرگردان خواهند بود تا آخرین نفر شما در بیابان بمیرد. ");
INSERT INTO pesopcb_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","همان‌طور که افراد شما مدت چهل روز سرزمین موعود را بررسی کردند، شما نیز مدت چهل سال در بیابان سرگردان خواهید بود، یعنی یک سال برای هر روز، و به این ترتیب چوب گناهان خود را خواهید خورد و خواهید فهمید که مخالفت با من چه سزایی دارد.“ ");
INSERT INTO pesopcb_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","شما ای قوم شرور که بر ضد من جمع شده‌اید در این بیابان خواهید مرد. من که خداوند هستم این را گفته‌ام.» ");
INSERT INTO pesopcb_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","آن مردانی که موسی برای بررسی سرزمین کنعان فرستاده بود و در بازگشت با آوردن اخبار بد، تمامی قوم را به سرکشی علیه خداوند برانگیختند، ");
INSERT INTO pesopcb_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","در حضور خداوند به بلا گرفتار و هلاک شدند. ");
INSERT INTO pesopcb_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","از میان کسانی که به بررسی زمین رفته بودند فقط یوشع و کالیب زنده ماندند. ");
INSERT INTO pesopcb_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","وقتی موسی سخنان خداوند را به گوش قوم اسرائیل رسانید، آنها به تلخی گریستند. ");
INSERT INTO pesopcb_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","آنها روز بعد، صبح زود برخاستند و به بلندیهای کوهستان رفتند. آنها می‌گفتند: «ما می‌دانیم که گناه کرده‌ایم، ولی حالا آماده‌ایم به سوی سرزمینی برویم که خداوند به ما وعده داده است.» ");
INSERT INTO pesopcb_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","موسی گفت: «اما شما با این کارتان از فرمان خداوند در مورد بازگشت به بیابان سرپیچی می‌کنید، پس بدانید که موفق نخواهید شد. ");
INSERT INTO pesopcb_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","نروید، زیرا دشمنانتان شما را شکست خواهند داد، چون خداوند با شما نیست. ");
INSERT INTO pesopcb_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","شما با عمالیقی‌ها و کنعانی‌ها روبرو شده، در جنگ کشته خواهید شد. خداوند با شما نخواهد بود، زیرا شما از پیروی او برگشته‌اید.» ");
INSERT INTO pesopcb_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","ولی آنها به سخنان موسی توجهی نکردند و با اینکه صندوق عهد خداوند و موسی از اردوگاه حرکت نکرده بودند، خودسرانه روانهٔ بلندیهای کوهستان شدند. ");
INSERT INTO pesopcb_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","آنگاه عمالیقی‌ها و کنعانی‌های ساکن کوهستان، پایین آمدند و به قوم اسرائیل حمله کرده، آنان را شکست دادند و تا حرما تعقیب نمودند. ");
INSERT INTO pesopcb_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","خداوند به موسی فرمود: ");
INSERT INTO pesopcb_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","«این دستورها را به قوم اسرائیل بده: وقتی ساکن سرزمینی شدید که من به شما می‌دهم، ");
INSERT INTO pesopcb_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","قربانی‌های مخصوص به خداوند تقدیم خواهید کرد تا هدایای خوشبو برای خداوند باشد. این هدایا می‌توانند به شکل قربانی سوختنی، قربانی نذری، قربانی اختیاری و یا قربانی اعیاد باشند که از میان گلۀ گوسفند و بز یا رمۀ گاو تقدیم می‌شوند. ");
INSERT INTO pesopcb_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","هرگاه این هدایا را به خداوند تقدیم می‌کنید، باید هدیۀ آردی شامل یک دهم ایفه آرد مرغوب مخلوط با یک چهارم هین روغن نیز تقدیم کنید. ");
INSERT INTO pesopcb_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","همچنین همراه قربانی سوختنی یا قربانی مخصوص، برای هر برّه یک چهارم هین شراب نیز به عنوان هدیهٔ نوشیدنی تقدیم شود. ");
INSERT INTO pesopcb_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","«اگر قربانی قوچ باشد، دو دهم ایفه آرد مرغوب، آمیخته با یک سوم هین روغن تقدیم شود، ");
INSERT INTO pesopcb_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","و نیز یک سوم هین شراب به‌عنوان هدیۀ نوشیدنی. این را همچون هدیه‌ای خوشبو به خداوند تقدیم کنید. ");
INSERT INTO pesopcb_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","«هرگاه گوسالۀ نری به عنوان قربانی سوختنی یا قربانی نذری یا قربانی سلامتی به خداوند تقدیم می‌کنید، ");
INSERT INTO pesopcb_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","هدیهٔ آردی همراه آن باید شامل سه دهمِ ایفه آرد مرغوب، آمیخته با نیم هین روغن ");
INSERT INTO pesopcb_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","و هدیهٔ نوشیدنی آن، نیم هین شراب باشد. این هدیه، هدیه‌ای مخصوص و خوشبو برای خداوند خواهد بود. ");
INSERT INTO pesopcb_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","«پس برای قربانی هر گاو، قوچ یا برّه یا بزغاله چنین عمل کنید. ");
INSERT INTO pesopcb_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","برای هر قربانی‌ای که تقدیم می‌کنید، این دستورها باید رعایت شود. ");
INSERT INTO pesopcb_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","هر اسرائیلی بومی که هدیۀ مخصوص به عنوان هدیۀ خوشبو به خداوند تقدیم می‌کند، باید این دستورها را رعایت کند. ");
INSERT INTO pesopcb_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","و اگر میهمان شما یا غریبی که در میان شما ساکن است بخواهد هدیۀ مخصوصی به عنوان هدیۀ خوشبو به خداوند تقدیم کند، باید همین دستورها را رعایت کند. ");
INSERT INTO pesopcb_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","اسرائیلی بومی و شخص غریب در پیشگاه خداوند یکسانند و تابع یک قانونند. این است قانونی ابدی برای همۀ نسلهای شما. ");
INSERT INTO pesopcb_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","برای شما و غریبی که در میان شما ساکن است یک حکم و یک قانون خواهد بود.» ");
INSERT INTO pesopcb_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","خداوند به موسی فرمود: ");
INSERT INTO pesopcb_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","«این دستورها را به قوم اسرائیل بده: «وقتی به سرزمینی که می‌خواهم به شما بدهم وارد شدید، ");
INSERT INTO pesopcb_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","هرگاه از محصول آن زمین بخورید باید قسمتی از آن را به عنوان هدیهٔ مخصوص به خداوند تقدیم کنید. ");
INSERT INTO pesopcb_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","قرص نانی از نخستین گندمی که آرد می‌کنید درست کنید و آن را به‌عنوان هدیه مقدّس تقدیم کنید، همانگونه که در نخستین برداشت خرمن انجام می‌دهید. ");
INSERT INTO pesopcb_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","این هدیه‌ای است سالیانه از نخستین خمیر نان شما که باید نسل اندر نسل به خداوند تقدیم شود. ");
INSERT INTO pesopcb_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","«هرگاه شما ناخواسته در انجام این دستورهایی که خداوند به‌وسیلهٔ موسی به شما داده است کوتاهی کنید، ");
INSERT INTO pesopcb_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","و نسلهای شما در آینده از انجام آنچه خداوند به موسی داده است کوتاهی کنند، ");
INSERT INTO pesopcb_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","اگر این کار، ناخواسته و بدون آگاهی جماعت انجام شده باشد، آنگاه تمامی جماعت باید یک گوسالۀ نر برای قربانی سوختنی به عنوان هدیۀ خوشبو برای خداوند تقدیم کنند. این قربانی باید طبق معمول با هدیهٔ آردی و هدیهٔ نوشیدنی و نیز یک بز نر برای قربانی گناه تقدیم گردد. ");
INSERT INTO pesopcb_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","کاهن برای تمام قوم اسرائیل کفاره نماید و ایشان بخشیده خواهند شد، زیرا ندانسته مرتکب اشتباه شده‌اند و برای این عمل خود، به حضور خداوند قربانی سوختنی و نیز قربانی گناه تقدیم نموده‌اند. ");
INSERT INTO pesopcb_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","تمام بنی‌اسرائیل و غریبانی که در میان ایشان ساکنند، آمرزیده می‌شوند، زیرا این اشتباه متوجه تمام جماعت می‌باشد. ");
INSERT INTO pesopcb_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","«اگر این اشتباه را فقط یک نفر مرتکب شود، در آن صورت باید یک بز مادهٔ یک ساله را به عنوان قربانی گناه تقدیم نماید ");
INSERT INTO pesopcb_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","و کاهن در حضور خداوند برایش کفاره کند و او بخشیده خواهد شد. ");
INSERT INTO pesopcb_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","این قانون شامل حال غریبانی که در میان شما ساکنند نیز می‌شود. ");
INSERT INTO pesopcb_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","«ولی کسی که دانسته مرتکب چنین اشتباهی شود، خواه اسرائیلی باشد، خواه غریب، نسبت به خداوند، گناه کرده است و باید از میان قوم خود منقطع شود، ");
INSERT INTO pesopcb_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","زیرا او کلام خداوند را خوار شمرده و از حکم او سرپیچی کرده است. او بدون شک باید منقطع شود و تقصیرش بر گردنش خواهد بود.» ");
INSERT INTO pesopcb_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","یک روز که قوم اسرائیل در بیابان بودند، مردی به هنگام جمع‌آوری هیزم در روز شبّات، غافلگیر شد. ");
INSERT INTO pesopcb_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","پس او را گرفته، پیش موسی و هارون و سایر رهبران بردند. ");
INSERT INTO pesopcb_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","ایشان او را به زندان انداختند، زیرا روشن نبود که در این مورد چه باید کرد. ");
INSERT INTO pesopcb_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","خداوند به موسی فرمود: «این شخص باید کشته شود. تمام قوم اسرائیل او را در خارج از اردوگاه سنگسار کنند تا بمیرد.» ");
INSERT INTO pesopcb_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","پس او را از اردوگاه بیرون برده، همان‌طور که خداوند امر فرموده بود وی را کشتند. ");
INSERT INTO pesopcb_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","خداوند به موسی فرمود: ");
INSERT INTO pesopcb_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","«به قوم اسرائیل بگو که برای لبۀ لباسهای خود منگوله‌هایی درست کنند. این حکمی است که باید نسل اندر نسل رعایت شود. منگوله‌ها را با نخ آبی به حاشیهٔ لباس خود وصل نمایند. ");
INSERT INTO pesopcb_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","هدف از این قانون آنست که هر وقت منگوله‌ها را ببینید، احکام خداوند را به یاد آورده، آنها را اجرا کنید و به دنبال شهوتهای دل و چشم خود که شما را به هرزگی می‌کشند، نروید. ");
INSERT INTO pesopcb_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","این قانون به شما یادآوری خواهد کرد که همۀ فرمانهای مرا به یاد آورده، آنها را اجرا کنید، و برای خدای خود مقدّس باشید. ");
INSERT INTO pesopcb_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","من یهوه، خدای شما هستم که شما را از مصر بیرون آوردم. من یهوه، خدای شما هستم!» ");
INSERT INTO pesopcb_vpl VALUES ("NU16_1‏","005_16_1‏","NUM","16","1‏","2","یک روز قورح پسر یصهار نوهٔ قهات از قبیلهٔ لاوی، با داتان و ابیرام پسران الیاب و اون پسر فالت که هر سه از قبیلهٔ رئوبین بودند با هم توطئه کردند که علیه موسی شورش کنند. دویست و پنجاه نفر از سران معروف اسرائیل که توسط مردم انتخاب شده بودند در این توطئه شرکت داشتند. ");
INSERT INTO pesopcb_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","ایشان نزد موسی و هارون رفته گفتند: «شما از حد خود تجاوز می‌کنید! شما از هیچ‌کدام از ما بهتر نیستید. همهٔ قوم اسرائیل مقدّسند و خداوند با همگی ما می‌باشد؛ پس چه حقی دارید خود را در رأس قوم خداوند قرار دهید؟» ");
INSERT INTO pesopcb_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","موسی وقتی سخنان ایشان را شنید به خاک افتاد. ");
INSERT INTO pesopcb_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","سپس به قورح و آنانی که با او بودند گفت: «فردا صبح خداوند به شما نشان خواهد داد چه کسی به او تعلق دارد و مقدّس است. خداوند فقط به کسانی که خود برگزیده است اجازه خواهد داد به حضور او وارد شوند. ");
INSERT INTO pesopcb_vpl VALUES ("NU16_6‏","005_16_6‏","NUM","16","6‏","7","ای قورح، تو و تمام کسانی که با تو هستند فردا صبح، آتشدانها گرفته، آتش در آنها بگذارید و در حضور خداوند بخور در آنها بریزید. آنگاه خواهیم دید خداوند چه کسی را انتخاب کرده است. ای پسران لاوی، این شما هستید که از حد خود تجاوز می‌کنید!» ");
INSERT INTO pesopcb_vpl VALUES ("NU16_8‏","005_16_8‏","NUM","16","8‏","9","موسی به قورح و آنانی که با او بودند گفت: «ای لاویان گوش دهید. آیا به نظر شما این امر کوچکی است که خدای اسرائیل شما را از میان تمام قوم اسرائیل برگزیده است تا در خیمهٔ مقدّس خداوند کار کنید و به او نزدیک باشید و برای خدمت به قوم در حضور آنها بایستید؟ ");
INSERT INTO pesopcb_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","آیا این وظیفه را که خداوند فقط به شما لاویان داده است ناچیز می‌دانید که اکنون خواهان مقام کاهنی هم هستید؟ ");
INSERT INTO pesopcb_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","با این کار در واقع بر ضد خداوند قیام کرده‌اید. مگر هارون چه کرده است که از او شکایت می‌کنید؟» ");
INSERT INTO pesopcb_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","بعد موسی به دنبال داتان و ابیرام پسران الیاب فرستاد، ولی آنها نیامدند ");
INSERT INTO pesopcb_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","و در جواب گفتند: «مگر این امر کوچکی است که تو ما را از سرزمین حاصلخیز مصر بیرون آوردی تا در این بیابان بی‌آب و علف از بین ببری و حالا هم خیال داری بر ما حکومت کنی؟ ");
INSERT INTO pesopcb_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","از این گذشته، هنوز که ما را به سرزمین حاصلخیزی که وعده داده بودی نرسانیده‌ای و مزرعه و تاکستانی به ما نداده‌ای. چه کسی را می‌خواهی فریب دهی؟ ما نمی‌خواهیم بیاییم.» ");
INSERT INTO pesopcb_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","پس موسی بسیار خشمناک شده، به خداوند گفت: «قربانیهای ایشان را قبول نکن! من حتی الاغی هم از ایشان نگرفته‌ام و زیانی به یکی از آنها نرسانیده‌ام.» ");
INSERT INTO pesopcb_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","موسی به قورح گفت: «تو و تمامی یارانت فردا صبح به حضور خداوند بیایید، هارون نیز اینجا خواهد بود. ");
INSERT INTO pesopcb_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","فراموش نکنید آتشدانها را با خودتان آورده، بخور بر آنها بگذارید. هر کس یک آتشدان، یعنی جمعاً دویست و پنجاه آتشدان با خودتان بیاورید. هارون هم با آتشدان خود به حضور خداوند بیاید.» ");
INSERT INTO pesopcb_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","آنها همین کار را کردند. همگی آتشدانهای خود را آورده، روشن کردند و بخور بر آنها گذاشتند و با موسی و هارون کنار مدخل خیمهٔ ملاقات ایستادند. ");
INSERT INTO pesopcb_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","در این بین، قورح تمامی قوم اسرائیل را علیه موسی و هارون تحریک کرده بود و همگی آنها نزد در خیمۀ ملاقات جمع شده بودند. آنگاه حضور پرجلال خداوند بر تمام قوم اسرائیل نمایان شد. ");
INSERT INTO pesopcb_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","خداوند به موسی و هارون فرمود: ");
INSERT INTO pesopcb_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","«از کنار این قوم دور شوید تا بی‌درنگ آنها را هلاک کنم.» ");
INSERT INTO pesopcb_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","ولی موسی و هارون رو به خاک نهاده، عرض کردند: «ای خدایی که خدای تمام افراد بشر هستی، آیا به خاطر گناه یک نفر، نسبت به تمامی قوم خشمگین می‌شوی؟» ");
INSERT INTO pesopcb_vpl VALUES ("NU16_23‏","005_16_23‏","NUM","16","23‏","24","خداوند به موسی فرمود: «پس به بنی‌اسرائیل بگو که از کنار خیمه‌های قورح و داتان و ابیرام دور شوند.» ");
INSERT INTO pesopcb_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","پس موسی در حالی که مشایخ اسرائیل او را همراهی می‌کردند به سوی خیمه‌های داتان و ابیرام شتافت. ");
INSERT INTO pesopcb_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","او به قوم اسرائیل گفت: «از اطراف خیمه‌های این مردان بدکار دور شوید و به چیزی که مال آنهاست دست نزنید مبادا شریک گناهان ایشان شده، با ایشان هلاک شوید.» ");
INSERT INTO pesopcb_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","پس قوم اسرائیل از اطراف خیمه‌های قورح و داتان و ابیرام دور شدند. داتان و ابیرام با زنان و پسران و اطفال خود از خیمه‌هایشان بیرون آمده، دم در ایستادند. ");
INSERT INTO pesopcb_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","موسی گفت: «حال خواهید دانست که خداوند مرا فرستاده است تا تمامی این کارها را انجام بدهم و اینکه به ارادهٔ خودم کاری نکرده‌ام. ");
INSERT INTO pesopcb_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","اگر این مردان به مرگ طبیعی یا در اثر تصادف یا بیماری بمیرند، پس خداوند مرا نفرستاده است. ");
INSERT INTO pesopcb_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","اما اگر خداوند معجزه‌ای نموده، زمین باز شود و ایشان را با هر چه که دارند ببلعد و زنده به گور شوند، آنگاه بدانید که این مردان به خداوند اهانت کرده‌اند.» ");
INSERT INTO pesopcb_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","به محض اینکه سخنان موسی تمام شد، ناگهان زمین زیر پای قورح و داتان و ابیرام دهان گشود ");
INSERT INTO pesopcb_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","و آنها را با خانواده‌ها و همدستانی که با آنها ایستاده بودند، همراه با دار و ندارشان، فرو برد. ");
INSERT INTO pesopcb_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","پس به این ترتیب، زمین بر ایشان به هم آمد و ایشان زنده به گور شدند و از بین رفتند. ");
INSERT INTO pesopcb_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","اسرائیلی‌هایی که نزدیک آنها ایستاده بودند از فریاد آنها پا به فرار گذاشتند، چون ترسیدند زمین، ایشان را هم به کام خود فرو برد. ");
INSERT INTO pesopcb_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","سپس آتشی از جانب خداوند فرود آمد و آن دویست و پنجاه نفری را که بخور تقدیم می‌کردند، سوزانید. ");
INSERT INTO pesopcb_vpl VALUES ("NU16_36‏","005_16_36‏","NUM","16","36‏","38","خداوند به موسی فرمود: «به العازار پسر هارون کاهن بگو که آن آتشدانها را از داخل آتش بیرون آورد، چون آنها وقف خداوند شده، مقدّس می‌باشند. او باید خاکستر آتشدانهای این مردانی را که به قیمت جان خود گناه کردند دور بریزد. بعد آتشدانها را در هم کوبیده، از آن ورقه‌ای برای پوشش مذبح درست کند، زیرا این آتشدانها مقدّسند. این پوشش مذبح برای قوم اسرائیل، خاطرهٔ عبرت‌انگیزی خواهد بود.» ");
INSERT INTO pesopcb_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","پس العازار کاهن، آن آتشدانهای مفرغین را گرفته، در هم کوبید و از آن ورقه‌ای فلزی برای پوشش مذبح ساخت، ");
INSERT INTO pesopcb_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","تا برای قوم اسرائیل عبرتی باشد که هیچ‌کس، غیر از نسل هارون، جرأت نکند در حضور خداوند بخور بسوزاند، مبادا همان بلایی بر سرش آید که بر سر قورح و طرفدارانش آمد. بدین ترتیب آنچه خداوند به موسی فرموده بود، عملی گردید. ");
INSERT INTO pesopcb_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","اما فردای همان روز، بنی‌اسرائیل دوباره علیه موسی و هارون زبان به شکایت گشودند و گفتند: «شما قوم خداوند را کشته‌اید!» ");
INSERT INTO pesopcb_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","ولی وقتی آنها دور موسی و هارون را گرفته بودند ناگهان ابر، خیمۀ ملاقات را پوشاند و حضور پرجلال خداوند نمایان شد. ");
INSERT INTO pesopcb_vpl VALUES ("NU16_43‏","005_16_43‏","NUM","16","43‏","44","موسی و هارون آمدند و کنار در خیمهٔ ملاقات ایستادند و خداوند به موسی فرمود: ");
INSERT INTO pesopcb_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","«از کنار این قوم دور شوید تا بی‌درنگ آنها را هلاک کنم.» ولی موسی و هارون در حضور خداوند به خاک افتادند. ");
INSERT INTO pesopcb_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","موسی به هارون گفت: «آتشدان خود را برداشته، آتش از روی مذبح در آن بگذار و بخور بر آن بریز و فوراً به میان قوم ببر و برای ایشان کفاره کن تا گناهانشان آمرزیده شود، زیرا خشم خداوند بر ایشان افروخته و بلا شروع شده است.» ");
INSERT INTO pesopcb_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","هارون مطابق دستور موسی عمل کرد و به میان قوم شتافت، زیرا بلا شروع شده بود، پس بخور بر آتش نهاد و برای ایشان کفاره نمود. ");
INSERT INTO pesopcb_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","او بین زندگان و مردگان ایستاد و بلا متوقف شد. ");
INSERT INTO pesopcb_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","با این حال، علاوه بر آنانی که روز پیش با قورح به هلاکت رسیده بودند چهارده هزار و هفتصد نفر دیگر هم مردند. ");
INSERT INTO pesopcb_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","هارون نزد موسی به در خیمهٔ ملاقات بازگشت و بدین ترتیب بلا رفع شد. ");
INSERT INTO pesopcb_vpl VALUES ("NU17_1‏","005_17_1‏","NUM","17","1‏","3","خداوند به موسی فرمود: «به قوم اسرائیل بگو که هر یک از رهبران قبایلشان، یک عصا پیش تو بیاورند و تو اسم هر یک از آنها را روی عصایش بنویس. نام هارون باید روی عصای قبیلهٔ لاوی نوشته شود. ");
INSERT INTO pesopcb_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","این عصاها را در اتاق درونی خیمهٔ ملاقات، همان جایی که با شما ملاقات می‌کنم، جلوی صندوق عهد بگذار. ");
INSERT INTO pesopcb_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","به‌وسیلهٔ این عصاها مردی را که برگزیده‌ام معرفی خواهم کرد، چون عصای او شکوفه خواهد آورد، و سرانجام این همهمه و شکایت که علیه شما به وجود آمده است پایان خواهد یافت.» ");
INSERT INTO pesopcb_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","موسی این دستور را به قوم اسرائیل داد و رهبران دوازده قبیلهٔ اسرائیل، از جمله هارون، هر یک عصایی نزد موسی آوردند. ");
INSERT INTO pesopcb_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","وی آنها را در اتاق درونی خیمهٔ عبادت در حضور خداوند گذاشت. ");
INSERT INTO pesopcb_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","روز بعد، موسی به آنجا رفت و دید عصای هارون که معرف قبیلهٔ لاوی بود شکفته و گل کرده و بادام داده است! ");
INSERT INTO pesopcb_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","موسی عصاها را از حضور خداوند بیرون آورد تا به بنی‌اسرائیل نشان دهد. پس از اینکه همه، عصاها را دیدند، هر یک از رهبران، عصای خود را پس گرفتند. ");
INSERT INTO pesopcb_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","سپس خداوند به موسی فرمود که عصای هارون را در کنار صندوق عهد بگذارد تا هشداری به این قوم سرکش باشد که بدانند اگر به شکایت خود پایان ندهند، از بین خواهند رفت. ");
INSERT INTO pesopcb_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","پس موسی همان‌طور که خداوند به او دستور داد عمل کرد. ");
INSERT INTO pesopcb_vpl VALUES ("NU17_12‏","005_17_12‏","NUM","17","12‏","13","ولی بنی‌اسرائیل بیش از پیش زبان به شکایت گشودند و گفتند: «دیگر امیدی برای ما نیست! هر کسی که به خیمهٔ عبادت خداوند نزدیک شود می‌میرد؛ بنابراین همهٔ ما هلاک خواهیم شد!» ");
INSERT INTO pesopcb_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","آنگاه خداوند به هارون فرمود: «تو و پسرانت و خانواده‌ات در برابر هر نوع بی‌حرمتی به این مکان مقدّس مسئول هستید. برای هر نوع عمل ناشایستی که در خدمت کاهنی صورت بگیرد، شما باید جوابگو باشید. ");
INSERT INTO pesopcb_vpl VALUES ("NU18_2‏","005_18_2‏","NUM","18","2‏","3","بستگان تو، یعنی قبیلهٔ لاوی، دستیاران تو خواهند بود و تو را در کارهای مربوط به خیمهٔ عبادت کمک خواهند کرد، ولی انجام وظایف مقدّس در داخل خیمهٔ عبادت فقط به عهدهٔ تو و پسرانت می‌باشد. لاویان باید مواظب باشند به مذبح و هیچ‌یک از اشیاء مقدّس دست نزنند و گرنه هم تو را و هم ایشان را هلاک خواهم کرد. ");
INSERT INTO pesopcb_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","لاویان باید در همۀ کارهای مربوط به خیمۀ ملاقات همراه شما باشند، ولی کسی که از قبیلهٔ لاوی نباشد نباید در این خدمت مقدّس تو را یاری دهد. ");
INSERT INTO pesopcb_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","به خاطر داشته باش که انجام وظایف مقدّس عبادتگاه و مذبح فقط به عهدهٔ کاهنان است. اگر از این دستورها پیروی کنید خشم خداوند دیگر بر شما نازل نخواهد شد. ");
INSERT INTO pesopcb_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","من لاویان را که از بستگان تو هستند از میان بنی‌اسرائیل انتخاب کرده‌ام. ایشان را که وقف خداوند شده‌اند همچون هدیه به شما می‌دهم تا در خیمهٔ ملاقات، وظایف خود را انجام دهند. ");
INSERT INTO pesopcb_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","ولی تو و پسرانت که کاهن هستید، باید شخصاً تمام خدمات مقدّس مذبح و قدس‌الاقداس را انجام دهید، چون خدمت کاهنی عطای خاصی است که آن را تنها به شما داده‌ام. هر فرد دیگری که بخواهد این کار را انجام دهد کشته خواهد شد.» ");
INSERT INTO pesopcb_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","خداوند این دستورها را به هارون داد: «شما کاهنان، مسئول دریافت هدایایی هستید که قوم اسرائیل برای من می‌آورند. تمام هدایای مخصوصی که به من تقدیم می‌شود از آن تو و پسرانت خواهد بود و این یک قانون دائمی است. ");
INSERT INTO pesopcb_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","از بین هدایای بسیار مقدّسی که بر مذبح سوخته نمی‌شود، این هدایا مال شماست: هدایای آردی، قربانیهای گناه و قربانیهای جبران. ");
INSERT INTO pesopcb_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","افراد مذکر باید در جای بسیار مقدّسی آنها را بخورند. ");
INSERT INTO pesopcb_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","تمام هدایای مخصوص دیگری که قوم اسرائیل با تکان دادن آنها در برابر مذبح به من تقدیم می‌کنند، از آن شما و پسران و دختران شماست. همهٔ اهل خانه‌تان می‌توانند از این هدایا بخورند، مگر اینکه کسی در آن وقت نجس باشد. ");
INSERT INTO pesopcb_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","«نوبر محصولاتی که بنی‌اسرائیل به خداوند تقدیم می‌کنند، از آن شماست، یعنی بهترین قسمت روغن زیتون، شراب، غله، ");
INSERT INTO pesopcb_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","و هر نوع محصول دیگر که برای خداوند می‌آورند. اهالی خانه‌تان می‌توانند از اینها بخورند، مگر اینکه در آن وقت نجس باشند. ");
INSERT INTO pesopcb_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","پس هر چه که وقف خداوند شود، از آن شماست. ");
INSERT INTO pesopcb_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","نخست‌زادگان بنی‌اسرائیل و نیز نخست‌زاده‌های حیوانات که وقف خداوند می‌شوند، از آن شماست. ولی هرگز نباید نخست‌زادهٔ حیواناتی را که من خوردن گوشت آنها را حرام کرده‌ام و نیز نخست‌زادگان انسان را قبول کنید. ");
INSERT INTO pesopcb_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","هر کسی که صاحب اولین پسر شود باید برای آن، پنج مثقال نقره برحسب مثقال عبادتگاه، به شما بپردازد. او باید این مبلغ را وقتی پسرش یک ماهه شد، بیاورد. ");
INSERT INTO pesopcb_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","«ولی نخست‌زادهٔ گاو و گوسفند و بز را نمی‌توان بازخرید نمود. آنها باید برای خداوند قربانی شوند. خون آنها را باید بر مذبح پاشید و چربی‌شان را سوزانید. این هدیه، هدیه‌ای مخصوص و خوشبو برای خداوند است. ");
INSERT INTO pesopcb_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","گوشت این حیوانات مانند گوشت سینه و ران راست هدیهٔ مخصوص، مال شماست. ");
INSERT INTO pesopcb_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","آری، من تمامی این هدایای مخصوصی را که قوم اسرائیل برای من می‌آورند تا ابد به شما بخشیده‌ام. اینها برای خوراک شما و خانواده‌هایتان می‌باشد و این عهدی است دائمی بین خداوند و شما و نسلهای آیندهٔ شما.» ");
INSERT INTO pesopcb_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","و خداوند به هارون گفت: «شما کاهنان نباید هیچ ملک و دارایی در سرزمین اسرائیل داشته باشید، چون ملک و ثروت شما، من هستم. ");
INSERT INTO pesopcb_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","«ده‌یکهایی را که بنی‌اسرائیل تقدیم می‌کنند، من به قبیلهٔ لاوی، در مقابل خدمت آنها در خیمۀ ملاقات، داده‌ام. ");
INSERT INTO pesopcb_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","«از این پس، غیر از کاهنان و لاویان هیچ اسرائیلی دیگری حق ندارد وارد خیمهٔ ملاقات بشود، مبادا مجرم شناخته شود و بمیرد. ");
INSERT INTO pesopcb_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","فقط لاویان باید کارهای خیمهٔ ملاقات را انجام دهند و اگر از این لحاظ کوتاهی کنند، مقصر خواهند بود. در میان شما این یک قانون دائمی خواهد بود. لاویان در اسرائیل نباید صاحب ملک باشند؛ ");
INSERT INTO pesopcb_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","چون ده‌یک‌های قوم اسرائیل که به صورت هدیهٔ مخصوص به خداوند تقدیم می‌شود، از آن لاویان خواهد بود. این میراث ایشان است و ایشان ملکی در سرزمین اسرائیل نخواهند داشت.» ");
INSERT INTO pesopcb_vpl VALUES ("NU18_25‏","005_18_25‏","NUM","18","25‏","26","همچنین خداوند به موسی فرمود به لاویان بگوید: «یک دهم عشریه‌هایی را که از بنی‌اسرائیل دریافت می‌کنید به صورت هدیهٔ مخصوص به خداوند تقدیم کنید. ");
INSERT INTO pesopcb_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","خداوند، این هدیهٔ مخصوص را به عنوان هدیهٔ نوبر محصولات غله و شراب شما، منظور خواهد نمود. ");
INSERT INTO pesopcb_vpl VALUES ("NU18_28‏","005_18_28‏","NUM","18","28‏","29","این یک دهم عشریه‌ها که به عنوان سهم خداوند تقدیم می‌شود باید از بهترین قسمت عشریه‌ها باشد. آن را به هارون کاهن بدهید. ");
INSERT INTO pesopcb_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","وقتی بهترین قسمت را تقدیم کردید، بقیهٔ هدایا را می‌توانید برای خود بردارید، همان‌گونه که مردم پس از تقدیم هدایا، بقیهٔ محصول را برای خود نگه می‌دارند. ");
INSERT INTO pesopcb_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","شما و خانواده‌هایتان، می‌توانید آن را در هر جایی که می‌خواهید بخورید، زیرا این مزد خدمتی است که در خیمهٔ ملاقات انجام می‌دهید. ");
INSERT INTO pesopcb_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","شما لاویان به سبب خوردن این هدایا مقصر نخواهید بود مگر اینکه از دادن یک دهم از بهترین قسمت آن به کاهنان، ابا نمایید. اگر این قسمت را به کاهنان ندهید، نسبت به هدایای مقدّس قوم اسرائیل بی‌حرمتی کرده‌اید و سزای شما مرگ است.» ");
INSERT INTO pesopcb_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","خداوند به موسی و هارون فرمود: ");
INSERT INTO pesopcb_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","«این است فریضه‌ای که خداوند در شریعت خود امر فرموده است تا انجام شود: به بنی‌اسرائیل بگویید که یک گوسالۀ ماده سرخ و بی‌عیب که هرگز یوغ بر گردنش گذاشته نشده باشد بیاورند ");
INSERT INTO pesopcb_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","و آن را به اِلعازار کاهن بدهند تا وی آن را از اردوگاه بیرون ببرد و یک نفر در حضور او سر آن را ببرد. ");
INSERT INTO pesopcb_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","اِلعازار کمی از خون گاو را گرفته با انگشت خود هفت بار آن را به طرف جلوی خیمهٔ ملاقات بپاشد. ");
INSERT INTO pesopcb_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","بعد در حضور او لاشهٔ گاو با پوست و گوشت و خون و سرگین آن سوزانده شود. ");
INSERT INTO pesopcb_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","العازار چوب سرو و شاخه‌های زوفا و نخ قرمز گرفته، آنها را به داخل این تودهٔ مشتعل بیندازد. ");
INSERT INTO pesopcb_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","پس از آن باید لباسهایش را شسته، غسل کند و سپس به اردوگاه بازگردد، ولی تا عصر، نجس خواهد بود. ");
INSERT INTO pesopcb_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","کسی که گاو را سوزانده باید لباسهایش را شسته، غسل کند. او نیز تا عصر نجس خواهد بود. ");
INSERT INTO pesopcb_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","بعد یک نفر که نجس نباشد خاکستر گاو را جمع کند و خارج از اردوگاه در محلی پاک بگذارد تا قوم اسرائیل از آن برای تهیهٔ آب طهارت که جهت رفع گناه است، استفاده کنند. ");
INSERT INTO pesopcb_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","همچنین کسی که خاکستر گاو را جمع می‌کند باید لباسهایش را بشوید. او نیز تا عصر نجس خواهد بود. این قانونی است همیشگی برای قوم اسرائیل و غریبی که در میان ایشان ساکن است. ");
INSERT INTO pesopcb_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","«هر کس با جنازه‌ای تماس پیدا کند تا هفت روز نجس خواهد بود. ");
INSERT INTO pesopcb_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","او باید در روز سوم و هفتم خودش را با آن آب، طاهر سازد، آنگاه پاک خواهد شد. ولی اگر در روز سوم و هفتم این کار را نکند، نجس خواهد بود. ");
INSERT INTO pesopcb_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","کسی که با جنازه‌ای تماس پیدا کند، ولی خودش را با آن آب طاهر نسازد، نجس باقی خواهد ماند، زیرا آب طهارت به روی او پاشیده نشده است. چنین شخصی باید از میان قوم اسرائیل رانده شود، زیرا خیمۀ عبادت خداوند را نجس کرده است. ");
INSERT INTO pesopcb_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","«وقتی شخصی در خیمه‌ای می‌میرد، این مقررات باید رعایت گردد: ساکنان آن خیمه و هر که وارد آن شود، تا هفت روز نجس خواهند بود. ");
INSERT INTO pesopcb_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","تمام ظروفِ بدون سرپوش واقع در آن خیمه نیز نجس خواهد بود. ");
INSERT INTO pesopcb_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","هر کسی که در صحرا با نعش شخصی که در جنگ کشته شده و یا به هر طریق دیگری مرده باشد تماس پیدا کند، و یا حتی دست به استخوان یا قبری بزند، تا هفت روز نجس خواهد بود. ");
INSERT INTO pesopcb_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","«برای اینکه شخص نجس طاهر شود، باید خاکستر گاو سرخ را که برای رفع گناه، قربانی شده است در ظرفی ریخته روی آن، آب روان بریزد. ");
INSERT INTO pesopcb_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","بعد، شخصی که نجس نباشد شاخه‌های زوفا را گرفته، در آن آب فرو ببرد و با آن، آب را روی خیمه و روی تمام ظروفی که در خیمه است و روی هر کسی که در خیمه بوده و یا به استخوان انسان مرده، نعش یا قبری دست زده، بپاشد. ");
INSERT INTO pesopcb_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","آب طهارت بایستی در روز سوم و هفتم روی شخص نجس پاشیده شود. در روز هفتم شخص نجس باید لباسهایش را بشوید و با آب غسل کند. او عصر همان روز از نجاست پاک خواهد بود. ");
INSERT INTO pesopcb_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","«اما کسی که نجس شود، ولی خود را طاهر نسازد، نجس باقی خواهد ماند؛ زیرا آب طهارت به روی او پاشیده نشده است. چنین شخصی باید از میان قوم اسرائیل رانده شود، زیرا خیمۀ عبادت خداوند را نجس کرده است. ");
INSERT INTO pesopcb_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","این یک قانون همیشگی برای قوم است. کسی که آب طهارت را می‌پاشد باید بعد، لباسهای خود را بشوید. هر که به آن آب دست بزند تا غروب نجس خواهد بود، ");
INSERT INTO pesopcb_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","و هر چیزی که دست شخص نجس به آن بخورد و نیز هر که آن را لمس کند تا عصر نجس خواهد بود.» ");
INSERT INTO pesopcb_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","قوم اسرائیل در ماه اول سال به بیابان صین رسیدند و در قادش اردو زدند. مریم در آنجا فوت کرد و او را به خاک سپردند. ");
INSERT INTO pesopcb_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","در آن مکان آب نبود، پس قوم اسرائیل دوباره علیه موسی و هارون شوریدند ");
INSERT INTO pesopcb_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","و زبان به اعتراض گشوده، گفتند: «ای کاش ما هم با برادرانمان در حضور خداوند می‌مردیم! ");
INSERT INTO pesopcb_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","چرا جماعت خداوند را به این بیابان آوردید تا ما با گله‌هایمان در اینجا بمیریم؟ ");
INSERT INTO pesopcb_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","چرا ما را از مصر به این زمین خشک آوردید که در آن نه غله هست نه انجیر، نه مو و نه انار! در اینجا حتی آب هم پیدا نمی‌شود که بنوشیم!» ");
INSERT INTO pesopcb_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","موسی و هارون از مردم دور شدند و در کنار در خیمهٔ ملاقات رو به خاک نهادند و حضور پرجلال خداوند بر ایشان نمایان شد. ");
INSERT INTO pesopcb_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","خداوند به موسی فرمود: ");
INSERT INTO pesopcb_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","«عصا را که در جلوی صندوق عهد است بردار. سپس تو و هارون قوم اسرائیل را جمع کنید و در برابر چشمان ایشان به این صخره بگویید که آب خود را جاری سازد. آنگاه از آبی که از صخره بیرون می‌آید به قوم اسرائیل و تمام حیواناتشان خواهید نوشاند.» ");
INSERT INTO pesopcb_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","پس، موسی چنانکه به او گفته شد عمل کرد. او عصا را از حضور خداوند برداشت، ");
INSERT INTO pesopcb_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","سپس به کمک هارون قوم را در نزدیکی آن صخره جمع کرده، به ایشان گفت: «ای آشوبگران بشنوید! آیا ما باید از این صخره برای شما آب بیرون بیاوریم؟» ");
INSERT INTO pesopcb_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","آنگاه موسی عصا را بلند کرده، دو بار به صخره زد و آب فوران نموده، قوم اسرائیل و حیواناتشان از آن نوشیدند. ");
INSERT INTO pesopcb_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","اما خداوند به موسی و هارون فرمود: «چون شما به من اعتماد نکردید و در نظر قوم اسرائیل حرمت قدوسیت مرا نگه نداشتید، شما آنها را به سرزمینی که به ایشان وعده داده‌ام رهبری نخواهید کرد.» ");
INSERT INTO pesopcb_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","این مکان «مَریبه» (یعنی «منازعه») نامیده شد، چون در آنجا بود که قوم اسرائیل با خداوند منازعه کردند و در همان جا بود که خداوند ثابت کرد که قدوس است. ");
INSERT INTO pesopcb_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","زمانی که موسی در قادش بود، قاصدانی نزد پادشاه ادوم فرستاد و گفت: «ما از نسل برادر تو اسرائیل هستیم و تو سرگذشت غم‌انگیز ما را می‌دانی ");
INSERT INTO pesopcb_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","که چطور اجداد ما به مصر رفته، سالهای سال در آنجا ماندند و بردهٔ مصری‌ها شدند. ");
INSERT INTO pesopcb_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","اما وقتی که به درگاه خداوند فریاد برآوردیم، او دعای ما را مستجاب فرمود و فرشته‌ای فرستاده ما را از مصر بیرون آورد. حالا ما در قادش هستیم و در مرز سرزمین تو اردو زده‌ایم. ");
INSERT INTO pesopcb_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","خواهش می‌کنیم به ما اجازه دهی از داخل مملکت تو عبور کنیم. از میان مزارع و باغهای انگور شما عبور نخواهیم کرد و حتی از چاههای شما آب نخواهیم نوشید، بلکه از شاهراه خواهیم رفت و از آن خارج نخواهیم شد تا از خاک کشورتان بیرون رویم.» ");
INSERT INTO pesopcb_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","ولی پادشاه ادوم گفت: «داخل نشوید! اگر بخواهید وارد سرزمین من شوید با لشکر به مقابلهٔ شما خواهم آمد.» ");
INSERT INTO pesopcb_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","فرستادگان اسرائیلی در جواب گفتند: «ای پادشاه، ما فقط از شاهراه می‌گذریم و حتی آب شما را بدون پرداخت قیمت آن، نخواهیم نوشید. ما فقط می‌خواهیم از اینجا عبور کنیم و بس.» ");
INSERT INTO pesopcb_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","ولی پادشاه ادوم اخطار نمود که داخل نشوند. سپس سپاهی عظیم و نیرومند علیه اسرائیل بسیج کرد. ");
INSERT INTO pesopcb_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","چون ادومی‌ها اجازهٔ عبور از داخل کشورشان را به قوم اسرائیل ندادند، پس بنی‌اسرائیل بازگشتند و از راهی دیگر رفتند. ");
INSERT INTO pesopcb_vpl VALUES ("NU20_22‏","005_20_22‏","NUM","20","22‏","23","آنها پس از ترک قادش به کوه هور در سرحد سرزمین ادوم رسیدند. خداوند در آنجا به موسی و هارون فرمود: ");
INSERT INTO pesopcb_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","«زمان مرگ هارون فرا رسیده است و او به‌زودی به اجداد خود خواهد پیوست. او به سرزمینی که به قوم اسرائیل داده‌ام داخل نخواهد شد، چون هر دو شما نزد چشمهٔ مریبه از دستور من سرپیچی کردید. ");
INSERT INTO pesopcb_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","حال ای موسی، هارون و پسرش العازار را برداشته، آنها را به بالای کوه هور بیاور. ");
INSERT INTO pesopcb_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","در آنجا، لباسهای کاهنی را از تن هارون درآور و به پسرش العازار بپوشان. هارون در همان جا خواهد مرد و به اجداد خود خواهد پیوست.» ");
INSERT INTO pesopcb_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","پس موسی همان‌طور که خداوند به او دستور داده بود عمل کرد و در حالی که تمامی قوم اسرائیل به ایشان چشم دوخته بودند، هر سه با هم از کوه هور بالا رفتند. ");
INSERT INTO pesopcb_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","وقتی که به بالای کوه رسیدند، موسی لباس کاهنی را از تن هارون درآورد و به پسرش العازار پوشانید. هارون در آنجا روی کوه درگذشت. سپس موسی و العازار بازگشتند. ");
INSERT INTO pesopcb_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","هنگامی که قوم اسرائیل از مرگ هارون آگاه شدند، مدت سی روز برای او عزاداری نمودند. ");
INSERT INTO pesopcb_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","پادشاه کنعانی سرزمین عراد (واقع در نگب کنعان) وقتی شنید اسرائیلی‌ها از راه اتاریم می‌آیند، سپاه خود را بسیج نموده، به قوم اسرائیل حمله کرد و عده‌ای از ایشان را به اسیری گرفت. ");
INSERT INTO pesopcb_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","پس قوم اسرائیل به خداوند نذر کردند که اگر خداوند ایشان را یاری دهد تا بر پادشاه عراد و مردمش پیروز شوند، تمامی شهرهای آن مرزوبوم را به کلی نابود کنند. ");
INSERT INTO pesopcb_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","خداوند دعای ایشان را شنیده کنعانی‌ها را شکست داد، و اسرائیلی‌ها آنان و شهرهای ایشان را به کلی نابود کردند. از آن پس، آن ناحیه «حرمه» (یعنی «نابودی») نامیده شد. ");
INSERT INTO pesopcb_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","سپس قوم اسرائیل از کوه هور رهسپار شدند تا از راهی که به دریای سرخ ختم می‌شد سرزمین ادوم را دور بزنند. اما قوم اسرائیل در این سفر طولانی به ستوه آمدند ");
INSERT INTO pesopcb_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","و به خدا و موسی اعتراض کرده گفتند: «چرا ما را از مصر بیرون آوردید تا در این بیابان بمیریم؟ در اینجا نه چیزی برای خوردن هست و نه چیزی برای نوشیدن! ما از خوردن این مَنّای بی‌مزه خسته شده‌ایم!» ");
INSERT INTO pesopcb_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","پس خداوند مارهای سمی به میان ایشان فرستاد و مارها عدهٔ زیادی از ایشان را گزیده، هلاک کردند. ");
INSERT INTO pesopcb_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","آنگاه قوم اسرائیل پیش موسی آمده، فریاد برآوردند: «ما گناه کرده‌ایم، چون بر ضد خداوند و بر ضد تو سخن گفته‌ایم. از خداوند درخواست کن تا این مارها را از ما دور کند.» موسی برای قوم دعا کرد. ");
INSERT INTO pesopcb_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","خداوند به وی فرمود: «یک مار مفرغین شبیه یکی از این مارها بساز و آن را بر سر یک تیر بیاویز. هر مارگزیده‌ای که به آن نگاه کند، زنده خواهد ماند!» ");
INSERT INTO pesopcb_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","پس موسی یک مار مفرغین درست کرد و آن را بر سر تیری آویخت. به محض اینکه مار گزیده‌ای به آن نگاه می‌کرد، شفا می‌یافت! ");
INSERT INTO pesopcb_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","قوم اسرائیل به اوبوت کوچ کردند و در آنجا اردو زدند. ");
INSERT INTO pesopcb_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","سپس از آنجا به عیی‌عباریم که در بیابان و در فاصلهٔ کمی از شرق موآب قرار داشت، رفتند. ");
INSERT INTO pesopcb_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","از آنجا به وادی زارد کوچ کرده، اردو زدند. ");
INSERT INTO pesopcb_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","بعد به طرف شمال رود ارنون نزدیک مرزهای اموری‌ها نقل مکان کردند. (رود ارنون، خط مرزی بین موآبی‌ها و اموری‌هاست. ");
INSERT INTO pesopcb_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","در کتاب «جنگهای خداوند» به این امر اشاره شده که درهٔ رود ارنون و شهر واهیب ");
INSERT INTO pesopcb_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","بین اموری‌ها و موآبی‌ها قرار دارند.) ");
INSERT INTO pesopcb_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","سپس قوم اسرائیل به «بئر» (یعنی «چاه») کوچ کردند. این همان جایی است که خداوند به موسی فرمود: «قوم را جمع کن و من به ایشان آب خواهم داد.» ");
INSERT INTO pesopcb_vpl VALUES ("NU21_17‏","005_21_17‏","NUM","21","17‏","18","آنگاه قوم اسرائیل این سرود را خواندند: «ای چاه، بجوش آی! در وصف این چاه بسرایید! این است چاهی که رهبران آن را کندند، بله، بزرگان اسرائیل با عصاهایشان آن را کندند!» قوم اسرائیل از بیابان به مَتّانه کوچ کردند، ");
INSERT INTO pesopcb_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","و از مَتّانه به نحلیئیل، و از نحلیئیل به باموت ");
INSERT INTO pesopcb_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","و از باموت به دره‌ای که در موآب قرار دارد و مشرف به بیابان و کوه پیسگاه است. ");
INSERT INTO pesopcb_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","در این وقت قوم اسرائیل سفیرانی نزد سیحون، پادشاه اموری‌ها فرستادند. ");
INSERT INTO pesopcb_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","فرستادگان درخواست کرده گفتند: «اجازه دهید از سرزمین شما عبور کنیم. ما قول می‌دهیم از شاهراه برویم و تا زمانی که از مرزتان نگذشته‌ایم از راهی که در آن می‌رویم خارج نشویم. به مزرعه‌ها و تاکستانهای شما وارد نخواهیم شد و آب شما را نیز نخواهیم نوشید.» ");
INSERT INTO pesopcb_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","ولی سیحون پادشاه موافقت نکرد. در عوض، او سپاه خود را در بیابان در مقابل قوم اسرائیل بسیج کرد و در ناحیهٔ یاهص با ایشان وارد جنگ شد. ");
INSERT INTO pesopcb_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","در این جنگ، بنی‌اسرائیل آنها را از دم شمشیر گذراندند و سرزمینشان را از رود ارنون تا رود یبوق و تا مرز سرزمین بنی‌عمون تصرف کردند، اما نتوانستند جلوتر بروند، زیرا مرز بنی‌عمون مستحکم بود. ");
INSERT INTO pesopcb_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","به این ترتیب، قوم اسرائیل تمام شهرهای اموری‌ها منجمله شهر حِشبون و تمام روستاهای اطرافش را تصرف کردند و در آنها ساکن شدند. ");
INSERT INTO pesopcb_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","حِشبون پایتخت سیحون پادشاه اموری‌ها بود. او پیش از آن، پادشاه قبلی موآب را شکست داده، تمام سرزمینش را تا به اَرنون به تصرف درآورده بود. ");
INSERT INTO pesopcb_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","از همین رو شعرا در مورد سیحون پادشاه چنین گفته‌اند: «به حشبون بیایید، بگذارید بنا شود، بگذارید شهر سیحون پادشاه بازسازی شود. ");
INSERT INTO pesopcb_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","زیرا آتشی از حِشبون افروخته شده، و شعله‌ای از شهر سیحون. شهر عارِ موآب را سوزانده، و حاکمان بلندیهای ارنون را هلاک کرده. ");
INSERT INTO pesopcb_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","وای بر تو ای موآب! تو هلاک شدی، ای قومی که کموش را می‌پرستید! کموش پسران خود را همچون فراریان تسلیم کرد، و دخترانش را به اسارت سیحون، پادشاه اموری‌ها فرستاد. ");
INSERT INTO pesopcb_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","اما ما آنها را هلاک کرده‌ایم از حشبون تا دیبون، و تا نوفح که نزدیک میدبا است.» ");
INSERT INTO pesopcb_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","بدین ترتیب قوم اسرائیل در سرزمین اموری‌ها ساکن شدند. ");
INSERT INTO pesopcb_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","موسی افرادی به ناحیهٔ یعزیز فرستاد تا وضع آنجا را بررسی کنند. پس از آن، قوم اسرائیل به آن ناحیه حمله بردند و آن را با روستاهای اطرافش گرفتند و اموری‌ها را بیرون راندند. ");
INSERT INTO pesopcb_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","سپس بنی‌اسرائیل بازگشتند و راهی را که به باشان منتهی می‌شد در پیش گرفتند؛ اما عوج، پادشاه باشان، برای جنگ با آنها، با سپاه خود به ادرعی آمد. ");
INSERT INTO pesopcb_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","خداوند به موسی فرمود: «از او نترس، زیرا او را با همۀ قوم و سرزمینش به دست تو تسلیم کرده‌ام. همان بلایی به سر عوج پادشاه می‌آید که در حشبون به سر سیحون، پادشاه اموری‌ها آمد.» ");
INSERT INTO pesopcb_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","پس قوم اسرائیل، عوجِ پادشاه را همراه با پسرانش و اهالی سرزمینش کشتند، به طوری که یکی از آنها هم زنده نماند. سپس قوم اسرائیل آن سرزمین را تصرف کردند. ");
INSERT INTO pesopcb_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","قوم اسرائیل به دشت موآب کوچ کرده، در سمت شرقی رود اردن، روبروی اریحا اردو زدند. ");
INSERT INTO pesopcb_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","بالاق (پسر صِفّور) پادشاه موآب هر آنچه را که بنی‌اسرائیل با اموریان کرده بودند، دید. ");
INSERT INTO pesopcb_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","و وقتی موآبیان تعداد قوم اسرائیل را دیدند، وحشت کردند. ");
INSERT INTO pesopcb_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","موآبیان برای مشایخ مدیان پیام فرستاده، گفتند: «این جمعیت کثیر، ما را مثل گاوی که علف می‌خورد خواهند بلعید!» پس بالاق پادشاه ");
INSERT INTO pesopcb_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","سفیرانی با این پیام نزد بلعام (پسر بعور) که در سرزمین اجدادی خود فتور، واقع در کنار رود فرات زندگی می‌کرد فرستاد: «قومی بزرگ از مصر بیرون آمده‌اند؛ مردمش همه جا پخش شده‌اند و به سوی سرزمین من می‌آیند. ");
INSERT INTO pesopcb_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","درخواست می‌کنم بیایی و این قوم را برای من نفرین کنی، زیرا از ما قویترند. شاید به این وسیله بتوانم آنان را شکست داده، از سرزمین خود بیرون کنم. زیرا می‌دانم هر که را تو برکت دهی برکت خواهد یافت و هر که را نفرین کنی، زیر لعنت قرار خواهد گرفت.» ");
INSERT INTO pesopcb_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","سفیران از مشایخ موآب و مدیان بودند. ایشان با مزد فالگیری نزد بلعام رفتند و پیام بالاق را به او دادند. ");
INSERT INTO pesopcb_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","بلعام گفت: «شب را اینجا بمانید و فردا صبح آنچه که خداوند به من بگوید، به شما خواهم گفت.» پس آنها شب را در آنجا به سر بردند. ");
INSERT INTO pesopcb_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","آن شب، خدا نزد بلعام آمده، از او پرسید: «این مردان کیستند؟» ");
INSERT INTO pesopcb_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","بلعام جواب داد: «ایشان از پیش بالاق، پادشاه موآب آمده‌اند. ");
INSERT INTO pesopcb_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","بالاق می‌گوید که گروه بی‌شماری از مصر به مرز کشور او رسیده‌اند و از من خواسته است بی‌درنگ بروم و آنها را نفرین کنم تا شاید قدرت یافته، بتواند آنها را از سرزمینش بیرون کند.» ");
INSERT INTO pesopcb_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","خدا به وی فرمود: «با آنها نرو. تو نباید این قوم را نفرین کنی، چون من ایشان را برکت داده‌ام.» ");
INSERT INTO pesopcb_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","صبح روز بعد، بلعام به فرستادگان بالاق گفت: «به سرزمین خود بازگردید. خداوند به من اجازه نمی‌دهد این کار را انجام دهم.» ");
INSERT INTO pesopcb_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","فرستادگان بالاق بازگشته به وی گفتند که بلعام از آمدن خودداری می‌کند. ");
INSERT INTO pesopcb_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","اما بالاق بار دیگر گروه بزرگتر و مهمتری فرستاد. ");
INSERT INTO pesopcb_vpl VALUES ("NU22_16‏","005_22_16‏","NUM","22","16‏","17","آنها با این پیغام نزد بلعام آمدند: «بالاق پادشاه به تو التماس می‌کند که بیایی. او قول داده است که پاداش خوبی به تو دهد و هر چه بخواهی برایت انجام دهد. فقط بیا و این قوم را نفرین کن.» ");
INSERT INTO pesopcb_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","ولی بلعام جواب داد: «اگر او کاخی پر از طلا و نقره هم به من بدهد، نمی‌توانم کاری را که خلاف دستور خداوند، خدای من باشد، انجام دهم. ");
INSERT INTO pesopcb_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","به هر حال، امشب اینجا بمانید تا ببینم آیا خداوند چیزی غیر از آنچه قبلاً فرموده است خواهد گفت یا نه.» ");
INSERT INTO pesopcb_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","آن شب خدا به بلعام فرمود: «برخیز و با این مردان برو، ولی فقط آنچه را که من به تو می‌گویم بگو.» ");
INSERT INTO pesopcb_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","بلعام صبح برخاست و الاغ خود را پالان کرده، با فرستادگان بالاق حرکت نمود. ");
INSERT INTO pesopcb_vpl VALUES ("NU22_22‏","005_22_22‏","NUM","22","22‏","23","اما خدا از رفتن بلعام خشمناک شد و فرشته‌ای به سر راهش فرستاد تا راه را بر او ببندد. در حالی که بلعام سوار بر الاغ، همراه دو نوکرش به پیش می‌رفت، ناگهان الاغ بلعام فرشتهٔ خداوند را دید که شمشیری به دست گرفته، و سر راه ایستاده است. پس الاغ از مسیر جاده منحرف شده، به مزرعه‌ای رفت، ولی بلعام او را زد و به جاده بازگرداند. ");
INSERT INTO pesopcb_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","بعد فرشتهٔ خداوند در راهی باریک بین دو تاکستان، که در هر دو طرف آن دیواری قرار داشت، ایستاد. ");
INSERT INTO pesopcb_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","الاغ وقتی دید فرشتۀ خداوند آنجا ایستاده است، خودش را به دیوار چسبانیده، پای بلعام را به دیوار فشرد. پس او دوباره الاغ را زد. ");
INSERT INTO pesopcb_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","آنگاه فرشته کمی پایینتر رفت و در جایی بسیار تنگ ایستاد، به طوری که الاغ به هیچ وجه نمی‌توانست از کنارش بگذرد. ");
INSERT INTO pesopcb_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","پس الاغ در وسط جاده خوابید. بلعام خشمگین شد و باز با چوبدستی خود الاغ را زد. ");
INSERT INTO pesopcb_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","آنگاه خداوند الاغ را به حرف آورد و الاغ گفت: «مگر من چه کرده‌ام؟ چرا مرا سه بار زدی؟» ");
INSERT INTO pesopcb_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","بلعام گفت: «برای اینکه مرا مسخره کرده‌ای! ای کاش شمشیری داشتم و تو را همین جا می‌کشتم!» ");
INSERT INTO pesopcb_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","الاغ گفت: «آیا قبلاً در تمام عمرم هرگز چنین کاری کرده بودم؟» بلعام گفت: «نه.» ");
INSERT INTO pesopcb_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","آنگاه خداوند چشمان بلعام را باز کرد و او فرشتهٔ خداوند را دید که شمشیری به دست گرفته و سر راه ایستاده است. پس پیش او به خاک افتاد. ");
INSERT INTO pesopcb_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","فرشتۀ خداوند گفت: «چرا سه دفعه الاغ خود را زدی؟ من آمده‌ام تا مانع رفتن تو شوم، چون این سفر تو از روی تمرد است. ");
INSERT INTO pesopcb_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","این الاغ سه بار مرا دید و خود را از من کنار کشید. اگر این کار را نمی‌کرد تا به حال تو را کشته بودم، و او را زنده می‌گذاشتم.» ");
INSERT INTO pesopcb_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","آنگاه بلعام اعتراف کرده، گفت: «من گناه کرده‌ام. من متوجه نشدم که تو سر راه من ایستاده بودی. حال اگر تو با رفتن من موافق نیستی، به خانه‌ام باز می‌گردم.» ");
INSERT INTO pesopcb_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","فرشته به او گفت: «با این افراد برو، ولی فقط آنچه را که من به تو می‌گویم، بگو.» پس بلعام با سفیران بالاق به راه خود ادامه داد. ");
INSERT INTO pesopcb_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","بالاق پادشاه وقتی شنید بلعام در راه است، از پایتخت خود بیرون آمده، تا رود ارنون واقع در مرز کشورش به استقبال او رفت. ");
INSERT INTO pesopcb_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","بالاق از بلعام پرسید: «چرا وقتی بار اول تو را احضار کردم، نیامدی؟ آیا فکر کردی نمی‌توانم پاداش خوبی به تو بدهم.» ");
INSERT INTO pesopcb_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","بلعام جواب داد: «الان آمده‌ام، ولی قدرت ندارم چیزی بگویم. من فقط آنچه را که خدا بر زبانم بگذارد خواهم گفت.» ");
INSERT INTO pesopcb_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","بلعام همراه بالاق به قریه حصوت رفت. ");
INSERT INTO pesopcb_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","در آنجا بالاق پادشاه گاو و گوسفند قربانی کرد و از گوشت آنها به بلعام و سفیرانی که فرستاده بود، داد. ");
INSERT INTO pesopcb_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","صبح روز بعد، بالاق بلعام را به بالای کوه بموت بعل برد تا از آنجا قسمتی از قوم اسرائیل را ببیند. ");
INSERT INTO pesopcb_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","بلعام به بالاقِ پادشاه گفت: «در اینجا هفت مذبح بساز و هفت گاو و هفت قوچ برای قربانی حاضر کن.» ");
INSERT INTO pesopcb_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","بالاق به دستور بلعام عمل نمود و ایشان بر هر مذبح، یک گاو و یک قوچ قربانی کردند. ");
INSERT INTO pesopcb_vpl VALUES ("NU23_3‏","005_23_3‏","NUM","23","3‏","4","بعد بلعام به بالاق گفت: «در اینجا در کنار قربانیهای سوختنی خود بایست تا من بروم و ببینم آیا خداوند به ملاقات من می‌آید یا نه. هر چه او به من بگوید به تو خواهم گفت.» پس بلعام به بالای تپه‌ای رفت و در آنجا خدا او را ملاقات نمود. بلعام به خدا گفت: «من هفت مذبح حاضر نموده و روی هر کدام یک گاو و یک قوچ قربانی کرده‌ام.» ");
INSERT INTO pesopcb_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","آنگاه خداوند توسط بلعام برای بالاق پادشاه پیامی فرستاد. ");
INSERT INTO pesopcb_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","پس بلعام به نزد پادشاه که با همهٔ بزرگان موآب در کنار قربانیهای سوختنی خود ایستاده بود بازگشت ");
INSERT INTO pesopcb_vpl VALUES ("NU23_7‏","005_23_7‏","NUM","23","7‏","10","و این پیام را داد: «بالاق، پادشاه موآب مرا از سرزمین ارام، از کوههای شرقی آورد. او به من گفت: ”بیا و قوم اسرائیل را برای من نفرین کن.“ ولی چگونه نفرین کنم آنچه را که خدا نفرین نکرده است؟ چگونه لعنت کنم قومی را که خداوند لعنت نکرده است؟ از بالای صخره‌ها ایشان را می‌بینم، از بالای تپه‌ها آنان را مشاهده می‌کنم. آنان قومی هستند که به تنهایی زندگی می‌کنند و خود را از دیگر قومها جدا می‌دانند. ایشان مثل غبارند، بی‌شمار و بی‌حساب! ای کاش این سعادت را می‌داشتم که همچون یک صالح بمیرم. ای کاش عاقبت من، مثل عاقبت آنها باشد!» ");
INSERT INTO pesopcb_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","بالاق پادشاه به بلعام گفت: «این چه کاری بود که کردی؟ من به تو گفتم که دشمنانم را نفرین کنی، ولی تو ایشان را برکت دادی!» ");
INSERT INTO pesopcb_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","اما بلعام جواب داد: «آیا می‌توانم سخن دیگری غیر از آنچه که خداوند به من می‌گوید بر زبان آورم؟» ");
INSERT INTO pesopcb_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","بعد بالاق به او گفت: «پس بیا تا تو را به جای دیگری ببرم. از آنجا فقط قسمتی از قوم اسرائیل را خواهی دید. حداقل آن عده را نفرین کن.» ");
INSERT INTO pesopcb_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","بنابراین بالاق پادشاه، بلعام را به مزرعهٔ صوفیم بر روی کوه پیسگاه برد و در آنجا هفت مذبح ساخت و روی هر مذبح یک گاو و یک قوچ قربانی کرد. ");
INSERT INTO pesopcb_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","پس بلعام به پادشاه گفت: «تو در کنار قربانی سوختنی خود بایست تا من به ملاقات خداوند بروم.» ");
INSERT INTO pesopcb_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","خداوند بلعام را ملاقات نمود و آنچه را که او می‌بایست به بالاق بگوید به او گفت. ");
INSERT INTO pesopcb_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","پس بلعام به نزد پادشاه که با بزرگان موآب در کنار قربانیهای سوختنی خود ایستاده بود، بازگشت. پادشاه پرسید: «خداوند چه فرموده است؟» ");
INSERT INTO pesopcb_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","جواب بلعام چنین بود: «بالاق، برخیز و بشنو! ای پسر صفور، به من گوش فرا ده! ");
INSERT INTO pesopcb_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","خدا انسان نیست که دروغ بگوید، او مثل انسان نیست که تغییر فکر دهد. آیا تاکنون وعده‌ای داده است که بدان عمل نکرده باشد؟ یا کلامی بر زبان آورده که به انجام نرسانده باشد؟ ");
INSERT INTO pesopcb_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","به من دستور داده شده است که ایشان را برکت دهم، زیرا خدا آنان را برکت داده است و من نمی‌توانم آن را تغییر دهم. ");
INSERT INTO pesopcb_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","او گناهی در اسرائیل ندیده است، پس بدبختی در قوم خدا مشاهده نخواهد شد. خداوند، خدای ایشان با آنان است، و ایشان اعلان می‌کنند که او پادشاه آنهاست. ");
INSERT INTO pesopcb_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","خدا اسرائیل را از مصر بیرون آورده است، آنها مثل شاخهای گاو وحشی نیرومند هستند. ");
INSERT INTO pesopcb_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","نمی‌توان اسرائیل را نفرین کرد، و هیچ افسونی بر این قوم کارگر نیست. دربارهٔ اسرائیل خواهند گفت: ”ببینید خدا برای آنها چه کارهایی کرده است!“ ");
INSERT INTO pesopcb_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","این قوم، چون شیر ماده برمی‌خیزد، و همچون شیر نر خود را بر پا می‌دارد. و تا وقتی شکار خود را نخورند و خون کشتگان را ننوشند، نمی‌خوابند.» ");
INSERT INTO pesopcb_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","پادشاه به بلعام گفت: «اگر آنها را نفرین نمی‌کنی، حداقل برکتشان هم نده.» ");
INSERT INTO pesopcb_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","اما بلعام جواب داد: «مگر به تو نگفتم هر چه خداوند بر زبانم بگذارد آن را خواهم گفت؟» ");
INSERT INTO pesopcb_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","بعد بالاق پادشاه، به بلعام گفت: «تو را به جای دیگری می‌برم، شاید خدا را خوش آید و به تو اجازه فرماید از آنجا بنی‌اسرائیل را نفرین کنی.» ");
INSERT INTO pesopcb_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","پس بالاق پادشاه بلعام را به قلهٔ کوه فغور که مشرف به بیابان بود، برد. ");
INSERT INTO pesopcb_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","بلعام دوباره به بالاق گفت که هفت مذبح بسازد و هفت گاو و هفت قوچ برای قربانی حاضر کند. ");
INSERT INTO pesopcb_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","بالاق چنانکه بلعام گفته بود عمل نمود و بر هر مذبح، یک گاو و یک قوچ قربانی کرد. ");
INSERT INTO pesopcb_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","چون بلعام دید که قصد خداوند این است که قوم اسرائیل را برکت دهد، پس مثل دفعات پیش سعی نکرد از عالم غیب پیام بگیرد. او سرش را به طرف دشت برگرداند ");
INSERT INTO pesopcb_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","و اردوی اسرائیل را دید که قبیله به قبیله در دشت پخش شده‌اند. آنگاه روح خدا بر او قرار گرفت، ");
INSERT INTO pesopcb_vpl VALUES ("NU24_3‏","005_24_3‏","NUM","24","3‏","9","و دربارهٔ ایشان چنین پیشگویی کرد: «این است وحی بلعام پسر بعور، وحی آن مردی که چشمانش باز شد، وحی آن کسی که سخنان خدا را شنید، و رویایی را که خدای قادر مطلق نشان داد مشاهده نمود، آنکه به خاک افتاد و چشمانش باز شد، چه زیبایند خیمه‌های بنی‌اسرائیل! آنها را مثل دره‌های سبز و خرم و چون باغهای کنار رودخانه، در مقابل خود گسترده می‌بینم، مثل درختان عود که خود خداوند نشانده باشد، و مانند درختان سرو کنار آب. دلوهای ایشان از آب لبریز خواهند بود، و بذرهایشان با آب فراوان آبیاری خواهند شد. پادشاه ایشان از ”اجاج“ بزرگتر خواهد بود و کشورشان بسیار سرافراز خواهد گردید. خدا اسرائیل را از مصر بیرون آورده است، آنها مثل شاخهای گاو وحشی نیرومند هستند، اسرائیل قومهایی را که با ایشان مخالفت کنند، می‌بلعند. استخوانهایشان را می‌شکنند و خرد می‌کنند و با تیرهایشان پیکر آنها را به زمین می‌دوزند. بنی‌اسرائیل چون شیر می‌خوابد، چه کسی جرأت دارد او را بیدار کند؟ ای اسرائیل، برکت باد بر هر که تو را برکت دهد و لعنت باد بر کسی که تو را لعنت کند.» ");
INSERT INTO pesopcb_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","بالاق به شدت خشمگین شد. او در حالی که دستهایش را به هم می‌کوبید سر بلعام فریاد کشید: «من تو را به اینجا آوردم تا دشمنانم را نفرین کنی، ولی در عوض، تو سه بار آنان را برکت دادی. ");
INSERT INTO pesopcb_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","از اینجا برو! برگرد به خانه‌ات! من تصمیم داشتم به تو پاداش خوبی دهم، ولی خداوند تو را از آن بازداشت.» ");
INSERT INTO pesopcb_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","بلعام جواب داد: «مگر به فرستاده‌های تو نگفتم که ");
INSERT INTO pesopcb_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","اگر بالاق یک کاخ پر از طلا و نقره هم به من بدهد، نمی‌توانم از فرمان خداوند سرپیچی نموده، آنچه خود بخواهم بگویم. من هر چه خداوند بفرماید همان را می‌گویم. ");
INSERT INTO pesopcb_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","حال، پیش قوم خود باز می‌گردم، ولی پیش از رفتنم بگذار به تو بگویم که در آینده بنی‌اسرائیل بر سر قوم تو چه خواهند آورد.» ");
INSERT INTO pesopcb_vpl VALUES ("NU24_15‏","005_24_15‏","NUM","24","15‏","19","آنگاه بلعام چنین پیشگویی کرد: «این است وحی بلعام پسر بعور، وحی آن مردی که چشمانش باز شد، وحی آن کسی که سخنان خدا را شنید، و از خدای متعال بصیرت را کسب کرد و رویایی را که خدای قادر مطلق نشان داد، مشاهده نمود، آنکه به خاک افتاد و چشمانش باز شد: او را خواهم دید، اما نه حالا، او را مشاهده خواهم نمود، اما نه از نزدیک. ستاره‌ای از یعقوب ظهور خواهد کرد، و عصایی از اسرائیل برخواهد خاست. او پیشانی موآب را خرد خواهد کرد و فرزندان شیث را سرکوب خواهد نمود، ادوم و سعیر به تصرف در خواهند آمد، اما اسرائیل پیروز خواهد شد. فرمانروایی از اسرائیل ظهور خواهد نمود و بازماندگان شهرها را نابود خواهد کرد.» ");
INSERT INTO pesopcb_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","سپس، بلعام به طرف عمالیقی‌ها چشم دوخت و چنین پیشگویی کرد: «عمالیق سرآمد قومها بود، ولی سرنوشتش هلاکت است.» ");
INSERT INTO pesopcb_vpl VALUES ("NU24_21‏","005_24_21‏","NUM","24","21‏","22","بعد به قینی‌ها نظر انداخت و چنین پیشگویی کرد: «آری، مسکن شما مستحکم است، آشیانه‌تان بر صخره قرار دارد؛ ولی ای قینی‌ها نابود خواهید شد و سپاه نیرومند پادشاه آشور شما را به اسارت خواهد برد.» ");
INSERT INTO pesopcb_vpl VALUES ("NU24_23‏","005_24_23‏","NUM","24","23‏","24","او با این سخنان به پیشگویی خود خاتمه داد: «وقتی خدا این کار را انجام دهد چه کسی زنده خواهد ماند؟ کشتی‌ها از سواحل قبرس خواهند آمد و آشور و عابر را ذلیل خواهند کرد، و خود نیز از بین خواهند رفت.» ");
INSERT INTO pesopcb_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","آنگاه بلعام و بالاق هر یک به خانه‌های خود رفتند. ");
INSERT INTO pesopcb_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","هنگامی که بنی‌اسرائیل در شطیم اردو زده بودند، مردانشان با دختران قوم موآب زنا کردند. ");
INSERT INTO pesopcb_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","این دختران، آنها را دعوت می‌کردند تا در مراسم قربانی بتهایشان شرکت کنند، و مردان اسرائیلی هم از گوشت قربانیها می‌خوردند و بتهایشان را پرستش می‌کردند. ");
INSERT INTO pesopcb_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","چندی نگذشت که تمامی اسرائیل به پرستش بعل فغور که خدای موآب بود روی آوردند. از این جهت، خشم خداوند به شدت بر قوم خود افروخته شد. ");
INSERT INTO pesopcb_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","پس خداوند به موسی چنین فرمان داد: «همهٔ سرانِ قبایلِ اسرائیل را اعدام کن. در روز روشن و در حضور من آنها را به دار آویز تا خشم شدید من از این قوم دور شود.» ");
INSERT INTO pesopcb_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","پس موسی به داوران اسرائیل دستور داد تا تمام کسانی را که بعل فغور را پرستش کرده بودند، بکشند. ");
INSERT INTO pesopcb_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","ولی یکی از مردان اسرائیلی، گستاخی را به جایی رساند که در مقابل چشمان موسی و تمام کسانی که جلوی در خیمهٔ ملاقات گریه می‌کردند، یک دختر مدیانی را به اردوگاه آورد. ");
INSERT INTO pesopcb_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","وقتی که فینحاس (پسر العازار و نوهٔ هارون کاهن) این را دید از جا برخاسته، نیزه‌ای برداشت ");
INSERT INTO pesopcb_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","و پشت سر آن مرد به خیمه‌ای که دختر را به آن برده بود، وارد شد. او نیزه را در بدن هر دو آنها فرو برد. به این ترتیب بلا رفع شد، ");
INSERT INTO pesopcb_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","در حالی که بیست و چهار هزار نفر از قوم اسرائیل در اثر آن بلا به هلاکت رسیده بودند. ");
INSERT INTO pesopcb_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","آنگاه خداوند به موسی فرمود: ");
INSERT INTO pesopcb_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","«فینحاس (پسر العازار و نوهٔ هارون کاهن) خشم مرا از بنی‌اسرائیل دور کرد. او با غیرت الهی حرمت مرا حفظ کرد، پس من هم قوم اسرائیل را نابود نکردم. ");
INSERT INTO pesopcb_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","پس به او بگو که من با او عهد سلامتی می‌بندم. ");
INSERT INTO pesopcb_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","به خاطر آنچه که او انجام داده است و برای غیرتی که جهت خدای خود دارد و به سبب اینکه با این عمل برای قوم اسرائیل کفاره نموده است، طبق این عهد، او و نسل او برای همیشه کاهن خواهند بود.» ");
INSERT INTO pesopcb_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","مردِ اسرائیلی که با آن دختر مدیانی کشته شد، زمری نام داشت؛ او پسر سالو، یکی از سران قبیلهٔ شمعون بود. ");
INSERT INTO pesopcb_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","آن دختر نیز کُزبی نام داشت؛ او دختر صور، یکی از بزرگان مدیان بود. ");
INSERT INTO pesopcb_vpl VALUES ("NU25_16‏","005_25_16‏","NUM","25","16‏","17","سپس خداوند به موسی فرمود: «مدیانیان را هلاک کنید، ");
INSERT INTO pesopcb_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","چون ایشان با حیله و نیرنگهایشان شما را نابود می‌کنند، آنها شما را به پرستش بعل فغور می‌کشانند و گمراه می‌نمایند، چنانکه واقعهٔ مرگ کزبی این را ثابت می‌کند.» ");
INSERT INTO pesopcb_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","پس از آنکه بلا رفع شد، خداوند به موسی و العازار (پسر هارون کاهن) فرمود: ");
INSERT INTO pesopcb_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","«تمامی مردان اسرائیل را از بیست سال به بالا سرشماری کنید تا معلوم شود از هر قبیله و طایفه چند نفر می‌توانند به جنگ بروند.» ");
INSERT INTO pesopcb_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","بنابراین وقتی ایشان در دشتهای موآب، کنار رود اردن، روبروی اریحا اردو زده بودند، موسی و العازار کاهن خطاب به ایشان گفتند: ");
INSERT INTO pesopcb_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","«قوم را از بیست ساله و بالاتر سرشماری کنید، همان‌گونه که خداوند به موسی فرمان داده بود.» اینانند اسرائیلیانی که از مصر بیرون آمدند: ");
INSERT INTO pesopcb_vpl VALUES ("NU26_5‏","005_26_5‏","NUM","26","5‏","11","قبیلهٔ رئوبین: ۴۳٬۷۳۰ نفر. (رئوبین پسر نخست‌زاده یعقوب بود.) طایفه‌های زیر جزو این قبیله بودند و به اسم پسران رئوبین نامگذاری شده بودند: طایفهٔ حنوکی‌ها، به نام جدشان حنوک؛ طایفهٔ فلوئی‌ها، به نام جدشان فلو؛ (خاندان الیاب که یکی از پسران فلو بود شامل خانواده‌های نموئیل، ابیرام و داتان بود. داتان و ابیرام همان دو رهبری بودند که با قورح علیه موسی و هارون توطئه نمودند و در حقیقت به خداوند اهانت کردند. ولی زمین دهان گشود و آنها را بلعید و آتش از جانب خداوند آمده، دویست و پنجاه نفر را سوزانید. این اخطاری بود به بقیهٔ قوم اسرائیل. اما پسران قورح کشته نشدند.) طایفهٔ حصرونی‌ها، به نام جدشان حصرون؛ طایفهٔ کرمی‌ها، به نام جدشان کرمی. ");
INSERT INTO pesopcb_vpl VALUES ("NU26_12‏","005_26_12‏","NUM","26","12‏","14","قبیلهٔ شمعون: ۲۲٬۲۰۰ نفر. طایفه‌های زیر جزو این قبیله بودند و به اسم پسران شمعون نامگذاری شده بودند: نموئیلی‌ها، به نام جدشان نموئیل؛ یامینی‌ها، به نام جدشان یامین؛ یاکینی‌ها، به نام جدشان یاکین؛ زارحی‌ها، به نام جدشان زارح؛ شائولی‌ها، به نام جدشان شائول. ");
INSERT INTO pesopcb_vpl VALUES ("NU26_15‏","005_26_15‏","NUM","26","15‏","18","قبیلهٔ جاد: ۴۰٬۵۰۰ نفر. طایفه‌های زیر جزو این قبیله بودند و به اسم پسران جاد نامگذاری شدند: صفونی‌ها، به نام جدشان صفون؛ حجی‌ها، به نام جدشان حجی؛ شونی‌ها، به نام جدشان شونی؛ اُزنی‌ها، به نام جدشان ازنی؛ عیری‌ها، به نام جدشان عیری؛ ارودی‌ها، به نام جدشان ارود؛ ارئیلی‌ها، به نام جدشان ارئیل. ");
INSERT INTO pesopcb_vpl VALUES ("NU26_19‏","005_26_19‏","NUM","26","19‏","22","قبیلهٔ یهودا: ۷۶٬۵۰۰ نفر. طایفه‌های زیر جزو این قبیله بودند و به اسم پسران یهودا نامگذاری شدند، ولی عیر و اونان که در سرزمین کنعان مردند جزو آنها نبودند: شیله‌ای‌ها به نام جدشان شیله؛ فارِصی‌ها، به نام جدشان فارِص؛ زارحی‌ها، به نام جدشان زارح. خاندانهای زیر جزو طایفهٔ فارص بودند: حصرونی‌ها، به نام جدشان حصرون؛ حامولی‌ها، به نام جدشان حامول. ");
INSERT INTO pesopcb_vpl VALUES ("NU26_23‏","005_26_23‏","NUM","26","23‏","25","قبیلهٔ یساکار: ۶۴٬۳۰۰ نفر. طایفه‌های زیر جزو این قبیله بودند و به اسم پسران یساکار نامگذاری شدند: تولعی‌ها، به نام جدشان تولع؛ فونی‌ها، به نام جدشان فوه؛ یاشوبی‌ها، به نام جدشان یاشوب؛ شمرونی‌ها، به نام جدشان شمرون. ");
INSERT INTO pesopcb_vpl VALUES ("NU26_26‏","005_26_26‏","NUM","26","26‏","27","قبیلهٔ زبولون: ۶۰٬۵۰۰ نفر. طایفه‌های زیر جزو این قبیله بودند و به اسم پسران زبولون نامگذاری شدند: سارَدی‌ها، به نام جدشان سارَد؛ ایلونی‌ها، به نام جدشان ایلون؛ یحلی‌ئیلی‌ها، به نام جدشان یحلی‌ئیل. ");
INSERT INTO pesopcb_vpl VALUES ("NU26_28‏","005_26_28‏","NUM","26","28‏","37","نسل یوسف: ۳۲٬۵۰۰ نفر در قبیلهٔ افرایم و ۵۲٬۷۰۰ نفر در قبیلهٔ منسی. در قبیلهٔ منسی طایفهٔ ماخیرها بودند که به نام جدشان ماخیر نامیده می‌شدند. طایفهٔ جلعادی‌ها نیز از ماخیر بودند و به اسم جدشان جلعاد نامیده می‌شدند. طایفه‌های زیر از جلعاد بودند: اِیعَزَری‌ها، به نام جدشان اِیعَزَر؛ حالقی‌ها، به نام جدشان حالق؛ اسری‌ئیلی‌ها، به نام جدشان اسری‌ئیل؛ شکیمی‌ها، به نام جدشان شکیم؛ شمیداعی‌ها، به نام جدشان شمیداع؛ حافری‌ها، به نام جدشان حافر. (صِلُفحاد پسر حافر پسری نداشت، اما پنج دختر داشت به نامهای محله، نوعه، حُجله، ملکه و ترصه.) تعداد ۳۲٬۵۰۰ نفر که زیر اسم قبیلهٔ افرایم ثبت شده بودند، شامل طایفه‌های زیر بودند که به اسم پسران افرایم نامیده می‌شدند: شوتالحی‌ها، به نام جدشان شوتالح؛ (یکی از طوایف شوتالحی‌ها، عیرانی‌ها بودند که به نام جدشان عیران نامیده می‌شدند.) باکری‌ها، به نام جدشان باکر؛ تاحَنی‌ها، به نام جدشان تاحَن. ");
INSERT INTO pesopcb_vpl VALUES ("NU26_38‏","005_26_38‏","NUM","26","38‏","41","قبیلهٔ بنیامین: ۴۵٬۶۰۰ نفر. طایفه‌های زیر جزو این قبیله بودند و به اسم پسران بنیامین نامگذاری شدند: بالعی‌ها، به نام جدشان بالع؛ (طایفه‌های زیر از بالع بودند: اردی‌ها، به نام جدشان ارد؛ نَعمانی‌ها، به نام جدشان نَعمان.) اشبیلی‌ها، به نام جدشان اشبیل؛ احیرامی‌ها، به نام جدشان احیرام؛ شفوفامی‌ها، به نام جدشان شفوفام؛ حوفامی‌ها، به نام جدشان حوفام. ");
INSERT INTO pesopcb_vpl VALUES ("NU26_42‏","005_26_42‏","NUM","26","42‏","43","قبیلهٔ دان: ۶۴٬۴۰۰ نفر. در این قبیله طایفهٔ شوحامی‌ها بودند که نام جدشان شوحام پسر دان بر آنها گذاشته شده بود. ");
INSERT INTO pesopcb_vpl VALUES ("NU26_44‏","005_26_44‏","NUM","26","44‏","47","قبیلهٔ اشیر: ۵۳٬۴۰۰ نفر. طایفه‌های زیر جزو این قبیله بودند و به اسم پسران اشیر نامگذاری شدند: یمنی‌ها، به نام جدشان یمنه؛ یشوی‌ها، به نام جدشان یشوی؛ بریعیی‌ها، به نام جدشان بریعه؛ طایفه‌های زیر از بریعه بودند: حابری‌ها، به نام جدشان حابر؛ ملکی‌ئیلی‌ها، به نام جدشان ملکی‌ئیل. اشیر دختری نیز داشت به نام سارح. ");
INSERT INTO pesopcb_vpl VALUES ("NU26_48‏","005_26_48‏","NUM","26","48‏","50","قبیلهٔ نفتالی: ۴۵٬۴۰۰ نفر. طایفه‌های زیر جزو این قبیله بودند و به اسم پسران نفتالی نامگذاری شدند: یاحص‌ئیلی‌ها، به نام جدشان یاحص‌ئیل؛ جونی‌ها، به نام جدشان جونی؛ یصری‌ها، به نام جدشان یصر؛ شلیمی‌ها، به نام جدشان شلیم. ");
INSERT INTO pesopcb_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","پس تعداد کل مردان قوم اسرائیل ۶۰۱٬۷۳۰ نفر بود. ");
INSERT INTO pesopcb_vpl VALUES ("NU26_52‏","005_26_52‏","NUM","26","52‏","54","سپس خداوند به موسی فرمود: «این سرزمین را بین قبایل به نسبت جمعیت آنها تقسیم کن. به قبیله‌های بزرگتر زمین بیشتر و به قبیله‌های کوچکتر زمین کمتر داده شود. ");
INSERT INTO pesopcb_vpl VALUES ("NU26_55‏","005_26_55‏","NUM","26","55‏","56","نمایندگان قبایل بزرگتر برای زمینهای بزرگتر و قبایل کوچکتر برای زمینهای کوچکتر قرعه بکشند.» ");
INSERT INTO pesopcb_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","قبایل لاویان که سرشماری شدند از این قرارند: جرشونی‌ها، به نام جدشان جرشون؛ قهاتی‌ها، به نام جدشان قهات؛ مراری‌ها، به نام جدشان مراری. ");
INSERT INTO pesopcb_vpl VALUES ("NU26_58‏","005_26_58‏","NUM","26","58‏","59","این طایفه‌ها نیز جزو قبیلهٔ لاوی بودند: لبنی‌ها، حبرونی‌ها، محلی‌ها، موشی‌ها و قورحی‌ها. زمانی که لاوی در مصر بود صاحب دختری به نام یوکابد شد که بعد به همسری عمرام، پسر قهات، درآمد. یوکابد و عمرام پدر و مادر هارون و موسی و مریم بودند. ");
INSERT INTO pesopcb_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","ناداب و ابیهو و العازار و ایتامار فرزندان هارون بودند. ");
INSERT INTO pesopcb_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","ناداب و ابیهو وقتی آتش غیر مجاز به حضور خداوند تقدیم کردند مردند. ");
INSERT INTO pesopcb_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","تعداد کل پسران و مردان قبیلهٔ لاوی از یک ماهه به بالا در سرشماری ۲۳٬۰۰۰ نفر بود. ولی تعداد لاویان در جمع کل سرشماری قوم اسرائیل منظور نمی‌شد، زیرا از سرزمین اسرائیل زمینی به ایشان تعلق نمی‌گرفت. ");
INSERT INTO pesopcb_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","این است ارقام سرشماری‌ای که توسط موسی و العازار کاهن، در دشت موآب کنار رود اردن و در مقابل اریحا به دست آمد. ");
INSERT INTO pesopcb_vpl VALUES ("NU26_64‏","005_26_64‏","NUM","26","64‏","65","در تمام این سرشماری، حتی یک نفر وجود نداشت که در سرشماری قبلی که در صحرای سینا توسط موسی و هارون کاهن به عمل آمده بود شمرده شده باشد، زیرا تمام کسانی که در آن وقت شمرده شده بودند در بیابان مرده بودند، درست همان‌طور که خداوند گفته بود. تنها افرادی که زنده مانده بودند کالیب پسر یفنه و یوشع پسر نون بودند. ");
INSERT INTO pesopcb_vpl VALUES ("NU27_1‏","005_27_1‏","NUM","27","1‏","2","روزی دختران صلفحاد به نامهای محله، نوعه، حجله، ملکه و ترصه به در خیمهٔ ملاقات آمدند تا تقاضای خودشان را به موسی و العازار کاهن و رهبران قبایل و سایر کسانی که در آنجا بودند تقدیم کنند. این زنان از قبیلهٔ منسی (یکی از پسران یوسف) بودند. صلفحاد پسر حافر بود، حافر پسر جلعاد، جلعاد پسر ماخیر و ماخیر پسر منسی. ");
INSERT INTO pesopcb_vpl VALUES ("NU27_3‏","005_27_3‏","NUM","27","3‏","4","دختران صلفحاد گفتند: «پدر ما در بیابان مرد. او از پیروان قورح نبود که بر ضد خداوند قیام کردند و هلاک شدند. او به سبب گناه خود مرد و پسری نداشت. چرا باید اسم پدرمان به دلیل اینکه پسری نداشته است از میان قبیله‌اش محو گردد؟ باید به ما هم مثل برادران پدرمان ملکی داده شود.» ");
INSERT INTO pesopcb_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","پس موسی دعوی ایشان را به حضور خداوند آورد. ");
INSERT INTO pesopcb_vpl VALUES ("NU27_6‏","005_27_6‏","NUM","27","6‏","7","خداوند در جواب موسی فرمود: «دختران صلفحاد راست می‌گویند. در میان املاک عموهایشان، به آنها ملک بده. همان ملکی را به ایشان بده که اگر پدرشان زنده بود به او می‌دادی. ");
INSERT INTO pesopcb_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","به بنی‌اسرائیل بگو که هرگاه مردی بمیرد و پسری نداشته باشد، ملک او به دخترانش می‌رسد، ");
INSERT INTO pesopcb_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","و اگر دختری نداشته باشد ملک او متعلق به برادرانش خواهد بود. ");
INSERT INTO pesopcb_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","اگر برادری نداشته باشد آنگاه عمویش وارث او خواهد شد، ");
INSERT INTO pesopcb_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","و اگر عمو نداشته باشد، در آن صورت ملک او به نزدیکترین فامیلش می‌رسد. بنی‌اسرائیل باید این قانون را رعایت کنند، همان‌طور که من به تو امر کرده‌ام.» ");
INSERT INTO pesopcb_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","روزی خداوند به موسی فرمود: «به کوه عباریم برو و از آنجا سرزمینی را که به قوم اسرائیل داده‌ام ببین. ");
INSERT INTO pesopcb_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","پس از اینکه آن را دیدی مانند برادرت هارون خواهی مرد و به اجداد خود خواهی پیوست، ");
INSERT INTO pesopcb_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","زیرا در بیابان صین هر دو شما از دستور من سرپیچی کردید. وقتی که قوم اسرائیل بر ضد من قیام کردند، در حضور آنها حرمت قدوسیت مرا نگه نداشتید.» (این واقعه در کنار چشمهٔ مریبه در قادش واقع در بیابان صین اتفاق افتاده بود.) ");
INSERT INTO pesopcb_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","موسی به خداوند عرض کرد: ");
INSERT INTO pesopcb_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","«ای خداوند، خدای روحهای تمامی افراد بشر، پیش از آنکه بمیرم التماس می‌کنم برای قوم اسرائیل رهبر جدیدی تعیین فرمایی، ");
INSERT INTO pesopcb_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","مردی که ایشان را هدایت کند و از آنان مراقبت نماید تا قوم خداوند مثل گوسفندان بی‌شبان نباشند.» ");
INSERT INTO pesopcb_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","خداوند جواب داد: «برو و دست خود را بر یوشع پسر نون که روح من در اوست، بگذار. ");
INSERT INTO pesopcb_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","سپس او را نزد العازار کاهن ببر و پیش چشم تمامی قوم اسرائیل او را به رهبری قوم تعیین نما. ");
INSERT INTO pesopcb_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","اختیارات خود را به او بده تا تمام قوم اسرائیل او را اطاعت کنند. ");
INSERT INTO pesopcb_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","او برای دستور گرفتن از من باید پیش العازار کاهن برود. من به‌وسیلۀ اوریم با العازار سخن خواهم گفت و العازار دستورهای مرا به یوشع و قوم اسرائیل ابلاغ خواهد کرد. به این طریق من آنان را هدایت خواهم نمود.» ");
INSERT INTO pesopcb_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","پس موسی، همان‌طور که خداوند امر کرده بود عمل نمود و یوشع را پیش العازار کاهن برد. سپس در حضور همهٔ قوم اسرائیل، ");
INSERT INTO pesopcb_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","دستهایش را بر سر او گذاشت و طبق فرمان خداوند وی را به عنوان رهبر قوم تعیین نمود. ");
INSERT INTO pesopcb_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","خداوند به موسی گفت: ");
INSERT INTO pesopcb_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","«این دستورها را به قوم اسرائیل بده: باید هدایای طعام مرا به عنوان هدایای مخصوص و خوشبو به من تقدیم کنید. پس ترتیبی بدهید که این قربانیها را به موقع آورده، طبق دستور من تقدیم کنید. ");
INSERT INTO pesopcb_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","«همچنین به ایشان بگو: قربانی‌ای که بر آتش به من تقدیم می‌کنید باید از بره‌های نر یک ساله و بی‌عیب باشد. هر روز دو تا از آنها را به عنوان قربانی سوختنی تقدیم کنید. ");
INSERT INTO pesopcb_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","یک بره صبح باید قربانی شود و دیگری عصر. ");
INSERT INTO pesopcb_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","با آنها یک کیلو آرد مرغوب که با یک لیتر روغن زیتون مخلوط شده باشد، به عنوان هدیهٔ آردی، تقدیم شود. ");
INSERT INTO pesopcb_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","این است قربانی سوختنی که در کوه سینا تعیین گردید تا هر روز به عنوان هدیۀ خوشبو و مخصوص به خداوند تقدیم شود. ");
INSERT INTO pesopcb_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","همراه با آن، هدیه نوشیدنی نیز باید تقدیم گردد که شامل یک لیتر شراب با هر بره بوده و بایستی در قدس در حضور خداوند ریخته شود. ");
INSERT INTO pesopcb_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","برۀ دیگر را هنگام عصر همراه با همان هدیه آردی و نوشیدنی تقدیم کنند. این قربانی، هدیه‌ای خوشبو و مخصوص برای خداوند خواهد بود. ");
INSERT INTO pesopcb_vpl VALUES ("NU28_9‏","005_28_9‏","NUM","28","9‏","10","«در روز شَبّات علاوه بر قربانی سوختنی روزانه و هدیه نوشیدنی آن، دو برهٔ بی‌عیبِ یک ساله نیز قربانی شود. با این قربانی باید هدیهٔ آردی که شامل دو کیلو آرد مخلوط با روغن است، و هدیهٔ نوشیدنی آن تقدیم شود. ");
INSERT INTO pesopcb_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","«همچنین در روز اول هر ماه، باید قربانی سوختنی دیگری نیز به خداوند تقدیم شود که شامل دو گوسالۀ نر، یک قوچ و هفت برهٔ نر یک ساله است که همهٔ آنها باید سالم و بی‌عیب باشند. ");
INSERT INTO pesopcb_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","برای هر گاو سه کیلو آرد مخلوط با روغن به عنوان هدیه آردی، برای قوچ دو کیلو، ");
INSERT INTO pesopcb_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","و برای هر بره یک کیلو تقدیم شود. این قربانی سوختنی، هدیه‌ای خوشبو و مخصوص برای خداوند خواهد بود. ");
INSERT INTO pesopcb_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","با هر گاو دو لیتر شراب به عنوان هدیهٔ نوشیدنی، با قوچ یک و نیم لیتر شراب، و با هر بره یک لیتر شراب تقدیم شود. این است قربانی سوختنی ماهانه که باید در طول سال تقدیم شود. ");
INSERT INTO pesopcb_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","«همچنین در روز اول هر ماه یک بز نر برای قربانی گناه به خداوند تقدیم کنید. این قربانی غیر از قربانی سوختنی روزانه و هدیهٔ نوشیدنی آن است. ");
INSERT INTO pesopcb_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","«در روز چهاردهمِ اولین ماه هر سال، مراسم پِسَح را به احترام خداوند بجا آورید. ");
INSERT INTO pesopcb_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","از روز پانزدهم به مدت یک هفته جشن مقدّسی بر پا گردد، ولی در این جشن فقط نان فطیر (نان بدون خمیرمایه) خورده شود. ");
INSERT INTO pesopcb_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","در روز اول این جشن مقدّس، همهٔ شما به عبادت بپردازید و هیچ کار دیگری نکنید. ");
INSERT INTO pesopcb_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","در این روز دو گوسالۀ نر، یک قوچ و هفت برهٔ نر یک ساله که همه سالم و بی‌عیب باشند به عنوان قربانی سوختنی، بر آتش به خداوند تقدیم کنید. ");
INSERT INTO pesopcb_vpl VALUES ("NU28_20‏","005_28_20‏","NUM","28","20‏","21","با هر گاو سه کیلو آرد مخلوط با روغن به عنوان هدیهٔ آردی، با قوچ دو کیلو، و با هر بره یک کیلو هدیه کنید. ");
INSERT INTO pesopcb_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","یک بز نر هم برای کفارهٔ گناهانتان قربانی کنید. ");
INSERT INTO pesopcb_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","اینها غیر از قربانی سوختنی است که هر روز صبح تقدیم می‌شود. ");
INSERT INTO pesopcb_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","در آن یک هفتهٔ عید، باید روزانه هدیۀ طعام را همچون هدیۀ مخصوص و به عنوان هدیۀ خوشبو به خداوند تقدیم کنید. اینها علاوه بر قربانی سوختنی و هدیهٔ نوشیدنی دائمی است. ");
INSERT INTO pesopcb_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","در روز هفتم این جشن مقدّس نیز همهٔ شما به عبادت مشغول باشید و هیچ کار دیگری نکنید. ");
INSERT INTO pesopcb_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","«در روز عید نوبرها که اولین نوبر محصول غلهٔ خود را به خداوند تقدیم می‌کنید، همهٔ شما جمع شده، به عبادت مشغول شوید و هیچ کار دیگری نکنید. ");
INSERT INTO pesopcb_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","در آن روز دو گوسالۀ نر، یک قوچ و هفت برهٔ نر یک ساله به عنوان قربانی سوختنی به خداوند تقدیم کنید. این قربانی، همچون هدیۀ خوشبو برای خداوند است. ");
INSERT INTO pesopcb_vpl VALUES ("NU28_28‏","005_28_28‏","NUM","28","28‏","29","با هر گاو سه کیلو آرد مخلوط با روغن به عنوان هدیهٔ آردی، با قوچ دو کیلو، و با هر بره یک کیلو هدیه کنید. ");
INSERT INTO pesopcb_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","همچنین برای کفارهٔ گناهانتان یک بز نر قربانی کنید. ");
INSERT INTO pesopcb_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","این قربانیها را همراه با هدایای نوشیدنی آنها تقدیم کنید. اینها غیر از قربانی سوختنی روزانه است که با هدایای آردی آن تقدیم می‌شود. دقت نمایید حیواناتی که قربانی می‌کنید سالم و بی‌عیب باشند. ");
INSERT INTO pesopcb_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","«عید شیپورها، روز اول ماه هفتم هر سال برگزار شود. در آن روز باید همهٔ شما برای عبادت جمع شوید و هیچ کار دیگری انجام ندهید. ");
INSERT INTO pesopcb_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","در آن روز یک گوسالۀ نر، یک قوچ و هفت برهٔ نر یک ساله که همگی سالم و بی‌عیب باشند به عنوان قربانی سوختنی تقدیم کنید. این قربانی، هدیه‌ای خوشبو برای خداوند خواهد بود. ");
INSERT INTO pesopcb_vpl VALUES ("NU29_3‏","005_29_3‏","NUM","29","3‏","4","با گاو سه کیلو آرد مخلوط با روغن به عنوان هدیه آردی، با قوچ دو کیلو، و با هر بره یک کیلو هدیه شود. ");
INSERT INTO pesopcb_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","یک بز نر هم برای کفارهٔ گناهانتان قربانی کنید. ");
INSERT INTO pesopcb_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","اینها غیر از قربانی سوختنی ماهانه با هدیهٔ آردی آن و نیز غیر از قربانی سوختنی روزانه با هدیهٔ آردی و نوشیدنی آن است که طبق مقررات مربوط تقدیم می‌گردند. این قربانیها، هدایای خوشبو و مخصوص برای خداوند خواهند بود. ");
INSERT INTO pesopcb_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","«در روز دهم ماه هفتم، دوباره برای عبادت جمع شوید. در آن روز، روزه بگیرید و هیچ کار دیگری انجام ندهید. ");
INSERT INTO pesopcb_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","یک گوسالۀ نر، یک قوچ و هفت برهٔ نر یک ساله که همگی سالم و بی‌عیب باشند به عنوان قربانی سوختنی تقدیم کنید. این قربانی، مورد پسند خداوند واقع خواهد شد. ");
INSERT INTO pesopcb_vpl VALUES ("NU29_9‏","005_29_9‏","NUM","29","9‏","10","با گاو سه کیلو آرد مخلوط با روغن به عنوان هدیه آردی، با قوچ دو کیلو، و با هر بره یک کیلو تقدیم شود. ");
INSERT INTO pesopcb_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","علاوه بر قربانی روز کفاره، و نیز قربانی سوختنی روزانه که با هدایای آردی و نوشیدنی آن تقدیم می‌شوند، یک بز نر هم برای کفارهٔ گناه قربانی کنید. ");
INSERT INTO pesopcb_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","«در روز پانزدهم ماه هفتم، دوباره برای عبادت جمع شوید و در آن روز هیچ کار دیگری انجام ندهید. این آغاز یک عید هفت روزه در حضور خداوند است. ");
INSERT INTO pesopcb_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","در روز اول عید، سیزده گوسالۀ نر، دو قوچ و چهارده برهٔ نر یک ساله که همگی سالم و بی‌عیب باشند به عنوان قربانی سوختنی تقدیم کنید. این قربانی که بر آتش تقدیم می‌شود، مورد پسند خداوند واقع خواهد شد. ");
INSERT INTO pesopcb_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","با هر گاو سه کیلو آرد مخلوط با روغن به عنوان هدیهٔ آردی، با هر قوچ دو کیلو ");
INSERT INTO pesopcb_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","و با هر بره یک کیلو تقدیم می‌شود. ");
INSERT INTO pesopcb_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","علاوه بر قربانی سوختنی روزانه و هدایای آردی و نوشیدنی آن، یک بز نر هم برای کفارهٔ گناه، قربانی شود. ");
INSERT INTO pesopcb_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","«در روز دوم عید، دوازده گوسالۀ نر، دو قوچ و چهارده برهٔ نر یک ساله که همه سالم و بی‌عیب باشند قربانی کنید. ");
INSERT INTO pesopcb_vpl VALUES ("NU29_18‏","005_29_18‏","NUM","29","18‏","19","همراه آنها قربانی و هدایای مربوطه نیز مانند روز اول تقدیم نمایید. ");
INSERT INTO pesopcb_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","«در روز سوم عید، یازده گوسالۀ نر، دو قوچ و چهارده برهٔ نر یک ساله که همه سالم و بی‌عیب باشند قربانی کنید. ");
INSERT INTO pesopcb_vpl VALUES ("NU29_21‏","005_29_21‏","NUM","29","21‏","22","همراه آنها قربانی و هدایای مربوطه نیز مانند روز اول تقدیم نمایید. ");
INSERT INTO pesopcb_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","«در روز چهارم عید، ده گوسالۀ نر، دو قوچ و چهارده برهٔ نر یک ساله که همه سالم و بی‌عیب باشند قربانی کنید. ");
INSERT INTO pesopcb_vpl VALUES ("NU29_24‏","005_29_24‏","NUM","29","24‏","25","همراه آنها قربانی و هدایای مربوطه نیز مانند روز اول تقدیم نمایید. ");
INSERT INTO pesopcb_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","«در روز پنجم عید، نه گوسالۀ نر، دو قوچ و چهارده برهٔ نر یک ساله که همه سالم و بی‌عیب باشند قربانی کنید. ");
INSERT INTO pesopcb_vpl VALUES ("NU29_27‏","005_29_27‏","NUM","29","27‏","28","همراه آنها قربانی و هدایای مربوطه نیز مانند روز اول تقدیم نمایید. ");
INSERT INTO pesopcb_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","«در روز ششم عید، هشت گوسالۀ نر، دو قوچ و چهارده برهٔ نر یک ساله که همه سالم و بی‌عیب باشند قربانی کنید. ");
INSERT INTO pesopcb_vpl VALUES ("NU29_30‏","005_29_30‏","NUM","29","30‏","31","همراه آنها قربانی و هدایای مربوطه نیز مانند روز اول تقدیم نمایید. ");
INSERT INTO pesopcb_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","«در روز هفتم عید، هفت گوسالۀ نر، دو قوچ و چهارده برهٔ نر یک ساله که همه سالم و بی‌عیب باشند قربانی کنید. ");
INSERT INTO pesopcb_vpl VALUES ("NU29_33‏","005_29_33‏","NUM","29","33‏","34","همراه آنها قربانی و هدایای مربوطه نیز مانند روز اول تقدیم نمایید. ");
INSERT INTO pesopcb_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","«در روز هشتم، قوم اسرائیل را برای عبادت جمع کنید و در آن روز هیچ کار دیگری انجام ندهید. ");
INSERT INTO pesopcb_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","یک گوسالۀ نر، یک قوچ و هفت برهٔ نر یک ساله که همگی سالم و بی‌عیب باشند به عنوان قربانی سوختنی تقدیم کنید. این قربانی که بر آتش تقدیم می‌شود، مورد پسند خداوند واقع خواهد شد. ");
INSERT INTO pesopcb_vpl VALUES ("NU29_37‏","005_29_37‏","NUM","29","37‏","38","همراه آنها قربانی و هدایای مربوطه نیز مانند روز اول تقدیم نمایید. ");
INSERT INTO pesopcb_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","«این بود قوانین مربوط به قربانی سوختنی، هدیهٔ آردی، هدیه نوشیدنی و قربانی سلامتی که شما باید در روزهای مخصوص به خداوند تقدیم نمایید. این قربانیها غیر از قربانیهای نذری و قربانیهای داوطلبانه است.» ");
INSERT INTO pesopcb_vpl VALUES ("NU29_40","005_29_40","NUM","29","40","40","موسی تمام این دستورهای خداوند را به قوم اسرائیل ابلاغ نمود. ");
INSERT INTO pesopcb_vpl VALUES ("NU30_1‏","005_30_1‏","NUM","30","1‏","2","موسی رهبران قبایل را جمع کرد و این دستورها را از جانب خداوند به ایشان داد: «هرگاه کسی برای خداوند نذر کند یا تعهدی نماید، حق ندارد قول خود را بشکند بلکه باید آنچه را که قول داده است بجا آورد. ");
INSERT INTO pesopcb_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","«هرگاه دختری که هنوز در خانهٔ پدرش زندگی می‌کند، برای خداوند نذر کند یا تعهدی نماید، ");
INSERT INTO pesopcb_vpl VALUES ("NU30_4‏","005_30_4‏","NUM","30","4‏","5","باید هر چه را قول داده است ادا نماید مگر اینکه وقتی پدرش آن را بشنود او را منع کند. در این صورت، نذر دختر خودبه‌خود باطل می‌شود و خداوند او را می‌بخشد، چون پدرش به او اجازه نداده است به آن عمل کند. ولی اگر پدرش در روزی که از نذر یا تعهد دخترش آگاه می‌شود، سکوت کند، دختر ملزم به ادای قول خویش می‌باشد. ");
INSERT INTO pesopcb_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","«اگر زنی قبل از ازدواج نذری کرده و یا با قول نسنجیده‌ای خود را متعهد کرده باشد، ");
INSERT INTO pesopcb_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","و شوهرش از قول او باخبر شود و در همان روزی که شنید چیزی نگوید، نذر او به قوت خود باقی خواهد ماند. ");
INSERT INTO pesopcb_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","ولی اگر شوهرش نذر یا تعهد او را قبول نکند، مخالفت شوهر نذر او را باطل می‌سازد و خداوند آن زن را می‌بخشد. ");
INSERT INTO pesopcb_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","اما اگر زن بیوه‌ای یا زنی که طلاق داده شده باشد، نذر یا تعهدی کند، باید آن را ادا نماید. ");
INSERT INTO pesopcb_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","«اگر زنی ازدواج کرده باشد و در خانهٔ شوهرش نذر یا تعهدی کند، ");
INSERT INTO pesopcb_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","و شوهرش از این امر با اطلاع شود و چیزی نگوید، نذر یا تعهد او به قوت خود باقی خواهد بود. ");
INSERT INTO pesopcb_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","ولی اگر شوهرش در آن روزی که باخبر می‌شود به او اجازه ندهد نذر یا تعهدش را به جا آورد، نذر یا تعهد آن زن باطل می‌شود و خداوند او را خواهد بخشید، چون شوهرش به او اجازه نداده است به آن عمل کند. ");
INSERT INTO pesopcb_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","پس شوهر او حق دارد نذر یا تعهد او را تأیید یا باطل نماید. ");
INSERT INTO pesopcb_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","ولی اگر در روزی که شنید چیزی نگوید، معلوم می‌شود با آن موافقت کرده است. ");
INSERT INTO pesopcb_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","اگر بیش از یک روز صبر نموده، بعد نذر او را باطل سازد، شوهر مسئول گناه زنش است.» ");
INSERT INTO pesopcb_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","اینها دستورهایی است که خداوند به موسی داد، در مورد ادای نذر یا تعهد دختری که در خانهٔ پدرش زندگی می‌کند یا زنی که شوهر دارد. ");
INSERT INTO pesopcb_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","خداوند به موسی فرمود: ");
INSERT INTO pesopcb_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","«از مدیانیان به دلیل اینکه قوم اسرائیل را به بت‌پرستی کشاندند انتقام بگیر. پس از آن، تو خواهی مرد و به اجداد خود خواهی پیوست.» ");
INSERT INTO pesopcb_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","پس موسی به قوم اسرائیل گفت: «عده‌ای از شما باید مسلح شوید تا انتقام خداوند را از مدیانیان بگیرید. ");
INSERT INTO pesopcb_vpl VALUES ("NU31_4‏","005_31_4‏","NUM","31","4‏","6","از هر قبیله هزار نفر برای جنگ بفرستید.» این کار انجام شد و از میان هزاران هزار اسرائیلی، موسی دوازده هزار مرد مسلح به جنگ فرستاد. صندوق عهد خداوند و شیپورهای جنگ نیز همراه فینحاس پسر العازار کاهن به میدان جنگ فرستاده شدند. ");
INSERT INTO pesopcb_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","آنها همان‌گونه که خداوند به موسی فرموده بود با مدیانیان جنگیدند و تمامی مردان مدیان در جنگ کشته شدند. ");
INSERT INTO pesopcb_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","پنج پادشاه مدیان به نامهای اَوی، راقم، صور، حور و رابع در میان کشته‌شدگان بودند. بلعام پسر بعور نیز با شمشیر کشته شد. ");
INSERT INTO pesopcb_vpl VALUES ("NU31_9‏","005_31_9‏","NUM","31","9‏","11","آنگاه سپاه اسرائیل تمام زنان و بچه‌ها را به اسیری گرفته، گله‌ها و رمه‌ها و اموالشان را غارت کردند. سپس همهٔ شهرها، روستاها و قلعه‌های مدیان را آتش زدند. ");
INSERT INTO pesopcb_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","آنها اسیران و غنایم جنگی را پیش موسی و العازار کاهن و بقیهٔ قوم اسرائیل آوردند که در دشت موآب کنار رود اردن، روبروی شهر اریحا اردو زده بودند. ");
INSERT INTO pesopcb_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","موسی و العازار کاهن و همهٔ رهبران قوم به استقبال سپاه اسرائیل رفتند، ");
INSERT INTO pesopcb_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","ولی موسی بر فرماندهان سپاه که از جنگ برگشته بودند، خشمگین شد ");
INSERT INTO pesopcb_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","و از آنها پرسید: «چرا زنها را زنده گذاشته‌اید؟ ");
INSERT INTO pesopcb_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","اینها همان کسانی هستند که نصیحت بلعام را گوش کردند و قوم اسرائیل را در فغور به بت‌پرستی کشاندند و جماعت خداوند را دچار بلا کردند. ");
INSERT INTO pesopcb_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","پس تمامی پسران و زنانی را که با مردی همبستر شده‌اند بکشید. ");
INSERT INTO pesopcb_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","فقط دخترهای باکره را برای خود زنده نگه دارید. ");
INSERT INTO pesopcb_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","حال، هر کدام از شما که کسی را کشته یا کشته‌ای را لمس کرده، مدت هفت روز از اردوگاه بیرون بماند. بعد در روزهای سوم و هفتم، خود و اسیرانتان را طاهر سازید. ");
INSERT INTO pesopcb_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","همچنین به یاد داشته باشید که همهٔ لباسهای خود و هر چه را که از چرم، پشم بز و چوب ساخته شده، طاهر سازید.» ");
INSERT INTO pesopcb_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","آنگاه العازار کاهن به مردانی که به جنگ رفته بودند گفت: «قانونی که خداوند به موسی داده چنین است: ");
INSERT INTO pesopcb_vpl VALUES ("NU31_22‏","005_31_22‏","NUM","31","22‏","23","طلا، نقره، مفرغ، آهن، روی، سرب و یا هر چیز دیگری را که در آتش نمی‌سوزد، باید از آتش بگذرانید و با آب طهارت، آن را طاهر سازید. ولی هر چیزی که در آتش می‌سوزد، باید فقط به‌وسیلۀ آب طاهر گردد. ");
INSERT INTO pesopcb_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","روز هفتم باید لباسهای خود را شسته، طاهر شوید و پس از آن به اردوگاه بازگردید.» ");
INSERT INTO pesopcb_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","خداوند به موسی فرمود: ");
INSERT INTO pesopcb_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","«تو و العازار کاهن و رهبران قبایل اسرائیل باید از تمام غنایم جنگی، چه انسان و چه حیواناتی که آورده‌اید، صورت برداری کنید. ");
INSERT INTO pesopcb_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","بعد آنها را به دو قسمت تقسیم کنید. نصف آن را به سپاهیانی بدهید که به جنگ رفته‌اند و نصف دیگر را به بقیهٔ قوم اسرائیل. ");
INSERT INTO pesopcb_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","از همهٔ اسیران، گاوها، الاغها و گوسفندهایی که به سپاهیان تعلق می‌گیرد، یک در پانصد سهم خداوند است. ");
INSERT INTO pesopcb_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","این سهم را به العازار کاهن بدهید تا آن را به عنوان هدیهٔ مخصوص به خداوند تقدیم نماید. ");
INSERT INTO pesopcb_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","همچنین از تمامی اسیران، گاوها، الاغها و گوسفندهایی که به قوم اسرائیل داده شده است یکی از پنجاه بگیرید و آن را به لاویانی که مسئول خیمهٔ عبادت خداوند هستند بدهید.» ");
INSERT INTO pesopcb_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","پس موسی و العازار همان‌طور که خداوند دستور داده بود عمل کردند. ");
INSERT INTO pesopcb_vpl VALUES ("NU31_32‏","005_31_32‏","NUM","31","32‏","35","همهٔ غنایم (غیر از چیزهایی که سربازان برای خود نگه داشته بودند) ۳۲٬۰۰۰ دختر باکره، ۶۷۵٬۰۰۰ گوسفند، ۷۲٬۰۰۰ گاو و ۶۱٬۰۰۰ الاغ بود. ");
INSERT INTO pesopcb_vpl VALUES ("NU31_36‏","005_31_36‏","NUM","31","36‏","40","نصف کل غنیمت، که به سپاهیان داده شد، از این قرار بود: ‏ ۱۶٬۰۰۰ دختر (۳۲ دختر به خداوند داده شد)، ‏ ۳۳۷٬۵۰۰ رأس گوسفند (۶۷۵ رأس از آن به خداوند داده شد)، ‏ ۳۶٬۰۰۰ رأس گاو (۷۲ رأس از آن به خداوند داده شد)، ‏ ۳۰٬۵۰۰ رأس الاغ (۶۱ رأس از آن به خداوند داده شد). ");
INSERT INTO pesopcb_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","همان‌طور که خداوند به موسی امر کرده بود، تمامی سهم خداوند به العازار کاهن داده شد. ");
INSERT INTO pesopcb_vpl VALUES ("NU31_42‏","005_31_42‏","NUM","31","42‏","46","سهم بقیهٔ قوم اسرائیل که موسی از سهم مردان جنگی جدا کرده بود، با سهم سپاهیان برابر و از این قرار بود: ۱۶٬۰۰۰ دختر، ۳۳۷٬۵۰۰ رأس گوسفند، ۳۶٬۰۰۰ رأس گاو، ۳۰٬۵۰۰ رأس الاغ. ");
INSERT INTO pesopcb_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","طبق اوامر خداوند، موسی یک در پنجاه از اینها را به لاویان که عهده‌دار کارهای خیمه بودند، داد. ");
INSERT INTO pesopcb_vpl VALUES ("NU31_48‏","005_31_48‏","NUM","31","48‏","49","بعد فرماندهان سپاه پیش موسی آمده، گفتند: «ما تمام افرادی را که به جنگ رفته بودند شمرده‌ایم. حتی یک نفر از ما کشته نشده است. ");
INSERT INTO pesopcb_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","بنابراین از زیورهای طلا، بازوبندها، دست‌بندها، انگشترها، گوشواره‌ها و گردن‌بندهایی که به غنیمت گرفته‌ایم هدیهٔ شکرگزاری برای خداوند آورده‌ایم تا خداوند جانهای ما را حفظ کند.» ");
INSERT INTO pesopcb_vpl VALUES ("NU31_51‏","005_31_51‏","NUM","31","51‏","52","موسی و العازار این هدیه را که فرماندهان سپاه برای خداوند آورده بودند قبول کردند. وزن کل آن حدود دویست کیلوگرم بود. ");
INSERT INTO pesopcb_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","(سربازان غنایم خود را برای خودشان نگه داشته بودند.) ");
INSERT INTO pesopcb_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","موسی و العازار آن هدیه را به خیمهٔ ملاقات بردند تا آن هدیه در آنجا یادآور قوم اسرائیل در حضور خداوند باشد. ");
INSERT INTO pesopcb_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","وقتی قوم اسرائیل به سرزمین یعزیر و جلعاد رسیدند، قبیله‌های رئوبین و جاد که صاحب گله‌های بزرگ بودند، متوجه شدند که آنجا برای نگهداری گله، محل بسیار مناسبی است. ");
INSERT INTO pesopcb_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","بنابراین نزد موسی و العازار کاهن و سایر رهبران قبایل آمده، گفتند: ");
INSERT INTO pesopcb_vpl VALUES ("NU32_3‏","005_32_3‏","NUM","32","3‏","4","«خداوند این سرزمین را به قوم اسرائیل داده است، یعنی شهرهای عطاروت، دیبون، یعزیر، نِمرَه، حشبون، العاله، شبام، نبو، و بعون. این سرزمین برای گله‌های ما بسیار مناسب است. ");
INSERT INTO pesopcb_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","تقاضا داریم به جای سهم ما در آن سوی رود اردن، این زمینها را به ما بدهید.» ");
INSERT INTO pesopcb_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","موسی از ایشان پرسید: «آیا منظورتان این است که شما همین‌جا بنشینید و برادرانتان به آن طرف رود اردن رفته، بجنگند؟ ");
INSERT INTO pesopcb_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","آیا می‌خواهید بقیهٔ قوم را از رفتن به آن طرف رود اردن و ورود به سرزمینی که خداوند به ایشان داده است دلسرد کنید؟ ");
INSERT INTO pesopcb_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","این همان کاری است که پدران شما کردند. از قادش برنیع ایشان را فرستادم تا سرزمین موعود را بررسی کنند، ");
INSERT INTO pesopcb_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","اما وقتی به درهٔ اشکول رسیدند و آن سرزمین را دیدند، بازگشتند و قوم را از رفتن به سرزمینی که خداوند به ایشان وعده داده بود دلسرد نمودند. ");
INSERT INTO pesopcb_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","به همین علّت خشم خداوند افروخته شد و قسم خورد که ");
INSERT INTO pesopcb_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","11","از تمام کسانی که از مصر بیرون آمده‌اند و بیشتر از بیست سال دارند، کسی موفق به دیدن سرزمینی که قسم خورده بود به ابراهیم، اسحاق و یعقوب بدهد، نشود، زیرا آنها با تمام دل از خداوند پیروی نکرده بودند. ");
INSERT INTO pesopcb_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","از این گروه، تنها کالیب (پسر یفنه قنزی) و یوشع (پسر نون) بودند که با تمام دل از خداوند پیروی نموده، قوم اسرائیل را تشویق کردند تا وارد سرزمین موعود بشوند. ");
INSERT INTO pesopcb_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","«پس خشم خداوند بر اسرائیل افروخته شد و چهل سال آنها را در بیابان سرگردان نمود تا اینکه تمامی آن نسل که نسبت به خداوند گناه ورزیده بودند مردند. ");
INSERT INTO pesopcb_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","حالا شما نسل گناهکار، جای آنها را گرفته‌اید و می‌خواهید غضب خداوند را بیش از پیش بر سر قوم اسرائیل فرود آورید. ");
INSERT INTO pesopcb_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","اگر اینطور از خداوند روگردان شوید، او باز قوم اسرائیل را در بیابان ترک خواهد کرد و آنگاه شما مسئول هلاکت تمام این قوم خواهید بود.» ");
INSERT INTO pesopcb_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","ایشان گفتند: «ما برای گله‌های خود آغل و برای زن و بچه‌هایمان شهرها می‌سازیم، ");
INSERT INTO pesopcb_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","ولی خودمان مسلح شده، پیشاپیش سایر افراد اسرائیل به آن طرف رود اردن می‌رویم، تا ایشان را به ملک خودشان برسانیم. اما قبل از هر چیز لازم است در اینجا شهرهای حصاردار برای خانواده‌های خود بسازیم تا در مقابل حملهٔ ساکنان بومی در امان باشند. ");
INSERT INTO pesopcb_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","تا تمام قوم اسرائیل ملک خود را نگیرند، ما به خانه‌هایمان باز نمی‌گردیم. ");
INSERT INTO pesopcb_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","ما در آن طرف رود اردن زمین نمی‌خواهیم، بلکه ترجیح می‌دهیم در این طرف، یعنی در شرق رود اردن زمین داشته باشیم.» ");
INSERT INTO pesopcb_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","پس موسی گفت: «اگر آنچه را که گفتید انجام دهید و خود را در حضور خداوند برای جنگ آماده کنید، ");
INSERT INTO pesopcb_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","و سپاهیان خود را تا وقتی که خداوند دشمنانش را بیرون براند، در آن سوی رود اردن نگه دارید، ");
INSERT INTO pesopcb_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","آنگاه، بعد از اینکه سرزمین موعود به تصرف خداوند درآمد، شما هم می‌توانید برگردید، چون وظیفهٔ خود را نسبت به خداوند و بقیهٔ قوم اسرائیل انجام داده‌اید. آنگاه زمینهای شرق رود اردن، از طرف خداوند ملک شما خواهد بود. ");
INSERT INTO pesopcb_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","ولی اگر مطابق آنچه که گفته‌اید عمل نکنید، نسبت به خداوند گناه کرده‌اید و مطمئن باشید که به خاطر این گناه مجازات خواهید شد. ");
INSERT INTO pesopcb_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","اکنون بروید و برای خانواده‌های خود شهرها و برای گله‌هایتان آغل بسازید و هر آنچه گفته‌اید انجام دهید.» ");
INSERT INTO pesopcb_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","قوم جاد و رئوبین جواب دادند: «ما از دستورهای تو پیروی می‌کنیم. ");
INSERT INTO pesopcb_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","بچه‌ها و زنان و گله‌ها و رمه‌های ما در شهرهای جلعاد خواهند ماند. ");
INSERT INTO pesopcb_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","ولی خود ما مسلح شده، به آن طرف رود اردن می‌رویم تا همان‌طور که تو گفته‌ای برای خداوند بجنگیم.» ");
INSERT INTO pesopcb_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","پس موسی به العازار، یوشع و رهبران قبایل اسرائیل رضایت خود را اعلام نموده، گفت: ");
INSERT INTO pesopcb_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","«اگر تمامی مردان قبیله‌های جاد و رئوبین مسلح شدند و با شما به آن طرف رود اردن آمدند تا برای خداوند بجنگند، آنگاه بعد از اینکه آن سرزمین را تصرف کردید، باید سرزمین جلعاد را به ایشان بدهید. ");
INSERT INTO pesopcb_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","ولی اگر آنها با شما نیامدند، آنگاه در بین بقیهٔ شما در سرزمین کنعان زمین به ایشان داده شود.» ");
INSERT INTO pesopcb_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","قبیله‌های جاد و رئوبین پاسخ دادند: «آنچه خداوند به خدمتگزارانت فرموده است، انجام خواهیم داد. ");
INSERT INTO pesopcb_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","ما مسلح شده، به فرمان خداوند به کنعان می‌رویم، ولی می‌خواهیم سهم ما، از زمینهای این سوی رود اردن باشد.» ");
INSERT INTO pesopcb_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","پس موسی مملکت سیحون، پادشاه اموری‌ها و عوج پادشاه باشان، یعنی تمامی اراضی و همهٔ شهرهای آنها را برای قبیله‌های جاد و رئوبین و نصف قبیلهٔ مَنَسی (پسر یوسف) تعیین کرد. ");
INSERT INTO pesopcb_vpl VALUES ("NU32_34‏","005_32_34‏","NUM","32","34‏","36","مردم قبیلهٔ جاد این شهرها را ساختند: دیبون، عطاروت، عروعیر، عطروت شوفان، یعزیر، یُجبَهه، بیت نِمرَه، بیت هاران. همهٔ این شهرها، حصاردار و دارای آغل برای گوسفندان بودند. ");
INSERT INTO pesopcb_vpl VALUES ("NU32_37‏","005_32_37‏","NUM","32","37‏","38","مردم قبیلهٔ رئوبین نیز این شهرها را ساختند: حشبون، الیعاله، قریتایم، نبو، بعل معون و سبمه. (اسرائیلی‌ها بعد نام بعضی از این شهرهایی را که تسخیر نموده و آنها را از نو ساخته بودند، تغییر دادند.) ");
INSERT INTO pesopcb_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","طایفهٔ ماخیر از قبیلهٔ منسی به جلعاد رفته، این شهر را به تصرف خود درآوردند و اموری‌ها را که در آنجا ساکن بودند، بیرون راندند. ");
INSERT INTO pesopcb_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40","پس موسی، جلعاد را به طایفهٔ ماخیر پسر مَنَسی داد و آنها در آنجا ساکن شدند. ");
INSERT INTO pesopcb_vpl VALUES ("NU32_41","005_32_41","NUM","32","41","41","مردان یائیر که طایفه‌ای دیگر از قبیلهٔ منسی بودند، برخی روستاهای جلعاد را اشغال کرده، ناحیهٔ خود را حَووت‌یائیر نامیدند. ");
INSERT INTO pesopcb_vpl VALUES ("NU32_42","005_32_42","NUM","32","42","42","مردی به نام نوبخ به شهر قنات و روستاهای اطراف آن لشکرکشی کرده، آنجا را اشغال نمود و آن منطقه را به نام خود نوبح نامگذاری کرد. ");
INSERT INTO pesopcb_vpl VALUES ("NU33_1","005_33_1","NUM","33","1","1","این است سفرنامهٔ قوم اسرائیل از روزی که به رهبری موسی و هارون از مصر بیرون آمدند. ");
INSERT INTO pesopcb_vpl VALUES ("NU33_2","005_33_2","NUM","33","2","2","موسی طبق دستور خداوند مراحل سفر آنها را نوشته بود. ");
INSERT INTO pesopcb_vpl VALUES ("NU33_3‏","005_33_3‏","NUM","33","3‏","4","آنها در روز پانزدهم از ماه اول، یعنی یک روز بعد از پِسَح از شهر رَمِسیس مصر خارج شدند. در حالی که مصری‌ها همۀ نخست‌زادگان خود را که خداوند شب قبل آنها را کشته بود دفن می‌کردند، قوم اسرائیل با سربلندی از مصر بیرون آمدند. این امر نشان داد که خداوند از تمامی خدایان مصر قویتر است. ");
INSERT INTO pesopcb_vpl VALUES ("NU33_5‏","005_33_5‏","NUM","33","5‏","6","پس از حرکت از رَمِسیس، قوم اسرائیل در سوکوت اردو زدند و از آنجا به ایتام که در حاشیهٔ بیابان است رفتند. ");
INSERT INTO pesopcb_vpl VALUES ("NU33_7","005_33_7","NUM","33","7","7","بعد به فی‌هاحیروت نزدیک بعل صفون رفته، در دامنهٔ کوه مجدل اردو زدند. ");
INSERT INTO pesopcb_vpl VALUES ("NU33_8","005_33_8","NUM","33","8","8","سپس از آنجا کوچ کرده، از میان دریای سرخ گذشتند و به بیابان ایتام رسیدند. سه روز هم در بیابان ایتام پیش رفتند تا به ماره رسیدند و در آنجا اردو زدند. ");
INSERT INTO pesopcb_vpl VALUES ("NU33_9","005_33_9","NUM","33","9","9","از ماره کوچ کرده، به ایلیم آمدند که در آنجا دوازده چشمهٔ آب و هفتاد درخت خرما بود، و مدتی در آنجا ماندند. ");
INSERT INTO pesopcb_vpl VALUES ("NU33_10","005_33_10","NUM","33","10","10","از ایلیم به کنار دریای سرخ کوچ نموده، اردو زدند؛ ");
INSERT INTO pesopcb_vpl VALUES ("NU33_11","005_33_11","NUM","33","11","11","پس از آن به صحرای سین رفتند. ");
INSERT INTO pesopcb_vpl VALUES ("NU33_12","005_33_12","NUM","33","12","12","سپس به ترتیب به دُفقه، ");
INSERT INTO pesopcb_vpl VALUES ("NU33_13","005_33_13","NUM","33","13","13","الوش، ");
INSERT INTO pesopcb_vpl VALUES ("NU33_14","005_33_14","NUM","33","14","14","و رفیدیم که در آنجا آب نوشیدنی یافت نمی‌شد، رفتند. ");
INSERT INTO pesopcb_vpl VALUES ("NU33_15‏","005_33_15‏","NUM","33","15‏","37","از رفیدیم به صحرای سینا و از آنجا به قبروت هتاوه و سپس از قبروت هتاوه به حصیروت کوچ کردند و بعد به ترتیب به نقاط زیر رفتند: از حصیروت به رتمه، از رتمه به رمون فارص، از رمون فارص به لبنه، از لبنه به رسه، از رسه به قهیلاته، از قهیلاته به کوه شافر، از کوه شافر به حراده، از حراده به مقهیلوت، از مقهیلوت به تاحت، از تاحت به تارح، از تارح به متقه، از متقه به حشمونه، از حشمونه به مسیروت، از مسیروت به بنی‌یعقان، از بنی‌یعقان به حورالجدجاد، از حورالجدجاد به یطبات، از یطبات به عبرونه، از عبرونه به عصیون جابر، از عصیون جابر به قادش (در بیابان صین)، از قادش به کوه هور (در مرز سرزمین ادوم). ");
INSERT INTO pesopcb_vpl VALUES ("NU33_38‏","005_33_38‏","NUM","33","38‏","39","وقتی در دامنهٔ کوه هور بودند، هارون کاهن به دستور خداوند به بالای کوه هور رفت. وی در سن ۱۲۳ سالگی، در روز اول از ماه پنجم سال چهلم؛ بعد از بیرون آمدن بنی‌اسرائیل از مصر، در آنجا وفات یافت. ");
INSERT INTO pesopcb_vpl VALUES ("NU33_40","005_33_40","NUM","33","40","40","در این هنگام بود که پادشاه کنعانی سرزمین عراد (واقع در نِگِب کنعان)، اطلاع یافت که قوم اسرائیل به کشورش نزدیک می‌شوند. ");
INSERT INTO pesopcb_vpl VALUES ("NU33_41","005_33_41","NUM","33","41","41","پس اسرائیلی‌ها از کوه هور به صلمونه کوچ کردند و در آنجا اردو زدند. ");
INSERT INTO pesopcb_vpl VALUES ("NU33_42","005_33_42","NUM","33","42","42","بعد به فونون رفتند. ");
INSERT INTO pesopcb_vpl VALUES ("NU33_43","005_33_43","NUM","33","43","43","پس از آن به اوبوت کوچ کردند ");
INSERT INTO pesopcb_vpl VALUES ("NU33_44","005_33_44","NUM","33","44","44","و از آنجا به عیی‌عباریم در مرز موآب رفته، در آنجا اردو زدند. ");
INSERT INTO pesopcb_vpl VALUES ("NU33_45","005_33_45","NUM","33","45","45","سپس به دیبون جاد رفتند ");
INSERT INTO pesopcb_vpl VALUES ("NU33_46","005_33_46","NUM","33","46","46","و از دیبون جاد به علمون دبلاتایم ");
INSERT INTO pesopcb_vpl VALUES ("NU33_47","005_33_47","NUM","33","47","47","و از آنجا به کوهستان عباریم، نزدیک کوه نبو کوچ کردند. ");
INSERT INTO pesopcb_vpl VALUES ("NU33_48","005_33_48","NUM","33","48","48","سرانجام به دشت موآب رفتند که در کنار رود اردن در مقابل شهر اریحا بود. ");
INSERT INTO pesopcb_vpl VALUES ("NU33_49","005_33_49","NUM","33","49","49","در دشت موآب، از بیت‌یشیموت تا آبل شطیم در جاهای مختلف، کنار رود اردن اردو زدند. ");
INSERT INTO pesopcb_vpl VALUES ("NU33_50‏","005_33_50‏","NUM","33","50‏","51","زمانی که آنها در کنار رود اردن، در مقابل اریحا اردو زده بودند، خداوند به موسی فرمود که به قوم اسرائیل بگوید: «وقتی که از رود اردن عبور کردید و به سرزمین کنعان رسیدید، ");
INSERT INTO pesopcb_vpl VALUES ("NU33_52","005_33_52","NUM","33","52","52","باید تمامی ساکنان آنجا را بیرون کنید و همهٔ بتها و مجسمه‌هایشان را از بین ببرید و عبادتگاهای واقع در بالای کوهها را که در آنجا بتهایشان را پرستش می‌کنند خراب کنید. ");
INSERT INTO pesopcb_vpl VALUES ("NU33_53","005_33_53","NUM","33","53","53","من سرزمین کنعان را به شما داده‌ام. آن را تصرف کنید و در آن ساکن شوید. ");
INSERT INTO pesopcb_vpl VALUES ("NU33_54","005_33_54","NUM","33","54","54","زمین به تناسب جمعیت قبیله‌هایتان به شما داده خواهد شد. قطعه‌های بزرگتر زمین به قید قرعه بین قبیله‌های بزرگتر و قطعه‌های کوچکتر بین قبیله‌های کوچکتر تقسیم شود. ");
INSERT INTO pesopcb_vpl VALUES ("NU33_55","005_33_55","NUM","33","55","55","ولی اگر تمامی ساکنان آنجا را بیرون نکنید، باقیماندگان مثل خار به چشمهایتان و چون تیغ در پهلویتان فرو خواهند رفت و شما را در آن سرزمین آزار خواهند رساند. ");
INSERT INTO pesopcb_vpl VALUES ("NU33_56","005_33_56","NUM","33","56","56","آری، اگر آنان را بیرون نکنید آنگاه من شما را هلاک خواهم کرد همان‌طور که قصد داشتم شما آنها را هلاک کنید.» ");
INSERT INTO pesopcb_vpl VALUES ("NU34_1‏","005_34_1‏","NUM","34","1‏","2","خداوند به موسی فرمود: «به بنی‌اسرائیل بگو: وقتی به سرزمین کنعان که من آن را به ارث به شما می‌دهم وارد شدید، مرزهایتان اینها خواهد بود: ");
INSERT INTO pesopcb_vpl VALUES ("NU34_3","005_34_3","NUM","34","3","3","«قسمت جنوبی آن، بیابان صین واقع در مرز ادوم خواهد بود. مرز جنوبی از دریای مرده آغاز شده، ");
INSERT INTO pesopcb_vpl VALUES ("NU34_4","005_34_4","NUM","34","4","4","به سمت جنوب از گردنهٔ عقربها به طرف بیابان صین امتداد می‌یابد. دورترین نقطهٔ مرز جنوبی، قادش برنیع خواهد بود که از آنجا به سمت حَصَر ادار و عصمون ادامه خواهد یافت. ");
INSERT INTO pesopcb_vpl VALUES ("NU34_5","005_34_5","NUM","34","5","5","این مرز از عصمون در جهت نهر مصر پیش رفته، به دریای مدیترانه منتهی می‌گردد. ");
INSERT INTO pesopcb_vpl VALUES ("NU34_6","005_34_6","NUM","34","6","6","«مرز غربی شما، ساحل دریای مدیترانه خواهد بود. ");
INSERT INTO pesopcb_vpl VALUES ("NU34_7‏","005_34_7‏","NUM","34","7‏","9","«مرز شمالی شما از دریای مدیترانه شروع شده، به سوی مشرق تا کوه هور پیش می‌رود و از آنجا تا گذرگاه حمات ادامه یافته، از صدد و زفرون گذشته، به حصرعینان می‌رسد. ");
INSERT INTO pesopcb_vpl VALUES ("NU34_10‏","005_34_10‏","NUM","34","10‏","11","«حد شرقی از حصرعینان به طرف جنوب تا شفام و از آنجا تا ربله واقع در سمت شرقی عین، ادامه می‌یابد. از آنجا به صورت یک نیم دایرهٔ بزرگ، اول به طرف جنوب و بعد به سمت غرب کشیده می‌شود تا به جنوبی‌ترین نقطهٔ دریای جلیل برسد، ");
INSERT INTO pesopcb_vpl VALUES ("NU34_12","005_34_12","NUM","34","12","12","سپس در امتداد رود اردن به دریای مرده منتهی می‌شود. «این سرزمین شما خواهد بود با سرحدات اطرافش.» ");
INSERT INTO pesopcb_vpl VALUES ("NU34_13","005_34_13","NUM","34","13","13","موسی به بنی‌اسرائیل گفت: «این است سرزمینی که باید به قید قرعه بین خودتان تقسیم کنید. به دستور خداوند آن را باید بین نُه قبیله و نیم تقسیم کنید، ");
INSERT INTO pesopcb_vpl VALUES ("NU34_14‏","005_34_14‏","NUM","34","14‏","15","زیرا برای قبیله‌های رئوبین و جاد و نصف قبیلهٔ منسی، در سمت شرقی رود اردن و در مقابل اریحا زمین تعیین شده است.» ");
INSERT INTO pesopcb_vpl VALUES ("NU34_16‏","005_34_16‏","NUM","34","16‏","28","خداوند به موسی فرمود: «مردانی که آنها را تعیین کرده‌ام تا کار تقسیم زمین را بین قبایل اسرائیل انجام دهند اینها هستند: العازار کاهن، یوشع پسر نون و یک رهبر از هر قبیله. اسامی این رهبران به شرح زیر می‌باشد: «قبیله رهبر یهودا کالیب، پسر یفنه شمعون شموئیل، پسر عمیهود بنیامین الیداد، پسر کسلون دان بِقُی، پسر یُجلی منسی (پسر یوسف) حنی‌ئیل، پسر ایفود افرایم (پسر یوسف) قموئیل، پسر شفطان زبولون الیصافان، پسر فرناک یساکار فلطی‌ئیل، پسر عزان اشیر اخیهود، پسر شلومی نفتالی فده‌ئیل، پسر عمیهود.» ");
INSERT INTO pesopcb_vpl VALUES ("NU34_29","005_34_29","NUM","34","29","29","اینها اسامی کسانی است که خداوند انتخاب کرد تا بر کار تقسیم زمین بین قبایل اسرائیل نظارت کنند. ");
INSERT INTO pesopcb_vpl VALUES ("NU35_1","005_35_1","NUM","35","1","1","زمانی که قوم اسرائیل در دشت موآب، کنار رود اردن و در مقابل اریحا اردو زده بودند، خداوند به موسی فرمود: ");
INSERT INTO pesopcb_vpl VALUES ("NU35_2","005_35_2","NUM","35","2","2","«به قوم اسرائیل دستور بده که از ملک خود، شهرهایی با چراگاههای اطرافشان به لاویان بدهند. ");
INSERT INTO pesopcb_vpl VALUES ("NU35_3","005_35_3","NUM","35","3","3","شهرها برای سکونت خودشان است و چراگاههای اطراف آنها برای گله‌های گوسفند و گاو و سایر حیوانات ایشان. ");
INSERT INTO pesopcb_vpl VALUES ("NU35_4","005_35_4","NUM","35","4","4","چراگاههای اطراف هر شهر، از دیوار شهر تا فاصله پانصد متر به هر طرف امتداد داشته باشد. ");
INSERT INTO pesopcb_vpl VALUES ("NU35_5","005_35_5","NUM","35","5","5","بدین ترتیب محوطه‌ای مربع شکل به وجود می‌آید که هر ضلع آن هزار متر خواهد بود و شهر در وسط آن قرار خواهد گرفت. ");
INSERT INTO pesopcb_vpl VALUES ("NU35_6‏","005_35_6‏","NUM","35","6‏","7","«چهل و هشت شهر با چراگاههای اطرافشان به لاویان داده شود. از این چهل و هشت شهر، شش شهر به عنوان پناهگاه باشد تا اگر کسی مرتکب قتل شود بتواند به آنجا فرار کند و در امان باشد. ");
INSERT INTO pesopcb_vpl VALUES ("NU35_8","005_35_8","NUM","35","8","8","قبیله‌های بزرگتر که شهرهای بیشتری دارند، شهرهای بیشتری به لاویان بدهند و قبیله‌های کوچکتر شهرهای کمتر.» ");
INSERT INTO pesopcb_vpl VALUES ("NU35_9","005_35_9","NUM","35","9","9","خداوند به موسی فرمود: ");
INSERT INTO pesopcb_vpl VALUES ("NU35_10","005_35_10","NUM","35","10","10","«به قوم اسرائیل بگو، هنگامی که از رود اردن عبور کرده به سرزمین موعود می‌رسند، ");
INSERT INTO pesopcb_vpl VALUES ("NU35_11","005_35_11","NUM","35","11","11","شهرهای پناهگاه تعیین کنند تا هر کس که ناخواسته شخصی را کشته باشد بتواند به آنجا فرار کند. ");
INSERT INTO pesopcb_vpl VALUES ("NU35_12","005_35_12","NUM","35","12","12","این شهرها مکانی خواهند بود که قاتل در برابر انتقام جویی بستگان مقتول در آنها ایمن خواهد بود، زیرا قاتل تا زمانی که جرمش در یک دادرسی عادلانه ثابت نگردد، نباید کشته شود. ");
INSERT INTO pesopcb_vpl VALUES ("NU35_13‏","005_35_13‏","NUM","35","13‏","14","سه شهر از این شش شهر پناهگاه، باید در سرزمین کنعان باشد و سه شهر دیگر در سمت شرقی رود اردن. ");
INSERT INTO pesopcb_vpl VALUES ("NU35_15","005_35_15","NUM","35","15","15","این شهرها نه فقط برای قوم اسرائیل، بلکه برای غریبان و مسافران نیز پناهگاه خواهند بود. ");
INSERT INTO pesopcb_vpl VALUES ("NU35_16‏","005_35_16‏","NUM","35","16‏","18","«اگر کسی با استفاده از یک تکه آهن یا سنگ یا چوب، شخصی را بکشد، قاتل است و باید کشته شود. ");
INSERT INTO pesopcb_vpl VALUES ("NU35_19","005_35_19","NUM","35","19","19","مدعی خون مقتول وقتی قاتل را ببیند خودش او را بکشد. ");
INSERT INTO pesopcb_vpl VALUES ("NU35_20","005_35_20","NUM","35","20","20","اگر شخصی از روی کینه با پرتاب چیزی به طرف کسی یا با هل دادن او، وی را بکشد، ");
INSERT INTO pesopcb_vpl VALUES ("NU35_21","005_35_21","NUM","35","21","21","یا از روی دشمنی مشتی به او بزند که او بمیرد، آن شخص قاتل است و قاتل باید کشته شود. مدعی خون مقتول وقتی قاتل را ببیند خودش او را بکشد. ");
INSERT INTO pesopcb_vpl VALUES ("NU35_22‏","005_35_22‏","NUM","35","22‏","23","«ولی اگر قتل تصادفی باشد، برای مثال، شخصی چیزی را به طور غیرعمد پرتاب کند یا کسی را هل دهد و باعث مرگ او شود و یا قطعه سنگی را بدون قصد پرتاب کند و آن سنگ به کسی اصابت کند و او را بکشد در حالی که پرتاب کننده، دشمنی با وی نداشته است، ");
INSERT INTO pesopcb_vpl VALUES ("NU35_24","005_35_24","NUM","35","24","24","در اینجا قوم باید در مورد اینکه آیا قتل تصادفی بوده یا نه، و اینکه قاتل را باید به دست مدعی خون مقتول بسپارند یا نه، قضاوت کنند. ");
INSERT INTO pesopcb_vpl VALUES ("NU35_25","005_35_25","NUM","35","25","25","اگر به این نتیجه برسند که قتل تصادفی بوده، آنگاه قوم اسرائیل متهم را از دست مدعی برهانند و به او اجازه بدهند که در شهر پناهگاه، ساکن شود. او باید تا هنگام مرگ کاهن اعظم، در آن شهر بماند. ");
INSERT INTO pesopcb_vpl VALUES ("NU35_26","005_35_26","NUM","35","26","26","«اگر متهم، شهرِ پناهگاه را ترک کند، ");
INSERT INTO pesopcb_vpl VALUES ("NU35_27","005_35_27","NUM","35","27","27","و مدعی خون مقتول، وی را خارج از شهر پیدا کرده، او را بکشد، عمل او قتل محسوب نمی‌شود، ");
INSERT INTO pesopcb_vpl VALUES ("NU35_28","005_35_28","NUM","35","28","28","چون آن شخص می‌بایستی تا هنگام مرگ کاهن اعظم در شهر پناهگاه می‌ماند و بعد از آن به ملک و خانهٔ خود بازمی‌گشت. ");
INSERT INTO pesopcb_vpl VALUES ("NU35_29","005_35_29","NUM","35","29","29","اینها برای تمامی قوم اسرائیل نسل اندر نسل قوانینی دائمی می‌باشند. ");
INSERT INTO pesopcb_vpl VALUES ("NU35_30","005_35_30","NUM","35","30","30","«هر کس شخصی را بکشد، به موجب شهادت چند شاهد، قاتل شناخته می‌شود و باید کشته شود. هیچ‌کس تنها به شهادت یک نفر نباید کشته شود. ");
INSERT INTO pesopcb_vpl VALUES ("NU35_31","005_35_31","NUM","35","31","31","هر وقت کسی قاتل شناخته شد باید کشته شود و نباید خونبهایی برای رهایی او پذیرفته شود. ");
INSERT INTO pesopcb_vpl VALUES ("NU35_32","005_35_32","NUM","35","32","32","از پناهنده‌ای که در شهر پناهگاه سکونت دارد پولی برای اینکه به او اجازه داده شود قبل از مرگ کاهن اعظم به ملک و خانهٔ خویش بازگردد گرفته نشود. ");
INSERT INTO pesopcb_vpl VALUES ("NU35_33","005_35_33","NUM","35","33","33","اگر این قوانین را مراعات کنید سرزمین شما آلوده نخواهد شد، زیرا قتل موجب آلودگی زمین می‌شود. هیچ کفاره‌ای برای قتل به‌جز کشتن قاتل پذیرفته نمی‌شود. ");
INSERT INTO pesopcb_vpl VALUES ("NU35_34","005_35_34","NUM","35","34","34","سرزمینی را که در آن ساکن خواهید شد نجس نسازید، زیرا من که یهوه هستم در آنجا ساکن می‌باشم.» ");
INSERT INTO pesopcb_vpl VALUES ("NU36_1‏","005_36_1‏","NUM","36","1‏","2","سران طوایف جلعاد (جلعاد پسر ماخیر، ماخیر پسر منسی و منسی پسر یوسف بود) با درخواستی نزد موسی و رهبران اسرائیل آمدند و به موسی یادآوری کرده، گفتند: «خداوند به تو دستور داد که زمین را به قید قرعه بین قوم اسرائیل تقسیم کنی و ارث برادرمان صَلُفحاد را به دخترانش بدهی. ");
INSERT INTO pesopcb_vpl VALUES ("NU36_3","005_36_3","NUM","36","3","3","ولی اگر آنها با مردان قبیلهٔ دیگری ازدواج کنند، زمینشان هم با خودشان به آن قبیله انتقال خواهد یافت و بدین‌سان از کل زمین قبیلهٔ ما کاسته خواهد گردید ");
INSERT INTO pesopcb_vpl VALUES ("NU36_4","005_36_4","NUM","36","4","4","و در سال یوبیل هم بازگردانده نخواهد شد.» ");
INSERT INTO pesopcb_vpl VALUES ("NU36_5","005_36_5","NUM","36","5","5","آنگاه موسی در حضور قوم این دستورها را از جانب خداوند به ایشان داد: «شکایت مردان قبیلهٔ یوسف بجاست، ");
INSERT INTO pesopcb_vpl VALUES ("NU36_6","005_36_6","NUM","36","6","6","آنچه خداوند دربارهٔ دختران صلفحاد امر فرموده این است: بگذارید این دختران با مردان دلخواه خود ازدواج کنند، ولی فقط به شرط آنکه این مردان از قبیلهٔ خودشان باشند. ");
INSERT INTO pesopcb_vpl VALUES ("NU36_7","005_36_7","NUM","36","7","7","به این طریق هیچ قسمتی از زمینهای قبیلهٔ یوسف به قبیلهٔ دیگری منتقل نخواهد شد، زیرا میراث هر قبیله بایستی همان‌طور که در اول تقسیم شد برای همیشه همان‌طور باقی بماند. ");
INSERT INTO pesopcb_vpl VALUES ("NU36_8","005_36_8","NUM","36","8","8","دخترانی که در تمامی قبایل اسرائیل وارث زمین هستند بایستی با مردان قبیلهٔ خودشان ازدواج کنند تا زمین ایشان از آن قبیله، جدا نشود. ");
INSERT INTO pesopcb_vpl VALUES ("NU36_9","005_36_9","NUM","36","9","9","به این طریق هیچ میراثی از قبیله‌ای به قبیلهٔ دیگر منتقل نخواهد شد.» ");
INSERT INTO pesopcb_vpl VALUES ("NU36_10","005_36_10","NUM","36","10","10","دختران صلفحاد همان‌طور که خداوند به موسی دستور داده بود عمل کردند. ");
INSERT INTO pesopcb_vpl VALUES ("NU36_11‏","005_36_11‏","NUM","36","11‏","12","این دختران، یعنی محله، تِرصه، حُجله، مِلکه و نوعه با پسر عموهای خود ازدواج کردند. بدین ترتیب آنها با مردانی از قبیلهٔ خود یعنی قبیلهٔ منسی (پسر یوسف) ازدواج کردند و میراث آنان در قبیلهٔ خودشان باقی ماند. ");
INSERT INTO pesopcb_vpl VALUES ("NU36_13","005_36_13","NUM","36","13","13","این است احکام و اوامری که خداوند توسط موسی به قوم اسرائیل داد، هنگامی که آنها در دشت موآب کنار رود اردن و در مقابل اریحا اردو زده بودند.");
INSERT INTO pesopcb_vpl VALUES ("DT1_1","006_1_1","DEU","1","1","1","در این کتاب، سخنرانی موسی خطاب به قوم اسرائیل، زمانی که آنها در بیابانِ شرق رود اردن بودند، ثبت شده است. آنها در عربه که مقابل سوف، و بین فاران در یک طرف و توفل، لابان، حضیروت و دی ذهب در طرف دیگر قرار داشت، اردو زدند. ");
INSERT INTO pesopcb_vpl VALUES ("DT1_2‏","006_1_2‏","DEU","1","2‏","5","فاصلهٔ کوه حوریب تا قادش برنیع از طریق کوه سعیر یازده روز است. این سخنرانی در روز اول ماه یازدهم سال چهلم بعد از خروج بنی‌اسرائیل از مصر ایراد شد. در آن زمان، سیحون، پادشاه اموری‌ها که در حشبون حکومت می‌کرد شکست خورده بود و عوج، پادشاه سرزمین باشان که در عشتاروت حکومت می‌کرد، در اَدَرعی مغلوب شده بود. موسی در این سخنرانی به شرح قوانین و دستورهای خداوند می‌پردازد: ");
INSERT INTO pesopcb_vpl VALUES ("DT1_6","006_1_6","DEU","1","6","6","وقتی ما در کوه حوریب بودیم یهوه خدایمان به ما فرمود: «به اندازه کافی در اینجا مانده‌اید. ");
INSERT INTO pesopcb_vpl VALUES ("DT1_7","006_1_7","DEU","1","7","7","اکنون بروید و سرزمین کوهستانی اموری‌ها، نواحی درهٔ اردن، دشتها و کوهستانها، صحرای نِگِب و تمامی سرزمین کنعان و لبنان یعنی همهٔ نواحی سواحل مدیترانه تا رود فرات را اشغال نمایید. ");
INSERT INTO pesopcb_vpl VALUES ("DT1_8","006_1_8","DEU","1","8","8","تمامی آن را به شما می‌دهم. داخل شده، آن را تصرف کنید، چون این سرزمینی است که قسم خورده‌ام آن را به نیاکان شما ابراهیم و اسحاق و یعقوب و تمامی نسلهای آیندهٔ ایشان بدهم.» ");
INSERT INTO pesopcb_vpl VALUES ("DT1_9","006_1_9","DEU","1","9","9","در آن روزها به مردم گفتم: «شما برای من بار سنگینی هستید و من نمی‌توانم به تنهایی این بار را به دوش بکشم، ");
INSERT INTO pesopcb_vpl VALUES ("DT1_10","006_1_10","DEU","1","10","10","چون یهوه خدایتان شما را مثل ستارگان زیاد کرده است. ");
INSERT INTO pesopcb_vpl VALUES ("DT1_11","006_1_11","DEU","1","11","11","خداوند، خدای نیاکانتان، شما را هزار برابر افزایش دهد و طبق وعده‌اش شما را برکت دهد. ");
INSERT INTO pesopcb_vpl VALUES ("DT1_12","006_1_12","DEU","1","12","12","ولی من چگونه می‌توانم به تنهایی تمامی دعواها و گرفتاریهایتان را حل و فصل نمایم؟ ");
INSERT INTO pesopcb_vpl VALUES ("DT1_13","006_1_13","DEU","1","13","13","بنابراین از هر قبیله چند مرد دانا و باتجربه و فهمیده انتخاب کنید و من آنها را به رهبری شما منصوب خواهم کرد.» ");
INSERT INTO pesopcb_vpl VALUES ("DT1_14","006_1_14","DEU","1","14","14","ایشان با این امر موافقت کردند ");
INSERT INTO pesopcb_vpl VALUES ("DT1_15","006_1_15","DEU","1","15","15","و من افرادی را که آنها از هر قبیله انتخاب کرده بودند برایشان گماردم تا مسئولیت گروه‌های هزار، صد، پنجاه و ده نفری را به عهده گرفته، به حل دعواهای آنان بپردازند. ");
INSERT INTO pesopcb_vpl VALUES ("DT1_16","006_1_16","DEU","1","16","16","به آنها دستور دادم که در همه حال، عدالت را کاملاً رعایت کنند، حتی نسبت به غریبه‌ها. ");
INSERT INTO pesopcb_vpl VALUES ("DT1_17","006_1_17","DEU","1","17","17","به آنها گوشزد کردم: «هنگام داوری از کسی جانبداری نکنید، بلکه نسبت به بزرگ و کوچک یکسان قضاوت نمایید. از مردم نترسید، چون شما از طرف خدا داوری می‌کنید. هر مسئله‌ای که حل آن برایتان مشکل است نزد من بیاورید تا من به آن رسیدگی کنم.» ");
INSERT INTO pesopcb_vpl VALUES ("DT1_18","006_1_18","DEU","1","18","18","در همان وقت دستورهای دیگری را هم که قوم می‌بایست انجام دهند، به ایشان دادم. ");
INSERT INTO pesopcb_vpl VALUES ("DT1_19‏","006_1_19‏","DEU","1","19‏","21","آنگاه طبق دستور خداوند، خدایمان کوه حوریب را ترک گفته، از بیابان بزرگ و ترسناک گذشتیم و سرانجام به میان کوهستانهای اموری‌ها رسیدیم. بعد به قادش برنیع رسیدیم و من به قوم گفتم: «خداوند، خدایمان این سرزمین را به ما داده است. بروید و همچنانکه به ما امر فرموده آن را تصرف کنید. نترسید و هراس به دلتان راه ندهید.» ");
INSERT INTO pesopcb_vpl VALUES ("DT1_22","006_1_22","DEU","1","22","22","ولی آنها جواب دادند: «بیایید افرادی به آنجا بفرستیم تا آن سرزمین را بررسی کنند و گزارشی از شهرهای آنجا به ما بدهند تا ما بدانیم از چه راهی می‌توانیم به آنجا رخنه کنیم.» ");
INSERT INTO pesopcb_vpl VALUES ("DT1_23","006_1_23","DEU","1","23","23","این پیشنهاد را پسندیدم و دوازده نفر، یعنی از هر قبیله یک نفر، انتخاب کردم. ");
INSERT INTO pesopcb_vpl VALUES ("DT1_24‏","006_1_24‏","DEU","1","24‏","25","آنها از میان کوهستانها گذشته، به وادی اشکول رسیده، آنجا را بررسی کردند و با نمونه‌هایی از میوه‌های آن سرزمین بازگشته، گفتند: «سرزمینی که خداوند، خدایمان به ما داده است سرزمین حاصلخیزی است.» ");
INSERT INTO pesopcb_vpl VALUES ("DT1_26","006_1_26","DEU","1","26","26","ولی قوم از ورود به آنجا خودداری نموده، علیه دستور یهوه خدایتان قیام کردند. ");
INSERT INTO pesopcb_vpl VALUES ("DT1_27","006_1_27","DEU","1","27","27","آنها در خیمه‌هایشان غرغر و شکایت کرده، گفتند: «لابد خداوند از ما بیزار است که ما را از مصر به اینجا آورده تا به دست اموری‌ها کشته شویم. ");
INSERT INTO pesopcb_vpl VALUES ("DT1_28","006_1_28","DEU","1","28","28","کار ما به کجا خواهد کشید؟ برادران ما که آن سرزمین را بررسی کرده‌اند با خبرهایشان ما را ترسانده‌اند. آنها می‌گویند که مردم آن سرزمین بلند قد و قوی هیکل هستند و شهرهایشان بزرگ است و حصارهایشان سر به فلک می‌کشد. آنها غولهایی از بنی‌عناق نیز در آنجا دیده‌اند.» ");
INSERT INTO pesopcb_vpl VALUES ("DT1_29","006_1_29","DEU","1","29","29","ولی من به ایشان گفتم: «نترسید و هراس به دلتان راه ندهید. ");
INSERT INTO pesopcb_vpl VALUES ("DT1_30‏","006_1_30‏","DEU","1","30‏","31","خداوند، خدای شما هادی شماست و برای شما جنگ خواهد کرد، همان‌طور که قبلاً در مصر و در این بیابان این کار را برای شما کرد. دیده‌اید که در تمام طول راه از شما مراقبت کرده است همان‌طور که یک پدر از بچه‌اش مواظبت می‌کند.» ");
INSERT INTO pesopcb_vpl VALUES ("DT1_32","006_1_32","DEU","1","32","32","ولی با این همه به یهوه خدایتان اعتماد نکردند، ");
INSERT INTO pesopcb_vpl VALUES ("DT1_33","006_1_33","DEU","1","33","33","هر چند خداوند در طول راه آنها را هدایت می‌نمود و پیشاپیش آنها حرکت می‌کرد تا مکانی برای بر پا کردن اردویشان پیدا کند، و شبها با ستونی از آتش و روزها با ستونی از ابر آنها را راهنمایی می‌نمود. ");
INSERT INTO pesopcb_vpl VALUES ("DT1_34‏","006_1_34‏","DEU","1","34‏","35","آری، خداوند شکوه‌هایشان را شنید و بسیار خشمگین شد و قسم خورده، گفت: «حتی یک نفر از تمامی این نسل شریر زنده نخواهد ماند تا سرزمین حاصلخیزی را که به پدرانشان وعده داده بودم ببیند ");
INSERT INTO pesopcb_vpl VALUES ("DT1_36","006_1_36","DEU","1","36","36","مگر کالیب پسر یَفُنه. من زمینی را که او بررسی کرده است به او و به نسلش خواهم داد، زیرا از من اطاعت کامل نمود.» ");
INSERT INTO pesopcb_vpl VALUES ("DT1_37","006_1_37","DEU","1","37","37","خداوند به خاطر آنها بر من نیز خشمناک شد و به من فرمود: «تو نیز به سرزمین موعود داخل نخواهی شد. ");
INSERT INTO pesopcb_vpl VALUES ("DT1_38","006_1_38","DEU","1","38","38","به جای تو، دستیارت یوشع (پسر نون) قوم را هدایت خواهد کرد. او را تشویق کن تا برای به عهده گرفتن رهبری آماده شود.» ");
INSERT INTO pesopcb_vpl VALUES ("DT1_39","006_1_39","DEU","1","39","39","سپس خداوند خطاب به همهٔ ما فرمود: «من سرزمین موعود را به همان اطفالی که می‌گفتید دشمنان، آنها را به اسارت خواهند برد، به ملکیت خواهم داد. ");
INSERT INTO pesopcb_vpl VALUES ("DT1_40","006_1_40","DEU","1","40","40","اما شما اکنون برگردید و از راهی که به سوی دریای سرخ می‌رود به بیابان بروید.» ");
INSERT INTO pesopcb_vpl VALUES ("DT1_41","006_1_41","DEU","1","41","41","آنگاه قوم اسرائیل اعتراف نموده، به من گفتند: «ما گناه کرده‌ایم؛ اما اینک به آن سرزمین می‌رویم و همان‌طور که خداوند، خدایمان به ما امر فرموده است برای تصاحب آن خواهیم جنگید.» پس اسلحه‌هایشان را به کمر بستند و گمان کردند که غلبه بر تمامی آن ناحیه آسان خواهد بود. ");
INSERT INTO pesopcb_vpl VALUES ("DT1_42","006_1_42","DEU","1","42","42","ولی خداوند به من گفت: «به ایشان بگو که این کار را نکنند، زیرا من با ایشان نخواهم رفت و دشمنانشان آنها را مغلوب خواهند کرد.» ");
INSERT INTO pesopcb_vpl VALUES ("DT1_43","006_1_43","DEU","1","43","43","من به ایشان گفتم، ولی گوش ندادند. آنها مغرور شده، فرمان خداوند را اطاعت نکردند و برای جنگیدن به کوهستان برآمدند. ");
INSERT INTO pesopcb_vpl VALUES ("DT1_44","006_1_44","DEU","1","44","44","ولی اموری‌هایی که در آنجا ساکن بودند برای مقابله با آنها بیرون آمده، مثل زنبور ایشان را دنبال کردند و از سعیر تا حرمه آنها را کشتند. ");
INSERT INTO pesopcb_vpl VALUES ("DT1_45","006_1_45","DEU","1","45","45","آنگاه قوم اسرائیل بازگشته، در حضور خداوند گریستند، ولی خداوند گوش نداد. ");
INSERT INTO pesopcb_vpl VALUES ("DT1_46","006_1_46","DEU","1","46","46","سپس آنها مدت مدیدی در قادش ماندند. ");
INSERT INTO pesopcb_vpl VALUES ("DT2_1‏","006_2_1‏","DEU","2","1‏","2","آنگاه طبق دستور خداوند بازگشتیم و از راهی که به سوی دریای سرخ می‌رود به بیابان رفتیم. سالهای زیادی در اطراف ناحیهٔ کوه سعیر سرگردان بودیم. سرانجام خداوند فرمود: ");
INSERT INTO pesopcb_vpl VALUES ("DT2_3","006_2_3","DEU","2","3","3","«به اندازهٔ کافی در این کوهستان سرگردان بوده‌اید. حال به سمت شمال بروید. ");
INSERT INTO pesopcb_vpl VALUES ("DT2_4","006_2_4","DEU","2","4","4","به قوم بگو که ایشان از مرز سرزمینی خواهند گذشت که به برادرانشان ادومی‌ها تعلق دارد. (ادومی‌ها از نسل عیسو هستند و در سعیر زندگی می‌کنند.) آنها از شما خواهند ترسید، ");
INSERT INTO pesopcb_vpl VALUES ("DT2_5","006_2_5","DEU","2","5","5","ولی شما با ایشان نجنگید، چون من تمام سرزمین کوهستانی سعیر را به عنوان ملک دائمی به ایشان داده‌ام و حتی یک وجب از زمین ایشان را به شما نخواهم داد. ");
INSERT INTO pesopcb_vpl VALUES ("DT2_6","006_2_6","DEU","2","6","6","در آنجا به ازای آب و غذایی که مصرف می‌کنید، پول بپردازید. ");
INSERT INTO pesopcb_vpl VALUES ("DT2_7","006_2_7","DEU","2","7","7","خداوند، خدایتان در تمام چهل سالی که در این بیابان بزرگ سرگردان بوده‌اید با شما بوده و قدم به قدم از شما مراقبت نموده است. او در تمام کارهایتان به شما برکت داده و شما هیچوقت محتاج به چیزی نبوده‌اید.» ");
INSERT INTO pesopcb_vpl VALUES ("DT2_8","006_2_8","DEU","2","8","8","بنابراین ما از کنار سعیر که برادرانمان از نسل عیسو در آنجا زندگی می‌کردند گذشتیم و جاده‌ای را که به سمت جنوب به اِیلَت و عصیون جابر می‌رود قطع نموده، رو به شمال به طرف بیابان موآب کوچ کردیم. ");
INSERT INTO pesopcb_vpl VALUES ("DT2_9","006_2_9","DEU","2","9","9","آنگاه خداوند به ما چنین هشدار داد: «با موآبی‌ها که از نسل لوط هستند کاری نداشته باشید و با ایشان وارد جنگ نشوید. من شهر عار را به ایشان داده‌ام و هیچ زمینی را از سرزمین ایشان به شما نخواهم داد.» ");
INSERT INTO pesopcb_vpl VALUES ("DT2_10","006_2_10","DEU","2","10","10","(ایمی‌ها که قبیلهٔ بسیار بزرگی بودند قبلاً در آن ناحیه سکونت داشتند و مثل غولهای عناقی بلند قد بودند. ");
INSERT INTO pesopcb_vpl VALUES ("DT2_11","006_2_11","DEU","2","11","11","ایمی‌ها و عناقی‌ها غالباً رفائی خوانده می‌شوند، ولی موآبی‌ها ایشان را ایمی می‌خوانند. ");
INSERT INTO pesopcb_vpl VALUES ("DT2_12","006_2_12","DEU","2","12","12","در روزگار پیشین حوری‌ها در سعیر سکونت داشتند، ولی ادومی‌ها یعنی قوم عیسو آنها را بیرون رانده، جایشان را گرفتند، همان‌طور که اسرائیل مردم کنعان را که خداوند سرزمینشان را به اسرائیل بخشیده بود، بیرون راندند.) ");
INSERT INTO pesopcb_vpl VALUES ("DT2_13","006_2_13","DEU","2","13","13","خداوند فرمود: «اکنون برخیزید و از رود زارَد بگذرید.» ما چنین کردیم. ");
INSERT INTO pesopcb_vpl VALUES ("DT2_14","006_2_14","DEU","2","14","14","سی و هشت سال پیش، ما قادش را ترک گفته بودیم. همان‌طور که خداوند فرموده بود، در این مدت تمام جنگجویان ما از بین رفتند. ");
INSERT INTO pesopcb_vpl VALUES ("DT2_15","006_2_15","DEU","2","15","15","خداوند بر ضد آنها بود و سرانجام همهٔ آنها را از بین برد. ");
INSERT INTO pesopcb_vpl VALUES ("DT2_16","006_2_16","DEU","2","16","16","پس از اینکه تمام جنگجویان مردند ");
INSERT INTO pesopcb_vpl VALUES ("DT2_17","006_2_17","DEU","2","17","17","خداوند به من فرمود: ");
INSERT INTO pesopcb_vpl VALUES ("DT2_18","006_2_18","DEU","2","18","18","«امروز باید از شهر عار که در مرز موآب است بگذرید. ");
INSERT INTO pesopcb_vpl VALUES ("DT2_19","006_2_19","DEU","2","19","19","وقتی به سرزمین عمونی‌ها که از نسل لوط هستند نزدیک شدید با آنها کاری نداشته باشید و با ایشان وارد جنگ نشوید، زیرا هیچ زمینی را از سرزمینی که به ایشان بخشیده‌ام، به شما نخواهم داد.» ");
INSERT INTO pesopcb_vpl VALUES ("DT2_20","006_2_20","DEU","2","20","20","(آن ناحیه نیز زمانی محل سکونت رفائی‌ها که عمونی‌ها ایشان را زَمزُمی می‌خوانند، بود. ");
INSERT INTO pesopcb_vpl VALUES ("DT2_21","006_2_21","DEU","2","21","21","آنها قبیلهٔ بسیار بزرگی بودند و مثل عناقی‌ها قد بلندی داشتند، ولی خداوند ایشان را هنگام ورود عمونی‌ها از بین برد و عمونی‌ها به جای ایشان در آنجا سکونت کردند. ");
INSERT INTO pesopcb_vpl VALUES ("DT2_22","006_2_22","DEU","2","22","22","خداوند به همین گونه به قوم عیسو در کوه سعیر کمک کرده بود و آنها حوری‌ها را که قبل از ایشان در آنجا سکونت داشتند از بین برده و تا امروز به جای ایشان ساکن شده‌اند. ");
INSERT INTO pesopcb_vpl VALUES ("DT2_23","006_2_23","DEU","2","23","23","وضع مشابه دیگر، زمانی اتفاق افتاد که مردم کفتور به قبیلهٔ عِوی‌ها که تا حدود غزه در دهکده‌های پراکنده‌ای سکونت داشتند حمله نموده، آنها را هلاک کردند و به جای ایشان ساکن شدند.) ");
INSERT INTO pesopcb_vpl VALUES ("DT2_24","006_2_24","DEU","2","24","24","آنگاه خداوند فرمود: «از رود ارنون گذشته، به سرزمین سیحونِ اموری، پادشاه حشبون داخل شوید. من او را و سرزمینش را به شما داده‌ام. با او بجنگید و سرزمین او را به تصرف خود درآورید. ");
INSERT INTO pesopcb_vpl VALUES ("DT2_25","006_2_25","DEU","2","25","25","از امروز ترس شما را بر دل مردم سراسر جهان می‌گذارم. آنها آوازهٔ شما را می‌شنوند و به وحشت می‌افتند.» ");
INSERT INTO pesopcb_vpl VALUES ("DT2_26","006_2_26","DEU","2","26","26","سپس از صحرای قدیموت سفیرانی با پیشنهاد صلح نزد سیحون، پادشاه حِشبون فرستادم. ");
INSERT INTO pesopcb_vpl VALUES ("DT2_27","006_2_27","DEU","2","27","27","پیشنهاد ما این بود: «اجازه دهید از سرزمین شما عبور کنیم. از جادهٔ اصلی خارج نخواهیم شد و به طرف مزارع اطراف آن نخواهیم رفت. ");
INSERT INTO pesopcb_vpl VALUES ("DT2_28","006_2_28","DEU","2","28","28","هنگام عبور برای هر لقمه نانی که بخوریم و هر جرعه آبی که بنوشیم، پول خواهیم داد. تنها چیزی که می‌خواهیم، اجازهٔ عبور از سرزمین شماست. ");
INSERT INTO pesopcb_vpl VALUES ("DT2_29","006_2_29","DEU","2","29","29","ادومی‌های نسل عیسو که ساکن سعیرند اجازهٔ عبور از سرزمین خود را به ما دادند. موآبی‌ها هم که پایتختشان در عار است همین کار را کردند. ما از راه اردن به سرزمینی که خداوند، خدایمان به ما داده است می‌رویم.» ");
INSERT INTO pesopcb_vpl VALUES ("DT2_30","006_2_30","DEU","2","30","30","ولی سیحون پادشاه حِشبون موافقت نکرد، زیرا خداوند، خدای شما او را سختدل گردانید تا او را به دست اسرائیل نابود کند، همچنانکه الان شده است. ");
INSERT INTO pesopcb_vpl VALUES ("DT2_31","006_2_31","DEU","2","31","31","آنگاه خداوند به من فرمود: «اکنون به تدریج سرزمین سیحون پادشاه را به شما می‌دهم. پس شروع به تصرف و تصاحب این سرزمین کن.» ");
INSERT INTO pesopcb_vpl VALUES ("DT2_32","006_2_32","DEU","2","32","32","آنگاه سیحون پادشاه به ما اعلان جنگ داد و نیروهایش را در یاهص بسیج کرد. ");
INSERT INTO pesopcb_vpl VALUES ("DT2_33‏","006_2_33‏","DEU","2","33‏","34","ولی خداوند، خدایمان او را به ما تسلیم نمود و ما او را با تمام پسران و افرادش کشتیم و تمامی شهرهایش را به تصرف خود درآورده، همهٔ مردان و زنان و اطفال را از بین بردیم. ");
INSERT INTO pesopcb_vpl VALUES ("DT2_35","006_2_35","DEU","2","35","35","به غیر از گله‌هایشان، موجود دیگری را زنده نگذاشتیم. این گله‌ها را هم با غنایمی که از تسخیر شهرها به چنگ آورده بودیم با خود بردیم. ");
INSERT INTO pesopcb_vpl VALUES ("DT2_36","006_2_36","DEU","2","36","36","ما از عروعیر که در کنارهٔ درهٔ ارنون است تا جلعاد، همهٔ شهرها را به تصرف خود درآوردیم. حتی یک شهر هم در برابر ما قادر به مقاومت نبود، زیرا خداوند، خدایمان تمامی آنها را به ما داده بود. ");
INSERT INTO pesopcb_vpl VALUES ("DT2_37","006_2_37","DEU","2","37","37","ولی ما به سرزمین بنی‌عمون و به رود یبوق و شهرهای کوهستانی یعنی جاهایی که خداوند، خدایمان قدغن فرموده بود، نزدیک نشدیم. ");
INSERT INTO pesopcb_vpl VALUES ("DT3_1‏","006_3_1‏","DEU","3","1‏","2","سپس به سوی سرزمین باشان روی آوردیم. عوج، پادشاه باشان لشکر خود را بسیج نموده، در اَدَرعی به ما حمله کرد. ولی خداوند به من فرمود که از او نترسم. خداوند به من گفت: «تمام سرزمین عوج و مردمش در اختیار شما هستند. با ایشان همان کنید که با سیحون، پادشاه اموری‌ها در حشبون کردید.» ");
INSERT INTO pesopcb_vpl VALUES ("DT3_3","006_3_3","DEU","3","3","3","بنابراین خداوند، خدای ما عوج پادشاه و همهٔ مردمش را به ما تسلیم نمود و ما همهٔ آنها را کشتیم. ");
INSERT INTO pesopcb_vpl VALUES ("DT3_4","006_3_4","DEU","3","4","4","تمامی شصت شهرش یعنی سراسر ناحیهٔ ارجوب باشان را به تصرف خود درآوردیم. ");
INSERT INTO pesopcb_vpl VALUES ("DT3_5","006_3_5","DEU","3","5","5","این شهرها با دیوارهای بلند و دروازه‌های پشتبنددار محافظت می‌شد. علاوه بر این شهرها، تعداد زیادی آبادی بی‌حصار نیز بودند که به تصرف ما درآمدند. ");
INSERT INTO pesopcb_vpl VALUES ("DT3_6","006_3_6","DEU","3","6","6","ما سرزمین باشان را مثل قلمرو سیحون پادشاه واقع در حشبون، کاملاً نابود کردیم و تمام اهالی آن را چه مرد، چه زن و چه کودک، از بین بردیم؛ ");
INSERT INTO pesopcb_vpl VALUES ("DT3_7","006_3_7","DEU","3","7","7","ولی گله‌ها و غنایم جنگی را برای خود نگه‌داشتیم. ");
INSERT INTO pesopcb_vpl VALUES ("DT3_8","006_3_8","DEU","3","8","8","پس ما بر تمام سرزمین دو پادشاه اموری واقع در شرق رود اردن، یعنی بر تمامی اراضی از دره ارنون تا کوه حرمون، مسلط شدیم. ");
INSERT INTO pesopcb_vpl VALUES ("DT3_9","006_3_9","DEU","3","9","9","(صیدونی‌ها کوه حرمون را سریون و اموری‌ها آن را سنیر می‌خوانند.) ");
INSERT INTO pesopcb_vpl VALUES ("DT3_10","006_3_10","DEU","3","10","10","ما تمامی شهرهای واقع در آن جلگه و تمامی سرزمین جلعاد و باشان را تا شهرهای سلخه و ادرعی تصرف کردیم. ");
INSERT INTO pesopcb_vpl VALUES ("DT3_11","006_3_11","DEU","3","11","11","ناگفته نماند که عوج، پادشاه باشان آخرین بازماندهٔ رفائی‌های غول‌پیکر بود. تختخواب آهنی او که در شهر رَبَت، یکی از شهرهای عمونی‌ها نگهداری می‌شود حدود چهار متر طول و دو متر عرض دارد. ");
INSERT INTO pesopcb_vpl VALUES ("DT3_12","006_3_12","DEU","3","12","12","در آن موقع، من سرزمین تسخیر شده را به قبیله‌های رئوبین و جاد دادم. به قبیله‌های رئوبین و جاد ناحیهٔ شمال عروعیر را که در کنار رود ارنون است به اضافهٔ نصف کوهستان جلعاد را با شهرهایش دادم، ");
INSERT INTO pesopcb_vpl VALUES ("DT3_13","006_3_13","DEU","3","13","13","و به نصف قبیلهٔ منسی باقیماندهٔ سرزمین جلعاد و تمام سرزمین باشان را که قلمرو قبلی عوج پادشاه بود واگذار کردم. (منطقهٔ ارجوب در باشان را سرزمین رفائی‌ها نیز می‌نامند.) ");
INSERT INTO pesopcb_vpl VALUES ("DT3_14","006_3_14","DEU","3","14","14","طایفهٔ یائیر از قبیلهٔ منسی تمامی منطقهٔ ارجوب (باشان) را تا مرزهای جشوری‌ها و معکی‌ها گرفتند و آن سرزمین را به اسم خودشان نامگذاری کرده، آنجا را همچنانکه امروز هم مشهور است حَووت‌یائیر (یعنی «دهستانهای یائیر») نامیدند. ");
INSERT INTO pesopcb_vpl VALUES ("DT3_15","006_3_15","DEU","3","15","15","بعد جلعاد را به طایفهٔ ماخیر دادم. ");
INSERT INTO pesopcb_vpl VALUES ("DT3_16","006_3_16","DEU","3","16","16","اما به قبیله‌های رئوبین و جاد منطقه‌ای را بخشیدم که از رود یبوق در جلعاد (که سرحد عمونی‌ها بود) شروع می‌شد و تا وسط جلگهٔ رود ارنون در جنوب، امتداد می‌یافت. ");
INSERT INTO pesopcb_vpl VALUES ("DT3_17","006_3_17","DEU","3","17","17","مرز غربی ایشان رود اردن بود که از دریاچهٔ جلیل تا دریای مرده و کوه پیسگاه ادامه می‌یافت. ");
INSERT INTO pesopcb_vpl VALUES ("DT3_18","006_3_18","DEU","3","18","18","آنگاه من به قبیله‌های رئوبین و جاد و نصف قبیلهٔ منسی یادآوری کردم که اگرچه خداوند آن سرزمین را به ایشان داده است با این حال حق سکونت در آنجا را نخواهند داشت تا زمانی که مردان مسلحشان در پیشاپیش بقیه قبیله‌ها، آنها را به آن سوی رود اردن یعنی به سرزمینی که خدا به ایشان وعده داده، برسانند. ");
INSERT INTO pesopcb_vpl VALUES ("DT3_19","006_3_19","DEU","3","19","19","به ایشان گفتم: «ولی زنان و فرزندانتان می‌توانند اینجا در این شهرهایی که خداوند به شما داده است سکونت کرده، از گله‌هایتان (که می‌دانم تعدادشان زیاد است) مواظبت کنند. ");
INSERT INTO pesopcb_vpl VALUES ("DT3_20","006_3_20","DEU","3","20","20","شما به برادران خود کمک کنید تا خداوند به آنها نیز پیروزی بدهد. وقتی آنها سرزمینی را که خداوند، خدایتان در آن طرف رود اردن به ایشان داده است تصرف کردند، آنگاه شما می‌توانید به سرزمین خود بازگردید.» ");
INSERT INTO pesopcb_vpl VALUES ("DT3_21","006_3_21","DEU","3","21","21","بعد به یوشع فرمان داده، گفتم: «تو با چشمانت دیدی که یهوه خدایتان با آن دو پادشاه چگونه عمل نمود. او با تمامی ممالک آن طرف رود اردن نیز همین کار را خواهد کرد. ");
INSERT INTO pesopcb_vpl VALUES ("DT3_22","006_3_22","DEU","3","22","22","از مردم آنجا نترسید، چون خداوند، خدایتان برای شما خواهد جنگید.» ");
INSERT INTO pesopcb_vpl VALUES ("DT3_23‏","006_3_23‏","DEU","3","23‏","25","آنگاه از خداوند چنین درخواست نمودم: «ای خداوند، التماس می‌کنم اجازه فرمایی از این رود گذشته، وارد سرزمین موعود بشوم، به سرزمین حاصلخیز آن طرف رود اردن با رشته کوههای آن و به سرزمین لبنان. آرزومندم نتیجه بزرگی و قدرتی را که به ما نشان داده‌ای ببینم. کدام خدا در تمام آسمان و زمین قادر است آنچه را که تو برای ما کرده‌ای بکند؟» ");
INSERT INTO pesopcb_vpl VALUES ("DT3_26","006_3_26","DEU","3","26","26","ولی خداوند به سبب گناهان شما بر من غضبناک بود و به من اجازهٔ عبور نداد. او فرمود: «دیگر از این موضوع سخنی بر زبان نیاور. ");
INSERT INTO pesopcb_vpl VALUES ("DT3_27","006_3_27","DEU","3","27","27","به بالای کوه پیسگاه برو. از آنجا می‌توانی به هر سو نظر اندازی و سرزمین موعود را از دور ببینی؛ ولی از رود اردن عبور نخواهی کرد. ");
INSERT INTO pesopcb_vpl VALUES ("DT3_28","006_3_28","DEU","3","28","28","یوشع را به جانشینی خود بگمار و او را تقویت و تشویق کن، زیرا او قوم را برای فتح سرزمینی که تو از قلهٔ کوه خواهی دید، به آن طرف رودخانه هدایت خواهد کرد.» ");
INSERT INTO pesopcb_vpl VALUES ("DT3_29","006_3_29","DEU","3","29","29","بنابراین ما در درهٔ نزدیک بیت‌فغور ماندیم. ");
INSERT INTO pesopcb_vpl VALUES ("DT4_1","006_4_1","DEU","4","1","1","اکنون ای اسرائیل، به قوانینی که به شما یاد می‌دهم به دقت گوش کنید و اگر می‌خواهید زنده مانده، به سرزمینی که خداوند، خدای پدرانتان به شما داده است داخل شوید و آن را تصاحب کنید از این دستورها اطاعت نمایید. ");
INSERT INTO pesopcb_vpl VALUES ("DT4_2","006_4_2","DEU","4","2","2","قوانین دیگری به اینها نیفزایید و چیزی کم نکنید، بلکه فقط این دستورها را اجرا کنید؛ زیرا این قوانین از جانب خداوند، خدایتان می‌باشد. ");
INSERT INTO pesopcb_vpl VALUES ("DT4_3","006_4_3","DEU","4","3","3","دیدید که چگونه یهوه خدایتان در بعل فغور همهٔ کسانی را که بت بعل را پرستیدند از بین برد، ");
INSERT INTO pesopcb_vpl VALUES ("DT4_4","006_4_4","DEU","4","4","4","ولی همگی شما که به خداوند، خدایتان وفادار بودید تا به امروز زنده مانده‌اید. ");
INSERT INTO pesopcb_vpl VALUES ("DT4_5","006_4_5","DEU","4","5","5","تمام قوانینی را که یهوه، خدایم به من داده است، به شما یاد داده‌ام. پس وقتی به سرزمین موعود وارد شده، آن را تسخیر نمودید از این قوانین اطاعت کنید. ");
INSERT INTO pesopcb_vpl VALUES ("DT4_6","006_4_6","DEU","4","6","6","اگر این دستورها را اجرا کنید به داشتن حکمت و بصیرت مشهور خواهید شد. زمانی که قومهای مجاور، این قوانین را بشنوند خواهند گفت: «این قوم بزرگ از چه حکمت و بصیرتی برخوردار است!» ");
INSERT INTO pesopcb_vpl VALUES ("DT4_7","006_4_7","DEU","4","7","7","هیچ قومی، هر قدر هم که بزرگ باشد، مثل ما خدایی مانند یهوه خدای ما ندارد که در بین آنها بوده، هر وقت او را بخوانند، فوری جواب دهد. ");
INSERT INTO pesopcb_vpl VALUES ("DT4_8","006_4_8","DEU","4","8","8","هیچ قومی، هر قدر هم که بزرگ باشد، چنین احکام و قوانین عادلانه‌ای که امروز به شما یاد دادم، ندارد. ");
INSERT INTO pesopcb_vpl VALUES ("DT4_9","006_4_9","DEU","4","9","9","ولی مواظب باشید و دقت کنید مبادا در طول زندگی‌تان آنچه را که با چشمانتان دیده‌اید فراموش کنید. همهٔ این چیزها را به فرزندان و نوادگانتان تعلیم دهید. ");
INSERT INTO pesopcb_vpl VALUES ("DT4_10","006_4_10","DEU","4","10","10","به یاد آورید آن روزی را که در کوه حوریب در برابر خداوند ایستاده بودید و او به من گفت: «مردم را به حضور من بخوان و من به ایشان تعلیم خواهم داد تا یاد بگیرند همیشه مرا احترام کنند و دستورهای مرا به فرزندانشان بیاموزند.» ");
INSERT INTO pesopcb_vpl VALUES ("DT4_11","006_4_11","DEU","4","11","11","شما در دامنهٔ کوه ایستاده بودید. ابرهای سیاه و تاریکی شدید اطراف کوه را فرا گرفته بود و شعله‌های آتش از آن به آسمان زبانه می‌کشید. ");
INSERT INTO pesopcb_vpl VALUES ("DT4_12","006_4_12","DEU","4","12","12","آنگاه خداوند از میان آتش با شما سخن گفت. شما کلامش را می‌شنیدید، ولی او را نمی‌دیدید. ");
INSERT INTO pesopcb_vpl VALUES ("DT4_13","006_4_13","DEU","4","13","13","او قوانینی را که شما باید اطاعت کنید یعنی «ده فرمان» را اعلام فرمود و آنها را بر دو لوح سنگی نوشت. ");
INSERT INTO pesopcb_vpl VALUES ("DT4_14","006_4_14","DEU","4","14","14","آری، در همان وقت بود که خداوند به من دستور داد قوانینی را که باید بعد از رسیدن به سرزمین موعود اجرا کنید به شما یاد دهم. ");
INSERT INTO pesopcb_vpl VALUES ("DT4_15","006_4_15","DEU","4","15","15","شما در آن روز در کوه حوریب وقتی که خداوند از میان آتش با شما سخن می‌گفت، شکل و صورتی از او ندیدید. پس مواظب باشید ");
INSERT INTO pesopcb_vpl VALUES ("DT4_16","006_4_16","DEU","4","16","16","مبادا با ساختن مجسمه‌ای از خدا خود را آلوده سازید، یعنی با ساختن بُتی به هر شکل، چه به صورت مرد یا زن، ");
INSERT INTO pesopcb_vpl VALUES ("DT4_17","006_4_17","DEU","4","17","17","و چه به صورت حیوان یا پرنده، ");
INSERT INTO pesopcb_vpl VALUES ("DT4_18","006_4_18","DEU","4","18","18","خزنده یا ماهی. ");
INSERT INTO pesopcb_vpl VALUES ("DT4_19","006_4_19","DEU","4","19","19","همچنین وقتی به آسمان نگاه می‌کنید و تمامی لشکر آسمان یعنی خورشید و ماه و ستارگان را که یهوه خدایتان برای تمام قومهای روی زمین آفریده است می‌بینید، آنها را پرستش نکنید. ");
INSERT INTO pesopcb_vpl VALUES ("DT4_20","006_4_20","DEU","4","20","20","خداوند شما را از مصر، از آن کورهٔ آتش، بیرون آورد تا قوم خاص او و میراث او باشید، چنانکه امروز هستید. ");
INSERT INTO pesopcb_vpl VALUES ("DT4_21","006_4_21","DEU","4","21","21","ولی به خاطر شما نسبت به من خشمناک گردید و به تأکید اعلام فرمود که من به آن سوی رود اردن یعنی به سرزمین حاصلخیزی که یهوه خدایتان به شما به میراث داده است نخواهم رفت. ");
INSERT INTO pesopcb_vpl VALUES ("DT4_22","006_4_22","DEU","4","22","22","من اینجا در این سوی رودخانه خواهم مرد، ولی شما از رودخانه عبور خواهید کرد و آن زمین حاصلخیز را تصرف خواهید نمود. ");
INSERT INTO pesopcb_vpl VALUES ("DT4_23","006_4_23","DEU","4","23","23","هوشیار باشید مبادا عهدی را که خداوند، خدایتان با شما بسته است بشکنید! اگر دست به ساختن هرگونه بُتی بزنید آن عهد را می‌شکنید، چون خداوند، خدایتان این کار را به کلی منع کرده است. ");
INSERT INTO pesopcb_vpl VALUES ("DT4_24","006_4_24","DEU","4","24","24","زیرا یهوه خدای شما آتشی سوزاننده و خدایی غیور است. ");
INSERT INTO pesopcb_vpl VALUES ("DT4_25","006_4_25","DEU","4","25","25","حتی اگر سالها در سرزمین موعود ساکن بوده، در آنجا صاحب فرزندان و نوادگان شده باشید، ولی با ساختن بت خود را آلوده کرده با گناهانتان یهوه خدایتان را خشمگین سازید، ");
INSERT INTO pesopcb_vpl VALUES ("DT4_26","006_4_26","DEU","4","26","26","زمین و آسمان را شاهد می‌آورم که در آن سرزمینی که با گذشتن از رود اردن آن را تصاحب خواهید کرد، نابود خواهید شد. عمرتان در آنجا کوتاه خواهد بود و به کلی نابود خواهید شد. ");
INSERT INTO pesopcb_vpl VALUES ("DT4_27","006_4_27","DEU","4","27","27","خداوند شما را در میان قومها پراکنده خواهد کرد و تعدادتان بسیار کم خواهد شد. ");
INSERT INTO pesopcb_vpl VALUES ("DT4_28","006_4_28","DEU","4","28","28","در آنجا، بتهایی را که از چوب و سنگ ساخته شده‌اند پرستش خواهید کرد، بتهایی که نه می‌بینند، نه می‌شنوند، نه می‌بویند و نه می‌خورند. ");
INSERT INTO pesopcb_vpl VALUES ("DT4_29","006_4_29","DEU","4","29","29","ولی اگر شما دوباره شروع به طلبیدن خداوند، خدایتان کنید، زمانی او را خواهید یافت که با تمام دل و جانتان او را طلبیده باشید. ");
INSERT INTO pesopcb_vpl VALUES ("DT4_30","006_4_30","DEU","4","30","30","وقتی در سختی باشید و تمام این حوادث برای شما رخ دهد، آنگاه سرانجام به خداوند، خدایتان روی آورده، آنچه را که او به شما بگوید اطاعت خواهید کرد. ");
INSERT INTO pesopcb_vpl VALUES ("DT4_31","006_4_31","DEU","4","31","31","یهوه، خدای شما رحیم است، پس او شما را ترک نکرده، نابود نخواهد نمود و عهدی را که با پدران شما بسته است فراموش نخواهد کرد. ");
INSERT INTO pesopcb_vpl VALUES ("DT4_32","006_4_32","DEU","4","32","32","در تمامی تاریخ، از وقتی که خدا انسان را روی زمین آفرید، از یک گوشهٔ آسمان تا گوشهٔ دیگر جستجو کنید و ببینید آیا می‌توانید چیزی شبیه به این پیدا کنید که ");
INSERT INTO pesopcb_vpl VALUES ("DT4_33","006_4_33","DEU","4","33","33","قومی صدای خدا را که از میان آتش با آنها سخن گفته است مثل شما شنیده و زنده مانده باشد! ");
INSERT INTO pesopcb_vpl VALUES ("DT4_34","006_4_34","DEU","4","34","34","و آیا تا به حال خدایی کوشیده است که با فرستادن بلاهای ترسناک و آیات و معجزات و جنگ، و با دست نیرومند و بازوی افراشته و اعمال عظیم و ترسناک، قومی را از بردگی قومی دیگر رها سازد؟ ولی یهوه خدایتان همۀ این کارها را در برابر چشمان شما در مصر برای شما انجام داد. ");
INSERT INTO pesopcb_vpl VALUES ("DT4_35","006_4_35","DEU","4","35","35","خداوند این کارها را کرد تا شما بدانید که فقط او خداست و کسی دیگر مانند او وجود ندارد. ");
INSERT INTO pesopcb_vpl VALUES ("DT4_36","006_4_36","DEU","4","36","36","او هنگامی که از آسمان به شما تعلیم می‌داد اجازه داد که شما صدایش را بشنوید؛ او گذاشت که شما ستون بزرگ آتشش را روی زمین ببینید. شما حتی کلامش را از میان آتش شنیدید. ");
INSERT INTO pesopcb_vpl VALUES ("DT4_37","006_4_37","DEU","4","37","37","چون او پدران شما را دوست داشت و اراده نمود که فرزندانشان را برکت دهد، پس شخص شما را از مصر با نمایش عظیمی از قدرت خود بیرون آورد. ");
INSERT INTO pesopcb_vpl VALUES ("DT4_38","006_4_38","DEU","4","38","38","او قومهای دیگر را که قویتر و بزرگتر از شما بودند پراکنده نمود و سرزمینشان را به طوری که امروز مشاهده می‌کنید، به شما بخشید. ");
INSERT INTO pesopcb_vpl VALUES ("DT4_39","006_4_39","DEU","4","39","39","پس امروز به خاطر آرید و فراموش نکنید که خداوند، هم خدای آسمانها و هم خدای زمین است و هیچ خدایی غیر از او وجود ندارد! ");
INSERT INTO pesopcb_vpl VALUES ("DT4_40","006_4_40","DEU","4","40","40","شما باید قوانینی را که امروز به شما می‌دهم اطاعت کنید تا خود و فرزندانتان کامیاب بوده، تا به ابد در سرزمینی که خداوند، خدایتان به شما می‌بخشد زندگی کنید. ");
INSERT INTO pesopcb_vpl VALUES ("DT4_41","006_4_41","DEU","4","41","41","آنگاه موسی سه شهر در شرق رود اردن تعیین کرد ");
INSERT INTO pesopcb_vpl VALUES ("DT4_42","006_4_42","DEU","4","42","42","تا اگر کسی ناخواسته شخصی را بکشد بدون اینکه قبلاً با او دشمنی داشته باشد، برای فرار از خطر به آنجا پناه ببرد. ");
INSERT INTO pesopcb_vpl VALUES ("DT4_43","006_4_43","DEU","4","43","43","این شهرها عبارت بودند از: باصر واقع در اراضی مسطح بیابان برای قبیلهٔ رئوبین، راموت در جلعاد برای قبیلهٔ جاد، و جولان در باشان برای قبیلهٔ منسی. ");
INSERT INTO pesopcb_vpl VALUES ("DT4_44‏","006_4_44‏","DEU","4","44‏","46","وقتی قوم اسرائیل از مصر خارج شده و در شرق رود اردن در کنار شهر بیت‌فغور اردو زده بودند، موسی قوانین خدا را به آنها داد. (این همان سرزمینی بود که قبلاً اموری‌ها در زمان سلطنت سیحون پادشاه که پایتختش حشبون بود در آنجا سکونت داشتند و موسی و بنی‌اسرائیل وی را با مردمش نابود کردند. ");
INSERT INTO pesopcb_vpl VALUES ("DT4_47","006_4_47","DEU","4","47","47","آنها بر سرزمین او و بر سرزمین عوج، پادشاه باشان که هر دو از پادشاهان اموری‌های شرق رود اردن بودند غلبه یافتند. ");
INSERT INTO pesopcb_vpl VALUES ("DT4_48","006_4_48","DEU","4","48","48","این سرزمین از عروعیر در کنار رود ارنون تا کوه سریون که همان حرمون باشد، امتداد می‌یافت ");
INSERT INTO pesopcb_vpl VALUES ("DT4_49","006_4_49","DEU","4","49","49","و شامل تمام منطقهٔ شرق رود اردن که از جنوب به دریای مرده و از شرق به دامنهٔ کوه پیسگاه منتهی می‌شد، بود.) ");
INSERT INTO pesopcb_vpl VALUES ("DT5_1","006_5_1","DEU","5","1","1","موسی به سخنانش ادامه داده، گفت: ای قوم اسرائیل، اکنون به فرایض و قوانینی که به شما می‌دهم، گوش کنید. آنها را یاد بگیرید و به دقت انجام دهید. ");
INSERT INTO pesopcb_vpl VALUES ("DT5_2","006_5_2","DEU","5","2","2","یهوه، خدایمان در کوه حوریب عهدی با ما بست. ");
INSERT INTO pesopcb_vpl VALUES ("DT5_3","006_5_3","DEU","5","3","3","این عهد را نه با پدرانمان بلکه با ما که امروز زنده هستیم بست. ");
INSERT INTO pesopcb_vpl VALUES ("DT5_4","006_5_4","DEU","5","4","4","او در آن کوه از میان آتش رو در رو با شما سخن گفت. ");
INSERT INTO pesopcb_vpl VALUES ("DT5_5","006_5_5","DEU","5","5","5","من به عنوان واسطه‌ای بین شما و خداوند ایستادم، زیرا شما از آن آتش می‌ترسیدید و بالای کوه پیش او نرفتید. او با من سخن گفت و من قوانینش را به شما سپردم. آنچه فرمود این است: ");
INSERT INTO pesopcb_vpl VALUES ("DT5_6","006_5_6","DEU","5","6","6","«من خداوند، خدای تو هستم، همان خدایی که تو را از اسارت و بندگی مصر آزاد کرد. ");
INSERT INTO pesopcb_vpl VALUES ("DT5_7","006_5_7","DEU","5","7","7","«تو را خدایان دیگر غیر از من نباشد. ");
INSERT INTO pesopcb_vpl VALUES ("DT5_8","006_5_8","DEU","5","8","8","«هیچگونه بُتی به شکل آنچه بالا در آسمان و آنچه بر زمین و آنچه در دریاست برای خود درست نکن. ");
INSERT INTO pesopcb_vpl VALUES ("DT5_9","006_5_9","DEU","5","9","9","در برابر آنها زانو نزن و آنها را پرستش نکن، زیرا من که خداوند، خدای تو می‌باشم، خدای غیوری هستم و کسانی را که از من نفرت دارند مجازات می‌کنم. این مجازات شامل حال فرزندان آنها تا نسل سوم و چهارم نیز می‌گردد. ");
INSERT INTO pesopcb_vpl VALUES ("DT5_10","006_5_10","DEU","5","10","10","اما بر کسانی که مرا دوست بدارند و دستورهای مرا پیروی کنند، تا هزار پشت رحمت می‌کنم. ");
INSERT INTO pesopcb_vpl VALUES ("DT5_11","006_5_11","DEU","5","11","11","«نام یهوه، خدای خود را نابجا به کار نبر. اگر نام مرا با بی‌احترامی بر زبان بیاوری یا به آن قسم دروغ بخوری، تو را بی‌سزا نخواهم گذاشت. ");
INSERT INTO pesopcb_vpl VALUES ("DT5_12","006_5_12","DEU","5","12","12","«روز شَبّات را به یاد داشته باش و آن را مقدّس بدار. من که خداوند، خدای تو هستم این را به تو امر می‌کنم. ");
INSERT INTO pesopcb_vpl VALUES ("DT5_13","006_5_13","DEU","5","13","13","در هفته شش روز کار کن، ");
INSERT INTO pesopcb_vpl VALUES ("DT5_14","006_5_14","DEU","5","14","14","ولی در روز هفتم که شَبّات یهوه خدای توست هیچ کاری نکن نه خودت، نه پسرت، نه دخترت، نه غلامت، نه کنیزت، نه مهمانانت و نه حتی چارپایانت. غلام و کنیزت باید مثل خودت استراحت کنند. ");
INSERT INTO pesopcb_vpl VALUES ("DT5_15","006_5_15","DEU","5","15","15","به یاد آور که در سرزمین مصر غلام بودی و من که خداوند، خدای تو هستم با قدرت و قوت عظیم خود تو را از آنجا بیرون آوردم. به این دلیل است که به تو امر می‌کنم شَبّات را نگه داری. ");
INSERT INTO pesopcb_vpl VALUES ("DT5_16","006_5_16","DEU","5","16","16","«پدر و مادر خود را گرامی بدار، زیرا این فرمان خداوند، خدای توست. اگر چنین کنی، در سرزمینی که خداوند، خدایت به تو خواهد بخشید، عمری طولانی و پربرکت خواهی داشت. ");
INSERT INTO pesopcb_vpl VALUES ("DT5_17","006_5_17","DEU","5","17","17","«قتل نکن. ");
INSERT INTO pesopcb_vpl VALUES ("DT5_18","006_5_18","DEU","5","18","18","«زنا نکن. ");
INSERT INTO pesopcb_vpl VALUES ("DT5_19","006_5_19","DEU","5","19","19","«دزدی نکن. ");
INSERT INTO pesopcb_vpl VALUES ("DT5_20","006_5_20","DEU","5","20","20","«بر همنوع خود شهادت دروغ نده. ");
INSERT INTO pesopcb_vpl VALUES ("DT5_21","006_5_21","DEU","5","21","21","«به زن همسایه‌ات طمع نکن. و حسرت خانۀ همسایه خود، یا مزرعۀ او، یا غلام و کنیزش، یا گاو و الاغش، یا اموالش را نخور.» ");
INSERT INTO pesopcb_vpl VALUES ("DT5_22","006_5_22","DEU","5","22","22","این بود قوانینی که خداوند در کوه سینا به شما داد. او این قوانین را با صدای بلند از میان آتش و ابر غلیظ اعلام فرمود و غیر از این قوانین، قانون دیگری نداد. آنها را روی دو لوح سنگی نوشت و به من داد. ");
INSERT INTO pesopcb_vpl VALUES ("DT5_23","006_5_23","DEU","5","23","23","ولی وقتی که آن صدای بلند از درون تاریکی به گوشتان رسید و آتش مهیب سر کوه را دیدید کلیهٔ رهبران قبایل و مشایخ شما نزد من آمدند ");
INSERT INTO pesopcb_vpl VALUES ("DT5_24","006_5_24","DEU","5","24","24","و گفتند: «امروز خداوند، خدایمان جلال و عظمتش را به ما نشان داده است، ما حتی صدایش را از درون آتش شنیدیم. اکنون می‌دانیم که ممکن است خدا با انسان صحبت کند و او نمیرد. ");
INSERT INTO pesopcb_vpl VALUES ("DT5_25","006_5_25","DEU","5","25","25","پس چرا جان خود را به خطر بیاندازیم؟ بدون شک اگر یهوه خدایمان دوباره با ما سخن بگوید خواهیم مرد. این آتش هولناک، ما را خواهد سوزانید. ");
INSERT INTO pesopcb_vpl VALUES ("DT5_26","006_5_26","DEU","5","26","26","چه کسی می‌تواند صدای خدای زنده را که از درون آتش سخن می‌گوید، بشنود و زنده بماند؟ ");
INSERT INTO pesopcb_vpl VALUES ("DT5_27","006_5_27","DEU","5","27","27","پس تو برو و به تمامی سخنانی که یهوه خدای ما می‌گوید گوش کن، بعد آمده، آنها را برای ما بازگو کن و ما آنها را پذیرفته، اطاعت خواهیم کرد.» ");
INSERT INTO pesopcb_vpl VALUES ("DT5_28","006_5_28","DEU","5","28","28","خداوند درخواستتان را پذیرفت و به من گفت: «آنچه که قوم اسرائیل به تو گفتند شنیدم و آنچه گفتند نیکوست. ");
INSERT INTO pesopcb_vpl VALUES ("DT5_29","006_5_29","DEU","5","29","29","ای کاش همیشه چنین دلی داشته باشند و از من بترسند و تمام اوامر مرا بجا آورند. در آن صورت زندگی خودشان و زندگی فرزندانشان در تمام نسلها با خیر و برکت خواهد گذشت. ");
INSERT INTO pesopcb_vpl VALUES ("DT5_30","006_5_30","DEU","5","30","30","اکنون برو و به آنها بگو که به خیمه‌هایشان بازگردند. ");
INSERT INTO pesopcb_vpl VALUES ("DT5_31","006_5_31","DEU","5","31","31","سپس برگشته، اینجا در کنار من بایست و من تمامی اوامرم را به تو خواهم داد. تو باید آنها را به قوم تعلیم دهی تا فرایض و قوانین مرا در سرزمینی که به ایشان می‌دهم اطاعت کنند.» ");
INSERT INTO pesopcb_vpl VALUES ("DT5_32","006_5_32","DEU","5","32","32","پس بایستی تمام اوامر یهوه، خدایتان را اطاعت کنید و دستورهای او را به دقت به‌جا آورید ");
INSERT INTO pesopcb_vpl VALUES ("DT5_33","006_5_33","DEU","5","33","33","و در طریقی که یهوه خدایتان به شما امر کرده گام بردارید و بمانید. اگر چنین کنید در سرزمینی که به تصرف درمی‌آورید زندگی طولانی و پربرکتی خواهید داشت. ");
INSERT INTO pesopcb_vpl VALUES ("DT6_1","006_6_1","DEU","6","1","1","یهوه، خدایتان به من فرمود که تمامی این فرمانها و فرایض و قوانین را به شما تعلیم دهم تا در سرزمینی که به‌زودی وارد آن می‌شوید، آنها را بجا آورید، ");
INSERT INTO pesopcb_vpl VALUES ("DT6_2","006_6_2","DEU","6","2","2","و بدین ترتیب شما و پسران و نوادگانتان یهوه، خدایتان را با اطاعت از تمامی فرایض و فرمانهای او در تمام طول زندگی خود احترام کنید تا عمر طولانی داشته باشید. ");
INSERT INTO pesopcb_vpl VALUES ("DT6_3","006_6_3","DEU","6","3","3","بنابراین ای اسرائیل به هر یک از فرامین به دقت گوش کنید و مواظب باشید آنها را اطاعت کنید تا زندگی پربرکتی داشته باشید. اگر این دستورها را بجا آورید در سرزمین حاصلخیزی که در آن شیر و عسل جاری است همچنانکه خداوند، خدای پدرانتان به شما وعده فرمود، قوم بزرگی خواهید شد. ");
INSERT INTO pesopcb_vpl VALUES ("DT6_4","006_6_4","DEU","6","4","4","بشنو، ای اسرائیل، یهوه خدای ما، خداوندِ یکتاست. ");
INSERT INTO pesopcb_vpl VALUES ("DT6_5","006_6_5","DEU","6","5","5","یهوه خدای خود را با تمامی دل و با تمامی جان و با تمامی قوّت خود دوست بدار. ");
INSERT INTO pesopcb_vpl VALUES ("DT6_6","006_6_6","DEU","6","6","6","این قوانینی که امروز به شما می‌دهم باید دائم در فکر و دلتان باشد. ");
INSERT INTO pesopcb_vpl VALUES ("DT6_7","006_6_7","DEU","6","7","7","آنها را به فرزندان خود بیاموزید و همیشه دربارهٔ آنها صحبت کنید خواه در خانه باشید خواه در بیرون، خواه هنگام خواب باشد خواه اول صبح. ");
INSERT INTO pesopcb_vpl VALUES ("DT6_8","006_6_8","DEU","6","8","8","آنها را همچون نشان روی انگشت و پیشانی خود ببندید؛ ");
INSERT INTO pesopcb_vpl VALUES ("DT6_9","006_6_9","DEU","6","9","9","آنها را بر سر در منازل خود و بر دروازه‌هایتان بنویسید. ");
INSERT INTO pesopcb_vpl VALUES ("DT6_10‏","006_6_10‏","DEU","6","10‏","12","وقتی که خداوند، خدایتان شما را به سرزمینی که با سوگند به پدرانتان ابراهیم و اسحاق و یعقوب وعده داده است برساند یعنی به شهرهای بزرگ و زیبایی که شما بنا نکرده‌اید و خانه‌هایی پر از چیزهای خوب که شما آنها را تهیه نکرده‌اید، چاههایی که شما نکنده‌اید، تاکستانها و درختان زیتونی که شما نکاشته‌اید، آنگاه وقتی که خوردید و سیر شدید مواظب باشید خداوند را که شما را از سرزمین بندگی مصر بیرون آورد فراموش نکنید. ");
INSERT INTO pesopcb_vpl VALUES ("DT6_13","006_6_13","DEU","6","13","13","از خداوند، خدایتان بترسید، او را عبادت کنید و تنها به نام او قسم بخورید. ");
INSERT INTO pesopcb_vpl VALUES ("DT6_14","006_6_14","DEU","6","14","14","خدایان قومهای همسایه را پرستش نکنید؛ ");
INSERT INTO pesopcb_vpl VALUES ("DT6_15","006_6_15","DEU","6","15","15","زیرا خداوند، خدایتان که در میان شما زندگی می‌کند خدای غیوری است و ممکن است خشم او بر شما افروخته شده، شما را از روی زمین نابود کند. ");
INSERT INTO pesopcb_vpl VALUES ("DT6_16","006_6_16","DEU","6","16","16","یهوه، خدای خود را آزمایش نکنید، چنانکه در مَسّا این کار را کردید. ");
INSERT INTO pesopcb_vpl VALUES ("DT6_17","006_6_17","DEU","6","17","17","فرمانهای یهوه خدای خود، یعنی همۀ قوانین و فرایض او را نگاه دارید. ");
INSERT INTO pesopcb_vpl VALUES ("DT6_18","006_6_18","DEU","6","18","18","آنچه را که خداوند می‌پسندد انجام دهید تا زندگیتان پربرکت شود و به سرزمین حاصلخیزی که خداوند به پدرانتان وعده داده، وارد شوید و آن را تصرف کنید ");
INSERT INTO pesopcb_vpl VALUES ("DT6_19","006_6_19","DEU","6","19","19","و تمام دشمنان را به کمک خداوند بیرون رانید، همان‌طور که خداوند به شما وعده داده است. ");
INSERT INTO pesopcb_vpl VALUES ("DT6_20","006_6_20","DEU","6","20","20","در سالهای آینده، زمانی که پسرانتان از شما بپرسند: «منظور از این قوانین، فرایض و مقرراتی که خداوند، خدایمان به ما داده است چیست؟» ");
INSERT INTO pesopcb_vpl VALUES ("DT6_21","006_6_21","DEU","6","21","21","به ایشان بگویید: «ما بردگان فرعون مصر بودیم و خداوند با قدرت عظیمش ");
INSERT INTO pesopcb_vpl VALUES ("DT6_22","006_6_22","DEU","6","22","22","و با معجزات بزرگ و بلاهای وحشتناکی که بر مصر و فرعون و تمام افرادش نازل کرد ما را از سرزمین مصر بیرون آورد. ما همهٔ این کارها را با چشمان خود دیدیم. ");
INSERT INTO pesopcb_vpl VALUES ("DT6_23","006_6_23","DEU","6","23","23","او ما را از زمین مصر بیرون آورد تا بتواند این سرزمین را که با سوگند به پدرانمان وعده داده بود به ما بدهد. ");
INSERT INTO pesopcb_vpl VALUES ("DT6_24","006_6_24","DEU","6","24","24","او به ما امر فرموده است که تمامی این قوانین را اطاعت کرده، به یهوه خدایمان احترام بگذاریم. اگر چنین کنیم او ما را برکت می‌دهد و زنده نگه می‌دارد، چنانکه تا امروز کرده است. ");
INSERT INTO pesopcb_vpl VALUES ("DT6_25","006_6_25","DEU","6","25","25","اگر هر چه را یهوه خدایمان فرموده است با اطاعت کامل انجام دهیم، او ما را عادل خواهد شمرد.» ");
INSERT INTO pesopcb_vpl VALUES ("DT7_1","006_7_1","DEU","7","1","1","هنگامی که یهوه خدایتان شما را به سرزمینی که برای تصرفش می‌روید، ببرد، این هفت قوم را که همگی از شما بزرگتر و قویترند نابود خواهد ساخت: حیتی‌ها، جرجاشی‌ها، اموری‌ها، کنعانی‌ها، فرزی‌ها، حوی‌ها و یبوسی‌ها. ");
INSERT INTO pesopcb_vpl VALUES ("DT7_2","006_7_2","DEU","7","2","2","زمانی که خداوند، خدایتان آنها را به شما تسلیم کند و شما آنها را مغلوب نمایید، باید همهٔ آنها را بکشید. با آنها معاهده‌ای نبندید و به آنها رحم نکنید، بلکه ایشان را به کلی نابود سازید. ");
INSERT INTO pesopcb_vpl VALUES ("DT7_3","006_7_3","DEU","7","3","3","با آنها ازدواج نکنید و نگذارید فرزندانتان با پسران و دختران ایشان ازدواج کنند. ");
INSERT INTO pesopcb_vpl VALUES ("DT7_4","006_7_4","DEU","7","4","4","چون در نتیجهٔ ازدواج با آنها جوانانتان به بت‌پرستی کشیده خواهند شد و همین سبب خواهد شد که خشم خداوند نسبت به شما افروخته شود و شما را به کلی نابود سازد. ");
INSERT INTO pesopcb_vpl VALUES ("DT7_5","006_7_5","DEU","7","5","5","مذبحهایشان را بشکنید، ستونهایی را که می‌پرستند خرد کنید و مجسمه‌های شرم‌آور را تکه‌تکه نموده، بتهایشان را بسوزانید؛ ");
INSERT INTO pesopcb_vpl VALUES ("DT7_6","006_7_6","DEU","7","6","6","چون شما قوم مقدّسی هستید که به خداوند، خدایتان اختصاص یافته‌اید. او از بین تمام مردم روی زمین شما را انتخاب کرده است تا گنج خاص او باشید. ");
INSERT INTO pesopcb_vpl VALUES ("DT7_7","006_7_7","DEU","7","7","7","شما کوچکترین قوم روی زمین بودید، پس خداوند شما را به سبب اینکه قومی بزرگتر از سایر قومها بودید برنگزید و محبت نکرد، ");
INSERT INTO pesopcb_vpl VALUES ("DT7_8","006_7_8","DEU","7","8","8","بلکه به این دلیل که شما را دوست داشت و می‌خواست عهد خود را که با پدرانتان بسته بود بجا آورد. به همین دلیل است که او شما را با چنین قدرت و معجزات عجیب و بزرگی از بردگی و از چنگ فرعون پادشاه مصر رهانید. ");
INSERT INTO pesopcb_vpl VALUES ("DT7_9","006_7_9","DEU","7","9","9","پس بدانید که تنها خدایی که وجود دارد یهوه، خدایتان است و او همان خدای امینی است که تا هزاران نسل عهد خود را نگاه داشته، پیوسته کسانی را که او را دوست می‌دارند و دستورهایش را اطاعت می‌کنند محبت می‌نماید. ");
INSERT INTO pesopcb_vpl VALUES ("DT7_10","006_7_10","DEU","7","10","10","ولی آنانی را که از او نفرت دارند بی‌درنگ مجازات و نابود می‌کند. ");
INSERT INTO pesopcb_vpl VALUES ("DT7_11","006_7_11","DEU","7","11","11","بنابراین تمام فرمانها و فرایض و قوانینی را که امروز به شما می‌دهم اجرا کنید. ");
INSERT INTO pesopcb_vpl VALUES ("DT7_12","006_7_12","DEU","7","12","12","اگر به این قوانین توجه کرده، آنها را اطاعت نمایید، یهوه، خدایتان عهدی را که از روی رحمت خویش برای پدرانتان سوگند خورد، ادا خواهد کرد. ");
INSERT INTO pesopcb_vpl VALUES ("DT7_13","006_7_13","DEU","7","13","13","او شما را دوست خواهد داشت و برکت خواهد داد و از شما قومی بزرگ به وجود خواهد آورد. او شما را بارور نموده، زمین و حیواناتتان را برکت خواهد داد تا محصول زیادی از گندم، انگور، زیتون و گله‌های گاو و گوسفند داشته باشید. تمام این برکات را در سرزمینی که با سوگند به پدرانتان وعده فرمود، به شما خواهد بخشید. ");
INSERT INTO pesopcb_vpl VALUES ("DT7_14","006_7_14","DEU","7","14","14","بیشتر از تمامی قومهای روی زمین برکت خواهید یافت و در میان شما و حتی میان گله‌هایتان نازا وجود نخواهد داشت. ");
INSERT INTO pesopcb_vpl VALUES ("DT7_15","006_7_15","DEU","7","15","15","خداوند تمام بیماریهایتان را از شما دور نموده، اجازه نخواهد داد به هیچ‌کدام از بیماریهای هولناکی که در مصر دیده‌اید دچار شوید. او همهٔ این بیماریها را به دشمنانتان خواهد داد. ");
INSERT INTO pesopcb_vpl VALUES ("DT7_16","006_7_16","DEU","7","16","16","تمامی قومهایی را که خداوند، خدایتان به دست شما گرفتار می‌سازد نابود کنید. به ایشان رحم نکنید و خدایان ایشان را پرستش ننمایید، و گرنه در دام مهلکی گرفتار خواهید شد. ");
INSERT INTO pesopcb_vpl VALUES ("DT7_17","006_7_17","DEU","7","17","17","شاید پیش خودتان فکر کنید: «چگونه می‌توانیم بر این قومهایی که از ما قویترند پیروز شویم؟» ");
INSERT INTO pesopcb_vpl VALUES ("DT7_18","006_7_18","DEU","7","18","18","ولی از آنها باک نداشته باشید! کافیست آنچه را خداوند، خدایتان با فرعون و سراسر سرزمین مصر کرد به خاطر آورید. ");
INSERT INTO pesopcb_vpl VALUES ("DT7_19","006_7_19","DEU","7","19","19","آیا بلاهای وحشتناکی را که خداوند بر سر آنها آورد و شما با چشمان خود آن را دیدید و نیز معجزات بزرگ و قوت و قدرت خداوند را که بدان وسیله شما را از سرزمین مصر بیرون آورد به خاطر دارید؟ پس بدانید که خداوند، خدایتان همین قدرت را علیه مردمی که از آنها می‌ترسید به کار خواهد برد. ");
INSERT INTO pesopcb_vpl VALUES ("DT7_20","006_7_20","DEU","7","20","20","از این گذشته، خداوند، خدایتان زنبورهای سرخ و درشتی خواهد فرستاد تا آن عده از دشمنانتان را نیز که خود را پنهان کرده‌اند، نابود سازد. ");
INSERT INTO pesopcb_vpl VALUES ("DT7_21","006_7_21","DEU","7","21","21","بنابراین از آن قومها نترسید، زیرا خداوند، خدایتان در میان شماست. او خدایی است بزرگ و مهیب. ");
INSERT INTO pesopcb_vpl VALUES ("DT7_22","006_7_22","DEU","7","22","22","یهوه خدایتان به تدریج آنها را بیرون خواهد راند. این کار را به سرعت انجام نخواهد داد، زیرا اگر چنین کند حیوانات وحشی به‌زودی افزایش یافته، برای شما ایجاد خطر خواهند کرد. ");
INSERT INTO pesopcb_vpl VALUES ("DT7_23","006_7_23","DEU","7","23","23","اما یهوه خدایتان این کار را به تدریج انجام خواهد داد و شما هم به آن قومها حمله نموده، آنها را از بین خواهید برد. ");
INSERT INTO pesopcb_vpl VALUES ("DT7_24","006_7_24","DEU","7","24","24","او پادشاهان آنها را به دست شما خواهد سپرد و شما نام ایشان را از صفحهٔ روزگار محو خواهید کرد. هیچ‌کس یارای مقاومت در برابر شما را نخواهد داشت، و شما همگی آنها را نابود خواهید کرد. ");
INSERT INTO pesopcb_vpl VALUES ("DT7_25","006_7_25","DEU","7","25","25","بتهایشان را بسوزانید و به طلا و نقره‌ای که این بتها از آن ساخته شده‌اند طمع نکنید و آن را برندارید و گرنه گرفتار خواهید شد، زیرا خداوند، خدایتان از بتها متنفر است. ");
INSERT INTO pesopcb_vpl VALUES ("DT7_26","006_7_26","DEU","7","26","26","بُتی را به خانهٔ خود نبرید، چون همان لعنتی که بر آن است بر شما نیز خواهد بود. از بتها نفرت و کراهت داشته باشید، چون لعنت شده‌اند. ");
INSERT INTO pesopcb_vpl VALUES ("DT8_1","006_8_1","DEU","8","1","1","اگر تمام فرامینی را که امروز به شما می‌دهم اطاعت کنید نه تنها زنده خواهید ماند، بلکه تعدادتان نیز افزایش خواهد یافت و به سرزمینی که خداوند با سوگند به پدرانتان وعده نموده، خواهید رفت و آن را تصرف خواهید کرد. ");
INSERT INTO pesopcb_vpl VALUES ("DT8_2","006_8_2","DEU","8","2","2","به خاطر آورید چگونه یهوه خدایتان شما را در بیابان چهل سال تمام هدایت کرد و شما را در تنگی قرار داده، آزمایش کرد تا ببیند واکنش شما چیست و آیا براستی از او اطاعت می‌کنید یا نه. ");
INSERT INTO pesopcb_vpl VALUES ("DT8_3","006_8_3","DEU","8","3","3","آری، او شما را در سختی و گرسنگی نگه داشت و بعد به شما خوراک مَنّا را داد تا بخورید، غذایی که شما و پدرانتان قبلاً از آن بی‌اطلاع بودید. او چنین کرد تا به شما بفهماند که انسان تنها به نان زنده نیست، بلکه به هر کلامی که از دهان خداوند صادر می‌شود. ");
INSERT INTO pesopcb_vpl VALUES ("DT8_4","006_8_4","DEU","8","4","4","در تمام این چهل سال لباسهایتان کهنه نشد و پاهایتان تاول نزد. ");
INSERT INTO pesopcb_vpl VALUES ("DT8_5","006_8_5","DEU","8","5","5","بنابراین باید بفهمید چنانکه پدر پسر خود را تنبیه می‌کند، یهوه خدایتان نیز شما را تأدیب نموده است. ");
INSERT INTO pesopcb_vpl VALUES ("DT8_6","006_8_6","DEU","8","6","6","فرمانهای یهوه، خدایتان را اطاعت کنید. از او پیروی نمایید و از وی بترسید. ");
INSERT INTO pesopcb_vpl VALUES ("DT8_7","006_8_7","DEU","8","7","7","خداوند، خدایتان شما را به سرزمین حاصلخیزی می‌برد، سرزمینی که در دره‌ها و کوههایش نهرها و رودها و چشمه‌ها جاری است. ");
INSERT INTO pesopcb_vpl VALUES ("DT8_8","006_8_8","DEU","8","8","8","آنجا سرزمین گندم و جو، انگور و انجیر، انار و زیتون، و عسل است. ");
INSERT INTO pesopcb_vpl VALUES ("DT8_9","006_8_9","DEU","8","9","9","سرزمینی است که در آن آهن مثل ریگ، فراوان است و مسِ بسیار در تپه‌هایش یافت می‌شود. سرزمینی است که خوراک در آن فراوان است و شما محتاج به چیزی نخواهید بود. ");
INSERT INTO pesopcb_vpl VALUES ("DT8_10","006_8_10","DEU","8","10","10","در آنجا خواهید خورد و سیر خواهید شد و خداوند، خدایتان را به خاطر سرزمین حاصلخیزی که به شما داده است شکر خواهید کرد. ");
INSERT INTO pesopcb_vpl VALUES ("DT8_11","006_8_11","DEU","8","11","11","اما مواظب باشید که در هنگام فراوانی، یهوه خدایتان را فراموش نکنید و از فرمانها و قوانین و فرایض او که امروز به شما می‌دهم سرپیچی ننمایید. ");
INSERT INTO pesopcb_vpl VALUES ("DT8_12‏","006_8_12‏","DEU","8","12‏","13","زیرا وقتی که شکمتان سیر شود و برای سکونت خود خانه‌های خوبی بسازید و گله‌ها و رمه‌هایتان فراوان شوند و طلا و نقره و اموالتان زیاد گردد، ");
INSERT INTO pesopcb_vpl VALUES ("DT8_14","006_8_14","DEU","8","14","14","همان وقت است که باید مواظب باشید مغرور نشوید و خداوند، خدایتان را که شما را از بردگی در مصر بیرون آورد فراموش نکنید. ");
INSERT INTO pesopcb_vpl VALUES ("DT8_15","006_8_15","DEU","8","15","15","مواظب باشید خدایی را که شما را در بیابان ترسناک و بزرگ، در آن زمین خشک و بی‌آب و علف که پر از مارهای سمی و عقربها بود، هدایت کرد فراموش نکنید. او از دل صخره به شما آب داد! ");
INSERT INTO pesopcb_vpl VALUES ("DT8_16","006_8_16","DEU","8","16","16","او با مَنّا شما را در بیابان سیر کرد، غذایی که پدرانتان از آن بی‌اطلاع بودند، و او شما را در تنگی قرار داد و آزمایش کرد تا در آخر به شما برکت دهد. ");
INSERT INTO pesopcb_vpl VALUES ("DT8_17","006_8_17","DEU","8","17","17","او چنین کرد تا شما هیچگاه تصور نکنید که با قدرت و توانایی خودتان ثروتمند شدید. ");
INSERT INTO pesopcb_vpl VALUES ("DT8_18","006_8_18","DEU","8","18","18","همیشه به خاطر داشته باشید که خداوند، خدایتان است که توانایی ثروتمند شدن را به شما می‌دهد. او این کار را می‌کند تا وعده‌ای را که با سوگند به پدرانتان داد، بجا آورد. ");
INSERT INTO pesopcb_vpl VALUES ("DT8_19‏","006_8_19‏","DEU","8","19‏","20","ولی اگر خداوند، خدایتان را فراموش کنید و به دنبال خدایان دیگر رفته، آنها را پرستش کنید بدون شک نابود خواهید شد، درست همان‌طور که خداوند قومهای دیگر را که با شما مقابله می‌کنند نابود می‌سازد. اگر از خداوند، خدایتان اطاعت نکنید سرنوشت شما نیز چنین خواهد بود. ");
INSERT INTO pesopcb_vpl VALUES ("DT9_1‏","006_9_1‏","DEU","9","1‏","2","ای قوم اسرائیل گوش کنید! امروز باید از رود اردن بگذرید تا سرزمین آن سوی رودخانه را تصرف کنید. قومهایی که در آنجا زندگی می‌کنند بزرگتر و قویتر از شما هستند و شهرهایی بزرگ با حصارهایی سر به فلک کشیده دارند. آنها غولهایی هستند از نسل عمالیق معروف که گفته می‌شود کسی نمی‌تواند در برابر ایشان ایستادگی کند. ");
INSERT INTO pesopcb_vpl VALUES ("DT9_3","006_9_3","DEU","9","3","3","ولی بدانید که خداوند، خدایتان مثل آتشی سوزاننده پیشاپیش شما در حرکت خواهد بود و آنها را هلاک خواهد کرد. همان‌طور که خداوند فرموده است شما به‌زودی بر آنها پیروز شده، آنها را از سرزمینشان بیرون خواهید راند. ");
INSERT INTO pesopcb_vpl VALUES ("DT9_4","006_9_4","DEU","9","4","4","پس از آنکه یهوه خدایتان این کار را برایتان کرد، نگویید: «چون ما مردم خوبی هستیم خداوند، ما را به این سرزمین آورده تا آن را تصاحب کنیم.» زیرا خداوند به دلیل شرارت اقوام این سرزمین است که آنها را از آنجا بیرون می‌راند. ");
INSERT INTO pesopcb_vpl VALUES ("DT9_5","006_9_5","DEU","9","5","5","یهوه خدایتان به هیچ وجه به سبب اینکه شما قومی خوب و درستکار هستید این سرزمین را به شما نمی‌دهد، بلکه به سبب شرارت این اقوام و برای وعده‌هایی که با سوگند به پدرانتان ابراهیم و اسحاق و یعقوب داده است این کار را می‌کند. ");
INSERT INTO pesopcb_vpl VALUES ("DT9_6","006_9_6","DEU","9","6","6","باز هم تکرار می‌کنم: خداوند، خدایتان به این دلیل این سرزمین حاصلخیز را به شما نمی‌دهد که مردم خوبی هستید. شما مردمی سرکش هستید. ");
INSERT INTO pesopcb_vpl VALUES ("DT9_7","006_9_7","DEU","9","7","7","فراموش نکنید که از روزی که از مصر بیرون آمدید تا به حال مدام خداوند، خدایتان را در بیابان به خشم آورده‌اید و در تمام این مدت علیه او قیام کرده‌اید. ");
INSERT INTO pesopcb_vpl VALUES ("DT9_8","006_9_8","DEU","9","8","8","او را در کوه حوریب خشمگین ساختید به حدی که خواست شما را نابود کند. ");
INSERT INTO pesopcb_vpl VALUES ("DT9_9","006_9_9","DEU","9","9","9","من به کوه رفته بودم تا عهدی را که خداوند، خدایتان با شما بسته بود یعنی همان لوحهای سنگی که قوانین روی آنها حک شده بود، بگیرم. چهل شبانه روز در آنجا بودم و در تمام این مدت لب به غذا نزدم و حتی یک جرعه آب هم ننوشیدم. ");
INSERT INTO pesopcb_vpl VALUES ("DT9_10‏","006_9_10‏","DEU","9","10‏","11","در پایان آن چهل شبانه روز، خداوند آن دو لوح سنگی را که قوانین عهد خود را بر آنها نوشته بود، به من داد. این همان قوانینی بود که او هنگامی که مردم در پای کوه جمع شده بودند از درون آتش اعلام فرموده بود. ");
INSERT INTO pesopcb_vpl VALUES ("DT9_12","006_9_12","DEU","9","12","12","سپس خداوند به من گفت: «بلند شو! بی‌درنگ به پایین کوه برو، زیرا قوم تو که ایشان را از مصر بیرون آوردی، خود را به فساد کشیده‌اند. آنها خیلی زود از احکام من روی گردان شده، برای خود بُتی از طلای ریخته شده ساخته‌اند.» ");
INSERT INTO pesopcb_vpl VALUES ("DT9_13‏","006_9_13‏","DEU","9","13‏","14","خداوند به من گفت: «مرا واگذار تا این قوم سرکش را نابود کنم و نامشان را از زیر آسمان محو ساخته، قوم دیگری از تو به وجود آورم، قومی که بزرگتر و قویتر از ایشان باشد.» ");
INSERT INTO pesopcb_vpl VALUES ("DT9_15","006_9_15","DEU","9","15","15","من در حالی که دو لوح عهد خداوند را در دست داشتم از کوه که شعله‌های آتش آن را فرا گرفته بود، پایین آمدم. ");
INSERT INTO pesopcb_vpl VALUES ("DT9_16","006_9_16","DEU","9","16","16","در آنجا دیدم چگونه شما به یهوه خدای خود گناه ورزیده، بت گوساله شکلی از طلای ریخته شده برای خود ساخته بودید. چه زود از فرمان خداوند سرپیچی کرده، نسبت به او گناه ورزیدید! ");
INSERT INTO pesopcb_vpl VALUES ("DT9_17","006_9_17","DEU","9","17","17","من لوحها را به زمین انداختم و در برابر چشمانتان آنها را خرد کردم. ");
INSERT INTO pesopcb_vpl VALUES ("DT9_18","006_9_18","DEU","9","18","18","آنگاه به مدت چهل شبانه روز دیگر، در حضور خداوند رو بر زمین نهادم. نه نانی خوردم و نه آبی نوشیدم، زیرا شما گناه بزرگی مرتکب شده بودید و آنچه خداوند از آن بیزار است انجام داده، او را به خشم آورده بودید. ");
INSERT INTO pesopcb_vpl VALUES ("DT9_19","006_9_19","DEU","9","19","19","می‌ترسیدم از شدت خشم، شما را نابود کند. ولی یک بار دیگر خداوند خواهش مرا اجابت کرد. ");
INSERT INTO pesopcb_vpl VALUES ("DT9_20","006_9_20","DEU","9","20","20","هارون نیز در خطر بزرگی بود چون خداوند بر او غضبناک شده، می‌خواست او را بکشد، ولی من دعا کردم و خداوند او را بخشید. ");
INSERT INTO pesopcb_vpl VALUES ("DT9_21","006_9_21","DEU","9","21","21","من آن گوساله را که شما از طلا ساخته بودید و مظهر گناه شما بود برداشته، در آتش انداختم، بعد آن را کوبیدم و به صورت غباری نرم درآورده، به داخل نهری که از دل کوه جاری بود ریختم. ");
INSERT INTO pesopcb_vpl VALUES ("DT9_22","006_9_22","DEU","9","22","22","شما در تَبعیره و مَسّا و قبروت هتاوه نیز خشم خداوند را برافروختید. ");
INSERT INTO pesopcb_vpl VALUES ("DT9_23","006_9_23","DEU","9","23","23","در قادش برنیع خداوند به شما گفت: «به سرزمینی که به شما داده‌ام داخل شوید.» اما شما از یهوه خدایتان اطاعت ننمودید زیرا باور نکردید که او به شما کمک خواهد کرد. ");
INSERT INTO pesopcb_vpl VALUES ("DT9_24","006_9_24","DEU","9","24","24","آری، از اولین روزی که شما را شناختم، علیه خداوند یاغیگری کرده‌اید. ");
INSERT INTO pesopcb_vpl VALUES ("DT9_25","006_9_25","DEU","9","25","25","پس خداوند خواست شما را هلاک کند، ولی من چهل شبانه روز در برابر او به خاک افتادم ");
INSERT INTO pesopcb_vpl VALUES ("DT9_26","006_9_26","DEU","9","26","26","و التماس کرده، گفتم: «ای خداوند، قوم خود را نابود نکن. آنها میراث تو هستند که با قدرت عظیمت از مصر نجات یافتند. ");
INSERT INTO pesopcb_vpl VALUES ("DT9_27","006_9_27","DEU","9","27","27","خدمتگزارانت ابراهیم و اسحاق و یعقوب را به یاد آور و از سرسختی و عصیان و گناه این قوم چشم‌پوشی کن. ");
INSERT INTO pesopcb_vpl VALUES ("DT9_28","006_9_28","DEU","9","28","28","زیرا اگر آنها را از بین ببری مصری‌ها خواهند گفت که خداوند قادر نبود آنها را به سرزمینی که به ایشان وعده داده بود برساند. آنها خواهند گفت که خداوند ایشان را نابود کرد، چون از ایشان بیزار بود و آنها را به بیابان برد تا آنها را بکشد. ");
INSERT INTO pesopcb_vpl VALUES ("DT9_29","006_9_29","DEU","9","29","29","ای خداوند، آنها قوم تو و میراث تو هستند که آنها را با قدرت عظیم و دست توانای خود از مصر بیرون آوردی.» ");
INSERT INTO pesopcb_vpl VALUES ("DT10_1","006_10_1","DEU","10","1","1","در آن هنگام خداوند به من فرمود: «دو لوح سنگی دیگر مانند لوحهای قبلی بتراش و یک صندوق چوبی برای نگهداری آنها بساز و لوحها را همراه خود نزد من به کوه بیاور. ");
INSERT INTO pesopcb_vpl VALUES ("DT10_2","006_10_2","DEU","10","2","2","من روی آن لوحها همان فرامینی را که روی لوحهای اولی بود و تو آنها را شکستی، دوباره خواهم نوشت. آنگاه آنها را در صندوق بگذار.» ");
INSERT INTO pesopcb_vpl VALUES ("DT10_3","006_10_3","DEU","10","3","3","بنابراین من یک صندوق از چوب اقاقیا ساخته، دو لوح سنگی مانند لوحهای اول تراشیدم و لوحها را برداشته، از کوه بالا رفتم. ");
INSERT INTO pesopcb_vpl VALUES ("DT10_4","006_10_4","DEU","10","4","4","خداوند دوباره ده فرمان را روی آنها نوشت و آنها را به من داد. (آنها همان فرمانهایی بودند که وقتی همگی شما در پایین کوه جمع شده بودید، از درون آتش روی کوه به شما داده بود.) ");
INSERT INTO pesopcb_vpl VALUES ("DT10_5","006_10_5","DEU","10","5","5","آنگاه از کوه پایین آمدم و طبق فرمان خداوند لوحها را در صندوقی که ساخته بودم گذاشتم. آن لوحها تا امروز هم در آنجا قرار دارند. ");
INSERT INTO pesopcb_vpl VALUES ("DT10_6","006_10_6","DEU","10","6","6","سپس قوم اسرائیل از بئیروت بنی‌یعقان به موسیره کوچ کردند. در آنجا هارون درگذشت و به خاک سپرده شد و پسرش العازار به جای او به خدمت کاهنی پرداخت. ");
INSERT INTO pesopcb_vpl VALUES ("DT10_7","006_10_7","DEU","10","7","7","آنگاه به جُدجوده و از آنجا به یُطبات که نهرهای فراوانی داشت، سفر کردند. ");
INSERT INTO pesopcb_vpl VALUES ("DT10_8","006_10_8","DEU","10","8","8","در آنجا بود که خداوند قبیلهٔ لاوی را برای حمل صندوقی که در آن ده فرمان خداوند قرار داشت انتخاب نمود تا در حضور او بایستند و او را خدمت کنند و به نام او برکت دهند، به طوری که تا امروز هم این کار را انجام می‌دهند. ");
INSERT INTO pesopcb_vpl VALUES ("DT10_9","006_10_9","DEU","10","9","9","(به همین دلیل است که برای قبیلهٔ لاوی مثل قبایل دیگر سهمی در سرزمین موعود در نظر گرفته نشده است، زیرا یهوه خدایتان به ایشان فرموده بود که او خود میراث ایشان است.) ");
INSERT INTO pesopcb_vpl VALUES ("DT10_10","006_10_10","DEU","10","10","10","چنانکه قبلاً هم گفتم برای دومین بار چهل شبانه روز در حضور خداوند در بالای کوه ماندم و خداوند بار دیگر التماس‌های مرا اجابت فرمود و از نابود کردن شما چشم پوشید. ");
INSERT INTO pesopcb_vpl VALUES ("DT10_11","006_10_11","DEU","10","11","11","او به من فرمود: «برخیز و بنی‌اسرائیل را به سرزمینی که به پدرانشان وعده داده‌ام هدایت کن تا به آنجا داخل شده، آن را تصاحب کنند.» ");
INSERT INTO pesopcb_vpl VALUES ("DT10_12","006_10_12","DEU","10","12","12","اکنون ای قوم اسرائیل، یهوه خدایتان از شما چه می‌خواهد، جز اینکه از یهوه خدایتان بترسید و در همه راههایش گام بردارید و او را دوست داشته، با تمامی دل و جان او را عبادت کنید، ");
INSERT INTO pesopcb_vpl VALUES ("DT10_13","006_10_13","DEU","10","13","13","و برای خیر و آسایش خود، فرمانها و فرایض خداوند را که من امروز به شما می‌دهم اطاعت کنید. ");
INSERT INTO pesopcb_vpl VALUES ("DT10_14","006_10_14","DEU","10","14","14","اینک بلندترین آسمانها و زمین و هرآنچه در آن است از آنِ یهوه، خدای شماست. ");
INSERT INTO pesopcb_vpl VALUES ("DT10_15","006_10_15","DEU","10","15","15","با وجود این، او آنقدر به پدرانتان علاقمند بود و به حدی ایشان را دوست می‌داشت که شما را که فرزندان آنها هستید انتخاب نمود تا بالاتر از هر قوم دیگری باشید، همچنانکه امروز آشکار است. ");
INSERT INTO pesopcb_vpl VALUES ("DT10_16","006_10_16","DEU","10","16","16","پس دلهای خود را ختنه کنید و دست از سرکشی بردارید. ");
INSERT INTO pesopcb_vpl VALUES ("DT10_17","006_10_17","DEU","10","17","17","خداوند، خدایتان، خدای خدایان و رب الارباب است. او خدایی بزرگ و تواناست، خدای مهیبی که از هیچ‌کس جانبداری نمی‌کند و رشوه نمی‌گیرد. ");
INSERT INTO pesopcb_vpl VALUES ("DT10_18","006_10_18","DEU","10","18","18","به داد بیوه‌زنان و یتیمان می‌رسد. غریبان را دوست می‌دارد و به آنها غذا و لباس می‌دهد. ");
INSERT INTO pesopcb_vpl VALUES ("DT10_19","006_10_19","DEU","10","19","19","پس شما هم باید غریبان را دوست بدارید، زیرا خودتان هم در سرزمین مصر غریب بودید. ");
INSERT INTO pesopcb_vpl VALUES ("DT10_20","006_10_20","DEU","10","20","20","باید از خداوند، خدایتان بترسید و او را پرستش کنید و از او جدا نشوید و فقط به نام او سوگند یاد کنید. ");
INSERT INTO pesopcb_vpl VALUES ("DT10_21","006_10_21","DEU","10","21","21","تنها او خدای شماست و تنها اوست که شایسته پرستش است، خدایی که معجزات عظیمی برای شما انجام داد و خود شاهد آنها بوده‌اید. ");
INSERT INTO pesopcb_vpl VALUES ("DT10_22","006_10_22","DEU","10","22","22","وقتی که اجداد شما به مصر رفتند فقط هفتاد نفر بودند، ولی اکنون خداوند، خدایتان شما را به اندازهٔ ستارگان آسمان افزایش داده است! ");
INSERT INTO pesopcb_vpl VALUES ("DT11_1","006_11_1","DEU","11","1","1","یهوه، خدایتان را دوست بدارید و خواسته‌ها و فرایض و قوانین و فرامین او را همیشه به‌جا آورید. ");
INSERT INTO pesopcb_vpl VALUES ("DT11_2","006_11_2","DEU","11","2","2","گوش کنید! من با فرزندان شما سخن نمی‌گویم که مزهٔ تنبیه یهوه خدایتان را نچشیده و بزرگی و قدرت مهیبش را ندیده‌اند. ");
INSERT INTO pesopcb_vpl VALUES ("DT11_3","006_11_3","DEU","11","3","3","ایشان آنجا نبودند تا معجزاتی را که او در مصر علیه فرعون و تمامی سرزمینش انجام داد ببینند. ");
INSERT INTO pesopcb_vpl VALUES ("DT11_4","006_11_4","DEU","11","4","4","آنها ندیده‌اند که خداوند با لشکر مصر و با اسبان و ارابه‌های ایشان چه کرد و چگونه کسانی را که در تعقیب شما بودند در دریای سرخ غرق نموده، هلاک کرد. ");
INSERT INTO pesopcb_vpl VALUES ("DT11_5","006_11_5","DEU","11","5","5","آنها ندیده‌اند در طول سالهایی که شما در بیابان سرگردان بودید، چگونه خداوند بارها از شما مراقبت کرده است تا شما را به اینجا برساند. ");
INSERT INTO pesopcb_vpl VALUES ("DT11_6","006_11_6","DEU","11","6","6","آنها آنجا نبودند وقتی که داتان و ابیرام، پسران الیاب، از نسل رئوبین، مرتکب گناه شدند و زمین دهان باز کرده، جلوی چشم تمامی قوم اسرائیل آنها را با خانواده و خیمه و اموالشان بلعید. ");
INSERT INTO pesopcb_vpl VALUES ("DT11_7","006_11_7","DEU","11","7","7","ولی شما با چشمانتان این معجزات عظیم خداوند را دیده‌اید. ");
INSERT INTO pesopcb_vpl VALUES ("DT11_8","006_11_8","DEU","11","8","8","پس این فرمانهایی را که امروز به شما می‌دهم با دقت اطاعت کنید تا توانایی آن را داشته باشید که سرزمینی را که به‌زودی وارد آن می‌شوید تصرف کنید. ");
INSERT INTO pesopcb_vpl VALUES ("DT11_9","006_11_9","DEU","11","9","9","اگر از این اوامر اطاعت کنید در سرزمینی که خداوند با سوگند به پدرانتان و به شما که فرزندان ایشان هستید وعده داد، عمر طولانی و خوبی خواهید داشت، در سرزمینی که شیر و عسل در آن جاری است. ");
INSERT INTO pesopcb_vpl VALUES ("DT11_10","006_11_10","DEU","11","10","10","چون سرزمینی که به‌زودی وارد آن می‌شوید و آن را تصاحب می‌کنید مثل سرزمین مصر که از آنجا آمده‌اید نیست و احتیاجی به آبیاری ندارد. ");
INSERT INTO pesopcb_vpl VALUES ("DT11_11","006_11_11","DEU","11","11","11","سرزمینی که شما برای تصرفش به آن عبور می‌کنید، سرزمین کوهها و دشتهاست که باران فراوان بر آن می‌بارد، ");
INSERT INTO pesopcb_vpl VALUES ("DT11_12","006_11_12","DEU","11","12","12","و سرزمینی است که یهوه، خدایتان خود از آن مراقبت می‌کند و چشمان او دائم در تمامی سال بر آن دوخته شده است. ");
INSERT INTO pesopcb_vpl VALUES ("DT11_13","006_11_13","DEU","11","13","13","اگر شما تمام فرامین او را که من امروز به شما می‌دهم با دقت اطاعت کنید و اگر یهوه خدایتان را با تمامی دل و جان دوست داشته باشید و او را عبادت کنید ");
INSERT INTO pesopcb_vpl VALUES ("DT11_14","006_11_14","DEU","11","14","14","آنگاه او باز هم باران را به موقع خواهد فرستاد تا غله، شراب تازه و روغن زیتون فراوان داشته باشید. ");
INSERT INTO pesopcb_vpl VALUES ("DT11_15","006_11_15","DEU","11","15","15","او به شما مراتع سرسبز برای چریدن گله‌هایتان خواهد داد و خود نیز غذای کافی خواهید داشت که بخورید و سیر شوید. ");
INSERT INTO pesopcb_vpl VALUES ("DT11_16","006_11_16","DEU","11","16","16","ولی هوشیار باشید که دلهایتان از خداوند برنگردد تا خدایان دیگر را بپرستید، ");
INSERT INTO pesopcb_vpl VALUES ("DT11_17","006_11_17","DEU","11","17","17","چون اگر چنین کنید خشم خداوند نسبت به شما افروخته شده، آسمانها را خواهد بست و دیگر باران نخواهد بارید و شما محصولی نخواهید داشت، و به‌زودی در سرزمین حاصلخیزی که خداوند به شما داده است نابود خواهید شد. ");
INSERT INTO pesopcb_vpl VALUES ("DT11_18","006_11_18","DEU","11","18","18","بنابراین، این فرمانها را در دل و جان خود جای دهید. آنها را به دستهای خود و همچنین به پیشانی‌تان ببندید تا همیشه به خاطر داشته باشید که باید آنها را اطاعت کنید. ");
INSERT INTO pesopcb_vpl VALUES ("DT11_19","006_11_19","DEU","11","19","19","آنها را به فرزندان خود بیاموزید و همیشه دربارهٔ آنها صحبت کنید، خواه در خانه باشید خواه در بیرون، خواه هنگام خواب باشد خواه اول صبح. ");
INSERT INTO pesopcb_vpl VALUES ("DT11_20","006_11_20","DEU","11","20","20","آنها را بر چارچوبِ درِ خانۀ خود و بر دروازه‌هایتان بنویسید. ");
INSERT INTO pesopcb_vpl VALUES ("DT11_21","006_11_21","DEU","11","21","21","آنگاه تا زمین و آسمان باقی است شما و فرزندانتان در سرزمینی که خداوند با سوگند به پدرانتان وعده داد زندگی خواهید کرد. ");
INSERT INTO pesopcb_vpl VALUES ("DT11_22","006_11_22","DEU","11","22","22","اگر با دقت همهٔ دستورهایی را که به شما می‌دهم اطاعت کرده، خداوند، خدایتان را دوست بدارید و آنچه را که او می‌خواهد انجام داده، از او جدا نشوید ");
INSERT INTO pesopcb_vpl VALUES ("DT11_23","006_11_23","DEU","11","23","23","آنگاه خداوند همهٔ قومهایی را که با شما مقاومت می‌کنند، هر قدر هم از شما بزرگتر و قویتر باشند، بیرون خواهد کرد و شما زمینهایشان را تسخیر خواهید نمود. ");
INSERT INTO pesopcb_vpl VALUES ("DT11_24","006_11_24","DEU","11","24","24","هر جا که قدم بگذارید به شما تعلق خواهد داشت. مرزهایتان از بیابان نِگِب در جنوب تا لبنان در شمال، و از رود فرات در مشرق تا دریای مدیترانه در مغرب خواهد بود. ");
INSERT INTO pesopcb_vpl VALUES ("DT11_25","006_11_25","DEU","11","25","25","هیچ‌کس یارای مقاومت با شما را نخواهد داشت، چون خداوند، خدایتان همان‌طور که قول داده است هر جا که بروید ترس شما را در دل مردمی که با آنها روبرو می‌شوید، خواهد گذاشت. ");
INSERT INTO pesopcb_vpl VALUES ("DT11_26","006_11_26","DEU","11","26","26","من امروز به شما حق انتخاب می‌دهم تا بین برکت و لعنت یکی را انتخاب کنید. ");
INSERT INTO pesopcb_vpl VALUES ("DT11_27","006_11_27","DEU","11","27","27","اگر فرامین یهوه خدایتان را که امروز به شما می‌دهم اطاعت کنید برکت خواهید یافت ");
INSERT INTO pesopcb_vpl VALUES ("DT11_28","006_11_28","DEU","11","28","28","و اگر از آنها سرپیچی کرده، خدایان قومهای دیگر را پرستش کنید، مورد لعنت قرار خواهید گرفت. ");
INSERT INTO pesopcb_vpl VALUES ("DT11_29","006_11_29","DEU","11","29","29","وقتی که خداوند، خدایتان شما را وارد سرزمینی می‌کند که باید آن را تصرف کنید، از کوه جَرِزیم برکت و از کوه عیبال، لعنت اعلام خواهد شد. ");
INSERT INTO pesopcb_vpl VALUES ("DT11_30","006_11_30","DEU","11","30","30","(جَرِزیم و عیبال کوههایی هستند در غرب رود اردن، یعنی در سرزمین کنعانی‌هایی که در آنجا در اراضی بیابانی نزدیک جلجال زندگی می‌کنند، بلوطستان موره هم در آنجا قرار دارد.) ");
INSERT INTO pesopcb_vpl VALUES ("DT11_31","006_11_31","DEU","11","31","31","شما به‌زودی از رود اردن عبور کرده، در سرزمینی که یهوه خدایتان به شما می‌دهد ساکن خواهید شد. ");
INSERT INTO pesopcb_vpl VALUES ("DT11_32","006_11_32","DEU","11","32","32","فراموش نکنید که در آنجا باید همهٔ فرایض و قوانینی را که امروز به شما می‌دهم اطاعت کنید. ");
INSERT INTO pesopcb_vpl VALUES ("DT12_1","006_12_1","DEU","12","1","1","وقتی به سرزمینی می‌رسید که خداوند، خدای پدرانتان آن را به شما داده است، باید این فرایض و قوانین را تا وقتی که در آن سرزمین زندگی می‌کنید، اطاعت نمایید. ");
INSERT INTO pesopcb_vpl VALUES ("DT12_2","006_12_2","DEU","12","2","2","در هر جا که بتخانه‌ای می‌بینید، چه در بالای کوهها و تپه‌ها، و چه در زیر هر درخت سبز، باید آن را نابود کنید. ");
INSERT INTO pesopcb_vpl VALUES ("DT12_3","006_12_3","DEU","12","3","3","مذبحهای بت‌پرستان را بشکنید، ستونهایی را که می‌پرستند خرد کنید، مجسمه‌های شرم‌آورشان را بسوزانید و بتهای آنها را قطعه‌قطعه کنید و چیزی باقی نگذارید که شما را به یاد آنها بیندازد. ");
INSERT INTO pesopcb_vpl VALUES ("DT12_4‏","006_12_4‏","DEU","12","4‏","5","مانند بت‌پرستان در هر جا برای خداوند، خدایتان قربانی نکنید، بلکه در محلی که خودش در میان قبیله‌های اسرائیل به عنوان عبادتگاه خود انتخاب می‌کند، او را عبادت نمایید. ");
INSERT INTO pesopcb_vpl VALUES ("DT12_6","006_12_6","DEU","12","6","6","قربانیهای سوختنی و سایر قربانیها، یک دهم دارایی‌تان، هدایای مخصوص، هدایای نذری، هدایای داوطلبانه، و نخست‌زاده‌های گله‌ها و رمه‌هایتان را به آنجا بیاورید. ");
INSERT INTO pesopcb_vpl VALUES ("DT12_7","006_12_7","DEU","12","7","7","در آنجا شما و خانواده‌هایتان در حضور خداوند، خدایتان خواهید خورد و از دسترنج خود لذت خواهید برد، زیرا او شما را برکت داده است. ");
INSERT INTO pesopcb_vpl VALUES ("DT12_8‏","006_12_8‏","DEU","12","8‏","9","وقتی به سرزمینی که در آنجا خداوند، خدایتان به شما صلح و آرامش می‌بخشد رسیدید، دیگر نباید مثل امروز هر جا که خواستید او را عبادت کنید. ");
INSERT INTO pesopcb_vpl VALUES ("DT12_10","006_12_10","DEU","12","10","10","زمانی که از رود اردن بگذرید و در آن سرزمین اقامت کنید و یهوه خدایتان به شما آرامش ببخشد و شما را از دست دشمنانتان حفظ کند، ");
INSERT INTO pesopcb_vpl VALUES ("DT12_11","006_12_11","DEU","12","11","11","آنگاه باید تمام قربانیها و هدایای خود را که به شما امر کرده‌ام به عبادتگاه یهوه خدایتان در محلی که خود انتخاب خواهد کرد بیاورید: قربانیهای سوختنی و دیگر قربانیها، ده‌یک‌ها، هدایای مخصوص و همۀ بهترین هدایای نذری خود را که برای خداوند نذر کرده‌اید. ");
INSERT INTO pesopcb_vpl VALUES ("DT12_12","006_12_12","DEU","12","12","12","در آنجا با پسران و دختران، غلامان و کنیزان خود، در حضور یهوه خدایتان شادی کنید. به خاطر داشته باشید که لاویان شهرتان را به جشن و شادی خود دعوت کنید، چون ایشان زمینی از خود ندارند. ");
INSERT INTO pesopcb_vpl VALUES ("DT12_13","006_12_13","DEU","12","13","13","قربانیهای سوختنی خود را نباید در هر جایی که رسیدید قربانی کنید. ");
INSERT INTO pesopcb_vpl VALUES ("DT12_14","006_12_14","DEU","12","14","14","آنها را فقط در جایی می‌توانید قربانی کنید که خداوند در میان یکی از قبیله‌های شما انتخاب کرده باشد. در آنجا هر آنچه من به شما فرمان می‌دهم به جا آورید. ");
INSERT INTO pesopcb_vpl VALUES ("DT12_15","006_12_15","DEU","12","15","15","ولی حیواناتی را که گوشتشان را می‌خورید می‌توانید در هر جا سر ببرید همان‌طور که غزال و آهو را سر می‌برید. از این گوشت هر قدر میل دارید و هر وقت که یهوه خدایتان به شما بدهد، بخورید. کسانی که نجس باشند نیز می‌توانند آن را بخورند. ");
INSERT INTO pesopcb_vpl VALUES ("DT12_16","006_12_16","DEU","12","16","16","تنها چیزی که نباید بخورید خون آن است که باید آن را مثل آب بر زمین بریزید. ");
INSERT INTO pesopcb_vpl VALUES ("DT12_17","006_12_17","DEU","12","17","17","ولی هیچ‌کدام از هدایا را نباید در خانه بخورید، نه ده‌یک غله و شراب تازه و روغن زیتون‌تان و نه نخست‌زادهٔ گله‌ها و رمه‌هایتان و نه چیزی که برای خداوند نذر کرده‌اید و نه هدایای داوطلبانه و نه هدایای مخصوصتان. ");
INSERT INTO pesopcb_vpl VALUES ("DT12_18","006_12_18","DEU","12","18","18","همهٔ اینها را باید به مذبح بیاورید و همراه فرزندان خود و لاویانی که در شهر شما هستند، در آنجا در حضور خداوند، خدایتان آن خوراکی‌ها را بخورید. او به شما خواهد گفت که این مذبح در کجا باید ساخته شود. در هر کاری که می‌کنید در حضور خداوند، خدایتان شادی کنید. ");
INSERT INTO pesopcb_vpl VALUES ("DT12_19","006_12_19","DEU","12","19","19","مواظب باشید تا وقتی که در زمینِ خود زندگی می‌کنید، لاویان را فراموش نکنید. ");
INSERT INTO pesopcb_vpl VALUES ("DT12_20‏","006_12_20‏","DEU","12","20‏","23","هنگامی که خداوند، خدایتان طبق وعدهٔ خود مرزهایتان را توسعه دهد اگر مذبح از شما دور باشد آنگاه می‌توانید گله‌ها و رمه‌هایتان را که خداوند به شما می‌بخشد، در هر وقت و در هر جا که خواستید سر ببرید و بخورید، همان‌طور که غزال و آهویتان را سر می‌برید و می‌خورید. حتی اشخاصی که نجس هستند می‌توانند آنها را بخورند. اما مواظب باشید گوشت را با خونش که بدان حیات می‌بخشد، نخورید، ");
INSERT INTO pesopcb_vpl VALUES ("DT12_24‏","006_12_24‏","DEU","12","24‏","25","بلکه خون را مثل آب بر زمین بریزید. اگر چنین کنید، خداوند از شما راضی خواهد شد و زندگی شما و فرزندانتان به خیر خواهد بود. ");
INSERT INTO pesopcb_vpl VALUES ("DT12_26‏","006_12_26‏","DEU","12","26‏","27","آنچه را که به خداوند وقف می‌کنید، و هدایایی را که نذر کرده‌اید و قربانیهای سوختنی خود را به مذبح ببرید. اینها را باید فقط بر مذبح خداوند، خدایتان قربانی کنید. خون را باید روی مذبح ریخته، گوشت آن را بخورید. ");
INSERT INTO pesopcb_vpl VALUES ("DT12_28","006_12_28","DEU","12","28","28","مواظب باشید آنچه را که به شما امر می‌کنم، اطاعت کنید. اگر آنچه در نظر خداوند، خدایتان پسندیده است انجام دهید، همه چیز برای شما و فرزندانتان تا به ابد به خیر خواهد بود. ");
INSERT INTO pesopcb_vpl VALUES ("DT12_29","006_12_29","DEU","12","29","29","وقتی یهوه خدای شما، قومهای سرزمینی را که در آن زندگی خواهید کرد نابود کند، ");
INSERT INTO pesopcb_vpl VALUES ("DT12_30","006_12_30","DEU","12","30","30","در پرستیدن خدایانشان از ایشان پیروی نکنید و گرنه در دام مهلکی گرفتار خواهید شد. نپرسید که این قومها چگونه خدایانشان را می‌پرستند و بعد رفته مثل آنها پرستش کنید. ");
INSERT INTO pesopcb_vpl VALUES ("DT12_31","006_12_31","DEU","12","31","31","هرگز نباید چنین اهانتی به خداوند، خدایتان بکنید. این قومها کارهای ناپسندی را که خداوند از آنها نفرت دارد، برای خدایانشان بجا می‌آورند. آنها حتی پسران و دخترانشان را برای خدایانشان می‌سوزانند. ");
INSERT INTO pesopcb_vpl VALUES ("DT12_32","006_12_32","DEU","12","32","32","تمام فرمانهایی را که به شما می‌دهم اطاعت کنید. چیزی به آنها نیافزایید و چیزی هم از آنها کم نکنید. ");
INSERT INTO pesopcb_vpl VALUES ("DT13_1","006_13_1","DEU","13","1","1","اگر در میان شما پیشگو یا تعبیرکنندهٔ خواب وجود دارد که آینده را پیشگویی می‌کند ");
INSERT INTO pesopcb_vpl VALUES ("DT13_2","006_13_2","DEU","13","2","2","و پیشگویی‌هایش نیز درست از آب در می‌آیند، ولی می‌گوید: «بیایید تا خدایان قومهای دیگر را که شما نمی‌شناسید، بپرستیم» ");
INSERT INTO pesopcb_vpl VALUES ("DT13_3","006_13_3","DEU","13","3","3","به حرف او گوش نکنید؛ چون یهوه خدایتان بدین ترتیب شما را امتحان می‌کند تا معلوم شود آیا براستی او را با تمامی دل و جانتان دوست دارید یا نه. ");
INSERT INTO pesopcb_vpl VALUES ("DT13_4","006_13_4","DEU","13","4","4","فقط از خداوند، خدایتان پیروی کنید و او را احترام نمایید و اوامرش را به جا آورید، او را پرستش کنید و از او جدا مشوید. ");
INSERT INTO pesopcb_vpl VALUES ("DT13_5","006_13_5","DEU","13","5","5","آن پیشگو یا تعبیر کنندهٔ خواب را که سعی می‌کند شما را گمراه سازد، بکشید، چون قصد داشته شما را بر ضد خداوند، خدایتان که شما را از بردگی در مصر بیرون آورد، برانگیزد. با کشتن او شرارت را از میان خود پاک خواهید کرد. ");
INSERT INTO pesopcb_vpl VALUES ("DT13_6","006_13_6","DEU","13","6","6","اگر نزدیکترین خویشاوند یا صمیمی‌ترین دوست شما، حتی برادر، پسر، دختر و یا همسرتان در گوش شما نجوا کند که «بیا برویم و این خدایان بیگانه را بپرستیم»، خدایانی که نه شما آنها را می‌شناسید و نه اجدادتان، ");
INSERT INTO pesopcb_vpl VALUES ("DT13_7","006_13_7","DEU","13","7","7","خدایان قومهایی که اطراف سرزمین شما هستند، خواه نزدیک به شما خواه دور، ");
INSERT INTO pesopcb_vpl VALUES ("DT13_8","006_13_8","DEU","13","8","8","به او گوش ندهید. پیشنهاد ناپسندش را برملا سازید و بر او رحم نکنید. ");
INSERT INTO pesopcb_vpl VALUES ("DT13_9","006_13_9","DEU","13","9","9","او را بکشید. دست خودتان باید اولین دستی باشد که او را سنگسار می‌کند و بعد دستهای تمامی قوم اسرائیل. ");
INSERT INTO pesopcb_vpl VALUES ("DT13_10","006_13_10","DEU","13","10","10","او را سنگسار کنید تا بمیرد، چون قصد داشته است شما را از خداوند، خدایتان که شما را از مصر یعنی سرزمین بردگی بیرون آورد دور کند. ");
INSERT INTO pesopcb_vpl VALUES ("DT13_11","006_13_11","DEU","13","11","11","آنگاه تمام بنی‌اسرائیل از کردار شرورانه‌اش آگاه شده، از ارتکاب چنین شرارتی در میان قوم خواهند ترسید. ");
INSERT INTO pesopcb_vpl VALUES ("DT13_12‏","006_13_12‏","DEU","13","12‏","14","هرگاه بشنوید در یکی از شهرهای اسرائیل می‌گویند که گروهی اوباش با پیشنهاد پرستیدن خدایان بیگانه همشهریان خود را گمراه کرده‌اند، اول حقایق را بررسی کنید و ببینید آیا آن شایعه حقیقت دارد یا نه. اگر دیدید حقیقت دارد و چنین عمل زشتی در میان شما در یکی از شهرهایی که یهوه خدایتان به شما داده است اتفاق افتاده، ");
INSERT INTO pesopcb_vpl VALUES ("DT13_15","006_13_15","DEU","13","15","15","باید بی‌درنگ شهر و کلیهٔ ساکنانش را نابود کنید و گله‌هایشان را نیز از بین ببرید. ");
INSERT INTO pesopcb_vpl VALUES ("DT13_16","006_13_16","DEU","13","16","16","سپس باید تمام غنایم را در میدان شهر انباشته، بسوزانید. پس از آن، تمام شهر را به عنوان قربانی سوختنی برای خداوند، خدایتان به آتش بکشید. آن شهر برای همیشه باید ویرانه بماند و نباید هرگز دوباره آباد گردد. ");
INSERT INTO pesopcb_vpl VALUES ("DT13_17","006_13_17","DEU","13","17","17","ذره‌ای از این غنایم حرام را نگاه ندارید. آنگاه خداوند از غضب خود برمی‌گردد و شما را مورد لطف و مرحمت خویش قرار داده، همچنانکه با سوگند به پدرانتان وعده فرمود، تعداد شما را زیاد خواهد کرد، ");
INSERT INTO pesopcb_vpl VALUES ("DT13_18","006_13_18","DEU","13","18","18","به شرطی که فقط از یهوه خدایتان و فرمانهای او که امروز به شما می‌دهم اطاعت نموده، آنچه را که در نظر یهوه خدایتان پسندیده است بجا آورید. ");
INSERT INTO pesopcb_vpl VALUES ("DT14_1","006_14_1","DEU","14","1","1","شما فرزندان یهوه خدای خود هستید، پس هنگام عزاداری برای مردگان خود، مثل بت‌پرستان، خود را زخمی نکنید و موی جلوی سرتان را نتراشید، ");
INSERT INTO pesopcb_vpl VALUES ("DT14_2","006_14_2","DEU","14","2","2","زیرا شما برای یهوه خدایتان قومی مقدّسید، و او شما را از میان قومهای روی زمین برگزیده است تا قوم خاص او باشید. ");
INSERT INTO pesopcb_vpl VALUES ("DT14_3‏","006_14_3‏","DEU","14","3‏","5","گوشت هیچ حیوانی را که من آن را حرام اعلام کرده‌ام نباید بخورید. حیواناتی که می‌توانید گوشت آنها را بخورید از این قرارند: گاو، گوسفند، بز، آهو، غزال، گوزن و انواع بز کوهی. ");
INSERT INTO pesopcb_vpl VALUES ("DT14_6","006_14_6","DEU","14","6","6","هر حیوانی را که سم شکافته دارد و نشخوار می‌کند می‌توانید بخورید. ");
INSERT INTO pesopcb_vpl VALUES ("DT14_7","006_14_7","DEU","14","7","7","پس اگر حیوانی این دو خصوصیت را نداشته باشد، نباید آن را بخورید. بنابراین شتر، خرگوش و گورکن را نباید بخورید. اینها نشخوار می‌کنند، ولی سمهای شکافته ندارند. ");
INSERT INTO pesopcb_vpl VALUES ("DT14_8","006_14_8","DEU","14","8","8","خوک را نباید بخورید، چون با اینکه سم شکافته دارد نشخوار نمی‌کند. حتی به لاشهٔ چنین حیواناتی نباید دست بزنید. ");
INSERT INTO pesopcb_vpl VALUES ("DT14_9","006_14_9","DEU","14","9","9","از حیواناتی که در آب زندگی می‌کنند فقط آنهایی را که باله و فلس دارند می‌توانید بخورید. ");
INSERT INTO pesopcb_vpl VALUES ("DT14_10","006_14_10","DEU","14","10","10","تمام جانوران آبزی دیگر برای شما حرامند. ");
INSERT INTO pesopcb_vpl VALUES ("DT14_11","006_14_11","DEU","14","11","11","همۀ پرندگان طاهر را می‌توانید بخورید. ");
INSERT INTO pesopcb_vpl VALUES ("DT14_12","006_14_12","DEU","14","12","12","اما اینها را نباید بخورید: عقاب، لاشخور و لاشخور سیاه؛ ");
INSERT INTO pesopcb_vpl VALUES ("DT14_13","006_14_13","DEU","14","13","13","زَغَن، شاهین و شاهین به نوعش؛ ");
INSERT INTO pesopcb_vpl VALUES ("DT14_14","006_14_14","DEU","14","14","14","هر قسم کلاغ به نوعش؛ ");
INSERT INTO pesopcb_vpl VALUES ("DT14_15","006_14_15","DEU","14","15","15","شترمرغ، جغد، مرغ نوروزی و باز به نوعش؛ ");
INSERT INTO pesopcb_vpl VALUES ("DT14_16","006_14_16","DEU","14","16","16","بوم، جغد بزرگ، جغد سفید، ");
INSERT INTO pesopcb_vpl VALUES ("DT14_17","006_14_17","DEU","14","17","17","و جغد صحرایی؛ کرکس، مرغ غواص، ");
INSERT INTO pesopcb_vpl VALUES ("DT14_18","006_14_18","DEU","14","18","18","لک‌لک و مرغ ماهیخوار به نوعش؛ هُدهُد و خفاش. ");
INSERT INTO pesopcb_vpl VALUES ("DT14_19","006_14_19","DEU","14","19","19","همۀ حشرات بالدار برای شما حرامند، و نباید خورده شوند. ");
INSERT INTO pesopcb_vpl VALUES ("DT14_20","006_14_20","DEU","14","20","20","اما همۀ پرندگان حلال گوشت را می‌توانید بخورید. ");
INSERT INTO pesopcb_vpl VALUES ("DT14_21","006_14_21","DEU","14","21","21","حیوانی را که به مرگ طبیعی مرده است نخورید. آن را به غریبی که در میان شما باشد بدهید تا بخورد و یا آن را به بیگانگان بفروشید؛ ولی خودتان آن را نخورید، چون برای یهوه خدایتان قومی مقدّس هستید. بزغاله را در شیر مادرش نپزید. ");
INSERT INTO pesopcb_vpl VALUES ("DT14_22","006_14_22","DEU","14","22","22","از تمامی محصولاتتان هر ساله باید یک دهم را کنار بگذارید. ");
INSERT INTO pesopcb_vpl VALUES ("DT14_23","006_14_23","DEU","14","23","23","این ده‌یک را بیاورید تا در محلی که یهوه، خدایتان به عنوان عبادتگاه خود انتخاب خواهد کرد در حضورش بخورید. این شامل عشریه‌های غله، شراب تازه، روغن زیتون و نخست‌زادهٔ گله‌ها و رمه‌هایتان می‌باشد. منظور از این کار این است که بیاموزید همیشه خداوند را در زندگی خود احترام کنید. ");
INSERT INTO pesopcb_vpl VALUES ("DT14_24","006_14_24","DEU","14","24","24","اگر مکانی که خداوند به عنوان عبادتگاه خود انتخاب می‌کند به قدری دور باشد که براحتی نتوانید ده‌یک‌های خود را از برکاتی که یهوه خدایتان به شما داده، به آنجا حمل کنید، ");
INSERT INTO pesopcb_vpl VALUES ("DT14_25","006_14_25","DEU","14","25","25","آنگاه می‌توانید ده‌یک محصولات و رمه‌هایتان را بفروشید و پولش را به مکانی که یهوه خدایتان برمی‌گزیند، ببرید. ");
INSERT INTO pesopcb_vpl VALUES ("DT14_26","006_14_26","DEU","14","26","26","وقتی که به آنجا رسیدید با آن پول هر چه خواستید بخرید گاو، گوسفند، شراب یا مشروبات دیگر تا در آنجا در حضور خداوند، خدایتان جشن گرفته، با خانوادهٔ خود به شادی بپردازید. ");
INSERT INTO pesopcb_vpl VALUES ("DT14_27","006_14_27","DEU","14","27","27","در ضمن لاویان شهرتان را فراموش نکنید، چون آنها مثل شما صاحب ملک و محصول نیستند. ");
INSERT INTO pesopcb_vpl VALUES ("DT14_28","006_14_28","DEU","14","28","28","در آخر هر سه سال باید عشریهٔ تمام محصولات خود را در شهر خود جمع کنید ");
INSERT INTO pesopcb_vpl VALUES ("DT14_29","006_14_29","DEU","14","29","29","تا آن را به لاویان که در میان شما ملکی ندارند، و همچنین غریبان، بیوه‌زنان و یتیمان داخل شهرتان بدهید تا بخورند و سیر شوند. آنگاه خداوند، خدایتان شما را در کارهایتان برکت خواهد داد. ");
INSERT INTO pesopcb_vpl VALUES ("DT15_1","006_15_1","DEU","15","1","1","در پایان هر هفت سال، باید تمام قرضهای بدهکاران خود را ببخشید. ");
INSERT INTO pesopcb_vpl VALUES ("DT15_2","006_15_2","DEU","15","2","2","هر که از همسایه یا برادر یهودی خود طلبی داشته باشد باید آن طلب را لغو نماید. او نباید در صدد پس گرفتن طلبش باشد، زیرا خود خداوند این طلب را لغو نموده است. ");
INSERT INTO pesopcb_vpl VALUES ("DT15_3","006_15_3","DEU","15","3","3","ولی این قانون شامل حال بدهکاران غیریهودی نمی‌شود. ");
INSERT INTO pesopcb_vpl VALUES ("DT15_4‏","006_15_4‏","DEU","15","4‏","5","اگر به دقت، تمام دستورهای خداوند، خدایتان را اطاعت کنید و اوامری را که امروز به شما می‌دهم اجرا نمایید در سرزمینی که خداوند به شما می‌دهد برکت زیادی خواهید یافت، به طوری که فقیری در میان شما نخواهد بود. ");
INSERT INTO pesopcb_vpl VALUES ("DT15_6","006_15_6","DEU","15","6","6","یهوه خدایتان چنانکه وعده داده است برکتتان خواهد داد، به طوری که به قومهای زیادی پول قرض خواهید داد، ولی هرگز احتیاجی به قرض گرفتن نخواهید داشت. بر قومهای بسیاری حکومت خواهید کرد، ولی آنان بر شما حکومت نخواهند نمود. ");
INSERT INTO pesopcb_vpl VALUES ("DT15_7","006_15_7","DEU","15","7","7","وقتی به سرزمینی که یهوه خدایتان به شما می‌دهد وارد شدید، اگر در بین شما اشخاص فقیری باشند نسبت به آنان دست و دل باز باشید، ");
INSERT INTO pesopcb_vpl VALUES ("DT15_8","006_15_8","DEU","15","8","8","و هر قدر احتیاج دارند به ایشان قرض بدهید. ");
INSERT INTO pesopcb_vpl VALUES ("DT15_9","006_15_9","DEU","15","9","9","این فکر پلید را به خود راه ندهید که سال بخشیدن قرض به‌زودی فرا می‌رسد و در نتیجه از دادن قرض خودداری کنید؛ زیرا اگر از دادن قرض خودداری کنید و مرد محتاج پیش خداوند ناله کند این عمل برای شما گناه محسوب خواهد شد. ");
INSERT INTO pesopcb_vpl VALUES ("DT15_10","006_15_10","DEU","15","10","10","باید آنچه نیاز دارد، از صمیم قلب به او بدهید و یهوه خدایتان هم به خاطر این امر، شما را در هر کاری برکت خواهد داد. ");
INSERT INTO pesopcb_vpl VALUES ("DT15_11","006_15_11","DEU","15","11","11","در میان شما همیشه فقیر وجود خواهد داشت به همین دلیل است که به شما فرمان می‌دهم که با گشاده‌دستی به فقیران و برادران نیازمند خود قرض بدهید. ");
INSERT INTO pesopcb_vpl VALUES ("DT15_12","006_15_12","DEU","15","12","12","هرگاه یکی از برادران عبرانیِ شما، خواه مرد و خواه زن، به شما فروخته شود، و شش سال شما را خدمت کند، سال هفتم او را آزاد کرده، بگذارید از نزد شما برود. ");
INSERT INTO pesopcb_vpl VALUES ("DT15_13","006_15_13","DEU","15","13","13","او را دست خالی روانه نکنید، ");
INSERT INTO pesopcb_vpl VALUES ("DT15_14","006_15_14","DEU","15","14","14","بلکه هدیه‌ای از گله و غله و شراب مطابق برکتی که خداوند، خدایتان به شما بخشیده است به وی بدهید. ");
INSERT INTO pesopcb_vpl VALUES ("DT15_15","006_15_15","DEU","15","15","15","به خاطر بیاورید که در سرزمین مصر بَرده بودید و خداوند، خدایتان شما را نجات داد. به همین دلیل است که امروز این فرمان را به شما می‌دهم. ");
INSERT INTO pesopcb_vpl VALUES ("DT15_16","006_15_16","DEU","15","16","16","ولی اگر غلام عبرانی شما نخواهد برود و بگوید شما و خانواده‌تان را دوست دارد و از بودن در خانهٔ شما لذت می‌برد، ");
INSERT INTO pesopcb_vpl VALUES ("DT15_17","006_15_17","DEU","15","17","17","آنگاه او را کنار در خانه قرار دهید و با درفشی گوشش را سوراخ کنید تا از آن پس، همیشه غلام شما باشد. با کنیزان خود نیز چنین کنید. ");
INSERT INTO pesopcb_vpl VALUES ("DT15_18","006_15_18","DEU","15","18","18","اما وقتی که برده‌ای را آزاد می‌کنید نباید ناراحت شوید، زیرا طیِ شش سال به اندازۀ دو برابر دستمزد یک کارگر شما را خدمت کرده است. یهوه خدایتان شما را در هر کاری که بکنید، برکت خواهد داد. ");
INSERT INTO pesopcb_vpl VALUES ("DT15_19","006_15_19","DEU","15","19","19","باید تمامی نخست‌زاده‌های نر گله‌ها و رمه‌هایتان را برای یهوه خدایتان وقف کنید. از نخست‌زاده‌های رمه‌هایتان جهت کار کردن در مزارع خود استفاده نکنید و پشم نخست‌زاده‌های گله‌های گوسفندتان را قیچی نکنید. ");
INSERT INTO pesopcb_vpl VALUES ("DT15_20","006_15_20","DEU","15","20","20","به جای آن، شما و خانواده‌تان هر ساله گوشت این حیوانات را در حضور خداوند، خدایتان در محلی که او تعیین خواهد کرد بخورید. ");
INSERT INTO pesopcb_vpl VALUES ("DT15_21","006_15_21","DEU","15","21","21","ولی اگر حیوان نخست‌زاده معیوب باشد، مثلاً لنگ یا کور بوده، یا عیب دیگری داشته باشد، نباید آن را برای یهوه خدایتان قربانی کنید. ");
INSERT INTO pesopcb_vpl VALUES ("DT15_22","006_15_22","DEU","15","22","22","در عوض از آن برای خوراک خانوادهٔ خود در منزل استفاده کنید. هر کس می‌تواند آن را بخورد، حتی اگر نجس باشد، درست همان‌طور که غزال یا آهو را می‌خورد؛ ");
INSERT INTO pesopcb_vpl VALUES ("DT15_23","006_15_23","DEU","15","23","23","ولی خون آن را نخورید، بلکه آن را مثل آب بر زمین بریزید. ");
INSERT INTO pesopcb_vpl VALUES ("DT16_1","006_16_1","DEU","16","1","1","همیشه به یاد داشته باشید که در ماه ابیب، مراسم عید پِسَح را به احترام یهوه خدایتان بجا آورید، زیرا در این ماه بود که او شما را شبانه، از سرزمین مصر بیرون آورد. ");
INSERT INTO pesopcb_vpl VALUES ("DT16_2","006_16_2","DEU","16","2","2","برای عید پِسَح، شما باید یک بره یا یک گاو در محلی که خداوند، خدایتان به عنوان عبادتگاه خود برمی‌گزیند، برای او قربانی کنید. ");
INSERT INTO pesopcb_vpl VALUES ("DT16_3","006_16_3","DEU","16","3","3","گوشت قربانی را با نان خمیرمایه‌دار نخورید. هفت روز نان بدون خمیرمایه یعنی نانِ مشقت بخورید. این نان، یادگار سختیهای شما در مصر و نیز یادگار روزی است که با عجله از مصر خارج شدید. این روز را در تمام عمر خود به خاطر داشته باشید. ");
INSERT INTO pesopcb_vpl VALUES ("DT16_4","006_16_4","DEU","16","4","4","مدت هفت روز اثری از خمیرمایه در خانهٔ شما نباشد و از گوشت قربانی پِسَح تا صبح روز بعد چیزی باقی نماند. ");
INSERT INTO pesopcb_vpl VALUES ("DT16_5","006_16_5","DEU","16","5","5","قربانی پِسَح را نمی‌توانید در هر شهری از شهرهایی که یهوه خدایتان به شما می‌دهد، ذبح کنید. ");
INSERT INTO pesopcb_vpl VALUES ("DT16_6","006_16_6","DEU","16","6","6","پِسَح را فقط باید در مکانی که یهوه خدایتان برای گرامیداشت نام خود تعیین می‌کند، ذبح نمایید. قربانی پِسَح را هنگام غروب سر ببرید، زیرا هنگامی که از مصر خارج شدید، غروب بود. ");
INSERT INTO pesopcb_vpl VALUES ("DT16_7","006_16_7","DEU","16","7","7","گوشت قربانی را در همان جا که یهوه خدایتان برمی‌گزیند، بپزید و بخورید، و صبح روز بعد، راهی خانه‌هایتان بشوید. ");
INSERT INTO pesopcb_vpl VALUES ("DT16_8","006_16_8","DEU","16","8","8","تمام شش روز بعد را هم نان فطیر بخورید. در روز هفتم، تمام قوم برای عبادت یهوه خدایتان جمع شوند و هیچ کار دیگری نکنند. ");
INSERT INTO pesopcb_vpl VALUES ("DT16_9","006_16_9","DEU","16","9","9","هفت هفته پس از شروع فصل درو، ");
INSERT INTO pesopcb_vpl VALUES ("DT16_10","006_16_10","DEU","16","10","10","عید دیگری در حضور خداوند، خدایتان خواهید داشت که عید هفته‌ها خوانده می‌شود. در این عید هدیهٔ داوطلبانه‌ای مطابق برکتی که خداوند به شما داده است نزد خداوند بیاورید. ");
INSERT INTO pesopcb_vpl VALUES ("DT16_11","006_16_11","DEU","16","11","11","در این عید با پسران و دختران، غلامان و کنیزان خود در حضور خداوند شادی کنید. فراموش نکنید که لاویان، غریبان، بیوه‌زنان و یتیمان شهرتان را هم دعوت کنید تا در مراسم جشن، در مکانی که خداوند به عنوان عبادتگاه خود تعیین می‌کند، شرکت کنند. ");
INSERT INTO pesopcb_vpl VALUES ("DT16_12","006_16_12","DEU","16","12","12","این فرایض را به‌دقت به جا آورید، زیرا خود شما هم در مصر برده بوده‌اید. ");
INSERT INTO pesopcb_vpl VALUES ("DT16_13","006_16_13","DEU","16","13","13","جشن دیگر، عید سایبانهاست که باید به مدت هفت روز در پایان فصل درو، پس از اینکه خرمن خود را کوبیدید و آب انگورتان را گرفتید، برگزار کنید. ");
INSERT INTO pesopcb_vpl VALUES ("DT16_14","006_16_14","DEU","16","14","14","در این عید به اتفاق پسران و دختران، غلامان و کنیزان خود شادی نمایید. فراموش نکنید که لاویان، غریبان، یتیمان و بیوه‌زنان شهر خود را نیز دعوت کنید. ");
INSERT INTO pesopcb_vpl VALUES ("DT16_15","006_16_15","DEU","16","15","15","این عید را در محلی که خداوند تعیین خواهد کرد به مدت هفت روز برای او برگزار کنید. در این عید شادی کنید، زیرا خداوند محصول و دسترنج شما را برکت داده است. ");
INSERT INTO pesopcb_vpl VALUES ("DT16_16","006_16_16","DEU","16","16","16","مردان اسرائیلی باید سه بار در سال در حضور خداوند، خدایشان در محلی که خداوند تعیین خواهد کرد به خاطر این سه عید حاضر شوند: عید پِسَح، عید هفته‌ها و عید سایبانها. در هر کدام از این اعیاد، هدایایی برای خداوند بیاورید. ");
INSERT INTO pesopcb_vpl VALUES ("DT16_17","006_16_17","DEU","16","17","17","تا جایی که از دستتان برمی‌آید به نسبت برکتی که از یهوه خدایتان یافته‌اید هدیه بدهید. ");
INSERT INTO pesopcb_vpl VALUES ("DT16_18","006_16_18","DEU","16","18","18","برای هر یک از قبایل خود در شهرهایی که خداوند، خدایتان به شما می‌دهد قضات و رهبرانی تعیین کنید تا ایشان مردم را عادلانه داوری کنند. ");
INSERT INTO pesopcb_vpl VALUES ("DT16_19","006_16_19","DEU","16","19","19","هنگام داوری از کسی طرفداری نکنید، عدالت را زیر پا نگذارید و رشوه نگیرید، چون رشوه حتی چشمان عادلان را کور می‌کند و راستگویان را به دروغگویی وا می‌دارد. ");
INSERT INTO pesopcb_vpl VALUES ("DT16_20","006_16_20","DEU","16","20","20","عدل و انصاف را همیشه بجا آورید تا بتوانید زنده مانده، سرزمینی را که خداوند، خدایتان به شما می‌بخشد تصرف نمایید. ");
INSERT INTO pesopcb_vpl VALUES ("DT16_21","006_16_21","DEU","16","21","21","هرگز مجسمه‌های شرم‌آور بت‌پرستان را در کنار مذبح یهوه خدایتان نسازید ");
INSERT INTO pesopcb_vpl VALUES ("DT16_22","006_16_22","DEU","16","22","22","و ستونهای آنها را بر پا نکنید، چون خداوند از این بتها بیزار است. ");
INSERT INTO pesopcb_vpl VALUES ("DT17_1","006_17_1","DEU","17","1","1","هرگز گاو یا گوسفند مریض و معیوب، برای خداوند، خدایتان قربانی نکنید. خداوند از این کار متنفر است. ");
INSERT INTO pesopcb_vpl VALUES ("DT17_2‏","006_17_2‏","DEU","17","2‏","3","اگر بشنوید مرد یا زنی در یکی از شهرهای سرزمینتان از عهد یهوه خدایتان تخلف نموده، بت یا خورشید و ماه و ستارگان را که خداوند پرستش آنها را اکیداً قدغن کرده، عبادت می‌کند، ");
INSERT INTO pesopcb_vpl VALUES ("DT17_4","006_17_4","DEU","17","4","4","اول خوب تحقیق کنید و بعد که معلوم شد چنین گناهی در اسرائیل به وقوع پیوسته است، ");
INSERT INTO pesopcb_vpl VALUES ("DT17_5","006_17_5","DEU","17","5","5","آنگاه آن مرد یا زن را به بیرون شهر ببرید و سنگسارش کنید تا بمیرد. ");
INSERT INTO pesopcb_vpl VALUES ("DT17_6","006_17_6","DEU","17","6","6","ولی هرگز شخصی را بنا به شهادت یک گواه به قتل نرسانید؛ حداقل باید دو یا سه شاهد وجود داشته باشند. ");
INSERT INTO pesopcb_vpl VALUES ("DT17_7","006_17_7","DEU","17","7","7","اول، شاهدان باید سنگها را پرتاب کنند و سپس تمام مردم. به این طریق، این بدی را از میان خود پاک خواهید ساخت. ");
INSERT INTO pesopcb_vpl VALUES ("DT17_8","006_17_8","DEU","17","8","8","اگر واقعه‌ای در میان شما اتفاق بیفتد که قضاوت راجع به آن برای شما سخت باشد چه قتل باشد، چه ضرب و جرح، و چه دعوا، در این صورت باید آن مرافعه را به محلی که خداوند، خدایتان تعیین می‌کند ");
INSERT INTO pesopcb_vpl VALUES ("DT17_9","006_17_9","DEU","17","9","9","نزد کاهنان نسل لاوی و قاضی وقت ببرید تا ایشان در این مورد قضاوت کنند. ");
INSERT INTO pesopcb_vpl VALUES ("DT17_10‏","006_17_10‏","DEU","17","10‏","11","هر چه آنها در مکانی که خداوند تعیین کرده است بگویند باید بدون چون و چرا اجرا گردد. مواظب باشید که از احکام و دستورهای ایشان سرپیچی نکنید. ");
INSERT INTO pesopcb_vpl VALUES ("DT17_12","006_17_12","DEU","17","12","12","اگر محکوم از قبول حکم قاضی یا کاهن که خادم یهوه خدایتان است، خودداری کند مجازات او مرگ است. اسرائیل را باید از وجود چنین گناهکارانی پاک نمود. ");
INSERT INTO pesopcb_vpl VALUES ("DT17_13","006_17_13","DEU","17","13","13","آنگاه همهٔ مردم از این مجازات باخبر شده، خواهند ترسید و جرأت نخواهند کرد با رأی دادگاه مخالفت کنند. ");
INSERT INTO pesopcb_vpl VALUES ("DT17_14","006_17_14","DEU","17","14","14","هرگاه در سرزمینی که یهوه خدایتان آن را به شما خواهد داد، ساکن شده، به این فکر بیفتید که «ما هم باید مثل قومهای دیگری که اطراف ما هستند یک پادشاه داشته باشیم»، ");
INSERT INTO pesopcb_vpl VALUES ("DT17_15","006_17_15","DEU","17","15","15","باید مردی را به پادشاهی برگزینید که خداوند، خدایتان انتخاب می‌کند. او باید اسرائیلی باشد و نه بیگانه. ");
INSERT INTO pesopcb_vpl VALUES ("DT17_16","006_17_16","DEU","17","16","16","او نباید به فکر جمع کردن اسب باشد و افرادش را به مصر بفرستد تا از آنجا برایش اسب بیاورند، چون خداوند به شما گفته است: «هرگز بار دیگر به مصر باز نگردید.» ");
INSERT INTO pesopcb_vpl VALUES ("DT17_17","006_17_17","DEU","17","17","17","او نباید زنان زیادی برای خود بگیرد مبادا دلش از خداوند دور شود؛ همچنین نباید برای خود ثروت بیندوزد. ");
INSERT INTO pesopcb_vpl VALUES ("DT17_18","006_17_18","DEU","17","18","18","وقتی او بر تخت پادشاهی نشست، باید نسخه‌ای از قوانین خدا را که به‌وسیلۀ کاهنان لاوی نگهداری می‌شود، برای خود تهیه کند. ");
INSERT INTO pesopcb_vpl VALUES ("DT17_19","006_17_19","DEU","17","19","19","او باید این رونوشت قوانین را نزد خود نگه دارد و در تمام روزهای عمرش آن را مطالعه کند تا یاد بگیرد خداوند، خدایش را احترام کند و دستورها و قوانین او را اطاعت نماید. ");
INSERT INTO pesopcb_vpl VALUES ("DT17_20","006_17_20","DEU","17","20","20","این کار او باعث خواهد شد خود را از دیگران برتر نداند و از هیچ‌یک از اوامر خداوند انحراف نورزد. بدین ترتیب سلطنت او طولانی خواهد بود و پس از او نیز پسرانش، نسلهای زیادی بر اسرائیل سلطنت خواهند کرد. ");
INSERT INTO pesopcb_vpl VALUES ("DT18_1","006_18_1","DEU","18","1","1","کاهنان و سایر افراد قبیلهٔ لاوی نباید در اسرائیل ملکی داشته باشند. بنابراین شما باید با آوردن قربانیها و هدایا به مذبح خداوند، زندگی ایشان را تأمین کنید. ");
INSERT INTO pesopcb_vpl VALUES ("DT18_2","006_18_2","DEU","18","2","2","کاهنان و لاویان نباید ملکی داشته باشند، زیرا همان‌طور که خداوند وعده داده، خود او میراث ایشان است. ");
INSERT INTO pesopcb_vpl VALUES ("DT18_3","006_18_3","DEU","18","3","3","شانه، دو بناگوش و شکمبهٔ هر گاو و گوسفندی را که برای قربانی می‌آورید به کاهنان بدهید. ");
INSERT INTO pesopcb_vpl VALUES ("DT18_4","006_18_4","DEU","18","4","4","علاوه بر اینها، نوبر محصول خود یعنی نوبر غلات، شراب تازه، روغن زیتون و همچنین پشم گوسفندان خود را نیز به ایشان بدهید؛ ");
INSERT INTO pesopcb_vpl VALUES ("DT18_5","006_18_5","DEU","18","5","5","زیرا خداوند، خدایتان قبیلهٔ لاوی را از بین تمام قبیله‌ها انتخاب کرده است تا نسل اندر نسل خداوند را خدمت کنند. ");
INSERT INTO pesopcb_vpl VALUES ("DT18_6‏","006_18_6‏","DEU","18","6‏","7","هر فرد لاوی، در هر گوشه‌ای از سرزمین اسرائیل که باشد این حق را دارد که هر وقت بخواهد به مکانی که خداوند به عنوان عبادتگاه خود تعیین می‌کند آمده، به نام یهوه خدای خود خدمت کند، درست مانند دیگر برادران لاوی خود که به طور مداوم در آنجا خدمت می‌کنند. ");
INSERT INTO pesopcb_vpl VALUES ("DT18_8","006_18_8","DEU","18","8","8","از قربانیها و هدایایی که به لاویان داده می‌شود به او نیز باید سهمی تعلق گیرد، چه محتاج باشد و چه نباشد. ");
INSERT INTO pesopcb_vpl VALUES ("DT18_9","006_18_9","DEU","18","9","9","وقتی به سرزمینی که یهوه خدایتان به شما می‌دهد، وارد شدید، مواظب باشید که از آداب و رسوم نفرت‌انگیز قومهایی که در آنجا زندگی می‌کنند پیروی نکنید. ");
INSERT INTO pesopcb_vpl VALUES ("DT18_10‏","006_18_10‏","DEU","18","10‏","11","مانند آنها فرزندان خود را روی آتش مذبح قربانی نکنید. هیچ‌یک از شما نباید به جادوگری بپردازد یا غیبگویی و رمالی و فالگیری کند و یا ارواح مردگان را احضار نماید. ");
INSERT INTO pesopcb_vpl VALUES ("DT18_12","006_18_12","DEU","18","12","12","خداوند از تمام کسانی که دست به چنین کارها می‌زنند متنفر است. به سبب انجام همین کارهاست که خداوند، خدایتان این قومها را ریشه‌کن می‌کند. ");
INSERT INTO pesopcb_vpl VALUES ("DT18_13","006_18_13","DEU","18","13","13","شما باید در حضور خداوند، خدایتان پاک و بی‌عیب باشید. ");
INSERT INTO pesopcb_vpl VALUES ("DT18_14","006_18_14","DEU","18","14","14","قومهایی که شما سرزمینشان را تصرف می‌کنید به غیبگویان و فالگیران گوش می‌دهند، ولی یهوه خدایتان به شما اجازه چنین کاری را نمی‌دهد. ");
INSERT INTO pesopcb_vpl VALUES ("DT18_15","006_18_15","DEU","18","15","15","او از میان قوم اسرائیل پیامبری مانند من برای شما خواهد فرستاد و شما باید به او گوش دهید و از او اطاعت کنید. ");
INSERT INTO pesopcb_vpl VALUES ("DT18_16","006_18_16","DEU","18","16","16","روزی که در دامنهٔ کوه حوریب جمع شده بودید از یهوه خدایتان خواستید که صدای مهیب او را بار دیگر نشنوید و آن آتش هولناک را در بالای کوه نبینید، چون می‌ترسیدید بمیرید. ");
INSERT INTO pesopcb_vpl VALUES ("DT18_17","006_18_17","DEU","18","17","17","پس خداوند به من فرمود: «درخواست آنها بجاست. ");
INSERT INTO pesopcb_vpl VALUES ("DT18_18","006_18_18","DEU","18","18","18","من از میان آنها پیامبری مانند تو برای ایشان خواهم فرستاد. به او خواهم گفت که چه بگوید و او سخنگوی من نزد مردم خواهد بود. ");
INSERT INTO pesopcb_vpl VALUES ("DT18_19","006_18_19","DEU","18","19","19","هر که به او گوش ندهد و به پیامش که از جانب من است توجه نکند، من خود از او بازخواست خواهم کرد. ");
INSERT INTO pesopcb_vpl VALUES ("DT18_20","006_18_20","DEU","18","20","20","هر پیامبری که به دروغ ادعا کند پیامش از جانب من است، خواهد مرد و هر پیامبری که ادعا کند پیامش از جانب خدایان دیگر است باید کشته شود.» ");
INSERT INTO pesopcb_vpl VALUES ("DT18_21","006_18_21","DEU","18","21","21","اگر دودل هستید که پیامی از جانب خداوند است یا نه، ");
INSERT INTO pesopcb_vpl VALUES ("DT18_22","006_18_22","DEU","18","22","22","راه فهمیدنش این است: اگر چیزی که او می‌گوید اتفاق نیفتد، پیام او از جانب خداوند نبوده بلکه ساخته و پرداختهٔ خودش است؛ پس، از او نترسید. ");
INSERT INTO pesopcb_vpl VALUES ("DT19_1","006_19_1","DEU","19","1","1","هنگامی که یهوه خدایتان قومهایی را که سرزمینشان را به شما می‌دهد، نابود کند و شما در شهرها و خانه‌هایشان ساکن شوید، ");
INSERT INTO pesopcb_vpl VALUES ("DT19_2‏","006_19_2‏","DEU","19","2‏","3","آنگاه باید سه شهر به عنوان پناهگاه تعیین کنید تا اگر کسی نادانسته شخصی را بکشد، بتواند به آنجا فرار کرده، در امان باشد. کشورتان را به سه منطقه تقسیم کنید به طوری که هر کدام از این سه شهر در یکی از آن سه منطقه واقع گردد. جاده‌هایی را که به این شهرها می‌روند خوب نگه دارید. ");
INSERT INTO pesopcb_vpl VALUES ("DT19_4","006_19_4","DEU","19","4","4","اگر کسی نادانسته مرتکب قتل شود می‌تواند به یکی از این شهرها فرار کرده، در آنجا پناه گیرد. ");
INSERT INTO pesopcb_vpl VALUES ("DT19_5","006_19_5","DEU","19","5","5","برای مثال، اگر مردی با همسایهٔ خود برای بریدن هیزم به جنگل برود و سر تبر از دسته‌اش جدا شده، باعث قتل همسایه‌اش گردد، آن مرد می‌تواند به یکی از این شهرها گریخته، در امان باشد. ");
INSERT INTO pesopcb_vpl VALUES ("DT19_6‏","006_19_6‏","DEU","19","6‏","7","بدین ترتیب مدعی خون مقتول نمی‌تواند او را بکشد. این شهرها باید پراکنده باشند تا همه بتوانند به آن دسترسی داشته باشند و گرنه مدعی خشمگین، ممکن است قاتل بی‌گناه را بکشد. ");
INSERT INTO pesopcb_vpl VALUES ("DT19_8","006_19_8","DEU","19","8","8","اگر یهوه خدایتان طبق وعده‌ای که با سوگند به پدران شما داده است مرزهای سرزمینتان را وسیعتر کند و تمام سرزمینی را که وعده داده است، به شما ببخشد، ");
INSERT INTO pesopcb_vpl VALUES ("DT19_9","006_19_9","DEU","19","9","9","در این صورت باید سه شهر پناهگاه دیگر نیز داشته باشید. (البته او وقتی این سرزمین را به شما خواهد داد که از کلیهٔ فرمانهایی که امروز به شما می‌دهم اطاعت نموده یهوه خدایتان را دوست بدارید و همواره در راه او گام بردارید.) ");
INSERT INTO pesopcb_vpl VALUES ("DT19_10","006_19_10","DEU","19","10","10","چنین عمل کنید تا در سرزمینی که خداوند به شما می‌دهد اشخاص بی‌گناه کشته نشوند و خون کسی به گردن شما نباشد. ");
INSERT INTO pesopcb_vpl VALUES ("DT19_11","006_19_11","DEU","19","11","11","ولی اگر کسی از همسایهٔ خود نفرت داشته باشد و با قصد قبلی او را بکشد و سپس به یکی از شهرهای پناهگاه فرار نماید، ");
INSERT INTO pesopcb_vpl VALUES ("DT19_12","006_19_12","DEU","19","12","12","آنگاه مشایخ شهر باید دنبال او فرستاده، او را بازگردانند و تحویل مدعی خون مقتول بدهند تا او را بکشد. ");
INSERT INTO pesopcb_vpl VALUES ("DT19_13","006_19_13","DEU","19","13","13","به او رحم نکنید! اسرائیل را از خون بی‌گناه پاک کنید تا در همهٔ کارهایتان کامیاب باشید. ");
INSERT INTO pesopcb_vpl VALUES ("DT19_14","006_19_14","DEU","19","14","14","هنگامی که وارد سرزمینی شدید که خداوند، خدایتان به شما می‌دهد، مواظب باشید مرزهای ملک همسایه‌تان را که از قدیم تعیین شده است به نفع خود تغییر ندهید. ");
INSERT INTO pesopcb_vpl VALUES ("DT19_15","006_19_15","DEU","19","15","15","هرگز کسی را بر اساس شهادت یک نفر محکوم نکنید. حداقل دو یا سه شاهد باید وجود داشته باشند. ");
INSERT INTO pesopcb_vpl VALUES ("DT19_16","006_19_16","DEU","19","16","16","اگر کسی شهادت دروغ بدهد و ادعا کند که شخصی را هنگام ارتکاب جرمی دیده است، ");
INSERT INTO pesopcb_vpl VALUES ("DT19_17","006_19_17","DEU","19","17","17","هر دو نفر باید به نزد کاهنان و قضاتی که در آن موقع در حضور خداوند مشغول خدمتند، آورده شوند. ");
INSERT INTO pesopcb_vpl VALUES ("DT19_18","006_19_18","DEU","19","18","18","قضات باید این امر را به دقت تحقیق کنند. اگر معلوم شد که شاهد دروغ می‌گوید، ");
INSERT INTO pesopcb_vpl VALUES ("DT19_19","006_19_19","DEU","19","19","19","مجازاتش باید همان باشد که او فکر می‌کرد مرد دیگر به آن محکوم می‌شد. به این طریق شرارت را از میان خود پاک خواهید کرد. ");
INSERT INTO pesopcb_vpl VALUES ("DT19_20","006_19_20","DEU","19","20","20","بعد از آن، کسانی که این خبر را بشنوند از دروغ گفتن در جایگاه شهود خواهند ترسید. ");
INSERT INTO pesopcb_vpl VALUES ("DT19_21","006_19_21","DEU","19","21","21","به شاهد دروغگو نباید رحم کنید. حکم شما در این گونه موارد باید چنین باشد: جان به عوض جان، چشم به عوض چشم، دندان به عوض دندان، دست به عوض دست و پا به عوض پا. ");
INSERT INTO pesopcb_vpl VALUES ("DT20_1","006_20_1","DEU","20","1","1","زمانی که به جنگ می‌روید و در برابر خود لشکری نیرومندتر از خود با اسبها و ارابه‌های جنگی زیاد می‌بینید، وحشت نکنید. خداوند، خدایتان با شماست، همان خدایی که شما را از مصر بیرون آورد. ");
INSERT INTO pesopcb_vpl VALUES ("DT20_2","006_20_2","DEU","20","2","2","قبل از شروع جنگ، کاهنی در برابر لشکر اسرائیل بایستد و بگوید: ");
INSERT INTO pesopcb_vpl VALUES ("DT20_3","006_20_3","DEU","20","3","3","«ای مردان اسرائیلی به من گوش کنید! امروز که به جنگ می‌روید از دشمن نترسید و جرأت خود را از دست ندهید؛ ");
INSERT INTO pesopcb_vpl VALUES ("DT20_4","006_20_4","DEU","20","4","4","چون خداوند، خدایتان همراه شماست. او برای شما با دشمنانتان می‌جنگد و به شما پیروزی می‌بخشد.» ");
INSERT INTO pesopcb_vpl VALUES ("DT20_5","006_20_5","DEU","20","5","5","آنگاه سرداران سپاه باید سربازان را خطاب کرده، چنین بگویند: «آیا در اینجا کسی هست که به تازگی خانه‌ای ساخته، ولی هنوز از آن استفاده نکرده باشد؟ اگر چنین کسی هست به خانه برگردد، چون ممکن است در این جنگ کشته شود و شخص دیگری از آن استفاده کند. ");
INSERT INTO pesopcb_vpl VALUES ("DT20_6","006_20_6","DEU","20","6","6","آیا کسی هست که به تازگی تاکستانی غرس کرده، ولی هنوز میوه‌ای از آن نخورده باشد؟ اگر چنین کسی هست به خانه بازگردد، چون ممکن است در این جنگ کشته شود و شخص دیگری میوهٔ آن را بخورد. ");
INSERT INTO pesopcb_vpl VALUES ("DT20_7","006_20_7","DEU","20","7","7","آیا کسی به تازگی دختری را نامزد کرده است؟ اگر چنین کسی هست به خانهٔ خود بازگردد و با نامزدش ازدواج کند، چون ممکن است در این جنگ بمیرد و شخص دیگری نامزد او را به زنی بگیرد.» ");
INSERT INTO pesopcb_vpl VALUES ("DT20_8","006_20_8","DEU","20","8","8","سپس سرداران بگویند: «آیا در اینجا کسی هست که می‌ترسد و دلشوره دارد؟ اگر چنین کسی هست به خانه بازگردد تا روحیهٔ دیگران را تضعیف نکند.» ");
INSERT INTO pesopcb_vpl VALUES ("DT20_9","006_20_9","DEU","20","9","9","پس از نطق سرداران، فرماندهانی برای سپاه تعیین شوند. ");
INSERT INTO pesopcb_vpl VALUES ("DT20_10","006_20_10","DEU","20","10","10","هنگامی که به شهری نزدیک می‌شوید تا با آن بجنگید، نخست به مردم آنجا فرصت دهید خود را تسلیم کنند. ");
INSERT INTO pesopcb_vpl VALUES ("DT20_11","006_20_11","DEU","20","11","11","اگر آنها دروازه‌های شهر را به روی شما باز کردند، وارد شهر بشوید و مردم آنجا را اسیر کرده، به خدمت خود بگیرید؛ ");
INSERT INTO pesopcb_vpl VALUES ("DT20_12","006_20_12","DEU","20","12","12","ولی اگر تسلیم نشدند، شهر را محاصره کنید. ");
INSERT INTO pesopcb_vpl VALUES ("DT20_13","006_20_13","DEU","20","13","13","هنگامی که خداوند، خدایتان آن شهر را به شما داد، همهٔ مردانِ آن را از بین ببرید؛ ");
INSERT INTO pesopcb_vpl VALUES ("DT20_14","006_20_14","DEU","20","14","14","ولی زنها و بچه‌ها، گاوها و گوسفندها، و هر چه را که در شهر باشد می‌توانید برای خود نگه دارید. تمام غنایمی را که از دشمن به دست می‌آورید مال شماست. خداوند آنها را به شما داده است. ");
INSERT INTO pesopcb_vpl VALUES ("DT20_15","006_20_15","DEU","20","15","15","این دستورها فقط شامل شهرهای دور دست می‌باشند و نه شهرهایی که در خود سرزمین موعود هستند. ");
INSERT INTO pesopcb_vpl VALUES ("DT20_16","006_20_16","DEU","20","16","16","در شهرهای داخل مرزهای سرزمین موعود، هیچ‌کس را نباید زنده بگذارید. هر موجود زنده‌ای را از بین ببرید. ");
INSERT INTO pesopcb_vpl VALUES ("DT20_17","006_20_17","DEU","20","17","17","حیتی‌ها، اموری‌ها، کنعانی‌ها، فرزی‌ها، حوی‌ها و یبوسی‌ها را به کلی نابود کنید. این حکمی است که خداوند، خدایتان داده است. ");
INSERT INTO pesopcb_vpl VALUES ("DT20_18","006_20_18","DEU","20","18","18","منظور از این فرمان آن است که نگذارد مردم این سرزمین، شما را فریب داده، در دام بت‌پرستی و آداب و رسوم قبیح خود گرفتار سازند و شما را وادارند گناه بزرگی نسبت به خداوند، خدایتان مرتکب شوید. ");
INSERT INTO pesopcb_vpl VALUES ("DT20_19","006_20_19","DEU","20","19","19","زمانی که شهری را برای مدت طولانی محاصره می‌کنید، درختان میوه را از بین نبرید. از میوهٔ آنها بخورید، ولی درختان را قطع نکنید. درختان، دشمنان شما نیستند! ");
INSERT INTO pesopcb_vpl VALUES ("DT20_20","006_20_20","DEU","20","20","20","اما درختان دیگر را می‌توانید قطع کنید و از آنها برای محاصرهٔ شهر استفاده کنید. ");
INSERT INTO pesopcb_vpl VALUES ("DT21_1","006_21_1","DEU","21","1","1","در سرزمینی که یهوه خدایتان به شما می‌دهد، هرگاه جسد مقتولی که قاتلش معلوم نیست در صحرا پیدا شود، ");
INSERT INTO pesopcb_vpl VALUES ("DT21_2‏","006_21_2‏","DEU","21","2‏","3","آنگاه مشایخ و قضات با اندازه‌گیری فاصلهٔ جسد تا شهرهای اطراف، نزدیکترین شهر را تعیین کنند. مشایخ آن شهر، باید گوساله‌ای را که تا به حال بر آن یوغ بسته نشده بگیرند ");
INSERT INTO pesopcb_vpl VALUES ("DT21_4","006_21_4","DEU","21","4","4","و آن را به دره‌ای ببرند که در آن آب جاری باشد، ولی زمینش هرگز شخم نخورده و کشت نشده باشد، و در آنجا گردن گوساله را بشکنند. ");
INSERT INTO pesopcb_vpl VALUES ("DT21_5","006_21_5","DEU","21","5","5","آنگاه کاهنان لاوی نزدیک بیایند، زیرا یهوه خدایتان ایشان را انتخاب کرده است تا در حضور او خدمت کنند و به نام خداوند برکت دهند و در مرافعه‌ها و مجازاتها تصمیم بگیرند. ");
INSERT INTO pesopcb_vpl VALUES ("DT21_6","006_21_6","DEU","21","6","6","سپس مشایخ آن شهر، دستهای خود را روی آن گوساله بشویند ");
INSERT INTO pesopcb_vpl VALUES ("DT21_7","006_21_7","DEU","21","7","7","و بگویند: «دستهای ما این خون را نریخته و چشمان ما هم آن را ندیده است. ");
INSERT INTO pesopcb_vpl VALUES ("DT21_8","006_21_8","DEU","21","8","8","ای خداوند، قوم خود، اسرائیل را که نجات داده‌ای ببخش و آنها را به قتل مردی بی‌گناه متهم نکن. گناه خون این مرد را بر ما نگیر.» ");
INSERT INTO pesopcb_vpl VALUES ("DT21_9","006_21_9","DEU","21","9","9","به این ترتیب با پیروی از دستورهای خداوند، شما این گناه را از بین خود دور خواهید کرد. ");
INSERT INTO pesopcb_vpl VALUES ("DT21_10","006_21_10","DEU","21","10","10","زمانی که به جنگ می‌روید و خداوند، خدایتان دشمنان شما را به دست شما تسلیم می‌کند و شما آنها را به اسارت خود درمی‌آورید، ");
INSERT INTO pesopcb_vpl VALUES ("DT21_11","006_21_11","DEU","21","11","11","چنانچه در میان اسیران، دختر زیبایی را ببینید و عاشق او بشوید، و بخواهید او را به زنی بگیرید، ");
INSERT INTO pesopcb_vpl VALUES ("DT21_12","006_21_12","DEU","21","12","12","می‌توانید او را به خانهٔ خود بیاورید و بگذارید سرش را بتراشد، ناخنهایش را بگیرد ");
INSERT INTO pesopcb_vpl VALUES ("DT21_13","006_21_13","DEU","21","13","13","و لباسهایش را که هنگام اسیر شدن پوشیده بود عوض کند. سپس یک ماه تمام در خانهٔ شما در عزای پدر و مادرش بنشیند. بعد از آن، می‌توانید او را به زنی اختیار کنید. ");
INSERT INTO pesopcb_vpl VALUES ("DT21_14","006_21_14","DEU","21","14","14","بعد اگر از او راضی نبودید، نباید او را بفروشید یا مثل برده با او رفتار کنید، زیرا او را به زنی گرفته‌اید؛ پس، بگذارید هر جا می‌خواهد برود. ");
INSERT INTO pesopcb_vpl VALUES ("DT21_15","006_21_15","DEU","21","15","15","اگر مردی دو همسر داشته باشد، و از هر دو صاحب پسر شود و پسر بزرگترش فرزند همسر مورد علاقه‌اش نباشد، ");
INSERT INTO pesopcb_vpl VALUES ("DT21_16","006_21_16","DEU","21","16","16","حق ندارد ارث بیشتری به پسر کوچکترش یعنی پسر زنی که وی او را دوست دارد بدهد. ");
INSERT INTO pesopcb_vpl VALUES ("DT21_17","006_21_17","DEU","21","17","17","او باید دو سهم به پسر بزرگترش که نخستین نشانهٔ قدرتش بوده و حق نخست‌زادگی به او می‌رسد بدهد، هرچند وی پسر همسر مورد علاقه‌اش نباشد. ");
INSERT INTO pesopcb_vpl VALUES ("DT21_18","006_21_18","DEU","21","18","18","اگر مردی پسر لجوج و سرکشی داشته باشد که با وجود تنبیهات مکرر والدین، از ایشان اطاعت نکند، ");
INSERT INTO pesopcb_vpl VALUES ("DT21_19","006_21_19","DEU","21","19","19","در این صورت باید پدر و مادرش او را نزد مشایخ شهر ببرند ");
INSERT INTO pesopcb_vpl VALUES ("DT21_20","006_21_20","DEU","21","20","20","و بگویند: «این پسر ما لجوج و سرکش است، حرف ما را گوش نمی‌کند و به ولخرجی و میگساری می‌پردازد.» ");
INSERT INTO pesopcb_vpl VALUES ("DT21_21","006_21_21","DEU","21","21","21","آنگاه اهالی شهر او را سنگسار کنند تا بمیرد. به این طریق، شرارت را از میان خود دور خواهید کرد و همهٔ جوانان اسرائیل این واقعه را شنیده، خواهند ترسید. ");
INSERT INTO pesopcb_vpl VALUES ("DT21_22","006_21_22","DEU","21","22","22","اگر مردی مرتکب جرمی شده باشد که جزای آن مرگ است و پس از اعدام، جسد او را به درختی بیاویزند، ");
INSERT INTO pesopcb_vpl VALUES ("DT21_23","006_21_23","DEU","21","23","23","جسد او نباید در طول شب روی درخت بماند. باید همان روز او را دفن کنید، زیرا کسی که بر دار آویخته شده باشد ملعون خداست. پس بدن او را دفن کنید تا سرزمینی که خداوند، خدایتان به شما داده است آلوده نشود. ");
INSERT INTO pesopcb_vpl VALUES ("DT22_1","006_22_1","DEU","22","1","1","اگر گاو یا گوسفند کسی را سرگردان دیدید، وانمود نکنید که آن را ندیده‌اید، بلکه حتماً آن را به نزد صاحبش برگردانید. ");
INSERT INTO pesopcb_vpl VALUES ("DT22_2","006_22_2","DEU","22","2","2","اگر صاحبش نزدیک شما زندگی نمی‌کند و یا او را نمی‌شناسید، آن را به مزرعهٔ خود ببرید و در آنجا نگه دارید تا زمانی که صاحبش به دنبال آن بیاید. آنگاه آن را به صاحبش بدهید. ");
INSERT INTO pesopcb_vpl VALUES ("DT22_3","006_22_3","DEU","22","3","3","این قانون شامل الاغ، لباس یا هر چیز دیگری که پیدا می‌کنید نیز می‌شود. نسبت به آن بی‌اعتنا نباشید. ");
INSERT INTO pesopcb_vpl VALUES ("DT22_4","006_22_4","DEU","22","4","4","اگر کسی را دیدید که سعی می‌کند گاو یا الاغی را که زیر بار خوابیده است روی پاهایش بلند کند، رویتان را برنگردانید، بلکه به کمکش بشتابید. ");
INSERT INTO pesopcb_vpl VALUES ("DT22_5","006_22_5","DEU","22","5","5","زن نباید لباس مردانه بپوشد و مرد نباید لباس زنانه به تن کند. این کار در نظر خداوند، خدایتان نفرت‌انگیز است. ");
INSERT INTO pesopcb_vpl VALUES ("DT22_6","006_22_6","DEU","22","6","6","اگر آشیانهٔ پرنده‌ای را روی زمین افتاده ببینید و یا آشیانه‌ای را روی درختی ببینید که پرنده با جوجه‌ها یا تخمهایش در داخل آن نشسته است، مادر و جوجه‌هایش را با هم برندارید؛ ");
INSERT INTO pesopcb_vpl VALUES ("DT22_7","006_22_7","DEU","22","7","7","مادر را رها کنید برود و فقط جوجه‌هایش را بردارید. اگر چنین کنید زندگی‌تان پربرکت و طولانی خواهد بود. ");
INSERT INTO pesopcb_vpl VALUES ("DT22_8","006_22_8","DEU","22","8","8","وقتی خانهٔ تازه‌ای می‌سازید، باید دیوار کوتاهی دور تا دور پشت بام بکشید تا از افتادن اشخاص جلوگیری کرده، مسئول مرگ کسی نشوید. ");
INSERT INTO pesopcb_vpl VALUES ("DT22_9","006_22_9","DEU","22","9","9","در تاکستان خود بذر دیگری نکارید. اگر کاشتید، هم محصول بذر کاشته شده و هم انگورها تلف خواهند شد. ");
INSERT INTO pesopcb_vpl VALUES ("DT22_10","006_22_10","DEU","22","10","10","با گاو و الاغی که به هم یراق شده‌اند شخم نکنید. ");
INSERT INTO pesopcb_vpl VALUES ("DT22_11","006_22_11","DEU","22","11","11","لباسی را که از دو نوع نخ، مثلاً پشم و کتان بافته شده است نپوشید. ");
INSERT INTO pesopcb_vpl VALUES ("DT22_12","006_22_12","DEU","22","12","12","در چهار گوشهٔ ردای خود باید منگوله بدوزید. ");
INSERT INTO pesopcb_vpl VALUES ("DT22_13‏","006_22_13‏","DEU","22","13‏","14","اگر مردی با دختری ازدواج کند و پس از همبستر شدن با او، وی را متهم کند که قبل از ازدواج با مرد دیگری روابط جنسی داشته است و بگوید: «وقتی با او ازدواج کردم باکره نبود.» ");
INSERT INTO pesopcb_vpl VALUES ("DT22_15","006_22_15","DEU","22","15","15","آنگاه پدر و مادر دختر باید مدرک بکارت او را نزد مشایخ به دروازۀ شهر بیاورند. ");
INSERT INTO pesopcb_vpl VALUES ("DT22_16","006_22_16","DEU","22","16","16","پدرش باید به آنها بگوید: «من دخترم را به این مرد دادم تا همسر او باشد، ولی این مرد او را نمی‌خواهد ");
INSERT INTO pesopcb_vpl VALUES ("DT22_17‏","006_22_17‏","DEU","22","17‏","18","و به او تهمت زده، ادعا می‌کند که دخترم هنگام ازدواج باکره نبوده است. اما این مدرک ثابت می‌کند که او باکره بوده است.» سپس باید پارچه را جلوی مشایخ پهن کنند. مشایخ باید آن مرد را شلّاق بزنند ");
INSERT INTO pesopcb_vpl VALUES ("DT22_19","006_22_19","DEU","22","19","19","و محکوم به پرداخت جریمه‌ای معادل صد مثقال نقره بکنند، چون به دروغ، یک باکرهٔ اسرائیلی را متهم کرده است. این جریمه باید به پدر دختر پرداخت شود. آن زن، همسر وی باقی خواهد ماند و مرد هرگز نباید او را طلاق بدهد. ");
INSERT INTO pesopcb_vpl VALUES ("DT22_20","006_22_20","DEU","22","20","20","ولی اگر اتهامات مرد حقیقت داشته و آن زن هنگام ازدواج باکره نبوده است، ");
INSERT INTO pesopcb_vpl VALUES ("DT22_21","006_22_21","DEU","22","21","21","مشایخ، دختر را به در خانهٔ پدرش ببرند و مردان شهر او را سنگسار کنند تا بمیرد، چون او در اسرائیل عمل قبیحی انجام داده است و در زمانی که در خانهٔ پدرش زندگی می‌کرده، زنا کرده است. چنین شرارتی باید از میان شما پاک گردد. ");
INSERT INTO pesopcb_vpl VALUES ("DT22_22","006_22_22","DEU","22","22","22","اگر مردی در حال ارتکاب زنا با زن شوهرداری دیده شود، هم آن مرد و هم آن زن باید کشته شوند. به این ترتیب، شرارت از اسرائیل پاک خواهد شد. ");
INSERT INTO pesopcb_vpl VALUES ("DT22_23","006_22_23","DEU","22","23","23","اگر مردی در شهری دختری را که نامزد دارد ببیند و با او همبستر شود ");
INSERT INTO pesopcb_vpl VALUES ("DT22_24","006_22_24","DEU","22","24","24","باید هم دختر و هم مرد را از دروازهٔ شهر بیرون برده، سنگسار کنند تا بمیرند. دختر را به سبب اینکه فریاد نزده و کمک نخواسته است و مرد را به جهت اینکه نامزد مرد دیگری را بی‌حرمت کرده است. چنین شرارتی باید از میان شما پاک شود. ");
INSERT INTO pesopcb_vpl VALUES ("DT22_25‏","006_22_25‏","DEU","22","25‏","27","ولی اگر چنین عملی خارج از شهر اتفاق بیفتد تنها مرد باید کشته شود، چون دختر گناهی که مستحق مرگ باشد مرتکب نشده است. این، مثل آن است که کسی بر شخصی حمله‌ور شده او را بکشد، زیرا دختر فریاد زده و چون در خارج از شهر بوده، کسی به کمکش نرفته است تا او را نجات دهد. ");
INSERT INTO pesopcb_vpl VALUES ("DT22_28‏","006_22_28‏","DEU","22","28‏","29","اگر مردی به دختری که نامزد نشده است تجاوز کند و در حین عمل غافلگیر شود، باید به پدر دختر پنجاه مثقال نقره بپردازد و با آن دختر ازدواج کند و هرگز نمی‌تواند او را طلاق بدهد. ");
INSERT INTO pesopcb_vpl VALUES ("DT22_30","006_22_30","DEU","22","30","30","هیچ‌کس نباید زن پدر خود را به زنی گرفته، به پدر خود بی‌حرمتی روا دارد. ");
INSERT INTO pesopcb_vpl VALUES ("DT23_1","006_23_1","DEU","23","1","1","مردی که بیضه‌هایش له شده و یا آلت تناسلی‌اش بریده شده باشد، نباید داخل جماعت خداوند شود. ");
INSERT INTO pesopcb_vpl VALUES ("DT23_2","006_23_2","DEU","23","2","2","شخص حرامزاده و فرزندان او تا ده نسل نباید وارد جماعت خداوند شوند. ");
INSERT INTO pesopcb_vpl VALUES ("DT23_3","006_23_3","DEU","23","3","3","از قوم عمونی یا موآبی هیچ‌کس وارد جماعت خداوند نشود حتی بعد از نسل دهم. ");
INSERT INTO pesopcb_vpl VALUES ("DT23_4","006_23_4","DEU","23","4","4","این دستور بدان سبب است که وقتی از مصر بیرون آمدید این قومها با نان و آب از شما استقبال نکردند و حتی بلعام، پسر بعور، اهل فتور را از بین‌النهرین اجیر کردند تا شما را لعنت کند. ");
INSERT INTO pesopcb_vpl VALUES ("DT23_5","006_23_5","DEU","23","5","5","ولی یهوه خدایتان به بلعام گوش نکرد و در عوض چون شما را دوست داشت آن لعنت را به برکت تبدیل نمود. ");
INSERT INTO pesopcb_vpl VALUES ("DT23_6","006_23_6","DEU","23","6","6","پس هرگز تا زمانی که زنده هستید نباید با عمونی‌ها و موآبی‌ها صلح کنید و با آنها رابطهٔ دوستی برقرار نمایید. ");
INSERT INTO pesopcb_vpl VALUES ("DT23_7","006_23_7","DEU","23","7","7","ولی ادومی‌ها را دشمن نشمارید، زیرا برادران شما هستند. مصری‌ها را نیز دشمن نشمارید، زیرا زمانی در میان ایشان زندگی می‌کردید. ");
INSERT INTO pesopcb_vpl VALUES ("DT23_8","006_23_8","DEU","23","8","8","نسل سوم ادومی‌ها و مصری‌ها می‌توانند به جماعت خداوند داخل شوند. ");
INSERT INTO pesopcb_vpl VALUES ("DT23_9‏","006_23_9‏","DEU","23","9‏","10","در زمان جنگ، مردانی که در اردوگاه هستند باید از هر نوع ناپاکی دوری کنند. کسی که به خاطر انزال شبانه، نجس می‌شود باید از اردوگاه خارج گردد ");
INSERT INTO pesopcb_vpl VALUES ("DT23_11","006_23_11","DEU","23","11","11","و تا غروب بیرون بماند. سپس خود را شسته، هنگام غروب بازگردد. ");
INSERT INTO pesopcb_vpl VALUES ("DT23_12","006_23_12","DEU","23","12","12","مستراحها باید بیرون اردوگاه باشند. ");
INSERT INTO pesopcb_vpl VALUES ("DT23_13","006_23_13","DEU","23","13","13","هر کس باید در بین ابزار خود وسیله‌ای برای کندن زمین داشته باشد و بعد از هر بار قضای حاجت، با آن گودالی حفر کند و مدفوعش را بپوشاند. ");
INSERT INTO pesopcb_vpl VALUES ("DT23_14","006_23_14","DEU","23","14","14","اردوگاه باید پاک باشد، چون خداوند در میان شما قدم می‌زند تا شما را محافظت فرماید و دشمنانتان را مغلوب شما سازد. اگر او چیز ناپسندی ببیند، ممکن است روی خود را از شما برگرداند. ");
INSERT INTO pesopcb_vpl VALUES ("DT23_15","006_23_15","DEU","23","15","15","اگر برده‌ای از نزد اربابش فرار کرده، به شما پناه آورد، نباید او را مجبور کنید که نزد اربابش برگردد. ");
INSERT INTO pesopcb_vpl VALUES ("DT23_16","006_23_16","DEU","23","16","16","بگذارید در هر شهری که مایل است در میان شما زندگی کند و بر او ظلم نکنید. ");
INSERT INTO pesopcb_vpl VALUES ("DT23_17","006_23_17","DEU","23","17","17","از دختران اسرائیلی کسی نباید در معبد بت‌پرستان روسپیگری کند، و از پسران اسرائیلی کسی نباید لوّاط شود. ");
INSERT INTO pesopcb_vpl VALUES ("DT23_18","006_23_18","DEU","23","18","18","هیچگونه هدیه‌ای را که از درآمد یک روسپی یا یک لواط تهیه شده باشد به خانهٔ خداوند نیاورید، چون هر دو در نظر یهوه خدایتان نفرت‌انگیز هستند. ");
INSERT INTO pesopcb_vpl VALUES ("DT23_19","006_23_19","DEU","23","19","19","وقتی به برادر اسرائیلی خود پول، غذا یا هر چیز دیگری قرض می‌دهید، از او بهره نگیرید. ");
INSERT INTO pesopcb_vpl VALUES ("DT23_20","006_23_20","DEU","23","20","20","از یک غریبه می‌توانید بهره بگیرید، ولی نه از یک اسرائیلی. اگر این قانون را رعایت کنید خداوند، خدایتان زمانی که وارد سرزمین موعود شوید به شما برکت خواهد داد. ");
INSERT INTO pesopcb_vpl VALUES ("DT23_21","006_23_21","DEU","23","21","21","هنگامی که برای خداوند نذر می‌کنید نباید در وفای آن تأخیر کنید، چون خداوند می‌خواهد نذرهای خود را به موقع ادا کنید. ادا نکردن نذر، گناه محسوب می‌شود. ");
INSERT INTO pesopcb_vpl VALUES ("DT23_22","006_23_22","DEU","23","22","22","(ولی اگر از نذر کردن خودداری کنید، گناهی انجام نداده‌اید.) ");
INSERT INTO pesopcb_vpl VALUES ("DT23_23","006_23_23","DEU","23","23","23","بعد از اینکه نذر کردید باید دقت کنید هر چه را که گفته‌اید ادا کنید، زیرا با میل خود به خداوند، خدایتان نذر کرده‌اید. ");
INSERT INTO pesopcb_vpl VALUES ("DT23_24","006_23_24","DEU","23","24","24","از انگورهای تاکستان دیگران، هر قدر که بخواهید می‌توانید بخورید، اما نباید انگور را در ظرف ریخته با خود ببرید. ");
INSERT INTO pesopcb_vpl VALUES ("DT23_25","006_23_25","DEU","23","25","25","همین‌طور وقتی داخل کشتزار همسایهٔ خود می‌شوید، می‌توانید با دست خود خوشه‌ها را بچینید و بخورید، ولی حق داس زدن ندارید. ");
INSERT INTO pesopcb_vpl VALUES ("DT24_1","006_24_1","DEU","24","1","1","اگر مردی پس از ازدواج با زنی، از او راضی نباشد، و طلاقنامه‌ای نوشته، به دستش دهد و او را رها سازد ");
INSERT INTO pesopcb_vpl VALUES ("DT24_2","006_24_2","DEU","24","2","2","و آن زن دوباره ازدواج کند ");
INSERT INTO pesopcb_vpl VALUES ("DT24_3","006_24_3","DEU","24","3","3","و شوهر دومی نیز از او راضی نباشد و او را طلاق دهد یا بمیرد، ");
INSERT INTO pesopcb_vpl VALUES ("DT24_4","006_24_4","DEU","24","4","4","آنگاه شوهر اولش نمی‌تواند دوباره با او ازدواج کند، زیرا آن زن نجس شده است. خداوند از چنین ازدواجی متنفر است و این عمل باعث می‌شود زمینی که خداوند، خدایتان به شما داده است به گناه آلوده شود. ");
INSERT INTO pesopcb_vpl VALUES ("DT24_5","006_24_5","DEU","24","5","5","مردی را که تازه ازدواج کرده است نباید به سربازی احضار نمود و یا مسئولیتهای بخصوص دیگری به وی محول کرد، بلکه مدت یک سال در خانهٔ خود آزاد بماند و زنش را خوشحال کند. ");
INSERT INTO pesopcb_vpl VALUES ("DT24_6","006_24_6","DEU","24","6","6","گرو گرفتن سنگ آسیاب خلاف قانون است، چون وسیلهٔ امرار معاش صاحبش می‌باشد. ");
INSERT INTO pesopcb_vpl VALUES ("DT24_7","006_24_7","DEU","24","7","7","اگر کسی یکی از برادران اسرائیلی خود را بدزدد و با او مثل برده رفتار کند و یا او را بفروشد، این آدم دزد باید کشته شود تا شرارت از میان شما پاک گردد. ");
INSERT INTO pesopcb_vpl VALUES ("DT24_8","006_24_8","DEU","24","8","8","هرگاه کسی به مرض جذام مبتلا شود، باید به دقت آنچه را که کاهنان لاوی به او می‌گویند انجام دهد؛ او باید از دستورهایی که من به کاهنان داده‌ام پیروی کند. ");
INSERT INTO pesopcb_vpl VALUES ("DT24_9","006_24_9","DEU","24","9","9","به خاطر بیاورید آنچه را که خداوند، هنگامی که از مصر بیرون می‌آمدید با مریم کرد. ");
INSERT INTO pesopcb_vpl VALUES ("DT24_10","006_24_10","DEU","24","10","10","اگر به کسی چیزی قرض می‌دهید نباید برای گرفتن گرو به خانه‌اش وارد شوید. ");
INSERT INTO pesopcb_vpl VALUES ("DT24_11","006_24_11","DEU","24","11","11","بیرون خانه بایستید تا صاحب خانه آن را برایتان بیاورد. ");
INSERT INTO pesopcb_vpl VALUES ("DT24_12‏","006_24_12‏","DEU","24","12‏","13","اگر آن مرد، فقیر بوده، ردایش را که در آن می‌خوابد به عنوان گرو به شما بدهد نباید تا روز بعد، پیش خود نگه دارید بلکه هنگام غروب آفتاب آن را به او بازگردانید تا بتواند شب در آن بخوابد. آنگاه او برای شما دعای خیر خواهد کرد و خداوند، خدایتان از شما راضی خواهد بود. ");
INSERT INTO pesopcb_vpl VALUES ("DT24_14‏","006_24_14‏","DEU","24","14‏","15","هرگز به یک کارگر روزمزد فقیر و محتاج ظلم نکنید، چه اسرائیلی باشد و چه غریبی که در شهر شما زندگی می‌کند. مزدش را هر روز قبل از غروب آفتاب به وی پرداخت کنید، چون او فقیر است و چشم امیدش به آن مزد است. اگر چنین نکنید، ممکن است نزد خداوند از دست شما ناله کند و این برای شما گناه محسوب شود. ");
INSERT INTO pesopcb_vpl VALUES ("DT24_16","006_24_16","DEU","24","16","16","پدران نباید به سبب گناهان پسرانشان کشته شوند، و نه پسران به سبب گناهان پدرانشان. هر کس باید به سبب گناه خودش کشته شود. ");
INSERT INTO pesopcb_vpl VALUES ("DT24_17","006_24_17","DEU","24","17","17","با غریبان و یتیمان به عدالت رفتار کنید و هرگز لباس بیوه‌زنی را در مقابل قرضی که به او داده‌اید گرو نگیرید. ");
INSERT INTO pesopcb_vpl VALUES ("DT24_18","006_24_18","DEU","24","18","18","همیشه به یاد داشته باشید که در مصر برده بودید و خداوند، خدایتان شما را نجات داد. به همین دلیل است که من این دستور را به شما می‌دهم. ");
INSERT INTO pesopcb_vpl VALUES ("DT24_19","006_24_19","DEU","24","19","19","اگر هنگام درو کردن محصول فراموش کردید یکی از بافه‌ها را از مزرعه بیاورید، برای برداشتن آن به مزرعه باز نگردید. آن را برای غریبان، یتیمان و بیوه‌زنان بگذارید تا خداوند، خدایتان دسترنج شما را برکت دهد. ");
INSERT INTO pesopcb_vpl VALUES ("DT24_20","006_24_20","DEU","24","20","20","وقتی که محصول زیتون خود را از درخت می‌تکانید شاخه‌ها را برای بار دوم تکان ندهید، بلکه باقیمانده را برای غریبان، یتیمان و بیوه‌زنان بگذارید. ");
INSERT INTO pesopcb_vpl VALUES ("DT24_21","006_24_21","DEU","24","21","21","در مورد انگور تاکستانتان نیز چنین عمل کنید. دوباره سراغ تاکی که انگورهایش را چیده‌اید نروید، بلکه آنچه را که از انگورها باقی مانده است برای نیازمندان بگذارید. ");
INSERT INTO pesopcb_vpl VALUES ("DT24_22","006_24_22","DEU","24","22","22","یادتان باشد که در سرزمین مصر برده بودید. به همین سبب است که من این دستور را به شما می‌دهم. ");
INSERT INTO pesopcb_vpl VALUES ("DT25_1‏","006_25_1‏","DEU","25","1‏","3","هرگاه بین دو نفر نزاعی درگیرد و آنها به دادگاه بروند، دادگاه باید مجرم را محکوم نماید و بی‌گناه را تبرئه کند. اگر مجرم مستحق شلّاق خوردن باشد باید قاضی به او دستور دهد که دراز بکشد و در حضور خودش به نسبت جرمی که انجام داده تا چهل ضربه شلّاقش بزنند؛ ولی نباید بیش از چهل ضربه شلّاق بزنید مبادا برادرتان در نظر شما خوار گردد. ");
INSERT INTO pesopcb_vpl VALUES ("DT25_4","006_25_4","DEU","25","4","4","دهان گاوی را که خرمن می‌کوبد، نبند و بگذار به هنگام کار، از خرمنت بخورد. ");
INSERT INTO pesopcb_vpl VALUES ("DT25_5","006_25_5","DEU","25","5","5","هرگاه دو برادر با هم در یک جا ساکن باشند و یکی از آنها بدون داشتن پسری بمیرد، بیوه‌اش نباید با فردی خارج از خانواده ازدواج کند، بلکه برادر شوهرش باید او را به زنی بگیرد و حق برادر شوهری را به جا آورد. ");
INSERT INTO pesopcb_vpl VALUES ("DT25_6","006_25_6","DEU","25","6","6","نخستین پسری که از این ازدواج به دنیا بیاید باید به عنوان پسر برادر فوت شده محسوب گردد تا اسم آن متوفی از اسرائیل فراموش نشود، ");
INSERT INTO pesopcb_vpl VALUES ("DT25_7","006_25_7","DEU","25","7","7","ولی اگر برادر متوفی راضی به این ازدواج نباشد، آنگاه آن زن باید به دروازۀ شهر نزد مشایخ برود و به آنها بگوید: «برادر شوهرم وظیفه‌اش را نسبت به من انجام نمی‌دهد و نمی‌گذارد نام برادرش در اسرائیل باقی بماند.» ");
INSERT INTO pesopcb_vpl VALUES ("DT25_8","006_25_8","DEU","25","8","8","سپس مشایخ شهر آن مرد را احضار کرده، با او صحبت کنند. اگر او باز راضی به ازدواج نشد، ");
INSERT INTO pesopcb_vpl VALUES ("DT25_9","006_25_9","DEU","25","9","9","زن بیوه باید در حضور مشایخ به طرف آن مرد رفته، کفش او را از پایش درآورد و آب دهان بر صورتش بیفکند و بگوید: «بر مردی که اجاق خانهٔ برادرش را روشن نگه نمی‌دارد اینچنین شود.» ");
INSERT INTO pesopcb_vpl VALUES ("DT25_10","006_25_10","DEU","25","10","10","و از آن پس، خاندان آن مرد در اسرائیل به «خاندان کفش کنده» شناخته خواهد شد. ");
INSERT INTO pesopcb_vpl VALUES ("DT25_11","006_25_11","DEU","25","11","11","اگر دو مرد با هم نزاع کنند و همسر یکی از آنها برای کمک به شوهرش مداخله نموده، عورت مرد دیگر را بگیرد، ");
INSERT INTO pesopcb_vpl VALUES ("DT25_12","006_25_12","DEU","25","12","12","دست آن زن را باید بدون ترحم قطع کرد. ");
INSERT INTO pesopcb_vpl VALUES ("DT25_13‏","006_25_13‏","DEU","25","13‏","15","در کلیهٔ معاملات خود باید از ترازوهای دقیق و اندازه‌های درست استفاده کنید تا در سرزمینی که خداوند، خدایتان به شما می‌دهد زندگی طولانی داشته باشید. ");
INSERT INTO pesopcb_vpl VALUES ("DT25_16","006_25_16","DEU","25","16","16","تمام کسانی که در معاملات کلاهبرداری می‌کنند مورد نفرت خداوند می‌باشند. ");
INSERT INTO pesopcb_vpl VALUES ("DT25_17","006_25_17","DEU","25","17","17","هرگز نباید کاری را که مردم عمالیق هنگام بیرون آمدن از مصر با شما کردند فراموش کنید. ");
INSERT INTO pesopcb_vpl VALUES ("DT25_18","006_25_18","DEU","25","18","18","به یاد داشته باشید که ایشان بدون ترس از خدا با شما جنگیده، کسانی را که در اثر ضعف و خستگی عقب مانده بودند به هلاکت رسانیدند. ");
INSERT INTO pesopcb_vpl VALUES ("DT25_19","006_25_19","DEU","25","19","19","بنابراین وقتی که خداوند، خدایتان در سرزمین موعود شما را از شر تمامی دشمنانتان خلاصی بخشید، باید نام عمالیق را از روی زمین محو و نابود کنید. هرگز این را فراموش نکنید. ");
INSERT INTO pesopcb_vpl VALUES ("DT26_1","006_26_1","DEU","26","1","1","پس از اینکه وارد سرزمینی شدید که یهوه خدایتان به شما به ملکیت می‌بخشد، و آن را تصرف کرده، در آن سکونت گزیدید، ");
INSERT INTO pesopcb_vpl VALUES ("DT26_2‏","006_26_2‏","DEU","26","2‏","3","باید نوبر برداشت محصول زمین خود را به مکانی که یهوه خدایتان به عنوان عبادتگاه خود برمی‌گزیند بیاورید و به یهوه خدایتان تقدیم کنید. آن را در سبد گذاشته، به کاهنی که در آن روزها خدمت می‌کند، بدهید و بگویید: «من اقرار می‌کنم که خداوند، خدایم مرا به سرزمینی که با سوگند به پدران ما وعده نمود، آورده است.» ");
INSERT INTO pesopcb_vpl VALUES ("DT26_4","006_26_4","DEU","26","4","4","سپس کاهن سبد را از دست شما گرفته، آن را جلوی مذبح خداوند، خدایتان بگذارد. ");
INSERT INTO pesopcb_vpl VALUES ("DT26_5","006_26_5","DEU","26","5","5","بعد شما در حضور خداوند، خدایتان اقرار کرده، بگویید: «جَدّ من اَرامی سرگردانی بود که با تعدادی کم به مصر رفت و در آنجا در غربت زندگی کرد، ولی در آنجا خاندان او به قومی بزرگ تبدیل شد. ");
INSERT INTO pesopcb_vpl VALUES ("DT26_6","006_26_6","DEU","26","6","6","مصری‌ها با ما بدرفتاری کردند و ما را بردهٔ خود ساختند. ");
INSERT INTO pesopcb_vpl VALUES ("DT26_7","006_26_7","DEU","26","7","7","ما نزد خداوند، خدای پدرانمان فریاد برآوردیم و خداوند صدای ما را شنیده، زحمت و مشقت و مشکلاتمان را دید ");
INSERT INTO pesopcb_vpl VALUES ("DT26_8","006_26_8","DEU","26","8","8","و ما را با قدرت عظیم خود از مصر بیرون آورد. او در حضور مصری‌ها معجزاتی بزرگ انجام داده، آنها را به وحشت انداخت ");
INSERT INTO pesopcb_vpl VALUES ("DT26_9","006_26_9","DEU","26","9","9","و ما را به سرزمین حاصلخیزی که در آن شیر و عسل جاری است آورد. ");
INSERT INTO pesopcb_vpl VALUES ("DT26_10","006_26_10","DEU","26","10","10","اکنون ای خداوند، نگاه کن، من نمونه‌ای از نوبر اولین محصولات زمینی را که به من عطا کرده‌ای برایت آورده‌ام.» سپس نمونه را در حضور خداوند، خدای خود گذاشته، او را پرستش کنید. ");
INSERT INTO pesopcb_vpl VALUES ("DT26_11","006_26_11","DEU","26","11","11","آنگاه بروید و به سبب تمام نعمتهایی که یهوه خدایتان به شما عطا کرده است او را شکر کنید و با خانوادهٔ خود و با لاویان و غریبانی که در میان شما زندگی می‌کنند، شادی نمایید. ");
INSERT INTO pesopcb_vpl VALUES ("DT26_12","006_26_12","DEU","26","12","12","هر سه سال یک بار، سال مخصوص ده‌یک است. در آن سال باید تمام ده‌یک‌های محصول خود را به لاویان، غریبان، یتیمان و بیوه‌زنان شهرتان بدهید تا بخورند و سیر شوند. ");
INSERT INTO pesopcb_vpl VALUES ("DT26_13","006_26_13","DEU","26","13","13","سپس در حضور خداوند، خدایتان اعلام کنید: «ای خداوند، همان‌گونه که امر فرمودی تمام ده‌یک‌هایم را به لاویان، غریبان، یتیمان و بیوه‌زنان داده‌ام و از هیچ‌کدام از قوانین تو سرپیچی ننموده آنها را فراموش نکرده‌ام. ");
INSERT INTO pesopcb_vpl VALUES ("DT26_14‏","006_26_14‏","DEU","26","14‏","15","زمانی که نجس بودم و وقتی که عزادار بودم، دست به ده‌یک نزده‌ام و چیزی از آن را برای مردگان هدیه نکرده‌ام. از تو اطاعت کرده‌ام و تمام احکام تو را بجا آورده‌ام. ای خداوند، از آسمان که جایگاه مقدّس توست نظر انداخته، قوم خود اسرائیل را برکت بده. این سرزمین حاصلخیز را نیز که برای اجداد ما سوگند خوردی که به ما بدهی، برکت عطا فرما.» ");
INSERT INTO pesopcb_vpl VALUES ("DT26_16","006_26_16","DEU","26","16","16","امروز یهوه خدایتان امر می‌فرماید که تمام فرایض و قوانین او را اطاعت کنید؛ پس شما با تمامی دل و جان آنها را بجا آورید. ");
INSERT INTO pesopcb_vpl VALUES ("DT26_17","006_26_17","DEU","26","17","17","امروز اعلام کرده‌اید که یهوه خدای شماست و قول داده‌اید از او پیروی نموده، فرایض و فرامین و قوانین او را به جا آورید. ");
INSERT INTO pesopcb_vpl VALUES ("DT26_18","006_26_18","DEU","26","18","18","خداوند امروز طبق وعده‌اش اعلام فرموده است که شما قوم خاص او هستید و باید تمامی فرمانهای او را اطاعت کنید. ");
INSERT INTO pesopcb_vpl VALUES ("DT26_19","006_26_19","DEU","26","19","19","اگر چنین کنید او شما را از همهٔ قومهای دیگر بزرگتر ساخته، اجازه خواهد داد عزت، احترام و شهرت بیابید؛ اما برای کسب این عزت و احترام باید قومی مقدّس برای یهوه خدای خود باشید. ");
INSERT INTO pesopcb_vpl VALUES ("DT27_1","006_27_1","DEU","27","1","1","آنگاه موسی و مشایخ اسرائیل، این دستورها را نیز به قوم دادند و از آنها خواستند تا آنها را به جا آورند: ");
INSERT INTO pesopcb_vpl VALUES ("DT27_2‏","006_27_2‏","DEU","27","2‏","4","«وقتی که از رود اردن عبور کردید و به سرزمین موعود یعنی به سرزمینی که شیر و عسل در آن جاری است رسیدید، سنگهای بزرگی از کف رودخانه بیرون آورید و آنها را به صورت بنای یادبودی در آن طرف رودخانه بر کوه عیبال بر روی یکدیگر قرار دهید. روی سنگها را با گچ بپوشانید و سپس قوانین خداوند را بر آن بنویسید. ");
INSERT INTO pesopcb_vpl VALUES ("DT27_5‏","006_27_5‏","DEU","27","5‏","6","در آنجا یک مذبح با سنگهای نتراشیده که ابزار آهنی بر آنها نخورده باشد برای خداوند، خدایتان بسازید و قربانیهای سوختنی برای خداوند، خدایتان بر آن تقدیم کنید. ");
INSERT INTO pesopcb_vpl VALUES ("DT27_7","006_27_7","DEU","27","7","7","قربانیهای سلامتی را نیز بر روی آن ذبح کرده، بخورید و در همان جا در حضور خداوند، خدایتان شادی کنید. ");
INSERT INTO pesopcb_vpl VALUES ("DT27_8","006_27_8","DEU","27","8","8","همۀ این قوانین را با خط خوانا روی بنای یادبود بنویسید.» ");
INSERT INTO pesopcb_vpl VALUES ("DT27_9","006_27_9","DEU","27","9","9","آنگاه موسی به همراهی کاهنان لاوی به تمامی قوم اسرائیل گفت: «ای اسرائیل خاموش باش و بشنو! امروز تو قوم خداوند، خدایت شده‌ای. ");
INSERT INTO pesopcb_vpl VALUES ("DT27_10","006_27_10","DEU","27","10","10","بنابراین باید از یهوه خدای خود پیروی نمایی و فرمانها و فرایض او را که امروز به تو می‌دهم اطاعت کنی.» ");
INSERT INTO pesopcb_vpl VALUES ("DT27_11","006_27_11","DEU","27","11","11","در همان روز موسی این دستور را به قوم اسرائیل داد: ");
INSERT INTO pesopcb_vpl VALUES ("DT27_12","006_27_12","DEU","27","12","12","پس از عبور از رود اردن، قبایل شمعون، لاوی، یهودا، یساکار، یوسف و بنیامین باید بر روی کوه جَرِزیم بایستند و قوم را برکت دهند. ");
INSERT INTO pesopcb_vpl VALUES ("DT27_13","006_27_13","DEU","27","13","13","و قبایل رئوبین، جاد، اشیر، زبولون، دان و نفتالی باید بر کوه عیبال بایستند و لعنتها را اعلام کنند. ");
INSERT INTO pesopcb_vpl VALUES ("DT27_14","006_27_14","DEU","27","14","14","آنگاه لاویان که در بین آنها ایستاده‌اند با صدای بلند به تمام بنی‌اسرائیل بگویند: ");
INSERT INTO pesopcb_vpl VALUES ("DT27_15","006_27_15","DEU","27","15","15","«لعنت خدا بر کسی که بُتی از سنگ، چوب یا فلز بسازد و مخفیانه آن را پرستش کند، زیرا خداوند از بت‌پرستی متنفر است.» و تمامی قوم بگویند: «آمین.» ");
INSERT INTO pesopcb_vpl VALUES ("DT27_16","006_27_16","DEU","27","16","16","«لعنت خدا بر کسی که نسبت به پدر و مادرش بی‌احترامی کند.» و تمامی قوم بگویند: «آمین.» ");
INSERT INTO pesopcb_vpl VALUES ("DT27_17","006_27_17","DEU","27","17","17","«لعنت خدا بر کسی که مرز بین زمین خودش و همسایه‌اش را تغییر دهد.» و تمامی قوم بگویند: «آمین.» ");
INSERT INTO pesopcb_vpl VALUES ("DT27_18","006_27_18","DEU","27","18","18","«لعنت خدا بر کسی که نابینا را از راه، منحرف کند.» و تمامی قوم بگویند: «آمین.» ");
INSERT INTO pesopcb_vpl VALUES ("DT27_19","006_27_19","DEU","27","19","19","«لعنت خدا بر کسی که نسبت به غریبان، یتیمان و بیوه‌زنان بی‌عدالتی نماید.» و تمامی قوم بگویند: «آمین.» ");
INSERT INTO pesopcb_vpl VALUES ("DT27_20","006_27_20","DEU","27","20","20","«لعنت خدا بر کسی که با زن پدرش همبستر شود، چون آن زن به پدرش تعلق دارد.» و تمامی قوم بگویند: «آمین.» ");
INSERT INTO pesopcb_vpl VALUES ("DT27_21","006_27_21","DEU","27","21","21","«لعنت خدا بر کسی که با حیوانی رابطهٔ جنسی برقرار کند.» و تمامی قوم بگویند: «آمین.» ");
INSERT INTO pesopcb_vpl VALUES ("DT27_22","006_27_22","DEU","27","22","22","«لعنت خدا بر کسی که با خواهر خود، چه تنی و چه ناتنی، همبستر شود.» و تمامی قوم بگویند: «آمین.» ");
INSERT INTO pesopcb_vpl VALUES ("DT27_23","006_27_23","DEU","27","23","23","«لعنت خدا بر کسی که با مادر زن خود همبستر شود.» و تمامی قوم بگویند: «آمین.» ");
INSERT INTO pesopcb_vpl VALUES ("DT27_24","006_27_24","DEU","27","24","24","«لعنت خدا بر کسی که همسایۀ خود را مخفیانه بکشد.» و تمامی قوم بگویند: «آمین.» ");
INSERT INTO pesopcb_vpl VALUES ("DT27_25","006_27_25","DEU","27","25","25","«لعنت خدا بر کسی که رشوه بگیرد تا فرد بی‌گناهی را به قتل برساند.» و تمامی قوم بگویند: «آمین.» ");
INSERT INTO pesopcb_vpl VALUES ("DT27_26","006_27_26","DEU","27","26","26","«لعنت خدا بر کسی که کلمات این شریعت را نپذیرد و به جا نیاورد.» و تمامی قوم بگویند: «آمین.» ");
INSERT INTO pesopcb_vpl VALUES ("DT28_1","006_28_1","DEU","28","1","1","اگر تمام فرمانهای یهوه خدایتان را که امروز به شما می‌دهم به دقت اطاعت کنید، یهوه خدایتان شما را بر همۀ قومهای جهان برتری خواهد بخشید ");
INSERT INTO pesopcb_vpl VALUES ("DT28_2","006_28_2","DEU","28","2","2","و این برکات نصیبتان خواهد شد و بر شما خواهد ماند: ");
INSERT INTO pesopcb_vpl VALUES ("DT28_3","006_28_3","DEU","28","3","3","در شهر و مزرعه‌تان مبارک خواهید بود. ");
INSERT INTO pesopcb_vpl VALUES ("DT28_4","006_28_4","DEU","28","4","4","فرزندان و محصولتان را برکت خواهد داد. گله و رمه شما را برکت خواهد داد. ");
INSERT INTO pesopcb_vpl VALUES ("DT28_5","006_28_5","DEU","28","5","5","میوه و نانتان را برکت خواهد داد. ");
INSERT INTO pesopcb_vpl VALUES ("DT28_6","006_28_6","DEU","28","6","6","به هر کجا که بروید و از هر کجا که بیرون بیایید مبارک خواهید بود. ");
INSERT INTO pesopcb_vpl VALUES ("DT28_7","006_28_7","DEU","28","7","7","خداوند، دشمنانتان را در مقابل شما شکست خواهد داد. آنها از یک سو علیه شما بیرون خواهند آمد، ولی در برابر شما به هفت سو پراکنده خواهند شد. ");
INSERT INTO pesopcb_vpl VALUES ("DT28_8","006_28_8","DEU","28","8","8","خداوند حاصل دسترنج شما را برکت خواهد داد و انبارهایتان را از غله پر خواهد ساخت. او شما را در سرزمینی که به شما می‌دهد برکت خواهد داد. ");
INSERT INTO pesopcb_vpl VALUES ("DT28_9","006_28_9","DEU","28","9","9","اگر فرمانهای یهوه خدای خود را اطاعت کنید و در راه او گام بردارید، او نیز چنانکه برایتان سوگند خورده، شما را قوم مقدّس خود خواهد ساخت. ");
INSERT INTO pesopcb_vpl VALUES ("DT28_10","006_28_10","DEU","28","10","10","آنگاه تمامی مردم جهان خواهند دید که شما قوم خاص خداوند هستید و از شما خواهند ترسید. ");
INSERT INTO pesopcb_vpl VALUES ("DT28_11","006_28_11","DEU","28","11","11","خداوند در سرزمینی که برای اجدادتان سوگند خورد که به شما بدهد، نعمتهای فراوان به شما خواهد بخشید یعنی فرزندان بسیار، گله‌های زیاد و محصول فراوان. ");
INSERT INTO pesopcb_vpl VALUES ("DT28_12","006_28_12","DEU","28","12","12","او روزنه‌های آسمان را گشوده، باران را به موقع خواهد فرستاد و شما را در همهٔ کارهایتان برکت خواهد داد. به قومهای زیادی قرض خواهید داد، ولی از آنان قرض نخواهید گرفت. ");
INSERT INTO pesopcb_vpl VALUES ("DT28_13","006_28_13","DEU","28","13","13","چنانچه فقط گوش فرا داده، فرمانهای یهوه خدایتان را که امروز به شما می‌دهم اطاعت کنید، او شما را برتر از دیگران خواهد ساخت. ");
INSERT INTO pesopcb_vpl VALUES ("DT28_14","006_28_14","DEU","28","14","14","پس مواظب باشید که از دستورهایی که به شما داده‌ام به هیچ وجه سرپیچی نکنید و هرگز خدایان دیگر را عبادت و پیروی ننمایید. ");
INSERT INTO pesopcb_vpl VALUES ("DT28_15","006_28_15","DEU","28","15","15","اگر به یهوه خدایتان گوش ندهید و فرمانها و فرایضی را که امروز به شما می‌دهم اطاعت نکنید، آنگاه تمام این لعنتها بر سر شما خواهد آمد: ");
INSERT INTO pesopcb_vpl VALUES ("DT28_16","006_28_16","DEU","28","16","16","شهر و مزرعه‌تان لعنت خواهد شد. ");
INSERT INTO pesopcb_vpl VALUES ("DT28_17","006_28_17","DEU","28","17","17","سبد نان و ظرف خمیرتان لعنت خواهد شد. ");
INSERT INTO pesopcb_vpl VALUES ("DT28_18","006_28_18","DEU","28","18","18","فرزندان و محصول زمینتان لعنت خواهد شد. گله و رمه شما لعنت خواهد شد. ");
INSERT INTO pesopcb_vpl VALUES ("DT28_19","006_28_19","DEU","28","19","19","هر کجا که بروید و از هر کجا که بیایید، زیر لعنت خواهید بود. ");
INSERT INTO pesopcb_vpl VALUES ("DT28_20","006_28_20","DEU","28","20","20","اگر شرارت ورزیده، خدا را ترک کنید، خداوند نیز در همهٔ کارهایتان شما را به مصیبت و اضطراب و ناکامی دچار خواهد کرد تا به کلی از میان بروید. ");
INSERT INTO pesopcb_vpl VALUES ("DT28_21","006_28_21","DEU","28","21","21","آنقدر بیماری در بین شما خواهد فرستاد تا از روی زمینی که به‌زودی آن را تصرف می‌کنید محو و نابود شوید. ");
INSERT INTO pesopcb_vpl VALUES ("DT28_22","006_28_22","DEU","28","22","22","او شما را گرفتار بیماریهای مهلک و تب و التهاب خواهد کرد و خشکسالی و باد سوزان خواهد فرستاد تا محصولتان را از بین ببرند. تمامی این بلاها آنقدر شما را دنبال خواهند کرد تا نابود شوید. ");
INSERT INTO pesopcb_vpl VALUES ("DT28_23","006_28_23","DEU","28","23","23","آسمان بالای سرتان به مفرغ تبدیل خواهد شد و نخواهد بارید و زمینِ زیر پایتان چون آهن، خشک خواهد بود. ");
INSERT INTO pesopcb_vpl VALUES ("DT28_24","006_28_24","DEU","28","24","24","عوض باران، خداوند طوفان خاک و شن خواهد فرستاد و شما را هلاک خواهد کرد. ");
INSERT INTO pesopcb_vpl VALUES ("DT28_25","006_28_25","DEU","28","25","25","خداوند شما را در مقابل دشمنانتان شکست خواهد داد. از یک سو علیه آنها بیرون خواهید آمد، ولی در برابرشان به هفت سو پراکنده خواهید شد و همهٔ قومهای روی زمین با دیدن وضع اسفناک شما هراسان خواهند گردید. ");
INSERT INTO pesopcb_vpl VALUES ("DT28_26","006_28_26","DEU","28","26","26","لاشه‌هایتان خوراک پرندگان و حیوانات وحشی خواهد شد و کسی نخواهد بود که آنها را براند. ");
INSERT INTO pesopcb_vpl VALUES ("DT28_27","006_28_27","DEU","28","27","27","خداوند همان دملی را که بر مصری‌ها آورد بر شما خواهد فرستاد. او بدنهای شما را به زخمهای گوناگون مبتلا خواهد کرد تا خود را بخارانید و علاجی نداشته باشید. ");
INSERT INTO pesopcb_vpl VALUES ("DT28_28","006_28_28","DEU","28","28","28","خداوند شما را به دیوانگی، کوری و پریشانیِ فکر دچار خواهد کرد. ");
INSERT INTO pesopcb_vpl VALUES ("DT28_29","006_28_29","DEU","28","29","29","در روشنایی آفتاب مثل نابینایی که در تاریکی به سختی راه خود را پیدا می‌کند، کورکورانه راه خواهید رفت. در هیچ کاری موفق نخواهید بود. دائم مورد ظلم دیگران واقع شده، اموالتان چپاول خواهد گردید. هیچ‌کس به دادتان نخواهد رسید. ");
INSERT INTO pesopcb_vpl VALUES ("DT28_30","006_28_30","DEU","28","30","30","شخص دیگری با نامزدتان ازدواج خواهد کرد و در خانه‌ای که بنا می‌کنید کس دیگری زندگی خواهد کرد. میوهٔ تاکستانی را که غرس کرده‌اید دیگران خواهند خورد ");
INSERT INTO pesopcb_vpl VALUES ("DT28_31","006_28_31","DEU","28","31","31","و گاوهایتان را در برابر چشمانتان سر خواهند برید، ولی حتی یک تکه از گوشت آنها را نخواهید خورد. الاغهایتان را پیش روی شما به غارت خواهند برد. گوسفندانتان به دشمنانتان داده خواهند شد و کسی نخواهد بود که به داد شما برسد. ");
INSERT INTO pesopcb_vpl VALUES ("DT28_32","006_28_32","DEU","28","32","32","پسران و دخترانتان را در برابر چشمانتان به بردگی خواهند برد و دلهایتان در اشتیاق دیدن آنها خون خواهد شد، ولی کاری از دستتان برنخواهد آمد. ");
INSERT INTO pesopcb_vpl VALUES ("DT28_33","006_28_33","DEU","28","33","33","قومی بیگانه که حتی اسمش را هم نشنیده‌اید محصولی را که با هزار زحمت کاشته‌اید، خواهند خورد. همیشه زیر ظلم و ستم خواهید بود. ");
INSERT INTO pesopcb_vpl VALUES ("DT28_34","006_28_34","DEU","28","34","34","با دیدن وضع ناگوار اطراف خود دیوانه خواهید شد. ");
INSERT INTO pesopcb_vpl VALUES ("DT28_35","006_28_35","DEU","28","35","35","خداوند زانوان و ساق پاهای شما را به دُمَلهای دردناک که از آن شفا نتوانید یافت دچار خواهد ساخت که از کف پا تا فرق سر شما را خواهد گرفت. ");
INSERT INTO pesopcb_vpl VALUES ("DT28_36","006_28_36","DEU","28","36","36","خداوند، شما و پادشاهی را که بر می‌گزینید نزد قومی که نه شما و نه اجدادتان می‌شناختید تبعید خواهد کرد. در آنجا خدایان چوبی و سنگی را پرستش خواهید نمود. ");
INSERT INTO pesopcb_vpl VALUES ("DT28_37","006_28_37","DEU","28","37","37","خداوند، شما را در میان قومها پراکنده خواهد ساخت و مردم با دیدن وضعتان هراسان خواهند شد و شما در میان قومها رسوا و انگشت‌نما خواهید بود. ");
INSERT INTO pesopcb_vpl VALUES ("DT28_38","006_28_38","DEU","28","38","38","بسیار خواهید کاشت، ولی اندک خواهید دروید، چون ملخها محصولاتتان را خواهند خورد. ");
INSERT INTO pesopcb_vpl VALUES ("DT28_39","006_28_39","DEU","28","39","39","تاکستانها غرس کرده، از آنها مراقبت خواهید نمود، ولی از انگور آنها نخواهید خورد و از شراب آنها نخواهید نوشید، زیرا کرم، درختان را از بین خواهد برد. ");
INSERT INTO pesopcb_vpl VALUES ("DT28_40","006_28_40","DEU","28","40","40","در همه جا درختان زیتون خواهند رویید، ولی از آنها روغنی به دست نخواهید آورد، چون میوه‌شان قبل از رسیدن خواهد ریخت. ");
INSERT INTO pesopcb_vpl VALUES ("DT28_41","006_28_41","DEU","28","41","41","پسران و دختران خواهید داشت، اما آنها را از دست شما خواهند ربود و به اسارت خواهند برد. ");
INSERT INTO pesopcb_vpl VALUES ("DT28_42","006_28_42","DEU","28","42","42","ملخها، درختان و محصولات شما را نابود خواهند کرد. ");
INSERT INTO pesopcb_vpl VALUES ("DT28_43","006_28_43","DEU","28","43","43","غریبانی که در میان شما زندگی می‌کنند بالاتر و بالاتر از شما خواهند رفت و شما پایین‌تر و پایین‌تر. ");
INSERT INTO pesopcb_vpl VALUES ("DT28_44","006_28_44","DEU","28","44","44","آنها به شما قرض خواهند داد، نه شما به آنها. ایشان ارباب خواهند شد و شما نوکر. ");
INSERT INTO pesopcb_vpl VALUES ("DT28_45","006_28_45","DEU","28","45","45","تمامی این لعنتها بر سرتان خواهند آمد تا نابود شوید، زیرا نخواستید از خداوند، خدایتان اطاعت کنید و از دستورهایش پیروی نمایید. ");
INSERT INTO pesopcb_vpl VALUES ("DT28_46","006_28_46","DEU","28","46","46","همهٔ این بلاها که دامنگیر شما و فرزندانتان می‌شود، درس عبرتی برای دیگران خواهد بود. ");
INSERT INTO pesopcb_vpl VALUES ("DT28_47","006_28_47","DEU","28","47","47","چون در زمان فراوانی، یهوه خدایتان را با شادی و خوشی خدمت نکردید، ");
INSERT INTO pesopcb_vpl VALUES ("DT28_48","006_28_48","DEU","28","48","48","پس او دشمنانتان را بر شما مسلط خواهد کرد تا در گرسنگی و تشنگی، برهنگی و بیچارگی، آنها را بندگی نمایید. یوغی آهنین بر گردن شما خواهد بود تا وقتی که نابود شوید. ");
INSERT INTO pesopcb_vpl VALUES ("DT28_49","006_28_49","DEU","28","49","49","خداوند قومی را از دور دستها به سراغتان خواهد فرستاد، قومی که زبانشان را نمی‌فهمید. ایشان مثل عقاب بر شما فرود خواهند آمد. ");
INSERT INTO pesopcb_vpl VALUES ("DT28_50","006_28_50","DEU","28","50","50","این قوم درنده‌خو، نه به پیران شما رحم خواهند کرد و نه به جوانانتان. ");
INSERT INTO pesopcb_vpl VALUES ("DT28_51","006_28_51","DEU","28","51","51","آنها گله و محصولتان را خواهند خورد و شما از گرسنگی خواهید مرد. نه غله‌ای برای شما باقی خواهد ماند، نه شراب تازه‌ای و نه روغن زیتونی، نه گوساله‌ای و نه بره‌ای. ");
INSERT INTO pesopcb_vpl VALUES ("DT28_52","006_28_52","DEU","28","52","52","تمام شهرهایتان را که یهوه خدایتان به شما داده است محاصره خواهند کرد و دیوارهای محکم و بلند آنها را فرو خواهند ریخت، همان دیوارهایی که فکر می‌کردید از شما حفاظت خواهند کرد. ");
INSERT INTO pesopcb_vpl VALUES ("DT28_53","006_28_53","DEU","28","53","53","به سبب محاصره دشمن و تنگی، گوشت پسران و دختران خود را که یهوه خدایتان به شما داده است، خواهید خورد. ");
INSERT INTO pesopcb_vpl VALUES ("DT28_54","006_28_54","DEU","28","54","54","نجیب‌ترین و دلسوزترین مرد، حتی به برادر خود و زن محبوب خویش و بچه‌هایش که هنوز زنده هستند ترحم نخواهد کرد، ");
INSERT INTO pesopcb_vpl VALUES ("DT28_55","006_28_55","DEU","28","55","55","و از دادن قطعه‌ای از گوشتی که می‌خورد یعنی گوشت فرزندانش به آنها امتناع خواهد کرد، چون به سبب محاصرهٔ شهر چیزی برای خوردن ندارد. ");
INSERT INTO pesopcb_vpl VALUES ("DT28_56‏","006_28_56‏","DEU","28","56‏","57","ظریفترین و لطیفترین زن که رغبت نمی‌کرد حتی نوک پایش را به زمین بگذارد، حاضر نخواهد بود از آنچه می‌خورد به شوهر و فرزندان محبوبش بدهد. جفت نوزاد و کودکی را که تازه به دنیا آورده، از ایشان مخفی خواهد ساخت تا خودش به تنهایی آنها را بخورد. چنین خواهد بود وحشت گرسنگی و پریشانی در زمانی که دشمنان، شما را محاصره کنند. ");
INSERT INTO pesopcb_vpl VALUES ("DT28_58‏","006_28_58‏","DEU","28","58‏","59","اگر از اطاعت همۀ قوانینی که در این کتاب نوشته شده سرپیچی کنید و از احترام گذاشتن به نام مجید و مهیب یهوه خدایتان امتناع ورزید، آنگاه خداوند بر شما و فرزندانتان بلاهای سخت و بیماریهای غیرقابل درمان خواهد فرستاد. ");
INSERT INTO pesopcb_vpl VALUES ("DT28_60","006_28_60","DEU","28","60","60","خداوند، شما را به تمامی بیماریهایی که در مصر از آنها می‌ترسیدید دچار خواهد کرد و علاجی نخواهد بود. ");
INSERT INTO pesopcb_vpl VALUES ("DT28_61","006_28_61","DEU","28","61","61","خداوند هرگونه بیماری و بلایی را که وجود دارد، حتی آنهایی را که در این کتاب اسمی از آنها برده نشده به سراغ شما خواهد فرستاد تا نابود شوید. ");
INSERT INTO pesopcb_vpl VALUES ("DT28_62","006_28_62","DEU","28","62","62","اگرچه به اندازهٔ ستارگان آسمان، بی‌شمار بودید، تعداد کمی از شما باقی خواهند ماند، زیرا از خداوند، خدایتان اطاعت نکردید. ");
INSERT INTO pesopcb_vpl VALUES ("DT28_63","006_28_63","DEU","28","63","63","همان‌طور که خداوند از احسان کردن و افزودن شما شادی کرده است، همان‌گونه نیز در آن وقت از نابود کردن شما خوشحال خواهد شد و شما از سرزمینی که تصرف می‌کنید ریشه‌کن خواهید گشت. ");
INSERT INTO pesopcb_vpl VALUES ("DT28_64","006_28_64","DEU","28","64","64","خداوند، شما را در میان تمامی قومها از یک گوشهٔ عالم تا گوشهٔ دیگر پراکنده خواهد ساخت. در آنجا خدایان دیگر را که نه خود می‌شناختید و نه پدرانتان، پرستش خواهید کرد، خدایانی که از چوب و سنگ ساخته شده‌اند. ");
INSERT INTO pesopcb_vpl VALUES ("DT28_65","006_28_65","DEU","28","65","65","در میان آن قومها روی آرامش را نخواهید دید، بلکه خداوند به شما دلهایی لرزان و چشمانی گریان و افکاری پریشان خواهد داد. ");
INSERT INTO pesopcb_vpl VALUES ("DT28_66","006_28_66","DEU","28","66","66","زندگی شما دائم در خطر خواهد بود، شب و روزتان با ترس سپری خواهد شد و امیدی برای دیدن روشنایی صبح نخواهید داشت. ");
INSERT INTO pesopcb_vpl VALUES ("DT28_67","006_28_67","DEU","28","67","67","به خاطر آنچه که می‌بینید، ترس و وحشت وجود شما را فرا خواهد گرفت. صبحگاهان خواهید گفت: «ای کاش شب می‌شد!» و شامگاهان: «ای کاش صبح می‌شد!» ");
INSERT INTO pesopcb_vpl VALUES ("DT28_68","006_28_68","DEU","28","68","68","خداوند، شما را با کشتی به مصر خواهد فرستاد هر چند قبلاً گفته بودم که هرگز دیگر مصر را نخواهید دید. در آنجا حاضر خواهید شد حتی خود را به بردگی دشمنانتان بفروشید، اما خریداری نخواهید داشت. ");
INSERT INTO pesopcb_vpl VALUES ("DT29_1","006_29_1","DEU","29","1","1","این است شرایط عهدی که خداوند در سرزمین موآب توسط موسی با قوم اسرائیل بست. این عهد غیر از عهدی بود که قبلاً در کوه حوریب بسته شده بود. ‏ ");
INSERT INTO pesopcb_vpl VALUES ("DT29_2","006_29_2","DEU","29","2","2","موسی تمام بنی‌اسرائیل را احضار کرد و به ایشان گفت: شما با چشمان خود بلاهایی را که خداوند بر سر فرعون و درباریانش آورد، دیدید ");
INSERT INTO pesopcb_vpl VALUES ("DT29_3","006_29_3","DEU","29","3","3","و شاهد معجزات عظیم خداوند در سراسر مصر بودید. ");
INSERT INTO pesopcb_vpl VALUES ("DT29_4","006_29_4","DEU","29","4","4","ولی تا امروز خداوند دلهایی که بفهمند و چشمانی که ببینند و گوشهایی که بشنوند به شما نداده است. ");
INSERT INTO pesopcb_vpl VALUES ("DT29_5","006_29_5","DEU","29","5","5","من چهل سال شما را در بیابان هدایت کردم. در این مدت نه لباسهایتان کهنه شد و نه کفشهایتان پاره گشت. ");
INSERT INTO pesopcb_vpl VALUES ("DT29_6","006_29_6","DEU","29","6","6","هر چند نانی برای خوردن و شرابی برای نوشیدن نداشتید، اما خداوند روزی شما را می‌رساند تا به شما بفهماند که او یهوه خدای شماست. ");
INSERT INTO pesopcb_vpl VALUES ("DT29_7","006_29_7","DEU","29","7","7","زمانی که به اینجا رسیدیم سیحون (پادشاه سرزمین حشبون) و عوج (پادشاه سرزمین باشان) با ما به جنگ برخاستند، ولی ما ایشان را شکست دادیم ");
INSERT INTO pesopcb_vpl VALUES ("DT29_8","006_29_8","DEU","29","8","8","و سرزمینشان را گرفتیم و به قبیله‌های رئوبین، جاد و نصف قبیلهٔ منسی دادیم. ");
INSERT INTO pesopcb_vpl VALUES ("DT29_9","006_29_9","DEU","29","9","9","شرایط این عهد را اطاعت کنید تا در تمام کارهایتان موفق باشید. ");
INSERT INTO pesopcb_vpl VALUES ("DT29_10‏","006_29_10‏","DEU","29","10‏","11","همگی شما یعنی رهبران، مشایخ، مردان قوم همراه با کودکان و همسرانتان و غریبانی که در بین شما زندگی می‌کنند یعنی کسانی که هیزم می‌شکنند و برایتان آب می‌آورند امروز در حضور خداوند، خدایتان ایستاده‌اید. ");
INSERT INTO pesopcb_vpl VALUES ("DT29_12","006_29_12","DEU","29","12","12","اینجا ایستاده‌اید تا به عهدی که یهوه خدایتان امروز با شما می‌بندد وارد شوید. ");
INSERT INTO pesopcb_vpl VALUES ("DT29_13","006_29_13","DEU","29","13","13","امروز خداوند می‌خواهد شما را به عنوان قوم خود تأیید کند و خدای شما باشد، همان‌طور که به شما وعده داد و برای پدرانتان، ابراهیم و اسحاق و یعقوب سوگند خورد. ");
INSERT INTO pesopcb_vpl VALUES ("DT29_14‏","006_29_14‏","DEU","29","14‏","15","این پیمان تنها با شما که امروز در حضور یهوه خدایمان ایستاده‌اید بسته نمی‌شود بلکه با تمام نسلهای آیندهٔ اسرائیل نیز بسته می‌شود. ");
INSERT INTO pesopcb_vpl VALUES ("DT29_16","006_29_16","DEU","29","16","16","شما به یاد دارید که چگونه در سرزمین مصر زندگی می‌کردیم و پس از خروج از آنجا چطور از میان قومهای دیگر گذشتیم. ");
INSERT INTO pesopcb_vpl VALUES ("DT29_17","006_29_17","DEU","29","17","17","شما رسوم و بتهای قبیح آن سرزمینها را دیدید که از چوب و سنگ و نقره و طلا ساخته شده بودند. ");
INSERT INTO pesopcb_vpl VALUES ("DT29_18","006_29_18","DEU","29","18","18","امروز در میان شما مرد یا زن، خاندان یا قبیله‌ای نباشد که از خداوند، خدایمان برگردد و بخواهد این خدایان را بپرستد و با این کار، به تدریج قوم را مسموم کند. ");
INSERT INTO pesopcb_vpl VALUE