﻿USE sofia;
DROP TABLE IF EXISTS sofia.pesOPV_vpl;
CREATE TABLE pesOPV_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES pesOPV_vpl WRITE;
INSERT INTO pesOPV_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","در ابتدا، خدا آسمانها و زمین را آفرید. ");
INSERT INTO pesOPV_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","وزمین تهی و بایر بود و تاریکی بر روی لجه. و روح خدا سطح آبها را فرو گرفت. ");
INSERT INTO pesOPV_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","و خدا گفت: «روشنایی بشود.» و روشنایی شد. ");
INSERT INTO pesOPV_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","و خدا روشنایی را دید که نیکوست و خداروشنایی را از تاریکی جدا ساخت. ");
INSERT INTO pesOPV_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","و خداروشنایی را روز نامید و تاریکی را شب نامید. وشام بود و صبح بود، روزی اول. ");
INSERT INTO pesOPV_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","و خدا گفت: «فلکی باشد در میان آبها و آبهارا از آبها جدا کند.» ");
INSERT INTO pesOPV_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","و خدا فلک را بساخت وآبهای زیر فلک را از آبهای بالای فلک جدا کرد. و چنین شد. ");
INSERT INTO pesOPV_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","و خدا فلک را آسمان نامید. و شام بود و صبح بود، روزی دوم. ");
INSERT INTO pesOPV_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","و خدا گفت: «آبهای زیر آسمان در یکجاجمع شود و خشکی ظاهر گردد.» و چنین شد. ");
INSERT INTO pesOPV_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","و خدا خشکی را زمین نامید و اجتماع آبها رادریا نامید. و خدا دید که نیکوست. ");
INSERT INTO pesOPV_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","و خداگفت: «زمین نباتات برویاند، علفی که تخم بیاوردو درخت میوه‌ای که موافق جنس خود میوه آوردکه تخمش در آن باشد، بر روی زمین.» و چنین شد. ");
INSERT INTO pesOPV_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","و زمین نباتات را رویانید، علفی که موافق جنس خود تخم آورد و درخت میوه داری که تخمش در آن، موافق جنس خود باشد. و خدادید که نیکوست. ");
INSERT INTO pesOPV_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","و شام بود و صبح بود، روزی سوم. ");
INSERT INTO pesOPV_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","و خدا گفت: «نیرها در فلک آسمان باشند تاروز را از شب جدا کنند و برای آیات و زمانها وروزها و سالها باشند. ");
INSERT INTO pesOPV_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","و نیرها در فلک آسمان باشند تا بر زمین روشنایی دهند.» و چنین شد. ");
INSERT INTO pesOPV_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","و خدا دو نیر بزرگ ساخت، نیر اعظم را برای سلطنت روز و نیر اصغر را برای سلطنت شب، وستارگان را. ");
INSERT INTO pesOPV_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","و خدا آنها را در فلک آسمان گذاشت تا بر زمین روشنایی دهند، ");
INSERT INTO pesOPV_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","و تاسلطنت نمایند بر روز و بر شب، و روشنایی را ازتاریکی جدا کنند. و خدا دید که نیکوست. ");
INSERT INTO pesOPV_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","وشام بود و صبح بود، روزی چهارم. ");
INSERT INTO pesOPV_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","و خدا گفت: «آبها به انبوه جانوران پر شودو پرندگان بالای زمین بر روی فلک آسمان پروازکنند.» ");
INSERT INTO pesOPV_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","پس خدا نهنگان بزرگ آفرید و همه جانداران خزنده را، که آبها از آنها موافق اجناس آنها پر شد، و همه پرندگان بالدار را به اجناس آنها. و خدا دید که نیکوست. ");
INSERT INTO pesOPV_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","و خدا آنها رابرکت داده، گفت: «بارور و کثیر شوید و آبهای دریا را پر سازید، و پرندگان در زمین کثیر بشوند.» ");
INSERT INTO pesOPV_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","و شام بود و صبح بود، روزی پنجم. ");
INSERT INTO pesOPV_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","و خدا گفت: «زمین، جانوران را موافق اجناس آنها بیرون آورد، بهایم و حشرات وحیوانات زمین به اجناس آنها.» و چنین شد. ");
INSERT INTO pesOPV_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","پس خدا حیوانات زمین را به اجناس آنهابساخت و بهایم را به اجناس آنها و همه حشرات زمین را به اجناس آنها. و خدا دید که نیکوست. ");
INSERT INTO pesOPV_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","و خدا گفت: «آدم را بصورت ما و موافق شبیه ما بسازیم تا بر ماهیان دریا و پرندگان آسمان وبهایم و بر تمامی زمین و همه حشراتی که بر زمین می‌خزند، حکومت نماید.» ");
INSERT INTO pesOPV_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","پس خدا آدم را بصورت خود آفرید. او رابصورت خدا آفرید. ایشان را نر و ماده آفرید. ");
INSERT INTO pesOPV_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","و خدا ایشان را برکت داد و خدا بدیشان گفت: «بارور و کثیر شوید و زمین را پر سازید و در آن تسلط نمایید، و بر ماهیان دریا و پرندگان آسمان وهمه حیواناتی که بر زمین می‌خزند، حکومت کنید.» ");
INSERT INTO pesOPV_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","و خدا گفت: «همانا همه علف های تخم داری که بر روی تمام زمین است و همه درختهایی که در آنها میوه درخت تخم دار است، به شما دادم تا برای شما خوراک باشد. ");
INSERT INTO pesOPV_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","و به همه حیوانات زمین و به همه پرندگان آسمان وبه همه حشرات زمین که در آنها حیات‌است، هر علف سبز را برای خوراک دادم.» و چنین شد. ");
INSERT INTO pesOPV_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","و خدا هر‌چه ساخته بود، دید و همانابسیار نیکو بود. و شام بود و صبح بود، روزششم. ");
INSERT INTO pesOPV_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","و آسمانها و زمین و همه لشکر آنها تمام شد. ");
INSERT INTO pesOPV_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","و در روز هفتم، خدا از همه کار خود که ساخته بود، فارغ شد. و در روز هفتم از همه کارخود که ساخته بود، آرامی گرفت. ");
INSERT INTO pesOPV_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","پس خدا روزهفتم را مبارک خواند و آن را تقدیس نمود، زیراکه در آن آرام گرفت، از همه کار خود که خداآفرید و ساخت. ");
INSERT INTO pesOPV_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","این است پیدایش آسمانها و زمین در حین آفرینش آنها در روزی که یهوه، خدا، زمین وآسمانها را بساخت. ");
INSERT INTO pesOPV_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","و هیچ نهال صحرا هنوز درزمین نبود و هیچ علف صحرا هنوز نروییده بود، زیرا خداوند خدا باران بر زمین نبارانیده بود وآدمی نبود که کار زمین را بکند. ");
INSERT INTO pesOPV_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","و مه از زمین برآمده، تمام روی زمین را سیراب می‌کرد. ");
INSERT INTO pesOPV_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","خداوند خدا پس آدم را از خاک زمین بسرشت و در بینی وی روح حیات دمید، و آدم نفس زنده شد. ");
INSERT INTO pesOPV_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","و خداوند خدا باغی در عدن بطرف مشرق غرس نمود و آن آدم را که سرشته بود، در آنجاگذاشت. ");
INSERT INTO pesOPV_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","و خداوند خدا هر درخت خوشنما وخوش خوراک را از زمین رویانید، و درخت حیات را در وسط باغ و درخت معرفت نیک و بدرا. ");
INSERT INTO pesOPV_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","و نهری از عدن بیرون آمد تا باغ را سیراب کند، و از آنجا منقسم گشته، چهار شعبه شد. ");
INSERT INTO pesOPV_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","نام اول فیشون است که تمام زمین حویله را که در آنجا طلاست، احاطه می‌کند. ");
INSERT INTO pesOPV_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","و طلای آن زمین نیکوست و در آنجا مروارید و سنگ جزع است. ");
INSERT INTO pesOPV_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","و نام نهر دوم جیحون که تمام زمین کوش را احاطه می‌کند. ");
INSERT INTO pesOPV_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","و نام نهر سوم حدقل که بطرف شرقی آشور جاری است. و نهر‌چهارم فرات. ");
INSERT INTO pesOPV_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","پس خداوند خدا آدم را گرفت و او را درباغ عدن گذاشت تا کار آن را بکند و آن رامحافظت نماید. ");
INSERT INTO pesOPV_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","و خداوند خدا آدم را امرفرموده، گفت: «از همه درختان باغ بی‌ممانعت بخور، ");
INSERT INTO pesOPV_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","اما از درخت معرفت نیک و بد زنهارنخوری، زیرا روزی که از آن خوردی، هرآینه خواهی مرد.» ");
INSERT INTO pesOPV_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","و خداوند خدا گفت: «خوب نیست که آدم تنها باشد. پس برایش معاونی موافق وی بسازم.» ");
INSERT INTO pesOPV_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","و خداوند خدا هر حیوان صحرا و هر پرنده آسمان را از زمین سرشت و نزدآدم آورد تا ببیند که چه نام خواهد نهاد و آنچه آدم هر ذی حیات را خواند، همان نام او شد. ");
INSERT INTO pesOPV_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","پس آدم همه بهایم و پرندگان آسمان و همه حیوانات صحرا را نام نهاد. لیکن برای آدم معاونی موافق وی یافت نشد. ");
INSERT INTO pesOPV_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","و خداوند خدا، خوابی گران بر آدم مستولی گردانید تا بخفت، و یکی از دنده هایش راگرفت و گوشت در جایش پر کرد. ");
INSERT INTO pesOPV_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","و خداوندخدا آن دنده را که از آدم گرفته بود، زنی بنا کرد ووی را به نزد آدم آورد. ");
INSERT INTO pesOPV_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","و آدم گفت: «همانااینست استخوانی از استخوانهایم و گوشتی ازگوشتم، از این سبب “نسا” نامیده شود زیرا که ازانسان گرفته شد.» ");
INSERT INTO pesOPV_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","از این سبب مرد پدر و مادرخود را ترک کرده، با زن خویش خواهد پیوست ویک تن خواهند بود. ");
INSERT INTO pesOPV_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","و آدم و زنش هر دو برهنه بودند و خجلت نداشتند. ");
INSERT INTO pesOPV_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","و مار از همه حیوانات صحرا که خداوندخدا ساخته بود، هشیارتر بود. و به زن گفت: «آیا خدا حقیقت گفته است که از همه درختان باغ نخورید؟» ");
INSERT INTO pesOPV_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","زن به مار گفت: «از میوه درختان باغ می‌خوریم، ");
INSERT INTO pesOPV_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","لکن از میوه درختی که در وسط باغ است، خدا گفت از آن مخورید و آن را لمس مکنید، مبادا بمیرید.» ");
INSERT INTO pesOPV_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","مار به زن گفت: «هر آینه نخواهید مرد، ");
INSERT INTO pesOPV_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","بلکه خدا می‌داند درروزی که از آن بخورید، چشمان شما باز شود ومانند خدا عارف نیک و بد خواهید بود.» ");
INSERT INTO pesOPV_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","و چون زن دید که آن درخت برای خوراک نیکوست وبنظر خوشنما و درختی دلپذیر دانش افزا، پس ازمیوه‌اش گرفته، بخورد و به شوهر خود نیز داد و اوخورد. ");
INSERT INTO pesOPV_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","آنگاه چشمان هر دو ایشان باز شد وفهمیدند که عریانند. پس برگهای انجیر به هم دوخته، سترها برای خویشتن ساختند. ");
INSERT INTO pesOPV_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","و آواز خداوند خدا را شنیدند که در هنگام وزیدن نسیم نهار در باغ می‌خرامید، و آدم و زنش خویشتن را از حضور خداوند خدا در میان درختان باغ پنهان کردند. ");
INSERT INTO pesOPV_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","و خداوند خدا آدم راندا در‌داد و گفت: «کجا هستی؟» ");
INSERT INTO pesOPV_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","گفت: «چون آوازت را در باغ شنیدم، ترسان گشتم، زیرا که عریانم. پس خود را پنهان کردم.» ");
INSERT INTO pesOPV_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","گفت: «که تورا آگاهانید که عریانی؟ آیا از آن درختی که تو راقدغن کردم که از آن نخوری، خوردی؟» ");
INSERT INTO pesOPV_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","آدم گفت: «این زنی که قرین من ساختی، وی از میوه درخت به من داد که خوردم.» ");
INSERT INTO pesOPV_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","پس خداوندخدا به زن گفت: «این چه‌کار است که کردی؟» زن گفت: «مار مرا اغوا نمود که خوردم.» ");
INSERT INTO pesOPV_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","پس خداوند خدا به مار گفت: «چونکه این کار کردی، از جمیع بهایم و از همه حیوانات صحرا ملعون تر هستی! بر شکمت راه خواهی رفت و تمام ایام عمرت خاک خواهی خورد. ");
INSERT INTO pesOPV_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","وعداوت در میان تو و زن، و در میان ذریت تو و ذریت وی می‌گذارم؛ او سر تو را خواهد کوبید وتو پاشنه وی را خواهی کوبید.» ");
INSERT INTO pesOPV_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","و به زن گفت: «الم و حمل تو را بسیار افزون گردانم؛ با الم فرزندان خواهی زایید و اشتیاق تو به شوهرت خواهد بود و او بر تو حکمرانی خواهد کرد.» ");
INSERT INTO pesOPV_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","و به آدم گفت: «چونکه سخن زوجه ات راشنیدی و از آن درخت خوردی که امرفرموده، گفتم از آن نخوری، پس بسبب توزمین ملعون شد، و تمام ایام عمرت از آن بارنج خواهی خورد. ");
INSERT INTO pesOPV_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","خار و خس نیز برایت خواهد رویانید و سبزه های صحرا را خواهی خورد، ");
INSERT INTO pesOPV_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","و به عرق پیشانی ات نان خواهی خوردتا حینی که به خاک راجع گردی، که از آن گرفته شدی زیرا که تو خاک هستی و به خاک خواهی برگشت.» ");
INSERT INTO pesOPV_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","و آدم زن خود را حوا نام نهاد، زیرا که اومادر جمیع زندگان است. ");
INSERT INTO pesOPV_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","و خداوند خدارختها برای آدم و زنش از پوست بساخت وایشان را پوشانید. ");
INSERT INTO pesOPV_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","و خداوند خدا گفت: «هماناانسان مثل یکی از ما شده است، که عارف نیک وبد گردیده. اینک مبادا دست خود را دراز کند و ازدرخت حیات نیز گرفته بخورد، و تا به ابد زنده ماند.» ");
INSERT INTO pesOPV_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","پس خداوند خدا، او را از باغ عدن بیرون کرد تا کار زمینی را که از آن گرفته شده بود، بکند. ");
INSERT INTO pesOPV_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","پس آدم را بیرون کرد و به طرف شرقی باغ عدن، کروبیان را مسکن داد و شمشیرآتشباری را که به هر سو گردش می‌کرد تا طریق درخت حیات را محافظت کند. ");
INSERT INTO pesOPV_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","و آدم، زن خود حوا را بشناخت و او حامله شده، قائن را زایید. و گفت: «مردی از یهوه حاصل نمودم.» ");
INSERT INTO pesOPV_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","و بار دیگر برادر او هابیل رازایید. و هابیل گله بان بود، و قائن کارکن زمین بود. ");
INSERT INTO pesOPV_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","و بعد از مرور ایام، واقع شد که قائن هدیه‌ای ازمحصول زمین برای خداوند آورد. ");
INSERT INTO pesOPV_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","و هابیل نیزاز نخست زادگان گله خویش و پیه آنها هدیه‌ای آورد. و خداوند هابیل و هدیه او را منظورداشت، ");
INSERT INTO pesOPV_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","اما قائن و هدیه او را منظور نداشت. پس خشم قائن به شدت افروخته شده، سر خود رابزیر افکند. ");
INSERT INTO pesOPV_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","آنگاه خداوند به قائن گفت: «چراخشمناک شدی؟ و چرا سر خود را بزیرافکندی؟ ");
INSERT INTO pesOPV_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","اگر نیکویی می‌کردی، آیا مقبول نمی شدی؟ و اگر نیکویی نکردی، گناه بر در، درکمین است و اشتیاق تو دارد، اما تو بر وی مسلطشوی.» ");
INSERT INTO pesOPV_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","و قائن با برادر خود هابیل سخن گفت. و واقع شد چون در صحرا بودند، قائن بر برادر خودهابیل برخاسته او را کشت. ");
INSERT INTO pesOPV_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","پس خداوند به قائن گفت: «برادرت هابیل کجاست؟» گفت: «نمی دانم، مگر پاسبان برادرم هستم؟» ");
INSERT INTO pesOPV_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","گفت: «چه کرده‌ای؟ خون برادرت از زمین نزد من فریادبرمی آورد! ");
INSERT INTO pesOPV_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","و اکنون تو ملعون هستی از زمینی که دهان خود را باز کرد تا خون برادرت را ازدستت فرو برد. ");
INSERT INTO pesOPV_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","هر گاه کار زمین کنی، هماناقوت خود را دیگر به تو ندهد. و پریشان و آواره در جهان خواهی بود.» ");
INSERT INTO pesOPV_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","قائن به خداوند گفت: «عقوبتم از تحملم زیاده است. ");
INSERT INTO pesOPV_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","اینک مراامروز بر روی زمین مطرود ساختی، و از روی تو پنهان خواهم بود. و پریشان و آواره درجهان خواهم بود و واقع می‌شود هر‌که مرایابد، مرا خواهد کشت.» ");
INSERT INTO pesOPV_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","خداوند به وی گفت: «پس هر‌که قائن را بکشد، هفت چندان انتقام گرفته شود.» و خداوند به قائن نشانی‌ای داد که هر‌که او را یابد، وی را نکشد. ");
INSERT INTO pesOPV_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","پس قائن از حضور خداوند بیرون رفت ودر زمین نود، بطرف شرقی عدن، ساکن شد. ");
INSERT INTO pesOPV_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","و قائن زوجه خود را شناخت. پس حامله شده، خنوخ را زایید. و شهری بنا می‌کرد، و آن شهر را به اسم پسر خود، خنوخ نام نهاد. ");
INSERT INTO pesOPV_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","وبرای خنوخ عیراد متولد شد، و عیراد، محویائیل را آورد، و محویائیل، متوشائیل را آورد، ومتوشائیل، لمک را آورد. ");
INSERT INTO pesOPV_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","و لمک، دو زن برای خود گرفت، یکی را عاده نام بود و دیگری را ظله. ");
INSERT INTO pesOPV_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","و عاده، یابال را زایید. وی پدر خیمه نشینان وصاحبان مواشی بود. ");
INSERT INTO pesOPV_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","و نام برادرش یوبال بود. وی پدر همه نوازندگان بربط و نی بود. ");
INSERT INTO pesOPV_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","و ظله نیز توبل قائن را زایید، که صانع هر آلت مس وآهن بود. و خواهر توبل قائن، نعمه بود. ");
INSERT INTO pesOPV_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","و لمک به زنان خود گفت: «ای عاده و ظله، قول مرابشنوید! ای زنان لمک، سخن مرا گوش گیرید! زیرا مردی را کشتم بسبب جراحت خود، وجوانی را بسبب ضرب خویش. ");
INSERT INTO pesOPV_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","اگر برای قائن هفت چندان انتقام گرفته شود، هر آینه برای لمک، هفتاد و هفت چندان.» ");
INSERT INTO pesOPV_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","پس آدم بار دیگرزن خود را شناخت، و او پسری بزاد و او را شیث نام نهاد، زیرا گفت: «خدا نسلی دیگر به من قرارداد، به عوض هابیل که قائن او را کشت.» ");
INSERT INTO pesOPV_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","وبرای شیث نیز پسری متولد شد و او را انوش نامید. در آنوقت به خواندن اسم یهوه شروع کردند. ");
INSERT INTO pesOPV_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","این است کتاب پیدایش آدم. در روزی که خدا آدم را آفرید، به شبیه خدا او راساخت. ");
INSERT INTO pesOPV_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","نر و ماده ایشان را آفرید. و ایشان رابرکت داد و ایشان را «آدم» نام نهاد، در روزآفرینش ایشان. ");
INSERT INTO pesOPV_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","و آدم صد و سی سال بزیست، پس پسری به شبیه و بصورت خود آورد، و او را شیث نامید. ");
INSERT INTO pesOPV_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","وایام آدم بعد از آوردن شیث، هشتصد سال بود، وپسران و دختران آورد. ");
INSERT INTO pesOPV_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","پس تمام ایام آدم که زیست، نهصد و سی سال بود که مرد. ");
INSERT INTO pesOPV_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","و شیث صد و پنج سال بزیست، و انوش را آورد. ");
INSERT INTO pesOPV_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","وشیث بعد از آوردن انوش، هشتصد و هفت سال بزیست و پسران و دختران آورد. ");
INSERT INTO pesOPV_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","و جمله ایام شیث، نهصد و دوازده سال بود که مرد. ");
INSERT INTO pesOPV_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","و انوش نود سال بزیست، و قینان را آورد. ");
INSERT INTO pesOPV_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","و انوش بعداز آوردن قینان، هشتصد و پانزده سال زندگانی کرد و پسران و دختران آورد. ");
INSERT INTO pesOPV_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","پس جمله ایام انوش نهصد و پنج سال بود که مرد. ");
INSERT INTO pesOPV_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","و قینان هفتاد سال بزیست، و مهللئیل را آورد. ");
INSERT INTO pesOPV_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","و قینان بعد از آوردن مهللئیل، هشتصد و چهل سال زندگانی کرد و پسران و دختران آورد. ");
INSERT INTO pesOPV_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","و تمامی ایام قینان، نهصد و ده سال بود که مرد. ");
INSERT INTO pesOPV_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","ومهللئیل، شصت و پنج سال بزیست، و یارد را آورد. ");
INSERT INTO pesOPV_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","و مهللئیل بعد از آوردن یارد، هشتصد وسی سال زندگانی کرد و پسران و دختران آورد. ");
INSERT INTO pesOPV_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","پس همه ایام مهللئیل، هشتصد و نود و پنج سال بود که مرد. ");
INSERT INTO pesOPV_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","و یارد صد و شصت و دو سال بزیست، و خنوخ را آورد. ");
INSERT INTO pesOPV_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","و یارد بعد از آوردن خنوخ، هشتصد سال زندگانی کرد و پسران ودختران آورد. ");
INSERT INTO pesOPV_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","و تمامی ایام یارد، نهصد وشصت و دو سال بود که مرد. ");
INSERT INTO pesOPV_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","و خنوخ شصت وپنج سال بزیست، و متوشالح را آورد. ");
INSERT INTO pesOPV_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","و خنوخ بعد از آوردن متوشالح، سیصد سال با خدا راه می‌رفت و پسران و دختران آورد. ");
INSERT INTO pesOPV_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","و همه ایام خنوخ، سیصد و شصت و پنج سال بود. ");
INSERT INTO pesOPV_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","وخنوخ با خدا راه می‌رفت و نایاب شد، زیرا خدااو را برگرفت. ");
INSERT INTO pesOPV_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","و متوشالح صد و هشتاد و هفت سال بزیست، و لمک را آورد. ");
INSERT INTO pesOPV_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","و متوشالح بعداز آوردن لمک، هفتصد و هشتاد و دو سال زندگانی کرد و پسران و دختران آورد. ");
INSERT INTO pesOPV_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","پس جمله ایام متوشالح، نهصد و شصت و نه سال بودکه مرد. ");
INSERT INTO pesOPV_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","و لمک صد و هشتاد و دو سال بزیست، و پسری آورد. ");
INSERT INTO pesOPV_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","و وی را نوح نام نهاده گفت: «این ما را تسلی خواهد داد از اعمال ما و ازمحنت دستهای ما از زمینی که خداوند آن راملعون کرد.» ");
INSERT INTO pesOPV_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","و لمک بعد از آوردن نوح، پانصدو نود و پنج سال زندگانی کرد و پسران و دختران آورد. ");
INSERT INTO pesOPV_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","پس تمام ایام لمک، هفتصد و هفتاد وهفت سال بود که مرد. ");
INSERT INTO pesOPV_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","و نوح پانصد ساله بود، پس نوح سام و حام و یافث را آورد. ");
INSERT INTO pesOPV_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","و واقع شد که چون آدمیان شروع کردندبه زیاد شدن بر روی زمین و دختران برای ایشان متولد گردیدند، ");
INSERT INTO pesOPV_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","پسران خدا دختران آدمیان را دیدند که نیکومنظرند، و از هر کدام که خواستند، زنان برای خویشتن می‌گرفتند. ");
INSERT INTO pesOPV_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","وخداوند گفت: «روح من در انسان دائم داوری نخواهد کرد، زیرا که او نیز بشر است. لیکن ایام وی صد و بیست سال خواهد بود.» ");
INSERT INTO pesOPV_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","و در آن ایام مردان تنومند در زمین بودند. و بعد از هنگامی که پسران خدا به دختران آدمیان در‌آمدند و آنهابرای ایشان اولاد زاییدند، ایشان جبارانی بودندکه در زمان سلف، مردان نامور شدند. ");
INSERT INTO pesOPV_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","و خداونددید که شرارت انسان در زمین بسیار است، و هرتصور از خیالهای دل وی دائم محض شرارت است. ");
INSERT INTO pesOPV_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","و خداوند پشیمان شد که انسان را برزمین ساخته بود، و در دل خود محزون گشت. ");
INSERT INTO pesOPV_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","وخداوند گفت: «انسان را که آفریده‌ام، از روی زمین محو سازم، انسان و بهایم و حشرات وپرندگان هوا را، چونکه متاسف شدم از ساختن ایشان.» ");
INSERT INTO pesOPV_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","اما نوح در نظر خداوند التفات یافت. ");
INSERT INTO pesOPV_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","این است پیدایش نوح. نوح مردی عادل بود، و در عصر خود کامل. و نوح با خدا راه می‌رفت. ");
INSERT INTO pesOPV_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","و نوح سه پسر آورد: سام و حام و یافث. ");
INSERT INTO pesOPV_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","وزمین نیز بنظر خدا فاسد گردیده و زمین از ظلم پر شده بود. ");
INSERT INTO pesOPV_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","و خدا زمین را دید که اینک فاسدشده است، زیرا که تمامی بشر راه خود را بر زمین فاسد کرده بودند. ");
INSERT INTO pesOPV_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","و خدا به نوح گفت: «انتهای تمامی بشر به حضورم رسیده است، زیرا که زمین بسبب ایشان پر از ظلم شده است. و اینک من ایشان را با زمین هلاک خواهم ساخت. ");
INSERT INTO pesOPV_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","پس برای خودکشتی‌ای از چوب کوفر بساز، و حجرات درکشتی بنا کن و درون و بیرونش را به قیر بیندا. ");
INSERT INTO pesOPV_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","وآن را بدین ترکیب بساز که طول کشتی سیصدذراع باشد، و عرضش پنجاه ذراع و ارتفاع آن سی ذراع. ");
INSERT INTO pesOPV_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","و روشنی‌ای برای کشتی بساز و آن را به ذراعی از بالا تمام کن. و در کشتی را در جنب آن بگذار، و طبقات تحتانی و وسطی و فوقانی بساز. ");
INSERT INTO pesOPV_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","زیرا اینک من طوفان آب را بر زمین می‌آورم تاهر جسدی را که روح حیات در آن باشد، از زیرآسمان هلاک گردانم. و هر‌چه بر زمین است، خواهد مرد. ");
INSERT INTO pesOPV_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","لکن عهد خود را با تو استوارمی سازم، و به کشتی در خواهی آمد، تو وپسرانت و زوجه ات و ازواج پسرانت با تو. ");
INSERT INTO pesOPV_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","و ازجمیع حیوانات، از هر ذی جسدی، جفتی از همه به کشتی در خواهی آورد، تا با خویشتن زنده نگاه داری، نر و ماده باشند. ");
INSERT INTO pesOPV_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","از پرندگان به اجناس آنها، و از بهایم به اجناس آنها، و از همه حشرات زمین به اجناس آنها، دودو از همه نزدتو آیند تا زنده نگاه داری. ");
INSERT INTO pesOPV_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","و از هر آذوقه‌ای که خورده شود، بگیر و نزد خود ذخیره نما تابرای تو و آنها خوراک باشد.» ");
INSERT INTO pesOPV_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","پس نوح چنین کرد و به هرچه خدا او را امر فرمود، عمل نمود. ");
INSERT INTO pesOPV_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","و خداوند به نوح گفت: «تو و تمامی اهل خانه ات به کشتی در آیید، زیرا تو را در این عصر به حضور خود عادل دیدم. ");
INSERT INTO pesOPV_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","و از همه بهایم پاک، هفت هفت، نر و ماده با خود بگیر، و از بهایم ناپاک، دودو، نر و ماده، ");
INSERT INTO pesOPV_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","و از پرندگان آسمان نیزهفت هفت، نر و ماده را، تا نسلی بر روی تمام زمین نگاه داری. ");
INSERT INTO pesOPV_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","زیرا که من بعد از هفت روزدیگر، چهل روز و چهل شب باران می‌بارانم، وهر موجودی را که ساخته‌ام، از روی زمین محومی سازم.» ");
INSERT INTO pesOPV_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","پس نوح موافق آنچه خداوند او را امرفرموده بود، عمل نمود. ");
INSERT INTO pesOPV_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","و نوح ششصد ساله بود، چون طوفان آب بر زمین آمد. ");
INSERT INTO pesOPV_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","و نوح وپسرانش و زنش و زنان پسرانش با وی از آب طوفان به کشتی در‌آمدند. ");
INSERT INTO pesOPV_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","از بهایم پاک و ازبهایم ناپاک، و از پرندگان و از همه حشرات زمین، ");
INSERT INTO pesOPV_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","دودو، نر و ماده، نزد نوح به کشتی در‌آمدند، چنانکه خدا نوح را امر کرده بود. ");
INSERT INTO pesOPV_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","و واقع شدبعد از هفت روز که آب طوفان بر زمین آمد. ");
INSERT INTO pesOPV_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","و در سال ششصد از زندگانی نوح، در روزهفدهم از ماه دوم، در همان روز جمیع چشمه های لجه عظیم شکافته شد، و روزنهای آسمان گشوده. ");
INSERT INTO pesOPV_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","و باران، چهل روز و چهل شب بر روی زمین می‌بارید. ");
INSERT INTO pesOPV_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","در همان روز نوح وپسرانش، سام و حام و یافث، و زوجه نوح و سه زوجه پسرانش، با ایشان داخل کشتی شدند. ");
INSERT INTO pesOPV_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","ایشان و همه حیوانات به اجناس آنها، و همه بهایم به اجناس آنها، و همه حشراتی که بر زمین می‌خزند به اجناس آنها، و همه پرندگان به اجناس آنها، همه مرغان و همه بالداران. ");
INSERT INTO pesOPV_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","دودواز هر ذی جسدی که روح حیات دارد، نزد نوح به کشتی در‌آمدند. ");
INSERT INTO pesOPV_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","و آنهایی که آمدند نر و ماده از هر ذی جسد آمدند، چنانکه خدا وی را امرفرموده بود. و خداوند در را از عقب او بست. ");
INSERT INTO pesOPV_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","و طوفان چهل روز بر زمین می‌آمد، و آب همی افزود و کشتی را برداشت که از زمین بلندشد. ");
INSERT INTO pesOPV_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","و آب غلبه یافته، بر زمین همی افزود، وکشتی بر سطح آب می‌رفت. ");
INSERT INTO pesOPV_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","و آب بر زمین زیاد و زیاد غلبه یافت، تا آنکه همه کوههای بلندکه زیر تمامی آسمانها بود، مستور شد. ");
INSERT INTO pesOPV_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","پانزده ذراع بالاتر آب غلبه یافت و کوهها مستور گردید. ");
INSERT INTO pesOPV_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","و هر ذی جسدی که بر زمین حرکت می‌کرد، ازپرندگان و بهایم و حیوانات و کل حشرات خزنده بر زمین، و جمیع آدمیان، مردند. ");
INSERT INTO pesOPV_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","هرکه دم روح حیات در بینی او بود، از هر‌که در خشکی بود، مرد. ");
INSERT INTO pesOPV_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","و خدا محو کرد هر موجودی را که برروی زمین بود، از آدمیان و بهایم و حشرات وپرندگان آسمان، پس از زمین محو شدند. و نوح باآنچه همراه وی در کشتی بود فقط باقی ماند. ");
INSERT INTO pesOPV_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","وآب بر زمین صد و پنجاه روز غلبه می‌یافت. ");
INSERT INTO pesOPV_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","بهایمی را که با وی در کشتی بودند، بیادآورد. و خدا بادی بر زمین وزانید و آب ساکن گردید. ");
INSERT INTO pesOPV_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","و چشمه های لجه و روزنهای آسمان بسته شد، و باران از آسمان باز ایستاد. ");
INSERT INTO pesOPV_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","و آب رفته رفته از روی زمین برگشت. و بعد از انقضای صد و پنجاه روز، آب کم شد، ");
INSERT INTO pesOPV_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","و روز هفدهم ازماه هفتم، کشتی بر کوههای آرارات قرار گرفت. ");
INSERT INTO pesOPV_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","و تا ماه دهم، آب رفته رفته کمتر می‌شد، و درروز اول از ماه دهم، قله های کوهها ظاهر گردید. ");
INSERT INTO pesOPV_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","و واقع شد بعد از چهل روز که نوح دریچه کشتی را که ساخته بود، باز کرد. ");
INSERT INTO pesOPV_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","و زاغ را رهاکرد. او بیرون رفته، در تردد می‌بود تا آب از زمین خشک شد. ");
INSERT INTO pesOPV_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","پس کبوتر را از نزد خود رها کرد تاببیند که آیا آب از روی زمین کم شده است. ");
INSERT INTO pesOPV_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","اماکبوتر چون نشیمنی برای کف پای خود نیافت، زیرا که آب در تمام روی زمین بود، نزد وی به کشتی برگشت. پس دست خود را دراز کرد و آن را گرفته نزد خود به کشتی در‌آورد. ");
INSERT INTO pesOPV_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","و هفت روز دیگر نیز درنگ کرده، باز کبوتر را از کشتی رها کرد. ");
INSERT INTO pesOPV_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","و در وقت عصر، کبوتر نزد وی برگشت، و اینک برگ زیتون تازه در منقار وی است. پس نوح دانست که آب از روی زمین کم شده است. ");
INSERT INTO pesOPV_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","و هفت روز دیگر نیز توقف نموده، کبوتر را رها کرد، و او دیگر نزد وی برنگشت. ");
INSERT INTO pesOPV_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","و در سال ششصد و یکم در روز اول از ماه اول، آب از روی زمین خشک شد. پس نوح پوشش کشتی را برداشته، نگریست، و اینک روی زمین خشک بود. ");
INSERT INTO pesOPV_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","و در روز بیست و هفتم از ماه دوم، زمین خشک شد. ");
INSERT INTO pesOPV_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","آنگاه خدا نوح رامخاطب ساخته، گفت: ");
INSERT INTO pesOPV_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","«از کشتی بیرون شو، توو زوجه ات و پسرانت و ازواج پسرانت با تو. ");
INSERT INTO pesOPV_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","وهمه حیواناتی را که نزد خود داری، هرذی جسدی را از پرندگان و بهایم و کل حشرات خزنده بر زمین، با خود بیرون آور، تا بر زمین منتشر شده، در جهان بارور و کثیر شوند.» ");
INSERT INTO pesOPV_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","پس نوح و پسران او و زنش و زنان پسرانش، با وی بیرون آمدند. ");
INSERT INTO pesOPV_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","و همه حیوانات و همه حشرات و همه پرندگان، و هر‌چه بر زمین حرکت می‌کند، به اجناس آنها، از کشتی به در شدند. ");
INSERT INTO pesOPV_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","و نوح مذبحی برای خداوند بنا کرد، و از هر بهیمه پاک واز هر پرنده پاک گرفته، قربانی های سوختنی برمذبح گذرانید. ");
INSERT INTO pesOPV_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","و خداوند بوی خوش بویید و خداوند در دل خود گفت: «بعد از این دیگر زمین را بسبب انسان لعنت نکنم، زیرا که خیال دل انسان از طفولیت بد است، و بار دیگر همه حیوانات را هلاک نکنم، چنانکه کردم. ");
INSERT INTO pesOPV_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","مادامی که جهان باقی است، زرع و حصاد، و سرما و گرما، و زمستان و تابستان، و روز و شب موقوف نخواهد شد.» ");
INSERT INTO pesOPV_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","و خدا، نوح و پسرانش را برکت داده، بدیشان گفت: «بارور و کثیر شوید و زمین را پر سازید. ");
INSERT INTO pesOPV_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","و خوف شما و هیبت شما بر همه حیوانات زمین و بر همه پرندگان آسمان، و بر هرچه بر زمین می‌خزد، و بر همه ماهیان دریا خواهدبود، به‌دست شما تسلیم شده‌اند. ");
INSERT INTO pesOPV_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","و هرجنبنده‌ای که زندگی دارد، برای شما طعام باشد. همه را چون علف سبز به شما دادم، ");
INSERT INTO pesOPV_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","مگرگوشت را با جانش که خون او باشد، مخورید. ");
INSERT INTO pesOPV_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","وهر آینه انتقام خون شما را برای جان شما خواهم گرفت. از دست هر حیوان آن را خواهم گرفت. واز دست انسان، انتقام جان انسان را از دست برادرش خواهم گرفت. ");
INSERT INTO pesOPV_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","هر‌که خون انسان ریزد، خون وی به‌دست انسان ریخته شود. زیرا خداانسان را به صورت خود ساخت. ");
INSERT INTO pesOPV_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","و شما بارور وکثیر شوید، و در زمین منتشر شده، در آن بیفزایید.» ");
INSERT INTO pesOPV_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","و خدا نوح و پسرانش را با وی خطاب کرده، گفت: ");
INSERT INTO pesOPV_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","«اینک من عهد خود را با شما و بعداز شما با ذریت شما استوار سازم، ");
INSERT INTO pesOPV_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","و با همه جانورانی که با شما باشند، از پرندگان و بهایم و همه حیوانات زمین با شما، با هر‌چه از کشتی بیرون آمد، حتی جمیع حیوانات زمین. ");
INSERT INTO pesOPV_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","عهدخود را با شما استوار می‌گردانم که بار دیگر هرذی جسد از آب طوفان هلاک نشود، و طوفان بعداز این نباشد تا زمین را خراب کند.» ");
INSERT INTO pesOPV_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","و خدا گفت: «اینست نشان عهدی که من می‌بندم، در میان خود و شما، و همه جانورانی که با شما باشند، نسلا بعد نسل تا به ابد: ");
INSERT INTO pesOPV_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","قوس خود را در ابر می‌گذارم، و نشان آن عهدی که درمیان من و جهان است، خواهد بود. ");
INSERT INTO pesOPV_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","و هنگامی که ابر را بالای زمین گسترانم، و قوس در ابر ظاهرشود، ");
INSERT INTO pesOPV_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","آنگاه عهد خود را که در میان من و شما وهمه جانوران ذی جسد می‌باشد، بیاد خواهم آورد. و آب طوفان دیگر نخواهد بود تا هرذی جسدی را هلاک کند. ");
INSERT INTO pesOPV_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","و قوس در ابرخواهد بود، و آن را خواهم نگریست تا بیاد آورم آن عهد جاودانی را که در میان خدا و همه جانوران است، از هر ذی جسدی که بر زمین است.» ");
INSERT INTO pesOPV_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","و خدا به نوح گفت: «این است نشان عهدی که استوار ساختم در میان خود و هرذی جسدی که بر زمین است.» ");
INSERT INTO pesOPV_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","و پسران نوح که از کشتی بیرون آمدند، سام و حام و یافث بودند. و حام پدر کنعان است. ");
INSERT INTO pesOPV_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","اینانند سه پسر نوح، و از ایشان تمامی جهان منشعب شد. ");
INSERT INTO pesOPV_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","و نوح به فلاحت زمین شروع کرد، وتاکستانی غرس نمود. ");
INSERT INTO pesOPV_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","و شراب نوشیده، مست شد، و در خیمه خود عریان گردید. ");
INSERT INTO pesOPV_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","و حام، پدر کنعان، برهنگی پدر خود را دید و دو برادرخود را بیرون خبر داد. ");
INSERT INTO pesOPV_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","و سام و یافث، ردا راگرفته، بر کتف خود انداختند، و پس رفته، برهنگی پدر خود را پوشانیدند. و روی ایشان بازپس بود که برهنگی پدر خود را ندیدند. ");
INSERT INTO pesOPV_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","و نوح از مستی خود به هوش آمده، دریافت که پسرکهترش با وی چه کرده بود. ");
INSERT INTO pesOPV_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","پس گفت: «کنعان ملعون باد! برادران خود را بنده بندگان باشد.» ");
INSERT INTO pesOPV_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","وگفت: «متبارک باد یهوه خدای سام! و کنعان، بنده او باشد. ");
INSERT INTO pesOPV_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","خدا یافث را وسعت دهد، و درخیمه های سام ساکن شود، و کنعان بنده او باشد.» ");
INSERT INTO pesOPV_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","و نوح بعد از طوفان، سیصد و پنجاه سال زندگانی کرد. ");
INSERT INTO pesOPV_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","پس جمله ایام نوح نهصد وپنجاه سال بود که مرد. ");
INSERT INTO pesOPV_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","این است پیدایش پسران نوح، سام وحام و یافث. و از ایشان بعد از طوفان پسران متولد شدند. ");
INSERT INTO pesOPV_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","پسران یافث: جومر و ماجوج و مادای ویاوان و توبال و ماشک و تیراس. ");
INSERT INTO pesOPV_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","و پسران جومر: اشکناز و ریفات و توجرمه. ");
INSERT INTO pesOPV_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","و پسران یاوان: الیشه و ترشیش و کتیم و رودانیم. ");
INSERT INTO pesOPV_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","از اینان جزایرامت‌ها منشعب شدند در اراضی خود، هر یکی موافق زبان و قبیله‌اش در امت های خویش. ");
INSERT INTO pesOPV_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","و پسران حام: کوش و مصرایم و فوط وکنعان. ");
INSERT INTO pesOPV_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","و پسران کوش: سبا و حویله و سبته ورعمه و سبتکا. و پسران رعمه: شبا و ددان. ");
INSERT INTO pesOPV_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","وکوش نمرود را آورد. او به جبار شدن در جهان شروع کرد. ");
INSERT INTO pesOPV_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","وی در حضور خداوند صیادی جبار بود. از این جهت می‌گویند: «مثل نمرود، صیاد جبار در حضور خداوند.» ");
INSERT INTO pesOPV_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","و ابتدای مملکت وی، بابل بود و ارک و اکد و کلنه در زمین شنعار. ");
INSERT INTO pesOPV_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","از آن زمین آشور بیرون رفت، و نینوا ورحوبوت عیر، و کالح را بنا نهاد، ");
INSERT INTO pesOPV_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","و ریسن را درمیان نینوا و کالح. و آن شهری بزرگ بود. ");
INSERT INTO pesOPV_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","ومصرایم لودیم و عنامیم و لهابیم و نفتوحیم راآورد. ");
INSERT INTO pesOPV_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","و فتروسیم و کسلوحیم را که از ایشان فلسطینیان پدید آمدند و کفتوریم را. ");
INSERT INTO pesOPV_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","و کنعان، صیدون، نخست زاده خود، وحت را آورد. ");
INSERT INTO pesOPV_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","ویبوسیان و اموریان و جرجاشیان را ");
INSERT INTO pesOPV_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","و حویان وعرقیان و سینیان را ");
INSERT INTO pesOPV_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","و اروادیان و صماریان وحماتیان را. و بعد از آن، قبایل کنعانیان منشعب شدند. ");
INSERT INTO pesOPV_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","و سرحد کنعانیان از صیدون به سمت جرار تا غزه بود، و به سمت سدوم و عموره وادمه و صبوئیم تا به لاشع. ");
INSERT INTO pesOPV_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","اینانند پسران حام برحسب قبایل و زبانهای ایشان، در اراضی وامت های خود. ");
INSERT INTO pesOPV_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","و از سام که پدر جمیع بنی عابر و برادریافث بزرگ بود، از او نیز اولاد متولد شد. ");
INSERT INTO pesOPV_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","پسران سام: عیلام و آشور و ارفکشاد و لود وارام. ");
INSERT INTO pesOPV_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","و پسران ارام: عوص و حول و جاتر وماش. ");
INSERT INTO pesOPV_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","و ارفکشاد، شالح را آورد، و شالح، عابررا آورد. ");
INSERT INTO pesOPV_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","و عابر را دو پسر متولد شد. یکی رافالج نام بود، زیرا که در ایام وی زمین منقسم شد. و نام برادرش یقطان. ");
INSERT INTO pesOPV_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","و یقطان، الموداد و شالف و حضرموت و یارح را آورد، ");
INSERT INTO pesOPV_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","و هدورام واوزال و دقله را، ");
INSERT INTO pesOPV_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","و عوبال و ابیمائیل و شبا را، ");
INSERT INTO pesOPV_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","و اوفیر و حویله و یوباب را. این همه پسران یقطان بودند. ");
INSERT INTO pesOPV_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","و مسکن ایشان از میشا بود به سمت سفاره، که کوهی از کوههای شرقی است. ");
INSERT INTO pesOPV_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","اینانند پسران سام برحسب قبایل و زبانهای ایشان، در اراضی خود برحسب امت های خویش. ");
INSERT INTO pesOPV_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","اینانند قبایل پسران نوح، برحسب پیدایش ایشان در امت های خود که از ایشان امت های جهان، بعد از طوفان منشعب شدند. ");
INSERT INTO pesOPV_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","و تمام جهان را یک زبان و یک لغت بود. ");
INSERT INTO pesOPV_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","و واقع شد که چون از مشرق کوچ می‌کردند، همواری‌ای در زمین شنعار یافتند و درآنجا سکنی گرفتند. ");
INSERT INTO pesOPV_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","و به یکدیگر گفتند: «بیایید، خشتها بسازیم و آنها را خوب بپزیم.» و ایشان راآجر به‌جای سنگ بود، و قیر به‌جای گچ. ");
INSERT INTO pesOPV_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","وگفتند: «بیایید شهری برای خود بنا نهیم، و برجی را که سرش به آسمان برسد، تا نامی برای خویشتن پیدا کنیم، مبادا بر روی تمام زمین پراکنده شویم.» ");
INSERT INTO pesOPV_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","و خداوند نزول نمود تا شهر وبرجی را که بنی آدم بنا می‌کردند، ملاحظه نماید. ");
INSERT INTO pesOPV_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","و خداوند گفت: «همانا قوم یکی است و جمیع ایشان را یک زبان و این کار را شروع کرده‌اند، والان هیچ کاری که قصد آن بکنند، از ایشان ممتنع نخواهد شد. ");
INSERT INTO pesOPV_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","اکنون نازل شویم و زبان ایشان رادر آنجا مشوش سازیم تا سخن یکدیگر رانفهمند.» ");
INSERT INTO pesOPV_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","پس خداوند ایشان را از آنجا بر روی تمام زمین پراکنده ساخت و از بنای شهر بازماندند. ");
INSERT INTO pesOPV_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","از آن سبب آنجا را بابل نامیدند، زیرا که در آنجا خداوند لغت تمامی اهل جهان رامشوش ساخت. و خداوند ایشان را از آنجا برروی تمام زمین پراکنده نمود. ");
INSERT INTO pesOPV_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","این است پیدایش سام. چون سام صد ساله بود، ارفکشاد را دو سال بعد از طوفان آورد. ");
INSERT INTO pesOPV_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","وسام بعد از آوردن ارفکشاد، پانصد سال زندگانی کرد و پسران و دختران آورد. ");
INSERT INTO pesOPV_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","و ارفکشاد سی وپنج سال بزیست و شالح را آورد. ");
INSERT INTO pesOPV_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","و ارفکشادبعد از آوردن شالح، چهار صد و سه سال زندگانی کرد و پسران و دختران آورد. ");
INSERT INTO pesOPV_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","و شالح سی سال بزیست، و عابر را آورد. ");
INSERT INTO pesOPV_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","و شالح بعد از آوردن عابر، چهارصد و سه سال زندگانی کرد و پسران ودختران آورد. ");
INSERT INTO pesOPV_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","و عابر سی و چهار سال بزیست و فالج را آورد. ");
INSERT INTO pesOPV_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","و عابر بعد از آوردن فالج، چهار صد و سی سال زندگانی کرد و پسران ودختران آورد. ");
INSERT INTO pesOPV_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","و فالج سی سال بزیست، و رعورا آورد. ");
INSERT INTO pesOPV_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","و فالج بعد از آوردن رعو، دویست ونه سال زندگانی کرد و پسران و دختران آورد. ");
INSERT INTO pesOPV_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","ورعو سی و دو سال بزیست، و سروج را آورد. ");
INSERT INTO pesOPV_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","ورعو بعد از آوردن سروج، دویست و هفت سال زندگانی کرد و پسران و دختران آورد. ");
INSERT INTO pesOPV_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","وسروج سی سال بزیست، و ناحور را آورد. ");
INSERT INTO pesOPV_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","وسروج بعد از آوردن ناحور، دویست سال بزیست و پسران و دختران آورد. ");
INSERT INTO pesOPV_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","و ناحور بیست و نه سال بزیست، و تارح را آورد. ");
INSERT INTO pesOPV_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","و ناحور بعد ازآوردن تارح، صد و نوزده سال زندگانی کرد وپسران و دختران آورد. ");
INSERT INTO pesOPV_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","و تارح هفتاد سال بزیست، و ابرام و ناحور و هاران را آورد. ");
INSERT INTO pesOPV_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","و این است پیدایش تارح که تارح، ابرام وناحور و هاران را آورد، و هاران، لوط را آورد. ");
INSERT INTO pesOPV_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","وهاران پیش پدر خود، تارح در زادبوم خویش دراور کلدانیان بمرد. ");
INSERT INTO pesOPV_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","و ابرام و ناحور زنان برای خود گرفتند. زن ابرام را سارای نام بود. و زن ناحور را ملکه نام بود، دختر هاران، پدر ملکه وپدر یسکه. ");
INSERT INTO pesOPV_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","اما سارای نازاد مانده، ولدی نیاورد. ");
INSERT INTO pesOPV_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","پس تارح پسر خود ابرام، و نواده خودلوط، پسر هاران، و عروس خود سارای، زوجه پسرش ابرام را برداشته، با ایشان از اور کلدانیان بیرون شدند تا به ارض کنعان بروند، و به حران رسیده، در آنجا توقف نمودند. ");
INSERT INTO pesOPV_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","و مدت زندگانی تارح، دویست و پنج سال بود، و تارح درحران مرد. ");
INSERT INTO pesOPV_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","و خداوند به ابرام گفت: «از ولایت خود، و از مولد خویش و از خانه پدرخود بسوی زمینی که به تو نشان دهم بیرون شو، ");
INSERT INTO pesOPV_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","و از تو امتی عظیم پیدا کنم و تو را برکت دهم، ونام تو را بزرگ سازم، و تو برکت خواهی بود. ");
INSERT INTO pesOPV_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","وبرکت دهم به آنانی که تو را مبارک خوانند، ولعنت کنم به آنکه تو را ملعون خواند. و از توجمیع قبایل جهان برکت خواهند یافت.» ");
INSERT INTO pesOPV_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","پس ابرام، چنانکه خداوند بدو فرموده بود، روانه شد. و لوط همراه وی رفت. و ابرام هفتاد و پنج ساله بود، هنگامی که از حران بیرون آمد. ");
INSERT INTO pesOPV_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","و ابرام زن خود سارای، و برادرزاده خود لوط، و همه اموال اندوخته خود را با اشخاصی که در حران پیداکرده بودند، برداشته، به عزیمت زمین کنعان بیرون شدند، و به زمین کنعان داخل شدند. ");
INSERT INTO pesOPV_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","وابرام در زمین می‌گشت تا مکان شکیم تا بلوطستان موره. و در آنوقت کنعانیان در آن زمین بودند. ");
INSERT INTO pesOPV_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","وخداوند بر ابرام ظاهر شده، گفت: «به ذریت تو این زمین را می‌بخشم.» و در آنجا مذبحی برای خداوند که بر وی ظاهر شد، بنا نمود. ");
INSERT INTO pesOPV_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","پس، ازآنجا به کوهی که به شرقی بیت ئیل است، کوچ کرده، خیمه خود را برپا نمود. و بیت ئیل بطرف غربی و عای بطرف شرقی آن بود. و در آنجامذبحی برای خداوند بنا نمود و نام یهوه را خواند. ");
INSERT INTO pesOPV_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","و ابرام طی مراحل و منازل کرده، به سمت جنوب کوچید. ");
INSERT INTO pesOPV_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","و قحطی در آن زمین شد، و ابرام به مصرفرود آمد تا در آنجا بسر برد، زیرا که قحط درزمین شدت می‌کرد. ");
INSERT INTO pesOPV_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","و واقع شد که چون نزدیک به ورود مصر شد، به زن خود سارای گفت: «اینک می‌دانم که تو زن نیکومنظر هستی. ");
INSERT INTO pesOPV_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","همانا چون اهل مصر تو را بینند، گویند: “این زوجه اوست.” پس مرا بکشند و تو را زنده نگاه دارند. ");
INSERT INTO pesOPV_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","پس بگو که تو خواهر من هستی تا به‌خاطر تو برای من خیریت شود و جانم بسبب توزنده ماند.» ");
INSERT INTO pesOPV_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","و به مجرد ورود ابرام به مصر، اهل مصر آن زن را دیدند که بسیار خوش منظر است. ");
INSERT INTO pesOPV_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","و امرای فرعون او را دیدند، و او را درحضور فرعون ستودند. پس وی را به خانه فرعون در‌آوردند. ");
INSERT INTO pesOPV_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","و بخاطر وی با ابرام احسان نمود، و او صاحب میشها و گاوان وحماران و غلامان و کنیزان و ماده الاغان وشتران شد. ");
INSERT INTO pesOPV_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","و خداوند فرعون و اهل خانه اورا بسبب سارای، زوجه ابرام به بلایای سخت مبتلا ساخت. ");
INSERT INTO pesOPV_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","و فرعون ابرام را خوانده، گفت: «این چیست که به من کردی؟ چرا مرا خبرندادی که او زوجه توست؟ ");
INSERT INTO pesOPV_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","چرا گفتی: اوخواهر منست، که او را به زنی گرفتم؟ و الان، اینک زوجه تو. او را برداشته، روانه شو!» ");
INSERT INTO pesOPV_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","آنگاه فرعون در خصوص وی، کسان خود راامر فرمود تا او را با زوجه‌اش و تمام مایملکش روانه نمودند. ");
INSERT INTO pesOPV_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","و ابرام با زن خود، و تمام اموال خویش، و لوط، از مصر به جنوب آمدند. ");
INSERT INTO pesOPV_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","وابرام از مواشی و نقره و طلا، بسیار دولتمند بود. ");
INSERT INTO pesOPV_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","پس، از جنوب، طی منازل کرده، به بیت ئیل آمد، بدانجایی که خیمه‌اش در ابتدا بود، در میان بیت ئیل و عای، ");
INSERT INTO pesOPV_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","به مقام آن مذبحی که اول بنانهاده بود، و در آنجا ابرام نام یهوه را خواند. ");
INSERT INTO pesOPV_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","ولوط را نیز که همراه ابرام بود، گله و رمه و خیمه هابود. ");
INSERT INTO pesOPV_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","و زمین گنجایش ایشان را نداشت که دریکجا ساکن شوند زیرا که اندوخته های ایشان بسیار بود، و نتوانستند در یک جا سکونت کنند. ");
INSERT INTO pesOPV_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","و در میان شبانان مواشی ابرام و شبانان مواشی لوط نزاع افتاد. و در آن هنگام کنعانیان و فرزیان، ساکن زمین بودند. ");
INSERT INTO pesOPV_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","پس ابرام به لوط گفت: «زنهاردر میان من و تو، و در میان شبانان من و شبانان تونزاعی نباشد، زیرا که ما برادریم. ");
INSERT INTO pesOPV_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","مگر تمام زمین پیش روی تو نیست؟ ملتمس اینکه از من جداشوی. اگر به‌جانب چپ روی، من بسوی راست خواهم رفت و اگر بطرف راست روی، من به‌جانب چپ خواهم رفت.» ");
INSERT INTO pesOPV_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","آنگاه لوط چشمان خود را برافراشت، وتمام وادی اردن را بدید که همه‌اش مانند باغ خداوند و زمین مصر، به طرف صوغر، سیراب بود، قبل از آنکه خداوند سدوم و عموره راخراب سازد. ");
INSERT INTO pesOPV_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","پس لوط تمام وادی اردن را برای خود اختیار کرد، و لوط بطرف شرقی کوچ کرد، واز یکدیگر جدا شدند. ");
INSERT INTO pesOPV_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","ابرام در زمین کنعان ماند، و لوط در بلاد وادی ساکن شد، و خیمه خودرا تا سدوم نقل کرد. ");
INSERT INTO pesOPV_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","لکن مردمان سدوم بسیار شریر و به خداوند خطاکار بودند. ");
INSERT INTO pesOPV_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","و بعد از جداشدن لوط از وی، خداوند به ابرام گفت: «اکنون توچشمان خود را برافراز و از مکانی که در آن هستی، بسوی شمال و جنوب، و مشرق و مغرب بنگر ");
INSERT INTO pesOPV_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","زیرا تمام این زمین را که می‌بینی به تو وذریت تو تا به ابد خواهم بخشید. ");
INSERT INTO pesOPV_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","و ذریت تو رامانند غبار زمین گردانم. چنانکه اگر کسی غبارزمین را تواند شمرد، ذریت تو نیز شمرده شود. ");
INSERT INTO pesOPV_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","برخیز و در طول و عرض زمین گردش کن زیراکه آن را به تو خواهم داد.» ");
INSERT INTO pesOPV_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","و ابرام خیمه خودرا نقل کرده، روانه شد و در بلوطستان ممری که در حبرون است، ساکن گردید، و در آنجا مذبحی برای یهوه بنا نهاد. ");
INSERT INTO pesOPV_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","و واقع شد در ایام امرافل، ملک شنعار، و اریوک، ملک الاسار، و کدرلاعمر، ملک عیلام، و تدعال، ملک امت‌ها، ");
INSERT INTO pesOPV_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","که ایشان بابارع، ملک سدوم، و برشاع ملک عموره، وشناب، ملک ادمه، و شمئیبر، ملک صبوئیم، وملک بالع که صوغر باشد، جنگ کردند. ");
INSERT INTO pesOPV_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","این همه در وادی سدیم که بحرالملح باشد، با هم پیوستند. ");
INSERT INTO pesOPV_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","دوازده سال، کدرلاعمر را بندگی کردند، و در سال سیزدهم، بر وی شوریدند. ");
INSERT INTO pesOPV_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","ودر سال چهاردهم، کدرلاعمر با ملوکی که با وی بودند، آمده، رفائیان را در عشتروت قرنین، وزوزیان را در هام، و ایمیان را در شاوه قریتین، شکست دادند. ");
INSERT INTO pesOPV_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","و حوریان را در کوه ایشان، سعیر، تا ایل فاران که متصل به صحراست. ");
INSERT INTO pesOPV_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","پس برگشته، به عین مشفاط که قادش باشد، آمدند، وتمام مرز و بوم عمالقه و اموریان را نیز که درحصون تامار ساکن بودند، شکست دادند. ");
INSERT INTO pesOPV_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","آنگاه ملک سدوم و ملک عموره و ملک ادمه و ملک صبوئیم و ملک بالع که صوغر باشد، بیرون آمده، با ایشان در وادی سدیم، صف آرایی نمودند. ");
INSERT INTO pesOPV_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","باکدرلاعمر ملک عیلام و تدعال، ملک امت‌ها وامرافل، ملک شنعار و اریوک ملک الاسار، چهارملک با پنج. ");
INSERT INTO pesOPV_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","و وادی سدیم پر از چاههای قیربود. پس ملوک سدوم و عموره گریخته، در آنجاافتادند و باقیان به کوه فرار کردند. ");
INSERT INTO pesOPV_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","و جمیع اموال سدوم و عموره را با تمامی ماکولات آنهاگرفته، برفتند. ");
INSERT INTO pesOPV_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","و لوط، برادرزاده ابرام را که درسدوم ساکن بود، با آنچه داشت برداشته، رفتند. ");
INSERT INTO pesOPV_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","و یکی که نجات یافته بود آمده، ابرام عبرانی را خبر داد. و او در بلوطستان ممری آموری که برادر اشکول و عانر بود، ساکن بود. وایشان با ابرام هم عهد بودند. ");
INSERT INTO pesOPV_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","چون ابرام ازاسیری برادر خود آگاهی یافت، سیصد و هجده تن از خانه زادان کارآزموده خود را بیرون آورده، در عقب ایشان تا دان بتاخت. ");
INSERT INTO pesOPV_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","شبانگاه، او وملازمانش، بر ایشان فرقه فرقه شده، ایشان راشکست داده، تا به حوبه که به شمال دمشق واقع است، تعاقب نمودند. ");
INSERT INTO pesOPV_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","و همه اموال را بازگرفت، و برادر خود، لوط و اموال او را نیز با زنان و مردان باز آورد. ");
INSERT INTO pesOPV_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","و بعد از مراجعت وی از شکست دادن کدرلاعمر و ملوکی که با وی بودند، ملک سدوم تابه وادی شاوه، که وادی الملک باشد، به استقبال وی بیرون آمد. ");
INSERT INTO pesOPV_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","و ملکیصدق، ملک سالیم، نان و شراب بیرون آورد. و او کاهن خدای تعالی بود، ");
INSERT INTO pesOPV_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","و او را مبارک خوانده، گفت: «مبارک باد ابرام ازجانب خدای تعالی، مالک آسمان و زمین. ");
INSERT INTO pesOPV_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","و متبارک باد خدای تعالی، که دشمنانت را به‌دستت تسلیم کرد.» و او را از هر چیز، ده‌یک داد. ");
INSERT INTO pesOPV_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","و ملک سدوم به ابرام گفت: «مردم را به من واگذار و اموال را برای خود نگاه دار.» ");
INSERT INTO pesOPV_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","ابرام به ملک سدوم گفت: «دست خود را به یهوه خدای تعالی، مالک آسمان و زمین، برافراشتم، ");
INSERT INTO pesOPV_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","که ازاموال تو رشته‌ای یا دوال نعلینی بر نگیرم، مباداگویی “من ابرام را دولتمند ساختم”. ");
INSERT INTO pesOPV_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","مگر فقطآنچه جوانان خوردند و بهره عانر و اشکول وممری که همراه من رفتند، ایشان بهره خود رابردارند.» ");
INSERT INTO pesOPV_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","بعد از این وقایع، کلام خداوند دررویا، به ابرام رسیده، گفت: «ای ابرام مترس، من سپر تو هستم، و اجر بسیار عظیم تو.» ");
INSERT INTO pesOPV_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","ابرام گفت: «ای خداوند یهوه، مرا چه خواهی داد، و من بی‌اولاد می‌روم، و مختارخانه‌ام، این العاذار دمشقی است؟» ");
INSERT INTO pesOPV_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","و ابرام گفت: «اینک مرا نسلی ندادی، و خانه زادم وارث من است.» ");
INSERT INTO pesOPV_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","در ساعت، کلام خداوند به وی دررسیده، گفت: «این وارث تو نخواهد بود، بلکه کسی‌که از صلب تو درآید، وارث تو خواهدبود.» ");
INSERT INTO pesOPV_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","و او را بیرون آورده، گفت: «اکنون بسوی آسمان بنگر و ستارگان را بشمار، هرگاه آنها راتوانی شمرد.» پس به وی گفت: «ذریت تو چنین خواهد بود.» ");
INSERT INTO pesOPV_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","و به خداوند ایمان آورد، و او، این را برای وی عدالت محسوب کرد. ");
INSERT INTO pesOPV_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","پس وی راگفت: «من هستم یهوه که تو را از اور کلدانیان بیرون آوردم، تا این زمین را به ارثیت، به تو بخشم.» ");
INSERT INTO pesOPV_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","گفت: «ای خداوند یهوه، به چه نشان بدانم که وارث آن خواهم بود؟» ");
INSERT INTO pesOPV_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","به وی گفت: «گوساله ماده سه ساله و بز ماده سه ساله و قوچی سه ساله و قمری و کبوتری برای من بگیر.» ");
INSERT INTO pesOPV_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","پس این همه را بگرفت، و آنها را از میان، دوپاره کرد، و هر پاره‌ای را مقابل جفتش گذاشت، لکن مرغان را پاره نکرد. ");
INSERT INTO pesOPV_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","و چون لاشخورها برلاشه‌ها فرود آمدند، ابرام آنها را راند. ");
INSERT INTO pesOPV_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","و چون آفتاب غروب می‌کرد، خوابی گران بر ابرام مستولی شد، و اینک تاریکی ترسناک سخت، اورا فرو گرفت. ");
INSERT INTO pesOPV_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","پس به ابرام گفت: «یقین بدان که ذریت تو در زمینی که از آن ایشان نباشد، غریب خواهند بود، و آنها را بندگی خواهند کرد، و آنهاچهارصد سال ایشان را مظلوم خواهند داشت. ");
INSERT INTO pesOPV_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","و بر آن امتی که ایشان بندگان آنها خواهند بود، من داوری خواهم کرد. و بعد از آن با اموال بسیاربیرون خواهند آمد. ");
INSERT INTO pesOPV_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","و تو نزد پدران خود به سلامتی خواهی رفت، و در‌پیری نیکو مدفون خواهی شد. ");
INSERT INTO pesOPV_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","و در پشت چهارم بدینجاخواهند برگشت، زیرا گناه اموریان هنوز تمام نشده است.» ");
INSERT INTO pesOPV_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","و واقع شد که چون آفتاب غروب کرده بودو تاریک شد، تنوری پر دود و چراغی مشتعل ازمیان آن پاره‌ها گذر نمود. ");
INSERT INTO pesOPV_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","در آن روز، خداوندبا ابرام عهد بست و گفت: «این زمین را از نهر مصرتا به نهر عظیم، یعنی نهر فرات، به نسل توبخشیده‌ام، ");
INSERT INTO pesOPV_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","یعنی قینیان و قنزیان و قدمونیان وحتیان و فرزیان و رفائیان، ");
INSERT INTO pesOPV_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","و اموریان و کنعانیان و جرجاشیان و یبوسیان را.» ");
INSERT INTO pesOPV_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","و سارای، زوجه ابرام، برای وی فرزندی نیاورد. و او را کنیزی مصری، هاجر نام بود. ");
INSERT INTO pesOPV_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","پس سارای به ابرام گفت: «اینک خداوند مرا از زاییدن باز داشت. پس به کنیز من درآی، شاید از او بنا شوم.» و ابرام سخن سارای را قبول نمود. ");
INSERT INTO pesOPV_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","و چون ده سال از اقامت ابرام درزمین کنعان سپری شد، سارای زوجه ابرام، کنیزخود هاجر مصری را برداشته، او را به شوهرخود، ابرام، به زنی داد. ");
INSERT INTO pesOPV_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","پس به هاجر درآمد و اوحامله شد. و چون دید که حامله است، خاتونش بنظر وی حقیر شد. ");
INSERT INTO pesOPV_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","و سارای به ابرام گفت: «ظلم من بر تو باد! من کنیز خود را به آغوش تو دادم وچون آثار حمل در خود دید، در نظر او حقیرشدم. خداوند در میان من و تو داوری کند.» ");
INSERT INTO pesOPV_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","ابرام به سارای گفت: «اینک کنیز تو به‌دست توست، آنچه پسند نظر تو باشد با وی بکن.» پس چون سارای با وی بنای سختی نهاد، او از نزد وی بگریخت. ");
INSERT INTO pesOPV_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","و فرشته خداوند او را نزد چشمه آب دربیابان، یعنی چشمه‌ای که به راه شور است، یافت. ");
INSERT INTO pesOPV_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","و گفت: «ای هاجر کنیز سارای، از کجا آمدی وکجا می‌روی؟» گفت: «من از حضور خاتون خودسارای گریخته‌ام.» ");
INSERT INTO pesOPV_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","فرشته خداوند به وی گفت: «نزد خاتون خود برگرد و زیر دست او مطیع شو.» ");
INSERT INTO pesOPV_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","و فرشته خداوند به وی گفت: «ذریت تو رابسیار افزون گردانم، به حدی که از کثرت به شماره نیایند.» ");
INSERT INTO pesOPV_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","و فرشته خداوند وی را گفت: «اینک حامله هستی و پسری خواهی زایید، و او را اسماعیل نام خواهی نهاد، زیرا خداوند تظلم تو را شنیده است. ");
INSERT INTO pesOPV_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","و او مردی وحشی خواهدبود، دست وی به ضد هر کس و دست هر کس به ضد او، و پیش روی همه برادران خود ساکن خواهد بود.» ");
INSERT INTO pesOPV_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","و او، نام خداوند را که با وی تکلم کرد، «انت ایل رئی» خواند، زیرا گفت: «آیا اینجانیز به عقب او که مرا می‌بیند، نگریستم.» ");
INSERT INTO pesOPV_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","از این سبب آن چاه را «بئرلحی رئی» نامیدند، اینک درمیان قادش و بارد است. ");
INSERT INTO pesOPV_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","و هاجر از ابرام پسری زایید، و ابرام پسر خود را که هاجر زایید، اسماعیل نام نهاد. ");
INSERT INTO pesOPV_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","و ابرام هشتاد و شش ساله بود چون هاجر اسماعیل را برای ابرام بزاد. ");
INSERT INTO pesOPV_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","و چون ابرام نود و نه ساله بود، خداوندبر ابرام ظاهر شده، گفت: «من هستم خدای قادر مطلق، پیش روی من بخرام و کامل شو، ");
INSERT INTO pesOPV_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","و عهد خویش را در میان خود و تو خواهم بست، و تو را بسیاربسیار کثیر خواهم گردانید.» ");
INSERT INTO pesOPV_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","آنگاه ابرام به روی در‌افتاد و خدا به وی خطاب کرده، گفت: ");
INSERT INTO pesOPV_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","«اما من اینک عهد من با توست و توپدر امت های بسیار خواهی بود. ");
INSERT INTO pesOPV_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","و نام تو بعد ازاین ابرام خوانده نشود بلکه نام تو ابراهیم خواهدبود، زیرا که تو را پدر امت های بسیار گردانیدم. ");
INSERT INTO pesOPV_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","و تو را بسیار بارور نمایم و امت‌ها از تو پدیدآورم و پادشاهان از تو به وجود آیند. ");
INSERT INTO pesOPV_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","و عهدخویش را در میان خود و تو، و ذریتت بعد از تو، استوار گردانم که نسلا بعد نسل عهد جاودانی باشد، تا تو را و بعد از تو ذریت تو را خدا باشم. ");
INSERT INTO pesOPV_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","وزمین غربت تو، یعنی تمام زمین کنعان را، به تو و بعد از تو به ذریت تو به ملکیت ابدی دهم، وخدای ایشان خواهم بود.» ");
INSERT INTO pesOPV_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","پس خدا به ابراهیم گفت: «و اما تو عهد مرا نگاه دار، تو و بعد از توذریت تو در نسلهای ایشان. ");
INSERT INTO pesOPV_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","این است عهد من که نگاه خواهید داشت، در میان من و شما و ذریت تو بعد از تو هر ذکوری از شما مختون شود، ");
INSERT INTO pesOPV_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","وگوشت قلفه خود را مختون سازید، تا نشان آن عهدی باشد که در میان من و شماست. ");
INSERT INTO pesOPV_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","هر پسرهشت روزه از شما مختون شود. هر ذکوری درنسلهای شما، خواه خانه زاد خواه زرخرید، ازاولاد هر اجنبی که از ذریت تو نباشد، ");
INSERT INTO pesOPV_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","هرخانه زاد تو و هر زر خرید تو البته مختون شود تاعهد من در گوشت شما عهد جاودانی باشد. ");
INSERT INTO pesOPV_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","واما هر ذکور نامختون که گوشت قلفه او ختنه نشود، آن کس از قوم خود منقطع شود، زیرا که عهد مرا شکسته است.» ");
INSERT INTO pesOPV_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","و خدا به ابراهیم گفت: «اما زوجه توسارای، نام او را سارای مخوان، بلکه نام او ساره باشد. ");
INSERT INTO pesOPV_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","و او را برکت خواهم داد و پسری نیز ازوی به تو خواهم بخشید. او را برکت خواهم داد وامتها از وی به وجود خواهند آمد، و ملوک امتهااز وی پدید خواهند شد.» ");
INSERT INTO pesOPV_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","آنگاه ابراهیم به روی در‌افتاده، بخندید و در دل خود گفت: «آیابرای مرد صد ساله پسری متولد شود و ساره درنود سالگی بزاید؟» ");
INSERT INTO pesOPV_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","و ابراهیم به خدا گفت: «کاش که اسماعیل در حضور تو زیست کند.» ");
INSERT INTO pesOPV_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","خدا گفت: «به تحقیق زوجه ات ساره برای توپسری خواهد زایید، و او را اسحاق نام بنه، و عهدخود را با وی استوار خواهم داشت، تا با ذریت اوبعد از او عهد ابدی باشد. ");
INSERT INTO pesOPV_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","و اما در خصوص اسماعیل، تو را اجابت فرمودم. اینک او را برکت داده، بارور گردانم، و او را بسیار کثیر گردانم. دوازده رئیس از وی پدید آیند، و امتی عظیم ازوی بوجود آورم. ");
INSERT INTO pesOPV_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","لکن عهد خود را با اسحاق استوار خواهم ساخت، که ساره او را بدین وقت در سال آینده برای تو خواهد زایید.» ");
INSERT INTO pesOPV_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","و چون خدا از سخن‌گفتن با وی فارغ شد، از نزد ابراهیم صعود فرمود. ");
INSERT INTO pesOPV_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","و ابراهیم پسر خود، اسماعیل وهمه خانه زادان و زرخریدان خود را، یعنی هرذکوری که در خانه ابراهیم بود، گرفته، گوشت قلفه ایشان را در همان روز ختنه کرد، چنانکه خدا به وی امر فرموده بود. ");
INSERT INTO pesOPV_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","و ابراهیم نود و نه ساله بود، وقتی که گوشت قلفه‌اش مختون شد. ");
INSERT INTO pesOPV_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","و پسرش، اسماعیل سیزده ساله بود هنگامی که گوشت قلفه‌اش مختون شد. ");
INSERT INTO pesOPV_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","در همان روزابراهیم و پسرش، اسماعیل مختون گشتند. ");
INSERT INTO pesOPV_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","وهمه مردان خانه‌اش، خواه خانه زاد، خواه زرخرید از اولاد اجنبی، با وی مختون شدند. ");
INSERT INTO pesOPV_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","و خداوند در بلوطستان ممری، بروی ظاهر شد، و او در گرمای روز به درخیمه نشسته بود. ");
INSERT INTO pesOPV_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","ناگاه چشمان خود را بلندکرده، دید که اینک سه مرد در مقابل اوایستاده‌اند. و چون ایشان را دید، از در خیمه به استقبال ایشان شتافت، و رو بر زمین نهاد ");
INSERT INTO pesOPV_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","و گفت: «ای مولا، اکنون اگر منظور نظر تو شدم، از نزدبنده خود مگذر، ");
INSERT INTO pesOPV_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","اندک آبی بیاورند تا پای خودرا شسته، در زیر درخت بیارامید، ");
INSERT INTO pesOPV_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","و لقمه نانی بیاورم تا دلهای خود را تقویت دهید و پس از آن روانه شوید، زیرا برای همین، شما را بر بنده خودگذر افتاده است.» گفتند: «آنچه گفتی بکن.» ");
INSERT INTO pesOPV_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","پس ابراهیم به خیمه، نزد ساره شتافت و گفت: «سه کیل از آرد میده بزودی حاضر کن و آن را خمیرکرده، گرده‌ها بساز.» ");
INSERT INTO pesOPV_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","و ابراهیم به سوی رمه شتافت و گوساله نازک خوب گرفته، به غلام خودداد تا بزودی آن را طبخ نماید. ");
INSERT INTO pesOPV_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","پس کره و شیر وگوساله‌ای را که ساخته بود، گرفته، پیش روی ایشان گذاشت، و خود در مقابل ایشان زیردرخت ایستاد تا خوردند. ");
INSERT INTO pesOPV_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","به وی گفتند: «زوجه ات ساره کجاست؟» گفت: «اینک درخیمه است.» ");
INSERT INTO pesOPV_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","گفت: «البته موافق زمان حیات، نزد تو خواهم برگشت، و زوجه ات ساره را پسری خواهد شد.» و ساره به در خیمه‌ای که در عقب اوبود، شنید. ");
INSERT INTO pesOPV_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","و ابراهیم و ساره پیر و سالخورده بودند، و عادت زنان از ساره منقطع شده بود. ");
INSERT INTO pesOPV_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","پس ساره در دل خود بخندید و گفت: «آیا بعداز فرسودگی‌ام مرا شادی خواهد بود، و آقایم نیزپیر شده است؟» ");
INSERT INTO pesOPV_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","و خداوند به ابراهیم گفت: «ساره برای چه خندید؟» و گفت: «آیا فی الحقیقه خواهم زایید و حال آنکه پیر هستم؟» ");
INSERT INTO pesOPV_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","«مگرهیچ امری نزد خداوند مشکل است؟ در وقت موعود، موافق زمان حیات، نزد تو خواهم برگشت و ساره را پسری خواهد شد.» ");
INSERT INTO pesOPV_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","آنگاه ساره انکار کرده، گفت: «نخندیدم»، چونکه ترسید. گفت: «نی، بلکه خندیدی.» ");
INSERT INTO pesOPV_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","پس، آن مردان از آنجا برخاسته، متوجه سدوم شدند، و ابراهیم ایشان را مشایعت نمود. ");
INSERT INTO pesOPV_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","و خداوند گفت: «آیا آنچه من می‌کنم ازابراهیم مخفی دارم؟ ");
INSERT INTO pesOPV_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","و حال آنکه از ابراهیم هرآینه امتی بزرگ و زورآور پدید خواهد آمد، وجمیع امت های جهان از او برکت خواهند یافت. ");
INSERT INTO pesOPV_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","زیرا او را می‌شناسم که فرزندان و اهل خانه خود را بعد از خود امر خواهد فرمود تا طریق خداوند را حفظ نمایند، و عدالت و انصاف را بجاآورند، تا خداوند آنچه به ابراهیم گفته است، به وی برساند.» ");
INSERT INTO pesOPV_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","پس خداوند گفت: «چونکه فریاد سدوم و عموره زیاد شده است، و خطایای ایشان بسیار گران، ");
INSERT INTO pesOPV_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","اکنون نازل می‌شوم تا ببینم موافق این فریادی که به من رسیده، بالتمام کرده اندوالا خواهم دانست.» ");
INSERT INTO pesOPV_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","آنگاه آن مردان از آنجابسوی سدوم متوجه شده، برفتند. و ابراهیم درحضور خداوند هنوز ایستاده بود. ");
INSERT INTO pesOPV_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","و ابراهیم نزدیک آمده، گفت: «آیا عادل را با شریر هلاک خواهی کرد؟ ");
INSERT INTO pesOPV_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","شاید در شهر پنجاه عادل باشند، آیا آن را هلاک خواهی کرد و آن مکان را بخاطرآن پنجاه عادل که در آن باشند، نجات نخواهی داد؟ ");
INSERT INTO pesOPV_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","حاشا از تو که مثل این کار بکنی که عادلان را با شریران هلاک سازی و عادل و شریر مساوی باشند. حاشا از تو آیا داور تمام جهان، انصاف نخواهد کرد؟» ");
INSERT INTO pesOPV_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","خداوند گفت: «اگر پنجاه عادل در شهر سدوم یابم هر آینه تمام آن مکان را به‌خاطر ایشان رهایی دهم.» ");
INSERT INTO pesOPV_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","ابراهیم در جواب گفت: «اینک من که خاک و خاکستر هستم جرات کردم که به خداوند سخن گویم. ");
INSERT INTO pesOPV_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","شاید از آن پنجاه عادل پنج کم باشد، آیا تمام شهر را بسبب پنج، هلاک خواهی کرد؟» گفت: «اگر‌چهل و پنج در آنجا یابم، آن را هلاک نکنم.» ");
INSERT INTO pesOPV_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","بار دیگر بدو عرض کرده، گفت: «هر گاه در آنجا چهل یافت شوند؟» گفت: «به‌خاطر چهل آن را نکنم.» ");
INSERT INTO pesOPV_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","گفت: «زنهار غضب خداوند افروخته نشود تاسخن گویم، شاید در آنجا سی پیدا شوند؟» گفت: «اگر در آنجا سی یابم، این کار را نخواهم کرد.» ");
INSERT INTO pesOPV_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","گفت: «اینک جرات کردم که به خداوندعرض کنم. اگر بیست در آنجا یافت شوند؟» گفت: «به‌خاطر بیست آن را هلاک نکنم.» ");
INSERT INTO pesOPV_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","گفت: «خشم خداوند، افروخته نشود تا این دفعه را فقط عرض کنم، شاید ده در آنجا یافت شوند؟» گفت: «به‌خاطر ده آن را هلاک نخواهم ساخت.» ");
INSERT INTO pesOPV_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","پس خداوند چون گفتگو را با ابراهیم به اتمام رسانید، برفت و ابراهیم به مکان خویش مراجعت کرد. ");
INSERT INTO pesOPV_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","و وقت عصر، آن دو فرشته وارد سدوم شدند، و لوط به دروازه سدوم نشسته بود. و چون لوط ایشان را بدید، به استقبال ایشان برخاسته، رو بر زمین نهاد ");
INSERT INTO pesOPV_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","و گفت: «اینک اکنون‌ای آقایان من، به خانه بنده خود بیایید، و شب رابسر برید، و پایهای خود را بشویید و بامدادان برخاسته، راه خود را پیش گیرید.» گفتند: «نی، بلکه شب را در کوچه بسر بریم.» ");
INSERT INTO pesOPV_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","اما چون ایشان را الحاح بسیار نمود، با او آمده، به خانه‌اش داخل شدند، و برای ایشان ضیافتی نمود و نان فطیرپخت، پس تناول کردند. ");
INSERT INTO pesOPV_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","و به خواب هنوز نرفته بودند که مردان شهر، یعنی مردم سدوم، از جوان و پیر، تمام قوم از هر جانب، خانه وی را احاطه کردند. ");
INSERT INTO pesOPV_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","و به لوط ندا در‌داده، گفتند: «آن دو مرد که امشب به نزد تو درآمدند، کجا هستند؟ آنها رانزد ما بیرون آور تا ایشان را بشناسیم.» ");
INSERT INTO pesOPV_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","آنگاه لوط نزد ایشان، بدرگاه بیرون آمد و در را از عقب خود ببست ");
INSERT INTO pesOPV_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","و گفت: «ای برادران من، زنهار بدی مکنید. ");
INSERT INTO pesOPV_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","اینک من دو دختر دارم که مرد رانشناخته‌اند. ایشان را الان نزد شما بیرون آورم وآنچه در نظر شما پسند آید، با ایشان بکنید. لکن کاری بدین دو مرد ندارید، زیرا که برای همین زیرسایه سقف من آمده‌اند.» ");
INSERT INTO pesOPV_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","گفتند: «دور شو.» وگفتند: «این یکی آمد تا نزیل ما شود و پیوسته داوری می‌کند. الان با تو از ایشان بدتر کنیم.» پس بر آن مرد، یعنی لوط، بشدت هجوم آورده، نزدیک آمدند تا در را بشکنند. ");
INSERT INTO pesOPV_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","آنگاه آن دو مرد، دست خود را پیش آورده، لوط را نزد خود به خانه درآوردند و در رابستند. ");
INSERT INTO pesOPV_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","اما آن اشخاصی را که به در خانه بودند، از خرد و بزرگ، به کوری مبتلا کردند، که ازجستن در، خویشتن را خسته ساختند. ");
INSERT INTO pesOPV_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","و آن دومرد به لوط گفتند: «آیا کسی دیگر دراینجا داری؟ دامادان و پسران و دختران خود و هر‌که را درشهر داری، از این مکان بیرون آور، ");
INSERT INTO pesOPV_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","زیرا که مااین مکان را هلاک خواهیم ساخت، چونکه فریادشدید ایشان به حضور خداوند رسیده و خداوندما را فرستاده است تا آن را هلاک کنیم.» ");
INSERT INTO pesOPV_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","پس لوط بیرون رفته، با دامادان خود که دختران او راگرفتند، مکالمه کرده، گفت: «برخیزید و از این مکان بیرون شوید، زیرا خداوند این شهر را هلاک می‌کند.» اما بنظر دامادان مسخره آمد. ");
INSERT INTO pesOPV_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","و هنگام طلوع فجر، آن دو فرشته، لوط را شتابانیده، گفتند: «برخیز و زن خود را با این دودختر که حاضرند بردار، مبادا در گناه شهر هلاک شوی.» ");
INSERT INTO pesOPV_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","و چون تاخیر می‌نمود، آن مردان، دست او و دست زنش و دست هر دو دخترش راگرفتند، چونکه خداوند بر وی شفقت نمود و اورا بیرون آورده، در خارج شهر گذاشتند. ");
INSERT INTO pesOPV_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","وواقع شد چون ایشان را بیرون آورده بودند که یکی به وی گفت: «جان خود را دریاب و از عقب منگر، و در تمام وادی مایست، بلکه به کوه بگریز، مبادا هلاک شوی.» ");
INSERT INTO pesOPV_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","لوط بدیشان گفت: «ای آقاچنین مباد! ");
INSERT INTO pesOPV_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","همانا بنده ات در نظرت التفات یافته است و احسانی عظیم به من کردی که جانم را رستگار ساختی، و من قدرت آن ندارم که به کوه فرار کنم، مبادا این بلا مرا فرو‌گیرد و بمیرم. ");
INSERT INTO pesOPV_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","اینک این شهر نزدیک است تا بدان فرار کنم، ونیز صغیر است. اذن بده تا بدان فرار کنم. آیا صغیرنیست، تا جانم زنده ماند.» ");
INSERT INTO pesOPV_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","بدو گفت: «اینک دراین امر نیز تو را اجابت فرمودم، تا شهری را که سفارش آن را نمودی، واژگون نسازم. ");
INSERT INTO pesOPV_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","بدان جابزودی فرار کن، زیرا که تا تو بدانجا نرسی، هیچ نمی توانم کرد.» از این سبب آن شهر مسمی به صوغر شد. ");
INSERT INTO pesOPV_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","و چون آفتاب بر زمین طلوع کرد، لوط به صوغر داخل شد. ");
INSERT INTO pesOPV_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","آنگاه خداوند برسدوم و عموره، گوگرد و آتش، از حضورخداوند از آسمان بارانید. ");
INSERT INTO pesOPV_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","و آن شهرها، و تمام وادی، و جمیع سکنه شهرها و نباتات زمین راواژگون ساخت. ");
INSERT INTO pesOPV_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","اما زن او، از عقب خودنگریسته، ستونی از نمک گردید. ");
INSERT INTO pesOPV_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","بامدادان، ابراهیم برخاست و به سوی آن مکانی که در آن به حضور خداوند ایستاده بود، رفت. ");
INSERT INTO pesOPV_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","و چون به سوی سدوم و عموره، و تمام زمین وادی نظر انداخت، دید که اینک دود آن زمین، چون دود کوره بالا می‌رود. ");
INSERT INTO pesOPV_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","و هنگامی که خدا، شهرهای وادی را هلاک کرد، خدا، ابراهیم را به یاد آورد، و لوط را از آن انقلاب بیرون آورد، چون آن شهرهایی را که لوط در آنهاساکن بود، واژگون ساخت. ");
INSERT INTO pesOPV_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","و لوط از صوغر برآمد و با دو دختر خوددر کوه ساکن شد زیرا ترسید که در صوغر بماند. پس با دو دختر خود در مغاره سکنی گرفت. ");
INSERT INTO pesOPV_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","ودختر بزرگ به کوچک گفت: «پدر ما پیر شده ومردی بر روی زمین نیست که برحسب عادت کل جهان، به ما در‌آید. ");
INSERT INTO pesOPV_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","بیا تا پدر خود را شراب بنوشانیم، و با او هم بستر شویم، تا نسلی از پدرخود نگاه داریم.» ");
INSERT INTO pesOPV_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","پس در همان شب، پدر خودرا شراب نوشانیدند، و دختر بزرگ آمده با پدرخویش همخواب شد، و او از خوابیدن وبرخاستن وی آگاه نشد. ");
INSERT INTO pesOPV_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","و واقع شد که روزدیگر، بزرگ به کوچک گفت: «اینک دوش با پدرم همخواب شدم، امشب نیز او را شراب بنوشانیم، و تو بیا و با وی همخواب شو، تا نسلی از پدرخود نگاه داریم.» ");
INSERT INTO pesOPV_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","آن شب نیز پدر خود راشراب نوشانیدند، و دختر کوچک همخواب وی شد، و او از خوابیدن و برخاستن وی آگاه نشد. ");
INSERT INTO pesOPV_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","پس هر دو دختر لوط از پدر خود حامله شدند. ");
INSERT INTO pesOPV_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","و آن بزرگ، پسری زاییده، او را موآب نام نهاد، و او تا امروز پدر موآبیان است. ");
INSERT INTO pesOPV_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","و کوچک نیز پسری بزاد، و او را بن عمی نام نهاد. وی تا بحال پدر بنی عمون است. ");
INSERT INTO pesOPV_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","پس ابراهیم از آنجا بسوی ارض جنوبی کوچ کرد، و در میان قادش وشور، ساکن شد و در جرار منزل گرفت. ");
INSERT INTO pesOPV_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","وابراهیم در خصوص زن خود، ساره، گفت که «اوخواهر من است.» و ابی ملک، ملک جرار، فرستاده، ساره را گرفت. ");
INSERT INTO pesOPV_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","و خدا در رویای شب، بر ابی ملک ظاهر شده، به وی گفت: «اینک تومرده‌ای بسبب این زن که گرفتی، زیرا که زوجه دیگری می‌باشد.» ");
INSERT INTO pesOPV_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","و ابی ملک، هنوز به اونزدیکی نکرده بود. پس گفت: «ای خداوند، آیاامتی عادل را هلاک خواهی کرد؟ ");
INSERT INTO pesOPV_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","مگر او به من نگفت که “او خواهر من است “، و او نیز خود گفت که “او برادر من است؟” به ساده دلی و پاک دستی خود این را کردم.» ");
INSERT INTO pesOPV_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","خدا وی را در رویا گفت: «من نیز می‌دانم که این را به ساده دلی خود کردی، و من نیز تو را نگاه داشتم که به من خطا نورزی، و از این سبب نگذاشتم که او را لمس نمایی. ");
INSERT INTO pesOPV_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","پس الان زوجه این مرد را رد کن، زیرا که او نبی است، وبرای تو دعا خواهد کرد تا زنده بمانی، و اگر او رارد نکنی، بدان که تو و هر‌که از آن تو باشد، هرآینه خواهید مرد.» ");
INSERT INTO pesOPV_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","بامدادان، ابی ملک برخاسته، جمیع خادمان خود را طلبیده، همه این امور را به سمع ایشان رسانید، و ایشان بسیار ترسان شدند. ");
INSERT INTO pesOPV_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","پس ابی ملک، ابراهیم را خوانده، بدو گفت: «به ما چه کردی؟ و به تو چه گناه کرده بودم، که بر من و بر مملکت من گناهی عظیم آوردی و کارهای ناکردنی به من کردی؟» ");
INSERT INTO pesOPV_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","و ابی ملک به ابراهیم گفت: «چه دیدی که این کار را کردی؟» ");
INSERT INTO pesOPV_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","ابراهیم گفت: «زیرا گمان بردم که خداترسی در این مکان نباشد، و مرا به جهت زوجه‌ام خواهند کشت. ");
INSERT INTO pesOPV_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","وفی الواقع نیز او خواهر من است، دختر پدرم، اما نه دختر مادرم، و زوجه من شد. ");
INSERT INTO pesOPV_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","و هنگامی که خدا مرا از خانه پدرم آواره کرد، او را گفتم: احسانی که به من باید کرد، این است که هر جابرویم، درباره من بگویی که او برادر من است.» ");
INSERT INTO pesOPV_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","پس ابی ملک، گوسفندان و گاوان و غلامان وکنیزان گرفته، به ابراهیم بخشید، و زوجه‌اش ساره را به وی رد کرد. ");
INSERT INTO pesOPV_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","و ابی ملک گفت: «اینک زمین من پیش روی توست، هر جا که پسند نظرت افتد، ساکن شو.» ");
INSERT INTO pesOPV_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","و به ساره گفت: «اینک هزار مثقال نقره به برادرت دادم، همانا او برای تو پرده چشم است، نزد همه کسانی که با تو هستند، و نزد همه دیگران، پس انصاف تو داده شد.» ");
INSERT INTO pesOPV_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","و ابراهیم نزدخدا دعا کرد. و خدا ابی ملک، و زوجه او وکنیزانش را شفا بخشید، تا اولاد بهم رسانیدند، ");
INSERT INTO pesOPV_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","زیرا خداوند، رحم های تمام اهل بیت ابی ملک را بخاطر ساره، زوجه ابراهیم بسته بود. ");
INSERT INTO pesOPV_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","و خداوند برحسب وعده خود، ازساره تفقد نمود، و خداوند، آنچه به ساره گفته بود، بجا آورد. ");
INSERT INTO pesOPV_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","و ساره حامله شده، ازابراهیم در‌پیری‌اش، پسری زایید، در وقتی که خدا به وی گفته بود. ");
INSERT INTO pesOPV_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","و ابراهیم، پسر مولود خودرا، که ساره از وی زایید، اسحاق نام نهاد. ");
INSERT INTO pesOPV_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","و ابراهیم پسر خود اسحاق را، چون هشت روزه بود، مختون ساخت، چنانکه خدا او را امر فرموده بود. ");
INSERT INTO pesOPV_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","و ابراهیم، در هنگام ولادت پسرش، اسحاق، صد ساله بود. ");
INSERT INTO pesOPV_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","و ساره گفت: «خدا خنده برای من ساخت، و هر‌که بشنود، با من خواهدخندید.» ");
INSERT INTO pesOPV_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","و گفت: «که بود که به ابراهیم بگوید، ساره اولاد را شیر خواهد داد؟ زیرا که پسری برای وی، در‌پیری‌اش زاییدم.» ");
INSERT INTO pesOPV_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","و آن پسر نموکرد، تا او را از شیر باز گرفتند. و در روزی که اسحاق را از شیر باز داشتند، ابراهیم ضیافتی عظیم کرد. ");
INSERT INTO pesOPV_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","آنگاه ساره، پسر هاجر مصری را که ازابراهیم زاییده بود، دید که خنده می‌کند. ");
INSERT INTO pesOPV_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","پس به ابراهیم گفت: «این کنیز را با پسرش بیرون کن، زیرا که پسر کنیز با پسر من اسحاق، وارث نخواهد بود.» ");
INSERT INTO pesOPV_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","اما این امر، بنظر ابراهیم، درباره پسرش بسیار سخت آمد. ");
INSERT INTO pesOPV_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","خدا به ابراهیم گفت: «درباره پسر خود و کنیزت، بنظرت سخت نیاید، بلکه هر‌آنچه ساره به تو گفته است، سخن او رابشنو، زیرا که ذریت تو از اسحاق خوانده خواهدشد. ");
INSERT INTO pesOPV_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","و از پسر کنیز نیز امتی بوجود آورم، زیراکه او نسل توست.» ");
INSERT INTO pesOPV_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","بامدادان، ابراهیم برخاسته، نان و مشکی از آب گرفته، به هاجر داد، و آنها را بر دوش وی نهاد، و او را با پسر روانه کرد. پس رفت، و در بیابان بئرشبع می‌گشت. ");
INSERT INTO pesOPV_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","وچون آب مشک تمام شد، پسر را زیر بوته‌ای گذاشت. ");
INSERT INTO pesOPV_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","و به مسافت تیر پرتابی رفته، در مقابل وی بنشست، زیرا گفت: «موت پسر را نبینم.» و در مقابل او نشسته، آواز خود را بلند کرد وبگریست. ");
INSERT INTO pesOPV_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","و خدا، آواز پسر را بشنید، و فرشته خدا از آسمان، هاجر را ندا کرده، وی را گفت: «ای هاجر، تو را چه شد؟ ترسان مباش، زیراخدا، آواز پسر را در آنجایی که اوست، شنیده است. ");
INSERT INTO pesOPV_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","برخیز و پسر را برداشته، او را به‌دست خود بگیر، زیرا که از او، امتی عظیم بوجودخواهم آورد.» ");
INSERT INTO pesOPV_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","و خدا چشمان او را باز کرد تاچاه آبی دید. پس رفته، مشک را از آب پر کرد، وپسر را نوشانید. ");
INSERT INTO pesOPV_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","و خدا با آن پسر می‌بود. و اونمو کرده، ساکن صحرا شد، و در تیراندازی بزرگ گردید. ");
INSERT INTO pesOPV_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","و در صحرای فاران، ساکن شد. ومادرش زنی از زمین مصر برایش گرفت. ");
INSERT INTO pesOPV_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","و واقع شد، در آن زمانی که ابی ملک، وفیکول، که سپهسالار او بود، ابراهیم را عرض کرده، گفتند که «خدا در آنچه می‌کنی با توست. ");
INSERT INTO pesOPV_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","اکنون برای من، در اینجا به خدا سوگند بخور، که با من و نسل من و ذریت من خیانت نخواهی کرد، بلکه برحسب احسانی که با تو کرده‌ام، با من و با زمینی که در آن غربت پذیرفتی، عمل خواهی نمود.» ");
INSERT INTO pesOPV_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","ابراهیم گفت: «من سوگند می‌خورم.» ");
INSERT INTO pesOPV_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","و ابراهیم ابی ملک را تنبیه کرد، بسبب چاه آبی که خادمان ابی ملک، از او به زور گرفته بودند. ");
INSERT INTO pesOPV_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","ابی ملک گفت: «نمی دانم کیست که این کار راکرده است، و تو نیز مرا خبر ندادی، و من هم تاامروز نشنیده بودم.» ");
INSERT INTO pesOPV_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","و ابراهیم، گوسفندان وگاوان گرفته، به ابی ملک داد، و با یکدیگر عهدبستند. ");
INSERT INTO pesOPV_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","و ابراهیم، هفت بره از گله جدا ساخت. ");
INSERT INTO pesOPV_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","گفت: «که این هفت بره ماده را از دست من قبول فرمای، تا شهادت باشدکه این چاه را من حفر نمودم.» ");
INSERT INTO pesOPV_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","از این سبب، آن مکان را، بئرشبع نامید، زیرا که در آنجا با یکدیگرقسم خوردند. ");
INSERT INTO pesOPV_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","و چون آن عهد را در بئرشبع بسته بودند، ابی ملک با سپهسالار خود فیکول برخاسته، به زمین فلسطینیان مراجعت کردند. ");
INSERT INTO pesOPV_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","و ابراهیم در بئرشبع، شوره کزی غرس نمود، ودر آنجا به نام یهوه، خدای سرمدی، دعا نمود. ");
INSERT INTO pesOPV_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","پس ابراهیم در زمین فلسطینیان، ایام بسیاری بسر برد. ");
INSERT INTO pesOPV_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","و واقع شد بعد از این وقایع، که خداابراهیم را امتحان کرده، بدو گفت: «ای ابراهیم!» عرض کرد: «لبیک.» ");
INSERT INTO pesOPV_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","گفت: «اکنون پسرخود را، که یگانه توست و او را دوست می‌داری، یعنی اسحاق را بردار و به زمین موریا برو، و او رادر آنجا، بر یکی از کوههایی که به تو نشان می‌دهم، برای قربانی سوختنی بگذران.» ");
INSERT INTO pesOPV_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","بامدادان، ابراهیم برخاسته، الاغ خود رابیاراست، و دو نفر از نوکران خود را، با پسرخویش اسحاق، برداشته و هیزم برای قربانی سوختنی، شکسته، روانه شد، و به سوی آن مکانی که خدا او را فرموده بود، رفت. ");
INSERT INTO pesOPV_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","و در روزسوم، ابراهیم چشمان خود را بلند کرده، آن مکان را از دور دید. ");
INSERT INTO pesOPV_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","آنگاه ابراهیم، به خادمان خودگفت: «شما در اینجا نزد الاغ بمانید، تا من با پسربدانجا رویم، و عبادت کرده، نزد شما بازآییم.» ");
INSERT INTO pesOPV_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","پس ابراهیم، هیزم قربانی سوختنی را گرفته، بر پسر خود اسحاق نهاد، و آتش و کارد را به‌دست خود گرفت؛ و هر دو با هم می‌رفتند. ");
INSERT INTO pesOPV_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","واسحاق پدر خود، ابراهیم را خطاب کرده، گفت: «ای پدر من!» گفت: «ای پسر من لبیک؟» گفت: «اینک آتش و هیزم، لکن بره قربانی کجاست؟» ");
INSERT INTO pesOPV_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","ابراهیم گفت: «ای پسر من، خدا بره قربانی رابرای خود مهیا خواهد ساخت.» و هر دو با هم رفتند. ");
INSERT INTO pesOPV_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","چون بدان مکانی که خدا بدو فرموده بود، رسیدند، ابراهیم در آنجا مذبح را بنا نمود، و هیزم را بر هم نهاد، و پسر خود، اسحاق را بسته، بالای هیزم، بر مذبح گذاشت. ");
INSERT INTO pesOPV_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","و ابراهیم، دست خودرا دراز کرده، کارد را گرفت، تا پسر خویش را ذبح نماید. ");
INSERT INTO pesOPV_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","در حال، فرشته خداوند از آسمان وی را ندا درداد و گفت: «ای ابراهیم! ای ابراهیم!» عرض کرد: «لبیک.» ");
INSERT INTO pesOPV_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","گفت: «دست خود را برپسر دراز مکن، و بدو هیچ مکن، زیرا که الان دانستم که تو از خدا می‌ترسی، چونکه پسر یگانه خود را از من دریغ نداشتی.» ");
INSERT INTO pesOPV_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","آنگاه، ابراهیم، چشمان خود را بلند کرده، دید که اینک قوچی، در عقب وی، در بیشه‌ای، به شاخهایش گرفتارشده. پس ابراهیم رفت و قوچ را گرفته، آن را درعوض پسر خود، برای قربانی سوختنی گذرانید. ");
INSERT INTO pesOPV_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","و ابراهیم آن موضع را «یهوه یری» نامید، چنانکه تا امروز گفته می‌شود: «در کوه، یهوه، دیده خواهد شد.» ");
INSERT INTO pesOPV_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","بار دیگر فرشته خداوند، به ابراهیم ازآسمان ندا در‌داد ");
INSERT INTO pesOPV_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","و گفت: «خداوند می‌گوید: به ذات خود قسم می‌خورم، چونکه این کار را کردی و پسر یگانه خود را دریغ نداشتی، ");
INSERT INTO pesOPV_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","هرآینه تو را برکت دهم، و ذریت تو را کثیر سازم، مانند ستارگان آسمان، و مثل ریگهایی که بر کناره دریاست. و ذریت تو دروازه های دشمنان خود رامتصرف خواهند شد. ");
INSERT INTO pesOPV_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","و از ذریت تو، جمیع امتهای زمین برکت خواهند یافت، چونکه قول مرا شنیدی.» ");
INSERT INTO pesOPV_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","پس ابراهیم نزد نوکران خودبرگشت، و ایشان برخاسته، به بئرشبع با هم آمدند، و ابراهیم در بئرشبع ساکن شد. ");
INSERT INTO pesOPV_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","و واقع شد بعد از این امور، که به ابراهیم خبر داده، گفتند: «اینک ملکه نیز برای برادرت ناحور، پسران زاییده است. ");
INSERT INTO pesOPV_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","یعنی نخست زاده او عوص، و برادرش بوز و قموئیل، پدر ارام، ");
INSERT INTO pesOPV_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","وکاسد و حزو و فلداش و یدلاف و بتوئیل.» ");
INSERT INTO pesOPV_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","وبتوئیل، رفقه را آورده است. این هشت را، ملکه برای ناحور، برادر ابراهیم زایید. ");
INSERT INTO pesOPV_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","و کنیز او که رومه نام داشت، او نیز طابح و جاحم و تاحش ومعکه را زایید. ");
INSERT INTO pesOPV_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","و ایام زندگانی ساره، صد و بیست وهفت سال بود، این است سالهای عمرساره. ");
INSERT INTO pesOPV_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","و ساره در قریه اربع، که حبرون باشد، درزمین کنعان مرد. و ابراهیم آمد تا برای ساره ماتم و گریه کند. ");
INSERT INTO pesOPV_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","و ابراهیم از نزد میت خودبرخاست، و بنی حت را خطاب کرده، گفت: ");
INSERT INTO pesOPV_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","«من نزد شما غریب و نزیل هستم. قبری از نزد خود به ملکیت من دهید، تا میت خود را از پیش روی خود دفن کنم.» ");
INSERT INTO pesOPV_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","پس بنی حت در جواب ابراهیم گفتند: ");
INSERT INTO pesOPV_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","«ای مولای من، سخن ما را بشنو. تو درمیان ما رئیس خدا هستی. در بهترین مقبره های ما، میت خود را دفن کن. هیچ کدام از ما، قبرخویش را از تو دریغ نخواهد داشت که میت خودرا دفن کنی.» ");
INSERT INTO pesOPV_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","پس ابراهیم برخاست، و نزد اهل آن زمین، یعنی بنی حت، تعظیم نمود. ");
INSERT INTO pesOPV_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","و ایشان را خطاب کرده، گفت: «اگر مرضی شما باشد که میت خود را از نزد خود دفن کنم، سخن مرابشنوید و به عفرون بن صوحار، برای من سفارش کنید، ");
INSERT INTO pesOPV_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","تا مغاره مکفیله را که از املاک او در کنارزمینش واقع است، به من دهد، به قیمت تمام، درمیان شما برای قبر، به ملکیت من بسپارد.» ");
INSERT INTO pesOPV_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","و عفرون در میان بنی حت نشسته بود. پس عفرون حتی، در مسامع بنی حت، یعنی همه که به دروازه شهر او داخل می‌شدند، در جواب ابراهیم گفت: ");
INSERT INTO pesOPV_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","«ای مولای من، نی، سخن مرا بشنو، آن زمین را به تو می‌بخشم، و مغاره‌ای را که در آن است به تو می‌دهم، بحضور ابنای قوم خود، آن رابه تو می‌بخشم. میت خود را دفن کن.» ");
INSERT INTO pesOPV_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","پس ابراهیم نزد اهل آن زمین تعظیم نمود، ");
INSERT INTO pesOPV_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","و عفرون را به مسامع اهل زمین خطاب کرده، گفت: «اگر تو راضی هستی، التماس دارم عرض مرا اجابت کنی. قیمت زمین را به تو می‌دهم، از من قبول فرمای، تا در آنجا میت خود را دفن کنم.» ");
INSERT INTO pesOPV_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","عفرون در جواب ابراهیم گفت: ");
INSERT INTO pesOPV_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","«ای مولای من، از من بشنو، قیمت زمین چهارصد مثقال نقره است، این در میان من و تو چیست؟ میت خود رادفن کن.» ");
INSERT INTO pesOPV_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","پس ابراهیم، سخن عفرون را اجابت نمود، و آن مبلغی را که در مسامع بنی حت گفته بود، یعنی چهارصد مثقال نقره رایج المعامله، به نزدعفرون وزن کرد. ");
INSERT INTO pesOPV_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","پس زمین عفرون، که درمکفیله، برابر ممری واقع است، یعنی زمین ومغاره‌ای که در آن است، با همه درختانی که در آن زمین، و در تمامی حدود و حوالی آن بود، مقررشد ");
INSERT INTO pesOPV_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","به ملکیت ابراهیم، بحضور بنی حت، یعنی همه که به دروازه شهرش داخل می‌شدند. ");
INSERT INTO pesOPV_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","ازآن پس، ابراهیم، زوجه خود، ساره را در مغاره صحرای مکفیله، در مقابل ممری، که حبرون باشد، در زمین کنعان دفن کرد. ");
INSERT INTO pesOPV_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","و آن صحرا، بامغاره‌ای که در آن است، از جانب بنی حت، به ملکیت ابراهیم، به جهت قبر مقرر شد. ");
INSERT INTO pesOPV_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","و ابراهیم پیر و سالخورده شد، وخداوند، ابراهیم را در هر چیز برکت داد. ");
INSERT INTO pesOPV_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","و ابراهیم به خادم خود، که بزرگ خانه وی، و بر تمام مایملک او مختار بود، گفت: «اکنون دست خود را زیر ران من بگذار. ");
INSERT INTO pesOPV_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","و به یهوه، خدای آسمان و خدای زمین، تو را قسم می‌دهم، که زنی برای پسرم از دختر کنعانیان، که در میان ایشان ساکنم، نگیری، ");
INSERT INTO pesOPV_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","بلکه به ولایت من و به مولدم بروی، و از آنجا زنی برای پسرم اسحاق بگیری.» ");
INSERT INTO pesOPV_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","خادم به وی گفت: «شاید آن زن راضی نباشد که با من بدین زمین بیاید؟ آیا پسرت را بدان زمینی که از آن بیرون آمدی، بازبرم؟» ");
INSERT INTO pesOPV_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","ابراهیم وی را گفت: «زنهار، پسر مرا بدانجا باز مبری. ");
INSERT INTO pesOPV_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","یهوه، خدای آسمان، که مرا از خانه پدرم و اززمین مولد من، بیرون آورد، و به من تکلم کرد، وقسم خورده، گفت: “که این زمین را به ذریت توخواهم داد.” او فرشته خود را پیش روی توخواهد فرستاد، تا زنی برای پسرم از آنجا بگیری. ");
INSERT INTO pesOPV_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","اما اگر آن زن از آمدن با تو رضا ندهد، از این قسم من، بری خواهی بود، لیکن زنهار، پسر مرابدانجا باز نبری.» ");
INSERT INTO pesOPV_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","پس خادم دست خود را زیرران آقای خود ابراهیم نهاد، و در این امر برای اوقسم خورد. ");
INSERT INTO pesOPV_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","و خادم ده شتر، از شتران آقای خود گرفته، برفت. و همه اموال مولایش به‌دست او بود. پس روانه شده، به شهر ناحور در ارام نهرین آمد. ");
INSERT INTO pesOPV_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","وبه وقت عصر، هنگامی که زنان برای کشیدن آب بیرون می‌آمدند، شتران خود را در خارج شهر، برلب چاه آب خوابانید. ");
INSERT INTO pesOPV_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","و گفت: «ای یهوه، خدای آقایم ابراهیم، امروز مرا کامیاب بفرما، و باآقایم ابراهیم احسان بنما. ");
INSERT INTO pesOPV_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","اینک من بر این چشمه آب ایستاده‌ام، و دختران اهل این شهر، به جهت کشیدن آب بیرون می‌آیند. ");
INSERT INTO pesOPV_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","پس چنین بشود که آن دختری که به وی گویم: “سبوی خودرا فرودآر تا بنوشم “، و او گوید: “بنوش و شترانت را نیز سیراب کنم “، همان باشد که نصیب بنده خود اسحاق کرده باشی، تا بدین، بدانم که با آقایم احسان فرموده‌ای.» ");
INSERT INTO pesOPV_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","و او هنوز از سخن‌گفتن فارغ نشده بود که ناگاه، رفقه، دختر بتوئیل، پسر ملکه، زن ناحور، برادر ابراهیم، بیرون آمد و سبویی بر کتف داشت. ");
INSERT INTO pesOPV_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","و آن دختر بسیار نیکومنظر و باکره بود، ومردی او را نشناخته بود. پس به چشمه فرورفت، و سبوی خود را پر کرده، بالا آمد. ");
INSERT INTO pesOPV_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","آنگاه خادم به استقبال او بشتافت و گفت: «جرعه‌ای آب ازسبوی خود به من بنوشان.» ");
INSERT INTO pesOPV_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","گفت: «ای آقای من بنوش»، و سبوی خود را بزودی بر دست خودفرودآورده، او را نوشانید. ");
INSERT INTO pesOPV_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","و چون ازنوشانیدنش فارغ شد، گفت: «برای شترانت نیزبکشم تا از نوشیدن بازایستند.» ");
INSERT INTO pesOPV_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","پس سبوی خود را بزودی در آبخور خالی کرد و باز به سوی چاه، برای کشیدن بدوید، و از بهر همه شترانش کشید. ");
INSERT INTO pesOPV_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","و آن مرد بر وی چشم دوخته بود وسکوت داشت، تا بداند که خداوند، سفر او راخیریت اثر نموده است یا نه. ");
INSERT INTO pesOPV_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","و واقع شد، چون شتران از نوشیدن بازایستادند، که آن مرد حلقه طلای نیم مثقال وزن، ودو ابرنجین برای دستهایش، که ده مثقال طلا وزن آنها بود، بیرون آورد. ");
INSERT INTO pesOPV_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","و گفت: «به من بگو که دختر کیستی؟ آیا در خانه پدرت جایی برای ماباشد تا شب را بسر بریم؟» ");
INSERT INTO pesOPV_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","وی را گفت: «من دختر بتوئیل، پسر ملکه که او را از ناحور زایید، می‌باشم.» ");
INSERT INTO pesOPV_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","و بدو گفت: «نزد ما کاه و علف فراوان است، و جای نیز برای منزل.» ");
INSERT INTO pesOPV_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","آنگاه آن مرد خم شد، خداوند را پرستش نمود ");
INSERT INTO pesOPV_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","و گفت: «متبارک باد یهوه، خدای آقایم ابراهیم، که لطف و وفای خود را از آقایم دریغ نداشت، و چون من در راه بودم، خداوند مرا به خانه برادران آقایم راهنمایی فرمود.» ");
INSERT INTO pesOPV_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","پس آن دختر دوان دوان رفته، اهل خانه مادر خویش را از این وقایع خبر داد. ");
INSERT INTO pesOPV_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","و رفقه رابرادری لابان نام بود. پس لابان به نزد آن مرد، به‌سر چشمه، دوان دوان بیرون آمد. ");
INSERT INTO pesOPV_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","و واقع شدکه چون آن حلقه و ابرنجینها را بر دستهای خواهر خود دید، و سخنهای خواهر خود، رفقه را شنید که می‌گفت آن مرد چنین به من گفته است، به نزد وی آمد. و اینک نزد شتران به‌سر چشمه ایستاده بود. ");
INSERT INTO pesOPV_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","و گفت: «ای مبارک خداوند، بیا، چرا بیرون ایستاده‌ای؟ من خانه را و منزلی برای شتران، مهیا ساخته‌ام.» ");
INSERT INTO pesOPV_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","پس آن مرد به خانه درآمد، و لابان شتران را باز کرد، و کاه و علف به شتران داد، و آب به جهت شستن پایهایش و پایهای رفقایش آورد. ");
INSERT INTO pesOPV_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","و غذا پیش او نهادند. وی گفت: «تا مقصود خود را بازنگویم، چیزی نخورم.» گفت: «بگو.» ");
INSERT INTO pesOPV_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","گفت: «من خادم ابراهیم هستم. ");
INSERT INTO pesOPV_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","وخداوند، آقای مرا بسیار برکت داده و او بزرگ شده است، و گله‌ها و رمه‌ها و نقره و طلا و غلامان و کنیزان و شتران و الاغان بدو داده است. ");
INSERT INTO pesOPV_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","وزوجه آقایم ساره، بعد از پیر شدن، پسری برای آقایم زایید، و آنچه دارد، بدو داده است. ");
INSERT INTO pesOPV_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","وآقایم مرا قسم داد و گفت که “زنی برای پسرم ازدختران کنعانیان که در زمین ایشان ساکنم، نگیری. ");
INSERT INTO pesOPV_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","بلکه به خانه پدرم و به قبیله من بروی، و زنی برای پسرم بگیری.” ");
INSERT INTO pesOPV_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","و به آقای خودگفتم: “شاید آن زن همراه من نیاید؟” ");
INSERT INTO pesOPV_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","او به من گفت: “یهوه که به حضور او سالک بوده‌ام، فرشته خود را با تو خواهد فرستاد، و سفر تو راخیریت اثر خواهد گردانید، تا زنی برای پسرم ازقبیله‌ام و از خانه پدرم بگیری. ");
INSERT INTO pesOPV_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","آنگاه از قسم من بری خواهی گشت، چون به نزد قبیله‌ام رفتی، هرگاه زنی به تو ندادند، از سوگند من بری خواهی بود.” ");
INSERT INTO pesOPV_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","پس امروز به‌سر چشمه رسیدم و گفتم: “ای یهوه، خدای آقایم ابراهیم، اگر حال، سفر مراکه به آن آمده‌ام، کامیاب خواهی کرد. ");
INSERT INTO pesOPV_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","اینک من به‌سر این چشمه آب ایستاده‌ام. پس چنین بشودکه آن دختری که برای کشیدن آب بیرون آید، وبه وی گویم: “مرا از سبوی خود جرعه‌ای آب بنوشان “، ");
INSERT INTO pesOPV_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","و به من گوید: “بیاشام، و برای شترانت نیز آب می‌کشم “، او همان زن باشد که خداوند، نصیب آقازاده من کرده است. ");
INSERT INTO pesOPV_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","و من هنوز از گفتن این، در دل خود فارغ نشده بودم، که ناگاه، رفقه با سبویی بر کتف خود بیرون آمد، و به چشمه پایین رفت، تا آب بکشد. و به وی گفتم: “جرعه‌ای آب به من بنوشان.” ");
INSERT INTO pesOPV_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","پس سبوی خودرا بزودی از کتف خود فروآورده، گفت: “بیاشام، و شترانت را نیز آب می‌دهم.” پس نوشیدم وشتران را نیز آب داد. ");
INSERT INTO pesOPV_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","و از او پرسیده، گفتم: “تودختر کیستی؟” گفت: “دختر بتوئیل بن ناحور که ملکه، او را برای او زایید.” پس حلقه را در بینی او، و ابرنجین‌ها را بر دستهایش گذاشتم. ");
INSERT INTO pesOPV_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","آنگاه سجده کرده، خداوند را پرستش نمودم. و یهوه، خدای آقای خود ابراهیم را، متبارک خواندم، که مرا به راه راست هدایت فرمود، تا دختر برادرآقای خود را، برای پسرش بگیرم. ");
INSERT INTO pesOPV_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","اکنون اگربخواهید با آقایم احسان و صداقت کنید، پس مراخبر دهید. و اگر نه مرا خبر دهید، تا بطرف راست یا چپ ره سپر شوم.» ");
INSERT INTO pesOPV_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","لابان و بتوئیل در جواب گفتند: «این امر ازخداوند صادر شده است، با تو نیک یا بدنمی توانیم گفت. ");
INSERT INTO pesOPV_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","اینک رفقه حاضر است، او رابرداشته، روانه شو تا زن پسر آقایت باشد، چنانکه خداوند گفته است.» ");
INSERT INTO pesOPV_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","و واقع شد که چون خادم ابراهیم سخن ایشان را شنید، خداوند را به زمین سجده کرد. ");
INSERT INTO pesOPV_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","و خادم، آلات نقره و آلات طلا و رختها رابیرون آورده، پیشکش رفقه کرد، و برادر و مادر اورا چیزهای نفیسه داد. ");
INSERT INTO pesOPV_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","و او و رفقایش خوردندو آشامیدند و شب را بسر بردند. و بامدادان برخاسته، گفت: «مرا به سوی آقایم روانه نمایید.» ");
INSERT INTO pesOPV_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","برادر و مادر او گفتند: «دختر با ما ده روزی بماند و بعد از آن روانه شود.» ");
INSERT INTO pesOPV_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","بدیشان گفت: «مرا معطل مسازید، خداوند سفر مرا کامیاب گردانیده است، پس مرا روانه نمایید تا بنزد آقای خود بروم.» ");
INSERT INTO pesOPV_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","گفتند: «دختر را بخوانیم و اززبانش بپرسیم.» ");
INSERT INTO pesOPV_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","پس رفقه را خواندند و به وی گفتند: «با این مرد خواهی رفت؟» گفت: «می‌روم.» ");
INSERT INTO pesOPV_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","آنگاه خواهر خود رفقه، و دایه‌اش را، با خادم ابراهیم و رفقایش روانه کردند. ");
INSERT INTO pesOPV_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","ورفقه را برکت داده به وی گفتند: «تو خواهر ماهستی، مادر هزار کرورها باش، و ذریت تو، دروازه دشمنان خود را متصرف شوند.» ");
INSERT INTO pesOPV_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","پس رفقه با کنیزانش برخاسته، بر شتران سوار شدند، و از عقب آن مرد روانه گردیدند. وخادم، رفقه را برداشته، برفت. ");
INSERT INTO pesOPV_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","و اسحاق از راه بئرلحی رئی می‌آمد، زیرا که او در ارض جنوب ساکن بود. ");
INSERT INTO pesOPV_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","و هنگام شام، اسحاق برای تفکر به صحرا بیرون رفت، و چون نظر بالا کرد، دید که شتران می‌آیند. ");
INSERT INTO pesOPV_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","و رفقه چشمان خود را بلندکرده، اسحاق را دید، و از شتر خود فرود آمد، ");
INSERT INTO pesOPV_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","زیرا که از خادم پرسید: «این مرد کیست که درصحرا به استقبال ما می‌آید؟» و خادم گفت: «آقای من است.» پس برقع خود را گرفته، خود راپوشانید. ");
INSERT INTO pesOPV_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","و خادم، همه کارهایی را که کرده بود، به اسحاق باز‌گفت. ");
INSERT INTO pesOPV_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","و اسحاق، رفقه را به خیمه مادر خود، ساره، آورد، و او را به زنی خود گرفته، دل در او بست. و اسحاق بعد از وفات مادر خود، تسلی پذیرفت. ");
INSERT INTO pesOPV_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","و ابراهیم، دیگر بار، زنی گرفت که قطوره نام داشت. ");
INSERT INTO pesOPV_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","و او زمران و یقشان و مدان و مدیان و یشباق و شوحا را برای او زایید. ");
INSERT INTO pesOPV_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","و یقشان، شبا و ددان را آورد. و بنی ددان، اشوریم و لطوشیم و لامیم بودند. ");
INSERT INTO pesOPV_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","و پسران مدیان، عیفا و عیفر و حنوک و ابیداع و الداعه بودند. جمله اینها، اولاد قطوره بودند. ");
INSERT INTO pesOPV_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","و ابراهیم تمام مایملک خود را به اسحاق بخشید. ");
INSERT INTO pesOPV_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","اما به پسران کنیزانی که ابراهیم داشت، ابراهیم عطایاداد، و ایشان را در حین حیات خود، از نزد پسرخویش اسحاق، به‌جانب مشرق، به زمین شرقی فرستاد. ");
INSERT INTO pesOPV_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","این است ایام سالهای عمر ابراهیم، که زندگانی نمود: صد و هفتاد وپنج سال. ");
INSERT INTO pesOPV_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","و ابراهیم جان بداد، و در کمال شیخوخیت، پیر و سیر شده، بمرد. و به قوم خود ملحق شد. ");
INSERT INTO pesOPV_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","و پسرانش، اسحاق و اسماعیل، او را در مغاره مکفیله، درصحرای عفرون بن صوحارحتی، در مقابل ممری دفن کردند. ");
INSERT INTO pesOPV_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","آن صحرایی که ابراهیم، ازبنی حت، خریده بود. در آنجا ابراهیم و زوجه‌اش ساره مدفون شدند. ");
INSERT INTO pesOPV_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","و واقع شد بعد از وفات ابراهیم، که خدا پسرش اسحاق را برکت داد، واسحاق نزد بئرلحی رئی ساکن بود. ");
INSERT INTO pesOPV_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","این است پیدایش اسماعیل بن ابراهیم، که هاجر مصری، کنیز ساره، برای ابراهیم زایید. ");
INSERT INTO pesOPV_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","واین است نامهای پسران اسماعیل، موافق اسمهای ایشان به حسب پیدایش ایشان. نخست زاده اسماعیل، نبایوت، و قیدار و ادبیل ومبسام. ");
INSERT INTO pesOPV_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","و مشماع و دومه و مسا ");
INSERT INTO pesOPV_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","و حدار وتیما و یطور و نافیش و قدمه. ");
INSERT INTO pesOPV_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","اینانند پسران اسماعیل، و این است نامهای ایشان در بلدان وحله های ایشان، دوازده امیر، حسب قبایل ایشان. ");
INSERT INTO pesOPV_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","و مدت زندگانی اسماعیل، صد و سی و هفت سال بود، که جان را سپرده، بمرد. و به قوم خودملحق گشت. ");
INSERT INTO pesOPV_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","و ایشان از حویله تا شور، که مقابل مصر، به سمت آشور واقع است، ساکن بودند. و نصیب او در مقابل همه برادران او افتاد. ");
INSERT INTO pesOPV_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","و این است پیدایش اسحاق بن ابراهیم. ابراهیم، اسحاق را آورد. ");
INSERT INTO pesOPV_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","و چون اسحاق چهل ساله شد، رفقه دختر بتوئیل ارامی و خواهر لابان ارامی را، از فدان ارام به زنی گرفت. ");
INSERT INTO pesOPV_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","و اسحاق برای زوجه خود، چون که نازاد بود، نزد خداونددعا کرد. و خداوند او را مستجاب فرمود. وزوجه‌اش رفقه حامله شد. ");
INSERT INTO pesOPV_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","و دو طفل در رحم او منازعت می‌کردند. او گفت: «اگر چنین باشد، من چرا چنین هستم؟» پس رفت تا از خداوندبپرسد. ");
INSERT INTO pesOPV_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","خداوند به وی گفت: «دو امت در بطن تو هستند، و دو قوم از رحم تو جدا شوند. وقومی بر قومی تسلط خواهد یافت، و بزرگ، کوچک را بندگی خواهد نمود.» ");
INSERT INTO pesOPV_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","و چون وقت وضع حملش رسید، اینک توامان در رحم اوبودند. ");
INSERT INTO pesOPV_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","و نخستین، سرخ‌فام بیرون آمد، وتمامی بدنش مانند پوستین، پشمین بود. و او راعیسو نام نهادند. ");
INSERT INTO pesOPV_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","و بعد از آن، برادرش بیرون آمد، و پاشنه عیسو را به‌دست خود گرفته بود. واو را یعقوب نام نهادند. و درحین ولادت ایشان، اسحاق، شصت ساله بود. ");
INSERT INTO pesOPV_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","و آن دو پسر، نموکردند، و عیسو صیادی ماهر، و مرد صحرایی بود. و اما یعقوب، مرد ساده دل و چادرنشین. ");
INSERT INTO pesOPV_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","واسحاق، عیسو را دوست داشتی، زیرا که صید اورا می‌خورد. اما رفقه، یعقوب را محبت نمودی. ");
INSERT INTO pesOPV_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","روزی یعقوب، آش می‌پخت و عیسو وا مانده، از صحرا آمد. ");
INSERT INTO pesOPV_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","و عیسو به یعقوب گفت: «از این آش ادوم (یعنی سرخ ) مرا بخوران، زیرا که وامانده‌ام.» از این سبب او را ادوم نامیدند. ");
INSERT INTO pesOPV_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","یعقوب گفت: «امروز نخست زادگی خود را به من بفروش.» ");
INSERT INTO pesOPV_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","عیسو گفت: «اینک من به حالت موت رسیده‌ام، پس مرا از نخست زادگی چه فایده؟» ");
INSERT INTO pesOPV_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","یعقوب گفت: «امروز برای من قسم بخور.» پس برای او قسم خورد، و نخست زادگی خود را به یعقوب فروخت. ");
INSERT INTO pesOPV_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","و یعقوب نان وآش عدس را به عیسو داد، که خورد و نوشید وبرخاسته، برفت. پس عیسو نخست زادگی خود راخوار نمود. ");
INSERT INTO pesOPV_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","و قحطی در آن زمین حادث شد، غیرآن قحط اول، که در ایام ابراهیم بود. واسحاق نزد ابی ملک، پادشاه فلسطینیان به جراررفت. ");
INSERT INTO pesOPV_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","و خداوند بر وی ظاهر شده، گفت: «به مصر فرود میا، بلکه به زمینی که به تو بگویم ساکن شو. ");
INSERT INTO pesOPV_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","در این زمین توقف نما، و با تو خواهم بود، وتو را برکت خواهم داد، زیرا که به تو و ذریت تو، تمام این زمین را می‌دهم، و سوگندی را که باپدرت ابراهیم خوردم، استوار خواهم داشت. ");
INSERT INTO pesOPV_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","وذریتت را مانند ستارگان آسمان کثیر گردانم، وتمام این زمینها را به ذریت تو بخشم، و از ذریت تو جمیع امتهای جهان برکت خواهند یافت. ");
INSERT INTO pesOPV_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","زیرا که ابراهیم قول مرا شنید، و وصایا و اوامر وفرایض و احکام مرا نگاه داشت.» ");
INSERT INTO pesOPV_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","پس اسحاق در جرار اقامت نمود. ");
INSERT INTO pesOPV_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","و مردمان آن مکان درباره زنش از او جویا شدند. گفت: «او خواهر من است، » زیرا ترسید که بگوید: «زوجه من است، » مبادا اهل آنجا، او را به‌خاطررفقه که نیکومنظر بود، بکشند. ");
INSERT INTO pesOPV_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","و چون در آنجامدتی توقف نمود، چنان افتاد که ابی ملک، پادشاه فلسطینیان، از دریچه نظاره کرد، و دید که اینک اسحاق با زوجه خود رفقه، مزاح می‌کند. ");
INSERT INTO pesOPV_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","پس ابی ملک، اسحاق را خوانده، گفت: «همانا این زوجه توست! پس چرا گفتی که خواهر من است؟» اسحاق بدو گفت: «زیرا گفتم که مبادابرای وی بمیرم.» ");
INSERT INTO pesOPV_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","ابی ملک گفت: «این چه‌کاراست که با ما کردی؟ نزدیک بود که یکی از قوم، بازوجه ات همخواب شود، و بر ما جرمی آورده باشی.» ");
INSERT INTO pesOPV_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","و ابی ملک تمامی قوم را قدغن فرموده، گفت: «کسی‌که متعرض این مرد و زوجه‌اش بشود، هر آینه خواهد مرد.» ");
INSERT INTO pesOPV_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","و اسحاق در آن زمین زراعت کرد، و در آن سال صد چندان پیدا نمود؛ و خداوند او را برکت داد. ");
INSERT INTO pesOPV_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","و آن مرد بزرگ شده، آن فان ترقی می‌نمود، تا بسیار بزرگ گردید. ");
INSERT INTO pesOPV_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","و او را گله گوسفندان و مواشی گاوان و غلامان کثیر بود، وفلسطینیان بر او حسد بردند. ");
INSERT INTO pesOPV_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","و همه چاههایی که نوکران پدرش در ایام پدرش ابراهیم، کنده بودند، فلسطینیان آنها را بستند، و از خاک پرکردند. ");
INSERT INTO pesOPV_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","و ابی ملک به اسحاق گفت: «از نزد مابرو، زیرا که از ما بسیار بزرگتر شده‌ای.» ");
INSERT INTO pesOPV_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","پس اسحاق از آنجا برفت، و در وادی جرارفرود آمده، در آنجا ساکن شد. ");
INSERT INTO pesOPV_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","و چاههای آب را، که در ایام پدرش ابراهیم کنده بودند، وفلسطینیان آنها را بعد از وفات ابراهیم بسته بودند، اسحاق از سر نو کند، و آنها را مسمی نمودبه نامهایی که پدرش آنها را نامیده بود. ");
INSERT INTO pesOPV_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","ونوکران اسحاق در آن وادی حفره زدند، و چاه آب زنده‌ای در آنجا یافتند. ");
INSERT INTO pesOPV_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","و شبانان جرار، باشبانان اسحاق، منازعه کرده، گفتند: «این آب ازآن ماست!» پس آن چاه را عسق نامید، زیرا که باوی منازعه کردند. ");
INSERT INTO pesOPV_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","و چاهی دیگر کندند، همچنان برای آن نیز جنگ کردند، و آن را سطنه نامید. ");
INSERT INTO pesOPV_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","و از آنجا کوچ کرده، چاهی دیگر کند، وبرای آن جنگ نکردند، پس آن را رحوبوت نامیده، گفت: «که اکنون خداوند ما را وسعت داده است، و در زمین، بارور خواهیم شد.» ");
INSERT INTO pesOPV_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","پس از آنجا به بئرشبع آمد. ");
INSERT INTO pesOPV_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","در همان شب، خداوند بر وی ظاهر شده، گفت: «من خدای پدرت، ابراهیم، هستم. ترسان مباش زیراکه من با تو هستم، و تو را برکت می‌دهم، و ذریت تو را بخاطر بنده خود، ابراهیم، فراوان خواهم ساخت.» ");
INSERT INTO pesOPV_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","و مذبحی در آنجا بنا نهاد و نام یهوه را خواند، و خیمه خود را برپا نمود، و نوکران اسحاق، چاهی در آنجا کندند. ");
INSERT INTO pesOPV_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","و ابی ملک، به اتفاق یکی از اصحاب خود، احزات نام، وفیکول، که سپهسالار او بود، از جرار به نزد اوآمدند. ");
INSERT INTO pesOPV_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","و اسحاق بدیشان گفت: «چرا نزد من آمدید، با آنکه با من عداوت نمودید، و مرا از نزدخود راندید؟» ");
INSERT INTO pesOPV_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","گفتند: «به تحقیق فهمیده‌ایم که خداوند با توست. پس گفتیم سوگندی در میان ماو تو باشد، و عهدی با تو ببندیم. ");
INSERT INTO pesOPV_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","تا با ما بدی نکنی چنانکه به تو ضرری نرساندیم، بلکه غیر ازنیکی به تو نکردیم، و تو را به سلامتی روانه نمودیم، و اکنون مبارک خداوند هستی.» ");
INSERT INTO pesOPV_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","آنگاه برای ایشان ضیافتی برپا نمود، وخوردند و آشامیدند. ");
INSERT INTO pesOPV_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","بامدادان برخاسته، بایکدیگر قسم خوردند، و اسحاق ایشان را وداع نمود. پس، از نزد وی به سلامتی رفتند. ");
INSERT INTO pesOPV_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","و درآن روز چنان افتاد که نوکران اسحاق آمده، او را ازآن چاهی که می‌کندند خبر داده، گفتند: «آب یافتیم!» ");
INSERT INTO pesOPV_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","پس آن را شبعه نامید. از این سبب آن شهر، تا امروز بئرشبع نام دارد. ");
INSERT INTO pesOPV_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","و چون عیسوچهل ساله بود، یهودیه، دختر بیری حتی، وبسمه، دختر ایلون حتی را به زنی گرفت. ");
INSERT INTO pesOPV_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","وایشان باعث تلخی جان اسحاق و رفقه شدند. ");
INSERT INTO pesOPV_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","و چون اسحاق پیر شد، و چشمانش از دیدن تار گشته بود، پسر بزرگ خودعیسو را طلبیده، به وی گفت: «ای پسر من!» گفت: «لبیک.» ");
INSERT INTO pesOPV_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","گفت: «اینک پیر شده‌ام و وقت اجل خود را نمی دانم. ");
INSERT INTO pesOPV_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","پس اکنون، سلاح خود یعنی ترکش و کمان خویش را گرفته، به صحرا برو، ونخجیری برای من بگیر، ");
INSERT INTO pesOPV_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","و خورشی برای من چنانکه دوست می‌دارم ساخته، نزد من حاضر کن، تا بخورم و جانم قبل از مردنم تو را برکت دهد.» ");
INSERT INTO pesOPV_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","و چون اسحاق به پسر خود عیسو سخن می‌گفت، رفقه بشنید، و عیسو به صحرا رفت تانخجیری صید کرده، بیاورد. ");
INSERT INTO pesOPV_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","آنگاه رفقه پسرخود، یعقوب را خوانده، گفت: «اینک پدر تو راشنیدم که برادرت عیسو را خطاب کرده، می‌گفت: ");
INSERT INTO pesOPV_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","“برای من شکاری آورده، خورشی بساز تا آن را بخورم، و قبل از مردنم تو را درحضور خداوند برکت دهم.” ");
INSERT INTO pesOPV_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","پس‌ای پسر من، الان سخن مرا بشنو در آنچه من به تو امر می‌کنم. ");
INSERT INTO pesOPV_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","بسوی گله بشتاب، و دو بزغاله خوب از بزها، نزد من بیاور، تا از آنها غذایی برای پدرت بطوری که دوست می‌دارد، بسازم. ");
INSERT INTO pesOPV_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","و آن را نزد پدرت ببر تا بخورد، و تو را قبل از وفاتش برکت دهد.» ");
INSERT INTO pesOPV_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","یعقوب به مادر خود، رفقه، گفت: «اینک برادرم عیسو، مردی مویدار است و من مردی بی‌موی هستم؛ ");
INSERT INTO pesOPV_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","شاید که پدرم مرا لمس نماید، و در نظرش مثل مسخره‌ای بشوم، و لعنت به عوض برکت بر خود آورم.» ");
INSERT INTO pesOPV_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","مادرش به وی گفت: «ای پسر من، لعنت تو بر من باد! فقط سخن مرا بشنو و رفته، آن را برای من بگیر.» ");
INSERT INTO pesOPV_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","پس رفت و گرفته، نزد مادر خود آورد. و مادرش خورشی ساخت بطوری که پدرش دوست می‌داشت. ");
INSERT INTO pesOPV_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","و رفقه، جامه فاخر پسر بزرگ خودعیسو را، که نزد او در خانه بود گرفته، به پسر کهترخود، یعقوب پوشانید، ");
INSERT INTO pesOPV_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","و پوست بزغاله‌ها را، بر دستها و نرمه گردن او بست. ");
INSERT INTO pesOPV_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","و خورش ونانی که ساخته بود، به‌دست پسر خود یعقوب سپرد. ");
INSERT INTO pesOPV_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","پس نزد پدر خود آمده، گفت: «ای پدرمن!» گفت: «لبیک، تو کیستی‌ای پسر من؟» ");
INSERT INTO pesOPV_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","یعقوب به پدر خود گفت: «من نخست زاده توعیسو هستم. آنچه به من فرمودی کردم، الان برخیز، بنشین و از شکار من بخور، تا جانت مرابرکت دهد.» ");
INSERT INTO pesOPV_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","اسحاق به پسر خود گفت: «ای پسر من! چگونه بدین زودی یافتی؟» گفت: «یهوه خدای تو به من رسانید.» ");
INSERT INTO pesOPV_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","اسحاق به یعقوب گفت: «ای پسر من، نزدیک بیا تا تو را لمس کنم، که آیا تو پسر من عیسو هستی یا نه.» ");
INSERT INTO pesOPV_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","پس یعقوب نزد پدر خود اسحاق آمد، و او را لمس کرده، گفت: «آواز، آواز یعقوب است، لیکن دستها، دستهای عیسوست.» ");
INSERT INTO pesOPV_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","و او را نشناخت، زیرا که دستهایش مثل دستهای برادرش عیسو، موی دار بود، پس او را برکت داد. ");
INSERT INTO pesOPV_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","و گفت: «آیاتو همان پسر من، عیسو هستی؟» گفت: «من هستم.» ");
INSERT INTO pesOPV_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","پس گفت: «نزدیک بیاور تا از شکارپسر خود بخورم و جانم تو را برکت دهد.» پس نزد وی آورد و بخورد و شراب برایش آورد ونوشید. ");
INSERT INTO pesOPV_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","و پدرش، اسحاق به وی گفت: «ای پسر من، نزدیک بیا و مرا ببوس.» ");
INSERT INTO pesOPV_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","پس نزدیک آمده، او را بوسید و رایحه لباس او را بوییده، او رابرکت داد و گفت: «همانا رایحه پسر من، مانندرایحه صحرایی است که خداوند آن را برکت داده باشد. ");
INSERT INTO pesOPV_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","پس خدا تو را از شبنم آسمان و ازفربهی زمین، و از فراوانی غله و شیره عطا فرماید. ");
INSERT INTO pesOPV_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","قومها تو را بندگی نمایند و طوایف تو راتعظیم کنند، بر برادران خود سرور شوی، وپسران مادرت تو را تعظیم نمایند. ملعون باد هرکه تو را لعنت کند، و هر‌که تو را مبارک خواند، مبارک باد.» ");
INSERT INTO pesOPV_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","و واقع شد چون اسحاق، از برکت دادن به یعقوب فارغ شد، به مجرد بیرون رفتن یعقوب ازحضور پدر خود اسحاق، که برادرش عیسو ازشکار باز آمد. ");
INSERT INTO pesOPV_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","و او نیز خورشی ساخت، و نزدپدر خود آورده، به پدر خود گفت: «پدر من برخیزد و از شکار پسر خود بخورد، تا جانت مرابرکت دهد.» ");
INSERT INTO pesOPV_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","پدرش اسحاق به وی گفت: «توکیستی؟» گفت: «من پسر نخستین تو، عیسوهستم.» ");
INSERT INTO pesOPV_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","آنگاه لرزه‌ای شدید بر اسحاق مستولی شده، گفت: «پس آن که بود که نخجیری صید کرده، برایم آورد، و قبل از آمدن تو از همه خوردم و او را برکت دادم، و فی الواقع او مبارک خواهد بود؟» ");
INSERT INTO pesOPV_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","عیسو چون سخنان پدر خود راشنید، نعره‌ای عظیم و بی‌نهایت تلخ برآورده، به پدر خود گفت: «ای پدرم، به من، به من نیز برکت بده!» ");
INSERT INTO pesOPV_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","گفت: «برادرت به حیله آمد، و برکت تورا گرفت.» ");
INSERT INTO pesOPV_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","گفت: «نام او را یعقوب بخوبی نهادند، زیرا که دو مرتبه مرا از پا درآورد. اول نخست زادگی مرا گرفت، و اکنون برکت مرا گرفته است.» پس گفت: «آیا برای من نیز برکتی نگاه نداشتی؟» ");
INSERT INTO pesOPV_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","اسحاق در جواب عیسو گفت: «اینک او را بر تو سرور ساختم، و همه برادرانش را غلامان او گردانیدم، و غله و شیره را رزق اودادم. پس الان‌ای پسر من، برای تو چه کنم؟» ");
INSERT INTO pesOPV_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","عیسو به پدر خود گفت: «ای پدر من، آیا همین یک برکت را داشتی؟ به من، به من نیز‌ای پدرم برکت بده!» و عیسو به آواز بلند بگریست. ");
INSERT INTO pesOPV_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","پدرش اسحاق در جواب او گفت: «اینک مسکن تو (دور) از فربهی زمین، و از شبنم آسمان از بالا خواهد بود. ");
INSERT INTO pesOPV_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","و به شمشیرت خواهی زیست، و برادر خود را بندگی خواهی کرد، وواقع خواهد شد که چون سر باز زدی، یوغ او را ازگردن خود خواهی انداخت.» ");
INSERT INTO pesOPV_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","و عیسو بسبب آن برکتی که پدرش به یعقوب داده بود، بر او بغض ورزید؛ و عیسو دردل خود گفت: «ایام نوحه گری برای پدرم نزدیک است، آنگاه برادر خود یعقوب را خواهم کشت.» ");
INSERT INTO pesOPV_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","و رفقه، از سخنان پسر بزرگ خود، عیسوآگاهی یافت. پس فرستاده، پسر کوچک خود، یعقوب را خوانده، بدو گفت: «اینک برادرت عیسو درباره تو خود را تسلی می‌دهد به اینکه تورا بکشد. ");
INSERT INTO pesOPV_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","پس الان‌ای پسرم سخن مرا بشنو وبرخاسته، نزد برادرم، لابان، به حران فرار کن. ");
INSERT INTO pesOPV_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","وچند روز نزد وی بمان، تا خشم برادرت برگردد. ");
INSERT INTO pesOPV_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","تا غضب برادرت از تو برگردد، و آنچه بدوکردی، فراموش کند. آنگاه می‌فرستم و تو را ازآنجا باز می‌آورم. چرا باید از شما هر دو در یک روز محروم شوم؟» ");
INSERT INTO pesOPV_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","و رفقه به اسحاق گفت: «بسبب دختران حت از جان خود بیزار شده‌ام. اگریعقوب زنی از دختران حت، مثل اینانی که دختران این زمینند بگیرد، مرا از حیات چه فایده خواهد بود.» ");
INSERT INTO pesOPV_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","و اسحاق، یعقوب را خوانده، او رابرکت داد و او را امر فرموده، گفت: «زنی از دختران کنعان مگیر. ");
INSERT INTO pesOPV_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","برخاسته، به فدان ارام، به خانه پدر مادرت، بتوئیل، برو و از آنجازنی از دختران لابان، برادر مادرت، برای خودبگیر. ");
INSERT INTO pesOPV_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","و خدای قادر مطلق تو را برکت دهد، و تورا بارور و کثیر سازد، تا از تو امتهای بسیار بوجودآیند. ");
INSERT INTO pesOPV_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","و برکت ابراهیم را به تو دهد، به تو و به ذریت تو با تو، تا وارث زمین غربت خود شوی، که خدا آن را به ابراهیم بخشید.» ");
INSERT INTO pesOPV_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","پس اسحاق، یعقوب را روانه نمود و به فدان ارام، نزد لابان بن بتوئیل ارامی، برادر رفقه، مادر یعقوب و عیسو، رفت. ");
INSERT INTO pesOPV_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","و اما عیسو چون دید که اسحاق یعقوب رابرکت داده، و او را به فدان ارام روانه نمود، تا ازآنجا زنی برای خود بگیرد، و در حین برکت دادن به وی امر کرده، گفته بود که «زنی از دختران کنعان مگیر، » ");
INSERT INTO pesOPV_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","و اینکه یعقوب، پدر و مادر خود را اطاعت نموده، به فدان ارام رفت. ");
INSERT INTO pesOPV_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","و چون عیسودید که دختران کنعان در نظر پدرش، اسحاق، بدند، ");
INSERT INTO pesOPV_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","پس عیسو نزد اسماعیل رفت، و محلت، دختر اسماعیل بن ابراهیم را که خواهر نبایوت بود، علاوه بر زنانی که داشت، به زنی گرفت. ");
INSERT INTO pesOPV_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","و اما یعقوب، از بئرشبع روانه شده، بسوی حران رفت. ");
INSERT INTO pesOPV_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","و به موضعی نزول کرده، در آنجاشب را بسر برد، زیرا که آفتاب غروب کرده بود ویکی از سنگهای آنجا را گرفته، زیر سر خود نهادو در همان جا بخسبید. ");
INSERT INTO pesOPV_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","و خوابی دید که ناگاه نردبانی بر زمین برپا شده، که سرش به آسمان می‌رسد، و اینک فرشتگان خدا، بر آن صعود ونزول می‌کنند. ");
INSERT INTO pesOPV_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","در حال، خداوند بر سر آن ایستاده، می‌گوید: «من هستم یهوه، خدای پدرت ابراهیم، و خدای اسحاق. این زمینی را که تو بر آن خفته‌ای به تو و به ذریت تو می‌بخشم. ");
INSERT INTO pesOPV_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","و ذریت تو مانند غبار زمین خواهند شد، و به مغرب ومشرق و شمال و جنوب منتشر خواهی شد، و ازتو و از نسل تو جمیع قبایل زمین برکت خواهندیافت. ");
INSERT INTO pesOPV_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","و اینک من با تو هستم، و تو را در هرجایی که روی، محافظت فرمایم تا تو را بدین زمین بازآورم، زیرا که تا آنچه به تو گفته‌ام، بجانیاورم، تو را رها نخواهم کرد.» ");
INSERT INTO pesOPV_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","پس یعقوب ازخواب بیدار شد و گفت: «البته یهوه در این مکان است و من ندانستم.» ");
INSERT INTO pesOPV_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","پس ترسان شده، گفت: «این چه مکان ترسناکی است! این نیست جز خانه خدا و این است دروازه آسمان.» ");
INSERT INTO pesOPV_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","بامدادان یعقوب برخاست و آن سنگی را که زیر سر خودنهاده بود، گرفت، و چون ستونی برپا داشت، وروغن بر سرش ریخت. ");
INSERT INTO pesOPV_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","و آن موضع را بیت ئیل نامید، لکن نام آن شهر اولا لوز بود. ");
INSERT INTO pesOPV_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","و یعقوب نذر کرده، گفت: «اگر خدا با من باشد، و مرا در این راه که می‌روم محافظت کند، و مرا نان دهد تابخورم، و رخت تا بپوشم، ");
INSERT INTO pesOPV_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","تا به خانه پدر خودبه سلامتی برگردم، هرآینه یهوه، خدای من خواهد بود. ");
INSERT INTO pesOPV_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","و این سنگی را که چون ستون برپاکردم، بیت الله شود، و آنچه به من بدهی، ده‌یک آن را به تو خواهم داد.» ");
INSERT INTO pesOPV_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","پس یعقوب روانه شد و به زمین بنی المشرق آمد. ");
INSERT INTO pesOPV_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","و دید که اینک درصحرا، چاهی است، و بر کناره‌اش سه گله گوسفند خوابیده، چونکه از آن چاه گله‌ها را آب می‌دادند، و سنگی بزرگ بر دهنه چاه بود. ");
INSERT INTO pesOPV_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","وچون همه گله‌ها جمع شدندی، سنگ را از دهنه چاه غلطانیده، گله را سیراب کردندی. پس سنگ را بجای خود، بر سر چاه باز گذاشتندی. ");
INSERT INTO pesOPV_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","یعقوب بدیشان گفت: «ای برادرانم از کجاهستید؟» گفتند: «ما از حرانیم.» ");
INSERT INTO pesOPV_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","بدیشان گفت: «لابان بن ناحور را می‌شناسید؟» گفتند: «می‌شناسیم.» ");
INSERT INTO pesOPV_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","بدیشان گفت: «بسلامت است؟» گفتند: «بسلامت، و اینک دخترش، راحیل، با گله او می‌آید.» ");
INSERT INTO pesOPV_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","گفت: «هنوز روز بلند است و وقت جمع کردن مواشی نیست، گله را آب دهید ورفته، بچرانید.» ");
INSERT INTO pesOPV_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","گفتند: «نمی توانیم، تا همه گله هاجمع شوند، و سنگ را از سر چاه بغلطانند، آنگاه گله را آب می‌دهیم.» ");
INSERT INTO pesOPV_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","و هنوز با ایشان در گفتگومی بود که راحیل، با گله پدر خود رسید. زیرا که آنها را چوپانی می‌کرد. ");
INSERT INTO pesOPV_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","اما چون یعقوب راحیل، دختر خالوی خود، لابان، و گله خالوی خویش، لابان را دید، یعقوب نزدیک شده، سنگ را از سر چاه غلطانید، و گله خالوی خویش، لابان را سیراب کرد. ");
INSERT INTO pesOPV_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","و یعقوب، راحیل را بوسید، وبه آواز بلند گریست. ");
INSERT INTO pesOPV_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","و یعقوب، راحیل را خبرداد که او برادر پدرش، و پسر رفقه است. پس دوان دوان رفته، پدر خود را خبر داد. ");
INSERT INTO pesOPV_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","و واقع شد که چون لابان، خبر خواهرزاده خود، یعقوب را شنید، به استقبال وی شتافت، و او را در بغل گرفته، بوسید و به خانه خود آورد، و او لابان را ازهمه این امور آگاهانید. ");
INSERT INTO pesOPV_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","لابان وی را گفت: «فی الحقیقه تو استخوان و گوشت من هستی.» و نزد وی مدت یک ماه توقف نمود. ");
INSERT INTO pesOPV_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","پس لابان، به یعقوب گفت: «آیاچون برادر من هستی، مرا باید مفت خدمت کنی؟ به من بگو که اجرت تو چه خواهد بود؟» ");
INSERT INTO pesOPV_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","ولابان را دو دختر بود، که نام بزرگتر، لیه و اسم کوچکتر، راحیل بود. ");
INSERT INTO pesOPV_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","و چشمان لیه ضعیف بود، و اما راحیل، خوب صورت و خوش منظربود. ");
INSERT INTO pesOPV_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","و یعقوب عاشق راحیل بود و گفت: «برای دختر کوچکت راحیل، هفت سال تو را خدمت می‌کنم.» ");
INSERT INTO pesOPV_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","لابان گفت: «او را به تو بدهم، بهتراست از آنکه به دیگری بدهم. نزد من بمان.» ");
INSERT INTO pesOPV_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","پس یعقوب برای راحیل هفت سال خدمت کرد. و بسبب محبتی که به وی داشت، در نظرش روزی چند نمود. ");
INSERT INTO pesOPV_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","و یعقوب به لابان گفت: «زوجه‌ام را به من بسپار، که روزهایم سپری شد، تا به وی درآیم.» ");
INSERT INTO pesOPV_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","پس لابان، همه مردمان آنجارا دعوت کرده، ضیافتی برپا نمود. ");
INSERT INTO pesOPV_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","و واقع شدکه هنگام شام، دختر خود، لیه را برداشته، او رانزد وی آورد، و او به وی درآمد. ");
INSERT INTO pesOPV_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","و لابان کنیزخود زلفه را، به دختر خود لیه، به کنیزی داد. ");
INSERT INTO pesOPV_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","صبحگاهان دید، که اینک لیه است! پس به لابان گفت: «این چیست که به من کردی؟ مگر برای راحیل نزد تو خدمت نکردم؟ چرا مرا فریب دادی؟» ");
INSERT INTO pesOPV_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","لابان گفت: «در ولایت ما چنین نمی کنند که کوچکتر را قبل از بزرگتر بدهند. ");
INSERT INTO pesOPV_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","هفته این را تمام کن و او را نیز به تو می‌دهیم، برای هفت سال دیگر که خدمتم بکنی.» ");
INSERT INTO pesOPV_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","پس یعقوب چنین کرد، و هفته او را تمام کرد، و دخترخود، راحیل را به زنی بدو داد. ");
INSERT INTO pesOPV_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","و لابان، کنیزخود، بلهه را به دختر خود، راحیل به کنیزی داد. ");
INSERT INTO pesOPV_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","و به راحیل نیز درآمد و او را از لیه بیشتردوست داشتی، و هفت سال دیگر خدمت وی کرد. ");
INSERT INTO pesOPV_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","و چون خداوند دید که لیه مکروه است، رحم او را گشود. ولی راحیل، نازاد ماند. ");
INSERT INTO pesOPV_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","و لیه حامله شده، پسری بزاد و او را روبین نام نهاد، زیراگفت: «خداوند مصیبت مرا دیده است. الان شوهرم مرا دوست خواهد داشت.» ");
INSERT INTO pesOPV_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","و بار دیگرحامله شده، پسری زایید و گفت: «چونکه خداوند شنید که من مکروه هستم، این را نیز به من بخشید.» پس او را شمعون نامید. ");
INSERT INTO pesOPV_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","و باز آبستن شده، پسری زایید و گفت: «اکنون این مرتبه شوهرم با من خواهد پیوست، زیرا که برایش سه پسر زاییدم.» از این سبب او را لاوی نام نهاد. ");
INSERT INTO pesOPV_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","وبار دیگر حامله شده، پسری زایید و گفت: «این مرتبه خداوند را حمد می‌گویم.» پس او را یهودانامید. آنگاه از زاییدن بازایستاد. ");
INSERT INTO pesOPV_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","یعقوب، اولادی نزایید، راحیل برخواهر خود حسد برد. و به یعقوب گفت: «پسران به من بده والا می‌میرم.» ");
INSERT INTO pesOPV_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","آنگاه غضب یعقوب برراحیل افروخته شد و گفت: «مگر من به‌جای خدا هستم که بار رحم را از تو باز داشته است؟» ");
INSERT INTO pesOPV_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","گفت: «اینک کنیز من، بلهه! بدو درآ تا بر زانویم بزاید، و من نیز از او اولاد بیابم.» ");
INSERT INTO pesOPV_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","پس کنیز خود، بلهه را به یعقوب به زنی داد. و او به وی درآمد. ");
INSERT INTO pesOPV_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","وبلهه آبستن شده، پسری برای یعقوب زایید. ");
INSERT INTO pesOPV_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","وراحیل گفت: «خدا مرا داوری کرده است، و آوازمرا نیز شنیده، و پسری به من عطا فرموده است.» پس او را دان نام نهاد. ");
INSERT INTO pesOPV_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","و بلهه، کنیز راحیل، بازحامله شده، پسر دومین برای یعقوب زایید. ");
INSERT INTO pesOPV_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","وراحیل گفت: «به کشتیهای خدا با خواهر خودکشتی گرفتم و غالب آمدم.» و او را نفتالی نام نهاد. ");
INSERT INTO pesOPV_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","و اما لیه چون دید که از زاییدن باز‌مانده بود، کنیز خود زلفه را برداشته، او را به یعقوب به زنی داد. ");
INSERT INTO pesOPV_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","و زلفه، کنیز لیه، برای یعقوب پسری زایید. ");
INSERT INTO pesOPV_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","و لیه گفت: «به سعادت!» پس او را جادنامید. ");
INSERT INTO pesOPV_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","و زلفه، کنیز لیه، پسر دومین برای یعقوب زایید. ");
INSERT INTO pesOPV_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","و لیه گفت: «به خوشحالی من! زیرا که دختران، مرا خوشحال خواهند خواند.» واو را اشیر نام نهاد. ");
INSERT INTO pesOPV_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","و در ایام درو گندم، روبین رفت و مهرگیاهها در صحرا یافت و آنها را نزدمادر خود لیه، آورد. پس راحیل به لیه گفت: «ازمهرگیاههای پسر خود به من بده.» ");
INSERT INTO pesOPV_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","وی را گفت: «آیا کم است که شوهر مرا گرفتی و مهر گیاه پسرمرا نیز می‌خواهی بگیری؟» راحیل گفت: «امشب به عوض مهر گیاه پسرت، با تو بخوابد.» ");
INSERT INTO pesOPV_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","ووقت عصر، چون یعقوب از صحرا می‌آمد، لیه به استقبال وی بیرون شده، گفت: «به من درآ، زیرا که تو را به مهرگیاه پسر خود اجیر کردم.» پس آنشب با وی همخواب شد. ");
INSERT INTO pesOPV_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","و خدا، لیه را مستجاب فرمود که آبستن شده، پسر پنجمین برای یعقوب زایید. ");
INSERT INTO pesOPV_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","و لیه گفت: «خدا اجرت به من داده است، زیرا کنیز خود را به شوهر خود دادم.» و او را یساکار نام نهاد. ");
INSERT INTO pesOPV_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","و بار دیگر لیه حامله شده، پسر ششمین برای یعقوب زایید. ");
INSERT INTO pesOPV_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","و لیه گفت: «خدا عطای نیکو به من داده است. اکنون شوهرم با من زیست خواهد کرد، زیرا که شش پسر برای او زاییدم.» پس او را زبولون نامید. ");
INSERT INTO pesOPV_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","و بعد از آن دختری زایید، و او را دینه نام نهاد. ");
INSERT INTO pesOPV_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","پس خداراحیل را بیاد آورد، و دعای او را اجابت فرموده، خدا رحم او را گشود. ");
INSERT INTO pesOPV_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","و آبستن شده، پسری بزاد و گفت: «خدا ننگ مرا برداشته است.» ");
INSERT INTO pesOPV_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","و اورا یوسف نامیده، گفت: «خداوند پسری دیگربرای من مزید خواهد کرد.» ");
INSERT INTO pesOPV_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","و واقع شد که چون راحیل، یوسف رازایید، یعقوب به لابان گفت: «مرا مرخص کن، تا به مکان و وطن خویش بروم. ");
INSERT INTO pesOPV_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","زنان و فرزندان مراکه برای ایشان، تو را خدمت کرده‌ام به من واگذار، تا بروم زیرا خدمتی که به تو کردم، تو می‌دانی.» ");
INSERT INTO pesOPV_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","لابان وی را گفت: «کاش که منظور نظر توباشم، زیرا تفالا یافته‌ام که بخاطر تو، خداوند مرابرکت داده است.» ");
INSERT INTO pesOPV_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","و گفت: «اجرت خود را برمن معین کن تا آن را به تو دهم.» ");
INSERT INTO pesOPV_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","وی را گفت: «خدمتی که به تو کرده‌ام، خود می‌دانی، ومواشی ات چگونه نزد من بود. ");
INSERT INTO pesOPV_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","زیرا قبل ازآمدن من، مال تو قلیل بود، و به نهایت زیاد شد، وبعد از آمدن من، خداوند تو را برکت داده است. واکنون من نیز تدارک خانه خود را کی ببینم؟» ");
INSERT INTO pesOPV_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","گفت: «پس تو را چه بدهم؟» یعقوب گفت: «چیزی به من مده، اگر این کار را برای من بکنی، بار دیگر شبانی و پاسبانی گله تو را خواهم نمود. ");
INSERT INTO pesOPV_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","امروز در تمامی گله تو گردش می‌کنم، و هرمیش پیسه و ابلق و هر میش سیاه را از میان گوسفندان، و ابلق‌ها و پیسه‌ها را از بزها، جدامی سازم، و آن، اجرت من خواهد بود. ");
INSERT INTO pesOPV_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","و درآینده عدالت من، بر من شهادت خواهد داد، وقتی که بیایی تا اجرت مرا پیش خود ببینی، آنچه ازبزها، پیسه و ابلق، و آنچه از گوسفندان، سیاه نباشد، نزد من به دزدی شمرده شود.» ");
INSERT INTO pesOPV_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","لابان گفت: «اینک موافق سخن تو باشد.» ");
INSERT INTO pesOPV_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","و در همان روز، بزهای نرینه مخطط و ابلق، و همه ماده بزهای پیسه و ابلق، یعنی هر‌چه سفیدی در آن بود، و همه گوسفندان سیاه را جدا کرده، به‌دست پسران خود سپرد. ");
INSERT INTO pesOPV_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","و در میان خود و یعقوب، سه روز راه، مسافت گذارد. و یعقوب باقی گله لابان را شبانی کرد. ");
INSERT INTO pesOPV_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","و یعقوب چوبهای تر و تازه از درخت کبوده و بادام و چنار برای خود گرفت، و خطهای سفید در آنها کشید، و سفیدی را که در چوبها بود، ظاهر کرد. ");
INSERT INTO pesOPV_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","و وقتی که گله‌ها، برای آب خوردن می‌آمدند، آن چوبهایی را که خراشیده بود، درحوضها و آبخورها پیش گله‌ها می‌نهاد، تا چون برای نوشیدن بیایند، حمل بگیرند. ");
INSERT INTO pesOPV_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","پس گله هاپیش چوبها بارآور می‌شدند، و بزهای مخطط وپیسه و ابلق می‌زاییدند. ");
INSERT INTO pesOPV_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","و یعقوب، بزها را جداکرد، و روی گله‌ها را بسوی هر مخطط و سیاه درگله لابان واداشت، و گله های خود را جدا کرد و باگله لابان نگذاشت. ");
INSERT INTO pesOPV_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","و هرگاه حیوان های تنومندحمل می‌گرفتند، یعقوب چوبها را پیش آنها درآبخورها می‌نهاد، تا در میان چوبها حمل گیرند. ");
INSERT INTO pesOPV_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","و هر گاه حیوانات ضعیف بودند، آنها رانمی گذاشت، پس ضعیف‌ها از آن لابان، وتنومندها از آن یعقوب شدند. ");
INSERT INTO pesOPV_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","و آن مرد بسیارترقی نمود، و گله های بسیار و کنیزان و غلامان وشتران و حماران بهم رسانید. ");
INSERT INTO pesOPV_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","و سخنان پسران لابان را شنید که می گفتند: «یعقوب همه مایملک پدر مارا گرفته است، و از اموال پدر ما تمام این بزرگی رابهم رسانیده.» ");
INSERT INTO pesOPV_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","و یعقوب روی لابان را دید که اینک مثل سابق با او نبود. ");
INSERT INTO pesOPV_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","و خداوند به یعقوب گفت: «به زمین پدرانت و به مولد خویش مراجعت کن و من با تو خواهم بود.» ");
INSERT INTO pesOPV_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","پس یعقوب فرستاده، راحیل و لیه را به صحرا نزد گله خودطلب نمود. ");
INSERT INTO pesOPV_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","و بدیشان گفت: «روی پدر شما رامی بینم که مثل سابق با من نیست، لیکن خدای پدرم با من بوده است. ");
INSERT INTO pesOPV_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","و شما می‌دانید که به تمام قوت خود پدر شما را خدمت کرده‌ام. ");
INSERT INTO pesOPV_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","و پدرشما مرا فریب داده، ده مرتبه اجرت مرا تبدیل نمود ولی خدا او را نگذاشت که ضرری به من رساند. ");
INSERT INTO pesOPV_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","هر گاه می‌گفت اجرت تو پیسه‌ها باشد، تمام گله‌ها پیسه می‌آوردند، و هر گاه گفتی اجرت تو مخطط باشد، همه گله‌ها مخطط می‌زاییدند. ");
INSERT INTO pesOPV_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","پس خدا اموال پدر شما را گرفته، به من داده است.» ");
INSERT INTO pesOPV_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","و واقع شد هنگامی که گله‌ها حمل می‌گرفتند که در خوابی چشم خود را باز کرده، دیدم اینک قوچهایی که با میشها جمع می‌شدند، مخطط و پیسه و ابلق بودند. ");
INSERT INTO pesOPV_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","و فرشته خدا درخواب به من گفت: «ای یعقوب!» گفتم: «لبیک.» ");
INSERT INTO pesOPV_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","گفت: «اکنون چشمان خود را باز کن و بنگر که همه قوچهایی که با میشها جمع می‌شوند، مخططو پیسه و ابلق هستند زیرا که آنچه لابان به تو کرده است، دیده‌ام. ");
INSERT INTO pesOPV_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","من هستم خدای بیت ئیل، جایی که ستون را مسح کردی و با من نذر نمودی. الان برخاسته، از این زمین روانه شده، به زمین مولد خویش مراجعت نما.» ");
INSERT INTO pesOPV_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","راحیل و لیه در جواب وی گفتند: «آیا در خانه پدر ما، برای ما بهره یامیراثی باقیست؟ ");
INSERT INTO pesOPV_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","مگر نزد او چون بیگانگان محسوب نیستیم، زیرا که ما را فروخته است و نقدما را تمام خورده. ");
INSERT INTO pesOPV_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","زیرا تمام دولتی را که خدااز پدر ما گرفته است، از آن ما و فرزندان ماست، پس اکنون آنچه خدا به تو گفته است، بجا آور.» ");
INSERT INTO pesOPV_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","آنگاه یعقوب برخاسته، فرزندان و زنان خود را بر شتران سوار کرد، ");
INSERT INTO pesOPV_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","و تمام مواشی واموال خود را که اندوخته بود، یعنی مواشی حاصله خود را که در فدان ارام حاصل ساخته بود، برداشت تا نزد پدر خود اسحاق به زمین کنعان برود. ");
INSERT INTO pesOPV_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","و اما لابان برای پشم بریدن گله خود رفته بود و راحیل، بتهای پدر خود را دزدید. ");
INSERT INTO pesOPV_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","و یعقوب لابان ارامی را فریب داد، چونکه او رااز فرار کردن خود آگاه نساخت. ");
INSERT INTO pesOPV_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","پس با آنچه داشت، بگریخت و برخاسته، از نهر عبور کرد ومتوجه جبل جلعاد شد. ");
INSERT INTO pesOPV_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","در روز سوم، لابان را خبر دادند که یعقوب فرار کرده است. ");
INSERT INTO pesOPV_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","پس برادران خویش را با خودبرداشته، هفت روز راه در عقب او شتافت، تا درجبل جلعاد بدو پیوست. ");
INSERT INTO pesOPV_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","شبانگاه، خدا درخواب بر لابان ارامی ظاهر شده، به وی گفت: «باحذر باش که به یعقوب نیک یا بد نگویی.» ");
INSERT INTO pesOPV_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","پس لابان به یعقوب دررسید و یعقوب خیمه خود رادر جبل زده بود، و لابان با برادران خود نیز درجبل جلعاد فرود آمدند. ");
INSERT INTO pesOPV_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","و لابان به یعقوب گفت: «چه کردی که مرا فریب دادی و دخترانم رامثل اسیران، شمشیر برداشته، رفتی؟ ");
INSERT INTO pesOPV_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","چرامخفی فرار کرده، مرا فریب دادی و مرا آگاه نساختی تا تو را با شادی و نغمات و دف و بربطمشایعت نمایم؟ ");
INSERT INTO pesOPV_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","و مرا نگذاشتی که پسران ودختران خود ببوسم؛ الحال ابلهانه حرکتی نمودی. ");
INSERT INTO pesOPV_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","در قوت دست من است که به شمااذیت رسانم. لیکن خدای پدر شما دوش به من خطاب کرده، گفت: «با حذر باش که به یعقوب نیک یا بد نگویی.» ");
INSERT INTO pesOPV_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","و الان چونکه به خانه پدرخود رغبتی تمام داشتی البته رفتنی بودی و لکن خدایان مرا چرا دزدیدی؟» ");
INSERT INTO pesOPV_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","یعقوب در جواب لابان گفت: «سبب این بود که ترسیدم و گفتم شایددختران خود را از من به زور بگیری، ");
INSERT INTO pesOPV_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","و اما نزدهر‌که خدایانت را بیابی، او زنده نماند. در حضوربرادران ما، آنچه از اموال تو نزد ما باشد، مشخص کن و برای خود بگیر.» زیرا یعقوب ندانست که راحیل آنها را دزدیده است. ");
INSERT INTO pesOPV_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","پس لابان به خیمه یعقوب و به خیمه لیه وبه خیمه دو کنیز رفت و نیافت، و از خیمه لیه بیرون آمده، به خیمه راحیل درآمد. ");
INSERT INTO pesOPV_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","اما راحیل بتها را گرفته، زیر جهاز شتر نهاد و بر آن بنشست و لابان تمام خیمه را جست وجو کرده، چیزی نیافت. ");
INSERT INTO pesOPV_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","او به پدر خود گفت: «بنظر آقایم بدنیاید که در حضورت نمی توانم برخاست، زیرا که عادت زنان بر من است.» پس تجسس نموده، بتهارا نیافت. ");
INSERT INTO pesOPV_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","آنگاه یعقوب خشمگین شده، با لابان منازعت کرد. و یعقوب در جواب لابان گفت: «تقصیر و خطای من چیست که بدین گرمی مراتعاقب نمودی؟ ");
INSERT INTO pesOPV_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","الان که تمامی اموال مراتفتیش کردی، از همه اسباب خانه خود چه یافته‌ای، اینجا نزد برادران من و برادران خودبگذار تا در میان من و تو انصاف دهند. ");
INSERT INTO pesOPV_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","در این بیست سال که من با تو بودم، میشها و بزهایت حمل نینداختند و قوچهای گله تو را نخوردم. ");
INSERT INTO pesOPV_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","دریده شده‌ای را پیش تو نیاوردم؛ خود تاوان آن را می‌دادم و آن را از دست من می‌خواستی، خواه دزدیده شده در روز و خواه دزدیده شده درشب. ");
INSERT INTO pesOPV_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","چنین بودم که گرما در روز و سرما درشب، مرا تلف می‌کرد، و خواب از چشمانم می‌گریخت. ");
INSERT INTO pesOPV_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","بدینطور بیست سال در خانه ات بودم، چهارده سال برای دو دخترت خدمت توکردم، و شش سال برای گله ات، و اجرت مرا ده مرتبه تغییر دادی. ");
INSERT INTO pesOPV_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","و اگر خدای پدرم، خدای ابراهیم، و هیبت اسحاق با من نبودی، اکنون نیزمرا تهی‌دست روانه می‌نمودی. خدا مصیبت مراو مشقت دستهای مرا دید و دوش، تو را توبیخ نمود.» ");
INSERT INTO pesOPV_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","لابان در جواب یعقوب گفت: «این دختران، دختران منند و این پسران، پسران من واین گله، گله من و آنچه می‌بینی از آن من است. پس الیوم، به دختران خودم و به پسرانی که زاییده‌اند چه توانم کرد؟ ");
INSERT INTO pesOPV_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","اکنون بیا تا من و توعهد ببندیم که در میان من و تو شهادتی باشد.» ");
INSERT INTO pesOPV_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","پس یعقوب سنگی گرفته، آن را ستونی برپانمود. ");
INSERT INTO pesOPV_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","و یعقوب برادران خود را گفت: «سنگهاجمع کنید.» پس سنگها جمع کرده، توده‌ای ساختند و در آنجا بر توده غذا خوردند. ");
INSERT INTO pesOPV_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","ولابان آن را «یجرسهدوتا» نامید ولی یعقوب آن راجلعید خواند. ");
INSERT INTO pesOPV_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","و لابان گفت: «امروز این توده در میان من و تو شهادتی است.» از این سبب آن را «جلعید» نامید. ");
INSERT INTO pesOPV_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","و مصفه نیز، زیرا گفت: «خداوند در میان من و تو دیده بانی کند وقتی که ازیکدیگر غایب شویم. ");
INSERT INTO pesOPV_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","اگر دختران مرا آزارکنی، و سوای دختران من، زنان دیگر بگیری، هیچکس در میان ما نخواهد بود. آگاه باش، خدادر میان من و تو شاهد است.» ");
INSERT INTO pesOPV_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","و لابان به یعقوب گفت: «اینک این توده و اینک این ستونی که در میان خود و تو برپا نمودم. ");
INSERT INTO pesOPV_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","این توده شاهد است و این ستون شاهد است که من از این توده بسوی تو نگذرم و تو از این توده و از این ستون به قصدبدی بسوی من نگذری. ");
INSERT INTO pesOPV_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","خدای ابراهیم وخدای ناحور و خدای پدر ایشان در میان ماانصاف دهند.» و یعقوب قسم خورد به هیبت پدرخود اسحاق. ");
INSERT INTO pesOPV_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","آنگاه یعقوب در آن کوه، قربانی گذرانید، و برادران خود را به نان خوردن دعوت نمود، و غذا خوردند و در کوه، شب را بسر بردند. ");
INSERT INTO pesOPV_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","بامدادان لابان برخاسته، پسران و دختران خودرا بوسید و ایشان را برکت داد و لابان روانه شده، به مکان خویش مراجعت نمود. ");
INSERT INTO pesOPV_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","و یعقوب راه خود را پیش گرفت وفرشتگان خدا به وی برخوردند. ");
INSERT INTO pesOPV_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","وچون یعقوب، ایشان را دید، گفت: «این لشکرخداست!» و آن موضع را «محنایم» نامید. ");
INSERT INTO pesOPV_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","پس یعقوب، قاصدان پیش روی خود نزدبرادر خویش، عیسو به دیار سعیر به بلاد ادوم فرستاد. ");
INSERT INTO pesOPV_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","و ایشان را امر فرموده، گفت: «به آقایم، عیسو چنین گویید که بنده تو یعقوب عرض می‌کند با لابان ساکن شده، تاکنون توقف نمودم، ");
INSERT INTO pesOPV_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","و برای من گاوان و الاغان و گوسفندان و غلامان و کنیزان حاصل شده است، و فرستادم تا آقای خود را آگاهی دهم و در نظرت التفات یابم.» ");
INSERT INTO pesOPV_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","پس قاصدان، نزد یعقوب برگشته، گفتند: «نزدبرادرت، عیسو رسیدیم و اینک با چهارصد نفر به استقبال تو می‌آید.» ");
INSERT INTO pesOPV_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","آنگاه یعقوب به نهایت ترسان و متحیر شده، کسانی را که با وی بودند با گوسفندان و گاوان و شتران به دو دسته تقسیم نمود ");
INSERT INTO pesOPV_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","و گفت: «هر گاه عیسو به‌دسته اول برسد وآنها را بزند، همانا دسته دیگر رهایی یابد.» ");
INSERT INTO pesOPV_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","و یعقوب گفت: «ای خدای پدرم، ابراهیم وخدای پدرم، اسحاق، ای یهوه که به من گفتی به زمین و به مولد خویش برگرد و با تو احسان خواهم کرد. ");
INSERT INTO pesOPV_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","کمتر هستم از جمیع لطفها و ازهمه وفایی که با بنده خود کرده‌ای زیرا که باچوبدست خود از این اردن عبور کردم و الان (مالک ) دو گروه شده‌ام. ");
INSERT INTO pesOPV_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","اکنون مرا از دست برادرم، از دست عیسو رهایی ده زیرا که من از اومی ترسم، مبادا بیاید و مرا بزند، یعنی مادر وفرزندان را، ");
INSERT INTO pesOPV_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","و تو گفتی هرآینه با تو احسان کنم و ذریت تو را مانند ریگ دریا سازم که از کثرت، آن را نتوان شمرد.» ");
INSERT INTO pesOPV_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","پس آن شب را در آنجا بسر برد و از آنچه بدستش آمد، ارمغانی برای برادر خود، عیسوگرفت: ");
INSERT INTO pesOPV_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","دویست ماده بز با بیست بز نر ودویست میش با بیست قوچ، ");
INSERT INTO pesOPV_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","و سی شتر شیرده با بچه های آنها و چهل ماده گاو با ده گاو نر وبیست ماده الاغ با ده کره. ");
INSERT INTO pesOPV_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","و آنها را دسته دسته، جداجدا به نوکران خود سپرد و به بندگان خود گفت: «پیش روی من عبور کنید و در میان دسته‌ها فاصله بگذارید.» ");
INSERT INTO pesOPV_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","و نخستین را امر فرموده، گفت که «چون برادرم عیسو به تو رسد و از تو پرسیده، بگوید: از آن کیستی و کجا می‌روی و اینها که پیش توست ازآن کیست؟ ");
INSERT INTO pesOPV_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","بدو بگو: این از آن بنده ات، یعقوب است، و پیشکشی است که برای آقایم، عیسوفرستاده شده است و اینک خودش نیز در عقب ماست.» ");
INSERT INTO pesOPV_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","و همچنین دومین و سومین و همه کسانی را که از عقب آن دسته‌ها می‌رفتند، امرفرموده، گفت: «چون به عیسو برسید، بدو چنین گویید، ");
INSERT INTO pesOPV_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","و نیز گویید: اینک بنده ات، یعقوب درعقب ماست.» زیرا گفت: «غضب او را بدین ارمغانی که پیش من می‌رود، فرو خواهم نشانید، وبعد چون روی او را بینم، شاید مرا قبول فرماید.» ");
INSERT INTO pesOPV_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","پس ارمغان، پیش از او عبور کرد و او آن شب را در خیمه گاه بسر برد. ");
INSERT INTO pesOPV_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","و شبانگاه، خودش برخاست و دو زوجه ودو کنیز و یازده پسر خویش را برداشته، ایشان رااز معبر یبوق عبور داد. ");
INSERT INTO pesOPV_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","ایشان را برداشت و ازآن نهر عبور داد، و تمام مایملک خود را نیز عبورداد. ");
INSERT INTO pesOPV_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","و یعقوب تنها ماند و مردی با وی تا طلوع فجر کشتی می‌گرفت. ");
INSERT INTO pesOPV_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","و چون او دید که بر وی غلبه نمی یابد، کف ران یعقوب را لمس کرد، وکف ران یعقوب در کشتی گرفتن با او فشرده شد. ");
INSERT INTO pesOPV_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","پس گفت: «مرا رها کن زیرا که فجرمی شکافد.» گفت: «تا مرا برکت ندهی تو را رهانکنم.» ");
INSERT INTO pesOPV_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","به وی گفت: «نام تو چیست؟» گفت: «یعقوب.» ");
INSERT INTO pesOPV_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","گفت: «از این پس نام تو یعقوب خوانده نشود بلکه اسرائیل، زیرا که با خدا و باانسان مجاهده کردی و نصرت یافتی.» ");
INSERT INTO pesOPV_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","ویعقوب از او سوال کرده، گفت: «مرا از نام خودآگاه ساز.» گفت: «چرا اسم مرا می‌پرسی؟» و او رادر آنجا برکت داد. ");
INSERT INTO pesOPV_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","و یعقوب آن مکان را «فنیئیل» نامیده، گفت: «زیرا خدا را روبرو دیدم وجانم رستگار شد.» ");
INSERT INTO pesOPV_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","و چون از «فنوئیل» گذشت، آفتاب بر وی طلوع کرد، و بر ران خودمی لنگید. ");
INSERT INTO pesOPV_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","از این سبب بنی‌اسرائیل تا امروز عرق النساء را که در کف ران است، نمی خورند، زیرا کف ران یعقوب را در عرق النسا لمس کرد. ");
INSERT INTO pesOPV_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","پس یعقوب چشم خود را باز کرده، دید که اینک عیسو می‌آید و چهارصدنفر با او. آنگاه فرزندان خود را به لیه و راحیل و دوکنیز تقسیم کرد. ");
INSERT INTO pesOPV_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","و کنیزان را با فرزندان ایشان پیش داشت و لیه را با فرزندانش در عقب ایشان، وراحیل و یوسف را آخر. ");
INSERT INTO pesOPV_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","و خود در‌پیش ایشان رفته، هفت مرتبه رو به زمین نهاد تا به برادر خودرسید. ");
INSERT INTO pesOPV_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","اما عیسو دوان دوان به استقبال او آمد واو را در بر‌گرفته، به آغوش خود کشید، و او رابوسید و هر دو بگریستند. ");
INSERT INTO pesOPV_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","و چشمان خود را بازکرده، زنان و فرزندان را بدید و گفت: «این همراهان تو کیستند؟» ");
INSERT INTO pesOPV_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","آنگاه کنیزان با فرزندان ایشان نزدیک شده، تعظیم کردند. ");
INSERT INTO pesOPV_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","و لیه با فرزندانش نزدیک شده، تعظیم کردند. پس یوسف و راحیل نزدیک شده، تعظیم کردند. ");
INSERT INTO pesOPV_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","و او گفت: «از تمامی این گروهی که بدان برخوردم، چه مقصود داری؟» گفت: «تا در نظر آقای خود التفات یابم.» ");
INSERT INTO pesOPV_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","عیسوگفت: «ای برادرم مرا بسیار است، مال خود را نگاه دار.» ");
INSERT INTO pesOPV_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","یعقوب گفت: «نی، بلکه اگر در نظرت التفات یافته‌ام، پیشکش مرا از دستم قبول فرما، زیرا که روی تو را دیدم مثل دیدن روی خدا، ومرا منظور داشتی. ");
INSERT INTO pesOPV_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","پس هدیه مرا که به حضورت آورده شد بپذیر، زیرا خدا به من احسان فرموده است و همه‌چیز دارم.» پس او را الحاح نمود تا پذیرفت. ");
INSERT INTO pesOPV_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","گفت: «کوچ کرده، برویم و من همراه تو می‌آیم.» ");
INSERT INTO pesOPV_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","گفت: «آقایم آگاه است که اطفال نازکند وگوسفندان و گاوان شیرده نیز با من است، و اگرآنها را یک روز برانند، تمامی گله می‌میرند؛ ");
INSERT INTO pesOPV_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","پس آقایم پیشتر از بنده خود برود و من موافق قدم مواشی که دارم. و به حسب قدم اطفال، آهسته سفر می‌کنم، تا نزد آقای خود به سعیربرسم. ");
INSERT INTO pesOPV_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","عیسو گفت: «پس بعضی از این کسانی را که با منند نزد تو می‌گذارم.» گفت: «چه لازم است، فقط در نظر آقای خود التفات بیابم.» ");
INSERT INTO pesOPV_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","در همان روز عیسو راه خود را پیش گرفته، به سعیرمراجعت کرد. ");
INSERT INTO pesOPV_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","و اما یعقوب به سکوت سفرکرد و خانه‌ای برای خود بنا نمود و برای مواشی خود سایبانها ساخت. از این سبب آن موضع به «سکوت» نامیده شد. ");
INSERT INTO pesOPV_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","پس چون یعقوب از فدان ارام مراجعت کرد، به سلامتی به شهر شکیم، در زمین کنعان آمد، و در مقابل شهر فرود آمد. ");
INSERT INTO pesOPV_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","و آن قطعه زمینی را که خیمه خود را در آن زده بود ازبنی حمور، پدر شکیم، به صد قسیط خرید. ");
INSERT INTO pesOPV_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","ومذبحی در آنجا بنا نمود و آن را ایل الوهی اسرائیل نامید. ");
INSERT INTO pesOPV_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","پس دینه، دختر لیه، که او را برای یعقوب زاییده بود، برای دیدن دختران آن ملک بیرون رفت. ");
INSERT INTO pesOPV_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","و چون شکیم بن حمورحوی که رئیس آن زمین بود، او را بدید، او را بگرفت و با او همخواب شده، وی را بی‌عصمت ساخت. ");
INSERT INTO pesOPV_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","و دلش به دینه، دختر یعقوب، بسته شده، عاشق آن دختر گشت، و سخنان دل آویز به آن دختر گفت. ");
INSERT INTO pesOPV_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","و شکیم به پدر خود، حمورخطاب کرده، گفت: «این دختر را برای من به زنی بگیر.» ");
INSERT INTO pesOPV_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","و یعقوب شنید که دخترش دینه رابی عصمت کرده است. و چون پسرانش با مواشی او در صحرا بودند، یعقوب سکوت کرد تا ایشان بیایند. ");
INSERT INTO pesOPV_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","و حمور، پدر شکیم نزد یعقوب بیرون آمد تا به وی سخن گوید. ");
INSERT INTO pesOPV_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","و چون پسران یعقوب این را شنیدند، از صحرا آمدند و غضبناک شده، خشم ایشان به شدت افروخته شد، زیرا که بادختر یعقوب همخواب شده، قباحتی دراسرائیل نموده بود و این عمل، ناکردنی بود. ");
INSERT INTO pesOPV_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","پس حمور ایشان را خطاب کرده، گفت: «دل پسرم شکیم شیفته دختر شماست؛ او را به وی به زنی بدهید. ");
INSERT INTO pesOPV_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","و با ما مصاهرت نموده، دختران خود را به ما بدهید و دختران ما را برای خودبگیرید. ");
INSERT INTO pesOPV_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","و با ما ساکن شوید و زمین از آن شماباشد. در آن بمانید و تجارت کنید و در آن تصرف کنید.» ");
INSERT INTO pesOPV_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","و شکیم به پدر و برادران آن دختر گفت: «در نظر خود مرا منظور بدارید و آنچه به من بگویید، خواهم داد. ");
INSERT INTO pesOPV_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","مهر و پیشکش هر قدرزیاده از من بخواهید، آنچه بگویید، خواهم دادفقط دختر را به زنی به من بسپارید.» ");
INSERT INTO pesOPV_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","اما پسران یعقوب در جواب شکیم و پدرش حمور به مکرسخن‌گفتند زیرا خواهر ایشان، دینه رابی عصمت کرده بود. ");
INSERT INTO pesOPV_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","پس بدیشان گفتند: «این کار را نمی توانیم کرد که خواهر خود را به شخصی نامختون بدهیم، چونکه این برای ما ننگ است. ");
INSERT INTO pesOPV_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","لکن بدین شرط با شما همداستان می‌شویم اگر چون ما بشوید، که هر ذکوری ازشما مختون گردد. ");
INSERT INTO pesOPV_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","آنگاه دختران خود را به شما دهیم و دختران شما را برای خود گیریم و باشما ساکن شده، یک قوم شویم. ");
INSERT INTO pesOPV_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","اما اگر سخن ما را اجابت نکنید و مختون نشوید، دختر خود رابرداشته، از اینجا کوچ خواهیم کرد.» ");
INSERT INTO pesOPV_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","و سخنان ایشان بنظر حمور و بنظر شکیم بن حمور پسند افتاد. ");
INSERT INTO pesOPV_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","و آن جوان در کردن این کار تاخیر ننمود، زیرا که شیفته دختر یعقوب بود، و او از همه اهل خانه پدرش گرامی تر بود. ");
INSERT INTO pesOPV_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","پس حمور و پسرش شکیم به دروازه شهرخود آمده، مردمان شهر خود را خطاب کرده، گفتند: ");
INSERT INTO pesOPV_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","«این مردمان با ما صلاح اندیش هستند، پس در این زمین ساکن بشوند، و در آن تجارت کنند. اینک زمین از هر طرف برای ایشان وسیع است؛ دختران ایشان را به زنی بگیریم و دختران خود را بدیشان بدهیم. ");
INSERT INTO pesOPV_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","فقط بدین شرط ایشان باما متفق خواهند شد تا با ما ساکن شده، یک قوم شویم که هر ذکوری از ما مختون شود، چنانکه ایشان مختونند. ");
INSERT INTO pesOPV_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","آیا مواشی ایشان و اموال ایشان و هر حیوانی که دارند، از آن ما نمی شود؟ فقط با ایشان همداستان شویم تا با ما ساکن شوند.» ");
INSERT INTO pesOPV_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","پس همه کسانی که به دروازه شهر اودرآمدند، به سخن حمور و پسرش شکیم رضادادند، و هر ذکوری از آنانی که به دروازه شهر اودرآمدند، مختون شدند. ");
INSERT INTO pesOPV_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","و در روز سوم چون دردمند بودند، دو پسر یعقوب، شمعون و لاوی، برادران دینه، هر یکی شمشیر خود را گرفته، دلیرانه بر شهر آمدند و همه مردان را کشتند. ");
INSERT INTO pesOPV_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","وحمور و پسرش شکیم را به دم شمشیر کشتند، ودینه را از خانه شکیم برداشته، بیرون آمدند. ");
INSERT INTO pesOPV_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","وپسران یعقوب بر کشتگان آمده، شهر را غارت کردند، زیرا خواهر ایشان را بی‌عصمت کرده بودند. ");
INSERT INTO pesOPV_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","و گله‌ها و رمه‌ها و الاغها و آنچه در شهرو آنچه در صحرا بود، گرفتند. ");
INSERT INTO pesOPV_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","و تمامی اموال ایشان و همه اطفال و زنان ایشان را به اسیری بردند. و آنچه در خانه‌ها بود تاراج کردند. ");
INSERT INTO pesOPV_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","پس یعقوب به شمعون و لاوی گفت: «مرا به اضطراب انداختید، و مرا نزد سکنه این زمین، یعنی کنعانیان و فرزیان مکروه ساختید، و من در شماره قلیلم، همانا بر من جمع شوند و مرا بزنند و من با خانه‌ام هلاک شوم.» ");
INSERT INTO pesOPV_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","گفتند: «آیا او با خواهر ما مثل فاحشه عمل کند؟» ");
INSERT INTO pesOPV_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","و خدا به یعقوب گفت: «برخاسته، به بیت ئیل برآی، و در آنجا ساکن شو وآنجا برای خدایی که بر تو ظاهر شد، وقتی که ازحضور برادرت، عیسو فرار کردی، مذبحی بساز.» ");
INSERT INTO pesOPV_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","پس یعقوب به اهل خانه و همه کسانی که با وی بودند، گفت: «خدایان بیگانه‌ای را که درمیان شماست، دور کنید، و خویشتن را طاهرسازید، و رختهای خود را عوض کنید. ");
INSERT INTO pesOPV_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","تابرخاسته، به بیت ئیل برویم و آنجا برای آن خدایی که در روز تنگی من، مرا اجابت فرمود ودر راهی که رفتم با من می‌بود، مذبحی بسازم.» ");
INSERT INTO pesOPV_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","آنگاه همه خدایان بیگانه را که در دست ایشان بود، به یعقوب دادند، با گوشواره هایی که در گوشهای ایشان بود. و یعقوب آنها را زیر بلوطی که در شکیم بود دفن کرد. ");
INSERT INTO pesOPV_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","پس کوچ کردند، وخوف خدا بر شهرهای گرداگرد ایشان بود، که بنی یعقوب را تعاقب نکردند. ");
INSERT INTO pesOPV_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","و یعقوب به لوزکه در زمین کنعان واقع است، و همان بیت ئیل باشد، رسید. او با تمامی قوم که با وی بودند. ");
INSERT INTO pesOPV_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","ودر آنجا مذبحی بنا نمود و آن مکان را «ایل بیت ئیل» نامید. زیرا در آنجا خدا بر وی ظاهر شده بود، هنگامی که از حضور برادر خودمی گریخت. ");
INSERT INTO pesOPV_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","و دبوره دایه رفقه مرد. و او را زیر درخت بلوط تحت بیت ئیل دفن کردند، و آن را «الون باکوت» نامید. ");
INSERT INTO pesOPV_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","و خدا بار دیگر بر یعقوب ظاهر شد، وقتی که از فدان ارام آمد، و او را برکت داد. ");
INSERT INTO pesOPV_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","و خدا به وی گفت: «نام تو یعقوب است اما بعد از این نام تویعقوب خوانده نشود، بلکه نام تو اسرائیل خواهدبود.» پس او را اسرائیل نام نهاد. ");
INSERT INTO pesOPV_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","و خدا وی راگفت: «من خدای قادر مطلق هستم. بارور و کثیرشو. امتی و جماعتی از امتها از تو بوجود آیند، واز صلب تو پادشاهان پدید شوند. ");
INSERT INTO pesOPV_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","و زمینی که به ابراهیم و اسحاق دادم، به تو دهم؛ و به ذریت بعد از تو، این زمین را خواهم داد.» ");
INSERT INTO pesOPV_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","پس خدا ازآنجایی که با وی سخن گفت، از نزد وی صعودنمود. ");
INSERT INTO pesOPV_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","و یعقوب ستونی برپا داشت، در جایی که باوی تکلم نمود. ستونی از سنگ و هدیه‌ای ریختنی بر آن ریخت، و آن را به روغن تدهین کرد. ");
INSERT INTO pesOPV_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","پس یعقوب آن مکان را، که خدا با وی در آنجا سخن گفته بود، «بیت ئیل» نامید. ");
INSERT INTO pesOPV_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","پس، از «بیت ئیل» کوچ کردند. و چون اندک مسافتی مانده بود که به افراته برسند، راحیل راوقت وضع حمل رسید، و زاییدنش دشوار شد. ");
INSERT INTO pesOPV_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","و چون زاییدنش دشوار بود، قابله وی را گفت: «مترس زیرا که این نیز برایت پسر است.» ");
INSERT INTO pesOPV_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","و درحین جان کندن، زیرا که مرد، پسر را «بن اونی» نام نهاد، لکن پدرش وی را «بن یامین» نامید. ");
INSERT INTO pesOPV_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","پس راحیل وفات یافت، و در راه افراته که بیت لحم باشد، دفن شد. ");
INSERT INTO pesOPV_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","و یعقوب بر قبر وی ستونی نصب کرد، که آن تا امروز ستون قبرراحیل است. ");
INSERT INTO pesOPV_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","پس اسرائیل کوچ کرد، و خیمه خود را بدان طرف برج عیدر زد. ");
INSERT INTO pesOPV_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","و در حین سکونت اسرائیل در آن زمین، روبین رفته، با کنیزپدر خود، بلهه، همخواب شد. و اسرائیل این راشنید. و بنی یعقوب دوازده بودند: ");
INSERT INTO pesOPV_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","پسران لیه: روبین نخست زاده یعقوب و شمعون و لاوی ویهودا و یساکار و زبولون. ");
INSERT INTO pesOPV_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","و پسران راحیل: یوسف و بن یامین. ");
INSERT INTO pesOPV_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","و پسران بلهه کنیز راحیل: دان و نفتالی. ");
INSERT INTO pesOPV_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","و پسران زلفه، کنیز لیه: جاد واشیر. اینانند پسران یعقوب، که در فدان ارام برای او متولد شدند. ");
INSERT INTO pesOPV_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","و یعقوب نزد پدر خود، اسحاق، در ممری آمد، به قریه اربع که حبرون باشد، جایی که ابراهیم و اسحاق غربت گزیدند. ");
INSERT INTO pesOPV_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","و عمراسحاق صد و هشتاد سال بود. ");
INSERT INTO pesOPV_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","و اسحاق جان سپرد و مرد، و پیر و سالخورده به قوم خویش پیوست. و پسرانش عیسو و یعقوب او را دفن کردند. ");
INSERT INTO pesOPV_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","و پیدایش عیسو که ادوم باشد، این است: ");
INSERT INTO pesOPV_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","عیسو زنان خود را از دختران کنعانیان گرفت: یعنی عاده دختر ایلون حتی، واهولیبامه دختر عنی، دختر صبعون حوی، ");
INSERT INTO pesOPV_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","وبسمه دختر اسماعیل، خواهر نبایوت. ");
INSERT INTO pesOPV_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","و عاده، الیفاز را برای عیسو زایید، و بسمه، رعوئیل رابزاد، ");
INSERT INTO pesOPV_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","و اهولیبامه یعوش، و یعلام و قورح رازایید. اینانند پسران عیسو که برای وی در زمین کنعان متولد شدند. ");
INSERT INTO pesOPV_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","پس عیسو زنان و پسران ودختران و جمیع اهل بیت، و مواشی و همه حیوانات، و تمامی اندوخته خود را که در زمین کنعان اندوخته بود، گرفته، از نزد برادر خودیعقوب به زمین دیگر رفت. ");
INSERT INTO pesOPV_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","زیرا که اموال ایشان زیاده بود از آنکه با هم سکونت کنند. و زمین غربت ایشان بسبب مواشی ایشان گنجایش ایشان نداشت. ");
INSERT INTO pesOPV_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","و عیسو در جبل سعیر ساکن شد. وعیسو همان ادوم است. ");
INSERT INTO pesOPV_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","و این است پیدایش عیسو پدر ادوم در جبل سعیر: ");
INSERT INTO pesOPV_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","اینست نامهای پسران عیسو: الیفاز پسرعاده، زن عیسو، و رعوئیل، پسر بسمه، زن عیسو. ");
INSERT INTO pesOPV_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","و بنی الیفاز: تیمان و اومار و صفوا و جعتام وقناز بودند. ");
INSERT INTO pesOPV_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","و تمناع، کنیز الیفاز، پسر عیسوبود. وی عمالیق را برای الیفاز زایید. اینانندپسران عاده زن عیسو. ");
INSERT INTO pesOPV_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","و اینانند پسران رعوئیل: نحت و زارع و شمه و مزه. اینانند پسران بسمه زن عیسو. ");
INSERT INTO pesOPV_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","و اینانند پسران اهولیبامه دختر عنی، دختر صبعون، زن عیسو که یعوش ویعلام و قورح را برای عیسو زایید. ");
INSERT INTO pesOPV_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","اینانند امرای بنی عیسو: پسران الیفازنخست زاده عیسو، یعنی امیر تیمان و امیر اومار وامیر صفوا و امیر قناز، ");
INSERT INTO pesOPV_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","و امیر قورح و امیرجعتام و امیر عمالیق. اینانند امرای الیفاز در زمین ادوم. اینانند پسران عاده. ");
INSERT INTO pesOPV_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","و اینان پسران رعوئیل بن عیسو می‌باشند: امیر نحت و امیر زارح و امیر شمه و امیر مزه. اینهاامرای رعوئیل در زمین ادوم بودند. اینانند پسران بسمه زن عیسو. ");
INSERT INTO pesOPV_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","و اینانند بنی اهولیبامه زن عیسو: امیریعوش و امیر یعلام و امیر قورح. اینها امرای اهولیبامه دختر عنی، زن عیسو می‌باشند. ");
INSERT INTO pesOPV_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","اینانند پسران عیسو که ادوم باشد و اینهاامرای ایشان می‌باشند. ");
INSERT INTO pesOPV_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","و اینانند پسران سعیر حوری که ساکن آن زمین بودند، یعنی: لوطان و شوبال و صبعون وعنی، ");
INSERT INTO pesOPV_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","و دیشون و ایصر و دیشان. اینانند امرای حوریان و پسران سعیر در زمین ادوم. ");
INSERT INTO pesOPV_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","و پسران لوطان: حوری و هیمام بودند وخواهر لوطان تمناع، بود. ");
INSERT INTO pesOPV_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","و اینانند پسران شوبال: علوان و منحت و عیبال و شفو و اونام. ");
INSERT INTO pesOPV_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","و اینانند بنی صبعون: ایه و عنی. همین عنی است که چشمه های آب گرم را در صحرا پیدانمود، هنگامی که الاغهای پدر خود، صبعون رامی چرانید. ");
INSERT INTO pesOPV_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","و اینانند اولاد عنی: دیشون واهولیبامه دختر عنی. ");
INSERT INTO pesOPV_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","و اینانند پسران دیشان: حمدان و اشبان و بتران و کران. ");
INSERT INTO pesOPV_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","و اینانند پسران ایصر: بلهان و زعوان و عقان. ");
INSERT INTO pesOPV_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","اینانند پسران دیشان: عوص و اران. ");
INSERT INTO pesOPV_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","اینها امرای حوریانند: امیر لوطان و امیرشوبال و امیر صبعون و امیر عنی، ");
INSERT INTO pesOPV_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","امیر دیشون و امیر ایصر و امیر دیشان. اینها امرای حوریانند به حسب امرای ایشان در زمین سعیر. ");
INSERT INTO pesOPV_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","و اینانند پادشاهانی که در زمین ادوم سلطنت کردند، قبل از آنکه پادشاهی بربنی‌اسرائیل سلطنت کند: ");
INSERT INTO pesOPV_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","و بالع بن بعور درادوم پادشاهی کرد، و نام شهر او دینهابه بود. ");
INSERT INTO pesOPV_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","وبالع مرد، و در جایش یوباب بن زارح از بصره سلطنت کرد. ");
INSERT INTO pesOPV_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","و یوباب مرد، و در جایش حوشام از زمین تیمانی پادشاهی کرد. ");
INSERT INTO pesOPV_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","وحوشام مرد، و در جایش هداد بن بداد، که درصحرای موآب، مدیان را شکست داد، پادشاهی کرد، و نام شهر او عویت بود. ");
INSERT INTO pesOPV_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","و هداد مرد، و درجایش سمله از مسریقه پادشاهی نمود. ");
INSERT INTO pesOPV_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","وسمله مرد، و شاول از رحوبوت نهر در جایش پادشاهی کرد. ");
INSERT INTO pesOPV_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","و شاول مرد، و در جایش بعل حانان بن عکبور سلطنت کرد. ");
INSERT INTO pesOPV_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","و بعل حانان بن عکبور مرد، و در جایش، هدار پادشاهی کرد. ونام شهرش فاعو بود، و زنش مسمی به مهیطبئیل دختر مطرد، دختر می‌ذاهب بود. ");
INSERT INTO pesOPV_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","و اینست نامهای امرای عیسو، حسب قبائل ایشان و اماکن و نامهای ایشان: امیر تمناع وامیر علوه و امیر یتیت، ");
INSERT INTO pesOPV_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","و امیر اهولیبامه و امیرایله و امیر فینون، ");
INSERT INTO pesOPV_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","و امیر قناز و امیرتیمان و امیرمبصار، ");
INSERT INTO pesOPV_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","و امیر مجدیئیل و امیر عیرام. اینان امرای ادومند، حسب مساکن ایشان در زمین ملک ایشان. همان عیسو پدر ادوم است. ");
INSERT INTO pesOPV_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","و یعقوب در زمین غربت پدر خود، یعنی زمین کنعان ساکن شد. ");
INSERT INTO pesOPV_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","این است پیدایش یعقوب. چون یوسف هفده ساله بود، گله را با برادران خود چوپانی می‌کرد. و آن جوان باپسران بلهه و پسران زلفه، زنان پدرش، می‌بود. ویوسف از بدسلوکی ایشان پدر را خبر می‌داد. ");
INSERT INTO pesOPV_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","واسرائیل، یوسف را از سایر پسران خود بیشتردوست داشتی، زیرا که او پسر پیری او بود، وبرایش ردایی بلند ساخت. ");
INSERT INTO pesOPV_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","و چون برادرانش دیدند که پدر ایشان، او را بیشتر از همه برادرانش دوست می‌دارد، از او کینه داشتند، ونمی توانستند با وی به سلامتی سخن گویند. ");
INSERT INTO pesOPV_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","ویوسف خوابی دیده، آن را به برادران خود بازگفت. پس بر کینه او افزودند. ");
INSERT INTO pesOPV_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","و بدیشان گفت: «این خوابی را که دیده‌ام، بشنوید: ");
INSERT INTO pesOPV_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","اینک ما در مزرعه بافه‌ها می‌بستیم، که ناگاه بافه من برپا شده، بایستاد، و بافه های شماگرد آمده، به بافه من سجده کردند.» ");
INSERT INTO pesOPV_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","برادرانش به وی گفتند: «آیا فی الحقیقه بر ماسلطنت خواهی کرد؟ و بر ما مسلط خواهی شد؟» و بسبب خوابها و سخنانش بر کینه او افزودند. ");
INSERT INTO pesOPV_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","از آن پس خوابی دیگر دید، و برادران خود را ازآن خبر داده، گفت: «اینک باز خوابی دیده‌ام، که ناگاه آفتاب و ماه و یازده ستاره مرا سجده کردند.» ");
INSERT INTO pesOPV_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","و پدر و برادران خود را خبر داد، وپدرش او را توبیخ کرده، بوی گفت: «این چه خوابی است که دیده‌ای؟ آیا من و مادرت وبرادرانت حقیقت خواهیم آمد و تو را بر زمین سجده خواهیم نمود؟» ");
INSERT INTO pesOPV_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","و برادرانش بر او حسدبردند، و اما پدرش، آن امر را در خاطر نگاه داشت. ");
INSERT INTO pesOPV_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","و برادرانش برای چوپانی گله پدر خود، به شکیم رفتند. ");
INSERT INTO pesOPV_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","و اسرائیل به یوسف گفت: «آیابرادرانت در شکیم چوپانی نمی کنند، بیا تا تو رانزد ایشان بفرستم.» وی را گفت: «لبیک.» ");
INSERT INTO pesOPV_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","او راگفت: «الان برو و سلامتی برادران و سلامتی گله را ببین و نزد من خبر بیاور.» و او را از وادی حبرون فرستاد، و به شکیم آمد. ");
INSERT INTO pesOPV_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","و شخصی به اوبرخورد، و اینک، او در صحرا آواره می‌بود، پس آن شخص از او پرسیده، گفت: «چه می‌طلبی؟» ");
INSERT INTO pesOPV_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","گفت: «من برادران خود را می‌جویم، مرا خبرده که کجا چوپانی می‌کنند.» ");
INSERT INTO pesOPV_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","آن مرد گفت: «ازاینجا روانه شدند، زیرا شنیدیم که می‌گفتند: به دوتان می‌رویم.» پس یوسف از عقب برادران خود رفته، ایشان را در دوتان یافت. ");
INSERT INTO pesOPV_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","و او را ازدور دیدند، و قبل از آنکه نزدیک ایشان بیاید، باهم توطئه دیدند که اورا بکشند. ");
INSERT INTO pesOPV_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","و به یکدیگر گفتند: «اینک این صاحب خوابها می‌آید. ");
INSERT INTO pesOPV_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","اکنون بیایید او را بکشیم، و به یکی از این چاهها بیندازیم، و گوییم جانوری درنده او را خورد. و ببینیم خوابهایش چه می‌شود.» ");
INSERT INTO pesOPV_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","لیکن روبین چون این را شنید، او را از دست ایشان رهانیده، گفت: «او را نکشیم.» ");
INSERT INTO pesOPV_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","پس روبین بدیشان گفت: «خون مریزید، او را در این چاه که در صحراست، بیندازید، و دست خود رابر او دراز مکنید.» تا او را از دست ایشان رهانیده، به پدر خود رد نماید. ");
INSERT INTO pesOPV_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","و به مجرد رسیدن یوسف نزد برادران خود، رختش را یعنی آن ردای بلند را که دربرداشت، از او کندند. ");
INSERT INTO pesOPV_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","و او را گرفته، درچاه انداختند، اما چاه، خالی و بی‌آب بود. ");
INSERT INTO pesOPV_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","پس برای غذا خوردن نشستند، و چشمان خود را باز کرده، دیدند که ناگاه قافله اسماعیلیان از جلعاد می‌رسد، و شتران ایشان کتیرا و بلسان ولادن، بار دارند، و می‌روند تا آنها را به مصر ببرند. ");
INSERT INTO pesOPV_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","آنگاه یهودا به برادران خود گفت: «برادر خودرا کشتن و خون او را مخفی داشتن چه سود دارد؟ ");
INSERT INTO pesOPV_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","بیایید او را به این اسماعیلیان بفروشیم، ودست ما بر وی نباشد، زیرا که او برادر و گوشت ماست.» پس برادرانش بدین رضا دادند. ");
INSERT INTO pesOPV_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","و چون تجار مدیانی در گذر بودند، یوسف را از چاه کشیده، برآوردند، و یوسف را به اسماعیلیان به بیست پاره نقره فروختند. پس یوسف را به مصر بردند. ");
INSERT INTO pesOPV_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","و روبین چون به‌سرچاه برگشت، و دید که یوسف در چاه نیست، جامه خود را چاک زد، ");
INSERT INTO pesOPV_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","و نزد برادران خودبازآمد و گفت: «طفل نیست و من کجا بروم؟» ");
INSERT INTO pesOPV_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","پس ردای یوسف را گرفتند، و بز نری راکشته، ردا را در خونش فرو بردند. ");
INSERT INTO pesOPV_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","و آن ردای بلند را فرستادند و به پدر خود رسانیده، گفتند: «این را یافته‌ایم، تشخیص کن که ردای پسرت است یا نه.» ");
INSERT INTO pesOPV_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","پس آن را شناخته، گفت: «ردای پسر من است! جانوری درنده او را خورده است، و یقین یوسف دریده شده است.» ");
INSERT INTO pesOPV_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","و یعقوب رخت خود را پاره کرده، پلاس دربر کرد، وروزهای بسیار برای پسر خود ماتم گرفت. ");
INSERT INTO pesOPV_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","وهمه پسران و همه دخترانش به تسلی اوبرخاستند. اما تسلی نپذیرفت، و گفت: «سوگوارنزد پسر خود به گور فرود می‌روم.» پس پدرش برای وی همی گریست. ");
INSERT INTO pesOPV_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","اما مدیانیان، یوسف را در مصر، به فوطیفار که خواجه فرعون و سردارافواج خاصه بود، فروختند. ");
INSERT INTO pesOPV_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","و واقع شد در آن زمان که یهودا ازنزد برادران خود رفته، نزد شخصی عدلامی، که حیره نام داشت، مهمان شد. ");
INSERT INTO pesOPV_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","و درآنجا یهودا، دختر مرد کنعانی را که مسمی به شوعه بود، دید و او را گرفته، بدو درآمد. ");
INSERT INTO pesOPV_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","پس آبستن شده، پسری زایید و او را عیر نام نهاد. ");
INSERT INTO pesOPV_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","وبار دیگر آبستن شده، پسری زایید و او را اونان نامید. ");
INSERT INTO pesOPV_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","و باز هم پسری زاییده، او را شیله نام گذارد. و چون او را زایید، یهودا در کزیب بود. ");
INSERT INTO pesOPV_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","و یهودا، زنی مسمی به تامار، برای نخست زاده خود عیر گرفت. ");
INSERT INTO pesOPV_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","و نخست زاده یهودا، عیر، در نظر خداوند شریر بود، و خداونداو را بمیراند. ");
INSERT INTO pesOPV_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","پس یهودا به اونان گفت: «به زن برادرت درآی، و حق برادر شوهری را بجاآورده، نسلی برای برادر خود پیدا کن.» ");
INSERT INTO pesOPV_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","لکن چونکه اونان دانست که آن نسل از آن او نخواهدبود، هنگامی که به زن برادر خود درآمد، بر زمین انزال کرد، تا نسلی برای برادر خود ندهد. ");
INSERT INTO pesOPV_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","و این کار او در نظر خداوند ناپسند آمد، پس او را نیزبمیراند. ");
INSERT INTO pesOPV_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","و یهودا به عروس خود، تامار گفت: «در خانه پدرت بیوه بنشین تا پسرم شیله بزرگ شود.» زیرا گفت: «مبادا او نیز مثل برادرانش بمیرد.» پس تامار رفته، در خانه پدر خود ماند. ");
INSERT INTO pesOPV_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","و چون روزها سپری شد، دختر شوعه زن یهودا مرد. و یهودا بعد از تعزیت او با دوست خود حیره عدلامی، نزد پشم‌چینان گله خود، به تمنه آمد. ");
INSERT INTO pesOPV_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","و به تامار خبر داده، گفتند: «اینک پدرشوهرت برای چیدن پشم گله خویش، به تمنه می‌آید.» ");
INSERT INTO pesOPV_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","پس رخت بیوگی را از خویشتن بیرون کرده، برقعی به رو کشیده، خود را درچادری پوشید، و به دروازه عینایم که در راه تمنه است، بنشست. زیرا که دید شیله بزرگ شده است، و او را به وی به زنی ندادند. ");
INSERT INTO pesOPV_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","چون یهودااو را بدید، وی را فاحشه پنداشت، زیرا که روی خود را پوشیده بود. ");
INSERT INTO pesOPV_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","پس از راه به سوی او میل کرده، گفت: «بیا تابه تو درآیم.» زیرا ندانست که عروس اوست. گفت: «مرا چه می‌دهی تا به من درآیی.» ");
INSERT INTO pesOPV_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","گفت: «بزغاله‌ای از گله می‌فرستم.» گفت: «آیا گرومی دهی تا بفرستی.» ");
INSERT INTO pesOPV_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","گفت: «تو را چه گرودهم.» گفت: «مهر و زنار خود را و عصایی که دردست داری.» پس به وی داد، و بدو درآمد، و او ازوی آبستن شد. ");
INSERT INTO pesOPV_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","و برخاسته، برفت. و برقع را ازخود برداشته، رخت بیوگی پوشید. ");
INSERT INTO pesOPV_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","و یهودا بزغاله را به‌دست دوست عدلامی خود فرستاد، تا گرو را از دست آن زن بگیرد، امااو را نیافت. ");
INSERT INTO pesOPV_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","و از مردمان آن مکان پرسیده، گفت: «آن فاحشه‌ای که سر راه عینایم نشسته بود، کجاست؟» گفتند: «فاحشه‌ای در اینجا نبود.» ");
INSERT INTO pesOPV_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","پس نزد یهودا برگشته، گفت: «او را نیافتم، ومردمان آن مکان نیز می‌گویند که فاحشه‌ای دراینجا نبود.» ");
INSERT INTO pesOPV_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","یهودا گفت: «بگذار برای خودنگاه دارد، مبادا رسوا شویم. اینک بزغاله رافرستادم و تو او را نیافتی.» ");
INSERT INTO pesOPV_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","و بعد از سه ماه یهودا را خبر داده، گفتند: «عروس تو تامار، زناکرده است و اینک از زنا نیز آبستن شده.» پس یهودا گفت: «وی را بیرون آرید تا سوخته شود!» ");
INSERT INTO pesOPV_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","چون او را بیرون می‌آوردند نزد پدر شوهر خود فرستاده، گفت: «از مالک این چیزها آبستن شده‌ام، و گفت: «تشخیص کن که این مهر و زنار وعصا از آن کیست.» ");
INSERT INTO pesOPV_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","و یهودا آنها را شناخت، وگفت: «او از من بی‌گناه تر است، زیرا که او را به پسر خود شیله ندادم. و بعد او را دیگر نشناخت. ");
INSERT INTO pesOPV_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","و چون وقت وضع حملش رسید، اینک توامان در رحمش بودند. ");
INSERT INTO pesOPV_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","و چون می‌زایید، یکی دست خود را بیرون آورد که در حال قابله ریسمانی قرمز گرفته، بر دستش بست و گفت: «این اول بیرون آمد.» ");
INSERT INTO pesOPV_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","و دست خود را بازکشید. و اینک برادرش بیرون آمد و قابله گفت: «چگونه شکافتی، این شکاف بر تو باد.» پس او را فارص نام نهاد. ");
INSERT INTO pesOPV_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","بعد از آن برادرش که ریسمان قرمز را بردست داشت بیرون آمد، و او را زارح نامید. ");
INSERT INTO pesOPV_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","اما یوسف را به مصر بردند، و مردی مصری، فوطیفار نام که خواجه و سردارافواج خاصه فرعون بود، وی را از دست اسماعیلیانی که او را بدانجا برده بودند، خرید. ");
INSERT INTO pesOPV_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","وخداوند با یوسف می‌بود، و او مردی کامیاب شد، و در خانه آقای مصری خود ماند. ");
INSERT INTO pesOPV_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","و آقایش دیدکه خداوند با وی می‌باشد، و هر‌آنچه او می‌کند، خداوند در دستش راست می‌آورد. ");
INSERT INTO pesOPV_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","پس یوسف در نظر وی التفات یافت، و او را خدمت می‌کرد، واو را به خانه خود برگماشت و تمام مایملک خویش را بدست وی سپرد. ");
INSERT INTO pesOPV_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","و واقع شد بعد ازآنکه او را بر خانه و تمام مایملک خود گماشته بود، که خداوند خانه آن مصری را بسبب یوسف برکت داد، و برکت خداوند بر همه اموالش، چه در خانه و چه در صحرا بود. ");
INSERT INTO pesOPV_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","و آنچه داشت به‌دست یوسف واگذاشت، و از آنچه با وی بود، خبر نداشت جز نانی که می‌خورد. و یوسف خوش اندام و نیک منظر بود. ");
INSERT INTO pesOPV_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","و بعد از این امور واقع شد که زن آقایش بریوسف نظر انداخته، گفت: «با من همخواب شو.» ");
INSERT INTO pesOPV_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","اما او ابا نموده، به زن آقای خود گفت: «اینک آقایم از آنچه نزد من در خانه است، خبر ندارد، وآنچه دارد، به‌دست من سپرده است. ");
INSERT INTO pesOPV_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","بزرگتری ازمن در این خانه نیست و چیزی از من دریغ نداشته، جز تو، چون زوجه او می‌باشی؛ پس چگونه مرتکب این شرارت بزرگ بشوم و به خدا خطاورزم؟» ");
INSERT INTO pesOPV_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","و اگرچه هر روزه به یوسف سخن می‌گفت، به وی گوش نمی گرفت که با او بخوابد یانزد وی بماند. ");
INSERT INTO pesOPV_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","و روزی واقع شد که به خانه درآمد، تا به شغل خود پردازد و از اهل خانه کسی آنجا درخانه نبود. ");
INSERT INTO pesOPV_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","پس جامه او را گرفته، گفت: «با من بخواب.» اما او جامه خود را به‌دستش رها کرده، گریخت و بیرون رفت. ");
INSERT INTO pesOPV_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","و چون او دید که رخت خود را به‌دست وی ترک کرد و از خانه گریخت، ");
INSERT INTO pesOPV_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","مردان خانه راصدا زد، و بدیشان بیان کرده، گفت: «بنگرید، مردعبرانی را نزد ما آورد تا ما را مسخره کند، و نزدمن آمد تا با من بخوابد، و به آواز بلند فریاد کردم، ");
INSERT INTO pesOPV_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","و چون شنید که به آواز بلند فریاد برآوردم، جامه خود را نزد من واگذارده، فرار کرد و بیرون رفت.» ");
INSERT INTO pesOPV_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","پس جامه او را نزد خود نگاه داشت، تاآقایش به خانه آمد. ");
INSERT INTO pesOPV_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","و به وی بدین مضمون ذکر کرده، گفت: «آن غلام عبرانی که برای ماآورده‌ای، نزد من آمد تا مرا مسخره کند، ");
INSERT INTO pesOPV_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","وچون به آواز بلند فریاد برآوردم، جامه خود راپیش من رها کرده، بیرون گریخت.» ");
INSERT INTO pesOPV_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","پس چون آقایش سخن زن خود را شنید که به وی بیان کرده، گفت: «غلامت به من چنین کرده است، » خشم او افروخته شد. ");
INSERT INTO pesOPV_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","و آقای یوسف، او را گرفته، در زندان خانه‌ای که اسیران پادشاه بسته بودند، انداخت و آنجا در زندان ماند. ");
INSERT INTO pesOPV_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","اماخداوند با یوسف می‌بود و بر وی احسان می‌فرمود، و او را در نظر داروغه زندان حرمت داد. ");
INSERT INTO pesOPV_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","و داروغه زندان همه زندانیان را که درزندان بودند، به‌دست یوسف سپرد. و آنچه درآنجا می‌کردند، او کننده آن بود. ");
INSERT INTO pesOPV_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","و داروغه زندان بدانچه در دست وی بود، نگاه نمی کرد، زیرا خداوند با وی می‌بود و آنچه را که او می‌کرد، خداوند راست می‌آورد. ");
INSERT INTO pesOPV_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","و بعد از این امور، واقع شد که ساقی و خباز پادشاه مصر، به آقای خویش، پادشاه مصر خطا کردند. ");
INSERT INTO pesOPV_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","و فرعون به دو خواجه خود، یعنی سردار ساقیان و سردار خبازان غضب نمود. ");
INSERT INTO pesOPV_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","و ایشان را در زندان رئیس افواج خاصه، یعنی زندانی که یوسف در آنجا محبوس بود، انداخت. ");
INSERT INTO pesOPV_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","و سردار افواج خاصه، یوسف را برایشان گماشت، و ایشان را خدمت می‌کرد، ومدتی در زندان ماندند. ");
INSERT INTO pesOPV_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","و هر دو در یک شب خوابی دیدند، هر کدام خواب خود را. هر کدام موافق تعبیر خود، یعنی ساقی و خباز پادشاه مصر که در زندان محبوس بودند. ");
INSERT INTO pesOPV_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","بامدادان چون یوسف نزد ایشان آمد، دید که اینک ملول هستند. ");
INSERT INTO pesOPV_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","پس، از خواجه های فرعون، که با وی در زندان آقای او بودند، پرسیده، گفت: «امروز چرا روی شما غمگین است؟» ");
INSERT INTO pesOPV_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","به وی گفتند: «خوابی دیده‌ایم و کسی نیست که آن را تعبیر کند.» یوسف بدیشان گفت: «آیا تعبیرها از آن خدانیست؟ آن را به من بازگویید.» ");
INSERT INTO pesOPV_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","آنگاه رئیس ساقیان، خواب خود را به یوسف بیان کرده، گفت: «در خواب من، اینک تاکی پیش روی من بود. ");
INSERT INTO pesOPV_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","و در تاک سه شاخه بود و آن بشکفت، و گل آورد و خوشه هایش انگور رسیده داد. ");
INSERT INTO pesOPV_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","و جام فرعون در دست من بود. و انگورها را چیده، در جام فرعون فشردم، وجام را به‌دست فرعون دادم.» ");
INSERT INTO pesOPV_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","یوسف به وی گفت: «تعبیرش اینست، سه شاخه سه روز است. ");
INSERT INTO pesOPV_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","بعد از سه روز، فرعون سر تو را برافرازد و به منصبت بازگمارد، و جام فرعون را به‌دست وی دهی به رسم سابق، که ساقی او بودی. ");
INSERT INTO pesOPV_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","و هنگامی که برای تو نیکوشود، مرا یاد کن و به من احسان نموده، احوال مرانزد فرعون مذکور ساز، و مرا از این خانه بیرون آور، ");
INSERT INTO pesOPV_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","زیرا که فی الواقع از زمین عبرانیان دزدیده شده‌ام، و اینجا نیز کاری نکرده‌ام که مرا درسیاه چال افکنند.» ");
INSERT INTO pesOPV_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","اما چون رئیس خبازان دید که تعبیر، نیکوبود، به یوسف گفت: «من نیز خوابی دیده‌ام، که اینک سه سبد نان سفید بر سر من است، ");
INSERT INTO pesOPV_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","و درسبد زبرین هر قسم طعام برای فرعون از پیشه خباز می‌باشد و مرغان، آن را از سبدی که بر سر من است، می‌خورند.» ");
INSERT INTO pesOPV_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","یوسف در جواب گفت: «تعبیرش این است، سه سبد سه روز می‌باشد. ");
INSERT INTO pesOPV_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","و بعد از سه روز فرعون سر تو را از تو بردارد وتو را بر دار بیاویزد، و مرغان، گوشتت را از توبخورند.» ");
INSERT INTO pesOPV_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","پس در روز سوم که یوم میلاد فرعون بود، ضیافتی برای همه خدام خود ساخت، و سررئیس ساقیان و سر رئیس خبازان را در میان نوکران خود برافراشت. ");
INSERT INTO pesOPV_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","اما رئیس ساقیان را به ساقی گریش باز آورد، و جام را به‌دست فرعون داد. ");
INSERT INTO pesOPV_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","و اما رئیس خبازان را به دار کشید، چنانکه یوسف برای ایشان تعبیر کرده بود. ");
INSERT INTO pesOPV_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","لیکن رئیس ساقیان، یوسف را به یاد نیاورد، بلکه او رافراموش کرد. ");
INSERT INTO pesOPV_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","و واقع شد، چون دو سال سپری شد، که فرعون خوابی دید که اینک بر کنارنهر ایستاده است. ");
INSERT INTO pesOPV_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","که ناگاه از نهر، هفت گاوخوب صورت و فربه گوشت برآمده، بر مرغزارمی چریدند. ");
INSERT INTO pesOPV_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","و اینک هفت گاو دیگر، بد صورت و لاغر گوشت، در عقب آنها از نهر برآمده، به پهلوی آن گاوان اول به کنار نهر ایستادند. ");
INSERT INTO pesOPV_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","و این گاوان زشت صورت و لاغر گوشت، آن هفت گاوخوب صورت و فربه را فرو بردند. و فرعون بیدارشد. ");
INSERT INTO pesOPV_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","و باز بخسبید و دیگر باره خوابی دید، که اینک هفت سنبله پر و نیکو بر یک ساق برمی آید. ");
INSERT INTO pesOPV_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","و اینک هفت سنبله لاغر، از باد شرقی پژمرده، بعد از آنها می‌روید. ");
INSERT INTO pesOPV_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","و سنبله های لاغر، آن هفت سنبله فربه و پر را فرو بردند، و فرعون بیدار شده، دید که اینک خوابی است. ");
INSERT INTO pesOPV_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","صبحگاهان دلش مضطرب شده، فرستاد و همه جادوگران و جمیع حکیمان مصر را خواند، و فرعون خوابهای خودرا بدیشان باز‌گفت. اما کسی نبود که آنها را برای فرعون تعبیر کند. ");
INSERT INTO pesOPV_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","آنگاه رئیس ساقیان به فرعون عرض کرده، گفت: «امروز خطایای من بخاطرم آمد. ");
INSERT INTO pesOPV_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","فرعون بر غلامان خود غضب نموده، مرا با رئیس خبازان در زندان سردار افواج خاصه، حبس فرمود. ");
INSERT INTO pesOPV_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","ومن و او در یک شب، خوابی دیدیم، هر یک موافق تعبیر خواب خود، خواب دیدیم. ");
INSERT INTO pesOPV_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","و جوانی عبرانی در آنجا با ما بود، غلام سردار افواج خاصه. و خوابهای خود را نزد او بیان کردیم و اوخوابهای ما را برای ما تعبیر کرد، هر یک را موافق خوابش تعبیر کرد. ");
INSERT INTO pesOPV_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","و به عینه موافق تعبیری که برای ما کرد، واقع شد. مرا به منصبم بازآورد، و اورا به دار کشید.» ");
INSERT INTO pesOPV_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","آنگاه فرعون فرستاده، یوسف را خواند، واو را به زودی از زندان بیرون آوردند. و صورت خود را تراشیده، رخت خود را عوض کرد، و به حضور فرعون آمد. ");
INSERT INTO pesOPV_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","فرعون به یوسف گفت: «خوابی دیده‌ام و کسی نیست که آن را تعبیر کند، و درباره تو شنیدم که خواب می‌شنوی تا تعبیرش کنی.» ");
INSERT INTO pesOPV_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","یوسف فرعون را به پاسخ گفت: «از من نیست، خدا فرعون را به سلامتی جواب خواهدداد.» ");
INSERT INTO pesOPV_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","و فرعون به یوسف گفت: «در خواب خوددیدم که اینک به کنار نهر ایستاده‌ام، ");
INSERT INTO pesOPV_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","و ناگاه هفت گاو فربه گوشت و خوب صورت از نهر برآمده، بر مرغزار می‌چرند. ");
INSERT INTO pesOPV_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","و اینک هفت گاودیگر زبون و بسیار زشت صورت و لاغر گوشت، که در تمامی زمین مصر بدان زشتی ندیده بودم، در عقب آنها برمی آیند. ");
INSERT INTO pesOPV_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","و گاوان لاغر زشت، هفت گاو فربه اول را می‌خورند. ");
INSERT INTO pesOPV_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","و چون به شکم آنها فرو رفتند معلوم نشد که بدرون آنهاشدند، زیرا که صورت آنها مثل اول زشت ماند. پس بیدار شدم. ");
INSERT INTO pesOPV_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","و باز خوابی دیدم که اینک هفت سنبله پر و نیکو بر یک ساق برمی آید. ");
INSERT INTO pesOPV_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","واینک هفت سنبله خشک باریک و از باد شرقی پژمرده، بعد از آنها می‌روید. ");
INSERT INTO pesOPV_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","و سنابل لاغر، آن هفت سنبله نیکو را فرو می‌برد. و جادوگران راگفتم، لیکن کسی نیست که برای من شرح کند.» ");
INSERT INTO pesOPV_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","یوسف به فرعون گفت: «خواب فرعون یکی است. خدا از آنچه خواهد کرد، فرعون راخبر داده است. ");
INSERT INTO pesOPV_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","هفت گاو نیکو هفت سال باشدو هفت سنبله نیکو هفت سال. همانا خواب یکی است. ");
INSERT INTO pesOPV_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","و هفت گاو لاغر زشت، که در عقب آنهابرآمدند، هفت سال باشد. و هفت سنبله خالی ازباد شرقی پژمرده، هفت سال قحط می‌باشد. ");
INSERT INTO pesOPV_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","سخنی که به فرعون گفتم، این است: آنچه خدامی کند به فرعون ظاهر ساخته است. ");
INSERT INTO pesOPV_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","هماناهفت سال فراوانی بسیار، در تمامی زمین مصرمی آید. ");
INSERT INTO pesOPV_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","و بعد از آن، هفت سال قحط پدیدآید. و تمامی فراوانی در زمین مصر فراموش شود. و قحط، زمین را تباه خواهد ساخت. ");
INSERT INTO pesOPV_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","وفراوانی در زمین معلوم نشود بسبب قحطی که بعداز آن آید، زیرا که به غایت سخت خواهد بود. ");
INSERT INTO pesOPV_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","و چون خواب به فرعون دو مرتبه مکرر شد، این است که این حادثه از جانب خدا مقرر شده، و خدا آن را به زودی پدید خواهد آورد. ");
INSERT INTO pesOPV_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","پس اکنون فرعون می‌باید مردی بصیر و حکیم را پیدانموده، و او را بر زمین مصر بگمارد. ");
INSERT INTO pesOPV_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","فرعون چنین بکند، و ناظران بر زمین برگمارد، و در هفت سال فراوانی، خمس از زمین مصر بگیرد. ");
INSERT INTO pesOPV_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","وهمه ماکولات این سالهای نیکو را که می‌آیدجمع کنند، و غله را زیر دست فرعون ذخیره نمایند، و خوراک در شهرها نگاه دارند. ");
INSERT INTO pesOPV_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","تاخوراک برای زمین، به جهت هفت سال قحطی که در زمین مصر خواهد بود ذخیره شود، مبادا زمین از قحط تباه گردد.» ");
INSERT INTO pesOPV_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","پس این سخن بنظر فرعون و بنظر همه بندگانش پسند آمد. ");
INSERT INTO pesOPV_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","و فرعون به بندگان خودگفت: «آیا کسی را مثل این توانیم یافت، مردی که روح خدا در وی است؟» ");
INSERT INTO pesOPV_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","و فرعون به یوسف گفت: «چونکه خدا کل این امور را بر تو کشف کرده است، کسی مانند تو بصیر و حکیم نیست. ");
INSERT INTO pesOPV_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","تو بر خانه من باش، و به فرمان تو، تمام قوم من منتظم شوند، جز اینکه بر تخت از تو بزرگترباشم.» ");
INSERT INTO pesOPV_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","و فرعون به یوسف گفت: «بدانکه تو را برتمامی زمین مصر گماشتم.» ");
INSERT INTO pesOPV_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","و فرعون انگشترخود را از دست خویش بیرون کرده، آن را بردست یوسف گذاشت، و او را به کتان نازک آراسته کرد، و طوقی زرین بر گردنش انداخت. ");
INSERT INTO pesOPV_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","و او را بر عرابه دومین خود سوار کرد، و پیش رویش ندا می‌کردند که «زانو زنید!» پس او را برتمامی زمین مصر برگماشت. ");
INSERT INTO pesOPV_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","و فرعون به یوسف گفت: «من فرعون هستم، و بدون توهیچکس دست یا پای خود را در کل ارض مصربلند نکند.» ");
INSERT INTO pesOPV_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","و فرعون یوسف را صفنات فعنیح نامید، و اسنات، دختر فوطی فارع، کاهن اون رابدو به زنی داد، و یوسف بر زمین مصر بیرون رفت. ");
INSERT INTO pesOPV_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","و یوسف سی ساله بود وقتی که به حضورفرعون، پادشاه مصر بایستاد، و یوسف از حضورفرعون بیرون شده، در تمامی زمین مصر گشت. ");
INSERT INTO pesOPV_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","و در هفت سال فراوانی، زمین محصول خود رابه کثرت آورد. ");
INSERT INTO pesOPV_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","پس تمامی ماکولات آن هفت سال را که در زمین مصر بود، جمع کرد، و خوراک را در شهرها ذخیره نمود، و خوراک مزارع حوالی هر شهر را در آن گذاشت. ");
INSERT INTO pesOPV_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","و یوسف غله بیکران بسیار، مثل ریگ دریا ذخیره کرد، تا آنکه ازحساب بازماند، زیرا که از حساب زیاده بود. ");
INSERT INTO pesOPV_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","وقبل از وقوع سالهای قحط، دو پسر برای یوسف زاییده شد، که اسنات، دختر فوطی فارع، کاهن اون برایش بزاد. ");
INSERT INTO pesOPV_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","و یوسف نخست زاده خود رامنسی نام نهاد، زیرا گفت: «خدا مرا از تمامی مشقتم و تمامی خانه پدرم فراموشی داد.» ");
INSERT INTO pesOPV_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","ودومین را افرایم نامید، زیرا گفت: «خدا مرا درزمین مذلتم بارآور گردانید.» ");
INSERT INTO pesOPV_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","و هفت سال فراوانی که در زمین مصر بود، سپری شد. ");
INSERT INTO pesOPV_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","و هفت سال قحط، آمدن گرفت، چنانکه یوسف گفته بود. و قحط در همه زمینهاپدید شد، لیکن در تمامی زمین مصر نان بود. ");
INSERT INTO pesOPV_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","وچون تمامی زمین مصر مبتلای قحط شد، قوم برای نان نزد فرعون فریاد برآوردند. و فرعون به همه مصریان گفت: «نزد یوسف بروید و آنچه او به شما گوید، بکنید.» ");
INSERT INTO pesOPV_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","پس قحط، تمامی روی زمین را فروگرفت، و یوسف همه انبارها را بازکرده، به مصریان می‌فروخت، و قحط در زمین مصر سخت شد. ");
INSERT INTO pesOPV_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","و همه زمینها به جهت خریدغله نزد یوسف به مصر آمدند، زیرا قحط برتمامی زمین سخت شد. ");
INSERT INTO pesOPV_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","و اما یعقوب چون دید که غله درمصر است، پس یعقوب به پسران خودگفت: «چرا به یکدیگر می‌نگرید؟» ");
INSERT INTO pesOPV_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","و گفت: «اینک شنیده‌ام که غله در مصر است، بدانجابروید و برای ما از آنجا بخرید، تا زیست کنیم ونمیریم.» ");
INSERT INTO pesOPV_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","پس ده برادر یوسف برای خریدن غله به مصر فرود آمدند. ");
INSERT INTO pesOPV_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","و اما بنیامین، برادر یوسف رایعقوب با برادرانش نفرستاد، زیرا گفت مبادازیانی بدو رسد. ");
INSERT INTO pesOPV_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","پس بنی‌اسرائیل در میان آنانی که می‌آمدند، به جهت خرید آمدند، زیرا که قحطدر زمین کنعان بود. ");
INSERT INTO pesOPV_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","و یوسف حاکم ولایت بود، و خود به همه اهل زمین غله می‌فروخت. و برادران یوسف آمده، رو به زمین نهاده، او را سجده کردند. ");
INSERT INTO pesOPV_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","چون یوسف برادران خود را دید، ایشان را بشناخت، وخود را بدیشان بیگانه نموده، آنها را به درشتی، سخن گفت و از ایشان پرسید: «از کجا آمده‌اید؟» گفتند: «از زمین کنعان تا خوراک بخریم.» ");
INSERT INTO pesOPV_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","و یوسف برادران خود را شناخت، لیکن ایشان او را نشناختند. ");
INSERT INTO pesOPV_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","و یوسف خوابها را که درباره ایشان دیده بود، بیاد آورد. پس بدیشان گفت: «شما جاسوسانید، و به جهت دیدن عریانی زمین آمده‌اید.» ");
INSERT INTO pesOPV_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","بدو گفتند: «نه، یا سیدی! بلکه غلامانت به جهت خریدن خوراک آمده‌اند. ");
INSERT INTO pesOPV_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","ماهمه پسران یک شخص هستیم. ما مردمان صادقیم؛ غلامانت، جاسوس نیستند.» ");
INSERT INTO pesOPV_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","بدیشان گفت: «نه، بلکه به جهت دیدن عریانی زمین آمده‌اید.» ");
INSERT INTO pesOPV_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","گفتند: «غلامانت دوازده برادرند، پسران یک مرد در زمین کنعان. و اینک کوچکتر، امروز نزد پدر ماست، و یکی نایاب شده است.» ");
INSERT INTO pesOPV_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","یوسف بدیشان گفت: «همین است آنچه به شما گفتم که جاسوسانید! ");
INSERT INTO pesOPV_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","بدینطور آزموده می‌شوید: به حیات فرعون از اینجا بیرون نخواهید رفت، جز اینکه برادر کهتر شما در اینجابیاید. ");
INSERT INTO pesOPV_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","یک نفر از خودتان بفرستید، تا برادر شمارا بیاورد، و شما اسیر بمانید تا سخن شما آزموده شود که صدق با شماست یا نه، والا به حیات فرعون جاسوسانید!» ");
INSERT INTO pesOPV_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","پس ایشان را با هم سه روز در زندان انداخت. ");
INSERT INTO pesOPV_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","و روز سوم یوسف بدیشان گفت: «این رابکنید و زنده باشید، زیرا من از خدا می‌ترسم: ");
INSERT INTO pesOPV_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","هر گاه شما صادق هستید، یک برادر از شما درزندان شما اسیر باشد، و شما رفته، غله برای گرسنگی خانه های خود ببرید. ");
INSERT INTO pesOPV_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","و برادر کوچک خود را نزد من آرید، تا سخنان شما تصدیق شودو نمیرید.» پس چنین کردند. ");
INSERT INTO pesOPV_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","و به یکدیگر گفتند: «هر آینه به برادر خودخطا کردیم، زیرا تنگی جان او را دیدیم وقتی که به ما استغاثه می‌کرد، و نشنیدیم. از این‌رو این تنگی بر ما رسید.» ");
INSERT INTO pesOPV_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","و روبین در جواب ایشان گفت: «آیا به شما نگفتم که به پسر خطا مورزید؟ ");
INSERT INTO pesOPV_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","و ایشان ندانستند که یوسف می‌فهمد، زیرا که ترجمانی در میان ایشان بود. ");
INSERT INTO pesOPV_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","پس از ایشان کناره جسته، بگریست و نزدایشان برگشته، با ایشان گفتگو کرد، و شمعون را ازمیان ایشان گرفته، او را روبروی ایشان دربند نهاد. ");
INSERT INTO pesOPV_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","و یوسف فرمود تا جوالهای ایشان را از غله پر سازند، و نقد ایشان را در عدل هر کس نهند، وزاد سفر بدیشان دهند، و به ایشان چنین کردند. ");
INSERT INTO pesOPV_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","پس غله را بر حماران خود بار کرده، از آنجاروانه شدند. ");
INSERT INTO pesOPV_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","و چون یکی، عدل خود را در منزل باز کرد، تا خوراک به الاغ دهد، نقد خود را دید که اینک در دهن عدل او بود. ");
INSERT INTO pesOPV_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","و به برادران خود گفت: «نقد من رد شده است، و اینک در عدل من است. آنگاه دل ایشان طپیدن گرفت، و به یکدیگر لرزان شده، گفتند: «این چیست که خدا به ما کرده است.» ");
INSERT INTO pesOPV_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","پس نزد پدر خود، یعقوب، به زمین کنعان آمدند، و از آنچه بدیشان واقع شده بود، خبرداده، گفتند: ");
INSERT INTO pesOPV_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","«آن مرد که حاکم زمین است، با مابه سختی سخن گفت، و ما را جاسوسان زمین پنداشت. ");
INSERT INTO pesOPV_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","و بدو گفتیم ما صادقیم و جاسوس نی. ");
INSERT INTO pesOPV_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","ما دوازده برادر، پسران پدر خود هستیم، یکی نایاب شده است، و کوچکتر، امروز نزد پدرما در زمین کنعان می‌باشد. ");
INSERT INTO pesOPV_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","و آن مرد که حاکم زمین است، به ما گفت: از این خواهم فهمید که شما راستگو هستید که یکی از برادران خود را نزدمن گذارید، و برای گرسنگی خانه های خودگرفته، بروید. ");
INSERT INTO pesOPV_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","و برادر کوچک خود را نزد من آرید، و خواهم یافت که شما جاسوس نیستیدبلکه صادق. آنگاه برادر شما را به شما رد کنم، ودر زمین داد و ستد نمایید.» ");
INSERT INTO pesOPV_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","و واقع شد که چون عدلهای خود را خالی می‌کردند، اینک کیسه پول هر کس در عدلش بود. و چون ایشان و پدرشان، کیسه های پول را دیدند، بترسیدند. ");
INSERT INTO pesOPV_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","و پدر ایشان، یعقوب، بدیشان گفت: «مرا بی‌اولاد ساختید، یوسف نیست و شمعون نیست و بنیامین را می‌خواهید ببرید. این همه برمن است؟» ");
INSERT INTO pesOPV_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","روبین به پدر خود عرض کرده، گفت: «هر دو پسر مرا بکش، اگر او را نزد تو بازنیاورم. او را به‌دست من بسپار، و من او را نزد توباز خواهم آورد.» ");
INSERT INTO pesOPV_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","گفت: «پسرم با شما نخواهد آمد زیرا که برادرش مرده است، و او تنها باقی است. و هر گاه در راهی که می‌روید زیانی بدو رسد، همانامویهای سفید مرا با حزن به گور فرود خواهیدبرد.» ");
INSERT INTO pesOPV_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","و قحط در زمین سخت بود. ");
INSERT INTO pesOPV_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","و واقع شد چون غله‌ای را که از مصر آورده بودند، تمام خوردند، پدرشان بدیشان گفت: «برگردید و اندک خوراکی برای ما بخرید.» ");
INSERT INTO pesOPV_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","یهودا بدو متکلم شده، گفت: «آن مرد به ما تاکیدکرده، گفته است هرگاه برادر شما با شما نباشد، روی مرا نخواهید دید. ");
INSERT INTO pesOPV_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","اگر تو برادر ما را با مافرستی، می‌رویم و خوراک برایت می‌خریم. ");
INSERT INTO pesOPV_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","امااگر تو او را نفرستی، نمی رویم، زیرا که آن مرد مارا گفت، هر گاه برادر شما، با شما نباشد، روی مرانخواهید دید.» ");
INSERT INTO pesOPV_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","اسرائیل گفت: «چرا به من بدی کرده، به آن مرد خبر دادید که برادر دیگر دارید؟» ");
INSERT INTO pesOPV_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","گفتند: «آن مرد احوال ما و خویشاوندان ما را به دقت پرسیده، گفت: “آیا پدر شما هنوز زنده است، وبرادر دیگر دارید؟” و او را بدین مضمون اطلاع دادیم، و چه می‌دانستیم که خواهد گفت: “برادرخود را نزد من آرید.”» ");
INSERT INTO pesOPV_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","پس یهودا به پدر خود، اسرائیل گفت: «جوان را با من بفرست تا برخاسته، برویم وزیست کنیم و نمیریم، ما و تو و اطفال ما نیز. ");
INSERT INTO pesOPV_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","من ضامن او می‌باشم، او را از دست من بازخواست کن هر گاه او را نزد تو باز نیاوردم و به حضورت حاضر نساختم، تا به ابد در نظر تو مقصر باشم. ");
INSERT INTO pesOPV_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","زیرا اگر تاخیر نمی نمودیم، هر آینه تا حال، مرتبه دوم را برگشته بودیم.» ");
INSERT INTO pesOPV_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","پس پدر ایشان، اسرائیل، بدیشان گفت: «اگر چنین است، پس این را بکنید. از ثمرات نیکوی این زمین در ظروف خود بردارید، وارمغانی برای آن مرد ببرید، قدری بلسان و قدری عسل و کتیرا و لادن و پسته و بادام. ");
INSERT INTO pesOPV_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","و نقدمضاعف بدست خود گیرید، و آن نقدی که دردهنه عدلهای شما رد شده بود، به‌دست خود بازبرید، شاید سهوی شده باشد. ");
INSERT INTO pesOPV_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","و برادر خود رابرداشته، روانه شوید، و نزد آن مرد برگردید. ");
INSERT INTO pesOPV_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","وخدای قادر مطلق شما را در نظر آن مرد مکرم دارد، تا برادر دیگر شما و بنیامین را همراه شمابفرستد، و من اگر بی‌اولاد شدم، بی‌اولاد شدم.» ");
INSERT INTO pesOPV_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","پس آن مردان، ارمغان را برداشته، و نقدمضاعف را بدست گرفته، با بنیامین روانه شدند. وبه مصر فرود آمده، به حضور یوسف ایستادند. ");
INSERT INTO pesOPV_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","اما یوسف، چون بنیامین را با ایشان دید، به ناظر خانه خود فرمود: «این اشخاص را به خانه ببر، و ذبح کرده، تدارک ببین، زیرا که ایشان وقت ظهر با من غذا می‌خورند.» ");
INSERT INTO pesOPV_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","و آن مرد چنانکه یوسف فرموده بود، کرد. و آن مرد ایشان را به خانه یوسف آورد. ");
INSERT INTO pesOPV_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","و آن مردان ترسیدند، چونکه به خانه یوسف آورده شدند و گفتند: «بسبب آن نقدی که دفعه اول درعدلهای ما رد شده بود، ما را آورده‌اند تا بر ماهجوم آورد، و بر ما حمله کند، و ما را مملوک سازد و حماران ما را.» ");
INSERT INTO pesOPV_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","و به ناظر خانه یوسف نزدیک شده، دردرگاه خانه بدو متکلم شده، ");
INSERT INTO pesOPV_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","گفتند: «یا سیدی! حقیقت مرتبه اول برای خرید خوراک آمدیم. ");
INSERT INTO pesOPV_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","وواقع شد چون به منزل رسیده، عدلهای خود راباز کردیم، که اینک نقد هر کس در دهنه عدلش بود. نقره ما به وزن تمام و آن را به‌دست خود بازآورده‌ایم. ");
INSERT INTO pesOPV_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","و نقد دیگر برای خرید خوراک به‌دست خود آورده‌ایم. نمی دانیم کدام کس نقد مارا در عدلهای ما گذاشته بود.» ");
INSERT INTO pesOPV_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","گفت: «سلامت باشید مترسید، خدای شماو خدای پدر شما، خزانه‌ای در عدلهای شما، به شما داده است؛ نقد شما به من رسید.» پس شمعون را نزد ایشان بیرون آورد. ");
INSERT INTO pesOPV_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","و آن مرد، ایشان را به خانه یوسف درآورده، آب بدیشان داد، تا پایهای خود را شستند، و علوفه به حماران ایشان داد. ");
INSERT INTO pesOPV_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","و ارمغان را حاضر ساختند، تا وقت آمدن یوسف به ظهر، زیرا شنیده بودند که درآنجا باید غذا بخورند. ");
INSERT INTO pesOPV_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","و چون یوسف به خانه آمد، ارمغانی را که به‌دست ایشان بود، نزد وی به خانه آوردند، و به حضور وی رو به زمین نهادند. ");
INSERT INTO pesOPV_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","پس از سلامتی ایشان پرسید و گفت: «آیاپدر‌پیر شما که ذکرش را کردید، به سلامت است؟ و تا بحال حیات دارد؟» ");
INSERT INTO pesOPV_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","گفتند: «غلامت، پدر ما، به سلامت است، و تا بحال زنده.» پس تعظیم و سجده کردند. ");
INSERT INTO pesOPV_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","و چون چشمان خود را باز کرده، برادر خود بنیامین، پسرمادر خویش را دید، گفت: «آیا این است برادرکوچک شما که نزد من، ذکر او را کردید؟» و گفت: «ای پسرم، خدا بر تو رحم کناد.» ");
INSERT INTO pesOPV_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","و یوسف چونکه مهرش بر برادرش بجنبید، بشتافت، و جای گریستن خواست. پس به خلوت رفته، آنجا بگریست. ");
INSERT INTO pesOPV_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","و روی خود راشسته، بیرون آمد. و خودداری نموده، گفت: «طعام بگذارید.» ");
INSERT INTO pesOPV_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","و برای وی جدا گذاردند، و برای ایشان جدا، و برای مصریانی که با وی خوردند جدا، زیرا که مصریان با عبرانیان نمی توانند غذابخورند زیرا که این، نزد مصریان مکروه است. ");
INSERT INTO pesOPV_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","و به حضور وی بنشستند، نخست زاده موافق نخست زادگی‌اش، و خرد سال بحسب خردسالی‌اش، و ایشان به یکدیگر تعجب نمودند. ");
INSERT INTO pesOPV_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","و حصه‌ها از پیش خود برای ایشان گرفت، اماحصه بنیامین پنج چندان حصه دیگران بود، و باوی نوشیدند و کیف کردند. ");
INSERT INTO pesOPV_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","پس به ناظر خانه خود امر کرده، گفت: عدلهای این مردمان را به قدری که می‌توانند برد، از غله پر کن، و نقد هر کسی را به دهنه عدلش بگذار. ");
INSERT INTO pesOPV_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","و جام مرا، یعنی جام نقره را، در دهنه عدل آن کوچکتر، با قیمت غله‌اش بگذار.» پس موافق آن سخنی که یوسف گفته بود، کرد. ");
INSERT INTO pesOPV_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","و چون صبح روشن شد، آن مردان را باحماران ایشان، روانه کردند. ");
INSERT INTO pesOPV_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","و ایشان از شهربیرون شده، هنوز مسافتی چند طی نکرده بودند، که یوسف به ناظر خانه خود گفت: «بر پا شده، درعقب این اشخاص بشتاب، و چون بدیشان فرارسیدی، ایشان را بگو: چرا بدی به عوض نیکویی کردید؟ ");
INSERT INTO pesOPV_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","آیا این نیست آنکه آقایم در آن می‌نوشد، و از آن تفال می‌زند؟ در آنچه کردید، بد کردید.» ");
INSERT INTO pesOPV_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","پس چون بدیشان در‌رسید، این سخنان رابدیشان گفت. ");
INSERT INTO pesOPV_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","به وی گفتند: «چرا آقایم چنین می‌گوید؟ حاشا از غلامانت که مرتکب چنین کارشوند! ");
INSERT INTO pesOPV_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","همانا نقدی را که در دهنه عدلهای خودیافته بودیم، از زمین کنعان نزد تو باز آوردیم، پس چگونه باشد که از خانه آقایت طلا یا نقره بدزدیم. ");
INSERT INTO pesOPV_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","نزد هر کدام از غلامانت یافت شود، بمیرد، و مانیز غلام آقای خود باشیم.» ");
INSERT INTO pesOPV_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","گفت: «هم الان موافق سخن شما بشود، آنکه نزد او یافت شود، غلام من باشد، و شما آزادباشید.» ");
INSERT INTO pesOPV_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","پس تعجیل نموده، هر کس عدل خودرا به زمین فرود آورد، و هر یکی عدل خود را بازکرد. ");
INSERT INTO pesOPV_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","و او تجسس کرد، و از مهتر شروع نموده، به کهتر ختم کرد. و جام در عدل بنیامین یافته شد. ");
INSERT INTO pesOPV_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","آنگاه رخت خود را چاک زدند، و هر کس الاغ خود را بار کرده، به شهر برگشتند. ");
INSERT INTO pesOPV_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","و یهودا با برادرانش به خانه یوسف آمدند، و او هنوز آنجا بود، و به حضور وی بر زمین افتادند. ");
INSERT INTO pesOPV_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","یوسف بدیشان گفت: «این چه‌کاری است که کردید؟ آیا ندانستید که چون من مردی، البته تفال می‌زنم؟» ");
INSERT INTO pesOPV_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","یهودا گفت: «به آقایم چه گوییم، و چه عرض کنیم، و چگونه بی‌گناهی خویش را ثابت نماییم؟ خدا گناه غلامانت رادریافت نموده است؛ اینک ما نیز و آنکه جام بدستش یافت شد، غلامان آقای خود خواهیم بود.» ");
INSERT INTO pesOPV_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","گفت: «حاشا از من که چنین کنم! بلکه آنکه جام بدستش یافت شد، غلام من باشد، وشما به سلامتی نزد پدر خویش بروید.» ");
INSERT INTO pesOPV_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","آنگاه یهودا نزدیک وی آمده، گفت: «ای آقایم بشنوغلامت به گوش آقای خود سخنی بگوید. وغضبت بر غلام خود افروخته نشود، زیرا که توچون فرعون هستی. ");
INSERT INTO pesOPV_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","آقایم از غلامانت پرسیده، گفت: “آیا شما را پدر یا برادری است؟” ");
INSERT INTO pesOPV_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","و به آقای خود عرض کردیم: “که ما را پدرپیری است، و پسر کوچک پیری او که برادرش مرده است، و او تنها از مادر خود مانده است، وپدر او را دوست می‌دارد.” ");
INSERT INTO pesOPV_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","و به غلامان خودگفتی: “وی را نزد من آرید تا چشمان خود را بروی نهم.” ");
INSERT INTO pesOPV_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","و به آقای خود گفتیم: “آن جوان نمی تواند از پدر خود جدا شود، چه اگر از پدرخویش جدا شود او خواهد مرد.” ");
INSERT INTO pesOPV_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","و به غلامان خود گفتی: “اگر برادر کهتر شما با شما نیاید، روی مرا دیگر نخواهید دید.” ");
INSERT INTO pesOPV_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","پس واقع شد که چون نزد غلامت، پدر خود، رسیدیم، سخنان آقای خود را بدو باز‌گفتیم. ");
INSERT INTO pesOPV_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","و پدر ما گفت: “برگشته اندک خوراکی برای ما بخرید.” ");
INSERT INTO pesOPV_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","گفتیم: “نمی توانیم رفت، لیکن اگر برادر کهتر باما آید، خواهیم رفت، زیرا که روی آن مرد رانمی توانیم دید اگر برادر کوچک با ما نباشد.” ");
INSERT INTO pesOPV_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","وغلامت، پدر من، به ما گفت: “شما آگاهید که زوجه‌ام برای من دو پسر زایید. ");
INSERT INTO pesOPV_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","و یکی از نزدمن بیرون رفت، و من گفتم هر آینه دریده شده است، و بعد از آن او را ندیدم. ");
INSERT INTO pesOPV_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","اگر این را نیز ازنزد من ببرید، و زیانی بدو رسد، همانا موی سفیدمرا به حزن به گور فرود خواهید برد.” ");
INSERT INTO pesOPV_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","و الان اگر نزد غلامت، پدر خود بروم، و این جوان با مانباشد، و حال آنکه جان او به‌جان وی بسته است، ");
INSERT INTO pesOPV_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","واقع خواهد شد که چون ببیند پسر نیست، او خواهد مرد. و غلامانت موی سفید غلامت، پدرخود را به حزن به گور فرود خواهند برد. ");
INSERT INTO pesOPV_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","زیراکه غلامت نزد پدر خود ضامن پسر شده، گفتم: “هرگاه او را نزد تو باز نیاورم، تا ابدالاباد نزد پدرخود مقصر خواهم شد.” ");
INSERT INTO pesOPV_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","پس الان تمنا اینکه غلامت به عوض پسر در بندگی آقای خود بماند، و پسر، همراه برادران خود برود. ");
INSERT INTO pesOPV_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","زیرا چگونه نزد پدر خود بروم و پسر با من نباشد، مبادا بلایی را که به پدرم واقع شود ببینم.» ");
INSERT INTO pesOPV_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","معرفی می‌کند و یوسف پیش جمعی که به حضورش ایستاده بودند، نتوانست خودداری کند، پس ندا کرد که «همه را از نزد من بیرون کنید!» و کسی نزد او نماند، وقتی که یوسف خویشتن را به برادران خود شناسانید. ");
INSERT INTO pesOPV_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","و به آوازبلند گریست، و مصریان و اهل خانه فرعون شنیدند. ");
INSERT INTO pesOPV_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","و یوسف، برادران خود را گفت: «من یوسف هستم! آیا پدرم هنوز زنده است؟» وبرادرانش جواب وی را نتوانستند داد، زیرا که به حضور وی مضطرب شدند. ");
INSERT INTO pesOPV_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","و یوسف به برادران خود گفت: «نزدیک من بیایید.» پس نزدیک آمدند، و گفت: «منم یوسف، برادر شما، که به مصر فروختید! ");
INSERT INTO pesOPV_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","و حال رنجیده مشوید، و متغیر نگردید که مرا بدینجا فروختید، زیرا خدا مرا پیش روی شما فرستاد تا (نفوس را)زنده نگاه دارد. ");
INSERT INTO pesOPV_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","زیرا حال دو سال شده است که قحط در زمین هست، و پنج سال دیگر نیز نه شیارخواهد بود نه درو. ");
INSERT INTO pesOPV_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","و خدا مرا پیش روی شما فرستاد تا برای شما بقیتی در زمین نگاه دارد، وشما را به نجاتی عظیم احیا کند. ");
INSERT INTO pesOPV_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","و الان شما مرااینجا نفرستادید، بلکه خدا، و او مرا پدر بر فرعون و آقا بر تمامی اهل خانه او و حاکم بر همه زمین مصر ساخت. ");
INSERT INTO pesOPV_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","بشتابید و نزد پدرم رفته، بدوگویید: پسر تو، یوسف چنین می‌گوید: که خدا مراحاکم تمامی مصر ساخته است، نزد من بیا وتاخیر منما. ");
INSERT INTO pesOPV_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","و در زمین جوشن ساکن شو، تانزدیک من باشی، تو و پسرانت و پسران پسرانت، و گله ات و رمه ات با هر‌چه داری. ");
INSERT INTO pesOPV_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","تا تو را درآنجا بپرورانم، زیرا که پنج سال قحط باقی است، مبادا تو و اهل خانه ات و متعلقانت بینوا گردید. ");
INSERT INTO pesOPV_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","و اینک چشمان شما و چشمان برادرم بنیامین، می‌بیند، زبان من است که با شما سخن می‌گوید. ");
INSERT INTO pesOPV_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","پس پدر مرا از همه حشمت من در مصر و ازآنچه دیده‌اید، خبر دهید، و تعجیل نموده، پدرمرا بدینجا آورید.» ");
INSERT INTO pesOPV_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","پس به گردن برادر خود، بنیامین، آویخته، بگریست و بنیامین بر گردن وی گریست. ");
INSERT INTO pesOPV_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","وهمه برادران خود را بوسیده، برایشان بگریست، وبعد از آن، برادرانش با وی گفتگو کردند. ");
INSERT INTO pesOPV_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","و این خبر را در خانه فرعون شنیدند، و گفتند برادران یوسف آمده‌اند، و بنظر فرعون و بنظر بندگانش خوش آمد. ");
INSERT INTO pesOPV_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","و فرعون به یوسف گفت: «برادران خود را بگو: چنین بکنید: چهارپایان خود را بارکنید، و روانه شده، به زمین کنعان بروید. ");
INSERT INTO pesOPV_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","و پدرو اهل خانه های خود را برداشته، نزد من آیید، ونیکوتر زمین مصر را به شما می‌دهم تا از فربهی زمین بخورید. ");
INSERT INTO pesOPV_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","و تو مامور هستی این را بکنید: ارابه‌ها از زمین مصر برای اطفال و زنان خود بگیرید، و پدر خود برداشته، بیایید. ");
INSERT INTO pesOPV_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","و چشمان شما در‌پی اسباب خود نباشد، زیرا که نیکویی تمامی زمین مصر از آن شماست.» ");
INSERT INTO pesOPV_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","پس بنی‌اسرائیل چنان کردند، و یوسف به حسب فرمایش فرعون، ارابه‌ها بدیشان داد، و زاد سفربدیشان عطا فرمود. ");
INSERT INTO pesOPV_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","و بهر هر یک از ایشان، یک دست رخت بخشید، اما به بنیامین سیصد مثقال نقره، و پنج دست جامه داد. ");
INSERT INTO pesOPV_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","و برای پدر خودبدین تفصیل فرستاد: ده الاغ بار شده به نفایس مصر، و ده ماده الاغ بار شده به غله و نان و خورش برای سفر پدر خود. ");
INSERT INTO pesOPV_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","پس برادران خود رامرخص فرموده، روانه شدند و بدیشان گفت: «زنهار در راه منازعه مکنید!» ");
INSERT INTO pesOPV_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","و از مصر برآمده، نزد پدر خود، یعقوب، به زمین کنعان آمدند. ");
INSERT INTO pesOPV_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","و او را خبر داده، گفتند: «یوسف الان زنده است، و او حاکم تمامی زمین مصر است.» آنگاه دل وی ضعف کرد، زیرا که ایشان را باور نکرد. ");
INSERT INTO pesOPV_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","و همه سخنانی که یوسف بدیشان گفته بود، به وی گفتند، و چون ارابه هایی را که یوسف برای آوردن او فرستاده بود، دید، روح پدر ایشان، یعقوب، زنده گردید. ");
INSERT INTO pesOPV_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","واسرائیل گفت: «کافی است! پسر من، یوسف، هنوز زنده است؛ می‌روم و قبل از مردنم او راخواهم دید.» ");
INSERT INTO pesOPV_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","و اسرائیل با هر‌چه داشت، کوچ کرده، به بئرشبع آمد، و قربانی‌ها برای خدای پدر خود، اسحاق، گذرانید. ");
INSERT INTO pesOPV_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","و خدا دررویاهای شب، به اسرائیل خطاب کرده، گفت: «ای یعقوب! ای یعقوب!» گفت: «لبیک.» ");
INSERT INTO pesOPV_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","گفت: «من هستم الله، خدای پدرت، از فرود آمدن به مصر مترس، زیرا در آنجا امتی عظیم از تو به وجود خواهم آورد. ");
INSERT INTO pesOPV_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","من با تو به مصر خواهم آمد، و من نیز، تو را از آنجا البته باز خواهم آورد، و یوسف دست خود را بر چشمان تو خواهدگذاشت.» ");
INSERT INTO pesOPV_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","و یعقوب از بئرشبع روانه شد، وبنی‌اسرائیل پدر خود، یعقوب، و اطفال و زنان خویش را بر ارابه هایی که فرعون به جهت آوردن او فرستاده بود، برداشتند. ");
INSERT INTO pesOPV_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","و مواشی و اموالی راکه در زمین کنعان اندوخته بودند، گرفتند. ویعقوب با تمامی ذریت خود به مصر آمدند. ");
INSERT INTO pesOPV_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","وپسران و پسران پسران خود را با خود، و دختران ودختران پسران خود را، و تمامی ذریت خویش رابه همراهی خود به مصر آورد. ");
INSERT INTO pesOPV_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","و این است نامهای پسران اسرائیل که به مصرآمدند: یعقوب و پسرانش روبین نخست زاده یعقوب. ");
INSERT INTO pesOPV_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","و پسران روبین: حنوک و فلو و حصرون و کرمی. ");
INSERT INTO pesOPV_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","و پسران شمعون: یموئیل و یامین واوهد و یاکین و صوحر و شاول که پسرزن کنعانی بود. ");
INSERT INTO pesOPV_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","و پسران لاوی: جرشون و قهات و مراری. ");
INSERT INTO pesOPV_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","و پسران یهودا: عیر و اونان و شیله و فارص وزارح. اما عیر و اونان در زمین کنعان مردند. وپسران فارص: حصرون و حامول بودند. ");
INSERT INTO pesOPV_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","وپسران یساکار: تولاع و فوه و یوب و شمرون. ");
INSERT INTO pesOPV_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","وپسران زبولون: سارد و ایلون و یاحلئیل. ");
INSERT INTO pesOPV_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","اینانند پسران لیه، که آنها را با دختر خود دینه، در فدان ارام برای یعقوب زایید. همه نفوس پسران و دخترانش سی و سه نفر بودند. ");
INSERT INTO pesOPV_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","وپسران جاد: صفیون و حجی و شونی و اصبون و عیری و ارودی و ارئیلی. ");
INSERT INTO pesOPV_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","و پسران اشیر: یمنه و یشوه و یشوی و بریعه، و خواهر ایشان ساره، وپسران بریعه حابر و ملکیئیل. ");
INSERT INTO pesOPV_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","اینانند پسران زلفه که لابان به دختر خود لیه داد، و این شانزده رابرای یعقوب زایید. ");
INSERT INTO pesOPV_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","و پسران راحیل زن یعقوب: یوسف و بنیامین. ");
INSERT INTO pesOPV_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","و برای یوسف درزمین مصر، منسی و افرایم زاییده شدند، که اسنات دختر فوطی فارع، کاهن اون برایش بزاد. ");
INSERT INTO pesOPV_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","و پسران بنیامین: بالع و باکر و اشبیل و جیرا ونعمان و ایحی و رش و مفیم و حفیم و آرد. ");
INSERT INTO pesOPV_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","اینانند پسران راحیل که برای یعقوب زاییده شدند، همه چهارده نفر. ");
INSERT INTO pesOPV_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","و پسران دان: حوشیم. ");
INSERT INTO pesOPV_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","و پسران نفتالی: یحصئیل و جونی و یصر وشلیم. ");
INSERT INTO pesOPV_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","اینانند پسران بلهه، که لابان به دخترخود راحیل داد، و ایشان را برای یعقوب زایید. همه هفت نفر بودند. ");
INSERT INTO pesOPV_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","همه نفوسی که با یعقوب به مصر آمدند، که از صلب وی پدید شدند، سوای زنان پسران یعقوب، جمیع شصت و شش نفر بودند. ");
INSERT INTO pesOPV_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","وپسران یوسف که برایش در مصر زاییده شدند، دونفر بودند. پس جمیع نفوس خاندان یعقوب که به مصر آمدند هفتاد بودند. ");
INSERT INTO pesOPV_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","و یهودا را پیش روی خود نزد یوسف فرستاد تا او را به جوشن راهنمایی کند، و به زمین جوشن آمدند. ");
INSERT INTO pesOPV_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","و یوسف عرابه خود را حاضرساخت، تا به استقبال پدر خود اسرائیل به جوشن برود. و چون او را بدید به گردنش بیاویخت، ومدتی بر گردنش گریست. ");
INSERT INTO pesOPV_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","و اسرائیل به یوسف گفت: «اکنون بمیرم، چونکه روی تو را دیدم که تابحال زنده هستی.» ");
INSERT INTO pesOPV_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","و یوسف برادران خود و اهل خانه پدر خویش را گفت: «می‌روم تا فرعون را خبر دهم و به وی گویم: “برادرانم و خانواده پدرم که در زمین کنعان بودند، نزد من آمده‌اند. ");
INSERT INTO pesOPV_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","و مردان شبانان هستند، زیرا اهل مواشیند، وگله‌ها و رمه‌ها و کل مایملک خود را آورده‌اند.” ");
INSERT INTO pesOPV_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","و چون فرعون شما را بطلبد و گوید: “کسب شما چیست؟” ");
INSERT INTO pesOPV_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","گویید: “غلامانت از طفولیت تابحال اهل مواشی هستیم، هم ما و هم اجداد ما، تادر زمین جوشن ساکن شوید، زیرا که هر شبان گوسفند مکروه مصریان است.» ");
INSERT INTO pesOPV_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","پس یوسف آمد و به فرعون خبرداده، گفت: «پدرم و برادرانم با گله ورمه خویش و هر‌چه دارند، از زمین کنعان آمده‌اند و در زمین جوشن هستند.» ");
INSERT INTO pesOPV_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","و از‌جمله برادران خود پنج نفر برداشته، ایشان را به حضورفرعون بر پا داشت. ");
INSERT INTO pesOPV_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","و فرعون، برادران او را گفت: «شغل شما چیست؟» به فرعون گفتند: «غلامانت شبان گوسفند هستیم، هم ما و هم اجداد ما.» ");
INSERT INTO pesOPV_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","وبه فرعون گفتند: «آمده‌ایم تا در این زمین ساکن شویم، زیرا که برای گله غلامانت مرتعی نیست، چونکه قحط در زمین کنعان سخت است. و الان تمنا داریم که بندگانت در زمین جوشن سکونت کنند.» ");
INSERT INTO pesOPV_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","و فرعون به یوسف خطاب کرده، گفت: «پدرت و برادرانت نزد تو آمده‌اند، ");
INSERT INTO pesOPV_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","زمین مصرپیش روی توست. در نیکوترین زمین، پدر وبرادران خود را مسکن بده. در زمین جوشن ساکن بشوند. و اگر می‌دانی که در میان ایشان کسان قابل می‌باشند، ایشان را سرکاران مواشی من گردان.» ");
INSERT INTO pesOPV_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","و یوسف، پدر خود، یعقوب را آورده، او رابه حضور فرعون برپا داشت. و یعقوب، فرعون را برکت داد. ");
INSERT INTO pesOPV_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","و فرعون به یعقوب گفت: «ایام سالهای عمر تو چند است؟» ");
INSERT INTO pesOPV_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","یعقوب به فرعون گفت: «ایام سالهای غربت من صد و سی سال است. ایام سالهای عمر من‌اندک و بد بوده است، و به ایام سالهای عمر پدرانم در روزهای غربت ایشان نرسیده.» ");
INSERT INTO pesOPV_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","و یعقوب، فرعون را برکت دادو از حضور فرعون بیرون آمد. ");
INSERT INTO pesOPV_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","و یوسف، پدرو برادران خود را سکونت داد، و ملکی در زمین مصر در نیکوترین زمین، یعنی در ارض رعمسیس، چنانکه فرعون فرموده بود، بدیشان ارزانی داشت. ");
INSERT INTO pesOPV_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","و یوسف پدر و برادران خود، وهمه اهل خانه پدر خویش را به حسب تعدادعیال ایشان به نان پرورانید. ");
INSERT INTO pesOPV_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","و در تمامی زمین نان نبود، زیرا قحط زیاده سخت بود، و ارض مصر و ارض کنعان بسبب قحط بینوا گردید. ");
INSERT INTO pesOPV_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","و یوسف، تمام نقره‌ای را که در زمین مصر و زمین کنعان یافته شد، به عوض غله‌ای که ایشان خریدند، بگرفت، و یوسف نقره را به خانه فرعون درآورد. ");
INSERT INTO pesOPV_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","و چون نقره از ارض مصر و ارض کنعان تمام شد، همه مصریان نزدیوسف آمده، گفتند: «ما را نان بده، چرا درحضورت بمیریم؟ زیرا که نقره تمام شد.» ");
INSERT INTO pesOPV_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","یوسف گفت: «مواشی خود را بیاورید، و به عوض مواشی شما، غله به شما می‌دهم، اگر نقره تمام شده است.» ");
INSERT INTO pesOPV_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","پس مواشی خود را نزدیوسف آوردند، و یوسف به عوض اسبان وگله های گوسفندان و رمه های گاوان و الاغان، نان بدیشان داد. و در آن سال به عوض همه مواشی ایشان، ایشان را به نان پرورانید. ");
INSERT INTO pesOPV_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","و چون آن سال سپری شد در سال دوم به حضور وی آمده، گفتندش: «از آقای خود مخفی نمی داریم که نقره ما تمام شده است، و مواشی و بهایم از آن آقای ماگردیده، و جز بدنها و زمین ما به حضور آقای ماچیزی باقی نیست. ");
INSERT INTO pesOPV_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","چرا ما و زمین ما نیز در نظرتو هلاک شویم؟ پس ما را و زمین ما را به نان بخر، و ما و زمین ما مملوک فرعون بشویم، و بذر بده تازیست کنیم و نمیریم و زمین بایر نماند.» ");
INSERT INTO pesOPV_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","پس یوسف تمامی زمین مصر را برای فرعون بخرید، زیرا که مصریان هر کس مزرعه خود را فروختند، چونکه قحط برایشان سخت بود و زمین از آن فرعون شد. ");
INSERT INTO pesOPV_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","و خلق را از این حد تا به آن حد مصر به شهرها منتقل ساخت. ");
INSERT INTO pesOPV_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","فقط زمین کهنه را نخرید، زیرا کهنه را حصه‌ای از جانب فرعون معین شده بود، و از حصه‌ای که فرعون بدیشان داده بود، می‌خوردند. از این سبب زمین خود را نفروختند. ");
INSERT INTO pesOPV_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","و یوسف به قوم گفت: «اینک، امروز شما را و زمین شما را برای فرعون خریدم، همانا برای شما بذر است تا زمین رابکارید. ");
INSERT INTO pesOPV_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","و چون حاصل برسد، یک خمس به فرعون دهید، و چهار حصه از آن شما باشد، برای زراعت زمین و برای خوراک شما و اهل خانه های شما و طعام به جهت اطفال شما.» ");
INSERT INTO pesOPV_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","گفتند: «تو ما را احیا ساختی، در نظر آقای خود التفات بیابیم، تا غلام فرعون باشیم.» ");
INSERT INTO pesOPV_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","پس یوسف این قانون را بر زمین مصر تا امروز قرار دادکه خمس از آن فرعون باشد، غیر از زمین کهنه فقط، که از آن فرعون نشد. ");
INSERT INTO pesOPV_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","و اسرائیل در ارض مصر در زمین جوشن ساکن شده، ملک در آن گرفتند، و بسیار بارور و کثیر گردیدند. ");
INSERT INTO pesOPV_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","ویعقوب در ارض مصر هفده سال بزیست. و ایام سالهای عمر یعقوب صد و چهل و هفت سال بود. ");
INSERT INTO pesOPV_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","و چون حین وفات اسرائیل نزدیک شد، پسر خود یوسف را طلبیده، بدو گفت: «الان اگردر نظر تو التفات یافته‌ام، دست خود را زیر ران من بگذار، و احسان و امانت با من بکن، و زنهار مرادر مصر دفن منما، ");
INSERT INTO pesOPV_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","بلکه با پدران خود بخوابم ومرا از مصر برداشته، در قبر ایشان دفن کن.» گفت: «آنچه گفتی خواهم کرد.» ");
INSERT INTO pesOPV_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","گفت: «برایم قسم بخور، » پس برایش قسم خورد و اسرائیل بر سربستر خود خم شد. ");
INSERT INTO pesOPV_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","و بعد از این امور، واقع شد که به یوسف گفتند: «اینک پدر تو بیماراست.» پس دو پسر خود، منسی و افرایم را باخود برداشت. ");
INSERT INTO pesOPV_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","و یعقوب را خبر داده، گفتند: «اینک پسرت یوسف، نزد تو می‌آید.» و اسرائیل، خویشتن را تقویت داده، بر بستر بنشست. ");
INSERT INTO pesOPV_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","ویعقوب به یوسف گفت: «خدای قادر مطلق درلوز در زمین کنعان به من ظاهر شده، مرا برکت داد. ");
INSERT INTO pesOPV_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","و به من گفت: هر آینه من تو را بارور و کثیرگردانم، و از تو قومهای بسیار بوجود آورم، و این زمین را بعد از تو به ذریت تو، به میراث ابدی خواهم داد. ");
INSERT INTO pesOPV_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","و الان دو پسرت که در زمین مصربرایت زاییده شدند، قبل از آنکه نزد تو به مصربیایم، ایشان از آن من هستند، افرایم و منسی مثل روبین و شمعون از آن من خواهند بود. ");
INSERT INTO pesOPV_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","و امااولاد تو که بعد از ایشان بیاوری، از آن تو باشند ودر ارث خود به نامهای برادران خود مسمی شوند. ");
INSERT INTO pesOPV_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","و هنگامی که من از فدان آمدم، راحیل نزد من در زمین کنعان به‌سر راه مرد، چون اندک مسافتی باقی بود که به افرات برسم، و او را در آنجا به‌سر راه افرات که بیت لحم باشد، دفن کردم.» ");
INSERT INTO pesOPV_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","و چون اسرائیل، پسران یوسف را دید، گفت: «اینان کیستند؟» ");
INSERT INTO pesOPV_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","یوسف، پدر خود راگفت: «اینان پسران منند که خدا به من در اینجاداده است.» گفت: «ایشان را نزد من بیاور تا ایشان را برکت دهم.» ");
INSERT INTO pesOPV_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","و چشمان اسرائیل از پیری تارشده بود که نتوانست دید. پس ایشان را نزدیک وی آورد و ایشان را بوسیده، در آغوش خودکشید. ");
INSERT INTO pesOPV_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","و اسرائیل به یوسف گفت: «گمان نمی بردم که روی تو را ببینم، و همانا خدا، ذریت تو را نیزبه من نشان داده است.» ");
INSERT INTO pesOPV_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","و یوسف ایشان را ازمیان دو زانوی خود بیرون آورده، رو به زمین نهاد. ");
INSERT INTO pesOPV_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","و یوسف هر دو را گرفت، افرایم را به‌دست راست خود به مقابل دست چپ اسرائیل، ومنسی را به‌دست چپ خود به مقابل دست راست اسرائیل، و ایشان را نزدیک وی آورد. ");
INSERT INTO pesOPV_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","واسرائیل دست راست خود را دراز کرده، بر سرافرایم نهاد و او کوچکتر بود و دست چپ خود رابر سر منسی، و دستهای خود را به فراست حرکت داد، زیرا که منسی نخست زاده بود. ");
INSERT INTO pesOPV_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","ویوسف را برکت داده، گفت: «خدایی که درحضور وی پدرانم، ابراهیم و اسحاق، سالک بودندی، خدایی که مرا از روز بودنم تا امروزرعایت کرده است، ");
INSERT INTO pesOPV_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","آن فرشته‌ای که مرا از هربدی خلاصی داده، این دو پسر را برکت دهد، ونام من و نامهای پدرانم، ابراهیم و اسحاق، برایشان خوانده شود، و در وسط زمین بسیار کثیرشوند.» ");
INSERT INTO pesOPV_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","و چون یوسف دید که پدرش دست راست خود را بر سر افرایم نهاد، بنظرش ناپسند آمد، ودست پدر خود را گرفت، تا آن را از سر افرایم به‌سر منسی نقل کند. ");
INSERT INTO pesOPV_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","و یوسف به پدر خود گفت: «ای پدر من، نه چنین، زیرا نخست زاده این است، دست راست خود را به‌سر او بگذار.» ");
INSERT INTO pesOPV_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","اماپدرش ابا نموده، گفت: «می‌دانم‌ای پسرم! می‌دانم! او نیز قومی خواهد شد و او نیز بزرگ خواهد گردید، لیکن برادر کهترش از وی بزرگترخواهد شد و ذریت او امتهای بسیار خواهندگردید.» ");
INSERT INTO pesOPV_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","و در آن روز، او ایشان را برکت داده، گفت: «به تو، اسرائیل، برکت طلبیده، خواهند گفت که خدا تو را مثل افرایم و منسی کرداناد.» پس افرایم را به منسی ترجیح داد. ");
INSERT INTO pesOPV_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","و اسرائیل به یوسف گفت: «همانا من می‌میرم، و خدا با شما خواهدبود، و شما را به زمین پدران شما باز خواهد آورد. ");
INSERT INTO pesOPV_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","و من به تو حصه‌ای زیاده از برادرانت می‌دهم، که آن را از دست اموریان به شمشیر و کمان خودگرفتم.» ");
INSERT INTO pesOPV_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","و یعقوب، پسران خود را خوانده، گفت: «جمع شوید تا شما را از آنچه درایام آخر به شما واقع خواهد شد، خبر دهم. ");
INSERT INTO pesOPV_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","‌ای پسران یعقوب جمع شوید و بشنوید! و به پدرخود، اسرائیل، گوش گیرید. ");
INSERT INTO pesOPV_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","«ای روبین! تو نخست زاده منی، توانایی من وابتدای قوتم، فضیلت رفعت و فضیلت قدرت. ");
INSERT INTO pesOPV_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","جوشان مثل آب، برتری نخواهی یافت، زیرا که بر بستر پدر خود برآمدی. آنگاه آن را بی‌حرمت ساختی، به بستر من برآمد. ");
INSERT INTO pesOPV_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","«شمعون و لاوی برادرند. آلات ظلم، شمشیرهای ایشان است. ");
INSERT INTO pesOPV_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","‌ای نفس من به مشورت ایشان داخل مشو، و‌ای جلال من به محفل ایشان متحد مباش زیرا در غضب خودمردم را کشتند. و در خودرایی خویش گاوان راپی کردند. ");
INSERT INTO pesOPV_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","ملعون باد خشم ایشان، که سخت بود، و غضب ایشان زیرا که تند بود! ایشان را دریعقوب متفرق سازم و در اسرائیل پراکنده کنم. ");
INSERT INTO pesOPV_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","«ای یهودا تو را برادرانت خواهند ستود. دستت بر گردن دشمنانت خواهد بود، و پسران پدرت، تو را تعظیم خواهند کرد. ");
INSERT INTO pesOPV_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","یهوداشیربچه‌ای است، ای پسرم از شکار برآمدی. مثل شیر خویشتن را جمع کرده، در کمین می‌خوابد وچون شیرماده‌ای است. کیست او را برانگیزاند؟ ");
INSERT INTO pesOPV_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","عصا از یهودا دور نخواهد شد. و نه فرمان فرمایی از میان پایهای وی تا شیلو بیاید. ومر او را اطاعت امتها خواهد بود. ");
INSERT INTO pesOPV_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","کره خود رابه تاک و کره الاغ خویش را به مو بسته. جامه خودرا به شراب، و رخت خویش را به عصیر انگورمی شوید. ");
INSERT INTO pesOPV_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","چشمانش به شراب سرخ و دندانش به شیر سفید است. ");
INSERT INTO pesOPV_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","«زبولون، بر کنار دریا ساکن شود، و نزدبندر کشتیها. و حدود او تا به صیدون خواهدرسید. ");
INSERT INTO pesOPV_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","یساکار حمار قوی است در میان آغلهاخوابیده. ");
INSERT INTO pesOPV_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","چون محل آرمیدن را دید که پسندیده است، و زمین را دلگشا یافت، پس گردن خویش را برای بار خم کرد، و بنده خراج گردید. ");
INSERT INTO pesOPV_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","«دان، قوم خود را داوری خواهد کرد، چون یکی از اسباط اسرائیل. ");
INSERT INTO pesOPV_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","دان، ماری خواهد بود به‌سر راه، و افعی بر کنار طریق که پاشنه اسب رابگزد تا سوارش از عقب افتد. ");
INSERT INTO pesOPV_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","‌ای یهوه منتظرنجات تو می‌باشم. ");
INSERT INTO pesOPV_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","«جاد، گروهی بر وی هجوم خواهند‌آورد، و او به عقب ایشان هجوم خواهد آورد. ");
INSERT INTO pesOPV_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","اشیر، نان او چرب خواهد بود، و لذات ملوکانه خواهدداد. ");
INSERT INTO pesOPV_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","نفتالی، غزال آزادی است، که سخنان حسنه خواهد داد. ");
INSERT INTO pesOPV_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","«یوسف، شاخه باروری است. شاخه باروربر سر چشمه‌ای که شاخه هایش از دیوار برآید. ");
INSERT INTO pesOPV_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","تیراندازان او را رنجانیدند، و تیر انداختند واذیت رسانیدند. ");
INSERT INTO pesOPV_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","لیکن کمان وی در قوت قایم ماند. و بازوهای دستش به‌دست قدیر یعقوب مقوی گردید که از آنجاست شبان و صخره اسرائیل. ");
INSERT INTO pesOPV_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","از خدای پدرت که تو را اعانت می‌کند، و از قادرمطلق که تو را برکت می‌دهد، به برکات آسمانی از اعلی و برکات لجه‌ای که دراسفل واقع است، و برکات پستانها و رحم. ");
INSERT INTO pesOPV_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","برکات پدرت بر برکات جبال ازلی فایق آمد، وبر حدود کوههای ابدی و بر سر یوسف خواهدبود، و بر فرق او که از برادرانش برگزیده شد. ");
INSERT INTO pesOPV_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","«بنیامین، گرگی است که می‌درد. صبحگاهان شکار را خواهد خورد، و شامگاهان غارت را تقسیم خواهد کرد.» ");
INSERT INTO pesOPV_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","همه اینان دوازده سبط اسرائیلند، و این است آنچه پدرایشان، بدیشان گفت و ایشان را برکت داد، و هریک را موافق برکت وی برکت داد. ");
INSERT INTO pesOPV_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","پس ایشان را وصیت فرموده، گفت: «من به قوم خود ملحق می‌شوم، مرا با پدرانم در مغاره‌ای که در صحرای عفرون حتی است، دفن کنید. ");
INSERT INTO pesOPV_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","در مغاره‌ای که در صحرای مکفیله است، که درمقابل ممری در زمین کنعان واقع است، که ابراهیم آن را با آن صحرا از عفرون حتی برای ملکیت مقبره خرید. ");
INSERT INTO pesOPV_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","آنجا ابراهیم و زوجه‌اش، ساره رادفن کردند؛ آنجا اسحاق و زوجه او رفقه را دفن کردند؛ و آنجا لیه را دفن نمودم. ");
INSERT INTO pesOPV_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","خرید آن صحرا و مغاره‌ای که در آن است از بنی حت بود.» ");
INSERT INTO pesOPV_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","و چون یعقوب وصیت را با پسران خود به پایان برد، پایهای خود را به بستر کشیده، جان بداد و به قوم خویش ملحق گردید. ");
INSERT INTO pesOPV_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","و یوسف بر روی پدر خود افتاده، بروی گریست و او را بوسید. ");
INSERT INTO pesOPV_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","و یوسف طبیبانی را که از بندگان او بودند، امر فرمود تا پدراو را حنوط کنند. و طبیبان، اسرائیل را حنوطکردند. ");
INSERT INTO pesOPV_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","و چهل روز در کار وی سپری شد، زیراکه این قدر روزها در حنوط کردن صرف می‌شد، و اهل مصر هفتاد روز برای وی ماتم گرفتند. ");
INSERT INTO pesOPV_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","وچون ایام ماتم وی تمام شد، یوسف اهل خانه فرعون را خطاب کرده، گفت: «اگر الان در نظرشما التفات یافته‌ام، در گوش فرعون عرض کرده، بگویید: ");
INSERT INTO pesOPV_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","“پدرم مرا سوگند داده، گفت: اینک من می‌میرم؛ در قبری که برای خویشتن در زمین کنعان کنده‌ام، آنجا مرا دفن کن.” اکنون بروم و پدرخود را دفن کرده، مراجعت نمایم.» ");
INSERT INTO pesOPV_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","فرعون گفت: «برو و چنانکه پدرت به تو سوگند داده است، او را دفن کن.» ");
INSERT INTO pesOPV_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","پس یوسف روانه شد تا پدرخود را دفن کند، و همه نوکران فرعون که مشایخ خانه وی بودند، و جمیع مشایخ زمین مصر با او رفتند. ");
INSERT INTO pesOPV_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","و همه اهل خانه یوسف و برادرانش واهل خانه پدرش، جز اینکه اطفال و گله‌ها ورمه های خود را در زمین جوشن واگذاشتند. ");
INSERT INTO pesOPV_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","وارابه‌ها نیز و سواران، همراهش رفتند؛ و انبوهی بسیار کثیر بودند. ");
INSERT INTO pesOPV_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","پس به خرمنگاه اطاد که آنطرف اردن است رسیدند، و در آنجا ماتمی عظیم و بسیار سخت گرفتند، و برای پدر خودهفت روز نوحه گری نمود. ");
INSERT INTO pesOPV_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","و چون کنعانیان ساکن آن زمین، این ماتم را در خرمنگاه اطاددیدند، گفتند: «این برای مصریان ماتم سخت است.» از این‌رو آن موضع را آبل مصرایم نامیدند، که بدان طرف اردن واقع است. ");
INSERT INTO pesOPV_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","همچنان پسران او بدان طوریکه امر فرموده بود، کردند. ");
INSERT INTO pesOPV_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","و پسرانش، او را به زمین کنعان بردند. و او را در مغاره صحرای مکفیله، که ابراهیم با آن صحرا از عفرون حتی برای ملکیت مقبره خریده بود، در مقابل ممری دفن کردند. ");
INSERT INTO pesOPV_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","و یوسف بعد از دفن پدر خود، با برادران خویش و همه کسانی که برای دفن پدرش با وی رفته بودند، به مصر برگشتند. ");
INSERT INTO pesOPV_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","و چون برادران یوسف دیدند که پدر ایشان مرده است، گفتند: «اگر یوسف الان از ما کینه دارد، هر آینه مکافات همه بدی را که به وی کرده‌ایم به ما خواهد رسانید.» ");
INSERT INTO pesOPV_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","پس نزد یوسف فرستاده، گفتند: «پدر تو قبل از مردنش امرفرموده، گفت: ");
INSERT INTO pesOPV_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","به یوسف چنین بگویید: التماس دارم که گناه و خطای برادران خود را عفوفرمایی، زیرا که به تو بدی کرده‌اند، پس اکنون گناه بندگان خدای پدر خود را عفو فرما.» و چون به وی سخن‌گفتند، یوسف بگریست. ");
INSERT INTO pesOPV_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","وبرادرانش نیز آمده، به حضور وی افتادند، وگفتند: «اینک غلامان تو هستیم.» ");
INSERT INTO pesOPV_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","یوسف ایشان را گفت: «مترسید زیرا که آیا من در جای خدا هستم؟ ");
INSERT INTO pesOPV_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","شما درباره من بد اندیشیدید، لیکن خدا از آن قصد نیکی کرد، تا کاری کند که قوم کثیری را احیا نماید، چنانکه امروز شده است. ");
INSERT INTO pesOPV_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","و الان ترسان مباشید. من، شما را واطفال شما را می‌پرورانم.» پس ایشان را تسلی دادو سخنان دل آویز بدیشان گفت. ");
INSERT INTO pesOPV_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","و یوسف در مصر ساکن ماند، او و اهل خانه پدرش. و یوسف صد و ده سال زندگانی کرد. ");
INSERT INTO pesOPV_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","ویوسف پسران پشت سوم افرایم را دید. و پسران ماکیر، پسر منسی نیز بر زانوهای یوسف تولدیافتند. ");
INSERT INTO pesOPV_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","و یوسف، برادران خود را گفت: «من می‌میرم، و یقین خدا از شما تفقد خواهد نمود، وشما را از این زمین به زمینی که برای ابراهیم واسحاق و یعقوب قسم خورده است، خواهدبرد.» ");
INSERT INTO pesOPV_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","و یوسف به بنی‌اسرائیل سوگند داده، گفت: «هر آینه خدا از شما تفقد خواهد نمود، واستخوانهای مرا از اینجا خواهید برداشت.» ");
INSERT INTO pesOPV_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","ویوسف مرد در حینی که صد و ده ساله بود. و اورا حنوط کرده، در زمین مصر در تابوت گذاشتند. ");
INSERT INTO pesOPV_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","و این است نامهای پسران اسرائیل که به مصر آمدند، هر کس با اهل خانه‌اش همراه یعقوب آمدند: ");
INSERT INTO pesOPV_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","روبین و شمعون و لاوی ویهودا، ");
INSERT INTO pesOPV_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","یساکار و زبولون و بنیامین، ");
INSERT INTO pesOPV_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","و دان ونفتالی، و جاد و اشیر. ");
INSERT INTO pesOPV_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","و همه نفوسی که از صلب یعقوب پدید آمدند هفتاد نفر بودند. و یوسف درمصر بود. ");
INSERT INTO pesOPV_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","و یوسف و همه برادرانش، و تمامی آن طبقه مردند. ");
INSERT INTO pesOPV_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","و بنی‌اسرائیل بارور و منتشر شدند، وکثیر و بی‌نهایت زورآور گردیدند. و زمین ازایشان پر گشت. ");
INSERT INTO pesOPV_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","اما پادشاهی دیگر بر مصربرخاست که یوسف را نشناخت. ");
INSERT INTO pesOPV_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","و به قوم خودگفت: «همانا قوم بنی‌اسرائیل از ما زیاده وزورآورترند. ");
INSERT INTO pesOPV_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","بیایید با ایشان به حکمت رفتارکنیم، مبادا که زیاد شوند. و واقع شود که چون جنگ پدید آید، ایشان نیز با دشمنان ماهمداستان شوند، و با ما جنگ کرده، از زمین بیرون روند.» ");
INSERT INTO pesOPV_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","پس سرکاران بر ایشان گماشتند، تا ایشان را به‌کارهای دشوار ذلیل سازند، و برای فرعون شهرهای خزینه، یعنی فیتوم و رعمسیس را بناکردند. ");
INSERT INTO pesOPV_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","لیکن چندانکه بیشتر ایشان را ذلیل ساختند، زیادتر متزاید و منتشر گردیدند، و ازبنی‌اسرائیل احتراز می‌نمودند. ");
INSERT INTO pesOPV_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","و مصریان ازبنی‌اسرائیل به ظلم خدمت گرفتند. ");
INSERT INTO pesOPV_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","و جانهای ایشان را به بندگی سخت، به گل کاری وخشت سازی و هر گونه عمل صحرایی، تلخ ساختندی. و هر خدمتی که بر ایشان نهادندی به ظلم می‌بود. ");
INSERT INTO pesOPV_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","و پادشاه مصر به قابله های عبرانی که یکی را شفره و دیگری را فوعه نام بود، امرکرده، ");
INSERT INTO pesOPV_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","گفت: «چون قابله گری برای زنان عبرانی بکنید، و بر سنگها نگاه کنید، اگر پسر باشد او رابکشید، و اگر دختر بود زنده بماند.» ");
INSERT INTO pesOPV_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","لکن قابله‌ها از خدا ترسیدند، و آنچه پادشاه مصربدیشان فرموده بود نکردند، بلکه پسران را زنده گذاردند. ");
INSERT INTO pesOPV_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","پس پادشاه مصر قابله‌ها را طلبیده، بدیشان گفت: «چرا این کار را کردید، و پسران را زنده گذاردید؟» ");
INSERT INTO pesOPV_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","قابله‌ها به فرعون گفتند: «از این سبب که زنان عبرانی چون زنان مصری نیستند، بلکه زورآورند، و قبل از رسیدن قابله می‌زایند.» ");
INSERT INTO pesOPV_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","و خدا با قابله‌ها احسان نمود، و قوم کثیرشدند، و بسیار توانا گردیدند. ");
INSERT INTO pesOPV_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","و واقع شدچونکه قابله‌ها از خدا ترسیدند، خانه‌ها برای ایشان بساخت. ");
INSERT INTO pesOPV_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","و فرعون قوم خود را امر کرده، گفت: «هر پسری که زاییده شود به نهر اندازید، وهر دختری را زنده نگاه دارید. ");
INSERT INTO pesOPV_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","و شخصی از خاندان لاوی رفته، یکی ازدختران لاوی را به زنی گرفت. ");
INSERT INTO pesOPV_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","و آن زن حامله شده، پسری بزاد. و چون او را نیکومنظردید، وی را سه ماه نهان داشت. ");
INSERT INTO pesOPV_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","و چون نتوانست او را دیگر پنهان دارد، تابوتی از نی برایش گرفت، و آن را به قیر و زفت اندوده، طفل را در آن نهاد، وآن را در نیزار به کنار نهر گذاشت. ");
INSERT INTO pesOPV_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","و خواهرش ازدور ایستاد تا بداند او را چه می‌شود. ");
INSERT INTO pesOPV_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","و دخترفرعون برای غسل به نهر فرود آمد. و کنیزانش به کنار نهر می‌گشتند. پس تابوت را در میان نیزاردیده، کنیزک خویش را فرستاد تا آن را بگیرد. ");
INSERT INTO pesOPV_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","وچون آن را بگشاد، طفل را دید و اینک پسری گریان بود. پس دلش بر وی بسوخت و گفت: «این از اطفال عبرانیان است.» ");
INSERT INTO pesOPV_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","و خواهر وی به دخترفرعون گفت: «آیا بروم و زنی شیرده را از زنان عبرانیان نزدت بخوانم تا طفل را برایت شیردهد؟» ");
INSERT INTO pesOPV_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","دختر فرعون به وی گفت: «برو.» پس آن دختر رفته، مادر طفل را بخواند. ");
INSERT INTO pesOPV_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","و دختر فرعون گفت: «این طفل را ببر و او را برای من شیر بده ومزد تو را خواهم داد.» پس آن زن طفل رابرداشته، بدو شیر می‌داد. ");
INSERT INTO pesOPV_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","و چون طفل نموکرد، وی را نزد دختر فرعون برد، و او را پسر شد. و وی را موسی نام نهاد زیرا گفت: «او را از آب کشیدم.» ");
INSERT INTO pesOPV_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","و واقع شد در آن ایام که چون موسی بزرگ شد، نزد برادران خود بیرون آمد، و به‌کارهای دشوار ایشان نظر انداخته، شخصی مصری را دیدکه شخصی عبرانی را که از برادران او بود، می‌زند. ");
INSERT INTO pesOPV_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","پس به هر طرف نظر افکنده، چون کسی را ندید، آن مصری را کشت، و او را در ریگ پنهان ساخت. ");
INSERT INTO pesOPV_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","و روز دیگر بیرون آمد، که ناگاه دومرد عبرانی منازعه می‌کنند، پس به ظالم گفت: «چرا همسایه خود را می‌زنی.» ");
INSERT INTO pesOPV_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","گفت: «کیست که تو را بر ما حاکم یا داور ساخته است، مگر تومی خواهی مرا بکشی چنانکه آن مصری راکشتی؟» پس موسی ترسید و گفت: «یقین این امرشیوع یافته است.» ");
INSERT INTO pesOPV_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","و چون فرعون این ماجرا رابشنید، قصد قتل موسی کرد، و موسی از حضورفرعون فرار کرده، در زمین مدیان ساکن شد. و برسر چاهی بنشست. ");
INSERT INTO pesOPV_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","و کاهن مدیان را هفت دختر بود که آمدند و آب کشیده، آبخورها را پرکردند، تا گله پدر خویش را سیراب کنند. ");
INSERT INTO pesOPV_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","وشبانان نزدیک آمدند، تا ایشان را دور کنند. آنگاه موسی برخاسته، ایشان را مدد کرد، و گله ایشان راسیراب نمود. ");
INSERT INTO pesOPV_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","و چون نزد پدر خود رعوئیل آمدند، او گفت: «چگونه امروز بدین زودی برگشتید؟» ");
INSERT INTO pesOPV_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","گفتند: «شخصی مصری ما را ازدست شبانان رهایی داد، و آب نیز برای ما کشیده، گله را سیراب نمود.» ");
INSERT INTO pesOPV_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","پس به دختران خودگفت: «او کجاست؟ چرا آن مرد را ترک کردید؟ وی را بخوانید تا نان خورد.» ");
INSERT INTO pesOPV_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","و موسی راضی شد که با آن مرد ساکن شود، و او دختر خود، صفوره را به موسی داد. ");
INSERT INTO pesOPV_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","و آن زن پسری زایید، و (موسی ) او را جرشون نام نهاد، چه گفت: «در زمین بیگانه نزیل شدم.» ");
INSERT INTO pesOPV_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","و واقع شد بعد از ایام بسیار که پادشاه مصربمرد، و بنی‌اسرائیل به‌سبب بندگی آه کشیده، استغاثه کردند، و ناله ایشان به‌سبب بندگی نزد خدا برآمد. ");
INSERT INTO pesOPV_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","و خدا ناله ایشان را شنید، و خداعهد خود را با ابراهیم و اسحاق و یعقوب بیادآورد. ");
INSERT INTO pesOPV_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","و خدا بر بنی‌اسرائیل نظر کرد و خدادانست. ");
INSERT INTO pesOPV_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","و اما موسی گله پدر زن خود، یترون، کاهن مدیان را شبانی می‌کرد، و گله را بدان طرف صحرا راند و به حوریب که جبل الله باشد آمد. ");
INSERT INTO pesOPV_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","وفرشته خداوند در شعله آتش از میان بوته‌ای بروی ظاهر شد، و چون او نگریست، اینک آن بوته به آتش مشتعل است اما سوخته نمی شود. ");
INSERT INTO pesOPV_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","وموسی گفت: «اکنون بدان طرف شوم، و این امرغریب را ببینم، که بوته چرا سوخته نمی شود.» ");
INSERT INTO pesOPV_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","چون خداوند دید که برای دیدن مایل بدان سومی شود، خدا از میان بوته به وی ندا درداد و گفت: «ای موسی! ای موسی!» گفت: «لبیک.» ");
INSERT INTO pesOPV_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","گفت: «بدین جا نزدیک میا، نعلین خود را از پایهایت بیرون کن، زیرا مکانی که در آن ایستاده‌ای زمین مقدس است.» ");
INSERT INTO pesOPV_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","و گفت: «من هستم خدای پدرت، خدای ابراهیم، و خدای اسحاق، وخدای یعقوب.» آنگاه موسی روی خود راپوشانید، زیرا ترسید که به خدا بنگرد. ");
INSERT INTO pesOPV_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","وخداوند گفت: «هر آینه مصیبت قوم خود را که درمصرند دیدم، و استغاثه ایشان را از دست سرکاران ایشان شنیدم، زیرا غمهای ایشان رامی دانم. ");
INSERT INTO pesOPV_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","و نزول کردم تا ایشان را از دست مصریان خلاصی دهم، و ایشان را از آن زمین به زمین نیکو و وسیع برآورم، به زمینی که به شیر وشهد جاری است، به مکان کنعانیان و حتیان و اموریان و فرزیان و حویان و یبوسیان. ");
INSERT INTO pesOPV_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","و الان اینک استغاثه بنی‌اسرائیل نزد من رسیده است، وظلمی را نیز که مصریان بر ایشان می‌کنند، دیده‌ام. ");
INSERT INTO pesOPV_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","پس اکنون بیا تا تو را نزد فرعون بفرستم، و قوم من، بنی‌اسرائیل را از مصر بیرون آوری.» ");
INSERT INTO pesOPV_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","موسی به خدا گفت: «من کیستم که نزدفرعون بروم، و بنی‌اسرائیل را از مصر بیرون آورم؟» ");
INSERT INTO pesOPV_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","گفت: «البته با تو خواهم بود. و علامتی که من تو را فرستاده‌ام، این باشد که چون قوم را ازمصر بیرون آوردی، خدا را بر این کوه عبادت خواهید کرد.» ");
INSERT INTO pesOPV_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","موسی به خدا گفت: «اینک چون من نزد بنی‌اسرائیل برسم، و بدیشان گویم خدای پدران شما مرا نزد شما فرستاده است، و ازمن بپرسند که نام او چیست، بدیشان چه گویم؟» ");
INSERT INTO pesOPV_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","خدا به موسی گفت: «هستم آنکه هستم.» وگفت: «به بنی‌اسرائیل چنین بگو: اهیه (هستم ) مرانزد شما فرستاد.» ");
INSERT INTO pesOPV_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","و خدا باز به موسی گفت: «به بنی‌اسرائیل چنین بگو، یهوه خدای پدران شما، خدای ابراهیم و خدای اسحاق و خدای یعقوب، مرا نزد شما فرستاده، این است نام من تا ابدالاباد، و این است یادگاری من نسلا بعد نسل. ");
INSERT INTO pesOPV_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","برو ومشایخ بنی‌اسرائیل را جمع کرده، بدیشان بگو: یهوه خدای پدران شما، خدای ابراهیم و اسحاق و یعقوب، به من ظاهر شده، گفت: هر آینه از شماو از آنچه به شما در مصر کرده‌اند، تفقد کرده‌ام، ");
INSERT INTO pesOPV_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","و گفتم شما را از مصیبت مصر بیرون خواهم آورد، به زمین کنعانیان و حتیان و اموریان وفرزیان و حویان و یبوسیان، به زمینی که به شیر وشهد جاری است. ");
INSERT INTO pesOPV_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","و سخن تو را خواهندشنید، و تو با مشایخ اسرائیل، نزد پادشاه مصر بروید، و به وی گویید: یهوه خدای عبرانیان ما راملاقات کرده است. و الان سفر سه روزه به صحرابرویم، تا برای یهوه خدای خود قربانی بگذرانیم. ");
INSERT INTO pesOPV_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","و من می‌دانم که پادشاه مصر شما را نمی گذاردبروید، و نه هم به‌دست زورآور. ");
INSERT INTO pesOPV_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","پس دست خود را دراز خواهم کرد، و مصر را به همه عجایب خود که در میانش به ظهور می‌آورم خواهم زد، و بعد از آن شما را رها خواهد کرد. ");
INSERT INTO pesOPV_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","و این قوم را در نظر مصریان مکرم خواهم ساخت، و واقع خواهد شد که چون بروید تهی‌دست نخواهید رفت. ");
INSERT INTO pesOPV_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","بلکه هر زنی از همسایه خود و مهمان خانه خویش آلات نقره و آلات طلا و رخت خواهد خواست، و به پسران ودختران خود خواهید پوشانید، و مصریان راغارت خواهید نمود.» ");
INSERT INTO pesOPV_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","تصدیق نخواهند کرد، و سخن مرانخواهند شنید، بلکه خواهند گفت یهوه بر توظاهر نشده است.» ");
INSERT INTO pesOPV_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","پس خداوند به وی گفت: «آن چیست در دست تو؟» گفت: «عصا.» ");
INSERT INTO pesOPV_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","گفت: «آن را بر زمین بینداز.» و چون آن را به زمین انداخت، ماری گردید و موسی از نزدش گریخت. ");
INSERT INTO pesOPV_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","پس خداوند به موسی گفت: «دست خود رادراز کن و دمش را بگیر.» پس دست خود را درازکرده، آن را بگرفت، که در دستش عصا شد. ");
INSERT INTO pesOPV_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","«تاآنکه باور کنند که یهوه خدای پدران ایشان، خدای ابراهیم، خدای اسحاق، و خدای یعقوب، به تو ظاهر شد.» ");
INSERT INTO pesOPV_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","و خداوند دیگرباره وی راگفت: «دست خود را در گریبان خود بگذار.» چون دست به گریبان خود برد، و آن را بیرون آورد، اینک دست او مثل برف مبروص شد. ");
INSERT INTO pesOPV_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","پس گفت: «دست خود را باز به گریبان خود بگذار.» چون دست به گریبان خود باز برد، و آن را بیرون آورد، اینک مثل سایر بدنش باز آمده بود. ");
INSERT INTO pesOPV_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","«وواقع خواهد شد که اگر تو را تصدیق نکنند، وآواز آیت نخستین را نشنوند، همانا آواز آیت دوم را باور خواهند کرد. ");
INSERT INTO pesOPV_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","و هر گاه این دو آیت راباور نکردند و سخن تو را نشنیدند، آنگاه از آب نهر گرفته، به خشکی بریز، و آبی که از نهر گرفتی بر روی خشکی به خون مبدل خواهد شد.» ");
INSERT INTO pesOPV_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","پس موسی به خداوند گفت: «ای خداوند، من مردی فصیح نیستم، نه در سابق و نه از وقتی که به بنده خود سخن گفتی، بلکه بطی الکلام و کندزبان.» ");
INSERT INTO pesOPV_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","خداوند گفت: «کیست که زبان به انسان داد، و گنگ و کر و بینا و نابینا را که آفرید؟ آیا نه من که یهوه هستم؟ ");
INSERT INTO pesOPV_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","پس الان برو و من با زبانت خواهم بود، و هر‌چه باید بگویی تو را خواهم آموخت.» ");
INSERT INTO pesOPV_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","گفت: «استدعا دارم‌ای خداوند که بفرستی به‌دست هر‌که می‌فرستی.» ");
INSERT INTO pesOPV_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","آنگاه خشم خداوند بر موسی مشتعل شدو گفت: «آیا برادرت، هارون لاوی را نمی دانم که او فصیح الکلام است؟ و اینک او نیز به استقبال توبیرون می‌آید، و چون تو را ببیند، در دل خود شادخواهد گردید. ");
INSERT INTO pesOPV_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","و بدو سخن خواهی گفت وکلام را به زبان وی القا خواهی کرد، و من با زبان توو با زبان او خواهم بود، و آنچه باید بکنید شما راخواهم آموخت. ");
INSERT INTO pesOPV_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","و او برای تو به قوم سخن خواهد گفت، و او مر تو را به‌جای زبان خواهدبود، و تو او را به‌جای خدا خواهی بود. ");
INSERT INTO pesOPV_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","و این عصا را به‌دست خود بگیر که به آن آیات را ظاهر سازی.» ");
INSERT INTO pesOPV_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","پس موسی روانه شده، نزد پدر زن خود، یترون، برگشت و به وی گفت: «بروم و نزد برادران خود که در مصرند برگردم، و ببینم که تا کنون زنده‌اند.» یترون به موسی گفت: «به سلامتی برو.» ");
INSERT INTO pesOPV_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","و خداوند در مدیان به موسی گفت: «روانه شده به مصر برگرد، زیرا آنانی که در قصد جان توبودند، مرده‌اند.» ");
INSERT INTO pesOPV_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","پس موسی زن خویش وپسران خود را برداشته، ایشان را بر الاغ سوارکرده، به زمین مصر مراجعت نمود، و موسی عصای خدا را به‌دست خود گرفت. ");
INSERT INTO pesOPV_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","و خداوندبه موسی گفت: «چون روانه شده، به مصرمراجعت کردی، آگاه باش که همه علاماتی را که به‌دستت سپرده‌ام به حضور فرعون ظاهر سازی، و من دل او را سخت خواهم ساخت تا قوم را رهانکند. ");
INSERT INTO pesOPV_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","و به فرعون بگو خداوند چنین می‌گوید: اسرائیل، پسر من و نخست زاده من است، ");
INSERT INTO pesOPV_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","و به تو می‌گویم پسرم را رها کن تا مرا عبادت نماید، واگر از رها کردنش ابا نمایی، همانا پسر تو، یعنی نخست زاده تو را می‌کشم.» ");
INSERT INTO pesOPV_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","و واقع شد در بین راه که خداوند در منزل بدو برخورده، قصد قتل وی نمود. ");
INSERT INTO pesOPV_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","آنگاه صفوره سنگی تیز گرفته، غلفه پسر خود را ختنه کرد و نزد پای وی انداخته، گفت: «تو مرا شوهرخون هستی.» ");
INSERT INTO pesOPV_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","پس او وی را رها کرد، آنگاه (صفوره ) گفت: «شوهر خون هستی، » به‌سبب ختنه. ");
INSERT INTO pesOPV_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","و خداوند به هارون گفت: «به سوی صحرا به استقبال موسی برو.» پس روانه شد و او را در جبل الله ملاقات کرده، او را بوسید. ");
INSERT INTO pesOPV_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","وموسی از جمیع کلمات خداوند که او را فرستاده بود، و از همه آیاتی که به وی امر فرموده بود، هارون را خبر داد. ");
INSERT INTO pesOPV_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","پس موسی و هارون رفته، کل مشایخ بنی‌اسرائیل را جمع کردند. ");
INSERT INTO pesOPV_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","وهارون همه سخنانی را که خداوند به موسی فرموده بود، باز‌گفت، و آیات را به نظر قوم ظاهرساخت. ");
INSERT INTO pesOPV_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","و قوم ایمان آوردند. و چون شنیدندکه خداوند از بنی‌اسرائیل تفقد نموده، و به مصیبت ایشان نظر انداخته است، به روی درافتاده، سجده کردند. ");
INSERT INTO pesOPV_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","و بعد از آن موسی و هارون آمده، به فرعون گفتند: «یهوه خدای اسرائیل چنین می‌گوید: قوم مرا رها کن تا برای من در صحرا عیدنگاه دارند.» ");
INSERT INTO pesOPV_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","فرعون گفت: «یهوه کیست که قول او را بشنوم و اسرائیل را رهایی دهم؟ یهوه رانمی شناسم و اسرائیل را نیز رها نخواهم کرد.» ");
INSERT INTO pesOPV_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","گفتند: «خدای عبرانیان ما را ملاقات کرده است، پس الان سفر سه روزه به صحرا برویم، ونزد یهوه، خدای خود، قربانی بگذرانیم، مبادا مارا به وبا یا شمشیر مبتلا سازد.» ");
INSERT INTO pesOPV_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","پس پادشاه مصربدیشان گفت: «ای موسی و هارون چرا قوم را ازکارهای ایشان بازمی دارید؟ به شغلهای خودبروید!» ");
INSERT INTO pesOPV_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","و فرعون گفت: «اینک الان اهل زمین بسیارند، و ایشان را از شغلهای ایشان بیکارمی سازید.» ");
INSERT INTO pesOPV_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","و در آن روز، فرعون سرکاران و ناظران قوم خود را قدغن فرموده، گفت: ");
INSERT INTO pesOPV_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","«بعد از این، کاه برای خشت سازی مثل سابق بدین قوم مدهید. خود بروند و کاه برای خویشتن جمع کنند. ");
INSERT INTO pesOPV_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","وهمان حساب خشتهایی را که پیشتر می‌ساختند، برایشان بگذارید، و از آن هیچ کم مکنید، زیراکاهلند، و از این‌رو فریاد می‌کنند و می‌گویند: برویم تا برای خدای خود قربانی گذرانیم. ");
INSERT INTO pesOPV_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","وخدمت ایشان سخت‌تر شود تا در آن مشغول شوند، و به سخنان باطل اعتنا نکنند.» ");
INSERT INTO pesOPV_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","پس سرکاران و ناظران قوم بیرون آمده، قوم را خطاب کرده، گفتند: «فرعون چنین می‌فرماید که من کاه به شما نمی دهم. ");
INSERT INTO pesOPV_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","خود بروید و کاه برای خود ازهرجا که بیابید بگیرید، و از خدمت شما هیچ کم نخواهد شد.» ");
INSERT INTO pesOPV_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","پس قوم در تمامی زمین مصر پراکنده شدند تا خاشاک به عوض کاه جمع کنند. ");
INSERT INTO pesOPV_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","وسرکاران، ایشان را شتابانیده، گفتند: «کارهای خود را تمام کنید، یعنی حساب هر روز را درروزش، مثل وقتی که کاه بود.» ");
INSERT INTO pesOPV_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","و ناظران، بنی‌اسرائیل را که سرکاران فرعون بر ایشان گماشته بودند، می‌زدند و می‌گفتند: «چرا خدمت معین خشت سازی خود را در این‌روزها مثل سابق تمام نمی کنید؟» ");
INSERT INTO pesOPV_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","آنگاه ناظران بنی‌اسرائیل آمده، نزد فرعون فریاد کرده، گفتند: «چرا به بندگان خود چنین می‌کنی؟ ");
INSERT INTO pesOPV_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","کاه به بندگانت نمی دهند و می‌گویند: خشت برای مابسازید! و اینک بندگانت را می‌زنند و اما خطا ازقوم تو می‌باشد.» ");
INSERT INTO pesOPV_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","گفت: «کاهل هستید. شماکاهلید! از این سبب شما می‌گویید: برویم و برای خداوند قربانی بگذرانیم. ");
INSERT INTO pesOPV_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","اکنون رفته، خدمت بکنید، و کاه به شما داده نخواهد شد، و حساب خشت را خواهید داد.» ");
INSERT INTO pesOPV_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","و ناظران بنی‌اسرائیل دیدند که در بدی گرفتار شده‌اند، زیرا گفت: «ازحساب یومیه خشتهای خود هیچ کم مکنید.» ");
INSERT INTO pesOPV_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","و چون از نزد فرعون بیرون آمدند، به موسی وهارون برخوردند، که برای ملاقات ایشان ایستاده بودند. ");
INSERT INTO pesOPV_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","و بدیشان گفتند: «خداوند بر شما بنگردو داوری فرماید! زیرا که رایحه ما را نزد فرعون وملازمانش متعفن ساخته‌اید، و شمشیری به‌دست ایشان داده‌اید تا ما را بکشند.» ");
INSERT INTO pesOPV_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","آنگاه موسی نزد خداوند برگشته، گفت: «خداوندا چرا بدین قوم بدی کردی؟ و برای چه مرا فرستادی؟ ");
INSERT INTO pesOPV_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","زیرا از وقتی که نزد فرعون آمدم تا به نام تو سخن گویم، بدین قوم بدی کرده است و قوم خود را هرگز خلاصی ندادی.» ");
INSERT INTO pesOPV_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","خداوند به موسی گفت: «الان خواهی دیدآنچه به فرعون می‌کنم، زیرا که به‌دست قوی ایشان را رها خواهد کرد، و به‌دست زورآورایشان را از زمین خود خواهد راند.» ");
INSERT INTO pesOPV_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","و خدا به موسی خطاب کرده، وی را گفت: «من یهوه هستم. ");
INSERT INTO pesOPV_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","و به ابراهیم و اسحاق و یعقوب به نام خدای قادرمطلق ظاهر شدم، لیکن به نام خود، یهوه، نزد ایشان معروف نگشتم. ");
INSERT INTO pesOPV_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","و عهد خود رانیز با ایشان استوار کردم، که زمین کنعان را بدیشان دهم، یعنی زمین غربت ایشان را که در آن غریب بودند. ");
INSERT INTO pesOPV_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","و من نیز چون ناله بنی‌اسرائیل را که مصریان ایشان را مملوک خود ساخته‌اند، شنیدم، عهد خود را بیاد آوردم. ");
INSERT INTO pesOPV_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","بنابراین بنی‌اسرائیل رابگو، من یهوه هستم، و شما را از زیر مشقتهای مصریان بیرون خواهم آورد، و شما را از بندگی ایشان رهایی دهم، و شما را به بازوی بلند و به داوری های عظیم نجات دهم. ");
INSERT INTO pesOPV_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","و شما را خواهم گرفت تا برای من قوم شوید، و شما را خداخواهم بود، و خواهید دانست که من یهوه هستم، خدای شما، که شما را از مشقتهای مصریان بیرون آوردم. ");
INSERT INTO pesOPV_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","و شما را خواهم رسانید به زمینی که درباره آن قسم خوردم که آن را به ابراهیم واسحاق و یعقوب بخشم، پس آن را به ارثیت شماخواهم داد. من یهوه هستم.» ");
INSERT INTO pesOPV_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","و موسی بنی‌اسرائیل را بدین مضمون گفت، لیکن بسبب تنگی روح و سختی خدمت، او رانشنیدند. ");
INSERT INTO pesOPV_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","و خداوند موسی را خطاب کرده، گفت: ");
INSERT INTO pesOPV_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","«برو و به فرعون پادشاه مصر بگو که بنی‌اسرائیل را از زمین خود رهایی دهد.» ");
INSERT INTO pesOPV_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","وموسی به حضور خداوند عرض کرده، گفت: «اینک بنی‌اسرائیل مرا نمی شنوند، پس چگونه فرعون مرا بشنود، و حال آنکه من نامختون لب هستم؟» ");
INSERT INTO pesOPV_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","و خداوند به موسی و هارون تکلم نموده، ایشان را به سوی بنی‌اسرائیل و به سوی فرعون پادشاه مصر مامور کرد، تا بنی‌اسرائیل را از زمین مصر بیرون آورند. ");
INSERT INTO pesOPV_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","و اینانند روسای خاندانهای آبای ایشان: پسران روبین، نخست زاده اسرائیل، حنوک و فلو و حصرون و کرمی؛ اینانندقبایل روبین. ");
INSERT INTO pesOPV_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","و پسران شمعون: یموئیل و یامین و اوهد و یاکین و صوحر و شاول که پسر زن کنعانی بود؛ اینانند قبایل شمعون. ");
INSERT INTO pesOPV_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","و این است نامهای پسران لاوی به حسب پیدایش ایشان: جرشون و قهات و مراری. و سالهای عمر لاوی صد و سی و هفت سال بود. ");
INSERT INTO pesOPV_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","پسران جرشون: لبنی و شمعی، به حسب قبایل ایشان. ");
INSERT INTO pesOPV_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","و پسران قهات: عمرام و یصهار و حبرون و عزیئیل. وسالهای عمر قهات صد و سی و سه سال بود. ");
INSERT INTO pesOPV_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","وپسران مراری: محلی و موشی؛ اینانند قبایل لاویان به حسب پیدایش ایشان. ");
INSERT INTO pesOPV_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","و عمرام عمه خود، یوکابد را به زنی گرفت، و او برای وی هارون و موسی را زایید، و سالهای عمر عمرام صد و سی و هفت سال بود. ");
INSERT INTO pesOPV_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","و پسران یصهار: قورح و نافج و زکری. ");
INSERT INTO pesOPV_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","و پسران عزیئیل: میشائیل و ایلصافن و ستری. ");
INSERT INTO pesOPV_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","و هارون، الیشابع، دختر عمیناداب، خواهر نحشون را به زنی گرفت، و برایش ناداب و ابیهو و العازر وایتامر را زایید. ");
INSERT INTO pesOPV_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","و پسران قورح: اسیر و القانه وابیاساف؛ اینانند قبایل قورحیان. ");
INSERT INTO pesOPV_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","و العازر بن هارون یکی از دختران فوتیئیل را به زنی گرفت، وبرایش فینحاس را زایید؛ اینانند روسای آبای لاویان، بحسب قبایل ایشان. ");
INSERT INTO pesOPV_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","اینانند هارون وموسی که خداوند بدیشان گفت: «بنی‌اسرائیل رابا جنود ایشان از زمین مصر بیرون آورید.» ");
INSERT INTO pesOPV_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","اینانند که به فرعون پادشاه مصر سخن‌گفتند، برای بیرون آوردن بنی‌اسرائیل از مصر. اینان موسی و هارونند. ");
INSERT INTO pesOPV_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","و واقع شد در روزی که خداوند در زمین مصر موسی را خطاب کرد. ");
INSERT INTO pesOPV_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","که خداوند به موسی فرموده، گفت: «من یهوه هستم هر‌آنچه من به تو گویم آن را به فرعون پادشاه مصر بگو.» ");
INSERT INTO pesOPV_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","وموسی به حضور خداوند عرض کرد: «اینک من نامختون لب هستم، پس چگونه فرعون مرابشنود؟» ");
INSERT INTO pesOPV_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","و خداوند به موسی گفت: «ببین تو را برفرعون خدا ساخته‌ام، و برادرت، هارون، نبی تو خواهد بود. ");
INSERT INTO pesOPV_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","هرآنچه به تو امر نمایم تو آن را بگو، و برادرت هارون، آن را به فرعون بازگوید، تا بنی‌اسرائیل را از زمین خود رهایی دهد. ");
INSERT INTO pesOPV_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","و من دل فرعون را سخت می‌کنم، و آیات وعلامات خود را در زمین مصر بسیار می‌سازم. ");
INSERT INTO pesOPV_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","وفرعون به شما گوش نخواهد گرفت، و دست خودرا بر مصر خواهم‌انداخت، تا جنود خود، یعنی قوم خویش بنی‌اسرائیل را از زمین مصر به داوریهای عظیم بیرون آورم. ");
INSERT INTO pesOPV_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","و مصریان خواهند دانست که من یهوه هستم، چون دست خود را بر مصر دراز کرده، بنی‌اسرائیل را از میان ایشان بیرون آوردم.» ");
INSERT INTO pesOPV_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","و موسی و هارون چنانکه خداوند بدیشان امر فرموده بود کردند، و هم چنین عمل نمودند. ");
INSERT INTO pesOPV_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","و موسی هشتاد ساله بود وهارون هشتاد و سه ساله، وقتی که به فرعون سخن‌گفتند. ");
INSERT INTO pesOPV_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","پس خداوند موسی و هارون را خطاب کرده، گفت: ");
INSERT INTO pesOPV_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","«چون فرعون شما را خطاب کرده، گوید معجزه‌ای برای خود ظاهر کنید، آنگاه به هارون بگو عصای خود را بگیر، و آن را پیش روی فرعون بینداز، تا اژدها شود.» ");
INSERT INTO pesOPV_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","آنگاه موسی و هارون نزد فرعون رفتند، و آنچه خداوندفرموده بود کردند. و هارون عصای خود را پیش روی فرعون و پیش روی ملازمانش انداخت، واژدها شد. ");
INSERT INTO pesOPV_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","و فرعون نیز حکیمان و جادوگران را طلبید و ساحران مصر هم به افسونهای خودچنین کردند، ");
INSERT INTO pesOPV_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","هر یک عصای خود را انداختند و اژدها شد، ولی عصای هارون عصاهای ایشان را بلعید. ");
INSERT INTO pesOPV_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","و دل فرعون سخت شد و ایشان رانشنید، چنانکه خداوند گفته بود. ");
INSERT INTO pesOPV_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","و خداوند موسی را گفت: «دل فرعون سخت شده، و از رها کردن قوم ابا کرده است. ");
INSERT INTO pesOPV_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","بامدادان نزد فرعون برو، اینک به سوی آب بیرون می‌آید، و برای ملاقات وی به کنار نهربایست، و عصا را که به مار مبدل گشت، بدست خود بگیر. ");
INSERT INTO pesOPV_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","و او را بگو: یهوه خدای عبرانیان مرا نزد تو فرستاده، گفت: قوم مرا رها کن تا مرا درصحرا عبادت نمایند و اینک تا بحال نشنیده‌ای، ");
INSERT INTO pesOPV_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","پس خداوند چنین می‌گوید، از این خواهی دانست که من یهوه هستم، همانا من به عصایی که در دست دارم آب نهر را می‌زنم و به خون مبدل خواهد شد. ");
INSERT INTO pesOPV_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","و ماهیانی که در نهرند خواهندمرد، و نهر گندیده شود و مصریان نوشیدن آب نهر را مکروه خواهند داشت.» ");
INSERT INTO pesOPV_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","و خداوند به موسی گفت: «به هارون بگوعصای خود را بگیر و دست خود را بر آبهای مصر دراز کن، بر نهرهای ایشان، و جویهای ایشان، و دریاچه های ایشان، و همه حوضهای آب ایشان، تا خون شود، و در تمامی زمین مصردر ظروف چوبی و ظروف سنگی، خون خواهدبود.» ");
INSERT INTO pesOPV_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","و موسی و هارون چنانکه خداوند امرفرموده بود، کردند. و عصا را بلند کرده، آب نهر رابه حضور فرعون و به حضور ملازمانش زد، وتمامی آب نهر به خون مبدل شد. ");
INSERT INTO pesOPV_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","و ماهیانی که در نهر بودند، مردند. و نهر بگندید، و مصریان از آب نهر نتوانستند نوشید، و در تمامی زمین مصرخون بود. ");
INSERT INTO pesOPV_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","و جادوگران مصر به افسونهای خویش هم چنین کردند، و دل فرعون سخت شد، که بدیشان گوش نگرفت، چنانکه خداوند گفته بود. ");
INSERT INTO pesOPV_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","و فرعون برگشته، به خانه خود رفت و براین نیز دل خود را متوجه نساخت. ");
INSERT INTO pesOPV_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","و همه مصریان گرداگرد نهر برای آب خوردن حفره می‌زدند زیرا که از آب نهر نتوانستند نوشید. ");
INSERT INTO pesOPV_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","وبعد از آنکه خداوند نهر را زده بود، هفت روزسپری شد. ");
INSERT INTO pesOPV_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","و خداوند موسی را گفت: «نزد فرعون برو، و به وی بگو خداوند چنین می‌گوید: قوم مرا رها کن تا مرا عبادت نمایند، ");
INSERT INTO pesOPV_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","و اگر تو از رهاکردن ایشان ابا می‌کنی، همانا من تمامی حدود تورا به وزغها مبتلا سازم. ");
INSERT INTO pesOPV_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","و نهر، وزغها را به کثرت پیدا نماید، به حدی که برآمده، به خانه ات وخوابگاهت و بسترت و خانه های بندگانت و برقومت و به تنورهایت و تغارهای خمیرت، درخواهند آمد، ");
INSERT INTO pesOPV_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","و بر تو و قوم تو و همه بندگان تو وزغها برخواهند آمد.» ");
INSERT INTO pesOPV_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","و خداوند به موسی گفت: «به هارون بگو: دست خود را با عصای خویش بر نهرها و جویها و دریاچه‌ها دراز کن، ووزغها را بر زمین مصر برآور.» ");
INSERT INTO pesOPV_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","پس چون هارون دست خود را بر آبهای مصر دراز کرد، وزغها برآمده، زمین مصر راپوشانیدند. ");
INSERT INTO pesOPV_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","و جادوگران به افسونهای خودچنین کردند، و وزغها بر زمین مصر برآوردند. ");
INSERT INTO pesOPV_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","آنگاه فرعون موسی و هارون را خوانده، گفت: «نزد خداوند دعا کنید، تا وزغها را از من و قوم من دور کند، و قوم را رها خواهم کرد تا برای خداوندقربانی گذرانند.» ");
INSERT INTO pesOPV_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","موسی به فرعون گفت: «وقتی را برای من معین فرما که برای تو و بندگانت وقومت دعا کنم تا وزغها از تو و خانه ات نابودشوند و فقط در نهر بمانند.» ");
INSERT INTO pesOPV_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","گفت: «فردا»، موسی گفت: «موافق سخن تو خواهد شد تا بدانی که مثل یهوه خدای ما دیگری نیست، ");
INSERT INTO pesOPV_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","و وزغهااز تو و خانه ات و بندگانت و قومت دور خواهندشد و فقط در نهر باقی خواهند ماند.» ");
INSERT INTO pesOPV_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","و موسی و هارون از نزد فرعون بیرون آمدند و موسی درباره وزغهایی که بر فرعون فرستاده بود، نزدخداوند استغاثه نمود. ");
INSERT INTO pesOPV_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","و خداوند موافق سخن موسی عمل نمود و وزغها از خانه‌ها و از دهات واز صحراها مردند، ");
INSERT INTO pesOPV_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","و آنها را توده توده جمع کردند و زمین متعفن شد. ");
INSERT INTO pesOPV_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","اما فرعون چون دیدکه آسایش پدید آمد، دل خود را سخت کرد وبدیشان گوش نگرفت، چنانکه خداوند گفته بود. ");
INSERT INTO pesOPV_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","و خداوند به موسی گفت: «به هارون بگو که عصای خود را دراز کن و غبار زمین را بزن تا درتمامی زمین مصر پشه‌ها بشود.» ");
INSERT INTO pesOPV_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","پس چنین کردند و هارون دست خود را با عصای خویش دراز کرد و غبار زمین را زد و پشه‌ها بر انسان وبهایم پدید آمد زیرا که تمامی غبار زمین در کل ارض مصر پشه‌ها گردید، ");
INSERT INTO pesOPV_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","و جادوگران به افسونهای خود چنین کردند تا پشه‌ها بیرون آورند اما نتوانستند و پشه‌ها بر انسان و بهایم پدیدشد. ");
INSERT INTO pesOPV_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","و جادوگران به فرعون گفتند: «این انگشت خداست.» اما فرعون را دل سخت شد که بدیشان گوش نگرفت، چنانکه خداوند گفته بود. ");
INSERT INTO pesOPV_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","و خداوند به موسی گفت: «بامدادان برخاسته پیش روی فرعون بایست. اینک بسوی آب بیرون می‌آید. و او را بگو: خداوند چنین می‌گوید: قوم مرا رها کن تا مرا عبادت نمایند، ");
INSERT INTO pesOPV_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","زیرا اگر قوم مرا رها نکنی، همانا من بر تو وبندگانت و قومت و خانه هایت انواع مگسهافرستم و خانه های مصریان و زمینی نیز که برآننداز انواع مگسها پر خواهد شد. ");
INSERT INTO pesOPV_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","و در آن روززمین جوشن را که قوم من در آن مقیمند، جداسازم که در آنجا مگسی نباشد تا بدانی که من درمیان این زمین یهوه هستم. ");
INSERT INTO pesOPV_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","و فرقی در میان قوم خود و قوم تو گذارم. فردا این علامت خواهدشد.» ");
INSERT INTO pesOPV_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","و خداوند چنین کرد و انواع مگسهای بسیار به خانه فرعون و به خانه های بندگانش و به تمامی زمین مصر آمدند و زمین از مگسها ویران شد. ");
INSERT INTO pesOPV_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","و فرعون موسی و هارون را خوانده گفت: «بروید و برای خدای خود قربانی در این زمین بگذرانید.» ");
INSERT INTO pesOPV_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","موسی گفت: «چنین کردن نشایدزیرا آنچه مکروه مصریان است برای یهوه خدای خود ذبح می‌کنیم. اینک چون مکروه مصریان را پیش روی ایشان ذبح نماییم، آیاما را سنگسار نمی کنند؟ ");
INSERT INTO pesOPV_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","سفر سه روزه به صحرا برویم و برای یهوه خدای خود قربانی بگذرانیم چنانکه به ما امر خواهد فرمود.» ");
INSERT INTO pesOPV_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","فرعون گفت: «من شما را رهایی خواهم داد تا برای یهوه، خدای خود، در صحرا قربانی گذرانید لیکن بسیار دور مروید و برای من دعاکنید.» ");
INSERT INTO pesOPV_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","موسی گفت: «همانا من از حضورت بیرون می‌روم و نزد خداوند دعا می‌کنم و مگسهااز فرعون و بندگانش و قومش فردا دور خواهندشد اما زنهار فرعون بار دیگر حیله نکند که قوم رارهایی ندهد تا برای خداوند قربانی گذرانند.» ");
INSERT INTO pesOPV_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","پس موسی از حضور فرعون بیرون شده نزدخداوند دعا کرد، ");
INSERT INTO pesOPV_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","و خداوند موافق سخن موسی عمل کرد و مگسها را از فرعون و بندگانش و قومش دور کرد که یکی باقی نماند. ");
INSERT INTO pesOPV_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","اما در این مرتبه نیز فرعون دل خود را سخت ساخته، قوم رارهایی نداد. ");
INSERT INTO pesOPV_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","و خداوند به موسی گفت: «نزد فرعون بروو به وی بگو: یهوه خدای عبرانیان چنین می‌گوید: قوم مرا رها کن تا مرا عبادت کنند. ");
INSERT INTO pesOPV_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","زیرا اگر تو از رهایی دادن ابا نمایی و ایشان را بازنگاه داری، ");
INSERT INTO pesOPV_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","همانا دست خداوند بر مواشی تو که در صحرایند خواهد شد، بر اسبان و الاغان وشتران و گاوان و گوسفندان، یعنی وبایی بسیارسخت. ");
INSERT INTO pesOPV_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","و خداوند در میان مواشی اسرائیلیان ومواشی مصریان فرقی خواهد گذاشت که از آنچه مال بنی‌اسرائیل است، چیزی نخواهد مرد.» ");
INSERT INTO pesOPV_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","وخداوند وقتی معین نموده، گفت: «فردا خداونداین کار را در این زمین خواهد کرد.» ");
INSERT INTO pesOPV_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","پس در فرداخداوند این کار را کرد و همه مواشی مصریان مردند و از مواشی بنی‌اسرائیل یکی هم نمرد. ");
INSERT INTO pesOPV_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","وفرعون فرستاد و اینک از مواشی اسرائیلیان یکی هم نمرده بود اما دل فرعون سخت شده، قوم رارهایی نداد. ");
INSERT INTO pesOPV_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","و خداوند به موسی و هارون گفت: «ازخاکستر کوره، مشتهای خود را پر کرده، برداریدو موسی آن را به حضور فرعون بسوی آسمان برافشاند، ");
INSERT INTO pesOPV_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","و غبار خواهد شد بر تمامی زمین مصر و سوزشی که دملها بیرون آورد بر انسان و بربهایم در تمامی زمین مصر خواهد شد.» ");
INSERT INTO pesOPV_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","پس ازخاکستر کوره گرفتند و به حضور فرعون ایستادندو موسی آن را بسوی آسمان پراکند، و سوزشی پدید شده، دملها بیرون آورد، در انسان و دربهایم. ");
INSERT INTO pesOPV_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","و جادوگران به‌سبب آن سوزش به حضور موسی نتوانستند ایستاد، زیرا که سوزش بر جادوگران و بر همه مصریان بود. ");
INSERT INTO pesOPV_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","و خداونددل فرعون را سخت ساخت که بدیشان گوش نگرفت، چنانکه خداوند به موسی گفته بود. ");
INSERT INTO pesOPV_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","و خداوند به موسی گفت: «بامدادان برخاسته، پیش روی فرعون بایست، و به وی بگو: یهوه خدای عبرانیان چنین می‌گوید: قوم مرا رهاکن تا مرا عبادت نمایند. ");
INSERT INTO pesOPV_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","زیرا در این دفعه تمامی بلایای خود را بر دل تو و بندگانت و قومت خواهم فرستاد، تا بدانی که در تمامی جهان مثل من نیست. ");
INSERT INTO pesOPV_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","زیرا اگر تاکنون دست خود را درازکرده، و تو را و قومت را به وبا مبتلا ساخته بودم، هرآینه از زمین هلاک می‌شدی. ");
INSERT INTO pesOPV_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","و لکن برای همین تو را برپا داشته‌ام تا قدرت خود را به تونشان دهم، و نام من در تمامی جهان شایع شود. ");
INSERT INTO pesOPV_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","و آیا تابحال خویشتن را بر قوم من برترمی سازی و ایشان را رهایی نمی دهی؟ ");
INSERT INTO pesOPV_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","همانا فردا این وقت، تگرگی بسیار سخت خواهم بارانید، که مثل آن در مصر از روز بنیانش تاکنون نشده است. ");
INSERT INTO pesOPV_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","پس الان بفرست و مواشی خود وآنچه را در صحرا داری جمع کن، زیرا که بر هرانسان و بهایمی که در صحرا یافته شوند، و به خانه‌ها جمع نشوند، تگرگ فرود خواهد آمد وخواهند مرد.» ");
INSERT INTO pesOPV_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","پس هر کس از بندگان فرعون که از قول خداوند ترسید، نوکران و مواشی خود را به خانه‌ها گریزانید. ");
INSERT INTO pesOPV_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","اما هر‌که دل خود را به کلام خداوند متوجه نساخت، نوکران و مواشی خود رادر صحرا واگذاشت. ");
INSERT INTO pesOPV_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","و خداوند به موسی گفت: «دست خود را به سوی آسمان دراز کن، تادر تمامی زمین مصر تگرگ بشود، بر انسان و بربهایم و بر همه نباتات صحرا، در کل ارض مصر.» ");
INSERT INTO pesOPV_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","پس موسی عصای خود را به سوی آسمان دراز کرد، و خداوند رعد و تگرگ داد، و آتش برزمین فرود آمد، و خداوند تگرگ بر زمین مصربارانید. ");
INSERT INTO pesOPV_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","و تگرگ آمد و آتشی که در میان تگرگ آمیخته بود، و به شدت سخت بود، که مثل آن درتمامی زمین مصر از زمانی که امت شده بودند، نبود. ");
INSERT INTO pesOPV_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","و در تمامی زمین مصر، تگرگ آنچه را که در صحرا بود، از انسان و بهایم زد. و تگرگ همه نباتات صحرا را زد، و جمیع درختان صحرا راشکست. ");
INSERT INTO pesOPV_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","فقط در زمین جوشن، جایی که بنی‌اسرائیل بودند، تگرگ نبود. ");
INSERT INTO pesOPV_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","آنگاه فرعون فرستاده، موسی و هارون راخواند، و بدیشان گفت: «در این مرتبه گناه کرده‌ام، خداوند عادل است و من و قوم من گناهکاریم. ");
INSERT INTO pesOPV_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","نزد خداوند دعا کنید، زیرا کافی است تا رعدهای خدا و تگرگ دیگر نشود، و شما را رهاخواهم کرد، و دیگر درنگ نخواهید نمود.» ");
INSERT INTO pesOPV_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","موسی به وی گفت: «چون از شهر بیرون روم، دستهای خود را نزد خداوند خواهم افراشت، تارعدها موقوف شود، و تگرگ دیگر نیاید، تا بدانی جهان از آن خداوند است. ");
INSERT INTO pesOPV_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","و اما تو و بندگانت، می‌دانم که تابحال از یهوه خدا نخواهید ترسید.» ");
INSERT INTO pesOPV_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","و کتان و جو زده شد، زیرا که جو خوشه آورده بود، و کتان تخم داشته. ");
INSERT INTO pesOPV_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","و اما گندم و خلر زده نشد زیرا که متاخر بود. ");
INSERT INTO pesOPV_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","و موسی از حضورفرعون از شهر بیرون شده، دستهای خود را نزدخداوند برافراشت، و رعدها و تگرگ موقوف شد، و باران بر زمین نبارید. ");
INSERT INTO pesOPV_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","و چون فرعون دیدکه باران و تگرگ و رعدها موقوف شد، باز گناه ورزیده، دل خود را سخت ساخت، هم او و هم بندگانش. ");
INSERT INTO pesOPV_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","پس دل فرعون سخت شده، بنی‌اسرائیل را رهایی نداد، چنانکه خداوند به‌دست موسی گفته بود. ");
INSERT INTO pesOPV_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","و خداوند به موسی گفت: «نزد فرعون برو زیرا که من دل فرعون و دل بندگانش را سخت کرده‌ام، تا این آیات خود را درمیان ایشان ظاهر سازم. ");
INSERT INTO pesOPV_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","و تا آنچه در مصر کردم و آیات خود را که در میان ایشان ظاهر ساختم، بگوش پسرت و پسر پسرت بازگویی تا بدانید که من یهوه هستم.» ");
INSERT INTO pesOPV_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","پس موسی و هارون نزد فرعون آمده، به وی گفتند: «یهوه خدای عبرانیان چنین می‌گوید: تا به کی از تواضع کردن به حضور من اباخواهی نمود؟ قوم مرا رها کن تا مرا عبادت کنند. ");
INSERT INTO pesOPV_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","زیرا اگر تو از رها کردن قوم من ابا کنی، هرآینه من فردا ملخها در حدود تو فرود آورم. ");
INSERT INTO pesOPV_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","که روی زمین را مستور خواهند ساخت، به حدی که زمین را نتوان دید، و تتمه آنچه رسته است که برای شمااز تگرگ باقی‌مانده، خواهند خورد، و هر درختی را که برای شما در صحرا روییده است، خواهندخورد. ");
INSERT INTO pesOPV_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","و خانه تو و خانه های بندگانت وخانه های همه مصریان را پر خواهند ساخت، به مرتبه‌ای که پدرانت و پدران پدرانت از روزی که بر زمین بوده‌اند تا الیوم ندیده‌اند.» پس روگردانیده، از حضور فرعون بیرون رفت. ");
INSERT INTO pesOPV_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","آنگاه بندگان فرعون به وی گفتند: «تا به کی برای ما این مرد دامی باشد؟ این مردمان را رها کن تا یهوه، خدای خود را عبادت نمایند. مگرتابحال ندانسته‌ای که مصر ویران شده است؟» ");
INSERT INTO pesOPV_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","پس موسی و هارون را نزد فرعون برگردانیدند، واو به ایشان گفت: «بروید و یهوه، خدای خود راعبادت کنید، لیکن کیستند که می‌روند؟» ");
INSERT INTO pesOPV_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","موسی گفت: «با جوانان و پیران خود خواهیم رفت، باپسران و دختران، و گوسفندان و گاوان خودخواهیم رفت، زیرا که ما را عیدی برای خداونداست.» ");
INSERT INTO pesOPV_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","بدیشان گفت: «خداوند با شما چنین باشد، اگر شما را با اطفال شما رهایی دهم با حذرباشید زیرا که بدی پیش روی شماست! ");
INSERT INTO pesOPV_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","نه چنین! بلکه شما که بالغ هستید رفته، خداوند راعبادت کنید، زیرا که این است آنچه خواسته بودید.» پس ایشان را از حضور فرعون بیرون راندند. ");
INSERT INTO pesOPV_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","و خداوند به موسی گفت: «دست خود رابرای ملخها بر زمین مصر دراز کن، تا بر زمین مصربرآیند، و همه نباتات زمین را که از تگرگ مانده است، بخورند.» ");
INSERT INTO pesOPV_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","پس موسی عصای خود را برزمین مصر دراز کرد، و خداوند تمامی آن روز، وتمامی آن شب را بادی شرقی بر زمین مصر وزانید، و چون صبح شد، باد شرقی ملخها راآورد. ");
INSERT INTO pesOPV_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","و ملخها بر تمامی زمین مصر برآمدند، ودر همه حدود مصر نشستند، بسیار سخت که قبل از آن چنین ملخها نبود، و بعد از آن نخواهد بود. ");
INSERT INTO pesOPV_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","و روی تمامی زمین را پوشانیدند، که زمین تاریک شد و همه نباتات زمین و همه میوه درختان را که از تگرگ باقی‌مانده بود، خوردند، به حدی که هیچ سبزی بر درخت، و نبات صحرا درتمامی زمین مصر نماند. ");
INSERT INTO pesOPV_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","آنگاه فرعون، موسی و هارون را به زودی خوانده، گفت: «به یهوه خدای شما و به شما گناه کرده‌ام. ");
INSERT INTO pesOPV_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","و اکنون این مرتبه فقط گناه مرا عفو فرمایید، و از یهوه خدای خود استدعا نمایید تا این موت را فقط از من برطرف نماید.» ");
INSERT INTO pesOPV_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","پس از حضور فرعون بیرون شده، از خداوند استدعا نمود. ");
INSERT INTO pesOPV_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","و خداوند بادغربی‌ای بسیار سخت برگردانید، که ملخها رابرداشته، آنها را به دریای قلزم ریخت، و درتمامی حدود مصر ملخی نماند. ");
INSERT INTO pesOPV_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","اما خداونددل فرعون را سخت گردانید، که بنی‌اسرائیل رارهایی نداد. ");
INSERT INTO pesOPV_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","و خداوند به موسی گفت: «دست خود را به سوی آسمان برافراز، تا تاریکی‌ای بر زمین مصرپدید آید، تاریکی‌ای که بتوان احساس کرد.» ");
INSERT INTO pesOPV_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","پس موسی دست خود را به سوی آسمان برافراشت، و تاریکی غلیظ تا سه روز در تمامی زمین مصر پدید آمد. ");
INSERT INTO pesOPV_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","و یکدیگر را نمی دیدند. و تا سه روز کسی از جای خود برنخاست، لیکن برای جمیع بنی‌اسرائیل در مسکنهای ایشان روشنایی بود. ");
INSERT INTO pesOPV_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","و فرعون موسی را خوانده، گفت: «بروید خداوند را عبادت کنید، فقط گله هاو رمه های شما بماند، اطفال شما نیز با شمابروند.» ");
INSERT INTO pesOPV_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","موسی گفت: «ذبایح و قربانی های سوختنی نیز می‌باید به‌دست ما بدهی، تا نزدیهوه، خدای خود بگذرانیم. ");
INSERT INTO pesOPV_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","مواشی ما نیز با ماخواهد آمد، یک سمی باقی نخواهد ماند زیرا که از اینها برای عبادت یهوه، خدای خود می‌بایدگرفت، و تا بدانجا نرسیم، نخواهیم دانست به چه چیز خداوند را عبادت کنیم.» ");
INSERT INTO pesOPV_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","و خداوند، دل فرعون را سخت گردانید که از رهایی دادن ایشان ابا نمود. ");
INSERT INTO pesOPV_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","پس فرعون وی را گفت: «از حضورمن برو! و با حذر باش که روی مرا دیگر نبینی، زیرا در روزی که مرا ببینی خواهی مرد.» ");
INSERT INTO pesOPV_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","موسی گفت: «نیکو گفتی، روی تو را دیگرنخواهم دید.» ");
INSERT INTO pesOPV_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","و خداوند به موسی گفت: «یک بلای دیگر بر فرعون و بر مصر می‌آورم، وبعد از آن شما را از اینجا رهایی خواهد داد، وچون شما را رها کند، البته شما را بالکلیه از اینجاخواهد راند. ");
INSERT INTO pesOPV_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","اکنون به گوش قوم بگو که هر مرداز همسایه خود، و هر زن از همسایه‌اش آلات نقره و آلات طلا بخواهند.» ");
INSERT INTO pesOPV_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","و خداوند قوم را درنظر مصریان محترم ساخت. و شخص موسی نیزدر زمین مصر، در نظر بندگان فرعون و در نظرقوم، بسیار بزرگ بود. ");
INSERT INTO pesOPV_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","و موسی گفت: «خداوندچنین می‌گوید: قریب به نصف شب در میان مصربیرون خواهم آمد. ");
INSERT INTO pesOPV_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","و هر نخست زاده‌ای که در زمین مصر باشد، از نخست زاده فرعون که برتختش نشسته است، تا نخست زاده کنیزی که درپشت دستاس باشد، و همه نخست زادگان بهایم خواهند مرد. ");
INSERT INTO pesOPV_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","و نعره عظیمی در تمامی زمین مصر خواهد بود که مثل آن نشده، و مانند آن دیگر نخواهد شد. ");
INSERT INTO pesOPV_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","اما بر جمیع بنی‌اسرائیل سگی زبان خود را تیز نکند، نه بر انسان و نه بربهایم، تا بدانید که خداوند در میان مصریان واسرائیلیان فرقی گذارده است. ");
INSERT INTO pesOPV_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","و این همه بندگان تو به نزد من فرود آمده، و مرا تعظیم کرده، خواهند گفت: تو و تمامی قوم که تابع تو باشند، بیرون روید! و بعد از آن بیرون خواهم رفت.» ");
INSERT INTO pesOPV_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","و خداوند به موسی گفت: «فرعون به شماگوش نخواهد گرفت، تا آیات من در زمین مصرزیاد شود.» ");
INSERT INTO pesOPV_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","و موسی و هارون جمیع این آیات را به حضور فرعون ظاهر ساختند. اما خداوند دل فرعون را سخت گردانید، و بنی‌اسرائیل را از زمین خود رهایی نداد. ");
INSERT INTO pesOPV_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","و خداوند موسی و هارون را در زمین مصر مخاطب ساخته، گفت: ");
INSERT INTO pesOPV_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","«این ماه برای شما سر ماهها باشد، این اول از ماههای سال برای شماست. ");
INSERT INTO pesOPV_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","تمامی جماعت اسرائیل راخطاب کرده، گویید که در دهم این ماه هر یکی ازایشان بره‌ای به حسب خانه های پدران خودبگیرند، یعنی برای هر خانه یک بره. ");
INSERT INTO pesOPV_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","و اگر اهل خانه برای بره کم باشند، آنگاه او و همسایه‌اش که مجاور خانه او باشد آن را به حسب شماره نفوس بگیرند، یعنی هر کس موافق خوراکش بره راحساب کند. ");
INSERT INTO pesOPV_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","بره شما بی‌عیب، نرینه یکساله باشد، از گوسفندان یا از بزها آن را بگیرید. ");
INSERT INTO pesOPV_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","و آن را تا چهاردهم این ماه نگاه دارید، و تمامی انجمن جماعت بنی‌اسرائیل آن را در عصر ذبح کنند. ");
INSERT INTO pesOPV_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","واز خون آن بگیرند، و آن را بر هر دو قایمه، وسردر خانه که در آن، آن را می‌خورند، بپاشند. ");
INSERT INTO pesOPV_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","وگوشتش را در آن شب بخورند. به آتش بریان کرده، با نان فطیر و سبزیهای تلخ آن را بخورند. ");
INSERT INTO pesOPV_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","و از آن هیچ خام نخورید، و نه پخته با آب، بلکه به آتش بریان شده، کله‌اش و پاچه هایش واندرونش را. ");
INSERT INTO pesOPV_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","و چیزی از آن تا صبح نگاه مدارید، و آنچه تا صبح مانده باشد به آتش بسوزانید. ");
INSERT INTO pesOPV_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","و آن را بدین طور بخورید: کمر شمابسته، و نعلین بر پایهای شما، و عصا در دست شما، و آن را به تعجیل بخورید، چونکه فصح خداوند است. ");
INSERT INTO pesOPV_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","«و در آن شب از زمین مصر عبور خواهم کرد، و همه نخست زادگان زمین مصر را از انسان وبهایم خواهم زد، و بر تمامی خدایان مصر داوری خواهم کرد. من یهوه هستم. ");
INSERT INTO pesOPV_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","و آن خون، علامتی برای شما خواهد بود، بر خانه هایی که درآنها می‌باشید، و چون خون را ببینم، از شماخواهم گذشت و هنگامی که زمین مصر را می‌زنم، آن بلا برای هلاک شما بر شما نخواهد آمد. ");
INSERT INTO pesOPV_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","وآن روز، شما را برای یادگاری خواهد بود، و درآن، عیدی برای خداوند نگاه دارید، و آن را به قانون ابدی، نسلا بعد نسل عید نگاه دارید. ");
INSERT INTO pesOPV_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","هفت روز نان فطیر خورید، در روز اول خمیرمایه را از خانه های خود بیرون کنید، زیرا هر‌که از روز نخستین تا روز هفتمین چیزی خمیرشده بخورد، آن شخص از اسرائیل منقطع گردد. ");
INSERT INTO pesOPV_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","و در روز اول، محفل مقدس، و در روز هفتم، محفل مقدس برای شما خواهد بود. در آنها هیچ کار کرده نشود جز آنچه هر کس باید بخورد؛ آن فقط در میان شما کرده شود. ");
INSERT INTO pesOPV_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","پس عید فطیر رانگاه دارید، زیرا که در همان روز لشکرهای شمارا از زمین مصر بیرون آوردم. بنابراین، این‌روز رادر نسلهای خود به فریضه ابدی نگاه دارید. ");
INSERT INTO pesOPV_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","درماه اول در روز چهاردهم ماه، در شام، نان فطیربخورید، تا شام بیست و یکم ماه. ");
INSERT INTO pesOPV_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","هفت روزخمیرمایه در خانه های شما یافت نشود، زیرا هرکه چیزی خمیر شده بخورد، آن شخص ازجماعت اسرائیل منقطع گردد، خواه غریب باشدخواه بومی آن زمین. ");
INSERT INTO pesOPV_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","هیچ‌چیز خمیر شده مخورید، در همه مساکن خود فطیر بخورید.» ");
INSERT INTO pesOPV_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","پس موسی جمیع مشایخ اسرائیل راخوانده، بدیشان گفت: «بروید و بره‌ای برای خودموافق خاندانهای خویش بگیرید، و فصح را ذبح نمایید. ");
INSERT INTO pesOPV_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","و دسته‌ای از زوفا گرفته، در خونی که در طشت است فروبرید، و بر سر در و دو قایمه آن، از خونی که در طشت است بزنید، و کسی ازشما از در خانه خود تا صبح بیرون نرود. ");
INSERT INTO pesOPV_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","زیراخداوند عبور خواهد کرد تا مصریان را بزند وچون خون را بر سردر و دو قایمه‌اش بیند، هماناخداوند از در گذرد و نگذارد که هلاک کننده به خانه های شما درآید تا شما را بزند. ");
INSERT INTO pesOPV_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","و این امررا برای خود و پسران خود به فریضه ابدی نگاه دارید. ");
INSERT INTO pesOPV_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","و هنگامی که داخل زمینی شدید که خداوند حسب قول خود، آن را به شما خواهدداد. آنگاه این عبادت را مرعی دارید. ");
INSERT INTO pesOPV_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","و چون پسران شما به شما گویند که این عبادت شماچیست، ");
INSERT INTO pesOPV_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","گویید این قربانی فصح خداوند است، که از خانه های بنی‌اسرائیل در مصر عبور کرد، وقتی که مصریان را زد و خانه های ما را خلاصی داد.» پس قوم به روی درافتاده، سجده کردند. ");
INSERT INTO pesOPV_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","پس بنی‌اسرائیل رفته، آن را کردند، چنانکه خداوند به موسی و هارون امر فرموده بودهمچنان کردند. ");
INSERT INTO pesOPV_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","و واقع شد که در نصف شب، خداوند همه نخست زادگان زمین مصر را، ازنخست زاده فرعون که بر تخت نشسته بود تانخست زاده اسیری که در زندان بود، و همه نخست زاده های بهایم را زد. ");
INSERT INTO pesOPV_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","و در آن شب فرعون و همه بندگانش وجمیع مصریان برخاستند و نعره عظیمی در مصربرپا شد، زیرا خانه‌ای نبود که در آن میتی نباشد. ");
INSERT INTO pesOPV_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","و موسی و هارون را در شب طلبیده، گفت: «برخیزید! و از میان قوم من بیرون شوید، هم شماو جمیع بنی‌اسرائیل! و رفته، خداوند را عبادت نمایید، چنانکه گفتید. ");
INSERT INTO pesOPV_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","گله‌ها و رمه های خود رانیز چنانکه گفتید، برداشته، بروید و مرا نیز برکت دهید.» ");
INSERT INTO pesOPV_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","و مصریان نیز بر قوم الحاح نمودند تاایشان را بزودی از زمین روانه کنند، زیرا گفتند ماهمه مرده‌ایم. ");
INSERT INTO pesOPV_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","و قوم، آرد سرشته خود را پیش از آنکه خمیر شود برداشتند، و تغارهای خویش را در رختها بر دوش خود بستند. ");
INSERT INTO pesOPV_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","و بنی‌اسرائیل به قول موسی عمل کرده، از مصریان آلات نقره و آلات طلا و رختها خواستند. ");
INSERT INTO pesOPV_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","وخداوند قوم را در نظر مصریان مکرم ساخت، که هرآنچه خواستند بدیشان دادند. پس مصریان راغارت کردند. ");
INSERT INTO pesOPV_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","و بنی‌اسرائیل از رعمسیس به سکوت کوچ کردند، قریب ششصدهزار مردپیاده، سوای اطفال. ");
INSERT INTO pesOPV_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","و گروهی مختلفه بسیار نیزهمراه ایشان بیرون رفتند، و گله‌ها و رمه‌ها ومواشی بسیار سنگین. ");
INSERT INTO pesOPV_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","و از آرد سرشته، که ازمصر بیرون آورده بودند، قرصهای فطیر پختند، زیرا خمیر نشده بود، چونکه از مصر رانده شده بودند، و نتوانستند درنگ کنند، و زاد سفر نیزبرای خود مهیا نکرده بودند. ");
INSERT INTO pesOPV_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","و توقف بنی‌اسرائیل که در مصر کرده بودند، چهارصد وسی سال بود. ");
INSERT INTO pesOPV_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","و بعد از انقضای چهار صد وسی سال در همان روز به وقوع پیوست که جمیع لشکرهای خدا از زمین مصر بیرون رفتند. ");
INSERT INTO pesOPV_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","این است شبی که برای خداوند باید نگاه داشت، چون ایشان را از زمین مصر بیرون آورد. این همان شب خداوند است که بر جمیع بنی‌اسرائیل نسلابعد نسل واجب است که آن را نگاه دارند. ");
INSERT INTO pesOPV_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","و خداوند به موسی و هارون گفت: «این است فریضه فصح که هیچ بیگانه از آن نخورد. ");
INSERT INTO pesOPV_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","و اما هر غلام زرخرید، او را ختنه کن و پس آن را بخورد. ");
INSERT INTO pesOPV_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","نزیل و مزدور آن را نخورند. ");
INSERT INTO pesOPV_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","دریک خانه خورده شود، و چیزی از گوشتش ازخانه بیرون مبر، و استخوانی از آن مشکنید. ");
INSERT INTO pesOPV_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","تمامی جماعت بنی‌اسرائیل آن را نگاه بدارند. ");
INSERT INTO pesOPV_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","و اگر غریبی نزد تو نزیل شود، و بخواهد فصح را برای خداوند مرعی بدارد، تمامی ذکورانش مختون شوند، و بعد از آن نزدیک آمده، آن را نگاه دارد، و مانند بومی زمین خواهد بود و اما هرنامختون از آن نخورد. ");
INSERT INTO pesOPV_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","یک قانون خواهد بودبرای اهل وطن و بجهت غریبی که در میان شمانزیل شود.» ");
INSERT INTO pesOPV_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","پس تمامی بنی‌اسرائیل این راکردند، چنانکه خداوند به موسی و هارون امرفرموده بود، عمل نمودند. ");
INSERT INTO pesOPV_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","و واقع شد که خداوند در همان روز بنی‌اسرائیل را با لشکرهای ایشان از زمین مصر بیرون آورد. ");
INSERT INTO pesOPV_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","و خداوند موسی را خطاب کرده، گفت: ");
INSERT INTO pesOPV_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","«هر نخست زاده‌ای را که رحم رابگشاید، در میان بنی‌اسرائیل، خواه از انسان خواه از بهایم، تقدیس نما؛ او از آن من است.» ");
INSERT INTO pesOPV_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","وموسی به قوم گفت: «این‌روز را که از مصر از خانه غلامی بیرون آمدید، یاد دارید، زیرا خداوندشما را به قوت دست، از آنجا بیرون آورد، پس نان خمیر، خورده نشود. ");
INSERT INTO pesOPV_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","این‌روز، در ماه ابیب بیرون آمدید. ");
INSERT INTO pesOPV_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","و هنگامی که خداوند تو را به زمین کنعانیان و حتیان و اموریان و حویان ویبوسیان داخل کند، که با پدران تو قسم خورد که آن را به تو بدهد، زمینی که به شیر و شهد جاری است، آنگاه این عبادت را در این ماه بجا بیاور. ");
INSERT INTO pesOPV_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","هفت روز نان فطیر بخور، و در روز هفتمین عیدخداوند است. ");
INSERT INTO pesOPV_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","هفت روز نان فطیر خورده شود، و هیچ‌چیز خمیر شده نزد تو دیده نشود، و خمیرمایه نزد تو در تمامی حدودت پیدا نشود. ");
INSERT INTO pesOPV_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","و در آن روز پسر خود را خبر داده، بگو: این است به‌سبب آنچه خداوند به من کرد، وقتی که از مصربیرون آمدم. ");
INSERT INTO pesOPV_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","و این برای تو علامتی بر دستت خواهد بود و تذکره‌ای در میان دو چشمت، تاشریعت خداوند در دهانت باشد. زیرا خداوند تورا به‌دست قوی از مصر بیرون آورد. ");
INSERT INTO pesOPV_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","و این فریضه را در موسمش سال به سال نگاه دار. ");
INSERT INTO pesOPV_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","«و هنگامی که خداوند تو را به زمین کنعانیان درآورد، چنانکه برای تو و پدرانت قسم خورد، و آن را به تو بخشد. ");
INSERT INTO pesOPV_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","آنگاه هر‌چه رحم را گشاید، آن را برای خدا جدا بساز، و هرنخست زاده‌ای از بچه های بهایم که از آن توست، نرینه‌ها از آن خداوند باشد. ");
INSERT INTO pesOPV_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","و هر نخست زاده الاغ را به بره‌ای فدیه بده، و اگر فدیه ندهی گردنش را بشکن، و هر نخست زاده انسان را ازپسرانت فدیه بده. ");
INSERT INTO pesOPV_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","و در زمان آینده چون پسرت از تو سوال کرده، گوید که این چیست، اورا بگو، یهوه ما را به قوت دست از مصر، از خانه غلامی بیرون آورد. ");
INSERT INTO pesOPV_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","و چون فرعون از رها کردن ما دل خود را سخت ساخت، واقع شد که خداوندجمیع نخست زادگان مصر را از نخست زاده انسان تا نخست زاده بهایم کشت. بنابراین من همه نرینه‌ها را که رحم را گشایند، برای خداوند ذبح می‌کنم، لیکن هر نخست زاده‌ای از پسران خود رافدیه می‌دهم. ");
INSERT INTO pesOPV_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","و این علامتی بر دستت وعصابه‌ای در میان چشمان تو خواهد بود، زیراخداوند ما را بقوت دست از مصر بیرون آورد.» ");
INSERT INTO pesOPV_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","و واقع شد که چون فرعون قوم را رها کرده بود، خدا ایشان را از راه زمین فلسطینیان رهبری نکرد، هرچند آن نزدیکتر بود. زیرا خدا گفت: «مبادا که چون قوم جنگ بینند، پشیمان شوند و به مصر برگردند.» ");
INSERT INTO pesOPV_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","اما خدا قوم را از راه صحرای دریای قلزم دور گردانید. پس بنی‌اسرائیل مسلح شده، از زمین مصر برآمدند. ");
INSERT INTO pesOPV_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","و موسی استخوانهای یوسف را با خود برداشت، زیرا که او بنی‌اسرائیل را قسم سخت داده، گفته بود: «هرآینه خدا از شما تفقد خواهد نمود واستخوانهای مرا از اینجا با خود خواهید برد.» ");
INSERT INTO pesOPV_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","و از سکوت کوچ کرده، در ایتام به کنار صحرااردو زدند. ");
INSERT INTO pesOPV_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","و خداوند در روز، پیش روی قوم در ستون ابر می‌رفت تا راه را به ایشان دلالت کند، و شبانگاه در ستون آتش، تا ایشان را روشنایی بخشد، و روز و شب راه روند. ");
INSERT INTO pesOPV_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","و ستون ابر را درروز و ستون آتش را در شب، از پیش روی قوم برنداشت. ");
INSERT INTO pesOPV_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","و خداوند موسی را خطاب کرده، گفت: ");
INSERT INTO pesOPV_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","«به بنی‌اسرائیل بگو که برگردیده، برابر فم الحیروت در میان مجدل ودریا اردو زنند. و در مقابل بعل صفون، در برابر آن به کنار دریا اردو زنید. ");
INSERT INTO pesOPV_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","و فرعون درباره بنی‌اسرائیل خواهد گفت: در زمین گرفتارشده‌اند، و صحرا آنها را محصور کرده است. ");
INSERT INTO pesOPV_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","ودل فرعون را سخت گردانم تا ایشان را تعاقب کند، و در فرعون و تمامی لشکرش جلال خود راجلوه دهم، تا مصریان بدانند که من یهوه هستم.» پس چنین کردند. ");
INSERT INTO pesOPV_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","و به پادشاه مصر گفته شد که قوم فرار کردند، و دل فرعون و بندگانش بر قوم متغیر شد، پس گفتند: «این چیست که کردیم که بنی‌اسرائیل را از بندگی خود رهایی دادیم؟» ");
INSERT INTO pesOPV_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","پس ارابه خود را بیاراست، و قوم خود را با خودبرداشت، ");
INSERT INTO pesOPV_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","و ششصد ارابه برگزیده برداشت، وهمه ارابه های مصر را و سرداران را بر جمیع آنها. ");
INSERT INTO pesOPV_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","و خداوند دل فرعون، پادشاه مصر را سخت ساخت تا بنی‌اسرائیل را تعاقب کرد، وبنی‌اسرائیل به‌دست بلند بیرون رفتند. ");
INSERT INTO pesOPV_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","و مصریان با تمامی اسبان و ارابه های فرعون و سوارانش و لشکرش در عقب ایشان تاخته، بدیشان دررسیدند، وقتی که به کنار دریا نزدفم الحیروت، برابر بعل صفون فرود آمده بودند. ");
INSERT INTO pesOPV_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","و چون فرعون نزدیک شد، بنی‌اسرائیل چشمان خود را بالا کرده، دیدند که اینک مصریان از عقب ایشان می‌آیند. پس بنی‌اسرائیل سخت بترسیدند، و نزد خداوند فریاد برآوردند. ");
INSERT INTO pesOPV_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","و به موسی گفتند: «آیا در مصر قبرها نبود که ما رابرداشته‌ای تا در صحرا بمیریم؟ این چیست به ماکردی که ما را از مصر بیرون آوردی؟ ");
INSERT INTO pesOPV_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","آیا این آن سخن نیست که به تو در مصر گفتیم که ما رابگذار تا مصریان را خدمت کنیم؟ زیرا که ما راخدمت مصریان بهتر است از مردن در صحرا!» ");
INSERT INTO pesOPV_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","موسی به قوم گفت: «مترسید. بایستید و نجات خداوند را ببینید، که امروز آن را برای شماخواهد کرد، زیرا مصریان را که امروز دیدید تا به ابد دیگر نخواهید دید. ");
INSERT INTO pesOPV_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","خداوند برای شماجنگ خواهد کرد و شما خاموش باشید.» ");
INSERT INTO pesOPV_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","و خداوند به موسی گفت: «چرا نزد من فریاد می‌کنی؟ بنی‌اسرائیل را بگو که کوچ کنند. ");
INSERT INTO pesOPV_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","و اما تو عصای خود را برافراز و دست خود رابر دریا دراز کرده، آن را منشق کن، تا بنی‌اسرائیل از میان دریا بر خشکی راه سپر شوند. ");
INSERT INTO pesOPV_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","و اما من اینک، دل مصریان را سخت می‌سازم، تا از عقب ایشان بیایند، و از فرعون و تمامی لشکر او وارابه‌ها و سوارانش جلال خواهم یافت. ");
INSERT INTO pesOPV_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","ومصریان خواهند دانست که من یهوه هستم، وقتی که از فرعون و ارابه هایش و سوارانش جلال یافته باشم.» ");
INSERT INTO pesOPV_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","و فرشته خدا که پیش اردوی اسرائیل می‌رفت، حرکت کرده، از عقب ایشان خرامید، وستون ابر از پیش ایشان نقل کرده، در عقب ایشان بایستاد. ");
INSERT INTO pesOPV_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","و میان اردوی مصریان و اردوی اسرائیل آمده، از برای آنها ابر و تاریکی می‌بود، واینها را در شب روشنایی می‌داد که تمامی شب نزدیک یکدیگر نیامدند. ");
INSERT INTO pesOPV_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","پس موسی دست خود را بر دریا دراز کرد و خداوند دریا را به بادشرقی شدید، تمامی آن شب برگردانیده، دریا راخشک ساخت و آب منشق گردید. ");
INSERT INTO pesOPV_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","وبنی‌اسرائیل در میان دریا بر خشکی می‌رفتند وآبها برای ایشان بر راست و چپ، دیوار بود. ");
INSERT INTO pesOPV_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","ومصریان با تمامی اسبان و ارابه‌ها و سواران فرعون از عقب ایشان تاخته، به میان دریا درآمدند. ");
INSERT INTO pesOPV_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","ودر پاس سحری واقع شد که خداوند بر اردوی مصریان از ستون آتش و ابر نظر انداخت، واردوی مصریان را آشفته کرد. ");
INSERT INTO pesOPV_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","و چرخهای ارابه های ایشان را بیرون کرد، تا آنها را به سنگینی برانند و مصریان گفتند: «از حضور بنی‌اسرائیل بگریزیم! زیرا خداوند برای ایشان با مصریان جنگ می‌کند.» ");
INSERT INTO pesOPV_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","و خداوند به موسی گفت: «دست خود را بردریا دراز کن، تا آبها بر مصریان برگردد، و برارابه‌ها و سواران ایشان.» ");
INSERT INTO pesOPV_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","پس موسی دست خود را بر دریا دراز کرد، و به وقت طلوع صبح، دریا به جریان خود برگشت، و مصریان به مقابلش گریختند، و خداوند مصریان را در میان دریا به زیر انداخت. ");
INSERT INTO pesOPV_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","و آبها برگشته، عرابه‌ها و سواران و تمام لشکر فرعون را که از عقب ایشان به دریادرآمده بودند، پوشانید، که یکی از ایشان هم باقی نماند. ");
INSERT INTO pesOPV_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","اما بنی‌اسرائیل در میان دریا به خشکی رفتند، و آبها برای ایشان دیواری بود به طرف راست و به طرف چپ. ");
INSERT INTO pesOPV_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","و در آن روز خداونداسرائیل را از دست مصریان خلاصی داد واسرائیل مصریان را به کنار دریا مرده دیدند. ");
INSERT INTO pesOPV_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","واسرائیل آن کار عظیمی را که خداوند به مصریان کرده بود دیدند، و قوم از خداوند ترسیدند، و به خداوند و به بنده او موسی ایمان آوردند. ");
INSERT INTO pesOPV_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","آنگاه موسی و بنی‌اسرائیل این سرودرا برای خداوند سراییده، گفتند که «یهوه را سرود می‌خوانم زیرا که با جلال مظفرشده است. اسب و سوارش را به دریا انداخت. ");
INSERT INTO pesOPV_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","خداوند قوت و تسبیح من است. و او نجات من گردیده است. این خدای من است، پس او را تمجید می‌کنم. خدای پدر من است، پس او را متعال می‌خوانم. ");
INSERT INTO pesOPV_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","خداوند مرد جنگی است. نام او یهوه است. ");
INSERT INTO pesOPV_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","ارابه‌ها و لشکر فرعون را به دریا انداخت. مبارزان برگزیده او در دریای قلزم غرق شدند. ");
INSERT INTO pesOPV_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","لجه‌ها ایشان را پوشانید. مثل سنگ به ژرفیها فرو رفتند. ");
INSERT INTO pesOPV_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","دست راست تو‌ای خداوند، به قوت جلیل گردیده. دست راست تو‌ای خداوند، دشمن را خردشکسته است. ");
INSERT INTO pesOPV_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","و به کثرت جلال خود خصمان را منهدم ساخته‌ای. غضب خود را فرستاده، ایشان را چون خاشاک سوزانیده‌ای. ");
INSERT INTO pesOPV_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","و به نفخه بینی تو آبها فراهم گردید. و موجها مثل توده بایستاد و لجه‌ها در میان دریامنجمد گردید. ");
INSERT INTO pesOPV_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","دشمن گفت تعاقب می‌کنم و ایشان را فرومی گیرم. و غارت را تقسیم کرده، جانم از ایشان سیرخواهد شد. شمشیر خود را کشیده، دست من ایشان را هلاک خواهد ساخت. ");
INSERT INTO pesOPV_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","و چون به نفخه خود دمیدی، دریا ایشان راپوشانید. ");
INSERT INTO pesOPV_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","کیست مانند تو‌ای خداوند در میان خدایان؟ کیست مانند تو جلیل در قدوسیت؟ ");
INSERT INTO pesOPV_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","چون دست راست خود را دراز کردی، زمین ایشان را فرو برد. ");
INSERT INTO pesOPV_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","این قوم خویش را که فدیه دادی، به رحمانیت خود، رهبری نمودی. ایشان را به قوت خویش به سوی مسکن قدس خود هدایت کردی. ");
INSERT INTO pesOPV_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","امتها چون شنیدند، مضطرب گردیدند. لرزه بر سکنه فلسطین مستولی گردید. ");
INSERT INTO pesOPV_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","آنگاه امرای ادوم در حیرت افتادند. و اکابر موآب را لرزه فرو گرفت، و جمیع سکنه کنعان گداخته گردیدند. ");
INSERT INTO pesOPV_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","ترس و هراس، ایشان را فروگرفت. از بزرگی بازوی تو مثل سنگ ساکت شدند. تا قوم تو‌ای خداوند عبور کنند. تا این قومی که تو خریده‌ای، عبور کنند. ");
INSERT INTO pesOPV_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","ایشان را داخل ساخته، در جبل میراث خودغرس خواهی کرد، به مکانی که تو‌ای خداوندمسکن خود ساخته‌ای، یعنی آن مقام مقدسی که دستهای تو‌ای خداوند مستحکم کرده است. ");
INSERT INTO pesOPV_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","خداوند سلطنت خواهد کرد تا ابدالاباد.» ");
INSERT INTO pesOPV_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","زیرا که اسبهای فرعون با ارابه‌ها وسوارانش به دریا درآمدند، و خداوند آب دریا رابر ایشان برگردانید. اما بنی‌اسرائیل از میان دریا به خشکی رفتند. ");
INSERT INTO pesOPV_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","و مریم نبیه، خواهر هارون، دف را به‌دست خود گرفته، و همه زنان از عقب وی دفها گرفته، رقص‌کنان بیرون آمدند. ");
INSERT INTO pesOPV_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","پس مریم در جواب ایشان گفت: «خداوند را بسرایید، زیرا که با جلال مظفر شده است، اسب و سوارش را به دریاانداخت.» ");
INSERT INTO pesOPV_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","پس موسی اسرائیل را از بحر قلزم کوچانید، و به صحرای شور آمدند، و سه روز درصحرا می‌رفتند و آب نیافتند. ");
INSERT INTO pesOPV_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","پس به ماره رسیدند، و از آب ماره نتوانستند نوشید زیرا که تلخ بود. از این سبب، آن را ماره نامیدند. ");
INSERT INTO pesOPV_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","و قوم بر موسی شکایت کرده، گفتند: «چه بنوشیم؟» ");
INSERT INTO pesOPV_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","چون نزد خداوند استغاثه کرد، خداونددرختی بدو نشان داد، پس آن را به آب انداخت وآب شیرین گردید. و در آنجا فریضه‌ای وشریعتی برای ایشان قرار داد، و در آنجا ایشان راامتحان کرد. ");
INSERT INTO pesOPV_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","و گفت: «هرآینه اگر قول یهوه، خدای خود را بشنوی، و آنچه را در نظر او راست است بجا آوری، و احکام او را بشنوی، و تمامی فرایض او را نگاه داری، همانا هیچ‌یک از همه مرضهایی را که بر مصریان آورده‌ام بر تو نیاورم، زیرا که من یهوه، شفا دهنده تو هستم.» ");
INSERT INTO pesOPV_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","پس به ایلیم آمدند، و در آنجا دوازده چشمه آب و هفتاددرخت خرما بود، و در آنجا نزد آب خیمه زدند. ");
INSERT INTO pesOPV_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","پس تمامی جماعت بنی‌اسرائیل ازایلیم کوچ کرده، به صحرای سین که درمیان ایلیم و سینا است در روز پانزدهم از ماه دوم، بعد از بیرون آمدن ایشان از زمین مصر، رسیدند. ");
INSERT INTO pesOPV_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","و تمامی جماعت بنی‌اسرائیل در آن صحرا برموسی و هارون شکایت کردند. ");
INSERT INTO pesOPV_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","و بنی‌اسرائیل بدیشان گفتند: «کاش که در زمین مصر به‌دست خداوند مرده بودیم، وقتی که نزد دیگهای گوشت می‌نشستیم و نان را سیر می‌خوردیم، زیراکه ما را بدین صحرا بیرون آوردید، تا تمامی این جماعت را به گرسنگی بکشید.» ");
INSERT INTO pesOPV_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","آنگاه خداوند به موسی گفت: «همانا من نان از آسمان برای شما بارانم، و قوم رفته، کفایت هرروز را در روزش گیرند، تا ایشان را امتحان کنم که بر شریعت من رفتار می‌کنند یا نه. ");
INSERT INTO pesOPV_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","و واقع خواهد شد در روز ششم، که چون آنچه را که آورده باشند درست نمایند، همانا دوچندان آن خواهدبود که هر روز برمی چیدند.» ");
INSERT INTO pesOPV_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","و موسی و هارون به همه بنی‌اسرائیل گفتند: «شامگاهان خواهیددانست که خداوند شما را از زمین مصر بیرون آورده است. ");
INSERT INTO pesOPV_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","و بامدادان جلال خداوند راخواهید دید، زیرا که او شکایتی را که بر خداوندکرده‌اید شنیده است، و ما چیستیم که بر ماشکایت می‌کنید؟» ");
INSERT INTO pesOPV_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","و موسی گفت: «این خواهدبود چون خداوند، شامگاه شما را گوشت دهد تابخورید، و بامداد نان، تا سیر شوید، زیرا خداوندشکایتهای شما را که بر وی کرده‌اید شنیده است، و ما چیستیم؟ بر ما نی، بلکه بر خداوند شکایت نموده‌اید.» ");
INSERT INTO pesOPV_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","و موسی به هارون گفت: «به تمامی جماعت بنی‌اسرائیل بگو به حضور خداوندنزدیک بیایید، زیرا که شکایتهای شما را شنیده است.» ");
INSERT INTO pesOPV_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","و واقع شد که چون هارون به تمامی جماعت بنی‌اسرائیل سخن گفت، به سوی صحرانگریستند و اینک جلال خداوند در ابر ظاهر شد. ");
INSERT INTO pesOPV_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","و خداوند موسی را خطاب کرده، گفت: ");
INSERT INTO pesOPV_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","«شکایتهای بنی‌اسرائیل را شنیده‌ام، پس ایشان را خطاب کرده، بگو: در عصر گوشت خواهید خورد، و بامداد از نان سیر خواهید شد تابدانید که من یهوه خدای شما هستم.» ");
INSERT INTO pesOPV_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","و واقع شد که در عصر، سلوی برآمده، لشکرگاه راپوشانیدند، و بامدادان شبنم گرداگرد اردونشست. ");
INSERT INTO pesOPV_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","و چون شبنمی که نشسته بودبرخاست، اینک بر روی صحرا چیزی دقیق، مدور و خرد، مثل ژاله بر زمین بود. ");
INSERT INTO pesOPV_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","و چون بنی‌اسرائیل این را دیدند به یکدیگر گفتند که این من است، زیرا که ندانستند چه بود. موسی به ایشان گفت: «این آن نان است که خداوند به شمامی دهد تا بخورید. ");
INSERT INTO pesOPV_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","این است امری که خداوندفرموده است، که هر کس به قدر خوراک خود ازاین بگیرد، یعنی یک عومر برای هر نفر به حسب شماره نفوس خویش، هر شخص برای کسانی که در خیمه او باشند بگیرد.» ");
INSERT INTO pesOPV_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","پس بنی‌اسرائیل چنین کردند، بعضی زیاد و بعضی کم برچیدند. ");
INSERT INTO pesOPV_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","اما چون به عومر پیمودند، آنکه زیاد برچیده بود، زیاده نداشت، و آنکه کم برچیده بود، کم نداشت، بلکه هر کس به قدر خوراکش برچیده بود. ");
INSERT INTO pesOPV_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","و موسی بدیشان گفت: «زنهار کسی چیزی از این تا صبح نگاه ندارد.» ");
INSERT INTO pesOPV_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","لکن به موسی گوش ندادند، بلکه بعضی چیزی از آن تا صبح نگاه داشتند. و کرمها بهم رسانیده، متعفن گردید، و موسی بدیشان خشمناک شد. ");
INSERT INTO pesOPV_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","و هر صبح، هر کس به قدر خوراک خودبرمی چید، و چون آفتاب گرم می‌شد، می‌گداخت. ");
INSERT INTO pesOPV_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","و واقع شد در روز ششم که نان مضاعف، یعنی برای هر نفری دو عومر برچیدند. پس همه روسای جماعت آمده، موسی را خبردادند. ");
INSERT INTO pesOPV_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","او بدیشان گفت: «این است آنچه خداوند گفت، که فردا آرامی است، و سبت مقدس خداوند. پس آنچه بر آتش باید پخت بپزید، و آنچه در آب باید جوشانید بجوشانید، وآنچه باقی باشد، برای خود ذخیره کرده، بجهت صبح نگاه دارید.» ");
INSERT INTO pesOPV_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","پس آن را تا صبح ذخیره کردند، چنانکه موسی فرموده بود، و نه متعفن گردید و نه کرم در آن پیدا شد. ");
INSERT INTO pesOPV_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","و موسی گفت: «امروز این را بخورید زیرا که امروز سبت خداوند است، و در این‌روز آن را در صحرانخواهید یافت. ");
INSERT INTO pesOPV_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","شش روز آن را برچینید، وروز هفتمین، سبت است. در آن نخواهد بود.» ");
INSERT INTO pesOPV_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","و واقع شد که در روز هفتم، بعضی از قوم برای برچیدن بیرون رفتند، اما نیافتند. ");
INSERT INTO pesOPV_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","و خداوند به موسی گفت: «تا به کی از نگاه داشتن وصایا وشریعت من ابا می‌نمایید؟ ");
INSERT INTO pesOPV_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","ببینید چونکه خداوند سبت را به شما بخشیده است، از این سبب در روز ششم، نان دو روز را به شما می‌دهد، پس هر کس در جای خود بنشیند و در روز هفتم هیچ‌کس از مکانش بیرون نرود.» ");
INSERT INTO pesOPV_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","پس قوم درروز هفتمین آرام گرفتند. ");
INSERT INTO pesOPV_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","و خاندان اسرائیل آن را من نامیدند، و آن مثل تخم گشنیز سفید بود، و طعمش مثل قرصهای عسلی. ");
INSERT INTO pesOPV_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","و موسی گفت: «این امری است که خداوند فرموده است که عومری از آن پرکنی، تا در نسلهای شما نگاه داشته شود، تا آن نان را ببینند که در صحرا، وقتی که شما را از زمین مصر بیرون آوردم، آن را به شما خورانیدم.» ");
INSERT INTO pesOPV_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","پس موسی به هارون گفت: «ظرفی بگیر، وعومری پر از من در آن بنه و آن را به حضورخداوند بگذار، تا در نسلهای شما نگاه داشته شود.» ");
INSERT INTO pesOPV_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","چنانکه خداوند به موسی‌امر فرموده بود، همچنان هارون آن را پیش (تابوت ) شهادت گذاشت تا نگاه داشته شود. ");
INSERT INTO pesOPV_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","و بنی‌اسرائیل مدت چهل سال من را می‌خوردند، تا به زمین آبادرسیدند، یعنی تا به‌سرحد زمین کنعان داخل شدند، خوراک ایشان من بود. ");
INSERT INTO pesOPV_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","و اما عومر، ده‌یک ایفه است. ");
INSERT INTO pesOPV_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","و تمامی جماعت بنی‌اسرائیل به حکم خداوند طی منازل کرده، ازصحرای سین کوچ کردند، و در رفیدیم اردوزدند، و آب نوشیدن برای قوم نبود. ");
INSERT INTO pesOPV_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","و قوم باموسی منازعه کرده، گفتند: «ما را آب بدهید تابنوشیم.» موسی بدیشان گفت: «چرا با من منازعه می‌کنید، و چرا خداوند را امتحان می‌نمایید؟» ");
INSERT INTO pesOPV_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","ودر آنجا قوم تشنه آب بودند، و قوم بر موسی شکایت کرده، گفتند: «چرا ما را از مصر بیرون آوردی، تا ما و فرزندان و مواشی ما را به تشنگی بکشی؟» ");
INSERT INTO pesOPV_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","آنگاه موسی نزد خداوند استغاثه نموده، گفت: «با این قوم چه کنم؟ نزدیک است مرا سنگسار کنند.» ");
INSERT INTO pesOPV_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","خداوند به موسی گفت: «پیش روی قوم برو، و بعضی از مشایخ اسرائیل را با خود بردار، و عصای خود را که بدان نهر رازدی به‌دست خود گرفته، برو. ");
INSERT INTO pesOPV_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","همانا من در آنجاپیش روی تو بر آن صخره‌ای که در حوریب است، می‌ایستم، و صخره را خواهی زد تا آب ازآن بیرون آید، و قوم بنوشند.» پس موسی به حضور مشایخ اسرائیل چنین کرد. ");
INSERT INTO pesOPV_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","و آن موضع را مسه و مریبه نامید، به‌سبب منازعه بنی‌اسرائیل، و امتحان کردن ایشان خداوند را، زیرا گفته بودند: «آیا خداوند در میان ما هست یانه؟» ");
INSERT INTO pesOPV_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","پس عمالیق آمده، در رفیدیم با اسرائیل جنگ کردند. ");
INSERT INTO pesOPV_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","و موسی به یوشع گفت: «مردان برای ما برگزین و بیرون رفته، با عمالیق مقابله نما، و بامدادان من عصای خدا را به‌دست گرفته، بر قله کوه خواهم ایستاد.» ");
INSERT INTO pesOPV_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","پس یوشع بطوری که موسی او را امر فرموده بود کرد، تا با عمالیق محاربه کند. و موسی و هارون و حور بر قله کوه برآمدند. ");
INSERT INTO pesOPV_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","و واقع شد که چون موسی دست خود را برمی افراشت، اسرائیل غلبه می‌یافتند وچون دست خود را فرو می‌گذاشت، عمالیق چیره می‌شدند. ");
INSERT INTO pesOPV_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","و دستهای موسی سنگین شد. پس ایشان سنگی گرفته، زیرش نهادند که بر آن بنشیند. و هارون و حور، یکی از این طرف ودیگری از آن طرف، دستهای او را بر می‌داشتند، و دستهایش تا غروب آفتاب برقرار ماند. ");
INSERT INTO pesOPV_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","ویوشع، عمالیق و قوم او را به دم شمشیر منهزم ساخت. ");
INSERT INTO pesOPV_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","پس خداوند به موسی گفت: «این رابرای یادگاری در کتاب بنویس، و به سمع یوشع برسان که هرآینه ذکر عمالیق را از زیر آسمان محو خواهم ساخت.» ");
INSERT INTO pesOPV_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","و موسی مذبحی بنا کردو آن را یهوه نسی نامید. ");
INSERT INTO pesOPV_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","و گفت: «زیرا که دست بر تخت خداوند است، که خداوند را جنگ باعمالیق نسلا بعد نسل خواهد بود.» ");
INSERT INTO pesOPV_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","و چون یترون، کاهن مدیان، پدر زن موسی، آنچه را که خدا با موسی و قوم خود، اسرائیل کرده بود شنید که خداوند چگونه اسرائیل را از مصر بیرون آورده بود، ");
INSERT INTO pesOPV_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","آنگاه یترون پدرزن موسی، صفوره، زن موسی رابرداشت، بعد از آنکه او را پس فرستاده بود. ");
INSERT INTO pesOPV_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","ودو پسر او را که یکی را جرشون نام بود، زیراگفت: «در زمین بیگانه غریب هستم.» ");
INSERT INTO pesOPV_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","و دیگری را الیعازر نام بود، زیرا گفت: «که خدای پدرم مددکار من بوده، مرا از شمشیر فرعون رهانید.» ");
INSERT INTO pesOPV_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","پس یترون، پدر زن موسی، با پسران وزوجه‌اش نزد موسی به صحرا آمدند، در جایی که او نزد کوه خدا خیمه زده بود. ");
INSERT INTO pesOPV_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","و به موسی خبر داد که من یترون، پدر زن تو با زن تو و دوپسرش نزد تو آمده‌ایم. ");
INSERT INTO pesOPV_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","پس موسی به استقبال پدر زن خود بیرون آمد و او را تعظیم کرده، بوسیدو سلامتی یکدیگر را پرسیده، به خیمه درآمدند. ");
INSERT INTO pesOPV_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","و موسی پدر زن خود را از آنچه خداوند به فرعون و مصریان به‌خاطر اسرائیل کرده بود خبرداد، و از تمامی مشقتی که در راه بدیشان واقع شده، خداوند ایشان را از آن رهانیده بود. ");
INSERT INTO pesOPV_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","ویترون شاد گردید، به‌سبب تمامی احسانی که خداوند به اسرائیل کرده، و ایشان را از دست مصریان رهانیده بود. ");
INSERT INTO pesOPV_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","و یترون گفت: «متبارک است خداوند که شما را از دست مصریان و ازدست فرعون خلاصی داده است، و قوم خود را ازدست مصریان رهانیده. ");
INSERT INTO pesOPV_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","الان دانستم که یهوه ازجمیع خدایان بزرگتر است، خصوص در همان امری که بر ایشان تکبر می‌کردند.» ");
INSERT INTO pesOPV_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","و یترون، پدر زن موسی، قربانی سوختنی و ذبایح برای خدا گرفت، و هارون و جمیع مشایخ اسرائیل آمدند تا با پدر زن موسی به حضور خدا نان بخورند. ");
INSERT INTO pesOPV_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","بامدادان واقع شد که موسی برای داوری قوم بنشست، و قوم به حضور موسی از صبح تاشام ایستاده بودند. ");
INSERT INTO pesOPV_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","و چون پدر زن موسی آنچه را که او به قوم می‌کرد دید، گفت: «این چه‌کاراست که تو با قوم می‌نمایی؟ چرا تو تنها می نشینی و تمامی قوم نزد تو از صبح تا شام می‌ایستند؟» ");
INSERT INTO pesOPV_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","موسی به پدر زن خود گفت که «قوم نزد من می‌آیند تا از خدا مسالت نمایند. ");
INSERT INTO pesOPV_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","هرگاه ایشان را دعوی شود، نزد من می‌آیند، ومیان هر کس و همسایه‌اش داوری می‌کنم، وفرایض و شرایع خدا را بدیشان تعلیم می‌دهم.» ");
INSERT INTO pesOPV_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","پدر زن موسی به وی گفت: «کاری که تومی کنی، خوب نیست. ");
INSERT INTO pesOPV_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","هرآینه تو و این قوم نیزکه با تو هستند، خسته خواهید شد، زیرا که این امر برای تو سنگین است. تنها این را نمی توانی کرد. ");
INSERT INTO pesOPV_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","اکنون سخن مرا بشنو. تو را پند می‌دهم. وخدا با تو باد. و تو برای قوم به حضور خدا باش، وامور ایشان را نزد خدا عرضه دار. ");
INSERT INTO pesOPV_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","و فرایض وشرایع را بدیشان تعلیم ده، و طریقی را که بدان می‌باید رفتار نمود، و عملی را که می‌باید کرد، بدیشان اعلام نما. ");
INSERT INTO pesOPV_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","و از میان تمامی قوم، مردان قابل را که خداترس و مردان امین، که از رشوت نفرت کنند، جستجو کرده، بر ایشان بگمار، تاروسای هزاره و روسای صده و روسای پنجاه وروسای ده باشند. ");
INSERT INTO pesOPV_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","تا بر قوم پیوسته داوری نمایند، و هر امر بزرگ را نزد تو بیاورند، و هر امرکوچک را خود فیصل دهند. بدین طور بار خود راسبک خواهی کرد، و ایشان با تو متحمل آن خواهند شد. ");
INSERT INTO pesOPV_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","اگر این کار را بکنی و خدا تو راچنین امر فرماید، آنگاه یارای استقامت خواهی داشت، و جمیع این قوم نیز به مکان خود به سلامتی خواهند رسید.» ");
INSERT INTO pesOPV_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","پس موسی سخن پدر زن خود را اجابت کرده، آنچه او گفته بود به عمل آورد. ");
INSERT INTO pesOPV_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","و موسی مردان قابل از تمامی اسرائیل انتخاب کرده، ایشان را روسای قوم ساخت، روسای هزاره وروسای صده و روسای پنجاه و روسای ده. ");
INSERT INTO pesOPV_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","ودر داوری قوم پیوسته مشغول می‌بودند. هر امرمشکل را نزد موسی می‌آوردند، و هر دعوی کوچک را خود فیصل می‌دادند. ");
INSERT INTO pesOPV_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","و موسی پدرزن خود را رخصت داد و او به ولایت خود رفت. ");
INSERT INTO pesOPV_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","و در ماه سوم از بیرون آمدن بنی‌اسرائیل از زمین مصر، در همان روزبه صحرای سینا آمدند، ");
INSERT INTO pesOPV_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","و از رفیدیم کوچ کرده، به صحرای سینا رسیدند، و در بیابان اردو زدند، واسرائیل در آنجا در مقابل کوه فرود آمدند. ");
INSERT INTO pesOPV_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","وموسی نزد خدا بالا رفت، و خداوند از میان کوه اورا ندا درداد و گفت: «به خاندان یعقوب چنین بگو، و بنی‌اسرائیل را خبر بده: ");
INSERT INTO pesOPV_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","شما آنچه را که من به مصریان کردم، دیده‌اید، و چگونه شما را بربالهای عقاب برداشته، نزد خود آورده‌ام. ");
INSERT INTO pesOPV_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","واکنون اگر آواز مرا فی الحقیقه بشنوید، و عهد مرانگاه دارید، همانا خزانه خاص من از جمیع قومهاخواهید بود. زیرا که تمامی جهان، از آن من است. ");
INSERT INTO pesOPV_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","و شما برای من مملکت کهنه و امت مقدس خواهید بود. این است آن سخنانی که به بنی‌اسرائیل می‌باید گفت.» ");
INSERT INTO pesOPV_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","پس موسی آمده، مشایخ قوم را خواند، و همه این سخنان را که خداوند او را فرموده بود، بر ایشان القا کرد. ");
INSERT INTO pesOPV_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","وتمامی قوم به یک زبان در جواب گفتند: «آنچه خداوند امر فرموده است، خواهیم کرد.» و موسی سخنان قوم را باز به خداوند عرض کرد. ");
INSERT INTO pesOPV_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","و خداوند به موسی گفت: «اینک من در ابرمظلم نزد تو می‌آیم، تا هنگامی که به تو سخن گویم قوم بشنوند، و بر تو نیز همیشه ایمان داشته باشند.» پس موسی سخنان قوم را به خداوند بازگفت. ");
INSERT INTO pesOPV_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","خداوند به موسی گفت: «نزد قوم برو وایشان را امروز و فردا تقدیس نما، و ایشان رخت خود را بشویند. ");
INSERT INTO pesOPV_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","و در روز سوم مهیا باشید، زیرا که در روز سوم خداوند در نظر تمامی قوم برکوه سینا نازل شود. ");
INSERT INTO pesOPV_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","و حدود برای قوم از هرطرف قرار ده، و بگو: باحذر باشید از اینکه به فرازکوه برآیید، یا دامنه آن را لمس نمایید، زیرا هر‌که کوه را لمس کند، هرآینه کشته شود. ");
INSERT INTO pesOPV_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","دست برآن گذارده نشود بلکه یا سنگسار شود یا به تیرکشته شود، خواه بهایم باشد خواه انسان، زنده نماند. اما چون کرنا نواخته شود، ایشان به کوه برآیند.» ");
INSERT INTO pesOPV_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","پس موسی از کوه نزد قوم فرود آمده، قوم را تقدیس نمود و رخت خود را شستند. ");
INSERT INTO pesOPV_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","و به قوم گفت: «در روز سوم حاضر باشید، و به زنان نزدیکی منمایید.» ");
INSERT INTO pesOPV_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","و واقع شد در روز سوم به وقت طلوع صبح، که رعدها و برقها و ابر غلیظ برکوه پدید آمد، و آواز کرنای بسیار سخت، بطوری که تمامی قوم که در لشکرگاه بودند، بلرزیدند. ");
INSERT INTO pesOPV_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","و موسی قوم را برای ملاقات خدا ازلشکرگاه بیرون آورد، و در پایان کوه ایستادند. ");
INSERT INTO pesOPV_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","و تمامی کوه سینا را دود فرو گرفت، زیراخداوند در آتش بر آن نزول کرد، و دودش مثل دود کوره‌ای بالا می‌شد، و تمامی کوه سخت متزلزل گردید. ");
INSERT INTO pesOPV_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","و چون آواز کرنا زیاده و زیاده سخت نواخته می‌شد، موسی سخن گفت، و خدا او را به زبان جواب داد. ");
INSERT INTO pesOPV_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","و خداوند بر کوه سینا بر قله کوه نازل شد، و خداوند موسی را به قله کوه خواند، و موسی بالا رفت. ");
INSERT INTO pesOPV_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","و خداوند به موسی گفت: «پایین برو و قوم را قدغن نما، مبادا نزدخداوند برای نظر کردن، از حد تجاوز نمایند، که بسیاری از ایشان هلاک خواهند شد. ");
INSERT INTO pesOPV_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","و کهنه نیز که نزد خداوند می‌آیند، خویشتن را تقدیس نمایند، مبادا خداوند بر ایشان هجوم آورد.» ");
INSERT INTO pesOPV_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","موسی به خداوند گفت: «قوم نمی توانند به فرازکوه سینا آیند، زیرا که تو ما را قدغن کرده، گفته‌ای کوه را حدود قرار ده و آن را تقدیس نما.» ");
INSERT INTO pesOPV_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","خداوند وی را گفت: «پایین برو و تو و هارون همراهت برآیید، اما کهنه و قوم از حد تجاوزننمایند، تا نزد خداوند بالا بیایند، مبادا بر ایشان هجوم آورد.» ");
INSERT INTO pesOPV_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","پس موسی نزد قوم فرود شده، بدیشان سخن گفت. ");
INSERT INTO pesOPV_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","و خدا تکلم فرمود و همه این کلمات را بگفت: ");
INSERT INTO pesOPV_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","«من هستم یهوه، خدای تو، که تو را از زمین مصر و از خانه غلامی بیرون آوردم. ");
INSERT INTO pesOPV_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","تو را خدایان دیگر غیر از من نباشد. ");
INSERT INTO pesOPV_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","صورتی تراشیده و هیچ تمثالی از آنچه بالا درآسمان است، و از آنچه پایین در زمین است، و ازآنچه در آب زیر زمین است، برای خود مساز. ");
INSERT INTO pesOPV_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","نزد آنها سجده مکن، و آنها را عبادت منما، زیرامن که یهوه، خدای تو می‌باشم، خدای غیورهستم، که انتقام گناه پدران را از پسران تا پشت سوم و چهارم از آنانی که مرا دشمن دارندمی گیرم. ");
INSERT INTO pesOPV_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","و تا هزار پشت بر آنانی که مرا دوست دارند و احکام مرا نگاه دارند، رحمت می‌کنم. ");
INSERT INTO pesOPV_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","نام یهوه، خدای خود را به باطل مبر، زیراخداوند کسی را که اسم او را به باطل برد، بی‌گناه نخواهد شمرد. ");
INSERT INTO pesOPV_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","روز سبت را یاد کن تا آن راتقدیس نمایی. ");
INSERT INTO pesOPV_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","شش روز مشغول باش و همه کارهای خود را بجا آور. ");
INSERT INTO pesOPV_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","اما روز هفتمین، سبت یهوه، خدای توست. در آن هیچ کار مکن، تو و پسرت و دخترت و غلامت و کنیزت وبهیمه ات و مهمان تو که درون دروازه های توباشد. ");
INSERT INTO pesOPV_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","زیرا که در شش روز، خداوند آسمان وزمین و دریا و آنچه را که در آنهاست بساخت، ودر روز هفتم آرام فرمود. از این سبب خداوند روزهفتم را مبارک خوانده، آن را تقدیس نمود. ");
INSERT INTO pesOPV_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","پدر و مادر خود را احترام نما، تا روزهای تو درزمینی که یهوه خدایت به تو می‌بخشد، درازشود. ");
INSERT INTO pesOPV_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","قتل مکن. ");
INSERT INTO pesOPV_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","زنا مکن. ");
INSERT INTO pesOPV_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","دزدی مکن. ");
INSERT INTO pesOPV_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","بر همسایه خود شهادت دروغ مده. ");
INSERT INTO pesOPV_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","به خانه همسایه خود طمع مورز، و به زن همسایه ات وغلامش و کنیزش و گاوش و الاغش و به هیچ‌چیزی که از آن همسایه تو باشد، طمع مکن.» ");
INSERT INTO pesOPV_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","و جمیع قوم رعدها و زبانه های آتش وصدای کرنا و کوه را که پر از دود بود دیدند، وچون قوم این را بدیدند لرزیدند، و از دوربایستادند. ");
INSERT INTO pesOPV_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","و به موسی گفتند: «تو به ما سخن بگو و خواهیم شنید، اما خدا به ما نگوید، مبادابمیریم.» ");
INSERT INTO pesOPV_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","موسی به قوم گفت: «مترسید زیراخدا برای امتحان شما آمده است، تا ترس اوپیش روی شما باشد و گناه نکنید.» ");
INSERT INTO pesOPV_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","پس قوم ازدور ایستادند و موسی به ظلمت غلیظ که خدا درآن بود، نزدیک آمد. ");
INSERT INTO pesOPV_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","و خداوند به موسی گفت: «به بنی‌اسرائیل چنین بگو: شما دیدید که ازآسمان به شما سخن گفتم: ");
INSERT INTO pesOPV_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","با من خدایان نقره مسازید و خدایان طلا برای خود مسازید. ");
INSERT INTO pesOPV_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","مذبحی از خاک برای من بساز، و قربانی های سوختنی خود و هدایای سلامتی خود را از گله ورمه خویش بر آن بگذران، در هر جایی که یادگاری برای نام خود سازم، نزد تو خواهم آمد، و تو را برکت خواهم داد. ");
INSERT INTO pesOPV_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","و اگر مذبحی ازسنگ برای من سازی، آن را از سنگهای تراشیده بنا مکن، زیرا اگر افزار خود را بر آن بلند کردی، آن را نجس خواهی ساخت. ");
INSERT INTO pesOPV_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","و بر مذبح من ازپله‌ها بالا مرو، مبادا عورت تو بر آن مکشوف شود.» ");
INSERT INTO pesOPV_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","«و این است احکامی که پیش ایشان می گذاری: ");
INSERT INTO pesOPV_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","اگر غلام عبری بخری، شش سال خدمت کند، و در هفتمین، بی‌قیمت، آزاد بیرون رود. ");
INSERT INTO pesOPV_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","اگر تنها آمده، تنها بیرون رود. واگر صاحب زن بوده، زنش همراه او بیرون رود. ");
INSERT INTO pesOPV_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","اگر آقایش زنی بدو دهد و پسران یا دختران برایش بزاید، آنگاه زن و اولادش از آن آقایش باشند، و آن مرد تنها بیرون رود. ");
INSERT INTO pesOPV_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","لیکن هرگاه آن غلام بگوید که هرآینه آقایم و زن و فرزندان خودرا دوست می‌دارم و نمی خواهم که آزاد بیرون روم، ");
INSERT INTO pesOPV_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","آنگاه آقایش او را به حضور خدا بیاورد، واو را نزدیک در یا قایمه در برساند، و آقایش گوش او را با درفشی سوراخ کند، و او وی راهمیشه بندگی نماید. ");
INSERT INTO pesOPV_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","اما اگر شخصی، دخترخود را به کنیزی بفروشد، مثل غلامان بیرون نرود. ");
INSERT INTO pesOPV_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","هر گاه به نظر آقایش که او را برای خودنامزد کرده است ناپسند آید، بگذارد که او را فدیه دهند، اما هیچ حق ندارد که او را به قوم بیگانه بفروشد، زیرا که بدو خیانت کرده است. ");
INSERT INTO pesOPV_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","و هرگاه او را به پسر خود نامزد کند، موافق رسم دختران بااو عمل نماید. ");
INSERT INTO pesOPV_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","اگر زنی دیگر برای خود گیرد، آنگاه خوراک و لباس و مباشرت او را کم نکند. ");
INSERT INTO pesOPV_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","و اگر این سه چیز را برای او نکند، آنگاه بی‌قیمت و رایگان بیرون رود. ");
INSERT INTO pesOPV_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","«هر‌که انسانی را بزند و او بمیرد، هر آینه کشته شود. ");
INSERT INTO pesOPV_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","اما اگر قصد او نداشت، بلکه خداوی را بدستش رسانید، آنگاه مکانی برای تو معین کنم تا بدانجا فرار کند. ");
INSERT INTO pesOPV_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","لیکن اگر شخصی عمد بر همسایه خود آید، تا او را به مکر بکشد، آنگاه او را از مذبح من کشیده، به قتل برسان. ");
INSERT INTO pesOPV_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","و هر‌که پدر یا مادر خود را زند، هرآینه کشته شود. ");
INSERT INTO pesOPV_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","وهر‌که آدمی را بدزدد و او را بفروشد یا در دستش یافت شود، هرآینه کشته شود. ");
INSERT INTO pesOPV_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","و هر‌که پدر یامادر خود را لعنت کند، هرآینه کشته شود. ");
INSERT INTO pesOPV_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","واگر دو مرد نزاع کنند، و یکی دیگری را به سنگ یابه مشت زند، و او نمیرد لیکن بستری شود، ");
INSERT INTO pesOPV_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","اگربرخیزد و با عصا بیرون رود، آنگاه زننده او بی‌گناه شمرده شود، اما عوض بیکاریش را ادا نماید، وخرج معالجه او را بدهد. ");
INSERT INTO pesOPV_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","و اگر کسی غلام یاکنیز خود را به عصا بزند، و او زیر دست او بمیرد، هرآینه انتقام او گرفته شود. ");
INSERT INTO pesOPV_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","لیکن اگر یک دوروز زنده بماند، از او انتقام کشیده نشود، زیرا که زرخرید اوست. ");
INSERT INTO pesOPV_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","و اگر مردم جنگ کنند، و زنی حامله را بزنند، و اولاد او سقط گردد، و ضرری دیگر نشود، البته غرامتی بدهد موافق آنچه شوهرزن بدو گذارد، و به حضور داوران ادا نماید. ");
INSERT INTO pesOPV_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","واگر اذیتی دیگر حاصل شود، آنگاه جان به عوض جان بده. ");
INSERT INTO pesOPV_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","و چشم به عوض چشم، و دندان به عوض دندان، و دست به عوض دست، و پا به عوض پا. ");
INSERT INTO pesOPV_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","و داغ به عوض داغ، و زخم به عوض زخم، و لطمه به عوض لطمه. ");
INSERT INTO pesOPV_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","و اگر کسی چشم غلام یا چشم کنیز خود را بزند که ضایع شود، او را به عوض چشمش آزاد کند. ");
INSERT INTO pesOPV_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","و اگردندان غلام یا دندان کنیز خود را بیندازد او را به عوض دندانش آزاد کند. ");
INSERT INTO pesOPV_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","و هرگاه گاوی به شاخ خود مردی یا زنی را بزند که او بمیرد، گاو را البته سنگسار کنند، و گوشتش را نخورند و صاحب گاو بی‌گناه باشد. ");
INSERT INTO pesOPV_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","و لیکن اگر گاو قبل از آن شاخ زن می‌بود، و صاحبش آگاه بود، و آن را نگاه نداشت، و او مردی یا زنی را کشت، گاو راسنگسار کنند، و صاحبش را نیز به قتل رسانند. ");
INSERT INTO pesOPV_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","و اگر دیه بر او گذاشته شود، آنگاه برای فدیه جان خود هرآنچه بر او مقرر شود، ادا نماید. ");
INSERT INTO pesOPV_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","خواه پسر خواه دختر را شاخ زده باشد، به حسب این حکم با او عمل کنند. ");
INSERT INTO pesOPV_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","اگر گاو، غلامی یا کنیزی را بزند، سی مثقال نقره به صاحب او داده شود، و گاو سنگسار شود. ");
INSERT INTO pesOPV_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","واگر کسی چاهی گشاید یا کسی چاهی حفر کند، وآن را نپوشاند، و گاوی یا الاغی در آن افتد، ");
INSERT INTO pesOPV_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","صاحب چاه عوض او را بدهد، و قیمتش را به صاحبش ادا نماید، و میته از آن او باشد. ");
INSERT INTO pesOPV_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","و اگرگاو شخصی، گاو همسایه او را بزند، و آن بمیردپس گاو زنده را بفروشند، و قیمت آن را تقسیم کنند، و میته را نیز تقسیم نمایند، ");
INSERT INTO pesOPV_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","اما اگر معلوم بوده باشد که آن گاو قبل از آن شاخ زن می‌بود، وصاحبش آن را نگاه نداشت، البته گاو به عوض گاو بدهد و میته از آن او باشد. ");
INSERT INTO pesOPV_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","«اگر کسی گاوی یا گوسفندی بدزدد، و آن را بکشد یا بفروشد، به عوض گاوپنج گاو، و به عوض گوسفند چهار گوسفند بدهد. ");
INSERT INTO pesOPV_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","اگر دزدی در رخنه کردن گرفته شود، و او رابزنند بطوری که بمیرد، بازخواست خون برای اونباشد. ");
INSERT INTO pesOPV_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","اما اگر آفتاب بر او طلوع کرد، بازخواست خون برای او هست. البته مکافات باید داد، و اگر چیزی ندارد، به عوض دزدی که کرد، فروخته شود. ");
INSERT INTO pesOPV_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","اگر چیزی دزدیده شده، ازگاو یا الاغ یا گوسفند زنده در دست او یافت شود، دو مقابل آن را رد کند. ");
INSERT INTO pesOPV_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","اگر کسی مرتعی یاتاکستانی را بچراند، یعنی مواشی خود را براند تامرتع دیگری را بچراند، از نیکوترین مرتع و ازبهترین تاکستان خود عوض بدهد. ");
INSERT INTO pesOPV_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","اگر آتشی بیرون رود، و خارها را فراگیرد و بافه های غله یاخوشه های نادرویده یا مزرعه‌ای سوخته گردد، هر‌که آتش را افروخته است، البته عوض بدهد. ");
INSERT INTO pesOPV_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","اگر کسی پول یا اسباب نزد همسایه خود امانت گذارد، و از خانه آن شخص دزدیده شود، هر گاه دزد پیدا شود، دو چندان رد نماید. ");
INSERT INTO pesOPV_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","و اگر دزدگرفته نشود، آنگاه صاحب‌خانه را به حضورحکام بیاورند، تا حکم شود که آیا دست خود رابر اموال همسایه خویش دراز کرده است یا نه. ");
INSERT INTO pesOPV_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","در هر خیانتی از گاو و الاغ و گوسفند و رخت وهر چیز گم شده، که کسی بر آن ادعا کند، امر هردو به حضور خدا برده شود، و بر گناه هر کدام که خدا حکم کند، دو چندان به همسایه خود ردنماید. ");
INSERT INTO pesOPV_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","اگر کسی الاغی یا گاوی یا گوسفندی یاجانوری دیگر به همسایه خود امانت دهد، و آن بمیرد یا پایش شکسته شود یا دزدیده شود، وشاهدی نباشد، ");
INSERT INTO pesOPV_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","قسم خداوند در میان هر دونهاده شود، که دست خود را به مال همسایه خویش دراز نکرده است. پس مالکش قبول بکندو او عوض ندهد. ");
INSERT INTO pesOPV_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","لیکن اگر از او دزدیده شد، به صاحبش عوض باید داد. ");
INSERT INTO pesOPV_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","و اگر دریده شد، آن را برای شهادت بیاورد، و برای دریده شده، عوض ندهد. ");
INSERT INTO pesOPV_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","و اگر کسی حیوانی از همسایه خود عاریت گرفت، و پای آن شکست یا مرد، وصاحبش همراهش نبود، البته عوض باید داد. ");
INSERT INTO pesOPV_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","اما اگر صاحبش همراهش بود، عوض نباید داد، و اگر کرایه شد، برای کرایه آمده بود. ");
INSERT INTO pesOPV_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","«اگر کسی دختری را که نامزد نبود فریب داده، با او هم بستر شد، البته می‌باید او را زن منکوحه خویش سازد. ");
INSERT INTO pesOPV_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","و هرگاه پدرش راضی نباشد که او را بدو دهد، موافق مهر دوشیزگان نقدی بدو باید داد. ");
INSERT INTO pesOPV_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","زن جادوگر را زنده مگذار. ");
INSERT INTO pesOPV_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","هر‌که با حیوانی مقاربت کند، هرآینه کشته شود. ");
INSERT INTO pesOPV_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","هر‌که برای خدای غیر از یهوه و بس قربانی گذراند، البته هلاک گردد. ");
INSERT INTO pesOPV_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","غریبی رااذیت مرسانید. و بر او ظلم مکنید، زیرا که درزمین مصر غریب بودید. ");
INSERT INTO pesOPV_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","بر بیوه‌زنی یا یتیمی ظلم مکنید. ");
INSERT INTO pesOPV_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","و هر گاه بر او ظلم کردی، و او نزدمن فریاد برآورد، البته فریاد او را مستجاب خواهم فرمود. ");
INSERT INTO pesOPV_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","و خشم من مشتعل شود، و شمارا به شمشیر خواهم کشت، و زنان شما بیوه شوندو پسران شما یتیم. ");
INSERT INTO pesOPV_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","اگر نقدی به فقیری ازقوم من که همسایه تو باشد قرض دادی، مثل رباخوار با او رفتار مکن و هیچ سود بر اومگذار. ");
INSERT INTO pesOPV_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","اگر رخت همسایه خود را به گروگرفتی، آن را قبل از غروب آفتاب بدو رد کن. ");
INSERT INTO pesOPV_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","زیرا که آن فقط پوشش او و لباس برای بدن اوست، پس در چه چیز بخوابد، و اگر نزد من فریاد برآورد، هرآینه اجابت خواهم فرمود، زیرا که من کریم هستم. ");
INSERT INTO pesOPV_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","به خدا ناسزا مگو ورئیس قوم خود را لعنت مکن. ");
INSERT INTO pesOPV_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","درآوردن نوبرغله و عصیر رز خود تاخیر منما. و نخست زاده پسران خود را به من بده. ");
INSERT INTO pesOPV_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","با گاوان وگوسفندان خود چنین بکن. هفت روز نزد مادرخود بماند و در روز هشتمین آن را به من بده. ");
INSERT INTO pesOPV_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","وبرای من مردان مقدس باشید، و گوشتی را که در صحرا دریده شود مخورید؛ آن را نزد سگان بیندازید. ");
INSERT INTO pesOPV_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","«خبر باطل را انتشار مده، و با شریران همداستان مشو، که شهادت دروغ دهی. ");
INSERT INTO pesOPV_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","پیروی بسیاری برای عمل بد مکن؛ و درمرافعه، محض متابعت کثیری، سخنی برای انحراف حق مگو. ");
INSERT INTO pesOPV_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","و در مرافعه فقیر نیزطرفداری او منما. ");
INSERT INTO pesOPV_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","اگر گاو یا الاغ دشمن خود رایافتی که گم شده باشد، البته آن را نزد او بازبیاور. ");
INSERT INTO pesOPV_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","اگر الاغ دشمن خود را زیر بارش خوابیده یافتی، و از گشادن او روگردان هستی، البته آن را همراه او باید بگشایی. ");
INSERT INTO pesOPV_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","حق فقیرخود را در دعوی او منحرف مساز. ");
INSERT INTO pesOPV_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","از امردروغ اجتناب نما و بی‌گناه و صالح را به قتل مرسان زیرا که ظالم را عادل نخواهم شمرد. ");
INSERT INTO pesOPV_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","ورشوت مخور زیرا که رشوت بینایان را کورمی کند و سخن صدیقان را کج می‌سازد. ");
INSERT INTO pesOPV_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","و برشخص غریب ظلم منما زیرا که از دل غریبان خبر دارید، چونکه در زمین مصر غریب بودید. ");
INSERT INTO pesOPV_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","«و شش سال مزرعه خود را بکار ومحصولش را جمع کن، ");
INSERT INTO pesOPV_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","لیکن در هفتمین آن رابگذار و ترک کن تا فقیران قوم تو از آن بخورند و آنچه از ایشان باقی ماند حیوانات صحرا بخورند. همچنین با تاکستان و درختان زیتون خود عمل نما. ");
INSERT INTO pesOPV_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","شش روز به شغل خود بپرداز و در روزهفتمین آرام کن تا گاوت و الاغت آرام گیرند وپسر کنیزت و مهمانت استراحت کنند. ");
INSERT INTO pesOPV_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","و آنچه را به شما گفته‌ام، نگاه دارید و نام خدایان غیر راذکر مکنید، از زبانت شنیده نشود. ");
INSERT INTO pesOPV_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","«در هر سال سه مرتبه عید برای من نگاه دار. ");
INSERT INTO pesOPV_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","عید فطیر را نگاه دار، و چنانکه تو را امرفرموده‌ام، هفت روز نان فطیر بخور در زمان معین در ماه ابیب، زیرا که در آن از مصر بیرون آمدی. وهیچ‌کس به حضور من تهی‌دست حاضر نشود. ");
INSERT INTO pesOPV_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","و عید حصاد نوبر غلات خود را که در مزرعه کاشته‌ای، و عید جمع را در آخر سال وقتی که حاصل خود را از صحرا جمع کرده‌ای. ");
INSERT INTO pesOPV_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","در هرسال سه مرتبه همه ذکورانت به حضور خداوندیهوه حاضر شوند. ");
INSERT INTO pesOPV_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","خون قربانی مرا با نان خمیرمایه دار مگذران و پیه عید من تا صبح باقی نماند. ");
INSERT INTO pesOPV_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","نوبر نخستین زمین خود را به خانه یهوه خدای خود بیاور و بزغاله را در شیر مادرش مپز. ");
INSERT INTO pesOPV_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","«اینک من فرشته‌ای پیش روی تومی فرستم تا تو را در راه محافظت نموده، بدان مکانی که مهیا کرده‌ام برساند. ");
INSERT INTO pesOPV_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","از او با حذر باش و آواز او را بشنو و از او تمرد منما زیرا گناهان شما را نخواهد آمرزید، چونکه نام من در اوست. ");
INSERT INTO pesOPV_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","و اگر قول او را شنیدی و به آنچه گفته‌ام عمل نمودی، هرآینه دشمن دشمنانت و مخالف مخالفانت خواهم بود، ");
INSERT INTO pesOPV_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","زیرا فرشته من پیش روی تو می‌رود و تو را به اموریان و حتیان وفرزیان و کنعانیان و حویان و یبوسیان خواهدرسانید و ایشان را هلاک خواهم ساخت. ");
INSERT INTO pesOPV_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","خدایان ایشان را سجده منما و آنها را عبادت مکن و موافق کارهای ایشان مکن، البته آنها رامنهدم ساز و بتهای ایشان را بشکن. ");
INSERT INTO pesOPV_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","و یهوه، خدای خود را عبادت نمایید تا نان و آب تو رابرکت دهد و بیماری را از میان تو دور خواهم کرد، ");
INSERT INTO pesOPV_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","و در زمینت سقط کننده و نازاد نخواهدبود و شماره روزهایت را تمام خواهم کرد. ");
INSERT INTO pesOPV_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","وخوف خود را پیش روی تو خواهم فرستاد و هرقومی را که بدیشان برسی متحیر خواهم ساخت و جمیع دشمنانت را پیش تو روگردان خواهم ساخت. ");
INSERT INTO pesOPV_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","و زنبورها پیش روی تو خواهم فرستاد تا حویان و کنعانیان و حتیان را ازحضورت برانند. ");
INSERT INTO pesOPV_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","ایشان را در یک سال ازحضور تو نخواهم راند، مبادا زمین ویران گردد وحیوانات صحرا بر تو زیاده شوند. ");
INSERT INTO pesOPV_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","ایشان را ازپیش روی تو به تدریج خواهم راند تا کثیر شوی و زمین را متصرف گردی. ");
INSERT INTO pesOPV_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","و حدود تو را از بحرقلزم تا بحر فلسطین، و از صحرا تا نهر فرات قراردهم زیرا ساکنان آن زمین را بدست شما خواهم سپرد و ایشان را از پیش روی خود خواهی راند. ");
INSERT INTO pesOPV_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","با ایشان و با خدایان ایشان عهد مبند. ");
INSERT INTO pesOPV_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","درزمین تو ساکن نشوند، مبادا تو را بر من عاصی گردانند و خدایان ایشان را عبادت کنی و دامی برای تو باشد.» ");
INSERT INTO pesOPV_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","و به موسی گفت: «نزد خداوند بالابیا، تو و هارون و ناداب و ابیهو و هفتادنفر از مشایخ اسرائیل و از دور سجده کنید. ");
INSERT INTO pesOPV_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","وموسی تنها نزدیک خداوند بیاید و ایشان نزدیک نیایند و قوم همراه او بالا نیایند.» ");
INSERT INTO pesOPV_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","پس موسی آمده، همه سخنان خداوند و همه این احکام را به قوم باز‌گفت و تمامی قوم به یک زبان در جواب گفتند: «همه سخنانی که خداوند گفته است، بجاخواهیم آورد.» ");
INSERT INTO pesOPV_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","و موسی تمامی سخنان خداوند را نوشت و بامدادان برخاسته، مذبحی درپای کوه و دوازده ستون، موافق دوازده سبطاسرائیل بنا نهاد. ");
INSERT INTO pesOPV_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","و بعضی از جوانان بنی‌اسرائیل را فرستاد و قربانی های سوختنی گذرانیدند وقربانی های سلامتی از گاوان برای خداوند ذبح کردند. ");
INSERT INTO pesOPV_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","و موسی نصف خون را گرفته، در لگنهاریخت و نصف خون را بر مذبح پاشید، ");
INSERT INTO pesOPV_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","و کتاب عهد را گرفته، به سمع قوم خواند. پس گفتند: «هرآنچه خداوند گفته است، خواهیم کرد و گوش خواهیم گرفت.» ");
INSERT INTO pesOPV_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","و موسی خون را گرفت و بر قوم پاشیده، گفت: «اینک خون آن عهدی که خداوند بر جمیع این سخنان با شما بسته است.» ");
INSERT INTO pesOPV_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","و موسی با هارون و ناداب و ابیهو و هفتاد نفراز مشایخ اسرائیل بالا رفت. ");
INSERT INTO pesOPV_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","و خدای اسرائیل را دیدند، و زیر پایهایش مثل صنعتی از یاقوت کبود شفاف و مانند ذات آسمان در صفا. ");
INSERT INTO pesOPV_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","و برسروران بنی‌اسرائیل دست خود را نگذارد، پس خدا را دیدند و خوردند و آشامیدند. ");
INSERT INTO pesOPV_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","وخداوند به موسی گفت: «نزد من به کوه بالا بیا، وآنجا باش تا لوحهای سنگی و تورات و احکامی را که نوشته‌ام تا ایشان را تعلیم نمایی، به تو دهم.» ");
INSERT INTO pesOPV_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","پس موسی با خادم خود یوشع برخاست، وموسی به کوه خدا بالا آمد. ");
INSERT INTO pesOPV_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","و به مشایخ گفت: «برای ما در اینجا توقف کنید، تا نزد شمابرگردیم، همانا هارون و حور با شما می‌باشند. پس هر‌که امری دارد، نزد ایشان برود.» ");
INSERT INTO pesOPV_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","و چون موسی به فراز کوه برآمد، ابر کوه را فرو گرفت. ");
INSERT INTO pesOPV_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","و جلال خداوند بر کوه سینا قرار گرفت، وشش روز ابر آن را پوشانید، و روز هفتمین، موسی را از میان ابر ندا درداد. ");
INSERT INTO pesOPV_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","و منظر جلال خداوند، مثل آتش سوزنده در نظر بنی‌اسرائیل برقله کوه بود. ");
INSERT INTO pesOPV_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","و موسی به میان ابر داخل شده، به فراز کوه برآمد، و موسی چهل روز و چهل شب در کوه ماند. ");
INSERT INTO pesOPV_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","و خداوند موسی را خطاب کرده، گفت: ");
INSERT INTO pesOPV_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","«به بنی‌اسرائیل بگو که برای من هدایا بیاورند؛ از هر‌که به میل دل بیاورد، هدایای مرا بگیرید. ");
INSERT INTO pesOPV_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","و این است هدایا که از ایشان می‌گیرید: طلا و نقره و برنج، ");
INSERT INTO pesOPV_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","و لاجورد وارغوان و قرمز و کتان نازک و پشم بز، ");
INSERT INTO pesOPV_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","و پوست قوچ سرخ شده و پوست خز و چوب شطیم، ");
INSERT INTO pesOPV_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","وروغن برای چراغها، و ادویه برای روغن مسح، وبرای بخور معطر، ");
INSERT INTO pesOPV_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","و سنگهای عقیق و سنگهای مرصعی برای ایفود و سینه بند. ");
INSERT INTO pesOPV_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","و مقامی ومقدسی برای من بسازند تا در میان ایشان ساکن شوم. ");
INSERT INTO pesOPV_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","موافق هر‌آنچه به تو نشان دهم از نمونه مسکن و نمونه جمیع اسبابش، همچنین بسازید. ");
INSERT INTO pesOPV_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","«و تابوتی از چوب شطیم بسازند که طولش دو ذراع و نیم، و عرضش یک ذراع و نیم وبلندیش یک ذراع و نیم باشد. ");
INSERT INTO pesOPV_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","و آن را به طلای خالص بپوشان. آن را از درون و بیرون بپوشان، وبر زبرش به هر طرف تاجی زرین بساز. ");
INSERT INTO pesOPV_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","وبرایش چهار حلقه زرین بریز، و آنها را بر چهارقایمه‌اش بگذار، دو حلقه بر یک طرفش و دوحلقه بر طرف دیگر. ");
INSERT INTO pesOPV_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","و دو عصا از چوب شطیم بساز، و آنها را به طلا بپوشان. ");
INSERT INTO pesOPV_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","و آن عصاها رادر حلقه هایی که بر طرفین تابوت باشد بگذران، تاتابوت را به آنها بردارند. ");
INSERT INTO pesOPV_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","و عصاها درحلقه های تابوت بماند و از آنها برداشته نشود. ");
INSERT INTO pesOPV_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","و آن شهادتی را که به تو می‌دهم، در تابوت بگذار. ");
INSERT INTO pesOPV_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","و تخت رحمت را از طلای خالص بساز. طولش دو ذراع و نیم، و عرضش یک ذراع ونیم. ");
INSERT INTO pesOPV_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","و دو کروبی از طلا بساز، آنها را ازچرخکاری از هر دو طرف تخت رحمت بساز. ");
INSERT INTO pesOPV_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","و یک کروبی در این سر و کروبی دیگر در آن سر بساز، کروبیان را از تخت رحمت بر هر دوطرفش بساز. ");
INSERT INTO pesOPV_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","و کروبیان بالهای خود را بر زبرآن پهن کنند، و تخت رحمت را به بالهای خودبپوشانند. و رویهای ایشان به سوی یکدیگرباشد، و رویهای کروبیان به طرف تخت رحمت باشد. ");
INSERT INTO pesOPV_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","و تخت رحمت را بر روی تابوت بگذارو شهادتی را که به تو می‌دهم در تابوت بنه. ");
INSERT INTO pesOPV_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","ودر آنجا با تو ملاقات خواهم کرد و از بالای تخت رحمت از میان دو کروبی که بر تابوت شهادت می‌باشند، با تو سخن خواهم گفت، درباره همه اموری که بجهت بنی‌اسرائیل تو را امر خواهم فرمود. ");
INSERT INTO pesOPV_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","«و خوانی از چوب شطیم بساز که طولش دو ذراع، و عرضش یک ذراع، و بلندیش یک ذراع و نیم باشد. ");
INSERT INTO pesOPV_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","و آن را به طلای خالص بپوشان، و تاجی از طلا به هر طرفش بساز. ");
INSERT INTO pesOPV_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","وحاشیه‌ای به قدر چهار انگشت به اطرافش بساز، و برای حاشیه‌اش تاجی زرین از هر طرف بساز. ");
INSERT INTO pesOPV_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","و چهار حلقه زرین برایش بساز، و حلقه‌ها را برچهار گوشه چهار قایمه‌اش بگذار. ");
INSERT INTO pesOPV_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","و حلقه هادر برابر حاشیه باشد، تا خانه‌ها باشد بجهت عصاها برای برداشتن خوان. ");
INSERT INTO pesOPV_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","و عصاها را ازچوب شطیم بساز، و آنها را به طلا بپوشان تاخوان را بدانها بردارند. ");
INSERT INTO pesOPV_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","و صحنها و کاسه‌ها وجامها و پیاله هایش را که به آنها هدایای ریختنی می‌ریزند بساز، آنها را از طلای خالص بساز. ");
INSERT INTO pesOPV_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","ونان تقدمه را بر خوان، همیشه به حضور من بگذار. ");
INSERT INTO pesOPV_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","«و چراغدانی از طلای خالص بساز، و ازچرخکاری چراغدان ساخته شود، قاعده‌اش وپایه‌اش و پیاله هایش و سیبهایش و گلهایش ازهمان باشد. ");
INSERT INTO pesOPV_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","و شش شاخه از طرفینش بیرون آید، یعنی سه شاخه چراغدان از یک طرف و سه شاخه چراغدان از طرف دیگر. ");
INSERT INTO pesOPV_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","سه پیاله بادامی با سیبی و گلی در یک شاخه و سه پیاله بادامی با سیبی و گلی در شاخه دیگر و هم چنین در شش شاخه‌ای که از چراغدان بیرون می‌آید. ");
INSERT INTO pesOPV_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","و درچراغدان چهار پیاله بادامی با سیبها و گلهای آنهاباشد. ");
INSERT INTO pesOPV_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","و سیبی زیر دو شاخه آن و سیبی زیر دوشاخه آن و سیبی زیر دو شاخه آن بر شش شاخه‌ای که از چراغدان بیرون می‌آید. ");
INSERT INTO pesOPV_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","وسیبها و شاخه هایش از همان باشد، یعنی از یک چرخکاری طلای خالص. ");
INSERT INTO pesOPV_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","و هفت چراغ برای آن بساز، و چراغهایش را بر بالای آن بگذار تاپیش روی آن را روشنایی دهند. ");
INSERT INTO pesOPV_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","و گل گیرها وسینیهایش از طلای خالص باشد. ");
INSERT INTO pesOPV_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","خودش باهمه اسبابش از یک وزنه طلای خالص ساخته شود. ");
INSERT INTO pesOPV_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","و آگاه باش که آنها را موافق نمونه آنها که در کوه به تو نشان داده شد بسازی. ");
INSERT INTO pesOPV_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","«و مسکن را از ده پرده کتان نازک تابیده، و لاجورد و ارغوان و قرمز بساز. با کروبیان از صنعت نساج ماهر آنها را ترتیب نما. ");
INSERT INTO pesOPV_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","طول یک پرده بیست و هشت ذراع، و عرض یک پرده چهار ذراع، و همه پرده‌ها را یک اندازه باشد. ");
INSERT INTO pesOPV_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","پنج پرده با یکدیگر پیوسته باشد، و پنج پرده با یکدیگر پیوسته. ");
INSERT INTO pesOPV_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","و مادگیهای لاجورد برکنار هر پرده‌ای بر لب پیوستگی‌اش بساز، و برکنار پرده بیرونی در‌پیوستگی دوم چنین بساز. ");
INSERT INTO pesOPV_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","پنجاه مادگی در یک پرده بساز، و پنجاه مادگی در کنار پرده‌ای که در‌پیوستگی دوم است بساز، به قسمی که مادگیها مقابل یکدیگر باشد. ");
INSERT INTO pesOPV_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","و پنجاه تکمه زرین بساز و پرده‌ها را به تکمه‌ها با یکدیگرپیوسته ساز، تا مسکن یک باشد. ");
INSERT INTO pesOPV_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","و خیمه بالای مسکن را از پرده های پشم بز بساز، و برای آن یازده پرده درست کن. ");
INSERT INTO pesOPV_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","طول یک پرده سی ذراع، و عرض یک پرده چهار ذراع، و اندازه هر یازده پرده‌یک باشد. ");
INSERT INTO pesOPV_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","و پنج پرده را جدا و شش پرده راجدا، پیوسته ساز، و پرده ششم را پیش روی خیمه دولا کن. ");
INSERT INTO pesOPV_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","و پنجاه مادگی بر کنار پرده‌ای که در‌پیوستگی بیرون است بساز، و پنجاه مادگی بر کنار پرده‌ای که در‌پیوستگی دوم است. ");
INSERT INTO pesOPV_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","وپنجاه تکمه برنجین بساز، و تکمه‌ها را در مادگیهابگذران، و خیمه را با هم پیوسته ساز تا یک باشد. ");
INSERT INTO pesOPV_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","و زیادتی پرده های خیمه که باقی باشد، یعنی نصف پرده که زیاده است، از پشت خیمه آویزان شود. ");
INSERT INTO pesOPV_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","و ذراعی از این طرف و ذراعی از آن طرف که در طول پرده های خیمه زیاده باشد، برطرفین مسکن از هر دو جانب آویزان شود تا آن رابپوشد. ");
INSERT INTO pesOPV_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","و پوششی برای خیمه از پوست قوچ سرخ شده بساز، و پوششی از پوست خز بر زبرآن. ");
INSERT INTO pesOPV_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","«و تخته های قایم از چوب شطیم برای مسکن بساز. ");
INSERT INTO pesOPV_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","طول هر تخته ده ذراع، و عرض هر تخته یک ذراع و نیم. ");
INSERT INTO pesOPV_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","و در هر تخته دو زبانه قرینه یکدیگر باشد، و همه تخته های مسکن راچنین بساز. ");
INSERT INTO pesOPV_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","و تخته‌ها برای مسکن بساز، یعنی بیست تخته از طرف جنوب به سمت یمانی. ");
INSERT INTO pesOPV_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","وچهل پایه نقره در زیر آن بیست تخته بساز، یعنی دو پایه زیر یک تخته برای دو زبانه‌اش، و دو پایه زیر یک تخته برای دو زبانه‌اش. ");
INSERT INTO pesOPV_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","و برای جانب دیگر مسکن، از طرف شمال بیست تخته باشد. ");
INSERT INTO pesOPV_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","و چهل پایه نقره آنها، یعنی دو پایه زیر یک تخته و دو پایه زیر تخته دیگر. ");
INSERT INTO pesOPV_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","و برای موخر مسکن از جانب غربی شش تخته بساز. ");
INSERT INTO pesOPV_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","و برای گوشه های مسکن در موخرش دو تخته بساز. ");
INSERT INTO pesOPV_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","واز زیر وصل کرده شود، و تا بالا نیز در یک حلقه باهم پیوسته شود، و برای هر دو چنین بشود، در هردو گوشه باشد. ");
INSERT INTO pesOPV_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","و هشت تخته باشد و پایه های آنها از نقره شانزده پایه باشد، یعنی دو پایه زیریک تخته و دو پایه زیر تخته دیگر. ");
INSERT INTO pesOPV_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","«و پشت بندها از چوب شطیم بساز، پنج ازبرای تخته های یک طرف مسکن، ");
INSERT INTO pesOPV_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","و پنج پشت بند برای تخته های طرف دیگر مسکن، وپنج پشت بند برای تخته های طرف مسکن درموخرش به سمت مغرب. ");
INSERT INTO pesOPV_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","و پشت بند وسطی که میان تخته هاست، از این سر تا آن سر بگذرد. ");
INSERT INTO pesOPV_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","و تخته‌ها را به طلا بپوشان و حلقه های آنها رااز طلا بساز تا خانه های پشت بندها باشد وپشت بندها را به طلا بپوشان. ");
INSERT INTO pesOPV_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","«پس مسکن را برپا کن موافق نمونه‌ای که در کوه به تو نشان داده شد. ");
INSERT INTO pesOPV_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","و حجابی ازلاجورد و ارغوان و قرمز و کتان نازک تابیده شده بساز، از صنعت نساج ماهر با کروبیان ساخته شود. ");
INSERT INTO pesOPV_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","و آن را بر چهار ستون چوب شطیم پوشیده شده به طلا بگذار، و قلابهای آنها از طلاباشد و بر چهار پایه نقره قایم شود. ");
INSERT INTO pesOPV_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","و حجاب را زیر تکمه‌ها آویزان کن، و تابوت شهادت را درآنجا به اندرون حجاب بیاور، و حجاب، قدس رابرای شما از قدس‌الاقداس جدا خواهد کرد. ");
INSERT INTO pesOPV_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","وتخت رحمت را بر تابوت شهادت درقدس‌الاقداس بگذار. ");
INSERT INTO pesOPV_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","و خوان را بیرون حجاب و چراغدان را برابر خوان به طرف جنوبی مسکن بگذار، و خوان را به طرف شمالی آن برپا کن. ");
INSERT INTO pesOPV_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","و پرده‌ای برای دروازه مسکن از لاجورد و ارغوان وقرمز و کتان نازک تابیده شده از صنعت طرازبساز. ");
INSERT INTO pesOPV_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","و برای پرده پنج ستون از چوب شطیم بساز، و آنها را به طلا بپوشان، و قلابهای آنها ازطلا باشد، و برای آنها پنج پایه برنجین بریز. ");
INSERT INTO pesOPV_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","«و مذبح را از چوب شطیم بساز، طولش پنج ذراع و عرضش پنج ذراع. ومذبح مربع باشد. و بلندی‌اش سه ذراع. ");
INSERT INTO pesOPV_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","وشاخه هایش را بر چهار گوشه‌اش بساز وشاخه هایش از همان باشد و آن را به برنج بپوشان. ");
INSERT INTO pesOPV_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","و لگنهایش را برای برداشتن خاکسترش بساز. وخاک اندازهایش و جامهایش و چنگالهایش ومجمرهایش و همه اسبابش را از برنج بساز. ");
INSERT INTO pesOPV_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","وبرایش آتش دانی مشبک برنجین بساز و بر آن شبکه چهار حلقه برنجین بر چهار گوشه‌اش بساز. ");
INSERT INTO pesOPV_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","و آن را در زیر، کنار مذبح بگذار تا شبکه به نصف مذبح برسد. ");
INSERT INTO pesOPV_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","و دو عصا برای مذبح بساز. عصاها از چوب شطیم باشد و آنها را به برنج بپوشان. ");
INSERT INTO pesOPV_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","و عصاها را در حلقه‌ها بگذرانند، وعصاها بر هر دو طرف مذبح باشد تا آن را بردارند. ");
INSERT INTO pesOPV_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","و آن را مجوف از تخته‌ها بساز، همچنانکه درکوه به تو نشان داده شد، به این طور ساخته شود. ");
INSERT INTO pesOPV_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","«و صحن مسکن را بساز به طرف جنوب به سمت یمانی. پرده های صحن از کتان نازک تابیده شده باشد، و طولش صد ذراع به یک طرف. ");
INSERT INTO pesOPV_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","وستونهایش بیست و پایه های آنها بیست، از برنج باشد و قلابهای ستونها و پشت بندهای آنها ازنقره باشد. ");
INSERT INTO pesOPV_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","و همچنین به طرف شمال، درطولش پرده‌ها باشد که طول آنها صد ذراع باشد وبیست ستون آن و بیست پایه آنها از برنج باشد وقلابهای ستونها و پشت بندهای آنها از نقره باشد. ");
INSERT INTO pesOPV_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","و برای عرض صحن به سمت مغرب، پرده های پنجاه ذراعی باشد. و ستونهای آنها ده وپایه های آنها ده. ");
INSERT INTO pesOPV_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","و عرض صحن به‌جانب مشرق از سمت طلوع پنجاه ذراع باشد. ");
INSERT INTO pesOPV_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","وپرده های یک طرف دروازه، پانزده ذراع وستونهای آنها سه و پایه های آنها سه. ");
INSERT INTO pesOPV_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","وپرده های طرف دیگر پانزده ذراعی و ستونهای آنها سه و پایه های آنها سه. ");
INSERT INTO pesOPV_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","و برای دروازه صحن، پرده بیست ذراعی از لاجورد و ارغوان وقرمز و کتان نازک تابیده شده از صنعت طرازباشد. و ستونهایش چهار و پایه هایش چهار. ");
INSERT INTO pesOPV_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","همه ستونهای گرداگرد صحن با پشت بندهای نقره پیوسته شود، و قلابهای آنها از نقره وپایه های آنها از برنج باشد. ");
INSERT INTO pesOPV_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","طول صحن صدذراع، و عرضش در هر جا پنجاه ذراع، وبلندی‌اش پنج ذراع از کتان نازک تابیده شده، وپایه هایش از برنج باشد. ");
INSERT INTO pesOPV_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","و همه اسباب مسکن برای هر خدمتی، و همه میخهایش، و همه میخهای صحن از برنج باشد. ");
INSERT INTO pesOPV_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","«و تو بنی‌اسرائیل را امر فرما که روغن زیتون مصفی و کوبیده شده برای روشنایی نزد توبیاورند تا چراغها دائم روشن شود. ");
INSERT INTO pesOPV_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","در خیمه اجتماع، بیرون پرده‌ای که در برابر شهادت است، هارون و پسرانش از شام تا صبح، به حضورخداوند آن را درست کنند. و این برای بنی‌اسرائیل نسلا بعد نسل فریضه ابدی باشد. ");
INSERT INTO pesOPV_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","«و تو برادر خود، هارون و پسرانش را با وی از میان بنی‌اسرائیل نزد خودبیاور تا برای من کهانت بکند، یعنی هارون وناداب و ابیهو و العازار و ایتامار، پسران هارون. ");
INSERT INTO pesOPV_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","ورختهای مقدس برای برادرت، هارون، بجهت عزت و زینت بساز. ");
INSERT INTO pesOPV_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","و تو به جمیع دانادلانی که ایشان را به روح حکمت پر ساخته‌ام، بگو که رختهای هارون را بسازند برای تقدیس کردن او تابرای من کهانت کند. ");
INSERT INTO pesOPV_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","و رختهایی که می‌سازنداین است: سینه بند و ایفود و ردا و پیراهن مطرز وعمامه و کمربند. این رختهای مقدس را برای برادرت هارون و پسرانش بسازند تا بجهت من کهانت کند. ");
INSERT INTO pesOPV_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","و ایشان طلا و لاجورد و ارغوان وقرمز و کتان نازک را بگیرند، ");
INSERT INTO pesOPV_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","«و ایفود را از طلا و لاجورد و ارغوان و قرمزو کتان نازک تابیده شده، از صنعت نساج ماهربسازند. ");
INSERT INTO pesOPV_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","و دو کتفش را بر دو کناره‌اش بپیوندند تاپیوسته شود. ");
INSERT INTO pesOPV_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","و زنار ایفود که برآن است، ازهمان صنعت و از همان پارچه باشد، یعنی از طلاو لاجورد و ارغوان و قرمز و کتان نازک تابیده شده. ");
INSERT INTO pesOPV_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","و دو سنگ جزع بگیر و نامهای بنی‌اسرائیل را بر آنها نقش کن. ");
INSERT INTO pesOPV_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","شش نام ایشان را بر یک سنگ و شش نام باقی ایشان را بر سنگ دیگر موافق تولد ایشان. ");
INSERT INTO pesOPV_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","از صنعت نقاش سنگ مثل نقش خاتم نامهای بنی‌اسرائیل را بر هردو سنگ نقش نما و آنها را در طوقهای طلا نصب کن. ");
INSERT INTO pesOPV_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","و آن دو سنگ را بر کتفهای ایفود بگذار تاسنگهای یادگاری برای بنی‌اسرائیل باشد، وهارون نامهای ایشان را بر دو کتف خود، بحضور خداوند برای یادگاری بردارد. ");
INSERT INTO pesOPV_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","و دو طوق ازطلا بساز. ");
INSERT INTO pesOPV_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","و دو زنجیر از طلای خالص بسازمثل طناب بهم پیچیده شده، و آن دو زنجیر بهم پیچیده شده را در طوقها بگذار. ");
INSERT INTO pesOPV_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","«و سینه بند عدالت را از صنعت نساج ماهر، موافق کار ایفود بساز و آن را از طلا و لاجورد وارغوان و قرمز و کتان نازک تابیده شده بساز. ");
INSERT INTO pesOPV_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","ومربع و دولا باشد، طولش یک وجب و عرضش یک وجب. ");
INSERT INTO pesOPV_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","و آن را به ترصیع سنگها، یعنی به چهار رسته از سنگها مرصع کن که رسته اول عقیق احمر و یاقوت اصفر و زمرد باشد، ");
INSERT INTO pesOPV_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","و رسته دوم بهرمان و یاقوت کبود و عقیق سفید، ");
INSERT INTO pesOPV_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","ورسته سوم عین الهر و یشم و جمشت، ");
INSERT INTO pesOPV_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","و رسته چهارم زبرجد و جزع و یشب. و آنها دررسته های خود با طلا نشانده شود. ");
INSERT INTO pesOPV_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","و سنگهاموافق نامهای بنی‌اسرائیل مطابق اسامی ایشان، دوازده باشد، مثل نقش خاتم، و هر یک برای دوازده سبط موافق اسمش باشد. ");
INSERT INTO pesOPV_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","و بر سینه بند، زنجیرهای بهم پیچیده شده، مثل طناب از طلای خالص بساز. ");
INSERT INTO pesOPV_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","و بر سینه بند، دو حلقه از طلابساز و آن دو حلقه را بر دو طرف سینه بند بگذار. ");
INSERT INTO pesOPV_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","و آن دو زنجیر طلا را بر آن دو حلقه‌ای که برسر سینه بند است بگذار. ");
INSERT INTO pesOPV_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","و دو سر دیگر آن دوزنجیر را در آن دو طوق ببند و بر دو کتف ایفودبطرف پیش بگذار. ");
INSERT INTO pesOPV_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","و دو حلقه زرین بساز و آنهارا بر دو سر سینه بند، به کنار آن که بطرف اندرون ایفود است، بگذار. ");
INSERT INTO pesOPV_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","و دو حلقه دیگر زرین بسازو آنها را بر دو کتف ایفود از پایین بجانب پیش، دربرابر پیوستگی آن، بر زبر زنار ایفود بگذار. ");
INSERT INTO pesOPV_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","وسینه بند را به حلقه هایش بر حلقه های ایفود به نوار لاجورد ببندند تا بالای زنار ایفود باشد و تاسینه بند از ایفود جدا نشود. ");
INSERT INTO pesOPV_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","و هارون نامهای بنی‌اسرائیل را بر سینه بند عدالت بر دل خود، وقتی که به قدس داخل شود، به حضور خداوندبجهت یادگاری دائم بردارد. ");
INSERT INTO pesOPV_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","و اوریم و تمیم را در سینه بند عدالت بگذار تا بر دل هارون باشد، وقتی که به حضور خداوند بیاید، و عدالت بنی‌اسرائیل را بر دل خود بحضور خداوند دائم متحمل شود. ");
INSERT INTO pesOPV_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","«و ردای ایفود را تمام از لاجورد بساز. ");
INSERT INTO pesOPV_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","و شکافی برای سر، در وسطش باشد. و حاشیه گرداگرد شکافش از کار نساج مثل گریبان زره، تادریده نشود. ");
INSERT INTO pesOPV_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","و در دامنش، انارها بساز ازلاجورد و ارغوان و قرمز، گرداگرد دامنش، وزنگوله های زرین در میان آنها به هر طرف. ");
INSERT INTO pesOPV_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","زنگوله زرین و اناری و زنگوله زرین و اناری گرداگرد دامن ردا. ");
INSERT INTO pesOPV_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","و در بر هارون باشد، هنگامی که خدمت می‌کند، تا آواز آنها شنیده شود، هنگامی که در قدس بحضور خداوند داخل می‌شود و هنگامی که بیرون می‌آید تا نمیرد. ");
INSERT INTO pesOPV_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","وتنکه از طلای خالص بساز و بر آن مثل نقش خاتم قدوسیت برای یهوه نقش کن. ");
INSERT INTO pesOPV_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","و آن را به نوارلاجوردی ببند تا بر عمامه باشد، بر پیشانی عمامه خواهد بود. ");
INSERT INTO pesOPV_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","و بر پیشانی هارون باشد تا هارون گناه موقوفاتی که بنی‌اسرائیل وقف می‌نمایند، درهمه هدایای مقدس ایشان متحمل شود. و آن دائم بر پیشانی او باشد تا بحضور خداوند مقبول شوند. ");
INSERT INTO pesOPV_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","و پیراهن کتان نازک را بباف و عمامه‌ای از کتان نازک بساز و کمربندی از صنعت طرازبساز. ");
INSERT INTO pesOPV_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","و برای پسران هارون پیراهنها بساز و بجهت ایشان کمربندها بساز و برای ایشان عمامه‌ها بساز بجهت عزت و زینت. ");
INSERT INTO pesOPV_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","و برادرخود هارون و پسرانش را همراه او به آنها آراسته کن، و ایشان را مسح کن و ایشان را تخصیص وتقدیس نما تا برای من کهانت کنند. ");
INSERT INTO pesOPV_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","و زیرجامه های کتان برای ستر عورت ایشان بساز که ازکمر تا ران برسد، ");
INSERT INTO pesOPV_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","و بر هارون و پسرانش باشد، هنگامی که به خیمه اجتماع داخل شوند یا نزدمذبح آیند تا در قدس خدمت نمایند، مبادامتحمل گناه شوند و بمیرند. این برای وی و بعد ازاو برای ذریتش فریضه ابدی است. ");
INSERT INTO pesOPV_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","«و این است کاری که بدیشان می‌کنی، برای تقدیس نمودن ایشان تا بجهت من کهانت کنند: یک گوساله و دو قوچ بی‌عیب بگیر، ");
INSERT INTO pesOPV_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","و نان فطیر و قرصهای فطیر سرشته به روغن ورقیقهای فطیر مسح شده به روغن. آنها را از آردنرم گندم بساز. ");
INSERT INTO pesOPV_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","و آنها را در یک سبد بگذار و آنهارا در سبد با گوساله و دو قوچ بگذران. ");
INSERT INTO pesOPV_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","و هارون و پسرانش را نزد دروازه خیمه اجتماع آورده، ایشان را به آب غسل ده، ");
INSERT INTO pesOPV_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","و آن رختها را گرفته، هارون را به پیراهن و ردای ایفود و ایفود وسینه بند آراسته کن و زنار ایفود را بر وی ببند. ");
INSERT INTO pesOPV_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","وعمامه را بر سرش بنه و افسر قدوسیت را برعمامه بگذار، ");
INSERT INTO pesOPV_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","و روغن مسح را گرفته، برسرش بریز و او را مسح کن. ");
INSERT INTO pesOPV_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","و پسرانش را نزدیک آورده، ایشان را به پیراهنها بپوشان. ");
INSERT INTO pesOPV_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","و بر ایشان، یعنی هارون و پسرانش کمربندها ببند و عمامه هارا بر ایشان بگذار و کهانت برای ایشان فریضه ابدی خواهد بود. پس هارون و پسرانش راتخصیص نما. ");
INSERT INTO pesOPV_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","و گوساله را پیش خیمه اجتماع برسان، و هارون و پسرانش دستهای خود را بر سرگوساله بگذارند. ");
INSERT INTO pesOPV_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","و گوساله را به حضورخداوند نزد در خیمه اجتماع ذبح کن. ");
INSERT INTO pesOPV_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","و ازخون گوساله گرفته، بر شاخهای مذبح به انگشت خود بگذار، و باقی خون را بر بنیان مذبح بریز. ");
INSERT INTO pesOPV_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","و همه پیه را که احشا را می‌پوشاند، و سفیدی که بر جگر است، و دو گرده را با پیهی که برآنهاست، گرفته، بر مذبح بسوزان. ");
INSERT INTO pesOPV_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","اما گوشت گوساله را و پوست و سرگینش را بیرون از اردو به آتش بسوزان، زیرا قربانی گناه است. ");
INSERT INTO pesOPV_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","«و یک قوچ بگیر و هارون و پسران، دستهای خود را بر سر قوچ بگذارند. ");
INSERT INTO pesOPV_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","و قوچ راذبح کرده، خونش را بگیر و گرداگرد مذبح بپاش. ");
INSERT INTO pesOPV_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","و قوچ را به قطعه هایش ببر، و احشا وپاچه هایش را بشوی، و آنها را بر قطعه‌ها و سرش بنه. ");
INSERT INTO pesOPV_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","و تمام قوچ را بر مذبح بسوزان، زیرا برای خداوند قربانی سوختنی است، و عطر خوشبو، وقربانی آتشین برای خداوند است. ");
INSERT INTO pesOPV_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","پس قوچ دوم را بگیر و هارون و پسرانش دستهای خود رابر سر قوچ بگذارند. ");
INSERT INTO pesOPV_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","و قوچ را ذبح کرده، ازخونش بگیر و به نرمه گوش راست هارون، و به نرمه گوش پسرانش، و به شست دست راست ایشان، و به شست پای راست ایشان، بگذار، وباقی خون را گرداگرد مذبح بپاش. ");
INSERT INTO pesOPV_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","و از خونی که بر مذبح است، و از روغن مسح گرفته، آن را برهارون و رخت وی و بر پسرانش و رخت پسرانش با وی بپاش، تا او و رختش و پسرانش ورخت پسرانش با وی تقدیس شوند. ");
INSERT INTO pesOPV_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","پس پیه قوچ را، و دنبه و پیهی که احشا را می‌پوشاند، وسفیدی جگر، و دو گرده و پیهی که بر آنهاست، وساق راست را بگیر، زیرا که قوچ، قربانی تخصیص است. ");
INSERT INTO pesOPV_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","و یک گرده نان و یک قرص نان روغنی، و یک رقیق از سبد نان فطیر را که به حضور خداوند است، ");
INSERT INTO pesOPV_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","و این همه را به‌دست هارون و به‌دست پسرانش بنه، و آنها را برای هدیه جنبانیدنی به حضور خداوند بجنبان. ");
INSERT INTO pesOPV_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","وآنها را از دست ایشان گرفته، برای قربانی سوختنی بر مذبح بسوزان، تا برای خداوند عطرخوشبو باشد، زیرا که این قربانی آتشین خداونداست. ");
INSERT INTO pesOPV_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","و سینه قوچ قربانی تخصیص را که برای هارون است گرفته، آن را برای هدیه جنبانیدنی به حضور خداوند بجنبان. و آن حصه تو می‌باشد. ");
INSERT INTO pesOPV_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","و سینه جنبانیدنی و ساق رفیعه را که از قوچ قربانی تخصیص هارون و پسرانش جنبانیده، وبرداشته شد، تقدیس نمای. ");
INSERT INTO pesOPV_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","و آن از آن هارون و پسرانش از جانب بنی‌اسرائیل به فریضه ابدی خواهد بود، زیرا که هدیه رفیعه است و هدیه رفیعه از جانب بنی‌اسرائیل از قربانی های سلامتی ایشان برای خداوند خواهد بود. ");
INSERT INTO pesOPV_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","ورخت مقدس هارون بعد از او، از آن پسرانش خواهد بود، تا در آنها مسح و تخصیص شوند. ");
INSERT INTO pesOPV_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","هفت روز، آن کاهن که جانشین او می‌باشد ازپسرانش و به خیمه اجتماع داخل شده، خدمت قدس را می‌کند، آنها را بپوشد. ");
INSERT INTO pesOPV_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","و قوچ قربانی تخصیص را گرفته، گوشتش را در قدس آب پزکن. ");
INSERT INTO pesOPV_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","و هارون و پسرانش گوشت قوچ را با نانی که در سبد است، به در خیمه اجتماع بخورند. ");
INSERT INTO pesOPV_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","و آنانی که برای تخصیص و تقدیس خود بدین چیزها کفاره کرده شدند، آنها را بخورند، لیکن شخص اجنبی نخورد زیرا که مقدس است. ");
INSERT INTO pesOPV_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","و اگر چیزی از گوشت هدیه تخصیص و از نان، تاصبح باقی ماند، آن باقی را به آتش بسوزان، و آن را نخورند، زیرا که مقدس است. ");
INSERT INTO pesOPV_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","«همچنان به هارون و پسرانش عمل نما، موافق آنچه به تو امر فرموده‌ام، هفت روز ایشان را تخصیص نما. ");
INSERT INTO pesOPV_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","و گوساله قربانی گناه را هرروز بجهت کفاره ذبح کن. ");
INSERT INTO pesOPV_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","و مذبح را طاهر سازبه کفاره‌ای که بر آن می‌کنی، و آن را مسح کن تامقدس شود. ");
INSERT INTO pesOPV_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","هفت روز برای مذبح کفاره کن، وآن را مقدس ساز، و مذبح، قدس اقداس خواهدبود. هر‌که مذبح را لمس کند، مقدس باشد. ");
INSERT INTO pesOPV_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","واین است قربانی هایی که بر مذبح باید گذرانید: دوبره یکساله. هر روز پیوسته ");
INSERT INTO pesOPV_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","یک بره را در صبح ذبح کن، و بره دیگر را در عصر ذبح نما. ");
INSERT INTO pesOPV_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","و ده‌یک از آرد نرم سرشته شده با یک ربع هین روغن کوبیده، و برای هدیه ریختنی، یک ربع هین شراب برای هر بره خواهد بود. ");
INSERT INTO pesOPV_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","و بره دیگر رادر عصر ذبح کن و برای آن موافق هدیه صبح وموافق هدیه ریختنی آن بگذران، تا عطر خوشبوو قربانی آتشین برای خداوند باشد. ");
INSERT INTO pesOPV_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","این قربانی سوختنی دائمی، در نسلهای شما نزد دروازه خیمه اجتماع خواهد بود، به حضور خداوند، درجایی که با شما ملاقات می‌کنم تا آنجا به تو سخن گویم. ");
INSERT INTO pesOPV_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","و در آنجا با بنی‌اسرائیل ملاقات می‌کنم، تا از جلال من مقدس شود. ");
INSERT INTO pesOPV_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","و خیمه اجتماع و مذبح را مقدس می‌کنم، و هارون وپسرانش را تقدیس می‌کنم تا برای من کهانت کنند. ");
INSERT INTO pesOPV_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","و در میان بنی‌اسرائیل ساکن شده، خدای ایشان می‌باشم. ");
INSERT INTO pesOPV_vpl VALUES ("EX29_47","003_29_47","EXO","29","47","47","و خواهند دانست که من یهوه، خدای ایشان هستم، که ایشان را از زمین مصر بیرون آورده‌ام، تا در میان ایشان ساکن شوم. من یهوه خدای ایشان هستم. ");
INSERT INTO pesOPV_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","«و مذبحی برای سوزانیدن بخوربساز. آن را از چوب شطیم بساز. ");
INSERT INTO pesOPV_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","طولش ذراعی باشد، و عرضش ذراعی، یعنی مربع باشد، و بلندی‌اش دو ذراع، و شاخهایش ازخودش باشد. ");
INSERT INTO pesOPV_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","و آن را به طلای خالص بپوشان. سطحش و جانبهایش به هر طرف و شاخهایش راو تاجی از طلا گرداگردش بساز. ");
INSERT INTO pesOPV_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","و دو حلقه زرین برایش در زیر تاجش بساز، بر دو گوشه‌اش، بر هر دو طرفش، آنها را بساز. و آنها خانه‌ها باشدبرای عصاها، تا آن را بدانها بردارند. ");
INSERT INTO pesOPV_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","و عصاها رااز چوب شطیم بساز و آنها را به طلا بپوشان. ");
INSERT INTO pesOPV_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","وآن را پیش حجابی که روبروی تابوت شهادت است، در مقابل کرسی رحمت که بر زبر شهادت است، در جایی که با تو ملاقات می‌کنم، بگذار. ");
INSERT INTO pesOPV_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","و هر بامداد هارون بخور معطر بر روی آن بسوزاند، وقتی که چراغها را می‌آراید، آن رابسوزاند. ");
INSERT INTO pesOPV_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","و در عصر چون هارون چراغها راروشن می‌کند، آن را بسوزاند تا بخور دائمی به حضور خداوند در نسلهای شما باشد. ");
INSERT INTO pesOPV_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","هیچ بخور غریب و قربانی سوختنی و هدیه‌ای بر آن مگذرانید، و هدیه ریختنی بر آن مریزید. ");
INSERT INTO pesOPV_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","وهارون سالی یک مرتبه بر شاخهایش کفاره کند، به خون قربانی گناه که برای کفاره است، سالی یک مرتبه بر آن کفاره کند در نسلهای شما، زیرا که آن برای خداوند قدس اقداس است.» ");
INSERT INTO pesOPV_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","و خداوند به موسی خطاب کرده، گفت: ");
INSERT INTO pesOPV_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","«وقتی که شماره بنی‌اسرائیل را برحسب شمرده شدگان ایشان می‌گیری، آنگاه هرکس فدیه جان خود را به خداوند دهد، هنگامی که ایشان را می‌شماری، مبادا در حین شمردن ایشان، وبایی در ایشان حادث شود. ");
INSERT INTO pesOPV_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","هر‌که به سوی شمرده شدگان می‌گذرد، این را بدهد، یعنی نیم مثقال موافق مثقال قدس، که یک مثقال بیست قیراط است، و این نیم مثقال هدیه خداوند است. ");
INSERT INTO pesOPV_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","هرکس از بیست ساله و بالاتر که به سوی شمرده شدگان بگذرد، هدیه خداوند را بدهد. ");
INSERT INTO pesOPV_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","دولتمند از نیم مثقال زیاده ندهد، و فقیر کمترندهد، هنگامی که هدیه‌ای برای کفاره جانهای خود به خداوند می‌دهند. ");
INSERT INTO pesOPV_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","و نقد کفاره را ازبنی‌اسرائیل گرفته، آن را برای خدمت خیمه اجتماع بده، تا برای بنی‌اسرائیل یادگاری به حضور خداوند باشد، و بجهت جانهای ایشان کفاره کند.» ");
INSERT INTO pesOPV_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","و خداوند به موسی خطاب کرده، گفت: ");
INSERT INTO pesOPV_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","«حوضی نیز برای شستن از برنج بساز، وپایه‌اش از برنج و آن را در میان خیمه اجتماع ومذبح بگذار، و آب در آن بریز. ");
INSERT INTO pesOPV_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","و هارون وپسرانش دست و پای خود را از آن بشویند. ");
INSERT INTO pesOPV_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","هنگامی که به خیمه اجتماع داخل شوند، به آب بشویند، مبادا بمیرند. و وقتی که برای خدمت کردن و سوزانیدن قربانی های آتشین بجهت خداوند به مذبح نزدیک آیند، ");
INSERT INTO pesOPV_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","آنگاه دست و پای خود را بشویند، مبادا بمیرند. و این برای ایشان، یعنی برای او و ذریتش، نسلا بعدنسل فریضه ابدی باشد.» ");
INSERT INTO pesOPV_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","و خداوند موسی را خطاب کرده، گفت: ");
INSERT INTO pesOPV_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","«و تو عطریات خاص بگیر، از مر چکیده پانصد مثقال، و از دارچینی معطر، نصف آن، دویست و پنجاه مثقال، و از قصب الذریره، دویست و پنجاه مثقال. ");
INSERT INTO pesOPV_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","و از سلیخه پانصدمثقال موافق مثقال قدس، و از روغن زیتون یک هین. ");
INSERT INTO pesOPV_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","و از آنها روغن مسح مقدس را بساز، عطری که از صنعت عطار ساخته شود، تا روغن مسح مقدس باشد. ");
INSERT INTO pesOPV_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","و خیمه اجتماع و تابوت شهادت را بدان مسح کن. ");
INSERT INTO pesOPV_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","و خوان را با تمامی اسبابش، و چراغدان را با اسبابش، و مذبح بخوررا، ");
INSERT INTO pesOPV_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","و مذبح قربانی سوختنی را با همه اسبابش، و حوض را با پایه‌اش. ");
INSERT INTO pesOPV_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","و آنها را تقدیس نما، تاقدس اقداس باشد. هر‌که آنها را لمس نمایدمقدس باشد. ");
INSERT INTO pesOPV_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","و هارون و پسرانش را مسح نموده، ایشان را تقدیس نما، تا برای من کهانت کنند. ");
INSERT INTO pesOPV_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","و بنی‌اسرائیل را خطاب کرده، بگو: این است روغن مسح مقدس برای من در نسلهای شما. ");
INSERT INTO pesOPV_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","و بر بدن انسان ریخته نشود، و مثل آن موافق ترکیبش مسازید، زیرا که مقدس است ونزد شما مقدس خواهد بود. ");
INSERT INTO pesOPV_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","هر‌که مثل آن ترکیب نماید، و هر‌که چیزی از آن بر شخصی بیگانه بمالد، از قوم خود منقطع شود.» ");
INSERT INTO pesOPV_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","و خداوند به موسی گفت: «عطریات بگیر، یعنی میعه و اظفار و قنه و از این عطریات با کندرصاف حصه‌ها مساوی باشد. ");
INSERT INTO pesOPV_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","و از اینها بخوربساز، عطری از صنعت عطار نمکین و مصفی و مقدس. ");
INSERT INTO pesOPV_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","و قدری از آن را نرم بکوب، و آن راپیش شهادت در خیمه اجتماع، جایی که با توملاقات می‌کنم بگذار، و نزد شما قدس اقداس باشد. ");
INSERT INTO pesOPV_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","و موافق ترکیب این بخور که می‌سازی، دیگری برای خود مسازید؛ نزد توبرای خداوند مقدس باشد. ");
INSERT INTO pesOPV_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","هر‌که مثل آن رابرای بوییدن بسازد، از قوم خود منقطع شود.» ");
INSERT INTO pesOPV_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","و خداوند موسی را خطاب کرده، گفت: ");
INSERT INTO pesOPV_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","«آگاه باش بصلئیل بن اوری بن حور را از سبط یهودا به نام خوانده‌ام. ");
INSERT INTO pesOPV_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","و او را به روح خدا پر ساخته‌ام، و به حکمت و فهم ومعرفت و هر هنری، ");
INSERT INTO pesOPV_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","برای اختراع مخترعات، تادر طلا و نقره و برنج کار کند. ");
INSERT INTO pesOPV_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","و برای تراشیدن سنگ و ترصیع آن و درودگری چوب، تا در هرصنعتی اشتغال نماید. ");
INSERT INTO pesOPV_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","و اینک من، اهولیاب بن اخیسامک را از سبط دان، انباز او ساخته‌ام، و دردل همه دانادلان حکمت بخشیده‌ام، تا آنچه را به تو امر فرموده‌ام، بسازند. ");
INSERT INTO pesOPV_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","خیمه اجتماع و تابوت شهادت و کرسی رحمت که بر آن است، و تمامی اسباب خیمه، ");
INSERT INTO pesOPV_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","و خوان و اسبابش و چراغدان طاهر و همه اسبابش و مذبح بخور، ");
INSERT INTO pesOPV_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","و مذبح قربانی سوختنی و همه اسبابش، و حوض وپایه‌اش، ");
INSERT INTO pesOPV_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","و لباس خدمت و لباس مقدس برای هارون کاهن، و لباس پسرانش بجهت کهانت، ");
INSERT INTO pesOPV_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","و روغن و مسح و بخور معطر بجهت قدس، موافق آنچه به تو امر فرموده‌ام، بسازند.» ");
INSERT INTO pesOPV_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","و خداوند موسی را خطاب کرده، گفت: ");
INSERT INTO pesOPV_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","«و تو بنی‌اسرائیل را مخاطب ساخته، بگو: البته سبت های مرا نگاه دارید. زیرا که این در میان من وشما در نسلهای شما آیتی خواهد بود تا بدانید که من یهوه هستم که شما را تقدیس می‌کنم. ");
INSERT INTO pesOPV_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","پس سبت را نگاه دارید، زیرا که برای شما مقدس است، هر‌که آن را بی‌حرمت کند، هرآینه کشته شود، و هر‌که در آن کار کند، آن شخص از میان قوم خود منقطع شود. ");
INSERT INTO pesOPV_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","شش روز کار کرده شود، و در روز هفتم سبت آرام و مقدس خداونداست. هر‌که در روز سبت کار کند، هرآینه کشته شود. ");
INSERT INTO pesOPV_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","پس بنی‌اسرائیل سبت را نگاه بدارند، نسلا بعد نسل سبت را به عهد ابدی مرعی دارند. ");
INSERT INTO pesOPV_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","این در میان من و بنی‌اسرائیل آیتی ابدی است، زیرا که در شش روز، خداوند آسمان و زمین راساخت و در روز هفتمین آرام فرموده، استراحت یافت.» ");
INSERT INTO pesOPV_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","و چون گفتگو را با موسی در کوه سینابپایان برد، دو لوح شهادت، یعنی دو لوح سنگ مرقوم به انگشت خدا را به وی داد. ");
INSERT INTO pesOPV_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","و چون قوم دیدند که موسی در فرودآمدن از کوه تاخیر نمود، قوم نزدهارون جمع شده، وی را گفتند: «برخیز و برای ماخدایان بساز که پیش روی ما بخرامند، زیرا این مرد، موسی، که ما را از زمین مصر بیرون آورد، نمی دانیم او را چه شده است.» ");
INSERT INTO pesOPV_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","هارون بدیشان گفت: «گوشواره های طلا را که در گوش زنان و پسران و دختران شماست، بیرون کرده، نزد من بیاورید.» ");
INSERT INTO pesOPV_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","پس تمامی گوشواره های زرین را که در گوشهای ایشان بودبیرون کرده، نزد هارون آوردند. ");
INSERT INTO pesOPV_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","و آنها را ازدست ایشان گرفته، آن را با قلم نقش کرد، و از آن گوساله ریخته شده ساخت، و ایشان گفتند: «ای اسرائیل این خدایان تو می‌باشند، که تو را از زمین مصر بیرون آوردند.» ");
INSERT INTO pesOPV_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","و چون هارون این را بدید، مذبحی پیش آن بنا کرد و هارون ندا درداده، گفت: «فردا عید یهوه می‌باشد.» ");
INSERT INTO pesOPV_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","و بامدادان برخاسته، قربانی های سوختنی گذرانیدند، و هدایای سلامتی آوردند، و قوم برای خوردن و نوشیدن نشستند، و بجهت لعب برپا شدند. ");
INSERT INTO pesOPV_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","و خداوند به موسی گفت: «روانه شده، بزیر برو، زیرا که این قوم تو که از زمین مصر بیرون آورده‌ای، فاسدشده‌اند. ");
INSERT INTO pesOPV_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","و به زودی از آن طریقی که بدیشان امرفرموده‌ام، انحراف ورزیده، گوساله ریخته شده برای خویشتن ساخته‌اند، و نزد آن سجده کرده، وقربانی گذرانیده، می‌گویند که‌ای اسرائیل این خدایان تو می‌باشند که تو را از زمین مصر بیرون آورده‌اند.» ");
INSERT INTO pesOPV_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","و خداوند به موسی گفت: «این قوم را دیده‌ام و اینک قوم گردنکش می‌باشند. ");
INSERT INTO pesOPV_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","واکنون مرا بگذار تا خشم من بر ایشان مشتعل شده، ایشان را هلاک کنم و تو را قوم عظیم خواهم ساخت.» ");
INSERT INTO pesOPV_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","پس موسی نزد یهوه، خدای خود تضرع کرده، گفت: «ای خداوند چرا خشم تو بر قوم خود که با قوت عظیم و دست زورآور اززمین مصر بیرون آورده‌ای، مشتعل شده است؟ ");
INSERT INTO pesOPV_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","چرا مصریان این سخن گویند که ایشان را برای بدی بیرون آورد، تا ایشان را در کوهها بکشد، و ازروی زمین تلف کند؟ پس از شدت خشم خودبرگرد، و از این قصد بدی قوم خویش رجوع فرما. ");
INSERT INTO pesOPV_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","بندگان خود ابراهیم و اسحاق و اسرائیل را بیادآور، که برای ایشان به ذات خود قسم خورده، بدیشان گفتی که ذریت شما را مثل ستارگان آسمان کثیر گردانم، و تمامی این زمین را که درباره آن سخن گفته‌ام به ذریت شما بخشم، تا آن را متصرف شوند تا ابدالاباد.» ");
INSERT INTO pesOPV_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","پس خداوند ازآن بدی که گفته بود که به قوم خود برساند، رجوع فرمود. ");
INSERT INTO pesOPV_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","آنگاه موسی برگشته، از کوه به زیر آمد، ودو لوح شهادت به‌دست وی بود، و لوحها به هردو طرف نوشته بود، بدین طرف و بدان طرف مرقوم بود. ");
INSERT INTO pesOPV_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","و لوح‌ها صنعت خدا بود، و نوشته، نوشته خدا بود، منقوش بر لوح‌ها. ");
INSERT INTO pesOPV_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","و چون یوشع آواز قوم را که می‌خروشیدند شنید، به موسی گفت: «در اردو صدای جنگ است.» ");
INSERT INTO pesOPV_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","گفت: «صدای خروش ظفر نیست، و صدای خروش شکست نیست، بلکه آواز مغنیان را من می‌شنوم.» ");
INSERT INTO pesOPV_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","و واقع شد که چون نزدیک به اردو رسید، وگوساله و رقص کنندگان را دید، خشم موسی مشتعل شد، و لوحها را از دست خود افکنده، آنها را زیر کوه شکست. ");
INSERT INTO pesOPV_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","و گوساله‌ای را که ساخته بودند گرفته، به آتش سوزانید، و آن راخرد کرده، نرم ساخت، و بر روی آب پاشیده، بنی‌اسرائیل را نوشانید. ");
INSERT INTO pesOPV_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","و موسی به هارون گفت: «این قوم به تو چه کرده بودند که گناه عظیمی بر ایشان آوردی؟» ");
INSERT INTO pesOPV_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","هارون گفت: «خشم آقایم افروخته نشود، تو این قوم رامی شناسی که مایل به بدی می‌باشند. ");
INSERT INTO pesOPV_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","و به من گفتند، برای ما خدایان بساز که پیش روی مابخرامند، زیرا که این مرد، موسی، که ما را از زمین مصر بیرون آورده است، نمی دانیم او را چه شده. ");
INSERT INTO pesOPV_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","بدیشان گفتم هر‌که را طلا باشد آن را بیرون کند، پس به من دادند، و آن را در آتش انداختم واین گوساله بیرون آمد.» ");
INSERT INTO pesOPV_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","و چون موسی قوم رادید که بی‌لگام شده‌اند، زیرا که هارون ایشان رابرای رسوایی ایشان در میان دشمنان ایشان بی‌لگام ساخته بود، ");
INSERT INTO pesOPV_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","آنگاه موسی به دروازه اردو ایستاده، گفت: «هر‌که به طرف خداوندباشد، نزد من آید.» پس جمیع بنی لاوی نزد وی جمع شدند. ");
INSERT INTO pesOPV_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","او بدیشان گفت: «یهوه، خدای اسرائیل، چنین می‌گوید: هر کس شمشیر خود رابر ران خویش بگذارد، و از دروازه تا دروازه اردوآمد و رفت کند، و هر کس برادر خود و دوست خویش و همسایه خود را بکشد.» ");
INSERT INTO pesOPV_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","و بنی لاوی موافق سخن موسی کردند. و در آن روز قریب سه هزار نفر از قوم افتادند. ");
INSERT INTO pesOPV_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","و موسی گفت: «امروزخویشتن را برای خداوند تخصیص نمایید. حتی هر کس به پسر خود و به برادر خویش، تا امروزشما را برکت دهد.» ");
INSERT INTO pesOPV_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","و بامدادان واقع شد که موسی به قوم گفت: «شما گناهی عظیم کرده‌اید. اکنون نزد خداوندبالا می‌روم، شاید گناه شما را کفاره کنم.» ");
INSERT INTO pesOPV_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","پس موسی به حضور خداوند برگشت و گفت: «آه، این قوم گناهی عظیم کرده، و خدایان طلا برای خویشتن ساخته‌اند. ");
INSERT INTO pesOPV_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","الان هرگاه گناه ایشان رامی آمرزی و اگرنه مرا از دفترت که نوشته‌ای، محو ساز.» ");
INSERT INTO pesOPV_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","خداوند به موسی گفت: «هر‌که گناه کرده است، او را از دفتر خود محو سازم. ");
INSERT INTO pesOPV_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","واکنون برو و این قوم را بدانجایی که به تو گفته‌ام، راهنمایی کن. اینک فرشته من پیش روی توخواهد خرامید، لیکن در یوم تفقد من، گناه ایشان را از ایشان بازخواست خواهم کرد.» ");
INSERT INTO pesOPV_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","وخداوند قوم را مبتلا ساخت زیرا گوساله‌ای را که هارون ساخته بود، ساخته بودند. ");
INSERT INTO pesOPV_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","و خداوند به موسی گفت: «روانه شده، از اینجا کوچ کن، تو و این قوم که اززمین مصر برآورده‌ای، بدان زمینی که برای ابراهیم، اسحاق و یعقوب قسم خورده، گفته‌ام آن را به ذریت تو عطا خواهم کرد. ");
INSERT INTO pesOPV_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","و فرشته‌ای پیش روی تو می‌فرستم، و کنعانیان و اموریان و حتیان و فرزیان و حویان و یبوسیان را بیرون خواهم کرد. ");
INSERT INTO pesOPV_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","به زمینی که به شیر و شهد جاری است، زیرا که در میان شما نمی آیم، چونکه قوم گردن کش هستی، مبادا تو را در بین راه هلاک سازم.» ");
INSERT INTO pesOPV_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","وچون قوم این سخنان بد را شنیدند، ماتم گرفتند، و هیچکس زیور خود را برخود ننهاد. ");
INSERT INTO pesOPV_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","وخداوند به موسی گفت: «بنی‌اسرائیل را بگو: شماقوم گردن کش هستید؛ اگر لحظه‌ای در میان توآیم، همانا تو را هلاک سازم. پس اکنون زیورخود را از خود بیرون کن تا بدانم با تو چه کنم.» ");
INSERT INTO pesOPV_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","پس بنی‌اسرائیل زیورهای خود را از جبل حوریب از خود بیرون کردند. ");
INSERT INTO pesOPV_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","و موسی خیمه خود را برداشته، آن را بیرون لشکرگاه، دور از اردو زد، و آن را «خیمه اجتماع» نامید. و واقع شد که هر‌که طالب یهوه می‌بود، به خیمه اجتماع که خارج لشکرگاه بود، بیرون می‌رفت. ");
INSERT INTO pesOPV_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","و هنگامی که موسی به سوی خیمه بیرون می‌رفت، تمامی قوم برخاسته، هر یکی به در خیمه خود می‌ایستاد، و در عقب موسی می‌نگریست تا داخل خیمه می‌شد. ");
INSERT INTO pesOPV_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","و چون موسی به خیمه داخل می‌شد، ستون ابر نازل شده، به در خیمه می‌ایستاد، و خدا با موسی سخن می‌گفت. ");
INSERT INTO pesOPV_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","و چون تمامی قوم، ستون ابر رابر در خیمه ایستاده می‌دیدند، همه قوم برخاسته، هر کس به در خیمه خود سجده می‌کرد. ");
INSERT INTO pesOPV_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","وخداوند با موسی روبرو سخن می‌گفت، مثل شخصی که با دوست خود سخن گوید. پس به اردو بر می‌گشت. اما خادم او یوشع بن نون جوان، از میان خیمه بیرون نمی آمد. ");
INSERT INTO pesOPV_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","و موسی به خداوند گفت: «اینک تو به من می‌گویی: این قوم را ببر. و تو مرا خبر نمی دهی که همراه من که را می‌فرستی. و تو گفته‌ای، تو را به نام می‌شناسم، و ایض در حضور من فیض یافته‌ای. ");
INSERT INTO pesOPV_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","الان اگر فی الحقیقه منظور نظر توشده‌ام، طریق خود را به من بیاموز تا تو رابشناسم، و در حضور تو فیض یابم، و ملاحظه بفرما که این طایفه، قوم تو می‌باشند.» ");
INSERT INTO pesOPV_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","گفت: «روی من خواهد آمد و تو را آرامی خواهم بخشید.» ");
INSERT INTO pesOPV_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","به وی عرض کرد: «هر گاه روی تونیاید، ما را از اینجا مبر. ");
INSERT INTO pesOPV_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","زیرا به چه چیز معلوم می‌شود که من و قوم تو منظور نظر تو شده‌ایم، آیانه از آمدن تو با ما؟ پس من و قوم تو از جمیع قومهایی که بر روی زمینند، ممتاز خواهیم شد.» ");
INSERT INTO pesOPV_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","خداوند به موسی گفت: «این کار را نیز که گفته‌ای خواهم کرد، زیرا که در نظر من فیض یافته‌ای و تو را بنام می‌شناسم.» ");
INSERT INTO pesOPV_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","عرض کرد: «مستدعی آنکه جلال خود را به من بنمایی.» ");
INSERT INTO pesOPV_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","گفت: «من تمامی احسان خود را پیش روی تومی گذرانم و نام یهوه را پیش روی تو ندا می‌کنم، و رافت می‌کنم بر هر‌که رئوف هستم و رحمت خواهم کرد بر هر‌که رحیم هستم. ");
INSERT INTO pesOPV_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","و گفت روی مرا نمی توانی دید، زیرا انسان نمی تواند مرا ببیندو زنده بماند.» ");
INSERT INTO pesOPV_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","و خداوند گفت: «اینک مقامی نزد من است. پس بر صخره بایست. ");
INSERT INTO pesOPV_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","و واقع می‌شود که چون جلال من می‌گذرد، تو را درشکاف صخره می‌گذارم، و تو را به‌دست خودخواهم پوشانید تا عبور کنم. ");
INSERT INTO pesOPV_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","پس دست خودرا خواهم برداشت تا قفای مرا ببینی، اما روی من دیده نمی شود.» ");
INSERT INTO pesOPV_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","و خداوند به موسی گفت: «دو لوح سنگی مثل اولین برای خود بتراش، وسخنانی را که بر لوح های اول بود و شکستی براین لوح‌ها خواهم نوشت. ");
INSERT INTO pesOPV_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","و بامدادان حاضر شوو صبحگاهان به کوه سینا بالا بیا، و در آنجا نزد من بر قله کوه بایست. ");
INSERT INTO pesOPV_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","و هیچکس با تو بالا نیاید، وهیچکس نیز در تمامی کوه دیده نشود، و گله ورمه نیز به طرف این کوه چرا نکند.» ");
INSERT INTO pesOPV_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","پس موسی دو لوح سنگی مثل اولین تراشید و بامدادان برخاسته، به کوه سینا بالا آمد، چنانکه خداوند اورا امر فرموده بود، و دو لوح سنگی را به‌دست خود برداشت. ");
INSERT INTO pesOPV_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","و خداوند در ابر نازل شده، درآنجا با وی بایستاد، و به نام خداوند ندا درداد. ");
INSERT INTO pesOPV_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","وخداوند پیش روی وی عبور کرده، ندا درداد که «یهوه، یهوه، خدای رحیم و رئوف و دیرخشم وکثیر احسان و وفا، ");
INSERT INTO pesOPV_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","نگاه دارنده رحمت برای هزاران، و آمرزنده خطا و عصیان و گناه، لکن گناه را هرگز بی‌سزا نخواهد گذاشت، بلکه خطایای پدران را بر پسران و پسران پسران ایشان تا پشت سوم و چهارم خواهد گرفت.» ");
INSERT INTO pesOPV_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","و موسی به زودی رو به زمین نهاده، سجده کرد. ");
INSERT INTO pesOPV_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","و گفت: «ای خداوند اگر فی الحقیقه منظور نظر تو شده‌ام، مستدعی آنکه خداوند در میان ما بیاید، زیرا که این قوم گردنکش می‌باشند، پس خطا و گناه ما رابیامرز و ما را میراث خود بساز.» ");
INSERT INTO pesOPV_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","گفت: «اینک عهدی می‌بندم و در نظرتمامی قوم تو کارهای عجیب می‌کنم، که درتمامی جهان و در جمیع امتها کرده نشده باشد، وتمامی این قومی که تو در میان ایشان هستی، کارخداوند را خواهند دید، زیراکه این کاری که با توخواهم کرد، کاری هولناک است. ");
INSERT INTO pesOPV_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","آنچه را من امروز به تو امر می‌فرمایم، نگاه دار. اینک من ازپیش روی تو اموریان و کنعانیان و حتیان و فرزیان و حویان و یبوسیان را خواهم راند. ");
INSERT INTO pesOPV_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","با حذرباش که با ساکنان آن زمین که تو بدانجا می‌روی، عهد نبندی، مبادا در میان شما دامی باشد. ");
INSERT INTO pesOPV_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","بلکه مذبحهای ایشان را منهدم سازید، و بتهای ایشان را بشکنید و اشیریم ایشان را قطع نمایید. ");
INSERT INTO pesOPV_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","زنهارخدای غیر را عبادت منما، زیرا یهوه که نام اوغیور است، خدای غیور است. ");
INSERT INTO pesOPV_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","زنهار با ساکنان آن زمین عهد مبند، والا از عقب خدایان ایشان زنا می کنند، و نزد خدایان ایشان قربانی می‌گذرانند، و تو را دعوت می‌نمایند و از قربانی های ایشان می‌خوری. ");
INSERT INTO pesOPV_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","و از دختران ایشان برای پسران خود می‌گیری، و چون دختران ایشان از عقب خدایان خود زنا کنند، آنگاه پسران شما را درپیروی خدایان خود مرتکب زنا خواهند نمود. ");
INSERT INTO pesOPV_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","خدایان ریخته شده برای خویشتن مساز. ");
INSERT INTO pesOPV_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","عید فطیر را نگاه دار، و هفت روز نان فطیرچنانکه تو را امر فرمودم، در وقت معین در ماه ابیب بخور، زیراکه در ماه ابیب از مصر بیرون آمدی. ");
INSERT INTO pesOPV_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","هر‌که رحم را گشاید، از آن من است وهر‌که نخست زاده ذکور از مواشی تو، چه از گاوچه از گوسفند، ");
INSERT INTO pesOPV_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","و برای نخست زاده الاغ، بره‌ای فدیه بده، و اگر فدیه ندهی، گردنش را بشکن و هرنخست زاده‌ای از پسرانت را فدیه بده. و هیچکس به حضور من تهی‌دست حاضر نشود. ");
INSERT INTO pesOPV_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","شش روز مشغول باش، و روز هفتمین، سبت را نگاه دار. در وقت شیار و در حصاد، سبت را نگاه دار. ");
INSERT INTO pesOPV_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","و عید هفته‌ها را نگاه دار، یعنی عید نوبر حصادگندم و عید جمع در تحویل سال. ");
INSERT INTO pesOPV_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","سالی سه مرتبه همه ذکورانت به حضور خداوند یهوه، خدای اسرائیل، حاضر شوند. ");
INSERT INTO pesOPV_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","زیرا که امتها رااز پیش روی تو خواهم راند، و حدود تو را وسیع خواهم گردانید، و هنگامی که در هر سال سه مرتبه می‌آیی تا به حضور یهوه، خدای خودحاضر شوی، هیچکس زمین تو را طمع نخواهدکرد. ");
INSERT INTO pesOPV_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","خون قربانی مرا با خمیرمایه مگذران، و قربانی عید فصح تا صبح نماند. ");
INSERT INTO pesOPV_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","نخستین نوبرزمین خود را به خانه یهوه، خدای خود، بیاور. وبزغاله را در شیر مادرش مپز.» ");
INSERT INTO pesOPV_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","و خداوند به موسی گفت: «این سخنان را تو بنویس، زیرا که به حسب این سخنان، عهد با تو و با اسرائیل بسته‌ام.» ");
INSERT INTO pesOPV_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","و چهل روز و چهل شب آنجا نزدخداوند بوده، نان نخورد و آب ننوشید و اوسخنان عهد، یعنی ده کلام را بر لوحها نوشت. ");
INSERT INTO pesOPV_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","و چون موسی از کوه سینا بزیر می‌آمد، ودو لوح سنگی در دست موسی بود، هنگامی که ازکوه بزیر می‌آمد، واقع شد که موسی ندانست که به‌سبب گفتگوی با او پوست چهره وی می‌درخشید. ");
INSERT INTO pesOPV_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","اما هارون و جمیع بنی‌اسرائیل موسی را دیدند که اینک پوست چهره اومی درخشد. پس ترسیدند که نزدیک او بیایند. ");
INSERT INTO pesOPV_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","و موسی ایشان را خواند، و هارون و همه سرداران جماعت نزد او برگشتند، و موسی بدیشان سخن گفت. ");
INSERT INTO pesOPV_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","و بعد از آن همه بنی‌اسرائیل نزدیک آمدند، و آنچه خداوند درکوه سینا بدو گفته بود، بدیشان امر فرمود. ");
INSERT INTO pesOPV_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","وچون موسی از سخن‌گفتن با ایشان فارغ شد، نقابی بر روی خود کشید. ");
INSERT INTO pesOPV_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","و چون موسی به حضورخداوند داخل می‌شد که با وی گفتگو کند، نقاب را برمی داشت تا بیرون آمدن او. پس بیرون آمده، آنچه به وی امر شده بود، به بنی‌اسرائیل می‌گفت. ");
INSERT INTO pesOPV_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","و بنی‌اسرائیل روی موسی را می‌دیدند که پوست چهره او می‌درخشد. پس موسی نقاب را به روی خود باز می‌کشید، تا وقتی که برای گفتگوی او می‌رفت. ");
INSERT INTO pesOPV_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","و موسی تمام جماعت بنی‌اسرائیل را جمع کرده، بدیشان گفت: «این است سخنانی که خداوند امر فرموده است که آنها رابکنی: ");
INSERT INTO pesOPV_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","شش روز کار کرده شود، و در روزهفتمین، سبت آرامی مقدس خداوند برای شماست؛ هر‌که در آن کاری کند، کشته شود. ");
INSERT INTO pesOPV_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","درروز سبت آتش در همه مسکنهای خودمیفروزید.» ");
INSERT INTO pesOPV_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","و موسی تمامی جماعت بنی‌اسرائیل راخطاب کرده، گفت: «این است امری که خداوندفرموده، و گفته است: ");
INSERT INTO pesOPV_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","از خودتان هدیه‌ای برای خداوند بگیرید. هر‌که از دل راغب است، هدیه خداوند را از طلا و نقره و برنج بیاورد، ");
INSERT INTO pesOPV_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","و ازلاجورد و ارغوان و قرمز و کتان نازک و پشم بز، ");
INSERT INTO pesOPV_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","و پوست قوچ سرخ شده و پوست خز و چوب شطیم، ");
INSERT INTO pesOPV_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","و روغن برای روشنایی، و عطریات برای روغن مسح و برای بخور معطر، ");
INSERT INTO pesOPV_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","وسنگهای جزع و سنگهای ترصیع برای ایفود وسینه بند.» ");
INSERT INTO pesOPV_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","و همه دانادلان از شما بیایند و آنچه را خداوند امر فرموده است، بسازند. ");
INSERT INTO pesOPV_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","مسکن وخیمه‌اش و پوشش آن و تکمه هایش وتخته هایش و پشت بندهایش و ستونهایش وپایه هایش، ");
INSERT INTO pesOPV_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","و تابوت و عصاهایش و کرسی رحمت و حجاب ستر، ");
INSERT INTO pesOPV_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","و خوان و عصاهایش و کل اسبابش و نان تقدمه، ");
INSERT INTO pesOPV_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","و چراغدان برای روشنایی و اسبابش و چراغهایش و روغن برای روشنایی، ");
INSERT INTO pesOPV_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","و مذبح بخور و عصاهایش و روغن مسح و بخور معطر، و پرده دروازه برای درگاه مسکن، ");
INSERT INTO pesOPV_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","و مذبح قربانی سوختنی و شبکه برنجین آن، و عصاهایش و کل اسبابش و حوض و پایه‌اش، ");
INSERT INTO pesOPV_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","و پرده های صحن و ستونهایش وپایه های آنها و پرده دروازه صحن، ");
INSERT INTO pesOPV_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","و میخهای مسکن و میخهای صحن و طنابهای آنها، ");
INSERT INTO pesOPV_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","ورختهای بافته شده برای خدمت قدس، یعنی رخت مقدس هارون کاهن، و رختهای پسرانش راتا کهانت نمایند.» ");
INSERT INTO pesOPV_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","پس تمامی جماعت بنی‌اسرائیل از حضورموسی بیرون شدند. ");
INSERT INTO pesOPV_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","و هر‌که دلش او را ترغیب کرد، و هر‌که روحش او را با اراده گردانید، آمدندو هدیه خداوند را برای کار خیمه اجتماع، و برای تمام خدمتش و برای رختهای مقدس آوردند. ");
INSERT INTO pesOPV_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","مردان و زنان آمدند، هر‌که از دل راغب بود، وحلقه های بینی و گوشواره‌ها و انگشتریها وگردن بندها و هر قسم آلات طلا آوردند، و هر‌که هدیه طلا برای خداوند گذرانیده بود. ");
INSERT INTO pesOPV_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","و هرکسی‌که لاجورد و ارغوان و قرمز و کتان نازک وپشم بز و پوست قوچ سرخ شده و پوست خز نزداو یافت شد، آنها را آورد. ");
INSERT INTO pesOPV_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","هر‌که خواست هدیه نقره و برنج بیاورد، هدیه خداوند را آورد، وهر‌که چوب شطیم برای هر کار خدمت نزد اویافت شد، آن را آورد. ");
INSERT INTO pesOPV_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","و همه زنان دانادل به‌دستهای خود می‌رشتند، و رشته شده را ازلاجورد و ارغوان و قرمز و کتان نازک، آوردند. ");
INSERT INTO pesOPV_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","و همه زنانی که دل ایشان به حکمت مایل بود، پشم بز را می‌رشتند. ");
INSERT INTO pesOPV_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","و سروران، سنگهای جزع و سنگهای ترصیع برای ایفود و سینه بندآوردند. ");
INSERT INTO pesOPV_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","و عطریات و روغن برای روشنایی وبرای روغن مسح و برای بخور معطر. ");
INSERT INTO pesOPV_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","و همه مردان و زنان بنی‌اسرائیل که دل ایشان، ایشان راراغب ساخت که چیزی برای هر کاری که خداوند امر فرموده بود که به وسیله موسی ساخته شود، برای خداوند به اراده دل آوردند. ");
INSERT INTO pesOPV_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","و موسی بنی‌اسرائیل را گفت: «آگاه باشیدکه خداوند بصلئیل بن اوری بن حور را از سبطیهودا به نام دعوت کرده است. ");
INSERT INTO pesOPV_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","و او را به روح خدا از حکمت و فطانت و علم و هر هنری پرساخته، ");
INSERT INTO pesOPV_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","و برای اختراع مخترعات و برای کارکردن در طلا و نقره و برنج، ");
INSERT INTO pesOPV_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","و برای تراشیدن ومرصع ساختن سنگها، و برای درودگری چوب تاهر صنعت هنری را بکند. ");
INSERT INTO pesOPV_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","و در دل او تعلیم دادن را القا نمود، و همچنین اهولیاب بن اخیسامک را از سبط دان، ");
INSERT INTO pesOPV_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","و ایشان را به حکمت دلی پر ساخت، برای هر عمل نقاش ونساج ماهر و طراز در لاجورد و ارغوان و قرمز وکتان نازک، و در هر کار نساج تا صانع هر صنعتی ومخترع مخترعات بشوند. ");
INSERT INTO pesOPV_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","«و بصلئیل و اهولیاب و همه دانادلانی که خداوند حکمت و فطانت بدیشان داده است، تا برای کردن هر صنعت خدمت قدس، ماهر باشند، موافق آنچه خداوند امرفرموده است، کار بکنند.» ");
INSERT INTO pesOPV_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","پس موسی، بصلئیل واهولیاب و همه دانادلانی را که خداوند در دل ایشان حکمت داده بود، و آنانی را که دل ایشان، ایشان را راغب ساخته بود که برای کردن کارنزدیک بیایند، دعوت کرد. ");
INSERT INTO pesOPV_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","و همه هدایایی را که بنی‌اسرائیل برای بجا آوردن کار خدمت قدس آورده بودند، از حضور موسی برداشتند، و هربامداد هدایای تبرعی دیگر نزد وی می‌آوردند. ");
INSERT INTO pesOPV_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","و همه دانایانی که هر گونه کار قدس رامی ساختند، هر یک از کار خود که در آن مشغول می‌بود، آمدند. ");
INSERT INTO pesOPV_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","و موسی را عرض کرده، گفتند: «قوم زیاده از آنچه لازم است برای عمل آن کاری که خداوند فرموده است که ساخته شود، می‌آورند.» ");
INSERT INTO pesOPV_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","و موسی فرمود تا در اردو ندا کرده، گویند که «مردان و زنان هیچ کاری دیگر برای هدایای قدس نکنند.» پس قوم از آوردن بازداشته شدند. ");
INSERT INTO pesOPV_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","و اسباب برای انجام تمام کار، کافی، بلکه زیاده بود. ");
INSERT INTO pesOPV_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","پس همه دانادلانی که در کار اشتغال داشتند، ده پرده مسکن را ساختند، از کتان نازک تابیده شده و لاجورد و ارغوان و قرمز، و آنها را باکروبیان از صنعت نساج ماهر ترتیب دادند. ");
INSERT INTO pesOPV_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","طول هر پرده بیست و هشت ذراع، و عرض هر پرده چهار ذراع. همه پرده‌ها را یک اندازه بود. ");
INSERT INTO pesOPV_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","وپنج پرده را با یکدیگر بپیوست، و پنج پرده را بایکدیگر بپیوست، ");
INSERT INTO pesOPV_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","و بر لب یک پرده در کنارپیوستگی‌اش مادگیهای لاجورد ساخت، وهمچنین در لب پرده بیرونی در‌پیوستگی دوم ساخت. ");
INSERT INTO pesOPV_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","و در یک پرده، پنجاه مادگی ساخت، و در کنار پرده‌ای که در‌پیوستگی دومین بود، پنجاه مادگی ساخت. و مادگیها مقابل یکدیگربود. ");
INSERT INTO pesOPV_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","و پنجاه تکمه زرین ساخت، و پرده‌ها را به تکمه‌ها با یکدیگر بپیوست، تا مسکن یک باشد. ");
INSERT INTO pesOPV_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","و پرده‌ها از پشم بز ساخت بجهت خیمه‌ای که بالای مسکن بود؛ آنها را پانزده پرده ساخت. ");
INSERT INTO pesOPV_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","طول هر پرده سی ذراع، و عرض هر پرده چهار ذراع؛ و یازده پرده را یک اندازه بود. ");
INSERT INTO pesOPV_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","وپنج پرده را جدا پیوست، و شش پرده را جدا. ");
INSERT INTO pesOPV_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","وپنجاه مادگی بر کنار پرده‌ای که در‌پیوستگی بیرونی بود ساخت، و پنجاه مادگی در کنار پرده در‌پیوستگی دوم. ");
INSERT INTO pesOPV_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","و پنجاه تکمه برنجین برای پیوستن خیمه بساخت تا یک باشد. ");
INSERT INTO pesOPV_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","و پوششی از پوست قوچ سرخ شده برای خیمه ساخت، وپوششی بر زبر آن از پوست خز. ");
INSERT INTO pesOPV_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","و تخته های قایم از چوب شطیم برای مسکن ساخت. ");
INSERT INTO pesOPV_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","طول هر تخته ده ذراع، وعرض هر تخته یک ذراع و نیم. ");
INSERT INTO pesOPV_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","هر تخته را دوزبانه بود مقرون یکدیگر، و بدین ترکیب همه تخته های مسکن را ساخت. ");
INSERT INTO pesOPV_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","و تخته های مسکن را ساخت، بیست تخته به‌جانب جنوب به طرف یمانی، ");
INSERT INTO pesOPV_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","و چهل پایه نقره زیر بیست تخته ساخت، یعنی دو پایه زیر تخته‌ای برای دوزبانه‌اش، و دو پایه زیر تخته دیگر برای دوزبانه‌اش. ");
INSERT INTO pesOPV_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","و برای جانب دیگر مسکن به طرف شمال، بیست تخته ساخت. ");
INSERT INTO pesOPV_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","و چهل پایه نقره آنها را یعنی دو پایه زیر یک تخته‌ای و دو پایه زیرتخته دیگر. ");
INSERT INTO pesOPV_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","و برای موخر مسکن به طرف مغرب، شش تخته ساخت. ");
INSERT INTO pesOPV_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","و دو تخته برای گوشه های مسکن در هر دو جانبش ساخت. ");
INSERT INTO pesOPV_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","واز زیر با یکدیگر پیوسته شد، و تا سر آن با هم دریک حلقه تمام شد. و همچنین برای هر دو در هردو گوشه کرد. ");
INSERT INTO pesOPV_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","پس هشت تخته بود، و پایه های آنها از نقره شانزده پایه، یعنی دو پایه زیر هرتخته. ");
INSERT INTO pesOPV_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","و پشت بندها از چوب شطیم ساخت، یعنی پنج برای تخته های یک جانب مسکن، ");
INSERT INTO pesOPV_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","و پنج پشت بند برای تخته های جانب دیگر مسکن، وپنج پشت بند برای تخته های موخر جانب غربی مسکن. ");
INSERT INTO pesOPV_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","و پشت بند وسطی را ساخت تا در میان تخته‌ها از سر تا سر بگذرد. ");
INSERT INTO pesOPV_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","تخته‌ها را به طلاپوشانید، و حلقه های آنها را از طلا ساخت تابرای پشت بندها، خانه‌ها باشد، و پشت بندها را به طلا پوشانید. ");
INSERT INTO pesOPV_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","و حجاب را از لاجورد و ارغوان و قرمز و کتان نازک تابیده شده ساخت، و آن را باکروبیان از صنعت نساج ماهر ترتیب داد. ");
INSERT INTO pesOPV_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","وچهار ستون از چوب شطیم برایش ساخت، و آنهارا به طلا پوشانید و قلابهای آنها از طلا بود، وبرای آنها چهار پایه نقره ریخت. ");
INSERT INTO pesOPV_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","و پرده‌ای برای دروازه خیمه از لاجورد و ارغوان و قرمز وکتان نازک تابیده شده از صنعت طراز بساخت. ");
INSERT INTO pesOPV_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","و پنج ستون آن و قلابهای آنها را ساخت وسرها و عصاهای آنها را به طلا پوشانید و پنج پایه آنها از برنج بود. ");
INSERT INTO pesOPV_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","و بصلئیل، تابوت را از چوب شطیم ساخت، طولش دو ذراع و نیم، وعرضش یک ذراع و نیم، و بلندیش یک ذراع ونیم. ");
INSERT INTO pesOPV_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","و آن را به طلای خالص از درون و بیرون پوشانید. و برای آن تاجی از طلا بر طرفش ساخت. ");
INSERT INTO pesOPV_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","و چهار حلقه زرین برای چهارقایمه‌اش بریخت، یعنی دو حلقه بر یک طرفش ودو حلقه بر طرف دیگر. ");
INSERT INTO pesOPV_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","و دو عصا از چوب شطیم ساخته، آنها را به طلا پوشانید. ");
INSERT INTO pesOPV_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","و عصاهارا در حلقه‌ها بر دو جانب تابوت گذرانید، برای برداشتن تابوت. ");
INSERT INTO pesOPV_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","و کرسی رحمت را از طلای خالص ساخت. طولش دو ذراع و نیم، و عرضش یک ذراع و نیم. ");
INSERT INTO pesOPV_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","و دو کروبی از طلا ساخت. وآنها را بر هر دو طرف کرسی رحمت ازچرخکاری ساخت. ");
INSERT INTO pesOPV_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","یک کروبی بر این طرف و کروبی دیگر بر آن طرف، و از کرسی رحمت، کروبیان را بر هر دو طرفش ساخت. ");
INSERT INTO pesOPV_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","و کروبیان بالهای خود را بر زبر آن پهن می‌کردند، و به بالهای خویش کرسی رحمت را می‌پوشانیدند، ورویهای ایشان به سوی یکدیگر می‌بود، یعنی رویهای کروبیان به‌جانب کرسی رحمت می‌بود. ");
INSERT INTO pesOPV_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","و خوان را از چوب شطیم ساخت. طولش دو ذراع، و عرضش یک ذراع، و بلندیش یک ذراع و نیم. ");
INSERT INTO pesOPV_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","و آن را به طلای خالص پوشانید، وتاجی زرین گرداگردش ساخت. ");
INSERT INTO pesOPV_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","و حاشیه‌ای به مقدار چهار انگشت گرداگردش ساخت، و تاجی زرین گرداگرد حاشیه ساخت. ");
INSERT INTO pesOPV_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","و چهار حلقه زرین برایش ریخت، و حلقه‌ها را بر چهارگوشه‌ای که بر چهار قایمه‌اش بود گذاشت. ");
INSERT INTO pesOPV_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","وحلقه‌ها مقابل حاشیه بود، تا خانه های عصاهاباشد، برای برداشتن خوان. ");
INSERT INTO pesOPV_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","و دو عصا را ازچوب شطیم ساخته، آنها را به طلا پوشانید، برای برداشتن خوان. ");
INSERT INTO pesOPV_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","و ظروفی را که بر خوان می‌بوداز صحنها و کاسه‌ها و پیاله‌ها و جامهایش که بدانها هدایای ریختنی می‌ریختند، از طلای خالص ساخت. ");
INSERT INTO pesOPV_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","و چراغدان را از طلای خالص ساخت. ازچرخکاری، چراغدان را ساخت، و پایه‌اش وشاخه هایش و پیاله هایش و سیبهایش و گلهایش از همین بود. ");
INSERT INTO pesOPV_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","و از دو طرفش شش شاخه بیرون آمد، یعنی سه شاخه چراغدان از یک طرف، و سه شاخه چراغدان از طرف دیگر. ");
INSERT INTO pesOPV_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","و سه پیاله بادامی با سیبی و گلی در یک شاخه، و سه پیاله بادامی و سیبی و گلی بر شاخه دیگر، و همچنین برای شش شاخه‌ای که از چراغدان بیرون می‌آمد. ");
INSERT INTO pesOPV_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","و بر چراغدان چهار پیاله بادامی باسیبها و گلهای آن. ");
INSERT INTO pesOPV_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","و سیبی زیر دو شاخه آن، وسیبی زیر دو شاخه آن، و سیبی زیر دو شاخه آن، برای شش شاخه‌ای که از آن بیرون می‌آمد. ");
INSERT INTO pesOPV_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","سیبهای آنها و شاخه های آنها از همین بود، یعنی همه از یک چرخکاری طلای خالص. ");
INSERT INTO pesOPV_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","وهفت چراغش و گلگیرهایش و سینیهایش را ازطلای خالص ساخت. ");
INSERT INTO pesOPV_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","از یک وزنه طلای خالص آن را با همه اسبابش ساخت. ");
INSERT INTO pesOPV_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","و مذبح بخور را از چوب شطیم ساخت، طولش یک ذراع، و عرضش یک ذراع مربع، وبلندیش دو ذراع، و شاخهایش از همان بود. ");
INSERT INTO pesOPV_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","وآن را به طلای خالص پوشانید، یعنی سطحش وطرفهای گرداگردش، و شاخهایش، و تاجی گرداگردش از طلای خالص ساخت. ");
INSERT INTO pesOPV_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","و دوحلقه زرین برایش زیر تاج بر دو گوشه‌اش بر دوطرفش ساخت، تا خانه های عصاها باشد برای برداشتنش به آنها. ");
INSERT INTO pesOPV_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","و عصاها را از چوب شطیم ساخته، آنها را به طلا پوشانید. ");
INSERT INTO pesOPV_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","و روغن مسح مقدس و بخور معطر طاهر را از صنعت عطارساخت. ");
INSERT INTO pesOPV_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","و مذبح قربانی سوختنی را از چوب شطیم ساخت. طولش پنج ذراع، وعرضش پنج ذراع مربع، و بلندیش سه ذراع. ");
INSERT INTO pesOPV_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","وشاخهایش را بر چهار گوشه‌اش ساخت. شاخهایش از همان بود و آن را از برنج پوشانید. ");
INSERT INTO pesOPV_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","و همه اسباب مذبح را ساخت، یعنی: دیگها وخاک اندازها و کاسه‌ها و چنگالها و مجمرها وهمه ظروفش را از برنج ساخت. ");
INSERT INTO pesOPV_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","و برای مذبح، آتش دانی مشبک از برنج ساخت، که زیرحاشیه‌اش بطرف پایین تا نصفش برسد. ");
INSERT INTO pesOPV_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","و چهارحلقه برای چهار سر آتش دان برنجین ریخت، تاخانه های عصاها باشد. ");
INSERT INTO pesOPV_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","و عصاها را از چوب شطیم ساخته، آنها را به برنج بپوشانید. ");
INSERT INTO pesOPV_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","و عصاهارا در حلقه‌ها بر دو طرف مذبح گذرانید، برای برداشتنش به آنها، و مذبح را از چوبها مجوف ساخت. ");
INSERT INTO pesOPV_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","و حوض را از برنج ساخت، و پایه‌اش را از برنج از آینه های زنانی که نزد دروازه خیمه اجتماع برای خدمت جمع می‌شدند. ");
INSERT INTO pesOPV_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","و صحن را ساخت که برای طرف جنوبی به سمت یمانی. پرده های صحن از کتان نازک تابیده شده صد ذراعی بود. ");
INSERT INTO pesOPV_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","ستونهای آنها بیست بود، و پایه های آنها بیست بود، از برنج و قلابهای آنهاو پشت بندهای آنها از نقره. ");
INSERT INTO pesOPV_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","و برای طرف شمالی صد ذراعی بود، و ستونهای آنها بیست ازبرنج، و قلابهای ستونها و پشت بندهای آنها ازنقره بود. ");
INSERT INTO pesOPV_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","و برای طرف غربی، پرده های پنجاه ذراعی بود، و ستونهای آنها ده و پایه های آنها ده، و قلابها و پشت بندهای ستونها از نقره بود. ");
INSERT INTO pesOPV_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","وبرای طرف شرقی به سمت طلوع، پنجاه ذراعی بود. ");
INSERT INTO pesOPV_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","و پرده های یک طرف دروازه پانزده ذراعی بود، ستونهای آنها سه و پایه های آنها سه. ");
INSERT INTO pesOPV_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","و برای طرف دیگر دروازه صحن از این طرف واز آن طرف پرده‌ها پانزده ذراعی بود، ستونهای آنها سه و پایه های آنها سه. ");
INSERT INTO pesOPV_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","همه پرده های صحن به هر طرف از کتان نازک تابیده شده بود. ");
INSERT INTO pesOPV_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","و پایه های ستونها از برنج بود، و قلابها وپشت بندهای ستونها از نقره، و پوشش سرهای آنها از نقره، و جمیع ستونهای صحن به پشت بندهای نقره پیوسته شده بود. ");
INSERT INTO pesOPV_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","و پرده دروازه صحن از صنعت طراز از لاجورد و ارغوان و قرمز و کتان نازک تابیده شده بود. طولش بیست ذراع، و بلندیش به عرض پنج ذراع موافق پرده های صحن. ");
INSERT INTO pesOPV_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","و ستونهای آنها چهار، وپایه های برنجین آنها چهار، و قلابهای آنها ازنقره، و پوشش سرهای آنها و پشت بندهای آنهااز نقره بود. ");
INSERT INTO pesOPV_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","و همه میخهای مسکن و صحن، به هر طرف از برنج بود. ");
INSERT INTO pesOPV_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","این است حساب مسکن، یعنی مسکن شهادت، چنانکه حسب فرمان موسی به خدمت لاویان، به توسط ایتاماربن هارون کاهن حساب آن گرفته شد. ");
INSERT INTO pesOPV_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","و بصلئیل بن اوری بن حور از سبطیهودا، آنچه را که خداوند به موسی‌امر فرموده بود بساخت. ");
INSERT INTO pesOPV_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","و با وی اهولیاب بن اخیسامک ازسبط دان بود، نقاش و مخترع و طراز در لاجورد وارغوان و قرمز و کتان نازک. ");
INSERT INTO pesOPV_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","و تمام طلایی که در کار صرف شد، یعنی در همه کار قدس، ازطلای هدایا بیست و نه وزنه و هفتصد و سی مثقال موافق مثقال قدس بود. ");
INSERT INTO pesOPV_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","و نقره شمرده شدگان جماعت صد وزنه و هزار و هفتصد وهفتاد و پنج مثقال بود، موافق مثقال قدس. ");
INSERT INTO pesOPV_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","یک درهم یعنی نیم مثقال موافق مثقال قدس، برای هر نفری از آنانی که به سوی شمرده شدگان گذشتند، از بیست ساله و بالاتر، که ششصد و سه هزار وپانصد و پنجاه نفر بودند. ");
INSERT INTO pesOPV_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","و اما آن صد وزنه نقره برای ریختن پایه های قدس و پایه های پرده بود. صد پایه از صد وزنه یعنی یک وزنه برای یک پایه. ");
INSERT INTO pesOPV_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","و از آن هزار و هفتصد و هفتاد و پنج مثقال قلابها برای ستونها ساخت، و سرهای آنهارا پوشانید، و پشت بندها برای آنها ساخت. ");
INSERT INTO pesOPV_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","وبرنج هدایا هفتاد وزنه و دو هزار و چهارصد مثقال بود. ");
INSERT INTO pesOPV_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","و از آن پایه های دروازه خیمه اجتماع، ومذبح برنجین، و شبکه برنجین آن و همه اسباب مذبح را ساخت. ");
INSERT INTO pesOPV_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","و پایه های صحن را به هرطرف، و پایه های دروازه صحن و همه میخهای مسکن و همه میخهای گرداگرد صحن را. ");
INSERT INTO pesOPV_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","و از لاجورد و ارغوان و قرمز رختهای بافته شده ساختند، برای خدمت کردن در قدس، و رختهای مقدس برای هارون ساختند، چنانکه خداوند به موسی‌امر نموده بود. ");
INSERT INTO pesOPV_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","و ایفود را از طلا و لاجورد و ارغوان و قرمزو کتان نازک تابیده شده، ساخت. ");
INSERT INTO pesOPV_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","و تنگه های نازک از طلا ساختند و تارها کشیدند تا آنها را درمیان لاجورد و ارغوان و قرمز و کتان نازک به صنعت نساج ماهر ببافند. ");
INSERT INTO pesOPV_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","و کتفهای پیوسته شده برایش ساختند، که بر دو کنار پیوسته شد. ");
INSERT INTO pesOPV_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","و زنار بسته شده‌ای که بر آن بود از همان پارچه واز همان صنعت بود، از طلا و لاجورد و ارغوان وقرمز و کتان نازک تابیده شده، چنانکه خداوند به موسی‌امر فرموده بود. ");
INSERT INTO pesOPV_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","و سنگهای جزع مرصع در دو طوق طلا، و منقوش به نقش خاتم، موافق نامهای بنی‌اسرائیل درست کردند. ");
INSERT INTO pesOPV_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","آنها را بر کتفهای ایفود نصب کرد، تا سنگهای یادگاری برای بنی‌اسرائیل باشد، چنانکه خداوند به موسی‌امر فرموده بود. ");
INSERT INTO pesOPV_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","و سینه بند را موافق کار ایفود از صنعت نساج ماهر ساخت، از طلا و لاجورد و ارغوان وقرمز و کتان نازک تابیده شده. ");
INSERT INTO pesOPV_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","و آن مربع بود وسینه بند را دولا ساختند طولش یک وجب وعرضش یک وجب دولا. ");
INSERT INTO pesOPV_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","و در آن چهار رسته سنگ نصب کردند، رسته‌ای از عقیق سرخ ویاقوت زرد و زمرد. این بود رسته اول. ");
INSERT INTO pesOPV_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","و رسته دوم از بهرمان و یاقوت کبود و عقیق سفید. ");
INSERT INTO pesOPV_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","ورسته سوم از عین الهر و یشم و جمست. ");
INSERT INTO pesOPV_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","ورسته چهارم از زبرجد و جزع و یشب در ترصیعه خود که به دیوارهای طلا احاطه شده بود. ");
INSERT INTO pesOPV_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","وسنگها موافق نامهای بنی‌اسرائیل دوازده بود، مطابق اسامی ایشان، مثل نقش خاتم، هر یکی به اسم خود برای دوازده سبط. ");
INSERT INTO pesOPV_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","و بر سینه بندزنجیرهای تابیده شده، مثل کار طنابها از طلای خالص ساختند. ");
INSERT INTO pesOPV_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","و دو طوق زرین و دو حلقه زرین ساختند و دو حلقه را بر دو سر سینه بندگذاشتند. ");
INSERT INTO pesOPV_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","و آن دو زنجیر تابیده شده زرین رادر دو حلقه‌ای که بر سرهای سینه بند بود، گذاشتند. ");
INSERT INTO pesOPV_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","و دو سر دیگر آن دو زنجیر را بر دوطوق گذاشتند، و آنها را بر دو کتف ایفود در‌پیش نصب کردند. ");
INSERT INTO pesOPV_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","و دو حلقه زرین ساختند، آنها رابر دو سر سینه بند گذاشتند، بر کناری که بر طرف اندرونی‌ایفود بود. ");
INSERT INTO pesOPV_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","و دو حلقه زرین دیگرساختند، و آنها را بر دو کتف ایفود، به طرف پایین، از جانب پیش، مقابل پیوستگیش بالای زنار ایفود گذاشتند. ");
INSERT INTO pesOPV_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","و سینه بند را به حلقه هایش با حلقه های ایفود به نوار لاجوردی بستند، تا بالای زنار ایفود باشد. و سینه بند از ایفود جدا نشود، چنانکه خداوند به موسی‌امرفرموده بود. ");
INSERT INTO pesOPV_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","و ردای ایفود را از صنعت نساج، تمام لاجوردی ساخت. ");
INSERT INTO pesOPV_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","و دهنه‌ای در وسط ردابود، مثل دهنه زره با حاشیه‌ای گرداگرد دهنه تادریده نشود. ");
INSERT INTO pesOPV_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","و بر دامن ردا، انارها از لاجورد وارغوان و قرمز و کتان تابیده شده ساختند. ");
INSERT INTO pesOPV_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","وزنگوله‌ها از طلای خالص ساختند. و زنگوله‌ها رادر میان انارها بر دامن ردا گذاشتند، گرداگردش درمیان انارها. ");
INSERT INTO pesOPV_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","و زنگوله‌ای و اناری، و زنگوله‌ای واناری گرداگرد دامن ردا برای خدمت کردن، چنانکه خداوند به موسی‌امر فرموده بود. ");
INSERT INTO pesOPV_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","وپیراهنها را برای هارون و پسرانش از کتان نازک ازصنعت نساج ساختند. ");
INSERT INTO pesOPV_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","و عمامه را از کتان نازک و دستارهای زیبا را از کتان نازک، و زیرجامهای کتانی را از کتان نازک تابیده شده. ");
INSERT INTO pesOPV_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","و کمربند رااز کتان نازک تابیده شده، و لاجورد و ارغوان وقرمز از صنعت طراز، چنانکه خداوند به موسی‌امر فرموده بود. ");
INSERT INTO pesOPV_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","و تنگه افسر مقدس را ازطلای خالص ساختند، و بر آن کتابتی مثل نقش خاتم مرقوم داشتند: قدوسیت برای یهوه. ");
INSERT INTO pesOPV_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","و برآن نواری لاجوردی بستند تا آن را بالای عمامه ببندند، چنانکه خداوند به موسی‌امر فرموده بود. ");
INSERT INTO pesOPV_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","پس همه کار مسکن خیمه اجتماع تمام شد، و بنی‌اسرائیل ساختند. موافق آنچه خداوندبه موسی‌امر فرموده بود، عمل نمودند. ");
INSERT INTO pesOPV_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","ومسکن خیمه را نزد موسی آوردند، با همه اسبابش و تکمه‌ها و تخته‌ها و پشت بندها وستونها و پایه هایش. ");
INSERT INTO pesOPV_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","و پوشش از پوست قوچ سرخ شده و پوشش از پوست خز و حجاب ستر. ");
INSERT INTO pesOPV_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","و تابوت شهادت و عصاهایش و کرسی رحمت. ");
INSERT INTO pesOPV_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","و خوان و همه اسبابش و نان تقدمه. ");
INSERT INTO pesOPV_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","و چراغدان طاهر و چراغهایش، چراغهای آراسته شده و همه اسبابش، و روغن برای روشنایی. ");
INSERT INTO pesOPV_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","و مذبح زرین و روغن مسح و بخورمعطر و پرده برای دروازه خیمه. ");
INSERT INTO pesOPV_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","و مذبح برنجین و شبکه برنجین آن، و عصاهایش و همه اسبابش و حوض و پایه‌اش. ");
INSERT INTO pesOPV_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","و پرده های صحن و ستونها و پایه هایش و پرده دروازه صحن، وطنابهایش و میخهایش و همه اسباب خدمت مسکن برای خیمه اجتماع. ");
INSERT INTO pesOPV_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","و رختهای بافته شده برای خدمت قدس، و رخت مقدس برای هارون کاهن، و رختها برای پسرانش تا کهانت نمایند. ");
INSERT INTO pesOPV_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","موافق آنچه خداوند به موسی‌امرفرموده بود، بنی‌اسرائیل همچنین تمام کار راساختند. ");
INSERT INTO pesOPV_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","و موسی تمام کارها را ملاحظه کرد، و اینک موافق آنچه خداوند امر فرموده بودساخته بودند، همچنین کرده بودند. و موسی ایشان را برکت داد. ");
INSERT INTO pesOPV_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","و خداوند موسی را خطاب کرده، گفت: ");
INSERT INTO pesOPV_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","«در غره ماه اول مسکن خیمه اجتماع را برپا نما. ");
INSERT INTO pesOPV_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","و تابوت شهادت را در آن بگذار. وحجاب را پیش تابوت پهن کن. ");
INSERT INTO pesOPV_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","و خوان رادرآورده، چیزهایی را که می‌باید، بر آن ترتیب نما. و چراغدان را درآور و چراغهایش را آراسته کن. ");
INSERT INTO pesOPV_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","و مذبح زرین را برای بخور پیش تابوت شهادت بگذار، و پرده دروازه را بر مسکن بیاویز. ");
INSERT INTO pesOPV_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","و مذبح قربانی سوختنی را پیش دروازه مسکن خیمه اجتماع بگذار. ");
INSERT INTO pesOPV_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","و حوض را در میان خیمه اجتماع و مذبح بگذار، و آب در آن بریز. ");
INSERT INTO pesOPV_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","و صحن را گرداگرد برپا کن. و پرده دروازه صحن رابیاویز. ");
INSERT INTO pesOPV_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","و روغن مسح را گرفته، مسکن را با آنچه در آن است مسح کن، و آن را با همه اسبابش تقدیس نما تا مقدس شود. ");
INSERT INTO pesOPV_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","و مذبح قربانی سوختنی را با همه اسبابش مسح کرده، مذبح راتقدیس نما. و مذبح، قدس اقداس خواهد بود. ");
INSERT INTO pesOPV_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","و حوض را با پایه‌اش مسح نموده، تقدیس کن. ");
INSERT INTO pesOPV_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","و هارون و پسرانش را نزد دروازه خیمه اجتماع آورده، ایشان را به آب غسل ده. ");
INSERT INTO pesOPV_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","وهارون را به رخت مقدس بپوشان، و او را مسح کرده، تقدیس نما، تا برای من کهانت کند. ");
INSERT INTO pesOPV_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","وپسرانش را نزدیک آورده، ایشان را به پیراهنهابپوشان. ");
INSERT INTO pesOPV_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","و ایشان را مسح کن، چنانکه پدرایشان را مسح کردی تا برای من کهانت نماید. ومسح ایشان هر آینه برای کهانت ابدی در نسلهای ایشان خواهد بود.» ");
INSERT INTO pesOPV_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","پس موسی موافق آنچه خداوند او را امر فرموده بود کرد، و همچنین به عمل آورد. ");
INSERT INTO pesOPV_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","و واقع شد در غره ماه اول از سال دوم که مسکن برپا شد، ");
INSERT INTO pesOPV_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","و موسی مسکن را برپا نمود، وپایه هایش را بنهاد و تخته هایش را قایم کرد، وپشت بندهایش را گذاشت، و ستونهایش را برپانمود، ");
INSERT INTO pesOPV_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","و خیمه را بالای مسکن کشید، و پوشش خیمه را بر زبر آن گسترانید، چنانکه خداوند به موسی‌امر نموده بود. ");
INSERT INTO pesOPV_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","و شهادت را گرفته، آن رادر تابوت نهاد، و عصاها را بر تابوت گذارد، وکرسی رحمت را بالای تابوت گذاشت. ");
INSERT INTO pesOPV_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","وتابوت را به مسکن درآورد، و حجاب ستر راآویخته، آن را پیش تابوت شهادت کشید. چنانکه خداوند به موسی‌امر فرموده بود. ");
INSERT INTO pesOPV_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","و خوان را در خیمه اجتماع به طرف شمالی مسکن، بیرون حجاب نهاد. ");
INSERT INTO pesOPV_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","و نان را به حضور خداوند بر آن ترتیب داد، چنانکه خداوند به موسی‌امر فرموده بود. ");
INSERT INTO pesOPV_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","و چراغدان را در خیمه اجتماع، مقابل خوان به طرف جنوبی مسکن نهاد. ");
INSERT INTO pesOPV_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","و چراغها رابه حضور خداوند گذاشت، چنانکه خداوند به موسی‌امر فرموده بود. ");
INSERT INTO pesOPV_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","و مذبح زرین را درخیمه اجتماع، پیش حجاب نهاد. ");
INSERT INTO pesOPV_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","و بخورمعطر بر آن سوزانید، چنانکه خداوند به موسی‌امر فرموده بود. ");
INSERT INTO pesOPV_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","و پرده دروازه مسکن راآویخت. ");
INSERT INTO pesOPV_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","و مذبح قربانی سوختنی را پیش دروازه مسکن خیمه اجتماع وضع کرد، و قربانی سوختنی و هدیه را بر آن گذرانید، چنانکه خداوند به موسی‌امر فرموده بود. ");
INSERT INTO pesOPV_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","و حوض رادر میان خیمه اجتماع و مذبح وضع کرده، آب برای شستن در آن بریخت. ");
INSERT INTO pesOPV_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","و موسی و هارون وپسرانش دست و پای خود را در آن شستند. ");
INSERT INTO pesOPV_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","وقتی که به خیمه اجتماع داخل شدند ونزد مذبح آمدند شست و شو کردند، چنانکه خداوند به موسی‌امر فرموده بود. ");
INSERT INTO pesOPV_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","و صحن راگرداگرد مسکن و مذبح برپا نمود، و پرده دروازه صحن را آویخت. پس موسی کار را به انجام رسانید. ");
INSERT INTO pesOPV_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","آنگاه ابر، خیمه اجتماع را پوشانید و جلال خداوند مسکن را پر ساخت. ");
INSERT INTO pesOPV_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","و موسی نتوانست به خیمه اجتماع داخل شود، زیراکه ابربر آن ساکن بود، و جلال خداوند مسکن را پرساخته بود. ");
INSERT INTO pesOPV_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","و چون ابر از بالای مسکن برمی خاست، بنی‌اسرائیل در همه مراحل خودکوچ می‌کردند. ");
INSERT INTO pesOPV_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","و هرگاه ابر برنمی خاست، تاروز برخاستن آن، نمی کوچیدند. ");
INSERT INTO pesOPV_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","زیرا که در روز، ابر خداوند بر مسکن و در شب، آتش بر آن می‌بود، در نظر تمامی خاندان اسرائیل، در همه منازل ایشان. ");
INSERT INTO pesOPV_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","و خداوند موسی را خواند، و او را از خیمه اجتماع خطاب کرده، گفت: ");
INSERT INTO pesOPV_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","«بنی‌اسرائیل را خطاب کرده، به ایشان بگو: هرگاه کسی از شماقربانی نزد خداوند بگذراند، پس قربانی خود را ازبهایم یعنی از گاو یا از گوسفند بگذرانید. ");
INSERT INTO pesOPV_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","اگرقربانی او قربانی سوختنی از گاو باشد، آن را نربی عیب بگذارند، و آن را نزد در خیمه اجتماع بیاورد تا به حضور خداوند مقبول شود. ");
INSERT INTO pesOPV_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","و دست خود را بر سر قربانی سوختنی بگذارد، و برایش مقبول خواهد شد تا بجهت او کفاره کند. ");
INSERT INTO pesOPV_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","پس گاو را به حضور خداوند ذبح نماید، و پسران هارون کهنه خون را نزدیک بیاورند، و خون را براطراف مذبح که نزد در خیمه اجتماع است بپاشند. ");
INSERT INTO pesOPV_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","و پوست قربانی سوختنی را بکند و آن را قطعه قطعه کند. ");
INSERT INTO pesOPV_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","و پسران هارون کاهن آتش برمذبح بگذارند، و هیزم بر آتش بچینند. ");
INSERT INTO pesOPV_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","و پسران هارون کهنه قطعه‌ها و سر و پیه را بر هیزمی که برآتش روی مذبح است بچینند. ");
INSERT INTO pesOPV_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","و احشایش وپاچه هایش را به آب بشویند، و کاهن همه را برمذبح بسوزاند، برای قربانی سوختنی و هدیه آتشین و عطر خوشبو بجهت خداوند. ");
INSERT INTO pesOPV_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","و اگرقربانی او از گله باشد خواه از گوسفند خواه از بزبجهت قربانی سوختنی، آن را نر بی‌عیب بگذراند. ");
INSERT INTO pesOPV_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","و آن را به طرف شمالی مذبح به حضور خداوند ذبح نماید، و پسران هارون کهنه خونش را به اطراف مذبح بپاشند. ");
INSERT INTO pesOPV_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","و آن را باسرش و پیه‌اش قطعه قطعه کند، و کاهن آنها را برهیزمی که بر آتش روی مذبح است بچیند. ");
INSERT INTO pesOPV_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","واحشایش و پاچه هایش را به آب بشوید، و کاهن همه را نزدیک بیاورد و بر مذبح بسوزاند، که آن قربانی سوختنی و هدیه آتشین و عطر خوشبوبجهت خداوند است. ");
INSERT INTO pesOPV_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","«و اگر قربانی او بجهت خداوند قربانی سوختنی از مرغان باشد، پس قربانی خود را ازفاخته‌ها یا از جوجه های کبوتر بگذراند. ");
INSERT INTO pesOPV_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","وکاهن آن را نزد مذبح بیاورد و سرش را بپیچد و برمذبح بسوزاند، و خونش را بر پهلوی مذبح افشرده شود. ");
INSERT INTO pesOPV_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","و چینه دانش را با فضلات آن بیرون کرده، آن را بر جانب شرقی مذبح در جای خاکستر بیندازد. ");
INSERT INTO pesOPV_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","و آن را از میان بالهایش چاک کند و از هم جدا نکند، و کاهن آن را بر مذبح برهیزمی که بر آتش است بسوزاند، که آن قربانی سوختنی و هدیه آتشین و عطر خوشبو بجهت خداوند است. ");
INSERT INTO pesOPV_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","«و هرگاه کسی قربانی هدیه آردی بجهت خداوند بگذراند، پس قربانی او از آرد نرم باشد، و روغن بر آن بریزد و کندر بر آن بنهد. ");
INSERT INTO pesOPV_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","وآن را نزد پسران هارون کهنه بیاورد، و یک مشت از آن بگیرد یعنی از آرد نرمش و روغنش باتمامی کندرش و کاهن آن را برای یادگاری بسوزاند، تا هدیه آتشین و عطر خوشبو بجهت خداوند باشد. ");
INSERT INTO pesOPV_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","و بقیه هدیه آردی از آن هارون وپسرانش باشد. این از هدایای آتشین خداوند قدس اقداس است. ");
INSERT INTO pesOPV_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","و هرگاه قربانی هدیه آردی پخته شده‌ای در تنور بگذرانی، پس قرصهای فطیر از آرد نرم سرشته شده به روغن، یا گرده های فطیر مالیده شده به روغن باشد. ");
INSERT INTO pesOPV_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","و اگر قربانی توهدیه آردی بر ساج باشد، پس از آرد نرم فطیرسرشته شده به روغن باشد. ");
INSERT INTO pesOPV_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","و آن را پاره پاره کرده، روغن بر آن بریز. این هدیه آردی است. ");
INSERT INTO pesOPV_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","واگر قربانی تو هدیه آردی تابه باشد از آرد نرم باروغن ساخته شود. ");
INSERT INTO pesOPV_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","و هدیه آردی را که از این چیزها ساخته شود نزد خداوند بیاور، و آن راپیش کاهن بگذار، و او آن را نزد مذبح خواهدآورد. ");
INSERT INTO pesOPV_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","و کاهن از هدیه آردی یادگاری آن رابردارد و بر مذبح بسوزاند. این هدیه آتشین و عطرخوشبو بجهت خداوند است. ");
INSERT INTO pesOPV_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","و بقیه هدیه آردی از آن هارون و پسرانش باشد. این ازهدایای آتشین خداوند قدس اقداس است. ");
INSERT INTO pesOPV_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","«و هیچ هدیه آردی که بجهت خداوندمی گذرانید با خمیرمایه ساخته نشود، زیرا که هیچ خمیرمایه و عسل را برای هدیه آتشین بجهت خداوند نباید سوزانید. ");
INSERT INTO pesOPV_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","آنها را برای قربانی نوبرها بجهت خداوند بگذرانید، لیکن برای عطر خوشبو به مذبح برنیارند. ");
INSERT INTO pesOPV_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","و هرقربانی هدیه آردی خود را به نمک نمکین کن، ونمک عهد خدای خود را از هدیه آردی خودبازمدار، با هر قربانی خود نمک بگذران. ");
INSERT INTO pesOPV_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","و اگرهدیه آردی نوبرها بجهت خداوند بگذرانی، پس خوشه های برشته شده به آتش، یعنی بلغورحاصل نیکو بجهت هدیه آردی نوبرهای خودبگذران. ");
INSERT INTO pesOPV_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","و روغن بر آن بریز و کندر بر آن بنه. این هدیه آردی است. ");
INSERT INTO pesOPV_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","و کاهن یادگاری آن رایعنی قدری از بلغور آن و از روغنش با تمامی کندرش بسوزاند. این هدیه آتشین بجهت خداوند است. ");
INSERT INTO pesOPV_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","«و اگر قربانی او ذبیحه سلامتی باشد، اگر ازرمه بگذراند خواه نر و خواه ماده باشد، آن را بی‌عیب به حضور خداوند بگذراند. ");
INSERT INTO pesOPV_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","و دست خود را بر سر قربانی خویش بنهد، و آن را نزد درخیمه اجتماع ذبح نماید، و پسران هارون کهنه خون را به اطراف مذبح بپاشند. ");
INSERT INTO pesOPV_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","و از ذبیحه سلامتی، هدیه آتشین بجهت خداوند بگذراند، یعنی پیهی که احشا را می‌پوشاند و همه پیه را که بر احشاست. ");
INSERT INTO pesOPV_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","و دو گرده و پیه که بر آنهاست که بر دو تهیگاه است، و سفیدی را که بر جگر است، با گرده‌ها جدا کند. ");
INSERT INTO pesOPV_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","و پسران هارون آن را برمذبح با قربانی سوختنی بر هیزمی که بر آتش است بسوزانند. این هدیه آتشین و عطر خوشبوبجهت خداوند است. ");
INSERT INTO pesOPV_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","و اگر قربانی او برای ذبیحه سلامتی بجهت خداوند از گله باشد، آن رانر یا ماده بی‌عیب بگذراند. ");
INSERT INTO pesOPV_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","اگر بره‌ای برای قربانی خود بگذراند، آن را به حضور خداوندنزدیک بیاورد. ");
INSERT INTO pesOPV_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","و دست خود را بر سر قربانی خود بنهد، و آن را نزد در خیمه اجتماع ذبح نماید، و پسران هارون خونش را به اطراف مذبح بپاشند. ");
INSERT INTO pesOPV_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","و از ذبیحه سلامتی هدیه آتشین بجهت خداوند بگذراند، یعنی پیه‌اش و تمامی دنبه را وآن را از نزد عصعص جدا کند، و پیهی که احشا رامی پوشاند و همه پیه را که بر احشاست. ");
INSERT INTO pesOPV_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","و دوگرده و پیهی که بر آنهاست که بر دو تهیگاه است وسفیدی را که بر جگر است با گرده‌ها جدا کند. ");
INSERT INTO pesOPV_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","و کاهن آن را بر مذبح بسوزاند. این طعام هدیه آتشین بجهت خداوند است. ");
INSERT INTO pesOPV_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","و اگر قربانی او بز باشد پس آن را به حضور خداوند نزدیک بیاورد. ");
INSERT INTO pesOPV_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","و دست خود را برسرش بنهد و آن را پیش خیمه اجتماع ذبح نماید. و پسران هارون خونش را به اطراف مذبح بپاشند. ");
INSERT INTO pesOPV_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","و قربانی خود، یعنی هدیه آتشین را، بجهت خداوند از آن بگذراند، پیهی که احشا رامی پوشاند و تمامی پیهی که بر احشاست. ");
INSERT INTO pesOPV_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","و دوگرده و پیهی که بر آنهاست که بر دو تهیگاه است وسفیدی را که بر جگر است با گرده‌ها جدا کند. ");
INSERT INTO pesOPV_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","و کاهن آن را بر مذبح بسوزاند. این طعام هدیه آتشین برای عطر خوشبوست. تمامی پیه از آن خداوند است. ");
INSERT INTO pesOPV_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","این قانون ابدی در همه پشتهای شما در جمیع مسکنهای شما خواهد بود که هیچ خون و پیه را نخورید.» ");
INSERT INTO pesOPV_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","و خداوند موسی را خطاب کرده، گفت: ");
INSERT INTO pesOPV_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","«بنی‌اسرائیل را خطاب کرده، بگو: اگرکسی سهو گناه کند، در هر کدام از نواهی خداوند که نباید کرد، و به خلاف هریک از آنهاعمل کند، ");
INSERT INTO pesOPV_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","اگر کاهن که مسح شده است گناهی ورزد و قوم را مجرم سازد، پس برای گناهی که کرده است، گوساله‌ای بی‌عیب از رمه برای قربانی گناه نزد خداوند بگذراند. ");
INSERT INTO pesOPV_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","و گوساله را به درخیمه اجتماع به حضور خداوند بیاورد، و دست خود را بر سر گوساله بنهد و گوساله را به حضورخداوند ذبح نماید. ");
INSERT INTO pesOPV_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","و کاهن مسح شده از خون گوساله گرفته، آن را به خیمه اجتماع درآورد. ");
INSERT INTO pesOPV_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","وکاهن انگشت خود را در خون فرو برد، و به حضور خداوند پیش حجاب قدس قدری ازخون را هفت مرتبه بپاشد. ");
INSERT INTO pesOPV_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","و کاهن قدری ازخون را بر شاخه های مذبح بخور معطر که درخیمه اجتماع است، به حضور خداوند بپاشد، و همه خون گوساله را بر بنیان مذبح قربانی سوختنی که به در خیمه اجتماع است بریزد. ");
INSERT INTO pesOPV_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","وتمامی پیه گوساله قربانی گناه، یعنی پیهی که احشا را می‌پوشاند و همه پیه را که بر احشاست ازآن بردارد. ");
INSERT INTO pesOPV_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","و دو گرده و پیهی که بر آنهاست که بردو تهیگاه است و سفیدی را که بر جگر است باگرده‌ها جدا کند. ");
INSERT INTO pesOPV_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","چنانکه از گاو ذبیحه سلامتی برداشته می‌شود و کاهن آنها را بر مذبح قربانی سوختنی بسوزاند. ");
INSERT INTO pesOPV_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","و پوست گوساله و تمامی گوشتش با سرش و پاچه هایش و احشایش وسرگینش، ");
INSERT INTO pesOPV_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","یعنی تمامی گوساله را بیرون لشکرگاه در مکان پاک جایی که خاکستر رامی ریزند ببرد، و آن را بر هیزم به آتش بسوزاند. در جایی که خاکستر را می‌ریزند سوخته شود. ");
INSERT INTO pesOPV_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","«و هرگاه تمامی جماعت اسرائیل سهو گناه کنند و آن امر از چشمان جماعت مخفی باشد، و کاری را که نباید کرد از جمیع نواهی خداوند کرده، مجرم شده باشند. ");
INSERT INTO pesOPV_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","چون گناهی که کردند معلوم شود، آنگاه جماعت گوساله‌ای ازرمه برای قربانی گناه بگذرانند و آن را پیش خیمه اجتماع بیاورند. ");
INSERT INTO pesOPV_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","و مشایخ جماعت دستهای خود را بر سر گوساله به حضور خداوند بنهند، وگوساله به حضور خداوند ذبح شود. ");
INSERT INTO pesOPV_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","و کاهن مسح شده، قدری از خون گوساله را به خیمه اجتماع درآورد. ");
INSERT INTO pesOPV_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","و کاهن انگشت خود را درخون فروبرد و آن را به حضور خداوند پیش حجاب هفت مرتبه بپاشد. ");
INSERT INTO pesOPV_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","و قدری از خون رابر شاخه های مذبح که به حضور خداوند درخیمه اجتماع است بگذارد، و همه خون را بربنیان مذبح قربانی سوختنی که نزد در خیمه اجتماع است بریزد. ");
INSERT INTO pesOPV_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","و همه پیه آن را از آن برداشته، بر مذبح بسوزاند. ");
INSERT INTO pesOPV_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","و با گوساله عمل نماید چنانکه با گوساله قربانی گناه عمل کرد، همچنان با این بکند و کاهن برای ایشان کفاره کند، و آمرزیده خواهند شد. ");
INSERT INTO pesOPV_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","و گوساله را بیرون لشکرگاه برده، آن را بسوزاند چنانکه گوساله اول را سوزانید. این قربانی گناه جماعت است. ");
INSERT INTO pesOPV_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","«و هرگاه رئیس گناه کند، و کاری را که نباید کرد از جمیع نواهی یهوه خدای خود سهو بکند و مجرم شود، ");
INSERT INTO pesOPV_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","چون گناهی که کرده است بر او معلوم شود، آنگاه بز نر بی‌عیب برای قربانی خود بیاورد. ");
INSERT INTO pesOPV_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","و دست خود را بر سر بز بنهد وآن را در جایی که قربانی سوختنی را ذبح کنند به حضور خداوند ذبح نماید. این قربانی گناه است. ");
INSERT INTO pesOPV_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","و کاهن قدری از خون قربانی گناه را به انگشت خود گرفته، بر شاخهای مذبح قربانی سوختنی بگذارد، و خونش را بر بنیان مذبح سوختنی بریزد. ");
INSERT INTO pesOPV_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","و همه پیه آن را مثل پیه ذبیحه سلامتی بر مذبح بسوزاند، و کاهن برای او گناهش را کفاره خواهد کرد و آمرزیده خواهد شد. ");
INSERT INTO pesOPV_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","«و هرگاه کسی از اهل زمین سهو گناه ورزدو کاری را که نباید کرد از همه نواهی خداوندبکند و مجرم شود، ");
INSERT INTO pesOPV_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","چون گناهی که کرده است بر او معلوم شود، آنگاه برای قربانی خود بز ماده بی‌عیب بجهت گناهی که کرده است بیاورد. ");
INSERT INTO pesOPV_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","ودست خود را بر سر قربانی گناه بنهد و قربانی گناه را در جای قربانی سوختنی ذبح نماید. ");
INSERT INTO pesOPV_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","و کاهن قدری از خونش را به انگشت خود گرفته، آن را برشاخهای مذبح قربانی سوختنی بگذارد، و همه خونش را بر بنیان مذبح بریزد. ");
INSERT INTO pesOPV_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","و همه پیه آن راجدا کند چنانکه پیه از ذبیحه سلامتی جدامی شود، و کاهن آن را بر مذبح بسوزاند برای عطر خوشبو بجهت خداوند و کاهن برای او کفاره خواهد کرد و آمرزیده خواهد شد. ");
INSERT INTO pesOPV_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","و اگر برای قربانی خود بره‌ای بجهت قربانی گناه بیاورد آن راماده بی‌عیب بیاورد. ");
INSERT INTO pesOPV_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","و دست خود را بر سرقربانی گناه بنهد و آن را برای قربانی گناه در جایی که قربانی سوختنی ذبح می‌شود ذبح نماید. ");
INSERT INTO pesOPV_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","وکاهن قدری از خون قربانی گناه را به انگشت خودگرفته، بر شاخهای مذبح قربانی سوختنی بگذاردو همه خونش را بر بنیان مذبح بریزد. ");
INSERT INTO pesOPV_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","و همه پیه آن را جدا کند، چنانکه پیه بره ذبیحه سلامتی جدا می‌شود، و کاهن آن را بر مذبح بر هدایای آتشین خداوند بسوزاند، و کاهن برای او بجهت گناهی که کرده است کفاره خواهد کرد و آمرزیده خواهد شد. ");
INSERT INTO pesOPV_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","بشنود، و او شاهد باشد خواه دیده و خواه دانسته، اگر اطلاع ندهد گناه او را متحمل خواهدبود. ");
INSERT INTO pesOPV_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","یا کسی‌که هر چیز نجس را لمس کند، خواه لاش وحش نجس، خواه لاش بهیمه نجس، خواه لاش حشرات نجس، و از او مخفی باشد، پس نجس و مجرم می‌باشد. ");
INSERT INTO pesOPV_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","یا اگر نجاست آدمی را لمس کند، از هر نجاست او که به آن نجس می‌شود، و از وی مخفی باشد، چون معلوم شد آنگاه مجرم خواهد بود. ");
INSERT INTO pesOPV_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","و اگر کسی غفلت به لبهای خود قسم خورد برای کردن کار بد یا کارنیک، یعنی در هر چیزی که آدمی غفلت قسم خورد، و از او مخفی باشد، چون بر او معلوم شودآنگاه در هر کدام که باشد مجرم خواهد بود. ");
INSERT INTO pesOPV_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","وچون در هر کدام از اینها مجرم شد، آنگاه به آن چیزی که در آن گناه کرده است اعتراف بنماید. ");
INSERT INTO pesOPV_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","و قربانی جرم خود را برای گناهی که کرده است نزد خداوند بیاورد، یعنی ماده‌ای از گله بره‌ای یابزی بجهت قربانی گناه، و کاهن برای وی گناهش را کفاره خواهد کرد. ");
INSERT INTO pesOPV_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","و اگر دست او به قیمت بره نرسد، پس قربانی جرم خود را برای گناهی که کرده است دو فاخته یا دو جوجه کبوتر نزدخداوند بیاورد، یکی برای قربانی گناه و دیگری برای قربانی سوختنی. ");
INSERT INTO pesOPV_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","و آنها را نزد کاهن بیاورد، و او آن را که برای قربانی گناه است اول بگذراند وسرش را از گردنش بکند و آن را دو پاره نکند، ");
INSERT INTO pesOPV_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","وقدری از خون قربانی گناه را بر پهلوی مذبح بپاشد، و باقی خون بر بنیان مذبح افشرده شود. این قربانی گناه است. ");
INSERT INTO pesOPV_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","و دیگری را برای قربانی سوختنی موافق قانون بگذراند، و کاهن برای وی گناهش را که کرده است کفاره خواهد کرد وآمرزیده خواهدشد. ");
INSERT INTO pesOPV_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","و اگر دستش به دو فاخته یا دو جوجه کبوتر نرسد، آنگاه قربانی خود رابرای گناهی که کرده است ده‌یک ایفه آرد نرم بجهت قربانی گناه بیاورد، و روغن برآن ننهد وکندر برآن نگذارد زیرا قربانی گناه است. ");
INSERT INTO pesOPV_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","و آن را نزد کاهن بیاورد و کاهن یک مشت از آن را برای یادگاری گرفته، بر هدایای آتشین خداوند برمذبح بسوزاند. این قربانی گناه است. ");
INSERT INTO pesOPV_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","و کاهن برای وی گناهش را که در هرکدام از اینها کرده است کفاره خواهد کرد، و آمرزیده خواهد شد، ومثل هدیه آردی از آن کاهن خواهد بود.» ");
INSERT INTO pesOPV_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","و خداوند موسی را خطاب کرده، گفت: ");
INSERT INTO pesOPV_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","«اگر کسی خیانت ورزد، و درباره چیزهای مقدس خداوند سهو گناه کند، آنگاه قربانی جرم خود را قوچی بی‌عیب از گله نزد خداوند موافق برآورد، وبه مثقالهای نقره مطابق مثقال قدس بیاورد، واین قربانی جرم است. ");
INSERT INTO pesOPV_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","وبه عوض نقصانی که در چیز مقدس رسانیده است عوض بدهد، و پنج یک بر آن اضافه کرده، و آن را به کاهن بدهد و کاهن برای وی به قوچ قربانی جرم کفاره خواهد کرد، و آمرزیده خواهد شد. ");
INSERT INTO pesOPV_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","واگر کسی گناه کند و کاری از جمیع نواهی خداوند که نباید کرد بکند، و آن را نداند، پس مجرم است و متحمل گناه خود خواهد بود. ");
INSERT INTO pesOPV_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","وقوچی بی‌عیب از گله موافق برآورد و نزد کاهن بیاورد، و کاهن برای وی غفلت او را که کرده است کفاره خواهد کرد، و آمرزیده خواهد شد. ");
INSERT INTO pesOPV_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","این قربانی جرم است البته نزد خداوند مجرم می‌باشد.» ");
INSERT INTO pesOPV_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","و خداوند موسی را خطاب کرده، گفت: ");
INSERT INTO pesOPV_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","«اگر کسی گناه کند، و خیانت به خداوندورزد، و به همسایه خود دروغ گوید، درباره امانت یا رهن یا چیز دزدیده شده، یا مال همسایه خود را غصب نماید، ");
INSERT INTO pesOPV_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","یا چیز گمشده را یافته، درباره آن دروغ گوید، و قسم دروغ بخورد، در هرکدام از کارهایی که شخصی در آنها گناه کند. ");
INSERT INTO pesOPV_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","پس چون گناه ورزیده، مجرم شود، آنچه را که دزدیده یا آنچه را غصب نموده یا آنچه نزد او به امانت سپرده شده یا آن چیز گم شده را که یافته است، رد بنماید. ");
INSERT INTO pesOPV_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","یا هر‌آنچه را که درباره آن قسم دروغ خورده، هم اصل مال را رد بنماید، وهم پنج یک آن را برآن اضافه کرده، آن را به مالکش بدهد، در روزی که جرم او ثابت شده باشد. ");
INSERT INTO pesOPV_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","و قربانی جرم خود را نزد خداوند بیاورد، یعنی قوچ بی‌عیب از گله موافق برآورد تو برای قربانی جرم نزد کاهن. ");
INSERT INTO pesOPV_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","و کاهن برای وی به حضور خداوند کفاره خواهد کرد و آمرزیده خواهد شد، از هر کاری که کرده، و در آن مجرم شده است.» ");
INSERT INTO pesOPV_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","و خداوند موسی را خطاب کرده، گفت: ");
INSERT INTO pesOPV_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","«هارون و پسرانش را امر فرموده، بگو: این است قانون قربانی سوختنی: که قربانی سوختنی تمامی شب تا صبح بر آتشدان مذبح باشد، و آتش مذبح بر آن افروخته بماند. ");
INSERT INTO pesOPV_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","و کاهن لباس کتان خود رابپوشد، و زیرجامه کتان بر بدن خود بپوشد، وخاکستر قربانی سوختنی را که بر مذبح به آتش سوخته شده، بردارد و آن را به یک طرف مذبح بگذارد. ");
INSERT INTO pesOPV_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","و لباس خود را بیرون کرده، لباس دیگر بپوشد، و خاکستر را بیرون لشکرگاه به‌جای پاک ببرد. ");
INSERT INTO pesOPV_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","و آتشی که بر مذبح است افروخته باشد، و خاموش نشود و هر بامداد کاهن هیزم برآن بسوزاند، و قربانی سوختنی را بر آن مرتب سازد، و پیه ذبیحه سلامتی را بر آن بسوزاند، ");
INSERT INTO pesOPV_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","وآتش بر مذبح پیوسته افروخته باشد، و خاموش نشود. ");
INSERT INTO pesOPV_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","«و این است قانون هدیه آردی: پسران هارون آن را به حضور خداوند بر مذبح بگذرانند. ");
INSERT INTO pesOPV_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","و از آن یک مشت از آرد نرم هدیه آردی و ازروغنش با تمامی کندر که بر هدیه آردی است بردارد، و بر مذبح بسوزاند، برای عطر خوشبو ویادگاری آن نزد خداوند. ");
INSERT INTO pesOPV_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","و باقی آن را هارون و پسرانش بخورند. بی‌خمیرمایه در مکان قدس خورده شود، در صحن خیمه اجتماع آن رابخورند. ");
INSERT INTO pesOPV_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","با خمیرمایه پخته نشود، آن را ازهدایای آتشین برای قسمت ایشان داده‌ام، این قدس اقداس است مثل قربانی گناه و مثل قربانی جرم. ");
INSERT INTO pesOPV_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","جمیع ذکوران از پسران هارون آن رابخورند. این فریضه ابدی در نسلهای شما ازهدایای آتشین خداوند است، هر‌که آنها را لمس کند مقدس خواهد بود.» ");
INSERT INTO pesOPV_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","و خداوند موسی را خطاب کرده، گفت: ");
INSERT INTO pesOPV_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","«این است قربانی هارون و پسرانش که در روزمسح کردن او نزد خداوند بگذرانند، ده‌یک ایفه آرد نرم برای هدیه آردی دائمی، نصفش در صبح و نصفش در شام، ");
INSERT INTO pesOPV_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","و بر ساج با روغن ساخته شود و چون آمیخته شد آن را بیاور و آن را به پاره های برشته شده برای هدیه آردی بجهت عطر خوشبو نزد خداوند بگذران. ");
INSERT INTO pesOPV_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","و کاهن مسح شده که از پسرانش در جای او خواهد بودآن را بگذراند. این است فریضه ابدی که تمامش نزد خداوند سوخته شود. ");
INSERT INTO pesOPV_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","و هر هدیه آردی کاهن تمام سوخته شود و خورده نشود.» ");
INSERT INTO pesOPV_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","و خداوند موسی را خطاب کرده، گفت: ");
INSERT INTO pesOPV_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","«هارون و پسرانش را خطاب کرده، بگو: این است قانون قربانی گناه، در جایی که قربانی سوختنی ذبح می‌شود، قربانی گناه نیز به حضورخداوند ذبح شود. این قدس اقداس است. ");
INSERT INTO pesOPV_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","وکاهنی که آن را برای گناه می‌گذراند آن را بخورد، در مکان مقدس، در صحن خیمه اجتماع خورده شود. ");
INSERT INTO pesOPV_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","هر‌که گوشتش را لمس کند مقدس شود، و اگر خونش بر جامه‌ای پاشیده شود آنچه را که بر آن پاشیده شده است در مکان مقدس بشوی. ");
INSERT INTO pesOPV_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","و ظرف سفالین که در آن پخته شود شکسته شود و اگر در ظرف مسین پخته شود زدوده، و به آب شسته شود. ");
INSERT INTO pesOPV_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","و هر ذکوری از کاهنان آن رابخورد، این قدس اقداس است. ");
INSERT INTO pesOPV_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","و هیچ قربانی گناه که از خون آن به خیمه اجتماع درآورده شودتا در قدس کفاره نماید خورده نشود، به آتش سوخته شود. ");
INSERT INTO pesOPV_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","«و این است قانون قربانی جرم؛ این اقدس اقداس است. ");
INSERT INTO pesOPV_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","در جایی که قربانی سوختنی را ذبح کنند، قربانی جرم را نیز ذبح بکنند، و خونش را به اطراف مذبح بپاشند. ");
INSERT INTO pesOPV_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","و ازآن همه پیه‌اش را بگذراند، دنبه و پیه که احشا رامی پوشاند. ");
INSERT INTO pesOPV_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","و دو گرده و پیهی که بر آنهاست که بر دو تهیگاه است، و سفیدی را که بر جگر است، با گرده‌ها جدا کند. ");
INSERT INTO pesOPV_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","و کاهن آنها را برای هدیه آتشین بجهت خداوند بسوزاند. این قربانی جرم است. ");
INSERT INTO pesOPV_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","و هر ذکوری از کاهنان آن را بخورد، درمکان مقدس خورده شود. این قدس اقداس است. ");
INSERT INTO pesOPV_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","«قربانی جرم مانند قربانی گناه است. آنها رایک قانون است. کاهنی که به آن کفاره کند از آن اوخواهد بود. ");
INSERT INTO pesOPV_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","و کاهنی که قربانی سوختنی کسی را گذراند، آن کاهن پوست قربانی سوختنی را که گذرانید برای خود نگه دارد. ");
INSERT INTO pesOPV_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","و هر هدیه آردی که در تنور پخته شود و هر‌چه بر تابه یا ساج ساخته شود از آن کاهن که آن راگذرانید خواهد بود. ");
INSERT INTO pesOPV_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","و هر هدیه آردی، خواه به روغن سرشته شده، خواه خشک، از آن همه پسران هارون بی‌تفاوت یکدیگر خواهدبود. ");
INSERT INTO pesOPV_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","«و این است قانون ذبیحه سلامتی که کسی نزد خداوند بگذراند. ");
INSERT INTO pesOPV_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","اگر آن را برای تشکربگذراند پس با ذبیحه تشکر، قرصهای فطیرسرشته شده به روغن، و نازکهای فطیر مالیده شده به روغن، و از آرد نرم آمیخته شده، قرصهای سرشته شده به روغن را بگذراند. ");
INSERT INTO pesOPV_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","با قرصهای نان خمیر مایه دار قربانی خود را همراه ذبیحه تشکر سلامتی خود بگذراند. ");
INSERT INTO pesOPV_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","و از آن از هرقربانی یکی را برای هدیه افراشتنی نزد خداوندبگذراند، و از آن آن کاهن که خون ذبیحه سلامتی را می‌پاشد خواهد بود. ");
INSERT INTO pesOPV_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","و گوشت ذبیحه تشکرسلامتی او در روز قربانی وی خورده شود، چیزی از آن را تا صبح نگذارد. ");
INSERT INTO pesOPV_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","و اگر ذبیحه قربانی او نذری یا تبرعی باشد، در روزی که ذبیحه خود را می‌گذراند خورده شود، و باقی آن در فردای آن روز خورده شود. ");
INSERT INTO pesOPV_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","و باقی گوشت ذبیحه در روز سوم به آتش سوخته شود. ");
INSERT INTO pesOPV_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","و اگرچیزی از گوشت ذبیحه سلامتی او در روز سوم خورده شود مقبول نخواهد شد و برای کسی‌که آن را گذرانید محسوب نخواهد شد، نجس خواهد بود. و کسی‌که آن را بخورد گناه خود رامتحمل خواهد شد. ");
INSERT INTO pesOPV_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","و گوشتی که به هر چیزنجس برخورد، خورده نشود، به آتش سوخته شود، و هر‌که طاهر باشد از آن گوشت بخورد. ");
INSERT INTO pesOPV_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","لیکن کسی‌که از گوشت ذبیحه سلامتی که برای خداوند است بخورد و نجاست او بر اوباشد، آن کس از قوم خود منقطع خواهد شد. ");
INSERT INTO pesOPV_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","وکسی‌که هر چیز نجس را خواه نجاست آدمی، خواه بهیمه نجس، خواه هر چیز مکروه نجس رالمس کند، و از گوشت ذبیحه سلامتی که برای خداوند است بخورد، آن کس از قوم خود منقطع خواهد شد.» ");
INSERT INTO pesOPV_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","و خداوند موسی را خطاب کرده، گفت: ");
INSERT INTO pesOPV_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","«بنی‌اسرائیل را خطاب کرده، بگو: هیچ پیه گاوو گوسفند و بز را مخورید. ");
INSERT INTO pesOPV_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","اما پیه مردار و پیه حیوان دریده شده برای هر کار استعمال می‌شود، لیکن هرگز خورده نشود. ");
INSERT INTO pesOPV_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","زیرا هر‌که پیه جانوری که از آن هدیه آتشین برای خداوندمی گذرانند بخورد، آن کس که خورد، از قوم خودمنقطع شود. ");
INSERT INTO pesOPV_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","و هیچ خون را خواه از مرغ خواه از بهایم در همه مسکنهای خود مخورید. ");
INSERT INTO pesOPV_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","هرکسی‌که از هر قسم خون بخورد، آن کس از قوم خود منقطع خواهد شد.» ");
INSERT INTO pesOPV_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","و خداوند موسی را خطاب کرده، گفت: ");
INSERT INTO pesOPV_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","«بنی‌اسرائیل را خطاب کرده، بگو: هر‌که ذبیحه سلامتی خود را برای خداوند بگذراند، قربانی خود را از ذبیحه سلامتی خود نزد خداوندبیاورد. ");
INSERT INTO pesOPV_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","به‌دستهای خود هدایای آتشین خداوند را بیاورد، پیه را با سینه بیاورد تا سینه بجهت هدیه جنبانیدنی به حضور خداوندجنبانیده شود. ");
INSERT INTO pesOPV_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","و کاهن پیه را بر مذبح بسوزاند، و سینه از آن هارون و پسرانش خواهد بود. ");
INSERT INTO pesOPV_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","وران راست را برای هدیه افراشتنی از ذبایح سلامتی خود به کاهن بدهید. ");
INSERT INTO pesOPV_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","آن کس از پسران هارون که خون ذبیحه سلامتی وپیه را گذرانید، ران راست حصه وی خواهد بود. ");
INSERT INTO pesOPV_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","زیرا سینه جنبانیدنی و ران افراشتنی را از بنی‌اسرائیل از ذبایح سلامتی ایشان گرفتم، و آنها را به هارون کاهن و پسرانش به فریضه ابدی از جانب بنی‌اسرائیل دادم.» ");
INSERT INTO pesOPV_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","این است حصه مسح هارون و حصه مسح پسرانش از هدایای آتشین خداوند، در روزی که ایشان را نزدیک آورد تابرای خداوند کهانت کنند. ");
INSERT INTO pesOPV_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","که خداوند امرفرمود که به ایشان داده شود، در روزی که ایشان را از میان بنی‌اسرائیل مسح کرد، این فریضه ابدی در نسلهای ایشان است. ");
INSERT INTO pesOPV_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","این است قانون قربانی سوختنی و هدیه آردی و قربانی گناه و قربانی جرم و قربانی تقدیس و ذبیحه سلامتی، ");
INSERT INTO pesOPV_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","که خداوند به موسی در کوه سینا امر فرموده بود، درروزی که بنی‌اسرائیل را مامور فرمود تاقربانی های خود را نزد خداوند بگذرانند درصحرای سینا. ");
INSERT INTO pesOPV_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","و خداوند موسی را خطاب کرده، گفت: ");
INSERT INTO pesOPV_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","«هارون و پسرانش را با او و رختها وروغن مسح و گوساله قربانی گناه و دو قوچ وسبدنان فطیر را بگیر. ");
INSERT INTO pesOPV_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","و تمامی جماعت را به درخیمه اجتماع جمع کن.» ");
INSERT INTO pesOPV_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","پس موسی چنانکه خداوند به وی امر فرموده بود به عمل آورد، وجماعت به در خیمه اجتماع جمع شدند. ");
INSERT INTO pesOPV_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","وموسی به جماعت گفت: «این است آنچه خداوندفرموده است که کرده شود.» ");
INSERT INTO pesOPV_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","پس موسی هارون و پسرانش را نزدیک آورد، و ایشان را به آب غسل داد. ");
INSERT INTO pesOPV_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","و پیراهن را بر او پوشانید و کمربند رابر او بست، و او را به ردا ملبس ساخت، و ایفود رابر او گذاشت و زنار ایفود را بر او بسته، آن را بر وی استوار ساخت ");
INSERT INTO pesOPV_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","و سینه بند را بر او گذاشت واوریم و تمیم را در سینه بند گذارد. ");
INSERT INTO pesOPV_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","و عمامه را برسرش نهاد، و بر عمامه در‌پیش آن تنکه زرین، یعنی افسر مقدس را نهاد، چنانکه خداوند موسی را امر فرموده بود. ");
INSERT INTO pesOPV_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","و موسی روغن مسح را گرفته، مسکن وآنچه را که در آن بود مسح کرده، آنها را تقدیس نمود. ");
INSERT INTO pesOPV_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","و قدری از آن را بر مذبح هفت مرتبه پاشید، و مذبح و همه اسبابش و حوض و پایه‌اش را مسح کرد، تا آنها را تقدیس نماید. ");
INSERT INTO pesOPV_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","و قدری از روغن مسح را بر سر هارون ریخته، او را مسح کرد تا او را تقدیس نماید. ");
INSERT INTO pesOPV_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","و موسی پسران هارون را نزدیک آورده، بر ایشان پیراهنها راپوشانید و کمربندها را بر ایشان بست و کلاهها رابر ایشان نهاد، چنانکه خداوند موسی را امرفرموده بود. ");
INSERT INTO pesOPV_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","پس گوساله قربانی گناه را آورد، و هارون وپسرانش دستهای خود را بر سر گوساله قربانی گناه نهادند. ");
INSERT INTO pesOPV_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","و آن را ذبح کرد، و موسی خون راگرفته، بر شاخهای مذبح به هر طرف به انگشت خود مالید، و مذبح را طاهر ساخت، و خون را بربنیان مذبح ریخته، آن را تقدیس نمود تا برایش کفاره نماید. ");
INSERT INTO pesOPV_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","و همه پیه را که بر احشا بود وسفیدی جگر و دو گرده و پیه آنها را گرفت، وموسی آنها را بر مذبح سوزانید ");
INSERT INTO pesOPV_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","و گوساله وپوستش و گوشتش و سرگینش را بیرون ازلشکرگاه به آتش سوزانید، چنانکه خداوندموسی را امر فرموده بود. ");
INSERT INTO pesOPV_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","پس قوچ قربانی سوختنی را نزدیک آورد، و هارون و پسرانش دستهای خود را بر سر قوچ نهادند. ");
INSERT INTO pesOPV_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","و آن را ذبح کرد، و موسی خون را به اطراف مذبح پاشید. ");
INSERT INTO pesOPV_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","وقوچ را قطعه قطعه کرد، و موسی سر و قطعه‌ها و چربی را سوزانید. ");
INSERT INTO pesOPV_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","و احشا و پاچه‌ها را به آب شست و موسی تمامی قوچ را بر مذبح سوزانید. ");
INSERT INTO pesOPV_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","پس قوچ دیگر یعنی قوچ تخصیص را نزدیک آورد، و هارون وپسرانش دستهای خود را بر سر قوچ نهادند. ");
INSERT INTO pesOPV_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","وآن را ذبح کرد، و موسی قدری از خونش را گرفته، بر نرمه گوش راست هارون و بر شست دست راست او، و بر شست پای راست او مالید. ");
INSERT INTO pesOPV_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","وپسران هارون را نزدیک آورد، و موسی قدری ازخون را بر نرمه گوش راست ایشان، و بر شست دست راست ایشان، و بر شست پای راست ایشان مالید، و موسی خون را به اطراف مذبح پاشید. ");
INSERT INTO pesOPV_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","و پیه و دنبه و همه پیه را که بر احشاست، وسفیدی جگر و دو گرده و پیه آنها و ران راست راگرفت. ");
INSERT INTO pesOPV_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","و از سبد نان فطیر که به حضور خداوندبود، یک قرص فطیر و یک قرص نان روغنی ویک نازک گرفت، و آنها را بر پیه و بر ران راست نهاد. ");
INSERT INTO pesOPV_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","و همه را بر دست هارون و بر دستهای پسرانش نهاد. و آنها را برای هدیه جنبانیدنی به حضور خداوند بجنبانید. ");
INSERT INTO pesOPV_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","و موسی آنها را ازدستهای ایشان گرفته، بر مذبح بالای قربانی سوختنی سوزانید. این هدیه تخصیص برای عطرخوشبو و قربانی آتشین بجهت خداوند بود. ");
INSERT INTO pesOPV_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","وموسی سینه را گرفته، آن را به حضور خداوندبرای هدیه جنبانیدنی جنبانید، و از قوچ تخصیص، این حصه موسی بود چنانکه خداوندموسی را امر فرموده بود. ");
INSERT INTO pesOPV_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","و موسی قدری از روغن مسح و از خونی که بر مذبح بود گرفته، آن را بر هارون و رختهایش و بر پسرانش و رختهای پسرانش با وی پاشید، و هارون و رختهایش و پسرانش و رختهای پسرانش را با وی تقدیس نمود. ");
INSERT INTO pesOPV_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","و موسی هارون و پسرانش را گفت: «گوشت را نزد درخیمه اجتماع بپزید و آن را با نانی که در سبدتخصیص است در آنجا بخورید، چنانکه امرفرموده، گفتم که هارون و پسرانش آن را بخورند. ");
INSERT INTO pesOPV_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","و باقی گوشت و نان را به آتش بسوزانید. ");
INSERT INTO pesOPV_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","واز در خیمه اجتماع هفت روز بیرون مروید تاروزی که ایام تخصیص شما تمام شود، زیرا که در هفت روز شما را تخصیص خواهد کرد. ");
INSERT INTO pesOPV_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","چنانکه امروز کرده شده است، همچنان خداوند امر فرمود که بشود تا برای شما کفاره گردد. ");
INSERT INTO pesOPV_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","پس هفت روز نزد در خیمه اجتماع روزو شب بمانید، و امر خداوند را نگاه دارید مبادابمیرید، زیرا همچنین مامور شده‌ام.» ");
INSERT INTO pesOPV_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","و هارون و پسرانش همه کارهایی را که خداوند به‌دست موسی‌امر فرموده بود بجا آوردند. ");
INSERT INTO pesOPV_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","و واقع شد که در روز هشتم، موسی هارون و پسرانش و مشایخ اسرائیل را خواند. ");
INSERT INTO pesOPV_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","وهارون را گفت: «گوساله‌ای نرینه برای قربانی گناه، و قوچی بجهت قربانی سوختنی، هر دو رابی عیب بگیر، و به حضور خداوند بگذران. ");
INSERT INTO pesOPV_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","وبنی‌اسرائیل را خطاب کرده، بگو: بزغاله نرینه برای قربانی گناه، و گوساله و بره‌ای هر دو یک ساله و بی‌عیب برای قربانی سوختنی بگیرید. ");
INSERT INTO pesOPV_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","وگاوی و قوچی برای ذبیحه سلامتی، تا به حضورخداوند ذبح شود، و هدیه آردی سرشته شده به روغن را، زیرا که امروز خداوند بر شما ظاهر خواهد شد.» ");
INSERT INTO pesOPV_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","پس آنچه را که موسی‌امر فرموده بود پیش خیمه اجتماع آوردند. و تمامی جماعت نزدیک شده، به حضور خداوندایستادند. ");
INSERT INTO pesOPV_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","و موسی گفت: «این است کاری که خداوند امر فرموده است که بکنید، و جلال خداوند بر شما ظاهر خواهد شد.» ");
INSERT INTO pesOPV_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","و موسی هارون را گفت: «نزدیک مذبح بیا و قربانی گناه خود و قربانی سوختنی خود را بگذران، و برای خود و برای قوم کفاره کن، و قربانی قوم را بگذران و بجهت ایشان کفاره کن، چنانکه خداوند امرفرموده است.» ");
INSERT INTO pesOPV_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","و هارون به مذبح نزدیک آمده، گوساله قربانی گناه را که برای خودش بود ذبح کرد. ");
INSERT INTO pesOPV_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","وپسران هارون خون را نزد او آوردند و انگشت خود را به خون فرو برده، آن را بر شاخهای مذبح مالید و خون را بر بنیان مذبح ریخت. ");
INSERT INTO pesOPV_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","و پیه وگرده‌ها و سفیدی جگر از قربانی گناه را بر مذبح سوزانید، چنانکه خداوند موسی را امر فرموده بود. ");
INSERT INTO pesOPV_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","و گوشت و پوست را بیرون لشکرگاه به آتش سوزانید. ");
INSERT INTO pesOPV_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","و قربانی سوختنی را ذبح کرد، و پسران هارون خون را به او سپردند، و آن را به اطراف مذبح پاشید. ");
INSERT INTO pesOPV_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","و قربانی را به قطعه هایش و سرش به او سپردند، و آن را بر مذبح سوزانید. ");
INSERT INTO pesOPV_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","و احشا و پاچه‌ها را شست و آنها را بر قربانی سوختنی بر مذبح سوزانید. ");
INSERT INTO pesOPV_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","و قربانی قوم رانزدیک آورد، و بز قربانی گناه را که برای قوم بودگرفته، آن را ذبح کرد و آن را مثل اولین برای گناه گذرانید. ");
INSERT INTO pesOPV_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","و قربانی سوختنی را نزدیک آورده، آن را به حسب قانون گذرانید. ");
INSERT INTO pesOPV_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","و هدیه آردی رانزدیک آورده، مشتی از آن برداشت، و آن را علاوه بر قربانی سوختنی صبح بر مذبح سوزانید. ");
INSERT INTO pesOPV_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","و گاو و قوچ ذبیحه سلامتی را که برای قوم بودذبح کرد، و پسران هارون خون را به او سپردند وآن را به اطراف مذبح پاشید. ");
INSERT INTO pesOPV_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","و پیه گاو و دنبه قوچ و آنچه احشا را می‌پوشاند و گرده‌ها وسفیدی جگر را. ");
INSERT INTO pesOPV_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","و پیه را بر سینه‌ها نهادند، وپیه را بر مذبح سوزانید. ");
INSERT INTO pesOPV_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","و هارون سینه‌ها و ران راست را برای هدیه جنبانیدنی به حضور خداوندجنبانید، چنانکه موسی‌امر فرموده بود. ");
INSERT INTO pesOPV_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","پس هارون دستهای خود را به سوی قوم برافراشته، ایشان را برکت داد، و از گذرانیدن قربانی گناه وقربانی سوختنی و ذبایح سلامتی بزیر آمد. ");
INSERT INTO pesOPV_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","وموسی و هارون به خیمه اجتماع داخل شدند، وبیرون آمده، قوم را برکت دادند و جلال خداوندبر جمیع قوم ظاهر شد. ");
INSERT INTO pesOPV_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","و آتش از حضورخداوند بیرون آمده، قربانی سوختنی و پیه را برمذبح بلعید، و چون تمامی قوم این را دیدند، صدای بلند کرده، به روی در‌افتادند. ");
INSERT INTO pesOPV_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","و ناداب و ابیهو پسران هارون، هر یکی مجمره خود را گرفته، آتش بر آنهانهادند. و بخور بر آن گذارده، آتش غریبی که ایشان را نفرموده بود، به حضور خداوند نزدیک آوردند. ");
INSERT INTO pesOPV_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","و آتش از حضور خداوند به در شده، ایشان را بلعید، و به حضور خداوند مردند. ");
INSERT INTO pesOPV_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","پس موسی به هارون گفت: «این است آنچه خداوندفرموده، و گفته است که از آنانی که به من نزدیک آیند تقدیس کرده خواهم شد، و در نظر تمامی قوم جلال خواهم یافت.» پس هارون خاموش شد. ");
INSERT INTO pesOPV_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","و موسی میشائیل و الصافان، پسران عزیئیل عموی هارون را خوانده، به ایشان گفت: «نزدیک آمده، برادران خود را از پیش قدس بیرون لشکرگاه ببرید.» ");
INSERT INTO pesOPV_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","پس نزدیک آمده، ایشان را در‌پیراهنهای ایشان بیرون لشکرگاه بردند، چنانکه موسی گفته بود. ");
INSERT INTO pesOPV_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","و موسی هارون وپسرانش العازار و ایتامار را گفت: «مویهای سرخود را باز مکنید و گریبان خود را چاک مزنیدمبادا بمیرید. و غضب بر تمامی جماعت بشود. اما برادران شما یعنی تمام خاندان اسرائیل بجهت آتشی که خداوند افروخته است ماتم خواهند کرد. ");
INSERT INTO pesOPV_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","و از در خیمه اجتماع بیرون مروید مبادا بمیرید، زیرا روغن مسح خداوند برشماست.» پس به حسب آنچه موسی گفت، کردند. ");
INSERT INTO pesOPV_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","و خداوند هارون را خطاب کرده، گفت: ");
INSERT INTO pesOPV_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","«توو پسرانت با تو چون به خیمه اجتماع داخل شوید شراب و مسکری منوشید مبادا بمیرید. این است فریضه ابدی در نسلهای شما. ");
INSERT INTO pesOPV_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","و تا درمیان مقدس و غیرمقدس و نجس و طاهر تمیزدهید، ");
INSERT INTO pesOPV_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","و تا به بنی‌اسرائیل همه فرایضی را که خداوند به‌دست موسی برای ایشان گفته است، تعلیم دهید.» ");
INSERT INTO pesOPV_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","و موسی به هارون و پسرانش العازار و ایتامار که باقی بودند گفت: «هدیه آردی که از هدایای آتشین خداوند مانده است بگیرید، و آن را بی‌خمیرمایه نزد مذبح بخورید زیراقدس اقداس است. ");
INSERT INTO pesOPV_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","و آن را در مکان مقدس بخورید زیرا که از هدایای آتشین خداوند این حصه تو و حصه پسران توست چنانکه مامورشده‌ام. ");
INSERT INTO pesOPV_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","و سینه جنبانیدنی و ران افراشتنی را تو و پسرانت و دخترانت با تو در جای پاک بخورید، زیرا اینها از ذبایح سلامتی بنی‌اسرائیل برای حصه تو و حصه پسرانت داده شده است. ");
INSERT INTO pesOPV_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","ران افراشتنی و سینه جنبانیدنی را با هدایای آتشین پیه بیاورند، تا هدیه جنبانیدنی به حضور خداوندجنبانیده شود، و از آن تو و از آن پسرانت خواهدبود، به فریضه ابدی چنانکه خداوند امر فرموده است.» ");
INSERT INTO pesOPV_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","و موسی بز قربانی گناه را طلبید و اینک سوخته شده بود، پس بر العازار و ایتامار پسران هارون که باقی بودند خشم نموده، گفت: ");
INSERT INTO pesOPV_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","«چراقربانی گناه را در مکان مقدس نخوردید؟ زیرا که آن قدس اقداس است، و به شما داده شده بود تاگناه جماعت را برداشته، برای ایشان به حضورخداوند کفاره کنید. ");
INSERT INTO pesOPV_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","اینک خون آن به اندرون قدس آورده نشد، البته می‌بایست آن را در قدس خورده باشید، چنانکه امر کرده بودم.» ");
INSERT INTO pesOPV_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","هارون به موسی گفت: «اینک امروز قربانی گناه خود وقربانی سوختنی خود را به حضور خداوندگذرانیدند، و چنین چیزها بر من واقع شده است، پس اگر امروز قربانی گناه را می‌خوردم آیا منظورنظر خداوند می‌شد؟» ");
INSERT INTO pesOPV_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","چون موسی این راشنید، در نظرش پسند آمد. ");
INSERT INTO pesOPV_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","و خداوند موسی و هارون را خطاب کرده، به ایشان گفت: ");
INSERT INTO pesOPV_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","«بنی‌اسرائیل راخطاب کرده، بگویید: اینها حیواناتی هستند که می‌باید بخورید، از همه بهایمی که بر روی زمین‌اند. ");
INSERT INTO pesOPV_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","هر شکافته سم که شکاف تمام دارد ونشخوار کننده‌ای از بهایم، آن را بخورید. ");
INSERT INTO pesOPV_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","اما ازنشخوارکنندگان و شکافتگان سم اینها رامخورید، یعنی شتر، زیرا نشخوار می‌کند لیکن شکافته سم نیست، آن برای شما نجس است. ");
INSERT INTO pesOPV_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","وونک، زیرا نشخوار می‌کند اما شکافته سم نیست، این برای شما نجس است. ");
INSERT INTO pesOPV_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","و خرگوش، زیرانشخوار می‌کند ولی شکافته سم نیست، این برای شما نجس است. ");
INSERT INTO pesOPV_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","و خوک، زیرا شکافته سم است و شکاف تمام دارد لیکن نشخوار نمی کند، این برای شما نجس است. ");
INSERT INTO pesOPV_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","از گوشت آنهامخورید و لاش آنها را لمس مکنید، اینها برای شما نجس‌اند. ");
INSERT INTO pesOPV_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","از همه آنچه در آب است اینها رابخورید، هر‌چه پر و فلس دارد در آب خواه دردریا خواه در نهرها، آنها را بخورید. ");
INSERT INTO pesOPV_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","و هر‌چه پر و فلس ندارد در دریا یا در نهرها، از همه حشرات آب و همه جانورانی که در آب می‌باشند، اینها نزد شما مکروه باشند. ");
INSERT INTO pesOPV_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","البته نزدشما مکروه‌اند، از گوشت آنها مخورید و لاشهای آنها را مکروه دارید. ");
INSERT INTO pesOPV_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","هر‌چه در آبها پر و فلس ندارد نزد شما مکروه خواهد بود. ");
INSERT INTO pesOPV_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","و از مرغان اینها را مکروه دارید، خورده نشوند، زیرامکروه‌اند، عقاب و استخوان خوار و نسربحر. ");
INSERT INTO pesOPV_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","وکرکس و لاشخوار به اجناس آن. ");
INSERT INTO pesOPV_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","و غراب به اجناس آن. ");
INSERT INTO pesOPV_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","و شترمرغ و جغد و مرغ دریایی وباز به اجناس آن. ");
INSERT INTO pesOPV_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","و بوم و غواص و بوتیمار. ");
INSERT INTO pesOPV_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","و قاز و مرغ سقا و رخم. ");
INSERT INTO pesOPV_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","و لقلق و کلنگ به اجناس آن و هدهد و شبپره. ");
INSERT INTO pesOPV_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","و همه حشرات بالدار که بر چهارپا می‌روند برای شما مکروه‌اند. ");
INSERT INTO pesOPV_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","لیکن اینها را بخورید از همه حشرات بالدار که بر چهار پا می‌روند، هر کدام که بر پایهای خودساقها برای جستن بر زمین دارند. ");
INSERT INTO pesOPV_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","از آن قسم اینها را بخورید. ملخ به اجناس آن و دبا به اجناس آن و حرجوان به اجناس آن و حدب به اجناس آن. ");
INSERT INTO pesOPV_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","و سایر حشرات بالدار که چهار پا دارندبرای شما مکروه‌اند. ");
INSERT INTO pesOPV_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","از آنها نجس می‌شوید، هرکه لاش آنها را لمس کند تا شام نجس باشد. ");
INSERT INTO pesOPV_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","و هر‌که چیزی از لاش آنها را بردارد، رخت خود را بشوید و تا شام نجس باشد. ");
INSERT INTO pesOPV_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","و هربهیمه‌ای که شکافته سم باشد لیکن شکاف تمام ندارد و نشخوار نکند اینها برای شما نجسند، وهر‌که آنها را لمس کند نجس است. ");
INSERT INTO pesOPV_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","و هر‌چه برکف پا رود از همه جانورانی که بر چهار پامی روند، اینها برای شما نجس‌اند، هر‌که لاش آنها را لمس کند تا شام نجس باشد. ");
INSERT INTO pesOPV_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","و هر‌که لاش آنها را بردارد، رخت خود را بشوید و تا شام نجس باشد. اینها برای شما نجس‌اند. ");
INSERT INTO pesOPV_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","«و از حشراتی که بر زمین می‌خزند اینهابرای شما نجس‌اند: موش کور و موش وسوسمار به اجناس آن، ");
INSERT INTO pesOPV_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","و دله و ورل و چلپاسه و کرباسه و بوقلمون. ");
INSERT INTO pesOPV_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","از جمیع حشرات اینهابرای شما نجس‌اند: هر‌که لاش آنها را لمس کندتا شام نجس باشد، ");
INSERT INTO pesOPV_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","و بر هر چیزی که یکی ازاینها بعد از موتش بیفتد نجس باشد، خواه هرظرف چوبی، خواه رخت، خواه چرم، خواه جوال؛ هر ظرفی که در آن کار کرده شود در آب گذاشته شود و تا شام نجس باشد، پس طاهرخواهد بود. ");
INSERT INTO pesOPV_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","و هر ظرف سفالین که یکی از اینهادر آن بیفتد آنچه در آن است نجس باشد و آن رابشکنید. ");
INSERT INTO pesOPV_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","هر خوراک در آن که خورده شود، اگرآب بر آن ریخته شد نجس باشد، و هر مشروبی که آشامیده شود که در چنین ظرف است نجس باشد. ");
INSERT INTO pesOPV_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","و بر هر چیزی که پاره‌ای از لاش آنهابیفتد نجس باشد، خواه تنور، خواه اجاق، شکسته شود؛ اینها نجس‌اند و نزد شما نجس خواهند بود. ");
INSERT INTO pesOPV_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","و چشمه و حوض که مجمع آب باشد طاهر است لیکن هر‌که لاش آنها را لمس کند نجس خواهد بود. ");
INSERT INTO pesOPV_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","و اگر پاره‌ای از لاش آنها بر تخم کاشتنی که باید کاشته شود بیفتدطاهر است. ");
INSERT INTO pesOPV_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","لیکن اگر آب بر تخم ریخته شود وپاره‌ای از لاش آنها بر آن بیفتد، این برای شمانجس باشد. ");
INSERT INTO pesOPV_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","و اگر یکی از بهایمی که برای شماخوردنی است بمیرد، هر‌که لاش آن را لمس کندتا شام نجس باشد. ");
INSERT INTO pesOPV_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","و هر‌که لاش آن را بخوردرخت خود را بشوید و تا شام نجس باشد. و هر‌که لاش آن را بردارد، رخت خود را بشوید و تا شام نجس باشد. ");
INSERT INTO pesOPV_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","«و هر حشراتی که بر زمین می‌خزد مکروه است؛ خورده نشود. ");
INSERT INTO pesOPV_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","و هر‌چه بر شکم راه رودو هر‌چه بر چهارپا راه رود و هر‌چه پایهای زیاده دارد، یعنی همه حشراتی که بر زمین می‌خزند، آنها را مخورید زیرا که مکروه‌اند. ");
INSERT INTO pesOPV_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","خویشتن رابه هر حشراتی که می‌خزد مکروه مسازید، و خودرا به آنها نجس مسازید، مبادا از آنها ناپاک شوید. ");
INSERT INTO pesOPV_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","زیرا من یهوه خدای شما هستم، پس خود را تقدیس نمایید و مقدس باشید، زیرا من قدوس هستم پس خویشتن را به همه حشراتی که بر زمین می‌خزند نجس مسازید. ");
INSERT INTO pesOPV_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","زیرا من یهوه هستم که شما را از زمین مصر بیرون آوردم تا خدای شما باشم، پس مقدس باشید زیرامن قدوس هستم. ");
INSERT INTO pesOPV_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","این است قانون بهایم ومرغان و هر حیوانی که در آبها حرکت می‌کندو هر حیوانی که بر زمین می‌خزد. ");
INSERT INTO pesOPV_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","تا در میان نجس و طاهر و در میان حیواناتی که خورده شوند و حیواناتی که خورده نشوند امتیازبشود.» ");
INSERT INTO pesOPV_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","و خداوند موسی را خطاب کرده، گفت: ");
INSERT INTO pesOPV_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","«بنی‌اسرائیل را خطاب کرده، بگو: چون زنی آبستن شده، پسر نرینه‌ای بزاید، آنگاه هفت روز نجس باشد، موافق ایام طمث حیضش نجس باشد. ");
INSERT INTO pesOPV_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","و در روز هشتم گوشت غلفه اومختون شود. ");
INSERT INTO pesOPV_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","و سی و سه روز در خون تطهیرخود بماند، و هیچ‌چیز مقدس را لمس ننماید، وبه مکان مقدس داخل نشود، تا ایام طهرش تمام شود. ");
INSERT INTO pesOPV_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","و اگر دختری بزاید، دو هفته برحسب مدت طمث خود نجس باشد، و شصت و شش روز در خون تطهیر خود بماند. ");
INSERT INTO pesOPV_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","و چون ایام طهرش برای پسر یا دختر تمام شود، بره‌ای یک ساله برای قربانی سوختنی و جوجه کبوتر یافاخته‌ای برای قربانی گناه به در خیمه اجتماع نزدکاهن بیاورد. ");
INSERT INTO pesOPV_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","و او آن را به حضور خداوندخواهد گذرانید، و برایش کفاره خواهد کرد، تا ازچشمه خون خود طاهر شود. این است قانون آن که بزاید، خواه پسر خواه دختر. ");
INSERT INTO pesOPV_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","و اگر دست اوبه قیمت بره نرسد، آنگاه دو فاخته یا دو جوجه کبوتر بگیرد، یکی برای قربانی سوختنی ودیگری برای قربانی گناه. و کاهن برای وی کفاره خواهد کرد، و طاهر خواهد شد.» ");
INSERT INTO pesOPV_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","و خداوند موسی و هارون را خطاب کرده، گفت: ");
INSERT INTO pesOPV_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","«چون شخصی را درپوست بدنش آماس یا قوبا یا لکه‌ای براق بشود، وآن در پوست بدنش مانند بلای برص باشد، پس او را نزد هارون کاهن یا نزد یکی از پسرانش که کهنه باشند بیاورند. ");
INSERT INTO pesOPV_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","و کاهن آن بلا را که درپوست بدنش باشد ملاحظه نماید. اگر مو در بلاسفید گردیده است، و نمایش بلا از پوست بدنش گودتر باشد، بلای برص است، پس کاهن او راببیند و حکم به نجاست او بدهد. ");
INSERT INTO pesOPV_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","و اگر آن لکه براق در پوست بدنش سفید باشد، و از پوست گودتر ننماید، و موی آن سفید نگردیده، آنگاه کاهن آن مبتلا را هفت روز نگاه دارد. ");
INSERT INTO pesOPV_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","و روزهفتم کاهن او را ملاحظه نماید، و اگر آن بلا درنظرش ایستاده باشد، و بلا در پوست پهن نشده، پس کاهن او را هفت روز دیگر نگاه دارد. ");
INSERT INTO pesOPV_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","و درروز هفتم کاهن او را باز ملاحظه کند، و اگر بلا کم رنگ شده، و در پوست پهن نگشته است، کاهن حکم به طهارتش بدهد. آن قوبا است. رخت خودرا بشوید و طاهر باشد. ");
INSERT INTO pesOPV_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","و اگر قوبا در پوست پهن شود بعد از آن که خود را به کاهن برای تطهیرنمود، پس بار دیگر خود را به کاهن بنماید. ");
INSERT INTO pesOPV_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","وکاهن ملاحظه نماید، و هرگاه قوبا در پوست پهن شده باشد، حکم به نجاست او بدهد. این برص است. ");
INSERT INTO pesOPV_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","و چون بلای برص در کسی باشد او را نزدکاهن بیاورند. ");
INSERT INTO pesOPV_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","و کاهن ملاحظه نماید اگر آماس سفید در پوست باشد، و موی را سفید کرده، وگوشت خام زنده در آماس باشد، ");
INSERT INTO pesOPV_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","این درپوست بدنش برص مزمن است. کاهن به نجاستش حکم دهد و او را نگاه ندارد زیرا که نجس است. ");
INSERT INTO pesOPV_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","و اگر برص در پوست بسیار پهن شده باشد وبرص، تمامی پوست آن مبتلا را از سر تا پا هرجایی که کاهن بنگرد، پوشانیده باشد، ");
INSERT INTO pesOPV_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","پس کاهن ملاحظه نماید اگر برص تمام بدن را فروگرفته است، به تطهیر آن مبتلا حکم دهد. چونکه همه بدنش سفید شده است، طاهر است. ");
INSERT INTO pesOPV_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","لیکن هر وقتی که گوشت زنده در او ظاهر شود، نجس خواهد بود. ");
INSERT INTO pesOPV_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","و کاهن گوشت زنده را ببیند وحکم به نجاست او بدهد. این گوشت زنده نجس است زیرا که برص است. ");
INSERT INTO pesOPV_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","و اگر گوشت زنده به سفیدی برگردد نزد کاهن بیاید. ");
INSERT INTO pesOPV_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","و کاهن او راملاحظه کند و اگر آن بلا به سفیدی مبدل شده است، پس کاهن به طهارت آن مبتلا حکم دهدزیرا طاهر است. ");
INSERT INTO pesOPV_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","«و گوشتی که در پوست آن دمل باشد وشفا یابد، ");
INSERT INTO pesOPV_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","و در جای دمل آماس سفید یا لکه براق سفید مایل به‌سرخی پدید آید، آن را به کاهن بنماید. ");
INSERT INTO pesOPV_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","و کاهن آن را ملاحظه نماید و اگراز پوست گودتر بنماید و موی آن سفید شده، پس کاهن به نجاست او حکم دهد. این بلای برص است که از دمل درآمده است. ");
INSERT INTO pesOPV_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","و اگر کاهن آن راببیند و اینک موی سفید در آن نباشد و گودتر ازپوست هم نباشد و کم رنگ باشد، پس کاهن او راهفت روز نگاه دارد. ");
INSERT INTO pesOPV_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","و اگر در پوست پهن شده، کاهن به نجاست او حکم دهد. این بلا می‌باشد. ");
INSERT INTO pesOPV_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","و اگر آن لکه براق در جای خود مانده، پهن نشده باشد، این گری دمل است. پس کاهن به طهارت وی حکم دهد. ");
INSERT INTO pesOPV_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","یا گوشتی که درپوست آن داغ آتش باشد و از گوشت زنده آن داغ، لکه براق سفید مایل به‌سرخی یا سفید پدیدآید، ");
INSERT INTO pesOPV_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","پس کاهن آن را ملاحظه نماید. اگر مو درلکه براق سفید گردیده، و گودتر از پوست بنمایداین برص است که از داغ درآمده است. پس کاهن به نجاست او حکم دهد زیرا بلای برص است. ");
INSERT INTO pesOPV_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","و اگر کاهن آن را ملاحظه نماید و اینک در لکه براق موی سفید نباشد و گودتر از پوست نباشد وکم رنگ باشد، کاهن او را هفت روز نگه دارد. ");
INSERT INTO pesOPV_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","و در روز هفتم کاهن او را ملاحظه نماید. اگر درپوست پهن شده، کاهن به نجاست وی حکم دهد. این بلای برص است. ");
INSERT INTO pesOPV_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","و اگر لکه براق در جای خود مانده، در پوست پهن نشده باشد و کم رنگ باشد، این آماس داغ است. پس کاهن به طهارت وی حکم دهد. این گری داغ است. ");
INSERT INTO pesOPV_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","«و چون مرد یا زن، بلایی در سر یا در زنخ داشته باشد، ");
INSERT INTO pesOPV_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","کاهن آن بلا را ملاحظه نماید. اگرگودتر از پوست بنماید و موی زرد باریک در آن باشد، پس کاهن به نجاست او حکم دهد. این سعفه یعنی برص سر یا زنخ است. ");
INSERT INTO pesOPV_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","و چون کاهن بلای سعفه را ببیند، اگر گودتر از پوست ننماید و موی سیاه در آن نباشد، پس کاهن آن مبتلای سعفه را هفت روز نگاه دارد. ");
INSERT INTO pesOPV_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","و در روزهفتم کاهن آن بلا را ملاحظه نماید. اگر سعفه پهن نشده، و موی زرد در آن نباشد و سعفه گودتر ازپوست ننماید، ");
INSERT INTO pesOPV_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","آنگاه موی خود را بتراشد لیکن سعفه را نتراشد و کاهن آن مبتلای سعفه را بازهفت روز نگاه دارد. ");
INSERT INTO pesOPV_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","و در روز هفتم کاهن سعفه را ملاحظه نماید. اگر سعفه در پوست پهن نشده، و از پوست گودتر ننماید، پس کاهن حکم به طهارت وی دهد و او رخت خود را بشوید وطاهر باشد. ");
INSERT INTO pesOPV_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","لیکن اگر بعد از حکم به طهارتش سعفه در پوست پهن شود، ");
INSERT INTO pesOPV_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","پس کاهن او راملاحظه نماید. اگر سعفه در پوست پهن شده باشد، کاهن موی زرد را نجوید، او نجس است. ");
INSERT INTO pesOPV_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","اما اگر در نظرش سعفه ایستاده باشد، و موی سیاه از آن در‌آمده، پس سعفه شفا یافته است. اوطاهر است و کاهن حکم به طهارت وی بدهد. ");
INSERT INTO pesOPV_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","«و چون مرد یا زن در پوست بدن خودلکه های براق یعنی لکه های براق سفید داشته باشد، ");
INSERT INTO pesOPV_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","کاهن ملاحظه نماید. اگر لکه‌ها در پوست بدن ایشان کم رنگ و سفید باشد، این بهق است که از پوست درآمده. او طاهر است. ");
INSERT INTO pesOPV_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","وکسی‌که موی سر او ریخته باشد، او اقرع است، وطاهر می‌باشد. ");
INSERT INTO pesOPV_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","و کسی‌که موی سر او از طرف پیشانی ریخته باشد، او اصلع است، و طاهرمی باشد. ");
INSERT INTO pesOPV_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","و اگر در سر کل او یا پیشانی کل اوسفید مایل به‌سرخی باشد، آن برص است که ازسر کل او یا پیشانی کل او در‌آمده است. ");
INSERT INTO pesOPV_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","پس کاهن او را ملاحظه کند. اگر آماس آن بلا در سرکل او یا پیشانی کل او سفید مایل به‌سرخی، مانندبرص در پوست بدن باشد، ");
INSERT INTO pesOPV_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","او مبروص است، ونجس می‌باشد. کاهن البته حکم به نجاست وی بدهد. بلای وی در سرش است. ");
INSERT INTO pesOPV_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","و اما مبروص که این بلا را دارد، گریبان او چاک شده، و موی سراو گشاده، و شاربهای او پوشیده شود، و ندا کندنجس نجس. ");
INSERT INTO pesOPV_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","و همه روزهایی که بلا دارد، البته نجس خواهد بود، و تنها بماند و مسکن او بیرون لشکرگاه باشد. ");
INSERT INTO pesOPV_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","«و رختی که بلای برص داشته باشد، خواه رخت پشمین خواه رخت پنبه‌ای، ");
INSERT INTO pesOPV_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","خواه در تارو خواه در پود، چه از پشم و چه از پنبه و چه ازچرم، یا از هر چیزی که از چرم ساخته شود، ");
INSERT INTO pesOPV_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","اگر آن بلا مایل به سبزی یا به‌سرخی باشد، دررخت یا در چرم، خواه در تار خواه در پود یا درهر ظرف چرمی، این بلای برص است. به کاهن نشان داده شود. ");
INSERT INTO pesOPV_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","و کاهن آن بلا را ملاحظه نماید و آن چیزی را که بلا دارد هفت روز نگاه دارد. ");
INSERT INTO pesOPV_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","و آن چیزی را که بلا دارد، در روز هفتم ملاحظه کند. اگر آن بلا در رخت پهن شده باشد، خواه در تار خواه در پود، یا در چرم در هر کاری که چرم برای آن استعمال می‌شود، این برص مفسد است و آن چیز نجس می‌باشد. ");
INSERT INTO pesOPV_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","پس آن رخت را بسوزاند، چه تار و چه پود، خواه در پشم خواه در پنبه، یا در هر ظرف چرمی که بلا در آن باشد، زیرا برص مفسد است. به آتش سوخته شود. ");
INSERT INTO pesOPV_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","اما چون کاهن آن را ملاحظه کند، اگر بلادر رخت، خواه در تار خواه در پود، یا در هرظرف چرمی پهن نشده باشد، ");
INSERT INTO pesOPV_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","پس کاهن امرفرماید تا آنچه را که بلا دارد بشویند، و آن راهفت روز دیگر نگاه دارد. ");
INSERT INTO pesOPV_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","و بعد از شستن آن چیز که بلا دارد کاهن ملاحظه نماید. اگر رنگ آن بلا تبدیل نشده، هر‌چند بلا هم پهن نشده باشد، این نجس است. آن را به آتش بسوزان. این خوره است، خواه فرسودگی آن در درون باشد یا دربیرون. ");
INSERT INTO pesOPV_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","و چون کاهن ملاحظه نماید، اگر بلا بعداز شستن آن کم رنگ شده باشد، پس آن را ازرخت یا از چرم خواه از تار خواه از پود، پاره کند. ");
INSERT INTO pesOPV_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","و اگر باز در آن رخت خواه در تار خواه در پود، یا در هر ظرف چرمی ظاهر شود، این برآمدن برص است. آنچه را که بلا دارد به آتش بسوزان. ");
INSERT INTO pesOPV_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","و آن رخت خواه تار و خواه پود، یا هر ظرف چرمی را که شسته‌ای و بلا از آن رفع شده باشد، دوباره شسته شود و طاهر خواهد بود.» ");
INSERT INTO pesOPV_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","این است قانون بلای برص در رخت پشمین یا پنبه‌ای خواه در تار خواه در پود، یا در هر ظرف چرمی برای حکم به طهارت یا نجاست آن. ");
INSERT INTO pesOPV_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","و خداوند موسی را خطاب کرده، گفت: ");
INSERT INTO pesOPV_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","«این است قانون مبروص: در روزتطهیرش نزد کاهن آورده شود. ");
INSERT INTO pesOPV_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","و کاهن بیرون لشکرگاه برود و کاهن ملاحظه کند. اگر بلای برص از مبروص رفع شده باشد، ");
INSERT INTO pesOPV_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","کاهن حکم بدهد که برای آن کسی‌که باید تطهیر شود، دوگنجشک زنده طاهر، و چوب ارز و قرمز و زوفابگیرند. ");
INSERT INTO pesOPV_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","و کاهن امر کند که یک گنجشک را درظرف سفالین بر بالای آب روان بکشند. ");
INSERT INTO pesOPV_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","و اماگنجشک زنده را با چوب ارز و قرمز و زوفا بگیردو آنها را با گنجشک زنده به خون گنجشکی که برآب روان کشته شده، فرو برد. ");
INSERT INTO pesOPV_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","و بر کسی‌که ازبرص باید تطهیر شود هفت مرتبه بپاشد، و حکم به طهارتش بدهد. و گنجشک زنده را به سوی صحرا رها کند. ");
INSERT INTO pesOPV_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","و آن کس که باید تطهیر شودرخت خود را بشوید، و تمامی موی خود رابتراشد، و به آب غسل کند، و طاهر خواهد شد. وبعد از آن به لشکرگاه داخل شود، لیکن تا هفت روز بیرون خیمه خود بماند. ");
INSERT INTO pesOPV_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","و در روز هفتم تمامی موی خود را بتراشد از سر و ریش وآبروی خود، یعنی تمامی موی خود را بتراشد ورخت خود را بشوید و بدن خود را به آب غسل دهد. پس طاهر خواهد بود. ");
INSERT INTO pesOPV_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","«و در روز هشتم دو بره نرینه بی‌عیب، ویک بره ماده‌یک ساله بی‌عیب، و سه عشر آرد نرم سرشته شده به روغن، برای هدیه آردی، و یک لج روغن بگیرد. ");
INSERT INTO pesOPV_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","و آن کاهن که او را تطهیر می‌کند، آن کس را که باید تطهیر شود، با این چیزها به حضور خداوند نزد در خیمه اجتماع حاضر کند. ");
INSERT INTO pesOPV_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","و کاهن یکی از بره های نرینه را گرفته، آن را باآن لج روغن برای قربانی جرم بگذراند. و آنها رابرای هدیه جنبانیدنی به حضور خداوند بجنباند. ");
INSERT INTO pesOPV_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","و بره را در جایی که قربانی گناه و قربانی سوختنی را ذبح می‌کنند، در مکان مقدس ذبح کند، زیرا قربانی جرم مثل قربانی گناه از آن کاهن است. این قدس اقداس است. ");
INSERT INTO pesOPV_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","و کاهن از خون قربانی جرم بگیرد، و کاهن آن را بر نرمه گوش راست کسی‌که باید تطهیر شود، و بر شست دست راست و بر شست پای راست وی بمالد. ");
INSERT INTO pesOPV_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","وکاهن قدری از لج روغن گرفته، آن را در کف دست چپ خود بریزد. ");
INSERT INTO pesOPV_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","و کاهن انگشت راست خود را به روغنی که در کف چپ خود دارد فروبرد، و هفت مرتبه روغن را به حضور خداوندبپاشد. ");
INSERT INTO pesOPV_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","و کاهن از باقی روغن که در کف وی است بر نرمه گوش راست و بر شست دست راست و بر شست پای راست آن کس که بایدتطهیر شود، بالای خون قربانی جرم بمالد. ");
INSERT INTO pesOPV_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","وبقیه روغن را که در کف کاهن است بر سر آن کس که باید تطهیر شود بمالد و کاهن برای وی به حضور خداوند کفاره خواهد نمود. ");
INSERT INTO pesOPV_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","و کاهن قربانی گناه را بگذراند، و برای آن کس که بایدتطهیر شود نجاست او را کفاره نماید. و بعد از آن قربانی سوختنی را ذبح کند. ");
INSERT INTO pesOPV_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","و کاهن قربانی سوختنی و هدیه آردی را بر مذبح بگذراند، وبرای وی کفاره خواهد کرد، و طاهر خواهد بود. ");
INSERT INTO pesOPV_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","و اگر او فقیر باشد و دستش به اینها نرسد، پس یک بره نرینه برای قربانی جرم تا جنبانیده شود وبرای وی کفاره کند، بگیرد و یک عشر از آرد نرم سرشته شده به روغن برای هدیه آردی و یک لج روغن، ");
INSERT INTO pesOPV_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","و دو فاخته یا دو جوجه کبوتر، آنچه دستش به آن برسد، و یکی قربانی گناه و دیگری قربانی سوختنی بشود. ");
INSERT INTO pesOPV_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","«و در روز هشتم آنها را نزد کاهن به درخیمه اجتماع برای طهارت خود به حضور خداوند بیاورد. ");
INSERT INTO pesOPV_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","و کاهن بره قربانی جرم و لج روغن را بگیرد و کاهن آنها را برای هدیه جنبانیدنی به حضور خداوند بجنباند. ");
INSERT INTO pesOPV_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","وقربانی جرم را ذبح نماید و کاهن از خون قربانی جرم گرفته، بر نرمه گوش راست و شست دست راست و شست پای راست کسی‌که تطهیرمی شود بمالد. ");
INSERT INTO pesOPV_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","و کاهن قدری از روغن را به کف دست چپ خود بریزد. ");
INSERT INTO pesOPV_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","و کاهن از روغنی که دردست چپ خود دارد، به انگشت راست خودهفت مرتبه به حضور خداوند بپاشد. ");
INSERT INTO pesOPV_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","و کاهن ازروغنی که در دست دارد بر نرمه گوش راست و برشست دست راست و بر شست پای راست کسی‌که تطهیر می‌شود، بر جای خون قربانی جرم بمالد. ");
INSERT INTO pesOPV_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","و بقیه روغنی که در دست کاهن است آن را بر سر کسی‌که تطهیر می‌شود بمالد تا برای وی به حضور خداوند کفاره کند. ");
INSERT INTO pesOPV_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","و یکی از دوفاخته یا از دو جوجه کبوتر را از آنچه دستش به آن رسیده باشد بگذراند. ");
INSERT INTO pesOPV_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","یعنی هر‌آنچه دست وی به آن برسد، یکی را برای قربانی گناه ودیگری را برای قربانی سوختنی با هدیه آردی. وکاهن برای کسی‌که تطهیر می‌شود به حضورخداوند کفاره خواهد کرد.» ");
INSERT INTO pesOPV_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","این است قانون کسی‌که بلای برص دارد، و دست وی به تطهیرخود نمی رسد. ");
INSERT INTO pesOPV_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","و خداوند موسی و هارون را خطاب کرده، گفت: ");
INSERT INTO pesOPV_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","«چون به زمین کنعان که من آن را به شمابه ملکیت می‌دهم داخل شوید، و بلای برص رادر خانه‌ای از زمین ملک شما عارض گردانم، ");
INSERT INTO pesOPV_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","آنگاه صاحب‌خانه آمده، کاهن را اطلاع داده، بگوید که مرا به نظر می‌آید که مثل بلا در خانه است. ");
INSERT INTO pesOPV_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","و کاهن امر فرماید تا قبل از داخل شدن کاهن برای دیدن بلا، خانه را خالی کنند، مباداآنچه در خانه است نجس شود، و بعد از آن کاهن برای دیدن خانه داخل شود، ");
INSERT INTO pesOPV_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","و بلا را ملاحظه نماید. اگر بلا در دیوارهای خانه از خطهای مایل به سبزی یا سرخی باشد، و از سطح دیوار گودتربنماید، ");
INSERT INTO pesOPV_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","پس کاهن از خانه نزد در بیرون رود وخانه را هفت روز ببندد. ");
INSERT INTO pesOPV_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","و در روز هفتم کاهن باز بیاید و ملاحظه نماید اگر بلا در دیوارهای خانه پهن شده باشد، ");
INSERT INTO pesOPV_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","آنگاه کاهن امر فرماید تاسنگهایی را که بلا در آنهاست کنده، آنها را به‌جای ناپاک بیرون شهر بیندازند. ");
INSERT INTO pesOPV_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","و اندرون خانه را از هر طرف بتراشند و خاکی را که تراشیده باشند به‌جای ناپاک بیرون شهر بریزند. ");
INSERT INTO pesOPV_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","وسنگهای دیگر گرفته، به‌جای آن سنگها بگذارندو خاک دیگر گرفته، خانه را اندود کنند. ");
INSERT INTO pesOPV_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","و اگربلا برگردد و بعد از کندن سنگها و تراشیدن واندود کردن خانه باز در خانه بروز کند، ");
INSERT INTO pesOPV_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","پس کاهن بیاید و ملاحظه نماید. اگر بلا در خانه پهن شده باشد این برص مفسد در خانه است و آن نجس است. ");
INSERT INTO pesOPV_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","پس خانه را خراب کند باسنگهایش و چوبش و تمامی خاک خانه و به‌جای ناپاک بیرون شهر بیندازند. ");
INSERT INTO pesOPV_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","و هر‌که داخل خانه شود در تمام روزهایی که بسته باشد تا شام نجس خواهد بود. ");
INSERT INTO pesOPV_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","و هر‌که در خانه بخوابدرخت خود را بشوید و هر‌که در خانه چیزی خورد، رخت خود را بشوید. ");
INSERT INTO pesOPV_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","و چون کاهن بیاید و ملاحظه نماید اگر بعد از اندود کردن خانه بلا در خانه پهن نشده باشد، پس کاهن حکم به طهارت خانه بدهد، زیرا بلا رفع شده است. ");
INSERT INTO pesOPV_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","وبرای تطهیر خانه دو گنجشک و چوب ارز و قرمزو زوفا بگیرد. ");
INSERT INTO pesOPV_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","و یک گنجشک را در ظرف سفالین بر آب روان ذبح نماید، ");
INSERT INTO pesOPV_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","و چوب ارز وزوفا و قرمز و گنجشک زنده را گرفته، آنها را به خون گنجشک ذبح شده و آب روان فرو برد، وهفت مرتبه بر خانه بپاشد. ");
INSERT INTO pesOPV_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","و خانه را به خون گنجشک و به آب روان و به گنجشک زنده و به چوب ارز و زوفا و قرمز تطهیر نماید. ");
INSERT INTO pesOPV_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","وگنجشک زنده را بیرون شهر به سوی صحرا رهاکند، و خانه را کفاره نماید و طاهر خواهد بود.» ");
INSERT INTO pesOPV_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","این است قانون، برای هر بلای برص و برای سعفه، ");
INSERT INTO pesOPV_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","و برای برص رخت و خانه، ");
INSERT INTO pesOPV_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","و برای آماس و قوبا و لکه براق. ");
INSERT INTO pesOPV_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","و برای تعلیم دادن که چه وقت نجس می‌باشد و چه وقت طاهر. این قانون برص است. ");
INSERT INTO pesOPV_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","و خداوند موسی و هارون را خطاب کرده، گفت: ");
INSERT INTO pesOPV_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","«بنی‌اسرائیل را خطاب کرده، به ایشان بگویید: مردی که جریان از بدن خود دارد او به‌سبب جریانش نجس است. ");
INSERT INTO pesOPV_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","واین است نجاستش، به‌سبب جریان او، خواه جریانش از گوشتش روان باشد خواه جریانش ازگوشتش بسته باشد. این نجاست اوست. ");
INSERT INTO pesOPV_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","هربستری که صاحب جریان بر آن بخوابد نجس است، و هر‌چه بر آن بنشیند نجس است. ");
INSERT INTO pesOPV_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","و هرکه بستر او را لمس نماید، رخت خود را بشوید، وبه آب غسل کند، و تا شام نجس باشد. ");
INSERT INTO pesOPV_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","و هر‌که بنشیند بر هر‌چه صاحب جریان بر آن نشسته بود، رخت خود را بشوید و به آب غسل کند، وتا شام نجس باشد. ");
INSERT INTO pesOPV_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","و هر‌که بدن صاحب جریان رالمس کند رخت خود را بشوید و به آب غسل کند و تا شام نجس باشد. ");
INSERT INTO pesOPV_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","و اگر صاحب جریان، بر شخص طاهر آب دهن اندازد، آن کس رخت خود را بشوید، و به آب غسل کند، و تا شام نجس باشد. ");
INSERT INTO pesOPV_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","و هر زینی که صاحب جریان بر آن سوارشود، نجس باشد. ");
INSERT INTO pesOPV_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","و هر‌که چیزی را که زیر اوبوده باشد لمس نماید تا شام نجس بوده، و هر‌که این چیزها را بردارد، رخت خود را بشوید، و به آب غسل کند و تا شام نجس باشد. ");
INSERT INTO pesOPV_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","و هر کسی را که صاحب جریان لمس نماید، و دست خود رابه آب نشسته باشد، رخت خود را بشوید، وبه آب غسل کند و تا شام نجس باشد. ");
INSERT INTO pesOPV_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","و ظرف سفالین که صاحب جریان آن را لمس نماید، شکسته شود، و هر ظرف چوبین به آب شسته شود. ");
INSERT INTO pesOPV_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","و چون صاحب جریان از جریان خودطاهر شده باشد، آنگاه هفت روز برای تطهیرخود بشمارد، و رخت خود را بشوید و بدن خودرا به آب غسل دهد و طاهر باشد. ");
INSERT INTO pesOPV_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","و در روزهشتم دو فاخته یا دو جوجه کبوتر بگیرد، و به حضور خداوند به در خیمه اجتماع آمده، آنها رابه کاهن بدهد. ");
INSERT INTO pesOPV_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","و کاهن آنها را بگذراند، یکی برای قربانی گناه و دیگری برای قربانی سوختنی. و کاهن برای وی به حضور خداوند جریانش راکفاره خواهد کرد. ");
INSERT INTO pesOPV_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","و چون منی از کسی درآیدتمامی بدن خود را به آب غسل دهد، وتا شام نجس باشد. ");
INSERT INTO pesOPV_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","و هر رخت و هر چرمی که منی برآن باشد به آب شسته شود، و تا شام نجس باشد. ");
INSERT INTO pesOPV_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","و هر زنی که مرد با او بخوابد و انزال کند، به آب غسل کنند و تا شام نجس باشند. ");
INSERT INTO pesOPV_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","«و اگر زنی جریان دارد، و جریانی که دربدنش است خون باشد، هفت روز در حیض خودبماند. و هر‌که او را لمس نماید، تا شام نجس باشد. ");
INSERT INTO pesOPV_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","و بر هر چیزی که در حیض خود بخوابدنجس باشد، و بر هر چیزی که بنشیند نجس باشد. ");
INSERT INTO pesOPV_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","و هر‌که بستر او را لمس کند، رخت خود را بشوید، و به آب غسل کند و تا شام نجس باشد. ");
INSERT INTO pesOPV_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","و هر‌که چیزی را که او بر آن نشسته بود لمس نماید رخت خود را بشوید، و به آب غسل کند، وتا شام نجس باشد. ");
INSERT INTO pesOPV_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","و اگر آن بر بستر باشد یا برهر چیزی که او بر آن نشسته بود، چون آن چیز رالمس کند تا شام نجس باشد. ");
INSERT INTO pesOPV_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","و اگر مردی با اوهم بستر شود و حیض او بر وی باشد تا هفت روزنجس خواهد بود. و هر بستری که بر آن بخوابدنجس خواهد بود. ");
INSERT INTO pesOPV_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","و زنی که روزهای بسیار، غیر از زمان حیض خود جریان خون دارد، یازیاده از زمان حیض خود جریان دارد، تمامی روزهای جریان نجاستش مثل روزهای حیضش خواهد بود. او نجس است. ");
INSERT INTO pesOPV_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","و هر بستری که درروزهای جریان خود بر آن بخوابد، مثل بسترحیضش برای وی خواهد بود. و هر چیزی که برآن بنشیند مثل نجاست حیضش نجس خواهدبود. ");
INSERT INTO pesOPV_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","و هر‌که این چیزها را لمس نماید نجس می‌باشد. پس رخت خود را بشوید و به آب غسل کند و تا شام نجس باشد. ");
INSERT INTO pesOPV_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","و اگر از جریان خودطاهر شده باشد، هفت روز برای خود بشمارد، وبعد از آن طاهر خواهد بود. ");
INSERT INTO pesOPV_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","و در روز هشتم دوفاخته یا دو جوجه کبوتر بگیرد، و آنها را نزد کاهن به در خیمه اجتماع بیاورد. ");
INSERT INTO pesOPV_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","و کاهن یکی رابرای قربانی گناه و دیگری را برای قربانی سوختنی بگذراند. و کاهن برای وی نجاست جریانش را به حضور خداوند کفاره کند. ");
INSERT INTO pesOPV_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","پس بنی‌اسرائیل را از نجاست ایشان جدا خواهیدکرد، مبادا مسکن مرا که در میان ایشان است نجس سازند و در نجاست خود بمیرند.» ");
INSERT INTO pesOPV_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","این است قانون کسی‌که جریان دارد، و کسی‌که منی از وی درآید و از آن نجس شده باشد. ");
INSERT INTO pesOPV_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","و حایض درحیضش و هر‌که جریان دارد خواه مرد خواه زن، و مردی که با زن نجس همبستر شود. ");
INSERT INTO pesOPV_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","و خداوند موسی را بعد از مردن دو پسرهارون، وقتی که نزد خداوند آمدند ومردند خطاب کرده، گفت: ");
INSERT INTO pesOPV_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","«پس خداوند به موسی گفت: برادر خود هارون را بگو که به قدس درون حجاب پیش کرسی رحمت که بر تابوت است همه وقت داخل نشود، مبادا بمیرد، زیرا که در ابر بر کرسی رحمت ظاهر خواهم شد. ");
INSERT INTO pesOPV_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","و بااین چیزها هارون داخل قدس بشود، با گوساله‌ای برای قربانی گناه، و قوچی برای قربانی سوختنی. ");
INSERT INTO pesOPV_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","و پیراهن کتان مقدس را بپوشد، و زیر جامه کتان بر بدنش باشد، و به کمربند کتان بسته شود، و به عمامه کتان معمم باشد. اینها رخت مقدس است. پس بدن خود را به آب غسل داده، آنها را بپوشد. ");
INSERT INTO pesOPV_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","و از جماعت بنی‌اسرائیل دو بز نرینه برای قربانی گناه، و یک قوچ برای قربانی سوختنی بگیرد. ");
INSERT INTO pesOPV_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","و هارون گوساله قربانی گناه را که برای خود اوست بگذراند، و برای خود و اهل خانه خود کفاره نماید. ");
INSERT INTO pesOPV_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","و دو بز را بگیرد و آنها را به حضور خداوند به در خیمه اجتماع حاضر سازد. ");
INSERT INTO pesOPV_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","و هارون بر آن دو بز قرعه اندازد، یک قرعه برای خداوند و یک قرعه برای عزازیل. ");
INSERT INTO pesOPV_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","و هارون بزی را که قرعه برای خداوند بر آن برآمد نزدیک بیاورد، و بجهت قربانی گناه بگذراند. ");
INSERT INTO pesOPV_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","و بزی که قرعه برای عزازیل بر آن برآمد به حضور خداوندزنده حاضر شود، و بر آن کفاره نماید و آن را برای عزازیل به صحرا بفرستد. ");
INSERT INTO pesOPV_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","«و هارون گاو قربانی گناه را که برای خوداوست نزدیک بیاورد، و برای خود و اهل خانه خود کفاره نماید، و گاو قربانی گناه را که برای خود اوست ذبح کند. ");
INSERT INTO pesOPV_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","و مجمری پر از زغال آتش از روی مذبح که به حضور خداوند است ودو مشت پر از بخور معطر کوبیده شده برداشته، به اندرون حجاب بیاورد. ");
INSERT INTO pesOPV_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","و بخور را بر آتش به حضور خداوند بنهد تا ابر بخور کرسی رحمت راکه بر تابوت شهادت است بپوشاند، مبادا بمیرد. ");
INSERT INTO pesOPV_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","و از خون گاو گرفته، بر کرسی رحمت به انگشت خود به طرف مشرق بپاشد، و قدری ازخون را پیش روی کرسی رحمت هفت مرتبه بپاشد. ");
INSERT INTO pesOPV_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","پس بز قربانی گناه را که برای قوم است ذبح نماید، و خونش را به اندرون حجاب بیاورد، وبا خونش چنانکه با خون گاو عمل کرده بودعمل کند، و آن را بر کرسی رحمت و پیش روی کرسی رحمت بپاشد. ");
INSERT INTO pesOPV_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","و برای قدس کفاره نماید به‌سبب نجاسات بنی‌اسرائیل، و به‌سبب تقصیرهای ایشان با تمامی گناهان ایشان، و برای خیمه اجتماع که با ایشان در میان نجاسات ایشان ساکن است، همچنین بکند. ");
INSERT INTO pesOPV_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","و هیچکس درخیمه اجتماع نباشد، و از وقتی که برای کردن کفاره داخل قدس بشود تا وقتی که بیرون آید، پس برای خود و برای اهل خانه خود و برای تمامی جماعت اسرائیل کفاره خواهد کرد. ");
INSERT INTO pesOPV_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","پس نزد مذبح که به حضور خداوند است بیرون آید، و برای آن کفاره نماید، و از خون گاو و ازخون بز گرفته، آن را بر شاخه های مذبح بهر طرف بپاشد. ");
INSERT INTO pesOPV_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","و قدری از خون را به انگشت خود هفت مرتبه بر آن بپاشد و آن را تطهیر کند، و آن رااز نجاسات بنی‌اسرائیل تقدیس نماید. ");
INSERT INTO pesOPV_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","«و چون از کفاره نمودن برای قدس و برای خیمه اجتماع و برای مذبح فارغ شود، آنگاه بززنده را نزدیک بیاورد. ");
INSERT INTO pesOPV_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","و هارون دو دست خودرا بر سر بز زنده بنهد، و همه خطایای بنی‌اسرائیل و همه تقصیرهای ایشان را با همه گناهان ایشان اعتراف نماید، و آنها را بر سر بز بگذارد و آن را به‌دست شخص حاضر به صحرا بفرستد. ");
INSERT INTO pesOPV_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","و بزهمه گناهان ایشان را به زمین ویران بر خودخواهد برد. پس بز را به صحرا رها کند. ");
INSERT INTO pesOPV_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","وهارون به خیمه اجتماع داخل شود، و رخت کتان را که در وقت داخل شدن به قدس پوشیده بودبیرون کرده، آنها را در آنجا بگذارد. ");
INSERT INTO pesOPV_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","و بدن خود را در جای مقدس به آب غسل دهد، ورخت خود را پوشیده، بیرون آید، و قربانی سوختنی خود و قربانی سوختنی قوم را بگذراند، و برای خود و برای قوم کفاره نماید. ");
INSERT INTO pesOPV_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","و پیه قربانی گناه را بر مذبح بسوزاند. ");
INSERT INTO pesOPV_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","و آنکه بز رابرای عزازیل رها کرد رخت خود را بشوید و بدن خود را به آب غسل دهد، و بعد از آن به لشکرگاه داخل شود. ");
INSERT INTO pesOPV_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","و گاو قربانی گناه و بز قربانی گناه را که خون آنها به قدس برای کردن کفاره آورده شد، بیرون لشکرگاه برده شود، و پوست و گوشت و سرگین آنها را به آتش بسوزانند. ");
INSERT INTO pesOPV_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","و آنکه آنهارا سوزانید رخت خود را بشوید و بدن خود را به آب غسل دهد، و بعد از آن به لشکرگاه داخل شود. ");
INSERT INTO pesOPV_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","«و این برای شما فریضه دائمی باشد، که درروز دهم از ماه هفتم جانهای خود را ذلیل سازید، و هیچ کار مکنید، خواه متوطن خواه غریبی که درمیان شما ماوا گزیده باشد. ");
INSERT INTO pesOPV_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","زیرا که در آن روزکفاره برای تطهیر شما کرده خواهد شد، و ازجمیع گناهان خود به حضور خداوند طاهرخواهید شد. ");
INSERT INTO pesOPV_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","این سبت آرامی برای شماست، پس جانهای خود را ذلیل سازید. این است فریضه دائمی. ");
INSERT INTO pesOPV_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","و کاهنی که مسح شده، و تخصیص شده باشد، تا در جای پدر خود کهانت نمایدکفاره را بنماید. و رختهای کتان یعنی رختهای مقدس را بپوشد. ");
INSERT INTO pesOPV_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","و برای قدس مقدس کفاره نماید، و برای خیمه اجتماع و مذبح کفاره نماید، و برای کهنه و تمامی جماعت قوم کفاره نماید. ");
INSERT INTO pesOPV_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","و این برای شما فریضه دائمی خواهد بود تابرای بنی‌اسرائیل از تمامی گناهان ایشان یک مرتبه هر سال کفاره شود.» پس چنانکه خداوندموسی را امر فرمود، همچنان بعمل آورد. ");
INSERT INTO pesOPV_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","و خداوند موسی را خطاب کرده، گفت: ");
INSERT INTO pesOPV_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","«هارون و پسرانش و جمیع بنی‌اسرائیل را خطاب کرده، به ایشان بگو: این است کاری که خداوند می‌فرماید و می‌گوید: ");
INSERT INTO pesOPV_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","هرشخصی از خاندان اسرائیل که گاو یا گوسفند یا بزدر لشکرگاه ذبح نماید، یا آنکه بیرون لشکرگاه ذبح نماید، ");
INSERT INTO pesOPV_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","و آن را به در خیمه اجتماع نیاورد، تاقربانی برای خداوند پیش مسکن خداوندبگذراند، بر آن شخص خون محسوب خواهدشد. او خون ریخته است و آن شخص از قوم خود منقطع خواهد شد. ");
INSERT INTO pesOPV_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","تا آنکه بنی‌اسرائیل ذبایح خود را که در صحرا ذبح می‌کنند بیاورند، یعنی برای خداوند به در خیمه اجتماع نزد کاهن آنها را بیاورند، و آنها را بجهت ذبایح سلامتی برای خداوند ذبح نمایند. ");
INSERT INTO pesOPV_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","و کاهن خون را برمذبح خداوند نزد در خیمه اجتماع بپاشد، و پیه را بسوزاند تا عطر خوشبو برای خداوند شود. ");
INSERT INTO pesOPV_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","وبعد از این، ذبایح خود را برای دیوهایی که درعقب آنها زنا می‌کنند دیگر ذبح ننمایند. این برای ایشان در پشتهای ایشان فریضه دائمی خواهدبود. ");
INSERT INTO pesOPV_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","«و ایشان را بگو: هر کس از خاندان اسرائیل و از غریبانی که در میان شما ماوا گزینند که قربانی سوختنی یا ذبیحه بگذراند، ");
INSERT INTO pesOPV_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","و آن را به درخیمه اجتماع نیاورد، تا آن را برای خداوندبگذراند. آن شخص از قوم خود منقطع خواهدشد. ");
INSERT INTO pesOPV_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","و هر کس از خاندان اسرائیل یا از غریبانی که در میان شما ماوا گزینند که هر قسم خون رابخورد، من روی خود را بر آن شخصی که خون خورده باشد برمی گردانم، و او را از میان قومش منقطع خواهم ساخت. ");
INSERT INTO pesOPV_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","زیرا که جان جسد درخون است، و من آن را بر مذبح به شما داده‌ام تابرای جانهای شما کفاره کند، زیرا خون است که برای جان کفاره می‌کند. ");
INSERT INTO pesOPV_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","بنابراین بنی‌اسرائیل را گفته‌ام: هیچکس از شما خون نخورد و غریبی که در میان شما ماوا گزیند خون نخورد. ");
INSERT INTO pesOPV_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","و هرشخص از بنی‌اسرائیل یا از غریبانی که در میان شما ماوا گزینند، که هر جانور یا مرغی را که خورده می‌شود صید کند، پس خون آن را بریزد وبه خاک بپوشاند. ");
INSERT INTO pesOPV_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","زیرا جان هر ذی جسد خون آن و جان آن یکی است، پس بنی‌اسرائیل راگفته‌ام خون هیچ ذی جسد را مخورید، زیرا جان هر ذی جسد خون آن است، هر‌که آن را بخوردمنقطع خواهد شد. ");
INSERT INTO pesOPV_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","و هر کسی از متوطنان یا ازغریبانی که میته یا دریده شده‌ای بخورد، رخت خود را بشوید، و به آب غسل کند و تا شام نجس باشد. پس طاهر خواهد شد. ");
INSERT INTO pesOPV_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","و اگر آن را نشویدو بدن خود را غسل ندهد، متحمل گناه خودخواهد بود.» ");
INSERT INTO pesOPV_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","و خداوند موسی را خطاب کرده، گفت: ");
INSERT INTO pesOPV_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","«بنی‌اسرائیل را خطاب کرده، به ایشان بگو: من یهوه خدای شما هستم. ");
INSERT INTO pesOPV_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","مثل اعمال زمین مصر که در آن ساکن می‌بودید عمل منمایید، و مثل اعمال زمین کنعان که من شما را به آنجا داخل خواهم کرد عمل منمایید، و برحسب فرایض ایشان رفتار مکنید. ");
INSERT INTO pesOPV_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","احکام مرا بجاآورید و فرایض مرا نگاه دارید تا در آنها رفتارنمایید، من یهوه خدای شما هستم. ");
INSERT INTO pesOPV_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","پس فرایض و احکام مرا نگاه دارید، که هر آدمی که آنها را بجاآورد در آنها زیست خواهد کرد، من یهوه هستم. ");
INSERT INTO pesOPV_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","هیچ‌کس به احدی از اقربای خویش نزدیکی ننماید تا کشف عورت او بکند. من یهوه هستم. ");
INSERT INTO pesOPV_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","عورت پدر خود یعنی مادر خود را کشف منما؛ او مادر توست. کشف عورت او مکن. ");
INSERT INTO pesOPV_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","عورت زن پدر خود را کشف مکن. آن عورت پدر تو است. ");
INSERT INTO pesOPV_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","عورت خواهر خود، خواه دختر پدرت، خواه دختر مادرت چه مولود در خانه، چه مولودبیرون، عورت ایشان را کشف منما. ");
INSERT INTO pesOPV_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","عورت دختر پسرت و دختر دخترت، عورت ایشان را کشف مکن، زیرا که اینها عورت تو است. ");
INSERT INTO pesOPV_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","عورت دختر زن پدرت که از پدر تو زاییده شده باشد، او خواهر تو است کشف عورت او رامکن. ");
INSERT INTO pesOPV_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","عورت خواهر پدر خود را کشف مکن، او از اقربای پدر تو است. ");
INSERT INTO pesOPV_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","عورت خواهرمادر خود را کشف مکن، او از اقربای مادر تواست. ");
INSERT INTO pesOPV_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","عورت برادر پدر خود را کشف مکن، وبه زن او نزدیکی منما. او (به منزله ) عمه تو است. ");
INSERT INTO pesOPV_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","عورت عروس خود را کشف مکن، او زن پسرتو است. عورت او را کشف مکن. ");
INSERT INTO pesOPV_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","عورت زن برادر خود را کشف مکن. آن عورت برادر تواست. ");
INSERT INTO pesOPV_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","عورت زنی را با دخترش کشف مکن. ودختر پسر او یا دختر دختر او را مگیر، تا عورت او را کشف کنی. اینان از اقربای او می‌باشند و این فجور است. ");
INSERT INTO pesOPV_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","و زنی را با خواهرش مگیر، تاهیوی او بشود، و تا عورت او را با وی مادامی که او زنده است، کشف نمایی. ");
INSERT INTO pesOPV_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","و به زنی درنجاست حیضش نزدیکی منما، تا عورت او راکشف کنی. ");
INSERT INTO pesOPV_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","و با زن همسایه خود همبسترمشو، تا خود را با وی نجس سازی. ");
INSERT INTO pesOPV_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","و کسی ازذریت خود را برای مولک از آتش مگذران و نام خدای خود را بی‌حرمت مساز. من یهوه هستم. ");
INSERT INTO pesOPV_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","و با ذکور مثل زن جماع مکن، زیرا که این فجور است. ");
INSERT INTO pesOPV_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","و با هیچ بهیمه‌ای جماع مکن، تاخود را به آن نجس سازی، و زنی پیش بهیمه‌ای نایستد تا با آن جماع کند، زیرا که این فجوراست. ");
INSERT INTO pesOPV_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","«به هیچ کدام از اینها خویشتن را نجس مسازید، زیرا به همه اینها امتهایی که من پیش روی شما بیرون می‌کنم، نجس شده‌اند. ");
INSERT INTO pesOPV_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","وزمین نجس شده است، و انتقام گناهش را از آن خواهم کشید، و زمین ساکنان خود را قی خواهدنمود. ");
INSERT INTO pesOPV_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","پس شما فرایض و احکام مرا نگاه دارید، و هیچ کدام از این فجور را به عمل نیاورید، نه متوطن و نه غریبی که در میان شما ماواگزیند. ");
INSERT INTO pesOPV_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","زیرا مردمان آن زمین که قبل از شمابودند، جمیع این فجور را کردند، و زمین نجس شده است. ");
INSERT INTO pesOPV_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","مبادا زمین شما را نیز قی کند، اگرآن را نجس سازید، چنانکه امتهایی را که قبل ازشما بودند، قی کرده است. ");
INSERT INTO pesOPV_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","زیرا هر کسی‌که یکی از این فجور را بکند، همه کسانی که کرده باشند، از میان قوم خود منقطع خواهند شد. ");
INSERT INTO pesOPV_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","پس وصیت مرا نگاه دارید، و از این رسوم زشت که قبل از شما به عمل آورده شده است عمل منمایید، و خود را به آنها نجس مسازید. من یهوه خدای شما هستم.» ");
INSERT INTO pesOPV_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","و خداوند موسی را خطاب کرده، گفت: ");
INSERT INTO pesOPV_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","«تمامی جماعت بنی‌اسرائیل راخطاب کرده، به ایشان بگو: مقدس باشید، زیرا که من یهوه خدای شما قدوس هستم. ");
INSERT INTO pesOPV_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","هر یکی ازشما مادر و پدر خود را احترام نماید و سبت های مرا نگاه دارید، من یهوه خدای شما هستم. ");
INSERT INTO pesOPV_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","به سوی بتها میل مکنید، و خدایان ریخته شده برای خود مسازید. من یهوه خدای شما هستم. ");
INSERT INTO pesOPV_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","وچون ذبیحه سلامتی نزد خداوند بگذرانید، آن رابگذرانید تا مقبول شوید، ");
INSERT INTO pesOPV_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","در روزی که آن را ذبح نمایید. و در فردای آن روز خورده شود، و اگرچیزی از آن تا روز سوم بماند به آتش سوخته شود. ");
INSERT INTO pesOPV_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","و اگر در روز سوم خورده شود، مکروه می‌باشد، مقبول نخواهد شد. ");
INSERT INTO pesOPV_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","و هر‌که آن رابخورد، متحمل گناه خود خواهد بود، زیرا چیزمقدس خداوند را بی‌حرمت کرده است، آن کس از قوم خود را منقطع خواهد شد. ");
INSERT INTO pesOPV_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","«و چون حاصل زمین خود را درو کنید، گوشه های مزرعه خود را تمام نکنید، و محصول خود را خوشه چینی مکنید. ");
INSERT INTO pesOPV_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","و تاکستان خود رادانه چینی منما، و خوشه های ریخته شده تاکستان خود را بر مچین، آنها را برای فقیر وغریب بگذار، من یهوه خدای شما هستم. ");
INSERT INTO pesOPV_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","دزدی مکنید، و مکر منمایید، و با یکدیگردروغ مگویید. ");
INSERT INTO pesOPV_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","و به نام من قسم دروغ مخورید، که نام خدای خود را بی‌حرمت نموده باشی، من یهوه هستم. ");
INSERT INTO pesOPV_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","مال همسایه خود را غصب منما، و ستم مکن، و مزد مزدور نزد تو تا صبح نماند. ");
INSERT INTO pesOPV_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","کر را لعنت مکن، و پیش روی کور سنگ لغزش مگذار، و از خدای خود بترس، من یهوه هستم. ");
INSERT INTO pesOPV_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","در داوری بی‌انصافی مکن، و فقیر راطرفداری منما، و بزرگ را محترم مدار، و درباره همسایه خود به انصاف داوری بکن؛ ");
INSERT INTO pesOPV_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","در میان قوم خود برای سخن‌چینی گردش مکن، و بر خون همسایه خود مایست. من یهوه هستم. ");
INSERT INTO pesOPV_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","برادر خود را در دل خود بغض منما، البته همسایه خودرا تنبیه کن، و به‌سبب او متحمل گناه مباش. ");
INSERT INTO pesOPV_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","ازابنای قوم خود انتقام مگیر، و کینه مورز، وهمسایه خود را مثل خویشتن محبت نما. من یهوه هستم. ");
INSERT INTO pesOPV_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","فرایض مرا نگاه دارید. بهیمه خودرا با غیر جنس به جماع وامدار؛ و مزرعه خود رابه دو قسم تخم مکار؛ و رخت از دوقسم بافته شده در بر خود مکن. ");
INSERT INTO pesOPV_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","و مردی که با زنی همبستر شود و آن زن کنیز و نامزد کسی باشد، امافدیه نداده شده، و نه آزادی به او بخشیده، ایشان را سیاست باید کرد، لیکن کشته نشوند زیرا که اوآزاد نبود. ");
INSERT INTO pesOPV_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","و مرد برای قربانی جرم خود قوچ قربانی جرم را نزد خداوند به در خیمه اجتماع بیاورد. ");
INSERT INTO pesOPV_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","و کاهن برای وی به قوچ قربانی جرم رانزد خداوند گناهش را که کرده است کفاره خواهدکرد، و او از گناهی که کرده است آمرزیده خواهدشد. ");
INSERT INTO pesOPV_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","«و چون به آن زمین داخل شدید و هر قسم درخت را برای خوراک نشاندید، پس میوه آن رامثل نامختونی آن بشمارید، سه سال برای شمانامختون باشد؛ خورده نشود. ");
INSERT INTO pesOPV_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","و در سال چهارم همه میوه آن برای تمجید خداوند مقدس خواهدبود. ");
INSERT INTO pesOPV_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","و در سال پنجم میوه آن را بخورید تامحصول خود را برای شما زیاده کند. من یهوه خدای شما هستم. ");
INSERT INTO pesOPV_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","هیچ‌چیز را با خون مخورید و تفال مزنید و شگون مکنید. ");
INSERT INTO pesOPV_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","گوشه های سر خود را متراشید، و گوشه های ریش خود را مچینید. ");
INSERT INTO pesOPV_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","بدن خود را بجهت مرده مجروح مسازید، و هیچ نشان بر خود داغ مکنید. من یهوه هستم. ");
INSERT INTO pesOPV_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","دختر خود را بی‌عصمت مساز، و او را به فاحشگی وامدار، مبادا زمین مرتکب زنا شود و زمین پر از فجور گردد. ");
INSERT INTO pesOPV_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","سبت های مرا نگاه دارید، و مکان مقدس مرامحترم دارید. من یهوه هستم. ");
INSERT INTO pesOPV_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","به اصحاب اجنه توجه مکنید، و از جادوگران پرسش منمایید، تاخود را به ایشان نجس سازید. من یهوه خدای شما هستم. ");
INSERT INTO pesOPV_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","در‌پیش ریش سفید برخیز، و روی مرد پیر را محترم دار، و از خدای خود بترس. من یهوه هستم. ");
INSERT INTO pesOPV_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","و چون غریبی با تو در زمین شما ماواگزیند، او را میازارید. ");
INSERT INTO pesOPV_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","غریبی که در میان شماماوا گزیند، مثل متوطن از شما باشد. و او را مثل خود محبت نما، زیرا که شما در زمین مصر غریب بودید. من یهوه خدای شما هستم. ");
INSERT INTO pesOPV_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","در عدل هیچ بی‌انصافی مکنید، یعنی در‌پیمایش یا دروزن یا در‌پیمانه. ");
INSERT INTO pesOPV_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","ترازوهای راست و سنگهای راست و ایفه راست و هین راست بدارید. من یهوه خدای شما هستم که شما را از زمین مصر بیرون آوردم. ");
INSERT INTO pesOPV_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","پس جمیع فرایض مرا و احکام مرانگاه دارید و آنها را بجا آورید. من یهوه هستم.» ");
INSERT INTO pesOPV_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","و خداوند موسی را خطاب کرده، گفت: ");
INSERT INTO pesOPV_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","«بنی‌اسرائیل را بگو: هر کسی ازبنی‌اسرائیل یا از غریبانی که در اسرائیل ماوا گزینند، که از ذریت خود به مولک بدهد، البته کشته شود؛ قوم زمین او را با سنگ سنگسار کنند. ");
INSERT INTO pesOPV_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","و من روی خود را به ضد آن شخص خواهم گردانید، و او را از میان قومش منقطع خواهم ساخت، زیرا که از ذریت خود به مولک داده است، تا مکان مقدس مرا نجس سازد، و نام قدوس مرا بی‌حرمت کند. ");
INSERT INTO pesOPV_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","و اگر قوم زمین چشمان خود را از آن شخص بپوشانند، وقتی که از ذریت خود به مولک داده باشد، و او را نکشند، ");
INSERT INTO pesOPV_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","آنگاه من روی خود را به ضد آن شخص وخاندانش خواهم گردانید، و او را و همه کسانی راکه در عقب او زناکار شده، در‌پیروی مولک زناکرده‌اند، از میان قوم ایشان منقطع خواهم ساخت. ");
INSERT INTO pesOPV_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","و کسی‌که به سوی صاحبان اجنه وجادوگران توجه نماید، تا در عقب ایشان زنا کند، من روی خود را به ضد آن شخص خواهم گردانید، و او را از میان قومش منقطع خواهم ساخت. ");
INSERT INTO pesOPV_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","پس خود را تقدیس نمایید و مقدس باشید، زیرا من یهوه خدای شما هستم. ");
INSERT INTO pesOPV_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","وفرایض مرا نگاه داشته، آنها را بجا آورید. من یهوه هستم که شما را تقدیس می‌نمایم. ");
INSERT INTO pesOPV_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","و هر کسی‌که پدر یا مادر خود را لعنت کند، البته کشته شود، چونکه پدر و مادر خود را لعنت کرده است، خونش بر خود او خواهد بود. ");
INSERT INTO pesOPV_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","و کسی‌که با زن دیگری زنا کند یعنی هر‌که با زن همسایه خود زنانماید، زانی و زانیه البته کشته شوند. ");
INSERT INTO pesOPV_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","و کسی‌که با زن پدر خود بخوابد، و عورت پدر خود راکشف نماید، هر دو البته کشته شوند. خون ایشان بر خود ایشان است. ");
INSERT INTO pesOPV_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","و اگر کسی با عروس خودبخوابد، هر دو ایشان البته کشته شوند. فاحشگی کرده‌اند خون ایشان بر خود ایشان است. ");
INSERT INTO pesOPV_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","و اگرمردی با مردی مثل با زن بخوابد هر دو فجورکرده‌اند. هر دو ایشان البته کشته شوند. خون ایشان بر خود ایشان است. ");
INSERT INTO pesOPV_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","و اگر کسی زنی ومادرش را بگیرد، این قباحت است. او و ایشان به آتش سوخته شوند، تا در میان شما قباحتی نباشد. ");
INSERT INTO pesOPV_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","و مردی که با بهیمه‌ای جماع کند، البته کشته شود و آن بهیمه را نیز بکشید. ");
INSERT INTO pesOPV_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","و زنی که به بهیمه‌ای نزدیک شود تا با آن جماع کند، آن زن و بهیمه را بکش. البته کشته شوند خون آنها برخود آنهاست. ");
INSERT INTO pesOPV_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","و کسی‌که خواهر خود را خواه دختر پدرش خواه دختر مادرش باشد بگیرد، وعورت او را ببیند و او عورت وی را ببیند، این رسوایی است. در‌پیش چشمان پسران قوم خودمنقطع شوند، چون که عورت خواهر خود راکشف کرده است. متحمل گناه خود خواهد بود. ");
INSERT INTO pesOPV_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","و کسی‌که با زن حایض بخوابد و عورت او راکشف نماید، او چشمه او را کشف کرده است واو چشمه خون خود را کشف نموده است، هردوی ایشان از میان قوم خود منقطع خواهند شد. ");
INSERT INTO pesOPV_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","و عورت خواهر مادرت یا خواهر پدرت راکشف مکن؛ آن کس خویش خود را عریان ساخته است. ایشان متحمل گناه خود خواهند بود. ");
INSERT INTO pesOPV_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","وکسی‌که با زن عموی خود بخوابد، عورت عموی خود را کشف کرده است. متحمل گناه خودخواهند بود. بی‌کس خواهند بود. ");
INSERT INTO pesOPV_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","و کسی‌که زن برادر خود را بگیرد، این نجاست است. عورت برادر خود را کشف کرده است. بی‌کس خواهندبود. ");
INSERT INTO pesOPV_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","«پس جمیع فرایض مرا و جمیع احکام مرانگاه داشته، آنها را بجا آورید، تا زمینی که من شمارا به آنجا می‌آورم تا در آن ساکن شوید، شما راقی نکند. ");
INSERT INTO pesOPV_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","و به رسوم قومهایی که من آنها را ازپیش شما بیرون می‌کنم رفتار ننمایید، زیرا که جمیع این کارها را کردند پس ایشان را مکروه داشتم. ");
INSERT INTO pesOPV_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","و به شما گفتم شما وارث این زمین خواهید بود ومن آن را به شما خواهم داد و وارث آن بشوید، زمینی که به شیر و شهد جاری است. من یهوه خدای شما هستم که شما را از امتهاامتیاز کرده‌ام. ");
INSERT INTO pesOPV_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","پس در میان بهایم طاهر و نجس، و در میان مرغان نجس و طاهر امتیاز کنید، وجانهای خود را به بهیمه یا مرغ یا به هیچ‌چیزی که بر زمین می‌خزد مکروه مسازید، که آنها رابرای شما جدا کرده‌ام تا نجس باشند. ");
INSERT INTO pesOPV_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","و برای من مقدس باشید زیرا که من یهوه قدوس هستم، وشما را از امتها امتیاز کرده‌ام تا از آن من باشید. ");
INSERT INTO pesOPV_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","مرد و زنی که صاحب اجنه یا جادوگر باشد، البته کشته شوند؛ ایشان را به سنگ سنگسار کنید. خون ایشان بر خود ایشان است.» ");
INSERT INTO pesOPV_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","و خداوند به موسی گفت: «به کاهنان یعنی پسران هارون خطاب کرده، به ایشان بگو: کسی از شما برای مردگان، خود رانجس نسازد، ");
INSERT INTO pesOPV_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","جز برای خویشان نزدیک خود، یعنی برای مادرش و پدرش و پسرش و دخترش و برادرش. ");
INSERT INTO pesOPV_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","و برای خواهر باکره خود که قریب او باشد و شوهر ندارد؛ برای او خود را نجس تواند کرد. ");
INSERT INTO pesOPV_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","چونکه در قوم خود رئیس است، خود را نجس نسازد، تا خویشتن را بی‌عصمت نماید. ");
INSERT INTO pesOPV_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","سر خود را بی‌مو نسازند، و گوشه های ریش خود را نتراشند، و بدن خود را مجروح ننمایند. ");
INSERT INTO pesOPV_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","برای خدای خود مقدس باشند، و نام خدای خود را بی‌حرمت ننمایند. زیرا که هدایای آتشین خداوند و طعام خدای خود را ایشان می‌گذرانند. پس مقدس باشند. ");
INSERT INTO pesOPV_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","زن زانیه یابی عصمت را نکاح ننمایند، و زن مطلقه ازشوهرش را نگیرند، زیرا او برای خدای خودمقدس است. ");
INSERT INTO pesOPV_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","پس او را تقدیس نما، زیرا که اوطعام خدای خود را می‌گذراند. پس برای تومقدس باشد، زیرا من یهوه که شما را تقدیس می‌کنم، قدوس هستم. ");
INSERT INTO pesOPV_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","و دختر هر کاهنی که خود را به فاحشگی بی‌عصمت ساخته باشد، پدرخود را بی‌عصمت کرده است. به آتش سوخته شود. ");
INSERT INTO pesOPV_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","«و آن که از میان برادرانش رئیس کهنه باشد، که بر سر او روغن مسح ریخته شده، وتخصیص گردیده باشد تا لباس را بپوشد، موی سر خود را نگشاید و گریبان خود را چاک نکند، ");
INSERT INTO pesOPV_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","و نزد هیچ شخص مرده نرود، و برای پدر خودو مادر خود خویشتن را نجس نسازد. ");
INSERT INTO pesOPV_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","و ازمکان مقدس بیرون نرود، و مکان مقدس خدای خود را بی‌عصمت نسازد، زیرا که تاج روغن مسح خدای او بر وی می‌باشد. من یهوه هستم. ");
INSERT INTO pesOPV_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","و اوزن باکره‌ای نکاح کند. ");
INSERT INTO pesOPV_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","و بیوه و مطلقه وبی عصمت و زانیه، اینها را نگیرد. فقط باکره‌ای از قوم خود را به زنی بگیرد. ");
INSERT INTO pesOPV_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","و ذریت خود را درمیان قوم خود بی‌عصمت نسازد. من یهوه هستم که او را مقدس می‌سازم.» ");
INSERT INTO pesOPV_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","و خداوند موسی را خطاب کرده، گفت: ");
INSERT INTO pesOPV_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","«هارون را خطاب کرده، بگو: هر کس از اولادتو در طبقات ایشان که عیب داشته باشد نزدیک نیاید، تا طعام خدای خود را بگذراند. ");
INSERT INTO pesOPV_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","پس هرکس که عیب دارد نزدیک نیاید، نه مرد کور و نه لنگ و نه پهن بینی و نه زایدالاعضا، ");
INSERT INTO pesOPV_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","و نه کسی‌که شکسته پا یا شکسته دست باشد، ");
INSERT INTO pesOPV_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","و نه گوژپشت و نه کوتاه قد و نه کسی‌که در چشم خودلکه دارد، و نه صاحب جرب و نه کسی‌که گری دارد و نه شکسته بیضه. ");
INSERT INTO pesOPV_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","هر کس از اولاد هارون کاهن که عیب داشته باشد نزدیک نیاید، تا هدایای آتشین خداوند را بگذراند، چونکه معیوب است، برای گذرانیدن طعام خدای خود نزدیک نیاید. ");
INSERT INTO pesOPV_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","طعام خدای خود را خواه از آنچه قدس اقداس است و خواه از آنچه مقدس است، بخورد. ");
INSERT INTO pesOPV_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","لیکن به حجاب داخل نشود و به مذبح نزدیک نیاید، چونکه معیوب است، تا مکان مقدس مرا بی‌حرمت نسازد. من یهوه هستم که ایشان را تقدیس می‌کنم.» ");
INSERT INTO pesOPV_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","پس موسی هارون وپسرانش و تمامی بنی‌اسرائیل را چنین گفت. ");
INSERT INTO pesOPV_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","و خداوند موسی را خطاب کرده، گفت: ");
INSERT INTO pesOPV_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","«هارون و پسرانش را بگو که ازموقوفات بنی‌اسرائیل که برای من وقف می‌کننداحتراز نمایند، و نام قدوس مرا بی‌حرمت نسازند. من یهوه هستم. ");
INSERT INTO pesOPV_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","به ایشان بگو: هر کس از همه ذریت شما در نسلهای شما که به موقوفاتی که بنی‌اسرائیل برای خداوند وقف نمایند نزدیک بیاید، و نجاست او بر وی باشد، آن کس از حضورمن منقطع خواهد شد. من یهوه هستم. ");
INSERT INTO pesOPV_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","هر کس از ذریت هارون که مبروص یا صاحب جریان باشد تا طاهر نشود، از چیزهای مقدس نخورد، وکسی‌که هر چیزی را که از میت نجس شود لمس نماید، و کسی‌که منی از وی درآید، ");
INSERT INTO pesOPV_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","و کسی‌که هر حشرات را که از آن نجس می‌شوند لمس نماید، یا آدمی را که از او نجس می‌شوند از هرنجاستی که دارد. ");
INSERT INTO pesOPV_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","پس کسی‌که یکی از اینها رالمس نماید تا شام نجس باشد، و تا بدن خود را به آب غسل ندهد از چیزهای مقدس نخورد. ");
INSERT INTO pesOPV_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","وچون آفتاب غروب کند، آنگاه طاهر خواهد بود، و بعد از آن از چیزهای مقدس بخورد چونکه خوراک وی است. ");
INSERT INTO pesOPV_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","میته یا دریده شده را نخوردتا از آن نجس شود. من یهوه هستم. ");
INSERT INTO pesOPV_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","پس وصیت مرا نگاه دارند مبادا به‌سبب آن متحمل گناه شوند. و اگر آن را بی‌حرمت نمایند بمیرند. من یهوه هستم که ایشان را تقدیس می‌نمایم. ");
INSERT INTO pesOPV_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","هیچ غریبی چیز مقدس نخورد، و مهمان کاهن ومزدور او چیز مقدس نخورد. ");
INSERT INTO pesOPV_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","اما اگر کاهن کسی را بخرد، زرخرید او می‌باشد. او آن رابخورد و خانه زاد او نیز. هر دو خوراک او رابخورند. ");
INSERT INTO pesOPV_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","و دختر کاهن اگر منکوحه مرد غریب باشد، از هدایای مقدس نخورد. ");
INSERT INTO pesOPV_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","و دختر کاهن که بیوه یا مطلقه بشود و اولاد نداشته، به خانه پدرخود مثل طفولیتش برگردد، خوراک پدر خود رابخورد، لیکن هیچ غریب از آن نخورد. ");
INSERT INTO pesOPV_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","و اگرکسی سهو چیز مقدس را بخورد، پنج یک بر آن اضافه کرده، آن چیز مقدس را به کاهن بدهد. ");
INSERT INTO pesOPV_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","وچیزهای مقدس بنی‌اسرائیل را که برای خداوندمی گذرانند، بی‌حرمت نسازند. ");
INSERT INTO pesOPV_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","و به خوردن چیزهای مقدس ایشان، ایشان را متحمل جرم گناه نسازند، زیرا من یهوه هستم که ایشان راتقدیس می‌نمایم.» ");
INSERT INTO pesOPV_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","و خداوند موسی را خطاب کرده، گفت: ");
INSERT INTO pesOPV_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","«هارون و پسرانش و جمیع بنی‌اسرائیل راخطاب کرده، به ایشان بگو: هر کس از خاندان اسرائیل و از غریبانی که در اسرائیل باشند که قربانی خود را بگذراند، خواه یکی از نذرهای ایشان، خواه یکی از نوافل ایشان، که آن را برای قربانی سوختنی نزد خداوند می‌گذرانند، ");
INSERT INTO pesOPV_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","تاشما مقبول شوید. آن را نر بی‌عیب از گاو یا ازگوسفند یا از بز بگذرانید. ");
INSERT INTO pesOPV_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","هر‌چه را که عیب دارد مگذرانید، برای شما مقبول نخواهد شد. ");
INSERT INTO pesOPV_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","و اگر کسی ذبیحه سلامتی برای خداوندبگذراند، خواه برای وفای نذر، خواه برای نافله، چه از رمه چه از گله، آن بی‌عیب باشد تا مقبول بشود، البته هیچ عیب در آن نباشد. ");
INSERT INTO pesOPV_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","کور یاشکسته یا مجروح یا آبله دار یا صاحب جرب یاگری، اینها را برای خداوند مگذرانید، و از اینهاهدیه آتشین برای خداوند بر مذبح مگذارید. ");
INSERT INTO pesOPV_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","اما گاو و گوسفند که زاید یا ناقص اعضا باشد، آن را برای نوافل بگذران، لیکن برای نذر قبول نخواهد شد. ");
INSERT INTO pesOPV_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","و آنچه را که بیضه آن کوفته یافشرده یا شکسته یا بریده باشد، برای خداوندنزدیک میاورید، و در زمین خود قربانی مگذرانید. ");
INSERT INTO pesOPV_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","و از دست غریب نیز طعام خدای خود را از هیچ‌یک از اینها مگذرانید، زیرا فسادآنها در آنهاست چونکه عیب دارند، برای شمامقبول نخواهند شد.» ");
INSERT INTO pesOPV_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","و خداوند موسی را خطاب کرده، گفت: ");
INSERT INTO pesOPV_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","«چون گاو یا گوسفند یا بز زاییده شود، هفت روز نزد مادر خود بماند و در روز هشتم و بعد برای قربانی هدیه آتشین نزد خداوند مقبول خواهد شد. ");
INSERT INTO pesOPV_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","اما گاو یا گوسفند آن را با بچه‌اش در یک روز ذبح منمایید. ");
INSERT INTO pesOPV_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","و چون ذبیحه تشکربرای خداوند ذبح نمایید، آن را ذبح کنید تا مقبول شوید. ");
INSERT INTO pesOPV_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","در همان روز خورده شود و چیزی ازآن را تا صبح نگاه ندارید. من یهوه هستم. ");
INSERT INTO pesOPV_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","پس اوامر مرا نگاه داشته، آنها را بجا آورید. من یهوه هستم. ");
INSERT INTO pesOPV_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","و نام قدوس مرا بی‌حرمت مسازید ودر میان بنی‌اسرائیل تقدیس خواهم شد. من یهوه هستم که شما را تقدیس می‌نمایم. ");
INSERT INTO pesOPV_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","و شما را اززمین مصر بیرون آوردم تا خدای شما باشم. من یهوه هستم.» ");
INSERT INTO pesOPV_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","و خداوند موسی را خطاب کرده، گفت: ");
INSERT INTO pesOPV_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","«بنی‌اسرائیل را خطاب کرده، به ایشان بگو: موسمهای خداوند که آنها رامحفلهای مقدس خواهید خواند، اینهاموسمهای من می‌باشند. ");
INSERT INTO pesOPV_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","«شش روز کار کرده شود و در روز هفتم سبت آرامی و محفل مقدس باشد. هیچ کارمکنید. آن در همه مسکنهای شما سبت برای خداوند است. ");
INSERT INTO pesOPV_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","«اینها موسمهای خداوند و محفلهای مقدس می‌باشد، که آنها را در وقتهای آنها اعلان باید کرد. ");
INSERT INTO pesOPV_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","در ماه اول، در روز چهاردهم ماه بین العصرین، فصح خداوند است. ");
INSERT INTO pesOPV_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","و در روزپانزدهم این ماه عید فطیر برای خداوند است، هفت روز فطیر بخورید. ");
INSERT INTO pesOPV_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","در روز اول محفل مقدس برای شما باشد، هیچ کار از شغل مکنید. ");
INSERT INTO pesOPV_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","هفت روز هدیه آتشین برای خداوند بگذرانید، و در روز هفتم، محفل مقدس باشد؛ هیچ کار ازشغل مکنید.» ");
INSERT INTO pesOPV_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","و خداوند موسی را خطاب کرده، گفت: ");
INSERT INTO pesOPV_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","«بنی‌اسرائیل را خطاب کرده، به ایشان بگو: چون به زمینی که من به شما می‌دهم داخل شوید، و محصول آن را درو کنید، آنگاه بافه نوبر خود رانزد کاهن بیاورید. ");
INSERT INTO pesOPV_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","و بافه را به حضور خداوندبجنباند تا شما مقبول شوید، در فردای بعد ازسبت کاهن آن را بجنباند. ");
INSERT INTO pesOPV_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","و در روزی که شمابافه را می‌جنبانید، بره یک ساله بی‌عیب برای قربانی سوختنی به حضور خداوند بگذرانید. ");
INSERT INTO pesOPV_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","وهدیه آردی آن دو عشر آرد نرم سرشته شده به روغن خواهد بود، تا هدیه آتشین و عطر خوشبوبرای خداوند باشد، و هدیه ریختنی آن چهار یک هین شراب خواهد بود. ");
INSERT INTO pesOPV_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","و نان و خوشه های برشته شده و خوشه های تازه مخورید، تا همان روزی که قربانی خدای خود را بگذرانید. این برای پشتهای شما در همه مسکنهای شمافریضه‌ای ابدی خواهد بود. ");
INSERT INTO pesOPV_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","و از فردای آن سبت، از روزی که بافه جنبانیدنی را آورده باشید، برای خود بشمارید تا هفت هفته تمام بشود. ");
INSERT INTO pesOPV_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","تا فردای بعد از سبت هفتم، پنجاه روز بشمارید، و هدیه آردی تازه برای خداوند بگذرانید. ");
INSERT INTO pesOPV_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","از مسکنهای خود دونان جنبانیدنی از دو عشر بیاورید از آرد نرم باشد، و با خمیر مایه پخته شود تا نوبر برای خداوندباشد. ");
INSERT INTO pesOPV_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","و همراه نان، هفت بره یک ساله بی‌عیب و یک گوساله و دو قوچ، و آنها با هدیه آردی وهدیه ریختنی آنها قربانی سوختنی برای خداوندخواهدبود، و هدیه آتشین و عطر خوشبو برای خداوند. ");
INSERT INTO pesOPV_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","و یک بز نر برای قربانی گناه، و دو بره نر یک ساله برای ذبیحه سلامتی بگذرانید. ");
INSERT INTO pesOPV_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","وکاهن آنها را با نان نوبر بجهت هدیه جنبانیدنی به حضور خداوند با آن دو بره بجنباند، تا برای خداوند بجهت کاهن مقدس باشد. ");
INSERT INTO pesOPV_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","و در همان روز منادی کنید که برای شما محفل مقدس باشد؛ و هیچ کار از شغل مکنید. در همه مسکنهای شما بر پشتهای شما فریضه ابدی باشد. ");
INSERT INTO pesOPV_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","و چون محصول زمین خود را دروکنید، گوشه های مزرعه خود را تمام درو مکن، و حصاد خود را خوشه چینی منما، آنها را برای فقیر و غریب بگذار. من یهوه خدای شماهستم.» ");
INSERT INTO pesOPV_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","و خداوند موسی را خطاب کرده، گفت: ");
INSERT INTO pesOPV_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","«بنی‌اسرائیل را خطاب کرده، بگو: در ماه هفتم در روز اول ماه، آرامی سبت برای شما خواهدبود، یعنی یادگاری نواختن کرناها و محفل مقدس. ");
INSERT INTO pesOPV_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","هیچ کار از شغل مکنید و هدیه آتشین برای خداوند بگذرانید.» ");
INSERT INTO pesOPV_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","و خداوند موسی را خطاب کرده، گفت: ");
INSERT INTO pesOPV_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","«در دهم این ماه هفتم، روز کفاره است. این برای شما محفل مقدس باشد. جانهای خود راذلیل سازید، و هدیه آتشین برای خداوندبگذرانید. ");
INSERT INTO pesOPV_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","و در همان روز هیچ کار مکنید، زیراکه روز کفاره است تا برای شما به حضوریهوه خدای شما کفاره بشود. ");
INSERT INTO pesOPV_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","و هر کسی‌که درهمان روز خود را ذلیل نسازد، از قوم خود منقطع خواهد شد. ");
INSERT INTO pesOPV_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","و هر کسی‌که در همان روزهرگونه کاری بکند، آن شخص را از میان قوم اومنقطع خواهم ساخت. ");
INSERT INTO pesOPV_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","هیچ کار مکنید. برای پشتهای شما در همه مسکنهای شما فریضه‌ای ابدی است. ");
INSERT INTO pesOPV_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","این برای شما سبت آرامی خواهدبود، پس جانهای خود را ذلیل سازید، درشام روز نهم، از شام تا شام، سبت خود را نگاه دارید.» ");
INSERT INTO pesOPV_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","و خداوند موسی را خطاب کرده، گفت: ");
INSERT INTO pesOPV_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","«بنی‌اسرائیل را خطاب کرده، بگو: در روزپانزدهم این ماه هفتم، عید خیمه‌ها، هفت روزبرای خداوند خواهد بود. ");
INSERT INTO pesOPV_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","در روز اول، محفل مقدس باشد؛ هیچ کار از شغل مکنید. ");
INSERT INTO pesOPV_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","هفت روز هدیه آتشین برای خداوند بگذرانید، و درروز هشتم جشن مقدس برای شما باشد، و هدیه آتشین برای خداوند بگذرانید. این تکمیل عیداست؛ هیچ کار از شغل مکنید. ");
INSERT INTO pesOPV_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","این موسمهای خداوند است که در آنها محفلهای مقدس رااعلان بکنید تا هدیه آتشین برای خداوند بگذرانید، یعنی قربانی سوختنی و هدیه آردی وذبیحه و هدایای ریختنی. مال هر روز را درروزش، ");
INSERT INTO pesOPV_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","سوای سبت های خداوند و سوای عطایای خود و سوای جمیع نذرهای خود وسوای همه نوافل خود که برای خداوند می‌دهید. ");
INSERT INTO pesOPV_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","در روز پانزدهم ماه هفتم چون شما محصول زمین را جمع کرده باشید، عید خداوند را هفت روز نگاه دارید، در روز اول، آرامی سبت خواهدبود، و در روز هشتم آرامی سبت. ");
INSERT INTO pesOPV_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","و در روزاول میوه درختان نیکو برای خود بگیرید، وشاخه های خرما و شاخه های درختان پربرگ، وبیدهای نهر، و به حضور یهوه خدای خود هفت روز شادی نمایید. ");
INSERT INTO pesOPV_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","و آن را هر سال هفت روزبرای خداوند عید نگاه دارید، برای پشتهای شمافریضه‌ای ابدی است که در ماه هفتم آن را عیدنگاه دارید. ");
INSERT INTO pesOPV_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","هفت روز در خیمه‌ها ساکن باشید؛ همه متوطنان در اسرائیل در خیمه‌ها ساکن شوند. ");
INSERT INTO pesOPV_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","تا طبقات شما بدانند که من بنی‌اسرائیل راوقتی که ایشان را از زمین مصر بیرون آوردم درخیمه‌ها ساکن گردانیدم. من یهوه خدای شماهستم.» ");
INSERT INTO pesOPV_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","پس موسی بنی‌اسرائیل را ازموسمهای خداوند خبر داد. ");
INSERT INTO pesOPV_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","و خداوند موسی را خطاب کرده، گفت ");
INSERT INTO pesOPV_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","که «بنی‌اسرائیل را امر بفرما تا روغن زیتون صاف کوبیده شده برای روشنایی بگیرند، تا چراغ را دائم روشن کنند. ");
INSERT INTO pesOPV_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","هارون آن را بیرون حجاب شهادت در خیمه اجتماع از شام تا صبح به حضور خداوند پیوسته بیاراید. در پشتهای شما فریضه ابدی است. ");
INSERT INTO pesOPV_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","چراغها را بر چراغدان طاهر، به حضور خداوند پیوسته بیاراید. ");
INSERT INTO pesOPV_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","و آردنرم بگیر و از آن دوازده گرده بپز؛ برای هر گرده دوعشر باشد. ");
INSERT INTO pesOPV_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","و آنها را به دو صف، در هر صف شش، بر میز طاهر به حضور خداوند بگذار. ");
INSERT INTO pesOPV_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","و برهر صف بخور صاف بنه، تا بجهت یادگاری برای نان و هدیه آتشین باشد برای خداوند. ");
INSERT INTO pesOPV_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","در هرروز سبت آن را همیشه به حضور خداوند بیاراید. از جانب بنی‌اسرائیل عهد ابدی خواهد بود. ");
INSERT INTO pesOPV_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","واز آن هارون و پسرانش خواهد بود تا آن را درمکان مقدس بخورند، زیرا این از هدایای آتشین خداوند به فریضه ابدی برای وی قدس اقداس خواهد بود.» ");
INSERT INTO pesOPV_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","و پسر زن اسرائیلی که پدرش مرد مصری بود در میان بنی‌اسرائیل بیرون آمد، و پسر زن اسرائیلی با مرد اسرائیلی در لشکرگاه جنگ کردند. ");
INSERT INTO pesOPV_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","و پسر زن اسرائیلی اسم را کفر گفت ولعنت کرد. پس او را نزد موسی آوردند و نام مادراو شلومیت دختر دبری از سبط دان بود. ");
INSERT INTO pesOPV_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","و او رادر زندان انداختند تا از دهن خداوند اطلاع یابند. ");
INSERT INTO pesOPV_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","و خداوند موسی را خطاب کرده، گفت: ");
INSERT INTO pesOPV_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","«آن کس را که لعنت کرده است، بیرون لشکرگاه ببر، و همه آنانی که شنیدند دستهای خود را بر سر وی بنهند، و تمامی جماعت او راسنگسار کنند. ");
INSERT INTO pesOPV_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","و بنی‌اسرائیل را خطاب کرده، بگو: هر کسی‌که خدای خود را لعنت کندمتحمل گناه خود خواهد بود. ");
INSERT INTO pesOPV_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","و هر‌که اسم یهوه را کفر گوید هرآینه کشته شود، تمامی جماعت او را البته سنگسار کنند، خواه غریب خواه متوطن. چونکه اسم را کفر گفته است کشته شود. ");
INSERT INTO pesOPV_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","و کسی‌که آدمی را بزند که بمیرد، البته کشته شود. ");
INSERT INTO pesOPV_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","و کسی‌که بهیمه‌ای را بزند که بمیرد عوض آن را بدهد، جان به عوض جان. ");
INSERT INTO pesOPV_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","وکسی‌که همسایه خود را عیب رسانیده باشدچنانکه او کرده باشد، به او کرده خواهد شد. ");
INSERT INTO pesOPV_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","شکستگی عوض شکستگی، چشم عوض چشم، دندان عوض دندان، چنانکه به آن شخص عیب رسانیده، همچنان به او رسانیده شود. ");
INSERT INTO pesOPV_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","وکسی‌که بهیمه‌ای را کشت، عوض آن را بدهد، اماکسی‌که انسان را کشت، کشته شود. ");
INSERT INTO pesOPV_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","شما رایک حکم خواهد بود، خواه غریب خواه متوطن، زیرا که من یهوه خدای شما هستم.» ");
INSERT INTO pesOPV_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","و موسی بنی‌اسرائیل را خبر داد، و آن را که لعنت کرده بود، بیرون لشکرگاه بردند، و او را به سنگ سنگسار کردند. پس بنی‌اسرائیل چنان‌که خداوند به موسی‌امر فرموده بود به عمل آوردند. ");
INSERT INTO pesOPV_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","و خداوند موسی را در کوه سینا خطاب کرده، گفت: ");
INSERT INTO pesOPV_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","«بنی‌اسرائیل را خطاب کرده، به ایشان بگو: چون شما به زمینی که من به شما می‌دهم، داخل شوید، آنگاه زمین، سبت خداوند را نگاه بدارد. ");
INSERT INTO pesOPV_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","شش سال مزرعه خود رابکار، و شش سال تاکستان خود را پازش بکن، ومحصولش را جمع کن. ");
INSERT INTO pesOPV_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","و در سال هفتم سبت آرامی برای زمین باشد، یعنی سبت برای خداوند. مزرعه خود را مکار و تاکستان خود راپازش منما. ");
INSERT INTO pesOPV_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","آنچه از مزرعه تو خودرو باشد، درو مکن، و انگورهای مو پازش ناکرده خود رامچین، سال آرامی برای زمین باشد. ");
INSERT INTO pesOPV_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","و سبت زمین، خوراک بجهت شما خواهد بود، برای تو وغلامت و کنیزت و مزدورت و غریبی که نزد توماوا گزیند. ");
INSERT INTO pesOPV_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","و برای بهایمت و برای جانورانی که در زمین تو باشند، همه محصولش خوراک خواهد بود. ");
INSERT INTO pesOPV_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","«و برای خود هفت سبت سالها بشمار، یعنی هفت در هفت سال و مدت هفت سبت سالها برای تو چهل و نه سال خواهد بود. ");
INSERT INTO pesOPV_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","و در روز دهم ازماه هفتم در روز کفاره، کرنای بلندآواز را بگردان؛ در تمامی زمین خود کرنا را بگردان. ");
INSERT INTO pesOPV_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","سال پنجاهم را تقدیس نمایید، و در زمین برای جمیع ساکنانش آزادی را اعلان کنید. این برای شمایوبیل خواهد بود، و هر کس از شما به ملک خودبرگردد، و هر کس از شما به قبیله خود برگردد. ");
INSERT INTO pesOPV_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","این سال پنجاهم برای شما یوبیل خواهد بود. زراعت مکنید و حاصل خودروی آن را مچینید، و انگورهای مو پازش ناکرده آن را مچینید. ");
INSERT INTO pesOPV_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","چونکه یوبیل است، برای شما مقدس خواهدبود؛ محصول آن را در مزرعه بخورید. ");
INSERT INTO pesOPV_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","در این سال یوبیل هر کس از شما به ملک خود برگردد. ");
INSERT INTO pesOPV_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","و اگر چیزی به همسایه خود بفروشی یا چیزی از دست همسایه ات بخری یکدیگر را مغبون مسازید. ");
INSERT INTO pesOPV_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","برحسب شماره سالهای بعد ازیوبیل، از همسایه خود بخر و برحسب سالهای محصولش به تو بفروشد. ");
INSERT INTO pesOPV_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","برحسب زیادتی سالها قیمت آن را زیاده کن، و برحسب کمی سالها قیمتش را کم نما، زیرا که شماره حاصلها رابه تو خواهد فروخت. ");
INSERT INTO pesOPV_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","و یکدیگر را مغبون مسازید، و از خدای خود بترس. من یهوه خدای شما هستم. ");
INSERT INTO pesOPV_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","پس فرایض مرا بجا آورید واحکام مرا نگاه داشته، آنها را به عمل آورید، تا درزمین به امنیت ساکن شوید. ");
INSERT INTO pesOPV_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","و زمین بار خود راخواهد داد و به سیری خواهید خورد، و به امنیت در آن ساکن خواهید بود. ");
INSERT INTO pesOPV_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","و اگر گویید در سال هفتم چه بخوریم، زیرا اینک نمی کاریم و حاصل خود را جمع نمی کنیم، ");
INSERT INTO pesOPV_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","پس در سال ششم برکت خود را بر شما خواهم فرمود، و محصول سه سال خواهد داد. ");
INSERT INTO pesOPV_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","و در سال هشتم بکارید واز محصول کهنه تا سال نهم بخورید. تا حاصل آن برسد، کهنه را بخورید. ");
INSERT INTO pesOPV_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","و زمین به فروش ابدی نرود زیرا زمین از آن من است، و شما نزد من غریب و مهمان هستید. ");
INSERT INTO pesOPV_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","و در تمامی زمین ملک خود برای زمین فکاک بدهید. ");
INSERT INTO pesOPV_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","اگر برادر تو فقیرشده، بعضی از ملک خود را بفروشد، آنگاه ولی او که خویش نزدیک او باشد بیاید، و آنچه را که برادرت می‌فروشد، انفکاک نماید. ");
INSERT INTO pesOPV_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","و اگر کسی ولی ندارد و برخوردار شده، قدر فکاک آن را پیدانماید. ");
INSERT INTO pesOPV_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","آنگاه سالهای فروش آن را بشمارد وآنچه را که زیاده است به آنکس که فروخته بود، رد نماید، و او به ملک خود برگردد. ");
INSERT INTO pesOPV_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","و اگرنتواند برای خود پس بگیرد، آنگاه آنچه فروخته است به‌دست خریدار آن تا سال یوبیل بماند، ودر یوبیل رها خواهد شد، و او به ملک خودخواهد برگشت. ");
INSERT INTO pesOPV_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","«و اگر کسی خانه سکونتی در شهرحصاردار بفروشد، تا یک سال تمام بعد ازفروختن آن حق انفکاک آن را خواهد داشت، مدت انفکاک آن یک سال خواهد بود. ");
INSERT INTO pesOPV_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","و اگر در مدت یک سال تمام آن را انفکاک ننماید، پس آن خانه‌ای که در شهر حصاردار است، برای خریدارآن نسلا بعد نسل برقرار باشد، در یوبیل رهانشود. ");
INSERT INTO pesOPV_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","لیکن خانه های دهات که حصار گردخود ندارد، با مزرعه های آن زمین شمرده شود. برای آنها حق انفکاک هست و در یوبیل رهاخواهد شد. ");
INSERT INTO pesOPV_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","و اما شهرهای لاویان، خانه های شهرهای ملک ایشان، حق انفکاک آنها همیشه برای لاویان است. ");
INSERT INTO pesOPV_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","و اگر کسی از لاویان بخرد، پس آنچه فروخته شده است از خانه یا از شهرملک او در یوبیل رها خواهد شد، زیرا خانه های شهرهای لاویان در میان بنی‌اسرائیل، ملک ایشان است. ");
INSERT INTO pesOPV_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","و مزرعه های حوالی شهرهای ایشان فروخته نشود، زیرا که این برای ایشان ملک ابدی است. ");
INSERT INTO pesOPV_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","«و اگر برادرت فقیر شده، نزد تو تهی‌دست باشد، او را مثل غریب و مهمان دستگیری نما تا باتو زندگی نماید. ");
INSERT INTO pesOPV_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","از او ربا و سود مگیر و ازخدای خود بترس، تا برادرت با تو زندگی نماید. ");
INSERT INTO pesOPV_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","نقد خود را به او به ربا مده و خوراک خود را به او به سود مده. ");
INSERT INTO pesOPV_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","من یهوه خدای شما هستم که شما را از زمین مصر بیرون آوردم تا زمین کنعان رابه شما دهم و خدای شما باشم. ");
INSERT INTO pesOPV_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","و اگر برادرت نزد تو فقیر شده، خود را به تو بفروشد، بر او مثل غلام خدمت مگذار. ");
INSERT INTO pesOPV_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","مثل مزدور و مهمان نزدتو باشد و تا سال یوبیل نزد تو خدمت نماید. ");
INSERT INTO pesOPV_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","آنگاه از نزد تو بیرون رود، خود او و پسرانش همراه وی، و به خاندان خود برگردد و به ملک پدران خود رجعت نماید. ");
INSERT INTO pesOPV_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","زیرا که ایشان بندگان منند که ایشان را از زمین مصر بیرون آوردم؛ مثل غلامان فروخته نشوند. ");
INSERT INTO pesOPV_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","بر او به سختی حکم رانی منما و از خدای خود بترس. ");
INSERT INTO pesOPV_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","و اما غلامانت و کنیزانت که برای توخواهندبود، از امتهایی که به اطراف تو می‌باشنداز ایشان غلامان و کنیزان بخرید. ");
INSERT INTO pesOPV_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","و هم ازپسران مهمانانی که نزد شما ماوا گزینند، و ازقبیله های ایشان که نزد شما باشند، که ایشان را درزمین شما تولید نمودند، بخرید و مملوک شماخواهندبود. ");
INSERT INTO pesOPV_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","و ایشان را بعد از خود برای پسران خود واگذارید، تا ملک موروثی باشند وایشان را تا به ابد مملوک سازید. و اما برادران شمااز بنی‌اسرائیل هیچکس بر برادر خود به سختی حکمرانی نکند. ");
INSERT INTO pesOPV_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","«و اگر غریب یا مهمانی نزد شما برخوردارگردد، و برادرت نزد او فقیر شده، به آن غریب یامهمان تو یا به نسل خاندان آن غریب، خود رابفروشد، ");
INSERT INTO pesOPV_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","بعد از فروخته شدنش برای وی حق انفکاک می‌باشد. یکی از برادرانش او را انفکاک نماید. ");
INSERT INTO pesOPV_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","یا عمویش یا پسر عمویش او را انفکاک نماید، یا یکی از خویشان او از خاندانش او راانفکاک نماید، یا خود او اگر برخوردار گردد، خویشتن را انفکاک نماید. ");
INSERT INTO pesOPV_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","و با آن کسی‌که او راخرید از سالی که خود را فروخت تا سال یوبیل حساب کند، و نقد فروش او برحسب شماره سالها باشد، موافق روزهای مزدور نزد او باشد. ");
INSERT INTO pesOPV_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","اگر سالهای بسیار باقی باشد، برحسب آنها نقدانفکاک خود را از نقد فروش خود، پس بدهد. ");
INSERT INTO pesOPV_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","و اگر تا سال یوبیل، سالهای کم باقی باشد باوی حساب بکند، و برحسب سالهایش نقدانفکاک خود را رد نماید. ");
INSERT INTO pesOPV_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","مثل مزدوری که سال به سال اجیر باشد نزد او بماند، و در نظر تو به سختی بر وی حکمرانی نکند. ");
INSERT INTO pesOPV_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","و اگر به اینهاانفکاک نشود پس در سال یوبیل رهاشود، هم خود او و پسرانش همراه وی. ");
INSERT INTO pesOPV_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","زیرا برای من بنی‌اسرائیل غلام‌اند، ایشان غلام من می‌باشند که ایشان را از زمین مصر بیرون آوردم. من یهوه خدای شما هستم. ");
INSERT INTO pesOPV_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","«برای خود بتها مسازید، و تمثال تراشیده و ستونی به جهت خود برپامنمایید، و سنگی مصور در زمین خود مگذاریدتا به آن سجده کنید، زیرا که من یهوه خدای شماهستم. ");
INSERT INTO pesOPV_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","سبت های مرا نگاه دارید، و مکان مقدس مرا احترام نمایید. من یهوه هستم. ");
INSERT INTO pesOPV_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","اگر درفرایض من سلوک نمایید و اوامر مرا نگاه داشته، آنها را بجا آورید، ");
INSERT INTO pesOPV_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","آنگاه بارانهای شما را درموسم آنها خواهم داد، و زمین محصول خود راخواهد آورد، و درختان صحرا میوه خود راخواهد داد. ");
INSERT INTO pesOPV_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","و کوفتن خرمن شما تا چیدن انگورخواهد رسید، و چیدن انگور تا کاشتن تخم خواهد رسید، و نان خود را به سیری خورده، درزمین خود به امنیت سکونت خواهید کرد. ");
INSERT INTO pesOPV_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","و به زمین، سلامتی خواهم داد و خواهید خوابید وترساننده‌ای نخواهد بود، و حیوانات موذی را اززمین نابود خواهم ساخت، و شمشیر از زمین شماگذر نخواهد کرد. ");
INSERT INTO pesOPV_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","و دشمنان خود را تعاقب خواهید کرد، و ایشان پیش روی شما از شمشیرخواهند افتاد. ");
INSERT INTO pesOPV_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","و پنج نفر از شما صد را تعاقب خواهند کرد، و صد از شما ده هزار را خواهندراند، و دشمنان شما پیش روی شما از شمشیرخواهند افتاد. ");
INSERT INTO pesOPV_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","و بر شما التفات خواهم کرد، وشما را بارور گردانیده، شما را کثیر خواهم ساخت، و عهد خود را با شما استوار خواهم نمود. ");
INSERT INTO pesOPV_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","و غله کهنه پارینه را خواهید خورد، وکهنه را برای نو بیرون خواهید آورد. ");
INSERT INTO pesOPV_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","و مسکن خود را در میان شما برپا خواهم کرد و جانم شمارا مکروه نخواهد داشت. ");
INSERT INTO pesOPV_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","و در میان شماخواهم خرامید و خدای شما خواهم بود و شماقوم من خواهید بود. ");
INSERT INTO pesOPV_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","من یهوه خدای شماهستم که شما را از زمین مصر بیرون آوردم تاایشان را غلام نباشید، و بندهای یوغ شما راشکستم، و شما را راست روان ساختم. ");
INSERT INTO pesOPV_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","«و اگر مرا نشنوید و جمیع این اوامر را بجانیاورید، ");
INSERT INTO pesOPV_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","و اگر فرایض مرا رد نمایید و دل شمااحکام مرا مکروه دارد، تا تمامی اوامر مرا بجانیاورده، عهد مرا بشکنید، ");
INSERT INTO pesOPV_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","من این را به شماخواهم کرد که خوف و سل و تب را که چشمان رافنا سازد، و جان را تلف کند، بر شما مسلط خواهم ساخت، و تخم خود را بی‌فایده خواهید کاشت ودشمنان شما آن را خواهند خورد. ");
INSERT INTO pesOPV_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","و روی خود را به ضد شما خواهم داشت، و پیش روی دشمنان خود منهزم خواهید شد، و آنانی که ازشما نفرت دارند، بر شما حکمرانی خواهند کرد، و بدون تعاقب کننده‌ای فرار خواهید نمود. ");
INSERT INTO pesOPV_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","واگر با وجود این همه، مرا نشنوید، آنگاه شما را برای گناهان شما هفت مرتبه زیاده سیاست خواهم کرد. ");
INSERT INTO pesOPV_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","و فخر قوت شما را خواهم شکست، و آسمان شما را مثل آهن و زمین شما رامثل مس خواهم ساخت. ");
INSERT INTO pesOPV_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","و قوت شما دربطالت صرف خواهد شد، زیرا زمین شما حاصل خود را نخواهد داد، و درختان زمین میوه خود رانخواهد آورد. ");
INSERT INTO pesOPV_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","و اگر به خلاف من رفتار نموده، از شنیدن من ابا نمایید، آنگاه برحسب گناهانتان هفت چندان بلایای زیاده بر شما عارض گردانم. ");
INSERT INTO pesOPV_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","و وحوش صحرا را بر شما فرستم تا شما رابی اولاد سازند، و بهایم شما را هلاک کنند، و شمارا در شماره کم سازند، و شاهراههای شما ویران خواهد شد. ");
INSERT INTO pesOPV_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","و اگر با این همه از من متنبه نشده، به خلاف من رفتار کنید، ");
INSERT INTO pesOPV_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","آنگاه من نیز به خلاف شما رفتار خواهم کرد، و شما را برای گناهانتان هفت چندان سزا خواهم داد. ");
INSERT INTO pesOPV_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","و بر شماشمشیری خواهم آورد که انتقام عهد مرا بگیرد. وچون به شهرهای خود جمع شوید، وبا در میان شما خواهم فرستاد، و به‌دست دشمن تسلیم خواهید شد. ");
INSERT INTO pesOPV_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","و چون عصای نان شما را بشکنم، ده زن نان شما را در یک تنور خواهند پخت، و نان شما را به شما به وزن پس خواهند داد، و چون بخورید سیر نخواهید شد. ");
INSERT INTO pesOPV_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","و اگر با وجود این، مرا نشنوید و به خلاف من رفتار نمایید، ");
INSERT INTO pesOPV_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","آنگاه به غضب به خلاف شما رفتار خواهم کرد، و من نیز برای گناهانتان، شما را هفت چندان سیاست خواهم کرد. ");
INSERT INTO pesOPV_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","و گوشت پسران خود را خواهیدخورد، و گوشت دختران خود را خواهید خورد. ");
INSERT INTO pesOPV_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","و مکانهای بلند شما را خراب خواهم ساخت، و اصنام شما را قطع خواهم کرد، و لاشه های شمارا بر لاشه های بتهای شما خواهم افکند، و جان من شما را مکروه خواهد داشت. ");
INSERT INTO pesOPV_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","و شهرهای شما را خراب خواهم ساخت، و مکانهای مقدس شما را ویران خواهم کرد، و بوی عطرهای خوشبوی شما را نخواهم بویید. ");
INSERT INTO pesOPV_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","و من زمین راویران خواهم ساخت، به حدی که دشمنان شماکه در آن ساکن باشند، متحیر خواهند شد. ");
INSERT INTO pesOPV_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","وشما را در میان امتها پراکنده خواهم ساخت، وشمشیر را در عقب شما خواهم کشید، و زمین شما ویران و شهرهای شما خراب خواهد شد. ");
INSERT INTO pesOPV_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","آنگاه زمین در تمامی روزهای ویرانی‌اش، حینی که شما در زمین دشمنان خود باشید، ازسبت های خود تمتع خواهد برد. پس زمین آرامی خواهد یافت و از سبت های خود تمتع خواهدبرد. ");
INSERT INTO pesOPV_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","تمامی روزهای ویرانی‌اش آرامی خواهدیافت، یعنی آن آرامی که در سبت های شماحینی که در آن ساکن می‌بودید، نیافته بود. ");
INSERT INTO pesOPV_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","«و اما در دلهای بقیه شما در زمین دشمنان شما ضعف خواهم فرستاد، و آواز برگ رانده شده، ایشان را خواهد گریزانید، و بدون تعاقب کننده‌ای مثل کسی‌که از شمشیر فرار کند، خواهند گریخت و خواهند افتاد. ");
INSERT INTO pesOPV_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","و به روی یکدیگر مثل از دم شمشیر خواهند ریخت، باآنکه کسی تعاقب نکند، و شما را یارای مقاومت با دشمنان خود نخواهد بود. ");
INSERT INTO pesOPV_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","و در میان امتهاهلاک خواهید شد و زمین دشمنان شما، شما راخواهد خورد. ");
INSERT INTO pesOPV_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","و بقیه شما در زمین دشمنان خود در گناهان خود فانی خواهند شد، و درگناهان پدران خود نیز فانی خواهند شد. ");
INSERT INTO pesOPV_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","پس به گناهان خود و به گناهان پدران خود در خیانتی که به من ورزیده، و سلوکی که به خلاف من نموده‌اند، اعتراف خواهند کرد. ");
INSERT INTO pesOPV_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","از این سبب من نیز به خلاف ایشان رفتار نمودم، و ایشان را به زمین دشمنان ایشان آوردم. پس اگر دل نامختون ایشان متواضع شود و سزای گناهان خود رابپذیرند، ");
INSERT INTO pesOPV_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","آنگاه عهد خود را با یعقوب بیادخواهم آورد، و عهد خود را با اسحاق نیز و عهدخود را با ابراهیم نیز بیاد خواهم آورد، و آن زمین را بیاد خواهم آورد. ");
INSERT INTO pesOPV_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","و زمین از ایشان ترک خواهد شد و چون از ایشان ویران باشد ازسبت های خود تمتع خواهد برد، و ایشان سزای گناه خود را خواهند پذیرفت، به‌سبب اینکه احکام مرا رد کردند، و دل ایشان فرایض مرامکروه داشت. ");
INSERT INTO pesOPV_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","و با وجود این همه نیز چون درزمین دشمنان خود باشند، من ایشان را رد نخواهم کرد، و ایشان را مکروه نخواهم داشت تا ایشان راهلاک کنم، و عهد خود را با ایشان بشکنم، زیرا که من یهوه خدای ایشان هستم. ");
INSERT INTO pesOPV_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","بلکه برای ایشان عهد اجداد ایشان را بیاد خواهم آورد که ایشان رادر نظر امتها از زمین مصر بیرون آوردم، تا خدای ایشان باشم. من یهوه هستم.» ");
INSERT INTO pesOPV_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","این است فرایض و احکام و شرایعی که خداوند در میان خود وبنی‌اسرائیل در کوه سینا به‌دست موسی قرار داد. ");
INSERT INTO pesOPV_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","و خداوند موسی را خطاب کرده، گفت: ");
INSERT INTO pesOPV_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","«بنی‌اسرائیل را خطاب کرده، به ایشان بگو: چون کسی نذر مخصوصی نماید، نفوس برحسب برآورد تو، از آن خداوند باشند. ");
INSERT INTO pesOPV_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","و اگر برآورد تو بجهت ذکور، از بیست ساله تاشصت ساله باشد، برآورد تو پنجاه مثقال نقره برحسب مثقال قدس خواهد بود. ");
INSERT INTO pesOPV_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","و اگر اناث باشد برآورد تو سی مثقال خواهد بود. ");
INSERT INTO pesOPV_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","و اگر ازپنج ساله تا بیست ساله باشد، برآورد تو بجهت ذکور، بیست مثقال و بجهت اناث ده مثقال خواهدبود. ");
INSERT INTO pesOPV_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","و اگر از یک ماهه تا پنج ساله باشد، برآوردتو بجهت ذکور پنج مثقال نقره، و بجهت اناث، برآورد تو سه مثقال نقره خواهد بود. ");
INSERT INTO pesOPV_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","و اگر ازشصت ساله و بالاتر باشد، اگر ذکور باشد، آنگاه برآورد تو پانزده مثقال، و برای اناث ده مثقال خواهد بود. ");
INSERT INTO pesOPV_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","و اگر از برآورد تو فقیرتر باشد، پس او را به حضور کاهن حاضر کنند، و کاهن برایش برآورد کند و کاهن به مقدار قوه آن که نذر کرده، برای وی برآورد نماید. ");
INSERT INTO pesOPV_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","و اگر بهیمه‌ای باشد ازآنهایی که برای خداوند قربانی می‌گذرانند، هرآنچه را که کسی از آنها به خداوند بدهد، مقدس خواهد بود. ");
INSERT INTO pesOPV_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","آن را مبادله ننماید و خوب را به بد یا بد را به خوب عوض نکند. و اگر بهیمه‌ای رابه بهیمه‌ای مبادله کند، هم آن و آنچه به عوض آن داده شود، هر دو مقدس خواهد بود. ");
INSERT INTO pesOPV_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","و اگر هرقسم بهیمه نجس باشد که از آن قربانی برای خداوند نمی گذرانند، آن بهیمه را پیش کاهن حاضر کند. ");
INSERT INTO pesOPV_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","و کاهن آن را چه خوب و چه بد، قیمت کند و برحسب برآورد تو‌ای کاهن، چنین باشد. ");
INSERT INTO pesOPV_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","و اگر آن را فدیه دهد، پنج یک بر برآوردتو زیاده دهد. ");
INSERT INTO pesOPV_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","و اگر کسی خانه خود را وقف نماید تا برای خداوند مقدس شود، کاهن آن راچه خوب و چه بد برآورد کند، و بطوری که کاهن آن را برآورد کرده باشد، همچنان بماند. ");
INSERT INTO pesOPV_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","و اگروقف کننده بخواهد خانه خود را فدیه دهد، پس پنج یک بر نقد برآورد تو زیاده کند و از آن اوخواهد بود. ");
INSERT INTO pesOPV_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","و اگر کسی قطعه‌ای از زمین ملک خود را برای خداوند وقف نماید، آنگاه برآوردتو موافق زراعت آن باشد، زراعت یک حومر جو به پنجاه مثقال نقره باشد. ");
INSERT INTO pesOPV_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","و اگر زمین خود را ازسال یوبیل وقف نماید، موافق برآورد تو برقرارباشد. ");
INSERT INTO pesOPV_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","و اگر زمین خود را بعد از یوبیل وقف نماید، آنگاه کاهن نقد آن را موافق سالهایی که تاسال یوبیل باقی می‌باشد برای وی بشمارد، و ازبرآورد تو تخفیف شود. ");
INSERT INTO pesOPV_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","و اگر آنکه زمین راوقف کرد بخواهد آن را فدیه دهد، پس پنج یک از نقد برآورد تو را بر آن بیفزاید و برای وی برقرارشود. ");
INSERT INTO pesOPV_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","و اگر نخواهد زمین را فدیه دهد، یا اگرزمین را به دیگری فروخته باشد، بعد از آن فدیه داده نخواهد شد. ");
INSERT INTO pesOPV_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","و آن زمین چون در یوبیل رها شود مثل زمین وقف برای خداوند، مقدس خواهد بود؛ ملکیت آن برای کاهن است. ");
INSERT INTO pesOPV_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","و اگرزمینی را که خریده باشد که از زمین ملک او نبود، برای خداوند وقف نماید، ");
INSERT INTO pesOPV_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","آنگاه کاهن مبلغ برآورد تو را تا سال یوبیل برای وی بشمارد، و درآن روز برآورد تو را مثل وقف خداوند به وی بدهد. ");
INSERT INTO pesOPV_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","و آن زمین در سال یوبیل به کسی‌که از اوخریده شده بود خواهد برگشت، یعنی به کسی‌که آن زمین ملک موروثی وی بود. ");
INSERT INTO pesOPV_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","و هر برآورد توموافق مثقال قدس باشد که بیست جیره یک مثقال است. ");
INSERT INTO pesOPV_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","«لیکن نخست زاده‌ای از بهایم که برای خداوند نخست زاده شده باشد، هیچکس آن راوقف ننماید، خواه گاو خواه گوسفند، از آن خداوند است. ");
INSERT INTO pesOPV_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","و اگر از بهایم نجس باشد، آنگاه آن را برحسب برآورد تو فدیه دهد، و پنج یک برآن بیفزاید، و اگر فدیه داده نشود پس موافق برآورد تو فروخته شود. ");
INSERT INTO pesOPV_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","اما هر چیزی که کسی برای خداوند وقف نماید، از کل مایملک خود، چه از انسان چه از بهایم چه از زمین ملک خود، نه فروخته شود و نه فدیه داده شود، زیرا هر‌چه وقف باشد برای خداوند قدس اقداس است. ");
INSERT INTO pesOPV_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","هر وقفی که از انسان وقف شده باشد، فدیه داده نشود. البته کشته شود. ");
INSERT INTO pesOPV_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","و تمامی ده‌یک زمین چه از تخم زمین چه از میوه درخت از آن خداوند است، و برای خداوند مقدس می‌باشد. ");
INSERT INTO pesOPV_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","و اگر کسی از ده‌یک خود چیزی فدیه دهدپنج یک آن را بر آن بیفزاید. ");
INSERT INTO pesOPV_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","و تمامی ده‌یک گاو و گوسفند یعنی هر‌چه زیر عصا بگذرد، دهم آن برای خداوند مقدس خواهد بود. ");
INSERT INTO pesOPV_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","در خوبی و بدی آن تفحص ننماید و آن را مبادله نکند، واگر آن را مبادله کند هم آن و هم بدل آن مقدس خواهد بود و فدیه داده نشود.» ");
INSERT INTO pesOPV_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","این است اوامری که خداوند به موسی برای بنی‌اسرائیل درکوه سینا امر فرمود. ");
INSERT INTO pesOPV_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","و در روز اول ماه دوم از سال دوم از بیرون آمدن ایشان از زمین مصر، خداوند دربیابان سینا در خیمه اجتماع موسی را خطاب کرده، گفت: ");
INSERT INTO pesOPV_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","«حساب تمامی جماعت بنی‌اسرائیل را برحسب قبایل و خاندان آبای ایشان، به شماره اسم های همه ذکوران موافق سرهای ایشان بگیرید. ");
INSERT INTO pesOPV_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","از بیست ساله و زیاده، هر‌که از اسرائیل به جنگ بیرون می‌رود، تو وهارون ایشان را برحسب افواج ایشان بشمارید. ");
INSERT INTO pesOPV_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","و همراه شما یک نفر از هر سبط باشد که هر یک رئیس خاندان آبایش باشد. ");
INSERT INTO pesOPV_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","و اسم های کسانی که با شما باید بایستند، این است: از روبین، الیصوربن شدیئور. ");
INSERT INTO pesOPV_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","و از شمعون، شلومیئیل بن صوریشدای. ");
INSERT INTO pesOPV_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","و از یهودا، نحشون بن عمیناداب. ");
INSERT INTO pesOPV_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","و از یساکار، نتنائیل بن صوغر. ");
INSERT INTO pesOPV_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","و از زبولون، الیاب بن حیلون. ");
INSERT INTO pesOPV_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","و از بنی یوسف: از افرایم، الیشمع بن عمیهود. و از منسی، جملیئیل بن فدهصور. ");
INSERT INTO pesOPV_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","از بنیامین، ابیدان بن جدعونی. ");
INSERT INTO pesOPV_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","و از دان، اخیعزر بن عمیشدای. ");
INSERT INTO pesOPV_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","و از اشیر، فجعیئیل بن عکران. ");
INSERT INTO pesOPV_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","و از جاد، الیاساف بن دعوئیل. ");
INSERT INTO pesOPV_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","و از نفتالی، اخیرع بن عینان.» ");
INSERT INTO pesOPV_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","اینانند دعوت‌شدگان جماعت و سروران اسباط آبای ایشان، و روسای هزاره های اسرائیل. ");
INSERT INTO pesOPV_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","و موسی و هارون این کسان را که به نام، معین شدند، گرفتند. ");
INSERT INTO pesOPV_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","و در روز اول ماه دوم، تمامی جماعت را جمع کرده، نسب نامه های ایشان را برحسب قبایل و خاندان آبای ایشان، به شماره اسم‌ها از بیست ساله و بالاتر موافق سرهای ایشان خواندند. ");
INSERT INTO pesOPV_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","چنانکه خداوندموسی را امر فرموده بود، ایشان را در بیابان سینابشمرد. ");
INSERT INTO pesOPV_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","و اما انساب بنی روبین نخست زاده اسرائیل، برحسب قبایل و خاندان آبای ایشان، موافق نامها و سرهای ایشان این بود: هر ذکور ازبیست ساله و بالاتر، جمیع کسانی که برای جنگ بیرون می‌رفتند. ");
INSERT INTO pesOPV_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","شمرده شدگان ایشان از سبطروبین، چهل و شش هزار و پانصد نفر بودند. ");
INSERT INTO pesOPV_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","و انساب بنی شمعون برحسب قبایل وخاندان آبای ایشان، کسانی که از ایشان شمرده شدند، موافق شماره اسم‌ها و سرهای ایشان این بود: هر ذکور از بیست ساله و بالاتر، هر‌که برای جنگ بیرون می‌رفت. ");
INSERT INTO pesOPV_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","شمرده شدگان ایشان ازسبط شمعون، پنجاه و نه هزار و سیصد نفر بودند. ");
INSERT INTO pesOPV_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","و انساب بنی جاد برحسب قبایل و خاندان آبای ایشان، موافق شماره اسم‌ها، از بیست ساله وبالاتر، هر‌که برای جنگ بیرون می‌رفت. ");
INSERT INTO pesOPV_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","شمرده شدگان ایشان از سبط جاد، چهل و پنج هزار و ششصد و پنجاه نفر بودند. ");
INSERT INTO pesOPV_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","و انساب بنی یهودا برحسب قبایل وخاندان آبای ایشان، موافق شماره اسم‌ها ازبیست ساله و بالاتر، هر‌که برای جنگ بیرون می‌رفت. ");
INSERT INTO pesOPV_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","شمرده شدگان ایشان از سبط یهودا، هفتاد و چهار هزار و شش صد نفر بودند. ");
INSERT INTO pesOPV_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","و انساب بنی یساکار برحسب قبایل وخاندان آبای ایشان، موافق شماره اسم‌ها ازبیست ساله و بالاتر، هر‌که برای جنگ بیرون می‌رفت. ");
INSERT INTO pesOPV_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","شمرده شدگان ایشان از سبط یساکار، پنجاه و چهار هزار و چهارصد نفر بودند. ");
INSERT INTO pesOPV_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","و انساب بنی زبولون برحسب قبایل وخاندان آبای ایشان، موافق شماره اسم‌ها ازبیست ساله و بالاتر، هر‌که برای جنگ بیرون می‌رفت. ");
INSERT INTO pesOPV_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","شمرده شدگان ایشان از سبط زبولون پنجاه و هفت هزار و چهارصد نفر بودند. ");
INSERT INTO pesOPV_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","و انساب بنی یوسف از بنی افرایم برحسب قبایل و خاندان آبای ایشان، موافق شماره اسم هااز بیست ساله و بالاتر، هر‌که برای جنگ بیرون می‌رفت. ");
INSERT INTO pesOPV_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","شمرده شدگان ایشان از سبط افرایم، چهل هزار و پانصد نفر بودند. ");
INSERT INTO pesOPV_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","و انساب بنی منسی برحسب قبایل وخاندان آبای ایشان، موافق شماره اسم‌ها، ازبیست ساله و بالاتر، هر‌که برای جنگ بیرون می‌رفت. ");
INSERT INTO pesOPV_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","شمرده شدگان ایشان از سبط منسی، سی و دو هزار و دویست نفر بودند. ");
INSERT INTO pesOPV_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","و انساب بنی بنیامین برحسب قبایل وخاندان آبای ایشان، موافق شماره اسم‌ها، ازبیست ساله بالاتر، هر‌که برای جنگ بیرون می‌رفت. ");
INSERT INTO pesOPV_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","شمرده شدگان ایشان از سبط بنیامین، سی و پنج هزار و چهارصد نفر بودند. ");
INSERT INTO pesOPV_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","و انساب بنی دان برحسب قبایل و خاندان آبای ایشان، موافق شماره اسم‌ها از بیست ساله وبالاتر، هر‌که برای جنگ می‌رفت. ");
INSERT INTO pesOPV_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","شمرده شدگان ایشان از سبط دان، شصت و دو هزار و هفتصد نفر بودند. ");
INSERT INTO pesOPV_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","و انساب بنی اشیر برحسب قبایل و خاندان آبای ایشان، موافق شماره اسم‌ها از بیست ساله وبالاتر، هر‌که برای جنگ بیرون می‌رفت. ");
INSERT INTO pesOPV_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","شمرده شدگان ایشان از سبط اشیر، چهل ویک هزار و پانصد نفر بودند. ");
INSERT INTO pesOPV_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","و انساب بنی نفتالی برحسب قبایل وخاندان آبای ایشان، موافق شماره اسم‌ها ازبیست ساله و بالاتر، هر‌که برای جنگ بیرون می‌رفت. ");
INSERT INTO pesOPV_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","شمرده شدگان ایشان از سبط نفتالی، پنجاه و سه هزار و پانصد نفر بودند. ");
INSERT INTO pesOPV_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","اینانند شمرده شدگانی که موسی و هارون با دوازده نفر از سروران اسرائیل، که یک نفر برای هر خاندان آبای ایشان بود، شمردند. ");
INSERT INTO pesOPV_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","و تمامی شمرده شدگان بنی‌اسرائیل برحسب خاندان آبای ایشان، از بیست ساله و بالاتر، هر کس از اسرائیل که برای جنگ بیرون می‌رفت. ");
INSERT INTO pesOPV_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","همه شمرده شدگان، ششصد و سه هزار و پانصد وپنجاه نفر بودند. ");
INSERT INTO pesOPV_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","اما لاویان برحسب سبط آبای ایشان در میان آنها شمرده نشدند. ");
INSERT INTO pesOPV_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","زیرا خداوند موسی را خطاب کرده، گفت: ");
INSERT INTO pesOPV_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","«اما سبط لاوی را مشمار و حساب ایشان را درمیان بنی‌اسرائیل مگیر. ");
INSERT INTO pesOPV_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","لیکن لاویان را برمسکن شهادت و تمامی اسبابش و بر هرچه علاقه به آن دارد بگمار، و ایشان مسکن و تمامی اسبابش را بردارند، و ایشان آن را خدمت نمایندو به اطراف مسکن خیمه زنند. ");
INSERT INTO pesOPV_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","و چون مسکن روانه شود لاویان آن را پایین بیاورند، و چون مسکن افراشته شود لاویان آن را برپا نمایند، وغریبی که نزدیک آن آید، کشته شود. ");
INSERT INTO pesOPV_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","و بنی‌اسرائیل هر کس در محله خود و هر کس نزدعلم خویش برحسب افواج خود، خیمه زنند. ");
INSERT INTO pesOPV_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","و لاویان به اطراف مسکن شهادت خیمه زنند، مبادا غضب بر جماعت بنی‌اسرائیل بشود، ولاویان شعائر مسکن شهادت را نگاه دارند.» ");
INSERT INTO pesOPV_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","پس بنی‌اسرائیل چنین کردند، و برحسب آنچه خداوند موسی را امر فرموده بود، به عمل آوردند. ");
INSERT INTO pesOPV_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","و خداوند موسی و هارون را خطاب کرده، گفت: ");
INSERT INTO pesOPV_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","«هر کس از بنی‌اسرائیل نزد علم ونشان خاندان آبای خویش خیمه زند، در برابر واطراف خیمه اجتماع خیمه زنند. ");
INSERT INTO pesOPV_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","و به‌جانب مشرق به سوی طلوع آفتاب اهل علم محله یهودابرحسب افواج خود خیمه زنند، و رئیس بنی یهودا نحشون بن عمیناداب باشد. ");
INSERT INTO pesOPV_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","و فوج اوکه از ایشان شمرده شدند هفتاد و چهار هزار وششصد نفر بودند. ");
INSERT INTO pesOPV_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","و سبط یساکار در پهلوی اوخیمه زنند، و رئیس بنی یساکار نتنائیل بن صوغرباشد. ");
INSERT INTO pesOPV_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","و فوج او که از ایشان شمرده شدند پنجاه و چهار هزار و چهارصد نفر بودند. ");
INSERT INTO pesOPV_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","و سبطزبولون و رئیس بنی زبولون الیاب بن حیلون باشد. ");
INSERT INTO pesOPV_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","و فوج او که از ایشان شمرده شدند، پنجاه وهفت هزار و چهارصد نفر بودند. ");
INSERT INTO pesOPV_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","جمیع شمرده شدگان محله یهودا برحسب افواج ایشان صد و هشتاد و شش هزار و چهارصد نفر بودند. وایشان اول کوچ کنند. ");
INSERT INTO pesOPV_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","و بر جانب جنوب، علم محله روبین برحسب افواج ایشان باشد، و رئیس بنی روبین الیصور بن شدیئور باشد. ");
INSERT INTO pesOPV_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","و فوج او که از ایشان شمرده شدند چهل و شش هزار و پانصد نفر بودند. ");
INSERT INTO pesOPV_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","و در پهلوی او سبط شمعون خیمه زنندو رئیس بنی شمعون شلومیئیل بن صوریشدای باشد. ");
INSERT INTO pesOPV_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","و فوج او که از ایشان شمرده شدند، پنجاه و نه هزار و سیصد نفر بودند. ");
INSERT INTO pesOPV_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","و سبط جادو رئیس بنی جاد الیاساف بن رعوئیل باشد. ");
INSERT INTO pesOPV_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","وفوج او که از ایشان شمرده شدند، چهل و پنج هزار و ششصد و پنجاه نفر بودند. ");
INSERT INTO pesOPV_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","جمیع شمرده شدگان محله روبین برحسب افواج ایشان صد و پنجاه و یک هزار و چهارصد و پنجاه نفربودند و ایشان دوم کوچ کنند. ");
INSERT INTO pesOPV_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","و بعد از آن خیمه اجتماع با محله لاویان درمیان محله‌ها کوچ کند، چنانکه خیمه می‌زنند، همچنان هر کس در جای خود نزد علمهای خویش کوچ کنند. ");
INSERT INTO pesOPV_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","و به طرف مغرب، علم محله افرایم برحسب افواج ایشان و رئیس بنی افرایم، الیشمع بن عمیهود باشد. ");
INSERT INTO pesOPV_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","و فوج او که از ایشان شمرده شدند، چهل هزار و پانصد نفر بودند. ");
INSERT INTO pesOPV_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","و درپهلوی او سبط منسی، و رئیس بنی منسی جملیئیل بن فدهصور باشد. ");
INSERT INTO pesOPV_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","و فوج او که ازایشان شمرده شدند، سی و دو هزار و دویست نفربودند. ");
INSERT INTO pesOPV_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","و سبط بنیامین و رئیس بنی بنیامین، ابیدان بن جدعونی باشد. ");
INSERT INTO pesOPV_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","و فوج او که از ایشان شمرده شدند، سی و پنج هزار و چهارصد نفربودند. ");
INSERT INTO pesOPV_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","جمیع شمرده شدگان محله افرایم برحسب افواج ایشان، صد و هشت هزار و یکصدنفر بودند، و ایشان سوم کوچ کنند. ");
INSERT INTO pesOPV_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","و به طرف شمال، علم محله دان، برحسب افواج ایشان، و رئیس بنی دان اخیعزر بن عمیشدای باشد. ");
INSERT INTO pesOPV_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","و فوج او که از ایشان شمرده شدند، شصت و دو هزاروهفت صد نفر بودند. ");
INSERT INTO pesOPV_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","ودر پهلوی ایشان سبط اشیر خیمه زنند، و رئیس بنی اشیر فجعیئیل بن عکران باشد. ");
INSERT INTO pesOPV_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","و فوج او که از ایشان شمرده شدند، چهل و یک هزار و پانصدنفر بودند. ");
INSERT INTO pesOPV_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","و سبط نفتالی و رئیس بنی نفتالی اخیرع بن عینان باشد. ");
INSERT INTO pesOPV_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","و فوج او که از ایشان شمرده شدند، پنجاه و سه هزار و چهارصد نفربودند. ");
INSERT INTO pesOPV_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","جمیع شمرده شدگان محله دان، صد وپنجاه و هفت هزار و ششصد نفر بودند. ایشان نزدعلمهای خود در عقب کوچ کنند. ");
INSERT INTO pesOPV_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","اینانند شمرده شدگان بنی‌اسرائیل برحسب خاندان آبای ایشان، جمیع شمرده شدگان محله‌ها موافق افواج ایشان شش صد و سه هزار وپانصد و پنجاه نفر بودند. ");
INSERT INTO pesOPV_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","اما لاویان چنانکه خداوند به موسی‌امر فرموده بود، در میان بنی‌اسرائیل شمرده نشدند. ");
INSERT INTO pesOPV_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","و بنی‌اسرائیل موافق هرچه خداوند به موسی‌امر فرموده بود، عمل نمودند، به اینطورنزد علمهای خود خیمه می‌زدند و به اینطور هرکس برحسب قبایل خود با خاندان آبای خودکوچ می‌کردند. ");
INSERT INTO pesOPV_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","این است انساب هارون و موسی در روزی که خداوند در کوه سینا با موسی متکلم شد. ");
INSERT INTO pesOPV_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","و نامهای پسران هارون این است: نخست زاده‌اش ناداب و ابیهو و العازار و ایتامار. ");
INSERT INTO pesOPV_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","این است نامهای پسران هارون کهنه که مسح شده بودند که ایشان را برای کهانت تخصیص نمود. ");
INSERT INTO pesOPV_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","اما ناداب و ابیهو در حضور خداوندمردند، هنگامی که ایشان در بیابان سینا آتش غریب به حضور خداوند گذرانیدند، و ایشان را پسری نبود و العازار و ایتامار به حضور پدر خودهارون، کهانت می‌نمودند. ");
INSERT INTO pesOPV_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","و خداوند موسی را خطاب کرده، گفت: ");
INSERT INTO pesOPV_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","«سبط لاوی را نزدیک آورده، ایشان را پیش هارون کاهن حاضر کن تا او را خدمت نمایند. ");
INSERT INTO pesOPV_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","وایشان شعائر او و شعائر تمامی جماعت را پیش خیمه اجتماع نگاه داشته، خدمت مسکن را بجاآورند. ");
INSERT INTO pesOPV_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","و جمیع اسباب خیمه اجتماع و شعائربنی‌اسرائیل را نگاه داشته، خدمت مسکن را بجاآورند. ");
INSERT INTO pesOPV_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","و لاویان را به هارون و پسرانش بده، زیراکه ایشان از جانب بنی‌اسرائیل بالکل به وی داده شده‌اند. ");
INSERT INTO pesOPV_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","و هارون و پسرانش را تعیین نما تاکهانت خود را بجا بیاورند، و غریبی که نزدیک آید، کشته شود.» ");
INSERT INTO pesOPV_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","و خداوند موسی را خطاب کرده، گفت: ");
INSERT INTO pesOPV_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","«که اینک من لاویان را از میان بنی‌اسرائیل، به عوض هر نخست زاده‌ای از بنی‌اسرائیل که رحم را بگشاید گرفته‌ام، پس لاویان از آن من می‌باشند. ");
INSERT INTO pesOPV_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","زیرا جمیع نخست زادگان از آن منند، و درروزی که همه نخست زادگان زمین مصر را کشتم، جمیع نخست زادگان اسرائیل را خواه از انسان وخواه از بهایم برای خود تقدیس نمودم، پس ازآن من می‌باشند. من یهوه هستم.» ");
INSERT INTO pesOPV_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","و خداوند موسی را در بیابان سینا خطاب کرده، گفت: ");
INSERT INTO pesOPV_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","«بنی لاوی را برحسب خاندان آباو قبایل ایشان بشمار، هر ذکور ایشان را از یک ماهه و زیاده بشمار.» ");
INSERT INTO pesOPV_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","پس موسی برحسب قول خداوند چنانکه مامور شد، ایشان را شمرد. ");
INSERT INTO pesOPV_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","وپسران لاوی موافق نامهای ایشان اینانند: جرشون و قهات و مراری. ");
INSERT INTO pesOPV_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","و نامهای بنی جرشون برحسب قبایل ایشان این است: لبنی و شمعی. ");
INSERT INTO pesOPV_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","و پسران قهات برحسب قبایل ایشان: عمرام ویصهار و حبرون و عزیئیل. ");
INSERT INTO pesOPV_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","و پسران مراری برحسب قبایل ایشان: محلی و موشی بودند. اینانند قبایل لاویان برحسب خاندان آبای ایشان. ");
INSERT INTO pesOPV_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","و از جرشون، قبیله لبنی و قبیله شمعی. اینانند قبایل جرشونیان. ");
INSERT INTO pesOPV_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","و شمرده شدگان ایشان به شماره همه ذکوران از یک ماهه و بالاتر، شمرده شدگان ایشان هفت هزار و پانصد نفربودند. ");
INSERT INTO pesOPV_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","و قبایل جرشونیان در عقب مسکن، به طرف مغرب خیمه زنند. ");
INSERT INTO pesOPV_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","و سرور خاندان آبای جرشونیان، الیاساف بن لایل باشد. ");
INSERT INTO pesOPV_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","و ودیعت بنی جرشون در خیمه اجتماع، مسکن و خیمه وپوشش آن و پرده دروازه خیمه اجتماع باشد. ");
INSERT INTO pesOPV_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","و تجیرهای صحن و پرده دروازه صحن که پیش روی مسکن و به اطراف مذبح است وطنابهایش با هر خدمت آنها. ");
INSERT INTO pesOPV_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","و از قهات، قبیله عمرامیان و قبیله یصهاریان و قبیله حبرونیان و قبیله عزیئیلیان، اینانند قبایل قهاتیان. ");
INSERT INTO pesOPV_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","به شماره همه ذکوران ازیک ماهه و بالاتر، هشت هزار و شش صد نفربودند که ودیعت قدس را نگاه می‌داشتند. ");
INSERT INTO pesOPV_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","وقبایل بنی قهات به طرف جنوب مسکن، خیمه بزنند. ");
INSERT INTO pesOPV_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","و سرور خاندان آبای قبایل قهاتیان، الیاصافان بن عزیئیل باشد. ");
INSERT INTO pesOPV_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","و ودیعت ایشان تابوت و میز و شمعدان و مذبح‌ها و اسباب قدس که با آنها خدمت می‌کنند، و حجاب و هر خدمت آن باشد. ");
INSERT INTO pesOPV_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","و سرور سروران لاویان، العازار بن هارون کاهن باشد، و نظارت نگهبانان خدمت قدس، او را خواهد بود. ");
INSERT INTO pesOPV_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","و از مراری، قبیله محلیان و قبیله موشیان؛ اینانند قبایل مراری. ");
INSERT INTO pesOPV_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","و شمرده شدگان ایشان وشماره همه ذکوران از یک ماهه و بالاتر، شش هزار و دویست نفر بودند. ");
INSERT INTO pesOPV_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","و سرور خاندان آبای قبایل مراری، صوریئیل بن ابیحایل باشد وایشان به طرف شمالی مسکن، خیمه بزنند. ");
INSERT INTO pesOPV_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","وودیعت معین بنی مراری، تختهای مسکن وپشت بندهایش و ستونهایش و پایه هایش وتمامی اسبابش با تمامی خدمتش باشد. ");
INSERT INTO pesOPV_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","وستونهای اطراف صحن و پایه های آنها و میخها وطنابهای آنها. ");
INSERT INTO pesOPV_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","و پیش مسکن به طرف مشرق و پیش روی خیمه اجتماع به طرف طلوع شمس، موسی وهارون و پسرانش خیمه بزنند و نگاهبانی قدس راو نگاهبانی بنی‌اسرائیل را بدارند. و هر غریبی که نزدیک آید، کشته شود. ");
INSERT INTO pesOPV_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","و جمع شمرده شدگان لاویان که موسی و هارون ایشان را برحسب قبایل ایشان و فرمان خداوند شمردند، همه ذکوران ازیک ماهه و بالاتر، بیست و دو هزار نفر بودند. ");
INSERT INTO pesOPV_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","و خداوند به موسی گفت: «جمیع نخست زادگان نرینه بنی‌اسرائیل را از یک ماهه وبالاتر بشمار، و حساب نامهای ایشان را بگیر. ");
INSERT INTO pesOPV_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","ولاویان را به عوض همه نخست زادگان بنی‌اسرائیل برای من که یهوه هستم بگیر، و بهایم لاویان را به عوض همه نخست زادگان بهایم بنی‌اسرائیل.» ");
INSERT INTO pesOPV_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","پس موسی چنانکه خداوند او را امرفرموده بود، همه نخست زادگان بنی‌اسرائیل راشمرد. ");
INSERT INTO pesOPV_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","و جمیع نخست زادگان نرینه، برحسب شماره اسم های شمرده شدگان ایشان از یک ماهه و بالاتر، بیست و دو هزار و دویست و هفتاد و سه نفر بودند. ");
INSERT INTO pesOPV_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","و خداوند موسی را خطاب کرده، گفت: ");
INSERT INTO pesOPV_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","«لاویان را به عوض جمیع نخست زادگان بنی‌اسرائیل، و بهایم لاویان را به عوض بهایم ایشان بگیر، و لاویان از آن من خواهند بود. من یهوه هستم. ");
INSERT INTO pesOPV_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","و اما درباره فدیه دویست و هفتادو سه نفر از نخست زادگان بنی‌اسرائیل که برلاویان زیاده‌اند، ");
INSERT INTO pesOPV_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","پنج مثقال برای هر سری بگیر، آن را موافق مثقال قدس که بیست جیره یک مثقال باشد، بگیر. ");
INSERT INTO pesOPV_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","و نقد فدیه آنانی که از ایشان زیاده‌اند به هارون و پسرانش بده.» ");
INSERT INTO pesOPV_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","پس موسی نقد فدیه را از آنانی که زیاده بودند، بر کسانی که لاویان فدیه آنها شده بودند، گرفت. ");
INSERT INTO pesOPV_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","و از نخست زادگان بنی‌اسرائیل نقد راکه هزار و سیصد و شصت و پنج مثقال موافق مثقال قدس باشد، گرفت. ");
INSERT INTO pesOPV_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","و موسی نقد فدیه رابرحسب قول خداوند چنانکه خداوند موسی راامر فرموده بود، به هارون و پسرانش داد. ");
INSERT INTO pesOPV_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","و خداوند موسی و هارون را خطاب کرده، گفت: ");
INSERT INTO pesOPV_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","«حساب بنی قهات را از میان بنی لاوی برحسب قبایل و خاندان آبای ایشان بگیر. ");
INSERT INTO pesOPV_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","از سی ساله و بالاتر تا پنجاه ساله، هر‌که داخل خدمت شود تا در خیمه اجتماع کار کند. ");
INSERT INTO pesOPV_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","«و خدمت بنی قهات در خیمه اجتماع، کارقدس‌الاقداس باشد. ");
INSERT INTO pesOPV_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","و هنگامی که اردو کوچ می‌کند هارون وپسرانش داخل شده، پوشش حجاب را پایین بیاورند، و تابوت شهادت را به آن بپوشانند. ");
INSERT INTO pesOPV_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","و برآن پوشش پوست خز آبی بگذارند و جامه‌ای که تمام آن لاجوردی باشد بالای آن پهن نموده، چوب دستهایش را بگذرانند. ");
INSERT INTO pesOPV_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","«و بر میز نان تقدمه، جامه لاجوردی بگسترانند و بر آن، بشقابها و قاشقها و کاسه‌ها وپیاله های ریختنی را بگذرانند و نان دائمی بر آن باشد. ");
INSERT INTO pesOPV_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","و جامه قرمز بر آنها گسترانیده، آن را به پوشش پوست خز بپوشانند و چوبدستهایش رابگذرانند. ");
INSERT INTO pesOPV_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","«و جامه لاجوردی گرفته، شمعدان روشنایی و چراغهایش و گلگیرهایش وسینی هایش و تمامی ظروف روغنش را که به آنهاخدمتش می‌کنند بپوشانند، ");
INSERT INTO pesOPV_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","و آن را و همه اسبابش را در پوشش پوست خز گذارده، برچوب دستی بگذارند. ");
INSERT INTO pesOPV_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","«و بر مذبح زرین، جامه لاجوردی گسترانیده، آن را به پوشش پوست خز بپوشانند، و چوب دستهایش را بگذرانند. ");
INSERT INTO pesOPV_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","«و تمامی اسباب خدمت را که به آنها درقدس خدمت می‌کنند گرفته، آنها را در جامه لاجوردی بگذرانند، و آنها را به پوشش پوست خز پوشانیده، بر چوب دست بنهند. ");
INSERT INTO pesOPV_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","«و مذبح را از خاکستر خالی کرده، جامه ارغوانی بر آن بگسترانند. ");
INSERT INTO pesOPV_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","و جمیع اسبابش راکه به آنها خدمت آن را می‌کنند یعنی مجمرها وچنگالها و خاک اندازها و کاسه‌ها، همه اسباب مذبح را بر روی آن بنهند، و بر آن پوشش، پوست خز گسترانیده، چوب دستهایش را بگذرانند. ");
INSERT INTO pesOPV_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","«و چون هارون و پسرانش در هنگام کوچ کردن اردو، از پوشانیدن قدس و تمامی اسباب قدس فارغ شوند، بعد از آن پسران قهات برای برداشتن آن بیایند، اما قدس را لمس ننمایند مبادابمیرند، این چیزها از خیمه اجتماع حمل بنی قهات می‌باشد. ");
INSERT INTO pesOPV_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","«و ودیعت العازار بن هارون کاهن، روغن بجهت روشنایی و بخور خوشبو و هدیه آردی دائمی و روغن مسح و نظارت تمامی مسکن می‌باشد، با هرآنچه در آن است، خواه از قدس وخواه از اسبابش.» ");
INSERT INTO pesOPV_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","و خداوند موسی و هارون را خطاب کرده، گفت: ");
INSERT INTO pesOPV_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","«سبط قبایل قهاتیان را از میان لاویان منقطع مسازید. ");
INSERT INTO pesOPV_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","بلکه با ایشان چنین رفتارنمایید تا چون به قدس‌الاقداس نزدیک آیند، زنده بمانند و نمیرند. هارون و پسرانش داخل آن بشوند، و هریک از ایشان را به خدمت و حمل خود بگمارند. ");
INSERT INTO pesOPV_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","و اما ایشان بجهت دیدن قدس لحظه‌ای هم داخل نشوند، مبادا بمیرند.» ");
INSERT INTO pesOPV_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","و خداوند موسی را خطاب کرده، گفت: ");
INSERT INTO pesOPV_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","«حساب بنی جرشون را نیز برحسب خاندان آباو قبایل ایشان بگیر. ");
INSERT INTO pesOPV_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","از سی ساله و بالاتر تاپنجاه ساله ایشان را بشمار، هر‌که داخل شود تادر خیمه اجتماع به شغل بپردازد و خدمت بنماید. ");
INSERT INTO pesOPV_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","«این است خدمت قبایل بنی جرشون درخدمت گذاری و حمل، ");
INSERT INTO pesOPV_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","که تجیرهای مسکن وخیمه اجتماع را با پوشش آن و پوشش پوست خز که بر بالای آن است، و پرده دروازه خیمه اجتماع را بردارند. ");
INSERT INTO pesOPV_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","و تجیرهای صحن و پرده مدخل دروازه صحن، که پیش مسکن و به اطراف مذبح است، و طنابهای آنها و همه اسباب خدمت آنها و هرچه به آنها باید کرده شود، ایشان بکنند. ");
INSERT INTO pesOPV_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","و تمامی خدمت بنی جرشون در هر حمل وخدمت ایشان، به فرمان هارون و پسران او بشود، و جمیع حملهای ایشان را بر ایشان ودیعت گذارید. ");
INSERT INTO pesOPV_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","این است خدمت قبایل بنی جرشون در خیمه اجتماع. و نظارت ایشان به‌دست ایتامار بن هارون کاهن باشد. ");
INSERT INTO pesOPV_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","«و بنی مراری را برحسب قبایل و خاندان آبای ایشان بشمار. ");
INSERT INTO pesOPV_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","از سی ساله و بالاتر تاپنجاه ساله هرکه به خدمت داخل شود، تا کارخیمه اجتماع را بنماید. ایشان را بشمار. ");
INSERT INTO pesOPV_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","این است ودیعت حمل ایشان، در تمامی خدمت ایشان در خیمه اجتماع، تختهای مسکن وپشت بندهایش و ستونهایش و پایه هایش ");
INSERT INTO pesOPV_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","وستونهای اطراف صحن و پایه های آنها و میخهای آنها و طنابهای آنها با همه اسباب آنها، و تمامی خدمت آنها، پس اسباب ودیعت حمل ایشان رابه نامها حساب کنید. ");
INSERT INTO pesOPV_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","این است خدمت قبایل بنی مراری در تمامی خدمت ایشان در خیمه اجتماع، زیردست ایتامار بن هارون کاهن.» ");
INSERT INTO pesOPV_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","و موسی و هارون و سروران جماعت، بنی قهات را برحسب قبایل و خاندان آبای ایشان شمردند. ");
INSERT INTO pesOPV_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","از سی ساله و بالاتر تا پنجاه ساله هرکه به خدمت داخل می‌شد تا در خیمه اجتماع مشغول شود. ");
INSERT INTO pesOPV_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","و شمرده شدگان ایشان برحسب قبایل ایشان، دو هزار و هفتصد و پنجاه نفر بودند. ");
INSERT INTO pesOPV_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","اینانند شمرده شدگان قبایل قهاتیان، هرکه درخیمه اجتماع کار می‌کرد که موسی و هارون ایشان را برحسب آنچه خداوند به واسطه موسی فرموده بود، شمردند. ");
INSERT INTO pesOPV_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","و شمرده شدگان بنی جرشون برحسب قبایل و خاندان آبای ایشان، ");
INSERT INTO pesOPV_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","از سی ساله وبالاتر تا پنجاه ساله، هرکه به خدمت داخل می‌شدتا در خیمه اجتماع کار کند. ");
INSERT INTO pesOPV_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","و شمرده شدگان ایشان برحسب قبایل و خاندان آبای ایشان، دوهزار و ششصد و سی نفر بودند. ");
INSERT INTO pesOPV_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","اینانند شمرده شدگان قبایل بنی جرشون، هرکه در خیمه اجتماع کار می‌کرد که موسی و هارون ایشان رابرحسب فرمان خداوند شمردند. ");
INSERT INTO pesOPV_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","و شمرده شدگان قبایل بنی مراری برحسب قبایل و خاندان آبای ایشان، ");
INSERT INTO pesOPV_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","از سی ساله وبالاتر تا پنجاه ساله، هرکه به خدمت داخل می‌شدتا در خیمه اجتماع کار کند. ");
INSERT INTO pesOPV_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","و شمرده شدگان ایشان برحسب قبایل ایشان سه هزار و دویست نفر بودند. ");
INSERT INTO pesOPV_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","اینانند شمرده شدگان قبایل بنی مراری که موسی و هارون ایشان را برحسب آنچه خداوند به واسطه موسی فرموده بود، شمردند. ");
INSERT INTO pesOPV_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","جمیع شمرده شدگان لاویان که موسی وهارون و سروران اسرائیل ایشان را برحسب قبایل و خاندان آبای ایشان شمردند، ");
INSERT INTO pesOPV_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","از سی ساله و بالاتر تا پنجاه ساله هرکه داخل می‌شد تاکار خدمت و کار حملها را در خیمه اجتماع بکند. ");
INSERT INTO pesOPV_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","شمرده شدگان ایشان هشت هزار وپانصد و هشتاد نفر بودند، ");
INSERT INTO pesOPV_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","برحسب فرمان خداوند به توسط موسی، هرکس موافق خدمتش و حملش شمرده شد. و چنانکه خداوند موسی را امر فرموده بود، اوایشان را شمرد. ");
INSERT INTO pesOPV_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","و خداوند موسی را خطاب کرده، گفت: ");
INSERT INTO pesOPV_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","«بنی‌اسرائیل را امر فرما که مبروص را وهرکه جریان دارد و هرکه از میته نجس شود، ازاردو اخراج کنند. ");
INSERT INTO pesOPV_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","خواه مرد و خواه زن، ایشان رااخراج نمایید؛ بیرون از اردو ایشان را اخراج نمایید، تا اردوی خود را جایی که من در میان ایشان ساکن هستم، نجس نسازند.» ");
INSERT INTO pesOPV_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","وبنی‌اسرائیل چنین کردند، و آن کسان را بیرون ازاردو اخراج کردند. چنانکه خداوند به موسی گفته بود، بنی‌اسرائیل به آن طور عمل نمودند. ");
INSERT INTO pesOPV_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","و خداوند موسی را خطاب کرده، گفت: ");
INSERT INTO pesOPV_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","«بنی‌اسرائیل را بگو: هرگاه مردی یا زنی به هرکدام از جمیع گناهان انسان مرتکب شده، به خداوند خیانت ورزد، و آن شخص مجرم شود، ");
INSERT INTO pesOPV_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","آنگاه گناهی را که کرده است اعتراف بنماید، واصل جرم خود را رد نماید، و خمس آن را برآن مزید کرده، به کسی‌که بر او جرم نموده است، بدهد. ");
INSERT INTO pesOPV_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","و اگر آن کس را ولی‌ای نباشد که دیه جرم به او داده شود، آنگاه دیه جرمی که برای خداوندداده می‌شود، از آن کاهن خواهد بود، علاوه برقوچ کفاره که به آن درباره وی کفاره می‌شود. ");
INSERT INTO pesOPV_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","وهر هدیه افراشتنی از همه موقوفات بنی‌اسرائیل که نزد کاهن می‌آورند، از آن او باشد. ");
INSERT INTO pesOPV_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","وموقوفات هر کس از آن او خواهد بود، و هرچه که کسی به کاهن بدهد، از آن او باشد.» ");
INSERT INTO pesOPV_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","و خداوند موسی را خطاب کرده، گفت: ");
INSERT INTO pesOPV_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","«بنی‌اسرائیل را خطاب کرده، به ایشان بگو: هرگاه زن کسی از او برگشته، به وی خیانت ورزد، ");
INSERT INTO pesOPV_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","و مردی دیگر با او همبستر شود، و این ازچشمان شوهرش پوشیده و مستور باشد، آن زن نجس می‌باشد، و اگر بر او شاهدی نباشد و در عین فعل گرفتار نشود، ");
INSERT INTO pesOPV_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","و روح غیرت بر او بیایدو به زن خود غیور شود، و آن زن نجس شده باشد، یا روح غیرت بر او بیاید و به زن خود غیورشود، و آن زن نجس نشده باشد، ");
INSERT INTO pesOPV_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","پس آن مردزن خود را نزد کاهن بیاورد، و بجهت او برای هدیه، یک عشر ایفه آرد جوین بیاورد، و روغن برآن نریزد، و کندر بر آن ننهد، زیرا که هدیه غیرت است و هدیه یادگار، که گناه را بیاد می‌آورد. ");
INSERT INTO pesOPV_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","«و کاهن او را نزدیک آورده، به حضورخداوند برپا دارد. ");
INSERT INTO pesOPV_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","و کاهن آب مقدس در ظرف سفالین بگیرد، و کاهن قدری از غباری که بر زمین مسکن باشد گرفته، بر آب بپاشد. ");
INSERT INTO pesOPV_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","و کاهن زن رابه حضور خداوند برپا داشته، موی سر او را بازکند و هدیه یادگار را که هدیه غیرت باشد بردست آن زن بگذارد، و آب تلخ لعنت بر دست کاهن باشد. ");
INSERT INTO pesOPV_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","و کاهن به زن قسم داده، به وی بگوید: اگر کسی با تو همبستر نشده، و اگر بسوی نجاست به کسی غیر از شوهر خود برنگشته‌ای، پس از این آب تلخ لعنت مبرا شوی. ");
INSERT INTO pesOPV_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","و لیکن اگر به غیر از شوهر خود برگشته، نجس شده‌ای، وکسی غیر از شوهرت با تو همبستر شده است، ");
INSERT INTO pesOPV_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","آنگاه کاهن زن را قسم لعنت بدهد و کاهن به زن بگوید: خداوند تو را در میان قومت موردلعنت و قسم بسازد به اینکه خداوند ران تو راساقط و شکم تو را منتفخ گرداند. ");
INSERT INTO pesOPV_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","و این آب لعنت در احشای تو داخل شده، شکم تو را منتفخ و ران تو را ساقط بسازد. و آن زن بگوید: آمین آمین. ");
INSERT INTO pesOPV_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","«و کاهن این لعنتها را در طوماری بنویسد، و آنها را در آب تلخ محو کند. ");
INSERT INTO pesOPV_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","و آن آب لعنت تلخ را به زن بنوشاند، و آن آب لعنت در او داخل شده، تلخ خواهد شد. ");
INSERT INTO pesOPV_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","و کاهن هدیه غیرت رااز دست زن گرفته، آن هدیه را به حضور خداوندبجنباند، و آن را نزد مذبح بیاورد. ");
INSERT INTO pesOPV_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","و کاهن مشتی از هدیه برای یادگاری آن گرفته، آن را برمذبح بسوزاند و بعد از آن، آن آب را به زن بنوشاند. ");
INSERT INTO pesOPV_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","و چون آب را به او نوشانید، اگرنجس شده و به شوهر خود خیانت ورزیده باشد، آن آب لعنت داخل او شده، تلخ خواهد شد، وشکم او منتفخ و ران او ساقط خواهد گردید، و آن زن در میان قوم خود مورد لعنت خواهدبود. ");
INSERT INTO pesOPV_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","واگر آن زن نجس نشده، طاهر باشد، آنگاه مبراشده، اولاد خواهد زایید. ");
INSERT INTO pesOPV_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","«این است قانون غیرت، هنگامی که زن ازشوهر خود برگشته، نجس شده باشد. ");
INSERT INTO pesOPV_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","یاهنگامی که روح غیرت بر مرد بیاید، و بر زنش غیور شود، آنگاه زن را به حضور خداوند برپابدارد، و کاهن تمامی این قانون را درباره او اجرادارد. ");
INSERT INTO pesOPV_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","پس آن مرد از گناه مبرا شود، و زن گناه خود را متحمل خواهد بود.» ");
INSERT INTO pesOPV_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","و خداوند موسی را خطاب کرده، گفت: ");
INSERT INTO pesOPV_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","«بنی‌اسرائیل را خطاب کرده، به ایشان بگو: چون مرد یا زن نذر خاص، یعنی نذر نذیره بکند، و خود را برای خداوند تخصیص نماید، ");
INSERT INTO pesOPV_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","آنگاه از شراب و مسکرات بپرهیزد و سرکه شراب و سرکه مسکرات را ننوشد، و هیچ عصیرانگور ننوشد، و انگور تازه یا خشک نخورد. ");
INSERT INTO pesOPV_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","وتمام ایام تخصیصش از هر چیزی که از تاک انگور ساخته شود، از هسته تا پوست نخورد. ");
INSERT INTO pesOPV_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","«و تمام ایام نذر تخصیص او، استره بر سر اونیاید، و تا انقضای روزهایی که خود را برای خداوند تخصیص نموده است، مقدس شده، گیسهای موی سر خود را بلند دارد. ");
INSERT INTO pesOPV_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","و تمام روزهایی که خود را برای خداوندتخصیص نموده است، نزدیک بدن میت نیاید. ");
INSERT INTO pesOPV_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","برای پدر و مادر و برادر و خواهر خود، هنگامی که بمیرند خویشتن را نجس نسازد، زیرا که تخصیص خدایش بر سر وی می‌باشد. ");
INSERT INTO pesOPV_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","تمامی روزهای تخصیصش برای خداوند مقدس خواهد بود. ");
INSERT INTO pesOPV_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","«و اگر کسی دفعت ناگهان نزد او بمیرد، پس سر خود را در روز طهارت خویش بتراشد، یعنی در روز هفتم آن را بتراشد. ");
INSERT INTO pesOPV_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","و در روز هشتم دوفاخته یا دو جوجه کبوتر نزد کاهن به در خیمه اجتماع بیاورد. ");
INSERT INTO pesOPV_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","و کاهن یکی را برای قربانی گناه و دیگری را برای قربانی سوختنی گذرانیده، برای وی کفاره نماید، از آنچه به‌سبب میت، گناه کرده است و سر او را در آن روز تقدیس نماید. ");
INSERT INTO pesOPV_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","و روزهای تخصیص خود را برای خداوند (ازنو) تخصیص نماید، و بره نرینه یک ساله برای قربانی جرم بیاورد، لیکن روزهای اول ساقطخواهد بود، چونکه تخصیصش نجس شده است. ");
INSERT INTO pesOPV_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","«این است قانون نذیره، چون روزهای تخصیص او تمام شود، آنگاه او را نزد دروازه خیمه اجتماع بیاورند. ");
INSERT INTO pesOPV_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","و قربانی خود را برای خداوند بگذراند، یعنی یک بره نرینه یک ساله بی‌عیب بجهت قربانی سوختنی، و یک بره ماده‌یک ساله بی‌عیب، بجهت قربانی گناه، و یک قوچ بی عیب بجهت ذبیحه سلامتی. ");
INSERT INTO pesOPV_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","و یک سبد نان فطیر یعنی گرده های آرد نرم سرشته شده باروغن، و قرصهای فطیر مسح شده با روغن، وهدیه آردی آنها و هدیه ریختنی آنها. ");
INSERT INTO pesOPV_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","«و کاهن آنها را به حضور خداوند نزدیک آورده، قربانی گناه و قربانی سوختنی او رابگذراند. ");
INSERT INTO pesOPV_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","و قوچ را با سبد نان فطیر بجهت ذبیحه سلامتی برای خداوند بگذراند، و کاهن هدیه آردی و هدیه ریختنی او را بگذراند. ");
INSERT INTO pesOPV_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","«و آن نذیره سر تخصیص خود را نزد درخیمه اجتماع بتراشد، و موی سر تخصیص خودرا گرفته، آن را بر آتشی که زیر ذبیحه سلامتی است بگذراند. ");
INSERT INTO pesOPV_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","«و کاهن سردست بریان شده قوچ را با یک گرده فطیر از سبد و یک قرص فطیر گرفته، آن رابر دست نذیره، بعد از تراشیدن سر تخصیصش بگذارد. ");
INSERT INTO pesOPV_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","و کاهن آنها را بجهت هدیه جنبانیدنی به حضور خداوند بجنباند، این با سینه جنبانیدنی و ران افراشتنی برای کاهن، مقدس است. و بعد ازآن نذیره شراب بنوشد. ");
INSERT INTO pesOPV_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","«این است قانون نذیره‌ای که نذر بکند وقانون قربانی که بجهت تخصیص خود برای خداوند باید بگذراند، علاوه بر آنچه دستش به آن می‌رسد موافق نذری که کرده باشد، همچنین برحسب قانون تخصیص خود، باید بکند.» ");
INSERT INTO pesOPV_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","و خداوند موسی را خطاب کرده، گفت: ");
INSERT INTO pesOPV_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","«هارون و پسرانش را خطاب کرده، بگو: به اینطور بنی‌اسرائیل را برکت دهید و به ایشان بگویید: ");
INSERT INTO pesOPV_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","«یهوه تو را برکت دهد و تو را محافظت نماید. ");
INSERT INTO pesOPV_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","یهوه روی خود را بر تو تابان سازد و برتو رحمت کند. ");
INSERT INTO pesOPV_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","یهوه روی خود را بر توبرافرازد و تو را سلامتی بخشد، ");
INSERT INTO pesOPV_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","و نام مرابنی‌اسرائیل بگذارند، و من ایشان را برکت خواهم داد.» ");
INSERT INTO pesOPV_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","و در روزی که موسی از برپا داشتن مسکن فارغ شده و آن را مسح نموده و تقدیس کرده و تمامی اسبابش را و مذبح را با تمامی اسبابش مسح کرده و تقدیس نموده بود، ");
INSERT INTO pesOPV_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","سروران اسرائیل و روسای خاندان آبای ایشان هدیه گذرانیدند. و اینها روسای اسباط بودند که برشمرده شدگان گماشته شدند. ");
INSERT INTO pesOPV_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","پس ایشان بجهت هدیه خود، به حضور خداوند شش ارابه‌سرپوشیده و دوازده گاو آوردند، یعنی یک ارابه برای دو سرور، و برای هر نفری یک گاو، و آنها راپیش روی مسکن آوردند. ");
INSERT INTO pesOPV_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","و خداوند موسی را خطاب کرده، گفت: ");
INSERT INTO pesOPV_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","«اینها را از ایشان بگیر تا برای بجا آوردن خدمت خیمه اجتماع به‌کار آید، و به لاویان به هرکس به اندازه خدمتش تسلیم نما.» ");
INSERT INTO pesOPV_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","پس موسی ارابه‌ها و گاوها را گرفته، آنها را به لاویان تسلیم نمود. ");
INSERT INTO pesOPV_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","دو ارابه و چهار گاو به بنی جرشون، به اندازه خدمت ایشان تسلیم نمود. ");
INSERT INTO pesOPV_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","و چهار ارابه و هشت گاو به بنی مراری، به اندازه خدمت ایشان، به‌دست ایتامار بن هارون کاهن تسلیم نمود. ");
INSERT INTO pesOPV_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","اما به بنی قهات هیچ نداد، زیراخدمت قدس متعلق به ایشان بود و آن را بر دوش خود برمی داشتند. ");
INSERT INTO pesOPV_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","و سروران بجهت تبرک مذبح، در روز مسح کردن آن، هدیه گذرانیدند. وسروران هدیه خود را پیش مذبح آوردند. ");
INSERT INTO pesOPV_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","وخداوند به موسی گفت که هر سرور در روز نوبه خود هدیه خویش را بجهت تبرک مذبح بگذراند. ");
INSERT INTO pesOPV_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","و در روز اول، نحشون بن عمیناداب ازسبط یهودا هدیه خود را گذرانید. ");
INSERT INTO pesOPV_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","و هدیه اویک طبق نقره بود که وزنش صد و سی مثقال بود، و یک لگن نقره، هفتاد مثقال به مثقال قدس که هردوی آنها پر از آرد نرم مخلوط شده با روغن بودبجهت هدیه آردی. ");
INSERT INTO pesOPV_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","و یک قاشق طلا ده مثقال پر از بخور. ");
INSERT INTO pesOPV_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","و یک گاو جوان و یک قوچ و یک بره نرینه یک ساله بجهت قربانی سوختنی. ");
INSERT INTO pesOPV_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","ویک بز نر بجهت قربانی گناه. ");
INSERT INTO pesOPV_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","و بجهت ذبیحه سلامتی، دو گاو و پنج قوچ و پنج بز نر و پنج بره نرینه یک ساله، این بود هدیه نحشون بن عمیناداب. ");
INSERT INTO pesOPV_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","و در روز دوم، نتنائیل بن صوغر، سروریساکار هدیه گذرانید. ");
INSERT INTO pesOPV_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","و هدیه‌ای که او گذرانیدیک طبق نقره بود که وزنش صد و سی مثقال بود، و یک لگن نقره هفتاد مثقال، موافق مثقال قدس، هر دوی آنها پر از آرد نرم مخلوط با روغن بجهت هدیه آردی. ");
INSERT INTO pesOPV_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","و یک قاشق طلا ده مثقال پر ازبخور. ");
INSERT INTO pesOPV_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","و یک گاو جوان و یک قوچ و یک بره نرینه یک ساله، بجهت قربانی سوختنی. ");
INSERT INTO pesOPV_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","و یک بز نر بجهت قربانی گناه. ");
INSERT INTO pesOPV_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","و بجهت ذبیحه سلامتی، دو گاو و پنج قوچ و پنج بز نر و پنج بره نرینه یک ساله، این بود هدیه نتنائیل بن صوغر. ");
INSERT INTO pesOPV_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","و در روز سوم، الیاب بن حیلون سروربنی زبولون، ");
INSERT INTO pesOPV_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","هدیه او یک طبق نقره که وزنش صد و سی مثقال بود، و یک لگن نقره هفتاد مثقال، موافق مثقال قدس، هر دوی آنها پر از آرد نرم مخلوط با روغن بجهت هدیه آردی. ");
INSERT INTO pesOPV_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","و یک قاشق طلا ده مثقال پر از بخور، ");
INSERT INTO pesOPV_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","و یک گاوجوان و یک قوچ بره نرینه یک ساله بجهت قربانی سوختنی. ");
INSERT INTO pesOPV_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","و یک بز نر بجهت قربانی گناه. ");
INSERT INTO pesOPV_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","وبجهت ذبیحه سلامتی، دو گاو و پنج قوچ و پنج بزنر و پنج بره نرینه یک ساله. این بود هدیه الیاب بن حیلون. ");
INSERT INTO pesOPV_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","و در روز چهارم، الیصور بن شدیئور سروربنی روبین. ");
INSERT INTO pesOPV_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","هدیه او یک طبق نقره که وزنش صدو سی مثقال بود، و یک لگن نقره هفتاد مثقال، موافق مثقال قدس، هر دوی آنها پر از آرد نرم مخلوط با روغن بجهت هدیه آردی. ");
INSERT INTO pesOPV_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","و یک قاشق طلا ده مثقال پر از بخور. ");
INSERT INTO pesOPV_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","و یک گاو جوان و یک قوچ و یک بره نرینه یک ساله بجهت قربانی سوختنی. ");
INSERT INTO pesOPV_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","و یک بز نر بجهت قربانی گناه. ");
INSERT INTO pesOPV_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","وبجهت ذبیحه سلامتی، دو گاو و پنج قوچ و پنج بزنر و پنج بره نرینه یک ساله. این بود هدیه الیصوربن شدیئور. ");
INSERT INTO pesOPV_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","و در روز پنجم، شلومیئیل بن صوریشدای سرور بنی شمعون. ");
INSERT INTO pesOPV_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","هدیه او یک طبق نقره که وزنش صد و سی مثقال بود، و یک لگن نقره هفتادمثقال، موافق مثقال قدس، هر دوی آنها پر از آردنرم مخلوط با روغن بجهت هدیه آردی. ");
INSERT INTO pesOPV_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","و یک قاشق طلا ده مثقال پر از بخور. ");
INSERT INTO pesOPV_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","و یک گاو جوان و یک قوچ و یک بره نرینه یک ساله بجهت قربانی سوختنی. ");
INSERT INTO pesOPV_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","و یک بز نر بجهت قربانی گناه. ");
INSERT INTO pesOPV_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","وبجهت ذبیحه سلامتی، دو گاو و پنج قوچ و پنج بزنر و پنج بره نرینه یک ساله. این بود هدیه شلومیئیل بن صوریشدای. ");
INSERT INTO pesOPV_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","و در روز ششم، الیاساف بن دعوئیل سروربنی جاد. ");
INSERT INTO pesOPV_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","هدیه او یک طبق نقره که وزنش صدو سی مثقال بود، و یک لگن نقره هفتاد مثقال، موافق مثقال قدس، هر دوی آنها پر از آرد نرم مخلوط با روغن بجهت هدیه آردی. ");
INSERT INTO pesOPV_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","و یک قاشق طلا ده مثقال پر از بخور. ");
INSERT INTO pesOPV_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","و یک گاو جوان و یک قوچ و یک بره نرینه یک ساله بجهت قربانی سوختنی. ");
INSERT INTO pesOPV_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","و یک بز نر بجهت قربانی گناه. ");
INSERT INTO pesOPV_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","وبجهت ذبیحه سلامتی، دو گاو و پنج قوچ و پنج بزنر و پنج بره نرینه یک ساله. این بود هدیه الیاساف بن دعوئیل. ");
INSERT INTO pesOPV_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","و در روز هفتم، الیشمع بن عمیهود سروربنی افرایم. ");
INSERT INTO pesOPV_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","هدیه او یک طبق نقره که وزنش صد و سی مثقال بود، و یک لگن نقره هفتاد مثقال، موافق مثقال قدس، هر دوی آنها پر از آرد نرم مخلوط با روغن بجهت هدیه آردی. ");
INSERT INTO pesOPV_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","و یک قاشق طلا ده مثقال پر از بخور. ");
INSERT INTO pesOPV_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","و یک گاو جوان و یک قوچ و یک بره نرینه یک ساله بجهت قربانی سوختنی. ");
INSERT INTO pesOPV_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","و یک بز نر بجهت قربانی گناه. ");
INSERT INTO pesOPV_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","وبجهت ذبیحه سلامتی، دو گاو و پنج قوچ و پنج بزنر و پنج بره نرینه یک ساله. این بود هدیه الیشمع بن عمیهود. ");
INSERT INTO pesOPV_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","و در روز هشتم، جملیئیل بن فدهصورسرور بنی منسی. ");
INSERT INTO pesOPV_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","هدیه او یک طبق نقره که وزنش صد و سی مثقال بود، و یک لگن نقره هفتادمثقال، موافق مثقال قدس، هر دوی آنها پر از آردنرم مخلوط با روغن بجهت هدیه آردی. ");
INSERT INTO pesOPV_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","و یک قاشق طلا ده مثقال پر از بخور. ");
INSERT INTO pesOPV_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","و یک گاوجوان و یک قوچ و یک بره نرینه یک ساله بجهت قربانی سوختنی. ");
INSERT INTO pesOPV_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","و یک بز نر بجهت قربانی گناه. ");
INSERT INTO pesOPV_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","و بجهت ذبیحه سلامتی، دو گاو و پنج قوچ و پنج بز نر و پنج بره نرینه یک ساله. این بودهدیه جملیئیل بن فدهصور. ");
INSERT INTO pesOPV_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","و در روز نهم، ابیدان بن جدعونی سروربنی بنیامین. ");
INSERT INTO pesOPV_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","هدیه او یک طبق نقره که وزنش صد و سی مثقال بود و یک لگن نقره هفتاد مثقال موافق مثقال قدس، هر دوی آنها پر از آرد نرم مخلوط با روغن، بجهت هدیه آردی. ");
INSERT INTO pesOPV_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","و یک قاشق طلا ده مثقال پر از بخور. ");
INSERT INTO pesOPV_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","و یک گاو جوان و یک قوچ و یک بره نرینه یک ساله بجهت قربانی سوختنی. ");
INSERT INTO pesOPV_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","و یک بز نر به جهت قربانی گناه ");
INSERT INTO pesOPV_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","به جهت ذبیحه سلامتی دو گاو و پنج قوچ و پنج بره نرینه یک ساله. این بود هدیه ابیدان بن جدعونی. ");
INSERT INTO pesOPV_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","و در روز دهم، اخیعزربن عمیشدای سروربنی دان. ");
INSERT INTO pesOPV_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","هدیه او یک طبق نقره که وزنش صد وسی مثقال بود، و یک لگن نقره، هفتاد مثقال موافق مثقال قدس، هر دوی آنها پر از آرد نرم مخلوط باروغن بجهت هدیه آردی. ");
INSERT INTO pesOPV_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","و یک قاشق طلا، ده مثقال پر از بخور. ");
INSERT INTO pesOPV_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","و یک گاو جوان و یک قوچ ویک بره نرینه یک ساله بجهت قربانی سوختنی. ");
INSERT INTO pesOPV_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","و یک بز نر بجهت قربانی گناه. ");
INSERT INTO pesOPV_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","و بجهت ذبیحه سلامتی، دو گاو و پنج قوچ و پنج بز نر وپنج بره نرینه یک ساله. این بود هدیه اخیعزر بن عمیشدای. ");
INSERT INTO pesOPV_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","و در روز یازدهم، فجعیئیل بن عکران سرور بنی اشیر. ");
INSERT INTO pesOPV_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","هدیه او یک طبق نقره که وزنش صد و سی مثقال بود، و یک لگن نقره، هفتاد مثقال موافق مثقال قدس؛ هردوی آنها پر ازآرد نرم مخلوط با روغن بجهت هدیه آردی. ");
INSERT INTO pesOPV_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","ویک قاشق طلا ده مثقال پر از بخور. ");
INSERT INTO pesOPV_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","و یک گاوجوان و یک قوچ و بره نرینه یک ساله بجهت قربانی سوختنی. ");
INSERT INTO pesOPV_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","و یک بز نر بجهت قربانی گناه. ");
INSERT INTO pesOPV_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","و بجهت ذبیحه سلامتی، دو گاو و پنج قوچ و پنج بز نر و پنج بره نرینه یک ساله. این بودهدیه فجعیئیل بن عکران. ");
INSERT INTO pesOPV_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","و در روز دوازدهم، اخیرع بن عینان، سروربنی نفتالی. ");
INSERT INTO pesOPV_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","هدیه او یک طبق نقره که وزنش صد و سی مثقال بود، و یک لگن نقره هفتاد مثقال موافق مثقال قدس، هردوی آنها پر از آرد نرم مخلوط با روغن بجهت هدیه آردی. ");
INSERT INTO pesOPV_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","و یک قاشق طلا، ده مثقال پر از بخور. ");
INSERT INTO pesOPV_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","و یک گاوجوان و یک قوچ و یک بره نرینه یک ساله بجهت قربانی سوختنی. ");
INSERT INTO pesOPV_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","و یک بز نر بجهت قربانی گناه. ");
INSERT INTO pesOPV_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","و بجهت ذبیحه سلامتی، دو گاو و پنج قوچ و پنج بز نر و پنج بره نرینه یک ساله. این بودهدیه اخیرع بن عینان. ");
INSERT INTO pesOPV_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","این بود تبرک مذبح در روزی که مسح شده بود، از جانب سروران اسرائیل دوازده طبق نقره و دوازده لگن نقره و دوازده قاشق طلا. ");
INSERT INTO pesOPV_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","هرطبق نقره صد و سی مثقال و هر لگن هفتاد، که تمامی نقره ظروف، دوهزار و چهارصد مثقال موافق مثقال قدس بود. ");
INSERT INTO pesOPV_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","و دوازده قاشق طلا پراز بخور هر کدام ده مثقال موافق مثقال قدس، که تمامی طلای قاشقها صد و بیست مثقال بود. ");
INSERT INTO pesOPV_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","تمامی گاوان بجهت قربانی سوختنی، دوازده گاو و دوازده قوچ و دوازده بره نرینه یک ساله. باهدیه آردی آنها و دوازده بز نر بجهت قربانی گناه. ");
INSERT INTO pesOPV_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","و تمامی گاوان بجهت ذبیحه سلامتی، بیست وچهار گاو و شصت قوچ و شصت بز نر و شصت بره نرینه یک ساله. این بود تبرک مذبح بعد از آنکه مسح شده بود. ");
INSERT INTO pesOPV_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","و چون موسی به خیمه اجتماع داخل شدتا با وی سخن گوید، آنگاه قول را می‌شنید که ازبالای کرسی رحمت که بر تابوت شهادت بود، ازمیان دو کروبی به وی سخن می‌گفت، پس با اوتکلم می‌نمود. ");
INSERT INTO pesOPV_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","و خداوند موسی را خطاب کرده، گفت: ");
INSERT INTO pesOPV_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","«هارون را خطاب کرده، به وی بگو: هنگامی که چراغها را برافرازی، هفت چراغ پیش شمعدان روشنایی بدهد.» ");
INSERT INTO pesOPV_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","پس هارون چنین کرد، و چراغها را برافراشت تا پیش شمعدان روشنایی بدهد، چنانکه خداوند موسی را امرفرموده بود. ");
INSERT INTO pesOPV_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","و صنعت شمعدان این بود: ازچرخکاری طلا از ساق تا گلهایش چرخکاری بود، موافق نمونه‌ای که خداوند به موسی نشان داده بود، به همین طور شمعدان را ساخت. ");
INSERT INTO pesOPV_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","و خداوند موسی را خطاب کرده، گفت: ");
INSERT INTO pesOPV_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","«لاویان را از میان بنی‌اسرائیل گرفته، ایشان راتطهیر نما. ");
INSERT INTO pesOPV_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","و بجهت تطهیر ایشان، به ایشان چنین عمل نما، آن کفاره گناه را بر ایشان بپاش و بر تمام بدن خود استره بگذرانند، و رخت خود را شسته، خود را تطهیر نمایند. ");
INSERT INTO pesOPV_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","و گاوی جوان و هدیه آردی آن، یعنی آرد نرم مخلوط با روغن بگیرند، وگاو جوان دیگر بجهت قربانی گناه بگیر. ");
INSERT INTO pesOPV_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","ولاویان را پیش خیمه اجتماع نزدیک بیاور، وتمامی جماعت بنی‌اسرائیل را جمع کن. ");
INSERT INTO pesOPV_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","ولاویان را به حضور خداوند نزدیک بیاور، وبنی‌اسرائیل دستهای خود را بر لاویان بگذارند. ");
INSERT INTO pesOPV_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","و هارون لاویان را از جانب بنی‌اسرائیل به حضور خداوند هدیه بگذراند، تا خدمت خداوندرا بجا بیاورند. ");
INSERT INTO pesOPV_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","و لاویان دستهای خود را بر سرگاوان بنهند، و تو یکی را بجهت قربانی گناه ودیگری را بجهت قربانی سوختنی برای خداوندبگذران، تا بجهت لاویان کفاره شود. ");
INSERT INTO pesOPV_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","و لاویان را پیش هارون و پسرانش برپا بدار، و ایشان رابرای خداوند هدیه بگذران. ");
INSERT INTO pesOPV_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","و لاویان را از میان بنی‌اسرائیل جدا نما و لاویان از آن من خواهندبود. ");
INSERT INTO pesOPV_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","«و بعد از آن لاویان داخل شوند تا خدمت خیمه اجتماع را بجا آورند، و تو ایشان را تطهیرکرده، ایشان را هدیه بگذران. ");
INSERT INTO pesOPV_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","زیراکه ایشان ازمیان بنی‌اسرائیل به من بالکل داده شده‌اند، و به عوض هر گشاینده رحم، یعنی به عوض همه نخست زادگان بنی‌اسرائیل، ایشان را برای خودگرفته‌ام. ");
INSERT INTO pesOPV_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","زیرا که جمیع نخست زادگان بنی‌اسرائیل خواه از انسان و خواه از بهایم، از آن من‌اند، در روزی که جمیع نخست زادگان را درزمین مصر زدم، ایشان را برای خود تقدیس نمودم. ");
INSERT INTO pesOPV_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","پس لاویان را به عوض همه نخست زادگان بنی‌اسرائیل گرفتم. ");
INSERT INTO pesOPV_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","و لاویان رااز میان بنی‌اسرائیل به هارون و پسرانش پیشکش دادم تا خدمت بنی‌اسرائیل را در خیمه اجتماع بجا آورند، و بجهت بنی‌اسرائیل کفاره نمایند، وچون بنی‌اسرائیل به قدس نزدیک آیند، وبا به بنی‌اسرائیل عارض نشود.» ");
INSERT INTO pesOPV_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","پس موسی و هارون و تمامی جماعت بنی‌اسرائیل به لاویان چنین کردند، برحسب هرآنچه خداوند موسی را درباره لاویان امرفرمود، همچنان بنی‌اسرائیل به ایشان عمل نمودند. ");
INSERT INTO pesOPV_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","و لاویان برای گناه خود کفاره کرده، رخت خود را شستند، و هارون ایشان را به حضور خداوند هدیه گذرانید، و هارون برای ایشان کفاره نموده، ایشان را تطهیر کرد. ");
INSERT INTO pesOPV_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","و بعداز آن لاویان داخل شدند تا در خیمه اجتماع به حضور هارون و پسرانش به خدمت خودبپردازند، و چنانکه خداوند موسی را درباره لاویان امر فرمود، همچنان به ایشان عمل نمودند. ");
INSERT INTO pesOPV_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","و خداوند موسی را خطاب کرده، گفت: ");
INSERT INTO pesOPV_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","«این است قانون لاویان که از بیست و پنج ساله و بالاتر داخل شوند تا در کار خیمه اجتماع مشغول خدمت بشوند. ");
INSERT INTO pesOPV_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","و از پنجاه ساله از کارخدمت بازایستند، و بعد از آن خدمت نکنند. ");
INSERT INTO pesOPV_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","لیکن با برادران خود در خیمه اجتماع به نگاهبانی نمودن مشغول شوند، و خدمتی دیگرنکنند. بدین طور با لاویان درباره ودیعت ایشان عمل نما.» ");
INSERT INTO pesOPV_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","و در ماه اول سال دوم بعد از بیرون آمدن ایشان از زمین مصر، خداوند موسی را درصحرای سینا خطاب کرده، گفت: ");
INSERT INTO pesOPV_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","«بنی‌اسرائیل عید فصح را در موسمش بجا آورند. ");
INSERT INTO pesOPV_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","در روزچهاردهم این ماه آن را در وقت عصر در موسمش بجا آورید، برحسب همه فرایضش و همه احکامش آن را معمول دارید.» ");
INSERT INTO pesOPV_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","پس موسی به بنی‌اسرائیل گفت که فصح رابجا آورند. ");
INSERT INTO pesOPV_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","و فصح را در روز چهاردهم ماه اول، در وقت عصر در صحرای سینا بجا آوردند، برحسب هرچه خداوند به موسی‌امر فرموده بودبنی‌اسرائیل چنان عمل نمودند. ");
INSERT INTO pesOPV_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","اما بعضی اشخاص بودند که از میت آدمی نجس شده، فصح را در آن روز نتوانستند بجا آورند، پس درآن روز نزد موسی و هارون آمدند. ");
INSERT INTO pesOPV_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","و آن اشخاص وی را گفتند که «ما از میت آدمی نجس هستیم؛ پس چرا از گذرانیدن قربانی خداوند در موسمش در میان بنی‌اسرائیل ممنوع شویم؟» ");
INSERT INTO pesOPV_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","موسی ایشان را گفت: «بایستید تا آنچه خداوند در حق شما امر فرماید، بشنوم.» ");
INSERT INTO pesOPV_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","و خداوند موسی را خطاب کرده، گفت: ");
INSERT INTO pesOPV_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","«بنی‌اسرائیل را خطاب کرده، بگو: اگر کسی ازشما یا از اعقاب شما از میت نجس شود، یا درسفر دور باشد، مع هذا فصح را برای خداوند بجاآورد. ");
INSERT INTO pesOPV_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","در روز چهاردهم ماه دوم، آن را دروقت عصر بجا آورند، و آن را با نان فطیر و سبزی تلخ بخورند. ");
INSERT INTO pesOPV_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","چیزی از آن تا صبح نگذارند و ازآن استخوانی نشکنند؛ برحسب جمیع فرایض فصح آن را معمول دارند. ");
INSERT INTO pesOPV_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","اما کسی‌که طاهرباشد و در سفر نباشد و از بجا آوردن فصح بازایستد، آن کس از قوم خود منقطع شود، چونکه قربانی خداوند را در موسمش نگذرانیده است، آن شخص گناه خود را متحمل خواهدشد. ");
INSERT INTO pesOPV_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","و اگر غریبی در میان شما ماوا گزیند وبخواهد که فصح را برای خداوند بجا آورد، برحسب فریضه و حکم فصح عمل نماید، برای شما یک فریضه می‌باشد خواه برای غریب وخواه برای متوطن.» ");
INSERT INTO pesOPV_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","و در روزی که مسکن برپا شد، ابر مسکن خیمه شهادت را پوشانید، و از شب تا صبح مثل منظر آتش بر مسکن می‌بود. ");
INSERT INTO pesOPV_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","همیشه چنین بودکه ابر آن را می‌پوشانید و منظر آتش در شب. ");
INSERT INTO pesOPV_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","وهرگاه ابر از خیمه برمی خاست بعد از آن بنی‌اسرائیل کوچ می‌کردند و در هر جایی که ابرساکن می‌شد آنجا بنی‌اسرائیل اردو می‌زدند. ");
INSERT INTO pesOPV_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","به فرمان خداوند بنی‌اسرائیل کوچ می‌کردند وبه فرمان خداوند اردو می‌زدند، همه روزهایی که ابر بر مسکن ساکن می‌بود، در اردو می‌ماندند. ");
INSERT INTO pesOPV_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","وچون ابر، روزهای بسیار برمسکن توقف می‌نمود، بنی‌اسرائیل ودیعت خداوند را نگاه می‌داشتند وکوچ نمی کردند. ");
INSERT INTO pesOPV_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","و بعضی اوقات ابر ایام قلیلی بر مسکن می‌ماند، آنگاه به فرمان خداوند در اردومی ماندند و به فرمان خداوند کوچ می‌کردند. ");
INSERT INTO pesOPV_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","وبعضی اوقات، ابر از شام تا صبح می‌ماند و دروقت صبح ابر برمی خاست، آنگاه کوچ می‌کردند، یا اگر روز و شب می‌ماند چون ابر برمی خاست، می‌کوچیدند. ");
INSERT INTO pesOPV_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","خواه دو روز و خواه یک ماه وخواه یک سال، هر قدر ابر بر مسکن توقف نموده، بر آن ساکن می‌بود، بنی‌اسرائیل در اردومی ماندند، و کوچ نمی کردند و چون برمی خاست، می‌کوچیدند. ");
INSERT INTO pesOPV_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","به فرمان خداونداردو می‌زدند، و به فرمان خداوند کوچ می‌کردند، و ودیعت خداوند را برحسب آنچه خداوند به واسطه موسی فرموده بود، نگاه می‌داشتند. ");
INSERT INTO pesOPV_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","و خداوند موسی را خطاب کرده، گفت: ");
INSERT INTO pesOPV_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","«برای خود دو کرنای نقره بساز، آنهارا از چرخکاری درست کن، و آنها را بجهت خواندن جماعت و کوچیدن اردو بکار ببر. ");
INSERT INTO pesOPV_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","وچون آنها را بنوازند تمامی جماعت نزد تو به درخیمه اجتماع جمع شوند. ");
INSERT INTO pesOPV_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","و چون یکی رابنوازند، سروران و روسای هزاره های اسرائیل نزد تو جمع شوند. ");
INSERT INTO pesOPV_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","و چون تیز آهنگ بنوازیدمحله هایی که به طرف مشرق جا دارند، کوچ بکنند. ");
INSERT INTO pesOPV_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","و چون مرتبه دوم تیز آهنگ بنوازید، محله هایی که به طرف جنوب جا دارند کوچ کنند؛ بجهت کوچ دادن ایشان تیز آهنگ بنوازند. ");
INSERT INTO pesOPV_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","و بجهت جمع کردن جماعت بنوازید، لیکن تیزآهنگ منوازید. ");
INSERT INTO pesOPV_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","«و بنی هارون کهنه، کرناها را بنوازند. این برای شما در نسلهای شما فریضه ابدی باشد. ");
INSERT INTO pesOPV_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","وچون در زمین خود برای مقاتله با دشمنی که برشما تعدی می‌نمایند می‌روید، کرناها را تیزآهنگ بنوازید، پس به حضور یهوه خدای خودبیاد آورده خواهید شد، و از دشمنان خود نجات خواهید یافت. ");
INSERT INTO pesOPV_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","و در روز شادی خود و درعیدها و در اول ماه های خود کرناها را برقربانی های سوختنی و ذبایح سلامتی خودبنوازید، تا برای شما به حضور خدای شمایادگاری باشد. من یهوه خدای شما هستم.» ");
INSERT INTO pesOPV_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","و واقع شد در روز بیستم ماه دوم سال دوم که ابر از بالای خیمه شهادت برداشته شد، ");
INSERT INTO pesOPV_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","وبنی‌اسرائیل به مراحل خود از صحرای سینا کوچ کردند، و ابر در صحرای فاران ساکن شد، ");
INSERT INTO pesOPV_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","وایشان اول به فرمان خداوند به واسطه موسی کوچ کردند. ");
INSERT INTO pesOPV_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","و علم محله بنی یهودا، اول با افواج ایشان روانه شد، و بر فوج او نحشون بن عمیناداب بود. ");
INSERT INTO pesOPV_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","و بر فوج سبط بنی یساکار، نتنائیل بن صوغر. ");
INSERT INTO pesOPV_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","و بر فوج سبط بنی زبولون، الیاب بن حیلون. ");
INSERT INTO pesOPV_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","پس مسکن را پایین آوردند و بنی جرشون وبنی مراری که حاملان مسکن بودند، کوچ کردند. ");
INSERT INTO pesOPV_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","و علم محله روبین با افواج ایشان روانه شد، و بر فوج او الیصور بن شدیئور بود. ");
INSERT INTO pesOPV_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","و بر فوج سبط بنی شمعون، شلومیئیل بن صوریشدای. ");
INSERT INTO pesOPV_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","و بر فوج سبط بنی جاد، الیاساف بن دعوئیل. ");
INSERT INTO pesOPV_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","پس قهاتیان که حاملان قدس بودند، کوچ کردند و پیش از رسیدن ایشان، آنها مسکن را برپاداشتند. ");
INSERT INTO pesOPV_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","پس علم محله بنی افرایم با افواج ایشان روانه شد، و بر فوج او الیشمع بن عمیهود بود. ");
INSERT INTO pesOPV_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","و بر فوج سبط بنی منسی، جملیئیل بن فدهصور. ");
INSERT INTO pesOPV_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","و بر فوج سبط بنی بنیامین، ابیدان بن جدعونی. ");
INSERT INTO pesOPV_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","پس علم محله بنی دان که موخر همه محله‌ها بود با افواج ایشان روانه شد، و بر فوج اواخیعزر بن عمیشدای بود. ");
INSERT INTO pesOPV_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","و بر فوج سبطبنی اشیر، فجعیئیل بن عکران. ");
INSERT INTO pesOPV_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","و بر فوج سبطبنی نفتالی، اخیرع بن عینان. ");
INSERT INTO pesOPV_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","این بود مراحل بنی‌اسرائیل با افواج ایشان. پس کوچ کردند. ");
INSERT INTO pesOPV_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","و موسی به حوباب بن رعوئیل مدیانی که برادرزن موسی بود، گفت: «ما به مکانی که خداوند درباره آن گفته است که آن را به شماخواهم بخشید کوچ می‌کنیم، همراه ما بیا و بتواحسان خواهیم نمود، چونکه خداوند درباره اسرائیل نیکو گفته است.» ");
INSERT INTO pesOPV_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","او وی را گفت: «نمی آیم، بلکه به زمین و به خاندان خود خواهم رفت.» ");
INSERT INTO pesOPV_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","گفت: «ما را ترک مکن زیرا چونکه تو منازل ما را در صحرا می‌دانی، بجهت ما مثل چشم خواهی بود. ");
INSERT INTO pesOPV_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","و اگر همراه ما بیایی، هر احسانی که خداوند بر ما بنماید، همان را بر تو خواهیم نمود.» ");
INSERT INTO pesOPV_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","و از کوه خداوند سفر سه روزه کوچ کردند، و تابوت عهد خداوند سفر سه روزه پیش روی ایشان رفت تا آرامگاهی برای ایشان بطلبد. ");
INSERT INTO pesOPV_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","و ابر خداوند در روز بالای سر ایشان بود، و وقتی که از لشکرگاه روانه می‌شدند. ");
INSERT INTO pesOPV_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","و چون تابوت روانه می‌شد، موسی می‌گفت: «ای خداوند برخیز و دشمنانت پراکنده شوند و مبغضانت از حضور تو منهزم گردند.» ");
INSERT INTO pesOPV_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","و چون فرود می‌آمد، می‌گفت: «ای خداوند نزد هزاران هزار اسرائیل رجوع نما.» ");
INSERT INTO pesOPV_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","و قوم شکایت‌کنان در گوش خداوند بدگفتند، و خداوند این را شنیده، غضبش افروخته شد، و آتش خداوند در میان ایشان مشتعل شده، در اطراف اردو بسوخت. ");
INSERT INTO pesOPV_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","و قوم نزد موسی فریاد برآورده، موسی نزد خداوند دعانمود و آتش خاموش شد. ");
INSERT INTO pesOPV_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","پس آن مکان راتبعیره نام نهادند، زیرا که آتش خداوند در میان ایشان مشتعل شد. ");
INSERT INTO pesOPV_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","و گروه مختلف که در میان ایشان بودند، شهوت‌پرست شدند، و بنی‌اسرائیل باز گریان شده، گفتند: «کیست که ما را گوشت بخوراند! ");
INSERT INTO pesOPV_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","ماهی‌ای را که در مصر مفت می‌خوردیم و خیارو خربوزه و تره و پیاز و سیر را بیاد می‌آوریم. ");
INSERT INTO pesOPV_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","والان جان ما خشک شده، و چیزی نیست و غیر ازاین من، در نظر ما هیچ نمی آید!» ");
INSERT INTO pesOPV_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","و من مثل تخم گشنیز بود و شکل آن مثل مقل. ");
INSERT INTO pesOPV_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","و قوم گردش کرده، آن را جمع می‌نمودند، و آن را در آسیا خرد می‌کردند یا در هاون می‌کوبیدند، و در دیگها پخته، گرده‌ها از آن می‌ساختند. و طعم آن مثل طعم قرصهای روغنی بود. ");
INSERT INTO pesOPV_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","و چون شبنم در وقت شب بر اردو می بارید، من نیز بر آن می‌ریخت. ");
INSERT INTO pesOPV_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","و موسی قوم را شنید که با اهل خانه خودهر یک به در خیمه خویش می‌گریستند، و خشم خداوند به شدت افروخته شد، و در نظر موسی نیز قبیح آمد. ");
INSERT INTO pesOPV_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","و موسی به خداوند گفت: «چرابه بنده خود بدی نمودی؟ و چرا در نظر تو التفات نیافتم که بار جمیع این قوم را بر من نهادی؟ ");
INSERT INTO pesOPV_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","آیامن به تمامی این قوم حامله شده، یا من ایشان رازاییده‌ام که به من می‌گویی ایشان را در آغوش خود بردار، به زمینی که برای پدران ایشان قسم خوردی مثل لالا که طفل شیرخواره رابرمی دارد؟ ");
INSERT INTO pesOPV_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","گوشت از کجا پیدا کنم تا به همه این قوم بدهم؟ زیرا نزد من گریان شده، می‌گویندما را گوشت بده تا بخوریم. ");
INSERT INTO pesOPV_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","من به تنهایی نمی توانم تحمل تمامی این قوم را بنمایم زیرا برمن زیاد سنگین است. ");
INSERT INTO pesOPV_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","و اگر با من چنین رفتارنمایی، پس هرگاه در نظر تو التفات یافتم مراکشته، نابود ساز تا بدبختی خود را نبینم.» ");
INSERT INTO pesOPV_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","پس خداوند موسی را خطاب کرده، گفت: «هفتاد نفر از مشایخ بنی‌اسرائیل که ایشان رامی دانی که مشایخ قوم و سروران آنها می‌باشندنزد من جمع کن، و ایشان را به خیمه اجتماع بیاورتا در آنجا با تو بایستند. ");
INSERT INTO pesOPV_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","و من نازل شده، درآنجا با تو سخن خواهم گفت، و از روحی که برتوست گرفته، بر ایشان خواهم نهاد تا با تومتحمل بار این قوم باشند و تو به تنهایی متحمل آن نباشی. ");
INSERT INTO pesOPV_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","«و قوم را بگو که برای فردا خود را تقدیس نمایید تا گوشت بخورید، چونکه در گوش خداوند گریان شده، گفتید، کیست که ما را گوشت بخوراند! زیرا که در مصر ما را خوش می‌گذشت! پس خداوند شما را گوشت خواهد داد تا بخورید. ");
INSERT INTO pesOPV_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","نه یک روز و نه دو روز خواهیدخورد، و نه پنج روز و نه ده روز و نه بیست روز، ");
INSERT INTO pesOPV_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","بلکه یک ماه تمام تا از بینی شما بیرون آید ونزد شما مکروه شود، چونکه خداوند را که درمیان شماست رد نمودید، و به حضور وی گریان شده، گفتید، چرا از مصر بیرون آمدیم.» ");
INSERT INTO pesOPV_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","موسی گفت: «قومی که من در میان ایشانم، ششصد هزار پیاده‌اند و تو گفتی ایشان را گوشت خواهم داد تا یک ماه تمام بخورند. ");
INSERT INTO pesOPV_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","آیا گله‌ها ورمه‌ها برای ایشان کشته شود تا برای ایشان کفایت کند؟ یا همه ماهیان دریا برای ایشان جمع شوند تا برای ایشان کفایت کند؟» ");
INSERT INTO pesOPV_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","خداوند موسی را گفت: «آیا دست خداوندکوتاه شده است؟ الان خواهی دید که کلام من برتو واقع می‌شود یا نه.» ");
INSERT INTO pesOPV_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","پس موسی بیرون آمده، سخنان خداوند رابه قوم گفت، و هفتاد نفر از مشایخ قوم را جمع کرده، ایشان را به اطراف خیمه برپا داشت. ");
INSERT INTO pesOPV_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","وخداوند در ابر نازل شده، با وی تکلم نمود، و ازروحی که بر وی بود، گرفته، بر آن هفتاد نفرمشایخ نهاد و چون روح بر ایشان قرار گرفت، نبوت کردند، لیکن مزید نکردند. ");
INSERT INTO pesOPV_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","اما دو نفر در لشکرگاه باقی ماندند که نام یکی الداد بود و نام دیگری میداد، و روح بر ایشان نازل شد و نامهای ایشان در ثبت بود، لیکن نزدخیمه نیامده، در لشکرگاه نبوت کردند. ");
INSERT INTO pesOPV_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","آنگاه جوانی دوید و به موسی خبر داده، گفت: «الداد ومیداد در لشکرگاه نبوت می‌کنند.» ");
INSERT INTO pesOPV_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","و یوشع بن نون خادم موسی که ازبرگزیدگان او بود، در جواب گفت: «ای آقایم موسی ایشان را منع نما!» ");
INSERT INTO pesOPV_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","موسی وی را گفت: «آیا تو برای من حسد می بری؟ کاشکه تمامی قوم خداوند نبی می‌بودندو خداوند روح خود را بر ایشان افاضه می‌نمود!» ");
INSERT INTO pesOPV_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","پس موسی با مشایخ اسرائیل به لشکرگاه آمدند. ");
INSERT INTO pesOPV_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","و بادی از جانب خداوند وزیده، سلوی رااز دریا برآورد و آنها را به اطراف لشکرگاه تخمین یک روز راه به این طرف و یک روز راه به آن طرف پراکنده ساخت، و قریب به دو ذراع از روی زمین بالا بودند. ");
INSERT INTO pesOPV_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","و قوم برخاسته تمام آن روز و تمام آن شب و تمام روز دیگر سلوی را جمع کردند وآنکه کمتر یافته بود، ده حومر جمع کرده بود، وآنها را به اطراف اردو برای خود پهن کردند. ");
INSERT INTO pesOPV_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","وگوشت هنوز در میان دندان ایشان می‌بود پیش ازآنکه خاییده شود، که غضب خداوند بر ایشان افروخته شده خداوند قوم را به بلای بسیارسخت مبتلا ساخت. ");
INSERT INTO pesOPV_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","و آن مکان را قبروت هتاوه نامیدند، زیرا قومی را که شهوت‌پرست شدند، در آنجا دفن کردند. ");
INSERT INTO pesOPV_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","و قوم از قبروت هتاوه به حضیروت کوچ کرده، در حضیروت توقف نمودند. ");
INSERT INTO pesOPV_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","و مریم و هارون درباره زن حبشی که موسی گرفته بود، بر او شکایت آوردند، زیرا زن حبشی گرفته بود. ");
INSERT INTO pesOPV_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","و گفتند: «آیا خداوندبا موسی به تنهایی تکلم نموده است، مگر به ما نیزتکلم ننموده؟» و خداوند این را شنید. ");
INSERT INTO pesOPV_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","و موسی مرد بسیار حلیم بود، بیشتر از جمیع مردمانی که در روی زمینند. ");
INSERT INTO pesOPV_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","در ساعت خداوند به موسی و هارون و مریم گفت: «شما هر سه نزد خیمه اجتماع بیرون آیید.» و هر سه بیرون آمدند. ");
INSERT INTO pesOPV_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","و خداوند در ستون ابرنازل شده، به در خیمه ایستاد، و هارون و مریم راخوانده، ایشان هر دو بیرون آمدند. ");
INSERT INTO pesOPV_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","و او گفت: «الان سخنان مرا بشنوید: اگر در میان شما نبی‌ای باشد، من که یهوه هستم، خود را در رویا بر اوظاهر می‌کنم و در خواب به او سخن می‌گویم. ");
INSERT INTO pesOPV_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","اما بنده من موسی چنین نیست. او در تمامی خانه من امین است. ");
INSERT INTO pesOPV_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","با وی روبرو و آشکارا و نه در رمزها سخن می‌گویم، و شبیه خداوند رامعاینه می‌بیند، پس چرا نترسیدید که بر بنده من موسی شکایت آوردید؟» ");
INSERT INTO pesOPV_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","و غضب خداوند برایشان افروخته شده، برفت. ");
INSERT INTO pesOPV_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","و چون ابر از روی خیمه برخاست، اینک مریم مثل برف مبروص بود، و هارون بر مریم نگاه کرد و اینک مبروص بود. ");
INSERT INTO pesOPV_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","و هارون به موسی گفت: «وای‌ای آقایم بار این گناه را بر ما مگذار زیرا که حماقت کرده، گناه ورزیده‌ایم. ");
INSERT INTO pesOPV_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","و او مثل میته‌ای نباشد که چون از رحم مادرش بیرون آید، نصف بدنش پوسیده باشد.» ");
INSERT INTO pesOPV_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","پس موسی نزد خداوند استغاثه کرده، گفت: «ای خدا او را شفا بده!» ");
INSERT INTO pesOPV_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","خداوند به موسی گفت: «اگر پدرش به روی وی فقط آب دهان می‌انداخت، آیا هفت روز خجل نمی شد؟ پس هفت روز بیرون لشکرگاه محبوس بشود، وبعد از آن داخل شود.» ");
INSERT INTO pesOPV_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","پس مریم هفت روزبیرون لشکرگاه محبوس ماند، و تا داخل شدن مریم، قوم کوچ نکردند. ");
INSERT INTO pesOPV_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","و بعد از آن، قوم از حضیروت کوچ کرده، در صحرای فاران اردو زدند. ");
INSERT INTO pesOPV_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","و خداوند موسی را خطاب کرده، گفت: ");
INSERT INTO pesOPV_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","«کسان بفرست تا زمین کنعان را که به بنی‌اسرائیل دادم، جاسوسی کنند؛ یک نفر را ازهر سبط آبای ایشان که هرکدام در میان ایشان سرور باشد، بفرستید.» ");
INSERT INTO pesOPV_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","پس موسی به فرمان خداوند، ایشان را ازصحرای فاران فرستاد، و همه ایشان از روسای بنی‌اسرائیل بودند. ");
INSERT INTO pesOPV_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","و نامهای ایشان اینهاست: ازسبط روبین، شموع بن زکور. ");
INSERT INTO pesOPV_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","از سبط شمعون، شافاط بن حوری. ");
INSERT INTO pesOPV_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","از سبط یهودا، کالیب بن یفنه. ");
INSERT INTO pesOPV_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","از سبط یساکار، یجال بن یوسف. ");
INSERT INTO pesOPV_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","از سبطافرایم، هوشع بن نون. ");
INSERT INTO pesOPV_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","از سبط بنیامین، فلطی بن رافو. ");
INSERT INTO pesOPV_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","از سبط زبولون، جدیئیل بن سودی. ");
INSERT INTO pesOPV_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","ازسبط یوسف از سبط بنی منسی، جدی بن سوسی. ");
INSERT INTO pesOPV_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","از سبط دان، عمیئیل بن جملی. ");
INSERT INTO pesOPV_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","از سبطاشیر، ستور بن میکائیل. ");
INSERT INTO pesOPV_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","از سبط نفتالی، نحبی بن وفسی. ");
INSERT INTO pesOPV_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","از سبط جاد، جاوئیل بن ماکی. ");
INSERT INTO pesOPV_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","این است نامهای کسانی که موسی برای جاسوسی زمین فرستاد، و موسی هوشع بن نون رایهوشوع نام نهاد. ");
INSERT INTO pesOPV_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","و موسی ایشان را برای جاسوسی زمین کنعان فرستاده، به ایشان گفت: «از اینجا به جنوب رفته، به کوهستان برآیید. ");
INSERT INTO pesOPV_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","و زمین را ببینید که چگونه است و مردم را که در آن ساکنند که قوی‌اند یا ضعیف، قلیل‌اند یا کثیر. ");
INSERT INTO pesOPV_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","و زمینی که در آن ساکنند چگونه است، نیک یا بد؟ و در چه قسم شهرها ساکنند، در چادرها یا در قلعه‌ها؟ ");
INSERT INTO pesOPV_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","و چگونه است زمین، چرب یا لاغر؟ درخت دارد یا نه؟ پس قوی‌دل شده، از میوه زمین بیاورید.» و آن وقت موسم نوبر انگور بود. ");
INSERT INTO pesOPV_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","پس رفته زمین را از بیابان سین تا رحوب، نزد مدخل حمات جاسوسی کردند. ");
INSERT INTO pesOPV_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","و به جنوب رفته، به حبرون رسیدند، و اخیمان وشیشای و تلمای بنی عناق در آنجا بودند، اماحبرون هفت سال قبل از صوعن مصر بنا شده بود. ");
INSERT INTO pesOPV_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","و به وادی اشکول آمدند، و شاخه‌ای با یک خوشه انگور بریده، آن را بر چوب دستی، میان دونفر با قدری از انار و انجیر برداشته، آوردند. ");
INSERT INTO pesOPV_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","وآن مکان به‌سبب خوشه انگور که بنی‌اسرائیل ازآنجا بریده بودند، به وادی اشکول نامیده شد. ");
INSERT INTO pesOPV_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","و بعد از چهل روز، از جاسوسی زمین برگشتند. ");
INSERT INTO pesOPV_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","و روانه شده، نزد موسی و هارون وتمامی جماعت بنی‌اسرائیل به قادش در بیابان فاران رسیدند، و برای ایشان و برای تمامی جماعت خبر‌آوردند، و میوه زمین را به ایشان نشان دادند. ");
INSERT INTO pesOPV_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","و برای او حکایت کرده، گفتند: «به زمینی که ما را فرستادی رفتیم، و به درستی که به شیر و شهد جاریست، و میوه‌اش این است. ");
INSERT INTO pesOPV_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","لیکن مردمانی که در زمین ساکنند زورآورند، وشهرهایش حصاردار و بسیار عظیم، و بنی عناق رانیز در آنجا دیدیم. ");
INSERT INTO pesOPV_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","و عمالقه در زمین جنوب ساکنند، و حتیان و یبوسیان و اموریان درکوهستان سکونت دارند. و کنعانیان نزد دریا و برکناره اردن ساکنند.» ");
INSERT INTO pesOPV_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","و کالیب قوم را پیش موسی خاموش ساخته، گفت: «فی الفور برویم و آن را در تصرف آریم، زیرا که می‌توانیم بر آن غالب شویم.» ");
INSERT INTO pesOPV_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","اماآن کسانی که با وی رفته بودند، گفتند: «نمی توانیم با این قوم مقابله نماییم زیرا که ایشان از ماقوی ترند.» ");
INSERT INTO pesOPV_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","و درباره زمینی که آن را جاسوسی کرده بودند، خبر بد نزد بنی‌اسرائیل آورده، گفتند: «زمینی که برای جاسوسی آن از آن گذشتیم زمینی است که ساکنان خود را می‌خورد، و تمامی قومی که در آن دیدیم، مردان بلند قدبودند. ");
INSERT INTO pesOPV_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","و در آنجا جباران بنی عناق را دیدیم که اولاد جبارانند، و ما در نظر خود مثل ملخ بودیم وهمچنین در نظر ایشان می‌نمودیم.» ");
INSERT INTO pesOPV_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","و تمامی جماعت آواز خود را بلندکرده، فریاد نمودند. و قوم در آن شب می‌گریستند. ");
INSERT INTO pesOPV_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","و جمیع بنی‌اسرائیل بر موسی وهارون همهمه کردند، و تمامی جماعت به ایشان گفتند: «کاش که در زمین مصر می‌مردیم یا در این صحرا وفات می‌یافتیم! ");
INSERT INTO pesOPV_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","و چرا خداوند ما را به این زمین می‌آورد تا به دم شمشیر بیفتیم، و زنان واطفال ما به یغما برده شوند، آیا برگشتن به مصربرای ما بهتر نیست؟» ");
INSERT INTO pesOPV_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","و به یکدیگر گفتند: «سرداری برای خود مقرر کرده، به مصربرگردیم.» ");
INSERT INTO pesOPV_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","پس موسی و هارون به حضور تمامی گروه جماعت بنی‌اسرائیل به رو افتادند. ");
INSERT INTO pesOPV_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","و یوشع بن نون و کالیب بن یفنه که از جاسوسان زمین بودند، رخت خود را دریدند. ");
INSERT INTO pesOPV_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","و تمامی جماعت بنی‌اسرائیل را خطاب کرده، گفتند: «زمینی که برای جاسوسی آن از آن عبور نمودیم، زمین بسیار بسیار خوبیست. ");
INSERT INTO pesOPV_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","اگر خداوند از ما راضی است ما را به این زمین آورده، آن را به ما خواهدبخشید، زمینی که به شیر و شهد جاری است. ");
INSERT INTO pesOPV_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","زنهار از خداوند متمرد نشوید، و از اهل زمین ترسان مباشید، زیراکه ایشان خوراک ما هستند، سایه ایشان از ایشان گذشته است، و خداوند با ماست، از ایشان مترسید.» ");
INSERT INTO pesOPV_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","لیکن تمامی جماعت گفتند که باید ایشان را سنگسار کنند. آنگاه جلال خداوند در خیمه اجتماع بر تمامی بنی‌اسرائیل ظاهر شد. ");
INSERT INTO pesOPV_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","وخداوند به موسی گفت: «تا به کی این قوم مرااهانت نمایند؟ و تا به کی با وجود همه آیاتی که در میان ایشان نمودم، به من ایمان نیاورند؟ ");
INSERT INTO pesOPV_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","ایشان را به وبا مبتلا ساخته، هلاک می‌کنم و ازتو قومی بزرگ و عظیم تر از ایشان خواهم ساخت.» ");
INSERT INTO pesOPV_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","موسی به خداوند گفت: «آنگاه مصریان خواهند شنید، زیراکه این قوم را به قدرت خود ازمیان ایشان بیرون آوردی. ");
INSERT INTO pesOPV_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","و به ساکنان این زمین خبر خواهند داد و ایشان شنیده‌اند که تو‌ای خداوند، در میان این قوم هستی، زیراکه تو‌ای خداوند، معاینه دیده می‌شوی، و ابر تو بر ایشان قایم است، و تو پیش روی ایشان روز در ستون ابرو شب در ستون آتش می‌خرامی. ");
INSERT INTO pesOPV_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","پس اگر این قوم را مثل شخص واحد بکشی، طوایفی که آوازه تو را شنیده‌اند، خواهند گفت: ");
INSERT INTO pesOPV_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","چون که خداوند نتوانست این قوم را به زمینی که برای ایشان قسم خورده بود درآورد از این سبب ایشان را در صحرا کشت. ");
INSERT INTO pesOPV_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","پس الان قدرت خداوندعظیم بشود، چنانکه گفته بودی ");
INSERT INTO pesOPV_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","که یهوه دیرخشم و بسیار رحیم و آمرزنده گناه و عصیان است، لیکن مجرم را هرگز بی‌سزا نخواهدگذاشت بلکه عقوبت گناه پدران را بر پسران تاپشت سوم و چهارم می‌رساند. ");
INSERT INTO pesOPV_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","پس گناه این قوم را برحسب عظمت رحمت خود بیامرز، چنانکه این قوم را از مصر تا اینجا آمرزیده‌ای.» ");
INSERT INTO pesOPV_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","و خداوند گفت: «برحسب کلام توآمرزیدم. ");
INSERT INTO pesOPV_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","لیکن به حیات خودم قسم که تمامی زمین از جلال یهوه پر خواهد شد. ");
INSERT INTO pesOPV_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","چونکه جمیع مردانی که جلال و آیات مرا که در مصر وبیابان نمودم دیدند، مرا ده مرتبه امتحان کرده، آواز مرا نشنیدند. ");
INSERT INTO pesOPV_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","به درستی که ایشان زمینی راکه برای پدران ایشان قسم خوردم، نخواهند دید، و هرکه مرا اهانت کرده باشد، آن را نخواهد دید. ");
INSERT INTO pesOPV_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","لیکن بنده من کالیب چونکه روح دیگر داشت ومرا تمام اطاعت نمود، او را به زمینی که رفته بودداخل خواهم ساخت، و ذریت او وارث آن خواهند شد. ");
INSERT INTO pesOPV_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","و چونکه عمالیقیان و کنعانیان دروادی ساکنند، فردا رو گردانیده، از راه بحر قلزم به صحرا کوچ کنید.» ");
INSERT INTO pesOPV_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","و خداوند موسی و هارون را خطاب کرده، گفت: ");
INSERT INTO pesOPV_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","«تا به کی این جماعت شریر را که بر من همهمه می‌کنند متحمل بشوم؟ همهمه بنی‌اسرائیل را که بر من همهمه می‌کنند، شنیدم. ");
INSERT INTO pesOPV_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","به ایشان بگو خداوند می‌گوید: به حیات خودم قسم که چنانکه شما در گوش من گفتید، همچنان با شما عمل خواهم نمود. ");
INSERT INTO pesOPV_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","لاشه های شما دراین صحرا خواهد افتاد، و جمیع شمرده شدگان شما برحسب تمامی عدد شما، از بیست ساله وبالاتر که بر من همهمه کرده‌اید. ");
INSERT INTO pesOPV_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","شما به زمینی که درباره آن دست خود را بلند کردم که شما را درآن ساکن گردانم، هرگز داخل نخواهید شد، مگرکالیب بن یفنه و یوشع بن نون. ");
INSERT INTO pesOPV_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","اما اطفال شما که درباره آنها گفتید که به یغما برده خواهند شد، ایشان را داخل خواهم کرد و ایشان زمینی را که شما رد کردید، خواهند دانست. ");
INSERT INTO pesOPV_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","لیکن لاشه های شما در این صحرا خواهد افتاد. ");
INSERT INTO pesOPV_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","وپسران شما در این صحرا چهل سال آواره بوده، بار زناکاری شما را متحمل خواهند شد، تالاشه های شما در صحرا تلف شود. ");
INSERT INTO pesOPV_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","برحسب شماره روزهایی که زمین را جاسوسی می‌کردید، یعنی چهل روز. یک سال به عوض هر روز، بارگناهان خود را چهل سال متحمل خواهید شد، ومخالفت مرا خواهید دانست. ");
INSERT INTO pesOPV_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","من که یهوه هستم، گفتم که البته این را به تمامی این جماعت شریر که به ضد من جمع شده‌اند خواهم کرد، ودر این صحرا تلف شده، در اینجا خواهند مرد.» ");
INSERT INTO pesOPV_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","و اما آن کسانی که موسی برای جاسوسی زمین فرستاده بود. و ایشان چون برگشتند خبر بددرباره زمین آورده، تمام جماعت را از او گله‌مندساختند. ");
INSERT INTO pesOPV_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","آن کسانی که این خبر بد را درباره زمین آورده بودند، به حضور خداوند از وبامردند. ");
INSERT INTO pesOPV_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","اما یوشع بن نون و کالیب بن یفنه ازجمله آنانی که برای جاسوسی زمین رفته بودند، زنده ماندند. ");
INSERT INTO pesOPV_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","و چون موسی این سخنان را به جمیع بنی‌اسرائیل گفت، قوم بسیار گریستند. ");
INSERT INTO pesOPV_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","وبامدادان به زودی برخاسته، به‌سر کوه برآمده، گفتند: «اینک حاضریم و به مکانی که خداوندوعده داده است می‌رویم، زیرا گناه کرده‌ایم.» ");
INSERT INTO pesOPV_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","موسی گفت: «چرا از فرمان خداوند تجاوزمی نمایید؟ لیکن این کار به کام نخواهد شد! ");
INSERT INTO pesOPV_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","مروید زیرا خداوند در میان شما نیست، مبادااز پیش دشمنان خود منهزم شوید. ");
INSERT INTO pesOPV_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","زیراعمالیقیان و کنعانیان آنجا پیش روی شما هستند، پس به شمشیر خواهید افتاد، و چونکه از پیروی خداوند روگردانیده‌اید، لهذا خداوند با شمانخواهد بود.» ");
INSERT INTO pesOPV_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","لیکن ایشان از راه تکبر به‌سر کوه رفتند، اماتابوت عهد خداوند و موسی از میان لشکرگاه بیرون نرفتند. ");
INSERT INTO pesOPV_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","آنگاه عمالیقیان و کنعانیان که درآن کوهستان ساکن بودند فرودآمده، ایشان رازدند و تا حرما منهزم ساختند. ");
INSERT INTO pesOPV_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","و خداوند موسی را خطاب کرده، گفت: ");
INSERT INTO pesOPV_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","«بنی‌اسرائیل را خطاب کرده، به ایشان بگو: چون به زمین سکونت خود که من آن را به شما می‌دهم داخل شوید، ");
INSERT INTO pesOPV_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","و می‌خواهیدهدیه آتشین برای خداوند بگذرانید، چه قربانی سوختنی و چه ذبیحه وفای نذر، یا برای نافله یادر عیدهای خود، برای گذرانیدن هدیه خوشبوبجهت خداوند، خواه از رمه و خواه از گله، ");
INSERT INTO pesOPV_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","آنگاه کسی‌که هدیه خود را می‌گذراند، برای هدیه آردی یک عشر ایفه آرد نرم مخلوط شده بایک ربع هین روغن بجهت خداوند بگذراند. ");
INSERT INTO pesOPV_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","وبرای هدیه ریختنی یک ربع هین شراب با قربانی سوختنی یا برای ذبیحه بجهت هر بره حاضرکن. ");
INSERT INTO pesOPV_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","«یا بجهت قوچ برای هدیه آردی دو عشرایفه آرد نرم مخلوط شده با یک ثلث هین روغن حاضرکن. ");
INSERT INTO pesOPV_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","و بجهت هدیه ریختنی یک ثلث هین شراب برای خوشبویی بجهت خداوندحاضرکن. ");
INSERT INTO pesOPV_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","«و چون گاوی برای قربانی سوختنی یاذبیحه‌ای برای ادای نذر یا برای ذبیحه سلامتی بجهت خداوند حاضر می‌کنی، ");
INSERT INTO pesOPV_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","آنگاه بجهت هدیه آردی، سه عشر آرد نرم مخلوط شده بانصف هین روغن با گاو بگذراند. ");
INSERT INTO pesOPV_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","و برای هدیه ریختنی نصف هین شراب بگذران تا هدیه آتشین خوشبو برای خداوند بشود. ");
INSERT INTO pesOPV_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","«همچنین برای هر گاو و برای هر قوچ وبرای هر بره نرینه و هر بزغاله کرده شود. ");
INSERT INTO pesOPV_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","برحسب شماره‌ای که حاضر کنید بدین قسم برای هریک، موافق شماره آنها عمل نمایید. ");
INSERT INTO pesOPV_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","«هر متوطن چون هدیه آتشین خوشبو برای خداوند می‌گذراند، این اوامر را به اینطور بجابیاورد. ");
INSERT INTO pesOPV_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","و اگر غریبی که در میان شما ماواگزیند، هرکه در قرنهای شما در میان شما باشد، می‌خواهد هدیه آتشین خوشبو برای خداوندبگذراند، به نوعی که شما عمل می‌نمایید، او نیزعمل نماید. ");
INSERT INTO pesOPV_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","برای شما که اهل جماعت هستیدو برای غریبی که نزد شما ماوا گزیند یک فریضه باشد، فریضه ابدی در نسلهای شما؛ مثل شما به حضور خداوند مثل غریب است. ");
INSERT INTO pesOPV_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","یک قانون ویک حکم برای شما و برای غریبی که در میان شما ماوا گزیند، خواهد بود.» ");
INSERT INTO pesOPV_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","و خداوند موسی را خطاب کرده، گفت: ");
INSERT INTO pesOPV_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","«بنی‌اسرائیل را خطاب کرده، به ایشان بگو: چون به زمینی که من شما را در آن درمی آورم داخل شوید، ");
INSERT INTO pesOPV_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","و از محصول زمین بخورید، آنگاه هدیه افراشتنی برای خداوند بگذرانید. ");
INSERT INTO pesOPV_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","از خمیر اول خود گرده‌ای بجهت هدیه افراشتنی بگذرانید؛ مثل هدیه افراشتنی خرمن، همچنان آن را بگذرانید. ");
INSERT INTO pesOPV_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","از خمیر اول خود، هدیه افراشتنی در قرنهای خود برای خداوند بگذرانید. ");
INSERT INTO pesOPV_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","«و هرگاه سهو خطا کرده، جمیع این اوامررا که خداوند به موسی گفته است، بجا نیاورده باشید، ");
INSERT INTO pesOPV_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","یعنی هرچه خداوند به واسطه موسی شما را امر فرمود، از روزی که خداوند امر فرمودو از آن به بعد در قرنهای شما. ");
INSERT INTO pesOPV_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","پس اگر این کارسهو و بدون اطلاع جماعت کرده شد، آنگاه تمامی جماعت یک گاو جوان برای قربانی سوختنی و خوشبویی بجهت خداوند با هدیه آردی و هدیه ریختنی آن، موافق رسم بگذرانند، و یک بز نر بجهت قربانی گناه. ");
INSERT INTO pesOPV_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","و کاهن برای تمامی جماعت بنی‌اسرائیل کفاره نماید، و ایشان آمرزیده خواهندشد، زیراکه آن کار سهو شده است، و ایشان قربانی خود را بجهت هدیه آتشین خداوند و قربانی گناه خود را بجهت سهوخویش، به حضور خداوند گذرانیده‌اند. ");
INSERT INTO pesOPV_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","وتمامی جماعت بنی‌اسرائیل و غریبی که در میان ایشان ساکن باشد، آمرزیده خواهند شد، زیراکه به تمامی جماعت سهو شده بود. ");
INSERT INTO pesOPV_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","«و اگر یک نفر سهو خطا کرده باشد، آنگاه بز ماده‌یک ساله برای قربانی گناه بگذراند. ");
INSERT INTO pesOPV_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","وکاهن بجهت آن کسی‌که سهو کرده است چونکه خطای او از نادانستگی بود، به حضور خداوندکفاره کند تا بجهت وی کفاره بشود و آمرزیده خواهد شد. ");
INSERT INTO pesOPV_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","بجهت کسی‌که سهو خطا کند، خواه متوطنی از بنی‌اسرائیل و خواه غریبی که در میان ایشان ساکن باشد، یک قانون خواهدبود. ");
INSERT INTO pesOPV_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","«و اما کسی‌که به‌دست بلند عمل نماید، چه متوطن و چه غریب، او به خداوند کفر کرده باشد، پس آن شخص از میان قوم خود منقطع خواهد شد. ");
INSERT INTO pesOPV_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","چونکه کلام خداوند را حقیرشمرده، حکم او را شکسته است، آن کس البته منقطع شود و گناهش بر وی خواهد بود.» ");
INSERT INTO pesOPV_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","و چون بنی‌اسرائیل در صحرا بودند، کسی را یافتند که در روز سبت هیزم جمع می‌کرد. ");
INSERT INTO pesOPV_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","وکسانی که او را یافتند که هیزم جمع می‌کرد، او رانزد موسی و هارون و تمامی جماعت آوردند. ");
INSERT INTO pesOPV_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","و او را در حبس نگاه داشتند، زیراکه اعلام نشده بود که با وی چه باید کرد. ");
INSERT INTO pesOPV_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","و خداوند به موسی گفت: «این شخص البته کشته شود، تمامی جماعت او را بیرون از لشکرگاه با سنگها سنگسارکنند.» ");
INSERT INTO pesOPV_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","پس تمامی جماعت او را بیرون ازلشکرگاه آورده، او را سنگسار کردند و بمرد، چنانکه خداوند به موسی‌امر کرده بود. ");
INSERT INTO pesOPV_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","و خداوند موسی را خطاب کرده، گفت: ");
INSERT INTO pesOPV_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","«بنی‌اسرائیل را خطاب کرده، به ایشان بگو که: برای خود بر گوشه های رخت خویش در قرنهای خود صیصیت بسازند و رشته لاجوردی بر هرگوشه صیصیت بگذارند. ");
INSERT INTO pesOPV_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","و بجهت شماصیصیت خواهد بود تا برآن بنگرید و تمام اوامرخداوند را بیاد آورده، بجا آورید، و در‌پی دلها وچشمان خود که شما در‌پی آنها زنا می‌کنید، منحرف نشوید. ");
INSERT INTO pesOPV_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","تا تمامی اوامر مرا بیاد آورده، بجا آورید، و بجهت خدای خود مقدس باشید. ");
INSERT INTO pesOPV_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","من یهوه خدای شما هستم که شما را از زمین مصر بیرون آوردم تا خدای شما باشم. من یهوه خدای شما هستم.» ");
INSERT INTO pesOPV_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","و قورح بن یصهار بن قهات بن لاوی وداتان و ابیرام پسران الیاب و اون بن فالت پسران روبین (کسان ) گرفته، ");
INSERT INTO pesOPV_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","با بعضی ازبنی‌اسرائیل، یعنی دویست و پنجاه نفر ازسروران جماعت که برگزیدگان شورا و مردان معروف بودند، به حضور موسی برخاستند. ");
INSERT INTO pesOPV_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","و به مقابل موسی و هارون جمع شده، به ایشان گفتند: «شما از حد خود تجاوز می‌نمایید، زیرا تمامی جماعت هریک از ایشان مقدس‌اند، و خداوند درمیان ایشان است. پس چرا خویشتن را بر جماعت خداوند برمی افرازید؟» ");
INSERT INTO pesOPV_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","و چون موسی این راشنید به روی خود درافتاد. ");
INSERT INTO pesOPV_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","و قورح و تمامی جمعیت او را خطاب کرده، گفت: «بامدادان خداوند نشان خواهد داد که چه کس از آن وی وچه کس مقدس است، و او را نزد خود خواهدآورد، و هرکه را برای خود برگزیده است، او رانزد خود خواهد آورد. ");
INSERT INTO pesOPV_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","این را بکنید که مجمرهابرای خود بگیرید، ای قورح و تمامی جمعیت تو. ");
INSERT INTO pesOPV_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","و آتش در آنها گذارده، فردا به حضورخداوند بخور در آنها بریزید، و آن کس که خداوند برگزیده است، مقدس خواهد شد. ای پسران لاوی شما از حد خود تجاوز می‌نمایید!» ");
INSERT INTO pesOPV_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","و موسی به قورح گفت: «ای بنی لاوی بشنوید! ");
INSERT INTO pesOPV_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","آیا نزد شما کم است که خدای اسرائیل شما رااز جماعت اسرائیل ممتاز کرده است، تا شما رانزد خود بیاورد تا در مسکن خداوندخدمت نمایید، و به حضور جماعت برای خدمت ایشان بایستید؟ ");
INSERT INTO pesOPV_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","و تو را و جمیع برادرانت بنی لاوی رابا تو نزدیک آورد، و آیا کهانت را نیز می‌طلبید؟ ");
INSERT INTO pesOPV_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","از این جهت تو و تمامی جمعیت تو به ضدخداوند جمع شده‌اید، و اما هارون چیست که براو همهمه می‌کنید؟» ");
INSERT INTO pesOPV_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","و موسی فرستاد تا داتان و ابیرام پسران الیاب را بخواند، و ایشان گفتند: «نمی آییم! ");
INSERT INTO pesOPV_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","آیاکم است که ما را از زمینی که به شیر و شهد جاری است، بیرون آوردی تا ما را در صحرا نیز هلاک سازی که می‌خواهی خود را بر ما حکمران سازی؟ ");
INSERT INTO pesOPV_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","و ما را هم به زمینی که به شیر و شهدجاری است درنیاوردی و ملکیتی از مزرعه‌ها وتاکستانها به ما ندادی. آیا چشمان این مردمان رامی کنی؟ نخواهیم آمد!» ");
INSERT INTO pesOPV_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","و موسی بسیار خشمناک شده، به خداوندگفت: «هدیه ایشان را منظور منما، یک خر ازایشان نگرفتم، و به یکی از ایشان زیان نرساندم.» ");
INSERT INTO pesOPV_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","و موسی به قورح گفت: «تو با تمامی جمعیت خود فردا به حضور خداوند حاضر شوید، تو وایشان و هارون. ");
INSERT INTO pesOPV_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","و هر کس مجمر خود راگرفته، بخور بر آنها بگذارد و شما هر کس مجمرخود، یعنی دویست و پنجاه مجمر به حضورخداوند بیاورید، تو نیز و هارون هر یک مجمرخود را بیاورید.» ");
INSERT INTO pesOPV_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","پس هر کس مجمر خود راگرفته، و آتش در آنها نهاده، و بخور بر آنهاگذارده، نزد دروازه خیمه اجتماع، با موسی وهارون ایستادند. ");
INSERT INTO pesOPV_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","و قورح تمامی جماعت را به مقابل ایشان نزد در خیمه اجتماع جمع کرد، وجلال خداوند بر تمامی جماعت ظاهرشد. ");
INSERT INTO pesOPV_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","و خداوند موسی و هارون را خطاب کرده، گفت: ");
INSERT INTO pesOPV_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","«خود را از این جماعت دور کنید تاایشان را در لحظه‌ای هلاک کنم.» ");
INSERT INTO pesOPV_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","پس ایشان به روی در‌افتاده، گفتند: «ای خدا که خدای روحهای تمام بشر هستی، آیا یک نفر گناه ورزد وبر تمام جماعت غضبناک شوی؟» ");
INSERT INTO pesOPV_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","و خداوند موسی را خطاب کرده، گفت: ");
INSERT INTO pesOPV_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","«جماعت را خطاب کرده، بگو از اطراف مسکن قورح و داتان و ابیرام دور شوید.» ");
INSERT INTO pesOPV_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","پس موسی برخاسته، نزد داتان و ابیرام رفت و مشایخ اسرائیل در عقب وی رفتند. ");
INSERT INTO pesOPV_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","و جماعت راخطاب کرده، گفت: «از نزد خیمه های این مردمان شریر دور شوید، و چیزی را که از آن ایشان است لمس منمایید، مبادا در همه گناهان ایشان هلاک شوید.» ");
INSERT INTO pesOPV_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","پس از اطراف مسکن قورح و داتان وابیرام دور شدند، و داتان و ابیرام بیرون آمده، بازنان و پسران و اطفال خود به در خیمه های خودایستادند. ");
INSERT INTO pesOPV_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","و موسی گفت: «از این خواهیددانست که خداوند مرا فرستاده است تا همه این کارها را بکنم و به اراده من نبوده است. ");
INSERT INTO pesOPV_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","اگر این کسان مثل موت سایر بنی آدم بمیرند و اگر مثل وقایع جمیع بنی آدم بر ایشان واقع شود، خداوندمرا نفرستاده است. ");
INSERT INTO pesOPV_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","و اما اگر خداوند چیزتازه‌ای بنماید و زمین دهان خود را گشاده، ایشان را با جمیع مایملک ایشان ببلعد که به گور زنده فرود روند، آنگاه بدانید که این مردمان خداوند رااهانت نموده‌اند.» ");
INSERT INTO pesOPV_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","و چون از گفتن همه این سخنان فارغ شد، زمینی که زیر ایشان بود، شکافته شد. ");
INSERT INTO pesOPV_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","و زمین دهان خود را گشوده، ایشان را و خانه های ایشان و همه کسان را که تعلق به قورح داشتند، با تمامی اموال ایشان بلعید. ");
INSERT INTO pesOPV_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","و ایشان با هرچه به ایشان تعلق داشت، زنده به گور فرورفتند، و زمین برایشان به هم آمد که از میان جماعت هلاک شدند. ");
INSERT INTO pesOPV_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","و جمیع اسرائیلیان که به اطراف ایشان بودند، از نعره ایشان گریختند، زیرا گفتند مبادا زمین ما رانیز ببلعد. ");
INSERT INTO pesOPV_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","و آتش از حضور خداوند بدر‌آمده، دویست و پنجاه نفر را که بخور می‌گذرانیدند، سوزانید. ");
INSERT INTO pesOPV_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","و خداوند موسی را خطاب کرده، گفت: ");
INSERT INTO pesOPV_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","«به العازار بن هارون کاهن بگو که مجمرها را ازمیان آتش بردار، و آتش را به آن طرف بپاش زیراکه آنها مقدس است. ");
INSERT INTO pesOPV_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","یعنی مجمرهای این گناهکاران را به ضد جان ایشان و از آنها تختهای پهن برای پوشش مذبح بسازند، زیرا چونکه آنهارا به حضور خداوند گذرانیده‌اند مقدس شده است، تا برای بنی‌اسرائیل آیتی باشد.» ");
INSERT INTO pesOPV_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","پس العازار کاهن مجمرهای برنجین را که سوخته شدگان گذرانیده بودند گرفته، از آنها پوشش مذبح ساختند. ");
INSERT INTO pesOPV_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","تا برای بنی‌اسرائیل یادگارباشد تا هیچ غریبی که از اولاد هارون نباشدبجهت سوزانیدن بخور به حضور خداوند نزدیک نیاید، مبادا مثل قورح و جمعیتش بشود، چنانکه خداوند به واسطه موسی او را امر فرموده بود. ");
INSERT INTO pesOPV_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","و در فردای آن روز تمامی جماعت بنی‌اسرائیل بر موسی و هارون همهمه کرده، گفتند که شما قوم خداوند را کشتید. ");
INSERT INTO pesOPV_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","و چون جماعت بر موسی و هارون جمع شدند، به سوی خیمه اجتماع نگریستند، و اینک ابر آن راپوشانید و جلال خداوند ظاهر شد. ");
INSERT INTO pesOPV_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","و موسی وهارون پیش خیمه اجتماع آمدند. ");
INSERT INTO pesOPV_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","و خداوندموسی را خطاب کرده، گفت: ");
INSERT INTO pesOPV_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","«از میان این جماعت دور شوید تا ایشان را ناگهان هلاک سازم.» و ایشان به روی خود درافتادند. ");
INSERT INTO pesOPV_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","و موسی به هارون گفت: «مجمر خود راگرفته، آتش از روی مذبح در آن بگذار، و بخور برآن بریز، و به زودی به سوی جماعت رفته، برای ایشان کفاره کن، زیرا غضب از حضور خداوندبرآمده، و وبا شروع شده است.» ");
INSERT INTO pesOPV_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","پس هارون به نحوی که موسی گفته بود آن را گرفته، در میان جماعت دوید و اینک وبا در میان قوم شروع شده بود، پس بخور را بریخت و بجهت قوم کفاره نمود. ");
INSERT INTO pesOPV_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","و او در میان مردگان و زندگان ایستاد ووبا بازداشته شد. ");
INSERT INTO pesOPV_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","و عدد کسانی که از وبا مردندچهارده هزار و هفتصد بود، سوای آنانی که درحادثه قورح هلاک شدند. ");
INSERT INTO pesOPV_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","پس هارون نزدموسی به در خیمه اجتماع برگشت و وبا رفع شد. ");
INSERT INTO pesOPV_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","و خداوند موسی را خطاب کرده، گفت: ");
INSERT INTO pesOPV_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","«به بنی‌اسرائیل سخن بگو و از ایشان عصاها بگیر، یک عصا از هر خاندان آبا، از جمیع سروران ایشان دوازده عصا برحسب خاندان آبای ایشان. و نام هرکس را بر عصای او بنویس. ");
INSERT INTO pesOPV_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","واسم هارون را بر عصای لاوی بنویس، زیراکه برای هر سرور خاندان آبای ایشان یک عصاخواهد بود. ");
INSERT INTO pesOPV_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","و آنها را در خیمه اجتماع پیش شهادت، جایی که من با شما ملاقات می‌کنم بگذار. ");
INSERT INTO pesOPV_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","و شخصی را که من اختیار می‌کنم عصای او شکوفه خواهدآورد، پس همهمه بنی‌اسرائیل را که بر شما می‌کنند از خود ساکت خواهم نمود.» ");
INSERT INTO pesOPV_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","و موسی این را به بنی‌اسرائیل گفت، پس جمیع سروران ایشان او را عصاها دادند، یک عصابرای هر سرور، یعنی دوازده عصا برحسب خاندان آبای ایشان، و عصاهای هارون در میان عصاهای آنها بود. ");
INSERT INTO pesOPV_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","و موسی عصاها را به حضور خداوند در خیمه شهادت گذارد. ");
INSERT INTO pesOPV_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","و در فردای آن روز چون موسی به خیمه شهادت داخل شد، اینک عصای هارون که بجهت خاندان لاوی بودشکفته بود، و شکوفه آورده و گل داده، و بادام رسانیده بود. ");
INSERT INTO pesOPV_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","و موسی همه عصاها را از حضورخداوند نزد جمیع بنی‌اسرائیل بیرون آورده، هریک نگاه کرده، عصای خود را گرفتند. ");
INSERT INTO pesOPV_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","و خداوند به موسی گفت: «عصای هارون را پیش روی شهادت باز بگذار تا بجهت علامت برای ابنای تمرد نگاه داشته شود، و همهمه ایشان را از من رفع نمایی تا نمیرند.» ");
INSERT INTO pesOPV_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","پس موسی چنان کرد، و به نحوی که خداوند او را امر فرموده بود، عمل نمود. ");
INSERT INTO pesOPV_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","وبنی‌اسرائیل به موسی عرض کرده، گفتند: «اینک فانی و هلاک می‌شویم. جمیع ما هلاک شده‌ایم! ");
INSERT INTO pesOPV_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","هرکه نزدیک می‌آید که به مسکن خداوندنزدیک می‌آید می‌میرد. آیا تمام فانی شویم؟» ");
INSERT INTO pesOPV_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","و خداوند به هارون گفت: «تو و پسرانت و خاندان آبایت با تو، گناه مقدس رامتحمل شوید، و تو و پسرانت با تو، گناه کهانت خود را متحمل شوید. ");
INSERT INTO pesOPV_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","و هم برادران خود یعنی سبط لاوی راکه سبط آبای توباشند باخود نزدیک بیاور تا با تو متفق شده، تو را خدمت نمایند، و اماتو با پسرانت پیش خیمه شهادت باشید. ");
INSERT INTO pesOPV_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","وایشان ودیعت تو را و ودیعت تمامی مسکن رانگاه دارند، لیکن به اسباب قدس و به مذبح نزدیک نیایند مبادا بمیرند، ایشان و شما نیز. ");
INSERT INTO pesOPV_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","و ایشان باتو متفق شده، ودیعت خیمه اجتماع را با تمامی خدمت خیمه بجا آورند و غریبی به شما نزدیک نیاید. ");
INSERT INTO pesOPV_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","و ودیعت قدس و ودیعت مذبح را نگاه دارید تا غضب بر بنی‌اسرائیل دیگر مستولی نشود. ");
INSERT INTO pesOPV_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","و اما من اینک برادران شما لاویان را ازمیان بنی‌اسرائیل گرفتم، و برای شما پیشکش می‌باشند که به خداوند داده شده‌اند، تا خدمت خیمه اجتماع را بجا آورند. ");
INSERT INTO pesOPV_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","و اما تو با پسرانت، کهانت خود را بجهت هر کار مذبح و برای آنچه اندرون حجاب است نگاه دارید، و خدمت بکنید. کهانت را به شما دادم تا خدمت از راه بخشش باشد، و غریبی که نزدیک آید، کشته شود.» ");
INSERT INTO pesOPV_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","و خداوند به هارون گفت: «اینک من ودیعت هدایای افراشتنی خود را با همه‌چیزهای مقدس بنی‌اسرائیل به تو بخشیدم. آنها را به تو و پسرانت به‌سبب مسح شدن به فریضه ابدی دادم. ");
INSERT INTO pesOPV_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","ازقدس اقداس که از آتش نگاه داشته شود این از آن تو خواهد بود، هر هدیه ایشان یعنی هر هدیه آردی و هر قربانی گناه و هر قربانی جرم ایشان که نزد من بگذرانند، اینها برای تو و پسرانت قدس اقداس باشد. ");
INSERT INTO pesOPV_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","مثل قدس اقداس آنها را بخور. هر ذکور از آن بخورد، برای تو مقدس باشد. ");
INSERT INTO pesOPV_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","واین هم از آن تو باشد، هدیه افراشتنی از عطایای ایشان با هر هدیه جنبانیدنی بنی‌اسرائیل را به تو وبه پسرانت و دخترانت به فریضه ابدی دادم، هرکه در خانه تو طاهر باشد، از آن بخورد. ");
INSERT INTO pesOPV_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","تمامی بهترین روغن و تمامی بهترین حاصل مو و غله یعنی نوبرهای آنها را که به خداوند می‌دهند، به تو بخشیدم. ");
INSERT INTO pesOPV_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","و نوبرهای هرچه در زمین ایشان است که نزد خداوند می‌آورند از آن تو باشد، هرکه در خانه تو طاهر باشد، از آن بخورد. ");
INSERT INTO pesOPV_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","و هرچه در اسرائیل وقف بشود، از آن تو باشد. ");
INSERT INTO pesOPV_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","وهرچه رحم را گشاید از هر ذی جسدی که برای خداوند می‌گذرانند چه از انسان و چه از بهایم ازآن تو باشد، اما نخست زاده انسان را البته فدیه دهی، و نخست زاده بهایم ناپاک را فدیه‌ای بده. ");
INSERT INTO pesOPV_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","«و اما درباره فدیه آنها، آنها را از یک ماهه به حساب خود به پنج مثقال نقره، موافق مثقال قدس که بیست جیره باشد فدیه بده. ");
INSERT INTO pesOPV_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","ولی نخست زاده گاو یا نخست زاده گوسفند یانخست زاده بز را فدیه ندهی؛ آنها مقدسند، خون آنها را بر مذبح بپاش و پیه آنها را بجهت هدیه آتشین و عطر خوشبو برای خداوند بسوزان. ");
INSERT INTO pesOPV_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","وگوشت آنها مثل سینه جنبانیدنی، از آن تو باشد وران راست، از آن تو باشد. ");
INSERT INTO pesOPV_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","جمیع هدایای افراشتنی را از چیزهای مقدس که بنی‌اسرائیل برای خداوند می‌گذرانند به تو و پسرانت ودخترانت با تو به فریضه ابدی دادم، این به حضورخداوند برای تو و ذریت تو با تو عهد نمک تا به ابد خواهد بود.» ");
INSERT INTO pesOPV_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","و خداوند به هارون گفت: «تو در زمین ایشان هیچ ملک نخواهی یافت، و در میان ایشان برای تو نصیبی نخواهد بود، نصیب تو و ملک تودر میان بنی‌اسرائیل من هستم. ");
INSERT INTO pesOPV_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","«و به بنی لاوی‌اینک تمامی عشر اسرائیل را برای ملکیت دادم، به عوض خدمتی که می‌کنند یعنی خدمت خیمه اجتماع. ");
INSERT INTO pesOPV_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","و بعد ازاین بنی‌اسرائیل به خیمه اجتماع نزدیک نیایند، مبادا گناه را متحمل شده، بمیرند. ");
INSERT INTO pesOPV_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","اما لاویان خدمت خیمه اجتماع را بکنند و متحمل گناه ایشان بشوند، این در قرنهای شما فریضه‌ای ابدی خواهد بود، و ایشان در میان بنی‌اسرائیل ملک نخواهندیافت. ");
INSERT INTO pesOPV_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","زیراکه عشر بنی‌اسرائیل را که آن را نزد خداوند برای هدیه افراشتنی بگذرانندبه لاویان بجهت ملک بخشیدم، بنابراین به ایشان گفتم که در میان بنی‌اسرائیل ملک نخواهندیافت.» ");
INSERT INTO pesOPV_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","و خداوند موسی را خطاب کرده، گفت: ");
INSERT INTO pesOPV_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","«که لاویان را نیز خطاب کرده، به ایشان بگو: چون عشری را که از بنی‌اسرائیل به شما برای ملکیت دادم از ایشان بگیرید، آنگاه هدیه افراشتنی خداوند را از آن، یعنی عشری از عشربگذرانید. ");
INSERT INTO pesOPV_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","و هدیه افراشتنی شما برای شما، مثل غله خرمن و پری چرخشت حساب می‌شود. ");
INSERT INTO pesOPV_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","بدینطور شما نیز از همه عشرهایی که ازبنی‌اسرائیل می‌گیرید، هدیه افراشتنی برای خداوند بگذرانید، و از آنها هدیه افراشتنی خداوند را به هارون کاهن بدهید. ");
INSERT INTO pesOPV_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","از جمیع هدایای خود هر هدیه خداوند را از تمامی پیه آنها و از قسمت مقدس آنها بگذرانید. ");
INSERT INTO pesOPV_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","و ایشان را بگو هنگامی که پیه آنها را از آنها گذرانیده باشید، آنگاه برای لاویان مثل محصول خرمن وحاصل چرخشت حساب خواهد شد. ");
INSERT INTO pesOPV_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","و شماو خاندان شما آن را در هرجا بخورید زیراکه این مزد شما است، به عوض خدمتی که در خیمه اجتماع می‌کنید. ");
INSERT INTO pesOPV_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","و چون پیه آنها را از آنهاگذرانیده باشید، پس به‌سبب آنها متحمل گناه نخواهید بود، و چیزهای مقدس بنی‌اسرائیل راناپاک نکنید، مبادا بمیرند.» ");
INSERT INTO pesOPV_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","و خداوند موسی و هارون را خطاب کرده، گفت: ");
INSERT INTO pesOPV_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","«این است فریضه شریعتی که خداوند آن را امر فرموده، گفت: به بنی‌اسرائیل بگو که گاو سرخ پاک که در آن عیب نباشد و یوغ بر گردنش نیامده باشد، نزد توبیاورند. ");
INSERT INTO pesOPV_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","و آن را به العازار کاهن بدهید، و آن رابیرون از لشکرگاه برده، پیش روی وی کشته شود. ");
INSERT INTO pesOPV_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","و العازار کاهن به انگشت خود از خون آن بگیرد، و به سوی پیشگاه خیمه اجتماع آن خون را هفت مرتبه بپاشد. ");
INSERT INTO pesOPV_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","و گاو در نظر او سوخته شود، پوست و گوشت و خون با سرگین آن سوخته شود. ");
INSERT INTO pesOPV_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","و کاهن چوب سرو با زوفا و قرمز گرفته، آنها را در میان آتش گاو بیندازد. ");
INSERT INTO pesOPV_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","پس کاهن رخت خود را بشوید و بدن خود را به آب غسل دهد، و بعد از آن در لشکرگاه داخل شود و کاهن تا شام نجس باشد. ");
INSERT INTO pesOPV_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","و کسی‌که آن را سوزانید، رخت خود را به آب بشوید و بدن خود را به آب غسل دهد، و تا شام نجس باشد. ");
INSERT INTO pesOPV_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","«و شخص طاهر، خاکستر گاو را جمع کرده، بیرون از لشکرگاه در جای پاک بگذارد. و آن بجهت جماعت بنی‌اسرائیل برای آب تنزیه نگاه داشته شود. آن قربانی گناه است. ");
INSERT INTO pesOPV_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","و کسی‌که خاکستر گاو را جمع کند، رخت خود را بشوید وتا شام نجس باشد. این برای بنی‌اسرائیل و غریبی که در میان ایشان ساکن باشد، فریضه‌ای ابدی خواهد بود. ");
INSERT INTO pesOPV_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","«هرکه میته هر آدمی را لمس نماید هفت روز نجس باشد. ");
INSERT INTO pesOPV_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","و آن شخص در روز سوم خویشتن را به آن پاک کند، و در روز هفتم طاهرباشد، و اگر خویشتن را در روز سوم پاک نکرده باشد، در روز هفتم طاهر نخواهد بود. ");
INSERT INTO pesOPV_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","و هرکه میته هر آدمی را که مرده باشد لمس نموده، و خود را به آن پاک نکرده باشد، او مسکن خداوندرا ملوث کرده است. و آن شخص از اسرائیل منقطع شود، چونکه آب تنزیه بر او پاشیده نشده است، نجس خواهد بود، و نجاستش بر وی باقی است. ");
INSERT INTO pesOPV_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","«این است قانون برای کسی‌که در خیمه‌ای بمیرد، هرکه داخل آن خیمه شود و هرکه در آن خیمه باشد هفت روز نجس خواهد بود. ");
INSERT INTO pesOPV_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","و هرظرف گشاده که سرپوش برآن بسته نباشد، نجس خواهد بود. ");
INSERT INTO pesOPV_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","و هرکه در بیابان کشته شمشیر یامیته یا استخوان آدمی یا قبری را لمس نماید، هفت روز نجس باشد. ");
INSERT INTO pesOPV_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","و برای شخص نجس ازخاکستر آتش آن قربانی گناه بگیرند و آب روان برآن در ظرفی بریزند. ");
INSERT INTO pesOPV_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","و شخص طاهر زوفاگرفته، درآن آب فرو برد و بر خیمه بر همه اسباب و کسانی که در آن بودند و بر شخصی که استخوان یا مقتول یا میته یا قبر را لمس کرده باشد، بپاشد. ");
INSERT INTO pesOPV_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","و آن شخص طاهر، آب را بر آن شخص نجس در روز سوم و در روز هفتم بپاشد، و در روزهفتم خویشتن را تطهیر کرده، رخت خود رابشوید و به آب غسل کند و در شام طاهرخواهد بود. ");
INSERT INTO pesOPV_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","و اما کسی‌که نجس شده، خویشتن را تطهیر نکند. آن شخص از میان جماعت منقطع شود، چونکه مقدس خداوند راملوث نموده، و آب تنزیه بر او پاشیده نشده است. او نجس است. ");
INSERT INTO pesOPV_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","«و برای ایشان فریضه ابدی خواهد بود. وکسی‌که آب تنزیه را بپاشد، رخت خود را بشویدو کسی‌که آب تنزیه را لمس کند تا شام نجس باشد. ");
INSERT INTO pesOPV_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","و هر چیزی را که شخص نجس لمس نماید نجس خواهد بود، و هر کسی‌که آن را لمس نماید تا شام نجس خواهد بود.» ");
INSERT INTO pesOPV_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","و تمامی جماعت بنی‌اسرائیل در ماه اول به بیابان صین رسیدند، و قوم درقادش اقامت کردند، و مریم در آنجا وفات یافته، دفن شد. ");
INSERT INTO pesOPV_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","و برای جماعت آب نبود. پس بر موسی وهارون جمع شدند. ");
INSERT INTO pesOPV_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","و قوم با موسی منازعت کرده، گفتند: «کاش که می‌مردیم وقتی که برادران ما در حضور خداوند مردند! ");
INSERT INTO pesOPV_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","و چرا جماعت خداوند را به این بیابان آوردید تا ما و بهایم ما، دراینجا بمیریم؟ ");
INSERT INTO pesOPV_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","و ما را از مصر چرا برآوردید تا مارا به این‌جای بد بیاورید که جای زراعت و انجیرو مو و انار نیست؟ و آب هم نیست که بنوشیم!» ");
INSERT INTO pesOPV_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","و موسی و هارون از حضور جماعت نزد درخیمه اجتماع آمدند، و به روی خود درافتادند، وجلال خداوند بر ایشان ظاهر شد. ");
INSERT INTO pesOPV_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","و خداوندموسی را خطاب کرده، گفت: ");
INSERT INTO pesOPV_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","«عصا را بگیر و توو برادرت هارون جماعت را جمع کرده، در نظرایشان به این صخره بگویید که آب خود را بدهد، پس آب را برای ایشان از صخره بیرون آورده، جماعت و بهایم ایشان را خواهی نوشانید.» ");
INSERT INTO pesOPV_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","پس موسی عصا را از حضور خداوند، چنانکه او را فرموده بود، گرفت. ");
INSERT INTO pesOPV_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","و موسی وهارون، جماعت را پیش صخره جمع کردند، و به ایشان گفت: «ای مفسدان بشنوید، آیا از این صخره آب برای شما بیرون آوریم؟» ");
INSERT INTO pesOPV_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","و موسی دست خود را بلند کرده، صخره را دو مرتبه باعصای خود زد و آب بسیار بیرون آمد که جماعت و بهایم ایشان نوشیدند. ");
INSERT INTO pesOPV_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","و خداوند به موسی و هارون گفت: «چونکه مرا تصدیق ننمودید تا مرا در نظر بنی‌اسرائیل تقدیس نمایید، لهذا شما این جماعت را به زمینی که به ایشان داده‌ام داخل نخواهید ساخت.» ");
INSERT INTO pesOPV_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","این است آب مریبه‌جایی که بنی‌اسرائیل با خداوندمخاصمه کردند، و او خود را در میان ایشان تقدیس نمود. ");
INSERT INTO pesOPV_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","و موسی، رسولان از قادش نزد ملک ادوم فرستاد که «برادر تو اسرائیل چنین می‌گوید: که تمامی مشقتی را که بر ما واقع شده است، تومی دانی. ");
INSERT INTO pesOPV_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","که پدران ما به مصر فرود آمدند ومدت مدیدی در مصر ساکن می‌بودیم، و مصریان با ما و با پدران ما، بد سلوکی نمودند. ");
INSERT INTO pesOPV_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","و چون نزد خداوند فریاد برآوردیم، او آواز ما را شنیده، فرشته‌ای فرستاد و ما را از مصر بیرون آورد. واینک ما در قادش هستیم، شهری که در آخرحدود توست. ");
INSERT INTO pesOPV_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","تمنا اینکه از زمین تو بگذریم، از مزرعه و تاکستان نخواهیم گذشت، و آب ازچاهها نخواهیم نوشید، بلکه از شاهراه‌ها خواهیم رفت، و تا از حدود تو نگذشته باشیم، به طرف راست یا چپ انحراف نخواهیم کرد.» ");
INSERT INTO pesOPV_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","ادوم وی را گفت: «از من نخواهی گذشت والا به مقابله تو با شمشیر بیرون خواهم آمد.» ");
INSERT INTO pesOPV_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","بنی‌اسرائیل در جواب وی گفتند: «از راههای عام خواهیم رفت و هرگاه من و مواشیم از آب توبنوشیم قیمت آن را خواهم داد، فقط بر پایهای خود می‌گذرم و بس.» ");
INSERT INTO pesOPV_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","گفت: «نخواهی گذشت.» و ادوم با خلق بسیار و دست قوی به مقابله ایشان بیرون آمد. ");
INSERT INTO pesOPV_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","بدینطور ادوم راضی نشد که اسرائیل را از حدود خود راه دهد، پس اسرائیل از طرف او رو گردانید. ");
INSERT INTO pesOPV_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","پس تمامی جماعت بنی‌اسرائیل از قادش کوچ کرده، به کوه هور رسیدند. ");
INSERT INTO pesOPV_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","و خداوندموسی و هارون را در کوه هور نزد سرحد زمین ادوم خطاب کرده، گفت: ");
INSERT INTO pesOPV_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","«هارون به قوم خودخواهد پیوست، زیرا چونکه شما نزد آب مریبه از قول من عصیان ورزیدید، از این جهت او به زمینی که به بنی‌اسرائیل دادم، داخل نخواهد شد. ");
INSERT INTO pesOPV_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","پس هارون و پسرش العازار را برداشته، ایشان را به فراز کوه هور بیاور. ");
INSERT INTO pesOPV_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","و لباس هارون رابیرون کرده، بر پسرش العازار بپوشان، و هارون درآنجا وفات یافته، به قوم خود خواهد پیوست.» ");
INSERT INTO pesOPV_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","پس موسی به طوری که خداوند او را امرفرموده بود، عمل نموده، ایشان درنظر تمامی جماعت به فراز کوه هور برآمدند. ");
INSERT INTO pesOPV_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","و موسی لباس هارون را بیرون کرده، به پسرش العازارپوشانید. و هارون در آنجا بر قله کوه وفات یافت، و موسی و العازار از کوه فرود آمدند. ");
INSERT INTO pesOPV_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","و چون تمامی جماعت دیدند که هارون مرد، جمیع خاندان اسرائیل برای هارون سی روز ماتم گرفتند. ");
INSERT INTO pesOPV_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","و چون کنعانی که ملک عراد و درجنوب ساکن بود، شنید که اسرائیل ازراه اتاریم می‌آید، با اسرائیل جنگ کرد و بعضی از ایشان را به اسیری برد. ");
INSERT INTO pesOPV_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","و اسرائیل برای خداوند نذر کرده گفت: «اگر این قوم را به‌دست من تسلیم نمایی، شهرهای ایشان را بالکل هلاک خواهم ساخت.» ");
INSERT INTO pesOPV_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","پس خداوند دعای اسرائیل را مستجاب فرموده، کنعانیان را تسلیم کرد، و ایشان و شهرهای ایشان را بالکل هلاک ساختند، و آن مکان حرمه نامیده شد. ");
INSERT INTO pesOPV_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","و از کوه هور به راه بحر قلزم کوچ کردند تازمین ادوم را دور زنند، و دل قوم به‌سبب راه، تنگ شد. ");
INSERT INTO pesOPV_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","و قوم بر خدا و موسی شکایت آورده، گفتند: «که ما را از مصر چرا برآوردید تا در بیابان بمیریم؟ زیرا که نان نیست و آب هم نیست! و دل ما از این خوراک سخیف کراهت دارد!» ");
INSERT INTO pesOPV_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","پس خداوند، مارهای آتشی در میان قوم فرستاده، قوم را گزیدند، و گروهی کثیر ازاسرائیل مردند. ");
INSERT INTO pesOPV_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","و قوم نزد موسی آمده، گفتند: «گناه کرده‌ایم زیرا که بر خداوند و بر تو شکایت آورده‌ایم، پس نزد خداوند دعا کن تا مارها را از مادور کند.» و موسی بجهت قوم استغاثه نمود. ");
INSERT INTO pesOPV_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","وخداوند به موسی گفت: «مار آتشینی بساز و آن رابر نیزه‌ای بردار، و هر گزیده شده‌ای که بر آن نظرکند، خواهد زیست.» ");
INSERT INTO pesOPV_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","پس موسی مار برنجینی ساخته، و بر سر نیزه‌ای بلند کرد، و چنین شد که اگر مار کسی را گزیده بود، به مجرد نگاه کردن برآن مار برنجین، زنده می‌شد. ");
INSERT INTO pesOPV_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","و بنی‌اسرائیل کوچ کرده، در اوبوت اردوزدند. ");
INSERT INTO pesOPV_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","و از اوبوت کوچ کرده، در عیی عباریم، در بیابانی که در مقابل موآب به طرف طلوع آفتاب است، اردو زدند. ");
INSERT INTO pesOPV_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","و از آنجا کوچ کرده، به وادی زارد اردو زدند. ");
INSERT INTO pesOPV_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","و از آنجا کوچ کرده، به آن طرف ارنون که در بیابان خارج از حدوداموریان می‌باشد اردو زدند، زیرا که ارنون حدموآب در میان موآب و اموریان است. ");
INSERT INTO pesOPV_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","از این جهت، در کتاب جنگهای خداوند گفته می‌شود: «واهیب در سوفه و وادیهای ارنون، ");
INSERT INTO pesOPV_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","و رودخانه وادیهایی که بسوی مسکن عار متوجه است، و برحدود موآب تکیه می‌زند.» ");
INSERT INTO pesOPV_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","و از آنجا به بئر کوچ کردند. این آن چاهی است که خداوند درباره‌اش به موسی گفت: «قوم را جمع کن تا به ایشان آب دهم.» ");
INSERT INTO pesOPV_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","آنگاه اسرائیل این سرود را سراییدند: «ای چاه بجوش آی، شما برایش سرودبخوانید، ");
INSERT INTO pesOPV_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","«چاهی که سروران حفره زدند، و نجبای قوم آن را کندند. به صولجان حاکم، به عصاهای خود آن را کندند.» ");
INSERT INTO pesOPV_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","و ازمتانه به نحلیئیل و از نحلیئیل به باموت. ");
INSERT INTO pesOPV_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","و ازباموت به دره‌ای که در صحرای موآب نزد قله فسجه که به سوی بیابان متوجه است. ");
INSERT INTO pesOPV_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","و اسرائیل، رسولان نزد سیحون ملک اموریان فرستاده، گفت: ");
INSERT INTO pesOPV_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","«مرا اجازت بده تا اززمین تو بگذرم، به سوی مزرعه یا تاکستان انحراف نخواهیم ورزید، و از آب چاه نخواهیم نوشید، و به شاهراه خواهیم رفت تا از سرحد توبگذریم.» ");
INSERT INTO pesOPV_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","اما سیحون، اسرائیل را از حدودخود راه نداد. و سیحون تمامی قوم خود را جمع نموده، به مقابله اسرائیل به بیابان بیرون آمد. و چون به یاهص رسید با اسرائیل جنگ کرد. ");
INSERT INTO pesOPV_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","واسرائیل او را به دم شمشیر زده، زمینش را ازارنون تا یبوق و تا حد بنی عمون به تصرف آورد، زیرا که حد بنی عمون مستحکم بود. ");
INSERT INTO pesOPV_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","واسرائیل تمامی آن شهرها را گرفت و اسرائیل درتمامی شهرهای اموریان در حشبون و در تمامی دهاتش ساکن شد. ");
INSERT INTO pesOPV_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","زیرا که حشبون، شهرسیحون، ملک اموریان بود، و او با ملک سابق موآب جنگ کرده، تمامی زمینش را تا ارنون ازدستش گرفته بود. ");
INSERT INTO pesOPV_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","بنابراین مثل آورندگان می‌گویند: «به حشبون بیایید تا شهر سیحون بنا کرده، و استوارشود. ");
INSERT INTO pesOPV_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","زیرا آتشی از حشبون برآمد و شعله‌ای از قریه سیحون. و عار، موآب را سوزانید وصاحبان بلندیهای ارنون را. ");
INSERT INTO pesOPV_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","وای بر تو‌ای موآب! ای قوم کموش، هلاک شدید! پسران خود را مثل گریزندگان تسلیم نمود، و دختران خود را به سیحون ملک اموریان به اسیری داد. ");
INSERT INTO pesOPV_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","به ایشان تیر انداختیم. حشبون تا به دیبون هلاک شد. و آن را تا نوفح که نزد میدباست ویران ساختیم.» ");
INSERT INTO pesOPV_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","و اسرائیل در زمین اموریان اقامت کردند. ");
INSERT INTO pesOPV_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","و موسی برای جاسوسی یعزیر فرستاد ودهات آن را گرفته، اموریان را که در آنجا بودند، بیرون کردند. ");
INSERT INTO pesOPV_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","پس برگشته، از راه باشان برآمدند. و عوج ملک باشان با تمامی قوم خود به مقابله ایشان ازبرای جنگ به ادرعی بیرون آمد. ");
INSERT INTO pesOPV_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","و خداوند به موسی گفت: «از او مترس زیرا که او را با تمامی قومش و زمینش به‌دست تو تسلیم نموده‌ام، و به نحوی که با سیحون ملک اموریان که در حشبون ساکن بود، عمل نمودی، با او نیز عمل خواهی نمود.» ");
INSERT INTO pesOPV_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","پس او را با پسرانش و تمامی قومش زدند، به حدی که کسی از برایش باقی نماند وزمینش را به تصرف آوردند. ");
INSERT INTO pesOPV_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","و بنی‌اسرائیل کوچ کرده، در عربات موآب به آنطرف اردن، در مقابل اریحااردو زدند. ");
INSERT INTO pesOPV_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","و چون بالاق بن صفور هر‌چه اسرائیل به اموریان کرده بودند دید، ");
INSERT INTO pesOPV_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","موآب ازقوم بسیار ترسید، زیرا که کثیر بودند. و موآب ازبنی‌اسرائیل مضطرب گردیدند. ");
INSERT INTO pesOPV_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","و موآب به مشایخ مدیان گفتند: «الان این گروه هر‌چه به اطراف ما هست خواهند لیسید، به نوعی که گاوسبزه صحرا را می‌لیسد.» و در آن زمان بالاق بن صفور، ملک موآب بود. ");
INSERT INTO pesOPV_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","پس رسولان به فتور که برکنار وادی است، نزد بلعام بن بعور، به زمین پسران قوم او فرستاد تااو را طلبیده، بگویند: «اینک قومی از مصر بیرون آمده‌اند و هان روی زمین را مستور می‌سازند، ودر مقابل من مقیم می‌باشند. ");
INSERT INTO pesOPV_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","پس الان بیا و این قوم را برای من لعنت کن، زیرا که از من قوی ترند، شاید توانایی یابم تا بر ایشان غالب آییم، و ایشان را از زمین خود بیرون کنم، زیرا می‌دانم هر‌که راتو برکت دهی مبارک است و هر‌که را لعنت نمایی، ملعون است.» ");
INSERT INTO pesOPV_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","پس مشایخ موآب و مشایخ مدیان، مزد فالگیری را به‌دست گرفته، روانه شدند، و نزدبلعام رسیده، سخنان بالاق را به وی گفتند. ");
INSERT INTO pesOPV_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","او به ایشان گفت: «این شب را در اینجا بمانید، تاچنانکه خداوند به من گوید، به شما باز گویم.» وسروران موآب نزد بلعام ماندند. ");
INSERT INTO pesOPV_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","و خدا نزد بلعام آمده، گفت: «این کسانی که نزد تو هستند، کیستند؟» ");
INSERT INTO pesOPV_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","بلعام به خدا گفت: «بالاق بن صفورملک موآب نزد من فرستاده است، ");
INSERT INTO pesOPV_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","که اینک این قومی که از مصر بیرون آمده‌اند روی زمین راپوشانیده‌اند. الان آمده، ایشان را برای من لعنت کن شاید که توانایی یابم تا با ایشان جنگ نموده، ایشان را دور سازم.» ");
INSERT INTO pesOPV_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","خدا به بلعام گفت: «باایشان مرو و قوم را لعنت مکن زیرا مبارک هستند.» ");
INSERT INTO pesOPV_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","پس بلعام بامدادان برخاسته، به‌سروران بالاق گفت: «به زمین خود بروید، زیراخداوند مرا اجازت نمی دهد که با شما بیایم.» ");
INSERT INTO pesOPV_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","و سروران موآب برخاسته، نزد بالاق برگشته، گفتند که «بلعام از آمدن با ما انکار نمود.» ");
INSERT INTO pesOPV_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","و بالاق بار دیگر سروران زیاده و بزرگتر ازآنان فرستاد. ");
INSERT INTO pesOPV_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","و ایشان نزد بلعام آمده، و وی راگفتند: «بالاق بن صفور چنین می‌گوید: تمنا اینکه از آمدن نزد من انکار نکنی. ");
INSERT INTO pesOPV_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","زیرا که البته تو رابسیار تکریم خواهم نمود، و هر‌آنچه به من بگویی بجا خواهم آورد، پس بیا و این قوم را برای من لعنت کن.» ");
INSERT INTO pesOPV_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","بلعام در جواب نوکران بالاق گفت: اگر بالاق خانه خود را پر از نقره و طلا به من بخشد، نمی توانم از فرمان یهوه خدای خودتجاوز نموده، کم یا زیاد به عمل آورم. ");
INSERT INTO pesOPV_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","پس الان شما نیز امشب در اینجا بمانید تا بدانم که خداوند به من دیگر‌چه خواهد گفت.» ");
INSERT INTO pesOPV_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","و خدادر شب نزد بلعام آمده، وی را گفت: «اگر این مردمان برای طلبیدن تو بیایند برخاسته، همراه ایشان برو، اما کلامی را که من به تو گویم به همان عمل نما.» ");
INSERT INTO pesOPV_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","پس بلعام بامدادان برخاسته، الاغ خود را بیاراست و همراه سروران موآب روانه شد. ");
INSERT INTO pesOPV_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","و غضب خدا به‌سبب رفتن او افروخته شده، فرشته خداوند در راه به مقاومت وی ایستاد، و او بر الاغ خود سوار بود، و دو نوکرش همراهش بودند. ");
INSERT INTO pesOPV_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","و الاغ، فرشته خداوند را باشمشیر برهنه به‌دستش، بر سر راه ایستاده دید. پس الاغ از راه به یک سو شده، به مزرعه‌ای رفت و بلعام الاغ را زد تا او را به راه برگرداند. ");
INSERT INTO pesOPV_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","پس فرشته خداوند در جای گود در میان تاکستان بایستاد، و به هر دو طرفش دیوار بود. ");
INSERT INTO pesOPV_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","و الاغ فرشته خداوند را دیده، خود را به دیوار چسبانید، و پای بلعام را به دیوار فشرد. پس او را بار دیگرزد. ");
INSERT INTO pesOPV_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","و فرشته خداوند پیش رفته، در مکانی تنگ بایستاد، که جایی بجهت برگشتن به طرف راست یا چپ نبود. ");
INSERT INTO pesOPV_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","و چون الاغ، فرشته خداوند رادید، در زیر بلعام خوابید. و خشم بلعام افروخته شده، الاغ را به عصای خود زد. ");
INSERT INTO pesOPV_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","آنگاه خداونددهان الاغ را باز کرد که بلعام را گفت: به تو چه کرده‌ام که مرا این سه مرتبه زدی. ");
INSERT INTO pesOPV_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","بلعام به الاغ گفت: «از این جهت که تو مرا استهزا نمودی! کاش که شمشیر در دست من می‌بود که الان تو رامی کشتم.» ");
INSERT INTO pesOPV_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","الاغ به بلعام گفت: «آیا من الاغ تونیستم که از وقتی که مال تو شده‌ام تا امروز بر من سوار شده‌ای، آیا هرگز عادت می‌داشتم که به اینطور با تو رفتار نمایم؟» او گفت: «نی» ");
INSERT INTO pesOPV_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","و خداوند چشمان بلعام را باز کرد تا فرشته خداوند را دید که با شمشیر برهنه در دستش، به‌سر راه ایستاده است پس خم شده، به روی درافتاد. ");
INSERT INTO pesOPV_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","و فرشته خداوند وی را گفت: «الاغ خود را این سه مرتبه چرا زدی؟ اینک من به مقاومت تو بیرون آمدم، زیرا که این سفر تو در نظرمن از روی تمرد است. ");
INSERT INTO pesOPV_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","و الاغ مرا دیده، این سه مرتبه از من کناره جست، و اگر از من کناره نمی جست یقین الان تو را می‌کشتم و او را زنده نگاه می‌داشتم.» ");
INSERT INTO pesOPV_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","بلعام به فرشته خداوند گفت: «گناه کردم زیرا ندانستم که تو به مقابل من در راه ایستاده‌ای. پس الان اگر در نظر تو ناپسند است برمی گردم.» ");
INSERT INTO pesOPV_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","فرشته خداوند به بلعام گفت: «همراه این اشخاص برو لیکن سخنی را که من به تو گویم، همان را فقط بگو». پس بلعام همراه سروران بالاق رفت. ");
INSERT INTO pesOPV_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","و چون بالاق شنید که بلعام آمده است، به استقبال وی تا شهر موآب که برحد ارنون و براقصای حدود وی بود، بیرون آمد. ");
INSERT INTO pesOPV_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","و بالاق به بلعام گفت: «آیا برای طلبیدن تو نزد تو نفرستادم، پس چرا نزد من نیامدی، آیا حقیقت قادر نیستم که تو را به عزت رسانم؟» ");
INSERT INTO pesOPV_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","بلعام به بالاق گفت: «اینک نزد تو آمده‌ام، آیا الان هیچ قدرتی دارم که چیزی بگویم؟ آنچه خدا به دهانم می‌گذارد همان را خواهم گفت.» ");
INSERT INTO pesOPV_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","پس بلعام همرا بالاق رفته، به قریت حصوت رسیدند. ");
INSERT INTO pesOPV_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","و بالاق گاوان وگوسفندان ذبح کرده، نزد بلعام و سرورانی که باوی بودند، فرستاد. ");
INSERT INTO pesOPV_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","و بامدادان بالاق بلعام رابرداشته، او را به بلندیهای بعل آورد، تا از آنجااقصای قوم خود را ملاحظه کند. ");
INSERT INTO pesOPV_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","و بلعام به بالاق گفت: «در اینجا برای من هفت مذبح بساز، و هفت گاو و هفت قوچ در اینجا برایم حاضر کن.» ");
INSERT INTO pesOPV_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","و بالاق به نحوی که بلعام گفته بود به عمل آورد، و بالاق و بلعام، گاوی و قوچی بر هر مذبح گذرانیدند. ");
INSERT INTO pesOPV_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","و بلعام به بالاق گفت: «نزد قربانی سوختنی خود بایست، تا من بروم؛ شاید خداوند برای ملاقات من بیاید، وهر‌چه او به من نشان دهد آن را به تو باز خواهم گفت.» پس به تلی برآمد. ");
INSERT INTO pesOPV_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","و خدا بلعام را ملاقات کرد، و او وی را گفت: «هفت مذبح برپا داشتم و گاوی و قوچی بر هرمذبح قربانی کردم.» ");
INSERT INTO pesOPV_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","خداوند سخنی به دهان بلعام گذاشته، گفت: «نزد بالاق برگشته چنین بگو.» ");
INSERT INTO pesOPV_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","پس نزد او برگشت، و اینک او با جمیع سروران موآب نزد قربانی سوختنی خود ایستاده بود. ");
INSERT INTO pesOPV_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","و مثل خود را آورده، گفت: «بالاق ملک موآب مرا از ارام از کوههای مشرق آورد، که بیایعقوب را برای من لعنت کن، و بیا اسرائیل رانفرین نما. ");
INSERT INTO pesOPV_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","چگونه لعنت کنم آن را که خدا لعنت نکرده است؟ و چگونه نفرین نمایم آن را که خداوند نفرین ننموده است؟ ");
INSERT INTO pesOPV_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","زیرا از سرصخره‌ها او را می‌بینم. و از کوهها او را مشاهده می‌نمایم. اینک قومی است که به تنهایی ساکن می‌شود، و در میان امتها حساب نخواهد شد. ");
INSERT INTO pesOPV_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","کیست که غبار یعقوب را تواند شمرد یا ربع اسرائیل را حساب نماید؟ کاش که من به وفات عادلان بمیرم و عاقبت من مثل عاقبت ایشان باشد.» ");
INSERT INTO pesOPV_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","پس بالاق به بلعام گفت: «به من چه کردی؟ تو را آوردم تا دشمنانم را لعنت کنی، و هان برکت تمام دادی!» ");
INSERT INTO pesOPV_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","او در جواب گفت: «آیا نمی بایدباحذر باشم تا آنچه را که خداوند به دهانم گذاردبگویم؟» ");
INSERT INTO pesOPV_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","بالاق وی را گفت: «بیا الان همراه من به‌جای دیگر که از آنجا ایشان را توانی دید، فقطاقصای ایشان را خواهی دید، و جمیع ایشان رانخواهی دید و از آنجا ایشان را برای من لعنت کن.» ");
INSERT INTO pesOPV_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","پس او را به صحرای صوفیم، نزد قله فسجه برد و هفت مذبح بنا نموده، گاوی و قوچی بر هر مذبح قربانی کرد. ");
INSERT INTO pesOPV_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","و او به بالاق گفت: «نزدقربانی سوختنی خود، اینجا بایست تا من در آنجا(خداوند را) ملاقات نمایم.» ");
INSERT INTO pesOPV_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","و خداوند بلعام را ملاقات نموده، و سخنی در زبانش گذاشته، گفت: «نزد بالاق برگشته، چنین بگو.» ");
INSERT INTO pesOPV_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","پس نزدوی آمد، و اینک نزد قربانی سوختنی خود باسروران موآب ایستاده بود، و بالاق از او پرسیدکه «خداوند چه گفت؟» ");
INSERT INTO pesOPV_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","آنگاه مثل خود راآورده، گفت: «ای بالاق برخیز و بشنو. و‌ای پسرصفور مرا گوش بگیر. ");
INSERT INTO pesOPV_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","خدا انسان نیست که دروغ بگوید. و از بنی آدم نیست که به اراده خودتغییر بدهد. آیا او سخنی گفته باشد و نکند؟ یاچیزی فرموده باشد و استوار ننماید؟ ");
INSERT INTO pesOPV_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","اینک مامور شده‌ام که برکت بدهم. و او برکت داده است و آن را رد نمی توانم نمود. ");
INSERT INTO pesOPV_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","او گناهی دریعقوب ندیده، و خطایی در اسرائیل مشاهده ننموده است. یهوه خدای او با وی است. و نعره پادشاه در میان ایشان است. ");
INSERT INTO pesOPV_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","خدا ایشان را ازمصر بیرون آورد. او را شاخها مثل گاو وحشی است. ");
INSERT INTO pesOPV_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","به درستی که بر یعقوب افسون نیست وبر اسرائیل فالگیری نی. درباره یعقوب و درباره اسرائیل در وقتش گفته خواهد شد، که خدا چه کرده است. ");
INSERT INTO pesOPV_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","اینک قوم مثل شیر ماده خواهندبرخاست. و مثل شیر نر خویشتن را خواهندبرانگیخت، و تا شکار را نخورد، و خون کشتگان را ننوشد، نخواهد خوابید.» ");
INSERT INTO pesOPV_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","بالاق به بلعام گفت: «نه ایشان را لعنت کن ونه برکت ده.» ");
INSERT INTO pesOPV_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","بلعام در جواب بالاق گفت: «آیاتو را نگفتم که هر‌آنچه خداوند به من گوید، آن را باید بکنم؟» ");
INSERT INTO pesOPV_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","بالاق به بلعام گفت: «بیا تا تو را به‌جای دیگر ببرم، شاید در نظر خدا پسند آید که ایشان را برای من از آنجا لعنت نمایی.» ");
INSERT INTO pesOPV_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","پس بالاق بلعام را بر قله فغور که مشرف بر بیابان است، برد. ");
INSERT INTO pesOPV_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","بلعام به بالاق گفت: «در اینجا برای من هفت مذبح بساز و هفت گاو و هفت قوچ از برایم دراینجا حاضر کن.» ");
INSERT INTO pesOPV_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","و بالاق به طوری که بلعام گفته بود، عمل نموده، گاوی و قوچی بر هر مذبح قربانی کرد. ");
INSERT INTO pesOPV_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","و چون بلعام دید که اسرائیل را برکت دادن به نظر خداوند پسند می‌آید، مثل دفعه های پیش برای طلبیدن افسون نرفت، بلکه به سوی صحرا توجه نمود. ");
INSERT INTO pesOPV_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","و بلعام چشمان خودرا بلند کرده، اسرائیل را دید که موافق اسباط خودساکن می‌بودند. و روح خدا بر او نازل شد. ");
INSERT INTO pesOPV_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","پس مثل خود را آورده، گفت: «وحی بلعام بن بعور. وحی آن مردی که چشمانش باز شد. ");
INSERT INTO pesOPV_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","وحی آن کسی‌که سخنان خدا را شنید. و رویای قادرمطلق را مشاهده نمود. آنکه بیفتاد و چشمان اوگشاده گردید. ");
INSERT INTO pesOPV_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","چه زیباست خیمه های تو‌ای یعقوب! و مسکنهای تو‌ای اسرائیل! ");
INSERT INTO pesOPV_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","مثل وادیهای کشیده شده، مثل باغها بر کنار رودخانه، مثل درختان عود که خداوند غرس نموده باشد، ومثل سروهای آزاد نزد جویهای آب. ");
INSERT INTO pesOPV_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","آب ازدلوهایش ریخته خواهد شد. و بذر او در آبهای بسیار خواهد بود. و پادشاه او از اجاج بلندتر، ومملکت او برافراشته خواهد شد. ");
INSERT INTO pesOPV_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","خدا او را ازمصر بیرون آورد. او را شاخها مثل گاو وحشی است. امتهای دشمنان خود را خواهد بلعید و استخوانهای ایشان را خواهد شکست و ایشان رابه تیرهای خود خواهد دوخت. ");
INSERT INTO pesOPV_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","مثل شیر نرخود را جمع کرده، خوابید. و مثل شیر ماده کیست که او را برانگیزاند؟ مبارک باد هر‌که تو رابرکت دهد. و ملعون باد هر‌که تو را لعنت نماید!» ");
INSERT INTO pesOPV_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","پس خشم بالاق بر بلعام افروخته شده، هردو دست خود را بر هم زد و بالاق به بلعام گفت: «تو را خواندم تا دشمنانم را لعنت کنی و اینک این سه مرتبه ایشان را برکت تمام دادی. ");
INSERT INTO pesOPV_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","پس الان به‌جای خود فرار کن! گفتم که تو را احترام تمام نمایم. همانا خداوند تو را از احترام بازداشته است.» ");
INSERT INTO pesOPV_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","بلعام به بالاق گفت آیا به رسولانی که نزد من فرستاده بودی نیز نگفتم: ");
INSERT INTO pesOPV_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","که اگر بالاق خانه خود را پر از نقره و طلا به من بدهد، نمی توانم از فرمان خداوند تجاوز نموده، از دل خود نیک یا بد بکنم بلکه آنچه خداوند به من گوید آن را خواهم گفت؟ ");
INSERT INTO pesOPV_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","و الان اینک نزدقوم خود می‌روم. بیا تا تو را اعلام نمایم که این قوم با قوم تو در ایام آخر چه خواهند کرد. ");
INSERT INTO pesOPV_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","پس مثل خود را آورده، گفت: «وحی بلعام بن بعور. وحی آن مردی که چشمانش بازشد. ");
INSERT INTO pesOPV_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","وحی آن کسی‌که سخنان خدا را شنید. ومعرفت حضرت اعلی را دانست. و رویای قادرمطلق را مشاهده نمود. آنکه بیفتاد و چشمان اوگشوده گردید. ");
INSERT INTO pesOPV_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","او را خواهم دید لیکن نه الان. اورا مشاهده خواهم نمود اما نزدیک نی. ستاره‌ای از یعقوب طلوع خواهد کرد و عصایی از اسرائیل خواهد برخاست و اطراف موآب را خواهدشکست. و جمیع ابنای فتنه را هلاک خواهدساخت. ");
INSERT INTO pesOPV_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","و ادوم ملک او خواهد شد ودشمنانش (اهل ) سعیر، مملوک او خواهندگردید. و اسرائیل به شجاعت عمل خواهد نمود. ");
INSERT INTO pesOPV_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","و کسی‌که از یعقوب ظاهر می‌شود، سلطنت خواهد نمود. و بقیه اهل شهر را هلاک خواهدساخت.» ");
INSERT INTO pesOPV_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","و به عمالقه نظر انداخته، مثل خود راآورده، گفت: «عمالیق اول امتها بود، اما آخر اومنتهی به هلاکت است.» ");
INSERT INTO pesOPV_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","و بر قینیان نظر انداخته، مثل خود را آورد وگفت: «مسکن تو مستحکم و آشیانه تو بر صخره نهاده (شده است ). ");
INSERT INTO pesOPV_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","لیکن قاین تباه خواهد شد، تا وقتی که آشور تو را به اسیری ببرد.» ");
INSERT INTO pesOPV_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","پس مثل خود را آورده، گفت: «وای! چون خدا این را می‌کند، کیست که زنده بماند؟ ");
INSERT INTO pesOPV_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","وکشتیها از جانب کتیم آمده، آشور را ذلیل خواهند ساخت، و عابر را ذلیل خواهند گردانید، و او نیز به هلاکت خواهد رسید.» ");
INSERT INTO pesOPV_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","و بلعام برخاسته، روانه شده، به‌جای خودرفت و بالاق نیز راه خود را پیش گرفت. ");
INSERT INTO pesOPV_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","و اسرائیل در شطیم اقامت نمودند، وقوم با دختران موآب زنا کردن گرفتند. ");
INSERT INTO pesOPV_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","زیرا که ایشان قوم را به قربانی های خدایان خوددعوت نمودند، پس قوم می‌خوردند و به خدایان ایشان سجده می‌نمودند. ");
INSERT INTO pesOPV_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","و اسرائیل به بعل فغورملحق شدند، و غضب خداوند بر اسرائیل افروخته شد. ");
INSERT INTO pesOPV_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","و خداوند به موسی گفت که: «تمامی روسای قوم را گرفته، ایشان را برای خداوند پیش آفتاب به دار بکش، تا شدت خشم خداوند از اسرائیل برگردد.» ");
INSERT INTO pesOPV_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","و موسی به داوران اسرائیل گفت که «هر یکی از شما کسان خود راکه به بعل فغور ملحق شدند، بکشید.» ");
INSERT INTO pesOPV_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","و اینک مردی از بنی‌اسرائیل آمده، زن مدیانی‌ای را در نظر موسی و در نظر تمامی جماعت بنی‌اسرائیل نزد برادران خود آورد، وایشان به دروازه خیمه اجتماع گریه می‌کردند. ");
INSERT INTO pesOPV_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","وچون فینحاس بن العازار بن هارون کاهن، این رادید، از میان جماعت برخاسته، نیزه‌ای به‌دست خود گرفت، ");
INSERT INTO pesOPV_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","و از عقب آن مرد اسرائیلی به قبه داخل شده، هر دوی ایشان یعنی آن مرداسرائیلی و زن را به شکمش فرو برد، و وبا ازبنی‌اسرائیل رفع شد. ");
INSERT INTO pesOPV_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","و آنانی که از وبا مردند، بیست و چهار هزار نفر بودند. ");
INSERT INTO pesOPV_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","و خداوند موسی را خطاب کرده، گفت: ");
INSERT INTO pesOPV_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","«فینحاس بن العازار بن هارون کاهن، غضب مرااز بنی‌اسرائیل برگردانید، چونکه باغیرت من درمیان ایشان غیور شد، تا بنی‌اسرائیل را در غیرت خود هلاک نسازم. ");
INSERT INTO pesOPV_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","لهذا بگو اینک عهدسلامتی خود را به او می‌بخشم. ");
INSERT INTO pesOPV_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","و برای او وبرای ذریتش بعد از او این عهد کهانت جاودانی خواهد بود، زیرا که برای خدای خود غیور شد، وبجهت بنی‌اسرائیل کفاره نمود.» ");
INSERT INTO pesOPV_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","و اسم آن مرد اسرائیلی مقتول که با زن مدیانی کشته گردید، زمری ابن سالو رئیس خاندان آبای سبط شمعون بود. ");
INSERT INTO pesOPV_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","و اسم زن مدیانی که کشته شد، کزبی دختر صور بود و اورئیس قوم خاندان آبا در مدیان بود. ");
INSERT INTO pesOPV_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","و خداوند موسی را خطاب کرده، گفت: ");
INSERT INTO pesOPV_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","«مدیانیان را ذلیل ساخته، مغلوب سازید. ");
INSERT INTO pesOPV_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","زیرا که ایشان شما را به مکاید خود ذلیل ساختند، چونکه شما را در واقعه فغور و در امرخواهر خود کزبی، دختر رئیس مدیان، که در روزوبا در واقعه فغور کشته شد، فریب دادند.» ");
INSERT INTO pesOPV_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","و بعد از وبا، خداوند موسی و العازاربن هارون کاهن را خطاب کرده، گفت: ");
INSERT INTO pesOPV_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","«شماره تمامی بنی‌اسرائیل را برحسب خاندان آبای ایشان، از بیست ساله و بالاتر، یعنی جمیع کسانی را که از اسرائیل به جنگ بیرون می‌روند، بگیرید.» ");
INSERT INTO pesOPV_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","پس موسی و العازار کاهن ایشان را درعربات موآب، نزد اردن در مقابل اریحا خطاب کرده، گفتند: ");
INSERT INTO pesOPV_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","«قوم را از بیست ساله و بالاتربشمارید، چنانکه خداوند موسی و بنی‌اسرائیل را که از زمین مصر بیرون آمدند، امر فرموده بود.» ");
INSERT INTO pesOPV_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","روبین نخست زاده اسرائیل: بنی روبین: ازحنوک، قبیله حنوکیان. و از فلو، قبیله فلوئیان. ");
INSERT INTO pesOPV_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","واز حصرون، قبیله حصرونیان. و از کرمی، قبیله کرمیان. ");
INSERT INTO pesOPV_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","اینانند قبایل روبینیان و شمرده شدگان ایشان، چهل و سه هزار و هفتصد و سی نفر بودند. ");
INSERT INTO pesOPV_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","و بنی فلو: الیاب. ");
INSERT INTO pesOPV_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","و بنی الیاب: نموئیل و داتان و ابیرام. اینانند داتان و ابیرام که خوانده‌شدگان جماعت بوده، با موسی و هارون در جمعیت قورح مخاصمه کردند، چون با خداوند مخاصمه نمودند، ");
INSERT INTO pesOPV_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","و زمین دهان خود را گشوده، ایشان رابا قورح فرو برد، هنگامی که آن گروه مردند وآتش، آن دویست و پنجاه نفر را سوزانیده، عبرت گشتند. ");
INSERT INTO pesOPV_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","لکن پسران قورح نمردند. ");
INSERT INTO pesOPV_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","و بنی شمعون برحسب قبایل ایشان: ازنموئیل، قبیله نموئیلیان و از یامین، قبیله یامینیان و از یاکین، قبیله یاکینیان. ");
INSERT INTO pesOPV_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","و از زارح قبیله زارحیان و از شاول قبیله شاولیان. ");
INSERT INTO pesOPV_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","اینانندقبایل شمعونیان: بیست و دو هزار و دویست نفر. ");
INSERT INTO pesOPV_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","و بنی جاد برحسب قبایل ایشان: از صفون قبیله صفونیان و از حجی قبیله حجیان و از شونی قبیله شونیان. ");
INSERT INTO pesOPV_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","و از ازنی قبیله ازنیان و از عیری، قبیله عیریان. ");
INSERT INTO pesOPV_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","و از ارود قبیله ارودیان و ازارئیلی قبیله ارئیلیان. ");
INSERT INTO pesOPV_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","اینانند قبایل بنی جادبرحسب شماره ایشان، چهل هزار و پانصد نفر. ");
INSERT INTO pesOPV_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","و بنی یهودا عیر و اونان. و عیر و اونان درزمین کنعان مردند. ");
INSERT INTO pesOPV_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","و بنی یهودا برحسب قبایل ایشان اینانند: از شیله قبیله شیلئیان و از فارص قبیله فارصیان و از زارح قبیله زارحیان. ");
INSERT INTO pesOPV_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","وبنی فارص اینانند: از حصرون قبیله حصرونیان واز حامول قبیله حامولیان. ");
INSERT INTO pesOPV_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","اینانند قبایل یهودابرحسب شمرده شدگان ایشان، هفتاد و شش هزارو پانصد نفر. ");
INSERT INTO pesOPV_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","و بنی یساکار برحسب قبایل ایشان: از تولع قبیله تولعیان و از فوه قبیله فوئیان. ");
INSERT INTO pesOPV_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","و از یاشوب قبیله یاشوبیان و از شمرون قبیله شمرونیان. ");
INSERT INTO pesOPV_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","اینانند قبایل یساکار برحسب شمرده شدگان ایشان، شصت و چهار هزار و سیصد نفر. ");
INSERT INTO pesOPV_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","و بنی زبولون برحسب قبایل ایشان: از ساردقبیله ساردیان و از ایلون قبیله ایلونیان و ازیحلیئیل قبیله یحلیئیلیان. ");
INSERT INTO pesOPV_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","اینانند قبایل زبولونیان برحسب شمرده شدگان ایشان، شصت هزار و پانصد نفر. ");
INSERT INTO pesOPV_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","و بنی یوسف برحسب قبایل ایشان: منسی و افرایم. ");
INSERT INTO pesOPV_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","و بنی منسی: از ماکیر قبیله ماکیریان وماکیر جلعاد را آورد و از جلعاد قبیله جلعادیان. ");
INSERT INTO pesOPV_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","اینانند بنی جلعاد: از ایعزر قبیله ایعزریان، ازحالق قبیله حالقیان. ");
INSERT INTO pesOPV_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","از اسریئیل قبیله اسریئیلیان، از شکیم قبیله شکیمیان. ");
INSERT INTO pesOPV_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","ازشمیداع قبیله شمیداعیان و از حافر قبیله حافریان. ");
INSERT INTO pesOPV_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","و صلحفاد بن حافر را پسری نبودلیکن دختران داشت و نامهای دختران صلحفاد محله و نوعه و حجله و ملکه و ترصه. ");
INSERT INTO pesOPV_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","اینانندقبایل منسی و شمرده شدگان ایشان، پنجاه ودوهزار و هفتصد نفر بودند. ");
INSERT INTO pesOPV_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","و اینانند بنی افرایم برحسب قبایل ایشان: از شوتالح قبیله شوتالحیان و از باکر قبیله باکریان و از تاحن قبیله تاحنیان. ");
INSERT INTO pesOPV_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","و بنی شوتالح اینانند: از عیران قبیله عیرانیان. ");
INSERT INTO pesOPV_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","اینانند قبایل بنی افرایم برحسب شمرده شدگان ایشان، سی و دو هزار وپانصد نفر. و بنی یوسف برحسب قبایل ایشان اینانند. ");
INSERT INTO pesOPV_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","و بنی بنیامین برحسب قبایل ایشان: از بالع قبیله بالعیان از اشبیل قبیله اشبیلیان و از احیرام قبیله احیرامیان. ");
INSERT INTO pesOPV_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","از شفوفام قبیله شفوفامیان ازحوفام قبیله حوفامیان. ");
INSERT INTO pesOPV_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","و بنی بالع: ارد و نعمان. از ارد قبیله اردیان و از نعمان قبیله نعمانیان. ");
INSERT INTO pesOPV_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","اینانند بنی بنیامین برحسب قبایل ایشان وشمرده شدگان ایشان، چهل و پنج هزار و ششصدنفر بودند. ");
INSERT INTO pesOPV_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","اینانند بنی دان برحسب قبایل ایشان: ازشوحام قبیله شوحامیان. اینانند قبایل دان برحسب قبایل ایشان. ");
INSERT INTO pesOPV_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","جمیع قبایل شوحامیان برحسب شمرده شدگان ایشان، شصت وچهارهزار و چهارصد نفر بودند. ");
INSERT INTO pesOPV_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","اینانند بنی اشیر برحسب قبایل ایشان: ازیمنه قبیله یمنئیان، از یشوی قبیله یشویان، ازبریعه قبیله بریعئیان، ");
INSERT INTO pesOPV_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","از بنی بریعه، از حابر قبیله حابریان، از ملکیئیل قبیله ملکیئیلیان. ");
INSERT INTO pesOPV_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","و نام دختر اشیر، ساره بود. ");
INSERT INTO pesOPV_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","اینانند قبایل بنی اشیربرحسب شمرده شدگان ایشان، پنجاه و سه هزار وچهارصد نفر. ");
INSERT INTO pesOPV_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","اینانند بنی نفتالی برحسب قبایل ایشان: ازیاحصئیل، قبیله یاحصئیلیان، از جونی قبیله جونیان. ");
INSERT INTO pesOPV_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","از یصر قبیله یصریان از شلیم قبیله شلیمیان. ");
INSERT INTO pesOPV_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","اینانند قبایل نفتالی برحسب قبایل ایشان و شمرده شدگان ایشان، چهل و پنج هزار وچهارصد نفر بودند. ");
INSERT INTO pesOPV_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","اینانند شمرده شدگان بنی‌اسرائیل: ششصدو یکهزار و هفتصد و سی نفر. ");
INSERT INTO pesOPV_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","و خداوند موسی را خطاب کرده، گفت: ");
INSERT INTO pesOPV_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","«برای اینان برحسب شماره نامها، زمین برای ملکیت تقسیم بشود. ");
INSERT INTO pesOPV_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","برای کثیر، نصیب او رازیاده کن و برای قلیل، نصیب او را کم نما، به هرکس برحسب شمرده شدگان او نصیبش داده شود. ");
INSERT INTO pesOPV_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","لیکن زمین به قرعه تقسیم شود، و برحسب نامهای اسباط آبای خود در آن تصرف نمایند. ");
INSERT INTO pesOPV_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","موافق قرعه، ملک ایشان در میان کثیر و قلیل تقسیم شود.» ");
INSERT INTO pesOPV_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","و اینانند شمرده شدگان لاوی برحسب قبایل ایشان: از جرشون قبیله جرشونیان، ازقهات قبیله قهاتیان، از مراری قبیله مراریان. ");
INSERT INTO pesOPV_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","اینانند قبایل لاویان: قبیله لبنیان و قبیله حبرونیان و قبیله محلیان و قبیله موشیان و قبیله قورحیان. اما قهات، عمرام را آورد. ");
INSERT INTO pesOPV_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","و نام زن عمرام، یوکابد بود، دختر لاوی که برای لاوی درمصر زاییده شد و او برای عمرام، هارون و موسی و خواهر ایشان مریم را زایید. ");
INSERT INTO pesOPV_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","و برای هارون ناداب و ابیهو و العازار و ایتامار زاییده شدند. ");
INSERT INTO pesOPV_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","ناداب و ابیهو چون آتش غریبی به حضورخداوند گذرانیده بودند، مردند. ");
INSERT INTO pesOPV_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","وشمرده شدگان ایشان یعنی همه ذکوران از یک ماهه و بالاتر، بیست و سه هزار نفر بودند زیرا که ایشان در میان بنی‌اسرائیل شمرده نشدند، چونکه نصیبی در میان بنی‌اسرائیل به ایشان داده نشد. ");
INSERT INTO pesOPV_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","اینانند آنانی که موسی و العازار کاهن شمردند، وقتی که بنی‌اسرائیل را در عربات موآب نزد اردن در مقابل اریحا شمردند. ");
INSERT INTO pesOPV_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","و درمیان ایشان کسی نبود از آنانی که موسی و هارون کاهن، شمرده بودند وقتی که بنی‌اسرائیل را دربیابان سینا شمردند. ");
INSERT INTO pesOPV_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","زیرا خداوند درباره ایشان گفته بود که البته در بیابان خواهند مرد، پس از آنهایک مرد سوای کالیب بن یفنه و یوشع بن نون باقی نماند. ");
INSERT INTO pesOPV_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","و دختران صلفحاد بن حافر بن جلعادبن ماکیر بن منسی، که از قبایل منسی ابن یوسف بود نزدیک آمدند، و اینهاست نامهای دخترانش: محله و نوعه و حجله و ملکه و ترصه. ");
INSERT INTO pesOPV_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","و به حضور موسی و العازار کاهن، و به حضورسروران و تمامی جماعت نزد در خیمه اجتماع ایستاده، گفتند: ");
INSERT INTO pesOPV_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","«پدر ما در بیابان مرد و او از آن گروه نبود که در جمعیت قورح به ضد خداوندهمداستان شدند، بلکه در گناه خود مرد و پسری نداشت. ");
INSERT INTO pesOPV_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","پس چرا نام پدر ما از این جهت که پسری ندارد از میان قبیله‌اش محو شود، لهذا ما رادر میان برادران پدر ما نصیبی بده.» ");
INSERT INTO pesOPV_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","پس موسی دعوی ایشان را به حضورخداوند آورد. ");
INSERT INTO pesOPV_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","و خداوند موسی را خطاب کرده، گفت: ");
INSERT INTO pesOPV_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","«دختران صلفحاد راست می‌گویند، البته در میان برادران پدر ایشان ملک موروثی به ایشان بده، و نصیب پدر ایشان را به ایشان انتقال نما. ");
INSERT INTO pesOPV_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","و بنی‌اسرائیل را خطاب کرده، بگو: اگر کسی بمیرد و پسری نداشته باشد، ملک او را به دخترش انتقال نمایید. ");
INSERT INTO pesOPV_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","و اگر او رادختری نباشد، ملک او را به برادرانش بدهید. ");
INSERT INTO pesOPV_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","واگر او را برادری نباشد، ملک او را به برادران پدرش بدهید. ");
INSERT INTO pesOPV_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","و اگر پدر او را برادری نباشد، ملک او را به هر کس از قبیله‌اش که خویش نزدیکتر او باشد بدهید، تا مالک آن بشود، پس این برای بنی‌اسرائیل فریضه شرعی باشد، چنانکه خداوند به موسی‌امر فرموده بود.» ");
INSERT INTO pesOPV_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","و خداوند به موسی گفت: «به این کوه عباریم برآی و زمینی را که به بنی‌اسرائیل داده‌ام، ببین. ");
INSERT INTO pesOPV_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","و چون آن را دیدی تو نیز به قوم خودملحق خواهی شد، چنانکه برادرت هارون ملحق شد. ");
INSERT INTO pesOPV_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","زیرا که در بیابان صین وقتی که جماعت مخامصه نمودند شما از قول من عصیان ورزیدید، و مرا نزد آب در نظر ایشان تقدیس ننمودید.» این است آب مریبه قادش، در بیابان صین. ");
INSERT INTO pesOPV_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","و موسی به خداوند عرض کرده، گفت: ");
INSERT INTO pesOPV_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","«ملتمس اینکه یهوه خدای ارواح تمامی بشر، کسی را بر این جماعت بگمارد ");
INSERT INTO pesOPV_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","که پیش روی ایشان بیرون رود، و پیش روی ایشان داخل شود، و ایشان را بیرون برد و ایشان را درآورد، تاجماعت خداوند مثل گوسفندان بی‌شبان نباشند.» ");
INSERT INTO pesOPV_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","و خداوند به موسی گفت: «یوشع بن نون را که مردی صاحب روح است گرفته، دست خود را بر او بگذار. ");
INSERT INTO pesOPV_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","و او را به حضورالعازار کاهن و به حضور تمامی جماعت برپاداشته، در نظر ایشان به وی وصیت نما. ");
INSERT INTO pesOPV_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","و ازعزت خود بر او بگذار تا تمامی جماعت بنی‌اسرائیل او را اطاعت نمایند. ");
INSERT INTO pesOPV_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","و او به حضور العازار کاهن بایستد تا از برای او به حکم اوریم به حضور خداوند سوال نماید، و به فرمان وی، او و تمامی بنی‌اسرائیل با وی و تمامی جماعت، بیرون روند، و به فرمان وی داخل شوند.» ");
INSERT INTO pesOPV_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","پس موسی به نوعی که خداوند او راامر فرموده بود عمل نموده، یوشع را گرفت و اورا به حضور العازار کاهن و به حضور تمامی جماعت برپا داشت. ");
INSERT INTO pesOPV_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","و دستهای خود را بر اوگذاشته، او را به طوری که خداوند به واسطه موسی گفته بود، وصیت نمود. ");
INSERT INTO pesOPV_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","و خداوند موسی را خطاب کرده، گفت: ");
INSERT INTO pesOPV_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","«بنی‌اسرائیل را امر فرموده، به ایشان بگو: مراقب باشید تا هدیه طعام مرا از قربانی های آتشین عطر خوشبوی من در موسمش نزد من بگذرانید. ");
INSERT INTO pesOPV_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","و ایشان را بگو قربانی آتشین را که نزدخداوند بگذرانید، این است: دو بره نرینه یک ساله بی‌عیب، هر روز بجهت قربانی سوختنی دائمی. ");
INSERT INTO pesOPV_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","یک بره را در صبح قربانی کن و بره دیگررا در عصر قربانی کن. ");
INSERT INTO pesOPV_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","و یک عشر ایفه آرد نرم مخلوط شده با یک ربع هین روغن زلال برای هدیه آردی. ");
INSERT INTO pesOPV_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","این است قربانی سوختنی دائمی که در کوه سینا بجهت عطر خوشبو و قربانی آتشین خداوند معین شد. ");
INSERT INTO pesOPV_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","و هدیه ریختنی آن یک ربع هین بجهت هر بره‌ای باشد، این هدیه ریختنی مسکرات را برای خداوند در قدس بریز. ");
INSERT INTO pesOPV_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","و بره دیگر را در عصر قربانی کن، مثل هدیه آردی صبح و مثل هدیه ریختنی آن بگذران تاقربانی آتشین و عطر خوشبو برای خداوند باشد. ");
INSERT INTO pesOPV_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","«و در روز سبت دو بره یک ساله بی‌عیب، ودو عشر ایفه آرد نرم سرشته شده با روغن، بجهت هدیه آردی با هدیه ریختنی آن. ");
INSERT INTO pesOPV_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","این است قربانی سوختنی هر روز سبت سوای قربانی سوختنی دائمی با هدیه ریختنی آن. ");
INSERT INTO pesOPV_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","«و در اول ماههای خود قربانی سوختنی برای خداوند بگذرانید، دو گاو جوان و یک قوچ و هفت بره نرینه یک ساله بی‌عیب. ");
INSERT INTO pesOPV_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","و سه عشرایفه آرد نرم سرشته شده با روغن بجهت هدیه آردی برای هر گاو، و دو عشر آرد نرم سرشته شده با روغن، بجهت هدیه آردی برای هر قوچ. ");
INSERT INTO pesOPV_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","و یک عشر آرد نرم سرشته شده با روغن، بجهت هدیه آردی برای هر بره، تا قربانی سوختنی، عطر خوشبو و هدیه آتشین برای خداوند باشد. ");
INSERT INTO pesOPV_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","و هدایای ریختنی آنها نصف هین شراب برای هر گاو، و ثلث هین برای هر قوچ، و ربع هین برای هر بره باشد. این است قربانی سوختنی هر ماه از ماههای سال. ");
INSERT INTO pesOPV_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","و یک بز نربجهت قربانی گناه سوای قربانی سوختنی دائمی، با هدیه ریختنی آن برای خداوند قربانی بشود. ");
INSERT INTO pesOPV_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","«و در روز چهاردهم ماه اول، فصح خداوند است. ");
INSERT INTO pesOPV_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","و در روز پانزدهم این ماه، عید است که هفت روز نان فطیر خورده شود. ");
INSERT INTO pesOPV_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","در روز اول، محفل مقدس است که هیچ کار خدمت در آن نکنید. ");
INSERT INTO pesOPV_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","و بجهت هدیه آتشین و قربانی سوختنی برای خداوند، دو گاو جوان و یک قوچ و هفت بره نرینه یک ساله قربانی کنید، اینها برای شما بی‌عیب باشد. ");
INSERT INTO pesOPV_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","و بجهت هدیه آردی آنهاسه عشر آرد نرم سرشته شده با روغن برای هرگاو، و دو عشر برای هر قوچ بگذرانید. ");
INSERT INTO pesOPV_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","و یک عشر برای هر بره، از آن هفت بره بگذران. ");
INSERT INTO pesOPV_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","ویک بز نر بجهت قربانی گناه تا برای شما کفاره شود. ");
INSERT INTO pesOPV_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","اینها را سوای قربانی سوختنی صبح که قربانی سوختنی دائمی است، بگذرانید. ");
INSERT INTO pesOPV_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","به اینطور هر روز از آن هفت روز، طعام هدیه آتشین، عطر خوشبو برای خداوند بگذرانید، واین سوای قربانی سوختنی دائمی گذرانیده شود، با هدیه ریختنی آن. ");
INSERT INTO pesOPV_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","و در روز هفتم، برای شمامحفل مقدس باشد. هیچ کار خدمت در آن نکنید. ");
INSERT INTO pesOPV_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","«و در روز نوبرها چون هدیه آردی تازه درعید هفته های خود برای خداوند بگذرانید، محفل مقدس برای شما باشد و هیچ کار خدمت در آن مکنید. ");
INSERT INTO pesOPV_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","و بجهت قربانی سوختنی برای عطر خوشبوی خداوند دو گاو جوان و یک قوچ و هفت بره نرینه یک ساله قربانی کنید. ");
INSERT INTO pesOPV_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","و هدیه آردی آنها سه عشر آرد نرم سرشته شده با روغن برای هر گاو، و دو عشر برای هر قوچ. ");
INSERT INTO pesOPV_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","و یک عشر برای هر بره، از آن هفت بره. ");
INSERT INTO pesOPV_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","و یک بز نر تا برای شما کفاره شود. ");
INSERT INTO pesOPV_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","اینها را با هدیه آردی آنها و هدایای ریختنی آنها سوای قربانی سوختنی دائمی بگذرانید و برای شما بی‌عیب باشد. ");
INSERT INTO pesOPV_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","«و در روز اول ماه هفتم، محفل مقدس برای شما باشد؛ در آن هیچ کار خدمت مکنید و برای شما روز نواختن کرنا باشد. ");
INSERT INTO pesOPV_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","وقربانی سوختنی بجهت عطر خوشبوی خداوندبگذرانید، یک گاو جوان و یک قوچ، و هفت بره نرینه یک ساله بی‌عیب. ");
INSERT INTO pesOPV_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","و هدیه آردی آنها، سه عشر آرد نرم سرشته شده با روغن برای هر گاو، ودو عشر برای هر قوچ. ");
INSERT INTO pesOPV_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","و یک عشر برای هر بره، از آن هفت بره. ");
INSERT INTO pesOPV_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","و یک بز نر بجهت قربانی گناه تابرای شما کفاره شود. ");
INSERT INTO pesOPV_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","سوای قربانی سوختنی اول ماه و هدیه آردی‌اش، و قربانی سوختنی دائمی با هدیه آردی‌اش، با هدایای ریختنی آنهابرحسب قانون آنها تا عطر خوشبو و هدیه آتشین خداوند باشد. ");
INSERT INTO pesOPV_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","«و در روز دهم این ماه هفتم، محفل مقدس برای شما باشد. جانهای خود را ذلیل سازید وهیچ کار مکنید. ");
INSERT INTO pesOPV_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","و قربانی سوختنی عطر خوشبوبرای خداوند بگذرانید، یک گاو جوان و یک قوچ و هفت بره نرینه یک ساله که برای شما بی‌عیب باشند. ");
INSERT INTO pesOPV_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","و هدیه آردی آنها سه عشر آرد نرم سرشته شده با روغن برای هر گاو، و دو عشر برای هر قوچ. ");
INSERT INTO pesOPV_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","و یک عشر برای هر بره، از آن هفت بره. ");
INSERT INTO pesOPV_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","و یک بز نر برای قربانی گناه سوای قربانی گناه کفاره‌ای و قربانی سوختنی دائمی با هدیه آردی‌اش و هدایای ریختنی آنها. ");
INSERT INTO pesOPV_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","«و در روز پانزدهم ماه هفتم، محفل مقدس برای شما باشد، هیچ کار خدمت مکنید و هفت روز برای خداوند عید نگاه دارید. ");
INSERT INTO pesOPV_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","و قربانی سوختنی هدیه آتشین عطر خوشبو برای خداوندبگذرانید. سیزده گاو جوان و دو قوچ و چهارده بره نرینه یک ساله که برای شما بی‌عیب باشند. ");
INSERT INTO pesOPV_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","و بجهت هدیه آردی آنها سه عشر آرد نرم سرشته شده با روغن برای هر گاو از آن سیزده گاو، و دو عشر برای هر قوچ از آن دو قوچ. ");
INSERT INTO pesOPV_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","ویک عشر برای هر بره از آن چهارده بره. ");
INSERT INTO pesOPV_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","و یک بز نر بجهت قربانی گناه، سوای قربانی سوختنی دائمی، با هدیه آردی و هدیه ریختنی آن. ");
INSERT INTO pesOPV_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","«و در روز دوم، دوازده گاو جوان و دو قوچ و چهارده بره نرینه یک ساله بی‌عیب. ");
INSERT INTO pesOPV_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","وهدایای آردی و هدایای ریختنی آنها برای گاوهاو قوچها و بره‌ها به شماره آنها برحسب قانون. ");
INSERT INTO pesOPV_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","و یک بز نر بجهت قربانی گناه، سوای قربانی سوختنی دائمی با هدیه آردی‌اش، و هدایای ریختنی آنها. ");
INSERT INTO pesOPV_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","«و در روز سوم، یازده گاو جوان و دو قوچ و چهارده بره نرینه یک ساله بی‌عیب. ");
INSERT INTO pesOPV_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","وهدایای آردی و هدایای ریختنی آنها برای گاوهاو قوچها و بره‌ها به شماره آنها برحسب قانون. ");
INSERT INTO pesOPV_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","و یک بز نر بجهت قربانی گناه سوای قربانی سوختنی دائمی با هدیه آردی‌اش و هدیه ریختنی آن. ");
INSERT INTO pesOPV_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","«و در روز چهارم ده گاو جوان و دو قوچ وچهارده بره نرینه یک ساله بی‌عیب. ");
INSERT INTO pesOPV_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","و هدایای آردی و هدایای ریختنی آنها برای گاوها وقوچها و بره‌ها به شماره آنها برحسب قانون. ");
INSERT INTO pesOPV_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","ویک بز نر بجهت قربانی گناه، سوای قربانی سوختنی دائمی، و هدیه آردی‌اش و هدیه ریختنی آن. ");
INSERT INTO pesOPV_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","«و در روز پنجم، نه گاو جوان و دو قوچ وچهارده بره نرینه یک ساله بی‌عیب. ");
INSERT INTO pesOPV_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","و هدایای آردی و هدایای ریختنی آنها برای گاوها وقوچها و بره‌ها به شماره آنها برحسب قانون. ");
INSERT INTO pesOPV_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","ویک بز نر بجهت قربانی گناه، سوای قربانی سوختنی دائمی و هدیه آردی‌اش و هدیه ریختنی آن. ");
INSERT INTO pesOPV_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","«و در روز ششم، هشت گاو جوان و دوقوچ و چهارده بره نرینه یک ساله بی‌عیب. ");
INSERT INTO pesOPV_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","وهدایای آردی و هدایای ریختنی آنها برای گاوهاو قوچها و بره‌ها به شماره آنها برحسب قانون. ");
INSERT INTO pesOPV_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","و یک بز نر بجهت قربانی گناه سوای قربانی سوختنی دائمی و هدیه آردی‌اش و هدایای ریختنی آن. ");
INSERT INTO pesOPV_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","«و در روز هفتم، هفت گاو جوان و دو قوچ و چهارده بره نرینه یک ساله بی‌عیب. ");
INSERT INTO pesOPV_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","وهدایای آردی و هدایای ریختنی آنها برای گاوهاو قوچها و بره‌ها به شماره آنها برحسب قانون. ");
INSERT INTO pesOPV_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","و یک بز نر بجهت قربانی گناه، سوای قربانی سوختنی دائمی و هدیه آردی‌اش و هدیه ریختنی آن. ");
INSERT INTO pesOPV_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","«و در روز هشتم، برای شما جشن مقدس باشد؛ هیچ کار خدمت مکنید. ");
INSERT INTO pesOPV_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","و قربانی سوختنی هدیه آتشین عطر خوشبو برای خداوندبگذرانید، یک گاو جوان و یک قوچ و هفت بره نرینه یک ساله بی‌عیب. ");
INSERT INTO pesOPV_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","و هدایای آردی وهدایای ریختنی آنها برای گاو و قوچ و بره‌ها به شماره آنها برحسب قانون. ");
INSERT INTO pesOPV_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","و یک بز نر برای قربانی گناه سوای قربانی سوختنی دائمی، باهدیه آردی‌اش و هدیه ریختنی آن. ");
INSERT INTO pesOPV_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","اینها را شما در موسمهای خود برای خداوند بگذرانید، سوای نذرها و نوافل خودبرای قربانی های سوختنی و هدایای آردی وهدایای ریختنی و ذبایح سلامتی خود.» ");
INSERT INTO pesOPV_vpl VALUES ("NU29_40","005_29_40","NUM","29","40","40","پس برحسب هر‌آنچه خداوند به موسی‌امر فرموده بود، موسی بنی‌اسرائیل را اعلام نمود. ");
INSERT INTO pesOPV_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","و موسی سروران اسباط بنی‌اسرائیل راخطاب کرده، گفت: «این است کاری که خداوند امر فرموده است: ");
INSERT INTO pesOPV_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","چون شخصی برای خداوند نذر کند یا قسم خورد تا جان خود را به تکلیفی الزام نماید، پس کلام خود را باطل نسازد، بلکه برحسب هر‌آنچه از دهانش برآمد، عمل نماید. ");
INSERT INTO pesOPV_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","«و اما چون زن برای خداوند نذر کرده، خودرا در خانه پدرش در جوانی‌اش به تکلیفی الزام نماید، ");
INSERT INTO pesOPV_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","و پدرش نذر او و تکلیفی که خود را برآن الزام نموده، شنیده باشد، و پدرش درباره اوساکت باشد، آنگاه تمامی نذرهایش استوار، و هرتکلیفی که خود را به آن الزام نموده باشد، قایم خواهد بود. ");
INSERT INTO pesOPV_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","اما اگر پدرش در روزی که شنید اورا منع کرد، آنگاه هیچ کدام از نذرهایش و ازتکالیفش که خود را به آن الزام نموده باشد، استوار نخواهد بود، و از این جهت که پدرش او رامنع نموده است، خداوند او را خواهد آمرزید. ");
INSERT INTO pesOPV_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","«و اگر به شوهری داده شود، و نذرهای او یاسخنی که از لبهایش جسته، و جان خود را به آن الزام نموده، بر او باشد، ");
INSERT INTO pesOPV_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","و شوهرش شنید و درروز شنیدنش به وی هیچ نگفت، آنگاه نذرهایش استوار خواهد ماند. و تکلیفهایی که خویشتن را به آنها الزام نموده است، قایم خواهند ماند. ");
INSERT INTO pesOPV_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","لیکن اگر شوهرش در روزی که آن را شنید، او را منع نماید، و نذری را که بر او است یا سخنی را که ازلبهایش جسته، و خویشتن را به آن الزام نموده باشد، باطل سازد، پس خداوند او را خواهدآمرزید. ");
INSERT INTO pesOPV_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","اما نذر زن بیوه یا مطلقه، در هر‌چه خود را به آن الزام نموده باشد، بر وی استوارخواهد ماند. ");
INSERT INTO pesOPV_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","و اما اگر زنی در خانه شوهرش نذر کند، یا خویشتن را با قسم به تکلیفی الزام نماید، ");
INSERT INTO pesOPV_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","و شوهرش بشنود و او را هیچ نگوید ومنع ننماید، پس تمامی نذرهایش استوار، و هرتکلیفی که خویشتن را به آن الزام نموده باشد، قایم خواهد بود. ");
INSERT INTO pesOPV_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","و اما اگر شوهرش در روزی که بشنود، آنها را باطل سازد. پس هر‌چه ازلبهایش درآمده باشد درباره نذرهایش یا تکالیف خود، استوار نخواهد ماند. چونکه شوهرش آن راباطل نموده است، خداوند او را خواهد آمرزید. ");
INSERT INTO pesOPV_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","هر نذری و هر قسم الزامی را برای ذلیل ساختن جان خود، شوهرش آن را استوار نماید، وشوهرش آن را باطل سازد. ");
INSERT INTO pesOPV_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","اما اگر شوهرش روز به روز به او هیچ نگوید، پس همه نذرهایش وهمه تکالیفش را که بر وی باشد استوار نموده باشد، چونکه در روزی که شنید به وی هیچ نگفت، پس آنها را استوار نموده است. ");
INSERT INTO pesOPV_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","و اگربعد از شنیدن، آنها را باطل نمود، پس او گناه وی را متحمل خواهد بود.» ");
INSERT INTO pesOPV_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","این است فرایضی که خداوند به موسی‌امرفرمود، در میان مرد و زنش و در میان پدر ودخترش، در زمان جوانی او در خانه پدر وی. ");
INSERT INTO pesOPV_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","و خداوند موسی را خطاب کرده، گفت: ");
INSERT INTO pesOPV_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","«انتقام بنی‌اسرائیل را از مدیانیان بگیر، و بعد از آن به قوم خود ملحق خواهی شد.» ");
INSERT INTO pesOPV_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","پس موسی قوم را مخاطب ساخته، گفت: «ازمیان خود مردان برای جنگ مهیا سازید تا به مقابله مدیان برآیند، و انتقام خداوند را از مدیان بکشند. ");
INSERT INTO pesOPV_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","هزار نفر از هر سبط از جمیع اسباطاسرائیل برای جنگ بفرستید.» ");
INSERT INTO pesOPV_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","پس از هزاره های اسرائیل، از هر سبط یک هزار، یعنی دوازده هزار نفر مهیا شده برای جنگ منتخب شدند. ");
INSERT INTO pesOPV_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","و موسی ایشان را هزار نفر از هرسبط به جنگ فرستاد، ایشان را با فینحاس بن العازار کاهن و اسباب قدس و کرناها برای نواختن در دستش به جنگ فرستاد. ");
INSERT INTO pesOPV_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","و با مدیان به طوری که خداوند موسی را امر فرموده بود، جنگ کرده، همه ذکوران را کشتند. ");
INSERT INTO pesOPV_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","و در میان کشتگان ملوک مدیان یعنی اوی و راقم و صور و حور و رابع، پنج پادشاه مدیان را کشتند، بلعام بن بعور را به شمشیر کشتند. ");
INSERT INTO pesOPV_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","و بنی‌اسرائیل زنان مدیان واطفال ایشان را به اسیری بردند، و جمیع بهایم وجمیع مواشی ایشان و همه املاک ایشان را غارت کردند. ");
INSERT INTO pesOPV_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","و تمامی شهرها و مساکن و قلعه های ایشان را به آتش سوزانیدند. ");
INSERT INTO pesOPV_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","و تمامی غنیمت و جمیع غارت را از انسان و بهایم گرفتند. ");
INSERT INTO pesOPV_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","واسیران و غارت و غنیمت را نزد موسی و العازارکاهن و جماعت بنی‌اسرائیل در لشکرگاه درعربات موآب، که نزد اردن در مقابل اریحاست، آوردند. ");
INSERT INTO pesOPV_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","و موسی و العازار کاهن و تمامی سروران جماعت بیرون از لشکرگاه به استقبال ایشان آمدند. ");
INSERT INTO pesOPV_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","و موسی بر روسای لشکر یعنی سرداران هزاره‌ها و سرداران صدها که از خدمت جنگ باز آمده بودند، غضبناک شد. ");
INSERT INTO pesOPV_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","و موسی به ایشان گفت: «آیا همه زنان را زنده نگاه داشتید؟ ");
INSERT INTO pesOPV_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","اینک اینانند که برحسب مشورت بلعام، بنی‌اسرائیل را واداشتند تا در امر فغور به خداوندخیانت ورزیدند و در جماعت خداوند وباعارض شد. ");
INSERT INTO pesOPV_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","پس الان هر ذکوری از اطفال رابکشید، و هر زنی را که مرد را شناخته، با اوهمبستر شده باشد، بکشید. ");
INSERT INTO pesOPV_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","و از زنان هردختری را که مرد را نشناخته، و با او همبسترنشده برای خود زنده نگاه دارید. ");
INSERT INTO pesOPV_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","و شما هفت روز بیرون از لشکرگاه خیمه زنید، و هر شخصی را کشته و هر‌که کشته‌ای را لمس نموده باشد ازشما و اسیران شما در روز سوم و در روز هفتم، خود را تطهیر نماید. ");
INSERT INTO pesOPV_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","و هر جامه و هرظرف چرمی و هر‌چه از پشم بز ساخته شده باشد و هرظرف چوبین را تطهیر نمایید.» ");
INSERT INTO pesOPV_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","و العازار کاهن به مردان جنگی که به مقاتله رفته بودند، گفت: «این است قانون شریعتی که خداوند به موسی‌امر فرموده است: ");
INSERT INTO pesOPV_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","22","طلا و نقره و برنج و آهن و روی و سرب، ");
INSERT INTO pesOPV_vpl VALUES ("NU31_23","005_31_23","NUM","31","23","23","یعنی هر‌چه متحمل آتش بشود، آن را از آتش بگذرانید و طاهر خواهد شد، و به آب تنزیه نیز آن را طاهرسازند و هر‌چه متحمل آتش نشود، آن را از آب بگذرانید. ");
INSERT INTO pesOPV_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","و در روز هفتم رخت خود رابشویید تا طاهر شوید، و بعد از آن به لشکرگاه داخل شوید.» ");
INSERT INTO pesOPV_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","و خداوند موسی را خطاب کرده، گفت: ");
INSERT INTO pesOPV_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","«تو و العازار کاهن و سروران خاندان آبای جماعت، حساب غنایمی که گرفته شده است، چه از انسان و چه از بهایم بگیرید. ");
INSERT INTO pesOPV_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","و غنیمت رادر میان مردان جنگی که به مقاتله بیرون رفته‌اند، وتمامی جماعت نصف نما. ");
INSERT INTO pesOPV_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","و از مردان جنگی که به مقاتله بیرون رفته‌اند زکات برای خداوندبگیر، یعنی یک نفر از پانصد چه از انسان و چه ازگاو و چه از الاغ و چه از گوسفند. ");
INSERT INTO pesOPV_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","از قسمت ایشان بگیر و به العازار کاهن بده تا هدیه افراشتنی برای خداوند باشد. ");
INSERT INTO pesOPV_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","و از قسمت بنی‌اسرائیل یکی که از هر پنجاه نفر گرفته شده باشد چه ازانسان و چه از گاو و چه از الاغ و چه از گوسفند وچه از جمیع بهایم بگیر، و آنها را به لاویانی که ودیعت مسکن خداوند را نگاه می‌دارند، بده.» ");
INSERT INTO pesOPV_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","پس موسی و العازار کاهن برحسب آنچه خداوند به موسی‌امر فرموده بود، عمل کردند. ");
INSERT INTO pesOPV_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","32","و غنیمت سوای آن غنیمتی که مردان جنگی گرفته بودند، از گوسفند ششصد و هفتاد و پنج هزار راس بود. ");
INSERT INTO pesOPV_vpl VALUES ("NU31_33","005_31_33","NUM","31","33","33","و از گاو هفتاد و دو هزار راس. ");
INSERT INTO pesOPV_vpl VALUES ("NU31_34","005_31_34","NUM","31","34","34","و از الاغ شصت و یک هزار راس. ");
INSERT INTO pesOPV_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","و ازانسان از زنانی که مرد را نشناخته بودند، سی و دوهزار نفر بودند. ");
INSERT INTO pesOPV_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","و نصفه‌ای که قسمت کسانی بود که به جنگ رفته بودند، سیصد و سی و هفت هزار و پانصد گوسفند بود. ");
INSERT INTO pesOPV_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","و زکات خداوند ازگوسفند ششصد و هفتاد و پنج راس بود. ");
INSERT INTO pesOPV_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","وگاوان سی و شش هزار بود و از آنها زکات خداوند هفتاد و دو راس بود. ");
INSERT INTO pesOPV_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","و الاغها سی هزار و پانصد و از آنها زکات خداوند شصت ویک راس بود. ");
INSERT INTO pesOPV_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","و مردمان شانزده هزار و ازایشان زکات خداوند سی و دو نفر بودند. ");
INSERT INTO pesOPV_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","وموسی زکات را هدیه افراشتی خداوند بود به العازار کاهن داد، چنانکه خداوند به موسی‌امرفرموده بود. ");
INSERT INTO pesOPV_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","42","و از قسمت بنی‌اسرائیل که موسی آن را ازمردان جنگی جدا کرده بود، ");
INSERT INTO pesOPV_vpl VALUES ("NU31_43","005_31_43","NUM","31","43","43","و قسمت جماعت از گوسفندان، سیصد و سی هزار وپانصد راس بود. ");
INSERT INTO pesOPV_vpl VALUES ("NU31_44","005_31_44","NUM","31","44","44","و از گاوان سی و شش هزارراس. ");
INSERT INTO pesOPV_vpl VALUES ("NU31_45","005_31_45","NUM","31","45","45","و از الاغها، سی هزار و پانصد راس. ");
INSERT INTO pesOPV_vpl VALUES ("NU31_46","005_31_46","NUM","31","46","46","واز انسان، شانزده هزار نفر. ");
INSERT INTO pesOPV_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","و موسی از قسمت بنی‌اسرائیل یکی را که از هر پنجاه گرفته شده بود، چه از انسان و چه از بهایم گرفت، و آنها را به لاویانی که ودیعت مسکن خداوند را نگاه می‌داشتند، داد، چنانکه خداوند به موسی‌امرفرموده بود. ");
INSERT INTO pesOPV_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","و روسایی که بر هزاره های لشکر بودند، سرداران هزاره‌ها با سرداران صدها نزد موسی آمدند. ");
INSERT INTO pesOPV_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","و به موسی گفتند: «بندگانت حساب مردان جنگی را که زیردست ما می‌باشند گرفتیم، و از ما یک نفر مفقود نشده است. ");
INSERT INTO pesOPV_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","پس ما ازآنچه هر کس یافته است هدیه‌ای برای خداوندآورده‌ایم از زیورهای طلا و خلخالها ودست بندها و انگشترها و گوشواره‌ها وگردن بندها تا برای جانهای ما به حضور خداوند کفاره شود.» ");
INSERT INTO pesOPV_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","و موسی و العازار کاهن، طلا وهمه زیورهای مصنوعه را از ایشان گرفتند. ");
INSERT INTO pesOPV_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","وتمامی طلای هدیه‌ای که از سرداران هزاره‌ها وسرداران صدها برای خداوند گذرانیدند، شانزده هزار و هفتصد و پنجاه مثقال بود. ");
INSERT INTO pesOPV_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","زیرا که هریکی از مردان جنگی غنیمتی برای خود برده بودند. ");
INSERT INTO pesOPV_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","و موسی و العازار کاهن، طلا را ازسرداران هزاره‌ها و صدها گرفته، به خیمه اجتماع آوردند تا بجهت بنی‌اسرائیل، به حضور خداوندیادگار باشد. ");
INSERT INTO pesOPV_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","و بنی روبین و بنی جاد را مواشی بی نهایت بسیار و کثیر بود، پس چون زمین یعزیر و زمین جلعاد را دیدند که اینک این مکان، مکان مواشی است. ");
INSERT INTO pesOPV_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","بنی جاد و بنی روبین نزد موسی و العازار کاهن و سروران جماعت آمده، گفتند: ");
INSERT INTO pesOPV_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","3","«عطاروت و دیبون و یعزیر و نمره و حشبون و العاله و شبام و نبو و بعون، ");
INSERT INTO pesOPV_vpl VALUES ("NU32_4","005_32_4","NUM","32","4","4","زمینی که خداوند پیش روی جماعت اسرائیل مفتوح ساخته است، زمین مواشی است، و بندگانت صاحب مواشی می‌باشیم. ");
INSERT INTO pesOPV_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","پس گفتند: اگر درنظر تو التفات یافته‌ایم، این زمین به بندگانت به ملکیت داده شود، و ما را از اردن عبور مده.» ");
INSERT INTO pesOPV_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","موسی به بنی جاد و بنی روبین گفت: «آیابرادران شما به جنگ روند و شما اینجا بنشینید؟ ");
INSERT INTO pesOPV_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","چرا دل بنی‌اسرائیل را افسرده می‌کنید تا به زمینی که خداوند به ایشان داده است، عبورنکنند؟ ");
INSERT INTO pesOPV_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","به همین طور پدران شما عمل نمودند، وقتی که ایشان را از قادش برنیع برای دیدن زمین فرستادم. ");
INSERT INTO pesOPV_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","به وادی اشکول رفته، زمین را دیدند ودل بنی‌اسرائیل را افسرده ساختند تا به زمینی که خداوند به ایشان داده بود، داخل نشوند. ");
INSERT INTO pesOPV_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","پس غضب خداوند در آن روز افروخته شد به حدی که قسم خورده، گفت: ");
INSERT INTO pesOPV_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","11","البته هیچکدام ازمردانی که از مصر بیرون آمدند از بیست ساله وبالاتر آن زمین را که برای ابراهیم و اسحاق ویعقوب قسم خوردم، نخواهند دید، چونکه ایشان مرا پیروی کامل ننمودند. ");
INSERT INTO pesOPV_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","سوای کالیب بن یفنه قنزی و یوشع بن نون، چونکه ایشان خداوند را پیروی کامل نمودند. ");
INSERT INTO pesOPV_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","پس غضب خداوند بر اسرائیل افروخته شده، ایشان را چهل سال در بیابان آواره گردانید، تا تمامی آن گروهی که این شرارت را در نظر خداوند ورزیده بودند، هلاک شدند. ");
INSERT INTO pesOPV_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","و اینک شما به‌جای پدران خودانبوهی از مردان خطاکار برپا شده‌اید تا شدت غضب خداوند را بر اسرائیل باز زیاده کنید؟ ");
INSERT INTO pesOPV_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","زیرا اگر از پیروی او روبگردانید بار دیگرایشان را در بیابان ترک خواهد کرد و شما تمامی این قوم را هلاک خواهید ساخت.» ");
INSERT INTO pesOPV_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","پس ایشان نزد وی آمده، گفتند: «آغلها رااینجا برای مواشی خود و شهرها بجهت اطفال خویش خواهیم ساخت. ");
INSERT INTO pesOPV_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","و خود مسلح شده، حاضر می‌شویم و پیش روی بنی‌اسرائیل خواهیم رفت تا آنها را به مکان ایشان برسانیم. واطفال ما از ترس ساکنان زمین در شهرهای حصاردار خواهند ماند. ");
INSERT INTO pesOPV_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","و تا هر یکی ازبنی‌اسرائیل ملک خود را نگرفته باشد، به خانه های خود مراجعت نخواهیم کرد. ");
INSERT INTO pesOPV_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","زیرا که ما با ایشان در آن طرف اردن و ماورای آن ملک نخواهیم گرفت، چونکه نصیب ما به این طرف اردن به طرف مشرق به ما رسیده است.» ");
INSERT INTO pesOPV_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","و موسی به ایشان گفت: «اگر این کار رابکنید و خویشتن را به حضور خداوند برای جنگ مهیا سازید، ");
INSERT INTO pesOPV_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","و هر مرد جنگی از شما به حضورخداوند از اردن عبور کند تا او دشمنان خود را ازپیش روی خود اخراج نماید، ");
INSERT INTO pesOPV_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","و زمین به حضور خداوند مغلوب شود، پس بعد از آن برگردیده، به حضور خداوند و به حضور اسرائیل بی‌گناه خواهید شد، و این زمین از جانب خداوندملک شما خواهد بود. ");
INSERT INTO pesOPV_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","و اگر چنین نکنید اینک به خداوند گناه ورزیده‌اید، و بدانید که گناه شما، شما را درخواهد گرفت. ");
INSERT INTO pesOPV_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","پس شهرها برای اطفال و آغلها برای گله های خود بنا کنید، و به آنچه از دهان شما درآمد، عمل نمایید.» ");
INSERT INTO pesOPV_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","پس بنی جاد و بنی روبین موسی را خطاب کرده، گفتند: «بندگانت به طوری که آقای مافرموده است، خواهیم کرد. ");
INSERT INTO pesOPV_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","اطفال و زنان ومواشی و همه بهایم ما اینجا در شهرهای جلعادخواهند ماند. ");
INSERT INTO pesOPV_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","و جمیع بندگانت مهیای جنگ شده، چنانکه آقای ما گفته است به حضورخداوند برای مقاتله عبور خواهیم نمود.» ");
INSERT INTO pesOPV_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","پس موسی العازار کاهن، و یوشع بن نون، وروسای خاندان آبای اسباط بنی‌اسرائیل را درباره ایشان وصیت نمود. ");
INSERT INTO pesOPV_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","و موسی به ایشان گفت: «اگر جمیع بنی جاد و بنی روبین مهیای جنگ شده، همراه شما به حضور خداوند از اردن عبورکنند، و زمین پیش روی شما مغلوب شود، آنگاه زمین جلعاد را برای ملکیت به ایشان بدهید. ");
INSERT INTO pesOPV_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","واگر ایشان مهیا نشوند و همراه شما عبور ننمایند، پس در میان شما در زمین کنعان ملک بگیرند.» ");
INSERT INTO pesOPV_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","بنی جاد و بنی روبین در جواب وی گفتند: «چنانکه خداوند به بندگانت گفته است، همچنین خواهیم کرد. ");
INSERT INTO pesOPV_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","ما مهیای جنگ شده، پیش روی خداوند به زمین کنعان عبور خواهیم کرد، و ملک نصیب ما به این طرف اردن داده شود.» ");
INSERT INTO pesOPV_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","پس موسی به ایشان یعنی به بنی جاد وبنی روبین و نصف سبط منسی ابن یوسف، مملکت سیحون، ملک اموریان و مملکت عوج ملک باشان را داد، یعنی زمین را با شهرهایش وحدود شهرهایش، زمین را از هر طرف. ");
INSERT INTO pesOPV_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","34","وبنی جاد، دیبون و عطاروت و عروعیر. ");
INSERT INTO pesOPV_vpl VALUES ("NU32_35","005_32_35","NUM","32","35","35","وعطروت، شوفان و یعزیز و یجبهه. ");
INSERT INTO pesOPV_vpl VALUES ("NU32_36","005_32_36","NUM","32","36","36","و بیت نمره و بیت هاران را بنا کردند یعنی شهرهای حصارداررا با آغلهای گله‌ها. ");
INSERT INTO pesOPV_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","37","و بنی روبین حشبون والیعاله و قریتایم. ");
INSERT INTO pesOPV_vpl VALUES ("NU32_38","005_32_38","NUM","32","38","38","و نبو و بعل معون که نام این دورا تغییر دادند و سبمه را بنا کردند و شهرهایی راکه بنا کردند به نامها مسمی ساختند. ");
INSERT INTO pesOPV_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","وبنی ماکیر بن منسی به جلعاد رفته، آن را گرفتند واموریان را که در آن بودند، اخراج نمودند. ");
INSERT INTO pesOPV_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40","وموسی جلعاد را به ماکیر بن منسی داد و او در آن ساکن شد. ");
INSERT INTO pesOPV_vpl VALUES ("NU32_41","005_32_41","NUM","32","41","41","و یائیر بن منسی رفته، قصبه هایش راگرفت، و آنها را حووت یائیر نامید. ");
INSERT INTO pesOPV_vpl VALUES ("NU32_42","005_32_42","NUM","32","42","42","و نوبح رفته، قنات و دهاتش را گرفته، آنها را به اسم خودنوبح نامید. ");
INSERT INTO pesOPV_vpl VALUES ("NU33_1","005_33_1","NUM","33","1","1","این است منازل بنی‌اسرائیل که از زمین مصر با افواج خود زیردست موسی وهارون کوچ کردند. ");
INSERT INTO pesOPV_vpl VALUES ("NU33_2","005_33_2","NUM","33","2","2","و موسی به فرمان خداوندسفرهای ایشان را برحسب منازل ایشان نوشت، واین است منازل و مراحل ایشان: ");
INSERT INTO pesOPV_vpl VALUES ("NU33_3","005_33_3","NUM","33","3","3","پس در ماه اول از رعمسیس، در روز پانزدهم از ماه اول کوچ کردند، و در فردای بعد از فصح بنی‌اسرائیل درنظر تمامی مصریان با دست بلند بیرون رفتند. ");
INSERT INTO pesOPV_vpl VALUES ("NU33_4","005_33_4","NUM","33","4","4","ومصریان همه نخست زادگان خود را که خداوند ازایشان کشته بود دفن می‌کردند، و یهوه بر خدایان ایشان قصاص نموده بود. ");
INSERT INTO pesOPV_vpl VALUES ("NU33_5","005_33_5","NUM","33","5","5","و بنی‌اسرائیل از رعمسیس کوچ کرده، درسکوت فرود آمدند. ");
INSERT INTO pesOPV_vpl VALUES ("NU33_6","005_33_6","NUM","33","6","6","و از سکوت کوچ کرده، درایتام که به کنار بیابان است، فرود آمدند. ");
INSERT INTO pesOPV_vpl VALUES ("NU33_7","005_33_7","NUM","33","7","7","و ازایتام کوچ کرده، به سوی فم الحیروت که در مقابل بعل صفون است، برگشتند، و پیش مجدل فرودآمدند. ");
INSERT INTO pesOPV_vpl VALUES ("NU33_8","005_33_8","NUM","33","8","8","و از مقابل حیروت کوچ کرده، از میان دریا به بیابان عبور کردند و در بیابان ایتام سفر سه روزه کرده، در ماره فرود آمدند. ");
INSERT INTO pesOPV_vpl VALUES ("NU33_9","005_33_9","NUM","33","9","9","و از ماره کوچ کرده، به ایلیم رسیدند و در ایلیم دوازده چشمه آب و هفتاد درخت خرما بود، و در آنجا فرودآمدند. ");
INSERT INTO pesOPV_vpl VALUES ("NU33_10","005_33_10","NUM","33","10","10","و از ایلیم کوچ کرده، نزد بحر قلزم فرود آمدند. ");
INSERT INTO pesOPV_vpl VALUES ("NU33_11","005_33_11","NUM","33","11","11","و از بحر قلزم کوچ کرده، در بیابان سین فرود آمدند. ");
INSERT INTO pesOPV_vpl VALUES ("NU33_12","005_33_12","NUM","33","12","12","و از بیابان سین کوچ کرده، دردفقه فرود آمدند. ");
INSERT INTO pesOPV_vpl VALUES ("NU33_13","005_33_13","NUM","33","13","13","و از دفقه کوچ کرده، درالوش فرود آمدند. ");
INSERT INTO pesOPV_vpl VALUES ("NU33_14","005_33_14","NUM","33","14","14","و از الوش کوچ کرده، دررفیدیم فرود آمدند و در آنجا آب نبود که قوم بنوشند. ");
INSERT INTO pesOPV_vpl VALUES ("NU33_15","005_33_15","NUM","33","15","15","و از رفیدیم کوچ کرده، در بیابان سینافرود آمدند. ");
INSERT INTO pesOPV_vpl VALUES ("NU33_16","005_33_16","NUM","33","16","16","و از بیابان سینا کوچ کرده، درقبروت هتاوه فرود آمدند. ");
INSERT INTO pesOPV_vpl VALUES ("NU33_17","005_33_17","NUM","33","17","17","و از قبروت هتاوه کوچ کرده، در حصیروت فرود آمدند. ");
INSERT INTO pesOPV_vpl VALUES ("NU33_18","005_33_18","NUM","33","18","18","و ازحصیروت کوچ کرده، در رتمه فرود آمدند. ");
INSERT INTO pesOPV_vpl VALUES ("NU33_19","005_33_19","NUM","33","19","19","واز رتمه کوچ کرده، و در رمون فارص فرود آمدند. ");
INSERT INTO pesOPV_vpl VALUES ("NU33_20","005_33_20","NUM","33","20","20","و از رمون فارص کوچ کرده، در لبنه فرودآمدند. ");
INSERT INTO pesOPV_vpl VALUES ("NU33_21","005_33_21","NUM","33","21","21","و از لبنه کوچ کرده، در رسه فرودآمدند. ");
INSERT INTO pesOPV_vpl VALUES ("NU33_22","005_33_22","NUM","33","22","22","و از رسه کوچ کرده، در قهیلاته فرودآمدند. ");
INSERT INTO pesOPV_vpl VALUES ("NU33_23","005_33_23","NUM","33","23","23","و از قهیلاته کوچ کرده، در جبل شافر فرود آمدند. ");
INSERT INTO pesOPV_vpl VALUES ("NU33_24","005_33_24","NUM","33","24","24","و از جبل شافر کوچ کرده، درحراده فرود آمدند. ");
INSERT INTO pesOPV_vpl VALUES ("NU33_25","005_33_25","NUM","33","25","25","و از حراده کوچ کرده، درمقهیلوت فرود آمدند. ");
INSERT INTO pesOPV_vpl VALUES ("NU33_26","005_33_26","NUM","33","26","26","و از مقهیلوت کوچ کرده، در تاحت فرود آمدند. ");
INSERT INTO pesOPV_vpl VALUES ("NU33_27","005_33_27","NUM","33","27","27","و از تاحت کوچ کرده، در تارح فرود آمدند. ");
INSERT INTO pesOPV_vpl VALUES ("NU33_28","005_33_28","NUM","33","28","28","و از تارح کوچ کرده، در متقه فرود آمدند. ");
INSERT INTO pesOPV_vpl VALUES ("NU33_29","005_33_29","NUM","33","29","29","و از متقه کوچ کرده، در حشمونه فرود آمدند. ");
INSERT INTO pesOPV_vpl VALUES ("NU33_30","005_33_30","NUM","33","30","30","و از حشمونه کوچ کرده، در مسیروت فرود آمدند. ");
INSERT INTO pesOPV_vpl VALUES ("NU33_31","005_33_31","NUM","33","31","31","و از مسیروت کوچ کرده، در بنی یعقان فرود آمدند. ");
INSERT INTO pesOPV_vpl VALUES ("NU33_32","005_33_32","NUM","33","32","32","و ازبنی یعقان کوچ کرده، در حورالجدجاد فرودآمدند. ");
INSERT INTO pesOPV_vpl VALUES ("NU33_33","005_33_33","NUM","33","33","33","و از حورالجدجاد کوچ کرده، دریطبات فرود آمدند. ");
INSERT INTO pesOPV_vpl VALUES ("NU33_34","005_33_34","NUM","33","34","34","و از یطبات کوچ کرده، درعبرونه فرود آمدند. ");
INSERT INTO pesOPV_vpl VALUES ("NU33_35","005_33_35","NUM","33","35","35","و از عبرونه کوچ کرده، درعصیون جابر فرود آمدند. ");
INSERT INTO pesOPV_vpl VALUES ("NU33_36","005_33_36","NUM","33","36","36","و از عصیون جابرکوچ کرده، در بیابان صین که قادش باشد، فرودآمدند. ");
INSERT INTO pesOPV_vpl VALUES ("NU33_37","005_33_37","NUM","33","37","37","و از قادش کوچ کرده، در جبل هور درسرحد زمین ادوم فرود آمدند. ");
INSERT INTO pesOPV_vpl VALUES ("NU33_38","005_33_38","NUM","33","38","38","هارون کاهن برحسب فرمان خداوند به جبل هور برآمده، در سال چهلم خروج بنی‌اسرائیل از زمین مصر، در روز اول ماه پنجم وفات یافت. ");
INSERT INTO pesOPV_vpl VALUES ("NU33_39","005_33_39","NUM","33","39","39","و هارون صد و بیست و سه ساله بود که در جبل هور مرد. ");
INSERT INTO pesOPV_vpl VALUES ("NU33_40","005_33_40","NUM","33","40","40","و ملک عراد کنعانی که در جنوب زمین کنعان ساکن بود از آمدن بنی‌اسرائیل اطلاع یافت. ");
INSERT INTO pesOPV_vpl VALUES ("NU33_41","005_33_41","NUM","33","41","41","پس از جبل هور کوچ کرده، در صلمونه فرود آمدند. ");
INSERT INTO pesOPV_vpl VALUES ("NU33_42","005_33_42","NUM","33","42","42","و از صلمونه کوچ کرده در فونون فرود آمدند ");
INSERT INTO pesOPV_vpl VALUES ("NU33_43","005_33_43","NUM","33","43","43","و از فونون کوچ کرده، در اوبوت فرود آمدند. ");
INSERT INTO pesOPV_vpl VALUES ("NU33_44","005_33_44","NUM","33","44","44","و از اوبوت کوچ کرده، درعیی عباریم در حدود موآب فرود آمدند. ");
INSERT INTO pesOPV_vpl VALUES ("NU33_45","005_33_45","NUM","33","45","45","و از عییم کوچ کرده، در دیبون جاد فرود آمدند. ");
INSERT INTO pesOPV_vpl VALUES ("NU33_46","005_33_46","NUM","33","46","46","واز دیبون جاد کوچ کرده، در علمون دبلاتایم فرودآمدند. ");
INSERT INTO pesOPV_vpl VALUES ("NU33_47","005_33_47","NUM","33","47","47","و از علمون دبلاتایم کوچ کرده، درکوههای عباریم در مقابل نبو فرود آمدند. ");
INSERT INTO pesOPV_vpl VALUES ("NU33_48","005_33_48","NUM","33","48","48","و ازکوههای عباریم کوچ کرده، در عربات موآب نزداردن در مقابل اریحا فرود آمدند. ");
INSERT INTO pesOPV_vpl VALUES ("NU33_49","005_33_49","NUM","33","49","49","پس نزد اردن از بیت یشیموت تا آبل شطیم در عربات موآب اردو زدند. ");
INSERT INTO pesOPV_vpl VALUES ("NU33_50","005_33_50","NUM","33","50","50","و خداوند موسی را در عربات مواب نزداردن، در مقابل اریحا خطاب کرده، گفت: ");
INSERT INTO pesOPV_vpl VALUES ("NU33_51","005_33_51","NUM","33","51","51","«بنی‌اسرائیل را خطاب کرده، به ایشان بگو: چون شما از اردن به زمین کنعان عبور کنید، ");
INSERT INTO pesOPV_vpl VALUES ("NU33_52","005_33_52","NUM","33","52","52","جمیع ساکنان زمین را از پیش روی خوداخراج نمایید، و تمامی صورتهای ایشان راخراب کنید، و تمامی بتهای ریخته شده ایشان رابشکنید، و همه مکانهای بلند ایشان را منهدم سازید. ");
INSERT INTO pesOPV_vpl VALUES ("NU33_53","005_33_53","NUM","33","53","53","و زمین را به تصرف آورده، در آن ساکن شوید، زیرا که آن زمین را به شما دادم تا مالک آن باشید. ");
INSERT INTO pesOPV_vpl VALUES ("NU33_54","005_33_54","NUM","33","54","54","و زمین را به حسب قبایل خود به قرعه تقسیم کنید، برای کثیر، نصیب او را کثیر بدهید، وبرای قلیل، نصیب او را قلیل بدهید، جایی که قرعه برای هر کس برآید از آن او باشد برحسب اسباط آبای شما آن را تقسیم نمایید. ");
INSERT INTO pesOPV_vpl VALUES ("NU33_55","005_33_55","NUM","33","55","55","و اگرساکنان زمین را از پیش روی خود اخراج ننماییدکسانی را که از ایشان باقی می‌گذارید در چشمان شما خار خواهند بود، و در پهلوهای شما تیغ وشما را در زمینی که در آن ساکن شوید، خواهندرنجانید. ");
INSERT INTO pesOPV_vpl VALUES ("NU33_56","005_33_56","NUM","33","56","56","و به همان طوری که قصد نمودم که با ایشان رفتار نمایم، با شما رفتار خواهم نمود.» ");
INSERT INTO pesOPV_vpl VALUES ("NU34_1","005_34_1","NUM","34","1","1","و خداوند موسی را خطاب کرده، گفت: ");
INSERT INTO pesOPV_vpl VALUES ("NU34_2","005_34_2","NUM","34","2","2","«بنی‌اسرائیل را امر فرموده، به ایشان بگو: چون شما به زمین کنعان داخل شوید، این است زمینی که به شما به ملکیت خواهد رسید، یعنی زمین کنعان با حدودش. ");
INSERT INTO pesOPV_vpl VALUES ("NU34_3","005_34_3","NUM","34","3","3","آنگاه حد جنوبی شما از بیابان سین بر جانب ادوم خواهد بود، و سرحد جنوبی شما از آخر بحرالملح به طرف مشرق خواهد بود. ");
INSERT INTO pesOPV_vpl VALUES ("NU34_4","005_34_4","NUM","34","4","4","و حد شما از جانب جنوب گردنه عقربیم دور خواهد زد و به سوی سین خواهدگذشت، و انتهای آن به طرف جنوب قادش برنیع خواهد بود، و نزد حصرادار بیرون رفته، تاعصمون خواهد گذشت. ");
INSERT INTO pesOPV_vpl VALUES ("NU34_5","005_34_5","NUM","34","5","5","و این حد از عصمون تاوادی مصر دور زده، انتهایش نزد دریا خواهدبود. ");
INSERT INTO pesOPV_vpl VALUES ("NU34_6","005_34_6","NUM","34","6","6","و اما حد غربی. دریای بزرگ حد شماخواهد بود. این است حد غربی شما. ");
INSERT INTO pesOPV_vpl VALUES ("NU34_7","005_34_7","NUM","34","7","7","و حد شمالی شما این باشد، از دریای بزرگ برای خود جبل هور را نشان گیرید. ");
INSERT INTO pesOPV_vpl VALUES ("NU34_8","005_34_8","NUM","34","8","8","و از جبل هور تا مدخل حمات را نشان گیرید. و انتهای این حد نزد صدد باشد. ");
INSERT INTO pesOPV_vpl VALUES ("NU34_9","005_34_9","NUM","34","9","9","و این حد نزد زفرون بیرون رود و انتهایش نزد حصر عینان باشد، این حدشمالی شما خواهد بود. ");
INSERT INTO pesOPV_vpl VALUES ("NU34_10","005_34_10","NUM","34","10","10","و برای حد مشرقی خود از حصر عینان تاشفام را نشان گیرید. ");
INSERT INTO pesOPV_vpl VALUES ("NU34_11","005_34_11","NUM","34","11","11","و این حد از شفام تا ربله به طرف شرقی عین برود، پس این حد کشیده شده به‌جانب دریای کنرت به طرف مشرق برسد. ");
INSERT INTO pesOPV_vpl VALUES ("NU34_12","005_34_12","NUM","34","12","12","واین حد تا به اردن برسد و انتهایش نزد بحرالملح باشد. این زمین برحسب حدودش به هر طرف زمین شما خواهد بود.» ");
INSERT INTO pesOPV_vpl VALUES ("NU34_13","005_34_13","NUM","34","13","13","و موسی بنی‌اسرائیل را امر کرده، گفت: «این است زمینی که شما آن را به قرعه تقسیم خواهید کرد که خداوند امر فرموده است تا به نه سبط و نصف داده شود. ");
INSERT INTO pesOPV_vpl VALUES ("NU34_14","005_34_14","NUM","34","14","14","زیرا که سبط بنی روبین برحسب خاندان آبای خود و سبط بنی جادبرحسب خاندان آبای خود، و نصف سبط منسی، نصیب خود را گرفته‌اند. ");
INSERT INTO pesOPV_vpl VALUES ("NU34_15","005_34_15","NUM","34","15","15","این دو سبط و نصف به آن طرف اردن در مقابل اریحا به‌جانب مشرق به سوی طلوع آفتاب نصیب خود را گرفته‌اند.» ");
INSERT INTO pesOPV_vpl VALUES ("NU34_16","005_34_16","NUM","34","16","16","و خداوند موسی را خطاب کرده، گفت: ");
INSERT INTO pesOPV_vpl VALUES ("NU34_17","005_34_17","NUM","34","17","17","«این است نامهای کسانی که زمین را برای شماتقسیم خواهند نمود. العازار کاهن و یوشع بن نون. ");
INSERT INTO pesOPV_vpl VALUES ("NU34_18","005_34_18","NUM","34","18","18","و یک سرور را از هر سبط برای تقسیم نمودن زمین بگیرید. ");
INSERT INTO pesOPV_vpl VALUES ("NU34_19","005_34_19","NUM","34","19","19","و این است نامهای ایشان. ازسبط یهودا کالیب بن یفنه. ");
INSERT INTO pesOPV_vpl VALUES ("NU34_20","005_34_20","NUM","34","20","20","و از سبطبنی شمعون شموئیل بن عمیهود. ");
INSERT INTO pesOPV_vpl VALUES ("NU34_21","005_34_21","NUM","34","21","21","و از سبطبنیامین الیداد بن کسلون. ");
INSERT INTO pesOPV_vpl VALUES ("NU34_22","005_34_22","NUM","34","22","22","و از سبط بنی دان رئیس بقی ابن یجلی. ");
INSERT INTO pesOPV_vpl VALUES ("NU34_23","005_34_23","NUM","34","23","23","و از بنی یوسف از سبطبنی منسی رئیس حنیئیل بن ایفود. ");
INSERT INTO pesOPV_vpl VALUES ("NU34_24","005_34_24","NUM","34","24","24","و از سبطبنی افرایم رئیس قموئیل بن شفطان. ");
INSERT INTO pesOPV_vpl VALUES ("NU34_25","005_34_25","NUM","34","25","25","و از سبطبنی زبولون رئیس الیصافان بن فرناک. ");
INSERT INTO pesOPV_vpl VALUES ("NU34_26","005_34_26","NUM","34","26","26","و از سبطبنی یساکار رئیس فلطیئیل بن عزان. ");
INSERT INTO pesOPV_vpl VALUES ("NU34_27","005_34_27","NUM","34","27","27","و از سبطبنی اشیر رئیس اخیهود بن شلومی. ");
INSERT INTO pesOPV_vpl VALUES ("NU34_28","005_34_28","NUM","34","28","28","و از سبطبنی نفتالی رئیس فدهئیل بن عمیهود.» ");
INSERT INTO pesOPV_vpl VALUES ("NU34_29","005_34_29","NUM","34","29","29","اینانندکه خداوند مامور فرمود که ملک را در زمین کنعان برای بنی‌اسرائیل تقسیم نمایند. ");
INSERT INTO pesOPV_vpl VALUES ("NU35_1","005_35_1","NUM","35","1","1","و خداوند موسی را در عربات موآب نزد اردن در مقابل اریحا خطاب کرده، گفت: ");
INSERT INTO pesOPV_vpl VALUES ("NU35_2","005_35_2","NUM","35","2","2","«بنی‌اسرائیل را امر فرما که از نصیب ملک خود شهرها برای سکونت به لاویان بدهند، ونواحی شهرها را از اطراف آنها به لاویان بدهید. ");
INSERT INTO pesOPV_vpl VALUES ("NU35_3","005_35_3","NUM","35","3","3","و شهرها بجهت سکونت ایشان باشد، و نواحی آنها برای بهایم و اموال و سایر حیوانات ایشان باشد. ");
INSERT INTO pesOPV_vpl VALUES ("NU35_4","005_35_4","NUM","35","4","4","و نواحی شهرها که به لاویان بدهید ازدیوار شهر بیرون از هر طرف هزار ذراع باشد. ");
INSERT INTO pesOPV_vpl VALUES ("NU35_5","005_35_5","NUM","35","5","5","واز بیرون شهر به طرف مشرق دو هزار ذراع، و به طرف جنوب دو هزار ذراع، و به طرف مغرب دوهزار ذراع، و به طرف شمال دو هزار ذراع بپیمایید. و شهر در وسط باشد و این نواحی شهرها برای ایشان خواهد بود. ");
INSERT INTO pesOPV_vpl VALUES ("NU35_6","005_35_6","NUM","35","6","6","«و از شهرها که به لاویان بدهید شش شهرملجا خواهد بود، و آنها را برای قاتل بدهید تا به آنجا فرار کند و سوای آنها چهل و دو شهربدهید. ");
INSERT INTO pesOPV_vpl VALUES ("NU35_7","005_35_7","NUM","35","7","7","پس جمیع شهرها که به لاویان خواهیدداد چهل و هشت شهر با نواحی آنها خواهد بود. ");
INSERT INTO pesOPV_vpl VALUES ("NU35_8","005_35_8","NUM","35","8","8","و اما شهرهایی که از ملک بنی‌اسرائیل می‌دهیداز کثیر، کثیر و از قلیل، قلیل بگیرید. هر کس به اندازه نصیب خود که یافته باشد از شهرهای خودبه لاویان بدهد.» ");
INSERT INTO pesOPV_vpl VALUES ("NU35_9","005_35_9","NUM","35","9","9","و خداوند موسی را خطاب کرده، گفت: ");
INSERT INTO pesOPV_vpl VALUES ("NU35_10","005_35_10","NUM","35","10","10","«بنی‌اسرائیل را خطاب کرده، به ایشان بگو: چون شما از اردن به زمین کنعان عبور کنید، ");
INSERT INTO pesOPV_vpl VALUES ("NU35_11","005_35_11","NUM","35","11","11","آنگاه شهرها برای خود تعیین کنید تا شهرهای ملجا برای شما باشد، تا هر قاتلی که شخصی راسهو کشته باشد، به آنجا فرار کند. ");
INSERT INTO pesOPV_vpl VALUES ("NU35_12","005_35_12","NUM","35","12","12","و این شهرها برای شما بجهت ملجا از ولی مقتول خواهد بود، تا قاتل پیش از آنکه به حضورجماعت برای داوری بایستد، نمیرد. ");
INSERT INTO pesOPV_vpl VALUES ("NU35_13","005_35_13","NUM","35","13","13","«و از شهرهایی که می‌دهید، شش شهرملجا برای شما باشد. ");
INSERT INTO pesOPV_vpl VALUES ("NU35_14","005_35_14","NUM","35","14","14","سه شهر از آنطرف اردن بدهید، و سه شهر در زمین کنعان بدهید تاشهرهای ملجا باشد. ");
INSERT INTO pesOPV_vpl VALUES ("NU35_15","005_35_15","NUM","35","15","15","بجهت بنی‌اسرائیل وغریب و کسی‌که در میان شما وطن گزیند، این شش شهر برای ملجا باشد تا هر‌که شخصی راسهو کشته باشد به آنجا فرار کند. ");
INSERT INTO pesOPV_vpl VALUES ("NU35_16","005_35_16","NUM","35","16","16","«و اگر او را به آلت آهنین زد که مرد، او قاتل است و قاتل البته کشته شود. ");
INSERT INTO pesOPV_vpl VALUES ("NU35_17","005_35_17","NUM","35","17","17","و اگر او را بادست خود به سنگی که از آن کسی کشته شود، بزند تا بمیرد، او قاتل است و قاتل البته کشته شود. ");
INSERT INTO pesOPV_vpl VALUES ("NU35_18","005_35_18","NUM","35","18","18","و اگر او را به چوب دستی که به آن کسی کشته شود، بزند تا بمیرد، او قاتل است و قاتل البته کشته شود. ");
INSERT INTO pesOPV_vpl VALUES ("NU35_19","005_35_19","NUM","35","19","19","ولی خون، خود، قاتل رابکشد. هرگاه به او برخورد، او را بکشد. ");
INSERT INTO pesOPV_vpl VALUES ("NU35_20","005_35_20","NUM","35","20","20","و اگراز روی بغض او را با تیغ زد یا قصد چیزی بر اوانداخت که مرد، ");
INSERT INTO pesOPV_vpl VALUES ("NU35_21","005_35_21","NUM","35","21","21","یا از روی عداوت او را بادست خود زد که مرد، آن زننده چون که قاتل است البته کشته شود، ولی خون هرگاه به قاتل برخورد، او را بکشد. ");
INSERT INTO pesOPV_vpl VALUES ("NU35_22","005_35_22","NUM","35","22","22","«لیکن اگر او را بدون عداوت سهو تیغ زندیا چیزی بدون قصد بر او اندازد، ");
INSERT INTO pesOPV_vpl VALUES ("NU35_23","005_35_23","NUM","35","23","23","و اگر سنگی را که کسی به آن کشته شود نادیده بر او بیندازد که بمیرد و با وی دشمنی نداشته، و بداندیش اونبوده باشد، ");
INSERT INTO pesOPV_vpl VALUES ("NU35_24","005_35_24","NUM","35","24","24","پس جماعت در میان قاتل و ولی خون برحسب این احکام داوری نمایند. ");
INSERT INTO pesOPV_vpl VALUES ("NU35_25","005_35_25","NUM","35","25","25","وجماعت، قاتل را از دست ولی خون رهایی دهند، و جماعت، وی را به شهر ملجای او که به آن فرارکرده بود برگردانند، و او در آنجا تا موت رئیس کهنه که به روغن مقدس مسح شده است، ساکن باشد. ");
INSERT INTO pesOPV_vpl VALUES ("NU35_26","005_35_26","NUM","35","26","26","و اگر قاتل وقتی از حدود شهر ملجای خود که به آن فرار کرده بود بیرون آید، ");
INSERT INTO pesOPV_vpl VALUES ("NU35_27","005_35_27","NUM","35","27","27","و ولی خون، او را بیرون حدود شهر ملجایش بیابد، پس ولی خون قاتل را بکشد؛ قصاص خون برای اونشود. ");
INSERT INTO pesOPV_vpl VALUES ("NU35_28","005_35_28","NUM","35","28","28","زیرا که می‌بایست تا وفات رئیس کهنه در شهر ملجای خود مانده باشد، و بعد ازوفات رئیس کهنه، قاتل به زمین ملک خودبرگردد. ");
INSERT INTO pesOPV_vpl VALUES ("NU35_29","005_35_29","NUM","35","29","29","«و این احکام برای شما در قرنهای شما درجمیع مسکنهای شما فریضه عدالتی خواهد بود. ");
INSERT INTO pesOPV_vpl VALUES ("NU35_30","005_35_30","NUM","35","30","30","«هر‌که شخصی را بکشد پس قاتل به گواهی شاهدان کشته شود، و یک شاهد برای کشته شدن کسی شهادت ندهد. ");
INSERT INTO pesOPV_vpl VALUES ("NU35_31","005_35_31","NUM","35","31","31","و هیچ فدیه به عوض جان قاتلی که مستوجب قتل است، مگیرید بلکه او البته کشته شود. ");
INSERT INTO pesOPV_vpl VALUES ("NU35_32","005_35_32","NUM","35","32","32","و از کسی‌که به شهر ملجای خود فرار کرده باشد فدیه مگیرید، که پیش از وفات کاهن برگردد و به زمین خودساکن شود. ");
INSERT INTO pesOPV_vpl VALUES ("NU35_33","005_35_33","NUM","35","33","33","و زمینی را که در آن ساکنید ملوث مسازید، زیرا که خون، زمین را ملوث می‌کند، وزمین را برای خونی که در آن ریخته شود، کفاره نمی توان کرد مگر به خون کسی‌که آن را ریخته باشد. ");
INSERT INTO pesOPV_vpl VALUES ("NU35_34","005_35_34","NUM","35","34","34","پس زمینی را که شما در آن ساکنید ومن در میان آن ساکن هستم نجس مسازید، زیرا من که یهوه هستم در میان بنی‌اسرائیل ساکن می‌باشم.» ");
INSERT INTO pesOPV_vpl VALUES ("NU36_1","005_36_1","NUM","36","1","1","و روسای خاندان آبای قبیله بنی جلعادبن ماکیربن منسی که از قبایل بنی یوسف بودند نزدیک آمده به حضور موسی وبه حضور سروران و روسای خاندان آبای بنی‌اسرائیل عرض کرده، ");
INSERT INTO pesOPV_vpl VALUES ("NU36_2","005_36_2","NUM","36","2","2","گفتند: «خداوند، آقای ما را امر فرمود که زمین را به قرعه تقسیم کرده، به بنی‌اسرائیل بدهد، و آقای ما از جانب خداوند مامور شده است که نصیب برادر ماصلفحاد را به دخترانش بدهد. ");
INSERT INTO pesOPV_vpl VALUES ("NU36_3","005_36_3","NUM","36","3","3","پس اگر ایشان به یکی از پسران سایر اسباط بنی‌اسرائیل منکوحه شوند، ارث ما از میراث پدران ما قطع شده، به میراث سبطی که ایشان به آن داخل شوند، اضافه خواهد شد، و از بهره میراث ما قطع خواهد شد. ");
INSERT INTO pesOPV_vpl VALUES ("NU36_4","005_36_4","NUM","36","4","4","و چون یوبیل بنی‌اسرائیل بشود ملک ایشان به ملک سبطی که به آن داخل شوند اضافه خواهدشد، و ملک ایشان از ملک پدران ما قطع خواهدشد.» ");
INSERT INTO pesOPV_vpl VALUES ("NU36_5","005_36_5","NUM","36","5","5","پس موسی بنی‌اسرائیل را برحسب قول خداوند امر فرموده، گفت: «سبط بنی یوسف راست گفتند. ");
INSERT INTO pesOPV_vpl VALUES ("NU36_6","005_36_6","NUM","36","6","6","این است آنچه خداوند درباره دختران صلفحاد امر فرموده، گفته است: به هر‌که در نظر ایشان پسند آید، به زنی داده شوند، لیکن در قبیله سبط پدران خود فقط به نکاح داده شوند. ");
INSERT INTO pesOPV_vpl VALUES ("NU36_7","005_36_7","NUM","36","7","7","پس میراث بنی‌اسرائیل از سبط به سبط منتقل نشود، بلکه هر یکی از بنی‌اسرائیل به میراث سبطپدران خود ملصق باشند. ");
INSERT INTO pesOPV_vpl VALUES ("NU36_8","005_36_8","NUM","36","8","8","و هر دختری که وارث ملکی از اسباط بنی‌اسرائیل بشود، به کسی از قبیله سبط پدر خود به زنی داده شود، تا هریکی از بنی‌اسرائیل وارث ملک آبای خود گردند. ");
INSERT INTO pesOPV_vpl VALUES ("NU36_9","005_36_9","NUM","36","9","9","و ملک از یک سبط به سبط دیگر منتقل نشود، بلکه هرکس از اسباط بنی‌اسرائیل به میراث خودملصق باشند.» ");
INSERT INTO pesOPV_vpl VALUES ("NU36_10","005_36_10","NUM","36","10","10","پس چنانکه خداوند موسی را امر فرمود، دختران صلفحاد چنان کردند. ");
INSERT INTO pesOPV_vpl VALUES ("NU36_11","005_36_11","NUM","36","11","11","و دختران صلفحاد، محله و ترصه و حجله و ملکه و نوعه به پسران عموهای خود به زنی داده شدند. ");
INSERT INTO pesOPV_vpl VALUES ("NU36_12","005_36_12","NUM","36","12","12","درقبایل بنی منسی ابن یوسف منکوحه شدند وملک ایشان در سبط قبیله پدر ایشان باقی ماند. ");
INSERT INTO pesOPV_vpl VALUES ("NU36_13","005_36_13","NUM","36","13","13","این است اوامر و احکامی که خداوند به واسطه موسی در عربات موآب نزد اردن در مقابل اریحا به بنی‌اسرائیل امر فرمود. ");
INSERT INTO pesOPV_vpl VALUES ("DT1_1","006_1_1","DEU","1","1","1","اردن، در بیابان عربه مقابل سوف، در میان فاران و توفل و لابان و حضیروت و دی ذهب باتمامی اسرائیل گفت. ");
INSERT INTO pesOPV_vpl VALUES ("DT1_2","006_1_2","DEU","1","2","2","از حوریب به راه جبل سعیر تا قادش برنیع، سفر یازده روزه است. ");
INSERT INTO pesOPV_vpl VALUES ("DT1_3","006_1_3","DEU","1","3","3","پس در روز اول ماه یازدهم سال چهلم، موسی بنی‌اسرائیل را برحسب هرآنچه خداوند او رابرای ایشان امر فرموده بود تکلم نمود، ");
INSERT INTO pesOPV_vpl VALUES ("DT1_4","006_1_4","DEU","1","4","4","بعد ازآنکه سیحون ملک اموریان را که در حشبون ساکن بود و عوج ملک باشان را که در عشتاروت درادرعی ساکن بود، کشته بود. ");
INSERT INTO pesOPV_vpl VALUES ("DT1_5","006_1_5","DEU","1","5","5","به آن طرف اردن درزمین موآب، موسی به بیان کردن این شریعت شروع کرده، گفت: دستور ترک حوریب ");
INSERT INTO pesOPV_vpl VALUES ("DT1_6","006_1_6","DEU","1","6","6","یهوه خدای ما، ما را در حوریب خطاب کرده، گفت: «توقف شما در این کوه بس شده است. ");
INSERT INTO pesOPV_vpl VALUES ("DT1_7","006_1_7","DEU","1","7","7","پس توجه نموده، کوچ کنید و به کوهستان اموریان، و جمیع حوالی آن از عربه و کوهستان وهامون و جنوب و کناره دریا، یعنی زمین کنعانیان و لبنان تا نهر بزرگ که نهر فرات باشد، داخل شوید. ");
INSERT INTO pesOPV_vpl VALUES ("DT1_8","006_1_8","DEU","1","8","8","اینک زمین را پیش روی شما گذاشتم. پس داخل شده، زمینی را که خداوند برای پدران شما، ابراهیم و اسحاق و یعقوب، قسم خورد که به ایشان و بعد از آنها به ذریت ایشان بدهد، به تصرف آورید.» ");
INSERT INTO pesOPV_vpl VALUES ("DT1_9","006_1_9","DEU","1","9","9","و در آن وقت به شما متکلم شده، گفتم: «من به تنهایی نمی توانم متحمل شما باشم. ");
INSERT INTO pesOPV_vpl VALUES ("DT1_10","006_1_10","DEU","1","10","10","یهوه خدای شما، شما را افزوده است و اینک شماامروز مثل ستارگان آسمان کثیر هستید. ");
INSERT INTO pesOPV_vpl VALUES ("DT1_11","006_1_11","DEU","1","11","11","یهوه خدای پدران شما، شما را هزار چندان‌که هستیدبیفزاید و شما را برحسب آنچه به شما گفته است، برکت دهد. ");
INSERT INTO pesOPV_vpl VALUES ("DT1_12","006_1_12","DEU","1","12","12","لیکن من چگونه به تنهایی متحمل محنت و بار و منازعت شما بشوم. ");
INSERT INTO pesOPV_vpl VALUES ("DT1_13","006_1_13","DEU","1","13","13","پس مردان حکیم و عاقل و معروف از اسباط خود بیاورید، تاایشان را بر شما روسا سازم.» ");
INSERT INTO pesOPV_vpl VALUES ("DT1_14","006_1_14","DEU","1","14","14","و شما در جواب من گفتید: «سخنی که گفتی نیکو است که بکنیم.» ");
INSERT INTO pesOPV_vpl VALUES ("DT1_15","006_1_15","DEU","1","15","15","پس روسای اسباط شما را که مردان حکیم ومعروف بودند گرفته، ایشان را بر شما روساساختم، تا سروران هزاره‌ها و سروران صدها وسروران پنجاهها و سروران دهها و ناظران اسباطشما باشند. ");
INSERT INTO pesOPV_vpl VALUES ("DT1_16","006_1_16","DEU","1","16","16","و در آنوقت داوران شما را امرکرده، گفتم: دعوای برادران خود را بشنوید، و درمیان هرکس و برادرش و غریبی که نزد وی باشدبه انصاف داوری نمایید. ");
INSERT INTO pesOPV_vpl VALUES ("DT1_17","006_1_17","DEU","1","17","17","و در داوری طرف داری مکنید، کوچک را مثل بزرگ بشنویدو از روی انسان مترسید، زیرا که داوری از آن خداست، و هر دعوایی که برای شما مشکل است، نزد من بیاورید تا آن را بشنوم. ");
INSERT INTO pesOPV_vpl VALUES ("DT1_18","006_1_18","DEU","1","18","18","و آن وقت همه‌چیزهایی را که باید بکنید، برای شما امر فرمودم. ");
INSERT INTO pesOPV_vpl VALUES ("DT1_19","006_1_19","DEU","1","19","19","پس از حوریب کوچ کرده، از تمامی این بیابان بزرگ و ترسناک که شما دیدید به راه کوهستان اموریان رفتیم، چنانکه یهوه خدای ما به ما امر فرمود و به قادش برنیع رسیدیم. ");
INSERT INTO pesOPV_vpl VALUES ("DT1_20","006_1_20","DEU","1","20","20","و به شما گفتم: «به کوهستان اموریانی که یهوه خدای ما به ما می‌دهد، رسیده‌اید. ");
INSERT INTO pesOPV_vpl VALUES ("DT1_21","006_1_21","DEU","1","21","21","اینک یهوه خدای تو، این زمین را پیش روی تو گذاشته است، پس برآی و چنانکه یهوه خدای پدرانت به تو گفته است، آن را به تصرف آور و ترسان و هراسان مباش.» ");
INSERT INTO pesOPV_vpl VALUES ("DT1_22","006_1_22","DEU","1","22","22","آنگاه جمیع شما نزد من آمده، گفتید: «مردان چند، پیش روی خود بفرستیم تا زمین رابرای ما جاسوسی نمایند، و ما را از راهی که بایدبرویم و از شهرهایی که به آنها می‌رویم، خبربیاورند.» ");
INSERT INTO pesOPV_vpl VALUES ("DT1_23","006_1_23","DEU","1","23","23","و این سخن مرا پسند آمد، پس دوازده نفر از شما، یعنی یکی را از هر سبطگرفتم، ");
INSERT INTO pesOPV_vpl VALUES ("DT1_24","006_1_24","DEU","1","24","24","و ایشان متوجه راه شده، به کوه برآمدند و به وادی اشکول رسیده، آن راجاسوسی نمودند. ");
INSERT INTO pesOPV_vpl VALUES ("DT1_25","006_1_25","DEU","1","25","25","و از میوه زمین به‌دست خود گرفته، آن را نزد ما آوردند، و ما را مخبرساخته، گفتند: «زمینی که یهوه خدای ما، به مامی دهد، نیکوست.» ");
INSERT INTO pesOPV_vpl VALUES ("DT1_26","006_1_26","DEU","1","26","26","لیکن شما نخواستید که بروید، بلکه ازفرمان خداوند عصیان ورزیدید. ");
INSERT INTO pesOPV_vpl VALUES ("DT1_27","006_1_27","DEU","1","27","27","و درخیمه های خود همهمه کرده، گفتید: «چونکه خداوند ما را دشمن داشت، ما را از زمین مصربیرون آورد، تا ما را به‌دست اموریان تسلیم کرده، هلاک سازد. ");
INSERT INTO pesOPV_vpl VALUES ("DT1_28","006_1_28","DEU","1","28","28","و حال کجا برویم چونکه برادران ما دل ما را گداخته، گفتند که این قوم از ما بزرگتر وبلندترند و شهرهای ایشان بزرگ و تا آسمان حصاردار است، و نیز بنی عناق را در آنجادیده‌ایم.» ");
INSERT INTO pesOPV_vpl VALUES ("DT1_29","006_1_29","DEU","1","29","29","پس من به شما گفتم: «مترسید و ازایشان هراسان مباشید. ");
INSERT INTO pesOPV_vpl VALUES ("DT1_30","006_1_30","DEU","1","30","30","یهوه خدای شما که پیش روی شما می‌رود برای شما جنگ خواهدکرد، برحسب هرآنچه به نظر شما در مصر برای شما کرده است.» ");
INSERT INTO pesOPV_vpl VALUES ("DT1_31","006_1_31","DEU","1","31","31","و هم در بیابان که در آنجادیدید چگونه یهوه خدای تو مثل کسی‌که پسرخود را می‌برد تو را در تمامی راه که می‌رفتیدبرمی داشت تا به اینجا رسیدید. ");
INSERT INTO pesOPV_vpl VALUES ("DT1_32","006_1_32","DEU","1","32","32","لیکن با وجوداین، همه شما به یهوه خدای خود ایمان نیاوردید. ");
INSERT INTO pesOPV_vpl VALUES ("DT1_33","006_1_33","DEU","1","33","33","که پیش روی شما در راه می‌رفت تاجایی برای نزول شما بطلبد، وقت شب در آتش تا راهی را که به آن بروید به شما بنماید و وقت روز در ابر. ");
INSERT INTO pesOPV_vpl VALUES ("DT1_34","006_1_34","DEU","1","34","34","و خداوند آواز سخنان شما را شنیده، غضبناک شد، و قسم خورده، گفت: ");
INSERT INTO pesOPV_vpl VALUES ("DT1_35","006_1_35","DEU","1","35","35","«هیچکدام از این مردمان و از این طبقه شریر، آن زمین نیکو راکه قسم خوردم که به پدران شما بدهم، هرگزنخواهند دید. ");
INSERT INTO pesOPV_vpl VALUES ("DT1_36","006_1_36","DEU","1","36","36","سوای کالیب بن یفنه که آن راخواهد دید و زمینی را که در آن رفته بود، به وی وبه پسرانش خواهم داد، چونکه خداوند را پیروی کامل نمود.» ");
INSERT INTO pesOPV_vpl VALUES ("DT1_37","006_1_37","DEU","1","37","37","و خداوند بخاطر شما برمن نیزخشم نموده، گفت که «تو هم داخل آنجا نخواهی شد. ");
INSERT INTO pesOPV_vpl VALUES ("DT1_38","006_1_38","DEU","1","38","38","یوشع بن نون که بحضور تو می‌ایستدداخل آنجا خواهد شد، پس او را قوی گردان زیرا اوست که آن را برای بنی‌اسرائیل تقسیم خواهد نمود. ");
INSERT INTO pesOPV_vpl VALUES ("DT1_39","006_1_39","DEU","1","39","39","و اطفال شما که درباره آنها گفتید که به یغما خواهند رفت، و پسران شماکه امروز نیک و بد را تمیز نمی دهند، داخل آنجاخواهند شد، و آن را به ایشان خواهم داد تا مالک آن بشوند. ");
INSERT INTO pesOPV_vpl VALUES ("DT1_40","006_1_40","DEU","1","40","40","و اما شما روگردانیده از راه بحرقلزم به بیابان کوچ کنید.» ");
INSERT INTO pesOPV_vpl VALUES ("DT1_41","006_1_41","DEU","1","41","41","و شما در جواب من گفتید که «به خداوندگناه ورزیده‌ایم، پس رفته، جنگ خواهیم کرد، موافق هرآنچه یهوه خدای ما به ما امر فرموده است، و همه شما اسلحه جنگ خود را بسته، عزیمت کردید که به کوه برآیید. ");
INSERT INTO pesOPV_vpl VALUES ("DT1_42","006_1_42","DEU","1","42","42","آنگاه خداوندبه من گفت: «به ایشان بگو که نروند و جنگ منمایند زیرا که من در میان شما نیستم، مبادا ازحضور دشمنان خود مغلوب شوید.» ");
INSERT INTO pesOPV_vpl VALUES ("DT1_43","006_1_43","DEU","1","43","43","پس به شما گفتم، لیکن نشنیدید، بلکه از فرمان خداوندعصیان ورزیدید، و مغرور شده، به فراز کوه برآمدید. ");
INSERT INTO pesOPV_vpl VALUES ("DT1_44","006_1_44","DEU","1","44","44","و اموریانی که در آن کوه ساکن بودندبه مقابله شما بیرون آمده، شما را تعاقب نمودند، بطوری که زنبورها می‌کنند و شما را از سعیر تاحرما شکست دادند. ");
INSERT INTO pesOPV_vpl VALUES ("DT1_45","006_1_45","DEU","1","45","45","پس برگشته، به حضورخداوند گریه نمودید، اما خداوند آواز شما رانشنید و به شما گوش نداد. ");
INSERT INTO pesOPV_vpl VALUES ("DT1_46","006_1_46","DEU","1","46","46","و در قادش برحسب ایام توقف خود، روزهای بسیار ماندید. ");
INSERT INTO pesOPV_vpl VALUES ("DT2_1","006_2_1","DEU","2","1","1","پس برگشته، چنانکه خداوند به من گفته بود، از راه بحرقلزم در بیابان کوچ کردیم وروزهای بسیار کوه سعیر را دور زدیم. ");
INSERT INTO pesOPV_vpl VALUES ("DT2_2","006_2_2","DEU","2","2","2","پس خداوند مرا خطاب کرده، گفت: ");
INSERT INTO pesOPV_vpl VALUES ("DT2_3","006_2_3","DEU","2","3","3","«دور زدن شمابه این کوه بس است، بسوی شمال برگردید. ");
INSERT INTO pesOPV_vpl VALUES ("DT2_4","006_2_4","DEU","2","4","4","وقوم را امر فرموده، بگو که شما از حدود برادران خود بنی عیسو که در سعیر ساکنند باید بگذرید، و ایشان از شما خواهند ترسید، پس بسیاراحتیاط کنید. ");
INSERT INTO pesOPV_vpl VALUES ("DT2_5","006_2_5","DEU","2","5","5","و با ایشان منازعه مکنید، زیرا که از زمین ایشان بقدر کف پایی هم به شما نخواهم داد، چونکه کوه سعیر را به عیسو به ملکیت داده‌ام. ");
INSERT INTO pesOPV_vpl VALUES ("DT2_6","006_2_6","DEU","2","6","6","خوراک را از ایشان به نقره خریده، بخورید و آب را نیز از ایشان به نقره خریده، بنوشید.» ");
INSERT INTO pesOPV_vpl VALUES ("DT2_7","006_2_7","DEU","2","7","7","زیرا که یهوه خدای تو، تو را در همه کارهای دستت برکت داده است، او راه رفتنت رادر این بیابان بزرگ می‌داند، الان چهل سال است که یهوه خدایت با تو بوده است و به هیچ‌چیزمحتاج نشده‌ای. ");
INSERT INTO pesOPV_vpl VALUES ("DT2_8","006_2_8","DEU","2","8","8","پس از برادران خود بنی عیسوکه در سعیر ساکنند، از راه عربه از ایلت و عصیون جابر عبور نمودیم. ");
INSERT INTO pesOPV_vpl VALUES ("DT2_9","006_2_9","DEU","2","9","9","پس برگشته، از راه بیابان موآب گذشتیم، وخداوند مرا گفت: «موآب را اذیت مرسان و باایشان منازعت و جنگ منما، زیرا که از زمین ایشان هیچ نصیبی به شما نخواهم داد، چونکه عاررا به بنی لوط برای ملکیت داده‌ام.» ");
INSERT INTO pesOPV_vpl VALUES ("DT2_10","006_2_10","DEU","2","10","10","ایمیان که قوم عظیم و کثیر و بلند قد مثل عناقیان بودند، پیش در آنجا سکونت داشتند. ");
INSERT INTO pesOPV_vpl VALUES ("DT2_11","006_2_11","DEU","2","11","11","ایشان نیز مثل عناقیان از رفائیان محسوب بودند، لیکن موآبیان ایشان را ایمیان می‌خوانند. ");
INSERT INTO pesOPV_vpl VALUES ("DT2_12","006_2_12","DEU","2","12","12","و حوریان در سعیرپیشتر ساکن بودند، و بنی عیسو ایشان را اخراج نموده، ایشان را از پیش روی خود هلاک ساختند، و در جای ایشان ساکن شدند، چنانکه اسرائیل به زمین میراث خود که خداوند به ایشان داده بود، کردند. ");
INSERT INTO pesOPV_vpl VALUES ("DT2_13","006_2_13","DEU","2","13","13","الان برخیزید و از وادی زاردعبور نمایید. پس از وادی زارد عبور نمودیم. ");
INSERT INTO pesOPV_vpl VALUES ("DT2_14","006_2_14","DEU","2","14","14","وایامی که از قادش برنیع راه می‌رفتیم تا از وادی زارد عبور نمودیم سی و هشت سال بود، تاتمامی آن طبقه مردان جنگی از میان اردو تمام شدند، چنانکه خداوند برای ایشان قسم خورده بود. ");
INSERT INTO pesOPV_vpl VALUES ("DT2_15","006_2_15","DEU","2","15","15","و دست خداوند نیز بر ایشان می‌بود تاایشان را از میان اردو بالکل هلاک کند. ");
INSERT INTO pesOPV_vpl VALUES ("DT2_16","006_2_16","DEU","2","16","16","پس چون جمیع مردان جنگی از میان قوم بالکل مردند، ");
INSERT INTO pesOPV_vpl VALUES ("DT2_17","006_2_17","DEU","2","17","17","آنگاه خداوند مرا خطاب کرده، گفت: ");
INSERT INTO pesOPV_vpl VALUES ("DT2_18","006_2_18","DEU","2","18","18","«تو امروز از عار که سرحد موآب باشد، باید بگذری. ");
INSERT INTO pesOPV_vpl VALUES ("DT2_19","006_2_19","DEU","2","19","19","و چون به مقابل بنی عمون برسی ایشان را مرنجان و با ایشان منازعه مکن، زیرا که اززمین بنی عمون نصیبی به تو نخواهم داد چونکه آن را به بنی لوط به ملکیت داده‌ام. ");
INSERT INTO pesOPV_vpl VALUES ("DT2_20","006_2_20","DEU","2","20","20","(آن نیز زمین رفائیان شمرده می‌شود و رفائیان پیشتر ساکن آنجا بودند، لیکن عمونیان ایشان را زمزمیان می‌خوانند. ");
INSERT INTO pesOPV_vpl VALUES ("DT2_21","006_2_21","DEU","2","21","21","ایشان قومی عظیم و کثیر و بلند قدمثل عناقیان بودند، و خداوند آنها را از پیش روی ایشان هلاک کرد، پس ایشان را اخراج نموده، درجای ایشان ساکن شدند. ");
INSERT INTO pesOPV_vpl VALUES ("DT2_22","006_2_22","DEU","2","22","22","چنانکه برای بنی عیسو که در سعیر ساکنند عمل نموده، حوریان را از حضور ایشان هلاک ساخته، آنها رااخراج نمودند، و تا امروز در جای ایشان ساکنند. ");
INSERT INTO pesOPV_vpl VALUES ("DT2_23","006_2_23","DEU","2","23","23","و عویان را که در دهات تا به غزا ساکن بودندکفتوریان که از کفتور بیرون آمدند هلاک ساخته، در جای ایشان ساکن شدند. ) ");
INSERT INTO pesOPV_vpl VALUES ("DT2_24","006_2_24","DEU","2","24","24","پس برخیزید وکوچ کرده، از وادی ارنون عبور کنید، اینک سیحون اموری ملک حشبون و زمین او را به‌دست تو دادم، به تصرف آن شروع کن و با ایشان جنگ نما. ");
INSERT INTO pesOPV_vpl VALUES ("DT2_25","006_2_25","DEU","2","25","25","امروز شروع کرده، خوف و ترس تورا بر قومهای زیر تمام آسمان مستولی می‌گردانم، و ایشان آوازه تو را شنیده، خواهندلرزید، و از ترس تو مضطرب خواهند شد.» ");
INSERT INTO pesOPV_vpl VALUES ("DT2_26","006_2_26","DEU","2","26","26","پس قاصدان با سخنان صلح‌آمیز از بیابان قدیموت نزد سیحون ملک حشبون فرستاده، گفتم: ");
INSERT INTO pesOPV_vpl VALUES ("DT2_27","006_2_27","DEU","2","27","27","«اجازت بده که از زمین تو بگذرم، به شاهراه خواهم رفت و به طرف راست یا چپ میل نخواهم کرد. ");
INSERT INTO pesOPV_vpl VALUES ("DT2_28","006_2_28","DEU","2","28","28","خوراک را به نقره به من بفروش تابخورم، و آب را به نقره به من بده تا بنوشم، فقطاجازت بده تا بر پایهای خود بگذرم. ");
INSERT INTO pesOPV_vpl VALUES ("DT2_29","006_2_29","DEU","2","29","29","چنانکه بنی عیسو که در سعیر ساکنند و موآبیان که در عارساکنند به من رفتار نمودند، تا از اردن به زمینی که یهوه خدای ما به ما می‌دهد، عبور نمایم.» ");
INSERT INTO pesOPV_vpl VALUES ("DT2_30","006_2_30","DEU","2","30","30","اماسیحون ملک حشبون نخواست که ما را از سرحدخود راه بدهد، زیرا که یهوه خدای تو روح او رابه قساوت و دل او را به سختی واگذاشت، تا او راچنانکه امروز شده است، به‌دست تو تسلیم نماید. ");
INSERT INTO pesOPV_vpl VALUES ("DT2_31","006_2_31","DEU","2","31","31","و خداوند مرا گفت: «اینک به تسلیم نمودن سیحون و زمین او به‌دست تو شروع کردم، پس بنابه تصرف آن بنما تا زمین او را مالک شوی.» ");
INSERT INTO pesOPV_vpl VALUES ("DT2_32","006_2_32","DEU","2","32","32","آنگاه سیحون با تمامی قوم خود به مقابله مابرای جنگ کردن در یاهص بیرون آمدند. ");
INSERT INTO pesOPV_vpl VALUES ("DT2_33","006_2_33","DEU","2","33","33","ویهوه خدای ما او را به‌دست ما تسلیم نموده، او رابا پسرانش و جمیع قومش زدیم. ");
INSERT INTO pesOPV_vpl VALUES ("DT2_34","006_2_34","DEU","2","34","34","و تمامی شهرهای او را در آنوقت گرفته، مردان و زنان واطفال هر شهر را هلاک کردیم که یکی را باقی نگذاشتیم. ");
INSERT INTO pesOPV_vpl VALUES ("DT2_35","006_2_35","DEU","2","35","35","لیکن بهایم را با غنیمت شهرهایی که گرفته بودیم، برای خود به غارت بردیم. ");
INSERT INTO pesOPV_vpl VALUES ("DT2_36","006_2_36","DEU","2","36","36","ازعروعیر که برکناره وادی ارنون است، و شهری که در وادی است، تا جلعاد قریه‌ای نبود که به ماممتنع باشد، یهوه خدای ما همه را به ما تسلیم نمود. ");
INSERT INTO pesOPV_vpl VALUES ("DT2_37","006_2_37","DEU","2","37","37","لیکن به زمین بنی عمون و به تمامی کناره وادی یبوق و شهرهای کوهستان، و به هر جایی که یهوه خدای ما نهی فرموده بود، نزدیک نشدیم. ");
INSERT INTO pesOPV_vpl VALUES ("DT3_1","006_3_1","DEU","3","1","1","پس برگشته، به راه باشان رفتیم، و عوج ملک باشان با تمامی قوم خود به مقابله مابیرون آمده، در ادرعی جنگ کرد. ");
INSERT INTO pesOPV_vpl VALUES ("DT3_2","006_3_2","DEU","3","2","2","و خداوند مراگفت: «از او مترس زیرا که او و تمامی قومش وزمینش را به‌دست تو تسلیم نموده‌ام، تا بطوری که با سیحون ملک اموریان که در حشبون ساکن بود، عمل نمودی، با وی نیز عمل نمایی.» ");
INSERT INTO pesOPV_vpl VALUES ("DT3_3","006_3_3","DEU","3","3","3","پس یهوه، خدای ما، عوج ملک باشان را نیز و تمامی قومش را به‌دست ما تسلیم نموده، او را به حدی شکست دادیم که احدی از برای وی باقی نماند. ");
INSERT INTO pesOPV_vpl VALUES ("DT3_4","006_3_4","DEU","3","4","4","و در آنوقت همه شهرهایش را گرفتیم، وشهری نماند که از ایشان نگرفتیم، یعنی شصت شهر و تمامی مرزبوم ارجوب که مملکت عوج در باشان بود. ");
INSERT INTO pesOPV_vpl VALUES ("DT3_5","006_3_5","DEU","3","5","5","جمیع اینها شهرهای حصاردار بادیوارهای بلند و دروازه‌ها و پشت بندها بود، سوای قرای بی‌حصار بسیار کثیر. ");
INSERT INTO pesOPV_vpl VALUES ("DT3_6","006_3_6","DEU","3","6","6","و آنها رابالکل هلاک کردیم، چنانکه با سیحون، ملک حشبون کرده بودیم، هر شهر را با مردان و زنان واطفال هلاک ساختیم. ");
INSERT INTO pesOPV_vpl VALUES ("DT3_7","006_3_7","DEU","3","7","7","و تمامی بهایم و غنیمت شهرها را برای خود به غارت بردیم. ");
INSERT INTO pesOPV_vpl VALUES ("DT3_8","006_3_8","DEU","3","8","8","و در آن وقت زمین را از دست دو ملک اموریان که به آن طرف اردن بودند، از وادی ارنون تا جبل حرمون، گرفتیم. ");
INSERT INTO pesOPV_vpl VALUES ("DT3_9","006_3_9","DEU","3","9","9","(و این حرمون راصیدونیان سریون می‌خوانند و اموریان آن راسنیر می‌خوانند. ) ");
INSERT INTO pesOPV_vpl VALUES ("DT3_10","006_3_10","DEU","3","10","10","تمام شهرهای هامون وتمامی جلعاد و تمامی باشان تا سلخه و ادرعی که شهرهای مملکت عوج در باشان بود. ");
INSERT INTO pesOPV_vpl VALUES ("DT3_11","006_3_11","DEU","3","11","11","زیرا که عوج ملک باشان از بقیه رفائیان تنها باقی‌مانده بود. اینک تخت خواب او تخت آهنین است آیاآن در ربت بنی عمون نیست. و طولش نه ذراع وعرضش چهار ذراع برحسب ذراع آدمی می‌باشد. ");
INSERT INTO pesOPV_vpl VALUES ("DT3_12","006_3_12","DEU","3","12","12","و این زمین را در آن وقت به تصرف آوردیم، و آن را از عروعیر که برکنار وادی ارنون است و نصف کوهستان جلعاد؛ و شهرهایش را به روبینیان و جادیان دادم. ");
INSERT INTO pesOPV_vpl VALUES ("DT3_13","006_3_13","DEU","3","13","13","و بقیه جلعاد و تمامی باشان را که مملکت عوج باشد به نصف سبطمنسی دادم، یعنی تمامی مرزبوم ارجوب را باتمامی باشان که زمین رفائیان نامیده می‌شود. ");
INSERT INTO pesOPV_vpl VALUES ("DT3_14","006_3_14","DEU","3","14","14","یائیر بن منسی تمامی مرزبوم ارجوب را تا حدجشوریان و معکیان گرفت، و آنها را تا امروز به اسم خود باشان، حووت یائیر نامید. ");
INSERT INTO pesOPV_vpl VALUES ("DT3_15","006_3_15","DEU","3","15","15","و جلعادرا به ماکیر دادم. ");
INSERT INTO pesOPV_vpl VALUES ("DT3_16","006_3_16","DEU","3","16","16","و به روبینیان و جادیان، ازجلعاد تا وادی ارنون، هم وسط وادی و هم کناره‌اش تا وادی یبوق را که حد بنی عمون باشد، دادم. ");
INSERT INTO pesOPV_vpl VALUES ("DT3_17","006_3_17","DEU","3","17","17","و عربه را نیز و اردن و کناره‌اش را ازکنرت تا دریای عربه که بحرالملح باشد، زیردامنه های فسجه به طرف مشرق دادم. ");
INSERT INTO pesOPV_vpl VALUES ("DT3_18","006_3_18","DEU","3","18","18","و در آن وقت به شما امر فرموده، گفتم: «یهوه خدای شما این زمین را به شما داده است تاآن را به تصرف آورید، پس جمیع مردان جنگی شما مهیا شده، پیش روی برادران خود، بنی‌اسرائیل، عبور کنید. ");
INSERT INTO pesOPV_vpl VALUES ("DT3_19","006_3_19","DEU","3","19","19","لیکن زنان و اطفال ومواشی شما، چونکه می‌دانم مواشی بسیار دارید، در شهرهای شما که به شما دادم، بمانند. ");
INSERT INTO pesOPV_vpl VALUES ("DT3_20","006_3_20","DEU","3","20","20","تاخداوند به برادران شما مثل شما آرامی دهد، وایشان نیز زمینی را که یهوه خدای شما به آنطرف اردن به ایشان می‌دهد، به تصرف آورند، آنگاه هریکی از شما به ملک خود که به شما دادم، برگردید.» ");
INSERT INTO pesOPV_vpl VALUES ("DT3_21","006_3_21","DEU","3","21","21","و در آن وقت یوشع را امر فرموده، گفتم: «هرآنچه یهوه، خدای شما، به این دوپادشاه کرده است، چشمان تو دید، پس خداوندبا تمامی ممالکی که بسوی آنها عبور می‌کنی، چنین خواهد کرد. ");
INSERT INTO pesOPV_vpl VALUES ("DT3_22","006_3_22","DEU","3","22","22","از ایشان مترسید زیرا که یهوه خدای شماست که برای شما جنگ می‌کند.» ");
INSERT INTO pesOPV_vpl VALUES ("DT3_23","006_3_23","DEU","3","23","23","و در آنوقت نزد خداوند استغاثه کرده، گفتم: ");
INSERT INTO pesOPV_vpl VALUES ("DT3_24","006_3_24","DEU","3","24","24","«ای خداوند یهوه تو به نشان دادن عظمت و دست قوی خود به بنده ات شروع کرده‌ای، زیرا کدام خداست در آسمان یا در زمین که مثل اعمال و جبروت تو می‌تواند عمل نماید. ");
INSERT INTO pesOPV_vpl VALUES ("DT3_25","006_3_25","DEU","3","25","25","تمنا اینکه عبور نمایم و زمین نیکو را که به آنطرف اردن است و این کوه نیکو و لبنان را ببینم.» ");
INSERT INTO pesOPV_vpl VALUES ("DT3_26","006_3_26","DEU","3","26","26","لیکن خداوند بخاطر شما با من غضبناک شده، مرا اجابت ننمود و خداوند مرا گفت: «تو را کافی است. بار دیگر درباره این امر با من سخن مگو. ");
INSERT INTO pesOPV_vpl VALUES ("DT3_27","006_3_27","DEU","3","27","27","به قله فسجه برآی و چشمان خود را به طرف مغرب و شمال و جنوب و مشرق بلند کرده، به چشمان خود ببین، زیرا که از این اردن نخواهی گذشت. ");
INSERT INTO pesOPV_vpl VALUES ("DT3_28","006_3_28","DEU","3","28","28","اما یوشع را امر فرموده، او را دلیر وقوی گردان، زیرا که او پیش این قوم عبور نموده، زمینی را که تو خواهی دید، برای ایشان تقسیم خواهد نمود.» ");
INSERT INTO pesOPV_vpl VALUES ("DT3_29","006_3_29","DEU","3","29","29","پس در دره، در برابر بیت فغورتوقف نمودیم. ");
INSERT INTO pesOPV_vpl VALUES ("DT4_1","006_4_1","DEU","4","1","1","پس الان‌ای اسرائیل، فرایض و احکامی راکه من به شما تعلیم می‌دهم تا آنها را بجاآورید بشنوید، تا زنده بمانید و داخل شده، زمینی را که یهوه، خدای پدران شما، به شمامی دهد به تصرف آورید. ");
INSERT INTO pesOPV_vpl VALUES ("DT4_2","006_4_2","DEU","4","2","2","بر کلامی که من به شماامر می‌فرمایم چیزی میفزایید و چیزی از آن کم منمایید، تا اوامر یهوه خدای خود را که به شماامر می‌فرمایم، نگاه دارید. ");
INSERT INTO pesOPV_vpl VALUES ("DT4_3","006_4_3","DEU","4","3","3","چشمان شما آنچه راخداوند در بعل فغور کرد دید، زیرا هرکه پیروی بعل فغور کرد، یهوه خدای تو، او را از میان توهلاک ساخت. ");
INSERT INTO pesOPV_vpl VALUES ("DT4_4","006_4_4","DEU","4","4","4","اما جمیع شما که به یهوه خدای خود ملصق شدید، امروز زنده ماندید. ");
INSERT INTO pesOPV_vpl VALUES ("DT4_5","006_4_5","DEU","4","5","5","اینک چنانکه یهوه، خدایم، مرا امر فرموده است، فرایض و احکام به شما تعلیم نمودم، تا درزمینی که شما داخل آن شده، به تصرف می‌آورید، چنان عمل نمایید. ");
INSERT INTO pesOPV_vpl VALUES ("DT4_6","006_4_6","DEU","4","6","6","پس آنها را نگاه داشته، بجا آورید زیرا که این حکمت و فطانت شماست، در نظر قومهایی که چون این فرایض رابشنوند، خواهند گفت: «هرآینه این طایفه‌ای بزرگ، قوم حکیم، و فطانت پیشه‌اند.» ");
INSERT INTO pesOPV_vpl VALUES ("DT4_7","006_4_7","DEU","4","7","7","زیرا کدام قوم بزرگ است که خدا نزدیک ایشان باشدچنانکه یهوه، خدای ما است، در هروقت که نزداو دعا می‌کنیم؟ ");
INSERT INTO pesOPV_vpl VALUES ("DT4_8","006_4_8","DEU","4","8","8","و کدام طایفه بزرگ است که فرایض و احکام عادله‌ای مثل تمام این شریعتی که من امروز پیش شما می‌گذارم، دارند؟ ");
INSERT INTO pesOPV_vpl VALUES ("DT4_9","006_4_9","DEU","4","9","9","لیکن احتراز نما و خویشتن را بسیار متوجه باش، مبادا این چیزهایی را که چشمانت دیده است فراموش کنی و مبادا اینها در تمامی ایام عمرت از دل تو محو شود، بلکه آنها را به پسرانت و پسران پسرانت تعلیم ده. ");
INSERT INTO pesOPV_vpl VALUES ("DT4_10","006_4_10","DEU","4","10","10","در روزی که درحضور یهوه خدای خود در حوریب ایستاده بودی و خداوند به من گفت: «قوم را نزد من جمع کن تا کلمات خود را به ایشان بشنوانم، تا بیاموزندکه در تمامی روزهایی که برروی زمین زنده باشنداز من بترسند، و پسران خود را تعلیم دهند.» ");
INSERT INTO pesOPV_vpl VALUES ("DT4_11","006_4_11","DEU","4","11","11","وشما نزدیک آمده، زیر کوه ایستادید، و کوه تا به وسط آسمان به آتش و تاریکی و ابرها و ظلمت غلیظ می‌سوخت. ");
INSERT INTO pesOPV_vpl VALUES ("DT4_12","006_4_12","DEU","4","12","12","و خداوند با شما از میان آتش متکلم شد، و شما آواز کلمات را شنیدید، لیکن صورتی ندیدید، بلکه فقط آواز را شنیدید. ");
INSERT INTO pesOPV_vpl VALUES ("DT4_13","006_4_13","DEU","4","13","13","و عهد خود را که شما را به نگاه داشتن آن مامور فرمود، برای شما بیان کرد، یعنی ده کلمه را و آنها را بر دو لوح سنگ نوشت. ");
INSERT INTO pesOPV_vpl VALUES ("DT4_14","006_4_14","DEU","4","14","14","و خداوندمرا در آنوقت امر فرمود که فرایض و احکام را به شما تعلیم دهم، تا آنها را در زمینی که برای تصرفش به آن عبور می‌کنید، بجا آورید. ");
INSERT INTO pesOPV_vpl VALUES ("DT4_15","006_4_15","DEU","4","15","15","پس خویشتن را بسیار متوجه باشید، زیرادر روزی که خداوند با شما در حوریب از میان آتش تکلم می‌نمود، هیچ صورتی ندیدید. ");
INSERT INTO pesOPV_vpl VALUES ("DT4_16","006_4_16","DEU","4","16","16","مبادا فاسد شوید و برای خود صورت تراشیده، یا تمثال هر شکلی از شبیه ذکور یا اناث بسازید. ");
INSERT INTO pesOPV_vpl VALUES ("DT4_17","006_4_17","DEU","4","17","17","یا شبیه هر بهیمه‌ای که بر روی زمین است، یا شبیه هر مرغ بالدار که در آسمان می‌پرد. ");
INSERT INTO pesOPV_vpl VALUES ("DT4_18","006_4_18","DEU","4","18","18","یا شبیه هر خزنده‌ای بر زمین یا شبیه هرماهی‌ای که در آبهای زیر زمین است. ");
INSERT INTO pesOPV_vpl VALUES ("DT4_19","006_4_19","DEU","4","19","19","و مباداچشمان خود را بسوی آسمان بلند کنی، و آفتاب و ماه و ستارگان و جمیع جنود آسمان را دیده، فریفته شوی و سجده کرده، آنها را که یهوه خدایت برای تمامی قومهایی که زیر تمام آسمانند، تقسیم کرده است، عبادت نمایی. ");
INSERT INTO pesOPV_vpl VALUES ("DT4_20","006_4_20","DEU","4","20","20","لیکن خداوند شما را گرفته، از کوره آهن ازمصر بیرون آورد تا برای او قوم میراث باشید، چنانکه امروز هستید. ");
INSERT INTO pesOPV_vpl VALUES ("DT4_21","006_4_21","DEU","4","21","21","و خداوند بخاطر شما بر من غضبناک شده، قسم خورد که از اردن عبور نکنم و به آن زمین نیکو که یهوه خدایت به تو برای ملکیت می‌دهد، داخل نشوم. ");
INSERT INTO pesOPV_vpl VALUES ("DT4_22","006_4_22","DEU","4","22","22","بلکه من در این زمین خواهم مرد واز اردن عبور نخواهم کرد، لیکن شما عبورخواهید کرد، و آن زمین نیکو را به تصرف خواهیدآورد. ");
INSERT INTO pesOPV_vpl VALUES ("DT4_23","006_4_23","DEU","4","23","23","پس احتیاط نمایید، مبادا عهد یهوه، خدای خود را که با شما بسته است فراموش نمایید، و صورت تراشیده یا شبیه هر چیزی که یهوه خدایت به تو نهی کرده است، برای خودبسازی. ");
INSERT INTO pesOPV_vpl VALUES ("DT4_24","006_4_24","DEU","4","24","24","زیرا که یهوه خدایت آتش سوزنده وخدای غیور است. ");
INSERT INTO pesOPV_vpl VALUES ("DT4_25","006_4_25","DEU","4","25","25","چون پسران و پسران پسران را تولیدنموده، و در زمین مدتی ساکن باشید، اگر فاسدشده، صورت تراشیده، و شبیه هرچیزی رابسازید و آنچه در نظر یهوه خدای شما بد است بجا آورده، او را غضبناک سازید، ");
INSERT INTO pesOPV_vpl VALUES ("DT4_26","006_4_26","DEU","4","26","26","آسمان وزمین را امروز بر شما شاهد می‌آورم که از آن زمینی که برای تصرف آن از اردن بسوی آن عبورمی کنید البته هلاک خواهید شد. و روزهای خودرا در آن طویل نخواهید ساخت، بلکه بالکل هلاک خواهید شد. ");
INSERT INTO pesOPV_vpl VALUES ("DT4_27","006_4_27","DEU","4","27","27","و خداوند شما را در میان قومها پراکنده خواهد نمود، و شما در میان طوایفی که خداوند شما را به آنجا می‌برد، قلیل العدد خواهید ماند. ");
INSERT INTO pesOPV_vpl VALUES ("DT4_28","006_4_28","DEU","4","28","28","و در آنجا خدایان ساخته شده دست انسان از چوپ و سنگ راعبادت خواهید کرد، که نمی بینند و نمی شنوند ونمی خورند و نمی بویند. ");
INSERT INTO pesOPV_vpl VALUES ("DT4_29","006_4_29","DEU","4","29","29","لیکن اگر از آنجا یهوه خدای خود را بطلبی، او را خواهی یافت. بشرطی که او را به تمامی دل و به تمامی جان خود تفحص نمایی. ");
INSERT INTO pesOPV_vpl VALUES ("DT4_30","006_4_30","DEU","4","30","30","چون در تنگی گرفتار شوی، و جمیع این وقایع برتو عارض شود، در ایام آخر بسوی یهوه خدای خود برگشته، آواز او را خواهی شنید. ");
INSERT INTO pesOPV_vpl VALUES ("DT4_31","006_4_31","DEU","4","31","31","زیرا که یهوه خدای تو خدای رحیم است، تو را ترک نخواهد کرد و تو را هلاک نخواهد نمود، و عهد پدرانت را که برای ایشان قسم خورده بود، فراموش نخواهد کرد. ");
INSERT INTO pesOPV_vpl VALUES ("DT4_32","006_4_32","DEU","4","32","32","زیرا که از ایام پیشین که قبل از تو بوده است از روزی که خدا آدم را برزمین آفرید، و از یک کناره آسمان تا به کناره دیگر بپرس که آیا مثل این امر عظیم واقع شده یا مثل این شنیده شده است؟ ");
INSERT INTO pesOPV_vpl VALUES ("DT4_33","006_4_33","DEU","4","33","33","آیا قومی هرگز آواز خدا را که از میان آتش متکلم شود، شنیده باشند و زنده بمانند، چنانکه تو شنیدی؟ ");
INSERT INTO pesOPV_vpl VALUES ("DT4_34","006_4_34","DEU","4","34","34","و آیا خدا عزیمت کرد که برود وقومی برای خود از میان قوم دیگر بگیرد باتجربه‌ها و آیات و معجزات و جنگ و دست قوی و بازوی دراز شده و ترسهای عظیم، موافق هرآنچه یهوه خدای شما برای شما در مصر درنظر شما بعمل آورد؟ ");
INSERT INTO pesOPV_vpl VALUES ("DT4_35","006_4_35","DEU","4","35","35","این برتو ظاهر شد تابدانی که یهوه خداست و غیر از او دیگری نیست. ");
INSERT INTO pesOPV_vpl VALUES ("DT4_36","006_4_36","DEU","4","36","36","از آسمان آواز خود را به تو شنوانید تا تو راتادیب نماید، و برزمین آتش عظیم خود را به تونشان داد و کلام او را از میان آتش شنیدی. ");
INSERT INTO pesOPV_vpl VALUES ("DT4_37","006_4_37","DEU","4","37","37","و ازاین جهت که پدران تو را دوست داشته، ذریت ایشان را بعد از ایشان برگزیده بود، تو را به حضرت خود با قوت عظیم از مصر بیرون آورد. ");
INSERT INTO pesOPV_vpl VALUES ("DT4_38","006_4_38","DEU","4","38","38","تا امتهای بزرگتر و عظیم تر از تو را پیش روی تو بیرون نماید و تو را درآورده، زمین ایشان رابرای ملکیت به تو دهد، چنانکه امروز شده است. ");
INSERT INTO pesOPV_vpl VALUES ("DT4_39","006_4_39","DEU","4","39","39","لهذا امروز بدان و دردل خود نگاه دار که یهوه خداست، بالا در آسمان و پایین برروی زمین ودیگری نیست. ");
INSERT INTO pesOPV_vpl VALUES ("DT4_40","006_4_40","DEU","4","40","40","و فرایض و اوامر او را که من امروز به تو امر می‌فرمایم نگاهدار، تا تو را و بعداز تو فرزندان تو را نیکو باشد و تا روزهای خود رابر زمینی که یهوه خدایت به تو می‌دهد تا به ابدطویل نمایی. ");
INSERT INTO pesOPV_vpl VALUES ("DT4_41","006_4_41","DEU","4","41","41","آنگاه موسی سه شهر به آن طرف اردن بسوی مشرق آفتاب جدا کرد. ");
INSERT INTO pesOPV_vpl VALUES ("DT4_42","006_4_42","DEU","4","42","42","تا قاتلی که همسایه خود را نادانسته کشته باشد و پیشتر باوی بغض نداشته به آنها فرار کند، و به یکی از این شهرها فرار کرده، زنده ماند. ");
INSERT INTO pesOPV_vpl VALUES ("DT4_43","006_4_43","DEU","4","43","43","یعنی باصر دربیابان، در زمین همواری به جهت روبینیان، وراموت در جلعاد به جهت جادیان، و جولان درباشان به جهت منسیان. ");
INSERT INTO pesOPV_vpl VALUES ("DT4_44","006_4_44","DEU","4","44","44","و این است شریعتی که موسی پیش روی بنی‌اسرائیل نهاد. ");
INSERT INTO pesOPV_vpl VALUES ("DT4_45","006_4_45","DEU","4","45","45","این است شهادات و فرایض و احکامی که موسی به بنی‌اسرائیل گفت، وقتی که ایشان از مصر بیرون آمدند. ");
INSERT INTO pesOPV_vpl VALUES ("DT4_46","006_4_46","DEU","4","46","46","به آنطرف اردن در دره مقابل بیت فغور در زمین سیحون، ملک اموریان که در حشبون ساکن بود، و موسی وبنی‌اسرائیل چون از مصر بیرون آمده بودند او رامغلوب ساختند. ");
INSERT INTO pesOPV_vpl VALUES ("DT4_47","006_4_47","DEU","4","47","47","و زمین او را و زمین عوج ملک باشان را، دو ملک اموریانی که به آنطرف اردن بسوی مشرق آفتاب بودند، به تصرف آوردند. ");
INSERT INTO pesOPV_vpl VALUES ("DT4_48","006_4_48","DEU","4","48","48","از عروعیر که بر کناره وادی ارنون است تا جبل سیئون که حرمون باشد. ");
INSERT INTO pesOPV_vpl VALUES ("DT4_49","006_4_49","DEU","4","49","49","و تمامی عربه به آنطرف اردن بسوی مشرق تا دریای عربه زیر دامنه های فسجه. ");
INSERT INTO pesOPV_vpl VALUES ("DT5_1","006_5_1","DEU","5","1","1","و موسی تمامی بنی‌اسرائیل را خوانده، به ایشان گفت: ای اسرائیل فرایض و احکامی را که من امروز به گوش شما می‌گویم بشنوید، تاآنها را یاد گرفته، متوجه باشید که آنها را بجاآورید. ");
INSERT INTO pesOPV_vpl VALUES ("DT5_2","006_5_2","DEU","5","2","2","یهوه خدای ما با ما در حوریب عهدبست. ");
INSERT INTO pesOPV_vpl VALUES ("DT5_3","006_5_3","DEU","5","3","3","خداوند این عهد را با پدران ما نبست، بلکه با ما که جمیع امروز در اینجا زنده هستیم. ");
INSERT INTO pesOPV_vpl VALUES ("DT5_4","006_5_4","DEU","5","4","4","خداوند در کوه از میان آتش با شما روبرومتکلم شد. ");
INSERT INTO pesOPV_vpl VALUES ("DT5_5","006_5_5","DEU","5","5","5","(من در آن وقت میان خداوند و شماایستاده بودم، تا کلام خداوند را برای شما بیان کنم، زیرا که شما به‌سبب آتش می‌ترسیدید و به فراز کوه برنیامدید) و گفت: ");
INSERT INTO pesOPV_vpl VALUES ("DT5_6","006_5_6","DEU","5","6","6","«من هستم یهوه، خدای تو، که تو را از زمین مصر از خانه بندگی بیرون آوردم. ");
INSERT INTO pesOPV_vpl VALUES ("DT5_7","006_5_7","DEU","5","7","7","تو را به حضور من خدایان دیگر نباشند. ");
INSERT INTO pesOPV_vpl VALUES ("DT5_8","006_5_8","DEU","5","8","8","«به جهت خود صورت تراشیده یا هیچ تمثالی از آنچه بالا در آسمان، یا از آنچه پایین درزمین، یا از آنچه در آبهای زیر زمین است مساز. ");
INSERT INTO pesOPV_vpl VALUES ("DT5_9","006_5_9","DEU","5","9","9","آنها را سجده و عبادت منما. زیرا من که یهوه خدای تو هستم، خدای غیورم، و گناه پدران را برپسران تا پشت سوم و چهارم از آنانی که مرادشمن دارند، می‌رسانم. ");
INSERT INTO pesOPV_vpl VALUES ("DT5_10","006_5_10","DEU","5","10","10","و رحمت می‌کنم تاهزار پشت برآنانی که مرا دوست دارند و احکام مرا نگاه دارند. ");
INSERT INTO pesOPV_vpl VALUES ("DT5_11","006_5_11","DEU","5","11","11","«نام یهوه خدای خود را به باطل مبر، زیراخداوند کسی را که نام او را به باطل برد، بی‌گناه نخواهد شمرد. ");
INSERT INTO pesOPV_vpl VALUES ("DT5_12","006_5_12","DEU","5","12","12","«روز سبت را نگاه دار و آن را تقدیس نما، چنانکه یهوه خدایت به تو امر فرموده است. ");
INSERT INTO pesOPV_vpl VALUES ("DT5_13","006_5_13","DEU","5","13","13","شش روز مشغول باش و هرکار خود را بکن. ");
INSERT INTO pesOPV_vpl VALUES ("DT5_14","006_5_14","DEU","5","14","14","اما روز هفتمین سبت یهوه خدای توست، درآن هیچکاری مکن، تو و پسرت و دخترت وغلامت و کنیزت و گاوت و الاغت و همه بهایمت و مهمانت که در اندرون دروازه های تو باشد، تاغلامت و کنیزت مثل تو آرام گیرند. ");
INSERT INTO pesOPV_vpl VALUES ("DT5_15","006_5_15","DEU","5","15","15","و بیاد آورکه در زمین مصر غلام بودی، و یهوه خدایت تو رابه‌دست قوی و بازوی دراز از آنجا بیرون آورد، بنابراین یهوه، خدایت، تو را امر فرموده است که روز سبت را نگاه داری. ");
INSERT INTO pesOPV_vpl VALUES ("DT5_16","006_5_16","DEU","5","16","16","«پدر و مادر خود را حرمت دار، چنانکه یهوه خدایت تو را امر فرموده است، تا روزهایت دراز شود و تو را در زمینی که یهوه خدایت به تومی بخشد، نیکویی باشد. ");
INSERT INTO pesOPV_vpl VALUES ("DT5_17","006_5_17","DEU","5","17","17","«قتل مکن. ");
INSERT INTO pesOPV_vpl VALUES ("DT5_18","006_5_18","DEU","5","18","18","و زنا مکن. ");
INSERT INTO pesOPV_vpl VALUES ("DT5_19","006_5_19","DEU","5","19","19","و دزدی مکن. ");
INSERT INTO pesOPV_vpl VALUES ("DT5_20","006_5_20","DEU","5","20","20","و بر همسایه خود شهادت دروغ مده. ");
INSERT INTO pesOPV_vpl VALUES ("DT5_21","006_5_21","DEU","5","21","21","وبرزن هسمایه ات طمع مورز، و به خانه همسایه ات و به مزرعه او و به غلامش و کنیزش وگاوش و الاغش و به هرچه از آن همسایه توباشد، طمع مکن.» ");
INSERT INTO pesOPV_vpl VALUES ("DT5_22","006_5_22","DEU","5","22","22","این سخنان را خداوند به تمامی جماعت شما در کوه از میان آتش و ابر و ظلمت غلیظ به آواز بلند گفت، و بر آنها چیزی نیفزود و آنها را بردو لوح سنگ نوشته، به من داد. ");
INSERT INTO pesOPV_vpl VALUES ("DT5_23","006_5_23","DEU","5","23","23","و چون شما آن آواز را از میان تاریکی شنیدید، و کوه به آتش می‌سوخت، شما با جمیع روسای اسباط ومشایخ خود نزد من آمده، ");
INSERT INTO pesOPV_vpl VALUES ("DT5_24","006_5_24","DEU","5","24","24","گفتید: اینک یهوه، خدای ما، جلال و عظمت خود را بر ما ظاهرکرده است، و آواز او را از میان آتش شنیدیم، پس امروز دیدیم که خدا با انسان سخن می‌گوید وزنده است. ");
INSERT INTO pesOPV_vpl VALUES ("DT5_25","006_5_25","DEU","5","25","25","و اما الان چرا بمیریم زیرا که این آتش عظیم ما را خواهد سوخت، اگر آواز یهوه خدای خود را دیگر بشنویم، خواهیم مرد. ");
INSERT INTO pesOPV_vpl VALUES ("DT5_26","006_5_26","DEU","5","26","26","زیرا از تمامی بشر کیست که مثل ما آوازخدای حی را که از میان آتش سخن گوید، بشنودو زنده ماند؟ ");
INSERT INTO pesOPV_vpl VALUES ("DT5_27","006_5_27","DEU","5","27","27","تو نزدیک برو و هرآنچه یهوه خدای ما بگوید، بشنو و هرآنچه یهوه خدای مابه تو بگوید برای ما بیان کن، پس خواهیم شنید وبه عمل خواهیم آورد. ");
INSERT INTO pesOPV_vpl VALUES ("DT5_28","006_5_28","DEU","5","28","28","و خداوند آواز سخنان شما را که به من گفتید شنید، و خداوند مرا گفت: «آواز سخنان این قوم را که به تو گفتند، شنیدم؛ هرچه گفتندنیکو گفتند. ");
INSERT INTO pesOPV_vpl VALUES ("DT5_29","006_5_29","DEU","5","29","29","کاش که دلی را مثل این داشتند تااز من می‌ترسیدند، و تمامی اوامر مرا در هر وقت بجا می‌آوردند، تا ایشان را و فرزندان ایشان را تابه ابد نیکو باشد. ");
INSERT INTO pesOPV_vpl VALUES ("DT5_30","006_5_30","DEU","5","30","30","برو و ایشان را بگو به خیمه های خود برگردید. ");
INSERT INTO pesOPV_vpl VALUES ("DT5_31","006_5_31","DEU","5","31","31","و اما تو در اینجاپیش من بایست، تا جمیع اوامر و فرایض واحکامی را که می‌باید به ایشان تعلیم دهی به توبگویم، و آنها را در زمینی که من به ایشان می‌دهم تا در آن تصرف نمایید، بجا آورند.» ");
INSERT INTO pesOPV_vpl VALUES ("DT5_32","006_5_32","DEU","5","32","32","«پس توجه نمایید تا آنچه یهوه، خدای شما، به شما امر فرموده است، به عمل آورید، وبه راست و چپ انحراف منمایید. ");
INSERT INTO pesOPV_vpl VALUES ("DT5_33","006_5_33","DEU","5","33","33","در تمامی آن طریقی که یهوه، خدای شما، به شما امرفرموده است، سلوک نمایید، تا برای شما نیکوباشد و ایام خود را در زمینی که به تصرف خواهیدآورد، طویل نمایید. ");
INSERT INTO pesOPV_vpl VALUES ("DT6_1","006_6_1","DEU","6","1","1","و این است اوامر و فرایض و احکامی که یهوه، خدای شما، امر فرمود که به شماتعلیم داده شود، تا آنها را در زمینی که شما بسوی آن برای تصرفش عبور می‌کنید، بجا آورید. ");
INSERT INTO pesOPV_vpl VALUES ("DT6_2","006_6_2","DEU","6","2","2","و تااز یهوه خدای خود ترسان شده، جمیع فرایض واوامر او را که من به شما امر می‌فرمایم نگاه داری، تو و پسرت و پسر پسرت، در تمامی ایام عمرت و تا عمر تو دراز شود. ");
INSERT INTO pesOPV_vpl VALUES ("DT6_3","006_6_3","DEU","6","3","3","پس‌ای اسرائیل بشنو، و به عمل نمودن آن متوجه باش، تا برای تو نیکوباشد، و بسیار افزوده شوی در زمینی که به شیر وشهد جاری است، چنانکه یهوه خدای پدرانت تورا وعده داده است. ");
INSERT INTO pesOPV_vpl VALUES ("DT6_4","006_6_4","DEU","6","4","4","‌ای اسرائیل بشنو، یهوه، خدای ما، یهوه واحد است. ");
INSERT INTO pesOPV_vpl VALUES ("DT6_5","006_6_5","DEU","6","5","5","پس یهوه خدای خود را به تمامی جان و تمامی قوت خود محبت نما. ");
INSERT INTO pesOPV_vpl VALUES ("DT6_6","006_6_6","DEU","6","6","6","و این سخنانی که من امروز تو را امر می‌فرمایم، بر دل توباشد. ");
INSERT INTO pesOPV_vpl VALUES ("DT6_7","006_6_7","DEU","6","7","7","و آنها را به پسرانت به دقت تعلیم نما، وحین نشستنت در خانه، و رفتنت به راه، و وقت خوابیدن و برخاستنت از آنها گفتگو نما. ");
INSERT INTO pesOPV_vpl VALUES ("DT6_8","006_6_8","DEU","6","8","8","و آنهارا بردست خود برای علامت ببند، و در میان چشمانت عصابه باشد. ");
INSERT INTO pesOPV_vpl VALUES ("DT6_9","006_6_9","DEU","6","9","9","و آنها را بر باهوهای درخانه ات و بر دروازه هایت بنویس. ");
INSERT INTO pesOPV_vpl VALUES ("DT6_10","006_6_10","DEU","6","10","10","و چون یهوه، خدایت، تو را به زمینی که برای پدرانت ابراهیم و اسحاق و یعقوب قسم خورد که به تو بدهد، درآورد، به شهرهای بزرگ وخوشنمایی که تو بنا نکرده‌ای، ");
INSERT INTO pesOPV_vpl VALUES ("DT6_11","006_6_11","DEU","6","11","11","و به خانه های پر از هر چیز نیکو که پر نکرده‌ای، و حوضهای کنده شده‌ای که نکنده‌ای، و تاکستانها و باغهای زیتونی که غرس ننموده‌ای، و از آنها خورده، سیرشدی. ");
INSERT INTO pesOPV_vpl VALUES ("DT6_12","006_6_12","DEU","6","12","12","آنگاه با حذر باش مبادا خداوند را که تورا از زمین مصر، از خانه بندگی بیرون آورد، فراموش کنی. ");
INSERT INTO pesOPV_vpl VALUES ("DT6_13","006_6_13","DEU","6","13","13","از یهوه خدای خود بترس و اورا عبادت نما و به نام او قسم بخور. ");
INSERT INTO pesOPV_vpl VALUES ("DT6_14","006_6_14","DEU","6","14","14","خدایان دیگر را از خدایان طوایفی که به اطراف تومی باشند، پیروی منمایید. ");
INSERT INTO pesOPV_vpl VALUES ("DT6_15","006_6_15","DEU","6","15","15","زیرا یهوه خدای تودر میان تو خدای غیور است، مبادا غضب یهوه، خدایت، برتو افروخته شود، و تو را از روی زمین هلاک سازد. ");
INSERT INTO pesOPV_vpl VALUES ("DT6_16","006_6_16","DEU","6","16","16","یهوه خدای خود را میازمایید، چنانکه او رادر مسا آزمودید. ");
INSERT INTO pesOPV_vpl VALUES ("DT6_17","006_6_17","DEU","6","17","17","توجه نمایید تا اوامر یهوه خدای خود را و شهادات و فرایض او را که به شما امر فرموده است، نگاه دارید. ");
INSERT INTO pesOPV_vpl VALUES ("DT6_18","006_6_18","DEU","6","18","18","و آنچه درنظر خداوند راست و نیکوست، به عمل آور تابرای تو نیکو شود، و داخل شده آن زمین نیکو راکه خداوند برای پدرانت قسم خورد به تصرف آوری. ");
INSERT INTO pesOPV_vpl VALUES ("DT6_19","006_6_19","DEU","6","19","19","و تا جمیع دشمنانت را از حضورت اخراج نماید، چنانکه خداوند گفته است. ");
INSERT INTO pesOPV_vpl VALUES ("DT6_20","006_6_20","DEU","6","20","20","چون پسر تو در ایام آینده از تو سوال نموده، گوید که مراد از این شهادات و فرایض واحکامی که یهوه خدای ما به شما امر فرموده است، چیست؟ ");
INSERT INTO pesOPV_vpl VALUES ("DT6_21","006_6_21","DEU","6","21","21","پس به پسر خود بگو: ما درمصر غلام فرعون بودیم، و خداوند ما را از مصر بادست قوی بیرون آورد. ");
INSERT INTO pesOPV_vpl VALUES ("DT6_22","006_6_22","DEU","6","22","22","و خداوند آیات ومعجزات عظیم و ردی‌ای بر مصر و فرعون وتمامی اهل خانه او در نظر ما ظاهر ساخت. ");
INSERT INTO pesOPV_vpl VALUES ("DT6_23","006_6_23","DEU","6","23","23","وما را از آنجا بیرون آورد تا ما را به زمینی که برای پدران ما قسم خورد که به ما بدهد، درآورد. ");
INSERT INTO pesOPV_vpl VALUES ("DT6_24","006_6_24","DEU","6","24","24","وخداوند ما را مامور داشت که تمام این فرایض رابجا آورده، از یهوه خدای خود بترسیم، تا برای ماهمیشه نیکو باشد و ما را زنده نگاه دارد، چنانکه تاامروز شده است. ");
INSERT INTO pesOPV_vpl VALUES ("DT6_25","006_6_25","DEU","6","25","25","و برای ما عدالت خواهد بودکه متوجه شویم که جمیع این اوامر را به حضوریهوه خدای خود بجا آوریم، چنانکه ما را امرفرموده است. ");
INSERT INTO pesOPV_vpl VALUES ("DT7_1","006_7_1","DEU","7","1","1","چون یهوه، خدایت، تو را به زمینی که برای تصرفش به آنجا می‌روی درآورد، وامتهای بسیار را که حتیان و جرجاشیان و اموریان و کنعانیان و فرزیان و حویان و یبوسیان، هفت امت بزرگتر و عظیم تر از تو باشند، از پیش تواخراج نماید. ");
INSERT INTO pesOPV_vpl VALUES ("DT7_2","006_7_2","DEU","7","2","2","و چون یهوه خدایت، ایشان را به‌دست تو تسلیم نماید، و تو ایشان را مغلوب سازی، آنگاه ایشان را بالکل هلاک کن، و با ایشان عهد مبند و بر ایشان ترحم منما. ");
INSERT INTO pesOPV_vpl VALUES ("DT7_3","006_7_3","DEU","7","3","3","و با ایشان مصاهرت منما؛ دختر خود را به پسر ایشان مده، و دختر ایشان را برای پسر خود مگیر. ");
INSERT INTO pesOPV_vpl VALUES ("DT7_4","006_7_4","DEU","7","4","4","زیراکه اولاد تو را از متابعت من برخواهند گردانید، تاخدایان غیر را عبادت نمایند، و غضب خداوندبرشما افروخته شده، شما را بزودی هلاک خواهد ساخت. ");
INSERT INTO pesOPV_vpl VALUES ("DT7_5","006_7_5","DEU","7","5","5","بلکه با ایشان چنین عمل نمایید؛ مذبحهای ایشان را منهدم سازید، وتمثالهای ایشان را بشکنید و اشیریم ایشان را قطع نمایید، و بتهای تراشیده ایشان را به آتش بسوزانید. ");
INSERT INTO pesOPV_vpl VALUES ("DT7_6","006_7_6","DEU","7","6","6","زیرا که تو برای یهوه، خدایت، قوم مقدس هستی. یهوه خدایت تو را برگزیده است تااز جمیع قومهایی که بر روی زمین‌اند، قوم مخصوص برای خود او باشی. ");
INSERT INTO pesOPV_vpl VALUES ("DT7_7","006_7_7","DEU","7","7","7","خداوند دل خود را با شما نبست و شما رابرنگزید از این سبب که از سایر قومها کثیرتربودید، زیرا که شما از همه قومها قلیلتر بودید. ");
INSERT INTO pesOPV_vpl VALUES ("DT7_8","006_7_8","DEU","7","8","8","لیکن از این جهت که خداوند شما را دوست می‌داشت، و می‌خواست قسم خود را که برای پدران شما خورده بود، بجا آورد، پس خداوند شما را با دست قوی بیرون آورد، و از خانه بندگی از دست فرعون، پادشاه مصر، فدیه داد. ");
INSERT INTO pesOPV_vpl VALUES ("DT7_9","006_7_9","DEU","7","9","9","پس بدان که یهوه، خدای تو، اوست خدا، خدای امین که عهد و رحمت خود را با آنانی که او را دوست می‌دارند و اوامر او را بجا می‌آورند تا هزار پشت نگاه می‌دارد. ");
INSERT INTO pesOPV_vpl VALUES ("DT7_10","006_7_10","DEU","7","10","10","و آنانی را که او را دشمن دارند، بر روی ایشان مکافات رسانیده، ایشان را هلاک می‌سازد. و به هرکه او را دشمن دارد، تاخیرننموده، او را بر رویش مکافات خواهد رسانید. ");
INSERT INTO pesOPV_vpl VALUES ("DT7_11","006_7_11","DEU","7","11","11","پس اوامر و فرایض و احکامی را که من امروزبه جهت عمل نمودن به تو امر می‌فرمایم نگاه دار. ");
INSERT INTO pesOPV_vpl VALUES ("DT7_12","006_7_12","DEU","7","12","12","پس اگر این احکام را بشنوید و آنها را نگاه داشته، بجا آورید، آنگاه یهوه خدایت عهد ورحمت را که برای پدرانت قسم خورده است، باتو نگاه خواهد داشت. ");
INSERT INTO pesOPV_vpl VALUES ("DT7_13","006_7_13","DEU","7","13","13","و تو را دوست داشته، برکت خواهد داد، و خواهد افزود، و میوه بطن توو میوه زمین تو را و غله و شیره و روغن تو را ونتاج رمه تو را و بچه های گله تو را، در زمینی که برای پدرانت قسم خورد که به تو بدهد، برکت خواهد داد. ");
INSERT INTO pesOPV_vpl VALUES ("DT7_14","006_7_14","DEU","7","14","14","از همه قومها مبارک تر خواهی شد، و در میان شما و بهایم شما، نر یا ماده، نازادنخواهد بود. ");
INSERT INTO pesOPV_vpl VALUES ("DT7_15","006_7_15","DEU","7","15","15","و خداوند هر بیماری را از تو دورخواهد کرد، و هیچکدام از مرضهای بد مصر راکه می‌دانی، برتو عارض نخواهد گردانید، بلکه برتمامی دشمنانت آنها را خواهد آورد. ");
INSERT INTO pesOPV_vpl VALUES ("DT7_16","006_7_16","DEU","7","16","16","وتمامی قومها را که یهوه بدست تو تسلیم می‌کندهلاک ساخته، چشم تو برآنها ترحم ننماید، وخدایان ایشان را عبادت منما، مبادا برای تو دام باشد. ");
INSERT INTO pesOPV_vpl VALUES ("DT7_17","006_7_17","DEU","7","17","17","و اگر در دلت گویی که این قومها از من زیاده‌اند، چگونه توانم ایشان را اخراج نمایم؟ ");
INSERT INTO pesOPV_vpl VALUES ("DT7_18","006_7_18","DEU","7","18","18","از ایشان مترس بلکه آنچه را یهوه خدایت بافرعون و جمیع مصریان کرد، نیکو بیاد آور. ");
INSERT INTO pesOPV_vpl VALUES ("DT7_19","006_7_19","DEU","7","19","19","یعنی تجربه های عظیمی را که چشمانت دیده است، و آیات و معجزات و دست قوی و بازوی دراز را که یهوه، خدایت، تو را به آنها بیرون آورد. پس یهوه، خدایت، با همه قومهایی که از آنهامی ترسی، چنین خواهد کرد. ");
INSERT INTO pesOPV_vpl VALUES ("DT7_20","006_7_20","DEU","7","20","20","و یهوه خدایت نیز زنبورها در میان ایشان خواهد فرستاد، تاباقی ماندگان و پنهان شدگان ایشان از حضور توهلاک شوند. ");
INSERT INTO pesOPV_vpl VALUES ("DT7_21","006_7_21","DEU","7","21","21","از ایشان مترس زیرا یهوه خدایت که در میان توست، خدای عظیم و مهیب است. ");
INSERT INTO pesOPV_vpl VALUES ("DT7_22","006_7_22","DEU","7","22","22","و یهوه، خدایت، این قومها را از حضورتو به تدریج اخراج خواهد نمود، ایشان را بزودی نمی توانی تلف نمایی مبادا وحوش صحرا برتوزیاد شوند. ");
INSERT INTO pesOPV_vpl VALUES ("DT7_23","006_7_23","DEU","7","23","23","لیکن یهوه خدایت، ایشان را به‌دست تو تسلیم خواهد کرد، و ایشان را به اضطراب عظیمی پریشان خواهد نمود تا هلاک شوند. ");
INSERT INTO pesOPV_vpl VALUES ("DT7_24","006_7_24","DEU","7","24","24","و ملوک ایشان را بدست تو تسلیم خواهد نمود، تا نام ایشان را از زیر آسمان محوسازی، و کسی یارای مقاومت با تو نخواهدداشت تا ایشان را هلاک سازی. ");
INSERT INTO pesOPV_vpl VALUES ("DT7_25","006_7_25","DEU","7","25","25","و تمثالهای خدایان ایشان را به آتش بسوزانید، به نقره وطلایی که بر آنهاست، طمع مورز، و برای خودمگیر، مبادا از آنها به دام گرفتار شوی، چونکه نزد یهوه، خدای تو، مکروه است. ");
INSERT INTO pesOPV_vpl VALUES ("DT7_26","006_7_26","DEU","7","26","26","و چیزمکروه را به خانه خود میاور، مبادا مثل آن حرام شوی، از آن نهایت نفرت و کراهت دار چونکه حرام است. ");
INSERT INTO pesOPV_vpl VALUES ("DT8_1","006_8_1","DEU","8","1","1","تمامی اوامری را که من امروز به شما امرمی فرمایم، حفظ داشته، بجا آورید، تا زنده مانده، زیاد شوید، و به زمینی که خداوند برای پدران شما قسم خورده بود، داخل شده، در آن تصرف نمایید. ");
INSERT INTO pesOPV_vpl VALUES ("DT8_2","006_8_2","DEU","8","2","2","و بیاد آور تمامی راه را که یهوه، خدایت، تو را این چهل سال در بیابان رهبری نمود تا تو را ذلیل ساخته، بیازماید، و آنچه را که در دل تو است بداند، که آیا اوامر او را نگاه خواهی داشت یا نه. ");
INSERT INTO pesOPV_vpl VALUES ("DT8_3","006_8_3","DEU","8","3","3","و او تو را ذلیل و گرسنه ساخت و من را به تو خورانید که نه تو آن رامی دانستی و نه پدرانت می‌دانستند، تا تو رابیاموزاند که انسان نه به نان تنها زیست می‌کندبلکه به هر کلمه‌ای که از دهان خداوند صادرشود، انسان زنده می‌شود. ");
INSERT INTO pesOPV_vpl VALUES ("DT8_4","006_8_4","DEU","8","4","4","در این چهل سال لباس تو در برت مندرس نشد، و پای تو آماس نکرد. ");
INSERT INTO pesOPV_vpl VALUES ("DT8_5","006_8_5","DEU","8","5","5","پس در دل خود فکر کن که بطوری که پدر، پسر خود را تادیب می‌نماید، یهوه خدایت تو را تادیب کرده است. ");
INSERT INTO pesOPV_vpl VALUES ("DT8_6","006_8_6","DEU","8","6","6","و اوامر یهوه خدای خود را نگاه داشته، در طریقهای او سلوک نما و ازاو بترس. ");
INSERT INTO pesOPV_vpl VALUES ("DT8_7","006_8_7","DEU","8","7","7","زیرا که یهوه خدایت تو را به زمین نیکو درمی آورد؛ زمین پر از نهرهای آب و ازچشمه‌ها و دریاچه‌ها که از دره‌ها و کوهها جاری می‌شود. ");
INSERT INTO pesOPV_vpl VALUES ("DT8_8","006_8_8","DEU","8","8","8","زمینی که پر از گندم و جو و مو و انجیرو انار باشد، زمینی که پر از زیتون زیت و عسل است. ");
INSERT INTO pesOPV_vpl VALUES ("DT8_9","006_8_9","DEU","8","9","9","زمینی که در آن نان را به تنگی نخواهی خورد، و در آن محتاج به هیچ‌چیز نخواهی شد، زمینی که سنگهایش آهن است، و از کوههایش مس خواهی کند. ");
INSERT INTO pesOPV_vpl VALUES ("DT8_10","006_8_10","DEU","8","10","10","و خورده، سیر خواهی شد، و یهوه خدای خود را به جهت زمین نیکو که به تو داده است، متبارک خواهی خواند. ");
INSERT INTO pesOPV_vpl VALUES ("DT8_11","006_8_11","DEU","8","11","11","پس باحذر باش، مبادا یهوه خدای خود رافراموش کنی و اوامر و احکام و فرایض او را که من امروز به تو امر می‌فرمایم، نگاه نداری. ");
INSERT INTO pesOPV_vpl VALUES ("DT8_12","006_8_12","DEU","8","12","12","مباداخورده، سیر شوی، و خانه های نیکو بنا کرده، درآن ساکن شوی. ");
INSERT INTO pesOPV_vpl VALUES ("DT8_13","006_8_13","DEU","8","13","13","و رمه و گله تو زیاد شود، ونقره و طلا برای تو افزون شود، و مایملک توافزوده گردد. ");
INSERT INTO pesOPV_vpl VALUES ("DT8_14","006_8_14","DEU","8","14","14","و دل تو مغرور شده، یهوه خدای خود را که تو را از زمین مصر از خانه بندگی بیرون آورد، فراموش کنی. ");
INSERT INTO pesOPV_vpl VALUES ("DT8_15","006_8_15","DEU","8","15","15","که تو را در بیابان بزرگ وخوفناک که در آن مارهای آتشین و عقربها و زمین تشنه بی‌آب بود، رهبری نمود، که برای تو آب ازسنگ خارا بیرون آورد. ");
INSERT INTO pesOPV_vpl VALUES ("DT8_16","006_8_16","DEU","8","16","16","که تو را در بیابان من راخورانید که پدرانت آن را ندانسته بودند، تا تو راذلیل سازد و تو را بیازماید و بر تو در آخرت احسان نماید. ");
INSERT INTO pesOPV_vpl VALUES ("DT8_17","006_8_17","DEU","8","17","17","مبادا در دل خود بگویی که قوت من و توانایی دست من، این توانگری را ازبرایم پیدا کرده است. ");
INSERT INTO pesOPV_vpl VALUES ("DT8_18","006_8_18","DEU","8","18","18","بلکه یهوه خدای خود رابیاد آور، زیرا اوست که به تو قوت می‌دهد تاتوانگری پیدا نمایی، تا عهد خود را که برای پدرانت قسم خورده بود، استوار بدارد، چنانکه امروز شده است. ");
INSERT INTO pesOPV_vpl VALUES ("DT8_19","006_8_19","DEU","8","19","19","و اگر یهوه خدای خود رافراموش کنی و پیروی خدایان دیگر نموده، آنهارا عبادت و سجده نمایی، امروز برشما شهادت می‌دهم که البته هلاک خواهید شد. ");
INSERT INTO pesOPV_vpl VALUES ("DT8_20","006_8_20","DEU","8","20","20","مثل قومهایی که خداوند پیش روی تو هلاک می‌سازد، شما همچنین هلاک خواهید شد از این جهت که قول یهوه خدای خود را نشنیدید. ");
INSERT INTO pesOPV_vpl VALUES ("DT9_1","006_9_1","DEU","9","1","1","ای اسرائیل بشنو. تو امروز از اردن عبورمی کنی، تا داخل شده، قومهایی را که از تو عظیم تر و قوی تراند، و شهرهای بزرگ را که تا به فلک حصاردار است، به تصرف آوری، ");
INSERT INTO pesOPV_vpl VALUES ("DT9_2","006_9_2","DEU","9","2","2","یعنی قوم عظیم و بلند قد بنی عناق را که می‌شناسی وشنیده‌ای که گفته‌اند کیست که یارای مقاومت بابنی عناق داشته باشد. ");
INSERT INTO pesOPV_vpl VALUES ("DT9_3","006_9_3","DEU","9","3","3","پس امروز بدان که یهوه، خدایت، اوست که پیش روی تو مثل آتش سوزنده عبور می‌کند، و او ایشان را هلاک خواهدکرد، و پیش روی تو ذلیل خواهد ساخت، پس ایشان را اخراج نموده، بزودی هلاک خواهی نمود، چنانکه خداوند به تو گفته است. ");
INSERT INTO pesOPV_vpl VALUES ("DT9_4","006_9_4","DEU","9","4","4","پس چون یهوه، خدایت، ایشان را از حضورتو اخراج نماید، در دل خود فکر مکن و مگو که به‌سبب عدالت من، خداوند مرا به این زمین درآوردتا آن را به تصرف آورم، بلکه به‌سبب شرارت این امتها، خداوند ایشان را از حضور تو اخراج می‌نماید. ");
INSERT INTO pesOPV_vpl VALUES ("DT9_5","006_9_5","DEU","9","5","5","نه به‌سبب عدالت خود و نه به‌سبب راستی دل خویش داخل زمین ایشان برای تصرفش می‌شوی، بلکه به‌سبب شرارت این امتها، یهوه، خدایت، ایشان را از حضور تو اخراج می‌نماید، و تا آنکه کلامی را که خداوند برای پدرانت، ابراهیم و اسحاق و یعقوب، قسم خورده بود، استوار نماید. ");
INSERT INTO pesOPV_vpl VALUES ("DT9_6","006_9_6","DEU","9","6","6","پس بدان که یهوه، خدایت، این زمین نیکو رابه‌سبب عدالت تو به تو نمی دهد تا در آن تصرف نمایی، زیرا که قومی گردن کش هستی. ");
INSERT INTO pesOPV_vpl VALUES ("DT9_7","006_9_7","DEU","9","7","7","پس بیادآور و فراموش مکن که چگونه خشم یهوه خدای خود را در بیابان جنبش دادی و از روزی که از زمین مصر بیرون آمدی تا به اینجا رسیدی به خداوند عاصی می‌شدید. ");
INSERT INTO pesOPV_vpl VALUES ("DT9_8","006_9_8","DEU","9","8","8","و در حوریب خشم خداوند را جنبش دادید، و خداوند بر شما غضبناک شد تا شما راهلاک نماید. ");
INSERT INTO pesOPV_vpl VALUES ("DT9_9","006_9_9","DEU","9","9","9","هنگامی که من به کوه برآمدم تالوحهای سنگ یعنی لوحهای عهدی را که خداوند با شما بست، بگیرم، آنگاه چهل روز وچهل شب در کوه ماندم؛ نه نان خوردم و نه آب نوشیدم. ");
INSERT INTO pesOPV_vpl VALUES ("DT9_10","006_9_10","DEU","9","10","10","و خداوند دو لوح سنگ مکتوب شده به انگشت خدا را به من داد و بر آنها موافق تمامی سخنانی که خداوند در کوه از میان آتش در روزاجتماع به شما گفته بود، نوشته شد. ");
INSERT INTO pesOPV_vpl VALUES ("DT9_11","006_9_11","DEU","9","11","11","و واقع شدبعد از انقضای چهل روز و چهل شب که خداونداین دو لوح سنگ یعنی لوحهای عهد را به من داد، ");
INSERT INTO pesOPV_vpl VALUES ("DT9_12","006_9_12","DEU","9","12","12","و خداوند مرا گفت: «برخاسته، از اینجا به زودی فرود شو زیرا قوم تو که از مصر بیرون آوردی فاسد شده‌اند، و از طریقی که ایشان را امرفرمودم به زودی انحراف ورزیده، بتی ریخته شده برای خود ساختند.» ");
INSERT INTO pesOPV_vpl VALUES ("DT9_13","006_9_13","DEU","9","13","13","و خداوند مراخطاب کرده، گفت: «این قوم را دیدم و اینک قوم گردن کش هستند. ");
INSERT INTO pesOPV_vpl VALUES ("DT9_14","006_9_14","DEU","9","14","14","مرا واگذار تا ایشان را هلاک سازم و نام ایشان را از زیر آسمان محو کنم و از توقومی قوی تر و کثیرتر از ایشان بوجود آورم.» ");
INSERT INTO pesOPV_vpl VALUES ("DT9_15","006_9_15","DEU","9","15","15","پس برگشته، از کوه فرود آمدم و کوه به آتش می‌سوخت و دو لوح عهد در دو دست من بود. ");
INSERT INTO pesOPV_vpl VALUES ("DT9_16","006_9_16","DEU","9","16","16","و نگاه کرده، دیدم که به یهوه خدای خودگناه ورزیده، گوساله‌ای ریخته شده برای خودساخته و از طریقی که خداوند به شما امر فرموده بود، به زودی برگشته بودید. ");
INSERT INTO pesOPV_vpl VALUES ("DT9_17","006_9_17","DEU","9","17","17","پس دو لوح راگرفتم و آنها را از دو دست خود انداخته، در نظرشما شکستم. ");
INSERT INTO pesOPV_vpl VALUES ("DT9_18","006_9_18","DEU","9","18","18","و مثل دفعه اول، چهل روز وچهل شب به حضور خداوند به روی درافتادم؛ نه نان خوردم و نه آب نوشیدم، به‌سبب همه گناهان شما که کرده و کار ناشایسته که در نظر خداوندعمل نموده، خشم او را به هیجان آوردید. ");
INSERT INTO pesOPV_vpl VALUES ("DT9_19","006_9_19","DEU","9","19","19","زیرا که از غضب و حدت خشمی که خداوندبر شما نموده بود تا شما را هلاک سازد، می‌ترسیدم، و خداوند آن مرتبه نیز مرا اجابت نمود. ");
INSERT INTO pesOPV_vpl VALUES ("DT9_20","006_9_20","DEU","9","20","20","و خداوند بر هارون بسیا غضبناک شده بود تا او را هلاک سازد، و برای هارون نیز در آن وقت دعا کردم. ");
INSERT INTO pesOPV_vpl VALUES ("DT9_21","006_9_21","DEU","9","21","21","و اما گناه شما یعنی گوساله‌ای را که ساخته بودید، گرفتم و آن را به آتش سوزانیدم و آن را خرد کرده، نیکو ساییدم تا مثل غبار نرم شد، و غبارش را به نهری که از کوه جاری بود، پاشیدم. ");
INSERT INTO pesOPV_vpl VALUES ("DT9_22","006_9_22","DEU","9","22","22","و در تبعیره و مسا و کبروت هتاوه خشم خداوند را به هیجان آوردید. ");
INSERT INTO pesOPV_vpl VALUES ("DT9_23","006_9_23","DEU","9","23","23","و وقتی که خداوند شما را از قادش برنیع فرستاده، گفت: بروید و در زمینی که به شما داده‌ام تصرف نمایید، از قول یهوه خدای خود عاصی شدید و به اوایمان نیاورده، آواز او را نشنیدید. ");
INSERT INTO pesOPV_vpl VALUES ("DT9_24","006_9_24","DEU","9","24","24","از روزی که شما را شناخته‌ام به خداوند عصیان ورزیده‌اید. ");
INSERT INTO pesOPV_vpl VALUES ("DT9_25","006_9_25","DEU","9","25","25","پس به حضور خداوند به روی درافتادم درآن چهل روز و چهل شب که افتاده بودم، از این جهت که خداوند گفته بود که شما را هلاک سازد. ");
INSERT INTO pesOPV_vpl VALUES ("DT9_26","006_9_26","DEU","9","26","26","و نزد خداوند استدعا نموده، گفتم: «ای خداوند یهوه، قوم خود و میراث خود را که به عظمت خود فدیه دادی و به‌دست قوی از مصربیرون آوردی، هلاک مساز. ");
INSERT INTO pesOPV_vpl VALUES ("DT9_27","006_9_27","DEU","9","27","27","بندگان خودابراهیم و اسحاق و یعقوب را بیاد آور، و برسخت دلی این قوم و شرارت و گناه ایشان نظر منما. ");
INSERT INTO pesOPV_vpl VALUES ("DT9_28","006_9_28","DEU","9","28","28","مبادا اهل زمینی که ما را از آن بیرون آوردی، بگویند چونکه خداوند نتوانست ایشان را به زمینی که به ایشان وعده داده بود درآورد، وچونکه ایشان را دشمن می‌داشت، از این جهت ایشان را بیرون آورد تا در بیابان هلاک سازد. ");
INSERT INTO pesOPV_vpl VALUES ("DT9_29","006_9_29","DEU","9","29","29","لیکن ایشان قوم تو و میراث تو هستند که به قوت عظیم خود و به بازوی افراشته خویش بیرون آوردی.» ");
INSERT INTO pesOPV_vpl VALUES ("DT10_1","006_10_1","DEU","10","1","1","و در آن وقت خداوند به من گفت: «دولوح سنگ موافق اولیه برای خودبتراش، و نزد من به کوه برآی، و تابوتی از چوب برای خود بساز. ");
INSERT INTO pesOPV_vpl VALUES ("DT10_2","006_10_2","DEU","10","2","2","و بر این لوحها کلماتی را که برلوحهای اولین که شکستی بود، خواهم نوشت، وآنها را در تابوت بگذار.» ");
INSERT INTO pesOPV_vpl VALUES ("DT10_3","006_10_3","DEU","10","3","3","پس تابوتی از چوب سنط ساختم، و دو لوح سنگ موافق اولین تراشیدم، و آن دو لوح را در دست داشته، به کوه برآمدم. ");
INSERT INTO pesOPV_vpl VALUES ("DT10_4","006_10_4","DEU","10","4","4","و بر آن دو لوح موافق کتابت اولین، آن ده کلمه را که خداوند در کوه از میان آتش، درروز اجتماع به شما گفته بود نوشت، و خداوندآنها را به من داد. ");
INSERT INTO pesOPV_vpl VALUES ("DT10_5","006_10_5","DEU","10","5","5","پس برگشته، از کوه فرود آمدم، و لوحها را در تابوتی که ساخته بودم گذاشتم، ودر آنجا هست، چنانکه خداوند مرا امر فرموده بود. ");
INSERT INTO pesOPV_vpl VALUES ("DT10_6","006_10_6","DEU","10","6","6","(و بنی‌اسرائیل از بیروت بنی یعقان به موسیره کوچ کردند، و در آنجا هارون مرد و درآنجا دفن شد. و پسرش العازار در جایش به کهانت پرداخت. ");
INSERT INTO pesOPV_vpl VALUES ("DT10_7","006_10_7","DEU","10","7","7","و از آنجا به جدجوده کوچ کردند، و از جدجوده به یطبات که زمین نهرهای آب است. ");
INSERT INTO pesOPV_vpl VALUES ("DT10_8","006_10_8","DEU","10","8","8","در آنوقت خداوند سبط لاوی را جداکرد، تا تابوت عهد خداوند را بردارند، و به حضور خداوند ایستاده، او را خدمت نمایند، و به نام او برکت دهند، چنانکه تا امروز است. ");
INSERT INTO pesOPV_vpl VALUES ("DT10_9","006_10_9","DEU","10","9","9","بنابراین لاوی را در میان برادرانش نصیب ومیراثی نیست؛ خداوند میراث وی است، چنانکه یهوه خدایت به وی گفته بود). ");
INSERT INTO pesOPV_vpl VALUES ("DT10_10","006_10_10","DEU","10","10","10","و من در کوه مثل روزهای اولین، چهل روزو چهل شب توقف نمودم، و در آن دفعه نیزخداوند مرا اجابت نمود، و خداوند نخواست تورا هلاک سازد. ");
INSERT INTO pesOPV_vpl VALUES ("DT10_11","006_10_11","DEU","10","11","11","و خداوند مرا گفت: «برخیز وپیش روی این قوم روانه شو تا به زمینی که برای پدران ایشان قسم خوردم که به ایشان بدهم داخل شده، آن را به تصرف آورند.» ");
INSERT INTO pesOPV_vpl VALUES ("DT10_12","006_10_12","DEU","10","12","12","پس الان‌ای اسرائیل، یهوه خدایت از توچه می‌خواهد، جز اینکه از یهوه خدایت بترسی و در همه طریقهایش سلوک نمایی، و او رادوست بداری و یهوه خدای خود را به تمامی دل و به تمامی جان خود عبادت نمایی. ");
INSERT INTO pesOPV_vpl VALUES ("DT10_13","006_10_13","DEU","10","13","13","و اوامرخداوند و فرایض او را که من امروز تو را برای خیریتت امر می‌فرمایم، نگاه داری. ");
INSERT INTO pesOPV_vpl VALUES ("DT10_14","006_10_14","DEU","10","14","14","اینک فلک و فلک الافلاک از آن یهوه خدای توست، و زمین وهرآنچه در آن است. ");
INSERT INTO pesOPV_vpl VALUES ("DT10_15","006_10_15","DEU","10","15","15","لیکن خداوند به پدران تورغبت داشته، ایشان را محبت می‌نمود، و بعد ازایشان ذریت ایشان، یعنی شما را از همه قومهابرگزید، چنانکه امروز شده است. ");
INSERT INTO pesOPV_vpl VALUES ("DT10_16","006_10_16","DEU","10","16","16","پس غلفه دلهای خود را مختون سازید، و دیگر گردن کشی منمایید. ");
INSERT INTO pesOPV_vpl VALUES ("DT10_17","006_10_17","DEU","10","17","17","زیرا که یهوه خدای شما خدای خدایان و رب‌الارباب، و خدای عظیم و جبار ومهیب است، که طرفداری ندارد و رشوه نمی گیرد. ");
INSERT INTO pesOPV_vpl VALUES ("DT10_18","006_10_18","DEU","10","18","18","یتیمان و بیوه‌زنان را دادرسی می‌کند، و غریبان را دوست داشته، خوراک وپوشاک به ایشان می‌دهد. ");
INSERT INTO pesOPV_vpl VALUES ("DT10_19","006_10_19","DEU","10","19","19","پس غریبان رادوست دارید، زیرا که در زمین مصر غریب بودید. ");
INSERT INTO pesOPV_vpl VALUES ("DT10_20","006_10_20","DEU","10","20","20","از یهوه خدای خود بترس، و او را عبادت نما وبه او ملصق شو و به نام او قسم بخور. ");
INSERT INTO pesOPV_vpl VALUES ("DT10_21","006_10_21","DEU","10","21","21","او فخرتوست و او خدای توست که برای تو این اعمال عظیم و مهیبی که چشمانت دیده بجا آورده است. ");
INSERT INTO pesOPV_vpl VALUES ("DT10_22","006_10_22","DEU","10","22","22","پدران تو با هفتاد نفر به مصر فرود شدندو الان یهوه خدایت، تو را مثل ستارگان آسمان کثیر ساخته است. ");
INSERT INTO pesOPV_vpl VALUES ("DT11_1","006_11_1","DEU","11","1","1","پس یهوه خدای خود را دوست بدار، وودیعت و فرایض و احکام و اوامر او رادر همه وقت نگاهدار. ");
INSERT INTO pesOPV_vpl VALUES ("DT11_2","006_11_2","DEU","11","2","2","و امروز بدانید، زیرا که به پسران شما سخن نمی گویم که ندانسته‌اند، وتادیب یهوه خدای شما را ندیده‌اند، و نه عظمت و دست قوی و بازوی افراشته او را. ");
INSERT INTO pesOPV_vpl VALUES ("DT11_3","006_11_3","DEU","11","3","3","و آیات واعمال او را که در میان مصر، به فرعون، پادشاه مصر، و به تمامی زمین او بظهور آورد. ");
INSERT INTO pesOPV_vpl VALUES ("DT11_4","006_11_4","DEU","11","4","4","و آنچه راکه به لشکر مصریان، به اسبها و به ارابه های ایشان کرد، که چگونه آب بحر قلزم را برایشان جاری ساخت، وقتی که شما را تعاقب می‌نمودند، وچگونه خداوند، ایشان را تا به امروز هلاک ساخت. ");
INSERT INTO pesOPV_vpl VALUES ("DT11_5","006_11_5","DEU","11","5","5","و آنچه را که برای شما در بیابان کرد تاشما به اینجا رسیدید. ");
INSERT INTO pesOPV_vpl VALUES ("DT11_6","006_11_6","DEU","11","6","6","و آنچه را که به داتان و ابیرام پسران الیاب بن روبین کرد، که چگونه زمین دهان خود را گشوده، ایشان را و خاندان وخیمه های ایشان را، و هر ذی حیات را که همراه ایشان بود در میان تمامی اسرائیل بلعید. ");
INSERT INTO pesOPV_vpl VALUES ("DT11_7","006_11_7","DEU","11","7","7","لیکن چشمان شما تمامی اعمال عظیمه خداوند را که کرده بود، دیدند. ");
INSERT INTO pesOPV_vpl VALUES ("DT11_8","006_11_8","DEU","11","8","8","پس جمیع اوامری را که من امروز برای شماامر می‌فرمایم نگاه دارید، تا قوی شوید و داخل شده، زمینی را که برای گرفتن آن عبور می‌کنید، به تصرف آورید. ");
INSERT INTO pesOPV_vpl VALUES ("DT11_9","006_11_9","DEU","11","9","9","و تا در آن زمینی که خداوندبرای پدران شما قسم خورد که آن را به ایشان وذریت ایشان بدهد، عمر دراز داشته باشید، زمینی که به شیر و شهد جاری است. ");
INSERT INTO pesOPV_vpl VALUES ("DT11_10","006_11_10","DEU","11","10","10","زیرا زمینی که تو برای گرفتن آن داخل می‌شوی، مثل زمین مصرکه از آن بیرون آمدی نیست، که در آن تخم خودرا می‌کاشتی و آن را مثل باغ بقول به پای خودسیراب می‌کردی. ");
INSERT INTO pesOPV_vpl VALUES ("DT11_11","006_11_11","DEU","11","11","11","لیکن زمینی که شما برای گرفتنش به آن عبور می‌کنید، زمین کوهها ودره هاست که از بارش آسمان آب می‌نوشد، ");
INSERT INTO pesOPV_vpl VALUES ("DT11_12","006_11_12","DEU","11","12","12","زمینی است که یهوه خدایت برآن التفات داردو چشمان یهوه خدایت از اول سال تا آخر سال پیوسته بر آن است. ");
INSERT INTO pesOPV_vpl VALUES ("DT11_13","006_11_13","DEU","11","13","13","و چنین خواهد شد که اگر اوامری را که من امروز برای شما امر می‌فرمایم، بشنوید، و یهوه خدای خود را دوست بدارید، و او را به تمامی دل و به تمامی جان خود عبادت نمایید، ");
INSERT INTO pesOPV_vpl VALUES ("DT11_14","006_11_14","DEU","11","14","14","آنگاه باران زمین شما یعنی باران اولین و آخرین را درموسمش خواهم بخشید، تا غله و شیره و روغن خود را جمع نمایی. ");
INSERT INTO pesOPV_vpl VALUES ("DT11_15","006_11_15","DEU","11","15","15","و در صحرای تو برای بهایمت علف خواهم داد تا بخوری و سیر شوی. ");
INSERT INTO pesOPV_vpl VALUES ("DT11_16","006_11_16","DEU","11","16","16","باحذر باشید مبادا دل شما فریفته شود وبرگشته، خدایان دیگر را عبادت و سجده نمایید. ");
INSERT INTO pesOPV_vpl VALUES ("DT11_17","006_11_17","DEU","11","17","17","و خشم خداوند برشما افروخته شود، تاآسمان را مسدود سازد، و باران نبارد، و زمین محصول خود را ندهد و شما از زمین نیکویی که خداوند به شما می‌دهد، بزودی هلاک شوید. ");
INSERT INTO pesOPV_vpl VALUES ("DT11_18","006_11_18","DEU","11","18","18","پس این سخنان مرا در دل و جان خود جادهید، و آنها را بر دستهای خود برای علامت ببندید، و در میان چشمان شما عصابه باشد. ");
INSERT INTO pesOPV_vpl VALUES ("DT11_19","006_11_19","DEU","11","19","19","وآنها را به پسران خود تعلیم دهید، و حین نشستنت در خانه خود، و رفتنت به راه، و وقت خوابیدن و برخاستنت از آنها گفتگو نمایید. ");
INSERT INTO pesOPV_vpl VALUES ("DT11_20","006_11_20","DEU","11","20","20","وآنها را بر باهوهای در خانه خود و بر دروازه های خود بنویسید. ");
INSERT INTO pesOPV_vpl VALUES ("DT11_21","006_11_21","DEU","11","21","21","تا ایام شما و ایام پسران شما برزمینی که خداوند برای پدران شما قسم خورد که به ایشان بدهد، کثیر شود، مثل ایام افلاک بر بالای زمین. ");
INSERT INTO pesOPV_vpl VALUES ("DT11_22","006_11_22","DEU","11","22","22","زیرا اگر تمامی این اوامر را که من به جهت عمل نمودن به شما امر می‌فرمایم، نیکو نگاه دارید، تا یهوه خدای خود را دوست دارید، و درتمامی طریقهای او رفتار نموده، به او ملصق شوید، ");
INSERT INTO pesOPV_vpl VALUES ("DT11_23","006_11_23","DEU","11","23","23","آنگاه خداوند جمیع این امتها را ازحضور شما اخراج خواهد نمود، و شما امتهای بزرگتر و قویتر از خود را تسخیر خواهید نمود. ");
INSERT INTO pesOPV_vpl VALUES ("DT11_24","006_11_24","DEU","11","24","24","هرجایی که کف پای شما برآن گذارده شود، ازآن شما خواهد بود، از بیابان و لبنان و از نهر، یعنی نهر فرات تا دریای غربی، حدود شماخواهد بود. ");
INSERT INTO pesOPV_vpl VALUES ("DT11_25","006_11_25","DEU","11","25","25","و هیچکس یارای مقاومت با شمانخواهد داشت، زیرا یهوه خدای شما ترس و خوف شما را بر تمامی زمین که به آن قدم می‌زنیدمستولی خواهد ساخت، چنانکه به شما گفته است. ");
INSERT INTO pesOPV_vpl VALUES ("DT11_26","006_11_26","DEU","11","26","26","اینک من امروز برکت و لعنت پیش شمامی گذارم. ");
INSERT INTO pesOPV_vpl VALUES ("DT11_27","006_11_27","DEU","11","27","27","اما برکت، اگر اوامر یهوه خدای خود را که من امروز به شما امر می‌فرمایم، اطاعت نمایید. ");
INSERT INTO pesOPV_vpl VALUES ("DT11_28","006_11_28","DEU","11","28","28","و اما لعنت، اگر اوامر یهوه خدای خودرا اطاعت ننموده، از طریقی که من امروز به شماامر می‌فرمایم برگردید، و خدایان غیر را که نشناخته‌اید، پیروی نمایید. ");
INSERT INTO pesOPV_vpl VALUES ("DT11_29","006_11_29","DEU","11","29","29","و واقع خواهد شدکه چون یهوه، خدایت، تو را به زمینی که به جهت گرفتنش به آن می‌روی داخل سازد، آنگاه برکت را بر کوه جرزیم و لعنت را بر کوه ایبال خواهی گذاشت. ");
INSERT INTO pesOPV_vpl VALUES ("DT11_30","006_11_30","DEU","11","30","30","آیا آنها به آنطرف اردن نیستند پشت راه غروب آفتاب، در زمین کنعانیانی که در عربه ساکنند مقابل جلجال نزد بلوطهای موره. ");
INSERT INTO pesOPV_vpl VALUES ("DT11_31","006_11_31","DEU","11","31","31","زیرا که شما از اردن عبور می‌کنید تا داخل شده، زمینی را که یهوه خدایت به تو می‌بخشد به تصرف آورید، و آن را خواهید گرفت و در آن ساکن خواهید شد. ");
INSERT INTO pesOPV_vpl VALUES ("DT11_32","006_11_32","DEU","11","32","32","پس متوجه باشید تا جمیع این فرایض و احکامی را که من امروز پیش شمامی گذارم، به عمل آورید. ");
INSERT INTO pesOPV_vpl VALUES ("DT12_1","006_12_1","DEU","12","1","1","اینهاست فرایض و احکامی که شما درتمامی روزهایی که بر زمین زنده خواهید ماند، می‌باید متوجه شده، به عمل آرید، در زمینی که یهوه خدای پدرانت به تو داده است، تا در آن تصرف نمایی. ");
INSERT INTO pesOPV_vpl VALUES ("DT12_2","006_12_2","DEU","12","2","2","جمیع اماکن امتهایی را که در آنها خدایان خود را عبادت می‌کنند و شما آنها را اخراج می‌نمایید خراب نمایید، خواه بر کوههای بلندخواه بر تلها و خواه زیر هر درخت سبز. ");
INSERT INTO pesOPV_vpl VALUES ("DT12_3","006_12_3","DEU","12","3","3","مذبحهای ایشان را بشکنید و ستونهای ایشان راخرد کنید، و اشیره های ایشان را به آتش بسوزانید، و بتهای تراشیده شده خدایان ایشان راقطع نمایید، و نامهای ایشان را از آنجا محوسازید. ");
INSERT INTO pesOPV_vpl VALUES ("DT12_4","006_12_4","DEU","12","4","4","با یهوه خدای خود چنین عمل منمایید. ");
INSERT INTO pesOPV_vpl VALUES ("DT12_5","006_12_5","DEU","12","5","5","بلکه به مکانی که یهوه خدای شما از جمیع اسباط شما برگزیند تا نام خود را در آنجا بگذارد، یعنی مسکن او را بطلبید و به آنجا بروید. ");
INSERT INTO pesOPV_vpl VALUES ("DT12_6","006_12_6","DEU","12","6","6","و به آنجا قربانی های سوختنی و ذبایح و عشرهای خود، و هدایای افراشتنی دستهای خویش، ونذرها و نوافل خود و نخست زاده های رمه و گله خویش را ببرید. ");
INSERT INTO pesOPV_vpl VALUES ("DT12_7","006_12_7","DEU","12","7","7","و در آنجا بحضور یهوه خدای خود بخورید، و شما و اهل خانه شما در هر شغل دست خود که یهوه خدای شما، شما را در آن برکت دهد، شادی نمایید. ");
INSERT INTO pesOPV_vpl VALUES ("DT12_8","006_12_8","DEU","12","8","8","موافق هرآنچه ما امروز در اینجا می‌کنیم، یعنی آنچه در نظر هرکس پسند آید، نکنید. ");
INSERT INTO pesOPV_vpl VALUES ("DT12_9","006_12_9","DEU","12","9","9","زیرا که هنوز به آرامگاه و نصیبی که یهوه خدای شما، به شما می‌دهد داخل نشده‌اید. ");
INSERT INTO pesOPV_vpl VALUES ("DT12_10","006_12_10","DEU","12","10","10","اما چون از اردن عبور کرده، در زمینی که یهوه، خدای شما، برای شما تقسیم می‌کند، ساکن شوید، و اوشما را از جمیع دشمنان شما از هرطرف آرامی دهد تا در امنیت سکونت نمایید. ");
INSERT INTO pesOPV_vpl VALUES ("DT12_11","006_12_11","DEU","12","11","11","آنگاه به مکانی که یهوه خدای شما برگزیند تا نام خود رادر آن ساکن سازد، به آنجا هرچه را که من به شماامر فرمایم بیاورید، از قربانی های سوختنی وذبایح و عشرهای خود، و هدایای افراشتنی دستهای خویش، و همه نذرهای بهترین خود که برای خداوند نذر نمایید. ");
INSERT INTO pesOPV_vpl VALUES ("DT12_12","006_12_12","DEU","12","12","12","و به حضور یهوه خدای خود شادی نمایید، شما با پسران ودختران و غلامان و کنیزان خود، و لاویانی که درون دروازه های شما باشند، چونکه ایشان را باشما حصه‌ای و نصیبی نیست. ");
INSERT INTO pesOPV_vpl VALUES ("DT12_13","006_12_13","DEU","12","13","13","با حذر باش که در هر جایی که می‌بینی قربانی های سوختنی خود را نگذرانی، ");
INSERT INTO pesOPV_vpl VALUES ("DT12_14","006_12_14","DEU","12","14","14","بلکه درمکانی که خداوند در یکی از اسباط تو برگزیند درآنجا قربانی های سوختنی خود را بگذرانی، و درآنجا هرچه من به تو امر فرمایم، به عمل آوری. ");
INSERT INTO pesOPV_vpl VALUES ("DT12_15","006_12_15","DEU","12","15","15","لیکن گوشت را برحسب تمامی آرزوی دلت، موافق برکتی که یهوه خدایت به تو دهد، درهمه دروازه هایت ذبح کرده، بخور؛ اشخاص نجس و طاهر از آن بخورند چنانکه از غزال و آهومی خورند. ");
INSERT INTO pesOPV_vpl VALUES ("DT12_16","006_12_16","DEU","12","16","16","ولی خون را نخور؛ آن را مثل آب بر زمین بریز. ");
INSERT INTO pesOPV_vpl VALUES ("DT12_17","006_12_17","DEU","12","17","17","عشر غله و شیره و روغن ونخست زاده رمه و گله خود را در دروازه های خودمخور، و نه هیچ‌یک از نذرهای خود را که نذرمی کنی و از نوافل خود و هدایای افراشتنی دست خود را. ");
INSERT INTO pesOPV_vpl VALUES ("DT12_18","006_12_18","DEU","12","18","18","بلکه آنها را به حضور یهوه خدایت درمکانی که یهوه خدایت برگزیند، بخور، تو وپسرت و دخترت و غلامت و کنیزت و لاویانی که درون دروازه های تو باشند، و به هرچه دست خود را برآن بگذاری به حضور یهوه خدایت شادی نما. ");
INSERT INTO pesOPV_vpl VALUES ("DT12_19","006_12_19","DEU","12","19","19","با حذر باش که لاویان را در تمامی روزهایی که در زمین خود باشی، ترک ننمایی. ");
INSERT INTO pesOPV_vpl VALUES ("DT12_20","006_12_20","DEU","12","20","20","چون یهوه، خدایت، حدود تو را بطوری که تو را وعده داده است، وسیع گرداند، و بگویی که گوشت خواهم خورد، زیرا که دل تو به گوشت خوردن مایل است، پس موافق همه آرزوی دلت گوشت را بخور. ");
INSERT INTO pesOPV_vpl VALUES ("DT12_21","006_12_21","DEU","12","21","21","و اگر مکانی که یهوه، خدایت، برگزیند تا اسم خود را در آن بگذارد ازتو دور باشد، آنگاه از رمه و گله خود که خداوندبه تو دهد ذبح کن، چنانکه به تو امر فرموده‌ام و ازهرچه دلت بخواهد در دروازه هایت بخور. ");
INSERT INTO pesOPV_vpl VALUES ("DT12_22","006_12_22","DEU","12","22","22","چنانکه غزال و آهو خورده شود، آنها را چنین بخور؛ شخص نجس و شخص طاهر از آن برابربخورند. ");
INSERT INTO pesOPV_vpl VALUES ("DT12_23","006_12_23","DEU","12","23","23","لیکن هوشیار باش که خون را نخوری زیرا خون جان است و جان را با گوشت نخوری. ");
INSERT INTO pesOPV_vpl VALUES ("DT12_24","006_12_24","DEU","12","24","24","آن را مخور، بلکه مثل آب برزمینش بریز. ");
INSERT INTO pesOPV_vpl VALUES ("DT12_25","006_12_25","DEU","12","25","25","آن را مخور تا برای تو و بعد از تو برای پسرانت نیکو باشد هنگامی که آنچه در نظرخداوند راست است، بجا آوری. ");
INSERT INTO pesOPV_vpl VALUES ("DT12_26","006_12_26","DEU","12","26","26","لیکن موقوفات خود را که داری و نذرهای خود رابرداشته، به مکانی که خداوند برگزیند، برو. ");
INSERT INTO pesOPV_vpl VALUES ("DT12_27","006_12_27","DEU","12","27","27","وگوشت و خون قربانی های سوختنی خود را برمذبح یهوه خدایت بگذران و خون ذبایح توبرمذبح یهوه خدایت ریخته شود و گوشت رابخور. ");
INSERT INTO pesOPV_vpl VALUES ("DT12_28","006_12_28","DEU","12","28","28","متوجه باش که همه این سخنانی را که من به تو امر می‌فرمایم بشنوی تا برای تو و بعد از توبرای پسرانت هنگامی که آنچه در نظر یهوه، خدایت، نیکو و راست است بجا آوری تا به ابدنیکو باشد. ");
INSERT INTO pesOPV_vpl VALUES ("DT12_29","006_12_29","DEU","12","29","29","وقتی که یهوه، خدایت، امتهایی را که به جهت گرفتن آنها به آنجا می‌روی، از حضور تومنقطع سازد، و ایشان را اخراج نموده، در زمین ایشان ساکن شوی. ");
INSERT INTO pesOPV_vpl VALUES ("DT12_30","006_12_30","DEU","12","30","30","آنگاه باحذر باش، مبادا بعداز آنکه از حضور تو هلاک شده باشند به دام گرفته شده، ایشان را پیروی نمایی و درباره خدایان ایشان دریافت کرده، بگویی که این امتها خدایان خود را چگونه عبادت کردند تا من نیز چنین کنم. ");
INSERT INTO pesOPV_vpl VALUES ("DT12_31","006_12_31","DEU","12","31","31","با یهوه، خدای خود، چنین عمل منما، زیراهرچه را که نزد خداوند مکروه است و از آن نفرت دارد، ایشان برای خدایان خود می‌کردند، حتی اینکه پسران و دختران خود را نیز برای خدایان خود به آتش می‌سوزانیدند. ");
INSERT INTO pesOPV_vpl VALUES ("DT12_32","006_12_32","DEU","12","32","32","هر‌آنچه من به شما امر می‌فرمایم متوجه شوید، تا آن را به عمل آورید، چیزی برآن میفزایید و چیزی از آن کم نکنید. ");
INSERT INTO pesOPV_vpl VALUES ("DT13_1","006_13_1","DEU","13","1","1","اگر در میان تو نبی‌ای یا بیننده خواب ازمیان شما برخیزد، و آیت یا معجزه‌ای برای شما ظاهر سازد، ");
INSERT INTO pesOPV_vpl VALUES ("DT13_2","006_13_2","DEU","13","2","2","و آن آیت یا معجزه واقع شود که از آن تو را خبر داده، گفت خدایان غیر راکه نمی شناسی پیروی نماییم، و آنها را عبادت کنیم، ");
INSERT INTO pesOPV_vpl VALUES ("DT13_3","006_13_3","DEU","13","3","3","سخنان آن نبی یا بیننده خواب را مشنو، زیرا که یهوه، خدای شما، شما را امتحان می‌کند، تا بداند که آیا یهوه، خدای خود را به تمامی دل وبه تمامی جان خود محبت می‌نمایید؟ ");
INSERT INTO pesOPV_vpl VALUES ("DT13_4","006_13_4","DEU","13","4","4","یهوه خدای خود را پیروی نمایید و از او بترسید، واوامر او را نگاه دارید، و قول او را بشنوید و او راعبادت نموده، به او ملحق شوید. ");
INSERT INTO pesOPV_vpl VALUES ("DT13_5","006_13_5","DEU","13","5","5","و آن نبی یابیننده خواب کشته شود، زیرا که سخنان فتنه انگیز بر یهوه خدای شما که شما را از زمین مصر بیرون آورد، و تو را از خانه بندگی فدیه داد، گفته است تا تو را از طریقی که یهوه خدایت به توامر فرمود تا با آن سلوک نمایی، منحرف سازد، پس به این طور بدی را از میان خود دور خواهی کرد. ");
INSERT INTO pesOPV_vpl VALUES ("DT13_6","006_13_6","DEU","13","6","6","و اگر برادرت که پسر مادرت باشد یا پسر یادختر تو یا زن هم آغوش تو یا رفیقت که مثل جان تو باشد، تو را در خفا اغوا کند، و گوید که برویم وخدایان غیر را که تو و پدران تو نشناختید عبادت نماییم، ");
INSERT INTO pesOPV_vpl VALUES ("DT13_7","006_13_7","DEU","13","7","7","از خدایان امتهایی که به اطراف شمامی باشند، خواه به تو نزدیک و خواه از تو دورباشند، از اقصای زمین تا اقصای دیگر آن، ");
INSERT INTO pesOPV_vpl VALUES ("DT13_8","006_13_8","DEU","13","8","8","او راقبول مکن و او را گوش مده، و چشم تو بر وی رحم نکند و بر او شفقت منما و او را پنهان مکن. ");
INSERT INTO pesOPV_vpl VALUES ("DT13_9","006_13_9","DEU","13","9","9","البته او را به قتل رسان، دست تو اول به قتل اودراز شود و بعد دست تمامی قوم. ");
INSERT INTO pesOPV_vpl VALUES ("DT13_10","006_13_10","DEU","13","10","10","و او را به سنگ سنگسار نما تا بمیرد، چونکه می‌خواست تو را از یهوه، خدایت، که تو را از زمین مصر ازخانه بندگی بیرون آورد، منحرف سازد. ");
INSERT INTO pesOPV_vpl VALUES ("DT13_11","006_13_11","DEU","13","11","11","وجمیع اسرائیلیان چون بشنوند، خواهند ترسید وبار دیگر چنین امر زشت را در میان شما مرتکب نخواهند شد. ");
INSERT INTO pesOPV_vpl VALUES ("DT13_12","006_13_12","DEU","13","12","12","اگر درباره یکی از شهرهایی که یهوه خدایت به تو به جهت سکونت می‌دهد خبر یابی، ");
INSERT INTO pesOPV_vpl VALUES ("DT13_13","006_13_13","DEU","13","13","13","که بعضی پسران بلیعال از میان تو بیرون رفته، ساکنان شهر خود را منحرف ساخته، گفته اندبرویم و خدایان غیر را که نشناخته‌اید، عبادت نماییم، ");
INSERT INTO pesOPV_vpl VALUES ("DT13_14","006_13_14","DEU","13","14","14","آنگاه تفحص و تجسس نموده، نیکواستفسار نما. و اینک اگر این امر، صحیح و یقین باشد که این رجاست در میان تو معمول شده است، ");
INSERT INTO pesOPV_vpl VALUES ("DT13_15","006_13_15","DEU","13","15","15","البته ساکنان آن شهر را به دم شمشیربکش و آن را با هرچه در آن است و بهایمش را به دم شمشیر هلاک نما. ");
INSERT INTO pesOPV_vpl VALUES ("DT13_16","006_13_16","DEU","13","16","16","و همه غنیمت آن را در میان کوچه‌اش جمع کن و شهر را با تمامی غنیمتش برای یهوه خدایت به آتش بالکل بسوزان، و آن تا به ابد تلی خواهد بود و بار دیگربنا نخواهد شد. ");
INSERT INTO pesOPV_vpl VALUES ("DT13_17","006_13_17","DEU","13","17","17","و از چیزهای حرام شده چیزی به‌دستت نچسبد تا خداوند از شدت خشم خود برگشته، برتو رحمت و رافت بنماید، و تو را بیفزاید بطوری که برای پدرانت قسم خورده بود. ");
INSERT INTO pesOPV_vpl VALUES ("DT13_18","006_13_18","DEU","13","18","18","هنگامی که قول یهوه خدای خودرا شنیده، و همه اوامرش را که من امروز به تو امرمی فرمایم نگاه داشته، آنچه در نظر یهوه خدایت راست است، بعمل آورده باشی. ");
INSERT INTO pesOPV_vpl VALUES ("DT14_1","006_14_1","DEU","14","1","1","شما پسران یهوه خدای خود هستید، پس برای مردگان، خویشتن را مجروح منمایید، و مابین چشمان خود را متراشید. ");
INSERT INTO pesOPV_vpl VALUES ("DT14_2","006_14_2","DEU","14","2","2","زیراتو برای یهوه، خدایت، قوم مقدس هستی، وخداوند تو را برای خود برگزیده است تا از جمیع امتهایی که برروی زمین‌اند به جهت او قوم خاص باشی. ");
INSERT INTO pesOPV_vpl VALUES ("DT14_3","006_14_3","DEU","14","3","3","هیچ‌چیز مکروه مخور. ");
INSERT INTO pesOPV_vpl VALUES ("DT14_4","006_14_4","DEU","14","4","4","این است حیواناتی که بخورید: گاو و گوسفند و بز، ");
INSERT INTO pesOPV_vpl VALUES ("DT14_5","006_14_5","DEU","14","5","5","و آهو و غزال وگور و بزکوهی و ریم و گاو دشتی و مهات. ");
INSERT INTO pesOPV_vpl VALUES ("DT14_6","006_14_6","DEU","14","6","6","و هرحیوان شکافته سم که سم را به دو حصه شکافته دارد و نشخوار کند، آن را از بهایم بخورید. ");
INSERT INTO pesOPV_vpl VALUES ("DT14_7","006_14_7","DEU","14","7","7","لیکن از نشخوارکنندگان و شکافتگان سم اینهارا مخورید: یعنی شتر و خرگوش و ونک، زیرا که نشخوار می‌کنند اما شکافته سم نیستند. اینهابرای شما نجس‌اند. ");
INSERT INTO pesOPV_vpl VALUES ("DT14_8","006_14_8","DEU","14","8","8","و خوک زیرا شکافته سم است، لیکن نشخوار نمی کند، این برای شما نجس است. از گوشت آنها مخورید و لاش آنها را لمس مکنید. ");
INSERT INTO pesOPV_vpl VALUES ("DT14_9","006_14_9","DEU","14","9","9","از همه آنچه در آب است اینها را بخورید: هرچه پر و فلس دارد، آنها را بخورید. ");
INSERT INTO pesOPV_vpl VALUES ("DT14_10","006_14_10","DEU","14","10","10","و هرچه پر و فلس ندارد مخورید، برای شما نجس است. ");
INSERT INTO pesOPV_vpl VALUES ("DT14_11","006_14_11","DEU","14","11","11","از همه مرغان طاهر بخورید. ");
INSERT INTO pesOPV_vpl VALUES ("DT14_12","006_14_12","DEU","14","12","12","و این است آنهایی که نخورید: عقاب و استخوان خوار و نسربحر، ");
INSERT INTO pesOPV_vpl VALUES ("DT14_13","006_14_13","DEU","14","13","13","و لاشخوار و شاهین و کرکس به اجناس آن؛ ");
INSERT INTO pesOPV_vpl VALUES ("DT14_14","006_14_14","DEU","14","14","14","و هر غراب به اجناس آن؛ ");
INSERT INTO pesOPV_vpl VALUES ("DT14_15","006_14_15","DEU","14","15","15","و شترمرغ وجغد و مرغ دریایی و باز، به اجناس آن؛ ");
INSERT INTO pesOPV_vpl VALUES ("DT14_16","006_14_16","DEU","14","16","16","و بوم و بوتیمار و قاز؛ ");
INSERT INTO pesOPV_vpl VALUES ("DT14_17","006_14_17","DEU","14","17","17","و قائت و رخم و غواص؛ ");
INSERT INTO pesOPV_vpl VALUES ("DT14_18","006_14_18","DEU","14","18","18","ولقلق و کلنک، به اجناس آن؛ و هدهد و شبپره. ");
INSERT INTO pesOPV_vpl VALUES ("DT14_19","006_14_19","DEU","14","19","19","و همه حشرات بالدار برای شما نجس‌اند؛ خورده نشوند. ");
INSERT INTO pesOPV_vpl VALUES ("DT14_20","006_14_20","DEU","14","20","20","اما از همه مرغان طاهربخورید. ");
INSERT INTO pesOPV_vpl VALUES ("DT14_21","006_14_21","DEU","14","21","21","هیچ میته مخورید؛ به غریبی که درون دروازه های تو باشد بده تا بخورد، یا به اجنبی بفروش، زیرا که تو برای یهوه، خدایت، قوم مقدس هستی و بزغاله را در شیر مادرش مپز. ");
INSERT INTO pesOPV_vpl VALUES ("DT14_22","006_14_22","DEU","14","22","22","عشر تمامی محصولات مزرعه خود را که سال به سال از زمین برآید، البته بده. ");
INSERT INTO pesOPV_vpl VALUES ("DT14_23","006_14_23","DEU","14","23","23","و به حضور یهوه خدایت در مکانی که برگزیند تا نام خود را در آنجا ساکن سازد، عشر غله و شیره وروغن خود را و نخست زادگان رمه و گله خویش را بخور، تا بیاموزی که از یهوه خدایت همه اوقات بترسی. ");
INSERT INTO pesOPV_vpl VALUES ("DT14_24","006_14_24","DEU","14","24","24","و اگر راه از برایت دور باشد که آن را نمی توانی برد، و آن مکانی که یهوه، خدایت، خواهد برگزید تا نام خود را در آن بگذارد، وقتی که یهوه، خدایت، تو را برکت دهد، از تو دور باشد. ");
INSERT INTO pesOPV_vpl VALUES ("DT14_25","006_14_25","DEU","14","25","25","پس آن را به نقره بفروش و نقره را بدست خود گرفته، به مکانی که یهوه خدایت برگزیند، برو. ");
INSERT INTO pesOPV_vpl VALUES ("DT14_26","006_14_26","DEU","14","26","26","و نقره را برای هرچه دلت می‌خواهد از گاو و گوسفند و شراب و مسکرات و هرچه دلت از تو بطلبد، بده، و در آنجا بحضوریهوه، خدایت، بخور و خودت با خاندانت شادی نما. ");
INSERT INTO pesOPV_vpl VALUES ("DT14_27","006_14_27","DEU","14","27","27","و لاوی‌ای را که اندرون دروازه هایت باشد، ترک منما چونکه او را با تو حصه و نصیبی نیست. ");
INSERT INTO pesOPV_vpl VALUES ("DT14_28","006_14_28","DEU","14","28","28","و در آخر هر سه سال تمام عشر محصول خود را در همان سال بیرون آورده، در اندرون دروازه هایت ذخیره نما. ");
INSERT INTO pesOPV_vpl VALUES ("DT14_29","006_14_29","DEU","14","29","29","و لاوی چونکه با توحصه و نصیبی ندارد و غریب و یتیم و بیوه‌زنی که درون دروازه هایت باشند، بیایند و بخورند و سیرشوند، تا یهوه، خدایت، تو را در همه اعمال دستت که می‌کنی، برکت دهد. ");
INSERT INTO pesOPV_vpl VALUES ("DT15_1","006_15_1","DEU","15","1","1","و در آخر هر هفت سال، انفکاک نمایی. ");
INSERT INTO pesOPV_vpl VALUES ("DT15_2","006_15_2","DEU","15","2","2","و قانون انفکاک این باشد، هرطلبکاری قرضی را که به همسایه خود داده باشدمنفک سازد، و از همسایه و برادر خود مطالبه نکند، چونکه انفکاک خداوند اعلان شده است. ");
INSERT INTO pesOPV_vpl VALUES ("DT15_3","006_15_3","DEU","15","3","3","از غریب مطالبه توانی کرد، اما هرآنچه از مال تو نزد برادرت باشد، دست تو آن را منفک سازد. ");
INSERT INTO pesOPV_vpl VALUES ("DT15_4","006_15_4","DEU","15","4","4","تا نزد تو هیچ فقیر نباشد، زیرا که خداوند تو رادر زمینی که یهوه، خدایت، برای نصیب و ملک به تو می‌دهد، البته برکت خواهد داد، ");
INSERT INTO pesOPV_vpl VALUES ("DT15_5","006_15_5","DEU","15","5","5","اگر قول یهوه، خدایت، را به دقت بشنوی تا متوجه شده، جمیع این اوامر را که من امروز به تو امر می‌فرمایم بجا آوری. ");
INSERT INTO pesOPV_vpl VALUES ("DT15_6","006_15_6","DEU","15","6","6","زیرا که یهوه، خدایت، تو را چنانکه گفته است برکت خواهد داد، و به امتهای بسیارقرض خواهی داد، لیکن تو مدیون نخواهی شد، وبر امتهای بسیار تسلط خواهی نمود، و ایشان برتو مسلط نخواهند شد. ");
INSERT INTO pesOPV_vpl VALUES ("DT15_7","006_15_7","DEU","15","7","7","اگر نزد تو در یکی از دروازه هایت، در زمینی که یهوه، خدایت، به تو می‌بخشد، یکی ازبرادرانت فقیر باشد، دل خود را سخت مساز، ودستت را بر برادر فقیر خود مبند. ");
INSERT INTO pesOPV_vpl VALUES ("DT15_8","006_15_8","DEU","15","8","8","بلکه البته دست خود را بر او گشاده دار، و به قدر کفایت، موافق احتیاج او به او قرض بده. ");
INSERT INTO pesOPV_vpl VALUES ("DT15_9","006_15_9","DEU","15","9","9","و باحذر باش مبادا در دل تو فکر زشت باشد، و بگویی سال هفتم یعنی سال انفکاک نزدیک است، و چشم توبر برادر فقیر خود بد شده، چیزی به او ندهی و اواز تو نزد خداوند فریاد برآورده، برایت گناه باشد. ");
INSERT INTO pesOPV_vpl VALUES ("DT15_10","006_15_10","DEU","15","10","10","البته به او بدهی و دلت از دادنش آزرده نشود، زیرا که به عوض این کار یهوه، خدایت، تو را درتمامی کارهایت و هرچه دست خود را بر آن درازمی کنی، برکت خواهد داد. ");
INSERT INTO pesOPV_vpl VALUES ("DT15_11","006_15_11","DEU","15","11","11","چونکه فقیر اززمینت معدوم نخواهد شد، بنابراین من تو را امرفرموده، می‌گویم البته دست خود را برای برادرمسکین و فقیر خود که در زمین تو باشند، گشاده دار. ");
INSERT INTO pesOPV_vpl VALUES ("DT15_12","006_15_12","DEU","15","12","12","اگر مرد یا زن عبرانی از برادرانت به توفروخته شود، و او تو را شش سال خدمت نماید، پس در سال هفتم او را از نزد خود آزاد کرده، رها کن. ");
INSERT INTO pesOPV_vpl VALUES ("DT15_13","006_15_13","DEU","15","13","13","و چون او را از نزد خود آزاد کرده، رهامی کنی، او را تهی‌دست روانه مساز. ");
INSERT INTO pesOPV_vpl VALUES ("DT15_14","006_15_14","DEU","15","14","14","او را ازگله و خرمن و چرخشت خود البته زاد بده، به اندازه‌ای که یهوه، خدایت، تو را برکت داده باشدبه او بده. ");
INSERT INTO pesOPV_vpl VALUES ("DT15_15","006_15_15","DEU","15","15","15","و بیادآور که تو در زمین مصر غلام بودی و یهوه، خدایت، تو را فدیه داد، بنابراین من امروز این را به تو امر می‌فرمایم، ");
INSERT INTO pesOPV_vpl VALUES ("DT15_16","006_15_16","DEU","15","16","16","و اگر به توگوید از نزد تو بیرون نمی روم چونکه تو را وخاندان تو را دوست دارد و او را نزد تو خوش گذشته باشد، ");
INSERT INTO pesOPV_vpl VALUES ("DT15_17","006_15_17","DEU","15","17","17","آنگاه درفشی گرفته، گوشش را باآن به دربدوز تا تو را غلام ابدی باشد، و با کنیزخود نیز چنین عمل نما. ");
INSERT INTO pesOPV_vpl VALUES ("DT15_18","006_15_18","DEU","15","18","18","و چون او را از نزد خود آزاد کرده، رهامی کنی، بنظرت بد نیاید، زیرا که دو برابر اجرت اجیر، تو را شش سال خدمت کرده است. و یهوه خدایت در هرچه می‌کنی تو را برکت خواهد داد. ");
INSERT INTO pesOPV_vpl VALUES ("DT15_19","006_15_19","DEU","15","19","19","همه نخست زادگان نرینه را که از رمه و گله تو زاییده شوند برای یهوه، خدای خود، تقدیس نما، و با نخست زاده گاو خود کار مکن ونخست زاده گوسفند خود را پشم مبر. ");
INSERT INTO pesOPV_vpl VALUES ("DT15_20","006_15_20","DEU","15","20","20","آنها رابه حضور یهوه خدای خود در مکانی که خداوندبرگزیند، تو و اهل خانه ات سال به سال بخورید. ");
INSERT INTO pesOPV_vpl VALUES ("DT15_21","006_15_21","DEU","15","21","21","لیکن اگر عیبی داشته باشد، مثلا لنگ یا کور یاهر عیب دیگر، آن را برای یهوه خدایت ذبح مکن. ");
INSERT INTO pesOPV_vpl VALUES ("DT15_22","006_15_22","DEU","15","22","22","آن را در اندرون دروازه هایت بخور، شخص نجس و شخص طاهر، آن را برابر مثل غزال و آهوبخورند. ");
INSERT INTO pesOPV_vpl VALUES ("DT15_23","006_15_23","DEU","15","23","23","اما خونش را مخور. آن را مثل آب بر زمین بریز. ");
INSERT INTO pesOPV_vpl VALUES ("DT16_1","006_16_1","DEU","16","1","1","ماه ابیب را نگاهدار و فصح را به جهت یهوه، خدایت، بجا آور، زیرا که در ماه ابیب یهوه، خدایت، تو را از مصر در شب بیرون آورد. ");
INSERT INTO pesOPV_vpl VALUES ("DT16_2","006_16_2","DEU","16","2","2","پس فصح را از رمه و گله برای یهوه، خدایت، ذبح کن، در مکانی که خداوند برگزیند، تا نام خود را در آن ساکن سازد. ");
INSERT INTO pesOPV_vpl VALUES ("DT16_3","006_16_3","DEU","16","3","3","با آن، خمیرمایه مخور، هفت روز نان فطیر یعنی نان مشقت را باآن بخور، زیرا که به تعجیل از زمین مصر بیرون آمدی، تا روز خروج خود را از زمین مصر درتمامی روزهای عمرت بیاد آوری. ");
INSERT INTO pesOPV_vpl VALUES ("DT16_4","006_16_4","DEU","16","4","4","پس هفت روز هیچ خمیرمایه در تمامی حدودت دیده نشود، و از گوشتی که در شام روز اول، ذبح می‌کنی چیزی تا صبح باقی نماند. ");
INSERT INTO pesOPV_vpl VALUES ("DT16_5","006_16_5","DEU","16","5","5","فصح را درهر یکی از دروازه هایت که یهوه خدایت به تومی دهد، ذبح نتوانی کرد. ");
INSERT INTO pesOPV_vpl VALUES ("DT16_6","006_16_6","DEU","16","6","6","بلکه در مکانی که یهوه، خدایت، برگزیند تا نام خود را در آن ساکن سازد، در آنجا فصح را در شام، وقت غروب آفتاب، هنگام بیرون آمدنت از مصر ذبح کن. ");
INSERT INTO pesOPV_vpl VALUES ("DT16_7","006_16_7","DEU","16","7","7","وآن را در مکانی که یهوه، خدایت، برگزیند بپز وبخور و بامدادان برخاسته، به خیمه هایت برو. ");
INSERT INTO pesOPV_vpl VALUES ("DT16_8","006_16_8","DEU","16","8","8","شش روز نان فطیر بخور، و در روز هفتم، جشن مقدس برای یهوه خدایت باشد، در آن هیچ کارمکن. ");
INSERT INTO pesOPV_vpl VALUES ("DT16_9","006_16_9","DEU","16","9","9","هفت هفته برای خود بشمار. از ابتدای نهادن داس در زرع خود، شمردن هفت هفته را شروع کن. ");
INSERT INTO pesOPV_vpl VALUES ("DT16_10","006_16_10","DEU","16","10","10","و عید هفته‌ها را با هدیه نوافل دست خودنگاهدار و آن را به اندازه برکتی که یهوه خدایت به تو دهد، بده. ");
INSERT INTO pesOPV_vpl VALUES ("DT16_11","006_16_11","DEU","16","11","11","و به حضور یهوه، خدایت، شادی نما تو و پسرت و دخترت و غلامت و کنیزت ولاوی که درون دروازه هایت باشد و غریب و یتیم و بیوه‌زنی که در میان تو باشند، در مکانی که یهوه خدایت برگزیند تا نام خود را در آن ساکن گرداند. ");
INSERT INTO pesOPV_vpl VALUES ("DT16_12","006_16_12","DEU","16","12","12","و بیاد آور که در مصر غلام بودی، پس متوجه شده، این فرایض را بجا آور. ");
INSERT INTO pesOPV_vpl VALUES ("DT16_13","006_16_13","DEU","16","13","13","عید خیمه‌ها را بعد از جمع کردن حاصل ازخرمن، و چرخشت خود هفت روز نگاهدار. ");
INSERT INTO pesOPV_vpl VALUES ("DT16_14","006_16_14","DEU","16","14","14","ودر عید خود شادی نما، تو و پسرت و دخترت وغلامت و کنیزت و لاوی و غریب و یتیم وبیوه‌زنی که درون دروازه هایت باشند. ");
INSERT INTO pesOPV_vpl VALUES ("DT16_15","006_16_15","DEU","16","15","15","هفت روز در مکانی که خداوند برگزیند، برای یهوه خدایت عید نگاه دار، زیرا که یهوه خدایت تو رادر همه محصولت و در تمامی اعمال دستت برکت خواهد داد، و بسیار شادمان خواهی بود. ");
INSERT INTO pesOPV_vpl VALUES ("DT16_16","006_16_16","DEU","16","16","16","سه مرتبه در سال جمیع ذکورانت به حضوریهوه خدایت در مکانی که او برگزیند حاضرشوند، یعنی در عید فطیر و عید هفته‌ها و عیدخیمه‌ها و به حضور خداوند تهی‌دست حاضرنشوند. ");
INSERT INTO pesOPV_vpl VALUES ("DT16_17","006_16_17","DEU","16","17","17","هر کس به قدر قوه خود به اندازه برکتی که یهوه، خدایت، به تو عطا فرماید، بدهد. ");
INSERT INTO pesOPV_vpl VALUES ("DT16_18","006_16_18","DEU","16","18","18","داوران و سروران در جمیع دروازه هایی که یهوه، خدایت، به تو می‌دهد برحسب اسباط خود برایت تعیین نما، تا قوم را به حکم عدل، داوری نمایند. ");
INSERT INTO pesOPV_vpl VALUES ("DT16_19","006_16_19","DEU","16","19","19","داوری را منحرف مساز و طرفداری منما و رشوه مگیر، زیرا که رشوه چشمان حکمارا کور می‌سازد و سخنان عادلان را کج می‌نماید. ");
INSERT INTO pesOPV_vpl VALUES ("DT16_20","006_16_20","DEU","16","20","20","انصاف کامل را پیروی نما تا زنده مانی وزمینی را که یهوه خدایت به تو می‌دهد، مالک شوی. ");
INSERT INTO pesOPV_vpl VALUES ("DT16_21","006_16_21","DEU","16","21","21","اشیره‌ای از هیچ نوع درخت نزد مذبح یهوه، خدایت، که برای خود خواهی ساخت غرس منما. ");
INSERT INTO pesOPV_vpl VALUES ("DT16_22","006_16_22","DEU","16","22","22","و ستونی برای خود نصب مکن زیرا یهوه خدایت آن را مکروه می‌دارد. ");
INSERT INTO pesOPV_vpl VALUES ("DT17_1","006_17_1","DEU","17","1","1","گاو یا گوسفندی که در آن عیب یا هیچ چیز بد باشد، برای یهوه خدای خودذبح منما، چونکه آن، نزد یهوه خدایت مکروه است. ");
INSERT INTO pesOPV_vpl VALUES ("DT17_2","006_17_2","DEU","17","2","2","اگر در میان تو، در یکی از دروازه هایت که یهوه خدایت به تو می‌دهد، مرد یا زنی پیدا شودکه در نظر یهوه، خدایت، کار ناشایسته نموده، ازعهد او تجاوز کند، ");
INSERT INTO pesOPV_vpl VALUES ("DT17_3","006_17_3","DEU","17","3","3","و رفته خدایان غیر را عبادت کرده، سجده نماید، خواه آفتاب یا ماه یا هر یک از جنود آسمان که من امر نفرموده‌ام، ");
INSERT INTO pesOPV_vpl VALUES ("DT17_4","006_17_4","DEU","17","4","4","و از آن اطلاع یافته، بشنوی، پس نیکو تفحص کن. واینک اگر راست و یقین باشد که این رجاست دراسرائیل واقع شده است، ");
INSERT INTO pesOPV_vpl VALUES ("DT17_5","006_17_5","DEU","17","5","5","آنگاه آن مرد یا زن راکه این کار بد را در دروازه هایت کرده است، بیرون آور، و آن مرد یا زن را با سنگها سنگسار کن تابمیرند. ");
INSERT INTO pesOPV_vpl VALUES ("DT17_6","006_17_6","DEU","17","6","6","از گواهی دو یا سه شاهد، آن شخصی که مستوجب مرگ است کشته شود؛ از گواهی یک نفر کشته نشود. ");
INSERT INTO pesOPV_vpl VALUES ("DT17_7","006_17_7","DEU","17","7","7","اولا دست شاهدان به جهت کشتنش بر او افراشته شود، و بعد از آن، دست تمامی قوم، پس بدی را از میان خود دورکرده‌ای. ");
INSERT INTO pesOPV_vpl VALUES ("DT17_8","006_17_8","DEU","17","8","8","اگر در میان تو امری که حکم بر آن مشکل شود به ظهور آید، در میان خون و خون، و درمیان دعوی و دعوی، و در میان ضرب و ضرب، از مرافعه هایی که در دروازه هایت واقع شود، آنگاه برخاسته، به مکانی که یهوه، خدایت، برگزیند، برو. ");
INSERT INTO pesOPV_vpl VALUES ("DT17_9","006_17_9","DEU","17","9","9","و نزد لاویان کهنه و نزد داوری که در آن روزها باشد رفته، مسالت نما و ایشان تو رااز فتوای قضا مخبر خواهند ساخت. ");
INSERT INTO pesOPV_vpl VALUES ("DT17_10","006_17_10","DEU","17","10","10","وبرحسب فتوایی که ایشان از مکانی که خداوندبرگزیند، برای تو بیان می‌کنند، عمل نما. وهوشیار باش تا موافق هر‌آنچه به تو تعلیم دهند، عمل نمایی. ");
INSERT INTO pesOPV_vpl VALUES ("DT17_11","006_17_11","DEU","17","11","11","موافق مضمون شریعتی که به توتعلیم دهند، و مطابق حکمی که به تو گویند، عمل نما، و از فتوایی که برای تو بیان می‌کنند به طرف راست یا چپ تجاوز مکن. ");
INSERT INTO pesOPV_vpl VALUES ("DT17_12","006_17_12","DEU","17","12","12","و شخصی که از روی تکبر رفتار نماید، و کاهنی را که به حضوریهوه، خدایت، به جهت خدمت در آنجامی ایستد یا داور را گوش نگیرد، آن شخص کشته شود. پس بدی را از میان اسرائیل دور کرده‌ای. ");
INSERT INTO pesOPV_vpl VALUES ("DT17_13","006_17_13","DEU","17","13","13","و تمامی قوم چون این را بشنوند، خواهندترسید و بار دیگر از روی تکبر رفتار نخواهندنمود. ");
INSERT INTO pesOPV_vpl VALUES ("DT17_14","006_17_14","DEU","17","14","14","چون به زمینی که یهوه، خدایت، به تومی دهد، داخل شوی و در آن تصرف نموده، ساکن شوی و بگویی مثل جمیع امتهایی که به اطراف منند پادشاهی بر خود نصب نمایم، ");
INSERT INTO pesOPV_vpl VALUES ("DT17_15","006_17_15","DEU","17","15","15","البته پادشاهی را که یهوه خدایت برگزیند برخود نصب نما. یکی از برادرانت را بر خود پادشاه بساز، و مرد بیگانه‌ای را که از برادرانت نباشد، نمی توانی بر خود مسلط نمایی. ");
INSERT INTO pesOPV_vpl VALUES ("DT17_16","006_17_16","DEU","17","16","16","لکن او برای خود اسبهای بسیار نگیرد، و قوم را به مصر پس نفرستد، تا اسبهای بسیار برای خود بگیرد، چونکه خداوند به شما گفته است بار دیگر به آن راه برنگردید. ");
INSERT INTO pesOPV_vpl VALUES ("DT17_17","006_17_17","DEU","17","17","17","و برای خود زنان بسیار نگیرد، مبادا دلش منحرف شود، و نقره و طلا برای خودبسیار زیاده نیندوزد. ");
INSERT INTO pesOPV_vpl VALUES ("DT17_18","006_17_18","DEU","17","18","18","و چون بر تخت مملکت خود بنشیند، نسخه این شریعت را از آنچه از آن، نزد لاویان کهنه است برای خود در طوماری بنویسد. ");
INSERT INTO pesOPV_vpl VALUES ("DT17_19","006_17_19","DEU","17","19","19","و آن نزد او باشد و همه روزهای عمرش آن را بخواند، تا بیاموزد که از یهوه خدای خود بترسد، و همه کلمات این شریعت و این فرایض را نگاه داشته، به عمل آورد. ");
INSERT INTO pesOPV_vpl VALUES ("DT17_20","006_17_20","DEU","17","20","20","مبادا دل او بر برادرانش افراشته شود، و از این اوامر به طرف چپ یا راست منحرف شود، تا آنکه او وپسرانش در مملکت او در میان اسرائیل روزهای طویل داشته باشند. ");
INSERT INTO pesOPV_vpl VALUES ("DT18_1","006_18_1","DEU","18","1","1","لاویان کهنه و تمامی سبط لاوی راحصه و نصیبی با اسرائیل نباشد. ");
INSERT INTO pesOPV_vpl VALUES ("DT18_2","006_18_2","DEU","18","2","2","پس ایشان در میان برادران خود نصیب نخواهندداشت. خداوند نصیب ایشان است، چنانکه به ایشان گفته است. ");
INSERT INTO pesOPV_vpl VALUES ("DT18_3","006_18_3","DEU","18","3","3","و حق کاهنان از قوم، یعنی از آنانی که قربانی، خواه از گاو و خواه از گوسفندمی گذرانند، این است که دوش و دو بنا گوش وشکنبه را به کاهن بدهند. ");
INSERT INTO pesOPV_vpl VALUES ("DT18_4","006_18_4","DEU","18","4","4","و نوبر غله و شیره وروغن خود و اول چین پشم گوسفند خود را به اوبده، ");
INSERT INTO pesOPV_vpl VALUES ("DT18_5","006_18_5","DEU","18","5","5","زیرا که یهوه، خدایت، او را از همه اسباطت برگزیده است، تا او و پسرانش همیشه بایستند و به نام خداوند خدمت نمایند. ");
INSERT INTO pesOPV_vpl VALUES ("DT18_6","006_18_6","DEU","18","6","6","و اگر احدی از لاویان از یکی ازدروازه هایت از هر جایی در اسرائیل که در آنجاساکن باشد آمده، به تمامی آرزوی دل خود به مکانی که خداوند برگزیند، برسد، ");
INSERT INTO pesOPV_vpl VALUES ("DT18_7","006_18_7","DEU","18","7","7","پس به نام یهوه خدای خود، مثل سایر برادرانش از لاویانی که در آنجا به حضور خداوند می‌ایستند، خدمت نماید. ");
INSERT INTO pesOPV_vpl VALUES ("DT18_8","006_18_8","DEU","18","8","8","حصه های برابر بخورند، سوای آنچه ازارثیت خود بفروشد. ");
INSERT INTO pesOPV_vpl VALUES ("DT18_9","006_18_9","DEU","18","9","9","چون به زمینی که یهوه، خدایت، به تومی دهد داخل شوی، یاد مگیر که موافق رجاسات آن امتها عمل نمایی. ");
INSERT INTO pesOPV_vpl VALUES ("DT18_10","006_18_10","DEU","18","10","10","و در میان تو کسی یافت نشود که پسر یا دختر خود را از آتش بگذرانند، ونه فالگیر و نه غیب گو و نه افسونگر و نه جادوگر، ");
INSERT INTO pesOPV_vpl VALUES ("DT18_11","006_18_11","DEU","18","11","11","و نه ساحر و نه سوال کننده از اجنه و نه رمال ونه کسی‌که از مردگان مشورت می‌کند. ");
INSERT INTO pesOPV_vpl VALUES ("DT18_12","006_18_12","DEU","18","12","12","زیرا هرکه این کارها را کند، نزد خداوند مکروه است وبه‌سبب این رجاسات، یهوه، خدایت، آنها را ازحضور تو اخراج می‌کند. ");
INSERT INTO pesOPV_vpl VALUES ("DT18_13","006_18_13","DEU","18","13","13","نزد یهوه، خدایت، کامل باش. ");
INSERT INTO pesOPV_vpl VALUES ("DT18_14","006_18_14","DEU","18","14","14","زیرا این امتهایی که تو آنها را بیرون می‌کنی به غیب گویان و فالگیران گوش می‌گیرند، و اما یهوه، خدایت، تو را نمی گذارد که چنین بکنی. ");
INSERT INTO pesOPV_vpl VALUES ("DT18_15","006_18_15","DEU","18","15","15","یهوه، خدایت، نبی‌ای را از میان تو ازبرادرانت، مثل من برای تو مبعوث خواهدگردانید، او را بشنوید. ");
INSERT INTO pesOPV_vpl VALUES ("DT18_16","006_18_16","DEU","18","16","16","موافق هر‌آنچه درحوریب در روز اجتماع از یهوه خدای خودمسالت نموده، گفتی: «آواز یهوه خدای خود رادیگر نشنوم، و این آتش عظیم را دیگر نبینم، مبادابمیرم.» ");
INSERT INTO pesOPV_vpl VALUES ("DT18_17","006_18_17","DEU","18","17","17","و خداوند به من گفت: «آنچه گفتندنیکو گفتند. ");
INSERT INTO pesOPV_vpl VALUES ("DT18_18","006_18_18","DEU","18","18","18","نبی‌ای را برای ایشان از میان برادران ایشان مثل تو مبعوث خواهم کرد، و کلام خود را به دهانش خواهم گذاشت و هر‌آنچه به اوامر فرمایم به ایشان خواهد گفت. ");
INSERT INTO pesOPV_vpl VALUES ("DT18_19","006_18_19","DEU","18","19","19","و هر کسی‌که سخنان مرا که او به اسم من گوید نشنود، من ازاو مطالبه خواهم کرد. ");
INSERT INTO pesOPV_vpl VALUES ("DT18_20","006_18_20","DEU","18","20","20","و اما نبی‌ای که جسارت نموده، به اسم من سخن گوید که به گفتنش امرنفرمودم، یا به اسم خدایان غیر سخن گوید، آن نبی البته کشته شود.» ");
INSERT INTO pesOPV_vpl VALUES ("DT18_21","006_18_21","DEU","18","21","21","و اگر در دل خود گویی: «سخنی را که خداوند نگفته است، چگونه تشخیص نماییم.» ");
INSERT INTO pesOPV_vpl VALUES ("DT18_22","006_18_22","DEU","18","22","22","هنگامی که نبی به اسم خداوند سخن گوید، اگر آن چیز واقع نشود و به انجام نرسد، این امری است که خداوند نگفته است، بلکه آن نبی آن را از روی تکبر گفته است. پس از او نترس. ");
INSERT INTO pesOPV_vpl VALUES ("DT19_1","006_19_1","DEU","19","1","1","وقتی که خدایت این امتها را که یهوه، خدایت، زمین ایشان را به تو می‌دهدمنقطع سازد، و تو وارث ایشان شده، در شهرها وخانه های ایشان ساکن شوی، ");
INSERT INTO pesOPV_vpl VALUES ("DT19_2","006_19_2","DEU","19","2","2","پس سه شهر رابرای خود در میان زمینی که یهوه، خدایت، به جهت ملکیت به تو می‌دهد، جدا کن. ");
INSERT INTO pesOPV_vpl VALUES ("DT19_3","006_19_3","DEU","19","3","3","شاهراه رابرای خود درست کن، و حدود زمین خود را که یهوه خدایت برای تو تقسیم می‌کند، سه قسمت کن، تا هر قاتلی در آنجا فرار کند. ");
INSERT INTO pesOPV_vpl VALUES ("DT19_4","006_19_4","DEU","19","4","4","و این است حکم قاتلی که به آنجا فرار کرده، زنده ماند، هر‌که همسایه خود را نادانسته بکشد، و قبل از آن از او بغض نداشت. ");
INSERT INTO pesOPV_vpl VALUES ("DT19_5","006_19_5","DEU","19","5","5","مثل کسی‌که باهمسایه خود برای بریدن درخت در جنگل برود، و دستش برای قطع نمودن درخت تبر را بلند کند، و آهن از دسته بیرون رفته، به همسایه‌اش بخوردتا بمیرد، پس به یکی از آن شهرها فرار کرده، زنده ماند. ");
INSERT INTO pesOPV_vpl VALUES ("DT19_6","006_19_6","DEU","19","6","6","مبادا ولی خون وقتی که دلش گرم است قاتل را تعاقب کند، و به‌سبب مسافت راه به وی رسیده، او را بکشد، و او مستوجب موت نباشد، چونکه او را پیشتر بغض نداشت. ");
INSERT INTO pesOPV_vpl VALUES ("DT19_7","006_19_7","DEU","19","7","7","از این جهت من تو را امر فرموده، گفتم برای خود سه شهر جداکن. ");
INSERT INTO pesOPV_vpl VALUES ("DT19_8","006_19_8","DEU","19","8","8","و اگر یهوه، خدایت، حدود تو را به طوری که به پدرانت قسم خورده است وسیع گرداند، وتمامی زمین را به تو عطا فرماید، که به دادن آن به پدرانت وعده داده است، ");
INSERT INTO pesOPV_vpl VALUES ("DT19_9","006_19_9","DEU","19","9","9","و اگر تمامی این اوامررا که من امروز به تو می‌فرمایم نگاه داشته، بجا آوری که یهوه خدای خود را دوست داشته، به طریقهای او دائم سلوک نمایی، آنگاه سه شهردیگر بر این سه برای خود مزید کن. ");
INSERT INTO pesOPV_vpl VALUES ("DT19_10","006_19_10","DEU","19","10","10","تا خون بی‌گناه در زمینی که یهوه خدایت برای ملکیت به تو می‌دهد، ریخته نشود، و خون بر گردن تونباشد. ");
INSERT INTO pesOPV_vpl VALUES ("DT19_11","006_19_11","DEU","19","11","11","لیکن اگر کسی همسایه خود را بغض داشته، در کمین او باشد و بر او برخاسته، او راضرب مهلک بزند که بمیرد، و به یکی از این شهرها فرار کند، ");
INSERT INTO pesOPV_vpl VALUES ("DT19_12","006_19_12","DEU","19","12","12","آنگاه مشایخ شهرش فرستاده، او را از آنجا بگیرند، و او را به‌دست ولی خون تسلیم کنند، تا کشته شود. ");
INSERT INTO pesOPV_vpl VALUES ("DT19_13","006_19_13","DEU","19","13","13","چشم تو بر اوترحم نکند، تا خون بی‌گناهی را از اسرائیل دورکنی، و برای تو نیکو باشد. ");
INSERT INTO pesOPV_vpl VALUES ("DT19_14","006_19_14","DEU","19","14","14","حد همسایه خود را که پیشینیان گذاشته‌اند، در ملک تو که به‌دست تو خواهد آمد، در زمینی که یهوه خدایت برای تصرفش به تومی دهد، منتقل مساز. ");
INSERT INTO pesOPV_vpl VALUES ("DT19_15","006_19_15","DEU","19","15","15","یک شاهد بر کسی برنخیزد، به هر تقصیر وهر گناه از جمیع گناهانی که کرده باشد، به گواهی دو شاهد یا به گواهی سه شاهد هر امری ثابت شود. ");
INSERT INTO pesOPV_vpl VALUES ("DT19_16","006_19_16","DEU","19","16","16","اگر شاهد کاذبی بر کسی برخاسته، به معصیتش شهادت دهد، ");
INSERT INTO pesOPV_vpl VALUES ("DT19_17","006_19_17","DEU","19","17","17","آنگاه هر دو شخصی که منازعه در میان ایشان است، به حضور خداوندو به حضور کاهنان و داورانی که در آن زمان باشند، حاضر شوند. ");
INSERT INTO pesOPV_vpl VALUES ("DT19_18","006_19_18","DEU","19","18","18","و داوران، نیکو تفحص نمایند، و اینک اگر شاهد، شاهد کاذب است و بربرادر خود شهادت دروغ داده باشد، ");
INSERT INTO pesOPV_vpl VALUES ("DT19_19","006_19_19","DEU","19","19","19","پس به طوری که او خواست با برادر خود عمل نماید با او همان طور رفتار نمایند، تا بدی را از میان خوددور نمایی. ");
INSERT INTO pesOPV_vpl VALUES ("DT19_20","006_19_20","DEU","19","20","20","و چون بقیه مردمان بشنوند، خواهند ترسید، و بعد از آن مثل این کار زشت درمیان شما نخواهند کرد. ");
INSERT INTO pesOPV_vpl VALUES ("DT19_21","006_19_21","DEU","19","21","21","و چشم تو ترحم نکند، جان به عوض جان، و چشم به عوض چشم، و دندان به عوض دندان، و دست به عوض دست و پا به عوض پا. ");
INSERT INTO pesOPV_vpl VALUES ("DT20_1","006_20_1","DEU","20","1","1","چون برای مقاتله با دشمن خود بیرون روی، و اسبها و ارابه‌ها و قومی را زیاده از خودبینی، از ایشان مترس زیرا یهوه خدایت که تو را از زمین مصر برآورده است، با توست. ");
INSERT INTO pesOPV_vpl VALUES ("DT20_2","006_20_2","DEU","20","2","2","وچون به جنگ نزدیک شوید آنگاه کاهن پیش آمده، قوم را مخاطب سازد. ");
INSERT INTO pesOPV_vpl VALUES ("DT20_3","006_20_3","DEU","20","3","3","و ایشان را گوید: «ای اسرائیل بشنوید شما امروز برای مقاتله بادشمنان خود پیش می‌روید، دل شما ضعیف نشود، و از ایشان ترسان و لرزان و هراسان مباشید. ");
INSERT INTO pesOPV_vpl VALUES ("DT20_4","006_20_4","DEU","20","4","4","زیرا یهوه، خدای شما، با شما می‌رود، تا برای شما با دشمنان شما جنگ کرده شما رانجات دهد.» ");
INSERT INTO pesOPV_vpl VALUES ("DT20_5","006_20_5","DEU","20","5","5","و سروران، قوم را خطاب کرده، گویند: «کیست که خانه نو بنا کرده، آن راتخصیص نکرده است؛ او روانه شده، به خانه خودبرگردد، مبادا در جنگ بمیرد و دیگری آن راتخصیص نماید. ");
INSERT INTO pesOPV_vpl VALUES ("DT20_6","006_20_6","DEU","20","6","6","و کیست که تاکستانی غرس نموده، آن را حلال نکرده است؛ او روانه شده، به خانه خود برگردد، مبادا در جنگ بمیرد، ودیگری آن را حلال کند. ");
INSERT INTO pesOPV_vpl VALUES ("DT20_7","006_20_7","DEU","20","7","7","و کیست که دختری نامزد کرده، به نکاح در نیاورده است، او روانه شده، به خانه خود برگردد، مبادا در جنگ بمیرد ودیگری او را به نکاح درآورد.» ");
INSERT INTO pesOPV_vpl VALUES ("DT20_8","006_20_8","DEU","20","8","8","و سروران نیزقوم را خطاب کرده، گویند: «کیست که ترسان وضعیف دل است؛ او روانه شده، به خانه‌اش برگردد، مبادا دل برادرانش مثل دل او گداخته شود.» ");
INSERT INTO pesOPV_vpl VALUES ("DT20_9","006_20_9","DEU","20","9","9","و چون سروران از تکلم نمودن به قوم فارغ شوند، بر سر قوم، سرداران لشکر مقررسازند. ");
INSERT INTO pesOPV_vpl VALUES ("DT20_10","006_20_10","DEU","20","10","10","چون به شهری نزدیک آیی تا با آن جنگ نمایی، آن را برای صلح ندا بکن. ");
INSERT INTO pesOPV_vpl VALUES ("DT20_11","006_20_11","DEU","20","11","11","و اگر تو راجواب صلح بدهد، و دروازه‌ها را برای توبگشاید، آنگاه تمامی قومی که در آن یافت شوند، به تو جزیه دهند و تو را خدمت نمایند. ");
INSERT INTO pesOPV_vpl VALUES ("DT20_12","006_20_12","DEU","20","12","12","و اگر باتو صلح نکرده، با تو جنگ نمایند، پس آن رامحاصره کن. ");
INSERT INTO pesOPV_vpl VALUES ("DT20_13","006_20_13","DEU","20","13","13","و چون یهوه، خدایت، آن را به‌دست تو بسپارد، جمیع ذکورانش را به دم شمشیربکش. ");
INSERT INTO pesOPV_vpl VALUES ("DT20_14","006_20_14","DEU","20","14","14","لیکن زنان و اطفال و بهایم و آنچه درشهر باشد، یعنی تمامی غنیمتش را برای خود به تاراج ببر، و غنایم دشمنان خود را که یهوه خدایت به تو دهد، بخور. ");
INSERT INTO pesOPV_vpl VALUES ("DT20_15","006_20_15","DEU","20","15","15","به همه شهرهایی که از تو بسیار دورند که از شهرهای این امتها نباشند، چنین رفتار نما. ");
INSERT INTO pesOPV_vpl VALUES ("DT20_16","006_20_16","DEU","20","16","16","اما از شهرهای این امتهایی که یهوه، خدایت، تو را به ملکیت می‌دهد، هیچ ذی نفس را زنده مگذار. ");
INSERT INTO pesOPV_vpl VALUES ("DT20_17","006_20_17","DEU","20","17","17","بلکه ایشان را، یعنی حتیان و اموریان و کنعانیان و فرزیان و حویان ویبوسیان را، چنانکه یهوه، خدایت، تو را امرفرموده است، بالکل هلاک ساز. ");
INSERT INTO pesOPV_vpl VALUES ("DT20_18","006_20_18","DEU","20","18","18","تا شما راتعلیم ندهند که موافق همه رجاساتی که ایشان باخدایان خود عمل می‌نمودند، عمل نمایید. و به یهوه، خدای خود، گناه کنید. ");
INSERT INTO pesOPV_vpl VALUES ("DT20_19","006_20_19","DEU","20","19","19","چون برای گرفتن شهری با آن جنگ کنی، وآن را روزهای بسیار محاصره نمایی، تبر بر درختهایش مزن و آنها را تلف مساز. چونکه ازآنها می‌خوری پس آنها را قطع منما، زیرا آیادرخت صحرا انسان است تا آن را محاصره نمایی؟ ");
INSERT INTO pesOPV_vpl VALUES ("DT20_20","006_20_20","DEU","20","20","20","و اما درختی که میدانی درختی نیست که از آن خورده شود آن را تلف ساخته، قطع نما وسنگری بر شهری که با تو جنگ می‌کند، بنا کن تامنهدم شود. ");
INSERT INTO pesOPV_vpl VALUES ("DT21_1","006_21_1","DEU","21","1","1","اگر در زمینی که یهوه، خدایت، برای تصرفش به تو می‌دهد مقتولی درصحرا افتاده، پیدا شود و معلوم نباشد که قاتل اوکیست، ");
INSERT INTO pesOPV_vpl VALUES ("DT21_2","006_21_2","DEU","21","2","2","آنگاه مشایخ و داوران تو بیرون آمده، مسافت شهرهایی را که در اطراف مقتول است، بپیمایند. ");
INSERT INTO pesOPV_vpl VALUES ("DT21_3","006_21_3","DEU","21","3","3","و اما شهری که نزدیک تر به مقتول است، مشایخ آن شهر گوساله رمه را که با آن خیش نزده، و یوغ به آن نبسته‌اند، بگیرند. ");
INSERT INTO pesOPV_vpl VALUES ("DT21_4","006_21_4","DEU","21","4","4","ومشایخ آن شهر آن گوساله را در وادی‌ای که آب در آن همیشه جاری باشد و در آن خیش نزده، وشخم نکرده باشند، فرود آورند، و آنجا در وادی، گردن گوساله را بشکنند. ");
INSERT INTO pesOPV_vpl VALUES ("DT21_5","006_21_5","DEU","21","5","5","و بنی لاوی کهنه نزدیک بیایند، چونکه یهوه خدایت ایشان رابرگزیده است تا او را خدمت نمایند، و به نام خداوند برکت دهند، و برحسب قول ایشان هرمنازعه و هر آزاری فیصل پذیرد. ");
INSERT INTO pesOPV_vpl VALUES ("DT21_6","006_21_6","DEU","21","6","6","و جمیع مشایخ آن شهری که نزدیک تر به مقتول است، دستهای خود را بر گوساله‌ای که گردنش در وادی شکسته شده است، بشویند. ");
INSERT INTO pesOPV_vpl VALUES ("DT21_7","006_21_7","DEU","21","7","7","و جواب داده، بگویند: «دستهای ما این خون را نریخته، وچشمان ما ندیده است. ");
INSERT INTO pesOPV_vpl VALUES ("DT21_8","006_21_8","DEU","21","8","8","‌ای خداوند قوم خوداسرائیل را که فدیه داده‌ای بیامرز، و مگذار که خون بی‌گناه در میان قوم تو اسرائیل بماند.» پس خون برای ایشان عفو خواهد شد. ");
INSERT INTO pesOPV_vpl VALUES ("DT21_9","006_21_9","DEU","21","9","9","پس خون بی‌گناه را از میان خود رفع کرده‌ای هنگامی که آنچه در نظر خداوند راست است به عمل آورده‌ای. ");
INSERT INTO pesOPV_vpl VALUES ("DT21_10","006_21_10","DEU","21","10","10","چون بیرون روی تا با دشمنان خود جنگ کنی، و یهوه خدایت ایشان را به‌دستت تسلیم نماید و ایشان را اسیر کنی، ");
INSERT INTO pesOPV_vpl VALUES ("DT21_11","006_21_11","DEU","21","11","11","و در میان اسیران زن خوب صورتی دیده، عاشق او بشوی وبخواهی او را به زنی خود بگیری، ");
INSERT INTO pesOPV_vpl VALUES ("DT21_12","006_21_12","DEU","21","12","12","پس او را به خانه خود ببر و او سر خود را بتراشد و ناخن خودرا بگیرد. ");
INSERT INTO pesOPV_vpl VALUES ("DT21_13","006_21_13","DEU","21","13","13","و رخت اسیری خود را بیرون کرده، در خانه تو بماند، و برای پدر و مادر خود یک ماه ماتم گیرد، و بعد از آن به او درآمده، شوهر او بشوو او زن تو خواهد بود. ");
INSERT INTO pesOPV_vpl VALUES ("DT21_14","006_21_14","DEU","21","14","14","و اگر از وی راضی نباشی او را به خواهش دلش رها کن، لیکن او را به نقره هرگز مفروش و به او سختی مکن چونکه اورا ذلیل کرده‌ای. ");
INSERT INTO pesOPV_vpl VALUES ("DT21_15","006_21_15","DEU","21","15","15","و اگر مردی را دو زن باشد یکی محبوبه ویکی مکروهه، و محبوبه و مکروهه هر دو برایش پسران بزایند، و پسر مکروهه نخست زاده باشد، ");
INSERT INTO pesOPV_vpl VALUES ("DT21_16","006_21_16","DEU","21","16","16","پس در روزی که اموال خود را به پسران خویش تقسیم نماید، نمی تواند پسر محبوبه را برپسر مکروهه که نخست زاده است، حق نخست زادگی دهد. ");
INSERT INTO pesOPV_vpl VALUES ("DT21_17","006_21_17","DEU","21","17","17","بلکه حصه‌ای مضاعف ازجمیع اموال خود را به پسر مکروهه داده، او رانخست زاده خویش اقرار نماید، زیرا که او ابتدای قوت اوست و حق نخست زادگی از آن اومی باشد. ");
INSERT INTO pesOPV_vpl VALUES ("DT21_18","006_21_18","DEU","21","18","18","اگر کسی را پسری سرکش و فتنه انگیزباشد، که سخن پدر و سخن مادر خود را گوش ندهد، و هر‌چند او را تادیب نمایند ایشان رانشنود، ");
INSERT INTO pesOPV_vpl VALUES ("DT21_19","006_21_19","DEU","21","19","19","پدر و مادرش او را گرفته، نزد مشایخ شهرش به دروازه محله‌اش بیاورند. ");
INSERT INTO pesOPV_vpl VALUES ("DT21_20","006_21_20","DEU","21","20","20","و به مشایخ شهرش گویند: «این پسر ما سرکش وفتنه انگیز است، سخن ما را نمی شنود و مسرف ومیگسار است.» ");
INSERT INTO pesOPV_vpl VALUES ("DT21_21","006_21_21","DEU","21","21","21","پس جمیع اهل شهرش او را به سنگ سنگسار کنند تا بمیرد، پس بدی را از میان خود دور کرده‌ای و تمامی اسرائیل چون بشنوند، خواهند ترسید. ");
INSERT INTO pesOPV_vpl VALUES ("DT21_22","006_21_22","DEU","21","22","22","و اگر کسی گناهی را که مستلزم موت است، کرده باشد و کشته شود، و او را به دارکشیده باشی، ");
INSERT INTO pesOPV_vpl VALUES ("DT21_23","006_21_23","DEU","21","23","23","بدنش در شب بر دار نماند. او راالبته در همان روز دفن کن، زیرا آنکه بر دارآویخته شود ملعون خدا است تا زمینی را که یهوه، خدایت، تو را به ملکیت می‌دهد، نجس نسازی. ");
INSERT INTO pesOPV_vpl VALUES ("DT22_1","006_22_1","DEU","22","1","1","اگر گاو یا گوسفند برادر خود را گم شده بینی، از او رومگردان. آن را البته نزدبرادر خود برگردان. ");
INSERT INTO pesOPV_vpl VALUES ("DT22_2","006_22_2","DEU","22","2","2","و اگر برادرت نزدیک تونباشد یا او را نشناسی، آن را به خانه خود بیاور ونزد تو بماند، تا برادرت آن را طلب نماید، آنگاه آن را به او رد نما. ");
INSERT INTO pesOPV_vpl VALUES ("DT22_3","006_22_3","DEU","22","3","3","و به الاغ او چنین کن و به لباسش چنین عمل نما و به هر چیز گمشده برادرت که از او گم شود و یافته باشی چنین عمل نما، نمی توانی از او روگردانی. ");
INSERT INTO pesOPV_vpl VALUES ("DT22_4","006_22_4","DEU","22","4","4","اگر الاغ یا گاو برادرت را در راه افتاده بینی، از آن رومگردان، البته آن را با او برخیزان. ");
INSERT INTO pesOPV_vpl VALUES ("DT22_5","006_22_5","DEU","22","5","5","متاع مرد بر زن نباشد، و مرد لباس زن رانپوشد، زیرا هر‌که این کار را کند مکروه یهوه خدای توست. ");
INSERT INTO pesOPV_vpl VALUES ("DT22_6","006_22_6","DEU","22","6","6","اگر اتفاق آشیانه مرغی در راه به نظر تو آید، خواه بر درخت یا بر زمین، و در آن بچه‌ها یاتخمها باشد، و مادر بر بچه‌ها یا تخمها نشسته، مادر را با بچه‌ها مگیر. ");
INSERT INTO pesOPV_vpl VALUES ("DT22_7","006_22_7","DEU","22","7","7","مادر را البته رها کن وبچه‌ها را برای خود بگیر، تا برای تو نیکو شود وعمر دراز کنی. ");
INSERT INTO pesOPV_vpl VALUES ("DT22_8","006_22_8","DEU","22","8","8","چون خانه نو بنا کنی، بر پشت بام خوددیواری بساز، مبادا کسی از آن بیفتد و خون برخانه خود بیاوری. ");
INSERT INTO pesOPV_vpl VALUES ("DT22_9","006_22_9","DEU","22","9","9","در تاکستان خود دو قسم تخم مکار، مباداتمامی آن، یعنی هم تخمی که کاشته‌ای و هم محصول تاکستان، وقف شود. ");
INSERT INTO pesOPV_vpl VALUES ("DT22_10","006_22_10","DEU","22","10","10","گاو و الاغ را با هم جفت کرده، شیار منما. ");
INSERT INTO pesOPV_vpl VALUES ("DT22_11","006_22_11","DEU","22","11","11","پارچه مختلط از پشم و کتان با هم مپوش. ");
INSERT INTO pesOPV_vpl VALUES ("DT22_12","006_22_12","DEU","22","12","12","بر چهار گوشه رخت خود که خود را به آن می‌پوشانی، رشته‌ها بساز. ");
INSERT INTO pesOPV_vpl VALUES ("DT22_13","006_22_13","DEU","22","13","13","اگر کسی برای خود زنی گیرد و چون بدودرآید، او را مکروه دارد. ");
INSERT INTO pesOPV_vpl VALUES ("DT22_14","006_22_14","DEU","22","14","14","و اسباب حرف بدونسبت داده، از او اسم بد شهرت دهد و گوید این زن را گرفتم و چون به او نزدیکی نمودم، او را باکره نیافتم. ");
INSERT INTO pesOPV_vpl VALUES ("DT22_15","006_22_15","DEU","22","15","15","آنگاه پدر یا مادر آن دختر علامت بکارت دختر برداشته، نزد مشایخ شهر نزددروازه بیاورند. ");
INSERT INTO pesOPV_vpl VALUES ("DT22_16","006_22_16","DEU","22","16","16","و پدر دختر به مشایخ بگوید: «دختر خود را به این مرد به زنی داده‌ام، و از اوکراهت دارد، ");
INSERT INTO pesOPV_vpl VALUES ("DT22_17","006_22_17","DEU","22","17","17","و اینک اسباب حرف بدو نسبت داده، می‌گوید دختر تو را باکره نیافتم، و علامت بکارت دختر من این است.» پس جامه را پیش مشایخ شهر بگسترانند. ");
INSERT INTO pesOPV_vpl VALUES ("DT22_18","006_22_18","DEU","22","18","18","پس مشایخ آن شهرآن مرد را گرفته، تنبیه کنند. ");
INSERT INTO pesOPV_vpl VALUES ("DT22_19","006_22_19","DEU","22","19","19","و او را صد مثقال نقره جریمه نموده، به پدر دختر بدهند چونکه برباکره اسرائیل بدنامی آورده است. و او زن وی خواهد بود و در تمامی عمرش نمی تواند او رارها کند. ");
INSERT INTO pesOPV_vpl VALUES ("DT22_20","006_22_20","DEU","22","20","20","لیکن اگر این سخن راست باشد، و علامت بکارت آن دختر پیدا نشود، ");
INSERT INTO pesOPV_vpl VALUES ("DT22_21","006_22_21","DEU","22","21","21","آنگاه دختر را نزددر خانه پدرش بیرون آورند، و اهل شهرش او رابا سنگ سنگسار نمایند تا بمیرد، چونکه در خانه پدر خود زنا کرده، در اسرائیل قباحتی نموده است. پس بدی را از میان خود دور کرده‌ای. ");
INSERT INTO pesOPV_vpl VALUES ("DT22_22","006_22_22","DEU","22","22","22","اگر مردی یافت شود که با زن شوهرداری همبستر شده باشد، پس هر دو یعنی مردی که بازن خوابیده است و زن، کشته شوند. پس بدی رااز اسرائیل دور کرده‌ای. ");
INSERT INTO pesOPV_vpl VALUES ("DT22_23","006_22_23","DEU","22","23","23","اگر دختر باکره‌ای به مردی نامزد شود ودیگری او را در شهر یافته، با او همبستر شود، ");
INSERT INTO pesOPV_vpl VALUES ("DT22_24","006_22_24","DEU","22","24","24","پس هر دو ایشان را نزد دروازه شهر بیرون آورده، ایشان را با سنگها سنگسار کنند تا بمیرند؛ اما دختر را چونکه در شهر بود و فریاد نکرد، ومرد را چونکه زن همسایه خود را ذلیل ساخت، پس بدی را از میان خود دور کرده‌ای. ");
INSERT INTO pesOPV_vpl VALUES ("DT22_25","006_22_25","DEU","22","25","25","اما اگر آن مرد دختری نامزد را در صحرایابد و آن مرد به او زور آورده، با او بخوابد، پس آن مرد که با او خوابیده، تنها کشته شود. ");
INSERT INTO pesOPV_vpl VALUES ("DT22_26","006_22_26","DEU","22","26","26","و اما بادختر هیچ مکن زیرا بر دختر، گناه مستلزم موت نیست، بلکه این مثل آن است که کسی بر همسایه خود برخاسته، او را بکشد. ");
INSERT INTO pesOPV_vpl VALUES ("DT22_27","006_22_27","DEU","22","27","27","چونکه او را درصحرا یافت و دختر نامزد فریاد برآورد و برایش رهاننده‌ای نبود. ");
INSERT INTO pesOPV_vpl VALUES ("DT22_28","006_22_28","DEU","22","28","28","و اگر مردی دختر باکره‌ای را که نامزدنباشد بیابد و او را گرفته، با او همبستر شود وگرفتار شوند، ");
INSERT INTO pesOPV_vpl VALUES ("DT22_29","006_22_29","DEU","22","29","29","آنکه آن مرد که با او خوابیده است پنجاه مثقال نقره به پدر دختر بدهد و آن دختر زن او باشد، چونکه او را ذلیل ساخته است و در تمامی عمرش نمی تواند او را رها کند. ");
INSERT INTO pesOPV_vpl VALUES ("DT22_30","006_22_30","DEU","22","30","30","هیچ‌کس زن پدر خود را نگیرد و دامن پدرخود را منکشف نسازد. ");
INSERT INTO pesOPV_vpl VALUES ("DT23_1","006_23_1","DEU","23","1","1","جماعت خداوند شخصی که کوبیده بیضه و آلت بریده باشد داخل جماعت خداوند نشود. ");
INSERT INTO pesOPV_vpl VALUES ("DT23_2","006_23_2","DEU","23","2","2","حرام زاده‌ای داخل جماعت خداوند نشود، حتی تا پشت دهم احدی از او داخل جماعت خداوند نشود. ");
INSERT INTO pesOPV_vpl VALUES ("DT23_3","006_23_3","DEU","23","3","3","عمونی و موآبی داخل جماعت خداوند نشوند. حتی تا پشت دهم، احدی ازایشان هرگز داخل جماعت خداوند نشود. ");
INSERT INTO pesOPV_vpl VALUES ("DT23_4","006_23_4","DEU","23","4","4","زیراوقتی که شما از مصر بیرون آمدید، شما را در راه به نان و آب استقبال نکردند، و از این جهت که بلعام بن بعور را از فتور ارام نهرین اجیر کردند تا تو را لعنت کند. ");
INSERT INTO pesOPV_vpl VALUES ("DT23_5","006_23_5","DEU","23","5","5","لیکن یهوه خدایت نخواست بلعام را بشنود، پس یهوه خدایت لعنت را به جهت تو، به برکت تبدیل نمود، چونکه یهوه خدایت تو را دوست می‌داشت. ");
INSERT INTO pesOPV_vpl VALUES ("DT23_6","006_23_6","DEU","23","6","6","ابد در تمامی عمرت جویای خیریت و سعادت ایشان مباش. ");
INSERT INTO pesOPV_vpl VALUES ("DT23_7","006_23_7","DEU","23","7","7","ادومی را دشمن مدار چونکه برادر توست، ومصری را دشمن مدار چونکه در زمین وی غریب بودی. ");
INSERT INTO pesOPV_vpl VALUES ("DT23_8","006_23_8","DEU","23","8","8","اولادی که از ایشان زاییده شوند درپشت سوم داخل جماعت خداوند شوند. ");
INSERT INTO pesOPV_vpl VALUES ("DT23_9","006_23_9","DEU","23","9","9","چون در اردو به مقابله دشمنانت بیرون روی خویشتن را از هر چیز بد نگاه دار. ");
INSERT INTO pesOPV_vpl VALUES ("DT23_10","006_23_10","DEU","23","10","10","اگر در میان شما کسی باشد که از احتلام شب نجس شود، از اردو بیرون رود و داخل اردونشود. ");
INSERT INTO pesOPV_vpl VALUES ("DT23_11","006_23_11","DEU","23","11","11","چون شب نزدیک شود با آب غسل کند، و چون آفتاب غروب کند، داخل اردو شود. ");
INSERT INTO pesOPV_vpl VALUES ("DT23_12","006_23_12","DEU","23","12","12","و تو را مکانی بیرون از اردو باشد تا به آنجابیرون روی. ");
INSERT INTO pesOPV_vpl VALUES ("DT23_13","006_23_13","DEU","23","13","13","و در میان اسباب تو میخی باشد، و چون بیرون می‌نشینی با آن بکن و برگشته، فضله خود را از آن بپوشان. ");
INSERT INTO pesOPV_vpl VALUES ("DT23_14","006_23_14","DEU","23","14","14","زیرا که یهوه خدایت درمیان اردوی تو می‌خرامد تا تو را رهایی داده، دشمنانت را به تو تسلیم نماید، پس اردوی تومقدس باشد، مبادا چیز پلید را در میان تو دیده، ازتو روگرداند. ");
INSERT INTO pesOPV_vpl VALUES ("DT23_15","006_23_15","DEU","23","15","15","غلامی را که از آقای خود نزد تو بگریزد به آقایش مسپار. ");
INSERT INTO pesOPV_vpl VALUES ("DT23_16","006_23_16","DEU","23","16","16","با تو در میان تو در مکانی که برگزینند در یکی از شهرهای تو که به نظرش پسند آید، ساکن شود. و بر او جفامنما. ");
INSERT INTO pesOPV_vpl VALUES ("DT23_17","006_23_17","DEU","23","17","17","از دختران اسرائیل فاحشه‌ای نباشد و ازپسران اسرائیل لواطی نباشد. ");
INSERT INTO pesOPV_vpl VALUES ("DT23_18","006_23_18","DEU","23","18","18","اجرت فاحشه وقیمت سگ را برای هیچ نذری به خانه یهوه خدایت میاور، زیرا که این هر دو نزد یهوه خدایت مکروه است. ");
INSERT INTO pesOPV_vpl VALUES ("DT23_19","006_23_19","DEU","23","19","19","برادر خود را به سود قرض مده نه به سودنقره و نه به سود آذوقه و نه به سود هر چیزی که به سود داده می‌شود. ");
INSERT INTO pesOPV_vpl VALUES ("DT23_20","006_23_20","DEU","23","20","20","غریب را می‌توانی به سودقرض بدهی، اما برادر خود را به سود قرض مده تایهوه خدایت در زمینی که برای تصرفش داخل آن می‌شوی تو را به هر‌چه دستت را بر آن درازمی کنی، برکت دهد. ");
INSERT INTO pesOPV_vpl VALUES ("DT23_21","006_23_21","DEU","23","21","21","چون نذری برای یهوه خدایت می‌کنی دروفای آن تاخیر منما، زیرا که یهوه خدایت البته آن را از تو مطالبه خواهد نمود، و برای تو گناه خواهد بود. ");
INSERT INTO pesOPV_vpl VALUES ("DT23_22","006_23_22","DEU","23","22","22","اما اگر از نذر کردن ابا نمایی، تو راگناه نخواهد بود. ");
INSERT INTO pesOPV_vpl VALUES ("DT23_23","006_23_23","DEU","23","23","23","آنچه را که از دهانت بیرون آید، هوشیار باش که بجا آوری، موافق آنچه برای یهوه خدایت از اراده خود نذر کرده‌ای و به زبان خود گفته‌ای. ");
INSERT INTO pesOPV_vpl VALUES ("DT23_24","006_23_24","DEU","23","24","24","چون به تاکستان همسایه خود درآیی، ازانگور، هر‌چه می‌خواهی به سیری بخور، اما درظرف خود هیچ مگذار. ");
INSERT INTO pesOPV_vpl VALUES ("DT23_25","006_23_25","DEU","23","25","25","چون به کشتزار همسایه خود داخل شوی، خوشه‌ها را به‌دست خود بچین، اما داس بر کشت همسایه خود مگذار. ");
INSERT INTO pesOPV_vpl VALUES ("DT24_1","006_24_1","DEU","24","1","1","چون کسی زنی گرفته، به نکاح خوددرآورد، اگر در نظر او پسند نیاید از این که چیزی ناشایسته در او بیابد آنگاه طلاق نامه‌ای نوشته، بدستش دهد، و او را از خانه‌اش رها کند. ");
INSERT INTO pesOPV_vpl VALUES ("DT24_2","006_24_2","DEU","24","2","2","و از خانه او روانه شده، برود و زن دیگری شود. ");
INSERT INTO pesOPV_vpl VALUES ("DT24_3","006_24_3","DEU","24","3","3","و اگر شوهر دیگر نیز او را مکروه دارد وطلاق نامه‌ای نوشته، به‌دستش بدهد و او را ازخانه‌اش رها کند، یا اگر شوهری دیگر که او را به زنی گرفت، بمیرد، ");
INSERT INTO pesOPV_vpl VALUES ("DT24_4","006_24_4","DEU","24","4","4","شوهر اول که او را رها کرده بود، نمی تواند دوباره او را به نکاح خود درآورد. بعد از آن ناپاک شده است، زیرا که این به نظرخداوند مکروه است. پس بر زمینی که یهوه، خدایت، تو را به ملکیت می‌دهد، گناه میاور. ");
INSERT INTO pesOPV_vpl VALUES ("DT24_5","006_24_5","DEU","24","5","5","چون کسی زن تازه‌ای بگیرد، در لشکر بیرون نرود، و هیچ کار به او تکلیف نشود، تا یک سال درخانه خود آزاد بماند، و زنی را که گرفته است، مسرور سازد. ");
INSERT INTO pesOPV_vpl VALUES ("DT24_6","006_24_6","DEU","24","6","6","هیچکس آسیا یا سنگ بالایی آن را به گرونگیرد، زیرا که جان را به گرو گرفته است. ");
INSERT INTO pesOPV_vpl VALUES ("DT24_7","006_24_7","DEU","24","7","7","اگر کسی یافت شود که یکی از برادران خوداز بنی‌اسرائیل را دزدیده، بر او ظلم کند یابفروشد، آن دزد کشته شود، پس بدی را از میان خود دور کرده‌ای. ");
INSERT INTO pesOPV_vpl VALUES ("DT24_8","006_24_8","DEU","24","8","8","درباره بلای برص هوشیار باش که به هرآنچه لاویان کهنه شما را تعلیم دهند به دقت توجه نموده، عمل نمایید، و موافق آنچه به ایشان امر فرمودم، هوشیار باشید که عمل نمایید. ");
INSERT INTO pesOPV_vpl VALUES ("DT24_9","006_24_9","DEU","24","9","9","بیادآور که یهوه خدایت در راه با مریم چه کرد، وقتی که شما از مصر بیرون آمدید. ");
INSERT INTO pesOPV_vpl VALUES ("DT24_10","006_24_10","DEU","24","10","10","چون به همسایه خود هر قسم قرض دهی، برای گرفتن گرو به خانه‌اش داخل مشو. ");
INSERT INTO pesOPV_vpl VALUES ("DT24_11","006_24_11","DEU","24","11","11","بلکه بیرون بایست تا شخصی که به او قرض می‌دهی گرو را نزد تو بیرون آورد. ");
INSERT INTO pesOPV_vpl VALUES ("DT24_12","006_24_12","DEU","24","12","12","و اگر مرد فقیر باشددر گرو او مخواب. ");
INSERT INTO pesOPV_vpl VALUES ("DT24_13","006_24_13","DEU","24","13","13","البته به وقت غروب آفتاب، گرو را به او پس بده، تا در رخت خود بخوابد و تورا برکت دهد و به حضور یهوه خدایت، عدالت شمرده خواهد شد. ");
INSERT INTO pesOPV_vpl VALUES ("DT24_14","006_24_14","DEU","24","14","14","بر مزدوری که فقیر و مسکین باشد، خواه ازبرادرانت و خواه از غریبانی که در زمینت دراندرون دروازه های تو باشند ظلم منما. ");
INSERT INTO pesOPV_vpl VALUES ("DT24_15","006_24_15","DEU","24","15","15","درهمان روز مزدش را بده، و آفتاب بر آن غروب نکند، چونکه او فقیر است و دل خود را به آن بسته است، مبادا بر تو نزد خداوند فریاد برآورد و برای تو گناه باشد. ");
INSERT INTO pesOPV_vpl VALUES ("DT24_16","006_24_16","DEU","24","16","16","پدران به عوض پسران کشته نشوند، و نه پسران به عوض پدران خود کشته شوند. هر کس برای گناه خود کشته شود. ");
INSERT INTO pesOPV_vpl VALUES ("DT24_17","006_24_17","DEU","24","17","17","داوری غریب و یتیم را منحرف مساز، وجامه بیوه را به گرو مگیر. ");
INSERT INTO pesOPV_vpl VALUES ("DT24_18","006_24_18","DEU","24","18","18","و بیاد آور که در مصرغلام بودی و یهوه، خدایت، تو را از آنجا فدیه داد. بنابراین من تو را امر می‌فرمایم که این کار رامعمول داری. ");
INSERT INTO pesOPV_vpl VALUES ("DT24_19","006_24_19","DEU","24","19","19","چون محصول خود را در مزرعه خویش درو کنی، و در مزرعه، بافه‌ای فراموش کنی، برای برداشتن آن برمگرد؛ برای غریب و یتیم و بیوه‌زن باشد تا یهوه خدایت تو را در همه کارهای دستت برکت دهد. ");
INSERT INTO pesOPV_vpl VALUES ("DT24_20","006_24_20","DEU","24","20","20","چون زیتون خود را بتکانی باردیگر شاخه‌ها را متکان؛ برای غریب و یتیم و بیوه باشد. ");
INSERT INTO pesOPV_vpl VALUES ("DT24_21","006_24_21","DEU","24","21","21","چون انگور تاکستان خود را بچینی باردیگر آن را مچین، برای غریب و یتیم و بیوه باشد. ");
INSERT INTO pesOPV_vpl VALUES ("DT24_22","006_24_22","DEU","24","22","22","و بیاد آور که در زمین مصر غلام بودی. بنابراین تو را امر می‌فرمایم که این کار را معمول داری. ");
INSERT INTO pesOPV_vpl VALUES ("DT25_1","006_25_1","DEU","25","1","1","اگر در میان مردم مرافعه‌ای باشد و به محاکمه آیند و در میان ایشان داوری نمایند، آنگاه عادل را عادل شمارند، و شریر راملزم سازند. ");
INSERT INTO pesOPV_vpl VALUES ("DT25_2","006_25_2","DEU","25","2","2","و اگر شریر مستوجب تازیانه باشدآنگاه داور، او را بخواباند و حکم دهد تا او راموافق شرارتش به حضور خود به شماره بزنند. ");
INSERT INTO pesOPV_vpl VALUES ("DT25_3","006_25_3","DEU","25","3","3","چهل تازیانه او را بزند و زیاد نکند، مبادا اگر ازاین زیاده کرده، تازیانه بسیار زند، برادرت در نظرتو خوار شود. ");
INSERT INTO pesOPV_vpl VALUES ("DT25_4","006_25_4","DEU","25","4","4","دهن گاو را هنگامی که خرمن را خرد می‌کند، مبند. ");
INSERT INTO pesOPV_vpl VALUES ("DT25_5","006_25_5","DEU","25","5","5","اگر برادران با هم ساکن باشند و یکی از آنهابی اولاد بمیرد، پس زن آن متوفی، خارج به شخص بیگانه داده نشود، بلکه برادر شوهرش به او درآمده، او را برای خود به زنی بگیرد، و حق برادر شوهری را با او بجا آورد. ");
INSERT INTO pesOPV_vpl VALUES ("DT25_6","006_25_6","DEU","25","6","6","ونخست زاده‌ای که بزاید به اسم برادر متوفای اووارث گردد، تا اسمش از اسرائیل محو نشود. ");
INSERT INTO pesOPV_vpl VALUES ("DT25_7","006_25_7","DEU","25","7","7","واگر آن مرد به گرفتن زن برادرش راضی نشود، آنگاه زن برادرش به دروازه نزد مشایخ برود وگوید: «برادر شوهر من از برپا داشتن اسم برادرخود در اسرائیل انکار می‌کند، و از بجا آوردن حق برادر شوهری با من ابا می‌نماید.» ");
INSERT INTO pesOPV_vpl VALUES ("DT25_8","006_25_8","DEU","25","8","8","پس مشایخ شهرش او را طلبیده، با وی گفتگو کنند، و اگر اصرار کرده، بگوید نمی خواهم او را بگیرم، ");
INSERT INTO pesOPV_vpl VALUES ("DT25_9","006_25_9","DEU","25","9","9","آنگاه زن برادرش نزد وی آمده، به حضورمشایخ کفش او را از پایش بکند، و به رویش آب دهن اندازد، و در جواب گوید: «با کسی‌که خانه برادر خود را بنا نکند، چنین کرده شود.» ");
INSERT INTO pesOPV_vpl VALUES ("DT25_10","006_25_10","DEU","25","10","10","ونام او در اسرائیل، خانه کفش کنده خوانده شود. ");
INSERT INTO pesOPV_vpl VALUES ("DT25_11","006_25_11","DEU","25","11","11","و اگر دو شخص با یکدیگر منازعه نمایند، و زن یکی پیش آید تا شوهر خود را از دست زننده‌اش رها کند و دست خود را دراز کرده، عورت او را بگیرد، ");
INSERT INTO pesOPV_vpl VALUES ("DT25_12","006_25_12","DEU","25","12","12","پس دست او را قطع کن. چشم تو بر او ترحم نکند. ");
INSERT INTO pesOPV_vpl VALUES ("DT25_13","006_25_13","DEU","25","13","13","در کیسه تو وزنه های مختلف، بزرگ وکوچک نباشد. ");
INSERT INTO pesOPV_vpl VALUES ("DT25_14","006_25_14","DEU","25","14","14","در خانه تو کیلهای مختلف، بزرگ و کوچک، نباشد. ");
INSERT INTO pesOPV_vpl VALUES ("DT25_15","006_25_15","DEU","25","15","15","تو را وزن صحیح وراست باشد و تو را کیل صحیح و راست باشد، تاعمرت در زمینی که یهوه، خدایت، به تومی دهد دراز شود. ");
INSERT INTO pesOPV_vpl VALUES ("DT25_16","006_25_16","DEU","25","16","16","زیرا هر‌که این کار کندیعنی هر‌که بی‌انصافی نماید، نزد یهوه خدایت مکروه است. ");
INSERT INTO pesOPV_vpl VALUES ("DT25_17","006_25_17","DEU","25","17","17","بیاد آور آنچه عمالیق وقت بیرون آمدنت از مصر در راه به تو نمودند. ");
INSERT INTO pesOPV_vpl VALUES ("DT25_18","006_25_18","DEU","25","18","18","که چگونه تو رادر راه، مقابله کرده، همه واماندگان را در عقب تو از موخرت قطع نمودند، در حالی که توضعیف و وامانده بودی و از خدا نترسیدند. ");
INSERT INTO pesOPV_vpl VALUES ("DT25_19","006_25_19","DEU","25","19","19","پس چون یهوه خدایت تو را در زمینی که یهوه، خدایت، تو را برای تصرفش نصیب می‌دهد، از جمیع دشمنانت آرامی بخشد، آنگاه ذکر عمالیق را از زیر آسمان محو ساز و فراموش مکن. ");
INSERT INTO pesOPV_vpl VALUES ("DT26_1","006_26_1","DEU","26","1","1","و چون به زمینی که یهوه خدایت تو رانصیب می‌دهد داخل شدی، و در آن تصرف نموده، ساکن گردیدی، ");
INSERT INTO pesOPV_vpl VALUES ("DT26_2","006_26_2","DEU","26","2","2","آنگاه نوبر تمامی حاصل زمین را که از زمینی که یهوه خدایت به تومی دهد، جمع کرده باشی بگیر، و آن را در سبدگذاشته، به مکانی که یهوه خدایت برگزیند تا نام خود را در آن ساکن گرداند، برو. ");
INSERT INTO pesOPV_vpl VALUES ("DT26_3","006_26_3","DEU","26","3","3","و نزد کاهنی که در آن روزها باشد رفته، وی را بگو: «امروز برای یهوه خدایت اقرار می‌کنم که به زمینی که خداوندبرای پدران ما قسم خورد که به ما بدهد، داخل شده‌ام.» ");
INSERT INTO pesOPV_vpl VALUES ("DT26_4","006_26_4","DEU","26","4","4","و کاهن سبد را از دستت گرفته، پیش مذبح یهوه خدایت بگذارد. ");
INSERT INTO pesOPV_vpl VALUES ("DT26_5","006_26_5","DEU","26","5","5","پس تو به حضوریهوه خدای خود اقرار کرده، بگو: «پدر من ارامی آواره بود، و با عددی قلیل به مصر فرود شده، درآنجا غربت پذیرفت، و در آنجا امتی بزرگ وعظیم و کثیر شد. ");
INSERT INTO pesOPV_vpl VALUES ("DT26_6","006_26_6","DEU","26","6","6","و مصریان با ما بدرفتاری نموده، ما را ذلیل ساختند، و بندگی سخت بر مانهادند. ");
INSERT INTO pesOPV_vpl VALUES ("DT26_7","006_26_7","DEU","26","7","7","و چون نزد یهوه، خدای پدران خود، فریاد برآوردیم، خداوند آواز ما را شنید ومشقت و محنت و تنگی ما را دید. ");
INSERT INTO pesOPV_vpl VALUES ("DT26_8","006_26_8","DEU","26","8","8","و خداوند مارا از مصر به‌دست قوی و بازوی افراشته و خوف عظیم، و با آیات و معجزات بیرون آورد. ");
INSERT INTO pesOPV_vpl VALUES ("DT26_9","006_26_9","DEU","26","9","9","و ما رابه این مکان درآورده، این زمین را زمینی که به شیرو شهد جاری است به ما بخشید. ");
INSERT INTO pesOPV_vpl VALUES ("DT26_10","006_26_10","DEU","26","10","10","و الان اینک نوبر حاصل زمینی را که تو‌ای خداوند به من دادی، آورده‌ام.» پس آن را به حضور یهوه خدای خود بگذار، و به حضور یهوه، خدایت، عبادت نما. ");
INSERT INTO pesOPV_vpl VALUES ("DT26_11","006_26_11","DEU","26","11","11","و تو با لاوی و غریبی که در میان تو باشد ازتمامی نیکویی که یهوه، خدایت، به تو و به خاندانت بخشیده است، شادی خواهی نمود. ");
INSERT INTO pesOPV_vpl VALUES ("DT26_12","006_26_12","DEU","26","12","12","و در سال سوم که سال عشر است، چون ازگرفتن تمامی عشر محصول خود فارغ شدی، آن را به لاوی و غریب و یتیم و بیوه‌زن بده، تا دراندرون دروازه های تو بخورند و سیر شوند. ");
INSERT INTO pesOPV_vpl VALUES ("DT26_13","006_26_13","DEU","26","13","13","وبه حضور یهوه خدایت بگو: «موقوفات را از خانه خود بیرون کردم، و آنها را نیز به لاوی و غریب ویتیم و بیوه‌زن، موافق تمامی اوامری که به من امرفرمودی، دادم، و از اوامر تو تجاوز ننموده، فراموش نکردم. ");
INSERT INTO pesOPV_vpl VALUES ("DT26_14","006_26_14","DEU","26","14","14","در ماتم خود از آنها نخوردم ودر نجاستی از آنها صرف ننمودم، و برای اموات از آنها ندادم، بلکه به قول یهوه، خدایم، گوش داده، موافق هر‌آنچه به من امر فرمودی، رفتارنمودم. ");
INSERT INTO pesOPV_vpl VALUES ("DT26_15","006_26_15","DEU","26","15","15","از مسکن مقدس خود از آسمان بنگر، و قوم خود اسرائیل و زمینی را که به ما دادی چنانکه برای پدران ما قسم خوردی، زمینی که به شیر و شهد جاری است، برکت بده،.» ");
INSERT INTO pesOPV_vpl VALUES ("DT26_16","006_26_16","DEU","26","16","16","امروز یهوه، خدایت، تو را امر می‌فرمایدکه این فرایض و احکام را بجا آوری، پس آنها رابه تمامی دل و تمامی جان خود نگاه داشته، بجاآور. ");
INSERT INTO pesOPV_vpl VALUES ("DT26_17","006_26_17","DEU","26","17","17","امروز به یهوه اقرار نمودی که خدای توست، و اینکه به طریقهای او سلوک خواهی نمود، و فرایض و اوامر و احکام او را نگاه داشته، آواز او را خواهی شنید. ");
INSERT INTO pesOPV_vpl VALUES ("DT26_18","006_26_18","DEU","26","18","18","و خداوند امروز به تواقرار کرده است که تو قوم خاص او هستی، چنانکه به تو وعده داده است، و تا تمامی اوامر اورا نگاه داری. ");
INSERT INTO pesOPV_vpl VALUES ("DT26_19","006_26_19","DEU","26","19","19","و تا تو را در ستایش و نام و اکرام از جمیع امتهایی که ساخته است، بلند گرداند، وتا برای یهوه، خدایت، قوم مقدس باشی، چنانکه وعده داده است. ");
INSERT INTO pesOPV_vpl VALUES ("DT27_1","006_27_1","DEU","27","1","1","و موسی و مشایخ اسرائیل، قوم را امرفرموده، گفتند: «تمامی اوامری را که من امروز به شما امر می‌فرمایم، نگاه دارید. ");
INSERT INTO pesOPV_vpl VALUES ("DT27_2","006_27_2","DEU","27","2","2","و درروزی که از اردن به زمینی که یهوه، خدایت، به تومی دهد عبور کنید، برای خود سنگهای بزرگ برپاکرده، آنها را با گچ بمال. ");
INSERT INTO pesOPV_vpl VALUES ("DT27_3","006_27_3","DEU","27","3","3","و بر آنها تمامی کلمات این شریعت را بنویس، هنگامی که عبور نمایی تابه زمینی که یهوه، خدایت، به تو می‌دهد، داخل شوی، زمینی که به شیر و شهد جاری است، چنانکه یهوه خدای پدرانت به تو وعده داده است. ");
INSERT INTO pesOPV_vpl VALUES ("DT27_4","006_27_4","DEU","27","4","4","و چون از اردن عبور نمودی این سنگها راکه امروز به شما امر می‌فرمایم در کوه عیبال برپاکرده، آنها را با گچ بمال. ");
INSERT INTO pesOPV_vpl VALUES ("DT27_5","006_27_5","DEU","27","5","5","و در آنجا مذبحی برای یهوه خدایت بنا کن، و مذبح از سنگها باشد و آلت آهنین بر آنها بکار مبر. ");
INSERT INTO pesOPV_vpl VALUES ("DT27_6","006_27_6","DEU","27","6","6","مذبح یهوه خدای خودرا از سنگهای ناتراشیده بنا کن، و قربانی های سوختنی برای یهوه خدایت، بر آن بگذران. ");
INSERT INTO pesOPV_vpl VALUES ("DT27_7","006_27_7","DEU","27","7","7","وذبایح سلامتی ذبح کرده، در آنجا بخور و به حضور یهوه خدایت شادی نما. ");
INSERT INTO pesOPV_vpl VALUES ("DT27_8","006_27_8","DEU","27","8","8","و تمامی کلمات این شریعت را بر آن به خط روشن بنویس.» ");
INSERT INTO pesOPV_vpl VALUES ("DT27_9","006_27_9","DEU","27","9","9","پس موسی و لاویان کهنه تمامی اسرائیل را خطاب کرده، گفتند: ");
INSERT INTO pesOPV_vpl VALUES ("DT27_10","006_27_10","DEU","27","10","10","«ای اسرائیل خاموش باش و بشنو. امروز قوم یهوه خدایت شدی. ");
INSERT INTO pesOPV_vpl VALUES ("DT27_11","006_27_11","DEU","27","11","11","پس آواز یهوه خدایت را بشنو و اوامر وفرایض او را که من امروز به تو امر می‌فرمایم، بجاآر.» ");
INSERT INTO pesOPV_vpl VALUES ("DT27_12","006_27_12","DEU","27","12","12","«چون از اردن عبور کردید، اینان یعنی شمعون و لاوی و یهودا و یساکار و یوسف وبنیامین بر کوه جرزیم بایستند تا قوم را برکت دهند. ");
INSERT INTO pesOPV_vpl VALUES ("DT27_13","006_27_13","DEU","27","13","13","و اینان یعنی روبین و جاد و اشیر وزبولون و دان و نفتالی بر کوه عیبال بایستند تانفرین کنند. ");
INSERT INTO pesOPV_vpl VALUES ("DT27_14","006_27_14","DEU","27","14","14","و لاویان جمیع مردان اسرائیل رابه آواز بلند خطاب کرده، گویند: ");
INSERT INTO pesOPV_vpl VALUES ("DT27_15","006_27_15","DEU","27","15","15","«ملعون باد کسی‌که صورت تراشیده یاریخته شده از صنعت دست کارگر که نزد خداوندمکروه است، بسازد، و مخفی نگاه دارد.» و تمامی قوم در جواب بگویند: «آمین!» ");
INSERT INTO pesOPV_vpl VALUES ("DT27_16","006_27_16","DEU","27","16","16","«ملعون باد کسی‌که با پدر و مادر خود به خفت رفتار نماید.» و تمامی قوم بگویند: «آمین!» ");
INSERT INTO pesOPV_vpl VALUES ("DT27_17","006_27_17","DEU","27","17","17","«ملعون باد کسی‌که حد همسایه خود راتغییر دهد.» و تمامی قوم بگویند: «آمین!» ");
INSERT INTO pesOPV_vpl VALUES ("DT27_18","006_27_18","DEU","27","18","18","«ملعون باد کسی‌که نابینا را از راه منحرف سازد.» و تمامی قوم بگویند: «آمین!» ");
INSERT INTO pesOPV_vpl VALUES ("DT27_19","006_27_19","DEU","27","19","19","«ملعون باد کسی‌که داوری غریب و یتیم وبیوه را منحرف سازد.» و تمامی قوم بگویند: «آمین!» ");
INSERT INTO pesOPV_vpl VALUES ("DT27_20","006_27_20","DEU","27","20","20","«ملعون باد کسی‌که با زن پدر خود همبسترشود، چونکه دامن پدر خود را کشف نموده است.» و تمامی قوم بگویند: «آمین!» ");
INSERT INTO pesOPV_vpl VALUES ("DT27_21","006_27_21","DEU","27","21","21","«ملعون باد کسی‌که با هر قسم بهایمی بخوابد.» و تمامی قوم بگویند: «آمین!» ");
INSERT INTO pesOPV_vpl VALUES ("DT27_22","006_27_22","DEU","27","22","22","«ملعون باد کسی‌که با خواهر خویش چه دختر پدر و چه دختر مادر خویش بخوابد.» وتمامی قوم بگویند: «آمین!» ");
INSERT INTO pesOPV_vpl VALUES ("DT27_23","006_27_23","DEU","27","23","23","«ملعون باد کسی‌که با مادر‌زن خودبخوابد.» و تمامی قوم بگویند: «آمین!» ");
INSERT INTO pesOPV_vpl VALUES ("DT27_24","006_27_24","DEU","27","24","24","«ملعون باد کسی‌که همسایه خود را درپنهانی بزند.» و تمامی قوم بگویند: «آمین!» ");
INSERT INTO pesOPV_vpl VALUES ("DT27_25","006_27_25","DEU","27","25","25","«ملعون باد کسی‌که رشوه گیرد تا خون بی‌گناهی ریخته شود.» و تمامی قوم بگویند: «آمین!» ");
INSERT INTO pesOPV_vpl VALUES ("DT27_26","006_27_26","DEU","27","26","26","«ملعون باد کسی‌که کلمات این شریعت رااثبات ننماید تا آنها را بجا نیاورد.» وتمامی قوم بگویند: «آمین!» ");
INSERT INTO pesOPV_vpl VALUES ("DT28_1","006_28_1","DEU","28","1","1","«و اگر آواز یهوه خدای خود را به دقت بشنوی تا هوشیار شده، تمامی اوامر اورا که من امروز به تو امر می‌فرمایم بجا آوری، آنگاه یهوه خدایت تو را بر جمیع امتهای جهان بلند خواهد گردانید. ");
INSERT INTO pesOPV_vpl VALUES ("DT28_2","006_28_2","DEU","28","2","2","و تمامی این برکتها به توخواهد رسید و تو را خواهد دریافت، اگر آوازیهوه خدای خود را بشنوی. ");
INSERT INTO pesOPV_vpl VALUES ("DT28_3","006_28_3","DEU","28","3","3","در شهر، مبارک ودر صحرا، مبارک خواهی بود. ");
INSERT INTO pesOPV_vpl VALUES ("DT28_4","006_28_4","DEU","28","4","4","میوه بطن تو ومیوه زمین تو و میوه بهایمت و بچه های گاو وبره های گله تو مبارک خواهند بود. ");
INSERT INTO pesOPV_vpl VALUES ("DT28_5","006_28_5","DEU","28","5","5","سبد و ظرف خمیر تو مبارک خواهد بود. ");
INSERT INTO pesOPV_vpl VALUES ("DT28_6","006_28_6","DEU","28","6","6","وقت درآمدنت مبارک، و وقت بیرون رفتنت مبارک خواهی بود. ");
INSERT INTO pesOPV_vpl VALUES ("DT28_7","006_28_7","DEU","28","7","7","«و خداوند دشمنانت را که با تو مقاومت نمایند، از حضور تو منهزم خواهد ساخت، ازیک راه بر تو خواهند آمد، و از هفت راه پیش توخواهند گریخت. ");
INSERT INTO pesOPV_vpl VALUES ("DT28_8","006_28_8","DEU","28","8","8","خداوند در انبارهای تو و به هر‌چه دست خود را به آن دراز می‌کنی بر توبرکت خواهد فرمود، و تو را در زمینی که یهوه خدایت به تو می‌دهد، مبارک خواهد ساخت. ");
INSERT INTO pesOPV_vpl VALUES ("DT28_9","006_28_9","DEU","28","9","9","واگر اوامر یهوه خدای خود را نگاهداری، و درطریقهای او سلوک نمایی، خداوند تو را برای خود قوم مقدس خواهد گردانید، چنانکه برای تو قسم خورده است. ");
INSERT INTO pesOPV_vpl VALUES ("DT28_10","006_28_10","DEU","28","10","10","و جمیع امتهای زمین خواهند دید که نام خداوند بر تو خوانده شده است، و از تو خواهند ترسید. ");
INSERT INTO pesOPV_vpl VALUES ("DT28_11","006_28_11","DEU","28","11","11","و خداوندتو را در میوه بطنت و ثمره بهایمت ومحصول زمینت، در زمینی که خداوند برای پدرانت قسم خورد که به تو بدهد، به نیکویی خواهد افزود. ");
INSERT INTO pesOPV_vpl VALUES ("DT28_12","006_28_12","DEU","28","12","12","و خداوند خزینه نیکوی خود، یعنی آسمان را برای تو خواهد گشود، تا باران زمین تو را در موسمش بباراند، و تو را درجمیع اعمال دستت مبارک سازد، و به امتهای بسیار قرض خواهی داد، و تو قرض نخواهی گرفت. ");
INSERT INTO pesOPV_vpl VALUES ("DT28_13","006_28_13","DEU","28","13","13","و خداوند تو را سر خواهد ساخت نه دم، و بلند خواهی بود فقط نه پست، اگر اوامریهوه خدای خود را که من امروز به تو امرمی فرمایم بشنوی، و آنها را نگاه داشته، بجاآوری. ");
INSERT INTO pesOPV_vpl VALUES ("DT28_14","006_28_14","DEU","28","14","14","و از همه سخنانی که من امروز به تو امرمی کنم به طرف راست یا چپ میل نکنی، تاخدایان غیر را پیروی نموده، آنها را عبادت کنی. ");
INSERT INTO pesOPV_vpl VALUES ("DT28_15","006_28_15","DEU","28","15","15","«و اما اگر آواز یهوه خدای خود را نشنوی تا هوشیار شده، همه اوامر و فرایض او را که من امروز به تو امر می‌فرمایم بجا آوری، آنگاه جمیع این لعنتها به تو خواهد رسید، و تو را خواهددریافت. ");
INSERT INTO pesOPV_vpl VALUES ("DT28_16","006_28_16","DEU","28","16","16","در شهر ملعون، و در صحرا ملعون خواهی بود. ");
INSERT INTO pesOPV_vpl VALUES ("DT28_17","006_28_17","DEU","28","17","17","سبد و ظرف خمیر تو ملعون خواهد بود. ");
INSERT INTO pesOPV_vpl VALUES ("DT28_18","006_28_18","DEU","28","18","18","میوه بطن تو و میوه زمین تو وبچه های گاو و بره های گله تو ملعون خواهد بود. ");
INSERT INTO pesOPV_vpl VALUES ("DT28_19","006_28_19","DEU","28","19","19","وقت درآمدنت ملعون، و وقت بیرون رفتنت ملعون خواهی بود. ");
INSERT INTO pesOPV_vpl VALUES ("DT28_20","006_28_20","DEU","28","20","20","و به هر‌چه دست خود رابرای عمل نمودن دراز می‌کنی خداوند بر تولعنت و اضطراب و سرزنش خواهد فرستاد تا به زودی هلاک و نابود شوی، به‌سبب بدی کارهایت که به آنها مرا ترک کرده‌ای، ");
INSERT INTO pesOPV_vpl VALUES ("DT28_21","006_28_21","DEU","28","21","21","خداوندوبا را بر تو ملصق خواهد ساخت، تا تو را اززمینی که برای تصرفش به آن داخل می‌شوی، هلاک سازد. ");
INSERT INTO pesOPV_vpl VALUES ("DT28_22","006_28_22","DEU","28","22","22","و خداوند تو را با سل و تب والتهاب و حرارت و شمشیر و باد سموم و یرقان خواهد زد، و تو را تعاقب خواهند نمود تا هلاک شوی. ");
INSERT INTO pesOPV_vpl VALUES ("DT28_23","006_28_23","DEU","28","23","23","و فلک تو که بالای سر تو است مس خواهد شد، و زمینی که زیر تو است آهن. ");
INSERT INTO pesOPV_vpl VALUES ("DT28_24","006_28_24","DEU","28","24","24","وخداوند باران زمینت را گرد و غبار خواهدساخت، که از آسمان بر تو نازل شود تا هلاک شوی. ");
INSERT INTO pesOPV_vpl VALUES ("DT28_25","006_28_25","DEU","28","25","25","«و خداوند تو را پیش روی دشمنانت منهزم خواهد ساخت. از یک راه بر ایشان بیرون خواهی رفت، و از هفت راه از حضور ایشان خواهی گریخت، و در تمامی ممالک جهان به تلاطم خواهی افتاد. ");
INSERT INTO pesOPV_vpl VALUES ("DT28_26","006_28_26","DEU","28","26","26","و بدن شما برای همه پرندگان هوا و بهایم زمین خوراک خواهد بود، وهیچ‌کس آنها را دور نخواهد کرد. ");
INSERT INTO pesOPV_vpl VALUES ("DT28_27","006_28_27","DEU","28","27","27","خداوند تو را به دنبل مصر و خراج و جرب و خارشی که تواز آن شفا نتوانی یافت، مبتلا خواهد ساخت. ");
INSERT INTO pesOPV_vpl VALUES ("DT28_28","006_28_28","DEU","28","28","28","خداوند تو را به دیوانگی و نابینایی و پریشانی دل مبتلا خواهد ساخت. ");
INSERT INTO pesOPV_vpl VALUES ("DT28_29","006_28_29","DEU","28","29","29","و در وقت ظهر مثل کوری که در تاریکی لمس نماید کورانه راه خواهی رفت، و در راههای خود کامیاب نخواهی شد، بلکه در تمامی روزهایت مظلوم وغارت شده خواهی بود، و نجات‌دهنده‌ای نخواهد بود. ");
INSERT INTO pesOPV_vpl VALUES ("DT28_30","006_28_30","DEU","28","30","30","زنی را نامزد خواهی کرد ودیگری با او خواهد خوابید. خانه‌ای بنا خواهی کرد و در آن ساکن نخواهی شد. تاکستانی غرس خواهی نمود و میوه‌اش را نخواهی خورد. ");
INSERT INTO pesOPV_vpl VALUES ("DT28_31","006_28_31","DEU","28","31","31","گاوت در نظرت کشته شود و از آن نخواهی خورد. الاغت پیش روی تو به غارت برده شود وباز به‌دست تو نخواهند آمد. گوسفند تو به دشمنت داده می‌شود و برای تو رهاکننده‌ای نخواهد بود. ");
INSERT INTO pesOPV_vpl VALUES ("DT28_32","006_28_32","DEU","28","32","32","پسران و دخترانت به امت دیگرداده می‌شوند، و چشمانت نگریسته از آرزوی ایشان تمامی روز کاهیده خواهد شد، و در دست تو هیچ 