﻿USE sofia;
DROP TABLE IF EXISTS sofia.peg_vpl;
CREATE TABLE peg_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES peg_vpl WRITE;
INSERT INTO peg_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","ଅବ୍ରାହାମ୍‌ ଆରି ଦାଉଦ୍‌ତି ଲାତ୍ରା ଜିସୁ କ୍ରିସ୍ଟ ଲାତ୍ରାର୍‍ତି ତାରେନ୍‌ ପତିତ ଲେକା ଆତାତ୍‌ନ୍ନା । ");
INSERT INTO peg_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","ଅବ୍ରାହାମ୍‌ ମେହି ଇସାହାକ୍‌; ଇସ୍‌ହାକ୍‌ ମେହି ଜାକୁବ୍‌; ଜାକୁବ୍‌ ମେହି ଜିହୁଦା ଆରି ତା ଟଣ୍ଡାହିରିଂ ଜଲମ୍‌ କିତାନ୍‌, ");
INSERT INTO peg_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","ଜିହୁଦା ତାମର୍‌ ୱାସ୍କିତାଂ ପେରସ୍‌ ଆରି ସେରହଙ୍ଗ୍‌ ଜଲମ୍‌ କିତାନ୍‌, ପେରସ୍‌ ହେସ୍ରଣ ଜଲମ୍‌ କିତାନ୍‌; ହେସ୍ରଣ ଆରାମ୍‌ ଜଲମ୍‌ କିତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","ହିସ୍ରଣ ମେହି ଆରାମ୍‌; ଆରାମ୍‌ ମେହି ଅମିନାଦାବ୍‌; ଅମିନାଦାବ୍‌ ମେହି ନହସନ୍‌; ନହସନ୍‌ ମେହି ସଲମନ୍‌; ");
INSERT INTO peg_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","ସଲମନ୍‌ତି ମାଜ଼ି ବୟଜ ମାଚାନ୍‌, ବୟଜତି ତେହି ତର୍‌ ରାହାବ୍‌, ବୟଜତି ମାଜ଼ି ଓବେଦ ତା ତର୍‌ ରୁତ୍‌; ଓବେଦତି ମେହି ଜିସିୟ । ");
INSERT INTO peg_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","ଜିସିୟ ମେହି ଦାଉଦ୍‌ ରାଜା । ଦାଉଦ୍‌ ମେହି ସଲମନ୍‌ ତେହି ଆଗେ ଉରିୟମ୍‌ ଡକ୍ରି ମାଚାତ୍‌; ");
INSERT INTO peg_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","ସଲମନ୍‌ ମେହି ରହବୟାମ୍‌; ରହବୟାମ୍‌ ମେହି ଅବିୟ; ");
INSERT INTO peg_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","ଅବିୟ ମେହି ଆସା; ଆସା ମେହି ଜିହସାପଟ୍‌; ଜିହସାପଟ୍‌ ମେହି ଜରାମ୍‌; ଜରାମ୍‌ ମେହି ଉଜିୟ; ");
INSERT INTO peg_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","ଉଜିୟ ମେହି ଜତାମ୍‌; ଜତାମ୍‌ ମେହି ଆହାଜ୍‌; ଆହାଜ୍‌ ମେହି ହିଜକିୟ; ");
INSERT INTO peg_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","ହିଜକିୟ ମେହି ମନସେହଙ୍ଗ୍‌ ଜଲମ୍‌ କିତାନ୍‌; ମନସେହ ମାଙ୍ଗେଙ୍ଗ୍‌ ଜଲମ୍‌ କିତାନ୍‌, ଆମନ୍‌ ଜସିୟଙ୍ଗ୍‌ ଜଲମ୍‌ କିତାନ୍‌, ");
INSERT INTO peg_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","ଆମନ୍‌ ମେହି ଜସିୟ; ଜସିୟ ମେହି ଜିକନିୟ ଆରି ତା ଟଣ୍ଡାହିର୍‌, ବାବିଲନ୍‌ତିଂ ଦେସ୍‌ତ ଗେହ୍‌ନାକା ଆତି ସମୁତ ଜିକନିୟ ଜଲମ୍‌ ଆଜ଼ି ମାଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","ବାବିଲନ୍‌ତ ଗେହ୍‌ନାକା ଆତି ପାଚେ ଜିକନିୟତି ମେହି ସଲ୍‌ଟିୟେଲ୍‌ ବାବିଲନ୍‌ତ ଜଲମ୍‌ କିତାନ୍‌ । ସଲ୍‌ଟିୟେଲ୍‌ ମେହି ଜିରୁବାବେଲ୍‌; ");
INSERT INTO peg_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","ଜିରୁବାବେଲ୍‌ ମେହି ଅବିହୁଦଂ; ଅବିହୁଦ ମେହି ଏଲିୟାକିମ୍‌; ଏଲିୟାକିମ୍‌ ମେହି ଆସର୍‌; ");
INSERT INTO peg_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","ଆସର୍‌ ମେହି ସାଦକ୍‌; ସାଦକ ମେହି ଆକିମ୍‌; ଆକିମ୍‌ ମେହି ଏଲିହୁଦ୍‌; ଏଲିହୁଦ୍‌ ମେହି ଏଲାଜାର୍‌; ଏଲାଜାର୍‌ ମେହି ମତାନ୍‌; ");
INSERT INTO peg_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","ଏଲିହୁଦ୍‌ ଏଲିୟାଜତିଂ ଜଲମ୍‌ କିନାନ୍‌, ଏଲିୟାଜର୍‌ ମତାନ୍‌ତିଂ ଜଲମ୍‌ କିନାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","ମତାନ୍‌ ଜାକୁବ୍‌ତିଂ ଜଲମ୍‌ କିନାନ୍‌, ଜାକୁବ୍‌ ମରିୟମ୍‌ ଡକ୍ରାହି ଜସେପ୍‌ତିଂ ଜଲମ୍‌ କିନାନ୍‌ । ଇ ମରିୟମ୍‌ ପଟତାଂ ଜିସୁ ଜଲମ୍‌ ଆତାନ୍‌ । ତାଙ୍ଗେଙ୍ଗ୍‌ କ୍ରିସ୍ଟ ଇନ୍ୟାନାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","ଇ ଲାକେ ଅବ୍ରାହାମ୍‌ତାଂ ଦାଉଦ୍‌ ପାତେକ୍‌ ଚଉଦ ଟିକ୍‌; ଦାଉଦର୍‌ତାଂ ବାବିଲନ୍‌ ଗେହ୍‌ନାକା ପାତେକ୍‌ ଚଉଦ ଟିକ୍‌ ଆରେ ବାବିଲନ୍‌ ଗେହ୍‌ନାକା ତାଙ୍ଗ୍‌ କ୍ରିସ୍ଟତି ଜଲମ୍‌ ପାତେକ୍‌ ଚଉଦ ଟିକ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","ଇଦାଂ ଆନାତା ଜିସୁ କ୍ରିସ୍ଟତି ଜଲମ୍‌ ବିସ୍ରେ । ତା ତେହି ମରିୟମ୍‌ ଜସେପ୍‌ ଲାହାଙ୍ଗ୍‌ ମାଲାକିୟା ଆଜ଼ି ମାଚାତ୍‌ । ମାତର୍‌ ହେୱାର୍‌ ବିବା ୱିଜ଼ୁ ୱିଜ଼୍‌ନି ଆଗେ ମରିୟମ୍‌ ପୁଚାତ୍‌ ଜେ ପୁଇପୁୟା ଜିବୁନ୍‌ ହୁକେ ମାଞ୍ଜେଙ୍ଗ୍‌ ଆସ୍ତାଙ୍ଗ୍‌ନା ଇଞ୍ଜି ପୁଚାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","ଜସେପ୍‌ ସବୁ ନାଞ୍ଜିଙ୍ଗ୍‌ ନ୍ୟାୟ୍‌ କାମାୟ୍‌ କିଜ଼ି ମାଚାନ୍‌ । ଲାଗିଂ ମରିୟମ୍‌ତିଂ ମାନାୟାର୍‌ ଲାଜୁତାଂ ରାକ୍ୟା କିଦେଙ୍ଗ୍‌ ଇଞ୍ଜି ଡ଼ୁଗ୍‌ଜି ମାଲାକିତାକାଦିଂ ବାଙ୍ଗାୟ୍‌ କିଦେଙ୍ଗ୍‌ ଇଞ୍ଜି ଉପାୟ୍‌ ପାଚି କିତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","“ହେୱାନ୍‌ ଇଦାଂ ଏତ୍‌କିନିହିଙ୍ଗ୍‌ ରୱାନ୍‌ ମାପ୍ରୁତି ଦୁତ୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ କେଚ୍‌କଣ୍‌ତ ଚଞ୍ଜ୍‌ୟା ଆଜ଼ି ଇଚାନ୍‌, ଏ ଦାଉଦ୍‌ ଲାତ୍ରାନି ଜସେପ୍‌ ! ମରିୟମ୍‌ତିଂ ଡକ୍ରି ଲାକେ ଇଡ୍‌ଦେଂ ପାଣ୍ଡ୍ରା ଆମା, ଇନାକିଦେଂକି ପୁଇପୁୟା ଜିବୁନ୍‌ ହୁକେ ମାଞ୍ଜେଙ୍ଗ୍‌ ଆସ୍ତାଙ୍ଗ୍‌ନା । ");
INSERT INTO peg_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","ତାଙ୍ଗ୍‌ ର ମାଜ଼ି ଜଲମ୍‌ ଆନାନ୍‌ । ଏନ୍‌ ତା ତର୍‌ ଜିସୁ ଇଟ୍‌ନାୟ୍‌, ଇନାକିଦେଂକି ହେୱାନ୍‌ ତା ଲଗାଂ ପାପ୍‌ତାଂ ରାକ୍ୟା କିନାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","ମାପ୍ରୁତି ରୱାନ୍‌ ବେଣ୍‌ବାକ୍‌ଣାୟ୍‌କିନାକାନ୍‌ ହୁକେ ଇମ୍‌ଣି ବେରଣ୍‌ ୱେଚ୍‌ଚି ମାଚାନ୍‌, ହେଦାଂ ପୁରା ଆଦେଂ ଇଞ୍ଜି ଇ ସବୁ ଗିଟା ଆଜ଼ି ମାଚାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“ହେ ଆଗେନିବେଣ୍‌ ଆନାତା, ରଞ୍ଜେଲ୍‌ ଜିପଲି ମାଞ୍ଜେଙ୍ଗ୍‌ଆସ୍ତି ମାଜ଼ି ଜଲମ୍‌ କିନାତ୍‌ । ହେ ମାଜ଼ି ‘ଇମାନୁୟେଲ୍‌’ ତର୍‌ଦ ତର୍‌ ଆନାତ୍‌ । ଇମାନୁୟେଲ୍‌ ଅରତ୍‌ ଇସ୍ୱର୍‌ ମାହୁଦାଂ ମାନାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","ଜସେପ୍‌ ହୁଚ୍‌କାଣ୍‌କୁ ରିଙ୍ଗ୍‌ତି ପାଚେ ହେୱାନ୍‌ ମାପ୍ରୁତି ଦୁତ୍‌ ବଲ୍‌ ଲାହାଙ୍ଗ୍‌ କାମାୟ୍‌ କିତାନ୍‌ । ହେୱାନ୍‌ ମରିୟମ୍‌ତିଂ ବିବା କିତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","ମାତର୍‌ ତା ହେ ମାଜ଼ି ଜଲମ୍‌ ଆନି ପାତେକ୍‌ ତା ଲାହାଙ୍ଗ୍‌ ରଚେ ହୁଞ୍ଜ୍‌ୱାତାର୍‌ । ଜସେପ୍‌ ହେ ମାଜ଼ି ଜିସୁ ତର୍‌ ହିତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","ହେରଦ୍‌ ରାଜା ସମୁତ ଜିହୁଦା ରାଜିନି ବେତ୍‌ଲିହିମ୍‌ ଗାଡ଼୍‌ଦ ଜିସୁ ଜଲମ୍‌ କିନାନ୍‌ । ଇଦାଂ ଅଲପ୍‍ ସମୁ ପାଚେ ୱେଡ଼ାହନି ଦେସ୍‌ନି କେତେଜାଣ୍‌ ପଣ୍ଡିତାର୍‌ ଜିରୁସାଲମ୍‌ତ ୱାଜ଼ି ୱେନ୍‌ବାତାର୍‌, ");
INSERT INTO peg_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","“ଇମ୍‌ଣି କାଡ଼୍‌ଦେ ଜିହୁଦିର୍‌ ରାଜା ଆନି କାଜିଂ ଜଲମ୍‌ ଆତାନ୍ନା, ହେୱାନ୍‌ ଇମେନ୍‌ ? ୱେଡ଼ାହନି ଦେସ୍‌ତାଂ ତା ହୁକାଙ୍ଗ୍‌ ହୁଡ଼୍‌ଜି ତାଙ୍ଗ୍‌ ପୁଜାକିନି କାଜିଂ ଆପେଂ ୱାତାପ୍‌ନା ।” ");
INSERT INTO peg_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","ହେୱାର୍‌ ଇ କାତା ୱେନ୍‌ଞ୍ଜି ରାଜା ହେରଦ୍‌ ଆରି ଜିରୁସାଲମ୍‌ନି ୱିଜ଼ାର୍‌ ବେସି ପାଣ୍ଡ୍ରା ଆତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","ହେରଦ୍‌ ୱିଜ଼ାର୍‌ ମୁଡ଼୍‌ ମାପ୍ରୁହେବାକିନାକାନ୍‌ ଆରି ଦରମ୍‌ ଗୁରୁରିଂ କୁକ୍‌ଚି ହେୱାରିଂ ୱେନ୍‌ବାତାନ୍‌, “ଇନେନ୍‌କି ମସିୟା ଇଚିସ୍‌ କ୍ରିସ୍ଟ ଇମେତାକେ ଜଲମ୍‌ ଆନାନ୍‌ ?” ");
INSERT INTO peg_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","ହେୱାର୍‌ ଉତର୍‌ ହିତାର୍‌, “ଜିହୁଦା ଦେସ୍‌ନି ବେତ୍‌ଲିହିମ୍‌ତ ।” ଇ ବିସ୍ରେ ରୱାନ୍‌ ବେଣ୍‌ବାକ୍‌ଣାୟ୍‌କିନାକାନ୍‌ ଲେକିକିନାନା, ");
INSERT INTO peg_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“ଜିହୁଦା ଦେସ୍‌ନି ବେତ୍‌ଲିହିମ୍‌ ! ଜିହୁଦାନି ମୁଡ଼୍‌ ବସ୍ତିକାଙ୍ଗ୍‌ ବିତ୍ରେ ଏପେଙ୍ଗ୍‌ ହାରୁକାଦେର୍‌ ଆକାୟ୍‌, ଇନାକିଦେଂକି ନା ଇସ୍ରାଏଲ୍‌ୟର୍‌ ମାନାୟାରିଂ ଚାଲାୟ୍‌କିଦେଂ ଇଞ୍ଜି ମିଙ୍ଗ୍‌ତାଂ ରୱାନ୍‌ ନେତା ହତ୍‌ନାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","ଇଦାଂ ୱେନ୍‌ଞ୍ଜି ହେରଦ୍‌ ୱେଡ଼ାହନି ଦେସ୍‌ନି ହେ ପଣ୍ଡିତାରିଙ୍ଗ୍‌ ଡ଼ୁଗ୍‌ଜି ବେଣ୍‌କିନି ସବାତ କୁକ୍‌ଚି ସମାନ୍‌ ଇମ୍‌ଣି ସମୁତ ହେ ହୁକା ହସି ମାଚାତ୍‌, ହେୱାର୍‌ତାଂ ବୁଜାଆତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","ତା ପାଚେ ହେୱାରିଂ ବେତ୍‌ଲିହିମ୍‌ ଗାଡ଼୍‌ଦ ପକ୍‌ଚି ଇଚାନ୍‌, “ହାଲାଟ୍‌ ହେ କାଡ଼୍‌ଦେଂ ହାର୍‌ କିଜ଼ି ଦାହାଟ୍‌ ଆରେ ତାଙ୍ଗେଙ୍ଗ୍‌ ହୁଡ଼୍‌ତିସ୍‌ ନାଙ୍ଗ୍‌ ୱେଚ୍‌ଚାଟ୍‌ ଆନ୍‌ ପା ହାଲ୍‌ଜି ତାଙ୍ଗେଙ୍ଗ୍‌ ପୁଜା କିନାଙ୍ଗ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","ହେବେ ହେୱାର୍‌ ରାଜା ବେଣ୍‌ ୱେନ୍‌ଞ୍ଜି ହାଚାର୍‌; ଆରେ ହୁଡ଼ା, ହେୱାର୍‌ ୱେଡ଼ାହତ୍‌ନି ଦେସ୍‌ତ ଇମ୍‌ଣି ହୁକା ହୁଡ଼୍‌ତାର୍‌, ହେଦାଂ ହେୱାର୍‌ ଆଗ୍‌ଦ ଆଗ୍‌ଦ ହାଲ୍‌ଜି, ଇମେତାକେ କାଡ଼୍‌ଦେ ମାଚାନ୍‌, ପାଚେ ହେ ବାହା ଜପି ଟେବାତାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","ହେୱାର୍‌ ହେଦେଲିଂ ହୁଡ଼୍‌ଜି ବେସି ୱାରିତାଂ ଏଚେକ୍‌ ଉଲ୍‌କା ଆଜ଼ି ନିଙ୍ଗ୍‌ତାର୍‌ ହେୱାର୍‌ ହେୱାରିଂ ଆଗେ ଆଗେ ହାଲ୍‌ଜି ହୁକା ଆରେ କାଡ଼୍‌ଦେ ମାନି ଇଲ୍‌ ଜପି ସମାନ୍‌ ଟେବା ଆତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","ହେୱାର୍‌ ହେ ଇଲ୍‌ ବିତ୍ରେ ହଟାର୍‌ ଆରି କାଡ଼୍‌ଦେଂ ତେହି ମରିୟମ୍‌ ଲାହାଙ୍ଗ୍‌ ହୁଡ଼୍‌ଜି ମେଣ୍ଡାଙ୍ଗ୍‌କୁନ୍ଦିକିଜ଼ି ତାଙ୍ଗ୍‌ ପାର୍ତାନା କିତାର୍‌ ଆରି ରଚେ ଅଜ଼ି ମାଚି ହନା, କୁନ୍ଦୁର୍‌ ଆରି ବାସ୍‌ନା ଚିକାଣ୍‌ ହପ୍‌ଚି ଦାନ୍‌ ହିତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","ଇଦାଂ ପାଚେ ହେୱାର୍‌ ବିନ୍‌ ର ହାଜ଼ି ହିଜ଼ି ଜାର୍‌ ଦେସ୍‌ତ ହାଚାର୍‌ । ଇନାକିଦେଂକି ହେରଦ୍‌ ଲାଗାଂ ହାଞ୍ଜେଙ୍ଗ୍‌ କାୱିତି କାଜିଂ ଇସ୍ୱର୍‌ ହେୱାରିଂ କେଚ୍‌କଣ୍‌ତ ବଲ୍‌ ହିଜ଼ି ମାଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","ହେୱାର୍‌ ହାଚି ପାଚେ ମାପ୍ରୁତି ଦୁତ୍‌ ଜସେପ୍‌ତିଂ କେଚ୍‌କଣ୍‌ତ ଚଞ୍ଜ୍‌ୟା ଆଜ଼ି ଇଚାନ୍‌, “ହେରଦ୍‌ କାଡ଼୍‌ଦେଂ ଟୁଣି କାଜିଂ ଦାହ୍‌ନାନ୍‌ । ଲାଗିଂ ନିଙ୍ଗାଟ୍‌, କାଡ଼୍‌ଦେଂ ଆରି ତେହିଙ୍ଗ୍‌ ଅଜ଼ି ମିସର୍‌ ଦେସ୍‌ତ ହାଲାଟ୍‌ । ହେ ବାହା ପିସ୍ତେଙ୍ଗ୍‌ ଇଞ୍ଜ୍‌ୱି ପାତେକ୍‌ ହେବେ ମାନାଟ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","ଜସେପ୍‌ ନିଙ୍ଗ୍‌ଜି କାଡ଼୍‌ଦେଂ ଆରି ତା ତେହିଙ୍ଗ୍‌ ଅଜ଼ି ହେ ନାଣା ମିସର୍‌ ଦେସ୍‌ତ ହାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","ହେରଦ୍‌ ହାନି ପାତେକ୍‌ ହେବେ ହେୱାର୍‌ ମାଚାର୍‌ । ଇ ୱିଜ଼ୁ ଗିଟାଆତି କାଜିଂ ବେଣ୍‌ବାକ୍‌ଣାୟ୍‌କିନାକାନ୍‌ ବେରଣ୍‌ ପୁରା ଆତାତ୍‌ । ମାପ୍ରୁ ଇଞ୍ଜି ମାଚାନ୍‌, “ନା ମାଜ଼ିଂ ଆନ୍‌ ମିସର୍‌ ଦେସ୍‌ତାଂ କୁକ୍‌ଚି ତାସି ୱାତାଂ ।” ");
INSERT INTO peg_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","ୱେଡ଼ାହନି ଦେସ୍‌ତାଂ ୱାଜ଼ି ମାନି ହେରଦ୍‌ ପଣ୍ଡିତାର୍‌ କାଜିଂ ତାଙ୍ଗେଙ୍ଗ୍‌ ଟକାୟ୍‌ କିଜ଼ି ହାଚାର୍‌ ଇଞ୍ଜି ପୁଞ୍ଜି, ହେରଦ୍‌ ରିସା ଆଜ଼ି ହାଚାନ୍‌ ଆରେ ବେତ୍‌ଲିହିମ୍‌ ଆରି ତା ଲାଗେ ଲାଗେନି ନାସ୍‌କୁକାଂ ମାନି ଦୁଇ ବାର୍ହୁ ଆରି ହେବେ ଉଣା ବାର୍ହୁନି ୱିଜ଼ାର୍‌ କାଡ଼୍‌ଦେରିଂ ଟୁଣି କାଜିଂ ବଲ୍‌ ହିନାନ୍‌ । ହୁକାଂ ହସି ମାନି ସମୁ ବିସ୍ରେ ହୁକାଂ ଗାଣାକିନାକାରିଂ ହେୱାନ୍‌ ଇମ୍‌ଣାକା ୱେନ୍‌ଞ୍ଜି ମାଚାନ୍‌, ହେ ଲାକେ ହେୱାନ୍‌ କାଡ଼୍‌ଦେର୍‌ ବାର୍ହୁନି ଇଟ୍‌କାଡ଼୍‌ ହପ୍‌ଚି ମାଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","ଇଦାଂ କାଜିଂ ବେଣ୍‌ବାକ୍‌ଣାୟ୍‌କିନାକାନ୍‌ ଜିରିମିୟତି ର ବେରଣ୍‌ ପୁରା ଆତାତ୍‌ । ଇଦାଂ ହେୱାନ୍‌ ଲେକିକିଜ଼ି ମାଚାନ୍‌, ");
INSERT INTO peg_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“ରାମା ବସ୍ତିତ ଚେରା ଆନାକା ୱେନାପା ହେଦାଂ କାକୁଲ୍‌ତି ଆଡ଼୍‌ବାନାକା କାଟ୍‌ ରାହେଲ୍‌ ତା ହିମ୍‌ଣାଂ କାଜିଂ ଆଡ଼୍‌ବାନାତା; ହେଦେଲିଂ ଇମ୍‌ଣି ଦୁକ୍‌ସାରାୟ୍‌ ଆଉତା, ଇନାକିଦେଂକି ହେୱାର୍‌ ୱିଜ଼ାର୍‌ ହାତାର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","ହେରଦ୍‌ ହାତି ପାଚେ ମାପ୍ରୁତି ଦୁତ୍‌ ମିସର୍‌ତ ଜସେପ୍‌ତିଂ ଚଞ୍ଜିୟାଆଜ଼ି ଇଚାନ୍‌, ");
INSERT INTO peg_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“ନିଙ୍ଗାଟ୍‌, କାଡ଼୍‌ଦେଂ ଆରି ତା ତେହିଙ୍ଗ୍‌ ଅଜ଼ି ଇସ୍ରାଏଲ୍‌ ଦେସ୍‌ତ ମାସ୍‌ଦି ହାଲାଟ୍‌ । ଇନାକିଦେଂକି ଇମ୍‌ଣାକାର୍‌ କାଡ଼୍‌ଦେତି ଜିବୁନ୍‌ ନାସ୍‌ କିଦେଙ୍ଗ୍‌ କାଜିଂ ସେସ୍ଟା କିଜ଼ି ମାଚାର୍‌, ହେୱାର୍‌ ହାତାର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","ଲାଗିଂ ଜସେପ୍‌ ନିଙ୍ଗ୍‌ଜି କାଡ଼୍‌ଦେଂ ଆରି ମରିୟମ୍‌ତିଂ ଅଜ଼ି ଇସ୍ରାଏଲ୍‌ ଦେସ୍‌ତ ମାସ୍‌ଦି ହାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","ମାତର୍‌ ହେରଦ୍‌ ପାଚେ ତା ମାଜ଼ି ଆର୍କିଲାୟ୍‌, ଜିହୁଦାନି ରାଜା ଆତାକା ୱେନ୍‌ଞ୍ଜି ହେୱାନ୍‌ ହେବେ ହାଞ୍ଜେଙ୍ଗ୍‌ ପାଣ୍ଡ୍ରା ଆନାନ୍‌ । ମାତର୍‌ କେଚ୍‌କଣ୍‌ତ ବିନ୍‌ ଦେସ୍‌ ପାୟାଜ଼ି ହେୱାନ୍‌ ଗାଲିଲି ରାଜିନିପ ହାଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","ଆରେ ରଗ ବିନ୍‌ବାନି କେଚ୍‌କଣ୍‌ ପାୟା ଆଜ଼ି ହେୱାନ୍‌ ଗାଲିଲି ରାଜିତ ନାଜରିତ୍‌ ବସ୍ତିତ ଇଲ୍‌ କିଜ଼ି ମାଚାନ୍‌ । ୱିସ୍ତି ବିତ୍ରେ ବେଣ୍‌ବାକ୍‌ଣାୟ୍‌କିନାକାନ୍ତି ହାରିହାରା ଲେକାଆତାକା ରଞ୍ଜାଙ୍ଗ୍‌ ବଚନ୍‌ ପୁରା ଆତାତ୍‌ । “ହେୱାନ୍‌ ନାଜରିତିୟ ଇଞ୍ଜି ପୁଟାଆନାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","ହେ ୱେଡ଼ାଲିଂ ବାପ୍ତିସିମ୍‌ ହିନି ଜହନ୍‌ ଜିହୁଦା ରାଜିନି ବାଟାରାଜିତ ୱାଜ଼ି ସୁଣାୟ୍‌କିଦେଂ ଆରମ୍‌ କିତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","ହେୱାନ୍‌ ଇଞ୍ଜି ମାଚାନ୍‌, “ପାପ୍‌ ହାଜ଼ିତାଂ ମାନ୍‌ବାଦ୍‌ଲାୟ୍‌ କିୟାଟ୍‌, ଇନାକିଦେଂକି ସାର୍ଗେ ରାଜି ଲାଗାଂ ।” ");
INSERT INTO peg_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","ଜିସାୟ୍‌ ବେଣ୍‌ବାକ୍‌ଣାୟ୍‌କିନାକାନ୍‌ ଇମ୍‌ଣି ମୁଣିକାନ୍ତି ବିସ୍ରେ ଇଞ୍ଜି ମାଚାନ୍‌, ଜହନ୍‌ ନେ ହେ ମାନାୟ୍‌; “ବାଲିବାଟାତ ଇନେର୍‌ ରକାନ୍‌ କିକିରାଡିଂ କିଜ଼ି ଇନାନ୍ନା, ମାପ୍ରୁ କାଜିଂ ହାଜ଼ି ଜାଲ୍‌ଦି କିୟାଟ୍‌; ହେୱାନ୍‌ ୱାନି କାଜିଂ ରଞ୍ଜାଙ୍ଗ୍‌ ଆଡ଼୍‌ୱା ହାଜ଼ି ରଚାଟ୍ ।” ");
INSERT INTO peg_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","ହେ ଜହନ୍‌ ଉଟ୍‌ ତଲ୍‌ନି ହେନ୍ଦ୍ରା ଉସ୍ପିସ୍‌ ମାଚାନ୍‌ । ହେୱାନ୍‌ ତା ମ୍ଡେଙ୍ଗାତ ତଲ୍‍ନି ନୁଣ୍‌କୁ ଡରି ଗାଚ୍‌ଚି ମାଚାନ୍ । ପାମି ଆରି ରାନ୍ତିପୁକି ହେୱାନ୍ତି କାଦି ମାଚାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","ଜିରୁସାଲମ୍‌ ବସ୍ତିତାଂ, ଜିହୁଦା ଦେସ୍‌ତ ଆରି ଜର୍ଦନ୍‌ ନାଗୁଡ଼୍‌ ଲାଗାଂ ୱିଜ଼ାର୍‌ ନିପ୍‌ଣାକାର୍‌ ମାନାୟାର୍‌ ତା ଲାଗେ ୱାଜ଼ି ମାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","ହେୱାର୍‌ ଜାର୍‌ ଜାର୍‌ତି ପାପ୍‌ ମାନି କିଜ଼ି ଜହନ୍‌ତାଂ ଜର୍ଦନ୍‌ ନାଗୁଡ଼୍‍ତ ବାପ୍ତିସିମ୍‌ ଅଜ଼ି ମାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","ଏଚେକାଡ଼୍‌ଦ ଜହନ୍‌ ହୁଡ଼୍‌ତାନ୍‌ ଆଦେକ୍‌ ପାରୁସିର୍‌ ଆରେ ସାଦୁକିର୍‍ ବାପ୍ତିସିମ୍‌ ଅନି କାଜିଂ ୱାନାରା; ହେୱାନ୍‌ ଇଚାନ୍‌, “କାଲାଟିରାଚ୍‌ନି ଲାତ୍ରା,” ୱାନିଦିନ୍‍ ମାପ୍ରୁତି ଟାକ୍ରିତାଂ ହନ୍ତେଙ୍ଗ୍‌ କାଜିଂ ଇନେର୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ଚେତ୍‌ନା ହିତ୍‍ତାନ୍ ? ");
INSERT INTO peg_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","ଲାଗିଂ ମାନ୍‌ବାଦ୍‌ଲାୟ୍‌ କିନି ହାର୍ଦି ପାଡ଼୍‌ ଉବ୍‌ଜାଣ୍‌ କିୟାଟ୍‌; ଆରେ, ଇଦାଂ ମି ହାର୍ଦି କାମାୟ୍‌ କାବାଡ଼୍‍ତ ଚଚାଟ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","ବାବି କିମାଟ୍‌ ଜେ ଅବ୍ରାହାମ୍‌ ମା ଆବା, ଇଞ୍ଜି ମାନେ ମାନେ ଏପେଙ୍ଗ୍‌ ଇନ୍‌ମାଟ୍‌, ଇନାକିଦେଂକି ଆନ୍‌ ମିଙ୍ଗ୍‌ ଇଞ୍ଜି ଇଟ୍‌ନାଙ୍ଗା ଜେ ଇସ୍ୱର୍‌ ଇ କାଲ୍‌କୁକାଂ ଅଜ଼ି ଅବ୍ରାହାମ୍‌ ଲାତ୍ରା ଉବ୍‌ଜାଣ୍‌ କିଦେଙ୍ଗ୍‌ ଆଡ୍‌ନାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","ଆରେ, ନଙ୍ଗ୍‌ ପା ମାର୍‍କୁକାଂ ଦଲ୍‌ଦ କୁଡ଼େଲ୍‌ ଲାଗାତାତ୍‍ନ୍ନା; ଇମ୍‌ଣି ମାର୍‌କୁ ହାର୍‌ ପାଡ଼୍‌ ଆହ୍‌ୱିତିସ୍‌, ହେଦାଂ କାଦ୍‌ଦି ନାଣିତ ତୁହିୟା ଆନାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","ଜହନ୍‌ ୱିଜ଼ାକାରିଂ ଉତର୍‌ ହିନାନ୍‌, “ଆନ୍‌ ହିନା ମିଙ୍ଗେଙ୍ଗ୍‌ ମାନ୍‌ବାଦ୍‌ଲାୟ୍‌ କିଦେଂ ଏଜ଼ୁଂତାଂ ବାପ୍ତିସିମ୍‌ ହିତ୍‌ତାଂନା, ମାତର୍‌ ନା ପାଚେ ଇନେନ୍‌ ୱାନାନା, ହେୱାନ୍‌ ନାଙ୍ଗ୍‌ତାଂ ସାକ୍ତିକାଟାକାନ୍‌, ତା ପାନାନି ପାଣ୍ଡାଇଙ୍ଗ୍‌ ରିକ୍‌ତେଂ ଇଞ୍ଜି ଆନ୍‌ ସମାନ୍‌ ଆକାୟ୍‌; ହେୱାନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ପୁଇପୁୟା ଜିବୁନ୍ତାଂ ଆରି ନାଣିତ ବାପ୍ତିସିମ୍‌ ହିଦ୍‌ନାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","ତା କେଇଦ ହେଚି ମାନାତ୍‌, ଲାଗିଂ ବାରବାନି ତାସ୍‌ ନିର୍ମଲ୍‌ କିଜ଼ି ଟୁଣ୍ଡିତ ଗଁମ୍‌ ରୁଣ୍ଡାୟ୍‌ କିଜ଼ି ଇଡ୍‌ଦେଂ ଇଞ୍ଜି ହେୱାନ୍‌ କେଇଦ ହେଚି ମାନାତ୍‌, ମାତର୍‌ ପୁଟା ୱିଜ଼ୁ ହେୱାନ୍‌ ହାୱିନାଣିତ ଦେସ୍‌ସି ତୁହିନାନ୍‍ ।” ");
INSERT INTO peg_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","ହେ ପାଦ୍‌ନା ଜିସୁ ଗାଲିଲିତାଂ ୱାଜ଼ି ବାପ୍ତିସିମ୍‌ ମାନି କିଦେଙ୍ଗ୍‌ ଇଞ୍ଜି ଜର୍ଦନ୍‌ ନାଗୁଡ଼୍‌ ଗୁଟିତ ଜହନ୍‌ତାଂ ବାପ୍ତିସିମ୍‌ ଅତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","ମାତର୍‌ ଜହନ୍‌ ଜିସୁଙ୍ଗ୍‌ ବୁଲାୟ୍‌କିଜ଼ି ଇଚାନ୍‌, “ଆନ୍‌ ହିନା ନି ତାଙ୍ଗ୍‌ ବାପ୍ତିସିମ୍‌ ଆନି କାତା-ଏନ୍‌ ଆତିସ୍‌ପା ନା ଲାଗାଂ ୱାତାୟ୍‌ନା ?” ");
INSERT INTO peg_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","ମାତର୍‌ ଜିସୁ ଉତର୍‌ ହିତାନ୍‌, ନଙ୍ଗ୍‌ “ନା କାତାତ ରାଜିଆ । ଇନାକିଦେଂକି ଇଦାଂ କାଜିଂ ଆସେଙ୍ଗ୍‌ ଇସ୍ୱର୍ତି ଇଚା କାମାୟ୍‌ କିଦେଙ୍ଗ୍‌ ଆଡ୍‌ନାସ୍‌ ।” ଲାଗିଂ ଜହନ୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ବାପ୍ତିସିମ୍‌ ହିଦେଂ ରାଜି ଆତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","ଜିସୁ ବାପ୍ତିସିମ୍‌ ଅଜ଼ି ଏଜ଼ୁଂତାଂ ନିଙ୍ଗ୍‌ଜି ୱାନିହିଂ ହେୱାନ୍‌ ହୁଡ଼୍‌ତାନ୍‌ ବାଦାଡ଼୍‌ ଜେୟାଆତାତ୍‌ନା ଆରେ ଇସ୍ୱର୍‌ତି ଜିବୁନ୍‌ ପାଣ୍ଡ୍‌କା ଲାକେ ତା ଜପି କୁଚ୍‌ଚାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","ତା ପାଚେ ସାର୍ଗେତାଂ ଇ ଗାର୍ଜାନ୍‌ ଆତାତ୍‌, “ଇୱାନ୍‌ ନା ୱାରିନି ମାଜ଼ି, ତାତାକେ ଆନ୍‌ ବେସି ୱାରି ।” ");
INSERT INTO peg_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","ଇଦାଂ ପାଚେ ପୁଇପୁୟା ଜିବୁନ୍‌ ଜିସୁଙ୍ଗ୍‌ ବାଲି ବାଟାନିପ ଅଜ଼ି ହାତାତ୍‌ । ହେବେ ହେୱାନ୍‌ ସୟ୍‌ତାନ୍‌ ହୁଦାଂ ପରିକ୍ୟା କିୟାତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","ଆରେ, ଚାଲିସ୍‌ ୱେଡ଼ା ଆରି ଚାଲିସ୍‌ ନାଣା ଉପାସ୍‌ କିଜ଼ି ହାରିହାରା ଜିସୁ ନାସ୍‌କି ଆତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","ହେୱାଡ଼ାଂ ସୟ୍‌ତାନ୍‌ ଜିସୁ ଲାଗାଂ ୱାଜ଼ି ଇଚାତ୍‌, “ଏନ୍‌ ଜଦି ଇସ୍ୱର୍‌ ମାଜ଼ି, ଇ କାଲ୍‌କୁକାଂ ରୁଟି ଆଦେଂ ଇଞ୍ଜି ବଲ୍‌ ହିୟା ।” ");
INSERT INTO peg_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","ମାତର୍‌ ଜିସୁ ଉତର୍‌ ହିନାନ୍‌, “ଦରମ୍‌ ସାସ୍ତର୍‌ତ ଲେକା ମାନାତ୍‌, ମାନାୟ୍‌ କେବଲ୍‌ ରୁଟିଂ ତିନ୍‌ଞ୍ଜି ଜିଉନ୍‌ । ମାତର୍‌ ଇସ୍ୱର୍‌ ୱେଇଦିଂ ହତ୍‌ନି ୱିଜ଼ୁ ବଚନ୍‌ ହୁକେ ଜିବୁନ୍‌ କାଜିଂ ଲଡ଼ା ।” ");
INSERT INTO peg_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","ଇଦାଂ ପାଚେ ସୟ୍‌ତାନ୍‌ ଜିସୁଙ୍ଗ୍‌ ପୁଇପୁୟା ଗାଡ଼୍‌ଦ ଜିରୁସାଲମ୍‌ତ ଅଜ଼ି ହାତାତ୍‌ । ହେବେ ତାଙ୍ଗେଙ୍ଗ୍‌ ମନ୍ଦିର୍‌ନି ବେସି ଜପି କୁଚି କିଜ଼ି ଇଚାତ୍‌, ");
INSERT INTO peg_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","“ଏନ୍‌ ଜଦି ଇସ୍ୱର୍‌ ମାଜ଼ି, ତା ଆତିସ୍‌ ଇବେତାଂ ତାରେନ୍‌ ଗୁମା । ଇନାକିଦେଂକି ଦରମ୍‌ ସାସ୍ତର୍‌ତ ଲେକା ମାନାତ୍‌, ନିଙ୍ଗେଙ୍ଗ୍‌ ରାକ୍ୟା କିଦ୍‌ନି କାଜିଂ ହେୱାନ୍‌ ଜାର୍‌ ଦୁତ୍‌ରିଂ ନି ବିସ୍ରେ ବଲ୍‌ ହିନାନ୍‌ । ଏଚେକାଡ଼୍‌ଦ ନି ପାନା କାଲ୍‌ଦ ଆଡ଼୍‌ଦାନାତ୍‌ । ଇଦାଂ କାଜିଂ ହେୱାର୍‌ ନି କେଇଦ ଆସ୍ତାନାର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","ଜିସୁ ସୟ୍‌ତାନ୍‌ତିଂ ଉତର୍‌ ହିତାନ୍‌, “ଦରମ୍‌ ସାସ୍ତର୍‌ତ ଲେକାମାନାତ୍‌, ଏନ୍‌ ମାପ୍ରୁ ଜାର୍‌ ଇସ୍ୱର୍‌ତିଂ ପରିକ୍ୟା କିଉୟ୍ ।” ");
INSERT INTO peg_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","ତା ପାଚେ ସୟ୍‌ତାନ୍‌ ଜିସୁଙ୍ଗ୍‌ ଜପି ଅଜ଼ି ଆରି ଜିସୁଙ୍ଗ୍‌ ପୁର୍ତିନି ସବୁ ରାଜି ଆରେ ହେ ସବୁ ହଲ୍‌ନାକା ଚଚ୍‌ଚି ଇଚାତ୍‌, ");
INSERT INTO peg_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","“ଜଦି ଏନ୍‌ ଏଚେକାଡ଼୍‌ଦ ମେଣ୍ଡାଙ୍ଗ୍‌ କୁନ୍ଦିକିଜ଼ି ନାଙ୍ଗେଙ୍ଗ୍‌ ପୁଜା କିଦ୍‍ନାୟ୍‌, ଇ ୱିଜ଼ୁ ନିଙ୍ଗେଙ୍ଗ୍‌ ଆନ୍‌ ହିଦ୍‌ନାଂ ।” ");
INSERT INTO peg_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","ଜିସୁ ଉତର୍‌ ହିତାନ୍‌, “ଦେହା ଆ ସୟ୍‌ତାନ୍‌ ! ଦରମ୍‌ ସାସ୍ତର୍‌ର୍ତ ଲେକାମାନାତ୍‌, କେବଲ୍‌ ନି ମାପ୍ରୁ ଇସ୍ୱର୍‌ତିଂ ପାର୍ତାନା କିୟା ଆରି ହେୱାନ୍ତି ହେବା କିୟା ।” ");
INSERT INTO peg_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","ତା ପାଚେ ସୟ୍‌ତାନ୍‌ ତାଙ୍ଗ୍‌ ପିସ୍ତି ହାଚାତ୍‌, ଆରେ ହୁଡ଼ାଟ୍‌, ଦୁତ୍‌କୁ ୱାଜ଼ି ହେୱାନ୍ତି ହେବା କିଦେଙ୍ଗ୍‌ ଲାଗିତିକ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","ଜହନ୍‌ତିଂ ଗେହ୍‌ତାର୍ଣ୍ଣା ଇଞ୍ଜି ୱେଚି ପାଚେ ଜିସୁ ଗାଲିଲିତ ହାଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","ମାତର୍‌ ନାଜରିତିୟତ ମାନ୍‌ୱାଦାଂ ଜବୁଲୁନ୍‌ ଆରି ନପ୍‌ତାଲି ନାସ୍‌କୁକାଂ ମାନି ଗାଲିଲି ହାମ୍‌ଦୁର୍‌ ଗୁଟିନି କପର୍ନାହୁମ୍‌ ତାକେ ବାହା କିତାନ୍‌ ");
INSERT INTO peg_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","ଇଦାଂ ହୁକେ ବେଣ୍‌ବାକ୍‌ଣାୟ୍‌କିନାକାନ୍‌ ଜିସାୟ୍‌ତି ବେଣ୍‌ ପୁରା ଆତାତ୍‌ । ହେୱାନ୍‌ ଇଞ୍ଜି ମାଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","ଜର୍ଦନ୍‌ ନାଗୁଡ଼୍‌ ଆଣ୍ଟି ପାଡ଼୍‌କା ହାମ୍‌ଦୁର୍‌ତିଂ ଆର୍ଜି ମାନି ହାଜ଼ି ଜପି ମାନାତ୍‌ ଜବୁଲୁନ୍‌ ଆରି ନପ୍‌ତାଲି ଦେସ୍‌ ରିଣ୍ଡି ପାର୍ତିକିୱି ଜିହୁଦିର୍‌ତି ଗାଲିଲି ! ");
INSERT INTO peg_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","ମାଜ୍‌ଗାତ ବାହା କିଜ଼ିମାନି ମାନାୟାର୍‌ ର ଅଜଡ଼୍‌ନି ଦିବାସ୍‌ ହୁଡ଼୍‌ନାର୍‌ ହାକିନି ନାଣା ନାସ୍‌କୁକାଂ ମାନି ମାନାୟାର୍‌ ଜପି ହେ ଅଜଡ଼୍‌ ଚଞ୍ଜ୍‌ୟା ଆତାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","ହେ ସମୁତାଂ ଜିସୁ ସୁଣାୟ୍‌ କିଜ଼ି ଇଚାନ୍‌, “ପାପ୍‌ ହାଜ଼ିତାଂ ମାନ୍‌ବାଦ୍‌ଲାୟ୍‌ କିୟାଟ୍‌, ଇନାକିଦେଂକି ସାର୍ଗେ ରାଜି ଲାଗାୟ୍‌ !” ");
INSERT INTO peg_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","ଜିସୁ ଗାଲିଲି ହାମ୍‌ଦୁର୍‌ ପାଡ଼ିତ ବୁଲାନି ସମୁତ ସିମନ୍‌, ଇନେରିଂକି ପିତର୍‌ ଇଞ୍ଜି ଇନାର୍‌, ଆରେ ତା ଟଣ୍ଡାହିଙ୍ଗ୍‌ ଆନ୍ଦ୍ରିୟ, ଇ ଟଣ୍ଡ୍‌ରିୟାରିଂ ହାମ୍‌ଦୁର୍‌ତ ଜାଲ୍‌ ତୁହିନାକା ହୁଡ଼୍‌ତାନ୍‌, ଇନେକିଦେଂକି ହେୱାର୍‌ ମିନ୍‌କୁ ଆହ୍‌ନାକାର୍‌ ମାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","ଜିସୁ ହେୱାରିଂ କୁକ୍‌ଚି ଇଚାନ୍‌, “ନା ପାଚେ ପାଚେ ୱାଡ । ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ମାନାୟ୍‌ ଆହ୍‌ନାକା ହିକାଇ କିଦ୍‌ନାଙ୍ଗ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","ହେୱାର୍‌ ହେ ଦାପ୍ରେ ହେ ଜାଲ୍‌ ପିସ୍ତି ତା ଲାହାଙ୍ଗ୍‌ ହାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","ଜିସୁ ଅଲପ୍‍ ଦେହା ହାଲ୍‌ଜି ଜାକୁବ୍‌ ଆରି ଜହନ୍‌ ତର୍‌ଦାକାନ୍‌ ଜେବ୍‌ଦିତି ରିୟାର୍‌ ମାଜ଼ିରିଂ ବେଟା ଆତାନ୍‌ । ଇ ରି ଟଣ୍ଡ୍‌ରିୟାର୍‌ ଆରି ହେୱାର୍‌ ଲାତ୍ରାହି ଡଙ୍ଗାତ କୁଚ୍‌ଚି ହେୱାର୍‌ତି ଜାଲ୍‌ ଗାଡ଼ି କିଜ଼ି ମାନାକା ହୁଡ଼୍‌ଜି ହେୱାରିଂ କୁକ୍‌ତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","ଜିସୁ ହେୱାରିଂ ପା କୁକ୍‌ତାନ୍‌ ଆରି ହେୱାର୍‌ ସାଙ୍ଗେ ସାଙ୍ଗେ ଡଙ୍ଗା ଆରି ଲାତ୍ରାହିଂ ପିସ୍ତି ଜିସୁତି ପାଚେ ପାଚେ ହାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","ପାଚେ ଜିସୁ ହେୱାର୍‌ତି କୁଟୁମ୍‌ ଇଞ୍ଜ ହିକ୍ୟା ହିଜ଼ି ଇସ୍ୱର୍ତି ରାଜିନି ନେକ୍ରିକାବୁର୍‌ ସୁଣାୟ୍‌ କିଜ଼ି ଆରି ଲକାର୍‌ ୱିଜ଼ୁ ବାନି ରଗ୍‌ ଆରି ୱିଜ଼ୁ ବାନି ବେମାର୍‌ ଉଜ୍‌ କିଜ଼ି ସବୁ ଗାଲିଲିତ ବୁଲାଦେଂ ଲାଗାତାନ୍‌, ");
INSERT INTO peg_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","ଆରେ ହେୱାନ୍ତି ବିସ୍ରେ ମାନାୟାର୍‌ ୱିଜ଼ାକାର୍‌ ସିରିୟା ପାତେକ୍‌ ୱିଣ୍‍ଜି ହାଚାତ୍‍ ଆରି ଲକୁ ପୁଦା ଡୁୟାତାକାର୍‍, ଆପ୍ରାଂ ଆରି ହିର୍‌କଲ୍‌ ଇଡ଼୍‌ୟାତି ରଗିରିଂ ସବୁ ବାର୍‍ବାନି ରଗ୍‌ତ ବେମାର୍‌ ଆରି ନନାକାରିଂ ହେୱାନ୍‌ ତାକେ ତାହିୱାତାର୍‌, ଆରେ ହେୱାନ୍‌ ହେୱାରିଂ ଉଜ୍‌ କିତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","ଆରେ ଗାଲିଲି, ଦେକାପଲି, ଜିରୁସାଲମ୍‌, ଜିହୁଦା ରାଜି ଆରି ଜର୍ଦନ୍‌ନି ଆଣ୍ଟିପାଡ଼୍‍କାତାଂ ବେସି ହେନି ଲକୁ ୱାଜ଼ି ହେୱାନ୍‌ ପାଚେ ପାଚେ ହାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","ଜିସୁ ମାନାୟ୍‌ ଗହ୍‌ଲି ହୁଡ଼୍‌ଜି ମାଡ଼ି ଜପି ଦୁମ୍‌ତାନ୍‌, ଆରେ କୁଚ୍‌ଚି ପାଚେ ହେୱାନ୍ତି ଚେଲାର୍‌ ହେୱାନ୍‌ ଚାର୍‌ବେଣ୍‌ତାଂ ବେଡ଼ି କିଜ଼ି ଲାଗେ ୱାତାର୍ । ");
INSERT INTO peg_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","ହେବେ ଜିସୁ ୱେଇ କିଜ଼ି, ହେୱାରିଂ ହିକ୍ୟା ହିଜ଼ି ଇଞ୍ଜେଙ୍ଗ୍‌ ଲାଗାତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","ଜିବୁନ୍‌ତ କାକୁଲ୍‌ତି ଲକୁ ଦନ୍ୟ, ଇନାକିଦେଂକି ସାର୍ଗେ ରାଜି ହେୱାର୍‌ତି । ");
INSERT INTO peg_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","ଆଡ଼୍‍ବିନି ଲକୁ ଦନ୍ୟ, ଇନାକିଦେଂକି ଇସ୍ୱର୍‌ ହେୱାରିଂ ଦୁକ୍‌ସାରାୟ୍‌ କିନାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","ସାଦୁ ଲକୁ ଦନ୍ୟ, ଇନାକିଦେଂକି ହେୱାର୍‌ ପୁର୍ତିନି ଆଦିକାରି ଆନାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","ଇସ୍ୱର୍ତି ଇଚାତାଂ ଇମ୍‌ଣାକାର୍‌ କାମାୟ୍‌ କିନି ମାନାୟ୍‌ ହେୱାର୍‌ ଦନ୍ୟ, ଇନାକିଦେଂକି ଇସ୍ୱର୍‌ ହେୱାରିଂ ସାରି ଆନାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","ଇମ୍‌ଣାକାର୍‌ ବିନ୍‌ଲକାରିଂ କାର୍ମା ଆନାନ୍‌, ହେୱାର୍‌ ଦନ୍ୟ, ଇନାକିଦେଂକି ଇସ୍ୱର୍‌ ହେୱାରିଂ ଦୟା କିନାନ୍ । ");
INSERT INTO peg_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","ଇନେର୍‌ତି ମାନ୍‌ ସକଟ୍‌ ହେୱାନ୍‌ ଦନ୍ୟ, ଇନାକିଦେଂକି ହେୱାର୍‌ ଇସ୍ୱର୍‌ତିଂ ହୁଡ଼୍‌ନାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","ଇମ୍‌ଣାକାର୍‌ ସୁସ୍ତା ହୁଗ୍‍ଇଡ଼୍‍ଦେଂ ସେସ୍ଟା କିତାର୍‌ ହେୱାର୍‌ ଦନ୍ୟ, ଇନାକିଦେଂକି ହେୱାର୍‌ ଇସ୍ୱର୍ତି ହିମ୍‌ଣାଂ ଇଞ୍ଜି ଡାକ୍‍ପୁଟାନାର୍ । ");
INSERT INTO peg_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","ଇସ୍ୱର୍ତି ଇଚାତ କାମାୟ୍‌ କିଜ଼ି ଇମ୍‌ଣାକାର୍‌ ନିନ୍ଦାପାୟାନାର୍‌ ହେୱାର୍‌ ଦନ୍ୟ, ଇନାକିଦେଂକି ସାର୍ଗେ ରାଜି ହେୱାର୍‌ତି । ");
INSERT INTO peg_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","ମାନାୟାର୍‌ ଏଚେକାଡ଼୍‌ଦ ମିଙ୍ଗେଙ୍ଗ୍‌ ନା କାଜିଂ ନିନ୍ଦା ଆରି ଲାଜ୍‌କୁଇ କିଦ୍‌ନାର୍‌, ଆରେ ମିଚ୍‍ତ ମି ବିରୁଦ୍‌ତ ସବୁ ବାନ୍ୟା କାତା ଇଞ୍ଚିସ୍, ତେବେ ଏପେଙ୍ଗ୍‌ ଦନ୍ୟ । ");
INSERT INTO peg_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","ୱାରି କିଜ଼ି ୱାର୍‌ୟା ଆଡୁ, ଇନାକିଦେଂକି ସାର୍ଗେତ ମିଦାଂ ଇନାମ୍‌ ଜବର୍‌ । ହେ ଲାକେ ତ ହେୱାର୍‌ ମି ପୁର୍ବେନିକାର୍ ବେଣ୍‍ବାକ୍‍ଣାୟ୍‍କିନାକାରିଂ ନିନ୍ଦା କିଜ଼ି ମାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","ଏପେଙ୍ଗ୍‌ ପୁର୍ତିନି ହର୍‌ ଲାକେ, ମାତର୍‌ ହର୍‌ ଜଦି ହୱାଦ୍‍ ଆୱିତିସ୍‌, ବାଟିଙ୍ଗ୍‌ ହେଦାଂ ଇମେ କାର୍‌ୟା ଆନାତ୍‌ ? ହେଦାଂ ଆରେ ଇମେତାକେ କାମାୟ୍‌ତ ୱାଉତ୍, କେବଲ୍‌ ବାର୍ତ ତୁହିଜ଼ି ମାନାୟାର୍‌ ପାନା ତାରେନ୍‌ କ୍ଡୁସ୍‌ପାୟ୍‌ ଆନି ଜଗ୍ । ");
INSERT INTO peg_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","ଏପେଙ୍ଗ୍‌ ପୁର୍ତିନି ଅଜଡ଼୍‌ । ମାଡ଼ି ଜପି ରଚ୍‌ଚି ଗାଡ଼୍‌ ଡ଼ୁଗ୍‌ଜି ମାଞ୍ଜେଙ୍ଗ୍‌ ଆଡୁତ୍‌; ");
INSERT INTO peg_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","କି ମାନାୟାର୍‌ ବଇଟା କାଚାୟ୍‌ କିଜ଼ି ମାଣ୍‌ ତାରେନ୍‌ ଇଟୁର୍‌, ମତର୍‌ ବଇଟା ଇଟ୍‌ନି ଜପି ଇଟ୍‌ନାର୍‌, ହେବେ ହେଦାଂ ଇଞ୍ଜ ମାନି ୱିଜ଼ାରିଂ ଅଜଡ଼୍‌ ହିନାତ୍ । ");
INSERT INTO peg_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","ହେ ଲାକେ ମି ଦିବାସ୍‌ ଲକୁର୍ ମୁମ୍‌ଦ ଦିବାସ୍‌ ଆୟେତ୍‌, ଇନେସ୍‌କି ହେୱାର୍‌ ମି ହାତ୍‌ପା କାମାୟ୍‌ତ ହୁଡ଼୍‌ଜି ମି ସାର୍ଗେ ମାନି ବାୱାତି ପାଣ୍‍ଦିଂ କେର୍‌ନାର୍ । ");
INSERT INTO peg_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","ଆନ୍‌ ଜେ ମସାତି ବିଦି କି ବେଣ୍‌ବାକ୍‌ଣାୟ୍‌କିନାକାର୍ତି ଦରମ୍‌ ସାସ୍ତର୍‌ ବୁଡାୟ୍‍ କିଦେଙ୍ଗ୍‌ ୱାତାଂନ୍ନା, ଇଦାଂ ବାବିକିମାଟ୍; ବୁଡାୟ୍‍ କିଦେଙ୍ଗ୍‌ ୱାୱାତାଂନା ମାତର୍‌ ପୁରା କିଦେଙ୍ଗ୍‌ ୱାତାଂନ୍ନା । ");
INSERT INTO peg_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","ଇନେକିଦେଂକି ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ହାତ୍‌ପା ଇଞ୍ଜ୍‌ନାଙ୍ଗା, ସାର୍ଗେ ଆରି ପୁର୍ତି ବୁଡା ଆୱି ପାତେକ୍‌ ମସାତି ବିଦି ର ଟପା, ଇନେସ୍‌ ପା ବୁଡା ଆଉତ୍‌ । ୱିଜ଼ୁ ବିସ୍ରେନି ୱିଜ଼ୁ ବୁଡାଆୱି ପାତେକ୍‌ ଗିଟା ଆଉତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","ଲାଗିଂ ଇନେର୍‌କି ବିଦିନି ୱିଜ଼େତାଂ ଗାଜା ବଲ୍‌କୁ ମାନିକିୱାତାନ୍‍ଚି ଆରି ହେ ଲାକେ କିତିଲେ ବିନ୍‍ ଲକାଂ ହିକ୍ୟା ହିନାନ୍‌, ହେୱାନ୍‌ ସାର୍ଗେ ରାଜିତ ୱିଜ଼େ ତାଙ୍ଗ୍‌ ହାରୁ ଇଞ୍ଜି ଇନ୍ୟା ଆନାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","ଲାଗିଂ ଆନ୍‌ ଇଞ୍ଜ୍‌ନାଙ୍ଗା ଦରମ୍‌ ଗୁରୁର୍‌ ଆରି ପାରୁସିର୍‌ତାଂ ଆଦିକ୍‌ ପାର୍ତି କିଜ଼ି ଇସ୍ୱର୍‌ତି ଇଚା ଲାକେ କାମାୟ୍‌ କିତିସ୍‌ ହାଲ୍‌ଜି ଏପେଙ୍ଗ୍‌ ସାର୍ଗେ ରାଜିତ ହଣ୍ଡେଙ୍ଗ୍‌ ଆଡ୍‌ନାଦେର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","ଏପେଙ୍ଗ୍‌ ୱେଚାଦେର୍ଣ୍ଣା ଜେ; ଆଗେ କାଡ଼୍‌ଦ ଲକାରିଂ ୱେଚ୍‍ଚାର୍ଣ୍ଣା, ନାର୍‌ ଅହ୍‌ମାଟ୍‌ । ଇନେର୍‌ ହେଦାଂ କିନାନ୍‌, ହେୱାନ୍‌ ବିଚାର୍ଣ୍ଣା କିୟାନାନ୍ ");
INSERT INTO peg_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","ମାତର୍‌ ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ଇଞ୍ଜ୍‌ନାଙ୍ଗା, ଇନେର୍‌ ଇମ୍‌ଣି ଟଣ୍ଡେନ୍‌ ଜପି ଟାକ୍ରି ଆନାନ୍‌, ହେୱାନ୍‌ ବିଚାର୍ଣ୍ଣା ବାହାତ ଦାଣ୍ଡ୍‌ ପାୟାନାନ୍‌ । ଆରେ, ଇନେର୍‌ ଜାର୍‌ ଟଣ୍ଡେନିଂ ବକ୍‌ୱା ଇଞ୍ଜି ଇନାନ୍‌, ହେୱାନ୍‌ ଗାଜା ବିଚାର୍ଣ୍ଣାତ ଡାଣ୍ଡ୍‌ପାୟାନାନ୍, ଆରେ ଇନେର୍‌ ନାର୍‍ବକ୍‍ୱା ମୁର୍କିୟା ଇଞ୍ଜି ଇନାନ୍‌, ହେୱାନ୍‌ ନାଣିଡ଼ିଞ୍ଜ୍‌ନିତ ନରକ୍‌ତ ଡାଣ୍ଡ୍‌ ପାୟାନାନ୍ । ");
INSERT INTO peg_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","ଲାଗିଂ, ଇସ୍ୱର୍ତି ବେଦି ଜପି ଗାର୍‌ଣି ଲାଗେ ଏପେଙ୍ଗ୍‌ ଜାର୍‌ ଆକାତ୍‌ ତାସି ମାନି ୱେଡ଼ାଲିଂ ମି ବିରୁଦ୍‌ତ ମି ଟଣ୍ଡେନ୍‌ ଇମ୍‌ଣି କାତା ମାନାତ୍‌ ଇଞ୍ଜି ହେବେ ମାନ୍ତ ଏତୁ ୱାତିସ୍, ");
INSERT INTO peg_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ତା ଆତିସ୍‌ ହେ ବାହାତ ଗାର୍‌ଣି ମୁମ୍‌ଦ ମି ଆକାତ୍‌ ଇଡ଼୍‌ଜି ହାଲାଟ୍‌, ଆଗେ ଜାର୍‌ ଟଣ୍ଡେନ୍‌ ହୁକେ ମେହାଆଡୁ, ଆରେ ତା ପାଚେ ୱାଜ଼ି ମି ଆକାତ୍‌ ହିୟାଟ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“ମି କୁର୍‍ଲିୟା ହୁକେ ହାଜ଼ିତ ମାନି ୱେଡ଼ାଲିଂ ବେଗି ତା ହୁକେ ମେହାଦେଂ ବାବ୍‍ନା ଚଞ୍ଜିୟାଡୁ, ଏଚେକାଡ଼୍‌ଦ କୁର୍‍ଲିୟା ନିଂ ବିଚାର୍‌କାର୍‌ୟା ମିଂ ମେଲ୍ୟାର୍‌ କେଇଦ ହେଲାୟ୍‌ କିଦ୍‌ନାନ୍‌, ଆରେ ବିଚାର୍‌ କାର୍‌ୟା ନିଂ ଜାମାନିର୍ କେଇଦ ହେଲାୟ୍‌ କିଦ୍‌ନାର୍‌, ଆରେ ଏନ୍‌ ଜେଲ୍‌ତ ଗେହ୍ୟାନାୟ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ହାତ୍‌ପା ଇଞ୍ଜ୍‌ନାଙ୍ଗା, ନି ଜପି ମାନି ଜରିମନାନି ଡାବୁଙ୍ଗ୍‌ ପା ହୁଜାୱି ପାତେକ୍‌ ଏପେଙ୍ଗ୍‌ ହେ ବାହାତାଂ ଇନେସ୍‌ ହସିୱାଦେଙ୍ଗ୍ ଆଡୁଦେର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","ଏପେଙ୍ଗ୍‌ ୱେଚାଦେର୍ଣ୍ଣା, ଲେକା ଆତାତ୍‌ନ୍ନା, ଦାରି କିମାଟ୍‌ ନାର୍‌ ଅହ୍‌ମାଟ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","ମାତର୍‌ ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ଇଞ୍ଜ୍‌ନାଙ୍ଗା, ଇନେର୍‌ ଇମ୍‌ଣି କଗ୍‌ଲେତିଂ କାମାୟ୍‌ କାଜିଂ ହୁଡ଼୍‌ତିସ୍‌, ହେୱାନ୍‌ ତା ହୁକେ ମାନ୍‌ତ ମାନ୍‌ତ ଦାରି କିତାନେ । ");
INSERT INTO peg_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","ଆରେ, ଜଦି ମିଙ୍ଗେଙ୍ଗ୍‌ ବାଦା ହିଦ୍‌ନାତା, ଏଚେକାଡ଼୍‌ଦ ମି ବାଦା ଆତିସ୍‌, ଇଚିସ୍‌ ହେ କାଣାଙ୍ଗାତିଂ ଉନ୍ଦ୍‌ଦି ତୁହି ହିୟାଟ୍‌, ଇନାକିଦେଂକି ମି ୱିଜ଼ୁ ଗାଗାଡ଼୍‌ ନରକ୍‌ତ ତୁହିୟାନି ବାଟା ର ପାଡ଼୍‍କା ନସ୍ଟ ଆନାକା ନି ପାକ୍ୟାତ ହାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","ଆରେ ମି ବୁଜ୍‌ଣି କେଇ ମିଦାଙ୍ଗ୍‌ ବାଦା ଆନାତ୍‌, ହେଦେଲିଂ ପା କାଦ୍‌ଦି ତୁହିୟାଟ୍ । ମିଦାଙ୍ଗ୍‌ ୱିଜ଼ୁ ଗାଗାଡ଼୍‌ ନରକ୍‌ତ ତୁହିୟାନି ବାଟା ର କେଇଗାଲ୍‌ ବାଦା ଆନାକା ମି ପାକ୍ୟା ହାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“ଜଦି ଇନେର୍‌ ଜାର୍‌ କଗ୍‌ଲେଂ ପିସ୍ତେଙ୍ଗ୍‌ ମାନ୍‌କିନାନ୍‌, ହେୱାନ୍‌ ତାଙ୍ଗ୍‌ ଲେକା ହୁଦାଂ ର ହେଲ ହିଏନ୍ ଇ ସିକ୍ୟା ଏପେଙ୍ଗ୍‌ ଆଗେତାଂ ପାୟାତାଦେର୍ଣ୍ଣା । ");
INSERT INTO peg_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","ମାତର୍‌ ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ଇଞ୍ଜ୍‌ନାଙ୍ଗା ଜେ, ଜଦି ଇନେର୍‌କି ଜାର୍‌ ଡକ୍ରିଂ ହେଲ ନାଟ୍‍ନାନ୍‍ ହେୱାନ୍‌ ହେଦେଲିଂ ଦାରି କିନି ପାପ୍‌ତ ଦସି ଆନାନ୍‌ । ଜଦି ତା ଡକ୍ରୁହି ବିନ୍‌ ଲକୁ ଲାହାଙ୍ଗ୍‌ ମେହାତିସ୍‍, ତେବେ କେବଲ୍‌ ହେୱାନ୍‌ ହେଦେଲିଂ ହେଲ ନାଟ୍‍ନାନ୍‍ । ଜଦି ଇମ୍‌ଣି ମାନାୟ୍‌ ହେଲ ନାଟ୍‌ୟାତି ହେ କଗ୍‌ଲେଂ ବିବା କିତିସ୍‍ ତେବେ ହେୱାନ୍‌ ପା ଦାରି କାମାୟ୍‌ତ ପାପ୍‍ତ ଦସି ଆନାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“ଆରେ ରଗ, ଏପେଙ୍ଗ୍‌ ୱେଚାଦେର୍ଣ୍ଣା ଜେ, ଆଗେନିକାରିଂ ୱେଚ୍‍ଚି ମାଚାର୍, ଏପେଙ୍ଗ୍‌ ମିଚ୍‌ ପାର୍ମାଣ୍‌ କିମାଟ୍‌, ମତର୍‌ ଜାର୍‌ ପାର୍ମାଣ୍‌ ସବୁ ମାପ୍ରୁତି ତର୍‌ଦ କାମାୟ୍‌ କିନାଦେର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","ମାତର୍‌ ଆନ୍‌ ମିଙ୍ଗ୍‌ ୱେଚ୍‍ଚାନାଙ୍ଗା, ମୁଡ଼୍‌କେ ପାର୍ମାଣ୍‌ କିମାଟ୍‌; ସାର୍ଗେନି ଜିଦ୍‌ କିମାଟ୍‌, ଇନାକିଦେଂକି ହେଦାଂ ଇସ୍ୱର୍ତି ଗାଦି, ");
INSERT INTO peg_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","କି ପୁର୍ତିନି ପାର୍ମାଣ୍‌ କିମାଟ୍‌, ଇନାକିଦେଂକି ହେଦାଂ ହେୱାନ୍ତି ତଗ୍‌ନିବାହା; ଜିରୁସାଲମ୍‌ନି ପାର୍ମାଣ୍‌ କିମାଟ୍‌, ଇନାକିଦେଂକି ହେଦାଂ ଗାଜା ରାଜାତି ଗାଡ଼୍‌; ");
INSERT INTO peg_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","କି ଜାର୍‌ କାପ୍‌ଡ଼ାନି ପାର୍ମାଣ୍‌ କିମାଟ୍‌, ଇନାକିଦେଂକି ହେଦାଂ ନି ର ତେମୁଲ୍‌ ଡ଼ିଚେଂ କି କାର୍ହାୟ୍‍ କିଦେଙ୍ଗ୍‌ ମି ସାକ୍ତି ହିଲୁତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","ମାତର୍‌ ମିଦାଙ୍ଗ୍‌ ଆଁ କାତା ଆଁ ଆୟେତ୍‌, ଆକାୟ୍‌ କାତା ଆକାୟ୍‌ ଆୟେତ୍‌; ଇବେଣ୍ଡାଂ ଇନାକା ଆଦିକ୍‌, ହେଦାଂ ବାନ୍ୟାତାଂ ହନାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“ଏପେଙ୍ଗ୍‌ ୱେଚାଦେର୍ଣ୍ଣା, ଲେକା ମାନାତ୍‌, କାଣ୍‌ଙ୍ଗା ବାଦୁଲ୍‍ତ କାଣ୍‌ଙ୍ଗା ଆରି ଟାଡାଙ୍ଗ୍‌ ବାଦୁଲ୍‍ତ ଟାଡାଙ୍ଗ୍‌; ");
INSERT INTO peg_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","ମାତର୍‌ ଆନ୍‌ ଇଞ୍ଜ୍‌ନାଙ୍ଗା, ଇନେର୍‌ ନିଙ୍ଗେଙ୍ଗ୍‌ ବାନ୍ୟା କିଦ୍‌ନାର୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ବାନ୍ୟା କିମାଟ୍‌ । ଜଦି ନି ବିନ୍‌ ତିନି କୁର୍‌ୱାତ ଇନେର୍‌ ଚାପ୍‌ଡ଼ା ଇଡ଼୍‌ଦାତାର୍‌, ଆରେ ରଞ୍ଜାଙ୍ଗ୍‌ ଚାପ୍‌ଡ଼ା ଇଡ଼୍‌ଦିନି କାଜିଂ ନି ଡେବ୍ରି କୁର୍‌ୱା ପା ଚଚାଟ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","ଜଦି ଇନେର୍‌ ନି ଆଙ୍ଗି ଅନି କାଜିଂ ମି ବିରୁଦ୍‌ତ ନାଡ଼ାଇ କିଜ଼ି ମିଙ୍ଗେଙ୍ଗ୍‌ ବିଚାର୍‌କିନି ତାକେ ଅଜ଼ି ହାଞ୍ଜ୍‌ନାନ୍‌, ତାଙ୍ଗେଙ୍ଗ୍‌ ନି ଆଙ୍ଗି ପା ଦାନ୍‌ କିୟା ।” ");
INSERT INTO peg_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","“ଜଦି ଇମ୍‌ଣି ମେଲ୍ୟା ବିତ୍ରେ ଇନେର୍‌ ନିଙ୍ଗେଙ୍ଗ୍‌ ତା ବଜ୍‌ ପିଣ୍ଡ୍‌ଜି ର କିଲମିଟର୍‌ ହାନି କାଜିଂ ରୁଟ୍‌ତାନାନ୍‌, ହେୱାନ୍‌ ହୁଦାଂ ରି କିଲମିଟର୍‌ ହାଲା । ");
INSERT INTO peg_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","ଇନେର୍‌ ନିଙ୍ଗେଙ୍ଗ୍‌ ଏନ୍ତାନାର୍‌, ତାଙ୍ଗେଙ୍ଗ୍‌ ହିୟାଟ୍‌, ମୁନା କିୱାଦାଂ ତାଙ୍ଗ୍‌ ହିୟା । ଇନେର୍‌ ଇନାକା ମୁକ୍‌ଡ଼ାୟ୍‌ ଏନ୍ତାନାର୍‌ ତାଙ୍ଗ୍‌ ହେଦାଂ ହିୟାଟ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“ହାଙ୍ଗ୍‌ଦାକାରିଂ ଜିଉନୱାଟ୍‌, ସାତ୍ରୁରିଂ ଗିଣ୍‌ କିୟାଟ୍‌ । ଇ ହିକ୍ୟା ଆଗେତାଂ ୱେଚାଦେର୍ଣ୍ଣା । ");
INSERT INTO peg_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","ମାତର୍‌ ଆନ୍‌ ମିଙ୍ଗ୍‌ ଇଞ୍ଜ୍‌ନାଙ୍ଗା, ସାତ୍ରୁରିଂ ଜିଉନୱାଟ୍‌ । ଇମ୍‌ଣାକାର୍‌ ନିଙ୍ଗେଙ୍ଗ୍‌ ନିନ୍ଦା କିଦ୍‌ନାର୍‌, ହେୱାର୍‌ କାଜିଂ ପାର୍ତାନା କିୟାଟ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","ଇଦାଂ କିତିସ୍‌ ସାର୍ଗେନି ଆବା ମାଜ଼ି ଇଞ୍ଜି ଚିନା ଆନାନ୍‌ । ଇନାକିଦେଂକି ଇସ୍ୱର୍‌ ଗାଜା ଆରି ଦାର୍ମି ଆରେ ଅଦାର୍ମି ମାନାୟାରିଂ ୱେଡ଼ା ଅଜଡ଼୍‌ ହିନାନ୍‌ ଆରି ହାର୍‌ କାମାୟ୍‌ ଆରି ବାନ୍ୟା କାମାୟ୍‌ କିନାକାରିଂ ୱିଜ଼ାରିଂ ବାର୍‌ହା ହିନାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","ଆରେ ଇମ୍‌ଣାକାର୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ଜିଉନଦ୍‌ନାର୍‌, ହେୱାରିଂ ଜିଉନତିସ୍‌, ଇସ୍ୱର୍‌ ଇନେକିଦେଂ ନିଙ୍ଗେଙ୍ଗ୍‌ ଇନାମ୍‌ ହିଦ୍‌ନାନ୍‌ ? ସିସ୍ତୁଏନ୍‌ନାକାର୍‌ ପା ହେଦାଂ କିତାର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","“ଆରେ ଏପେଙ୍ଗ୍‌ କେବଲ୍‌ ଜାର୍‌ ଜାର୍‌ ଟଣ୍ଡାରିଂ ଜୱାର୍‌ କିୟାଟ୍‌, ଲାଗିଂ ଏପେଙ୍ଗ୍‌ କି କାବାନି କାମାୟ୍‌ କିନାଦେରା ? ପାର୍ତିକିୱି ଜିହୁଦିର୍‌ ପା ହେଦାଂ କିୱାତାର୍ଣ୍ଣା ? ");
INSERT INTO peg_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","ମି ସାର୍ଗେନି ଆବା ଇନେସ୍‌ ଦାର୍ମି, ଏପେଙ୍ଗ୍‌ ହେ ଲାକେ ଦାର୍ମି ଆନାକା ମାନାତ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","ଲକାରିଂ ଚଚ୍‍ନି କାଜିଂ ହେୱାର୍‌ ମୁମ୍‌ଦ ହାର୍ଦି କାମାୟ୍‌ କିମାଟ୍‌ । ହେଦାଂ କିତିସ୍‌ ସାର୍ଗେନି ଆବା ତାଙ୍ଗ୍‌ ଏପେଙ୍ଗ୍‌ ଇନାମ୍‌ ଗାଟା ଆଉଦେର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“ରକାନ୍‌ ଅର୍କିତ୍‌ ଲକାଂ ଅଲପ୍‍ ଦାନ୍‌ ହିନିହିଂ କାପ୍‌ଟିୟାର୍‌ ଲାକେ ଜାର୍‌ ମୁମ୍‌ଦ ମରି ତୁବ୍‌ମାଟ୍‌ । ହେୱାର୍‌ ପାର୍ତାନା ଇଲ୍‌କୁକାଂ ଆରି ମାଦ୍‍ଣି ପାଟିତ ଜାର୍‌ କାପ୍‌ଟିୟାର୍‌ ଚଚ୍‌ନାର୍‌ । ମାନାୟାର୍‌ତାଂ ଜାଜ୍‌ମାଲ୍‌ ପାୟା ଆନି କାଜିଂ ହେୱାର୍‌ ଇଦାଂ କିତାର୍‌ । ଆନ୍‌ ହାତ୍‌ପା ଇଞ୍ଜ୍‌ନାଙ୍ଗା ଜେ ହେୱାର୍‌ ଇଦାଂ ତାଙ୍ଗ୍‌ ହେୱାର୍‌ତି ଗାଟାନାକା ପୁରା ପାୟାଆତାରେ । ");
INSERT INTO peg_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","ମାତର୍‌ ଏପେଙ୍ଗ୍‌ ଦାନ୍‌ କିନି ୱେଡ଼ାଲିଂ ମି ବୁଜ୍‌ଣି କେଇ ଇନାକା କିନାତା, ହେଦାଂ ମି ଡେବ୍ରି କେଇ ପୁନ୍‍ମେତ୍, ");
INSERT INTO peg_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","ଇନେସ୍‌ ମି ଦାନ୍‌ ଡ଼ୁକ୍‌ଚି ଆନାତ୍‌, ଆରେ ମି ବାୱା ଜେ ଡ଼ୁଗ୍‌ଜି ହୁଡ଼୍‍ଦାନାନ୍, ହେୱାନ୍‌ ଇ ଲାକେ ଇ ଦାନ୍‌ ଡ଼ୁଗ୍‌ଜି ହିଦ୍‌ନାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“ପାର୍ତାନା କିନି ୱେଡ଼ାଲିଂ କାପ୍‌ଟିୟାର୍‌ ଲାକେ ଆମାଟ୍‌, ଇନାକିଦେଂକି ହେୱାର୍‌ ଲକୁ ଚଚ୍‌ନି କାଜିଂ ପାର୍ତାନା ଇଲ୍‌ ଆରି ହାଡ଼ାକ୍‍ ଡେଡ଼ା ବାହାତ ନିଲ୍‌ଚି ପାର୍ତାନା କିଦେଙ୍ଗ୍‌ ୱାରିୟାନାର୍; ଆନ୍‌ ମିଙ୍ଗ୍‌ ହାତ୍‌ପା ଇଞ୍ଜ୍‌ନାଙ୍ଗା, ହେୱାର୍‌ ଜାର୍‌ ଜାର୍‌ ନିଜାର୍‌ତି ଇନାମ୍‌ ଗାଟାତାର୍ଣ୍ଣା । ");
INSERT INTO peg_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","ମାତର୍‌ ଏପେଙ୍ଗ୍‌ ପାର୍ତାନା କିନି ୱେଡ଼ାଲିଂ ଜାର୍‌ ବାକ୍ରା ବିତ୍ରେ ହାଲାଟ୍‌, କାପାଟ୍‌ ଗେହାଟ୍ ଆରି ମି ସାର୍ଗେନି ବାୱା ଇସ୍ୱର୍‌ତିଂ ପାର୍ତାନା କିୟାଟ୍‌ । ଏପେଙ୍ଗ୍‌ ଡ଼ୁଗ୍‌ଜି ଇନାକା କିନାଦେର୍‌, ୱିଜ଼ୁ ହୁଡ଼୍‌ନି ବାୱା ଇସ୍ୱର୍‌ ହେଦାଂ ହୁଡ଼୍‌ଜି ମିଙ୍ଗେଙ୍ଗ୍‌ ଇନାମ୍‌ ହିଦ୍‌ନାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“ଆରେ, ପାର୍ତାନା କିନି ୱେଡ଼ାଲିଂ ପାର୍ତିକିୱି ଜିହୁଦିର୍‌ ଲାକେ ପଲ୍ୟା ଅରତ୍‌ ହିଲ୍‍ୱି ବେଣ୍‌ କିମାଟ୍‌, ଇନାକିଦେଂକି ହେୱାର୍‌ ବେସି କାତା ଇଚିଲେ ହେୱାର୍‌ତି ପାର୍ତାନା ୱେନ୍‍ୟାନାତ୍ ଇଞ୍ଜି ବାବି କିତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","ହେୱାର୍‌ ଲାକେ ଆମାଟ୍‌ । ଏପେଙ୍ଗ୍‌ ଏନ୍‌ନି ଆଗେ ମିଦାଙ୍ଗ୍‌ ଇନାକା ଲଡ଼ା, ମି ସାର୍ଗେନି ବାୱା ହେଦାଂ ୱିଜ଼ୁ ପୁନାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","ଲାଗିଂ ଏପେଙ୍ଗ୍‌ ଇବାନି ପାର୍ତାନା କିନାଦେର୍‌; ଏ ମା ସାର୍ଗେନି ଆବା, ନି ତର୍‌ ପୁଇପୁୟା ଇଞ୍ଜି ମାନି ଆୟେତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","ନି ରାଜି ୱାୟେତ୍‌ । ଇନେସ୍‌ ସାର୍ଗେତ, ହେ ଲାକେ ପୁର୍ତିତ ନି ଇଚା ପୁରାୟେତ୍ । ");
INSERT INTO peg_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","ନେଞ୍ଜେଙ୍ଗ୍‌ ମାଙ୍ଗେଙ୍ଗ୍‌ ଲଡ଼ାନି କାଦି ହିଦା । ");
INSERT INTO peg_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","ଆପେଂ ଇନେସ୍‌ ଜାର୍‌ ଜାର୍‌ ପାପିରିଂ କେମା କିନାପା, ହେ ଲାକେ ମା ପାପ୍‌ ସବୁ କେମା କିଦା । ");
INSERT INTO peg_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","ପରିକ୍ୟାତ ମାଙ୍ଗେଙ୍ଗ୍‌ ତାହି ୱାଦ୍‌ମା, ବାନ୍ୟାତାଂ ରାକ୍ୟା କିଦା । ଲାଗିଂ ରାଜି, ସାକ୍ତି ଆରି ଜୁୱାର୍‌ ଜୁଗ୍‌ ଜୁଗ୍‌ ନିନ୍ଦାଂ । ଆମେନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“ଏଚେକାଡ଼୍‌ଦ ମାନାୟାର୍‌ତି ପାପ୍‌ ସବୁ କେମା କିନାଦେର୍‌, ତେବେ ମିଦାଙ୍ଗ୍‌ ସାର୍ଗେନି ବାୱା ମିଙ୍ଗେଙ୍ଗ୍‌ ପା କେମା କିଦ୍‌ନାନ୍‌; ");
INSERT INTO peg_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","ମାତର୍‌ ଏଚେକାଡ଼୍‌ଦ ଲକାରିଂ କେମା କିୱିତିସ୍‌, ତେବେ ମି ସାର୍ଗେନି ଆବା ପା ମିଙ୍ଗେଙ୍ଗ୍‌ ପାପ୍‌ ସବୁ କେମା କିଦୁନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“ଉପାସ୍‌ କିନି ୱେଡ଼ାଲିଂ କାପ୍‌ଟିୟାର୍‌ ଲାକେ ମୁମ୍‍ରାତ୍‍ମାଟ୍, ଇନାକିଦେଂକି ହେୱାର୍‌ ଉପାସ୍‌ କିନାରା ଇଞ୍ଜି ଲକାର୍‍ ମୁମ୍‌ଦ ହୁଡ଼୍‍ୟାନି କାଜିଂ ଜାର୍‌ ଜାର୍‌ ମୁମ୍‌ଦିଂ ରାତ୍‌ନାର୍; ଆନ୍‌ ମିଙ୍ଗ୍‌ ହାତ୍‌ପା ଇଞ୍ଜ୍‌ନାଙ୍ଗା, ହେୱାର୍‌ ଜାର୍‌ ଜାର୍‌ ଇନାମ୍‌ ଗାଟାତାର୍ଣ୍ଣା । ");
INSERT INTO peg_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","ମାତର୍‌ ଏପେଙ୍ଗ୍‌ ଉପାସ୍‌ କିନି ୱେଡ଼ାଲିଂ ଏପେଙ୍ଗ୍‌ ମୁମ୍‌ ଉରାଟ୍‌ ଆରି ମି କାପ୍‌ଡ଼ାତ ଚିକାଣ୍‌ ଉଚାଟ୍, ");
INSERT INTO peg_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","ଇନେସ୍‌ ଏପେଙ୍ଗ୍‌ ଉପାସ୍‌ କିନାଦେରା ଇଞ୍ଜି ଲକାର୍‍ ମୁମ୍‌ଦ ହୁଡ଼୍‍ୟାୱାଦାଂ ଡ଼ୁଗ୍‌ଜି ମାନି ବାୱାତି ମୁମ୍‌ଦ ହୁଡ଼୍‍ୟାନାଦେର୍; ଆରେ, ମି ବାୱା ଜେ ଡ଼ୁଗ୍‌ଜି ହୁଡ଼୍‍ଦାନାନ୍, ହେୱାନ୍‌ ମିଙ୍ଗ୍‌ ପାଡ଼୍‌ ହିଦ୍‌ନାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“ଇମେତାକେ ପ୍ଡି ଆରି ଲିମ୍‌ ତିନାତ୍‌ ପ୍ରାଲ୍‌ ଜିରାୟ୍‌ କିନାତ୍‌, ଆରେ ଚର୍କୁ ଇଲ୍‌ ଚରି କିତାର୍‌, ଏଲେଙ୍ଗ୍‌ବାର୍ତି ପୁର୍ତିତ ଜାର୍‌ ଜାର୍‌ କାଜିଂ ଦାନ୍‌ ରୁଣ୍ଡାୟ୍‌ କିମାଟ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","ମାତର୍‌ ଇମେତାକେ ପ୍ଡିକୁ ଆରି ପ୍ରାଲ୍‌ ନସ୍ଟ କିଉତ୍‌ ଆରି ଚର୍‌କୁ ହଣ୍‌ଜି ଦାନ୍‌ ଚର୍‌ ଅଦେଂ ଆଡୁର୍‌ । ଏଲେଙ୍ଗ୍‌ ସାର୍ଗେତ ଜାର୍‌ ଜାର୍‌ କାଜିଂ ଦାନ୍‌ ଆର୍ଜା ଆଡ, ");
INSERT INTO peg_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","ଇନାକିଦେଂକି ଇମେତାକେ ମିଦାଙ୍ଗ୍‌ ଦାନ୍‌ ହେବେ ପା ମିଙ୍ଗେଙ୍ଗ୍‌ ମାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“କାଣ୍‌କୁ ଗାଗାଡ଼୍‌ନି ଅଜଡ଼୍‌ ଲାକେ । ଏଚେକାଡ଼୍‌ଦ ମି କାଣ୍‌କୁ ଅଣ୍ଡାଙ୍ଗ୍‌ ମାଚିସ୍‌, ହେ ପାଦ୍‌ନା ମି ୱିଜ଼ୁ ଗାଗାଡ଼୍‌ ପା ଅଜଡ଼୍‌ ଲାକେ ଆନାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","ମାତର୍‌ କାଣ୍‌କୁ ଜଦି ବାନ୍ୟା ଆନିକ୍‌, ଗାଗାଡ଼୍‌ନି ମାଜ୍‌ଗା ଆନାତ୍‌ । ମି ୱାସ୍‌କିନି ଅଜଡ଼୍‌ ଜଦି ମାଜ୍‌ଗା ଆନାତ୍‌, ତେବେ ଏଚେକ୍‌ ମାଜ୍‌ଗା ବଇଁକାର୍‌ ମାଜ୍‌ଗା ଆନାତ୍‌ !” ");
INSERT INTO peg_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“ରକାନ୍‌ ମାନାୟ୍‌ ରି ମାପ୍ରୁତି ଆଡ଼ିଏନ୍‌ ଆଦେଂ ଆଡୁନ୍‌; ଇନାକିଦେଂକି ହେୱାନ୍‌ ରକାନିଂ ଗିଣ୍‌ କିନାନ୍‌ ଆରି ବିନ୍‌ ଲଗାଂ ଜିଉନନାନ୍, ଆୱିତିସ୍‌ ରକାନ୍‌ ପାଚେ ହାନାନ୍ ଆରି ବିନ୍‌ ନିକାନିଂ ମାନିକିଉନ୍‌ । ଏପେଙ୍ଗ୍‌ ଇସ୍ୱର୍‌ ଆରି ଦାନ୍‌, ରିୟାର୍‌ତି ଆଡ଼ିଏନ୍‌ ଆଦେଂ ଆଡୁନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“ଇଦାଂ କାଜିଂ ଆନ୍‌ ମିଙ୍ଗ୍‌ ଇଞ୍ଜ୍‌ନାଙ୍ଗା, ଇନାକା ତିନାଦେର୍‌ କି ଇନାକା ଉଣାଦେର୍‌, ଏପେଙ୍ଗ୍‌ ଏତୁ କିଜ଼ି ମି ଜିବୁନ୍‌ କାଜିଂ, କି ଇନାକା ଉସ୍‌ପାନାଙ୍ଗ୍‌, ଏପେଙ୍ଗ୍‌ ଏତୁ କିଜ଼ି ମି ଗାଗାଡ଼୍‌ କାଜିଂ ପା ଚିନ୍ତା କିମାଟ୍‌ । ତିନାଉଣାତାଂ ଜିବୁନ୍‌ ଆରି ହେନ୍ଦ୍ରାଙ୍ଗ୍‌ ତାଂ ଗାଗାଡ଼୍‌ କି ଗାଜା ଆକାୟ୍‌ ? ");
INSERT INTO peg_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","ପଟିକାଂ ହୁଡ଼ାଟ୍‌, ହେୱେକ୍‌ ୱିତୁକ୍‌ କି ତ୍ରେସୁକ୍‌ପା । ତାସ୍‌ ତ୍ରେଜ଼ି ଟୁଣ୍ଡିତ ରୁଣ୍ଡାୟ୍‌ କିଜ଼ି ଇଟୁକ୍ । ମି ସାର୍ଗେନି ଆବା ଇସ୍ୱର୍‌ ହେୱାକାଂ ଜତନ୍‌ କିଜ଼ି କାଦି ହିନାନ୍‌ । ଏପେଙ୍ଗ୍‌ ଇନାକା ପଟିଂତାଂ ଗାଜା ଆକାୟ୍‌ ? ");
INSERT INTO peg_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","ଆରେ, ମି ବିତ୍ରେ ଇନେର୍‌ ଚିନ୍ତା କିଜ଼ି ଜାର୍‌ ଆଁଇସ୍‌ ଦାପ୍ରେ ବାଡାୟ୍‌ କିଦେଙ୍ଗ୍‌ ଆଡ୍‌ନାନ୍‌ ?” ");
INSERT INTO peg_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“ଆରେ ହେନ୍ଦ୍ରାଙ୍ଗ୍‌ କାଜିଂ ଇନେକିଦେଂ ଚିନ୍ତା କିନାଦେରା ? ବାଟାନି ପୁଇକୁ ବିସ୍ରେ ଏତ୍‌ କିଜ଼ି ହିକ୍ୟା ମାନି କିୟାଟ୍‌, ହେୱାଙ୍ଗ୍‌ ଇନେସ୍‌ ଗାଜାନିଂ; ହେୱାଙ୍ଗ୍‌ ସବୁ କସ୍ଟ କିଉକ୍‌, କି ନୁଲ୍‌ ଡ଼ଚୁକ୍‌, ");
INSERT INTO peg_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ଇଞ୍ଜ୍‌ନାଙ୍ଗା, ସଲମନ୍‌ ପା ଜାର୍‌ତି ୱିଜ଼ୁ ହଲ୍‌ନାକାତ ଇୱାଙ୍ଗ୍‌ ବିତ୍ରେ ରଞ୍ଜାଙ୍ଗ୍‌ ଲାକେ ଉସ୍‌ପାୱାଦାଂ ମାଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","ମାତର୍‌ ଇମ୍‌ଣି କାଚ୍ରା ନେଜେଙ୍ଗ୍‌ ବାଡ଼୍‌ଦ ମାନାତ୍‌, ଆରି ୱିଗାଲିଙ୍ଗ୍‌ ହଲ୍‌ଦ ଦେହିୟା ଆନାତ୍‌, ତାଙ୍ଗେଙ୍ଗ୍‌ ଇନାୱାଡ଼ାଂ ଇସ୍ୱର୍‌ ଇ ଲାକେ ବେସ୍‌ କିଦ୍‍ନାନ୍‌, ଲାଗିଂ, ହେ ଅଲପ୍‍ ପାର୍ତି କିନାଦେର୍‌, ହେୱାନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ କି ଆଦିକ୍‌ ହାତ୍‌ପା ହେନ୍ଦ୍ରାପାଟା ହିଦୁନ୍‌ !” ");
INSERT INTO peg_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“ଲାଗିଂ ଇନାକା ତିନାକା ଇନାକା ଉଣାକା କି ଇନାକା ଉସ୍ପାନାକା ଇଦାଂ ଇଞ୍ଜି ମାନ୍‌ ଦୁକ୍‌ କିମାଟ୍‍ ? ");
INSERT INTO peg_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","ଇନେକିଦେଂକି ପାର୍ତିକିୱି ଜିହୁଦିର୍‌ ଇ ସବୁ ବିସ୍ରେ ଦାସ୍ତି ବୁଲାନାର୍‌ । ଆରେ ଇ ସବୁ ବିସ୍ରେ ଇନେନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ଲଡ଼ା, ହେଦାଂ ମିଦାଂ ସାର୍ଗେନି ଆବା ପୁଞ୍ଜ୍‌ନାନ୍‍ । ");
INSERT INTO peg_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","ମାତର୍‌ ଏପେଙ୍ଗ୍‌ ପର୍ତୁମ୍‌ ଇସ୍ୱର୍‌ ରାଜି ଆରି ଦାର୍ମି ଡେକାଟ୍‌, ଆରେ ଇ ୱିଜ଼ୁ ବିସ୍ରେ ପା ମିଙ୍ଗେଙ୍ଗ୍‌ ହିଦ୍‌ନାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","ସବୁ ନାଜିଂ ନି ହାବଡ଼୍‌ ନିତ୍ରେ କାଜିଂ ଇଞ୍ଜି ଲଡ଼ା ଆଏତ୍‌ ଏଚେକ୍‌ ସାରି । ବିପ୍ତି ଆମାଟ୍‌ । ୱିଗାନି ଚିନ୍ତା ୱିଗା କିନାଦେର୍‌ । ୱିଗାମାହିଙ୍ଗ୍‌ ବିସ୍ରେ ଚିନ୍ତା କିଜ଼ି ନେଜେଙ୍ଗ୍‌ନି ବିପ୍ତିତିଂ ଲାମାୟ୍‌ କିମାଟ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“ଏପେଙ୍ଗ୍‌ ଇନେସ୍‌ ବିଚାର୍‌କିୟା ଆଉଦେର୍‌, ଇଦାଂ କାଜିଂ ବିଚାର୍‌ କିମାଟ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","ଇନେକିଦେଂକି ଇମ୍‌ଣି ବିଚାର୍‌ତ ବିଚାର୍‌ କିନାଦେର୍‌, ହେ ବିଚାର୍‌ତ ଏପେଙ୍ଗ୍‌ ବିଚାର୍‌ କିୟାନାଦେର୍‌; ଆରେ ଇମ୍‌ଣି ମାଣ୍‌ଦ ଲାଚ୍‌ନାସ୍‌, ହେ ମାଣ୍‌ତାଂ ମିଙ୍ଗେଙ୍ଗ୍‌ ମାଣ୍‌ଦାଂ ହିଦ୍‌ୟା ଆନାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","ନି କାଣ୍‌ଙ୍ଗାତ ୱେଜ଼୍‌ଗୁ ଗାତ୍ରା ମାନିହିଂ ନି ଟଣ୍ଡେନ୍‌ କାଣ୍‌ଙ୍ଗାତ ହାରୁ ଗାତ୍ରା ଇନେକିଦେଂ ଦିୟାନ୍‌ କିନାୟା ? ");
INSERT INTO peg_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","ଜାର୍‌ କାଣ୍‌ଙ୍ଗାତ ୱେଜ଼୍‌ଗୁ ଗାତ୍ରା ମାନୁ ମାନୁ ଏନ୍‌ ଇମ୍‌ଣି ସାସ୍ତର୍‌ତାଂ ନି ଟଣ୍ଡେନ୍‌ କାଣ୍‌ଙ୍ଗାତାଂ ଦୁଡ଼ି ହପ୍‌ଚି ହିଦ୍‌ନାଂ ଇଞ୍ଜି ଇନାୟା ? ");
INSERT INTO peg_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","କାପ୍‌ଟିୟାର୍‌ ! ନି କାଣ୍‌ଗାନି ୱେଜ଼୍‌ଗୁ ଗାତ୍ରା ପର୍ତୁମ୍‌ ହପ୍‌ୟା । ତା ଆତିସ୍‌ ନି ଟଣ୍ଡେନ୍‌ କାଣ୍‌ଙ୍ଗାତ ଆର୍ଜି ମାନି ଦୁଡ଼ି ଏନ୍‌ ଆଡ଼୍‌ୱା ହୁଡ଼୍‌ଦେଂ ଆଡ୍‌ନାୟ୍‌ । ଆରି ହୁଡ଼୍‌ଦେଂ ଆଡ୍‌ନାଦେର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“ନିକୁଡ଼ିକାଂ ପୁଇପୁୟା ଜିନିସ୍‌ ହିମାଟ୍‌ । ଇନାକିଦେଂକି ହେଦାଂ ମାସ୍‌ଦି ନିଙ୍ଗେଙ୍ଗ୍‌ କାପ୍‌ତେଦେଂ ଆଡ଼୍‌ଦାନାତ୍‌ । ପାଞ୍ଜି ମୁମ୍‌ଦ ମୁକ୍ତା ତୁହି ହିମାଟ୍‌ । ତା ଦାମ୍‌ ବୁଜାୱାଦାଂ ହେଦେଲିଂ ହେଦାଂ କେବଲ୍‌ ପାନାତ କୁହ୍‌ନାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","ଏନା, ତା ଆତିସ୍‌ ନିଙ୍ଗେଙ୍ଗ୍‌ ହିଦ୍‌ନାତ୍; ଦାହା, ପାୟା ଆନାୟ୍‌; ଦୁୱେର୍‌ତ ଇଡ଼ା, ଦୁୱେର୍‌ ଜେୟାନାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","ଇମ୍‌ଣାକାନ୍‌ ଏନ୍‌ନାନ୍‌, ତାଙ୍ଗେଙ୍ଗ୍‌ ହିୟାନାତ୍‌; ଇନେନ୍‌ ଦାହ୍‌ନାନ୍‌, ହେୱାନ୍‌ ଗାଟାନାନ୍‌; ଇନେନ୍‌ ଦୁୱେର୍‌ତ ଇଡ଼୍‌ନାନ୍‌, ତା କାଜିଂ ଦୁୱେର୍‌ ଜେସି ହିୟା ଆନାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","ମି ବିତ୍ରେ ଏପେଙ୍ଗ୍‌ ଆବା ଇନେନ୍‌ ମାନାନ୍‌, ଇନେରିଂ ଜାର୍‌ ମାଜ଼ି ମିନ୍‌ ଏନ୍ତିସ୍‌ ହେୱାନ୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ମିନ୍‌ ବାଦୁଲ୍‌ ରାଚ୍‌ ହିନାନ୍‌, ତାଙ୍ଗେଙ୍ଗ୍‌ ଇନାକା କାଲ୍‌କୁ ହିନାୟ୍‌ ");
INSERT INTO peg_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","କି ହେୱାନ୍‌ ମିନ୍‌କୁ ଏନ୍ତିତିସ୍‌ ତାଙ୍ଗ୍‌ ଇନାକା ଏନ୍‌ ରାଚ୍‌ ହିନାୟ୍‌ ? ");
INSERT INTO peg_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","ଲାଗିଂ ଏପେଙ୍ଗ୍‌ ଚୁଲ୍‌ଚୁଲିୟା ଆତିସ୍‌ ପା ଏଚେକାଡ଼୍‌ଦ ଜାର୍‌ ଜାର୍‌ କାଡ଼୍‌ଦେରିଂ ହାର୍ଦି ହାର୍ଦି ଦାନ୍‌ ହିଦେଂ ପୁନାଦେର୍‌, ତେବେ ମି ସାର୍ଗେନି ଆବା ତା ମୁମ୍‌ଦ ଏନ୍‌ନାକା ମାନାୟାରିଂ କେତେକ୍‌ ଆଦିକ୍‌ ହାର୍ଦି ହାର୍ଦି ଜିନିସ୍‌ ହିଉନ୍‌ ?” ");
INSERT INTO peg_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","ଲାଗିଂ ମାନାୟାର୍‌ “ମି କାଜିଂ ଇନାକା ସବୁ କିନାର୍‌ ଇଞ୍ଜି ଇଚା କିନାଦେର୍‌, ଏପେଙ୍ଗ୍‌ ପା ହେୱାର୍‌ କାଜିଂ ହେ ଲାକେ କିୟାଟ୍‌, ଇନେକିଦେଂକି ଇଦାଂ ନେ ମସାତି ବିଦି ଆରି ବେଣ୍‌ବାକ୍‌ଣାୟ୍‌ କିନାକାର୍‌ତି ଦରମ୍‌ ସାସ୍ତର୍‌ ହିକ୍ୟାନି ହାତ୍‌ପା ଅରତ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“ହିରୁ ଦୁୱେର୍‌ତିଂ ହଣ୍ଡେଙ୍ଗ୍‌ କସ୍ଟକିୟାଟ୍‌ । ଇନେକିଦେଂକି ନାସ୍‌ କିଦେଙ୍ଗ୍‌ ଅସି ହାନି ହୁକେ ଓହାର୍‌ ଆରି ହାଜ଼ି ଓହାର୍‌, ଆରେ ହେଦାଂ ହିଜ଼ି ହଣ୍‌ଗାନାକାର୍‌ ହେନି । ");
INSERT INTO peg_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","ମାତର୍‌ ୱିଜ଼୍‌ୱି ଜିବୁନ୍‌ତିଂ ଅନି ହାଜ଼ି ବାନ୍ୟା ଆରି ତା ଦୁୱେର୍‌ ଚିପା ଆରେ ଅଲପ୍‍ ମାନାୟ୍‌ ଇ ହାଜ଼ି ଦାସ୍‌ତେଂ ଆଡ୍‌ନାର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“ଚାକ୍ରାୟ୍‌ ବେଣ୍‌ବାକ୍‌ଣାୟ୍‌କିନାକାର୍‌ ତାଙ୍ଗ୍‌ ଜାଗ୍ରତ୍‌ ! ହେୱାର୍‌ ବାର୍ତ ମେଣ୍ଡା ଲାକେ ଚଞ୍ଜାନାର୍‌, ମାତର୍‌ ହାତ୍‌ପା ହେୱାର୍‌ ରଞ୍ଜାଙ୍ଗ୍‌ ରଞ୍ଜାଙ୍ଗ୍‌ ହୁଣ୍ଡାର୍‌ ବୁର୍କା । ");
INSERT INTO peg_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","ହେୱାର୍‌ତି ପାଡ଼୍‌ ହୁକେ ଏପେଙ୍ଗ୍‌ ହେୱାରିଂ ଚିନ୍‌ କିନାଦେର୍‌ । ୱାଡ଼ି ମାର୍‌ତ ଅଙ୍ଗୁର୍‌ପାଡ଼୍‌ ଆହୁତ୍‌ କି ଲେକାଜାମୁ ମାର୍‌ତ ତଗା ପାଡ଼୍‌ ଆହୁତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","ହାର୍ଦି ମାରତ ହାର୍ଦି ପାଡ଼୍‌ ଆହ୍‌ନାତ୍‌ । ବାନିୟାଁ ମାର୍‌ତିନି ପାଡ଼୍‌ ବାନିୟାଁ । ");
INSERT INTO peg_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","ହାର୍ଦି ମାର୍‌ତ ବାନିୟାଁ ପାଡ଼୍‌ ଆହୁତ୍‌ କି ବାନିୟାଁ ମାର୍‌ତିନି ପାଡ଼୍‌ ହାର୍‌ ଆଦେଂ ଆଡୁତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","ହାର୍ଦି ପାଡ଼୍‌ ଆହ୍‌ୱିତିସ୍‌ ମାର୍‌ତିଂ କାଦ୍‌ଦି ନାଣିତାକେ ଦେହ୍‌ନାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","ଲାଗିଂ ହେୱାର୍‌ତି ପାଡ଼୍‌ ହୁକେ ଏପେଙ୍ଗ୍‌ ହେୱାରିଂ ଚିନ୍‌ କିନାଦେର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“ଇମ୍‌ଣାକାର୍‌ ନାଙ୍ଗେଙ୍ଗ୍‌ ମାପ୍ରୁ ମାପ୍ରୁ ଇଞ୍ଜି କୁକ୍ତାନାର୍‌, ହେୱାର୍‌ ବିତ୍ରେ ୱିଜ଼ାର୍‌ ସାର୍ଗେ ରାଜିତ ହଣ୍ଡେଙ୍ଗ୍‌ ଆଡୁର୍‌ । ଇମ୍‌ଣାକାର୍‌ ସାର୍ଗେନି ଆବା ଇସ୍ୱର୍ତି ଇଚା ହୁକେ କାମାୟ୍‌ କିତାର୍‌, କେବଲ୍‌ ହେୱାର୍‌ ସାର୍ଗେ ରାଜିତ ହଣ୍ଡେଙ୍ଗ୍‌ ଆଡ୍‌ନାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","ଗାଜା ବିଚାର୍‌ ଦିନ୍‌ ଏକାୱାତିସ୍‌ ହେନି ନାଙ୍ଗେଙ୍ଗ୍‌ ଇଞ୍ଜ୍‌ନାର୍‌, ମାପ୍ରୁ ନି ତର୍‌ଦାଂ ଆପେଂ ଇନାକା ଇସ୍ୱର୍ତି ନେକ୍ରି କାବୁର୍‌ ସୁଣାୟ୍‌ କିନାପା, ମାପ୍ରୁ, ନି ତର୍‌ନି ସାକ୍ତିତାଂ ବୁତ୍‌ ପିହିକିତାପ୍‌ନା ଆରେ ବେସି କାବାଆନି କାମାୟ୍‌ କିତାପ୍‌ନ୍ନା । ");
INSERT INTO peg_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","ହେ ପାଦ୍‌ନା ହେୱାରିଂ ଆନ୍‌ ଇନାଙ୍ଗ୍‌, ମିଙ୍ଗେଙ୍ଗ୍‌ ଆନ୍‌ ପୁଞ୍ଜୁଙ୍ଗ୍‌ । ବାନ୍ୟାକାଦେର୍‌, ନା ଲାଗାଂତାଂ ଗୁଚା ଆଡ !” ");
INSERT INTO peg_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“ଇନେନ୍‌ ନା କାତା ୱେନ୍‌ଞ୍ଜି ପାଲି କିନାନ୍‌, ହେୱାନ୍‌ ଚେଚ୍‌ରା କାଲ୍‌ ଜପି ଇଲ୍‌ ରଚ୍‍ନି ବୁଦିକାର୍‌ୟା ମାନାୟ୍‌ ଲାକେ । ");
INSERT INTO peg_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","ଅପ୍ରବଲ୍‌ ବାର୍‌ହା ଆତାତ୍‌, ନାଗୁଡ଼୍‌ ଏଜ଼ୁଂ ବାନ୍ଦ୍‌ ଜପି ଡ଼ିତାତ୍‌ ଆରି ହେ ଇଲ୍‌ ଜପି ଅପ୍ରବଲ୍‌ ଡ଼ୁଇ ଆତାତ୍‌, ମାତର୍‌ ହେ ଇଲ୍‌ ବାହ୍‌ଡ଼ା ୱାତାତ୍‌ ଇନାକିଦେଂକି ହେଦାଂ ଚେଚ୍‌ରା ଜପି ମୁଡ଼୍‌ କୁନାଦି ମାଚାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","ମାତର୍‌ ଇମ୍‌ଣାକାର୍‌ ନା କାତା ୱେନ୍‌ଞ୍ଜି ପାଲି କିଉର୍‌, ହେୱାର୍‌ ବାଲି ଜପି ଇଲ୍‌ ରଚ୍‌ଚି ମାଚି ଟେପ୍‌ରିୟା ଲାକେ । ");
INSERT INTO peg_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","ବେସି ବାର୍‌ହା ଆତାତ୍‌, ନାଗୁଡ଼୍‌ ଏଜ଼ୁଂ ଏକିତିକ୍‌ । ଅପ୍ରବଲ୍‌ ଡ଼ୁଇ ଆତାତ୍‌ ଆରି ଇଲ୍‌ ମେଦ୍‌ନିତ ମେହାଆତାତ୍‌ । ହେଦାଂ କେତେକ୍‌ ବଇଁକାର୍‌ ଆତାତ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","ୱିଜ଼୍‌ନି ପାତେକ୍‌ ଜିସୁତି ଇ ୱିଜ଼ୁ କାତା ୱେନ୍‌ଞ୍ଜି ମାନାୟାର୍‌ ତା ହିକ୍ୟାତ କାବା ଆତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","ହେୱାନ୍‌ ବିନ୍‌ବିନ୍‌ନିକାର୍‌ ଦରମ୍‌ ଗୁରୁରିଂ ଲାକେ ହିକ୍ୟା ହିୱାଦାଂ ଆଦିକାର୍‌ ପାୟାତି ମାନାୟ୍‌ ଲାକେ ହିକ୍ୟା ହିଜ଼ି ମାଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","ଜିସୁ ମାଡ଼ି ଜପିତାଂ ଜୁତ୍‌ତି ପାଚେ ବେସି ମାନାୟ୍‌ ତା ପାଚେ ପାଚେ ୱାତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","ତା ପାଚେ ଆରେ ହୁଡ଼ା, ରୱାନ୍‌ ଗାଜା ରଗ୍ୟାଙ୍ଗ୍‌ ତା ତାକେ ୱାଜ଼ି ଜୱାର୍‌ କିଜ଼ି ଇଚାନ୍‌, “ଏ ମାପ୍ରୁ, ଏନ୍‌ ଜଦି ଇଚା କିତାୟ୍‌ଚି, ତା ଆତିସ୍‌ ନାଙ୍ଗେଙ୍ଗ୍‌ ସକଟ୍‌ କିଦ୍‌ଦେଂ ଆଡ଼୍‌ଦାନାୟ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","ହେବେ ଜିସୁ କେଇ ଇଡ଼୍‌ଜି ତାଙ୍ଗେଙ୍ଗ୍‌ ଡୁଜ଼ି ଇଚାନ୍‌, “ଆନ୍‌ ଇଚା କିନାଙ୍ଗା, ସକଟ୍‌ ଆ ।” ହେ ଦାପ୍ରେ ହେ ଗାଜାରଗ୍‌ “ସକଟ୍‌ ଆତାତ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","ଆରେ, ଜିସୁ ତାଙ୍ଗେଙ୍ଗ୍‌ ଇଚାନ୍‌, “ୱେନା, ଏନ୍‌ ଇନେସ୍‌ ଆଜ଼ି ଉଜ୍‌ ଆତାୟ୍‌, ଇନେରିଂ ୱେଚ୍‌ମା, ମାତର୍‌ ହାଲା, ମାପ୍ରୁହେବାକିନାକାନିଂ ଚଞ୍ଜ୍‌ୟା, ଆରେ ମସା ଇମ୍‌ଣି ଆକାତ୍‌ଗାର୍‌ଣି ବିସ୍ରେ ବଲ୍‌ ହିତ୍‌ନ୍ନା, ହେଦାଂ ହେୱାର୍‌ ଲାଗାଂ ଏନ୍‌ ଉଜ୍‌ ଆତାଙ୍ଗ୍‌ନା ଇଞ୍ଜି ସାକି ହିୟା ।” ");
INSERT INTO peg_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","ଜିସୁ କପର୍ନାହୁମ୍‌ ବସ୍ତିତ ହଣ୍‌ଗିତିଲେ, ର ମୁଡ଼୍‌ମେଲ୍ୟା ତା କଚଣ୍‌ତ ୱାଜ଼ି ଗୱାରି କିଜ଼ି ଇଚାନ୍‌, ");
INSERT INTO peg_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“ଏ ମାପ୍ରୁ ନା ଆଡ଼ିଏନ୍‌ ହିର୍‌କଲ୍‌ ଇଡ଼୍‌ୟାତି ରଗି ବେସି ନନାକାଦିଂ ଇଞ୍ଜ ମାକ୍‌ତାନ୍‌ନା ।” ");
INSERT INTO peg_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","ଜିସୁ ତାଙ୍ଗେଙ୍ଗ୍‌ ଇଚାନ୍‌, “ଆନ୍‌ ହାଲ୍‌ଜି ତାଙ୍ଗେଙ୍ଗ୍‌ ଉଜ୍‌ କିନାଙ୍ଗ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","“ମୁଡ଼୍‌ମେଲ୍ୟା” ଉତର୍‌ ହିତାନ୍‌, ମାପ୍ରୁ, “ଏନ୍‌ ଜେ ନା ଇଞ୍ଜ କାଲ୍‌ ତଗ୍‌ନାୟ୍‌, ଆନ୍‌ ଏଲେଙ୍ଗ୍‌ ଆକାୟ୍‌; ମାତର୍‌ କେବଲ୍‌ ପାଦେକ୍‌ ବଲ୍‌ ହିଦା, ନା ଆଡ଼ିଏନ୍‌ ଉଜ୍‌ ଆନାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","ଇନାକିଦେଂକି ଆନ୍‌ ରୱାନ୍‌ ତାରେନ୍‌ ମାନାଙ୍ଗ୍‌ ଆତିସ୍‌ ପାନା ତାରେନ୍‌ ମେଲ୍ୟାର୍‌ ମାନାର୍‌; ଆନ୍‌ ରୱାନିଂ ଆଦିକାର୍‌ ହିତିସ୍‌ ହେୱାନ୍‌ ହାନାନ୍; ଆରେ ରୱାନିଂ ୱା ଇଚିସ୍‌ ହେୱାନ୍‌ ୱାନାନ୍‌; ଆରେ ନା ହଲ୍ୟାଙ୍ଗ୍‌ ଇଦାଂ କିୟା ଇଚିସ୍‌ ହେୱାନ୍‌ ହେଦାଂ କିନାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","ଜିସୁ ଇଦାଂ ୱେନ୍‌ଞ୍ଜି କାବା ଆଜ଼ି ପାଚେ ୱାନି ମାନାୟାରିଂ ଇଚାନ୍‌, “ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ହାତ୍‌ପା ଇଞ୍ଜ୍‌ନାଙ୍ଗା, ଇସ୍ରାଏଲ୍‌ ବିତ୍ରେ ଇନେର୍‌ ତାକେ ଏଚେକ୍‌ ଗାଜା ପାର୍ତି ପାୟାୱାତାଂନା । ");
INSERT INTO peg_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","ମାତର୍‌ ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ଇଞ୍ଜ୍‌ନାଙ୍ଗା, ବେସି ୱେଡ଼ାହତ୍‌ନି ବାଗାଙ୍ଗ୍‌ ଆରି ୱେଡ଼ାହାନି ବାଗାଙ୍ଗ୍‌ ୱାଜ଼ି ଅବ୍ରାହାମ୍‌, ଇସ୍‌ହାକ୍‌ ଆରି ଜାକୁବ୍‌ ଲାହାଙ୍ଗ୍‌ ସାର୍ଗେ ରାଜିତ ବଜି ଚିଞ୍ଜେଙ୍ଗ୍‌ କୁଚ୍‌ନାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","ମାତର୍‌ ଇମ୍‌ଣାକାର୍‌ ଇ ରାଜିତ ମାନି କାତା ହେୱାରିଂ ବାର୍ତ ମାଜ୍‌ଗାତ ତୁହିୟା ଆନାର୍‌; ହେବେ ଆଡ଼୍‌ବିସ୍‌ ଆରି ଟାଡାଙ୍ଗ୍ କାଟ୍‌ନାର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","ଆରେ ଜିସୁ ପାଞ୍ଚ୍‌କଡ଼ି ମେଲ୍ୟାଙ୍ଗ୍‌ ଇଚାନ୍‌, “ହାଲା ଏନ୍‌ ଇନେସ୍‌ କିଜ଼ି ପାର୍ତି କିନାୟା, ନି କାଜିଂ ହେ ଲାକେ ଗିଟାଆୟେତ୍‌ ।” ହେ ଡାଣ୍ଡ୍‌ତ ଆଡ଼ିଏନ୍‌ ଉଜ୍‌ ଆତାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","ପାଚେ ଜିସୁ ପିତର୍‌ ଇଞ୍ଜ ୱାଜ଼ି ତା ପଦାହିଙ୍ଗ୍‌ ନମେର୍‌ ଆଜ଼ି ମାଗ୍‌ଜି ମାନାକା ହୁଡ଼୍‌ତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","ହେବେ ହେୱାନ୍‌ ତା କେଇଦ ଡୁତାନ୍‌, ଆରେ ତାଙ୍ଗେଙ୍ଗ୍‌ ନମେର୍‌ ପିସ୍ତାତ୍‌, ପାଚେ ହେଦେଲ୍‌ ନିଙ୍ଗ୍‌ଜି ହେୱାରିଂ ହେବା କିଦେଙ୍ଗ୍‌ ଲାଗାତାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","ମ୍ଡିକାହାରେସ୍‌, ମାନାୟାର୍‌ ହେନି ପୁଦା ଡୁୟାଆତି ଲଗାଂ ଜିସୁ କଚଣ୍‌ତ ତାହିୱାତାର୍‌, ହେବେ ଜିସୁ ୱେଇକିତି ମାତର୍‌ ପୁଦାଂ ପିହିକିତାନ୍‌ ଆରି ୱିଜ଼ାର୍‌ ବେମାରିଂ ଉଜ୍‌ କିତାନ୍‌, ");
INSERT INTO peg_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","ଇ ଲାକେ ହେୱାନ୍‌ ଜିସାୟ୍‌ ବେଣ୍‌ବାକ୍‌ଣାୟ୍‌ କାଜିଂ ଇ ବଚନ୍‌ ପୁରାଆତାତ୍‌, “ହେୱାନ୍‌ ନିଜେ ମା ନାଦାର୍‌ ୱିଜ଼ୁ ଇଡ଼୍‌ତାନ୍‌ ଆରେ ରଗ୍‌ ସବୁ ପିଣ୍ଡ୍‌ତାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","ଜିସୁ ତା ଚାରିବେଣ୍‌ତି ତା ଚେଲାରିଂ ହୁଡ଼୍‌ଜି ହାମ୍‌ଦୁର୍‌ ଆନ୍‌ଟି ପାଡ଼୍‌କା ହାନି କାଜିଂ ବଲ୍‌ ହିତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","ଆରେ, ରୱାନ୍‌ ସାସ୍ତ୍ରି ତା ଲାଗାଂ ୱାଜ଼ି ଇଚାନ୍‌, “ଏ ଗୁରୁ,” ଏନ୍‌ ଇମ୍‌ଣି ବାହାତ ହାନାୟ୍‌, “ଆନ୍‌ ନି ଲାହାଙ୍ଗ୍‌ ୱାନାଙ୍ଗ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","ହେବେ ଜିସୁ ହେଦେଲିଂ ଇଚାନ୍‌, “କଲ୍ୟାତିଂ ପାରା ମାନାତ୍‌, ଆକାସ୍‌ନି ପଟିତିଂ ଗୁଡା ମାନାତ୍‌, ମତର୍‌ ମାନାୟ୍‌ ମାଜ଼ି କାପ୍‌ଡ଼ା ଇଡ୍‌ଦେଂ ବାହା ହିଲୁତ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","ଜିସୁଙ୍ଗ୍‌ ଆରେ ର ଚେଲାହି ଇଚାନ୍‌, “ମାପ୍ରୁ, ପର୍ତୁମ୍‌ ହାଲ୍‌ଜି ମାଞ୍ଜି ଆବାଂ ମୁଚେଙ୍ଗ୍‌ ଇଞ୍ଜି ନାଙ୍ଗେଙ୍ଗ୍‌ ବଲ୍‌ ହିଦା ।” ");
INSERT INTO peg_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","ଜିସୁ ତାଙ୍ଗ୍‌ ଇଚାନ୍‌, “ନା ପାଚେ ପାଚେ ୱାଡୁ, ହାତି ମାନାୟ୍‌ ହାତି ଲଗାଂ ମୁଚ୍‌ଚି ହିୟାଟ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","ଦିନେକ୍‌ ଜିସୁ ଚେଲାହିର୍‌ ଲାହାଙ୍ଗ୍‌ ଡଙ୍ଗାତ ହାଲ୍‌ଜି ମାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","ହାଚାଟ୍ରେ ହାମ୍‌ଦୁର୍‌ତ ର ବେସି ଗାଜା ତ୍ରିପ୍‌କୁ ହୁଜ଼ାୱାଣି ନିକ୍‌ତାତ୍‌ ଆରି ଡଙ୍ଗା ଏଜ଼ୁକାଂ ମୁଞ୍ଜ୍‌ନି ଲାକେ ଆତାତ୍‌ । ମାତର୍‌ ହେ ପାଦ୍‌ନା ଜିସୁ ହୁନ୍‌ଞ୍ଜି ମାଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","ଚେଲାହିର୍‌ ତାଙ୍ଗ୍‌ ନିକ୍‌ଚି ଇଚାର୍‌, ଏ “ମାପ୍ରୁ, ମାଙ୍ଗେଙ୍ଗ୍‌ ରାକ୍ୟା କିଦା । ଆୱିତିସ୍‌ ଆପେଂ ମୁନ୍‌ଞ୍ଜି ହାନାପ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","ଜିସୁ ଦାକା କିଜ଼ି ଇଚାନ୍‌, “ଇନାକିଦେଂ ଏଚେକ୍‌ ପାଡ୍ରା ଆନାଦେରା ?” ଏପେଙ୍ଗ୍‌ “ଇନାକା ଏଚେକ୍‌ ଅଲପ୍‍ ପାର୍ତି କିନାକାଦେର୍‌ ? ତା ପାଚେ ହେୱାନ୍‌ ନିଙ୍ଗ୍‌ଜି ଦୁକା ଆରି ଲଡ଼ିତିଂ ତିର୍‌ ଆଦେଂ କାଜିଂ ବଲ୍‌ ହିତାନ୍‌ । ସାଙ୍ଗେ ସାଙ୍ଗେ ୱିଜ଼ୁ ତିର୍‌ ଆତାତ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","ହେବେ ୱିଜ଼ାର୍‌ କାବା ଆତାର୍‌ । ହେୱାର୍‌ ରକାନ୍‌ ଆରେ ରକାନିଂ ବେଣ୍‌ବାଟ୍‌ କିତାର୍‌ “ଇୱାନ୍‌ ଇନେସ୍‌ ବାର୍ତି ମାନାୟ୍‌ ? ଦୁକା ଆରି ଲଉଡ଼ି ପା ତା ବଲ୍‌ ମାନିକିନିକା ।” ");
INSERT INTO peg_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","ଜିସୁ ହାମ୍‌ଦୁର୍‌ ଆନ୍‌ଟି ପାଡ଼୍‌କା ଗଦରିୟର୍‌ ନିପ ଏକିତି ଦାପ୍ରେ ରିୟାରିଂ ବେଟାଆତାନ୍ । ହେୱାର୍‌ ହେବେ ମାନି ଦୁଗେର୍‌ନି କ୍ଡୁକିତ ମାଚାର୍‌ । ହେୱାର୍‌ ପୁଦାଆହ୍ୟାତାକାର୍ ଆରି ଏଚେକ୍‌ ବଇଁଙ୍କାର୍‌ ଜେ ହେ ରାସ୍ତା ହିଜ଼ି ହାଞ୍ଜେଙ୍ଗ୍‌ ୱାଦେଙ୍ଗ୍‌ ଇନେର୍‌ ସାସ୍‌ କିୱାଦାଂ ମାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","ହେୱାର୍‌ ଜିସୁଙ୍ଗ୍‌ ହୁଡ଼୍‌ତି ଦାପ୍ରେ କିକିରାଡିଂ କିଜ଼ି ଇଚାର୍‌, “ଏ ଇସ୍ୱର୍ତି ମେହି ! ନି ଲାହାଙ୍ଗ୍‌ ମାତି ଇନାକା ମାନାତ୍‌ ? ସମୁ ଆୱିହିଙ୍ଗ୍‌ନେ ଏନ୍‌ ମାଙ୍ଗେଙ୍ଗ୍‌ ଇନାକା ଡାଣ୍ଡ୍‌ ହିଦେଂ ଇବେ ୱାତାଇନା ?” ");
INSERT INTO peg_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","ହେବେତାଂ ଅଲପ୍‍ ଦେହା ର ମାନ୍ଦା ପାଞ୍ଜିଙ୍ଗ୍‌ ହାରାଆଜ଼ି ମାଚିକ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","ହେ ମାନାୟାର୍‌ ବିତ୍ରେ ମାନି ପୁଦାଂ ଜିସୁଙ୍ଗ୍‌ ଗୱାରି କିଜ଼ି ଇଚିକ୍‌, “ମାଙ୍ଗ୍‌ ଜଦି ପେସ୍‌ପେଦେଂ ଇଚା କିନାୟା, ହେ ପାଞ୍ଜିଙ୍ଗ୍‌ ବିତ୍ରେ ମାଙ୍ଗ୍‌ ପକ୍‌ତା ।” ");
INSERT INTO peg_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","ଜିସୁ ଇଚାନ୍‌, “ହାଲାଟ୍‌ ।” ପୁଦାଂ ସାଙ୍ଗେ ସାଙ୍ଗେ ମାନାୟ୍‌ତିଂ ପିସ୍ତି ପାଞ୍ଜିଙ୍ଗ୍ ବିତ୍ରେ ହଟିକ୍‌ । ପାଞ୍ଜିଙ୍ଗ୍‌ ମାନ୍ଦା ହଞ୍ଚି ହାଲ୍‌ଜି ମାଡ଼ି ଗବାତାଂ ହନ୍‌ଚି ହାଲ୍‌ଜି ହାମ୍‌ଦୁର୍‌ତ ମୁନ୍‌ଞ୍ଜି ହାତିକ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","ପାଞ୍ଜିଙ୍ଗ୍‌ ହାରାଇ କିଜ଼ି ମାଚି ମାନାୟ୍‌ ଲାଗେନି ବସ୍ତିକାଙ୍ଗ୍‌ ହାଲ୍‌ଜି ପୁଦା ଆହ୍ୟାତାକାର୍‌ କାଜିଂ ଇନାକା ଗିଟା ଆଜ଼ି ମାଚାତ୍‌ ହେବେ ୱିଜ଼ୁ ବେଣ୍‌ ୱେଚ୍‌ଚି ବୁଲାଆତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","ଲାଗିଂ ହେ ବସ୍ତିନି ୱିଜ଼ାକାର୍‌ ଜିସୁଙ୍ଗ୍‌ ବେଟା ଆଦେଂ ହସି ୱାତାର୍‌ ଆରେ ତାଙ୍ଗ୍‌ ବେଟାଆଜ଼ି ହେ ନିପ ପିସ୍ତି ହାନ୍ଦିତାଂ ହାଞ୍ଜେଙ୍ଗ୍‌ ଜିସୁଙ୍ଗ୍‌ ଗୱାରି କିତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","ଜିସୁ ଡଙ୍ଗାତ ଦୁମ୍‌ଜି ହାମ୍‌ଦୁର୍‌ ଆନ୍‌ଟି ପାଡ଼୍‌କା ମାନି ଜାର୍‌ ବସ୍ତିତ ମାସ୍‌ଦି ହାଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","ହେବେ ର ହିର୍‌କଲ୍‌ ରଗିଂ ମାନାୟାର୍‌ ତା ତାକେ ତାହିୱାତାର୍‌ । ରଗ୍ୟା ତା ଟାଟିତ ମାଗ୍‌ଜି ମାଚାନ୍‌ । ହେୱାର୍‌ତି ଏଚେକ୍‌ ପାର୍ତି ହୁଡ଼୍‌ଜି ଜିସୁ ହିର୍‌କଲ୍‌ ଇଡ଼୍‌ୟାତାକାନିଂ ଇଚାନ୍‌, “ବପା ସାସ୍‌ ଆହା । ନି ପାପ୍‌ କେମା ଆତାତ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","କେତେକ୍‌ ଦରମ୍‌ ଗୁରୁର୍‌ ଇକାତା ୱେନ୍‌ଞ୍ଜି ମାନେ ମାନେ ବାବି କିତାର୍‌, “ଇ ମାନାୟ୍‌ ଇସ୍ୱର୍‌ତିଂ ନିନ୍ଦା କିନାନା ।” ");
INSERT INTO peg_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","ହେୱାର୍‌ତି ମାନ୍‌ତି କାତା ପୁଞ୍ଜି ଜିସୁ ଇଚାନ୍‌, “ଏପେଙ୍ଗ୍‌ ଇନାକିଦେଂ ଏଲେଙ୍ଗ୍‌ ବାନ୍ୟା ଚିନ୍ତା କିନାଦେରା ? ");
INSERT INTO peg_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","‘ନି ପାପ୍‌ କେମା ଆତାତ୍‌ ?’ ଇ କାତା ଇନାକା ଆଡ଼୍‌ୱା କି ‘ନିଙ୍ଗ୍‌ଜି ହାଲା’ ଇନାକା ଆଦିକ୍‌ ଆଡ଼୍‌ୱା ? ");
INSERT INTO peg_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","ମାତର୍‌ ପାପ୍‌ କେମା କିଦେଙ୍ଗ୍‌ ପୁର୍ତିତ ମାନାୟ୍‌ ମାଜ଼ି ଜେ ଆଦିକାର୍‌ ମାନାତ୍‌, ଇ କାତା ମି ଆଗେ ପାର୍ମାଣ୍‌ କିନାଙ୍ଗ୍‌ ।” ତା ପାଚେ ଜିସୁ ହିର୍‌କଲ୍‌ ରଗିଂ ଇଚାନ୍‌, “ନିଙ୍ଗା, ନି କାଟେଲ୍‌ ଆସ୍ତି ମିଞ୍ଜ ତାଙ୍ଗ୍‌ଜି ହାଲା ।” ");
INSERT INTO peg_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","ହେବେତାଂ ହେୱାନ୍‌ ନିଙ୍ଗ୍‌ଜି ଇଞ୍ଜ ତାଙ୍ଗ୍‌ଜି ହାଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","ହେଦାଂ ହୁଡ଼୍‌ଜ଼ି ମାନାୟାର୍‌ ପାଣ୍ଡ୍ରା ଆତାର୍‌, ଆରେ, ଇମ୍‌ଣି ଇସ୍ୱର୍‌ ମାନାୟାରିଂ ଏଲେଙ୍ଗ୍‌ ଆଦିକାର୍‌ ହିତାର୍ଣ୍ଣା, ହେୱାନ୍ତି ଜାଜ୍‌ମାଲ୍‌ କିତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","ଜିସୁ ହେବେତାଂ ତାଙ୍ଗ୍‌ଜି ହାଚି ପାଚେ ମାତିଉ ତର୍‌ଦି ରୱାନ୍‌ ସିସ୍ତୁଏନ୍‌ନାକାନିଂ ତା ଏନ୍‌ନି ବାହାତ କୁଚ୍‌ଚାକା ହୁଡ଼୍‌ତାନ୍‌ ଆରି ତାଙ୍ଗେଙ୍ଗ୍‌ କୁକ୍‌ଚି ଇଚାନ୍‌, “ନା ପାଚେପାଚେ ୱା ।” ମାତିଉ ନିଙ୍ଗ୍‌ଜି ତା ଲାହାଙ୍ଗ୍‌ ହାଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","ଜିସୁ ମାତିଉ ଇଞ୍ଜ ତିଞ୍ଜେଙ୍ଗ୍‌ କୁଚ୍‌ଚିହିଂ ହେନି ସିସ୍ତୁଏନ୍‌ନାକାର୍‌ ଆରି ପାପି ଲକୁ ତା ଲାହାଙ୍ଗ୍‌ ଆରି ତା ଚେଲାହିର୍‌ ଲାହାଙ୍ଗ୍‌ ତିଞ୍ଜେଙ୍ଗ୍‌ କୁଚ୍‌ଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","କେତେକ୍‌ ଜାଣ୍‌ ପାରୁସିର୍‌ ଇଦାଂ ହୁଡ଼୍‌ଜି ତା ଚେଲାହିରିଂ ଇଞ୍ଜେଙ୍ଗ୍‌ ଲାଗାତାର୍‌, “ମି ଗୁରୁ ଇନାକିଦେଂ ସିସ୍ତୁଏନ୍‌ନାକାର୍‌ ଆରି ପାପିର୍‌ ଲାହାଙ୍ଗ୍‌ ତିନାନା ?” ");
INSERT INTO peg_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","ମାତର୍‌ ଜିସୁ ହେଦାଂ ୱେନ୍‌ଞ୍ଜି ଇଚାନ୍‌, “ଉଜ୍‌ ମାନାୟ୍‌ତିଂ ଡାକ୍ତର୍‌ ଲଡ଼ା ଆକାୟ୍‌, ମାତର୍‌ ବେମାର୍‌ ଲଗାଂ ଲଡ଼ା ମାନାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","ସାସ୍ତର୍‍ତ ଲେକା ଆତାତ୍‌ନ୍ନା ଆନ୍‌ ପୁନାଙ୍ଗ୍‌ ପୁଜା ମାନ୍‌ କିୱାଦାଂ ଦୟା ମାନ୍‌ କିନାଙ୍ଗ୍‌, ଇ ବଚନ୍‌ନି ଅରତ୍‌ ଏପେଙ୍ଗ୍‌ ହାଲ୍‌ଜି ହିକ୍ୟା କିୟାଟ୍‌, ଇନାକିଦେଂକି ଆନ୍‌ ଦରମ୍‌ ଲଗାଂ କୁକ୍‌ତେଂ ୱାୱାତାଂନା, ମତର୍‌ ପାପିରିଂ କୁକ୍‌ତେଂ ୱାତାଂନା ।” ");
INSERT INTO peg_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","ହେୱାଡ଼ାଂ ଜହନ୍‌ତି ଚେଲାହିର୍‌ ତା ତାକେ ୱାଜ଼ି ଇଚାର୍‌, “ଆପେଂ ଆରି ପାରୁସିର୍‌ ଉପାସ୍‌ କିନାପ୍‌, ମାତର୍‌ ନି ଚେଲାର୍‌ ଉପାସ୍‌ କିଉର୍‌ ଇନାକିଦେଂ ?” ");
INSERT INTO peg_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","ଜିସୁ ହେୱାରିଂ ଇଚାନ୍‌, “ବିବାଦାଂଣେନ୍‌ ଏଚେକାଡ଼୍‌ଦ ପାତେକ୍‌ ବିବାକିନାକାର୍‌ ହୁକେ ମାନାନ୍‌, ହେ ପାତେକ୍‌ ହେୱାର୍‌ କି ଦୁକ୍‌ କିଦେଙ୍ଗ୍‌ ଆଡ୍‌ନାର୍‌ ? ମାତର୍‌ ସମୁ ୱାନାତ୍‌, ଏଚେକାଡ଼୍‌ଦ ହେୱାର୍‌ତାଂ ବିବା ଦାଙ୍ଗ୍‌ଣେନିଂ ନିକ୍‌ଚି ଅୟା ଆନାତ୍‌, ଆରେ ହେୱାଡ଼ାଂ ହେୱାର୍‌ ଉପାସ୍‌ କିନାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","ଇନେର୍‌ ପୁନି ହେନ୍ଦ୍ରା ନି ଗନ୍ଦା ପ୍ଡାନି ହେନ୍ଦ୍ରାତ ମେହାୟ୍‌ କିଉର୍‌, ଇନାକିଦେଂକି ହେ ହେନ୍ଦ୍ରା ଗନ୍ଦା ହେନ୍ଦ୍ରାତିଂ ବେସି କେଚ୍‌ଚି ଅନାତ୍‌ ଆରେ ଆଦେକ୍‌ ଗାଜା କାଣା ଆନାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","ଆରେ, ମାନାୟ୍‌ ପୁନି ଅଙ୍ଗୁର୍‌ ରାସ୍‌ ପ୍ଡାନି ତଲ୍‌ ମଣାତ ଇଟୁର୍‌; ଇଟ୍‌ଟିସ୍‌ ତଲ୍‌ ମଣା କେଞ୍ଜ୍‌ନାତ୍‌ ଆରେ ଅଙ୍ଗୁର୍‌ ରାସ୍‌ ବଂନାତ୍‌, ଆରେ ମଣା ୱିଜ଼ୁ କାରାପ୍‌ ଆନାତ୍‌; ମାତର୍‌ ମାନାୟ୍‌ ପୁନି ଅଙ୍ଗୁର୍‌ ରାସ୍‌ ପୁନି ମଣାତ ଇଟ୍‌ନାର୍‌, ଆରେ ରିଣ୍ଡିପା ରାକ୍ୟା ପାୟାନାତ୍‍ ।” ");
INSERT INTO peg_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","ଜିସୁ ହେୱାରିଂ ଇ ୱିଜ଼ୁ କାତା ଇନିୱାଡ଼ାଲିଂ, ହୁଡ଼ା, ର ମୁଣିକା ତାତାକେ ୱାଜ଼ି ଜୱାର୍‌ କିଜ଼ି ଇଚାନ୍‌, “ନା ଗାଡ଼୍‌ଚେ ହାଚାଟ୍ରେ ହାତାତ୍‌, ମାତର୍‌ ଏନ୍‌ ୱାଜ଼ି ତାଙ୍ଗେଙ୍ଗ୍‌ କେଇ ଇଡ଼ା, ଆରେ ହେଦେଲ୍‌ ଜିନାତ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","ହେବେ ଜିସୁ ନିଙ୍ଗ୍‌ଜି ତା ଚେଲାହିର୍‌ ଲାହାଙ୍ଗ୍‌ ତା ପାଚେ ପାଚେ ହାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","ଜିସୁ ହାଜ଼ିତ ହାନିହିଂ ର କଗ୍‌ଲେ ତା ପାଚ୍‌ ବାଗାଙ୍ଗ୍‌ ୱାଜ଼ି ତା ହେନ୍ଦ୍ରାନି ଚେଲିଂ ଡୁତାତ୍‌ । ହେଦେଲ୍‌ ବାର ବାର୍ହୁ ପାତେକ୍‌ ଗାଗାଡ଼୍‌ନାଡ୍‌ୱି ରଗ୍‌ତ ଡଣ୍ଡ୍‌ ଆଜ଼ି ମାଚାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","ଇନାକିଦେଂକି ହେଦେଲ୍‌ ମାନ୍ତ ମାନ୍ତ ଇଞ୍ଜି ମାଚାତ୍‌, “କେବଲ୍‌ ତା ହେନ୍ଦ୍ରା ଡୁତିସ୍‌ ଆନ୍‌ ଉଜ୍‌ ଆନାଙ୍ଗ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","ମାତର୍‌ ଜିସୁ ମାସ୍‌ଦି ତାଙ୍ଗ୍‌ ହୁଡ଼୍‌ଜି ଇଚାନ୍‌, “ଗାଡ଼୍‌, ସାସ୍‌ ଆହା, ନି ପାର୍ତି ନିଙ୍ଗେଙ୍ଗ୍‌ ଉଜ୍‌ କିତାନ୍‌ନା ।” ହେ ଦାପ୍ରେ କଗ୍‌ଲେ ଉଜ୍‌ ଆତାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","ପାଚେ ଜିସୁ ହେ ଜିହୁଦି ମୁଣିକା ଇଞ୍ଜ ୱାଜ଼ି ହୁର୍‌ଡ଼ି ତୁବ୍‌ନାକାରିଂ ଆରି କିର କିଜ଼ି ମାନି ଲକ୍‌ତିଂ ହୁଡ଼୍‌ଜି, ");
INSERT INTO peg_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","ଜିସୁ ଇଚାନ୍‌, “ୱିଜ଼ାଦେର୍‌ ଇବେଣ୍ଡାଂ ହସି ହାଲାଟ୍‌ । ଗାଡ଼୍‌ଚେ ହାୱାତାତ୍‌ନା । କେବଲ୍‌ ହୁଞ୍ଜ୍‌ନାତା ।” ତା କାତା ୱେନ୍‌ଞ୍ଜି ହେୱାର୍‌ ଗ୍ଡାଇତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","ମାତର୍‌ ମାନାୟାରିଂ ବାର୍ତ ହପ୍‌ତି ପାଚେ, ହେୱାନ୍‌ ବିତ୍ରେ ହାଲ୍‌ଜି ଗାଡ଼୍‌ଚେଂ କେଇ ଆସ୍ତାନ୍‌, ଆରେ ହେଦେଲ୍‌ ନିଙ୍ଗ୍‌ଜି ନିଲ୍‌ତାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","ଆରେ, ଇ କାତା ହେ ଦେସ୍‌ ସବୁନିପ ୱିଣ୍‌ତାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","ଜିସୁ ହେବେତାଂ ହାନିହିଂ ରିୟାର୍‌ କାଣାର୍‌ ପାଚେ ପାଚେ ହାଲ୍‌ଜି ଗାଜାକାଟ୍‌ କିଜ଼ି ଇଞ୍ଜେଙ୍ଗ୍‌ ଲାଗାତାର୍‌, “ଏ ଦାଉଦ୍‌ ମାଜ଼ି, ମାଙ୍ଗେଙ୍ଗ୍‌ ଦୟା କିଦା ।” ");
INSERT INTO peg_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","ଜିସୁ ପର୍ତୁମ୍‌ ଇଞ୍ଜ ହଣ୍‌ଗାତାନ୍‌ କାଣାର୍‌ ପା ହଣ୍‌ଗାତାର୍‌ । ହେବେ ଜିସୁ ହେୱାରିଂ ୱେନ୍‌ବାତାନ୍‌, “ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ଉଜ୍‌ କିଦେଙ୍ଗ୍‌ ଆଡ଼୍‌ଦାନାଂ ଇଞ୍ଜି ଏପେଙ୍ଗ୍‌ ପାର୍ତି କିନାଦେରା କି ?” ହେୱାର୍‌ ଉତର୍‌ ହିତାର୍‌ “ଆଁ ମାପ୍ରୁ ।” ");
INSERT INTO peg_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","ହେ ପାଦ୍‌ନା ଜିସୁ ହେୱାର୍‌ତି କାଣ୍‌ଙ୍ଗାତ ଡୁଜ଼ି ଇଚାନ୍‌, “ମି ପାର୍ତି କାଜିଂ ହେଦାଂ ଆୟେତ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","ହେ ଦାପ୍ରେ ହେୱାର୍‌ କାଣ୍‌କୁ ସାକ୍ତି ପାୟା ଆତାର୍‌ । ପାଚେ ଜିସୁ ହେୱାରିଂ ଡାଟ୍‌କିଜ଼ି ବଲ୍‌ ହିଜ଼ି ଇଚାନ୍‌, “ହୁଡ଼ାଟ୍‌, ଇ ବିସ୍ରେ ଇନେସ୍‌ ଇନେର୍‌ ପୁନ୍‌ୱାକା ମାନାତ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","ମାତର୍‌ ହେୱାର୍‌ ହେବେତାଂ ହାଲ୍‌ଜି ଜିସୁତି କାତା ୱିଜ଼ୁ ଦେସ୍‌ ନିପ ସୁଣାୟ୍‌ କିତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","ହେୱାର୍‌ ହସି ହାନିହିଂ, ହୁଡ଼ା, ମାନାୟାର୍‌ ରୱାନ୍‌ ଗୁଲା ପୁଦା ଡୁୟାଆତାକାନିଂ ତା ତାକେ ତାହିୱାତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","ଆରେ, ବୁତ୍‌ ପିସ୍ତିଲେ, ହେ ଗୁଲା କାତା ଇଚାନ୍‌ । ହେବେ ମାନାୟାର୍‌ କାବା ଆଜ଼ି ଇଚାର୍‌, “ଇସ୍ରାଏଲ୍‌ ବିତ୍ରେପା ଏଲେଙ୍ଗ୍‌ ଇନାୱାଡ଼ାଂ ପା ହୁଡ଼୍‌ୱାତାପ୍‌ନା ।” ");
INSERT INTO peg_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","ମାତର୍‌ ପାରୁସିର୍‌ ଇଚାର୍‌, “ହେ ମୁଣିକା ‌ଗାଜା ବୁତ୍‌ ଉପ୍‌କାର୍‌ତାଂ ପୁଦାଂ ପିହିକିନାନା ।” ");
INSERT INTO peg_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","ଇଦାଂ ପାଚେ ଜିସୁ ହେୱାର୍‌ତି କୁଟୁମ୍‌ ଇଞ୍ଜ ହିକ୍ୟା ହିଜ଼ି ରାଜିନି ନେକ୍ରିକାବୁର୍‌ ସୁଣାୟ୍‌ କିଜ଼ି ଆରି ବାରବିନି ରଗ୍‌ ଆରି ସବୁ ବାନି ବେମାର୍‌ ଉଜ୍‌ କିଜ଼ି ୱିଜ଼ୁ ଗାଡ଼୍‌, ଆରେ ନାସ୍‌କୁକାଂ ପ୍ଡାଞ୍ଜେଙ୍ଗ୍‌ ଲାଗାତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","ଆରେ, ମାନାୟାରିଂ ହୁଡ଼୍‌ଜି ହେୱାର୍‌ କାଜିଂ ହେୱାନ୍‌ କାର୍ମାତିଂ ରାସ୍‌ ଇଚାନ୍‌, ଇନାକିଦେଂକି ହେୱାର୍‌ ରାକ୍ୟାହିଲ୍‌ୱି ମେଣ୍ଡାଂ ଲାକେ ଉପାୟ୍‌ ହିଲ୍‍ୱି ଆରି ଜେତେକେତେ ମାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","ହେୱାଡ଼ାଂ ଜିସୁ ଜାର୍‌ ଚେଲାରିଂ ଇଚାନ୍‌, ତାସ୍‌ ହିନା ବେସି ମତର୍‌ କାମାୟ୍‌ କିନାକାର୍‌ ଉଣା, ");
INSERT INTO peg_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","ଲାଗିଂ ତା କାମାୟ୍‌ ବାହାତ କାମାୟ୍‌ କିନାକାରିଂ ପକ୍‌ନି କାଜିଂ କାମାୟ୍‌ ବାହିନି ହାଉକାର୍‌ ତାକେ ପାର୍ତାନା କିୟାଟ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","ଜିସୁ ତା ବାରଜାଣ୍‌ ଚେଲାରିଂ କୁକ୍‌ଚି ପୁଦାଂ ପିହିକିନି କାଜିଂ ଆରି ସବୁ ବାନି ରଗ୍‌ ବେମାର୍‌ ଉଜ୍‌ କିନି କାଜିଂ ହେୱାରିଂ ଆଦିକାର୍‌ ସାକ୍ତି ହିତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","ହେ ବାରଜାଣ୍‌ ପକ୍ୟାତାକାର୍‌ ତର୍‌ ଆତାତ୍‌, ସିମନ୍‌, ପିତର୍‌ ତର୍‌ଦ ପା ଜାଣାଚିନା ଆରି ତା ଟଣ୍ଡାହି ଆନ୍ଦ୍ରିୟ; ଜେବ୍‌ଦିତି ରି ମେହିର୍‌ ଜାକୁବ୍‌ ଆରି ତା ଟଣ୍ଡାହି ଜହନ୍‌; ");
INSERT INTO peg_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","ପିଲିପ୍‌ ଆରି ବାର୍ତଲମି, ତମା ଆରି ସିସ୍ତୁଏନ୍‌ନାକାର୍‌ ମାତିଉ, ଆଲପିୟ ମେହି ଜାକୁବ୍‌, ଆରି ତଦିୟ, ");
INSERT INTO peg_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","କିଣାନିୟ ସିମନ୍‌ ଆରି ଇସ୍କାରିୟତିୟ ଜିହୁଦା, ଇନେନ୍‌ ଜିସୁଙ୍ଗ୍‌ ସାତ୍ରୁ କେଇଦ ହେଲାୟ୍‌ କିତାକାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","ଜିସୁ ଇ ବାରଜାଣ୍‌ ଚେଲାରିଂ ପକ୍‌ଚି ହେୱାନ୍‌ ହେୱାରିଂ ବଲ୍‌ ହିଜ଼ି ଇଚାନ୍‌, “ପାର୍ତିକିୱି ଜିହୁଦିର୍‌ ନିପ ହାଲ୍‌ମାଟ୍‌ ଆରି ସମିରଣିୟାନି ଇମ୍‌ଣି ଗାଡ଼୍‌ଦ ହଣ୍‌ଗାମାଟ୍, ");
INSERT INTO peg_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","ମାତର୍‌ ଜାଙ୍ଗ୍‌ଜି ମାଚି ମେଣ୍ଡା ଲାକେ ଇସ୍ରାଏଲ୍‌ ଲାଗାଂ ହାଲାଟ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","ହେୱାର୍‌ ବିତ୍ରେ ସୁଣାୟ୍‌ କିଜ଼ି ଇନାଟ୍‌, ସାର୍ଗେ ରାଜି ଲାଗେ ୱାତାତେ ! ");
INSERT INTO peg_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","ବେମାର୍‌ ଲଗାଂ ଉଜ୍‌ କିୟାଟ୍‌, ହାତି ଲଗାଂ ଆରେ ନିକ୍‌କାଟ୍‌, ଗାଜା ରଗ୍ୟାରିଂ ସକଟ୍‌ କିୟାଟ୍‌, ପୁଦାଂ ପିହିକିୟାଟ୍‌ । ଇନାକା ଉପ୍‌କା ଗାଟା ଆତାଦେର୍ଣ୍ଣା, ହେଦାଂ ବିନ୍‌ନିକାରିଂ ଉପ୍‌କା ଦାନ୍‌ ହିୟାଟ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","ମି ଜାଙ୍ଗ୍‌ୟାତ “ହନା, କି ରୁପା କି ତାମା, ଆରେ ଜାତ୍ରା କାଜିଂ ମଣା, ");
INSERT INTO peg_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","କି ବିକ୍ୟା ଏନ୍‌ନି ମଣା ଆସ୍ତି ବୁଲା ଆମାଟ୍‌ ଅଲପ୍‍ ରିଣ୍ଡାଂ ଆଙ୍ଗିଙ୍ଗ୍‌ ନଲେ ପାଣ୍ଡାଇଙ୍ଗ୍‌ କି ବାଡ୍‌ଗା ପା ଅମାଟ୍‌ । ଇନେକିଦେଂକି କାମାୟ୍‌ କିନାକାଦେର୍‌ ଜାର୍‌ ଡାବୁଙ୍ଗ୍‌ ପାୟାନି ଜଗ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“ଆରେ, ଏପେଙ୍ଗ୍‌ ଇମ୍‌ଣି ଗାଡ଼୍‌ଦ କି ନାସ୍ତ ହଣ୍‌ଗାନାଦେର୍‌, ହେବେ ଇମ୍‌ଣି ଲକ୍‌ ହେବା କିଦ୍‌ଦେଂ ଆଡ଼୍‌ଦାନାନ୍‌, ହେଦାଂ ଆନ୍‌ମାନ୍‌ କିୟାଟ୍‌, ଆରେ ୱାୱି ପାତେକ୍‌ ହେବେ ମାନାଟ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","ର ଇଞ୍ଜ ହଣ୍‌ଗିନି ୱେଡ଼ାଲିଂ ହେବେ ମାନି ମାନାୟ୍‌ତିଂ ଇନାଟ୍‌, “ମିଦାଙ୍ଗ୍‌ ସୁସ୍ତା ଆୟେତ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","ହେ ଇଲ୍‌ ଏଚେକାଡ଼୍‌ଦ ଆନାତ୍‌, ଲାଗିଂ ତା କାଜିଂ ମି ସୁସ୍ତା ଆଏତ୍‌, ମାତର୍‌ ହେଦାଂ ଜଦି ଆଉତ୍‌, ତା ଆତିସ୍‌ ମି ସୁସ୍ତା ମି ଲାଗାଂ ମାସ୍‌ଦି ୱାଏତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","ଜଦି ଇମ୍‌ଣି ଇଞ୍ଜ କି ଗାଡ଼୍‌ଦ ମିଙ୍ଗେଙ୍ଗ୍‌ ଲକୁ ଇଡ଼୍‌ଦୁର୍‌, ପାନାନି ଦୁଡ଼ି ଡ଼ାତ୍‌ତି ହେ ବାହା ପିହାଟ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ହାତ୍‌ପା ଇଞ୍ଜ୍‌ନାଙ୍ଗା, ବିଚାର୍‌ ନାଜିଂ ଇୱାର୍‌ ତାଙ୍ଗ୍‌ ସଦମ୍‌ ଆରି ଗମରା ଦେସ୍‌ନି ମାନାୟାର୍‌ କାଜିଂ ଇସ୍ୱର୍‌ ଆଦିକ୍‌ ଦସା ଆନାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“ହୁଡ଼ାଟ୍‌, ହୁଣ୍ଡାର୍‌ ବୁର୍କାକାଂ ତାକେ ପା ମେଣ୍ଡାଂ ଲାକେ ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ପକ୍ତାନାଙ୍ଗା, ଇଚିସ୍‌ ରାଚ୍‌ ଲାକେ ବୁଦ୍ୟା ଆରି ପାର୍‌ୱା ଲାକେ ହୁଦାର୍‌ ଆଡୁ । ");
INSERT INTO peg_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","ମତର୍‌ ମାନାୟାର୍‌ତାଂ ଜାଗ୍ରତ୍‌ ଆଜ଼ି ମାନାଟ୍‌, ଇନାକିଦେଂକି ହେୱାର୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ବିଚାର୍‌ ବାହାତ ହେଲାୟ୍‌ କିଦ୍‌ନାର୍‌ ଆରି ହେୱାର୍‌ କୁଟୁମ୍‌ ଇଞ୍ଜ କର୍‌ଡା ଲାହାଂ ଟ୍ରାକ୍‌ତାନାର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","“ଆରେ ଏପେଙ୍ଗ୍‌ ନା କାଜିଂ ରାଜ୍‌କାରିୟା ଆରି ରାଜାର୍‌ କଚଣ୍‌ତ ତାହିୱାୟାନାଦେର୍; ହେଦାଂ ହେୱାରିଂ ଆରି ପାର୍ତିକିୱି ଜିହୁଦିର୍‌ କାଜିଂ ସାକି ଲାକେ ଆନାଦେର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","ମାତର୍‌ ଏଚେକାଡ଼୍‌ଦ ହେୱାର୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ହେଲାୟ୍‌ କିଦ୍‌ନାର୍‌, ହେୱାଡ଼ାଂ ଏପେଙ୍ଗ୍‌ ଇନେସ୍‌କି ଇନା କାତା ଇନାଦେର୍‌, ହେ ବିସ୍ରେନି ଚିନ୍ତା କିମାଟ୍‌, ଇନାକିଦେଂକି ଇନାକା ଇନାଦେର୍‌, ହେଦାଂ ହେ ଦାପ୍ରେ ମିଙ୍ଗେଙ୍ଗ୍‌ ହିଦ୍ୟାନାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","ଲାଗିଂ ଏପେଙ୍ଗ୍‌ ଇନ୍‍ୱାକାଦେର୍‌, ମାତର୍‌ ମିଞ୍ଜି ଆବାତି ଜିବୁନ୍‌, ଇନେର୍‌କି ମି ୱାସ୍କିତ କାତା ଇନାନ୍‌, ହେୱାନ୍‌ ବେଣ୍‍କାର୍‍ୟା ଆନାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“ଟଣ୍ଡେନ୍‌ ଟଣ୍ଡେନିଙ୍ଗ୍‌ ଆରି ଆବା ମାଜ଼ି ହାକି ବାହାତ ହେଲାୟ୍‌ କିତାର୍‌ ଆରେ ହିମ୍‌ଣାଙ୍ଗ୍ ଆବା ଆୟାକାଂ ବିରୁତ୍‌ତ ନିଙ୍ଗ୍‌ଜି ଅହ୍‌ନାର୍‌, ଆରି, ଏପେଙ୍ଗ୍‌ ନା ପାଚେୱାତି କାଜିଂ ଏପେଙ୍ଗ୍‌ ୱିଜ଼ାକାର୍‌ତାଂ ଗିଣ୍‌କିୟା ଆନାଦେର୍‌, ମତର୍‌ ଇନେର୍‌ ହାରିହାରା ପାତେକ୍‌ ସାସ୍‌ ଆଜ଼ି ମାନାନ୍‌ ହେୱାନ୍‌ ସାର୍ଗେତ ମୁକ୍ତି ପାୟା ଆନାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","ଆରେ ନା ତର୍‌ କାଜିଂ ଏପେଙ୍ଗ୍‌ ୱିଜ଼ାର୍‌ ହୁକେ ଗିଣ୍‌ ଆନାତ୍‌, “ମାତର୍‌ ଇନେର୍‌କି ୱିଜ଼୍‌ନି ପାତେକ୍‌ ତିର୍‌ ଆଜ଼ି ମାନାନ୍‌, ହେୱାନ୍‌ ମୁକ୍ତି ପାୟାଆନାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","ର ବସ୍ତିତ ଏପେଙ୍ଗ୍‌ କସ୍ଟ ପାୟାତିସ୍‍ ଅଲ୍‌ଗା ବସ୍ତିତ ହାଲାଟ୍‌, ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ହାତ୍‌ପା ଇଞ୍ଜ୍‌ନାଙ୍ଗା, ଏପେଙ୍ଗ୍‌ ଇସ୍ରାଏଲ୍‌ନି ଗାଡ଼୍‌ଦ କାମାୟ୍‌ ୱିହ୍‍ନି ଆଗେ ମାନାୟ୍‌ ମାଜ଼ି ମାସ୍‌ଦି ୱାନାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“ଇମ୍‌ଣି ଚେଲାହି ତା ଗୁରୁତାଂ ଗାଜା ଆକାୟ୍‌ । ହାଉକାର୍‌ ତାଙ୍ଗ୍‌ ଆଡ଼ିଏନ୍‌ ଗାଜାକାନ୍‌ ଆକାୟ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","ଚେଲା ଜାର୍‌ ଗୁରୁ ଆରି ଆଡ଼ିଏନ୍‌ ଜାର୍‌ ହାଉକାର୍‌ ଲାକେ ଆତିସ୍‌ ହେୱାର୍‌ ପାକ୍ୟାତ ସାରି । ହେୱାର୍‌ ଏଚେକାଡ଼୍‌ଦ ଇଲ୍‌ ମୁଣିକାଂ ବାଲ୍‌ଜିବୁଲ୍‌ ଇଞ୍ଜି ଇଚାର୍ଣ୍ଣା, ତେବେ ହେୱାର୍‌ତି ଲକ୍‌ବାକ୍‍ତିଂ ତ ଆରି ଆଦିକ୍‌ ଇନାର୍‌ !” ");
INSERT INTO peg_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“ଲାଗିଂ, ହେୱାରିଂ ପାଣ୍ଡ୍ରା ଆଡ; ଇନାକିଦେଂକି ଇନାକା ହତ୍‍ୱାକା, ଏଲେଙ୍ଗ୍‌ ହାର୍ଦାକା ଇନାକା ହିଲୁତ୍‌; ଆରେ ଇନାକା ପୁନ୍‍ୱାତାକା, ଏଲେଙ୍ଗ୍‌ ଡ଼ୁକ୍‌ନାକା ଇନାକା ହିଲୁତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ଇନାକା ମାଜ୍‌ଗାତାଂ ଇଞ୍ଜ୍‌ନାଙ୍ଗ୍‌; ହେଦାଂ ଅଜଡ଼୍‌ତ ଇନାଙ୍ଗ୍‌, ଆରେ ଇନାକା ଏପେଙ୍ଗ୍‌ ଡ଼ୁଗ୍‌ଜି ୱେନାଦେର୍‌, ହେଦାଂ ଇଲ୍‌ ଜେଗନ୍‌ ଜପି ସୁଣାୟ୍‌ କିୟାଟ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","ଆରେ ଇମ୍‌ଣାକାର୍‌ ଗାଗାଡ଼୍‌ତିଂ ଅହ୍‌ନାର୍‌, ମାତର୍‌ ୱାସ୍କିତିଂ ଅସ୍ତେଙ୍ଗ୍‌ ଆଡୁର୍‌, ହେୱାରିଂ ପାଣ୍ଡ୍ରା ଆମାଟ୍‌; ଇଚିସ୍‌ ଜେ ଗାଗାଡ଼୍‌ ଆରି ଜିବୁନ୍‌ ରିୟାରିଂ ନରକ୍‌ତ ନସ୍ଟ କିତାର୍‌, ତାଙ୍ଗେଙ୍ଗ୍‌ ପାଣ୍ଡ୍ରା ଆଡୁ । ");
INSERT INTO peg_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","ରିଣ୍ଡାଂ କଡିହାଡ଼ା ପଟିଂ ଇନାକା ଆଣେକ୍‌ତିଂ ପ୍ରୟା ଆଉତ୍‌ ? ଆରେ, ମି ଆବା ପିସ୍ତି ହେୱାର୍‌ ବିତ୍ରେତାଂ ପା ରଞ୍ଜାଙ୍ଗ୍‌ ମେଦ୍‌ନିତ ଆରୁତ୍‌; ");
INSERT INTO peg_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","ମାତର୍‌ ଇସ୍ୱର୍‌ ମି କାପ୍‌ଡ଼ାନି ୱିଜ଼ୁ ତେମୁଲ୍‌ ପା ଗାଣାକିୟା ଆତାତ୍‌ନ୍ନା । ");
INSERT INTO peg_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","ଲାଗିଂ ପାଣ୍ଡ୍ରା ଆମାଟ୍‌, ବେସି କଡିହାଡ଼ା ପଟିଂ ତାଙ୍ଗ୍‌ ଗାଜା !” ");
INSERT INTO peg_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“ଜେ ଇନେର୍‌ ଚଞ୍ଜ୍ୟାନାକା ନାଙ୍ଗେଙ୍ଗ୍‌ ମାପ୍ରୁ ଇଞ୍ଜି ମାନିକିଦ୍‌ନାର୍‌, ଆନ୍‌ ପା ସାର୍ଗେନି ଆବା ମୁମ୍‌ଦ ତାଙ୍ଗେଙ୍ଗ୍‌ ଏତୁ କିନାଙ୍ଗ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","ମାତର୍‌ ଜେ ଇନେର୍‌ ମାନାୟାର୍‌ ମୁମ୍‌ଦ ନାଙ୍ଗେଙ୍ଗ୍‌ ଏତୁ କିଦୁଦେର୍‍, ଆନ୍‌ ପା ସାର୍ଗେନି ଆବା ମୁମ୍‌ଦ ତାଙ୍ଗେଙ୍ଗ୍‌ ମାନି କିଉଙ୍ଗ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","ଆନ୍‌ ଜେ ପୁର୍ତିତ ସୁସ୍ତା ହିଦେଂ ୱାତାଂନା, ଇଦାଂ ବାବି କିମାଟ୍‌; ସୁସ୍ତା ହିଦେଂ ୱାୱାଦାଙ୍ଗ୍‌ ଇଚିସ୍‌ କାଣ୍ଡା ହିଦେଂ ୱାତାଂନା । ");
INSERT INTO peg_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","ଇନାକିଦେଂକି ଆନ୍‌ ଆବା ଲାହାଙ୍ଗ୍‌ ମାଜ଼ି ଆରି ଆୟା ଲାହାଙ୍ଗ୍‌ ଗାଡ଼୍‌ଚେ ଆରେ ପଦା ହୁକେ କଡ଼୍‍ୟା ବେରୁ ଗିଟାଇକିଦେଂ ୱାତାଂନା । ");
INSERT INTO peg_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","ଆରେ ନିଜ୍‌ଲକ୍‌ ଜାର୍‌ ଲାତ୍ରାର୍‌ ନେ ଜାର୍‌ ସାତ୍ରୁର୍‌ ଆନାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","ଇନେର୍‌ ଆବାଂ କି ଆୟାଂ ନା ତାଙ୍ଗ୍‌ ଆଦିକ୍‌ ଜିଉନନାର୍‌, ହେୱାନ୍‌ ନା ଚେଲା ଆଦେଂ ଆଡୁନ୍‌ । ଆରେ ଇନେର୍‌ କାଡ଼୍‌ଦେଙ୍ଗ୍‌ କି ଗାଡ଼୍‌ଚେଂ ନାତାଙ୍ଗ୍‌ ଆଦିକ୍‌ ୱାରି କିୱିତିସ୍‌, ହେୱାନ୍‌ ନା ଚେଲା ଆଦେଂ ଜଗ୍ୟ ଆକାୟ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","ଆରେ, ଇନେର୍‌ ଜାର୍‌ କ୍ରୁସ୍‌ ଆସ୍ତି ନା ପାଚେ ୱାଉନ୍‌, ହେୱାନ୍‌ ନା ଚେଲା ଆଦେଂ ଜଗ୍ୟ ଆକାୟ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","ଇନେନ୍‌ ଜାର୍‌ ଜିବୁନ୍‌ ବାଚାୟ୍‌ କିନାନ୍‌, ହେୱାନ୍‌ ହେଦାଂ ଆରାୟ୍‌ କିନାନ୍‌, ଆରେ ଇନେନ୍‌ ନା କାଜିଂ ଜାର୍‌ ଜିବୁନ୍‌ ଆରାୟ୍‌ କିନାନ୍‌, ହେୱାନ୍‌ ହେଦାଂ ବାଚାୟ୍‌ କିନାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“ଇନେନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ଇଡ଼୍‌ଦାନାନ୍‍, ହେୱାନ୍‌ ନାଙ୍ଗେଙ୍ଗ୍‌ ଇଡ଼୍‌ଦାନାନ୍‍, ଆରେ ଇନେର୍‌ ନାଙ୍ଗେଙ୍ଗ୍‌ ଇଡ଼୍‌ଦାନାନ୍‍, ହେୱାନ୍‌ ନା ପକ୍‌ତାକାନିଂ ଇଡ଼୍‌ତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","ଇନେନ୍‌ ବେଣ୍‌ବାକ୍‌ଣାୟ୍‌କିନାକାନିଂ ଇସ୍ୱର୍‌ କାବୁର୍‌ ଅନାକାନ୍‌ ଇଞ୍ଜି ଇଡ଼୍‌ନାନ୍‌, ହେୱାନ୍‌ ବେଣ୍‌ବାକ୍‌ଣାୟ୍‌କିନାକାନ୍ତି ଇନାମ୍‌ ପାୟା ଆନାନ୍‌ । ଆରେ ଇନେନ୍‌ ଦାର୍ମି ଇଞ୍ଜି ଇଡ଼୍‌ନାନ୍‌, ହେୱାନ୍‌ ଦର୍ମି ଲକାର୍ତି ଇନାମ୍‌ ପାୟାନାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","ଆରେ, ଇନେନ୍‌ ଇ ହିରୁକାର୍‌ ବିତ୍ରେ ରୱାନିଂ ନା ଚେଲା ଇଞ୍ଜି କେବଲ୍‌ ର ଗିନା କାକାର୍‌ ଏଜ଼ୁଂ ଉଣ୍ଡେଙ୍ଗ୍‌ ହିନାନ୍‌, ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ହାତ୍‌ପା ଇଞ୍ଜ୍‌ନାଙ୍ଗା ଇନେସ୍‌କି ହେୱାନ୍‌ ନା ଚେଲା ହାତ୍‌ପା ଇନାମ୍‌ ପାୟାନାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","ଜିସୁ ତା ବାରଜାଣ୍‌ ଚେଲାରିଂ ବଲ୍‌ ହିଜ଼ି ୱିସ୍ତି ପାଚେ ହେ ବାହା ପିସ୍‌ସି ଲାଗାଂନି ଗାଡ଼୍‌କାଂ ହାଲ୍‌ଜି ସୁଣାୟ୍‌ କିଦେଙ୍ଗ୍‌ ଲାଗାତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","ଇବେଣ୍ଡାଂ ଜହନ୍‌ କ୍ରିସ୍ଟତି କାମାୟ୍‌ନି ବିସ୍ରେ ଜଇଲ୍‌ତ ୱେନ୍‌ଞ୍ଜି ଜାର୍‌ ଚେଲାହିରିଂ କ୍ରିସ୍ଟ ଲାଗାଂ ପକ୍‌ତାନ୍‌, ");
INSERT INTO peg_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","ହେୱାର୍‌ ହାଲ୍‌ଜି ଜିସୁଙ୍ଗ୍‌ ୱେନ୍‌ବାତାର୍‌, “ଇନେର୍‌ ୱାନାକା ମାନାତ୍‌, ହେୱାନ୍‌ କି ଏନ୍‌, ଆକାୟ୍‌ଚି ଆପେଂ ଆଲ୍‌ଗା ନିକାନିଂ କାଜିଂ ମାନାପ୍‌ ?” ");
INSERT INTO peg_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","ଜିସୁ ହେୱାରିଂ ଉତର୍‌ ହିତାନ୍‌, “ଏପେଙ୍ଗ୍‌ ହାଲ୍‌ଜି, ଇନା ଇନାକା ୱେଚାଦେର୍ଣ୍ଣା ଆରି ହୁଡ଼୍‌ନାଦେରା, ହେ ଜହନ୍‌ତିଂ ୱେଚାଟ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","କାଣାର୍‌ କାଣ୍‌କୁ ହୁଡ଼୍‌ନାର୍‌, ମେଟାର୍‌ ତାଂନାର୍‌, ଗାଜା ରଗ୍ୟାର୍‌ ସକଟ୍‌ ଆନାର୍‌, ବଇରାର୍‌ ୱେନାର୍‌, ହାତାକାର୍‌ ନିଙ୍ଗ୍‌ନାର୍‌, ଆରେ ହିଲ୍‍ୱାକାର୍‍ ତାକେ ନେକ୍ରିକାବୁର୍‌ ସୁଣାୟ୍‌ କିୟାଆନାତ୍‌; ");
INSERT INTO peg_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","ଆରେ, ଆରେ ଇମ୍‌ଣି ମାନାୟ୍‌ ନାତାକେଣ୍ଡାଂ ବାଦା ପାୟା ଆଉନ୍‌, ହେୱାନ୍‌ ଦନ୍ୟ ।” ");
INSERT INTO peg_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","ହେୱାର୍‌ ତାଙ୍ଗ୍‌ଜି ହାନିହିଂ ଜିସୁ ଜହନ୍‌ ବିସ୍ରେ ମାନାୟାରିଂ ଇଞ୍ଜେଙ୍ଗ୍‌ ଲାଗାତାନ୍‌, ହୁଡ଼୍‌ଦେଂ ଇଞ୍ଜି ଏଚେକାଡ଼୍‌ଦ ବାଟାତ ହାଲ୍‌ଜି ମାଚାଦେର୍‌ ? ଇନାକା ହୁଡ଼୍‌ଦେଂ ହାଲ୍‌ଜି ମାଚାଦେର୍‌ ? ଇନାକା ଦୁକାତିଙ୍ଗ୍‌ ଜଲାଆନି ନାଡ଼ା ? ");
INSERT INTO peg_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","ହେଦାଂ ଆୱିତିସ୍‌ ଏପେଙ୍ଗ୍‌ ଇନାକା ହୁଡ଼୍‌ଦେଂ ହସି ହାଲ୍‌ଜି ମାଚାଦେର୍‌ ? ଇନାକା ଦାମ୍‌ନି ହେନ୍ଦ୍ରା ଉସ୍ପିତି ର ମାନାୟ୍‌ତିଂ ? ହୁଡ଼ାଟ୍‌, ଇନେର୍‌ ଦାର୍ଜାହେନ୍ଦ୍ରା ଉସ୍ପିସ୍‌ ମାନାର୍‌, ହେୱାର୍‌ ରାଜା ଇଞ୍ଜ ମାନ୍‌ଗାନାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","ହେଦାଂ ଆୱିତିସ୍‌ ଇନାକିଦେଂ ହସି ହାଲ୍‌ଜି ମାଚାଦେର୍‌ ? ଇନାକା ରୱାନ୍‌ ବେଣ୍‌ବାକ୍‌ଣାୟ୍‌କିନାକାନିଂ ହୁଡ଼୍‌ଦେଂ ? ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ହାତ୍‌ପା ଇଞ୍ଜ୍‌ନାଙ୍ଗା, ବେଣ୍‌ବାକ୍‌ଣାୟ୍‌କିନାକାନ୍‌ତାଂ ଆଦିକ୍‌ ଗାଜା ମାନାୟ୍‌ତିଂ ହୁଡ଼୍‌ତାଦେର୍ଣ୍ଣା । ");
INSERT INTO peg_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","ଇନାବିସ୍ରେ ଇଦାଂ ଲେକା ମାନାତ୍‌, ହୁଡ଼ାଟ୍‌ ଆପେଂ ଦୁତ୍‌ତିଂ ମି ତାକେ ପକ୍‌ତା ନାପା, ହେୱାନ୍‌ ମି କାଜିଂ ମେହାଜ଼ି ରଚ୍‌ଚି ହିଦ୍‌ନାନ୍‌ ଇୱାନ୍‌ ହେ ମାନାୟ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ହାତ୍‌ପା ଇଞ୍ଜ୍‌ନାଙ୍ଗା, ପୁର୍ବେତାଂ ନଙ୍ଗ୍‌ ପାତେକ୍‌ ଇ ପୁର୍ତିନି ଏଚେ ଜାଣ୍‌ ଚଞ୍ଚାର୍‌ନା, ଜହନ୍‌ ତାଙ୍ଗ୍‌ ଗାଜାକାନ୍‌ ଇନେର୍‌ ହିଲୁର୍‌ । ମାତର୍‌ ସାର୍ଗେ ରାଜିତ ଇନେନ୍‌ ୱିଜ଼ାର୍‌ତାଂ ହିରୁକାନ୍‌, ହେୱାନ୍‌ ବାପ୍ତିସିମ୍‌ ଜହନ୍‌ତାଂ ଗାଜାକାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","ଆରେ, ବାପ୍ତିସିମ୍‌ ଜହନ୍‌ ସମୁତାଂ ନଙ୍ଗ୍‌ ପାତେକ୍‌ ସାର୍ଗେ ରାଜି ସାକ୍ତିତାଂ କାଟ୍ରା ଆନାରା; ଆରେ, ସାକ୍ତିତାଂ କାଟ୍ରାନାକାର୍‌; ବାଡ଼୍‌କାସ୍‌ତାଂ ହେଦାଂ ଆଦିକ୍‌ କିନାରା । ");
INSERT INTO peg_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","ଇନାକିଦେଂକି ୱିଜ଼ାର୍‌ ବେଣ୍‌ବାକ୍‌ଣାୟ୍‌କିନାକାର୍‌ ଆରି ବିଦିନି ସାସ୍ତର୍‌ ଜହନ୍‌ ୱାନି ଦିନ୍‌ ପାତେକ୍‌ ମସାତି ବିଦି ବେଣ୍‌ବାକ୍‌ଣାୟ୍‌କିନାକାନ୍‌ ବିସ୍ରେ ଇଞ୍ଜି ମାଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","ଆରେ, ଏପେଙ୍ଗ୍‌ ଏଚେକାଡ଼୍‌ଦ ଇଡ୍‌ଦେଂ ମାନ୍‌ କିନାଦେର୍‌, ଲାଗିଂ ଇ ଜହନ୍‌ ଆନାନା, ହେୱାନ୍‌ ଏଲିୟ । ");
INSERT INTO peg_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","ଇନେରିଂ କିତୁଲିଂ ମାନିକ୍‌, ହେୱାନ୍‌ ୱେନେନ୍‌ ! ");
INSERT INTO peg_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“ମାତର୍‌ ଆନ୍‌ ଇନେର୍‌ ଲାହାଙ୍ଗ୍‌ ନଙ୍ଗ୍‌ନି ମାନାୟାରିଂ ତୁଲାୟ୍‌ କିନାଙ୍ଗ୍‌ ? ଇମ୍‌ଣି କାଡ଼୍‌ଦେର୍‌ ଆଟ୍‌ ପାଦାତ କୁଚ୍‌ଚି ବିନେନିକାରିଂ କୁକ୍‌ଚି ଇନାର୍‌, ");
INSERT INTO peg_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","ଆପେଂ ମି ତାକେ ହୁରୁଡ଼ି ତୁବ୍‌ତାପ୍‌, ଏପେଙ୍ଗ୍‌ ଏନ୍ଦ୍‌ୱାତାଦେର୍‌; ଆପେଂ ଦୁକ୍‍କିତାପ୍‍, ଏପେଙ୍ଗ୍‌ ନେଞ୍ଜେଡାକିତ ଇଡ଼ିୟା ଆୱାତାଦେର୍‌, ନଙ୍ଗ୍‌ନି ନାର୍‌ ହେୱାର୍‌ ଲାକେ । ");
INSERT INTO peg_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","ଇନାକିଦେଂକି ଜହନ୍‌ ୱାଜ଼ି ତିନ୍‌ୱାତାନ୍‌ କି ଉଣ୍‌ୱାତାନ୍‌, ଆରେ ଲକୁ ଇନାରା, ହେୱାନ୍‌ ପୁଦା ଆସ୍ତାତ୍‌ନା । ");
INSERT INTO peg_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","ମାନାୟ୍‌ ମାଜ଼ି ୱାଜ଼ି ତିନାଉଣା କିନାନ୍‌, ଲକୁ ୱିଜ଼ାର୍‌ ଇନାର୍‌, ହୁଡ଼ାଟ୍‌, ଇୱାନ୍‌ ରକାନ୍‌ ବାତ୍‌ୱା ଆରି ମାତ୍‌ଲି, ସିସ୍ତୁଏନ୍‌ନାକାର୍‌ ଆରେ ପାପିର୍‌ ହାଙ୍ଗ୍‌ଦାକାନ୍‌; ମତର୍‌ ଇସ୍ୱର୍‌ ଗିଆନି ଜାର୍‌ କାମାୟ୍‌ ତାଙ୍ଗ୍‌ ସମାନ୍‌ ଇଞ୍ଜି ପାର୍ମାଣ୍‌ ଆତାତ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","ଏଚେକାଡ଼୍‌ଦ ଇମ୍‌ଣି ଇମ୍‌ଣି ଗାଡ଼୍‌ଦ ତା ଆଦିକାର୍‌ ସାକ୍ତିନି କାମାୟ୍‌ କିୟାଆଜ଼ି ମାଚାତ୍‌, ହେୱାନ୍‌ ହେ ଗାଡ଼୍‌ତିଙ୍ଗ୍‌ ହେୱାନ୍‌ ନିନ୍ଦା କିଦେଙ୍ଗ୍‌ ଲାଗାତାନ୍‌, ଇନାକିଦେଂକି ହେୱାର୍‌ ମାନ୍‌ବାଦ୍‌ଲାୟ୍‌ କିୱାଦାଂ ମାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“ଏ ଡାଣ୍ଡ୍‌ନି କରାଜିନ୍‌, ଏ ଡାଣ୍ଡ୍‌ନି ବେତ୍‌ସାଇଦା, ଇନାକିଦେଂକି ମି ବିତ୍ରେ ଇମ୍‌ଣି ଇମ୍‌ଣି ସାକ୍ତିନି କାମାୟ୍‌ କିୟାତାତ୍‌ନା, ହେଦାଂ ୱିଜ଼ୁ ଇନାୱାଡ଼ାଂ ସର ଆରି ସିଦନ୍‌ ତାକେ କିଆତାତ୍‍ମା, ଲାଗିଂ ହେୱାର୍‌ ବେସିଦିନ୍‌ ପୁର୍ବେତାଂ ବାସ୍ତା ଉସ୍ପିସ୍‌ ନିସ୍‌ତାକେ କୁଚ୍‌ଚି ମାନ୍‌ବାଦ୍‌ଲାୟ୍‌ କିତାର୍ମା । ");
INSERT INTO peg_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","ଆତିସ୍‌ପା ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ଇଞ୍ଜ୍‌ନାଙ୍ଗା, ଇସ୍ୱର୍ତି ବିଚାର୍‌ ନାଜିଂ ମି ବାଟା ସର ଆରି ସିଦନ୍‌ନି ମାନାୟାରିଂ ଆଦିକ୍‌ ଦୟା ଚଚ୍‌ଚାନାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","ଆରେ, ଆଡ଼େ କପର୍ନାହୁମ୍‌, ନିକାଦେର୍‌ ଏପେଙ୍ଗ୍‌ ଜାର୍‌ତିଂ ସାର୍ଗେ ପାତେକ୍‌ ଲାମା ଆଦେଂ ଆଡ୍‌ନାୟ୍‌ ? କୱାଣ୍‌ ପାତାଲ୍‌ନି ଆଦାହାନାକା ଆନାତ୍‌, ଇନାକିଦେଂକି ନି ବିତ୍ରେ ଇମ୍‌ଣି ଇମ୍‌ଣି ସାକ୍ତିନି କାମାୟ୍‌ କିୟାତାତ୍‌ନା, ହେଦାଂ ୱିଜ଼ୁ ଏଚେକାଡ଼୍‌ଦ ସଦମ୍‌ ତାକେ କିଆତାତ୍‍ମା, ଲାଗିଂ ହେଦାଂ ନେଞ୍ଜେଙ୍ଗ୍‌ ପାତେକ୍‌ ମାନ୍‌ଗାତାତ୍‌ମା । ");
INSERT INTO peg_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ହାତ୍‌ପା ଇଞ୍ଜ୍‌ନାଙ୍ଗା, ଇସ୍ୱର୍‌ ବିଚାର୍‌ କିନାନ୍‌ ନିଙ୍ଗ୍‌ ତାଙ୍ଗ୍‌ ନି ଦସ୍‌ ବାଟା ସଦମ୍‌ ଦେସ୍‌ନି ଦସ୍‌ ବେସି ଆନାତ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","ହେୱାଡ଼ାଂ ଜିସୁ ପାର୍ତାନା କିଜ଼ି ଇଚାନ୍‌, ଏ ଆବା, ସାର୍ଗେ ଆରି ପୁର୍ତିତ ମାପ୍ରୁ, ଏପେଙ୍ଗ୍‌ ଗିଆନି ଆରି ବୁଦିୟା ମାନାୟାର୍‌ ତାଙ୍ଗ୍‌ ଇ ୱିଜ଼ୁ ବିସ୍ରେ ଡ଼ୁକ୍‌ଚି ଇଡ଼୍‌ଜି ହିମ୍‍ଣାଙ୍ଗ୍‍ତାକେ ୱେଚ୍‍ଚାୟ୍‌ନା, ଇଦାଂ କାଜିଂ ନି ଜୁୱାର୍‌ କିଦ୍‌ନାଙ୍ଗା; ");
INSERT INTO peg_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","ଆଁ ଆବା, ଇନାକିଦେଂକି ଇଦାଂ ନି କାଣ୍‌କୁତାଂ ଏଚେକ୍‌ସାରି ଆତାତ୍‌ନ୍ନା । ");
INSERT INTO peg_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","ନା ଆବା ନାଙ୍ଗେଙ୍ଗ୍‌ ୱିଜ଼ୁ ବିସ୍ରେ ନାବେ ସର୍‌ପି ଆତାତ୍‌ନ୍ନା । ଆବାଂ ପିସ୍ତି ମାଜ଼ି ଆରେ ଇନେର୍‌ ପୁନୁର୍‌ ଆରି ମାଜ଼ି ପିସ୍ତି ଆବା ଆରେ ଇନେର୍‌ ପୁନୁର୍‌ । ମାଜ଼ି ଇମ୍‌ଣାକାର୍‌ ତାକେ ଆବାଂ ହପ୍‌ନାନ୍‌, କେବଲ୍‌ ହେୱାର୍‌ ଆବାଂ ପୁଞ୍ଜେଙ୍ଗ୍‌ ଆଡ୍‌ନାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“ଏ ୱାହ୍‌ନାକାଦେର୍‌ ଆରି ବଜ୍‌ପିଣ୍ଡ୍‌ତି ମାନାୟ୍‌ ନା ତାକେ ୱାଡୁ, ଆନ୍‌ ମିଙ୍ଗ୍‌ ଜମ୍‌ଦେଂ ହିଦ୍‌ନାଂ । ");
INSERT INTO peg_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","ନା ଜୁୱାଣ୍ଡ୍‌ ଜାର୍‌ ଜାର୍‌ ଜପି ପିଣ୍ଡ୍‌ଜି, ଆରେ, ନା ତାକେ ହିକ୍ୟା କିୟାଟ୍‌, ଇନାକିଦେଂକି, ଆନ୍‌ ହୁଦାର୍‌ ଆରି ଦାର୍ମି, ଆରେ ଏପେଙ୍ଗ୍‌ ଜାର୍‌ ଜାର୍‌ ୱାସ୍କିତ ଜମ୍‌ନାଦେର୍‌; ");
INSERT INTO peg_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","ଆନ୍‌ ମି ଜପି ଇମ୍‌ଣି ଜୁୱାଣ୍ଡ୍‌ ଇଟ୍‍ନାଂ, ହେଦାଂ ପିଣ୍ଡ୍‌ଦେଂ ଆଡ଼୍‌ୱା । ଆରେ ମିଙ୍ଗ୍‌ ଇମ୍‌ଣି ବଜ୍‌ ହିଦ୍‌ନାଂ, ହେଦାଂ ବେସି ଉସାସ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","ହେୱାଡ଼ାଂ ଜିସୁ ଜମ୍‌ନିବାର୍‌ ନାଜିଂ ତାସ୍‌ ଜମିତିଂ ହିଜ଼ି ତାଙ୍ଗ୍‌ଜି ହାଲ୍‌ଜି ମାଚାନ୍‌, ଆରେ ତା ଚେଲାହିର୍‌ ନାସ୍‌କି ଆଜ଼ି ତାସ୍‌ନି ଜିକି ନାଡ଼୍‌ଚି ଚିଞ୍ଜେଙ୍ଗ୍‌ ଲାଗାତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","ମାତର୍‌ ପାରୁସିର୍‌ ହେଦାଂ ହୁଡ଼୍‌ଜି ଜିସୁଙ୍ଗ୍‌ ଇଚାର୍‌, “ହୁଡ଼ାଟ୍‌, ଜମ୍‌ନିବାର୍‌ ନାଜିଂ ଇନାକା କିନି ବିଦି ଆକାୟ୍‌, ହେଦାଂ ନି ଚେଲାର୍‌ କିନାରା ।” ");
INSERT INTO peg_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","ମତର୍‌ ହେୱାନ୍‌ ହେୱାରିଂ ଇଚାନ୍‌, “ଦାଉଦ୍‌ ଆରି ତା ହାଙ୍ଗ୍‌ଦାକାର୍‌ ନାସ୍‌କି ଆନିହିଙ୍ଗ୍‌ ହେୱାନ୍‌ ଇନାକା କିଜ଼ି ମାଚାନ୍‌, ହେଦାଂକି ଏପେଙ୍ଗ୍‌ ପଡ଼ି କିୱାତାଦେର୍ଣ୍ଣା ? ");
INSERT INTO peg_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","ହେୱାନ୍‌ ଇନେସ୍‌ କିଜ଼ି ଇସ୍ୱର୍‌ ଇଞ୍ଜ ହଣ୍‌ଜି, ଇମ୍‌ଣି ଦର୍ସନି ରୁଟି କେବଲ୍‌ ମାପ୍ରୁହେବାକିନାକାର୍‌ ତିନି ବିଦି ମାଚାତ୍‌, ମାତାର୍‌ ତା ଆରି ସାଙ୍ଗହିର୍‌ ତିକାନା ବିଦି ହିଲ୍‌ୱାତାତ୍‌, ହେଦାଂ ହେୱାର୍‌ ଚିଞ୍ଜି ମାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","ମାତର୍‌ ଜମ୍‌ନିବାର୍‌ ନାଜିଂ ମାପ୍ରୁହେବାକିନାକାର୍‌ ମନ୍ଦିର୍‌ ବିତ୍ରେ ଜମ୍‌ନିବାର୍‌ତିଂ ବିଟାଡ଼୍‌ କିୱିତିସ୍‌ ପା ହେୱାର୍‌ ଦସ୍‌ ଆଉର୍‌, ବିଦିତାଂ ଏପେଙ୍ଗ୍‌ ଇନାକା ଇଦାଂ ପଡ଼ି କିୱାତାଦେର୍ଣ୍ଣା ? ");
INSERT INTO peg_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","ମତର୍‌ ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ଇଞ୍ଜ୍‌ନାଙ୍ଗା, ମନ୍ଦିର୍‌ ତାଙ୍ଗ୍‌ ଗାଜା ବିସ୍ରେ ଇବେ ମାନାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","ସାସ୍ତର୍‌ ଇନାତ୍‌ ଆନ୍‌ ପୁନାଙ୍ଗ୍‌ ପୁଜା ମାନ୍‌ କିୱାଦାଂ ଦୟା ମାନ୍‌ କିନାଙ୍ଗ୍‌, ଇ କାତାନି ଅରତ୍‌ ଜଦି ସତ୍‌ ବୁଜାନାଦେର୍‌ ଦସିଲଗାରିଂ ଏପେଙ୍ଗ୍‌ ଦସ୍‌ କିୱାତାଦେର୍‌ମା । ");
INSERT INTO peg_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","ଇନାକିଦେଂକି ମାନାୟ୍‌ ମାଜ଼ି ଜମ୍‌ନିବାର୍‌ ନାଜିଂ ପା ମାପ୍ରୁ ଆନାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","ଜିସୁ ହେ ବାହାତାଂ ହାଲ୍‌ଜି ହେୱାର୍‌ କୁଟୁମ୍‌ ଇଞ୍ଜ ହଣ୍‌ଗାତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","ଆରେ ହୁଡ଼ାଟ୍‌, ହେବେ ରୱାନ୍‌ ଲକ୍‌ ମାଚାନ୍‌, ତା ର କେଇ ୱାଜ୍‌ଜି ମାଚାତ୍‌ । ଆରେ, ହେୱାର୍‌ “ତା ବେରଣ୍‌ତାଂ ଦାବା କିନି ହେଦାଂ କାଜିଂ ଜିସୁଙ୍ଗ୍‌ ୱେନ୍‌ବାତାର୍‌, ଜମ୍‌ନିବାର୍‌ ନାଜିଂ ଉଜ୍‌ କିନାକା ଇନାକା ବିଦି ମାନାତ୍‌ ?” ");
INSERT INTO peg_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","ମାତର୍‌ ଜିସୁ ହେୱାରିଂ ଇଚାନ୍‌, ଜଦି “ଇନେର୍‌ତି ରଞ୍ଜାଙ୍ଗ୍‌ ମେଣ୍ଡା ମାନାତ୍‌ ଆରି ହେଦାଂ ଜମ୍‌ନିବାର୍‌ ନାଜିଂ କୁଇତାକେ ଆର୍ତିସ୍‌ ଇନାକା ହେଦେଲିଂ ଜେ ତାଙ୍ଗେଙ୍ଗ୍‌ ଆସ୍ତି ନିକୁନ୍‌, ଏଲେଙ୍ଗ୍‌ ମାନାୟ୍‌ ମି ବିତ୍ରେ ଇନେନ୍‌ ମାନାନ୍‌ ? ");
INSERT INTO peg_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","ଲାଗିଂ, ମେଣ୍ଡା ତାଙ୍ଗ୍‌ ମାନାୟ୍‌ ଆରେ ଏଚେକ୍‌ ଆଦେକ୍‌ ଗାଜା । ବିଦି ଲାକେ ଜମ୍‌ନିବାର୍‌ ନାଜିଂ ହାର୍‌ କିନାକା ବିଦି ମାନାତ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","ହେୱାଡ଼ାଂ ହେୱାନ୍‌ ହେ ମାନାୟ୍‌ତିଂ ଇଚାନ୍‌, ନି କେଇ ଲାମାୟ୍‍ କିଦା । ହେବେ ହେୱାନ୍‌ କେଇ ଲାମାୟ୍‌ କିତାନ୍‌, “ଆରେ ହେଦାଂ ଅଲ୍‌ଗା କେଇ ଲାକେ ଆରେ ହାରା ଆତାତ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","ମାତର୍‌ ପାରୁସିର୍‌ ବାର୍ତ ହାଲ୍‌ଜି ହେୱାନିଂ ବୁଡାୟ୍‌ କିନି କାଜିଂ ତା ବେରଣ୍‌ତାଂ ମାନ୍‌ପାଚି କିତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","ଜିସୁ ହେଦାଂ ପୁଞ୍ଜି ହେବେତାଂ ହେ ବାହା ପିସ୍ତି ହସି ହାଚାନ୍‌, ହେନି ତା ପାଚେ ପାଚେ ହାଚାର୍‌, ଆରେ ହେୱାନ୍‌ ୱିଜ଼ାର୍‌ ରଗ୍ୟାରିଂ ଉଜ୍‌ କିତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","ଆରେ, ତାଙ୍ଗେଙ୍ଗ୍‌ ୱେଚ୍‌ୱି କାଜିଂ ହେୱାନ୍‌ ହେ ବାନ୍ୟା ପୁଦାକାଂ ବେସି ଡାଟ୍‌ କିଜ଼ି ବଲ୍‌ ହିତାନ୍‌, ");
INSERT INTO peg_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","ଇନେସ୍‌କି ଜିସାୟ୍‌ ବେଣ୍‌ବାକ୍‌ଣାୟ୍‌ କାଜିଂ ଏକାତାର୍‌ ପୁରା ଆନାତ୍‌, ");
INSERT INTO peg_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“ହୁଡ଼ାଟ୍‌, ମା ଆଡ଼ିଏନ୍‌, ଇନେରିଂକି ଆପେଙ୍ଗ୍‌ ବାଚି କିତାପ୍‌ନ୍ନା; ମା ୱାରିନି ମାଜ଼ି ଇନେର୍‌ ତାକେ କି ଆପେଂ ଜିବୁନ୍‌ନି ବେସି ୱାରି ଆସେଙ୍ଗ୍‌ ତା ଜପି ନା ଜିବୁନ୍‌ ଜୁଦ୍‌ନାତ୍‌, ଆରେ ହେୱାନ୍‌ ପାର୍ତିକିୱି ଜିହୁଦିର୍‌ ଲାଗାଂ ନ୍ୟାୟ୍‌ ବିଚାର୍‌ କିଜ଼ି ସୁଣାୟ୍‌ କିନାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","ହେୱାନ୍‌ କୁର୍ଲି କିଉନ୍‌ କି ଗାଜା କାଟ୍‌ ସୁଣାୟ୍‌ କିଉନ୍‌, କି ହାକ୍‌ଡ଼ିତ ହେୱାନ୍ତି କାଟ୍‌ ଇନେର୍‌ ୱେନୁର୍‌ ");
INSERT INTO peg_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","ନାଦାର୍‌ କାଟାକାରିଂ କାଜିଂ ହେୱାନ୍‌ ହୁଦାର୍‌ ବେବାର୍‌ କିନାନ୍‌ ନାଡ଼ା ଆରି ସାଇଜ ହିଲ୍‌ୱାକାରିଂ ଉପ୍‌କାର୍‌ କିନାନ୍‌ । ନ୍ୟାୟ୍‌ ବିଚାର୍‌ ଆୱି ପାତେକ୍‌ ହେୱାନ୍‌ କି ସଦୁମ୍‌ ନୁଲ୍‌କଦାନି ବଇଟାତିଂ ପାଗୁନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","ଆରେ ତା ତର୍‌ଦ ପାର୍ତିକିୱି ଜିହୁଦିର୍‌ ଆହା କିତାର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","ହେୱାଡ଼ାଂ ରୱାନ୍‌ ପୁଦା ଆହ୍‌ୟାତି କାଣାଂ ଆରି କନ୍ଦାଲଗାଂ ତା ତାକେ ତାହିୱାତାର୍‌, ଆରେ ଜିସୁ ତାଙ୍ଗେଙ୍ଗ୍‌ ଉଜ୍‌ କିତାନ୍‌; ହେବେ ହେ କନ୍ଦା ବେଣ୍‌ ଇଞ୍ଜେଙ୍ଗ୍‌ ଆଡ଼୍‌ତାନ୍‌ ଆରି ହୁଡ଼୍‌ଦେଂ ଆଡ଼୍‌ତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","ଆରେ, ମାନାୟାର୍‌ କାବା ଆଜ଼ି ଇଞ୍ଜେଙ୍ଗ୍‌ ଲାଗାତାର୍‌, “ଇୱାନ୍‌ ଇନାକା ଦାଉଦ୍‌ ମାଜ଼ି ଆକାୟ୍‌ ?” ");
INSERT INTO peg_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","ମତର୍‌ ପାରୁସିର୍‌ ହେଦାଂ ୱେନ୍‌ଞ୍ଜି ଇଚାର୍‌, “ଇ ମୁଣିକା ଗାଜାପୁଦା ବାଲ୍‌ଜିବୁଲ୍‌ ଉପ୍‌କାର୍‌ତାଂ ପୁଦାଂ ପିହିକିଉନା ।” ");
INSERT INTO peg_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","ମାତର୍‌ ଜିସୁ ହେୱାର୍‌ ମାନ୍ତି ଏତ୍‌ ପୁଞ୍ଜି ହେୱାରିଂ ଇଚାନ୍‌, “ଇମ୍‌ଣି ରାଜି ରିବାଗ୍‌ ଆଜ଼ି ଜାର୍‌ ବେରୁତାଂ ନିଙ୍ଗ୍‌ନାତ୍‌, ହେଦାଂ ଦୁଡ଼ି ଆଜ଼ି ହାନାତ୍‌; ଆରେ, ଇମ୍‌ଣି ଗାଡ଼୍‌ କି ଇଲ୍‌ ରିବାଗ୍‌ ଆଜ଼ି ଜାର୍‌ ବେରୁତାଂ ନିଙ୍ଗ୍‌ନାତ୍‌ ହେଦାଂ ତିର୍‌ ଆଜ଼ି ମାଞ୍ଜେଙ୍ଗ୍‌ ଆଡୁତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","ଆରେ, ସୟ୍‌ତାନ୍‌ ଜଦି ସୟ୍‌ତାନ୍‌ତିଂ ପିହିକିତିସ୍‌, ତା ଆତିସ୍‌ ହେଦାଂ ରିବାଗ୍‌ ଆଜ଼ି ଜାର୍‌ ବିରୁତ୍‌ତାଂ ନିଙ୍ଗ୍‌ତାତେ; ଲାଗିଂ ତା ରାଜି ଇନେସ୍‌ ତିର୍‌ ଆଜ଼ି ମାନାତ୍‌ ? ");
INSERT INTO peg_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","ଆନ୍‌ ଏଚେକାଡ଼୍‌ଦ ବାଲ୍‌ଜିବୁଲ୍‌ ଉପ୍‌କାର୍‌ତାଂ ପୁଦାକାଂ ପିହିକିନାଙ୍ଗ୍‌, ଲାଗିଂ ମି ମାଜ଼ିର୍‌ ଇନେର୍‌ ଉପ୍‌କାର୍‌ତାଂ ହେୱାକାଂ ପିହିକିନାର୍‌ । ଲାଗିଂ ହେୱାର୍‌ ନେ ମିଙ୍ଗେଙ୍ଗ୍‌ ବିଚାର୍‌କାର୍‌ୟାର୍‌ ଆଦ୍‌ନାର୍‌ ! ");
INSERT INTO peg_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","ମାତର୍‌ ଆନ୍‌ ଜଦି ଇସ୍ୱର୍‌ ୱାସ୍କି ସାଇଜତାଂ ପୁଦାକାଂ ପିହିକିନାଙ୍ଗ୍‌, ଇଦାଂ କାଜିଂ ପାର୍ମାଣ୍‌ ଆନାତ୍‌ ସାର୍ଗେ ରାଜି ମି କାଜିଂ ଏକା ୱାତାତେ ।” ");
INSERT INTO peg_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“କି ଇନେର୍‌ ପର୍ତୁମ୍‌ ସାକ୍ତି ଲଗାଂ ଗାଚ୍‌ୱିତିସ୍‌ ଇନେସ୍‌ କିଜ଼ି ତାଞ୍ଜ ହଣ୍‌ଗିସ୍‌ ତା ଦାନ୍‌ ସବୁ ଚର୍‌ କିଦେଙ୍ଗ୍‌ ଆଡ୍‌ନାନ୍‌ ? ତାଙ୍ଗେଙ୍ଗ୍‌ ଆଗେ ଗାଚ୍‌ଚିସ୍‌ ହିନା ତା ଇଲ୍‌ ଚର୍‌ କିଦେଙ୍ଗ୍‌ ଆଡ୍‌ନାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“ଇନେନ୍‌ ନା ପାକ୍ୟା ଆକାୟ୍‌, ହେୱାନ୍‌ ନା ବେରିୟା, ଆରେ ଇନେନ୍‌ ନାଲାହାଂ ରୁଣ୍ଡାୟ୍‌ କିଉନ୍‌, ହେୱାନ୍‌ ଜେଡ଼େ କେତେ କିନାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","ଆତିସ୍‌ପା, ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ଇଞ୍ଜ୍‌ନାଙ୍ଗା ମାନାୟାର୍‌ ୱିଜ଼ୁ ପାପ୍‌ ଆରି ନିନ୍ଦା କାତା କେମା କିୟା ଆନାତ୍‌, ମାତର୍‌ ୱାସ୍କି ବେରୁ ନିନ୍ଦା କେମା କିୟା ଆଉତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","ଆରେ, ଇନେର୍‌ ଆୟେତ୍‌ ମାନାୟ୍‌ ମାଜ଼ି ବେରୁତାଂ କାତା ଇନାନ୍‌, ତାଙ୍ଗେଙ୍ଗ୍‌ କେମା ହିୟା ଆନାତ୍‌, ମାତର୍‌ ଇନେର୍‌ ଆୟେତ୍‌ ପୁଇପୁୟା ଜିବୁନ୍‌ ବେରୁତାଂ କାତା ଇନାନ୍‌, ଇ ଜୁଗ୍‌ତ କି ପାଚେନି ଜୁଗ୍‌ତ ତାଙ୍ଗେଙ୍ଗ୍‌ କେମା ହିୟା ଆଉତ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“ହାର୍ଦି ପାଡ଼୍‌ ଆହ୍‌ନି କାଜିଂ ମାର୍‌ ବାଡ଼୍‌କାସ୍‌ ଆନାକା ମାନାତ୍‌ । ମିଦାଙ୍ଗ୍‌ ବାନ୍ୟା ମାର୍‌ ମାଚିସ୍‌ ହେବେତାଂ ଏପେଙ୍ଗ୍‌ ବାନ୍ୟା ପାଡ଼୍‌ ପାୟା ଆନାଦେର୍‌ । ଇନାକିଦେଂକି ପାଡ଼୍‌ କାଜିଂ ମାର୍‌ତିଂ ପୁନ୍ୟା ଆନାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","ଆଡ଼େ କାଲାଟିରାଚ୍‌ନି ଲାତ୍ରା, ଏପେଙ୍ଗ୍‌ ବାନ୍ୟା ଆଜ଼ି ଇନେସ୍‌ ବାର୍ତି ହାର୍‌ଦି କାତା ଇଞ୍ଜେଙ୍ଗ୍‌ ଆଡ୍‌ନାଦେର୍‌ ? ଇନାକିଦେଂକି ମାନ୍‌ନି ବାର୍ତିତାଂ ୱେଇଦି କାତା ଇନାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","ହାର୍ଦି ଲଗୁ ହାର୍‌ଦି ୱାସ୍କିତାଂ ହାର୍ଦି ଆଡ଼୍‌ମାଡ଼୍‌ ହପ୍‌ନାନ୍‌ । ଆରେ ବାନ୍ୟା ଲଗୁ ବାନ୍ୟା ୱାସ୍କିତାଂ ବାନ୍ୟା ଆଡ଼୍‌ମାଡ଼୍‌ ହପ୍‌ନାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“ମାତର୍‌ ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ଇଞ୍ଜ୍‌ନାଙ୍ଗା, ମାନାୟାର୍‌ ଇନେସ୍‌ ବାର୍ତି ପଲ୍ୟା କାତା ଇନାର୍‌, ବିଚାର୍ଣ୍ଣା-ନାଜିଂ ହେୱାର୍‌ ହେବେନି ଉତର୍‌ ହିନାର୍‌; ");
INSERT INTO peg_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","ମି କାତା କାଜିଂ ଏପେଙ୍ଗ୍‌ ବିଚାର୍‌ କିୟା ଆଜ଼ି ଦସିଆକାଇ ଦସି ଇଞ୍ଜି ପାର୍ମାଣ୍‌ ଆନାତ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","ହେ ପାଦ୍‌ନା ସାସ୍ତ୍ରିର୍‌ ଆରି ପାରୁସିର୍‌ ବିତ୍ରେ କେତ୍‌ ଜାଣ୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ଉତର୍‌ ହିତାର୍‌, “ଏ ଗୁରୁ, ଆପେଂ ନିତାକେନ୍‌ଣ୍ଡାଙ୍ଗ୍‌ ର ଚିନ୍‌ ହୁଡ଼୍‌ଦେଂ ମାନ୍‌କିନାପା ।” ");
INSERT INTO peg_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","ଜିସୁ ହେୱାରିଂ ଉତର୍‌ ହିତାନ୍‌, “କେତେକ୍‌ ଦାରି ଆରି ଇସ୍ୱର୍‌ତିଂ ପାର୍ତି କିୱାକାନ୍ ଡେକ୍‌ନାର୍‌, ମତର୍‌ ବେଣ୍‌ବାକ୍‌ଣାୟ୍‌କିନାକାନ୍‌ ଜୁନସ୍‌ ଚିନ୍‌ ପିସ୍‌ସି ଅଲ୍‌ଗା ଇନା ଚିନ୍‌ ହେୱାରିଂ ହିୟା ଆଉତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","ଜୁନସ୍‌ ଇନେସ୍‌ ତିନ୍‌ ଦିନ୍‌ ଆରି ତିନ୍‌ ରାତି ଗାଜା ମିନ୍‌ ପଟ ବିତ୍ରେ ମାଚାନ୍‌, ମାନାୟ୍‌ ମାଜ଼ି ହେ ଲାକେ ତିନ୍‌ ଦିନ୍‌ ଆରି ତିନ୍‌ ରାତି ମେଦ୍‌ନି ପୁର୍ତିନି ଗରବ୍‌ ବିତ୍ରେ ମାନ୍‌ଗାନାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","ବିଚାର୍ଣ୍ଣାତ ଦିନ୍ତ ନିନିବିନି ମାନାୟାର୍‌ ମି ବିରୁଦ୍‌ତ ଦାବା କିଦେଙ୍ଗ୍‌ ନିଲ୍‌ନାର୍‌, ଇନାକିଦେଂକି ହେୱାର୍‌ ଜୁନସ୍‌ତି ସୁଣାୟ୍‌ କିନାକା ୱେନ୍‌ଞ୍ଜି ହେୱାର୍‌ ପାପ୍‌ ହାଜ଼ିତାଂ ମାନ୍‌ବାଦ୍‌ଲାୟ୍‌ କିତାର୍‌ ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ଇଞ୍ଜ୍‌ନାଙ୍ଗା, ଜୁନସ୍‌ ତାଙ୍ଗ୍‌ ଗାଜାକାନ୍‌ ରୱାନ୍‌ ଇବେ ମାନାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","ଆରେ, ଜେନ୍‌ବାଗାଙ୍ଗ୍‌ ଦେସ୍‌ନି ରାଣି ବିଚାର୍ଣ୍ଣାତ ଇ ନଙ୍ଗ୍‌ନି ଆଣ୍ଡ୍ରାଙ୍ଗ୍‌ ଲାହାଙ୍ଗ୍‌ ନିଙ୍ଗ୍‌ଜି ଇୱାରିଂ ଦସି କିନାତ୍‌, ଇନାକିଦେଂକି ହେଦେଲ୍‌ ସଲମନ୍‌ତି ବୁଦିନି କାତା ୱେଞ୍ଜେଙ୍ଗ୍‌ ପୁର୍ତିନି ବାଟାତାଂ ୱାଜ଼ି ମାଚାତ୍‌, ଆରେ ହୁଡ଼ା, ସଲମନ୍‌ତାଂ ଗାଜା ବିସ୍ରେ ଇ ବାହାତ ମାନାତ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“ବାନ୍ୟା ଜିବୁନିଂ ରକାନ୍‌ ମାନାୟ୍‌ତିଂ ହସି ହାଚି ପାଚେ ଏଜ଼ୁଂ ହିଲ୍‍ୱି ବାହା ସବୁ ବୁଲା ଆଜ଼ି ଜମ୍‌ଦେଂ ଡେକ୍‌ନାତ୍‌ ଆରି ହେଦାଂ ଗାଟା ଆଉତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","ହେବେ ହେଦାଂ ଇନାତ୍‌, ଆନ୍‌ ଇମ୍‌ଣି ଇଞ୍ଜାଙ୍ଗ୍‌ ହସି ୱାତାଂନା, ଆନ୍‌ ହେ ଇଞ୍ଜ ମାସ୍‌ଦି ହାନାଙ୍ଗ୍‌; ଆରେ, ହେଦାଂ ୱାଜ଼ି ହେ ବାହା ୱାରାକା, ଆରି ନିର୍ମଲ୍‌ ହୁଡ଼୍‌ତାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","ହେପାଦ୍‌ନା ହେଦାଂ ହାଲ୍‌ଜି ଜାର୍‌ତାଂ ଆଦିକ୍‌ ବାନ୍ୟା ଆରେ ସାତ୍‌ଗଟା ପୁଦାଂ ରଚେ ତାସି ୱାନାତ୍‌, ଆରେ, ହେୱାଙ୍ଗ୍‌ ହଣ୍‌ଜି ହେବେ ବାହାକିନିକ୍‌, ଆରେ ହେ ଲକ୍‌ତି ପର୍ତୁମ୍‌ ଦସା ତାଙ୍ଗ୍‌ ହାରିହାରା ଦସା ଆଦେକ୍‌ ବାନ୍ୟା ଆନାନ୍‌ । ଇ ବାନ୍ୟା ଆଣ୍ଡ୍ରେନ୍‌ ଇ ଜୁଗ୍‌ନି ମାନାୟାର୍‌ ହାର୍‌ ଗିଟା ଆନାତ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","ଜିସୁ ମାନାୟାର୍‌ ଲାହାଙ୍ଗ୍‌ କାତା ଆନିୱେଡ଼ାଂ, ତାଞ୍ଜି ଆୟା ଆରି ଟଣ୍ଡାହିର୍‌ ବାର୍‌ତ ନିଲ୍‌ଚି ତା ଲାହାଙ୍ଗ୍‌ ବେଣ୍‌ କିଦେଙ୍ଗ୍‌ ଇଚା କିଜ଼ି ମାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","ହେବେ ରକାନ୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ଇଚାନ୍‌, “ହୁଡ଼ା, ମିଞ୍ଜି ଆୟା ଆରି ଟଣ୍ଡାର୍‌ ବାର୍ତ ନିଲ୍‌ଚି ନି ଲାହାଙ୍ଗ୍‌ ବେଣ୍‌ କିଦେଙ୍ଗ୍‌ ମାନ୍‌ କିନାରା ।” ");
INSERT INTO peg_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","ମାତର୍‌ ଜେ ତାଙ୍ଗେଙ୍ଗ୍‌ ଇ କାତା ଇଚାନ୍‌, ତାଙ୍ଗେଙ୍ଗ୍‌ ଜିସୁ ଉତର୍‌ ହିତାନ୍‌, “ମାଞ୍ଜି ଆୟା ଇନ୍ଦେଲ୍‌ ? ଆରେ, ନା ଟଣ୍ଡାର୍‌ ଇନେର୍‌ ?” ");
INSERT INTO peg_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","ଆରେ, ଜିସୁ ତା ଚେଲାହିର୍‌ ନିପ କେଇ ଚଚ୍‌ଚି ଇଚାନ୍‌, “ହୁଡ଼ା, ମାଞ୍ଜି ଆୟା ଆରି ମାଞ୍ଜି ଟଣ୍ଡାର୍‌, ");
INSERT INTO peg_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","ଇନେର୍‌କି ସାର୍ଗେନି ଆବାତି ଇଚା କିନାନ୍‌, ହେୱାନ୍‌ ନା ଟଣ୍ଡାର୍‌, ତଣ୍‌ଦେକ୍‌ ଆରି ଆୟା ।” ");
INSERT INTO peg_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","ହେ ନାଜିଂ ଜିସୁ ଇଞ୍ଜାଙ୍ଗ୍‌ ହସି ହାଲ୍‌ଜି ହାମ୍‌ଦୁର୍‌ ଗୁଟିତ ହେବେ ହିକ୍ୟା ହିଦେଂ କୁଚ୍‌ଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","ହେବେ ତା କଚଣ୍‌ତ ବେସି ମାନାୟ୍‌ ରୁଣ୍ଡା ଆତିଲେ ହେୱାନ୍‌ ହାଲ୍‌ଜି ର ଡଙ୍ଗାତ କୁଚ୍‌ଚାନ୍‌, ଆରେ ମାନାୟାର୍‌ ଗୁଟିତ ମାଚାର୍‌ ତା କାତା ୱେନ୍‌ଞ୍ଜି ମାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","ଆରେ, ଜିସୁ ଉତର୍‌ମୁଡ଼୍‌ ହୁକେ ହେୱାରିଂ ବେସି କାତା ଇଚାନ୍‌, ହୁଡ଼ାଟ୍‌, “ରକାନ୍‌ ୱିତ୍‌ନାକାନ୍‌ ୱିଦ୍‌ଦେଂ ହତ୍‌ତାନ୍ । ");
INSERT INTO peg_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","ହେୱାନ୍‌ ୱିତୁ ୱିତୁ କେତେକ୍‌ ବିୟାନ୍‌ ହାଜ଼ି କଚଣ୍‌ତ ଆର୍‌ତାତ୍‌, ଆରେ ପଟିଂ ୱାଜ଼ି ହେୱାକାଂ ତିନ୍‌ଞ୍ଜି ହାଚିକ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","ଆରେ କେତେକ୍‌ ଅଲପ୍‍ ଚିକ୍‌ଲା ମାନି ଚେଚ୍‌ରା ବୁଇଁତ ଆର୍‌ତାତ୍‌ ଆରି ବାଜେକ୍‌ ଚିକ୍‌ଲା ହିଲ୍‌ୱିତିଲେ ଚାଣ୍ଡେକ୍‌ ନେସ୍‌ତାତ୍‌, ");
INSERT INTO peg_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","ମାତର୍‌ ୱେଡ଼ା ହତ୍‌ତିଲେ, କାଡ଼୍‌ତାତ୍‌ ଆରେ ଚିରା ହିଲ୍‌ୱିତିଲେ ୱାଜ୍‌ଜି ହାଚାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","ଆରେ କେତେକ୍‌ ୱାଡ଼ି ମାର୍‌କୁକାଂ ପା ଆର୍‌ତାତ୍‌, ଆରେ ୱାଡ଼ିଙ୍ଗ୍‌ବୁଟାଙ୍ଗ୍‌ ପାନ୍‌ଚି ହେୱାଙ୍ଗ୍‌ ଚାପି କିତିକ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","ମତର୍‌ ବିନେ କେତେକ୍‌ ହାର୍ଦି ମେଦ୍‌ନିତ ଆର୍‌ତାତ୍‌ ଆରି ପାଡ଼୍‌ ଆସ୍ତାତ୍‌, କେତେକ୍‌ ପାଞ୍ଚ୍‌କଡ଼ି ଗାଡ଼୍‌ହା, ଆଦିକ୍‌ କେତେକ୍‌ ତିନ୍‌କଡ଼ି ଗାଡ଼୍‌ହା, ଆଦିକ୍‌ ଆରେ କେତେକ୍‌ ରିକଡ଼ିଦସ୍‌ ଗାଡ଼୍‌ହା ଆଦିକ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","ଜିସୁ ଇଚାନ୍‌ “ଇନେରିଂ କିତୁଲିଂ ମାନିକ୍‌, ହେୱାନ୍‌ ୱେନେନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","ଇଦାଂ ପାଚେ ଚେଲାର୍‌ ତା କଚଣ୍‌ ୱାଜ଼ି ୱେନ୍‌ବାତାର୍‌, “ଏନ୍‌ ଇନାକିଦେଂ ହେୱାରିଂ ଉତର୍‌ମୁଡ଼୍‌ ହୁକେ କାତା ଇନାୟା ?” ");
INSERT INTO peg_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","ଜିସୁ ଉତର୍‌ ହିତାନ୍‌, “ଇନାକିଦେଂକି ସାର୍ଗେ ରାଜି ବିତ୍ରେନି ବେରଣ୍‌ ସବୁ ପୁନି କାଜିଂ ମିଙ୍ଗେଙ୍ଗ୍‌ ସାକ୍ତି ହିଦ୍‍ୟା ଆତାତ୍‌ନ୍ନା, ମାତର୍‌ ହେୱାରିଂ ହିୟାୱାତାତ୍‌ନା । ");
INSERT INTO peg_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","ଲାଗିଂ ଇନେର୍‌ତି ବେସି ମାନାତ୍‌, ତାଙ୍ଗେଙ୍ଗ୍‌ ହିୟାନାତ୍‌, ଆରେ ତାଦାଙ୍ଗ୍‌ ବାଜେକ୍‌ ଆନାତ୍‌; ମାତର୍‌ ଇନେରିଂ ହିଲୁତ୍‌, ତାତାକେ ଇନାକା ମାନାତ୍‌, ହେଦାଂ ନେ ତା ତାକେଣ୍ଡାଂ ଅୟାନାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","ହେୱାରିଂ ଆନ୍‌ ଉତର୍‌ମୁଡ଼୍‌ ଲାହାଙ୍ଗ୍‌ ଇନାଙ୍ଗା, ହେୱାର୍‌ ହୁଡ଼୍‌ଜି ହୁଡ଼୍‌ଜି ହୁଡ଼୍‌ଦେଂ ଆଡୁର୍‌ ଆରି ୱେନୁ ୱେନୁ ୱେଞ୍ଜେଙ୍ଗ୍‌ ଆଡୁର୍‌ କି ବୁଜାଆଦେଂ ଆଡୁର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","ଆରେ, ଜିସାୟ୍‌ତି ଇ ବେଣ୍‌ବାକ୍‌ଣାୟ୍‌କିନାକା ହେୱାର୍‌ ବିସ୍ରେ ପୁରା ଆନାତା, ଏପେଙ୍ଗ୍‌ ୱେନୁ ୱେନୁ ୱେନାଦେର୍‌, ମାତର୍‌ ଇନେସ୍‌ ବାନି ବୁଜାଉଦେର୍‌, ଆରେ ହୁଡ଼୍‌ଜି ହୁଡ଼୍‌ଜି ହୁଡ଼୍‌ନାଦେର୍‌, ମାତର୍‌ ଇନେସ୍‌ ବୁଜାଉଦେର୍‌; ");
INSERT INTO peg_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","ଇନାକିଦେଂକି ଇ ମାନାୟାର୍‌ତି ଜିବୁନ୍‌ ବୱାଡ଼୍‌ ଆତାତ୍‌, ହେୱାର୍‌ କିତୁଲ୍‌ତ କସ୍ଟତାଂ ୱେଚାର୍‌ ଆରି ଜାର୍‌ ଜାର୍‌ କାଣ୍‌କୁ ଜୁଚ୍‌ଚାର୍‌, ଇନେସ୍‌ ହେୱାର୍‌ କାଣ୍‌ଙ୍ଗାତାଂ ହୁଡ଼୍‌ର୍‌ ହେଦାଂ ଆୱିତିସ୍‌ ହେୱାର୍‌ କିତୁଲ୍‌ତ ୱେଞ୍ଜେଙ୍ଗ୍‌ ଆଡ଼୍‌ତାର୍‌ମା, ଆରେ ମାନ୍ତ ବୁଜାଆଦେଂ ଆଡୁର୍‌, ଆରେ ମାସ୍‌ଦି ୱାଉର୍‌, ଆରେ ଆପେଂ ହେୱାରିଂ ଉଜ୍‌ କିଦେଙ୍ଗ୍‌ କପ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“ମାତର୍‌ ଦନ୍ୟ ମି କାଣ୍‌କୁ, ଲାଗିଂ ହେଦାଂ ହୁଡ଼୍‌ନାତ୍‌; ଦନ୍ୟ ମି କିତୁଲିଂ, ଲାଗିଂ ହେଦାଂ ୱେନାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","ଇନାକିଦେଂକି ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ହାତ୍‌ପା ଇଞ୍ଜ୍‌ନାଙ୍ଗା, ଏପେଙ୍ଗ୍‌ ଇନା ଇନାକା ହୁଡ଼୍‌ନାଦେର୍‌, ହେ ୱିଜ଼ୁ ବେସି ବେଣ୍‌ବାକ୍‌ଣାୟ୍‌ ଆରି ଦାର୍ମି ମାନାୟାର୍‌ ହୁଡ଼୍‌ଦେଂ ମାନ୍‌ କିତାର୍‌, ମାତର୍‌ ହୁଡ଼୍‌ୱାତାର୍‌; ଆରେ, ଏପେଙ୍ଗ୍‌ ଇନା ଇନାକା ୱେଚାଦେର୍ଣ୍ଣା, ହେ ସବୁ ହେୱାର୍‌ ୱେଞ୍ଜେଙ୍ଗ୍‌ ମାନ୍‌ କିତାର୍‌, ମାତର୍‌ ୱେଞ୍ଜେଙ୍ଗ୍‌ ଆଡ୍‌ୱାତାର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“ଲାଗିଂ ୱେନାଟ୍‌, ବିୟାନ୍‌ ୱିତ୍‌ନାକାନ୍‌ ଉତର୍‌ମୁଡ଼୍‌ନି ଅରତ୍‌ ଇନାନ୍ନା । ବୁଜାଆଦେଂ ସେସ୍ଟା କିୟାଟ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","ଇନେର୍‌କି ରାଜିନି ବଚନ୍‌ ୱେନ୍‌ଞ୍ଜି ବୁଜା ଆଉର୍‌, ସୟ୍‌ତାନ୍‌ ୱାଜ଼ି ତା ମାନ୍‌ତ ଇନାକା ୱିତ୍‌ୟାଜ଼ି ମାଚାତ୍‌, ହେଦାଂ ଉନ୍‌ଦି ଅନାତ୍‌, ହେୱାନ୍‌ ରୱାନ୍‌ ୱିତ୍‌ତି ହାଜ଼ି ଗୁଟିତ ଆର୍ଜି ମାନି ବିୟାନ୍‌ ଲାକେ । ");
INSERT INTO peg_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","ଇନେର୍‌ ଇସ୍ୱର୍ତି ବଚନ୍‌ ଆଏତ୍‌ ବେରଣ୍‌ ୱେଚ୍‌ଚି ଦାପ୍ରେ ୱାର୍‌ୟା ଆଜ଼ି ହେଦାଂ ମାନି କିତାର୍‌, ହେୱାର୍‌ କାଲ୍‌କୁକୁଡ଼ି ବୁଇଁତ ଆର୍ଜି ମାନି ବିୟାନ୍‌ ଲାକେ, ");
INSERT INTO peg_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","ହେୱାର୍‌ତି ଚିରାଂ ଦେହା ହାଲ୍‌ୱାଦାଂ ମାଚିଲେ ହେୱାର୍‌ ହେଦେଲିଂ ବେସି ସମୁ ଆସ୍ତି ଇଡ୍‌ଦେଂ ଆଡୁର୍‌ । ଇ କାବୁର୍‌ କାଜିଂ ଏଚେକାଡ଼୍‌ଦ କସ୍ଟ କି ନିନ୍ଦା ୱାତିସ୍‌ ହେୱାର୍‌ ଦାପ୍ରେ ହେଦେଲିଂ ପିହ୍‌ନାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","ଇନେନ୍‌ ଇସ୍ୱର୍ତି ବେରଣ୍‌ ୱେନାନ୍‌, ଆରେ ସଁସାର୍‌ନି ଚିନ୍ତା ଆରି ଦାନ୍‌ନି ବାୟା ବେଣ୍‌ତିଙ୍ଗ୍‌ ଚାପି କିନାତ୍‌, ଆରେ ହେୱାନ୍‌ ପାଡ଼୍‌ ଆହେନ୍‌, ହେ ରୱାନ୍‌ ୱିତ୍‌ୟାତି ୱାଡ଼ି ମାର୍‌କୁ ତାରେନ୍‌ ଲାକେ । ");
INSERT INTO peg_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","ମାତର୍‌ ଇନେର୍‌ ବଚନ୍‌ ୱେନ୍‌ଞ୍ଜି ବୁଜାଆନାନ୍‌, ହାର୍ଦି ଜମିତ ଆର୍ଜି ମାଚି ବିୟାନ୍‌ ଲାକେ ହେୱାର୍‌ ହାର୍ଦି ପାଡ଼୍‌ ଆହ୍‌ନାତ୍‌, ଇନେନ୍‌ ପାଞ୍ଚ୍‌କଡ଼ି ଗାଡ଼୍‌ହା ଆଦିକ୍‌, ଇନେନ୍‌ ତିନ୍‌କଡ଼ି ଗାଡ଼୍‌ହା ଆଦିକ୍‌, ଇନେନ୍‌ ରିକଡ଼ିଦସ୍‌ ଗାଡ଼୍‌ହା ଆଦିକ୍‌ ପାୟାନାନ୍‌, ହେୱାନ୍‌ ୱିତ୍‌ୟାତି ହାର୍ଦି ମେଦ୍‌ନି ଲାକେ ।” ");
INSERT INTO peg_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","“ଜିସୁ ହେୱାରିଂ ଆରେ ର ଉତର୍‌ମୁଡ଼୍‌ ହିଜ଼ି ଇଚାନ୍‌, ସାର୍ଗେ ରାଜି ଜାର୍‌ ଜମିତ ହାର୍ଦି ବିୟାନ୍‌ ୱିଦ୍‌ଦିମାଚି ର ମୁଣିକା ଲାକେ; ");
INSERT INTO peg_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","ମତର୍‌ ଲକୁ ହୁଚ୍‌କାଣ୍‌କୁ ହନିହିଙ୍ଗ୍‌ ତା ସାତ୍ରୁ ୱାଜ଼ି ହେ ଗଁମ୍‌ ବିୟାନ୍‌ ବିତ୍ରେ କାଚ୍ରା ୱିଦ୍‌ଦି ତାଙ୍ଗ୍‌ଜି ହାଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","ଏଚେକାଡ଼୍‌ଦ ଆକିଂ ହସି ପାଡ଼୍‌ ଆସ୍ତେଙ୍ଗ୍‌ ଲାଗାତାତ୍‌, ହେ ପାଦ୍‌ନା କାଚ୍ରା ପା ଚଞ୍ଜିୟାଆତାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","ହେବେ ଇଞ୍ଜିମୁଣିକାଂ ହଲ୍ୟାହିର୍‌ ତା କଚଣ୍‌ ୱାଜ଼ି ଇଚାର୍‌, ହାଉକାର୍‌, ଏନ୍‌ ଇନାକା ଜାର୍‌ ଜମିତାକେ ହାର୍ଦି ବିୟାନ୍‌ ୱିତ୍‌ୱାଦାଂ ମାଚାୟ୍‌ ? ଲାଗିଂ କାଚ୍ରାଂ ଇମେଣ୍ଡାଂ ଆତାତ୍‌ ? ");
INSERT INTO peg_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","ହେୱାନ୍‌ ହେୱାରିଂ ଇଚାନ୍‌, ରକାନ୍‌ ସାତ୍ରୁ ଇଦାଂ କିତାନ୍‌ନ୍ନା । ଆରେ, ହଲ୍ୟାହିର୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ଇଚାର୍‌, ଲାଗିଂ ଆପେଂ ହାଲ୍‌ଜି ହେ ୱିଜ଼ୁ ଜେଲ୍‌ଜି ରବେ କିନାପ୍‌, ଇଦାଂ ଇନାକା ନିମାନ୍‌ ? ");
INSERT INTO peg_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","ମାତର୍‌ ହେୱାନ୍‌ ଇଚାନ୍‌, ଆକାୟ୍‌, କାତେ ଏପେଙ୍ଗ୍‌ କାଚ୍ରା ରୁଣ୍ଡାୟ୍‌ କିଉ କିଉ ହେ ୱିଜ଼ୁ ରଚେ ଗଁମ୍‌ ଜେଲ୍‌ଜି ତୁହିହିନାଦେର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","ତାସ୍‌ ତ୍ରେସ୍‌ୱି ପାତେକ୍‌ ରିଣ୍ଡାକାଂ ରଚେ ଗାଜାଆଦେଂ ପିହାଟ୍‌, ଆରେ କାଚ୍ରା ତ୍ରେସ୍‌ନିହିଙ୍ଗ୍‌ ଆନ୍‌ ତ୍ରେସ୍‌ନା କାରିଂ ଇନାଙ୍ଗ୍‌, କାଚାୟ୍‌କିଦେଂ ହିଗ୍‌ଦ କାଚ୍ରା ରବେ କିଜ଼ି ମୁଟା ଗାଚାଟ୍‌, ମାତର୍‌ ଗଁମ୍‌ ନା ଟୁଣ୍ଡିତ ରୁଣ୍ଡାୟ୍‌ କିଜ଼ି ଇଟାଟ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","ଜିସୁ ହେୱାରିଂ ଆରେ ର ଉତର୍‌ମୁଡ଼୍‌ ହିଜ଼ି ଇଚାନ୍‌, “ସାର୍ଗେ ରାଜି ଇ ଲାକେ ର ହାର୍‌ହୁ ମାଞ୍ଜି ଲାକେ, ଇନାକା ଅଜ଼ି ର ମାନାୟ୍‌ ଜାର୍‌ ଜମିତ ୱିତ୍‌ତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","ହେଦାଂ ତ ୱିଜ଼ୁ ବିୟାନ୍‌ ତାଙ୍ଗ୍‌ ହିରୁ, ମତର୍‌ ହେଦାଂ ଗାଜାଆତିସ୍‌ ସବୁ କୁଚାତାଂ ଗାଜା ଆଜ଼ି ଇ ଲାକେ ମାର୍‌ ଆନାତ୍‌ ଜେ, ବାଦାଡ଼୍‌ନି ପଟିଂ ୱାଜ଼ି ତା କେନ୍ଦାତ ବାହା କିନିକ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","ଜିସୁ ହେୱାରିଂ ଆରେ ର ଉତର୍‌ମୁଡ଼୍‌ ଇଚାନ୍‌, “ସାର୍ଗେ ରାଜି ହଇନି ଲାକେ; ରଞ୍ଜେଲ୍‌ କଗ୍‌ଲେ ହେଦାଂ ଅଜ଼ି ଆଦାବାସ୍ତା ମଇଦା ବିତ୍ରେ ଡାବାୟ୍‌ କିଜ଼ି ଇଟ୍‌ଟାତ୍‌, ଆରେ ହାରିହାରା ୱିଜ଼ୁ ହଇତାତ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","ଇ ୱିଜ଼ୁ କାତା ଜିସୁ ଉତର୍‌ମୁଡ଼୍‌ କାଜିଂ ମାନାୟାରିଂ ଇଚାନ୍‌, ଆରେ ଉତର୍‌ମୁଡ଼୍‌ ପିସ୍ତି ହେୱାନ୍‌ ହେୱାରିଂ ଇନାକା ଇନ୍‌ୱାଦାଂ ମାଚାନ୍‌, ");
INSERT INTO peg_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","ଇନେସ୍‌କି ବେଣ୍‌ବାକ୍‌ଣାୟ୍‌ କିନାକାର୍‌ କାଜିଂ ଇ ବେରଣ୍‌ ପୁରା ଆନାତ୍‌, “ଆପେଂ ଜାର୍‌ ୱେଇ କିଜ଼ି ଉତର୍‌ମୁଡ଼୍‌ ହୁକେ କାତା ଇନାକା, ପୁର୍ତି ଉବ୍‌ଜାଣ୍‌ ବୁଡାଆତି ଡ଼ୁକ୍‌ତି ବିସ୍ରେ ସବୁ ଇନାସ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","ପାଚେ ହେୱାନ୍‌ ମାନାୟାରିଂ ପିସ୍ତି ଇଞ୍ଜ ହଣ୍‌ଗାତାନ୍‌, ଆରେ ତା ଚେଲାହିର୍‌ ତା ଲାଗେ ୱାଜ଼ି ଇଚାର୍‌, “ଜମିନି କାଚ୍ରାନି ଉତର୍‌ମୁଡ଼୍‌ ମାଙ୍ଗେଙ୍ଗ୍‌ ହାର୍‌ କିଜ଼ି ବୁଜାୟ୍‌କିଦା ।” ");
INSERT INTO peg_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","ଜିସୁ ଉତର୍‌ ହିତାନ୍‌, “ହାର୍ଦି ବିୟାନ୍‌ ଇନେନ୍‌ ୱିତ୍‌ନାନ୍‌, ହେୱାନ୍‌ ମାନାୟ୍‌ ମାଜ଼ି; ");
INSERT INTO peg_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","ଜମି ପୁର୍ତି; ହାର୍ଦି ବିୟାନ୍‌ ରାଜିନି ହିମ୍‌ଣାଂ, କାଚ୍ରା ସୟ୍‌ତାନ୍‌ ଜିବୁନ୍‌ ହିମ୍‌ଣାଂ; ");
INSERT INTO peg_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","ଇମ୍‌ଣି ସାତ୍ରୁ ହେଦାଂ ୱିତ୍‌ତାନ୍‌, ହେୱାନ୍‌ ସୟ୍‌ତାନ୍‌; ତାସ୍‌ ତ୍ରେସ୍‌ନି ୱେଡ଼ାଙ୍ଗ୍‌ ଜୁଗ୍‌ସେସ୍‌, ଆରେ ତ୍ରେସ୍‌ନାକାର୍‌ ୱିଜ଼ାର୍‌ ସାର୍ଗେ ଦୁତ୍‌ତର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","ତା ଆତିସ୍‌, କାଚ୍ରା ଇନେସ୍‌କି ରବେ କିଜ଼ି ନାଣିତ କାଡିକିୟାଆନାତ୍‌, ଜୁଗ୍‌ସେସ୍‌ ୱେଡ଼ାଲିଂ ହେ ଲାକେ ଗିଟା ଆନାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","ମାନାୟ୍‌ ମାଜ଼ି ଜାର୍‌ ଦୁତ୍‌ତରିଂ ପକ୍ତାନାନ୍‌, ଆରେ ହେୱାର୍‌ ତା ରାଜିତାଂ ସବୁ ବାଦାନିକା ବିସ୍ରେ ଆରି ବାନ୍ୟାରିଂ ରୁଣ୍ଡାୟ୍‌ କିନାନ୍‌, ");
INSERT INTO peg_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","ଆରେ ହେୱାରିଂ ନାଣି ହଲିତ ତୁହିହିନାର୍‌, ହେବେ ଆଡ଼୍‌ବାନାର୍‌ ଆରି ଟାଡାଙ୍ଗ୍‌ କଡ଼୍‌ମଡ଼୍‌ ଆନାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","ହେୱାଡ଼ାଂ ଦାର୍ମିର୍‌ ହେୱାର୍‌ତି ଲାତ୍ରାହି ସାର୍ଗେନି ଆବା ରାଜିତ ୱେଡ଼ା ଲାକେ ଡ଼ିନ୍‍ଞ୍ଜି ଚଞ୍ଜ୍‌ୟା ଆନାର୍‌ । ଇନେରିଂ କିତୁଲ୍‌ ମାନାତ୍‌, ହେୱାନ୍‌ ୱେନେନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“ସାର୍ଗେ ରାଜି ଜମିତ ଡ଼ୁକ୍‌ତି ଦାନ୍‌ ଲାକେ । ର ମାନାୟ୍‌ ହେଦାଂ ହୁଡ଼୍‌ଜି ଡ଼ୁକ୍‌ଚି ଇଡ଼୍‌ତାନ୍‌ ଆରି ୱାରିତାଂ ହାଲ୍‌ଜି ଜାର୍‌ତି ସବୁ ପ୍ରସି ହେ ଜମିତିଂ କଡ଼୍‌ତାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“ଆରେ, ସାର୍ଗେ ରାଜି ହାର୍ଦି ହାର୍ଦି ମୁକ୍ତା ଡେକ୍‌ଚି ମାନି ର ବେପ୍ରିୟା ଲାକେ । ");
INSERT INTO peg_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","ର ବେସି ଦାମ୍‌ନି ମୁକ୍ତା ହୁଡ଼୍‌ଜି ହେୱାନ୍‌ ହାଲ୍‌ଜି ଜାର୍‌ତି ସବୁ ପ୍ରସି ହେ ମୁକ୍ତାତିଙ୍ଗ୍‌ କଡ଼୍‌ତାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“ସାର୍ଗେ ରାଜି ର ମିନ୍‌କୁ ଆହ୍‌ନି ଜାଲ୍‌ ଲାକେ । କେଉଟାର୍‌ ହାମ୍‌ଦୁର୍‌ତ ଜାଲ୍‌ ଇଡ଼୍‌ଜି ବାରବିନି ମିନ୍‌କୁ ଆହ୍‌ନାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","ଜାଲ୍‌ ବର୍ତି ଆତିସ୍‌ ଗୁଟିତ ଜେଲ୍‌ଜି ତାସି ହାର୍ଦି ହାର୍ଦି ମିନ୍‌କୁ ସବୁ ଆଜ଼ି ଟପାତ ଇଟ୍‌ନାର୍‌ ଆରି ବାନ୍ୟା ମିନ୍‌କୁ ତୁହି ହିନାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","ଜୁଗ୍‌ସେସ୍‌ ସମୁତ ଇ ଲାକେ ଗିଟା ଆନାତ୍‌ । ସାର୍ଗେନି ଦୁତ୍‌ତର୍‌ ଦାର୍ମିର୍‌ ତାକେଣ୍ଡାଂ ପାପିୟାରିଂ ଆଲ୍‌ଗା କିଜ଼ି ");
INSERT INTO peg_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","ହେୱାରିଂ ଆହ୍‌ନି ନାଣିତ ତୁହି ହିନାର୍‌ । ଆରେ ହେୱାରିଂ ନାଣି ହଲିତ ତୁଇହିନାର୍‌; ହେବେ ଆଡ଼୍‌ବାନାର୍‌ ଆରି ଟାଡାଙ୍ଗ୍‌ କାଟ୍‌ନାର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","ଜିସୁ ଚେଲାରିଂ ୱେନ୍‌ବାତାନ୍‌, “ଇ ସବୁ ବିସ୍ରେ ବୁଜାଆଦେଂ ଆଡ଼୍‌ନାଦେରା ?” ହେୱାର୍‌ ଉତର୍‌ ହିତାର୍‌, “ଆଁ ମାପ୍ରୁ ।” ");
INSERT INTO peg_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","ଜିସୁ ଗୁରୁରିଂ ଇଚାନ୍‌, “ଇନେସ୍‌ ରୱାନ୍‌ ଇଲ୍‌ ମୁଣିକା ଜାର୍‌ କଟିତାଂ ଆତି ନେଚେକ୍‍ ପୁନାକା ଆରି ପ୍ଡାନାକା ଆଡ଼୍‌ମାଡ଼୍‌ ହପ୍‌ନାନ୍‌, ସାର୍ଗେ ରାଜିତ ଚେଲା ଆଜ଼ି ମାଚି ରକାର୍‍ ରକାର୍‍ ସାସ୍ତର୍‌ ତା ଲାକେ ।” ");
INSERT INTO peg_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","ଜିସୁ ଇ ସବୁ ଉତର୍‌ମୁଡ଼୍‌ ୱିସ୍ତି ପାଚେ ହେ ବାହା ପିସ୍‌ସି ହାଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","ଆରେ, ହେୱାନ୍‌ ଜାର୍‌ତି ଆବା ଲାତ୍ରା ଗାଡ଼୍‌ଦ ୱାଜ଼ି ମାନାୟାରିଂ ହେୱାର୍‌ତି କୁଟୁମ୍‌ ଇଞ୍ଜ ଇ ଲାକେ ହିକ୍ୟା ହିତାନ୍‌ ଜେ, ହେୱାର୍‌ ଚାନ୍ୟା ଆଜ଼ି ଇଚାର୍‌, “ଇ ମାନାୟ୍‌ତିଂ ଇ ଲାକେ ବୁଦି ଆରି ସାକ୍ତିନି କାମାୟ୍‌ ଇମେତାଂ ଆତାତ୍‌ ?” ");
INSERT INTO peg_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","ଇୱାନ୍‌ କି ହେ ବାଡାୟ୍‌ ମେହି ଆକାୟ୍‌ ? ଇୱାନ୍ତି ତେହି ତର୍‌ ମରିୟମ୍‌ ଆକାୟ୍‌ ? ଆରେ ଇୱାନ୍‌ ଟଣ୍ଡାହିର୍‌ତି ତର୍‌ ଇନାକା ଜାକୁବ୍‌, ଜସେପ୍‌, ସିମନ୍‌ ଆରି ଜିହୁଦା ଆକାୟ୍‌ ? ");
INSERT INTO peg_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","ଆରେ, ଇୱାନ୍ତି ତଣ୍‌ଦେହିକ୍‌ ଇନାକା ୱିଜ଼େକ୍‌ ମାଲାହାଂ ହିଲୁକ୍‌ ? ଲାଗିଂ “ହେୱାନ୍‌ ଇ ବୁଦି ସବୁ ସାକ୍ତି ଇମେଣ୍ଡାଂ ଗାଟାତାନ୍‌ ?” ");
INSERT INTO peg_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","ଆରେ, ହେୱାର୍‌ ତା ତାକେଣ୍ଡାଂ ବାଦା ପାୟା ଆତାର୍‌ । ମାତର୍‌ ଜିସୁ ହେୱାରିଂ ଇଚାନ୍‌, “ବେଣ୍‌ବାକ୍‌ଣାୟ୍‌ କିନାକାନ୍‌ ଜାର୍‌ ଆବା ଲାତ୍ରା ଗାଡ଼୍‌, ଇଲ୍‌ ଆରି ଜାର୍‌ କୁଟୁମ୍‌ ପିସ୍ତି ଅଲ୍‌ଗା ଇମେତାକେ ହିନସ୍ତା କିୟାଉନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","ଆରେ, ହେୱାନ୍‌ ହେୱାର୍‌ତି ପାର୍ତି କିୱାକା କାଜିଂ ହେବେ ବେସି ସାକ୍ତିନି କାମାୟ୍‌ କିୱାତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","ହେ ସମୁତ ଗାଲିଲିନି ରାଜା ହେରଦ୍‌ ଜିସୁତି ବିସ୍ରେନି କାତା ୱେଚାନ୍‌, ତା ହଲ୍ୟାହିରିଂ ଇଚାନ୍‌, ");
INSERT INTO peg_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","“ଇୱାନ୍‌ ବାପ୍ତିସିମ୍‌ହିନି ଜହନ୍‌, ହେୱାନ୍‌ ହାତି ତାକେଣ୍ଡାଂ ପା ନିଙ୍ଗ୍‌ତାନ୍‌ନା, ହେଦାଂ କାଜିଂ ଇ ୱିଜ଼ୁ ସାକ୍ତି ତା ତାକେଣ୍ଡାଂ କାମାୟ୍‌ କିନାତା ।” ");
INSERT INTO peg_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","ହେରଦ୍‌ ଜାର୍‌ ଟଣ୍ଡାହି ପିଲିପ୍‌ ୱାଣି ହେରଦିୟା କାଜିଂ ଜହନ୍‌ତିଂ ଆସ୍ତି ଆରି ଗାଚ୍‌ଚି ବନ୍ଦିହାଡ଼ାତ ପ୍ରଦ୍‌ଦି ମାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","ଇନାକିଦେଂକି ଜହନ୍‌ ହେରଦିୟାଙ୍ଗ୍‌ ଇଞ୍ଜି ମାଚାନ୍‌, “ଇଦେଲିଂ ରାକିକିନାକା ନି ବିଦି ହିଲୁତ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","ଆରେ, ହେୱାନ୍‌ ଜହନ୍‌ତିଂ ଅସ୍ତେଙ୍ଗ୍‌ ମାନ୍‌ କିତାନ୍‌ ହିନା, ମାନାୟାର୍‌ତିଂ ପାଣ୍ଡ୍ରା ଆତାର୍‌, ଇନାକିଦେଂକି ହେୱାର୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ବେଣ୍‌ବାକ୍‌ଣାୟ୍‌କିନାକାନ୍‌ ଇଞ୍ଜି ମାନିକିଜ଼ି ମାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","ମାତର୍‌ ହେରଦ୍‌ତି ଜଲମ୍‌ ଦିନ୍‌ ଏକାୱାତିଲେ, ହେରଦିୟା ଗାହ୍‌ଡ଼ି ମାନାୟାର୍‌ ମୁମ୍‌ଦ ଏନ୍‌ନ୍ଦି ହେରଦ୍‌ତିଂ ୱାରି କି କିତାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","ହେବେ “ହେରଦ୍‌ ପାର୍ମାଣ୍‌ କିଜ଼ି ରାଣ୍‌ କିତାନ୍‌ ଜେ, ହେଦେଲ୍‌ ଇନାକାପା ଏନ୍ତାନାତ୍‌, ହେୱାନ୍‌ ହେଦେଲିଂ ହେଦାଂ ହିନାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","ଆରେ, ହେଦେଲ୍‌ ତା ତେହି ହିକ୍ୟାତ ଆର୍ଜି ଇଚାତ୍‌, “ବାପ୍ତିସିମ୍‌ ହିନି ଜହନ୍‌ତି କାପ୍‌ଡ଼ା ଇ ଦାପ୍ରେ ଇବେ ର ତାଡ଼ିୟାତ ନାଙ୍ଗ୍‌ ହିଦା ।” ");
INSERT INTO peg_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","ଇବେ ରାଜା ଦୁକ୍‌ ଆତିସ୍‌ ପା ଜାର୍‌ ପାର୍ମାଣ୍‌ ଆରି ଜାର୍‌ ଲାହାଙ୍ଗ୍‌ ବଜିତ କୁଚ୍‌ଚି ମାନି ମାନାୟାର୍‌ କାଜିଂ ହେଦାଂ ହିଦେଂ ବଲ୍‌ ହିତାନ୍‌, ");
INSERT INTO peg_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","ଆରେ ମାନାୟ୍‌ ପକ୍‌ଚି ଜେଲ୍‌ତ ଜହନ୍‌ତି କାପ୍‌ଡ଼ା କାତି କିୟ୍‍କିତାନ୍‌, ");
INSERT INTO peg_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","ଆରେ ତା କାପ୍‌ଡ଼ା ର ତାଡ଼ିୟାତ ତାସି ହେ ଗାଡ଼୍‌ଚେଂ ହିତାର୍‌, ପାଚେ ହେଦେଲ୍‌ ତା ତେହି ତାକେ ହେଦାଂ ଅତାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","ହେବେ ଜହନ୍‌ ଚେଲାହିର୍‌ ୱାଜ଼ି ମାଡ଼ା ଅଜ଼ି ତାଙ୍ଗେଙ୍ଗ୍‌ ମୁଚ୍‌ଚାର୍‌ ଆରି ହାଲ୍‌ଜି ଜିସୁଙ୍ଗ୍‌ ୱେଚ୍‌ଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","ଜହନ୍‌ କାବୁର୍‌ ୱେଚି ଦାପ୍ରେ ଜିସୁ ବିନେ ଆଜ଼ି ଡଙ୍ଗାତ ଦୁମ୍‌ଜି ର ଚିମ୍‌ରା ବାହାତ ହାଚାନ୍‌ । ଜିସୁ ହେବେ ହାନାକା ପୁଞ୍ଜି ଲାଗେନି ଗାଡ଼୍‌ନିକାର୍‌ତାଂ ହେନି ମାନାୟ୍‌ ଗୁଟି ଗୁଟି ତାଙ୍ଗ୍‌ଜି ଜିସୁତି ପାଚେ ପାଚେ ହାଚାର୍‌; ");
INSERT INTO peg_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","ଆରେ, ଜିସୁ ହେୱାନ୍‌ ଡଙ୍ଗାତାଂ ହସି ବେସି ହେନି ମାନାୟାରିଂ ହୁଡ଼୍‌ଜି ହେୱାର୍‌ କାଜିଂ କାର୍ମାତିଂ ତାଙ୍ଗ୍‌ ମାନ୍ତ ରାସ୍‌ ଇଚାତ୍‌ । ଆରି ହେୱାର୍‌ ରଗିରିଂ ଉଜ୍‌ କିତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","ୱେଡ଼ା ହାଚିଲେ ଚେଲାହିର୍‌ ତା କଚଣ୍‌ତ ୱାଜ଼ି ଇଚାର୍‌, ଇ ବାହାତ ଚିମ୍‌ରା, ଆରେ ୱେଡ଼ା ତ ହାଚାତେ, “ଲାଗିଂ ମାନାୟାର୍‌ ଇନେସ୍‌ ନାସ୍‌କୁକାଂ ହାଲ୍‌ଜି ଜାର୍‌ ଜାର୍‌ କାଜିଂ କାଦି କଡ଼୍‌ନାର୍‌, ହେଦାଂ କାଜିଂ ହେୱାରିଂ ହେଲ ହିୟାଟ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","ମାତର୍‌ ଜିସୁ ହେୱାରିଂ ଇଚାନ୍‌, “ହେୱାର୍‌ ହାନି ଲଡ଼ା ଆକାୟ୍‌, ଏପେଙ୍ଗ୍‌ ହେୱାରିଂ ଚିଚ୍‌ପାଟ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","ଚେଲାର୍‌ ହେୱାନିଙ୍ଗ୍‌ ଇଚାର୍‌, “ମା ଇବେ କେବଲ୍‌ ପାଞ୍ଚ୍‌ଗଟା ରୁଟି ଆରି ରିଣ୍ଡାଂ ମିନ୍‌କୁ ମାନିକ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","ଜିସୁ ଇଚାନ୍‌, “ହେୱାଙ୍ଗ୍‌ ଇବେ ନା କଚଣ୍‌ ତାଡୁ ।” ");
INSERT INTO peg_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","ଆରେ, ହେୱାନ୍‌ ମାନାୟାରିଂ କାଚ୍ରା ଜପି କୁଚ୍‌ନି କାଜିଂ ବଲ୍‌ ହିତାନ୍‌, ଆରେ ଜିସୁ ହେ ପାଞ୍ଚ୍‌ଗଟା ରୁଟି ଆରି ରିଣ୍ଡାଂ ମିନ୍‌କୁ ଅଜ଼ି ସାର୍ଗେ ନିପ ଜପି ହୁଡ଼୍‌ଜି ଆସିର୍ବାଦ୍‌ କିତାନ୍‌ ଆରି ରୁଟିଂ ଡ୍ରିକ୍‌ଚି ଚେଲାରିଂ ହିତାନ୍‌, ଆରେ ଚେଲାହିର୍‌ ମାନାୟାରିଂ ହିତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","ଆରେ, ୱିଜ଼ାକାର୍‌ ତିନ୍‌ଞ୍ଜି ପାଞ୍ଚାର୍‌ ଆରି ଡ୍ରିକ୍‌ତି ରୁଟିତାଂ ଏଚେକ୍‌ ହାର୍‌ତାତ୍‌, ହେଦାଂ ଚେଲାର୍‌ ନିକ୍‌ଚି ବାର ଟପା ବାର୍ତି କିତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","ତିନି ମାନାୟାର୍‌, କଗ୍‌ଲେକାଂ ଆରି ହିମ୍‌ଣାକାଂ ପିସ୍ତି, ଆନ୍‌ମାନ୍‌ତାଂ ପାଞ୍ଚ୍‌ ହାଜାର୍‌ ଆଣ୍ଡ୍ରାହିମ୍‌ଣାଂ ମାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","ହେ ଦାପ୍ରେ ଜିସୁ ଚେଲାରିଂ ଡଙ୍ଗାତ ଦୁମ୍‌ଜି ତା ମାଡ଼ି ଆନ୍‌ଟି ପାଡ଼୍‌କା ଆଗେ ହାନ୍‍ଞ୍ଜେଙ୍ଗ୍‍ ଇଚାନ୍‌, ଆରେ ହେୱାନ୍‌ ଇବେଣ୍ଡାଂ ମାନାୟାରିଂ ୱିଜ଼ାରିଂ ହେଲ ହିତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","ମାନାୟାରିଂ ହେଲ ହିତି ପାଚେ ଜିସୁ ପାର୍ତାନା କିନି କାଜିଂ ହସି ହାଲ୍‌ଜି ମାଡ଼ି ଜପି ହାଚାନ୍‌, ଆରେ ମିକା ଆତିଲେ ହେୱାନ୍‌ ହେବେ ରକାନ୍‌ ମାଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","ମାତର୍‌ ଡଙ୍ଗା ହେ ପାଦ୍‌ନା ଗୁଟିତାଂ ବେସି ଦେହା ମାଚାତ୍‌ ଆରି ଲଡ଼ି ଦୁକା କାଜିଂ ହେଦାଂ ତୁଙ୍ଗ୍‌ଜି ମାଚାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","ମାତର୍‌ କୁଜ଼ୁ କେପା ହେୱାନ୍‌ ହାମ୍‌ଦୁର୍‌ ଜପି ତାଙ୍ଗ୍‌ଜି ଚେଲାର୍‌ ତାକେ ୱାତାନ୍‌, ");
INSERT INTO peg_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","ଆରେ ଚେଲାହିର୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ହାମ୍‌ଦୁର୍‌ ଜପି ତାଂନାକା ହୁଡ଼୍‌ଜି ପାଣ୍ଡ୍ରା ଆଜ଼ି ଇଚାର୍‌, “ଇଦାଂ ତ ବାନ୍ୟା ପୁଦା” ଆରେ ହେୱାର୍‌ ପାଣ୍ଡ୍ରୁତିଂ କିକିରାଡିଂ କିତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","ମାତର୍‌ ଜିସୁ ହେ ଦାପ୍ରେ ହେୱାର୍‌ ଲାହାଙ୍ଗ୍‌ ବେଣ୍‌ କିଜ଼ି ଇଚାନ୍‌, ସାସ୍‌ ଆହାଟ୍‌, “ଇୱାଙ୍ଗ୍‌ ତ ଆନ୍‌, ପାଣ୍ଡ୍ରା ଆମାଟ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","ହେବେ ପିତର୍‌ ଉତର୍‌ ହିତାନ୍‌, “ଏ ମାପ୍ରୁ, ଇନାୱାଡ଼ାଂ ଏନ୍‌, ଲାଗିଂ ଏଜ଼ୁଂ ଜପି ନି ତାକେ ହାନି କାଜିଂ ନାଙ୍ଗ୍‌ ବଲ୍‌ ହିଦା ।” ");
INSERT INTO peg_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","ଜିସୁ ଇଚାନ୍‌, “ୱା” ହେବେ ପିତର୍‌ ଡଙ୍ଗାତାଂ ଜୁଜ଼ି ଏଜ଼ୁଂ ଜପି ତାଙ୍ଗ୍‌ଜି ଜିସୁ ତାକେ ହାଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","ମତର୍‌ ହେୱାନ୍‌ ଦୁକା ହୁଡ଼୍‌ଜି ପାଣ୍ଡ୍ରା ଆତାନ୍‌, ଆରେ ମୁଞ୍ଜ୍‌ନିହିଂ କିକିରାଡିଂ କିଜ଼ି ଇଚାନ୍‌ “ଏ ମାପ୍ରୁ, ନାଙ୍ଗେଙ୍ଗ୍‌ ରାକ୍ୟା କିଦା ।” ");
INSERT INTO peg_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","ଜିସୁ ହେ ଦାପ୍ରେ କେଇ ଲାମାୟ୍‌ କିଜ଼ି ତାଙ୍ଗେଙ୍ଗ୍‌ ଆସ୍ତି ଇଚାନ୍‌, “ଏ ଅଲପ୍‍ ପାର୍ତିକିନାକାୟ୍‌, ଇନାକିଦେଂ ପାର୍ତି କିଉୟା ?” ");
INSERT INTO peg_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","ଆରେ, ହେୱାର୍‌ ହେୱାର୍‌ ଲାଗାଂ ହାଲ୍‌ଜି ଡଙ୍ଗାତ ଦୁମ୍‌ତାନ୍‌, ଆରେ ଦୁକା ତିର୍‌ ଆତାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","ହେବେ ଡଙ୍ଗାତ ମାନି ଚେଲାର୍‌ ଜିସୁଙ୍ଗ୍‌ ପାର୍ତାନା କିଜ଼ି ଇଚାର୍‌, “ଏନ୍‌ ହାତ୍‌ପା ଇସ୍ୱର୍‌ ମେହିତି ।” ");
INSERT INTO peg_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","ହେୱାର୍‌ ନାସି ଗିନ୍ନେସର୍‌ ନାସ୍‌ତ ଏକାତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","ଆରେ, ହେ ବାହାନି ମାନାୟାର୍‌ ତାଙ୍ଗ୍‌ ଚିନ୍‌ କିତାର୍‌ ହେବେନି ଚାରିବେଣ୍‌ତାଂ ୱିଜ଼ୁ ନିପ କାବୁର୍‌ ପକ୍ତାର୍‌ ଆରି ମାନାୟାର୍‌ ସବୁ ରଗିରିଂ ତା ଲାଗାଂ ତାଇୱାତାର୍‌; ");
INSERT INTO peg_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","ଆରେ, ହେୱାର୍‌ ଇନେସ୍‌କି ଜିସୁ ହେନ୍ଦ୍ରାନି ଚେଲିଂ ଡୁନାର୍‌, ଇଦାଂ ଜିସୁଙ୍ଗ୍‌ ଗୱାରି କିଦେଙ୍ଗ୍‌ ଲାଗାତାର୍‌, ଆରେ ଏଚେକ୍‌ ଜାଣ୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ଡୁତାର୍‌, ୱିଜ଼ାର୍‌ ଉଜ୍‌ ଆତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","ଦିନେକ୍‌ କେତେ ଜାଣ୍‌ ପାରୁସିର୍‌ ଆରି ଦରମ୍‌ ଗୁରୁର୍‌ ଜିରୁସାଲମ୍‌ତାଂ ୱାଜ଼ି ଜିସୁଙ୍ଗ୍‌ ୱେନ୍‍ବାତାର୍, ");
INSERT INTO peg_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“ମା ଆଗେ ପ୍ରାଚିନାର୍‌ ରିତି ନିତି ହିଜ଼ି ହାଚାର୍ଣ୍ଣା, ମି ଚେଲାର୍‌ ଇନେକିଦେଂ ହେ ୱିଜ଼ୁ ଉଡ଼ା ଆନାରା ? ତିନି ଆଗେ ହେୱାର୍‌ ରିତିତ ଇନେକିଦେଂ ହାର୍‌ କିଜ଼ି କେଇ ନୁଜ଼ୁରା ।” ");
INSERT INTO peg_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","ଜିସୁ ହେୱାରିଂ ଉତର୍‌ ହିତାନ୍‌, “ଏପେଙ୍ଗ୍‌ ପା ମି ରିତି ନିତି କାଜିଂ ଇନେକିଦେଂ ଇସ୍ୱର୍‌ତି ବଲ୍‌ ଉଡ଼ା ଆନାଦେରା ? ");
INSERT INTO peg_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","ଇସ୍ୱର୍ତି ବଲ୍‌ କିତାନ୍‌ନ୍ନା, ଆବାଂ ଆୟାଙ୍ଗ୍‌ ୱାରି କିୟାଟ୍‌ । ଆରେ ଇନେର୍‌ ତା ଆବା କି ଆୟାଂ ସାଇପ୍‌ ହିନାନ୍‌, ହେୱାନ୍‌ ହାକି ଡାଣ୍ଡ୍‌ ପାୟା ଆନାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","“ମାତର୍‌ ଏପେଙ୍ଗ୍‌ ଇନାଦେରା ହିକ୍ୟା ହିନାଦେରା ଜେ ରୱାନ୍‌ ମାନାୟ୍‌ ଇମ୍‌ଣି ଅରତ୍‌ ଲାହାଙ୍ଗ୍‌ ଜାର୍‌ ଆବାଂ କି ଆୟାଙ୍ଗ୍‌ ସାଇଜ କିଦେଙ୍ଗ୍‌ ଆଡ଼୍‌ତାନ୍‌ମା ହେଦାଂ ଇସ୍ୱର୍‌ତିଂ ଦାନ୍‌ କିତାନ୍‌ନ୍ନା ଇଞ୍ଜି ୱେଚ୍‌ଚାର୍‌, ");
INSERT INTO peg_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","ହେୱାନ୍‌ ଆରେ ତା ଆବା ଆୟାଂ ହାତେନେ ଜତନ୍‌ କିଉନ୍‌ । ଇ ଲାକେ ଏପେଙ୍ଗ୍‌ ମିଦାଂ ବଲ୍‌ମନ୍ଦ୍‌ ରିତିନିତି କାଜିଂ ଇସ୍ୱର୍‌ତି ବଚନ୍‌ ବେକାର୍‌ କିନାଦେରା । ");
INSERT INTO peg_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","ଆଡ଼େ କାପ୍‌ଟିୟାର୍‌, ଜିସାୟ୍‌ ମି ବିସ୍ରେ ସମାନ୍‌ ବାବ୍ରେ ବେରଣ୍‌ ୱେଚ୍‌ଚାତାନ୍‌ନା !” ");
INSERT INTO peg_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","“ଇସ୍ୱର୍‌ ଇଞ୍ଜ୍‌ନାନା, ଇ ଜାତି ମୁମ୍‌ଦ ମାଙ୍ଗେଙ୍ଗ୍‌ ୱାରି କିଦ୍‌ନାର୍‌, ମାତର୍‌ ହେୱାର୍‌ ମାନ୍‌ ମା ତାଙ୍ଗ୍‌ ଦେହା ମାନାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","ନାଙ୍ଗ୍‌ ହେୱାର୍‌ ପାର୍ତାନା କିଦେଙ୍ଗ୍‌ ପଲ୍ୟା, ଇନାକିଦେଂକି ହେୱାର୍‌ ମାନାୟାର୍‌ତି ବିଦିଙ୍ଗ୍‌ ଦରମ୍‌ ବେରଣ୍‌ ଇଞ୍ଜି ହିକ୍ୟା ହିନାନ୍‌ ପଲ୍ୟା ମା ପାର୍ତାନା କିନାର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","ତା ପାଚେ ଜିସୁ ମାନାୟ୍‌ତିଂ କଚଣ୍‌ତ କୁକ୍‌ଚି ଇଚାନ୍‌, “ମାନ୍‌ ହିଜ଼ି ୱେନାଟ୍‌ ଆରି ବୁଜାଆଦେଂ ସେସ୍ଟା କିୟାଟ୍‌; ");
INSERT INTO peg_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","ମାନାୟ୍‌ ତାଙ୍ଗ୍‌ ୱେୟ୍‍ ବିତ୍ରେ ହାନାତ୍‌, ହେଦାଂ ତାଙ୍ଗ୍‌ ବିଟାଡ଼୍‌ କିଉତ୍‌; ମାତର୍‌ ଇନାକା ବିତ୍ରେତାଂ ଇନାକା ବାର୍ତ ୱାନାତ୍, ହେଦାଂ ତାଙ୍ଗେଙ୍ଗ୍‌ ବିଟାଡ଼୍‌ କିନାତ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","ଚେଲାର୍‌ ଜିସୁ ଲାଗେ ୱାଜ଼ି ଇଚାର୍‌, “ନି କାତା ୱେନ୍‌ଞ୍ଜି ପାରୁସିର୍‌ ରିସା ଆତାର୍ଣ୍ଣା, ଇଦାଂ ଇନାକା ଏନ୍‌ ପୁନୁୟା ?” ");
INSERT INTO peg_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","ଜିସୁ ଉତର୍‌ ହିତାନ୍‌, “ଇମ୍‌ଣି ମାର୍‌କୁ ନା ସାର୍ଗେନି ଆବା ରୁଜ଼୍‌ୱାତାନ୍ନା, ହେ ୱିଜ଼ୁ ଉଟ୍‌କା ଆଜ଼ି ହାନାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","ହେୱାର୍‌ ବିସ୍ରେ ତାନ୍ଦ୍ରା ଆମାଟ୍‌ । ହେୱାର୍‌ କାଣା ବିନ୍‌ କାଣାରିଂ ହାଜ଼ି ଚଚ୍‍ନାକାର୍ । ର କାଣା ଆରେ ର କାଣାଂ ହାଜ଼ି ଚଚ୍‍ଚିସ୍ ରିୟାର୍‌ ପା କ୍ଡଇଦ ଆର୍ଣ୍ଣାର୍ ।” ");
INSERT INTO peg_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","ହେବେଣ୍ଡାଂ ପିତର୍‌ ତାଙ୍ଗ୍‌ ଉତର୍‌ ହିତାନ୍‌, “ଉତର୍‌ମୁଡ଼୍‌ ମାଙ୍ଗେଙ୍ଗ୍‌ ବୁଜାୟ୍‌କିଦା ।” ");
INSERT INTO peg_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","ଜିସୁ ଇଚାନ୍‌, ଏପେଙ୍ଗ୍‌ ପା ଇନାକା “ଇ ପାତେକ୍‌ ବୁଜାଆଉଦେରା ? ");
INSERT INTO peg_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","ଇନାକା ୱେଇଦ ହଣାତ୍, ହେଦାଂ ପଟତ ହାଲ୍‌ଜି ବାର୍ତବାହାତ ହାନାତ୍‌, ଇଦାଂ ଇନାକା ବୁଜା ଆଉଦେରା ? ");
INSERT INTO peg_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","ମାତର୍‌ ୱେଇଦାଂ ଇନାକା ସବୁ ହନାତ୍‌, ହେଦାଂ ୱାସ୍କିତାଂ ହନାତ୍‌ ଆରି ହେଦାଂ ନେ ମାନାୟ୍‌ତିଂ ବିଟାଡ଼୍‌ କିନାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","ଇନାକିଦେଂକି ମାନ୍‌ତାଂ କାରାପ୍‌ ବିସ୍ରେ, ବେକାର୍‌ ଚିନ୍ତା ମାନାୟ୍‌ ଟୁଣାକା, ଦାରି, ମ୍ଡାନାକା, ମିଚ୍‌ ସାକି, ଆରି ନିନ୍ଦା କିନାକା ହନାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","ଇଦାଂ ୱିଜ଼ୁ କାମାୟ୍‌ ମାନାୟ୍‌ତିଂ ବିଟାଡ଼୍‌ କିନାତ୍‌, ମାତର୍‌ ହେୱାର୍‌ କିନି କାଜିଂ ମାତର୍‌ ରିତିନିତି ଲାକେ କେଇ ନୁସ୍‌ୱାଦାଂ ଚିଚିସ୍‌ ମାନାୟାରିଂ ବିଟାଡ଼୍‌ କିଉତ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","ଜିସୁ ହେ ବାହା ପିସ୍ତି ସର ଆରି ସିଦନ୍‌ ନିପ ଲାଗେ ଗାଡ଼୍‌ଦ ହାଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","ଆରେ ହୁଡ଼ା, ହେ ହାନ୍ଦିତାଂ ରଞ୍ଜେଲ୍‌ କିଣାନିୟ କଗ୍‌ଲେ ଗାଜା କାଟ୍‌ତାଂ ଇଞ୍ଜେଙ୍ଗ୍‌ ଲାଗାତାତ୍‌, “ଏ ମାପ୍ରୁ ଦାଉଦ୍‌ତି ହିମ୍‍ଣା ନାଙ୍ଗ୍‌ ଦୟା କିଦା । ମାଞ୍ଜି ଗାଡ଼୍‌ଚେଂ ପୁଦା ଆସ୍ତାତାନ୍ନା ଆରି ହେଦେଲ୍‌ ବେସି କସ୍ଟ ଆନାତା ।” ");
INSERT INTO peg_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","ମାତର୍‌ ଜିସୁ ତାଙ୍ଗେଙ୍ଗ୍‌ ପାଦେକ୍‌ ପା ଉତର୍‌ ହିୱାତାନ୍ । ଆରି ତା ଚେଲାହିର୍‌ ୱାଜ଼ି ତାଙ୍ଗ୍‌ ଗୱାରି କିଜ଼ି ଇଞ୍ଜେଙ୍ଗ୍‌ ଲାଗାତାର୍‌, “ଇଦେଲିଂ ହାଜ଼ି ଲୱାଡ଼୍‌ ହିୟା, ଇନାକିଦେଂକି ଇଦେଲ୍‌ ମା ପାଚେ ପାଚେ ଆଲା ଆନାତା ।” ");
INSERT INTO peg_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","ଜିସୁ ଉତର୍‌ ହିତାନ୍‌, “ଜାଙ୍ଗ୍‌ତି ମେଣ୍ଡା ଲାକେ ହାଜ଼ିବାଣାତି ଇସ୍ରାଏଲ୍‌ନି ଲକ୍‌ ତାକେ ଆନ୍‌ ୱାତାଙ୍ଗ୍‍ନା ।” ");
INSERT INTO peg_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","ମାତର୍‌ କଗ୍‌ଲେ ୱାଜ଼ି ଜିସୁଙ୍ଗ୍‌ ଜୱାର୍‌ କିଜ଼ି ଇଞ୍ଜେଙ୍ଗ୍‌ ଲାଗାତାତ୍‌, “ମାପ୍ରୁ, ନାଙ୍ଗେଙ୍ଗ୍‌ ଦୟା କିଦା ।” ");
INSERT INTO peg_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","ଜିସୁ ଇଚାନ୍‌, “ହିମ୍‍ଣାଙ୍ଗ୍‍ତି ଆରାଣ୍‌ ଅଜ଼ି ନିକୁଡ଼ିଙ୍ଗ୍‌ କଚଣ୍‌ତ ତୁହିନାକା ହାର୍‌ ଆକାୟ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","ମାତର୍‌ ହେଦେଲ୍‌ ଇଚାତ୍‌, “ଆଁ, ମାପ୍ରୁ, ମାତର୍‌ ନିକୁଡ଼ିଙ୍ଗ୍‌ ତ ଜାର୍‌ ଜାର୍‌ ମାପ୍ରୁତି ପାଟା ତାରେନ୍‌ ଆର୍‌ତି ସୁକ୍‍ଡ଼ି ତିନିକ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","ଜିସୁ ତା କାତାନି ଉତର୍‌ ହିଜ଼ି ଇଚାନ୍‌, “ଏ କଇ, ନିନ୍ଦାଂ ଗାଜା ପାର୍ତି, ନି ଇଚା ହୁକେ ନିଂ ଗିଟାଏତ୍ ।” ହେ ସମୁତ ହେଦେଲ୍‌ତି ଗାଡ଼୍‌ଚେ ଉଜ୍‌ ଆତାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","ଜିସୁ ହେବେତାଂ ହସି ଗାଲିଲି ଗୁଟି ଗୁଟି ହାଲ୍‌ଜି ର ମାଡ଼ି, ଜପି କୁଚାନ୍ । ");
INSERT INTO peg_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","ଆରେ, ବେସିହେନି ମାନାୟ୍‌ ଟୁଟା, କାଣା, ଚଟା, ଗୁଲା, ଆରି ବେସି ବେମାର୍‌ ମାନାୟାରିଂ ତାସି ଜିସୁ ପାନା ତାରେନ୍‌ ଇଡ୍‌ତାର୍‌ ଆରେ ଜିସୁ ୱିଜ଼ାରିଂ ଉଜ୍‌ କିତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","ଇ ଲାକେ କନ୍ଦା ବେଣ୍‌ କିତାନ୍‌, ଚଟାର୍‌ ଉଜ୍‌ ଆତାର୍‌, ଚଟାର୍‌ ତାଙ୍ଗ୍‍ତାର୍, କାଣାର୍‌ ହୁଡ଼୍‍ନାରା, ଇଦାଂ ହୁଡ଼୍‌ତାର୍‌, ଆରି ଇସ୍ରାଏଲ୍‌ନି ଇସ୍ୱର୍ତି ପାର୍ତାନା କିତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","ଜିସୁ ଚେଲାହିର୍‌ ହିର୍‌ବିସ୍‌ ଇଚାନ୍‌, “ଇ ମାନାୟାର୍‌ କାଜିଂ ନାଙ୍ଗ୍‌ ଦୁକ୍‌ ହତ୍‌ନାତା, ଇନାକିଦେଂକି ଇୱାର୍‌ ନା ଲାହାଙ୍ଗ୍‌ ତିନ୍‌ ଦିନ୍‌ ଆତାତେ ଆରି ନଙ୍ଗ୍‌ ହେୱାର୍‌ କଚଣ୍‌ତ ଇନାକା ତିନାକା ହିଲୁତ୍‌ । ହେୱାର୍‌ ତିନ୍‌ୱାଦାଂ ଇବେତାଂ ପକ୍‌ତେଂ, ଇ କାତା ଆନ୍‌ ମାନ୍‍କିଉଙ୍ଗ୍; ଇନାକିଦେଂକି ହାନିହିଂ ହାସ୍‌ଦ ହେୱାର୍‌ ନାସ୍କି ବାଉଡ଼ା ଆସି ଗୁର୍‌ନାର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","ଚେଲାହିର୍‌ ତାଙ୍ଗ୍‌ ୱେନ୍‍ବାତାର୍, “ଏଚେକ୍‌ ମାନାୟାରିଂ ଚିଚ୍‌ପେଦେଂ ଆସେଙ୍ଗ୍‌ ଚିମ୍‌ରା ବାହାତ ଇମେଣ୍ଡାଂ ଏଚେକ୍‌ ରୁଟିଂ ଗାଟାନାସ୍ ।” ");
INSERT INTO peg_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","ଜିସୁ ହେୱାରିଂ ୱେନ୍‌ବାତାନ୍‌, ମି ତାକେ ଏଚଙ୍ଗ୍ ରୁଟିଂ ମାନିକ୍‌ ? ହେୱାର୍‌ ଇଚାର୍‌, “ସାତ୍‌ଗଟା, ଆରେ, ଅଲପ୍‍ କେତ୍‌ଗଟା ହିରୁ ମିନ୍‌କୁ ।” ");
INSERT INTO peg_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","ଜିସୁ ମାନାୟାରିଂ ମେଦ୍‌ନିତ ଜପି କୁଚ୍‌ଚେଂ ୱେଚ୍‌ଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","ଆରେ ଜିସୁ ହେ ସାତ୍‌ଗଟା ରୁଟିଂ ଆରି ମିନ୍‌କୁ ଅଜ଼ି ଦନ୍ୟବାଦ୍‌ ହିଜ଼ି ହେ ସବୁ ଚେଲାହିରିଂ ହିତାନ୍‌, ହେୱାର୍‌ ମାନାୟାରିଂ ହିତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","ଆରେ, ୱିଜ଼ାର୍‌ ତିନ୍‌ଞ୍ଜି ପଟ ପାନ୍‌ଚାର୍ ଆରି ଡ୍ରିକ୍‌ତି ରୁଟିଂ ଏଚେକ୍‌ ହାର୍‌ତାତ୍‌, ହେଦାଂ ହେୱାର୍‌ ପେସ୍‌ଦି ସାତ୍‌ ଟପା ବାର୍ତି କିତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","କଗ୍‌ଲେ ଆରି ହିମ୍‌ଣାକାଂ ପିସ୍ତି ଚାରି ହାଜାର୍‌ ଆଣ୍ଡ୍ରାହିମ୍‌ଣାଂ ମାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","ଇଦାଂ ପାଚେ ଜିସୁ ମାନାୟାରିଂ ହେଲ ହିଜ଼ି ଡଙ୍ଗାତ ଦୁମ୍‌ଜି ମୁଗ୍‌ଦାନ୍‌ ନିପ ହାଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","ଦିନେକ୍‌ କେତେଜାଣ୍‌ ପାରୁସି ଆରି ସାଦୁକିର୍‌ ଜିସୁ ତାକେ ୱାଜ଼ି ତାଙ୍ଗେଙ୍ଗ୍‌ ପରିକ୍ୟା କିଦେଂ ୱେନ୍‌ବାତାର୍‌ ହେୱାରିଂ ଆକାସ୍‌ତାଂ ର ଚିନ୍‌ ଚଚ୍‌ନି କାଜିଂ ତାଙ୍ଗେଙ୍ଗ୍‌ ଗୱାରି କିତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","ମାତର୍‌ ଜିସୁ ହେୱାରିଂ ଉତର୍‌ ହିତାନ୍‌, “ମ୍ଡିକାହାରେସ୍‌ ଏପେଙ୍ଗ୍‌ ଇଞ୍ଜିମାନାଦେର୍, ହାର୍‌ ପାଗ୍‌ ଆନାତ୍‌, ଇନାକିଦେଂକି ଆକାସ୍‌ ଗେରୁ ମାନ୍‌ଗାନାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","ଆରେ, ଉଟ୍‌ଲା ହାକାଡ଼େ ଇଞ୍ଜିମାନାଦେର୍, ନେଞ୍ଜେଙ୍ଗ୍‌ ଦୁକାବାର୍ହା ୱାନାତ୍, ଇନାକିଦେଂକି ଆକାସ୍‌ ଗେରୁ ଆରି ବାଦାଡ଼୍‌ ଆତାତ୍‌ନ୍ନା । ଏପେଙ୍ଗ୍‌ ବାଦାଡ଼୍‌ତାଂ ଇଟ୍‌କାଡ଼୍‌ ଆନାକା ଆୱାକା ବୁଜାନାଦେରା, ମାତର୍‌ କାଡ୍‌ନି ଇଟ୍‌କାଡ଼୍‌ ସବୁ ବୁଜାଉଦେରା ? ");
INSERT INTO peg_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","ଉତ୍‌ପାତ୍ୟା ଆରି ଦାରୁଲାର୍‌ ଲାତ୍ରା ଚିନ୍‌ ଡେକ୍‌ନାର୍‌, ମତର୍‌ ଜୁନସ୍‌ତି ଚିନ୍‌ ପିସ୍ତି ବିନେନି ଇନାକା ପା ଚିନା ହେୱାରିଂ ହିୟାଉତ୍ । ଆରେ ଜିସୁ ହେୱାରିଂ ପିସ୍ତି ହାଚାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","ଚେଲାର୍‌ ହାମ୍‌ଦୁର୍‌ ଆଣ୍ଟିପାଡ଼୍‌କା ହାନିୱାଡ଼ାଲିଂ ରୁଟି ଅଦେଂ ବାଣା ଆତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","ଜିସୁ ହେୱାରିଂ ଇଚାନ୍‌, “ଜାଗ୍ରତ୍‌ ଆଡୁ, ପାରୁସି ଆରି ସାଦୁକିର୍ତି ହଇନିତାଂ ଜାଗ୍ରତ୍‌ ଆଜ଼ି ମାନାଟ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","ହେବେ ହେୱାର୍‌ ନିଜେ ନିଜେ ବେଣ୍‌କିବା ଆଜ଼ି ଇଞ୍ଜେଙ୍ଗ୍‌ ଲାଗାତାର୍‌, “ଆପେଂ ରୁଟି ତାୟିୱାୱାତାପ୍‌ନା ଇଞ୍ଜି ହେୱାନ୍‌ ଇ କାତା ଇଞ୍ଜ୍‌ନାନା ।” ");
INSERT INTO peg_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","ମାତର୍‌ ଜିସୁ ହେଦାଂ ପୁଞ୍ଜି ଇଚାନ୍‌, ଏ ଅଲପ୍‍ ପାର୍ତି କିନାକାଦେର୍‌, “ମି କଚଣ୍‌ ରୁଟିଂ ହିଲୁକ୍‌ ଇଞ୍ଜି ଇନେକିଦେଂ ରକାନ୍‌ ଆରେ ରକାନ୍ ବେଣ୍‌ କିନାଦେରା ? ");
INSERT INTO peg_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","ଏପେଙ୍ଗ୍‌ ଇନାକା ନଙ୍ଗ୍‌ ପାତେକ୍‌ ବୁଜା ଆଉଦେରା ? ପାଞ୍ଚ୍‌ ହାଜାର୍‌ ମାନାୟାରିଂ ପାଞ୍ଚ୍‌ଗଟା ରୁଟିଂ, ଆରି ଏଚେ ଟପା ନିକ୍‍ତାଦେର୍ ? ");
INSERT INTO peg_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","ଆରେ ଚାରି ହାଜାର୍‌ ମାନାୟାର୍‌ କାଜିଂ ସାତ୍‌ଗଟା ରୁଟିଂ କାତା ମାନେ ଆକାୟ୍‌ ? ହେ ପାଦ୍‌ନା ଏଚେଗଟା ଟପାଙ୍ଗ୍ ବାର୍ତି କିଜ଼ି ମାଚାଦେର୍‌ ? ");
INSERT INTO peg_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","ଆନ୍‌ ରୁଟିଂ ବିସ୍ରେ ଇନ୍‌ୱାଦାଂ ମାନ୍‌ଚାଙ୍ଗ୍‌, ଏପେଙ୍ଗ୍‌ ଇନେସ୍‌ ବୁଜା ଆଉଦେରା ? ଆନ୍‌ ଇଞ୍ଜ୍‌ନାଙ୍ଗା, ପାରୁସି ଆରି ସାଦୁକିର୍‌ ହୟ୍‌ନାକା କାଜିଂ ଜାଗ୍ରତ୍‌ ମାନାଟ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","ହେ ପାଦ୍‌ନା ଚେଲାହିର୍‌ ବୁଜାତାର୍‌ ଜେ ଜିସୁ ରୁଟିନି ହଇନି କାତା ଇନ୍‌ୱାଦାଂ ମାଚାନ୍‌, ମାତର୍‌ ପାରୁସି ଆରି ସାଦୁକିର୍ତି ହିକ୍ୟା କାଜିଂ ଜାଗ୍ରତ୍‌ କିଜ଼ି ହିଜ଼ି ମାଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","ଜିସୁ କାଇସରିୟା ପିଲିପି ଗାଡ଼୍‌ ଲାଗାଂ ନିପ ୱାଜ଼ି ଜାର୍‌ ଚେଲାରିଂ ୱେନ୍‌ବେଦେଂ ଲାଗାତାନ୍‌, “ମାନାୟ୍‌ ମାଜ଼ି ଇନେର୍‌ ଇଞ୍ଜି ମାନାୟାର୍‌ ଇନାକା ଇଞ୍ଜ୍‌ନାର୍‌ ?” ");
INSERT INTO peg_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","ଇବେତାଂ ହେୱାର୍‌ ଇଚାର୍‌, “ଇନେର୍‌ ଇନେର୍‌ ଇନାର୍‌, ବାପ୍ତିସିମ୍‌ ଜହନ୍‌, ଇନେର୍‌ ଇନେର୍‌ ଇନାର୍‌ ଏଲିୟ, ଆରେ ଇନେର୍‌ ଇନେର୍‌ ଜିରିମିୟ ଆରେ ବେଣ୍‌ବାକ୍‌ଣାୟ୍‌ କିନାକାର୍‌ ବିତ୍ରେ ରକାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","ଜିସୁ ୱେନ୍‌ବାତାନ୍‌, “ଆନ୍‌ ଇନେର୍‌ ଇ ବିସ୍ରେ ଏପେଙ୍ଗ୍‌ ଇନାକା ଇନାଦେରା ?” ");
INSERT INTO peg_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","ସିମନ୍‌ ପିତର୍‌ ଉତର୍‌ ହିତାନ୍‌, “ଏନ୍‌ କ୍ରିସ୍ଟ ମସିୟା, ଜିବୁନ୍ତି ଇସ୍ୱର୍ତି ମାଜ଼ି ।” ");
INSERT INTO peg_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","ଜିସୁ ଇଚାନ୍‌, “ଦନ୍ୟ ଏନ୍‌ ଜୁନସ୍‌ତି ମାଜ଼ି, ସିମନ୍‌ !” ଇ ହାତ୍‌ପା ଏନ୍‌ ଇମ୍‌ଣି ମାନାୟ୍‌ତାଂ ଗାଟାଆୱାତାୟ୍‌ନା । “ନା ସାର୍ଗେନି ଆବା ଜାର୍‌ ଇଦାଂ ମି ତାକେ ଇଚାନ୍ନା ।” ");
INSERT INTO peg_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","“ଆରେ, ଆନ୍‌ ପା ମିଙ୍ଗେଙ୍ଗ୍‌ ଇଞ୍ଜ୍‌ନାଙ୍ଗା, ଏନ୍‌ ପିତର୍‌, ଆରେ ଇ କାଲ୍‌ ଜପି ଆନ୍‌ ଜାର୍‌ ମଣ୍ଡ୍‌ଲି ରଚ୍‌ନାଙ୍ଗ୍‌, ଆରେ ପାତାଲ୍‌ନି ସାକ୍ତି ହେୱାନିଂ ଆରାୟ୍‌ କିଉତ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","“ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ସାର୍ଗେ ରାଜିନି କୁଚିକାଡିଙ୍ଗ୍ ହିଦ୍‌ନାଂ । ଆରେ ଏପେଙ୍ଗ୍‌ ପୁର୍ତିତ ଇନାକା ବନ୍ଦ୍‌ କିନାଦେର୍‌, ସାର୍ଗେତପା ହେଦାଂ ବନ୍ଦ୍‌ ମାନ୍‌ଗାନାତ୍‌ । ଆରି ପୁର୍ତିତାକେ ଇନାକାପା ଜେନାଦେର୍‌, ସାର୍ଗେତ ପା ଜେନାଦେର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","ଜିସୁଙ୍ଗ୍‌ କ୍ରିସ୍ଟ ମସିୟା ଇଞ୍ଜି ଇନେର୍‌ ଆଗେ ୱେଚ୍‍ମାଟ୍‍ ଇଞ୍ଜି ଜିସୁ ଚେଲାହିରିଂ ବଲ୍‌ ହିତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","ହେ ସମୁତ ଜିସୁ କ୍ରିସ୍ଟ ଚେଲାହିରିଂ ହାର୍‌ କିଜ଼ି ଇଞ୍ଜେଙ୍ଗ୍‌ ଲାଗାତାନ୍‌, “ଆନ୍‌ ଜିରୁସାଲମ୍‌ତ ହାଲ୍‌ଜି ପ୍ରାଚିନ୍‌ ମୁଡ଼୍‌ ମାପ୍ରୁହେବାକିନାକାନ୍‌, ଦରମ୍‌ ଗୁରୁ ଦରମ୍‌ ନେତାର୍‌ କାଜିଂ ଚୁପ୍‌ୟାଆଜ଼ି ବେସି କସ୍ଟ ବଗି କିନାଙ୍ଗ୍‌ । ହାରିହାରା ହାନାଙ୍ଗ୍‌, ମାତର୍‌ ତିନ୍‌ଦିନ୍‌ତାଂ ନିଙ୍ଗ୍‌ନାକା ମାନାତ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","ହେବେତାଂ ପିତର୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ର ବାହାତ ଅଜ଼ି ହାଲ୍‌ଜି ଉଲ୍‌ଟା ପାଲ୍‌ଟା କିଜ଼ି ଗଡ଼୍‌କିଦେଂ ଲାଗାତାନ୍‌, “ଏ ମାପ୍ରୁ, ଇସ୍ୱର୍‌ ନିଙ୍ଗେଙ୍ଗ୍‌ ଦୟା କିଦେନ୍‌, ଇଦାଂ ନି କାଜିଂ ଇନାୱାଡ଼ାଂ ପା ଗିଟାଆମେତ୍‍ ।” ");
INSERT INTO peg_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","ମାତର୍‌ ଜିସୁ ମାସ୍‌ଦି ପିତର୍‌ତିଂ ଇଚାନ୍‌, “ନା ଲାଗେତାଂ ଦେହା ଆ, ସୟ୍‌ତାନ୍‌, ଏନ୍‌ ନା ବାଦା ଲାକେ, ଇନାକିଦେଂକି ଏନ୍‌ ଇସ୍ୱର୍‌ ବିସ୍ରେ ବାବି କିୱାଦାଂ ମାନାୟ୍‌ ବିସ୍ରେ ବାବିକିନାୟା ।” ");
INSERT INTO peg_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","ତା ପାଚେ ଜିସୁ ଚେଲାରିଂ ଇଚାନ୍‌, “ଜେ ଇନେର୍‌ ନା ଲାହାଙ୍ଗ୍‌ ୱାନାନ୍‌, ହେୱାନ୍‌ ମାନ୍‌ବାଦ୍‌ଲାୟ୍‌ କିଜ଼ି ଜାର୍‌ କ୍ରୁସ୍‌ ଆସ୍ତି ନା ପାଚେ ପାଚେ ୱାନାକା ମାନାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","ଇନାକିଦେଂକି ଇନେର୍‌କି ଜାର୍‌ତିଂ ଜିବୁନ୍‌ ରାକ୍ୟା କିଦେଙ୍ଗ୍‌ ଇଚା କିନାନ୍‌, ହେୱେନ୍‌ ହେଦାଂ ଆରାୟ୍‌ କିନାନ୍‌; ମାତର୍‌ ଇନେର୍‌କି ନା କାଜିଂ ଜାର୍‌ ଜିବୁନ୍‌ ଆରାୟ୍‌ କିନାନ୍‌, ହେୱେନ୍‌ ହେଦାଂ ପାୟାଆନାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","ଆରେ, ମାନାୟ୍‌ ଏଚେକାଡ଼୍‌ଦ ୱିଜ଼ୁ ପୁର୍ତିତିଂ ଲାବ୍‌ କିଜ଼ି ଜାର୍‌ ଜିବୁନ୍‌ ଆରାୟ୍‌ କିନାନ୍‌, ଲାଗିଂ ତାଦି ଇନା ଲାବ୍‌ ଆନାତ୍‌ ? ମତର୍‌ ମାନାୟ୍‌ ଜାର୍‌ ଜିବୁନ୍‌ ବାଦୁଲ୍‌ ଇନାକା ହିନାୟ୍‌ ? ");
INSERT INTO peg_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","ଆରି, ମାନାୟ୍‌ ମାଜ଼ି ଜାର୍‌ ଆବାତି ପାଣ୍‌ଦାଙ୍ଗ୍‌ ଜାର୍‌ ଦୁତ୍‌ର୍‌ ଲାହାଙ୍ଗ୍‌ ଆରେ ରଗ ଜୁଦ୍‌ନାନ୍‌ ଆରି ହେ ପାଦ୍‌ନା ହେୱେନ୍‌ ୱିଜ଼ାର୍‌ ମାନାୟାରିଂ ହେ କାମାୟ୍‌ ହୁଡ଼୍‌ଜି ପାଡ଼୍‌ ହିଦ୍‌ନାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ହାତ୍‌ପା ଇଞ୍ଜ୍‌ନାଙ୍ଗା ମାନାୟ୍‍ ମାଜ଼ିତି ଜାର୍‌ ରାଜିତ ଜୁଦେଂ ହୁଡ଼୍‌ୱି ପାତେକ୍‌ ଇବେ ନିଲ୍‌ଚିମାନି ମାନାୟାର୍‌ ବିତ୍ରେତାଂ କେତେକ୍‌ ଇନେସ୍‌ ବାନି ହାକିଡାଣ୍ଡ୍‌ ପାୟା ଆଉନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","ଜିସୁ ଇ ଚଅ ଦିନ୍‌ ପାଚେ ପିତର୍‌ ଆରି ଜାକୁବ୍‌, ଜହନ୍‌ ଟଣ୍ଡ୍‌ରିୟାରିଂ ଅଜ଼ି ର ପାନ୍ତି ମାଡ଼ିଜପି ହାଚାର୍‌ । ହେବେ ବିନେନିକାର୍‌ ଇନେର୍‌ ହିଲ୍‌ୱାତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","ଚେଲାହିର୍‌ ହୁଡ଼ୁ ହୁଡ଼ୁ ଜିସୁତି ର ତ୍ରିପ୍‌କୁ ପାଗ୍‌ମାସ୍‌ବାତାନ୍‌ । ହେୱାନ୍‌ ୱେଇ ୱେଡ଼ାଲାକେ ଅଜଡ଼୍‌ ଆତାତ୍‌ ଆରେ ହେୱାନ୍‌ତି ହେନ୍ଦ୍ରା ଅଜଡ଼୍‌ ଲାକେ ଡ଼ିଞ୍ଚାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","ମସା ଆରି ଏଲିୟ ଜିସୁ ଲାହାଙ୍ଗ୍‌ କାତାର୍ବାତା ଆନାକା ଚେଲାର୍‌ ହୁଡ଼୍‌ତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","ହେବେ ପିତର୍‌ ଜିସୁଙ୍ଗ୍‌ ଇଚାନ୍‌, “ଏ ମାପ୍ରୁ, ଆସେଙ୍ଗ୍‌ ଜେ ଇ ବାହାତ ମାନାସ୍‌, ଇଦାଂ ହାର୍‌ଦାକା; ନି ଇଚା ଆତିସ୍‌ ଆନ୍‌ ଇବେ ତିନିଗଟା ପୁଟ୍‌କୁ ରଚ୍‍ନାଙ୍ଗ୍ ନି କାଜିଂ ରଞ୍ଜାଙ୍ଗ୍‌, ମସା କାଜିଂ ରଞ୍ଜାଙ୍ଗ୍‌ ଆରି ଏଲିୟ କାଜିଂ ରଞ୍ଜାଙ୍ଗ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","ହେୱାନ୍‌ ଇ କାତା ଇନୁ ଇନୁ, ହୁଡ଼ାଟ୍‌, ଇଚୁକ୍‌ ବାଦାଡ଼୍‌ ହେୱାରିଂ ଡାବାୟ୍‌ କିତାତ୍‌, ଆରି ହୁଡ଼ାଟ୍‌, ଇ ସବଦ୍ ଆତାତ୍‌, “ଇ ମା ୱାରିନି ମାଜ଼ି ଇୱାନ୍‌ ତାକେ ମା ଅପ୍ରବଲ୍‌ ୱାରି, ଇୱାନ୍ତି ବଚନ୍‌ ମାନ୍ତ ଇଟାଟ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","ଇଦାଂ ୱେନ୍‌ଞ୍ଜି ଚେଲାହିର୍‌ ମୁମ୍‌ ତାରେନ୍‌ କିତାର୍‌ ଆରି ବେସି ପାଣ୍ଡ୍ରା ଆତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","ଜିସୁ ହେୱାର୍‌ ଲାଗେ ୱାଜ଼ି ହେୱାରିଂ ଡୁବିସ୍‍ ଇଚାନ୍‌, “ନିଙ୍ଗା, ପାଣ୍ଡ୍ରା ଆମାଟ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","ଲାଗିଂ ହେୱାର୍‌ ଜପି ହୁଡ଼୍‌ଜି ଜିସୁଙ୍ଗ୍‌ ପିସ୍ତି ହେବେ ଆରେ ଇନେରିଂ ହୁଡ଼୍‌ୱାତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","ହେୱାର୍‌ ମାଡ଼ିତାଂ ଜୁଜ଼ି ୱାନିହିଂ ଜିସୁ ହେୱାରିଂ ବଲ୍‌ ହିଜ଼ି ଇଚାନ୍‌, “ମାନାୟ୍‌ ମାଜ଼ି ହାକିତାଂ ନିଙ୍ଗ୍‌ନି ପାତେକ୍‌, ଇନାକା ହୁଡ଼୍‌ତାଦେର୍ଣ୍ଣା ହେଦାଂ ନିଙ୍ଗ୍‌ୱି ପାତେକ୍‌ ଇନେରିଂ ପା ୱେଚ୍‌ମାଟ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","ଚେଲାହିର୍‌ ଜିସୁଙ୍ଗ୍‌ ୱେନ୍‌ବାତାର୍, “ଏଲିୟ ପର୍ତୁମ୍‌ ୱାନାନ୍ ଇଞ୍ଜି ମା ଦରମ୍‌ ଗୁରୁର୍‌ ଇନେକିଦେଂ ଇଞ୍ଚାର୍ଣ୍ଣା ?” ");
INSERT INTO peg_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","ଜିସୁ ଉତର୍‌ ହିତାନ୍‌, “ଆଁ, ହାତ୍‌ପା ଏଲିୟ ପର୍ତୁମ୍‌ ୱାଜ଼ି ସବୁ ବିସ୍ରେ ଜାଲ୍‌ଦି କିନାନ୍‌; ");
INSERT INTO peg_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","ମାତର୍‌ ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ଇଞ୍ଜ୍‌ନାଙ୍ଗା, ଏଲିୟ ୱାତାନେ ମତର୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ଚିନ୍‌କିୱାଦାଂ ମାନାୟାର୍‌ ତା କାଜିଂ ଇନାକା ଇଚା, ହେଦାଂ କିତାନ୍‌ନ୍ନା । ମାନାୟ୍‌ ମାଜ଼ି କାଜିଂ ପା ହେୱାର୍‌ ହେ ଲାକେ କାରାପ୍‌ ଚିନ୍ତା କିତାର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","ହେୱେଡ଼ାଂ ଚେଲାର୍‌ ବୁଜାତାର୍‌ ଜେ, ଜିସୁ ବାପ୍ତିସିମ୍‌ ହିନି ଜହନ୍‌ତି ବିସ୍ରେ ଇନାନ୍ନା । ");
INSERT INTO peg_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","ପାଚେ ଚେଲାର୍‌ ମାନାୟାର୍‌ ଲାଗେ ୱାଜ଼ି, ରକାନ୍‌ ମାନାୟ୍‌ ଜିସୁ ଲାଗେ ୱାଜ଼ି ମେଣ୍ଡାଂ କୁନ୍ଦିକିଜ଼ି ଇଚାନ୍‌, ");
INSERT INTO peg_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“ଏ ମାପ୍ରୁ, ନା ମାଜ଼ି ଦୟା କିୟା, ଇନାକିଦେଂକି ହେୱାନ୍‌ ଆପ୍ରାଂତ ବେସି କସ୍ଟ ପାୟାନାନା, ହେୱାନ୍‌ ରଗତିଂ ରଗ ନାଣିତ ଆରି ରଗତିଂ ରଗ ଏଜ଼ୁକାଂ ଆର୍ଣ୍ଣାନା । ");
INSERT INTO peg_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","ଆନ୍‌ ନି ଚେଲାରିଂ କଚଣ୍‌ତ ହେୱାନିଂ ତାଜ଼ି ମାଚାଙ୍ଗ୍‌, ମତର୍‌ ହେୱାର୍‌ ହେୱାନିଂ ଉଜ୍‌ କିଦେଙ୍ଗ୍‌ ହେୱାର୍‌ ଆଡ୍‌ୱାତାର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","ଜିସୁ ଉତର୍‌ ହିତାନ୍‌, “ଆଡ଼େ ପାର୍ତି କିୱାକାର୍‌ ଆରି ଉଚ୍‌କା ଆନି ମାନାୟ୍‌, ଏଚେକ୍‌ କାଡ଼୍‌ ଆନ୍‌ ମି ଲାହାଙ୍ଗ୍‌ ମାନ୍‌ଗାନାଂ ? ଏଚେକ୍‌ କାଡ଼୍‌ ମି ଚିନ୍ତା ହୁଡ଼୍‍ଦାନାଙ୍ଗ୍ ? ତାଙ୍ଗେଙ୍ଗ୍‌ ନାତାକେ ତାଇୱାଡୁ ।” ");
INSERT INTO peg_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","କାଡ଼୍‌ଦେ ବିତ୍ରେ ବୁତ୍‌ ମାଚାତ୍‌, ଜିସୁ ବୁତ୍‌ତିଙ୍ଗ୍ ଦାକା କିତିଲେ ବୁତ୍‌ କାଡ଼୍‌ଦେତାଂ ହସି ହାଚାତ୍‌ ଆରି କାଡ଼୍‌ଦେ ହେ ଦାପ୍ରେ ଉଜ୍‌ ଆତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","ଇଦାଂ ପାଚେ ଚେଲାର୍‌ ଡ଼ୁଗ୍‌ଜି ଜିସୁଙ୍ଗ୍‌ ଲାଗେ ୱାଜ଼ି ଇଚାର୍‌, ଆପେଙ୍ଗ୍‌ “ଇନେକିଦେଂ ତାଙ୍ଗେଙ୍ଗ୍‌ ପିହିକିଦେଂ ଆଡ୍‌ୱାତାପ୍‌ ?” ");
INSERT INTO peg_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","ଜିସୁ ହେୱାରିଂ ଇଚାନ୍‌, “ଏପେଙ୍ଗ୍‌ ଅଲପ୍‍ ପାର୍ତି କାଜିଂ, ଇନାକିଦେଂକି ଆନ୍‌ ମିଙ୍ଗ୍‌ ହାତ୍‌ପା ଇଞ୍ଜ୍‌ନାଙ୍ଗା, ଜଦି ର ହାର୍‌ହୁ ମାଞ୍ଜି ଲାକେ ମି ପାର୍ତି କିନାକା ମାନ୍‌ଗାନାତ୍‌, ତା ଆତିସ୍‌ ଇ ମାଡ଼ିତିଂ ଇବେତାଂ ହେବେ ଗୁଚା ଇଞ୍ଜି ଇଚିସ୍‌ ହେଦାଂ ଗୁଚାଆନାତ୍, ପାର୍ତି ହୁକେ ଇନାକା ଆବ୍‌ଡ଼ୁ ଆକାୟ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","ମାତର୍‌ “ପାର୍ତାନା ଆରି ଉପାସ୍‌ ପିସ୍ତି ବିନ୍‌ ଇନାକାପା ଉପାୟ୍‌ ଇ ବାନି ବୁତ୍‌ ହସି ହାଲୁତ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","ଚେଲାହିର୍‌ ୱିଜ଼ାର୍‌ ଗାଲିଲିତ ରୁଣ୍ଡାଆତି ପାଚେ ଜିସୁ ହେୱାରିଂ ଇଚାନ୍‌, “ମାନାୟ୍‌ ମାଜ଼ି ମାନାୟାର୍‌ କେଇଦ ଆହ୍‌ୟାଦେଂ ହାନାନା, ");
INSERT INTO peg_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","ହେ ମାନାୟାର୍‌ ମାନାୟ୍‌ ମାଜ଼ି ଟୁଣାର୍, ମାତର୍‌ ତିନି ଦିନ୍‌ ପାଚେ ହେୱେନ୍‌ ଆରେ ନିଙ୍ଗ୍‌ନାନ୍‌,” ହେବେ ଚେଲାର୍‌ ବେସି ଦୁକ୍‌ ଆତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","ଜିସୁ ଆରି ତା ଚେଲାହିର୍‌ କପର୍ନାହୁମ୍‌ ୱାତି ପାଚେ ଦେଉଡ଼୍‌ନି ସିସ୍ତୁଏନ୍‌ନାକାର୍‌ ପିତର୍‌ତିଂ ୱେନ୍‍ବାତାର୍, “ମି ଗୁରୁ ଦେଉଡ଼୍‌ନି ସିସ୍ତୁ ହିନାନ୍‌ କି ?” ");
INSERT INTO peg_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","ହେୱେନ୍‌ ଇଚାନ୍‌ “ଆଁ ହିନାନ୍‌ ।” ଆରେ ହେୱେନ୍‌ ଇଞ୍ଜ ୱାତିପାଚେ ଜିସୁ ଆଗେ ତାଙ୍ଗ୍‌ ଇଚାନ୍‌, “ସିମନ୍‌ ନି ବଲ୍‌ ଇନାକା ? ପୁର୍ତିନି ରାଜାର୍‌ ଇନେର୍‌ କଚଣ୍‌ତାଂ ସିସ୍ତୁ କି ରାଜା ପାଦ୍ ଅନାର୍‌ ? ହେୱାର୍‌ ପାର୍‌ଜାତାଂ କି ବିଦେସ୍‌ନିକାର୍‌ତାଂ ?” ");
INSERT INTO peg_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","ପିତର୍‌ “ବିଦେସ୍‌ନିକାର୍‌ତାଂ ଇଞ୍ଜି ଇଚିଲେ,” ଜିସୁ ତାଙ୍ଗ୍‌ ଇଚାନ୍‌, “ଲାଗିଂ ତ ହିମ୍‌ଣାଂ ମୁକ୍‌ଡ଼ା ଆତାର୍ଣ୍ଣା ? ");
INSERT INTO peg_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","ମାତର୍‌ ଆସେଙ୍ଗ୍‌ ଇନେସ୍‌ ହେୱାର୍‌ତି ବାଦାନି କାରଣ୍‌ ଆମେତ୍‌, ଇଦାଂ କାଜିଂ ହାମ୍‌ଦୁର୍‌ତ ହାଲ୍‌ଜି ବାଣ୍‌ହି ଇଜ଼ାଟ୍‌ ଆରେ ପର୍ତୁମ୍‌ ଇମ୍‌ଣି ମିନ୍‌ କାପ୍‌ନାତ୍‌, ହେଦେଲିଂ ଅଜ଼ି ତା ୱେଇ ଏସ୍‌ତିସ୍‌ ର ରୁପା ଡାବୁଙ୍ଗ୍‌ ଗାଟାଆନାଦେର୍; ହେଦାଂ ଅଜ଼ି ନା କାଜିଂ ଆରି ମି କାଜିଂ ହେୱାରିଂ ହିୟାଟ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","ହେ ପାଦ୍‌ନା ଚେଲାହିର୍‌ ଜିସୁ କଚଣ୍‌ ୱାଜ଼ି ୱେନ୍‍ବାତାର୍, ତେବେ “ସାର୍ଗେ ରାଜିତ ଇନେର୍‌ ଗାଜା ?” ");
INSERT INTO peg_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","ଜିସୁ ର ହିରୁ ହିମ୍‌ଣାଂ ଲାଗେ କୁକ୍‌ଚି ହେୱାର୍‌ ବିତ୍ରେ ନିଲି କିଜ଼ି ଇଚାନ୍‌, ");
INSERT INTO peg_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","“ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ହାତ୍‌ପା ଇଞ୍ଜ୍‌ନାଙ୍ଗା, ଏପେଙ୍ଗ୍‌ ବାଦ୍‌ଲାୱିତିସ୍‌ ହିରୁ ହିମ୍‌ଣା ଲାକେ ଆୱିତିସ୍‌ ଇନେସ୍‌ କିତିସ୍‌ପା ସାର୍ଗେ ରାଜିତ ହଣ୍ଡେଙ୍ଗ୍‌ ଆଡୁଦେର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","ଲାଗିଂ, ଇନେର୍‌କି ଇ ହିରୁ ହିମ୍‌ଣା ଲାକେ ଜାର୍‌ତିଂ ହାଦ୍‌ଦାର୍ମି କିନାନ୍‌, ହେୱେନ୍‌ ସାର୍ଗେ ରାଜିତ ଗାଜାକାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","ଆରେ, ଇନେର୍‌ ନା ତର୍‌ଦାଂ ଇ ଲାକେ ର ହିରୁ ହିମ୍‌ଣାଂ ମାନ୍‌କିନାନ୍‌, ହେୱେନ୍‌ ନାଙ୍ଗେଙ୍ଗ୍‌ ମାନ୍‌କିଦ୍‍ନାନ୍ ।” ");
INSERT INTO peg_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","ମାତର୍‌ ଇନେର୍‌କି “ନା ତାକେ ପାର୍ତି କିନାକାର୍‌ ଇ ହିରୁହିମ୍‍ଣାଙ୍ଗ୍ ବିତ୍ରେ ରକାନ୍ତି ବାଦା ଇନାକିଦେଂକି ଆନାତ୍‌, ହେଦାଂ ଗାଡେଲ୍‌ତ ର ଗାଜା ଜାତାକାଲ୍‌ ଗାଚ୍‌ଚି ତାଙ୍ଗେଙ୍ଗ୍‌ ହାମ୍‌ଦୁର୍‌ତ ତୁସି ହିନାକା ହାର୍‌ ଆନାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","ମାନାୟାର୍‌ତି ପାର୍ତିତ ବାଦା ଗିଟାୟ୍‌କିଦେଂ ଇଞ୍ଜି, ବେସି ବିସ୍ରେ ମାନାତ୍‌ । ହେଦାଂ କାଜିଂ ଇ ପୁର୍ତିତ ଅବସ୍ତା ଏଚେକ୍‌ ବଇଁକାର୍‌ ସବୁ ଦିନ୍‌ ଇ ଲାକେ ବାଦା ୱାନାତ୍, ମାତର୍‌ ଇନେନ୍‌ ବାଦା ଗିଟାୟ୍‌କିନାନ୍‌, ତା ୱିଜ଼େ କେତେକ୍‌ ହାର୍‌ଦାକା !” ");
INSERT INTO peg_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“ଜଦି ମି କେଇ କି ପାନା କାଜିଂ ଏପେଙ୍ଗ୍‌ ପାର୍ତି ବାଦା କିନାଦେର୍‌, ଲାଗିଂ ତାଙ୍ଗ୍‌ କାଦ୍‌ଦି ତୁସିହିୟାଟ୍‌ । ରି କେଇ ଆରି ରି ପାନା ମାନ୍‌ଞ୍ଜି ୱିଜ଼୍‌ୱିନାଣିତ ତୁସ୍‌ୟାନି ପାତେକ୍‌ ରକେଇ ଆରେ ର ପାନା ବିନେ ଆଜ଼ି ୱିଜ଼୍‌ୱି ଜିବୁନ୍‌ତ ହଣାକା ମି ପାକ୍ୟାତ ହାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","ଆରେ ମି କାଣ୍‌ଙ୍ଗା ଜଦି ନି ବାଦା ଆନାତ୍‌, ଲାଗିଂ ତାଙ୍ଗ୍‌ ଉନ୍‌ଦି ତୁଇ ହିୟାଟ୍‌; ରିଣ୍ଡାଂ କାଣ୍‌କୁ ଅଜ଼ି ନାଣି ବିତ୍ରେ ନରକ୍‌ ତାକେ କାଡ୍‌ନି ବାଟା ଇଚିସ୍‌ ର କାଣ୍‌ଙ୍ଗା ଅଜ଼ି ଜିବୁନ୍‌ତ ହଣାକା ମି ପାକ୍ୟାତ ହାର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","ଜାଗ୍ରତ୍‌, ଇ ହିରୁକାର୍‌ ବିତ୍ରେ ରକାନିଂ ନେ ଇଣ୍‌ କିମାଟ୍‌, ଇନାକିଦେଂକି ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ହାତ୍‌ପା ଇଞ୍ଜ୍‌ନାଙ୍ଗା ସାର୍ଗେତ ହେୱାର୍‌ତି ଦୁତ୍‌ତର୍‌ ସବୁ ଦିନ୍‌ ନା ସାଗ୍ରେନି ଆବା ଲାଗାଂ ମାନାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","ଇନାକିଦେଂକି ଇନାକା ଜାଙ୍ଗ୍‍ତାତ୍‍ନା, ହେଦାଂ ରାକ୍ୟା କିଦେଙ୍ଗ୍‌ ଇଞ୍ଜି ମାନାୟ୍‌ ମାଜ଼ି ୱାତାନ୍‌ନା । ");
INSERT INTO peg_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“ଏପେଙ୍ଗ୍‌ ଇନାକା ଏତୁ କିନାଦେରା ? ଇମ୍‌ଣି ଲକ୍‌ତି ଜଦି ପାଞ୍ଚ୍‌କଡ଼ି ମେଣ୍ଡାଂ ମାଚିସ୍‌, ଆରେ ହେୱାଙ୍ଗ୍‌ ବିତ୍ରେ ରଞ୍ଜାଙ୍ଗ୍‌ ଜାଙ୍ଗ୍‌ତିସ୍‌, ଲାଗିଂ ଇନାକା ନବେନଗଟାକାଂ ମାଡ଼ିତ ପିସ୍‌ସି ହେୱାନ୍‌ ହାଲ୍‌ଜି ହେ ବାଣାତି ମେଣ୍ଡାତିଂ ଡେକ୍‌କୁନ୍‌ ? ");
INSERT INTO peg_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","ଆରେ ହେୱେନ୍‌ ମେଣ୍ଡା ଗାଟାଆନାନ୍ ତା ଆତିସ୍‌ ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ହାତ୍‌ପା ଇଞ୍ଜ୍‌ନାଙ୍ଗା, ନବେନଗଟା ବାଣା ଆୱାଦାଂ ମାଚିକ୍‌, ହେୱାଙ୍ଗ୍‌ ବିତ୍ରେ ଇ ରଞ୍ଜାଙ୍ଗ୍‌ କାଜିଂ ହେୱେନ୍‌ ଆଦିକ୍‌ ୱାରି କିନାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","ହେ ଲାକେ ଇ ହିରୁକାରିଂ ବିତ୍ରେ ଜେ ରଞ୍ଜାଙ୍ଗ୍‌ କାରାପ୍‌ ଆନାତ୍‌, ଇଦାଂ ଏପେଙ୍ଗ୍‌ ସାର୍ଗେନି ଆବାତି ମାନ୍‌ ଆକାୟ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","ଲାଗିଂ “ନି ଟଣ୍ଡେନ୍‌ନି ବିରୁଦ୍‌ତ ପାପ୍‌ କିନାନ୍‌, ଲାଗିଂ ହାଲ୍‌ଜି କେବଲ୍‌ ମି ରିୟାରିଂ ବିତ୍ରେ ହେୱାନିଂ ତା ଦସ୍‌ ଚଚାଟ୍‌; ଜଦି ହେୱାନ୍‌ ମି କାତା ୱେନାନ୍, ଲାଗିଂ ଏପେଙ୍ଗ୍‌ ଜାର୍‌ ଟଣ୍ଡେନିଂ ପାୟା ଆତାୟ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","ମାତର୍‌ ଜଦି ହେୱାନ୍‌ ୱେନୁର୍, ରକାନ୍‌ କି ରିୟାରିଂ ଅଜ଼ି ହାଲାଟ୍‌ । ଇନେସ୍‌ ରିୟାର୍‌ କି ତିନ୍‌ଜାଣ୍‌ ସାକିରିଙ୍ଗ୍‌ ମୁମ୍‌ଦ ୱିଜ଼ୁ ଦାବା କାତା ତିର୍‌ କିୟାନାତ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","ଜଦି ହେୱାନ୍‌ ହେୱାର୍‌ କାତା ମାନିକିଉନ୍‌, ଲାଗିଂ ମଣ୍ଡ୍‌ଲିତିଂ ଇନାଟ୍‌, ଆରେ ଜଦି ହେୱାନ୍‌ ମଣ୍ଡ୍‌ଲି କାତା ପା ମାନିକିୱିତିସ୍, ଲାଗିଂ ହେୱାନ୍‌ ମି କାଣ୍‍ଗାତ ପାର୍ତିକିୱି ଜିହୁଦିର୍‌ ଆରି ସିସ୍ତୁଏନ୍‌ନାକାର୍‌ ଲାକେ ଆଏନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","ଆନ୍‌ “ମିଙ୍ଗେଙ୍ଗ୍‌ ହାତ୍‌ପା ଇଞ୍ଜ୍‌ନାଙ୍ଗା, ଏପେଙ୍ଗ୍‌ ପୁର୍ତିତ ଇନାକାପା ବନ୍ଦ୍‌ କିନାଦେର୍‌, ସାର୍ଗେତ ହେୱିଜ଼ୁ ବନ୍ଦ୍‌ ମାନ୍‌ଗାନାତ୍‌, ଆରି ପୁର୍ତିତ ଇନାକା ୱିଜ଼ୁ ଜେନାଦେର୍‌, ସାର୍ଗେତ ହେୱିଜ଼ୁ ଜେନାଦେର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","ଆରି, ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ହାତ୍‌ପା ଇଞ୍ଜ୍‌ନାଙ୍ଗା, ପୁର୍ତିତ ମି ବିତ୍ରେପା ରିୟାର୍‌ ଇନେସ୍‌ ବାର୍ତି ବିସ୍ରେ ର ମାନ୍‌ତାଂ ଆଜ଼ି ଇନାକା ଏନ୍‌ନାଦେର୍‌, ହେଦାଂ ନା ସାର୍ଗେନି ଆବାତି ଇଚା ହେୱାର୍‌ କାଜିଂ ଗିଟା ଆନାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","“ଇନାକିଦେଂକି ଇମ୍‌ଣି ବାହାତ ରିୟାର୍‌ କି ତିନ୍‌ ଜାଣ୍‌ ନା ତର୍‌ଦାଂ ରୁଣ୍ଡା ଆନାର୍‌, ହେ ବାହାତ ଆନ୍‌ ହେୱାର୍‌ ବିତ୍ରେ ମାନ୍‌ଗାନାଂ ।” ");
INSERT INTO peg_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","ହେ ପାଦ୍‌ନା ପିତର୍‌ ଜିସୁ କଚଣ୍‌ ୱାଜ଼ି ୱେନ୍‌ବାତାନ୍‌, “ଏ ମାପ୍ରୁ, ଏଚେକ୍‌ ହଟ୍‌ ନା ଟଣ୍ଡେନ୍‌ ନା ବିରୁତ୍‌ତାଂ ପାପ୍‌ କିତିସ୍‌ ଆନ୍‌ ଏଚେକାଡ଼୍‌ଦ କେମା କିନାଙ୍ଗ୍‌ ? ଇନାକା ସାତ୍‌ ହଟ୍‌ ?” ");
INSERT INTO peg_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","ଜିସୁ ତାଙ୍ଗେଙ୍ଗ୍‌ ଇଚାନ୍‌, “ନିଙ୍ଗେଙ୍ଗ୍‌ କେବଲ୍‌ ସାତ୍‌ ହଟ୍‌ ପାତେକ୍‌ ଇଞ୍ଜୁଙ୍ଗା, ମତର୍‌ ସତୁରି ଗୁଣ୍‌ ସାତ୍‌ ହଟ୍‌ ପାତେକ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","ଇଚିସ୍‌ ସାର୍ଗେ ରାଜି ଜାର୍‌ ଆଡ଼ିୟାର୍‌ ଲାହାଙ୍ଗ୍‌ ଇସାବ୍‌ କିଦେଙ୍ଗ୍‌ ଇଚାକିନି ରୱାନ୍‌ ରାଜା ଲାକେ । ");
INSERT INTO peg_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","ହେୱେନ୍‌ ଇସାବ୍‌ ଆରମ୍‌ କିତିଲେ, ଲାକେ ଟାକାଂ ରୁଣ୍‌ କିଜ଼ି ମାଚି ର ହେବାକାରି ରାଜା ଲାଗାଂ ତାହିୱାତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","ମାତର୍‌ ତା ହୁଜାଆଦେଂ ଇନାକା ହିଲ୍‌ୱିତିଲେ ତା ମାପ୍ରୁ ତାଙ୍ଗ୍‌ ଆରି ତା ଡକ୍ରିଙ୍ଗ୍, ହିମ୍‍ଣାୱାକ୍‍ଡ଼ା ଆରି ୱିଜ଼ୁ ପ୍ରସି କର୍ଚ ଅଦେଂ ରାଜା ବଲ୍‌ ହିତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","ଲାଗିଂ ହେ ହଲ୍ୟା ତାଙ୍ଗେଙ୍ଗ୍‌ ପାନା ତାରେନ୍‌ ଜୁୱାର୍‌ କିଜ଼ି ଇଞ୍ଜେଙ୍ଗ୍‌ ଲାଗାତାନ୍‌, ଏନ୍‌ ନା ବିସ୍ରେ ବାଡ଼୍‌କାସ୍‌ଆ, ଆନ୍‌ ନିଗେଙ୍ଗ୍ ୱିଜ଼ୁ ହୁଜା ଆଜ଼ି ହିଦ୍‌ନାଂ ।” ");
INSERT INTO peg_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","ହେବେତାଂ ହେ ହଲ୍ୟାତିଂ ମାପ୍ରୁ କାର୍ମା ଆଜ଼ି ତାଙ୍ଗେଙ୍ଗ୍‌ ପିସ୍ତି ହିତାନ୍‌ ଆରି ରାଜା ରୁଣ୍‌ କେମା କିତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","ମାତର୍‌ “ହେ ହଲ୍ୟା ହସି ହାଲ୍‌ଜି ତାବେଣ୍ଡାଂ ପଚାସ୍‌ ଟାକା ରୁଣ୍‌ କିଜ଼ି ମାନି ର ହାଙ୍ଗ୍‌ଦାକାନ୍‌ ଚଞ୍ଜ୍‌ୟା ଆଜ଼ି ହେୱାନିଂ ଆଜ଼ି ତା ଗାଡେଲ୍ ମ୍ଡିଞ୍ଜି ଇଞ୍ଜେଙ୍ଗ୍‌ ଲାଗାତାନ୍‌, ଏନ୍‌ ଇନାକା ଆସ୍ତାୟ୍‌ନା ହୁଜାଆଦା ।” ");
INSERT INTO peg_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","ଲାଗିଂ “ତା ହାଙ୍ଗ୍‌ଦାକାନ୍‌ କାଲ୍‌ ତାରେନ୍‌ ଆଜ଼ି ହେୱାନିଂ ଗୱାରି କିଜ଼ି ଇଞ୍ଜେଙ୍ଗ୍‌ ଲାଗାତାନ୍‌, ଏନ୍‌ ନା ବିସ୍ରେ ବାଡ଼୍‌କାସ୍‌ଆ, ଆନ୍‌ ନିଙ୍ଗେଙ୍ଗ୍‌ ହୁଜା ଆଜ଼ି ହିଦ୍‌ନାଂ ।” ");
INSERT INTO peg_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","“ମତର୍‌ ହେୱେନ୍‌ ରାଜି ଆୱାତାନ୍‌, ମାତର୍‌ ହାଲ୍‌ଜି ରୁଣ୍‌ ହୁଜାଆୱି ପାତେକ୍‌ ତାଙ୍ଗ୍‌ ଜଇଲ୍‌ତ ପ୍ରତ୍‌ତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","ଲାଗିଂ ତା ହାଙ୍ଗ୍‌ଦାକାର୍‌ ଇ ଗଟ୍‌ନା ହୁଡ଼୍‌ଜି ବେସି ଦୁକ୍‌ ଆତାର୍‌ ଆରି ହାଲ୍‌ଜି ହେୱାର୍‌ ମାପ୍ରୁ ଲାଗାଂ ୱିଜ଼ୁ ଗଟ୍‍ଣାଗିଟା ଆଜ଼ି ମାଚାତ୍‌ ୱେଚ୍‍ଚାର୍ ।” ");
INSERT INTO peg_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","ହେବେତାଂ ତା ମାପ୍ରୁ ତାଙ୍ଗ୍‌ ଲାଗେ କୁକି କିଜ଼ି ଇଚାନ୍‌, “ଏଡ଼େ ଉତ୍‌ପାତ୍ୟା ହଲ୍ୟା, ଏନ୍‌ ନାଙ୍ଗେଙ୍ଗ୍‌ ଗୱାରି କିତ୍‍ତିଲେ ଆନ୍‌ ନି ହେ ୱିଜ଼ୁ ରୁଣ୍‌ କେମା କିତାଙ୍ଗ୍‌; ");
INSERT INTO peg_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","ଆନ୍‌ ଇନେସ୍‌ ଲାକେ ନିଙ୍ଗେଙ୍ଗ୍‌ ଦୟା କିତ୍‍ତାଙ୍ଗ୍, ହେ ଲାକେ ପା ଜାର୍‌ ହାଙ୍ଗ୍‌ଦାକାର୍‌ ଦୟା କିନାକା କି ନି କାମାୟ୍‌ ହିଲ୍‌ୱାତାତ୍‌ ?” ");
INSERT INTO peg_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","ଆରେ, ତା “ମାପ୍ରୁ ରିସା ଆଜ଼ି ୱିଜ଼ୁ ରୁଣ୍‌ ହୁଜାଆୱି ତାଙ୍ଗ୍‌ ପାତେକ୍‌ ବାଦା ହିନି ମାନାୟାର୍‌ କେଇଦ ସର୍‌ପି କିତାର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","ଜିସୁ ଇନାକା ୱିସ୍ତି “ହେୱାରିଂ ଇଚାନ୍‌ ଜଦି ୱାସ୍କିତାଂ ଜାର୍‌ ଜାର୍‌ ଟଣ୍ଡାରିଂ କେମା କିୱିତିସ୍‌, ତାଆତିସ୍‌ ନା ସାର୍ଗେନି ଆବା ପା ମି କାଜିଂ ହେ ଲାକେ କିଦ୍‌ନାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","ଜିସୁ ଇ ୱିଜ଼ୁ କାତା ଇଞ୍ଜି ୱିସ୍ତି ପାଚେ ଗାଲିଲି ପିସ୍ତି ଜର୍ଦନ୍‌ ନାଗୁଡ଼୍‌ ଆନ୍‌ଟି ପାଡ଼୍‍କା ମାନି ଜିହୁଦା ନିପ ହାଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","ବେସିହେନି ମାନାୟାର୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ଦାସ୍ତାର୍‌ ଆରି ହେୱାନ୍‌ ହେନି ରଗ୍ୟାରିଂ ଉଜ୍‌ କିତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","କେତେଜାଣ୍‌ ପାରୁସିର୍‌ ତା ଲାଗାଂ ୱାଜ଼ି ତାଙ୍ଗ୍‌ ଡ଼ୁକାତ ପ୍ରଦ୍‌ଦେଂ ପାଚି କିତାର୍‌ । ହେୱାର୍‌ ତାଙ୍ଗ୍‌ ୱେନ୍‍ବାତାର୍‍, “ମା ଦର୍ମନି ମସାତି ବିଦି ଇସାବ୍‌ରେ ରକାନ୍‌ ଜେ ଇନା ବିସ୍ରେ ତା, କଗ୍‌ଲେଂ ହେଲ ହିଦେଂ ଆଡ୍‌ନାନ୍‌ କି ?” ");
INSERT INTO peg_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","ହେୱେନ୍‌ ଉତର୍‌ ହିତାନ୍‌, ଏପେଙ୍ଗ୍‌ ଇନାକା ପଡ଼ି କିୱାତାଦେର୍ଣ୍ଣା ଜେ ଉବ୍‌ଜାଣ୍‌ କିନାକାନ୍‌ ଆରମ୍‌ତାଂ ହେୱାରିଂ ଆଣ୍ଡ୍ରେନ୍‌ ଆରି କଗ୍‌ଲେ କିଜ଼ି ଉବ୍‌ଜାଣ୍‌ କିତାନ୍‌, ");
INSERT INTO peg_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","ଆରେ ଇଚାନ୍‌, “ଇଦାଂ କାଜିଂ ମାନାୟ୍‌ ଆବାଆୟାକାଂ ପିସ୍ତି ଜାର୍‌ କଗ୍‌ଲେ ତାକେ ମେହା ଆନାନ୍‌, ଆରେ ହେୱାର୍‌ ଦୁଲ୍‍ମାତାର୍ ଏକ୍‌ ଆନାର୍‌ ? ");
INSERT INTO peg_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","ଲାଗିଂ ହେୱାର୍‌ ଆରେ ରିକାର୍‌ ଆକାୟ୍‌, ମାତର୍‌ ଏକ୍‌ ଆନାର୍‌ । ଲାଗିଂ, ଇସ୍ୱର୍‌ ଇନାକା ମେହାୟ୍‌ କିତ୍‌ତାନ୍‌ନା, ମାନାୟାର୍‌ ହେଦାଂ ଏଡ଼ାୟ୍‍ କିମେନ୍ ।” ");
INSERT INTO peg_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","ହେୱାର୍‌ ହେୱାନିଂ “ୱେନ୍‌ବାତାର୍‌, ଲାଗିଂ ମସା ଇନେକିଦେଂ ହେଲ ଆକି ହିଜ଼ି କଗ୍‌ଲେଙ୍ଗ୍‌ ହେଲ ହିନି କାଜିଂ ବଲ୍‌ ହିତାନ୍‌ ?” ");
INSERT INTO peg_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","ଜିସୁ ଉତର୍‌ ହିତାନ୍‌, “ମି ମାନ୍‌ ଆଟ୍‌ୱା କାଜିଂ ମସା ହେ ଲାକେ କିଜ଼ି ମାଚାନ୍‌ । ମାତର୍‌ ଆଗେ ଉବ୍‌ଜାଣ୍‌ ୱେଡ଼ାଲିଂ ଏଲେଙ୍ଗ୍‌ ବିଦି ହିଲ୍‌ୱାତାତ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","“ମତର୍‌ ଆନ୍‌ ମିଙ୍ଗ୍‌ ଇଞ୍ଜ୍‌ନାଙ୍ଗା, ଇନେର୍‌କି ଜାର୍‌ ଡକ୍ରିଂ ଦାରି ଦସ୍‍ତ ପିସ୍ତି ବିନ୍‌ ବିସ୍ରେତାଂ ପିହ୍‌ନିଆକି ହିଜ଼ି ବିନ୍‌ କଗ୍‌ଲେଂ ବିବା କିତିସ୍‌, ହେୱାନ୍‌ ଦାରି ଆନାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","ଚେଲାର୍‌ ହେୱାନିଂ ଇଚାର୍‌, “କଗ୍‌ଲେ ହୁକେ ମାନାୟ୍‌ତିଂ ଜଦି ଇ ମାସ୍ତୁର୍‌ ମେହାବିଡ଼ା, ଲାଗିଂ ବିବା କିୱାକା ହାର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","ଜିସୁ ଉତର୍‌ ହିତାନ୍‌, “ଇ ହିକ୍ୟା ୱିଜ଼ାକାର୍‌ କାଜିଂ ସମାନ୍‌ ଆକାୟ୍‌ । ଇସ୍ୱର୍ତି ତାଙ୍ଗ୍‌ ଇମ୍‌ଣାକାରିଂ ଇଦାଂ ହିୟାତାତ୍‍ନ୍ନା, କେବଲ୍‌ ହେୱାର୍‌ ନେ ଇଦାଂ ଇଡ୍‌ଦେଂ ଆଡ୍‌ନାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","ଇନାକିଦେଂକି ଇନେର୍‌ ଇନେର୍‌ ଆୟା ଗରବ୍‍ତାଂ ବେଜୁ ଆଜ଼ି ଜଲମ୍‌ ଆତାର୍ଣ୍ଣା, ଆରେ ଇନେର୍‌ ଇନେର୍‌ ମାନାୟ୍‍ତାଂ ବେଜୁ କିୟାତାର୍ଣ୍ଣା, ଆରି ଆରେ ଇନେର୍‌ ଇନେର୍‌ ସାର୍ଗେ ରାଜି କାଜିଂ ଜାର୍‌ ଜାର୍‌ତିଂ ବେଜୁ କିତାର୍ଣ୍ଣା । ଇମ୍‌ଣାକାର୍‌ ଇଡ୍‌ଦେଂ ଆଡ୍‌ନାର୍‌, ହେୱାନ୍‌ ଇଟେନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","ହିମ୍‌ଣାଂ ଜପି କେଇ ଇଡ଼୍‌ଜି ପାର୍ତାନା କିଦେଙ୍ଗ୍‌ କାଜିଂ କେତେକ୍‌ ଲକୁ ହେୱାରିଂ ଜିସୁ ଲାଗେ ତାହିୱାତାର୍‌ । ହେ ଲକୁରିଂ ଚେଲାର୍‌ ଦାକା ହିତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","ମାତର୍‌ ଜିସୁ ଇଚାନ୍‌, “ହିମ୍‌ଣାକାଂ ନା ଲାଗେ ୱାଦେଙ୍ଗ୍‌ ହିଆଟ୍ । ହେୱାରିଂ ବାଦା ହିମାଟ୍‌ । ଇନାକିଦେଂକି ସାର୍ଗେ ରାଜି ଇମ୍‌ଣାକାର୍‌ ଇୱାର୍‌ ଲାକେ ହେୱାର୍‌ତି ।” ");
INSERT INTO peg_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","ଆରେ ହେୱାର୍‌ ଜପି କେଇ ଇଡ଼୍‌ଜି ଆସିର୍ବାଦ୍‌ କିତି ପାଚେ ଜିସୁ ହେବେତାଂ ହାଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","ଦିନେକ୍‌ ରକାନ୍‌ ମାଜାନ୍‌ ଦାଙ୍ଗ୍‌ଣେନ୍‌ ଜିସୁ ଲାଗେ ୱାଜ଼ି ୱେନ୍‌ବାତାନ୍‌, “ଗୁରୁ ! ୱିଜ଼୍‌ୱି ଜିବୁନ୍‌ ପାୟାଦେଂ କାଜିଂ ଆନ୍‌ ଇମ୍‌ଣି ହାର୍‌ଦି କାମାୟ୍‌ କିନାଙ୍ଗ୍‌ ?” ");
INSERT INTO peg_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","ଜିସୁ ତାଙ୍ଗେଙ୍ଗ୍‌ ଇଚାନ୍‌, “ହାର୍ଦି କାମାୟ୍‌ ବିସ୍ରେ ନାଙ୍ଗ୍‌ ଇନେକିଦେଂ ୱେନ୍‌ବା ଆଦ୍‌ନାଦେରା ? କେବଲ୍‌ ଇସ୍ୱର୍‌ ନେ ହାର୍‌ଦାକାନ୍‌ । ହେୱାନ୍ତି ବଲ୍‌ ୱିଜ଼ୁ ମାନି କିତିସ୍‌, ୱିଜ଼୍‌ୱି ଜିବୁନ୍‌ ଲାବ୍‌ କିଦେଙ୍ଗ୍‌ ଆଡ୍‌ନାସ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","ହେୱାନ୍‌ ୱେନ୍‌ବାତାନ୍‌, “ଇମ୍‌ଣି ୱିଜ଼ୁ ବଲ୍‌ ?” ଜିସୁ ଇଚାନ୍‌, “ନାର୍‌ ଅହ୍‌ମାଟ୍‌, ଦାରି କିମାଟ୍‌ । ଚରି କିମାଟ୍‌, ଇନେର୍‌ ବିରୁଦ୍‌ତ ମିଚ୍‌ ଦାବା କିମାଟ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","ଆବାଂ ଆୟାଙ୍ଗ୍‌ ୱାରି କିୟାଟ୍‌ ଆରି ମି ପାଡ଼୍‍ହାନିକାରିଂ ଜାର୍‌ ଲାକେ ଜିଉ ନୱାଟ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","ହେ ଦାଙ୍ଗ୍‌ଣେନ୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ଇଚାନ୍‌, “ଇ ସବୁ ବଲ୍‌ ଆନ୍‌ ମାନି କିତାଂନ୍ନା । ନାଦାଂ ଆରେ ଇନାକା କିନି ଲଡ଼ା ?” ");
INSERT INTO peg_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","ସୁଣାୟ୍‌ କିଜ଼ି ଜିସୁ ହେୱାନିଂ ଉତର୍‌ ହିତାନ୍‌, “ଜଦି ଏନ୍‌ ହାର୍‌ ଆଦେଂ ମାନ୍‍କିନାୟ୍, ହାଲା, ନିନ୍ଦାଂ ସବୁ ଦନ୍‌ ପ୍ରସି ହେ ଟାକାଙ୍ଗ୍‌ ଅର୍କିତାରିଂ ଦାନ୍‌ କିୟା । ତା ଆତିସ୍‌ ଏନ୍‌ ସାର୍ଗେତ ଦନ୍‌ ଲାବ୍‌ କିନାୟ୍‌ । ଇ ୱିଜ଼ୁ କିତିପାଚେ ନା ପାଚେ ପାଚେ ୱା ।” ");
INSERT INTO peg_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","ମାତର୍‌ ଇ କାତା ୱେନ୍‌ଞ୍ଜି ଦାଙ୍ଗ୍‌ଣେନ୍‌ ଦୁକ୍‌ ଆଜ଼ି ହାଚାନ୍‌, ଇନାକିଦେଂକି ହେୱାନ୍‌ ବେସି ମାଜାନ୍‌ ମାଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","ଜିସୁ ଚେଲାରିଂ ଇଚାନ୍‌, “ଆନ୍‌ ମିଙ୍ଗ୍‌ ହାତ୍‌ପା ଇଞ୍ଜ୍‌ନାଙ୍ଗା, ମାଜାନିଂ ସାର୍ଗେ ରାଜିତ ହଣାକା ବେସି କସ୍ଟ । ");
INSERT INTO peg_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","ଆରେ ଆନ୍‌ ମିଙ୍ଗ୍‌ ଇଞ୍ଜ୍‌ନାଙ୍ଗା, ଇସ୍ୱର୍ତି ରାଜିତ ମାଜାନ୍‌ ଲକୁ ହଣି ବାଟା ଇଚିସ୍‌ ହୁଜାନି କାଣାତିଂ ଉଟ୍‌ ହଣାକା ଆଡ଼୍‌ୱା ।” ");
INSERT INTO peg_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","ଚେଲାର୍‌ ଇଦାଂ ୱେନ୍‌ଞ୍ଜି କାବା ଆଜ଼ି ଇଚାର୍‌, “ତେବେ ଇନେର୍‌ ମୁକ୍ତି ଆଦେଂ ଆଡ୍‌ନାର୍‌ ?” ");
INSERT INTO peg_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","ଜିସୁ ହେୱାରିଂ ସିଦା ହୁଡ଼୍‌ଜି ଇଚାନ୍‌, ଇଦାଂ “ମାନାୟ୍‌ତିଂ ପାକ୍ୟାତ ଆଡ୍‌ୱାକା, ମାତର୍‌ ଇସ୍ୱର୍ତି ପାକ୍ୟାତ ୱିଜ଼ୁ ଆଡ଼୍‌ୱା ।” ");
INSERT INTO peg_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","ଇଦାଂ ୱେନ୍‌ଞ୍ଜି ପିତର୍‌ ଇଚାନ୍‌, “ହୁଡ଼ା, ଆପେଂ ୱିଜ଼ୁ ପିସ୍ତି ନି ପାଚେ ପାଚେ ୱାତାପ୍‍ନା । ଆପେଙ୍ଗ୍‌ ଇନାକା ଗାଟାନାପ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","ଜିସୁ ହେୱାରିଂ ଇଚାନ୍‌, “ଆନ୍‌ ମିଙ୍ଗ୍‌ ହାତ୍‌ପା ଇଞ୍ଜ୍‌ନାଙ୍ଗା, ପୁନି ଜୁଗ୍‌ତ ଏଚେକାଡ଼୍‌ଦ ମାନାୟ୍‌ ମାଜ଼ି ଜାର୍‌ ଜାଜ୍‌ମାଲ୍‌ନି ଗାଦିତ କୁଚ୍‌ଚାନ୍‌, ହେ ଏଚେକାଡ଼୍‌ଦ, ନା ପାଚେ ୱାତାଦେର୍‌ ଜେ ଏପେଙ୍ଗ୍‌, ଏପେଙ୍ଗ୍‌ ପା ବାର ଚେଲାର୍‌ ଗାଦିତ କୁଚ୍‌ଚି ଇସ୍ରାଏଲ୍‌ନି ବାର କୁଟୁମ୍‌ ଜପି ରାଜ୍‌ କିନାଦେର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","ଆରି ଇନେର୍‌କି ନା ତର୍‌ କାଜିଂ ଇଲ୍‌, କି ଟଣ୍ଡେନ୍‌ କି ତଣ୍‌ଦେଲ୍‌, କି ଆବା କି ଆୟା, ହିମ୍‍ଣା ୱାକ୍‍ଡ଼ା କି ତାରେନ୍‌ ପିହିନାନ୍‌, ହେୱାନ୍‌ ସହେ ଗୁଣ୍‌ ଆଦିକ୍‌ ପାୟାନାନ୍‌; ଆରି ୱିଜ଼୍‌ୱି ଜିବୁନ୍‌ ଆଦିକାର୍‌ ଆନାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","“ମାତର୍‌ ପର୍ତୁମ୍‌ତ ମାନି ଆଦେକ୍‌ ଲକୁ ପାଚେ ଆର୍ନାର୍‌ ଆରି ପାଚେ ମାନି ହେନି ଲକୁ ପର୍ତୁମ୍‌ ଆନାର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“ସାର୍ଗେ ରାଜି ଇନେସ୍‌, ଇଦାଂ ଆରେ ର ଉତର୍‌ମୁଡ଼୍‌ ୱେନାଟ୍‌ । ର ମାନାୟ୍‌ ଦିନେକ୍‌ ନାଣାଙ୍ଗେ ତା ଅଙ୍ଗୁର୍‌ ବାଡ଼୍‌ଦ କାମାୟ୍‌ କିଦେଙ୍ଗ୍‌ କୁଲିୟାରିଂ ଡେକ୍‌ତେଂ ହତାନ୍ । ");
INSERT INTO peg_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","ଆରେ ହେୱାନ୍‌ କୁଲିୟାର୍‌ ହୁକେ ଦିନେକ୍‍ତିଂ ର ଦିନ୍‌ନି ରୁଣ୍‌ ନାଟ୍‌ଚି ହେୱାରିଂ ଜାର୍‌ ଅଙ୍ଗୁର୍‌ ବାଡ଼୍‌ଦ ପକ୍‌ତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","ତା ପାଚେ ଦିନ୍‌ ନଅ ଗଣ୍ଟା ୱେଡ଼ାଲିଂ ବାଜାର୍‌ତ ହାଲ୍‌ଜି ହୁଡ଼୍‌ତାନ୍‌, ର କୁଦା ଲକୁ ପଲ୍ୟା ଆଜ଼ି ନିଲ୍‌ତାର୍ଣ୍ଣା ।” ");
INSERT INTO peg_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","ହେୱାରିଂ ହେୱାନ୍‌ ଇଚାନ୍‌, ଏପେଙ୍ଗ୍‌ ପା ନା ଅଙ୍ଗୁର୍‌ ବାଡ଼୍‌ଦ ହାଲ୍‌ଜି କାମାୟ୍‌ କିୟାଟ୍‌, ମିଙ୍ଗ୍‌ ସମାନ୍‌ କୁଲି ହିଦ୍‌ନାଂ । ");
INSERT INTO peg_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","ହେୱାର୍‌ ହାଲ୍‌ଜି କାମାୟ୍‌ତ ଲାଗାତାର୍‌ । ଦିନ୍‌ ବାର୍ଟା ଆରି ତିନ୍‍ଟା ୱେଡ଼ାଲିଂ ସମାନ୍‌ ହେ ଲାକେ ଆରେ କେତେକ୍‌ କୁଲିୟାରିଂ ତାହିୱାଜ଼ି କାମାୟ୍‌ତ ଲାଗାୟ୍‌ କିତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","ମିଡ଼୍‍କାହାରେସ୍ ପାଞ୍ଚ୍‍ଟା ୱେଡ଼ାଲିଂ ଆରେ ରଗ ବାଜାର୍‌ତ ହାଲ୍‌ଜି ହୁଡ଼୍‌ତାନ୍‌, ଆରେ କେତେକ୍‌ ଜାଣ୍‌ ନିଲ୍‌ତାର୍ଣ୍ଣା । ହେୱାରିଂ ୱେନ୍‌ବାତାନ୍‌, “ୱେଡ଼ାବୁଡି କାମାୟ୍‌ କିୱାଦାଂ ଇନେକିଦେଂ ପଲ୍ୟା ସମୁ ନସ୍ଟ କିନାଦେରା ?” ");
INSERT INTO peg_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","ହେୱାର୍‌ ଉତର୍‌ ହିତାର୍‌, ଇନେର୍‌ ତ ମାଂ କାମାୟ୍‌ତ କିୟ୍‍କିଦ୍‍ୱାତାର୍ଣ୍ଣା । ହେୱାନ୍‌ ହେୱାରିଂ ଇଚାନ୍‌, ଆୟେତ୍‌, ବାଟିଙ୍ଗ୍‌ ଏପେଙ୍ଗ୍‌ ୱିଜ଼ାକାଦେର୍‌ ନା ଅଙ୍ଗୁର୍‌ ବାଡ଼୍‌ଦ ହାଲ୍‌ଜି କାମାୟ୍‌ କିୟାଟ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“ହେ ଦିନ୍ ମିଡ଼୍‍କାହାରେସ୍ ଅଙ୍ଗୁର୍‌ ବାଡ଼୍‌ନି ହାଉକାର୍‌ ଗୁମୁସ୍ତାଙ୍ଗ୍ ଇଚାନ୍‌, କୁଲିୟାରିଂ କୁକା । ଇମ୍‌ଣାକାର୍‌ ୱିଜ଼ାର୍‌ତାଂ ପାଚେ କାମାୟ୍‌ ହାଙ୍ଗ୍‍ତାର୍ଣ୍ଣା, ଆଗେ ହେୱାରିଂ ହାଜ୍‌ରି ହିଆ । ");
INSERT INTO peg_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","ହେବେଣ୍ଡାଂ ଇମ୍‌ଣାକାର୍‌ ପାଞ୍ଚ୍‍ଟା ୱେଡ଼ାଲିଂ କୁଲି କିଜ଼ି ମାଚାର୍‌, ହେୱାର୍‌ ୱାଜ଼ି ରଞ୍ଜାଙ୍ଗ୍‌ ରଞ୍ଜାଙ୍ଗ୍‌ ରୁପା ଟାକାଂ ଗାଟାତାର୍ ।” ");
INSERT INTO peg_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","ଆରେ, ପର୍ତୁମ୍‌ ୱାଜ଼ି କିଜ଼ିମାଚି କୁଲିୟାର୍‌ ୱାଜ଼ି ଆଦିକ୍‌ ଗାଟାନାପ୍ ଇଞ୍ଜି ବାବିକିତାର୍, “ମତର୍‌ ହେୱାର୍‌ ପା ରଞ୍ଜାଙ୍ଗ୍‌ ରଞ୍ଜାଙ୍ଗ୍‌ ରୁପା ଟାକାଂ ଗାଟାତାର୍ । ");
INSERT INTO peg_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","ହେୱାର୍‌ ହେୱାଙ୍ଗ୍‌ ଅଜ଼ି ହାଉକାର୍‌ ବିରୁଦ୍‌ତ ମାନ୍‍ଦୁକ୍‍ କିଜ଼ି ଇଚାର୍‌, ");
INSERT INTO peg_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","ମ୍ଡିକାହାରେସ୍‌ ପାଞ୍ଚ୍‍ଟାତ କାମାୟ୍‌ ହାଙ୍ଗ୍‍ଜି ମାନି କୁଲିୟାର୍‌ ମତର୍‌ ରଗଣ୍ଟା କାମାୟ୍‌ କିତାର୍ଣ୍ଣା । ଆସେଙ୍ଗ୍‌ ଇ କାରାତ ୱେଡ଼ାବୁଡି କିତାପ୍, ଇ ହାଜ୍‌ରି ହିନି ୱେଡ଼ାଂ ହେୱାରିଂ ମାହୁଦାଂ ସମାନ୍‌ କିତ୍‌ତାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","ହାଉକାର୍‌ ହେୱାର୍‌ ବିତ୍ରେ ରକାନିଂ ଉତର୍‌ ହିଜ଼ି ଇଚାନ୍‌, “ଟଣ୍ଡେନ୍‌ ! ଆନ୍‌ ନିଂ ଅନ୍ୟାୟ୍‌ କିଦ୍‍ୱାତାଂନା; ଏନ୍‌ ଇନାକା ନା ହୁଦାଂ ର ଟାକାଂ କାଜିଂ ରାଜି ଆୱାଦାଂ ମାଚାୟ୍‌ ? ");
INSERT INTO peg_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","ନିନ୍ଦାଂ ଇମ୍‌ଣାକା, ହେଦାଂ ଅଜ଼ି ହାଲା, ମାତର୍‌ ଇ ହାରିହାରା ଲକାଂ ପାନି ଲାକେ ହିଦେଂ କାଜିଂ ନା ମାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","ନା ଜାର୍‌ ଦନ୍‌ ଇନେସ୍‌ ହାର୍‌ ହେ ଏଲେଙ୍ଗ୍‌ କର୍ଚ କିଦେଙ୍ଗ୍‌ ଇନାକା ନା ଆଦିକାର୍‌ ହିଲୁତ୍‌ ? କି ଆନ୍‌ ଅଲପ୍‍ ଉଦାର୍‌ ଆତିଲେ ଏପେଙ୍ଗ୍‌ ୱିଜ଼ାଦେର୍‌ ନାଙ୍ଗ୍‌ ଆକର୍‌ ଆଦ୍‌ନାଦେର୍‌ ?” ");
INSERT INTO peg_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","“ହେ ଲାକେ ପାଚେ ମାନି ମାନାୟ୍‌ ପର୍ତୁମ୍‌ ଆନାର୍‌ ଆରି ପର୍ତୁମ୍‌ ମାନି ମାନାୟ୍‌ ପାଚେ ଆନାର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","ଜିସୁ ଜିରୁସାଲମ୍‌ତ ହାନି ହାସ୍‌ଦ ବାର ଚେଲାରିଂ ର ଲାଗେ କୁକ୍‌ଚି ଅଜ଼ି ବିନେ କିଜ଼ି ହେୱାରିଂ ଇଚାନ୍‌, ");
INSERT INTO peg_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“ହୁଡ଼ାଟ୍‌ ଆସେଙ୍ଗ୍‌ ଜିରୁସାଲମ୍‌ତ ହାନାସା । ହେବେ ମାନାୟ୍‌ ମାଜ଼ି ମୁଡ଼୍‌ ମାପ୍ରୁହେବାକିନାକାନ୍‌ ଆରି ଦରମ୍‌ ଗୁରୁର୍‌ କେଇଦ ହେଲାୟ୍‌ ଆନାନ୍‌ ହେୱାର୍‌ ହେୱାନିଂ ହାକି ଡାଣ୍ଡ୍‌ ହିନାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","ତା ପାଚେ ପାର୍ତିକିୱି ଜିହୁଦିର୍‌ କେଇଦ ପିସ୍ତି ହିନାର୍‌ । ପାର୍ତିକିୱି ଜିହୁଦି ତାଙ୍ଗ୍‌ ଗ୍ଡାଇନାର୍‌, କରଡା ଇଡ଼୍‌ନାର୍‌ ଆରି କ୍ରୁସ୍‌ତ ଦୁପ୍‌ନାର୍ । ମାତର୍‌ ତିନି ଦିନ୍‌ ପାଚେ ହେୱାନ୍‌ ଆରେ ନିଙ୍ଗ୍‌ନାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","ଇ ୱେଡ଼ାଲିଂ ଜେବ୍‌ଦିତି ଡକ୍ରୁହି ତା ରି ମେହିର୍‌ ହୁକେ ଜିସୁ ତାକେ ୱାଜ଼ି । ଜିସୁଙ୍ଗ୍‌ ଜୱାର୍‌ କିଜ଼ି ତାଙ୍ଗ୍‌ ଅଲପ୍‍ ଏନ୍ତାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","ଜିସୁ ହେଦେଲିଂ ୱେନ୍‌ବାତାନ୍‌, “ଇନାକା ମାନ୍‌ କିନାୟା ?” ହେଦେଲ୍‌ ଇଚାତ୍‌, “ଏନ୍‌ ଏଚେକାଡ଼୍‌ଦ ମି ରାଜିତ ରାଜା ଆନାୟ୍‌, ନା ଇ ରି ହିମ୍‌ଣାକାଂ ନି ବୁଜ୍‌ଣି ଆରି ଡେବ୍ରି ପାଡ଼୍‍କା କୁଚିକିନାୟ୍‍ ଇଞ୍ଜି ବଲ୍‌ ହିଦା ।” ");
INSERT INTO peg_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","ଜିସୁ ଜେବ୍‌ଦି ରିୟାର୍‌ ମାଜ଼ିରିଂ ଉତର୍‌ ହିତାନ୍‌, “ଏପେଙ୍ଗ୍‌ ଇନାକା ଏନ୍‌ନାଦେରା, ହେଦାଂ ପୁନୁଦେରା । ଆନ୍‌ ଦୁକ୍‌ ବଗ୍‌ନି ବାହାତ ଉଣ୍ଡେଙ୍ଗ୍‌ ହାନାଙ୍ଗା ? ହେବେ କି ଏପେଙ୍ଗ୍‌ ଉଣ୍ଡେଙ୍ଗ୍‌ ଆଡ୍‌ନାଦେର୍‌ ?” ହେୱାର୍‌ ତାଙ୍ଗ୍‌ ଇଚାର୍‌, “ଆଡ୍‌ନାପ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","ଜିସୁ ହେୱାରିଂ ଇଚାନ୍‌, “ଏପେଙ୍ଗ୍‌ ନା ଦୁକ୍‌ ବଗ୍‌ନି ବାହାତ ଉଣାକା ସତ୍‌, ମାତର୍‌ ନା ତିନାବାଗାଙ୍ଗ୍‌ ଆରି ଡେବ୍ରି ବାଗାଙ୍ଗ୍‌ କୁଚ୍‌ଚେଂ ହିନାକା ନା ଆଦିକାର୍‌ ବିସ୍ରେ ଆକାୟ୍‌, ଇଚିସ୍‌ ଇମ୍‌ଣାକାର୍‌ କାଜିଂ ନା ଆବା କାଜିଂ ବାହା ଜାଲ୍‌ଦି କିୟା ଆତାତ୍‌ନ୍ନା, ହେୱାର୍‌ କୁଚ୍‌ନାର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","ବିନ୍‌ ଦାସ୍‍ ଜାଣ୍‌ ଇଦାଂ ୱେନ୍‌ଞ୍ଜି ହେ ଟଣ୍ଡ୍‌ରିୟାର୍‌ ଜପି ରିସା ଆତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","ମାତର୍‌ ଜିସୁ ଚେଲାରିଂ ଲାଗେ କୁକ୍‌ଚି ଇଚାନ୍‌, “ପାର୍ତିକିୱି ଜିହୁଦିର୍‌ ସାସନ୍‌ କାରିୟାର୍‌ ହେୱାର୍‌ ଜପି ରାଜ୍‌କିନାର୍‌ ଆରି ଗାଜା ମୁଣିକାର୍‌ ହେୱାର୍‌ ଜପି ୱିଜ଼ୁ ରାଜ୍‌କିନାର୍‌, ଇଦାଂ ଏପେଙ୍ଗ୍‌ ପୁନାଟ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","“ମି ବିତ୍ରେ ହେ ଲାକେ ଆକାୟ୍‌, ମାତର୍‌ ମି ବିତ୍ରେ ଜେ ଇନେର୍‌ ଗାଜା ଆଦେଂ ମାନ୍‌ କିନାନ୍‌, ହେୱେନ୍‌ ମି ହେବା କିନାକାନ୍‌ ଆୟେନ୍‌, ");
INSERT INTO peg_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","ଆରେ ଇନେର୍‌କି ମୁଡ଼୍‌ ଆଦେଂ ଇଚା କିନାନ୍‌, ହେୱେନ୍‌ ମି ହଲ୍ୟା ଆୟେନ୍‌, ");
INSERT INTO peg_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","ଇନେସ୍‌ ମାନାୟ୍‌ ମାଜ଼ି ହେବା ପାୟା ଆଦେଂ ୱାୱାତାନ୍‍ନା, ମତର୍‌ ହେବା କିଦେଙ୍ଗ୍‌ ଆରି ହେନି କାଜିଂ ମୁକ୍‌ଡ଼ାୟ୍‌ କିନି ମୁଲ୍‌ଲାକେ ଜିବୁନ୍‌ ହିଦେଂ ୱାତାନ୍‌ନା ।” ");
INSERT INTO peg_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","ହେୱାର୍‌ ଜିରିହ ବସ୍ତିତ ହସି ହାନି ୱେଡ଼ାଲିଂ ବେସିହେନି ମାନାୟାର୍‌ ତା ପାଚେ ପାଚେ ହାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","ଆରେ ହୁଡ଼ାଟ୍‌, ହାଜ଼ି କଚଣ୍‌ ରିୟାର୍‌ କାଣାର୍‌ ଜିସୁ ହେ ହାଜ଼ି ହାନାନା ଇଞ୍ଜି ୱେନ୍‌ଞ୍ଜି ଗାଜା କାଟ୍‌ କିଜ଼ି ଇଚାର୍‌, “ଏ ମାପ୍ରୁ, ଦାଉଦ୍‌ ମେହି, ମାଙ୍ଗେଙ୍ଗ୍‌ ଦୟା କିଦା ।” ");
INSERT INTO peg_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","ଲକୁ ମୁମ୍‌ଦ ହେୱାରିଂ ଦାକା କିଜ଼ି ଚିମ୍‌ରା ଆଦେଂ ଇଚାର୍‌ । ମାତର୍‌ ହେୱାର୍‌ ଆରି ଚେରା ଆଜ଼ି ଇଚାର୍‌, “ଏ ମାପ୍ରୁ ଦାଉଦ୍‌ ମେହି, ମାଙ୍ଗ୍‌ ଦୟା କିଦା ।” ");
INSERT INTO peg_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","ହେବେତାଂ ଜିସୁ ନିଲ୍‌ଚି ହେୱାରିଂ ହିର୍‌ବିସ୍‌ ୱେନ୍‌ବାତାନ୍‌, “ଆନ୍‌ ମି କାଜିଂ ଇନାକା କିନାଙ୍ଗ୍‌ ଇଞ୍ଜି ଏପେଙ୍ଗ୍‌ ଇଚା କିନାଦେରା ?” ");
INSERT INTO peg_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","ହେୱାର୍‌ ତାଙ୍ଗ୍‌ ଇଚାର୍‌, “ଏ ମାପ୍ରୁ, ଇନେସ୍‌ ମା କାଣ୍‌ଙ୍ଗା ଜେୟା ଆନାତ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","ଆରେ, ଜିସୁ ଦୟା କିଜ଼ି ହେୱାର୍‌ କାଣ୍‌ଙ୍ଗା ଡୁତାନ୍‌ ଆରି ହେ ଦାପ୍ରେ ହେୱାର୍‌ କାଣ୍‌ଙ୍ଗା ହୁଡ଼୍‌ଜି ଜିସୁ ପାଚେ ପାଚେ ତାଙ୍ଗ୍‌ଦେଂ ଲାଗାତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","ହେ ପାଦ୍‌ନା ଜିସୁ ଆରି ଚେଲାର୍‌ ଜିରୁସାଲମ୍‌ କଚଣ୍‌ ବେତ୍‌ପାଗି ନାସ୍‌ତାଂ ଏକାତାର୍‌ ହେ ପାଦ୍‌ନା ରିୟାର୍‌ ଚେଲାର୍‌ ଜିତ୍‌ମାଡ଼ି ଏକାତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","ମି “ଲାଗେ ହେ ନାସ୍ତ ହାଲାଟ୍‌, ଆରେ ହାନିଲାଡ଼େ ଗାଚ୍ୟା ଆଜ଼ି ମାନି ର ଗଦ ହିମ୍‌ଣା ଆରି ତା ଲାହାଙ୍ଗ୍‌ ର ହିମ୍‍ଣା ହୁଡ଼୍‌ନାଦେର୍‌; ହେୱେକିୟାଙ୍ଗ୍ ରିକ୍‌ଚି ନା କଚଣ୍‌ ତାହିୱାଡୁ ।” ");
INSERT INTO peg_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","ଆରେ, ଇନାୱାଡ଼ାଂ ଇନେର୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ଇନାକା ଇନାର୍‌, “ଲାଗିଂ ଇନାଦେର୍‌, ଇୱାଙ୍ଗ୍‌ ତାକେ ମାପ୍ରୁ ଲଡ଼ା ମାନାତ୍‌ । ହେ ଦାପ୍ରେ ହେୱେନ୍‌ ହେୱେକିୟାଙ୍ଗ୍ ପକ୍ତାନାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","ବେଣ୍‌ବାକ୍‌ଣାୟ୍‌କିନାକାର୍‌ କାଜିଂ ଇଦାଂ ଇ ବଚନ୍‌ ଇନେସ୍‌ ପୁରା ଆନାତ୍‌, ହେଦାଂ କାଜିଂ ଇଦାଂ ଗିଟା ଆତାତ୍‌, ");
INSERT INTO peg_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“ସିୟନ୍‌ନି ଗାଡ଼୍‌ଚେଂ ୱେଚାଟ୍‌, ହୁଡ଼ା, ମି ରାଜା ନି କଚଣ୍‌ ୱାନାନା; ହେୱାନ୍‌ ହୁଦାର୍‌ ଆରି ଗଦ ହିମ୍‌ଣା ଜପି କୁଚ୍‌ଚାନ୍ନା ଗଦ ଜପି କୁଚ୍‌ଚାକାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","ହେବେ ଚେଲାହିର୍‌ ହାଲ୍‌ଜି ଜିସୁଙ୍ଗ୍‌ ବଲ୍‌ ତାଙ୍ଗ୍‌ କାମାୟ୍‌ କିତାର୍‌, ");
INSERT INTO peg_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","ଆରେ ଗଦ ହିମ୍‌ଣା ତାସି ହେୱାଙ୍ଗ୍‌ ଜପି ହେନ୍ଦ୍ରା ପାସ୍‍ସି ହିତାର୍, ଆରେ ଜିସୁ ତା ଜପି କୁଚ୍‌ଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","ଆରେ, ମାନାୟାର୍‌ ବିତ୍ରେ କେତେଜାଣ୍‌ ଜାର୍‌ ଜାର୍‌ ହେନ୍ଦ୍ରା ହାସ୍‌ଦ ପାସ୍ତାର୍ ଆରି କେତେଜାଣ୍‌ ମାର୍‌ଦାଂ ଡାଡ଼୍‌ କାଦ୍‌ଦି ତାସି ହାସ୍‌ଦ ପାସ୍‍ସି ହିଦେଂ ଲାଗାତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","ଆରେ ତା ଆଗେ ଆରି ପାଚେ ହାଲ୍‌ଜି ମାନି ମାନାୟାର୍‌ ଗାଜା କାଟ୍‌ତାଂ ଇଞ୍ଜେଙ୍ଗ୍‌ ଲାଗାତାର୍‌, ହସାନ୍ନା “ଦାଉଦ୍‌ତି ହିମ୍‍ଣା ଦନ୍ୟବାଦ୍‌ କିୟାଟ୍‌ ! ମାପ୍ରୁ ତର୍‌ଦାଂ ଇନେର୍‌ ୱାନାରା, ହେୱେନ୍‌ ଦନ୍ୟ ମାପ୍ରୁ କେର୍‌କଣ୍‌ ଆୟେତ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","ଆରେ, ହେୱେନ୍‌ ଜିରୁସାଲମ୍‌ତ ହଣ୍‌ଗାତାନ୍‌, ଗାଡ଼୍‌ନିକାର୍‌ ଇୱାନ୍‌ ଇନେନ୍‌ ଇଞ୍ଜି ବିଙ୍ଗ୍‌ବିଙ୍ଗ୍‌ ଆତାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","ହେବେତାଂ ମାନାୟାର୍‌ ଇଚାର୍‌, “ଇୱେନ୍ ଗାଲିଲିନି ନାଜରିତ୍‌ତ ର ବେଣ୍‌ବାକ୍‌ଣାୟ୍‌କିନାକାନ୍‌ ଜିସୁ ।” ");
INSERT INTO peg_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","ପାଚେ ଜିସୁ ମନ୍ଦିର୍‌ତ ହଣ୍‌ଜି ହେ ବାହାତ କଡ଼୍‌ନାକା ପ୍ରନାକାରିଂ ୱିଜ଼ାର୍‌ ମାନାୟାରିଂ ହପ୍‍ତାନ୍, ଆରେ ଡାବୁଙ୍ଗ୍‌ ବେପ୍ରିୟାର୍‌ତି ପାଟା ଆରି ପାଣ୍ଡ୍‌କା ବେପ୍ରିୟାର୍‌ତି କୁଚ୍‌ନି ବାହା ଉଲ୍‌ଟାୟ୍‌ କିତାନ୍‌, ");
INSERT INTO peg_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","ଆରେ ଜିସୁ ହେୱାରିଂ ଇଚାନ୍‌, ଦର୍‌ମ ସାସ୍ତର୍‌ତ ଲେକା ମାନାତ୍‌, “ମା ଇଲ୍‌ ପାର୍ତାନା ଇଲ୍‌ ଇଞ୍ଜି ପୁଟା ଆନାତ୍‌ ମାତର୍‌ ଏପେଙ୍ଗ୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ଚର୍କୁ ଇଲ୍‌ କିତାଦେର୍ଣ୍ଣା ।” ");
INSERT INTO peg_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","ଆରେ, ମନ୍ଦିର୍‌ତ କାଣା ଆରି ହିର୍‌କଲ୍‌ ରଗି ମାନାୟ୍‌ ତା କଚଣ୍‌ ୱାତିଲେ, ହେୱେନ୍‌ ହେୱାରିଂ ଉଜ୍‌ କିତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","ମାତର୍‌ ମୁଡ଼୍‌ ମାପ୍ରୁହେବାକିନାକାନ୍‌ ଆରି ଗୁରୁର୍‌ ତା କିତି କାବା ଆନି କାମାୟ୍‌ ସବୁ ଆରି ମନ୍ଦିର୍‌ ବିତ୍ରେ ହସାନ୍ନା “ଦାଉଦ୍‌ନି ହିମ୍‍ଣା” ଇଞ୍ଜି ଗାଜା କାଟ୍‌ କିଜ଼ି ମାନି କାଡ଼୍‌ଦେରିଂ ହୁଡ଼୍‌ଜି ରିସା ଆତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","ହେୱାର୍‌ ଜିସୁଙ୍ଗ୍‌ ୱେନ୍‍ବାତାର୍‍, “ଇୱାର୍‌ ଇନାକା ଇଞ୍ଜ୍‌ନାରା, ଏପେଙ୍ଗ୍‌ ୱେନାଦେରା ?” ଜିସୁ ହେୱାରିଂ ଇଚାନ୍‌, “ଆଁ, ଏନେଙ୍ଗ୍‌ ହିମ୍‌ଣା ଆରି ଉଣାକାର୍‌ ୱେଇ କାଜିଂ ମିଦାଙ୍ଗ୍‌ ଇନାକା ଦରମ୍‌ ସାସ୍ତର୍‌ତ ଲେକାତାତ୍‌ନା ପଡ଼ି କିୱାତାଇନା କି, ଏନ୍‌ ହିମ୍‌ଣାଂ ଆରି କଡ଼୍‌ଗେ ହିମ୍‌ଣାକାଂ ଆଦିକ୍‌ ୱାରି କିଦେଙ୍ଗ୍‌ ହିକ୍ୟା ହିତାୟ୍‌ନା ?” ");
INSERT INTO peg_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","ଇଦାଂ ଇଞ୍ଜି ଜିସୁ ହେୱାରିଂ ପିସ୍ତି ଜିରୁସାଲମ୍‌ତାଂ ହସି ବେତ୍‌ନିୟା ହାଚାର୍‌ । ହେବେ ଜିସୁ ନାଣା ମାଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","ହେ ଆର୍କାତ୍‌ ନାଜିଂ ଜିସୁ ଜିରୁସାଲମ୍‌ତାଂ ୱାନିହିଂ ନାସ୍‌କି ଆତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","ହାଜ଼ି କଚଣ୍‌ ର ତଗା ମାର୍‌ ମାଚାତ୍‌ । ଜିସୁ ତା ଲାଗାଂ ହାଲ୍‌ଜି ହେବେ ଆକିଂ ପିସ୍ତି ଆରି ଇନାକା ହୁଡ଼୍‍ୱାତାନ୍ । ଲାଗିଂ ଜିସୁ ମାର୍‌ତିଂ ଇଚାନ୍‌, “ଏନ୍‌ ଆରେ ମୁଡ଼୍‌କେ ପାଡ଼୍‌ ଆହ୍‌ମା ।” ହେ ଦାପ୍ରେ ତଗା ମାର୍‌ ୱାଜ୍‌ଜି ହାଚାତ୍ । ");
INSERT INTO peg_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","ଚେଲାହିର୍‌ ଇଦାଂ ହୁଡ଼୍‌ଜି କାବା ଆଜ଼ି ୱେନ୍‍ବାତାର୍, “ତଗା ମାର୍‌ ଏଚେଚାଣ୍ଡ୍‌ ୱାଚ୍‌ଚାତ୍‌ ଇନେସ୍‌ ?” ");
INSERT INTO peg_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","ଜିସୁ ଉତର୍‌ ହିତାନ୍‌, “ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ହାତ୍‌ପା ଇଞ୍ଜ୍‌ନାଙ୍ଗା, ଜଦି ମି ପାର୍ତି ମାନାତ୍‌, ଆରେ ଏପେଙ୍ଗ୍‌ ପାର୍ତି କିଉଦେର୍‌, ଲାଗିଂ ଇ ତଗା ମାର୍‌ କାଜିଂ ଇନେସ୍‌ କିୟାଆତାତ୍‌ନା, କେବଲ୍‌ ଇନେର୍‌ ହେ ଲାକେ କିନାଦେର୍‌, ହେଦାଂ ଆକାୟ୍‌, ମତର୍‌ ଜଦି ଇ ମାଡ଼ିତିଂ ପା ଏନ୍‌ ନିଙ୍ଗ୍‌ଜି ହାମ୍‌ଦୁର୍‌ତ ହାଲ୍‌ଜି ଆରା ଇଞ୍ଜି ଇନାଦେର୍‌, ତା ଆତିସ୍‌ ହେଦାଂ ଗିଟା ଆନାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","ଆରେ, ପାର୍ତି କିଜ଼ି ପାର୍ତାନାତାଂ ଇନାକା ପା ଏନ୍‌ନାଦେର୍‌ ହେ ସବୁ ପାୟାନାଦେର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","ପାଚେ ଜିସୁ ମନ୍ଦିର୍‌ତ ହଣ୍‌ଜି ହିକ୍ୟା ହିନି ୱେଡ଼ାଲିଂ ମୁଡ଼୍‌ ମାପ୍ରୁହେବା କିନାକାର୍‌ ଆରି ମାନାୟାର୍‌ତି ବୁଡ଼ାଲୁର୍‌ ତା କଚଣ୍‌ ୱାଜ଼ି ୱେନ୍‍ବାତାର୍‍, ଏନ୍‌ “ଇମ୍‌ଣି ଆଦିକାର୍‌‌ତାଂ ଇ ୱିଜ଼ୁ କିନାୟା ? ଆରେ, ନିଙ୍ଗେଙ୍ଗ୍‌ ଇନେର୍‌ ଇ ଆଦିକାର୍‌ ହିତ୍‍ତାର୍‍ ?” ");
INSERT INTO peg_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","ଜିସୁ ହେୱାରିଂ ଉତର୍‌ ହିତାନ୍‌, “ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ କେବଲ୍‌ ର ପର୍‌ସନ୍‌ ଗୱାରି କିଦ୍‌ନାଙ୍ଗ୍‌ ହେ ଉତର୍‌ ହିଦେଂ ଆଡ଼୍‌ତିସ୍‌, ଆନ୍‌ ଇମ୍‌ଣି ଆଦିକାର୍‌ ଇ ୱିଜ଼ୁ କାମାୟ୍‌ କିନାଙ୍ଗା, ମିଙ୍ଗେଙ୍ଗ୍‌ ୱେଚ୍‍ନାଙ୍ଗ୍ । ");
INSERT INTO peg_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","ବାପ୍ତିସିମ୍‌ ହିନାକା ଆଦିକାର୍‌ ଜହନ୍‌ ଇନେର୍‌ତାଂ ଗାଟା ଆଜ଼ି ମାଚାନ୍‌ ? ସାର୍ଗେତାଂ କି ମାନାୟ୍‌ତିଂ ?” ହେବେ ହେୱାର୍‌ ହେୱାର୍‌ ବିତ୍ରେ ବେଣ୍‌କିତାର୍‌ “ଇ ବିସ୍ରେ ଇନାକା ଇନାସ୍‌ ? ଜଦି ଇନାସ୍‌ ଇସ୍ୱର୍‌ତାଂ, ଲାଗିଂ ଜହନ୍‌ତିଂ ଇନାକିଦେଂ ପାର୍ତି କିଉଦେରା ଇଞ୍ଜି ହେୱାନ୍‌ ମାଙ୍ଗେଙ୍ଗ୍‌ ୱେନ୍‌ବାଦାନାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","ମାନାୟ୍‌ତିଂ ଇଞ୍ଜି ଜଦି ଇନାସ୍‌, ଲାଗିଂ ମାନାୟାରିଂ ମାଙ୍ଗ୍‌ ପାଣ୍ଡ୍ରୁ ହତ୍‌ନାତା, ଇନାକିଦେଂକି ୱିଜ଼ାର୍‌ ମାନାୟାର୍‌ ଜହନ୍‌ ରକାନ୍‌ ବେଣ୍‌ବାକ୍‌ଣାୟ୍‌ କିନାକାନ୍‌ ଇଞ୍ଜି ହେୱାର୍‌ ପାର୍ତି କିନାରା ।” ");
INSERT INTO peg_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","ହେଦାଂ କାଜିଂ ହେୱାର୍‌ ଜିସୁ ଉତର୍‌ ହିଜ଼ି ଇଚାର୍‌, “ଆପେଂ ପୁନୁପ୍‌ ।” ଜିସୁ ହେୱାରିଂ ଇଚାନ୍‌, “ଇନେର୍‌ ଆଦିକାର୍‌‌ତାଂ ଇ ସବୁ କିନାଙ୍ଗା, ଆନ୍‌ ପା ମିଙ୍ଗେଙ୍ଗ୍‌ ୱେଚ୍‍ଚୁଙ୍ଗ୍ ।” ");
INSERT INTO peg_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“ମତର୍‌ ଏପେଙ୍ଗ୍‌ ଇନାକା ମାନେ କିୟା ? ରୱାନ୍‌ ମାନାୟ୍‌ତିଂ ରିୟାର୍‌ ମାଜ଼ି ମାଚାର୍‌ । ହେୱେନ୍‌ ପର୍ତୁମ୍‌ କଚଣ୍‌ ୱାଜ଼ି ଗାଜା ମାଜ଼ି ଇଚାନ୍‌, ମାଜ଼ି, ହାଲା, ନେଞ୍ଜେଙ୍ଗ୍‌ ଅଙ୍ଗୁର୍‌ ବାଡ଼୍‌ଦ କାମାୟ୍‌ କିୟା । ");
INSERT INTO peg_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","ହେୱେନ୍‌ ଉତର୍‌ ହିତାନ୍‌, ନା ଇଚା ଆକାୟ୍‌, ମାତର୍‌ ପାଚେ ମାନ୍‌ବାଦ୍‌ଲାୟ୍‌ କିଜ଼ି ହାଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","ଆରେ, ଆବା ଆରେ ରକାନ୍‌ କଚଣ୍‌ ୱାଜ଼ି ହେ ଲାକେ ଇଚାନ୍‌ । ହେୱାନ୍‌ ଉତର୍‌ ହିତାନ୍‌, ଗୁରୁ, ଆନ୍‌ ହାନାଙ୍ଗା, ମାତର୍‌ ହାଲ୍‍ୱାତାନ୍ । ");
INSERT INTO peg_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","ଇନା, ଇ ରିୟାର୍‌ ମେହିର୍‌ ବିତ୍ରେ ଇନେର୍‌ ତା ଆବାତି ବଲ୍‌ ମାନି କିଜ଼ି ମାଚାନ୍‌ ?” ହେୱାର୍‌ ଇଚାର୍‌, “ଗାଜା ମେହି ।” ଜିସୁ ହେୱାରିଂ ଇଚାନ୍‌, “ଆନ୍‌ ହାତ୍‌ପା ଇଞ୍ଜ୍‌ନାଙ୍ଗା ସିସ୍ତୁଏନ୍‌ନାକାର୍‌ ଆରି ଦାରୁଲାର୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ତାଙ୍ଗ୍‌ ଆଗେ ଇସ୍ୱର୍‌ ରାଜିତ ହଣାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","ଇନାକିଦେଂକି ଜହନ୍‌ ମି କଚଣ୍‌ ଦାର୍ମିନି ହାଜ଼ି ହିଜ଼ି ୱାତାନ୍‍, ଆରେ ଏପେଙ୍ଗ୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ପାର୍ତି କିୱାତାଦେର୍‌, ମତର୍‌ ସିସ୍ତୁଏନ୍‌ନାକାର୍‌ ଆରି ଦାରୁଲାର୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ପାର୍ତି କିତାର୍‌, ମାତର୍‌ ଏପେଙ୍ଗ୍‌ ଇନେସ୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ପାର୍ତି କିଦେଙ୍ଗ୍‌ ଆଡ୍‌ନାଦେର୍‌, ଇଦାଂ କାଜିଂ ହେଦାଂ ହୁଡ଼୍‌ଜି ପା ମାନ୍‌ବାଦ୍‌ଲାୟ୍‌ କିୱାତାଦେର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“ଆରେ ର ଉତର୍‌ମୁଡ଼୍‌ ୱେନାଟ୍‌ । ରୱାନ୍‌ ଇଲ୍‌ ହାଉକାର୍‌ ମାଚାନ୍‌, ହେୱାନ୍‌ ର ଅଙ୍ଗୁର୍‌ ବାଡ଼୍‌ କିଜ଼ି ଚାରିବେଣ୍‌ତାଂ ବାଡ଼୍‌ ଡ଼ଚ୍‌ଚାନ୍‌ ଆରି ହେ ବିତ୍ରେ ଅଙ୍ଗୁର୍‌କୁଣ୍ଡି କାର୍ଚି ମାଚା ରଚ୍‌ଚାନ୍‌, ଆରେ କାମ୍‌ଲିୟାରିଂ ହେ ବାଡ଼୍‌ ବାଗ୍‌ ହିଜ଼ି ବିଦେସ୍‌ ହାଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","ପାଚେ ପାଡ଼୍‍ନି ସମୁ ଲାଗେ ୱାତିଲେ, ହେୱାନ୍‌ ଜାର୍‌ ପାଡ଼୍‌ ଗାଟାଆଦେଂ କାଜିଂ କାମ୍‌ଲିୟାର୍‌ ଲାଗାଂ ଜାର୍‌ ଆଡ଼ିୟାରିଂ ପକ୍‌ତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","ମାତର୍‌ କାମ୍‌ଲିୟାର୍‌ ହେୱାନ୍ତି ଆଡ଼ିୟାରିଂ ଆସ୍ତି ରକାନିଂ ଟ୍ରାକ୍‌ତାର୍‌, ଆରେ ରକାନିଂ ଅସ୍ତାର୍‌, ଆରେ ରକାନିଂ କାଲ୍‌କୁ ଇଡ଼୍‌ଜି ଅସ୍ତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","ଆରେ ରଗ ବାଡ଼୍‌ ମାଲିକ୍‌ ହିଗ୍‍ଦତାଂ ବେସିହେନି ଆଡ଼ିୟାରିଂ ପକ୍‌ତାନ୍‌, ଆରେ ବାଗ୍‌ କାମ୍‌ଲିୟାର୍‌ ହେୱାର୍‌ ହେୱାର୍‌ କାଜିଂ ହେ ଲାକେ କିତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","ମାତର୍‌ ନା ମେହିଙ୍ଗ୍‌ ହେୱାର୍‌ ମାନି କିନାର୍‌, ଇଦାଂ ଇଞ୍ଜି ୱିସ୍ତିହିଙ୍ଗ୍‌ ହେୱାନ୍‌ ପାଚେ ଜାର୍‌ ମାଜ଼ି ହେୱାର୍‌ ତାକେ ପକ୍‌ତାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","“ମତର୍‌ ହେ କାମ୍‌ଲିୟାର୍‌ ମେହିଙ୍ଗ୍‌ ହୁଡ଼୍‌ଜି ରୱାନ୍‌ ଆରେ ରୱାନିଂ ଇଚାର୍‌, ‘ଇୱାନ୍‌ ହୁଡ଼ାଟ୍‌ ହାଉକାର୍‌ ମେହି; ୱାଡୁ, ଇୱାନିଂ ଅଜ଼ି ଆସେଙ୍ଗ୍‌ ଇୱାନ୍ତି ଆଦିକାର୍‌ କେଇଦ ଅନାସ୍‌ ।’ ");
INSERT INTO peg_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","ହେବେ ହେୱାର୍‌ ହେୱାନିଂ ଅଜ଼ି ଅଙ୍ଗୁର୍‌ ବାଡ଼୍‌ନି ବାର୍ତ ତୁଇଜ଼ି ଅସ୍ତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","ଜିସୁ ୱେନ୍‌ବାତାନ୍‌, ଏଚେକାଡ଼୍‌ଦ ହେ ଅଙ୍ଗୁର୍‌ ବାଡ଼୍‌ନି ହାଉକାର୍‌ ୱାନାନ୍‌, ହେୱାଡ଼ାଂ ହେ କାମ୍‌ଲିୟାର୍‌ କାଜିଂ ହେୱାନ୍‌ ଇନାକା କିନାନ୍‌ ?” ");
INSERT INTO peg_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","ହେୱାର୍‌ ହେୱାନିଂ ଇଚାର୍‌ “ହେୱାନ୍‌ ହେ ବାନିୟାରିଂ ହେୱାନ୍‌ ହାତେନେ ଅହ୍‌ନାର୍‌ ଆରି ଇମ୍‌ଣି ବିନ୍‌ ବାଗ୍‌ କାମ୍‌ଲିୟାର୍‌ ହେୱାନିଂ ସମାନ୍‌ ସମୁତ ବାଗ୍‌ନି ପାଡ଼୍‌ ହିନାର୍‌, ହେୱାରିଂ ଅଙ୍ଗୁର୍‌ ବାଡ଼୍‌ ବାଗ୍‌ ହିନାନାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","ଜିସୁ ହେୱାରିଂ ଇଚାନ୍‌, “ଏପେଙ୍ଗ୍‌ କି ଇନାୱାଡ଼ାଂପା ଦରମ୍‌ ସାସ୍ତର୍‌ତ ଇ କାତା ପଡ଼ି କିୱାତାଦେର୍ଣ୍ଣା, ‘ଇଲ୍‌ ରଚ୍‌ନାକାର୍‌ ଇମ୍‌ଣି କାଲ୍‌ଦିଂ ମୁନାକିତାନ୍‌, ହେଦାଂ କନାନି ମୁଡ଼୍‌କାଲ୍‌ ଆତାତ୍‌; ମାପ୍ରୁତାଂ ଇଦାଂ ଆତାତ୍‌, ଆରେ ହେଦାଂ ମା କାଣ୍‌କୁତ କାବାଆନାକା ?’ ");
INSERT INTO peg_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","ଇଦାଂ କାଜିଂ ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ଇଞ୍ଜ୍‌ନାଙ୍ଗା, ଇସ୍ୱର୍ତି ରାଜି ମିତାଙ୍ଗ୍ ଉନ୍‌ଦିୟାନାତ୍‌, ଆରେ ଇମ୍‌ଣି ଜାତି ହେବେନି ପାଡ଼୍‌ ଆହ୍‌ନାତ୍‌, ହେୱାନିଂ ହିୟାନାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","ଆରେ, ଇନେର୍‌ ଇ କାଲ୍‌ ଜପି ଆର୍ନାର୍‌, ହେୱାନ୍‌ ବିରାଆନାନ୍‌, ଆରେ ଇ କାଲ୍‌ ଇନେର୍‌ ଜପି ଆର୍ନାତ୍‌, ହେୱାନିଂ ହେଦାଂ ବିରାୟ୍‌ କିନାତ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","ମୁଡ଼୍‌ମାପ୍ରୁହେବାକିନାକାର୍‌ ଆରି ପାରୁସିର୍‌ ଜିସୁତି ଇ ସବୁ ଉତର୍‌ମୁଡ଼୍‌ ୱେନ୍‌ଞ୍ଜି, ଜିସୁ ଜେ ହେୱାର୍‌ ବିସ୍ରେ ଇଟ୍‌କାଡ଼୍‌ କିତାର୍ଣ୍ଣା ଇଞ୍ଜି, ବୁଜାଆତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","ଆରେ, ହେୱାର୍‌ ହେୱାନିଂ ଆସ୍ତେଙ୍ଗ୍‌ ସେସ୍ଟା କିତାର୍‌, ମାତର୍‌ ମାନାୟାରିଂ ପାଣ୍ଡ୍ରାତାର୍‌, ଇନାକିଦେଂକି ହେୱାର୍‌ ହେୱାନିଂ ବେଣ୍‌ବାକ୍‌ଣାୟ୍‌ କିନାକାନ୍‌ ଇଞ୍ଜି ମାନି କିଜ଼ି ମାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","ଜିସୁ ଆରେ ରଗ ଉତର୍‌ମୁଡ଼୍‌ ହୁକେ ଲକୁରିଂ ହିକ୍ୟା ହିତାନ୍‌, ");
INSERT INTO peg_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“ସାର୍ଗେ ରାଜି ଏଲେଙ୍ଗ୍‌, ରକାନ୍‌ ରାଜା ମାଚାନ୍‌, ଇନେର୍‌କି ଜାର୍‌ ମାଜ଼ିତି ବିବା ବଜି ଜାଲ୍‌ଦି କିତାନ୍‌, ");
INSERT INTO peg_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","ଆରେ ହେ ବଜିତ କୁକ୍ୟାତି ଲକାରିଂ କୁକ୍‌ଚି ତାତେଙ୍ଗ୍‌ ଇଞ୍ଜି ହେୱାନ୍‌ ହେ ଆଡ଼ିୟାରିଂ ପକ୍‌ତାନ୍‌, ମାତର୍‌ ହେୱାର୍‌ ୱାଦେଙ୍ଗ୍‌ ମାନ୍‌ କିୱାତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","ଆରେ ରଗ ହେୱାନ୍‌ ବିନ୍‌ ଆଡ଼ିୟାରିଂ ପକ୍‌ଚି ବଲ୍‌ ହିତାନ୍‌, କୁକ୍‌ତି ଲଗାଂ ଇନାଟ୍‌, ହୁଡ଼ାଟ୍‌, ‘ଆପେଂ ମା’ ବଜି ଜାଲ୍‌ଦି କିତାପ୍‌ନ୍ନା, ମା ସଣ୍ଡ୍‌ ଆରି ଦୁମାଂ ଅହ୍‍ରିଙ୍ଗ୍ ପାଗ୍‍ତାପ୍‍ନ୍ନା, ୱିଜ଼ୁ ଜାଲ୍‌ଦି ଆତାତ୍‌ନ୍ନା, ଏପେଙ୍ଗ୍‌ ବିବା ବଜିତ ୱାଡୁ ।” ");
INSERT INTO peg_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","“ମାତର୍‌ କୁକ୍ୟାତି ମୁଣିକାର୍ ଇ କାତାତିଂ ମାନିକିୱାଦାଂ ଜାର୍‌ ଜାର୍‌ କାମାୟ୍‌ କିଦେଙ୍ଗ୍‌ ଲାଗାତାର୍‌ ରୱାନ୍‌ ତା ବୁମିତ ହାଚାନ୍‌, ଆରେ ରୱାନ୍‌ ଦୁକାଣ୍‍ତ ହାଚାନ୍‌ ଆରି, ");
INSERT INTO peg_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","ଆରେ କେତେକ୍‌ ଜାଣ୍‌ ରାଜାତି ଆଡ଼ିୟାରିଂ ଆସ୍ତି ଅସ୍‍ପାତାର୍ । ");
INSERT INTO peg_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","ରାଜା ରିସା ଆଜ଼ି ମେଲ୍ୟାରିଂ ପକ୍‌ତାନ୍‌ । ହେୱାର୍‌ ହେ ନାର୍‌ ମାରୁରିଂ ଅଜ଼ି ହେୱାର୍‌ତି ବସ୍ତିତିଙ୍ଗ୍‌ ନିସ୍‍ତ ମେହାୟ୍‌ କିତାର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","ତା ପାଚେ ରାଜା ଆଡ଼ିୟାରିଂ କୁକ୍‌ଚି ଇଚାନ୍‌, “ବିବା ବଜି ଜାଲ୍‌ଦି, ମାତର୍‌ ଆନ୍‌ କୁକ୍ତାକାର୍‌ ୱାଦେଙ୍ଗ୍ କାୱାତାର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","“ଲାଗିଂ ରାଜ୍‌ଡାଣ୍ଡ୍‌ନି ଡେଡ଼ା ଡେଡ଼ା ହାଲ୍‌ଜି ଏଚେକ୍‌ ଲକାଂ ହୁଡ଼୍‌ନାଦେର୍‌, ୱିଜ଼ାକାରିଂ ମା ବଜିତ କୁକ୍‌ଚି ତାହିୱାଡୁ ।” ");
INSERT INTO peg_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","ଲାଗିଂ ଆଡ଼ିୟାର୍‌ ପାଟି ପାଟିତିଂ ବୁଲାଆଜ଼ି ହାର୍‌ ଆଏତ୍‌ କି, ବାନ୍ୟା; ଏଚେକ୍‌ ଲଗାଂ ହୁଡ଼୍‌ତାର୍‌, ୱିଜ଼ାକାରିଂ କୁକ୍‌ଚି ତାହିୱାତାର୍‌ ଆରି ବିବା ଇଞ୍ଜ ବାର୍ତି କିତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“ରାଜା ଗତାକାଂ ହୁଡ଼୍‌ଦେଂ ୱାତାନ୍ । ହେୱାନ୍‌ ହୁଡ଼୍‌ତାନ୍‌, ହେୱାର୍‌ ବିତ୍ରେ ରୱାନ୍‌ ବିବା ହେନ୍ଦ୍ରା ଉସ୍‍ପା ୱାଦାଂ ମାନି ରୱାନିଙ୍ଗ୍‌ ହୁଡ଼୍‌ଜି ହେୱାନିଙ୍ଗ୍‌ ଇଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","ରାଜା ହେୱାନିଂ ୱେନ୍‌ବାତାନ୍‌, ‘ବନ୍ଦୁ, ବିବା ଇଲ୍‌ ହେନ୍ଦ୍ରା ଉସ୍‌ପାୱାଦାଂ ଇବେ ୱାତାୟ୍ ଇନେସ୍‌ ?’ ମାନାୟ୍‌ ଉତର୍‌ ହିୱାଦାଂ ଚିମ୍‌ରା ଆତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","ରାଜା ଆଡ଼ିୟା ୱେଚ୍‌ଚାନ୍‌, ତା କେଇକାଲ୍ ଗାଚ୍‌ଚି ବାର୍ତ ମାଜ୍‌ଗାତ ତୁହିୟାଟ୍ । ହେବେ ଆଡ଼୍‌ବିସ୍‌ ଟାଡାଙ୍ଗ୍‌ ରେତିକିନାନ୍‍ ।” ");
INSERT INTO peg_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","ଜିସୁ ୱିସ୍ତିହିଙ୍ଗ୍‌ ଇଚାନ୍‌, ଆଦିକ୍‌ କୁକ୍ୟାତାର୍, “ମାତର୍‌ ଅଲପ୍‍ ବାଚିକିୟାତାକାର୍ ।” ");
INSERT INTO peg_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","କେତ୍‌ଜାଣ୍‌ ପାରୁସିର୍‌ ହାଲ୍‌ଜି ଜିସୁଙ୍ଗ୍‌ ପର୍‌ସନ୍‌ ୱେନ୍‌ବିସ୍‌ ହେୱାନିଂ ଡ଼ୁକାତ ରାତ୍‍ତେଂ ଇଞ୍ଜି ଉପାୟ୍‌ ପାଚି କିତାର୍ । ");
INSERT INTO peg_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","ହେୱାର୍‌ ନିଜାର୍‌ କେତେକ୍‌ ଜାଣ୍‌ ଚେଲାରିଂ ଆରି ହେରଦିୟା ଦଲ୍‌ନି କେତେକ୍‌ ଜାଣ୍‌ ମାନାୟ୍‌ତିଂ ଜିସୁ ଲାଗେ ପକ୍ତାର୍‌, ହେୱାର୍‌ ୱେନ୍‌ବାତାର୍‌ “ଏ ଗୁରୁ ଆପେଂ ପୁଚାପ୍‍ନ୍ନା, ଏନ୍‌ ସତ୍‌ କାତା ଇନାୟ୍‌ ଇସ୍ୱର୍‌ ହାତ୍‌ପା ବିସ୍ରେନି ହାଜ଼ି ସିକ୍ୟା ହିତାୟ୍‌ନା । ଆରେ ଇନେରିଂ ପାଣ୍ଡ୍ରା ଆଉୟ୍‌, ଇନାକିଦେଂକି ଏନ୍‌ ମାନାୟ୍‌ତିଂ ମୁକ୍‍ମେଟ୍‍ ହୁଡ଼ୁୟ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","ଲାଗିଂ ମାଙ୍ଗ୍‌ ୱେଚ୍‌ଚା, ନି ଇନାକା ଇନାକା ? କାଇସର୍‌ତିଂ ସିସ୍ତୁ ହିନାକା ବିଦି ମାନାତ୍‌ କି ଆକାୟ୍‌ ?” ");
INSERT INTO peg_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","ମାତର୍‌ ଜିସୁ ହେୱାର୍‌ତି କୁଟ୍‌ ପୁଞ୍ଜି ମାଚାନ୍‌ । ଲାଗିଂ ହେୱାନ୍‌ ଇଚାନ୍‌, “ଆଡ଼େ କାପ୍‌ଟିୟାର୍‌, ନାଙ୍ଗ୍‌ ଡ଼ୁକାତ ରାତ୍‍ତେଦେଂ ଇନେକିଦେଂ ସେସ୍ଟା କିନାଦେରା ? ");
INSERT INTO peg_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","ଇମ୍‌ଣି ଟାକାଂ ହିନାଦେରା, ହେବେଣ୍ଡାଂ ରଞ୍ଜୁ ତାସି ଚଚ୍‍ଚାଟ୍ । ହେୱାର୍‌ ରଞ୍ଜୁ ଅଦ୍‌ନି ତାସି ତାଙ୍ଗେଙ୍ଗ୍‌ ହିତାର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","ଜିସୁ ହେୱାରିଂ ୱେନ୍‌ବାତାନ୍‌, “ଇ ଅଦ୍‌ନି ଜପି ଇନେର୍‌ତି ତର୍‌ ଆରି ପୁତ୍‌ଡ଼ା ରଚ୍ୟା ଆତାତ୍‌ନ୍ନା ।” ");
INSERT INTO peg_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","ହେୱାର୍‌ ଉତର୍‌ ହିତାର୍‌, “କାଇସର୍‌ତି ।” ଜିସୁ ହେୱାରିଂ ଇଚାନ୍‌, “ତେବେ ଇମ୍‌ଣାକା ରମ୍‌ତି, ହେଦାଂ ରମ୍‌ତିଂ ହିୟାଟ୍‌, ଆରି ଇମ୍‌ଣାକା ଇସ୍ୱର୍ତି, ହେଦାଂ ଇସ୍ୱର୍‌ତିଂ ହିୟାଟ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","ଇଦାଂ ୱେନ୍‌ଞ୍ଜି ହେୱାର୍‌, କାବା ଆଜ଼ି ହାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","ହେ ଦିନ୍‌ ସାଦୁକି କୁଦାନି କେତେକ୍‌ ଜାଣ୍‌ ଜିସୁ ତାକେ ୱାତାର୍ । ସାଦୁକିର୍‌ ପାର୍ତି କିଜ଼ି ମାଚାର୍‌ ଜେ, ଆରେ ନିଂନାକା ଆକାୟ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","ହେୱାର୍‌ ଜିସୁଙ୍ଗ୍‌ ୱେନ୍‍ବାତାର୍, “ଗୁରୁ, ମସା ଇଞ୍ଚାନ୍ନା ଜେ, ଜଦି ରୱାନ୍‌ ମାନାୟ୍‌ ହିମ୍‍ଣାୱାକ୍‍ଡ଼ା ଆୱାଦାଂ ହାତିସ୍, ବାଟିଙ୍ଗ୍‌ ତା ଟଣ୍ଡେନ୍‌ ହେ ରାଣ୍ଡିଙ୍ଗ୍‌ ବିବା କିନାନ୍‌ ଆରି ହେୱାର୍‌ତି ହିମ୍‌ଣାଂ ହେ ହାତି ଲକୁତ ମାଜ଼ିର୍‌ ଇଞ୍ଜି ଇନ୍ୟା ଆନାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","ୱେନାଟ୍‌, ମା ବିତ୍ରେ ସାତ୍‌ ବାୟ୍‍ ଟଣ୍ଡାର୍‌ ମାଚାର୍‌, ଗାଜା ଟଣ୍ଡେନ୍‌ ବିବା କିଜ଼ି ହାତାନ୍‌, ହିମ୍‍ଣାୱାକ୍‍ଡ଼ା ହିଲ୍‌ୱିତିଲେ ଜାର୍‌ ଟଣ୍ଡେନ୍‌ କାଜିଂ ଜାର୍‌ କଗ୍‌ଲେଂ ପିସ୍ତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","ମାତର୍‌ ରିୟାର୍‌, ତିନ୍‌ ଜାଣ୍‌ ଆରି ହାରିହାରା ସାତ୍‌ ଟଣ୍ଡାର୍‌ ପା ହେ ଲାକେ ବିବା କିତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","ହାରିହାରା ହେ କଗ୍‌ଲେ ପା ହାତାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","ଇମ୍‌ଣି ଦିନ୍‌ ହାତି ମୁଣିକାର୍ ଆରେ ନିଂନାର୍‌, ଇ କଗ୍‌ଲେ ଇନେର୍‌ ଡକ୍ରି ଇଞ୍ଜି ଇନ୍ୟା ଆନାତ୍‌ ? ୱିଜ଼ାକାର୍‌ ତ ତାଙ୍ଗ୍‌ ବିବା କିଜ଼ି ମାଚାର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","ଜିସୁ ହେୱାରିଂ ଉତର୍‌ ହିତାନ୍‌, “ଏପେଙ୍ଗ୍‌ ବାୟା କାଦେର୍‌ । ସାସ୍ତର୍‌ କି ଇସ୍ୱର୍ତି ସାକ୍ତି ବିସ୍ରେ ମିଦାଙ୍ଗ୍‌ ଇଟ୍‌କାଡ଼୍‌ ହିଲ୍‍ୱି କାଜିଂ ଇ କାତା ପୁନ୍‌ୱା ତାଦେର୍ଣ୍ଣା । ");
INSERT INTO peg_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","ଆରେ ନିଂନିତ ପାଚେ ହାତି ଲକୁ ହେୱାର୍‌ ସାର୍ଗେନି ଦୁତ୍‌ ଲାକେ ଆନାର୍‌ । ହେୱାର୍‌ ବିବା ଆଉର୍‌ କି ବିବା କିଉର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","ହାତି ମୁଣିକାର୍ ଆରେ ନିଂନି ବିସ୍ରେ ଇସ୍ୱର୍‌ ସାସ୍ତର୍‌ ୱେଚ୍‌ଚାତାନ୍ନା, ଏପେଙ୍ଗ୍‌ ଇନାକା ବାଇବଲ୍‍ତ ଇନାୱାଡ଼ାଂ ପଡ଼ି କିୱାତାଦେର୍ଣ୍ଣା ?” ");
INSERT INTO peg_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","ଇସ୍ୱର୍‌ ଇଞ୍ଚାନ୍ନା, ଆସେଙ୍ଗ୍‌ ଅବ୍ରାହାମ୍‌, ଇସ୍‌ହାକ୍‌, ଆରି ଜାକୁବ୍‌ତି ଇସ୍ୱର୍‌ । ଇସ୍ୱର୍‌ ତ ଜିତାକାର୍ତି ଇସ୍ୱର୍‌ ହାତାକାର୍ତି ଆଦେଂ ଆଡୁନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","ଲକୁ ଜିସୁତି ହିକ୍ୟା ୱେନ୍‌ଞ୍ଜି କାବା ଆତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","ଏଚେକାଡ଼୍‌ଦ ପାରୁସିର୍‌ ୱେଚାର୍‌ ଜେ ଜିସୁ ସାଦୁକିରିଂ ଉତର୍‌ କିୟ୍‍କିୱାତାନ୍‍ଦେ, ହେୱାର୍‌ ରୁଣ୍ଡା ଆଜ଼ି ଜିସୁ ଲାଗେ ୱାତାର୍ ");
INSERT INTO peg_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","ଆରି ହେୱାର୍‌ ବିତ୍ରେ ରକାନ୍‌ ଦରମ୍‌ ସାସ୍ତର୍‌ ଜିସୁଙ୍ଗ୍‌ ଡ଼ୁକାତ ରାତ୍‍ତେଂ ଇଞ୍ଜି ର ପରସନ୍‌ କିତାନ୍‌, ");
INSERT INTO peg_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“ଏ ଗୁରୁ,” ମସାତି ବିଦିତ “ଇମ୍‌ଣି ବଲ୍‌ ୱିଜ଼େତିଂ ମୁଡ଼୍‍ଦାକା ।” ");
INSERT INTO peg_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","ଜିସୁ ହେୱାନିଂ ଇଚାନ୍‌, “ନି ମାପ୍ରୁ ଇସ୍ୱର୍‌ତିଂ ୱିଜ଼ୁ ୱାସ୍କି, ୱିଜ଼ୁ ପାରାଣ୍‌ ଆରି ୱିଜ଼ୁ ମାନ୍‌ ହିଜ଼ି ଜିଉନୱାଟ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","ଇଦାଂ ନେ ପର୍ତୁମ୍‌ ଆରି ମୁଡ଼୍‌ ବଲ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","“ରିଣ୍ଡାଙ୍ଗ୍‌ ମୁଡ଼୍‌ ବଲ୍‌ ଆନାତା, ମି ପାଡ଼୍‍ହା ଇଞ୍ଜାକାରିଂ ଜିବୁନ୍‌ ଲାକେ ଜିଉନୱାଟ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","ଇ ରିଣ୍ଡି ବଲ୍‌ ମସାତି ୱିଜ଼ୁ ବିଦି ଆରି ବେଣ୍‌ବାକ୍‌ଣାୟ୍‌କିନାକାର୍ତି ସିକ୍ୟାତ ବାର୍ସି କିନାତ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","ଏଚେକାଡ଼୍‌ଦ ପାରୁସିର୍‌ ରୁଣ୍ଡାଆତି ୱେଡ଼ାଲିଂ ଜିସୁ ହେୱାରିଂ ୱେନ୍‌ବାତାନ୍‌, ");
INSERT INTO peg_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“କ୍ରିସ୍ଟ ଇଚିସ୍‌ ମସିୟା ତା ବିସ୍ରେ ଏପେଙ୍ଗ୍‌ ଇନାକା ବାବି କିନାଦେରା ? ହେୱାନ୍‌ ଇନେର୍‌ କୁଟୁମ୍‌ ?” ହେୱାର୍‌ ଉତର୍‌ ହିତାର୍‌, “ହେୱାନ୍‌ ଦାଉଦ୍‌ତି ।” ");
INSERT INTO peg_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","ଜିସୁ ୱେନ୍‌ବାତାନ୍‌, “ତା ଆତିସ୍‌ ଦାଉଦ୍‌ ମସିୟାଙ୍ଗ୍‌ ନା ମାପ୍ରୁ” ଇଞ୍ଜି ଇନେକିଦେଂ ଲେକି କିତାନ୍‌ନ୍ନା ? ଇନାକିଦେଂକି ଜିବୁନ୍‌ ପକ୍ତିଲେ ହେୱାନ୍‌ ଲେକି କିତାନ୍‌ନ୍ନା, ");
INSERT INTO peg_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","“ମାପ୍ରୁ ନା ମାପ୍ରୁଙ୍ଗ୍‌ ଇଚାନ୍‌, ଆପେଂ ମି ସାତ୍ରୁରିଂ ମି ପାନା ତାରେନ୍‌ ଇଟ୍‍ୱି, ହେ ପାତେକ୍‌ ମା ବୁଜ୍‌ଣି ବାଗାଙ୍ଗ୍‌ କୁଚ୍‌ଚି ମାନା ।” ");
INSERT INTO peg_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","“ଲାଗିଂ ଦାଉଦ୍‌ ଜଦି ତାଙ୍ଗ୍‌ ମାପ୍ରୁ ଇଞ୍ଜି କିତାର୍‌, ବାଟିଙ୍ଗ୍‌ ମସିୟା ଇନେସ୍‌ ତା ମାଜ଼ି ଇଞ୍ଜି ଇନାନ୍‌ ?” ");
INSERT INTO peg_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","ହେବେ ଇନେର୍‌ ପା ହେୱାନିଂ ପାଦେକ୍‍ ଉତର୍‌ ହିଦେଂ ଆଡ୍‌ୱାତାର୍‌, ଆରେ ହେ ଦିନ୍‌ତାଂ ଇନେର୍‌ ଆରେ ହେୱାନିଂ ପର୍‌ସନ୍‌ ୱେନ୍‍ବେଦେଂ ସାସ୍‌ କିୱାତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","ହେୱେଡ଼ାଲିଂ ଜିସୁ ମାନାୟାରିଂ ଆରି ଚେଲାରିଂ ଇଚାନ୍‌, ");
INSERT INTO peg_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“ଦରମ୍‌ ଗୁରୁର୍‌ ଆରି ପାରୁସିର୍‌ ମସାତି ଗାଦିତ କୁଚ୍‌ଚାର୍ଣ୍ଣା । ");
INSERT INTO peg_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","ଲାଗିଂ ହେୱାର୍‌ ଇନାକା କିଦେଙ୍ଗ୍‌ ଇନାରା, ହେଦାଂ କିୟାଟ୍‌ । ମାତର୍‌ ହେୱାର୍‌ତି କାମାୟ୍‌ କାବାଡ଼୍‍ତାକେ ପାଚେ ହାଲ୍‌ମାଟ୍‌ । ଇନାକିଦେଂକି ହେୱାର୍‌ ନିଜେ ହିତି ହିକ୍ୟା ସମାନ୍‌ କାମାୟ୍‌ କିଉର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","ହେୱାର୍‌ ହିକ୍ୟା ସବୁ ଲକାର୍ତି ଗାଗାଡ଼୍‌ ଜପି ଜବର୍‌ ବଜ୍‌ ଲାଦିକିନାର୍, ମାତର୍‌ ହେୱିଜ଼ୁ ବଜ୍‌ ପିଣ୍ଡ୍‌ଦେଂ କାଜିଂ ଜାର୍‌ତିଂ ୱାଚ୍‍କା ହୁକେ ପା ଅଲପ୍‍ ହାଂ କିଉର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","ହେୱାର୍‌ ଲକାଂ ଚଚ୍‌ଚେଙ୍ଗ୍‌ ଇଞ୍ଜି ଜାର୍‌ ଜାର୍‌ତି ସବୁ କାମାୟ୍‌ କିବାନାର୍, ଇନାକିଦେଂକି ହେୱାର୍‌ ଜାର୍‌ ସାସ୍ତର୍‌ ବଚନ୍‌ ଲେକାଆତି ନିଦାଣ୍‌ତ ପତାତ ଡରି ଗାଚ୍ୟାତାର୍‌ନା ଆରି ହେୱାର୍‌ ହେନ୍ଦ୍ରା କେତେକ୍‌ ଲାମା କିତାର୍‌ ଆରି ଆଙ୍ଗିନି ଚେଲିଂ ଗାଜା କିତାର୍‌, ");
INSERT INTO peg_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","ଆରେ ବଜିତ ମୁଡ଼୍‌ ବାହା ଆରି କୁଟୁମ୍‌ ଇଞ୍ଜ ମୁଡ଼୍‍ ବାହାତ କୁଚ୍‌ଚେଂ ୱାର୍‌ୟା ଆନାର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","ଆରେ ଆଟ୍‌ ବାଜାର୍‌ତ ଜୱାର୍‌ ପାୟାଦେଂ ଆରି ମାନାୟ୍‌ତିଂ “ଏ ଗୁରୁ” ଇଞ୍ଜି ଇନ୍ୟା ଆଦେଂ ୱାର୍‌ୟା ଆନାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","ମାତର୍‌ ଏପେଙ୍ଗ୍‌ ଗୁରୁ ଇଞ୍ଜି କୁକ୍ୟାମାଟ୍, ଇନାକିଦେଂକି ମିୱାର୍ତି ରକାନ୍‌ ଗୁରୁ ଆରି ଏପେଙ୍ଗ୍‌ ୱିଜ଼ାକାଦେର୍‌ ଟଣ୍ଡାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","ଆରେ, ପୁର୍ତିତ ଇନେରିଂ ଏ ଆବା ଇନ୍‌ମାଟ୍‌, ଇନାକିଦେଂକି ମିୱାର୍ତି ରୱାନ୍‌ ଆବା, ହେୱାନ୍‌ ସାର୍ଗେତ ମାନାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","ଆରେ, ମାଲିକ୍‌ ଇଞ୍ଜି ପା ଇନେର୍‌ କୁକ୍‍ତେମେର୍, ଇନାକିଦେଂକି ରକାନ୍‌ ମତର୍‌ ମି ମାଲିକ୍‌ ଆନାନା କ୍ରିସ୍ଟ । ");
INSERT INTO peg_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","ମାତର୍‌ ମି ବିତ୍ରେ ଇମ୍‌ଣାକାନ୍‌ ଗାଜାକାନ୍‌, ହେୱାନ୍‌ ମି ହେବା କିନାକାନ୍‌ ଆନାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","ଇନେର୍‌ ଜାର୍‌ତିଂ ଉଚ୍‍ କିନାନ୍‌, ତାଙ୍ଗ୍‌ ନିଚ୍‍କିୟା ଆନାତ୍‌ ଆରି ଇନେର୍‌ ଜାର୍‌ତିଂ ନିଚ୍‍ କିନାନ୍‌, ହେୱାନିଂ ଉଚ୍‍ କିୟା ଆନାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“ହାୟ୍‌, ଦରମ୍‌ ଗୁରୁର୍‌ ଆରେ ପାରୁସିକାଦେର୍‌, ମି ସେସ୍‌ ଦସା ଏଚେକ୍‌ ବଇଁକାର୍‌ ! ଆଡ଼େ କାପ୍‌ଟିୟାର୍‌ ଦାର୍ମି କୁଦା, ସାର୍ଗେ ରାଜିନି ହଣି ଦୁୱେର୍‌ ଗେସ୍‌ତି ଇଡ଼୍‌ତାଦେର୍ଣ୍ଣା । ନିଜେ ହେବେ ହଣୁଦେରା ଆରି ଇମ୍‌ଣାକାର୍‌ ହଣ୍ଡେଙ୍ଗ୍‌ ସେସ୍ଟା କିନାରା, ହେୱାରିଂ ହାଜ଼ି ପିସ୍ତି ହିଉଦେରା । ");
INSERT INTO peg_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","ଏ କାପ୍‌ଟିୟାର୍‌ ଦରମ୍‌ ଗୁରୁର୍‌ ଆରି ପାରୁସିର୍‌, ମି ଦସା ବେସି ଆବ୍‌ଡ଼ୁ ଆନାତ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","ଏ କାପ୍‌ଟିୟାର୍‌ ଆରେ “ସାସ୍ତିର୍‌ ଆରି ପାରୁସିର୍‌, ଦସା ବେସି ଆବ୍‌ଡ଼ୁ । ଏପେଙ୍ଗ୍‌ ହାମ୍‌ଦୁର୍‌ ନାସି ଦେସ୍‌ତ ହାଲ୍‌ଜି ରକାନିଂ ମି ଦରମ୍‌ତ ମୁଚ୍‍ଚେଂ କାଜିଂ ଡେକ୍‌ଚି ବୁଲାନାଦେରା । ମାତର୍‌ ହେ ଲାକେ ରୱାନିଂ ଗାଟା ଆତିସ୍‌, ତାଙ୍ଗ୍‌ ନରକ୍‌ ହାନି କାଜିଂ ମିତାଂ ରି ଗୁଣ୍‌ ଆଦିକ୍‌ କିୟ୍‍କିତାଦେର୍ଣ୍ଣା !” ");
INSERT INTO peg_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“ଆଡ଼େ କାଣା ହାଜ଼ି ଚଚ୍‍ନାକାଦେର୍, ମି ଦସା ଏଚେକ୍‌ କସ୍ଟମାନାତ୍ । ଏପେଙ୍ଗ୍‌ ସିକ୍ୟା ହିଜ଼ି ମାନାଦେର୍‌, ଇନେର୍‌ ମନ୍ଦିର୍‌ ତର୍‌ଦ ପାର୍ମାଣ୍‌ କିତିସ୍‌, ହେଦାଂ ହେୱାନ୍‌ ମାନିକିଦେଂ ବଲତ୍କାର୍ ଆକାୟ୍‌, ମାତର୍‌ ମନ୍ଦିର୍‌ତ ମାନି ହନା ତର୍‌ଦ ଇନେର୍‌ ପାର୍ମାଣ୍‌ କିତାର୍‌, ହେୱାନିଂ ହେଦାଂ ମାନିକିଦେଂ ପଡ଼ାନାତ୍ । ");
INSERT INTO peg_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","ଡ଼େ କାଣା ନିର୍‍ବୁଦିୟାର୍‌, ହନା ଗାଜା କି ହନାତିଂ ପୁଇପୁୟା କିଜ଼ି ମାନି ମନ୍ଦିର୍‌ ଗାଜା ?” ");
INSERT INTO peg_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","ଆରେ ଏପେଙ୍ଗ୍‌ ଇଞ୍ଜିମାନାଦେର୍, ଇନେର୍‌ ଗାର୍‌ଣିତ ପାର୍ମାଣ୍‌ କିତିସ୍‌ ହେଦାଂ ଇନାକା ଆକାୟ୍‌, ମତର୍‌ ଇମ୍‌ଣାକାର୍‌ ତା ଜପି ମାନି ଆକାତ୍‌ ପାର୍ମାଣ୍‌ କିନାନ୍‌, ହେୱାନ୍‌ ତାକେ ମାନାଦେରା । ");
INSERT INTO peg_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","ଡ଼େ କାଣାର୍‌, ଇମ୍‌ଣାକା ମୁଡ଼୍‍ଦାକା-ଗାର୍‌ଣି କି ଆକାତ୍‍ତିଂ ପୁଇପୁୟା କିଜ଼ି ମାନି ଗାର୍‍ଣି ? ");
INSERT INTO peg_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","ଲାଗିଂ, ଇନେର୍‌ ଗାର୍‌ଣି ତର୍‌ଦ ପାର୍ମାଣ୍‌ କିନାନ୍‌, ହେୱାନ୍‌ ଗାର୍‍ଣି ଆରି ତା ଜପି ମାନି ୱିଜ଼ୁ ଆକାତ୍‌ ଆଡ଼୍‍ମାଡ଼୍‍ଦିଂ ତର୍‌ଦ ପାର୍ମାଣ୍‌ କିନାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","ଆରେ, ଇନେର୍‌ ମନ୍ଦିର୍‌ ତର୍‌ଦ ପାର୍ମାଣ୍‌ କିନାନ୍‌, ହେୱାନ୍‌ ମନ୍ଦିର୍‌ ଆରି ହେବେ ବାହାକିତିକାଂ ଇସ୍ୱର୍‌ ତର୍‌ଦାଂ ପାର୍ମାଣ୍‌ କିନାନ୍‌; ");
INSERT INTO peg_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","ଆରେ, “ଇନେର୍‌ ସାର୍ଗେତିଂ ପାର୍ମାଣ୍‌ କିନାନ୍‌, ହେୱାନ୍‌ ଇସ୍ୱର୍ତି ଗାଦି ହେବେ କୁଚ୍‌ଚି ମାଚି ଇସ୍ୱର୍‌ ତର୍‌ଦାଂ ପାର୍ମାଣ୍‌ କିନାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“ଡ଼େ କାପ୍‌ଟିୟାର୍‌ ଦରମ୍‌ ଗୁରୁର୍‌ ଆରି ପାରୁସିର୍‌ ଇନାକିଦେଂକି ଏପେଙ୍ଗ୍‌ ପଦିନା, ସଁପ୍, ଆରି ଜିରାତିଂ ଦସ୍‍ବାଗ୍ ର ବାଗ୍‌ ଇସ୍ୱର୍‌ତିଂ ଦାନ୍‌ ହିନାଦେରା । ଆରେ ବିଦିନି ଆଗେ ବିସ୍ରେକାଂ ହୁଡ଼୍‌ୱାଙ୍ଗ୍‌ ଆତିସ୍‌ପା ଅବ୍ୟାସ୍‌ କିନାକା ଲଡ଼ା, ନ୍ୟାୟ୍‌ ବିଚାର୍‌, ଦୟା, ଆରେ ପାର୍ତିତିଂ ଇ ସବୁ ପିସ୍ତାର୍ଣ୍ଣା; ମାତର୍‌ ଇ ୱିଜ଼ୁ ମାନି କିନାକା ଆରି ବିନ୍‌ ସବୁ ପିହ୍‍ନାକା ମାନାତ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","“ଡ଼େ କାଣା ହାଜ଼ି ଚଚ୍‍ନାକାଦେର୍, ଏପେଙ୍ଗ୍‌ ପ୍ରାଚ୍‌ତିଂ ପୁଚାଦେର୍ଣ୍ଣା, ମାତର୍‌ ଉଟ୍‌ତିଂ ଗୁସ୍‍ସି ମାନାଦେର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“ଏ କାପ୍‌ଟିୟାର୍‌ ଦରମ୍‌ ଗୁରୁର୍‌ କେତେକ୍‌ ବଇଁକାର୍‌ ମି ସେସ୍‌ ହାଜ଼ି, ଡ଼େ ଦରମ୍‌ ଗୁରୁ ଆରି ପାରୁସିର୍‌ । ଏପେଙ୍ଗ୍‌ ଗିନା ଆରି ତାଡ଼ିଆନି ବାର୍‌ ବାଗାଙ୍ଗ୍‌ ସକଟ୍‌ କିଜ଼ି ମାନାଦେର୍‌, ମାତର୍‌ ହେୱାକାଂ ବିତ୍ରେ ଆକର୍‌ ଆରି ଦାରିକାମ୍‍ତ ବାର୍ତି ।” ");
INSERT INTO peg_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","“କାଣା ପାରୁସିର୍‌ ! ଆଗେ ଗିନାନି ବିତ୍ରେ ସକଟ୍‌ କିୟାଟ୍‌, ଇନେସ୍‌ ହେବେନିକା ବାର୍ତ ପା ନିର୍ମଲ୍‌ ଆନାତ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“ହାୟ୍‌, ଦରମ୍‌ ଗୁରୁର୍‌ କାପ୍‌ଟିୟାର୍‌ ସାସ୍ତିର୍‌ ଆରି ପାରୁସିର୍‌, ଇନେକିଦେଂକି ଏପେଙ୍ଗ୍‌ ଡ଼ିଞ୍ଜିନି ରଙ୍ଗ୍‌ନି ଦୁଗେର୍‌ ଲାକେ । ହେଦାଂ ବାର୍ତ ହଲ୍‌ନାକା ଚଞ୍ଚାନାତ୍‌, ମାତର୍‌ ବିତ୍ରେ ହାତାକାର୍‌ତି ମେର୍ଗାଣା ପ୍ଡେକୁ ଆରି ସବୁ ବାନି ବିଟାଡ଼୍‌ତ ବାର୍ତି; ");
INSERT INTO peg_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","ହେ ଲାକେ ଏପେଙ୍ଗ୍‌ ପା ବାର୍ତ ମାନାୟାର୍‌ କାଣ୍‌କୁକାଂ ଦାର୍ମି ଚନ୍‍ଞ୍ଜାନାଦେର୍, ମାତର୍‌ ମି ବିତ୍ରେ କୁଟ୍‌ ଆରି ପାପ୍‌ତ ବାର୍ତି ।” ");
INSERT INTO peg_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“ଏ କାପ୍‌ଟିୟାର୍‌ ଦରମ୍‌ ଗୁରୁ ଆରି ପାରୁସିର୍‌ ମି ଦସା କେତେକ୍‌ ବଇଁକାର୍‌ ଆନାତ୍‌ ! ଇନାକିଦେଂକି ଏପେଙ୍ଗ୍‌ ବେଣ୍‌ବାକ୍‌ଣାୟ୍‌ କିନାକାର୍‌ତି ଦୁଗେର୍‌ ହଲ୍‌ନାକା ରଚ୍‌ଚି ଆରି ଦାର୍ମିର୍ତି ଦୁଗେର୍‍କାମ୍ ହଲିକିଜ଼ି ମାନାଦେର୍‌, ");
INSERT INTO peg_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","ଆସେଙ୍ଗ୍‌ ଏଚେକାଡ଼୍‌ଦ ମା ଆବା ଲାତ୍ରା ସମୁତ ମାଚିସ୍‌, ତେବେ ବେଣ୍‌ବାକ୍‌ଣାୟ୍‌ କିନାକାର୍‌ତାଂ ନେତେର୍‌ତ ହେୱାର୍‌ତି ମେହାଣ୍‌ ଆମାଟ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","ଲାଗିଂ ଏପେଙ୍ଗ୍‌ ଜେ ବେଣ୍‌ବାକ୍‌ଣାୟ୍‌ କିନାକାର୍‌ ପାଗ୍‍ନାକାର୍ ଲାତ୍ରାକାଦେର୍‌, ହେ ବିସ୍ରେ ଏପେଙ୍ଗ୍‌ ଆଁ ଜାର୍‌ ଜାର୍‌ କାଜିଂ ସାକି ହିନାଦେରା ।” ");
INSERT INTO peg_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","“ବାଟିଙ୍ଗ୍‌ ଏପେଙ୍ଗ୍‌ ଆଗେ ତାଙ୍ଗାଟ୍‌, ମି ଆବାଲାତ୍ରାତି ବାକି କାମାୟ୍‍ତିଂ ପୁରା କିୟାଟ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“ଡ଼େ ରାଚ୍‌କୁ ! କାଲାଟିରାଚ୍‌ନି ବସ୍‌ୟାର୍‌ ! ନରକ୍‌ ଡାଣ୍ଡ୍‌ତାଂ ରାକ୍ୟା ପାୟା ଆନାପ୍‌ ଇଞ୍ଜି ଇନେସ୍‌ ଆହା କିନାଦେରା ? ");
INSERT INTO peg_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","ଲାଗିଂ ଆନ୍‌ ଇଞ୍ଜ୍‌ନାଙ୍ଗା; ମି ତାକେ ବେଣ୍‌ବାକ୍‌ଣାୟ୍‌କିନାକାର୍‌, ହିକାୟ୍‍କିନି ଗୁରୁ ଆରି ଗିଆନିରିଂ ପକ୍ତାନାଂ । ହେୱାର୍‌ ବିତ୍ରେ କେତେଜାଣ୍‌ତିଂ ଏପେଙ୍ଗ୍‌ ଟୁଣାଦେର୍, କେତେକ୍‌ ଜାଣ୍‍ତିଂ କ୍ରୁସ୍‌ତ ଦୁପ୍‍ନାଦେର୍, ଆରି ବିନ୍‍ଲୁଗାଂ କୁଟୁମ୍‌ ଇଞ୍ଜ କର୍‌ଡା ହୁକେ ଇଡ଼୍‌ଜି ର ଗାଡ଼୍‌ଦାଂ ଆରେ ର ଗାଡ଼୍‌ଦ ପେସ୍‌ନାଦେର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","ଇନେସ୍‌କି ଦର୍ମି ହେବଲ୍‌ତାଂ ନେତେର୍‌ତାଂ, ଇମ୍‌ଣି ବେରିକିୟତି ମେହି ଜିକରିୟ ଏପେଙ୍ଗ୍‌ ମନ୍ଦିର୍‌ନି ପୁଇପୁୟା ବାହାତ ଆରି ଗାର୍‌ଣି ମାଦ୍‍ନି ବାହାତ ଅସ୍ତାଦେର୍, ତା ଅସ୍ତି ପାତେକ୍‌ ପୁର୍ତିତ ଜେତେକ୍‌ ଦାର୍ମି ଲଗାରିଂ ଅସ୍ତାର୍ଣ୍ଣା, ହେ ୱିଜ଼ାକାର୍‍ତି ହାନି ଦାଣ୍ଡ୍‌ ମି ଜପି ଆର୍ଦାନାତ୍ । ");
INSERT INTO peg_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","ଆନ୍‌ ମିଙ୍ଗ୍‌ ହାତ୍‌ପା ଇଞ୍ଜ୍‌ନାଙ୍ଗା, ଇ ୱିଜ଼ାର୍‌ ମାନାୟାରିଂ ଅସ୍ତିଲେ ନଂନି ମାନାୟ୍‌ ଜପି ଇ ସବୁ ପଡ଼ାନାତ୍ ।” ");
INSERT INTO peg_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“ଏ ଜିରୁସାଲମ୍‌, ଏ ଜିରୁସାଲମ୍‌ । ଏନ୍‌ ବେଣ୍‌ବାକ୍‌ଣାୟ୍‌କିନାକାରିଂ ଟୁଟାୟ୍‍ନା ଆରି ଇସ୍ୱର୍‌ ପକ୍ତି କାବୁର୍‌ ହିନାକାରିଂ କାଲ୍‌କୁ ଇଡ଼୍‌ନାର୍‌ । କୁଜ଼ୁ ତା ମାରା ତାରେନ୍‌ ହିମ୍‌ଣାକାଂ ଆସ୍ତି ଇଡ୍‌ତି ଲାକେ, ନି ଲକ୍‌ତିଂ ନା କାକା ତାରେନ୍‌ ରାକ୍ୟାକିଦେଂ କାଜିଂ ଆନ୍‌ କେତେହଟ୍ ସେସ୍ଟା କିତାଂନ୍ନା । ମାତର୍‌ ଏନ୍‌ନାଙ୍ଗ୍‌ ହେଦାଂ କିଦେଙ୍ଗ୍‌ ହିଦ୍‍ୱାତାୟ୍‍ନା । ");
INSERT INTO peg_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","ହୁଡ଼ା, ମି ମନ୍ଦିର୍‌ ମି କେଇଦ ପିସ୍ତି ହିଦ୍ୟାଆନାତା । ");
INSERT INTO peg_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ହାତ୍‌ପା ଇଞ୍ଜି ଇଟ୍‌ନାଙ୍ଗା, ‘ମାପ୍ରୁ ତର୍‌ଦ ଇନେର୍‌ ୱାନାରା, ହେୱାନ୍‌ ଦନ୍ୟ’ ଇଦାଂ ଏଚେକାଡ଼୍‌ଦ ପାତେକ୍‌ ଇନ୍‌ୱାତାଂନ୍ନା, ନଙ୍ଗ୍‌ ତାଙ୍ଗ୍‌ ଏନ୍‌ନାଙ୍ଗ୍‌ ଆରେ ହୁଡ଼୍‌ଦେଂ ଆଡୁୟ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","ଜିସୁ ମନ୍ଦିର୍‍ତାଂ ହସି ହାନି ୱେଡ଼ାଲିଂ ହେୱାନ୍ତି ଚେଲାର୍‌ ହେୱାନିଂ ମନ୍ଦିର୍‌ନି ଇଲ୍‌କୁ ଚଚ୍‌ଚେଙ୍ଗ୍‌ କାଜିଂ ହେୱାନ୍‌ ଲାଗେ ୱାତାର୍, ");
INSERT INTO peg_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","ମାତର୍‌ ହେୱାନ୍‌ ହେୱାରିଂ ଉତର୍‌ ହିତାନ୍‌, “ଏପେଙ୍ଗ୍‌ ଇନାକା ଇ ୱିଜ଼ୁ ହୁଡ଼ୁଦେରା ? ଆନ୍‌ ମିଙ୍ଗ୍‌ ହାତ୍‌ପା ଇଞ୍ଜ୍‌ନାଙ୍ଗା, ଇ ବାହାତ ର କାଲ୍‌ ବିନ୍‌ କାଲ୍‌ ଜପି ମାନୁତ୍, ୱିଜ଼ୁ ଦୁଡ଼ି ମାସ୍‍ନାତ୍ ।” ");
INSERT INTO peg_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","ପାଚେ ହେୱାନ୍‌ ଜିତ୍‌ମାଡ଼ି ଜପି କୁଚ୍‌ଚାନ୍‌, ଚେଲାର୍‌ ହେୱାନ୍‌ ଲାଗେ ଡ଼ୁଗ୍‌ଜି ୱାଜ଼ି ୱେନ୍‍ବାତାର୍, “ଇ ସବୁ ଇନାୱାଡ଼ାଂ ଗିଟା ଆନାତ୍‌, ଆରେ ନି ୱାନାକା ଆରି ଜୁଗ୍‌ସେସ୍‌ନି ଇଟ୍‌କାଡ଼୍‌ ଇନାକା, ହେଦାଂ ମାଂ ୱେଚ୍‌ଚା ।” ");
INSERT INTO peg_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","ହେବେ ଜିସୁ ହେୱାରିଂ ଉତର୍‌ ହିତାନ୍‌, “ଜାଗ୍ରତ୍‌, ଇନେର୍‌କି ଇନେସ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ଚାକ୍ରାୟ୍‌ କିଦ୍‍ମେର୍ ।” ");
INSERT INTO peg_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","ଇନାକିଦେଂକି ବେସିହେନି ନା ତର୍‌ଦ ୱାଜ଼ି “ଆନ୍‌ କ୍ରିସ୍ଟ ଇଚିସ୍‌ ମସିୟା ଇଞ୍ଜି ଇଞ୍ଜି ଆଦେକ୍‌ତିଂ ଚାକ୍ରାୟ୍‌ କିଦ୍‌ନାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","ଆରେ, ଏପେଙ୍ଗ୍‌ ଜୁଜ୍‌ ବିସ୍ରେ ଆରି ଜୁଜ୍‍ନି ମାନାୟ୍‌ ଆଲି ୱେନାଦେର୍; ଜାଗ୍ରତ୍‌, ବାଇକାବିତାଡ଼୍‍ ଆମାଟ୍‌ । ଇନାକିଦେଂକି ଇ ୱିଜ଼ୁ ଗିଟାନାତ୍, ମାତର୍‌ ହେ ସମୁ ୱିଜ଼୍‌ନାକା ଆକାୟ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","ଇନାକିଦେଂକି ଜାତି ବିରୁଦ୍‌ତ ଜାତି ଆରି ରାଜି ବିରୁଦ୍‌ତ ରାଜି ନିଂଗ୍‍ନାତ୍‍, ଆରେ ସବୁ ବାହାତ କାତାର୍‌ ଆରି ମେଦ୍‌ନିଦାଲ୍‌କାତାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","ମାତର୍‌ ଇ ୱିଜ଼ୁ କଗ୍‌ଲେ ହିମ୍‌ଣାଗାଟାନି କସ୍ଟ ଏକାୱାନାତ୍‌ ଦୁକ୍‌ ଆରମ୍‌ ମତର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“ହେ ୱେଡ଼ାଲିଂ ଲକୁ ମିଙ୍ଗେଙ୍ଗ୍‌ ଦୁକ୍‍ବଗି କିଦେଙ୍ଗ୍‌ କାଜିଂ ହେଲାୟ୍‌ କିଦ୍‌ନାର୍‌ ଆରି ମିଙ୍ଗ୍‌ ଅସ୍ତାନାର୍‌, ଆରେ ନା ତର୍‌ ପାର୍ତି କିନି କାଜିଂ ଏପେଙ୍ଗ୍‌ ୱିଜ଼ୁ ଜାତିତାଂ ଗିଣ୍‌ କିୟାନାଦେର୍ । ");
INSERT INTO peg_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","ହେୱାଡ଼ାଂ ବେସି ହେୱାର୍‌ତି ପାର୍ତି ଆରାୟ୍‌ କିତାର୍‌, ଆରେ ରକାନ୍‌ ଆରେ ରକାନିଂ ଆହିକିନାନ୍‌ ଆରି ରକାନ୍‌ ଆରେ ରକାନିଂ ଗିଣ୍‌ କିନାନ୍‌, ");
INSERT INTO peg_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","ଆରେ ବେସି ଚାକ୍ରାୟ୍‌ ବେଣ୍‌ବାକ୍‌ଣାୟ୍‌କିନାକାର୍‌ ୱାଜ଼ି ବେସିହେନିତିଂ ଚାକ୍ରାୟ୍‌ କିନାର୍‌, ");
INSERT INTO peg_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","ଆରେ ବାନ୍ୟା ବାଡାନି କାଜିଂ ଆଦେକ୍‌ ମାନାୟାର୍‌ତି ଜିଉନନାକା କାଜିଂ ହିତ୍‍ଡ଼ି ଆନାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","ମତର୍‌ ଇନେର୍‌ ସେସ୍‌ ପାତେକ୍‌ ସାସ୍‌ ଆଜ଼ି ମାନାର୍‌, ହେୱାନ୍‌ ମୁକ୍ତି ଆନାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","ଆରେ, ସବୁ ଜାତି ଲାଗାଂ ସାକି ହିଦେଂ କାଜିଂ ରାଜିନି ଇ ନେକ୍ରିକାବୁର୍‌ ସବୁ ପୁର୍ତିତ ସୁଣାୟ୍‌ କିୟାଆନାତ୍‌, ତା ପାଚେ ଜୁଗ୍‌ ୱିଜ଼୍‌ନାତ୍ ।” ");
INSERT INTO peg_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","ଲାଗିଂ ଏପେଙ୍ଗ୍‌ ଏଚେକାଡ଼୍‌ଦ “ଦାନିଏଲ୍‌ ବେଣ୍‌ବାକ୍‌ଣାୟ୍‌କିନାକାନ୍‌ କାଜିଂ ଲେକାତି ନାସ୍‌ କିନି ଗିଣ୍‌ ଜିନିସ୍‌ତିଂ ମନ୍ଦିର୍‌ ପୁଇପୁୟା ବାହାତ ମାନାକା ହୁଡ଼୍‌ନାଦେର୍‌, ପଡ଼ିକିନାକାଦେର୍‌ ବୁଜାଆଡୁ,” ");
INSERT INTO peg_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","“ହେ ଏଚେକାଡ଼୍‌ଦ ଇମ୍‌ଣାକାର୍‌ ଜିହୁଦା ରାଜି ମାନ୍‌ଗାନାର୍‌, ହେୱାର୍‌ ମାଡ଼ିତ ହନ୍‌ଚି ହାଲେର୍; ");
INSERT INTO peg_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","ଇନେର୍‌ ଜେଗନ୍‌ ଜପି ମାନାନ୍‌, ହେୱାନ୍‌ ଇଲ୍‌ ବିତ୍ରେ ଆଡ଼୍‌ମାଡ଼୍‌ ଅଦେଂ କାଜିଂ ଜୁଜ଼ି ୱାମେନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","ଆରେ, ଇନେର୍‌ ବୁମିତ ମାନ୍‌ଗାନାର୍‌, ହେୱାନ୍‌ ଜାର୍‌ ହେନ୍ଦ୍ରା ତାକେଦେଂ ଉଲ୍‌ଟି ହାଲ୍‍ମେନ୍ । ");
INSERT INTO peg_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","ହେୱେଡ଼ାଲିଂ ଇମ୍‌ଣାକାର୍‌ ଏସ୍‌ ପିସ୍ତାକାଦେଲ୍‍ କଗ୍‌ଲେ ଆରି ମାୟ୍‍ଉଟ୍‍ନି ଆୟା, ଆ, ହେୱେକ୍‌ ଦୁକ୍‌ନିକିକ୍‌, ");
INSERT INTO peg_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","ମାତର୍‌ ମିଦାଙ୍ଗ୍‌ ହନ୍‍ନାକା ଇନେସ୍‌ ପିନି ମାସ୍‍ତ କି ଜମ୍‌ନିବାର୍‌ ନାଜିଂ ଆମେତ୍‌, ଇଦାଂ କାଜିଂ ପାର୍ତାନା କିୟାଟ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","ଇନାକିଦେଂକି ହେୱେଡ଼ାଂ ଏପେଙ୍ଗ୍‌ ବେଜେକ୍‌ ଦୁକ୍‌ ଗିଟାନାତ୍ ଜେ, ପୁର୍ତିନି ଆରମ୍‌ତାଂ ନେଞ୍ଜେଙ୍ଗ୍‌ ପାତେକ୍‌ ଗିଟାୱାତାତ୍‍ନ୍ନା, ଆରେ ଇନାୱାଡ଼ାଂ ପା ଗିଟାଆଦୁତ୍ । ");
INSERT INTO peg_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","ଆରେ, ହେ ସମୁ ବାଟିଙ୍ଗ୍‌ ଉଣା କିୱାଦାଂ ମାଚିସ୍‌, ତେବେ ଇମ୍‌ଣାକା ପା ପାତାଡ଼୍‌ ମୁକ୍ତି ଆୱାତାତ୍ମା, ମତର୍‌ ବାଚିକିତି ଲକୁ କାଜିଂ ହେ ସମୁ ଉଣା କିୟା ଆନାତ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“ହେ ଏଚେକାଡ଼୍‌ଦ ହୁଡ଼ାଟ୍‌, କ୍ରିସ୍ଟ ଇବେ କି ହେବେ ଇନେର୍‌ ଏଚେକାଡ଼୍‌ଦ ମିଙ୍ଗ୍‌ ଏଲେଙ୍ଗ୍‌ ଇଞ୍ଜ୍‌ନାର୍‌, ତେବେ ହେଦାଂ ପାର୍ତି କିମାଟ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","ଇନାକିଦେଂକି ଚାକ୍ରାୟ୍‌ କ୍ରିସ୍ଟର୍‌ ଆରି ଚାକ୍ରାୟ୍‌ ବେଣ୍‌ବାକ୍‌ଣାୟ୍‌ କିନାକାର୍‌ ନିଙ୍ଗ୍‌ଜି ଏପେଙ୍ଗ୍‌ ଗାଜା ଗାଜା ଚିନ୍‌ ଆରି କାବାନି କାମାୟ୍‌ ଚଚ୍‍ଚାନାର୍ ଜେ, ଜଦି ଆଡ୍‌ନାର୍‌, ତେବେ ବାଚିକିତି ଲଗାଂ ପା ବାମ୍‌ଣ୍ଡାୟ୍‌ କିତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","ହୁଡ଼ାଟ୍‌, ଆନ୍‌ ଆଗେତାଂ ମିଙ୍ଗେଙ୍ଗ୍‌ ୱେଚ୍‍ଚାନାଙ୍ଗା ।” ");
INSERT INTO peg_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","ଲାଗିଂ, “ହୁଡ଼ାଟ୍‌, ହେୱାନ୍‌ ବାଟାତ ମାନାନ୍‌” ଲକୁ ଜଦି ମିଙ୍ଗ୍‌ ଇ କାତା ଇଞ୍ଜ୍‌ନାର୍‌, ତେବେ ହସି ହାଲ୍‌ମାଟ୍‌, “ହୁଡ଼ାଟ୍‌, ହେୱାନ୍‌ ବିତ୍ରେ ବାକ୍ରାତ ଡ଼ୁକ୍‌ତାନ୍‌ନା ମାନାୟ୍‌ ଜଦି ଇଦାଂ ଇଞ୍ଜ୍‌ନାର୍‌, ତେବେ ହେଦାଂ ପାର୍ତି କିମାଟ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","ଇନାକିଦେଂକି ବିଜ୍‌ଲି ଇନେସ୍‌ ୱେଡ଼ାହନିତାଂ ଇଡ଼୍‌ଜି ୱେଡ଼ାହାନି ପାତେକ୍‌ ବାଦାଡ଼୍‌ ଅଜଡ଼୍‌ ଆନାତ୍‌, ହେ ଲାକେ ମାନାୟ୍‌ ମାଜ଼ିତି ୱାନାକା ହେ ଲାକେ ଆନାତ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","ଇମେତାକେ ମଡ଼୍‍ ମାଚିସ୍‌, ହେବେ ରାମାଣିଙ୍ଗ୍‌ ରୁଣ୍ଡା ଆନିକ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","ମତର୍‌ ହେ ସମୁନି ଦୁକ୍‌ ପାଚେ ହାଚାଟ୍ରେ ମାଜ୍‌ଗା ଆନାତ୍‌ ଆରି ଲେଞ୍ଜ୍ ଅଜଡ଼୍‌ ହିଉତ୍, ଆରେ ହୁକାଂ ଆକାସ୍‌ତାଂ ଆର୍‍ନିଂ ଆରି ଆକାସ୍‌ନି ସାକ୍ତି ସବୁ ଦାଲ୍‍କାନାତ୍ । ");
INSERT INTO peg_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","ହେ ଏଚେକାଡ଼୍‌ଦ ଆକାସ୍‌ତ ମାନାୟ୍‍ ମାଜ଼ିତି ଇଟ୍‌କାଡ଼୍‌ ଚନ୍‌ଞ୍ଜାନାତ୍‌, ଆରେ ହେୱେଡ଼ାଲିଂ ପୁର୍ତିତ ୱିଜ଼ୁ ଜାତିନି ମାନାୟାର୍‌ ଆଡ଼୍‌ବାନାର୍‌ ଆରି ମାନାୟ୍‍ ମାଜ଼ିଂ ଗାଜା ସାକ୍ତିତାଂ ଆରି ଗାଜା ପାଣ୍‌ ହୁକେ ବାଦାଡ଼୍‍ତ ୱାନାକା ହୁଡ଼୍‌ନାଦେର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","ଆରେ, ହେୱାନ୍‌ ଗାଜା ମରି ବାଜା ହୁକେ ଜାର୍‌ ଦୁତ୍‌ରିଂ ପକ୍‌ତାନ୍‌ ଆରି ହେୱାର୍‌ ଆକାସ୍‌ନି ର ହାନ୍ଦିତାଂ ବିନ୍‌ ହାନ୍ଦି ପାତେକ୍‌ ଚାରି ଦିଗ୍‌ତାଂ ଇସ୍ୱର୍ତି ବାଚିକିତି ଲଗାଂ ରୁଣ୍ଡାୟ୍‌ କିନାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","ତଗା ମାର୍‌ନି ଉତର୍‌ମୁଡ଼୍‌ ହିକ୍ୟା କିୟାଟ୍‌, ଏଚେକାଡ଼୍‌ଦ ହେ କେନ୍ଦାଂ ହାରା ଆଜ଼ି ଆକିଂ ଗିଲ୍‌ନିଂ, ହେ ଏଚେକାଡ଼୍‌ଦ ଜେଟ୍‌ ମାସ୍‍ ଏକା ୱାତାତେ ଇଞ୍ଜି ଏପେଙ୍ଗ୍‌ ପୁଞ୍ଜି ମାନାଟ୍‌; ");
INSERT INTO peg_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","ହେ ଲାକେ ଏପେଙ୍ଗ୍‌ ପା ଇ ୱିଜ଼ୁ ହୁଡ଼୍‌ତିସ୍‌ ମାନାୟ୍‌ ମାଜ଼ି ଦୁୱେର୍‌ତ ଏକାୱାତାନେ ଇଞ୍ଜି ଇଦାଂ ପୁନାଟ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ହାତ୍‌ପା ଇଞ୍ଜ୍‌ନାଙ୍ଗା, ଇ ୱିଜ଼ୁ ଗିଟାୱି ପାତେକ୍‌ ନେଞ୍ଜେୱିଗାନି ନାର୍‌ ଇନେସ୍‌ ବାର୍ତି ବୁଡା ଆଉର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","ଆକାସ୍‌ ଆରି ପୁର୍ତି ବୁଡାନାତ୍, ମତର୍‌ ନା ବଚନ୍‌ ସବୁ ମଡ଼୍‍କେ ବୁଡା ଆଉତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","ମାତର୍‌ ଇନାୱାଡ଼ାଂ ୱାନାନ୍‌ “ହେ ଦିନ୍‌ ଆରି ସମୁ ବିସ୍ରେ ଇନେର୍‌ ପୁନୁର୍‌, ସାର୍ଗେନି ଦୁତ୍‌ତର୍‌ କି ମାଜ଼ି ପା ପୁନୁନ୍, କେବଲ୍‌ ମତର୍‌ ବାୱା ପୁନାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","ଆରେ, ନହତି ସମୁତ ଇନେସ୍‌ ଗିଟା ଆଜ଼ି ମାଚାତ୍‌, ମାନାୟ୍‌ ମାଜ଼ି ୱାନି ସମୁତ ହେ ଲାକେ ଗିଟାଆନାତ୍ । ");
INSERT INTO peg_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","ଇନାକିଦେଂକି କ୍ଡୁପ୍‌କିନି ଆଗେନି ସମୁତ ଜାଜ୍‌ତ ନହ ହଣି ଦିନ୍‌ ପାତେକ୍‌ ଲକୁ ଇନେସ୍‌ ତିନାଉଣା ଆରି ବିବା କିନାକା ଆରି ବିବା ହିଦେଂ ବିପ୍ତି ମାଚାର୍‌, ");
INSERT INTO peg_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","ଆରେ ପୁର୍‍ ୱାଜ଼ି ୱିଜ଼ାରିଂ ବଡ଼ାୟ୍‍ କିଜ଼ି ଅୱି ପାତେକ୍‌ ଇନେସ୍‌ ପୁନ୍‌ୱାଦାଂ ମାଚାର୍‌, ମାନାୟ୍‌ ମାଜ଼ିତି ୱାନାକା ପା ହେ ଲାକେ ଆନାତ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","ହେ ଏଚେକାଡ଼୍‌ଦ ରିୟାର୍‌ ବୁମିତ ମାନ୍‌ଗାନାର୍‌, ରୱାନିଂ ଇଟ୍ୟା ଆନାତ୍‌ ଆରି ବିନ୍‌ ଲଗାଂ ପିହ୍‌ୟା ଆନାତ୍‌; ");
INSERT INTO peg_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","ରିଣ୍ଡେକ୍‌ ଜାତା ନୁଜ଼୍‌ଜି ମାନିକ୍‌, ରଞ୍ଜିଲିଂ ଇଟ୍ୟାନାତ୍‌ ଆରି ଆରେ ରଞ୍ଜିଲିଂ ପିହ୍ୟାନାତ୍ । ");
INSERT INTO peg_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“ଲାଗିଂ, ଜାଗ୍ରତ୍‌ ମାନାଟ୍‌, ଇନାକିଦେଂକି ମି ମାପ୍ରୁ ଇମ୍‌ଣି ଦିନ୍‌ ୱାନାନ୍, ହେଦାଂ ଏପେଙ୍ଗ୍‌ ପୁନୁଦେର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","ମତର୍‌ ଇଦାଂ ପୁଞ୍ଜି ମାନାଟ୍‌, ଇମ୍‌ଣି ଗାଡ଼ିତ ଚର୍‌ ୱାନାନ୍, ଇଦାଂ ଇଲ୍‌ ମୁଣିକା ଏଚେକାଡ଼୍‌ଦ ପୁଚାନ୍‍ଚି, ତା ଆତିସ୍‌ ହେୱାନ୍‌ ଜାଗ୍ରତ୍‌ ମାନ୍‌ଞ୍ଜି ଜାର୍‌ ଇଞ୍ଜ ଚର୍‌ କିଦେଙ୍ଗ୍‌ ହିୱାତାନ୍ । ");
INSERT INTO peg_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","ଲାଗିଂ ଏପେଙ୍ଗ୍‌ ପା ଜାଲ୍‌ଦି ଆଜ଼ି ମାନାଟ୍‌, ଇନାକିଦେଂକି ଇମ୍‌ଣି ସମୁତ ଏପେଙ୍ଗ୍‌ ଏତ୍‌ କିୱାଦାଂ ମାନ୍‍ଗାନାଦେର୍, ହେ ସମୁଦ ମାନାୟ୍‌ ମାଜ଼ି ୱାନାନ୍ ।” ");
INSERT INTO peg_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“ତେବେ ମାପ୍ରୁ ଜାର୍‌ ଲକ୍‌ବାକ୍‍ତିଂ ସମାନ୍‌ ୱେଡ଼ାଲିଂ ବାତ୍ୟା ହିଦେଂ କାଜିଂ ଇନେରିଂ ହେୱାର୍‌ ଜପି ବାଚି କିତାନ୍‌ନ୍ନା, ଏଲେଙ୍ଗ୍‌ବାର୍ତି ପାର୍ତିନି ଆରି ବୁଦିକାର୍‌ୟା ଆଡ଼ିଏନ୍‌ ଇନେର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","ମାପ୍ରୁ ୱାଜ଼ି ଜାର୍‌ତି ଇମ୍‌ଣି ଆଡ଼ିଏନିଂ ହେ ଲାକେ କିଜ଼ି ମାନାକା ହୁଡ଼୍‍ନାନ୍, ହେୱାନ୍‌ ଦନ୍ୟ । ");
INSERT INTO peg_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ହାତ୍‌ପା ଇଞ୍ଜ୍‌ନାଙ୍ଗ୍‌, ହେୱାନ୍‌ ହେୱାନିଂ ଜାର୍‌ତି ୱିଜ଼ୁ ଦାନ୍‌ତିଙ୍ଗ୍ ଜପି ବାଚି କିଦ୍‌ନାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","ମାତର୍‌ ଜଦି ହେ ବାନ୍ୟା ଆଡ଼ିଏନ୍‌ ନା ମାପ୍ରୁ ୱାନାକା ମାଲାଆନାତ୍‍ ଇଞ୍ଜି ମାନ୍‌ତ ମାନ୍‌ତ ଇଞ୍ଜି, ");
INSERT INTO peg_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","ଜାର୍‌ ହାଂ ହାଙ୍ଗ୍‌ଦାକାର୍‌ ଟ୍ରାକ୍‍ତେଂ ଲାଗାନାନ୍‌, ଆରେ ମଦୁୱାର୍‍ ହୁକେ ତିନାଉଣା କିତିସ୍‌, ");
INSERT INTO peg_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","ତା ଆତିସ୍‌ ଇମ୍‌ଣି ଦିନ୍‌ ହଲ୍ୟା କାଜିଂ କାସି ମାନ୍‌ଗୁନ୍‌ ଆରି ଇମ୍‌ଣି ସମୁତ ହେୱାନ୍‌ ପୁନ୍‌ୱାଦାଂ ମାନାନ୍‌, ହେ ଦିନ୍‌ ଆରି ହେ ସମୁତ ହେୱାନ୍ତି ମାପ୍ରୁ ୱାନାନ୍, ");
INSERT INTO peg_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","ଆରେ ହେୱାନ୍‌ ହେୱାନିଂ ଗାଣ୍ଡ୍ରା ଗାଣ୍ଡ୍ରା କିଜ଼ି ହଟ୍‌କାନାର୍‌ କାପ୍‌ଟିୟାର୍‌ ହୁକେ ତାଦାଙ୍ଗ୍‌ ବାଗ୍‌ ରଚ୍‌ନାନ୍‌; ହେବେ ଆଡ଼୍‌ବେଦେଂ ଆରି ଟାଡାଙ୍ଗ୍‌ ରେତିକିନାନ୍‍ ।” ");
INSERT INTO peg_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“ହେୱେଡ଼ାଲିଂ ସାର୍ଗେ ରାଜି ୱାନାକା ଏଲେଙ୍ଗ୍‌ ଆନାତ୍‌ । ଦସ୍‌ ଜାଣ୍‌ ଜିପଲିକ୍‌ ୱିଜ଼େକିକ୍‍ ର ର ବଇଟା ଅଜ଼ି ବିବାଦାଂଣେନିଂ ତାତେଙ୍ଗ୍‌ ହାଲ୍‍ଜି ମାଚିକ୍ । ");
INSERT INTO peg_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","ହେୱେକ୍‌ ବିତ୍ରେ ପାଞ୍ଚ୍‌ ଜାଣ୍‌ ବୁଦିକାର୍‍ୟାକ୍‍ ଆରି ପାଞ୍ଚ୍‌ ଜାଣ୍‌ ନିର୍‌ବୁଦିୟାକ୍‌ ମାଚିକ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","ନିର୍‌ବୁଦିୟାକ୍‌ ବଇଟା ଅତିକ୍‌ ମାତର୍‌ ଜାର୍‌ ଜାର୍‌ କାଜିଂ ପା ଆଦିକ୍‌ ଚିକାଣ୍‌ ଅୱାଦାଂ ମାଚିକ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","ବୁଦ୍‍ୟାର୍‍ ଜାର୍‌ ଜାର୍‌ ବଇଟା ଲାହାଙ୍ଗ୍‌ କାଚ୍‌ତ ଚିକାଣ୍‌ ଅଜ଼ି ମାଚାର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","ବିବାଦାଂଣେନ୍‌ ୱାନାକା ମାଲା ଆତିଲେ କଇକ୍‌ ଡ଼ୁଗ୍‌ଜି ଡ଼ୁଗ୍‌ଜି ହୁଞ୍ଚିକ୍ । ");
INSERT INTO peg_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“ମାଦିମାଦା ନାଣା କିର ଇନାକା ୱେନ୍ୟା ଆତାତ୍‌, ଇୱାନ୍‌ ହୁଡ଼ା ବିବାଦାଂଣେନ୍‌ ୱାତାନେ, ୱାଡୁ ହେୱାରିଂ ହାସ୍‍ଦାଂ ତାନାସ୍ ।” ");
INSERT INTO peg_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","ହେୱାଡ଼ାଲିଂ ଜିପଲିକ୍‌ ନିଙ୍ଗ୍‌ଜି ଜାର୍‌ ଜାର୍‌ ବଇଟାଙ୍ଗ୍‌ ଜାଲ୍‌ଦି କିତିକ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","ହେୱେଡ଼ାଂ ନିର୍‌ବୁଦିୟାଂ କଇକ୍‌ ବୁଦ୍ୟାକାଂ ଇଚିକ୍‌, “ମାଙ୍ଗେଙ୍ଗ୍‌ ଇଚୁକ୍‌ ଚିକାଣ୍‌ ହିଦାଟ୍ । ମା ବଇଟା ହାଜ଼ି ହାନାତା ।” ");
INSERT INTO peg_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","“ବୁଦ୍ୟାକ୍‍ ଇଚିକ୍‌, ମି କାଜିଂ ଆରି ମା କାଜିଂ ଚିକାଣ୍‌ ସାରି ଆଉତ୍‌ । ଏପେଙ୍ଗ୍‌ ଦୁକାଣ୍‍ତ ହାଲ୍‌ଜି ଜାର୍‌ ଜାର୍‌ କାଜିଂ ଇଚୁଟିଂ ଚିକାଣ୍‌ କଡ଼୍‌ଜି ତାହିୱାଡୁ ।” ");
INSERT INTO peg_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","ଲାଗିଂ ନିର୍‌ବୁଦ୍‌ୟାଂ କଇକ୍‌ ଚିକାଣ୍‌ କଡ଼୍‌ଦେଂ ହସି ହାଚିକ୍‌ । ହେୱେକ୍‌ ତାଙ୍ଗ୍‌ଜି ହାଚି ପାଚେ ବିବାଦାଂଣେନ୍‌ ୱାଜ଼ି ଏକାୱାତାନ୍‌ । ଜାଲ୍‌ଦି ମାନି ପାଞ୍ଚ୍‌ଜାଣ୍‌ କଇକ୍‌ ତା ହୁକେ ବିବା ବଜିତ ହାଚି ପାଚେ କାପାଟ୍‌ ଗେସ୍‍ତାର୍ । ");
INSERT INTO peg_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“ପାଚେ ବିନ୍‌ ଜିପଲିକ୍‌ ପା ୱାଜ଼ି ଇଚିକ୍‌, ଏ ମାପ୍ରୁ, ଏ ମାପ୍ରୁ, ମା କାଜିଂ କାପାଟ୍‌ ଜେସି ହିଦା । ");
INSERT INTO peg_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","ମାତର୍‌ ବିବାଦାଂଣେନ୍‌ ଉତର୍‌ ହିତାନ୍‌, ଆନ୍‌ ମିଙ୍ଗ୍‌ ହାତ୍‌ପା ଇଞ୍ଜ୍‌ନାଙ୍ଗା, ଆନ୍‌ ମିଙ୍ଗ୍‌ ପୁଞ୍ଜୁଙ୍ଗ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","କାତା ୱିସ୍ତି ଜିସୁ ଇଚାନ୍‌, ଜାଗ୍ରତ୍‌ ମାନାଟ୍‌, ଇନାକିଦେଂକି ଏପେଙ୍ଗ୍‌ ହେ ଦିନ୍‌ କି ହେ ସମୁ ପୁନୁଦେର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“ସାର୍ଗେ ରାଜି ଇ ଲାକେ, ତାଦାଙ୍ଗ୍‌ ଆରେ ରଞ୍ଜୁ ଉତର୍‌ମୁଡ଼୍‌ ୱେନାଟ୍‌ । ଦିନେକ୍‌ ଆଡ଼ିୟା ମାନାୟ୍‌ କେଇଦ ତାଦାଙ୍ଗ୍‌ ଦାନ୍‌ ପିସ୍ତି ହିଜ଼ି ବିଦେସ୍‌ ହାଞ୍ଜେଙ୍ଗ୍‌ ହତାନ୍ । ");
INSERT INTO peg_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","ହେୱାନ୍‌ ରକାନିଂ ହେବାକାରି ପାଞ୍ଚ୍‌ ହାଜାର୍‌ ରୁପା ଟାକାଂ, ଆରେ ରକାନିଂ ରି ହାଜାର୍‌ ରୁପା ଟାକାଂ, ଆରେ ରକାନିଂ ଏକ୍‌ ହାଜାର୍‌ ରୁପା ଟାକାଂ, ଏପେଙ୍ଗ୍‌ ୱିଜ଼ାରିଂ ହେୱାର୍‌ ସାକ୍ତି ହୁଡ଼୍‌ଜି ହିଜ଼ି ବିଦେସ୍‍ତ ହାଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","ପାଞ୍ଚ୍‌ ହାଜାର୍‌ ରୁପା ଟାକାଂ ପାୟା ଆଜ଼ି ମାଚାନ୍‌, ହେୱାନ୍‌ ଦାପ୍ରେ ହେଦାଂ ଅଜ଼ି ବେପାର୍‌ କିଜ଼ି ଆରେ ପାଞ୍ଚ୍‌ ହାଜାର୍‌ ରୁପା ଟାକାଂ ଲାବ୍‌ କିତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","ହେ ଲାକେ ଇନେର୍‌ ରି ହାଜାର୍‌ ରୁପା ଟାକାଂ ପାୟା ଆଜ଼ି ମାଚାନ୍‌, ହେୱାନ୍‌ ଆରେ ରି ହାଜାର୍‌ ରୁପା ଟାକାଂ ଲାବ୍‌ କିତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","ମତର୍‌ ଇମ୍‌ଣି ଚାକର୍‌ ହାଜାର୍‌ ରୁପା ଟାକାଂ ପାୟା ଆଜ଼ି ମାଚାନ୍‌, ହେୱାନ୍‌ ର ଚିକ୍‌ଲା କାର୍ଚି ହାଉକାର୍ତି ହେ ରୁପା ଟାକାଂ ଡ଼ୁକ୍‌ଚି ଇଡ଼୍‌ତାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“ବେସି ଦିନ୍‌ ପାଚେ ଆଡ଼ିୟା ହାଉକାର୍‌ ମାସ୍‍ଦାତାନ୍ ଆରି ଚାକର୍‍ରିଂ ହୁକେ ହିସାବ୍‍ କିତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","ପାଞ୍ଚ୍‌ ହାଜାର୍‌ ଟାକାଂ ଅଜ଼ି ମାଚି ଚାକର୍‌ ହାଉକାର୍‍ତିଂ ଆରେ ପାଞ୍ଚ୍‌ ହାଜାର୍‌ ହିଜ଼ି ଇଚାନ୍‌, ମାପ୍ରୁ ଏନ୍‌ନାଙ୍ଗ୍‌ ପାଞ୍ଚ୍ ହାଜାର୍‌ ରୁପା ଟାକାଂ ହିଜ଼ି ମାଞ୍ଚାୟ୍, ହୁଡ଼ା, ଆନ୍‌ ପାଞ୍ଚ୍ ହାଜାର୍‌ ଲାବ୍‌ କିତାଂନ୍ନା ");
INSERT INTO peg_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","ହାଉକାର୍‌ ୱାର୍‌ୟା ଆଜ଼ି ଇଚାନ୍‌, ହାର୍‌ କିତାୟ୍‌ନା, ଏନ୍‌ ନା ସାବାସ୍‌ ହାର୍‍ଦାକାୟ୍‍ ଆରି ପାର୍ତିନି ଆଡ଼ିୟା । ଏନ୍‌ ପାର୍ତି ବାବ୍ରେ ଅଲପ୍‍ ଦନ୍‍ଦିଂ କାର୍‍ବାର୍‍ କିଦେଙ୍ଗ୍‌ ଆଡ଼୍‍ତିଲେ ନି କେଇଦ ବେସି ଦାନ୍‌ ପିସ୍ତି ହିଦ୍‌ନାଂ । ୱା, ନା ମାପ୍ରୁ ୱାରିତ ମେହାଆଦା !” ");
INSERT INTO peg_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“ରି ହାଜାର୍‌ ରୁପା ଟାକାଂ ଅଜ଼ି ମାଚି ହେବାକାରି ୱାଜ଼ି ଇଚାନ୍‌, ଏ ମାପ୍ରୁ, ଏନ୍‌ନାଙ୍ଗ୍‌ ରି ହାଜାର୍‌ ହିଜ଼ି ମାଞ୍ଚାୟ୍, ଆନ୍‌ ଆରେ ରି ହାଜାର୍‌ ରୁପା ଲାବ୍‌ କିତାଂନ୍ନା ।” ");
INSERT INTO peg_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","ହାଉକାର୍‌ ଇଚାନ୍‌, “ସାବାସ୍‌ କିତାୟ୍‌ନା । ଏନ୍‌ ପା ନା ହାର୍‌ଦି ଆଡ଼ିୟା । ଅଲପ୍‍ ଦାନ୍‌ତ ପାର୍ତିତାଂ ଚଚ୍‍ଚାତାୟ୍‍ନା । ବେସି ଦାନ୍‌ ଆନ୍‌ ନିଂ ବାଚି କିଦ୍‍ନାଂ । ୱା ନା ୱାରିତ ମିହାଆଦା ।” ");
INSERT INTO peg_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“ସେସ୍‌ତ ଏକ୍‌ ହାଜାର୍‌ ରୁପା ଟାକାଂ ଅଜ଼ି ମାଚି ଲକୁ ୱାଜ଼ି ଇଚାନ୍‌, ହାଉକାର୍‍, ଏନ୍‌ ରକାୟ୍‌ କଟି ଲକୁ ଇଦାଂ ଆନ୍‌ ପୁନାଙ୍ଗ୍‌ । ୱିତ୍‍ୱିତି ବାଡ଼୍‌ଦ ଏନ୍‌ ତ୍ରେସ୍‍ନାୟ୍‍ । ବିୟାନ୍‌ ୱିତ୍‌ୱାଦାଂ ତାସ୍‌ ରୁଣ୍ଡାୟ୍‌ କିନାୟ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","ହେଦାଂ କାଜିଂ ଆନ୍‌ ପାଣ୍ଡ୍ରା ଆଜ଼ି ନି ରୁପା ଟାକାଂ ଅଜ଼ି ହାଉକାର୍‍ ମେଦ୍‌ନିତ ମୁଚ୍‌ଚି ଇଡ଼୍‌ଜି ମାଚାଙ୍ଗ୍‌ । ହୁଡ଼ା, ନି ହେ ଡାବୁଙ୍ଗ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“ହାଉକାର୍‌ ଇଚାନ୍‌, ଡ଼େ ଆଡ୍‍ୱି, ଆଡ଼୍‌ସାୟ୍‌ ଆଡ଼ିୟା ! ଏନ୍‌ କିନ୍ଦା ପୁଞ୍ଜିମାଚାୟ୍, ଆନ୍‌ ଇମେତାକେ ୱିତ୍‌ୱାଦାଂ ମାନାଂ, ହେବେ ତ୍ରେସ୍‌ନାଂ ଇମେତାକେ ୱିତ୍‌ୱାଦାଂ ମାନ୍‌ଗାନାଂ ହେବେ ତାସ୍‌ ତ୍ରେସ୍‌ନାଂ । ");
INSERT INTO peg_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","ତେବେ ନା ଟାକାଂ ଅଜ଼ି ଏନ୍‌ କଲନ୍ତର୍‌ କାଜିଂ ଇଡ଼୍‌ଜି ମାଚାଂମା । ତା ଆତିସ୍‌ ତାଙ୍ଗ୍‌ ଆନ୍‌ କଲନ୍ତର୍‌ ହୁକେ ଉଲ୍‌ଟି ଗାଟା ଆତାଂମା ।” ");
INSERT INTO peg_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","ଇଦାଂ ଇଞ୍ଜି ହାଉକାର୍‍ ବଲ୍‌ ହିତାନ୍‌, “ଇ ରୁପା ଡାବୁଙ୍ଗ୍‌ ଅଜ଼ି, ଇନେର୍‌ ତାକେ ଦସ୍‌ ହାଜାର୍‌ ରୁପା ଟାକାଂ ମାନିଙ୍ଗ୍, ହେୱାନିଂ ହିଆଟ୍ । ");
INSERT INTO peg_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","ଇନାକିଦେଂକି ଇମ୍‌ଣି ଲକୁତ ମାନିଂ, ହେୱାନିଂ ହିୟାଆନାତ୍, ଆରେ ହେୱାନ୍ତି ବେସି ଆନାତ୍‌; ମାତର୍‌ ଇନେରିଂ ହିଲୁତ୍‌, ହେୱାନ୍‌ ଲାଗେ ଇନାକା ମାନାତ୍‌, ହେଦାଂ ନେ ତା ତାକେଣ୍ଡାଂ ଅୟାନାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","ଇ କାମାୟ୍‌ ଆଡ୍‍ୱି ଆଡ଼ିୟାତିଂ ବାର୍ତ ମାଜ୍‌ଗାତ ତୁହିୟାଟ୍‌ । ହେବେ ହେୱାନ୍‌ ଆଡ଼୍‌ବିସ୍‌ ଟାଡାଙ୍ଗ୍‌ କଡ଼୍‌ମଡ଼୍‌ କିଜ଼ି ମାନେନ୍ ।” ");
INSERT INTO peg_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“ଏଚେକାଡ଼୍‌ଦ ମାନାୟ୍‌ ମାଜ଼ି ରାଜା ଆଜ଼ି ହେୱାନ୍ତି ସାର୍ଗେ ଦୁତ୍‌ତର୍‌ ଲାହାଙ୍ଗ୍‌ ୱାନାନ୍, ରାଜା ଜାଜ୍‌ମାଲ୍‌ ହୁକେ ଗାଦିତ କୁଚ୍‌ଚାନ୍‌, ");
INSERT INTO peg_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","ସବୁ ଜାତିନି ଲକୁ ତା ଲାଗାଂ ରୁଣ୍ଡା ଆନାର୍‌ । ହେ ଏଚେକାଡ଼୍‌ଦ ମେଣ୍ଡାଗଡ଼ିୟା ଇନେସ୍‌ ଅଡାଙ୍ଗ୍‌ ଆରି ମେଣ୍ଡାକାଂ ବିନେ କିନାନ୍‌, ମାନାୟ୍‌ ମାଜ଼ି ହେ ଲାକେ ମାନାୟ୍‌ତିଂ ରି କୁଦା କିଜ଼ି ବାଗ୍‌ କିନାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","ମେଣ୍ଡାକାଂ ଜାର୍‌ ବୁଜ୍‌ଣି ବାଗାଙ୍ଗ୍‌ ଆରି ଅଡାକାଂ ଡେବ୍ରି ବାଗାଙ୍ଗ୍‌ ଇଟ୍‌ନାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","ତା ପାଚେ ହେୱାନ୍ତି ବୁଜ୍‍ଣିତ ମାନି ଲକାରିଂ ରାଜା ଇନାନ୍‌, “ୱାଡୁ, ମିଙ୍ଗେଙ୍ଗ୍‌ ନା ବାୱା ଆସିର୍ବାଦ୍‌ କିତ୍‍ନ୍ନା । ପୁର୍ତି ଉବ୍‍ଜାଣ୍‍ନି ଆରମ୍‌ତାଂ ଇମ୍‌ଣି ରାଜି ମି କାଜିଂ ଜାଲ୍‌ଦି ଆଜ଼ି ମାନାତ୍‌, ୱାଡ ହେବେ ହଣାଟ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","ଆନ୍‌ ନାସ୍‌କି ମାଚାଙ୍ଗ୍‌, ଏପେଙ୍ଗ୍‌ ଚିଚ୍‍ପାତାଦେର୍ଣ୍ଣା; ଆନ୍‌ ଏସ୍‌କି ଆଜ଼ି ମାଚାଙ୍ଗ୍‌, ଏପେଙ୍ଗ୍‌ ନାଙ୍ଗ୍‌ ଉଣ୍ଡେଙ୍ଗ୍‌ ହିତ୍‍ତାଦେର୍ଣ୍ଣା । ଆନ୍‌ ଚିନାହିଲ୍‍ୱାଦାଂ ମାଚାଙ୍ଗ୍‌, ଏପେଙ୍ଗ୍‌ ନାଙ୍ଗ୍‌ ଇଞ୍ଜ ମାଞ୍ଜେଙ୍ଗ୍‌ ବାହା ହିତ୍‌ତାୟ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","ନାଗ୍‍ଡ଼ା ମାଚାଙ୍ଗ୍‌, ନାଙ୍ଗ୍‌ ହେନ୍ଦ୍ରା ଉସ୍ପି କିତ୍‌ତାଦେର୍ଣ୍ଣା । ଆନ୍‌ ବେମାର୍‌ ମାଚାଙ୍ଗ୍‌, ନାଙ୍ଗ୍‌ ଜତନ୍‌ କିନାଦେର୍‌ ।” ଆନ୍‌ ଜେଲ୍‌ ଇଞ୍ଜ ମାଚାଙ୍ଗ୍‌, ନାଙ୍ଗ୍‌ ହୁଡ଼୍‌ଦେଂ ୱାତାଦେର୍ । ");
INSERT INTO peg_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“ହେବେ ଦାର୍ମିର୍‍ ତାଙ୍ଗ୍‌ ଉତର୍‌ ହିଦ୍‍ନାର୍, ଏ ମାପ୍ରୁ, ଇନାୱାଡ଼ାଂ ଆପେଂ ନିଂ ନାସ୍‌କି ହୁଡ଼୍‌ଜି କାଦି ହିତ୍‍ତାପ୍ କି ଏସ୍‌କି ହୁଡ଼୍‌ଜି ଉଟ୍‍ପି କିତ୍‌ତାପ୍‌ ? ");
INSERT INTO peg_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","ଆରେ ଇନାୱାଡ଼ାଂ ରୱାନ୍‌ ନିଂ ଚିନାହିଲ୍‌ୱି ଲକୁ ହୁଡ଼୍‌ଜି ଆହା ହିତ୍‍ତାପ୍ ? କି ନାଗ୍‍ଡ଼ା ହୁଡ଼୍‌ଜି ହେନ୍ଦ୍ରା ଉସ୍ପି କିତ୍‌ତାପ୍‌ ? ");
INSERT INTO peg_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","ଇନାୱାଡ଼ାଂ ନିଂ ବେମାର୍‌ କି ଜେଲ୍‌ ଇଞ୍ଜ ହୁଡ଼୍‌ଜି ହେବା କିତ୍‌ତାପ୍‌ ? ");
INSERT INTO peg_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","ଆରେ ରାଜା ହେୱାରିଂ ଉତର୍‌ ହିନାନ୍‌, ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ହାତ୍‌ପା ଇଞ୍ଜ୍‌ନାଙ୍ଗା, ଏପେଙ୍ଗ୍‌ ନା ଇ ହାରୁ ଟଣ୍ଡାର୍‌ ବିତ୍ରେତାଂ ରୱାନ୍‌ କାଜିଂ ଇଦାଂ କିଜ଼ି ମାଚିଲେ ନା କାଜିଂ ନେ ହେଦାଂ କିନାଦେରା ।” ");
INSERT INTO peg_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“ତା ପାଚେ ଡେବ୍ରିବାଗାଙ୍ଗ୍‌ ମାନି ଲକାରିଂ ହେୱାନ୍‌ ଇନାନ୍‌, ଡ଼େ ସାଇପ୍‌ ପାୟାତି ମାନାୟାର୍‌ ! ନା ମୁମ୍‌ଦାଂ ଦେହା ଆ ! ସୟ୍‌ତାନ୍‌ ଆରି ତା ଦୁତ୍‌ତର୍‌ କାଜିଂ ଇମ୍‌ଣି ୱିଜ଼୍‌ୱିନାଣି ଜାଲ୍‌ଦି ଆଜ଼ି ମାନାତ୍‌, ହେବେ ହାଲାଟ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","ଆନ୍‌ ନାସ୍‌କି ମାଚାଙ୍ଗ୍‌, ଏପେଙ୍ଗ୍‌ ନାଙ୍ଗ୍‌ ଚିଞ୍ଜେଙ୍ଗ୍‌ ହିଦ୍‍ୱାତାଦେର୍ । ଆନ୍‌ ଏସ୍‌କି ମାନିୱେଡ଼ାଲିଂ ନାଙ୍ଗ୍‌ ଏଜ଼ୁଂ ଉଣ୍ଡେଙ୍ଗ୍‌ ହିଦ୍‍ୱାତାଦେର୍ । ");
INSERT INTO peg_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","ଆନ୍‌ ଚିନ୍‍ପୁନ୍‍ୱି ୱେଡ଼ାଲିଂ ନା ଇଞ୍ଜ ବାହା ହିଦ୍‍ୱାତାଦେର୍ । ଆନ୍‌ ନାଗ୍‍ଡ଼ା ମାନିହିଂ ହେନ୍ଦ୍ରା ଉସ୍ପି କିଦ୍‌ୱାତାଦେର୍‌ । ବେମାର୍‌ ଆରି ଜଇଲ୍‌ତ ମାନିୱେଡ଼ାଲିଂ ନା ଜତନ୍‌ ଅୱାତାଦେର୍ଣ୍ଣା ।” ");
INSERT INTO peg_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“ହେୱାଡ଼ାଂ ହେୱାର୍‌ ଉତର୍‌ ହିଦ୍‌ନାନ୍‌, ଏ ମାପ୍ରୁ, ଇନାୱାଡ଼ାଂ ଆପେଂ ନିଂ ନାସ୍‌କି, ଏସ୍‌କି, ବିଦେସି କି ନାଗ୍‍ଡ଼ା, ବେମାର୍‌ କି ଜଇଲ୍‌ତ ମାନାକା ହୁଡ଼୍‌ଜି ଆପେଂ ନିଂ ହେବା କିଦ୍‍ୱାତାଂନା ?” ");
INSERT INTO peg_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“ରାଜା ଉତର୍‌ ହିନାନ୍‌, ଆନ୍‌ ହାତ୍‌ପା ଇଞ୍ଜ୍‌ନାଙ୍ଗା, ଇ ହାରୁକାର୍‌ ବିତ୍ରେ ରକାନିଂ ଉପ୍‌କାର୍‌ କିଦେଙ୍ଗ୍‌ ମୁନା କିନିହିଙ୍ଗ୍‌, ଏପେଙ୍ଗ୍‌ ନାଙ୍ଗ୍‌ ଉପ୍‌କାର୍‌ କିଦେଙ୍ଗ୍‌ କାୱାତାଦେର୍ଣ୍ଣା । ");
INSERT INTO peg_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","ଇ ଲକୁ ସବୁ ଦିନ୍‌ କାଜିଂ ଡାଣ୍ଡ୍‌ ପାୟାନାର୍ ଆରି ଦାର୍ମିର୍‌ ୱିଜ଼୍‌ୱି ଜିବୁନ୍‌ ପାୟାନାର୍ ।” ");
INSERT INTO peg_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","ଇ ସବୁ ହିକ୍ୟା ହିଜ଼ି ୱିସ୍ତି ପାଚେ ଜିସୁ ଚେଲାରିଂ ଇଚାନ୍‌, ");
INSERT INTO peg_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“ରି ଦିନ୍‌ ପାଚେ ଜେ, ନିସ୍ତାର୍‌ ପାର୍ବୁ ଆନାତ୍‌, ଇଦାଂ ଏପେଙ୍ଗ୍‌ ପୁଚାଦେର୍ଣ୍ଣା । ଆରେ ମାନାୟ୍‌ ମାଜ଼ି ଜେ କ୍ରୁସ୍‌ତ ଦୁପ୍‌ୟା ଆଦେଂ କାଜିଂ ହେଲାୟ୍‌ କିୟାଆନାନ୍ ।” ");
INSERT INTO peg_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","ହେ ୱେଡ଼ାଲିଂ ମୁଡ଼୍‌ ମାପ୍ରୁହେବାକିନାକାନ୍‌ ଆରି ଲକୁର୍ତି ବୁଡ଼ାଲୁର୍‌ କୟାପା ତର୍‌ନି ମୁଡ଼୍‌ ମାପ୍ରୁହେବାକିନାକାନ୍ତି ହାକ୍‌ଡ଼ିତ ରୁଣ୍ଡା ଆତାର୍‌, ");
INSERT INTO peg_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","ହେୱାର୍‌ ଡ଼ୁଗ୍‌ଜି ଜିସୁଙ୍ଗ୍‌ ଅସ୍ତେଙ୍ଗ୍‌ ମାନ୍‌ପାଚି କିତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","ମାତର୍‌ ହେୱାର୍‌ ଇଚାର୍‌, “ପାର୍ବୁ ୱେଡ଼ାଲିଂ ଇଦାଂ କିନାକା ହାର୍‌ ଆକାୟ୍‌, ଇନାକିଦେଂକି ମାନାୟାର୍‌ ଗଣ୍ଡ୍‌ଗଲ୍‌ କିଦ୍‌ନାର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","ଦିନେକ୍‌ ଜିସୁ ବେତ୍‌ନିୟାତ ଗାଜା ରଗ୍ୟା ବଗ୍‌ କିଜ଼ି ସିମନ୍‌ ଇଞ୍ଜ ମାନି ୱେଡ଼ାଲିଂ, ");
INSERT INTO peg_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","ରଞ୍ଜେଲ୍‌ କଗ୍‌ଲେ ର କଣ୍ଡିତ ଦାମ୍‌ନି ବାସ୍‌ନା ଚିକାଣ୍‌ ଅସି ତା ତାକେ ୱାତାତ୍‌ ଆରି ହେଦେଲ୍‌ ଚିଞ୍ଜେଙ୍ଗ୍‌ କୁଚ୍‌ଚି ସମୁତ ତାଙ୍ଗେଙ୍ଗ୍‌ କାପ୍‌ଡ଼ାତ ୱାକ୍‍ତେଂ ଲାଗାତାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","ହେଦାଂ ହୁଡ଼୍‌ଜି ଚେଲାର୍‌ ରିସା ଆଜ଼ି ଇଚାର୍‌, “ଏଚେକ୍‌ ନସ୍ଟ କିନାତା ଇନାକିଦେଂ ? ");
INSERT INTO peg_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","ଇ ବାସ୍‌ନା ଚିକାଣ୍‌ ବେସି ଟାକାଂତାଂ ପ୍ରୟା ଆତାତ୍ମା ଆରି ହେ ଦାନ୍‌ ଅର୍କିତାରିଂ ଦାନ୍‌ ହିୟାତାତ୍ମା ।” ");
INSERT INTO peg_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","ଜିସୁ ହେଦାଂ ପୁଞ୍ଜି ହେୱାରିଂ ଇଚାନ୍‌, ଇନେକିଦେଂ କଗ୍‌ଲେଂ କସ୍ଟ ହିନାଦେରା ? ହେଦେଲ୍‌ ନା କାଜିଂ ହାର୍‌ କାମାୟ୍‌ କିନାତା । ");
INSERT INTO peg_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","“ଅର୍କିତ୍‌ ଲକୁତ ନିତ୍ରେ ମି ହୁଦାଂ ମାନାର୍‌, ମତର୍‌ ଆନ୍‌ ନିତ୍ରେ ମି ହୁଦାଂ ମାନୁଙ୍ଗ୍ । ");
INSERT INTO peg_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","ଆରେ, ନା ଦୁଗେର୍‌ତ ମୁଚ୍‌ନି କାମାୟ୍‌ ଲାକେ ନା ଗାଗାଡ଼୍‌ତ ଇ ବାସ୍‌ନା ଚିକାଣ୍‌ ୱାକ୍‍ତାନାତା । ");
INSERT INTO peg_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","ଆନ୍‌ ନିଂ ହାତ୍‌ପା ଇଞ୍ଜ୍‌ନାଙ୍ଗା, ୱିଜ଼ୁ ପୁର୍ତିତ ଇମ୍‌ଣି ବାହାତ ପା ନେକ୍ରିକାବୁର୍‌ ୱେଚ୍ୟାନାତ୍, ହେ ବାହାତ ଇ କଗ୍‌ଲେତି ଏତୁତିଂ ତାଦାଙ୍ଗ୍‌ ଇ କାମାୟ୍‌ନି କାତା ପା ଇନ୍ୟା ଆନାତ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","ଜିସୁତି ବାରଜାଣ୍‌ ଚେଲାର୍‌ ବିତ୍ରେ ଇସ୍କାରିୟତିୟ ଜିହୁଦା ତର୍‌ନି ରକାନ୍‌ ଚେଲା ମୁଡ଼୍‌ ମାପ୍ରୁହେବାକିନାକାର୍‌ ତାକେ ହାଲ୍‌ଜି ୱେନ୍‌ବାତାନ୍‌, ");
INSERT INTO peg_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","“ଜିସୁଙ୍ଗ୍‌ ଆହି କିଜ଼ି ହିତ୍‍ତିସ୍ ନାଙ୍ଗ୍‌ ଇନାକା ହିଦ୍‍ନାଦେର୍ ?” ହେୱାର୍‌ ତାଙ୍ଗ୍‌ କଡ଼େଦସ୍‍ ଗଟା ରୁପା ଟାକାଂ ଏଜା କିଜ଼ି ହିତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","ହେ ଦିନ୍‍ତାଂ ଜିସୁଙ୍ଗ୍‌ ହେୱାର୍‌ କେଇଦ ଆହିକିଦେଂ କାଜିଂ ସୁବିଦା ଡେକ୍‌ତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","ପାଚେ ହଇୱି ରୁଟି “ପାର୍ବୁନି ପର୍ତୁମ୍‌ ଦିନ୍ତ ଚେଲାର୍‌ ଜିସୁ ଲାହାଙ୍ଗ୍‌ ୱାଜ଼ି ୱେନ୍‍ବାତାର୍, ଆପେଂ ଇମ୍‌ଣି ବାହାତ ନି କାଜିଂ ନିସ୍ତାର୍‌ ପାର୍ବୁ ବଜି ଜାଲ୍‌ଦି କିନାପ୍‌ ଇଞ୍ଜି ନି ଇଚା ?” ");
INSERT INTO peg_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","ଜିସୁ ଉତର୍‌ ହିତାନ୍‌, ଗାଡ଼୍‌ଦ ହାଲ୍‌ଜି ହେ ଆମ୍‍କ ଲଗାଂ ତାଙ୍ଗେଙ୍ଗ୍‌ ଇନାଟ୍‌, “ଗୁରୁ ଇଞ୍ଚାନ୍ନା, ହେୱାନ୍ତି ସମୁ ଲାଗେ ଆଜ଼ି ୱାତାତେ । ହେୱାନ୍ତି ଚେଲାର୍‌ ଲାହାଙ୍ଗ୍‌ ମି ଇଞ୍ଜ ହେୱାନ୍‌ ନିସ୍ତାର୍‌ ପାର୍ବୁ ମାନିକିନାନ୍ ।” ");
INSERT INTO peg_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","ଜିସୁ ଇନି ହିସାବ୍‍ରେ ଚେଲାର୍‌ ନିସ୍ତାର୍‌ ପାର୍ବୁ ବଜି ଜାଲ୍‌ଦି କିତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","ପାଚେ ମ୍ଡିତିଲେ ହେୱାନ୍‌ ବାରଜାଣ୍‌ ଚେଲାର୍‌ ଲାହାଙ୍ଗ୍‌ ଚିଞ୍ଜେଙ୍ଗ୍ କୁଚ୍‌ଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","ତିନି ୱେଡ଼ାଲିଂ ଜିସୁ ଇଚାନ୍‌, “ଆନ୍‌ ମିଙ୍ଗ୍‌ ହାତ୍‌ପା ଇଞ୍ଜ୍‌ନାଙ୍ଗା, ମି ବିତ୍ରେ ରକାନ୍‌ ନାଙ୍ଗେଙ୍ଗ୍‌ ସତ୍ରୁ କେଇଦ ହେଲାୟ୍‌ କିଦ୍‌ନାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","ଚେଲାର୍‌ ବେସି ଦୁକ୍‌ ଆଜ଼ି ରକାନ୍‌ ପାଚେ ରକାନ୍‌ ଜିସୁଙ୍ଗ୍‌ ୱେନ୍‌ବାତାର୍, “ମାପ୍ରୁ ହେୱାଙ୍ଗ୍‌ ଇନାକା ଆନ୍‌ ?” ");
INSERT INTO peg_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","ଜିସୁ ଇଚାନ୍‌, “ଇନେର୍‌ ନା ଲାହାଙ୍ଗ୍‌ ରଚେ ତାଡ଼ିୟାତ ରୁଟି କ୍ଡକ୍‍ନାନ୍, ହେୱାନ୍‌ ନାଙ୍ଗ୍‌ ସତ୍ରୁ କେଇଦ ହେଲାୟ୍‌ କିଦ୍‌ନାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","ସାସ୍ତର୍‌ର୍ତ ଇନେସ୍‌ ଲେକା ଆତାତ୍‌ନ୍ନା ମାନାୟ୍‌ ମାଜ଼ି ହାକିଡାଣ୍ଡ୍‌ ଆନାନ୍‌, ମାତର୍‌ ଇନେର୍‌ ଆହିକିନାନ୍‌, ତା ଦସା କେତେକ୍‌ କସ୍ଟ ! ହେ ମାନାୟ୍‌ ଜଲମ୍‌ ଆୱାଦାଂ ମାଚିସ୍‌ ତା ପାକ୍ୟାତ ହାରା ଆତାତ୍ମା ।” ");
INSERT INTO peg_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","ସାତ୍ରୁ କେଇଦ ହେଲାୟ୍‌ କିତି ଜିହୁଦା ନିଙ୍ଗ୍‌ଜି ୱେନ୍‌ବାତାନ୍‌, “ଏ ଗୁରୁ, ହେୱାଙ୍ଗ୍‌ ଇନାକା ଆନ୍‌ ?” ଜିସୁ ହେୱାନିଂ ଇଚାନ୍‌, “ଏନ୍‌ ଇଞ୍ଚାୟ୍‌ନ୍ନା ।” ");
INSERT INTO peg_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","ହେୱାର୍‌ ତିନି ୱେଡ଼ାଲିଂ ଜିସୁ ର ରୁଟି ଅଜ଼ି ଇସ୍ୱର୍‌ତିଂ ଦନ୍ୟବାଦ୍‌ ହିତାନ୍‌ ଆରି ହେଦାଂ ଡ୍ରିକ୍‌ଚି ଚେଲାରିଂ ହିଜ଼ି ଇଚାନ୍‌, “ଇଦାଂ ନା ଗାଗାଡ଼୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","ତା ପାଚେ ହେୱାନ୍‌ ଉଣି ବାହା ଅଜ଼ି ଇସ୍ୱର୍‌ତିଂ ଜୁୱାର୍‌ କିତାନ୍‌ ଆରି ହେଦାଂ ଚେଲାରିଂ ହିଜ଼ି ଇଚାନ୍‌, “ଏପେଙ୍ଗ୍‌ ୱିଜ଼ାକାଦେର୍‌ ଇବେଣ୍ଡାଂ ଉଣାଟ୍ ।” ");
INSERT INTO peg_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","“ଇଦାଂ ନା ନେତେର୍‌ । ମାନାୟ୍‌ତିଂ ପାପ୍‌ କେମା କାଜିଂ ଆନ୍‌ ଇମ୍‌ଣି ନେତେର୍‌ ୱାକ୍‍ଚି ହିଦେଂ ହାନାଙ୍ଗା, ଇମ୍‌ଣାକା ଇସ୍ୱର୍ତି ପୁନି ନିୟମ୍‌ ରଚ୍ୟା ଆତାତ୍‌ନ୍ନା । ");
INSERT INTO peg_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","ମାତର୍‌ ଆନ୍‌ ମିଙ୍ଗ୍‌ ଇଞ୍ଜ୍‌ନାଙ୍ଗା, ଇମ୍‌ଣି ଦିନ୍‌ ଆନ୍‌ ନା ବାୱାତି ରାଜିତ ମି ହୁଦାଂ ପୁନି କିଜ଼ି ଅଙ୍ଗୁର୍‌ ପାଡ଼୍‌ନି ରାସ୍‌ ଉଣାଙ୍ଗ୍‌, ହେ ଦିନ୍‌ ପାତେକ୍‌ ନେଞ୍ଜ୍‍ତାଂ ଆନ୍‌ ଇଦାଂ ଇନାୱାଡ଼ାଂ ପା ଉଣୁଙ୍ଗ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","ଆରେ, ହେୱାର୍‌ ଜୁୱାର୍‌ କେର୍‌କଣ୍‌ କେର୍‌ତି ପାଚେ ଜିତ୍‌ମାଡ଼ିତ ହସି ହାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","ଇ ୱେଡ଼ାଲିଂ ଜିସୁ ହେୱାରିଂ ଇଚାନ୍‌, “ନେଞ୍ଜେଙ୍ଗ୍‌ ନାଣା ଏପେଙ୍ଗ୍‌ ୱିଜ଼ାକାଦେର୍‌ ନାଙ୍ଗ୍‌ ପିସ୍ତି ହାନାଦେର୍ । ଇନାକିଦେଂକି ସାସ୍ତର୍‌ତ ଲେକାତାତ୍‌ନା, ଆସେଙ୍ଗ୍‌ ମେଣ୍ଡା ଗଡ଼ିୟାଙ୍ଗ୍‌ ଅସ୍‌ତିସ୍‌, ଆରେ ମାନ୍ଦା ନି ମେଣ୍ଡାଂ ଜେଡ଼େକେତେ ଆଜ଼ି ହାନିକ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","“ମାତର୍‌ ଆନ୍‌ ନିଙ୍ଗ୍‌ନି ପାଚେ ମି ଆଗେ ଗାଲିଲି ରାଜି ହାନାଂ ।” ");
INSERT INTO peg_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","ପିତର୍‌ ଜିସୁଙ୍ଗ୍‌ ଇଚାନ୍‌, “ବିନ୍‌ ଲଗୁ ୱିଜ଼ାକାର୍‌ ନିଂ ପିସ୍ତି ହାଚିସ୍ ପା ଆନ୍‌ ମୁଡ଼୍‌କେ ପିସ୍ତି ହାଲୁଙ୍ଗ୍ ।” ");
INSERT INTO peg_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","ଜିସୁ ପିତରଂ ଇଚାନ୍‌, “ଆନ୍‌ ହାତ୍‌ପା ଇଞ୍ଜ୍‌ନାଙ୍ଗା, ନେଞ୍ଜେଙ୍ଗ୍‌ ନାଣା କୁଜ଼ୁ କେଡ଼୍‍ନି ଆଗେ ଏନ୍‌ନାଙ୍ଗ୍‌ ପୁନୁଙ୍ଗ୍‌ ଇଞ୍ଜି ତିନିହଟ୍‌ ପାର୍ତି କିଦୁୟ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","ପିତର୍‌ ଉତର୍‌ ହିତାନ୍‌, “ନି ହୁକେ ହାଦେଂ ଲାଗ୍‍ଦିତିସ୍‌ପା ଆନ୍‌ ଇନାୱାଡ଼ାଂ ପା ଉଡ଼ା ଆଦୁଙ୍ଗ୍ ।” ବିନ୍‌ ଚେଲାର୍‌ ପା ୱିଜ଼ାକାର୍‌ ହେ ଲାକେ ଇଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","ତା ପାଚେ ଜିସୁ ଜାର୍‌ ଚେଲାର୍‌ ହୁକେ ଗେତ୍‌ସିମନି ତର୍‌ନି ର ବାହାତ ହେୱାରିଂ ଇଚାନ୍‌, “ଆନ୍‌ ହେବେ ହାଲ୍‌ଜି ପାର୍ତାନା କିନି ପାତେକ୍‌ ଏପେଙ୍ଗ୍‌ ଇବେ କୁଚ୍‌ଚି ମାନାଟ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","ଆରେ, ଜିସୁ ପିତର୍‌ ଆରି ଜେବ୍‌ଦି ରିକାର୍‌ ମେହିରିଂ ଅତାନ୍‌ । ହେ ଏଚେକାଡ଼୍‌ଦ ଜିସୁ ବେସି ଦୁକ୍‌ ବାଦାତ ବିପ୍ତି ଆଜ଼ି ମାଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","ଜିସୁ ହେୱାରିଂ ଇଚାନ୍‌, “ଦୁକ୍‌ତ ନା ୱାସ୍କି ବିପ୍ତି ଆନାତା । ଇବେ ଏପେଙ୍ଗ୍‌ ନା ଲାହାଙ୍ଗ୍‌ କାଜିଂ ମାନାଟ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","ଜିସୁ ଅଲପ୍‍ ଦେହା ହାଲ୍‌ଜି ମେଦ୍‌ନିତ ମୁମ୍‌ କୁନ୍ଦି କିଜ଼ି ପାର୍ତାନା କିତାନ୍‌, “ବାୱା ! ଜଦି ଆଦେଂ ଆନାତ୍‌, ଇ ଦୁକ୍‍ବଗନି ଉଣି ବାହା ନା ତାଙ୍ଗ୍‌ ଦେହା ଅୱା, ମାତର୍‌ ନା ଇଚା ଆକାୟ୍‌, ନି ଇଚା ପୁରା ଆଏତ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","ତା ପାଚେ ହେୱାନ୍‌ ଚେଲାର୍‌ ଲାଗାଙ୍ଗ୍‌ ୱାଜ଼ି ହୁଡ଼୍‌ତାନ୍‌, ହେୱାର୍‌ ହୁଞ୍ଚାର୍ଣ୍ଣା । ଜିସୁ ପିତର୍‌ତିଂ ଇଚାନ୍‌, “ଏପେଙ୍ଗ୍‌ ନା ହୁଦାଂ ରଗଣ୍ଟା କାଜିଂ ମାଞ୍ଜେଙ୍ଗ୍‌ ଆଡୁଦେରା ? ");
INSERT INTO peg_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","ପରିକ୍ୟାତ ଇନେସ୍‌ ଆର୍‌ମାଟ୍‌, ହେଦାଂ କାଜିଂ ମାନ୍‌ଞ୍ଜି ପାର୍ତାନା କିୟାଟ୍‌ । ଇନାକିଦେଂକି ମିଦାଙ୍ଗ୍‌ ଜିବୁନ୍‌ ଇଚା, ମାତର୍‌ ଗାଗାଡ଼୍‌ ନାଦାର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","ଜିସୁ ଆରେ ରଗ ହାଲ୍‌ଜି ପାର୍ତାନା କିତାନ୍‌, ନା “ବାୱା ! ଜଦି ଦୁକ୍‍ବଗନି ଉଣି ବାହା ନାତାଙ୍ଗ୍‌ ଗୁଚା ଆଦେଂ ଆଡୁୟ୍‌ ଆରି ନାଙ୍ଗ୍‌ ହେଦାଂ ଉଣ୍ଡେଙ୍ଗ୍‌ ନେ ଆନାତ୍‌, ନି ଇଚା ପୁରା ଆୟେତ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","ହେୱାନ୍‌ ଆରେ ରଗ ମାସ୍‌ଦି ଚେଲାରିଂ ହୁଞ୍ଜ୍‌ନାକା ହୁଡ଼୍‌ତାନ୍‌ । ହେୱାର୍‌ କାଣ୍‌କୁ ଜେତେଙ୍ଗ୍‌ ଆଡ୍‌ୱାଦାଂ ମାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","ଜିସୁ ହେୱାରିଂ ପିସ୍ତି ଅଲପ୍‍ ଦେହା ହାଲ୍‌ଜି ତିନ୍‌ହଟ୍‌ କାଜିଂ ହେ ଲାକେ ପାର୍ତାନା କିତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","ତା ପାଚେ ଚେଲାର୍‌ ତାକେ ୱାଜ଼ି ଇଚାନ୍‌, “ଏପେଙ୍ଗ୍‌ ଇ ପାତେକ୍‌ ହୁଞ୍ଜିମାଞ୍ଜି ଜମ୍‌ନାଦେରା ? ହୁଡ଼ାଟ୍‌, ମାନାୟ୍‌ ମାଜ଼ି ପାପିର୍‌ କେଇଦ ହେଲାୟ୍‌ ଆନି ସମୁ ୱାତାତ୍ । ");
INSERT INTO peg_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","ନିଂଗାଟ୍ ଆସେଙ୍ଗ୍‌ ହାନାସ୍ । ଇଦି ହୁଡ଼ାଟ୍‌, ନାଙ୍ଗ୍‌ ଆହିକିଦ୍‍ନି ମାନାୟ୍‌ ମାଜ଼ି ଏକାୱାତାନେ ।” ");
INSERT INTO peg_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","ହେୱାନ୍‌ କାତା ଇନିୱାଡ଼ାଲିଂ, ହୁଡ଼ାଟ୍‌, ବାରଜାଣ୍‌ ବିତ୍ରେ ଜିହୁଦା ତର୍‌ନି ରକାନ୍‌ ଆରି ହେ ଲାହାଙ୍ଗ୍‌ ମୁଡ଼୍‌ ମାପ୍ରୁହେବା କିନାକାର୍‌ ଆରି ମାନାୟାର୍‌ତି ବୁଡ଼ାଲୁର୍‌ ତାଙ୍ଗ୍‌ ପକ୍ୟାତି ହେନି ଲକୁ କାଣ୍ଡା ଆରି ଟେଙ୍ଗାଙ୍ଗ୍ ଆସ୍ତି ୱାତାର୍ । ");
INSERT INTO peg_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","ଆରେ, ହେୱାନିଂ ସତ୍ରୁ କେଇଦ ହେଲାୟ୍‌ କିନାକାନ୍‌ ହେୱାରିଂ ଚଚ୍‌ଚି ଇଞ୍ଜି ମାଚାନ୍‌, “ଆନ୍‌ ଇନେରିଂ ଡଞ୍ଜ୍‍ନାଂ, ହେୱାନିଂ ନେ ଏପେଙ୍ଗ୍‌ ଇଟ୍‌କାଡ଼୍‌ କିନାଦେରା । ହେୱାନିଂ ଆହାଟ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","ଆରେ, ହେଦାପ୍ରେ ଜିସୁତି ଲାଗାଂ ହାଲ୍‌ଜି ୱାଜ଼ି, ଏ ଗୁରୁ ଜୁୱାର୍‌, ଇଦାଂ ଇଞ୍ଜି ହେୱାନିଂ ବେସି ଡଞ୍ଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","ଜିସୁ ହେୱାନିଂ ଇଚାନ୍‌, “ବନ୍ଦୁ, ଏନ୍‌ କାମାୟ୍‌ ବେଗି ୱିହା ।” ଇଦାଂ ପାଚେ ହେୱାର୍‌ ଜିସୁଙ୍ଗ୍‌ ଆସ୍ତାର୍‌ ଆରି ଗାଚ୍‌ଚି ଅତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","ଆରେ ହୁଡ଼ାଟ୍‌, ଜିସୁ ଲାହାଙ୍ଗ୍‌ ମାନି ମାନାୟାର୍‌ ବିତ୍ରେ ରକାନ୍‌ କାଣ୍ଡା ଉନ୍‌ଦି ମୁଡ଼୍‌ ମାପ୍ରୁହେବାକିନାକାନ୍‌ ଆଡ଼ିୟାତିଂ କାତ୍‍ତାନ୍ । ହେୱାନ୍ତି କିତୁଲ୍‌ ରାସ୍ତିଲେ ନାଡ଼୍‍ଜି ହାଚାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","ଜିସୁ ତାଙ୍ଗ୍‌ ଇଚାନ୍‌, “ନି କାଣ୍ଡାତିଂ ହେ କାପୁତାକେ ଇଟା । ଇନେର୍‌ କାଣ୍ଡା ହପ୍‌ନାର୍‌, ହେୱାର୍‌ କାଣ୍ଡାତ ହାନାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","ଏପେଙ୍ଗ୍‌ ଇନାକା ପୁନ୍‍ୱାତାଦେର୍ଣ୍ଣା, ଆନ୍‌ ନା ବାୱାଙ୍ଗ୍‌ ଗୱାରି କିଦେଙ୍ଗ୍‌ ଏନ୍ତିସ୍‌, ହେୱାନ୍‌ ନା କାଜିଂ ଦାପ୍ରେ ବାରଜାଣ୍‌ ଟଣ୍ଡାର୍‌ ବାଟା ଆଦିକ୍‌ ସାର୍ଗେ ଦୁତ୍‌ରିଂ ପକ୍ତେତେଂ ଆଡ୍‌ନାନ୍‌ ? ");
INSERT INTO peg_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","ମାତର୍‌ ତା ଆତିସ୍‌ ଇ ସବୁ ଗିଟାନାତ୍ ଇଞ୍ଜି ସାସ୍ତର୍‌ତ ଇନାକା ଲେକାମାନାତ୍‌, ହେଦାଂ ପୁରା ଆନାତ୍‌ ଇନେସ୍‌ ?” ");
INSERT INTO peg_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","ହେୱେଡ଼ାଂ ଜିସୁ ମାନାୟାରିଂ ଇଚାନ୍‌, ଚର୍କୁ ବିରୁଦ୍‌ତ ହତି ଲାକେ କାଣ୍ଡା ଆରି ଟେଙ୍ଗାଙ୍ଗ୍ ତାସି ଏପେଙ୍ଗ୍‌ ଇନାକା “ନାଙ୍ଗ୍‌ ଆସ୍ତେଙ୍ଗ୍‌ ୱାତାଦେର୍ ? ଆନ୍‌ ନିତ୍ରେ ମନ୍ଦିର୍‌ତ କୁଚ୍‌ଚି ହିକ୍ୟା ହିଜ଼ି ମାଚାଙ୍ଗ୍‌, ମାତର୍‌ ଏପେଙ୍ଗ୍‌ ନାଙ୍ଗ୍‌ ଆସ୍ତାୱାତାଦେର୍‌; ");
INSERT INTO peg_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","ହେୱାନ୍‌ ଇନାକା ଆୟେତ୍‌, ବେଣ୍‌ବାକ୍‌ଣାୟ୍‌କିନାକାର୍‌ ସାସ୍ତର୍‌ତ ଇନାକା ଇନାକା ଲେକିକିତାର୍ଣ୍ଣା, ହେ ସବୁ ପୁରା ଆଦେଂ କାଜିଂ ଇଦାଂ ଗିଟାତାତ୍‍ନା ।” ଏଚେକାଡ଼୍‌ଦ ଚେଲାର୍‌ ୱିଜ଼ାକାର୍‌ ଜିସୁଙ୍ଗ୍‌ ପିସ୍ତି ହନ୍ତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","ଜିସୁଙ୍ଗ୍‌ ଗାଚ୍‍ଚାକାର୍ ହେୱାନିଂ ମୁଡ଼୍‌ ମାପ୍ରୁହେବା କିନାକାନ୍‌ କୟାପା ଇଞ୍ଜ ଅତାର୍‌ । ହେବେ ଦରମ୍‌ ଗୁରୁ ଆରି ପ୍ରାଚିନାର୍‌ ରୁଣ୍ଡା ଆଜ଼ି ମାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","ପିତର୍‌ ଅଲପ୍‍ ଦେହା ମାନ୍‌ଞ୍ଜି ଜିସୁଙ୍ଗ୍‌ ଡେଇଁ ଡ଼କ୍‍ଚି ହାଚାନ୍‌, ଆରେ ହେୱାନ୍‌ ମୁଡ଼୍‌ ମାପ୍ରୁହେବା କିନାକାନ୍‌ ଇଞ୍ଜ ହାକ୍‌ଡ଼ି ପାତେକ୍‌ ହାଚାନ୍‌ । ଇ ସବୁନି ଗଟ୍‌ନା ଇନାକା ଆନାତ୍‌, ହୁଡ଼୍‌ଦେଂ କାଜିଂ ପିତର୍‌ ହେବେ ହେବା କାର୍‌ୟାର୍‌ ହୁକେ କୁଚ୍‌ଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","ୱିସ୍ତି ବିତ୍ରେ ମୁଡ଼୍‌ ମାପ୍ରୁହେବା କିନାକାର୍‌ ଆରି ଗାଜା ସବାନି ମେମରାର୍ ଜିସୁଙ୍ଗ୍‌ ହାକି ଡାଣ୍ଡ୍‌ ହିଦେଂ କାଜିଂ ହେ ବିରୁଦ୍‌ତ ମିଚ୍‌ ପାର୍ମାଣ୍‌ କିଦେଙ୍ଗ୍‌ ସେସ୍ଟା କିତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","ୱିଜ଼ାର୍‌ ଲକୁ ଜିସୁ ବିରୁଦ୍‌ତ ମିଚ୍‌ କାତା ଇଚାର୍‌ । ମାତର୍‌ ହେ ଲାକେ ଇନାକାପା ପାର୍ମାଣ୍‌ ଗାଟାୱାତାର୍‌ । ହାରିହାରା ରିକାର୍‌ ନିଂତାର୍‌, ");
INSERT INTO peg_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","“ହେୱାର୍‌ ଇଚାର୍‌ ଇୱାନ୍‌ ଇଞ୍ଜି ମାଚାନ୍‌, ଆନ୍‌ ଇସ୍ୱର୍ତି ମନ୍ଦିର୍‌ତିଂ ଡ୍ରିକ୍‌ଚି ତିନି ଦିନ୍‌ ପାଚେ ହେଦେଲିଂ ଆରେ ରଚ୍‌ଚେଂ ଆଡ୍‌ନାଂ ।” ");
INSERT INTO peg_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","ମୁଡ଼୍‌ ମାପ୍ରୁହେବାକିନାକାନ୍‌ ନିଙ୍ଗ୍‌ଜି ଜିସୁଙ୍ଗ୍‌ ୱେନ୍‌ବାତାନ୍‌, “ଏନ୍‌ ଇନାକାପା ଉତର୍‌ ହିଉୟା ? ନି ବିରୁଦ୍‌ତ ଇୱାର୍‌ ଇ ସାକି ହିନାରା, ଇଦାଂ ଇନାକା ?” ");
INSERT INTO peg_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","ମାତର୍‌ ଜିସୁ ପ୍ଡକ୍ ମାଚାନ୍‌ । ମୁଡ଼୍‌ ମାପ୍ରୁହେବାକିନାକାନ୍‌ ଇଚାନ୍‌, “ଜିବୁନିଂ ଇସ୍ୱର୍‌ ତର୍‌ଦ ଆନ୍‌ ଜିସୁ ପାର୍ମାଣ୍‌ ହିଜ଼ି ୱେନ୍‍ବାଦ୍‍ନାଙ୍ଗା, ହାତ୍‌ପା ଇନା, ଏନ୍‌ ଇନାକା ଇସ୍ୱର୍ତି ମାଜ଼ି କ୍ରିସ୍ଟ ଇଚିସ୍‌ ମସିୟା ?” ");
INSERT INTO peg_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","ଜିସୁ ଉତର୍‌ ହିତାନ୍‌, “ଏନ୍‌ ଇଚାୟ୍‍ନା । ମାତର୍‌ ଆନ୍‌ ମିଙ୍ଗ୍‌ ୱିଜ଼ାରିଂ ଇଞ୍ଜ୍‌ନାଙ୍ଗା, ବେଗି ମାନାୟ୍‌ ମାଜ଼ି ସାର୍ଗେ ସାକ୍ତିକାଟାକାନ୍‌ ଇସ୍ୱର୍‌ ବୁଜ୍‌ଣି ବାଗାଙ୍ଗ୍‌ କୁଚ୍‌ଚେଂ ହାନାନା, ଆରେ ତାଙ୍ଗ୍‌ ସାର୍ଗେତ ବାଦାଡ଼୍‍ ଲାହାଂ ଜୁଜ଼ି ୱାନାକା ଏପେଙ୍ଗ୍‌ ହୁଡ଼୍‌ନାଦେର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","ହେବେଣ୍ଡାଂ ମୁଡ଼୍‌ ମାପ୍ରୁହେବାକିନାକାନ୍‌ ଜାର୍‌ ହେନ୍ଦ୍ରା କେଚ୍‌ଚି ଇଚାନ୍‌, “ଇୱାନ୍‌ ଇସ୍ୱର୍‌ ନିନ୍ଦା କିତାନ୍‌, ସାକିତ ମାଦାଂ ଆରେ ଇନାକା ଲଡ଼ା ? ହୁଡ଼ାଟ୍‌ ଦାପ୍ରେ ଇୱାନ୍‌ ଇସ୍ୱର୍‌ ନିନ୍ଦା ତ ଏପେଙ୍ଗ୍‌ ୱେଚାଦେର୍ । ");
INSERT INTO peg_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","ଇ ବିସ୍ରେ ମିଦାଙ୍ଗ୍‌ ମାନ୍‌ ଇନାକା ?” ହେୱାର୍‌ ଉତର୍‌ ହିତାର୍‌, “ହେୱାନ୍‌ ପାରାଣ୍‌ ଡାଣ୍ଡ୍‌ ପାୟାନି ବିଦି ।” ");
INSERT INTO peg_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","ତା ପାଚେ ହେୱାର୍‌ ଜିସୁଙ୍ଗ୍‌ ମୁମ୍‌ଦ ଏୱିଡ଼ିଂ ଚୁବ୍‍ଜି ତାଙ୍ଗ୍‌ ମୁଟ୍‌କାକୁନ୍‌ତାର୍‌ । କେତେକ୍‌ ଜାଣ୍‌ ତାଙ୍ଗ୍‌ ଚାପ୍‌ଡ଼ା ଇଡ଼୍‌ଜି ଇଚାର୍‌, ");
INSERT INTO peg_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","“ଏ କ୍ରିସ୍ଟ ଇଚିସ୍‌ ମସିୟା ! ଏନ୍‌ ବେଣ୍‌ବାକ୍‌ଣାୟ୍‌ କିୟା । ଇନେର୍‌ ନିଂ ଇଡ଼୍‌ଦାତାର୍‌, ୱେଚ୍‌ଚା ତ !” ");
INSERT INTO peg_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","ମୁଡ଼୍‌ ମାପ୍ରୁହେବାକିନାକାନ୍‌ ବାର୍ତ ଅହ୍‌ଣାତ ପିତର୍‌ ହାକ୍‌ଡ଼ିତ କୁଚ୍‌ଚି ମାନି ୱେଡ଼ାଲିଂ ରଞ୍ଜେଲ୍‌ ଆଡ଼ିଏଣି ଲାଗେ ୱାଜ଼ି ଇଚାତ୍‌, “ଏନ୍‌ ପା ଗାଲିଲିୟ ଜିସୁ ଲାହାଙ୍ଗ୍‌ ମାଚାୟ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","ମାତର୍‌ ପିତର୍‌ ୱିଜ଼ାକାର୍‌ ମୁମ୍‌ଦ ଇ କାତା ମୁନାକିଜ଼ି ଇଚାନ୍‌, “ଏନ୍‌ ଇନାକା ଇନାୟା, ଆନ୍‌ ପୁନୁଙ୍ଗ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","ଇଦାଂ ଇଞ୍ଜି ହେୱାନ୍‌ ହେ ଅହ୍‍ଣାନି ଦୁୱେର୍‌ କଚଣ୍‌ତ ହାଚାନ୍‌ । ଆରେ ରଞ୍ଜେଲ୍‌ ଚାକର୍‌ଣି ତାଙ୍ଗ୍‌ ହୁଡ଼୍‌ଜି ହେବେ ମାନି ଲକାଂ ଇଚାତ୍‌, “ଇୱାନ୍‌ ନାଜରିତିୟ ଜିସୁ ଲାହାଙ୍ଗ୍‌ ମାଚାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","ପିତର୍‌ ଆରେ ରଗ ମୁନାକିଜ଼ି ଇଚାନ୍‌, “ପାର୍ମାଣ୍‌ କିଜ଼ି ଇନାଙ୍ଗା, ହେୱାନିଂ ଆନ୍‌ ପୁନୁଙ୍ଗ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","ଅଲପ୍‍ ସମୁ ପାଚେ ଲାଗେ ନିଲ୍‌ଚି ମାନି ମାନାୟାର୍‌ ପିତର୍‌ତି ଲାଗାଂ ୱାଜ଼ି ହେୱାନିଂ ଇଚାର୍‌, “ଏନ୍‌ ପା ହାତ୍‌ପା ହେୱାର୍‌ ବିତ୍ରେ ରକାୟ୍‌ । ଇନେକିଦେଂକି ନି କାତାତାଂ ତ ପୁନ୍ୟାନାତା ।” ");
INSERT INTO peg_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","ପିତର୍‌ ଇଚାନ୍‌, “ପାର୍ମାଣ୍‌ କିଜ଼ି ଇନାଙ୍ଗା, ନା କାତା ହାତ୍‌ପା । ଆୱିତିସ୍‌ ଇସ୍ୱର୍‌ ନାଙ୍ଗ୍‌ ଡାଣ୍ଡ୍‌ ହିଦେନ୍ । ହେ ମାନାୟ୍‌ତିଂ ଆନ୍‌ ପୁନୁଙ୍ଗ୍‌ । ଦାପ୍ରେ କୁଜ଼ୁ କ୍ଡେତାତ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","ଆରେ ଜିସୁ ଇନାକା ଇଞ୍ଜି ମାଚାନ୍‌, ପିତର୍‌ ମାନ୍ତ ଏତୁୱାତାତ୍‌; “କୁଜ଼ୁ କେନି ଆଗେ ନାଙ୍ଗ୍‌ ପୁନ୍‍ୱାତାଂନା ଇଞ୍ଜି ଏନ୍‌ ତିନି ହଟ୍‌ କାତା ଇଞ୍ଜ୍‍ନାୟ୍ ।” ହେୱାନ୍‌ ବାର୍ତ ହାଲ୍‌ଜି ବିପ୍ତି ଆଜ଼ି ଆଡ଼୍‌ବାତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","ଆର୍କାତ୍‌ ନାଜିଂ ଉଟ୍‌ଲା ହାକାଡ଼େ ପ୍ରାଚିନାର୍‌ ଜିସୁଙ୍ଗ୍‌ ଅସ୍ତେଙ୍ଗ୍‌ ମୁଡ଼୍‌ ମାପ୍ରୁହେବାକିନାକାର୍‌ ଆରି ଦରମ୍‌ ଗୁରୁର୍‌ ତିର୍‌ କିତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","ଆରେ ହେୱାର୍‌ ତାଙ୍ଗ୍‌ ହାକ୍‌ଡ଼ିତ ଗାଚ୍‌ଚି ରମିୟ ସାସ୍‌ନି ମୁଡ଼୍‌ ନେତା ପିଲାତ ମୁଣିକା କେଇଦ ହେଲାୟ୍‌ କିତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","ହେ ଏଚେକାଡ଼୍‌ଦ ହେୱାନିଂ ସତ୍ରୁ କେଇଦ ହେଲାୟ୍‌ କିତି ଜିହୁଦା ୱେଚାନ୍‍ ଜେ, ଜିସୁଙ୍ଗ୍‌ ହାକି ଡାଣ୍ଡ୍‌ ବଲ୍‌ ଆତାତ୍‌ନ୍ନା, ହେୱାନ୍‌ ମାନ୍‌ବାଦ୍‌ଲାୟ୍‌ କିତାନ୍‌ ଆରି ମୁଡ଼୍‌ ମାପ୍ରୁହେବାକିନାକାର୍‌ ଆରି ବୁଡ଼ାଲୁରିଂ ତିରିସ୍‌ଗଟା ରୁପା ଟାକାଂ ମାସ୍‌ଦି ହିଜ଼ି ଇଚାନ୍‌, ");
INSERT INTO peg_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","“ରକାନ୍ତି ଦସ୍‌ ହିଲ୍‍ୱି ନେତେର୍‌ ହେଲାୟ୍‌ କିଜ଼ି ପାପ୍‌ କିତାଂନ୍ନା ।” ମାତର୍‌ ହେୱାର୍‌ ଇଚାର୍‌, “ହେବେ ମାଦାଂ ଇନାକା ମାନାତ୍‌ ? ଏନ୍‌ ହେଦାଂ ବୁଜାଆ ।” ");
INSERT INTO peg_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","ଜିହୁଦା ହେୱାର୍‌ ହିତ୍‌ତି ରୁପା ଟାକାଂ ମନ୍ଦିର୍‌ତ ବିତ୍ରେ ତୁହିଜି ହାଚାନ୍‌ । ପାଚେ ହେୱାନ୍‌ ହାଲ୍‌ଜି ଗାଡେଲ୍‌ତ ଡରି ଗାଚ୍ୟାଜ଼ି ଉଚ୍‌କା ଆଜ଼ି ହାତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","ମୁଡ଼୍‌ ମାପ୍ରୁହେବାକିନାକାର୍‌ ଟାକାଂ ରୁଣ୍ଡାୟ୍‌ କିଜ଼ି ଇଚାର୍‌, ଇଦାଂ ନେତେର୍‌ନି ଦାମ୍‌ । “ଇଦାଂ ମନ୍ଦିର୍‌ନି କଟିତ ଇଟ୍‌ନି ବିଦି ହିଲୁତ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","ହେ ଦାନ୍‍ଦିଂ ଇନେସ୍‌ କର୍ଚ କିଦେଙ୍ଗ୍‌ ଆଡ୍‌ନାର୍‌, ଇ ବିସ୍ରେ ତିର୍‌ କିଜ଼ି “କୁମ୍‌ରାଂ ବୁମି ତର୍‌ନି ଇଚୁଟିଂ ଜମି କଡ଼୍‍ତାର୍ । ଇଦାଂ ବିଦେସ୍‍ତିର୍ ଦୁଗେର୍‌ ବାହା ଲାକେ ଚିନ୍ତା ଆତାତ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","ନଙ୍ଗ୍‌ ପାତେକ୍‌ “ହେ ବୁମିତିଂ ନେତେର୍‌ ବୁମି” ଇଞ୍ଜି ଇନାରା । ");
INSERT INTO peg_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","ଇ ଲାକେ ବେଣ୍‌ବାକ୍‌ଣାୟ୍‌କିନାକାନ୍‌ ଜିରିମିୟ ଇଞ୍ଜି ମାଚାନ୍‌, ଇମ୍‌ଣାକା “ତିରିସ୍‌ ରୁପା ଟାକାଂ ବେପାର୍‌ କିଦେଙ୍ଗ୍‌ ଇସ୍ରାଏଲ୍‌ କାଡ଼୍‌ଦେର୍‌ ସମାନ୍‌ କିଜ଼ି ମାଚାର୍‌ ହେଦାଂ ଅତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","କଡ଼େଦସ୍‍ ଗଟା ଟାକାଂତାଂ ହେୱାର୍‌ କୁମ୍‌ରାଂ ବୁମି କଡ଼୍‍ତାର୍, ହେୱାର୍‌ ହେ କୁମ୍‌ରେନ୍‌ ଡାବୁଙ୍ଗ୍‌ତାଂ କଡ଼୍‌ଜି ଅତାର୍‌ ଇଦାଂ କିନି କାଜିଂ ନାଙ୍ଗେଙ୍ଗ୍‌ ମାପ୍ରୁ ବଲ୍‌ ହିଜ଼ି ମାନ୍‌ଚାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","ଜିସୁଙ୍ଗ୍‌ ମୁମ୍‌ଦ ହୁଡ଼୍‌ଜି ରମିୟ ରାଜି ପାଲି କିନି ପିଲାତ ୱେନ୍‌ବାତାନ୍‌; “ଏନ୍‌ ଇନାକା ଜିହୁଦିର୍‌ ରାଜା ?” ଜିସୁ ତାଙ୍ଗ୍‌ ଉତର୍‌ ହିତାନ୍‌, ଆଁ “ଏନ୍‌ ହେଦାଂ ଇଚାୟ୍‍ନା ।” ");
INSERT INTO peg_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","ଆରେ, ମୁଡ଼୍‌ ମାପ୍ରୁହେବାକିନାକାର୍‌ ଆରି ପ୍ରାଚିନାର୍‌ ତା ବିରୁଦ୍‌ତ ତାଜ଼ିମାଚି ଦାବାତ ଉତର୍‌ ହେୱାନ୍‌ ଇନାକା ଇନ୍‍ୱାତାନ୍ । ");
INSERT INTO peg_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","ଲାଗିଂ ପିଲାତ ତାଙ୍ଗ୍‌ ଇଚାନ୍‌, “ନି ବିରୁଦ୍‌ତ ହେୱାର୍‌ତି ଦାବା ୱିଜ଼ୁ ଏନ୍‌ ଇନାକା ୱେଞ୍ଜେଙ୍ଗ୍‌ ଆଡୁୟା ?” ");
INSERT INTO peg_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","ମାତର୍‌ ଜିସୁ ତାଙ୍ଗ୍‌ ର କାତାନି ପାଦେକ୍‍ ପା ଉତର୍‌ ହିୱାତାନ୍‌, ହେବେ ସାସନ୍‌କାରିୟା ବେସି କାବା ଆତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","ନିସ୍ତାର୍‌ ପାର୍ବୁ ୱେଡ଼ାଲିଂ ମାନାୟାର୍‌ତି ଇଚା ହୁକେ ରମିୟ ରାଜ୍‌ କିନାକାନ୍‌ ଜେ ରୱାନିଂ ବନ୍ଦି ମାନାକାନିଂ କୁଲାସ୍‌ କିନି ନିତି ମାଚାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","ହେପାଦ୍‌ନା ଜିସୁ ହେୱାର୍‌ ବାରବା ତର୍‌ନି ରୱାନ୍‌ ଡାକ୍‌ପୁଟା ବନ୍ଦି ମାଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","ରୁଣ୍ଡାତି ମାନାୟାରିଂ ପିଲାତ ୱେନ୍‌ବାତାନ୍‌, “ଆନ୍‌ ଇନେରିଂ କୁଲାସ୍‌ କିନାଂ ଇଞ୍ଜି ମି ଇଚା ?” ବାରବାଙ୍ଗ୍‌ କି ଜିସୁ ଇନେରିଂ କ୍ରିସ୍ଟ ଇନାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","ପିଲାତ ହାର୍‌ କିଜ଼ି ପୁଞ୍ଜି ମାଚାନ୍‌ ଜେ ଜିହୁଦିର୍‌ ଆକାର୍‌ ଆଜ଼ି ଜିସୁଙ୍ଗ୍‌ ହେୱାନ୍‌ କେଇଦ ହେଲାୟ୍‌ କିତାର୍ଣ୍ଣା । ");
INSERT INTO peg_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","ପିଲାତ ବିଚାର୍‌ ବାହାତ କୁଚ୍‌ଚିମାଚି ୱେଡ଼ାଲିଂ ତା ଡକ୍ରୁହି ର କାବୁର୍‌ ପକ୍ତାତ୍, “ହେ ଦାର୍ମି ମାନାୟ୍‌ତିଂ ଇନାକା ପା କିମା । ୱିଗା ନାଣାଲିଂ ର କେଚ୍‌କଣ୍‌ତ ତା କାଜିଂ ଆନ୍‌ ବେସି ଦୁକ୍‌ ପାୟା ଆତାଙ୍ଗ୍‌ନା ।” ");
INSERT INTO peg_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","ମାତର୍‌ ମୁଡ଼୍‌ ମାପ୍ରୁହେବାକିନାକାର୍‌ ଆରି ବୁଡ଼ାଲୁର୍‌ ବାରବାଙ୍ଗ୍‌ ଏନ୍ତେଙ୍ଗ୍‌ କାଜିଂ ଆରି ଜିସୁଙ୍ଗ୍‌ ହାକି ଡାଣ୍ଡ୍‌ ହିଦେଂ କାଜିଂ ଲକୁରିଂ ବୁଜାୟ୍‌କିତାର୍ । ");
INSERT INTO peg_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","ପିଲାତ ଆରେ ରଗ ମାନାୟାରିଂ ୱେନ୍‌ବାତାନ୍‌, “ଇ ରିକାର୍‌ ବିତ୍ରେ ଆନ୍‌ ଇନେରିଂ କୁଲାସ୍‌ କିନାଂ ଇଞ୍ଜି ମି ଇଚା ହେୱାର୍‌ ଉତର୍‌ ହିତାର୍‌,” “ବାରବାଙ୍ଗ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","ପିଲାତ ହେୱାରିଂ ୱେନ୍‌ବାତାନ୍‌, “ତେବେ ଇନେରିଂ କ୍ରିସ୍ଟ ଇନାର୍‌, ହେ ଜିସୁ କାଜିଂ ଇନାକା କିନାଂ ?” “ତାଙ୍ଗେଙ୍ଗ୍‌ କ୍ରୁସ୍‌ତ ଦୁପାଟ୍‌” ଇଞ୍ଜି ହେୱାର୍‌ କିର କିତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","ପିଲାତ ୱେନ୍‌ବାତାନ୍‌, “ମାତର୍‌ ହେୱାନ୍‌ ଇନା ଦସ୍‌ କିତାନ୍‌ନ୍ନା ?” ହେୱାର୍‌ ଆରେ କିର କିଜ଼ି ଇଞ୍ଜେଙ୍ଗ୍‌ ଲାଗାତାର୍‌, “ତାଙ୍ଗେଙ୍ଗ୍‌ କ୍ରୁସ୍‌ତ ଦୁପାଟ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","ଲାଗିଂ ପିଲାତ ଏଚେକାଡ଼୍‌ଦ ହୁଡ଼୍‌ତାନ୍‌ ଜେ, ହେୱାନ୍‌ ଇନାକା କିଦେଙ୍ଗ୍‌ ଆଡୁନା, ଆୱିତିସ୍‌ ଆରେ ଗଣ୍ଡ୍‌ଗଲ୍‌ ଆନାତା, ହେ ଏଚେକାଡ଼୍‌ଦ ହେୱାନ୍‌ ଏଜ଼ୁଂ ଅଜ଼ି ଲକୁର୍ ମୁମ୍‌ଦ କେଇ ନୁଜ଼୍‌ଜି ଇଚାନ୍‌, “ଇ ନେତେର୍‌ତ ଆନ୍‌ ଦସି ଆକାୟ୍‌, ଏପେଙ୍ଗ୍‌ ହେଦାଂ ବୁଜାଡୁ ।” ");
INSERT INTO peg_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","ଇବେ ୱିଜ଼ାର୍‌ ଉତର୍‌ ହିତାର୍‌, “ଜିସୁତି ନେତେର୍‌ ମାଙ୍ଗେଙ୍ଗ୍‌ ଆରି ମା ହିମ୍‌ଣାଙ୍ଗ୍‌ ଜପି ଆରେତ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","ହାରିହାରା ପିଲାତ ବାରବାଙ୍ଗ୍‌ ମୁକ୍‌ଡ଼ାୟ୍‌ କିଜ଼ି ଜିସୁଙ୍ଗ୍‌ କର୍‌ଡା ଇଡ଼ି କିଦେଙ୍ଗ୍‌ ବଲ୍‌ ହିତାନ୍‌, ତା ପାଚେ କ୍ରୁସ୍‌ ହାକି କିଦେଙ୍ଗ୍‌ ମେଲ୍ୟାର୍‌ କେଇଦ ପିସ୍ତି ହିତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","ଇଦାଂ ପାଚେ ସାସନ୍‌କିନାକାନିଂ ମେଲ୍ୟାର୍‌ ଜିସୁଙ୍ଗ୍‌ କୁୱାଡ଼୍‍ ବିତ୍ରେ ଅଜ଼ି ହାଲ୍‌ଜି ସବୁ ମେଲ୍ୟାରିଂ ହେୱାନ୍ତି ଲାଗେ ରୁଣ୍ଡାୟ୍‌ କିତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","ଆରେ, ହେୱାର୍‌ ଜିସୁତି ଆଙ୍ଗି ଉନ୍‌ଦି ଅଜ଼ି ହେୱାନିଂ କାହ୍‌ରାତି କାଲାର୍‌ ବାନି ଆଙ୍ଗି ଉସ୍ପି କିତାର୍‌, ");
INSERT INTO peg_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","ଆରେ ୱାଡ଼ି ମୁକୁଟ୍‌ ରଚ୍‌ଚି ହେୱାନ୍ତି କାପ୍‌ଡ଼ାତ ତୁଜ଼ି କିତାର୍‌ ଆରି ହେୱାନ୍ତି ବୁଜ୍‌ଣି କେଇଦ ର ନାଡ଼ା ହିତାର୍‌, ଆରେ ହେୱାନ୍ତି ମୁମ୍‌ଦ ମେଣ୍ଡାଂ କୁନ୍ଦିକିଜ଼ି ଇଚାର୍‌, “ଏ ଜିହୁଦିର୍ତି ରାଜା ଜୱାର୍‌, ଇଦାଂ ଇଞ୍ଜି ହେୱାନିଂ ଗ୍ଡାଇତାର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","ଆରେ, ହେୱାର୍‌ “ହେୱାନ୍‌ ଜପି ଏୱିଡ଼ିଂ ଚୁପ୍‌ତାର୍‌ ଆରି ହେ ନାଡ଼ା ଅଜ଼ି ହେୱାନ୍ତି କାପ୍‌ଡ଼ାତ ଚାପ୍‌ଡ଼ା ଇଡ୍‌ଦେଂ ଲାଗାତାର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","ଆରେ, ହେୱାର୍‌ ହେୱାନିଂ ଗ୍ଡାଇତି ପାଚେ ରାଜାର୍‌ ଆଙ୍ଗି ଉନ୍‌ଦି ଅଜ଼ି ହେୱାନ୍ତି ନିଜାର୍ତି ହେନ୍ଦ୍ରା ଉସ୍ପି କିତାର୍‌ ଆରି ତାଙ୍ଗେଙ୍ଗ୍‌ କ୍ରୁସ୍‌ତ ଦୁପ୍‌ତେଂ ଅଜ଼ି ହାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","ହେୱାର୍‌ ହନି ୱେଡ଼ାଲିଂ ସିମନ୍‌ ତର୍‌ଦି ରକାନ୍‌ କୁରିଣିୟ ବସ୍ତିନିକାନ୍‌ ମାନାୟ୍‌ତିଂ ହୁଡ଼୍‌ଜି ମେଲ୍ୟାର୍‌ ଜିସୁତି କ୍ରୁସ୍‌ ପିଣ୍ଡ୍‌ଦେଂ କାଜିଂ ଟାଟାୟ୍‍ କିତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","ଆରେ, ହେୱାର୍‌ ଗଲ୍‌ଗତା ଇନି ତର୍‌ ବାହାତ, ଇଚିସ୍‌, “ଇନେରିଂ ନିନ୍ଦାଣ୍‌ ବାର୍ତି ବାହା ଇଞ୍ଜି ଇନାର୍‌,” ହେବେ ଏକିସ୍‌, ");
INSERT INTO peg_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","ହେୱାନିଂ କେନିମେହାତି ଅଙ୍ଗୁର୍‌ ରାସ୍‌ ଉଣ୍ଡେଙ୍ଗ୍‌ ହିତାର୍‌, ମତର୍‌ ହେୱାନ୍‌ ହେଦାଂ ୱେଣ୍‍ଜି ଉଣ୍ଡେଙ୍ଗ୍‌ ମାନ୍‌ କିୱାତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","ପାଚେ ହେୱାର୍‌ ହେୱାନିଂ କ୍ରୁସ୍‌ତ ଦୁପ୍‌ଚି ହେୱାନ୍ତି ହେନ୍ଦ୍ରାଙ୍ଗ୍‌ ସବୁ ଦରମ୍‌ଗୁଲି ହୁକେ ଜାର୍‌ ଜାର୍‌ ବିତ୍ରେ ବାଟା କିଜ଼ି ଅତାର୍‌, ");
INSERT INTO peg_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","ଆରେ ହେବେ କୁଚ୍‌ଚି ଜିସୁଙ୍ଗ୍‌ କାସି ମାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","ଆରେ, ହେୱାର୍‌ ହେୱାନ୍ତି କାପ୍‌ଡ଼ାନି ଜପି ଇ ଦାବା ଆକି ଲେକିକିଜ଼ି ଡାଚ୍‍ଚାର୍, “ଇୱାନ୍‌ ଆନାନା ଜିହୁଦିର୍ତି ରାଜା ଜିସୁ ।” ");
INSERT INTO peg_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","ହେ ଏଚେୱାଡ଼ାଂ ହେୱାନ୍ତି ବୁଜ୍‌ଣି ବାଗାଙ୍ଗ୍‌ ରକାନ୍‌ ଆରି ଡେବ୍ରି ବାଗାଙ୍ଗ୍‌ ରକାନିଂ, ଏପେଙ୍ଗ୍‌ ରିକାର୍‌ ଚର୍କୁକାଂ ତା ହୁକେ କ୍ରୁସ୍‌ତ ଦୁପ୍ୟାତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","ଆରେ, ହେ ହାଜ଼ି ହିଜ଼ି ହାଲ୍‍ଜିମାନି ମାନାୟାର୍‌ ଜାର୍‌ ଜାର୍‌ କାପ୍‌ଡ଼ା ତୁକ୍‍ଚି ହେୱାନିଂ ନିନ୍ଦା କିଜ଼ି ଇଞ୍ଜେଙ୍ଗ୍‌ ଲାଗାତାର୍‌, ");
INSERT INTO peg_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“ଡ଼େ ମନ୍ଦିର୍‌ ଡ୍ରିକ୍‌ନିଲଗୁ ଆରି ତିନି ଦିନ୍‌ତାଂ ହେଦାଂ ରଚ୍‍ନିଲଗୁ, ଏନ୍‌ ଏଚେକାଡ଼୍‌ଦ ଇସ୍ୱର୍ତି ମାଜ଼ି, ତେବେ ଜାର୍‌ତିଂ ରାକ୍ୟା କିଜ଼ି କ୍ରୁସ୍‌ତାଂ ଜୁଜ଼ି ୱା ।” ");
INSERT INTO peg_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","ମୁଡ଼୍‌ ମାପ୍ରୁହେବାକିନାକାର୍‌ ପା ହେ ଲାକେ ଦରମ୍‌ ଗୁରୁର୍‌ ଆରି ବୁଡ଼ାଲୁର୍‌ ହୁକେ ନିନ୍ଦା କିଦେଙ୍ଗ୍‌ ଲାଗାତାର୍‌, ");
INSERT INTO peg_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“ହେୱାନ୍‌ ବିନ୍‌ଲଗାଂ ରାକ୍ୟା କିତାନ୍‌, ଜାର୍‌ତିଂ ରାକ୍ୟା କିଦେଙ୍ଗ୍‌ ଆଡୁନା । ହେୱାନ୍‌ ହିନା ଇସ୍ରାଏଲ୍‌ନି ରାଜା, ହେୱାନ୍‌ ଇ ଦାପ୍ରେ କ୍ରୁସ୍‌ତାଂ ଜୁଜ଼ି ୱାୟେନ୍‌, ତେବେ ଆସେଙ୍ଗ୍‌ ହେୱାନ୍‌ ତାକେ ପାର୍ତି କିନାସ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","ହେୱାନ୍‌ ଜାର୍‌ତିଂ ଇସ୍ୱର୍ତି ମାଜ଼ି ଇଞ୍ଜି ଇସ୍ୱର୍‌ ଜପି ବାର୍ସି କିନାନ୍‌, ତା ଆତିସ୍‌ ହୁଡ଼୍‌ନାସ୍‌, ଇସ୍ୱର୍‌ ହେୱାନିଂ ନଙ୍ଗ୍‌ ରାକ୍ୟା କିଦେଙ୍ଗ୍‌ ଇଚା କିନାନ୍‌ କି ଆକାୟ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","ଆରେ, ଇମ୍‌ଣି ଚର୍କୁର୍‍ ହେୱାନ୍ତି ହୁକେ କ୍ରୁସ୍‌ତ ଦୁପ୍ୟା ଆଜ଼ି ମାଚାର୍‌, ହେୱାର୍‌ ପା ହେୱାନିଂ ହେ ଲାକେ ନିନ୍ଦା କିଦେଙ୍ଗ୍‌ ଲାଗାତାର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","ହେ ଦିନ୍‌ ମୁଣ୍ଡାମେଦାନ୍‌ ସମୁତ ବାର ଗଣ୍ଟା ତାଙ୍ଗ୍‌ ତିନି ଗଣ୍ଟା ପାତେକ୍‌ ଦେସ୍‌ ଜାକ୍‌ ମାଜ୍‌ଗା ଆତାତ୍‌, ");
INSERT INTO peg_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","ମ୍ଡିକାହାରେସ୍‌ ତିନି ଗଣ୍ଟା ୱେଡ଼ାଲିଂ ଜିସୁ ଗାଜା କାଟ୍‌ତାଂ ଇଚାନ୍‌, “ଏଲି, ଏଲି, ଲାମା ସବକ୍‍ତାନି ।” ଇଚିସ୍‌ “ଏ ଇସ୍ୱର୍‌, ଏ ଇସ୍ୱର୍‌, ନାଙ୍ଗେଙ୍ଗ୍‌ ଇନେକିଦେଂ ପିସ୍ତାତାୟ୍ ?” ");
INSERT INTO peg_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","ଲାଗେ ନିଲ୍‌ଚିମାନି କେତେକ୍‌ ଜାଣ୍‌ ଇଦାଂ ୱେନ୍‌ଞ୍ଜି ଇଚାର୍‌, “ହେୱାନ୍‌ ଏଲିୟତିଂ କୁକ୍‍ନାନା ।” ");
INSERT INTO peg_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","ହେ ଦାପ୍ରେ ହେୱାର୍‌ ବିତ୍ରେ ରକାନ୍‌ ମାନାୟ୍‌ ହଞ୍ଚି ହାଲ୍‌ଜି କେନିମେହା ଅଙ୍ଗୁର୍‌ ରାସ୍‌ତ ର ରୁଆ କ୍ଡୁକ୍‌ଚି ହେ ନାଡ଼ା ଟିପ୍‍ତ ଗାଚ୍‌ଚି ଉଣ୍ଡେଙ୍ଗ୍‌ ଜିସୁ ନିପ ଲାମାୟ୍‌ କିତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","ମାତର୍‌ ଆଦେକ୍‌ ମାନାୟାର୍‌ ଇଚାର୍‌, “ମାନାଟ୍‌, ଏଲିୟ ଇୱାନିଂ ରାକ୍ୟା କିଦେଙ୍ଗ୍‌ ୱାନାନା କି ଆକାୟ୍‌, ହୁଡ଼୍‌ନାସ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","ଜିସୁ ଆରେ ରଗ ଗାଜା କାଟ୍‌ତାଂ ହିର୍‌ବାତାନ୍‌, ଆରେ ରଗ କିକିରାଡିଂ ହିର୍‌ବିସ୍‌ ଜିବୁନ୍‌ ପିସ୍ତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","ହେୱେଡ଼ାଲିଂ ମନ୍ଦିର୍‌ତ ଜଲାଆନି ହେନ୍ଦ୍ରା ଜପିତାଂ ତାରେନ୍‌ ପାତେକ୍‌ ରି ପାଡ଼ା ଆଜ଼ି କେନ୍‍ଚାତ୍ । ମେଦ୍‌ନି ଦାଲ୍‌କାତାତ୍‌, ଚେଚ୍‌ରାଂ ପାକାଆତିକ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","ଆରି ଦୁଗେର୍‌ ଜେୟା ଆଜ଼ି କେତେକ୍‌ ସାଦୁର୍‌ତି ଗାଗାଡ଼୍‌ ଆରେରଗ ନିଙ୍ଗ୍‌ତାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","ଇୱାର୍‌ ଦୁଗେର୍‌ତାଂ ନିଙ୍ଗ୍‌ଜି ୱାତାର୍ ଆରି ଜିସୁତି ଆରେ ନିଂନାକା ପାଚେ ହେୱାର୍‌ ପୁଇପୁୟା ଗାଡ଼୍‌ ଜିରୁସାଲମ୍‌ତ ହାନାକାର୍ ଆଦେକ୍‌ ହୁଡ଼୍‌ତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","ଜିସୁଙ୍ଗ୍‌ କାସି ମାନି ମୁଡ଼୍‌ମେଲ୍ୟା ଆରି ମେଲ୍ୟାର୍‌ ମେଦ୍‌ନି ଦାଲ୍‍କାନାକା ଆରି ବିନ୍‍ବିନ୍‍ନି ଗିଟାନାକା ହୁଡ଼୍‌ଜି ପାଣ୍ଡ୍ରାତାର୍‌ । ହେୱାର୍‌ ଇଚାର୍‌, “ଇୱେନ୍ ହାତ୍‌ପାନେ ଇସ୍ୱର୍‌ ମାଜ଼ି ମାଚାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","ଗାଲିଲିତାଂ ଜିସୁଙ୍ଗ୍‌ ଡେକ୍‍ଚି ୱାଜ଼ି, ତାଙ୍ଗେଙ୍ଗ୍‌ ହେବା କିଜ଼ି ମାନି ହେନି କଗ୍‌ଲେକ୍‌ ଦେହା ମାନ୍‌ଞ୍ଜି ଇ ୱିଜ଼ୁ ହୁଡ଼୍‌ଜି ମାଚିକ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","ଇୱେକ୍‌ ବିତ୍ରେ ମାଚିକ୍‌ ମଗ୍‌ଦଲିନି ମରିୟମ୍‌, ଜାକୁବ୍‌ ଆରି ଜସେପ୍‌ତି ତେହି ମରିୟମ୍‌ ଆରି ଜେବ୍‌ଦିତି ଡକ୍ରି । ");
INSERT INTO peg_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","ମିଡ଼୍‍କାହାରେସ୍ ହାରାମାତିୟାନି ବସ୍ତିନି ଜସେପ୍‌ ଇନି ରକାନ୍‌ ମାଜାନ୍‌ ଲଗୁ ୱାଜ଼ି ଏକାୱାତାନ୍‌ । ହେୱାନ୍‌ ଜିସୁତି ଚେଲା ଆଜ଼ି ମାଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","ହେୱାନ୍‌ ପିଲାତଂ ବେଟା ଆଜ଼ି ଜିସୁତି ହାତି ଗାଗାଡ଼୍‌ତିଂ ଅଦେଂ କାଜିଂ ଲୱାଡ଼୍‌ ଏନ୍ତାନ୍‌ ଲାଗିଂ ପିଲାତ ଜିସୁତି ହାତି ଗାଗାଡ଼୍‌ ହିଦେଂ । ");
INSERT INTO peg_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","ପିଲାତ ଲୱାଡ଼୍‌ ହିତିଲେ ଜସେପ୍‌ ଜିସୁତି ଗାଗାଡ଼୍‌ତିଂ ଅଜ଼ି ହାଲ୍‌ଜି ର ସକଟ୍‌ କୱାଣ୍‌ ହେନ୍ଦ୍ରା କାଦ୍ୟାତ ହୁର୍ପାତାନ୍ ଆରି ");
INSERT INTO peg_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","ତା ଜାର୍‌ କାଜିଂ କାଲ୍‌ଦ କାର୍ଚି ମାଚି ର ପୁନି ଦୁଗେର୍‌ତ ହେୱାନିଂ ଇଡ୍‌ତାର୍‌ ଆରି ଦୁଗେର୍‌ ଦୁୱେର୍‌ ର ଗାଜା କାଲ୍‌ ପାଡ଼୍‍କ୍‍ଚି ହାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","ମଗ୍‌ଦଲିନି ମରିୟମ୍‌ ଆରି ବିନ୍‌ ମରିୟମ୍‌ ହେବେ ଦୁଗେର୍‌ତ ମୁମ୍‌ କିଜ଼ି କୁଚ୍‌ଚି ମାଚିକ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","ହେ ଆର୍କାତ୍‌ ନାଜିଂ ଇଚିସ୍‌ ଜମ୍‌ନି ନାଜିଂ ମୁଡ଼୍‌ ମାପ୍ରୁହେବାକିନାକାର୍‌ ଆରି ପାରୁସିର୍‌ ପିଲାତଂ ଲାଗେ ବେଟାଆଜ଼ି ଇଚାର୍‌, ");
INSERT INTO peg_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","“ମାପ୍ରୁ ମାଦାଂ ଏତୁ ମାନାତ୍‌, ହେ ମିଚ୍‍ୱା ଜିଜ଼ି ମାନିହିଂ ଇଞ୍ଜି ମାଚାନ୍‌ ‘ତିନି ଦିନ୍‌ ପାଚେ ଆନ୍‌ ଆରେ ନିଙ୍ଗ୍‌ନାଙ୍ଗ୍‌ ।’ ");
INSERT INTO peg_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","ଲାଗିଂ ତିନି ଦିନ୍‌ ପାତେକ୍‌ ହେ ଦୁଗେର୍‌ କାଜିଂ ମାଞ୍ଜେଙ୍ଗ୍‌ ଜାଗ୍‌ୱାଡ଼ାରିଂ ବାଚିକିଜ଼ି ବଲ୍‌ ହିଆ, ଆୱିତିସ୍‌ ତା ଚେଲାର୍‌ ତା ଗାଗାଡ଼୍‌ତିଂ ଚରି କିଜ଼ି ଅଜ଼ି, ହେୱାନ୍‌ ଜିଜ଼ି ନିଙ୍ଗ୍‌ତାନ୍ନା ଇଞ୍ଜି ଇଞ୍ଜେଙ୍ଗ୍‌ ଆଡୁର୍‌ । ହେୱାର୍‌ତି ଇ ମିଚ୍‌ କାତା ଆଗେତାଂ ଆଦିକ୍‌ ସବୁତାଂ ବାନ୍ୟା ଆନାତ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","ପିଲାତ ଉତର୍‌ ହିତାନ୍‌, “ର କୁଦା ଜାଗ୍‌ୱାଡ଼ାରିଂ ଅହାଟ୍‌ ଆରି ହେ ଦୁଗେର୍‌ତିଂ ଇନେସ୍‌ କିଜ଼ି ପା ହାର୍‌ ଇଟ୍‌ନାଦେର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","ହେୱାର୍‌ ହାଲ୍‌ଜି ଦୁଗେର୍‌ତିଂ ଜାଗ୍ରତ୍‌ କିଦେଙ୍ଗ୍‌ ଇଞ୍ଜି ଜାଲ୍‌ଦି କିତାର୍‌ । ହେ ମୁମ୍‌ଦିଂ ଗେସ୍‌ତି ଇଡ଼୍‌ଜି ମାଚି କାଲ୍‌ ଜପି ଚିନ୍‌ ଇଡ଼୍‌ଜି କାନି କାଜିଂ ଜାଗ୍‌ୱାଡ଼ାରିଂ ଇଡ୍‌ତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","ଜମ୍‌ନିବାର୍‌ ୱିସ୍ତି ପାଚେ ସାତ୍‌ଦିନ୍‌ନି ପର୍‌ତୁମ୍‌ ନାଜିଂ ଉଟ୍‌ଲା ହାକାଡ଼େ ମଗ୍‌ଦଲିନି ମରିୟମ୍‌ ଆରି ବିନ୍‌ ମରିୟମ୍‌ ଦୁଗେର୍‌ ହୁଡ଼୍‌ଦେଂ ହାଚିକ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","ହେ ସମୁତ ବେସି ମେଦ୍‌ନିଦାଲ୍‌କାତାତ୍‌, ଇନାକିଦେଂକି ମାପ୍ରୁତି ରୱାନ୍‌ ଦୁତ୍‌ ସାର୍ଗେତାଂ ଜୁଜ଼ି ୱାଜ଼ି ହେ ଦୁଗେର୍‌ ରଚ୍‌ଚିମାଚି କାଲ୍‌ ଗ୍ରୁତ୍‌ତି ତା ଜପି କୁଚ୍‌ଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","ହେୱାନ୍ତି ମୁମ୍‌ ବିଜ୍‌ଲି ଲାକେ ଅଜଡ଼୍‌ ମାଚାତ୍‌ ଆରି ହେୱାନ୍ତି ହେନ୍ଦ୍ରା ଆଞ୍ଜ୍‌ଗା ଲାକେ ଡ଼ିନ୍‍ଜି ମାଚାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","ଆରେ ଦୁତ୍‌ତିଂ ହୁଡ଼୍‌ଜି ଜାଗ୍‌ୱାଡ଼ାର୍‌ ପାଣ୍ଡ୍ରୁତିଂ ତ୍ରିଗ୍‍ତାର୍ ଆରି ହାତି ଲାକେ ଆତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","ସାର୍ଗେ ଦୁତ୍‌ ହେ କଗ୍‌ଲେକାଂ ଇଚାନ୍‌, “ପାଣ୍ଡ୍ରାମାଟ୍ ।” ଆନ୍‌ ପୁନାଙ୍ଗ୍‌, ଏପେଙ୍ଗ୍‌ କ୍ରୁସ୍‌ତ ହାତି ଜିସୁଙ୍ଗ୍‌ ହୁଡ଼୍‌ଦେଂ ୱାତାଦେର୍ଣ୍ଣା । ");
INSERT INTO peg_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","ହେୱାନ୍‌ ଇବେ ହିଲୁନ୍ । ହେୱାନ୍‌ ଇନେସ୍‌ ଇଞ୍ଜି ମାଚାନ୍‌, ହେ ଲାକେ ନିଂତାନ୍ନା । ୱାଡ, ତା ହାତି ମାଡ଼ା ଇମେତାକେ ଇଡ଼୍‌ଜି ମାଚାର୍‌, ହେ ବାହା ହୁଡ଼ାଟ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","“ବେଗି ହାଲ୍‌ଜି ତା ଚେଲାହିରିଂ ୱେଚାଟ୍‌, ‘ହେୱାନ୍‌ ଆରେ ନିଙ୍ଗ୍‌ତାନ୍ନା ଆରି ମି ଆଗେ ହେୱାନ୍‌ ଗାଲିଲିତ ହାଚାନ୍‍ନା । ହେବେ ଏପେଙ୍ଗ୍‌ ତାଙ୍ଗ୍‌ ହୁଡ଼୍‌ନାଦେର୍‌ ।’ ଆନ୍‌ ଇନାକା ଇଞ୍ଚାଙ୍ଗ୍ ହେଦାଂ ମାନ୍ତ ଇଟାଟ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","ଇଦାଂ ୱେନ୍‌ଞ୍ଜି ହେୱେକ୍‌ ବେଗି ଦୁଗେର୍‌ ପିସ୍ତି ଚେଲାର୍‌ ତାକେ କାବୁର୍‌ ହିଦେଂ ହନ୍ତିକ୍ । ପାଣ୍ଡ୍ରା ଆଜ଼ି ପା, ହେୱେକ୍‌ ମାନ୍ତ ବେସି ୱାର୍‌ୟା ଆଜ଼ି ମାଚିକ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","ଆରେ ହୁଡ଼ାଟ୍‌, ଜିସୁ ହେୱାରିଂ ତ୍ରିପ୍‌କୁ ବେଟାଆଜ଼ି ଇଚାନ୍‌, “ମିଦାଙ୍ଗ୍‌ ସୁସ୍ତା ଆୟେତ୍‌ । ହେୱାର୍‌ ତା ଲାଗେ ୱାଜ଼ି ତା ପାନା ଆସ୍ତି ଜୱାର୍‌ କିତାର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","ଜିସୁ ହେୱାରିଂ ଇଚାନ୍‌, “ପାଣ୍ଡ୍ରାମାଟ୍ ନା ଟଣ୍ଡାରିଂ ୱେଚାଟ୍‌, ହେୱାର୍‌ ଗାଲିଲିତ ହାଲେର୍ । ହେବେ ନାଙ୍ଗେଙ୍ଗ୍‌ ହୁଡ଼୍‍ଦାନାର୍ ।” ");
INSERT INTO peg_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","କଗ୍‌ଲେକ୍‌ ହାଲ୍‌ଜି ମାନି ୱେଡ଼ାଲିଂ, ହୁଡ଼ାଟ୍‌, ଜାଗ୍‌ୱାଡ଼ାର୍‌ କୁଦା ବିତ୍ରେତାଂ କେତେକ୍‌ ଜାଣ୍‌ ଗାଡ଼୍‌ଦ ହାଲ୍‌ଜି ହେ ୱିଜ଼ୁ ଗଟ୍‍ଣାନି କାତା ମୁଡ଼୍‌ ମାପ୍ରୁହେବାକିନାକାରିଂ ୱେଚ୍‍ପାତାର୍ । ");
INSERT INTO peg_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","ମୁଡ଼୍‌ ମାପ୍ରୁହେବାକିନାକାର୍‌ ବୁଡ଼ାଲୁର୍‌ ହୁକେ ରୁଣ୍ଡା ଆଜ଼ି ଗାଣ୍‌ଜୁ କିତି ପାଚେ ହେ ମେଲ୍ୟାରିଂ ବେସି ଟାକାଂ ହିଜ଼ି ଇଚାର୍‌, ");
INSERT INTO peg_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","“ଏପେଙ୍ଗ୍‌ ଇନାଟ୍‌, ଆପେଂ ହୁଞ୍ଜିମାଚି ୱେଡ଼ାଲିଂ ତା ଚେଲାହିର୍‌ ନାଣା ୱାଜ଼ି ହେୱାନିଂ ଚରି କିଜ଼ି ଅତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","ଆରେ ଜଦି ସାସନ୍‌ କାର୍‌ୟା ଇ କାତା ୱେନାନ୍‌ ଆପେଂ ତାଙ୍ଗ୍‌ ବୁଜାୟ୍‌ କିନାପ୍‌ ଜେ ନି ଦସ୍‌ ବିର୍‌କୁଲ୍‌ ଆକାୟ୍‌ । ଇ ବିସ୍ରେ ବିପ୍ତି ଆମା ।” ");
INSERT INTO peg_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","ମେଲ୍ୟାର୍‌ ଟାକାଂ ଅଜ଼ି ହେୱାରିଂ ଇଞ୍ଜିମାଚି ସମାନ୍‌ କାମାୟ୍‌ କିତାର୍‌ । ହେୱାର୍‌ ହେ ୱେଡ଼ାଲିଂ ଇନାକା ଇଚାର୍‌, ଜିହୁଦିର୍‌ ନେଞ୍ଜେଙ୍ଗ୍‌ ପାତେକ୍‌ ହେ କାତା ସୁଣାୟ୍‌ କିନାରା । ");
INSERT INTO peg_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","ମାତର୍‌ ଏଗାର୍‌ ଜାଣ୍‌ ଚେଲାର୍‌ ଆଗେ ଗାଲିଲିତ ହାଲ୍‌ଜି, ଜିସୁ ଇମ୍‌ଣି ମାଡ଼ି ବିସ୍ରେ ହାଲ୍‌ଜି ହେୱାରିଂ ଇଞ୍ଜି ମାଚାନ୍‌, ହେ ମାଡ଼ିତ ହାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","ଆରେ, ହେୱାର୍‌ ତାଙ୍ଗ୍‌ ହୁଡ଼୍‌ଜି ଜୱାର୍‌ କିତାର୍‌, ମତର୍‌ ଇନେର୍‌ ଇନେର୍‌ ପାର୍ତି କିୱାତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","ଆରେ, ଜିସୁ ହେୱାର୍‌ ଲାଗେ ୱାଜ଼ି ବେଣ୍‌ କିଜ଼ି ଇଚାନ୍‌, “ସାର୍ଗେ ଆରି ପୁର୍ତିନି ୱିଜ଼ୁ ଆଦିକାର୍‌ ନାଙ୍ଗ୍‌ ହିଦ୍ୟାତାତ୍‍ନ୍ନା । ");
INSERT INTO peg_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","ଲାଗିଂ, ଏପେଙ୍ଗ୍‌ ହାଲ୍‌ଜି ସବୁ ଜାତିନି ମାନାୟାରିଂ ବାୱା, ମାଜ଼ି, ଆରି ପୁଇପୁୟା ଜିବୁନ୍‍ ତର୍‌ଦାଂ ବାପ୍ତିସିମ୍‌ ହିୟାଟ୍‌, ");
INSERT INTO peg_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","ଆନ୍‌ ମିଙ୍ଗ୍‌ ଇମ୍‌ଣି ଇମ୍‌ଣି ବଲ୍‌ ହିତ୍‌ନ୍ନା, ହେ ସବୁ ମାନି କିଦେଙ୍ଗ୍‌ ହିକ୍ୟା ହିଜ଼ି ଆରି ମାନ୍ତ ଇଟାଟ୍‌, ଜୁଗ୍‌ସେସ୍‌ ପାତେକ୍‌ ନିତ୍ରେ ତାଇନାତ୍‌ ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ହାଙ୍ଗ୍‌ ହାଙ୍ଗ୍‌ ମାନାଂ ।”");
INSERT INTO peg_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","ଇସ୍ୱର୍ତି ମାଜ଼ି ଜିସୁ କ୍ରିସ୍ଟତି ନେକ୍ରିକାବୁର୍‌ ଆରମ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","ଜିସାୟ୍‌ ବେଣ୍‌ବାକ୍‌ଣାୟ୍‌କିନାକାନ୍ତି ସାସ୍ତର୍‌ତ ଇନେସ୍‌ ଲେକା ଆତାତ୍‌ନ୍ନା, “ହୁଡ଼ାଟ୍‌, ଆନ୍‌ ନା ଦୁତ୍‌ତିଂ ମି ଆଗେ ପକ୍ତାନାଙ୍ଗା,” “ହେୱାନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ହାଜ଼ି ରଚ୍‌ଚି ହିଦ୍‌ନାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","ବାଟାତ ବେସି ଗାଜାକାଟ୍‌ କିଜ଼ି ହିର୍‌ବାନାକାନ୍ତି କାଟ୍‌, “ମାପ୍ରୁତି ହାଜ଼ି ରଚାଟ୍‍, ହେୱାନ୍ତି ରାଜା ହାକ୍‍ଡ଼ି ହାଣ୍‌କୁ କିୟାଟ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","ପାଚେ ବାପ୍ତିସିମ୍‌ ହିନି ଜହନ୍‌ ବାଲି ବାଟାତ ହାଲ୍‌ଜି ପାପ୍‌ କେମା କାଜିଂ ପାପ୍‍ତାଂ ମାନ୍‌ବାଦ୍‌ଲାୟ୍‌ କିନି “ବାପ୍ତିସିମ୍‌ ସୁଣାୟ୍‌ କିଦେଙ୍ଗ୍‌ ଲାଗାତାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","ହେବେ ସବୁ ରାଜିନି ଜିହୁଦା ଦେସ୍‌ ଆରି ସବୁ ଜିରୁସାଲମ୍‌ନି ମାନାୟାର୍‌ ହସି ହେୱାନ୍‌ ଲାଗାୟ୍‌ ୱାଦେଙ୍ଗ୍‌ ଲାଗାତାର୍‌ ଆରି ଜାର୍‌ ଜାର୍‌ ପାପ୍‌ କିତାକା ମାନିକିିଜ଼ି ହେୱାନ୍‌ତାଂ ଜର୍ଦନ୍‌ ନାଗୁଡ଼୍‌ ତାକେ ବାପ୍ତିସିମ୍‌ ଅତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","ହେ ଜହନ୍‌ ଉଟ୍‌ ତଲ୍‌ନି ହେନ୍ଦ୍ରା ଉସ୍ପିସ୍‌ ମାଚାନ୍‌ ଆରି ତା ମ୍ଡେଙ୍ଗାଙ୍ଗ୍‌ ତଲ୍‍ନି ନୁଣ୍‌କୁ ଡରି ଗାଚ୍‌ଚି ମାଚାନ୍, ପାଚେ ପାମି ଆରେ ରାନ୍ତି ପୁକି ହେୱାନ୍ତି କାଦି ମାଚାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","ଜହନ୍‌ ସୁଣାୟ୍‌ କିଜ଼ି ୱିଜ଼ାକାରିଂ ଉତର୍‌ ହିନାନ୍‌, “ନାଙ୍ଗ୍‌ ତାଙ୍ଗ୍‌; ଇନେର୍‌ ବେସି ସାକ୍ତିକାଟାକାନ୍‌, ହେୱାନ୍‌ ନା ପାଚେ ୱାନାନା; ଆନ୍‌ ତା ସମାନ୍‌ ଆକାୟ୍‌ ହେୱାନ୍ତି ପାନାନି ଡରି ପାଣ୍ଡାଇଙ୍ଗ୍‌ ରିକ୍‌ତେଂ ସମାନ୍‌ ଆକାୟ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ଏଜ଼ୁଂତାଂ ବାପ୍ତିସିମ୍‌ ହିତ୍‌ତାଂ, ମାତର୍‌ ହେୱାନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ପୁଇପୁୟା ଜିବୁନ୍ତାଂ ବାପ୍ତିସିମ୍‌ ହିଦ୍‌ନାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","ହେ ସମୁତ ଜିସୁ ଗାଲିଲିନି ନାଜରିତିୟତାଂ ୱାଜ଼ି ଜର୍ଦନ୍‌ ନାଗୁଡ଼୍‍ତାକେ ଜହନ୍‌ତାଂ ବାପ୍ତିସିମ୍‌ ଅନାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","ଆରେ ହେ ଦାପ୍ରେ ହେୱାନ୍‌ ଏଜ଼ୁଂତାଂ ନିଙ୍ଗ୍‌ଜି ୱାନି ୱେଡ଼ାଲିଂ ବାଦାଡ଼୍‌ ଜେୟା ଆତାତ୍‌ ଆରେ ପୁଇପୁୟା ଜିବୁନ୍‌ତିଂ ପାର୍‌ୱା ଲାକେ ତା ଜପି ଜୁଦ୍‌ନାକା ହୁଡ଼୍‌ତାନ୍‌, ");
INSERT INTO peg_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","ଆରେ, ବାଦାଡ଼୍‌ ତାଙ୍ଗ୍‌ ଇ କାତା ଆତାତ୍‌, “ଏନେଙ୍ଗ୍‌ ନା ୱାରିନି ମାଜ଼ି, ନି ତାକେ ନାତାଂ ବେସି ୱାରି ମାନାତ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","ହେ ଦାପ୍ରେ ପୁଇପୁୟା ଜିବୁନ୍‌ ହେୱାନିଂ ବାଟାତ ଅଜ଼ି ହାଚାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","ଜିସୁ ହେ ବାଟାତ ଚାଲିସ୍‌ ଦିନ୍‌ ମାନ୍‌ଞ୍ଜି ହେବେ ହେୱାନ୍‌ ସୟ୍‌ତାନ୍‌ ହୁଦାଂ ପରିକ୍ୟା ଆନାନ୍‌ । ହେୱାନ୍‌ ରାନ୍‌ ଜାତ୍‌ ଲାହାଙ୍ଗ୍‌ ମାଚାନ୍‌, ଦୁତ୍‌କୁ ହେୱାନିଂ ହେବା କିଜ଼ି ମାଚିକ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","ଜହନ୍‌ ଜେଲ୍‌ତ ହାଚି ପାଚେ, ଜିସୁ ଗାଲିଲିତ ୱାଜ଼ି ଇସ୍ୱର୍‌ତି ନେକ୍ରିକାବୁର୍‌ ଗାଜା କାଟ୍‌ତାଂ ଇଞ୍ଜେଙ୍ଗ୍‌ ଲାଗାତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","“ଜିସୁ ସୁଣାୟ୍‌ କିଦେଙ୍ଗ୍‌ ଲାଗାତାନ୍‌, ଦିନ୍‌ ୱିଜ଼େ ୱାତାତେ, ଇସ୍ୱର୍‌ତି ରାଜି ଲାଗାୟ୍‌ ଆତାତେ; ପାପ୍‍ତାଂ ମାନ୍‌ବାଦ୍‌ଲାୟ୍‌ କିୟାଟ୍‌ ଆରି ନେକ୍ରିକାବୁର୍‌ ତାକେ ପାର୍ତି କିୟାଟ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","ଜିସୁ ଗାଲିଲି ହାମ୍‌ଦୁର୍‌ ପାଡ଼ିତିଂ ହାଲ୍‌ଜି ମାନି ସମୁତ ସିମନ୍‌ ଆରେ ତା ଟଣ୍ଡାହି ଆନ୍ଦ୍ରିୟଙ୍ଗ୍‌ ହାମ୍‌ଦୁର୍‌ତ ଜାଲ୍‌ ତୁହିନାକା ହୁଡ଼୍‌ତାନ୍‌, ଇଚିସ୍‌ ହେୱାର୍‌ ମିନ୍‌କୁ ଆସ୍ତି ଜିନାକାର୍‌ ମାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","ଜିସୁ ହେୱାରିଂ ଇଚାନ୍‌, “ନା ପାଚେ ପାଚେ ୱାଡୁ, ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ମାନାୟ୍‌ ଆହ୍‌ନାକା ହିକାଇ କିଦ୍‌ନାଙ୍ଗ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","ହେବେ ହେୱାର୍‌ ହେ ଦାପ୍ରେ ଜାଲ୍‌ ପିସ୍ତି ହେୱାନ୍‌ ପାଚେ ହାଚାର୍ । ");
INSERT INTO peg_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","ପାଚେ, ହେୱାନ୍‌ ଅଲପ୍‍ ଆଗେ ହାଲ୍‌ଜି ଜାକୁବ୍‌ ଆରି ଜହନ୍‌ ତର୍‌ଦାକାନ୍‌ ଜେବ୍‌ଦିତି ମାଜ଼ି ଜାକୁବ୍‌ ଆରି ହେୱାନ୍‌ ଟଣ୍ଡାହି ଜହନ୍‌ତିଂ ଡଙ୍ଗାତ କୁଚ୍‌ଚି ହେୱାର୍‌ତି ଜାଲ୍‌ ଗାଡ଼ି କିଜ଼ି ମାଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","ହେ ଦାପ୍ରେ ହେୱାନ୍‌ ହେୱାରିଂ କୁକ୍‌ତାନ୍‌, ପାଚେ ହେୱେର୍‌ ହେୱାର୍‌ ଲାତ୍ରାହି ଜେବ୍‌ଦିତି କାମ୍‌ଲିୟାର୍‌ ହୁକେ ଡଙ୍ଗାତାକେ ପିସ୍ତି ହେୱାନ୍‌ ପାଚେ ହାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","ପାଚେ ଜିସୁ ଆରି ଚେଲାର୍‌ କପର୍ନାହୁମ୍‌ ତାକେ ହାଚାର୍‌, ଆରେ ହେ ଦାପ୍ରେ ଜିହୁଦିର୍‌ ଜମ୍‌ନିବାର୍‌ ନାଜିଂ କୁଟୁମ୍‌ ଇଞ୍ଜ ହାଲ୍‌ଜିପା ହିକାୟ୍ କିଦେଙ୍ଗ୍‌ ଲାଗାତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","ମାନାୟାର୍‌ ହେୱାନ୍‌ ହିକ୍ୟାତ କାବା ଆତାର୍‌, ଇନାକିଦେଂକି ହେୱାନ୍‌ ଦରମ୍‌ ଗୁରୁର୍‌ ଲାକେ ହିକାଇ କିୱାଦାଂ ଆଦିକାର୍‌ ପାୟା ଆତି ମାନାୟାର୍‌ ଲାକେ ହେୱାରିଂ ହିକ୍ୟା ହିଜ଼ି ମାଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","ହେ ସମୁତ ହେୱାର୍‌ ଜିହୁଦିର୍‌ କୁଟୁମ୍‌ ଇଞ୍ଜ ମାନି ରକାନ୍‌ ପୁଦା ଆହ୍‌ୟା ଆତାକାନ୍‌ କିକିରାଡିଂ କିଜ଼ି ଗାଜା କାଟ୍‌ତାଂ ଇଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“ଏ ନାଜରିତିୟ ଜିସୁ, ନି ଲାହାଙ୍ଗ୍‌ ମାଦାଂ ଇନାକା ମାନାତ୍‌ ? ଏନେଙ୍ଗ୍‌ ମାଙ୍ଗେଙ୍ଗ୍‌ ୱିସ୍ତେଦେଂ ୱାତାଇନା ? ଏନେଙ୍ଗ୍‌ ଇମ୍‌ଣାକାୟ୍‌ ? ହେଦାଂ ଆନ୍‌ ପୁନାଙ୍ଗ୍‌, ଏନେଙ୍ଗ୍‌ ଇସ୍ୱର୍‌ତି ହେ ପୁଇପୁୟା ମାନାୟ୍‌ତି ।” ");
INSERT INTO peg_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","ଜିସୁ ହେୱାନିଂ ଦାକା ହିଜ଼ି ଇଚାନ୍‌, “ଚିମ୍‌ରା ଆ ଇବେଣ୍ଡାଂ ହସି ହାଲା ।” ");
INSERT INTO peg_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","ହେବେଣ୍ଡାଂ ହେ ବାନ୍ୟା ଜିବୁନ୍‌ ହେୱାନିଂ କିନ୍ଦ୍ରାୟ୍‌ କିଜ଼ି ଗାଜାକାଟ୍‌ ତାଙ୍ଗ୍‌ ଆଲା ଆଜ଼ି ହେୱାନ୍‍ତାଂ ହସି ହାଚାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","ଇବେଣ୍ଡାଂ ୱିଜ଼ାର୍‌ ଏଚେକ୍‌ କାବା ଆତାର୍‌ ଜେ, ହେୱାର୍‌ ହେୱାର୍‌ନେ ଇନ୍‌ବା ଆତାର୍‌, “ଇଦାଂ ଇନାକା ? ଇଦାଂ ତ ଆଦିକାର୍‌ ପୁନ୍‌ ହିକିୟା, ହେୱାନ୍‌ ବାନ୍ୟା ଜିବୁନ୍‌ତିଂ ପା ବଲ୍‌ ହିନାନା, ଆରେ ହେୱାର୍‌ ହେୱାନ୍ତି ବଲ୍‌ବଚନ୍‌ ମାନି କିନିକ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","ହେବେ ହେୱାନ୍‌ ବିସ୍ରେ ବେରଣ୍ ହେ ଦାପ୍ରେ ଗାଲିଲିନିପ ଚାର୍‌ବେଣ୍‌ତିଂ ସବୁ ନାସ୍‌କୁକାଂ ୱିଣ୍‌ଜି ହାଚାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","ତା ପାଚେ ଚେଲାର୍‌ କୁଟୁମ୍‌ ଇଞ୍ଜ ହସି ଜାକୁବ୍‌ ଆରି ଜହନ୍‌ ଲାହାଙ୍ଗ୍‌ ହେ ଦାପ୍ରେ ସିମନ୍‌ ଆରି ଆନ୍ଦ୍ରିୟର୍ ଇଞ୍ଜ ହାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","ସିମନ୍‌ ପଦାହି ନମେର୍‌ ଆଜ଼ି କାଟେଲ୍‌ତ ହୁନ୍‌ଞ୍ଜି ମାଚାତ୍‌, ଆରେ ହେୱାର୍‌ ହେ ଦାପ୍ରେ ହେଦେଲ୍‌ ବେରଣ୍‌ ଜିସୁଙ୍ଗ୍‌ ୱେଚ୍‌ଚାର୍ । ");
INSERT INTO peg_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","ହେବେଣ୍ଡାଂ ହେୱାନ୍‌ ଲାଗାୟ୍‌ ହାଲ୍‌ଜି ହେଦେଲ୍‌ତି କେଇ ଆଜ଼ି ତାଙ୍ଗେଙ୍ଗ୍‌ ନିକ୍‌ତାନ୍‌, ଆରେ ହେଦେଲିଂ ନମେର୍‌ ପିସ୍ତାତ୍‌, ଆରେ ହେଦେଲ୍‌ ହେୱାରିଂ ହେବା କିଦେଙ୍ଗ୍‌ ଲାଗାତାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","ମ୍ଡିକାହାରେସ୍‌ ୱେଡ଼ା ହାଚିପାଚେ ମାନାୟାର୍‌ ହେୱାନ୍‌ ତାକେ ନଚ୍‌ନାକାରିଂ ଆରେ ପୁଦା ଆହ୍‌ୟା ଆତାକାରିଂ ତାହିୱାଦେଂ ଲାଗାତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","ପାଚେ ସବୁ ଗାଡ଼୍‌ନିକାର୍‌ ଇଲ୍‌ନି ଦୁୱେର୍‌ ଲାଗାୟ୍‌ ରୁଣ୍ଡା ଆତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","ହେବେ ଜିସୁ ବାରବିନି ରଗ୍‌ ଆହ୍‌ୟା ଆତାକାରିଂ ବେସି ରଗିରିଂ ଉଜ୍‌ କିତାନ୍‌, ଆରି ବେସି ପୁଦାଂ ପିହିକିତାନ୍‍, ପାଚେ ପୁଦାକାଂ ବେରଣ୍‌ କିଦେଙ୍ଗ୍‌ ହିୱାତାନ୍, ହେଦାଂ କାଜିଂ ହେୱାନିଂ ଚିନ୍‌ କିଜ଼ି ମାଚିକ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","ଆର୍କାତ୍‌ ନାଜିଂ ପ୍ରାଙ୍ଗ୍‌ନି ୱେଡ଼ାଲିଂ ମାଜ୍‌ଗା ମାନୁ ମାନୁ ହେୱାନ୍‌ ନିଙ୍ଗ୍‌ଜି ହସି ହାଚାନ୍‌ ଆରି ର ସିଣିନ୍ଦା ବାହାତ ହାଲ୍‌ଜି ହେବେ ପାର୍ତାନା କିଦେଙ୍ଗ୍‌ ଲାଗାତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","ଆରେ, ସିମନ୍‌ ଆରି ହେୱାନ୍‌ ହାଙ୍ଗ୍‍ଦାକାର୍‍ ହେୱାନିଂ ଇଟ୍‌କାଡ଼୍‌ କିଜ଼ି, ");
INSERT INTO peg_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","ବେଟ୍‌ଗାଟ୍ ଆଜ଼ି ହେୱାନିଂ ଇଚାର୍‌, “ୱିଜ଼ାକାର୍‌ ନିଙ୍ଗେଙ୍ଗ୍‌ ଦାସ୍ତାନାରା ।” ");
INSERT INTO peg_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","ହେବେଣ୍ଡାଂ ହେୱାନ୍‌ ହେୱାରିଂ ଇଚାନ୍‌, ୱାଡ ଆସେଙ୍ଗ୍‌ “ବିନେନି ବାହାତ, ମାତର୍‌ ହାଲ୍‍ଜି ଲାଗେନି ନାସ୍‌କୁକାଂ ହାନାସ୍‌; ହେବେ ପା ଆନ୍‌ ସୁଣାୟ୍‌ କିନାଙ୍ଗ୍‌, ଇନେକିଦେଂକି ଆନ୍‌ ହେ ବେରଣ୍‌ କାଜିଂ ହତ୍‌ତାଂନ୍ନା ।” ");
INSERT INTO peg_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","ପାଚେ ହେୱାନ୍‌ ସବୁ ଗାଲିଲିନିପ ପ୍ଡାଞ୍ଜି ବୁଲା ଆଜ଼ି ହାଲ୍‌ଜି ହେୱାର୍‌ ହେ କୁଟୁମ୍‌ ଇଞ୍ଜ ସୁଣାୟ୍‌ କିତାର୍‌ ଆରି ପୁଦାକାଂ ପିହିକିତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","ଇବେତାଂ ର ଗାଜାରଗ୍‌ କାଟାକାନ୍‌ ଜିସୁ ତାକେ ହେୱାନ୍‌ ୱାଜ଼ି ମେଣ୍ଡାଂ କୁନ୍ଦିକିଜ଼ି ହେୱାନିଂ ଗୱାରି କିଜ଼ି ଇଚାନ୍‌, “ଏନେଙ୍ଗ୍‌ ଜଦି ଇଚା କିତାୟ୍‌ଚି, ତା ଆତିସ୍‌ ନାଙ୍ଗେଙ୍ଗ୍‌ ସକଟ୍‌ କିଦ୍‌ନାୟ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","ହେବେଣ୍ଡାଂ ହେୱାନ୍‌, କାର୍ମା ଆଜ଼ି କେଇ ପେସ୍‌ଦି ହେୱାନିଂ ଡୁତାନ୍‌ ଆରି ଇଚାନ୍‌, “ଆନ୍‌ ଇଚା କିନାଙ୍ଗା ସକଟ୍‌ ଆ ।” ");
INSERT INTO peg_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","ହେ ଦାପ୍ରେ ଗାଜାରଗ୍‌ ହେୱାନ୍ତି ହାଚାତ୍‌ ଆରି ହେୱାନ୍‌ ସକଟ୍‌ ଆତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","ଆରେ, ଜିସୁ ହେୱାନିଂ ବେସି ଆଟ୍‌ୱା କିଜ଼ି ବଲ୍‍ହିଜ଼ି ହେ ଦାପ୍ରେ ପକ୍‌ଚି ଇଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","ଜାଗ୍ରତ୍‌ “ଇନାକା, ଇନେରିଂ ଇନ୍‍ମା, ମାତର୍‌ ହାଲା ମାପ୍ରୁହେବାକିନାକାନ୍‌ ତାକେ ଜାର୍‌ତିଂ ଚଞ୍ଜ୍‌ୟା; ଆରେ ମସା ଇନା ଇନାକା ବଲ୍‌ ହିତ୍‍ତାନ୍ନା ହେ ସବୁ ନିଜେ ନିର୍ମଲ୍‌ ଲାକେ ହେୱାର୍‌ ଲାଗାଂ ସାକି ହିନି କାଜିଂ ସର୍‌ପି ଆ ।” ");
INSERT INTO peg_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","ମାତର୍‌ ହେୱାନ୍‌ ହସି ହାଲ୍‌ଜି ହେ ବିସ୍ରେ ବେସି ସୁଣାୟ୍‌ କିଦେଂ ଲାଗାତାନ୍‌ ଜେ, ଜିସୁ ଆରି ଚଞ୍ଜ୍‌ୟା ଆଜ଼ି ମାଞ୍ଜେଙ୍ଗ୍‌ ଆଡ୍‌ୱାତାନ୍‌, ମାତର୍‌ ବାର୍ତ ସିଣିନ୍ଦା ବାହାତାକେ ମାଚାନ୍‌; ଆରେ ମାନାୟାର୍‌ ଚାର୍‌ବେଣ୍‌ତାଂ ହେୱାନ୍‌ ତାକେ ୱାଦେଙ୍ଗ୍‌ ଲାଗାତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","ଏଚେକ୍‌ ଦିନ୍‌ ପାଚେ, ଜିସୁ ଆରେ ରଗ କପର୍ନାହୁମ୍‌ ମାସ୍‌ଦି ୱାତାନ୍‌, ହେୱାନ୍‌ ଇଞ୍ଜ ମାନାନ୍‌ ଇଞ୍ଜି ୱିଜ଼ାର୍‌ ପୁଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","ହେବେ ଏଚେକ୍‌ ମାନାୟାର୍‌ ରୁଣ୍ଡା ଆତାର୍‌, ଜେ, ଦୁୱେର୍‌ତ ପା ବାହା ହିଲ୍‌ୱାତାତ୍‌, ପାଚେ ହେୱାନ୍‌ ହେୱାର୍‌ ତାକେ ବେରଣ୍‌ ସୁଣାୟ୍‌ କିଦେଙ୍ଗ୍‌ ଲାଗାତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","ଇବେ ପା ମାନାୟାର୍‌ ର ହିରକଲ୍‌ ରଗିଂ ଚାରିଜାଣ୍‌ତାଂ ପିଣ୍ଡ୍‌ଜ଼ି ଜିସୁ ଲାଗାଏ ତାସି ୱାତାର୍‌, ");
INSERT INTO peg_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","ମାତର୍‌ ବିଡ଼୍‌ ଲାଗିଂ ଜିସୁତାକେ ତାସ୍‌ ୱାଦେଂ ଆଡ୍‌ୱିତିଲେ, ହେୱାନ୍‌ ଇମ୍‌ଣି ବାହାତ ମାଚାନ୍‌, ହେବେନି ଚାଉଣି ଜେତାର୍ ଆରି ହେଦାଂ ଡ୍ରିକ୍‌ଚି ହେ କାଟେଲ୍‌ତ ହିର୍‌କଲ୍‌ ଇଡ଼ିୟାତି ରଗି ହୁନ୍‌ଞ୍ଜି ମାଚାନ୍ ହେଦାଂ ଜୁତ୍‌ତାତାର୍ । ");
INSERT INTO peg_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","ଜିସୁ ହେୱାର୍‌ ପାର୍ତି କିନାକା ହୁଡ଼୍‌ଜି ହେ ହିରକଲ୍‌ ରଗିଂ ଇଚାନ୍‌, “ଏ ବପା, ନି ପାପ୍‌ ସବୁ କେମା କିୟା ଆତାତ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","ମାତର୍‌ ଦରମ୍‌ ଗୁରୁର୍‌ ତାଙ୍ଗ୍‌ କେତେଜାଣ୍‌ ହେ ବାହାତ କୁଚ୍‌ଚି ନିଜେ ନିଜେତି ମାନ୍ତ ପୁସୁର୍ ପାସାର୍‍ ଆଜ଼ି ୱେଚ୍‌ପା ଆଜ଼ି ମାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“ଇ ମାନାୟ୍‌ ଇନେକିଦେଂ ଏଲେଙ୍ଗ୍‌ ଇନାନ୍ନା ? ହେୱାନ୍‌ ଇସ୍ୱର୍‌ ନିନ୍ଦା କିନାନା ! ହେଦାଂ ରୱାନିଂ ପିସ୍ତି ଇଚିସ୍‌ ଇସ୍ୱର୍‌ତିଂ ପିସ୍ତି ଆରେ ଇନେନ୍‌ ପାପ୍‌ କେମା କିଦେଙ୍ଗ୍‌ ଆଡ୍‌ନାନ୍‌ !” ");
INSERT INTO peg_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","ହେୱାର୍‌ ଜେ, ମାନ୍ତ ମାନ୍ତ ଏଲେଙ୍ଗ୍‌ ୱେଚ୍‌ପା ଆନାରା, ହେଦାଂ ଜିସୁ ନିଜେ “ହେ ଦାପ୍ରେ ପୁଞ୍ଜି ହେୱାରିଂ ଇଚାନ୍‌, ଏପେଙ୍ଗ୍‌ ଜାର୍‌ ଜାର୍‌ ମାନ୍ତ ଇନେକିଦେଂ ଇ ସବୁ ୱେଚ୍‌ପା ଆନାଦେରା ?” ");
INSERT INTO peg_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","“ଇନାକା ଆଡ଼୍‌ୱା ? ହିରକଲ୍‌ ରଗିଂ ନି ପାପ୍‌ ସବୁ କେମା କିୟା ଆତ୍‌ତାତ୍‌ ଇଞ୍ଜି ଇନାକା, କି ନିଙ୍ଗା, ନି କାଟେଲ୍‌ ଆସ୍ତି ତାଙ୍ଗା ଇଞ୍ଜି ଇନାକା ?” ");
INSERT INTO peg_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","ମାତର୍‌ ପୁର୍ତିତ ପାପ୍‌ କେମା କିଦେଙ୍ଗ୍‌ ମାନାୟ୍‌ ମାଜ଼ି ଜେ ଆନ୍‌, ନା ଆଦିକାର୍‌ ମାନାତ୍‌, ଇଦାଂ ଏପେଙ୍ଗ୍‌ ପୁନାଦେର୍‌ ଇଦାଂ କାଜିଂ ହେ ହିରକଲ୍‌ ରଗିଂ ଇଚାନ୍‌, ");
INSERT INTO peg_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“ଆନ୍‌ ନିଙ୍ଗେଙ୍ଗ୍‌ ଇଞ୍ଜ୍‌ନାଙ୍ଗା, ନିଙ୍ଗା, ନି କାଟେଲ୍‌ ଆସ୍ତି, ମିଞ୍ଜ ହାଲା !” ");
INSERT INTO peg_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","ହେବେତାଂ ହେୱାନ୍‌ ନିଙ୍ଗ୍‌ଜି ହେ ଦାପ୍ରେ କାଟେଲ୍‌ ଆଜ଼ି ୱିଜ଼ାକାର୍‌ ମୁମ୍‌ଦାଂ ହସି ହାଚାନ୍‍; ହେବେ ୱିଜ଼ାର୍‌ କାବା ଆଜ଼ି ଇସ୍ୱର୍‌ତିଂ ଗୁଣ୍‌ କେର୍‌ଜି କେର୍‌ଜି ଇଚାର୍‌, “ଆପେଂ ଏଲେଙ୍ଗ୍‌ ବାର୍ତାକା ଇନାୱାଡ଼ାଂପା ହୁଡ଼୍‍ୱାଦାଂ ମାଚାପ୍‌ !” ");
INSERT INTO peg_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","ହେୱାନ୍‌ ଆରେ ରଗ ଗାଲିଲି ହାମ୍‌ଦୁର୍‌ ଗୁଟିତ ହସି ହାଚାନ୍, ଆରେ ମାନାୟାର୍‌ ତା ତାକେ ୱାତିଲେ, ହେୱାନ୍‌ ହେୱାରିଂ ହିକାୟ୍‍ କିଦେଙ୍ଗ୍‌ ଲାଗାତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","ଆରେ, ହାଲୁ ହାଲୁ ହେୱାନ୍‌ ଆଲପିତି ମାଜ଼ି ଲେବିଙ୍ଗ୍‌ ନିଜ୍‍ ସିସ୍ତୁଏନ୍‌ନାକାନ୍‌ ବାହାତ କୁଚ୍‌ଚି ମାନାକା ହୁଡ଼୍‌ଜି ହେୱାନିଂ ଇଚାନ୍‌, “ନା ପାଚେ ୱା” ହେବେଣ୍ଡାଂ ହେୱାନ୍‌ ତା ପାଚେ ହାଚାନ୍ । ");
INSERT INTO peg_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","ଇଦାଂ ପାଚେ, ଜିସୁ ଲେବିର୍‌ ଇଞ୍ଜ ଚିଞ୍ଜେଙ୍ଗ୍‌ କୁଚ୍‌ନି ୱେଡ଼ାଲିଂ ହେନି ସିସ୍ତୁଏନ୍‌ନାକାର୍‌ ଆରି ପାପିର୍‌ ହେୱାନ୍‌ ଆରି ଜିସୁ ଚେଲାହିର୍‌ ହୁକେ କୁଚ୍‌ଚାନ୍‌; ଇନାକିଦେଂକି ହେୱାର୍‌ ହେନି ମାଚାର୍‌, ଆରି ହେୱାନ୍‌ ପାଚେ ହାଲ୍‌ଜି ମାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","ହେୱାନ୍‌ ପାପିର୍‌ ଆରେ ସିସ୍ତୁଏନ୍‌ନାକାର୍‌ ହୁକେ ତିନ୍‌ଞ୍ଜି ମାଚାନ୍‌, ଇଦାଂ ହୁଡ଼୍‌ଜି ହେୱାନ୍‌ ପାରୁସି ଦଲ୍‌ନି ସାସ୍ତିର୍‌ ହେୱାନ୍‌ ଚେଲାରିଂ ଇଞ୍ଜେଙ୍ଗ୍‌ ଲାଗାତାର୍‌, ଇଦାଂ ଇନାକା ? “ହେୱାନ୍‌ ଗାଚ୍‌ନାକାର୍‌ ହୁକେ ଆରି ପାପିର୍‌ ହୁକେ ରଚେ ତିନାନା ।” ");
INSERT INTO peg_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","ଜିସୁ ହେଦାଂ ୱେନ୍‌ଞ୍ଜି ହେୱାରିଂ ଇଚାନ୍‌, “ଉଜ୍‌ ଆତାକାରିଂ ଡାକ୍ତର୍‌ ଲଡ଼ାଆକାୟ, ମାତର୍‌ ଇନେର୍‌ ନଚ୍‌ନି ମାନାୟ୍‌ତିଂ ହେୱାରିଂ ଡାକ୍ତର୍‌ ଲଡ଼ା ମାନାତ୍‌; ଆନ୍‌ ଦାର୍ମି ଲଗାଂ କୁକ୍‌ତେଂ ଇଞ୍ଜି ୱାୱାତାଂନା, ମାତର୍‌ ପାପିରିଙ୍ଗ୍‌ କୁକ୍‌ତେଂ ୱାତାଂନା ।” ");
INSERT INTO peg_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","ଜହନ୍‌ ଚେଲାହିର୍‌ ଆରେ ପାରୁସିର୍‌ ଉପାସ୍‌ କିିଜ଼ି ମାଚାର୍‌ । “ଏଚେକ୍‌ଜାଣ୍‌ ୱାଜ଼ି ଜିସୁଙ୍ଗ୍‌ ଇଚାର୍‌, ଜହନ୍‌ ଚେଲାହିର୍‌ ଆରେ ପାରୁସିର୍‌ ଚେଲାହିର୍‌ ଉପାସ୍‌ କିତାର୍‌, ମାତର୍‌ ନି ଚେଲାର୍‌ ଉପାସ୍‌ କିଉରୁ ଇନେକିଦେଂ ?” ");
INSERT INTO peg_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","“ଜିସୁ ହେୱାରିଂ ଇଚାନ୍‌, ବିବାକିନାକାର୍‌ ହୁକେ ବିବା ଦାଂଣେନ୍‌ ମାନି ସମୁତ ହେୱାର୍‌ ଇନାକା ଉପାସ୍‌ କିଦେଙ୍ଗ୍‌ ଆଡ୍‌ନାର୍‌ ? ବିବାଦାଂଣେନ୍‌ ଏଚେକ୍‌ ୱେଡ଼ାପାତେକ୍‌ ହେୱାର୍‌ ହୁକେ ମାନାନ୍‌, ହେ ପାତ୍‌ତେକ୍‌ ହେୱାର୍‌ ଉପାସ୍‌ କିଦେଙ୍ଗ୍‌ ଆଡୁର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","ମାତର୍‌ ସମୁ ୱାନାତ୍‌, ଏଚେକାଡ଼୍‌ଦ ହେୱାର୍‌ତାଂ ବିବା ଦାଂଣେନିଂ ନିକ୍‌ଚି ଅୟା ଆନାତ୍‌, ଆରି ହେବେଣ୍ଡାଂ ହେ ଦିନ୍ତ ହେୱାର୍‌ ଉପାସ୍‌ କିତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","ଇନେନ୍‌ ପୁନି ହେନ୍ଦ୍ରାତ ପ୍ଡାନି ହେନ୍ଦ୍ରା ନୁଲ୍‌ ଡ଼ଚୁନ୍‌; ଡ଼ଚ୍‌ଚିସ୍‌ ପୁନି ହେନ୍ଦ୍ରା ମେହାୟ୍ କିତିସ୍‌ ପ୍ଡାନି ହେନ୍ଦ୍ରାତାଂ ବେସି କେଚ୍‌ଚି ଅନାତ୍‌ ଆରି ଆଦିକ୍‌ ଗାଜା ଆଜ଼ି କେନ୍‌ଞ୍ଜି ହାନାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","ଆରି, ଇନେର୍‌ ପୁନି ଅଙ୍ଗୁର୍‌ ରାସ୍‌ ପ୍ଡାନି ତଲ୍‌ ମଣାତ ଇଟୁର୍‌; ଇଟ୍‌ତିସ୍‌ ହେଦାଂ ତଲ୍‌ ମଣା ପାଟ୍‌ଚି ତୁହିନାତ୍‌, ଆରେ ଅଙ୍ଗୁର୍‌ ରାସ୍‌ ଆରି ତଲ୍‌ ମଣା ରିଣ୍ଡାଂ ନସ୍ଟ ଆନିକ୍‌ । ମାତର୍‌ ପୁନି ଅଙ୍ଗୁର୍‌ ରାସ୍‌ ପୁନି ତଲ୍‌ ମଣାତ ଇଟ୍‌ନାକା ମାନାତ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","ଦିନେକ୍‌ ଜିସୁ ଜମ୍‌ନିବାର୍‌ ନାଜିଂ ଜମିପାଚି ନିପ ହାଲ୍‌ଜି ମାଚାନ୍‌, ଆରେ ତା ଚେଲାହିର୍‌, ହାଲୁ ହାଲୁ ତାସ୍‌ନି ଜିକି ନାଟ୍‌ତେଙ୍ଗ୍ ଲାଗାତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","ଇବେଣ୍ଡାଂ ପାରୁସିର୍‌ ହେୱାନିଂ ଇଚାର୍‌, “ହୁଡ଼ା, ଜମ୍‌ନିବାର୍‌ ନାଜିଂ ଇନାକା କିନାକା ବିଦି ହିଲୁତ୍‍, ଚେଲାର୍‌ ଇନେକିଦେଂ ଆନ୍ଦାଂ କିନାରା !” ");
INSERT INTO peg_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","ଜିସୁ ହେୱାରିଂ ଇଚାନ୍‌, ଦାଉଦ୍‌ ନାସ୍‌କି ୱେଡ଼ାଙ୍ଗ୍‌ ଏଚେକାଡ଼୍‌ଦ ହେୱାନ୍‌ ଆରି ତା ହାଙ୍ଗ୍‌ଦାକାର୍‌ ନାସ୍‌କି ଆଜ଼ି ମାଚାର୍‌, ହେ ପାଦ୍‌ନା ହେୱାନ୍‌ ଇନାକା କିଜ଼ି ମାଚାନ୍‌, ହେଦାଂ ଏପେଙ୍ଗ୍‌ ଇନାୱାଡ଼ାଂ ପା ପଡ଼ି କିୱାତାର୍ଣ୍ଣା ? ");
INSERT INTO peg_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","ଅବିୟାତର୍‌ ମୁଡ଼୍‌ ମାପ୍ରୁହେବାକିନାକାର୍‌ ସମୁତ “ହେୱାନ୍‌ ଇନେସ୍‌ ଇସ୍ୱର୍‌ତି ଇଞ୍ଜ ହାଲ୍‌ଜି ମାଚାନ୍‌, ଇମ୍‌ଣି ଦର୍ସନି ରୁଟି ଇସ୍ୱର୍‌ତିଂ ହେବାକିନି ମୁଣିକା ପିସ୍ତି ଆରି ଇନେର୍‌ ତିନି ଆଦିକାର୍‌ ବିଦି ଆକାୟ୍‌, ହେଦାଂ ତିନ୍‌ଞ୍ଜି ମାଚାର୍‌, ପାଚେ ଜାର୍‌ ହାଙ୍ଗ୍‍ଦାକାରିଂ ପା ହିିଜ଼ି ମାଚାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","ଆରି, ହେୱାନ୍‌ ହେୱାରିଂ ଇଚାନ୍‌, ଜମ୍‌ନିବାର୍‌ ଦିନ୍‌ ମାନାୟାର୍‌ କାଜିଂ ଆତାତ୍‌ନ୍ନା, “ମାନାୟାର୍‌ ଜମ୍‌ନିବାର୍‌ କାଜିଂ ଆୱାତାର୍ଣ୍ଣା । ");
INSERT INTO peg_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","ଲାଗିଂ ମାନାୟ୍‌ ମାଜ଼ି ଜମ୍‌ନିବାର୍‌ ନାଜିଂ ପା ମାପ୍ରୁ ଆନାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","ପାଚେ ହେୱାନ୍‌ ଆରେ ରଗ କୁଟୁମ୍‌ ଇଞ୍ଜ ହାଚାନ୍, ହେବେ ରକାନ୍‌ ମାଚାନ୍‌, ହେୱାନ୍ତି ର କେଇ ୱାଜ୍‌ଜି ମାଚାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","ଆରେ, ହେୱାନ୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ଇନେସ୍‌କି ଜମ୍‌ନିବାର୍‌ତ ଉଜ୍‌ କିନାନ୍‌, ହେଦାଂ ହୁଡ଼୍‍ନି କାଜିଂ ଇଞ୍ଜି ହେୱାର୍‌ ହେୱେନିଂ ହୁଡ଼୍‌ଜି ମାଚାର୍‌, ଇନେସ୍‌ ହେୱାର୍‌ ହେୱାନ୍‌ ବିରୁଦ୍‌ତ ଦାବା କିନାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","ହେବେ ଇନେନ୍‌ କେଇ ୱାଜ୍‌ଜି ମାଚାତ୍‌ ହେୱାନିଂ ଜିସୁ ଇଚାନ୍‌, “ୱା ମାଦି ନିଲା ।” ");
INSERT INTO peg_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","ପାଚେ, ହେୱାନ୍‌ ହେୱାରିଂ ଇଚାନ୍‌, “ଜମ୍‌ନିବାର୍‌ତ ଇନାକା କିନାକା ବିଦି ମାନାତ୍‌ ? ହାର୍‌, କିନାକା କି ବାନ୍ୟା କିନାକା ? ଜିବୁନ୍‌ ରାକ୍ୟା କିନାକା କି ନସ୍ଟ କିନାକା ? ମାତର୍‌ ହେୱାର୍‌ ଉତର୍‌ ହିୱାଦାଂ ଚିମ୍‌ରା ଆଜ଼ି ମାଚାର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","ହେବେ ହେୱାନ୍‌ ହେୱାରିଂ ମାନ୍ତ କୁଟ୍‌ ଲାଗିଂ ଦୁକ୍‌ ଆଜ଼ି ରିସାତାଂ ଚାର୍‌ବେଣ୍‌ତାଂ ହେୱାରିଂ ହୁଡ଼୍‌ଜି ହେ ମାନାୟ୍‌ତିଂ ଇଚାନ୍‌, “କେଇ ଲାମାୟ୍‌ କିୟା ।” ହେୱାନ୍‌ କେଇ ଲାମାୟ୍‌ କିତାନ୍‌ ଆରି ହେଦାଂ ଆରେ ହାରା ଆତାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","ହେବେ ପାରୁସିର୍‌ ବାର୍ତ ହାଲ୍‌ଜି ହେୱାନିଂ ବୁଡାୟ୍‌ କିଦେଙ୍ଗ୍‌ ଇଞ୍ଜି ହେୱାନ୍‌ ବିରୁତ୍‌ତାଂ ହେରଦିୟାର୍‌ ରାଜା ଲାହାଙ୍ଗ୍‌ କୁଟ୍‌ କିଦେଙ୍ଗ୍‌ ଲାଗାଆତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","ଇ ୱାଡ଼ାଂ ଜିସୁ ତା ଚେଲାହିର୍‌ ଲାହାଙ୍ଗ୍‌ ବିନେ ଆଜ଼ି ଗାଲିଲି ହାମ୍‌ଦୁର୍‌ତ ହାଚାର୍, ପାଚେ ଗାଲିଲିତାଂ ହେନି ମାନାୟାର୍‌ ତା ପାଚେ ପାଚେ ହାଚାର୍‌; ଆରେ ଜିହୁଦା ରାଜି, ");
INSERT INTO peg_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","ଜିରୁସାଲମ୍‌, ଇଦମ୍‌, ଜର୍ଦନ୍‌ନି ଆଣ୍ଟି ପାଡ଼୍‍କା, ଆରେ ସୋର ଆରି ସିଦନ୍‌ନି ଚାରବେଣ୍‌ତି ବେସି ମାନାୟାର୍‌ ହେୱାନ୍ତି ୱିଜ଼ୁ କାମାୟ୍‌ନି ବେରଣ୍‌ ୱେନ୍‌ଞ୍ଜି ତା ତାକେ ୱାତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","ହେ ପାଦ୍‌ନା ବିଡ଼୍‌ କାଜିଂ, ମାନାୟାର୍‌ ଇନେସ୍‌ ହେୱାନ୍‌ ଜପି କ୍ଡୁସ୍‌ପିସ୍‌ ହାଲୁର୍‌, ଇଦାଂ କାଜିଂ ହେୱାନ୍‌ ନିଜ୍‍ ଚେଲାରିଂ ତା କାଜିଂ ର ହାରୁ ଡଙ୍ଗା ଲାଗେ ଇଡ୍‌ଦେଂ ଇଚାନ୍‌; ");
INSERT INTO peg_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","ଇନାକିଦେଂକି ହେୱାନ୍‌ ହେନି ମାନାୟ୍‌ତିଂ ଉଜ୍‌ କିତିଲେ-ରଗିୟାର୍ ୱିଜ଼ାକାର୍‌ ହେୱାନିଂ ଡୁଦେଂ ଇଞ୍ଜି ହେୱାନ୍‌ ଜପି କ୍ଡୁସ୍ପିସ୍‌ ମାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","ଆରେ, ବାନ୍ୟା ଜିବୁନିଙ୍ଗ୍‌ ଆସ୍ତି ମାନି ଲଗାଙ୍ଗ୍ ହେୱାନିଂ ହୁଡ଼୍‌ଜି ମାଚିକ୍‌, ହେୱାଙ୍ଗ୍‌ ହେୱାନ୍‌ ତାରେନ୍‌ ଗୁର୍‌ଜି କିକିରାଡିଂ କିଜ଼ି ଇଞ୍ଜି ମାଚିକ୍‌, “ଏନେଙ୍ଗ୍‌ ଇସ୍ୱର୍‌ ମାଜ଼ିତି ।” ");
INSERT INTO peg_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","ହେବେତାଂ ତାଙ୍ଗେଙ୍ଗ୍‌ ୱେଚ୍‌ୱି କାଜିଂ ହେୱାନ୍‌ ହେ ବାନ୍ୟା ପୁଦାକାଂ ବେସି ଡାଟ୍‌ କିଜ଼ି ବଲ୍‌ ହିତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","ଜିସୁ ମାଡ଼ି ଜପି ହାଲ୍‌ଜି, ଇମ୍‌ଣାକାରିଂ ମାନ୍‌ କିତାନ୍‌, ହେୱାରିଂ ଲାଗେ କୁକ୍‌ତାନ୍‌ ଆରେ ହେୱାର୍‌ ତା ଲାଗେ ୱାତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","ପାଚେ, ହେୱାନ୍‌ ବାର ଜାଣ୍‌ତିଂ ବାଚିକିତାନ୍‌, ଇନେସ୍‌ ହେୱାର୍‌ ତା ହୁକେ ରଚେ ମାନାର୍‍ ଆରେ ହେୱାନ୍‌, “ହେୱାରିଂ ସୁଣାୟ୍‌ କିନି କାଜିଂ ପକ୍ୟାତାକାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","ଆରି ହେୱାନ୍‌ ହେୱାରିଂ ପୁଦାଂ ପିହି କିନାକା ଆଦିକାର୍‌ ହିତାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","ଜିସୁ ଇ ବାର ଜାଣ୍‌ତିଂ ବାଚିକିତାନ୍‌ ଇଚିସ୍‌, ସିମନ୍‌ତିଂ, ହେୱାନ୍‌ ପିତର୍‌ ଇଞ୍ଜି, ଆରେ ର ତର୍‌ ହିତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","ଜେବ୍‌ଦି ମାଜ଼ି ଜାକୁବ୍‌ ଆରି ତା ଟଣ୍ଡେନ୍‌ ଜହନ୍‌, ଇନେରିଂ ହେୱାନ୍‌ ବିନେରିଗସ୍‌, ଇଚିସ୍‌ “ବାଦାଡ଼୍‌ ଗାର୍ଜାନି ମାଜ଼ି” ଇଞ୍ଜି ଆରେ ର ତର୍‌ ହିତାନ୍‌; ");
INSERT INTO peg_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","ଆନ୍ଦ୍ରିୟ, ପିଲିପ୍‌, ବାର୍ତଲମି, ମାତିଉ, ତମା, ଆଲପିତି ମେହି ଜାକୁବ୍‌, ତଦିୟ, କିଣାନିୟ ସିମନ୍‌, ");
INSERT INTO peg_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ପାଚେ ଇସ୍କାରିୟତିୟ ଜିହୁଦା, ଇନେନ୍‌ ଜିସୁଙ୍ଗ୍‌ ସାତ୍ରୁ କେଇଦ ଆହି କିତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","ପାଚେ ହେୱାନ୍‌ ଇଞ୍ଜ ୱାତାନ୍‌; ଆରେ ରଗ ହେନି ମାନାୟାର୍‌ ରୁଣ୍ଡା ଆଦେଂ ଲାଗାତାର୍ ଜେ, ହେୱାର୍‌ ଚିଞ୍ଜେଙ୍ଗ୍‌ ପା ଆଡ୍‌ୱାତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","ଏଚେକାଡ଼୍‌ଦ ଜିସୁ ଲାତ୍ରା ଇଦାଂ ୱେଚାର୍‌ ହେୱାଡ଼ାଂ ତାହିୱାଦେଂ ହାଚାର୍‌, ଇଚିସ୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ “ବାୟା ଆତାନ୍ନା !” ଇଞ୍ଜି ମାନାୟାର୍‌ କାତାବାର୍ତା ଆଜ଼ି ମାଚାର୍‌, ");
INSERT INTO peg_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","ଆରେ, ଜିରୁସାଲମ୍‌ତାଂ ୱାଜ଼ି ମାନି ଦରମ୍‌ ଗୁରୁର୍‌ ଇଚାର୍‌, “ଇୱାନିଂ ବାଲ୍‌ଜିବୁଲ୍‌ ଲାଗା ଆତାତ୍‌ନ୍ନା, ଆରେ ମୁଡ଼୍‌ ପୁଦାଂତାଂ ଗାଜା ସାକ୍ତି ହେୱାନ୍‌ ପୁଦାଂ ପିହିକିନାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","ଇବେଣ୍ଡାଂ ହେୱାନ୍‌ ହେୱାରିଂ ଲାଗେ କୁକ୍‌ଚି ଉତର୍‌ମୁଡ଼୍‌ କାତା ହେୱାରିଂ ଇଚାନ୍‌, “ସୟ୍‌ତାନ୍‌ ଇନେସ୍‌ କିଜ଼ି ସୟ୍‌ତାନ୍‌ତିଂ ପିହିିକିନାତ୍‌ ?” ");
INSERT INTO peg_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","ଜଦି ଇମ୍‌ଣି ରାଜି ବିନେ ଆଜ଼ି ନିଜ୍‌ତି ବିରୁଦ୍‌ତ ନିଙ୍ଗ୍‌ନାତ୍‌, ହେ ରାଜି ତିର୍‌ ଆଜ଼ି ମାଞ୍ଜେଙ୍ଗ୍‌ ଆଡୁତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","ଆରେ, ଜଦି ଇମ୍‌ଣି ଇଲ୍‌ ବିନେ ଆଜ଼ି ନିଜ୍‍ତି ବିରୁଦ୍‌ତ ନିଙ୍ଗ୍‌ନାତ୍‌, ବାଟିଙ୍ଗ୍‌ ହେ ଇଲ୍‌ ତିର୍‌ ଆଜ଼ି ମାଞ୍ଜେଙ୍ଗ୍‌ ଆଡୁତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","ହେ ଲାକେ, ସୟ୍‌ତାନ୍‌ନି ରାଜି ଜଦି ବିନେ ଆଜ଼ି ନିଜ୍‌ ବିରୁଦ୍‌ତ ନିଙ୍ଗ୍‌ତାତେ, ଲାଗିଂ ହେଦାଂ ତିର୍‌ ଆଜ଼ି ମାଞ୍ଜେଙ୍ଗ୍‌ ଆଡୁତ୍‌, ମାତର୍‌ ହେଦାଂ ୱିଜ଼ୁ ହାକି ଗିଟା ଆତାତେ । ");
INSERT INTO peg_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“ମାତର୍‌ ଇନେର୍‌ ପର୍ତୁମ୍‌ ସାକ୍ତି କାଟାକାନିଂ ଗାଚ୍‌ୱିତିସ୍‌ ହେୱାନ୍‌ ଇଞ୍ଜ ହଣ୍‌ଞ୍ଜି ହେୱାନ୍ତି ଆତ୍‌ ଆତିୟାର୍‌ କ୍ଡିସ୍ତେଙ୍ଗ୍ ଆଡୁନ୍‌; ହେୱାନିଂ ଆଗେ ଗାଚ୍‌ଚିସ୍‌ ହିନା ହେୱାନ୍‌ ତା ଇଞ୍ଜ ଚର୍‌ କିନାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ହାତ୍‌ପା ୱେଚ୍‌ଚାନାଙ୍ଗା, ମାନାୟ୍‌ ମାଜ଼ିର୍‌ ୱିଜ଼ୁ ପାପ୍‌ ଆରି ହେୱାର୍‌ ୱିଜ଼ୁ କୁଟ୍‌ କାତା ଇଞ୍ଜି ଇସ୍ୱର୍‌ତିଂ ନିନ୍ଦା କିତାର୍‌, ହେ ୱିଜ଼ୁ କେମା କିୟାନାତ୍‌; ");
INSERT INTO peg_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","ମାତର୍‌ ଜେ ଇନେର୍‌ ପୁଇପୁୟା ଜିବୁନ୍‌ତିଂ ବିରୁତ୍‌ତାଂ ନିନ୍ଦା କାତା ଇନାନ୍‌, ହେୱାନିଂ ଇମ୍‌ଣି ଜୁଗ୍‌ତପା କେମା ହିଲୁତ୍‌, ମାତର୍‌ ହେୱାନ୍‌ ୱିଜ଼୍‌ୱି ପାପ୍‌ତ ଦସିଆନାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","ଦର୍ମ ସାସ୍ତର୍‌ “ହେୱାନିଂ ବାନ୍ୟାପୁଦା ଆସ୍ତାତ୍‌ନା, ଇଦାଂ ହେୱାର୍‌ ଇଚିଲେ ହେୱାନ୍‌ ଇ କାତା ଇଚାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","ହେପାଦ୍‌ନା ଜିସୁ ତେହି ଆରି ଟଣ୍ଡାହିର୍‌ ୱାଜ଼ି ବାର୍‌ତ ନିଲ୍‌ଚି ହେୱାନିଂ କୁକ୍‌ତେଂ ପକ୍ତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","ହେବେ ତା ଚାରିବେଣ୍‌ତାଂ କୁଚ୍‌ଚି ମାଚି ମାନାୟାର୍‌ ହେୱାନିଂ ଇଚାର୍‌, “ହୁଡ଼ା, ମିଞ୍ଜିୟା, ଟଣ୍ଡେନ୍‌ ଆରି ତଣ୍‌ଦେକ୍‌ ବାର୍‌ତ ମାନ୍‌ଞ୍ଜି ନିଙ୍ଗେଙ୍ଗ୍‌ ଦାସ୍ତାନାରା ।” ");
INSERT INTO peg_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","ହେୱାନ୍‌ ହେୱାରିଂ ଉତର୍‌ ହିତାନ୍‌; ମାଞ୍ଜିୟା ଆରେ ଟଣ୍ଡାର୍‌ ଇନେର୍‌ ? ");
INSERT INTO peg_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","ଆରି, ହେୱାନ୍‌ ଚାର୍‌ବେଣ୍‌ତିଂ କୁଚ୍‌ଚି ମାଚି ମାନାୟାରିଂ ହୁଡ଼୍‌ଜି ଇଚାନ୍‌, “ହୁଡ଼ାଟ୍‌, ଇୱାର୍‌ ନା ଆୟା ଆରେ ନା ଟଣ୍ଡାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","ଇନେର୍‌ପା ଇସ୍ୱର୍‌ନି ଇଚାତିଂ ମାନିକିନାର୍‌, ହେୱାନ୍‌ ନା ଟଣ୍ଡେନ୍‌, ତଣ୍‌ଦେଲ୍‌ ଆରେ ଆୟା ।” ");
INSERT INTO peg_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","ଜିସୁ ଗାଲିଲି ହାମ୍‌ଦୁର୍‌ ଗୁଟିତ ଆରେ ରଗ ହିକାୟ୍‌ ହିଦେଙ୍ଗ୍‌ ଲାଗାତାନ୍‌, ଆରେ ହେନି ମାନାୟାର୍‌ ତା ଲାଗାଂ ରୁଣ୍ଡାଆତାର୍‌ ଜେ ହେୱାନ୍‌ ହାମ୍‌ଦୁର୍‌ତ ମାନି ର ଡଙ୍ଗାତ ହାଲ୍‌ଜି କୁଚ୍‌ଚାନ୍‌ ଆରି ମାନାୟାର୍‌ ହାମ୍‌ଦୁର୍‌ ଲାଗାଂ ର ବୁଇଁତ ମାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","ହେବେଣ୍ଡାଂ ହେୱାନ୍‌ ଉତର୍‌ମୁଡ଼୍‌ ହିଜ଼ି ହେୱାରିଂ ବେସି କାତା ବିସ୍ରେ ହିକ୍ୟା ହିଦେଂ ଲାଗାତାନ୍‌, ପାଚେ ନିଜ୍ ହିକ୍ୟା ବିସ୍ରେ ହେୱାରିଂ ଇଚାନ୍‌ ୱେନାଟ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“ହୁଡ଼ାଟ୍‌, ରୱାନ୍‌ ୱିତ୍‌ନାକାନ୍‌ ୱିଦେଂ ହତ୍‌ତାନ୍ । ");
INSERT INTO peg_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","ହେୱାନ୍‌ ୱିତୁ ୱିତୁ କେତେକ୍‌ ବିୟାନ୍‌ ହାଜ଼ି କଚଣ୍‌ତ ଆର୍‌ନାତ୍‌, ପାଚେ ପଟିଂ ୱାଜ଼ି ହେଦାଂ ତିନିକ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","ଆରେ କେତେକ୍‌ ଅଲପ୍‍ ଚିକ୍‌ଲା ମାନି କାଲ୍‌କୁ କୁଡ଼ିତ ଆର୍‌ନାତ୍‌ ଆରି ବେସି ଚିକ୍‌ଲା ହିଲ୍‍ୱି କାଜିଂ ହାଣ୍ଡେଲ୍‌ ନେସ୍‌ନାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","ମାତର୍‌ ୱେଡ଼ା ହତ୍‌ତିସ୍‌ ମୁର୍‌ଜା ଆନାତ୍‌ ଆରେ ଚିରା ହାର୍‌ କିଜ଼ି ହାଲ୍‌ୱିତି କାଜିଂ ୱାଜ୍‌ଜି ହାଚାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","ଆରେ କେତେକ୍‌ ୱାଡ଼ି କୁଡ଼ିକାଙ୍ଗ୍‌ ଆର୍‌ନାତ୍‌, ଆରେ ୱାଡ଼ିକୁଡ଼ି ନିଙ୍ଗ୍‌ଜି ଗାଜା ଆଜ଼ି, ହେୱାକାଂ ଡାବାୟ୍‌ କିନିକ୍‌ ଆରି ଇନାକାପା ପାଡ଼୍‌ ୱାଉତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","ପାଚେ, ହାର୍‌ଦି ମେଦ୍‌ନିତ ଆର୍‌ନାତ୍‌, ଆରି ନେସ୍‌ଦି ପାନ୍‌ଚି ନିଙ୍ଗ୍‌ଜି ରିକଡ଼ି ଦସ୍‌ ଗାଡ଼୍‌ହା, ତିନ୍‌କଡ଼ି ଗାଡ଼୍‌ହା ଆରେ ପାଞ୍ଚ୍‌କଡ଼ି ଗାଡ଼୍‌ହା ପାତେକ୍‌ ପାଡ଼୍‌ ଆସ୍ତାତ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","ପାଚେ ହେୱାନ୍‌ ଇଚାନ୍‌, “ଇନେରିଂ ୱେଞ୍ଜେଙ୍ଗ୍‌ କିତୁଲ୍‌ ମାନାତ୍‌, ହେୱାନ୍‌ ୱେନେନ୍ ।” ");
INSERT INTO peg_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","ହେୱାନ୍‌ ରକାନ୍‌ ମାନିୱେଡ଼ାଲିଂ ତା ହାଙ୍ଗ୍‍ଦାକାର୍ ବାରଜାଣ୍‌ ଚେଲାର୍‌ ଲାହାଙ୍ଗ୍‌ ହେୱାନିଂ ହେ ଉତର୍‌ମୁଡ଼୍‌କୁ ବିସ୍ରେ ୱେନ୍‌ବେଦେଂ ଲାଗାତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","“ହେବେଣ୍ଡାଂ ହେୱାନ୍‌ ହେୱାରିଂ ଇଚାନ୍‌,” ଇସ୍ୱର୍‌ତି ରାଜିନି ଡ଼ୁକ୍‌ତି କାତା, ପୁଞ୍ଜେଙ୍ଗ୍‌ କାଜିଂ ମିଙ୍ଗେଙ୍ଗ୍‌ ସାକ୍ତି ହିଦ୍‍ୟା ଆତାତ୍‌ନ୍ନା, “ମାତର୍‌ ହେ ବାର୍‌ତି ମାନାୟାରିଂ ସବୁ ବିସ୍ରେ ଉତର୍‌ମୁଡ଼୍‌ ଇନ୍ୟାନାତା, ");
INSERT INTO peg_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","ଇନେସ୍‌ ହେୱାର୍‌ ହୁଡ଼୍‌ଜି ହୁଡ଼୍‌ଜି ବୁଜାଆଦେଂ ଆଡୁର୍‌, ଆରି ୱେନୁ ୱେନୁ ପୁଞ୍ଜେଙ୍ଗ୍‌ ଆଡୁର୍‌, କାତେହିନା ହେୱାର୍‌ ଇସ୍ୱର୍‌ତାକେ ୱାନାର୍‌ ଆରି କେମା ପାୟା ଆନାର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","ହେୱାନ୍‌ ଆରେ ହେୱାରିଂ ଇଚାନ୍‌, “ଏପେଙ୍ଗ୍‌ ଇ କାତା ବୁଜା ଆଉଦେରା କି ? ଲାଗିଂ ଇନେସ୍‌ ବିନେନି ୱିଜ଼ୁ ଉତର୍‌ମୁଡ଼୍‌ ବୁଜା ଆଦେଂ ଆଡ୍‌ନାଦେର୍‌ ? ");
INSERT INTO peg_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","ୱିତ୍‌ନାକାନ୍‌ ଇସ୍ୱର୍‌ତି ବେରଣ୍‌ ୱିତ୍‌ନାନ୍ । ");
INSERT INTO peg_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","ଇନେର୍‌ ୱେନାର୍‌, ଆରେ ୱେଚ୍‌ଚି ଦାପ୍ରେ ସୟ୍‌ତାନ୍‌ ୱାଜ଼ି ହେୱାର୍‌ ତାକେ ୱିତ୍‌ତାକା ବେରଣ୍‌ କିସ୍ତି ଅନାତ୍‌ । ହେୱାର୍‌ ବେରଣ୍‌ ୱିତ୍ୟାଆତି ହାଜ଼ିନି ମେଦ୍‌ନି ଲାକେ । ");
INSERT INTO peg_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","ହେ ଲାକେ, ଇନେର୍‌ ଆଏତ୍‌ ବେରଣ୍‌ ୱେଚ୍‌ଚି ଦାପ୍ରେ ୱାର୍‌ୟା ଆଜ଼ି ହେଦାଂ ମାନି କିତାର୍‌, ");
INSERT INTO peg_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","ମାତର୍‌ ହେୱାର୍‌ ତାକେ ଚିରାବିତ୍ରେ ହାଲ୍‌ୱି କାଜିଂ ଅଲପ୍‍ ଦିନ୍‌ ତିର୍‌ ମାନ୍‌ଗାନାର୍‌, ପାଚେ ବେରଣ୍‌ କାଜିଂ ଦୁକ୍‌ କି ନିନ୍ଦା ୱାତିସ୍‌ ହେ ଦାପ୍ରେ ବାଦାପାୟା ଆନାର୍‌, ହେୱାର୍‌ ୱିତିୟାତି କାଲ୍‌କୁଡ଼ିନି ମେଦ୍‌ନି ଲାକେ । ");
INSERT INTO peg_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","ୱାଡ଼ି କୁଡ଼ିତ ଆର୍‌ତି ବିୟାନ୍‌ ଲାକେ ହେ ନେକ୍ରିକାବୁର୍‌ ଆରେ କେତେଜାଣ୍‌ ୱେନାର୍‌, ");
INSERT INTO peg_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","ମାତର୍‌ ସଁସାର୍‌ନି ଚିନ୍ତା, ଦାନ୍‌ ଲବ୍‌ରା ଆରି ବାରବିନି ଲାବ୍‌ଡ଼ି ହେୱାର୍‌ ମାନ୍‌ତିଂ ଗୁରାୟ୍‌ କିନି କାଜିଂ ହେ କାତା ପାଡ଼୍‌ ପାୟା ଆଉତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","ଆରେ, ଇନେର୍‌ ବେରଣ୍‌ ୱେନ୍‌ଞ୍ଜି ହେଦାଂ ମାନିକିନାର୍‌ ଆରି ରିକଡ଼ିଦସ୍‍ ଗାଡ଼୍‌ହା, ତିନିକଡ଼ି ଗାଡ଼୍‌ହା, ଆରେ ପାଞ୍ଚ୍‍କଡ଼ି ଗାଡ଼୍‌ହା ପାଡ୍‌ ୱାନାତ୍‌, ହେୱାର୍‌ ୱିତିୟା ଆଜ଼ି ମାଚି ହାର୍ଦି ମେଦ୍‌ନି ଲାକେ ।” ");
INSERT INTO peg_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","ଆରେ ରଗ ହେୱାନ୍‌ ହେୱାରିଂ ଇଚାନ୍‌, “ଇନେର୍‌ ଇନାୱାଡ଼ାଂ ବଇଟା ଆହି କିଜ଼ି ମାଣ୍‌ ତାରେନ୍‌ କି କାଟେଲ୍‌ ତାରେନ୍‌ ଇନାକା ଇଟ୍ୟା ଆନାତ୍‌ ? ବଇଟା ଇଟ୍‌ନି ବାହା ଜପି ଇଟ୍‌ଦେଂ ଇଞ୍ଜି ତାହି ୱାୱାକା ? ");
INSERT INTO peg_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","ଇନାକିଦେଂକି ଚଞ୍ଜ୍‌ୟା ଆୱାକା ଇନାକା ଆକାୟ୍‌, ଆରେ ଜଦି ଡ଼ୁକ୍‌ତାତ୍‌ନ୍ନା, ହେଦାଂ ବାର୍ତ ହତ୍‍ତେଂ ଡ଼ୁକ୍‌ତାତ୍‌ନ୍ନା । ");
INSERT INTO peg_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","ଜଦି ଇନେରିଂ ୱେଞ୍ଜେଙ୍ଗ୍‌ କିତୁଲ୍‌ ମାନାତ୍‌, ହେୱେନ୍‌ ୱେନେନ୍ !” ");
INSERT INTO peg_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","ହେୱାନ୍‌ ପାଚେ ହେୱାରିଂ ଇଚାନ୍‌, “ଇନାକା ୱେନାଦେରା, ହେ ବିସ୍ରେ ଜାଗ୍ରତ୍‌ । ଇମ୍‌ଣି ମାଣ୍‍ତାଂ ଲାଚ୍‍ନାସ୍‍, ହେ ମାଣ୍‍ତାଂ ମିଙ୍ଗେଙ୍ଗ୍‌ ଲାଜ୍‌ଜି ହିଦ୍‌ନାତ୍‌, ଆରି ମିଙ୍ଗେଙ୍ଗ୍‌ ଆଦିକ୍‌ ହିଦ୍ୟା ଆନାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","ଇନାକିଦେଂକି ଇନେରିଂ ମାନାତ୍‌, ତାଙ୍ଗ୍‌ ହିୟାଆନାତ୍; ଆରି ଇନେରିଂ ହିଲୁତ୍‌, ତା ତାକେ ଇନାକା ମାନାତ୍‌, ହେଦାଂ ଇସ୍ୱର୍‌ ତାକେଣ୍ଡାଂ ଅନାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","ଆରେ ରଗ ହେୱାନ୍‌ ଇଚାନ୍‌, ଇସ୍ୱର୍‌ତି ରାଜି ଇ ଲାକେ, ରୱାନ୍‌ ଜାର୍‌ ମେଦ୍‌ନିତ ବିୟାନ୍‌ ୱିତ୍‌ନାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","ପାଚେ, ରୱାନ ମାନାୟ୍‌ ନାଣା ହୁନ୍‌ଞ୍ଜ୍‌ନାନ୍‌ ଆରି ଅଜଡ଼୍‌ ଆତିସ୍‌ ଜାଗ୍ରତ୍‌ ଆନାନ୍‌, ଆରି ବିୟାନ୍‌ ଇନେସ୍‌ କିଜ଼ି ନେସ୍‌ଇ ପାନ୍ତାତ୍‌, ହେଦାଂ ହେୱାନ୍‌ ପୁନୁନ୍ । ");
INSERT INTO peg_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","ମେଦ୍‌ନି ନିଜେ ପାଡ଼୍‌ ଆହିକିନାତ୍‌, ପର୍ତୁମ୍‌ ଆକି, ପାଚେ କେନ୍ଦା, ତା ପାଚେ ଜିକିତ ଗଁମ୍‌ ବାର୍ତି । ");
INSERT INTO peg_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","ମାତର୍‌ ତାସ୍‌ ହେନ୍‌ତାତେ ତାସ୍‌ ସମୁ ୱାତିସ୍‌ ହେୱାନ୍‌ କୱେସ୍‌ ଲାହାଙ୍ଗ୍‌ ତ୍ରେସ୍‌ନାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","ଜିସୁ ଆରେ ଇଚାନ୍‌, “ଆସେଙ୍ଗ୍‌ ଇନେର୍‌ ଲାହାଙ୍ଗ୍‌ ଇସ୍ୱର୍‌ ରାଜିତିଂ ଡାଡ଼ାୟ୍‍ କିନାସ୍‌ ? କି ଆରେ ଇମ୍‌ଣି ଉତର୍‌ମୁଡ଼୍‌ତ ହେଦାଂ ବୁଜାୟ୍‌ କିନାସ୍‌ ? ");
INSERT INTO peg_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","ହେଦାଂ ରଞ୍ଜାଙ୍ଗ୍‌ ହାର୍‌ହୁ ମାଞ୍ଜି ଲାକେ; ମେଦ୍‌ନିତ ୱିତିନି ୱାଡ଼ାଙ୍ଗ୍‌ ହେଦାଂ ପୁର୍ତିତ ସବୁ ପାଡ଼୍‍ତାଂ ହାରୁ । ");
INSERT INTO peg_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","ମାତର୍‌ ୱିତିସ୍‌ ହେଦାଂ ପାନ୍‌ଚି ସବୁ କୁଚାତାଂ ଗାଜା ଆନାତ୍‌, ପାଚେ ଡାଡ଼୍‌ ଏଲେଙ୍ଗ୍‌ ଆଜ଼ି ଗାଜା ଗାଜା ଆନିଂ ଜେ, ଆକାସ୍‌ନି ପଟିଂ ହେ ହିତ୍‍ଡ଼ିତ ବାହା କିଦେଙ୍ଗ୍‌ ଆଡ୍‌ନିକ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","ହେୱାନ୍‌ ଇ ଲାକେ ବେସି ଉତର୍‌ମୁଡ଼୍‌ ହୁଦାଂ ହେୱାରିଂ ୱେନ୍‌ଞ୍ଜେଙ୍ଗ୍‌ ବୁଜାଆନି ସାକ୍ତି ସମାନ୍‌ ହେୱେର୍‌ ଲାଗେ ବେରଣ୍‌ ପର୍‌ଚାର୍‌ କିଜ଼ି ମାଚାନ୍‌, ");
INSERT INTO peg_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","ଆରେ ଉତର୍‌ମୁଡ଼୍‌ ୱେଚ୍‍ୱାଦାଂ ହେୱାନ୍‌ ହେୱାର୍‌ ତାକେ ଇମ୍‌ଣି ବେରଣ୍‌ପା ଇନ୍‌ୱାଦାଂ ମାଚାନ୍‌ । ମାତର୍‌ ହେୱାନ୍‌ ବିନେନିକାର୍‌ ହିଲ୍‌ୱି ୱେଡ଼ାଲିଂ କାତା ତାଙ୍ଗ୍‌ ହେ ଚେଲାରିଂ ସବୁ ବିସ୍ରେ ବୁଜାୟ୍‌ କିଜ଼ି ମାଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","ହେଦାଂ କାଜିଂ ମ୍ଡିକାହାରେସ୍‌ ଆତିଲେ ଜିସୁ ହେୱାରିଂ ଇଚାନ୍‌, “ୱାଡୁ, ହାମ୍‌ଦୁର୍‌ ଆନ୍‌ଟି ପାଡ଼୍‌କା ହାନାସ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","ହେବେତାଂ ହେୱାର୍‌ ମାନାୟାରିଂ ପିସ୍ତି, ଜିସୁ ଇମ୍‌ଣି ଡଙ୍ଗାତ ମାଚାନ୍‌, ହେ ଲାକେ ହେୱାନ୍‌ ଡଙ୍ଗା ଲାହାଙ୍ଗ୍‌ ଅଜ଼ି ହାଚାର୍‌, ପାଚେ ବିନ୍‌ ବିନ୍‌ ଡଙ୍ଗାଙ୍ଗ୍‌ପା ହେୱାନ୍‌ ହୁକେ ମାଚିକ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","ଆରି, ତ୍ରିପ୍‌କୁ ହୁଜ଼ାୱାଣି ଆତାତ୍‌, ପାଚେ ଲଡ଼ି ପଡ୍‍ନି କାଜିଂ ଡଙ୍ଗାତ ଏଜ଼ୁଂ ବାର୍ତି ଆଦେଂ ଲାଗିତିକ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","ହେ ଏଚେକାଡ଼୍‌ଦ ହେୱାନ୍‌ ଡଙ୍ଗାନି ପାଚ୍‌ବାଗାଂ ଆକ୍‌ସା କାପ୍‌ଡ଼ା ପାଟାତ ଡୁପ୍‌ଚି ହୁନ୍‌ଜି ମାଚାନ୍‌; ଆରେ ହେୱାର୍‌ ହେୱାନିଂ ନିକ୍‌ଚି ଇଚାର୍‌, “ଏ ଗୁରୁ, ଆପେଂ ହାତାପ୍‌, ନିଙ୍ଗ୍‌ ଇନାକା ଚିନ୍ତା ହିଲୁତ୍‌ ?” ");
INSERT INTO peg_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","ଇବେଣ୍ଡାଂ ହେୱାନ୍‌ ନିଙ୍ଗ୍‌ଜି ଦୁକାତିଙ୍ଗ୍‌ ଦାକା ହିଜ଼ି ଲଡ଼ିତିଂ ଇଚାନ୍‌, “ପ୍ଡକ୍‌ ଇନା, ଚିମ୍‌ରା !” ହେବେଣ୍ଡାଂ ଦୁକା ମଦା ଆତାତ୍‌ ଆରେ ସବୁ ତିର୍‌ ଆତାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","ଆରେ, ହେୱାନ୍‌ ହେୱାରିଂ ଇଚାନ୍‌, ଏପେଙ୍ଗ୍‌ “ଇନେକିଦେଂ ଏଚେକ୍‌ ଡ୍ରିକୁଣା କାଦେର୍‌ ? ଇଦାଂ ! ଇନାକା ମିଙ୍ଗେଙ୍ଗ୍‌ ପାର୍ତି ହିଲୁତ୍‌ ?” ");
INSERT INTO peg_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","ହେବେ ହେୱାର୍‌ ବେସି ପାଣ୍ଡ୍ରା ଆଜ଼ି ହେୱେର୍‌ ହେୱାର୍‌ ୱେଚ୍‌ପା ଆଦେଂ ଲାଗାତାର୍‌, “ଇୱାନ୍‌ ଜେ ଇନେନ୍‌ ? ଦୁକା ଆରେ ହାମ୍‌ଦୁର୍‌ ରିଣ୍ଡାଂପା ଇୱାନ୍‌ ବଲ୍‌ ମାନି କିନିକା !” ");
INSERT INTO peg_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","ପାଚେ ଜିସୁ ଚେଲାହିର୍‌ ଗାଲିଲି ହାମ୍‌ଦୁର୍‌ ଆନ୍‌ଟି ପାଡ଼ାକା ଗରାସିୟର୍‌ ମାନି ନାସ୍ତ ଏକାତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","ଜିସୁ ଡଙ୍ଗାତାଂ ଜୁତି ଦାପ୍ରେ ର ବାନ୍ୟା ଜିବୁନ୍ ଆତାକାନ୍‌ ଦୁଗେର୍‌ ତାଙ୍ଗ୍‌ ହତ୍‌ତାନ୍ ଆରେ ହେୱାନିଂ ଗିଟା ଆତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","ହେୱାନ୍‌ ଦୁଗେର୍‌ତ ବାହା କିଜ଼ି ମାଚାନ୍‌, ହେୱାନିଂ ଆରେ ଇନେର୍‌ ହିକ୍‌ଡ଼ିଂ ଗାଚ୍‌ଚେଙ୍ଗ୍‌ ଆଡ୍‌ୱାଦାଂ ମାଚାର୍‌, ");
INSERT INTO peg_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","ହେୱାନ୍‌ ବେସିହଟ୍‌ ହିକ୍‌ଡ଼ିଂ ଆରେ କାଗଡ଼ା ଗାଚ୍‌ପିସ୍‌ ମାଚାର୍‌, ହେୱାନ୍‌ ହିକ୍‌ଡ଼ିଂ ନାଟ୍‌ଚି ଗନ୍ଦା ଗନ୍ଦା କିଜ଼ି ଡ୍ରିପ୍‌କିସ୍‌ ମାଚାନ୍‌, ଆରେ ହେୱାନିଂ ଇନେର୍‌ ଗାଚ୍‌ଚେଙ୍ଗ୍‌ ସାକ୍ତି ହିଲ୍‌ୱାତାତ୍ ");
INSERT INTO peg_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","ହେୱାନ୍‌ ନାଣା ୱେଡ଼ା ସବୁ ୱେଡ଼ାଙ୍ଗ୍‌ ଦୁଗେର୍‌ ତାକେ ଆରେ ମାଡ଼ିଜପି ମାନ୍‌ଞ୍ଜି କିର୍‌ଡ଼ିପାଡ଼ି କିଜ଼ି ମାଚାନ୍‌, ପାଚେ କାଲ୍‌ହୁକେ ଜାର୍‌ ଗାଗାଡ଼୍‌ତିଂ ଗାୱାଦାୱ୍‌ କିଜ଼ି ମାଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","ହେୱାନ୍‌ ଜିସୁଙ୍ଗ୍‌ ଦେହାତାଂ ହୁଡ଼୍‌ଜି ହନ୍‌ଚି ୱାଜ଼ି ତାଙ୍ଗେଙ୍ଗ୍‌ ଜୱାର୍‌ କିତାନ୍‌, ");
INSERT INTO peg_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","ଆରେ ଗାଜା କାଟ୍‌ତାଂ କିକିରାଡିଂ ଆଜ଼ି ଇଚାନ୍‌, “ଏ ସତ୍‌ତି ଗାଜା ଇସ୍ୱର୍‌ ମେହି ଜିସୁ ! ନି ହୁଦାଂ ନାଦି ଇନାକା ମାନାତ୍‌ ? ନିଙ୍ଗେଙ୍ଗ୍‌ ଇସ୍ୱର୍‌ ତର୍‌ଦାଂ ରାଣ୍‌ ହିଦ୍‌ନାଙ୍ଗା, ନାଙ୍ଗେଙ୍ଗ୍‌ କସ୍ଟ ହିଦ୍‍ମା !” ");
INSERT INTO peg_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","ଲାଗିଂ ଜିସୁ ହେୱାନିଂ ଇଞ୍ଜେଙ୍ଗ୍‌ ହାଲ୍‌ଜି ମାଚାନ୍‌, “ଆଡ଼େ ବାନ୍ୟା ପୁଦା, ଇ ମାନାୟ୍‌ ତାକେଣ୍ଡାଂ ହସି ହାଲା !” ");
INSERT INTO peg_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","ଆରେ, ଜିସୁ ହେୱାନିଂ ୱେନ୍‌ବାତାନ୍‌, “ନି ତର୍‌ ଇନା ତର୍‌ ? ହେୱାନ୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ଇଚାନ୍‌, ନା ତର୍‌ ‘ବାହିନି’ ଲାଗିଂ ଆପେଂ ହେନି !” ");
INSERT INTO peg_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","ପାଚେ, ହେୱାନ୍‌ ହେଦାଂ କାଜିଂ ହେୱାରିଂ ହେ ବାର୍‌ତ ଅଲ୍‌ଗା ନାସ୍‌ ପକ୍‌ୱାଦାଂ ମାଚାନ୍‌, ହେଦାଂ କାଜିଂ ହେୱାନ୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ବେସି ଗୱାରି କିତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","ହେବେ ମାଡ଼ି କନାତ ପାଞ୍ଜିଙ୍ଗ୍‌ ର ମାନ୍ଦା ହାରା ଆଜ଼ି ମାଚିକ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","ଆରେ, ହେୱାଙ୍ଗ୍‌ ଜିସୁଙ୍ଗ୍‌ ଗୱାରି କିଜ଼ି ଇଚିକ୍‌, “ହେ ପାଞ୍ଜିଙ୍ଗ୍‍ ବିତ୍ରେ ହଣିକାଜିଙ୍ଗ୍‍ ମାଙ୍ଗେଙ୍ଗ୍‌ ତା ତାକେ ପକ୍‌ତା ।” ");
INSERT INTO peg_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","ହେୱାନ୍‌ ହେୱାରିଂ ହେଲ ହିତିଲେ, ବାନ୍ୟା ଜିବୁନିଙ୍ଗ୍‌ ହସି ପାଞ୍ଜିଙ୍ଗ୍‌ ବିତ୍ରେ ହଟିକ୍‌; ହେବେ ହେବେଣ୍ଡାଂ ହେ ମାନ୍ଦା ବେସି ତାନ୍ଦ୍ରାତାଙ୍ଗ୍ ହନ୍‍ଚିହାଲ୍‍ଜି ହାମ୍‌ଦୁର୍‌ ଗୁଟିତାଂ ଆର୍ଜି ମୁନ୍ଞ୍ଜି ହାତିଙ୍ଗ୍‌ । ୱିଜ଼ୁ ପାଞ୍ଜିଙ୍ଗ୍‌ ଆନ୍‌ମାନ୍‌ତାଂ ରି ହାଜାର୍‌ ମାଚିକ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","ହେୱାକାଂ ହାରାଇ କିଜ଼ି ମାଚି ମାନାୟ୍‌ ହଞ୍ଚି ହାଲ୍‌ଜି ଗାଡ଼୍‌ଦ ଆରେ ନାସ୍‌କୁକାଂ ୱେଚ୍‌ଚାର୍; ହେବେ ଲକୁ ଇନାକା ଗିଟା ଆତାତ୍‌ନ୍ନା ଇଞ୍ଜି ହୁଡ଼ୁଗା ୱାତାର୍ । ");
INSERT INTO peg_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","ଆରେ, ହେୱାର୍‌ ଜିସୁ ତାକେ ୱାଜ଼ି ହେ ପୁଦା ଡୁୟାଆତାକାନ୍‍, ଇଚିସ୍‌, ଇନେରିଂ ହିଗ୍‌ଦ ବାହିନି ପୁଦା ଡୁଜ଼ି ମାଚାତ୍‌, ହେୱାନ୍‌ ହେନ୍ଦ୍ରା ଉସ୍ପିସ୍‌ ହାର୍ଦି ମାନ୍ତ କୁଚ୍‌ଚି ମାନାକା ହୁଡ଼୍‌ଜି ପାଣ୍ଡ୍ରା ଆତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","ଆରେ, ଇନେର୍‌ ହୁଡ଼୍‌ଜି ମାଚାର୍‌, ହେୱାର୍‌ ହେ ପୁଦା ଆହ୍‌ୟା ଆତାକାନ୍‌ କାଜିଂ ଇନାକା ଗିଟା ଆଜ଼ି ମାଚାତ୍‌, ହେଦାଂ ଆରି ପାଞ୍ଜିଙ୍ଗ୍‌ ବିସ୍ରେ ହେୱାର୍‌ ତାକେ ହାଲ୍‌ଜି ବେରଣ୍‌ ୱେଚ୍‌ଚେଙ୍ଗ୍‌ ଲାଗାତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","ହେବେଣ୍ଡାଂ ହେୱେର୍‌ ହେୱାର୍‌ ହାନ୍ଦିତାଂ ହାଞ୍ଜେଙ୍ଗ୍‌ ଜିସୁଙ୍ଗ୍‌ ଗୱାରି କିଦେଙ୍ଗ୍‌ ଲାଗାତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","ପାଚେ ହେୱାନ୍‌ ଡଙ୍ଗାତ ଦୁମ୍‌ନି ୱେଡ଼ାଲିଂ, ଇମ୍‌ଣି ମାନାୟ୍‌ତିଂ ଆଗେ ପୁଦା ଆସ୍ତି ମାଚାତ୍‌, “ଜିସୁ ତା ଲାହାଂ ମାନି କାଜିଂ ଚାନେକ୍‌ ଚାନେକ୍‌ ଗୱାରି କିତାନ୍‌ !” ");
INSERT INTO peg_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","ମାତର୍‌ ଜିସୁ ହେଲ ହିୱାଦାଂ ତାଙ୍ଗେଙ୍ଗ୍‌ ଇଚାନ୍‌, “ମି ଇଞ୍ଜ, ମି ୱାସ୍କିନିକାର୍‌ ତାକେ ହାଲା, ପାଚେ ମାପ୍ରୁ ନି କାଜିଂ ଇନା ଇନାକା କାମାୟ୍‌ କିତାତ୍‌ନା ଆରି ନି କାଜିଂ ଇମ୍‌ଣି ଦୟା ଚଚାତାତ୍‌ନା, ହେ ସବୁ ହେୱାରିଂ ୱେଚା ।” ");
INSERT INTO peg_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","ତା ପାଚେ ହେୱାନ୍‌ ହାଲ୍‌ଜି, ଜିସୁ ହେୱାନ୍‌ କାଜିଂ ଇମ୍‌ଣି ଇମ୍‌ଣି କାମାୟ୍‌ କିଜ଼ି ମାଚାନ୍‌, ହେ କାମାୟ୍‌ ଦେକାପଲି, ଇଚିସ୍‌ ଦସ୍‌ଗଟା ଗାଡ଼୍‌ତ ସୁଣାୟ୍‌ କିଦେଙ୍ଗ୍‌ ଲାଗାତାନ୍‌, ହେବେ ୱିଜ଼ାକାର୍‌ ୱେନ୍‌ଞ୍ଜି କାବା ଆତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","ଜିସୁ ଡଙ୍ଗାତାଂ ନାସି ଆରେ ରଗ ଉଲ୍‌ଟି ୱାତାନ୍‌, ତା ପାଚେ ହାମ୍‌ଦୁର୍‌ ଗୁଟିତ ମାନି ସମୁତ ବେସି ହେନି ଲକୁ ତା ଲାଗେ ରୁଣ୍ଡା ଆତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","ହେ ପାଦ୍‌ନା ନାଟି କୁଟୁମ୍‌ ଇଲ୍‌ ମୁଣିକା ବିତ୍ରେ ଜାଇରସ୍‌ ତର୍‌ଦାକାନ୍‌ ରକାନ୍‌ ୱାଜ଼ି ହେୱାନିଂ ହୁଡ଼୍‌ଜି କାଲ୍‌କୁ ତାରେନ୍‌ ଡାଣ୍ଡାହାଣ୍‌ ମାକ୍‌ତାନ୍, ");
INSERT INTO peg_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","“ଆରେ ବେସି ଗୱାରି କିଜ଼ି ଇଚାନ୍‌, ନା ଗାଡ଼୍‌ ହାତିଲାକେ, ହେଦେଲ୍‌ ଇନେସ୍‌ ରାକ୍ୟା ପାୟାଜ଼ି ଜିନାତ୍‌, ହେଦାଂ କାଜିଂ ଏନେଙ୍ଗ୍‌ ୱାଜ଼ି ତାଙ୍ଗେଙ୍ଗ୍‌ କେଇ ଡୁୱା ।” ");
INSERT INTO peg_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","ଇବେଣ୍ଡାଂ ହେୱାନ୍‌ ତା ହୁଦାଂ ହାଚାନ୍‌, ଆରି ବେସିହେନି ମାନାୟ୍‌ ହେୱାନ୍‌ ପାଚେ ପାଚେ ହାଞ୍ଜେଙ୍ଗ୍‌ ଲାଗାତାର୍‌, ଆରେ ହେୱାର୍‌ ତା ଜପି କୁସ୍‌ପିସ୍‌ ମାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","ହେ ପାଦ୍‌ନା ବାର ବାର୍ହୁ ପାତେକ୍‌ ଗାଗାଡ଼୍‌ ନାଡ୍‌ୱି ରଗ୍‌ନି ର କଗ୍‌ଲେ, ");
INSERT INTO peg_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","ଇନେସ୍‌କି ବେସି ଡାକ୍ତର୍‌ ତାଂ ବେସି ଦୁକ୍‌ପାୟା ଆଜ଼ି ଦାନ୍‌ ୱିସ୍ତିଲେପା ଅଲପ୍‍ ପା ହାରା ଆୱାଦାଂ ତାଦେଲ୍‌ ଆଦିକ୍‌ ବେମାର୍‌ ଆଜ଼ି ମାଚାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","ହେଦେଲ୍‌ ଜିସୁ ବେରଣ୍‌ ୱେନ୍‌ଞ୍ଜି ମାନାୟ୍‌ ବିତ୍ରେ ପାଚ୍‌ ବାଗାଙ୍ଗ୍‌ ୱାଜ଼ି ହେୱାନ୍‌ ହେନ୍ଦ୍ରାନି ଚେଲିଂ ଡୁତାତ୍‌, ଇନାକିଦେଂକି ହେଦେଲ୍‌ ଇଞ୍ଜି ମାଚାତ୍‌, ");
INSERT INTO peg_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","“ମାତର୍‍ଜେ ହେ ହେନ୍ଦ୍ରା ଡ଼ୁତାଂଚି ଆନ୍‌ ଉଜ୍‌ ଆନାଙ୍ଗ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","ହେ ଦାପ୍ରେ ତା ନେତେର୍‌ ହନାକା ଟେବା ଆତାତ୍‌, ଆରେ ହେଦେଲ୍‌ ଜେ ରଗ୍‌ତାଂ ଉଜ୍‌ ଆତାତ୍‌ନ୍ନା, ଇଦାଂ ହେଦେଲ୍‌ ତା ଗାଗାଡ଼୍‌ତ ପୁଚାତ୍‍ । ");
INSERT INTO peg_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","ହେ ଦାପ୍ରେ ଜିସୁ ତାଙ୍ଗ୍‌ ସାକ୍ତି ହଜ଼ି ହାନାକା ମାନ୍ତ ପୁଞ୍ଜି, ମାନାୟ୍‌ ବିତ୍ରେ ଜେଣ୍‌ପାଡ଼୍‌କା ମାସ୍‌ଦି ଇଚାନ୍‌, “ଇନେର୍‌ ନା ହେନ୍ଦ୍ରା ଡୁତ୍‌ତାର୍‌ ?” ");
INSERT INTO peg_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","ତା ଚେଲାହିର୍‌ ହେୱାନିଂ ଇଚାର୍‌, “ଏନେଙ୍ଗ୍‍ତ ହୁୁଡୁନାୟା, ମାନାୟାର୍‌ ନି ଜପି କୁସ୍‌ପା ଆଦ୍‌ନାରା, ଆରି ଏନ୍‌ ଇନାୟା, ଇନେର୍‌ ନାଙ୍ଗ୍‌ ଡୁତ୍‌ତାର୍‌ ?” ");
INSERT INTO peg_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","ମାତର୍‌ ଜେ ଇଦାଂ କିଜ଼ି ମାଚାତ୍‌, ହେଦାଂ ହୁଡ଼୍‌ଦେଂ ହେୱାନ୍‌ ଚାରିବେଣ୍‌ତାଂ କାଣ୍‌କୁ କିଦେଙ୍ଗ୍‌ ଲାଗାତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","ହେବେଣ୍ଡାଂ ହେ କଗ୍‌ଲେ ତାଙ୍ଗେଙ୍ଗ୍‌ ସବୁ ଗିଟା ଆତାକା, ଆରେ ହେଦାଂ ପୁଞ୍ଜି ପାଣ୍ଡ୍ରୁତିଂ ତ୍ରିଗ୍‌ଜି ତ୍ରିଗ୍‌ଜି ୱାଜ଼ି ହେୱାନିଂ ଡାଣ୍ଡାହାଡ଼୍‌ ମାଗ୍‌ଜି ୱିଜ଼ୁ ହାତ୍‌ପା କାତା ହେୱାନିଂ ୱେଚ୍‌ଚାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","ତା ପାଚେ ଜିସୁ ହେଦେଲିଂ ଇଚାନ୍‌, “ଏ କଇ, ନି ପାର୍ତିତାଂ ନିଙ୍ଗେଙ୍ଗ୍‌ ଉଜ୍‌ କିଜ଼ି ମାଞ୍ଜ୍‌ନାତ୍ । ଏନ୍‌ ସୁସ୍ତାତାଂ ହାଲା, ଆରେ ନି ରଗ୍‌ତାଂ ଉଜ୍‌ ଆଜ଼ି ମାନା ।” ");
INSERT INTO peg_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","ହେୱାନ୍‌ ଇ ବେରଣ୍‌ ଇନିହିଙ୍ଗ୍, ତା ନାଟି ମୁଣିକା ଇଞ୍ଜି ଲକୁ ୱାଜ଼ି ଇଚାର୍‌, “ନି ଗାଡ଼୍‌ ହାତାତେ । ଗୁରୁଙ୍ଗ୍‌ ଇନାକିଦେଂ ଆରେ କସ୍ଟ ହିନାୟା ?” ");
INSERT INTO peg_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","ମାତର୍‌ ଜିସୁ ହେ ବେରଣ୍‌ ୱେନ୍‌ଞ୍ଜି ୱେନ୍‌ୱିତି ଲାକେ ଆଜ଼ି ନାଟି ମୁଣିକାଂ ଇଚାନ୍‌, “ପାଣ୍ଡ୍ରା ଆମା, ଜେ ମାତର୍‌ ପାର୍ତି କିୟା ।” ");
INSERT INTO peg_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","ପାଚେ, ଜିସୁ ପିତର୍‌ ଜାକୁବ୍‌ ଆରେ ତା ଟଣ୍ଡାହି ଜହନ୍‌ ପିସ୍ତି ଆରେ ଇନେରିଂ ପା ତା ଲାହାଙ୍ଗ୍‌ ହାଞ୍ଜେଙ୍ଗ୍‌ ହିୱାତାନ୍ । ");
INSERT INTO peg_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","ହେୱାର୍‌ କୁଟୁମ୍‌ନି ମୁଡ଼୍‌ଦାକାନ୍‌ ଇଞ୍ଜ ୱାଜ଼ି, ହେୱାନ୍‌ ଇଞ୍ଜ ଆଡ଼ାକୁକା ଆନାକା ଆରେ ବିଲ୍‌କି ଆଜ଼ି ଆଡ଼୍‌ବାନାକା ହୁଡ଼୍‌ତାର୍‌, ");
INSERT INTO peg_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","ଆରି ବିତ୍ରେ ହାଲ୍‌ଜି ହେୱାରିଂ ଇଚାନ୍‌, “ଇନାକିଦେଂ ଆଡ଼ାକୁକା ଆନାଦେରା ? କଇହିମ୍‌ଣା ହାୱାତାତ୍‌ନା, ମାତର୍‌ ହୁଞ୍ଜ୍‌ନାତା ହେବେ ହେୱାର୍‌ ହେୱାନିଂ କିଜାୟ୍‌ କିଦେଙ୍ଗ୍‌ ଲାଗାତାର୍‌ !” ");
INSERT INTO peg_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","ମାତର୍‌ ହେୱାନ୍‌ ୱିଜ଼ାକାରିଂ ବାର୍ତ ହପ୍‌ଚି କଇହିମ୍‌ଣା ତେହିଙ୍ଗ୍‌ ଲାତ୍ରାହିଙ୍ଗ୍‌ ଆରେ ତା ହାଙ୍ଗ୍‌ଦା କାରିଂ ଅଜ଼ି ହାଲ୍‌ଜି, କଇହିମ୍‌ଣା ଇମେତାକେ ମାଚାତ୍‌, ହେ ବାହାତ ହଣ୍‌ଗାତାର୍, ");
INSERT INTO peg_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","ଆରେ ହିମ୍‌ଣାତି କେଇ ଆସ୍ତି ହେଦେଲିଂ ଇଚାନ୍‌, “ଟଲିତାକୁମ୍,” ଇଚିସ୍‌ “ଏ କଇ ହିମ୍‌ଣା, ଆନ୍‌ ନିଙ୍ଗେଙ୍ଗ୍‌ ଇଞ୍ଜ୍‌ନାଙ୍ଗା, ନିଙ୍ଗା !” ");
INSERT INTO peg_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","ହେ ଦାପ୍ରେ କଇହିମ୍‌ଣା ନିଙ୍ଗ୍‌ଜି ବୁଲାଆଦେଂ ଲାଗାତାତ୍‌; ହେ କଇହିମ୍‌ଣା ବୟସ୍‍ ବାର ବାର୍ହୁ ଆଜ଼ି ମାଚାତ୍‌ । ହେବେ ହେୱାର୍‌ ୱିଜ଼ାକାର୍‌ କାବା ଆଜ଼ି ହାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","ଆରେ, ଇନେର୍‌ପା ଜେ ଇ ବିସ୍ରେ ପୁନୁର୍‌, ଇଦାଂ କାଜିଂ ହେୱାନ୍‌ ହେୱାରିଂ ଡାଟ୍‌କିଜ଼ି ବଲ୍‌ ହିତାନ୍‌, ଆରେ “ହେ କଇହିମ୍‌ଣାଂ ଇଚୁଟିଂ ତିନାକା ହିଦେଂ ୱେଚ୍‌ଚାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","ହେ ବାହାତାଂ ଜିସୁ ଇମେତାକେ ଗାଜା ଆଜ଼ି ମାଚାନ୍‌ ଜାର୍‌ ଗାଡ଼୍‌ଦ ୱାତାନ୍ ଆରେ ତା ଚେଲାହିର୍‌ ତା ପାଚେ ପାଚେ ୱାତାର୍ । ");
INSERT INTO peg_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","ଜମ୍‌ନିବାର୍‌, ହେୱାନ୍‌ କୁଟୁମ୍‌ ଇଞ୍ଜ ହିକାଇ କିଦେଙ୍ଗ୍‌ ଲାଗାତାନ୍‌ । ଆରେ, ବେସି ଲକୁ ହେୱାନ୍‌ କାତା ୱେନ୍‌ଞ୍ଜି କାବା ଆଜ଼ି ଇଚାର୍‌, “ଇୱାନ୍‌ ଇ ସବୁ ଇମେତାଂ ପୁଚାନ୍‌ନା ?” ପାଚେ, ଇୱାନ୍‌ ଇମ୍‌ଣି ବୁଦିହିୟା ଆତାତ୍‌ନ୍ନା ? “ଆରେ ଇମ୍‌ଣି ସାକ୍ତିନି କାମାୟ୍‌ ଇୱାନ୍ତି ତା କେଇ କାଜିଂ କାମାୟ୍‌ ଆନାତା, ଇ ସବୁ ଇନାକା ?” ");
INSERT INTO peg_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","ଇୱାନ୍‌ ଜେ ହେ ବାଡାୟ୍‌ ଆକାୟ୍‌ । ଇୱାନ୍‌ ହେ ମରିୟମ୍‌ ମେହି, ଆରି ଜାକୁବ୍‌, ଜସି, ଜିହୁଦା ଆରେ ସିମନ୍‌ ଟଣ୍ଡେନ୍‌ ଆକାୟ୍‌ ପାଚେ, “ଇୱାର୍‌ ତଣ୍‌ଦେହିକ୍‌ ଇବେ ମା ଲାହାଙ୍ଗ୍‌ ରଚେ ହିଲ୍‍ୱିତିକ୍” ଆରେ ଇଦାଂ ଇଞ୍ଜି ତାଙ୍ଗେଙ୍ଗ୍‌ ପାର୍ତି କିୱାତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","ହେବେତାଂ ଜିସୁ ହେୱାରିଂ ଇଚାନ୍‌, “ବିନେନିକାର୍‌ ରୱାନ୍‌ ବେଣ୍‌ବାକ୍‌ଣାୟ୍‌ କିନାକାନିଂ ଗୱାରି କିତାର୍‌, ମାତର୍‌ ହେ ନିଜେ ଗାଡ଼୍‌ନି ମାନାୟାର୍‌, ହେ ଲକ୍‌ବାକ୍‌ ଆରି ନିଜେ ଇଞ୍ଜ୍‌ନି ଲକ୍‌ବାକ୍‌ ପିସ୍ତି ତାଙ୍ଗେଙ୍ଗ୍‌ ଗୱାରି କିଉର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","ପାଚେ, ଅଲପ୍‍ କେତେକ୍‌ ରଗିୟାରିଂ ଜପି କେଇ ଇଡ଼୍‌ଜି ହେୱାରିଂ ଉଜ୍‌ କିନାକା ପିସ୍ତି ଅଲ୍‌ଗା ଇମ୍‌ଣି ସାକ୍ତିତାଂ କାମାୟ୍‌ କିଦେଙ୍ଗ୍‌ ଆଡ଼୍‌ୱା ତାନ୍‌ନ୍ଦେ । ");
INSERT INTO peg_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","ଆରେ, ହେୱାର୍‌ତି ପାର୍ତି କିୱାକା କାଜିଂ କାବା ଆତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","ପାଚେ ହେୱାନ୍‌ ବାରଜାଣ୍‌ ଲାଗେ କୁକ୍‌ଚି ହେୱାରିଂ ରିୟାର୍‌ ରିୟାରିଂ କିଜ଼ି ପକ୍ତେତେଂ ଆରାମ୍‌ କିତାନ୍‌ ଆରି ପୁଦାଂ ଡୁୟାଆତି ମାନାୟ୍‌ତିଂ ପିହିକିଦେଂ ଇଞ୍ଜି ହେୱାରିଂ ଆଦିକାର୍‌ ହିତାନ୍‌; ");
INSERT INTO peg_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","ଆରେ, “ଏପେଙ୍ଗ୍‌ ହାନିହିଂ ମାତର୍‌ ଜେ ବାଡ୍‌ଗା ପିସ୍ତି ରୁଟି କି ଡରି ମଣାତ ଡାବୁଙ୍ଗ୍‌ ଆମାଟ୍‌ ଇଞ୍ଜି ହେୱାରିଂ ବଲ୍‌ ହିତାନ୍‌; ");
INSERT INTO peg_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","ମାତର୍‌ ହେୱାରିଂ କାଲ୍‌ଦ ପାଣ୍ଡାୟ୍‌ଙ୍ଗ୍ ତୁଜ଼ାଟ୍‌ ଇଚାନ୍‌, ରିଣ୍ଡାଂ ଆଙ୍ଗିଙ୍ଗ୍‌ ଆର୍ପେଦେଂ ମୁନା କିତାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","ଆରେ, ଜିସୁ ହେୱାରିଂ ଇଚାନ୍‌, “ଏପେଙ୍ଗ୍‌ ଇମ୍‌ଣି ଇଞ୍ଜ ହଣ୍‌ଗାନାଦେର୍, ହେ ବାହାତାଂ ପକ୍ତିୱି ପାତେକ୍‌ ହେବେ ମାନାଟ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","ମାତର୍‌ ଇମ୍‌ଣି ନାସ୍‍ନି ମାନାୟ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ମାନ୍‍କିଦୁର୍‌, ଆରେ ମି ବେରଣ୍‌ ୱେନ୍‌ଞ୍ଜୁର୍, ହେ ବାହାତାଂ ହାନି ୱେଡ଼ାଙ୍ଗ୍‌ ହେୱାର୍‌ ତାକେ ସାକି ହିଦେଂ ମି କାଲ୍‌ ପାନାନି ଦୁଡ଼ି ଡ଼ାତାଟ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","ହେବେ ହେୱାର୍‌ ବାର୍ତ ହାଲ୍‌ଜି ମାନ୍‌ବାଦ୍‌ଲାୟ୍‌ କିନାକା ଜେ ମାନାତ୍‌, ଇଦାଂ ସୁଣାୟ୍‌ କିତାର୍‌, ");
INSERT INTO peg_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","ଆରେ ଆଦେକ୍‌ ପୁଦାଂ ପିହିକିତାର୍‌ ଆରେ ବେସି ହେନି ରଗି ଲଗାଙ୍ଗ୍ ଚିକାଣ୍‌ କାଜିଂ ଉଜ୍‌ କିତାର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","ଜିସୁ ତର୍‌ ୱିଣ୍‌ତିଲେ ହେରଦ୍‌ ରାଜା । ହେୱାନ୍‌ ବିସ୍ରେ ୱେଚାନ୍‌, ଆରେ ଲକୁ ଇଞ୍ଜି ମାଚାର୍‌, “ବାପ୍ତିସିମ୍‌ ଜହନ୍‌ ହାତି ତାକେଣ୍ଡାଂ ନିଙ୍ଗ୍‌ତାନ୍ନା ! ହେ ଇ ୱିଜ଼ୁ ସାକ୍ତି ହେୱାନ୍‌ ତାକେ କାମାୟ୍‌ କିନାତା ।” ");
INSERT INTO peg_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","ମାତର୍‌ ବିନେନିକାର୍‌ ଇଞ୍ଜି ମାଚାର୍‌, “ଆଗେଦିନି ରୱାନ୍‌ ଏଲିୟ,” ପାଚେ ଆରେ ଇନେ ଇନେର୍‌ ଇଞ୍ଜି ମାଚାର୍‌, “ବେଣ୍‌ବାକ୍‌ଣାୟ୍‌କିନାକାନ୍‌ ତାଙ୍ଗ୍‌ ଇନାକାନ୍‌ ଲାକେପା ଇୱାନ୍‌ ରକାନ୍‌ ବେରଣ୍‌ ବାକ୍‌ଣାୟ୍‌ କିନାକାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","ମାତର୍‌ ହେରଦ୍‌ ଇଦାଂ ୱେନ୍‌ଞ୍ଜି ଇଚାନ୍‌, “ଇମ୍‌ଣି ଜହନ୍‌ତିଂ ଆପେଂ କାପ୍‌ଡ଼ା ରାସ୍‍ତାପ୍‌ନା, ହେୱାନ୍‌ ନିଙ୍ଗ୍‌ତାନ୍‌ନା ।” ");
INSERT INTO peg_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","ଲାଗିଂ ହେରଦ୍‌ ତା ଟଣ୍ଡାହି ପିଲିପ୍‌ ୱାଣିଙ୍ଗ୍ ହେରଦିଆଙ୍ଗ୍‌ ବିବା କିତିଲେ ହେଦାଂ କାଜିଂ ନିଜେ ମାନାୟ୍‌ ପକ୍‌ଚି ଜହନ୍‌ତିଂ ଆସ୍ତି ଆରେ ଗାଚ୍‌ଚି ଜେଲ୍‌ ଇଞ୍ଜ ତୁଇଜ଼ି ମାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","ହେଦାଂ କାଜିଂ ଜହନ୍‌ ହେରଦ୍‌ତିଂ ଇଞ୍ଜି ମାଚାନ୍‌, “ନି ଟଣ୍ଡେନ୍‌ ୱାଣିଙ୍ଗ୍‌ ଡକ୍ରି କିନାକା ନି ବିଦି ହିଲୁତ୍‌ !” ");
INSERT INTO peg_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","ହେବେତାଂ ହେରଦିୟା ଆକାର୍‌ ଆଜ଼ି ଜହନ୍‌ତିଂ ଅସ୍ତେଙ୍ଗ୍‌ ଇଞ୍ଜି ମାନ୍‌ କିଜ଼ି ମାଚାନ୍‌, ମାତର୍‌ ଆଡ୍‌ୱାଦାଂ ମାଚାନ୍‌; ");
INSERT INTO peg_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","ଇନାକିଦେଂକି ହେରଦ୍‌ ଜହନ୍‌ତିଂ ରୱାନ୍‌ ଦାର୍ମି ନିକାନ୍‌ ଆରି ପୁଇପୁୟା ପୁଞ୍ଜି ପାଣ୍ଡ୍ରା ଆଜ଼ି ମାଚାନ୍‌, ଆରେ ତାଙ୍ଗେଙ୍ଗ୍‌ ‌ରାକ୍ୟା କିଦେଙ୍ଗ୍‌ ସେସ୍ଟା କିଜ଼ି ମାଚାନ୍‌, ଆରେ ହେ କାତା ୱେନ୍‌ଞ୍ଜି ବେସି ରିସା ଆତିସ୍‌ପା ୱାରିତାଂ ହେଦାଂ ୱେନ୍‌ଞ୍ଜି ମାଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","ପାଚେ ହେରଦିୟାତି ପାଗ୍‌ ଦିନ୍‌ ଏକା ୱାତାତ୍ । ହେରଦ୍‌ତି ଜଲମ୍‌ ଦିନ୍‌ ନାଜିଂ ପାଟ୍ ମତ୍ରି, ମୁଡ଼୍‌ମେଲ୍ୟା ଆରି ଗାଲିଲିନି ମୁଣିକାର୍ କାଜିଂ ମିକାଲିଂ ବଜି ଜାଲ୍‌ଦି କିତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","ଆରେ, ହେରଦିୟା ତା ଗାଡ଼୍‌ହି ବିତ୍ରେ ୱାଜ଼ି ଏନ୍‌ନ୍ଦିପା, ହେରଦ୍‌ ଆରି ହେୱାନ୍‌ ହୁକେ ବଜିତ କୁଚ୍‌ଚି ଲଗାଙ୍ଗ୍‍ ଗୱାରି କିତାତ୍‌ । ହେବେ ହେରଦ୍‌ ରାଜା ଗାଡ଼୍‌ଚେଂ ଇଚାନ୍‌, “ଇନାକା ମାନ୍‌ କିନାୟା, ଏନ୍‌ତା, ଆନ୍‌ ନିଙ୍ଗେଙ୍ଗ୍‌ ହେଦାଂ ହିଦ୍‌ନାଂ ।” ");
INSERT INTO peg_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","ଆରେ, ହେୱାନ୍‌ ତା ତାକେ ପାର୍ମାଣ୍‌ କିତାନ୍‌, “ଏନ୍‌ ନାଙ୍ଗେଙ୍ଗ୍‌ ଇନାକା ଏନ୍ତାନାୟ୍, ହେଦାଂ ନିଙ୍ଗେଙ୍ଗ୍‌ ରାଜିନି ବାଗେ ପାତେକ୍‌ ଏନ୍ତିତିସ୍‌ ପା ଆନ୍‌ ହିଦିନାଂ !” ");
INSERT INTO peg_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","ତା ପାଚେ ହେଦେଲ୍‌ ହସି ହାଲ୍‌ଜି ତା ତେହିଙ୍ଗ୍‌ ୱେନ୍‌ବାତାତ୍, “ଆନ୍‌ ଇନାକା ଏନ୍‌ନାଙ୍ଗ୍‌ ? ହେଦେଲ୍‌ ଇଚାତ୍‌, ବାପ୍ତିସିମ୍‌ ଜହନ୍‌ନ୍ତି କାପ୍‌ଡ଼ା” ଏନା । ");
INSERT INTO peg_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","ହେ ଦାପ୍ରେ ହେଦେଲ୍‌ ରାଜା ଲାଗେ ୱାଜ଼ି ଇଦାଂ ଇଞ୍ଜି ଏନ୍ତାତ୍‌, ତା ପାଚେ ତେହି ଇଚାତ୍‌ ଜେ, “ଏନ୍‌ ବାପ୍ତିସିମ୍‌ ହିନି ଜହନ୍‌ତି କାପ୍‌ଡ଼ା ର ତାଡ଼ିୟାତ ହେ ଦାପ୍ରେ ହିଦା !” ");
INSERT INTO peg_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","ଇବେ ରାଜା ଦୁକ୍‌ ଆତିସ୍‌ ପା ଜାର୍‌ ପାର୍ମାଣ୍‌ ଆରି ବଜିତ କୁଚ୍‌ଚି ମାନାୟାର୍‌ ତାକେ ଆକାୟ୍‌ ଇଞ୍ଜେଙ୍ଗ୍‌ ମାନ୍‌ କିୱାତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","ଲାଗିଂ ରାଜା ହେ ଦାପ୍ରେ ର ଜାମାନ୍‌ତିଂ ପକ୍‌ଚି ହେୱାନ୍ତି କାପ୍‌ଡ଼ା ତାସି ୱାଦେଙ୍ଗ୍ ଇଞ୍ଜି ବଲ୍‌ ହିତାନ୍‌ । ହେବେଣ୍ଡାଂ ହେୱାନ୍‌ ହାଲ୍‌ଜି ଜେଲ୍‌ତାଂ ଜହନ୍ତି କାପ୍‌ଡ଼ା ରାସ୍‌ଦି ତାହିୱାତାନ୍‌, ");
INSERT INTO peg_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","ଆରେ ହେଦାଂ ର ତାଡ଼ିୟାତ ତାକେ ତାସି ଗାଡ଼୍‌ଚେଂ ହିତାନ୍‌, ଆରେ ଗାଡ଼୍‌ଚେ ହେଦାଂ ଅଜ଼ି ତା ତେହିଙ୍ଗ୍‌ ହିତାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","ଜହନ୍‌ ଚେଲାହିର୍‌ ହେବେନି କାବୁର୍‌ ୱେନ୍‌ଞ୍ଜି ୱାତାର୍‌ ଆରି ହେୱାନ୍‌ ମାଡ଼ା ଅଜ଼ି ଦୁଗେର୍‌ତ ଇଟ୍‌ତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","ପାଚେ ପକ୍ୟାତାକାର୍‌ ଜିସୁ ତାକେ ରୁଣ୍ଡା ଆତାର୍‌, ଆରି ହେୱାର୍‌ ଇନା ଇନାକା କିଜ଼ି ମାଚାର୍‌ ଆରେ ଇନା ଇନାକା ହିକିୟା ହିଜ଼ି ମାଚାନ୍‌, ହେ ୱିଜ଼ୁ ହେୱାନିଂ ୱେଚ୍‍ପାତାର୍‍ । ");
INSERT INTO peg_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","ହେବେତାଂ ହେୱାନ୍‌ ହେୱାରିଂ ଇଚାନ୍‌, “ଜାଡୁ ଆସେଙ୍ଗ୍‌ ର ଚିମ୍‌ରା ବାହାତ ଜମ୍‍ନାସ୍‍ । ଇନାକିଦେଂକି ହେନି ମାନାୟ୍‌ ହାନାକା ୱାନାକା ଆଜ଼ି ମାନି କାଜିଂ ହେୱାର୍‌ ଚିଞ୍ଜେଙ୍ଗ୍‌ ପା ପାବ୍‌ ଆୱାଦାଂ ମାଚାର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","ତା ପାଚେ ହେୱାର୍‌ ବିନେ ଆଜ଼ି ର ଡଙ୍ଗାତ ଚିମ୍‌ରା ବାହାତାକେ ହସି ହାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","ମାତର୍‌ ହେନି ହେୱାରିଂ ହସି ହାନାକା ହୁଡ଼୍‌ତାର୍‌ ଆରି ଚିିନ୍‍ କିତାର୍‌, ଆରେ ମାନାୟାର୍‌ ୱିଜ଼ାକାର୍‌ ଗାଡ଼୍‌ଦାଂ ତାଙ୍ଗ୍‌ଜି ହାଲ୍‌ଜି ହେବେ ରଚେ ହଞ୍ଚି ହାଲ୍‌ଜି ହେୱାର୍‌ ଆଗେ ଏକାତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","ହେୱାନ୍‌ ଡଙ୍ଗାତାଂ ହସି ବେସି ହେନି ମାନାୟାରିଂ ହୁଡ଼୍‌ଜି ହେୱାର୍‌ କାଜିଂ କାର୍ମାତିଂ ତାଙ୍ଗ୍‌ ମାନ୍ତ ରାସ୍‌ ଇଚାନ୍‌, ଇନାକିଦେଂକି ହେୱାର୍‌ ଗଡ଼ିୟା ହିଲ୍‌ୱି ମେଣ୍ଡାଂ ଲାକେ ମାଚାର୍‌, ପାଚେ, ହେୱାନ୍‌ ହେୱାରିଂ ଆଦିକ୍‌ ବିସ୍ରେ ହିକାଇ ହିଦେଂ ଲାଗାତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","ୱେଡ଼ା ଆଦିକ୍‌ ଆତିଲେ ତା ଚେଲାର୍‌ ତା କଚଣ୍‌ତ ୱାଜ଼ି ଇଚାର୍‌, ଇ ବାହାତ ଚିମ୍‌ରା, ଆରେ “ବେସି ୱେଡ଼ା ଆତାତେ । ");
INSERT INTO peg_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","ମାନାୟାର୍‌ ଇନେସ୍‌ ଚାରିବେଣ୍‌ତି ନାସ୍‌କୁ ନିକାର୍‌ ଆରେ ନାଟ ହାଲ୍‌ଜି ଜାର୍‌ ଜାର୍‌ କାଜିଂ ତିନ୍‌ଞ୍ଜେଙ୍ଗ୍‌ ଇଞ୍ଜି ଇନାକା କଡ଼୍‌ନାର୍‌, ଇଦାଂ କାଜିଂ ହେୱାରିଂ ପକା ।” ");
INSERT INTO peg_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","ମାତର୍‌ ହେୱାନ୍‌ ହେୱାରିଂ ଉତର୍‌ ହିତାନ୍‌, “ଏପେଙ୍ଗ୍‌ ହେୱାରିଂ ଚିଚ୍‌ପାଟ୍‌ । ହେୱାର୍‌ ହେୱାନିଂ ଇଚାର୍‌, ଆସେଙ୍ଗ୍‌ ଇନାକା ସହେ ଟାକାନି ରୁଟିଂ କଡ଼୍‌ଜି ଇୱାରିଂ ହିନାସ୍ ?” ");
INSERT INTO peg_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","“ହେୱାନ୍‌ ହେୱାରିଂ ଇଚାନ୍‌, ମି ତାକେ ଏଚେଗଟା ରୁଟିଂ ମାନିକ୍‌ ? ହାଲ୍‌ଜି ହୁଡ଼ାଟ୍‌ ।” ହେୱାର୍‌ ବୁଜା ଆଜ଼ି ୱାଜ଼ି ହେୱାନିଂ ଇଚାର୍‌, “ପାଞ୍ଚ୍‌ ଗଟା, ଆରେ ରିଣ୍ଡାଂ ମିନ୍‌କୁ ।” ");
INSERT INTO peg_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","ଜିସୁ ବଲ୍‌ ହିତାନ୍‌, ମାନାୟାରିଂ ବାଟାତ କୱାଣ୍‌ କାଚ୍ରା ଜପି କୁଦା କୁଦା କିଜ଼ି କୁଚ୍‌ଚି କିୟାଟ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","ହେବେ ହେୱାର୍‌ ସଏ ସଏ ଜାଣ୍‌ ଆରେ ପଚାସ୍‌ ପଚାସ୍‌ ଜାଣ୍‌ ଆଜ଼ି କୁଦା କୁଦା ଆଜ଼ି କୁଚ୍‌ଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","ପାଚେ ଜିସୁ ହେ ପାଞ୍ଚ୍‌ଗଟା ରୁଟିଂ ଆରେ ରିଣ୍ଡାଂ ମିନ୍‌କୁ ଆସ୍ତି ସାର୍ଗେତ ହୁଡ଼୍‌ଜି ଆସିର୍ବାଦ୍‌ କିଜ଼ି ଇଚାନ୍‌ ଆରି ରୁଟିଂ ଡ୍ରିପ୍‌କିସ୍‌ ମାନାୟାରିଂ ପାସ୍‍ପେଦେଂ ଚେଲାରିଂ ହିତାନ୍‌ । ପାଚେ, ହେ ଲାକେ ରିଣ୍ଡାଂ ମିନ୍‌କୁ ହେୱାରିଂ ବାଟା କିଜ଼ି ହିତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","ହେବେଣ୍ଡାଂ ୱିଜ଼ାକାର୍‌ ତିନ୍‌ଞ୍ଜି ପଟ ପାନ୍‌ଚାର୍, ");
INSERT INTO peg_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","ଆରେ ହେୱେର୍‌ ଡ୍ରିଙ୍ଗ୍‌ତି ରୁଟିଂ ପେସ୍‌ଜିପା ବାର ଟପା ବାର୍ତି କିତାର୍‌ ଆରି ମିନ୍‌କୁପା ଏଲେଙ୍ଗ୍‌ନେ ପେସ୍‌କାତାର୍ । ");
INSERT INTO peg_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","ରୁଟି ତିନି ମାନାୟ୍‌ ପାଞ୍ଚ୍‌ ହାଜାର୍‌ ଆଣ୍ଡ୍ରାହିମ୍‌ଣାଂ ମାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","ହେ ଦାପ୍ରେ ହେୱାନ୍‌ ତା ଚେଲାରିଂ ଡଙ୍ଗାତ ଦୁମ୍‌ଜି ବେତ୍‌ସାଇଦା ନିପ ଆନ୍‌ଟି ପାଡ଼୍‍କା ଆଗେ ହାନ୍‍ଞ୍ଜେଙ୍ଗ୍‍ ଇଚାନ୍‌, ଆରେ ହେୱାନ୍‌ ଇବେଣ୍ଡାଂ ମାନାୟାରିଂ ୱିଜ଼ାରିଂ ହେଲ ହିତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","ଜିସୁ ହେୱାର୍‌ ତାକେଣ୍ଡାଂ ହେଲ ଅତି ପାଚେ ଜିସୁ ପାର୍ତାନା କିନି କାଜିଂ ମାଡ଼ିଜପି ହାଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","ମ୍ଡିକାହାରେସ୍‌ ଆତିଲେ ଡଙ୍ଗା ହାମ୍‌ଦୁର୍‌ ମାଦି ମାଚାତ୍‌ ଆରେ ହେୱାନ୍‌ ମେଦ୍‌ନିତ ରକାନ୍‌ ମାଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","ଲଡ଼ି ଦୁକା କାଜିଂ ହେୱାରିଂ ଡଙ୍ଗା ଗାଟି କିଦେଙ୍ଗ୍‌ କସ୍ଟ ପାୟା ଆନାକା ହୁଡ଼୍‌ଜି ହେୱାନ୍‌ ପୁରା ନାଣା କୁଜ଼ୁ କେପା ୱେଡ଼ାଙ୍ଗ୍‌ ହାମ୍‌ଦୁର୍‌ ଜପି ତାଙ୍ଗ୍‌ଜି ଚେଲାର୍‌ ତାକେ ୱାତାନ୍‌, ଆରେ ହେୱାର୍‌ କଚଣ୍‌ତାଂ ଆଗେ ତାଂଦେଙ୍ଗ୍ ପା ସାସ୍‌ ମାଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","ମାତର୍‌ ହେୱାର୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ହାମ୍‌ଦୁର୍‌ ଜପି ତାଂନାକା ହୁଡ଼୍‌ଜି “ପୁଦା ଇଞ୍ଜି !” କିକିରାଡିଂ କିତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","ଇନାକିଦେଂକି ହେୱାର୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ହୁଡ଼୍‌ଜି ପାଣ୍ଡ୍ରା ଆଜ଼ି ମାଚାର୍‌ । ମାତର୍‌ ଜିସୁ ହେ ଦାପ୍ରେ ହେୱାରିଂ ବେରଣ୍‌ କିଜ଼ି ହେୱାରିଂ ଇଚାନ୍‌, ପାଡ୍ରା ଆମାଟ୍‌ “ସାସ୍‌ ଆଡୁ ଇୱାଙ୍ଗ୍‌ ତ ଆନ୍‌ ପାଣ୍ଡ୍ରା ଆମାଟ୍‌ !” ");
INSERT INTO peg_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","ଆରେ, ହେୱାନ୍‌ ହେୱାର୍‌ ଲାଗାଂ ହାଲ୍‌ଜି ଡଙ୍ଗାତ ଦୁମ୍‌ତାନ୍‌, ଆରେ ଦୁକା ତିର୍‌ ଆତାତ୍‌ । ହେବେ ହେୱାର୍‌ ମାନ୍ତ ମାନ୍ତ କାବା ଆଜ଼ି ହାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","ହେୱାର୍‌ ପାଞ୍ଚ୍‌ ହାଜାର୍‍ ମାନାୟାରିଂ ରୁଟି ଚିଚ୍‍ପିନି ବିସ୍ରେ ଅରତ୍‌ ପୁନ୍‌ୱାଦାଂ ହିକାୱାଦାଙ୍ଗ୍‍ ମାଚାର୍‌ ଇନାକିଦେଂକି ରୁଟି ନି ଗଟ୍‌ଣା ୱେଡ଼ାଙ୍ଗ୍‌ ହେୱାର୍‌ତି ବୁଦି ଆର୍‌ୱାଦାଂ ମାଚାତ୍‌, ଲାଗିଂ ହେୱାରିଂ ମାନ୍‌ ଆଟ୍‌ୱା ଆଜ଼ି ମାଚାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","ହେୱାର୍‌ ନାସି ଗିନ୍ନେସରତ୍‌ ନିପ ଏକିସ୍‌ ଗୁଟିତ ଡଙ୍ଗା ଗାଚ୍‌ଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","ଆରେ, ହେୱାର୍‌ ଡଙ୍ଗାତାଙ୍ଗ୍ ଜୁତିଲେ, ମାନାୟାର୍‌ ହେ ଦାପ୍ରେ ତାଙ୍ଗ୍‌ ଚିନ୍‌ କିତାର୍‌, ");
INSERT INTO peg_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","ହେ ୱିଜ଼ୁ ରାଜି ନିକାର୍‌ ଚାରିବେଣ୍‌ତାଂ ହନ୍‍ଚି ହାଚାର୍‌, ଆରେ ଜିସୁ ଇମେ ଇମ୍‌ଣି ବାହାତ ମାନାନ୍‌ ଇଞ୍ଜି ୱେଚାର୍‌, ହେ ବାହାତ ରଗି ମାନାୟାରିଂ କାଟେଲ୍‌ତ ପିଣ୍ଡ୍‌ଜି ତାସି ୱାଦେଙ୍ଗ୍ ଲାଗାତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","ଆରେ, ହେୱାନ୍‌ ଇମେ ଇମ୍‌ଣି ନାସ୍ତ, ଗାଡ଼୍‌ଦ କି ହାରୁନାସ୍‍ତ ହଟାର୍‌, ମାନାୟ୍‌ ହେ ବାହାତ ଆଟ୍‌ ପାଦାଲାକେ ରଗି ଲଗାଙ୍ଗ୍ ଇଡ଼୍‌ଜି, ହେୱାର୍‌ ଇନେସ୍‌କି ଜିସୁ ହେନ୍ଦ୍ରାନି ଚେଲିଂ ଡୁନାର୍‌, ଇଦାଂ ଜିସୁଙ୍ଗ୍‌ ଗୱାରି କିଦେଙ୍ଗ୍‌ ଲାଗାତାର୍‌; ଆରି, ଏଚେକ୍‌ ଜାଣ୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ଡୁତାର୍‌, ୱିଜ଼ାର୍‌ ଉଜ୍‌ ଆତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","ପାଚେ ପାରୁସିର୍‌ ଆରି ଜିରୁସାଲମ୍‌ ତାଙ୍ଗ୍‌ ୱାଜ଼ି ମାଚି କେତେକ୍‌ ଦରମ୍‌ ଗୁରୁର୍‌ ତା ତାକେ ରୁଣ୍ଡା ଆତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","ହେୱାର୍‌ ହେୱାନ୍ତି ଚେଲାର୍‌ ବିତ୍ରେ କେତେଜାଣ୍‌ ରାଡ଼ା, ଇଚିସ୍‌ କେଇ ନୁସ୍‌ୱାଦାଂ ତିନାକା ହୁଡ଼୍‌ତାର୍ । ");
INSERT INTO peg_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","ପାରୁସିର୍‌ ଆରେ ୱିଜ଼ାର୍‌ ଜିହୁଦି ଲକ୍‌ ପ୍ରାଚିନାର୍‌ ରିତି ନିତି ନିୟମ୍‌ କିଜ଼ି ହାର୍‌ କିଜ଼ି କେଇ ନୁଜ଼୍‌ୱାତାର୍‌ଚି ତିନୁର୍, ");
INSERT INTO peg_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","ପାଚେ ଆଟ୍‌ ବାଜାର୍ ତାଙ୍ଗ୍‌ ୱାଜ଼ି ଜାର୍‌ ଜାର୍‌ ଜପି ଏଜ଼ୁଂ ଡ଼ଞ୍ଜ୍‌ୟା ଆୱିତିସ୍‌ କୁଲେର୍‌ ଉଣୁର୍; ଆରି ଗିିନା, ମତା ଆରେ ପିତାଡ଼୍‌ ତାଡ଼ିଆ ତ ଏଜ଼ୁଂ କ୍ଡୁପ୍‌କିସ୍‌ ନୁଜ଼୍‌ନାକା, କାଟେଲ୍‌ ଜପି ଏଜ଼ୁଂ ତିର୍‌ନାକା ଇୱାଙ୍ଗ୍‌ ବିନ୍‌ ବିନ୍‌ ବେସି ରିତି ନିତି ମାନି କିଦେଙ୍ଗ୍‌ ଇଞ୍ଜି ହେୱାର୍‌ ବଲ୍‌ ପାୟା ଆତାର୍ଣ୍ଣା । ");
INSERT INTO peg_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","ଲାଗିଂ ପାରୁସିର୍‌ ଆରେ ଦରମ୍‌ ଗୁରୁର୍‌ ହେୱାନିଂ ୱେନ୍‌ବାତାର୍, ମି ଚେଲାର୍‌ ପ୍ରାଚିନାର୍‌ ରିତି ନିତି ନିୟମ୍‌ ତାଙ୍ଗ୍‌ “ଇନାକିଦେଂ ବେବାର୍‌ କିୱାଦାଂ ରାଡ଼ା କେଇଦ ତିନାରା ?” ");
INSERT INTO peg_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","ହେୱାନ୍‌ ହେୱାରିଂ ଇଚାନ୍‌, ଆଡ଼େ କାପ୍‌ଟିୟାର୍‌, ଜିସାୟ୍‌ ମି ବିସ୍ରେ ସମାନ୍‌ ବାବ୍ରେ ବେରଣ୍‌ ୱେଚ୍‌ଚାତାନ୍‌ନା, ଇନେସ୍‌ ଲେକାମାନାତ୍‌, ଇ ଜାତି ମୁମ୍‌ଦ ମାଙ୍ଗେଙ୍ଗ୍‌ ୱାରି କିଦ୍‌ନାର୍‌, ମାତର୍‌ ହେୱାର୍‌ ମାନ୍‌ ମା ତାଙ୍ଗ୍‌ ଦେହା ମାନାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","“ହେୱାର୍‌ ମାନାୟାର୍‌ତି ବିଦିଙ୍ଗ୍‌ ଦରମ୍‌ ବେରଣ୍‌ ଇଞ୍ଜି ହିକ୍ୟା ହିନାନ୍‌ ପଲ୍ୟା ମା ପାର୍ତାନା କିନାର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","“ଏପେଙ୍ଗ୍‌ ଇସ୍ୱର୍‌ତି ବଲ୍‌ ପିସ୍ତି ମାନାୟାର୍‌ତି ରିତି ନିତି ଆସ୍ତି କୁଚ୍‌ଚା ଦେର୍‌ନା ।” ");
INSERT INTO peg_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","ଆରେ, ଜିସୁ ହେୱାରିଂ “ଏପେଙ୍ଗ୍‌ ଜାର୍‌ ଜାର୍‌ ରିତି ନିତି ମାନି କିନି କାଜିଂ ଇସ୍ୱର୍‌ତି ବଲ୍‌ ମାନି କିଉ ଦେରା ।” ");
INSERT INTO peg_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","ଇନାକିଦେଂକି ମସା ରିତି ନିୟମ୍‌ ହିତ୍‌ତାନ୍ନା, “ଜାର୍‌ ଆବା ଆୟାକାଂ ୱାରି କିୟାଟ୍‌, ଆରେ ଇନେର୍‌ ତା ଆବା କି ଆୟାଂ ସାଇପ୍‌ ହିନାନ୍‌, ହେୱାନ୍‌ ହାକି ଡାଣ୍ଡ୍‌ ପାୟା ଆନାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","ମାତର୍‌ ଏପେଙ୍ଗ୍‌ ଇନାଟ୍‌, ଇନେର୍‌ ଏଚେକାଡ଼୍‌ଦ ଆବା କି ଆୟାଂ ଇନାର୍‌, ନା ତାଙ୍ଗ୍‌ ଇନାକାପା ମି ଉପ୍‌କାର୍‍ ଆତାତ୍ମା, ହେଦାଂ କର୍ବାନ୍‍, ଇଚିସ୍‌ ଅଡ଼୍‌ଗା ଆତାତ୍‌ନ୍ନା, ");
INSERT INTO peg_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","ଲାଗିଂ ଏପେଙ୍ଗ୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ତାଞ୍ଜି ଆବା କି ଆୟାଂ ଅଲପ୍‌ପା ଉପ୍‌କାର୍‌ କିଦେଙ୍ଗ୍‌ ହିୱାଦାଂ ମାଚିସ୍‌; ");
INSERT INTO peg_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","ଇ ଲାକେ ଏପେଙ୍ଗ୍‌ ଚାଲାଆତି ବେରଣ୍‌ ରିତି ନିତି କାଜିଂ ଇସ୍ୱର୍‌ତି ବଚନ୍‌ ପଲ୍ୟା କିନାଦେରା ଆରି ହେ ଲାକେ ବେସି ବିସ୍ରେ କିନାଦେରା ।” ");
INSERT INTO peg_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","ଜିସୁ ଆରେ ରଗ ମାନାୟ୍‌ଗଲି କଚଣ୍‌ତ କୁକ୍‌ଚି ହେୱାରିଂ ଇଚ୍‌ଚି, “ଏପେଙ୍ଗ୍‌ ୱିଜ଼ାକାଦେର୍‌ ନା କାତା ୱେନାଟ୍‌ ଆରି ବୁଜାଆଡୁ । ");
INSERT INTO peg_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","ମାନାୟାର୍‌ତି ବାର୍ତ ଏପେଙ୍ଗ୍‌ ଇମ୍‌ଣି ବିସ୍ରେ ହିଲୁତ୍‌, ଇନାକା କି ତା ବିତ୍ରେ ହଣ୍‌ଜି ତାଙ୍ଗେଙ୍ଗ୍‌ ବିଟାଡ଼୍‌ କିଦେଙ୍ଗ୍‌ ଆଡ଼୍‌ଦାତାତ୍‌, ମାତର୍‌ ଇନା ଇନାକା ମାନାୟ୍‌ ତାଙ୍ଗ୍‌ ବାର୍ତ ହନାତ୍‌, ହେ ସବୁ ତାଙ୍ଗେଙ୍ଗ୍‌ ବିଟାଡ଼୍‌ କିିନାତ୍ ।” ");
INSERT INTO peg_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","“ଜଦି ଇନେରିଂ ୱେଞ୍ଜେଙ୍ଗ୍‌ କିତୁଲିଂ ମାନିଙ୍ଗ୍, ହେୱାନ୍‌ ୱେନେନ୍ !” ");
INSERT INTO peg_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","ଆରେ, ହେୱାନ୍‌ ମାନାୟ୍‌ ତାକେଣ୍ଡାଂ ଇଲ୍‌ ବିତ୍ରେ ୱାତି ପାଚେ ତା ଚେଲାହିର୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ଉତର୍‌ମୁଡ଼୍‌ନି ଅରତ୍‌ ୱେନେବେଦେଂ ଲାଗାତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","ହେବେ ଜିସୁ ହେୱାରିଂ ଉତର୍‌ ହିତାନ୍‌, “ଏପେଙ୍ଗ୍‌ ପା ଇନାକା ହେ ଲାକେ ବୁଜାଆଉଦେରା ?” ଇନାକା ଆୟେତ୍‌ ହୱେତ୍‌ ମାନାୟ୍‌ ବାର୍‌ତାଂ ବିତ୍ରେ ହଟିସ୍, ହେଦାଂ ତାଙ୍ଗ୍‌ ବିଟାଡ଼୍‌ କିଦେଙ୍ଗ୍‌ ଆଡୁତ୍‌, ");
INSERT INTO peg_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","“ଇନାକିଦେଂକି ତାଙ୍ଗେଙ୍ଗ୍‌ ହେ ମାନ୍ତ ହଣ୍ଡେଙ୍ଗ୍‍ ଆଡୁତ୍‌, ମାତର୍‌ ପଟତ ହାଲ୍‌ଜି ବାର୍ତ ହନାତ୍‌ ଆରେ ଏଲେଙ୍ଗ୍‌ ଆଜ଼ି ୱିଜ଼ୁ ତିନି କାଦି ସକଟ୍‌ ଆନାକା, ଇଦାଂ ଜିସୁ ଇଚାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","ଆରି, ଜିସୁ ଇଚାନ୍‌, “ଇନାକା ମାନାୟ୍‌ ତାକେଣ୍ଡାଂ ବାର୍ତ ହନାତ୍‌, ହେଦାଂ ନେ ତାଙ୍ଗେଙ୍ଗ୍‌ ବିଟାଡ଼୍‌ କିନାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","ଇନାକିଦେଂକି ବିତ୍ରେତାଂ, ମାନାୟ୍‌ ମାନ୍‌ତାଂ, ବାନ୍ୟା ଚିନ୍ତା ବାର୍ତ ହତ୍‍ନାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ଦାରି, ଚରି, ନାର୍‌ ଅହ୍‌ନାକା, ଦାରିହାନାକା, ଲାବ୍‍ଡ଼ି, ଚୁଲ୍‍ଚୁଲା ବଡ଼୍‍ପାଣିୟା, ନାଙ୍ଗ୍‌ରା, ବେରୁହୁଡ଼୍‍ନାକା, ନିନ୍ଦା, ଆକର୍‌, ଟେପର୍‌, ");
INSERT INTO peg_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","ଇଦାଂ ୱିଜ଼ୁ ବାନ୍ୟା ବିସ୍ରେ ବିତ୍ରେତାଂ ହସି ମାନାୟ୍‌ତିଂ ବିଟାଡ଼୍‌ କିନାତ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","ଇଦାଂ ପାଚେ ହେୱେନ୍‌ ହେବେଣ୍ଡାଂ ନିଙ୍ଗ୍‌ଜି ସର୍‌ ଗାଡ଼୍‌ଦ ନାସ୍‌କୁକାଂ ହାଚାନ୍‌, ଆରି ର ଇଞ୍ଜ ହଟାନ୍‌, ଇନେର୍‌ ଇନେସ୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ପୁନୁର୍‌, ଇଦାଂ ମାନ୍‌ କିଜ଼ି ମାଚାନ୍‌, ମାତର୍‌ ହେୱାନ୍‌ ଡ଼ୁଗ୍‌ଜି ମାଞ୍ଜେଙ୍ଗ୍‌ ଆଡ୍‌ୱାତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","ହେ ଦାପ୍ରେ ର କଗ୍‌ଲେ, ଇନେର୍‌ ଗାଡ଼୍‌ହିଙ୍ଗ୍‍ ବାନ୍ୟା ପୁଦା ଡୁଜ଼ି ମାଚାତ୍‌, ହେଦେଲ୍‌ ହେୱେନ୍‌ ବିସ୍ରେ ନି ବେରଣ୍‌ ୱେନ୍‌ଞ୍ଜି ତା କାଲ୍‌କୁ ତାରେନ୍‌ ୱାଜ଼ି ଡାଣ୍ଡାହାଡ଼୍‌ ମାଗ୍‌ତାତ୍ । ");
INSERT INTO peg_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","ହେଦେଲ୍‌ ସୁରପୈନିକିୟା ନିପ ରଞ୍ଜେଲ୍‌ ଗ୍ରିକ୍‌ ଗାଡ଼୍‌ଚେ ମାଚାତ୍‌ । ତା ଗାଡ଼୍‌ହି ତାକେଣ୍ଡାଂ ପୁଦାଂ ପିିହି କିନି କାଜିଂ ହେଦେଲ୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ଗୱାରି କିଦେଙ୍ଗ୍‌ ଲାଗାତାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","ହେବେଣ୍ଡାଂ ଜିସୁ ହେଦେଲିଂ ଇଚାନ୍‌, “ପର୍ତୁମ୍‌ ହିମ୍‌ଣାକାଂ ପଟ ପାଞ୍ଜି କିୟାଟ୍‌, ଇନାକିଦେଂକି ହିମ୍‍ଣାଙ୍ଗ୍‍ତି ଆରାଣ୍‌ ଅଜ଼ି ନିକୁଡ଼ିଙ୍ଗ୍‌ କଚଣ୍‌ତ ତୁହିନାକା ହାର୍‌ ଆକାୟ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","ମାତର୍‌ ହେଦେଲ୍‌ ହେୱେନିଂ ଉତର୍‌ ହିତାତ୍‌, ଆଁ, “ମାପ୍ରୁ, ନିକୁଡ଼ିଙ୍ଗ୍‌ ପା ପାଟା ତାରେନ୍‌ ଆର୍ତାକା ହିମ୍‌ଣାଂତି ଆରାଣ୍‌ ଲିତାଂ ତିନିିକ୍‌ !” ");
INSERT INTO peg_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","“ହେବେ ଜିସୁ ତାଙ୍ଗେଙ୍ଗ୍‌ ଇଚାନ୍‌, ଇ କାତା ଇଚିଲେ ଏନ୍‌ ହାଲା, ନି ଗାଡ଼୍‌ ତାଙ୍ଗ୍‌ ପୁଦା ହସି ହାଚାତେ !” ");
INSERT INTO peg_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","ଆରେ, ହେଦେଲ୍‌ ଇଞ୍ଜ ହାଲ୍‌ଜି କଇ ହିମ୍‌ଣା କାଟେଲ୍‌ତ ମାଗ୍‌ଜି ମାନାକା ଆରି ପୁଦା ହସି ହାଲ୍‌ଜି ମାନାକା ହୁଡ଼୍‌ତାତ୍ । ");
INSERT INTO peg_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","ଆରେ ରଗ ହେୱାନ୍‌ ସର ହାନ୍ଦିତାଂ ହାଲ୍‌ଜି ସିଦନ୍‌ ଆରେ ଦେକାପଲି ନି ହାନ୍ଦିମାଦିତିଂ ହାଲ୍‌ଜି ଗାଲିଲି ହାମ୍‌ଦୁର୍‌ ଲାଗେ ୱାତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","ଆରେ, ମାନାୟାର୍‌ ରୱାନ୍‌ ବୈରା ଆରି ଗୁଲାଂ ତା ଲାଗେ ତାଇୱାତାର୍‌ ତା ଜପି କେଇ ଇଡ୍‌ଦେଂ ଇଞ୍ଜି ତାଙ୍ଗେଙ୍ଗ୍‌ ଗୱାରି କିତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","ଜିସୁ ତାଙ୍ଗେଙ୍ଗ୍‌ ମାନାୟ୍‌ ତାକେଣ୍ଡାଂ ବିନେ କିଜ଼ି ରୱାନିଂ ଅଜ଼ି ହାଲ୍‌ଜି ହେୱାନିଂ ରି କିତୁଲିକାଂ ତା ୱାଚ୍‌କାଙ୍ଗ୍ ଇଟ୍‌ତାନ୍‌ ଆରି ଏୱିଡ଼ିଂ ଚୁପ୍‌ଜି ତା ୱେନ୍ଦୁଲ୍‌ତ ଡୁତାନ୍‌, ");
INSERT INTO peg_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","ଆରି ସାର୍ଗେ ହୁଡ଼୍‌ଜି ରାଗ୍‌ଦାଙ୍ଗ୍ ନେନ୍‌ଞ୍ଜି ହେୱାନିଂ ଇଚାନ୍‌, “ଇପ୍‌ପତ, ଇଚିସ୍‌ ଜେୟା ଆୟେତ୍‌ !” ");
INSERT INTO peg_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","ହେବେଣ୍ଡାଂ ହେୱାନ୍‌ତି କିତୁଲିଂ ଜେୟା ଆତିକ୍‌ ଆରି ୱେନ୍ଦୁଲ୍ ଗାଚ୍‌ୟାତାକା ହେ ଦାପ୍ରେ ଜେୟା ଆତାତ୍‌, ଆରେ ହେୱାନ୍‌ ହାର୍‌ କିଜ଼ି ବେରଣ୍‌ ଇଞ୍ଜେଙ୍ଗ୍‌ ଲାଗାତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","ଆରେ, ଇ ବିସ୍ରେ ଇନେରିଂ ୱେଚ୍‌ମାଟ୍‌ ଇଞ୍ଜି ହେୱାନ୍‌ ହେୱାରିଂ ଆଟ୍‌ୱା କିିଜ଼ି ବଲ୍‌ ହିତାନ୍‌; ମାତର୍‌ ହେୱାନ୍‌ ହେୱାରିଂ ଏଚେକ୍‌ ମୁନାକିତାନ୍‌, ହେୱାର୍‌ ବେସି ହେଦାଂ ସୁଣାୟ୍‌ କିଦେଂ ଲାଗାତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","ଆରେ, ମାନାୟାର୍‌ ବେସି କାବା ଆଜ଼ି ଇଚାର୍‌, “ହେୱାନ୍‌ ୱିଜ଼ୁ କାମାୟ୍‌ ହାର୍‌ କିଜ଼ି କିତାନ୍‌ନ୍ନା ! ହେୱାନ୍‌ ବଇରାରିଂ ୱେନି ସାକ୍ତି ଆରି ଗୁଲାରିଂ ବେଣ୍‌ କିନି ସାକ୍ତି ହିନାନା !” ");
INSERT INTO peg_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","ହେୱାଡ଼ାଂ ହେନି ମାନାୟାର୍‌ ଆରେ ରଗ ରୁଣ୍ଡାଆତାର୍, ଆରେ ହେୱାର୍‌ ତାକେ ତିନାକା ଉଣାକା ଇନାକା ହିଲ୍‌ୱିତିଲେ ଜିସୁ ଚେଲାହିରିଂ ଲାଗେ କୁକ୍‌ଚି ହେୱାରିଂ ୱେଚ୍‌ଚାନ୍‌, ");
INSERT INTO peg_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“ହେନି ମାନାୟାର୍‌ କାଜିଂ ନାଙ୍ଗ୍‌ କାର୍ମା ହତ୍‌ନାତା, ଇନାକିଦେଂକି ଇୱାର୍‌ ତିନି ଦିନ୍‌ ଆତାରେ ନା ହୁଦାଂ ମାନ୍‌ଞ୍ଜି ୱାନାରା ଆରେ ହେୱାର୍‌ ତାକେ ଇନାକାପା ତିନାକା ହିଲୁତ୍‌,” ");
INSERT INTO peg_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","ଜଦି ଆନ୍‌ ହେୱାରିଂ ନାସ୍‌କିତାଂ ଇଞ୍ଜ ପକ୍‌ତାଂଚି, ତା ଆତିସ୍‌ ହାସ୍‌ଦ ହେୱାର୍‌ ନାସ୍‌କି ବାଉଡ଼ା ଆନାର୍‌; ହେୱାର୍‌ ବିତ୍ରେ କେତେକ୍‌ ଦେହାତାଂ ୱାତାର୍ଣ୍ଣା । ");
INSERT INTO peg_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","ଚେଲାହିର୍‌ ତାଙ୍ଗ୍‌ ୱେନ୍‍ବାତାର୍, “ଇବେ ଇ ଚିମ୍‌ରା ବାହାତାକେ ଇନେର୍‌ ଇମେଣ୍ଡାଂ ରୁଟି ତାସି ଇୱାରିଂ ପଟପାଞ୍ଜି କିଦେଙ୍ଗ୍‌ ଆଡ୍‌ନାସ୍‌ ?” ");
INSERT INTO peg_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","“ଜିସୁ ହେୱାରିଂ ୱେନ୍‌ବାତାନ୍‌, ମି ତାକେ ଏଚଙ୍ଗ୍ ରୁଟିଂ ମାନିକ୍‌ ?” ହେୱାର୍‌ ଇଚାର୍‌, “ସାତ୍‌ଗଟା ।” ");
INSERT INTO peg_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","ହେବେତାଂ ଜିସୁ ମାନାୟାରିଂ ମେଦ୍‌ନିତ କୁଚ୍‌ଚେଂ ବଲ୍‌ ହିତାନ୍‌; ଆରି, ହେୱାନ୍‌ ହେୱାରିଂ ସାତ୍‌ଗଟା ରୁଟିଂ ଅଜ଼ି ଇସ୍ୱର୍‌ତିଂ ଜୁୱାର୍‌ କିଜ଼ି ହେ ୱିଜ଼ୁ ଡ୍ରିପ୍‌କିସ୍‌ ବାଟାକିଜ଼ି ହିଦେଙ୍ଗ୍‍ ଇଞ୍ଜି ହେ ଚେଲାହିରିଂ ହିତାନ୍‌ ଆରେ ହେୱାର୍‌ ମାନାୟାରିଂ ହେଦାଂ ପାସ୍‌ପିସ୍‍ ହିତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","ପାଚେ, ହେୱାର୍‌ ତାକେ ଅଲପ୍‍ ପାରାନେ କେତ୍‌ ଗଟା ହିରୁ ମିନ୍‌କୁ ମାଚିକ୍‌; ହେୱାଙ୍ଗ୍‌ ୱିଜ଼ୁ ହେୱାନ୍‌ ଇସ୍ୱର୍‌ତିଂ ଦନ୍ୟବାଦ୍‌ କିଜ଼ି ହେୱାରିଂ ବାଟା କିଦେଙ୍ଗ୍‌ ଇଞ୍ଜି ଇଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","ହେବେ ହେୱାର୍‌ ତିନ୍‌ଞ୍ଜି ପଟ ପାନ୍‌ଚାର୍ ଆରେ ସାତ୍‌ ଟପା ହାର୍‌ତି ଡ୍ରିକ୍‌ତି ରୁଟିଂ ନିିକ୍‍ଚି ଅତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","ହେୱାର୍‌ ଆନ୍‌ମାନ୍‌ ତାଙ୍ଗ୍‌ ଚାରି ହାଜାର୍‌ ଲକୁ ମାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","ତା ପାଚେ ହେୱାନ୍‌ ହେୱାରିଂ ପକ୍‌ତାନ୍‌ ଆରି ହେ ଦାପ୍ରେ ହେୱାନ୍‌ ତା ଚେଲାର୍‌ ହୁଦାଂ ଡଙ୍ଗାତ ଦୁମ୍‌ଜି ଦଲ୍‌ମନୁତା ନିପ ୱାତାର୍ । ");
INSERT INTO peg_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","ପାଚେ ପାରୁସିର୍‌ ବାର୍ତ ୱାଜ଼ି ତା ଲାହାଂ ବେଣ୍‌କିବାଦେଂ ଲାଗାତାର୍‌ ଆରି ତାଙ୍ଗେଙ୍ଗ୍‌ ପରିକ୍ୟା କିନି ବାବ୍‌ନାତ ଆକାସ୍‌ନି ର ଚିନ୍‌ ଏନ୍ତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","ହେବେତାଂ ହେୱାନ୍‌ ଜିବୁନ୍‌ତ ଗାଜା ପୁଣ୍ଡା ହିଜ଼ି ନେନ୍‍ଚାନ୍‍, “ନେଞ୍ଜେୱିଗାନି ନାର୍‌ ଇନାକିଦେଂକି ଚିନ୍‌ ଡେକ୍‍ନାରା ? ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ହାତ୍‌ପା ଇଞ୍ଜ୍‌ନାଙ୍ଗା, ନେଞ୍ଜେୱିଗାନି ନାର୍‍ଦିଂ ଇନାକାପା ଚିନ୍‌ ହିୟା ଆଉତ୍‌ !” ");
INSERT INTO peg_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","ଆରେ, ହେୱାନ୍‌ ହେୱାରିଂ ପିସ୍‌ସି ଆରି ରଗ ଡଙ୍ଗାତ ଦୁମ୍‌ଜି ଆନ୍‌ଟି ପାଡ଼ାକା ହାଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","ଜିସୁତି ଚେଲାର୍‌ ରୁଟି ଅଦେଂ ବାଣା ଆତାର୍‌; ଡଙ୍ଗାତ ହେୱାର୍‌ ତାକେ ମାତର୍‌ ରଞ୍ଜାଙ୍ଗ୍‌ନେ ରୁଟି ମାଚାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","ପାଚେ ଜିସୁ ହେୱାରିଂ ଇଚାନ୍‌, “ଜାଗ୍ରତ୍‌ ଆଡୁ,” ହେରଦ୍‌ତି ଆରି “ପାରୁସିର୍‌ତାଂ ଆରି ହେରଦ୍‌ତି ସାଦୁକିର୍ତି ହଇନିତାଂ ଜାଗ୍ରତ୍‌ ଆଜ଼ି ମାନାଟ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","ହେବେଣ୍ଡାଂ ହେୱେର୍‌ ନିଜେ ନିଜେ ବେଣ୍‌କିବା ଆଜ଼ି ଇଞ୍ଜେଙ୍ଗ୍‌ ଲାଗାତାର୍‌, “ମା ତାକେ ରୁଟି ହିଲୁତ୍‌ ଇଞ୍ଜି ହେୱାର୍‌ ଇଦାଂ ଇଚାର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","ଜିସୁ ହେଦାଂ ପୁଞ୍ଜି ହେୱାରିଂ ଇଚାନ୍‌, “ମି ତାକେ ରୁଟି ହିଲୁତ୍‌ ଇଞ୍ଜି ଇନାକିଦେଂ ହାରି ବେଣ୍‌କିବା ଆନାଦେରା ? ଏପେଙ୍ଗ୍‌ ଇନାକା ଇ ପାତେକ୍‌ ପୁନୁଦେରା କି ବୁଜା ଆଉଦେରା ? ଇନାକା ମି ମାନ୍‌ ଆଟ୍‌ୱା ଆତାତ୍‌ନ୍ନା ");
INSERT INTO peg_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","ମି ମାନ୍‌ ଇନାକା କାଲ୍‌ଲାକେ ଆତାତ୍‌ନ୍ନା ? କାଣ୍‌କୁ ମାନ୍‌ଞ୍ଜି ମାନ୍‌ଞ୍ଜି ହୁଡ଼ୁଦେରା ? ଆରେ, କିତୁଲିଂ ମାନ୍‌ଞ୍ଜି ମାନ୍‌ଞ୍ଜି ୱେନୁଦେରା ? ");
INSERT INTO peg_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","ହେ ପାଞ୍ଚ୍‌ ହାଜାର୍‌ ମାନାୟାର୍‌ ବିତ୍ରେ ଆନ୍‌ ଏଚେକାଡ଼୍‌ଦ ପାଞ୍ଚ୍‌ଗଟା ରୁଟିଂ ଡ୍ରିକ୍‌ଚି ମାଚାଙ୍ଗ୍‌ ହେ ପାଦ୍‌ନା ଏପେଙ୍ଗ୍‌ ବାର୍ତି ଏଚେ ଟପା କୁଦ୍ରି ଆତି ରୁଟିଂ ଅଜ଼ି ମାଚାଦେର୍‌ ହେଦାଂ ମିଙ୍ଗେଙ୍ଗ୍‌ ଏତ୍‌ ହିଲୁତ୍‌ ?” ହେୱାର୍‌ ହେୱାନିଂ ଇଚାର୍‌, “ବାର ଦାଉଡ଼ା ।” ");
INSERT INTO peg_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","ଆରେ, “ହେ ଚାରି ହାଜାର୍‌ ମାନାୟାର୍‌ ବିତ୍ରେ ଆନ୍‌ ଏଚେକାଡ଼୍‌ଦ ସାତ୍‌ଗଟା ରୁଟିଂ ଡ୍ରିକ୍‌ଚି ମାଚାଙ୍ଗ୍‌, ହେ ପାଦ୍‌ନା ଏପେଙ୍ଗ୍‌ ପୁରା ଏଚେ ଟପା ଡ୍ରିଙ୍ଗ୍‌ତି କୁଦ୍ରି ନିକ୍‌ଚି ଅଜ଼ି ମାଚାଦେର୍‌ ?” ହେୱାର୍‌ ଇଚାର୍‌, “ସାତ୍‌ ଟପା ।” ");
INSERT INTO peg_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","ହେବେ ଜିସୁ ହେୱାରିଂ ଇଚାନ୍‌, “ଏପେଙ୍ଗ୍‌ ଇନାକା ନଙ୍ଗ୍‌ ପାତେକ୍‌ ବୁଜା ଆଉଦେରା ।” ");
INSERT INTO peg_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","ପାଚେ ହେୱାର୍‌ ବେତ୍‌ସାଇଦାତ ୱାତାର୍ । ଆରି, ଲକୁ ର କାଣାଙ୍ଗ୍ ତା ଲାଗେ ତାଜ଼ି ତାଙ୍ଗେଙ୍ଗ୍‌ ଡୁଦେଂ ହେୱାନିଂ ଗୱାରି କିତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","ଲାଗିଂ ହେୱାନ୍‌ କାଣାଙ୍ଗ୍ କେଇ ଆଜ଼ି ତାଙ୍ଗେଙ୍ଗ୍‌ ନାସ୍‌ ବାର୍ତ ଅସି ହାଚାନ୍‌, ଆରେ ହେ କାଣ୍‌କୁକାଂ ଏୱିଡ଼ିଂ ଆରେ ତା ଜପି କେଇ ଇଡ଼ିିଜି ତାଙ୍ଗେଙ୍ଗ୍‌ ୱେନ୍‌ବାତାନ୍‌, “ଏନ୍‌ କି ଅଲପ୍‍ ହୁଡ଼୍‌ନାୟା ?” ");
INSERT INTO peg_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","ହେୱାନ୍‌ ଜପି ହୁଡ଼୍‌ଜି ଇଚାନ୍‌, ଆନ୍‌ ମାନାୟ୍‌ତିଂ ତାଂନାକା ହୁଡ଼୍‌ନାଙ୍ଗା, ମାତର୍‌ “ଆନ୍‌ ମାର୍‌ ଲାକେ ଇନାକା ତାଂନାକା ହୁଡ଼୍‌ନାଙ୍ଗା ।” ");
INSERT INTO peg_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","ତାପାଚେ ହେୱାନ୍‌ ଆରେ ରଗ ତା କାଣାଙ୍ଗାତ କେଇ ଡୁପ୍‌ତାନ୍; ହେବେ ହେୱାନ୍‌ ହାର୍‌ କିଜ଼ି ହୁଡ଼୍‌ତାନ୍ ଆରି ଉଜ୍‌ ଆଜ଼ି କାଣ୍‌ଙ୍ଗାମିଟ୍‌ ଇଚ୍‌ୱାଦାଂ ୱିଜ଼ୁ ହୁଡ଼୍‌ଦେଂ ଲାଗାତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","ପାଚେ ଜିସୁ ହେୱାନିଂ ଇଞ୍ଜ ପକ୍‌ଚି ଇଚାନ୍‌, “ଇ ନାସ୍‌ ହାଲ୍‌ମା ମାତର୍‌ ଜାର୍‌ ଇଞ୍ଜ ହାଲା ।” ");
INSERT INTO peg_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","ଇଦାଂ ପାଚେ ଜିସୁ ଆରି ତା ଚେଲାହିର୍‌ କାଇସରିୟା ପିଲିପ୍‌ପି ନିପ ନାସ୍‌କୁକାଂ ହାଚାର୍‌, ଆରି ହାନି ହାସ୍‌ଦ ହେ ଚେଲାହିରିଂ ଜିସୁ ୱେନ୍‌ବେଦେଂ ଲାଗାତାନ୍‌, “ଆନ୍‌ ଇନେର୍‌ ଇଞ୍ଜି ଲକୁ ଇନାକା ଇଞ୍ଜି ବାବି କିଦ୍ନାରା ?” ");
INSERT INTO peg_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","ଇବେ ହେୱାର୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ଇଚାର୍‌, “ବାପ୍ତିସିମ୍‌ହିନି ଜହନ୍‌,” ଆରେ ଇନେର୍‌ ଇନେର୍‌ ଏଲିୟ, ମାତର୍‌ ଇନେର୍‌ ଇନେର୍‌ ଇନାର୍‌, ବେଣ୍‌ବାକ୍‌ଣାୟ୍‌କିନାକାନ୍‌ ବିତ୍ରେ ରକାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","ହେୱାନ୍‌ ହେୱାରିଂ ୱେନ୍‌ବାତାନ୍‌, ମାତର୍‌ “ନାଙ୍ଗେଙ୍ଗ୍‌ ଇନେନ୍‌ ଇଞ୍ଜି ଏପେଙ୍ଗ୍‌ ଇନାକା ଇଞ୍ଜ୍‌ନାଦେରା ?” ପିତର୍‌ ହେୱାନିଂ ଉତର୍‌ ହିତାନ୍‌, “ଏନ୍‌ ଆନାୟା ଇସ୍ୱର୍‌ ବାଚିକିତି କ୍ରିସ୍ଟତି ।” ");
INSERT INTO peg_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","ମାତର୍‌ ଜିସୁ ହେୱାରିଂ “ହେ ବିସ୍ରେ ଇନେରିଂକି ଇନାକା ୱେଚ୍‌ୱେଦେଂ ବଲ୍‌ ହିତାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","ଆରେ, ଜିସୁ ହେୱାରିଂ ହିକାଇ କିଦେଙ୍ଗ୍‌ ଲାଗାତାନ୍‌ ଜେ, “ମାନାୟ୍‌ ମାଜ଼ି ଆତିସ୍‌ପା ବେସି ଦୁକ୍‌ପାୟା ଆଦେଂ ଆନାତ୍‌ ଆରେ ପ୍ରାଚିନାର୍‌, ମୁଡ଼୍‌ ମାପ୍ରୁହେବାକିନାକାନ୍‌ ଆରେ ସାସ୍ତିର୍‌ତି ହୁକେ ମୁନା କିୟାଜ଼ି ହାଦେଂ ଆନାତ୍‌, ଆରେ ତିନ୍‌ଦିନ୍‌ତାଂ ନିଙ୍ଗ୍‌ନାକା ମାନାତ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","ଇ ବେରଣ୍‌ ହେୱାନ୍‌ ପୁଟ୍‍ତେ ଇଚାନ୍‌ । ହେବେଣ୍ଡାଂ ପିତର୍‌ ହେୱାନିଂ ର ବାହାତ ଅଜ଼ି ଗଡ଼୍‌କିଦେଂ ଲାଗାତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","ମାତର୍‌ ହେୱାନ୍‌ ମାସ୍‌ଦି ହୁଡ଼୍‌ଜି ତା ଚେଲାହିରିଂ ପିତର୍‌ତିଂ ଗଡ଼୍‌ କିଜ଼ି ଇଚାନ୍‌, “ନା ମୁମ୍‌ଦାଂ ଗୁଚା, ସୟ୍‌ତାନ୍‌,” ଲାଗିଂ “ଏନ୍‌ ଇସ୍ୱର୍‌ ବିସ୍ରେ ବାବି କିୱାଦାଂ ଏନ୍‌ ମାନାୟ୍‌ ବିସ୍ରେ ବାବି କିନାୟା ।” ");
INSERT INTO peg_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","ତା ପାଚେ ଜିସୁ ତା ଚେଲାରିଂ ଆରି ରୁଣ୍ଡାତି ମାନାୟାରିଂ କୁକ୍‌ଚି ଇଚାନ୍‌, “ଇନେର୍‌କି ନା ହୁଦାଂ ୱାଦେଙ୍ଗ୍ ଇଚା କିନାନ୍‌, ହେୱାନ୍‌ ଜାର୍‌ତିଂ ପିହେନ୍‌ ଆରି ଜାର୍‌ତି କ୍ରୁସ୍‌ ଆସ୍ତି ନା ପାଚେ ପାଚେ ୱାୟେନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","ଇନାକିଦେଂକି “ଇନେର୍‌ ଜାର୍‌ ଜିବୁନ୍‌ ବାଚାୟ୍‌ କିଦେଙ୍ଗ୍‌ ଇଚା କିନାନ୍‌, ହେୱାନ୍‌ ହେଦାଂ ଆରାଇ କିନାନ୍‌; ମାତର୍‌ ଇନେନ୍‌ ଜଦି ନା ନେକ୍ରିକାବୁର୍‌ କାଜିଂ ତା ଜିବୁନ୍‌ ଆରାଇ କିନାନ୍‌, ହେୱାନ୍‌ ତା ଜିବୁନ୍‌ ରାକ୍ୟା କିନାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","ଆରେ, ମାନାୟ୍‌ ୱିଜ଼ୁ ପୁର୍ତିତିଂ ଲାବ୍‍କିଜ଼ି ଜାର୍‌ ଜିବୁନ୍‌ ହାଚ୍‌ନାନ୍, ହେଦାଂ ତାଙ୍ଗେଙ୍ଗ୍‌ ଇନା ଲାବ୍‌ ? ");
INSERT INTO peg_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","ଆରେ, ମାନାୟ୍‌ ଜାର୍‌ ଜିବୁନ୍‌ ବାଦୁଲ୍‌ ଇନାକା ହିଦେଂ ଆଡ୍‌ନାନ୍‌ ? ");
INSERT INTO peg_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","ଲାଗିଂ ଇନେର୍‌ ଇ କାଡ୍‌ନି ଦାରିୟାର୍‌ ଆରି ପାପିର୍‌ ମାନାୟ୍‌ ବିତ୍ରେ ନାଦାଂ ଆରି ନା ବଚନ୍‌ ବିସ୍ରେ ଲାଜା ଆନାନ୍‌, ମାନାୟ୍‌ ମାଜ଼ି ଏଚେକାଡ଼୍‌ଦ ପୁଇପୁୟା ଦୁତ୍‌ର୍‌ ଲାହାଙ୍ଗ୍‌ ନିଜେନି ଆବାତି ଜାଜ୍‌ମାଲ୍‌ତ ଆଜ଼ି ୱାନାନ୍‌, ହେବେତାଂ ହେୱାନ୍‌ପା ହେ ବିସ୍ରେ ଲାଜା ଆନାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","ଆରେ ରଗ ଜିସୁ ହେୱାରିଂ ଇଚାନ୍‌, “ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ହାତ୍‌ପା ଇଞ୍ଜ୍‌ନାଙ୍ଗା, ଇସ୍ୱର୍‌ ରାଜିତିଂ ସାକ୍ତି ହୁକେ ଏକା ୱାନାକା ହୁଡ଼୍‌ୱି ପାତେକ୍‌ ଇବେ ନିଲ୍‌ଚି ମାନି ମାନାୟ୍‌ ବିତ୍ରେ କେତେ ଜାଣ୍‌ ଇନେସ୍‌ କିତିସ୍‌ ପା ହାକିି ଦିନ୍‌ ହୁଡ଼ୁର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","ଚଅ ଦିନ୍‌ ପାଚେ ଜିସୁ ପିତର୍‌, ଜାକୁବ୍‌ ଆରି ଜହନ୍‌ତିଂ ହାଙ୍ଗ୍‌ ଅଜ଼ି ଅଲ୍‌ଗା ଆଜ଼ି ହେୱାରିଂ ର ପାନ୍ତି ମାଡ଼ିଜପି ଅଜ଼ି ହାଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","ଆରେ, ହେୱାର୍‌ ମୁମ୍‌ଦ ପାଗ୍‌ମାସ୍‌ବାତାନ୍‌, ତା ହେନ୍ଦ୍ରା ଏଲେଙ୍ଗ୍‌ ଅଜଡ଼୍‌ ଆରି ବେସି ଡ଼ିଞ୍ଜ୍‌ବାତାନ୍, ଜେ, ପୁର୍ତିନି ଇମ୍‌ଣି ଲଗୁପା ହେ ଲାକେ ଡ଼ିଞ୍ଜ୍‌ବେଦେଂ ଆଡୁର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","ଆରି, ମସା ଆରି ଏଲିୟ ଜିସୁ ଲାହାଙ୍ଗ୍‌ ବେରଣ୍‌ କିନାକାର୍‌ ହେୱାରିଂ ଚଞ୍ଜ୍‌ୟା ଆତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","ହେବେ ପିତର୍‌ ଜିସୁଙ୍ଗ୍‌ ଉତର୍‌ ହିତାନ୍‌, “ଏ ଗୁରୁ, ଆପେଂ ଜେ ଇ ବାହାତ ମାନାପ୍‌ !” ଇଦାଂ ହାରା ଆତାତ୍‌; “ଆସେଙ୍ଗ୍‌ ଇବେ ତିନ୍‌ଗଟା ପୁଟ୍‌କୁ ରଚ୍‌ନାସ୍, ନି କାଜିଂ ରଞ୍ଜାଙ୍ଗ୍‌, ମସା କାଜିଂ ରଞ୍ଜାଙ୍ଗ୍‌ ଆରେ ଏଲିୟ କାଜିଂ ରଞ୍ଜାଙ୍ଗ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","ପିତର୍‌ ଇନା ଉତର୍‌ ହିଦ୍‌ନାନ୍ ଇଞ୍ଜି ପୁନ୍‌ୱାଦାଂ ମାଚାର୍‌, ହେୱାଡ଼ାଂ ହେୱାର୍‌ ପାଣ୍ଡ୍ରା ଆଜ଼ି ମାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","ଆରେ, ଇଚୁଟିଂ ବାଦାଡ଼୍‌ ୱାଜ଼ି ହେୱାରିଂ ପାଡ଼ାକ୍‌ତାତ୍‌, ଆରି ହେ ବାଦାଡ଼୍‌ତାଂ ଇ କାତା ଆତାତ୍‌, “ଇୱାନ୍‌ ନା ୱାରିନି ମାଜ଼ି, ଇୱାନ୍ତି କାତା ୱେନାଟ୍‌ !” ");
INSERT INTO peg_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","ଆରେ, ହାଚାଟ୍ରେ ହେୱାର୍‌ ଚାରିବେଣ୍‌ତାଂ ହୁଡ଼୍‌ଜି ହେୱାର୍‌ ହୁଦାଂ ଜିସୁଙ୍ଗ୍‌ ପିସ୍ତି ଆରେ ଇନେରିଂ ପା ହୁଡ଼୍‌ୱାତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","ହେୱାର୍‌ ମାଡ଼ିତାଂ ଜୁନି ୱେଡ଼ାଲିଂ ଜିସୁ ହେୱାରିଂ ଆଟ୍‌ୱା ବଲ୍‌ ହିଜ଼ି ଇଚାନ୍‌, “ଏପେଙ୍ଗ୍‌ ଇନା ଇନାକା ହୁଡ଼୍‌ନାଦେରା, ହେଦାଂ ୱିଜ଼ୁ ହାତି ମାନାୟ୍‌ ବିତ୍ରେତାଂ ମାନାୟ୍‌ ମାଜ଼ି ତାଙ୍ଗ୍‌ ନିଙ୍ଗ୍‌ୱି ପାତେକ୍‌ ଇନେରିଂ ପା ୱେଚ୍‌ମାଟ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","ହେବେଣ୍ଡାଂ ହେୱାର୍‌ ହେ କାତା ଆଜ଼ି “ହାତାକାର୍‌ ବିତ୍ରେ ଆରେ ନିଙ୍ଗ୍‌ନାକା ଜେ ଇନାକା ? ଜିସୁ ବିସ୍ରେ ଜାର୍‌ ଜାର୍‌ ବିତ୍ରେ କାତାବାର୍ତା କିଦେଙ୍ଗ୍‌ ଲାଗାତାର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","ହେୱାର୍‌ ଜିସୁଙ୍ଗ୍‌ ୱେନ୍‌ବାତାର୍, “ତେବେ ଏଲିୟ ପର୍ତୁମ୍‌ ୱାନାନ୍‍, ଇଞ୍ଜି ଦରମ୍‌ ଗୁରୁର୍‌ ଇ କାତା ଇନେସ୍‌ ଇନାର୍‌ ?” ");
INSERT INTO peg_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","ହେବେଣ୍ଡାଂ ଜିସୁ ହେୱାରିଂ ଇଚାନ୍‌, “ଏଲିୟ ପର୍ତୁମ୍‌ ୱାଜ଼ି ସବୁ ବିସ୍ରେ ରଚ୍‍ନି କାତା ସତ୍‌, ମାତର୍‌ ମାନାୟ୍‌ ମାଜ଼ି ବେସି ଗିଣ୍‌କିୟା ଆନାନ୍‌, ଇଦାଂ ଇନେସ୍‌ ହେୱାନ୍‌ ବିସ୍ରେ ଲେକା ଆତାତ୍‌ନ୍ନା ? ");
INSERT INTO peg_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","ମାତର୍‌ ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ଇଞ୍ଜ୍‌ନାଙ୍ଗା, ଏଲିୟ ୱାତାନେ, ଆରେ ହେୱାନ୍‌ ବିସ୍ରେ ଇନେସ୍‌ ଲେକା ଆତାତ୍‌ନ୍ନା, ହେ ଲାକେ ପା ହେୱାର୍‌ ତା-କାଜିଂ ଇନାକା ଇଚା ହେଦାଂ କିତାନ୍‌ନ୍ନା ।” ");
INSERT INTO peg_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","ପାଚେ ହେୱାର୍‌ ଚେଲାର୍‌ ତାକେ ୱାଜ଼ି ହୁଡ଼୍‌ତାନ୍‌ ହେୱାର୍‌ ଚାରିବେଣ୍‌ତାଂ ବେସିହେନି ମାନାୟ୍‌ ଆରେ ଦରମ୍‌ ଗୁରୁର୍‌ ହେୱାର୍‌ ହୁକେ କାତାବାର୍ତା କିନାରା । ");
INSERT INTO peg_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","ମାନାୟାର୍‌ ହେୱାନିଂ ହୁଡ଼୍‌ତି ଦାପ୍ରେ ବେସି କାବା ଆତାର୍‌ ଆରି ହନ୍‌ଚି ୱାଜ଼ି ହେୱାନିଂ ଜୱାର୍‌ କିଦେଙ୍ଗ୍‌ ଲାଗାତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","ହେବେତାଂ ଜିସୁ ଚେଲାରିଂ ୱେନ୍‌ବାତାନ୍‌, “ଏପେଙ୍ଗ୍‌ ହେୱାର୍‌ ହୁକେ ଇନାକା ବେରଣ୍‌ବାଟ୍ କିନାଦେରା ?” ");
INSERT INTO peg_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","ମାନାୟ୍‌ ବିତ୍ରେ ରୱାନ୍‌ ହେୱାନିଂ ଉତର୍‌ ହିତାନ୍‌, “ଏ ଗୁରୁ ଆନ୍‌ ନା ମାଜ଼ିଙ୍ଗ୍‌ ନି ତାକେ ତାସି ମାଚାଙ୍ଗ୍‌; ତାଙ୍ଗେଙ୍ଗ୍‌ ର ଗୁଲା ପୁଦା ଆସ୍ତାତ୍‌ନା, ");
INSERT INTO peg_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","ଇମ୍‌ଣି ବାହାତପା ହେଦାଂ ତାଙ୍ଗେଙ୍ଗ୍‌ ଆହ୍‌ନାତ୍‌, ତାଙ୍ଗେଙ୍ଗ୍‌ ତାରେନ୍‌ ଗ୍ରୁତ୍‌ତାନ୍ନା, ହେୱାନ୍‌ ୱେଇଦାଂ ପୁମେଲ୍‌ ହନାତ୍‌ ଆରେ ଟାଡାଙ୍ଗ୍‌ କାଟ୍‌ନାନା ଆରି ହେୱାନ୍‌ ୱାଜ୍‌ଜି ହାନାନ୍‌; ତାଙ୍ଗେଙ୍ଗ୍‌ ପିହି କିିନି କାଜିଂ ଆନ୍‌ ମି ଚେଲାରିଂ ଇଞ୍ଜି ମାଚାଙ୍ଗ୍‌, ମାତର୍‌ ହେୱାର୍‌ ଆଡ୍‌ୱାତାର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","ଜିସୁ ହେୱାରିଂ ଉତର୍‌ ହିତାନ୍‌, “ଆଡ଼େ ପାର୍ତିକିୱି ଲାତ୍ରା ଏଚେକ୍‌ ଦିନ୍‌ ମି ହୁକେ ମାନାଙ୍ଗ୍‌ ? ଏଚେକ୍‍ଦିନ୍‌ ମି ଚିନ୍ତା ଆଡ୍‌ନାଂ ? କାଡ଼୍‌ଦେଂ ନାତାକେ ତାଇୱାଡୁ !” ");
INSERT INTO peg_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","ହେବେଣ୍ଡାଂ ହେୱାର୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ହେୱାନ୍‌ ତାକେ ତାହି ୱାତାର୍‌ । ଆରି ହେୱାନିଂ ହୁଡ଼୍‌ତି ଦାପ୍ରେ ହେ ପୁଦା ତାଙ୍ଗେଙ୍ଗ୍‌ ବେସି ମଡ଼ି କିତାତ୍‌ ଆରି ହେ ମେଦ୍‌ନିତ ଗୁର୍‌ଜି ପୁମେଲ୍‌ ଉର୍‌ଚି ଡଣଗୁର୍‌ଦେଂ ଲାଗାତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","ହେ କାଡ଼୍‌ଦ ହେୱାନ୍‌ ତା ଲାତ୍ରାହିଙ୍ଗ୍‌ ୱେନ୍‌ବାତାନ୍‌, “ଏଚେଦିନ୍‌ ଆତାତ୍‌ ଇୱାନିଂ ଏଲେଙ୍ଗ୍‌ ଆନାତା ?” ହେୱାନ୍‌ ଇଚାନ୍‌, “ହିରୁୱେଡ଼ାଙ୍ଗ୍ ତାଙ୍ଗ୍‌,” ");
INSERT INTO peg_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","“ହେୱାନ୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ଅସ୍ତେଙ୍ଗ୍‌ ଇଞ୍ଜି ବାର୍‌ ବାର୍‌ ନାଣିତ ଆରି ଏଜ଼ୁକାଂ ତୁହିହିତାତ୍‌ନା; ମାତର୍‌ ଏନ୍‌ ଜଦି ଇନାକା କିଦେଙ୍ଗ୍‌ ଆଡ୍‌ନାୟ୍‌, ତା ଆତିସ୍‌ ମା କାଜିଂ କାର୍ମା ଆଜ଼ି ଉପ୍‌କାର୍‌ କିଦା ।” ");
INSERT INTO peg_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","ହେବେ ଜିସୁ ତାଙ୍ଗେଙ୍ଗ୍‌ ଇଚାନ୍‌, “ଇନାକା ଇଚାୟ୍‌ ? ଜଦି କିଦେଙ୍ଗ୍‌ ଆଡ୍‌ନାୟ୍‌ ! ପାର୍ତି କିନାକାନ୍‌ ତାକେ ୱିଜ଼ୁ ଆନାତ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","“ହେ ସାଙ୍ଗେ କାଡ଼୍‌ଦେ ଲାତ୍ରାହି ଗାଜା କାଟ୍‌ତାଂ ଇଚାନ୍‌, ଆନ୍‌ ପାର୍ତି କିନାଙ୍ଗା, ନା ପାର୍ତି କିୱାକା ବାଡାୟ୍‌ କିଦା ।” ");
INSERT INTO peg_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","ପାଚେ ଲକୁ ରବେ ହନ୍‌ଚି ୱାନାକା ହୁଡ଼୍‌ଜି ଜିସୁ ହେ ବାନ୍ୟା ପୁଦା ଜିବୁନ୍‌ତିଂ ଦାମ୍‌କାୟ୍‌ କିଜ଼ି ଇଚାନ୍‌, “ଏ ଗୁଲା ଆରି ବୟିରା ଜିବୁନ୍‌ ଆନ୍‌ ନିଙ୍ଗେଙ୍ଗ୍‌ ବଲ୍‌ ହିଦ୍‌ନାଙ୍ଗା, ଇବେଣ୍ଡାଂ ହସି ହାଲା, ଆରେ ରଗ ଇନାୱାଡ଼ାଂପା ଇୱାନ୍‌ ତାକେ ହଣୁୟ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","ହେବେ ହେଦାଂ କିରିଡ଼ି ପାଡ଼ି କିଜ଼ି ତାଙ୍ଗେଙ୍ଗ୍‌ ମଡ଼ିକିଜ଼ି ହସି ହାଚାତ୍‌, ଆରେ କାଡ଼୍‌ଦେ ହାତିଲାକେ ଆତାନ୍‌, ଏଲେଙ୍ଗ୍‌ ଆତି କାଜିଂ ଆଦେକ୍‌ ହେନି ଇଚାର୍‌, “ହେୱାନ୍‌ ହାତାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","ମାତର୍‌ ଜିସୁ ତା କେଇ ଆସ୍ତି ତାଙ୍ଗେଙ୍ଗ୍‌ ନି‍କ୍‌ତାନ୍, ଆରେ ହେୱାନ୍‌ ନିଙ୍ଗ୍‌ତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","ଆରେ, ହେୱାନ୍‌ ଇଞ୍ଜ ୱାତିଲେ, ହେୱାନ୍‌ “ଚେଲାହିର୍‌ ହେୱାନିଂ କାଲେତାଂ ୱେନ୍‌ବେଦେଂ ଲାଗାତାର୍‌, ଆପେଂ ପୁଦାତିଙ୍ଗ୍‌ ଇନେକିଦେଂ ପିହିକିଦେଂ ଆଡ୍‌ୱାତାପ୍‌ ?” ");
INSERT INTO peg_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","ଜିସୁ ହେୱାରିଂ ଇଚାନ୍‌, “ପାର୍ତାନା ଆୱିତିସ୍‌ ଆରି ଇମ୍‌ଣି ବାନ୍ୟା ପୁଦା ପିହିକିୟା ଆଉତ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","ଜିସୁ ଆରି ଚେଲାର୍‌ ହେ ବାହାତ ପିସ୍ତି ଗାଲିଲି ନିପତିଂ ଆଜ଼ି ହାଚାର୍‌, ଆରି ଇନେର୍‌ ହେଦାଂ ପୁନ୍‌ମେର୍‌ ଇଞ୍ଜି ମାନ୍‌ ହିଲ୍‌ୱାତାତ୍‌, ");
INSERT INTO peg_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","ଇନାକିଦେଂକି ହେୱାନ୍‌ ତା ଚେଲାରିଂ ଇ କାତା ଇଞ୍ଜି ହିକ୍ୟା ହିଜ଼ି ମାଚାନ୍‌, ହେୱାନ୍‌ ହେୱେରିଂ ଇଚାନ୍‌ । “ମାନାୟ୍‌ ମାଜ଼ି ମାନାୟ୍‌ କେଇଦ ହେଲାୟ୍‌ କିୟା ଆନାନ୍‌, ଆରେ ହେୱାର୍‌ ହେୱାନିଂ ଟ୍ରାକ୍‌ନାର୍‌ ଆରେ ହେୱାନ୍‌ ହାତି ପାଚେ ତିନ୍‌ଦିନ୍‌ ତାଙ୍ଗ୍‌ ପାଚେ ଆରେ ନିଙ୍ଗ୍‌ନାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","ମାତର୍‌ ଚେଲାର୍‌ ହେ କାତା ବୁଜା ଆୱାତାର୍‌ ଆରେ ହେୱାନିଂ ୱେନ୍‌ବେଦେଂ ପାଣ୍ଡ୍ରା ଆଜ଼ି ମାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","ପାଚେ ହେୱାର୍‌ କପର୍ନାହୁମ୍‌ ୱାତାର୍ । ଜିସୁ ଇଞ୍ଜ ଏକିସ୍‌ ହେୱାରିଂ ୱେନ୍‌ବାତାନ୍‌, “ଏପେଙ୍ଗ୍‌ ହାସ୍‌ଦ ଇନାକା କାତା ବାର୍ତା କିଜ଼ି ମାଚାଦେର୍‌ ?” ");
INSERT INTO peg_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","ମାତର୍‌ ହେୱାର୍‌ ଚିମ୍‌ରା ଆଜ଼ି ମାଚାର୍‌, ଇନାକିଦେଂକି ସାର୍ଗେ ରାଜିତ ଇନେର୍‌ ଗାଜା, ଇ କାତା ଆସ୍ତି ହାସ୍‌ଦ ଗାଣ୍‌ଜୁ କିଜ଼ି ମାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","ହେବେ ହେୱାନ୍‌ କୁଚ୍‌ଚି ବାରଜାଣ୍ ଚେଲାରିଂ କୁକ୍‌ତାନ୍‌ ଆରି ହେୱାରିଂ ଇଚାନ୍‌, “ଜଦି ଇନେର୍‌ ମୁଡ଼୍‌ ଆଦେଂ ଇଚା କିନାନ୍‌ ତାଆତିସ୍‌ ହେୱାନ୍‌ ୱିଜ଼ାକାର୍‌ ତାଙ୍ଗ୍‌ ହାରୁକାନ୍‌ ଆରି ୱିଜ଼ାକାରିଂ ହେବା କିନାକାନ୍‌ ଆୟେନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","ଆରେ, ହେୱାନ୍‌ ର ହାରୁ କାଡ଼୍‌ଦେଂ ଆସ୍ତି ହେୱାର୍‌ ମାଦି ନିଲି କିତାନ୍‌ ଆରେ ତାଙ୍ଗେଙ୍ଗ୍‌ ଡନ୍‌ଞ୍ଜି ହେୱାରିଂ ଇଚାନ୍‌, ");
INSERT INTO peg_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“ଇନେର୍‌ ନା ତର୍‌ଦ ଏଲେଙ୍ଗ୍‌ ହାରୁ ହିମ୍‌ଣା ବିତ୍ରେ ରକାନିଂ ଇଟ୍‌ନାର୍‌, ହେୱାନ୍‌ ନାଙ୍ଗେଙ୍ଗ୍‌ ଇଟ୍‌ନାନ୍‌, ଇନେର୍‌ ନାଙ୍ଗେଙ୍ଗ୍‌ ଇଟ୍‌ନାନ୍‌, ମାତର୍‌ ନା ପକ୍ତିତି ଆବାଙ୍ଗ୍‌ ମାନି କିନାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","ଜହନ୍‌ ଜିସୁଙ୍ଗ୍‌ ଇଚାନ୍‌, “ଏ ଗୁରୁ, ମା କୁଦା ତାକେ ରୱାନ୍‌ ହିଲ୍‌ୱିତି ଲଗାଙ୍ଗ୍ ନି ତର୍‌ଦାଂ ପୁଦା ପିହ୍‌ନାକା ହୁଡ଼୍‌ତାପ୍, ଆରେ ହେୱାନ୍‌ ମା କୁଦା ତ ହିଲ୍‌ୱିତିଲେ ମୁନାକିତାପ୍ ।” ");
INSERT INTO peg_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","ମାତର୍‌ ଜିସୁ ଇଚାନ୍‌, “ତାଙ୍ଗେଙ୍ଗ୍‌ ମୁନା କିମାଟ୍‌; ଇନେକିଦେଂକି ନା ତର୍‌ଦ ସାକ୍ତିନି କାମାୟ୍‌ କିଜ଼ି ହାଚାଟ୍ରେ ନାଦାଂ ବାନ୍ୟା କିଦେଙ୍ଗ୍‌ ଆଡ୍‌ନାନ୍‌, ଏପେଙ୍ଗ୍‌ ଲଗୁ ଇନେର୍‌ ହିଲୁର୍‌; ");
INSERT INTO peg_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","ଇନେକିଦେଂକି ଇନେର୍‌ ମା ବିରୁତ୍‌ ଆକାୟ୍‌, ହେୱାନ୍‌ ମାପାକ୍ୟା । ");
INSERT INTO peg_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ହାତ୍‌ପା ଇଞ୍ଜ୍‌ନାଙ୍ଗା, ଏପେଙ୍ଗ୍‌ କ୍ରିସ୍ଟତି ଲକୁ ଇଞ୍ଜି ଇନେର୍‌କି ମିଙ୍ଗେଙ୍ଗ୍‌ ର ଗିନା ଏଜ଼ୁଂ ଉଣ୍ଡେଙ୍ଗ୍‌ ହିତ୍‍ତିସ୍, ହେୱାନ୍‌ ଇନେସ୍‌ କିଜ଼ିପା ଜାର୍‌ ମୁକୁଟ୍‌ ଆରାୟ୍‌ କିଉନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“ଜିସୁ ଆରେ ଇଞ୍ଜେଙ୍ଗ୍‌ ଲାଗାତାନ୍‌, ଇନେର୍‌ ପାର୍ତି କିଜ଼ି ମାନି ଇ ହାରୁକାର୍‌ ବିସ୍ରେ ରକାନିଂ ବାଦା ଆତିସ୍‌, ହେୱାନ୍‌ ହାକ୍‌ତ ର ଗାଜା ଜାତାକାଲ୍‌ ଡ଼ଇ କିଜ଼ି ହେୱାନିଂ ହାମ୍‌ଦୁର୍‌ ତାକେ ତୁଇ ହିଗିତିସ୍‌ ହେଦାଂ କାଜିଂ ହାରା ଆତାତ୍ମା । ");
INSERT INTO peg_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","ଆରେ, ମି କେଇ ଜଦି ମିଦାଙ୍ଗ୍‌ ବାଦା ଆନାତ୍‌, ତାଙ୍ଗେଙ୍ଗ୍‌ କାଦ୍‌ଦି ତୁସି ହିୟାଟ୍‌, ଆରି ରି କେଇ ଅଜ଼ି ନରକ୍‌, ଇଚିସ୍‌ ହାୱିନାଣି ବିତ୍ରେ ହାନି ବାଟା ଟୁଟାଆଜ଼ି ଜିବୁନ୍‌ତ ହଣଗାନାକା ମି ପାକ୍ୟାତ ହାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","ଇନାକିଦେଂକି ନାଣିତ ହେୱାର୍‌ତି ପ୍ଡିକୁ ଜିରା ଆଉକ୍‌, ଆରି ନାଣି ହାହୁତ୍ । ");
INSERT INTO peg_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","ଆରେ, ମି ପାନା ଜଦି ମିଙ୍ଗେଙ୍ଗ୍‌ ବାଦା ହିଦ୍‌ନାତା ହେଦେଲିଂ କାଦ୍‌ଦି ତୁସିହିୟାଟ୍‌, ରି ପାନାଙ୍ଗ୍‌ ତାସି ନରକ୍‌ତ ଦେହେନି ବାଟା ଚଟା ଆଜ଼ି ଜିବୁନ୍‌ତ ହାନାକା ମି ପାକ୍ୟାତ ହାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","ଇନାକିଦେଂକି ନାଣିତ ହେୱାର୍‌ତି ପ୍ଡିକୁ ଜିରା ଆଉକ୍‌, ଆରି ନାଣି ମୁଡ଼୍‌କେ ହାଉତ୍ । ");
INSERT INTO peg_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","ଆରେ ମି କାଣ୍‌ଙ୍ଗା ଜଦି ମିଙ୍ଗେଙ୍ଗ୍‌ ବାଦା ହିଦ୍‌ନାତା, ଇଚିସ୍‌ ହେ କାଣାଙ୍ଗାତିଂ ଉନ୍‌ଦି ତୁହି ହିୟାଟ୍‌, ରି କାଣ୍‌କୁ ଅଜ଼ି ନରକ୍‌ତ ତୁହିହିନି ବାଟା ର କାଣ୍‌ଙ୍ଗା ଅଜ଼ି ମାପ୍ରୁ ରାଜିତ ହଣାକା ନି ପାକ୍ୟାତ ହାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","ଇନାକିଦେଂକି ନାଣିତ ହେୱାର୍‌ତି ପ୍ଡି ୱିଜ଼ୁତ୍ ଆରି ନାଣି ହାଉତ୍ ।” ");
INSERT INTO peg_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“ଲାଗିଂ ୱିଜ଼ାର୍‌ ନାଣିତ ହର୍‌ ଲାକେ ହୱାଦ୍‌ । ହର୍‌ ହାର୍ଦାକା, ମାତର୍‌ ହର୍‌ ଜଦି କାର୍ୟା ଆନାତ୍‌, ତା ଆତିସ୍‌ ହେଦେଲିଂ ଇନାକାତ ହୱାଦ୍‌ କିୟାନାତ୍‌ ? ଏପେଙ୍ଗ୍‌ ଜାର୍‌ ବିତ୍ରେ ହର୍‌ ହୱାଦ୍‌ ସମାନ୍‌ ମାନାଟ୍‌ ଆରି ହାରି ଲାହାଂ ସୁସ୍ତାତ ମାନାଟ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“ହର୍‌ ହାର୍‌ଦାକା, ଏଲେଙ୍ଗ୍‌ ହର୍‌ ଲାକେ ଆୱାତାତ୍‍ଚି, ତା ଆତିସ୍‌ ଇନାକାତ ହୱାଦ୍‌ କିନାକା ? ଏପେଙ୍ଗ୍‌ ଜାର୍‌ ଜାର୍‌ ତାକେ ହାର୍‌ ଗୁଣ୍‌ ଇଟାଟ୍‌ ଆରେ ୱିଜ଼ାକାଦେର୍‌ ସୁସ୍ତାତ ମାନାଟ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","ଜିସୁ ହେ ବାହାତାଂ ହାଲ୍‌ଜି ପା ଜିହୁଦାନିପ ଆରି ଜର୍ଦନ୍‌ ନାଗୁଡ଼୍‌ ନାସି ୱାତାନ୍‌, ଆରେ ମାନାୟ୍‌ ତାକେ ଆରେ ରଗ ହେଦାଂ ମେହା ଆତାନ୍‌, ହେୱାନ୍‌ ନିଜେ ନି ନିତି ତାଙ୍ଗ୍‌ ହେୱାରିଂ ହିକାଇ କିଦେଙ୍ଗ୍‌ ଲାଗାତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","ଇବେଣ୍ଡାଂ ପାରୁସିର୍‌ ତା ତାକେ ୱାଜ଼ି ତାଙ୍ଗେଙ୍ଗ୍‌ ପରିକ୍ୟା କିଜ଼ି ୱେନ୍‌ବାତାର୍, ମା “ବିଦି ହିଦ୍‍ନାତା କି ରୱାନ୍‌ ତା ଡକ୍ରୁହିଂ ପିସ୍‌ସି ହେଦାଂ ଇନାକା ଆଣ୍ଡ୍ରେନ୍‌ ତାକେ ନିୟାୟ୍‌ ମାନାତ୍‍କି ?” ");
INSERT INTO peg_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","ଜିସୁ ହେୱାରିଂ ଉତର୍‌ ହିତାନ୍‌, “ମସା ମିଙ୍ଗେଙ୍ଗ୍‌ ଇନା ବଲ୍‌ ହିତ୍‌ତାନ୍ନା ?” ");
INSERT INTO peg_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","ହେୱାର୍‌ ଇଚାର୍‌, “ହେଲ ଆକି ଲେକି କିଜ଼ି କଗ୍‌ଲେଂ ପିହ୍‌ନି କାଜିଂ ମସା, ହେଲ ହିତାନ୍‌ନା ।” ");
INSERT INTO peg_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","ହେବେ ଜିସୁ ହେୱାରିଂ ଇଚାନ୍‌, “ମି ମାନ୍‌ ଆଟ୍‌ୱା ହୁଡ଼୍‌ଜି ମସା ମି କାଜିଂ ଇ ବଲ୍‌ ଲେକି କିତାନ୍‌ନ୍ନା । ");
INSERT INTO peg_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","ମାତର୍‌ ଉବ୍‌ଜାଣ୍‌ ଆତି ଆରମ୍‌ତାଂ ଇସ୍ୱର୍‌ ହେ ଲାକେ ହେୱାରିଂ ଆଣ୍ଡ୍ରେନ୍‌ ଆରେ କଗ୍‌ଲେ କିଜ଼ି ଉବ୍‌ଜାଣ୍‌ କିତାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","“ଇଦାଂ କାଜିଂ ଆଣ୍ଡ୍ରେନ୍‌ ଜାର୍‌ ଆବା ଆୟାଂ ପିିହିନାନ୍, ଆରି ହେୱାର୍‌ ଏକ୍‌ ଆନାର୍‌, ");
INSERT INTO peg_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","ଆରେ ହେୱାର୍‌ ରିକାର୍‌ ଆକାୟ୍‌, ମାତର୍‌ ର ଗାଗାଡ଼୍‌ ଆନାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","ଲାଗିଂ ଇସ୍ୱର୍‌ ଇମ୍‌ଣାକାରିଂ ମେହାୟ୍‌ କିତାନ୍‌ନ୍ନା, ମାନାୟ୍‌ ହେଦାଂ ଏଡ଼ାୟ୍‍ କିମେର୍ ।” ");
INSERT INTO peg_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","ପାଚେ ଚେଲାର୍‌ ଇଞ୍ଜ ହେୱାନିଂ ଇ ବିସ୍ରେ ଆରେ ରଗ ୱେନ୍‌ବେଦେଂ ଲାଗାତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","ହେବେଣ୍ଡାଂ ହେୱାନ୍‌ ହେୱାରିଂ ଇଚାନ୍‌, “ଇନେର୍‌ ଜାର୍‌ ଡକ୍ରିଂ ପିସ୍ତି ବିନ୍‌ନିକାତିଂ ବିବାଆତିସ୍, ହେୱାନ୍‌ ତା ବିରୁଦ୍‌ତ ଦାରି ଆନାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","ଆରେ, ଜଦି କଗ୍‌ଲେ ଜାର୍‌ ଡକ୍ରାଙ୍ଗ୍ ପିସ୍ତି ବିନ୍‍ଲୁଗାଂ ବିବା ଆତିସ୍‌, ଲାଗିଂ ହେଦେଲ୍‌ ଦାରି ।” ");
INSERT INTO peg_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","ହେୱାନ୍‌ ଇନେସ୍‌ ହିମ୍‌ଣାକାଂ ଡୁଜ଼ି ଆସିର୍ବାଦ୍‌ କିନାନ୍‌, ଇଦାଂ କାଜିଂ ହେୱାରିଂ ହେୱାନ୍‌ ତାକେ ତାତେଙ୍ଗ୍‌ ଲାଗାତାର୍‌, ମାତର୍‌ ଚେଲାର୍‌ ହେୱାରିଂ ଦାକା କିତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","ଜିସୁ ହେଦାଂ ହୁଡ଼୍‌ଜି ରିସା ଆଜ଼ି ହେୱାରିଂ ଇଚାନ୍‌, “ହିମ୍‌ଣାକାଂ ନା ତାକେ ୱାଦେଙ୍ଗ୍ ହିଆଟ୍, ହେୱାରିଂ ମୁନାକିମାଟ୍, ଇଦାଂ କାଜିଂ ଇସ୍ୱର୍‌ତି ରାଜି ଇ ଲାକେ ମାନାୟାର୍‌ତି । ");
INSERT INTO peg_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ହାତ୍‌ପା ଇଞ୍ଜ୍‌ନାଙ୍ଗା, ଇନେର୍‌ ହିମ୍‌ଣାଂ ଲାକେ ଇସ୍ୱର୍‌ ରାଜିତ ଆୱିତିସ୍‌, ହେୱାନ୍‌ ଇନେସ୍‌ କିଜ଼ି ପା ସାର୍ଗେ ରାଜିନିପ ହେବେ ହଣ୍ଡେଙ୍ଗ୍‍ ଆଡୁନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","ଆରେ, ହେୱାନ୍‌ ହେୱାରିଂ ଡ୍ରକ୍‌ଚି କେଇ ଇଡ଼୍‌ଜି ଆର୍ସିବାଦ୍‌ କିତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","ଜିସୁ ହାନିହିଂ ହାଞ୍ଜେଙ୍ଗ୍‌ ଆରାମ୍‌ କିନି ୱେଡ଼ାଲିଂ ରକାନ୍‌ ହନ୍‍ଚି ୱାଜ଼ି ହେୱାନ୍‌ ଲାଗାଂ ମେଣ୍ଡାକୁନ୍ଦି କିଜ଼ି ହେୱାନିଂ ୱେନ୍‌ବାତାନ୍‌, “ଏ ସତ୍‌ ଗୁରୁ, ୱିଜ଼୍‌ୱି ଜିବୁନ୍‌ ପାୟା ଆଦେଂ ଆନ୍‌ ଇନାକା କିନାଙ୍ଗ୍‌ ?” ");
INSERT INTO peg_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","ହେବେଣ୍ଡାଂ ଜିସୁ ହେୱାନିଂ ଇଚାନ୍‌, “ନାଙ୍ଗେଙ୍ଗ୍‌ ହାର୍‌ ଇଞ୍ଜି ଇନେକିଦେଂ ଇଞ୍ଜ୍‌ନାୟା ?” ରୱାନ୍‌ ପିସ୍ତି, ଇଚିସ୍‌ “ଇସ୍ୱର୍‌ ତାଙ୍ଗ୍‌ ଇନେର୍‌ ହାର୍ଦାକାର୍‌ ହିଲୁର୍ ।” ");
INSERT INTO peg_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","ବଲ୍‌କୁ ତ ଏନ୍‌ ପୁଚାୟ୍‍ନା, ନାର୍‌ତିଂ ଅହ୍‌ମାଟ୍‌, ଦାରି କିମାଟ୍, କୁଟ୍‌ କିମାଟ୍‌, ଜାର୍‌ ଆବା ଆୟାକାଂ ୱାରି କିୟାଟ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","ହେୱାନ୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ଇଚାନ୍‌, “ଏ ଗୁରୁ, ଇଦାଂ ୱିଜ଼ୁ ନିୟମ୍‌ ହାରୁୱେଡ଼ାଙ୍ଗ୍‌ତାଂ ଆନ୍‌ ବେଣ୍ଡିୟା ୱେଡ଼ାତାଙ୍ଗ୍ ମାନି କିଜ଼ି ୱାନାଙ୍ଗା ।” ");
INSERT INTO peg_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","ଜିସୁ ହେୱାନ୍‌ କାଜିଂ ରବେ ହୁଡ଼୍‌ଜି ହେୱାନିଂ ଜିଉନଜ଼ି ଆରେ ଇଚାନ୍‌, “ନିନ୍ଦାଂ ର ବିସ୍ରେ ଉଣା ମାନାତ୍‌, ଏନ୍‌ ହାଲ୍‌ଜି ନିଜେତି ସବୁ ପ୍ରସି ଅର୍କିତ୍‌ ତାରିଙ୍ଗ୍‌ ଦାନ୍‌ ହିୟା, ଆରେ ଏନ୍‌ ସାର୍ଗେନି ଦାନ୍‌ ପାୟା ଆନାୟ୍‌; ଆରେ ୱାଜ଼ି ନା ପାଚେ ପାଚେ ୱା ।” ");
INSERT INTO peg_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","ମାତର୍‌ ଇ କାତାତ ତା ମୁମ୍‌ ରାତ୍‌ତାନ୍ ଆରେ ହେୱାନ୍‌ ଦୁକ୍‌ ଆଜ଼ି ହାଚାନ୍‌, ଇଚିସ୍‌ ହେୱାନ୍ତି ବେସି ଦାନ୍‌ ମାଚାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","ପାଚେ ଜିସୁ ଚାରିବେଣ୍‌ତାଂ ହୁଡ଼୍‌ଜି ନିଜେତି ଚେଲାରିଂ ଇଚାନ୍‌, “ଇନେର୍‌ତି ଦାନ୍‌ ମାନାତ୍‌, ହେୱାର୍‌ କେତେକ୍‌ କସ୍ଟତାଂ ଇସ୍ୱର୍‌ ରାଜିତ ହାନାର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","ଜିସୁତି କାତା ୱେନ୍‌ଞ୍ଜି ଚେଲାର୍‌ କାବା ଆତାର୍‌, ମାତର୍‌ ଜିସୁ ଆରେ ରଗ ହେୱେରିଂ ଇଚାନ୍‌, “ବପାର୍‌ ଇସ୍ୱର୍‌ ରାଜିତ ହାନାକା କେତେକ୍‌ କସ୍ଟ !” ");
INSERT INTO peg_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","ଇସ୍ୱର୍‌ ରାଜିତ ମାଜାନିଂ ହାଣାକା ଇଚିସ୍‌ ହୁଜା କାଣାତ ଉଟ୍‌ ହାଣାକା ଆଡ଼୍‌ୱା, ର ମାଜାନ୍‌ ସାର୍ଗେ ରାଜିତ ହାଣାକା ବେସି କସ୍ଟ । ");
INSERT INTO peg_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","ଇଦାଂ ହେୱାର୍‌ ବେସି କାବା ଆଜ଼ି ହେୱାର୍‌ ହେୱାର୍‌ନେ ଇନ୍‌ବା ଆତାର୍‌, “ଇଚିସ୍‌ ଇନେର୍‌ ମୁକ୍ତି ପାୟା ଆନାନ୍‌ ?” ");
INSERT INTO peg_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","ଜିସୁ ହେୱାରିଂ ସିଦା ହୁଡ଼୍‌ଜି ଇଚାନ୍‌, “ଇଦାଂ ମାନାୟ୍‌ତିଂ କିୟା ଆୱାକା, ମାତର୍‌ ଇସ୍ୱର୍‌ତି ଆକାୟ୍‌; ଇଚିସ୍‌ ଇସ୍ୱର୍‌ତି ୱିଜ଼ୁ ଆନାତ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","ପିତର୍‌ ହେୱାନିଂ ଇଚାନ୍‌, “ହୁଡ଼ାଟ୍‌, ଆପେଂ ୱିଜ଼େ ପିସ୍‌ସି ନି ପାଚେ ପାଚେ ୱାନାପା ।” ");
INSERT INTO peg_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","ଜିସୁ ଇଚାନ୍‌, “ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ହାତ୍‌ପା ୱେଚ୍‌ଚାନାଙ୍ଗା, ଇମ୍‌ଣାକାନ୍‌ ନା ନେକ୍ରିକାବୁର୍‌ କାଜିଂ ଇଲ୍‌ କି ଟଣ୍ଡେନ୍‌ କି ତଣ୍‌ଦେଲ୍‌ କି ଆୟା କି ଆବା କି ହିମ୍‌ଣାୱାକ୍‌ଡ଼ା କି ବୁମି ପିସ୍ତାନ୍‍ନା । ");
INSERT INTO peg_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ଆରେ ଅଙ୍ଗୟ୍‌ ଇ କାଡ଼୍‌ଦ ଦୁକ୍‌ ସାଙ୍ଗେ ସାଙ୍ଗେ ପାଞ୍ଚକଡ଼ି ଗୁଣ୍‌ତ ଇଲ୍‌, ଟଣ୍ଡେନ୍‌, ତଣ୍‌ଦେଲ୍‌, ଆୟା, ହିମ୍‌ଣାୱାକ୍‌ଡ଼ା ଆରେ ବୁମି, ଆରେ ପାଚେନି ଜୁଗ୍‌ତ ୱିଜ଼୍‌ୱି ଜିବୁନ୍‌ ପାୟା ଆଉନ୍‌, ଏଲେଙ୍ଗ୍‌ ବାର୍ତି ମାନାୟ୍‌ ଇନେର୍‌ ହିଲୁର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","ମାତର୍‌ ଆଗେ ମାନି ହେନି ମାନାୟାର୍‌ ପାଚେ ଆନାର୍‌ ଆରି ପାଚେ ମାନି ହେନି ମାନାୟାର୍‌ ହିଗ୍‌ଦ ଆନାର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","ହେୱାର୍‌ ଜିରୁସାଲମ୍‌ ତାକେ ହାନିୱାଡ଼ାଂ ହାସ୍‌ଦ ମାଚାର୍‌ ଆରି ଜିସୁ ହେୱାର୍‌ ଆଗେ ଆଗେ ହାଲ୍‌ଜି ମାଚାନ୍‌, ଆରି, ଚେଲାର୍‌ କାବା ଆରି ପାଚେ ମାଚି ଲଗାଂ ପାଣ୍ଡ୍ରୁ ଆଜ଼ି ମାଚାର୍‌ । ଇଦାଂ କାଜିଂ ହେୱାନ୍‌ ଆରେ ବାରଜାଣାତିଂ ବିନେ କିଜ଼ି, ହେୱାନ୍‌ ବିସ୍ରେ ଇନା ଇନାକା ଜିରୁସାଲମ୍‌ ଗିଟା ଆଦେଂ ହାନାତା, ହେ ୱିଜ଼େ ହେୱେରିଂ ଜାଣାଇ କିଦେଙ୍ଗ୍‌ ଲାଗାଆତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","ହେୱେନ୍‌ ଇଚାନ୍‌, “ହୁଡ଼ାଟ୍‌, ଆପେଂ ଜିରୁସାଲମ୍‌ତ ହାନାପା; ମାନାୟ୍‌ ମାଜ଼ି ମୁଡ଼୍‌ ମାପ୍ରୁ ହେବା କିନାକାନ୍‌ ଆରେ ଦରମ୍‌ ଗୁରୁର୍‌ କେଇଦ ହେଲାୟ୍‌ ଆନାନ୍‌, ଆରେ ହେୱାର୍‌ ହେୱେନିଂ ହାକିଦଣ୍ଡ ହିଜ଼ି ପାର୍ତିକିୱି ଜିହୁଦିର୍‌ କେଇଦ ହିନାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","ଆରେ ହେୱାର୍‌ ହେୱେନିଂ କିଜାୟ୍‌ କିନାର୍‌, ହେୱାନ୍‌ ଜପି ଏୱିଡ଼ିଂ ଚୁପ୍‌ନାର୍‌, ହେୱେନିଂ କରଡା ଇଡ଼ିନାର୍‌ ଆରି ପାଗ୍‍ନାର୍‌, ଆରେ ତିନି ଦିନ୍‌ ପାଚେ ହେୱାନ୍‌ ଆରେ ଜିବୁନ୍‌ ଆଜ଼ି ନିଙ୍ଗ୍‌ନାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","ପାଚେ ଜେବ୍‌ଦିତି ମାଜ଼ି ଜାକୁବ୍‌ ଆରି ଜହନ୍‌ ଜିସୁ ତାକେ ୱାଜ଼ି ଇଚାର୍‌, “ଏ ଗୁରୁ, ମା ଇଚା ଜେ, ଆପେଂ ନିବେଣ୍ଡାଂ ଇନାକାପା ଏନ୍ତାନାପ୍‌, ହେଦାଂ ମା କାଜିଂ ଏନ୍‌ କିୟା ।” ");
INSERT INTO peg_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","ହେବେଣ୍ଡାଂ ହେୱାନ୍‌ ହେୱେରିଂ ୱେନ୍‌ବାତାନ୍‌, “ଆନ୍‌ ମି କାଜିଂ ଇନାକା କିନାଙ୍ଗ୍‌ ଇଞ୍ଜି ଏପେଙ୍ଗ୍‌ ମାନ୍‌ କିନାଦେରା ?” ");
INSERT INTO peg_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","ହେୱେର୍‌ ହେୱେନିଂ ଇଚାର୍‌, “ଜାର୍‌ ଜାଜ୍‌ମାଲ୍‌ ପାୟା ଆତିସ୍‌ ଇନେସ୍‌ ମା ତାଙ୍ଗ୍‌ ରକାନ୍‌ ନିଙ୍ଗ୍‌ ତିନି କଚଣ୍‌ତ ରକାନ୍‌ ଡେବା କଚଣ୍‌ କୁଚ୍‌ଚାନ୍‌ ମାଙ୍ଗେଙ୍ଗ୍‌ ଇ ବର୍‌ ହିଦା ।” ");
INSERT INTO peg_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","ମାତର୍‌ ଜିସୁ ହେୱେରିଂ ଇଚାନ୍‌, “ଏପେଙ୍ଗ୍‌ ଇନାକା ଏନ୍‌ନାଦେରା, ହେଦାଂ ପୁନୁଦେରା । ଆନ୍‌ ଇମ୍‌ଣି ଗିଲାସ୍‌ତ ଉଣ୍‌ଜି ମାନାଙ୍ଗ୍‌, ହେବେ କି ଏପେଙ୍ଗ୍‌ ଉଣ୍ଡେଙ୍ଗ୍‌ ଆଡ୍‌ନାଦେର୍‌ କି ? ଇଚିସ୍‌ ଆନ୍‌ ଇମ୍‌ଣି ବାପ୍ତିସିମ୍‌ତ ବାପ୍ତିସିମ୍‌ ଆନାଙ୍ଗା, ହେବେ କି ଏପେଙ୍ଗ୍‌ ବାପ୍ତିସିମ୍‌ ଆଦେଂ ଆଡ୍‌ନାଦେର୍‌ କି ?” ");
INSERT INTO peg_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","ହେୱାର୍‌ ହେୱେନିଂ ଇଚାର୍‌, “ଆଡ୍‌ନାପ୍‌ ।” ଜିସୁ ହେୱେରିଂ ଇଚାନ୍‌, ଆନ୍‌ ଇମ୍‌ଣି ଗିଲାସ୍‌ତ ଉଣାଙ୍ଗା, ଏପେଙ୍ଗ୍‌ ହେ ଗିଲାସ୍‌ତ ଉଣାଦେର୍‌, ଆରେ ଆନ୍‌ ଇମ୍‌ଣି ବାପ୍ତିସିମ୍‌ତ ବାପ୍ତିସିମ୍‌ ଅନାଙ୍ଗ୍‌, ଏପେଙ୍ଗ୍‌ ହେବେ ବାପ୍ତିସିମ୍‌ ଆନାଦେର୍‌; ");
INSERT INTO peg_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","ମାତର୍‌ ବୁଜ୍‌ଣି ବାଗାଙ୍ଗ୍‌ କି ଡେବାବାଗାଙ୍ଗ୍ କୁଚ୍‌ଚେଂ ହିନାକା ନା ଆଦିକାର୍‌ ବିସ୍ରେ ହିଲୁତ୍‌, ଇସ୍ୱର୍‌ ଆବା ଇମ୍‌ଣାକାର୍‌ କାଜିଂ ବାହା ରଚି କିତାନ୍‌ନ୍ନା, ହେୱାର୍‌ କୁଚ୍‌ନାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","ବିନ୍‌ ଦାସ୍‌ ଜାଣ୍‌ ଇଦାଂ ୱେନ୍‌ଞ୍ଜି ଜାକୁବ୍‌ ଆରେ ଜହନ୍‌ ଜପି ରିସା ଆଦେଂ ଲାଗାତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","ହେବେତାଂ ଜିସୁ ହେୱେରିଂ ରବେ କୁକ୍‌ଚି ଇଚାନ୍‌, “ଇମ୍‌ଣାକାର୍‌ ପାର୍ତିକିୱି ଜିହୁଦିରିଂ ରାଜ୍‌ କିନାକାର୍‌ ଲାକେ, ହେୱେର୍‌ ହେୱାର୍‌ ଜପି ରାଜି କିନାନ୍‌ ଆରି ପାର୍ତିକିୱି ଜିହୁଦିରିଂ ଗାଜାଲଗୁ ହେୱାର୍‌ ଜପି କାମାୟ୍‌କି କିତାର୍‌, ଇଦାଂ ଏପେଙ୍ଗ୍‌ ପୁନାଟ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","ମାତର୍‌ ମି ବିତ୍ରେ ହେ ଲାକେ ଆକାୟ୍‌, ମାତର୍‌ ମି ବିତ୍ରେ ଇନେର୍‌ ଗାଜାକାର୍‌ ଆଦେଂ ଇଚା କିତାର୍‌, ହେୱାନ୍‌ ମି କାଜିଂ ହେବା କିନାକାନ୍‌ ଆୟେନ୍‌; ");
INSERT INTO peg_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","ଆରେ ମି ବିତ୍ରେ ଇନେର୍‌ ଗାଜାକାନ୍‌ ଆଦେଂ ଇଚା କିନାନ୍‌, ହେୱାନ୍‌ ୱିଜ଼ାରିଂ ହଲ୍ୟା ଆୟେନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","ଇନେକିଦେଂକି ମାନାୟ୍‌ ମାଜ଼ି ପା ହେବା ପାୟା ଆଦେଂ ୱାୱାତାଂନା, ମତର୍‌ ହେବା କିଦେଙ୍ଗ୍‌ ଆରି ହେନି କାଜିଂ ମୁକ୍‌ଡ଼ାୟ୍‌ କିନି ମୁଲ୍‌ଲାକେ ଜିବୁନ୍‌ ହିଦେଂ ୱାତାନ୍‌ନା ।” ");
INSERT INTO peg_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","ପାଚେ ହେୱାର୍‌ ଜିରିହ ତାକେ ଏକାତାର୍‌, ଆରେ ଜିସୁ ଚେଲାହିର୍‌ ଲାହାଙ୍ଗ୍‌ ଆରି ବେସି ମାନାୟ୍‌ ଲାହାଙ୍ଗ୍‌ ଜିରିହତ ପିସ୍ତି ହାନିୱାଡ଼ାଂ ଟିମାୟର୍‌ ମେହି ବାର୍‌ର୍ଟିମୟ୍‌ ତର୍‌ ରକାନ୍‌ କାଣା ବିକାରି ହାଜ଼ି ଗୁଟିତ କୁଚ୍‌ଚି ମାଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","ହେୱାନ୍‌ ଜେ ନାଜରିତିୟନି ଜିସୁ, ଇଦାଂ ୱେନ୍‌ଞ୍ଜି ହେୱାନ୍‌ ଗାଜା ୱେଇଦାଂ ଇଞ୍ଜେଙ୍ଗ୍‌ ଲାଗାତାନ୍‌, “ଏ ଦାଉଦ୍‌ ମାଜ଼ି ଜିସୁ, ନାଙ୍ଗେଙ୍ଗ୍‌ ଦୟା କିଦା ।” ");
INSERT INTO peg_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","ଇବେତାଂ ବେସି ତାଙ୍ଗେଙ୍ଗ୍‌ ଆଲା ଆମା ଇଞ୍ଜି ଗଡ଼୍‌କିଦେଂ ଲାଗାତାର୍‌, “ମାତର୍‌ ହେୱାନ୍‌ ଆରି ଆଦିକ୍‌ ଗାଜା ୱେଇଦାଂ ଇଞ୍ଜେଙ୍ଗ୍‌ ଲାଗାତାନ୍‌, ଏ ଦାଉଦ୍‌ ମେହି, ନାଙ୍ଗେଙ୍ଗ୍‌ ଦୟା କିଦା ।” ");
INSERT INTO peg_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","ହେବେତାଂ ଜିସୁ ନିଲ୍‌ଚି ୱେଚ୍‌ଚାନ୍‌, “ହେୱାନିଂ ହିର୍‌ବାଟ୍ ।” ହେୱାର୍‌ ହେ କାଣ୍‌କୁ ହୁଡ଼୍‌ୱି ମାନାୟ୍‌ତିଂ ହିର୍‌ବିସ୍ ଇଚାନ୍‌, “ସାସ୍‌ ଆ, ନିଲା, ନିଙ୍ଗେଙ୍ଗ୍‌ କୁକ୍ତାନାନା ।” ");
INSERT INTO peg_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","ହେବେତାଂ ହେୱାନ୍‌ ନିଲ୍‌ଚି ପା ହେନ୍ଦ୍ରା ତୁହିଜି ଜିସୁ ତାକେ ୱାତାନ୍ । ");
INSERT INTO peg_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","ଜିସୁ ତାଙ୍ଗେଙ୍ଗ୍‌ ଉତର୍‌ ହିତାନ୍‌, “ଆନ୍‌ ନି କାଜିଂ ଇନାକା କିନାଙ୍ଗ୍‌ ଇଞ୍ଜି ଏନ୍‌ ଇନାକା ଇଚା କିନାୟା ?” ହେ କାଣା ମାନାୟ୍‌ ହେୱାନିଂ ଇଚାନ୍‌, “ଏ ଗୁରୁ, ଆନ୍‌ ଇନେସ୍‌ ହୁଡ଼୍‌ଦେଂ ଆଡ୍‌ନାଂ ।” ");
INSERT INTO peg_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","ଜିସୁ ତାଙ୍ଗେଙ୍ଗ୍‌ ଇଚାନ୍‌, “ହାଲା,” ନି ପାର୍ତି କିନାକା ନିଙ୍ଗେଙ୍ଗ୍‌ ଉଜ୍‌ କିତ୍‌ତାତ୍‌ନ୍ନା । ହେ ଦାପ୍ରେ ହେୱାନ୍‌ ହୁଡ଼୍‌ତାନ୍ ଆରେ ହାଜ଼ିତିଂ ହେୱାନ୍‌ ପାଚେ ପାଚେ ହାଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","ଏଚେକାଡ଼୍‌ଦ ହେୱାର୍‌ ଜିରୁସାଲମ୍‌ ଲାଗାୟ୍‌ ୱାଜ଼ି ଜିତ୍‌ମାଡ଼ି ଲାଗେ ବେତ୍‌ପାଗି ଆରି ବେତ୍‌ନିୟା କଚଣ୍‌ତ ୱାତାର୍‌, ହେ ପାଦ୍‌ନା ଜିସୁ ନିଜ୍‌ ଚେଲାରିଂ ତାଙ୍ଗ୍‌ ରିୟାରିଂ ଇ କାତା ୱେଚ୍‌ଚି ପକ୍‌ତାନ୍‌, ");
INSERT INTO peg_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","ମି ମୁମ୍‌ ହାଣ୍‍କୁ ହେ ନାସ୍‌ତ ହାଲାଟ୍‌ । “ହେବେ ହଣି ସାଙ୍ଗେ ସାଙ୍ଗେ, ଇମ୍‌ଣାକା ଜପି ଇନେର୍‌ ଇନାୱାଡ଼ାଂ କୁଚ୍‌ୱାତାର୍‌ନା, ଏଲେଙ୍ଗ୍‌ ବାର୍ତାକା ର ଗଦ ହିମ୍‌ଣାତିଂ ଗାଚ୍‌ଚାକା ହୁଡ଼୍‌ନାଦେର୍‌, ହେଦେଲିଂ ରିକ୍‌ଚି ତାଇୱାଡୁ । ");
INSERT INTO peg_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","ଆରେ, ଏଚେକାଡ଼୍‌ଦ ଇନେନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ଇନାକିଦେଂ ଏଲେଙ୍ଗ୍‌ କିନାଦେର୍‌ ଇଞ୍ଜି ଇନ୍‌ଚିସ୍‌, ହେଦାଂ ଇନାଦେର୍‌, ଇଦାଂ ତାକେ ମାପ୍ରୁତି ଲଡ଼ା ମାନାତ୍‌, ଆରେ ହେୱାନ୍‌ ଆରେରଗ ବେଗି ପକ୍ତାନାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","ହେୱାର୍‌ ହାଲ୍‌ଜି ଦୁୱେର୍‌ ଲାଗାୟ୍‌ ବାର୍ତ ହାକିଡ଼ିତ ର ଗଦ ହିମ୍‌ଣା ଗାଚ୍‌ଚାକା ହୁଡ଼୍‌ଜି ହେଦେଲିଂ ରିକ୍ତାର୍ । ");
INSERT INTO peg_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","ହେବେ ନିଲ୍‌ଚିମାନି ମାନାୟାର୍‌ ବିତ୍ରେ ଇନେର୍‌ ଇନେର୍‌ ହେୱାରିଂ ୱେନ୍‍ବାତାର୍, “ଗଦ ହିମ୍‌ଣାତିଂ ରିକ୍‌ଚି ଇନାକିନାଦେରା ?” ");
INSERT INTO peg_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","ଜିସୁ ଇନେସ୍‌ ୱେଚ୍‌ଚି ମାଚାନ୍‌, ହେୱାର୍‌ ହେ ଲାକେ ହେୱାରିଂ ଉତର୍‌ ହିତାର୍‌, ପାଚେ ହେୱାର୍‌ ହେୱାରିଂ ପିସ୍ତି ହିତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","ଜିସୁ ଲାଗାୟ୍‌ ଗଦ ହିମ୍‌ଣାତିଂ ତାସି ହେୱାର୍‌ ତା ଜପି ନିଜ୍ ନିଜ୍‍ନି ହେନ୍ଦ୍ରା ପାସ୍ତାର୍, ଆରି ଜିସୁ ତା ଜପି କୁଚ୍‌ଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","ଆରେ ହେନି ହାସ୍‍ଦ ଜାର୍‌ ଜାର୍‌ ହେନ୍ଦ୍ରା ପାସ୍ତାର୍ ଆରେ କେତେଜାଣ୍‌ ଜମିତାଂ ଡାଡ଼୍‌ କାଦ୍‌ଦି ତାସି ପାସ୍ତାର୍ । ");
INSERT INTO peg_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","ଆରେ, ଆଗେ ଆରି ପାଚେ ହାଲ୍‍ଜିମାନି ମାନାୟାର୍‌ ଗାଜାକାଟ୍‌ତାଂ ଇଞ୍ଜେଙ୍ଗ୍‌ ଲାଗାତାର୍‌, “ହସାନ୍ନା ! ମାପ୍ରୁତି ତର୍‌ଦ ଇନେନ୍‌ ୱାନାନା ଇସ୍ୱର୍‌ ଆସିର୍ବାଦ୍‌ ହିଦ୍‍ନାନ୍‍ ! ");
INSERT INTO peg_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","ମା ଆବା ଲାତ୍ରା ଦାଉଦ୍‌ତି ଇମ୍‌ଣି ରାଜି ୱାନାତା, ହେଦାଂ ଇସ୍ୱର୍‌ ଆସିର୍ବାଦ୍‌ କିଦେନ୍‌ ! ଜପ୍‌ଣି ଲକାର୍‍ତି ହସାନ୍ନା !” ");
INSERT INTO peg_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","ପାଚେ ଜିସୁ ଜିରୁସାଲମ୍‌ତ ୱାଜ଼ି ମନ୍ଦିର୍‌ତ ହଟାନ୍, ଆରେ ଚାର୍‍ବେଣ୍‍ତି ସବୁ ବିସ୍ରେ ହୁଡ଼୍‌ଜି ମାଜ୍‌ଗା ଆତିଲେ ବାରଜାଣ୍ ହୁକେ ବେତ୍‌ନିୟାତ ହସିହାଚାର୍ । ");
INSERT INTO peg_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","ହେ ଆର୍କାତ୍‌ ନାଜିଂ ହେୱାର୍‌ ବେତ୍‌ନିୟାତାଂ ୱାଜ଼ି ମାଚି ୱେଡ଼ାଲିଂ ଜିସୁ ନାସ୍‌କି ଆତାନ୍‌; ");
INSERT INTO peg_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","ଆରେ, ହେୱାନ୍‌ ଦେହାତାଂ ଆକିଂ ମାନି ର ତଗା ମାର୍‌ ହୁଡ଼୍‌ଜି, ଇନେସ୍‌ ଆତିସ୍‌ ହେବେ ପାଡ଼୍‌ ଗାଟାଆଦ୍‍ନାତ୍, ଇ ଆହା କିଜ଼ି ଲାଗେ ହାଚାନ୍‌ । ମାତର୍‌ ଲାଗେ ୱାଜ଼ି ଆକିଂ ପିସ୍ତି ଆରି ଇନାକା ହୁଡ଼୍‌ଦେଂ ଆଡ୍‌ୱାତାନ୍‌, ଇନାକିଦେଂକି ହେ କାଡ଼୍‌ଦ ତଗାପାଡ଼୍‌ନି ସମୁ ହିଲ୍‌ୱାତାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","ହେବେଣ୍ଡାଂ ଜିସୁ ମାର୍‍ଦିଙ୍ଗ୍ ଇଚାନ୍‌, “ଆରେ ମୁଡ଼୍‌କେ ନି ତାଂ ପାଡ଼୍‌ ଇନେର୍‌ ତିନ୍‍ମେର୍ !” ହେୱାନ୍ତି ଚେଲାର୍‌ ଇ କାତା ୱେଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","ତାପାଚେ ହେୱାର୍‌ ଜିରୁସାଲମ୍‌ତ ୱାତାର୍, ଆରି ଜିସୁ ମନ୍ଦିର୍‌ ବିତ୍ରେ ହଣ୍‌ଜି ହେୱାର୍‌ ପୁଜାକିଦେଂ କଡ଼୍‍ନାକାରିଂ ପନାକାରିଂ ହପ୍‍ତେଂ ଲାଗାତାନ୍‌, ଆରି ଟାକାଂ ବେପ୍ରିୟାରିଂ ପାଟାଙ୍ଗ୍ ଆରି ପାଣ୍ଡ୍‌କା ବେପ୍ରିୟାରିଂ କୁଚ୍‌ନି ବାହା ଉଲ୍‌ଟାୟ୍‌ କିତାନ୍‌, ");
INSERT INTO peg_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","ଆରେ ମନ୍ଦିର୍‌ ବିତ୍ରେ ଇନେରିଂ ପା ତାଡ଼ିଆ ଇନାକା ଅଦେଂ ହିୱାତାନ୍ । ");
INSERT INTO peg_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","ଆରେ ଜିସୁ ହେୱାରିଂ ହିକ୍ୟା ହିଉ ହିଉ ଇଚାନ୍‌, ଇଦାଂ ଲେକା ଆତାତ୍‌ନ୍ନା, “ମା ଇଲ୍‌ ୱିଜ଼ୁ ଜାତି କାଜିଂ ପାର୍ତାନା ଇଲ୍‌ ଇଞ୍ଜି ଡାକ୍‌ପୁଟା ଆନାତ୍‌, ମାତର୍‌ ଏପେଙ୍ଗ୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ଚର୍କୁ ଇଲ୍‌ କିତାଦେର୍ଣ୍ଣା !” ");
INSERT INTO peg_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","ମୁଡ଼୍‌ ମାପ୍ରୁହେବାକିନାକାନ୍‌ ଆରି ଦରମ୍‌ ଗୁରୁର୍‌ ଇଦାଂ ୱେନ୍‌ଞ୍ଜି ଜିସୁଙ୍ଗ୍‌ ଇନେସ୍‌ କିଜ଼ି ନାସ୍‌ କିନାର୍‌ ହେଦାଂ ଉପାୟ୍‌ କିଦେଙ୍ଗ୍‌ ଲାଗାତାର୍‌; ଇନେକିଦେଂକି ଲକୁ ହେୱାନ୍‌ ହିକ୍ୟାତ କାବା ଆତିଲେ ହେୱାର୍‌ ହେୱାନିଂ ପାଣ୍ଡ୍ରା ଆଜ଼ି ମାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","ହେ ଦିନ୍ତ ମ୍ଡିକା ଆତିଲେ ଜିସୁ ଆରି ଚେଲାର୍‌ ଗାଡ଼୍‌ଦାଂ ହସି ହାଲ୍‌ଜି ମାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","ନାଡ଼ିହିଙ୍ଗ୍ ହେ ହାଜ଼ି ହିଜ଼ି ହାନି ୱେଡ଼ାଲିଂ ହେୱାର୍‌ ତଗା ମାର୍‌ ଚିରାତାଂ ୱାଜ୍‍ଜି ହାଲ୍‌ଜି ମାଚାକା ହୁଡ଼୍‌ତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","ହେବେ ପିତର୍‌ ଆଗେନି କାତା ଏତୁ କିଜ଼ି ହେୱାନିଂ ଇଚାନ୍‌, “ଏ ଗୁରୁ, ହୁଡ଼ା, ଏନ୍‌ ଇମ୍‌ଣି ତଗା ମାର୍‌ଦିଂ ସାଇପ୍‌ ହିଜ଼ି ମାଚାୟ୍‍ ହେଦାଂ ୱାଜ୍‍ଜି ହାଚାତେ ।” ");
INSERT INTO peg_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","ଜିସୁ ଚେଲାରିଂ ଉତର୍‌ ହିତାନ୍‌, “ଇସ୍ୱର୍‌ ତାକେ ପାର୍ତି କିୟାଟ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ହାତ୍‌ପା ଇଞ୍ଜ୍‌ନାଙ୍ଗା, ଇନେର୍‌ପା ଇ ମାଡ଼ିତିଂ ନିଙ୍ଗା ଆରି ହାମ୍‌ଦୁର୍‌ତ ଆର୍‍ଗା ଇଚିସ୍‌ ଆରି ଜାର୍‌ ମାନ୍‌ ପାର୍ତି କିତିସ୍‌ ଇନାକା ଇଚିସ୍‌, ହେଦାଂ ଗିଟା ଆନାତ୍‌ ଇଞ୍ଜି ପାର୍ତି କିଜ଼ି, ହେୱାନ୍‌ କାଜିଂ ହେଦାଂ ଗିଟା ଆନାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","ଲାଗିଂ, ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ଇଞ୍ଜ୍‌ନାଙ୍ଗା ଏପେଙ୍ଗ୍‌ ଇନା ଇନାକା ପାର୍ତାନା କିନାଦେର୍‌ ଆରି ଏନ୍‌ନାଦେରା, ହେ ସବୁ ଗାଟା ଆତାପ୍‌ନା ଇଞ୍ଜି ପାର୍ତି କିୟାଟ୍‌ ହେବେନି ହେ ସବୁ ପାୟାନାଦେର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","ଆରେ, ଏପେଙ୍ଗ୍‌ ଏଚେୱାଡ଼ାଂପା ପାର୍ତାନା କିଦେଙ୍ଗ୍‌ ନିଙ୍ଗାଟ୍‌ ଜଦି ଇନେର୍‌ ବେରୁତ ମି ଇନାକା କାତା ମାଚିସ୍‌, ତା ଆତିସ୍‌ କେମା କିୟାଟ୍‌, ଇନେସ୍‌କି ମି ସାର୍ଗେନି ଆବାପା ମିୱାଙ୍ଗ୍‌ ପାପ୍‌ ସବୁ କେମା କିଦ୍‌ନାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","ମାତର୍‌ ଏପେଙ୍ଗ୍‌ କେମା ହିୱିତିସ୍, ମି ସାର୍ଗେ ନି ଆବାପା ମିଦାଙ୍ଗ୍‌ ବାନିୟାତାକା କେମା କିଦୁନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","ଆରେ ରଗ ହେୱାର୍‌ ଆରି ଜିରୁସାଲମ୍‌ତ ୱାତାର୍‌, ଆରି, ଜିସୁ ମନ୍ଦିର୍‌ ବିତ୍ରେ ବୁଲାଆନି ୱେଡ଼ାଲିଂ ମୁଡ଼୍‌ ମାପ୍ରୁ ହେବା କିନାକାର୍‌, ଦରମ୍‌ ଗୁରୁର୍‌ ଆରି ପ୍ରାଚିନାର୍‌ ତାକେ ୱାଜ଼ି ୱେନ୍‌ବାତାର୍, ");
INSERT INTO peg_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","“ଏନ୍‌ ଇମ୍‌ଣି ଆଦିକାର୍‌‌ତ ଇ ସବୁ କିନାୟା ? କି ଇ ସବୁ କିଦେଙ୍ଗ୍‌ ନିଙ୍ଗେଙ୍ଗ୍‌ ଇନେର୍‌ ଆଦିକାର୍‌ ହିତ୍‍ତାର୍‌ ?” ");
INSERT INTO peg_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","ମାତର୍‌ ଜିସୁ ହେୱାରିଂ ଇଚାନ୍‌, “ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ର କାତା ୱେନ୍‌ବା ଆଦ୍‌ନାଂ, ନାଙ୍ଗେଙ୍ଗ୍‌ ଉତର୍‌ ହିଦାଟ୍‌, ତାଆତିସ୍‌ ଆନ୍‌ ଇମ୍‌ଣି ଆଦିକାର୍‌‌ତାଂ ଇ ସବୁ କିନାଙ୍ଗା, ହେଦାଂ ମିଙ୍ଗେଙ୍ଗ୍‌ ୱେଚାନାଙ୍ଗ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","ଜହନ୍‌ତି ବାପ୍ତିସିମ୍‌ ସାର୍ଗେତାଂ କି ମାନାୟାର୍‌ତାଂ ୱାତାତ୍ ?” ନାଙ୍ଗେଙ୍ଗ୍‌ ଉତର୍‌ ହିଦାଟ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","ହେବେ ହେୱାର୍‌ ହାରି ବେଣ୍‌ ବାଟ୍‌ କିଦେଂ ଲାଗାତାର୍‌, ଜଦି ସାର୍ଗେତାଂ ଇଚିସ୍‌, ତା ଆତିସ୍‌ ହେୱାନ୍‌ ଇଞ୍ଜ୍‌ନାନ୍‌, ତେବେ “ଏପେଙ୍ଗ୍‌ ଇନାକିଦେଂ ଜହନ୍ତି ପାର୍ତି କିୟୁଦେରା ? ");
INSERT INTO peg_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","ଆରେ ମାନାୟାର୍‌ତାଂ ଇଞ୍ଜି ଇନାକା ଇନାସ୍‌ ?” ହେୱାର୍‌ ମାନାୟ୍‌ତିଂ ପାଣ୍ଡ୍ରା ଆଜ଼ି ମାଚାର୍‌; ଇନାକିଦେଂକି ୱିଜ଼ାକାର୍‌ ଜହନ୍‌ତିଂ ରକାନ୍‌, ବେଣ୍‌ବାକ୍‌ଣାୟ୍‌ କିନାକାନ୍‌ ଇଞ୍ଜି ମାନି କିଜ଼ି ମାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","ଲାଗିଂ ହେୱାର୍‌ ଜିସୁଙ୍ଗ୍‌ ଉତର୍‌ ହିତାର୍‌, “ଆପେଂ ପୁନୁପ୍‌ ।” ଜିସୁ ହେୱାରିଂ ଇଚାନ୍‌ ତେବେ ଆନ୍‌ ଇମ୍‌ଣି ଆଦିକାର୍‌‌ତ ଇ ସବୁ କିନାଙ୍ଗା, ହେଦାଂ ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ୱେଚ୍‍ଚୁଙ୍ଗ୍ । ");
INSERT INTO peg_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","ଇଦାଂ ପାଚେ ହେୱାନ୍‌ ହେୱାରିଂ ଉତର୍‌ମୁଡ଼୍‌ ଇଞ୍ଜେଙ୍ଗ୍‌ ଲାଗାତାନ୍‌ । “ରକାନ୍‌ ର ଅଙ୍ଗୁର୍‌ ବାଡ଼୍‌ କିଜ଼ି ତା ଚାରିବେଣ୍‌ତାଂ ବାଡ଼୍‌ ଡ଼ଚ୍‍ଚାନ୍ ଆରି ଅଙ୍ଗୁର୍‌କୁଣ୍ଡି କାର୍ଚି କାନାକାର୍‌ ମାଚା ରଚ୍‍ଚାନ୍, ଆରେ କାମାୟ୍‌ କିନାକାରିଂ ହେ ବାଡ଼୍‌ ବାଗ୍‍ରେ ହିଜ଼ି ରାଜି ହତାନ୍ । ");
INSERT INTO peg_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","ପାଚେ କାମାୟ୍‌ କିନାକାର୍‌ତାଂ ଅଙ୍ଗୁର୍‌ ବାଡ଼୍‌ନି ପାଡ଼୍‌ ପାୟା ଆଦେଂ ଇଞ୍ଜି ହେୱାନ୍‌ ର ଆଡ଼ିଏନିଂ ସମାନ୍‌ ୱେଡ଼ାଲିଂ ହେୱାର୍‌ ତାକେ ପକ୍‌ତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","ମାତର୍‌ ହେୱାର୍‌ ହେୱାନିଂ ଆଜ଼ି ଟ୍ରାକ୍‌ତାର୍‌ ଆରି ୱାରା କେଇଦାଂ ପକ୍ତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","ହେୱାନ୍‌ ଆରି ରକାନିଂ ଆଡ଼ିୟାଂ ପକ୍‌ତାନ୍‌; ହେୱାର୍‌ ହେୱାନ୍ତି ପା କାପ୍‌ଡ଼ା ପାଟ୍‍ତାର୍ ଆରି ହେୱାନିଂ ହିନସ୍ତା କିତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","ହେୱାନ୍‌ ଆରେ ରକାନିଂ ପକ୍‌ତାନ୍‌; ହେୱାର୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ପା ଟୁଟାର୍‌ । ହେବେ ହେୱାନ୍‌ ଆରେ ହେନିତିଂ ପକ୍‌ତାନ୍‌; ହେୱାର୍‌ ତାଙ୍ଗ୍‌ ପା କେତେକ୍‌ ଜାଣ୍‌ତିଂ ହେୱାର୍‌ ଟ୍ରାକ୍‌ତାର୍‌ ଆରେ କେତେକ୍‌ ଜାଣ୍‌ତିଂ ଟୁଟାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","ତା କଚଣ୍‌ତ ରକାନ୍‌ ମାତର୍‌ ମାଚାନ୍‌, ହେୱାନ୍‌ ତା ୱାରିନି ମାଜ଼ି । ନା ମାଜ଼ିଂ ହେୱାର୍‌ ମାନିିକିନାର୍‌, ଇଦାଂ ଇଞ୍ଜି ହେୱାନ୍‌ ହାରିହାରା ହେୱାନିଂ ହେୱାର୍‌ ତାକେ ପକ୍‌ତାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","ମାତର୍‌ ହେ କୁଲିୟାର୍‌ ହେୱାର୍‌ ହେୱାର୍‌ ବେଣ୍‌କିବା ଆତାର୍‌ ଇୱାନ୍ତ ମୁଣିକା କାଡ଼୍‌ଦେ, ୱାଡୁ, ଇୱାନିଂ ଅହ୍‌ନାସ୍‌; ତା ଆତିସ୍‌ ମାଦାଂ ଆଦିକାର୍‌ ଆନାତ୍‌ ! ");
INSERT INTO peg_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","ହେବେଣ୍ଡାଂ ହେୱାର୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ଆସ୍ତି ଅସ୍ତାର୍‌ ଆରି ଅଙ୍ଗୁର୍‌ ବାଡ଼୍‌ ବାର୍‌ତ ତୁହିତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“ହେବେ ଅଙ୍ଗୁର୍‌ ବାଡ଼୍‌ନି ହାଉକାର୍‌ ଇନାକା ଇନାନ୍‌ ?” ହେୱାନ୍‌ ୱାଜ଼ି କୁଲିୟାରିଂ ଟାଣ୍‌ତେ ଅହ୍‌ନାନ୍‌ ଆରି ବିନ୍‌ ଲଗାଂ ଅଙ୍ଗୁର୍‌ ବାଡ଼୍‌ ହିନାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","ଏପେଙ୍ଗ୍‌କି ଦରମ୍‌ ସାସ୍ତର୍‌ “ଇ ବଚନ୍‌ ପା ପଡ଼ି କିୱାତାଦେର୍ଣ୍ଣା, ଇଲ୍‌ ରଚ୍‌ନାକାର୍‌ ଇମ୍‌ଣି କାଲ୍‌ଦିଂ ମୁନା କିତାର୍‌, ହେଦାଂ କନାନି ମୁଡ଼୍‌କାଲ୍‌ ଆତାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","ମାପ୍ରୁତାଂ ଇଦାଂ ଆତାତ୍‌, ଆରି ହେଦାଂ ମା କାଣ୍‌କୁକାଂ କାବା ଆନାକା ?” ");
INSERT INTO peg_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","ଇବେଣ୍ଡାଂ ଜିହୁଦିର୍‌ ଜିସୁଙ୍ଗ୍‌ ଆସ୍ତେଙ୍ଗ୍‌ ହାତୁର୍‌ କିତାର୍‌, ମାତର୍‌ ହେୱାର୍‌ ମାନାୟ୍‌ତିଂ ପାଣ୍ଡ୍ରା ଆତାର୍‌; ଇନାକିଦେଂକି ହେୱାନ୍‌ ହେ ଉତର୍‌ମୁଡ଼୍‌ ହେୱାରିଂ ଇଟ୍‌କାଡ଼୍‌ କିଜ଼ି ଇଞ୍ଜି ମାଚାନ୍‌ ଇଞ୍ଜି ହେୱାର୍‌ ବୁଜାଆତାର୍‌, ଆରେ ହେୱାର୍‌ ହେୱାନିଂ ପିସ୍‌ସି ହାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","ପାଚେ ହେୱାନ୍‌ କାତାନି ଗାଣ୍‌ଜୁ ୱେନ୍‌ଞ୍ଜି ଆସ୍ତେଙ୍ଗ୍‌ ଇଞ୍ଜି ହେୱାର୍‌ ପାରୁସିର୍‌ ଆରେ ହେରଦିୟା ଦାଡ଼୍‌ନି ମାନାୟାର୍‌ ବିତ୍ରେ କେତେକ୍‌ ଜାଣ୍‌ତିଂ ହେୱାନ୍‌ ଲାଗାଂ ପକ୍ତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","ହେୱାର୍‌ ୱାଜ଼ି ହେୱାନିଂ ଇଚାର୍‌, “ଏ ଗୁରୁ ଆପେଂ ପୁନାପ୍‌, ଏନ୍‌ ହାତ୍‌ପା ସତ୍‌ ଆରି ଇନେରିଂ ପାଣ୍ଡ୍ରା ଆଉୟ୍‌, ଇନାକିଦେଂକି ଏନ୍‌ ମାନାୟ୍‌ତି ମୁକ୍‌ମେଟ୍‌ ହୁଡ଼ୁୟ୍‌ ମାତର୍‌ ହାତ୍‌ପା ରଚେ ଇସ୍ୱର୍‌ତିଂ ହାଜ଼ି ହିକ୍ୟାହିନାୟ୍‌ । ମାଙ୍ଗେଙ୍ଗ୍‌ ୱେଚ୍‌ଚା କାଇସର୍‌ ରାଜାଙ୍ଗ୍‌ ସିସ୍ତୁ ହିନି ବିଦି କି ଆକାୟ୍‌ ?” ");
INSERT INTO peg_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","ଆସେଙ୍ଗ୍‌ ହିନାସ୍ କି ଆକାୟ୍‌ ? “ମାତର୍‌ ହେୱାନ୍‌ ହେୱାର୍‌ତି କୁଟ୍‌ ପୁଞ୍ଜି ହେୱାରିଂ ଇଚାନ୍‌, ଇନେକିଦେଂ ନାଙ୍ଗେଙ୍ଗ୍‌ ପରିକ୍ୟା କିଦ୍‌ନାଦେରା ? ର ଟାକା ନା ଲାଗାୟ୍ ତାଡୁ, ଆନ୍‌ ହେଦାଂ ହୁଡ଼୍‌ନାଂ ।” ");
INSERT INTO peg_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","ହେବେ ହେୱାର୍‌ ଅଦ୍‌ନି ତାହିୱାତାର୍‌ । ଜିସୁ ହେୱାରିଂ ୱେନ୍‌ବାତାନ୍‌, “ଇ ପୁତ୍‌ଡ଼ା ଆରି ତର୍‌ ଇନେର୍‌ତି ?” ହେୱାର୍‌ ହେୱାନିଂ ଇଚାର୍‌, “କାଇସର୍‌ତି ।” ");
INSERT INTO peg_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","ହେବେ ଜିସୁ ହେୱାରିଂ ଇଚାନ୍‌, “କାଇସର୍‌ତି ଇନାକା, ହେଦାଂ ରମିୟ ରାଜାଙ୍ଗ୍ ହିୟାଟ୍‌ ଆରେ ଇସ୍ୱର୍‌ତିଂ ଇନାକା ହେଦାଂ ଇସ୍ୱର୍‌ତିଂ ହିୟାଟ୍‌ ।” ହେବେ ହେୱାର୍‌ ହେୱାନ୍‌ କାତାତ କାବା ଆତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","ଇଦାଂ ପାଚେ ଆରେ ନିଙ୍ଗ୍‌ନାକା ମୁନା କିତାର୍‌ ସାଦୁକିର୍‌ ହେୱାନ୍‌ ଲାଗାଂ ୱାଜ଼ି ୱେନ୍‌ବେଦେଂ ଲାଗାତାର୍‌, ");
INSERT INTO peg_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“ଏ ଗୁରୁ, ମସା ମାକାଜିଂ ଲେକିକିତାନ୍ନା ଜେ, ଜଦି ଇନେର୍‌ ଲକୁ ନି ଟଣ୍ଡେନ୍‌ ହାତିସ୍, ଆରି ତା ଡକ୍ରୁହି ଜିବୁନ୍ତ ମାଚିସ୍‌, ଆରେ ତାଦାଙ୍ଗ୍‌ ଇନାକାପା ହିମ୍‍ଣାୱାକ୍ଡ଼ା ହିଲ୍‍ୱିତିସ୍, ତା ଆତିସ୍‌ ତା ଟଣ୍ଡେନ୍‌ ତା ଡକ୍ରୁହିଙ୍ଗ୍ ଇଡ୍‌ଜ଼ି ତା ଟଣ୍ଡେନ୍‌ କାଜିଂ ହିମ୍‍ଣାୱାକ୍‍ଡା ଉବ୍‌ଜାଣ୍‌ କିନାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","ହୁଡ଼ାଟ୍‌, ସାତ୍‌ ବାୟ୍‍ ଟଣ୍ଡାର୍‌ ମାଚାର୍‌; ଗାଜାକାନ୍‌ ର ଡକ୍ରି ଇଟ୍‌ତାନ୍‌ ଆରି ହିମ୍‌ଣାୱାକ୍‌ଡ଼ା ଆୱାଦାଂ ହାତାନ୍‌; ");
INSERT INTO peg_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","ପାଚେ ଆରେ ରକାନ୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ଇଡ଼୍‌ଜିପା ହିମ୍‌ଣାୱାକ୍‌ଡ଼ା ଆୱାଦାଂ ହାତାନ୍‌ । ଆରେ ରକାନ୍‌ପା ହେ ଲାକେନେ ଆଜ଼ି ହାତାନ୍‌, ");
INSERT INTO peg_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","ଆରେ, ସାତ୍‌ଜାଣ୍‌ ଜାକ ହିମ୍‌ଣାୱାକ୍‌ଡ଼ା ଆୱାଦାଂ ହାତାର୍‌; ହାରିହାରା ହେ କଗ୍‌ଲେ ପା ହାତାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","ହାଜ଼ି ଆରେ ନିଂନି ୱେଡ଼ାଲିଂ ଏଚେକାଡ଼୍‌ଦ ହେୱାର୍‌ ନିଙ୍ଗ୍‌ନାର୍‌, ହେ ଏଚେକାଡ଼୍‌ଦ ହେୱାର୍‌ ବିତ୍ରେ ହେଦେଲ୍‌ ଇନେର୍‌ ଡକ୍ରି ଆନାତ୍‌ ? ସାତ୍‌ ଜାଣ୍‌ ଜାକ୍‌ ହେଦେଲିଂ ବିବା କିଜ଼ି ମାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","ଜିସୁ ହେୱାରିଂ ଇଚାନ୍‌, “ଏପେଙ୍ଗ୍‌ ଦରମ୍‌ ସାସ୍ତର୍‌, ଆରେ ଇସ୍ୱର୍‌ ସାକ୍ତି ପୁନ୍‌ୱାଦାଂ କି ବାନ୍ୟା ହାଜ଼ିଦିଂ ହାନାଦେରା । ");
INSERT INTO peg_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","ଜିସୁ ହାତାକାର୍‌ ବିତ୍ରେ ଆରେ ନିଙ୍ଗ୍‌ତି ପାଚେ ମାନାୟ୍‌ ବିବା କିଉର୍‌ କି ଇନେରିଂ ବିବାଆଦେଂ ହିଉର୍‌ । ମାତର୍‌ ସାର୍ଗେନି ଦୁତ୍‌ ଲାକେ ମାନ୍‌ଗାନାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","ମାତର୍‌ ହାତାକାର୍‌ ଜେ ନିଙ୍ଗ୍‌ନାର୍‌, ହେ ବିସ୍ରେ ଏପେଙ୍ଗ୍‌ କି ମସାତି ସାସ୍ତର୍‌ତ ବୁଟାନି ବୁଜାଆନି କାତା ପଡ଼ି କିୱାତାଦେର୍ଣ୍ଣା ଜେ, ଇସ୍ୱର୍‌ ଇନେସ୍‌ ହେୱାନିଂ ଇଚାନ୍‌ ଆପେଂ ଅବ୍ରାହାମ୍‌ତି ଇସ୍ୱର୍‌, ଇସ୍‌ହାକ୍‌ତି ଇସ୍ୱର୍‌ ଆରି ଜାକୁବ୍‌ତି ଇସ୍ୱର୍‌ ? ");
INSERT INTO peg_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","ହେୱାନ୍‌ ହାତି ଲଗାର୍‍ତି ଇସ୍ୱର୍‌ ଆକାୟ୍‌ ମାତର୍‌, ଜିତାକାର୍ତି । ଏପେଙ୍ଗ୍‌ ବେସିବୁଜା ଆଉଦେରା !” ");
INSERT INTO peg_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","ହେ ଏଚେକାଡ଼୍‌ଦ ଦରମ୍‌ ଗୁରୁର୍‌ ବିତ୍ରେ ରକାନ୍‌ ଲାଗେ ୱାଜ଼ି ହେୱାର୍‌ କାତାବାର୍ତା ୱେନ୍‌ଞ୍ଜି ଜିସୁ ଆରି ସାଦୁକିରିଂ ହାର୍ଦି ଉତର୍‌ ହିତାନ୍ନା, ଇଦାଂ ପୁଞ୍ଜି ହେୱାନିଂ ୱେନ୍‌ବାତାନ୍‌, “ୱିଜ଼ୁ ବଲ୍‌ ବିତ୍ରେ ଇନାବାନି ବଲ୍‌ ମୁଡ଼୍‌ ?” ");
INSERT INTO peg_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","ଜିସୁ ଉତର୍‌ ହିତାନ୍‌, ମୁଡ଼୍‌ବଲ୍‌ ଇଦାଂ, “ଏ ଇସ୍ରାଏଲ୍‌, ୱେନା, ମାପ୍ରୁ ମାଙ୍ଗେଙ୍ଗ୍‌ ଇସ୍ୱର୍‌ ରକାନ୍‌ ମାତର୍‌ ଇସ୍ୱର୍‌ ଆନାନ୍‌; ");
INSERT INTO peg_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","ଆରେ, ଏପେଙ୍ଗ୍‌ ମି ୱିଜ଼ୁ ୱାସ୍କି, ୱିଜ଼ୁ ପାରାଣ୍‌, ୱିଜ଼ୁ ମାନ୍‌, ଆରି ମାନ୍‌ ୱିଜ଼ୁ ସାକ୍ତି ହିଜ଼ି ମାପ୍ରୁ ଜାର୍‌ ଇସ୍ୱର୍‌ତିଂ ଜିଉ ନୱାଟ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","ଆରେ ରଞ୍ଜାଙ୍ଗ୍‌ ଇଦାଂ, ଏନ୍‌ ନି ପାଡ଼୍‌ହା ଇଞ୍ଜି ଲଗାଂ ନି ୱାସ୍କିଲାକେ ଜିଉ ନୱାଟ୍‌ । ଇ ବଲ୍‌ତିଂ ଆଦିକ୍‌ ଆରି ଇନାକାପା ସିଗ୍‌ ବଲ୍‌ ହିଲୁତ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","ହେବେ ହେ ଦରମ୍‌ ଗୁରୁର୍‌ ହେୱାନିଂ ଇଚାନ୍‌, “ଏ ଗୁରୁ, ହେଦାଂ ହାତ୍‌ପା, ହେୱାନ୍‌ ଜେ ରଞ୍ଜାଙ୍ଗ୍‌ ଆରି ହେୱାନ୍‌ ୱାତିସ୍‌ ଆରି ଇନେର୍‌ ଆକାୟ୍‌, ଇଦାଂ ଏନ୍‌ ହାତ୍‌ପା ରଚେ ଇଚାଇନା । ");
INSERT INTO peg_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","ଆରେ, ୱିଜ଼ୁ ୱାସ୍କି, ୱିଜ଼ୁ ବୁଦି ଆରି ୱିଜ଼ୁ ସାକ୍ତି ହିଜ଼ି ହେୱାନିଂ ଜିଉ ନୱାଟ୍‌, ଆରି ପାଡ଼୍‌ହା ଇଞ୍ଜି ଲଗାଂ ଜାର୍‌ ଜିବୁନ୍‌ ଲାକେ ଜିଉନନାକା ୱିଜ଼ୁ ଗାର୍‌ଣି ଆରି ପୁଜାତିଙ୍ଗ୍‌ ଗାଜାଟି ।” ");
INSERT INTO peg_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","ହେୱାନ୍‌ ବୁଦି ଲାହାଙ୍ଗ୍‌ ଉତର୍‌ ହିଜ଼ି ମାନାକା ପୁଞ୍ଜି ଜିସୁ ହେୱାନିଂ ଇଚାନ୍‌, “ଇସ୍ୱର୍‌ ରାଜିତାଂ ଏନ୍‌ ଦେହା ଆକାୟ୍‌ । ଇଦାଂ ପାଚେ ଇନେନ୍‌ ହେୱାନିଂ ଆରେ ଇମ୍‌ଣି ପର୍‌ସନ୍‌ ୱେନ୍‌ବେଦେଂ ସାସ୍‌ କିୱାତାର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","ମାତର୍‌ ଜିସୁ ମନ୍ଦିର୍‌ତ ହିକ୍‌ୟା କିଜ଼ି ମାନି ସମୁତ ୱେନ୍‌ବାତାର୍‌, “କ୍ରିସ୍ଟ ଜେ, ଦାଉଦ୍‌ ମାଜ଼ି, ଇଦାଂ ଦରମ୍‌ ଗୁରୁର୍‌ ଇନେସ୍‌ ଇନାର୍‌ ? ");
INSERT INTO peg_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","ନିଜେ ନେ ଦାଉଦ୍‌ ପୁଇପୁୟା ଜିବୁନ୍ତାଂ ବାର୍‌ତି ଆଜ଼ି ଇଞ୍ଜି ମାଚାନ୍‌, ମାପ୍ରୁ ନା ମାପ୍ରୁତିଂ ଇଚାନ୍‌, ଆପେଂ ଜେ ନି ସାତ୍ରୁରିଂ ନି ପାନା ତାରେନ୍‌ ଇଡ୍‍ୱାତାପ୍‌ନା, ହେ ପାତେକ୍‌ ନା ବୁଜ୍‍ଣିପାଡ଼୍‍କା କୁଚ୍‌ଚି ମାନାଟ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","ନିଜେନେ ଦାଉଦ୍‌ କ୍ରିସ୍ଟଙ୍ଗ୍‌ ମାପ୍ରୁ ଇଞ୍ଜି ଇନାନ୍‌; “ଲାଗିଂ ଇସ୍ୱର୍‌ ବାଚିକିତି ରାକ୍ୟାକାରିୟା କ୍ରିସ୍ଟ ଇନେସ୍‌ ବାର୍‌ତି ମାଜ଼ି ଆନାନ୍‌ ?” ");
INSERT INTO peg_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","ୱିଜ଼ାକାର୍‌ ମାନାୟାର୍‌ ୱାରିତାଂ ହେୱାନ୍‌ ବେରଣ୍‌ ୱେନ୍‌ଞ୍ଜି ମାଚାର୍‌ । ଆରେ, ହେୱାନ୍‌ ଜାର୍‌ତି ହିକ୍ୟା ବିତ୍ରେ ଇଚାନ୍‌, “ଦରମ୍‌ ସାସ୍ତର୍‌ତାଂ ଜାଗ୍ରତ୍‌ !” ହେୱାର୍‌ ଡେଙ୍ଗା ଆଙ୍ଗି ଆର୍ପିସ୍‌ ବୁଲା ଆନି କାଜିଂ, ଆରେ ଆଟ୍‌ ବାଜାର୍‌ତ, ଜୱାର୍‌ ପାୟା ଆଦେଂ । ");
INSERT INTO peg_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","“କୁଟୁମ୍‌ ଇଞ୍ଜ ଗାଜା ବାହା ଆରି ବଜିତ ଗାଜା ବାହା ପାୟା ଆଦେଂ ୱାର୍‌ୟା ଆନାର୍‌; ");
INSERT INTO peg_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","ହେୱାର୍‌ ରାଣ୍ଡିକାଂ ଇଲ୍‌ ୱିଜ଼େ ନସ୍ଟ କିତାର୍‌ ଆରି ଟକାୟ୍‌ କିଜ଼ି ଲାମା ପାର୍ତାନା କିନାର୍‌; ହେୱାର୍‌ ଡାଣ୍ଡ୍‌ ପାୟା ଆନାର୍‌ !” ");
INSERT INTO peg_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","ପାଚେ ହେ ଗାଦ୍ୟା ଇଲ୍‌ ମୁମ୍‌ଦ କୁଚ୍‌ଚି ଲକାର୍‌ ଇନେସ୍‌ ଟାକାଂ ରୁଣ୍ଡାଇକିତାର୍‌, ହେଦାଂ ହୁଡ଼୍‌ଜି ମାଚାନ୍‌ । ଏଚେକାଡ଼୍‌ଦ ହେନି ମାନାୟାର୍‌ ମାଜାନିଂ ହେବେ ବେସି ଇଡ୍‌ତାର୍‌; ");
INSERT INTO peg_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","ଆରି, ରଞ୍ଜେଲ୍‌ ଅର୍କିତ୍‌ ରାଣ୍ଡି ରି ଟାକା ଡାବୁଙ୍ଗ୍‌ ହେବେ ରାତ୍‌ତାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","ହେବେଣ୍ଡାଂ ଜିସୁ ନିଜ୍‍ତି ଚେଲାରିଂ ଲାଗେ କୁକ୍‌ଚି ଇଚାନ୍‌, “ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ହାତ୍‌ପା ଇଞ୍ଜ୍‌ନାଙ୍ଗା, ଟାକାଂ ପେଡ଼ି ଇଡ଼୍‌ଜିମାନି ୱିଜ଼ାକାର୍‌ ତାକେଣ୍ଡାଂ, ଇ ଅର୍କିତ୍‌ ରାଣ୍ଡି ବେସି ଇଡ଼ିତାତ୍‌ ନା । ");
INSERT INTO peg_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","ଇନାକିଦେଂକି ୱିଜ଼ାକାର୍‌ ନିଜେ ନିଜେତି ବେସି ଦାନ୍‌ତ ଅଲପ୍‍ ଅଲପ୍‍ ଦାନ୍‌ ଇଡ଼ିତାର୍‌, ମାତର୍‌ ଇଦେଲ୍‌ ନିଜେତି ଇନାକା ହିଲ୍‌ୱାଦାଂ ନିଜେତି ଜିବୁନ୍‌ ବାଚାୟ୍‌ କିଦେଙ୍ଗ୍‌ ହେଦେଲ୍‌ତି ଇନାକା ମାଚାତ୍‌, ହେ ୱିଜ଼େ ରାତ୍‌ତାତ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","ଜିସୁ ମନ୍ଦିର୍‌ ତାଙ୍ଗ୍‌ ହସି ହାନି ୱେଡ଼ାଲିଂ ତା ଚେଲାର୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ରକାନ୍‌ ହେୱାନିଂ ଇଚାନ୍‌, “ଏ ଗୁରୁ, ହୁଡ଼ା; ଇନେସ୍‌ ଗାଜା ଗାଜା କାଲ୍‌କୁ ଆରି ଏଚେକ୍‌ ହଲ୍‌ନି ଇଲ୍‌ !” ");
INSERT INTO peg_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","ହେବେ ଜିସୁ ହେୱାନିଂ ଇଚାନ୍‌, “ଏନ୍‌ ଇନାକା ଇ ୱିଜ଼ୁ ଇଲ୍‌ ହୁଡ଼୍‌ନାୟା ? ର କାଲ୍‌ ବିନ୍‌ କାଲ୍‌ ଜପି ମାନୁତ୍, ୱିଜ଼ୁ ଦୁଡ଼ି ମାସ୍‌ନାତ୍ ।” ");
INSERT INTO peg_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","ପାଚେ ଜିସୁ ଜିତ୍‌ମାଡ଼ି ଜପି ମନ୍ଦିର୍‌ ହାଣ୍‌କୁ କୁଚ୍‌ଚିଲେ ପିତର୍‌, ଜାକୁବ୍‌, ଜହନ୍‌ ଆରି ଆନ୍ଦ୍ରିୟ ହେୱାନିଂ କାଲେତାଂ ୱେନ୍‌ବେଦେଂ ଲାଗାତାର୍‌, ଇ ସବୁ ଇନାୱାଡ଼ାଂ ଗିଟା ଆନାତ୍‌, ");
INSERT INTO peg_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“ଇମ୍‌ଣି ସମୁଦ ଇ ସବୁ ଗିଟା ଆନାତ୍‌, ହେ ସମୁନି ଦିନ୍‌ ଚିନ୍‌ ଇନାକା, ହେଦାଂ ମାଙ୍ଗେଙ୍ଗ୍‌ ୱେଚ୍‌ଚା ।” ");
INSERT INTO peg_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","ହେବେତାଂ ଜିସୁ ହେୱାରିଂ ୱେଚ୍‌ଚେଙ୍ଗ୍‌ ଲାଗାତାନ୍‌, “ଜାଗ୍ରତ୍‌, ଇନେସ୍‌ ଇନେର୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ବାମ୍‌ଣ୍ଡାୟ୍‌ କିଦ୍‍ମେର୍ ।” ");
INSERT INTO peg_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","ଆଦିକ୍‌ ମାନାୟାର୍‌ ନା ତର୍‌ଦ ୱାଜ଼ି, “ଆନ୍‌ କ୍ରିସ୍ଟ ! ଇଞ୍ଜି ହେୱାନ୍‌ ଇଞ୍ଜି ଚାକ୍ରାୟ୍‌ କିଦ୍‌ନାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","ଲାଗାୟ୍‌ ଜୁଜ୍‌ନି ସବଦ୍ କି ଦେହାନି ଜୁଜ୍‌ନି କାବୁର୍ ୱେନ୍‌ଞ୍ଜି ଏପେଙ୍ଗ୍‌ ପାଣ୍ଡ୍ରାଆମାଟ୍‌ । ଏଲେଙ୍ଗ୍‌ କେତେକ୍‌ ଗଟ୍‌ଣା ହାତ୍‌ପା ଗିଟାନାତ୍‌ । ମାତର୍‌ ଇଦାଂନି ଅରତ୍‌ ଆକାୟ୍‌ ଜେ ୱିଜ଼୍‌ନି ଦିନ୍‌ ଇକାୱାତାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","ମାତର୍‌ ଜାତି ବିରୁତ୍‌ତ ଜାତି ଆରି ରାଜି ବିରୁତ୍‌ତ ରାଜି ନିଙ୍ଗ୍‌ନାତ୍‌, ଆରେ ବାହା ବାହାତ ମେଦ୍‌ନି ଦାଲ୍‍କା ଆନାତ୍‌ ଆରି କାତାର୍‌ ଆର୍ନାତ୍‌, ଇ ସବୁ ଆରମ୍‌ନି ମୁଡ଼୍‌ଦାକା ।” ");
INSERT INTO peg_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","ମାତର୍‌ “ଏପେଙ୍ଗ୍‌ ଜାର୍‌ ଜାର୍‌ ବିସ୍ରେ ଜାଗ୍ରତ୍‌ ଆଜ଼ି ମାନାଟ୍‌, ମାନାୟାର୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ବିଚାର୍ଣ୍ଣା ବାହାତ ହେଲାୟ୍‌ କିଦ୍‌ନାର୍‌, ଆରି ଏପେଙ୍ଗ୍‌ କୁଟୁମ୍‌ ଇଞ୍ଜ ଟ୍ରାକ୍‌ୟା ଆନାଦେର୍‌, ଆରି ନା କାଜିଂ ରାଜି ଚାଲାୟ୍‌ କିନାକାନ୍‌ ଆରି ରାଜାର୍‌ ଲାଗେ ହେୱାର୍‌ କାଜିଂ ସାକି ହିଦେଂ କାଜିଂ ନିଲି କିଦ୍‌ନାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","ଆରେ, ପର୍ତୁମ୍‌ ସବୁ ଜାତି ତାକେ ଇସ୍ୱର୍‌ତି ନେକ୍ରିକାବୁର୍‌ ସୁଣାୟ୍‌ କିୟା ଆନାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","ଇଦାଂ କାଜିଂ ଏଚେକାଡ଼୍‌ଦ ମିଙ୍ଗେଙ୍ଗ୍‌ ଲକୁ ଆସ୍ତି ହେଲାୟ୍‌ କିଦ୍‌ନାର୍‌, ହେ କାଡ଼୍‌ଦ ଏପେଙ୍ଗ୍‌ ଇନାକା ଇନାଦେର୍‌, ହେ ବିସ୍ରେ ଆଗେନେ ଚିନ୍ତାକିମାଟ୍, ମାତର୍‌ ହେ ୱେଡ଼ାଲିଂ ମିଙ୍ଗେଙ୍ଗ୍‌ ଇନାକା ହିଦ୍ୟାଆନାତ୍ ହେଦାଂ ଇନାଟ୍‌, ଇନାକିଦେଂକି ଏପେଙ୍ଗ୍‌ ଇନାକାଦେର୍ ଆକାୟ୍‌ ମାତର୍‌ ପୁଇପୁୟା ଜିବୁନ୍‌ ଇନାକାନ୍‌ ମାନାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","ଟଣ୍ଡେନ୍‌ ଟଣ୍ଡେନ୍ତିଙ୍ଗ୍ ଆରି ଆବା ମାଜ଼ି ହାକି ବାହାତ ହେଲାୟ୍‌ କିତାର୍‌ ଆରେ ହିମ୍‌ଣାଙ୍ଗ୍ ଆବା ଆୟାକାଂ ବିରୁତ୍‌ତ ନିଙ୍ଗ୍‌ଜି ଅହ୍‌ନାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","ଆରେ, ଏପେଙ୍ଗ୍‌ ନା ପାଚେୱାତି କାଜିଂ ଏପେଙ୍ଗ୍‌ ୱିଜ଼ାକାର୍‌ତାଂ ଗିଣ୍‌କିୟା ଆନାଦେର୍‌, ମତର୍‌ ଇନେର୍‌ ହାରିହାରା ପାତେକ୍‌ ସାସ୍‌ ଆଜ଼ି ମାନାନ୍‌ ହେୱାନ୍‌ ସାର୍ଗେ ମୁକ୍ତି ପାୟା ଆନାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","ମାତର୍‌ “ଏପେଙ୍ଗ୍‌ ହେ ନାସ୍‌କିନି ଗିଣ୍‌ ଜିନିସ୍‌ତିଂ, ଇମେ ତାକେ ମାନ୍‌ୱି କାତା ଲଡ଼ା,” ହେବେ ମାନାକା ହୁଡ଼୍‌ନାଦେର୍‌ ପଡ଼ିକିନାକାର୍‌ ବୁଜାଆଏର୍‌, ଏଚେକାଡ଼୍‌ଦ ଇମ୍‌ଣାକାର୍‌ ଜିହୁଦା ରାଜିତ ମାନାର୍‌, ହେୱାର୍‌ ମାଡ଼ିତ ହନ୍‌ଚି ହାଲେର୍‌; ");
INSERT INTO peg_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","ଇନେର୍‌ ଜେଗନ୍‌ ଜପି ମାଚିସ୍‌, ତାରେନ୍‌ ୱାମେନ୍‌ ଆରି ଇଲ୍‌ ବିତ୍ରେ ଇନାକାପା ତାକେଦେଂ ହାଲ୍‌ମେନ୍‌; ");
INSERT INTO peg_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","ଆରେ ଇନେର୍‌ କାମାୟ୍‌ ବାହାତ ମାଚିସ୍‌, ହେୱାନ୍‌ ତା ହେନ୍ଦ୍ରା ଅଦେଂ ଉଲ୍‌ଟି ୱାମେନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","ହେୱାଡ଼ାଂ ଇନେର୍‌ ଏସ୍‌ ପିସ୍ତାକା ଆରି ମାୟ୍‌ ଉଟ୍‌ନି ଆୟା, ଅୟ୍‌ ହେୱେକ୍‌ କସ୍ଟନିକିକ୍‌ ! ");
INSERT INTO peg_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","ମାତର୍‌ ଇଦାଂ ଇନେସ୍‌ ପିନି ମାସ୍‌ତ ଆମେତ୍‌, ହେଦାଂ କାଜିଂ ଇସ୍ୱର୍‌ତାକେ ପାର୍ତାନା କିୟାଟ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","ଇନାକିଦେଂକି ହେୱାଡ଼ାଂ ଇ ଲାକେ କସ୍ଟଗିଟା ଆଦ୍‌ନାତ୍‌ ଜେ, ମାପ୍ରୁ କିତି ଉବ୍‌ଜାଣ୍‌ ଆରାମ୍‌ ତାଙ୍ଗ୍‌ ନେଜେଙ୍ଗ୍‌ ପାତେକ୍‌ ହେ ଲାକେ ଗିଟା ଆୱାତାତ୍‌ନା, ଆରି ଇନାୱାଡ଼ାଂପା ଗିଟାଆଦୁତ୍ । ");
INSERT INTO peg_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","ଆରେ, ମାପ୍ରୁ ହେ ସମୁଦିଙ୍ଗ୍‌ ଉଣା କିୱାଦାଂ ମାଚିସ୍‌, ତେବେ ଇମ୍‌ଣି ପୁର୍ତି ପା ମୁକ୍ତି ପାୟା ଆୱାତାତ୍ମା; ମାତର୍‌ ହେୱାନ୍‌ ଇନେରିଂ ବାଚି କିନାନା, ହେ ବାଚିକିତି ଲଗାଂ ସମୁଉଣା କିତାନ୍‌ନ୍ନା । ");
INSERT INTO peg_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","ହେ ଏଚେକାଡ଼୍‌ଦ ହୁଡ଼ାଟ୍‌, କ୍ରିସ୍ଟ ଇବେ ! ଆୱିତିସ୍‌ “ହୁଡ଼ାଟ୍‌, ହେବେ ! ଇନେର୍‌ ଜଦି ମିଙ୍ଗେଙ୍ଗ୍‌ ଏଲେଙ୍ଗ୍‌ ଇନ୍‌ଚିସ୍‌ ତେବେ ହେଦାଂ ପାର୍ତି କିମାଟ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","ଚାକ୍ରାୟ୍‌ କ୍ରିସ୍ଟର୍‌ ଆରି ଚାକ୍ରାୟ୍‌ ବେଣ୍‌ବାକ୍‌ଣାୟ୍‌କିନାକାର୍‌ ଏଲେଙ୍ଗ୍‌ ଚିନ୍‌ ଆରି କାବାନି କାମାୟ୍‌ ଚଚ୍‌ଚାନାର୍‌, ଇନେର୍‌ ଜଦି ଆତିସ୍‌, ଲାଗିଂ ବାଚିକିତି ଲଗାଂ ବାମ୍‌ଣ୍ଡାୟ୍‌ କିତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","ମାତର୍‌ ଏପେଙ୍ଗ୍‌ ଜାଲ୍‌ଦି ଆଜ଼ି ମାନାଟ୍‌; ଆନ୍‌ ପୁର୍ବେତାଂ ଇ ବିସ୍ରେ ମିଙ୍ଗେଙ୍ଗ୍‌ ୱେଚ୍‌ଚାତାଂ ।” ");
INSERT INTO peg_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“ମାତର୍‌ ହେୱାଡ଼ାଂ ହେ ଦୁକ୍‌ ପାଚେ ୱେଡ଼ା ମାଜ୍‌ଗା ଆନାତ୍‌ ଆରି ଲେଞ୍ଜ୍ ଅଜଡ଼୍‌ ହିଉତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","ପାଚେ ହୁକାଙ୍ଗ୍‌ ବାଦାଡ଼୍‌ତାଂ ଆର୍‌ଦେଂ ଲାଗିନିକ୍‌ ଆରି ବାଦାଡ଼୍‌ନି ସାକ୍ତି ୱିଜ଼ୁ ତ୍ରିଗ୍‌ଜି ହାନିକ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","ହେୱାଡ଼ାଂ ମାନାୟ୍‌ ମାଜ଼ି ବାଦାଡ଼୍‌ତ ଜବର୍‌ ସାକ୍ତି ଆରି ପାଣ୍‌ହୁକେ ବାଦାଡ଼୍‌ତ ୱାନାକା ହୁଡ଼୍‍ନାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","ତା ବାଚିକିତି ମାନାୟାରିଂ ପୁର୍ତିନି ର ହାନ୍ଦିତାଂ ବିନ୍‌ ହାନ୍ଦି ପାତେକ୍‌ ଦାସ୍‌ସି ରୁଣ୍ଡାୟ୍‌ କିନି କାଜିଂ ହେୱାନ୍‌ ତା ସାର୍ଗେନି ଦୁତ୍‌କୁକାଂ ଚାର୍‌ବେଣ୍‌ତାଂ ପକ୍‌ତାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“ତଗା ମାର୍‌ଦିଂ ଉତର୍‌ମୁଡ଼୍‌ ହିକ୍ୟା କିୟାଟ୍‌, ଏଚେକାଡ଼୍‌ଦ ହେ କେନ୍ଦାଂ ଆକିଂ ଗିଲ୍‌ନିଂ, ହେ ଏଚେକାଡ଼୍‌ଦ ଜେଟ୍‌ କାଡ଼୍‌ ଲାଗାଂ ଏକା ୱାତାତେ ଇଞ୍ଜି ଏପେଙ୍ଗ୍‌ ପୁଞ୍ଜି ମାନାଟ୍‌; ");
INSERT INTO peg_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","ହେ ଲାକେ ଏପେଙ୍ଗ୍‌ପା ଇ ସବୁ ଗଟ୍‌ଣା ହୁଡ଼୍‌ତିସ୍‍ ହେୱାନ୍‌ ଦୁୱେର୍‌ ଲାଗେ ଆତାତେ ଇଞ୍ଜି ପୁନାଟ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ହାତ୍‌ପା ଇଞ୍ଜ୍‌ନାଙ୍ଗା, ଇ ସବୁ ଗିଟାୱି ପାତେକ୍‌ ନେଞ୍ଜେୱିଗାନି ନାର୍‌ ଇନେସ୍‌ କିତିସ୍‌ ପା ବୁଡା ଆଉର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","ଆକାସ୍‌ ଆରି ପୁର୍ତି ବୁଡା ଆନାତ୍‌, ମାତର୍‌ ନା ବଚନ୍‌ ୱିଜ଼େ ବୁଡା ଆଉତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","ମାତର୍‌ ହେ ଦିନ୍‌ କି ସମୁ ବିସ୍ରେ ଇନେର୍‌ ପୁନୁର୍‌,” ସାର୍ଗେପୁର୍‍ନି ଦୁତ୍‌ର୍‌ କି ମାଜ଼ିପା ପୁନୁନ୍; ମାତର୍‌ ନା ସାର୍ଗେନି ଆବା ପୁନାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","ଏପେଙ୍ଗ୍‌ ଜାଲ୍‌ଦି ଆଜ଼ି ମାନାଟ୍‌, କାସି ମାନାଟ୍, ମାତର୍‌ ହେ ସମୁ ଇନାୱାଡ଼ାଂ ଆନାତ୍‌ ହେଦାଂ ଏପେଙ୍ଗ୍‌ ପୁନୁଦେର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","ହେଦାଂ ଏଲେଙ୍ଗ୍‌ ଇନେସ୍‌ ରକାନ୍‌ ମାନାୟ୍‌ ଇଲ୍‌ ପିସ୍ତି ବିଦେସ୍‌ତ ହାଲ୍‌ଜି ବାହା କିନାକାନ୍‌, ଆରି ହେ ଆଡ଼ିୟାରିଂ ଆଦିକାର୍‌ ହିଜ଼ି ୱିଜ଼ୁ କାମାୟ୍‌ ରଚ୍‍ଚିପା ଦୁୱେର୍‌ତ ଜାଗ୍‌ୱାଡ଼ାରିଂ କାତେଙ୍ଗ୍ ବଲ୍‌ ହିତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","ଇଚିସ୍‌ ଏଚେକାଡ଼୍‌ଦ ଇଲ୍‌ ହାଉକାର୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ଜାଗ୍ରତ୍‌ ମାଞ୍ଜେଙ୍ଗ୍‌ ଇଞ୍ଜ୍‌ନାନ୍‌, ମାତର୍‌ ହେୱାନ୍‌ ମ୍ଡିକା ହାରେସ୍‍ କୁଜ଼ୁ କ୍ଡେନି ସମୁଦ କି ନାଣାଙ୍ଗେ ହେ ପାଦ୍‌ନା ହେୱାନ୍‌ ୱାନାନ୍‌ ହେଦାଂ ଏପେଙ୍ଗ୍‌ ପୁନୁଦେର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","ହେୱାନ୍‌ ବେଗି ୱାଜ଼ିପା ହାଞ୍ଜେଙ୍ଗ୍‌ ଆଡ୍‌ନାନ୍‌ ଏପେଙ୍ଗ୍‌ ଜଦି ସବୁୱେଡ଼ାଙ୍ଗ୍‌ ଜାଗ୍ରତ୍‌ ଆଜ଼ି ମାନାଦେର୍‌ ଲାଗିଂ ହେୱାନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ହୁଞ୍ଜନାକା ହୁଡ଼୍‌ଦେଂ ଆଡ଼୍‍ଦୁନ୍‍ । ");
INSERT INTO peg_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ଇନାକା ଇଞ୍ଜ୍‌ନାଙ୍ଗା, ହେଦାଂ ୱିଜ଼ାକାରିଂ ଇଞ୍ଜ୍‌ନାଙ୍ଗା, ଜାଗ୍ରତ୍‌ ମାନାଟ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","ହେ ନିସ୍ତାର୍‌ ପାର୍ବୁ ଆରି ହଇୱି ରୁଟି ପାର୍ବୁ ଆଦେଂ ରି ଦିନ୍‌ ମାଚାତ୍‌ । ହେ ୱେଡ଼ାଲିଂ ମୁଡ଼୍‌ ମାପ୍ରୁ ହେବା କିନାକାର୍‌ ଆରି ସାସ୍ତିର୍‌ ଇନେସ୍‌ ଜିସୁଙ୍ଗ୍‌ ଚାଲାକି କିଜ଼ି ଆସ୍ତେଙ୍ଗ୍‌ ଆଡ୍‌ନାର୍‌, ହେବେ ନି ଉପାୟ୍‌ ଡେକ୍‌ଚି ମାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","“ଇନେକିଦେଂକି ହେୱାର୍‌ ଇଚାର୍‌,” ପାର୍ବୁ ୱେଡ଼ାଲିଂ ଆକାୟ୍‌, “ଏଚେକାଡ଼୍‌ଦ ମାନାୟ୍‌ ବିତ୍ରେ ଗଣ୍ଡ୍‌ଗଲ୍‌ ଆନାତ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","ଜିସୁ ବେତ୍‌ନିୟାତ ଗାଜାରଗ୍‌ନି ସିମନ୍‌ ଇଞ୍ଜ ତିଞ୍ଜେଙ୍ଗ୍‌ କୁଚ୍‌ଚି ୱେଡ଼ାଲିଂ ର କଗ୍‌ଲେ ର କଣ୍ଡିତ ବେସି ହାର୍ଦାକା ଜଟାମାଂସି ବାସ୍‌ନା ଚିକାଣ୍‌ ତାସି ଜିସୁ କାପ୍‌ଡ଼ାତ ଚିକାଣ୍‌ କଣ୍ଡି ଡ୍ରିକ୍‌ଚି ୱାକ୍‍ତେଙ୍ଗ୍‍ ଲାଗାତାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","ଆରେ କେତେକ୍‌ ହେବେ ମାଚି ମାନାୟ୍‌ ରିସା ଆଜ଼ି ହେୱାର୍‌ ୱେଚ୍‌ପା ଆତାର୍‌, “ବାସ୍‌ନା ଚିକାଣ୍‌ ଇଦେଲ୍‌ ଇନେକିଦେଂ ଆର୍ଲା କିନାତା ? ");
INSERT INTO peg_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","ଇ ବାସ୍‌ନା ଚିକାଣ୍‌ତ ତିନ୍‌ସ ଦିନ୍‌ତି ଟାକାଂ ଆଦିକ୍‌ ମଲ୍‌ତ ପ୍ରସି ହିଲ୍‌ୱାକାରିଂ ହିୟାତାତ୍‌ମା । ଲାଗିଂ ହେୱାର୍‌ ହେ କଗ୍‌ଲେ ହିମ୍‌ଣାତି କେତ୍‌ତେଙ୍ଗ୍‌ ଲାଗାତାର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","ମାତର୍‌ ଜିସୁ ଇଚାନ୍‌, “ଆନ୍ଦେଂଲିଂ ପିହାଟ୍, ଇନେକିଦେଂ ତାଙ୍ଗେଙ୍ଗ୍‌ କସ୍ଟ ହିନାଦେରା ? ହେଦେଲ୍‌ତ ନା କାଜିଂ ହାର୍ଦି କାମାୟ୍‌ କିନାତା ।” ");
INSERT INTO peg_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","ଇନେକିଦେଂକି ଅର୍କିତ୍‌ ଲଗୁ ସବୁୱେଡ଼ାଙ୍ଗ୍‌ ମି “ଲାଗାଂ ମାନାର୍‌, ଆରି ମିଦାଙ୍ଗ୍‌ ଏଚେକାଡ଼୍‌ଦ ଇଚା ହେ ଏଚେକାଡ଼୍‌ଦ ପା ହେୱାରିଂ ଉପ୍‌କାର୍‌ କିଦେଙ୍ଗ୍‌ ଆଡ୍‌ନାଦେର୍‌, ମତର୍‌ ଆନ୍‌ ସବୁୱେଡ଼ାଙ୍ଗ୍‌ ମି ତାକେ ମାନୁଙ୍ଗ୍ । ");
INSERT INTO peg_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","ହେଦେଲ୍‌ ଏଚେକ୍‌ ଆଡ଼୍‌ଦାତାତ୍‌, ହେଦାଂ ହେଦେଲ୍‌ କିତାତ୍‌ନା; ହେଦେଲ୍‌ ଦୁଗେର୍‌ କାଜିଂ ନା ଗାଗାଡ଼୍‌ତିଂ ଆଗେନେ ଚିକାଣ୍‌ କାସ୍‌ଦାତାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ହାତ୍‌ପା ଇଞ୍ଜ୍‌ନାଙ୍ଗା, ୱିଜ଼େ ପୁର୍ତି ତାକେ ଇମ୍‌ଣି ବାହାତ ପା ନେକ୍ରିକାବୁର୍‌ ୱେଚ୍‍ଚିୟା ଆନାତ୍‌, ହେ ବାହାତ ଇ କଗ୍‌ଲେଂ ଏତୁ କିଦେଙ୍ଗ୍‌ ତାଦେଲ୍‍ତି ଇ କାମାୟ୍‌ନି କାତା ପା ଇନିୟା ଆନାତ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","ହେବେ ବାର ଚେଲାର୍‌ ବିତ୍ରେ ଇସ୍କାରିୟତିୟ ଜିହୁଦା ଇଞ୍ଜି ରକାନ୍‌ ହେୱାନ୍‌ ମୁଡ଼୍‌ ମାପ୍ରୁହେବାକିନାକାର୍‌ କେଇଦ ହେଲାୟ୍‌ କିଦେଙ୍ଗ୍‌ କାଜିଂ ହେୱାର୍‌ ତାକେ ହାଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","ହେଦାଂ ୱେନ୍‌ଞ୍ଜି ୱାରିୟା ଆତାର୍‌ ଆରି ହେୱାନିଂ ଟାକାଂ ହିଦେଂ ଇଞ୍ଜି ପାର୍ମାଣ୍‌ କିତାର୍‌ । ହେବେତାଂ ହେୱାନ୍‌ ଜିସୁଙ୍ଗ୍‌ ସୁବିଦା ହୁଡ଼୍‌ଜି ଇନେସ୍‌ ଆହିକିଦେଂ ଆଡ୍‌ନାନ୍‌, ଇଦାଂ ଉପାୟ୍‌ ଡେକ୍‌ତେଂ ଲଗାତାନ୍ । ");
INSERT INTO peg_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","ପାଚେ ହେ ହଇୱି ରୁଟି ପାର୍ବୁନି ପର୍ତୁମ୍‌ ଦିନ୍ତ, ଇମ୍‌ଣି ଦିନ୍‌ ନିସ୍ତାର୍‌ ପାର୍ବୁନି ମେଣ୍ଡାହିମ୍‌ଣା ପୁଜାକିନାର୍‌, ହେ ଦିନ୍‌ ଜିସୁତି ଚେଲାର୍‌ ହେୱାନିଂ ୱେନ୍‍ବାତାର୍, “ଆସେଙ୍ଗ୍‌ ହାଲ୍‌ଜି ନି କାଜିଂ ନିସ୍ତାର୍‌ ପାର୍ବୁ ତିଞ୍ଜେଙ୍ଗ୍‌ ଜାତ୍‌ନାୟ୍‌ କିନାପ୍‌ ଇଞ୍ଜି ନି ଇଚା କିନାୟା ?” ");
INSERT INTO peg_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","ହେବେତାଂ ହେ ଚେଲାର୍‌ ବିତ୍ରେ ରିୟାରିଂ ଏଲେଙ୍ଗ୍‌ ୱେଚ୍‌ଚି ପକ୍‌ତାନ୍‌ । “ଏପେଙ୍ଗ୍‌ ଗାଡ଼୍‌ଦ ହାଲାଟ୍‌, ଆରି ରକାନ୍‌ ଗାଗ୍ରି ଆସ୍ତି ହାନି ମାନାୟ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ବେଟା ଆଦ୍‌ନାନ୍‌, ତା ପାଚେ ପାଚେ ହାଲାଟ୍‌; ");
INSERT INTO peg_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","ଇମ୍‌ଣି ଇଞ୍ଜ ହେୱାନ୍‌ ହଣାନ୍‌ । ହେ ଇଞ୍ଜ ନି ମୁଣିକାଙ୍ଗ୍ ଇନାଟ୍‌, ଗୁରୁ ୱେନ୍‌ବା ଆଦ୍‍ନାନା, ଆନ୍‌ ନା ଚେଲାର୍‌ ହୁକେ ଇମେତାକେ ନିସ୍ତାର୍‌ ପାର୍ବୁ ବଜି କିନାଙ୍ଗ୍, ଇମେତ୍‌ ନା ହେ ଗତାଙ୍ଗ୍‍ବାହା ।” ");
INSERT INTO peg_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","ହେୱାନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ହେବେ ଜାତ୍‌ନାୟ୍‌ ଆରି ଜାଲ୍‌ଦି କିିତି ଜପ୍‌ଣି ଗାଜା ବାକ୍ରା ଚଚାନାନ୍, ହେ ବାହାତ ମାକାଜିଂ ଜାଲ୍‌ଦି କିୟାଟ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","ହେବେତାଂ ଚେଲାର୍‌ ହସି ଗାଡ଼୍‌ ବିତ୍ରେ ହଟାର୍, ଆରେ ଜିସୁ ହେୱାରିଂ ଇନେସ୍‌ ଇଞ୍ଜି ମାଚାନ୍‌, ହେ ଲାକେ ହୁଡ଼୍‌ଜି ନିସ୍ତାର୍‌ ପାର୍ବୁ ଦିନ୍ତି ବଜି ଜାଲ୍‌ଦି କିତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","ମ୍ଡିତିଲେ ହେୱାନ୍‌ ବାରଜାଣ୍‌ ଚେଲାର୍‌ ହୁକେ ୱାତାନ୍ । ");
INSERT INTO peg_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","ହେୱାର୍‌ କୁଚ୍‌ଚି ତିନି ସମୁଦ ଜିସୁ ଇଚାନ୍‌, “ଆନ୍‌ ହାତ୍‌ପା ଇଞ୍ଜ୍‌ନାଙ୍ଗା, ମି ବିତ୍ରେ ରକାନ୍‌, ଇନେର୍‌କି ନା ହୁକେ ତିନାନା, ହେୱାନ୍‌ ନାଙ୍ଗେଙ୍ଗ୍‌ ସାତ୍ରୁ କେଇଦ ହେଲାୟ୍‌ କିଦ୍‌ନାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","ହେବେ ହେୱାର୍‌ ଦୁକ୍‌ ଆଜ଼ି ରକାର୍ ରକାର୍ କିଜ଼ି ହେୱାନିଂ ୱେନ୍‍ବାତାର୍, “ହେୱାନ୍‌ ଇନାକା ଆନ୍‌ ?” ");
INSERT INTO peg_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","ଜିସୁ ହେୱାରିଂ ଇଚାନ୍‌, “ବାରଜାଣ୍‌ ବିତ୍ରେ ରକାନ୍‌, ଇନେର୍‌କି ନା ହୁକେ ତାଡ଼ିୟାତ ରୁଟି କ୍ଡୁକ୍‍ନାନ୍‍ ହେୱାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","ମାନାୟ୍‌ ମାଜ଼ି ବିସ୍ରେ ସାସ୍ତର୍‌ ତାକେ ଇନେସ୍‌ ଲେକା ଆତାତ୍‌ନ୍ନା, ହେ ଲାକେ ହାକି ଡାଣ୍ଡ୍‌ ପାୟାଦେଂ ହାନାନା, ମାତର୍‌ ମାନାୟ୍‌ ମାଜ଼ି ସତ୍ରୁ କେଇଦ ହେଲାୟ୍‌ କିୟା ଆନାନ୍‌, ଆ ହେୱାନ୍‌ ଦାଣ୍ଡ୍‌ ପାୟା ଆନାନ୍‌ ! ହେୱାନ୍‌ ମାନାୟ୍‌ ଜଲମ୍‌ ଆୱାଦାଂ ମାଚିସ୍‌ ହେୱାନ୍‌ ତା ପାକ୍ୟାତ ହାର୍‌ ଆତାତ୍ମା !” ");
INSERT INTO peg_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","ହେୱାର୍‌ ତିନି ୱେଡ଼ାଲିଂ ହେ ରୁଟି ଅସି ଆସିର୍ବାଦ୍‌ କିଜ଼ି ହେୱାରିଂ ହିତାନ୍‌ ଆରି ହେଦାଂ ଡ୍ରିକ୍‌ଚି ହେୱାରିଂ ହିଜ଼ି ଇଚାନ୍‌, “ଇନ୍ଦାଟ୍‌, ଇଦାଂ ନା ଗାଗାଡ଼୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","ଆରେ, ହେୱାନ୍‌ କଲ୍‌ସି ଆସ୍ତି ଜୁୱାର୍‌ କିସି ହେୱାରିଂ ହିତାନ୍‌ “ଆରି ୱିଜ଼ାକାର୍‌ ହେବେଣ୍ଡାଂ ଉଟାର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","ଆରି, ଜିସୁ ହେୱାରିଂ ଇଚାନ୍‌, ଇମ୍‌ଣି ନିୟମ୍‌ନି ନେତେର୍‌ ବେସି ଲଗାଂ କାଜିଂ ରାକ୍ୟା ଆନାତା, ଇଦାଂ ନା “ହେ ନେତେର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ହାତ୍‌ପା ଇଞ୍ଜ୍‌ନାଙ୍ଗ୍‌, ଆନ୍‌ ଏଚେକାଡ଼୍‌ଦ ପୁନି କିଜ଼ି ଇସ୍ୱର୍‌ ରାଜିତ ଅଙ୍ଗୁର୍‌ ପାଡ଼୍‌ନି ରାସ୍‌ ଉଣାଙ୍ଗ୍‌, ହେ ଦିନ୍‌ ପାତେକ୍‌ ଇଦାଂ ଆରି ଇନାୱାଡ଼ାଂପା ଉଣ୍ଡେଙ୍ଗ୍‌ କଙ୍ଗ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","ଆରେ, ହେୱାର୍‌ କେର୍‌ତି ପାଚେ ଜିତ୍‌ମାଡ଼ିତ ହସି ହାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","ହେ ଏଚେକାଡ଼୍‌ଦ ଜିସୁ ହେୱାରିଂ ଇଚାନ୍‌, ଏପେଙ୍ଗ୍‌ ୱିଜ଼ାକାଦେର୍‌ ବାଦାପାୟା ଆନାଦେର୍‌, ଇନେକିଦେଂକି ଲେକା ଆତାତ୍‌ନ୍ନା, “ଆସେଙ୍ଗ୍‌ ମେଣ୍ଡା ଗଡ଼ିୟାଙ୍ଗ୍‌ ଅସ୍‌ତିସ୍‌, ଆରି ମେଣ୍ଡାଂ ଜେତ୍‌ କେତ୍‌ ଆଜ଼ି ହାନିକ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","ମାତର୍‌ ଆନ୍‌ ନିଙ୍ଗ୍‌ତି ପାଚେ ମି ଆଗେ ଗାଲିଲିତ ହାନାଙ୍ଗ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","ମତର୍‌ ପିତର୍‌ ହେୱାନିଂ ଇଚାନ୍‌, “ୱିଜ଼ାକାର୍‌ ନିଙ୍ଗେଙ୍ଗ୍‌ ପିସ୍ତି ହାନ୍‍ଚିସ୍ପା, ଆନ୍‌ ପିସ୍ତି ହାଞ୍ଜୁଙ୍ଗ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","ଜିସୁ ହେୱାନିଂ ଇଚାନ୍‌, “ଆନ୍‌ ନିଙ୍ଗେଙ୍ଗ୍‌ ହାତ୍‌ପା ଇଞ୍ଜ୍‌ନାଙ୍ଗା, ନେଞ୍ଜେଙ୍ଗ୍‌ ଇ ନାଣା ରିହା କୁଜ଼ୁ କ୍ଡେନି ଆଗେ ଏନ୍‌ ନାଙ୍ଗେଙ୍ଗ୍‌ ତିନିହଟ୍‌ ପାର୍ତି କିଦୁୟ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","ମାତର୍‌ ହେୱାନ୍‌ ଆଟ୍‌ୱା କିଜ଼ି ଇଞ୍ଜେଙ୍ଗ୍‌ ଲାଗାତାନ୍‌, “ଜଦି ଆନ୍‌ ନି ହୁକେ ହାଦେଂ ଲାଗ୍‌ଦାନାତ୍‌ ଆତିସ୍‌ ପା ଆନ୍‌ ନିଙ୍ଗେଙ୍ଗ୍‌ ମୁଡ଼୍‌କେ ଉଡ଼ା ଆଦୁଙ୍ଗ୍ । ଆରି ୱିଜ଼ାକାର୍‌ପା ହେ ଲାକେ ଇଚାର୍‌ !” ");
INSERT INTO peg_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","ପାଚେ ହେୱାର୍‌ ଗେତ୍‌ସିମନି ଇନି ତର୍‌ ର ବାହାତ ୱାତାର୍, ଆରି ହେୱାନ୍‌ ହେ ଚେଲାରିଂ ଇଚାନ୍‌, “ଆନ୍‌ ପାର୍ତାନା କିନି ପାତେକ୍‌ ଏପେଙ୍ଗ୍‌ ଇବେ କୁଚ୍‌ଚି ମାନାଟ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","ଆରେ, ହେୱାନ୍‌ ପିତର୍‌, ଜାକୁବ୍‌ ଆରି ଜହନ୍‌ତିଂ ହାଙ୍ଗ୍‌ ଅଜ଼ି ଆଦିକ୍‌ କାବା ଆଜ଼ି ଆରି ବିପ୍ତି ଆଦେଂ ଲାଗାତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","ହେବେ ଜିସୁ ହେୱାରିଂ ଇଚାନ୍‌, “ନା ୱାସ୍କି ହାକି ଲାକେ ବେସି ଦୁକ୍‌ ଆନାତା; ଏପେଙ୍ଗ୍‌ ଇବେ ମାନ୍‌ଞ୍ଜି କାସି ମାନାଟ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","ଜଦି ଆନାତ୍‌ ହେ ଦୁକ୍‌ ଇନେସ୍‌ ଦେହା ଆନାତ୍‌ ହେବେତାଂ ହେୱାନ୍‌ ଅଲପ୍‍ ଦେହା ହାଲ୍‌ଜି ମେଦ୍‌ନିତ ଗୁର୍‌ଜି, ପାର୍ତାନା କିଦେଙ୍ଗ୍‌ ଲାଗାତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","ଆରି ଜିସୁ ଇଚାନ୍‌, “ଆବା, ୱିଜ଼ୁ ନି ପୁରା, ଇ ଉଣି ଗିନା ନା ତାଙ୍ଗ୍‌ ଦେହା ଇଟା, ଆତିସ୍‌ପା ନା ଇଚା ଆକାୟ୍‌, ମାତର୍‌ ନି ଇଚା ।” ");
INSERT INTO peg_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","ଆରେ, ହେୱାନ୍‌ ୱାଜ଼ି ହେୱାରିଂ ହୁଞ୍ଜ୍‌ନାକା ହୁଡ଼୍‌ତାନ୍‌ ଆରି ପିତର୍‌ତିଂ ଇଚାନ୍‌, “ସିମନ୍‌, ଏପେଙ୍ଗ୍‌ ଇନାକା ହୁଞ୍ଜ୍‌ନାଦେରା ? ର ଗଣ୍ଟା କାତେଙ୍ଗ୍ ଆଡ୍‌ୱାତାଦେର୍‌ ?” ");
INSERT INTO peg_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","“ପରିକ୍ୟାତ ଇନେସ୍‌ ଆର୍‌ମାଟ୍‌, ଇଦାଂ କାଜିଂ କାସିମାଞ୍ଜି ପାର୍ତାନା କିୟାଟ୍‌, ଜିବୁନ୍‌ ଇଚା, ମାତର୍‌ ଗାଗାଡ଼୍‌ ନାଦାର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","ହେୱାନ୍‌ ଆରି ଆଗେ ଲାକେ ହାଲ୍‌ଜି କାତା ଇଞ୍ଜି ପାର୍ତାନା କିତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","ଆରେ ରଗ ୱାଜ଼ି ଜିସୁ ହେୱାରିଂ ହୁଞ୍ଜ୍‌ନାକା ହୁଡ଼୍‌ତାନ୍‌, ଇନେକିଦେଂକି ହେୱାର୍‌ ହୁଞ୍ଜ୍‍କାଣ୍‍କୁଙ୍ଗ୍‌ ଜୁଚ୍‍ପିୟା ଆଜ଼ି ମାଚିକ୍‌, ଆରି ହେୱାନିଂ ଇନା ଉତର୍‌ ହିନାର୍‌, ହେଦାଂ ପୁନ୍‌ୱାଦାଂ ମାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","ହେୱାନ୍‌ ତିନିହଟ୍‌ ୱାଜ଼ି ହେୱାରିଂ ଇଚାନ୍‌, “ଏପେଙ୍ଗ୍‌ ଇନାକା ଆରି ହୁନ୍‌ଞ୍ଚାଦେର୍ଣ୍ଣା ? ଜବର୍‌ ଆତାତେ ! ହୁଡ଼ାଟ୍‌, ମାନାୟ୍‌ ମାଜ଼ି ପାପିର୍‌ କେଇତାକେ ହେଲାୟ୍‌ ଆନାନା । ");
INSERT INTO peg_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","ନିଙ୍ଗାଟ୍‌, ଆସେଙ୍ଗ୍‌ ହାନାସ୍; ହୁଡ଼ାଟ୍‌, ଇନେର୍‌ ନାଙ୍ଗେଙ୍ଗ୍‌ ସତ୍ରୁ କେଇଦ ହେଲାୟ୍‌ କିଦ୍‌ନାନ୍‌ ହେୱାନ୍‌ ଲାଗାଂ ୱାତାନେ !” ");
INSERT INTO peg_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","ଆରେ ସାଙ୍ଗେ ସାଙ୍ଗେ, ହେୱାନ୍‌ କାତା ଇନି ୱାଡ଼ାଲିଂ ବାରଜାଣ୍ ବିତ୍ରେ ଜିହୁଦା ଇନି ରକାନ୍‌ ଆରି ହେନି ଲକୁ ହେୱାନ୍‌ ହୁକେ ମୁଡ଼୍‌ ମାପ୍ରୁ ହେବା କିନାକାର୍‌, ସାସ୍ତିର୍‌ ଆରି ପ୍ରାଚିନାର୍‌ ତାଙ୍ଗ୍‌ ଲକୁ କାଣ୍ଡାଂ ଆରି ଟେଙ୍ଗାଙ୍ଗ୍ ଆଜ଼ି ୱାତାର୍ । ");
INSERT INTO peg_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","ଜିସୁଙ୍ଗ୍‌ ସତ୍ରୁ କେଇଦ ହେଲାୟ୍‌ କିନାକାନ୍‌ ଏଲେଙ୍ଗ୍‌ ଚଚ୍‌ଚି ହିଜ଼ି ଇଞ୍ଜି ମାଚାନ୍‌ । “ଆନ୍‌ ଇନେରିଂ ଡଞ୍ଜ୍‌ଗାନାଂ, ହେୱାନ୍‌ ହେୱେନ୍‌, ହେୱାନିଂ ଆସ୍ତି ଜାଗ୍ରତ୍‌ ତ ଅନାଦେର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","ଲାଗିଂ ହେୱାନ୍‌ ହେପାଦ୍‌ନା ହେୱାନ୍‌ ଲାଗେ ହାଲ୍‌ଜି, “ଏ ଗୁରୁ !” ଇଞ୍ଜି ହେୱାନିଂ ବେସି ଡନ୍‍ଚାନ୍ । ");
INSERT INTO peg_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","ହେବେତାଂ ହେୱାର୍‌ ତା ଜପି କେଇ କିସି ଆସ୍ତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","ମାତର୍‌ ଲାଗେ ନିଲ୍‌ଚିମାନି ମାନାୟାର୍‌ ତାଙ୍ଗ୍‌ ରକାନ୍‌ କାଣ୍ଡା ହପ୍‌ତାନ୍ ଆରି ମୁଡ଼୍‌ ମାପ୍ରୁ ହେବା କିନାକାନ୍‌ ଆଡ଼ିଏନିଂ କେଇ କିଜ଼ି ତା କିତୁଲ୍‌ ହଣ୍‌ଜି ତୁହିତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","ଜିସୁ ହେୱାରିଂ ଉତର୍‌ ହିତାନ୍‌, “ଚର୍କୁ ବିରୁଦ୍‌ତ ହତି ଲାକେ କାଣ୍ଡା ଆରି ଟେଙ୍ଗା ଆଜ଼ି ଇନାକା ନାଙ୍ଗେଙ୍ଗ୍‌ ଆସ୍ତେଙ୍ଗ୍‌ ୱାତାଦେର୍ଣ୍ଣା ? ");
INSERT INTO peg_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","ସବୁ ଦିନ୍‌ ଆନ୍‌ ମି ହୁକେ ମନ୍ଦିର୍‌ତ ମାନ୍‌ଞ୍ଜି ସିକ୍ୟା ହିିଜ଼ି ମାଚାଙ୍ଗ୍‌, ମାତର୍‌ ନାଙ୍ଗେଙ୍ଗ୍‌ ଏପେଙ୍ଗ୍‌ ଆସ୍ତାୱାତାଦେର୍‌, ମାତର୍‌ ଦରମ୍‌ ସାସ୍ତର୍‌ କାତା ଗିଟାଆନି କାଦ୍‌ଲିଂ ଇଞ୍ଜି ଇ ସବୁ ଗିଟା ଆନାତା ।” ");
INSERT INTO peg_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","ହେବେ ୱିଜ଼ାର୍‌ ଚେଲାର୍‌ ହେୱାନିଂ ହେ ଏଚେକାଡ଼୍‌ଦ ପିସ୍ତି ହନ୍ତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","ମାତର୍‌ ରକାନ୍‌ ଦାଙ୍ଗ୍‌ଣା ହିମ୍‌ଣେନ୍ ଡୁମ୍‌ଣ୍ଡା କୱାଣ୍‌ ହେନ୍ଦ୍ରା ପର୍‌ଚି ହେୱାନ୍‌ ପାଚେ ପାଚେ ହାଲ୍‌ଜି ମାଚାନ୍‌, ହେୱାର୍‌ ହେୱାନିଂ ଆସ୍ତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","ମାତର୍‌ ହେୱାନ୍‌ ହେ କୱାଣ୍‌ ହେନ୍ଦ୍ରା ପିସ୍ତି ଡୁମ୍‌ଣ୍ଡା ଗାଗାଡ଼୍‌ତ ହନ୍‌ତାନ୍ । ");
INSERT INTO peg_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","ପାଚେ ହେୱାର୍‌ ଜିସୁଙ୍ଗ୍‌ ମୁଡ଼୍‌ ମାପ୍ରୁହେବା କିନାକାର୍‌ ତାକେ ଅତାର୍‌, ଆରେ ମୁଡ଼୍‌ ମାପ୍ରୁ ହେବା କିନାକାର୍‌, ପ୍ରାଚିନାର୍‌ ଆରି ସାସ୍ତିର୍‌ ୱିଜ଼ାକାର୍‌ ୱାଜ଼ି ରୁଣ୍ଡାଆତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","ପିତର୍‌ ଦେହା ମାନ୍‌ଞ୍ଜି ହେୱାର୍‌ ପାଚେ ପାଚେ ମୁଡ଼୍‌ ମାପ୍ରୁ ହେବା କିନାକାର୍‌ ହାକ୍‌ଡ଼ି ବିତ୍ରେ ହାଚାନ୍‌ ଆରି ପାଦ୍‌ ଆଦିକାରି ହୁକେ କୁଚ୍‌ଚି ନାଣି କାଇଜି ମାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","ଇଦାଂ ପାଚେ ମୁଡ଼୍‌ ମାପ୍ରୁହେବା କିନାକାନ୍‌ ଆରି ଜିହୁଦି ସବାନିକାର୍ ଜିସୁଙ୍ଗ୍‌ ବିରୁଦ୍‌ତ ସାକି ଡେକ୍‌ତେଂ ଲାଗାତାର୍‌, ମାତର୍‌ ଗାଟା ଆୱାତାର୍‌; ");
INSERT INTO peg_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","ଇଦାଂ କାଜିଂ ବେସି ମିଚ୍‌ ସାକି ହିତାର୍‌ ମାତର୍‌ ହେୱାର୍‌ ସାକି ଗାଟାୱାତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","ପାଚେ କେତେକ୍‌ ଲଗୁ ନିଙ୍ଗ୍‌ଜି ହେୱାନ୍‌ ବେରୁତ ଇ ମିଚ୍‌ ସାକି ହିଜ଼ି ଇଞ୍ଜେଙ୍ଗ୍‌ ଲାଗାତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“ଆପେଂ ଇୱାନ୍‌ ତାଙ୍ଗ୍‌ ଇ କାତା ଇନାକା ୱେଚାପ୍‌ନା, ‘ଆନ୍‌ ଇ କେଇଦାଂ ରଚ୍‌ଚି ମନ୍ଦିର୍‌ତିଂ ଡ୍ରିକ୍‌ଚି ତିନ୍‌ଦିନ୍‌ ବିତ୍ରେ’ ଆରି ରଞ୍ଜାଙ୍ଗ୍‌ କେଇଦାଂ ରଚ୍‍ୱିିତି ମନ୍ଦିର୍‌ ରଚ୍‌ନାଙ୍ଗ୍ ।” ");
INSERT INTO peg_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","ମାତର୍‌ ଇବେପା ହେୱାର୍‌ ସାକି ଗାଟାୱାତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","ହେବେ ମୁଡ଼୍‌ ମାପ୍ରୁ ହେବା କିନାକାନ୍‌ ମାଦି ନିଲ୍‌ଚି ଜିସୁଙ୍ଗ୍‌ ୱେନ୍‌ବାତାନ୍‌, ନି ବିରୁଦ୍‌ତ ଇୱାର୍‌ ସାକି ହିନାରା, “ଏନ୍‌ ଇନାକାପା ଉତର୍‌ ହିଉୟା ?” ");
INSERT INTO peg_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","ମାତର୍‌ ହେୱାନ୍‌ ଦୟା ଆତାନ୍‌ ଆରି ଇନାକାପା ଉତର୍‌ ହିୱାତାନ୍ । ମୁଡ଼୍‌ ମାପ୍ରୁ ହେବା କିନାକାନ୍‌ ଆରେ ରଗ ୱେନ୍‌ବାତାନ୍‌ ହେୱାନ୍‌ “ଏନ୍‌ ଇନାକା ମଙ୍ଗ୍‌ଲ୍‌ ପାୟାନି ଇସ୍ୱର୍‌ତି ମାଜ଼ି କ୍ରିସ୍ଟ ?” ");
INSERT INTO peg_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","ଜିସୁ ଇଚାନ୍‌, “ଆନ୍‌ ହେୱାନ୍‌,” ଆରି ଏପେଙ୍ଗ୍‌ “ଆନ୍‌ ଜେ ମାନାୟ୍‌ ମାଜ଼ିଙ୍ଗ୍‌ ସାକ୍ତିତାଂ ବୁଜ୍‌ଣି ବାଗାଙ୍ଗ୍‌ କୁଚ୍‌ନାକା ଆରି ଆକାସ୍‌ନି ବାଦାଡ଼୍‌ତ ୱାନାକା ହୁଡ଼୍‌ନାଦେର୍ !” ");
INSERT INTO peg_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","ହେବେ ତାଙ୍ଗ୍‌ ମୁଡ଼୍‌ ମାପ୍ରୁ ହେବା କିନାକାନ୍‌ ତା ହେନ୍ଦ୍ରା କେଚ୍‌ଚି ଇଚାନ୍‌, “ସାକିତାଂ ମାଦାଂ ଆରି ଇନାକା ଲଡ଼ା ! ");
INSERT INTO peg_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","ଏପେଙ୍ଗ୍‌ ତ ଇସ୍ୱର୍‌ତି ନିନ୍ଦା ୱେଚାଦେର୍‌, ମି ବିଚାର୍‌ କିନାକା ଇନାକା ?” ଇବେ ହେୱାର୍‌ ୱିଜ଼ାକାର୍‌ ହାକି ଦାଣ୍ଡ୍‌ ପାୟା ଆନି ବିଦି ମାନାତ୍‌ ଇଞ୍ଜି ୱିଜ଼ାକାର୍‌ ଇଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","ଆରେ ଇନେର୍‌ ଇନେର୍‌ ହେୱାନ୍‌ ଜପି ଚୁବ୍‌ଦେଂ ଲାଗାତାର୍‌ ଆରି ହେୱାନ୍‌ ମୁମ୍‌ଦ ଗୁଗୁର୍‌ ମୁଗି କିଜ଼ି ବିଦା ଇଡ଼୍‌ଜି ଇଞ୍ଜେଙ୍ଗ୍‌ ଲାଗାତାର୍‌, “ଏନ୍‌ କିନ୍ଦା ବେରଣ୍‌ ବାକ୍‌ଣାୟ୍‌ କିନାକାୟ୍‌ !” ପାର୍ମାଣ୍ ହିଦା । ଆରି ପାଦ୍‌ ଆଦିକାରିର୍‌ ଚାପ୍‌ଡ଼ା ଇଡ଼ୁ ଇଡ଼ୁ ହେୱାନିଂ ଆସ୍ତି ଅତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","ଆରି ପିତର୍‌ ତାରେନ୍‌ ହାକ୍‌ଡ଼ିତ ମାନିୱେଡାଲିଂ ମୁଡ଼୍‌ ମାପ୍ରୁ ହେବା କିନାକାର୍ତି ର ଆଡ଼ିଏଣି ୱାଜ଼ି ପିତର୍‌ ନାଣି କାଇନାକା ହୁୁଡୁତାତ୍, ");
INSERT INTO peg_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","ଆରି ପିତର୍‌ତିଂ ଇଟ୍‌କାଡ଼୍‌ କିଜ଼ି ଇଚାତ୍‌, “ଏନ୍‌ ପା ନାଜରିତିୟନି ଜିସୁ ହୁକେ ମାଚାୟ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","ମାତର୍‌ ହେୱାନ୍‌ ଉଡ଼ା ଆଜ଼ି ଇଚାନ୍‌, “ଆନ୍‌ ହେୱାନିଂ ପୁୁନୁଙ୍ଗ୍, ଆରି ଏନ୍‌ ଇନାକା ଇନାୟା, ଆନ୍‌ ବୁଜା ଆଉଙ୍ଗା ।” ପାଚେ ହାକ୍‌ଡ଼ି ଦୁୱେର୍‌ତାଂ ହସି ହାଚାନ୍‌; କୁଜ଼ୁ କ୍ଡେତାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","ଆରେ, ହେ ଆଡ଼ିଏଣି ହେୱାନିଂ ହୁଡ଼୍‌ଜି ଲାଗେ ନିଲ୍‌ଚି ମାନିଲୁଗାଂ ଆରି ରଗ ଇଞ୍ଜେଙ୍ଗ୍‌ ଲାଗାତାତ୍‌, “ଇୱାନ୍‌ ହେୱାର୍‌ ବିତ୍ରେ ରକାନ୍‌ !” ");
INSERT INTO peg_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","ମାତର୍‌ ଆରେ ପାର୍ତି କିୱାଦାଂ ଇଞ୍ଜେଙ୍ଗ୍‌ ଲାଗାତାନ୍‌ । ଆରେ ଅଲପ୍‍ ସମୁ ପାଚେ ଲାଗାଂ ନିଲ୍‌ଚି ମାନି ଲଗୁ ପିତର୍‌ତିଂ ଇଚାର୍‌, “ଏନ୍‌ ହାତ୍‌ପାନେ ହେୱାର୍‌ ବିତ୍ରେ ରକାୟ୍‌, ଇଚିସ୍‌ ଏନ୍‌ ତ ଗାଲିଲିୟ୍‌ ଲଗୁ ।” ");
INSERT INTO peg_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","“ମାତର୍‌ ପିତର୍‌ ନିଜେତିଙ୍ଗ୍‌ ରାଣ୍‌ କିଜ଼ି ଆରେ ପାର୍ମାଣ୍‌ କିଜ଼ି ଇଞ୍ଜେଙ୍ଗ୍‌ ଲାଗାତାନ୍‌, ଏପେଙ୍ଗ୍‌ ଇମ୍‌ଣି ମାନାୟ୍‌ କାତା ଇନାଦେରା, ଆନ୍‌ ହେୱାନିଂ ପୁନୁଙ୍ଗ୍‌ !” ");
INSERT INTO peg_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","ହେ ପାଦ୍‌ନା କୁଜ଼ୁ ରିହା କ୍ଡେତାତ୍‌, ଇବେତାଂ କୁଜ଼ୁ ରିହା କ୍ଡେନିହିଂ ଆଗେ ଏନ୍‌ “ନାଙ୍ଗେଙ୍ଗ୍‌ ତିନିହଟ୍‌ ପାର୍ତି କିଦୁୟ୍‌,” ଇ ଇମ୍‌ଣି କାତା ଜିସୁ ପିତର୍‌ତିଂ ଇଞ୍ଜି ମାଚାନ୍‌, ହେଦାଂ ପିତର୍‌ତିଂ ଏତୁ ୱାତାତ୍, ଆରି ହେୱାନ୍‌ ହେ କାତା ବାବିକିଜ଼ି ଆଡ଼୍‌ବେଦେଂ ଲାଗାତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","ଅଜଡ଼୍‌ ଆତି ଦାପ୍ରେ ସବୁ ଗାଜା ମିଟିଂ, ଇଚିସ୍‌ ପ୍ରାଚିନ୍‌ ଆରି ସାସ୍ତିର୍‌ତି ହୁକେ ମୁଡ଼୍‌ ମାପ୍ରୁହେବାକିନାକାର୍‌ ସବା କିଜ଼ି ଜିସୁଙ୍ଗ୍‌ ଗାଚ୍‌ଚି ଅଜ଼ି ପିଲାତ ତାକେ ହେଲାୟ୍‌ କିତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","ପିଲାତ ହେୱାନିଂ ୱେନ୍‌ବାତାନ୍‌, “ଏନ୍‌ କି ଜିହୁଦିର୍‌ ରାଜା ?” ଜିସୁ ହେୱାନିଂ ଉତର୍‌ ହିତାନ୍, “ଏନ୍‌ ଇନାୟା ।” ");
INSERT INTO peg_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","ଆରେ, ମୁଡ଼୍‌ ମାପ୍ରୁହେବାକିନାକାର୍‌ ଜିସୁ ବିରୁଦ୍‌ତ ବେଜେକ୍‌ ଲାଗେଦେଂ ହାଙ୍ଗ୍‍ତାର୍ । ");
INSERT INTO peg_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","ହେବେ ପିଲାତ ଆରେରଗ ହେୱାନିଂ ୱେନ୍‌ବାତାନ୍‌ “ଏନେଙ୍ଗ୍‌ ଇନାକା ଉତର୍‌ ହିଉୟା ? ହୁଡ଼ା, ଇୱାର୍‌ ନି ବିରତ୍‌ତ ଦସ୍‌ ବାଜେକ୍‌ କିସି ଲାଗ୍‍ଦାନାରା !” ");
INSERT INTO peg_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","ମାତର୍‌ ଜିସୁ ଇନାକା ପା ଉତର୍‌ ହିୱାତାନ୍, ହେଦାଂ କାଜିଂ ପିଲାତ କାବା ଆତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","ମତର୍‌ ନିସ୍ତାର୍‌ ପାର୍ବୁୱେଡ଼ାଙ୍ଗ୍ ମାନାୟାର୍‌ ଇମ୍‌ଣି ଚରେନ୍ତିଙ୍ଗ୍ ଏନ୍‌ଚି ମାଚାର୍‌, ହେୱାନିଂ ହେୱାନ୍‌ ହେୱାର୍‌ କାଜିଂ ମୁକ୍‌ଡ଼ାୟ୍‌ କିଜ଼ି ମାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","ଇମ୍‌ଣି କୁଟୁମ୍‌ ବିରୁଦ୍‌ତ ଗଡ଼୍‌ମେଲି ୱେଡ଼ାଲିଂ ମାନାୟ୍‌ତିଂ ଅଜ଼ି ମାଚାନ୍‌, ହେୱାର୍‌ ହୁକେ ବାରବା ତର୍‌ନି ରୱାନ୍‌ ବନ୍ଦି ମାଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","ଲାଗିଂ ଲକୁ ଜପି ହାଲ୍‌ଜି ଜାର୍‌ ରିତି ହୁଦାଂ କିନି କାଜିଂ ଗୱାରି କିଦେଙ୍ଗ୍‌ ଲାଗାତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","ହେବେତାଂ ପିଲାତ ହେୱାରିଂ ଉତର୍‌ ହିତାନ୍, “ଏପେଙ୍ଗ୍‌ ଇନାକା ଇଚା କିନାଦେରା ? ଆନ୍‌ ଇନାକା ମି କାଜିଂ ଜିହୁଦିର୍‌ ରାଜାଙ୍ଗ୍‌ ମୁକୁଡ଼ାୟ୍‍ କିନାଙ୍ଗ୍‌ ?” ");
INSERT INTO peg_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","ଇଚିସ୍‌ ମୁଡ଼୍‌ ମାପ୍ରୁହେବାକିନାକାର୍‌ ଜେ କୁଟ୍‍ତ ହେୱାନିଂ ହେଲାୟ୍‌ କିଜ଼ି ମାଚାର୍‌, ହେଦାଂ ହେୱାନ୍‌ ବୁଜା ଆତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","ମାତର୍‌ ହେୱାନ୍‌ ଇନେସ୍‌ ହେୱାର୍‌ କାଜିଂ ବାରବାଙ୍ଗ୍‌ ମୁୁକ୍‌ଡ଼ାୟ୍‍ କିନାନ୍‌, ହେଦାଂ କାଜିଂ ମୁଡ଼୍‌ ମାପ୍ରୁହେବାକିନାକାର୍‌ ଲକାଂ ମାତାୟ୍‍ କିତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","ମାତର୍‌ ପିଲାତ ଆରେ ରଗ ହେୱାରିଂ ଉତର୍‌ ହିତାନ୍‌, “ବାଟିଙ୍ଗ୍‌ ଏପେଙ୍ଗ୍‌ ଇନେରିଂ ଜିହୁଦିର୍‌ ରାଜା ଇଞ୍ଜି ଇନାଦେରା, ହେୱାନ୍‌ କାଜିଂ ଆନ୍‌ ଇନାକା କିନାଙ୍ଗ୍‌ ?” ");
INSERT INTO peg_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","ହେୱାର୍‌ ପାଚେ କିର କିଜ଼ି ଇଚାର୍‌, “ହେୱାନିଂ କ୍ରୁସ୍‌ତ ଦୁପାଟ୍‌ !” ");
INSERT INTO peg_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","ହେବେତାଂ ପିଲାତ ହେୱାରିଂ ୱେନ୍‍ବାତାନ୍, ଇନେକିଦେଂ, “ହେୱାନ୍‌ ଇନା ଦସ୍‌ କିତାନ୍‌ନ୍ନା ?” ମାତର୍‌ ହେୱାର୍‌ ଆଦିକ୍‌ କିର କିତାର୍‌, “ହେୱାନିଂ କ୍ରୁସ୍‌ତ ଦୁପାଟ୍‌ !” ");
INSERT INTO peg_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","ଲାଗିଂ ପିଲାତ ମାନାୟ୍‌ତିଂ ସାରି କିଦେଙ୍ଗ୍‌ ଇଚା କିଜ଼ି ହେୱାର୍‌ କାଜିଂ ବାରବାତିଂ ମୁକ୍‌ଡ଼ାୟ୍ କିତାନ୍‌, ପାଚେ ଜିସୁଙ୍ଗ୍‌ କର୍‌ଡା ଟ୍ରାକି କିସି କ୍ରୁସ୍‌ତ ଦୁପ୍‍ଦେଂ ଇଞ୍ଜି ହେଲାୟ୍‌ କିତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","ହେବେତାଂ ମେଲ୍ୟାର୍‌ ହେୱାନିଂ ହାକ୍‌ଡ଼ି, ଇଚିସ୍‌ ବାଙ୍ଗ୍‌ଲା ବିତ୍ରେ ଆସ୍‌ସି ପା ସବୁ ମେଲ୍ୟାରିଂ କୁକ୍‌ଚି ରୁଣ୍ଡାୟ୍‍ କିତାର୍ । ");
INSERT INTO peg_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","ହେୱାର୍‌ ହେୱାନିଂ କିଜାୟ୍‌ କିଦେଙ୍ଗ୍‌ ଇଞ୍ଜି କାହ୍‌ରାତି ବାନି ହେନ୍ଦ୍ରା ଉସ୍ପି କିତାର୍‌ ଆରି ୱାଡ଼ି ମୁକୁଟ୍‌ ରଚ୍‌ଚି କାପ୍‌ଡ଼ାତ ତୁଜ଼ି କିତାର୍‌; ");
INSERT INTO peg_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","ଆରେ, “ଏ ଜିହୁଦିର୍‌ ରାଜା !” ଜୱାର୍‌, ଇଦାଂ ଇଞ୍ଜି କିଜାୟ୍‌ କିଦେଙ୍ଗ୍‌ ଲାଗାତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","ପାଚେ, ହେୱାର୍‌ ର ପଲ୍‍କା ନାଡ଼ା ଅସି କାପ୍‌ଡ଼ାତ ମାଟ୍‌ କିତାର୍‌ ଆରି ହେୱାନ୍‌ ଜପି ଚୁପ୍‌ତାର୍‌, କିଜାୟ୍‌ କିଜ଼ି ଆରି ମେଣ୍ଡାଂ କୁନ୍ଦିକିଜ଼ି ଜୱାର୍‌ କିଦେଙ୍ଗ୍‌ ଲାଗାତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","ହେୱାର୍‌ ହେୱାନିଂ କିଜାୟ୍‍କିତି ପାଚେ ହେ କାର୍ହାତି ବାନି ହେନ୍ଦ୍ରା କୁତ୍‍ତି ଅଜ଼ି ହେୱାନ୍ତି ଜାର୍‌ ହେନ୍ଦ୍ରା ଉସ୍ପି କିତାର୍‌ । ପାଚେ, ହେୱାର୍‌ ହେୱାନିଂ କ୍ରୁସ୍‌ ଜପି ଦୁପ୍‌ତେଂ ବାର୍ତ ଅତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","ହେ ଏଚେକାଡ଼୍‌ଦ ଆଲେକ୍‌ଜାଣ୍ଡର୍‌ ଆରି ରୁପ୍‌ତି ଲାତ୍ରାହି ସିମନ୍‌ ତର୍‌ନି ରକାନ୍‌ କୁରିଣିୟ ମାନାୟ୍‌ ଦେସିନାସ୍‍ତାଂ ୱାଜ଼ି ହେ ହାଜ଼ିହିଜ଼ି ହାଲ୍‍ଜି ମାଚାନ୍, ହେୱାର୍‌ ହେୱାନିଂ ହେୱାନ୍ତି କ୍ରୁସ୍‌ ପିଣ୍ଡ୍‌ଦେଂ ବଲତ୍କାର୍ କିତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","ଆରେ, ହେୱାର୍‌ ହେୱାନିଂ ଗଲ୍‌ଗତା ଇଚିସ୍‌ “କାପ୍‍ଡ଼ାବାହା ତର୍‌ ବାହାତ ଅତାର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","ଆରେ, ହେୱାର୍‌ ହେୱାନିଂ ଗାନ୍ଦାରାସ୍‌ ମିହାଆତାକା ଅଙ୍ଗୁର୍‌ ରାସ୍‌ ହିତାର୍‌, ମାତର୍‌ ହେୱାନ୍‌ ହେଦାଂ ଅଦେଂ କାୱାତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","ପାଚେ ହେୱାର୍‌ ହେୱାନିଂ କ୍ରୁସ୍‌ତ ଦୁପ୍‌ତାର୍‌, ଆରେ ଇନେର୍‌ ଇନାକା ଗାଟାଆନାନ୍, ହେଦାଂ ଦରମ୍‌ଗୁଲି ହୁକେ ତିର୍‌ କିଜ଼ି ହେୱାନ୍ତି ହେନ୍ଦ୍ରା ସବୁ ଜାର୍‌ ଜାର୍‌ତାକେ ପାସ୍‍ପିସ୍ ଅତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","ଦିନ୍‌ ନଅଟା ୱେଡ଼ାଲିଂ ହେୱାର୍‌ ହେୱାନିଂ କ୍ରୁସ୍‌ତ ଦୁପ୍‌ତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","ଆରେ ହେୱାନ୍ତି ତା ବିରୁଦ୍‌ତ ଇଦାଂ ଲେକା ଆଜ଼ି ମାଚାତ୍‌, “ଜିହୁଦିର୍ତି ରାଜା ।” ");
INSERT INTO peg_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","ଆରେ, ହେୱାନ୍ତି ବୁଜ୍‌ଣି ପାଡ଼୍‍କା ରକାନ୍‌ ଆରି ଡେବ୍ରି ପାଡ଼୍‍କା ରକାନିଂ, ଏଲେଙ୍ଗ୍‌ ରିକାର୍ ଚର୍କୁକାଂ ହେୱାର୍‌ ଜିସୁ ହୁକେ କ୍ରୁସ୍‌ ତାକେ ଦୁପ୍‌ତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","ହେବେ ଦରମ୍‌ ସାସ୍ତର୍‌ ଇ କାତା ପୁରାଆତାତ୍, ହେୱାନ୍‌ ଚର୍କୁ ହୁକେ ସମାନ୍‌ ଆତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","“ହେ ହାଜ଼ି ହିଜ଼ି ହାଲ୍‍ଜିମାନି ଲକୁ ଜାର୍‌ ଜାର୍‌ କାପ୍‌ଡ଼ା ଜଲାୟ୍ କିଜ଼ି ହେୱାନିଂ ନିନ୍ଦା କିଦେଙ୍ଗ୍‌ ଲାଗାତାର୍‌, ଆରେ ର ମନ୍ଦିର୍‌ ଡ୍ରିକ୍‌ନି ଲଗୁ ଆରି ତିନି ଦିନ୍‌ତାଂ ଆରେ ରଚ୍‍ନାକାୟ୍‌ !” ");
INSERT INTO peg_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","କ୍ରୁସ୍‌ତାଂ ଜୁଦା ଜାର୍‌ତିଂ ରାକ୍ୟା କିୟା । ");
INSERT INTO peg_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","ମୁଡ଼୍‌ ମାପ୍ରୁହେବାକିନାକାର୍‌ ପା ହେ ଲାକେ ସାସ୍ତିର୍‌ ହୁକେ ହେୱାର୍‌ ହେୱାର୍‌ ବିତ୍ରେ ହେୱାନିଂ ଗ୍ଡାଇଜି ଇଞ୍ଜେଙ୍ଗ୍‌ ଲାଗାତାର୍‌, “ହେୱାନ୍‌ ବିନ୍‍ଲୁଗାଂ ରାକ୍ୟାକିତାନ୍ ଜାର୍‌ତିଂ ରାକ୍ୟା କିଦେଙ୍ଗ୍‌ ଆଡୁନା ! ");
INSERT INTO peg_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","ଏନ୍‌ ଜଦି ହାତ୍‌ପା ଇସ୍ରାଏଲ୍‌ନି ରାଜା କ୍ରିସ୍ଟ ବେଗି କ୍ରୁସ୍‌ ତାଙ୍ଗ୍‌ ଜୁଜ଼ି ୱାୟେନ୍‌, ଇନେସ୍‌କି ହେଦାଂ ହୁଡ଼୍‌ଜି ଆପେଂ ପାର୍ତି କିନାପ୍‌ । ଆରେ ଇନେର୍‌ ତା ହୁକେ କ୍ରୁସ୍‌ତ ଦୁପ୍‌ୟା ଆଜ଼ି ମାଚାର୍‌, ହେୱାର୍‌ ପା ତାଙ୍ଗେଙ୍ଗ୍‌ ନିନ୍ଦାକିଦେଂ ଲାଗାତାର୍‌ !” ");
INSERT INTO peg_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","ବାର ଗଣ୍ଟା ୱେଡ଼ାଲିଂ ଦେସ୍‌ ଜାକ୍‌ ମାଜ୍‌ଗା ଆଜ଼ି ତିନି ଗଣ୍ଟା ପାତେକ୍‌ ମାଚାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","ତିନି ଗଣ୍ଟା ୱେଡ଼ାଲିଂ ଜିସୁ ଗାଜାକାଟ୍‌ତାଂ କୁକ୍‌ଚି ଇଚାନ୍‌, “ଏଲି, ଏଲି, ଲାମା ସାବାକ୍‍ତାନି ?” ଇଚିସ୍‌ “ଏ ନା ଇସ୍ୱର୍‌, ଏ ନା ଇସ୍ୱର୍‌, ଏନ୍‌ ନାଙ୍ଗେଙ୍ଗ୍‌ ଇନାକିଦେଂ ପିସ୍ତାତାୟ୍ ?” ");
INSERT INTO peg_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","ଇଦାଂ ୱେନ୍‌ଞ୍ଜି ଲାଗାଂ ନିଲ୍‍ତି ମାନାୟାର୍‌ ବିତ୍ରେ ଇନେର୍‌ ଇନେର୍‌ ଇଚାର୍‌, ହୁଡ଼ାଟ୍‌, “ହେୱାନ୍‌ ଏଲିୟଙ୍ଗ୍‌ କୁକ୍‍ନାନା !” ");
INSERT INTO peg_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","ଆରେ, ରକାନ୍‌ ହନ୍‍ଚିହାଲ୍‍ଜି ର ରୁଆ ତ କେନିରାସ୍‌ ବାର୍ତି କିଜ଼ି ହେଦାଂ ର ନାଡ଼ାତ କିଜ଼ି ହେୱାନିଂ ଉଣ୍ଡେଙ୍ଗ୍‌ ହିଜ଼ି ଇଚାନ୍‌, “ମାନାଟ୍‌, ଏଲିୟ ଇୱାନିଂ ଜୁତ୍‍ତେଂ ୱାନାନା କି ଆକାୟ୍‌, ହୁଡ଼୍‌ନାସ୍‌ !” ");
INSERT INTO peg_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","ମାତର୍‌ ଜିସୁ ଗାଜାକାଟ୍‌ କିଜ଼ି ପାରାଣ୍‌ ପିସ୍ତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","ଆରେ, ମନ୍ଦିର୍‌ନି ପୁଇପୁୟା ବାହାତ ଟଣ୍‌ତି ହେନ୍ଦ୍ରା ଜପିତାଂ ତାରେନ୍‌ ପାତେକ୍‌ ରି ପାଡ଼ା ଆଜ଼ି କେନ୍‍ଚାତ୍ । ");
INSERT INTO peg_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","ହେୱାର୍‌ ମୁମ୍‌ଦ ନିଲ୍‍ଚିମାଚି ପାଞ୍ଚ୍‌କଡ଼ି ମେଲ୍ୟାର୍‌ ଆଦିକାରି ହେୱାନ୍ତି ପାରାଣ୍‌ ପିହ୍‌ନାକା ହୁଡ଼୍‌ଜି ଇଚାର୍‌, “ହାତ୍‌ପାନେ, ଇୱାନ୍‌ ରକାନ୍‌ ଇସ୍ୱର୍‌ ମାଜ଼ି !” ମାଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","କେତେକ୍‌ ଜାଣ୍‌ କଗ୍‌ଲେହିମ୍‌ଣାଂ ପା ଦେହାତାଂ ହୁଡ଼୍‌ଜି ମାଚିକ୍‌; ହେୱେକ୍‌ ବିତ୍ରେ ମଗ୍‌ଦଲିନି ମରିୟମ୍‌, ହାରୁ ଜାକୁବ୍‌ ଆରି ଜସି ତେହି ମରିୟମ୍‌, ଆରେ ସଲମି ମାଚିକ୍‌; ");
INSERT INTO peg_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","ହେୱାନ୍‌ ଗାଲିଲିତ ମାନି ୱେଡ଼ାଲିଂ ହେୱେକ୍‌ ତା ପାଚେ ପାଚେ ହାଲ୍‌ଜି ହେୱାନିଂ ହେବା କିଜ଼ି ମାଚିକ୍‌, ହେୱେକ୍‌ ହୁକେ ଜିରୁସାଲମ୍‌ତ ୱାଜ଼ିମାନି କଗ୍‌ଲେକ୍‌ ପା ହୁଡ଼୍‌ଜି ମାଚିକ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","ୱେଡ଼ା ଆତିଲେ, ହେ ଦିନ୍‌ ଜୁତିପାତି କିନି ଦିନ୍‌, ଇଚିସ୍‌ ଜମ୍‌ନିବାର୍‌ ଆଗେନି ଦିନ୍‌ ମାଚିଲେ, ");
INSERT INTO peg_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","ହାରାମାତିୟାର୍‌ନି ଜସେପ୍‌ ତର୍‌ନି ଜିହୁଦି ଗାଜା ସବାନି ରକାନ୍‌ ମାଜାନ୍‌ ମେମର୍‌, ଇନେନ୍‌ ନିଜେପା ଇସ୍ୱର୍‌ତି ରାଜିତିଂ କାସି ମାଚାନ୍‌, ହେୱାନ୍‌ ସାସ୍‍ତାଙ୍ଗ୍ ପିଲାତ ତାକେ ହାଲ୍‌ଜି ଜିସୁତି ଗାଗାଡ଼୍‌ ଏନ୍ତାନ୍ । ");
INSERT INTO peg_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","ମାତର୍‌ ଜେ ହାତାନେ ଇଦାଂ ୱେନ୍‌ଞ୍ଜି ପିଲାତ କାବା ଆତାନ୍‌, ଆରି ପାଞ୍ଚ୍‌ କଡ଼ିନି ମେଲ୍ୟାର୍‌ ଆଦିକାରିଂ ଲାଗେ କୁକି କିଜ଼ି ହେୱାନିଂ ୱେନ୍‌ବାତାନ୍‌, ହେୱାନ୍‌ ଇନାକା ବେସିଗାଡ଼ି ହାଜ଼ି ଆତାତେ ? ");
INSERT INTO peg_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","ପାଞ୍ଚ୍‌ କଡ଼ିନି ମେଲ୍ୟାର୍‌ ଆଦିକାର୍‌ ତାଙ୍ଗ୍‌ ପୁନ୍‌ଞ୍ଜି ଜିସୁ ଗାଗାଡ଼୍‌ତିଂ ଜସେପ୍‌ତିଂ ହିତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","ହେୱାନ୍‌ ରଞ୍ଜାଙ୍ଗ୍‍ କୱାଣ୍‌ ହେନ୍ଦ୍ରା କଡ଼୍‌ଜି ତାଙ୍ଗେଙ୍ଗ୍‌ ଜୁତ୍‌ତି ତାସି ହେବେ ହେୱାନିଂ ହୁର୍ପାତାନ୍ ଆରି କାଲ୍‌ ରେଟି ମାଡ଼ିତ କାର୍‌ତି ର ଦୁଗେର୍‌ତ ହେୱାନିଂ ଇଡ଼୍‌ଜି ଦୁଗେର୍‌ନି ଦୁୱେର୍‌ତ ଗାଜା କାଲ୍‌ ଗ୍ରୁତ୍‌ତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","ହେୱାନିଂ ଇମ୍‌ଣି ବାହାତ ଇଡ଼ିତାର୍‌ନା, ହେଦାଂ ମଗ୍‌ଦଲିନି ମରିୟମ୍‌ ଆରି ଜସି ତେହି ମରିୟମ୍‌ ହୁଡ଼୍‌ଜି ମାଚିକ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","ଜମ୍‌ନିବାର୍‌ ହାଚିପାଚେ ମଗ୍‌ଦଲିନି ମରିୟମ୍‌ ଜାକୁବ୍‌ ତେହି ମରିୟମ୍‌ ଆରି ସଲମି ବାସ୍‌ନା ଚିକାଣ୍‌ କଡ଼୍‍ତିକ୍, ଇନେସ୍‌କି ହେୱାନିଂ ହାଲ୍‌ଜି ଉଚି କିଦେଙ୍ଗ୍‌ ଆଡ୍‌ନିକ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","ଆରେ, ରଇବାର୍‌ ନାଜିଂ ଉଟ୍‌ଲା ହାକାଡ଼େ ହେୱେକ୍‌ ଦୁଗେର୍‌ତ ହାଚିକ୍‌, ହେପାଦ୍‌ନା ୱେଡ଼ା ହସି ମାଚାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","ହେୱେକ୍‌ ହେୱେକ୍‌ ବିତ୍ରେ ବେଣ୍‌ କିିବିସ୍‍ ମାଚିକ୍‌, ଇନେର୍‌ ମା କାଜିଂ ଦୁଗେର୍‌ନି ଦୁୱେର୍‌ କାଲ୍‌ ଗ୍ରୁତ୍‌ତି ହିଦ୍‍ନାର୍ ? ଇନାକିଦେଂକି ହେଦାଂ ବେସି ଗାଜା କାଲ୍ ମାଚାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","ଇ ଲାକେ ୱେଡ଼ାଲିଂ ହେୱେକ୍‌ ଏରି କିଜ଼ି ହୁଡ଼୍‌ତିକ୍ ଜେ, କାଲ୍‌ ଗ୍ରୁତ୍‍ତାକା । ");
INSERT INTO peg_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","ହେୱେକ୍‌ ଦୁଗେର୍‌ ବିତ୍ରେ ହଣ୍‌ଜି ଡ଼ିଞ୍ଜିନି ଆଙ୍ଗି ଉସ୍‍ପାତାକାନିଂ ର ଦାଙ୍ଗ୍‌ଣାହିମ୍‌ଣା ବୁଜ୍‍ଣିବାଗାଂ କୁଚ୍‌ଚାକା ହୁଡ଼୍‌ଜି ବେସିକାବା ଆତିକ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","“ହେବେ ହେୱାନ୍‌ ହେୱାକାଂ ଇଚାନ୍‌,” କାବା ଆମାଟ୍‌, ଏପେଙ୍ଗ୍‌ କ୍ରୁସ୍‌ତ ହାତି ନାଜରିତିୟନି ଜିସୁଙ୍ଗ୍‌ ଡେକ୍‌ନାଦେରା; ହେୱାନ୍‌ ନିଙ୍ଗ୍‌ତାନ୍ନା, ହେୱାନ୍‌ ଇବେ ହିଲୁନ୍, ହୁଡ଼ାଟ୍‌, ଇ ବାହାତ ହେୱାର୍‌ ହେୱାନିଂ ଇଡ଼୍‌ଜି ମାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","ମାତର୍‌ ଏପେଙ୍ଗ୍‌ ହାଲ୍‌ଜି ହେୱାନ୍‌ ଚେଲାରିଂ ଆରି ପିତର୍‌ତିଂ ବଲ୍‌ ହିତାନ୍‌, ଜିସୁ ମି ଆଗେ ଗାଲିଲିତ ହାଚାନ୍‍ନା; ହେୱାନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ଇନେସ୍‌ ଇଞ୍ଜି ମାନ୍‍ଞ୍ଚାନ୍, ହେ ଲାକେ ଏପେଙ୍ଗ୍‌ ହେବେ ହେୱାନିଂ ହୁଡ଼୍‌ନାଦେର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","ହେବେଣ୍ଡାଂ ହେୱେକ୍‌ ହାତ୍‌ପା ହୁଡ଼୍‌ଜି ଦୁଗେର୍‌ ତାଙ୍ଗ୍‌ ହସି ହନ୍ତିକ୍‍, ଇନେସ୍‌ ଲାକେ କି ହେୱେକ୍‌ ପାଡ୍ରୁତିଙ୍ଗ୍ ତ୍ରିଗ୍‌ଜି ମାଚିକ୍‌ ଆରି କାବା ଆଜ଼ି ମାଚିକ୍‌, ଆରେ ଇନେରିଂ ଇନାକା ଇନ୍‍ୱିତିକ୍, ଇନେକିଦେଂକି ହେୱେକ୍‌ ପାଣ୍ଡ୍ରା ଆଜ଼ି ମାଚିକ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","ସାତ୍‌ ଦିନ୍‌ନି ପର୍ତୁମ୍‌ ରଇବାର୍‌ ନାଜିଂ ଉଟ୍‌ଲା ହାକାଡ଼େ ଜିସୁ ନିଙ୍ଗ୍‌ଜି, ଇନେର୍‌ତାଂ ସାତ୍‍ ପୁଦାଂ ପିହି କିଜ଼ି ମାଚାନ୍‌, ହେ ମଗ୍‌ଦଲିନି ମରିୟମ୍‌ତିଂ ପର୍ତୁମ୍‌ ଚଞ୍ଜ୍‌ୟା ଆତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","ହେଦେଲ୍‌ ହାଲ୍‌ଜି, ଇନେର୍‌କି ତା ହାଙ୍ଗ୍‌ ଆସି ମାଚିକ୍‌, ହେୱେକାଂ କାବୁର୍‌ ହିତାତ୍, ହେୱେକ୍‌ ଦୁକ୍‌ ଆରି ଆଡ଼୍‌ବିସ୍‌ ମାଚିକ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","ହେୱାନ୍‌ ଜିବୁନ୍‌ ମାନାନ୍‌ ଆରି ହେଦେଲିଂ ଚଞ୍ଜିୟାଆତାନ୍ନା, ଇଦାଂ ୱେନ୍‌ଞ୍ଜି ହେୱାର୍‌ ପାର୍ତି କିୱାତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","ଇ ସବୁ ଗଟ୍‌ଣା ପାଚେ ହେୱାର୍‌ ବିତ୍ରେ ରିକାର୍‌ ର ନାସ୍‌ତ ହାଲ୍‍ଜିମାନି ୱେଡ଼ାଲିଂ ହେୱାନ୍‌ ଆରି ବିନ୍‍ମୁର୍ତିତ ହେୱାରିଂ ଚଞ୍ଜ୍ୟା ଆତାନ୍‌, ");
INSERT INTO peg_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","ଆରେ ହେୱେକ୍‌ ହାଲ୍‌ଜି ବିନ୍‍ଲୁଗାଂ କାବୁର୍‌ ହିତିକ୍, ମାତର୍‌ ହେୱେକ୍‌ କାତା ପା ପାର୍ତି କିୱାତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","ଇଦାଂ ପାଚେ ଏଗାର୍ ଜାଣ୍‌ ଚେଲାର୍‌ ଚିଞ୍ଜେଙ୍ଗ୍‌ କୁଚ୍‌ଚି ୱେଡ଼ାଲିଂ ଜିସୁ ହେୱାରିଂ ଚଞ୍ଜ୍ୟା ଆତାନ୍‌ ଆରି ହେୱାର୍‌ତି ପାର୍ତି କିୱାକା ଆରି ମାନ୍‌ ଆଟ୍‌ୱା କାଜିଂ ହେୱାରିଂ ଲେତ୍‍ତାନ୍, ମାତର୍‌ ଇନେର୍‌ ହେୱାନିଂ ଆରି ନିଙ୍ଗ୍‌ନାକା ହୁଡ଼୍‌ଜି ମାଚାର୍‌, ହେୱାର୍‌ କାତା ୱିଜ଼ାକାର୍‌ ପାର୍ତି କିୱାଦାଂ ମାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","ଆରେ, “ଜିସୁ ହେୱାରିଂ ଇଚାନ୍‌, ଏପେଙ୍ଗ୍‌ ୱିଜ଼ୁ ପୁର୍ତିତ ହାଲ୍‌ଜି ସବୁ ନାର୍‌ ଜାତି ତାକେ ନେକ୍ରିକାବୁର୍‌ ସୁଣାୟ୍‌ କିୟାଟ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","ଇନେର୍‌ ପାର୍ତି କିଜ଼ି ବାପ୍ତିସିମ୍‌ ଅତିସ୍‌ ହେୱାନ୍‌ ରାକ୍ୟା ପାୟା ଆନାନ୍‌; ଆରେ ଇନେର୍‌ ପାର୍ତି କିଉର୍‌, ହେୱାର୍‌ ଦାଣ୍ଡ୍‌ ପାୟା ଆନାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","ଆରେ, ପାର୍ତି କିନାକାର୍‍ତି ଇ ସବୁ ଚିନ୍‌ ପାୟା ଆନାନ୍‌, ହେୱାର୍‌ ନା ତର୍‌ଦ ପୁଦାଂ ପିହିକିନାର୍, ପୁନି ପୁନି ବେରଣ୍‌ତ କାତା ଇନାର୍‌, ");
INSERT INTO peg_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","କେଇଦ ରାଚ୍‌ ଆହ୍‌ନାର୍‌, ଆରେ ପାରାଣ୍‍ନାସ୍ ଅହ ଉଟିସ୍ ହେୱାର୍‌ତି ଇନାକା ନସ୍ଟ ଆଉତ୍‌, ହେୱାର୍‌ ବେମାରିର୍ ଜପି କେଇ ଇଟ୍‌ତିସ୍‌ ହେୱାର୍‌ ଉଜ୍‌ ଆନାର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","ଇ ଲାକେ ମାପ୍ରୁ ଜିସୁ ହେୱାରିଂ କାତା ଇଚି ପାଚେ ସାର୍ଗେ ତାକେ ଅୟା ଆଜ଼ି ଇସ୍ୱର୍‌ତି ବୁଜ୍‌ଣି କଚଣ୍‌ତ କୁଚ୍‌ଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","ମାତର୍‌ ହେୱାର୍‌ ହାଲ୍‌ଜି ୱିଜ଼ୁ ତାକେ ପର୍‌ଚାର୍‌ କିତାର୍‌, ଆରି ମାପ୍ରୁ ହେୱାରିଂ ହାଙ୍ଗ୍‍ଦାଂ ଅସି ଚିନ୍‌କୁତାଂ ହେ କାତା ପାର୍ମାଣ୍‌ ସିଗ୍‌ କିତାନ୍‌ ।");
INSERT INTO peg_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","ଏ ତିଓପିଲସ୍‌, ଇମ୍‌ଣାକାର୍‌ ମା ବିତ୍ରେ କିଜ଼ି ମାଚି ଗଟ୍‌ଣାଂ ୱିଜ଼ୁ ବେସି ବିସ୍ରେ ରିତି ହୁକେ ଲେକିକିଦେଂ ମାନ୍‌ କିତାର୍‌, ");
INSERT INTO peg_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","ଆରମ୍‌ତାଂ ଇ ସବୁ ଗଟ୍‌ନା ହୁଡ଼୍‌ଜି ମାନି ମାନାୟାର୍‌ ଇନେସ୍‌ ହାର୍ଦି ନେକ୍ରିକାବୁର୍‌ ସୁଣାୟ୍‌କିନି ହେବାକାର୍‌ୟା ଆଡ, ହେ ଇସାବ୍ରେ ବାକି ବିସ୍ରେନିକିଂ ଲେକାତାତ୍‌ନ୍ନା । ");
INSERT INTO peg_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","ଲାଗିଂ, ହେ ମାନିନି ତିୟପିଲ୍‌, ଆରମ୍‌ତାଂ ୱିଜ଼ୁ ବିସ୍ରେ ସମାନ୍‌ ବାବ୍ରେ ଦାସ୍ତି ହେବେନି ଆରମ୍‌ତାଂ ହାରିହାରାନି କାତା ମି କାଜିଂ ଲେକିକିଦେଂ ଆନ୍‌ ପା ମାନେ କିତାଂ, ");
INSERT INTO peg_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","ଇନେସ୍‌କି ଏନ୍‌ ଇମ୍‌ଣି ୱିଜ଼ୁ ହିକ୍ୟା ପାୟା ଆତାୟ୍‌ନା, ହେ ସବୁ ବିସ୍ରେ ବୁଦି ଆର୍ଜା ଆନାୟ୍‌, ");
INSERT INTO peg_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","ଜିହୁଦା ଦେସ୍‌ନି ରାଜା ହେରଦ୍‌ତି ୱାଡ଼ାଙ୍ଗ୍‌ “ଅବିୟତି ମାପ୍ରୁହେବାକିନାକାନ୍‌ ଦଲ୍‌ନି ଜିକରିୟ ଇନି ରକାନ୍‌ ମାପ୍ରୁହେବାକିନାକାନ୍‌ ମାଚାନ୍‌; ହେ କଗ୍‌ଲେ ହାରଣ୍‌ ଲାତ୍ରାନିକା ମାଚାତ୍‌, ହେଦେଲ୍‌ତି ତର୍‌ ଏଲିସାବେତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","ହେୱାର୍‌ ରିକାର୍‌ ମାପ୍ରୁତି ୱିଜ଼ୁ ବଲ୍‌ ଆରି ବିଦି ହୁକେ କାମାୟ୍‌ କିଜ଼ି ଦସି ଆୱାଦାଂ ବେବାର୍‌ କିଜ଼ି ଇସ୍ୱର୍‌ ମୁମ୍‌ଦ ଦାର୍ମି ମାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","ମାତର୍‌ ହେୱାର୍‌ତି ହିମ୍‌ଣାୱାକ୍ଡ଼ା ହିଲ୍‌ୱାତାର୍‌, ଇନାକିଦେଂକି ଏଲିସାବେତ୍‌ ବାଞ୍ଜ୍‌ଣି ମାଚାତ୍‌, ହେୱାର୍‌ ଦସି ମାଚାର୍‌ ତାତାକେ ହିମ୍‌ଣା ୱାକ୍‌ଡ଼ା ହିଲ୍‌ୱାତାର୍‌ ହେୱାର୍‌ ବୟ୍‌ସ୍‌ ଆଦିକ୍‌ ଆଜ଼ି ମାଚାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","ହେୱାନ୍‌ ହେ କୁଦାନି ପାଲିହୁକେ ଇସ୍ୱର୍‌ ଲାଗାଂ ମନ୍ଦିର୍‌ତ ମାପ୍ରୁତି ମାପ୍ରୁହେବାକିନାକାନ୍‌ କାମାୟ୍‌ କିନି ୱେଡ଼ାଲିଂ, ");
INSERT INTO peg_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","ମାପ୍ରୁହେବାକିନାକାନ୍‌ କାମାୟ୍‌ନି ରିତି ହୁକେ ଦରମ୍‌ଗୁଲି ହୁଦାଂ ତା ମାପ୍ରୁ ମନ୍ଦିର୍‌ତ ହଣ୍‌ଜିପା ଦୁପ୍‌ନି ହିଦେଂ ପଡ଼ାତାତ୍‌, ");
INSERT INTO peg_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","ଆରେ ଦୁପ୍‌ନି ହିନି ୱେଡ଼ାଲିଂ ୱିଜ଼ାକାର୍‌ ବାର୍ତ ମାନ୍‌ଞ୍ଜି ପାର୍ତାନା କିଜ଼ି ମାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","ହେ ୱେଡ଼ାଲିଂ ମାପ୍ରୁତି ର ଦୁତ୍‌ ଦୁପ୍‌ନି ଗାର୍‌ଣିନି ତିନି ପାଡ଼୍‍କାତ ନିଲ୍‌ଚି ହେୱାନିଂ ଚଞ୍ଜ୍ୟା ଆତାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","ଜିକରିୟ ହେୱାନିଂ ହୁଡ଼୍‌ଜି କାବା ଆତାନ୍‌ ଆରି ପାଣ୍ଡ୍ରା ଆତାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","ମାତର୍‌ ଦୁତ୍‌ ହେୱାନିଂ ଇଚାତ୍‌, “ଜିକରିୟ, ପାଣ୍ଡ୍ରା ଆମା, ଇନାକିଦେଂକି ନି ପାର୍ତାନା କିନାକା ୱେଚାପ୍‌ନ୍ନା, ଆରି ନି କଗ୍‌ଲେ ଏଲିସାବେତ୍‌ ମି କାଜିଂ ର କାଡ଼୍‌ଦେ ଗାଟାଆନାତ୍‌, ଆରେ ଏପେଙ୍ଗ୍‌ ହେ ତର୍‌ ଜହନ୍‌ ହିନାଦେର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","ହେୱାନ୍‌ ମି ୱାରି ଆରି ଉପାସ୍‌ ଆନାନ୍‌, ଆରେ ଆଦିକ୍‌ ମାନାୟ୍‌ ତା ଜଲମ୍‌ତ କିତିତାକେ ୱାରି କିତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","ଲାଗିଂ ହେୱାନ୍‌ ମାପ୍ରୁତି ଲାଗେ ଗାଜା ଆନାନ୍‌; ହେୱାନ୍‌ ଅଙ୍ଗୁର୍‌ ରାସ୍‌ କି କାଲିଂ ଇନାୱାଡ଼ାଂପା ଉଣୁନ୍‌, ଆରେ ଆୟା ପଟତାଂ ପୁଇପୁୟା ଜିବୁନ୍‌ତ ପୁରା ଆନାନ୍‌, ");
INSERT INTO peg_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","ଆରେ ହେୱାନ୍‌ ଇସ୍ରାଏଲ୍‌ ହିମ୍‌ଣାୱାକ୍‌ଡ଼ାକାଂ ପା ଆଦେକ୍‌ତିଂ ମାପ୍ରୁ ହେୱାରିଂ ଇସ୍ୱର୍‌ ନିପ ଲେଉଟାୟ୍‍ କିନାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","ଆବାର୍‌ତି ମାନ୍‌ ହିମ୍‌ଣାଂ କାଜିଂ ଆରି ଅବୁଜା ଲଗାଂ ଦାର୍ମିଲଗାଂ ଗିଆନ୍‌ତାଂ ବେବାର୍‌ କିନି କାଜିଂ ତାହିୱାଦେଂ ଆରି ମାପ୍ରୁ କାଜିଂ ଜାଲ୍‌ଦିନି ର ଲକୁ ମଣ୍ଡ୍‌ଲି ଜାଲ୍‌ଦିନି କିଦେଙ୍ଗ୍‌ ହେୱାନ୍‌ ଏଲିୟଙ୍ଗ୍‌ ଜିବୁନ୍‌ ଆରି ସାକ୍ତିତାଂ ହେୱାନ୍‌ ଆଗେ ହାନାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","ଇବେଣ୍ଡାଂ ଜିକରିୟ ଦୁତ୍‌ତିଂ ଇଚାନ୍‌, “ଆନ୍‌ ଇମ୍‌ଣି ଚିନ୍‌ ଲାହାଙ୍ଗ୍‌ ଇଦାଂ ପୁନାଙ୍ଗ୍‌ ? ଇନାକିଦେଂକି ଆନ୍‌ତ ବୁଡ଼୍‌ହି, ଆରେ ନା ୱାଣିପା ଜବର୍‌ ବାର୍ହୁ ଆତାତେ ।” ");
INSERT INTO peg_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","“ଦୁତ୍‌ ହେୱାନିଂ ଉତର୍‌ ହିତାନ୍‌, ଆନ୍‌ ଗାବ୍ରିଏଲ୍‌, ଇମ୍‌ଣି ଇସ୍ୱର୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ଇ ନେକ୍ରିକାବୁର୍‌ ୱେଚ୍‍ଚିନି କାଜିଂ ନାଙ୍ଗ୍‌ ପକ୍ୟାତାଂନା, ଆନ୍‌ ତା ମୁମ୍‌ଦ ନିଲ୍‌ଚି ମାନାଙ୍ଗ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","ହୁଡ଼ାଟ୍‌, ଇ ୱିଜ଼ୁ ଗିଟାୱିଦିନ୍‌ ପାତେକ୍‌ ଏପେଙ୍ଗ୍‌ ଗୁଲା ଲାକେ ବେଣ୍‌କିଦେଂ ଆଡୁଦେର୍‌, ଇନାକିଦେଂକି ନାଦାଂ ସବୁ ବଚନ୍‌ ସମାନ୍‌ ସମୁତ ପୁରା ଆନାତ୍‌, ହେ ୱିଜ଼ୁ ଏପେଙ୍ଗ୍‌ ପାର୍ତି କିୱାତାଦେର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","ଇବେତାଂ ମାନାୟାର୍‌ ଜିକରିୟଙ୍ଗ୍‌ କାସି ମାଚାର୍‌, ଆରେ ମନ୍ଦିର୍‌ତ ହେୱାନ୍ତି ମାଲା ଆତିଲେ ହେୱାର୍‌ କାବା ଆଜ଼ି ମାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","ମାତର୍‌ ହେୱାନ୍‌ ହସି ୱାଜ଼ି ହେୱାରିଂ ବେଣ୍‌ ଇଞ୍ଜେଙ୍ଗ୍‌ ଆଡ୍‌ୱାତାନ୍‌; ଇବେଣ୍ଡାଂ ହେୱାନ୍‌ ମନ୍ଦିର୍‌ତ ଚଞ୍ଜ୍‌ୟା ଆତାନ୍ନା ଇଞ୍ଜି ହେୱାର୍‌ ବୁଜାଆତାର୍‌, ଆରେ ହେୱାନ୍‌ ହେୱାରିଂ କେଇଚଚ୍‌ଚି ଇଞ୍ଜେଙ୍ଗ୍‌ ଲାଗାତାନ୍‌ ଆରି କନ୍ଦା ଆଜ଼ି ମାଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","ପାଚେ ହେ ହେବା ପାଲିନି ଦିନ୍‌ ସବୁ ୱିସ୍ତିଲେ, ହେୱାନ୍‌ ନିଜାର୍‌ ଇଞ୍ଜ ହାଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","ହେ ପାଚେ ହେ ଡକ୍ରୁହି ଏଲିସାବେତ୍‌ ମାଞ୍ଜେଙ୍ଗ୍‌ ଆସ୍ତାତ୍‌, ଆରେ ହେଦେଲ୍‌ ପାଞ୍ଜ୍ ମାସ୍‌ ପାତେକ୍‌ ଇନେରିଂ ୱେଚ୍‌ୱାଦାଙ୍ଗ୍‌ ମାଚାତ୍‌, ");
INSERT INTO peg_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","ତା ପାଚେ ହେୱାନ୍‌ ଇଚାନ୍‌, “ମାନାୟାର୍‌ ତାକେ ନା ଲାଜ୍‌ ହାଚ୍‌ଚେଦେଂ ଇଞ୍ଜି ମାପ୍ରୁ ଦୟା କିଜ଼ି ନା କାଜିଂ ଏଲେଙ୍ଗ୍‌ କିତ୍‌ତାନ୍‌ନା ।” ");
INSERT INTO peg_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","ଚଅ ମାସ୍‌ ପାଚେ ଗାବ୍ରିଏଲ୍‌ ଦୁତ୍‌ ଇସ୍ୱର୍‌ ମାପ୍ରୁ ଲାଗାଂ ଗାଲିଲିନି ନାଜରିତିୟ ତର୍‌ଦି ଗାଡ଼୍‌ଦ ର ଗାଡ଼୍‌ଚେ ତାକେ ପକ୍ୟା ଆତାନ୍‌; ");
INSERT INTO peg_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","ଦାଉଦ୍‌ ଲାତ୍ରାନି ଜସେପ୍‌ ତର୍‌ଦାକାନ୍‌ ରୱାନ୍‌ ଆଣ୍ଡ୍ରେନ୍‌ ଲାହାଙ୍ଗ୍‌ ହେଦେଲ୍‌ ମାଲାକିୟା ଆଜ଼ି ମାଚାତ୍‌; ହେ ଜିପଲି ତର୍‌ ମରିୟମ୍‌; ");
INSERT INTO peg_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","ହେୱାନ୍‌ ଇଞ୍ଜ ହଣ୍‌ଜି ହେ ଲାଗେ ୱାଜ଼ି ଇଚାନ୍‌, “ଆଗ ଦୟା ପାୟାଆତାକାୟ୍‌, ନିନ୍ଦାଂ ହାର୍‌ ଆଏତ୍‌, ମାପ୍ରୁ ନି ହୁଦାଂ ମାନାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","ମାତର୍‌ ହେଦେଲ୍‌ ଇ ବଚନ୍‌ତ କାବା ଆଜ଼ି ଇଦାଂ ଇନେସ୍‌ ବେରଣ୍‌ ଇଞ୍ଜି ମାନ୍ତ ବାବିକିଦେଂ ଲାଗାତାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","ହେବେଣ୍ଡାଂ ଦୁତ୍‌ ହେଦେଲିଂ ଇଚାତ୍‌, “ଏ ମରିୟମ୍‌, ପାଣ୍ଡ୍ରା ଆମା, ଇନାକିଦେଂକି ଏନ୍‌ ଇସ୍ୱର୍‌ ଲାଗେ ଦୟା ପାୟା ଆତାୟ୍‌ନା । ");
INSERT INTO peg_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","ଆରି ହୁଡ଼ାଟ୍‌ ଏନ୍‌ ଏସ୍‌ ପିସ୍ତିପା ର କାଡ଼୍‌ଦେଂ ଗାଟାଆନାତ୍‌ ଆରି ହେୱାନ୍‌ ତର୍‌ ଜିସୁ ତର୍‌ ହିନାଦେର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","ହେୱାନ୍‌ ସିଗ୍‌ଦାକାନ୍‌ ଆନାନ୍‌ ଆରି ଇସ୍ୱର୍‌ ମାଜ଼ି ଇଞ୍ଜି ଡାକ୍‌ପୁଟା ଆନାନ୍‌; ମାପ୍ରୁ ଇସ୍ୱର୍‌ ହେୱାନିଂ ତାଞ୍ଜି ଆବା ଦାଉଦ୍‌ତି ଗାଦି ଦାନ୍‌ କିତାର୍‌, ");
INSERT INTO peg_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","ହେୱାନ୍‌ ଜାକୁବ୍‌ ଲାତ୍ରା ଜପି ଜୁଗ୍‌ ଜୁଗ୍‌ ରାଜି କିନାନ୍‌ ଆରି ହେୱାନ୍‌ ରାଜିତ ୱିଜ଼ୁତ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","ମାତର୍‌ ମରିୟମ୍‌ ଦୁତ୍‌ଙ୍ଗ୍‌ ଇଚାତ୍‌, “ଇଦାଂ ଇନେସ୍‌ ଆନାତ୍‌ ? ଆନ୍‌ତ ଆଣ୍ଡ୍ରେନ୍‌ତିଂ ପୁନୁଙ୍ଗ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","ଦୁତ୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ଉତର୍‌ ହିତାତ୍‌, “ନେକ୍ରି ଜିବୁନ୍‌ ନି ଜପି ଜୁଦ୍‌ନାତ୍‌ ଆରି ସିଗ୍‌ଦାକାନ୍‌ ଇସ୍ୱର୍ତି ସାକ୍ତି ନିଙ୍ଗେଙ୍ଗ୍‌ ଆସ୍ତାନାତ୍‌, ଲାଗିଂ ଇନେର୍‌ ଜଲମ୍‌ ଆନାନ୍‌, ହେୱାନ୍‌ ପୁଇପୁୟା ଜିବୁନ୍‌ ଆରି ଇସ୍ୱର୍‌ ମେହି ଇଞ୍ଜି ଡାକ୍‌ପୁଟାଆନାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","ଆରେ ହୁଡ଼ାଟ୍‌, ମି ଇଞ୍ଜି ଏଲିସାବେତ୍‌ ପା ବୁଡ଼ା ୱେଡ଼ାଲିଂ ର ମାଜ଼ିଂ ଗରବ୍‌ତ ଆସ୍ତାନ୍‌ନା । ଇନେର୍‌ ବାଞ୍ଜ୍‌ଣି ଇଞ୍ଜି ଡାକ୍‌ପୁଟା, ନଙ୍ଗ୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ଚଅ ମାସ୍‌ ଆତାତ୍‌ନ୍ନା; ");
INSERT INTO peg_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","ଇନାକିଦେଂକି ଇସ୍ୱର୍‌ ମାପ୍ରୁ ବଚନ୍‌ ତାକେ ସବୁ ବିସ୍ରେ ଆୱାକା ଆନାତ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","“ଇବେଣ୍ଡାଂ ମରିୟମ୍‌ ଇଚାତ୍‌,” ହୁଡ଼ାଟ୍‌, “ଆନ୍‌ ମାପ୍ରୁତି ଆଡ଼ିୟାଣି; ମି କାତାହୁକେ ନାଙ୍ଗେଙ୍ଗ୍‌ ଗିଟାଆଏତ୍‌ ।” ହେଦାଂ ପାଚେ ଦୁତ୍‌ତ ତା ତାକେଣ୍ଡାଂ ହାଚାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","ଇୱାଡ଼ାଲିଂ ମରିୟମ୍‌ ନିଙ୍ଗ୍‌ଜି ମାଡ଼ି ରାଜି ଜିହୁଦା ଦେସ୍‌ନି ର ଗାଡ଼୍‌ଦ ଦାପ୍ରେ ହାଚାତ୍‌, ");
INSERT INTO peg_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","ଆରେ ଜିକରିୟ ଇଞ୍ଜ ହଣ୍‌ଜିପା ଏଲିସାବେତ୍‌ତିଂ ଜୁୱାର୍‌ କିତାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","ଆରେ, ଏଲିସାବେତ୍‌ ମରିୟମ୍‌ତିଂ ଜୁୱାର୍‌ ୱେଚି ଦାପ୍ରେ ହିମ୍‌ଣା ତା ପଟତ ଏନ୍‌ନ୍ଦି ନିଙ୍ଗ୍‌ତାନ୍‌, ପାଚେ ଏଲିସାବେତ୍‌ ପୁଇପୁୟା ଜିବୁନ୍ତ ବାର୍ତି ଆଜ଼ି ଇଚାତ୍‌ ");
INSERT INTO peg_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","ବେସି ଗାଜା କାଟ୍‌ ଆଜ଼ି ଇଚାତ୍‌, “କଗ୍‌ଲେ ବିତ୍ରେ ଏନ୍‌ ଦନ୍ୟବାଦ୍‌ ନି ଗରବ୍‍ନି ପାଡ଼୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","ଆରେ, ନା ମାପ୍ରୁ ତେହି ଜେ ନା ଲାଗେ ୱାନାତ୍‌, ନାଦାଂ ଇ କାରୁମ୍‌ ଇମେଣ୍ଡାଂ ଆତାତ୍‌ ? ");
INSERT INTO peg_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","ଇନାକିଦେଂକି ହୁଡ଼ାଟ୍‌, ନି ଇଚି ବେରଣ୍‌ ୱେଚିଦାପ୍ରେ ହିମ୍‌ଣା ନା ପଟତ ମାନି କାଡ଼୍‌ଦେ ୱାର୍‌ୟା ଆଜ଼ି ଏନ୍ତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","ଇନେର୍‌ ପାର୍ତି କିତାର୍‌, ହେୱାନ୍‌ ଦନ୍ୟ, ଇନାକିଦେଂକି ମାପ୍ରୁତାଂ ତାଙ୍ଗେଙ୍ଗ୍‌ ଇନା ଇନାକା ୱେଚ୍‌ଚାନ୍‌ନା, ହେ ସବୁ କାମ୍‌ ଆନାତ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","ଇବେଣ୍ଡାଂ ମରିୟମ୍‌ ଇଚାତ୍‌, “ନା ୱାସ୍କି ମାପ୍ରୁଙ୍ଗ୍‌ କେର୍‌କଣ୍‌ କେର୍‌ନାତା,” ");
INSERT INTO peg_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","ଆରେ, “ନା ଜିବୁନ୍‌ ନାଙ୍ଗ୍‌ ବାଚାୟ୍‌କିତ୍‌ତି ଇସ୍ୱର୍‌ ମାପ୍ରୁତାକେ ୱାରି ହତ୍‌ନାତା; ");
INSERT INTO peg_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","ଇନାକିଦେଂକି ହେୱାନ୍‌ ନିଜ୍‌ ଆଡ଼ିୟାଣି ପାତିଦିନିଦୁକ୍‌ କାଜିଂ ହୁଡ଼୍‌ନାର୍‌ । ଆରେ ହୁଡ଼ାଟ୍‌, ମୁଡ଼୍‍ଦାଂ ୱିଜ଼୍‌ନି ପାତେକ୍‌ ଲାତ୍ରା ୱିଜ଼ାର୍‌ ନାଙ୍ଗେଙ୍ଗ୍‌ ଦନ୍ୟ ଇଞ୍ଜି ଇଞ୍ଜ୍‌ନାର୍‌; ");
INSERT INTO peg_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","ଇନାକିଦେଂକି ଗାଜା ସାକ୍ତିକାଟାକାନ୍‌, ହେୱାନ୍‌ ନା କାଜିଂ ଗାଜା କାମାୟ୍‌ କିତାନ୍‌ନ୍ନା; ହେୱାନ୍‌ ତର୍‌ ପୁଇପୁୟା । ");
INSERT INTO peg_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","ଆରେ ତାଙ୍ଗେଙ୍ଗ୍‌ ପାଣ୍ଡ୍ରା ଆନାକାର୍‌ କାଜିଂ ହେୱାନ୍ତି ଦୟା ଜୁଗ୍‌ ଜୁଗ୍‌ ମାନ୍‌ଗାନାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","ହେୱାନ୍‌ ନିଜ୍‍ କେଇନି ବାପୁତାଂ ଚଚ୍‌ଚାନ୍ନା; ଆକ୍ରିୟାରିଂ ହେୱାର୍‌ ମାନ୍‌ନି ମେହାଆନାକାରିଂ ଚିନ୍‍ବିନ୍‍ କିତାନ୍‌ନ୍ନା; ");
INSERT INTO peg_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","ହେୱାନ୍‌ ସାସନ୍‌ କାର୍‌ୟାରିଂ ରାଜା ଗାଦିତାଂ ପିହିକିତାନ୍ନା, ଅର୍କିତ୍‌ ଲଗାଙ୍ଗ୍‌ ନିକ୍‌ତାର୍ଣ୍ଣା, ");
INSERT INTO peg_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","ହେୱାନ୍‌ ନାସ୍‌କି ଲଗାଂ ହାର୍ଦି କାଦି ହିଜ଼ି ମାଚାନ୍‌, ହାଉକାର୍‌ରିକାଂ ୱାରା କେଇଦାଂ ପକ୍ତାନ୍‍ନ୍ନା । ");
INSERT INTO peg_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","ମା ଦାଦି ଆକର୍‌ କାଜିଂ ତା ପାର୍ମାଣ୍‌ ହେୱାନ୍‌ ରାକ୍ୟା କିତାନ୍‌ନ୍ନା ଆରି ତା ଆଡ଼ିଏନ୍‌ ଇସ୍ରାଏଲ୍‌ତିଂ ଦୟା କିତାନ୍‌ନା । ");
INSERT INTO peg_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","ହେୱାନ୍‌ ଜୁଗ୍‌ ଜୁଗ୍‌ କାଜିଂ ଅବ୍ରାହାମ୍‌ ଆରି ତା ୱିଜ଼ାର୍‌ ଲାତ୍ରାନିକାରିଂ ଦୟା ଚଚ୍‌ଚି କିଦେଙ୍ଗ୍‌ ବାଣାୱାତାର୍ଣ୍ଣା ।” ");
INSERT INTO peg_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","ଆରେ, ମରିୟମ୍‌ ତିନିମାସ୍‌ ପାତେକ୍‌ ଏଲିସାବେତ୍‌ ଲାହାଙ୍ଗ୍‌ ମାନ୍‌ଞ୍ଜି ନିଜାର୍‌ ଇଞ୍ଜ ହାଚାତ୍‍ । ");
INSERT INTO peg_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","ପାଚେ ଏଲିସାବେତ୍‌ ପାର୍‍ହାଡ଼୍‍ ଆନି ଦିନ୍‌ ଏକାୱାତିଲେ, ହେଦେଲ୍‌ ର ମାଜ଼ି ଗାଟାଆତାତ୍‍, ");
INSERT INTO peg_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","ଆରେ ମାପ୍ରୁ ଜେ ହେ କାଜିଂ ବେସି ଦୟା କିତାନ୍‌ନ୍ନା, ଇଦାଂ ୱେନ୍‌ଞ୍ଜି ତା ପାଡ଼୍‍ହା ଲଗୁ ଆରି ୱାସ୍କିନିକାର୍‍ ତା ଲାହାଙ୍ଗ୍‌ ୱାରି କିଦେଙ୍ଗ୍‌ ଲାଗାତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","ଆଟ୍‌ ଦିନ୍‌ତାଂ ହେୱାର୍‌ ହିମ୍‌ଣାତିଂ ସୁନ୍ନତ୍‌ କିଦେଙ୍ଗ୍‌ ୱାତାର୍‍ ଆରି ତା ଲାତ୍ରାହି ତର୍‌ ଲାକେ ହେ ତର୍‌ ଜିକରିୟ ଇଡ୍‌ଦେଂ ମାନ୍‌କିତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","ମାତର୍‌ ତା ତେହି ଇଚାତ୍‌, “ଆକାୟ୍‌, ତା ତର୍‌ ଜହନ୍‌ ଆନାତ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","ହେୱାର୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ଇଚାର୍‌, “ନି ୱାସ୍କିନିକାରିଂ ବିତ୍ରେ ତ ଇନେରିଂ ଇ ତର୍‌ ହିଲୁତ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","ଇବେଣ୍ଡାଂ “ତାଙ୍ଗେଙ୍ଗ୍‌ ଇମ୍‌ଣି ତର୍‌ ହିନାସ୍‌ ଇଞ୍ଜି ତାଞ୍ଜିଆବା ମାନ୍‌ କିନାନା, ହେଦାଂ ହେୱାର୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ଚାନ୍ୟା ଆଜ଼ି ୱେନ୍‌ବେଦେଂ ଲାଗାତାର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","ହେ ପାଚେ ହେୱାନ୍‌ ର ଲେକିକିନି ପାଟା ଏନ୍‌ଚି ଲେକିକିତାନ୍‌; “ତା ତର୍‌ ଜହନ୍‌ ।” ଇବେ ୱିଜ଼ାର୍‌ କାବା ଆତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","ଆରେ, ହେ ଦାପ୍ରେ ତା ୱେଇ ଆରି ୱେନ୍ଦୁଲ୍‌ ଜେୟାଆତାତ୍‌ ଆରି ହେୱାନ୍‌ ବେଣ୍‌ ଇଞ୍ଜି ଇସ୍ୱର୍‌ ମାପ୍ରୁ ଦନ୍ୟବାଦ୍‌ କିଦେଙ୍ଗ୍‌ ଲାଗାତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","ଇବେଣ୍ଡାଂ ହେୱାନ୍‌ ତା ଲାଗେ ଲାଗେ ନିକାର୍‌ ୱିଜ଼ାର୍‌ ପାଣ୍ଡ୍ରା ଆଜ଼ି ହାଚାର୍‌, ଆରେ ଇ ୱିଜ଼ୁ କାତା ଜିହୁଦା ଦେସ୍‌ନି ମାଡ଼ିରାଜିନି ସବୁନିପ ଲକୁ ୱେଚ୍‌ପାୱେଚ୍‌ପି ଆତାର୍‌, ");
INSERT INTO peg_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","ଆରେ ୱେନାକାର୍‌ ୱିଜ଼ାର୍‌ ହେ ୱିଜ଼ୁ ନିଜ୍‌; ନିଜାର୍‌ ମାନ୍ତ ଇଡ଼୍‌ଜି ଇଚାର୍‌, “ଇ କାଡ଼୍‌ଦେ ଇନାକା ଆନାତ୍‌ ?” ଇନାକିଦେଂକି ହାତ୍‌ପାନେ ମାପ୍ରୁ କେଇ ତା ହୁଦାଂ ମାନାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","ଆରେ, ତା ଲାତ୍ରାହି ଜିକରିୟ ପୁଇପୁୟା ଜିବୁନ୍ତ ବାର୍‌ତି ଆଜ଼ି ଇ ବେଣ୍‌ବାକ୍‌ଣାୟ୍‌କିନାକାନ୍‌ ଇଚାନ୍‌, ");
INSERT INTO peg_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","ଦନ୍ୟ ମାପ୍ରୁ, “ଇସ୍ରାଏଲ୍‌ନି ଇସ୍ୱର୍‌ ମାପ୍ରୁଙ୍ଗ୍‌,” ଇନାକିଦେଂକି ନିଜାର୍‌ ଲଗାଂ ଦୟା ହୁଡ଼୍‌ଜି ହେୱାନ୍‌ ମୁକ୍ତି କିତାନ୍‌ନ୍ନା; ");
INSERT INTO peg_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","ହେୱାନ୍‌ ନିଜାର୍‌ ଆଡ଼ିଏନ୍‌ ଦାଉଦ୍‌ନି ଲାତ୍ରାନି ରକାନ୍‌ ସାକ୍ତିନିକାନ୍‌ ମା କାଜିଂ ମୁକ୍ତି କିଦ୍‌ଦେଂ ମାଙ୍ଗେଙ୍ଗ୍‌ ହିତ୍‌ନ୍ନା, ");
INSERT INTO peg_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","ଆଗେନି ସମୁତାଂ ନିଜ୍‍ ପୁଇପୁୟା ବେଣ୍‌ବାକ୍‌ଣାୟ୍‌କିନାକାର୍‌ ୱେଇ ତାଙ୍ଗ୍‌ ଇନେସ୍‌ ଇଞ୍ଜି ମାଚାର୍‌ ");
INSERT INTO peg_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","ହେ ଲାକେ ମା ବିତ୍ରେ ସାତ୍ରୁର୍‍ତାଂ ଆରି ମା ୱିଜ଼ାକାର୍‌ ଗିଣ୍‌କାରିୟାର୍‍ କେଇଦାଂ ମୁକ୍ତି ପାୟାତାୟ୍‌ନା, ");
INSERT INTO peg_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","ହେୱାନ୍‌ ଇଚାନ୍‌, ମା ଆକର୍‌ କାଜିଂ ଦୟା ଚଚ୍‌ୟାତାନ୍‌ନା, ଆରି ତାଂ ପୁଇପୁୟା ନିୟମ୍‌ ହେୱାନ୍‌ ନିତ୍ରେ ଏତୁ କିଜ଼ି ମାନେନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","ମା ଆବା ଅବ୍ରାହାମ୍‌ ଲାଗେ ଇମ୍‌ଣି ପାର୍ମାଣ୍‌ କିଜ଼ି ମାଚାନ୍‌, ");
INSERT INTO peg_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","ପାଚେ ଇନେସ୍‌ ସାତ୍ରୁ କେଇଦାଂ ମୁକ୍‌ଡ଼ା ଆଜ଼ି ପାଣ୍ଡ୍ରା ଆୱାଦାଂ ଜିବୁନ୍‌ ମାନି ପାତେକ୍‌ ହେୱାନ୍‌ ଲାଗେ, ");
INSERT INTO peg_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","ଇନେସ୍‌କି ଆସେଙ୍ଗ୍‌ ପୁଇପୁୟା ଆରି ଦାର୍ମି ଆଜ଼ି ତାତି ପାର୍ତାନା କିଦେଙ୍ଗ୍‌ ଇଞ୍ଜି ମାଙ୍ଗେଙ୍ଗ୍‌ ଆସିର୍ବାଦ୍‌ କିଦ୍‌ନାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","“ଏ ନା ମାଜ଼ି ଏନ୍‌ ସିଗ୍‌ଦାକାନ୍‌ ଇସ୍ୱର୍ତି ର ବେଣ୍‌ବାକ୍‌ଣାୟ୍‌କିନାକାନ୍‌ ଲାକେ ଡାକ୍‌ପୁଟା ଆନାୟ୍‌ । ଏନ୍‌ ମାପ୍ରୁତି ରୱାୟ୍‌ ଚାଣ୍ଡ୍‌ ଦୁତ୍‌ ଲାକେ ତା କାଜିଂ ତା ହାଜ଼ି ରଚ୍‌ନାୟ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","ପାପ୍‌ କେମା ପାୟା ଆନି କାଜିଂ ହେୱାର୍‌ ଜେ ମୁକ୍ତି ଆନାକା ଲାବ୍‌ ପାୟା ଆନାର୍‌ ତା ମାନାୟାରିଂ ଇ କାତା ଇଞ୍ଜେଙ୍ଗ୍‌ ହାନାନ୍‌, ");
INSERT INTO peg_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","ମା ଇସ୍ୱର୍‌ ଦୟାନିକାନ୍‌ ଆରି ହୁଦାର୍‌ ଜିବୁନ୍‌, ହେୱାନ୍‌ ମା କାଜିଂ ମୁକ୍ତି ଆନାକା ମା କାଜିଂ ୱେଡ଼ା ହନାତ୍‌, ");
INSERT INTO peg_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","ଇମ୍‌ଣାକାର୍‌ ହାତିଲାକେ ମାଜ୍‌ଗା ହିତ୍‌ଡ଼ିତ ବାହାକିନାର୍‌, ସୁସ୍ତା ହାଜ଼ିତ ହେୱାରିଂ ଅଜ଼ି ହାଞ୍ଜେଙ୍ଗ୍‌ ଇଞ୍ଜି ହେୱାନ୍‌ ୱିଜ଼ାର୍‌ ଜପି ସାର୍ଗେତାଂ ଅଜଡ଼୍‌ ହିଦେଙ୍ଗ୍‍ ଆଡ୍‌ନାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","ପାଚେ, କାଡ଼୍‌ଦେ ଗାଜା ଆଜ଼ି ଜିବୁନ୍‌ତ ସାକ୍ତି ଆଦେଂ ଲାଗାତାନ୍‌ ଆରେ ଇସ୍ରାଏଲ୍‌ ଲାଗାଂ ପୁଟାଆୱି ପାତେକ୍‌ ବାଟାତ ମାଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","ହେ ସମୁତ ରମିୟ ପୁର୍ତିନି ୱିଜ଼ୁ ରାଜ୍‌କିନାକାନ୍‌ ମାନାୟାରିଂ ତର୍‌ ଲେକିକିନାକା ଇଞ୍ଜି କାଇସର୍‌ ଅଗସ୍ଟତାଂ ବଲ୍‌ ସୁଣାୟ୍‌ କିତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","ସିରିୟାନି ରାଜ୍‌କିନାକାନ୍‌ କିରଣିୟତି ସମୁତ ପର୍ତୁମ୍‌ ଇ ଲକୁ ଗାଣାକିନାକା ତର୍‌ ଲେକା ଆଜ଼ି ମାଚାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","ହେଦାଂ କାଜିଂ ୱିଜ଼ାର୍‌ ତର୍‌ ଲେକିକିନାକା କିଦେଙ୍ଗ୍‌ ଜାର୍‌ ଜାର୍‌ ଗାଡ଼୍‌ଦ ହାଲ୍‌ଜି ମାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","ଆରେ, ଜସେପ୍‌ ପା ତର୍‌ ଲେକିକିଦେଂ ଇଞ୍ଜି ମରିୟମ୍‌ ଲାହାଙ୍ଗ୍‌ ଗାଲିଲିନି ନାଜରିତିୟ ଗାଡ଼୍‌ତାଂ ଜିହୁଦା ରାଜିନି ବେତ୍‌ଲିହିମ୍‌ ତର୍‌ଦି ଦାଉଦ୍‌ନି ଗାଡ଼୍‌ଦ ହାଚାର୍‌, ଇନାକିଦେଂକି ହେୱାନ୍‌ ଦାଉଦ୍‌ ଲାତ୍ରା ଆରି ଜାତିନି ଲକ୍‌ ମାଚାନ୍‌; ");
INSERT INTO peg_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","ହେୱାନ୍‌ ତା ମାଲାକିୟା ଆଜ଼ି ମରିୟମ୍‌ ଲାହାଂ ତର୍‌ ଲେକିକିନି କାଜିଂ ହାଚାର୍‌ । ମରିୟମ୍‌ ଏସ୍‌ପିସ୍ତି ମାଚାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","ହେୱାର୍‌ ହେ ବାହାତ ମାନି ୱେଡ଼ାଲିଂ ହେଦେଲ୍‌ତି ଜଲମ୍‌ କିନି ସମୁ ଏକାୱାତାତ୍‌ ");
INSERT INTO peg_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","ପାଚେ ହେଦେଲ୍‌ ଜାର୍‌ ପାଣ୍‌ୱା ମାଜ଼ି ଚଞ୍ଚାନ୍‌ ଆରି ହେୱାନିଂ ହେନ୍ଦ୍ରାତ ହୁରୁପିସ୍ କଡି ହାଡ଼ାନି ଡଙ୍ଗାତ ତ୍ରେପ୍‌ତାର୍‌, ଇନାକିଦେଂକି ମାନି ଇଲ୍‌ ହେୱାରିଂ ହିଲ୍‍ୱାତାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","ହେ ୱେଡ଼ାଙ୍ଗ୍‍ କେତେକ୍‌ ମେଣ୍ଡାଗଡ଼ିୟାର୍‌ ବାଟାତ ମାନ୍‌ଞ୍ଜି ନାଣା ହେୱାର୍‌ତି ମେଣ୍ଡାଂ ମାନ୍ଦାତିଂ କାସି ମାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","ମାପ୍ରୁନି ରୱାନ୍‌ ଦୁତ୍‌ ହେୱାର୍‌ ଲାଗେ ନିଲ୍‌ତାନ୍‌, ଆରେ ମାପ୍ରୁତି, ଜାଜ୍‌ମାଲ୍‌ନି ଅଜଡ଼୍‌ ହେୱାର୍‌ ଚାରିବେଣ୍‌ତାଂ ଆର୍‌ତାତ୍‌ । ଆରି ହେୱାର୍‌ ବେସି ପାଣ୍ଡ୍ରା ଆତାର୍‌ ");
INSERT INTO peg_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","ହେବେଣ୍ଡାଂ ଦୁତ୍‌ ହେୱାରିଂ ଇଚାନ୍‌, “ପାଣ୍ଡ୍ରା ଆମାଟ୍‌; ହୁଡ଼ାଟ୍‌, ଆନ୍‌ ସବୁ ମାନାୟାରିଂ ବେସି ୱାରିନି ନେକ୍ରିକାବୁର୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ୱେଚାନାଙ୍ଗା, ");
INSERT INTO peg_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","ଇନାକିଦେଂକି ନେଞ୍ଜେଙ୍ଗ୍‌ ଦାଉଦ୍‌ନି ଗାଡ଼୍‌ଦ ମି କାଜିଂ ମୁକ୍ତି କାରିୟା ହେୱାନ୍‌ କ୍ରିସ୍ଟ ମାପ୍ରୁ ।” ");
INSERT INTO peg_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","ଆରେ, ମି କାଜିଂ ଇଦାଂ ଚିନ୍‌ ଲାକେ ଆନାତ୍‌, “ଏପେଙ୍ଗ୍‌ ର କାଡ଼୍‌ଦେଂ ହେନ୍ଦ୍ରା ହୁର୍‍ପିୟା ଆଜ଼ି କଡି ହାଡ଼ାନି ଡଙ୍ଗାତ ହୁନ୍‌ଜି ମାନାକା ହୁଡ଼୍‌ନାଦେର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","ପାଚେ, ହାଚାଟ୍ରେ ହେ ଦୁତ୍‌ ହୁଦାଂ ସାର୍ଗେନି ଦଲ୍‌ ର ଗାଜାଦାଡ଼୍ ୱାତାର୍‌ ଇସ୍ୱର୍‌ ମାପ୍ରୁଙ୍ଗ୍‌ ପାର୍ତାନା କିଜ଼ି କିଜ଼ି କେର୍‌ତାର୍‌, ");
INSERT INTO peg_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“ଜପ୍‌ଣି ନିକାରିଂ ଇସ୍ୱର୍‌ ମାପ୍ରୁଙ୍ଗ୍‌ ଜାଜ୍‌ମାଲ୍‌, ଆରେ ପୁର୍ତିତ ହେୱାନ୍ତି ଏଚେକ୍‌ସାରି ବିୱାହିଂ ମାନାୟ୍‌ ବିତ୍ରେ ସୁସ୍ତା ଆଏତ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","ଦୁତକ୍‌ ହେୱାର୍‌ ତାଙ୍ଗ୍‌ ସାର୍ଗେତ ହାଚିପାଚେ ମେଣ୍ଡାଗଡ଼ିୟାର୍‌ ହେୱେର୍‌ ହେୱାର୍‌ ଇନ୍‌ବା ଆତାର୍‌ “ୱାଡ ଆସେଙ୍ଗ୍‌ ବେତ୍‌ଲିହିମ୍‌ ପାତେକ୍‌ ହାଲ୍‌ଜି, ମାପ୍ରୁ ମାଙ୍ଗେଙ୍ଗ୍‌ ଇମ୍‌ଣି ବଚନ୍‌ନି ଗଟ୍‌ଣା ୱେଚ୍‌ଚାତାନ୍ନା, ହେଦାଂ ହୁଡ଼୍‌ନାସ୍‍ ।” ");
INSERT INTO peg_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","ଇବେଣ୍ଡାଂ ହେୱାର୍‌ ବେଗିହାଲ୍‍ଜି ଡେକ୍‌ଚି ମରିୟମ୍‌ ଆରି ଜସେପ୍‌ତିଂ, ଆରି କଡିହାଡ଼ା ଡଙ୍ଗାତ କାଡ଼୍‌ଦେଂ ତ୍ରେପ୍‌ଚି ମାଚାକା ହୁଡ଼୍‌ତାର୍ । ");
INSERT INTO peg_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","ହେୱାର୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ହୁଡ଼୍‌ଜି ହେ କାଡ଼୍‌ଦେ ବିସ୍ରେ ହେୱେରିଂ ଦୁତ୍‌ ଇମ୍‌ଣି କାତା ଇଞ୍ଜି ମାଚାତ୍‌, ହେଦାଂ ୱେଚ୍‌ଚାର୍‌, ");
INSERT INTO peg_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","ପାଚେ ଏଚେକ୍‌ ମାନାୟ୍‌ ମେଣ୍ଡାଗଡ଼ିୟାର୍‌ତାଂ ହେ ସବୁ ବେରଣ୍‌ ୱେଚାର୍‌, ହେୱାର୍‌ ୱିଜ଼ାର୍‌ ହେବେ କାବା ଆତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","ମାତର୍‌ ମରିୟମ୍‌ ଇ ୱିଜ଼ୁ କାତା ମାନ୍ତ ଇଡ଼୍‌ଜି ଗାଜା ଏତ୍‌ କିଦେଙ୍ଗ୍‌ ଲାଗାତାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","ଆରେ, ମେଣ୍ଡା ଗଡ଼ିୟାରିଂ ଇନେସ୍‌ ୱେଚ୍‌ଚି ମାଚାର୍‌, ହେ ଲାକେ ହେୱାର୍‌ ଇନା ଇନାକା ୱେଚାର୍‌ ଆରି ହୁଡ଼୍‌ତାର୍, ହେ ୱିଜ଼ୁତିଙ୍ଗ୍‌ ଇସ୍ୱର୍‌ ମାପ୍ରୁ ନାନ୍ଦ୍‌ ଆରି କେର୍‌କଣ୍‌ କେର୍‌ଜି ଲେଉଟା ଆତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","ଆଟ୍‌ ଦିନ୍‌ତାଂ ପାଚେ ସୁନ୍ନତ୍‌ କିଦେଙ୍ଗ୍‌ ଜିସୁଙ୍ଗ୍‌ ମନ୍ଦିର୍‌ତ ଅଜ଼ି ହାଚାର୍‌ ତା ତର୍‌ ଜିସୁ ଇଡ୍‌ତାର୍‌; ଇ ତର୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ଏସ୍‌ ପିହ୍‍ୱି ଆଗେ ଦୁତ୍‌ ଇଞ୍ଜି ମାଚାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","ପାଚେ ଏଚେକାଡ଼୍‌ଦ ମସାତି ବିଦି ଇସାବ୍‌ରେ ଜସେପ୍‌ ଆରି ମରିୟମ୍‌ତି ସକଟ୍‌ ଆନି ସମୁ ଏକା ୱାତାତ୍‌, ହେୱାର୍‌ ମାପ୍ରୁତି ଉଦେସ୍‌ତ କାଡ଼୍‌ଦେଂ ପୁଜା କିନି କାଜିଂ ଜିରୁସାଲମ୍‌ତ ଅତାର୍‌, ");
INSERT INTO peg_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","ଇନେସ୍‌କି ମାପ୍ରୁତି ବିଦି ଲେକା ଆତି ଲାକେ “ୱିଜ଼ାର୍‍ ପର୍ତୁମ୍‌ ଜନମ୍‌ଆତି ଆଣ୍ଡ୍ରା ହିମ୍‌ଣାଂ ମାପ୍ରୁ କାଜିଂ ପୁଇପୁୟା ଇଞ୍ଜି ହିସାବ ଆନାତ୍‌,” ");
INSERT INTO peg_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","ମାପ୍ରୁତି ବିଦି ସାସ୍ତର୍‌ ତାକେ ଲେକାଆତି ଇ ବଲ୍‌ ହୁଦାଂ ହେୱାର୍‌ ହେୱେନିଂ ମାପ୍ରୁଙ୍ଗ୍‌ କାଜିଂ ପୁଜାହିନାକା ଇଞ୍ଜି ଆରି ମାପ୍ରୁନି ସାସ୍ତର୍‌ତ ଲେକାଆତାତ୍‌ନା “ରିଣ୍ଡାଂ ପାର୍‌ୱାଙ୍ଗ୍‌ ଆୱିତିସ୍‌ ରିଣ୍ଡାଂ ପାଣ୍ଡ୍‌କା ହିମ୍‌ଣାଂ ପୁଜାକିଦେଙ୍ଗ୍‌ ଇଞ୍ଜି ତାଙ୍ଗେଙ୍ଗ୍‌ ଜିରୁସାଲମ୍‌ତ ଅତାର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","ଆରେ ହୁଡ଼ାଟ୍‌, ଜିରୁସାଲମ୍‌ତ ସିମିୟନ୍‌ ତର୍‌ଦାକାନ୍‌ ରୱାନ୍‌ ଦାର୍ମି ଆରି ହାର୍‍ଦିମାନାୟ୍‍ ମାଚାନ୍‌; ହେୱାନ୍‌ ଇସ୍ରାଏଲ୍‌ନି ଦୁକ୍‌ସାରାୟ୍‌ କିଦେଙ୍ଗ୍‌ କାସି ମାଚାନ୍‌, ଆରେ ପୁଇପୁୟା ଜିବୁନ୍‍ ତା ତାକେ ଜୁଜ଼ି ମାଚାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","ମାପ୍ରୁ କ୍ରିସ୍ଟଙ୍ଗ୍‌ ହୁଡ଼୍‌ୱିତିସ୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ହେୱାନ୍ତି ହାକିଆଉତ୍, ପୁଇପୁୟା ଜିବୁନ୍‌ ହୁକେ ତାଙ୍ଗ୍‌ ଇ ବାର୍ସି ହିୟାଆଜ଼ି ମାଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","ହେୱାନ୍‌ ଜିବୁନ୍‌ତାଂ ବାର୍ତି ଆଜ଼ି ମନ୍ଦିର୍‌ତ ୱାତାନ୍‌, ଆରେ ହିମ୍‌ଣା ଜିସୁତି ଆବା ଆୟା ଏଚେକାଡ଼୍‌ଦ ହେ ବିସ୍ରେ ନି ବିଦିନି ହୁକେ କାମାୟ୍‌ କିଦେଙ୍ଗ୍‌ ଇଞ୍ଜି ତାଙ୍ଗେଙ୍ଗ୍‌ ବିତ୍ରେ ତାଇୱାତାର୍‌, ");
INSERT INTO peg_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","ହେୱାଡ଼ାଂ ସିମିୟନ୍‌ ହିମ୍‌ଣାତିଂ ଡ୍ରକ୍‌ଚି ଆଜ଼ି ଇସ୍ୱର୍‌ତିଂ ଦନ୍ୟବାଦ୍‌ କିଜ଼ି ଇଚାନ୍‌, ");
INSERT INTO peg_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“ଏ ମାପ୍ରୁ, ଅଙ୍ଗୟ୍‌ ଏନ୍‌ ନି କାତା ଲାକେ ନିଜ୍‌ ଆଡ଼ିୟାଙ୍ଗ୍‌ ସୁସ୍ତାତାଂ ତାଙ୍ଗ୍‌ଜି ହାଞ୍ଜେଙ୍ଗ୍‌ ହିନାୟ୍‌; ");
INSERT INTO peg_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","ଇନାକିଦେଂକି ନା କାଣ୍‌ଙ୍ଗା ନି ମୁକ୍ତି ଆନାକା ହୁଡ଼୍‌ନାଙ୍ଗା, ");
INSERT INTO peg_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","ଇମ୍‌ଣାକା ଏନ୍‌ ୱିଜ଼ାର୍‌ ମାନାୟାର୍‌ ମୁମ୍‌ଦ ଜାଲ୍‌ଦି କିତାୟ୍‌ନା, ");
INSERT INTO peg_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","ପାର୍ତିକିୱି ଜିହୁଦିର୍‌ କାଜିଂ ସତ୍‌ ହନି ଅଜଡ଼୍‌, ଆରେ ମି ଲକ୍‌ ଇସ୍ରାଏଲ୍‌ନି ଜାଜ୍‌ମାଲ୍‌ ଲାକେ କିତାୟ୍‌ନା ।” ");
INSERT INTO peg_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","ହେୱାନ୍‌ କାଜିଂ ଇଚି ୱିଜ଼ୁ ବିସ୍ରେ ହେ ଆବା ଆୟା ୱେନ୍‌ଞ୍ଜି କାବା ଆଜ଼ି ମାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","ଆରେ, ସିମିୟନ୍‌ ହେୱାରିଂ ଆସିର୍ବାଦ୍‌ କିଜ଼ି ହେୱାନ୍‌ ତେହି ମରିୟମ୍‌ତିଂ ଇଚାନ୍‌, ଇ କାଡ଼୍‌ଦେ ଇସ୍ରାଏଲ୍‌ ବିତ୍ରେ “ହେନିର୍‌ତି ଆରେ ନିଙ୍ଗ୍‌ଜି ବୁଡାଆନି କାଜିଂ ଇସ୍ୱର୍‌ ହୁକେ ବାଚିକିୟା ଆତାନ୍‌, ଇମ୍‌ଣାକାର୍‌ ବିରୁଦ୍‌ତ ବେସି ମାନାୟ୍‌ କାତା ଇନାର୍‌ ର ଚିନ୍‌ ଲାକେ ଆନାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","ହେନି ତାଙ୍ଗେଙ୍ଗ୍‌ ବେରୁଆନାର୍‌ ନିଜେ ମାନ୍‌ନି ଡ଼ୁକ୍‌ତି ବିଚାର୍‌ ସବୁ ହପ୍‌ନାନ୍‌ । ଦୁକ୍‌ ଲାକେ ର ଦାରାକାଣ୍ଡା ଜାର୍‌ ୱାସ୍କିତିଂ ଚିର୍‌ବିର୍‌ କିନାୟ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","ଆରେ, ହାନ୍ନା ଇନି ରଞ୍ଜେଲ୍‌ ବେଣ୍‌ବାକ୍‌ଣାୟ୍‌କିନାକାଦେଲ୍‌ ମାଚାତ୍‌; ହେଦେଲ୍‌ ଆସେର୍‌ ଜାତିନି ପେନୁଏଲ୍‍ ଗାଡ଼୍‌ହି । ତାଦାଙ୍ଗ୍‌ ବୟ୍‌ସ୍‌ ବେସି ଆଜ଼ି ମାଚାତ୍‌, ହେଦେଲ୍‌ ଜିପଲି ମାନି ପାଚେ ସାତ୍‍ବାର୍ହୁ ଆଣ୍ଡ୍ରେନ୍‌ ହୁକେ ବାହା କିଜ଼ି ମାଚାତ୍‌ ଆରି ଚାରିକଡ଼ି ଚାରିବାର୍ହୁ ପାତେକ୍‌ ରାଣ୍ଡି ଆଜ଼ି ମାଚାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","ହେଦେଲ୍‌ ବିର୍‌କୁଲ୍‌ ମନ୍ଦିର୍‌ ପିହ୍‍ୱାଦାଙ୍ଗ୍ ଉପାସ୍‌ ଆରି ଗୱାରି ହୁକେ ୱେଡ଼ାନାଣା ମାପ୍ରୁଙ୍ଗ୍‌ ପାର୍ତାନା କିଜ଼ି ମାଚାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","କାଡ଼୍‌ଦେ ଜିସୁ ମନ୍ଦିର୍‌ତ ୱାର୍‌ୟା ଆନିୱେଡ଼ାଂ ହାନ୍ନା ହେବେ ଏକିସ୍‌ ଇସ୍ୱର୍‌ତିଂ ଜୁୱାର୍‌ କିତାତ୍‌ ଆରି ଇସ୍ୱର୍‌ ଜିରୁସାଲମ୍‌ତିଂ ମୁକ୍ତି କିନାନ୍‌ ଇଞ୍ଜି ଇମ୍‌ଣାକାର୍‌ ପାର୍ତି କିଜ଼ି କାସି ମାଚାର୍‌, ହେୱାନ୍‌ ୱିଜ଼ାରିଂ କାଡ଼୍‌ଦେ ବିସ୍ରେ ଇଚାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","ପାଚେ ହେୱାର୍‌ ମାପ୍ରୁତି ମସାତି ବିଦି ଇସାବ୍ରେ ୱିଜ଼ୁ କାମାୟ୍‌ ୱିସ୍ତି ଗାଲିଲିତ, ଜାର୍‌ ଗାଡ଼୍‌ ନାଜରିତ୍‌ତ ଲେଉଟାତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","ଆରେ, କାଡ଼୍‌ଦେ ଗାଜା ଆଦେଂ ଲାଗାତାନ୍‌ ଆରି ଗିଆନ୍‍ତ ପୁରା ଆଉ ଆଉ ସାକ୍ତି ମାନାୟ୍‌ ଆତାନ୍‌, ଆରେ ଇସ୍ୱର୍ତି ଦୟା ହେ ଜପି ମାଚାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","ତା ତେହି ଲାତ୍ରାହି ପାତି ବାର୍ହୁ ନିସ୍ତାର୍‌ ପାର୍ବୁ ୱେଡ଼ାଲିଂ ଜିରୁସାଲମ୍‌ତ ହାଲ୍‌ଜି ମାଚାର୍‍ । ");
INSERT INTO peg_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","ହେୱାନ୍ତି ବାର ବାର୍ହୁ ୱେଡ଼ାଲିଂ ହେୱାର୍‌ ପାର୍ବୁ ରିତି ଇସାବ୍‌ରେ ହେବେ ହାଚିକ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","ପାର୍ବୁନି ସମୁ ୱିସ୍ତି ଏଚେକାଡ଼୍‌ଦ ହେୱାର୍‌ ମାଜ଼ି ୱାଜ଼ି ମାଚାର୍‌, ହେ ଏଚେକାଡ଼୍‌ଦ କାଡ଼୍‌ଦେ ଜିସୁ ଜିରୁସାଲମ୍‌ତ ଟେବା ଆତାନ୍‌, ଆରେ ତା ତେହି ଲାତ୍ରାହି ହେଦାଂ ପୁନ୍‌ୱାଦାଂ ମାଚାର୍‍ । ");
INSERT INTO peg_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","ମାତର୍‌ ହେୱାନ୍‌ ହାଙ୍ଗ୍‍ତାଂ ହାଚାକାର୍ ହୁକେ ମାନାନ୍‌ ଇଞ୍ଜି ହେୱାର୍‌ ଦିନେକ୍‌ନି ହାଜ଼ି ତାଙ୍ଗ୍‌ଜି ହାଚାର୍‌, ଆରେ ୱାସ୍କିନିକାର୍‍ ଆରି ଜାଣାଚିନା ଲକାର୍‍ ତାକେ ହେୱାର୍‌ ଡେକ୍‌ତେଂ ଲାଗାତାର୍‌, ");
INSERT INTO peg_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","ଆରେ ହେୱାନିଂ ଡେକୁ ଡେକୁ ଗାଟାଆୱିତିଲେ ଜିରୁସାଲମ୍‌ତ ଲେଉଟା ଆଜ଼ି ହାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","ତିନି ଦିନ୍‌ ପାଚେ ହେୱାର୍‌ ହେୱାନିଂ ମନ୍ଦିର୍‌ତ ଗାଟାଆତାର୍‍; ହେୱାନ୍‌ ପଣ୍ଡିତ୍‌କୁର୍‌ ବିତ୍ରେ କୁଚ୍‌ଚି ହେୱାର୍‌ କାତା ୱେନ୍‌ଞ୍ଜି ମାଚାନ୍‌ ଆରି ହେୱାରିଂ ପର୍‌ସନ୍‌ କିଜ଼ି ମାଚାନ୍‌, ");
INSERT INTO peg_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","ଆରେ ଏଚେକ୍‌ ମାନାୟ୍‌ ହେୱାନ୍‌ କାତା ୱେନ୍‌ଞ୍ଜି ମାଚାର୍‌, ୱିଜ଼ାକାର୍‌ ହେୱାନ୍ତି ବୁଦି ଆରି ଉତର୍‌ତ କାବା ଆବିସ୍ ମାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","ହେୱାର୍‌ ହେୱାନିଂ ହୁଡ଼୍‌ଜି କାବା ଆତାର୍‌, ଆରି ତା ତେହି ତାଙ୍ଗ୍‌ ଇଚାତ୍‌, “ବପା, ମାଙ୍ଗେଙ୍ଗ୍‌ ଇନେକିଦେଂ ଏଲେଙ୍ଗ୍‌ ଚିନ୍ତା କିତ୍‌ତାୟ୍‌ ? ହୁଡ଼ା, ମିଞ୍ଜ୍‍ବା ଆରି ଆନ୍‌ ବେସି ବିପ୍ତି ଆଜ଼ି ନିଙ୍ଗେଙ୍ଗ୍‌ ଡେକ୍ତାନାପା ।” ");
INSERT INTO peg_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","ଇବେତାଂ ହେୱାନ୍‌ ହେୱାରିଂ ଇଚାନ୍‌, ଇନେକିଦେଂ “ଏପେଙ୍ଗ୍‌ ନାଙ୍ଗେଙ୍ଗ୍‌ ଡେକ୍‌ଚି ମାଞ୍ଚାଦେର୍‌ ? ମାଞ୍ଜି ଆବାର୍‌ ଇଞ୍ଜ ମାନାକା ଜେ ନା କାମାୟ୍‌, ଇଦାଂ ଇନାକା ପୁନ୍‌ୱାଦାଂ ମାଚାଦେର୍‌ ?” ");
INSERT INTO peg_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","ମାତର୍‌ ହେୱାନ୍‌ ହେୱାରିଂ ଇମ୍‌ଣି କାତା ଇଚାନ୍‌, ହେଦାଂ ହେୱାର୍‌ ବୁଜାୱାତାର୍‍ । ");
INSERT INTO peg_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","ପାଚେ ହେୱାନ୍‌ ହେୱାର୍‌ ହୁକେ ଲେଉଟା ଆଜ଼ି ନାଜରିତିୟତ ୱାତାନ୍‍ ଆରି ହେୱାର୍‌ତି କାତା ମାନିକିଜ଼ି ମାଚାନ୍‌; ଆରେ, ହେ ତେହି ଇ ସବୁ କାତା ଜାଗ୍ରତ୍‌ତାଂ ହେ ମାନ୍ତ ଇଟ୍‌ତାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","ଆରେ, ଜିସୁ ଗିଆନ୍‍ତ ଆରି ଗାଗାଡ଼୍‌ତ, ଆରେ ଇସ୍ୱର୍ତି ଆରି ମାନାୟାର୍‌ତି ଦୟାତ ଗାଜା ଆତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","ତିବିରିୟା କାଇସର୍‌ତି ରାଜ୍‌ କିନାକା ପନ୍ଦର ବାର୍ହୁତ, ଏଚେକାଡ଼୍‌ଦ ପନ୍ତିୟ ପିଲାତ, ଜିହୁଦା ରାଜିତ ରାଜ୍‌ କାମାୟ୍‌ ଆରି ହେରଦ୍‌ ଗାଲିଲିନି ହାନ୍ଦିରାଜା ମାଚାନ୍‌, ଆରେ ତା ଟଣ୍ଡାହି ପିଲିପ୍‌ ଇତୁରିୟା, ଆରି ତ୍ରାକନିତି ରାଜିନି, ଆରେ ଲୁସାନିୟା ଅବିଲିନି ନି ହାନ୍ଦି ରାଜା ମାଚାନ୍‌, ");
INSERT INTO peg_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","ଆରି ହାନାନ ଆରି କୟାପା ମୁଡ଼୍‌ ମାପ୍ରୁହେବାକିନାକାର୍‌ ମାଚାର୍‌, ହେ ଏଚେକାଡ଼୍‌ଦ ଇସ୍ୱର୍ତି ବଚନ୍‌ ବାଟାତ ଜିକରିୟତି ମେହି ଜହନ୍‌ ତାକେ ଏକାୱାତାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","ହେବେତାଂ ବାପ୍ତିସିମ୍‌ ହିନି ଜହନ୍‌ ଜର୍ଦନ୍‌ନି ଲାଗାୟ୍‌ ୱିଜ଼ୁ ନାସ୍‌କୁ ହାଲ୍‌ଜି ପାପ୍‌ କେମା କାଜିଂ “ମାନ୍‌ବାଦ୍‌ଲାୟ୍‌ କିନି ବାପ୍ତିସିମ୍‌ ସୁଣାୟ୍‌ କିଦେଙ୍ଗ୍‌ ଲାଗାତାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","“ଇନେସ୍‌କି ଜିସାୟ୍‌ ବେଣ୍‌ବାକ୍‌ଣାୟ୍‌କିନାକାନ୍‌ ସାସ୍ତର୍‌ତାକେ ଲେକାଆତାତ୍‌ନା, ବାଟାତ ଗାଜା କାଟ୍‌ କିଜ଼ି ମାନି ରକାନ୍ତି କାଟ୍‌, ‘ମାପ୍ରୁତି ହାଜ଼ି ଜାଲ୍‌ଦି କିୟାଟ୍‌, ହେୱାନ୍ତି ରାଜାହାଜ଼ି ହାଣ୍‍କୁ କିୟାଟ୍‌; ");
INSERT INTO peg_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","ସବୁ ବାଟା ବାର୍ତି କିୟା ଆନାତ୍‌, ଆରେ ସବୁ, ମାଡ଼ିଙ୍ଗ୍ ଆରି କୁପ୍‍ଲିଙ୍ଗ୍ ହାରୁ କିୟା ଆନାତ୍‌, ବାଙ୍ଗ୍‍ଟା ହାଜ଼ି ସଲକ୍‌ କିୟାଟ୍‌ ସବୁ ହାଣ୍‍କୁ ଆନାତ୍‌, ଆରେ ଉଚ୍‍ନିଚ୍‍ ବୁମି ସାରିଆ ହାଜ଼ିତ ରଚିଆ ଆନାତ୍‌; ");
INSERT INTO peg_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","ଆରେ, ୱିଜ଼ୁ ପୁର୍ତି ଇସ୍ୱର୍ତି ମୁକ୍ତି ଆନାକା ହୁଡ଼୍‍ନାର୍‍ ।’” ");
INSERT INTO peg_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","ଲାଗିଂ, ହେୱାନ୍‌ ତା ତାକେଣ୍ଡାଂ ବାପ୍ତିସିମ୍‌ ଆଦେଂ କାଜିଂ ହସି ୱାନି ମାନାୟାରିଂ ଇଚାନ୍‌, “କାଲାଟିରାଚ୍‌ନି ଲାତ୍ରା,” ୱାନିଦିନ୍‍ ମାପ୍ରୁତି ଟାକ୍ରିତାଂ ହନ୍ତେଙ୍ଗ୍‌ କାଜିଂ ଇନେର୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ଚେତ୍‌ନା ହିତ୍‍ତାନ୍ ? ");
INSERT INTO peg_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","ଲାଗିଂ ମାନ୍‌ବାଦ୍‌ଲାୟ୍‌ କିନି ହାର୍ଦି ପାଡ଼୍‌ ଉବ୍‌ଜାଣ୍‌ କିୟାଟ୍‌; ଆରେ, “ଅବ୍ରାହାମ୍‌ ତ ମା ଆବା, ଇଞ୍ଜି ମାନେ ମାନେ ଏପେଙ୍ଗ୍‌ ଇନ୍‌ମାଟ୍‌, ଇନାକିଦେଂକି ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ଇଞ୍ଜ୍‌ନାଙ୍ଗା, ଇସ୍ୱର୍‌ ଇ କାଲ୍‌କୁକାଂ ପା ଅବ୍ରାହାମ୍‌ କାଜିଂ ମାଜ଼ି ଉବ୍‌ଜାଣ୍‌ କିଦେଙ୍ଗ୍‌ ଆଡ୍‌ନାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","ଆରେ, ନଙ୍ଗ୍‌ ପା ମାର୍‍କୁକାଂ ଦଲ୍‌ଦ କୁଡ଼େଲ୍‌ ଲାଗାତାତ୍‍ନ୍ନା; ଇମ୍‌ଣି ମାର୍‌କୁ ହାର୍‌ ପାଡ଼୍‌ ଆହ୍‌ୱିତିସ୍‌, ହେଦାଂ କାଦ୍‌ଦି ନାଣିତ ତୁହିୟା ଆନାତ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","ଇବେଣ୍ଡାଂ ମାନାୟାର୍‌ ଜହନ୍‌ତିଂ ୱେନ୍‌ବେଦେଂ ଲାଗାତାନ୍‌, “ତା ଆତିସ୍‌ ଆସେଙ୍ଗ୍‌ ଇନାକା କିନାସ୍‌ ?” ");
INSERT INTO peg_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","ଜହନ୍‌ ହେୱାରିଂ ଉତର୍‌ ହିତାନ୍‌, “ଇନେର୍‌ତି ରିଣ୍ଡାଂ ଆଙ୍ଗିଙ୍ଗ୍‌ ମାନିଙ୍ଗ୍, ହେୱାନ୍‌ ଇନେର୍‌ତି ହିଲୁତ୍‍, ହେଦାଂ ରଞ୍ଜାଙ୍ଗ୍‌ ହିଏନ୍; ଆରେ, ଇନେର୍‌ତି କାଦି ମାନାତ୍‌, ହେୱାନ୍‌ ହେ ଲାକେ କିଏନ୍‍ ।” ");
INSERT INTO peg_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","ସିସ୍ତୁଏନ୍‌ନାକାର୍‌ ପା ବାପ୍ତିସିମ୍‌ ଅଦେଂ ୱାଜ଼ି ତାଙ୍ଗ୍‌ ୱେନ୍‍ବାତାର୍‍, “ଏ ଗୁରୁ, ଆପେଂ ଇନାକା କିନାପ୍‌ ?” ");
INSERT INTO peg_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","ପାଚେ ଜହନ୍‌ ହେୱାରିଂ ଇଚାନ୍‌, “ମି କାଜିଂ ଏଚେକ୍‌ ଲଡ଼ା ଆତାତ୍‌ନ୍ନା, ତା ତାଙ୍ଗ୍‌ ଆଦିକ୍‌ ଏନ୍‌ମାଟ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","ମେଲ୍ୟାର୍‌ ପା ହେୱାନିଂ ୱେନ୍‌ବେଦେଂ ଲାଗାତାର୍‌, ଆରେ, “ଆପେଂ ଇନାକା କିନାପ୍‌ ?” ହେୱାନ୍‌ ହେୱାରିଂ ଇଚାନ୍‌, “ବାଡ଼୍‌କାସ୍‌ତାଂ କି ଟକାୟ୍‌ କିଜ଼ି ଇନେର୍‌ତି ପାଣ୍ଡ୍ରୁ କିମାଟ୍‌, ଆରେ ମି ଦାର୍ମାତାକେ ସାରିମାନାଟ୍‍ ।” ");
INSERT INTO peg_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","ମାନାୟାର୍‌ କାସି ମାନି କାଜିଂ ଆରି ଜହନ୍‌ ଇନେସ୍‌କି କ୍ରିସ୍ଟ ଆନାନ୍‌, ଇଞ୍ଜି ଇଦାଂ ହେୱାନ୍‌ କାଜିଂ ୱିଜ଼ାକାର୍‌ ଜାର୍‌ ଜାର୍‌ ମାନ୍ତ ଗାଣ୍‌ଜୁ କିଜ଼ି ମାନ୍‍ବିତିଲେ, ");
INSERT INTO peg_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","ଲାଗିଂ ଜହନ୍‌ ୱିଜ଼ାକାରିଂ ଉତର୍‌ ହିତାନ୍‌, “ଆନ୍‌ ହିନା ମିଙ୍ଗେଙ୍ଗ୍‌ ଏଜ଼ୁଂତାଂ ବାପ୍ତିସିମ୍‌ ହିଦ୍‍ନାଙ୍ଗା, ମାତର୍‌ ନା ତାଙ୍ଗ୍‌ ଇନେର୍‌ ଆଦିକ୍‌ ସାକ୍ତିକାଟାକାନ୍‌, ୱାନାନା ହେୱାନ୍‌ ତା ପାଣ୍ଡାଇଙ୍ଗ୍‌ ଡରି ରିକ୍‌ତେଂ ସମାନ୍‌ ଆନ୍‌ ଆକାୟ୍‌, ହେୱାନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ପୁଇପୁୟା ଜିବୁନ୍ତ ଆରି ନାଣିତ ବାପ୍ତିସିମ୍‌ ହିନାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","ତା କେଇଦ ହେଚି ମାନାତ୍‌, ଲାଗିଂ ବାରବାନି ତାସ୍‌ ନିର୍ମଲ୍‌ କିଜ଼ି ଟୁଣ୍ଡିତ ଗଁମ୍‌ ରୁଣ୍ଡାୟ୍‌ କିଜ଼ି ଇଡ୍‌ଦେଂ ଇଞ୍ଜି ହେୱାନ୍‌ କେଇଦ ହେଚି ମାନାତ୍‌, ମାତର୍‌ ପୁଟା ୱିଜ଼ୁ ହେୱାନ୍‌ ହାୱିନାଣିତ ଦେସ୍ଇ ତୁହିନାନ୍‍ ।” ");
INSERT INTO peg_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","ହେୱାନ୍‌ ଇ ଲାକେ ବେସି ଉପ୍‌ଦେସ୍‌ ହିଜ଼ି, ଆରେ ବାରବିନି ୱାରି ବେରଣ୍‌ ୱେଚ୍‌ଚି ମାନାୟ୍‌ ଲାଗାଂ ନେକ୍ରିକାବୁର୍‌ ପରଚାର୍‌ କିଜ଼ି ମାଚାନ୍‌; ଆରି ମାନ୍‌ବାଦ୍‌ଲାୟ୍‌ କିନି କାଜିଂ ମାନାୟାରିଂ ବୁଜାୟ୍‌ କିତାନ୍‌ ");
INSERT INTO peg_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","ମାତର୍‌ ଜହନ୍‌ ହାନ୍ଦି ରାଜା ହେରଦ୍‌ତିଂ ଆଦିକ୍‌ ଆଟ୍‌ୱା ଆଜ଼ି ଇଚାନ୍‌ ଇନାକିଦେଂକି ଜାର୍‌ ଟଣ୍ଡେନ୍‌ ଡକ୍ରିଂ ହେରଦିଆତିଂ ବିବା କିଜ଼ି ମାଚାନ୍‌, ଆରି ବେସି ବିସ୍ରେ ବାନ୍ୟା କାମାୟ୍‌ କିଜ଼ି ମାଚାନ୍‌, ");
INSERT INTO peg_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","ହେ ଲାକେ ଆରେ ରଞ୍ଜାଙ୍ଗ୍‌ ହେରଦ୍‌ କାରାପ୍‌ କାମାୟ୍‌ କିତାନ୍‌, ଜହନ୍‌ତିଂ ବନ୍ଦିତ ଇଡ୍‌ତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","ୱିଜ଼ାର୍‍ ମାନାୟାର୍‌ ବାପ୍ତିସିମ୍‌ ଆତି ପାଚେ ଜିସୁ ପା ବାପ୍ତିସିମ୍‌ ଅତାନ୍‌ । ଆରେ ପାର୍ତାନା କିନି ୱେଡ଼ାଲିଙ୍ଗ୍ ବାଦାଡ଼୍‌ ଜେୟା ଆତାତ୍‌, ");
INSERT INTO peg_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","ଆରି ପୁଇପୁୟା ଜିବୁନ୍‌ ଗାଗାଡ଼୍‌ତ ପାଣ୍ଡ୍‌କା ଲାକେ ଜିସୁ ଜପି ଜୁଜ଼ି ୱାଜ଼ି ଜିସୁଙ୍ଗ୍‌ କୁଚ୍‌ଚାତ୍‌; ଆରେ, ବାଦାଡ଼୍‌ତାଂ ଇ ବେରଣ୍‌ ଆତାତ୍‌, “ଏନ୍‌ ମା ୱାରିନି ମାଜ଼ିତି, ମି ତାକେ ମା ବେସି ୱାରି ।” ");
INSERT INTO peg_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","ଜିସୁ କାମାୟ୍‌ ହାଙ୍ଗ୍‍ନି ୱେଡ଼ାଲିଂ ତାଙ୍ଗେଙ୍ଗ୍‌ ତିରିସ୍‌ ବାର୍ହୁ ବୟସ୍‍ ଆଜ଼ି ମାଚାତ୍‌; ଲକାର୍‍ ମାନ୍ତାଙ୍ଗ୍‌ ହେୱାନ୍‌ ଜସେପ୍ ମେହି ମାଚାନ୍‌; ଜସେପ୍‌ ଏଲିତି ମେହି, ");
INSERT INTO peg_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","ଏଲି ମତାତି ମେହି, ମତ୍‍ତାତ ଲେବି ମେହି, ଲେବି ମଲ୍‌କିତି ମେହି, ମଲ୍‌କି ଜନ୍ନୟତି ମେହି, ଜନ୍ନୟ ଜସେପ୍‌ତି ମେହି, ");
INSERT INTO peg_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","ଜସେପ୍‌ ମତିତ୍ୟାତି ମେହି, ମତିତ୍ୟା ଆମସ୍‌ତି ମେହି, ଆମସ୍‌ ନାହୁମ୍‍ତି ମେହି, ନାହୁମ୍‌ ହେଲସିତି ମେହି, ହେଲସି ନଗୟତି ମେହି, ");
INSERT INTO peg_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","ନଙ୍ଗୟ୍‌ ମହତତି ମେହି, ମହତ ମତିତ୍ୟାତି ମେହି, ମତିତ୍ୟା ସିମୟିତି ମେହି, ସିମୟି ଜସେକ୍‌ତି ମେହି, ଜସେକ୍‌ ଜଦାତି ମେହି, ");
INSERT INTO peg_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","ଜଦା ଜହନ୍ତି ମେହି, ଜହନ୍‌ ରେସା ଜିରୁବ୍‍ବାବେଲ୍‍ତି ମେହି, ଜିରୁବାବେଲ୍‌ ସଲ୍‌ଟିୟେଲ୍‌ ମେହି, ସଲ୍‌ଟିୟେଲ୍‌ ନେରିତି ମେହି, ");
INSERT INTO peg_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","ନେରି ମଲ୍‌କିତି ମେହି, ମଲ୍‌କି ଅଦିତି ମେହି, ଅଦି କସାମ୍‌ତି ମେହି, କସାମ୍‌ ଏଲ୍ଲଦାନ୍‌ତି ମେହି, ଏଲୁଦାନ୍‌ ଏରତି ମେହି, ");
INSERT INTO peg_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","ଏର ଜିହସୁୟତି ମେହି, ଜିହସୁୟ୍‌ ଏଲିୟାଜର୍‌ତି ମେହି, ଏଲିୟେଜର୍‌ ଜରିମତି ମେହି, ଜରିମ୍‌ ମତାତି ମେହି, ମତାତ ଲେବିତି ମେହି, ");
INSERT INTO peg_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","ଲେବି ସିମିୟନ୍‌ତି ମେହି, ସମିୟନ୍‌ ଜିହୁଦାତି ମେହି, ଜିହୁଦା ଜସେପ୍‌ତି ମେହି, ଜସେପ୍‌ ଜନାମ୍‍ତି ମେହି, ଜନାମ୍‌ ଏଲିୟାକିମ୍‌ତି ମେହି, ");
INSERT INTO peg_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","ଏଲିୟାକିମ୍‌ ମଲାହତି ମେହି, ମଲାହ ମନ୍ନାତି ମେହି, ମନ୍ନା ମତତାତି ମେହି, ମତତା ନାତନ୍‌ତି ମେହି, ନାତନ୍‌ ଦାଉଦ୍‌ତି ମେହି, ");
INSERT INTO peg_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","ଦାଉଦ୍‌ ଜିସିୟତି ମେହି, ଜିସି ଓବେଦତି ମେହି, ଓବେଦ ବୟଜତି ମେହି, ବୟଜ ସେଲହତି ମେହି, ସେଲହ ନହସନ୍‌ତି ମେହି, ");
INSERT INTO peg_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","ନହସନ ଅମିନାଦବ୍‌ତି ମେହି, ଅମିନାଦାବ୍‌ ଅଦ୍‌ନି ମେହି, ଅଦ୍‌ନି ଅର୍ଣ୍ଣି ମେହି, ଅର୍ଣ୍ଣି ହେସ୍ରଣତି ମେହି, ହେସ୍ରଣ ପେରସ୍‌ତି ମେହି, ପେରସ୍‌ ଜିହୁଦାତି ମେହି, ");
INSERT INTO peg_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","ଜିହୁଦା ଜାକୁବ୍‌ତି ମେହି, ଜାକୁବ୍‌ ଇସ୍‌ହାକ୍‌ତି ମେହି, ଇସାହାକ୍‌ ଅବ୍ରାହାମ୍‌ତି ମେହି, ଅବ୍ରାହାମ୍‌ ତେରହତି ମେହି, ତେରହ ନାହରତି ମେହି, ");
INSERT INTO peg_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","ନାହର୍‌ ସରୁଗତି ମେହି, ସରୁଗ ରଗୁତି ମେହି, ରଗୁ ପେଲଗତି ମେହି, ପେଲଗ ଏବର୍‌ତି ମେହି, ଏବର୍‌ ସେଲହତି ମେହି, ");
INSERT INTO peg_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","ସେଲହ କେନାନ୍‌ତି ମେହି, କେନାନ୍‌ ଅର୍ପକ୍ୟଦତି ମେହି, ଅର୍ପକ୍ୟଦ ସେମ୍‌ତି ମେହି, ସେମ ନହତି ମେହି, ନହ ଲେମକତି ମେହି, ");
INSERT INTO peg_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","ଲେମକ ମିତୁସିଲହତି ମେହି, ମିତୁସିଲାହ ହନକତି ମେହି, ହନକ ଜେରଦତି ମେହି, ଜେରଦ ମହଲଲେଲତି ମେହି, ମହଲଲେଲ କେନାନ୍‌ତି ମେହି, ");
INSERT INTO peg_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","କେନାନ୍‌ ଏନସତି ମେହି, ଏନସ୍‌ ସେତତି ମେହି, ସେତ ଆଦମ୍‌ତି ମେହି, ଆରମ୍‌ ଇସ୍ୱର୍ତି ମେହି । ");
INSERT INTO peg_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","ଜିସୁ ପୁଇପୁୟା ଜିବୁନ୍ତ ବାର୍ତି ଆଜ଼ି ଜର୍ଦନ୍‌ ନାଗୁଡ଼୍‌ତାଂ ମାଜ଼ି ୱାତାନ୍, ଆରି ରିକଡ଼ି ଦିନ୍‍ ପାତେକ୍‌ ଜିବୁନ୍‌ ହୁଦାଂ ବାଟାତ ଚାଲାଆଜ଼ି ସୟ୍‌ତାନ୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ପରିକ୍ୟା କିତାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","ହେବେ ହେୱାନ୍‌ ସୟ୍‌ତାନ୍‌ ହୁକେ ଚାଲିସ୍‌ ଦିନ୍‌ ପାତେକ୍‌ ପରିକ୍ୟା ଆତାନ୍‌ । ହେ ସମୁ ବିତ୍ରେ ହେୱାନ୍‌ ଇନାକା ତିନ୍‌ୱାଦାଂ ମାଚାନ୍‌, ଲାଗିଂ ଚାଲିସ୍‌ ଦିନ୍‌ ୱିସ୍ତିଲେ, ହେୱାନ୍‌ ନାସ୍‌କି ଆତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","ହେବେ ସୟ୍‌ତାନ୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ଇଚାତ୍‌, “ଏନ୍‌ ଜଦି ଇସ୍ୱର୍‌ ମାଜ଼ି, ବାଟିଙ୍ଗ୍‌ ଇ କାଲ୍‌ଦିଂ ରୁଟି ଆଦେଂ ଇଞ୍ଜି ବଲ୍‌ ହିୟା ।” ");
INSERT INTO peg_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","ଜିସୁ ହେଦେଲିଂ ଉତର୍‌ ହିତାନ୍‌, “ଦରମ୍‌ ସାସ୍ତର୍‌ତ ଲେକା ମାନାତ୍‍, ମାନାୟ୍‌ କେବଲ୍‌ ରୁଟିଂ ତିନ୍‌ଞ୍ଜି ବାଚା ଆଉନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","ଆରେ, ସୟ୍‌ତାନ୍‌ ଜିସୁଙ୍ଗ୍‌ ଜପି ଅଜ଼ି ଅଲପ୍‍ ସମୁ ବିତ୍ରେ ପୁର୍ତିନି ସବୁ ରାଜି ହେୱାନିଂ ଚଚ୍‌ଚାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","ଆରେ, ସୟ୍‌ତାନ୍‌ ତାଙ୍ଗ୍‌ ଇଚାତ୍‌, “ଆନ୍‌ ନିଙ୍ଗେଙ୍ଗ୍‌ ଇ ୱିଜ଼ୁ ଆଦିକାର୍‌ ଆରି ଇ ହଲ୍‌ନାକା ହିଦ୍‌ନାଂ, ଇନାକିଦେଂକି ନାଙ୍ଗେଙ୍ଗ୍‌ ଇଦାଂ ୱିଜ଼ୁ ଆଦିକାର୍‌ ହିତ୍‍ତାର୍‌ନ୍ନା, ଆରେ ଆନ୍‌ ଇନେରିଂ ଇଚା, ତାଙ୍ଗ୍‌ ହେଦାଂ ହିଦ୍‌ନାଂ ।” ");
INSERT INTO peg_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","ଲାଗିଂ, “ଏନ୍‌ ଏଚେକାଡ଼୍‌ଦ ମା ମୁମ୍‌ଦ ପୁଜା କିଦ୍‍ନାୟ୍‌, ଲାଗିଂ ୱିଜ଼ୁ ନିନ୍ଦାଂ ଆନାତ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","ଜିସୁ ଉତର୍‌ ହିତାନ୍‌, ସାସ୍ତର୍‌ ଲେକା ମାନାତ୍‌, “ଏନ୍‌ କେବଲ୍‌ ମାପ୍ରୁ ଇସ୍ୱର୍‌ତିଂ ଜୁୱାର୍‌ କିନାୟ୍‌, ଆରେ ହେୱାନ୍ତି ପାର୍ତାନା କିନାୟ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","ଆରେ, ସୟ୍‌ତାନ୍‌ ହେୱାନିଂ ଜିରୁସାଲମ୍‌ତ ଅଜ଼ି ମନ୍ଦିର୍‌ନି ଜେଗନ୍‌ ଜପି ନିଲି କିଜ଼ି ତାଙ୍ଗ୍‌ ଇଚାତ୍‌, “ଏନ୍‌ ଜଦି ଇସ୍ୱର୍‌ ମାଜ଼ି, ତା ଆତିସ୍‌ ଇବେତାଂ ତାରେନ୍‌ ଗୁମା ।” ");
INSERT INTO peg_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","ଇନାକିଦେଂକି ଦରମ୍‌ ସାସ୍ତର୍‌ତ ଲେକା ମାନାତ୍‌, “ନିଙ୍ଗେଙ୍ଗ୍‌ ରାକ୍ୟା କିଦ୍‌ନି କାଜିଂ ହେୱାନ୍‌ ଜାର୍‌ ଦୁତ୍‌ରିଂ ନି ବିସ୍ରେ ବଲ୍‌ ହିନାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","ଦରମ୍‌ ସାସ୍ତର୍‌ତ ଲେକା ମାନାତ୍‌, ଏଚେକାଡ଼୍‌ଦ ନି ପାନା କାଲ୍‌ଦ ଆଡ଼୍‌ଦାନାତ୍‌, ଇଦାଂ କାଜିଂ ହେୱାର୍‌ ନି କେଇଦ ଆସ୍ତାନାର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","ଆରେ, ଜିସୁ ସୟ୍‌ତାନ୍‌ତିଂ ଉତର୍‌ ହିତାନ୍‌, ଦରମ୍‌ ସାସ୍ତର୍‌ତ ଲେକାମାନାତ୍‌, “ଏନ୍‌ ମାପ୍ରୁ ଜାର୍‌ ଇସ୍ୱର୍‌ତିଂ ପରିକ୍ୟା କିଉୟ୍ । ");
INSERT INTO peg_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","ଜିସୁଙ୍ଗ୍‌ ସୟ୍‌ତାନ୍‌ ସବୁ ବାନି ପରିକ୍ୟା ୱିସ୍ତି ପାଚେ କେତେଦିନ୍‌ ପାତେକ୍‌ ତାଙ୍ଗ୍‌ ପିସ୍ତି ହାଚାତ୍ ।” ");
INSERT INTO peg_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","ଇଦାଂ ପାଚେ ଜିସୁ ପୁଇପୁୟା ଜିବୁନ୍‌ନି ସାକ୍ତିତାଂ ଗାଲିଲିତ ଲେଉଟା ଆତାନ୍‌, ଆରେ ଚାରିବେଣ୍‌ତାଂ ସବୁ ରାଜିତ ଇଞ୍ଜେଙ୍ଗ୍‌ ଲାଗାତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","ଆରି, ହେୱାନ୍‌ ହେୱାର୍‌ତି କୁଟୁମ୍‌ ଇଲ୍‌ ଲାଗେ ହିକ୍ୟା ହିଜ଼ି ୱିଜ଼ାର୍‌ତାଂ ଜାଜ୍‌ମାଲ୍‌ ପାୟା ଆଦେଂ ଲାଗାତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","ଜିସୁ ଇମ୍‌ଣି ନାଜରିତିୟ ପାଲିକିୟା ଆଜ଼ି ମାଚାନ୍‌, ହେ ବାହାତ ହାରିହାରା ହାଚାନ୍‌ ଆରି ନିଜାର୍‌ ବିଦିତାଂ ଜମ୍‌ନିବାର୍‌ତ କୁଟୁମ୍‌ ଇଞ୍ଜ ହଟାନ୍‌, ଆରେ ସାସ୍ତର୍‌ ପଡ଼ି କିଦେଙ୍ଗ୍‌ ଇଞ୍ଜି ନିଲ୍‌ତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","ହେବେଣ୍ଡାଂ ଜିସାୟ୍‌ ବେଣ୍‌ବାକ୍‌ଣାୟ୍‌କିନାକାନ୍ତି ପତି ତାଙ୍ଗେଙ୍ଗ୍‌ ହିତାର୍‌, ଆରେ ଜିସୁ ହେଦାଂ ଉନ୍‌ଦି, ଇମେତାକେ ଇ ବଚନ୍‌ ଲେକାଆତାତ୍‌ନା ହେଦାଂ ହୁଡ଼୍‌ତାନ୍‌, ");
INSERT INTO peg_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","ମାପ୍ରୁତି ଜିବୁନ୍‌ ନା ତାକେ ଜୁତ୍‌ତାନ୍ନା, “ଲାଗିଂ ଇନାକା ହିଲାକାର୍‌ ଲାଗେ ନେକ୍ରିକାବୁର୍‌ ସୁଣାୟ୍‌ କିଦେଙ୍ଗ୍‌ ଇଞ୍ଜି ହେୱାନ୍‌ ନାଙ୍ଗେଙ୍ଗ୍‌ ସିଗ୍‌କିତ୍‌ନ୍ନା, ଜଇଲ୍‌ ମାନାକାରିଂ ମୁକ୍ତି କିନାକା ଆରି କାଣାର୍‍ତାକେ ଲାଗେ ହୁଡ଼ିକିଦେଂ ବିସ୍ରେ ସୁଣାୟ୍‌ କିଦେଙ୍ଗ୍‌, ଆରେ କସ୍ଟପାୟାଆନି ଲଗାଂ ମୁକ୍ତି କିଦେଙ୍ଗ୍‌, ");
INSERT INTO peg_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","ଆରେ ମାପ୍ରୁତି ଦୟାନିବାର୍‌ହୁ ସୁଣାୟ୍‌ କିଦେଙ୍ଗ୍‌ ହେୱାନ୍‌ ନାଙ୍ଗେଙ୍ଗ୍‌ ପକ୍‌ତାତାନ୍ନା ।” ");
INSERT INTO peg_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","ପାଚେ ହେୱାନ୍‌ ପତି ଡାବାୟ୍‌ କିଜ଼ି ହେବା କିନାକାରିଂ ହେଦାଂ ହିଜ଼ି କୁଚ୍‌ଚାନ୍‌, ଆରେ କୁଟୁମ୍‌ ଇଞ୍ଜ ୱିଜ଼ାର୍‌ତି କାଣ୍‌କୁ ହେୱାନ୍‌ ଜପି ହୁଡ଼୍‌ଜି ମାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","ପାଚେ, “ହେୱାନ୍‌ ହେୱେରିଂ ଇଞ୍ଜେଙ୍ଗ୍‌ ଲାଗାତାନ୍‌, ନେଜେଙ୍ଗ୍‌ ଦରମ୍‌ ସାସ୍ତର୍‌ ଇ ବଚନ୍‌ ଏପେଙ୍ଗ୍‌ ୱେଚିଲେ ହେଦାଂ ପୁରାଆତାତ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","ଆରେ, ୱିଜ଼ାର୍‌ ହେୱାନ୍‌ ବିସ୍ରେ ସାକି ହିଦେଂ ଲାଗାତାର୍‌ ଆରେ ହେ ୱେଇତାଂ ଇମ୍‌ଣି ଦୟାନି ବଚନ୍‌ତ ହିଜ଼ି ୱାଜ଼ି ମାଚାତ୍‌; ଆରି ହେୱାର୍‌ ଇଞ୍ଜେଙ୍ଗ୍‌ ଲାଗାତାର୍‌, “ଇୱାନ୍‌ ଇନାକା ଜସେପ୍‌ ମେହି ଆକାୟ୍‌ ?” ");
INSERT INTO peg_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","ହେବେଣ୍ଡାଂ ହେୱାନ୍‌ ଉତର୍‌ମୁଡ଼୍‌ ହେୱେରିଂ ଇଚାନ୍‌, “ଏପେଙ୍ଗ୍‌ ଇନେସ୍‌ କିତିସ୍‌ପା ନାଙ୍ଗେଙ୍ଗ୍‌ ଇ ଟିକଲ୍ ବେରଣ୍‌ ୱେଚ୍‍ଚାନାଦେର୍‌, ହେ ଡାକ୍ତର୍‌ ନିଜେ ନିଜ୍‌ତିଂ ଉଜ୍‌ ଆ; ଆରେ ଇନାନ୍‌ କପର୍ନାହୁମ୍‌ ଇନା ଇନାକା ଗିଟା ଆତାତ୍‌ନ୍ନା ଇଞ୍ଜି ଆପେଂ ୱେଚ୍‌ଚାପ୍‌ନା, ହେ ସବୁ ଇ ବାହାତ ନିଜ୍‌ ଦେସ୍‌ ଗାଡ଼୍‌ଦପା କିୟା ।” ");
INSERT INTO peg_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","ଆରେ, ହେୱାନ୍‌ ଇଚାନ୍‌, “ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ହାତ୍‌ପା ଇଞ୍ଜେନାଙ୍ଗ୍‌, ଇମ୍‌ଣି ବେଣ୍‌ବାକ୍‌ଣାୟ୍‌ କିନାକାନ୍‌ ନିଜ୍‌ ଗାଡ଼୍‌ଦ ମାନ୍‌ କିୟାଆଉନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","“ମାତର୍‌ ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ହାତ୍‌ପା ଇଞ୍ଜ୍‌ନାଙ୍ଗ୍‌, ଏଲିୟତି ସମୁଦ ଏଚେକାଡ଼୍‌ଦ ତିନିବାର୍‌ହୁ ଚଅମାସ୍‌ ପାତେକ୍‌ ଆକାସ୍‌ତାଂ ବାର୍‌ହା ଆୱିତିଲେ ସବୁ ଦେସ୍‌ତ କାତାର୍‌ ଆର୍‌ତାତ୍‌, ହେ ପାଦ୍‌ନା ଇସ୍ରାଏଲ୍‌ ବିତ୍ରେ ହେନି ରାଣ୍ଡିକ୍‌ ମାଚିକ୍‌; ");
INSERT INTO peg_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","ଆତିସ୍‌ପା ଏଲିୟ ହେୱାର୍‌ତି ଇନେର୍‌ ତାକେପା ପକ୍ୟା ଆୱାଦାଂ କେବଲ୍‌ ସିଦନ୍‌ ଦେସ୍‌ନି ସାରିପତ୍‌ତିଂ ର ରାଣ୍ଡି କଗ୍‌ଲେ ଲାଗେ ପକ୍ୟା ଆତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","ପାଚେ, ବେଣ୍‌ବାକ୍‌ଣାୟ୍‌କିନାକାନ୍‌ ଇଲିସାୟ୍‌ନି ସମୁତ ଇସ୍ରାଏଲ୍‌ ବିତ୍ରେ ବେସି ଗାଜା ରଗ୍ୟାର୍‌ ମାଚାର୍‌; ଆତିସ୍‌ପା ହେୱାର୍‌ ବିତ୍ରେ ଇନେର୍‌ପା ଉଜ୍‌ ଆୱାଦାଂ ମାଚାର୍‌, କେବଲ୍‌ ସିରିୟା ଦେସ୍‌ନି ନାମାନ୍‌ ସକଟ୍‌ କିୟା ଆଜ଼ି ମାଚାର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","କୁଟୁମ୍‌ ଇଞ୍ଜ ଇ ସବୁ ବେରଣ୍‌ ୱେନୁ ୱେନୁ ୱିଜ଼ାର୍‌ ରିସା ଆତାର୍‌, ");
INSERT INTO peg_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","ଆରେ ହେୱାର୍‌ ନିଙ୍ଗ୍‌ଜି ତାଙ୍ଗେଙ୍ଗ୍‌ ଗାଡ଼୍‌ତାଂ ହପ୍‌ତାତାର୍‌ ଆରି ହେୱାର୍‌ତି ଗାଡ଼୍‌ ଇମ୍‌ଣି ମାଡ଼ି ଜପି ରଚ୍‌ଚିମାଚାର୍‌, ହେ ୱେଡ଼ାଙ୍ଗ୍‌ ଦାରିଆ ବାହାତ ତାରେନ୍‌ ତୁଇଦେଙ୍ଗ୍‌ ଇଞ୍ଜି ହେୱାନିଂ ହେବେ ଅଜ଼ି ହାଚାର୍; ");
INSERT INTO peg_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","ମାତର୍‌ ଜିସୁ ହେୱାର୍‌ ବିତ୍ରେ ହିଜ଼ି ବୁଲାଆଜ଼ି ହାଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","ହେୱାନ୍‌ କପର୍ନାହୁମ୍‌ ତର୍‌ଦି ଗାଲିଲିତ ର ଗାଡ଼୍‌ଦ ୱାତାନ୍‌, ଜମ୍‌ନିବାର୍‌ ୱେଡ଼ାଙ୍ଗ୍‌ ମାନାୟାରିଂ ହିକ୍ୟା ହିକାୟ୍ କିଦେଙ୍ଗ୍‌ ଲାଗାତାନ୍‌, ");
INSERT INTO peg_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","ଆରେ ହେୱାର୍‌ ହେୱାନ୍‌ତି ହିକ୍ୟାତ କାବା ଆତାର୍‌, ଇନାକିଦେଂକି ହେୱାନ୍ତି ବଚନ୍‌ ଆଦିକାର୍‌ ମେହା ମାଚାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","ଦିନେକ୍‌ କୁଟୁମ୍‌ ଇଞ୍ଜ ରୱାନ୍‌ ରାଡ଼ା ପୁଦା ଆହିୟା ଆତାକାନ୍‌ ମାଚାନ୍‌; ହେୱାନ୍‌ ଗାଜାକାଟ୍‌ତାଂ ହିର୍‌ବାତାନ୍‌, ");
INSERT INTO peg_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“ଆ, ନାଜରିତିୟ ଜିସୁ, ମା ଲାହାଙ୍ଗ୍‌ ମିଦାଙ୍ଗ୍‌ ଇନାକା ମାନାତ୍‌ ? ଏନ୍‌ କି ମାଙ୍ଗେଙ୍ଗ୍‌ ନସ୍ଟ କିଦେଙ୍ଗ୍‌ ୱାତାଇନା ? ଏନ୍‌ ଇନେର୍‌ ହେଦାଂ ଆନ୍‌ ପୁନାଙ୍ଗ୍‌; ଏନ୍‌ ଇସ୍ୱର୍‌ ମାପ୍ରୁତି ହେ ପୁଇପୁୟା ମାନାୟ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","ଜିସୁ ହେଦେଲିଂ ଦାକା ହିଜ଼ି ଇଚାନ୍‌, “ଚିମ୍‌ରା ଆ, ଇବେଣ୍ଡାଂ ହସି ହାଲା ।” ହେବେଣ୍ଡାଂ ହେ ବୁତ୍‌ ହେୱେନିଂ ୱିଜ଼ାର୍‌ ମୁମ୍‌ଦ ତୁହିଜି ହେୱାନ୍ତି ଇନାକା କସ୍ଟ ହିୱାଦାଂ ହେୱାନ୍‌ତାଂ ହସି ହାଚାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","ଇବେଣ୍ଡାଂ ୱିଜ଼ାର୍‌ କାବା ଆଜ଼ି ହେୱେର୍‌ ହେୱାର୍‌ ୱେଚ୍‌ପା ଆତାର୍‌, “ଇଦାଂ ଇନା ବେରଣ୍‌ ? ହେୱାନ୍‌ ଆଦିକାର୍‌ ସାକ୍ତିତାଂ ହେୱାନ୍‌ ବାନ୍ୟା ଜିବୁନ୍‌ତିଂ ପା ବଲ୍‌ ହିନାନା, ଆରେ ହେୱାଙ୍ଗ୍‌ ହିଜ଼ି ହାନିକ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","ହେବେଣ୍ଡାଂ ହେୱାନ୍‌ ବିସ୍ରେ ବେରଣ୍‌ ଚାରବେଣ୍‌ତାଂ ନାସ୍‌କୁକାଂ ୱିଣ୍‌ଜି ହାଚାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","ପାଚେ ଜିସୁ କୁଟୁମ୍‌ ଇଞ୍ଜ ନିଙ୍ଗ୍‌ଜି ସିମନାର୍‌ ଇଞ୍ଜ ହାଚାନ୍‌ । ସିମନ୍‌ ପଦାହିଙ୍ଗ୍‌ ବେସି ନମେର୍‌ ଆଜ଼ି ମାଚାତ୍‌, ଆରେ ହେୱାର୍‌ ତା ବିସ୍ରେ ହେୱାନିଂ ଗୱାରି କିତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","ହେବେଣ୍ଡାଂ ହେୱାନ୍‌ ହେ ଲାଗାୟ୍‌ ନିଲ୍‌ଚି ନମେର୍‌ତିଂ ଦାକା ହିତାନ୍‌, ଆରି ହେଦେଲିଂ ନମେର୍‌ ପିସ୍ତାତ୍‌, ପାଚେ ହେଦେଲ୍‌ ହେ ସାଙ୍ଗେ ସାଙ୍ଗେ ନିଙ୍ଗ୍‌ଜି ହେୱାର୍‌ତି ହେବା କିଦେଙ୍ଗ୍‌ ଲାଗାତାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","ୱେଡ଼ାହାନି ସମୁତ, ଇନେର୍‌ ଲାଗାଂ ବାର୍‌ବିନ୍‌ ରଗ୍‌ ଆତି ମାନାୟାର୍‌ ମାଚାର୍‌, ହେୱାର୍‌ ୱିଜ଼ାର୍‌ ହେୱାରିଂ ଜିସୁ ଲାଗେ ତାଇୱାତାର୍‌ ଆରି ହେୱାନ୍‌ ୱିଜ଼ାର୍‌ ମାନାୟ୍‌ଜପି କେଇ ଇଡ଼୍‌ଜି ହେୱାରିଂ ଉଜ୍‌ କିତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","ପାଚେ, ବୁତ୍‌କୁପା କିକିରାଡିଂ କିଜ଼ି କିଜ଼ି “ଏନ୍‌ ଇସ୍ୱର୍‌ ମାଜ଼ି” ଇଞ୍ଜି ୱେନ୍‌ଞ୍ଜି ବେସି ଲଗାର୍‌ତାଂ ହସି ହାଚିକ୍‌ ଆରେ, ଜିସୁ ହେୱେରିଂ ଦାକା ହିଜ଼ି ବେରଣ୍‌ ଇଞ୍ଜେଙ୍ଗ୍‌ ହିୱାତାନ୍‌, ଇନାକିଦେଂକି ହେୱାନ୍‌ ଜେ କ୍ରିସ୍ଟ, ଇଦାଂ ହେୱାଙ୍ଗ୍‌ ପୁଞ୍ଜି ମାଚିକ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","ନାଣାଙ୍ଗେ ଆନିହିଙ୍ଗ୍‌, ହେୱାନ୍‌ ଗାଡ଼୍‌ଦାଂ ହସି ର ଚିମ୍‌ରା ବାହାତ ହାଚାନ୍‌; ଆରି, ମାନାୟାର୍‌ ତାକେ ହେୱାନିଂ ଦାସ୍‌ତେଂ ହେ ଲାଗେ ୱାତାର୍, ଆରେ ହେୱାନ୍‌ ଇନେସ୍‌ ହେୱାର୍‌ତାଂ ହାଜେଙ୍ଗ୍‌ ଆଡୁନ୍‌, ହେଦାଂ କାଜିଂ ହେୱାନିଂ ଟେବାୟ୍‌ କିଦେଙ୍ଗ୍‌ ସେସ୍ଟା କିତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","ମାତର୍‌ ହେୱାନ୍‌ ହେୱାରିଂ ଇଚାନ୍‌, “ବିନ୍‌ ବିନ୍‌ ଗାଡ଼୍‌ଦ ପା ନାଙ୍ଗେଙ୍ଗ୍‌ ଲଡ଼ା ମାପ୍ରୁ ରାଜିନି ନେକ୍ରିକାବୁର୍‌ ସୁଣାୟ୍‌ କିଦେଙ୍ଗ୍‌ ଆନାତ୍‌, ଇନାକିଦେଂକି ହେଦାଂ କାଜିଂ ଇସ୍ୱର୍‌ ନାଙ୍ଗେଙ୍ଗ୍‌ ପକ୍‌ତାତାନ୍ନା ।” ");
INSERT INTO peg_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","ପାଚେ, ହେୱାନ୍‌ ଜିହୁଦା ଦେସ୍‌ନି କୁଟୁମ୍‌ ଇଞ୍ଜ ସୁଣାୟ୍‌ କିଦେଙ୍ଗ୍‌ ଲାଗାତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","ଦିନେକ୍‌ ଜିସୁ ଗିନେସରତ୍‌ ହମ୍‌ଦୁର୍‌ ଗୁଟିତ ନିଲ୍‌ଚି ମାଚାନ୍‌; ଆରି ମାନାୟାର୍‌ ଗହଲିତ ହେୱାନ୍‌ ଜପି ତବ୍‌ଗା ଆଜ଼ି ଇସ୍ୱର୍‌ ମାପ୍ରୁ ବଚନ୍‌ ୱେନ୍‌ଞ୍ଜି ମାଚାର୍‌, ");
INSERT INTO peg_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","ଆରି, ହେୱାନ୍‌ ହାମ୍‌ଦୁର୍‌ ଗୁଟିତ ରିଣ୍ଡାଂ ଡଙ୍ଗାଙ୍ଗ୍‌ ମାନାକା ହୁଡ଼୍‌ତାର୍‌; ମିନ୍‌କୁ ଆହ୍‌ନାକାର୍‌ ହେବେଣ୍ଡାଂ ଜୁଜ଼ି ଜାଲ୍‌ ନୁସ୍‌ଦି ମାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","ହେ ଡଙ୍ଗାଙ୍ଗ୍‌ ବିତ୍ରେତାଂ ଇମ୍‌ଣାକା ସିମନ୍‌ତି ମାଚାତ୍‌, ହେବେ ହେୱାନ୍‌ ଦୁମ୍‌ଜି ମେଦ୍‌ନିତାଂ ଅଲପ୍‍ ଦେହା ହାଜେଙ୍ଗ୍‌ ଇଞ୍ଜି ହେୱାନିଂ ଗୱାରି କିତାନ୍‌; ଆରେ, ହେୱାନ୍‌ କୁଚ୍‌ଚି ଡଙ୍ଗାତାଂ ହେନି ମାନାୟାର୍‌ତ ହିକ୍ୟା ହିଦେଂ ଲାଗାତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","ଜିସୁ ବେରଣ୍‌ ୱିସ୍ତି ସିମନ୍‌ତିଂ ଇଚାନ୍‌, “ଏଜ଼ୁଂ ବିତ୍ରେ ହାଲ୍‌ଜି ମିନ୍‌କୁ ଆସ୍ତେଙ୍ଗ୍‌ ଇଞ୍ଜି ମିୱାଙ୍ଗ୍‌ ଜାଲ୍‌ ଇଡ଼ାଟ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","ଇବେଣ୍ଡାଂ ସିମନ୍‌ ଉତର୍‌ ହିତାନ୍‌, “ଏ ଗୁରୁ, ଆପେଂ ହାର୍‌ତାନାଣା କାମାୟ୍‌ କିଜ଼ି ଇନାକା ଆହ୍‌ୱାତାତ୍ମା; ମାତର୍‌ ନି କାତାତାଂ ଆନ୍‌ ଜାଲ୍‌ ଇଡ଼୍‌ନାଙ୍ଗା ।” ");
INSERT INTO peg_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","ଆରି, ହେୱାର୍‌ ହେଦାଂ ଇଡ଼୍‌ଜି ବେସି ମିନ୍‌କୁ ଆସ୍ତାର୍‌, ପାଚେ ହେୱାର୍‌ତି ଜାଲ୍‌ ନାଡ୍‌ବେଦେଂ ଲାଗାତାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","ହେବେଣ୍ଡାଂ ହେୱାର୍‌ ଇମ୍‌ଣି ତା ହାଙ୍ଗ୍‌ଦାକାର୍‌ ମାଚାର୍‌ ଅଲ୍‌ଗା ଡଙ୍ଗାତାକେ ମାଚାର୍‌, ହେୱାର୍‌ ଇନେସ୍‌ ୱାଜ଼ି ହାଙ୍ଗ୍‌ କିତାର୍‌, ଇଦାଂ କାଜିଂ ହେୱାର୍‌ ହେୱାରିଂ କୁକ୍ତାର୍‌ । ଇବେଣ୍ଡାଂ ହେୱାର୍‌ ୱାଜ଼ି ରିଣ୍ଡାଂ ଡଙ୍ଗାକାଂ ଏଲେଙ୍ଗ୍‌ ବାର୍ତି କିତାର୍‌ ଜେ, ହେୱାଙ୍ଗ୍‌ ମୁଞ୍ଜ୍‌ନି ଲାକେ ଆତାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","ମାତର୍‌ ସିମନ୍‌ ପିତର୍‌ ଇଦାଂ ହୁଡ଼୍‌ଜି ଜିସୁଙ୍ଗ୍‌ କାଲ୍‌କୁ ତାରେନ୍‌ ଦାଣ୍ଡ୍‌ହାଣ୍‌ ମାଗ୍‌ଜି ଇଚାନ୍‌, “ଏ ମାପ୍ରୁ ନା ଲାଗେତାଂ ହାଲା, ଲାଗିଂ ଆନ୍‌ ରୱାଙ୍ଗ୍‌ ପାପି ମାନାୟ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","ଇନାକିଦେଂକି ହେୱାର୍‌ ହେ ବାହାତ ଏଚେକ୍‌ ମିନ୍‌କୁ ଆସ୍ତାର୍‌ ଜେ ହେଦାଂ ହୁଡ଼୍‌ଜି ହେୱାନ୍‌ ଆରେ ତା ହାଙ୍ଗ୍‌ଦାକାର୍‌ କାବା ଆତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","ଆରି, ଜେବ୍‌ଦିର୍‌ନି ରିୟାର୍‌ ମାଜ଼ି ମାଚାର୍‌ ଜାକୁବ୍‌ ଆରି ଜହନ୍‌, ଇମ୍‌ଣାକାର୍‌ କି ସିମନ୍‌ତିଂ ମେହାୟ୍‌କିଜ଼ି ମାଚାର୍‌, ହେୱାର୍‌ ବିତ୍ରେ ହେ ଲାକେ କାବା ଆତାର୍‌ । ଆରେ, ଜିସୁ ସିମନ୍‌ତିଂ ଇଚାନ୍‌, “ପାଣ୍ଡ୍ରା ଆମା, ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ମାନାୟ୍‌ ଆହ୍‌ନାକା ହିକାଇ କିଦ୍‌ନାଙ୍ଗ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","ହେବେଣ୍ଡାଂ ହେୱାର୍‌ ଡଙ୍ଗାଙ୍ଗ୍‌ ଗୁଟିତ ତାସି ୱିଜ଼ୁ ପିସ୍ତି ଜିସୁ ପାଚେ ପାଚେ ହାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","ରଗ ଜିସୁ ଗାଡ଼୍‌ଦ ମାନି ସମୁତ, ହୁଡ଼ା, ଗାଜାରଗ୍‌ କାଟାକାନ୍‌ ହେ ବାହାତ ମାଚାନ୍‌; ହେୱାନ୍‌ ଜିସୁଙ୍ଗ୍‌ ହୁଡ଼୍‌ଜି ମୁମ୍‌ ତାରେନ୍‌ କିଜ଼ି ତାଙ୍ଗେଙ୍ଗ୍‌ ଗୱାରି କିଜ଼ି ଇଚାନ୍‌, “ଏ ମାପ୍ରୁ ଏନ୍‌ ଜଦି ଇଚା କିନାୟ୍‌, ତା ଆତିସ୍‌ ନାଙ୍ଗେଙ୍ଗ୍‌ ସକଟ୍‌ କିଦେଙ୍ଗ୍‌ ଆଡ଼୍‌ଦାନାୟ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","ହେବେଣ୍ଡାଂ ହେୱାନ୍‌ କେଇ ଲାମାୟ୍‌ କିଜ଼ି ହେୱାନିଂ ଡୁବିସ୍ ଇଚାନ୍‌, “ଆନ୍‌ ଇଚା କିନାଙ୍ଗା, ସକଟ୍‌ ଆ ।” ହେ ଦାପ୍ରେ ଗାଜାରଗ୍‌ ତା ତାକେଣ୍ଡାଂ ଦେହା ଆତାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","ଆରେ, ଜିସୁ ତାଙ୍ଗେଙ୍ଗ୍‌ ବଲ୍‌ ହିଜ଼ି ଇଚାନ୍‌ ଇନେରିଂପା ୱେଚ୍‌ମା, ମାତର୍‌ “ହାଲ୍‌ଜି ମାପ୍ରୁହେବାକିନାକାନିଂ ତାକେ ହାଲା ନିଜେ ଚଚ୍‌ୟା, ଆରି ମସାତି ବଲ୍‌ ଇସାବ୍‌ରେ ଜାର୍‌ତି ନିର୍ମଲ୍‌ ଲାକେ ହେୱାର୍‌ ଲାଗାଂ ସାକି ହିନି କାଜିଂ ପୁଜା କିୟା ।” ");
INSERT INTO peg_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","ମାତର୍‌ ହେୱାନ୍ତି ବେଣ୍‌ନି କାତା ଆରି ବେସି ୱିଣିତାତ୍‌, ଆରି ବେସି ମାନାୟାର୍‌ ୱେଞ୍ଜେଙ୍ଗ୍‌ ଇଞ୍ଜି ଆରେ ଜାର୍‌ ଜାର୍‌ ରଗ୍‌ତାଂ ଉଜ୍‌ ଆଦେଂ ଇଞ୍ଜି ରୁଣ୍ଡା ଆଦେଂ ଲାଗାତାର୍‌; ");
INSERT INTO peg_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","ମାତର୍‌ ହେୱାନ୍‌ ଚିମ୍‌ରା ବାହାକାଂ ମାନ୍‌ଞ୍ଜି ପାର୍ତାନା କିଜ଼ି ମାଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","ଦିନେକ୍‌ ଜିସୁ ହିକାୟ୍‌ କିଜ଼ି ମାଚାନ୍‌, ଆରି ଗାଲିଲିନି ସବୁ ନାସ୍‌କୁ, ଆରେ ଜିହୁଦା ଦେସ୍‌ ଆରେ ଜିରୁସାଲମ୍‌ତାଂ ୱାନାକାରିଂ ପାରୁସି ଆରେ ମସାତି ବିଦି ଗୁରୁର୍‌ ଲାଗେନେ କୁଚ୍‌ଚି ମାଚାର୍‌ । ଆରି, ହେୱାନ୍‌ ଇନେସ୍‌ ରଗିଂ ଉଜ୍‌ କିନାନ୍‌, ଇଦାଂ କାଜିଂ ମାପ୍ରୁତି ସାକ୍ତି ହେବେ ମାଚାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","ଆରେ ହୁଡ଼ାଟ୍‌, କେତେକ୍‌ ଲଗୁ ର ପାକା ୱାଚ୍‍ୟାତି ରଗି ମାନାୟ୍‌ତିଂ କାଟେଲ୍‌ତ ପିଣ୍ଡ୍‌ଜି ତାସି ବିତ୍ରେ ଅଦେଂ କାଜିଂ ଆରି ଜିସୁଙ୍ଗ୍‌ ମୁମ୍‌ଦ ଇଡ଼୍‌ଦେଂ କାଜିଂ ସେସ୍ଟା କିଜ଼ି ମାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","ମାତର୍‌ ବିଡ଼୍‌ ଲାଗିଂ ତାଙ୍ଗେଙ୍ଗ୍‌ ବିତ୍ରେ ଅଦେଂ କାଜିଂ ହାଜ଼ି ଗାଟାୱାତିଲେ ହେୱାର୍‌ ଇଲ୍‌ ଚାଉଣି ହାଲ୍‌ଜି ଜେଗନ୍‌ ଜେସ୍‍ସି କାଟେଲ୍‌ ହୁକେ ତାଙ୍ଗ୍‌ ମାଦ୍‍ଣି ବାହାତ ଜିସୁ ମୁମ୍‌ଦ ଜୁତ୍‍ତାର୍‍ । ");
INSERT INTO peg_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","ହେୱାନ୍‌ ହେୱାର୍‌ ପାର୍ତି କିନାକା ହୁଡ଼୍‌ଜି ଇଚାନ୍‌, “ଏ ମାନାୟ୍‌, ନି ୱିଜ଼ୁ ପାପ୍‌ କେମା କିୟା ଆତାତ୍‌ନ୍ନା ।” ");
INSERT INTO peg_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","ହେବେ ସାସ୍ତିର୍‌ ଆରି ପାରୁସିର୍‌ ଜାର୍‌ ଜାର୍‌ ବିତ୍ରେ ଏଲେଙ୍ଗ୍‌ ଇଞ୍ଜେଙ୍ଗ୍‌ ଲାଗାତାର୍‌, ଇୱାନ୍‌ ଜେ ଇସ୍ୱର୍‌ ନିନ୍ଦା କିନାନା, “ଇୱାନ୍‌ ଇନାକାନ୍‌ ? କେବଲ୍‌ ଇସ୍ୱର୍‌ ପିସ୍ତି ଆରେ ଇନେର୍‌ ପାପ୍‌ କେମା କିଦେଙ୍ଗ୍‌ ଆଡ଼୍‌ଦାନାନ୍‌ ?” ");
INSERT INTO peg_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","ମାତର୍‌ ଜିସୁ ହେୱାର୍‌ତି କାତାବାର୍ତା ପୁଞ୍ଜି ହେୱାରିଂ ଉତର୍‌ ହିତାନ୍‌, “ଏପେଙ୍ଗ୍‌ ଜାର୍‌ ଜାର୍‌ ମାନ୍ତ ଇନାକା କାତାବାର୍ତା କିନାଦେରା ? ");
INSERT INTO peg_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","ଇନାକା ଆଡ଼୍‌ୱା ? ନି ୱିଜ଼ୁ ପାପ୍‌ ସବୁ କେମା କିୟା ଆତାତ୍‌ ଇଞ୍ଜି ଇନାକା, କି ନିଙ୍ଗା, ତାଙ୍ଗା ଇଞ୍ଜି ଇନାକା ?” ");
INSERT INTO peg_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","ମାତର୍‌ ପୁର୍ତିତ ପାପ୍‌ କେମା କିଦେଙ୍ଗ୍‌ ମାନାୟ୍‌ ମାଜ଼ିତି ଆଦିକାର୍‌ ମାନାତ୍‌, ଇଦାଂ ଇନେସ୍‌ ଏପେଙ୍ଗ୍‌ ପୁନାଦେର୍‌ ଇଦାଂ କାଜିଂ ହେୱାନ୍‌ ହିର୍‍କଲ୍‍ଇଡ଼୍‌ୟାତି ରଗିଂ ଇଚାନ୍‌, “ଆନ୍‌ ନିଙ୍ଗ୍‌ ଇଞ୍ଜ୍‌ନାଙ୍ଗା, ନିଙ୍ଗା, ନି କାଟେଲ୍‌ ଆସ୍ତି ଜାର୍‌ ଇଞ୍ଜ ହାଲା ।” ");
INSERT INTO peg_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","ହେବେତାଂ ହେୱାନ୍‌ ଦାପ୍ରେ ହେୱାର୍‌ ମୁମ୍‌ଦ ନିଙ୍ଗ୍‌ଜି, ଇମ୍‌ଣି କାଟେଲ୍‌ ଜପି ହେୱାନ୍‌ ହୁନ୍‌ଜି ମାଚାନ୍‌, ହେଦାଂ ଅଜ଼ି ଗାଜା ଇସ୍ୱର୍ତି କେର୍‌ଜି କିଜ଼ି କିଜ଼ି ଜାର୍‌ ଇଞ୍ଜ ହାଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","ହେବେ ୱିଜ଼ାକାର୍‌ କାବା ଆଜ଼ି ଇସ୍ୱର୍ତି କେର୍‌ଦେଙ୍ଗ୍‌ ଲାଗାତାର୍‌ ଆରି ବେସି ପାଣ୍ଡ୍ରା ଆଜ଼ି ଇଚାର୍‌, “ନେଞ୍ଜେଙ୍ଗ୍‌ ଆପେଙ୍ଗ୍‌ କି କାବାଆନି ଗଟ୍‌ଣା ହୁଡ଼୍‌ତାପ୍‌ !” ");
INSERT INTO peg_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","ଇବେଣ୍ଡାଂ ଜିସୁ ହସି ହାଲ୍‌ଜି ଲେବି ତର୍‌ଦାକାନ୍‌ ରୱାନ୍‌ ସିସ୍ତୁଏନ୍‌ନାକାନ୍‌ ଏନ୍‌ନି ବାହାତ କୁଚ୍‌ଚି ମାନାକା ହୁଡ଼୍‌ଜି ତାଙ୍ଗ୍‌ ଇଚାନ୍‌, “ନା ପାଚେ ୱା ।” ");
INSERT INTO peg_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","ହେବେଣ୍ଡାଂ ଲେବି ୱିଜ଼ୁ ପିସ୍ତି ନିଙ୍ଗ୍‌ଜି ତା ପାଚେ ହାଞ୍ଜେଙ୍ଗ୍‌ ଲାଗାତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","ଆରେ, ଲେବି ଜାର୍‌ ଇଞ୍ଜ ହେଦାଂ କାଜିଂ ର ଗାଜାବଜି କିତାନ୍‌, ଆରେ ବେସି ହେନି ସିସ୍ତୁଏନ୍‌ନାକାର୍‌ ଆରି ବିନ୍‌ ବିନ୍‌ ଲକୁ ହେୱାର୍‌ ହୁକେ ଚିଞ୍ଜେଙ୍ଗ୍‌ କୁଚ୍‌ଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","ହେବେଣ୍ଡାଂ ପାରୁସିର୍‌ ଆରି ହେୱାର୍‌ କୁଦାନି ସାସ୍ତିର୍‌ ତା ଚେଲାର୍‌ ବିରୁତ୍‌ତାଂ ଇଞ୍ଜେଙ୍ଗ୍‌ ଲାଗାତାର୍‌, “ଏପେଙ୍ଗ୍‌ ଇନେକିଦେଂ ସିସ୍ତୁଏନ୍‌ନାକାର୍‌ ଆରି ପାପିୟାର୍‌ ହୁକେ ତିନାଉଣା କିନାଦେରା ?” ");
INSERT INTO peg_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","ଜିସୁ ହେୱାରିଂ ଉତର୍‌ ହିତାନ୍‌, “ଉଜ୍‌ ଆତାକାର୍‌ ତାକେ ଡାକ୍ତର୍‌ତିଂ ଲଡ଼ା ଆକାୟ୍‌, ମାତର୍‌ ଉଜ୍‌ ଆୱାତାକାରିଂ ଲଡ଼ା ମାନାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","ଆନ୍‌ ଦାର୍ମି ଲଗାଙ୍ଗ୍ କୁକ୍‌ତେଂ ଇଞ୍ଜି ୱାୱାତାଂନ୍ନା, ମାତର୍‌ ମାନ୍‌ବାଦ୍‌ଲାୟ୍‌ କିନି କାଜିଂ ପାପିୟାରିଂ କୁକ୍‌ତେଂ ୱାତାଂନ୍ନା ।” ");
INSERT INTO peg_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","କେତେଜାଣ୍‌ ଜିସୁଙ୍ଗ୍‌ ଇଚାର୍‌, “ଜହନ୍‌ତି ଚେଲାର୍‌ ଚାଣେକ୍‌ତିଂ ଚାଣେକ୍‍ ଉପାସ୍‌ ଆରି ପାର୍ତାନା କିତାର୍‌, ପାରୁସିର୍‌ ଚେଲାର୍‌ ପା ହେ ଲାକେ କିତାର୍‌, ମାତର୍‌ ନି ଚେଲାର୍‌ ତିନାଉଣା କିତାର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","ହେବେଣ୍ଡାଂ ଜିସୁ ହେୱେରିଂ ଇଚାନ୍‌, “ବିବା ଇଞ୍ଜ ୱାତାକାର୍‌ ବିବାଦାଂଣେନ୍‍ ମାନି ୱେଡ଼ାଲିଂ ଏପେଙ୍ଗ୍‌ କି ହେୱାରିଂ ଉପାସ୍‌ କିଇକିଦେଂ ଆଡ୍‌ନାଦେର୍‌ ? ମୁଡ଼କେ ଆକାୟ୍‌ ");
INSERT INTO peg_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","ମାତର୍‌ ସମୁ ୱାନାତ୍; ଏଚେକାଡ଼୍‌ଦ ହେୱେର୍‍ତାଂ ବିବାଦାଂଣେନିଂ ନିକ୍‌ଚି ଅନାର୍‌, ହେ ପାଦ୍‌ନା ହେୱାଡ଼ାଂ ହେୱାର୍‌ ଉପାସ୍‌ କିତାର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","ଆରେ, ହେୱାନ୍‌ ହେୱେରିଂ ର ଉତର୍‌ମୁଡ଼୍‌ ଇଚାନ୍‌, “ଇନେର୍‌ ପୁନି ହେନ୍ଦ୍ରାତାଂ ପ୍ଡାନି ହେନ୍ଦ୍ରାତ ଇଟୁନ୍‌; ଇଟ୍‌ତିସ୍‌ ହେ ପୁନି ହେନ୍ଦ୍ରାତିଂ କେଚ୍‌ଚି ଅନାତ୍‌, ଆରେ ପୁନିହେନ୍ଦ୍ରା ପ୍ଡାନି ହେନ୍ଦ୍ରା ହୁକେ ମିହାଆଉତ୍‍ । ");
INSERT INTO peg_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","ଆରେ, ଇନେର୍‌ ପୁନି ଅଙ୍ଗୁର୍‌ ରାସ୍‌ ପ୍ଡାନି ତଲ୍‍ ମଣାତ ଇଟୁନ୍‌; ଇଟ୍‌ତିସ୍‌ ପୁନି ଅଙ୍ଗୁର୍‌ ରାସ୍‌ ମଣାତିଙ୍ଗ୍ ପାଟ୍‍ନାତ୍, ଆରେ ମଣା ନସ୍ଟ ଆନାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","ମାତର୍‌ ପୁନି ଅଙ୍ଗୁର୍‌ ରାସ୍‌ ପୁନି ମଣାତ ଇଟ୍‌ନାକା ମାନାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","ଆରେ, ଇନେର୍‌ ପ୍ଡାନି ଅଙ୍ଗୁର୍‌ ରାସ୍‌ ଉଣ୍‌ଜି ପୁନି ଅଙ୍ଗୁର୍‌ ରାସ୍‌ ଉଣ୍ଡେଙ୍ଗ୍‌ ମାନ୍‌ କିଉର୍‌, ଇନାକିଦେଂକି ହେୱାନ୍‌ ଇନାନ୍‌, ପ୍ଡାନାକା ନେ ହାର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","ରଗ ଜମ୍‌ନିବାର୍‌ ନାଜିଂ ଜିସୁ ତାସ୍‍ବୁମି ହିଜ଼ି ହାଲ୍‍ଜି ମାନି ୱେଡ଼ାଲିଂ ତା ଚେଲାହିର୍‌ ତାସ୍‌ନି ଜିକି ନାଡ଼୍‌ଚି ନାଡ଼୍‌ଚି କେଇଦ ରାମ୍‍ଦାୟ୍‍ କିଜ଼ି ତିଞ୍ଜି ମାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","ମାତର୍‌ ପାରୁସିର୍‌ ବିତ୍ରେ କେତେକ୍‌ ଇଚାର୍‌, “ଜମ୍‌ନିବାର୍‌ତ ଇନାକା କିନାକା ବିଦି ହିଲୁତ୍‌, ହେଦାଂ ଏପେଙ୍ଗ୍‌ ଇନେକିଦେଂ କିନାଦେରା ?” ");
INSERT INTO peg_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","ଜିସୁ ହେୱାରିଂ ଉତର୍‌ ହିତାନ୍‌, “ଦାଉଦ୍‌ ଆରି ତା ମାନାୟାର୍‌ ନାସ୍‌କି ମାନି ୱେଡ଼ାଲିଂ ଇନାକା କିଜ଼ି ମାଚାନ୍‌, ହେଦାଂକି ଏପେଙ୍ଗ୍‌ ପଡ଼ି କିୱାତାଦେର୍ଣ୍ଣା ? ");
INSERT INTO peg_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","ଦାଉଦ୍‌ ଇନେସ୍‌ ଇସ୍ୱର୍‌ ଇଞ୍ଜ ହଣ୍‌ଜି, ଇମ୍‌ଣି ଦର୍ସନି ରୁଟି କେବଲ୍‌ ମାପ୍ରୁହେବାକିନାକାର୍ ପିସ୍ତି ଆରେ ଇନେର୍‌ ଚିଞ୍ଜେଙ୍ଗ୍‌ ବିଦି ହିଲୁତ୍‍, ହେଦାଂ ଅଜ଼ି ତିଞ୍ଜି ମାଚାର୍‌, ଆରେ ଜାର୍‌ ହାଙ୍ଗ୍‍ଦାକାରିଂ ପା ହିଜ଼ି ମାଚାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","ଆରେ, ହେୱାନ୍‌ ହେୱାରିଂ ଇଚାନ୍‌, “ମାନାୟ୍‌ ମାଜ଼ି ଜମ୍‌ନିବାର୍‌ ନାଜିଂ ପା ମାପ୍ରୁ ଆନାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","ତାୱାନ୍‌ ଆରେ ର ଜମ୍‌ନିବାର୍‌ ନାଜିଂ କୁଟୁମ୍‌ ଇଞ୍ଜ ହଣ୍‌ଜି ହିକାୟ୍‍କିଜ଼ି ମାଚାନ୍‌; ହେବେ ରକାନ୍‌ ମାନାୟ୍‌ ମାଚାନ୍‌, ହେ ବୁଜ୍‌ଣି କେଇ ୱାଜ୍‍ଜି ହାଲ୍‌ଜି ମାଚାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","ଆରେ, ହେୱାନ୍‌ ଇନେସ୍‌କି ଜମ୍‌ନିବାର୍‌ତ ଉଜ୍‌ କିନାନ୍‌, ଇଦାଂ ହୁଡ଼୍‌ଦେଂ କାଜିଂ ସାସ୍ତିର୍‌ ଆରି ପାରୁସିର୍‌ ତାଙ୍ଗ୍‌ ଇଟ୍‌କାଡ଼୍‌ କିଜ଼ି ଟେବା ଆତାର୍‌, ଇନେସ୍‌ ହେୱାର୍‌ ହେୱାନ୍‌ ବିରୁଦ୍‌ତ ଦାବା କିଦେଙ୍ଗ୍‌ ଆଡ୍‌ନାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","ମାତର୍‌ ହେୱାନ୍‌ ହେୱାର୍‌ ମାନ୍‌ନି ଏତ୍‌ ପୁଞ୍ଜି, ଇମ୍‌ଣି ମାନାୟ୍‌ତିଂ କେଇ ୱାଜ୍‍ଜି ମାଚାତ୍‌, ତାଙ୍ଗେଙ୍ଗ୍‌ ଇଚାନ୍‌, “ନିଙ୍ଗା, ମାଦି ନିଲା । ଆରେ, ହେୱାନ୍‌ ନିଙ୍ଗ୍‌ଜି ନିଲ୍‌ତାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","ହେବେ ଜିସୁ ହେୱାରିଂ ଇଚାନ୍‌, “ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ୱେନ୍‍ବାଦ୍‍ନାଙ୍ଗା, ଜମ୍‌ନିବାର୍‌ ଇନାକା କିନାକା ବିଦି ହାର୍‌ କିନାକା କି ବାନ୍ୟା କିନାକା ? ଜିବୁନ୍‌ ରାକ୍ୟା କିନାକା କି ନସ୍ଟ କିନାକା ?” ");
INSERT INTO peg_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","ଆରେ, ହେୱାନ୍‌ ଚାରିବେଣ୍‌ତାଂ ୱିଜ଼ାକାରିଂ ହୁଡ଼୍‌ଜି ତାଙ୍ଗ୍‌ ଇଚାନ୍‌, “ନି କେଇ ଲାମାୟ୍‌କିଦା ।” ହେବେ ହେୱାନ୍‌ ହେଦାଂ କିତାନ୍‌, ଆରେ ତା କେଇ ହାରା ଆତାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","ମାତର୍‌ ହେୱାର୍‌ ରିସା ଆଜ଼ି ବାର୍ତ ହାଲ୍‌ଜି, ଆରେ ଜିସୁଙ୍ଗ୍‌ ବେରୁତାଂ ଇନେସ୍‌ କିତିସ୍‌ ଆଡ୍‌ନାର୍‌, ହେ ବିସ୍ରେ ହେୱାର୍‌ ହେୱେର୍‌ କାତାବାର୍ତା କିଦେଙ୍ଗ୍‌ ଲାଗାତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","ହେୱାଡ଼ାଂ ହେୱାନ୍‌ ଦିନେକ୍‌ ପ୍ରାର୍ତାନା କିଦେଙ୍ଗ୍‌ ଇଞ୍ଜି ମାଡ଼ିତ ହାଚାନ୍‌, ଇସ୍ୱର୍‌ ତାକେ ପାର୍ତାନା କିଜ଼ି କିଜ଼ି ହାର୍ତାନାଣା ମାଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","ଅଜଡ଼୍‌ ଆତିଲେ, ହେୱାନ୍‌ ହେ ଚେଲାରିଂ ଲାଗେ କୁକ୍‌ଚି ହେୱାର୍‌ ବିତ୍ରେ ବାର ଜାଣ୍‌ତିଂ ବାଚି କିତାନ୍‌; ହେୱାନ୍‌ ପକ୍ୟାତାକାର୍‌ ତର୍‌ ଇଡ୍‍ତାନ୍; ");
INSERT INTO peg_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","ହେୱାର୍‌ ଆତାର୍‌ ସିମନ୍‌, ଇନେରିଂ ହେୱାନ୍‌ ପା ପିତର୍‌ ତର୍‌ ଇଡ୍‍ତାନ୍, ଆରି ହେ ଟଣ୍ଡାହି ଆନ୍ଦ୍ରିୟ, ଜାକୁବ୍‌ ଆରି ଜହନ୍‌, ପିଲିପ୍‌ ଆରି ବାର୍ତଲମି, ");
INSERT INTO peg_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","ମାତିଉ ଆରି ତମା, ଆଲପିତି ମାଜ଼ି ଜାକୁବ୍‌ ଆରି ସିମନ୍‌, ଇନେରିଂ ମୁମ୍‍ଅଜଡ଼୍ ଇନାର୍‌, ");
INSERT INTO peg_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","ଜାକୁବ୍‌ତି ମାଜ଼ି ଜିହୁଦା ଆରି ଇସ୍କାରିୟତିୟ ଜିହୁଦା, ଇନେର୍‌ ଜିସୁଙ୍ଗ୍‌ ସାତ୍ରୁ କେଇଦ ହେଲାୟ୍‌ କିତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","ଆରେ, ହେୱାନ୍‌ ହେୱାର୍‌ ହୁକେ ମାଡ଼ିତାଂ ଜୁଜ଼ି ୱାତାର୍‌ ସାରିୟା ବାଟାତ ନିଲ୍‌ତାର୍‌, ଆରେ ତା ବେସିହେନି ଚେଲାର୍‌ ଆରି ୱିଜ଼ାର୍‌ ଜିହୁଦା ରାଜି ଜିରୁସାଲମ୍‌ ଆରେ ହାମ୍‌ଦୁର୍‌ ଗୁଟିତମାନି ସର ଆରି ସିଦନ୍‌ ଗାଡ଼୍‌ତାଂ ବେସିହେନି ତା ଲାଗେ ଏକାୱାତାର୍‌; ");
INSERT INTO peg_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","ହେୱାର୍‌ ହେ ବେରଣ୍‌ ୱେଞ୍ଜେଙ୍ଗ୍‌ ଆରି ଜାର୍‌ ଜାର୍‌ ରଗ୍‌ତାଂ ଉଜ୍‌ ଆଦେଂ ୱାତାର୍‍, ଆରେ ଇମ୍‌ଣାକାର୍‌ ବାନ୍ୟା ଜିବୁନ୍‍କାଂ ତାଙ୍ଗ୍‌ କସ୍ଟ ପାୟା ଆଜ଼ି ମାଚାର୍‌, ହେୱାର୍‌ ଉଜ୍‌ କିୟାଆତାର୍‌; ");
INSERT INTO peg_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","ଆରେ ଲକୁ ତାଙ୍ଗ୍‌ ଡୁଦେଂ ଇଞ୍ଜି ସେସ୍ଟା କିଜ଼ି ମାଚାର୍‌, ଇନାକିଦେଂକି ତା ତାକେଣ୍ଡାଂ ସାକ୍ତି ହସି ୱିଜ଼ାକାରିଂ ଉଜ୍‌ କିଜ଼ି ମାଚାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","ହେ ୱେଡ଼ାଙ୍ଗ୍‌ ହେୱାନ୍‌ ଜାର୍‌ ଚେଲାର୍‌ କାଜିଂ ହୁଡ଼୍‌ଜି ଇଚାନ୍‌, “ହିଲ୍‍ୱି କାକୁଲ୍‌ତି ଲଗୁ ଜେ ଏପେଙ୍ଗ୍‌, ଏପେଙ୍ଗ୍‌ ଦନ୍ୟ, ଇନାକିଦେଂକି ଇସ୍ୱର୍ତି ରାଜି ମିଦାଙ୍ଗ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","“ନଙ୍ଗ୍‌ ନାସ୍‌କି ଜେ ଏପେଙ୍ଗ୍‌, ଏପେଙ୍ଗ୍‌ ଦନ୍ୟ, ଇନାକିଦେଂକି ଏପେଙ୍ଗ୍‌ ପାଞ୍ଚାନ୍ନାଦେର୍‌ ।” “ନଙ୍ଗ୍‌ ଆଡ଼୍‌ବାନାଦେର୍‌ ଜେ ଏପେଙ୍ଗ୍‌, ଏପେଙ୍ଗ୍‌ ଦନ୍ୟ, ଇନାକିଦେଂକି ଏପେଙ୍ଗ୍‌ ଗ୍ଡାଇନାଦେର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“ମାନାୟାର୍‌ ଏଚେକାଡ଼୍‌ଦ ମିଙ୍ଗେଙ୍ଗ୍‌ ଗିଣ୍‌କିଦ୍‌ନାର୍‌ ଆରି ମାନାୟ୍‌ ମାଜ଼ି କାଜିଂ ବିନେ କିଦ୍‌ନାର୍‌, ଆରେ ନିନ୍ଦାକିଦ୍‌ନାର୍‌ ଆରି ମି ତର୍‌ଦିଂ ବାନ୍ୟା ଇଞ୍ଜି ମୁନାକିନାର୍‌, ତେବେ ଏପେଙ୍ଗ୍‌ ଦନ୍ୟ । ");
INSERT INTO peg_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","ହେ ଦିନ୍‌ ୱାରି କିଜ଼ି ଏନ୍ଦାଟ୍, ଇନାକିଦେଂକି ହୁଡ଼ାଟ୍‌, ସାର୍ଗେତ ମିଦାଂ ଇନାମ୍‌ ଜବର୍‌; ଆରେ, ହେ ଲାକେ ତ ହେୱାର୍‌ ଆବାନି ଲାତ୍ରାର୍‌ ବେଣ୍‌ବାକ୍‌ଣାୟ୍‌କିନାକାର୍‌ କାଜିଂ କିଜ଼ି ମାଚାର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“ମାତର୍‌ ହାୟ୍‌, ଡାଣ୍ଡ୍‌ ପାୟା ଆନି ମାଜାନ୍‌ ଜେ ଏପେଙ୍ଗ୍‌, ଇନାକିଦେଂକି ଏପେଙ୍ଗ୍‌ ଜାର୍‌ ଜାର୍‌ ସୁକ୍‌ ପାଇ କିନାଦେରା ।” ");
INSERT INTO peg_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","“ହାୟ୍‌, ଡାଣ୍ଡ୍‌ନି କାଜିଂ ନେଜେୱିଗା ପାଞ୍ଚାଦେର୍ଣ୍ଣା ଜେ ଏପେଙ୍ଗ୍‌, ଇନାକିଦେଂକି ଏପେଙ୍ଗ୍‌ ନାସ୍‌କି ଆନାଦେର୍‌ ।” “ହାୟ୍‌, ଡାଣ୍ଡ୍‌ ପାୟା ଆନାଦେର୍‌ ନେଜେୱିଗା ଗ୍ଡାଇନାଦେର୍‌ ଜେ ଏପେଙ୍ଗ୍‌, ଇନାକିଦେଂକି ଏପେଙ୍ଗ୍‌ ଦୁକ୍‌ ଆରି ଆଡ଼୍‌ବାନାଦେର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“ଏଚେକାଡ଼୍‌ଦ ୱିଜ଼ାର୍‌ ଲକୁ ମି ତର୍‌ ଉପ୍‌ନାର୍‌, ହେ ଏଚେକାଡ଼୍‌ଦ ହାୟ୍‌, ଏପେଙ୍ଗ୍‌ ଡାଣ୍ଡ୍‌ ପାୟାନି ଲଗୁ; ହେ ଲାକେ ତ ହେୱାର୍‌ତି ଆବା ଲାତ୍ରାର୍‌ ଚାକ୍ରାୟ୍‌ ବେଣ୍‌କିନାକାର୍‌ କାଜିଂ କିଜ଼ି ମାଚାର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“ମାତର୍‌ ୱେନାଦେରା ଜେ ଏପେଙ୍ଗ୍‌, ମିଙ୍ଗେଙ୍ଗ୍‌ ଆନ୍‌ ଇଞ୍ଜ୍‌ନାଙ୍ଗା, ମି ସାତ୍ରୁରିଂ ୱାରି କିୟାଟ୍‌; ଇମ୍‌ଣାକାର୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ନିନ୍ଦା କିଦ୍‌ନାର୍‌, ହେୱେରିଂ ଜିଉନୱାଟ୍‌; ");
INSERT INTO peg_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","ଇମ୍‌ଣାକାର୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ରାଣ୍‌ ହିଦ୍‌ନାର୍‌, ହେୱେରିଂ ଆସିର୍ବାଦ୍‌ କିୟାଟ୍‌; ଇମ୍‌ଣାକାର୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ହିନସ୍ତା କିଦ୍‌ନାର୍‌, ହେୱାର୍‌ କାଜିଂ ପାର୍ତାନା କିୟାଟ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","ଇନେର୍‌ ନିଙ୍ଗେଙ୍ଗ୍‌ ର କୁର୍‌ୱାତ ଚାପ୍‌ଡ଼ା ଇଡ଼ିଦାନାର୍‌, ହେଦାଂ କାଜିଂ ଅଲ୍‌ଗା କୁର୍‌ୱା ଚଚା; ଆରେ, ଇନେର୍‌ ନି ହେନ୍ଦ୍ରା ଅନାର୍‌, ହେଦାଂ ନି ଉସ୍‌ପାନାକା ପା ଅଦେଂ ମୁନା କିମାଟ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","ଇନେର୍‌ ନିଙ୍ଗେଙ୍ଗ୍‌ ଏନ୍ତାନାର୍‌, ତାଙ୍ଗେଙ୍ଗ୍‌ ହିୟାଟ୍‌; ଆରେ ଇନେର୍‌ ନି ଦାନ୍‌ ଅନାର୍‌, ତାତାକେଣ୍ଡାଙ୍ଗ୍‌ ହେଦାଂ ଆରେ ରଗ ଏନ୍‌ମାଟ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","ମାନାୟାର୍‌ ମି କାଜିଂ ଇନେସ୍‌ ବାନି ବେବାର୍‌ କିଦ୍‌ନାର୍‌ ଇଞ୍ଜି ଇଚା କିନାଦେର୍‌, ଏପେଙ୍ଗ୍‌ ହେୱାର୍‌ କାଜିଂ ହେ ଲାକେ କିୟାଟ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","ଆରେ, ଇମ୍‌ଣାକାର୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ଜିଉନଦ୍‌ନାର୍‌, ହେୱାରିଂ ଜିଉନତିସ୍‌ ଏପେଙ୍ଗ୍‌ ଇନା ଆସିର୍ବାଦ୍‌ ପାୟା ଆନାଦେର୍‌ ? ଇନାକିଦେଂକି ପାପିର୍‌ ପା ଜାର୍‌ ଜାର୍‌ ଜିଉନନାକାରିଂ ଜିଉନନାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","ଆରେ, ଇମ୍‌ଣାକାର୍‌ ମିଦାଙ୍ଗ୍‌ ହାର୍‌ କିନାର୍‌, ଜଦି ଏପେଙ୍ଗ୍‌ କେବଲ୍‌ ହେୱାରିଂ ହାର୍‌ କିନାଦେର୍‌, ତେବେ ଏପେଙ୍ଗ୍‌ ଇନାକା ଆସିର୍ବାଦ୍‌ ପାୟା ଆନାଦେର୍‌ ? ଇନାକିଦେଂକି ପାପିୟାର୍‍ପା ହେଦାଂ କିନାରା । ");
INSERT INTO peg_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","ପାଚେ, ଇମ୍‌ଣାକାର୍‌ତାଂ ମିଦାଙ୍ଗ୍‌ ପାୟା ଆନି ଆହା ମାନାତ୍‌, କେବଲ୍‌ ହେୱେରିଂ ରୁଣ୍‌ ହିତିସ୍ ଏପେଙ୍ଗ୍‌ ଇନା ଆସିର୍ବାଦ୍‌ ପାୟା ଆନାଦେର୍‌ ? ପାପିର୍‌ ପା ସମାନ୍‌ନେ ପାୟାଦେଂ ଇଞ୍ଜି ପାପିରିଙ୍ଗ୍‌ ରୁଣ୍‍ ହିନାର୍‍ ");
INSERT INTO peg_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","ମାତର୍‌ ମି ସାତ୍ରୁକାଂ ଜିଉନୱାଟ୍‌ ଆରି ହେୱାରିଂ ହାର୍‌ କିୟାଟ୍‌, ଆରେ ଉଲ୍‌ଟି ରୁଣ୍‍ ଆହା କିୱାଦାଂ ରୁଣ୍‍ ହିଆଟ୍‍; ତା ଆତିସ୍‌ ମିଦାଙ୍ଗ୍‌ ଇନାମ୍‌ ବେସି ଆନାତ୍‌ ଆରି ଏପେଙ୍ଗ୍‌ ସିଗ୍‌ଦାକାନ୍‌ ମାପ୍ରୁ ମେହି ଆନାଦେର୍‌, ଇନାକିଦେଂକି ହେୱାନ୍‌ ଲଡ଼ାଆୱି ଆରି ବାନ୍ୟାଙ୍ଗ୍‌ ପା ଦୟା କିନାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","ମିଞ୍ଜି ଆବା ଇନେସ୍‌ ଦାର୍ମି, ଏପେଙ୍ଗ୍‌ ହେ ଲାକେ ଦାର୍ମି ଆଡ । ");
INSERT INTO peg_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“ଆରେ, ବିଚାର୍‌ କିମାଟ୍‌, ତା ଆତିସ୍‌ ଏପେଙ୍ଗ୍‌ ବିଚାର୍‌କିୟା ଆଉଦେର୍‌; ଦସ୍‌ କିମାଟ୍‌, ତା ଆତିସ୍‌ ଏପେଙ୍ଗ୍‌ ଦସି କିୟାଆଉଦେର୍‍ । କେମା କିୟାଟ୍‌, ତା ଆତିସ୍‌ ଏପେଙ୍ଗ୍‌ କେମା କିୟା ଆନାଦେର୍‌; ");
INSERT INTO peg_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","ଦାନ୍‌ କିୟାଟ୍‌, ହେଦାଂ ମିଙ୍ଗେଙ୍ଗ୍‌ ଦାନ୍‌ ହିଦ୍‌ୟା ଆନାତ୍‌; ଇସ୍ୱର୍‌ ମାଣ୍‌ଦ ବାର୍ତି କିଜ଼ି ହେଦେଲିଂ ଲେପ୍‌ଚି ଡ଼ିଉଡ଼ିଉ ମିଙ୍ଗେଙ୍ଗ୍‌ ମାଣ୍‌ଦ ହିଦ୍‌ନାର୍‌; ଇନାକିଦେଂକି ଇମ୍‌ଣି ମାଣ୍‌ଦ ଲାଚ୍‍ନାସ୍‍, ହେ ମାଣ୍‍ତାଂ ମିଙ୍ଗେଙ୍ଗ୍‌ ଆରେ ମାଣ୍‍ଦାଂ ହିଦ୍‍ଆ ଆନାତ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","ଜିସୁ ହେୱେରିଂ ର ଉତର୍‌ମୁଡ଼୍‌ ପା ଇଚାନ୍‌, “କାଣା ଇନାକା କାଣାଂ ହାଜ଼ି ଚଚ୍‌ଚେଙ୍ଗ୍‌ ଆଡ୍‌ନାନ୍‌ ? ଜଦି ହେୱାନ୍‌ ହେ ଲାକେ କିନାନ୍‌, ଲାଗିଂ, ହେୱାର୍‌ ଇନାକା ରିୟାର୍‌ କ୍ଡଇଦ ଆରୁର୍‌ ? ");
INSERT INTO peg_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","ଗୁରୁତାଂ ଚେଲା ଗାଜା ଆକାୟ୍‌; ମାତର୍‌ ୱିଜ଼ାର୍‌ ଚେଲା ହିକ୍ୟା ୱିସ୍ତାର୍‌ଚି ହାର୍‌ ଆଜ଼ି ନିଜାର୍‌ ଗୁରୁ ସମାନ୍‌ ଆନାର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","ଆରେ, ଇନେକିଦେଂ ନି ଟଣ୍ଡେନ୍‌ କାଣ୍‌ଙ୍ଗାତ ମାନି ଗାତ୍ରା ହୁଡ଼୍‍ନାୟା, ମାତର୍‌ ନି ନିଜ୍‌ କାଣ୍‌ଙ୍ଗାତ ଇମ୍‌ଣି ୱେଜ଼୍‌ଗୁ ଗାତ୍ରା ମାନାତ୍‌, ହେଦାଂ ବାବିକିଦେଂ ଆଡୁୟା ? ");
INSERT INTO peg_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","ଏପେଙ୍ଗ୍‌ ଜାର୍‌ କାଣ୍‌ଙ୍ଗାତ ମାନି ଦୁଲୁମ୍‍ ଗାତ୍ରା ହୁଡ଼୍‌ୱାଦାଂ ଇନେସ୍‌ ଜାର୍‌ ଟଣ୍ଡେନିଂ ଇଞ୍ଜେଙ୍ଗ୍‌ ଆଡ୍‌ନାୟ୍‌, ଟଣ୍ଡେନ୍‌, ୱା, ନି କାଣ୍‌ଙ୍ଗାତ ମାନି ଗାତ୍ରାତିଙ୍ଗ୍‌ ଉନ୍‌ଦି ହିଦ୍‍ନାଙ୍ଗ୍ ? ଆଡ଼େ କାପ୍‌ଟିୟାର୍‌ ଆଗେ ଜାର୍‌ କାଣ୍‌ଙ୍ଗାତାଂ ଦୁଲୁମ୍‍ ଗାତ୍ରା ଉନ୍‌ଦିୟା ତା ପାଚେ ନିଜ୍‌ ଟଣ୍ଡେନ୍‌ କାଣ୍‌ଙ୍ଗାତ ମାନି ୱେଜ଼୍‌ଗୁ ଗାତ୍ରା ଉନ୍‌ଦିନି କାଜିଂ ହାର୍‌ଦାଂ ହୁଡ଼୍‌ଦେଂ ଆଡ୍‌ନାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“ହାର୍ଦି ମାର୍‌ ବାନ୍ୟା ପାଡ଼୍‌ ୱାଉତ୍‌, ବାନ୍ୟା ମାର୍‌ତ ହାର୍ଦି ପାଡ଼୍‌ ଆହୁତ୍‌, ଇନେସ୍‌କି ହାର୍‌ ପାଡ଼୍‌ ଆହ୍‌ନାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","ଇନାକିଦେଂକି ୱିଜ଼ୁ ମାର୍‌କୁ ଜାର୍‌ ପାଡ଼୍‌ଦାଂ ପୁନିୟା ଆନାତ୍‌; ୱାଡ଼ିଙ୍ଗ୍‌ ବୁଟାତାଂତ ମାନାୟାର୍‌ ତଗା ଏଚୁର୍‌, କି ୱାଡ଼ିକୁଡ଼ିଙ୍ଗ୍‌ତାଂ ଅଙ୍ଗୁର୍‌ପାଡ଼୍‌ ଏଚୁର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","ହାର୍ଦି ଲଗୁ ହାର୍‌ଦି ୱାସ୍କିତାଂ ହାର୍ଦି ଆଡ଼୍‌ମାଡ଼୍‌ ହପ୍‌ନାନ୍‌ । ଆରେ ବାନ୍ୟା ଲଗୁ ବାନ୍ୟା ୱାସ୍କିତାଂ ବାନ୍ୟା ଆଡ଼୍‌ମାଡ଼୍‌ ହପ୍‌ନାନ୍‌; ଇନାକିଦେଂକି ମାନ୍ତ ବାର୍ତିଆତାତ୍‌ନା ୱେଇ କାତା ଇନାତ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“ଆରେ, ଏପେଙ୍ଗ୍‌ ଇନେକିଦେଂ ନାଙ୍ଗେଙ୍ଗ୍‌ ମାପ୍ରୁ, ମାପ୍ରୁ ଇଞ୍ଜି କୁକ୍ତାନାଦେରା ମତର୍‌ ନା ବଚନ୍‌ ପାଲି କିଉଦେରା ? ");
INSERT INTO peg_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","ଇମ୍‌ଣାକାର୍‌ ନା ଲାଗେ ୱାଜ଼ି ନା ବେରଣ୍‌ ୱେନ୍‌ଞ୍ଜି ହେ ସବୁ ପାଲି କିନାନ୍‌, ହେୱାନ୍‌ ଇନେର୍‌ ସମାନ୍‌ ଆନାନ୍‌, ହେଦାଂ ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ୱେଚାନାଙ୍ଗ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","ହେୱାନ୍‌ ଇ ଲାକେ ରକାନ୍‌ ଇଲ୍‌ ଡ୍ରିକ୍‌ନି ମାନାୟ୍‌ ଲାକେ ଜେ ଡେଙ୍ଗାକିଜ଼ି କାର୍ଚି କୁନାଦି କାଲ୍‌ ଜପି ଇଡ଼୍‌ଜି କୁଚିକିତାର୍‌; ଆରେ ପୁର୍‍ଆତିଲେ ହୁଞ୍ଜାଟ୍‌ ହେ ଇଞ୍ଜ ବେସି ଦକା ଇଡ଼ିତାତ୍‌ ମାତର୍‌ ହେଦାଂ ଲେପ୍‍ପେଦେଂ ଆଡ୍‌ୱାତାତ୍‌, ଇନାକିଦେଂକି ହେଦାଂ ହାର୍‌ କିଜ଼ି ରଚ୍‍ଚାକାମାଚାତ୍‍ । ");
INSERT INTO peg_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","ମାତର୍‌ ଜେ ୱେନ୍‌ଞ୍ଜି ପାଲି କିଉନ୍‌, ହେୱାନ୍‌ କୁନାଦି କୁଚିକିୱାଦାଂ ମେଦ୍‌ନି ଜପି ଇଲ୍‌ ରଚ୍‍ନି ମାନାୟ୍‌ ଲାକେ; ଏଚେକାଡ଼୍‌ଦ ଇଲ୍‌ତିଂ ବେସି ଦକା ଇଡ଼ିତିସ୍‍, ଉଲ୍‌କା ହେ ମଲ୍‍ଦିଂ ବେସି ଦକା ଇଡ଼୍‍ତିଲେ, ହେ ଦାପ୍ରେ ହେଦାଂ ବାଡ଼୍‍ହା ଆତାତ୍‌ ଆରେ ହେଦାଂ ନାସ୍‌ ବଇଁଙ୍କାର୍‌ ଆତାତ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","ଜିସୁ ମାନାୟାରିଂ ୱେଚ୍‌ଚେଙ୍ଗ୍‌ ମାନ୍‌କିଜ଼ି ମାଚାନ୍‌ ହେୱାନ୍‌ ୱିଜ଼ାର୍‌ କାତା ୱିସ୍ତି କପର୍ନାହୁମ୍‌ ହଣଗାତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","ହେୱାଡ଼ାଂ ରୱାନ୍‌ ପାଞ୍ଚକଡ଼ି ମେଲ୍ୟାର୍‌ ମୁଡ଼୍‌ଦାକାନ୍‌ ହଲ୍ୟାହି ବେମାର୍‌ ଆଜ଼ି ମାଚାନ୍‌, ହେୱାନ୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ବେସି ଜିଉନଜ଼ି ମାଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","ହେୱାନ୍‌ ଜିସୁ ବିସ୍ରେ କାବୁର୍‌ ପୁଞ୍ଜି, ହେୱାନ୍‌ ଇନେସ୍‌ ୱାଜ଼ି ହେ ହଲ୍ୟାହିତି ଜିବୁନ୍‌ ରାକ୍ୟା କିନାନ୍‌, ଇଦାଂ କାଜିଂ ତା ତାକେ ଜିହୁଦିର୍ତି କେତେଜାଣ୍‌ ବୁଡ଼ାଲୁରିଂ ପକ୍‌ଚି ତାଙ୍ଗେଙ୍ଗ୍‌ ଗୱାରି କିତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","ହେୱାର୍‌ ଜିସୁ କଚଣ୍‌ତ ୱାଜ଼ି ତାଙ୍ଗେଙ୍ଗ୍‌ ବେସି ଗୱାରି କିଦେଙ୍ଗ୍‌ ଲାଗାତାର୍‌, ଏନ୍‌ ଜେ ହେୱାନ୍‌ କାଜିଂ ଇଦାଂ କିନାୟ୍‌, “ହେୱାନ୍‌ ହେବେନି ଦାୟିତ୍‍ ଆନାନ୍‌; ");
INSERT INTO peg_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","ଇନାକିଦେଂକି ଜିସୁ ମାଙ୍ଗେଙ୍ଗ୍‌ ଜାତିତିଂ ଜିଉନନାନ୍ ଆରି ହେୱାନ୍‌ ମା କାଜିଂ କୁଟୁମ୍‌ ଇଞ୍ଜ ରଚ୍‌ଚି ହିତ୍‌ନ୍ନା ।” ");
INSERT INTO peg_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","ହେବେ ଜିସୁ ହେୱାର୍‌ ଲାହାଙ୍ଗ୍‌ ରଚେ ହାଚାନ୍‌ । ହେୱାନ୍‌ ଇଞ୍ଜାଙ୍ଗ୍‌ ଅଲପ୍‍ ଦେହା ଆତିଲେ, ପାଞ୍ଚକଡ଼ି ମେଲ୍ୟାର୍‌ ହାଙ୍ଗ୍‌ଦାକାରିଂ ପକ୍‌ଚି ତାଙ୍ଗେଙ୍ଗ୍‌ ଇଚାର୍‌, “ମାପ୍ରୁ କସ୍ଟ କିଦ୍‌ମା; ଇନାକିଦେଂକି ଏନ୍‌ ଜେ ମା ଇଞ୍ଜ କାଲ୍‌ ତଗ୍‌ନାୟ୍‌, ଆନ୍‌ ଏଲେଙ୍ଗ୍‌ ବାର୍‌ତି ଇନାକା ହିଲୁତ୍‌; ");
INSERT INTO peg_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","ଲାଗିଂ ଆନ୍‌ ନି କଚଣ୍‌ତ ହାଞ୍ଜେଙ୍ଗ୍‌ ନିଜ୍‌ତିଂ ୱାର୍‌ୟା ଆୱାଦାଂ ମାଚାଙ୍ଗ୍‌; ମାତର୍‌ ପାଦେକ୍‌ ବଲ୍‌ କିଦା, ନା ଆଡ଼ିଏନ୍‌ ଉଜ୍‌ ଆନାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","ଇନାକିଦେଂକି ଆନ୍‌ ରୱାନ୍‌ ବାନ୍ୟା ମାନାଙ୍ଗ୍‌ ଆତିସ୍‌ ପା ନା ତାରେନ୍‌ ମେଲ୍ୟାର୍‌ ମାନାର୍‌; ଆରେ, ଆନ୍‌ ରୱାନିଂ ଆଦିକାର୍‌ ହିତିସ୍‌ ହେୱାନ୍‌ ହାନାନ୍‍; ଆରେ ରୱାନିଂ ୱା ଇଚିସ୍‌ ହେୱାନ୍‌ ୱାନାନ୍‍; ମାତର୍‌ ନା ହଲ୍ୟା ଇଦାଂ କିୟା ଇଚିସ୍‌ ହେଦାଂ କିନାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","ଜିସୁ ଇ ୱିଜ଼ୁ କାତା ୱେନ୍‌ଞ୍ଜି ହେ ବିସ୍ରେ କାବା ଆତାର୍‌, ଆରେ ମାସ୍‌ଦି ହେ ପାଚେ ୱାଜ଼ିମାନି ମାନାୟାରିଂ ଇଚାନ୍‌, “ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ଇଞ୍ଜ୍‌ନାଙ୍ଗା, ଇସ୍ରାଏଲ୍‌ ବିତ୍ରେ ପା ଏଚେକ୍‌ ଗାଜା ପାର୍ତି ପାୟାଆୱାତାଂନ୍ନା ।” ");
INSERT INTO peg_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","ଆରେ ପକ୍ୟାତାକାର୍‌ ମାନାୟ୍‌ ଇଞ୍ଜ ଲେଉଟା ଆଜ଼ି ହଲ୍ୟାହିଙ୍ଗ୍‌ ଉଜ୍‌ ଆତାକା ହୁଡ଼୍‌ତାର୍ । ");
INSERT INTO peg_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","ଇଦାଂ ପାଚେ ହେୱାନ୍‌ ନାଇନ୍‌ ତର୍‌ଦି ଗାଡ଼୍‌ଦ ହାଚାନ୍‌, ଆରି ହେୱାନ୍‌ ଚେଲାହିର୍‌ ଆରି ବେସିହେନି ମାନାୟ୍‌ ହେୱାର୍‌ ହୁଦାଂ ହାଲ୍‌ଜି ମାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","ହେୱାନ୍‌ ଗାଡ଼୍‌ନି ଦୁୱେର୍‌ ଲାଗେ ଏକାୱାତିଲେ, ହୁଡ଼ାଟ୍‌, ମାନାୟ୍‌ ରୱାନ୍‌ ହାତି ମାନାୟ୍‌ତିଂ ବାର୍ତ ପିଣ୍ଡ୍‌ଜି ତାସି ମାଚାର୍‌, ହେୱାନ୍‌ ଜାର୍‌ ଆୟାନି ରୱାନ୍‌ ମତର୍‌ କାଡ଼୍‌ଦେ, ମାତର୍‌ ହେ କଗ୍‌ଲେ ରାଣ୍ଡି; ଆରେ ଗାଡ଼୍‌ନି ବେସିହେନିମାନାୟ୍‌ ତା ଲାହାଙ୍ଗ୍‌ ମାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","ହେଦେଲିଂ ହୁଡ଼୍‌ଜି ମାପ୍ରୁ ତା କାଜିଂ କାର୍ମା ଆଜ଼ି ଦୁକ୍‌ ହୁଡ଼୍‌ଜି ତାଙ୍ଗେଙ୍ଗ୍‌ ଇଚାନ୍‌, “ଆଡ଼୍‌ବାମା ।” ");
INSERT INTO peg_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","ଆରେ, ହେୱାନ୍‌ କଚଣ୍‌ତ ହାଲ୍‌ଜି ମାରାତ ଡୁତାନ୍‌, ପାଚେ ପିଣ୍ଡ୍‌ତାକାର୍‌ ନିଲ୍‍ତିଲେ ହେୱାନ୍‌ ଇଚାନ୍‌, ନିଲାଟ୍‌, ହେୱାନ୍‌ ଇଚାନ୍‌, “ଦାଙ୍ଗ୍‌ଣେନ୍‌, ଆନ୍‌ ନିଙ୍ଗେଙ୍ଗ୍‌ ଇଞ୍ଜ୍‌ନାଙ୍ଗା ନିଙ୍ଗା ।” ");
INSERT INTO peg_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","ହେବେତାଂ ହାତି ଲଗୁ ନିଙ୍ଗ୍‌ଜି କୁଚ୍‌ଚାନ୍‌, ଆରେ ବେଣ୍‌ କିଦେଙ୍ଗ୍‌ ଲାଗାତାନ୍‌, ଆରେ ହେୱାନିଂ ତା ତେହି କେଇଦ ହେଲାୟ୍‌ କିତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","ଇବେତାଂ ୱିଜ଼ାକାର୍‌ ପାଣ୍ଡ୍ରା ଆତାର୍‌, “ଆରେ ଇସ୍ୱର୍ତି ଗୁଣ୍‌ କେର୍‌ଜି କିଉ କିଉ ଇଞ୍ଜେଙ୍ଗ୍‌ ଲାଗାତାର୍‌,” ମା ବିତ୍ରେ ରୱାନ୍‌ ଗାଜା ବେଣ୍‌ବାକ୍‌ଣାୟ୍‌କିନାକାନ୍‌ ହନ୍‌ତାନ୍‌ନା “ଆରି ଇସ୍ୱର୍‌ ଜାର୍‌ ଲଗାଂ କାଜିଂ ମୁକ୍ତି କିଦେଙ୍ଗ୍‌ ୱାତାନ୍‌ନା ।” ");
INSERT INTO peg_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","ପାଚେ, ଜିସୁ ବିସ୍ରେ ଇ ବେରଣ୍‌ ୱିଜ଼ାର୍‌ ଜିହୁଦା ଦେସ୍‌ ଆରି ଚାରିବେଣ୍‌ତାଂ ୱିଜ଼ୁ ନାସ୍‌କୁକାଂ ୱିଣ୍‌ତାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","ପାଚେ ଜହନ୍‌ ଚେଲାହିର୍‌ ଇ ୱିଜ଼ୁ ବିସ୍ରେ ୱେଚ୍‌ଚାର୍ । ");
INSERT INTO peg_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","ହେବେ ଜହନ୍‌ ଜାର୍‌ ଚେଲାର୍‌ ବିତ୍ରେ ରିୟାରିଂ କଚଣ୍‌ତ କୁକ୍‌ଚି ମାପ୍ରୁ ତାକେ ଇଦାଂ ଇଞ୍ଜି ପକ୍‌ତାନ୍‌, “ଇନେନ୍‍ତି ୱାନାକା ମାଚାତ୍‌, ହେ ମାନାୟ୍‌ ଏନ୍‌, କି ନଲେ ଆପେଂ ଆରେ ରୱାନିଂ କାସିମାନାପ୍‌ ?” ");
INSERT INTO peg_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","ହେ ମାନାୟାର୍‌ ଜିସୁଙ୍ଗ୍‌ ଲାଗେ ହାଲ୍‌ଜି ଇଚାର୍‌, “ବାପ୍ତିସିମ୍‌ ହିନି ଜହନ୍‌ ମାଙ୍ଗେଙ୍ଗ୍‌ ନି ତାକେ ଏଲେଙ୍ଗ୍‌ ଇଞ୍ଜି ପକ୍‌ତାତାନ୍ନା, ଇନେର୍‌ତି ୱାନାକା ଆନାତ୍‌, ହେ ମାନାୟ୍‌ କି ଏନ୍‌, କି ଆପେଂ ଆରକାନିଂ କାଜିଂ ମାନାପ୍‌ ?” ");
INSERT INTO peg_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","ହେୱାଡ଼ାଂ ହେୱାନ୍‌ ବେସିଲଗାଂ ରଗ୍‌, ବେମାର୍‌ ଆରି ବାନ୍ୟାପୁଦା ଉଜ୍‌ କିତାନ୍‌, ଆରି ହେନି କାଣାରିଂ କାଣ୍‌କୁ ହୁଡ଼ିକିତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","ଜିସୁ ହେୱାରିଂ ଉତର୍‌ ହିତାନ୍‌, ଏପେଙ୍ଗ୍‌ ହାଲ୍‌ଜି ଇନା ଇନାକା ହୁଡ଼୍‌ତାଦେର୍ ଆରି ୱେଚାଦେର୍‍, ହେଦାଂ ୱିଜ଼ୁ ଜହନ୍‌ତିଂ ୱେଚାଟ୍‌; “କାଣାର୍‌ କାଣ୍‌କୁ ହୁଡ଼୍‌ନାର୍, ଚଟାର୍‌ ତାଂଦେଙ୍ଗ୍ ଆଡ଼୍‌ତାର୍‌, ଗାଜା ରଗ୍ୟାର୍‌ ସକଟ୍‌ ଆଦେଂ ଆଡ଼୍‌ତାର୍‌, ବଇରାର୍‌ ୱେଞ୍ଜେଙ୍ଗ୍‌ ଆଡ଼୍‌ତାର୍‌, ହାତାକାର୍‌ ନିଙ୍ଗ୍‌ନାର୍‌, ହିଲ୍‍ୱାକାର୍‍ ତାକେ ନେକ୍ରିକାବୁର୍‌ ସୁଣାୟ୍‌ କିତାର୍‌; ");
INSERT INTO peg_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","ଆରେ ଇମ୍‌ଣି ମାନାୟ୍‌ ନାତାକେଣ୍ଡାଂ ବାଦା ପାୟା ଆଉନ୍‌, ହେୱାନ୍‌ ଦନ୍ୟ ।” ");
INSERT INTO peg_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","ଜହନ୍‌ନି ଦୁତର୍‌ ହାଚିପାଚେ ଜିସୁ ଜହନ୍‌ ବିସ୍ରେ ବେରଣ୍‌ ଇଞ୍ଜେଙ୍ଗ୍‌ ଲାଗାତାନ୍‌, ଏପେଙ୍ଗ୍‌ ଇନାକା ହୁଡ଼୍‌ଦେଂ ଇଞ୍ଜି ହାଲ୍‌ଜି ମାନାଦେର୍‌ ? “ଇନାକା ଦୁକାତିଙ୍ଗ୍‌ ଜଲାଆନି ନାଡ଼ା ? ");
INSERT INTO peg_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","ହେଦାଂ ଆୱିତିସ୍‌ ଏପେଙ୍ଗ୍‌ ଇନାକା ହୁଡ଼୍‌ଦେଂ ଇଞ୍ଜି ହସି ହାଲ୍‌ଜି ମାଚାଦେର୍‌ ? ଇନାକା ଦାମ୍‌ନି ହେନ୍ଦ୍ରା ଉସ୍ପିତି ର ମାନାୟ୍‌ତିଂ ? ହୁଡ଼ାଟ୍‌, ଇମ୍‌ଣାକାର୍‌ ଦାମ୍‌ନି ହେନ୍ଦ୍ରା ଉସ୍‌ପାତାନ୍‌ ବିସ୍ରେ ସୁକ୍‌ତାଙ୍ଗ୍ ଜିନାନ୍‌, ହେୱାର୍‌ ରାଜା ଗାଦିତ ମାନ୍‌ଗାନାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","ନାଙ୍ଗେଙ୍ଗ୍‌ ଇଞ୍ଜା, ହେଦାଂ ଆୱିତିସ୍‌ ଇନାକା ହୁଡ଼୍‌ଦେଂ ଇଞ୍ଜି ହସି ହାଲ୍‌ଜି ମାଚାଦେର୍‌ ? ଇନାକା ରୱାନ୍‌ ବେଣ୍‌ବାକ୍‌ଣାୟ୍‌କିନାକାନିଂ ? ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ହାତ୍‌ପା ୱେଚାନାଙ୍ଗା, ବେଣ୍‍ବାକ୍‌ଣାୟ୍‌ କିନାକାନ୍ତାଙ୍ଗ୍ ଆଦିକ୍‌ ଗାଜା ମାନାୟ୍‌ତିଂ । ");
INSERT INTO peg_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","ଇନେର୍‌ ବିସ୍ରେ ଇଦାଂ ଦରମ୍‌ ସାସ୍ତର୍‌ ଲେକା ମାନାତ୍‌, ଇସ୍ୱର୍‌ ଇଚାନ୍‌ ହୁଡ଼ାଟ୍‌, ଆପେଂ ମା ଦୁତ୍‌ତିଂ ମି ଆଗେ ପକ୍ତାନାପା, ହେୱାନ୍‌ ମି ଲାଗେ ମିଦାଙ୍ଗ୍‌ ହାଜ଼ି ରଚ୍‌ଚି ହିଦ୍‌ନାନ୍, ଇୱାନ୍‌ ହେ ମାନାୟ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ଇଞ୍ଜ୍‌ନାଙ୍ଗା,” କଗ୍‌ଲେ ପଟତ ଜଲମ୍ ୱିଜ଼ାର୍‌ତାଂ ବିତ୍ରେ ଜହନ୍‌ ତାଙ୍ଗ୍‌ ଗାଜାକାନ୍‌ ଇନେର୍‌ ହିଲୁର୍‌; ଆତିସ୍‌ପା ସାର୍ଗେ ରାଜିତ ଇନେନ୍‌ ହିରୁକାନ୍, “ହେୱାନ୍‌ ଜହନ୍‌ ତାଙ୍ଗ୍‌ ପା ଗାଜାକାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","ଇମ୍‌ଣି ଇ ୱିଜ଼ୁ ବେରଣ୍‌ ୱେନ୍‌ଞ୍ଜି ମାଚାର୍‌, ହେୱାର୍‌, ହାତ୍‌ପାକିଜ଼ି ସିସ୍ତୁଏନ୍‌ନାକାର୍‌, ଇସ୍ୱର୍‌ ମାପ୍ରୁଙ୍ଗ୍‌ ହାର୍ଦି ଦାବି ୱିଜ଼ୁ ପାର୍ତି କିଜ଼ି ଜହନ୍‌ ତାଙ୍ଗ୍‌ ବାପ୍ତିସିମ୍‌ ଅଜ଼ି ମାଚାନ୍‌; ");
INSERT INTO peg_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","ମାତର୍‌ ପାରୁସିର୍‌ ଆରେ ଦରମ୍‌ ଗୁରୁର୍‌ ହେୱାର୍‌ ଜିବୁନ୍‌ କାଜିଂ ଇସ୍ୱର୍‌ ମାପ୍ରୁ କାଜିଂ ଇଟ୍ୟା ଆୱାଦାଂ ତାତାଂ ବାପ୍ତିସିମ୍‌ ଅୱାଦାଂ ମାଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","ଜିସୁ ଆରେ ରଗ ଇଚାନ୍‌ ଇନେର୍‌ ଇ ଜୁଗ୍‌ଦି ମାନାୟାରିଂ ଆନ୍‌ ଇନେର୍‌ ହୁଦାଂ ତୁଲାୟ୍‌ କିନାଙ୍ଗ୍‌, “ଆରେ ହେୱାର୍‌ ଇନେର୍‌ ଲାକେ ? ");
INSERT INTO peg_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","ଇମ୍‌ଣି କାଡ଼୍‌ଦେର୍‌ ଆଟ୍‌ ବାଜାର୍‌ତ କୁଚ୍‌ଚି ହେୱେର୍‌ ହେୱାର୍‌ କୁକ୍‌ଚି ଇନାର୍‌, ଆପେଂ ମି ଲାଗାଂ ହୁରୁଡ଼ି ତୁବ୍‌ତାପ୍‌, ଏପେଙ୍ଗ୍‌ ଏନ୍ଦ୍‌ୱାତାଦେର୍‌; ଆପେଂ ହାତି କେର୍‌କଣ୍‌ କେର୍‌ତାପ୍‌, ଏପେଙ୍ଗ୍‌ ଆଡ଼୍‌ବାୱାତାଦେର୍, ହେୱାର୍‌ ହେୱେର୍‌ ଲାକେ । ");
INSERT INTO peg_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","ଇନାକିଦେଂକି ବାପ୍ତିସିମ୍‌ହିନି ଜହନ୍‌ ୱାଜ଼ି ରୁଟି ତିନ୍‌ୱାତାନ୍‌ କି ଆରେ ଅଙ୍ଗୁର୍‌ ରାସ୍‌ ଉଣୁୱାତାନ୍‌, ଆରେ ଏପେଙ୍ଗ୍‌ ଇନାଦେରା, ହେୱାନ୍‌ ବୁତ୍‌ ଆସ୍ତାତ୍‌ନା । ");
INSERT INTO peg_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","ମାନାୟ୍‌ ମାଜ଼ି ୱାଜ଼ି ତିନାଉଣା କିନାନ୍‌, ଆରେ ଏପେଙ୍ଗ୍‌ ଇନାଦେରା, ହୁଡ଼ାଟ୍‌, ଇୱାନ୍‌ ରକାନ୍‌ ବାତ୍‌ୱା ଆରି ମଦ୍‌ୱା, ସିସ୍ତୁଏନ୍‌ନାକାର୍‌ ଆରି ପାପିୟାର୍‌ ହାଙ୍ଗ୍‌ଦାକାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","ମତର୍‌ ବୁଦି ନିଜାର୍‌ ୱିଜ଼ାର୍‌ ହିମ୍‌ଣାଂ ତାଙ୍ଗ୍‌ ସମାନ୍‌ ଇଞ୍ଜି ପାର୍ମାଣ୍‌ ଆତାତ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","ଆରି, ପାରୁସିର୍‌ ବିତ୍ରେ ରୱାନ୍‌ ଜିସୁ ନିଜାର୍‌ ଲାହାଙ୍ଗ୍‌ ଚିଞ୍ଜେଙ୍ଗ୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ଗୱାରି କିଜ଼ି କୁକ୍‌ତାନ୍‌ । ହେବେଣ୍ଡାଂ ହେୱାନ୍‌ ପାରୁସି ଇଞ୍ଜ ହଣ୍‌ଜି ଚିଞ୍ଜେଙ୍ଗ୍‌ କୁଚ୍‌ଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","ଆରେ ହୁଡ଼ାଟ୍‌, ହେ ଗାଡ଼୍‌ଦ ରଞ୍ଜେଲ୍‌ ପାପିୟାଣି କଗ୍‌ଲେ ମାଚାତ୍‌; ଜିସୁ ହେ ପାରୁସି ଇଞ୍ଜ ତିନି କାଜିଂ କୁଚ୍‌ଚାନ୍ନା, ଇଦାଂ ପୁଞ୍ଜି ହେଦେଲ୍‌ ର କଣ୍ଡିତ ବାସ୍‌ନା ଚିକାଣ୍‌ ତାସି ୱାତାତ୍‌, ");
INSERT INTO peg_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","ପାଚ୍‍ବାଗାଂ ତା ପାନା ତାରେନ୍‌ ନିଲ୍‌ଚି ଆଡ଼୍‌ଜି ଆଡ଼୍‌ଜି କାଣେଲ୍‌ତାଂ ହେୱାନ୍‌ ପାନାତିଂ ଉଦିକିଜ଼ି ଜାର୍‌ କାପ୍‌ଡ଼ାନି ତେମୁଲ୍‌ତାଂ ହେଦାଂ ନେନ୍‌ଦେଂ ଲାଗାତାତ୍‌ । ଆରେ ଜିସୁ ପାନାତିଂ ଡନ୍‌ଞ୍ଜି ଡନ୍‌ଞ୍ଜି ବାସ୍‌ନା ଚିକାଣ୍‌ କାସ୍‌ତାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","ହେଦାଂ ହୁଡ଼ାଟ୍‌, ଇମ୍‌ଣି ପାରୁସି ତାଙ୍ଗେଙ୍ଗ୍‌ କୁକ୍‌ଚି ମାଚାନ୍‌, “ହେୱାନ୍‌ ମାନେ ମାନେ ଇଚାନ୍‌, ଇୱାନ୍‌ ଜଦି ବେଣ୍‌ବାକ୍‌ଣାୟ୍‌କିନାକାନ୍‌ ଆଜ଼ି ମାଚାନ୍‍ଚି, ତା ଆତିସ୍‌ ଇୱାନିଂ ଜେ ଡୁନାତା, ହେଦେଲ୍‌ ଇନ୍ଦେଲ୍‌ ଆରି ଇନେସ୍‌ ବାର୍ତିନି କଗ୍‌ଲେ, ଇଚିସ୍‌, ହେଦେଲ୍‌ ଜେ ପାପିୟାଣି, ଇଦାଂ ପୁଚାନ୍‍ମା ।” ");
INSERT INTO peg_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","ଜିସୁ ତାଙ୍ଗେଙ୍ଗ୍‌ ଉତର୍‌ ହିତାନ୍‌, “ସିମନ୍‌, ନିଙ୍ଗେଙ୍ଗ୍‌ ଆନ୍‌ ଇନାକାପା ଇଞ୍ଜ୍‌ନାକା ମାନାତ୍‌ ।” ହେୱାନ୍‌ ଇଚାନ୍‌, “ଗୁରୁ ଇଞ୍ଜା ।” ");
INSERT INTO peg_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","“ର ମାଜାନ୍‌ତାଂ ରିୟାର୍‌ ରିଣ୍‌ ଆଜ଼ି ମାଚାର୍‌; ରୱାନ୍‌ ପାଞ୍ଚ୍‌ସହ ଟାକାଂ ଆରି ଆରେ ରୱାନ୍‌ ରିକଡ଼ିଦସ୍ ଟାକାଂ ରିଣ୍‌ ଅଜ଼ି ମାଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","ହୁଜାଆଦେଂ ହେୱାର୍‌ତି ଇନାକା ହିଲ୍‍ୱିତିଲେ ହେୱାନ୍‌ ରିଆର୍‌ତି କେମା କିତାନ୍‌ । ଲାଗିଂ ହେୱାର୍‌ ବିତ୍ରେ ଇନେର୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ଆଦିକ୍‌ ଜିଉନନାନ୍ ?” ");
INSERT INTO peg_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","ସିମନ୍‌ ଉତର୍‌ ହିତାନ୍‌, “ଆନ୍‌ ବାବିକିନାଙ୍ଗା, ହେୱାନ୍‌ ଇନେକିଦେଂ ଆଦିକ୍‌ ରୁଣ୍‌ ପିସ୍ତାନ୍‌, ହେୱାନ୍‌ । ହେୱାନ୍‌ ହେୱାରିଂ ଇଚାନ୍‌, ଏନ୍‌ ହାତ୍‌ପା ବିଚାର୍‌ କିତାୟ୍ ।” ");
INSERT INTO peg_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","ଆରେ, ହେୱାନ୍‌ ହେ କଗ୍‌ଲେ କାଜିଂ ୱେଇ ମାସ୍‌ତି ସିମନ୍‌ତିଂ ଇଚାନ୍‌, “ଇ କଗ୍‌ଲେଂ ହୁଡ଼୍‌ନାୟା ? ଆନ୍‌ ମି ଇଞ୍ଜ ୱାତାଂ, ଏନ୍‌ ନା ପାନା କାଜିଂ ଏଜ଼ୁଂ ହିଦ୍‌ୱାତାୟ୍‌, ମାତର୍‌ ଇଦେଲ୍‌ କାଣେଲିଂ ଲାହାଙ୍ଗ୍‌ ନା ପାନା ଉଦିକିଜ଼ି ନିଜ୍‍ନି ତେମୁଲ୍‌ତାଂ ହେଦାଂ ନେନ୍ତାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","ଏନ୍‌ ନାଙ୍ଗେଙ୍ଗ୍‌ ଡଞ୍ଜି, ହିର୍‌ବା ଆଦ୍‌ୱାତାୟ୍‌ ମାତର୍‌ ଆନ୍‌ ବିତ୍ରେ ୱାତି ସମୁତାଂ ଇଦେଲ୍‌ ନା ପାନା ଡଞ୍ଜାନାକା ପିସ୍ତୁତେ । ");
INSERT INTO peg_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","ଏନ୍‌ ନା କାପ୍‌ଡ଼ାତ ଚିକାଣ୍‌ କାସ୍‌ଦାୱାତାୟ୍‌, ମାତର୍‌ ଇଦେଲ୍‌ ନା ପାନାତ ବାସ୍‌ନା ଚିକାଣ୍‌ କାସ୍‌ଦାତାତ୍ । ");
INSERT INTO peg_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","ଲାଗିଂ ଆନ୍‌ ନିଙ୍ଗେଙ୍ଗ୍‌ ଇଞ୍ଜ୍‌ନାଙ୍ଗା, ଇଦେଲ୍‌ତି ଆଦିକ୍‌ ପାପ୍‌ କେମା ଆତାତ୍‌ନ୍ନା, ଇନାକିଦେଂକି ହେଦେଲ୍‌ ବେସି ଜିଉନନାନ୍; ମାତର୍‌ ଇନେରିଂ ଅଲପ୍‍ କେମା ହିୟାଆନାତ୍, ହେୱାନ୍‌ ଅଲପ୍‍ ଲାଡ୍‍ କିନାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","ଆରି, ଜିସୁ ହେ କଗ୍‌ଲେଂ ଇଚାନ୍‌, “ନି ପାପ୍‌ ୱିଜ଼ୁ କେମା ଆତାତ୍‌ନ୍ନା ।” ");
INSERT INTO peg_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","ହେବେଣ୍ଡାଂ ତା ଲାହାଙ୍ଗ୍‌ ତିନି କୁଚ୍‌ଚି ମାନି ମାନାୟାର୍‌ ମାନେ ମାନେ ଇଞ୍ଜେଙ୍ଗ୍‌ ଲାଗାତାର୍‌, “ପାପ୍‌ ପା କେମା କିନାନା ଜେ, ଇୱାନ୍‌ ଇନେନ୍‌ ?” ");
INSERT INTO peg_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","ମାତର୍‌ ଜିସୁ ହେ କଗ୍‌ଲେଂ ଇଚାନ୍‌, “ନି ପାର୍ତି ନିଙ୍ଗେଙ୍ଗ୍‌ ରାକ୍ୟା କିତ୍‌ତାତ୍‌ନ୍ନା; ସୁସ୍ତାତାଂ ହାଲା ।” ");
INSERT INTO peg_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","ଇବେଣ୍ଡାଂ ଅଲପ୍‍ ସମୁ ପାଚେ ଜିସୁ ଗାଡ଼୍‌ଦ ଗାଡ଼୍‌ଦ ଆରେ ନାସ୍‌କୁ ନାସ୍‌କୁକାଂ ସୁଣାୟ୍‌ କିଜ଼ି ମାପ୍ରୁ ରାଜିନି ନେକ୍ରିକାବୁର୍‌ ସୁଣାୟ୍‍ କିଜ଼ି ପ୍ଡାଞ୍ଜେଙ୍ଗ୍‌ ଲାଗାତାର୍‌, ଆରେ ବାରଜାଣ୍ ଚେଲାହିର୍‌ ତା ଲାହାଙ୍ଗ୍‌ ମାଚାର୍‌, ");
INSERT INTO peg_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","ଆରେ କେତେ ଜାଣ୍‌ କଗ୍‌ଲେହିମ୍‌ଣା ପା ତା ଲାହାଙ୍ଗ୍‌ ହାଲ୍‍ଜି ମାଚିକ୍‌, ଇମ୍‌ଣି କଗ୍‌ଲେ ହିମ୍‌ଣାକାଂ ବାନ୍ୟାପୁଦାତାଂ ଉଜ୍‌ ଆଜ଼ି ମାଚିକ୍‌ ହେୱେକ୍‌ପା ତା ଲାହାଙ୍ଗ୍‌ ମାଚିକ୍‌, ମରିୟମ୍‌ ଇମ୍‌ଣାକା କି ତର୍‌ ମଗ୍‌ଦଲିନି ଇନାର୍‌ ତା ତାକେଣ୍ଡାଂ ସାତ୍‌ଗଟା ପୁଦାଂ ହପ୍‌ଚି ମାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","ହେରଦ୍‌ତି ଗୁମୁସ୍ତା କୁଜାତି ୱାଣି ଜହନା, ସସ୍‌ନ୍ନା, ଆରେ ଆଦିକ୍‌ ହେନି କଗ୍‌ଲେକ୍‌ ତା ଲାହାଙ୍ଗ୍‌ ମାନ୍‌ଞ୍ଜି ଜାର୍‌ ଜାର୍‌ ଦାନ୍‌ ହିଜ଼ି ହେୱାର୍‌ତି ହେବା କିଜ଼ି ମାଚିକ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","ବେସିହେନି ମାନାୟ୍‌ ରୁଣ୍ଡା ଆନିହିଙ୍ଗ୍‌ ଆରି ଗାଡ଼୍‌ ଗାଡ଼୍‌ଦାଂ ମାନାୟ୍‌ ତା ଲାଗେ ୱାତିହିଙ୍ଗ୍‌, ଜିସୁ ଇ ଉତର୍‌ମୁଡ଼୍‌ ହିଜ଼ି ୱେଚ୍‌ଚାନ୍‌, ");
INSERT INTO peg_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“ରୱାନ୍‌ ୱିତ୍‌ନାକାନ୍‌ ନିଜାର୍‌ ବିୟାନ୍‌ ୱିତ୍‌ଦେଙ୍ଗ୍ ହତ୍‌ତାନ୍ । ହେୱାନ୍‌ ୱିତୁ ୱିତୁ କେତେକ୍‌ ହାଜ଼ି କଚଣ୍‌ତ ଆର୍‌ତାତ୍‌ ଆରେ କାଲ୍‌ ତାରେନ୍‌ ଦୁଡ଼ି ଆଜ଼ି ହାତାତ୍‌, ଆରେ ଆକାସ୍‌ନି ପଟିଂ ହେଦାଂ ଚିଚିକ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","ଆରେ କେତେକ୍‌ କାଲ୍‌କୁକୁଡ଼ି ଜପି ଆର୍‌ତାତ୍‌, ପାଚେ ନେସ୍‌ଇ ଚିକ୍‌ଲା ଅଦା ହିଲ୍‌ୱିତିଲେ ୱାଚ୍‍ଚାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","ଆରେ କେତେକ୍‌ ୱାଡ଼ି ମାର୍‌ ବିତ୍ରେ ଆର୍‌ତାତ୍‌, ଆରେ ୱାଡ଼ିଙ୍ଗ୍‌ ମାର୍‍କୁ ହେଦାଂ ହାଙ୍ଗେ ହାଙ୍ଗେ ଗାଜା ଆଜ଼ି ହେୱାକାଂ ଡାବାୟ୍‌ କିତିକ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","ଆଦେକ୍‌ କେତେକ୍‌ ହାର୍ଦି ମେଦ୍‌ନିତ ଆର୍‌ତାତ୍‌, ଆରେ ପାନ୍‌ଚି ପାଞ୍ଚ୍‌କଡ଼ି ଗୁଣ୍‌ ପାଡ଼୍‌ ଆସ୍ତାତ୍‌ ।” ଜିସୁ ଏଲେଙ୍ଗ୍‌ ଇଞ୍ଜି ଇଞ୍ଜି ଗାଜା କାଟ୍‌ତାଂ ଇଚାନ୍‌, “ଇନେରିଂ ୱେଞ୍ଜେଙ୍ଗ୍‌ କିତୁଲିଂ ମାନିକ୍‌, ହେୱାନ୍‌ ୱେନେନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","ଜିସୁ ଚେଲାହିର୍‌ ଇ ଉତର୍‌ମୁଡ଼୍‌ ଅରତ୍‌ ଇନାକା ଇଞ୍ଜି ୱେନ୍‌ବେଦେଂ ଲାଗାତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","ହେବେତାଂ ହେୱାନ୍‌ ଇଚାନ୍‌, “ଇସ୍ୱର୍ତି ରାଜି ବିତ୍ରେନି ବିସ୍ରେ ପୁଞ୍ଜେଙ୍ଗ୍‌ ଇଞ୍ଜି ମିଙ୍ଗେଙ୍ଗ୍‌ ସାକ୍ତି ହିଦ୍‍ୟା ଆତାତ୍‌ନ୍ନା, ମାତର୍‌ ବିନେ ନିକାରିଂ ଉତର୍‌ମୁଡ଼୍‌ଦାଂ ୱେଚ୍‌ୟାନାତ୍‌, ଇନେସ୍‌କି ହେୱାର୍‌ ହୁଡ଼୍‌ଜି ହୁଡ଼୍‌ଜି ହୁଡ଼୍‌ଦେଂ ଆଡୁର୍‌ ଆରି ୱେନୁ ୱେନୁ ବୁଜାଆଉର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“ଉତର୍‌ମୁଡ଼୍‌ନି ଅରତ୍‌ ଇଦାଂ । ବିୟାନ୍‌ ଇସ୍ୱର୍‌ ମାପ୍ରୁତି ବଚନ୍‌, ");
INSERT INTO peg_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","ଆରେ ହାଜ଼ି କଚଣ୍‌ତ ମାନି ବିୟାନ୍‌ ଲାକେ ବୁଜାଆନାର୍‌, କଚଣ୍‌ତ ମାନି ବିୟାନ୍‌ ବୁଜାଆନାର୍‌, ହେୱାର୍‌ ବଚନ୍‌ ୱେନାର୍; ତା ପାଚେ ସୟ୍‌ତାନ୍‌ ୱାଜ଼ି, ଇନେସ୍‌କି ହେୱାର୍‌ ପାର୍ତି କିଜ଼ି ମୁକ୍ତି ଆଉର୍‌ ଇଦାଂ କାଜିଂ ହେୱାର୍‌ ମାନ୍‌ତିନି ବଚନ୍‌ ଉନ୍‌ଦି ଅନାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","ଆରେ କାଲ୍‌କୁକୁଡ଼ି ବୁଇଁନି ବିୟାନ୍‌ ଆର୍‌ତି ଲାଗ୍‌ଦି ମାନାୟାରିଂ ବୁଜାଆନାତ୍‌, ହେୱାର୍‌ ବଚନ୍‌ ୱେନ୍‌ଞ୍ଜି ୱାରିତାଂ ଇଟ୍‌ନାର୍‌; ମାତର୍‌ ହେୱାର୍‌ତି ଚିରାହିଲ୍‌ୱିତିଲେ ହେୱାର୍‌ ଅଲପ୍‍ ସମୁ ପାର୍ତି କିତାର୍‌ ଆରି ପରିକ୍ୟା ସମୁତ ଦରମ୍‌ ପିହ୍‌ନାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","ଆରି ୱାଡ଼ି ମାର୍‍କୁ ବିତ୍ରେ ଆର୍ତାକା ବିୟାନ୍‌, ଏଲେଙ୍ଗ୍‌ ବୁଜାଆନାତ୍‌, ଇମ୍‌ଣାକାର୍‌ ବଚନ୍‌ ୱେନ୍‌ଞ୍ଜି ରାଜିନି ଚିନ୍ତା, ଦାନ୍‌ ଆରି ସୁକ୍‌ବଗ୍‍ତାଙ୍ଗ୍ ମାନ୍‌ଞ୍ଜି ଜିବୁନ୍‌ ବିତାୟ୍‌ କିଜ଼ି କିଜ଼ି ଡାବାୟ୍‌ କିୟା ଆନାର୍‌, ପାଚେ ହାର୍ଦି ପାଡ଼୍‌ ଆହୁର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","ଆରି, ହାର୍ଦି ମେଦ୍‌ନିତ ଆର୍ଜି ମାଚି ବିୟାନ୍‌ ଏଲେଙ୍ଗ୍‌ ବୁଜାଆନାତ୍‌, ଇମ୍‌ଣାକାର୍‌ ହାର୍‌ ଆରି ଦାର୍ମି ମାନ୍ତ ବଚନ୍‌ ୱେନ୍‌ଞ୍ଜି ହେଦାଂ ଆସ୍ତି ଇଟ୍‌ନାର୍‌ ଆରି ବାଡ଼୍‌କାସ୍‌ତାଂ ପାଡ଼୍‌ ଆନାର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“ଇନେର୍‌ ବଇଟା କାଚାୟ୍‌ କିଜ଼ି ମାଣ୍‌ ପ୍ଡାକ୍‌ଚି ଇଟୁନ୍‌, କି କାଟେଲ୍‌ ତାରେନ୍‌ ଇଟୁନ୍‌, ମାତର୍‌ ବଇଟା ଇଟ୍‌ନି ଜପି ଇଟ୍‌ନାନ୍‌, ଇନେସ୍‌କି ହଣ୍‌ଗା ୱାନି ମାନାୟ୍‌ ର ଅଜଡ଼୍‌ ହୁଡ଼୍‍ଦେଂ ଆଡ୍‌ନାର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","“ଇନାକିଦେଂକି ଇନାକା ହତ୍‌ୱାକା, ଇ ଲାକେ ଡ଼ୁଗ୍‌ତି ବିସ୍ରେ ଇନାକା ହିଲୁତ୍‌, ଆୱିତିସ୍‌ ଇନାକା ପୁନ୍‌ୱାଦାଂ ହୱାକାହିଲୁତ୍‍, ଇ ଲାକେ ଡ଼ୁଗ୍‌ତି ବିସ୍ରେ ଇନାକା ହିଲୁତ୍‍ ।” ");
INSERT INTO peg_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“ଏପେଙ୍ଗ୍‌, ଇନେସ୍‌ ୱେନାଦେରା ହେ ବିସ୍ରେ ଜାଗ୍ରତ୍‌; ଇନାକିଦେଂକି ଇନେରିଂ ମାନାତ୍‌, ହେୱାନିଂ ହିୟାନାତ୍‌, ଆରେ ଇନେରିଂ ହିଲୁତ୍‌, ହେୱାନ୍‌ ଇନାକା ଜାର୍‍ତି ମାନାତ୍‌ ଇଞ୍ଜି ବାବି କିନାନ୍‌, ହେଦାଂ ପା ହେୱାନ୍‍ ତାଂ ଅୟାନାତ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","ଜିସୁ ତେହି ଆରି ଟଣ୍ଡାହିର୍‌ ତା ଲାଗେ ୱାତାର୍, ମାତର୍‌ ମାନାୟାର୍‌ ଗହଲି ଲାଗିଂ ତା ଲାହାଙ୍ଗ୍‌ ମେହାଆଦେଂ ଆଡ୍‌ୱାଦାଂ ମାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","ଇନେର୍‌ ରୱାନ୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ଇ କାବୁର୍‌ ହିତାର୍‌, “ମିଞ୍ଜିୟା ଆରି ଟଣ୍ଡାର୍‌ ନି ହୁକେ ବେଟାଆଦେଂ ଇଚା କିଜ଼ି ବାର୍‌ତ ନିଲ୍‌ତାର୍ଣ୍ଣା ।” ");
INSERT INTO peg_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","ମାତର୍‌ ହେୱାନ୍‌ ହେୱାରିଂ ଉତର୍‌ ହିତାନ୍‌, “ଇମ୍‌ଣାକାର୍‌ ଇସ୍ୱର୍‌ତି ବଚନ୍‌ ୱେନାର୍ ଆରି ମାନିକିନାର୍‌, ହେୱାର୍‌ ନା ଆୟା ଆରି ଟଣ୍ଡାର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","ଦିନେକ୍‌ ଜିସୁ ତା ଚେଲାହିର୍‌ ର ଡଙ୍ଗାତ ଦୁମ୍‌ତାର୍‌, “ଆରେ ହେୱାନ୍‌ ହେୱାରିଂ ଇଚାନ୍‌, ୱାଡୁ, ହାମ୍‌ଦୁର୍‌ନି ଆନ୍‌ଟି ପାଡ଼୍‌କା ହାନାସ୍‌ ।” ହେବେତାଂ ହେୱାର୍‌ ଡଙ୍ଗା ରିକ୍ତାର୍ । ");
INSERT INTO peg_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","ମାତର୍‌ ହେୱାର୍‌ ଡଙ୍ଗା ଗାଟିକିଜ଼ି ହାନି ସମୁତ ଜିସୁ ହୁନ୍‌ଚାନ୍‌ । ହେୱାଡ଼ାଂ ହାମ୍‌ଦୁର୍‌ତ ତ୍ରିପ୍‌କୁ ହୁଜ଼ାୱାଣି ଆତାତ୍‌, ଆରେ ହେୱାର୍‌ତି ଡଙ୍ଗା ଏଜ଼ୁକାଂ ବାର୍ତି ଆଦେଂ ଲାଗାତାତ୍‌ ଆରି ହେୱାର୍‌ ସନିତ ପଡ଼ାତାର୍ । ");
INSERT INTO peg_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","ହେବେତାଂ ଚେଲାର୍‌ ଲାଗେ ୱାଜ଼ି ହେୱାନିଂ ନିକ୍‌ଚି ଇଚାର୍‌, “ଏ ଗୁରୁ, ଏ ଗୁରୁ, ଆପେଂ ହାତାପ୍‌ ।” ଇବେତାଂ ଜିସୁ ନିଙ୍ଗ୍‌ଜି ଦୁକା ଆରି ଜବର୍‌ ଲଡ଼ିତିଂ ଦାକା ହିତାନ୍‌, ଆରି ହେ ସବୁ ଚିମ୍‌ରା ଆଜ଼ି ତିର୍‌ ଆତାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","ଆରେ, ହେୱାନ୍‌ ହେୱାରିଂ ଇଚାନ୍‌, “ମିଦାଙ୍ଗ୍‌ ପାର୍ତି ଇମେତ୍‌ ?” ମାତର୍‌ ହେୱାର୍‌ ପାଣ୍ଡ୍ରା ଆତାର୍‌ ଆରି କାବା ଆଜ଼ି ହେୱାର୍‌ ହେୱେର୍‌ ଇଞ୍ଜେଙ୍ଗ୍‌ ଲାଗାତାର୍‌, ଇୱାନ୍‌ ଇନେନ୍‌ ଜେ, ହେୱାନ୍‌ ଦୁକା ଆରି ଏଜ଼ୁକାଂ ପା ବଲ୍‌ ହିତିସ୍‍, ହେୱାଙ୍ଗ୍‌ ହେ ବଲ୍‌ ମାନିକିନିଙ୍ଗ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","ପାଚେ ଜିସୁ ଆରି ତା ଚେଲାହିର୍‌ ଗାଲିଲିନି ଲାଗେ ହେ ପାଡ଼ାକାନି ଗରାସିୟର୍‌ ରାଜି ନିପ ଏକାତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","ହେୱାନ୍‌ ଡଙ୍ଗାତାଙ୍ଗ୍ ହସି ଗୁଟିତ ଜୁଜ଼ି, ହେ ଗାଡ଼୍‌ନି ରକାନ୍‌ ପୁଦାଂ ଆହ୍‌ୟାତାକାନ୍‌ ହେୱାନିଂ ଗିଟାତାନ୍‌; ହେୱାନ୍‌ ବେସି ବାର୍ହୁ ପାତେକ୍‌ ହେନ୍ଦ୍ରା ଉସ୍‌ପାୱାଦାଂ ଆରି ଇଞ୍ଜ ମାନ୍‌ୱାଦାଂ ଦୁଗେର୍‌ତ ମାଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","ହେୱାନ୍‌ ଜିସୁଙ୍ଗ୍‌ ହୁଡ଼୍‌ଜି କିକିରାଡିଂ କିଜ଼ି ହେୱାନ୍‌ ସାରାଣ୍‌ ତାରେନ୍‌ ଆର୍ଜି ଗାଜା କାଟ୍‌ତାଂ ଇଚାନ୍‌, “ଏ ଗାଜା ଇସ୍ୱର୍‌ ମାପ୍ରୁ ମାଜ଼ି ଜିସୁ, ନି ହୁକେ ନାଦାଂ ଇନାକା ମାନାତ୍‌ ? ଆନ୍‌ ନିଙ୍ଗେଙ୍ଗ୍‌ ଗୱାରି କିଦ୍‌ନାଙ୍ଗା, ନାଙ୍ଗେଙ୍ଗ୍‌ କସ୍ଟହିଦ୍‌ମା ।” ");
INSERT INTO peg_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","ଇନାକିଦେଂକି ଜିସୁ ବାନ୍ୟା ଜିବୁନ୍‌ତିଂ ହେ ମାନାୟ୍‌ତିଂ ହସି ହାଞ୍ଜେଙ୍ଗ୍‌ ଇଞ୍ଜି ବଲ୍‌ ହିଜ଼ି ମାଚାନ୍‌ । ହେ ଜିବୁନ୍‌ ବେସିହଟ୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ଆସ୍ତି ମାଚାତ୍‌, ଆରେ ମାନାୟାର୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ହିକ୍‌ଡ଼ିଂ ଆରି କାଲ୍‌ଦ କାଗଡ଼ା ଲାହାଙ୍ଗ୍‌ ଗାଚ୍‌ଚି ଇଡ଼୍‌ଜି ମାଚାର୍‌, ମାତର୍‌ ହେୱାନ୍‌ ଗାଚ୍‌ଚା କାଦ୍‌ଲିଂ ନାଡ଼୍‌ଚି ପୁଦା ହୁଦାଂ ତାଙ୍ଗେଙ୍ଗ୍‌ ବାଟାତ ଅଜ଼ି ମାଚାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","ଜିସୁ ହେୱାନିଂ ୱେନ୍‌ବାତାନ୍‌ “ନି ତର୍‌ ଇନାକା ?” ହେୱାନ୍‌ ଇଚାନ୍‌, ବାହିନି; ଇନାକିଦେଂକି ଆଦିକ୍‌ ପୁଦାଂ ହେୱାନ୍‌ ତାକେ ହଣ୍‌ଜି ମାଚିକ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","ଆରେ, ହେୱାନ୍‌ ଇନେସ୍‌ ହେୱାକାଂ ଜମ୍‌ପୁର୍‌ ହାଞ୍ଜେଙ୍ଗ୍‌ ବଲ୍‌ ହିଉନ୍‌, ଇଦାଂ କାଜିଂ ହେୱାଙ୍ଗ୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ଗୱାରି କିଦେଙ୍ଗ୍‌ ଲାଗିତିକ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","ହେବେ ମାଡ଼ି ଲାଗେ ର ଗାଜା ପାଞ୍ଜିଙ୍ଗ୍‌ ମାନ୍ଦା ହାରାଆଜ଼ି ମାଚିକ୍‌, ଆରେ ହେୱାନ୍‌ ଇନେସ୍‌ ହେୱାକାଂ ହେ ପାଞ୍ଜିଙ୍ଗ୍ ବିତ୍ରେ ହଣ୍ଡେଙ୍ଗ୍‌ ବଲ୍‌ ହିନାନ୍‌, ଇଦାଂ କାଜିଂ ହେୱାଙ୍ଗ୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ଗୱାରି କିତିକ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","ଜିସୁ ହେୱାରିଂ ବଲ୍‌ ହିତିଲେ, ପୁଦାଂ ହେ ମାନାୟ୍‌ ତାକେଣ୍ଡାଂ ହସି ପାଞ୍ଜିଙ୍ଗ୍ ବିତ୍ରେ ହଟିକ୍‌; ହେବେ ହେ ମାଦାଂ ବେସିତାଦ୍ରାତାଂ ହଞ୍ଚି ହାଲ୍‌ଜି ହାମ୍‌ଦୁର୍‌ ଗୁଟିତାଂ ଆର୍ଜି ମୁନ୍‌ଞ୍ଜି ହାତିକ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","ହାରାଇ କିଜ଼ି ମାଚି ମାନାୟାର୍‌ ହେ ଗଟ୍‌ଣା ହୁଡ଼୍‌ଜି ହଞ୍ଚି ହାଲ୍‌ଜି ଗାଡ଼୍‌ଦ ଆରେ ନାସ୍‌କୁକାଂ ହେଦାଂ ୱେଚ୍‌ଚାର୍ । ");
INSERT INTO peg_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","ହେବେ ମାନାୟାର୍‌ ହେ ଗଟ୍‌ଣା ହୁଡ଼୍‌ଦେଂ ହସି ୱାତାର୍; ଆରେ ହେୱାର୍‌ ଜିସୁ କଚଣ୍‌ତ ୱାଜ଼ି, ଇମ୍‌ଣି ମାନାୟ୍‌ ତାକେଣ୍ଡାଂ ପୁଦାଂ ହସି ମାଚିକ୍‌, ତାଙ୍ଗେଙ୍ଗ୍‌ ହେନ୍ଦ୍ରା ଉସ୍ପିସ୍‌ ହାର୍‌ ମାନ୍ତାଙ୍ଗ୍‌ ଜିସୁ କାଲ୍‌କୁ ତାରେନ୍‌ କୁଚ୍‌ଚି ମାନାକା ହୁଡ଼୍‌ଜି ପାଣ୍ଡ୍ରା ଆତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","ଆରି ଇନେର୍‌ ହୁଡ଼୍‌ଜି ମାଚାର୍‌, ହେୱାର୍‌ ହେ ପୁଦାଆହ୍‍ୟା ଆଜ଼ି ମାଚି ମାନାୟ୍‌ ଇନେସ୍‌ ଆଜ଼ି ଉଜ୍‌ ଆତାନ୍‌, ହେଦାଂ ହେୱାରିଂ ୱେଚ୍‌ପାତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","ହେବେ ଗରାସିୟାର୍ ଦେସ୍‌ନି ଚାରିବେଣ୍‌ତି ମାନାୟ୍‌ ୱିଜ଼ାର୍‌ ହେୱାର୍‌ ହାନ୍ଦିତାଂ ହାଞ୍ଜେଙ୍ଗ୍‌ ଜିସୁଙ୍ଗ୍‌ ଗୱାରି କିତାର୍‌, ହେୱାର୍‌ ବେସି ପାଣ୍ଡ୍ରା ଆଜ଼ି ମାଚାର୍‌; ଆରେ, ହେୱାନ୍‌ ର ଡଙ୍ଗାତ ଦୁମ୍‌ଜି ମାସ୍‌ଦି ୱାତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","ମାତର୍‌ ଇମ୍‌ଣି ମାନାୟ୍‌ ତାକେଣ୍ଡାଂ ପୁଦାଂ ହସି ହାଲ୍‌ଜି ମାଚିକ୍‌, “ହେୱାନ୍‌ ଜିସୁ ଲାଗାଂ ମାଞ୍ଜେଙ୍ଗ୍‌ ଗୱାରି କିତାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“ମାତର୍‌ ହେୱାନ୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ପକ୍‌ଚି ଇଚାନ୍‌, ମିଞ୍ଜ ମାସ୍‌ଦି ହାଲା, ଆରେ ଇସ୍ୱର୍‌ତି କାଜିଂ ଇମ୍‌ଣି କାମାୟ୍‌ କିତାନ୍‌ନ୍ନା, ହେଦାଂ ୱିଜ଼ୁ ମାନାୟ୍‌ତିଂ ୱେଚା ।” ହେବେ ହେୱାନ୍‌ ତାଙ୍ଗ୍‌ଜି ହାଲ୍‌ଜି, ଜିସୁ ହେୱାନ୍‌ କାଜିଂ ଇମ୍‌ଣି କାମାୟ୍‌ କିଜ଼ି ମାଚାନ୍‌, ହେଦାଂ ୱିଜ଼ୁ ଗାଡ଼୍‌ଦ ସୁଣାୟ୍‌ କିଦେଙ୍ଗ୍‌ ଲାଗାତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","ଆରେ ଜିସୁ ମାସ୍‌ଦି ୱାତିଲେ ମାନାୟାର୍‌ ଗହଲିତାଂ ତାଙ୍ଗେଙ୍ଗ୍‌, ୱାରିତାଂ ଇଟ୍‌ତାର୍‌, ଇନାକିଦେଂକି ୱିଜ଼ାର୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ କାସି ମାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","ଆରେ, ହୁଡ଼ାଟ୍‌; ଜାଇରସ୍‌ ତର୍‌ଦାକାନ୍‌ ରୱାନ୍‌ ୱାତାନ୍; ହେୱାନ୍‌ ରୱାନ୍‌ କୁଟୁମ୍‌ ଇଞ୍ଜ ମୁଡ଼୍‌ଦାକାନ୍‌ ମାଚାନ୍‌ । ହେୱାନ୍‌ ଜିସୁତି କାଲ୍‌ତାରେନ୍‍ ଗୁର୍‌ଜି ଜାର୍‌ ଇଞ୍ଜ ୱାନି କାଜିଂ ଗୱାରି କିତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","ଇନାକିଦେଂକି ତାତି ବାର ବାର୍ହୁ ବୟସ୍‌ନି ରଞ୍ଜେଲ୍‌ ମତର୍‌ ଗାଡ଼୍‌ଚେ ମାଚାତ୍‌, ଆରେ ହେଦେଲ୍‌ ହାନି ଲାକେ ଆଜ଼ି ମାଚାତ୍‌ । ମାତର୍‌ ହେୱାନ୍‌ ହାନି ସମୁତ ମାନାୟାର୍‌ ତା ଜପି କୁସ୍‌ପିସ୍‌ ମାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","ହେ ପାଦ୍‌ନା ବାର ବାର୍ହୁ ପାତେକ୍‌ ନେତେର୍‌ ନାଡ୍‌ୱାକା ରଗ୍ୟାଣି ର କଗ୍‌ଲେ, ମାଚାତ୍‌ ଇନେସ୍‌କି ତା ଜିବୁନ୍‌ତ ସବୁ ଦାନ୍‌ ୱିସ୍ତି ମାଚାତ୍‌ ପା ଉଜ୍‌ ଆଡ୍‌ୱାଦାଂ ମାଚାତ୍‌, ");
INSERT INTO peg_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","ହେଦେଲ୍‌ ପାଚ୍‌ ବାଗାଙ୍ଗ୍‌ ୱାଜ଼ି ହେୱାନ୍‌ତି ହେନ୍ଦ୍ରାନି ଚେଲିଂ ଡୁତାତ୍‌, ଆରେ ହେ ସାଙ୍ଗେ ତାଙ୍ଗେଙ୍ଗ୍‌ ଗାଗାଡ଼୍‌ ଟେବା ଆତାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","ହେବେଣ୍ଡାଂ ଜିସୁ ଇଚାନ୍‌, “ଇନେର୍‌ ନାଙ୍ଗେଙ୍ଗ୍‌ ଡୁତ୍‌ତାର୍‌ ?” ମାତର୍‌ ୱିଜ଼ାର୍‌ ପାର୍ତିକିୱିହିଙ୍ଗ୍‌, ପିତର୍‌ ଇଚାନ୍‌, “ଏ ଗୁରୁ, ମାନାୟାର୍‌ ମେଲ୍ ମେଲ୍ ଆଜ଼ି ନି ଜପି କୁସ୍‌ପା ଆଦ୍‌ନାରା ।” ");
INSERT INTO peg_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","ମାତର୍‌ ଜିସୁ ଇଚାନ୍‌, “ଇନେର୍‌ ରୱାନ୍‌ ନାଙ୍ଗେଙ୍ଗ୍‌ ଡୁତ୍‌ତାନ୍‌, ଇନାକିଦେଂକି ନାଙ୍ଗ୍‌ତାଂ ସାକ୍ତି ହସି ହାଚି ଲାକେ ଆନ୍‌ ପୁଚାଙ୍ଗ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","ଏଚେକାଡ଼୍‌ଦ କଗ୍‌ଲେ ହୁଡ଼୍‌ତାତ୍‌ ଜେ, ହେଦେଲ୍‌ ଡ଼ୁଗ୍‌ଜି ମାଞ୍ଜେଙ୍ଗ୍‌ ଆଡ୍‌ୱାତାତ୍‌, ହେ ଏଚେକାଡ଼୍‌ଦ ହେଦେଲ୍‌ ତ୍ରିଗ୍‌ଜି ତ୍ରିଗ୍‌ଜି ୱାଜ଼ି ହେୱାନିଂ ଡାଣ୍ଡାହାଡ଼୍‌ ମାଗ୍‌ଜି, ଇନାକିଦେଂ ତାଙ୍ଗେଙ୍ଗ୍‌ ଡୁତାତ୍‌ ଆରି ଇନେସ୍‌ ସାଙ୍ଗେ ସାଙ୍ଗେ ଉଜ୍‌ ଆତାତ୍‌ ହେଦାଂ ୱିଜ଼ାର୍‌ ମାନାୟ୍‌ ମୁମ୍‌ଦ ୱେଚ୍‍ଚାତ୍‍ । ");
INSERT INTO peg_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","ହେବେଣ୍ଡାଂ ହେଦେଲିଂ ଇଚାନ୍‌, “ଏ ଗାଡ଼୍‌ଚେ ନି ପାର୍ତି ନିଙ୍ଗେଙ୍ଗ୍‌ ଉଜ୍‌ କିତ୍‌ତାତ୍‌ନ୍ନା, ସୁସ୍ତାତାଂ ତାଙ୍ଗ୍‌ଜି ହାଲା ।” ");
INSERT INTO peg_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","ହେୱାନ୍‌ ଇ ବେରଣ୍‌ ଇଞ୍ଜିମାନିହିଂ କୁଟୁମ୍‌ ଇଞ୍ଜ୍‌ନି ମୁଡ଼୍‌ଦାକାନ୍‌ ରୱାନ୍‌ ୱାଜ଼ି ଇଚାନ୍‌, “ନି ଗାଡ଼୍‌ ହାତାତେ, ଗୁରୁଙ୍ଗ୍‌ ଆରେ କସ୍ଟ ହିମାଟ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","ମାତର୍‌ ଜିସୁ ଇଦାଂ ୱେନ୍‌ଞ୍ଜି ଜାଇରସ୍‌ତିଂ ଉତର୍‌ ହିତାନ୍‌, “ପାଣ୍ଡ୍ରା ଆମା, କେବଲ୍‌ ପାର୍ତି କିୟା, ଆରେ ହେଦେଲ୍‌ ଉଜ୍‌ ଆନାତ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","ଆରେ, ହେୱାନ୍‌ ଇଞ୍ଜ ୱାଜ଼ି ପିତର୍‌, ଜହନ୍‌ ଆରି ଜାକୁବ୍‌, ଆରେ ଗାଡ଼୍‌ଚେ ଲାତ୍ରାହି ତେହିଙ୍ଗ୍‌ ପିସ୍ତି ଆରେ ଇନେରିଂ ତା ଲାହାଙ୍ଗ୍‌ ବିତ୍ରେ ହଣ୍ତେଙ୍ଗ୍‌ କାଜିଂ ହିୱାତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","ମାତର୍‌ ୱିଜ଼ାକାର୍‌ ହେ କାଜିଂ ଆଡ଼୍‌ଜି ଆଡ଼୍‌ଜି ନେଞ୍ଜେଡାକିତ ଇଡ଼ିୟା ଆଜ଼ି ମାଚାର୍‌ । ହେବେଣ୍ଡାଂ ହେୱାନ୍‌ ଇଚାନ୍‌, “ଆଡ଼୍‌ବାମାଡୁ; ହେଦେଲ୍‌ ହାୱାତାତ୍‌ନ୍ନା, ମାତର୍‌ ହୁଞ୍ଜୁନାତା ।” ");
INSERT INTO peg_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","ମାତର୍‌ ହେଦେଲ୍‌ ହାତାତେ ଇଞ୍ଜି ପୁନ୍ଞ୍ଜି ମାଚିଲେ ହେୱାର୍‌ ଜିସୁଙ୍ଗ୍‌ ଗ୍ରେଚ୍‌ଚେଂ ଲାଗାତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","ମାତର୍‌ ଜିସୁ ତା କେଇ ଆସ୍ତି ହିର୍‌ବିସ୍ ଇଚାନ୍‌, “ଏ ଗାଡ଼୍‌ଚେ ନିଙ୍ଗା ।” ");
INSERT INTO peg_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","ହେବେ ତା ଜିବୁନ୍‌ ୱାତାତ୍‌, ଆରେ ହେଦେଲ୍‌ ହେ ଦାପ୍ରେ ନିଙ୍ଗ୍‌ତାତ୍‌, ଆରେ ଜିସୁ ତାଙ୍ଗେଙ୍ଗ୍‌ ଇଚୁଟିଂ ତିଞ୍ଜେଙ୍ଗ୍‌ ହିଦେଙ୍ଗ୍‍ ଇଞ୍ଜି ବଲ୍‌ ହିତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","ଇବେ ହେ ଲାତ୍ରାହି ତେହି ଟାଟ୍‌କା ଆତାର୍‌; ମାତର୍‌ ହେ ଗଟ୍‌ଣାନି କାତା ଇନେରିଂ ୱେଚ୍‌ପାମାଡୁ ଇଞ୍ଜି ବଲ୍‌ ହିତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","ଇବେତାଂ ହେୱାନ୍‌ ବାରଜାଣ୍ ଚେଲାରିଂ କୁକ୍‌ଚି ରବେ କିଜ଼ି ହେୱାରିଂ ସବୁ ପୁଦାଂ ପିହିକିଦେଂ, ଆରେ ରଗ୍‌ ଉଜ୍‌ କିଦେଙ୍ଗ୍‌ କାଜିଂ ସାକ୍ତି ଆରି ଆଦିକାର୍‌ ହିତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","ଆରେ, ହେୱାନ୍‌ ହେୱାରିଂ ଇସ୍ୱର୍ତି ରାଜିନି ନେକ୍ରିକାବୁର୍‌ ସୁଣାୟ୍‌ କିଦେଙ୍ଗ୍‌ ଆରି ରଗ୍ୟାରିଂ ଉଜ୍‌ କିନି କାଜିଂ ପକ୍‌ତାନ୍‌, ");
INSERT INTO peg_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","ଆରି, ହେୱାରିଂ ଇଚାନ୍‌, “ମି ହାନି କାଜିଂ ବାଡ୍‌ଗା କି ମଣା କି ରୁଟି କି ଡାବୁଙ୍ଗ୍‌ ପା ଅମାଟ୍‌, ନଲେ ରିଣ୍ଡାଂ ଆଙ୍ଗିଙ୍ଗ୍‌ ରଚେ ଇଟ୍‌ମାଟ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","ଆରେ, ଏପେଙ୍ଗ୍‌ ଇମ୍‌ଣି ଇଞ୍ଜ ମାନିକିଦ୍‌ନାର୍‌, ହେ ବାହାତାଂ ହାଲ୍‍ୱି ପାତେକ୍‌ ହେବେ ମାନାଟ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","ଆରେ, ଏଚେକ୍‌ ଜାଣ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ମାନିକିଦୁର୍‌, ହେ ନାସ୍‌ତାଂ ୱାନିହିଂ ହେୱାର୍‌ ବିରୁଦ୍‌ତ ସାକି ହିନି କାଜିଂ ମି ପାନାନି ଦୁଡ଼ି ଡ଼ାତ୍‍ତି ତୁହିୟାଟ୍ । ");
INSERT INTO peg_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","ହେବେଣ୍ଡାଂ ହେୱାର୍‌ ହାଲ୍‌ଜି ୱିଜ଼ୁ ବାହାତ ନେକ୍ରିକାବୁର୍‌ ସୁଣାୟ୍‌ କିତାର୍‌ ଆରି ଉଜ୍‌ କିଜ଼ି କିଜ଼ି ନାସ୍‌କୁ ନାସ୍‌କୁକାଂ ବୁଲାଆଦେଂ ଲାଗାତାର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","ଇବେଣ୍ଡାଂ ଗାଲିଲିନି ସାମନ୍ତ ରାଜା ହେରଦ୍‌ ଇ ୱିଜ଼ୁ ଗଟ୍‌ଣା ବିସ୍ରେ ୱେନ୍‌ଞ୍ଜି ବୁଦିଆନ୍ଦାର୍ ଆତାନ୍‌, ଇନାକିଦେଂକି ବାପ୍ତିସିମ୍‌ହିନି ଜହନ୍‌ ହାତି ତାକେଣ୍ଡାଂ ନିଂତାନ୍ନା ଇଞ୍ଜି ଇନେ ଇନେର୍‌ ଇଞ୍ଜି ମାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","ଆରେ, ଇନେ ଇନେର୍‌ ଏଲିୟ ଚଞ୍ଜ୍ୟା ଆତାନ୍ନା ଇଞ୍ଜି ଇଞ୍ଜି ମାଚାର୍‌ ଆରି ବିନ୍‌ନିକାର୍‌ ଆଗେଦିନ୍ତି ବେଣ୍‌ବାକ୍‌ଣାୟ୍‌କିନାକାନ୍ତି ବିତ୍ରେ ରୱାନ୍‌ ଆରେ ନିଂତାନ୍ନା ଇଞ୍ଜି ଇଞ୍ଜି ମାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","ମାତର୍‌ ହେରଦ୍‌ ଇଚାନ୍‌, “ଜହନ୍‌ତି କାପ୍‌ଡ଼ାତ ଆନ୍‌ ଟୁଟାଙ୍ଗ୍‍ନା, ମାତର୍‌ ଇନେର୍‌ ବିସ୍ରେ ଏଲେଙ୍ଗ୍‌ ବାନି କାତା ୱେନାପା, ଇୱାନ୍‌ ଇନେନ୍‌ ? ଆରେ, ହେୱାନ୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ହୁଡ଼୍‌ଦେଂ ଇଞ୍ଜି ସେସ୍ଟା କିଜ଼ି ମାଚାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","ପାଚେ ପକ୍ୟାତାକାର୍‌ ମାସ୍‌ଦି ୱାଜ଼ି, ଇନା ଇନାକା କିଜ଼ି ମାଚାର୍‌, ହେ ୱିଜ଼ୁ ତା ତାକେ ୱେଚ୍‌ପାତାର୍‌ । ଆରେ ହେୱାନ୍‌ ହେୱାରିଂ ରଚେ ଅଜ଼ି ହାଲ୍‌ଜି ବିନେ ଆଜ଼ି ବେତ୍‌ସାଇଦା ଇନି ଗାଡ଼୍‌ଦ ହାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","ମାତର୍‌ ମାନାୟାର୍‌ ହେଦାଂ ପୁଞ୍ଜି ହେୱାନ୍‌ ପାଚେ ହାଚାର୍‌; ଆରେ, ହେୱାନ୍‌ କାର୍ମା ଆଜ଼ି ହେୱାରିଂ ଅଜ଼ି ହାଲ୍‌ଜି ଇସ୍ୱର୍ତି ରାଜି ବିସ୍ରେ ହେୱାରିଂ ୱେଚ୍‌ଚେଙ୍ଗ୍‌ ଲାଗାତାନ୍‌, ଆରେ ଇନେର୍‌ତି ଉଜ୍‌ ଆଦେଂ ଇଚା ମାଚାତ୍‌, ହେୱାରିଂ ଉଜ୍‌ କିତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","ଇଦାଂ ପାଚେ ୱେଡ଼ା ହାନିହିଂ; ହେବେ ବାରଜାଣ୍‌ ହେୱାନ୍‌ କଚଣ୍‌ତ ୱାଜ଼ି ଇଚାର୍‌, “ମାନାୟାର୍‌ ଇନେସ୍‌ ଚାରିବେଣ୍‌ତି ନାସ୍‌କୁ ଆରି ଗୁଡ଼ାନିକାର୍‌ ହାଲ୍‌ଜି ମାଞ୍ଜେଙ୍ଗ୍‌ ଆରି କାଦି ପାୟା ଆନାର୍‌, ହେଦାଂ କାଜିଂ ହେୱାରିଂ ପକାମ୍‌ଦେ, ଇନାକିଦେଂକି ଆସେଙ୍ଗ୍‌ ଇବେ ଚିମ୍‌ରା ବାହାତ ମାନାସ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","ମାତର୍‌ ହେୱାନ୍‌ ହେୱାରିଂ ଇଚାନ୍‌, “ଏପେଙ୍ଗ୍‌ ହେୱାରିଂ ଚିଚ୍‌ପାଟ୍‌ ।” ହେୱାର୍‌ ଇଚାର୍‌, “ମା ତାକେ ପାଞ୍ଚ୍‌ଗଟା ରୁଟିଂ ଆରେ ରିଣ୍ଡାଂ ମିନ୍‌କୁ ତାଙ୍ଗ୍‌ ଆଗ୍‍ଡ଼ା ହିଲୁକ୍‌; ତାଆତିସ୍‌ ଆସେଙ୍ଗ୍‌ ଇନାକା ହାଲ୍‌ଜି ଇ ୱିଜ଼ାକାର୍‌ ମାନାୟ୍‌ କାଜିଂ କାଦି କଡ଼୍‌ନାସ୍‌ ?” ");
INSERT INTO peg_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","ଇନାକିଦେଂକି ହେୱାର୍‌ ଆନ୍‌ମାନ୍‌ ପାଞ୍ଚ୍‌ ହାଜାର୍‌ ଆଣ୍ଡ୍ରାହିମ୍‌ଣାଂ ମାଚାର୍‌ । “ଆରି, ଜିସୁ ଜାର୍‌ ଚେଲାହିରିଂ ଇଚାନ୍‌, ଇସାବ୍‌ କିଜ଼ି ରିକଡିଦସ୍‌ ରିକଡ଼ି ଦସ୍‌ଜାଣ୍ କିଜ଼ି ହେୱାରିଂ ମାନ୍ଦା ମାନ୍ଦା କିଜ଼ି କୁଚିକିୟାଟ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","ହେବେଣ୍ଡାଂ ହେୱାର୍‌ ହେ ଲାକେ କିଜ଼ି ୱିଜ଼ାରିଂ କୁଚିକିତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","ଆରେ, ଜିସୁ ହେ ପାଞ୍ଚ୍‌ଗଟା ରୁଟିଂ ଆରେ ରିଣ୍ଡାଂ ମିନ୍‌କୁ ଅଜ଼ି ବାଦାଡ଼୍‌ତିଂ ହୁଡ଼୍‌ଜି ହେ ୱିଜ଼ୁକାଙ୍ଗ୍‌ ଆସିର୍ବାଦ୍‌ କିତାନ୍‌, ଆରେ ଡ୍ରିପ୍‌କିସ୍‌ ୱିଜ଼ୁ ଲଗାଂ ଚିଚ୍‍ପି କିଦେଙ୍ଗ୍‌ କାଜିଂ ଚେଲାରିଂ ହିଦେଂ ଲାଗାତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","ହେବେ ୱିଜ଼ାକାର୍‌ ତିନ୍‌ଞ୍ଜି ପଟ ପାଞ୍ଚାର୍‌, ଆରେ ହେୱେର୍‌ ହେୱାର୍‌ କଚଣ୍‌ ହାର୍‌ତିକିଙ୍ଗ୍‌ ବାର ଟପା ଡ୍ରିଙ୍ଗ୍‌ତି କୁଦ୍ରି ପେସ୍‌ଜି ଅତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","ରଗ ଜିସୁ ଚିମ୍‌ରାତାଂ ପାର୍ତାନା କିଜ଼ି ମାନିହିଂ ଚେଲାହିର୍‌ ତା ଲାହାଙ୍ଗ୍‌ ମାଚାର୍‌, ଆରେ ଜିସୁ ହେୱାରିଂ ୱେନ୍‌ବାତାନ୍‌, “ଆନ୍‌ ଇନେନ୍‌ ଇଞ୍ଜି ମାନାୟାର୍‌ ଇନାକା ଇଞ୍ଜ୍‌ନାରା ?” ");
INSERT INTO peg_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","“ଇବେ ହେୱାର୍‌ ଉତର୍‌ ହିତାର୍‍, ବାପ୍ତିସିମ୍‌ ହିନି ଜହନ୍‌,” ମାତର୍‌ ଇନେର୍‌ ଇନେର୍‌ ଇନାର୍‌, “ଏଲିୟ, ଆରେ ଇନେର୍‌ ଇନେର୍‌ ଇନାରା, ଆଗେନି ଦିନ୍ତି ବେଣ୍‌ବାକ୍‌ଣାୟ୍‌ କିନାକାନ୍‌ ବିତ୍ରେ ରୱାନ୍‌ ଆରେ ନିଂତାକାନ୍‌ ଆତାନ୍ନା ।” ");
INSERT INTO peg_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","ଜିସୁ ହେୱାରିଂ ୱେନ୍‌ବାତାନ୍‌, “ମାତର୍‌ ଆନ୍‌ ଇନେନ୍‌ ଇଞ୍ଜି ଏପେଙ୍ଗ୍‌ ଇନାକା ଇଞ୍ଜ୍‌ନାଦେରା ?” ପିତର୍‌ ଉତର୍‌ ହିତାନ୍, “ଇସ୍ୱର୍ତି କ୍ରିସ୍ଟ ।” ");
INSERT INTO peg_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","ଆରେ ଜିସୁ ହେୱେରିଂ ଇଚାନ୍‌ ଇଦାଂ ଇନେରିଂ ୱେଚ୍‌ମାଟ୍‌ ଇଞ୍ଜି ହେୱାରିଂ ଡାଟ୍‌ କିଜ଼ି ବଲ୍‌ ହିଜ଼ି ଇଚାନ୍‌, ");
INSERT INTO peg_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","ଆରେ ହେୱାନ୍‌ ହେୱାରିଂ ଇଚାନ୍‌, “ମାନାୟ୍‌ ମାଜ଼ିଂ ଆଦିକ୍‌ ଦୁକ୍‌ପାୟା ଆନାକା ମାନାତ୍‌ ଆରେ ବୁଡ଼ାଲୁର୍‌, ମୁଡ଼୍‌ ମାପ୍ରୁହେବାକିନାକାନ୍‌ ଆରି ସାସ୍ତିର୍‌ ହୁକେ ମୁନା କିୟା ଆଜ଼ି ହାନାକା ଆନାତ୍‌, ଆରେ ତିନ୍‌ଦିନ୍‌ତାଂ ନିଙ୍ଗ୍‌ନାକା ମାନାତ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","ହେ ପାଦ୍‌ନା ଜିସୁ ୱିଜ଼ାରିଂ ୱେଚ୍‌ଚାନ୍‌, “ଇନେନ୍‌ ଏଚେକାଡ଼୍‌ଦ ନା ଲାହାଙ୍ଗ୍‌ ୱାଦେଙ୍ଗ୍‌ ଇଚା କିନାନ୍‌, ୱିଜ଼ୁ ପିସ୍ତି ସବୁଦିନା ହେୱାନ୍‌ କ୍ରୁସ୍‌ ଆସ୍ତି ନା ଲାହାଙ୍ଗ୍‌ ୱାୟେନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","ଇନାକିଦେଂକି ଇନେନ୍‌ ଜାର୍‌ ଜିବୁନ୍‌ ରାକ୍ୟା କିଦେଙ୍ଗ୍‌ ଇଚା କିନାନ୍‌, ହେୱାନ୍‌ ତା ଜିବୁନ୍‌ ଆରାୟ୍‌ କିନାନ୍‌; ମାତର୍‌ ଇନେର୍‌ ଜଦି ନା କାଜିଂ ହେୱାନ୍‌ ଜିବୁନ୍‌ ଆରାୟ୍‌ କିନାନ୍‌, ହେୱାନ୍‌ ହେଦାଂ ରାକ୍ୟା କିନାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","ଆରି, ମାନାୟ୍‌ ଏଚେକାଡ଼୍‌ଦ ୱିଜ଼ୁ ପୁର୍ତିତିଂ ଲାବ୍‌ କିଜ଼ି ଜାର୍‌ ଜିବୁନ୍‌ ଆରାୟ୍‌ କିନାନ୍‌, ତେବେ ତାଦାଙ୍ଗ୍‌ ଇନା ଲାବ୍‌ ? ");
INSERT INTO peg_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","ଲାଗିଂ ଇନେର୍‌କି ଜଦି ନା ଆରେ ନାଦାଂ ବେରଣ୍‌ ବିସ୍ରେ ଲାଜ୍‍କୁଡ଼ା ଆନାନ୍‌, ମାନାୟ୍‌ ମାଜ଼ି ଏଚେକାଡ଼୍‌ଦ ଜାର୍‌ତି ଆରି ଆବାତି, ମତର୍‌ ପୁଇପୁୟା ଦୁତ୍‌ର୍‌ ଜାଜ୍‌ମାଲ୍‌ ୱାନାନ୍, ହେୱେଡ଼ାଂ ହେୱାନ୍‌ ହେଦାଂ ବିସ୍ରେ ଲାଜା ଆନାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","ମାତର୍‌ ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ହାତ୍‌ପା ଇଞ୍ଜ୍‌ନାଙ୍ଗା, ଇସ୍ୱର୍ତି ରାଜି ହୁଡ଼୍‍ୱି ପାତେକ୍‌ ଇବେ ନିଲ୍‌ଚିମାନି ଲକୁ ବିତ୍ରେ ଏଚେକ୍‌ଜାଣ୍‌ ଇନେସ୍‌ କିଜ଼ିପା ହାକି ହୁଡ଼ୁର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","ଇ ୱିଜ଼ୁ ଗଟ୍‌ଣାନି ଆଟ୍‌ ଦିନ୍‌ ପାଚେ ହେୱାନ୍‌ ପିତର୍‌, ଜହନ୍‌ ଆରି ଜାକୁବ୍‌ତିଂ ରଚେ ଅଜ଼ି ହାଲ୍‌ଜି ପାର୍ତାନା କିନି କାଜିଂ ମାଡ଼ି ଜପି ହାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","ଆରେ, ଜିସୁ ପାର୍ତାନା କିନି ୱେଡ଼ାଲିଂ ତା ମୁମ୍‌ ବାଦ୍‌ଲି ଆତାତ୍‌ ଆରି ତା ହେନ୍ଦ୍ରା ଡ଼ିନ୍‍ଞ୍ଚାତ୍‍ ଆରି ଜବର୍‌ ଅଜଡ଼୍‌ ଆତାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","ଆରେ ହୁଡ଼ାଟ୍‌ ତ୍ରିପ୍‌କୁ, ମସା ଆରି ଏଲିୟ, ଇ ରିୟାର୍‌ ହେୱାନ୍‌ ଲାହାଙ୍ଗ୍‌ ବେରଣ୍‌ କିଦେଙ୍ଗ୍‌ ଲାଗାତାର୍‌; ");
INSERT INTO peg_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","ହେୱାର୍‌ ସାର୍ଗେ ପାଣ୍‌ତାଂ ଚଞ୍ଜ୍‌ୟା ଆଜ଼ି ମାଚାର୍‌, ହେୱାନ୍‌ ଜିରୁସାଲମ୍‌ତ ଇନାୱାଡ଼ାଙ୍ଗ୍‌ ହାଞ୍ଜେଙ୍ଗ୍‍ ଜାଲ୍‌ଦି ଆଜ଼ି ମାନାର୍‌, ହେ ବିସ୍ରେ ଇଞ୍ଜି ମାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","ହେ ୱାଡ଼ାଙ୍ଗ୍ ପିତର୍‌ ଆରି ତା ହାଙ୍ଗ୍‌ଦାକାର୍‌ ହୁଚ୍‌କାଣ୍‌କୁ ହତିଲେ ହୁନ୍‌ଞ୍ଜି ମାଚାର୍‌; ମାତର୍‌ ହେୱାର୍‌ ହୁନ୍‌ଜି ନିଙ୍ଗ୍‌ନିହିଂ ହେୱାନ୍ତି ଜାଜ୍‌ମାଲ୍‌ ଆରି ତା ଲାହାଂ ନିଲ୍‌ଚି ମାନି ହେ ରିୟାରିଂ ହୁଡ଼୍‌ତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","ପାଚେ ହେୱାର୍‌ ତା ତାକେଣ୍ଡାଂ ହାନିହିଂ ପିତର୍‌ ଜିସୁଙ୍ଗ୍‌ ଇଞ୍ଜେଙ୍ଗ୍‌ ଲାଗାତାନ୍‌, “ଏ ଗୁରୁ, ଆପେଂ ଜେ ଇ ବାହାତ ମାନାପ୍‌, ଇଦାଂ ହାର୍‌ଦାକା; ଆସେଙ୍ଗ୍‌ ତିନ୍‌ଗଟା ପୁଟ୍‌କୁ ରଚ୍‌ନାସ୍‌, ନି କାଜିଂ ରଞ୍ଜାଙ୍ଗ୍‌, ମସା କାଜିଂ ରଞ୍ଜାଙ୍ଗ୍‌ ଆରେ ଏଲିୟ କାଜିଂ ରଞ୍ଜାଙ୍ଗ୍‌ ।” ମାତର୍‌ ହେୱାନ୍‌ ଇନାକା ଇନାନ୍ନା, ହେଦାଂ ପୁନ୍‌ୱାଦାଂ ମାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","ପିତର୍‌ ଇଦାଂ ଇନୁ ଇନୁ ବାଦାଡ଼୍‌ ୱାଜ଼ି ହେୱାରିଂ ଡାବାୟ୍‌ କିତାତ୍‌, ଆରେ ହେୱାର୍‌ ବାଦାଡ଼୍‍ତାକେ ହଣ୍‌ଗିନିହିଙ୍ଗ୍‌ ପାଣ୍ଡ୍ରା ଆତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","ପାଚେ ହେ ବାଦାଡ଼୍‌ତାଂ ଇ କାତା ଆତାତ୍‌, “ଇୱାନ୍‌ ନା ମାଜ଼ି, ମା ବାଚି କିତି ଇୱାନ୍ତି ବଚନ୍‌ ୱେନାଟ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","ଆରେ, ହେ କାତା ଆତି ପାଚେ ଜିସୁ ରୱାନ୍‌ନେ ଚନ୍‌ଞ୍ଜାତାନ୍‌ । ପାଚେ, ହେୱାର୍‌ ଚିମ୍‌ରା ଆଜ଼ି ମାଚାର୍‌, ଆରେ ଇନା ଇନାକା ହୁଡ଼୍‌ଜି ମାଚାର୍‌, ହେବେଣ୍ଡାଂ ଇନା ବେରଣ୍‌ ହେୱାଡ଼ାଂ ଇନେରିଂ ୱେଚ୍‌ୱାତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","ମାହିଙ୍ଗ୍‌ନି ଦିନ୍‌ ଜିସୁ ଆରେ ତିନ୍‌ଜାଣ୍‌ ଚେଲାର୍‌ ମାଡ଼ିତାଂ ଜୁଜ଼ି ୱାତିଲେ, ବେସିହେନି ମାନାୟ୍‌ ତା ଲାହାଙ୍ଗ୍‌ ବେଟା ଆତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","ଆରେ ହୁଡ଼ାଟ୍‌, ମାନାୟ୍‌ ଗହଲି ବିତ୍ରେତାଂ ରୱାନ୍‌ ଗାଜା ୱେଇ କିଜ଼ି ଇଚାନ୍‌, “ଏ ଗୁରୁ, ଆନ୍‌ ନିଙ୍ଗେଙ୍ଗ୍‌ ଗୱାରି କିଦ୍‌ନାଙ୍ଗା, ନା ମାଜ଼ି କାଜିଂ କାର୍ମା ହୁଡ଼ା, ଇନାକିଦେଂକି ହେୱାନ୍‌ ନା ରୱାନ୍‌ ଇଞ୍ଜି ମାଜ଼ି; ");
INSERT INTO peg_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","ହୁଡ଼ାଟ୍‌, ତାଙ୍ଗେଙ୍ଗ୍‌ ର ପୁଦା ଆହ୍‌ନାତ୍‌, ଆରେ ହେୱାନ୍‌ ତ୍ରିପ୍‌କୁ କିର୍‌ଡ଼ି କିଜ଼ି ନିଙ୍ଗ୍‌ନାନ୍‌, ପାଚେ ହେୱାନିଂ ଏଲେଙ୍ଗ୍‌ ମଡ଼ିକିନାତ୍‌ ଜେ, ତା ୱେଇଦିଂ ପେପ୍‌ଲା ହତ୍‌ନାତ୍‌, ପାଚେ ହେଦାଂ ତାଙ୍ଗେଙ୍ଗ୍‌ ଚିର୍‌ବିର୍‌ କିଜ଼ି ତା ତାକେଣ୍ଡାଂ କେତେ କସ୍ଟତାଂ ହସି ହାନାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","ତାଙ୍ଗେଙ୍ଗ୍‌ ପିହିକିଦେଂ ଇଞ୍ଜି ଆନ୍‌ ନି ଚେଲାରିଂ କୁକ୍‌ଚି ମାଚାଙ୍ଗ୍‌, ମାତର୍‌ ହେୱାର୍‌ ଆଡ୍‌ୱାତାର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","ଜିସୁ ଉତର୍‌ ହିତାନ୍‌, “ଆଡ଼େ ପାର୍ତିକିୱାକାଦେର୍‌ ଆରି ବାନ୍ୟା ଲାତ୍ରାର୍‌, ଏଚେକ୍‌ ଦିନ୍‌ ଆନ୍‌ ମି ଲାହାଙ୍ଗ୍‌ ରଚେ ମାନ୍‌ଞ୍ଜି ମି ଚିନ୍ତା ଏଚେକ୍‌ ହୁଞ୍ଜ୍‌ନାଙ୍ଗ୍‌ ? ମି ମାଜ଼ିଙ୍ଗ୍‌ ନା ତାକେ ତାଇୱାଡୁ ।” ");
INSERT INTO peg_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","କାଡ଼୍‌ଦେ ୱାଉ ୱାଉ ପୁଦା ତାଙ୍ଗେଙ୍ଗ୍‌ ତାରେନ୍‌ ଗ୍ରୁତ୍‌ତି ବେସି ରାଗ୍‌ଦାଂ ମଡ଼ିକିତାତ୍‌, ମାତର୍‌ ଜିସୁ ବାନ୍ୟା ଜିବୁନ୍‌ତିଂ ଦାକା କିତାନ୍‌ ଆରି କାଡ଼୍‌ଦେଂ ଉଜ୍‌ କିଜ଼ି ତାଞ୍ଜିଆବା କେଇଦ ହିତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","ହେବେ ୱିଜ଼ାକାର୍‌ ଇସ୍ୱର୍ତି ଗାଜା ସାକ୍ତି କାଜିଂ କାବା ଆଜ଼ି ହାଚାର୍‌ । ମାତର୍‌ ହେୱାନ୍‌ କିତି ୱିଜ଼ୁ କାମାୟ୍‌ କାଜିଂ ୱିଜ଼ାକାର୍‌ ଚାନ୍ୟା ଆଜ଼ି ମାନି ୱେଡାଙ୍ଗ୍‌ ଜିସୁ ତା ଚେଲାରିଂ ଇଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“ଇ ୱିଜ଼ୁ ବେରଣ୍‌ ମି କିତୁଲିକାଂ ନେଚ୍‌ଚାଟ୍‌; ଇନାକିଦେଂକି ମାନାୟ୍‌ ମାଜ଼ି ମାନାୟ୍‌ କେଇଦ ହେଲାୟ୍‌ କିୟା ଆଦେଂ ହାନାନା ।” ");
INSERT INTO peg_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","ମାତର୍‌ ଚେଲାହିର୍‌ ହେ ଇ ବେରଣ୍‌ ବୁଜା ଆୱାତାର୍‌, ଆରେ ହେଦାଂ ହେୱାର୍‌ତାକେଣ୍ଡାଂ ଡ଼ୁଗ୍‌ଜି ମାଚାତ୍‌, ଇନେସ୍‌ ହେଦାଂ ହେୱାର୍‌ତି ଅବୁଜା ଆଉତ୍‌, ଆରେ ହେୱାର୍‌ ହେ କାତା ବିସ୍ରେ ତାଙ୍ଗେଙ୍ଗ୍‌ ୱେନ୍‌ବେଦେଂ ପାଣ୍ଡ୍ରା ଆଜ଼ି ମାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","ହେୱାର୍‌ ବିତ୍ରେ ଇନେନ୍‌ ଗାଜାକାନ୍‌, ହେ ବିସ୍ରେ ହେୱାର୍‌ ବିତ୍ରେ ଇନ୍‌ବା ଆତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","ମାତର୍‌ ଜିସୁ ହେୱାର୍‌ତି ମାନ୍ତ ବେଣ୍‌ବାଟ୍‌ କିନାକା ପୁନ୍‌ଞ୍ଜି ର ହିରୁକାନ୍ କାଡ଼୍‌ଦେଂ ଅଜ଼ି ଜାର୍‌ କଚଣ୍‌ତ ନିଲି କିଜ଼ି ହେୱାରିଂ ଇଚାନ୍‌, ");
INSERT INTO peg_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","ଇନେର୍‌ ନା ତର୍‌ଦାଂ ଇ ହିରୁ ହିମ୍‌ଣାତିଂ ମାନିକିନାର୍‌, “ହେୱାର୍‌ ନାଙ୍ଗେଙ୍ଗ୍‌ ମାନିକିଦ୍‌ନାର୍‌, ଆରେ ଇନେର୍‌ ନାଙ୍ଗେଙ୍ଗ୍‌ ଇଟ୍‍ଦାନାର୍‌, ହେୱାର୍‌ ନା ପକ୍‍ତାତାକିନିଂ ମାନ୍‌କିନାର୍‌; ଇନାକିଦେଂକି ମି ୱିଜ଼ାଦେର୍‌ ବିତ୍ରେ ଇନେନ୍‌ ହିରୁକାନ୍; ହେୱାନ୍‌ ଗାଜାକାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","ହେବେ ଜହନ୍‌ ଉତର୍‌ ହିତାନ୍‌, “ଏ ଗୁରୁ, ଆପେଂ ରୱାନିଂ ନି ତର୍‌ଦାଂ ପୁଦା ପିହି କିନାକା ହୁଡ଼୍‌ତାପ୍‌, ଆରେ ହେୱାନ୍‌ ମା ଦଲ୍‌ଦ ୱାୱିକାଜିଂ ତାଙ୍ଗେଙ୍ଗ୍‌ ମୁନା କିତାପ୍ ।” ");
INSERT INTO peg_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","ମାତର୍‌ ଜିସୁ ତାଙ୍ଗେଙ୍ଗ୍‌ ଇଚାନ୍‌, “ମୁନା କିମାଟ୍‌,” ଇନାକିଦେଂକି ମିଦାଙ୍ଗ୍‌ ଆଣ୍ଟିପାକ୍ୟା ଆକାୟ୍‌, “ହେୱାନ୍‌ ମି ପାକ୍ୟା ।” ");
INSERT INTO peg_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","ପାଚେ ଏଚେକାଡ଼୍‌ଦ ଜିସୁ ପୁର୍ତି ପିସ୍ତି ସାର୍ଗେ ହାନି ଦିନ୍‌ ଲାଗେ ୱାଜ଼ି ମାଚାତ୍‌, ହେୱାଡ଼ାଂ ହେୱାନ୍‌ ଜିରୁସାଲମ୍‌ତ ହାଞ୍ଜେଙ୍ଗ୍‌ ତିୟାର୍ ଆତାନ୍‌, ");
INSERT INTO peg_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","ହେୱାନ୍‌ ଆଗେ ଦୁତ୍‌ତିଂ ପକ୍‌ତାନ୍‌ । ହେୱାର୍‌ ହାଲ୍‌ଜି ଜିସୁ କାଜିଂ ଜାଲ୍‌ଦି କିଦେଙ୍ଗ୍‌ ସମିରଣିୟନି ତର୍‌ଦି ର ନାସ୍ତ ହଣ୍‌ଙ୍ଗାତାର୍‌; ");
INSERT INTO peg_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","ମାତର୍‌ ହେୱାନ୍‌ ଜିରୁସାଲମ୍‌ତ ହାଞ୍ଜେଙ୍ଗ୍‍ ମାନ୍‌ କିତାନ୍‌ନ୍ନା ଇଞ୍ଜି ପୁଞ୍ଜି ହେୱାର୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ଇଟ୍‍ୱାତାର୍‍ । ");
INSERT INTO peg_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","ଇଦାଂ ହୁଡ଼୍‌ଜି ଜାକୁବ୍‌ ଆରେ ଜହନ୍‌, ଇ ରିୟାର୍‌ ଚେଲାହିର୍‌ ଜିସୁଙ୍ଗ୍‌ ଇଚାର୍‌, ମାପ୍ରୁ “ଏଲିୟ ପା ଇନେସ୍‌ କିଜ଼ି କିଜ଼ି ମାଚାନ୍‌, ହେ ଲାକେ ସାର୍ଗେତାଂ ନାଣି ଆର୍ଜି ହେୱାରିଂ ବୁଡାଇ କିନାତ୍‌, ଇଦାଂ ଆପେଂ ଇଞ୍ଜ୍‌ନାପ୍‌ ଇଞ୍ଜି ଇନାକା ନି ଇଚା ?” ");
INSERT INTO peg_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","ମାତର୍‌ ହେୱାନ୍‌ ମାସ୍‌ଦି ହେୱାରିଂ ଗଡ଼୍‌ କିତାନ୍‌ ଆରି ଇଚାନ୍‌, ଏପେଙ୍ଗ୍‌ ଇନେସ୍‌ ବାର୍ତି ଜିବୁନ୍‌ନି ମାନାୟ୍‌, ଇଦାଂ ପୁନୁଦେରା । ମାନାୟ୍‌ ମାସ୍‌ଦି ମାନାୟ୍‌ତିଂ ଜିବୁନ୍‌ ନସ୍ଟ କିଦେଙ୍ଗ୍‌ ୱାୱାଦାଙ୍ଗ୍‌ ରାକ୍ୟା କିଦେଙ୍ଗ୍‌ ୱାତାଂନା । ");
INSERT INTO peg_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","ତା ପାଚେ ହେୱାର୍‌ ଆରେ ର ନାସ୍ତ ତାଙ୍ଗ୍‌ଜି ହାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","ହେୱାର୍‌ ହାସ୍‌ଦିଙ୍ଗ୍‌ ହାନିହିଂ ରୱାନ୍‌ ମାନାୟ୍‌ ଜିସୁଙ୍ଗ୍‌ ଇଚାନ୍‌, ଏନ୍‌ ଇମ୍‌ଣି ବାହାତ ହାନାୟ୍‌, “ଆନ୍‌ ନି ପାଚେ ପାଚେ ୱାନାଙ୍ଗ୍ ।” ");
INSERT INTO peg_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","ଜିସୁ ତାଙ୍ଗେଙ୍ଗ୍‌ ଇଚାନ୍‌, କଲ୍ୟାତିଂ ପାରା ମାନାତ୍‌, ଆକାସ୍‌ନି ଉମ୍‌ନି ପଟିତିଂ ଗୁଡା ମାନାତ୍‌, ମାତର୍‌ ମାନାୟ୍‌ ମାଜ଼ି କାପ୍‌ଡ଼ା ଇଡ୍‌ଦେଂ ବାହା ହିଲୁତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","ଆରି, ହେୱାନ୍‌ ଆରେ ରୱାନିଂ ଇଚାନ୍‌, “ନା ପାଚେପାଚେ ୱା ।” ମାତର୍‌ ମାପ୍ରୁ ଇଚାନ୍‌, “ପର୍ତୁମ୍‌ ହାଲ୍‌ଜି ମାଞ୍ଜି ଆବାଂ ମୁଚେଙ୍ଗ୍‌ ଇଞ୍ଜି ନାଙ୍ଗେଙ୍ଗ୍‌ ବଲ୍‌ ହିଦା ।” ");
INSERT INTO peg_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","ମାତର୍‌ ଜିସୁ ତାଙ୍ଗେଙ୍ଗ୍‌ ଇଚାନ୍‌, “ହାତାକାରିଂ ଜାର୍‌ ଜାର୍‌ ହାତି ଲଗାଂ ମୁଚେଙ୍ଗ୍‌ ପିସ୍ତି ହିୟାଟ୍, ମାତର୍‌ ଏପେଙ୍ଗ୍‌ ହାଲ୍‌ଜି ଇସ୍ୱର୍‌ ରାଜିତ ସୁଣାୟ୍‌ କିୟାଟ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","ଆରେ ରୱାନ୍‌ ପା ଇଚାନ୍‌, ମାପ୍ରୁ, “ଆନ୍‌ ନି ପାଚେ ପାଚେ ୱାନାଙ୍ଗ୍, ମାତର୍‌ ପର୍ତୁମ୍‌ ମା ଇଞ୍ଜ ମାନି ମାନାୟାର୍‌ତାଂ ଜୱାର୍‌ ଇଞ୍ଜି ନାଙ୍ଗେଙ୍ଗ୍‌ ବଲ୍‌ ହିଦା ।” ");
INSERT INTO peg_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","ମାତର୍‌ ଜିସୁ ତାଙ୍ଗେଙ୍ଗ୍‌ ଇଚାନ୍‌, “ଇନେନ୍‌ ନାଙ୍ଗେଲ୍‌ତ କେଇଆଜ଼ି ଜେନ୍‌ପାଡ଼୍‌କା ହୁଡ଼୍‌ନାନ୍‌, ହେୱାନ୍‌ ଇସ୍ୱର୍‌ ରାଜିତ ହାଞ୍ଜେଙ୍ଗ୍‌ ଆଡୁନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","ଇଦାଂ ପାଚେ ମାପ୍ରୁ ଆରେ ତିନ୍‌କଡ଼ି ଦସ୍‌ଜାଣ୍‌ତିଂ ବାଚି କିତାନ୍‌ ଆରି ତା ଇମ୍‌ଣି ଗାଡ଼୍‌ ଆରି ବାହାକାଂ ହାନାକା ମାଚାତ୍‌, ହେୱାନ୍‌ ହାନି ଆଗେତାଂ ହେୱାରିଂ ରିୟାର୍‌ ରିୟାରିଂ କିଜ଼ି ହେବେ ପକ୍‌ତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","ଆରେ, ଜିସୁ ହେୱାରିଂ ଇଚାନ୍‌, “ତାସ୍‌ ହିନା ବେସି, ମାତର୍‌ କାମାୟ୍‌ କିନାକାର୍‌ ଉଣା; ଲାଗିଂ ନି କାମାୟ୍‌ ବାହାତ କାମାୟ୍‌ କିନାକାରିଂ ପକ୍‌ନି କାଜିଂ ତାସି ଜମିନି ହାଉକାର୍‌ ତାକେ ପାର୍ତାନା କିୟାଟ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","ଏପେଙ୍ଗ୍‌ ହାଲାଟ୍‌; ହୁଡ଼ାଟ୍‌, ହୁଣ୍ଡାର୍‌ ବୁର୍କାକାଂ ବିତ୍ରେ ମେଣ୍ଡା ହିମ୍‌ଣାକାଂ ଲାକେ ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ପକ୍ତାନାଙ୍ଗା । ");
INSERT INTO peg_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","ଜାଲିୟା ମଣା ଆରି ପାଣ୍ଡାଇଙ୍ଗ୍‌ ଆମାଟ୍‌, ଆରେ ହାସ୍‌ଦ ଇନେରିଂ ଜୱାର୍‌ କିମାଟ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","ଆରେ ଇମ୍‌ଣି ଇଞ୍ଜ ଏପେଙ୍ଗ୍‌ ହଣ୍‌ଗାନାଦେର୍‌, ହିଗ୍‌ଦ ଇନାଟ୍‌, ଇ ଇଲ୍‌ କାଜିଂ ସୁସ୍ତା ଆୟେତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","ଆରେ, ହେ ବାହାତ ଇନେନ୍‌ ଜଦି ରୱାନ୍‌ ସୁସ୍ତାନିକାନ୍‌ ମାଚିସ୍‌, ତା ଆତିସ୍‌ ମି ତାକ୍‌ଣି ସୁସ୍ତା ହେ ଜପି ଦୁମ୍‍ନାତ୍‍; ମାତର୍‌ ଜଦି ହିଲ୍‌ୱିତିସ୍‌, ତେବେ ହେଦାଂ ମିତାକେଣ୍ଡାଂ ମାଜ଼ି ୱାନାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","ଆରେ, ହେୱାର୍‌ ତାକେ ଇନାକା ମାନାତ୍‌, ତିନ୍‌ଞ୍ଜି ଉଣ୍‌ଜି ହେ ଇଞ୍ଜ ମାନାଟ୍‌, ଇନେକିଦେଂକି କାମାୟ୍‌ କିନାକାଦେର୍‌ ଡାବୁଙ୍ଗ୍‌ ପାୟାନି ଜଗ୍‌ । ଇଲ୍‌କୁକାଂ ଇଲ୍‌କୁ ହାଲ୍‌ମାଟ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","ଆରେ, ଇମ୍‌ଣି ଗାଡ଼୍‌ଦ ଏପେଙ୍ଗ୍‌ ହଣାଦେର୍‍ ଆରି ଲକୁ ମିଙ୍ଗେଙ୍ଗ୍‌ ଇଡ଼୍‌ଦାନାର୍‌, ହେବେ ମିଙ୍ଗେଙ୍ଗ୍‌ ଇନାକା ଚିଚ୍‌ପା ଆଦ୍‌ନାର୍‌, ହେଦାଂ ତିନାଟ୍‌, ");
INSERT INTO peg_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","ହେ ବାହାତ ମାନି ରଗ୍ୟାରିଂ ଉଜ୍‌ କିୟାଟ୍‌, ଆରେ ହେୱାରିଂ ଇନାଟ୍‌, ଇସ୍ୱର୍‌ତି ରାଜି ମି ତାକେ ୱାତାତେ । ");
INSERT INTO peg_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","ମାତର୍‌ ଇମ୍‌ଣି ଗାଡ଼୍‌ଦ ଏପେଙ୍ଗ୍‌ ହଣାଦେର୍‍ ଆରି ମାନାୟାର୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ଇଡ୍‌ଦୁର୍‌, ହେବେ ହୁଗିତାକେ ହସି ହାଲ୍‌ଜି ଇନାଟ୍‌, ");
INSERT INTO peg_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","ମି ଗାଡ଼୍‌ନି ଇମ୍‌ଣି ଦୁଡ଼ି ମା ପାନାତ ଆଣ୍ଟାତ୍‌ନା, ହେଦାଂ ପା ମି କାଜିଂ ଡ଼ାତ୍‌ନାପା; ମାତର୍‌ ଇସ୍ୱର୍‌ତି ରାଜି ଜେ ଲାଗେ ୱାତାତେ, ଇଦାଂ ପୁନାଟ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ଇଞ୍ଜ୍‌ନାଙ୍ଗା, ତା ବିଚାର୍‌ ନାଞ୍ଜିଙ୍ଗ୍‌ ହେ ଗାଡ଼୍‌ନି ଦାଣ୍ଡ୍‌ ବାଟା ସଦମ୍‌ନି ଦାଣ୍ଡ୍‌ ପାୟାନାର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","ହାୟ, ଡାଣ୍ଡ୍‌ନି କଣ୍ଡି କରାଜିନ୍‌, ହାୟ, ଡାଣ୍ଡ୍‌ନି କଣ୍ଡି ବେତ୍‌ସାଇଦା, ଇନାକିଦେଂକି ମି ବିତ୍ରେ ଇମ୍‌ଣି ଇମ୍‌ଣି ସାକ୍ତିନି କାମାୟ୍‌ କିୟା ଆତାତ୍‌ନ୍ନା, ହେଦାଂ ୱିଜ଼ୁ ଇନାୱାଡ଼ାଂ ସର ଆରେ ସିଦନ୍‌ ତାକେ କିୟାଆତାତ୍‍ମା, ଲାଗିଂ ହେୱାର୍‌ ବେସିଦିନ୍‌ ପୁର୍ବେତାଂ ବାସ୍ତା ଉସ୍ପିସ୍‌ ନିସ୍‌ତାକେ କୁଚ୍‌ଚି ମାନ୍‌ବାଦ୍‌ଲାୟ୍‌ କିତାର୍ମା । ");
INSERT INTO peg_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","ଆତିସ୍‌ପା ବିଚାର୍ଣ୍ଣାତ ମି ଦାଣ୍ଡ୍‌ ବାଟା ସର ଆରି ସିଦନ୍‌ନି ଦାଣ୍ଡ୍‌ ପାୟା ଆନାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","ଆରେ, ଆଡ଼େ କପର୍ନାହୁମ୍‌, ଏନ୍‌ ଇନାକା ସାର୍ଗେ ପାତେକ୍‌ ଲାମା ଆଦେଂ ଆଡ୍‌ନାୟ୍‌ ? ପାତାଲ୍‌ ପାତେକ୍‌ ନିଙ୍ଗ୍‌ ଆଦା ହାଞ୍ଜେଙ୍ଗ୍‌ ଆଦ୍‌ନାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","ଜିସୁ ଜାର୍‌ ଚେଲାରିଂ ଇଚାନ୍‌ ଇନେର୍‌ ମି ବେରଣ୍‌ ୱେନାର୍‌, “ହେୱାର୍‌ ନା କାତା ୱେନାନ୍, ଆରେ ଇନେର୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ଇଡ୍‌ଦୁର୍‌, ହେୱାର୍‌ ନାଙ୍ଗେଙ୍ଗ୍‌ ଇଡ୍‌ଦୁର୍‌, ଆରେ ଇନେର୍‌ ନାଙ୍ଗେଙ୍ଗ୍‌ ଇଡ୍‌ଦୁର୍‌, ହେୱାର୍‌ ନା ପକ୍‌ତାତାକାନିଂ ଇଟୁର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","ଇଦାଂ ପାଚେ ହେ ବାସ୍‌ତୁରି ଜାଣ୍‌ ୱାରିତାଂ ମାସ୍‌ଦି ୱାଜ଼ି ଇଚାନ୍‌, “ମାପ୍ରୁ, ପୁଦାଂପା ନି ତର୍‌ଦାଂ ମାଙ୍ଗେଙ୍ଗ୍‌ ମାନି କିଦ୍‌ନିକା ।” ");
INSERT INTO peg_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","ମାତର୍‌ ଜିସୁ ହେୱାରିଂ ଇଚାନ୍‌, “ବିଜ୍‌ଲି ଲାକେ ସାର୍ଗେତାଂ ସୟ୍‌ତାନ୍‌ତିଂ ଆର୍ଦାନାକା ଆନ୍‌ ହୁଡ଼୍‌ଜି ମାଚାଙ୍ଗ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","“ହୁଡ଼ାଟ୍‌, ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ରାଚ୍‌ ଆରି କାଚାକୁପି ଜପି ତାଙ୍ଗ୍‌ଦେଂ ଆଦିକାର୍‌ ହିତ୍‍ତାଙ୍ଗ୍‍ନା, ଆରେ, ସାତ୍ରୁର୍ ୱିଜ଼ୁ ସାକ୍ତି ଜପି ଆଦିକାର୍‌ ହିତ୍‍ତାଂନା, ଆରେ ଇନାକା ପା ଇମ୍‌ଣି ବାନି ମିଙ୍ଗେଙ୍ଗ୍‌ ନସ୍ଟ କିଦୁଙ୍ଗ୍ । ");
INSERT INTO peg_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","ଆତିସ୍‌ପା ବାନ୍ୟା ଜିବୁନିଂ ଜେ ମି ତାରେନ୍‌ ମାନିଙ୍ଗ୍, ଇବେ ୱାରି କିମାଟ୍‌, ମାତର୍‌ ମି ତର୍‌ ଜେ ସାର୍ଗେତ ଲେକାମାନାତ୍‌, ଇବେ ୱାରି କିୟାଟ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","ହେ ୱେଡ଼ାଙ୍ଗ୍‌ ଜିସୁ ପୁଇପୁୟା ଜିବୁନ୍ତାଂ ୱାରିୟା ଆଜ଼ି ଇଚାନ୍‌, “ଆବା, ସାର୍ଗେ ଆରି ପୁର୍ତିନି ମାପ୍ରୁ, ଏନ୍‌ ଗିଆନି ଆରି ବୁଦ୍‍ୟାତି ଲକୁତାଙ୍ଗ୍ ଇ ୱିଜ଼ୁ ବିସ୍ରେ ଡ଼ୁକ୍‌ଚି ଇଡ଼୍‌ଜି ହିମ୍‍ଣାଙ୍ଗ୍‍ତାକେ ୱେଚ୍‍ଚାୟ୍‌ନା, ଇଦାଂ କାଜିଂ ନି ନାନ୍ଦ୍‌ କିନାଙ୍ଗା; ଆଁ ଆବା, ଇନାକିଦେଂକି ଇଦାଂ ନି କାଣ୍‌କୁତାଂ ଏଚେକ୍‌ସାରି ଆତାତ୍‌ନ୍ନା ।” ");
INSERT INTO peg_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","“ନା ଆବାତି ୱିଜ଼ୁ ବିସ୍ରେ ନାବେ ସର୍‌ପି ଆତାତ୍‌ନ୍ନା; ଆରେ ମାଜ଼ି ଇନେର୍‌, ଇଦାଂ ଆବାଂ ପିସ୍ତି ଇନେର୍‌ ପୁନୁର୍‌, ଆରେ ଆବା ଇନେର୍‌ ଇଦାଂ ମାଜ଼ି ପିସ୍ତି ଇନେର୍‌ ପୁନୁର୍‌, ଆରେ ମାଜ଼ି ଇନେର୍‌ ତାକେ ହେୱାନିଂ ୱେଚ୍‌ଚେଙ୍ଗ୍‌ ମାନ୍‌ କିନାନ୍‌, ହେୱାନ୍‌ ପୁନାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","ଆରେ, ଜିସୁ ଜାର୍‌ ଚେଲାରିଂ ମାସ୍‌ଦିହୁଡ଼୍‌ଜି ଇଚାନ୍‌, “ଏପେଙ୍ଗ୍‌ ଇନା ଇନାକା ହୁଡ଼୍‍ନାଦେରା, ହେ ୱିଜ଼ୁ ଇମ୍‌ଣି କାଣ୍‌କୁ ହୁଡ଼୍‍ନାତ୍‍, ହେଦାଂ ଦନ୍ୟ । ");
INSERT INTO peg_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","ଇନାକିଦେଂକି ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ଇଞ୍ଜ୍‌ନାଙ୍ଗା, ଏପେଙ୍ଗ୍‌ ଇନା ଇନାକା ହୁଡ଼୍‌ନାଦେରା, ହେଦାଂ ୱିଜ଼ୁ ହେନି ବେଣ୍‌ବାକ୍‌ଣାୟ୍‌କିନାର୍‌ ଆରି ରାଜା ହୁଡ଼୍‌ଦେଂ ମାନ୍‌ କିତାନ୍‌, ମାତର୍‌ ହୁଡ଼୍‌ଦେଂ ଆଡ୍‌ୱାତାନ୍‌; ଆରେ, ଏପେଙ୍ଗ୍‌ ଇନା ଇନାକା ୱେନାଦେରା, ହେ ୱିଜ଼ୁ ହେୱାର୍‌ ୱେଞ୍ଜେଙ୍ଗ୍‌ ମାନ୍‌ କିତାର୍‌, ମାତର୍‌ ୱେନ୍‍ୱାତାର୍ ।” ");
INSERT INTO peg_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","ଆରେ ହୁଡ଼ାଟ୍‌, ରୱାନ୍‌ ଦରମ୍‌ ସାସ୍ତର୍‌ ନିକାନ୍‌ ନିଙ୍ଗ୍‌ଜି ତାଙ୍ଗେଙ୍ଗ୍‌ ପରିକ୍ୟା କିଜ଼ି ୱେନ୍‌ବାତାନ୍‌, “ଏ ଗୁରୁ, ୱିଜ଼୍‌ୱି ଜିବୁନ୍‌ନି ଆଦିକାର୍‌ ଆଦେଂ ଇଞ୍ଜି ଆନ୍‌ ଇନା କିନାଙ୍ଗ୍‌ ?” ");
INSERT INTO peg_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","ହେବେଣ୍ଡାଂ ଜିସୁ ତାଙ୍ଗେଙ୍ଗ୍‌ ଇଚାନ୍‌, “ମସାତି ବିଦିତ ଇନାକା ଲେକା ମାନାତ୍‌ ? ଏପେଙ୍ଗ୍‌ ଇନେସ୍‌ ପଡ଼ିକିନାଦେରା ?” ");
INSERT INTO peg_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","ହେୱାନ୍‌ ଉତର୍‌ ହିତାନ୍‌, “ଏପେଙ୍ଗ୍‌ ୱିଜ଼ୁ ୱାସ୍କିତାଂ, ୱିଜ଼ୁ ପାରାଣ୍‌, ୱିଜ଼ୁ ସାକ୍ତି ଆରି ୱିଜ଼ୁ ମାନ୍‌ ହିଜ଼ି ମାପ୍ରୁ ଜାର୍‌ ଇସ୍ୱର୍‌ ମାପ୍ରୁ ଜିଉନୱାଟ୍‌; ଆରେ, ଜାର୍‌ ପାଡ଼୍‍ହା ଇଞ୍ଜିନି ଲଗାଂ ୱାସ୍କିଲାକେ ଜିଉନୱାଟ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","ହେବେ ଜିସୁ ତାଙ୍ଗେଙ୍ଗ୍‌ ଇଚାନ୍‌, ଏନ୍‌ ହାତ୍‍ପାରଚେ ଉତର୍‌ ହିତାୟ୍‌ନା, “ଏପେଙ୍ଗ୍‌ କିୟାଟ୍‌, ତା ଆତିସ୍‌ ଏପେଙ୍ଗ୍‌ ଜିବୁନ୍‌ ପାୟା ଆନାଦେର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","ମାତର୍‌ ବିଦିବିଦାଣି ସାସ୍ତର୍‌ ଜାର୍‌ତିଂ ଦାର୍ମି ଇଞ୍ଜି ଚଚ୍‌ଚେଙ୍ଗ୍‌ ଇଚା କିଜ଼ି ଜିସୁଙ୍ଗ୍‌ ୱେନ୍‌ବାତାର୍‌, “ଲାଗିଂ ନା ପାଡ଼୍‍ହାନିକାର୍ ଇନେର୍‌ ?” ");
INSERT INTO peg_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","ଜିସୁ ହେ ବେରଣ୍‌ ଆସ୍ତି ଇଚାନ୍‌, ରୱାନ୍‌ ମାନାୟ୍‌ ଜିରୁସାଲମ୍‌ତାଂ ଜିରିହତ ହାଲୁ ହାଲୁ ଚର୍କୁକାଂ ହାବଡ଼୍‌ତାକେ ପଡ଼ାତାନ୍ । ହେୱାର୍‌ ତା ହେନ୍ଦ୍ରାପାଟା ଡୁସ୍‌ଦି ଅଜ଼ି ଆରି ଟ୍ରାକ୍‌ଚି ତାଙ୍ଗେଙ୍ଗ୍‌ ଦାରାମାସ୍କା କାକୁଲ୍‌ତି କିଜ଼ି ପିସ୍ତି ହାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","ଗଟ୍‌ଣା ପାଚେ ରୱାନ୍‌ ମାପ୍ରୁହେବାକିନାକାନ୍‌ ହେ ହାସ୍‍ଦିଙ୍ଗ୍‌ ହାଲ୍‌ଜି ମାଚାନ୍‌, ଆରେ ହେୱାନ୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ହୁଡ଼୍‌ଜି ହେୱାନ୍‌ ଆରେ ର ହାସ୍‌ଦିଙ୍ଗ୍‌ ନାସି ହାଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","ଏଲେଙ୍ଗ୍‌ ଆଜ଼ି ରୱାନ୍‌ ଲେବିୟ ପା ହେ ବାହାତ ୱାଜ଼ି ହେୱାନିଂ ହୁଡ଼୍‌ଜି ହେୱାନ୍‌ପା ଆରେ ର ହାସ୍‌ଦିଙ୍ଗ୍‌ ନାସି ହାଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","ମାତର୍‌ ରୱାନ୍‌ ସମିରଣିୟ ତା କଚଣ୍‌ତ ୱାଜ଼ି ତାଙ୍ଗେଙ୍ଗ୍‌ ହୁଡ଼୍‌ଜି କାର୍ମାତିଂ ଲବାୟ୍‌ କିତାନ୍, ");
INSERT INTO peg_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","ଆରି ଲାଗେ ହାଲ୍‌ଜି ତାଙ୍ଗେଙ୍ଗ୍‌ ନନିତାକେ ଚିକାଣ୍‌ ଆରେ ଅଙ୍ଗୁର୍‌ ରାସ୍‌ ୱାକ୍‌ଚି ହେ ସବୁ ଗାଚ୍‌ଚାନ୍‌, ଆରେ ତାଙ୍ଗେଙ୍ଗ୍‌ ଜାର୍‌ ପସୁ ଜପି ଦୁପ୍‌ଚି ଅଜ଼ି ର ତିନାକା ଉଣାକା ମାନି ବାହାତ ଅଜ଼ି ହାଲ୍‌ଜି ତାଙ୍ଗେଙ୍ଗ୍‌ ଜତନ୍‌ କିତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","ତା ପାଚେ ଆରେ ର ଦିନ୍‌ ହେୱାନ୍‌ ରିଣ୍ଡାଂ ଟାକାଂ ହପ୍‌ଚି ହେବା ମାଲିକାରିଂ ହିଜ଼ି ଇଚାନ୍‌, ଇୱାନିଂ ଏନ୍‌ ହେବା କିୟା, ଆରେ ଇନାକା ଆଦିକ୍‌ କର୍ଚ କିନାୟ୍‌, ହେଦାଂ ଆନ୍‌ ମାସ୍‌ଦି ୱାନିହିଂ ମିଙ୍ଗେଙ୍ଗ୍‌ ହିଦ୍‌ନାଂ । ");
INSERT INTO peg_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","“ଇ ତିନ୍‌ ଜାଣ୍‌ ବିତ୍ରେ ଇନେନ୍‌ ଚର୍କୁକାଂ ତାକେ ଦାରାପଡ଼ା ଆତି ଲକ୍‌ତିଙ୍ଗ୍ ପାଡ଼୍‍ହାନିକାନ୍‍ ଇଞ୍ଜି ମାନ୍ତ କିନାଦେରା ?” ");
INSERT INTO peg_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","ବିଦିବିଦାଣି ସାସ୍ତର୍ ଇଚାନ୍‌ ଜେ ଏଲେଙ୍ଗ୍‌ କିଜ଼ି ଦୟା କିତାନ୍‌ ହେୱାନ୍‌, ଜିସୁ ତାଙ୍ଗେଙ୍ଗ୍‌ ଇଚାନ୍‌, “ହାଲାଟ୍‌, ଏପେଙ୍ଗ୍‌ ପା ହେ ଲାକେ କିୟାଟ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","ଜିସୁ ତା ଚେଲାହିର୍‌ ହେୱାର୍‌ ହାନିହିଂ ହେୱାନ୍‌ ର ନାସ୍ତ ହଣଗାତାନ୍ ଆରି ମାର୍ତା ତର୍‌ନି ରଞ୍ଜେଲ୍‌ କଗ୍‌ଲେ ଜିସୁଙ୍ଗ୍‌ ନିଜାର୍‌ ଇଞ୍ଜ ଅଜ଼ି ହାତାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","ମରିୟମ୍‌ ଇନି ତାଙ୍ଗେଙ୍ଗ୍‌ ରଞ୍ଜେଲ୍‌ ତଣ୍‌ଦେହି ମାଚାତ୍‌, ହେଦେଲ୍‌ ମାପ୍ରୁତି କାଲ୍‌କୁ ତାରେନ୍‌ କୁଚ୍‌ଚି ତା ବଚନ୍‌ ୱେନ୍‌ଞ୍ଜି ମାଚାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","ମାତର୍‌ ମାର୍ତା ହେବା କିନି ବିସ୍ରେତିଂ ବେସି ତାନ୍ଦ୍ରା ଆଜ଼ି ମାଚାତ୍‌; ଲାଗିଂ ହେଦେଲ୍‌ ତା ଲାଗାଂ ୱାଜ଼ି ଇଚାତ୍‌, “ଏ ମାପ୍ରୁ, ନା ତଣ୍‌ଦେଲ୍‌ ଜେ ରଞ୍ଜେଲ୍‌ନେ ନା ଜପି ୱିଜ଼ୁ କାମାୟ୍‌ ହେଲାୟ୍‌ କିତ୍‌ତାନ୍‌, ହେ ନିପ ଇନାକା ନିଙ୍ଗେଙ୍ଗ୍‌ ମାନ୍‌ହିଲୁତ୍‌ ? ଲାଗିଂ ନାଙ୍ଗେଙ୍ଗ୍‌ ଉପ୍‌କାର୍‌ କିଦ୍‌ନି କାଜିଂ ତାଙ୍ଗେଙ୍ଗ୍‌ ଇନା ।” ");
INSERT INTO peg_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","ମାତର୍‌ ମାପ୍ରୁ ତାଙ୍ଗେଙ୍ଗ୍‌ ଇଚାନ୍‌, “ମାର୍ତା, ମାର୍ତା, ଏନ୍‌ ବେସି ବିସ୍ରେ ଚିନ୍ତା କିଜ଼ି ଆରେ ବେସି ତାନ୍ଦ୍ରା ଆନାୟା, ");
INSERT INTO peg_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","ମାତର୍‌ ଅଲପ୍‍ କେତ୍‌ଗଟା, ଆତିସ୍‌ ରଞ୍ଜାଙ୍ଗ୍‍ ମାତର୍‌ ଲଡ଼ା; ମରିୟମ୍‌ତ ହାର୍‌ଦି ବାଗ୍‌ ବାଚି କିତାତ୍‌ନା, ଆରେ ତା ତାକେଣ୍ଡାଂ ହେଦାଂ ଚାକ୍‌ରାଇ କିୟାଆଉତ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","ରଗ ହେୱାନ୍‌ ଇମ୍‌ଣି ର ବାହାତ ପାର୍ତାନା କିଜ଼ି ମାଚାନ୍‌; ହେୱାନ୍‌ ପାର୍ତାନା ୱିସ୍ତିଲେ, ତା ଚେଲାହିର୍‌ ବିତ୍ରେ ରୱାନ୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ଇଚାନ୍‌, “ଏ ମାପ୍ରୁ, ବାପ୍ତିସିମ୍‌ହିନି ଜହନ୍‌ ଇନେସ୍‌ ଜାର୍‌ ଚେଲାରିଂ ପାର୍ତାନା କିଦେଙ୍ଗ୍‌ ହିକାଇକିତାନ୍‌, ଏନ୍‌ ପା ହେ ଲାକେ ମାଙ୍ଗେଙ୍ଗ୍‌ ପାର୍ତାନା କିଦେଙ୍ଗ୍‌ ହିକାଇକିଦା ।” ");
INSERT INTO peg_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","ଇବେ ଜିସୁ ହେୱାରିଂ ଇଚାନ୍‌, “ଏଚେକାଡ଼୍‌ଦ ଏପେଙ୍ଗ୍‌ ପାର୍ତାନା କିନାଦେର୍‌, ହେୱାଡ଼ାଂ ଇନାଟ୍‌, ଆବା, ନି ତର୍‌ ପୁଇପୁୟା ଇଞ୍ଜି ମାନି ଆୟେତ୍‌ । ନି ରାଜି ୱାୟେତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","ନିତ୍ରେଦିନା ମାଙ୍ଗେଙ୍ଗ୍‌ ଲଡ଼ାନି କାଦି ହିଦା । ");
INSERT INTO peg_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","ମା ପାପ୍‌ ୱିଜ଼ୁ କେମା କିଦା, ଇନାକିଦେଂକି ଆପେଂ ପା ଜାର୍‌ ଜାର୍‌ତି ବେରୁତାଂ ପାପ୍‌ କେମା କିନାପ୍‌ ।” “ପରିକ୍ୟାତ ମାଙ୍ଗେଙ୍ଗ୍‌ ତାହି ୱାଦ୍‌ମା ।” ");
INSERT INTO peg_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","ଆରେ, ଜିସୁ ତା ଚେଲାରିଂ ଇଚାନ୍‌, “ମିଙ୍ଗେଙ୍ଗ୍‌ ଇନେରିଂ ଏଲେଙ୍ଗ୍‌ ବାର୍ତିନି ସାଙ୍ଗ ମାନାନ୍‌ କି, ଇନେର୍‌ ଲାଗେ ମାଦିମାଦାନାଣା ହେୱାନ୍‌ ହାଲ୍‍ଜି ଇନାନ୍‌, ଏ ହାଇ, ନାଙ୍ଗେଙ୍ଗ୍‌ ତିନିଗଟା ରୁଟିଂ ଉଦାର୍‌ ହିଦା, ");
INSERT INTO peg_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","ଇନାକିଦେଂକି ନା ରୱାନ୍‌ ସାଙ୍ଗ ନା ତାକେ ୱାତାନ୍ନା, ତାଙ୍ଗେଙ୍ଗ୍‌ ବାଟା କିଜ଼ି ହିଦେଂ ନା ତାକେ ଇନାକା ହିଲୁତ୍‌, ");
INSERT INTO peg_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","ଆରେ ହେ ବିତ୍ରେତାଂ ଏଲେଙ୍ଗ୍‌ ଉତର୍‌ ହିନାନ୍‌, ନାଙ୍ଗେଙ୍ଗ୍‌ କସ୍ଟ ହିଦ୍‌ମା; ଦୁୱେର୍‌ ଗେହ୍‍ୟା ଆତାତେ ଆରେ ନା ହିମ୍‌ଣାଂ ନା ଲାହାଙ୍ଗ୍‌ ହୁଞ୍ଜୁନାରା; ଆନ୍‌ ନିଙ୍ଗ୍‌ଜି ନିଙ୍ଗେଙ୍ଗ୍‌ ହିଦ୍‌ଦେଂ ଆଡ଼୍‌ଦୁଙ୍ଗ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ଇଞ୍ଜ୍‌ନାଙ୍ଗା, ହେୱାନ୍‌ ଆତିସ୍‌ପା ତା ସାଙ୍ଗ ଆତିଲେ ତାଙ୍ଗେଙ୍ଗ୍‌ ନିଙ୍ଗ୍‌ଜି ହିଉନ୍‍, ଆତିସ୍‌ପା ହେୱାନ୍‌ ଲାଜାଆୱାଦାଂ ଚାନେକ୍‌ ଚାନେକ୍‌ ଏନ୍ତିଲେ ହେୱାନ୍‌ ନିଙ୍ଗ୍‌ଜି, ହେୱାନ୍ତି ଏଚେକ୍‌ ଲଡ଼ା ହେୱାନିଂ ହେ ଏଚେକ୍‌ ହିନାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","ଆନ୍‌ ପା ମିଙ୍ଗେଙ୍ଗ୍‌ ଇଞ୍ଜ୍‌ନାଙ୍ଗା, ଏନାଟ୍‌, ହେବେ ମିଙ୍ଗେଙ୍ଗ୍‌ ହିଦ୍‌ନାନ୍‌; ଡେକାଟ୍‌, ହେବେ ଏପେଙ୍ଗ୍‌ ଗାଟା ଆନାଦେର୍‌; ଦୁୱେର୍‌ରିଂ ଇଡ଼ାଟ୍‌, ହେବେ ମି କାଜିଂ ଜେସ୍‌ସି ହିଦ୍‌ନାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","ଇନାକିଦେଂକି ଇନେର୍‌ ଏନ୍‌ନାନ୍‌, ହେୱାନ୍‌ ପାୟା ଆନାନ୍‌; ଇନେର୍‌ ଡେକ୍‌ନାନ୍‌, ହେୱାନ୍‌ ଗାଟାଆନାନ୍; ଆରେ, ଇନେର୍‌ ଦୁୱେର୍‌ତ ଇଡ଼୍‌ନାନ୍‌, ହେୱାନ୍‌ କାଜିଂ ଜେୟାନାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","ଆରେ, ମି ବିତ୍ରେ ଏଲେଙ୍ଗ୍‌ ଆବା ଇନେନ୍‌ ମାନାନ୍‌, ଇନେରିଂ ଜାର୍‌ ମାଜ଼ି ମିନ୍‌ ଏନ୍ତିସ୍‌ ହେୱାନ୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ମିନ୍‌ ବାଦୁଲ୍‌ ରାଚ୍‌ ହିନାନ୍‌ ? ");
INSERT INTO peg_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","ଆତିସ୍‌ପା ରଣ୍ଡା ଏନ୍ତିସ୍‌ ହେୱାନ୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ କାଚାକୁପି ହିନାନ୍‌ ? ");
INSERT INTO peg_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","ଲାଗିଂ ଏପେଙ୍ଗ୍‌ କୁଲ୍‍କୁଲିଆ ଆତିସ୍‌ପା ଏଚେକାଡ଼୍‌ଦ ଜାର୍‌ ଜାର୍‌ ହିମ୍‌ଣାକାଂ ହାର୍ଦି ହାର୍ଦି ଦାନ୍‌ ହିଦେଂ ପୁନାଟ୍‌, ଲାଗିଂ ଇମ୍‌ଣି ଆବା ସାର୍ଗେତାଂ ଦାନ୍‌ ହିଦ୍‍ନାନ୍‍, ହେୱାନ୍‌ ତା ମୁମ୍‌ଦ ଏନ୍‍ନାସ୍‌ ମାନାୟାରିଂ କେତେକ୍‌ ଆଦିକ୍‌ ଲାକେ ପୁଇପୁୟା ଜିବୁନ୍‌ ହିଦ୍‍ନାନ୍‍ !” ");
INSERT INTO peg_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","ରଗ ଜିସୁ ର ପୁଦା ପିହି କିଜ଼ି ମାଚାନ୍‌, ହେ ପୁଦା ଗୁଲି । ପୁଦା ହସି ହାଚିପାଚେ ଗୁଲା ମାନାୟ୍‌ ବେଣ୍‌ ଇଚାନ୍‌, ହେବେ ମାନାୟାର୍‌ କାବା ଆଜ଼ି ହାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","ମାତର୍‌ ହେୱାର୍‌ ବିତ୍ରେତାଂ ଇନେର୍‌ ଇନେର୍‌ ଇଚାର୍‌, “ଜିସୁ ମୁଣିକା ବାଲ୍‌ଜିବୁଲ୍‌ ସାକ୍ୟାତାଂ ପୁଦାଂ ପିହିକିନାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","ବିନ୍‌ଲଗୁ ତାଙ୍ଗେଙ୍ଗ୍‌ ଡ଼ୁକାତ ହେଜ଼ି କିଦେଙ୍ଗ୍‌ ଇଞ୍ଜି ମାନ୍‌କିଜ଼ି ମାଚାର୍‌ । ଲାଗିଂ ଇସ୍ୱର୍‌ ଜେ ତା ସାଇଜ କାର୍‌ୟା ଇଚାକାଂ ପରିକ୍ୟା କିଦେଙ୍ଗ୍‌ ଆକାସ୍‌ତାଂ ର ଚିନ୍‌ ଏନ୍ତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","ମାତର୍‌ ଜିସୁ ହେୱାରିଂ ମାନ୍ତିନି ବାବ୍‍ନା ପୁଞ୍ଜି ହେୱାରିଂ ଇଚାନ୍‌, “ଇମ୍‌ଣି ରାଜି ବାଗ୍‌ ଆଜ଼ି ଜାର୍‌ ବିରୁଦ୍‌ତ ନିଙ୍ଗ୍‌ତିସ୍‌, ହେଦାଂ ନସ୍ଟ ଆଜ଼ି ହାନାତ୍‌, ଆରେ ଇମ୍‌ଣି ଇଲ୍‌ ରିବାଗ୍‌ ଆନାତ୍‌ ହେ ଇଲ୍‌ ଜପି ଲେଦି ଆଜ଼ି ନସ୍ଟ ଆନାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","ଆରେ, ସୟ୍‌ତାନ୍‌ ପା ଜଦି ବାଗ୍‌ ଆଜ଼ି ଜାର୍‌ ବିରୁଦ୍‌ତ ନିଙ୍ଗ୍‌ନାତ୍‌, ତା ଆତିସ୍‌ ତା ରାଜି ଇନେସ୍‌ ତିର୍‌ ଆଜ଼ି ମାନାତ୍‌ ? ଆନ୍‌ ବାଲ୍‌ଜିବୁଲ୍‌ ସାଇଜତାଂ ପୁଦାକାଂ ପିହିକିନାନା ଇଞ୍ଜି ଏପେଙ୍ଗ୍‌ ତ ଇଞ୍ଜ୍‌ନାଦେରା ।” ");
INSERT INTO peg_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","ମାତର୍‌ ଆନ୍‌ ଇନାୱାଡ଼ାଂ ବାଲ୍‌ଜିବୁଲ୍‌ ସାଇଜତାଂ ପୁଦାକାଂ ପିହିକିନାଙ୍ଗ୍‌, ଲାଗିଂ ମି ହିମ୍‍ଣାଙ୍ଗ୍‍ ଇନେର୍‌ ସାଇଜତାଂ ହେୱାକାଂ ପିହିକିନାର୍‌ ? ଲାଗିଂ ହେୱାର୍‌ ନେ ମିଙ୍ଗେଙ୍ଗ୍‌ ବିଚାର୍‌କାର୍‌ୟାର୍‌ ଆଦ୍‌ନାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","ଆନ୍‌ ଆରି ଇସ୍ୱର୍‌ ସାକ୍ତି ସାଇଜତାଂ ଆନ୍‌ ପୁଦାକାଂ ପିହିକିନାଙ୍ଗ୍‌, ଆରି ଇଦାଂ ପାର୍ମାଣ୍‌ କିନାତ୍‌ ଜେ, ଇସ୍ୱର୍‌ ରାଜି ମିଦାଙ୍ଗ୍‌ ଲାଗେ ଆତାତେ । ");
INSERT INTO peg_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“ସାକ୍ତି ଲଗୁ ଏଚେକାଡ଼୍‌ଦ ପାତେକ୍‌ ଆତ୍‌ ଆତିୟାର୍‌ ତା ହାକ୍‌ଡ଼ିତ ଜାଲ୍‌ଦି ଆଜ଼ି ତା କାଲ୍‌ ରାକ୍ୟା କିନାନ୍‌, ହେ ପାତେକ୍‌ ତା ଦାନ୍‌ ଜାଗ୍ରତ୍‌ତାଂ ମାନ୍‌ଗାନାତ୍‌; ");
INSERT INTO peg_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","ମାତର୍‌ ଏଚେକାଡ଼୍‌ଦ ତା ତାକେଣ୍ଡାଂ ଆଦିକ୍‌ ସାକ୍ତି ମାନାୟ୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ପାଣ୍ଡ୍ରୁ କିଜ଼ି ଆବାର୍‌ ଆହ୍‌ନାନ୍‌, ହେୱାଡ଼ାଂ ଇମ୍‌ଣି ଆତିୟାର୍‌ ଜପି ତା ବାର୍ସି ମାଚାତ୍‌, ହେୱାନ୍ତି ୱିଜ଼ୁ କିସ୍ତି ଅନାନ୍‌ ଆରେ ତାଦାଙ୍ଗ୍‌ ଚର୍‌ କିଜ଼ିମାନି ଦନ୍‌ସମ୍ପତି ବାଟାକିଜ଼ି ଅନାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","ଇନେର୍‌ ନା ପାକ୍ୟା ଆକାୟ୍‌, ହେୱାନ୍‌ ନା ବେରିୟା; ଆରେ, ଇନେର୍‌ ନା ଲାହାଙ୍ଗ୍‌ ରୁଣ୍ଡାୟ୍‌ କିଉନ୍‌, ହେୱାନ୍‌ ଜେଡ଼େ କେତେ କିନାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“ବାନ୍ୟା ଜିବୁନ୍‌ ରକାନ୍‌ ମାନାୟ୍‌ତିଂ ହସିହାଚି ପାଚେ ଚିମ୍‌ରା ବାହା ୱିଜ଼ୁ ବୁଲାଆଜ଼ି ଜମ୍‍ନାକା ଡେକ୍‌ନାତ୍‌ ଆରେ ହେଦାଂ ଗାଟାଆୱିତିସ୍‍ ଇନାନ୍‌, ଆନ୍‌ ଇମ୍‌ଣି ଇଞ୍ଜାଙ୍ଗ୍‌ ହସିୱାଜ଼ି ମାଚାଙ୍ଗ୍‌, ଆନ୍‌ ହେ ଇଞ୍ଜ ଲେଉଟା ଆଜ଼ି ହାନାଂ; ");
INSERT INTO peg_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","ଆରି, ହେଦାଂ ୱାଜ଼ି ହେଦାଂ ନିର୍ମଲ୍‌ ଆରି ହାର୍‍ଦାକା ହୁଡ଼୍‌ନାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","ହେପାଦ୍‌ନା ହେଦାଂ ହାଲ୍‌ଜି ଜାର୍‌ତାଂ ଆଦିକ୍‌ ବାନ୍ୟା ଆରେ ସାତ୍‌ଗଟା ପୁଦାଂ ରଚେ ତାସି ୱାନାତ୍‌, ଆରି ହେୱାଙ୍ଗ୍‌ ହଣ୍‌ଜି ହେବେ ବାହାକିନିକ୍‌, ଆରେ ହେ ମାନାୟ୍‌ତିଂ ପର୍ତୁମ୍‌ ଦସା ବାଟା ହାରିହାନି ଦସା ଆଦିକ୍‌ ବାନ୍ୟା ଆନାତ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","ହେଦେଲ୍‌ ଇ ୱିଜ଼ୁ ବେରଣ୍‌ ଇନି ୱାଡ଼ାଙ୍ଗ୍‍ ମାନାୟାର୍‌ ବିତ୍ରେ ରଞ୍ଜେଲ୍‌ କଗ୍‌ଲେହିମ୍‌ଣା ଗାଜା କାଟ୍‌ତାଂ ଇଚାତ୍‌, ଦନ୍ୟ ହେ ଗରବ୍‍, “ଇନାକା ନିଙ୍ଗେଙ୍ଗ୍‌ ଜଲମ୍‌ କିତ୍‌ତାତ୍‌ ଆରି ମାୟ୍ ହେବେତାଂ ଉଟାୟ୍‍ ।” ");
INSERT INTO peg_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","ମତର୍‌ ଜିସୁ ଇଚାନ୍‌, “ଆନ୍‌ ଆକାୟ୍‌, ଇମ୍‌ଣାକାର୍‌ ଇସ୍ୱର୍‌ ବେରଣ୍‌ ୱେନାର୍‌ ଆରି ମାନିକିନାର୍‌ ଇଚିସ୍‌, ହେୱାର୍‌ ଦନ୍ୟ ।” ");
INSERT INTO peg_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","ବେସିହେନି ମାନାୟ୍‌ ମାନ୍ଦା ମାନ୍ଦା ଆଜ଼ି ଜିସୁ ତାକେ ରୁଣ୍ଡାଆନି ୱେଡ଼ାଙ୍ଗ୍‌ ଜିସୁ ଇଞ୍ଜେଙ୍ଗ୍‌ ଲାଗାତାନ୍‌, ଇ ନଙ୍ଗ୍‌ନି ଆଣ୍ଡ୍ରାହିମ୍‌ଣାଂ ବାନ୍ୟାନିକାର୍; ଇୱାର୍‌ ଚିନ୍‌ ଡେକ୍‌ନାର୍‌, ମତର୍‌ ଜୁନସ୍‌ତି ଚିନ୍‌ ପିସ୍ତି ଅଲ୍‌ଗା ଇମ୍‌ଣି ଚିନ୍‌ ହେୱାରିଂ ହିୟାଆଉତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","ଇନାକିଦେଂକି ଜୁନସ୍‌ ଇନେସ୍‌ ନିନିବିୟର୍ତି କାଜିଂ ଚିନ୍‌ଲାକେ ଆତାର୍‌, ମାନାୟ୍‌ ମାଜ଼ି ପା ହେ ଲାକେ ଇ ନଙ୍ଗ୍‌ନି ଆଣ୍ଡ୍ରାହିମ୍‌ଣାଂ କାଜିଂ ଆନାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","ତିନିବାଗାଙ୍ଗ୍‌ନି ଦେସ୍‌ନି ରାଣି ବିଚାର୍ଣ୍ଣାତ ଇ ନଙ୍ଗ୍‍ନି ଆଣ୍ଡ୍ରାହିମ୍‌ଣାଂ ମାନାୟାର୍‌ ଲାହାଙ୍ଗ୍‌ ନିଙ୍ଗ୍‌ଜି ନିନ୍ଦା କିନାତ୍‌, ଇନାକିଦେଂକି ହେୱାନ୍‌ ସଲମନ୍‌ତି ବୁଦିନି କାତା ୱେଞ୍ଜେଙ୍ଗ୍‌ ପୁର୍ତିନି ବାହାତାଂ ୱାଜ଼ି ମାଚାତ୍‌; ଆରେ ହୁଡ଼ାଟ୍‌, ସଲମନ୍‌ତାଂ ଗାଜା ବିସ୍ରେ ଇ ବାହାତ ମାନାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","ନିନିବିନି ମାନାୟାର୍‌ ବିଚାର୍ଣ୍ଣାତ ଇ ନଙ୍ଗ୍‌ନି ଆଣ୍ଡ୍ରାହିମ୍‌ଣାଂ ଲାହାଙ୍ଗ୍‌ ନିଙ୍ଗ୍‌ଜି ଇ ଜୁଗ୍‌ନି ମାନାୟାର୍‌ ଲାହାଙ୍ଗ୍‌ ନିଙ୍ଗ୍‌ଜି ହେୱାରିଂ ନିନ୍ଦା କିତାର୍‌, ଇନାକିଦେଂକି ହେୱାର୍‌ ଜୁନସ୍‌ତି ସୁଣାୟ୍‌ କିନାକା ମାନ୍‌ବାଦ୍‌ଲାୟ୍‌ କିଜ଼ି ମାଚାର୍‌; ଆରେ ହୁଡ଼ାଟ୍‌, ଜୁନସ୍‌ତି ଗାଜା ବିସ୍ରେ ଇ ବାହାତ ମାନାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“ଇନେର୍‌ ବଇଟା ଆହି କିଜ଼ି ଡ଼ୁକ୍‌ତି ବାହା ଇଲ୍‌ କି ମାଣ୍‌ ତାରେନ୍‌ ଇଟୁର୍‌, ମାତର୍‌ ବଇଟା ଇଟ୍‌ନି ଜପି ଇଟ୍‌ନାର୍‌, ଇନେସ୍‌କି ବିତ୍ରେ ହଣାକାର୍‍ ମାନାୟାର୍‌ ଅଜଡ଼୍‌ ହୁଡ଼୍‌ଦେଂ ଆଡ୍‌ନାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","ମି କାଣ୍‌କୁ ଗାଗାଡ଼୍‌ନି ଅଜଡ଼୍‌ । ଏଚେକାଡ଼୍‌ଦ ମି କାଣ୍‌କୁ ଅଣ୍ଡାଙ୍ଗ୍‌ ମାଚିସ୍‌, ହେପାଦ୍‌ନା ମି ୱିଜ଼ୁ ଗାଗାଡ଼୍‌ ପା ଅଜଡ଼୍‌ ଲାକେ ଆନାତ୍‌; ମାତର୍‌ ଏଚେକାଡ଼୍‌ଦ ହେଦାଂ ବାନ୍ୟା ମାନାତ୍‌, ହେପାଦ୍‌ନା ମି ଗାଗାଡ଼୍‌ ପା ମାଜ୍‌ଗା ଆନାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","ଲାଗିଂ ଜାଗ୍ରତ୍‌, ଇନେସ୍‌କି ମି ୱାସ୍ତିନି ଅଜଡ଼୍‌ ମାଜ୍‌ଗା ଆଉତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","ଲାଗିଂ ଜଦି ମି ୱିଜ଼ୁ ଗାଗାଡ଼୍‌ ଅଜଡ଼୍‌ ଆଦ୍‌ନାତ୍‌ ଆରେ ହେବେ ଇମ୍‌ଣି ଆଦା ମାଜ୍‌ଗା ମାନ୍‌ଗୁତ୍‌, ତା ଆତିସ୍‌ ଅଜଡ଼୍‌ ଇନେସ୍‌ ବଇଟା ମିଙ୍ଗେଙ୍ଗ୍‌ ଅଜଡ଼୍‌ ହିଦ୍‌ନାତ୍‌, ହେ ଲାକେ ମି ୱିଜ଼ୁ ଗାଗାଡ଼୍‌ ଅଜଡ଼୍‌ ଆନାତ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","ଜିସୁ କାତା ଇନିୱାଡ଼ାଲିଂ ରୱାନ୍‌ ପାରୁସି ତାଙ୍ଗେଙ୍ଗ୍‌ ଜାର୍‌ ଇଞ୍ଜ ତିନି କାଜିଂ ଗୱାରି କିଜ଼ି କୁକ୍‌ତାନ୍‌, ଆରେ ହେୱାନ୍‌ ଇଞ୍ଜ ହଣ୍‌ଜିପା ଚିଞ୍ଜେଙ୍ଗ୍‌ କୁଚ୍‌ଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","ମତର୍‌ ତିନିହିଙ୍ଗ୍‌ ଆଗେ ହେୱାନ୍‌ ଜେ ପର୍ତୁମ୍‌ ନୁସ୍‌ୱାଦାଂ ମାଚାନ୍‌, ଇଦାଂ ହୁଡ଼୍‌ଜି ହେ ପାରୁସି କାବା ଆତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","ହେବେ ମାପ୍ରୁ ତାଙ୍ଗେଙ୍ଗ୍‌ ଇଚାନ୍‌, “ଏପେଙ୍ଗ୍‌ ପାରୁସିକାଦେର୍‌ ହିନା ଗିନା ଆରେ ତାଡ଼ିୟାନି ବାର୍‌ ବାଗାଙ୍ଗ୍‌ ସକଟ୍‌ କିଜ଼ି ମାନାଟ୍‌, ମତର୍‌ ମି ବିତ୍ରେ ନାଡ଼ାଇ କାମାୟ୍‌ ଆରି ପାଟ୍‌କାର୍‌ ବିତ୍ରେ ବାର୍ତି । ");
INSERT INTO peg_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","ଏ ନିର୍‌ବୁଦିୟାର୍‌, ଇନେର୍‌ ବାର୍ତ ରଚ୍‌ଚାନ୍‌, ହେୱାନ୍‌ ଜେ ବିତ୍ରେ ପା ରଚ୍‍ୱାତାନ୍‌ ? ");
INSERT INTO peg_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","ଏପେଙ୍ଗ୍‌ ଲବ୍‌ତାଂ ଇନାକା ରୁଣ୍ଡାୟ୍‌ କିନାଦେରା ହେଦାଂ ଅର୍କିତ୍‌ତାରିଂ ଦାନ୍‌ କିୟାଟ୍‌ ଲାଗିଂ ପୁରାପୁରି ସକଟ୍‌ ଆନାଦେର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“ହାୟ୍‌ ଦାଣ୍ଡ୍‌ନି ବାହା ପାରୁସିର୍‌, ଇନାକିଦେଂକି ଏପେଙ୍ଗ୍‌ ପଦିନା, ଆରୁଦ ଆରି ୱିଜ଼ୁ ଲାକେ କୁଚାନି ଦାନ୍‌ ହିଜ଼ି ମାନାଟ୍‌, ଆରେ ନିୟାୟ୍‌ ବିଚାର୍‌ ଆରି ଇସ୍ୱର୍‌ ଜିଉନନିତ ଏଲା କିନାଦେରା; ମତର୍‌ ଇ ୱିଜ଼ୁ ମାନିକିନାସ୍ ଆରି ବିନେ ୱିଜ଼ୁ ଏଲା ଆୱାକା ମାନାତ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“ହାୟ୍‌ ଦାଣ୍ଡ୍‌ନି ବାହା ପାରୁସିର୍‌, ଇନାକିଦେଂକି ଏପେଙ୍ଗ୍‌ କୁଟୁମ୍‌ ଇଞ୍ଜ ମୁଡ଼୍‌ଦି ବାହା ଆରେ ଆଟ୍‌ ବାଜାର୍‌ତାକେ ଜୁୱାର୍‌ ପାୟା ଆଦେଂ ଜିଉନନାଦେର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","ହାୟ୍‌, ଡାଣ୍ଡ୍‌ନି, ଇନାକିଦେଂକି ଏପେଙ୍ଗ୍‌ ହୁଡ଼୍‌ୱିତି ଦୁଗେର୍‌ ଲାକେ; ତା ଜପି ହାନାକାଦେରେ ମାନାୟ୍‌ ହେଦାଂ ଦୁଗେର୍‌ ଇଞ୍ଜି ପୁନୁର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","ଇବେ ମସାତି ବିଦି ସାସ୍ତିର୍‌ ବିତ୍ରେ ରକାନ୍‌ ଜିସୁଙ୍ଗ୍‌ ଉତର୍‌ ହିତାନ୍‌, “ଏ ଗୁରୁ, ଇଦାଂ ଇଞ୍ଜି ଏନ୍‌ ମାଙ୍ଗେଙ୍ଗ୍‌ ପା ଲାଜୁ କିଦ୍‌ନାୟା ।” ");
INSERT INTO peg_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","ଜିସୁ ଇଚାନ୍‌, ହାୟ୍‌, “ଦରମ୍‌ ସାସ୍ତର୍‌ ଜେ ଏପେଙ୍ଗ୍‌ ଏପେଙ୍ଗ୍‌ ପା ଦାଣ୍ଡ୍‌ନି ବାହା, ଇନାକିଦେଂକି ଏପେଙ୍ଗ୍‌ ମାନାୟାର୍‌ ଜପି ବଜ୍‌ ଲାଦିକିନାଦେରା ଆରି ଜାର୍‌ ର ୱାଚ୍‌କାତାଂ ହିଜ଼ି ହେଦାଂ ଡୁଜ଼ି ହାଙ୍ଗ୍‌କିଦୁୟା । ");
INSERT INTO peg_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","ହାୟ୍‌, ଏପେଙ୍ଗ୍‌ ଡାଣ୍ଡ୍‌ନି ବାହା ଇନାକିଦେଂକି ଏପେଙ୍ଗ୍‌ ବେଣ୍‌ବାକ୍‌ଣାୟ୍‌ କିନାକାନ୍ତି ଦୁଗେର୍‌ ରଚ୍‌ଚି ମାନାଟ୍‌, ଇମ୍‌ଣାକାରିଂ ଦାଦିର୍‌ଆକର୍ ହେୱାରିଂ ଅଜ଼ି ମାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","ଲାଗିଂ, ମି ଦାଦିର୍‌ ଆକର୍‌ତି କାମାୟ୍‌ ବିସ୍ରେ ଏପେଙ୍ଗ୍‌ ସାକି ଆନାଦେରା ଆରି ବାଚି କିନାଦେରା; ଇନାକିଦେଂକି ହେୱାର୍‌ ହିନା ହେୱେରିଂ ଅସ୍ତି ମାଚାର୍‌, ମତର୍‌ ଏପେଙ୍ଗ୍‌ ହେୱାର୍‌ତି ଦୁଗେର୍‌ବାହା ରଚ୍‌ଚି କିଜ଼ି ମାନାଟ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","ଲାଗିଂ ଇସ୍ୱର୍‌ ପା ଜାର୍‌ ବୁଦିତାଙ୍ଗ୍‍ ୱେଚ୍‍ତାନ୍‍ନା, ଆସେଙ୍ଗ୍‌ ହେୱାର୍‌ ତାକେ ବେଣ୍‌ବାକ୍‌ଣାୟ୍‌କିନାକାନ୍‌ ଆରି ପକ୍ୟାତାକାର୍‌ରିଂ; ପକ୍‍ନାପ୍‍ ହେୱାର୍‌ ବିତ୍ରେ ଇନେ ଇନେରିଂ ହେୱାର୍‌ ଟ୍ରାକ୍‌ନାର୍‌ ଆରି ଇନେ ଇନେରିଂ ନିନ୍ଦା କିନାର୍‌, ");
INSERT INTO peg_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","ଇନେସ୍‌ ହେ ବଲ୍‌ନି ନେତେର୍‌ତାଂ, ଇମ୍‌ଣି ଜିକିରିୟ ଗାର୍‌ଣି ଆରି ମନ୍ଦିର୍‌ନି ପୁଇପୁୟା ବାହାନି ମାଦି ହାତାନ୍‌, ହେୱାନ୍ତି ନେତେର୍‌ ପାତେକ୍‌ ପୁର୍ତିନି ଆରମ୍‌ତାଂ ଏଚେକ୍‌ ବେଣ୍‌ବାକ୍‌ଣାୟ୍‌କିନାକାର୍‌ତି ନେତେର୍‌ ହାଚାତ୍‌ନା, ");
INSERT INTO peg_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","ହେବଲ୍‌ ଟୁଟିତାଂ ଆରମ୍‌ କିଜ଼ି ଜିକରିୟ ପାତେକ୍‌, ଇମ୍‌ଣାକାନିଂ ଗାର୍‌ଣି ଆରି ପୁଇପୁୟା ବାହା ବିତ୍ରେ ଟୁଣ୍‌ଚି ମାଚାର୍‌ । ଆଁ ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ଇଞ୍ଜ୍‌ନାଙ୍ଗା, ଇ ଜୁଗ୍‌ନି ମାନାୟାର୍‌ ହେୱାନ୍‌ ୱିଜ଼ାର୍‌ତି କାଜିଂ ନେତେର୍‌ନି ଦାଣ୍ଡ୍‌ ବଗି କିନାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“ହାୟ୍‌, ଡାଣ୍ଡ୍‌ନି ବାହା ଦରମ୍‌ ସାସ୍ତର୍‌, ଇନାକିଦେଂକି ଏପେଙ୍ଗ୍‌ ବୁଦିନି କୁଚିକାଡି ଆରାୟ୍‌ କିନାଦେର୍‌; ଏପେଙ୍ଗ୍‌ ନିଜେ ନିଜେ ହଣ୍‌ୱାତାଦେର୍‌, ଆରି ହଣି କାଜିଂ ମାନ୍‍କିତି ମାନାୟାରିଂ କସ୍ଟ ହିତାଦେର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","ଆରି, ଜିସୁ ହେବେତାଂ ହସି ହାଚି ପାଚେ ସାସ୍ତିର୍‌ ଆରି ପାରୁସିର୍‌ ବେସି ବେରୁଆଜ଼ି, ");
INSERT INTO peg_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","ତା ୱେଇଦାଂ ଇନା ବେଣ୍‌ ଆସ୍ତେଙ୍ଗ୍‌ ଇଞ୍ଜି ଡ଼ୁକା ଉଚ୍‍ଚି ତାଙ୍ଗେଙ୍ଗ୍‌ ଆଦିକ୍‌ ବିସ୍ରେ ପର୍‌ସନ୍‌ ୱେନ୍‌ବେଦେଂ‍ ଲଗାତାନ୍‍ । ");
INSERT INTO peg_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","ଇବେତାଂ ହେନି ମାନାୟ୍‌ ରୁଣ୍ଡା ଆଜ଼ି ହାରି ଜପି କ୍ଡୁସ୍‌ପ୍ପା ଆତାର୍‌; ହେ ପାଦ୍‌ନା ହେୱାନ୍‌ ପର୍ତୁମ୍‌ ଜାର୍‌ ଚେଲାରିଂ ଇଞ୍ଜେଙ୍ଗ୍‌ ଲାଗାତାନ୍‌, “ପାରୁସିର୍‌ତି ହଇନି ଲାଗ୍‌ଦି କୁଟ୍‌ ବିସ୍ରେ ଜାଗ୍ରତ୍‌ ଆଜ଼ି ମାନାଟ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","ଇନାକା ଡ଼ୁକ୍‌ତାତ୍‌ନ୍ନା ହେଦାଂ ଚନ୍‌ଞ୍ଜାନାତ୍‌ ଆରି ୱିଜ଼ୁ ଡ଼ୁକ୍‌ତାକା ବିସ୍ରେ ହପ୍‌ୟାନାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","ଇଚିସ୍‌ ଏପେଙ୍ଗ୍‌ ଇନା ଇନାକା ମାଜ୍‌ଗାତାଂ ଇନାଦେରା, ହେଦାଂ ୱିଜ଼ୁ ଅଜଡ଼୍‌ ତାକେ ୱେନ୍‍ୟାଆନାତ୍‍, ଆରି ଇନାକା ଡ଼ୁକ୍‌ତି ବିତ୍ରେ କାଲେତାଂ ଇଚାଦେର୍ଣ୍ଣା, ହେଦାଂ ବାକ୍ରାତ ଜେଗନ୍‌ ଜପି ସୁଣାୟ୍‌ କିୟା ଆନାତ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“ମାତର୍‌ ନା ସାଙ୍ଗ ଜେ ଏପେଙ୍ଗ୍‌, ମିଙ୍ଗେଙ୍ଗ୍‌ ଆନ୍‌ ଇଞ୍ଜ୍‌ନାଙ୍ଗା, ଇମ୍‍ଣାକାର୍‌କି ଗାଗାଡ଼୍‌ତିଂ ଅହ୍‌ନାର୍‌, ମତର୍‌ ତା ପାଚେ ଆରେ ବେସି ନସ୍ଟ କିଦେଙ୍ଗ୍‌ ଆଡୁର୍‌, ହେୱାରିଂ ପାଣ୍ଡ୍ରୁ ଆମାଟ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","ମାତର୍‌ ଇନେରିଂ ପାଣ୍ଡ୍ରା ଆନାଦେର୍‌, ହେଦାଂ ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ୱେଚ୍‌ଚାନାଂ; ଅସ୍ତି ପାଚେ ନରକ୍‌ତ ତୁସିହିନି କାସି ଇନେର୍‌ତି ଆଦିକାର୍‌ ମାନାତ୍‌, ତାଙ୍ଗେଙ୍ଗ୍‌ ପାଣ୍ଡ୍ରା ଆଡୁ; ଆଁ ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ହାତ୍‌ପା ଇଞ୍ଜ୍‌ନାଙ୍ଗା, ତାଙ୍ଗେଙ୍ଗ୍‌ ପାଣ୍ଡ୍ରା ଆଡୁ ।” ");
INSERT INTO peg_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“ପାଞ୍ଚ୍‌ଗଟା କଡିହାଡ଼ା ପଟିଂ ଇନାକା ଦୁଇ ଟାକା ଡାବୁକାଂ ପ୍ରୟାଆଉତ୍‌ ? ଆରି, ହେୱାଙ୍ଗ୍‌ ବିତ୍ରେତାଂ ରଞ୍ଜାଙ୍ଗ୍‌ ପା ଇସ୍ୱର୍‌ ବାଣାଆଉନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","ମାତର୍‌ ମି କାପ୍‌ଡ଼ାନି ୱିଜ଼ୁ ତେମୁଲ୍‌ ଗାଣା କିତ୍‌ତାନ୍‌ନା ପାଣ୍ଡ୍ରା ଆମାଟ୍‌; ଏପେଙ୍ଗ୍‌ ବେସି କଡିହାଡ଼ା ପଟିଂତାଂ ଆଦିକ୍‌ ଗାଜା ।” ");
INSERT INTO peg_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“ଆରେ, ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ଇଞ୍ଜ୍‌ନାଙ୍ଗା, ଇମ୍‌ଣି ମାନାୟାରିଂ ମୁମ୍‌ଦ ନାଙ୍ଗେଙ୍ଗ୍‌ ଏତୁ କିଦ୍‌ନାଦେର୍‌, ମାନାୟ୍‌ ମାଜ଼ି ପା ଇସ୍ୱର୍‌ ଦୁତ୍‌ର୍‌ ମୁମ୍‌ଦ ତାଙ୍ଗେଙ୍ଗ୍‌ ଏତୁ କିତାର୍‌; ");
INSERT INTO peg_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","ମାତର୍‌ ଜେ ଲକୁ ମୁମ୍‌ଦ ନାଙ୍ଗେଙ୍ଗ୍‌ ଏତୁ କିଦୁଦେର୍‍, ହେୱାନ୍‌ ଇସ୍ୱର୍‌ତି ଦୁତ୍‌ର୍‌ ମୁମ୍‌ଦ ମାନି କିୟା ଆଉଦେର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“ଆରେ, ଇନେର୍‌ ମାନାୟ୍‌ ମାଜ଼ି ବିରତ୍‌ତାଂ କାତା ଇନାଦେର୍‌, ତାଙ୍ଗେଙ୍ଗ୍‌ କେମା ହିୟାନାତ୍‌; ମତର୍‌ ଜେ ପୁଇପୁୟା ଜିବୁନ୍‌ ବିରୁତ୍‌ତାଂ ନିନ୍ଦା କାତା ଇନାର୍‌, ତାଙ୍ଗେଙ୍ଗ୍‌ କେମା ହିୟା ଆଉତ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“ଆରେ, ଏଚେକାଡ଼୍‌ଦ ହେୱାର୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ କୁଟୁମ୍‌ ଇଞ୍ଜ, ସାସନ୍‌ କିନାକାର୍‌ ଆରି ଆଦିକାର୍‌ ପାୟା ଆତି ମାନାୟାରିଂ ଲାଗେ ତାହିୱାନାର୍‌ ହେ ପାଦ୍‌ନା, ଏପେଙ୍ଗ୍‌ ଜାର୍‌ ପାକ୍ୟାତ ଇନେସ୍‌ କିଜ଼ି ଇନା କାତା ଉତର୍‌ ହିନାନ୍‌ ଇଞ୍ଜି ଇନାକା ଇନାଦେର୍‌, ହେୱାନ୍‌ ବିସ୍ରେ ଚିନ୍ତା କିମାଟ୍‌; ");
INSERT INTO peg_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","ଇନାକିଦେଂକି ଇନାକା ଇନ୍ୟା ଆନାତ୍‌, ହେଦାଂ ପୁଇପୁୟା ଜିବୁନ୍‌ ହେପାଦ୍‌ନା ମିଙ୍ଗେଙ୍ଗ୍‌ ହିକାଇକିଦ୍‌ନାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","ମାନାୟାର୍‌ ବିତ୍ରେତାଂ ରୱାନ୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ଇଚାନ୍‌, “ଏ ଗୁରୁ, ନା ଟଣ୍ଡେନିଂ ନା ଲାହାଙ୍ଗ୍‌ ଆବାତି ଦାନ୍‌ ବାଗ୍‌ କିଦେଙ୍ଗ୍‌ ଇଞ୍ଜି ବଲ୍‌ ଇନା ।” ");
INSERT INTO peg_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","ମାତର୍‌ ହେୱାନ୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ଇଚାନ୍‌, “ଏ ଟଣ୍ଡେନ୍‌, ଇନେନ୍‌ ନାଙ୍ଗେଙ୍ଗ୍‌ ମି ଜପି ବିଚାର୍‌କିନାକାନ୍‌ ଆରି ବାଟା କିନାକାନ୍‌ ମାଦି କିଜ଼ି ବାଚିକିତାନ୍‌ ?” ");
INSERT INTO peg_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","ଆରେ, ହେୱାନ୍‌ ହେୱାରିଂ ଇଚାନ୍‌, “ଜାଗ୍ରତ୍‌, ୱିଜ଼ୁ ବାନି କଟିତାଂ ଜାର୍‌ ଜାର୍‌ତିଂ ଦେହା ଇଟାଟ୍‌, ଇନାକିଦେଂକି ରୱାନ୍‌ ମାନାୟ୍‌ତିଂ ଜିବୁନ୍‌ ତା ଦାନ୍‌ ଆଦିକ୍‌ ଜପି ମାନ୍‍କିଉନ୍ ।” ");
INSERT INTO peg_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","ଆରେ, ଜିସୁ ହେୱେରିଂ ଇ ଉତର୍‌ମୁଡ଼୍‌ ଇଚାନ୍‌, “ରକାନ୍‌ ମାଜାନ୍‌ ମାନାୟ୍‌ତି ଜମିତାକେ ଆଦିକ୍‌ ପାଚି ଆତାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","ହେବେ ହେୱାନ୍‌ ମାନ୍ତ ମାନ୍ତ ଏତ୍‌ କିଜ଼ି ଇଚାନ୍‌, ଇନାକା କିନାଙ୍ଗ୍‌ ? ଇନାକିଦେଂକି ନା ପାଚି ମଦାୟ୍‌ କିଜ଼ି ଇଟ୍‌ଦେଂ ଇଞ୍ଜି ବାହା ହିଲୁତ୍‍ । ");
INSERT INTO peg_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","ଆରି, ହେୱାନ୍‌ ଇଚାନ୍‌, ଇଦାଂ କିନାଙ୍ଗ୍‌; ନା ଟୁଣ୍ଡିଙ୍ଗ୍‌ ଡ୍ରିକ୍‌ଚି ଗାଜାଙ୍ଗ୍‌ ଗାଜାଙ୍ଗ୍‌ କିଜ଼ି ରଚ୍‌ନାଙ୍ଗ୍‌ ଆରି ହେ ୱିଜ଼ୁ ତାକେ ନା ତାସ୍‌ ଆରି ଜିନ୍‍ସୁପାତି ୱିଜ଼ୁ ମଦାୟ୍‌ କିଜ଼ି ଇଟ୍‍ନାଙ୍ଗ୍‌, ");
INSERT INTO peg_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","ଆରି, ଆନ୍‌ ନା ୱାସ୍କିତିଂ ଇନାଙ୍ଗ୍‌ ଏ, ଜିବୁନ୍‌, ଆଦିକ୍‌ ବାର୍ହୁ କାଜିଂ ନିନ୍ଦାଂ ଆଦିକ୍‌ ଜିନ୍‍ସୁ ରୁଣ୍ଡା ଆତାତ୍‌ନ୍ନା, ଜମା, ତିନ୍‌ଞ୍ଜି ଉଣ୍‌ଜି, ୱାରି କିୟା; ");
INSERT INTO peg_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","ମତର୍‌ ଇସ୍ୱର୍‌ ହେୱାନିଂ ଇଚାନ୍‌, ଆଡ଼େ ନିର୍‌ବୁଦ୍‍ୟା, ନେଞ୍ଜେଙ୍ଗ୍‌ ନାଣା ନି ୱାସ୍କି ନିବେ ତାଙ୍ଗ୍‌ ଅୟାନାତ୍‌; ହେବେତାଂ ଏନେଙ୍ଗ୍‌ ଇନା ଇନାକା ଜାର୍‌ କାଜିଂ ଜତନ୍‌ କିତାୟ୍‌ନା, ହେଦାଂ ୱିଜ଼ୁ ଇନେର୍‌ତି ଆନାତ୍‌ ?” ");
INSERT INTO peg_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","ଇନେନ୍‌ ଜାର୍‌ କାଜିଂ ଦାନ୍‌ ରୁଣ୍ଡାୟ୍‍ କିନାନ୍‌, “ମାତର୍‌ ଇସ୍ୱର୍‌ ଆଗେ ହାଉକାର୍‌ ଆକାୟ୍‌, ହେଦାଂ କାଜିଂ ଇ ଲାକେ ଗିଟା ଆନାତ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","ଜିସୁ ଜାର୍‌ ଚେଲାରିଂ ଇଚାନ୍‌, “ଇଦାଂ କାଜିଂ ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ଇଞ୍ଜ୍‌ନାଙ୍ଗା, ଇନାକା ତିନାଦେର୍‌, ଇ ଲାକେ ମି ଜିବୁନ୍‌ କାଜିଂ ଆତିସ୍‌ ଇନାକା ଉସ୍‍ପାନାଦେର୍‍, ଇ ଲାକେ ମି ଗାଗାଡ଼୍‌ କାଜିଂ ପା ଚିନ୍ତା କିମାଟ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","ଇନାକିଦେଂକି କାଦିତାଂ ଜିବୁନ୍‌ ଆରି ହେନ୍ଦ୍ରାତାଂ ଗାଗାଡ଼୍‌ ଗାଜା । ");
INSERT INTO peg_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","ପଟିଂ ବିସ୍ରେ ହୁଡ଼ାଟ୍‌, ହେୱେକ୍‌ ୱିତୁକ୍‌ କି ତ୍ରେସୁକ୍‌ପା, ଆରି ହେୱେକ୍‍ତି ଇଲ୍‌ କି ଟୁଣ୍ଡି ହିଲୁତ୍‍, ଆରେ ଇସ୍ୱର୍‌ ହେୱାକାଂ କାଦି ହିନାନ୍‌; ଏପେଙ୍ଗ୍‌ ପଟିଂତାଂ ଆଦିକ୍‌ ଗାଜା । ");
INSERT INTO peg_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","ଆରେ, ମି ବିତ୍ରେପା ଇନେର୍‌ ଚିନ୍ତା କିଜ଼ି କିଜ଼ି ଜାର୍‌ ଆଁଇସ୍‌ ଲାମା କିଦେଙ୍ଗ୍‌ ଆଡ୍‌ନାନ୍‌ ? ");
INSERT INTO peg_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","ଆତିସ୍‌, ଏପେଙ୍ଗ୍‌ ଜଦି ୱିଜ଼ୁତାଙ୍ଗ୍ ହିରୁ କାମାୟ୍‌ କିଦେଙ୍ଗ୍‌ ପା ଆଡୁୟ୍‌, ଲାଗିଂ ବିନେ ୱିଜ଼ୁ ବିସ୍ରେ ହେଦାଂ ଇନେକିଦେଂ ଚିନ୍ତା କିନାଦେରା ? ");
INSERT INTO peg_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","ପୁଇକୁ ବିସ୍ରେ ବାବି କିଜ଼ି ହୁଡ଼ାଟ୍‌, ହେୱାଙ୍ଗ୍‌ ଇନେସ୍‌ ନୁଲ୍‌ ନାଟୁକ୍‍ କି ଡ଼ଚୁକ୍‌; ଆତିସ୍‌ପା ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ଇଞ୍ଜ୍‌ନାଙ୍ଗ୍‌, ସଲମନ୍‌ ପା ଜାର୍‌ ୱିଜ଼ୁ ହଲ୍‌ନାକାତ ଇୱାଙ୍ଗ୍‌ ବିତ୍ରେ ରଞ୍ଜାଙ୍ଗ୍‍ ଲାକେ ଉସ୍‌ପାୱାଦାଂ ମାଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","ମାତର୍‌ ଇମ୍‌ଣି କାଚ୍ରା ନେଜେଙ୍ଗ୍‌ ବାଡ଼୍‌ଦ ମାନାତ୍‌, ଆରି ୱିଗାଲିଙ୍ଗ୍‌ ହଲ୍‌ଦ ଦେହିୟା ଆନାତ୍‌, ତାଙ୍ଗେଙ୍ଗ୍‌ ଇନାୱାଡ଼ାଂ ଇସ୍ୱର୍‌ ଇ ଲାକେ ବେସ୍‌ ହିଦ୍‍ନାନ, ଲାଗିଂ, ହେ ଅଲପ୍‍ ପାର୍ତି କିନାଦେର୍‌, ହେୱାନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ଏଚେକ୍‌ ଆଦିକ୍‌ ଲାକେ ହିଦୁନ୍‍ ।” ");
INSERT INTO peg_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","ଆରେ, ଇନାକା ତିନାକା ଆରି ଇନାକା ଉଣାକା, ହେଦାଂ ଏପେଙ୍ଗ୍‌ ଡେକ୍‌ଚି ବୁଲାଆମାଟ୍‌ କି ମାନ୍‌ ଦୁକ୍‌ କିମାଟ୍‍, ");
INSERT INTO peg_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","ଇନାକିଦେଂକି ପୁର୍ତିନି ପାର୍ତିକିୱି ଜିହୁଦିର୍‌ ଇ ୱିଜ଼ୁ ବିସ୍ରେ ଡେକ୍‌ଚି ବୁଲା ଆନାର୍‌; ମାତର୍‌ ଇ ୱିଜ଼ୁ ବିସ୍ରେ ଜେ ମିଦାଙ୍ଗ୍‌ ଲଡ଼ା, ହେଦାଂ ମି ସାର୍ଗେନି ଆବା ପୁଞ୍ଜ୍‌ନାନ୍‍ । ");
INSERT INTO peg_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","ଆତିସ୍‌ ଏପେଙ୍ଗ୍‌ ଇସ୍ୱର୍‌ ରାଜି ଡେକାଟ୍‌, ଆରି ଇ ୱିଜ଼ୁ ବିସ୍ରେ ପା ମିଙ୍ଗେଙ୍ଗ୍‌ ହିଦ୍‌ନାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“ଏ ହିରୁ ମାନ୍ଦା, ପାଣ୍ଡ୍ରା ଆମାଟ୍‌, ଇନେକିଦେଂ ମିଙ୍ଗେଙ୍ଗ୍‌ ତା ରାଜି ହିଦ୍‌ନି କାଜିଂ ମି ଆବାତି ବେସି ୱାରି ଆନାତା । ");
INSERT INTO peg_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","ମିଙ୍ଗେଙ୍ଗ୍‌ ଇନାକା ମାନାତ୍‌, ହେଦାଂ ପ୍ରସି ହିଲ୍‌ୱାକାରିଂ ଦାନ୍‌ ହିୟାଟ୍‌; ଇନାକା ନସ୍ଟ ଆଉତ୍‌ ଇ ଲାକେ ମଣା ଜାର୍‌ ଜାର୍‌ କାଜିଂ ଜାଲ୍‌ଦି କିୟାଟ୍‌, ଇମେତାକେ ଚର୍‌ ଲାଗେ ୱାଉନ୍‌ କି ପ୍ଡିକୁ ନସ୍ଟ କିଉକ୍‌, ଇ ଲାକେ ସାର୍ଗେନି ନସ୍ଟ ଆୱି ଦାନ୍‌ ଆର୍ଜା ଆଡ । ");
INSERT INTO peg_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","ଇନାକିଦେଂକି ଇମେତାକେ ମିଦାଙ୍ଗ୍‌ ଦାନ୍‌, ହେବେ ପା ମିଙ୍ଗେଙ୍ଗ୍‌ ମାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“ମି ମେଙ୍ଗାଙ୍ଗ୍‍ ଗାଚ୍ୟା ଆଜ଼ି ମାନେତ୍‍ ଆରି ଅଜଡ଼୍‌ ଆଜ଼ି ମାନେତ୍‍; ");
INSERT INTO peg_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","ଆରି, ମାପ୍ରୁ ବିବା ୱେଡ଼ାଙ୍ଗ୍‌ ଲେଉଟା ଆଜ଼ି ଦୁୱେର୍‌ତିଂ ଇଡ଼ିତିପାଚେ ଇମ୍‌ଣି ମାନାୟାର୍‌ ହେଦାଂ କାଜିଂ ସାଙ୍ଗେ ସାଙ୍ଗେ ଦୁୱେର୍‌ ଜେତ୍‍ତେଂ କାଜିଂ ମାନାର୍‌, ଏପେଙ୍ଗ୍‌ପା ହେୱାର୍‌ ଲାକେ ଆଜ଼ି ମାନାଟ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","ମାପ୍ରୁ ୱାଜ଼ି ଇମ୍‌ଣି ଆଡ଼ିୟାରିଂ ଜାଗ୍ରତ୍‌ ହୁଡ଼୍‍ନାନ୍‌, ହେୱାର୍‌ ଦନ୍ୟ, “ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ହାତ୍‌ପା ଇଞ୍ଜ୍‌ନାଙ୍ଗା, ହେୱାନ୍‌ ନିଜେ ମେଙ୍ଗାଙ୍ଗ୍‍ ଗାଚ୍‌ଚି ହେୱାରିଂ ତିନି ବାହାତ କୁଚି କିଜ଼ି ଲାଗେ ହାଲ୍‌ଜି ହେବା କିତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","ଆରି, ହେୱାନ୍‌ ମାଦିମାଦାନାଣା ଅଜଡ଼୍‌ ଆନିହିଙ୍ଗ୍‌ ପା ୱାଜ଼ି ହେୱେରିଂ ହେ ଲାକେ ହୁଡ଼୍‌ନାନ୍‌, ତା ଆତିସ୍‌ ହେ ହଲ୍ୟାର୍‌ ଦନ୍ୟ । ");
INSERT INTO peg_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","ମାତର୍‌ ଇଦାଂ ପୁଞ୍ଜି ମାନାଟ୍‌, ଇମ୍‌ଣି ସମୁତ ଚରେନ୍‌ ୱାନାନ୍‌ ଇଲ୍‌ ମୁଣିକା ଏଚେକାଡ଼୍‌ଦ ପୁନାନ୍‌, ତାଆତିସ୍‌ ହେୱାନ୍‌ ଜାର୍‌ ଇଞ୍ଜ ଚର୍‌ କିଦେଂ ହିଉନ୍‍ । ");
INSERT INTO peg_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","ଏପେଙ୍ଗ୍‌ ପା ଜାଗ୍ରତ୍‌ ଆଜ଼ି ମାନାଟ୍‌, ଇନାକିଦେଂକି ଇମ୍‌ଣି ସମୁତ ଏପେଙ୍ଗ୍‌ ବାବି କିଜ଼ି ମାନ୍‍ଗୁଦେର୍‌, ହେ ସମୁତ ମାନାୟ୍‌ ମାଜ଼ି ୱାନାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","ହେବେତାଂ ପିତର୍‌ ଇଚାନ୍‌, “ଏ ମାପ୍ରୁ, ଏନ୍‌ କେବଲ୍‌ ମାଙ୍ଗେଙ୍ଗ୍‌ କି ୱିଜ଼ାରିଂ ଇ ଉତର୍‌ମୁଡ଼୍‌ ଇଞ୍ଜ୍‌ନାନା ?” ");
INSERT INTO peg_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","ମାପ୍ରୁ ଉତର୍‌ ହିତାନ୍‌, “ଲାଗିଂ ଜାର୍‌ ଲକ୍‌ବାକ୍‍ତିଂ ସମାନ୍‌ ହିଦେଂ ଇଞ୍ଜି ମୁଣିକା ଇଲ୍‌ ଚାଲାୟ୍‌କିନା କାନିଂ ଦାଇତ୍‌ ହିଜ଼ି ମାଚାନ୍‌ ହେୱାନ୍‌ ସମାନ୍‌ ସମୁତ ବିନ୍‌ ହଲିୟାରିଙ୍ଗ୍‌ ପା ଚିଞ୍ଜେଙ୍ଗ୍‌ ହିଜ଼ି ମାନ୍‌ୱାତାନ୍‌ ? ");
INSERT INTO peg_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","ମାପ୍ରୁ ୱାଜ଼ି ଜାର୍‌ତି ଇମ୍‌ଣି ଆଡ଼ିୟାଙ୍ଗ୍‌ ହେ ଲାକେ କିନାକା ହୁଡ଼୍‌ନାନ୍‌, ହେୱାନ୍‌ ଦନ୍ୟ । ");
INSERT INTO peg_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ହାତ୍‌ପା ଇଞ୍ଜ୍‌ନାଙ୍ଗା, ହେୱାନ୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ଜାର୍‌ତି ୱିଜ଼ୁ ଦାନ୍‌ତିଙ୍ଗ୍ ଜପି ବାଚି କିଦ୍‌ନାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","ମାତର୍‌ ଜଦି ହେ ଆଡ଼ିଏନ୍‌ ନା ମାପ୍ରୁ ୱାନାକା ବିଲମ୍‌ ମାନାତ୍‌ ଇଞ୍ଜି ମାନ୍ତ ମାନ୍ତ ଇଞ୍ଜି ହଲିୟା ଆଡ଼ିଏନ୍‌ଣିକାଂ ଅସ୍ତେଙ୍ଗ୍‌ ଆରି ତିନ୍ଞ୍ଜିଉଣ୍‌ଜି ଏକ୍‌ ଆଦେଂ ଆରାମ୍‌ କିତାର୍‌, ");
INSERT INTO peg_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","ତା ଆତିସ୍‌ ଇମ୍‌ଣି ଦିନ୍‌ ଆଡ଼ିୟା କାଜିଂ ମାଞ୍ଜେଙ୍ଗ୍‌ ଆଡୁନ୍‌ ଆରି ଇମ୍‌ଣି ସମୁତ ହେୱାନ୍‌ ପୁଞ୍ଜି ମାନୁନ୍‌, ହେ ଦିନ୍‌ ଆରି ହେ ଡାଣ୍ଡ୍‌ତ ତା ମାପ୍ରୁ ୱାନାନ୍‌, ଆରେ ହେୱାନ୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ରିବାଗ୍‌ କିଜ଼ି ପାର୍ତି କିୱାକାର୍‌ ଲାହାଙ୍ଗ୍‌ ତା ବାଗ୍‌ତାକା ବାଚିକିନାର୍‍ ।” ");
INSERT INTO peg_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“ଆରେ, ଇମ୍‌ଣି ଆଡ଼ିୟା ଜାର୍‌ ମାପ୍ରୁ ମାନ୍‌ ପୁଞ୍ଜି ଜାଗ୍ରତ୍‌ ଆଜ଼ି ମାନୁନ୍‌ ଆୱିତିସ୍‌ ତା ଇଚାତାଂ କାମାୟ୍‌ କିଜ଼ି ମାନୁନ୍‌, ହେୱାନ୍‌ ବେସି ମାଡ୍‍ତାଙ୍ଗ୍‍ ମାଡ୍‍କିୟାଆନାନ୍‍; ");
INSERT INTO peg_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","ମାତର୍‌ ଇନେନ୍‌ ପୁନ୍‌ୱାଦାଂ ମାଡ୍‍ତିନି କାମାୟ୍‌ କିଜ଼ି ମାନାନ୍‌, ହେୱାନ୍‌ ଅଲପ୍‍ ମାଡ୍‍ତାଙ୍ଗ୍‍ ମାଡ୍‍କିୟାଆନାନ୍‍ । ଇନେରିଂ ବେସି ହିୟାଆତାତ୍‍ନା, ତା ତାକେଣ୍ଡାଂ ବେସି ଦାବା କିୟାନାତ୍‌ ଆରେ, ଲକୁ ଇନେନ୍‌ ତାକେ ବେସି ହେଲାୟ୍‌ କିୟାତାନ୍‌ନା, ତା ଲାଗାଂ ବେସି ଦାବା କିନାର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“ଆନ୍‌ ପୁର୍ତିତ ନାଣି ଆହି କିଦେଙ୍ଗ୍‌ ୱାତାଂନା, ଆରେ ହେଦାଂ ଜଦି ଆସ୍ତାତେ ତାଆତିସ୍‌ ନା ଆରେ ଇନାକା ମାନ୍‌, ");
INSERT INTO peg_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","ମାତର୍‌ ନାଙ୍ଗ୍‌ ର ବାପ୍ତିସିମ୍‌ତ ବାପ୍ତିସିମ୍‌ ଆନାକା ମାନାତ୍‌, ଆରି ହେଦାଂ ୱିଜ଼୍‌ୱି ପାତେକ୍‌ ଆନ୍‌ ଇନେସ୍‌ ଦୁକ୍‌ ମାନ୍ତ ବାବିକିନାଙ୍ଗା । ");
INSERT INTO peg_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","ଆନ୍‌ ପୁର୍ତିତିଂ ସୁସ୍ତା ହିଦେଂ ୱାତାଂନା ଇଞ୍ଜି ଇନାକା ଏପେଙ୍ଗ୍‌ ଏତ୍‌ କିନାଦେରା ? ଆକାୟ୍‌ ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ଇଞ୍ଜ୍‌ନାଙ୍ଗା, କୁଦାକୁଦା କିଦେଙ୍ଗ୍‌ ୱାତାଂନା । ");
INSERT INTO peg_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","ଇନାକିଦେଂକି ର ଇଞ୍ଜ ପାଞ୍ଚ୍‌ଜାଣ୍‌ ମାଚିସ୍‌ ରିୟାର୍‌ ବିରୁତ୍‌ତାଂ ତିନ୍‌ଜାଣ୍‌ ଆରି ତିନ୍‌ଜାଣ୍‌ତିଂ ବିରୁଦ୍‌ତ ରିୟାର୍‌ ବିନେ ବିନେ ଆନାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","ମାଜ଼ି ବିରୁଦ୍‌ତ ଆବା, ଆବା ବିରୁଦ୍‌ତ ମାଜ଼ି, ଗାଡ଼୍‌ଚେ ବିରୁଦ୍‌ତ ଆୟା, ଆୟା ବିରୁଦ୍‌ତ ଗାଡ଼୍‌ଚେ, କଡ଼ିୟା ବିରୁଦ୍‌ତ ପଦାହି ଆରି ପଦାହି ବିରୁଦ୍‌ତ କଡ଼ିୟାଣିହି ବିନେ ଆନାତ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","ଆରେ, ହେୱାନ୍‌ ମାନାୟାରିଂ ପା ଇଚାନ୍‌, ଡେବା ପାଡ଼୍‌କାନି ବାଦାଡ଼୍‌ ନିଙ୍ଗ୍‌ନାକା ହୁଡ଼୍‌ତିସ୍‌ ହେ ଦାପ୍ରେ ଏପେଙ୍ଗ୍‌ ଇନାଟ୍‌, ବାର୍‌ହା ୱାନାତ୍‌, ଆରେ ଏଲେଙ୍ଗ୍‌ ଲାକେ ଗିଟା ଆଦ୍‌ନାତ୍‌; ");
INSERT INTO peg_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","ଆରେ, ତିନିପାଡ଼୍‌କାନି ଦୁକା ୱାନାକା ହୁଡ଼୍‌ତିସ୍‌ ଏପେଙ୍ଗ୍‌ ଇନାଟ୍‌, ଗାଜା କାରା ୱାନାତ୍‌, ଆରେ ହେଦାଂ ଗିଟା ଆଦ୍‌ନାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","ଆଡ଼େ କାପ୍‌ଟିୟାର୍‌ କାଦେର୍, ଏପେଙ୍ଗ୍‌ ପୁର୍ତିତ ଆରେ ବାଦାଡ଼୍‌ତାଂ ହୁଡ଼୍‌ଜି ୱିଜ଼ୁ ବୁଜା ଆନାଦେରା, ମାତର୍‌ ଇ ଦିନ୍ତ ଚିନ୍‌ ହୁଡ଼୍‌ଜି ୱିଜ଼ୁ ଇନେସ୍‌ ବୁଜା ଆଉଦେରା ? ");
INSERT INTO peg_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“ଆରେ, ଜାର୍‌ ଜାର୍‌ ଇନେକିଦେଂ ନିୟାୟ୍‌ ବିଚାର୍‌ କିଉଦେରା ? ");
INSERT INTO peg_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","ମି କୁର୍‍ଲିୟା ହୁକେ ସାସନ୍‌କିନାକାନ୍‌ କଚଣ୍‌ତ ହାନିହିଂ ହାସ୍‌ଦ ପା ତା ଲାହାଙ୍ଗ୍‌ ମୁକ୍‌ଡ଼ା ଆଦେଂ ଜାତୁନ୍‌ କିୟାଟ୍‌, ଏଚେକାଡ଼୍‌ଦ ହେୱାନ୍‌ ନିଂ ବିଚାର୍‌କାର୍‌ୟା କଚଣ୍‌ ଜେଲ୍‌ଜି ଅଦ୍‍ନାର୍‍, ଆରେ ବିଚାର୍‌ କିନାକାନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ମେଲ୍ୟାର୍‌ କେଇଦ ସର୍‌ପି କିଦ୍‌ନାର୍‌, ଆରେ ମେଲ୍ୟାର୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ତାନାଇଞ୍ଜ ବାର୍ତି କିଦ୍‌ନାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ଇଞ୍ଜ୍‌ନାଙ୍ଗା, ଏପେଙ୍ଗ୍‌ ହାରିହାରା ଡାବୁଙ୍ଗ୍‌ ହୁଜା ଆୱି ପାତେକ୍ ହେ ବାହାତାଂ ଇନେସ୍‌ ଆଜ଼ି ହସିୱାଦେଙ୍ଗ୍ ଆଡୁଦେର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","ହେ ସମୁତ କେତ୍‌ଜାଣ୍ ମାନି କେତେକ୍‌ ଲକ୍‌ ଜିସୁଙ୍ଗ୍‌ ଇଚାର୍‌ ଜେ ଲକୁ ୱାଜ଼ି, ପିଲାତ ଇମ୍‌ଣି ଗାଲିଲିୟର୍‌ତି ନେତେର୍‌ ହେୱାର୍‌ତି ପୁଜା ଲାହାଙ୍ଗ୍‌ ମେହାୟ୍‌କିଜ଼ି ମାଚାର୍‌, ହେୱାର୍‌ ବିସ୍ରେ ହେୱାନିଂ ଜାଣାଇ କିତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","ହେବେତାଂ ଜିସୁ ହେୱାରିଂ ଉତର୍‌ ହିତାନ୍‌, “ଇଦାଂ ୱିଜ଼ୁ ବଗ୍‌ କିଦେଙ୍ଗ୍‌ ଇ ଗାଲିଲିୟର୍‌ ଜେକନି ୱିଜ଼ାର୍‌ ଗାଲିଲିୟର୍‌ ତାଙ୍ଗ୍‌ ଆଦିକ୍‌ ପାପିର୍‌ ଇଞ୍ଜି କି ଏପେଙ୍ଗ୍‌ ମାନେକିନାଦେରା ? ");
INSERT INTO peg_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","କି ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ୱେଚ୍‍ନାଙ୍ଗା, ମାତର୍‌ ପାପ୍‌ ମାନ୍‌ବାଦ୍‌ଲାୟ୍‌ କିୱିତିସ୍‌ ଏପେଙ୍ଗ୍‌ ୱିଜ଼ାକାଦେର୍‍ ହେ ଲାକେ ନସ୍ଟ ଅନାଦେର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","ଇଚିସ୍‌ ସିଲହତ ହେ ଅଟର ଜାଣ୍‌ ଜପି ମାଚା କାଡ଼୍‌ଜି ହେୱାର୍‌ତି ଜିବୁନ୍‌ ହାଚାତ୍‌, ହେୱାର୍‌ ବିସ୍ରେ ଇନାକା ବାବି କିନାଦେର୍‌ ? ହେୱାର୍‌ ୱିଜ଼ାର୍‌ ଜିରୁସାଲମ୍‌ ତାଙ୍ଗ୍‌ ଆଦିକ୍‌ ପାପିର୍‌ ଇଞ୍ଜି କି ଏପେଙ୍ଗ୍‌ ମାନେ କିନାଦେରା ? ");
INSERT INTO peg_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ୱେଚ୍‍ଚାନାଙ୍ଗ୍‌, ମାତର୍‌ ପାପ୍‌ତାଂ ମାନ୍‌ବାଦ୍‌ଲାୟ୍‌ କିୱିତିସ୍‌ ଏପେଙ୍ଗ୍‌ ୱିଜ଼ାକାଦେର୍‌ ହେ ଲାକେ ନସ୍ଟ ଆନାଦେର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","ଆରେ, ଜିସୁ ଇ ଉତର୍‌ମୁଡ଼୍‌ ଇଚାନ୍‌, “ରକାନ୍ତି ଅଙ୍ଗୁର୍‌ ବାଡ଼୍‌ଦ ର ତଗା ମାର୍‌ ରୁଜ଼୍‌ଦି ମାଚାନ୍‌ । ମାଲିକ୍‌ ୱାଜ଼ି ହେବେନି ପାଡ଼୍ ଡେକ୍‌ତାନ୍‌, ମାତର୍‌ ଗାଟା ଆୱାତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","ଲାଗିଂ ହେୱାନ୍‌ କାନାକାନ୍‌ ଇଚାନ୍‌, ହୁଡ଼ା, ଇ ତିନି ବାର୍ହୁ ଆତାତ୍‌ ଆନ୍‌ ୱାଜ଼ି ଇ ତଗା ମାର୍‌ତି ପାଡ଼୍ ଡେକ୍‍ନାଙ୍ଗା, ମାତର୍‌ ଗାଟା ଆଉଙ୍ଗା, ଇଦେଲିଂ କାଦିତୁସିୟା, ଇଦାଂ ଇନେକିଦେଂ ମେଦ୍‌ନିତିଂ ଆବାର୍‌ ଆହ୍‌ନାତା ? ");
INSERT INTO peg_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","ମାତର୍‌ ମାଲିକ୍‌ତିଂ ଉତର୍‌ ହିତାନ୍‌, ମାପ୍ରୁ, ଇଦେଲିଂ ଇ ବାର୍ହୁ ପା ପିସ୍ତିହିଦା, ଆନ୍‌ ଇବେତାଂ ଇଦାଂ ଚାରିବେଣ୍‌ତାଂ କାର୍ଚି ଗାତ୍ ହିନାଙ୍ଗ୍, ");
INSERT INTO peg_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","ଆରେ ପାଚେ ପାଡ଼୍ ୱାତିସ୍‍ ହାର୍‌, ଆୱିତିସ୍‌ ହେଦେଲିଂ କାଦ୍‌ଦି ତୁସିହିନାଙ୍ଗ୍ ।” ");
INSERT INTO peg_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","ରଗ ଜିସୁ ଜମ୍‌ନିବାର୍‌ତ ର କୁଟୁମ୍‌ ଇଞ୍ଜ ହିକ୍ୟା ହିଜ଼ିମାଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","ଆରେ ହୁଡ଼ାଟ୍‌, ଅଟର ବାର୍ହୁ ପାତେକ୍‌ ବାନ୍ୟା ଜିବୁନ୍‌ କାଜିଂ ପାପିୟା ର କଗ୍‌ଲେ ହେବେ ମାଚାତ୍‌, ହେଦେଲ୍‌ କୁବ୍‍ଡ଼ି ଆଜ଼ି ଇନେସ୍‌ ଆଜ଼ି ପା ଜାରତିଂ ହାଣ୍‍କୁ କିଦେଙ୍ଗ୍‌ ଆଡ୍‌ୱାଦାଂ ମାଚାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","ଜିସୁ ହେଦେଲିଂ ହୁଡ଼୍‌ଜି ଲାଗାୟ୍‌ କୁକ୍‌ଚି ଇଚାନ୍‌, “ଏ କଗ୍‌ଲେ ନି ବେମାର୍‍ତାଂ ଉଜ୍‌ ଆତାୟ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","ଆରେ, ଜିସୁ ହେ ଜପି କେଇ ଇଡ଼୍‌ତାନ୍‌, ହେବେତାଂ ହେଦେଲ୍‌ ହେ ଦାପ୍ରେ ହାଣ୍‍କୁ ଆଜ଼ି ଇସ୍ୱର୍‌ତିଂ ପାର୍ତାନା କିଦେଙ୍ଗ୍‌ ଲାଗାତାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","ମାତର୍‌ ଜିସୁ ଜମ୍‌ନିବାର୍‌ତ ଉଜ୍‌ କିଦେଙ୍ଗ୍‌ କୁଟୁମ୍‌ ଇଲ୍‌ନି ମୁଡ଼୍‌ଦାକାନ୍‌ ରିସା ଆଜ଼ି ମାନାୟାର୍‌ ତାକେ ଉତର୍‌ ହିତାନ୍‌, “କାମାୟ୍‌ କିନି କାଜିଂ ଚଅ ଦିନ୍‌ ମାନାତ୍‌, ଲାଗିଂ ହେ ୱିଜ଼ୁନାଞ୍ଜିଙ୍ଗ୍ ୱାଜ଼ି ଉଜ୍‌ ଆଡୁ, ଜମ୍‌ନିବାର୍‌ ୱାମାଟ୍ ।” ");
INSERT INTO peg_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","ମାତର୍‌ ମାପ୍ରୁ ହେୱାରିଂ ଉତର୍‌ ହିତାନ୍‌, “ଏ କାପ୍‌ଟିୟାର୍‌, ଏପେଙ୍ଗ୍‌ ୱିଜ଼ୁ ଇନାକା ଜମ୍‌ନିବାର୍‌ତ ଜାର୍‌ ଜାର୍‌ ବାଡ଼୍‌ଦୁ କି ଗଦ ହାଡ଼ାତାଂ ରିକ୍‌ଚି ତାସି ଏଜ଼ୁଂ ଉଟ୍‌ପାମାଡୁ ? ");
INSERT INTO peg_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","ଲାଗିଂ ହୁଡ଼ାଟ୍‌, ଅଟର ବାର୍ହୁ ପାତେକ୍‌ ସୟ୍‌ତାନ୍‌ ଲାହାଙ୍ଗ୍‌ ଇଚିସ୍‌ ଅବ୍ରାହାମ୍‌ ଗାଡ଼୍‌ହି ଇ କଗ୍‌ଲେ ଇନାକା ଜମ୍‌ନିବାର୍‌ ଜାର୍‌ ଗାଚ୍‌ଚି ତାଙ୍ଗ୍‌ ଉଜ୍‌ ଆନାକା ଇନାକା ହିଲ୍‌ୱାତାତ୍‌ ?” ");
INSERT INTO peg_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","ଆରେ, ଜିସୁ ଇ କାତା ଇଚିଲେ, ତାଙ୍ଗେଙ୍ଗ୍‌ ବେରିୟାର୍‌ ୱିଜ଼ାର୍‌ ଲାଜୁ କିଦେଙ୍ଗ୍‌ ଲାଗାତାର୍‌, ମାତର୍‌ ମାନାୟାର୍‌ ଜିସୁ ଇଞ୍ଜି ମାନି ୱିଜ଼ୁ ଜାଜ୍‌ମାଲ୍‌ ଗାଜା କାମାୟ୍‌ ସାକାତାଂ ୱାରି କିଦେଙ୍ଗ୍‌ ଲାଗାତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","ହେବେତାଂ ଜିସୁ ଇଚାନ୍‌, “ଇସ୍ୱର୍ତି ରାଜି ଇନେର୍‌ ଲାକେ ? ଆରି ଇନେର୍‌ ହାଙ୍ଗ୍‌ତାଂ ଆନ୍‌ ହେଦାଂ ତୁଲାୟ୍‌ କିନାଙ୍ଗ୍‌ ? ");
INSERT INTO peg_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","ହେଦାଂ ଇ ଲାକେ ରଞ୍ଜାଙ୍ଗ୍‌ ହାର୍‌ହୁ ମାଞ୍ଜି ଲାକେ, ହେଦାଂ ଅଜ଼ି ରକାନ୍‌ ମାନାୟ୍‌ ଜାର୍‌ ବାଡ଼୍‌ଦ ୱିତ୍‌ତାନ୍, ଆରେ ହେଦାଂ ପାନ୍‌ଚି ମାର୍‌ ଆତାତ୍‌, ଆରି ବାଦାଡ଼୍‌ତାଂ ପଟିଂ ୱାଜ଼ି ହେ ଡାଡ଼୍‌ଦ ବାହା କିତିଂ ।” ");
INSERT INTO peg_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","ଜିସୁ ଆରେ ଇଚାନ୍‌, “ଆନ୍‌ ଇନେର୍‌ ଲାହାଙ୍ଗ୍‌ ଇସ୍ୱର୍‌ ରାଜିତିଂ ତୁଲାୟ୍‌ କିନାଙ୍ଗ୍‌ ? ");
INSERT INTO peg_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","ହେଦାଂ ହଇନିରୁଟି ଲାକେ, ର କଗ୍‌ଲେ ହେଦାଂ ତାସି ମଣାତ ମଇଦା ବିତ୍ରେ ପ୍ଡାକ୍‌ଚି ଇଟ୍‌ତାତ୍‌, ଆରେ ହାରିହାରା ୱିଜ଼ୁ ହଇନି ଲାକେ ଆତାତ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","ଇବେତାଂ ହେୱାନ୍‌ ଗାଡ଼୍ ଗାଡ଼୍‌ଦ ଆରି ନାସ୍‌କୁ ନାସ୍‌କୁ ବୁଲାଆଜ଼ି ହିକ୍ୟା ହିଉ ହିଉ ଜିରୁସାଲମ୍‌ ନିପ ହାଲ୍‌ଜି ମାଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","ଆରେ, ରକାନ୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ଇଚାନ୍‌, “ମାପ୍ରୁଙ୍ଗ୍‌, ମୁକ୍ତି ଆନାକା ପାୟା ଆନି ମାନାୟାର୍‌ ହିସାବ୍ ଇନାକା ଅଲପ୍‍ ? ହେବେତାଂ ହେୱାନ୍‌ ହେୱାରିଂ ଇଚାନ୍‌,” ");
INSERT INTO peg_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","ହିରୁ ଦୁୱେର୍‌ତିଂ ହଣ୍ଡେଙ୍ଗ୍‌ କସ୍ଟକିୟାଟ୍‌, ଇନେକିଦେଂକି ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ଇଞ୍ଜ୍‌ନାଙ୍ଗା, “ବେସି ହେନି ହଣ୍‌ଗିନି କାଜିଂ ସେସ୍ଟା କିନାର୍‌, ମାତର୍‌ ଆଡୁର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","ଇଲ୍‌ ମୁଣିକା ନିଞ୍ଜି କାପାଟ୍‌ ବନ୍ଦ୍‌ କିତି ପାଚେ ଏଚେକାଡ଼୍‌ଦ ଏପେଙ୍ଗ୍‌ ବାର୍ତ ନିଲ୍‌ଚି ମାନାଦେର୍‌ ଆରି ଏ ମାପ୍ରୁ, ମା କାଜିଂ ଦୁୱେର୍‌ ଜେତା, ଇଦାଂ ଇଞ୍ଜି କାପାଟ୍‌ତ ଇଡ଼ିଦେଂ ଲାଗାନାଦେର୍, ହେ ପାଦ୍‌ନା ହେୱାନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ଉତର୍‌ ହିଦ୍‌ନାନ୍‌, ଏପେଙ୍ଗ୍‌ ଇମ୍‌ଣି ବାହାନି ମାନାୟ୍‌ ହେଦାଂ ଆନ୍‌ ପୁନୁଙ୍ଗ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","ହେ ସମୁତ ଏପେଙ୍ଗ୍‌ ଇଞ୍ଜେଙ୍ଗ୍‌ ଲାଗାନାଦେର୍, “ଆପେଂ ନି ମୁମ୍‌ଦ ଉଟାପ୍ ଚିଚାପ୍‌, ଆରି ଏନ୍‌ ମାଙ୍ଗେଙ୍ଗ୍‌ ହାକ୍ଡିତ ହିକ୍ୟା ହିତାୟ୍ ।” ");
INSERT INTO peg_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","ଆରେ, ହେୱାନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ଇଞ୍ଜ୍‌ନାନ୍‌, ଏପେଙ୍ଗ୍‌ ଇମ୍‌ଣି ବାହାନି ମାନାୟ୍‌, ହେଦାଂ “ଆନ୍‌ ପୁନୁଙ୍ଗ୍‌; ଏ ଅଦାର୍ମି ୱିଜ଼ାକାଦେର୍ ନା କଚଣ୍‌ତାଂ ଦେହାଆଡୁ । ");
INSERT INTO peg_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","ଏଚେକାଡ଼୍‌ଦ ଏପେଙ୍ଗ୍‌ ଅବ୍ରାହାମ୍‌, ଇସ୍‌ହାକ୍‌, ଜାକୁବ୍‌, ଆରି ୱିଜ଼ାର୍‌ ବେଣ୍‌ବାକ୍‌ଣାୟ୍‌କିନାକାରିଂ ଇସ୍ୱର୍‌ ରାଜିତ ମାନି ଆରି ଜାର୍‌ ଜାର୍‌ତିଂ ବାର୍‌ତ ତୁସିହିତାକା ହୁଡ଼୍‌ନାଦେର୍, ହେପାଦ୍‌ନା ହେବେ ଆଡ଼୍‌ବିସ୍‌ ଆରି ଟାଡାଙ୍ଗ୍‌ କାଟ୍‍ନାଦେର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","ଆରେ, ୱେଡ଼ାହତ୍‌ନି ଆରି ୱେଡାହାନି ନିପ, ତିନିପାଡ଼୍‌କା ଆରି ଡେବାପାଡ଼୍‍କାନି ଲକୁ ୱାଜ଼ି ଇସ୍ୱର୍‌ ରାଜିତିଂ ତିଞ୍ଜେଙ୍ଗ୍‌ କୁଚ୍‌ନାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","ଆରେ ହୁଡ଼ାଟ୍‌, ଇମ୍‌ଣାକାର୍‌ ନଙ୍ଗୟ୍‌ ପାଚେ ମାନି କେତେକ୍‌ ପର୍ତୁମ୍‌ ଆନାର୍‌ ଆରି ପର୍ତୁମ୍‌ ମାନି କେତେକ୍‌ ପାଚେ ଆର୍ନାର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","ହେ ପାଦ୍‌ନା କେତେକ୍‌ ପାରୁସିର୍‌ ଜିସୁ ଲାଗେ ୱାଜ଼ି ଇଚାର୍‌, “ଇ ବାହା ପିସ୍ତି ହସି ହାଲାଟ୍‌, ଇନାକିଦେଂକି ହେରଦ୍‌ ନିଙ୍ଗେଙ୍ଗ୍‌ ଅସ୍ତେଦେଂ ମାନ୍‌ କିନାନା ।” ");
INSERT INTO peg_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","ହେବେତାଂ ଜିସୁ ହେୱାରିଂ ଇଚାନ୍‌, “ଏପେଙ୍ଗ୍‌ ହାଲ୍‌ଜି ହେ କଲ୍ୟାତିଂ ୱେଚାଟ୍‌, ହୁଡ଼ାଟ୍‌, ଆନ୍‌ ନେଞ୍ଜେଙ୍ଗ୍‌ ଆରି ୱିଗା ପୁଦା ପିହିକିନାଙ୍ଗା ଆରି ଉଜ୍‌ କିନାଙ୍ଗା, ଆରେ ତିନି ଦିନ୍‌ତାଂ ଆନ୍‌ ପଡ଼୍‌କ୍‌ ଇନାଙ୍ଗ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","ଇନାକା ଆୟେତ୍‌, ନେଞ୍ଜେଙ୍ଗ୍‌, ୱିଗା ଆରି ମାହିଙ୍ଗ୍ ନାଙ୍ଗେଙ୍ଗ୍‌ ହାଞ୍ଜେଙ୍ଗ୍‌ ଆନାତ୍‌, ଇନାକିଦେଂକି ଜିରୁସାଲମ୍‌ନି ବାର୍ତ ବେଣ୍‌ବାକ୍‌ଣାୟ୍‌କିନାକାର୍ ନାସ୍‌ ଆନାକା ହାର୍‌ ଆକାୟ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“ଏ ଜିରୁସାଲମ୍‌, ଏ ଜିରୁସାଲମ୍‌, ବେଣ୍‌ବାକ୍‌ଣାୟ୍‌ କିନାକାର୍‌ତି ଟୁଣାକାୟ୍ ଆରି ଜାର୍‌ ତାକେ ପକ୍ୟାତାକାରିଂ କାଲ୍ଅହିୟାନି । କୁଜ଼ୁ ଇନେସ୍‌ ମାରା ତାରେନ୍‌ ଜାର୍‌ ହିମ୍‌ଣାକାଂ ରବେ କିନାତ୍‌, ହେ ଲାକେ ଆନ୍‌ ଏଚେହଟ୍ ନି ହିମ୍‌ଣାକାଂ ରବେ କିଦେଙ୍ଗ୍‌ ମାନ୍‌ କିତାଙ୍ଗ୍‌, ମାତର୍‌ ଏପେଙ୍ଗ୍‌ ମାନ୍‌ କିୱାତାଦେର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","ହୁଡ଼ାଟ୍‌, ମି ଇଲ୍‌ ମି କେଇଦ ପିସ୍ତାତାର୍ଣ୍ଣା; ଆରେ ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ଇଞ୍ଜ୍‌ନାଙ୍ଗା, ମାପ୍ରୁ ତର୍‌ଦ ଇନେନ୍‌ ୱାନାନା, ହେୱାନ୍‌ ଦନ୍ୟ, ଏପେଙ୍ଗ୍‌ ଇମ୍‌ଣି ନାଜିଂ ଇ କାତା ଇନାଦେର୍‌, ହେ ଦିନ୍‍ୱାୱି ପାତେକ୍‌ ନାଙ୍ଗ୍‌ ହାତେନେ ଆରେ ହୁଡ଼୍‍ଦୁଦେର୍‍ ।” ");
INSERT INTO peg_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","ରଗ ଜିସୁ ଜମ୍‌ନିବାର୍‌ ନାଜିଂ ତିନି କାଜିଂ ର ପାରୁସିର୍‌ ମୁଣିକା ଇଞ୍ଜ ହଟିଲେ, ହେୱାର୍‌ ତାଙ୍ଗ୍‌ ଇଟ୍‌କାଡ଼୍‌ କିଜ଼ି ମାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","ଆରେ ହୁଡ଼ାଟ୍‌, ହେୱାନ୍‌ ମୁମ୍‌ଦ ରକାନ୍‌ କାଲ୍‌କୁ କେଇକୁ ପୁଲାଆତି ରଗ୍ୟା ନଚ୍‌ନି ମାନାୟ୍‌ ମାଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","ହେବେ ଜିସୁ ମସାତି ବିଦିନି ଗୁରୁର୍‌ ଆରି ପାରୁସିରିଂ ଉତର୍‌ ହିତାନ୍‌, “ଜମ୍‌ନିବାର୍‌ ନାଜିଂ ଉଜ୍‌ କିନାକା ବିଦି କି ଆକାୟ୍‌ ?” ମାତର୍‌ ହେୱାର୍‌ ଚିମ୍‌ରା ଆଜ଼ି ମାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","ଆରେ, ହେୱାନ୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ଆସ୍ତି ଉଜ୍‌ କିତାନ୍‌ ଆରି ପକ୍‌ତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","ଆରେ, ହେୱାନ୍‌ ହେୱାରିଂ ଇଚାନ୍‌, “ମି ବିତ୍ରେତାଂ ଇନେର୍‌ ଜାର୍‌ ହିମ୍‌ଣାଂ କି ବାଡ଼୍‌ଦୁ କୁଇତାକେ ଆର୍ତିସ୍‌ ଇନାକା ହେଦେଲିଂ ଜମ୍‌ନିବାର୍‌ ନାଜିଂ ହେ ଦାପ୍ରେ ନିକୁନ୍ ?” ");
INSERT INTO peg_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","ଆରେ, ହେୱାର୍‌ ଇ ୱିଜ଼ୁ ବେରଣ୍‌ତ ଇନାକା ଉତର୍‌ ହିଦେଂ ଆଡ୍‌ୱାତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","ଆରେ, କୁପ୍‌କାୟାତି ମାନାୟାର୍‌ ଇନେସ୍‌ ମୁଡ଼୍‌ ମୁଡ଼୍‌ ବାହା ବାଚି କିଜ଼ି ମାଚାର୍‌, ଇଦାଂ ଇଟ୍‌କାଡ଼୍‌ କିଜ଼ି ହେୱାନ୍‌ ହେୱାରିଂ ଇ ଉତର୍‌ମୁଡ଼୍‌ ହିଜ଼ି ଇଚାନ୍‌, ");
INSERT INTO peg_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“ଏଚେକାଡ଼୍‌ଦ ଏପେଙ୍ଗ୍‌ ଇମ୍‌ଣି ଲକୁତାଙ୍ଗ୍ ବିବାନି ବଜିତ କୁକ୍ୟାନାଦେର୍‌, ହେୱେଡ଼ାଂ ମୁଡ଼୍‌ ବାହାତ କୁଚ୍‍ମାଟ୍, କାତେହିନା ମିତାଙ୍ଗ୍ ଆଦିକ୍‌ ଗାଜାଲକୁ ହେୱାନ୍‌ତାଂ କୁକ୍ୟା ଆଜ଼ି ମାନ୍‌ଗାନାନ୍, ");
INSERT INTO peg_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","ଆରେ ଇନେର୍‌ ମିଙ୍ଗ୍‌ ଆରି ତାଙ୍ଗ୍‌ କୁକ୍‌ତାନ୍‌ଚି, ହେୱାନ୍‌ ୱାଜ଼ି ମିଙ୍ଗ୍‌ ଇଞ୍ଜାନାନ୍, ଇୱାନିଂ ବାହା ହିଆ; ଆରେ, ହେୱାଡ଼ାଂ ଏପେଙ୍ଗ୍‌ ଲାଜୁତାଂ ତାରେନ୍‌ ବାହାତ କୁଚ୍‌ଚେଂ ହାନାଦେର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","ମାତର୍‌ ଏଚେକାଡ଼୍‌ଦ ଏପେଙ୍ଗ୍‌ କୁକ୍ୟା ଆନାଦେର୍‌, ହେୱେଡ଼ାଂ ହାଲ୍‌ଜି ତାରେନ୍‍ନି ବାହାତ କୁଚାଟ୍, ଇନେସ୍‌ ମି କୁକ୍ୟାତି ଲକୁ ୱାଜ଼ି ମିଙ୍ଗେଙ୍ଗ୍‌ ଇଞ୍ଜାନାନ୍, ଏ ବନ୍ଦୁ, ଜପ୍‍ଣି ବାହାତ ୱା ଇଞ୍ଜ୍‌ନାନ୍‌, ହେୱାଡ଼ାଂ ମି ହୁକେ କୁଚ୍‌ଚି ମାନି ୱିଜ଼ାକାର୍‌ ମାନାୟାର୍‌ ମୁମ୍‌ଦ ମି ଜାଜ୍‌ମାଲ୍‌ ଆନାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","ଇନାକିଦେଂକି ଇନେର୍‌ ଜାର୍‌ତିଂ ଗାଜା ଇଞ୍ଜି ଚଞ୍ଜିୟାଆନାନ୍‌, ତାଙ୍ଗେଙ୍ଗ୍‌ ହାରୁ ଆନାନ୍‌, ଆରେ ଇନେର୍‌ ଜାର୍‌ତିଂ ହାରୁ ଆନାନ୍‌, ହେୱାନିଂ ଉଚ୍‌ କିୟାନାତ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","ଆରି, ଜିସୁ ନିଜେ କୁକ୍ୟାତି ଲଗାଂ ପା ଇଚାନ୍‌, “ୱେଡ଼ା କି ନାଣା ବଜି ହିଜ଼ି ଜାର୍‌ ବନ୍ଦୁ କି ଟଣ୍ଡେନ୍‌ କି ୱାସ୍କିନିକାର୍ କି ମାଜାନ୍‌ ପାଡ଼୍‍ହାନିକାରିଂ କୁକ୍‌କି କିମାଟ୍‌, କାତେହିନା ହେୱାର୍‌ ପା ୱାଜ଼ି ମିଙ୍ଗ୍ କୁକ୍‌କି କିଦ୍‌ନାର୍‌ ଆରି ଏପେଙ୍ଗ୍‌ ପ୍ରାତିପାଦ୍‌ ପାୟା ଆତାଦେର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","ମାତର୍‌ ବଜି ଜାଲ୍‌ଦି କିତିସ୍‌ ଅର୍କିତ୍‌, ଟୁଟା, ଚଟା ଆରି କାଣାରିଂ କୁପ୍‌କାଟ୍; ");
INSERT INTO peg_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","ତା ଆତିସ୍‌ ଏପେଙ୍ଗ୍‌ ଦନ୍ୟ ଆନାଦେର୍‌, ଇନେକିଦେଂକି ମିଙ୍ଗେଙ୍ଗ୍‌ ଆରେ ହିଦ୍‌ନି କାଜିଂ ହେୱାର୍‌ତି ଇନାକା ହିଲୁତ୍‌; ଆରେ, ଦାର୍ମିର୍‍ ଆରେ ନିଂନି ୱେଡ଼ାଲିଂ ମିଙ୍ଗେଙ୍ଗ୍‌ ଆରେ ହିଦ୍ୟାନାତ୍ ।” ");
INSERT INTO peg_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","ହେଦାଂ ୱେନ୍‌ଞ୍ଜି ଜିସୁହୁକେ ଚିଞ୍ଜେଙ୍ଗ୍‌ କୁଚ୍‌ଚି ମାନି ଲଗାଂ ବିତ୍ରେ ରକାନ୍‌ ହେୱାନିଂ ଇଚାନ୍‌, ଇମ୍‌ଣି ଲଗୁ “ଇସ୍ୱର୍ତି ରାଜିତ ତିନାନ୍‌, ହେୱାନ୍‌ ଦନ୍ୟ ।” ");
INSERT INTO peg_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","ମାତର୍‌ ଜିସୁ ତାଙ୍ଗେଙ୍ଗ୍‌ ଇଚାନ୍‌, “ରକାନ୍‌ ମାନାୟ୍‌ ମ୍ଡିକା ସମୁତ ଗାଜାବଜି ହିଦେଂ ଇଚା କିଜ଼ି ବେସି ଜାଣ୍‌ତିଂ କୁକ୍‌ତାନ୍‌; ");
INSERT INTO peg_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","ଆରେ, ତିନି ସମୁ ଏକାୱାତିଲେ, ହେୱାନ୍‌ କୁକ୍‍ତି ଲଗାଂ ଜାର୍‌ ଆଡ଼ିୟାତିଂ ପକ୍‌ଚି ଇଚାନ୍‌, ‘ଏପେଙ୍ଗ୍‌ ୱାଡୁ, ଇନାକିଦେଂ ୱିଜ଼ୁ ଜାଲ୍‌ଦି ଆତାତେ ।’ ");
INSERT INTO peg_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","ମାତର୍‌ ୱିଜ଼ାକାର୍‌ ର ମାନ୍‌ କିଜ଼ି କେମା ପାର୍ତାନା କିଦେଙ୍ଗ୍‌ ଲାଗାତାର୍‌ । ପର୍ତୁମ୍‌ ରକାନ୍‌ ତାଙ୍ଗ୍‌ ଇଚାନ୍‌, ଆନ୍‌ ଇଚୁଟିଂ ବୁମି କଡ଼୍‌ତାଂନ୍ନା, ନାଙ୍ଗ୍‌ ହେଦାଂ ହୁଡ଼୍‌ଦେଂ ଲାଗ୍‌ଦାନାତ୍‌; ଗୱାରି କିଦ୍‍ନାଙ୍ଗା, ଆନ୍‌ କେମା ପାୟା ଆତାଙ୍ଗ୍‌ନା ଇଞ୍ଜି ବାବି କିୟା ।” ");
INSERT INTO peg_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","ଆରେ ରକାନ୍‌ ଇଚାନ୍‌, “ଆନ୍‌ ପାଞ୍ଚ୍ ଆଡ଼୍‌ ବାଡ଼୍‌ଦୁଙ୍ଗ୍‌ କଡ଼୍‌ତାଂନ୍ନା, ଆରେ ଆନ୍‌ ହେୱାକାଂ ପରିକ୍ୟା କିଦେଙ୍ଗ୍‌ ହାନାଙ୍ଗା; ଗୱାରି କିଦ୍‍ନାଙ୍ଗା, ଆନ୍‌ କେମା ପାୟାଆତାଂନ୍ନା ଇଞ୍ଜି ବାବି କିୟା ।” ");
INSERT INTO peg_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","ବିନ୍‌ ଲଗୁ ଇଚାନ୍‌, “ଆନ୍‌ ପୁନ୍‌ ବିବା ଆତାଙ୍ଗ୍‌ନା, ଲାଗିଂ ହାଞ୍ଜେଙ୍ଗ୍‌ ଆଡୁଙ୍ଗା ।” ");
INSERT INTO peg_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","ଆରେ, ହେ ଆଡ଼ିଏନ୍‌ ୱାଜ଼ି ହେ ମାପ୍ରୁଙ୍ଗ୍‌ ହେ ସବୁ ୱେଚ୍‌ଚାନ୍‌ । ହେବେଣ୍ଡାଂ ଇଲ୍‌ ମୁଣିକା ରିସା ଆଜ଼ି ଜାର୍‌ ଆଡ଼ିଏନିଂ ଇଚାନ୍‌, “ବେଗି ଗାଡ଼୍‌ନି ହାକ୍‍ଡ଼ି ଆରି ଗଲିଗନ୍ଦିତ ହାଲ୍‌ଜି ଅର୍କିତ୍‌, ଟୁଟା, କାଣା ଆରି ଚଟାରିଂ ଇବେ ତାହିୱାଡୁ ।” ");
INSERT INTO peg_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","ପାଚେ ହେ, ଆଡ଼ିଏନ୍‌ ଇଚାନ୍‌, “ଏ ମାପ୍ରୁ, ନି ବଲ୍‌ତାଂ କିୟାଆତାଙ୍ଗ୍‍ନା, ଆତିସ୍‌ପା ଆରେ ବାହା ମାନାତ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","ହେବେତାଂ ମାପ୍ରୁ ହେ ଆଡ଼ିଏନିଂ ଇଚାନ୍‌, “ରାଜାର୍‌ ହାଜ଼ି ଆରି ଅଙ୍ଗୁର୍‌ ବାଡ଼୍‌ ମାର୍‌ତ ହାଲ୍‌ଜି, ନା ଇଲ୍‌ ଇନେସ୍‌କି ପୁରା ଆନାତ୍‌, ହେଦାଂ କାଜିଂ ମାନାୟାରିଂ ୱାନିକାଜିଂ ହିୟାଟ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","ଲାଗିଂ ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ଇଞ୍ଜ୍‌ନାଙ୍ଗା, ହେ କୁକ୍ୟା ଆଜ଼ି ମାନି ମାନାୟାରିଂ ପା ଇନେର୍‌ ନା ବଜିନି ଗୁଣ୍‌ ମଦୁର୍‌ ପାୟା ଆଉର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","ଦିନେକ୍‌ ବେସିହେନି ମାନାୟାର୍‌ ଜିସୁ ଲାହାଙ୍ଗ୍‌ ହାଲ୍‌ଜି ମାଚାର୍‌, ଆରେ ହେୱାନ୍‌ ଲେଉଟା ଆଜ଼ି ହେୱାରିଂ ଇଚାନ୍‌, ");
INSERT INTO peg_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“ଇନେର୍‌ ଜଦି ନା କଚଣ୍‌ ୱାଜ଼ି ଜାର୍‌ ଆବା, ଆୟା, ଡକ୍ରି, ହିମ୍‍ଣା, ଟଣ୍ଡେନ୍‌ ଆରି ତଣ୍‌ଦେକାଂ, ଇ ଲାକେ ଜାର୍‌ ଜିବୁନ୍‌ତିଂ ପା ଆଦିକ୍‌ ୱାରି କିୱିତିସ୍‌, ଲାଗିଂ ହେୱାନ୍‌ ନା ଚେଲା ଆଦେଂ ଆଡୁନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","ଇନେର୍‌ ଜାର୍‌ତି କ୍ରୁସ୍‌ ପିଣ୍ଡ୍‌ଜି ନା ଡେଇଁ ୱାୱାତାନ୍‌ଚି, ହେୱାନ୍‌ ନା ଚେଲା ଆଦେଂ ଆଡୁନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","ଇନାକିଦେଂକି ମିଙ୍ଗେଙ୍ଗ୍‌ ବିତ୍ରେ ଇନେର୍‌ ମାଚା ରସ୍‍ତେଂ ଇଚା କିଜ଼ି ହେଦାଂ ୱିସ୍‌ପିସ୍‌ କିନାକା ଡାବୁଙ୍ଗ୍‌ ସାକ୍ତି ମାନାତ୍‌ କି ଆକାୟ୍‌, ଇଦାଂ ପର୍ତୁମ୍‌ କୁଚ୍‌ଚି କର୍ଚ ଇସାବ୍‌ ହୁଡ଼ୁଦେର୍ ? ");
INSERT INTO peg_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","ହେ ଦିନ୍ତ ହେୱାନ୍‌ କୁନାଦି କୁଚି କିଜ଼ି ୱିସ୍ତେଙ୍ଗ୍‌ ଆଡ୍‌ୱିତିସ୍‌, ଏଚେଜାଣ୍‌ ହେଦାଂ ହୁଡ଼୍‌ନାର୍‌ ୱିଜ଼ାର୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ଗ୍ଡାଇଦେଂ ଲାଗାନାର୍‌, ");
INSERT INTO peg_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","ଇ ମାନାୟ୍‌ ରଚ୍‌ଚେଂ ଆରାମ୍‌ କିଜ଼ି ୱିସ୍ତେଙ୍ଗ୍ ଆଡ୍‌ୱାତାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“ମାତର୍‌ ଇମ୍‌ଣି ରାଜା ଦସହାଜାର୍‌ ମେଲ୍ୟାରିଂ ଅଜ଼ି ବିନେ ରକାନ୍‌ ରାଜା ଲାହାଙ୍ଗ୍‌ ଜୁଜ୍‌ କିଦେଙ୍ଗ୍‌ ହାନି ୱେଡ଼ାଲିଂ, କଡ଼େ ହାଜାର୍ ମେଲ୍ୟାର୍‌ ଆସ୍ତି ବିରୁଦ୍‌ତ ୱାଜ଼ିମାନି ରାଜା ଲାହାଙ୍ଗ୍‌ ଦସ୍‌ ହାଜାର୍‌ ମେଲ୍ୟାର୍‌ ଅଜ଼ି ଜୁଜ୍‌ କିଦେଙ୍ଗ୍‌ ଆଡ଼୍‌ନାଦେରା କି ଆକାୟ୍‌, ହେଦାଂ ପର୍ତୁମ୍‌ କୁଚ୍‌ଚି ବିଚାର୍‌ କିଉର୍‌ ? ");
INSERT INTO peg_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","ଜଦି ଆଡୁନ୍‌, ଲାଗିଂ ବିନେନି ରାଜା ଦେହା ମାନୁ ମାନୁ ହେୱାନ୍‌ ଦୁତ୍‌ ପକ୍‌ଚି ହାନ୍ଦି ପାର୍ତାନା କିନାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","ହେ ଲାକେ ମିଙ୍ଗେଙ୍ଗ୍‌ ବିତ୍ରେ ଇନେର୍‌ ଜାର୍‌ତି ୱିଜ଼ୁ ପିହ୍‌ୱିତିସ୍‌, ହେୱାନ୍‌ ନା ଚେଲା ଆଦେଂ ଆଡୁନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“ହର୍‌ତ ହାର୍‌; ମାତର୍‌ ହର୍‌ ପା ଜଦି ହୱାଦ୍‌ ଆଉତ୍‌, ବାଟିଙ୍ଗ୍‌ ହେଦାଂ ଇମେ କାର୍ୟା ଆନାତ୍‌ ? ");
INSERT INTO peg_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","ହେଦାଂ ମେଦ୍‌ନିତ କି ଗାତ୍‍ଗାଦା କାଜିଂ ସମାନ୍‌ ଆକାୟ୍‌; ଲକୁ ହେଦାଂ ବାର୍ତ ତୁସି ହିନାର୍‌ । ଇନେର୍‌ ୱେଞ୍ଜେଙ୍ଗ୍‌ କିତୁଲ୍‌ ମାନାତ୍‌, ହେୱାନ୍‌ ୱେନେନ୍‍ ।” ");
INSERT INTO peg_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","ଆରେ, ଦିନେକ୍‌ ସିସ୍ତୁଏନ୍‌ନାକାର୍‌ ଆରି ପାପିୟାର୍‌ ୱିଜ଼ାକାର୍‌ ହେୱାନ୍‌ ବଚନ୍‌ ୱେଞ୍ଜେଙ୍ଗ୍‌ କାଜିଂ ହେୱାନ୍‌ ତାକେ ୱାଜ଼ି ମାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","ହେବେ ପାରୁସିର୍‌ ଆରି ସାସ୍ତିର୍‌ ଗାଣ୍‌ଜୁ କିଜ଼ି କିଜ଼ି ଇଚାର୍‌, “ଇୱାନ୍‌ ରକାନ୍‌ ପାପିୟାରିଂ ଇଟ୍‌ନାନ୍‌ ଆରି ହେୱାର୍‌ ହୁକେ ତିନାନ୍‌ !” ");
INSERT INTO peg_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","ହେବେ ହେୱାନ୍‌ ହେୱାରିଂ ଇ ଉତର୍‌ମୁଡ଼୍‌ ୱେଚ୍‌ଚାନ୍‌, ");
INSERT INTO peg_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“ମି ବିତ୍ରେ ଏପେଙ୍ଗ୍‌ ଇମ୍‌ଣି ମାନାୟ୍‌ ମାନାନ୍‌ ଜେ ହେୱାନ୍ତି ପାଞ୍ଚକଡ଼ି ମେଣ୍ଡାଂ ମାଚିସ୍‌, ଆରେ ହେୱାଙ୍ଗ୍‌ ବିତ୍ରେ ରଞ୍ଜାଙ୍ଗ୍‌ ଜାଙ୍ଗ୍‌ତିସ୍‌, ଲାଗିଂ ହେ ଏକ୍‌ ଉଣା ପାଞ୍ଚ୍‌କଡ଼ିକାଙ୍ଗ୍‌ ବାଟାତ ପିସ୍ତି ହେ ଜାଙ୍ଗ୍‌ତି ମେଣ୍ଡା ଗାଟାୱି ପାତେକ୍‌ ହେଦେଲିଂ ଡେକୁନ୍‌ ? ");
INSERT INTO peg_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","ଆରେ, ଗାଟାଆତିସ୍ ହେୱାନ୍‌ ହେଦେଲିଂ ୱାରିତାଂ ପିଣ୍ଡ୍‌ଜି ଇଞ୍ଜ ତାହିୱାନାନ୍, ");
INSERT INTO peg_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","ଆରେ ଜାର୍‌ ସାଙ୍ଗ ପାଡ଼୍‍ହା ଇଞ୍ଜାକାରିଂ ରବେରୁଣ୍ତାୟ୍‍ କିଜ଼ି ହେୱାରିଂ ଇନାନ୍‌, ନା ହୁକେ ୱାରି କିୟାଟ୍‌, ଲାଗିଂ ନା ଜାଙ୍ଗ୍‌ତି ମେଣ୍ଡା ଗାଟାତାଙ୍ଗ୍ । ");
INSERT INTO peg_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","ଆନ୍‌ ମିଙ୍ଗ୍‌ ଇଞ୍ଜ୍‌ନାଙ୍ଗା, ହେ ଲାକେ ଇନେର୍‌ତି ମାନ୍‌ବାଦ୍‌ଲାୟ୍‌ କିନି ଲଡ଼ା ଆକାୟ୍‌, ଏଲେଙ୍ଗ୍‌ ଏକଉଣା ପାଞ୍ଚ୍‌କଡ଼ି ଦାର୍ମି ମାନାୟାରିଂ ପିସ୍ତି, ଇନେନ୍‌ ମାନ୍‌ ବାଦ୍‌ଲାୟ୍‌ କିନାନ୍‌, ଏଲେଙ୍ଗ୍‌ ରକାନ୍‌ ପାପ୍‌ନି କାଜିଂ ସାର୍ଗେତ ବେସି ୱାରି ଆନାତ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“ଆୱିତିସ୍‌ ଏଲେଙ୍ଗ୍‌ ଇମ୍‌ଣି କଗ୍‌ଲେଲଗୁ ମାନାତ୍‌ ଜେ, ତାୱି ଜଦି ଦସ୍‌ ରୁପା ଡାବୁଙ୍ଗ୍‌ ମାଚିସ୍‌, ଆରେ ହେବେଣ୍ଡାଂ ରଞ୍ଜୁ ଜାଙ୍ଗ୍‌ତିସ୍‌, ଲାଗିଂ ହେଦେଲ୍‌ ବଇଟା ଆହି କିଜ଼ି ଇଲ୍‌ ପାପ୍‍ଡ଼ି କିଜ଼ି ଗାଟାୱି ପାତେକ୍‌ ଜତନ୍‌ତାଂ ଡେକୁତ୍ ? ");
INSERT INTO peg_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","ଆରେ, ହେଦାଂ ଗାଟାଆତିସ୍ ହେଦେଲ୍‌ ହେ ହାଙ୍ଗ୍‌ଦାକାରିଂ ଆରି ପାଡ଼୍‍ହା ଇଞ୍ଜି ଲଗାଂ କୁକ୍‌ଚି ରୁଣ୍ଡାୟ୍‌ କିଜ଼ି ଇନାତ୍‌, ନା ହୁକେ ୱାରି କିୟାଟ୍‌, ଲାଗିଂ ଇମ୍‌ଣି ଟାକା ଜାକ୍‍ଚି ମାଚାଙ୍ଗ୍‌, ହେଦାଂ ଗାଟାଆତାଙ୍ଗ୍ । ");
INSERT INTO peg_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍ ଇଞ୍ଜ୍‌ନାଙ୍ଗା, ହେ ଲାକେ ଇନେର୍‌ ମାନ୍‌ବାଦ୍‌ଲାୟ୍‌ କିତାର୍‌, ଏଲେଙ୍ଗ୍‌ବାର୍ତି ପାପି କାଜିଂ ଇସ୍ୱର୍ତି ଦୁତ୍‌ର୍‌ ମୁମ୍‌ଦ ୱାର୍‌ୟା ଆଡୁ ।” ");
INSERT INTO peg_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","ଜିସୁ ଆରେ ଇଚାନ୍‌, “ରୱାନିଂ ରିକାର୍‌ ମାଜ଼ି ମାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","ହେୱାର୍‌ ବିତ୍ରେ ହାରୁ ମାଜ଼ି ଇଚାନ୍‌, ଆବା, ଦାନ୍‌ ଇମ୍‌ଣି ବାଗ୍‌ ନାଦାଂ ଆନାତା, ହେଦାଂ ନାଙ୍ଗ୍‌ ହିଦା ।” ହେବେଣ୍ଡାଂ ହେୱାନ୍‌ ୱିଜ଼ୁ ପାସ୍‌ପିସ୍ ହିତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","ଅଲପ୍‍ ଦିନ୍‌ ପାଚେ ହାରୁ କାଡ଼୍‌ଦେ ସବୁ ରବେ ରୁଣ୍ଡାୟ୍‌ କିଜ଼ି ରାଜି ହତାନ୍, ଆରେ ହେବେ ପାଟ୍‍କାର୍ ଆଜ଼ି ହେ ଦାନ୍‌ ଉପ୍ତାନ୍ । ");
INSERT INTO peg_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","ମାତର୍‌ ୱିଜ଼ୁ ଉପ୍‍ଚି ପାଚେ ଦେସ୍‍ତାକେ କାତାର୍‌ ଆର୍ତିଲେ ତା ଅବାବ୍‌ ଆଦେଂ ଲାଗାତାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","ହେବେଣ୍ଡାଂ ହେୱାନ୍‌ ହାଲ୍‌ଜି ହେ ଦେସ୍‌ନି ରକାନ୍‌ ଲକୁତାକେ ଆହ୍‌ର ଅତାନ୍‌, ଆରେ ହେୱାନ୍‌ ତାଙ୍ଗ୍‌ ପାଞ୍ଜିଙ୍ଗ୍ ହାରାୟ୍‌ କିଦେଂ ଜମିତ ପକ୍‌ତାନ୍‌; ");
INSERT INTO peg_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","ଆରେ ପାଞ୍ଜିଙ୍ଗ୍ କାଦି ତିନ୍‍ଞ୍ଜି ମାଚିକ୍‌, ହେବେ ହେୱାନ୍‌ ତା ପଟପାଞ୍ଜି ଜିଜ଼ି ମାଚାନ୍‌, ମାତର୍‌ ଇନେର୍‌ ହେୱାନିଂ ଇନାକା ହିୱାଦାଂ ମାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","ମତର୍‌ ହେୱାନ୍‌ ଚେତ୍‌ନା ଆଜ଼ି ଇଚାନ୍‌, “ମାଞ୍ଜି ଆବା ତାକେ କେତେକ୍‌ କାମ୍‌ଲିୟାର୍ତି କାଦି ହାର୍ଜିହାନାତା, ମାତର୍‌ ଆନ୍‌ ଇବେ ନାସ୍‌କି ହାନାଙ୍ଗା । ");
INSERT INTO peg_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","ଆନ୍‌ ନିଙ୍ଗ୍‌ଜି ନା ସାର୍ଗେନି ଆବା ଲାଗେ ହାନାଙ୍ଗ୍” ଆରି ତାଙ୍ଗ୍‌ ଇନାଙ୍ଗ୍‌, “ଆବା, ଇସ୍ୱର୍ତି ବିରୁଦ୍‌ତ ଆରି ନି ନଞ୍ଜର୍‌ତ ପାପ୍‌ କିତାଙ୍ଗ୍‌ନା; ");
INSERT INTO peg_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","ନି ମାଜ଼ି ଇଞ୍ଜି କୁକ୍ୟା ଆଦେଂ ଆନ୍‌ ଆରେ ତର୍‌ ହିଲେତ୍; ନାଙ୍ଗ୍‌ ମି କାମ୍‌ଲିୟାର୍‌ ଲାକେ ଇଡ୍‍ଦା ।” ");
INSERT INTO peg_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","ହେବେଣ୍ଡାଂ ହେୱାନ୍‌ ନିଙ୍ଗ୍‌ଜି ନିଜେ ଲାତ୍ରାହି ତାକେ ହାଚାନ୍‌ । “ମାତର୍‌ ହେୱାନ୍‌ ଦେହା ମାନୁ ମାନୁ ହେ ଲାତ୍ରାହି ତାଙ୍ଗ୍‌ ହୁଡ଼୍‌ଜି ଦୟାତ କାର୍ମା ଆତାନ୍‌ ଆରି ହନ୍‌ଚିହାଲ୍‌ଜି ହେୱାନିଂ ପମ୍‌ଜି ଡନ୍‍ଚାନ୍ ।” ");
INSERT INTO peg_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","କାଡ଼୍‌ଦେ ତାଙ୍ଗେଙ୍ଗ୍‌ ଇଚାନ୍‌, “ଆବା, ସାର୍ଗେନି ବିରୁଦ୍‌ତ ଆରି ନି ନଞ୍ଜର୍‌ତ ଆନ୍‌ ପାପ୍‌ କିତାଙ୍ଗ୍‌, ନି ମାଜ଼ି ଇଞ୍ଜି କୁକ୍ୟାନି ଆନ୍‌ ତର୍‌ ଆକାୟ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","ମାତର୍‌ ଲାତ୍ରାହି ହେ ଆଡ଼ିୟାରିଂ ଇଚାନ୍‌, “ୱିଜ଼ୁତିଂ ହାର୍ଦି ଆଙ୍ଗି ବେଗି ତାହିୱାଜ଼ି ଇୱାନିଂ ଆର୍‌ପି କିୟାଟ୍‌, ଇୱାନ୍‌ କେଇଦ ୱାତୁସ୍‌ ଆରି ପାନାତ ପାଣ୍ଡାଇଙ୍ଗ୍ ହିୟାଟ୍‍, ");
INSERT INTO peg_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","ଆରେ ଦୁମାଟି ଅହ୍‌ରି ତାସି ଅହାଟ୍‌; ୱାଡୁ ଆସେଙ୍ଗ୍‌ ତିନ୍‌ଞ୍ଜି ୱାରି କିନାସ୍‌, ");
INSERT INTO peg_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","ଇନାକିଦେଂକି ନା ଇ ହିମ୍‍ଣା ହାଜ଼ି ମାଚାନ୍‌, ଆରେ ଜିତାନ୍ନା, ଜାଙ୍ଗ୍‌ଜି ମାଚାନ୍‌, ଆରେ ଗାଟାଆତାନ୍‌ ।” ହେବେଣ୍ଡାଂ ହେୱାର୍‌ ୱାରି କିଦେଙ୍ଗ୍‌ ଲାଗାତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“ଏଚେକାଡ଼୍‌ଦ ତା ଗାଜାକାନ୍‌ ମେହି ତାସ୍‌ ବାହାତ ମାଚାନ୍‌ । ହେୱାନ୍‌ ଏଚେକାଡ଼୍‌ଦ ୱାଜ଼ି ଇଲ୍‌ ଲାଗେ ଏକାୱାତାନ୍‌, ହେୱାଡ଼ାଂ ବାଜା ଆରି ଏନ୍ଦିନି ଗାଜ୍ରାନାକା ୱେନ୍‌ଞ୍ଜି, ");
INSERT INTO peg_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","ଆଡ଼ିୟାରିଂ ବିତ୍ରେ ରୱାନିଂ ଲାଗେ କୁକ୍‌ଚି ହେ ସବୁ ଇନାକା ଇଞ୍ଜି ୱେନ୍‌ବେଦେଂ ଲାଗାତାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","ହେୱାନ୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ଇଚାନ୍‌, “ନି ଟଣ୍ଡେନ୍‌ ୱାତାନ୍ନା, ଆରେ ମି ଆବା ହେୱାନିଂ ହାର୍‌ଦି ଗାଗାଡ଼୍‌ତ ଗାଟା ଆତିଲେ ଦୁମାଟି ଅହ୍‌ରି ଅସ୍ତାନ୍ନା ।” ");
INSERT INTO peg_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","ହେବେତାଂ ହେୱାନ୍‌ ରିସା ଆଜ଼ି ବିତ୍ରେ ହାଞ୍ଜେଙ୍ଗ୍‌ ମାନ୍‌ କିୱାତାନ୍‌, ମାତର୍‌ ହେ ଲାତ୍ରାହି ବାର୍ତୱାଜ଼ି ତାଙ୍ଗେଙ୍ଗ୍‌ ବେସି ଗୱାରି କିଦେଙ୍ଗ୍‌ ଲାଗାତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","ମତର୍‌ ହେୱାନ୍‌ ଆବାଂ ଉତର୍‌ ହିତାନ୍‌, ହୁଡ଼ା ଏଚେକ୍‌ ବାର୍ହୁ ଆତାତ୍‌ ଆନ୍‌ ନିଙ୍ଗେଙ୍ଗ୍‌ ଆଡ଼ିଏନ୍‌ ଲାକେ କାମାୟ୍‌ କିଜ଼ି ୱାନାଙ୍ଗା, ଆରେ ଇନାୱାଡ଼ାଂ ପାନି ବଲ୍‌ ଉଡ଼ା ଆୱାତାଂନା, ଆତିସ୍‌ପା ନା ହାଙ୍ଗ୍‌ଦାକାର୍‌ ହୁକେ ୱାରି କିଦେଙ୍ଗ୍‌ ଏନ୍‌ ନାଙ୍ଗେଙ୍ଗ୍‌ ଇନାୱାଡ଼ାଂପା ଅଡା ହିମ୍‌ଣା ରଞ୍ଜାଙ୍ଗ୍‌ ହିଦ୍‍ୱାତାୟ୍‍ନ୍ନା; ");
INSERT INTO peg_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","ମାତର୍‌ ନି ଇ ଇମ୍‌ଣି କାଡ଼୍‌ଦେ ଦାରିୟାର୍‌ ହୁକେ ନିନ୍ଦାଂ ୱିଜ଼ୁ ଦାନ୍‌ ତିନ୍‌ଞ୍ଜି ଉପ୍ତାନ୍ନା, ଏଚେକାଡ଼୍‌ଦ ହେୱାନ୍‌ ୱାତାନ୍, ହେ ଏଚେକାଡ଼୍‌ଦ ଏନ୍‌ ହେଦାଂ କାଜିଂ ଦୁମା ଅହ୍‌ରି ଅସ୍ତାୟ୍ । ");
INSERT INTO peg_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","ହେବେଣ୍ଡାଂ ହେୱାନ୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ଇଚାନ୍‌, “ବପାହୟ୍‌, ଏନେଙ୍ଗ୍‌ତ ସବୁୱେଡ଼ାଙ୍ଗ୍‌ ନା ହୁକେ ମାନାୟା, ଆରେ ଇନାକା ସବୁ ନାଦାଂ, ହେ ସବୁ ନିନ୍ଦାଂ; ");
INSERT INTO peg_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","ମାତର୍‌ ଇୱାନ୍‌ ଜେ ନି ଟଣ୍ଡେନ୍‌ ହାଜ଼ି ମାଚାନ୍‌, ଆରେ ରଗ ଜିତାନ୍‌, ଜାଙ୍ଗ୍‌ଜି ମାଚାନ୍‌, ଆରେ ଗାଟାଆତ୍‍ତାନ୍‌, ହେଦାଂ କାଜିଂ ବଜି ଆରି ୱାରି କିନାକା ମାଚାତ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","ଜିସୁ ଚେଲାରିଂ ପା ଇଚାନ୍‌, “ର ମାଜାନ୍‌ ମାନାୟ୍‌ ମାଚାନ୍‌, ତାଙ୍ଗେଙ୍ଗ୍‌ ରକାନ୍‌ ଗୁମୁସ୍ତା ମାଚାନ୍‌, ଆରେ ହେୱାନ୍‌ ହେ ଦାନ୍‌ କାରାପ୍‌ କିନାନା ଇଞ୍ଜି ହେଦାଂ ବିସ୍ରେ ୱେନ୍‌ଞ୍ଜି ହେୱାନ୍‌ ହେୱେନିଂ ହିର୍‌ବିସ୍‌ ଇଚାନ୍‌, ");
INSERT INTO peg_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","ଆନ୍‌ ମି ବିସ୍ରେ ଇଦାଂ କି କାତା ୱେନାଙ୍ଗା ?” ନି ଗୁମୁସ୍ତା କାମାୟ୍‌ ନି ଇସାବ୍‌ ହିଦା ଇନେକିଦେଂ ଏନ୍‌ ଆରି ଗୁମୁସ୍ତା ଆଜ଼ି ମାଞ୍ଜେଙ୍ଗ୍‌ ଆଡୁୟ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","ହେବେତାଂ ହେ ଗୁମୁସ୍ତା ମାନେ ମାନେ ଇଚାନ୍‌, ଇନାକା କିନାଙ୍ଗ୍‌ ? ନା ମାପ୍ରୁ ତ ନା ତାକେଣ୍ଡାଂ ଗୁମୁସ୍ତା ପାଦ୍‌ ପିହି କିଜ଼ି ଅନାନା । ଚିକ୍‌ଲା କାଦ୍‌ଦେଂ ନା ସାକ୍ତି ହିଲୁତ୍‌, ଇସ୍‍ପିସ୍‍ ଚିଞ୍ଜେଙ୍ଗ୍‌ ନାଙ୍ଗେଙ୍ଗ୍‌ ଲାଜୁ ହତ୍‍ନାତା । ");
INSERT INTO peg_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","ଆନ୍‌ ଗୁମୁସ୍ତା ପାଦ୍‍ତାଙ୍ଗ୍ ପିସ୍ତି ପାଚେ ଲକୁ ଇନେସ୍‌କି ନାଙ୍ଗେଙ୍ଗ୍‌ ଜାର୍‌ ଜାର୍‌ ଇଞ୍ଜ ମାନ୍‌କିଦ୍‌ନାର୍‌, ଇଦାଂ କାଜିଂ ଇନାକା କିନାଙ୍ଗ୍‌, ହେଦାଂ ବୁଜା ଆନାଙ୍ଗା । ");
INSERT INTO peg_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","ଆରି, ହେୱାନ୍‌ ଜାର୍‌ ମାପ୍ରୁତି ୱିଜ଼ାକାରିଂ କାତକ୍‌ତିଂ ଲାଗେ ହିର୍‌ବିସ୍‌ ପର୍ତୁମ୍‌ ରକାନିଂ ଇଚାନ୍‌, “ମି ଜପି ନାମାପ୍ରୁତି ରୁଣ୍‌ ଅତାୟ୍‌ନା ? ଏଚେକ୍‌ ଚିକାଣ୍‌ ? ହେୱାନ୍‌ ଇଚାନ୍‌, ପାଞ୍ଚ୍‌କଡ଼ି ମାଣ୍‌ ଚିକାଣ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","ହେୱାନ୍‌ ଇଚାନ୍‌, “ସହେ ସିପା ଚିକାଣ୍‌ । ବେବାର୍‌ କିନାକାନ୍‌ ଇଚାନ୍‌, ଇଦାଂ ନି କାଗଜ୍‌, ଇବେ ପଚାସ୍‌ ଇଞ୍ଜି ଲେକିକିୟା । ");
INSERT INTO peg_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","ତା ପାଚେ ହେୱାନ୍‌ ଆରେ ରକାନିଂ ଇଚାନ୍‌, ଏନ୍‌ ଏଚେକ୍‌ ରୁଣ୍‌ ଅତାୟ୍‌ନା ?” ହେୱାନ୍‌ ଇଚାନ୍‌, “ପାଞ୍ଚ୍‌କଡ଼ି ମାଣ୍‌ ଗଁମ୍‌ । ହେୱାନ୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ଇଚାନ୍‌, ମି ଲେକିକିତି କାଗଜ୍ ଆସ୍ତି ଚାର୍‌କଡ଼ି ଇଞ୍ଜି ଲେକି କିୟା ।” ");
INSERT INTO peg_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","ହେ ଅଦାର୍ମି ଗୁମୁସ୍ତା ବୁଦି ଲାହାଙ୍ଗ୍‌ କାମାୟ୍‌ କିଜ଼ିମାନି କାଜିଂ ମାପ୍ରୁ ତାଙ୍ଗେଙ୍ଗ୍‌ ପାର୍ତାନା କିତାନ୍‌, ଲାଗିଂ ଇ ଜୁଗ୍‌ନି ହିମ୍‌ଣାଂ ହେୱାର୍‌ ନିଜାର୍‌ ଜାତି ପାକ୍ୟାତ ଅଜଡ଼୍‌ନି ହିମ୍‌ଣାଙ୍ଗ୍‌ ବାଟା ଆଦିକ୍‌ ବୁଦିତି । ");
INSERT INTO peg_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","ଆନ୍‌ ପା ମିଙ୍ଗେଙ୍ଗ୍‌ ୱେଚାନାଙ୍ଗା, “ଅଦାର୍ମି ଦାନ୍‌ ଜାର୍‌ ଜାର୍‌ କାଜିଂ ସାଙ୍ଗ ଲାବ୍‌ କିୟା, ଇନେସ୍‌ ହେଦାଂ ୱିସ୍ତିସ୍‌ ହେୱାର୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ୱିଜ଼୍‌ୱି ଇଞ୍ଜ ମାନ୍‌ କିୟାଆନାଦେର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","ଇନେନ୍‌ ଅଲପ୍‍ ବିସ୍ରେ ପାର୍ତି କିନାକାନ୍‌, ହେୱାନ୍‌ ଆଦିକ୍‌ ବିସ୍ରେ ପା ପାର୍ତି ଆନାନ୍‌, ଆରେ ଇନେର୍‌ ଆଦିକ୍‌ ବିସ୍ରେ ପାର୍ତି କିୱାକାନ୍ ହେୱାନ୍‌ ଆଦିକ୍‌ ବିସ୍ରେ ପା ପାର୍ତି କିଉନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","ଜଦି ଏପେଙ୍ଗ୍‌ ଅଦାର୍ମି ଦାନ୍‌ତ ପାର୍ତି ଆୱାତାଦେର୍‌, ଲାଗିଂ ଇନେର୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ପାର୍ତି କିଜ଼ି ହାତ୍‌ପା ଦାନ୍‌ ମି କେଇଦ ସର୍‌ପି କିଦ୍‌ନାନ୍‌ ? ");
INSERT INTO peg_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","ଆରେ, ଜଦି ଏପେଙ୍ଗ୍‌ ପାଚେନି ଦାନ୍‌ ବିସ୍ରେ ପାର୍ତି ଆୱାତାୟ୍‌ନା, ଲାଗିଂ ଇନେର୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ମି ଜାର୍‌ ବିସ୍ରେ ହିଦ୍‍ନାର୍‌ ?” ");
INSERT INTO peg_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“ଇମ୍‌ଣି ଆଡ଼ିୟା ରି ମାପ୍ରୁଙ୍ଗ୍‌ ହଲ୍ୟା ଆଦେଂ ଆଡୁନ୍‌; ଇନାକିଦେଂକି ହେୱାନ୍‌ ରକାନିଂ ଗିଣ୍‌ କିନାନ୍‌ ଆରି ବିନ୍‌ ଲଗାଂ ଜିଉନନାନ୍‌, ଲାଗିଂ ରକାନ୍‌ କାଜିଂ କାର୍ମା ଆନାନ୍‌ ଆରି ବିନ୍‌ ରକାନିଂ ଆଲ୍‌ଗା କିନାନ୍‌ । ଏପେଙ୍ଗ୍‌ ଇସ୍ୱର୍‌ ଦାନ୍‌ ରିୟାର୍‌ତି ଆଡ଼ିଏନ୍‌ ଆଦେଂ ଆଡୁନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","ଇ କାତା ୱେନ୍‌ଞ୍ଜି ଦାନ୍‌ଲବ୍‌ ପାରୁସିର୍‌ ପା ଜିସୁଙ୍ଗ୍‌ ନିନ୍ଦାକିଦେଂ ଲାଗାତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","ହେବେତାଂ ହେୱାନ୍‌ ହେୱାରିଂ ଇଚାନ୍‌, “ଇମ୍‌ଣାକାର୍‌ ଜାର୍‌ ଜାର୍‌ତିଂ ମାନାୟାର୍‌ କାଣ୍‌କୁକାଂ ଦାର୍ମି ଇଞ୍ଜି ଚଚ୍‌ନାର୍‌, ଏପେଙ୍ଗ୍‌ ହେ ଲାଗ୍‌ଦି ମାନାୟ୍‌, ମାତର୍‌ ଇସ୍ୱର୍‌ ମିଦାଙ୍ଗ୍‌ ମାନ୍‌ ପୁନାନ୍‌; ଇନେକିଦେଂକି ଇନାକା ମାନାୟାର୍‌ ବିତ୍ରେ ଗାଜାଟି, ହେଦାଂ ମାପ୍ରୁ କାଣ୍‌ଙ୍ଗାତ ଗିଣ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","ମସାତି ବିଦି ଆରେ ବେଣ୍‌ବାକ୍‌ଣାୟ୍‌କିନାକାର୍‌ ଦରମ୍‌ ସାସ୍ତର୍‌ ଜହନ୍‌ ପାତେକ୍‌ ହସିମାଚାତ୍ ହେ ସମୁତାଂ ସାର୍ଗେ ରାଜିନି ନେକ୍ରିକାବୁର୍‌ ସୁଣାୟ୍‌କିଦେଂ ଆନାତା, ଆରେ ୱିଜ଼ାର୍‌ ଲକ୍‌ ସାକ୍ତିତାଂ ହେବେ ହଣାରା । ");
INSERT INTO peg_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","ମାତର୍‌ ମସାତି ବିଦିନି ର ଟପା ବୁଡାଆନି ବାଟା ମତର୍‌ ବାଦାଡ଼୍‌ ଆରି ପୁର୍ତି ବୁଡାନାକା ଆଡ଼୍‌ୱା ।” ");
INSERT INTO peg_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“ଇନେର୍‌କି ଜାର୍‌ ଡକ୍ରିଂ ପିସ୍ତି ଆରେ ରଞ୍ଜେଲିଂ ବିବା ଆନାନ୍‌, ହେୱାନ୍‌ ଦାରି କିନାନ୍‌; ଆରି, ଇନେର୍‌ ଆଣ୍ଡ୍ରେନ୍‌ କାଜିଂ ପିସ୍‌ସି ଡକ୍ରିଂ ବିବା ଆନାନ୍‌, ହେୱାନ୍‌ ଦାରି କିନାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“ର ମାଜାନ୍‌ ମାନାୟ୍‌ ମାଚାନ୍‌, ହେୱାନ୍‌ ମଲ୍‌ନି ହେନ୍ଦ୍ରା ଆର୍ପିସ୍‌ ବେସି ବିୱାହିଂ ୱିଜ଼ୁଦିନ୍ ତିନ୍‌ଞ୍ଜି ଉଣ୍‌ଜି ମାଚାନ୍‌; ");
INSERT INTO peg_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","ମାତର୍‌ ତା ଦୁୱେର୍‌ କଚଣ୍‌ ଲାଜାର୍‌ ଇଞ୍ଜି ରୱାନ୍‌ ବିକାରି ମାନାୟ୍‌ ଗୁର୍‌ଜି ମାଚାନ୍‌, ତା ଗାଗାଡ଼୍‌ତ ଗାଅ ବାର୍ତି ଆଜ଼ି ମାଚାତ୍‌; ");
INSERT INTO peg_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","ଲାଜାର୍‌ ହେ ମାଜାନ୍‌ ମାନାୟ୍‌ ଟେବୁଲ୍‌ତାଂ ଆର୍‍ନି ଜୁଟା ତିନ୍‌ଞ୍ଜି ପଟ ପାଞ୍ଜିକିଦେଂ ଆହା କିଜ଼ି ମାଚାନ୍‌; ଆରେ ନିକୁଡ଼ିଂ ପା ୱାଜ଼ି ହେ ଗାଅ ୱିଜ଼ୁ ନାଙ୍ଗ୍‍ଞ୍ଜି ମାଚିଙ୍ଗ୍ । ");
INSERT INTO peg_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","ଦିନେକ୍‌ ହେ ବିକାରି ହାତାନ୍‌ ଆରି ଦୁତ୍‌ର୍‌ କାଜିଂ ଅବ୍ରାହାମ୍‌ ତାକେ ଡ୍ରକ୍ୟାଆତାନ୍; ପାଚେ ହେ ମାଜାନ୍‌ ମାନାୟ୍‌ ପା ହାତାନ୍‌ ଆରେ ଦୁଗେର୍‌ତ ମୁଚ୍ୟା ଆତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","ଆରେ, ହେୱାନ୍‌ ନର୍କତ କଲ୍‌ ବଲ୍‌ ଆସ୍ତି ଜପି ହୁଡ଼୍‌ଜି ଦେହା ଅବ୍ରାହାମ୍‌ ଆରି ତା ଡ୍ରକ୍ୟାଆତାକା ଲାଜାର୍‌ତିଂ ହୁଡ଼୍‌ତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","ହେବେତାଂ ହେୱାନ୍‌ ହିରିବିସ୍‍ ଇଚାନ୍‌, ଏ ଆବା ଅବ୍ରାହାମ୍‌, ନାଙ୍ଗେଙ୍ଗ୍‌ ଦୟା କିଜ଼ି ଲାଜାର୍‌ତିଂ ପକ୍‌ତା, ଇନେସ୍‌କି ହେୱାନ୍‌ ଏଜ଼ୁଂ ତା ୱାଚ୍‍କାତାଂ ଟିପ୍ କୁଡ଼୍‌କ୍‌ଚି ନା ୱେଦୁଲ୍‍ତ ହିତ୍‍ଡ଼ି କିଦେନ୍‌, ଇଚିସ୍‌ ଆନ୍‌ ଇ ନାଣିତ କଲ୍‌ ବଲ୍‌ ଅାନାଙ୍ଗା ।” ");
INSERT INTO peg_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","ମାତର୍‌ ଅବ୍ରାହାମ୍‌ ଇଚାନ୍‌, “କାଡ଼୍‌ଦେ, ଏନ୍‌ ଜେ ଜିବୁନ୍‌ ମାନି ସମୁତ ନି ହାର୍‌ ବିସ୍ରେ ୱିଜ଼ୁ ପାୟା ଆତାୟ୍‌, ଆରେ ଲାଜାର୍‌ ହେ ଲାକେ କାରାପ୍‌ ବିସ୍ରେ ୱିଜ଼ୁ ଗାଟାଆତାନ୍‌, ଇଦାଂ ମାନେ କିୟା; ମାତର୍‌ ନଙ୍ଗ୍‌ ହେୱାନ୍‌ ଇ ବାହାତ ଦୁକ୍‌ସାରାୟ୍‌ ପାୟାତାନ୍ନା, ଆରେ ଏନ୍‌ ନଙ୍ଗ୍‌ କଲ୍‌ ବଲ୍‌ ଆନାୟା । ");
INSERT INTO peg_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","ହେଦାଂ ପିସ୍ତି ମି ଆରି ମା ବିତ୍ରେ ବେସିଗାଜା ଦେହା ମାନାତ୍‌, ଇନେସ୍‌ ଇମ୍‌ଣାକାର୍‌ ଇ ବାହାତାଂ ମି ତାକେ ହାନି କାଜିଂ ମାନ୍‌କିନାନ୍‌, ହେୱାର୍‌ ହାଞ୍ଜେଙ୍ଗ୍‌ ଆଡୁର୍‌, କି ଆରି ହେ ବାହାତାଂ ଇନେର୍‌ ମା କଚଣ୍‌ ନାସି ୱାଦେଙ୍ଗ୍ ଆଡୁର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","ହେବେତାଂ ହେୱାନ୍‌ ଇଚାନ୍‌, “ଏ ଆବା ତା ଆତିସ୍‌ ଆନ୍‌ ନିଙ୍ଗେଙ୍ଗ୍‌ ଗୱାରି କିଦ୍‌ନାଙ୍ଗା, ହେୱାନିଂ ନା ଆବା ଇଲ୍‌ତ ପକ୍ତାନାୟ୍‌, ");
INSERT INTO peg_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","ଇନାକିଦେଂକି ନା ପାଞ୍ଚ୍‌ଜାଣ୍ ଟଣ୍ଡାର୍‌ ମାନାର୍‌; ହେୱାର୍‌ ପା ଇନେସ୍‌କି ଇ ବାଦା ବାହାତ ୱାଉର୍‌, ହେଦାଂ କାଜିଂ ହେୱାନ୍‌ ହେୱାର୍‌ କଚଣ୍‌ ସାକି ହିନାଦେର୍ ।” ");
INSERT INTO peg_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","ମାତର୍‌ ଅବ୍ରାହାମ୍‌ ଇଚାନ୍‌, “ହେୱାର୍‌ କଚଣ୍‌ତ ମସା ଆରି ବେଣ୍‌ବାକ୍‌ଣାୟ୍‌ କିନାକାର୍‌ ଦରମ୍‌ ସାସ୍ତର୍‌ ମାନାତ୍, ହେୱାଦେର୍ ହେୱାର୍‌ କାତା ୱେନାଟ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","ହେବେତାଂ ହେୱାନ୍‌ ଇଚାନ୍‌, “ଏ ଆବା ଅବ୍ରାହାମ୍‌, ହେଦାଂ ସାରି ଆକାୟ୍‌, ମତର୍‌ ଜଦି ହାତିମାନାୟ୍‌ କଚଣ୍‌ତାଂ ରକାନ୍‌ ହେୱାର୍‌ କଚଣ୍‌ତ ହାନାନ୍‌, ଏଲେଙ୍ଗ୍‌ଚି ହେୱାର୍‌ ମାନ୍‌ବାଦ୍‌ଲାୟ୍‌ କିନାର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","ମାତର୍‌ ହେୱାନ୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ଇଚାନ୍‌, “ଜଦି ହେୱାର୍‌ ମସା ଆରି ବେଣ୍‌ବାକ୍‌ଣାୟ୍‌କିନାକାର୍‌ କାତା ୱେନ୍‌ୱାତାର୍‌ଚି, ଏଲେଙ୍ଗ୍‌ଚି ହାତିମାନାୟ୍‌ତାଂ ପା ରୱାନ୍‌ ମୁକ୍‌ଡ଼ା ଆଜ଼ି ହାଚିସ୍‌ ପା ହେୱାର୍‌ ପାର୍ତି କିଉର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","ଜିସୁ ତା ଚେଲାହିରିଙ୍ଗ୍‌ ଇଚାନ୍‌, ଇମ୍‌ଣି ସବୁ ବାଦା ହୁକେ ମାନାୟ୍‌ ପାପ୍‌ତ ଆର୍‌ନାନ୍‌ ହେ ୱିଜ଼ୁ “ହାତ୍‌ପା ୱାନାନ୍‌; ଜେ ଇ ସବୁନି କାରଣ୍‌ ଆନାତ୍‌, ତା ହାରିହାରା ଦସା ବେସି ବୟଙ୍କାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","ଇ ହାରୁକାର୍‌ ବିତ୍ରେତାଂ ରକାନ୍‌ନିଙ୍ଗ୍‌ ବାଦା ଆନି ବାଟା ଇଚିସ୍‌ ତା ଗାଡେଲ୍‌ତ ର ଜାତା କାଲ୍‌ ଡ଼ଇ କିଜ଼ି ହେୱାନିଂ ହାମ୍‌ଦୁର୍‍ତ ତୁସି ହିନାକା ଇଚିସ୍‌ ତା କାଜିଂ ହାର୍‌ ଆତାତ୍ମା । ");
INSERT INTO peg_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","ଲାଗିଂ, ଏପେଙ୍ଗ୍‌ ଜାର୍‌ ଜାର୍‌ କାମାୟ୍‌ତ ବିସ୍ରେ ଜାଗ୍ରତ୍‌ ଆଜ଼ି ମାନାଟ୍‌ ।” “ଜଦି ମି ଟଣ୍ଡେନ୍‌ ପାପ୍‌ କିତିସ୍‌, ଲାଗିଂ ହେୱାନିଂ ଗଡ଼୍‌ କିୟାଟ୍‌, ଆରେ ହେୱାନ୍‌ ଜଦି ମାନ୍‌ବାଦ୍‌ଲାୟ୍‌ କିତିସ୍‌, ଲାଗିଂ ହେୱାନିଂ କେମା ହିୟାଟ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","ପାଚେ, ଜଦି ହେୱାନ୍‌ ଦିନେକ୍‌ ବିତ୍ରେ ସାତ୍‌ ହଟ୍‌ ମି ବିରୁତ୍‌ତ ପାପ୍‌ କିତିସ୍‌ ଆରି ସାତ୍‌ ହଟ୍ ମି ତାକେ ୱାଜ଼ି ଆନ୍‌ ମାନ୍‌ବାଦ୍‌ଲାୟ୍‌ କିନାଙ୍ଗା ଇଞ୍ଜି ଇନାନ୍‌, ଲାଗିଂ ହେୱାନିଂ ଏପେଙ୍ଗ୍‌ କେମା ହିୟାଟ୍‍ ।” ");
INSERT INTO peg_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","ହେବେଣ୍ଡାଂ ପକ୍ୟାତାକାର୍‌ ମାପ୍ରୁଙ୍ଗ୍‌ ଇଚାର୍‌, “ମା ପାର୍ତି ବାଡାୟ୍‌ କିୟା ।” ");
INSERT INTO peg_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","ମାପ୍ରୁ ଇଚାନ୍‌, “ଜଦି ର ହାର୍‌ହୁ ମାଞ୍ଜି ଲାକେ ମିଦାଙ୍ଗ୍‌ ପାର୍ତି ମାଚିସ୍‌, ତା ଆତିସ୍‌ ଇ ତୁତ୍‌ୱା ମାର୍‌ଦିଙ୍ଗ୍‌ ଏନ୍‌ ଦଲ୍‌ଦାଂ ଉଟ୍‌କା ଆଜ଼ି ହାମ୍‌ଦୁର୍‌ତ ରୁଜ଼୍‌ୟା ଆଡ ଇଞ୍ଜି ଇଚିସ୍‌ ହେଦାଂ ମି ବଲ୍‌ ମାନିକିନାତ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“ମାତର୍‌ ମି ବିତ୍ରେ ଏଲେଙ୍ଗ୍‌ ମାନାୟ୍‌ ଇନେନ୍‌ ମାନାନ୍‌, ଇନେର୍‌ ଆଡ଼ିୟାଏନ୍‌ ଆଡ଼୍‌ ବୁଲାଇ କିଜ଼ି କି ମେଣ୍ଡାଂ ହାରାୟ୍‌ କିଜ଼ି ୱାତିସ୍‍ ହେୱାନ୍‌ ତାଙ୍ଗ୍‌ ଇନାନ୍‌, ଇ ଦାପ୍ରେ ୱାଜ଼ି କୁଚ୍‌ଚି ତିନା ?” ");
INSERT INTO peg_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","ହେୱାନ୍‌ ଇନାକା ହେୱାନିଂ ଇନୁନ୍‌, “ନା ତିନାକା ଜାଲ୍‌ଦି କିୟା, ଆରେ ଆନ୍‌ ତିଞ୍ଜି ଉଣ୍‌ଜି ୱିହ୍‌ୱି ପାତେକ୍‌ ନା ହେବା କିୟା, ତା ପାଚେ ଏନ୍‌ ତିନାୟ୍‌ ଉଣାୟ୍‌ ?” ");
INSERT INTO peg_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","ଆଡ଼ିୟା ବଲ୍‌ କାମାୟ୍‌ ଇନାକା ହେୱାନିଂ ଜୁୱାର୍‌ କିନାନ୍‌ ? ");
INSERT INTO peg_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","ହେ ଲାକେ ଏପେଙ୍ଗ୍‌ପା ବଚନ୍‌ତାଂ ୱିଜ଼ୁ କାମାୟ୍‌ କିତିପାଚେ ଇନାଟ୍‌, “ଆପେଂ ପୁନ୍‌ୱି ଆଡ଼ିୟାକାପ୍‌, ଇନା କାମାୟ୍‌ କିନାକା ହେଦାଂ କେବଲ୍‌ କିତାପ୍‌ନ୍ନା ।” ");
INSERT INTO peg_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","ଜିସୁ ଜିରୁସାଲମ୍‌ତ ହାନିୱାଡ଼ାଲିଂ ସମିରଣ୍‌ ଆରି ଗାଲିଲି ମାଦିତିଂ ହାଲ୍‌ଜି ମାଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","ଆରେ, ହେୱାନ୍‌ ଇମ୍‌ଣି ର ନାସ୍‌ତ ହଟାନ୍‌, ଦସଜାଣ୍‌ ଗାଜା ରଗ୍ୟାର୍‌ ହେୱାନ୍‌ ହୁକେ ବେଟା ଆତାର୍‌; ");
INSERT INTO peg_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","ହେୱାର୍‌ ଦେହା ନିଲ୍‌ଚିପା ଗାଜାକାଟ୍‌ତାଂ ଇଚାର୍‌, “ଏ ଜିସୁ, ଗୁରୁ, ମା ଦୟା ହୁଡ଼୍‌ଦା ।” ");
INSERT INTO peg_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","ପାଚେ ଜିସୁ ହେୱାରିଂ ହୁଡ଼୍‌ଜି ଇଚାନ୍‌, “ଏପେଙ୍ଗ୍‌ ହାଲ୍‌ଜି ଜାର୍‌ ଜାର୍‌ତିଂ ମାପ୍ରୁହେବାକିନାକାରିଂ ଚଚାଟ୍‌ ।” ଆରେ ହେୱାର୍‌ ହାଲୁ ହାଲୁ ସକଟ୍‌ ଆତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","ମାତର୍‌ ହେୱାର୍‌ ବିତ୍ରେ ରକାନ୍‌ ଜାର୍‌ତି ଉଜ୍‌ ଆନାକା ହୁଡ଼୍‌ଜି ଗାଜା କାଟ୍‌ତାଂ ଇସ୍ୱର୍‌ ଗୁଣ୍‌ କେର୍‌ଜି କେର୍‌ଜି ଲେଉଟା ଆଜ଼ି ୱାଜ଼ି, ");
INSERT INTO peg_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","ଜିସୁତି କାଲ୍‌କୁ ତାରେନ୍‌ ଗୁର୍‌ଜି ହେୱାନିଂ ଜୁୱାର୍‌ କିଦେଙ୍ଗ୍‌ ଲାଗାତାନ୍‌; ହେୱାନ୍‌ ରକାନ୍‌ ସମିରଣିୟନି ମାନାୟ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","ହେବେ ଜିସୁ ଉତର୍‌ ହିତାନ୍‌, “ଦସଜାଣ୍‌ ଇନାକା ସକଟ୍‌ ଆୱାତାର୍ଣ୍ଣା ? ଲାଗିଂ ଆରେ ନଅଜାଣ୍ ଇମେର୍‌ ? ");
INSERT INTO peg_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","ଲାଗିଂ ଆରେ ନଅ ଜାଣ୍‌ ଇମେର୍‌ ? ଇସ୍ୱର୍‌ତିଂ ଜାଜ୍‌ମାଲ୍‌ କିନି କାଜିଂ ଇ ପାର୍ତିକିୱି ଜିହୁଦି ଲକ୍‌ତିଂ ପିସ୍ତି ଆରେ ଇନେର୍‌ ମାସ୍‌ଦି ୱାତାର୍ ?” ");
INSERT INTO peg_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","ଆରେ, ଜିସୁ ହେୱାନିଂ ଇଚାନ୍‌, “ନିଙ୍ଗ୍‌ଜି ହାଲା, ନି ପାର୍ତି ନିଙ୍ଗେଙ୍ଗ୍‌ ଉଜ୍‌ କିତ୍‌ତାତ୍‌ନ୍ନା ।” ");
INSERT INTO peg_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","ଇସ୍ୱର୍‌ ମାପ୍ରୁତି ରାଜି ଇନାୱାଡ଼ାଂ ୱାନାତା, ଇ ବିସ୍ରେ ପାରୁସିର୍‌ ହେୱାନିଂ ୱେନ୍‍ବିତିଲେ ହେୱାନ୍‌ ହେୱାରିଂ ଉତର୍‌ ହିତାନ୍‌, “ଇସ୍ୱର୍ତି ରାଜି ହୁଡ଼୍‌ନାକା ଲାକେ ୱାଉତ୍; ");
INSERT INTO peg_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","ମାତର୍‌ ହୁଡ଼ାଟ୍‌, ଇବେ କି ହାବେ ଇଞ୍ଜି ମାନାୟାର୍‌ ଇଞ୍ଜୁର୍ ଇନାକିଦେଂକି ହୁଡ଼ାଟ୍‌, ଇସ୍ୱର୍ତି ରାଜି ମି ବିତ୍ରେ ମାନାତ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","ମାତର୍‌ ଜିସୁ ହେୱାନ୍‌ ଚେଲାହିରିଂ ଇଚାନ୍‌, “ଏଲେଙ୍ଗ୍‌ବାର୍ତି ସମୁ ୱାନାତ୍, ଏଚେକାଡ଼୍‌ଦ ଏପେଙ୍ଗ୍‌ ମାନାୟ୍‌ ମାଜ଼ି ଦିନ୍‍କୁ ବିତ୍ରେ ର ଦିନ୍‌ ହୁଡ଼୍‌ଦେଂ ଇଚା କିନାଦେର୍, ମାତର୍‌ ହୁଡ଼ୁଦେର୍ ।” ");
INSERT INTO peg_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","ହୁଡ଼ା, “ହେବେ, ହୁଡ଼ାଟ୍‌” ଇବେ ଇଞ୍ଜି ମାନାୟାର୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ଇଞ୍ଜ୍‌ନାର୍‌, ମାତର୍‌ ଏପେଙ୍ଗ୍‌ ହାଲ୍‍ମାଟ୍‍ । ");
INSERT INTO peg_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","ଇନାକିଦେଂକି ବିଜ୍‌ଲି ଇଡ଼୍‌ଜି ଇନେସ୍‌ ବାଦାଡ଼୍‌ତ ର ପାଡ଼୍‌କାତାଂ ଆର ପାଡ଼୍‌କା ପାତେକ୍‌ ଅଜଡ଼୍‌ ହିନାତ୍, “ମାନାୟ୍‌ ମାଜ଼ି ହେ ଦିନ୍ତ ହେ ଲାକେ ଚଞ୍ଜ୍ୟାୟାନାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","ମାତର୍‌ ପର୍ତୁମ୍‌ ହେୱାନ୍‌ ବେସି ଦୁକ୍‌ବଗି କିନାନ୍‌ ଆରି ଇ ଜୁଗ୍‌ତ ଲକୁ ତାଙ୍ଗ୍‌ ମୁନାକିନାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","ଆରେ, ନହ ୱେଡ଼ାଲିଂ ଇନେସ୍‌ ଗିଟା ଆଜ଼ି ମାଚାତ୍‌, ମାନାୟ୍‌ ମାଜ଼ି ୱେଡ଼ାଲିଂ ପା ହେ ଲାକେ ଗିଟା ଆନାତ୍‌; ");
INSERT INTO peg_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","ଜାଜ୍‌ତ ନହତି ହଣି ୱେଡ଼ାଲିଙ୍ଗ୍ ଦିନ୍‌ ପାତେକ୍‌ ମାନାୟାର୍‌ ଚିନ୍‍ଜିଉଣ୍‍ଜି ଆରି ବିବା ଆନାକା ଆରି ବିବା ଆଦେଂ ଲୟା ମାଚାର୍‌ କେ, କ୍ଡୁକ୍‌ନାକା ୱାଜ଼ି ୱିଜ଼ାକାରିଂ ନାସ୍‌ କିତାତ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","ଲଟ ୱେଡ଼ାଲିଂ ପା ହେ ଲାକେ ଗିଟା ଆଜ଼ି ମାଚାତ୍‌, ଲକୁ ତିନାଉଣାକା, କଡ଼୍‌ନାକା ପ୍ରନାକା, ମାର୍‍କୁ ରୁଜ଼୍‌ନାକା, ଆରି ଇଲ୍‌ ରଚ୍‌ଚେଂ ଲୟା ଆଜ଼ି ମାଚାର୍‌, ");
INSERT INTO peg_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","ମାତର୍‌ ଲଟ ସଦମ୍‌ତାଂ ହସି ହାନି ଦିନ୍‌ ସାର୍ଗେତାଂ ନାଣି ଆରି ଗନ୍ଦକ୍‌ ବାର୍‌ହା ଆଜ଼ି ୱିଜ଼ାକାରିଂ ନାସ୍‍କିତାତ୍ । ");
INSERT INTO peg_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","ମାନାୟ୍‌ ମାଜ଼ି ଚଞ୍ଜିୟାଆନି ଦିନ୍‌ ହେ ଲାକେ ଗିଟା ଆନାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“ହେ ଦିନ୍‌ ଜେ ଇନେର୍‌ ଜେଗନ୍‌ ଜପି ମାଚିସ୍‌, ହେୱାନ୍‌ ଇଲ୍‌ ବିତ୍ରେ ମାନି ଜାର୍‌ ଆଡ଼୍‌ମାଡ଼୍‌ ଅନି କାଜିଂ ଜୁଜ଼ି ୱାମେନ୍‌; ହେ ଲାକେ ଜେ ବୁଇଁତାକେ ମାଚିସ୍‌, ହେୱାନ୍‌ ଲେଉଟି ଆଜ଼ି ହାଲ୍‍ମେନ୍ । ");
INSERT INTO peg_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","ଲଟତି ଡକ୍ରି କାତା ଏତୁ କିୟାଟ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","ଇନେର୍‌ ଜାର୍‌ ଜିବୁନ୍‌ ବାଚାୟ୍‌ କିଦେଙ୍ଗ୍‌ ସେସ୍ଟା କିନାନ୍‌, ହେୱାନ୍‌ ହେଦାଂ ଆରାୟ୍‌ କିନାନ୍‌, ଆରେ ଇନେର୍‌ ଜାର୍‌ ଜିବୁନ୍‌ ଆରାୟ୍‌ କିନାନ୍‌, ହେୱାନ୍‌ ହେଦାଂ ବାଚାୟ୍‍କିନାନ୍‍ । ");
INSERT INTO peg_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ଇଞ୍ଜ୍‌ନାଙ୍ଗା, ହେ ନାଣା ରିକାର୍‌ ର ଟାଟିତ ମାନ୍‍ଙ୍ଗାନାର୍, ରକାନିଂ ଇଟିୟା ଆନାତ୍‌ ଆରି ବିନ୍‌ ଲଗାଂ ପିହ୍‌ୟା ଆନାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","ରିଣ୍ଡେକ୍‌ କଗ୍‌ଲେକ୍‌ ର ଜାତାତ ନୁସ୍‌ଦି ମାନିକ୍‌, ରଞ୍ଜିଲିଂ ଇଟିୟା ଆନାତ୍‌ ଆରି ରଞ୍ଜିଲିଂ ପିହ୍ୟାନାତ୍ । ");
INSERT INTO peg_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","ରିକାର୍‌ ଜମିତାକେ ମାଚିସ୍‌, ରକାନିଂ ଇଟିୟା ଆନାତ୍‌ ଆରି ରକାନିଂ ପିହ୍ୟାନାତ୍ ।” ");
INSERT INTO peg_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","ହେବେଣ୍ଡାଂ ଚେଲାର୍‌ ହେୱାନିଂ ଉତର୍‌ ହିତାର୍‌, “ଏ ମାପ୍ରୁ, ଇମେତାକେ ?” ଜିସୁ ହେୱାରିଂ ଇଚାନ୍‌, “ଇମେତାକେ ମାଡ଼ା, ହେବେ ରାମାଣିଙ୍ଗ୍‌ ପା ରୁଣ୍ଡା ଆନିକ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","ୱାହ୍‍ୱାଦାଂ ତାୟ୍‍ନାତ୍ ପାର୍ତାନା କିନାକା ଜେ ମାନାତ୍‌, ଇ ବିସ୍ରେ ହେୱାନ୍‌ ହେୱାରିଂ ଉତର୍‌ମୁଡ଼୍‌ ହିଜ଼ି ଇଚାନ୍‌, ");
INSERT INTO peg_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","“ର ଗାଡ଼୍‌ଦ ରୱାନ୍‌ ବିଚାର୍‌କିନାକାନ୍‌ ମାଚାନ୍‌, ହେୱାନ୍‌ ଇସ୍ୱର୍‌ତିଂ ପାଣ୍ଡ୍ରା ଆୱାଦାଂ ମାଚାନ୍‌ କି ମାନାୟ୍‌ତିଂ ମାନିକିୱାଦାଂ ମାଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","ହେ ଗାଡ଼୍‌ଦ ରଞ୍ଜେଲ୍‌ ରାଣ୍ଡି ମାଚାତ୍‌, ହେଦେଲ୍‌ ଚାନେକ୍‌ ଚାନେକ୍‌ ହେୱାନ୍‌ ତାକେ ହାଲ୍‌ଜି ଇଞ୍ଜି ମାଚାତ୍‌, ନା ଅନ୍ୟାୟ୍‌ରିଂ ବିଚାର୍‌ କିୟା ।” ");
INSERT INTO peg_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","ଆରେ, ହେୱାନ୍‌ ଏଚେକ୍‌ ୱେଡ଼ାପାତେକ୍ ରାଜି ଆୱାଦାଂ ମାଚାନ୍‌, ମାତର୍‌ ପାଚେ ହେୱାନ୍‌ ମାନେ ମାନେ ଇଚାନ୍‌, ଆତିସ୍‌ପା “ଆନ୍‌ ଇସ୍ୱର୍‌ତିଂ ପାଣ୍ଡ୍ରା ଆଉଙ୍ଗ୍‌ କି ମାନ୍‍ୟାରିଂ ମାନି କିଉଙ୍ଗ୍‌, ");
INSERT INTO peg_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","ଆତିସ୍‌ପା ଇ ରାଣ୍ଡି କଗ୍‌ଲେ ନାଙ୍ଗେଙ୍ଗ୍‌ କସ୍ଟ ହିଦ୍‍ନି କାଜିଂ ଆନ୍‌ ହେଦାଂ କାଜିଂ କିତି ଅନ୍ୟାୟ୍‌ ସବୁ ବିଚାର୍‌ କିନାଙ୍ଗ୍‌, ନଲେ ହେଦେଲ୍‌ ସବୁୱେଡ଼ାଙ୍ଗ୍‌ ୱାଜ଼ି ନାଙ୍ଗ୍‌ ତାନ୍ଦ୍ରା କିଦ୍‌ନାତ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","ହେବେଣ୍ଡାଂ ମାପ୍ରୁ ଇଚାନ୍‌, “ଇ ଅଦାର୍ମି ବିଚାର୍‌କିନାକାନ୍‌ ଇନାକା ଇନାନ୍ନା, ହେଦାଂ ୱେନା । ");
INSERT INTO peg_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","ଲାଗିଂ ଇସ୍ୱର୍‌ତିଂ ଇମ୍‌ଣି ବାଚିକିତି ଲକାର୍‌ ୱେଡ଼ା ନାଣା ହେୱାନିଂ କୁକ୍‌ଚି ମାନାର୍‌, ହେୱାନ୍‌ କି ହେୱାର୍‌ କିତି କାମାୟ୍‌ ଅନ୍ୟାୟ୍‌ ବିଚାର୍‌ କିଉନ୍‌ ଆତିସ୍‌ପା ହେୱାନ୍‌ ହେୱାର୍‌ ସତ୍ରୁରୁର୍ କାଜିଂ ବେସି ଦାର୍ମି ଆନାନ୍‌ ? ");
INSERT INTO peg_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ଇଞ୍ଜ୍‌ନାଙ୍ଗା, ହେୱାନ୍‌ ବେଗି ହେୱାର୍‌ କିତି କାମାୟ୍‌ ଅନ୍ୟାୟ୍‌ ବିଚାର୍‌ କିନାନ୍‌ । ମାତର୍‌ ମାନାୟ୍‌ ମାଜ଼ି ୱାଜ଼ି ପୁର୍ତିତ ଇନାକା ପାର୍ତି ହୁଡ଼୍‍ନାନ୍ ?” ");
INSERT INTO peg_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","ଜାର୍‌ ଜାର୍‌ତିଂ ଦାର୍ମି ମାନେ କିଜ଼ି ଆଲ୍‌ଗା ୱିଜ଼ାକାରିଂ ଲାଜ୍‌କୁଇ କିନାକାର୍‌ କେତେକ୍‌ ଜିବୁନ୍‌ତ ପାର୍ତି ଲଗାଂ ଜିସୁ ଇ ଉତର୍‌ମୁଡ଼୍‌ ପା ୱେଚ୍‌ଚାନ୍‌, ");
INSERT INTO peg_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“ରିକାର୍‌ ମାନାୟ୍‌ ପାର୍ତାନା କିନି କାଜିଂ ମନ୍ଦିର୍‌ତ ହାଚାର୍‌, ରକାନ୍‌ ପାରୁସି ଆରି ଆରେ ରକାନ୍‌ ସିସ୍ତୁ ଏନ୍‌ନାକାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","ପାରୁସି ନିଲ୍‌ଚିପା ଜାର୍‌ ଲାଗେ ଇ ଲାକେ ପାର୍ତାନା କିଦେଙ୍ଗ୍‌ ଲାଗାତାନ୍‌, ଏ ଇସ୍ୱର୍‌, ଆନ୍‌ ନିଙ୍ଗେଙ୍ଗ୍‌ ଜୁୱାର୍‌ ହିଦ୍‍ନାଙ୍ଗା ଜେ ଆନ୍‌ ବିନ୍‌ ଲକୁଲାକେ ପାଣ୍ଡ୍ରୁକିନାକାଙ୍ଗ୍‌, ଅଦାର୍ମି, ନାଙ୍ଗ୍‌ରା କି ଇ ସିସ୍ତୁଏନ୍‌ନାକାନ୍‌ ଲାକେ ପା ଆକାୟ୍‌; ");
INSERT INTO peg_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","ଆନ୍‌ ରଇବାର୍‌ ଦିନ୍‌ତିଂ ରିହା ଉପାସ୍‌ କିନାଙ୍ଗା ଆରି ନା ୱିଜ଼ୁ କମାୟ୍‌କିତି ଦାନ୍‍ ଦସ୍‌ ବାଗ୍‌ ଦାନ୍‌ ହିନାଙ୍ଗା” ");
INSERT INTO peg_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","ମାତର୍‌ ସିସ୍ତୁଏନ୍‌ନାକାନ୍‌ ଦେହା ନିଲ୍‌ଚି ସାର୍ଗେସ୍ତ ହୁଡ଼୍‌ଦେଂ ପା ସାସ୍‌ କିୱାତାନ୍‌, ମାତର୍‌ ତା ନେଞ୍ଜେଡାକିତ ଇଡ଼୍‌ୟା ଆଜ଼ି ଇଞ୍ଜେଙ୍ଗ୍‌ ଲାଗାତାନ୍‌, “ଏ ଇସ୍ୱର୍‌, ଆନ୍‌ ପାପି, ନାଙ୍ଗେଙ୍ଗ୍‌ ଦୟା କିଦା ।” ");
INSERT INTO peg_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ଇଞ୍ଜ୍‌ନାଙ୍ଗା, ହେୱାନ୍‌ ପାରୁସି ଆକାୟ୍‌ ମାତର୍‌ ହେ ସିସ୍ତୁ ଏନ୍‌ନାକାନ୍‌ ଦାର୍ମି ଆଜ଼ି ଜାର୍‌ ଇଞ୍ଜ ହାଚାନ୍‌; ଇନାକିଦେଂକି ଇନେର୍‌ ଜାର୍‌ତିଂ ଜପି ଇଞ୍ଜି ଚଞ୍ଜ୍ୟା ଆନାନ୍‌, ହେୱାନିଂ ତାରେନ୍‌ କିୟା ଆନାତ୍‌, ମାତର୍‌ ଜେ ଜାର୍‌ତିଂ ତାରେନ୍‌ କିନାନ୍‌, ହେୱାନିଂ ଉଚ୍‍ କିୟା ଆନାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","ଜିସୁ ଇନେସ୍‌ ହିମ୍‌ଣାକାଂ ଡୁନାନ୍, ଇଦାଂ କାଜିଂ ଲକୁ ହେୱାରିଂ ପା ହେୱାନ୍‌ ତାକେ ତାତେଙ୍ଗ୍‌ ଲାଗାତାର୍‌, ମାତର୍‌ ଚେଲାର୍‌ ହେଦାଂ ହୁଡ଼୍‌ଜି ହେୱାରିଂ ଦାକା ହିଦେଂ ଲାଗାତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","ମାତର୍‌ ଜିସୁ ହେୱାରିଂ ଜାର୍‌ ଲାଗାଂ କୁକ୍‌ଚି ଇଚାନ୍‌, ହିମ୍‌ଣାକାଂ ନା କଚଣ୍‌ତ ୱାଦେଙ୍ଗ୍ ହିଆଟ୍, ଆରେ ହେୱାରିଂ ମୁନା କିମାଟ୍‌, ଇନାକିଦେଂକି ମାପ୍ରୁତି ରାଜି ଏଲେଙ୍ଗ୍‌ବାର୍ତି ହିମ୍‌ଣାଂ । ");
INSERT INTO peg_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ହାତ୍‌ପା ଇଞ୍ଜ୍‌ନାଙ୍ଗା, “ଇନେର୍‌ ହିମ୍‌ଣା ଲାକେ ଇସ୍ୱର୍ତି ରାଜି ଇଟ୍‍ୱିତିସ୍, ହେୱାନ୍‌ ଇନେସ୍‌ କିଜ଼ିପା ହେବେ ହଣ୍ଡେଙ୍ଗ୍‌ ଆଡୁନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","ରୱାନ୍‌ ଜିହୁଦି ନେତା ଜିସୁଙ୍ଗ୍‌ ୱେନ୍‌ବାତାନ୍‌, “ଏ ସତ୍‌ ଗୁରୁ, ୱିଜ଼୍‌ୱି ଜିବୁନ୍‌ ପାୟାନି କାଜିଂ ଆନ୍‌ ଇନାକା କିନାଙ୍ଗ୍‌ ?” ");
INSERT INTO peg_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","“ହେବେଣ୍ଡାଂ ଜିସୁ ତାଙ୍ଗେଙ୍ଗ୍‌ ଇଚାନ୍‌, ନାଙ୍ଗେଙ୍ଗ୍‌ ସତ୍‌ ଇଞ୍ଜି ଇନେକିଦେଂ ଇଞ୍ଜ୍‌ନାୟା ? ରକାନିଂ ପିସ୍ତି, ଇଚିସ୍‌, ଇସ୍ୱର୍‌ତିଂ ପିସ୍ତି ଅଲ୍‌ଗା ଇନେର୍‌ ପା ହାର୍‌ ଆକାୟ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","ବଲ୍‌କୁତ ଏପେଙ୍ଗ୍‌ ପୁଚାଦେର୍ଣ୍ଣା, ଦାରି କିମାଟ୍‌, ନାର୍‌ ଅହ୍‌ମାଟ୍‌, ଚର୍‌ କିମାଟ୍‌, ମିଚ୍‍ସାକି ହିମାଟ୍‍, ଜାର୍‌ ଆବା ଆୟାକାଂ ଜିଉନୱାଟ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","ହେୱାନ୍‌ ଇଚାନ୍‌, “ଇଦାଂ ୱିଜ଼ୁ ଆନ୍‌ ବେଣ୍ଡିୟା ୱେଡ଼ାତାଂ ମାନିକିଜ଼ି ୱାନାଙ୍ଗା ।” ");
INSERT INTO peg_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","ଜିସୁ ଇଦାଂ ୱେନ୍‌ଞ୍ଜି ତାଙ୍ଗେଙ୍ଗ୍‌ ଇଚାନ୍‌, “ନିନ୍ଦାଂ ଆରେ ରଞ୍ଜାଙ୍ଗ୍‌ ବିସ୍ରେ ଅଲପ୍‍ ମାନାତ୍‌; ଏନ୍‌ ଜାର୍‌ତି ୱିଜ଼ୁ ପ୍ରସି ହିଲ୍‍ୱାକାରିଂ ଦାନ୍‌ ବାଟାକିଜ଼ି ହିଆ, ଆରେ ଏନ୍‌ ସାର୍ଗେତାଂ ଦାନ୍‌ ପାୟା ଆନାୟ୍‌; ପାଚେ, ୱାଜ଼ି ନା ପାଚେ ପାଚେ ୱା ।” ");
INSERT INTO peg_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","ମାତର୍‌ ହେୱାନ୍‌ ଇ ୱିଜ଼ୁ କାତା ୱେନ୍‌ଞ୍ଜି ବେସି ଦୁକ୍‍କିତାନ୍‍, ଇନାକିଦେଂକି ହେୱାନ୍‌ ବେସି ମାଜାନ୍‌ ମାଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","ହେବେତାଂ ହେଦେଲ୍‌ ଦୁକ୍‌ଆନାକା ହୁଡ଼୍‌ଜି ଜିସୁ ତାଙ୍ଗେଙ୍ଗ୍‌ ଇଚାନ୍‌, “ଇନେର୍‌ତି ଦାନ୍‌ ମାନାତ୍‌, ହେୱାର୍‌ କେତେ କସ୍ଟତାଂ ମାପ୍ରୁ ରାଜିତ ହଣାର୍‍ । ");
INSERT INTO peg_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","ଇନାକିଦେଂକି ଇସ୍ୱର୍‌ ରାଜିତ ଦନିଲଗୁ ହଣିବାଟା ହୁଜାନି କାଣାତିଂ ଉଟ୍‌ ହଣାକା ଆଡ଼୍‌ୱା ।” ");
INSERT INTO peg_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","ଇନେର୍‌ ଇ କାତା ୱେଚାର୍‍, ହେୱାର୍‌ ଇଚାର୍‌, “ଲାଗିଂ ଇନେର୍‌ ମୁକ୍ତି ପାୟା ଆଦେଂ ଆଡ୍‌ନାର୍‌ ?” ");
INSERT INTO peg_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","ମାତର୍‌ ହେୱାନ୍‌ ହୁଡ଼୍‌ଜି ଇଚାନ୍‌, “ଇନାକା ମାନାୟ୍‌ତାକେ ଆଉତ୍‌, ହେଦାଂ ଇସ୍ୱର୍‌ ତାକେ ଆନାତ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","ହେବେଣ୍ଡାଂ ପିତର୍‌ ଇଚାନ୍‌, “ହୁଡ଼ା ଆପେଙ୍ଗ୍‌ ଜାର୍‌ ଜାର୍‌ତି ୱିଜ଼ୁ ପିସ୍ତିପା ନି ପାଚେ ପାଚେ ୱାନାପା ।” ");
INSERT INTO peg_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","ଜିସୁ ହେୱେରିଂ ଇଚାନ୍‌, “ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ହାତ୍‌ପା ୱେଚ୍‍ନାଙ୍ଗା, ଇମ୍‌ଣି ମାନାୟ୍‌ ମାପ୍ରୁ ରାଜି କାଜିଂ ଇଲ୍‌ କି ଡକ୍ରି ଟଣ୍ଡେନ୍‌ ଆବା ଆୟା ! ହିମ୍‌ଣାୱାକ୍‌ଡ଼ା ପିସ୍ତାର୍ଣ୍ଣା, ");
INSERT INTO peg_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ହେୱାର୍‌ ଇ କାଡ଼୍‌ଦ ବେସିଗୁଣ୍‌ ଆରି ପାଚେନି କାଡ଼୍‌ଦ ୱିଜ଼୍‌ୱି ଜିବୁନ୍‌ ପାୟା ଆଉନ୍‌, ଏଲେଙ୍ଗ୍‌ବାର୍ତି ମାନାୟ୍‌ ଇନେର୍‌ ହିଲୁର୍ ।” ");
INSERT INTO peg_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","ପାଚେ ହେୱାନ୍‌ ବାରଜାଣ୍‌ତିଂ ବିନେ କିଜ଼ି ହେୱାରିଂ ଇଚାନ୍‌, “ହୁଡ଼ାଟ୍‌ ଆସେଙ୍ଗ୍‌ ଜିରୁସାଲମ୍‌ତ ହାନାସା, ଆରେ ବେଣ୍‌ବାକ୍‌ଣାୟ୍‌କିନାର୍‌ ମାନାୟ୍‌ ମାଜ଼ି ବିତ୍ରେ ଇମ୍‌ଣି ୱିଜ଼ୁ ବିସ୍ରେ ଲେକା ମାନାତ୍‌, ହେ ୱିଜ଼ୁ ଜିତାଆନାନ୍‌; ");
INSERT INTO peg_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","ଇନାକିଦେଂକି ଜିସୁ ପାର୍ତିକିୱି ଜିହୁଦିର୍‌ କେଇଦ ହିୟାଆନାନ୍‍, ଆରେ ହେୱାର୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ଲାଜ୍‌କୁଇ କିନାର୍‌, ହେୱାନିଂ ଗ୍ରେଚ୍‌ନାର୍‌ ହେୱାନ୍‌ ଜପି ଚୁପ୍‌ନାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","ହେୱେନିଂ କର୍‌ଡା ଡ଼ିଜି ଅହ୍‌ନାର୍‌, ଆରେ ତିନ୍‌ଦିନ୍‌ ପାଚେ ଆରେ ନିଂନାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","ମାତର୍‌ ହେୱାର୍‌ ଇ ୱିଜ଼ୁ ବିସ୍ରେ ଅଲପ୍‌ପା ବୁଜାଆୱାତାର୍‌, ଇ କାତା ହେୱାର୍‌ତାଂ ଡ଼ୁଗ୍‌ଜି ମାଚାତ୍‌, ଆରି ଇନା ଇନାକା ଇଞ୍ଜି ମାଚାନ୍‌, ହେ ୱିଜ଼ୁ ହେୱାର୍‌ ବୁଜାଆୱାଦାଂ ମାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","ଜିସୁ ଜିରିହନି ଲାଗେ ଆନି ସମୁତ ର କାଣା ହାଜ଼ି ଗୁଟିତ କୁଚ୍‌ଚି ବିକ୍ୟା ଏନ୍‌ଚି ମାଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","ହେୱାନ୍‌ ମାନାୟ୍‌ ହାନିହିଂ ଆଲି ୱେନ୍‌ଞ୍ଜି କାତା “ଇନାକା ଇଞ୍ଜି ୱେନ୍‌ବେଦେଂ‌ ଲାଗାତାନ୍‌ ?” ");
INSERT INTO peg_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","ହେୱାର୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ଇଚାର୍‌, “ନାଜରିତିୟ ଜିସୁ ଇ ହାଜ଼ି ହିଜ଼ି ହାନାନ୍ନା ।” ");
INSERT INTO peg_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","ହେବେଣ୍ଡାଂ କାଣା ଗାଜା କାଟ୍‌ତାଂ ଇଚାନ୍‌, “ଏ ଜିସୁ, ଦାଉଦ୍‌ ମାଜ଼ି, ନାଙ୍ଗେଙ୍ଗ୍‌ ଦୟା କିଦା ।” ");
INSERT INTO peg_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","ମତର୍‌ ଆଗେ ହାଲ୍‌ଜି ମାଚି ମାନାୟାର୍‌ ହେୱାନିଂ ଚିମ୍‌ରା ଆଦେଂ ଦାକା କିଦେଙ୍ଗ୍‌ ଲାଗାତାର୍‌, ମତର୍‌ ହେୱାନ୍‌ ଆଦିକ୍‌ ଗାଜା କାଟ୍‌ତାଂ ଇଞ୍ଜେଙ୍ଗ୍‌ ଲାଗାତାନ୍‌, “ଏ ଦାଉଦ୍‌ତି ମାଜ଼ି, ନାଙ୍ଗେଙ୍ଗ୍‌ ଦୟା କିଦା ।” ");
INSERT INTO peg_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","ହେବେତାଂ ଜିସୁ ନିଲ୍‌ଚି ହେୱାନିଂ ତା ଲାଗେ ତାତେଙ୍ଗ୍‌ ବଲ୍‌ ହିତାନ୍‌; ଆରେ, ହେୱାନ୍‌ ଲାଗାଂ ଏକିତିଲେ, “ହେୱାନ୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ୱେନ୍‌ବାତାନ୍‌,” ");
INSERT INTO peg_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“ଆନ୍‌ ନି କାଜିଂ ଇନାକା କିନାଙ୍ଗ୍‌ ଇଞ୍ଜି ଏନ୍‌ ଇଚା କିନାୟା ?” ହେୱାନ୍‌ ଇଚାନ୍‌, “ଏ ମାପ୍ରୁ ଆନ୍‌ ଇନେସ୍‌କି ଆରେ କାଣ୍‌କୁ ହୁଡ଼୍‍ନାଂ ।” ");
INSERT INTO peg_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","ଜିସୁ ତାଙ୍ଗେଙ୍ଗ୍‌ ଇଚାନ୍‌, “କାଣ୍‌କୁ ହୁଡ଼ା; ନି ପାର୍ତି କିନାକା ନିଙ୍ଗେଙ୍ଗ୍‌ ଉଜ୍‌ କିତ୍‌ତାତ୍‌ନ୍ନା ।” ");
INSERT INTO peg_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","ହେ ଦାପ୍ରେ ହେୱାନ୍‌ ହୁଡ଼୍‌ଜି ଇସ୍ୱର୍ତି କେର୍‌କଣ୍‌ କିଉ କିଉ ଜିସୁ ପାଚେ ପାଚେ ହାଞ୍ଜେଙ୍ଗ୍‌ ଲାଗାତାନ୍‌ ଆରି ଲକୁ ୱିଜ଼ାକାର୍‌ ହେଦାଂ ହୁଡ଼୍‌ଜି ଇସ୍ୱର୍‌ତିଂ ପାର୍ତାନା କିତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","ପାଚେ ଜିସୁ ଜିରିହତ ହଣ୍‌ଜିପା ହେଦେଲିଂ ଆଜ଼ି ହାଲ୍‌ଜି ମାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","ଆରି ହୁଡ଼ାଟ୍‌, ଜକିୟ ତର୍‌ନି ରକାନ୍‌ ମାନାୟ୍‌ ମାଚାନ୍‌, ହେୱାନ୍‌ ରକାନ୍‌ ମୁଡ଼୍‌ଦାକାନ୍‌ ସିସ୍ତୁଏନ୍‍ନାକାନ୍‍ ଆରି ମାଜାନ୍‌ ମାନାୟ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","ଜିସୁ ଇନେନ୍‌, ହେଦାଂ ହୁଡ଼୍‌ଦେଂ ହେୱାନ୍‌ ସେସ୍ଟା କିଜ଼ି ମାଚାନ୍‌, ମାତର୍‌ ଲକୁ ଗହଲି କାଜିଂ ହୁଡ଼୍‌ଦେଂ ଆଡ୍‌ୱାଦାଂ ମାଚାନ୍‌, ଇନାକିଦେଂକି ହେୱାନ୍‌ କୁଜା ମାଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","ଲାଗିଂ ହେୱାନ୍‌ ମାନାୟ୍‌ ଆଗେ ହଞ୍ଚି ହାଲ୍‌ଜି ହେୱାନିଂ ହୁଡ଼୍‌ନି କାଜିଂ ର ତଗାମାର୍‌ତ ଦୁମ୍‌ତାନ୍‌, ଇନାକିଦେଂକି ହେ ହାଜ଼ି ହିଜ଼ି ଜିସୁ ହାନାକା ମାଚାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","ଜିସୁ ହେ ବାହାତ ୱାଜ଼ି ଜପି ହୁଡ଼୍‌ଜି ହେୱାନିଂ ଇଚାନ୍‌, “ଜକିୟ ବେଗି ଜୁଜ଼ି ୱା, ଇନାକିଦେଂକି ନେଞ୍ଜେଙ୍ଗ୍‌ ନାଙ୍ଗେଙ୍ଗ୍‌ ମିଞ୍ଜ ହାତ୍‌ପା ମାଞ୍ଜେଙ୍ଗ୍‌ ଲାଗ୍‌ଦାନାତ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","ହେବେତାଂ ହେୱାନ୍‌ ବେଗି ଜୁଜ଼ି ୱାଜ଼ି ୱାରିତାଂ ଜିସୁଙ୍ଗ୍‌ ହେବା କିତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","ହେଦାଂ ହୁଡ଼୍‌ଜି ୱିଜ଼ାକାର୍‌ ଗାଣ୍‌ଜୁ କିଜ଼ି ଇଞ୍ଜେଙ୍ଗ୍‌ ଲାଗାତାର୍‌, “ହେୱାନ୍‌ ପାପିୟାର୍‌ ଇଞ୍ଜ ମାଞ୍ଜେଙ୍ଗ୍ ହାନାନା ।” ");
INSERT INTO peg_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","ମାତର୍‌ ଜକିୟ ନିଲ୍‌ଚିପା ମାପ୍ରୁଙ୍ଗ୍‌ ଇଚାନ୍‌, ଏ ମାପ୍ରୁ, ହୁଡ଼ା, “ନା ଦାନ୍‌ତାଂ ଆନ୍‌ ଆଦା ହିଲ୍‍ୱାକାରିଂ ଦାନ୍‌ ହିନାଙ୍ଗା, ଆରି ଜଦି ଅନ୍ୟାୟ୍‍ତାଂ ଇନେର୍‌ତାଂ ଅଲପ୍‍ ଅଜ଼ି ମାଚିସ୍‌, ଲାଗିଂ ଚାରିଗୁଣ୍‌ତାଂ ହେଦାଂ ଲେଉଟାୟ୍‍ କିନାଙ୍ଗା ।” ");
INSERT INTO peg_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","ହେବେଣ୍ଡାଂ ଜିସୁ ହେୱାନ୍‌ ବିସ୍ରେ ଇଚାନ୍‌, “ନେଞ୍ଜେଙ୍ଗ୍‌ ଇ ଇଞ୍ଜ ମୁକ୍ତିକିନାକା ଏକାୱାତାତ୍‌ନା, ଲାଗିଂ ଇୱାନ୍‍ପା ଅବ୍ରାହାମ୍‌ତି ରକାନ୍‌ ମାଜ଼ି; ");
INSERT INTO peg_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","ଇନାକିଦେଂକି ଇନାକା ଜାଙ୍ଗ୍‍ତାତ୍‍ନା ହେଦାଂ ଡେକ୍‌ତେଂ ରାକ୍ୟା କିଦେଙ୍ଗ୍‌ ମାନାୟ୍‌ ମାଜ଼ି ୱାତାନ୍ନା ।” ");
INSERT INTO peg_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","ଲକୁ ଇ ଉତର୍‌ମୁଡ଼୍‌ ୱିଜ଼ୁ ୱେନି ୱେଡ଼ାଲିଂ ହେୱାନ୍‌ ଆରି ରଞ୍ଜାଙ୍ଗ୍‌ କାତା ଇଚାନ୍‌, ଇନାକିଦେଂକି ହେୱାନ୍‌ ଜିରୁସାଲମ୍‌ନି ଲାଗେ ଆଜ଼ି ମାଚାନ୍‌ ଆରି ଇସ୍ୱର୍‌ତି ରାଜି ବେଗି ମେଙ୍ଗିୟା ଆନାତ୍‌ ଇଞ୍ଜି ହେୱାର୍‌ ବାବିକିଜ଼ି ମାଚାର୍ । ");
INSERT INTO peg_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","ଲାଗିଂ ହେୱାନ୍‌ ଇଚାନ୍‌, “ରକାନ୍‌ ଗାଜାକାନ୍‌ ମାନାୟ୍‌ ଜାର୍‌ ରାଜି କାଜିଂ ରାଜା ପାଦ୍‌ ପାୟା ଆଜ଼ି ଲେଉଟା ଆଦେଂ କାଜିଂ ଦେହା ଦେସ୍‌ତ ହାଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","ହେୱାନ୍‌ ତା ଦସ୍‌ ଜାଣ୍‌ ଆଡ଼ିୟାରିଂ କୁକ୍‌ଚି ହେୱାରିଂ ଦସ୍‌ଗଟା ଡାବୁଙ୍ଗ୍‌ ହିଜ଼ି ଇଚାନ୍‌, ଆନ୍‌ ୱାନି ପାତେକ୍‌ ବେପାର୍‌ କିୟାଟ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","ମାତର୍‌ ହେୱାନ୍ତି ଦେସ୍‍ନିକାର୍‍ ହେୱାନିଂ ଗିଣ୍‌ କିଜ଼ି ମାଚାର୍‌, ଆରି ହେୱାର୍‌ ହେୱାନ୍‌ ପାଚେ ଦୁତ୍‌ ପକ୍‌ଚି ଇଚାନ୍‌, ଇୱାନ୍‌ ଜେ ମା ଜପି ରାଜ୍‌ କିନାନ୍‌, “ଇଦାଂ ମା ଇଚା ଆକାୟ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“ପାଚେ ହେୱାନ୍‌ ରାଜା ପାଦ୍‌ ପାୟା ଆଜ଼ି ଲେଉଟା ଆଜ଼ି, ଇମ୍‌ଣି ଆଡ଼ିୟାରିଂ ଡାବୁଙ୍ଗ୍‌ ହିଜ଼ି ମାଚାନ୍‌, ହେୱାର୍‌ ବିତ୍ରେ ବେପାର୍‌ କିଜ଼ି ଇନେର୍‌ ଏଚେକ୍‌ ଲାବ୍‌ କିତାର୍ଣ୍ଣା, ହେଦାଂ ପୁନିକାଜିଂ ହେୱାରିଂ ଜାର୍‌ ରାଜି ଲାଗେ କୁକ୍‌ଚି ତାହିୱାଦେଂ ବଲ୍‌ ହିତାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","ହେବେଣ୍ଡାଂ ପର୍ତୁମ୍‌ ମାନାୟ୍‌ ୱାଜ଼ି ଇଚାନ୍‌, “ମାପ୍ରୁ, ନି ହିତ୍‌ତି ହନା ଟାକାଂ ଆରି ଦସ୍‌ଗଟା ଡାବୁଙ୍ଗ୍‌ ଆନ୍‌ ଲାବ୍‌ କିତାଙ୍ଗ୍‌ନା ।” ");
INSERT INTO peg_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","ହେୱାନ୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ଇଚାନ୍‌, “ଏନ୍‌ ରକାୟ୍‌ ହାର୍‌ଦି ଆଡ଼ିୟା, ଏନ୍‌ ବେସି ଅଲପ୍‍ ବିସ୍ରେ ପାର୍ତିଲାହାଂ କିତିଲେ ଏନ୍‌ ଦାସ୍‌ଗଟା ଗାଡ଼୍‌ ଜପି ଆଦିକାର୍‌ ପାୟା ଆ ।” ");
INSERT INTO peg_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","ଆରେ ଆରେ ରକାନ୍‌ ୱାଜ଼ି ଇଚାନ୍‌, “ମାପ୍ରୁ, ନି ଡାବୁଙ୍ଗ୍‌ ପାଞ୍ଚ୍‌ଗଟା ନାଦାଂ ଲାବ୍‌କିତାଂନା ।” ");
INSERT INTO peg_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","ହେୱାନ୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ପା ଇଚାନ୍‌, “ଏନ୍‌ ପା ପାଞ୍ଚ୍‌ଗଟା ଗାଡ଼୍‌ ଜପି ଆଦିକାର୍‌ ପାୟା ଆ ।” ");
INSERT INTO peg_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","ଆରେ ରକାନ୍‌ ୱାଜ଼ି ଇଚାନ୍‌, “ମାପ୍ରୁ, ହୁଡ଼ା, ଇଦାଂ ନି ଡାବୁଙ୍ଗ୍‌, ଆନ୍‌ ଇଦାଂ ନା ତୁୱାଲ୍‌ତ ଗାଚ୍‌ଚି ଇଡ଼୍‌ଜି ମାଚାଙ୍ଗ୍‌; ");
INSERT INTO peg_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","ଇନାକିଦେଂକି ଆନ୍‌ ନିଙ୍ଗେଙ୍ଗ୍‌ ପାଣ୍ଡ୍ରା ଆତ୍‍ତାଂ, ଲାଗିଂ ଏନ୍‌ ରକାୟ୍‌ କଟିମାନାୟ୍‍ତି, ଇନାକା ଇଟ୍‍ୱାତାଂମା, ହେଦାଂ ନିକ୍‌ଚି ଅନାୟ୍, ଆରେ ଇନାକା ୱିତ୍‍ୱାଦାଂ ମାନାୟ୍‌ ହେଦାଂ ତ୍ରେଜ଼୍‌ନାୟ୍‍ । ");
INSERT INTO peg_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","ହେୱାନ୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ଇଚାନ୍‌, ଏଡ଼େ ବାନ୍ୟା ଆଡ଼ିୟା, ନି ମୁମ୍‍ନି କାତାତିଂ ନି ବିଚାର୍‌ କିନାଙ୍ଗ୍‌ । ଆନ୍‌ ରକାଂ କଟି ଲଗୁ, ଇନାକା ଇଟ୍‌ୱାଦାଂ ମାନାଂ, ହେଦାଂ ନିକ୍‌ଚି ଅନାଙ୍ଗ୍‌, ଆରେ ଇନାକା ୱିତ୍‍ୱାଦାଂ ମାନାଂ, ହେଦାଂ ତ୍ରେଜ଼୍‌ନାଂ, ଇଦାଂ ଇନାକା ପୁଚାୟ୍‍ନା ?” ");
INSERT INTO peg_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","ଲାଗିଂ, ବେଙ୍କତ ଇନେକିଦେଂ ନା ହନା ଟାକାଂ ଇଟ୍‍ୱାତାୟ୍ ? ତାଆତିସ୍‌ ଆନ୍‌ ୱାଜ଼ି କଲନ୍ତର୍‌ ଲାହାଙ୍ଗ୍‌ ପାୟାଆତାଂମା । ");
INSERT INTO peg_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","ଆରେ, ହେ କଚଣ୍‌ତ ନିଲ୍‌ଚିମାନି ମାନାୟ୍‌ତିଂ ଇଚାନ୍‌, “ଇବେଣ୍ଡାଂ ଇ ଡାବୁଙ୍ଗ୍‌ ଅଜ଼ି, ଇନେରିଂ ଦାସ୍‍ଟାକା ମାନିଙ୍ଗ୍, ହେୱାନିଂ ହିଆଟ୍ ।” ");
INSERT INTO peg_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","ହେବେତାଂ ହେୱାର୍‌ ହେୱାନିଂ ଇଚାର୍‌, “ମାପ୍ରୁ, ତାଦାଙ୍ଗ୍‌ ତ ଦାସ୍‍ ଗଟା ଡାବୁଙ୍ଗ୍‌ ମାନିଙ୍ଗ୍ ।” ");
INSERT INTO peg_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ୱେଚାନାଙ୍ଗା, “ଇମ୍‌ଣି ମାନାୟ୍‌ତିଂ ମାନାତ୍‌, ହେୱାନିଂ ହିୟାଆନତ୍; ମାତର୍‌ ଇନେର୍‌ତି ହିଲୁତ୍‌, ହେ କଚଣ୍‌ ଇନାକା ମାନାତ୍‌, ହେଦାଂ ନେ ହେୱାନ୍‌ତାଂ ଅୟାନାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","ମାତର୍‌ ନା ଇମ୍‌ଣି ସାତ୍ରୁର୍‌ ଆନ୍‌ ହେୱାର୍‌ ଜପି ସାସନ୍ କିନାଙ୍ଗ୍‌ ଇଞ୍ଜି ଇଚା କିୱାଦାଂ ମାଚାଙ୍ଗ୍‌, ହେୱାରିଂ ଇବେ ତାସି ନା ମୁମ୍‌ଦ ଟୁଣାଟ୍ ।” ");
INSERT INTO peg_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","ଇ ସବୁ କାତା ଇଞ୍ଜି ଜିସୁ ଆଗେ ହାଲ୍‌ଜି ଜିରୁସାଲମ୍‌ ନିପ ହାଞ୍ଜେଙ୍ଗ୍‌ ଲାଗାତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","ଆରେ, ଏଚେକାଡ଼୍‌ଦ ହେୱାନ୍‌ ଜିତ୍‌ମାଡ଼ି କଚଣ୍‌ତ ବେତ୍‌ପାଗି ଆରି ବେତ୍‌ନିୟା ଲାଗାଂ ଏକାତାନ୍‌, ହେ ଏଚେକାଡ଼୍‌ଦ ହେୱାନ୍‌ ହେ ଚେଲାର୍‌ ବିତ୍ରେତାଂ ରିକାରିଙ୍ଗ୍ ଇ କାତା ଇଞ୍ଜି ପକ୍‌ତାନ୍‌, ");
INSERT INTO peg_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“ମି ହାଣ୍‍କୁ ହେ ନାସ୍‌ତ ହାଲାଟ୍‍, ହେବେ ହଣି ୱେଡ଼ାଲିଙ୍ଗ୍, ଇନାକା ଜପି ଇନେର୍‌ ଇନାୱାଡ଼ାଂ ଇନେର୍‌ କୁଚ୍‍ୱାତାନ୍‍ନ୍ନା, ଏଲେଙ୍ଗ୍‌ବାର୍ତି ର ଗଦ ହିମ୍‌ଣା ଗାଚ୍‌ଚାକା ହୁଡ଼୍‌ନାଦେର୍‌, ହେଦେଲିଂ ରିକ୍‌ଚି ତାହିୱାଡୁ । ");
INSERT INTO peg_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","ଆରେ, ବାଟିଙ୍ଗ୍‌ ଇନେର୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ଇନେକିଦେଂ ରିକ୍‍ନାଦେରା ଇଞ୍ଜି ୱେନ୍‌ବାତିସ୍‌, ଏପେଙ୍ଗ୍‌ ଇନାଦେର୍‌, ଇନାକିଦେଂକି ଇଦାଂ ତାକେ ମାପ୍ରୁତି ଲଡ଼ା ମାନାତ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","ହେବେ ପକ୍ୟାତି ମାନାୟାର୍‌ ହାଲ୍‍ଜିପା, ଜିସୁ ହେୱାରିଂ ଇନେସ୍‌ ଇଞ୍ଜି ମାଚାନ୍‌, ହେ ଲାକେ ହୁଡ଼୍‌ତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","ଆରେ, ହେୱାର୍‌ ଗଦ ହିମ୍‌ଣାତିଂ ରିକ୍‍ନିୱେଡ଼ାଲିଂ ହେ ହାଉକାର୍‌ ହେୱାରିଂ ୱେନ୍‍ବାତାର୍‍, “ଇନେକିଦେଂ ଗଦ ହିମ୍‍ଣାତିଂ ରିକ୍‍ନାଦେରା ?” ");
INSERT INTO peg_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","ହେୱାର୍‌ ଇଚାର୍‌, “ଇନାକିଦେଂକି ଇଦାଂ ତାକେ ମାପ୍ରୁତି ଲଡ଼ା ମାନାତ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","ଆରେ, ହେୱାର୍‌ ଗଦ ହିମ୍‌ଣାତିଂ ଜିସୁତାକେ ତାସି ତା ଜପି ଜାର୍‌ ଜାର୍‌ ହେନ୍ଦ୍ରା ପାସ୍‌ସି ଜିସୁଙ୍ଗ୍‌ କୁଚିକିତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","ଆରେ, ଜିସୁ ହାନି ୱେଡ଼ାଲିଂ ମାନାୟାର୍‌ ହାସ୍‍ଦ ଜାର୍‌ ଜାର୍‌ ହେନ୍ଦ୍ରା ପାସ୍‌ସି ହିଦେଙ୍ଗ୍‍ ଲାଗାତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","ଆରେ, ଜିସୁ ଏଚେକାଡ଼୍‌ଦ ଜିତ୍‌ମାଡ଼ିନି ଗାଡ଼୍‍ଗାଡ଼ା ବାହାତ ଲାଗାୟ୍‌ ଆତାନ୍‌, ହେୱେଡ଼ାଲିଂ ସବୁ ଚେଲାର୍‌ ମାନ୍ଦା ହୁଡ଼୍‌ଜି ମାଚି ୱିଜ଼ୁ ସାକ୍ତିନି କାମାୟ୍‌ କାଜିଂ ୱାରିତାଂ ଗାଜା କାଟ୍‌ କିଜ଼ି ଇସ୍ୱର୍‌ ମାପ୍ରୁତି ପାର୍ତାନା କିଜ଼ି ଇଚାର୍‌, ");
INSERT INTO peg_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","“ମାପ୍ରୁତି ତର୍‌ଦ ଇମ୍‌ଣି ରାଜା ୱାନାନା, ଇସ୍ୱର୍‌ ହେୱାନିଂ ଦନ୍ୟବାଦ୍‌ କିଏନ୍‌ । ସାର୍ଗେତ ସୁସ୍ତା ଆରି ଜପ୍‌ଣି ଲକାର୍ତି ଜାଜ୍‌ମାଲ୍‌ ଆୟେତ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","ହେବେଣ୍ଡାଂ ମାନାୟାର୍‌ ଗହ୍‌ଲି ବିତ୍ରେ କେତେକ୍‌ ପାରୁସିର୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ଦାକା କିଜ଼ି ଇଚାର୍‌, “ଏ ଗୁରୁ, ନି ଚେଲାରିଂ ଚିମ୍‌ରା ଆଦେଂ ଇନା ।” ");
INSERT INTO peg_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","ଜିସୁ ଉତର୍‌ ହିତାନ୍‌, “ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ଇଞ୍ଜ୍‌ନାଙ୍ଗା, ଇୱାର୍‌ ଚିମ୍‌ରା ଆତିସ୍‌, କାଲ୍‍କୁଙ୍ଗ୍‍ ଆଲାଆନିକ୍‍ ।” ");
INSERT INTO peg_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","ଆରେ, ଏଚେକାଡ଼୍‌ଦ ଜିସୁ ଜିରୁସାଲାମ୍‌ ଲାଗାୟ୍‌ ୱାତାନ୍, ହେ ଏଚେକାଡ଼୍‌ଦ ଗାଡ଼୍‌ଦିଂ ହୁଡ଼୍‌ଜି ହେଦାଂ କାଜିଂ ଆଡ଼୍‌ବିସ୍‌ ଇଚାନ୍‌, ");
INSERT INTO peg_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","“ଏନ୍‌, ଆଁ, ଏନ୍‌ ଜଦି ନେଞ୍ଜେଙ୍ଗ୍‌ ସୁସ୍ତାନି ବିସ୍ରେ ପୁନ୍‍ଞ୍ଜିମାଚାୟ୍‍ଚି ! ମାତର୍‌ ନଙ୍ଗ୍‌ନି କାଣ୍‌କୁକାଂ ଡ଼ୁଗ୍‌ଜି ମାଚାତ୍‍ନ୍ନା । ");
INSERT INTO peg_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","ସମୁ ୱାନାତା ଏଚେକାଡ଼୍‌ଦ ମି ସାତ୍ରୁର୍‌ ନି ଚାରିବେଣ୍‌ତାଂ କାଲ୍‌ଦ ଗାଚ୍‌ଚି ନିଙ୍ଗେଙ୍ଗ୍‌ ଟେବାୟ୍‌ କିଦ୍‌ନାର୍‌, ଆରେ ମିଦାଙ୍ଗ୍‌ ୱିଜ଼ୁ ହାଜ଼ି ଗେସ୍‌ତାନାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","ହେୱାର୍‌ ନିଙ୍ଗେଙ୍ଗ୍‌ ଆରି ନି ଲାହାଙ୍ଗ୍‌ ନି ବିତ୍ରେ ମାନି ୱିଜ଼ାର୍‌ ମାନାୟାରିଂ ବୁଡାଇ କିଦ୍‌ନାର୍‌, ର କାଲ୍‌ ଜପି ଆରେ ର କାଲ୍‌ ଜପି ମାନୁତ୍‌, ଇନାକିଦେଂକି ଏଚେକାଡ଼୍‌ଦ ନିଙ୍ଗେଙ୍ଗ୍‌ ମୁକ୍ତି କିଦ୍‌ଦେଂ ଇଞ୍ଜି ଇସ୍ୱର୍‌ ମାପ୍ରୁ ୱାତାନ୍, ଏପେଙ୍ଗ୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ପୁନ୍‌ୱାତାଦେର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","ଆରେ, ଜିସୁ ମନ୍ଦିର୍‌ତ ହଣ୍‍ଜିପା ବେପାର୍‌ କିନି ଲଗାଂ ଇଦାଂ ଇଞ୍ଜି ହପ୍‍ତେଂ ଲାଗାତାନ୍‌, ");
INSERT INTO peg_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","ଦରମ୍‌ ସାସ୍ତର୍‌ତ ଲେକାଆତାତ୍‌ନା, ଇସ୍ୱର୍‌ ଇଚାନ୍‌ “ମା ଇଲ୍‌ ପାର୍ତାନା ଇଲ୍‌ ଆନାତ୍‌, ମାତର୍‌ ଏପେଙ୍ଗ୍‌ ଚର୍କୁ ଇଲ୍‌ନି ପାରା କିତାଦେର୍ଣ୍ଣା ।” ");
INSERT INTO peg_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","ଆରେ, ହେୱାନ୍‌ ନିତ୍ରେ ମନ୍ଦିର୍‌ତ ହିକ୍ୟା ହିିଜ଼ି ମାଚାନ୍‍, ମାତର୍‌ ମୁଡ଼୍‌ ମାପ୍ରୁହେବାକିନାକାନ୍‌, ସାସ୍ତିର୍‌ ମାନାୟାର୍‌ତି ନେତାର୍‌ ଲାହାଂ ହେୱାନିଂ ୱିସ୍‍ପେଦେଂ ସେସ୍ଟା କିଜ଼ି ମାଚାର୍‌, ");
INSERT INTO peg_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","ମାତର୍‌ ୱିଜ଼ୁ ଲଗୁ ର ମାନ୍ତ ହେୱାନ୍‌ ହିକ୍ୟା ୱେନ୍‍ଞ୍ଜି ମାଚିଲେ ହେୱାର୍‌ ଇନାକା କିନାପ୍‌ ଇଞ୍ଜି ତିର୍‌ କିଦେଙ୍ଗ୍‌ ଆଡ୍‌ୱାଦାଂ ମାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","ଇବେତାଂ ହେୱାନ୍‌ ଦିନେକ୍‌ ଏଚେକାଡ଼୍‌ଦ ମନ୍ଦିର୍‌ତ ମାନାୟାରିଂ ହିକ୍ୟା ହିଜ଼ି ମାଚାନ୍‌ ଆରି ନେକ୍ରିକାବୁର୍‌ ପର୍‌ଚାର୍ କିଜ଼ି ମାଚାନ୍‌, ଏଚେକାଡ଼୍‌ଦ ମୁଡ଼୍‌ ମାପ୍ରୁହେବା କିନାକାର୍‌ ଆରି ସାସ୍ତିର୍‌ ବୁଡ଼ାଲୁର୍‌ ହୁକେ ୱାଜ଼ି ତାଙ୍ଗ୍‌ ଇଚାର୍‌, ");
INSERT INTO peg_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","“ଏନ୍‌ ଇମ୍‌ଣି ଆଦିକାର୍‌‌ତ ଇ ୱିଜ଼ୁ କିନାୟା, କି, ଇନେର୍‌ ନିଙ୍ଗ୍‌ ଇ ଆଦିକାର୍‌ ହିତ୍‍ତାନ୍, ହେୱାନ୍‌ ଇନେନ୍‌, ମାଙ୍ଗେଙ୍ଗ୍‌ ୱେଚ୍‌ଚା ।” ");
INSERT INTO peg_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","ମାତର୍‌ ଜିସୁ ହେୱାରିଂ ଉତର୍‌ ହିତାନ୍‌, “ଆନ୍‌ ପା ମିଙ୍ଗେଙ୍ଗ୍‌ ର ବେରଣ୍‌ ୱେନ୍‌ବା ଆଦ୍‌ନାଂ, ନାଙ୍ଗ୍‌ ୱେଚ୍‍ଚାଟ୍, ");
INSERT INTO peg_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","ବାପ୍ତିସିମ୍‌ ହିନି ଜହନ୍‌ତି ବାପ୍ତିସିମ୍‌ ସାର୍ଗେତାଂ କି ମାନାୟ୍‌ତିଂ ଆତାତ୍‌ ?” ");
INSERT INTO peg_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","ହେବେ ହେୱାର୍‌ ହେୱାର୍‌ ବିତ୍ରେ କାତାବାର୍ତା କିଜ଼ି ଇଚାର୍‌, “ଜଦି ସାର୍ଗେତାଂ ଇଞ୍ଜି ଇନାସ୍‌, ତା ଆତିସ୍‌ ହେୱାନ୍‌ ଇଞ୍ଜ୍‌ନାନ୍‌, ଏପେଙ୍ଗ୍‌ ଇନେକିଦେଂ ତାଙ୍ଗ୍‌ ପାର୍ତି କିୱାତାଦେର୍‌ ?” ");
INSERT INTO peg_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","ମାତର୍‌ ଜଦି ମାନାୟ୍‌ତିଂ ଇଞ୍ଜି ଇନାସ୍‌, ବାଟିଙ୍ଗ୍‌ ୱିଜ଼ାକାର୍‌ ଲକୁ ମାଙ୍ଗ୍‌ କାଲ୍‌କୁ ଇଡ଼୍‌ଜି ମାଟ୍‍କିଦ୍‍ନାର୍, ଇନାକିଦେଂକି “ଜହନ୍‌ ରକାନ୍‌ ଜେ ବେଣ୍‌ବାକ୍‌ଣାୟ୍‌ କିନାକାନ୍‌, ଇଦାଂ ହେୱାର୍‌ ପାର୍ତି କିଜ଼ି ମାଚାର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","ଲାଗିଂ ହେଦାଂ ଇମେତାଂ ଆତାତ୍‌, “ଇଦାଂ ପୁନୁପ୍‌ ଇଞ୍ଜି ହେୱାର୍‌ ଉତର୍‌ ହିତାର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","ଜିସୁ ହେୱାରିଂ ଇଚାନ୍‌, “ଆନ୍‌ ଇମ୍‌ଣି ଆଦିକାର୍‌‌ତ ଇ ୱିଜ଼ୁ କିନାଙ୍ଗା, ହେଦାଂ ଆନ୍‌ ପା ମିଙ୍ଗେଙ୍ଗ୍‌ ୱେଚ୍‍ଚୁଙ୍ଗ୍ ।” ");
INSERT INTO peg_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","ଇଦାଂ ପାଚେ ହେୱାନ୍‌ ମାନାୟାର୍‌ତି ଇ ଉତର୍‌ମୁଡ଼୍‌ ଇଞ୍ଜେଙ୍ଗ୍‌ ଲାଗାତାନ୍‌ । “ରକାନ୍‌ ମାନାୟ୍‌ ର ଅଙ୍ଗୁର୍‌ ବାଡ଼୍‌ କିଜ଼ି ହେଦାଂ କାମ୍‌ଲିୟାରିଂ ଆଦି ହିଜ଼ି ବେସି ବାର୍ହୁ କାଜିଂ ବିଦେସ୍‍ତ ହାଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","ଆରେ, କାମ୍‌ଲିୟାର୍‌ ଇନେସ୍‌ ତାଙ୍ଗ୍‌ ଅଙ୍ଗୁର୍‌ ବାଡ଼୍‌ନି ପାଡ଼୍‌ ତାଙ୍ଗ୍‌ ବାଗ୍‌ ହିନାର୍‌, ଇଦାଂ କାଜିଂ ହେୱାନ୍‌ ରକାନ୍‌ ଆଡ଼ିଏନିଂ ହାର୍ଦି ୱେଡ଼ାଲିଂ ହେୱାର୍‌ ତାକେ ପକ୍‌ତାନ୍‌, ମାତର୍‌ ହେ ଆଡ଼ିୟାର୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ମାଟ୍‍କିଜ଼ି ୱାରା କେଇଦାଂ ପକ୍ତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","ହେୱାନ୍‌ ପାଚେ ଆରେ ରକାନିଂ ଆଡ଼ିୟାନିଂ ପକ୍‌ତାନ୍‌; ହେୱାର୍‌ ତାଙ୍ଗ୍‌ ପା ଟ୍ରାକ୍ରାର୍ ଆରି ଲାଜୁ କିଜ଼ି ୱାରା କେଇଦାଂ ପକ୍ତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","ପାଚେ ହେୱାନ୍‌ ଆରେ ରକାନିଂ ପା ପକ୍‌ତାନ୍‌; ମାତର୍‌ ହେୱାର୍‌ ତାଙ୍ଗ୍‌ ପା ଗାଅଦାଅ କିଜ଼ି ବାର୍ତ ତୁହିତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","ହେବେଣ୍ଡାଂ ଅଙ୍ଗୁର୍‌ ବାଡ଼୍‌ନି ହାଉକାର୍‌ ଇଚାନ୍‌, ଆନ୍‌ ଇନାକା କିନାଙ୍ଗ୍‌ ? ନା ୱାରିନି ହିମ୍‍ଣାତିଂ ପକ୍‌ନାଂ, ଇନେସ୍‌ ଆତିସ୍‌ ହେୱାର୍‌ ତାଙ୍ଗ୍‌ ମାନି କିନାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","ମତର୍‌ ଆଡ଼ିୟାର୍‌ ତାଙ୍ଗ୍‌ ହୁଡ଼୍‌ଜି ହେୱାର୍‌ ହେୱେର୍‌ କାତାବାର୍ତା କିଜ଼ି ଇଞ୍ଜେଙ୍ଗ୍‌ ଲାଗାତାର୍‌, ‘ଇୱାନ୍ତ ମୁଣିକା, ଇୱାନିଂ ଅହ୍‌ନାସ୍‌, ଇନେସ୍‌ ମାଦାଂ ଆଦିକାର୍‌ ଆନାତ୍‌ ।’ ");
INSERT INTO peg_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","ଆରେ, ହେୱାର୍‌ ତାଙ୍ଗ୍‌ ଅଙ୍ଗୁର୍‌ ବାଡ଼୍‌ ଅସ୍ତି ବାର୍ତ ତୁହି ହିତାର୍‌ ।” “ବାଟିଙ୍ଗ୍‌, ଅଙ୍ଗୁର୍‌ ବାଡ଼୍‌ନି ହାଉକାର୍‌ ହେୱାର୍‌ କାଜିଂ ଇନାକା କିନାନ୍‌ ? ");
INSERT INTO peg_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","ହେୱାନ୍‌ ୱାଜ଼ି ଇ କାମ୍‌ଲିୟାରିଂ ନାସ୍‌ କିନାନ୍‌ ଆରି ବିନ୍‌ ଲଗାଂ ଅଙ୍ଗୁର୍‌ ବାଡ଼୍‌ ହିନାନ୍‌ ।” ଇଦାଂ ୱେନ୍‌ଞ୍ଜି ହେୱାର୍‌ ଇଚାର୍‌, “ହେଦାଂ ଆମେତ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","ମାତର୍‌ ହେୱାନ୍‌ ହେୱାରିଂ ଗାଣ୍‌ଗାଣ୍‌ ହୁଡ଼୍‌ଜି ଇଚାନ୍‌, “ବାଟିଙ୍ଗ୍‌ ଇ ଇମ୍‌ଣି ବଚନ୍‌ ଲେକା ଆତାତ୍‌ନ୍ନା, ତା ଅରତ୍‌ ଇନାକା, ଇଲ୍‌ ରଚ୍‍ନାକାର୍ ଇମ୍‌ଣି କାଲ୍‌ଦିଂ ମୁନା କିତାର୍‌, ହେଦାଂ କନାନି ମୁଡ଼୍‌କାଲ୍‌ ଆତାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","ଇନେର୍‌ ହେ କାଲ୍‌ ଇନେର୍‌ ଜପି ଆର୍ନାର୍‌, ହେୱାନ୍‌ କୁଦ୍ରିକୁଦ୍ରା ଆନାର୍‌, ଆରେ ହେ କାଲ୍‌ ଇନେର୍‌ ଜପି ଆର୍ନାନ୍, ହେଦେଲିଂ ହେଦାଂ ବିରାୟ୍‌ କିନାତ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","ଇବେ ସାସ୍ତିର୍‌ ଆରି ମୁଡ଼୍‌ ମାପ୍ରୁହେବାକିନାକାର୍ ହେ ଦାପ୍ରେ ଆସ୍ତେଙ୍ଗ୍‌ ସେସ୍ଟା କିତାର୍‌, ମାତର୍‌ ହେୱାର୍‌ ମାନାୟାରିଂ ପାଣ୍ଡ୍ରା ଆତାର୍‌, ଇନାକିଦେଂକି ହେୱାନ୍‌ ହେ ଉତର୍‌ମୁଡ଼୍‌ ହେୱାରିଂ ଇଟ୍‌କାଡ଼୍‌ କିଜ଼ି ଇଞ୍ଜି ମାଚାନ୍‌ ଇଞ୍ଜି ହେୱାର୍‌ ବୁଜାତାର୍ । ");
INSERT INTO peg_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","ହେବେଣ୍ଡାଂ ହେୱାର୍‌ ଜିସୁଙ୍ଗ୍‌ ରାଜି ପାଲି କିନି କେଇଦ ଆରି ସାସନ୍‌କିନାକାନ୍‌ ସାସନ୍‌ନି ଆଦିକାର୍‌ ହେଲାୟ୍‌ କିଦେଙ୍ଗ୍‌ କାଜିଂ ଉପାୟ୍‌ ଡେକ୍‌ଚି ଜିସୁତି କାତାନି ବୁଲ୍‌ ଆହ୍‌ନି ଉଦେସ୍‌ତ ଇମ୍‌ଣାକାର୍‌ କପଟ୍‌ତାଂ ଜାର୍‌ ଜାର୍‌ତିଂ ଦାର୍ମି ଇଞ୍ଜି ଚଞ୍ଜିୟାଆନି ଚର୍କୁକାଂ ପକ୍ତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","ହେୱାର୍‌ ତାଙ୍ଗ୍‌ ୱେନ୍‍ବାତାର୍, “ଏ ଗୁରୁ, ଆପେଂ ପୁନାପ୍‌, ଏନ୍‌ ହାତ୍‌ପା ରଚେ କାତା ଇନାୟ୍‌ ଆରି ହିକ୍ୟା ହିନାୟ୍, ଆରେ ଇନେର୍‌ତି ମୁକ୍‌ମେଟ୍‌ ହୁଡ଼୍‌ଜି କିଉୟ୍, ମାତର୍‌ ହାତ୍‌ପା ଲାକେ ଇସ୍ୱର୍‌ତି ହାଜ଼ି ବିସ୍ରେ ହିକ୍ୟା ହିନାୟା । ");
INSERT INTO peg_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","ମାଙ୍ଗେଙ୍ଗ୍‌ ଇଞ୍ଜା, କାଇସର୍‌ତିଂ ସିସ୍ତୁ ହିନାକା ମା ବିଦି ମାନାତ୍‌ କି ଆକାୟ୍‌ ?” ");
INSERT INTO peg_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","ମାତର୍‌ ଜିସୁ ହେୱାର୍‌ତି କାପ୍‌ଟି ପୁଞ୍ଜି ହେୱାରିଂ ଇଚାନ୍‌, ନାଙ୍ଗ୍‌ ର ଅଦ୍‌ନି ଚଚ୍‍ଚାଟ୍ । ");
INSERT INTO peg_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“ଇବେ ଇନେର୍‌ ଟାକାଂ ପୁତ୍‌ଡ଼ା ଆରି ତର୍‌ ମାନାତ୍‌ ?” “ହେୱାର୍‌ ଇଚାର୍‌ କାଇସର୍‌ତି ।” ");
INSERT INTO peg_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","ହେବେ ଜିସୁ ହେୱାରିଂ ଇଚାନ୍‌, “ବାଟିଙ୍ଗ୍‌ କାଇସର୍‌ତି ଇମ୍‌ଣାକା, ହେଦାଂ କାଇସର୍‌ତିଂ ହିଆଟ୍, ଆରେ, ଇସ୍ୱର୍ତି ଇମ୍‌ଣାକା, ହେଦାଂ ଇସ୍ୱର୍‌ତିଂ ହିଆଟ୍ ।” ");
INSERT INTO peg_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","ଇବେଣ୍ଡାଂ ହେୱାର୍‌ ମାନାୟ୍‌ ମୁମ୍‌ଦ ହେୱାନ୍‌ କାତାତ କୁନି ଆସ୍ତେଙ୍ଗ୍‌ ଆଡ୍‌ୱାତାର୍‌, ଆରେ ହେୱାର୍‌ ହେୱାନ୍‌ ଉତର୍‌ତ କାବା ଆଜ଼ି ଚିମ୍‌ରା ଆଜ଼ି ମାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","ଇଦାଂ ପାଚେ ଆରେ ନିଂନି ବିସ୍ରେ ଉଡ଼ାନାକାର୍ କେତେକ୍‌ ସାଦୁକିର୍‌ ଜିସୁ ଲାଗେ ୱାଜ଼ି ୱେନ୍‍ବାତାର୍, ");
INSERT INTO peg_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“ଏ ଗୁରୁ, ମସା ମା କାଜିଂ ଲେକିକିତାନ୍ନା ଇନେନ୍‌, ଜଦି ଇମ୍‌ଣି ଲକୁତ ଟଣ୍ଡେନ୍‌, ଡକ୍ରି ମାଞ୍ଜି ହିମ୍‍ଣାୱାକ୍ଡ଼ା ଆୱାଦାଂ ହାତିସ୍, ତା ଆତିସ୍‌ ତା ଟଣ୍ଡେନ୍‌ ତା ଡକ୍ରୁହିଂ ଇଡ଼୍‌ଜି ଜାର୍‌ ଟଣ୍ଡେନ୍‌ କାଜିଂ ଲାତ୍ରା ଉବ୍‌ଜାଣ୍‌ କିନାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","ଦିନେକ୍‌, ସାତ୍‌ ବାୟ୍‍ ଟଣ୍ଡାର୍‌ ମାଚାର୍‌; ପର୍ତୁମ୍‌ ର କଗ୍‌ଲେଂ ବିବା ଆତାନ୍‌ ଆରି ହିମ୍‍ଣାୱାକ୍‍ଡ଼ା ଆୱାଦାଂ ହାତାନ୍‌; ");
INSERT INTO peg_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","ପାଚେ ଆରେ ମାଜିୟା ବିବା ଆତାନ୍‌ ତାଙ୍ଗ୍‌ ଇଡ୍‍ତାନ୍; ");
INSERT INTO peg_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","ହେ ଲାକେ ସାତ୍‌ ଜାଣ୍‌ ଜାକ୍‌ ହିମ୍‍ଣାୱାକ୍‍ଡ଼ା ଆୱାଦାଂ ହାତାର୍ । ");
INSERT INTO peg_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","ହାରିହାରା କଗ୍‌ଲେ ପା ହାତାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","ବାଟିଙ୍ଗ୍‌, ଆରେ ନିଂନିହିଂ ହେୱାର୍‌ ବିତ୍ରେ ହେଦେଲ୍‌ ଇନେର୍‌ ଡକ୍ରି ଆନାତ୍‌ ? ସାତ୍‌ ଜାଣ୍‌ ଜାକ ତାଙ୍ଗ୍‌ ବିବା ଆଜ଼ି ମାଚାର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","ଜିସୁ ହେୱାରିଂ ଇଚାନ୍‌, “ଇ ଜୁଗ୍‌ନି ମାନାୟାର୍‌ ବିବା କିତାର୍‌ ଆରି ବିବା ଆନିକ୍‌, ");
INSERT INTO peg_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","ମାତର୍‌ ଇମ୍‌ଣି ମାନାୟାର୍‌ ହେ ସଁସାର୍‌ ଆରି ହାତାକାର୍‌ ବିତ୍ରେ ଆରେ ନିଂନାକା ପାୟାନି କାଜିଂ ନିଜେ ଗାଣା କିୟାନାର୍‌, ହେୱାର୍‌ ବିବା କିଉର୍‌ କି ବିବା ଆଉର୍‌; ");
INSERT INTO peg_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","ଆରେ, ହେୱାର୍‌ ଆରେ ହାଦେଂ ଆଡୁର୍‌, ଇନାକିଦେଂକି ହେୱାର୍‌ ଦୁତ୍‌କୁ ଲାକେ ମାନ୍‍ଙ୍ଗାନାର୍ ଆରେ ନିଙ୍ଗ୍‌ଜି ଇସ୍ୱର୍ତି ମାଜ଼ି ଗାଡ଼୍‌ ଆନାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","ମତର୍‌ ହାତାକାର୍‌ ଜେ ନିଙ୍ଗ୍‌ନାର୍‌, ଇଦାଂ ମସା ପା ବୁଟାନି କାତା ମାପ୍ରୁତି ଅବ୍ରାହାମ୍‌ତି ଇସ୍ୱର୍‌, ଇସ୍‌ହାକ୍‌ତି ଇସ୍ୱର୍‌ ଆରି ଜାକୁବ୍‌ତି ଇସ୍ୱର୍‌ ଇଞ୍ଜି ଚଚ୍‌ଚି ହିନାର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","ହେୱାନ୍‌ ତ ହାତାକାର୍‌ ଇସ୍ୱର୍‌ ଆକାୟ୍‌, ମତର୍‌ ଜିତାକାରିଂ; ଇନାକିଦେଂକି ୱିଜ଼ାର୍‍ ହେ ମୁମ୍‌ଦ ଜିବୁନ୍‌ ପାୟା ଆନାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","ହେବେଣ୍ଡାଂ ସାସ୍ତିର୍‌ ବିତ୍ରେ କେତେକ୍‌ ଜାଣ୍‌ ଉତର୍‌ ହିତାର୍‌, “ଏ ଗୁରୁ, ଏନ୍‌ ସତ୍‌ ଇଚାୟ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","ଇନାକିଦେଂକି ହେୱାର୍‌ ତାଙ୍ଗ୍‌ ଇମ୍‌ଣି ପରସନ୍‌ ୱେନ୍‌ବେଦେଂ ସାସ୍‌ କିୱାତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","ମାତର୍‌ ହେୱାନ୍‌ ହେୱାରିଂ ୱେନ୍‌ବାତାନ୍‌, “କ୍ରିସ୍ଟ ଜେ ଦାଉଦ୍‌ ମାଜ଼ି, ଇଦାଂ ଲକୁ ଇନାକା ଇନାର୍‌ ? ");
INSERT INTO peg_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","ଇନାକିଦେଂକି ନିଜେ ଦାଉଦ୍‌ ନାନ୍ଦ୍‌ ସାସ୍ତର୍‌ କିଜ଼ି ଇନାନ୍‌, ‘ମାପ୍ରୁ ନା ମାପ୍ରୁଙ୍ଗ୍‌ ଇଚାନ୍‌, ");
INSERT INTO peg_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","ଆପେଂ ଏଚେକ୍‌ ପାତେକ୍‌ ମି ସାତ୍ରୁରିଂ ମି ତଗ୍‌ନିବାହା କିୱାତାପ୍‌ନା, ହେ ପାତେକ୍‌ ମା ବୁଜ୍‌ଣି ବାଗାଙ୍ଗ୍‌ କୁଚ୍‌ଚି ମାନାଟ୍‌ ।’ ");
INSERT INTO peg_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","ଲାଗିଂ, ଦାଉଦ୍‌ ତାଙ୍ଗ୍‌ ‘ମାପ୍ରୁ’ ଇଞ୍ଜି ଇନାନ୍‌; ବାଟିଙ୍ଗ୍‌, ହେୱାନ୍‌ ଇନେସ୍‌ ତା ମାଜ଼ି ?” ");
INSERT INTO peg_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","ପାଚେ ହେୱାନ୍‌ ସବୁଲଗାଂ ୱିଜ଼ାର୍‌ ମୁମ୍‌ଦ ଚେଲାର୍‌ ତାକେ ଇଚାନ୍‌, ");
INSERT INTO peg_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“ସାସ୍ତିର୍‌ତାଂ ଜାଗ୍ରତ୍‌ ! ହେୱାର୍‌ ଲାମା ଆଙ୍ଗି ଉସ୍ପିସ୍‌ ବୁଲାଆଦେଂ, ଆରେ ଆଟ୍‌ ବାଜାର୍‌ତ ଜୱାର୍‌, କୁଟୁମ୍‌ ଇଞ୍ଜ ମୁଡ଼୍‌ ବାହା ଆରି ବଜିତ ଆଗେନି ବାହା ୱାରିୟା ଆନାର୍‌; ");
INSERT INTO peg_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","ହେୱାର୍‌ ରାଣ୍ଡିକ୍‌ ଇଲ୍‌କୁ ସବୁ ଚରି କିନାର୍‌ ଆରି ଲାମା ପାର୍ତାନା କିନାର୍‌; ହେୱାର୍‌ ବେସି ଡାଣ୍ଡ୍‌ ପାୟା ଆନାର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","ଇଦାଂ ପାଚେ ଜିସୁ ଚାରିବେଣ୍‌ତାଂ ହୁଡ଼୍‌ଜି ପା ମାଜାନିଂ ଗାଦ୍ୟାତାକେ ଜାର୍‌ ଜାର୍‌ ଦାନ୍‌ ୱାକ୍‌ନାକା ହୁଡ଼୍‌ତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","ଆରେ, ହେୱାନ୍‌ ର ହିଲ୍‍ୱି ରାଣ୍ଡିକାଂ ହେବେ ରି ଟାକା ଡାବୁଙ୍ଗ୍‌ ଇଟ୍‍ନାକା ହୁଡ଼୍‌ଜି ଇଚାନ୍‌, ");
INSERT INTO peg_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","“ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ହାତ୍‌ପା ଇଞ୍ଜ୍‌ନାଙ୍ଗା, ଇ ହିଲ୍‍ୱି ରାଣ୍ଡି ୱିଜ଼ାକାର୍‌ତାଂ ଆଦିକ୍‌ ଇଟ୍‍ତାତ୍‍ନ୍ନା, ");
INSERT INTO peg_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","ଇନାକିଦେଂକି ଇୱାର୍‌ ୱିଜ଼ାକାର୍‌ ଗାଦ୍ୟାତାଂ ଜାର୍‌ ଜାର୍‌ ଦାନ୍ତାଙ୍ଗ୍‌ ଅଲପ୍‍ ଅଲପ୍‍ ଇଟ୍‌ତାର୍‌, ମାତର୍‌ ଇଦେଲ୍‌ ତା କସ୍ଟକିତାକା ଦାନ୍‌ ଜାର୍‌ ଜିବୁନ୍‌ ବାଚାୟ୍‌କିଦେଂ କାଜିଂ ଇଦେଲ୍‌ତି ଇନାକା ମାଚାତ୍‌, ହେ ସବୁ ଇଟ୍‌ତାତ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","କେତେଜାଣ୍‌ ଚେଲାର୍‌ “ମନ୍ଦିର୍‌ ବିତ୍ରେ ବେଣ୍‌କିଜ଼ି ମାଚାର୍‌ । ହେୱାର୍‌ ଇଞ୍ଜି ମାଚାର୍‌ ହେବେ ମେହାୟ୍‌କିଜ଼ି ମାଚି ହଲ୍‌ନି କାଲ୍‌ ଆରି ଇସ୍ୱର୍‌ ମାପ୍ରୁ କାଜିଂ ରଚ୍‌ଚି ମାଚି ଇନାମିଙ୍ଗ୍‌ ଲାହାଙ୍ଗ୍‌ ମନ୍ଦିର୍‌ ଅପ୍ରବଲ୍‌ ହଲ୍‌ନାତା ।” ");
INSERT INTO peg_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“ଏପେଙ୍ଗ୍‌ ଇ ଇନାକା ସବୁ ହୁଡ଼୍‍ନାଦେରା, ସମୁ ୱାନାତ୍‍, ଏଚେକାଡ଼୍‌ଦ ର କାଲ୍‌ ଆରେ ର କାଲ୍‌ ଜପି ମାନୁତ୍‌, ମାଚିସ୍‌ ୱିଜ଼ୁ ମେଦ୍‌ନି ଦୁଡ଼ି ମାସ୍‍ନାତ୍‍ ।” ");
INSERT INTO peg_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","ହେବେଣ୍ଡାଂ ହେୱାର୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ୱେନ୍‍ବାତାର୍‍, “ଏ ଗୁରୁ, ବାଟିଙ୍ଗ୍‌ ଇ ସବୁ ଇନାୱାଡ଼ାଂ ଗିଟା ଆନାତ୍‌ ? ଆରେ, ଇନାୱାଡ଼ାଲିଂ ଇ ସବୁ ଗଟ୍‌ଣା ଲାଗେ ଆନାତ୍‌, ହେ ସମୁନି ଇଟ୍‌କାଡ଼୍‌ ଇନାକା ?” ");
INSERT INTO peg_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","ହେବେଣ୍ଡାଂ ଜିସୁ ଇଚାନ୍‌, “ଜାଗ୍ରତ୍‌, ଏପେଙ୍ଗ୍‌ ଚାକ୍ରାୟ୍‌ କିୟାଆମାଟ୍‍; ଇନାକିଦେଂକି ହେନି ନା ତର୍‌ଦ ୱାଜ଼ି, ଆନ୍‌ ହେୱାଙ୍ଗ୍‌ ଆରି ସମୁ ଲାଗାଂ ଇଞ୍ଜି ଇଞ୍ଜ୍‌ନାର୍‌, ହେୱାର୍‌ ପାଚେ ହାଲ୍‍ମାଟ୍‍ । ");
INSERT INTO peg_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","ମାତର୍‌ ଏପେଙ୍ଗ୍‌ ଏଚେକାଡ଼୍‌ଦ ମେଲି ଆରି ଗଣ୍ଡ୍‌ଗଲ୍‌ ବିସ୍ରେ ୱେନାଦେର୍‍, ହେ କାଡ଼୍‌ଦ ପାଣ୍ଡ୍ରା ଆମାଟ୍‌; ଇନାକିଦେଂକି ଇ ସବୁ ଆତିସ୍‌ପା ପର୍ତୁମ୍‌ ଗିଟା ଆନାତ୍‌, ମାତର୍‌ ଦାପ୍ରେ ରାଜି ବୁଡାଆଉତ୍‍ ।” ");
INSERT INTO peg_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","ତା ପାଚେ ଜିସୁ ହେୱାରିଂ ଇଚାନ୍‌, “ଜାତି ବିରୁଦ୍‌ତ ଜାତି ଆରି ରାଜି ବିରୁଦ୍‌ତ ରାଜି ନିଙ୍ଗ୍‌ନାତ୍‌, ");
INSERT INTO peg_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","ଆରେ ବେସିଗାଜା ମେଦ୍‌ନି ଦାଲ୍‍କା ଆନାତ୍‌ ଆରେ ବାହା ବାହାତ ମାର୍ଡି ଆରି କାତାର୍‌ ଆର୍ନାତ୍‌, ଆରେ ବାଦାଡ଼୍‌କାଂ ବେସି ଗାଜା ବାନା ଆରି ଗାଜା ଗାଜା ଚିନ୍‌କୁ ଚଞ୍ଜିୟାନିଂ ।” ");
INSERT INTO peg_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“ମାତର୍‌ ଇ ୱିଜ଼ୁ ଗଟ୍‌ଣା ଆଗେ ଲକୁ ମିଙ୍ଗେଙ୍ଗ୍‌ ଆସ୍ତାନାର୍‌ ଆରି କୁଟୁମ୍‌ ଇଞ୍ଜ ଆରି ବନ୍ଦି ଇଞ୍ଜ ମିଙ୍ଗେଙ୍ଗ୍‌ ହେଲାୟ୍‌ କିଜ଼ି ଗିଣ୍‌ କିଦ୍‌ନାର୍‌, ଆରେ ନା ତର୍‌ କାଜିଂ ଏପେଙ୍ଗ୍‌ ରାଜା ଆରି ରାଜ୍‌ କିନାକାର୍‌ ତାକେ ଅୟା ଅନାଦେର୍‌, ");
INSERT INTO peg_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","ଇଦାଂ ମି ପାକ୍ୟା ସାକି ଆନାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","ଆୱିତିସ୍‌, ନିଜେ ପାକ୍ୟାତାଂ ଇନାକା ଉତର୍‌ ହିନାଦେର୍‍, ହେ ବିସ୍ରେ ପୁର୍ବେତାଂ ଚିତା କିୱି କାଜିଂ ଜାର୍‌ ଜାର୍‌ ମାନ୍ତ ତିର୍‌ କିୟାଟ୍‌ ! ");
INSERT INTO peg_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","ଇନାକିଦେଂକି ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ଇ ଲାକେ କାତା ଆରି ଗିଆନ୍‍ ହିଦ୍‌ନାଂ ଆୱିତିସ୍‌ ମି ୱିଜ଼ୁ ବେର୍ୟାର୍‌ ୱେଇ ମାସ୍ତେଦେଂ ଆଡ଼୍‌ଦୁର୍‍ । ");
INSERT INTO peg_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","ଆରେ ଏପେଙ୍ଗ୍‌ ଆବା ଆୟା, ଟଣ୍ଡେନ୍‌, ୱାସ୍କିନିକାର୍‍ ଆରି ବନ୍ଦୁ କୁଟୁମ୍‌ନିକାର୍‍ କାଜିଂ ପା ହେଲାୟ୍‌ ଅନାଦେର୍‌, ଆରେ ମିତାଙ୍ଗ୍ ଲକୁ ଇନେ ଇନେରିଂ ଅହ୍‌ନାର୍‌, ");
INSERT INTO peg_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","ଆରେ ନା ତର୍‌ କାଜିଂ ଏପେଙ୍ଗ୍‌ ୱିଜ଼ାକାର୍‌ ତାକେ ଗିଣ୍‌କିୟା ଅନାଦେର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","ମାତର୍‌ ମି କାପ୍‌ଡ଼ାନି ତେମୁଲ୍‌ ପା ନସ୍ଟ ଆଉତ୍‌ ! ");
INSERT INTO peg_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","ମାତର୍‌ ଏପେଙ୍ଗ୍‌ ସାସ୍‌ ମାଚିସ୍‌ ଜାର୍‌ ଜାର୍‌ ୱାସ୍କି ଲାବ୍‌ କିନାଦେର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","ମାତର୍‌ “ଏପେଙ୍ଗ୍‌ ଏଚେକାଡ଼୍‌ଦ ଜିରୁସାଲମ୍‌ ତାକେ ମେଲ୍ୟାର୍‌ତାଂ ବେଡ଼ିକିନାକା ହୁଡ଼୍‌ନାଦେର୍‌, ହେପାଦ୍‌ନା ହେଦାଂ ବାଡ଼୍‍ହାଆନାକା ଜେ ଲାଗେ, ଇଦାଂ ପୁନାଟ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","ଏଚେକାଡ଼୍‌ଦ ଇନେର୍‌ ଜିହୁଦା ରାଜିତ ମାଚିସ୍‌, ହେୱାର୍‌ ଆତିସ୍‌ପା ମାଡ଼ିତ ହନ୍‍ଚି ହାଲେର୍‍, ଆରେ, ଇନେର୍‌ ଗାଡ଼୍‌ଦ ବିତ୍ରେ ମାଚିସ୍‌, ହେୱାର୍‌ ଆତିସ୍‌ପା ହାଲେର୍‍; ଆରେ, ଇନେର୍‌ ନାସ୍‌କୁକାଂ ମାଚିସ୍‌, ହେୱାର୍‌ ଆତିସ୍‌ପା ଗାଡ଼୍‌ଦ ହଣ୍‍ମେର୍‍; ");
INSERT INTO peg_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","ଇନାକିଦେଂକି ଲେକାଆତି ବିସ୍ରେ ୱିଜ଼ୁ ଗିଟାଆନି କାଜିଂ ହେଦାଂ ଡାଣ୍ଡ୍‌ ସମୁ । ");
INSERT INTO peg_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","ହେ ୱେଡ଼ାଲିଂ ଇନେର୍‌ ଏସ୍‌ ପିସ୍ତାକା ଆରି ମାୟ୍‍ଉଟ୍‍ନି ଆୟା, ଆ, ହେୱେକ୍‌ ଦୁକ୍‌ନିକିକ୍‌ ! ଇନାକିଦେଂକି ପୁର୍ତିତ ଗାଜା ବିପତି ଆରି ଇ ଇସ୍ୱର୍‌ ଜାତି କାଜିଂ ରିସା ଗିଟା ଆନାତ୍‌, ");
INSERT INTO peg_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","ଆରେ ହେୱାର୍‌ କାଣ୍ଡା ଦାରାତ ହାନାର୍‌ ଆରି ବନ୍ଦିଆଜ଼ି ୱିଜ଼ୁ ବିନ୍‌ଜାତି ତାକେ ମେହା ଆନାର୍, ଆରେ ପାର୍ତିକିୱି ଜିହୁଦିର୍‌ତି ଦିନ୍‌ପୁରାଆୱି ପାତେକ୍‌ ଜିରୁସାଲମ୍‌ ହେୱାର୍‌ତି ପାନା ତାରେନ୍‌ ଆଜ଼ି ମାନାତ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","ଆରେ “ୱେଡ଼ା, ଲେଞ୍ଜ୍‌ ଆରି ହୁକାଙ୍ଗ୍‌ତ ଚିନ୍‌ ଚନ୍‌ଞ୍ଜାନାତ୍‌, ଆରି ପୁର୍ତିତ ଜାତି ବିତ୍ରେ ଗଡ଼୍‌ମେଲି ଆନାତ୍‌, ହାମ୍‌ଦୁର୍‌ ଆରି ଲଡ଼ି ଗାର୍ଜାନ୍‌ କାଜିଂ ହେୱାର୍‌ ବୁଦିବାଣା ଆନାର୍‌, ");
INSERT INTO peg_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","ଆରେ ପୁର୍ତି ଜପି ୱାନି ଗଟ୍‌ଣା ୱିଜ଼ୁ କାସିପା ଲକୁ ଆପ୍ରାଂ ଆନାର୍‌, ଇନାକିଦେଂକି ଆକାସ୍‌ନି ସାକ୍ତି ସବୁ ପାଣ୍ଡ୍ରା ଆନିଂ । ");
INSERT INTO peg_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","ହେ କାଡ଼୍‌ଦ ଲକୁ ମାନାୟ୍‌ ମାଜ଼ି ଗାଜା ସାକ୍ତିତାଂ ଆରି ଗାଜା ପାଣ୍‌ଦାଙ୍ଗ୍‌ ୱାନାକା ହୁଡ଼୍‌ନାଦେର୍ । ");
INSERT INTO peg_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","ମାତର୍‌ ଇ ସବୁ ଗଟ୍‌ଣା ହାଙ୍ଗ୍‌ତିସ୍‌ ଏପେଙ୍ଗ୍‌ କାପ୍‌ଡ଼ା ଜପି ହୁଡ଼ାଟ୍‌ ଆରି କାପ୍‌ଡ଼ା ତାରେନ୍‌ କିୟାଟ୍‌, ଲାଗିଂ ମିଦାଙ୍ଗ୍‌ ମୁକ୍‌ଡ଼ାନାକା ଲାଗେ ।” ");
INSERT INTO peg_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","ଆରି, ହେୱାନ୍‌ ହେୱାରିଂ ର ଉତର୍‌ମୁଡ଼୍‌ ୱେଚ୍‌ଚାନ୍‌, ତଗା ମାର୍‌, ଆରେ “ୱିଜ଼ୁ ମାର୍‌କୁ ବିସ୍ରେ ଚିନ୍ତା କିୟାଟ୍‌ ହୁଡ଼ାଟ୍‌; ");
INSERT INTO peg_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","ଏଚେକାଡ଼୍‌ଦ ହେୱାଙ୍ଗ୍‌ ଆକିଂ ଗିଲ୍‌ନିକ୍‌, ହେ ଏଚେକାଡ଼୍‌ଦ ଏପେଙ୍ଗ୍‌ ହେଦାଂ ହୁଡ଼୍‌ଜି ଜେଟ୍‌କାଡ଼୍‌ ଏକାୱାତାତ୍‌ ଇଞ୍ଜି ଜାର୍‌ ଜାର୍‌ ପୁଞ୍ଜି ମାନାଟ୍‌, ");
INSERT INTO peg_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","ହେ ଲାକେ ଏଲେଙ୍ଗ୍‌ ପା ଇ ସବୁ ଗଟ୍‌ଣା ହୁଡ଼୍‌ତିସ୍‌ ଇସ୍ୱର୍ତି ରାଜି ଏକାୱାତାତ୍‌, ଇଦାଂ ପୁନାଟ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ହାତ୍‌ପା ଇଞ୍ଜ୍‌ନାଙ୍ଗା, ଇ ୱିଜ଼ୁଗିଟାଆୱି ପାତେକ୍‌ ଇ ନେଞ୍ଜେ ୱିଗାନି ନାର୍‌ ଇନେସ୍‌ ବାନି ବୁଡା ଆଉର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","ଆକାସ୍‌ ଆରି ପୁର୍ତି ୱିଜ଼୍‌ନାତ୍‌, ମାତର୍‌ ନା ବଚନ୍‌ ସବୁ ମୁଡ଼୍‌କେ ୱିଜ଼ୁତ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","ମାତର୍‌ ଏପେଙ୍ଗ୍‌ ଜାର୍‌ ଜାର୍‌ ବିସ୍ରେ “ଜାଗ୍ରତ୍‌ ଆଜ଼ି ମାନାଟ୍‌, ଏଚେକାଡ଼୍‌ଦ ନି ମାନ୍‌ମୁଞ୍ଜ୍‍ନାକା ଆରି କାଲିଂ ଗହନାକାତ, ଆରେ ଜିଦେଂ କାଜିଂ ଚିନ୍ତାତ ତେରେ ପେତେ ଆନାତ୍‌, ଆରି ହେ ଦିନ୍‌ ହାଚାଟ୍ରେ ମି ଜପି ଆର୍ନାତ୍‌; ");
INSERT INTO peg_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","ଇନାକିଦେଂକି ହାଦାଙ୍ଗ୍ ଡ଼ୁକା ଲାକେ ସବୁ ପୁର୍ତିନି ଲକୁ ୱିଜ଼ାକାର୍‌ ଜପି ୱାନାତ୍‍ । ");
INSERT INTO peg_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","ମାତର୍‌ ଏପେଙ୍ଗ୍‌ ଇନେସ୍‌ ଇ ସବୁ ୱାନି ଦିନ୍‌ ଗଟ୍‌ଣାତାଂ ରାକ୍ୟା ପାୟା ଆଦେଂ ଆରି ମାନାୟ୍‌ ମାଜ଼ି ଲାଗେ ନିଲ୍‌ତେଂ ବାଚିକିୟା ଆଡୁ, ଇଦାଂ କାଜିଂ ନିତ୍ରେ ପାର୍ତାନା କିଜ଼ି କାସି ମାନାଟ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","ହେୱାନ୍‌ ନିତ୍ରେ ମନ୍ଦିର୍‌ତ ହିକାଇ କିଜ଼ି ମାଚାନ୍‌, ଆରେ ନିତ୍ରେ ନାଣା ହସି ହାଲ୍‌ଜି ଜିତ୍‌ମାଡ଼ିତ ମାନ୍‌ଞ୍ଜି ମାଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","ଆରି, ୱିଜ଼ୁଲଗୁ ମନ୍ଦିର୍‌ତ ହେୱାନ୍ତି ହିକ୍ୟା ୱେନ୍ଞ୍ଜେଙ୍ଗ୍ ଉଟ୍‌ଲା ହାକାଡ଼େ ହେୱାନ୍‌ତାକେ ୱାଜ଼ି ମାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","ନିସ୍ତାର୍‌ ପାର୍ବୁ ତର୍‌ ହଇୱିରୁଟି ନି ପାର୍ବୁ ଲାଗାଂ ଆଜ଼ି ୱାଜ଼ି ମାଚାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","ଆରି, ମୁଡ଼୍‌ ମାପ୍ରୁହେବାକିନାକାର୍‌ ଆରି ସାସ୍ତିର୍‌, ଇନେସ୍‌ ଜିସୁଙ୍ଗ୍‌ ଡ଼ୁଗ୍‌ଜି ଅସ୍ତେଙ୍ଗ୍‌ ଆଡ୍‌ନାର୍‌, ହେବେଣ୍ଡାଂ ଉପାୟ୍‌ ଡେକ୍‌ଚି ମାଚାର୍‌, ଇନାକିଦେଂକି ହେୱାର୍‌ ମାନାୟ୍‌ତିଂ ପାଣ୍ଡ୍ରା ଆଜ଼ି ମାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","ହେୱାଡ଼ାଂ ବାରଜାଣ୍‌ ଚେଲାର୍‌ ବିତ୍ରେ ଇସ୍କାରିୟତିୟ ଇନି ଜିହୁଦା ତାକେ ସୟ୍‌ତାନ୍‌ ହଟାତ୍; ");
INSERT INTO peg_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","ଆରି, ହେୱାନ୍‌ ହାଲ୍‌ଜି, ଇନେସ୍‌ ଉପାୟ୍‍ତ ହେୱାନିଂ ମୁଡ଼୍‌ ମାପ୍ରୁହେବାକିନାକାର୍‌ ତାକେ ଆରି ମେଲ୍ୟାର୍‌ କେଇଦ ହେଲାୟ୍‌ କିଦେଙ୍ଗ୍‌ ଆଡ୍‌ନାନ୍‌, ହେଦାଂ ହେୱାର୍‌ ହୁକେ ବେଣ୍‌ କିତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","ହେବେ ତାଙ୍ଗ୍‌ ହେୱାର୍‌ ୱାରିୟା ଆତାର୍‌ ଆରି ହେୱାନିଂ ଟାକାଂ ହିଦେଂ ଗଜା କିତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","ଆରି ହେୱାନ୍‌ ରାଜି ଆଜ଼ି ଜିସୁଙ୍ଗ୍‌ ଆସ୍ତାର୍‌ ହେୱାନିଂ ହେୱାର୍‌ କେଇଦ ହେଲାୟ୍‌ କିଦେଙ୍ଗ୍‌ କାଜିଂ ଡେକ୍‌ଚି ମାଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","ପାଚେ ଇମ୍‌ଣି ଦିନ୍‌ ନିସ୍ତାର୍‌ ପାର୍ବୁନି ମେଣ୍ଡା ପୁଜାକିଦେଙ୍ଗ୍‌ ଲାଗ୍‌ଦାନାତ୍‌, ହଇୱି ରୁଟିନି ପାର୍ବୁ ହେ ଦିନ୍‌ ଏକାୱାତାତ୍‌; ");
INSERT INTO peg_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","ଆରେ, ହେୱାନ୍‌ ପିତର୍‌ ଆରି ଜହନ୍‌ତିଂ ଇଦାଂ ଇଞ୍ଜି ପକ୍‌ତାନ୍‌, ଆସେଙ୍ଗ୍‌ ଇନେସ୍‌କି ତିନ୍‌ଞ୍ଜେଙ୍ଗ୍‌ ଆଡ୍‌ନାସ୍‌, ଇଦାଂ କାଜିଂ “ଏପେଙ୍ଗ୍‌ ହାଲ୍‌ଜି ମା କାଜିଂ ନିସ୍ତାର୍‌ ପାର୍ବୁ ବଜି ଜାଲ୍‌ଦି କିୟାଟ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","ହେବେତାଂ ହେୱାର୍‌ ହେୱାନିଂ ୱେନ୍‍ବାତାର୍‍, “ଆସେଙ୍ଗ୍‌ ଇଦାଂ ଇମ୍‌ଣି ବାହାତ ଜାଲ୍‌ଦି କିନାପ୍‌ ଇଞ୍ଜି ଏନ୍‌ ଇଚା କିନାୟ୍‌ ?” ");
INSERT INTO peg_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","ଜିସୁ ହେୱାରିଂ ଇଚାନ୍‌, “ହୁଡ଼ାଟ୍‌ ଏପେଙ୍ଗ୍‌ ଗାଡ଼୍‌ଦ ହଟିସ୍‍, ଏସ୍‍ ଗାଗ୍ରି ଅଜ଼ି ହାନି ରକାନ୍‌ ମାନାୟ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ବେଟାଆଦ୍‌ନାନ୍‌; ହେୱାନ୍‌ ଇମ୍‌ଣି ଇଞ୍ଜ ହଣାନ୍‍, ହେୱାନ୍‌ ପାଚେ ପାଚେ ହେ ଇଞ୍ଜ ହାଲ୍‌ଜି ଇଲ୍‌ନି ମୁଣିକାଙ୍ଗ୍ ଇନାଦେର୍‌, ");
INSERT INTO peg_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","‘ଗୁରୁ ନିଙ୍ଗେଙ୍ଗ୍‌ ୱେନ୍‍ବାଆଦ୍ନାନା, ଆନ୍‌ ନା ଚେଲାର୍‌ ଲାହାଙ୍ଗ୍‌ ଇମେତାକେ ନିସ୍ତାର୍‌ ପାର୍ବୁ ତିଞ୍ଜେଙ୍ଗ୍‌ ମାନି କିନାପ୍‌, ହେ ଗତାଙ୍ଗ୍ ଇଲ୍‌ ଇମେତ୍‌ ?’ ");
INSERT INTO peg_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","ହେବେତାଂ ହେୱାନ୍‌ ମିଦାଙ୍ଗ୍‌ ହାର୍‍କିଜ଼ି ଜାଲ୍‌ଦି କିତି ଜପ୍‌ଣି ଗାଜା ବାକ୍ରା ଚଚ୍‍ଚାନାନ୍‍, ହେ ବାହାତ ଜାଲ୍‌ଦି କିୟାଟ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","ଆରେ, ହେୱାର୍‌ ହାଲ୍‌ଜି, ଜିସୁ ହେୱାରିଂ ଇନେସ୍‌ ଇଞ୍ଜି ମାଚାନ୍‌, ହେ ଲାକେ ହୁଡ଼୍‌ଜି ନିସ୍ତାର୍‌ ପାର୍ବୁନି ବଜି ଜାଲ୍‌ଦି କିତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","ଆରେ, ସମୁ ଏକାୱାତିଲେ, ହେୱାନ୍‌ ବାରଜାଣ୍‌ ପକ୍ୟାତାକାର୍‌ ହୁକେ ଚିଞ୍ଜେଙ୍ଗ୍‌ କୁଚ୍‌ଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","ଆରେ, ଜିସୁ ହେୱାରିଂ ଇଚାନ୍‌, “ନା ଦୁକ୍‌ ଆଗେ ଆନ୍‌ ମି ହୁକେ ଇ ନିସ୍ତାର୍‌ ବଜି ମାନି କିଦେଙ୍ଗ୍‌ ମାନ୍ତ ଇଚା କିତାଙ୍ଗ୍‌; ");
INSERT INTO peg_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","ଇନାକିଦେଂକି ମିଙ୍ଗେଙ୍ଗ୍‌ ଇଞ୍ଜ୍‌ନାଙ୍ଗା, ମାପ୍ରୁତି ରାଜିତ ଇଦାଂ ଅରତ୍‌ ହାତ୍‌ପା ପୁରା ଆୱି ପାତେକ୍‌ ଆନ୍‌ ଆରେ ଇନାୱାଡ଼ାଂ ପା ମାନି କିଉଙ୍ଗ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","ଆରେ, ହେୱାନ୍‌ ଗିଲାସ୍‌ ଅଜ଼ି ଜୁୱାର୍‌ କିଜ଼ି ହିଜ଼ି ଇଚାନ୍‌, “ଇଦାଂ ଅଜ଼ି ଜାର୍‌ ଜାର୍‌ ବିତ୍ରେ ବାଗ୍‌ କିୟାଟ୍‌,” ");
INSERT INTO peg_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","ଇନାକିଦେଂକି ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ଇଞ୍ଜ୍‌ନାଙ୍ଗା, ମାପ୍ରୁ ରାଜି ୱାୱି ପାତେକ୍‌ ଆନ୍‌ ଅଙ୍ଗୁର୍‌ ରାସ୍‌ ନେଞ୍ଜେଙ୍ଗ୍‌ ତାଙ୍ଗ୍ ଇଦାଂ ଆରେ ଉଣୁଙ୍ଗ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","ଆରେ, ହେୱାନ୍‌ ରୁଟି ଅଜ଼ି ଜୱାର୍‌ କିଜ଼ି ଆରି ହେଦାଂ ଡ୍ରିକ୍‌ଚି ହେୱାରିଂ ହିଜ଼ି ଇଚାନ୍‌, “ମି କାଜିଂ ହିତି ନା ଗାଗାଡ଼୍‌ ଇଦାଂ, ନାଙ୍ଗେଙ୍ଗ୍‌ ଏତୁ କିଦେଙ୍ଗ୍‌ ଇଦାଂ କିୟାଟ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","ଚିଚି ପାଚେ ହେ ଲାକେ ହେୱାନ୍‌ ଗିଲାସ୍‌ ଅଜ଼ି ଇଚାନ୍‌, “ଇ ଗିଲାସ୍‌ ମି କାଜିଂ ରଚ୍‌ଚି ମାନି ନା ନେତେର୍‌ତାଂ ରଚ୍‌ଚି ପୁନି ନିୟମ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","ମାତର୍‌ ହୁଡ଼ାଟ୍‌, “ଇନେର୍‌ ନାଙ୍ଗେଙ୍ଗ୍‌ ସତ୍ରୁ କେଇଦ ହେଲାୟ୍‌ କିଦ୍‍ନ୍ନା, ତା କେଇ ନା ଲାହାଙ୍ଗ୍‌ ଟେବୁଲ୍‍ ଜପି ମାନାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","ଇନାକିଦେଂକି ଇନେସ୍‌ ତିର୍‌ ଆତାତ୍‌ନ୍ନା, ମାନାୟ୍‌ ମାଜ଼ି ହେ ଲାକେ ହାକି ପାୟା ଆନାନ୍‌, ମାତର୍‌ ଇମ୍‌ଣି ମାନାୟ୍‌ତିଂ ହେୱାନ୍‌ ସତ୍ରୁ କେଇଦ ହେଲାୟ୍‌ କିୟା ଆନାନ୍‌, ହାୟ୍‍ ଡାଣ୍ଡ୍‌ ପାୟା ଆନାନ୍‌ !” ");
INSERT INTO peg_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","ଲାଗିଂ “ହେୱାର୍‌ ବିତ୍ରେ ଇନେର୍‌ ଇଦାଂ କିଦେଙ୍ଗ୍‌ ହାନାରା, ହେ ବିସ୍ରେ ହେୱାର୍‌ ହେୱାର୍‌ ୱେଚ୍‍ପା ଆଦେଂ ଲାଗାତାର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","ଆରେ, ହେୱାର୍‌ ବିତ୍ରେ ଇନେର୍‌ ଗାଜା, ହେ ବିସ୍ରେ କେତ୍‍ପା ଆତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","ହେବେତାଂ ହେୱାନ୍‌ ହେୱାରିଂ ଇଚାନ୍‌, “ପାର୍ତିକିୱି ଜିହୁଦିର୍‌ ରାଜାର୍‌ ହେୱାର୍‌ ଜପି ଆଦିକାର୍‌ କିତାର୍‌, ହେୱାର୍‌ ଲକୁ ହେବାନିକାର୍‌ ଇଞ୍ଜି ପୁଟାଆନାର୍‍ । ");
INSERT INTO peg_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","ମାତର୍‌ ଏପେଙ୍ଗ୍‌ ହେ ଲାକେ ଆମାଟ୍‌, ମତର୍‌ ମି ବିତ୍ରେ ଇନେର୍‌ ଗାଜାକାନ୍‌, ହେୱାନ୍‌ ହାରୁକାନ୍‍ ଲାକେ ଆୟେନ୍‌, ଆରି ଇନେର୍‌ ନେତା, ହେୱାନ୍‌ ହେବାକାର୍‌ୟା ଲାକେ ଆୟେନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","ଇନାକିଦେଂକି ଇନେର୍‌ ଗାଜାକାନ୍‌ ? ଇନେର୍‌ ଚିଞ୍ଜେଙ୍ଗ୍‌ କୁଚ୍‌ଚାନ୍ନା, କି ଜେ ହେବାକାର୍‌ୟା ? ଇନେର୍‌ ଚିଞ୍ଜେଙ୍ଗ୍‌ କୁଚ୍‌ଚାକାନ୍‌ ହେୱାନ୍‌ କି ଗାଜାକାନ୍‌ ଆକାୟ୍‌ ? ମାତର୍‌ ଆନ୍‌ ମି ବିତ୍ରେ ରକାଂ ହେବାକାର୍‌ୟା ଲାକେ ମାନାଂ ।” ");
INSERT INTO peg_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","ମାତର୍‌ “ଏପେଙ୍ଗ୍‌ ନା ୱିଜ଼ୁ ପରିକ୍ୟାତ ନା ଲାହାଙ୍ଗ୍‌ ମାନ୍‌ଞ୍ଜି ୱାନାଦେରା; ");
INSERT INTO peg_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","ଲାଗିଂ ନା ଆବା ରାଜି ରଚ୍‍ଚାନ୍ନା, ଆନ୍‌ ପା ହେ ଲାକେ ମି କାଜିଂ ରଚ୍‍ନାଙ୍ଗା, ");
INSERT INTO peg_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","ଇନେସ୍‌କି ଏପେଙ୍ଗ୍‌ ନା ରାଜିତ ନା ଟେବୁଲ୍‍ତ ତିନ୍‌ଞ୍ଜି ଉଣ୍‌ଜି କିନାଦେର୍‌, ଆରେ ଗାଦିତ କୁଚ୍‌ଚି ଇସ୍ରାଏଲ୍‌ନି ବାର କୁଟୁମ୍‌ତିଂ ରାଜ୍‌ କିନାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","“ସିମନ୍‌, ସିମନ୍‌, ହୁଡ଼ା କାମ୍‌ଲିୟା, ଗଁମ୍‌ତିଂ ପୁଟା ଆଲ୍‌ଗା କିଦେଙ୍ଗ୍‌ ଇଞ୍ଜି ହାଣେଲ୍‍ତ ଚାଲାୟ୍‍କିନି ଲାକେ ସୟ୍‌ତାନ୍‌ ପା ହାର୍‌ଦିମାନାୟାର୍‌ତାଂ ବାନିୟାରିଙ୍ଗ୍‌ ଆଲ୍‌ଗା କିଦେଙ୍ଗ୍‌ ଇଞ୍ଜି ମିଙ୍ଗେଙ୍ଗ୍‌ ପରିକ୍ୟା କିଦେଙ୍ଗ୍‌ ଆଦିକାର୍‌ ପାୟାଆତାଂନ୍ନା; ");
INSERT INTO peg_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","ମାତର୍‌ ନି ପାର୍ତି କିନାକା ଇନେସ୍‌ ଡ଼ୁଗୁତ୍‍, ଇଦାଂ କାଜିଂ ଆନ୍‌ ନି ହୁଦାଂ ପାର୍ତାନା କିତାଙ୍ଗ୍‌; ଆରେ, ଏନ୍‌ ଲେଉଟା ଆଜ଼ି ୱାନିହିଂ ଜାର୍‌ ଟଣ୍ଡାରିଂ ସୁସ୍ତା କିୟା ।” ");
INSERT INTO peg_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","ମାତର୍‌ ହେୱାନ୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ଇଚାନ୍‌, “ଏ ମାପ୍ରୁ, ଆନ୍‌ ନି ଲାହାଙ୍ଗ୍‌ ବନ୍ଦି ଇଞ୍ଜ ହାଞ୍ଜେଙ୍ଗ୍‌ ଆରି ହାଦେଂ ଜାଲ୍‌ଦି ଆତାଙ୍ଗ୍‌ନା ।” ");
INSERT INTO peg_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","ମାତର୍‌ ହେୱାନ୍‌ ଇଚାନ୍‌, “ଏ ପିତର୍‌, ଆନ୍‌ ନିଙ୍ଗେଙ୍ଗ୍‌ ୱେଚ୍‍ଚାନାଙ୍ଗା, ନେଞ୍ଜେଙ୍ଗ୍‌ କୁଜ଼ୁ କ୍ଡେନିହିଂ ଆଗେ ଏନ୍‌ ଜେ ପୁଞ୍ଜ୍‌ନାୟ୍‍, ଇଦାଂ ତିନିହଟ୍‌ ପାର୍ତି କିଦୁୟ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","ଆରେ, ହେୱାନ୍‌ ହେୱାରିଂ ଇଚାନ୍‌, “ଏଚେକାଡ଼୍‌ଦ ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ବାଡି, ମଣା ଆରି କାଣ୍ଡା ପାଣ୍ଡାଇଙ୍ଗ୍‌ ତୁସ୍‍ୱାଦାଙ୍ଗ୍ ପକ୍‌ଚି ମାନ୍‍ଞ୍ଚାଙ୍ଗ୍, ହେୱାଡ଼ାଂ ମିଦାଙ୍ଗ୍‌ ଇନାକା ଅବାବ୍‌ ଆଜ଼ି ମାଚାତ୍‌ ?” ହେୱାର୍‌ ଇଚାର୍‌, ଇନାକା “ଆକାୟ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","ହେବେତାଂ ହେୱାନ୍‌ ହେୱାରିଂ ଇଚାନ୍‌, “ମାତର୍‌ ନଙ୍ଗ୍‌, ଇନେର୍‌ତି ବାଡି ମାନାତ୍‌, ହେୱାନ୍‌ ହେଦାଂ ଅୱେନ୍‍, ହେ ଲାକେ ମଣା ପା ଅୱେନ୍‍, ଆରି ଇନେର୍‌ତି ହିଲୁତ୍‍, ହେୱାନ୍‌ ହେ ହେନ୍ଦ୍ରା ରଞ୍ଜାଙ୍ଗ୍‌ ପ୍ରସି କାଣ୍ଡା କଡ଼େନ୍‍ ।” ");
INSERT INTO peg_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","ଇନାକିଦେଂକି ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ଇଞ୍ଜ୍‌ନାଙ୍ଗା, “ହେୱାନ୍‌ ଅଦାର୍ମିର୍‌ ଲାହାଂ ଗାଣାକିୟା ଆତାନ୍‌,” ଇ କାତା ଲେକା ଆତାତ୍‌ନ୍ନା, “ହେଦାଂ ନା ତାକେ ପୁରାଆନାକା ମାନାତ୍‌; ଲାଗିଂ ନା ବିସ୍ରେ ପୁରା ଆତାତ୍‌ନ୍ନା ।” ");
INSERT INTO peg_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","ହେବେତାଂ ହେୱାର୍‌ ଇଚାର୍‌, ମାପ୍ରୁ, ହୁଡ଼ା, “ଇବେ ରିଣ୍ଡାଂ କାଣ୍ଡାଙ୍ଗ୍‌ ମାନିକ୍‌ । ଆରେ, ହେୱାନ୍‌ ହେୱାରିଂ ଇଚାନ୍‌, ଏଚେକ୍‌ନେ ସାରି ।” ");
INSERT INTO peg_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","ଜିସୁ ଗାଡ଼୍‌ଦାଂ ହସି ଜାର୍‌ ରିତି ହୁକେ ଜିତ୍‌ମାଡ଼ିତ ହାଚାର୍‌, ଆରି ଚେଲାର୍‌ ପା ତା ପାଚେ ପାଚେ ହାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","ହେ ବାହାତ ଏକିସ୍‌ ଜିସୁ ହେୱାରିଂ ଇଚାନ୍‌, “ପରିକ୍ୟାତ ଇନେସ୍‌ ଆର୍‌ମାଟ୍‌, ଇଦାଂ କାଜିଂ ପାର୍ତାନା କିୟାଟ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","ଆରେ, ହେୱାନ୍‌ ହେୱାର୍‌ ଆନ୍‌ମାନ୍‌ତାଂ ପାଞ୍ଚ୍‌କଡ଼ି ଆତ୍‍ତାଂ ଦେହା ହାଲ୍‌ଜି ମେଣ୍ଡାଙ୍ଗ୍‌ କୁନ୍ଦିକିଜ଼ି ଇ ପାର୍ତାନା କିଦେଙ୍ଗ୍‌ ଲାଗାତାର୍‌, ");
INSERT INTO peg_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“ଏ ଆବା,” ଜଦି ନି ଇଚା ମାନାତ୍‌ ଲାଗିଂ “ଇ ଦୁକ୍‌ ନା ତାଙ୍ଗ୍‌ ଦେହା କିୟା, ଆତିସ୍‌ ପା ନା ଇଚା ଆକାୟ୍‌, ମାତର୍‌ ନି ଇଚା ପୁରା ଆୟେତ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","ଆରେ, ସାର୍ଗେତାଂ ର ଦୁତ୍‌ ଚଞ୍ଜ୍‌ୟା ଆଜ଼ି ତାଙ୍ଗେଙ୍ଗ୍‌ ସାକ୍ତି ହିତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","ଆରେ, ଜିସୁ ମାନ୍‌ ବିତ୍ରେ ଦୁକ୍‍ତାଂ ଡ୍ରିଙ୍ଗ୍‍ଜି ପାର୍ତାନା କିଦେଙ୍ଗ୍‌ ଲାଗାତାନ୍‌ ଆରି ତା ରୁମିଙ୍ଗ୍ ନେତେର୍‌ ଲାକେ ମେଦ୍‌ନିତ ଆର୍‌ତିକ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","ଆରେ, ହେୱାନ୍‌ ପାର୍ତାନାତାଙ୍ଗ୍‍ ନିଙ୍ଗ୍‌ଜି ଚେଲାର୍‌ ଲାଗାଂ ୱାଜ଼ି ହେୱାରିଂ ଦୁକ୍‌ କାଜିଂ ହୁନ୍‌ଞ୍ଚାକାରିଂ ହୁଡ଼୍‌ତାନ୍‌; ");
INSERT INTO peg_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","ଆରେ, ହେୱାନ୍‌ ହେୱାରିଂ ଇଚାନ୍‌, “ଇନେକିଦେଂ ହୁଞ୍ଜ୍‌ନାଦେରା ? ପରିକ୍ୟାତ ଇନେସ୍‌ ଆର୍‌ମାଟ୍‌, ଇଦାଂ କାଜିଂ ନିଙ୍ଗ୍‌ଜି ପାର୍ତାନା କିୟାଟ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","ଜିସୁ କାତା ଇନିୱାଡ଼ାଂ, ହୁଡ଼ାଟ୍‌ ଲକୁ ୱାଜ଼ି ଏକାୱାତାର୍‌, ଆରି ବାରଜାଣ୍‌ ବିତ୍ରେ ଜିହୁଦା ଇନି ରକାନ୍‌ ହେୱାର୍‌ ଆଗେ ଆଗେ ୱାଜ଼ି ଜିସୁଙ୍ଗ୍‌ ଡନ୍‍ଞ୍ଜେଙ୍ଗ୍ ହେ କଚଣ୍‌ତ ହାଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","ମାତର୍‌ ଜିସୁ ହେୱାନିଂ ଇଚାନ୍‌, “ଏ ଜିହୁଦା ଡନ୍‌ଞ୍ଜି ପା ମାନାୟ୍‌ ମାଜ଼ି ସତ୍ରୁ କେଇଦ ହେଲାୟ୍‌ କିଦ୍‍ନାୟା ?” ");
INSERT INTO peg_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","ଇବେଣ୍ଡାଂ ଇନାକା ଗିଟା ଆନାତ୍‌, ହେଦାଂ ହୁଡ଼୍‌ଜି ହାଙ୍ଗ୍‍ଦାକାର୍‍ ଇଚାର୍‌, “ମାପ୍ରୁ, ଆପେଂ ଇନାକା କାଣ୍ଡାତ କାତ୍‍ନାପ୍‌ ?” ");
INSERT INTO peg_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","ଆରେ, ହେୱାର୍‌ ବିତ୍ରେ ରକାନ୍‌ ମୁଡ଼୍‌ ମାପ୍ରୁହେବାକିନାକାନ୍‌ ଆଡ଼ିୟାଙ୍ଗ୍‌ ମାଟ୍‍କିଜ଼ି ହେ ତିନି କିତୁଲ୍‌ ରାସ୍‌ଦି ତୁହିତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","ମାତର୍‌ ଜିସୁ ଉତର୍‌ ହିତାନ୍‌, “ଏଚେକ୍‌ ହୁନ୍‌ଜି ମାନାଟ୍‌,” ଆରେ, ହେୱାନ୍‌ ହେ କିତୁଲ୍‌ ଡୁଜ଼ି ତାଙ୍ଗେଙ୍ଗ୍‌ ଉଜ୍‌ କିତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","ଆରେ, ଜିସୁ ହେୱାନ୍ତି ବିରୁଦ୍‌ତ ୱାଜ଼ି ମାଚି ମୁଡ଼୍‌ ମାପ୍ରୁହେବାକିନାକାର୍‌, ମନ୍ଦିର୍‌ନି ମୁଡ଼୍‍ଜାମାନ୍‍ ଆରି ବୁଡ଼ାଲୁରିଂ ଇଚାର୍‌, “ଚର୍କୁ ବିରୁଦ୍‌ତ ହତି ଲାକେ କାଣ୍ଡା ଆରି ଟେଙ୍ଗା ଆଜ଼ି ଏପେଙ୍ଗ୍‌ ଇନାକା ହସି ୱାତାଦେର୍ଣ୍ଣା ? ");
INSERT INTO peg_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","ଆନ୍‌ ନିତ୍ରେ ମି ହୁକେ ମନ୍ଦିର୍‌ତ ମାନିୱେଡ଼ାଲିଂ ଏପେଙ୍ଗ୍‌ ନା ବିରୁଦ୍‌ତ କେଇ କିଦ୍‌ୱାତାଦେର୍‌, ମାତର୍‌ ଇଦାଂ ମି ସମୁ ଆରି ମାଜ୍‍ଗାନି ଆଦିକାର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","ପାଚେ ହେୱାର୍‌ ହେୱାନିଂ ଆସ୍ତି ଅଜ଼ି ମୁଡ଼୍‌ ମାପ୍ରୁହେବା କିନାକାର୍‌ ଇଞ୍ଜ ତାହିୱାତାର୍‌; ମାତର୍‌ ପିତର୍‌ ଦେହା ମାନ୍‌ଞ୍ଜି ପାଚେ ପାଚେ ହାଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","ଆରେ, ହେୱାର୍‌ ହାକ୍‌ଡ଼ିନି ମାଦି ବାହାତ ନାଣି ତୁବ୍‍ଜି ରଚେ କୁଚ୍‌ଚିଲେ, ପିତର୍‌ ହେୱାର୍‌ ମାଦି କୁଚ୍‌ଚି ମାଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","ରଞ୍ଜେଲ୍‌ ଆଡ଼ିଏଣି ହେୱାନ୍‌ ନାଣି ଲାଗାଂ କୁଚ୍‌ଚି ମାନାକା ହୁଡ଼୍‌ଜି ହେୱାନିଂ ଇଟ୍‌କାଡ଼୍‌ କିଜ଼ି ହୁଡ଼୍‌ଜି ଇଚାତ୍‌, “ଇୱାନ୍‌ ପା ହେୱାନ୍‌ ହୁକେ ମାଚାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","ମାତର୍‌ ପିତର୍‌ ପାର୍ତି କିୱାଦାଂ ଇଚାନ୍‍, “ଏ ଆୟାତାଡ଼ି, ଆନ୍‌ ହେୱାନିଂ ପୁନୁଙ୍ଗ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","ଅଲପ୍‍ ସମୁ ପାଚେ ଆରି ରଞ୍ଜେଲ୍‌ ହେୱାନିଂ ହୁଡ଼୍‌ଜି ଇଚାତ୍‌, “ଏନେଙ୍ଗ୍‌ ପା ହେୱାର୍‌ ବିତ୍ରେ ରକାୟ୍‌ ।” ମାତର୍‌ ପିତର୍‌ ଇଚାନ୍‌, “ଆକାୟ୍‌, ଟଣ୍ଡେନ୍‌, ଆନ୍‌ ଆକାୟ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","ର ଗଣ୍ଟା ପାଚେ ରକାନ୍‌ ଆଟ୍‌ୱା କିଜ଼ି ଇଞ୍ଜେଙ୍ଗ୍‌ ଲାଗାତାନ୍‌, “ଇ ମାନାୟ୍‌ ପା ହାତ୍‌ପାନେ ତା ହୁକେ ମାଚାନ୍‌, ଇନାକିଦେଂକି ହେୱାନ୍‌ ରକାନ୍‌ ଗାଲିଲିୟ ମାନାୟ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","ମାତର୍‌ ପିତର୍‌ ଇଚାନ୍‌, “ଟଣ୍ଡେନ୍‌, ଏନ୍‌ ଇନାକା ଇନାୟା, ଆନ୍‌ ହେଦାଂ ପୁନୁଙ୍ଗ୍‌ ।” ହେ ଦାପ୍ରେ ହେୱାନ୍‌ କାତା ଇନୁ ଇନୁ କୁଜ଼ୁ କ୍ଡେତାତ୍‌, ");
INSERT INTO peg_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","ଆରେ ମାପ୍ରୁ ପିତର୍‌ତିଂ ର କାଣ୍‌କୁତ ହୁଡ଼୍‌ତାନ୍‌; ହେବେ “ନେଞ୍ଜେଙ୍ଗ୍‌ କୁଜ଼ୁ କ୍ଡେନି ଆଗେ ଏନ୍‌ ନାଙ୍ଗେଙ୍ଗ୍‌ ତିନି ହଟ୍‌ ପାର୍ତି କିଦୁୟ୍‌,” ଇଦାଂ ଇମ୍‌ଣି କାତା ମାପ୍ରୁ ପିତର୍‌ତିଂ ଇଞ୍ଜି ମାଚାନ୍‌, ");
INSERT INTO peg_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","ହେଦାଙ୍ଗ୍ ତା ମାନ୍ତ ୱାତାତ୍‍, ଆରି ହେୱାନ୍‌ ବାର୍ତ ହାଲ୍‌ଜି ବେସି ତାନ୍ଦ୍ରା ଆଜ଼ି ଆଡ଼୍‌ବାତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","ଆରେ, ଇମ୍‌ଣି ମାନାୟାର୍‌ ଜିସୁଙ୍ଗ୍‌ ଆସ୍ତି ଇଡ଼୍‌ଜି ମାଚାର୍‌, ହେୱାର୍‌ ହେୱାନିଂ ମାଡ଼୍‌ଜି କିଉ କିଉ ଲାଜୁ କିତାର୍‌, ");
INSERT INTO peg_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","ଆରେ ହେ ମୁମ୍‌ଦ ପାଡ଼ାକ୍‍ଚି ହେୱାନିଂ ୱେନ୍‍ବେଦେଂ ଲାଗାତାର୍‌, “ଏନ୍‌ କିନ୍ଦା ବେଣ୍‌ବାକ୍‌ଣାୟ୍‌ କିନାକାୟ୍‌ ! ଇନାତ, ଇନେର୍‌ ନିଙ୍ଗେଙ୍ଗ୍‌ ମାଟ୍‍କିତ୍‍ତାର୍‍ ?” ");
INSERT INTO peg_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","ଆରେ, ହେୱାର୍‌ ଆଦିକ୍‌ ବେସି କାତା ହେୱାନ୍‌ ବିରୁଦ୍‌ତ ଇଞ୍ଜି ହେୱାନିଂ ନିନ୍ଦା କିଦେଙ୍ଗ୍‌ ଲାଗାତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","ଅଜଡ଼୍‌ ଆତି ଦାପ୍ରେ ମାନାୟାର୍‌ତି ପ୍ରାଚିନାର୍‌, ଆରେ ମୁଡ଼୍‌ ମାପ୍ରୁହେବାକିନାକାର୍‌ ଆରି ସାସ୍ତିର୍‌ ରୁଣ୍ଡା ଆଜ଼ି ଜାର୍‌ତିଂ ଗାଜା ମିଟିଙ୍ଗ୍‌ତାଂ ଅଜ଼ି ଇଚାର୍‌, “ଏନେଙ୍ଗ୍‌ ଜଦି କ୍ରିସ୍ଟ, ତେବେ ମାଙ୍ଗେଙ୍ଗ୍‌ ୱେଚ୍‌ଚା ।” ");
INSERT INTO peg_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","ମାତର୍‌ ଜିସୁ ହେୱାରିଂ ଇଚାନ୍‌, “ଆନ୍‌ ଜଦି କ୍ରିସ୍ଟ ମିଙ୍ଗେଙ୍ଗ୍‌ ଇଞ୍ଜ୍‌ନାଙ୍ଗ୍‌, ଏପେଙ୍ଗ୍‌ ତ ପାର୍ତି କିଉଦେର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","ଆରେ, ଆନ୍‌ ୱେନ୍‌ବା ଆତିସ୍‌, “ଏପେଙ୍ଗ୍‌ ଉତର୍‌ ହିଉଦେର୍‍ ।” ");
INSERT INTO peg_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","ମାତର୍‌ ନଙ୍ଗ୍‌ତାଂ ମାନାୟ୍‌ ମାଜ଼ି ଇସ୍ୱର୍ତି ସାକ୍ତିତାଂ ବୁଜ୍‌ଣି ବାଗାଙ୍ଗ୍‌ କୁଚ୍‍ନାନ୍‍ । ");
INSERT INTO peg_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","ହେବେଣ୍ଡାଂ ୱିଜ଼ାକାର୍‌ ୱେନ୍‍ବାତାର୍, “ବାଟିଙ୍ଗ୍‌ ଏନ୍‌ ଇନାକା ଇସ୍ୱର୍ତି ମାଜ଼ି ?” ହେୱାନ୍‌ ହେୱାରିଂ ଇଚାନ୍‌, “ଆନ୍‌ ହେୱାନ୍‌ ଇଞ୍ଜି ଏପେଙ୍ଗ୍‌ ଇନାଦେରା ।” ");
INSERT INTO peg_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","ଲାଗିଂ ହେୱାର୍‌ ଇଚାର୍‌, “ମାଦାଂ ଆରେ ସାକିନି ଲଡ଼ା ଆକାୟ୍‌ । ହେୱାନ୍‌ ଇନାକା ଇନାନା, ଆପେଂ ନିଜ୍‍ ହେଦାଂ ୱେଚାପ୍‌ନ୍ନା ।” ");
INSERT INTO peg_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","ପାଚେ ସବାନି ୱିଜ଼ାକାର୍‌ ନିଙ୍ଗ୍‌ଜି ଜିସୁଙ୍ଗ୍‌ ପିଲାତ ତାକେ ଅତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","ଆରେ, ହେୱାର୍‌ ଜିସୁ ବିରୁଦ୍‌ତ ଦାବା କିଦେଙ୍ଗ୍‌ ଲାଗାତାର୍‌, ଆପେଂ ହୁଡ଼୍‌ତାପ୍‌, ଇ ମାନାୟ୍‌ “ମା ଜାତିତିଂ ରାଜା ବିଦ୍‌ଡ଼ କିଦ୍‌ନାନା ଆରି କାଇସର୍‌ତିଂ ସିସ୍ତୁ ହିଦେଂ ମୁନାକିନାନ୍ନା ଆରି ଜାର୍‌ତିଂ କ୍ରିସ୍ଟ ରାଜା ଇଞ୍ଜି ଇନାନ୍ନା ।” ");
INSERT INTO peg_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","ଇବେଣ୍ଡାଂ ପିଲାତ ଜିସୁଙ୍ଗ୍‌ ୱେନ୍‌ବାତାନ୍‌, “ଏନ୍‌ କି ଜିହୁଦିର୍‌ ରାଜାତି ?” ଜିସୁ ଉତର୍‌ ହିତାନ୍‌, “ଏନ୍‌ ଇଞ୍ଜ୍‌ନାୟା ।” ");
INSERT INTO peg_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","ହେବେଣ୍ଡାଂ ପିଲାତ ମୁଡ଼୍‌ ମାପ୍ରୁହେବାକିନାକାନ୍‌ ଆରି ମାନାୟାରିଂ ଇଚାନ୍‌, ଆନ୍‌ “ଇ ମାନାୟ୍‌ତିଂ ଇନାକାପା ଦସ୍‌ ପାୟାଆୱାତାଂ ।” ");
INSERT INTO peg_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","ମାତର୍‌ ହେୱାର୍‌ ଆରେ ଜବର୍‌ କିଜ଼ି ଇଞ୍ଜେଙ୍ଗ୍‌ ଲାଗାତାର୍‌, “ଇୱାନ୍‌ ୱିଜ଼ୁ ଜିହୁଦା ଦେସ୍‌ତ ହିକ୍ୟା ହିଜ଼ି ଗାଲିଲିତାଂ ଆରମ୍‌ କିଜ଼ି ଇ ବାହା ପାତେକ୍‌ ପା ଲକାଂ ମାତାୟ୍‍ କିନାନା ।” ");
INSERT INTO peg_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","ମାତର୍‌ ପିଲାତ ଇଦାଂ ୱେନ୍‌ଞ୍ଜି ୱେନ୍‌ବାତାନ୍‌, “ଇ ମାନାୟ୍‌ ଇନାକା ରକାନ୍‌ ଗାଲିଲିୟ ମାନାୟ୍‌ କି ?” ");
INSERT INTO peg_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","ଆରେ, ହେୱାନ୍‌ ଜେ ହେରଦ୍‌ତି ଆଦିକାର୍‌ ତାରେନ୍‌ ମାନାର୍‌, ଇଦାଂ ପୁଞ୍ଜି ହେୱାନ୍‌ତାଂ ହେରଦ୍‌ ଲାଗାଂ ପକ୍‌ତାନ୍‌, ଲାଗିଂ ହେୱାନ୍‌ ପା ଇ ସମୁତ ଜିରୁସାଲମ୍‌ତ ମାଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","ହେରଦ୍‌ ଜିସୁଙ୍ଗ୍‌ ହୁଡ଼୍‌ଜି ବେସି ୱାର୍‌ୟା ଆତାନ୍‌, ଇନାକିଦେଂକି ହେୱାନ୍‌ ହେ ବିସ୍ରେ ୱେନ୍‌ଞ୍ଜି ମାଚିଲେ ତାଙ୍ଗେଙ୍ଗ୍‌ ବେସି ଦିନ୍‌ତାଂ ହୁଡ଼୍‌ଦେଂ ମାନ୍‌ କିଜ଼ି ମାଚାନ୍‌, ଆରେ ହେୱାନ୍‌ କାଜିଂ ଇମ୍‌ଣାକା ପା କାବାଆନି କାମାୟ୍‌ ଆନାକା ହୁଡ଼୍‌ଦେଂ ଆହା କିଜ଼ି ମାଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","ଲାଗିଂ ହେୱାନ୍‌ତାଂ ବେସି କାତା ୱେନ୍‌ବେଦେଂ ଲାଗାତାନ୍‌, ମାତର୍‌ ଜିସୁ ତାଙ୍ଗ୍‌ ଇନାକା ଇନ୍‍ୱାତାନ୍ । ");
INSERT INTO peg_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","ଆରେ, ମୁଡ଼୍‌ ମାପ୍ରୁହେବାକିନାକାର୍‌ ଆରି ସାସ୍ତିର୍‌ ନିଲ୍‌ଚି ହେ ବିରୁଦ୍‌ତ ବେସି ଇଞ୍ଜେଙ୍ଗ୍‌ ଲାଗିସ୍‌ ମାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","ଆରେ, ହେରଦ୍‌ ଜାର୍‌ ମେଲ୍ୟାର୍‌ ହୁକେ ତାଙ୍ଗ୍‌ ଲାଜ୍‌ କିଜ଼ି ନିନ୍ଦା କିଜ଼ି ଜିଲିମିଲି ହେନ୍ଦ୍ରା ଉସ୍ପି କିଜ଼ି ପିଲାତ ଲାଗେ ପକ୍‌ଚି ତୁହିତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","ହେ ଦିନ୍‌ ହେରଦ୍‌ ଆରି ପିଲାତ ହାରି ହାଙ୍ଗ୍‌ଦାକାର୍‌ ଆତାର୍‌; ଇଦାଂ ଆଗେ ହେୱାର୍‌ ହାରି ହାଙ୍ଗ୍‌ଦାକାର୍‌ ବିତ୍ରେ ସତ୍ରୁର୍‍ ମାଚାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","ଇଦାଂ ପାଚେ ପିଲାତ ମୁଡ଼୍‌ ମାପ୍ରୁହେବାକିନାକାର୍‌, ଗାଜାକାର୍‌ ଆରି ମାନାୟାରିଂ କୁକ୍‌ଚି ରୁଣ୍ଡାୟ୍‌ କିଜ଼ି ହେୱାରିଂ ଇଚାନ୍‌, ");
INSERT INTO peg_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","ଇୱାନ୍‌ ମାନାୟ୍‌ ବିଦ୍‍ବାଦା କିନାନା ଇଞ୍ଜି “ଏପେଙ୍ଗ୍‌ ଇୱାନିଂ ନା ଲାଗାଂ ତାସି ମାଚାଦେର୍‌; ଆରି ହୁଡ଼ାଟ୍‌, ଆନ୍‌ ମି ମୁମ୍‌ଦ ଇୱାନିଂ ପର୍‌ସନ୍‌ କିଜ଼ି, ହେ ବିରୁଦ୍‌ତ ଏପେଙ୍ଗ୍‌ ଜେ ୱିଜ଼ାକାଦେର୍‌ ଇୱାନ୍‌ କାତା କିନାଦେରା, ହେ ଲାକେ ଇମ୍‌ଣାକା ପା ଦସ୍‌ ଇୱାନ୍ତାଙ୍ଗ୍ ଗାଟାଆୱାତାପ୍‍ । ");
INSERT INTO peg_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","ହେରଦ୍‌ ପା ଗାଟାଆୱାତାନ୍‍, ଇନାକିଦେଂକି ହେୱାନ୍‍ତାଂ ମା ତାକେ ଆରେ ପକ୍ତାତାନ୍‌; ଆରି ହୁଡ଼ାଟ୍‌, ଇୱାନ୍‌ ହାକିଡାଣ୍ଡ୍‌ ପାୟା ଆନି ଇନାକାପା କାମାୟ୍‌ କିୱାତାନ୍‌ନା; ");
INSERT INTO peg_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","ଲାଗିଂ ଆପ୍‌ ଇୱାନିଂ ଟ୍ରାକି କିଜ଼ି ମୁକ୍ତି କିନାପ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","ପାର୍ବୁ ୱେଡ଼ାଲିଂ ହେୱାର୍‌ କାଜିଂ ରକାନିଂ ମୁକ୍ତି କିଦେଙ୍ଗ୍‌ ୱାଜ଼ି ମାଚାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","ମାତର୍‌ ହେୱାର୍‌ ୱିଜ଼ାକାର୍‌ ରବେ କିକିରାଡିଂ କିଜ଼ି ଇଚାର୍‌, “ଇୱାନିଂ ଅହାଟ୍‌, ମା କାଜିଂ ବାରବାଙ୍ଗ୍‌ ମୁୁକ୍‌ଡ଼ାୟ୍‍ କିୟାଟ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","ଇ ବାରବା ଗାଡ଼୍‌ଦ ଗିଟା ଆଜ଼ି ଇମ୍‌ଣି ଗଡ଼୍‌ମେଲି କାଜିଂ ଆରି ନାର୍‌ ଅହ୍‌ନି କାଜିଂ ବନ୍ଦି ଇଞ୍ଜ ଇଡ଼୍‌ଜି ମାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","ମାତର୍‌ ପିଲାତ ଜିସୁଙ୍ଗ୍‌ ମୁକ୍ତି କିଦେଙ୍ଗ୍‌ ମାନ୍‌କିଜ଼ି ହେୱାରିଂ ଆରେ ରଗ ବୁଜାୟ୍‌ କିତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","ମାତର୍‌ ହେୱାର୍‌ ଜବର୍‌ କିଜ଼ି ଇଞ୍ଜେଙ୍ଗ୍‌ ଲାଗାତାର୍‌, “ତାଙ୍ଗ୍‌ କ୍ରୁସ୍‌ତ ଦୁପାଟ୍‌, କ୍ରୁସ୍‌ତ ଦୁପାଟ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","ଆରେ, ଜିସୁ ହେୱାରିଂ ତିନି ହଟ୍‌ ଇଚାନ୍‌, “ଇନେକିଦେଂ, ହେୱାନ୍‌ ଇନା ଦସ୍‌ କିତାନ୍‌ନ୍ନା ? ଆପେଂ ତା ତାକେ ଇନାକାପା ହାକି ଡାଣ୍ଡ୍‌ ଗାଟା ଆଉପା; ଲାଗିଂ, ଆପେଂ ତାଙ୍ଗେଙ୍ଗ୍‌ ଡାଣ୍ଡ୍‌ ହିଜ଼ି ପିସ୍ତି ହିନାପ୍‍ ।” ");
INSERT INTO peg_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","ମତର୍‌ ହେୱାନ୍‌ କ୍ରୁସ୍‌ତ ଦୁପ୍‌ୟା ଆୟେନ୍‌ ଇଞ୍ଜି ଦାବା କିଜ଼ି ହେୱାର୍‌ ଗାଜା ୱେଇଦ ଜିଦ୍‌ କିଦେଙ୍ଗ୍‌ ଲାଗାତାର୍‌, ଆରେ ହେୱାର୍‌ତି ଆଲି ଜିଣା ଆତାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","ଆରେ, ହେୱାର୍‌ତି ଦାବା ହୁଦାଂ କିୟାଆୟେତ୍‌ ଇଞ୍ଜି ପିଲାତ ବଲ୍‌ ହିତାନ୍‌; ");
INSERT INTO peg_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","ମାତର୍‌ ମାନାୟ୍‌ କାଜିଂ ନିଲ୍‌ଚି ଆରି ମାନାୟ୍‌ ଅସ୍ତି କାଜିଂ ଜଇଲ୍‌ତ ଇଟ୍ୟାଜ଼ି ମାଚି ଇମ୍‌ଣି ମାନାୟ୍‌ କାଜିଂ ହେୱାର୍‌ ଦାବା କିଜ଼ି ମାଚାର୍‌, ତାଙ୍ଗ୍‌ ହେୱାନ୍‌ ମୁକ୍ତି କିତାନ୍‌, ଆରେ ଜିସୁଙ୍ଗ୍‌ ହେୱାନ୍‌ ହେୱାର୍‌ ମାନ୍‍ତାରେନ୍‍ ହେଲାୟ୍‌ କିତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","ହେୱାର୍‌ ଜିସୁଙ୍ଗ୍‌ ଅନିୱେଡ଼ାଲିଂ ବିତ୍ରେ ନାସ୍‌ତାଂ ୱାଜ଼ି ମାନି ସିମନ୍‌ ଇନି ରକାନ୍‌ କୁରିଣିୟ ଲଗାଂ ଆସ୍ତି ଜିସୁତି ପାଚେ ପାଚେ କ୍ରୁସ୍‌ ପିଣ୍ଡ୍‌ଦେଂ କାଜିଂ ହେୱାନ୍‌ ନିପିତ ହେଦାଂ ଇଡ୍‌ତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","ଆରେ, ମାନାୟାର୍‌ତି ଆରି ହେୱାନ୍‌ କାଜିଂ ନେଞ୍ଜେଡାକିତ ଇଡ଼୍‍ୟାଆନି ଆଡ଼୍‍ବିନି ଲଗାଂ ବେସି କଗ୍‌ଲେହିମ୍‌ଣାଂ ହେୱାନ୍ତି ପାଚେ ପାଚେ ହାଲ୍‌ଜି ମାଚିକ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","ମାତର୍‌ ଜିସୁ ହେୱେକ୍‌ ନିପ ମାସ୍‌ଦି ପା ଇଚାନ୍‌, “ଗ ଜିରୁସାଲମ୍‌ନି ଗାଡ଼୍‍ଚେକ୍‍, ନା କାଜିଂ ଆଡ଼୍‍ବାମାଟ୍‍, ମତର୍‌ ଜାର୍‌ ଜାର୍‌ କାଜିଂ ଆରି ଜାର୍‌ ଜାର୍‌ ହିମ୍‌ଣାଂ କାଜିଂ ଆଡ଼୍‍ବାଟ୍‍; ");
INSERT INTO peg_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","ଇନାକିଦେଂକି ହୁଡ଼ାଟ୍‌, ଇନେର୍‌ ବାଞ୍ଜ୍‌ଣି, ଆରେ ଇନେର୍‌ ଇନାୱାଡ଼ାଂପା ଏସ୍‌ ପିହ୍‍ୱାତାତ୍‍ନ୍ନା ଆରି ମାୟ୍‍ଉଟ୍‍ୱା ତାତ୍‍ନ୍ନା, ହେୱାକାଂ ଲକୁ ଏଚେକାଡ଼୍‌ଦ ଦନ୍ୟ ଦନ୍ୟ ଇଞ୍ଜି ଇନାର୍‌, ଏଲେଙ୍ଗ୍‌ବାର୍ତି ସମୁ ୱାନାତା । ");
INSERT INTO peg_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","ହେ ଏଚେକାଡ଼୍‌ଦ ଲକୁ ମାଡ଼ିକାଂ ଇଞ୍ଜେଙ୍ଗ୍‌ ଲାଗାନାର୍‌, ମା ଜପି ଆର୍‍ଦା, ଆରେ କୁପ୍‌ଲିକାଂ ଇଞ୍ଜେଙ୍ଗ୍‌ ଲାଗାନାର୍‌, ମାଙ୍ଗେଙ୍ଗ୍‌ ପ୍ଡାକ୍‍ତା । ");
INSERT INTO peg_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","ଇନାକିଦେଂକି ଲକୁ ଜଦି ଜିତ୍‌ ମାର୍‌ କାଜିଂ ଏଲେଙ୍ଗ୍‌ କିତାର୍‌, ୱାଚ୍‌ଚି ମାର୍‌ କାଜିଂ ବାଟିଙ୍ଗ୍‌ ଇନାକା କିଉର୍‌ ?” ");
INSERT INTO peg_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","ଆରେ, ହାକି ଡାଣ୍ଡ୍‌ ପାୟା ଆଦେଂ କାଜିଂ ରିକାରିଙ୍ଗ୍ କାରାପ୍‌ କାମାୟ୍‌ ପା ହେୱାନ୍‌ ହୁକେ ଅୟା ଆଜ଼ି ମାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","ଆରେ, ହେୱାର୍‌ “ନିନ୍ଦାଣ୍‌” ଇନି ବାହାତ ଏକିସ୍‌ ହେବେ ହେୱାନିଂ କ୍ରୁସ୍‌ତ ଦୁପ୍‌ତାର୍‌ ଆରି କାରାପ୍‌ କାମାୟ୍‌ କିନାକାର୍‌ ବିତ୍ରେତାଂ ରକାନିଂ ତିନାବାଗାଙ୍ଗ୍‌ ଆରେ ରକାନିଂ ଡେବା ବାଗାଙ୍ଗ୍‌ କ୍ରୁସ୍‌ତ ଦୁପ୍‌ତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","ହେ ଏଚେକାଡ଼୍‌ଦ ଜିସୁ ଇଚାନ୍‌, “ଆବା, ଇୱାରିଂ କେମା କିୟା, ଇନାକିଦେଂକି ଇୱାର୍‌ ଇନାକା କିନାରା, ହେଦାଂ ପୁନୁରା ।” ଆରେ, ହେୱାର୍‌ ତା ହେନ୍ଦ୍ରା ସବୁ ବାଟା କିନି କାଜିଂ ଦରମ୍‌ଗୁଲି କିତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","ଆରେ, ମାନାୟାର୍‌ ନିଲ୍‌ଚିପା ହୁଡ଼୍‍ଜିମାଚାର୍‍ । ଆରି, ମୁଡ଼୍‌ଦାକାର୍‍ ପା ତାଙ୍ଗ୍‌ ବିଦ୍‍ବାଦ୍‍ କିଜ଼ି ଇଞ୍ଜେଙ୍ଗ୍‌ ଲାଗାତାର୍‌, ହେୱାନ୍‌ ବିନ୍‌ ଲଗାଂ ରାକ୍ୟା କିତାନ୍‌; “ହେୱାନ୍‌ ଜଦି ଇସ୍ୱର୍ତି ବାଚିକିୟାତି କ୍ରିସ୍ଟ, ବାଟିଙ୍ଗ୍‌ ନିଜ୍‍ତିଙ୍ଗ୍ ରାକ୍ୟା କିଏନ୍‍ ।” ");
INSERT INTO peg_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","ଆରେ, ମେଲ୍ୟାର୍‌ ପା ହେ ଲାଗାଂ ୱାଜ଼ି କେନିରାସ୍‌ ହିଜ଼ି ତାଙ୍ଗ୍‌ ଗ୍ଡାଜ଼ି କିଜ଼ି ଇଚାର୍‌, ");
INSERT INTO peg_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","“ଏନ୍‌ ଜଦି ଜିହୁଦିର୍ତି ରାଜା, ତା ଆତିସ୍‌ ନିଜ୍‍ତିଙ୍ଗ୍ ରାକ୍ୟା କିୟା ।” ");
INSERT INTO peg_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","ଆରେ, ହେୱାନ୍‌ ଜପି ଇ ଲେକା ପା ଲେକା ଆଜ଼ି ମାଚାତ୍‌, “ଇୱାନ୍‌ ଜିହୁଦିର୍ତି ରାଜା ।” ");
INSERT INTO peg_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","ଆରେ, କ୍ରୁସ୍‌ତ ଦୁପ୍‌ୟା ଆଜ଼ି ମାନି ଚର୍କୁକାଂ ତାଙ୍ଗ୍‌ ବିତ୍ରେ ରକାନ୍‌ ହେୱାନିଂ ନିନ୍ଦା କିଜ଼ି ଇଞ୍ଜେଙ୍ଗ୍‌ ଲାଗାତାନ୍‌, “ଏନ୍‌ ଇନାକା କ୍ରିସ୍ଟ ଆକାୟ୍‌ ? ନିଜ୍‍ତିଙ୍ଗ୍ ଆରି ମାଙ୍ଗେଙ୍ଗ୍‌ ରାକ୍ୟା କିଦା ।” ");
INSERT INTO peg_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","ମାତର୍‌ ଆରି ରକାନ୍‌ ହେୱାନିଂ ଦାକା କିଜ଼ି ଉତର୍‌ ହିତାନ୍‌, ଏନ୍‌ ସମାନ୍‌ ଡାଣ୍ଡ୍‌ତ ପାୟାଆନାୟା, “ଏନ୍‌ ଇସ୍ୱର୍ତି ଇନାକା ପାଣ୍ଡ୍ରା ପା ଆଉୟା ? ");
INSERT INTO peg_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","ଆରେ, ଆପେଂ ହିନା ନ୍ୟାୟ୍‌ତାଂ ଡାଣ୍ଡ୍‌ ପାୟାଆନାପା, ଇନାକିଦେଂକି ନିଜ୍‍ ନିଜ୍‍ ବାନ୍ୟାକାମାୟ୍‍ ପାଡ଼୍‌ ପାୟାଆନାପା, ମାତର୍‌ ଇ ମୁଣିକା ଇନାକାପା ଦସ୍‌ କିୱାତାନ୍‌ନା ।” ");
INSERT INTO peg_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","ଆରେ, ହେୱାନ୍‌ ଇଚାନ୍‌, “ଏ ଜିସୁ, ଏନ୍‌ ଜାର୍‌ ରାଜିତ ହଟିସ୍ ନାଙ୍ଗେଙ୍ଗ୍‌ ଏତୁ କିଦ୍‌ନାୟ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","ହେବେଣ୍ଡାଂ ଜିସୁ ତାଙ୍ଗ୍‌ ଇଚାନ୍‌, “ଆନ୍‌ ନିଙ୍ଗେଙ୍ଗ୍‌ ହାତ୍‌ପା ଇଞ୍ଜ୍‌ନାଙ୍ଗା, ନେଞ୍ଜେଙ୍ଗ୍‌ ଏନ୍‌ ନା ହୁକେ ସାର୍ଗେ ରାଜିତ ଏକାୱାନାୟ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","ହେ ଏଚେକାଡ଼୍‌ଦ ହେ ପାଦ୍‌ନା ବାର ଗଣ୍ଟା ୱେଡ଼ାଲିଂ ଆଜ଼ି ମାଚାତ୍‌, ଆରି, ୱେଡ଼ା ମାଜ୍‌ଗା ଆତିଲେ ତିନି ଗଣ୍ଟା ପାତେକ୍‌ ଦେସ୍‌ ଜାକ୍‌ ମାଜ୍‌ଗା ଆତାତ୍‌, ");
INSERT INTO peg_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","ଆରେ ମନ୍ଦିର୍‌ନି ପାର୍‍ଦା ହେନ୍ଦ୍ରା ମାଦିତାଂ କେନ୍‌ଞ୍ଜି ହାଚାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","ଆରେ, ଜିସୁ ଆଟ୍‌ୱା କିଜ଼ି କୁକ୍‌ଚି ଇଚାନ୍‌, “ଏ ଆବା, ନି କେଇଦ ନା ପାରାଣ୍‍ନି ଜିବୁନ୍‌ ହେଲାୟ୍‌ କିଦ୍‌ନାଙ୍ଗା ।” ଇଦାଂ ଇଞ୍ଜି ହେୱାନ୍‌ ପାରାଣ୍‌ ପିସ୍ତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","ପାଞ୍ଜ୍‍ କଡ଼ି ମୁଡ଼୍‌ଦାକାନ୍‌ ମେଲ୍ୟାର୍‌ ଜପି ଗାଜାକାନ୍‌ ଇ ଗଟ୍‌ଣା ହୁଡ଼୍‌ଜି ଇସ୍ୱର୍‌ତିଂ ଜାଜ୍‌ମାଲ୍‌ କିଜ଼ି ଇଚାନ୍‌, “ହାତେନେ ଇୱାନ୍‌ ଦାର୍ମି ଲଗୁ ମାଚାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","ଆରେ, ଇମ୍‌ଣି ମାନାୟାର୍‌ ହୁଡ଼୍‌ଦେଂ ରୁଣ୍ଡାଆଜ଼ି ମାଚାର୍‌, ୱିଜ଼ାକାର୍‌ ହେୱାର୍‌ ହେ ସବୁ ହୁଡ଼୍‌ଜି ନେଞ୍ଜେଡାକିତ ଇଡ଼ିଆ ଆଜ଼ି ମାସ୍‌ଦି ହାଞ୍ଜେଙ୍ଗ୍‌ ଲାଗାତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","ମାତର୍‌ ହେୱାନ୍ତି ଚିନାଜାଣା ୱିଜ଼ାକାର୍‌ ଆରି ଗାଲିଲିତାଂ ରଚେ ମିହାଆଜ଼ି ଜିସୁଙ୍ଗ୍‌ ପାଚେ ପାଚେ ୱାଜ଼ି ମାନି କଗ୍‌ଲେକ୍‌ ଦେହା ନିଲ୍‌ଚି ଇ ସବୁ ହୁଡ଼୍‌ଜି ମାଚିକ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","ଆରେ ହୁଡ଼ାଟ୍‌, ଜିହୁଦିର୍ତି ହାରାମାତିୟା ଗାଡ଼୍‌ନି ଜସେପ୍‌ ଇନି ରକାନ୍‌ ମାନାୟ୍‌ ଗାଜା ସବାନି ମେମର୍‌ ମାଚାନ୍‌; ହେୱାନ୍‌ ରକାନ୍‌ ହାର୍‌ ଆରି ଦାର୍ମି ଲକୁ, ");
INSERT INTO peg_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","ଜିହୁଦାନି ହାରାମାତିୟା ତର୍‌ନି ନାସ୍‌ତ ଜସେପ୍‌ ଇଞ୍ଜି ରୱାନ୍‌ ମାଚାନ୍‌ । ଜିହୁଦି ରକାନ୍‌ ଦାର୍ମି ଆରି ମାନିନି ଲକ୍‌ ମାଚାନ୍‌ ଆରେ ଇସ୍ୱର୍‌ତି ରାଜିନି ୱାନାକାଦିଂ କାସି ମାଚାନ୍‌ । ଗାଜା ସବାନି ରୱାନ୍‌ ମୁଣିକା ମାଚିସ୍‌ ପା, ହେୱାନ୍‌ ହେୱାର୍‌ତି ଦାୟିତ୍‌ ଆରି କାମାୟ୍‌ ଲାହାଂ ଏକ୍‌ଜୁଟ୍‌ ହିଲାତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","ହେୱାନ୍‌ ପିଲାତ ତାକେ ହାଲ୍‌ଜି ଜିସୁତି ଗାଗାଡ଼୍‌ ଏନ୍ତାନ୍‌, ");
INSERT INTO peg_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","ଆରେ ହେଦାଂ ଜୁତ୍‌ତି ତାସି କୱାଣ୍‌ ହେନ୍ଦ୍ରାତ ହୁର୍‌ପିସ୍‌, ଇମେତାକେ ଇନେର୍‌ ଇନାୱାଡ଼ାଂ ଇଟ୍ୟାୱାଦାଂ ମାଚାନ୍‌, ମାଡ଼ିତ କାର୍ଚି ମାଚି ଏଲେଙ୍ଗ୍‌ ର ଦୁଗେର୍‌ତ ତାଙ୍ଗେଙ୍ଗ୍‌ ଇଡ୍‌ତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","ହେ ଦିନ୍‌ ଜାଲ୍‌ଦି କିନି ଦିନ୍‌ ମାଚାତ୍‌, ଆରେ ଜମ୍‌ନିବାର୍‌ ଲାଗେ ଆଜ଼ି ୱାଜ଼ି ମାଚାତ୍‍ । ");
INSERT INTO peg_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","ଆରେ ଗାଲିଲିତାଂ ହେୱାନ୍‌ ହୁକେ ୱାଜ଼ିମାନି କଗ୍‌ଲେହିମ୍‌ଣାଂ ପାଚେ ପାଚେ ହାଲ୍‌ଜି ଦୁଗେର୍‌ ଆରି ହେୱାନ୍ତି ଗାଗାଡ଼୍‌ ଇନେସ୍‌ ଇଡ଼୍‌ତାର୍‌ନ୍ନା, ହେଦାଂ ହୁଡ଼୍‍ତିକ୍‍, ");
INSERT INTO peg_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","ଆରେ ହେୱେକ୍‌ ମାସ୍‌ଦି ହାଲ୍‌ଜି ଆରି ବାସ୍‌ନା ଚିକାଣ୍‌ ଜାଲ୍‌ଦି କିତିକ୍‌ । ମାତର୍‌ ବିଦି ଇସାବ୍ରେ ହେ ନାଜିଂ ଜମ୍‌ନିବାର୍‌ ମାଚିଲେ ହେୱାର୍‌ ଜମ୍‌ତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","ମାତର୍‌ ସାତ୍‌ ଦିନ୍‌ନି ରଇବାର୍‌ ଉଟ୍‌ଲା ହାକାଡ଼େ ହେୱେକ୍‌ ଜାଲ୍‌ଦି କିତି ହାର୍‌ଦି ବାସ୍‌ନା ସାମାନ୍ ଅଜ଼ି ଦୁଗେର୍‌ ତାକେ ହାଚିକ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","ଆରେ, ହେୱାର୍‌ ଦୁଗେର୍‌ତାଂ କାଲ୍‌ ଗ୍ରୁତ୍‍ତାକା ହୁଡ଼୍‍ତିକ୍‍, ");
INSERT INTO peg_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","ମାତର୍‌ ବିତ୍ରେ ହାଲ୍‌ଜି ମାପ୍ରୁ ଜିସୁତି ଗାଗାଡ଼୍‌ ଗାଟାୱିତିକ୍‍ । ");
INSERT INTO peg_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","ଆରେ, ହେୱେକ୍‌ ହେଦାଂ କାଜିଂ ବୁଦିବାଣା ଆନିକା, ଏଲେଙ୍ଗ୍‌ ୱେଡ଼ାଙ୍ଗ୍‌ ହୁଡ଼ାଟ୍‌, ଅଜଡ଼୍‌ ହେନ୍ଦ୍ରା ଉସ୍ପିସ୍‌ ରିକାର୍‌ ଲକୁ ହେୱେକ୍‌ ତାକେ ଏକାତାର୍‌; ");
INSERT INTO peg_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","ହେବେ ହେୱେକ୍‌ ପାଣ୍ଡ୍ରା ଆଜ଼ି ମେଦ୍‌ନିତ ମୁମ୍‌ ଆତିଲେ, ହେୱାର୍‌ ହେୱେକାଂ ଇଚାର୍‌, “ହାତିଲକାର୍‍ ବିତ୍ରେ ଏପେଙ୍ଗ୍‌ ଇନେକିଦେଂ ଜିତାକାନିଂ ଡେକ୍‌ନାଦେରା ? ");
INSERT INTO peg_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","ହେୱାନ୍‌ ଇବେ ହିଲୁନ୍, ମାତର୍‌ ନିଂତାନ୍ନା । ହେୱାନ୍‌ ଗାଲିଲିତ ମାନି ୱେଡ଼ାଲିଂ ମିଙ୍ଗେଙ୍ଗ୍‌ ୱେଚ୍‌ଚି ମାନ୍‍ଞ୍ଚାନ୍‍, ହେଦାଂ ଏତୁ କିୟାଟ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","ମାନାୟ୍‌ ମାଜ଼ି ପାପିୟାର୍‌ କେଇଦ କ୍ରୁସ୍‌ତ ହାଦେଂ ଆରି ତିନି ଦିନ୍ତ ଆରି ନିଙ୍ଗ୍‍ଦେଙ୍ଗ୍ ଆନାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","ହେବେଣ୍ଡାଂ ହେୱାର୍‌ ହେୱାନ୍‌ କାତା ଏତୁ କିତାର୍‌, ");
INSERT INTO peg_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","ଆରେ ଦୁଗେର୍‌ତାଂ ମାସ୍‌ଦିହାଲ୍‌ଜି ଏଗାର୍‌ ଜାଣ୍‌ ଚେଲାର୍‌ ଆରି ବିନ୍‌ ଲଗାଂ ଇ ସବୁ କାବୁର୍‌ ୱେଚ୍‍ଚାର୍‍ । ");
INSERT INTO peg_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","ଇୱେକ୍‌ ମଗ୍‌ଦଲିନି ମରିୟମ୍‌ ଜହନା ଜାକୁବ୍‌ ତେହି ମରିୟମ୍‌ ଆରି ଇୱେକ୍‌ ହାଙ୍ଗ୍‍ଦାଂ ମାନି ବିନ୍‌ କଗ୍‌ଲେକ୍‌, ଇୱେକ୍‌ ପକ୍ୟାତାକାର୍‌ରିଂ ଇ ବିତ୍ରେ କାତା ୱେଚ୍‍ଚିକ୍‍ । ");
INSERT INTO peg_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","ମାତର୍‌ ଇ ସବୁ କାତା ହେୱାର୍‌ ତାକେ କ୍ଡେଞ୍ଚ୍‍କଣ୍‌ ଲାକେ ଲାଗାତାତ୍‌, ଆରେ ହେୱାର୍‌ ହେୱେକାଂ ପାର୍ତି କିୱାତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","ମାତର୍‌ ପିତର୍‌ ନିଙ୍ଗ୍‌ଜି ଦୁଗେର୍‌ ତାକେ ହନ୍‍ଚି ହାଚାନ୍‌, ଆରେ ଟଡ଼୍‌ଜି ହୁଡ଼୍‌ତାନ୍‌ ମତର୍‌ ହାରୁ ହେନ୍ଦ୍ରା ସବୁ ହୁଡ଼୍‌ତାନ୍‌, ଆରେ ହେୱାନ୍‌ ହେ ଗଟ୍‌ଣା ବିସ୍ରେ କାବା ଆଜ଼ି ତା ଇଞ୍ଜ ହାଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","ଆରେ ହୁଡ଼ାଟ୍‌, ହେ ଦିନ୍‌ ହେୱାର୍‌ ବିତ୍ରେ ରିକାର୍‌ ଜିରୁସାଲମ୍‌ତାଂ ବେସିଆୱିତିସ୍‍ ଏଗାର୍‌ କିଲମିଟର୍‌ ଦେହାତାଂ ଇମାୟୁ ନାସ୍‌ତ ହାଲ୍‌ଜି ମାଚାର୍‌ ");
INSERT INTO peg_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","ଆରି ଇ ୱିଜ଼ୁ ଗଟ୍‌ଣା ବିସ୍ରେ ହେୱାର୍‌ ହାୱେର୍‍ କାତାବାର୍ତା କିଜ଼ି ମାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","ହେୱାର୍‌ କାତାବାର୍ତା ଆରି ବେରଣ୍‌ୱେଚ୍‌ପା ଆନି ୱେଡ଼ାଲିଂ ଜିସୁ ଆପେ ହେୱାର୍‌ ତାକେ ୱାଜ଼ି ହେୱାର୍‌ ହୁକେ ତାଙ୍ଗ୍‌ଦେଂ ଲାଗାତାନ୍‌; ");
INSERT INTO peg_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","ମାତର୍‌ ହେୱାର୍‌ କାଣ୍‌କୁ ଏଲେଙ୍ଗ୍‌ ଗେହ୍‍ୟା ଆଜ଼ି ମାଚାତ୍‌ ଜେ, ହେୱାର୍‌ ଜିସୁଙ୍ଗ୍‌ ଚିନ୍‌କିଦେଂ ଆଡ୍‌ୱାତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","ଜିସୁ ହେୱାରିଂ ୱେନ୍‌ବାତାନ୍‌, “ଏପେଙ୍ଗ୍‌ ତାଙ୍ଗୁ ତାଙ୍ଗୁ ଇମ୍‌ଣି ୱିଜ଼ୁ ବିସ୍ରେ କାତାବାର୍ତା କିନାଦେରା, ହେ ୱିଜ଼ୁ ଇନାକା ?” ହେବେଣ୍ଡାଂ ହେୱାର୍‌ ବାଡ଼ିୟା ଆଜ଼ି ନିଲ୍‌ଚି ମାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","ଆରେ ହେୱାର୍‌ ବିତ୍ରେ କେଲୟପା ଇନି ରକାନ୍‌ ହେୱାନିଂ ଉତର୍‌ ହିତାନ୍‌, “ଜିରୁସାଲମ୍‌ତ ବାହାକିନି ମାନାୟ୍‌ ବିତ୍ରେ ଏନ୍‌ ଇନାକା ରକାୟ୍‌ ହେ ବାହାନି ଏଚେକ୍‌ ଦିନ୍‌ନି ଗଟ୍‌ଣା ପୁନୁୟ୍‌ ?” ");
INSERT INTO peg_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","ଜିସୁ ହେୱାରିଂ ୱେନ୍‌ବାତାନ୍‌, “ଇନେସ୍‌ ଇନେସ୍‌ ବାନି ଗଟ୍‌ଣା ?” ହେୱାର୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ଇଚାର୍‌, “ନାଜରିତିୟାନି ଜିସୁତି ବିସ୍ରେ; ହେୱାନ୍‌ ଇସ୍ୱର୍‌ ଆରି ୱିଜ଼ୁ ଲକାର୍‍ କାଣ୍‌କୁତ କାମାୟ୍‌ତ ଆରି ବଚନ୍‌ତ ସାକ୍ତିକାଟାକାନ୍‌ ବେଣ୍‌ବାକ୍‌ଣାୟ୍‌କିନାକାନ୍‌ ମାଚାନ୍‌, ");
INSERT INTO peg_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","ଆରେ ମୁଡ଼୍‌ ମାପ୍ରୁହେବାକିନାକାନ୍‌ ଆରି ମୁଡ଼୍‍ଦାକାର୍‍ ଇନେସ୍‌ ତାଙ୍ଗ୍‌ ହାକି ଡାଣ୍ଡ୍‌ ଆଦେଂ ହେଲାୟ୍‌ କିଜ଼ି ତାଙ୍ଗ୍‌ କ୍ରୁସ୍‌ତ ଅସ୍ତାର୍‌, ଇ ୱିଜ଼ୁ ବିସ୍ରେ । ");
INSERT INTO peg_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","ମାତର୍‌ ଇନେର୍‌ ଇସ୍ରାଏଲ୍‌ତିଂ ମୁକ୍ତି କିନାନ୍‌, ହେୱାନ୍‌ ଜେ ଇୱାନ୍‍, ହେଦାଂ ଆପେଂ ଆହା କିଜ଼ି ମାଚାପ୍‍; ମାତର୍‌ ଇଦାଂ ପିସ୍ତି ଇ ୱିଜ଼ୁ ଗଟ୍‍ଣାନି ନେଞ୍ଜେଙ୍ଗ୍‌ ତାଙ୍ଗ୍ ତିନି ଦିନ୍‌ ଆତାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","ଆରେ ପା, ମା ବିତ୍ରେତାଂ କେତେକ୍‌ ଜାଣ୍‌ କଗ୍‌ଲେକ୍‌ ମାଙ୍ଗେଙ୍ଗ୍‌ କାବା କିତ୍‍କ୍‍ନା; ହେୱେକ୍‌ ଉଟ୍‌ଲା ହାକାଡ଼େ ଦୁଗେର୍‌ ତାକେ ହାଲ୍‍ଜି ମାଚିକ୍‌, ");
INSERT INTO peg_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","ଆରେ ହେୱାନ୍ତି ଗାଗାଡ଼୍‌ ଗାଟାୱାଦାଙ୍ଗ୍ ୱାଜ଼ି ଇଚିକ୍‌ ଜେ, ହେୱେକ୍‌ ଦୁତରିଂ ପା ହୁଡ଼୍‍ତିକ୍‍ନ୍ନା ଆରି ହେ ଦୁତ୍‌କୁ ଇଚିକ୍‌ ଜେ, ହେୱାନ୍‌ ଜିତାକାନ୍‍ ମାନାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","ଆରେ, ମା ହାଙ୍ଗ୍‍ଦାକାର୍‍ ବିତ୍ରେ ଇନେର୍‌ ଇନେର୍‌ ଦୁଗେର୍‌ ଲାଗେ ହାଲ୍‌ଜି, କଗ୍‌ଲେହିମ୍‌ଣାଂ ଇନେସ୍‌ ଇଞ୍ଜି ମାଚିକ୍‍, ହେ ଲାକେ ହୁଡ଼୍‍ତିକ୍‍, ମାତର୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ହୁଡ଼୍‍ୱିତିକ୍‍ ।” ");
INSERT INTO peg_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","ହେବେଣ୍ଡାଂ ହେୱେକାଂ ଇଚାନ୍‌, “ଏ ନିର୍‍ବୁଦିୟା କାଦେର୍‌ ଆରି ବେଣ୍‌ବାକ୍‌ଣାୟ୍‌କିନାକାର୍‌ ହୁକେ ଇଚି ୱିଜ଼ୁ ବେରଣ୍‌ତ ପାର୍ତି କିଦେଙ୍ଗ୍‌ ହିତ୍‍ଡ଼ି ମାନ୍‌ କାଦେର୍, ");
INSERT INTO peg_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","ଇ ୱିଜ଼ୁ ଦୁକ୍‌ କିଜ଼ି ଜାର୍‌ ପାଣ୍‌ ହଣ୍ଡେଙ୍ଗ୍‌ ଇନାକା କ୍ରିସ୍ଟତି ଲଡ଼ା ହିଲ୍‌ୱାତାତ୍‌ ?” ");
INSERT INTO peg_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","ଆରେ, ମସା ଆରି ୱିଜ଼ାର୍‌ ବେଣ୍‌ବାକ୍‌ଣାୟ୍‌କିନାକାନ୍‌ତାଂ ହାଙ୍ଗ୍‍ଜି ୱିଜ଼ୁ ଦରମ୍‌ ସାସ୍ତର୍‌ତ ଜାର୍‌ କାଜିଂ ବେରଣ୍‌ ହେୱାନ୍‌ ହେୱାରିଂ ବୁଜାୟ୍‌ କିତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","ଆରେ, ହେୱାର୍‌ ଇମ୍‌ଣି ନାସ୍‌ତ ହାଲ୍‌ଜି ମାଚାର୍‌, ହେବେଣ୍ଡାଂ ଲାଗେ ଏକିନିହିଙ୍ଗ୍, ହେୱାନ୍‌ ଆରେ ଆଗେ ହାଞ୍ଜେଙ୍ଗ୍‌ ଟାଟାୟ୍‍ କିତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","ମାତର୍‌ ହେୱାର୍‌ ତାଙ୍ଗ୍‌ ଟେବାୟ୍‌ କିଜ଼ି ଇଚାର୍‌, “ମାହୁଦାଂ ମାନା, ଇନାକିଦେଂକି ମ୍ଡିସି ୱାନାତା” ଆରି ୱେଡ଼ା ହାଚାତେ । ହେବେଣ୍ଡାଂ ହେୱାନ୍‌ ହେୱେର୍‌ ହୁଦାଂ ମାଞ୍ଜେଙ୍ଗ୍‌ ଇଞ୍ଜ ହାଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","ଆରେ, ହେୱାର୍‌ ହୁକେ ଚିଞ୍ଜେଙ୍ଗ୍‌ କୁଚ୍‌ଚି ପାଚେ ହେୱାନ୍‌ ରୁଟି ଅଜ଼ି ଆସିର୍ବାଦ୍‌ କିତାନ୍‌, ଆରି ହେଦାଂ ଡ୍ରିକ୍‌ଚି ହେୱାରିଂ ହିଦେଂ ଲାଗାତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","ହେବେ ହେୱାର୍‌ କାଣ୍‌କୁ ଜେୟାଆତିକ୍‍ ଆରି ହେୱାର୍‌ ତାଙ୍ଗ୍‌ ଚିନ୍‌ କିତାର୍; ଆରେ, ହେୱାନ୍‌ ହେୱାର୍‌ ନଞ୍ଜର୍‌ତାଂ ମାୟାଁ ଆତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","ହେବେଣ୍ଡାଂ ହେୱାର୍‌ ହେୱେର୍‌ ଇଚାର୍‌, “ଏଚେକାଡ଼୍‌ଦ ହାସ୍‍ଦ ହେୱାନ୍‌ ମା ହୁକେ କାତାବାର୍ତା କିଜ଼ି ମାଚାନ୍‌ ଆରି ମାଙ୍ଗେଙ୍ଗ୍‌ ଦରମ୍‌ ସାସ୍ତର୍‌ ବୁଜାୟ୍‌ କିଜ଼ି ମାଞ୍ଚାନ୍, ହେୱେଡ଼ାଂ ଇନାକା ମା ମାନ୍‌ କେଦ୍‍ୱାଦାଂ ମାଚାତ୍‌ ?” ");
INSERT INTO peg_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","ଆରେ, ହେୱାର୍‌ ହେପାଦ୍‌ନା ନିଙ୍ଗ୍‌ଜି ଜିରୁସାଲମ୍‌ତ ଲେଉଟା ଆଜ଼ି ରବେ ରୁଣ୍ଡା ଆଜ଼ି ମାନି ଏଗାର୍‌ଜାଣ୍‌ତିଂ ଆରି ହେୱାର୍‌ ହଲ୍ୟାରିଂ ହୁଡ଼୍‌ତାନ୍‌; ");
INSERT INTO peg_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","ହେୱେର୍‌ ଇଞ୍ଜି ମାଚାର୍‌, “ମାପ୍ରୁ ହାତ୍‌ପା ନିଂତାନ୍ନା ଆରି ସିମନ୍‌ତିଂ ଚଞ୍ଜ୍‌ୟା ଆତାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","ଆରେ, ହେୱାର୍‍ପା ହାଜ଼ିନି ସବୁ ଗଟ୍‌ଣା ଆରି ରୁଟି ଡ୍ରିକ୍‌ନି ସମୁତ ହେୱାନ୍‌ ଇନେସ୍‌ ହେୱାର୍‌ ହୁକେ ଚିନା ଆତାନ୍‌, ହେ ସବୁ ପୁଞ୍ଜେଙ୍ଗ୍‌ ଲାଗାତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","ମାତର୍‌ ହେୱାର୍‌ ଇ ସବୁ ବେରଣ୍‌ ଇନିୱାଡ଼ାଲିଂ ମାପ୍ରୁ ଜିସୁ ନିଜେ ହେୱାର୍‌ ତାକେ ଏକାତାନ୍‌ ଆରେ ଇଚାନ୍‌, “ମି କାଜିଂ ସୁସ୍ତା ଆୟେତ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","ମତର୍‌ ମାନାୟ୍‌ୟାର୍‌ କାବା ଆଜ଼ି ବେସି ପାଣ୍ଡ୍ରା ଆଜ଼ି ର ପୁଦା ହୁଡ଼୍‍ନାରା ଇଞ୍ଜି ବାବି କିତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","ହେବେଣ୍ଡାଂ ଜିସୁ ହେୱାରିଂ ଇଚାନ୍‌, “ଇନେକିଦେଂ ପାଣ୍ଡ୍ରା ଆନାଦେରା, ଆରେ, ମି ମାନ୍ତ ଇନେକିଦେଂ ଗାଣ୍‌ଜୁ ନିଙ୍ଗ୍‌ନାତା ? ");
INSERT INTO peg_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","ଇୱାଙ୍ଗ୍‌ ଜେ ଆନ୍‌, ନା କେଇ ଆରି ପାନା ହୁଡ଼ାଟ୍‌, ନାଙ୍ଗ୍‌ ଡୁଜ଼ି ହୁଡ଼୍‍ଦାଟ୍‌, ଇନାକିଦେଂକି ନାଦାଂ ଇନେସ୍‌ ଜେଇ ଆରି ପ୍ଡେନ୍ ମାନାକା ଏପେଙ୍ଗ୍‌ ହୁଡ଼୍‍ନାଦେରା, ପୁଦାତିଙ୍ଗ୍‌ ହେ ଲାକେ ଆକାୟ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","ଆରେ ହେୱାନ୍‌ ଇଦାଂ ଇଞ୍ଜି ହେୱେରିଂ ଜାର୍‌ କେଇ ଆରି ପାନା ଚଚ୍‌ଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","ଲାଗିଂ ପା ହେୱାର୍‌ ୱାରି କାଜିଂ ପାର୍ତି କିୱାଦାଂ କାବା ଆତିଲେ ହେୱାନ୍‌ ହେୱାରିଂ ୱେନ୍‌ବାତାନ୍‌, “ଇବେ ମିବେ ଇନାକାତ ଇଚୁକ୍‌ କାଦି ମାନାତ୍‌ ?” ");
INSERT INTO peg_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","ହେବେଣ୍ଡାଂ ହେୱାର୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ରଞ୍ଜାଙ୍ଗ୍‌ ୱାସ୍ତି ମିନ୍‌ ହିତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","ଆରେ, ଜିସୁ ଅଜ଼ି ହେୱାର୍‌ ମୁମ୍‌ଦ ଚିଚାନ୍‍ । ");
INSERT INTO peg_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","ଆରି, ହେୱାନ୍‌ ହେୱାରିଂ ଇଚାନ୍‌ ମସାତି ବିଦି ଆରି ବେଣ୍‌ବାକ୍‌ଣାୟ୍‌କିନାକାର୍‌ ଆରି ନାନ୍ଦ୍‌କେର୍‍ନି ସାସ୍ତର୍‌ତାକେ ନା ବିସ୍ରେ ଇନା ଇନାକା ଇନାକା ଲେକା ଆତାତ୍‌ନ୍ନା, ହେ ସବୁ ପୁରା ଆନାକା ଲଡ଼ା, “ଆନ୍‌ ମି ହୁଦାଂ ରଚେ ମାନିହିଂ ମିଙ୍ଗେଙ୍ଗ୍‌ ଇ ସବୁ ବେରଣ୍‌ ଇଞ୍ଜିମାନ୍‌ଚାଙ୍ଗ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","ହେ ପାଦ୍‌ନା ହେୱାର୍‌ ଇନେସ୍‌ ଦର୍ମ ସାସ୍ତର୍‌ ବୁଜା ଆନାର୍‌, ହେଦାଂ କାଜିଂ ହେୱାନ୍‌ ହେୱାରିଂ ବୁଦିନି ହାଜ଼ି ଜେତାନ୍‍; ");
INSERT INTO peg_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","ଆରେ, ହେୱାନ୍‌ ହେୱାରିଂ ଇଚାନ୍‌, ଇ ଲାକେ ଲେକା ମାନାତ୍‌, “କ୍ରିସ୍ଟ ଦୁକ୍‍ବଗି କିନାନ୍‌ ଆରି ତିନି ଦିନ୍‌ତାଂ ହାକିତାକେତାଂ ନିଙ୍ଗ୍‌ନାନ୍‌, ");
INSERT INTO peg_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","ଆରେ ଜିରୁସାଲମ୍‌ତାଂ ହାଙ୍ଗ୍‍ଜି ୱିଜ଼ୁ ଜାତି ତାକେ ହେୱାନ୍‌ ତର୍‌ଦ ପାପ୍‌ କେମା କାଜିଂ ମାନ୍‌ବାଦ୍‌ଲାୟ୍‌ ବେରଣ୍‌ ସୁଣାୟ୍‌ କିତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","ଏପେଙ୍ଗ୍‌ ଇ ୱିଜ଼ୁ ବିସ୍ରେ ସାକି ଆନାଦେର୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","ଆରେ ହୁଡ଼ାଟ୍‌, ନା ଆବା ଇନାକା ରାଣ୍‌ ହିତ୍‌ତାନ୍ନା, ହେଦାଂ ଆନ୍‌ ମି ତାକେ ପକ୍ତାନାଙ୍ଗା, ମାତର୍‌ ଜପିତାଂ ସାକ୍ତି ପାୟାୱି ପାତେକ୍‌ ଏପେଙ୍ଗ୍‌ ଇ ଗାଡ଼୍‌ଦ ମାନାଟ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","ତା ପାଚେ ଜିସୁ ହେୱାରିଂ ବେତ୍‌ନିୟା ହାନି ହାଜ଼ି ପାତେକ୍‌ ଅଜ଼ି ହାଚାର୍‌ ଆରି ଜାର୍‌ କେଇ ପେସ୍‌ଜି ହେୱେରିଂ ଆସିର୍ବାଦ୍‌ କିତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","ଆରେ, ହେୱାରିଂ ଆସିର୍ବାଦ୍‌ କିଉ କିଉ ଜିସୁ ହେୱାର୍‌ ତାଙ୍ଗ୍‌ ଏଡ଼ା ଆଜ଼ି ସାର୍ଗେଜପି ହାଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","ଆରେ, ହେୱାର୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ଜୱାର୍‌ କିଜ଼ି ବେସି ୱାରିତାଂ ଜିରୁସାଲମ୍‌ତ ଲେଉଟା ଆତାର୍‌, ");
INSERT INTO peg_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","ଆରେ ହେୱାର୍‌ ନିତ୍ରେ ମନ୍ଦିର୍‌ତ ମାନ୍‌ଞ୍ଜି ଇସ୍ୱର୍ତି ଦନ୍ୟବାଦ୍‌ କିଜ଼ି ମାଚାର୍‌ ।");
INSERT INTO peg_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","ହିଗ୍‌ଦ ବଚନ୍‌ ମାଚାନ୍‌, ବଚନ୍‌ ଇସ୍ୱର୍‌ ଲାହାଙ୍ଗ୍‌ ମାଚାନ୍‌, ହେୱାନ୍‌ ଆରି ଇସ୍ୱର୍‌ ଏକ୍‌ ମାଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","ହେୱାନ୍‌ ହିଗ୍‌ଦ ଇସ୍ୱର୍‌ ଲାହାଙ୍ଗ୍‌ ମାଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","ତା ଲାହାଙ୍ଗ୍‌ ଇସ୍ୱର୍‌ ୱିଜ଼ୁ ବିସ୍ରେ ଉବ୍‌ଜାଣ୍‌ କିତାନ୍‌; ଆରେ ଜେ ୱିଜ଼ୁ ଉବ୍‌ଜା ଆତାତ୍‌ନ୍ନା, ହେବେତାଂ ପା ରଞ୍ଜାଙ୍ଗ୍‌ ପା ହେୱାନିଂ ପିସ୍ତି ଉବ୍‌ଜା ଆୱାତାତ୍‌ନା । ");
INSERT INTO peg_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","ହେୱାନ୍‌ ତାକେ ଜିବୁନ୍‌ ମାଚାତ୍‌ ଆରି ହେ ଜିବୁନ୍‌ ମାନାୟାର୍‌ତି ଅଜଡ଼୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","ହେ ଅଜଡ଼୍‌ ମାଜ୍‌ଗାତ ଅଜଡ଼୍‌ ଆଜ଼ି ୱାନାତା, ଆରେ ମାଜ୍‌ଗା ହେଦାଂ ମାନ୍‌ କିୱାତାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","ଇସ୍ୱର୍‌ କଚଣ୍‌ତ କାବୁର୍‌ ୱେଚ୍‌ନି ରୱାନ୍‌ ମାନାୟ୍‌ ଏକାତାନ୍‌; ହେୱାନ୍‌ ତର୍‌ ଜହନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","ହେୱାନ୍‌ ଇନେସ୍‌ ଅଜଡ଼୍‌ ବିସ୍ରେ ସାକି ହିନାନ୍‌, ଆରେ ହେୱାନ୍‌ ୱେନ୍‌ଞ୍ଜି ୱିଜ଼ାର୍‌ ପାର୍ତି କିତାର୍‌, ଇଦାଂ କାଜିଂ ହେୱାନ୍‌ ହିଦେଂ ଇଞ୍ଜି ୱାତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","ହେୱାନ୍‌ ନିଜେ ହେ ଅଜଡ଼୍‌ ହିଲ୍‌ୱାତାନ୍‌, ମାତର୍‌ ଅଜଡ଼୍‌ ବିସ୍ରେ ସାକି ହିଦେଂ ଇଞ୍ଜି ୱାତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","ଇମ୍‌ଣି ହାତ୍‌ପା ଅଜଡ଼୍‌ ପୁର୍ତି ୱାଜ଼ି ୱିଜ଼ୁ ରାଜିନି ମାନାୟାରିଂ ଅଜଡ଼୍‌ କିନାତ୍‌, ହେଦାଂ ନେ ହାତ୍‌ପା ଅଜଡ଼୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","ହେୱାନ୍‌ ପୁର୍ତିତ ମାଚାନ୍‌ ଆରି ପୁର୍ତି ହେୱାନ୍‌ ହୁକେ ଉବ୍‌ଜାଣ୍‌ ଆତାତ୍‌, ଆତିସ୍‌ପା ପୁର୍ତି ତାଙ୍ଗେଙ୍ଗ୍‌ ଚିନ୍‌କିଦେଂ ଆଡ୍‌ୱାତାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","ହେୱାନ୍‌ ଜାର୍‌ ରାଜିତ ୱାତାନ୍‌, ଆତିସ୍‌ପା ହେୱାନ୍ତି ଜାର୍‌ ଲକୁ ତାଙ୍ଗେଙ୍ଗ୍‌ ମାନ୍‌ କିୱାତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","ମତର୍‌ ଏଚେକ୍‌ ମାନାୟ୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ମାନ୍‌ କିତାର୍‌, ଇଚିସ୍‌ ଇମ୍‌ଣାକାର୍‌ ହେୱାନ୍‌ ତର୍‌ଦାଂ ପାର୍ତି କିତାର୍‌, ହେୱାନ୍‌ ୱିଜ଼ାରିଂ ହେୱାନ୍‌ ଇସ୍ୱର୍ତି କାଡ଼୍‌ଦେ ଆଦେଂ ଇଞ୍ଜି ଆଦିକାର୍‌ ହିତାନ୍‌; ");
INSERT INTO peg_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","ହେୱାର୍‌ ନେତେର୍‌ତାଂ, ଗାଗାଡ଼୍‌ନି ଇଚାତାଂ ନଲେ ମାନାୟ୍‌ ଇଚାତାଂ ଉବ୍‌ଜା ଆୱାତାର୍‌, ଇଚିସ୍‌ ଇସ୍ୱର୍‌ତାଂ ଉବ୍‌ଜା ଆତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","ଆରେ, ହେ ବଚନ୍‌ ମାନାୟ୍‌ ଆତାନ୍‌, ଆରେ ଦୟା ଆରି ହାତ୍‌ପାତ ବାର୍ତି ଆଜ଼ି ମା ବିତ୍ରେ ବାହାକିତାନ୍‌, ଆରେ ଆବାତାଂ ୱାତି ଦୁଆଁ ମାଜ଼ିଙ୍ଗ୍‌ ପାଣ୍‌ ଲାକେ ଆପେଂ ହେୱାନ୍‌ତି ପାଣ୍‌ ହୁଡ଼୍‌ତାପ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","ଜହନ୍‌ ହେୱାନ୍‌ ବିସ୍ରେ ସାକି ହିଜ଼ି ଗାଜାକାଟ୍‌ତାଂ ଇଚାନ୍‌, “ଇନେନ୍‌ ନା ପାଚେ ୱାନାନା, ହେୱାନ୍‌ ନାଙ୍ଗ୍‌ ତାଂ ଗାଜାକାନ୍‌ ଆତାନ୍ନା, ଇନାକିଦେଂକି ହେୱାନ୍‌ ନା ଆଗେ ମାଚାନ୍‌, ଇମ୍‌ଣାକାନ୍‌ ବିସ୍ରେ ଆନ୍‌ ଇଦାଂ ୱେଚ୍‌ଚି ମାନ୍‌ଚାଙ୍ଗ୍‌, ହେୱାନ୍‌ ଇୱାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","ତା ଦୟାତାଂ ବାର୍ତି ହୁକେ ମାଙ୍ଗେଙ୍ଗ୍‌ ୱିଜ଼ାର୍‌ ଆସିର୍ବାଦ୍‌ ପାୟା ଆତାସ୍‌ନା । ଆଁ, ଆସିର୍ବାଦ୍‌ ଜପି ଆସିର୍ବାଦ୍‌ ପାୟା ଆତାସ୍‌ନା । ");
INSERT INTO peg_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","ଇସ୍ୱର୍‌ ବିଦି ମସା ହୁକେ ଆତାତ୍‌ନ୍ନା, ମାତର୍‌ ଦୟା ଆରି ହାତ୍‌ପା ଜିସୁ କ୍ରିସ୍ଟତି ହୁକେ ୱାତାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","ଇନେର୍‌ ଇନାୱାଡ଼ାଲିଂ ଇସ୍ୱର୍‌ତିଂ ହୁଡ଼୍‌ୱାତାର୍ଣ୍ଣା, ଆବା ୱାକ୍‌ତ ମାନି କେବଲ୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ପାଣ୍‌ୱା ମାଜ଼ି ତାଙ୍ଗେଙ୍ଗ୍‌ ହପ୍‌ତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","ଏନେଙ୍ଗ୍‌ ଇନେର୍‌, ଇଦାଂ ଜହନ୍‌ତିଂ ୱେନ୍‌ବିନି କାଜିଂ ଜିହୁଦିର୍‌ ଏଚେକାଡ଼୍‌ଦ ଜିରୁସାଲମ୍‌ତାଂ ମାପ୍ରୁହେବାକିନାକାନ୍‌ ଆରି ଲେବିୟରିଂ ତା ଲାଗାଂ ପକ୍ତାତାର୍‌, “ହେପାଦ୍‌ନା ହେୱାନ୍‌ ଇ ସାକି ହିତାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","ହେୱାନ୍‌ ମାନି କିୱାଦାଂ, ହାର୍‌ କିଜ଼ି ୱେଚ୍‌ଚାନ୍‌, “ଆନ୍‌ କ୍ରିସ୍ଟ ଆକାୟ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","ହେବେତାଂ ହେୱାର୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ୱେନ୍‌ବାତାର୍‌, “ବାଟିଙ୍ଗ୍‌, ଏନ୍‌ ଇନାକା ଏଲିୟ ?” ହେୱାନ୍‌ ଇଚାନ୍‌, ଆନ୍‌ ଆକାୟ୍‌ । “ଏନ୍‌ ଇନାକା ହେ ବେଣ୍‌ବାକ୍‌ଣାୟ୍‌କିନାକାନ୍‌ ? ହେୱାନ୍‌ ଉତର୍‌ ହିତାନ୍‌, ଆକାୟ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","ହେବେତାଂ ହେୱାର୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ଇଚାର୍‌, ମାଙ୍ଗେଙ୍ଗ୍‌ ପକ୍ତିତି ମାନାୟାରିଂ ଇନେସ୍‌ ଉତର୍‌ ହିଦେଂ ଆଡ୍‌ନାପ୍‌, ଇଦାଂ କାଜିଂ “ଏନ୍‌ ଇନେର୍‌ ? ଜାର୍‌ତି ବିସ୍ରେ ଇନାକା ଇନାୟା ?” ");
INSERT INTO peg_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","ଜିସାୟ୍‌ ବେଣ୍‌ବାକ୍‌ଣାୟ୍‌କିନାକାନ୍‌ ଇନେସ୍‌ ଇଞ୍ଜି ମାଚାନ୍‌, ହେ ଲାକେ ଜହନ୍‌ ଇଚାନ୍‌ । ଆନ୍‌ ହେ ଲାକେ ବାଲିବାଟାତ ଗାଜାକାଟ୍‌ କିଜ଼ି ମାନି ରୱାନ୍‌ତି କାଟ୍‌ । ମାପ୍ରୁତି ହାଜ଼ି ହାଣ୍‌କୁ କିୟାଟ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","ଆରେ, ପାରୁସିର୍‌ ପକ୍‌ଚି ମାଚି କାବୁର୍‌ ହିନାକାର୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ଇଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","ହେୱାର୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ୱେନ୍‌ବାତାର୍‌, “ଏନ୍‌ ଜଦି କ୍ରିସ୍ଟ କି ଏଲିୟ ହେ ବେଣ୍‌ବାକ୍‌ଣାୟ୍‌କିନାକାୟ୍‌ ଆକାୟ୍‌, ହେଦାଂ ଆତିସ୍‌ ଇନେକିଦେଂ ବାପ୍ତିସିମ୍‌ ହିନାୟ୍‌ୟା ?” ");
INSERT INTO peg_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","ଜହନ୍‌ ହେୱେରିଂ ଉତର୍‌ ହିତାନ୍‌, “ଆନ୍‌ ଏଜ଼ୁଂତାଂ ବାପ୍ତିସିମ୍‌ ହିନାଙ୍ଗା; ଇମ୍‌ଣାକାନିଂ ଏପେଙ୍ଗ୍‌ ପୁନୁଦେର୍‌, ହେୱାନ୍‌ ମି ବିତ୍ରେ ମାନାନ୍‌; ");
INSERT INTO peg_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","ହେୱାନ୍‌ ନା ପାଚେ ୱାନାନା, ତାଙ୍ଗ୍‌ ପାନାନି ପାଣ୍ଡାଇଙ୍ଗ୍‌ ଡରି ରିକ୍‌ତେଂ ଆନ୍‌ ସମାନ୍‌ ଆକାୟ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","ଜର୍ଦନ୍‌ ନାଗୁଡ଼୍‌ ଆଣ୍ଟିପାଡ଼୍‌କା ଇମ୍‌ଣି ବେତ୍‌ନିୟାତ ଜହନ୍‌ ବାପ୍ତିସିମ୍‌ ହିିଜ଼ି ମାଚାନ୍‌, ହେ ବାହାତ ଇ ୱିଜ଼ୁ ଗିଟା ଆତାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","ଆର୍କାତ୍‌ ନାଜିଂ ହେୱାନ୍‌ ଜିସୁଙ୍ଗ୍‌ ଜାର୍‌ ଲାଗେ ୱାନାକା ହୁଡ଼୍‌ଜି ଇଚାନ୍‌, “ଏହେଁ ହୁଡ଼ା, ଇସ୍ୱର୍ତି ମେଣ୍ଡାହିମ୍‌ଣା, ଜେ ପୁର୍ତିନି ପାପ୍‌ ପିଣ୍‌ଜି ଅନାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","ନା ପାଚେ ଇନେନ୍‌ ୱାନାନା, ହେୱାନ୍‌ ନା ଗାଜାକାନ୍‌ ଆତାନ୍ନା, ଇନାକିଦେଂକି ହେୱାନ୍‌ ନା ଜଲମ୍‌ ଆଗେ ମାଚାନ୍‌, ଇମ୍‌ଣାକାନ୍‌ ବିସ୍ରେ ଆନ୍‌ ଇଦାଂ ଇଞ୍ଜି ମାଚାଙ୍ଗ୍‌, ହେୱାନ୍‌ ଇ ମାନାୟ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","ଆନ୍‌ ପା ତାଙ୍ଗେଙ୍ଗ୍‌ ଚିନ୍‌ କିୱାଦାଂ ମାଚାଙ୍ଗ୍‌, ମାତର୍‌ ହେୱାନ୍‌ ଇନେସ୍‌ ଇସ୍ରାଏଲ୍‌ ମାନାୟାର୍‌ ଲାଗେ ଚଞ୍ଜ୍‌ୟା ଆନାନ୍‌, ଇ କାଜିଂ ଆନ୍‌ ଏଜ଼ୁଂତାଂ ବାପ୍ତିସିମ୍‌ ହିଦେଂ ୱାତାଙ୍ଗ୍‌ନା ।” ");
INSERT INTO peg_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","ଆରେ, ଜହନ୍‌ ସାକି ହିଜ଼ି ଇଚାନ୍‌, “ଆନ୍‌ ଜିବୁନ୍‌ତିଂ ପାଣ୍ଡ୍‌କା ଲାକେ ବାଦାଡ଼୍‌ତାଂ ତା ଜପି ଜୁଦ୍‌ନାକା ହୁଡ଼୍‌ତାଙ୍ଗ୍‌ନ୍ନା, ଆରେ ହେଦାଂ ତା ଜପି କୁଚ୍‌ଚାତ୍‌, ଏନେଙ୍ଗ୍‌ ନା ୱାରିନି ମାଜ଼ି, ନି ତାକେ ନାତାଂ ବେସି ୱାରି ମାନାତ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","“ଆନ୍‌ ପା ତାଙ୍ଗେଙ୍ଗ୍‌ ଚିନ୍‌ କିୱାଦାଂ ମାଚାଙ୍ଗ୍‌, ମତର୍‌ ଜେ ନାଙ୍ଗେଙ୍ଗ୍‌ ଏଜ଼ୁଂତାଂ ବାପ୍ତିସିମ୍‌ ହିଦେଂ ପକ୍‌ତାନ୍‌, ହେୱାନ୍‌ ନାଙ୍ଗେଙ୍ଗ୍‌ ଇନ୍‌ଚାନ୍‌, ଇମ୍‌ଣାକାନ୍‌ ଜପି ଜିବୁନ୍‌ତିଂ ଜୁଦ୍‌ନାକା ହୁଡ଼୍‌ନାଦେର୍‌, ହେୱାନ୍‌ ହେ ମାନାୟ୍‌, ଜେ ପୁଇପୁୟା ଜିବୁନ୍ତାଂ ବାପ୍ତିସିମ୍‌ ହିନାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","ଆରେ, ଆନ୍‌ ହେଦାଂ ହୁଡ଼୍‌ତାଙ୍ଗ୍‌ନ୍ନା, ଆରି ହେୱାନ୍‌ ଇସ୍ୱର୍ତି ମାଜ଼ି ଇଞ୍ଜି ସାକି ହିନାନା ।” ");
INSERT INTO peg_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","ପାଚେନି ନାଜିଂ ଆରେ ରଗ ଜହନ୍‌ ଆରି ହେ ଚେଲାର୍‌ ବିତ୍ରେ ରିକାର୍‌ ଲାହାଙ୍ଗ୍‌ ନିଲ୍‌ଚି ମାଚାର୍‌; ");
INSERT INTO peg_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","ଆରେ, ହେୱାନ୍‌ ଜିସୁଙ୍ଗ୍‌ ହେ ହାଜ଼ି ହିଜ଼ି ହାନାକା ହୁଡ଼୍‌ଜି ତାଙ୍ଗେଙ୍ଗ୍‌ ଇଚାନ୍‌, “ଇୱାନ୍‌ ହୁଡ଼ାଟ୍‌, ଇସ୍ୱର୍ତି ମେଣ୍ଡାହିମ୍‌ଣା ।” ");
INSERT INTO peg_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","ହେ ରିକାର୍‌ ଚେଲାର୍‌ ହେ ବେରଣ୍‌ ୱେନ୍‌ଞ୍ଜି ଜିସୁତି ପାଚେ ପାଚେ ହାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","ଜିସୁ ପାଚ୍‌ବାଗାଂ ମାସ୍‌ଦି ହେୱେରିଂ ପାଚେ ପାଚେ ୱାନାକା ହୁଡ଼୍‌ଜି ୱେନ୍‌ବାତାନ୍‌, “ଏପେଙ୍ଗ୍‌ ଇନାକା ଦାହ୍‌ନାଦେରା ?” ହେୱାର୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ଉତର୍‌ ହିତାର୍‌, “ରାବ୍‌ବି ଇନାକା ଅରତ୍‌ ଗୁରୁ, ଏନ୍‌ ଇମେତାକେ ମାନାୟା ?” ");
INSERT INTO peg_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","ହେୱାନ୍‌ ହେୱେରିଂ ଇଚାନ୍‌, “ୱାଡ, ହୁଡ଼୍‌ନାଦେର୍‍ ।” ହେବେଣ୍ଡାଂ ହେୱାର୍‌ ହାଲ୍‌ଜି ହେୱାନ୍ତି ବାହା ହୁଡ଼୍‌ତାର୍‌, ଆରେ ହେ ନାଜିଂ ତା ହୁଦାଂ ମାଚାର୍‌; ଇନେକିଦେଂକି ହେପାଦ୍‌ନା ମ୍ଡିକାହାରେସ୍‌ କମ୍‌ସେକମ୍‌ ଚାର୍‌ଟା ଆଜ଼ି ମାଚାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","ଇମ୍‌ଣି ରିକାର୍‌ ଜହନ୍‌ତି ବେରଣ୍‌ ୱେନ୍‌ଞ୍ଜି ଜିସୁତି ପାଚେ ପାଚେ ହାଲ୍‌ଜି ମାଚାର୍‌, ହେୱାର୍‌ ବିତ୍ରେ ରକାନ୍‌ ସିମନ୍‌ ପିତର୍‌ ଟଣ୍ଡାହି ଆନ୍ଦ୍ରିୟ ମାଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","ହେୱାନ୍‌ ପର୍ତୁମ୍‌ ଜାର୍‌ ଟଣ୍ଡେନ୍‌ ସିମନ୍‌ତିଂ ଚଞ୍ଜ୍ୟା ଆଜ଼ି ତାଙ୍ଗେଙ୍ଗ୍‌ ଇଚାନ୍‌, ଆପେଂ ମସିୟାତି ହୁଡ଼୍‌ତାପ୍‌ନା, “ଇମ୍‌ଣାକା ଅରତ୍‌ କ୍ରିସ୍ଟ ।” ");
INSERT INTO peg_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","ହେୱାନ୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ଜିସୁ ଲାଗାୟ୍‌ ତାହିୱାତାନ୍‌ । ଜିସୁ ହେୱାନିଂ ହୁଡ଼୍‌ଜି ଇଚାନ୍‌, “ଏନ୍‌ ଜହନ୍‌ ମେହି ସିମନ୍‌ ।” ଏନ୍‌ କୈପା ସବଦ୍‌ ଅରତ୍‌ ପିତର୍‌ ନଲେ କାଲ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","ଆର୍କାତ୍‌ ନାଜିଂ ଜିସୁ ଗାଲିଲିତ ହସି ହାଜେଙ୍ଗ୍‌ ଇଞ୍ଜି ମାନ୍‌ କିତାନ୍‌, ଆରେ ହେୱାନ୍‌ ପିଲିପ୍‌ୟଙ୍ଗ୍‌ ଚଞ୍ଜ୍ୟା ଆଜ଼ି ତାଙ୍ଗେଙ୍ଗ୍‌ ଇଚାନ୍‌, “ନା ପାଚେପାଚେ ୱା ।” ");
INSERT INTO peg_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","ପିଲିପ୍‌ ବେତ୍‌ସାଇଦାନି ଲକ୍‌ ମାଚାନ୍‌, ହେଦାଂ ଆନ୍ଦ୍ରିୟ ଆରି ପିତର୍‌ତି ଗାଡ଼୍‌ ମାଚାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","ପିଲିପ୍‌ ନିତନିୟେଲ୍‌ତି ଚଞ୍ଜ୍ୟା ଆଜ଼ି ତାଙ୍ଗେଙ୍ଗ୍‌ ଇଚାନ୍‌, “ଇମ୍‌ଣାକାନ୍‌ ବିସ୍ରେ ମସା ବିଦିନି ପତିତ ଲେକିକିତାନ୍‌ନା, ଆରେ ବେଣ୍‌ବାକ୍‌ଣାୟ୍‌କିନାକାର୍‌ ପା ଲେକିକିତାର୍ଣ୍ଣା, ଆସେଙ୍ଗ୍‌ ହେୱାନିଂ ଚଞ୍ଜ୍ୟା ଆତାସ୍‌ନା; ହେୱାନ୍‌ ଜସେପ୍‌ ମାଜ଼ି ନାଜରିତିୟ ଜିସୁ ।” ");
INSERT INTO peg_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","ନିତନିୟେଲ୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ୱେନ୍‌ବାତାନ୍‌, “ନାଜରିତିୟତାଂ କି ଇନାକାପା ହାର୍‌ଦି ବିସ୍ରେ ୱାଦେଙ୍ଗ୍‌ ଆଡ଼୍‌ଦାନାତ୍‌ କି ?” ପିଲିପ୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ଇଚାନ୍‌, “ୱାଜ଼ି ହୁଡ଼ାଟ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","ଜିସୁ ନିତନିୟେଲ୍‌ତିଂ ଜାର୍‌ ଲାଗେ ୱାନାକା ହୁଡ଼୍‌ଜି ହେ ବିସ୍ରେ ଇଚାନ୍‌, “ଇଦାଂ ହୁଡ଼ା ହାତ୍‌ପାନେ ଇ ରକାନ୍‌ ଇସ୍ରାଏଲିୟ ମାନାୟ୍‌, ଇୱାନ୍‌ ତାକେ ଟିଉଲି ହିଲୁତ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","ନିତନିୟେଲ୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ୱେନ୍‌ବାତାନ୍‌, “ଏନ୍‌ ନାଙ୍ଗେଙ୍ଗ୍‌ ଇନେସ୍‌ ଚିନ୍‌କିତ୍‌ତାୟ୍‌ ?” ଜିସୁ ତାଙ୍ଗେଙ୍ଗ୍‌ ଉତର୍‌ ହିତାନ୍‌, “ପିଲିପ୍‌ ନିଙ୍ଗେଙ୍ଗ୍‌ କୁକ୍‌ତିନି ଆଗେ ଏନ୍‌ ଏଚେକାଡ଼୍‌ଦ ତଗା ମାର୍‌ ତାରେନ୍‌ ମାଚାୟ୍‌, ହେପାଦ୍‌ନା ଆନ୍‌ ନିଙ୍ଗେଙ୍ଗ୍‌ ହୁଡ଼୍‌ଜି ମାନ୍‌ଞ୍ଜାଙ୍ଗ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","ନିତନିୟେଲ୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ଉତର୍‌ ହିତାନ୍‌, “ଏ ଗୁରୁ, ଏନ୍‌ ଇସ୍ୱର୍ତି ମାଜ଼ି, ଏନ୍‌ ଇସ୍ରାଏଲ୍‌ନି ରାଜା ।” ");
INSERT INTO peg_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","ଜିସୁ ତାଙ୍ଗେଙ୍ଗ୍‌ ଉତର୍‌ ହିତାନ୍‌, “ଆନ୍‌ ନିଙ୍ଗେଙ୍ଗ୍‌ ତଗା ମାର୍‌ ତାରେନ୍‌ ହୁଡ଼୍‌ଜି ମାନ୍‌ଞ୍ଜାଙ୍ଗ୍‌ ଇଞ୍ଜି ଇଚିଲେ କି ଏନ୍‌ ପାର୍ତି କିନାୟା ? ଏନ୍‌ ଇବେତାଂ ଆରେ ଗାଜା ଗାଜା ବିସ୍ରେ ହୁଡ଼୍‍ନାୟ୍ ।” ");
INSERT INTO peg_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","ଆରେ, ହେୱାନ୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ଇଚାନ୍‌, “ହାତ୍‌ପା ହାତ୍‌ପା ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ଇଞ୍ଜ୍‌ନାଙ୍ଗା, ଏପେଙ୍ଗ୍‌ ସାର୍ଗେତ ଜେୟାନାତ୍‌ ଆରି ଇସ୍ୱର୍ତି ଦୁତ୍‌ର୍‌ ମାନାୟ୍‌ ମାଜ଼ିତି ଜପି ଦୁମ୍‌ନାକା ଆରି ଜୁଦ୍‌ନାକା ହୁଡ଼୍‌ନାଦେର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","ତିନ୍‌ ଦିନ୍ତ ଗାଲିଲିନି କାନାତ ର ବିବା ମାଚାତ୍‌, ଆରେ ଜିସୁ ତେହି ହେବେ ମାଚାତ୍‌; ");
INSERT INTO peg_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","ଜିସୁ ପା ଜାର୍‌ ଚେଲାର୍‌ ଲାହାଙ୍ଗ୍‌ ହେ ବିବାତ କୁକ୍ୟା ଆତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","ବଜି ୱିଜ଼୍‌ୱିହିଙ୍ଗ୍‌ ହେୱାର୍‌ତି ଅଙ୍ଗୁର୍‌ ରାସ୍‌ ୱିସ୍ତିଲେ ଜିସୁ ତେହି ଜିସୁଙ୍ଗ୍‌ ଇଚାତ୍‌, “ହେୱାର୍‌ତି ଅଙ୍ଗୁର୍‌ ରାସ୍‌ ହିଲୁତ୍‍ ।” ");
INSERT INTO peg_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","ହେବେଣ୍ଡାଂ ଜିସୁ ତାଙ୍ଗେଙ୍ଗ୍‌ ଇଚାନ୍‌, ନି ଲାହାଙ୍ଗ୍‌ ନାଦି ଇନାକା ମାନାତ୍‌ “ନାଙ୍ଗ୍‌ ଇନେକିଦେଂ ଇବେ ମିହାୟ୍‍ କିଦ୍‌ନାୟା ? ନା ସମୁ ଅଙ୍ଗୟ୍‌ ପାତେକ୍‌ ଏକା ଆୱାତାତ୍‌ନା ।” ");
INSERT INTO peg_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","ହେ ତେହି ହେବା କିନାକାରିଂ ପାସ୍‌ପାନାକାରିଂ ଇଚାତ୍‌, “ହେୱାନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ଇନାକା ଇଞ୍ଜ୍‌ନାନ୍‌, ହେଦାଂ କିୟାଟ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","ଆରେ, ହେବେ ଜିହୁଦିର୍ତି ନିର୍ମଲ୍‌ ଆନି ରିତି ଲାକେ ସହେ ଲିଟର୍‌ ଏଜ଼ୁଂ ଇଡ଼୍‌ଜି ଚଅଗଟା କାଲ୍‌କୁ କୁଣ୍ଡ୍‌ ଇଡ଼୍‌ଜି ମାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","ଜିସୁ ଆଡ଼ିୟାରିଂ ଇଚାନ୍‌, “କୁଣ୍ଡ୍‌କୁକାଂ ଏଜ଼ୁଂ ବାର୍ତି କିୟାଟ୍‌ ।” ହେବେଣ୍ଡାଂ ହେୱାର୍‌ ହେ ୱିଜ଼ୁ ଅଟି ପାତେକ୍‌ ବାର୍ତିକିତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","ଆରେ, ହେୱାନ୍‌ ହେୱାରିଂ ଇଚାନ୍‌, “ନଙ୍ଗୟ୍‌ ଉନ୍‌ଦି ଅଜ଼ି ବଜିନି ମୁଣିକାଂ ଲାଗେ ଅହାଟ୍‌ ।” ହେବେଣ୍ଡାଂ ହେୱାର୍‌ ଅଜ଼ି ହାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","ବଜିନି ମୁଣିକା ଅଙ୍ଗୁର୍‌ ରାସ୍‌ ଆଜ଼ି ମାଚି ହେ ଏଜ଼ୁଂ ୱେଣ୍‌ଜି ହେଦାଂ ଇମେତାଂ ୱାତିକ୍‌, ଇଦାଂ ପୁନ୍‌ୱାଦାଂ ମାଚିଲେ ମାତର୍‌ ଇମ୍‌ଣି ହେବା କିନାକାର୍‌ ଏଜ଼ୁଂ ଉନ୍‌ଦି ମାଚାର୍‌, ହେୱାର୍‌ ପୁନ୍‌ଞ୍ଜି ମାଚାର୍‌ ବିବାଆନାକାନିଂ କୁକ୍‌ଚି ଇଚାର୍‌, ");
INSERT INTO peg_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","“ୱିଜ଼ାକାର୍‌ ପର୍ତୁମ୍‌ତ ହାର୍ଦି ଅଙ୍ଗୁର୍‌ ରାସ୍‌ ହିନାର୍‌, ଆରେ ମାନାୟାର୍‌ ଉଣ୍‌ଜି ହଚ୍‌ଚି ପାଚେ ଜବାକାଲିଂ ହିନାର୍‌; ଏପେଙ୍ଗ୍‌ ଅଙ୍ଗୟ୍‌ ପାତେକ୍‌ ହାର୍ଦି ଅଙ୍ଗୁର୍‌ ରାସ୍‌ ଇଡ଼୍‌ତାଦେର୍ଣ୍ଣା ।” ");
INSERT INTO peg_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","ଜିସୁ ଇ ଲାକେ ଗାଲିଲିନି କାନାତ ପର୍ତୁମ୍‌ କାବାକିନି କାମାୟ୍‌ ହାଂଜି ଜାର୍‌ ପାଣ୍‌ ଚଚ୍‌ଚାନ୍‌, ଆରେ ତା ଚେଲାର୍‌ ତା ତାକେ ପାର୍ତି କିତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","ଇଦାଂ ପାଚେ ହେୱାନ୍‌ ଜାର୍‌ ଆୟାଂ, ଟଣ୍ଡାର୍‌ବାଇ ଆରି ଚେଲାର୍‌ ଲାହାଙ୍ଗ୍‌ କପର୍ନାହୁମ୍‌ ତାକେ ହାଚାର୍‌; ପାଚେ, ହେୱାର୍‌ ହେବେ ବେସି ଦିନ୍‌ ମାନ୍‌ୱାତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","ହେ ପାଦ୍‌ନା ଜିହୁଦିର୍ତି ନିସ୍ତାର୍‌ ପାର୍ବୁ ଲାଗେ ଆଜ଼ି ମାଚାତ୍‌, ଆରେ ଜିସୁ ଜିରୁସାଲମ୍‌ତ ହାଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","ହେବେ ହେୱାନ୍‌ ହୁଡ଼୍‌ତାନ୍‌, ମନ୍ଦିର୍‌ ବିତ୍ରେ ମାନାୟ୍‌ କଡିଙ୍ଗ୍‌, ମେଣ୍ଡା ଆରି ପାଣ୍ଡ୍‌କା ବେପ୍‌ରିୟାରିଂ ଆରେ ଡାବୁଙ୍ଗ୍‌ ବେପ୍‌ରିୟାରିଂ କୁର୍ଚି ଜପି ଗାଡ଼ି କିଜ଼ି ମାନାକା ହୁଡ଼୍‌ତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","ହେବେ ହେୱାନ୍‌ ଡରିତାଂ ର କରଡା ରଚ୍‌ଚି କଡି ଆରି ମେଣ୍ଡାକାଂ ୱିଜ଼ାରିଂ ମନ୍ଦିର୍‌ତାଙ୍ଗ୍‌ ବାର୍‌ତ ହପ୍‌ତାନ୍; ଆରେ, ଡାବୁଙ୍ଗ୍‌ ବେପ୍‌ରିୟାର୍‌ତି ଡାବୁଙ୍ଗ୍‌ ସବୁ ଡ଼ିୱିଜି ହେୱାର୍‌ତି ଟେବୁଲିଂ ଉଲ୍‌ଟାୟ୍‌ କିଜ଼ି ଡାବୁଙ୍ଗ୍‌ ତାରେନ୍‌ ଡ଼ିୱିତାର୍‌; ");
INSERT INTO peg_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","ଆରେ, ହେୱାନ୍‌ ପାଣ୍ଡ୍‌କା ବେପ୍‌ରିୟାରିଂ ଇଚାନ୍‌, “ଇୱାକାଂ ଇବେଣ୍ଡାଂ ଅହାଟ୍‌, ମାଞ୍ଜି ଆବା ଇଲ୍‌ଦିଂ ବେପ୍‌ପାର୍‌ ଇଲ୍‌ କିମାଟ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","“ମି ଇଲ୍‌ କାଜିଂ ଇଚା ନାଙ୍ଗେଙ୍ଗ୍‌ ୱିସ୍ତାନାତ୍ ଇଦାଂ ଲେକା ମାନାତ୍‌ ଇଞ୍ଜି ତା ଚେଲାର୍‌ ମାନ୍ତ ଏତୁ କିତାର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","ହେବେ ଜିହୁଦିର୍‌ତାଂ ଉତର୍‌ ହିତାର୍‌, “ଏନ୍‌ ଇ ସବୁ କାମାୟ୍‌ କିନି କାଜିଂ ଆଦିକାର୍‌ ପାୟ୍‌ଆତାଂନା ଇଞ୍ଜି ଆପେଂ ଇନେସ୍‌ ପୁନାପ୍‌ ?” ଆରେ ଇମ୍‌ଣି ଚିନ୍‌ ହୁକେ ମାଙ୍ଗେଙ୍ଗ୍‌ ହେଦାଂ ଚଚ୍‌ଚାନାୟା । ");
INSERT INTO peg_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","ଜିସୁ ହେୱେରିଂ ଉତର୍‌ ହିତାନ୍‌, “ଏପେଙ୍ଗ୍‌ ଇ ମନ୍ଦିର୍‌ତିଂ ବାଡ଼୍‌ହାୟ୍‌ କିୟାଟ୍‌, ଆରେ ତିନି ଦିନ୍‌ ବିତ୍ରେ ଆନ୍‌ ହେଦାଂ ରଚ୍‌ନାଙ୍ଗ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","ହେବେ ଜିହୁଦିର୍‌ ଇଚାର୍‌, “ଇ ମନ୍ଦିର୍‌ ରଚ୍‌ଚେଂ ଇଞ୍ଜି ରିକଡ଼ିଚ ବାର୍ହୁ ଲାଗାଆତ୍‌ନା; ଆରେ ଏନ୍‌ ଇନାକା ହେଦେଲିଂ ତିନ୍‌ଦିନ୍‌ତାଂ ରଚ୍‌ଚେଂ ଆଡ୍‌ନାୟ୍‌ ?” ");
INSERT INTO peg_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","ମାତର୍‌ ହେୱାନ୍‌ ନିଜାର୍‌ ଗାଗାଡ଼୍‌ ବାର୍ତାକା ମନ୍ଦିର୍‌ତିଂ ହୁଡ଼୍‌ଜି ଇଦାଂ ଇଞ୍ଜି ମାଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","ଲାଗିଂ ହେୱାନ୍‌ ହାତାକାର୍‌ ବିତ୍ରେତାଂ ନିଙ୍ଗ୍‌ତି ପାଚେ ତା ଚେଲାର୍‌ ହେୱାନ୍‌ ଇଦାଂ ଇଞ୍ଜି ମାଚାନ୍‌ ଇଞ୍ଜି ଏତ୍‌ କିତାର୍‌; ପାଚେ, ହେୱାର୍‌ ଦରମ୍‌ ସାସ୍ତର୍‌ ଆରି ଜିସୁ ଇଞ୍ଜିମାଚି ବଚନ୍‌ ପାର୍ତି କିତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","ନିସ୍ତାର୍‌ ପାର୍ବୁ ସମୁତ ହେୱାନ୍‌ ଜିରୁସାଲମ୍‌ତ ମାନିୱାଡ଼ାଙ୍ଗ୍‌ ହେନି ତାଙ୍ଗେଙ୍ଗ୍‌ କିତାକା କାବାଆନି କାମାୟିଙ୍ଗ୍‌ ହୁଡ଼୍‌ଜି ତା ତର୍‌ଦାଂ ପାର୍ତି କିତାର୍‌, ");
INSERT INTO peg_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","ମାତର୍‌ ଜିସୁ ହେୱାର୍‌ ଜପି ପାର୍ତି କିୱାଦାଂ ମାଚାନ୍‌ ଇନାକିଦେଂକି ହେୱାର୍‌ ମାନ୍ତ ପୁନ୍‌ଞ୍ଜି ମାଚାନ୍‌, ");
INSERT INTO peg_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","ଆରେ, ଇମ୍‌ଣାକାନ୍‌ ଜେ ମାନାୟ୍‌ ବିସ୍ରେ ସାକି ହିନାନ୍‌, ଇଦାଂ ତାଦାଙ୍ଗ୍‌ ଲଡ଼ା ହିଲ୍‌ୱାତାତ୍‌, ଲାଗିଂ ମାନାୟ୍‌ ୱାସ୍କିତ ଇନାକା ମାନାତ୍‌, ହେଦାଂ ହେୱାନ୍‌ ନିଜେ ପୁଞ୍ଜିମାଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","ପାରୁସିର୍‌ ବିତ୍ରେ ନିକଦିମ୍‌ ତର୍‌ଦାକାନ୍‌ ରୱାନ୍‌ ମାନାୟ୍‌ ମାଚାନ୍‌, ହେୱାନ୍‌ ଜିହୁଦିର୍‌ ରୱାନ୍‌ ମୁଡ଼୍‌ଦାକାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","ହେୱାନ୍‌ ନାଣା ସମୁତ ଜିସୁତି ଲାଗେ ୱାଜ଼ି ତାଙ୍ଗେଙ୍ଗ୍‌ ଇଚାନ୍‌, “ଏ ଗୁରୁ, ଏନ୍‌ ଜେ ଇସ୍ୱର୍‌ତାଂ ୱାଜ଼ି ମାଚି ଗୁରୁ, ଇଦାଂ ଆପେଂ ପୁନାପ୍‌, ଇନାକିଦେଂକି ଏନ୍‌ ଇ ଇମ୍‌ଣି ୱିଜ଼ୁ କାବାଆନି କାମାୟ୍‌ କିତାୟ୍‌ନା, ଇସ୍ୱର୍‌ ଲାହାଂ ହିଲ୍‌ୱିତିସ୍‌ ହେ ସବୁ ଇନେର୍‌ କିଦେଙ୍ଗ୍‌ ଆଡୁର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","ଜିସୁ ତାଙ୍ଗେଙ୍ଗ୍‌ ଉତର୍‌ ହିତାନ୍‌, “ହାତ୍‌ପା ହାତ୍‌ପା ଆନ୍‌ ନିଙ୍ଗେଙ୍ଗ୍‌ ଇଞ୍ଜ୍‌ନାଙ୍ଗ୍‌, ଆରେ ରଗ ଜଲମ୍‌ ଆୱିତିସ୍‌ ଇନେର୍‌ ଇସ୍ୱର୍‌ ରାଜି ହୁଡ଼୍‌ଦେଂ ଆଡୁନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","ନିକଦିମ୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ୱେନ୍‌ବାତାନ୍‌, “ବୁଡ଼୍‌ହି ଆତିସ୍‌ ମାନାୟ୍‌ ଇନେସ୍‌ କିଜ଼ି ଜଲମ୍‌ ଆନାନ୍‌ ? ହେୱାନ୍‌ ଇନାକା ରି ହାଜାର୍‌ ଆୟା ପଟତ ହଣ୍‌ଜି ଜଲମ୍‌ ଆଦେଂ ଆଡ୍‌ନାଂ ?” ");
INSERT INTO peg_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","ଜିସୁ ଉତର୍‌ ହିତାନ୍‌, ହାତ୍‌ପା ହାତ୍‌ପା “ଆନ୍‌ ନିଙ୍ଗେଙ୍ଗ୍‌ ଇଞ୍ଜ୍‌ନାଙ୍ଗ୍‌,” ଏଜ଼ୁଂ ଆରି ଜିବୁନ୍‌ତାଂ ଜଲମ୍‌ ଆୱିତିସ୍‌ ଇନେର୍‌ ଇସ୍ୱର୍ତି ରାଜିତ ହଣ୍ଡେଙ୍ଗ୍‌ ଆଡୁନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","ଗାଗାଡ଼୍‌ତାଂ ଇନାକା ଆତାତ୍‌ନ୍ନା, ହେଦାଂ ଗାଗାଡ଼୍‌; ଆରେ, ଜିବୁନ୍ତାଂ ଇନାକା ଆତାତ୍‌ନ୍ନା, ହେଦାଂ ଜିବୁନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","ନିଙ୍ଗେଙ୍ଗ୍‌ ଆରେ ରଗ ଜଲମ୍‌ ଆନାକା ମାନାତ୍‌ ଇଞ୍ଜି ଆନ୍‌ ଜେ ନିଙ୍ଗେଙ୍ଗ୍‌ ଇନ୍‌ଚାଙ୍ଗ୍‌, ଇଦାଂ କାବା ଆମାଟ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","ଡ଼ୁଇ ଇମ୍‌ଣି ବାଗାଙ୍ଗ୍‌ ମାନ୍‌ କିନାତ୍‌, ହେ ବାଗାଙ୍ଗ୍‌ ହାନାତ୍‌ ଆରେ ଏପେଙ୍ଗ୍‌ ତାଦାଙ୍ଗ୍‌ ଗାଜାର୍‍ ୱେନ୍‌ଞ୍ଜି ମାନାଦେର୍‌, ମାତର୍‌ ହେଦାଂ ଇମେତାଂ ୱାନାତ୍‌ ଆରେ ଇମେ ନିପ ହାନାତ୍‌, ହେଦାଂ ପୁନୁଦେର୍‌; ଜିବୁନ୍‌ତାଂ ଉବ୍‌ଜାଣ୍‌ ୱିଜ଼ାର୍‌ ମାନାୟ୍‌ ବିସ୍ରେ ହେ ଲାକେ । ");
INSERT INTO peg_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","ନିକଦିମ୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ଉତର୍‌ ହିତାନ୍‌, “ଇ ୱିଜ଼ୁ ଇନେସ୍‌ ଆନାତ୍‌ ?” ");
INSERT INTO peg_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","ଜିସୁ ତାଙ୍ଗେଙ୍ଗ୍‌ ଉତର୍‌ ହିତାନ୍‌, “ଏନ୍‌ ଇସ୍ରାଏଲ୍‌ନି ରକାୟ୍‌ ଗୁରୁ ଆଜ଼ି ପା ଇନାକା ଇ ସବୁ ବୁଜାଆଉୟା ? ");
INSERT INTO peg_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","ଆନ୍‌ ନିଙ୍ଗେଙ୍ଗ୍‌ ହାତ୍‌ପା ଇଞ୍ଜ୍‌ନାଙ୍ଗା, ଆପେଂ ଇମ୍‌ଣାକା ପୁନାପ୍‌, ହେଦାଂ ଇନାପ୍‌, ଆରେ ଇନାକା ହୁଡ଼୍‌ତାପ୍‌ନା, ତା ବିସ୍ରେ ସାକି ହିନାପ୍‌, ଆରେ ଏପେଙ୍ଗ୍‌ ମାଦାଂ ସାକି ଇଟୁଦେରା । ");
INSERT INTO peg_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ପୁର୍ତି ବିସ୍ରେ ଇଞ୍ଜିସ୍‌ ଜଦି ଏପେଙ୍ଗ୍‌ ପାର୍ତି କିୱିତିସ୍‌, ତେବେ ମିଙ୍ଗେଙ୍ଗ୍‌ ସାର୍ଗେ ବିସ୍ରେ ଇଞ୍ଜିସ୍‌ ଇନେସ୍‌ ପାର୍ତି କିନାଦେର୍‌ ? ");
INSERT INTO peg_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","ଇମ୍‌ଣି ମାନାୟ୍‌ ମାଜ଼ି ସାର୍ଗେତାଂ ଜୁତ୍‌ତାନ୍‌, ହେୱାନିଂ ପିସ୍ତି ଆରେ ଇନେର୍‌ ସାର୍ଗେ ହାଲ୍‌ୱାତାର୍‌ନା ।” ");
INSERT INTO peg_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","ଆରେ, ମସା ଇନେସ୍‌କି ବାଟାତ ପିତାଡ଼୍‌ ରାଚ୍‌ତିଂ ଜପି ପେସ୍‌ଜି ମାଚାନ୍‌, ମାନାୟ୍‌ ମାଜ଼ି ପା ହେ ଲାକେ ଜପି ପେଜ଼୍‌ୟା ଆନାନ୍‌, ");
INSERT INTO peg_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","ଇନେସ୍‌ ଇନେର୍‌କି ତା ତାକେ ପାର୍ତି କିତାର୍‌, ହେୱାନ୍‌ ୱିଜ଼୍‌ୱି ଜିବୁନ୍‌ ପାୟା ଆନାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","ଇନାକିଦେଂକି ଇସ୍ୱର୍‌ ପୁର୍ତିତିଂ ଏଚେକ୍‌ ଜିଉନତାନ୍‍ ଜେ, ହେୱାନ୍‌ ଜାର୍‌ ପାଣ୍‍ଆଁ ମାଜ଼ିଙ୍ଗ୍‌ ଦାନ୍‌ କିତାନ୍‌, ଇନେସ୍‌ ଇନେର୍‌କି ତା ତାକେ ପାର୍ତି କିତାର୍‌, ହେୱାନ୍‌ ନସ୍ଟ ଆୱାଦାଂ ୱିଜ଼୍‌ୱି ଜିବୁନ୍‌ ପାୟା ଆନାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","ଇସ୍ୱର୍‌ ତା ମେହିଙ୍ଗ୍‌ ପୁର୍ତିତ ବିଚାର୍‌ କିନି କାଜିଂ ଆକାୟ୍‌, ମାତର୍‌ ପୁର୍ତିତ ଇନେସ୍‌ ତା ଲାହାଙ୍ଗ୍‌ ମୁକ୍ତି ଆନାନ୍‌ ହେଦାଂ କାଜିଂ ପକ୍‌ତାନ୍‌ନା । ");
INSERT INTO peg_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","ଇନେନ୍‌ ମାଜ଼ିତାକେ ପାର୍ତି କିତାର୍‌, ହେୱାନ୍‌ ବିଚାର୍‌ କିୟାଆଉନ୍‌; ଇନେନ୍‌ ପାର୍ତି କିଉନ୍‌, ହେୱାନ୍‌ ବିଚାର୍‌ କିୟାଆତାନେ, ଇନାକିଦେଂକି ହେୱାନ୍‌ ଇସ୍ୱର୍ତି ପାଣ୍‍ଆଁ ମାଜ଼ି ତର୍‌ଦ ପାର୍ତି କିୱାତାନ୍‌ନା । ");
INSERT INTO peg_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","ଆରେ, ହେ ବିଚାର୍‌ ଇ, ପୁର୍ତିତ ଅଜଡ଼୍‌ ୱାତାତ୍‌, ମାତର୍‌ ମାନାୟାର୍‌ ଅଜଡ଼୍‌ ପିସ୍ତି ମାଜ୍‌ଗାତିଂ ଜିଉନତାର୍‌, ଇନାକିଦେଂକି ହେୱାର୍‌ତି କାମାୟ୍‌ ସବୁ ବାନ୍ୟା । ");
INSERT INTO peg_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","ଇନାକିଦେଂକି ଇନେର୍‌କି ବାନ୍ୟା କାମାୟ୍‌ କିନାନ୍‌, ହେୱାନ୍‌ ଅଜଡ଼୍‌ତିଂ ଗିଣ୍‌ କିନାନ୍‌, ଆରେ କାତେହିନା ସତ୍‌ କାମାୟ୍‌ନି ଦସ୍‌ ହନାତ୍‌, ଇଦାଂ କାଜିଂ ହେୱାନ୍‌ ଅଜଡ଼୍‌ ଲାଗାଂ ୱାଉନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","ମାତର୍‌ ଇନେନ୍‌କି ହାତ୍‌ପା ବେବାର୍‌ କିନାନ୍‌, ହେୱାନ୍‌ ଅଜଡ଼୍‌ ଲାଗାଂ ୱାନାନ୍‌, ଇନେସ୍‌ ହେଦାଂ ୱିଜ଼ୁ କାମାୟ୍‌ ସବୁ ଇସ୍ୱର୍‌ ତାକେ କିତାକା ଇଞ୍ଜି ହନାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","ଇଦାଂ ପାଚେ ଜିସୁ ଆରି ତା ଚେଲାର୍‌ ଜିହୁଦା ଦେସ୍‌ତ ହାଚାର୍‌, ଆରେ ହେୱାନ୍‌ ହେ ବାହାତ ହେୱେର୍‌ ଲାହାଙ୍ଗ୍‌ ମାନ୍‌ଞ୍ଜି ବାପ୍ତିସିମ୍‌ ହିଦେଂ ଲାଗାତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","ଜହନ୍‌ ପା ସାଲମ୍‌ ଲାଗେ ଏନନ୍‌ତ ଜହନ୍‌ ବାପ୍ତିସିମ୍‌ ହିିଜ଼ି ମାଚାନ୍‌, ଇନାକିଦେଂକି ହେ ବାହାତ ବେସି ଏଜ଼ୁଂ ମାଚିକ୍‌, ଆରେ ମାନାୟାର୍‌ ୱାଜ଼ି ବାପ୍ତିସିମ୍‌ ଅଜ଼ି ମାଚାର୍‌; ");
INSERT INTO peg_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","ଜହନ୍‌ ହେ ପାତେକ୍‌ ଜଇଲ୍‌ ଇଞ୍ଜ ଗେହ୍‌ନାକା ଆୱାଦାଂ ମାଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","ହେ ବିତ୍ରେ ନିର୍ମଲ୍‌ କାମ୍‌ ବିସ୍ରେ ଜହନ୍‌ କେତେକ୍‌ ଚେଲାର୍‌ ରୱାନ୍‌ ଜିହୁଦି ଲାହାଙ୍ଗ୍‌ ଉର୍‌ଜି କିବାଆତାର୍‌ ");
INSERT INTO peg_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","ଆରେ, ହେୱାର୍‌ ଜହନ୍‌ ଲାଗେ ହାଲ୍‌ଜି ତାଙ୍ଗେଙ୍ଗ୍‌ ଇଚାର୍‌, “ଏ ଗୁରୁ, ଜେ ଜର୍ଦନ୍‌ନି ଆଣ୍ଟିପାଡ଼୍‌କା ନି ଲାହାଙ୍ଗ୍‌ ମାଚାର୍‌, ଇନେନ୍‌ ବିସ୍ରେ ଏନ୍‌ ସାକି ହିତାୟ୍‌ନା, ହୁଡ଼ାଟ୍‌, ହେୱାନ୍‌ ବାପ୍ତିସିମ୍‌ ହିନାନା ଆରି ୱିଜ଼ାକାର୍‌ ତା ଲାଗେ ହାନାରା ।” ");
INSERT INTO peg_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","ଜହନ୍‌ ଉତର୍‌ ହିତାନ୍‌, “ସାର୍ଗେତାଂ ହିଦ୍ୟାଆୱିତିସ୍‌ ମାନାୟ୍‌ ବିର୍‌କୁଲ୍‌ ପାୟା ଆଉନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","ଆନ୍‌ ଜେ କ୍ରିସ୍ଟ ଆକାୟ୍‌, ମାତର୍‌ ତା ଆଗେ ପକ୍ୟା ଆତାଙ୍ଗ୍‌ନା, ଇଦାଂ ଆନ୍‌ ଇଞ୍ଜି ମାଚାଙ୍ଗ୍‌ ଇଞ୍ଜି ଏପେଙ୍ଗ୍‌ ନିଜ୍‌ ନିଜ୍‌ ନା ସାକି । ");
INSERT INTO peg_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","ଇନେନ୍‌ ଗାଡ଼୍‌ ଇଟ୍‌ନାନ୍‌, ହେୱାନ୍‌ ବିବାଦାଂଣେନ୍‌, ମାତର୍‌ ବିବାଦାଂଣେନ୍‌ତି ଇମ୍‌ଣି ସାଙ୍ଗ ଲାଗେ ନିଲ୍‌ଚି ତା କାତା ୱେନାନ୍‌, ହେୱାନ୍‌ ବିବାଦାଂଣେନ୍‌ତି କାଟ୍‌ କାଜିଂ ବେସି ୱାର୍‌ୟା ଆନାନ୍‌, ଇ ଲାକେ, ନା ଇ ୱାରି ବାର୍ତି ଆତାତ୍‌ନ୍ନା । ");
INSERT INTO peg_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","ହେୱାନିଂ ଆତିସ୍‌ପା ବାଡାନାକା ମାନାତ୍‌, ମାତର୍‌ ନାଙ୍ଗେଙ୍ଗ୍‌ ଉଣାଆଦେଂ ମାନାତ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","ଇନେନ୍‌ ସାର୍ଗେତାଂ ୱାନାନ୍‌, ହେୱାନ୍‌ ୱିଜ଼ାର୍‌ତାଂ ଗାଜା; ଇନେନ୍‌ ପୁର୍ତିତାଂ ଉବ୍‌ଜାଣ୍‌, ହେୱାନ୍‌ ପୁର୍ତିନିକାନ୍‌, ଆରେ ହେୱାନ୍‌ ପୁର୍ତିନି କାତା ଇନାନ୍‌; ଇନେନ୍‌ ସାର୍ଗେତାଂ ୱାନାନ୍‌, ହେୱାନ୍‌ ୱିଜ଼ାର୍‌ତାଂ ଗାଜାକାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","ହେୱାନ୍‌ ଇନାକା ହୁଡ଼୍‌ତାନ୍‌ନା ଆରି ୱେଚାନ୍‌ନା, ହେଦାଂ ବିସ୍ରେ ହେୱାନ୍‌ ସାକି ହିନାନ୍‌, ମାତର୍‌ ତା ସାକି ଇନେର୍‌ ମାନ୍‌କିଉର୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","ଇନେନ୍‌ ତା ସାକି ଇଡ୍‌ତାନ୍ନା, ଇସ୍ୱର୍‌ ଜେ ହାତ୍‌ପା, ଇଦାଂ ହେୱାନ୍‌ ଚିନ୍‌ ଇଡ଼୍‌ତାନ୍ନା । ");
INSERT INTO peg_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","ଇନାକିଦେଂକି ଇସ୍ୱର୍‌ ଇନେରିଂ ପକ୍‌ଚି ମାଚାନ୍‌, ହେୱାନ୍‌ ଇସ୍ୱର୍‌ତି ବଚନ୍‌ ଇନାନ୍‌, ଇନେକିଦେଂକି ହେୱାନ୍‌ ଇସ୍ୱର୍‌ତି ଜିବୁନ୍‌ତ ବାର୍ତି । ");
INSERT INTO peg_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","ଆବା ମାଜ଼ିଙ୍ଗ୍‌ ଜିଉନନାନ୍, ଆରେ ସବୁ ବିସ୍ରେ ତା କେଇଦ ହିତାନ୍‍ନା । ");
INSERT INTO peg_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","ଇନେନ୍‌ ମାଜ଼ିତାକେ ପାର୍ତି କିନାନ୍‌, ହେୱାନ୍‌ ୱିଜ଼୍‌ୱି ଜିବୁନ୍‌ ପାୟା ଆତାନ୍ନା, ମାତର୍‌ ଇନେନ୍‌ ମାଜ଼ିଙ୍ଗ୍‌ ମାନିକିଉନ୍‌, ହେୱାନ୍‌ ଜିବୁନ୍‌ ହୁଡ଼୍‌ନ୍‌, ମାତର୍‌ ହେୱାନ୍‌ ଇସ୍ୱର୍ତି କାକ୍ରିନି ଲକୁ ଆଜ଼ି ମାନାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","ଜିସୁ ଜେ ଜହନ୍‌ତାଂ ଆଦିକ୍‌ ଚେଲା କିନାନା ଆରି ବାପ୍ତିସିମ୍‌ ହିନାନା ଇଞ୍ଜି ପାରୁସିର୍‌ ୱେଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","ହାତ୍‌ପା ଜିସୁ ନିଜେ ବାପ୍ତିସିମ୍‌ ହିୱାଦାଂ ମାଚାନ୍‌, ତା ଚେଲାର୍‌ ହିିଜ଼ି ମାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","ଇଦାଂ ପାରୁସିର୍‌ ଇଞ୍ଜ୍‌ନାର୍‌ ଇଞ୍ଜି ଏଚେକାଡ଼୍‌ଦ ଜିସୁ ୱେଚାନ୍‌ । ହେଏଚେକାଡ଼ଦ ହେୱାନ୍‌ ଜିହୁଦା ଦେସ୍‌ ପିସ୍ତି ଆରେ ରଗ ଗାଲିଲିତ ହାଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","ହେୱାନ୍‌ ସମିରଣ୍‌ନି ହାଜ଼ି ହିିଜ଼ି ତାଙ୍ଗେଙ୍ଗ୍‌ ହାଞ୍ଜେଙ୍ଗ୍‌ ଲାଗାତାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","ଲାଗିଂ ହେୱାନ୍‌ ହାଲ୍‌ଜି ଜାକୁବ୍‌ ଜାର୍‌ ମାଜ଼ି ଜସେପ୍‌ତିଂ ଇମ୍‌ଣି ତାରେନ୍‌ ଇଚୁକ୍‌ ଦାନ୍‌ କିଜ଼ି ମାଚାନ୍‌, ହେବେତାଂ ଲାଗାୟ୍‌ନି ସମିରଣ୍‌ନି ସୁକାର୍‌ ତର୍‌ଦିନି ର ଗାଡ଼୍‌ଦ ଏକାତାର୍‌; ");
INSERT INTO peg_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","ହେ ବାହାତ ଜାକୁବ୍‌ତି କୁଇ ମାଚାତ୍‌ । ଇଚିସ୍‌, ଜିସୁ ହାସ୍‌ଦ ତାଙ୍ଗ୍‌ଜି ୱାସ୍ତି ମାଚିଲେ ହେ, କୁଇ ଲାଗେ କୁଚ୍‌ଚାନ୍‌ । ହେଏଚେକାଡ଼ଦ ମୁଣ୍ତାବେଲା ଆଜ଼ି ମାଚାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","ଆରେ, ର ସମିରଣ୍‌ନି କଗ୍‌ଲେ ଏଜ଼ୁଂ ଅଦେଂ ୱାତାତ୍‌ । ଜିସୁ ତାଙ୍ଗେଙ୍ଗ୍‌ ଇଚାନ୍‌, “ନାଙ୍ଗେଙ୍ଗ୍‌ ଏଜ଼ୁଂ ଉଣ୍ଡେଙ୍ଗ୍‌ ହିଦା ।” ");
INSERT INTO peg_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","ହେ ପାଦ୍‌ନା ତା ଚେଲାର୍‌ କାଦି କଡ଼୍‌ଦେଂ କାଜିଂ ବସ୍ତିତ ହାଲ୍‌ଜି ମାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","ହେବେ ସମିରଣିୟା କଗ୍‌ଲେ ଜିସୁଙ୍ଗ୍‌ ଇଚାତ୍‌, “ଏନ୍‌ ରୱାୟ୍‌ ଜିହୁଦି ଆରେ ଆନ୍‌ ରୱାଙ୍ଗ୍‌ ସମିରଣି କଗ୍‌ଲେ ଇନେସ୍‌ ନା କେଇଦି ଏଜ଼ୁଂ ଉଣ୍ଡେଙ୍ଗ୍‌ ଏନ୍ତାନାୟା ?” ଇନାକିଦେଂକି ସମିରଣିର୍‌ତି ଲାହାଙ୍ଗ୍‌ ଜିହୁଦିର୍‌ ଡୁବା ଆଉର୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","ଜିସୁ ତାଙ୍ଗେଙ୍ଗ୍‌ ଉତର୍‌ ହିତାନ୍‌, “ଇସ୍ୱର୍‌ତି ଦାନ୍‌ ଆରି ନାଂ ଉଣ୍ଡେଙ୍ଗ୍‌ ହିଦା ଇଞ୍ଜି ଇନେନ୍‌ ନିଂ ଇଞ୍ଜ୍‌ନାରା, ହେୱାର୍‌ ଇନେର୍‌, ଏଲେଙ୍ଗ୍‌ ଜଦି ଏନେଂ ପୁଚାୟ୍‌ମା, ତାଆତିସ୍‌ ଏନେଂ ତାଂ ଏନ୍ତାୟ୍‌ମା, ଆରେ ହେୱାନ୍‌ ନିଙ୍ଗେଙ୍ଗ୍‌ ଜିବୁନ୍‌ନି ଏଜ଼ୁଂ ହିତ୍‌ତାନ୍‌ମା ।” ");
INSERT INTO peg_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","ହେ କଗ୍‌ଲେହିମ୍‌ଣା ତାଙ୍ଗେଙ୍ଗ୍‌ ଇଚାତ୍‌, “ଏ ମାପ୍ରୁ,” ଏଜ଼ୁଂ ମ୍ଡୁକ୍‌ତେଂ ଇଞ୍ଜି ନି ତାକେ ଇମ୍‌ଣି ବାହା ହିଲୁତ୍‌, ଆରେ କୁଇ ତ ଡେଙ୍ଗା, “ବାଟିଙ୍ଗ୍‌ ଏନ୍‌ ଇମେତାଂ ହେ ଜିବୁନ୍‌ନି ଏଜ଼ୁଂ ପାୟା ଆତାୟ୍‌ନା । ");
INSERT INTO peg_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","ମା ଇମ୍‌ଣି ଆକର୍‌ ଦାଦିର୍‌ ଜାକୁବ୍‌ ମାଙ୍ଗେଙ୍ଗ୍‌ ଇ କୁଇ ହିିଜ଼ି ମାନ୍‌ଚାନ୍‌, ଆରେ ନିଜେ, ଆରେ ତା ମାଜ଼ିର୍‌ ଆରି ପସୁରାହି ଇବେଣ୍ଡାଂ ଉଣ୍‌ଜି ମାଚିକ୍‌, ତା ତାକେଣ୍ଡାଂ କି ଏନ୍‌ ଗାଜା ?” ");
INSERT INTO peg_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","ଜିସୁ ତାଙ୍ଗେଙ୍ଗ୍‌ ଉତର୍‌ ହିତାନ୍‌, “ଇନେର୍‌କି ଇ ଏଜ଼ୁଂ ଉଣାନ୍‌, ହେୱାନ୍‌ ଆରେ ରଗ ଏସ୍‌କି ଆନାନ୍‌; ");
INSERT INTO peg_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","ମାତର୍‌ ଆନ୍‌ ଇମ୍‌ଣି ଏଜ଼ୁଂ ହିଦ୍‌ନାଂ, ହେଦାଂ ଇନେନ୍‌କି ଉଣାନ୍‌, ହେୱାନ୍‌ ଇନାୱାଡ଼ାଂ ପା ଏସ୍‌କି ଆଉନ୍‌, ଆତିସ୍‌ ଆନ୍‌ ତାଂ ଇମ୍‌ଣି ଏଜ଼ୁଂ ହିନାଂ, ହେଦାଂ ୱିଜ଼୍‌ୱି ଜିବୁନ୍‌ ଏଜ଼ୁଙ୍ଗ୍‌ନି ୱିଜ଼୍‌ୱି ଲାକେ ତାତାକେ ଡ଼ିଜ଼ି ହାନିଂ ।” ");
INSERT INTO peg_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","କଗ୍‌ଲେହିମ୍‌ଣା ତାଙ୍ଗେଙ୍ଗ୍‌ ଇଚାତ୍‌, “ଏ ମାପ୍ରୁ,” ହିଗ୍‌ଦ ଏଜ଼ୁଂ ହିଦା ଇନେସ୍‌ ଏସ୍‌କି ଆନ୍‌ ଇନାୱାଡ଼ାଂ ଏସ୍‌କି ଆଉଙ୍ଗ୍‌, “ଆରେ ଏଜ଼ୁଂ ମ୍ଡୁକ୍‌ତେଂ ଇଞ୍ଜି ଏଚେକ୍‌ ହାଜ଼ି ଇବେ ୱାଦେଙ୍ଗ୍‌ ଲାଗ୍‌ଦେମେତ୍‌, ଇଦାଂ କାଜିଂ ନାଙ୍ଗେଙ୍ଗ୍‌ ହେ ଏଜ଼ୁଂ ହିଦା ।” ");
INSERT INTO peg_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","“ଜିସୁ ତାଙ୍ଗେଙ୍ଗ୍‌ ଇଚାନ୍‌, ହାଲା, ନି ଆଣ୍ଡ୍ରେନିଂ କୁକ୍‌ଚି ଇବେ ୱା ।” ");
INSERT INTO peg_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","କଗ୍‌ଲେହିମ୍‌ଣା ତାଙ୍ଗେଙ୍ଗ୍‌ ଉତର୍‌ ହିତାତ୍‌, “ନା ଆଣ୍ଡ୍ରେନ୍‌ ହିଲୁନ୍‌ ।” ଜିସୁ ତାଙ୍ଗେଙ୍ଗ୍‌ ଇଚାନ୍‌, ଏନ୍‌ ନା ଆଣ୍ଡ୍ରେନ୍‌ ହିଲୁନ୍‌ ଇଞ୍ଜି, ଇଦାଂ ସତ୍‌ ଇଚାୟ୍‌; ");
INSERT INTO peg_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","ମି ପାଞ୍ଜ୍‌ଜାଣ୍‌ ଡକ୍ରାଦିର୍‍ ମାଚାର୍‌, ମାତର୍‌ ନଙ୍ଗୟ୍‌ ଇନେର୍‌ ଲାହାଂ ମାନାୟା, ହେୱାନ୍‌ ନି ଆଣ୍ଡ୍ରେନ୍‌ ଆକାୟ୍‌ । ଇଦାଂ ଆନେଙ୍ଗ୍‌ ହାତ୍‌ପା ଇଞ୍ଜ୍‌ନାଙ୍ଗା । ");
INSERT INTO peg_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","କଗ୍‌ଲେହିମ୍‌ଣା ତାଙ୍ଗେଙ୍ଗ୍‌ ଇଚାତ୍‌, “ଏ ମାପ୍ରୁ,” ଏନ୍‌ ଜେ ରକାୟ୍‌ ବେଣ୍‌ବାକ୍‌ଣାୟ୍‌କିନାକାୟ୍‌, ଇଦାଂ ଆନ୍‌ ପୁଞ୍ଜ୍‌ନାଙ୍ଗା । ");
INSERT INTO peg_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","“ମା ଆବା ଲାତ୍ରା ଇ ମାଡ଼ିତ ପାର୍ତାନା କିତାର୍‌; ଆରେ, ଏପେଙ୍ଗ୍‌ ଜିହୁଦି କାଦେର୍‌ ଇଞ୍ଜ୍‌ନାଦେରା, ଇମ୍‌ଣି ବାହାତ ପାର୍ତାନା କିନାକା ଲଡ଼ା, ହେଦାଂ ଜିରୁସାଲମ୍‌ତ ମାନାତ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","ଜିସୁ ତାଙ୍ଗେଙ୍ଗ୍‌ ଇଚାନ୍‌ ଏ କଗ୍‌ଲେ, “ନା ବେରଣ୍‌ ପାର୍ତି କିୟା, ଇ ସମୁ ୱାନାତା ଇମ୍‌ଣି ସମୁତ ଏପେଙ୍ଗ୍‌ ଇ ମାଡ଼ିତ କି ଜିରୁସାଲମ୍‌ତ ପା ଆବାତି ପାର୍ତାନା କିଉଦେର୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","ଏପେଙ୍ଗ୍‌ ସମିରଣି ନିକାଦେର୍‌ ହାତ୍‌ପା ଇନେକିଦେଂ ପୁନୁଦେରା, ତାଙ୍ଗେଙ୍ଗ୍‌ ପାର୍ତାନା କିଜ଼ି ମାନାଟ୍‌ ମାତର୍‌ ଆପେଂ ଜିହୁଦିର୍‌ ଇନେରିଂ ପୁନାପ୍‌ ତା ପାର୍ତାନା କିନାପ୍‌, ଇନାକିଦେଂକି ମୁକ୍ତି ଆନାକା ଜିହୁଦିର୍‌ ବିତ୍ରେତାଂ ୱାନାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","ମାତର୍‌ ଇମ୍‌ଣି ସମୁତ ହାତ୍‌ପା ପାର୍ତାନା କିନାକାର୍‌ ଜିବୁନ୍ତ ଆରି ହାତ୍‍ପାତ ଆବାତି ପାର୍ତାନା କିତାର୍‌, ହେ ଲାଗ୍‌ଦି ସମୁ ୱାନାତା; ଆରି, ନଙ୍ଗୟ୍‌ ପା ଏକାୱାତାତ୍‌; ଇନାକିଦେଂକି ଆବା ଏପେଙ୍ଗ୍‌ ବାନି ପାର୍ତାନା ମାନ୍‍କିନାନ୍‍ । ");
INSERT INTO peg_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","ଇସ୍ୱର୍ତି ଜିବୁନ୍‌ ଆନାନ୍‌, ଆରେ କେବଲ୍‌ ଜିବୁନ୍‌ନି ସାକ୍ତି ଆରି ହାତ୍‌ପା ହୁକେ ହେୱାନ୍ତି ପାର୍ତାନା କିତାର୍‌, ହେୱାର୍‌ ଜିବୁନ୍ତ ଆରି ହାତ୍‌ପାତ ପାର୍ତାନା କିନାକା ହେୱାର୍‌ତି ଲଡ଼ା ।” ");
INSERT INTO peg_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","କଗ୍‌ଲେହିମ୍‌ଣା ତାଙ୍ଗେଙ୍ଗ୍‌ ଇଚାତ୍‌, ମସିୟା ଇମ୍‌ଣାକାନିଂ କ୍ରିସ୍ଟ ଇନାର୍‌, “ହେୱାନ୍‌ ୱାନାନା ଇଞ୍ଜି ଆନ୍‌ ପୁନାଙ୍ଗ୍‌; ଏଚେକାଡ଼୍‌ଦ ହେୱେନ୍‌ ୱାନାନ୍‌, ହେୱାନ୍‌ ମାଙ୍ଗେଙ୍ଗ୍‌ ସବୁ ବିସ୍ରେ ଜାଣାୟ୍‌ କିଦ୍‌ନାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","ଜିସୁ ତାଙ୍ଗେଙ୍ଗ୍‌ ଇଚାନ୍‌, “ମି ହୁଦାଂ ବେଣ୍‌କିଦ୍‌ନାଙ୍ଗା ଜେ ଆନ୍‌, ଆନ୍‌ ହେୱାଙ୍ଗ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","ଏଲେଙ୍ଗ୍‌ବାର୍ତି ସମୁତ ତା ଚେଲାର୍‌ ୱାଜ଼ି ତାଙ୍ଗେଙ୍ଗ୍‌ ର କଗ୍‌ଲେହିମ୍‌ଣା ଲାହାଙ୍ଗ୍‌ ବେଣ୍‌କିବାଆନାକା ହୁଡ଼୍‌ଜି କାବା ଆତାର୍‌, “ଇନାକା ଇଚା କିନାୟ୍‌,” ନଲେ ଇନେକିଦେଂ ହେଦାଂ ରଚେ ବେଣ୍‌କିନାନା, “ଇଦାଂ ଇନେର୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ୱେନ୍‌ବେଦେଂ ସାସ୍‌ କିୱାତାର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","ହେବେତାଂ ହେ କଗ୍‌ଲେହିମ୍‌ଣା ଜାର୍‌ ଗାଗ୍ରି ଇଡ଼୍‌ଜି ବସ୍ତିତ ହାଲ୍‌ଜି ମାନାୟାରିଂ ଇଚାତ୍‌, ");
INSERT INTO peg_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“ୱାଡୁ ରୱାନିଂ ହୁଡ଼୍‌ନାଦେର୍‌, ଆନ୍‌ ଇନା ଇନାକା କିତାଙ୍ଗ୍‌ନା, ହେ ୱିଜ଼ୁ ହେୱାନ୍‌ ନାଙ୍ଗେଙ୍ଗ୍‌ ଇନ୍‌ଚାନ୍‌; ହେୱାନ୍‌ ଇନେସ୍‌ ଆତିସ୍‌ କ୍ରିସ୍ଟ କାତେ ?” ");
INSERT INTO peg_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","ଇବେଣ୍ଡାଂ ଲକୁ ବସ୍ତିତ ହସି ତା ଲାଗେ ହାଞ୍ଜେଙ୍ଗ୍‌ ଲାଗାତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","ହେବେ ଚେଲାର୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ଗୱାରି କିଜ଼ି ଇଚାର୍‌, “ଏ ଗୁରୁ, ଇଚୁକ୍‌ ଚିନ୍‌ଞ୍ଜେଙ୍ଗ୍‌ ୱା !” ");
INSERT INTO peg_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","ମାତର୍‌ ଜିସୁ ହେୱେରିଂ ଉତର୍‌ ହିତାନ୍‌, “ତିନି କାଜିଂ କାଦି ନାତାକେ ମାନାତ୍‌ ତା ବିସ୍ରେ ଏପେଙ୍ଗ୍‌ ଇଚୁକ୍‌ ପୁନୁଦେର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","ଲାଗିଂ ଚେଲାର୍‌ ହେୱେର୍‌ ହେୱାର୍‌ ଇଞ୍ଜେଙ୍ଗ୍‌ ଲାଗାତାର୍‌, “ଇନେନ୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ କାଦି ତାହିହିତାନ୍‌ନା କି ?” ");
INSERT INTO peg_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","ଜିସୁ ହେୱାରିଂ ଇଚାନ୍‌, ନା ପକ୍‌ତାତାକାନ୍‌ ମାନ୍‌ ପୁରାକିନାକା ଆରି ତା ହିତି କାମାୟ୍‌ ୱିହ୍‍ନାକା, “ଇଦାଂ ନେ ନା କାଦି ।” ");
INSERT INTO peg_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","ଏପେଙ୍ଗ୍‌ ଇଞ୍ଜ୍‌ନାଦେରା ପାଚି ତ୍ରେସ୍‌ଦେଙ୍ଗ୍‌ ଇଞ୍ଜି ଆରେ ଚାରି ମାସ୍‌ ମାନାତ୍‌, ମାତର୍‌ ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ଇଞ୍ଜ୍‌ନାଙ୍ଗା ପାଚିଙ୍ଗ୍‌ ନିପହୁଡ଼ାଟ୍‌ ହେ ୱିଜ଼ୁ ତ୍ରେସ୍‌ଦେଙ୍ଗ୍‌ ଇଞ୍ଜି ହେନ୍‌ତାତେ । ");
INSERT INTO peg_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","ନଙ୍ଗୟ୍‌ ପାତେକ୍‌ ତ୍ରେସ୍‌ନାକାନ୍‌ କୁଲି ପାୟାଆନାନା ମୁଡ଼୍‌ ପାୟାଆନାନା ଆରି ୱିଜ଼୍‌ୱି ଜିବୁନ୍‌ କାଜିଂ ପାଡ଼୍‌ ରୁଣ୍ଡାୟ୍‌ କିନାନା, ଇନେସ୍‌ ୱିତ୍‌ନାକାନ୍‌ ଆରି ତ୍ରେସ୍‌ନାକାନ୍‌ ରିକାର୍‌ ମେହାଆଜ଼ି ୱାରି କିତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","ଇନାକିଦେଂକି ରକାନ୍‌ ୱିତ୍‌ନାନ୍‌ ଆରି ଆରେ ରକାନ୍‌ ତ୍ରେସ୍‌ନାନ୍‌, ଇ ବେରଣ୍‌ ହାତ୍‌ପା । ");
INSERT INTO peg_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","ଏପେଙ୍ଗ୍‌ ଇମ୍‌ଣାକାନ୍‌ କାଜିଂ କାମାୟ୍‌ କିୱାତାଦେର୍ଣ୍ଣା, ହେଦାଂ ତ୍ରେସ୍‌ଦେଙ୍ଗ୍‌ ଇଞ୍ଜି ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ପକ୍‌ତାତାଂ; ବିନ୍‌ଲଗୁ କାମାୟ୍‌ କିନାରା, ଆରେ ଏପେଙ୍ଗ୍‌ ହେୱାର୍‌ତି କାମାୟ୍‌ କିତି ଲାବ୍‌ ପାୟାଆନାଦେରା । ");
INSERT INTO peg_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","ଆନ୍‌ ଇନା ଇନାକା କିତାଙ୍ଗ୍‌ନା, ହେ ୱିଜ଼ୁ ହେୱାନ୍‌ ନାଙ୍ଗେଙ୍ଗ୍‌ ଇନ୍‌ଚାନ୍‌ ଇ କାତା ଇମ୍‌ଣି କଗ୍‌ଲେହିମ୍‌ଣା ସାକି ହିିଜ଼ି ମାଚାତ୍‌, “ତା ବେରଣ୍‌ କାଜିଂ ହେ ବସ୍ତିତ ସମିରଣିୟର୍‌ ବିତ୍ରେ ହେନି ତାତାକେ ପାର୍ତି କିତାର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","ଆରେ, ହେ ସମିରଣିୟର୍‌ ତାଂ ଲାଗେ ୱାଜ଼ି ହେୱାର୍‌ ଲାହାଙ୍ଗ୍‌ ମାଞ୍ଜେଙ୍ଗ୍‌ ଇଞ୍ଜି ତାଙ୍ଗେଙ୍ଗ୍‌ ଗୱାରି କିତାର୍‌, ଆରେ ହେୱାନ୍‌ ରି ଦିନ୍‌ ହେ ବାହାତ ମାଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","ଆରେ, ଜିସୁତି ବଚନ୍‌ କାଜିଂ ଆରେ ହେନି ମାନାୟ୍‌ ପାର୍ତି କିତାର୍‌; ");
INSERT INTO peg_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","ଆରେ, ହେୱାର୍‌ ହେ କଗ୍‌ଲେହିମ୍‌ଣାତିଂ ଇଚାର୍‌, “ନଙ୍ଗୟ୍‌ ମି ବେରଣ୍‌ କାଜିଂ ଆପେଂ ପାର୍ତିକିଉପା, ମାତର୍‌ ଆପେଂ ଜାର୍‌ ଜାର୍‌ ୱେନାପା, ଆରେ ଇୱାନ୍‌ ଜେ ହାତ୍‌ପାନେ ପୁର୍ତିନି ମୁକ୍ତି କିଦ୍‌ନାକାନ୍‌, ଇଦାଂ ଆସେଙ୍ଗ୍‌ ପୁଚାସ୍‌ନା ।” ");
INSERT INTO peg_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","ରି ଦିନ୍‌ ପାଚେ ହେୱାନ୍‌ ହେବେତାଂ ହସି ଗାଲିଲିତ ହାଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","“ଇନାକିଦେଂକି ବେଣ୍‌ବାକ୍‌ଣାୟ୍‌ କିନାକାନ୍‌ ଜାର୍‌ ଦେସ୍‌ତ ମାନି ପାୟା ଆଉନ୍‌ ଇଞ୍ଜି ଜିସୁ ନିଜେ ସାକି ହିତାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","ପାଚେ, ହେୱାନ୍‌ ଗାଲିଲିତ ୱାତିଲେ, ପାର୍ବୁ ସମୁତ ହେୱାନ୍‌ ଜିରୁସାଲମ୍‌ତ ଇନା ଇନାକା କିଜ଼ି ମାଚାନ୍‌, ହେ ୱିଜ଼ୁ ହୁଡ଼୍‌ଜିମାଚିଲେ ଗାଲିଲିର୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ମାନି କିତାର୍‌, ଲାଗିଂ ହେୱାର୍‌ ପା ପାର୍ବୁତ ହାଲ୍‌ଜି ମାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","ଇଦାଂ ପାଚେ ଗାଲିଲିନି ଇମ୍‌ଣି କାନା ଗାଡ଼୍‌ଦ ହେୱାନ୍‌ ଏଜ଼ୁକାଂ ଅଙ୍ଗୁର୍‌ ରାସ୍‌ କିଜ଼ି ମାଚାନ୍‌, ହେ ବାହାତ ହେୱାନ୍‌ ଆରେ ରଗ ହାଚାନ୍‌ । ଆରେ ହେବେ ରକାନ୍‌ ଗୁମୁସ୍ତା ମାଚାନ୍‌, ତା ମାଜ଼ି କପର୍ନାହୁମ୍‌ ବିଡ଼୍‌ ଆଜ଼ି ମାଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","ଜିସୁ ଜିହୁଦା ଦେସ୍‌ତାଂ ଗାଲିଲିତ ହସି ୱାତାନ୍‌ନା, ଇଦାଂ ୱେନ୍‌ଞ୍ଜି ହେୱାନ୍‌ ତା ଲାଗେ ହାଲ୍‌ଜି ହେୱାନ୍‌ ଇନେସ୍‌ ୱାଜ଼ି ତା ମାଜ଼ିଙ୍ଗ୍‌ ଉଜ୍‌ କିନାନ୍‌, ଇଦାଂ କାଜିଂ ତାଙ୍ଗେଙ୍ଗ୍‌ ଗୱାରି କିଦେଙ୍ଗ୍‌ ଲାଗାତାର୍‌, ଇନାକିଦେଂକି ହେୱାନ୍‌ ହାନି ଲାକେ ଆଜ଼ି ମାଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","ହେବେତାଂ ଜିସୁ ତାଙ୍ଗେଙ୍ଗ୍‌ ଇଚାନ୍‌, “ଚିନ୍‌ ଆରେ କାବାନି କାମାୟ୍‌ ହୁଡ଼୍‌ୱିତିସ୍‌ ଏପେଙ୍ଗ୍‌ ଇନେସ୍‌ କିତିସ୍‌ପା ପାର୍ତି କିଉଦେର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","ଗୁମୁସ୍ତା ତାଙ୍ଗେଙ୍ଗ୍‌ ଇଚାନ୍‌, “ଏ ମାପ୍ରୁ, ନା କାଡ଼୍‌ଦେ ହାନି ଆଗେ ୱା ।” ");
INSERT INTO peg_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","ଜିସୁ ତାଙ୍ଗେଙ୍ଗ୍‌ ଇଚାନ୍‌, ହାଲା, ମି ମାଜ଼ି ଜିତାନେ । “ଜିସୁ ହେ ମାନାୟ୍‌ତିଂ ଇମ୍‌ଣି ବଚନ୍‌ ଇଚାନ୍‌, ହେୱାନ୍‌ ହେଦାଂ ପାର୍ତି କିଜ଼ି ମାସ୍‌ଦି ହାଚାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","ପାଚେ, ହେୱାନ୍‌ ହାଲୁ ହାଲୁ ତା ଆଡ଼ିୟାର୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ବେଟ୍‌ ଆଜ଼ି ନି କାଡ଼୍‌ଦେ ଜିତାନେ ଇଞ୍ଜି ଇଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","ଇମ୍‌ଣି ସମୁତ ଉପ୍‌କାର୍‌ ଆତାନ୍‌, ହେଦାଂ ହେୱାନ୍‌ ହେୱେରିଂ ୱେନ୍‌ବାତାନ୍‌ । “ହେବେତାଂ ହେୱାର୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ଇଚାର୍‌, ନିହିଙ୍ଗ୍‌ ଗନ୍‌ଟେୱେଡ଼ାଙ୍ଗ୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ନମେର୍‌ ପିସ୍‌ତାତ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","ଇବେତାଂ ଆବା ବୁଜାଆତାନ୍‌ ଜେ, ଜିସୁ ଇମ୍‌ଣି ସମୁତ ନି ମାଜ଼ି ଜିତାନେ ଇଞ୍ଜି ତାଙ୍ଗେଙ୍ଗ୍‌ ୱେଚ୍‌ଚି ମାଚାର୍‌, “ହାତ୍‌ପା ହେ ସମୁତ ଇଦାଂ ଗିଟାଆଜ଼ି ମାଚାତ୍‌ ।” ହେୱାନ୍‌ ଆରି ତା ୱିଜ଼ାକାର୍‌ କୁଟୁମ୍‌ ପାର୍ତି କିତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","ଜିହୁଦାତାଂ ଆରେ ରଗ ଗାଲିଲିତ ୱାତି ପାଚେ ଇଦାଂ ଜିସୁତି ରିହା କାବାଆନି କାମାୟ୍‌ କିତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","ଇଦାଂ ପାଚେ ଜିହୁଦିର୍ତି ର ପାର୍ବୁ ଏକାୱାତାତ୍‌, ଆରେ ଜିସୁ ଜିରୁସାଲମ୍‌ତ ହାଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","ଜିରୁସାଲମ୍‌ନି ମେଣ୍ଡା ଦୁୱେର୍‌ କଚଣ୍‌ ର ବାନ୍ଦ୍‌ ମାନାତ୍‌; ଏବ୍ରି ବାସାତାଂ ତାଙ୍ଗେଙ୍ଗ୍‌ ବେତ୍‌ସାଇଦା ଇଞ୍ଜି ଇନାର୍‌, ହେ ବାନ୍ତ ପାଞ୍ଚ୍‌ଗଟା ମଣ୍ଡମ୍‌ ମାନାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","ହେ ମାଣ୍ଡମ୍‌ତ ହେନି ହେନି ସୁକ୍‌ ହିଲ୍‌ୱାକାର୍‌, କାଣା, ଚଟା, ଆରି ହିରକଲ୍‌ରଗି ମାଚାର୍‌ । ହେୱାର୍‌ ନାଗୁଡ଼୍‌ ଉଲ୍‌କା ଆନାକା କାଜିଂ ମାଚାର୍‌; ");
INSERT INTO peg_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","ଇନାକିଦେଂକି ଇନା ଇନା ୱେଡ଼ାଙ୍ଗ୍‌ ମାପ୍ରୁତି ରୱାନ୍‌ ଦୁତ୍‌ ବାନ୍ତ ଜୁଜ଼ି ନାଗୁଡ଼୍‌ ଉଲ୍‌କାୟ୍‌ କିଜ଼ି ମାଚାନ୍‌, ଆରେ ନାଗୁଡ଼୍‌ ଉଲ୍‌କା ଆତି ସମୁତ ଇନେର୍‌କି ପର୍ତୁମ୍‌ ହେବେ ହଣ୍‌ଜି ମାଚାନ୍‌, ହେୱାନ୍‌ ଇନେସ୍‌ ବାର୍ତି ରଗ୍‌ ବେମାର୍‌ ମାଚାନ୍‌ ପା ଉଜ୍‌ ଆଜ଼ି ମାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","ହେବେ ତିରିସ୍‌ଆଟ୍‌ ବାର୍ହୁ ପାତେକ୍‌ ରଗ୍ୟା ରକାନ୍‌ ମାନାୟ୍‌ ମାଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","ଜିସୁ ତାଙ୍ଗେଙ୍ଗ୍‌ ମାଗ୍‌ଜିମାନାକା ହୁଡ଼୍‌ଜି ବେସିଦିନ୍‌ନ୍ତି ରଗ୍ୟା ଇଞ୍ଜି ପୁଞ୍ଜି ତାଙ୍ଗେଙ୍ଗ୍‌ ୱେନ୍‌ବାତାନ୍‌, “ଏନ୍‌ ଇନାକା ଉଜ୍‌ ଆଦେଂ ଇଚା କିନାୟା ?” ");
INSERT INTO peg_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","ରଗ୍ୟା ମାନାୟ୍‌ ଜିସୁଙ୍ଗ୍‌ ଉତର୍‌ ହିତାନ୍‌, “ଏ ମାପ୍ରୁ, ଏଜ଼ୁଂ ଉଲ୍‌କା ଆନି ସମୁତ ନାଙ୍ଗେଙ୍ଗ୍‌ ବାନ୍ଦ୍‌ ବିତ୍ରେ ଅଜ଼ି ହାଞ୍ଜେଙ୍ଗ୍‌ ଇଞ୍ଜି ନାଙ୍ଗ୍‌ ଇନେର୍‌ ହିଲୁର୍‌; ଆରେ, ଆନ୍‌ ହାଲୁ ହାଲୁ ବିନେ ନିକାନ୍‌ ନା ଆଗେ ହଣ୍‌ଗାନାନା ।” ");
INSERT INTO peg_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","ଜିସୁ ତାଙ୍ଗେଙ୍ଗ୍‌ ଇଚାନ୍‌, “ନିଙ୍ଗା, ନି କାଟେଲ୍‌ ଆସ୍ତି ତାଙ୍ଗା ।” ");
INSERT INTO peg_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","ହେ ଦାପ୍ରେ ହେ ମାନାୟ୍‌ ଉଜ୍‌ ଆତାନ୍‌ ଆରି ଜାର୍‌ କାଟେଲ୍‌ ଆସ୍ତି ତାଙ୍ଗ୍‌ଦେଂ ଲାଗାତାନ୍‌ । ହେ ଦିନା ଜମ୍‌ନିବାର୍‌ ମାଚାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","ହେବେତାଂ, ଜିହୁଦିର୍‌ ଉଜ୍‌ ଆତି ଲଗାଂ ଇଞ୍ଜେଙ୍ଗ୍‌ ଲାଗାତାର୍‌, “ନେଞ୍ଜେଙ୍ଗ୍‌ ଜମ୍‌ନିବାର୍‌, କାଟେଲ୍‌ ପିଣ୍‌ଜି ଅନାକା ନି ବିଦି ହିଲୁତ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","ମାତର୍‌, ହେୱାନ୍‌ ହେୱାରିଂ ଉତର୍‌ ହିତାନ୍‌, “ଜେ ନାଙ୍ଗେଙ୍ଗ୍‌ ଉଜ୍‌ କିତ୍‌ତାନ୍‌, ହେୱାନ୍‌ ନାଙ୍ଗେଙ୍ଗ୍‌ ଇନ୍‌ଚାନ୍‌, ନି କାଟେଲ୍‌ ଆସ୍ତି ତାଙ୍ଗା ।” ");
INSERT INTO peg_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","ହେୱାର୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ୱେନ୍‌ବାତାର୍‌, “ନି କାଟେଲ୍‌ ଆସ୍ତି ତାଙ୍ଗା ଇଞ୍ଜି ଜେ ନିଙ୍ଗେଙ୍ଗ୍‌ ଇନ୍‌ଚାନ୍‌, ହେ ଲକ୍‌ ଇନେନ୍‌ ?” ");
INSERT INTO peg_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","ମାତର୍‌ ହେୱାନ୍‌ ଇନେନ୍‌, ହେଦାଂ ହେ ଉଜ୍‌ ଆତି ଲକ୍‌ ପୁନ୍‌ୱାଦାଂ ମାଚାନ୍‌, ଇନାକିଦେଂକି ହେ ବାହାତ ହେନି ମାନାୟାର୍‌ ମାନିକାଜିଂ ଜିସୁ ଏଡ଼ା ଆଜ଼ି ହାଲ୍‌ଜି ମାଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","ଇଦାଂ ପାଚେ ଜିସୁ ମନ୍ଦିର୍‌ତ ଚଞ୍ଜ୍ୟା ଆଜ଼ି ତାଙ୍ଗେଙ୍ଗ୍‌ ଇଚାନ୍‌, “ହୁଡ଼ାଟ୍‌, ଏପେଙ୍ଗ୍‌ ଉଜ୍‌ ଆତାଦେର୍ଣ୍ଣା, ଆରେ ପାପ୍‌ କିମାଟ୍‌, ଇନେସ୍‌କି ମି କାଜିଂ ଆଦେକ୍‌ କସ୍ଟ ଗିଟା ଆଦ୍‌ନାତ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","ହେ ମାନାୟ୍‌ ତାଙ୍ଗ୍‌ଜି ହାଲ୍‌ଜି, ଇନେର୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ଉଜ୍‌ କିଜ଼ି ମାଚାର୍‌, ହେୱାନ୍‌ ଜିସୁ ଇଞ୍ଜି ଜିହୁଦି ନେତାରିଂ ଇଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","ଲାଗିଂ ଜିସୁ ଜମ୍‌ନିବାର୍‌ ନାଜିଂ ଇଦାଂ କିଜ଼ି ମାଚିଲେ ଜିହୁଦିର୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ଗାଣ୍‌ଜୁ କିଦେଙ୍ଗ୍‌ ଲାଗାତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","ମତର୍‌ ଜିସୁ ହେୱାରିଂ ଉତର୍‌ ହିତାନ୍‌, “ମାଞ୍ଜି ଆବା ସବୁ ନାଞ୍ଜିଙ୍ଗ୍‌ କାମାୟ୍‌ କିନାନା, ଆରେ ଆନ୍‌ ପା କିନାଙ୍ଗା ।” ");
INSERT INTO peg_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","ଇ ନିୟମ୍‌ତାଂ ଜିହୁଦିର୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ଆସ୍ତେଙ୍ଗ୍‌ ଇଞ୍ଜି ଆରେ ଆଦେକ୍‌ ସେସ୍ଟା କିଦେଙ୍ଗ୍‌ ଲାଗାତାର୍‌, ଇନାକିଦେଂକି ହେୱାନ୍‌ ଜମ୍‌ନିବାର୍‌ ନାଜିଂ ମାନିକିୱାତାନ୍‌ କେବଲ୍‌ ଆକାୟ୍‌, ମତର୍‌ ଇସ୍ୱର୍‌ ଲାହାଙ୍ଗ୍‌ ଜାର୍‌ ଆବା ଇଞ୍ଜି ଇଞ୍ଜି ଜାର୍‌ତିଂ ଇସ୍ୱର୍‌ ଲାହାଙ୍ଗ୍‌ ସମାନ୍‌ କିଜ଼ି ମାଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","ଲାଗିଂ ଜିସୁ ହେୱାରିଂ ଉତର୍‌ ହିତାନ୍‌, “ହାତ୍‌ପା ହାତ୍‌ପା ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ଇଞ୍ଜ୍‌ନାଙ୍ଗା, ମାଜ଼ି ହେୱାନ୍‌ ନିଜେ କିଦେଙ୍ଗ୍‌ ଆଡୁନ୍‌ ତା ଆବା ଇନାକା କିନାନ୍‌ ହେଦାଂ ନେ ହୁଡ଼୍‌ତିସ୍, ମାଜ଼ିପା ହେଦାଂ କିନାନ୍‌ । ଇନାକିଦେଂକି ହେୱାନ୍‌ ଇନା ଇନାକା କିନାନ୍‌, ମାଜ଼ିପା ହେଦାଂ ୱିଜ଼ୁ ହେ ଲାକେ କିନାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","ଇନାକିଦେଂକି ଆବା ମାଜ଼ିଙ୍ଗ୍‌ ଜିଉନନାର୍‌, ଆରେ ନିଜେ ଇନାକା କିନାନ୍‌ ହେ ୱିଜ଼ୁ ତାଙ୍ଗେଙ୍ଗ୍‌ ଚଚ୍‌ନାନ୍‌ ଆରେ ଇବେତାଂ ଗାଜା କାମାୟିଙ୍ଗ୍‌ କିନି କାଜିଂ ହେୱାନ୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ଚଚ୍‌ନାନ୍‌ ଆରେ ଏପେଙ୍ଗ୍‌ ୱିଜ଼ାଦେର୍‌ କାବା ଆନାଦେର୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","ଲାଗିଂ ଆବା ଇନେସ୍‌ କିଜ଼ି ହାତି ଲଗାଂ ନିକ୍‌ଚି ଆରେ ଜିବୁନ୍‌ ହିନାନ୍‌, ହେ ଲାକେ ମାଜ଼ି ପା ଇନେରିଂ ମାନ୍‌ କିନାନ୍‌, ହେୱାରିଂ ଜିବୁନ୍‌ ହିନାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","ଆରେ, ଆବା ପା ଇନାକାନିଂ ବିଚାର୍‌ କିଉନ୍‌, ବିଚାର୍‌ କିନି କାଜିଂ ହେୱାନ୍‌ ଜାର୍‌ ମାଜ଼ି ଆଦିକାର୍‌ ହିତାନ୍‌ନା । ");
INSERT INTO peg_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","ହେବେତାଂ ଆବାଂ ମାନି କିତାର୍‌ ମାଜ଼ିଙ୍ଗ୍‌ ପା ହେ ଲାକେ ୱିଜ଼ାର୍‌ ମାନି କିତାର୍‌, ଇନେନ୍‌ ମାଜ଼ିଙ୍ଗ୍‌ ମାନିକିଉନ୍‌ ତା ପକ୍ତିତି ଆବାଂ ପା ହେୱାନ୍‌ ମାନିକିଉନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“ହାତ୍‌ପା ହାତ୍‌ପା ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ଇଞ୍ଜ୍‌ନାଙ୍ଗା, ଇନେର୍‌ ବଚନ୍‌ ୱେନ୍‌ଞ୍ଜି ନା ପକ୍‌ତାକାନିଂ ପାର୍ତି କିନାନ୍‌, ହେୱାନ୍‌ ୱିଜ଼୍‌ୱି ଜିବୁନ୍‌ ପାୟା ଆତାନ୍ନା, ଆରେ ହେୱାନ୍‌ ବିଚାର୍‌ କିୟାଆଉନ୍‌ ହାକିତିଂ ନାସି ହାଲ୍‌ଜି ଜିବୁନ୍‌ ତାକେ ହଟାନ୍‌ନା । ");
INSERT INTO peg_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","ହାତ୍‌ପା ହାତ୍‌ପା ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ଇଞ୍ଜ୍‌ନାଙ୍ଗା, ଏପେଙ୍ଗ୍‌ ସମୁ ୱାନାତା, ଏଚେକାଡ଼୍‌ଦ ହାତାକାର୍‌ ଇସ୍ୱର୍‌ ମାଜ଼ି ୱେଇ ୱେନାର୍‌ ଆରି ଇନେର୍‌ ୱେନାର୍‌, ହେୱାର୍‌ ଜିବୁନ୍‌ ପାୟା ଆନାର୍‌ ଆରେ ଇ ଦିନ୍ତ ପା ୱାତାତେ । ");
INSERT INTO peg_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","ଇନାକିଦେଂକି ଆବାଂ ଇନେସ୍‌କି ନିଜେ ଜିବୁନ୍‌, ହେ ଲାକେ ହେୱାନ୍‌ ମାଜ଼ିଙ୍ଗ୍‌ ପା ନିଜେ ଜିବୁନ୍‌ ଆଦେଂ ହିତାନ୍ନା; ");
INSERT INTO peg_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","ଆରେ, ହେୱାନ୍‌ ମାନାୟ୍‌ ମାଜ଼ି ଆନି କାଜିଂ ହେୱାନ୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ବିଚାର୍‌ କିନାକା ଆଦିକାର୍‌ ହିତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","ଇବେ କାବା ଆମାଟ୍‌, ଇ ସମୁ ୱାନାତା ସମୁତ ଦୁଗେର୍‌ତ ୱିଜ଼ାକାର୍‌ ତା କାଟ୍‌ ୱେନାର୍‌, ");
INSERT INTO peg_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","ହେୱାର୍‌ ଦୁଗେର୍‌ତାଂ ନିଙ୍ଗ୍‌ଜି ୱାନାର୍‌, ଆରେ ଇମ୍‌ଣାକାର୍‌ ହାର୍‌ଦି କାମାୟ୍‌ କିତାର୍ଣ୍ଣା ହେୱାର୍‌ ଆରେ ନିଂଜି ଜିବୁନ୍‌ ଆନାର୍‌, ବାନ୍ୟା କାମାୟ୍‌ କିନାକାର୍‌ ଆରେନିଂନାର୍‌ ଆରି ହେୱାର୍‌ ଡାଣ୍ଡ୍‌ ପାୟା ଆନାର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“ଆନ୍‌ ରୱାଙ୍ଗ୍‌ ଇନାକା କିଦେଙ୍ଗ୍‌ ଆଡୁଙ୍ଗ୍‌; କେବଲ୍‌ ଇସ୍ୱର୍‌ ବଲ୍‌ତାଂ ଆନ୍‌ ବିଚାର୍‌ କିନାଙ୍ଗ୍‌ ଇନେସ୍‌କି ୱେନାଙ୍ଗ୍‌, ହେ ଲାକେ ବିଚାର୍‌ କିନାଙ୍ଗ୍‌, ଆରେ ନା ବିଚାର୍‌ ସମାନ୍‌, ଇନାକିଦେଂକି ଆନ୍‌ ଜାର୍‌ ମାନ୍‌ ହୁଦାର୍‌ କିଦ୍‌ଦେଂ ସେସ୍ଟା କିୱାଦାଂ ନା ପକ୍‌ତାତାକାନିଂ ଇଚା କିଦେଙ୍ଗ୍‌ ସେସ୍ଟା କିନାଙ୍ଗ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“ଜଦି ଆନ୍‌ ନିଜେ ବିସ୍ରେ ନିଜେ ସାକି ହିନାଙ୍ଗ୍‌, ତା ଆତିସ୍‌ ନା ସାକ୍ୟା ହାତ୍‌ପା ଆକାୟ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","ନା ବିସ୍ରେ ଇନେନ୍‌ ରକାନ୍‌ ସାକି ହିନାନ୍‌, ହେୱାନ୍‌ ଆରେ ପୁନାନ୍‌; ଆରି, ନା ବିସ୍ରେ ତା ସାକି ଜେ ହାତ୍‌ପା, ହେଦାଂ ଆନ୍‌ ପୁନାଙ୍ଗ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","ଏପେଙ୍ଗ୍‌ ଜହନ୍‌ ଲାଗାଂ ମାନାୟ୍‌ ପକ୍‌ତାଦେର୍ଣ୍ଣା ଆରି ହେୱାନ୍‌ ହାତ୍‌ପା ଲକାର୍‌ ସାକି ହିନାନା; ");
INSERT INTO peg_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","ମାତର୍‌ ଆନ୍‌ ମାନାୟ୍‌ତିଂ ସାକି ମାନି କିଉଙ୍ଗ୍‌, ଇଚିସ୍‌ ଏପେଙ୍ଗ୍‌ ଇନେସ୍‌କି ମୁକ୍ତି ଆନାଦେର୍‌, ହେଦାଂ କାଜିଂ ଇ ସବୁ ଇଞ୍ଜ୍‌ନାଙ୍ଗା । ");
INSERT INTO peg_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","ଜହନ୍‌ ଆହ୍‌ନି ଅଜଡ଼୍‌ ବଇଟା ଲାକେ ମାଚାନ୍‌, ଆରେ ଏପେଙ୍ଗ୍‌ ଅଲପ୍‍ ଦିନ୍‌ ତା ଅଜଡ଼୍‌ତ ୱାରି କିନି କାଜିଂ ୱାରିୟା ଆତାଦେର୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","ମାତର୍‌ ଜହନ୍‌ତି ସାକି ତାଙ୍ଗ୍‌ ନାତାଙ୍ଗ୍‌ ସଲ୍‌କେ ସାକି ମାନାତ୍‌, ଇନାକିଦେଂକି ଆବା ନାଙ୍ଗେଙ୍ଗ୍‌ ଇମ୍‌ଣି ଇମ୍‌ଣି କାମାୟ୍‌ ୱିସ୍ତେଙ୍ଗ୍ ହିତ୍‌ନ୍ନା, ଜେ ୱିଜ଼ୁ କାମାୟ୍‌ ଆନ୍‌ କିନାଙ୍ଗା, ଆବା ନାଙ୍ଗେଙ୍ଗ୍‌ ପକ୍‌ତାତାନ୍ନା ଇଞ୍ଜି ହେ ୱିଜ଼ୁ ନା ବିସ୍ରେ ସାକି ହିନାଙ୍ଗା । ");
INSERT INTO peg_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","ଆରେ, ଇମ୍‌ଣି ଆବା ନାଙ୍ଗେଙ୍ଗ୍‌ ପକ୍‌ତାତାନ୍ନା, ହେୱାନ୍‌ ନା ବିସ୍ରେ ସାକି ହିତ୍‌ତାନ୍ନା । ଏପେଙ୍ଗ୍‌ ଇନାୱାଡ଼ାଂ ତା କାଟ୍‌ ୱେନୁଙ୍ଗେ କି ତା ମୁମ୍‌ ହୁଡ଼ୁଙ୍ଗେ, ");
INSERT INTO peg_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","ଆରେ ତା ବଚନ୍‌ ମି ୱାସ୍କିତ ବାହା କିୱାତାତ୍‌ନା, ଇନାକିଦେଂକି ହେୱାନ୍‌ ଇନେରିଂ ପକ୍‌ତାତାନ୍ନା, ତାଙ୍ଗେଙ୍ଗ୍‌ ଏପେଙ୍ଗ୍‌ ପାର୍ତି କିଉଦେରା । ");
INSERT INTO peg_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","ଏପେଙ୍ଗ୍‌ ଦରମ୍‌ ସାସ୍ତର୍‌ ମାନିକିନାଦେରା, ଇନାକିଦେଂକି ହେବେ ୱିଜ଼୍‌ୱି ଜିବୁନ୍‌ ପାୟା ଆନାନ୍‌ ଇଞ୍ଜି ମାନ୍ତ କିନାଦେରା; ଆରେ, ହେ ଦରମ୍‌ ସାସ୍ତର୍‌ ନା ବିସ୍ରେ ସାକି ହିନାଙ୍ଗା । ");
INSERT INTO peg_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","ମାତର୍‌ ଏପେଙ୍ଗ୍‌ ଜିବୁନ୍‌ ପାୟା ଆଦେଂ ଇଞ୍ଜି ନା କଚଣ୍‌ ୱାଦେଙ୍ଗ୍‌ ମାନ୍‌ କିଉଦେରା ।” ");
INSERT INTO peg_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“ଆନ୍‌ ମାନାୟାର୍‌ତାଂ ଜାଜ୍‌ମାଲ୍‌ ଇଚା କିଉଙ୍ଗା, ");
INSERT INTO peg_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","ମାତର୍‌ ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ପୁଞ୍ଚାଙ୍ଗ୍‌ନା, ଏପେଙ୍ଗ୍‌ ଇନେସ୍‌ ବାର୍ତି ମାନାୟ୍‌ ଆରେ ମି ୱାସ୍କିତ ଇସ୍ୱର୍‌ତି ଜିଉନନାକା ଆକାୟ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","ଆନ୍‌ ମାଞ୍ଜିଆବା ତର୍‌ଦାଂ ୱାତାଙ୍ଗ୍‌ନା, ଆରେ ଏପେଙ୍ଗ୍‌ ନାଙ୍ଗେଙ୍ଗ୍‌ ମାନ୍‌ କିଦୁଦେରା; ବିନ୍‌ ନିକାନ୍‌ ଜଦି ନିଜେ ତର୍‌ଦାଂ ୱାନାନ୍‌, ଲାଗିଂ ଏପେଙ୍ଗ୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ମାନି କିନାଦେର୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","ଏପେଙ୍ଗ୍‌ ନାଙ୍ଗ୍‌ ଇନେସ୍‌ ପାର୍ତି କିଦ୍‌ନାଦେର୍‌ ? ଏପେଙ୍ଗ୍‌ ତ ରକାନ୍‌ ଆରେ ରକାନ୍‌ ତାଙ୍ଗ୍‌ ଜାଜ୍‌ମାଲ୍‌ ପାୟା ଆଦେଂ ମାନ୍‌ କିନାଦେରା, ଆରି ରଞ୍ଜାଙ୍ଗ୍‌ ମାତର୍‌ ଇସ୍ୱର୍‌ତାଂ ଇମ୍‌ଣି ଜାଜ୍‌ମାଲ୍‌, ହେଦାଂ ଗାଟାଆନି କାଜିଂ ସେସ୍ଟା କିଉଦେରା । ");
INSERT INTO peg_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","ଆନ୍‌ ଜେ ଆବା ମୁମ୍‌ଦ ମି ବେରୁତ୍‌ତାଂ ୱେନ୍‌ବା ଆଦ୍‌ନାଂ, ଇଦାଂ ମାନ୍ତ କିମାଟ୍‌; ଇମ୍‌ଣି ମସାତାକେ ଏପେଙ୍ଗ୍‌ ଆହା କିତାଦେର୍ଣ୍ଣା, ହେୱାନ୍‌ ମି ବିରୁତ୍‌ତାଂ ୱେନ୍‌ବା ଆଦ୍‌ନାରା । ");
INSERT INTO peg_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","ଇନାକିଦେଂକି ଏପେଙ୍ଗ୍‌ ଜଦି ମସାଙ୍ଗ୍‌ ପାର୍ତି କିନାଦେର୍‌, ଲାଗିଂ ନାଙ୍ଗେଙ୍ଗ୍‌ ପାର୍ତି କିଦ୍‌ନାଦେର୍‌, ଲାଗିଂ ହେୱାନ୍‌ ନା ବିସ୍ରେ ଲେକି କିତାନ୍‌ନ୍ନା । ");
INSERT INTO peg_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","ମାତର୍‌ ଏପେଙ୍ଗ୍‌ ଜଦି ମସା ଲେକିକିତି ବଚନ୍‌ ପାର୍ତି କିଉଦେର୍‌, ଲାଗିଂ ଇନେସ୍‌ ନା ବଚନ୍‌ ପାର୍ତି କିନାଦେର୍‌ ?” ");
INSERT INTO peg_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","ଇବେଣ୍ଡାଂ ଜିସୁ ଗାଲିଲି ହାମ୍‌ଦୁର୍‌, ଇଚିସ୍‌, ତିବିରିୟା ହାମ୍‌ଦୁର୍‌ ଆନ୍‌ଟି ପାଡ଼୍‌କା ହାଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","ଆରେ, ହେୱାନ୍‌ ରଗ୍ୟାର୍‌ କାଜିଂ ଇନା ଇନା କାବାଆନି କାମାୟ୍‌ କିଜ଼ି ମାଚାନ୍‌, ହେଦାଂ ୱିଜ଼ୁ ହୁଡ଼୍‌ଜି ହେନି ମାନାୟ୍‌ ତାପାଚେ ୱାଦେଙ୍ଗ୍‌ ଲାଗାତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","ହେବେ ଜିସୁ ମାଡ଼ିଜପି ହାଲ୍‌ଜି ଜାର୍‌ ଚେଲାହିର୍‌ ଲାହାଙ୍ଗ୍‌ ହେବେ କୁଚ୍‌ଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","ହେ ପାଦ୍‌ନା ଜିହୁଦିର୍ତି ନିସ୍ତାର୍‌ ପାର୍ବୁ ଏକା ୱାଜ଼ି ମାଚାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","ଆରେ, ଜିସୁ ଇଟ୍‌କାଡ଼୍‌ କିଜ଼ି ବେସି ହେନି ମାନାୟାରିଂ ଜାର୍‌ କଚଣ୍‌ ୱାନାକା ହୁଡ଼୍‌ଜି ପିଲିପ୍‌ତିଂ ଇଚାନ୍‌, “ଇୱାର୍‌ ତିନି କାଜିଂ ଆସେଙ୍ଗ୍‌ ଇମେତାକେ ଜବର୍‌ ରୁଟିଂ କଡ଼୍‌ନାସ୍‌ ?” ");
INSERT INTO peg_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","ମାତର୍‌ ହେୱାନ୍‌ ପିଲିପ୍‌ତିଂ ପରିକ୍ୟା କିନି ଉପାୟ୍‌ତାଂ ଏଲେଙ୍ଗ୍‌ ଇଚାନ୍‌, ଇନାକିଦେଂକି ହେୱାନ୍‌ ଇନାକା କିଦେଙ୍ଗ୍‌ ହାନାନା, ହେଦାଂ ହେୱାନ୍‌ ନିଜେ ପୁଞ୍ଜି ମାଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","ପିଲିପ୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ଉତର୍‌ ହିତାନ୍‌, “ୱିଜ଼ାରିଂ ଅଲପ୍‍ ଚିଚ୍‌ପେଦେଂ ଇୱାର୍‌ କାଜିଂ ଦୁଇସ ଟାକାଂ ରୁଟିଂ, ଜବର୍‌ ଆକାୟ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","ସିମନ୍‌ ପିତର୍‌ ଟଣ୍ଡାହି ଆନ୍ଦ୍ରିୟ ତର୍‌ଦାକାନ୍‌ ତା ଚେଲାର୍‌ ବିତ୍ରେତାଂ ରୱାନ୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ଇଚାନ୍‌, “ଇବେ ରୱାନ୍‌ କାଡ଼୍‌ଦେ ମାନାନ୍‌, ");
INSERT INTO peg_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","ତା ତାକେ କୁଜ଼ା ପାଞ୍ଚ୍‌ଗଟା ରୁଟିଂ ଆରି ରିଣ୍ଡାଂ ୱାସ୍ତି ମିନ୍‌କୁ ମାନିକ୍‌, ମାତର୍‌ ଏଚେକ୍‌ ହେନି କାଜିଂ ହେଦାଂ ଜବର୍‌ ଆକାୟ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","“ଜିସୁ ଚେଲାରିଂ ଇଚାନ୍‌, ମାନାୟାରିଂ କୁଚିକିୟାଟ୍‌ ।” ହେ ବାହାତ ବେସି କାଚ୍ରା ମାଚାତ୍‌ । ଲାଗିଂ ଆନ୍‌ମାନ୍‌ତାଂ ପାଞ୍ଚ୍‌ ହାଜାର୍‌ ଆଣ୍ଡ୍ରାହିମ୍‌ଣାଂ ମାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","ହେବେ ଜିସୁ ହେ ରୁଟି ଆସ୍ତି ଜୁୱାର୍‌ କିଜ଼ି କୁଚ୍‌ଚି ମାନି ମାନାୟାରିଂ ହେଦାଂ ବାଟାକିଜ଼ି ହିତାନ୍‌, ହେ ଲାକେ ମିନ୍‌କୁ ପା ହାସ୍ତିହିତାନ୍‌, ହେୱାର୍‌ ଏଚେକ୍‌ ଏନ୍ତିସ୍‌, ହେ ଏଚେକ୍‌ ହିତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","ଆରେ ହେୱେର୍‌ ପଟପାଞ୍ଚିଲେ, ହେୱାନ୍‌ ତା ଚେଲାରିଂ ଇଚାନ୍‌, “ଇନେସ୍‌କି ଅଲପ୍‍ କ୍ଡାୱାସ୍‌ ଆମେତ୍‌, ଇଦାଂ କାଜିଂ ହାର୍‌ଜିମାନି ଡ୍ରିକ୍‌ତି କୁଦ୍ରିଙ୍ଗ୍‌ ରବେ କିୟାଟ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","ହେବେ ହେୱାଙ୍ଗ୍‌ ହେୱାର୍‌ ୱିଜ଼ୁ ରବେ କିତାର୍‌, ଆରେ ମାନାୟାର୍‌ ଚିଚ୍‌ଚି ପାଚେ ହେ ପାଞ୍ଚ୍‌ ଗଟା କୁଜ଼ା ରୁଟିଂ ଇମ୍‌ଣି ଡ୍ରିଙ୍ଗ୍‌ତି କୁଦ୍ରିଙ୍ଗ୍‌ ହାର୍‌ଜି ମାଚିକ୍‌, ହେବେ ହେୱାର୍‌ ବାର ଟପା ବାର୍ତି କିତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","ଲାଗିଂ, ମାନାୟାର୍‌ ତା କିତି କାବାଆନି କାମାୟ୍‌ ହୁଡ଼୍‌ଜି ହେବେ ମାନି ମାନାୟାରିଂ ଇଞ୍ଜେଙ୍ଗ୍‌ ଲାଗାତାର୍‌, “ପୁର୍ତି ଇମ୍‌ଣି ବେଣ୍‌ବାକ୍‌ଣାୟ୍‌କିନାକାର୍‌ ୱାନାକା ମାଚାତ୍‌, ଇୱାନ୍‌ ହାତ୍‌ପା ହେୱାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","ଲାଗିଂ, ହେୱାର୍‌ ୱାଜ଼ି ରାଜା କିନି କାଜିଂ ଜେ ତାଙ୍ଗେଙ୍ଗ୍‌ ସାକ୍ତିକାଟାକାନ୍‌ ଆସ୍ତେଙ୍ଗ୍‌ ସାସ୍‌ମାନାତ୍‌, ଇଦାଂ ପୁଞ୍ଜି ଜିସୁ ଆରେ ରଗ ଏଡ଼ା ଆଜ଼ି ରୱାନ୍‌ନେ ମାଡ଼ିତ ହସି ହାଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","ହେ ନାଜିଂ ମ୍ଡିତିଲେ ତା ଚେଲାହିର୍‌ ହାମ୍‌ଦୁର୍‌ ଗୁଟିତ ହାଚାର୍‌ ");
INSERT INTO peg_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","ଆରେ ଡଙ୍ଗାତ ଦୁମ୍‌ଜି ହାମ୍‌ଦୁର୍‌ ଆନ୍‌ଟି ପାଡ଼୍‌କା କପର୍ନାହୁମ୍‌ ନିପ ହାଞ୍ଜେଙ୍ଗ୍‌ ଲାଗାତାର୍‌ । ମାଜ୍‌ଗା ଆଜ଼ି ହାତାତ୍‌, ଆରେ ଜିସୁ ହେ ପାଦ୍‌ନା ପାତେକ୍‌ ହେୱାର୍‌ କଚଣ୍‌ତ ୱାୱାଦାଙ୍ଗ୍‌ ମାଚାନ୍‌, ");
INSERT INTO peg_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","ଆରେ ବେସି ଦୁକା କିତିଲେ ଏଜ଼ୁକାଂ ଲଡ଼ି ନିଙ୍ଗ୍‌ଜି ମାଚାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","ଇବେପା ଚେଲାର୍‌ ପୁରା ପାଞ୍ଚ୍‌ ଚଅ କିଲମିଟର୍‌ ଡଙ୍ଗା କେଡ଼ା ଆଜ଼ି ହାଚିପାଚେ ଜିସୁଙ୍ଗ୍‌ ଏଜ଼ୁଂ ଜପି ତାଙ୍ଗ୍‌ଜି ଡଙ୍ଗାତାକେ ୱାନାକା ହୁଡ଼୍‌ଜି ପାଣ୍ଡ୍ରା ଆତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","“ମାତର୍‌ ଜିସୁ ହେୱାରିଂ ଇଚାନ୍‌,” ଇୱାଙ୍ଗ୍‌ ତ ଆନ୍‌, “ପାଣ୍ଡ୍ରା ଆମାଟ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","ଲାଗିଂ ହେୱାର୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ଡଙ୍ଗାତ ଅଦେଂ ମାନ୍‌ କିତାର୍‌, ଆରେ ହେୱାର୍‌ ଇମ୍‌ଣି ବାହାତ ହାଲ୍‌ଜି ମାଚାର୍‌, ଡଙ୍ଗା ହେ ଦାପ୍ରେ ଗୁଟିତ ଏକାତାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","ହେ ବାହାତ କେବଲ୍‌ ର ଡଙ୍ଗା ମାଚାତ୍‌, ଅଲ୍‌ଗା ଇମ୍‌ଣି ଡଙ୍ଗା ହିଲ୍‌ୱାତାତ୍‌, ଆରେ ହେବେ ଜେ ଜିସୁ ତା ଚେଲାହିର୍‌ ଲାହାଙ୍ଗ୍‌ ହାଲ୍‌ୱାଦାଂ ମାଚାନ୍‌, ମତର୍‌ କେବଲ୍‌ ତା ଚେଲାହିର୍‌ ହାଲ୍‌ଜି ମାଚାର୍‌, ଇୱାର୍‌ ଇମ୍‌ଣି ମାନାୟାର୍‌ ତା ଆର୍କାତ୍‌ ନାଜିଂ ହାମ୍‌ଦୁର୍‌ ଆନ୍‌ଟି ପାଡ଼୍‌କା ନିଲ୍‌ଚି ମାଚାର୍‌, ହେୱାର୍‌ ହୁଡ଼୍‌ଜି ମାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","ମାପ୍ରୁଙ୍ଗ୍‌ ଜୁୱାର୍‌ କିତି ପାଚେ ହେୱାର୍‌ ଇମ୍‌ଣି ବାହାତ ରୁଟି ତିଞ୍ଜି ମାଚାର୍‌, ହେ ବାହାତ ତିବିରିୟାତାଂ ଆରେ କେତ୍‌ଗଟା ଡଙ୍ଗାଙ୍ଗ୍‌ ୱାତିକ୍‌; ");
INSERT INTO peg_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","ଲାଗିଂ ଜିସୁ କି ତା ଚେଲାହିର୍‌ ଜେ ହେବେ ହିଲାତାର୍‌, ଇବେ ଏଚେକାଡ଼୍‌ଦ ମାନାୟାରିଂ ହୁଡ଼୍‌ତାର୍‌, ହେ ପାଦ୍‌ନା ହେୱାର୍‌ ୱିଜ଼ାର୍‌ ଡଙ୍ଗାତ ଦୁମ୍‌ଜି ଜିସୁଙ୍ଗ୍‌ ଡେକୁ ଡେକୁ କପର୍ନାହୁମ୍‌ ୱାତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","ଆରେ, ହେୱାର୍‌ ହାମ୍‌ଦୁର୍‌ ଆଣ୍ଟିପାଡ଼୍‌କା ତାଙ୍ଗେଙ୍ଗ୍‌ ହୁଡ଼୍‌ଜି ୱେନ୍‌ବାତାର୍‌, “ଏ ଗୁରୁ, ଏନ୍‌ ଏଚେକାଡ଼୍‌ଦ ଇବେ ୱାତାୟ୍‌ ?” ");
INSERT INTO peg_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","ଜିସୁ ହେୱାରିଂ ଉତର୍‌ ହିତାନ୍‌, ହାତ୍‌ପା “ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ଇଞ୍ଜ୍‌ନାଙ୍ଗା, କାବାଆନି କାମାୟ୍‌ ହୁଡ଼୍‌ଦେଂ ଜେ ଏପେଙ୍ଗ୍‌ ନାଙ୍ଗ୍‌ ଡେକ୍ତାନାଦେରା, ହେଦାଂ ଆକାୟ୍‌, ମତର୍‌ ରୁଟି ତିନ୍‌ଞ୍ଜି ପଟ ପାଞ୍ଜ୍ୟାୱାଦାଂ ନାଙ୍ଗେଙ୍ଗ୍‌ ଡେକ୍ତାନାଦେରା । ");
INSERT INTO peg_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","ଇମ୍‌ଣି କାଦି ନସ୍ଟ ଆନାତ୍‌, ହେଦାଂ କାଜିଂ ବେସି କସ୍ଟକିମାଟ୍‌ । ମାତର୍‌ ଇମ୍‌ଣି କାଦି ୱିଜ଼୍‌ୱି ଜିବୁନ୍‌ ହିନାତ୍‌, ହେଦାଂ କାଜିଂ କାମାୟ୍‌ କିୟାଟ୍‌ । ଇ କାଦି ମାନାୟ୍‌ ମାଜ଼ି ହିଦ୍‌ନାନ୍‌, ଇନାକିଦେଂକି ଆବା ଇସ୍ୱର୍‌ ହେଦାଂ କାଜିଂ ତାଙ୍ଗେଙ୍ଗ୍‌ ଇଡ୍‌ତାନ୍ନା ।” ");
INSERT INTO peg_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","ହେବେ ହେୱାର୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ୱେନ୍‌ବାତାର୍‌, “ଇସ୍ୱର୍‌ତି କାମାୟ୍‌ ସବୁ କିନି କାଜିଂ ଆପେଂ ଇନାକା କିୟାଆନାତ୍‌ ?” ");
INSERT INTO peg_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","ଜିସୁ ହେୱାରିଂ ଉତର୍‌ ହିତାନ୍‌, “ଇନେକିଦେଂ ଇସ୍ୱର୍‌ ପକ୍‌ତାତାନ୍ନା, ତା ତାକେ ପାର୍ତି କିନାକା ନେ ଇସ୍ୱର୍ତି କାମାୟ୍‌ ଆନାତ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","ହେବେ ହେୱାର୍‌ ଜିସୁଙ୍ଗ୍‌ ୱେନ୍‌ବାତାର୍‌, ହେଦାଂ ଆତିସ୍‌ ଏନ୍‌ ଚିନ୍‌ଲାକେ ଇନାକା କିତ୍‌ୟ୍‌ନା ଜେ, “ହେଦାଂ ହୁଡ଼୍‌ଜି ଆପେଂ ନିଙ୍ଗେଙ୍ଗ୍‌ ପାର୍ତି କିଦ୍‌ନାପ୍‌ ? ୱେଚ୍‌ଚା ଇନା କିଦେଙ୍ଗ୍‌ ଆଡ୍‌ନାୟ୍‌ ? ");
INSERT INTO peg_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","ମା ଆକର୍‌ ବାଟାତ ମାନ୍ନା ତିଞ୍ଜି ମାଚାର୍‌, ଇନେସ୍‌ ସାସ୍ତର୍‌ ଲେକା ମାନାତ୍‌, ତିନି କାଜିଂ ହେୱାନ୍‌ ହେୱାରିଂ ସାର୍ଗେତାଂ କାଦି ହିତାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","“ହେବେ ଜିସୁ ହେୱାରିଂ ଇଚାନ୍‌, ହାତ୍‌ପା ହାତ୍‌ପା ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ଇଞ୍ଜ୍‌ନାଙ୍ଗା, ମସା ମିଙ୍ଗେଙ୍ଗ୍‌ ସାର୍ଗେତାଂ କାଦି ହିଦ୍‌ୱାତାନ୍‌ନା, ମାତର୍‌ ମାଞ୍ଜି ଆବା ମିଙ୍ଗେଙ୍ଗ୍‌ ସାର୍ଗେତାଂ ହାତ୍‌ପା କାଦି ହିନାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","ଇନାକିଦେଂକି ଇମ୍‌ଣି କାଦି ସାର୍ଗେତାଂ ଜୁତ୍‌ତି ପୁର୍ତିତିଂ ଜିବୁନ୍‌ ହିନାନ୍‌, ହେଦାଂ ଇସ୍ୱର୍ତି କାଦି ।” ");
INSERT INTO peg_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","ହେୱାର୍‌ ଜିସୁଙ୍ଗ୍‌ ଇଚାର୍‌, “ଏ ମାପ୍ରୁ, ସବୁ ୱେଡ଼ାଙ୍ଗ୍‌ ମାଙ୍ଗେଙ୍ଗ୍‌ ଇ କାଦି ହିଦା ।” ");
INSERT INTO peg_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","“ହେବେ ଜିସୁ ହେୱାରିଂ ଇଚାନ୍‌,” ଆନ୍‌ ହେ ଜିବୁନ୍‌ କାଦି, “ଇନେନ୍‌ ନା ଲାଗାଂ ୱାନାନ୍‌, ହେୱାନ୍‌ ଇନାୱାଡ଼ାଂପା ନାସ୍‌କି ଆଉନ୍‌, ଆରେ ଇନେନ୍‌ ନା ତାକେ ପାର୍ତି କିନାନ୍‌, ହେୱାନ୍‌ ଇନାୱାଡ଼ାଂ ଏସ୍‌କି ଆଉନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","ମାତର୍‌ ଏପେଙ୍ଗ୍‌ ନାଙ୍ଗେଙ୍ଗ୍‌ ହୁଡ଼୍‌ଜିପା ପାର୍ତି କିଦୁଦେରା, ଇଦାଂ ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ଇନ୍‌ଞ୍ଚାଙ୍ଗ୍‌ନ୍ନା । ");
INSERT INTO peg_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","ଆବା ଜେ ୱିଜ଼ାରିଂ ନାଙ୍ଗେଙ୍ଗ୍‌ ଦାନ୍‌ କିଦ୍‌ନାନ୍‌, ହେୱାର୍‌ ନା କଚଣ୍‌ତ ୱାନାର୍‌; ଆରେ, ଇନେର୍‌ ନା ତାକେ ୱାନାନ୍‌, ତାଙ୍ଗେଙ୍ଗ୍‌ ଇନେସ୍‌ କିତିସ୍‌ପା ବାର୍ତ ହପୁଙ୍ଗ୍‌; ");
INSERT INTO peg_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","ଇନାକିଦେଂକି ଆନ୍‌ ନିଜେ ମାନ୍‌ ମାନି କିଦେଙ୍ଗ୍‌ ଜୁଦ୍‌ୱାଦାଂ, ଇଚିସ୍‌ ନା ପକ୍‌ତାତାକାନିଂ ମାନ୍‌ ମାନି କିଦେଙ୍ଗ୍‌ ସାର୍ଗେତାଂ ଜୁତ୍‌ତାଙ୍ଗ୍‌ନା । ");
INSERT INTO peg_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","ଆରେ, ନା ପକ୍‌ତାତାକାନ୍‌ ଜେ ୱିଜ଼ାରିଂ ନାଙ୍ଗ୍‌ ଦାନ୍‌ କିଦ୍‌ନାନ୍‌, ହେୱାର୍‌ ବିତ୍ରେ ଇନେରିଂ ନେ ଇନେସ୍‌କି ଆନ୍‌ ଆରାୟ୍‌ କିୱାଦାଂ, ମାତର୍‌ ହାରିହାରା ଦିନ୍ତ ତାଙ୍ଗେଙ୍ଗ୍‌ ଆରେ ରଗ ଜିପ୍‌ନାଙ୍ଗ୍‌, ଇଦାଂ ତାଦାଙ୍ଗ୍‌ ମାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","ଇନାକିଦେଂକି ଇନେର୍‌କି ମାଜ଼ିଙ୍ଗ୍‌ ହୁଡ଼୍‌ଜି ତା ତାକେ ପାର୍ତି କିତାର୍‌, ହେୱାନ୍‌ ଇନେସ୍‌ ୱିଜ଼୍‌ୱି ଜିବୁନ୍‌ ପାୟା ଆନାନ୍‌, ଇଦାଂ ନେ ମାଞ୍ଜି ଆବାତି ମାନ୍‌; ଆରେ, ଆନ୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ହାରିହାରା ନାଜିଂ ଆରେ ରଗ ଜିପ୍‌ନାଙ୍ଗ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","“ଆନ୍‌ ସାର୍ଗେତାଂ ଜୁଜ଼ି ମାନ୍‌ଚି କାଦି ଆନାଙ୍ଗ୍‌, ହେୱାନ୍‌ ଇଦାଂ ଇଚିଲେ ଜିହୁଦିର୍‌ ତା ବେରୁତାଂ ନିନ୍ଦା କିଦେଙ୍ଗ୍‌ ଲାଗାତାର୍‌,” ");
INSERT INTO peg_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","ଆରେ ଇଚାର୍‌ ଇୱାନ୍‌ ଜସେପ୍‌ ମେହି ଜିସୁ ଆକାୟ୍‌, “ଆରେ ଆପେଂ ଇନାକା ଇୱାନ୍‌ ଲାତ୍ରାହି ତେହିଙ୍ଗ୍‌ ପୁନୁପ୍‌ ? ଲାଗିଂ ଆନ୍‌ ସାର୍ଗେତାଂ ଜୁତ୍‌ତାଙ୍ଗ୍‌ନା ଇଞ୍ଜି ହେୱାନ୍‌ ନଙ୍ଗ୍‌ ଇନେସ୍‌ ଇନାନ୍ନା ?” ");
INSERT INTO peg_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","ଜିସୁ ହେୱାରିଂ ଉତର୍‌ ହିତାନ୍‌, ଜାର୍‌ ଜାର୍‌ ବିତ୍ରେ ନିନ୍ଦା କିମାଟ୍‌ ? ");
INSERT INTO peg_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","ଇମ୍‌ଣି ଆବା ନାଙ୍ଗ୍‌ ପକ୍‌ତାତାନ୍ନା ହେୱାନ୍‌ ନାତାକେ ଚଞ୍ଜ୍‌ୟା ଆଦ୍‌ୱିତିସ୍‌ ଇନେର୍‌ ନା ଲାଗେ ୱାଦେଙ୍ଗ୍‌ ଆଡୁର୍‌ । ଇମ୍‌ଣାକାର୍‌ ୱାନାର୍‌ ହେୱାରିଂ ଆନ୍‌, ହାରିହାରା ନାଜିଂ ଆରେ ରଗ ଜିପ୍‌ନାଙ୍ଗ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","ବେଣ୍‌ବାକ୍‌ଣାୟ୍‌କିନାକାର୍‌ ଦରମ୍‌ ସାସ୍ତର୍‌ ତାକେ ଲେକିକିତାର୍ଣ୍ଣା, ୱିଜ଼ାର୍‌ କେବଲ୍‌ ଇସ୍ୱର୍ତି ହିକ୍ୟା ପାୟା ଆନାର୍‌ । ଇନେର୍‌କି ଆବା ତାକେଣ୍ଡାଂ ହିକ୍ୟା ଲାବ୍‌ କିତାନ୍‌ନ୍ନା, ହେୱାନ୍‌ ନାତାକେ ୱାନାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","ଇନେନ୍‌ ଜେ ଆବାଂ ହୁଡ଼୍‌ତାନ୍‌ନା, ହେଦାଂ ଆକାୟ୍‌; ଇନେର୍‌ ଇସ୍ୱର୍‌ ତାକେଣ୍ଡାଂ ୱାତାନ୍‌ନା, ହେୱାନ୍‌ ଆବାଂ ହୁଡ଼୍‌ତାନ୍‌ନା । ");
INSERT INTO peg_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","ହାତ୍‌ପା ହାତ୍‌ପା ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ଇଞ୍ଜ୍‌ନାଙ୍ଗା, ଇନେନ୍‌ ପାର୍ତି କିନାନ୍‌, ହେୱାନ୍‌ ୱିଜ଼୍‌ୱି ଜିବୁନ୍‌ ପାୟା ଆନାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","ଆନ୍‌ ଜିବୁନ୍‌ ହିନି କାଦି । ");
INSERT INTO peg_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","ମି ଆକର୍‌ ବାଟାତ ମାନ୍ନା ଚିଚାର୍‌, ଆତିସ୍‌ପା ହେୱାର୍‌ ହାତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","ମାତର୍‌ ଇମ୍‌ଣି କାଦି ସାର୍ଗେତାଂ ୱାନାତ୍‌, ତାଙ୍ଗେଙ୍ଗ୍‌ ଇନେର୍‌ ତିନାନ୍‌ ହେୱାନ୍‌ ୱିଜ଼୍‌ୱି ଜିବୁନ୍‌ ପାୟା ଆନାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","ଆନ୍‌ ସାର୍ଗେତାଂ ଜୁତ୍‌ତାଙ୍ଗ୍‌ ହେ ଜିବୁନ୍‌ କାଦି; ଇନେର୍‌ ଜଦି ଇ କାଦି ତିନାର୍‌, ହେୱାନ୍‌ ଜୁଗ୍‌ ଜୁଗ୍‌ ପାତେକ୍‌ ଜିଜ଼ି ମାନାର୍‌; ଆଁ, ଆନ୍‌ ଇମ୍‌ଣି କାଦି ହିଦ୍‌ନାଂ, ହେଦାଂ ନା ଜେଇ, ଆନ୍‌ ତା ପୁର୍ତିତିଂ ବାଚାୟ୍‌କିଦେଂ ଇଞ୍ଜି ଜିବୁନ୍‌ ହିଦ୍‌ନାଂ । ");
INSERT INTO peg_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","ଇବେ ଜିହୁଦିର୍‌ ହେୱେର୍‌ ହେୱାର୍‌ ରିସା ଆଜ଼ି ଇଞ୍ଜେଙ୍ଗ୍‌ ଲାଗାତାର୍‌, ଇୱାନ୍‌ ଇନେସ୍‌ ମାଙ୍ଗେଙ୍ଗ୍‌ ଜାର୍‌ ଜେଇ ତିଞ୍ଜେଙ୍ଗ୍‌ ହିଦେଂ ଆଡ୍‌ନାନ୍‌ ? ");
INSERT INTO peg_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","ହେବେ ଜିସୁ ହେୱାରିଂ ଇଚାନ୍‌, “ହାତ୍‌ପା ହାତ୍‌ପା ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ଇଞ୍ଜ୍‌ନାଙ୍ଗା, ମାନାୟ୍‌ ମାଜ଼ିତି ଜେଇ ତିନ୍‌ୱିତିସ୍‌ ଆରି ତା ନେତେର୍‌ ଉଣ୍‌ୱିତିସ୍‌, ମି ତାକେ ଜିବୁନ୍‌ ହିଲୁତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","ଇନେର୍‌ ନା ଜେଇ ତିନାର୍‌ ଆରି ନା ନେତେର୍‌ ଉଣାର୍‌, ହେୱାନ୍‌ ୱିଜ଼୍‌ୱି ଜିବୁନ୍‌ ପାୟା ଆନାନ୍‌, ଆରେ ଆନ୍‌ ହାରିହାରା ନାଜିଂ ତାଙ୍ଗେଙ୍ଗ୍‌ ଜିପିକିନାଙ୍ଗ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","ଇନାକିଦେଂକି ନା ଜେଇ ହାତ୍‌ପା କାଦି ଆରି ନା ନେତେର୍‌ ହାତ୍‌ପା ଏଜ଼ୁଂ । ");
INSERT INTO peg_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","ଇନେର୍‌କି ନା ଜେଇ ତିନାର୍‌ ଆରି ନା ନେତେର୍‌ ଉଣାର୍‌, ହେୱାନ୍‌ ନା ତାକେ ମାନେନ୍‌ ଆରି ଆନ୍‌ ତା ତାକେ ମାନାଙ୍ଗ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","ଜିବୁନ୍‌ନି ଆବା ନାଙ୍ଗେଙ୍ଗ୍‌ ପକ୍‌ତାତାନ୍ନା ଆରି ଆନ୍‌ ଆବା କାଜିଂ ଜିଜ଼ି ମାନାଂ, ହେ ଲାକେ ଜେ ନାଙ୍ଗେଙ୍ଗ୍‌ ତିଞ୍ଜିନାର୍‌, ହେୱାନ୍‌ ପାନା କାଜିଂ ଜିଜ଼ି ମାନାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","ଇମ୍‌ଣି କାଦି ସାର୍ଗେତାଂ ଜୁତ୍‌ତାନ୍ନା, ହେଦାଂ ଇ; ଆକର୍‌ ଇନେସ୍‌ ତିନ୍‌ଞ୍ଜି ହାତାର୍‌, ହେ ଲାକେ ଆକାୟ୍‌; ଜେ ଇ କାଦି ତିନାର୍‌, ହେୱାନ୍‌ ଜୁଗ୍‌ ଜୁଗ୍‌ ପାତେକ୍‌ ଜିଜ଼ି ମାନାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","ହେୱାନ୍‌ କପର୍ନାହୁମ୍‌ ର କୁଟୁମ୍‌ ଇଞ୍ଜ ହିକ୍ୟା ହିନି ସମୁତ ଇ ୱିଜ଼ୁ କାତା ଇଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","ଲାଗିଂ, ତା ଚେଲାହିର୍‌ ବିତ୍ରେ ହେନି ଇଦାଂ ୱେନ୍‌ଞ୍ଜି ଇଚାର୍‌, “ଇ ହିକ୍ୟା ୱେଞ୍ଜେଙ୍ଗ୍‌ ବେସି କସ୍ଟ, ଇନେର୍‌ ଇଦାଂ ୱେଞ୍ଜେଙ୍ଗ୍‌ ଆଡ୍‌ନାର୍‌ ?” ");
INSERT INTO peg_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","ମାତର୍‌ ଜିସୁ, ତା ଚେଲାର୍‌ ଇନେର୍‌ ହେ ବିସ୍ରେ ନିନ୍ଦା କିନାରା ଇଞ୍ଜି, ତା ମାନ୍ତ ପୁଞ୍ଜି ହେୱାରିଂ ଇଚାନ୍‌, ବାଦାନି କାରଣ୍‌ ଆନାତା ? ");
INSERT INTO peg_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","ମାନାୟ୍‌ ମାଜ଼ି ଇମେତାଂ ୱାତାନ୍‌ନା, ହେବେ ତାଙ୍ଗେଙ୍ଗ୍‌ ହାନାକା ହୁଡ଼୍‌ତାନ୍‌ ଇନା କିନାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","କେବଲ୍‌ ଇସ୍ୱର୍ତି ୱାସ୍ତି ଜିବୁନ୍‌ ହିଦେଂ ଆଡ୍‌ନାନ୍‌; ମାନାୟ୍‌ ଜେଇ ଇନାକା କିଦେଙ୍ଗ୍‌ ଆଡୁତ୍‌ ଇସ୍ୱର୍ତି ହେ ଜିବୁନ୍‌ ହିନି ୱାସ୍କିତିଂ ଏପେଙ୍ଗ୍‌ ଇନେସ୍‌ ପୁନାଦେର୍‌ ହେଦାଂ କାଜିଂ ଆନ୍‌ ଇ ୱିଜ଼ୁ କାତା ଇଞ୍ଜ୍‌ନାଙ୍ଗା । ");
INSERT INTO peg_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","ମାତର୍‌ ମି ବିତ୍ରେ ଇନେ ଇନେର୍‌ ପାର୍ତି କିଉରା । ଇନାକିଦେଂକି ଇମ୍‌ଣାକାର୍‌ ଜିସୁଙ୍ଗ୍‌ ପାର୍ତି କିୱାଦାଂ ମାଚାର୍‌ ଆରି ଇନେନ୍‌ ଜିସୁଙ୍ଗ୍‌ ସାତ୍ରୁର୍‌ କେଇଦ ଇନେନ୍‌ ହେଲାୟ୍‌ କିନାନ୍‌, ହେଦାଂ ଇସ୍ୱର୍‌ ଆଗେତାଂ ପୁଞ୍ଜି ମାଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","ଜିସୁ ଆରେ ଇଚାନ୍‌, “ଇଦାଂ କାଜିଂ ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ଇନ୍‌ଞ୍ଚାଙ୍ଗ୍‌ନ୍ନା, ଆବା ତାକେଣ୍ଡାଂ ପକ୍ୟା ଆୱିତିସ୍‌ ଇନେର୍‌ ନା କଚଣ୍‌ ୱାଦେଙ୍ଗ୍‌ ଆଡୁର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","ହେ ସମୁତାଂ ତା ଚେଲାହିର୍‌ ବିତ୍ରେ ହେନି ବେଣ୍‌କିୱାଦାଂ ହସି ହାଚାର୍‌, ଆରେ ତା ଲାହାଙ୍ଗ୍‌ ଚାଲା ବୁଲା କିୱାତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","ହେବେ ଜିସୁ ବାରଜାଣ୍‌ତିଂ ୱେନ୍‌ବାତାନ୍‌, “ଏପେଙ୍ଗ୍‌ପା ନାଙ୍ଗ୍‌ ପିସ୍ତି ହାଞ୍ଜେଙ୍ଗ୍‌ ଇଚା କିନାଦେରା ?” ");
INSERT INTO peg_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","ସିମନ୍‌ ପିତର୍‌ ଜିସୁଙ୍ଗ୍‌ ଉତର୍‌ ହିତାର୍‌, ମାପ୍ରୁ, ଇନେର୍‌ ତାକେ ହାନାପ୍‌ ? ନି ତାକେ ୱିଜ଼୍‌ୱି ଜିବୁନ୍‌ନି ବଚନ୍‌ ମାନାତ୍‌; ");
INSERT INTO peg_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","ଆରେ, ଏନ୍‌ ଜେ ଇସ୍ୱର୍ତି ହେ ପୁଇପୁୟା ମାନାୟ୍‌, “ଇଦାଂ ଆପେଂ ପାର୍ତି କିତାପ୍‌ନ୍ନା ଆରି ପୁଚାପ୍‌ନା ।” ");
INSERT INTO peg_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","ଜିସୁ ହେୱାରିଂ ଉତର୍‌ ହିତାନ୍‌, “ଆନ୍‌ ଇନାକା ମି ବାରଜାଣ୍‌ତିଂ ବାଚି କିୱାତାଂନା କି ? ଆରେ, ମି ବିତ୍ରେ ର ସୟ୍‌ତାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","ହେୱାନ୍‌ ଇସ୍କାରିୟତିୟ ସିମନ୍‌ ମେହି ଜିହୁଦାଙ୍ଗ୍‌ ହୁଡ଼୍‌ଜି ଏପେଙ୍ଗ୍‌ ଇଚାନ୍‌, ଇନାକିଦେଂକି ହେୱାନ୍‌ ବାରଜାଣ୍‌ ବିତ୍ରେ ରୱାନ୍‌, ଆରେ ହେୱାନ୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ସାତ୍ରୁର୍‌ କେଇଦ ହେଲାୟ୍‌ କିଦେଙ୍ଗ୍‌ ହାଲ୍‌ଜି ମାଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","ଇଦାଂ ପାଚେ ଜିସୁ ଗାଲିଲିତ ବୁଲାଆଦେଂ ଲାଗାତାନ୍‌, ଇନାକିଦେଂକି ଜିହୁଦିର୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ଟାଣ୍‌ତେ ଅହ୍‌ନି କାଜିଂ ସେସ୍ଟା କିଜ଼ି ମାଚିଲେ, ହେୱାନ୍‌ ଜିହୁଦା ଦେସ୍‌ତ ବୁଲାଆଦେଂ ମାନ୍‌ କିୱାଦାଂ ମାଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","ଜିହୁଦିର୍‌ କୁଡ଼ିୟା ବାହା ପାର୍ବୁନି ସମୁ ଲାଗେ ୱାଜ଼ି ମାଚାତ୍‌, ");
INSERT INTO peg_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","ତା ଟଣ୍ଡାହିର୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ଇଚାର୍‌, “ଏନ୍‌ ଜେ ଇନା କାମାୟ୍‌ କିତାୟ୍‌ନା, ହେ ୱିଜ଼ୁ ଇନେସ୍‌କି ନି ଚେଲାର୍‌ ପା ହୁଡ଼୍‌ନାର୍‌, ଇଦାଂ କାଜିଂ ଇବେଣ୍ଡାଂ ହସି ହାଲ୍‌ଜି ଜିହୁଦା ଦେସ୍‌ତ ହାଲାଟ୍‌, ");
INSERT INTO peg_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","ଇନାକିଦେଂକି ଇନେର୍‌ ଚଞ୍ଜିୟାଦେଂ ମାନ୍‌ କିତାନ୍‌ ଡ଼ୁଗ୍‌ଜି ଇନାକା କିଉନ୍‌ । ଏପେଙ୍ଗ୍‌ ଜଦି ୱିଜ଼ାଦେର୍‌, କିନାଦେରା, ଲାଗିଂ ଜାର୍‌ତିଂ ପୁର୍ତି ତାକେ ଚଚାଟ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","ଇନାକିଦେଂକି ତା ଟଣ୍ଡାହିର୍‌ ପା ତା ତାକେ ପାର୍ତି କିୱାଦାଂ ମାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","ହେବେ ଜିସୁ ହେୱାରିଂ ଇଚାନ୍‌, “ନା ସମୁ ନଙ୍ଗ୍‌ ପାତେକ୍‌ ଏକା ୱାଉତେ, ମାତର୍‌ ମି ସମୁ ଏକା ୱାତାତେ । ");
INSERT INTO peg_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","ପୁର୍ତି ମିଙ୍ଗେଙ୍ଗ୍‌ ଗିଣ୍‌ କିଦୁତ୍‌, ମାତର୍‌ ନାଙ୍ଗେଙ୍ଗ୍‌ ଗିଣ୍‌ କିଦ୍‌ନାତ୍‌, ଇନାକିଦେଂକି ତା କାମାୟ୍‌ ଜେ କାରାପ୍‌, ଆନ୍‌ ଇ ସାକି ହିତାଙ୍ଗ୍‌ନା । ");
INSERT INTO peg_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","ଏପେଙ୍ଗ୍‌ ଇ ପାର୍ବୁତ ହାଲାଟ୍‌, ଆନ୍‌ ନଙ୍ଗ୍‌ ଇ ପାର୍ବୁତ ହାଲୁଙ୍ଗା, ଇନାକିଦେଂକି ନା ସମୁ ଇ ପାତେକ୍‌ ଏକା ୱାଉତେ ।” ");
INSERT INTO peg_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","ଜିସୁ ହେୱାରିଂ ଇ ୱିଜ଼ୁ କାତା ଇଞ୍ଜି, ଗାଲିଲିତ ମାଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","ମାତର୍‌ ତାଂ ଟଣ୍ଡାହିର୍‌ ପାର୍ବୁତ ହାଚି ପାଚେ ହେୱାନ୍‌ ପା ହାଚାନ୍‌, ଚଞ୍ଜିୟାଆୱାଦାଂ ଆକାୟ୍‌, ମତର୍‌ ର ବାନି ଡ଼ୁଗ୍‌ଜି । ");
INSERT INTO peg_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","ଲାଗିଂ ଜିହୁଦି ନେତାର୍‌ ପାର୍ବୁତ ତାଙ୍ଗେଙ୍ଗ୍‌ ଡେକ୍‌ଚି ଡେକ୍‌ଚି ୱେନ୍‌ବାତାର୍‌, “ହେୱାନ୍‌ ଜେ ?” ");
INSERT INTO peg_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","ଆରେ, ତା ବିସ୍ରେ ମାନାୟାର୍‌ ବିତ୍ରେ ବେସି ହେୱାର୍‌ ହେୱେର୍‌ କାଲେ କାଲେ ବେଣ୍‌ କିଦେଙ୍ଗ୍‌ ଲାଗାତାର୍‌; “ଇନେ ଇନେର୍‌ ଇଚାର୍‌, ହେୱାନ୍‌ ରକାନ୍‌ ହାର୍‌ ଲଗୁ, ଆରେ ଇନେ ଇନେର୍‌ ଇଚାର୍‌, ଆକାୟ୍‌, ହେୱାନ୍‌ ମାନାୟାରିଂ ବୁଲ୍‌କାୟ୍‌କିନାନା ।” ");
INSERT INTO peg_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","ଆତିସ୍‌ପା ଜିହୁଦି ନେତାର୍‌ ପାଣ୍ଡ୍ରୁତିଂ ତା ବିସ୍ରେ ୱେଚ୍‌ଚେଙ୍ଗ୍‌ ଇନେର୍‌ ଇନାକା ଇନ୍‌ୱାଦାଂ ମାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","ମାତର୍‌ ପାର୍ବୁନି ଆଦା ସମୁ ହାଚି ପାଚେ, ଜିସୁ ମନ୍ଦିର୍‌ତ ହାଲ୍‌ଜି ହିକ୍ୟା ହିଦେଂ ଲାଗାତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","ଇବେ ଜିହୁଦି ନେତାର୍‌ କାବା ଆଜ଼ି ଇଚାର୍‌, “ଇୱାନ୍‌ ପାଟ୍‌ ପଡ଼ିକିୱାଦାଂ ଇନେସ୍‌ ପୁଚାନ୍‌ ?” ");
INSERT INTO peg_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","ଲାଗିଂ ଜିସୁ ହେୱାରିଂ ଉତର୍‌ ହିତାନ୍‌, “ନା ହିକ୍ୟା ନା ଜାର୍‌ତି ଆକାୟ୍‌, ମାତର୍‌ ନାଙ୍ଗ୍‌ ପକ୍‌ତାତାକାନ୍ତି ଇସ୍ୱର୍‌ତାଂ ୱାନି ହିକ୍ୟା ହିନାଙ୍ଗା । ");
INSERT INTO peg_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","ଇନେର୍‌ ଜଦି ଇସ୍ୱର୍‌ ଇଚା ମାନି କିଦେଙ୍ଗ୍‌ ମାନ୍‌କିନାନ୍‌, ତା ଆତିସ୍‌ ଇ ହିକ୍ୟା ଇସ୍ୱର୍‌ତାଂ ଆତାତ୍‌ନ୍ନା, କି ଆନ୍‌ ନି ତାକେଣ୍ଡାଂ ଇଞ୍ଜ୍‌ନାଙ୍ଗା, ହେଦାଂ ହେୱାନ୍‌ ପୁନାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","ଇନେନ୍‌ ଜାର୍‌ତାଂ ଇନାନ୍‌, ହେୱାନ୍‌ ନିଜେ ଜାଜ୍‌ମାଲ୍‌ ପାୟା ଆଦେଂ ଦାହ୍‌ନାନ୍‌, ମାତର୍‌ ଇନେନ୍‌ ଜାର୍‌ ପକ୍‌ତାତାକାନିଂ ପାଦ୍‌ ପାୟା ଆଦେଂ ଦାହ୍‌ନାନ୍‌, ହେୱାନ୍‌ ହାତ୍‌ପା ଇନାନ୍‌, ଆରେ ତାତାକେ ଇନାକାପା ଅଦାର୍ମି ମିଚ୍‌ ହିଲୁତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","ମସା ଇନାକା ମିଙ୍ଗେଙ୍ଗ୍‌ ବିଦି ହିଦ୍‌ୱାତାନ୍‌ନା ? ଆତିସ୍‌ପା ମି ବିତ୍ରେ ରୱାନ୍‌ ପା ବିଦି ମାନି କିଉଦେରା । ଏପେଙ୍ଗ୍‌ ଇନାକିଦେଂ ନାଙ୍ଗେଙ୍ଗ୍‌ ଅସ୍ତେଦେଂ ସେସ୍ଟା କିଦ୍‌ନାଦେରା ?” ");
INSERT INTO peg_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","“ମାନାୟାର୍‌ ଉତର୍‌ ହିତାର୍‌,” ନିଙ୍ଗେଙ୍ଗ୍‌ ପୁଦା ଆସ୍ତାତାନ୍ନା, “ଇନେର୍‌ ନିଙ୍ଗେଙ୍ଗ୍‌ ଅସ୍ତେଦେଂ ସେସ୍ଟା କିଦ୍ନାରା ?” ");
INSERT INTO peg_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","ଜିସୁ ହେୱାରିଂ ଉତର୍‌ ହିତାନ୍‌, “ଆନ୍‌ କାବାଆନି କାମାୟ୍‌ କିତାଙ୍ଗ୍‌, ଆରେ ଏପେଙ୍ଗ୍‌ ୱିଜ଼ାଦେର୍‌ କାବା ଆତାଦେର୍ଣ୍ଣା । ");
INSERT INTO peg_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","ଇ କାଜିଂ ମସା ମିଙ୍ଗେଙ୍ଗ୍‌ ସୁନ୍ନତ୍‌ ବିଦି ହିତ୍‌ତାନ୍ନା ଇଦାଂ ଜେ ମସାତାକେଣ୍ଡାଂ ଆତାତ୍‌ନ୍ନା, ହେଦାଂ ଆକାୟ୍‌, ମାତର୍‌ ଆକର୍‌ତାଂ, ଆରେ ଏପେଙ୍ଗ୍‌ ଜମ୍‌ନିବାର୍‌ ନାଜିଂ କାଡ଼୍‌ଦେରିଂ ସୁନ୍ନତ୍‌ କିନାଦେରା । ");
INSERT INTO peg_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","ମସାତି ବିଦି ୱିଜ଼୍‌ୱି କାଜିଂ ଜଦି ଜମ୍‌ନିବାର୍‌ ନାଜିଂ କାଡ଼୍‌ଦେଂ ସୁନ୍ନତ୍‌ ପାୟା ଆନାନ୍‌, ତା ଆତିସ୍‌ ଆନ୍‌ ଜମ୍‌ନିବାର୍‌ ନାଜିଂ ରୱାନ୍‌ କାଡ଼୍‌ଦେଂ ୱିଜ଼ୁ ଉଜ୍‌ କିତିଲେ ଏପେଙ୍ଗ୍‌ ଇନାକିଦେଂ ନା ଜପି ରିସା କିଦ୍‌ନାଦେରା ? ");
INSERT INTO peg_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","ବାର୍ତି ବିସ୍ରେ ହୁଡ଼୍‌ଜି ବିଚାର୍‌ କିୱାଦାଂ ନିୟାୟ୍‌ ବିଚାର୍‌ କିୟାଟ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","ଇବେ ଜିରୁସାଲମ୍‌ ନିକାର୍‌ ବିତ୍ରେ ଇନେର୍‌ ଇନେର୍‌ ଇଞ୍ଜେଙ୍ଗ୍‌ ଲାଗାତାର୍‌, “ଜିହୁଦି ନେତାର୍‌ ହେୱାର୍‌ ଇନେକିଦେଂ ଅହ୍‌ନି କାଜିଂ ସେସ୍ଟା କିଜ଼ି ମାଚାର୍‌, ଇୱାନ୍‌ ଇନାକା ହେୱାନ୍‌ ଆକାୟ୍‌ ? ");
INSERT INTO peg_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","ଆରେ ହୁଡ଼ାଟ୍‌, ହେୱାନ୍‌ ହପ୍‌ଚି କାତା ଇଞ୍ଜ୍‌ନାନା, ଆରେ ହେୱାର୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ଇନାକା କିଉରା । ଇୱାନ୍‌ ଜେ କ୍ରିସ୍ଟ, ଇୱାନ୍‌ ଇନାକା ନେତାର୍‌ ହାତ୍‌ପା ପୁଚାରେ ? ");
INSERT INTO peg_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","ଇନାକା ଆୟେତ୍‌, ଇୱାନ୍ତି ଆରମ୍‌ ଆସେଙ୍ଗ୍‌ ପୁନାସ୍‌, ମାତର୍‌ ମସିୟା ଏଚେକାଡ଼୍‌ଦ ୱାନାନ୍, ହେ ପାଦ୍‌ନା ତା ଆରମ୍‌ ଇନେର୍‌ ପୁନୁର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","ହେବେ ଜିସୁ ମନ୍ଦିର୍‌ତ ହିକ୍ୟା ହିଉ ହିଉ ଗାଜା କାଟ୍‌ତାଂ ଇଚାନ୍‌, ଏପେଙ୍ଗ୍‌ ନାଙ୍ଗେଙ୍ଗ୍‌ ଆରି ନା ଉବ୍‌ଜାଣ୍‌ ରିୟାଦେର୍‌ ପୁନାଦେର୍‌ ? ଆନ୍‌ ନିଜେତାଂ ୱାୱାତାଙ୍ଗ୍‌ନା, “ମାତର୍‌ ନା ପକ୍‌ତାତାକାନ୍‌ ହାତ୍‌ପା, ତାଙ୍ଗେଙ୍ଗ୍‌ ଏପେଙ୍ଗ୍‌ ପୁନୁଦେରା । ");
INSERT INTO peg_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","ଆନ୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ପୁନାଙ୍ଗ୍‌, ଇନାକିଦେଂକି ଆନ୍‌ ତା ତାକେଣ୍ଡାଂ ୱାତାଙ୍ଗ୍‌ନା, ଆରେ ହେୱାନ୍‌ ନାଙ୍ଗେଙ୍ଗ୍‌ ପକ୍‌ତାତାନ୍ନା । ");
INSERT INTO peg_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","ହେବେ ହେୱାର୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ଆସ୍ତେଙ୍ଗ୍‌ ସେସ୍ଟା କିତାର୍‌; ମାତର୍‌ ଇନେର୍‌ ତା ଜପି କେଇ କିୱାତାର୍‌, ଇନାକିଦେଂକି ତା ସମୁ ହେ ପାତେକ୍‌ ଏକା ୱାୱାଦାଙ୍ଗ୍‌ ମାଚାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","ମାତର୍‌ ମାନାୟାର୍‌ ବିତ୍ରେ ହେନି ତାତାକେ ପାର୍ତି କିଜ଼ି ଇଞ୍ଜେଙ୍ଗ୍‌ ଲାଗାତାର୍‌, ଇୱାନ୍‌ ଜେ ୱିଜ଼ାର୍‌ କାବାଆନି କାମାୟ୍‌ କିତାନ୍‌ନ୍ନା, କ୍ରିସ୍ଟ ୱାଜ଼ି ତା ତାକେଣ୍ଡାଂ ଇନାକା ଆଦିକ୍‌ କିନାନ୍‌ ?” ");
INSERT INTO peg_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","ପାରୁସିର୍‌ ମାନାୟାର୍‌ ତା ବିସ୍ରେ ବେଣ୍‌କିବାଆନାକା ୱେନ୍‌ଞ୍ଜି ଆରେ ମୁଡ଼୍‌ ମାପ୍ରୁହେବାକିନାକାନ୍‌ ଆରି ପାରୁସିର୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ଆହ୍‌ନି କାଜିଂ କାନାକାରିଂ ପକ୍ତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","ହେବେ ଜିସୁ ଇଚାନ୍‌, “ଆନ୍‌ ଆରେ ଅଲପ୍‍ ସମୁ ମି ଲାହାଙ୍ଗ୍‌ ମାନ୍‌ଗାନାଙ୍ଗ୍‌ ଆରେ ପକ୍‌ତାତାକାନ୍‌ ତାକେ ହାନାଙ୍ଗା । ");
INSERT INTO peg_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","ଏପେଙ୍ଗ୍‌ ନାଙ୍ଗେଙ୍ଗ୍‌ ଡେକ୍ତାନାଦେର୍‌, ମତର୍‌ ଗାଟାଆଦୁଦେର୍; ଆରେ, ଆନ୍‌ ଇମେତାକେ ମାନାଙ୍ଗ୍‌, ଏପେଙ୍ଗ୍‌ ହେବେ ହାଞ୍ଜେଙ୍ଗ୍‌ ଆଡୁଦେର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","ହେବେ ଜିହୁଦିର୍‌ ହେୱେର୍‌ ହେୱାର୍‌ ଇଚାର୍‌, “ଇୱାନ୍‌ ଇମେତାକେ ହାଞ୍ଜେଙ୍ଗ୍‌ ହତ୍‌ତାନ୍‌ନା ଜେ, ଆସେଙ୍ଗ୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ଗାଟାଆଉସ୍‌ ? ଇୱାନ୍‌ ଇନାକା ଗ୍ରିକ୍‌ନିକାର୍‌ ବିତ୍ରେ ଜେତ୍‌ କେତ୍‌ ଜିହୁଦିର୍‌ ତାକେ ହାଲ୍‌ଜି ଗ୍ରିକ୍‌ନିକାରିଂ ହିକ୍ୟା ହିଦେଂ ହତ୍‌ତାନ୍‌ନା ? ");
INSERT INTO peg_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","ଏପେଙ୍ଗ୍‌ ନାଙ୍ଗେଙ୍ଗ୍‌ ଡେକ୍ତାନାଦେର୍‌, ମତର୍‌ ଗାଟା ଆଦୁଦେର୍‌, ଆରେ ଆନ୍‌ ଇମେତାକେ ମାନାଙ୍ଗ୍‌, ଏପେଙ୍ଗ୍‌ ହେବେ ହାଞ୍ଜେଙ୍ଗ୍‌ ଆଡୁଦେର୍‌, ହେୱାନ୍‌ ଇ ଇମ୍‌ଣି କାତା ଇଚାନ୍‌, ହେ ଅରତ୍‌ ଇନାକା ?” ");
INSERT INTO peg_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","ୱିସ୍ତି ନାଜିଂ, ଇଚିସ୍‌, ପାର୍ବୁନି ଗାଜା ଦିନ୍ତ, ଜିସୁ ନିଲ୍‌ଚି ଗାଜା କାଟ୍‌ତାଂ ଇଚାନ୍‌, ଇନେର୍‌ ଜଦି ଏସ୍‌କି ଆନାନ୍‌, “ଲାଗିଂ ହେୱାନ୍‌ ନା ତାକେ ୱାୟେନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","ଦରମ୍‌ ସାସ୍ତର୍‌ ଲେକାଆତାତ୍‌ନା, ଇନେନ୍‌ ନା ତାକେ ପାର୍ତି କିଜ଼ି ହେୱାନ୍‌ ଉଣେନ୍‌, ତା ୱାସ୍କିତାଂ ଜିବୁନ୍‌ନି ଏଜ଼ୁଂ ଡ଼ିଜ଼ି ହାନିକ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","ତା ତାକେ ପାର୍ତି କିୱାକାର୍‌ ଇମ୍‌ଣି ଜିବୁନ୍‌ ପାୟାନି କାଜିଂ ହାଲ୍‌ଜି ମାଚାର୍‌, ଜିସୁ ବିସ୍ରେ ହେୱାନ୍‌ ଏପେଙ୍ଗ୍‌ ଇଚାନ୍‌, ଇନାକିଦେଂକି ଜିସୁ ହେପାତେକ୍‌ ଜାଜ୍‌ମାଲ୍‌ ପାୟାଆୱି କାଜିଂ ହେୱାର୍‌ ପୁଇପୁୟା ଜିବୁନ୍‌ ପାୟା ଆୱାଦାଂ ମାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","ଲାଗିଂ ମାନାୟାର୍‌ ବିତ୍ରେ ଇନେ ଇନେର୍‌ ଇ କାତା ୱେନ୍‌ଞ୍ଜି ଇଞ୍ଜେଙ୍ଗ୍‌ ଲାଗାତାର୍‌, “ଇୱାନ୍‌ ହାତ୍‌ପା ହେ ବେଣ୍‌ବାକ୍‌ଣାୟ୍‌କିନାକାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","ବିନେନିକାର୍‌ ଇଞ୍ଜେଙ୍ଗ୍‌ ଲାଗାତାର୍‌, “ଇୱାନ୍‌ କ୍ରିସ୍ଟ ।” ମାତର୍‌ ଇନେ ଇନେର୍‌ ଇଞ୍ଜେଙ୍ଗ୍‌ ଲାଗାତାର୍‌, “ଇନାକା ମସିୟା ଗାଲିଲିତାଂ ୱାଉନ୍‌ ! ");
INSERT INTO peg_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","କ୍ରିସ୍ଟ ଜେ ଦାଉଦ୍‌ ଲାତ୍ରାତାଂ ଆରି ଦାଉଦ୍‌ ନିକାର୍‌ ଇମେତାକେ ମାଚାର୍‌, ହେ ବେତ୍‌ଲିହିମ୍‌ ନାସ୍‌ତାଂ ୱାନାନ୍‌, ଇଦାଂ ଇନାକା ଦରମ୍‌ ସାସ୍ତର୍‌ ବଚନ୍‌ ଇନୁତା ?” ");
INSERT INTO peg_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","ଲାଗିଂ ମାନାୟାର୍‌ ବିତ୍ରେ ତା କାଜିଂ ବାଗ୍‌ଆନାକା ଗିଟା ଆତାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","ଆରେ, ହେୱାର୍‌ ବିତ୍ରେତାଂ କେତେ ଜାଣ୍‌ ଆସ୍ତେଙ୍ଗ୍‌ ଇଚା କିଜ଼ି ମାଚାର୍‌, ମାତର୍‌ ଇନେର୍‌ ତା ଜପି କେଇ କିୱାତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","ୱିସ୍ତି ବିତ୍ରେ କାନାକାର୍‌ ମାସ୍‌ଦି ୱାତିଲେ ମୁଡ଼୍‌ ମାପ୍ରୁହେବାକିନାକାନ୍‌ ଆରି ପାରୁସିର୍‌ ତାକେ ମାସ୍‌ଦି ୱାତାର୍‌, ଆରେ ହେୱାର୍‌ ହେୱାରିଂ ୱେନ୍‌ବାତାର୍‌, “ଏପେଙ୍ଗ୍‌ ଇନାକିଦେଂ ତାଙ୍ଗେଙ୍ଗ୍‌ ତାସ୍‌ ୱାୱାତାଦେର୍‌ ?” ");
INSERT INTO peg_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","କାନାକାର୍‌ ଉତର୍‌ ହିତାର୍‌, “ଇ ମାନାୟ୍‌ ଇନେସ୍‌କି କାତା ଇନାନ୍‌, ଇମ୍‌ଣି ମାନାୟ୍‌ ଇନାୱାଡ଼ାଂ ହେ ଲାକେ ଇନ୍‌ୱାତାଂନ୍ନା ।” ");
INSERT INTO peg_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","“ହେବେ ପାରୁସିର୍‌ ହେୱାରିଂ ଉତର୍‌ ହିତାର୍‌,” ଏପେଙ୍ଗ୍‌ ପା ଇନାକା ବୁଲ୍‌କାଇ କିୟାତାଦେର୍‌ ? ");
INSERT INTO peg_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","“ନେତାର୍‌ ବିତ୍ରେ କି ପାରୁସିର୍‌ ବିତ୍ରେ ଇନାକା ଇନେର୍‌ ତା ତାକେ ପାର୍ତି କିନାରା, ଇଦାଂ ଏନ୍‌ ପୁନାୟ୍‌ ? ");
INSERT INTO peg_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","ମାତର୍‌ ଇ ଇମ୍‌ଣି ଲଗୁ ମସାତି ବିଦି ପୁନୁର୍‌, ହେଦାଂ କାଜିଂ ଇୱାର୍‌ ୱିଜ଼ାର୍‌ ବାଗ୍‌ଇଟ୍‌ୟାଆତି ମାନାୟାର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","ଇମ୍‌ଣି ନିକଦିମ୍‌ ଇଦାଂ ପାଚେ ତା ତାକେ ୱାଜ଼ି ମାଚାନ୍‌ ଆରି ଜେ ହେୱାର୍‌ ବିତ୍ରେ ରୱାନ୍‌, ହେୱାନ୍‌ ହେୱାରିଂ ୱେନ୍‌ବାତାନ୍‌, ");
INSERT INTO peg_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“ର ମାନାୟ୍‌ ତାଙ୍ଗ୍‌ ପର୍ତୁମ୍‌ ୱେନ୍‌ୱାଦାଂ ଆରି ତା ମାନି ବିସ୍ରେ ପୁନ୍‌ୱାଦାଂ ମା ବିଦି ଇନାକା ତାଙ୍ଗେଙ୍ଗ୍‌ ଦସ୍‌ କିତାର୍‌ ?” ");
INSERT INTO peg_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","“ହେୱାର୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ଉତର୍‌ ହିତାର୍‌,” ଏପେଙ୍ଗ୍‌ପା ଇନାକା ର ଗାଲିଲି ମାନାୟ୍‌ ? ଗାଲିଲିତାଂ ଇମ୍‌ଣି ବେଣ୍‌ବାକ୍‌ଣାୟ୍‌କିନାକାନ୍‌ ହତୁର୍‌, “ଇଦାଂ ଇଟ୍‌କାଡ଼୍‌ କିଜ଼ି ହୁଡ଼ାଟ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","ଆରେ ହେୱାର୍‌ ୱିଜ଼ାର୍‌ ଜାର୍‌ ଜାର୍‌ ଇଞ୍ଜ ହାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","ମାତର୍‌ ଜିସୁ ଜିତ୍‌ମାଡ଼ିତ ହାଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","ଆର୍କାତ୍‌ ନାଜିଂ ହେୱାନ୍‌ ଆରେ ରଗ ମନ୍ଦିର୍‌ତ ୱାତାନ୍‌, ଆରେ ୱିଜ଼ାର୍‌ ମାନାୟ୍‌ ତା କଚଣ୍‌ତ ୱାତିଲେ, ହେୱାନ୍‌ କୁଚ୍‌ଚି ହେୱାରିଂ ହିକ୍ୟା ହିଦେଂ ଲାଗାତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","ଆରେ, ସାସ୍ତିର୍‌ ଆରି ପାରୁସିର୍‌ ଦାରି କାମାୟ୍‌ ଦାରାପଡ଼ା ଆତି ର କଗ୍‌ଲେହିମ୍‌ଣାଂ ତାସ୍‌ ୱାଜ଼ି ହେଦେଲିଂ ମାଦି ବାହାତ ନିଲି କିଜ଼ି ଜିସୁଙ୍ଗ୍‌ ଇଚାର୍‌, ");
INSERT INTO peg_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","“ଏ ଗୁରୁ, ଇ କଗ୍‌ଲେହିମ୍‌ଣା ଦାରି କାମାୟ୍‌ କିନି ସମୁତ ଦାରାପଡ଼ା ଆତାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","ଇ ଲାକେ କଗ୍‌ଲେକାଂ କାଲ୍‌କୁ ଇଡ଼୍‌ଜି ଅସ୍ତେଙ୍ଗ୍‌ ମସା ମାଙ୍ଗେଙ୍ଗ୍‌ ବିଦିତ ବଲ୍‌ ହିତ୍‌ନ୍ନା; ଲାଗିଂ ଏନ୍‌ ଇନାକା ଇଞ୍ଜ୍‌ନାୟା ?” ");
INSERT INTO peg_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","ହେୱାର୍‌ ଇନେସ୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ବେରୁତାଂ ଇନାର୍‌ ଇନାକିଦେଂକି ଗାଟା ଆନାର୍‌, ଇଦାଂ କାଜିଂ ହେୱାର୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ପରିକ୍ୟା କିନି ବିସ୍ରେ ଇଦାଂ ଇଚାର୍‌ । ମାତର୍‌ ଜିସୁ ଟଡ଼୍‌ଜି ୱାଚ୍‌କାଙ୍ଗ୍‌ ହୁକେ ମେଦ୍‌ନିତ ଲେକିକିଦେଂ ଲାଗାତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","ହେୱାର୍‌ ହେବେ ନିଲ୍‌ଚି ଆରେ ୱେନ୍‌ବିତିଲେ, ହେୱାନ୍‌ କାପ୍‌ଡ଼ା ନିକ୍‌ଚି ହେୱାରିଂ ଇଚାନ୍‌, ମି ବିତ୍ରେତାଂ ଇନେର୍‌ ଇନାୱାଡ଼ାଂ ପା ଇନା ପାପ୍‌କିୱାତାନ୍‌ନା, “ହେୱାନ୍‌ ପର୍ତୁମ୍‌ ୱାଜ଼ି କାଲ୍‌ ଇଡ଼େନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","ଆରେ ରଗ ହେୱାନ୍‌ ଟଡ଼୍‌ଜି ମେଦ୍‌ନିତ ଲେକିକିଦେଂ ଲାଗାତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","ହେଦାଂ ୱେନ୍‌ଞ୍ଜି ହେୱାର୍‌ ପ୍ରାଚିନାର୍‌ ତାଂ ଆରମ୍‌ କିଜ଼ି ରୱାନ୍‌ ରୱାନ୍‌ ଆଜ଼ି ୱିଜ଼ାର୍‌ ହସି ହାଞ୍ଜେଙ୍ଗ୍‌ ଲାଗାତାର୍‌, ଆରେ କେବଲ୍‌ ଜିସୁ ଆରି ମାଦି ହେ କଗ୍‌ଲେହିମ୍‌ଣାଂ ମାଚିକ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","“ଆରେ ଜିସୁ କାପ୍‌ଡ଼ା ନିକ୍‌ଚି ତାଙ୍ଗେଙ୍ଗ୍‌ ଇଚାନ୍‌,” ଏ କଇ, ହେୱାର୍‌ ଇମେର୍‌ ? ଇନେର୍‌ ଇନାକା ନିଙ୍ଗେଙ୍ଗ୍‌ ଦାଣ୍ଡ୍‌ ଇଞ୍ଜି ବିଚାର୍‌ କିୱାତାର୍‌ କି ? ");
INSERT INTO peg_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","“ହେଦେଲ୍‌ ଇଚାତ୍‌, ଇନେର୍‌ ହିଲୁର୍‌ ମାପ୍ରୁ ।” ହେବେ ଜିସୁ ଇଚାନ୍‌, “ଆନ୍‌ ପା ନିଙ୍ଗେଙ୍ଗ୍‌ ଦାଣ୍ଡ୍‌ ହିଦ୍‌ନାଂ ଇଞ୍ଜି ବିଚାର୍‌ କିଦୁଙ୍ଗା; ହାଲା, ନେଞ୍ଜେଙ୍ଗ୍‌ ତାଙ୍ଗ୍‌ ଆରେ ପାପ୍‌ କିମା ।” ");
INSERT INTO peg_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","ଜିସୁ ଆରେ ରଗ ପାରୁସିରିଂ ଇଚାନ୍‌, “ଆନ୍‌ ପୁର୍ତିନି ଅଜଡ଼୍‌” ଇନେର୍‌ ନା ପାଚେ ୱାନାର୍‌, “ହେୱାନ୍‌ ଇନାୱାଡ଼ାଂ ପା ମାଜ୍‌ଗାତ ବୁଲା ଆଉନ୍‌, ଇଚିସ୍‌ ଜିବୁନ୍‌ନି ଅଜଡ଼୍‌ ପାୟା ଆନାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","ହେବେ ପାରୁସିର୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ଇଚାର୍‌, “ଏପେଙ୍ଗ୍‌ ଜାର୍‌ ଜାର୍‌ତିଂ ବିସ୍ରେ ସାକି ହିନାଦେରା, ମି ସାକି ହାତ୍‌ପା ଆକାୟ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","ଜିସୁ ହେୱାରିଂ ଉତର୍‌ ହିତାନ୍‌, ଆନ୍‌ ଜଦି ନିଜେ ବିସ୍ରେ ସାକି ହିଜ଼ିମାନାଂ, ଲାଗିଂ ପାନା ସାକି ହାତ୍‌ପା, ଇନାକିଦେଂକି ଆନ୍‌ ଇମ୍‌ଣି ବାହାତାଂ ୱାତାଙ୍ଗ୍‌ନା ଆରି ଇମ୍‌ଣି ବାହାତାକେ ହାନାଙ୍ଗା, ହେଦାଂ ପୁନାଙ୍ଗ୍‌, “ମାତର୍‌ ଆନ୍‌ ଇମ୍‌ଣି ବାହାତାଂ ୱାନାଙ୍ଗ୍‌ କି ଇମ୍‌ଣି ବାହାତ ହାନାଙ୍ଗ୍‌, ହେଦାଂ ଏପେଙ୍ଗ୍‌ ପୁନୁଦେର୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","ଏପେଙ୍ଗ୍‌ ମାନାୟାର୍‌ ବାବ୍ରେ ବିଚାର୍‌ କିଜ଼ି ମାନାଟ୍‌, ଆନ୍‌ ଇନେରିଂ ବିଚାର୍‌ କିଉଙ୍ଗ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","ମାତର୍‌ ଆନ୍‌ ଜଦି ବିଚାର୍‌ କିନାଙ୍ଗ୍‌, ଲାଗିଂ ପାନା ବିଚାର୍‌ ହାତ୍‌ପା; ଇନାକିଦେଂକି ଆନ୍‌ ରୱାଙ୍ଗ୍‌ ଆକାୟ୍‌, ମତର୍‌ ନାଙ୍ଗ୍‌ ପକ୍‌ତାତାକାନ୍‌ ଆବା ନା ଲାହାଙ୍ଗ୍‌ ମାନାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","ଆରେ, ରିୟାର୍‌ତି ସାକି କାତା ସମାନ୍‌ ଆତିସ୍‌ ହେୱାର୍‌ ଇନାକା ଇନାରା ହେଦାଂ ହାତ୍‌ପା, ଇଦାଂ ମି ବିଦିତ ପା ଲେକା ମାନାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","ନା ନିଜେ କାଜିଂ ଆନ୍‌ ସାକି ହିନାଙ୍ଗା, ଆରେ ନାଙ୍ଗ୍‌ ପକ୍ତିତି ଆବା ନା ବିସ୍ରେ ସାକି ହିନାନା ।” ");
INSERT INTO peg_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","ହେବେ ହେୱାର୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ୱେନ୍‌ବେଦେଂ ଲାଗାତାର୍‌, “ମି ଆବା ଇମେନ୍‌ ?” ଜିସୁ ଉତର୍‌ ହିତାନ୍‌, “ଏପେଙ୍ଗ୍‌ ନାଙ୍ଗେଙ୍ଗ୍‌ ପୁଞ୍ଜୁଦେର୍‌ କି ମାଞ୍ଜି ଆବାଂ ପା ପୁନୁଦେର୍‌ ଜଦି ନାଙ୍ଗ୍‌ ପୁନ୍‌ଚିସ୍, ଲାଗିଂ ମାଞ୍ଜି ଆବାଂ ପା ପୁଚାଦେର୍ମା ।” ");
INSERT INTO peg_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","ମନ୍ଦିର୍‌ନି ଦାନ୍‌ ଇଟ୍‌ନି ପେଡ଼ିଙ୍ଗ୍‌ ଇଡ଼୍‌ଜି ମାଚି ଇଞ୍ଜ ଜିସୁ ଇ ୱିଜ଼ୁ କାତା ବିସ୍ରେ ହିକ୍ୟା ହିିଜ଼ି ମାଚାନ୍‌, ଆରେ ଇନେର୍‌ପା ତାଙ୍ଗେଙ୍ଗ୍‌ ଗେହ୍‌ନାକା କିୱାତାର୍‌ ଇନାକିଦେଂକି, ତା ସମୁ ଏକାୱାୱାଦାଂ ମାଚାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","ଜିସୁ ଆରେ ରଗ ହେୱାରିଂ ଇଚାନ୍‌, “ଆନ୍‌ ହାନାଙ୍ଗା, ଆରେ ଏପେଙ୍ଗ୍‌ ନାଙ୍ଗ୍‌ ଡେକ୍ତାନାଦେର୍‌ ମାତର୍‌ ଏପେଙ୍ଗ୍‌ ଜାର୍‌ ଜାର୍‌ ପାପ୍‌ତ ହାନାଦେର୍‌, ଆନ୍‌ ଇମେତାକେ ହାନାଙ୍ଗା, ଏପେଙ୍ଗ୍‌ ହେବେ ହାଞ୍ଜେଙ୍ଗ୍‌ ଆଡୁଦେର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","ଜିହୁଦି ନେତାର୍‌ ଇଞ୍ଜେଙ୍ଗ୍‌ ଲାଗାତାର୍‌, “ଆନ୍‌ ଇମେତାକେ ହାନାଙ୍ଗା, ଏପେଙ୍ଗ୍‌ ହେବେ ହାଞ୍ଜେଙ୍ଗ୍‌ ଆଡୁର୍‌, ଇୱାନ୍‌ ଇନାକା କକ୍‌ଲାପାଟିୟା ଆଦେଂ ବାବି କିନାନା କି ।” ");
INSERT INTO peg_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","ହେବେ ଜିସୁ ହେୱାରିଂ ଇଚାର୍‌, “ଏପେଙ୍ଗ୍‌ ଇ ପୁର୍ତିତ ଜଲମ୍‌ ମାତର୍‌ ଆନ୍‌ ସାର୍ଗେତାଂ ୱାତାଙ୍ଗ୍‌ନା ଏପେଙ୍ଗ୍‌ ଇ ପୁର୍ତିନିକାଦେର୍‌ ମାତର୍‌, ଆନ୍‌ ଇ ପୁର୍ତିନିକାଂ ଆକାୟ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","ଲାଗିଂ ଏପେଙ୍ଗ୍‌ ଜେ ଜାର୍‌ ଜାର୍‌ ପାପ୍‌ତ ହାନାଦେର୍‌, ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ଇଦାଂ ଇନ୍‌ଚାଙ୍ଗ୍‌; ଇନାକିଦେଂକି ଆନ୍‌ ହେୱାଙ୍ଗ୍‌ ମାନାୟ୍‌, ଇଦାଂ ଏପେଙ୍ଗ୍‌ ପାର୍ତି କିଦ୍‌ୱା ତାଦେର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","ହେବେ ହେୱାର୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ୱେନ୍‌ବାତାର୍‌, “ଏନ୍‌ ଇନେନ୍‌ ?” ଜିସୁ ହେୱାରିଂ ଇଚାନ୍‌, “ହେ କାତା ଆରମ୍‌ ତାଙ୍ଗ୍‌ ଇଞ୍ଜି ୱାନାଙ୍ଗା ? ");
INSERT INTO peg_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","ମି ବିସ୍ରେ ଇଞ୍ଜେଙ୍ଗ୍‌ ଆରି ବିଚାର୍‌ କିଦେଙ୍ଗ୍‌ ଆନ୍‌ ମି ବିସ୍ରେ ବେସି ଇଞ୍ଜ୍‌ନାକା ମାନାତ୍‌; ଇନେସ୍‌ ଆୟେତ୍‌, ନାଙ୍ଗ୍‌ ପକ୍‌ତାତାକାନ୍‌ ହାତ୍‌ପା, ଆରେ ଆନ୍‌ ତା ତାକେଣ୍ଡାଂ ଇନା ଇନାକା ୱେଚାଙ୍ଗ୍‌ନା, ହେଦାଂ ୱିଜ଼ୁ ପୁର୍ତିତିଂ ୱେଚ୍‌ନାଙ୍ଗା ।” ");
INSERT INTO peg_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","ଜିସୁ ଜେ ଆବା ବିସ୍ରେ ହେୱାରିଂ ଇଞ୍ଜି ମାଚାନ୍‌, ଇଦାଂ ହେୱାର୍‌ ବୁଜାଆୱାତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","ଜିସୁ ଇଚାନ୍‌, “ଏଚେକାଡ଼୍‌ଦ ଏପେଙ୍ଗ୍‌ ମାନାୟ୍‌ ମାଜ଼ି ଜପି ପେସ୍‌ନାଦେର୍‌, ହେ ପାଦ୍‌ନା ଆନ୍‌ ଜେ ହେ ମାନାୟ୍‌ ଆରି ଆନ୍‌ ନିଜେ ଆଦିକାର୍‌ ଇନାକା କିୱାଦାଂ ଇଚିସ୍‌ ଆବା ନାଙ୍ଗେଙ୍ଗ୍‌ ଇନେସ୍‌ ହିକ୍ୟା ହିତ୍‌ତାନ୍‌, ହେ ଲାକେ ଇ ୱିଜ଼ୁ କାତା ଜେ ଇଞ୍ଜ୍‌ନାଙ୍ଗା, ଇଦାଂ ଏପେଙ୍ଗ୍‌ ବୁଜାଆନାଦେର୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","ନା ପକ୍‌ତାତାକାନ୍‌ ହେୱାନ୍‌ ନା ଲାହାଙ୍ଗ୍‌ ମାନାନ୍‌; ହେୱାନ୍‌ ନାଙ୍ଗେଙ୍ଗ୍‌ ରୱାନିଂ ପିସ୍ତି ହାଞ୍ଜ୍‌ୱାତାନ୍‌, ଇନାକିଦେଂକି ତାଦାଙ୍ଗ୍‌ ଇନାକା ମାନ୍‌ ହେଦାଂ ଆନ୍‌ କିନାଙ୍ଗ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","ଜିସୁତି ଇ ୱିଜ଼ୁ କାତା ୱେନ୍‌ଞ୍ଜି, ତା ତାକେ ପାର୍ତି କିତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","ଲାଗିଂ, ଜିସୁ ତାଙ୍ଗେଙ୍ଗ୍‌ ପାର୍ତି କିଜ଼ି ମାନି ଜିହୁଦିରିଂ ଇଚାନ୍‌, “ଜଦି ଏପେଙ୍ଗ୍‌ ନା ହିକ୍ୟାତ ପାର୍ତି କିଦ୍‌ନାଦେର୍‌ ତା ଆତିସ୍‌, ଲାଗିଂ ଏପେଙ୍ଗ୍‌ ହାତ୍‌ପା ନା ଚେଲା କାଦେର୍‌, ");
INSERT INTO peg_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","ଆରେ ଏପେଙ୍ଗ୍‌ ହାତ୍‌ପା ପୁନାଦେର୍‌ ଆରି ହେ ହାତ୍‌ପା ମିଙ୍ଗେଙ୍ଗ୍‌ ମୁକ୍‌ଡ଼ାୟ୍‌ କିଦ୍‌ନାତ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","“ହେୱାର୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ଉତର୍‌ ହିତାର୍‌,” ଆପେଂ ଅବ୍ରାହାମ୍‌ନି ଲାତ୍ରା, ଇନାୱାଡ଼ାଂ ଇନେର୍‌ ଆଡ଼ିଏନ୍‌ ଆୱାତାଇନା, “ଲାଗିଂ ଏପେଙ୍ଗ୍‌ ମୁକ୍‌ଡ଼ା ଆନାଦେର୍‌ ଇଞ୍ଜି ଏପେଙ୍ଗ୍‌ ଇନେସ୍‌ ଇନାଦେରା ? ଇ ଅରତ୍‌ ଇନାକା ?” ");
INSERT INTO peg_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","ଜିସୁ ହେୱାରିଂ ଉତର୍‌ ହିତାନ୍‌, “ହାତ୍‌ପା ହାତ୍‌ପା ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ଇଞ୍ଜ୍‌ନାଙ୍ଗା, ଇନେର୍‌କି ପାପ୍‌ କିତାର୍‌, ହେୱାନ୍‌ ପାପ୍‌ନି ହଲ୍ୟା । ");
INSERT INTO peg_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","ହଲ୍ୟା ଜାଇଜୁଗ୍‌ ଇଞ୍ଜ ମାନ୍‌ଗୁନ୍‌, ମାତର୍‌ ମାଜ଼ି ଜୁଗ୍‌ ଜୁଗ୍‌ ମାନ୍‌ଗାନାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","ଲାଗିଂ, ମାଜ଼ି ଜଦି ମିଙ୍ଗେଙ୍ଗ୍‌ ମୁକ୍‌ଡ଼ାୟ୍‌ କିଦ୍‌ନାନ୍‌, ତା ଆତିସ୍‌ ଏପେଙ୍ଗ୍‌ ହାତ୍‌ପାରଚେ ମୁକ୍‌ଡ଼ା ଆନାଦେର୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","ଏପେଙ୍ଗ୍‌ ଜେ ଅବ୍ରାହାମ୍‌ନି ଲାତ୍ରା, ହେଦାଂ ଆନ୍‌ ପୁନାଙ୍ଗ୍‌; ମାତର୍‌ ନା ବଚନ୍‌ ମି ୱାସ୍କିତ ହିଲ୍‌ୱିତିଲେ ଏପେଙ୍ଗ୍‌ ନାଙ୍ଗେଙ୍ଗ୍‌ ଅସ୍ତେଦେଂ ସେସ୍ଟା କିଦ୍‌ନାଦେରା । ");
INSERT INTO peg_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","ମାଞ୍ଜି ଆବା ତାକେ ଇନା ଇନାକା ହୁଡ଼୍‌ତାଙ୍ଗ୍‌ନା, ହେଦାଂ ଆନ୍‌ ଇଞ୍ଜ୍‌ନାଙ୍ଗା, ମାତର୍‌ ମି ଆବା ଇଞ୍ଜ୍‌ନି ଲାକେ ଏନ୍‌ କାମାୟ୍‌ କିନାୟା ।” ");
INSERT INTO peg_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","ହେୱାର୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ଉତର୍‌ ହିତାର୍‌, “ଅବ୍ରାହାମ୍‌ ମା ଆବା ଆଦ୍‌ନାନ୍‌ ।” ଜିସୁ ହେୱାରିଂ ଇଚାନ୍‌, “ଜଦି ଏପେଙ୍ଗ୍‌ ଅବ୍ରାହାମ୍‌ ମେହି, ତା ଆତିସ୍‌ ଲାଗିଂ ଅବ୍ରାହାମ୍‌ତି କାମାୟ୍‌ କିତା ଦେର୍‌ମା; ");
INSERT INTO peg_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","ମାତର୍‌ ଇନେର୍‌ ଇସ୍ୱର୍‌ ତାକେଣ୍ଡାଂ ୱେନ୍‌ଞ୍ଜି ମାନି ହାତ୍‌ପା ପିସ୍ତି ମିଙ୍ଗେଙ୍ଗ୍‌ ଇଞ୍ଜୁଙ୍ଗା, ଏଲେଙ୍ଗ୍‌ବାର୍ତି ମାନାୟ୍‌ ଜେ ଆନ୍‌, ନାଙ୍ଗେଙ୍ଗ୍‌ ଏପେଙ୍ଗ୍‌ ନଙ୍ଗ୍‌ ଅସ୍ତେଙ୍ଗ୍‌ ସେସ୍ଟା କିଦ୍‌ନାଦେରା; ଅବ୍ରାହାମ୍‌ ଏଲେଙ୍ଗ୍‌ କାମାୟ୍‌ କିୱାଦାଂ ମାଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","ଏପେଙ୍ଗ୍‌ ମି ଆବାତି କାମାୟ୍‌ ସବୁ କିନାଦେରା ।” “ହେୱାର୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ଇଚାର୍‌, ଆପେଂ ଦାରିତାଂ ଜଲମ୍‌ ଆୱାତାପ୍‌ନା; ମା ରୱାନ୍‌ ମତର୍‌ ଆବା, ହେୱାନ୍‌ ଇସ୍ୱର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","ଜିସୁ ହେୱାରିଂ ଇଚାନ୍‌, “ଇସ୍ୱର୍‌ ଜଦି ହାତ୍‌ପା ମି ଆବା, ତାଆତିସ୍‌ ଏପେଙ୍ଗ୍‌ ନାଙ୍ଗେଙ୍ଗ୍‌ ଜିଉ ନତ୍‌ତାଦେର୍ମା; ଇନାକିଦେଂକି ଆନ୍‌ ଇସ୍ୱର୍‌ ତାକେଣ୍ଡାଂ ୱାତାଙ୍ଗ୍‌ନା; ଆନ୍‌ ନିଜେ ତାଙ୍ଗ୍‌ ୱାୱାତାଙ୍ଗ୍‌ନା, ମାତର୍‌ ହେୱାନ୍‌ ନାଙ୍ଗେଙ୍ଗ୍‌ ପକ୍‌ତାତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","ଆନ୍‌ ଇନାକା ଇଞ୍ଜ୍‌ନାଙ୍ଗ୍‌ ଏପେଙ୍ଗ୍‌ ଇନାକିଦେଂ ବୁଜା ଆଉଦେରା ? ଇନେକିଦେଂକି ଏପେଙ୍ଗ୍‌ ନା ହିକ୍ୟା ୱେନ୍‌ଞ୍ଜି ଇଟ୍‌ଦେଂ ଆଡୁଦେରା । ");
INSERT INTO peg_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","ଏପେଙ୍ଗ୍‌ ମି ଆବା ସୟ୍‌ତାନ୍‌ ତାଙ୍ଗ୍‌ ହତ୍‌ତାନ୍‌ନା, ଆରେ ମି ଆବାତି କାମାୟ୍‌ ମାନି କିଦେଙ୍ଗ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ମାନ୍‌ । ହେୱାନ୍‌ ଆଗେତାଂ ନାର୍‌ଅହ୍‌ନାକାନ୍‌, ଆରେ ହେୱାନ୍‌ ହାତ୍‌ପା ମାନୁନ୍‌, ଇନାକିଦେଂକି ତା ତାକେ ସତ୍‌ ହିଲୁତ୍‌ । ହେ ପାଦ୍‌ନା ହେୱାନ୍‌ ମିଚ୍‌ ଇନାନ୍‌, ହେ ପାଦ୍‌ନା ହେୱାନ୍‌ ଜାର୍‌ତାଂ ଇନାନ୍‌; ଇନାକିଦେଂକି ହେୱାନ୍‌ ମିଚ୍‌ୱା ଆରି ମିଚ୍‌ ଇନି ଆବା । ");
INSERT INTO peg_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","ମାତର୍‌ ଆନ୍‌ ହାତ୍‌ପା ଇଞ୍ଚିଲେ ଏପେଙ୍ଗ୍‌ ନାଙ୍ଗେଙ୍ଗ୍‌ ପାର୍ତି କିଦୁଦେରା । ");
INSERT INTO peg_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","ନା ତାକେ ପାପ୍‌ ମାନାତ୍‌ ଇଞ୍ଜି ମି ବିତ୍ରେତାଂ ଇନେର୍‌ ସାକି ହିନାନା ? ଆନ୍‌ ଏଚେକାଡ଼୍‌ଦ ହାତ୍‌ପା ଇନାଙ୍ଗ୍‌, ଲାଗିଂ ଏପେଙ୍ଗ୍‌ ଇନାକିଦେଂ ନାଙ୍ଗେଙ୍ଗ୍‌ ପାର୍ତି କିଦୁଦେରା ? ");
INSERT INTO peg_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","ଇନେର୍‌ ଇସ୍ୱର୍‌ ତାକେଣ୍ଡାଂ ଜଲମ୍‌ ଆତାନ୍ନା, ହେୱାନ୍‌ ଇସ୍ୱର୍‌ ବଚନ୍‌ ୱେନାନ୍‌; ଇଦାଂ କାଜିଂ ଏପେଙ୍ଗ୍‌ ୱେନୁଦେରା, ଇନାକିଦେଂକି ଏପେଙ୍ଗ୍‌ ଇସ୍ୱର୍‌ତାଂ ଜଲମ୍‌ ଆୱାତାଦେର୍ଣ୍ଣା ।” ");
INSERT INTO peg_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","ଜିହୁଦିର୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ୱେନ୍‌ବାତାର୍‌, “ଏନ୍‌ ଜେ ରୱାୟ୍‌ ସମିରଣିୟତି ଆରି ନିଙ୍ଗେଙ୍ଗ୍‌ ଜେ ପୁଦା ଡୁତ୍‌ତାତ୍‌ନା, ଇଦାଂ ଇନାକା ଆପେଂ ସମାନ୍‌ ଇଞ୍ଜ୍‌ୱାଦାଂ ମାନ୍‌ଚାପ୍‌ କି ?” ");
INSERT INTO peg_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","ଜିସୁ ଉତର୍‌ ହିତାନ୍‌, “ନାଙ୍ଗେଙ୍ଗ୍‌ ପୁଦା ଡୁଦ୍‌ୱାତାତ୍‌ନା,” ମାତର୍‌ ଆନ୍‌ ମାଞ୍ଜି ଆବାଂ ମାନି କିନାଙ୍ଗା, ଆରେ ଏପେଙ୍ଗ୍‌ ନାଙ୍ଗେଙ୍ଗ୍‌ ମାନିକିଦୁଦେରା । ");
INSERT INTO peg_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","ମାତର୍‌ ଆନ୍‌ ନିଜେ ଜାର୍‌ତିଂ ଜାଜ୍‌ମାଲ୍‌ ଦାସ୍‌ତେଂ କଙ୍ଗ୍‌; ମାତର୍‌ ଇ କାତା ଆନେଂ ଦାହ୍‌ନାଙ୍ଗା ଆରି ବିଚାର୍‌ କିଉଙ୍ଗା, ଏପେଙ୍ଗ୍‌ ଆରେ ରୱାନ୍‌ ମାନ୍‌କିନାନ୍‌ ହେୱାନ୍‌ ଇଞ୍ଜି ମାନାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","ହାତ୍‌ପା ହାତ୍‌ପା ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ଇଞ୍ଜ୍‌ନାଙ୍ଗା, ଜଦି ଇନେର୍‌ ନା ବଚନ୍‌ ପାଲି କିନାନ୍‌, ତା ଆତିସ୍‌ ହେୱାନ୍‌ ମୁଡ଼୍‌କେ ହାଉନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","ଜିହୁଦିର୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ଇଚାର୍‌, “ନଙ୍ଗ୍‌ ଆପେଂ ପୁନ୍‌ଚାପ୍‌ ଜେ, ହାତ୍‌ପା ନିଙ୍ଗେଙ୍ଗ୍‌ ପୁଦା ଡୁତ୍‌ତାତ୍‌ନା, ଅବ୍ରାହାମ୍‌ ଆରି ବେଣ୍‌ବାକ୍‌ଣାୟ୍‌କିନାକାର୍‌ ହାତାରେ, ଆରେ ଏନ୍‌ ମୁଡ଼୍‌କେ ହାଉୟି । ");
INSERT INTO peg_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","ଏନ୍‌ ଇନାକା ମା ଆବା ଅବ୍ରାହାମ୍‌ ତାଙ୍ଗ୍‌ ଗାଜା ? ହେୱାନ୍‌ ତ ହାତାନେ, ବେଣ୍‌ବାକ୍‌ଣାୟ୍‌କିନାକାନ୍‌ ପା ହାତାନେ, ଏନ୍‌ ଜାର୍‌ତିଂ ଇନେର୍‌ ଇଞ୍ଜି ଇନାୟା ?” ");
INSERT INTO peg_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","ଜିସୁ ଉତର୍‌ ହିତାନ୍‌, “ଆନ୍‌ ଜଦି ଜାର୍‌ତିଂ ପାଦ୍‌ କିତାଙ୍ଗ୍‌ମା, ଲାଗିଂ ନା ଜାଜ୍‌ମାଲ୍‌ ଇନାକା ଆକାୟ୍‌; ଇନେର୍‌ ନାଙ୍ଗ୍‌ ପାଦ୍‌ ପାୟା ଆନି କାଜିଂ ନା ଆବା ଇନେରିଂ ଏପେଙ୍ଗ୍‌ ମି ଇସ୍ୱର୍‌ ଇଞ୍ଜି ଇନାଦେରା; ");
INSERT INTO peg_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","ଏପେଙ୍ଗ୍‌ ଇନାୱାଡ଼ାଂ ତାଙ୍ଗେଙ୍ଗ୍‌ ପୁନୁଦେରା, ଆନ୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ପୁନାଙ୍ଗ୍‌ । ଆନ୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ପୁନୁଙ୍ଗ୍‌ ଇଞ୍ଜି ଜଦି ଇନାଙ୍ଗ୍‌, ମି ଲାକେ ଆନ୍‌ ପା ମିଚ୍‌ୱା ଆନାଙ୍ଗ୍‌, ମାତର୍‌ ହାତ୍‌ପା ଆନ୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ପୁନାଙ୍ଗ୍‌ ଆରି ତା ବଚନ୍‌ ପାଲି କିନାଙ୍ଗ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","ମିଦାଙ୍ଗ୍‌ ଆବା ଅବ୍ରାହାମ୍‌ ନା ୱାନାକା ହୁଡ଼୍‌ଦେଂ ଆଡ଼୍‌ଦାନାଂ ଇଞ୍ଜି ଆହା କିଜ଼ି ଅବ୍ରାହାମ୍‌ ୱାର୍‌ୟା ଆତାନ୍‌, ଆରେ ହେୱାନ୍‌ ହେଦାଂ ହୁଡ଼୍‌ଜି ୱାରି କିତାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","ହେବେ ଜିହୁଦିର୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ଇଚାର୍‌, “ନିଙ୍ଗ୍‌ ତ ନଙ୍ଗ୍‌ ପାତେକ୍‌ ପଚାସ୍‌ ବାର୍ହୁ ବୟ୍‌ସ୍‌ ଆୱାତାତ୍‌ନା, ଏନ୍‌ ଇନାକା ଅବ୍ରାହାମ୍‌ତି ହୁଡ଼୍‌ତାୟ୍‌ନା ?” ");
INSERT INTO peg_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","“ଜିସୁ ହେୱାରିଂ ଇଚାନ୍‌,” ହାତ୍‌ପା ହାତ୍‌ପା ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ଇଞ୍ଜ୍‌ନାଙ୍ଗା, “ଅବ୍ରାହାମ୍‌ ଜଲମ୍‌ ପୁର୍ବେତାଂ ଆନ୍‌ ମାନାଙ୍ଗ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","ହେବେ ହେୱାର୍‌ ତା ଜପି ଇଡ଼୍‌ଦେଂ କାଲ୍‌କୁ ପେସ୍ତାର୍, ମାତର୍‌ ଜିସୁ କାଲେ ମନ୍ଦିର୍‌ତାଙ୍ଗ୍‌ ହସି ହାଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","ଜିସୁ ହାନି ସମୁତ ର ଜଲମ୍‌ କାଣାଂ ହୁଡ଼୍‌ତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","ଆରେ, ତା ଚେଲାହିର୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ୱେନ୍‌ବାତାର୍‌, “ଏ ଗୁରୁ ଇନେର୍‌ ପାପ୍‌ କିତିଲେ ଇୱାନ୍‌ କାଣା ଆଜ଼ି ଜଲମ୍‌ ଆତାନ୍‌ ? ନିଜେ କି ଇୱାନ୍‌ ଆବା ଆୟା ପାପ୍‌ କାଜିଂ ?” ");
INSERT INTO peg_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","ଜିସୁ ଉତର୍‌ ହିତାନ୍‌, “ଇୱାନ୍‌ କି ଇୱାନ୍‌ ଆବା ଆୟା ପାପ୍‌ କିୱାତାର୍‌, ମାତର୍‌ ଇସ୍ୱର୍‌ ସାକ୍ତି କାମାୟ୍‌ ଇନେସ୍‌କି ଇୱାନ୍‌ ତାକେ ହପ୍‌ନାତ୍‌, ଇଦାଂ କାଜିଂ କାଣା ଆଜ଼ି ଜଲମ୍‌ ଆତାନ୍ନା । ");
INSERT INTO peg_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","ଦିନ୍‌ ମାନୁ ମାନୁ ନା ପକ୍‌ତାତାକାନ୍‌ କାମାୟ୍‌ କିନାକା ଦାଇତ୍‌; ଇମ୍‌ଣି ସମୁତ ଏପେଙ୍ଗ୍‌ ନାଣା ୱାନାତା ଇନେର୍‌ କାମାୟ୍‌ କିଦେଙ୍ଗ୍‌ ଆଡୁର୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","ଇ ପୁର୍ତିତ ମାନି ପାତେକ୍‌, ଆନ୍‌ ପୁର୍ତିନି ଅଜଡ଼୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","ଇଦାଂ ଇଞ୍ଜି ହେୱାନ୍‌ ଚିକ୍‌ଲାତ ଚୁପ୍‌ତାନ୍‌ ହେ ଏୱିଡ଼ିଂତାଂ ଚିକ୍‌ଲା କିତାନ୍‌, ଆରେ ତା ରି କାଣ୍‌କୁକାଂ ଚିକ୍‌ଲା କାସ୍‌ତାନ୍‌ ଆରି ତାଙ୍ଗେଙ୍ଗ୍‌ ଇଚାନ୍‌ ହାଲା, ");
INSERT INTO peg_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","“ସିଲହ ଅନୁବାଦ୍‌ କିତାନ୍‌, ଇଦାଂ ଅରତ୍‌ ପକ୍ୟାତାକା ବାନ୍ଦ୍‌ତ ନୁସ୍ୟାୟା ଆ । ହେବେ ହେୱାନ୍‌ ହସି ହାଲ୍‌ଜି ନୁସ୍ୟାୟା ଆତାନ୍‌ । ଆରି କାଣ୍‌କୁ ହୁଡ଼୍‌ଜି ହାଚାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","ଲାଗିଂ ହାଙ୍ଗ୍‌ଦାକାର୍‌, ଆରେ ଇମ୍‌ଣାକାର୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ଆଗେତାଂ ରୱାନ୍‌ ବିକାରି ଇଞ୍ଜି ହୁଡ଼୍‌ଜି ମାଚାର୍‌, ହେୱାର୍‌ ୱେନ୍‌ବାତାର୍‌, “ଇନେନ୍‌ କୁଚ୍‌ଚି ବିକ୍ୟା ଏନ୍‌ଚି ମାଚାନ୍‌, ଇୱାନ୍‌ ଇନାକା ହେୱାନ୍‌ ଆକାୟ୍‌ ?” ");
INSERT INTO peg_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","ଇନେ ଇନେର୍‌ ଇଚାର୍‌, “ଇୱାନ୍‌ ହେୱାନ୍‌, ଆରେ ଇନେ ଇନେର୍‌ ଇଚାର୍‌, ଆକାୟ୍‌, ଇୱାନ୍‌ ତା ଲାକେ ।” ମାତର୍‌ ହେୱାନ୍‌ ଇଚାନ୍‌, “ଆନ୍‌ ହେ ମାନାୟ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","“ହେବେ ହେୱାର୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ଇଚାର୍‌, ତା ଆତିସ୍‌ ନି କାଣ୍‌କୁ ଇନେସ୍‌ ହୁଡ଼୍‌ତାୟ୍‌ ?” ");
INSERT INTO peg_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","ହେୱାନ୍‌ ଉତର୍‌ ହିତାନ୍‌, “ଇନେରିଂ ଜିସୁ ଇଞ୍ଜି ଇନାର୍‌, ହେ ମାନାୟ୍‌ ଚାଟ୍‌କାୟ୍‌ କିଜ଼ି ନା ରି କାଣ୍‌କୁକାଂ କାସ୍‌ଦାତାନ୍‌, ଆରେ ନାଙ୍ଗେଙ୍ଗ୍‌ ଇନ୍‌ଚାନ୍‌, ସିଲହତ ହାଲ୍‌ଜି ନୁସ୍ୟାୟା; ଲାଗିଂ ଆନ୍‌ ହସି ହାଲ୍‌ଜି ନୁସ୍ୟାୟା ଆତାଙ୍ଗ୍‌ ଆରି କାଣ୍‌କୁ ହୁଡ଼୍‌ତାଙ୍ଗ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","“ହେୱାର୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ୱେନ୍‌ବାତାର୍‌,” ହେୱାନ୍‌ ଜେ ? ହେୱାନ୍‌ ଇଚାନ୍‌, “ଆନ୍‌ ପୁନୁଙ୍ଗ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","ଇନେନ୍‌ ଜଲମ୍‌ କାଣା ମାଚାନ୍‌, ହେୱାର୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ପାରୁସିର୍‌ ତାକେ ତାହିୱାତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","ଜିସୁ ଇମ୍‌ଣି ଦିନା ଚାଟ୍‌କାୟ୍‌ କିଜ଼ି ତା କାଣ୍‌କୁ ଉଜ୍‌ କିଜ଼ି ମାଚାନ୍‌, ହେ ଦିନା ଜମ୍‌ନିବାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","ଲାଗିଂ, ହେୱାନ୍‌ ଇନେସ୍‌ କାଣ୍‌କୁ ହୁଡ଼୍‌ତାନ୍‌, ଇଦାଂ ପାରୁସିର୍‌ ପା ତାଙ୍ଗେଙ୍ଗ୍‌ ଆରେ ରଗ ୱେନ୍‌ବେଦେଂ ଲାଗାତାର୍‌ । ହେବେ ହେୱାନ୍‌ ହେୱାରିଂ ଇଚାନ୍‌, “ହେୱାନ୍‌ ନା କାଣ୍‌କୁକାଂ ଚିକ୍‌ଲା କାସ୍‌ଦାତାନ୍‌, ପାଚେ ଆନ୍‌ ନୁସ୍ୟାୟା ଆତାଙ୍ଗ୍‌ ଆରି ହୁଡ଼୍‌ଦେଂ ଆଡ୍‌ନାଂ ।” ");
INSERT INTO peg_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","ତା ପାଚେ ପାରୁସିର୍‌ ପା ଇନେ ଇନେର୍‌ ଇଚାର୍‌, “ହେ ମାନାୟ୍‌ ଇସ୍ୱର୍‌ ତାକେ ୱାୱାତାନ୍ନା, ଇନାକିଦେଂକି ହେୱାନ୍‌ ଜମ୍‌ନିବାର୍‌ ପାଲି କିୱାତାନ୍‌ନା ।” ଆରେ, ଇନେ ଇନେର୍‌ ଇଚାର୍‌, “ପାପି ଲଗୁ ଇନେସ୍‌ ଇ ଲାକେ କାବାଆନି କାମାୟ୍‌ ସବୁ କିଦେଙ୍ଗ୍‌ ଆଡ୍‌ନାନ୍‌ ?” ଏଲେଙ୍ଗ୍‌ ବାବ୍ରେ ହେୱାର୍‌ ବିତ୍ରେ ଇନ୍‌ବା ଆତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","ଲାଗିଂ ହେୱାର୍‌ ଆରେ ରଗ ହେ କାଣା ଲଗାଂ ୱେନ୍‌ବାତାର୍‌, “ହେୱାନ୍‌ ଜେ ନି କାଣ୍‌କୁ ଉଜ୍‌ କିତ୍‌ତାନ୍‌, ଇବେ ଏନ୍‌ ତା ବିସ୍ରେ ଇନାକା ଇନାୟା ?” “ହେୱାନ୍‌ ଇଚାନ୍‌,” ହେୱାନ୍‌ ରୱାନ୍‌ ବେଣ୍‌ବାକ୍‌ଣାୟ୍‌କିନାକାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","ହେୱାନ୍‌ ଜେ କାଣା ମାଚାନ୍‌ ଆରେ କାଣ୍‌କୁ ହୁଡ଼୍‌ତାନ୍‌ନା, ହେ କାଣ୍‌କୁ ପାୟା ଆତି ଲକ୍‌ ଆବା ଆୟାଂ କୁକ୍‌ଚି ୱେନ୍‌ବିୱି ପାତେକ୍‌ ଜିହୁଦି ନେତାର୍‌ ତା ବିସ୍ରେ ଇଦାଂ ପାର୍ତି କିୱାତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","ହେୱାର୍‌ ହେୱାରିଂ ୱେନ୍‌ବାତାର୍‌, “ମି ଇମ୍‌ଣି କାଡ଼୍‌ଦେ କାଣା ଆଜ଼ି ଜଲମ୍‌ ଆଜ଼ି ମାଚାନ୍‌ ଇଞ୍ଜି ଇନାଦେରା, ଇୱାନ୍‌ ଇନାକା ମି ହେ କାଡ଼୍‌ଦେ ? ତା ଆତିସ୍‌ ହେୱାନ୍‌ ଇନେସ୍‌ ନଙ୍ଗ୍‌ ହୁଡ଼୍‌ଦେଂ ଆଡ୍‌ନାନା ?” ");
INSERT INTO peg_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","ହେବେ ତା ଆବା ଆୟା ଉତର୍‌ ହିତାର୍‌, “ଇୱାନ୍‌ ଜେ ମା ମାଜ଼ି ଆରି ଇୱାନ୍‌ ଜେ କାଣା ଆଜ଼ି ଜଲମ୍‌ ଆଜ଼ି ମାଚାନ୍‌, ଇଦାଂ ଆପେଂ ପୁନାପ୍‌; ");
INSERT INTO peg_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","ମାତର୍‌ ହେୱାନ୍‌ ଇନେସ୍‌ ନଙ୍ଗ୍‌ ହୁଡ଼୍‌ନାନା, ହେଦାଂ ପୁନୁଦେରା, କି ଇନେର୍‌ ତା କାଣ୍‌କୁ ଉଜ୍‌ କିତାନ୍‌, ହେଦାଂ ପା ଆପେଂ ପୁନୁପା; ତାଙ୍ଗେଙ୍ଗ୍‌ ୱେନ୍‌ବାଟ୍‌, ହେୱାନ୍‌ ତ ବେଣ୍ଡିୟା, ହେୱାନ୍‌ ଜାର୍‌ କାତା ନିଜେ ଇନାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","ତା ଆବା ଆୟା ଜିହୁଦିରିଂ ପାଣ୍ଡ୍ରା ଆନି କାଜିଂ ଇ ୱିଜ଼ୁ କାତା ଇଚାର୍‌, ଇନାକିଦେଂକି ଜଦି ଇନେର୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ କ୍ରିସ୍ଟ ଇଞ୍ଜି ପାର୍ତି କିନାନ୍‌, ତା ଆତିସ୍‌ ହେୱାନ୍‌ କୁଟୁମ୍‌ ପାଗ୍ରି କିୟାଆନାତ୍‌ ଇଞ୍ଜି ଇବେଣ୍ଡାଂ ଜିହୁଦିର୍‌ ର କାତା କିଜ଼ି ମାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","ହେଦାଂ କାଜିଂ, ତା ଆବା ଆୟା ଇଚାର୍‌, “ହେୱାନ୍‌ ବେଣ୍ଡିୟା, ତାଙ୍ଗେଙ୍ଗ୍‌ ୱେନ୍‌ବାଟ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","ହେବେ ଆଗ୍‌ଦ କାଣା ମାଚି ମାନାୟ୍‌ତିଂ ହେୱାର୍‌ ରିହା କୁକ୍‌ଚି ଇଚାର୍‌, ଇସ୍ୱର୍‌ତିଂ ପାଦ୍‌ ହିୟାଟ୍‌, “ହେ ମାନାୟ୍‌ ଜେ ପାପି, ଇଦାଂ ଆପେଂ ପୁନାପ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","“ହେବେ ହେୱାନ୍‌ ଉତର୍‌ ହିତାନ୍‌,” ହେୱାନ୍‌ ପାପି କି ଆକାୟ୍‌, “ଆନ୍‌ ହେଦାଂ ପୁନୁଙ୍ଗ୍‌; ଆନ୍‌ ର ବିସ୍ରେ ପୁନାଙ୍ଗ୍‌, ଆନ୍‌ କାଣା ମାଚାଙ୍ଗ୍‌, ନଙ୍ଗ୍‌ ହୁଡ଼୍‌ଦେଂ ଆଡ୍‌ନାଂ ।” ");
INSERT INTO peg_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","“ଲାଗିଂ ହେୱାର୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ଇଚାର୍‌, ହେୱାନ୍‌ ନିଙ୍ଗେଙ୍ଗ୍‌ ଇନାକା କିତ୍‌ତାନ୍‌ ? ହେୱାନ୍‌ ଇନେସ୍‌ କିଜ଼ି ନି କାଣ୍‌କୁ ଉଜ୍‌ କିତ୍‌ତାନ୍‌ ?” ");
INSERT INTO peg_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","“ହେୱାନ୍‌ ହେୱାରିଂ ଉତର୍‌ ହିତାର୍‌,” ଆନ୍‌ ୱେଚ୍‌ଚାତାଂ, “ଆରେ ଏପେଙ୍ଗ୍‌ ୱେନ୍‌ୱାତାଦେର୍‌; ଇନାକିଦେଂ ଆରେ ରଗ ୱେଞ୍ଜେଙ୍ଗ୍‌ ମାନ୍‌କିନାଦେରା ? ଏପେଙ୍ଗ୍‌ ପା ଇନାକା ତା ଚେଲାହିର୍‌ ଆଦେଂ ମାନ୍‌ କିନାଦେରା ?” ");
INSERT INTO peg_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","ହେବେ ହେୱାର୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ବାଗ୍‌ଇଡ଼ିଜି ଇଚାର୍‌, “ଏନ୍‌ ହେୱାନ୍ତି ଚେଲା, ମାତର୍‌ ଆପେଂ ମସା ଚେଲାକାପ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","ଆପେଂ ପୁନାପ୍‌ ଜେ ଇସ୍ୱର୍‌ ମସାଙ୍ଗ୍‌ କାତା ଇଚାନ୍ନା, ମାତର୍‌ ଇ ମାନାୟ୍‌ ଇମେଣ୍ଡାଂ ୱାତାନ୍‌ନା, ହେଦାଂ ପା ଆପେଂ ପୁନୁପ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","ହେ ମାନାୟ୍‌ ହେୱାରିଂ ଉତର୍‌ ହିତାନ୍‌, “ହେୱାନ୍‌ ନା କାଣ୍‌କୁ ଉଜ୍‌ କିତ୍‌ତାନ୍‌, ଆରେ ହେୱାନ୍‌ ଇମେଣ୍ଡାଂ ୱାତାନ୍ନା, ହେଦାଂ ଏପେଙ୍ଗ୍‌ ପୁନୁଦେର୍‌, ଇଦାଂ ତ କାବାଆନି କାତା । ");
INSERT INTO peg_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","ଇସ୍ୱର୍‌ ଜେ ପାପିର୍‌ କାତା ୱେନୁନ୍, ଇଦାଂ ଆପେଂ ପୁନାପ୍‌, ମାତର୍‌ ଜଦି ଇନେର୍‌ ଇସ୍ୱର୍‌ ହେବା କିନାକାନ୍‌ ଆଜ଼ି ତା ଇଚା ମାନି କିନାନ୍‌, ତା ଆତିସ୍‌ ହେୱାନ୍‌ ତା କାତା ୱେନାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","ଆରମ୍‌ ସମୁତାଂ ଇନେନ୍‌ ଜଲମ୍‌ କାଣା କାଣ୍‌କୁ ଉଜ୍‌ କିଜ଼ି ମାଚାନ୍‌, ଇଦାଂ ତ ଇନାୱାଡ଼ାଂ ପା ୱେନ୍ୟା ଆୱାଦାଂ ମାଚାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","ଇୱାନ୍‌ ମାନାୟ୍‌ ଇସ୍ୱର୍‌ ତାକେଣ୍ଡାଂ ୱାୱାଦାଙ୍ଗ୍‌ ମାଚିସ୍‌ ଲାଗିଂ ଇ କାମାୟ୍‌ କିଦେଙ୍ଗ୍‌ ଆଡ୍‌ୱାତାନ୍‌ମା ।” ");
INSERT INTO peg_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","ହେୱାର୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ଉତର୍‌ ହିତାର୍‌, “ଏନ୍‌ ତ ନିଜେ ପାପ୍‌ତ ଜଲମ୍‌ ଆତାୟ୍‌, ଆରେ ପାପ୍‌ତ ଗାଜା ଆତାୟ୍‌ ଏନ୍‌ ମାଙ୍ଗେଙ୍ଗ୍‌ ହିକ୍ୟା ହିଦ୍‌ନାୟା ?” ହେବେ ହେୱାର୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ବାରି କିତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","ହେୱାର୍‌ ଜେ ତାଙ୍ଗେଙ୍ଗ୍‌ ଗୁଡି ଇଞ୍ଜାଙ୍ଗ୍‌ ବାରି କିତାର୍‌ ଇଞ୍ଜି, ଜିସୁ ଇଦାଂ ୱେନ୍‌ଞ୍ଜି ତାଙ୍ଗେଙ୍ଗ୍‌ ବେଟା ଆଜ଼ି ଇଚାନ୍‌, “ଏନ୍‌ ଇନାକା ମାନାୟ୍‌ ମାଜ଼ିତାକେଣ୍ଡାଙ୍ଗ୍‌ ପାର୍ତି କିନାୟା ?” ");
INSERT INTO peg_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","ହେୱାନ୍‌ ଉତର୍‌ ହିତାନ୍‌, “ଏ ମାପ୍ରୁ, ହେୱାନ୍‌ ଇନେନ୍‌ ୱେଚ୍‌ଚା, ଇନେସ୍‌ ଆନ୍‌ ତା ତାକେ ପାର୍ତି କିନାଙ୍ଗ୍‌ ?” ");
INSERT INTO peg_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","ଜିସୁ ତାଙ୍ଗେଙ୍ଗ୍‌ ଇଚାନ୍‌, “ଏନ୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ହୁଡ଼୍‌ନାୟା, ଆରେ ଇନେନ୍‌ ନି ଲାହାଙ୍ଗ୍‌ ବେଣ୍‌ ଇନାନ୍ନା, ଇୱାନ୍‌ ହେୱାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","“ହେବେ ହେୱାନ୍‌ ଇଚାନ୍‌,” ମାପ୍ରୁ ଆନ୍‌ ପାର୍ତି କିନାଙ୍ଗା; ଆରେ, ହେୱାନ୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ଜୱାର୍‌ କିତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","ଆରେ ଜିସୁ ଇଚାନ୍‌, ହୁଡ଼୍‌ୱି “ମାନାୟାର୍‌ ଇନେସ୍‌ ହୁଡ଼୍‌ନାର୍‌ ଆରି ହୁଡ଼୍‌ନି ମାନାୟାର୍‌ ଇନେସ୍‌କି ହୁଡ଼ୁର୍‌, ଇ ବିଚାର୍‌ କାଜିଂ ଆନ୍‌ ପୁର୍ତିତ ଜଗତ୍‌ତ ୱାତାଙ୍ଗ୍‌ନା ।” ");
INSERT INTO peg_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","ପାରୁସିର୍‌ ବିତ୍ରେ ଇମ୍‌ଣାକାର୍‌ ତା ଲାହାଙ୍ଗ୍‌ ମାଚାର୍‌, “ହେୱାର୍‌ ଇଦାଂ ୱେନ୍‌ଞ୍ଜି ତାଙ୍ଗେଙ୍ଗ୍‌ ଇଚାର୍‌, ଆପେଂ ପା ଇନାକା କାଣା ?” ");
INSERT INTO peg_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","ଜିସୁ ହେୱାରିଂ ଇଚାନ୍‌, ଜଦି “କାଣା ଆଜ଼ି ମାଚିସ୍‌, ତା ଆତିସ୍‌ ଏପେଙ୍ଗ୍‌ ପାପ୍‌ ଆତାତ୍ମା । ମାତର୍‌ ଆପେଂ ହୁଡ଼୍‌ନାପା, ଇଦାଂ ନଙ୍ଗ୍‌ ଇନାଦେରା; ଏପେଙ୍ଗ୍‌ ପାପ୍‌ତ ମାନାଦେର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","ହାତ୍‌ପା ହାତ୍‌ପା, “ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ଇଞ୍ଜ୍‌ନାଙ୍ଗା, ଇନେର୍‌ ଦୁୱେର୍‌ତିଂ ମେଣ୍ଡାହାଡ଼ା ତାକେ ହଣ୍‌ଗିୱିତିସ୍, ମତର୍‌ ବିନେ ଇମ୍‌ଣି ହାଜ଼ି ଦୁମ୍‌ଜି ହଣାନ୍‌, ହେୱାନ୍‌ ଚର୍‌ ଆରି ଡାକୁ; ");
INSERT INTO peg_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","ଇନେନ୍‌ ଦୁୱେର୍‌ତିଂ ହଣାନ୍‌, ହେୱାନ୍‌ ମେଣ୍ଡାଙ୍ଗ୍‌ନି ଗଡ଼ିୟା । ");
INSERT INTO peg_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","ହଲ୍ୟାହି ତା କାଜିଂ ଦୁୱେର୍‌ ଜେସି ହିନାନ୍‌, ପାଚେ ମେଣ୍ଡାଂ ତା କାଟ୍‌ ୱେନ୍‌ଞ୍ଜି, ଆରେ ହେୱାନ୍‌ ତା ମେଣ୍ଡାକାଂ ତର୍‌ ଆଜ଼ି କୁକ୍‌ଚି ବାର୍ତ ହପ୍‌ଚି ତାଇ ୱାନାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","ହେୱାନ୍‌ ତା ମେଣ୍ଡାଂ ୱିଜ଼ୁ ହପ୍‌ଚି ହେୱାକାଂ ଆଗେ ଆଗେ ମେଣ୍ଡା ଗଡ଼ିୟା ତାଙ୍ଗ୍‌ନାନ୍‌ ଆରି ମେଣ୍ଡାଂ ତା ପାଚେ ପାଚେ ତାଙ୍ଗ୍‌ନିକ୍‌, ଇନାକିଦେଂକି ହେୱାଙ୍ଗ୍‌ ତା କାଟ୍‌ ପୁନିକ୍‌; ");
INSERT INTO peg_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","ମାତର୍‌ ହେୱାଙ୍ଗ୍‌ ଚିନ୍‌ହିଲ୍‌ୱାକାର୍‌ ପାଚେ ପାଚେ ଇନାୱାଡ଼ାଂ ପା ହାଲୁକ୍‌, ମତର୍‌ ତା ଲାଗାଂତିଂ ହନ୍‌ଚି ହାନିକ୍‌, ଇନାକିଦେଂକି ହେୱାଙ୍ଗ୍‌ ଚିନ୍‌ହିଲ୍‌ୱାକାର୍‌ କାଟ୍‌ ଆଣ୍‌ଗା ଆଉକ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","ଜିସୁ ହେୱାରିଂ ଇ ଉତର୍‌ମୁଡ଼୍‌ ଇଚାନ୍‌, ମାତର୍‌ ହେୱାନ୍‌ ହେୱାରିଂ ଇନା ଇନାକା ଇଞ୍ଜି ମାଚାର୍‌, ହେ ସବୁ ଇନାକା ଇଞ୍ଜି ହେୱାର୍‌ ବୁଜା ଆୱାତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","ଲାଗିଂ ଜିସୁ ଆରେ ରଗ ଇଚାନ୍‌, “ହାତ୍‌ପା ହାତ୍‌ପା ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ଇଞ୍ଜ୍‌ନାଙ୍ଗା, ଆନ୍‌ ମେଣ୍ଡାଂ ଦୁୱେର୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","ଇମ୍‌ଣାକାର୍‌ ନା ଆଗେ ୱାନାରା, ହେୱାର୍‌ ୱିଜ଼ାର୍‌ ଚର୍କୁ ଆରି ଡାକୁର୍‌, ମାତର୍‌ ମେଣ୍ଡାଂ ୱିଜ଼ୁ ହେୱାର୍‌ କାତା ୱେନୁକ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","ନା ଦୁୱେର୍‌, ଜଦି ଇନେର୍‌ ନାଙ୍ଗ୍‌ ହିଜ଼ି ହଣାର୍‌, ତା ଆତିସ୍‌ ହେୱାନ୍‌ ରାକ୍ୟା ପାୟା ଆନାନ୍‌ ଆରି ବିତ୍ରେ ୱାଜ଼ି ଆରି ବାର୍ତ ହାଲ୍‌ଜି ଚାରା ଗାଟା ଆନାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","ଚର୍‌ କେବଲ୍‌ ୱାନାନ୍‌ ଚର୍‌ କିଦେଙ୍ଗ୍‌, ଅସ୍ତେଙ୍ଗ୍‌ ଆରି ନସ୍ଟ କିନି କାଜିଂ; ହେୱାର୍‌ ଇନେସ୍‌କି ଜିବୁନ୍‌ ପାୟା ଆନାର୍‌ ଆରି ବେସି ପାୟା ଆନାର୍‌, ଇଦାଂ କାଜିଂ ଆନ୍‌ ୱାତାଙ୍ଗ୍‌ନା ।” ");
INSERT INTO peg_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“ଆନ୍‌ ହାର୍ଦି ମେଣ୍ଡା ଗଡ଼ିୟା ଆନାଙ୍ଗ୍‌; ମେଣ୍ଡାଂ କାଜିଂ ଆନ୍‌ ଜିବୁନ୍‌ ହିନାଙ୍ଗ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","ଇନେନ୍‌ ମେଣ୍ଡା ଗଡ଼ିୟା ଆକାୟ୍‌, ମତର୍‌ କାମ୍‌ଲିୟା, ମେଣ୍ଡାଂ ଇମ୍‌ଣିକିଙ୍ଗ୍‌ ନିଜାର୍‌ତି ଆକାୟ୍‌, ହେୱାନ୍‌ ହୁଣ୍ଡେର୍‌ବୁର୍କା ୱାନାକା ହୁଡ଼୍‌ଜି ମେଣ୍ଡାକାଂ ପିସ୍ତି ହନ୍‌ନାନ୍‌, ଆରେ ହୁଣ୍ଡାର୍‌ ବୁର୍କା ହେୱାକାଂ ଆସ୍ତି ଚିର୍‌ବିର୍‌ କିନିକ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","ଆଦି ଅଜ଼ି ମେଣ୍ଡାଂ କାଜିଂ ମାନାନ୍‌ ହେୱାନ୍‌ ହାନାନ୍‌, ଇନାକିଦେଂକି ହେୱାନ୍‌ ରୱାନ୍‌ କାମ୍‌ଲିୟା ମତର୍‌ ମେଣ୍ଡାଂ କାଜିଂ ଚିନ୍ତା କିଉନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","ଆନ୍‌ ହାର୍ଦି ମେଣ୍ଡା ଗଡ଼ିୟା । ଆବା ଇନେସ୍‌କି ନାଙ୍ଗେଙ୍ଗ୍‌ ପୁଞ୍ଜ୍‌ନାନ୍‌ ଆରି ଆନ୍‌ ଆବାଂ ପୁନାଙ୍ଗ୍‌, ");
INSERT INTO peg_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","ଆନ୍‌ ହେ ଲାକେ ପୁନାଙ୍ଗ୍‌ ଆନ୍‌ ନା ଜାର୍‌ ମେଣ୍ଡାକାଂ ପୁନାଙ୍ଗ୍‌, ଆରେ ହେୱାନ୍‌ ନା ଜାର୍‌ତି ମେଣ୍ଡାଂ ନାଙ୍ଗେଙ୍ଗ୍‌ ପୁଞ୍ଜ୍‌ନିକ୍‌, ଆରେ ମେଣ୍ଡାଂ କାଜିଂ ଆନ୍‌ ନା ଜିବୁନ୍‌ ହିଦେଂ ରେଡି । ");
INSERT INTO peg_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","ଇମ୍‌ଣି ମେଣ୍ଡାଂ ଇ ମେଣ୍ଡାହାଡ଼ାତ ଆକାୟ୍‌, ନା ଏଲେଙ୍ଗ୍‌ ଆଲ୍‌ଗା ମେଣ୍ଡାଂ ମାନିକ୍‌, ହେୱାକାଂ ପା ନାଙ୍ଗ୍‌ ତାହିୱାଦେଂ ଆନାତ୍‌, ଆରେ ହେୱାଙ୍ଗ୍‌ ନା କାଟ୍‌ ୱେଞ୍ଜ୍‌ନିକ୍‌; ହେବେ ର ଦାଡ଼୍‌ ଆରି ର ମାନ୍ଦା ଆନିକ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“ଆନ୍‌ ନା ଜିବୁନ୍‌ ଦାନ୍‌ କିନାଙ୍ଗ୍‌ ମାନ୍‌ କିନାଙ୍ଗା ଆବା ନାଙ୍ଗେଙ୍ଗ୍‌ ଜିଉନନାନ୍, ଆରେ ଆନ୍‌ ନା ଜିବୁନ୍‌ ଆରେ ରଗ ମାନିକିନି କାଜିଂ ହେଦାଂ ଦାନ୍‌ କିତ୍‌ତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","ଇନେର୍‌ ନା ତାକେଣ୍ଡାଂ ହେଦାଂ ଅଦେଂ ଆଡୁର୍‌, ମତର୍‌ ଆନ୍‌ ନିଜେ ହେଦାଂ ଦାନ୍‌ କିନାଙ୍ଗ୍‌ । ହେଦାଂ ଦାନ୍‌ କିଦେଙ୍ଗ୍‌ ନା ଆଦିକାର୍‌ ମାନାତ୍‌ ଆରି ହେଦାଂ ଆରେ ରଗ ମାନି କିଦେଙ୍ଗ୍‌ ନା ଆଦିକାର୍‌ ମାନାତ୍‌ । ଆନ୍‌ ମାଞ୍ଜି ଆବାତାଂ ଇ ବଲ୍‌ ପାୟା ଆତାଙ୍ଗ୍‌ନା ।” ");
INSERT INTO peg_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","ଇ ୱିଜ଼ୁ ବେଣ୍‌ କାଜିଂ ଜିହୁଦିର୍‌ ବିତ୍ରେ ଆରେ ରଗ ପାଗ୍ରି କିତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","ହେୱାର୍‌ ବିତ୍ରେ ହେନି ଇଞ୍ଜେଙ୍ଗ୍‌ ଲାଗାତାର୍‌, “ତାଙ୍ଗେଙ୍ଗ୍‌ ପୁଦା ଡୁତାତ୍‌ନା, ହେୱାନ୍‌ ପାଗ୍‌ଲା, ଇନାକିଦେଂ ତା କାତା ୱେନାଦେରା ?” ");
INSERT INTO peg_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","ବିନେନିକାର୍‌ ଇଚାର୍‌, “ଇ ୱିଜ଼ୁ କାତା ତ ପୁଦା ଡୁୟାଆତି ମାନାୟ୍‌ତିଂ ଆକାୟ୍‌; ପୁଦା ଇନାକା କାଣାଂ କାଣ୍‌ଙ୍ଗା ଉଜ୍‌ କିଦେଙ୍ଗ୍‌ ଆଡ୍‌ନାନ୍‌ ?” ");
INSERT INTO peg_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","ହେ ସମୁ ପିନିମାସ୍‌ ମାଚାତ୍‌, ହେୱାଡ଼ାଂ ଜିରୁସାଲମ୍‌ତ ମନ୍ଦିର୍‌ ରଚ୍‌ନି ପାର୍ବୁ ଆତାତ୍‌; ");
INSERT INTO peg_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","ଆରେ ଜିସୁ ମନ୍ଦିର୍‌ତ ସଲମନ୍‌ ମଣ୍ଡମ୍‌ତ ବୁଲାଆଜ଼ି ମାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","ହେବେ ଜିହୁଦିର୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ଚାରିବେଣ୍‌ତାଂ ବେଡ଼ିକିଜ଼ି ୱାସ୍କିନି କାତା ୱେନ୍‌ବେଦେଂ ଲାଗାତାର୍‌, “ଆରେ ଏଚେକାଡ଼୍‌ଦ ଦିନ୍‌ ମାଙ୍ଗେଙ୍ଗ୍‌ ହାବଡ଼୍‌ତ ଇଡ଼୍‌ଦାନାୟ୍‌ ? ଜଦି ଏନ୍‌ କ୍ରିସ୍ଟ, ତା ଆତିସ୍‌ ମାଙ୍ଗେଙ୍ଗ୍‌ ହାର୍‌ କିଜ଼ି ୱେଚ୍‌ଚା ।” ");
INSERT INTO peg_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","ଜିସୁ ହେୱାରିଂ ଉତର୍‌ ହିତାନ୍‌, ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ଇଞ୍ଜ୍‌ନାଙ୍ଗା, ମାତର୍‌ ଏପେଙ୍ଗ୍‌ ପାର୍ତି କିଉଦେରା; ମା ଆବା ତର୍‌ଦାଂ ଆଦିକାର୍‌ ପାୟା ଆତାଙ୍ଗ୍‌ନା ଆନ୍‌ ଇମ୍‌ଣି ଇମ୍‌ଣି କାମାୟ୍‌ କିନାଙ୍ଗା, ହେ ସବୁ ନା ବିସ୍ରେ ସାକି ହିନାଙ୍ଗା; ");
INSERT INTO peg_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","ମାତର୍‌ ଏପେଙ୍ଗ୍‌ ପାର୍ତି କିଉଦେରା, ଇନାକିଦେଂକି ଏପେଙ୍ଗ୍‌ ନା ମେଣ୍ଡାଂ ଆକାୟ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","ନା ମେଣ୍ଡାଂ ୱିଜ଼ୁ ନା କାଟ୍‌ ୱେନିକ୍‌ ଆରି ଆନ୍‌ ହେୱାକାଂ ପୁନାଙ୍ଗ୍‌, ଆରେ ହେୱାଙ୍ଗ୍‌ ନା ପାଚେ ପାଚେ ୱାନିକ୍‌, ");
INSERT INTO peg_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","ଆରେ ଆନ୍‌ ହେୱାକାଂ ୱିଜ଼୍‌ୱି ଜିବୁନ୍‌ ହିନାଙ୍ଗ୍‌, ଆରେ ହେୱାଙ୍ଗ୍‌ ଇନାୱାଡ଼ାଂ ପା ବୁଡାଆଉକ୍‌, ଆରେ ଇନେର୍‌ ନା କେଇତାଂ ହେୱାକାଂ କ୍ଡିସ୍ତି ଅଦେଂ ଆଡୁର୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","ମା ଆବା ନାଙ୍ଗେଙ୍ଗ୍‌ ଇନାକା ହିତ୍‌ନ୍ନା, ହେଦାଂ ସବୁ ତାକେଣ୍ଡାଂ ବେସି ଦାମ୍‌, ଆରେ ଆବା କେଇଦାଂ ଇନେର୍‌ ହେଦାଂ କ୍ଡିସ୍ତି ଅଦେଂ ଆଡୁର୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","ଆବା ଆରି ଆନ୍‌ ଏକ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","ଇ କାତା ୱେନ୍‌ଞ୍ଜି ଆରେ ଜିହୁଦିର୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ଇଡ଼୍‌ଦେଂ କାଜିଂ ଆରେ ରଗ କାଲ୍‌କୁ ପେସ୍ତାର୍ । ");
INSERT INTO peg_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","ଜିସୁ ହେୱାରିଂ ଉତର୍‌ ହିତାନ୍‌, “ଆନ୍‌ ଆବା ତାକେଣ୍ଡାଂ ବେସି ହାର୍ଦି କାମାୟ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ଚଚ୍‌ଚାତାଂନା; ହେ ସବୁ କାମାୟ୍‌ ବିତ୍ରେ ଇମ୍‌ଣି କାମାୟ୍‌ କାଜିଂ ନାଙ୍ଗ୍‌ ଅସ୍ତେଦେଂ କାଲ୍‌କୁ ଡେକ୍‌ନାଦେରା ?” ");
INSERT INTO peg_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","ଜିହୁଦିର୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ଉତର୍‌ ହିତାର୍‌, “ହାର୍ଦି କାମାୟ୍‌ କାଜିଂ ଆପେଂ ନିଙ୍ଗେଙ୍ଗ୍‌ କାଲ୍‌ ଇଡ଼୍‌ଦୁପା, ମାତର୍‌ ଇସ୍ୱର୍‌ତିଂ ନିନ୍ଦା କାଜିଂ, ଆରେ ଏନ୍‌ ମାନାୟ୍‌ ଆଜ଼ି ଜାର୍‌ତିଂ ଇସ୍ୱର୍‌ ବଲାୟ୍‌ଆନାୟା ।” ");
INSERT INTO peg_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","ଜିସୁ ହେୱାରିଂ ଉତର୍‌ ହିତାନ୍‌, “ମି ମସାତି ବିଦିତ ଇଦାଂ ଇନାକା ଲେକା ହିଲୁତ୍‌, ଇସ୍ୱର୍‌ ଇଚାନ୍‌, ଏପେଙ୍ଗ୍‌ ଇସ୍ୱର୍‌ ? ");
INSERT INTO peg_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","ଆପେଂ ପୁନାପ୍‌ ସାସ୍ତର୍‌ ବଚନ୍‌ ଜୁଗ୍‌ ଜୁଗ୍‌ ହାତ୍‌ପା । ଇସ୍ୱର୍‌ତି ବେରଣ୍‌ ଇମ୍‌ଣାକାର୍‌ ତାକେ ହତାତ୍‌ନା, ହେୱାରିଂ ଇବେ ଇସ୍ୱର୍‌ ଇଚାନ୍ନା । ");
INSERT INTO peg_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","ତା ଆତିସ୍‌ ଇନେରିଂ ଇସ୍ୱର୍‌ ପୁଇପୁୟା କିଜ଼ି ପୁର୍ତିତ ପକ୍‌ତାନ୍‌, ତାଙ୍ଗେଙ୍ଗ୍‌ ଇନାକା ଏପେଙ୍ଗ୍, ଆନ୍‌ ଇସ୍ୱର୍‌ତି ମାଜ଼ି, ଇଦାଂ ଆନ୍‌ ଇଞ୍ଚିଲେ, ଏନ୍‌ ଇସ୍ୱର୍‌ତିଂ ନିନ୍ଦା କିନାୟା ଇଞ୍ଜି ଇନାଦେରା ? ");
INSERT INTO peg_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","ଜଦି ଆନ୍‌ ମାଞ୍ଜି ଆବାତି କାମାୟ୍‌ ସବୁ କିୱିତିସ୍‌, ତାଆତିସ୍‌ ନାଙ୍ଗେଙ୍ଗ୍‌ ପାର୍ତି କିଦ୍‌ମାଟ୍‌; ");
INSERT INTO peg_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","ମାତର୍‌ ଜଦି ଆନ୍‌ ତା ଇଚା ମାନି କିନାଙ୍ଗ୍‌, ତା ଆତିସ୍‌ ପାର୍ତି କିୱିତିସ୍‌ ପା, ନା କାମାୟ୍‌ ହୁଡ଼୍‌ଜି ପାର୍ତି କିୟାଟ୍‌ ଲାଗିଂ ଏପେଙ୍ଗ୍‌ ହାତ୍‌ପା ବାବ୍ରେ ପୁଞ୍ଜେଙ୍ଗ୍‌ ଆଡ୍‌ନାଦେର୍‌, ନା ଆବା ଇସ୍ୱର୍‌ ନା ତାକେ ମାନାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","ହେବେଣ୍ଡାଂ ହେୱାର୍‌ ତାଙ୍ଗ୍‌ ଆସ୍ତେଙ୍ଗ୍‌ ଇଞ୍ଜି ଆରେ ରଗ ସେସ୍ଟା କିଦେଙ୍ଗ୍‌ ଲାଗାତାର୍‌, ମାତର୍‌ ହେୱାନ୍‌ ହେୱାର୍‌ କେଇଦ ଆହ୍‌ୟା ଆୱାଦାଂ ହସି ହାଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","ଇଦାଂ ପାଚେ ଇସ୍ୱର୍‌ ଆରେ ରଗ ଜର୍ଦନ୍‌ନି ଆନ୍‌ଟି ପାଡ଼୍‌କା ହାଲ୍‌ଜି, ଜହନ୍‌ ଇମ୍‌ଣି ବାହାତ ହିଗ୍‌ଦ ବାପ୍ତିସିମ୍‌ ହିିଜ଼ି ମାଚାନ୍‌, ହେ ବାହାତ ହାଲ୍‌ଜି ହେବେ ମାନ୍‌ଗାତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","ଆରେ, ହେନି ତା ତାକେ ୱାଜ଼ି ଇଚାର୍‌, “ଜହନ୍‌ ହିନା ଇନାକାପା କାବାଆନି କାମାୟ୍‌ କିୱାତାନ୍‌,” ମାତର୍‌ ଇ ମୁଣିକା ବିସ୍ରେ ଜହନ୍‌ ଜେ ୱିଜ଼ୁ କାତା ଇଚାନ୍‌, “ହେଦାଂ ସବୁ ହାତ୍‌ପା ।” ");
INSERT INTO peg_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","ଆରେ, ହେ ବାହାତ ହେନି ମାନାୟାର୍‌ ତା ତାକେ ପାର୍ତି କିତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","ବେତ୍‌ନିୟା ନିକାନ୍‌ ଲାଜାର୍‌ ତର୍‌ଦାକାନ୍‌ ରୱାନ୍‌ ମାନାୟ୍‌ ବେମାର୍‌ ମାଚାନ୍‌; ମରିୟମ୍‌ ଆରି ତା ତଣ୍‌ଦେହି ମାର୍ତା ହେ ନାସ୍ତ ମାଚିକ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","ଇ ମରିୟମ୍‌ ମାପ୍ରୁଙ୍ଗ୍‌ କାଲ୍‌ ଜପି ବାସ୍‌ନା ଚିକାଣ୍‌ତାଂ ନେନ୍‌ଦି ତା ତେମୁଲ୍‌ତାଂ ତା ପାନା ନୁଜ଼୍‌ଜି ମାଚାତ୍‌ ତା ଟଣ୍ଡାହି ଲାଜାର୍‌ ବେମାର୍‌ ମାଚାନ୍‌, ");
INSERT INTO peg_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","ଲାଗିଂ ହେ ତଣ୍‌ଦେକ୍‌ ତା ତାକେ କାବୁର୍‌ ପକ୍ତିକ୍‌, “ମାପ୍ରୁ, ହୁଡ଼ା, ଇନେରିଂ ଏନ୍‌ ୱାରି କିନାୟା, ହେୱାନ୍‌ ବେମାର୍‍ତ ମାନାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","ଇ କାବୁର୍‌ ଜିସୁ ୱେନ୍‌ଞ୍ଜି ଇଚାନ୍‌, “ଇ ରଗ୍‌ତ ଲାଜାର୍‌ ହାଉନ୍‌, ମାତର୍‌ ମାପ୍ରୁତି ଜାଜ୍‌ମାଲ୍‌ କାଜିଂ, ଇନେସ୍‌କି ଇ ଲାକେ ଇସ୍ୱର୍ତି ମାଜ଼ି ଜାଜ୍‌ମାଲ୍‌ ପାୟା ଆନାର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","ଜିସୁ ମାର୍ତା, ମରିୟମ୍‌ ତା ତଣ୍‌ଦେହି ଆରେ ଲାଜାର୍‌ତିଂ ଜିଉ ନଜ଼ି ମାଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","ଆତିସ୍‌ପା, ଲାଜାର୍‌ ବେମାର୍‍ତ ମାନାନ୍‌ ଇଞ୍ଜି ଏଚେକାଡ଼୍‌ଦ ହେୱାନ୍‌ ୱେଚାନ୍, ହେ ପାଦ୍‌ନା ହେୱାନ୍‌ ଇମ୍‌ଣି ବାହାତ ମାଚାନ୍‌, ହେ ବାହାତ ଆରେ ରି ଦିନ୍‌ ମାଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","ତା ପାଚେ ଜିସୁ ଚେଲାରିଂ ଇଚାନ୍‌, “ଜାଡ ଆସେଙ୍ଗ୍‌ ଆରେ ରଗ ଜିହୁଦା ଦେସ୍‌ତ ମାସ୍‌ଦି ହାନାସ୍‍ ।” ");
INSERT INTO peg_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","ଚେଲାର୍‌ ଜିସୁଙ୍ଗ୍‌ ଇଚାର୍‌, “ଏ ଗୁରୁ,” ଜିହୁଦିର୍‌ ନିଙ୍ଗେଙ୍ଗ୍‌ କେତ୍‌ଦିନ୍‌ ଆଗେ ଇଡ଼୍‌କାଦେଂ ସେସ୍ଟା କିଜ଼ି ମାନ୍‍ଚାର୍, “ଆରେ ଏନ୍‌ ଆରି ରଗ ହେବେ ହାନାୟା ?” ");
INSERT INTO peg_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","ଜିସୁ ଉତର୍‌ ହିତାନ୍‌, “ୱେଡ଼ାଲିଂ ଇନାକା ବାର ଗଣ୍ଟା ଆକାୟ୍‌ ? ଇନେର୍‌ ୱେଡ଼ାଲିଂ ତାଙ୍ଗ୍‍ତିସ୍‍ ଉଜ଼୍‌ର୍‌, ଇନାକିଦେଂକି ହେୱାନ୍‌ ଇ ପୁର୍ତିନି ଅଜଡ଼୍‌ ହୁଡ଼୍‌ନାନ୍‌; ");
INSERT INTO peg_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","ମାତର୍‌ ନାଣା ତାଙ୍ଗ୍‍ତିସ୍ ହେୱାନ୍‌ ଉଜ଼୍‌ନାନ୍‌, ଇନାକିଦେଂକି ୱାସ୍କିତ ଅଜଡ଼୍‌ ହିଲୁତ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","ଜିସୁ ଇ ୱିଜ଼ୁ କାତା ଇଚି ପାଚେ ହେୱାରିଂ ଆରେ ଇଚାନ୍‌, “ମା ବନ୍ଦୁ ଲାଜାର୍‌ ହୁଞ୍ଜ୍‌ନାନା, ମାତର୍‌ ତାଙ୍ଗ୍‌ ହୁନ୍‌ଚାକାନିଂ ନିକ୍‍ନି କାଜିଂ ଆନ୍‌ ହାନାଙ୍ଗା ।” ");
INSERT INTO peg_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","ହେବେତାଂ ଚେଲାହିର୍‌ ତାଙ୍ଗ୍‌ ଇଞ୍ଜି ମାଚାର୍‌, ମାପ୍ରୁ, “ଜଦି ହେୱାନ୍‌ ହୁନ୍‍ଚାନ୍‍ନା ତା ଆତିସ୍‌ ହେୱାନ୍‌ ଉଜ୍‌ ଆନାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","ଜିସୁ ଲାଜାର୍‌ ହାତି ବିସ୍ରେ ଇଚାନ୍‌, ମାତର୍‌ ହେୱାନ୍‌ ହୁନ୍‌ଞ୍ଜ୍‌ନି ବିସ୍ରେ ଇଚାନ୍‌ ଇଞ୍ଜି ହେୱାର୍‌ ବାବିକିତାର୍ । ");
INSERT INTO peg_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","ହେଦାଂ କାଜିଂ ଜିସୁ ହେ ପାଦ୍‌ନା ହେୱାରିଂ ହାର୍‍ଦାଂ ଇଚାନ୍‌, “ଲାଜାର୍‌ ହାତାନ୍‍ନା; ");
INSERT INTO peg_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","ଆରେ, ଆନ୍‌ ଜେ ହେବାତ ହିଲ୍‍ୱିତିସ୍, ଇଦାଂ ଲାଗିଂ ମି କାଜିଂ ୱାରି କିନାଙ୍ଗା, ଇନେସ୍‌କି ଏପେଙ୍ଗ୍‌ ପାର୍ତି କିନାଦେର୍‌; ମାତର୍‌ ଜାଡୁ, ଆସେଙ୍ଗ୍‌ ତା କଚଣ୍‌ ହାନାସ୍ ।” ");
INSERT INTO peg_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","ହେବେତାଂ ତମା, ଇନେରିଂ ଦିଦୁମ୍‌ ଇଞ୍ଜି ଇନାର୍‌, ହେୱାନ୍‌ ଜାର୍‌ ହାଙ୍ଗ୍‌ ଚେଲାହିରିଂ ଇଚାନ୍‌, “ଜାଡୁ ଆସେଙ୍ଗ୍‌ ପା ଗୁରୁ ଲାହାଙ୍ଗ୍‌ ହାଲ୍‌ଜି ତା ଲାହାଂ ହାନାସ୍‍ ।” ");
INSERT INTO peg_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","ଜିସୁ ବେତ୍‌ନ୍ୟାତ ଏକିସ୍‌ ୱେଚାନ୍ ଜେ, ହେୱାନ୍‌ ଦୁଗେର୍‌ତ ଇଡ଼୍‌ଜି ଚାରି ଦିନ୍‌ ଆତାତ୍‌ ଦୁଗେର୍‌ତ ଇଟ୍ୟା ଆତାନେ । ");
INSERT INTO peg_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","ବେତ୍‌ନିୟା ଜିରୁସାଲମ୍‌ କଚଣ୍‌ତ ମାଚାତ୍‌, ଆନ୍‌ମାନ୍‌ତାଂ ତିନି କିଲମିଟର୍‌ ଦେହା; ");
INSERT INTO peg_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","ଆରେ, ଜିହୁଦି ଦେସ୍‌ନି ହେନି ମାନାୟ୍‌ ବିତ୍ରେ ମାର୍ତା ଆରି ମରିୟମ୍‌ତିଂ ହେୱାର୍‌ତି ଟଣ୍ଡେନ୍‌ ବିସ୍ରେ ଦୁକ୍‌ଜାଣାଇ କିଦେଙ୍ଗ୍‌ କାଜିଂ ହେୱାର୍‌ କଚଣ୍‌ ୱାଜ଼ି ମାଚାର୍ । ");
INSERT INTO peg_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","ହେବେତାଂ ଜିସୁ ୱାନାନା ଇଞ୍ଜି ଏଚେକାଡ଼୍‌ଦ ମାର୍ତା ୱେଚାତ୍, ହେ ପାଦ୍‌ନା ହେଦେଲ୍‌ ବେଟାଆଦେଂ ହାତାତ୍‌, ମାତର୍‌ ମରିୟମ୍‌ ଇଞ୍ଜ ମାଚାନ୍‌ ");
INSERT INTO peg_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","ମାର୍ତା ଜିସୁଙ୍ଗ୍‌ ଇଚାତ୍‌, “ମାପ୍ରୁ ଜଦି ଏନ୍‌ ଇବେ ୱାଜ଼ି ମାଚିସ୍‌, ତା ଆତିସ୍‌ ନା ଟଣ୍ଡେନ୍‌ ହାୱାତାନ୍‍ମା, ");
INSERT INTO peg_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","ମାତର୍‌ ନଙ୍ଗ୍‌ ପା ଆନ୍‌ ପୁନାଙ୍ଗ୍‌, ମାତର୍‌ ଏନ୍‌ ଇସ୍ୱର୍‌ତିଂ ଇନାକାପା ଏନ୍‍ନାୟ୍, ଇସ୍ୱର୍‌ ଜେ ହେଦାଂ ନିଙ୍ଗେଙ୍ଗ୍‌ ହିଦ୍‌ନାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","ଜିସୁ ତାଙ୍ଗେଙ୍ଗ୍‌ ଇଚାନ୍‌, “ମି ଟଣ୍ଡେନ୍‌ ଆରେ ଜିବୁନ୍‌ ପାୟା ଆଜ଼ି ନିଙ୍ଗ୍‌ନାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","ମାର୍ତା ଜିସୁଙ୍ଗ୍‌ ଇଚାତ୍‌, “ହେୱାନ୍‌ ଜେ ହାରିହାରା ଦିନ୍‍ତ ଆରେ ନିଂନି ସମୁତ ନିଙ୍ଗ୍‌ନାନ୍‌ ଇଦାଂ ଆନ୍‌ ପୁନାଙ୍ଗ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","ଜିସୁ ତାଙ୍ଗେଙ୍ଗ୍‌ ଇଚାନ୍‌, “ଆନ୍‌ ଆରେ ନିଂନାକାଂ ଆରି ଜିବୁନ୍‌, ଇନେର୍‌ ନା କଚଣ୍‌ ପାର୍ତି କିଦ୍‌ନାନ୍‌, ହେୱାନ୍‌ ଜଦି ହାନାନ୍, ଆତିସ୍‌ପା ହେୱାନ୍‌ ଜିନାନ୍‌, ");
INSERT INTO peg_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","ଆରେ ଇନେର୍‌କି ଜିନାନ୍‌ ଆରି ନାବେ ପାର୍ତି କିନାନ୍‌, ହେୱାନ୍‌ ମୁଡ଼୍‌କେ ହାଉନ୍; ଇଦାଂ ଇନାକା ପାର୍ତି କିନାଦେରା ?” ");
INSERT INTO peg_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","ମାର୍‌ତା ହେୱାନିଂ ଇଚାତ୍‌, “ଆଁ, ମାପ୍ରୁ, ଇନେର୍‌କି ପୁର୍ତିତ ୱାନାକା ମାଚାତ୍‌, ଏନ୍‌ ଜେ ଇସ୍ୱର୍ତି ମାଜ଼ି ହେ କ୍ରିସ୍ଟ, ଇଦାଂ ନା ପାର୍ତି ।” ");
INSERT INTO peg_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","ଇଦାଂ ଇଚି ପାଚେ ମାର୍‌ତା ହାଲ୍‌ଜି ଜାର୍‌ ତଣ୍‌ଦେଲ୍‌ ମରିୟମ୍‌ତିଂ ଡ଼ୁଗ୍‌ଜି କୁକ୍‌ଚି ଇଚାତ୍‌, “ଗୁରୁ ୱାତାନେ ଆରେ ନିଙ୍ଗେଙ୍ଗ୍‌ କୁକ୍ତାନାନା ।” ");
INSERT INTO peg_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","ହେୱାନ୍‌ ଇଦାଂ ୱେନ୍‌ଞ୍ଜି ବେଗି ନିଙ୍ଗ୍‌ଜି ତା କଚଣ୍‌ ହାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","ଜିସୁ ହେ ପାଦ୍‌ନା ନାସ୍‌କୁ ବିତ୍ରେ ୱାୱାଦାଙ୍ଗ୍ ମାଚାନ୍‌, ମାତର୍‌ ମାର୍ତା ହେୱେନିଂ ଇମ୍‌ଣି ବାହାତ ବେଟା ଆଜ଼ି ମାଚାତ୍, ହେପାତେକ୍‌ ହେୱାନ୍‌ ହେ ବାହାତ ମାଚାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","ବାଟିଙ୍ଗ୍‌ ଇମ୍‌ଣି ଜିହୁଦିର୍‌ ତା ଲାହାଙ୍ଗ୍‌ ଇଞ୍ଜ ମାନ୍‍ଞ୍ଜି ତାଙ୍ଗ୍‌ କ୍ଡପ୍‍କିସ୍‍ ମାଚାର୍‍, ହେୱାର୍‌ ମରିୟମ୍‌ତିଂ ବେଗି ନିଙ୍ଗ୍‌ଜି ହସିହାନାକା ହୁଡ଼୍‌ଜି, ହେଦେଲ୍‌ ଦୁଗେର୍‌ କଚଣ୍‌ତ ଆଡ଼୍‍ବିନି କାଜିଂ ହାନାରା, ଇଦାଂ ମାନେ କିଜ଼ି ହେ ପାଚେ ପାଚେ ହାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","ହେବେତାଂ ଜିସୁ ଇମ୍‌ଣି ବାହାତ ମାଚାନ୍‌, ମରିୟମ୍‌ ହେ ବାହାତ ଏକିସ୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ହୁଡ଼୍‌ଜି ହେ କାଲ୍‌କୁ ତାରେନ୍‌ ଗୁର୍‌ଜି ଇଚାତ୍‌, “ଏ ମାପ୍ରୁ, ଜଦି ଏନ୍‌ ଇବେ ଏକାୱାତାୟ୍‌ଚି, ତା ଆତିସ୍‌ ନା ଟଣ୍ଡେନ୍‌ ହାୱାତାନ୍‍ମା ।” ");
INSERT INTO peg_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","ଲାଗିଂ, ଜିସୁ ତାଙ୍ଗ୍‌ ଆରି ତା ଲାହାଙ୍ଗ୍‌ ୱାଜ଼ି ମାଚି ଜିହୁଦିରିଂ ଆଡ଼୍‌ବାନାକା ହୁଡ଼୍‌ଜି ଜିବୁନ୍‌ତାଂ ରାସ୍‌ ଇଚାନ୍‌, ଆରେ କାମାୟ୍‌ ପୁରା କିନି କାଜିଂ ହିର୍ଜାଆଜ଼ି ୱେନ୍‌ବାତାନ୍‌, ");
INSERT INTO peg_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","“ତାଙ୍ଗେଙ୍ଗ୍‌ ଇମେତାକେ ଇଡ଼୍‌ତାଦେର୍ଣ୍ଣା ?” ହେୱାର୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ଇଚାର୍‌, “ମାପ୍ରୁ ୱାଜ଼ି ହୁଡ଼ା ।” ");
INSERT INTO peg_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","ଜିସୁ ଆଡ଼୍‌ବାତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","ହେବେତାଂ ଜିହୁଦିର୍‌ ଇଚାର୍‌, “ହୁଡ଼ାଟ୍‌ ହେୱାନ୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ଇନେସ୍‌ ଜିଉନଜ଼ି ମାଚାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","ମାତର୍‌ ହେୱାର୍‌ ବିତ୍ରେ ଇନେର୍‌ ଇନେର୍‌ ଇଚାର୍‌, “ଇ ଇମ୍‌ଣି ମାନାୟ୍‌ ହେ କାଣାଂ କାଣ୍‌କୁ ସାକ୍ତି ହିୱାଦାଂ ମାଚାନ୍‌ କି ? ହେୱାନ୍‌ ଇନାକା ଇୱାନ୍ତି ହାକି ପା ଜିପ୍‍ତେଙ୍ଗ୍ ଆଡ୍‌ୱାତାନ୍‌ମା ?” ");
INSERT INTO peg_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","ହେବେତାଂ ଜିସୁ ଆରେ ରଗ ୱାସ୍କିତାଂ ରିସା ଆଜ଼ି ଦୁଗେର୍‌ କଚଣ୍‌ତ ୱାତାନ୍‍, ହେଦାଂ ରଞ୍ଜାଙ୍ଗ୍‌ ପାରା, ଆରେ ତା ମୁମ୍‌ଦ ରଞ୍ଜାଙ୍ଗ୍‌ କାଲ୍‌ ମାଚାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","ଜିସୁ ବଲ୍‌ ହିତାନ୍‌ ଇ କାଲ୍‌ ଗୁଚାୟ୍‍ କିୟାଟ୍‌ । ହାତି ମାନାୟ୍‌ତିଂ ତଣ୍‌ଦେହି, ମାର୍ତା ତାଙ୍ଗେଙ୍ଗ୍‌ ଇଚାତ୍‌, “ମାପ୍ରୁ, ହେୱେନ୍‌ ଗାନ୍ଦାଆତାନେ, ଇନାକିଦେଂକି ହେୱେନ୍‌ ଚାରି ଦିନ୍‌ ଆତାତ୍‌ ହାତାନେ ।” ");
INSERT INTO peg_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","ଜିସୁ ତାଙ୍ଗେଙ୍ଗ୍‌ ଇଚାନ୍‌, “ଜଦି ଏନ୍‌ ପାର୍ତି କିନାୟା, ତା ଆତିସ୍‌ ଇସ୍ୱର୍ତି ଜାଜ୍‌ମାଲ୍‌ ହୁଡ଼୍‌ନାଦେର୍‌, ଇଦାଂ ଇନାକା ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ୱେଚ୍‍ୱାତାଙ୍ଗ୍ ।” ");
INSERT INTO peg_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","ହେବେତାଂ ହେୱାର୍‌ କାଲ୍‌ ନେକ୍‍ତାର୍ ଆରେ, ଜିସୁ ଜପି ହୁଡ଼୍‌ଜି ଇଚାନ୍‌, “ଆବା, ଏନ୍‌ ନା ପାର୍ତାନା ୱେଚାୟ୍ ଇଞ୍ଜି ଆନ୍‌ ନିଙ୍ଗେଙ୍ଗ୍‌ ଜୁୱାର୍‌ ହିଦ୍‍ନାଙ୍ଗା । ");
INSERT INTO peg_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","ଏନ୍‌ ଜେ ନିତ୍ରେ ନା ପାର୍ତାନା ୱେନ୍‍ଞ୍ଜି ମାନାୟା, ଇଦାଂ ଆନ୍‌ ପୁଚାଙ୍ଗ୍‌ନା; ମାତର୍‌ ଇମ୍‌ଣି ମାନାୟାର୍‌ ଚାରିବେଣ୍‌ତାଂ ନିଲ୍‌ତାର୍ଣ୍ଣା, ଏନ୍‌ ନାଙ୍ଗେଙ୍ଗ୍‌ ପକ୍‌ତାତାୟ୍‌ନା ଇଞ୍ଜି ହେୱାର୍‌ ଇନେସ୍‌କି ପାର୍ତି କିଦ୍‌ନାର୍‌, ଇଦାଂ ଲାଗିଂ ହେୱାର୍‌ କାଜିଂ ଆନ୍‌ ଇଦାଂ ଇନ୍‌ଚାଙ୍ଗ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","ଇଦାଂ ଇଚି ପାଚେ ହେୱାନ୍‌ ଇଦାଂ ଇଞ୍ଜି ଗାଜା କାଟ୍‌ତାଂ ହିର୍‍ବାତାନ୍, “ଲାଜାର୍‌, ହସି ୱା ।” ");
INSERT INTO peg_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","ହେୱାନ୍‌ ହସି ୱାତାନ୍; ତା କେଇ ଆରି ପାନା ଦୁଗେର୍‍ ହେନ୍ଦ୍ରାତାଂ ଗାଚ୍ୟା ଆଜ଼ି ମାଚାତ୍‌, ଆରେ, ତା ମୁମ୍‌ଦ ଇଚୁକ୍‌ ତୁୱାଲ୍‌ ହୁର୍‌ପିସ୍‌ ମାଚାର୍‌ । ଜିସୁ ହେୱାରିଂ ଇଚାନ୍‌, “ଇୱାନ୍ତି ଗାଚ୍‌ଚାକା ରିକ୍‌ଚି ତାଙ୍ଗ୍‌ଜି ହାଞ୍ଜେଙ୍ଗ୍ ହିୟାଟ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","ଆରେ, ଜିହୁଦିର୍‌ ବିତ୍ରେ ଆଦେକ୍‌, ଇଚିସ୍‌ ଇମ୍‌ଣାକାର୍‌ ମରିୟମ୍‌ କଚଣ୍‌ ୱାଜ଼ି ମାଚାର୍, ହେୱାର୍‌ ଜିସୁତି କାରୁମ୍‌ ହୁଡ଼୍‌ଜି ମାଚାର୍‌, ଆରି ହେୱାର୍‌ ତାତାକେ ପାର୍ତି କିତାର୍‌; ");
INSERT INTO peg_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","ମାତର୍‌, ହେୱାର୍‌ ବିତ୍ରେ ଇନେର୍‌ ଇନେର୍‌ ପାରୁସିର୍‌ କଚଣ୍‌ ହାଲ୍‌ଜି, ଜିସୁ ଇନାକା ଇନାକା କିଜ଼ି ମାଚାନ୍‌, ହେୱିଜ଼ୁ ହେୱାରିଂ ଜାଣାୟ୍‌ କିତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","ହେବେତାଂ ମୁଡ଼୍‌ ମାପ୍ରୁହେବାକିନାକାନ୍‌ ଆରି ପାରୁସିର୍‌ ଗାଜା କୁଟୁମ୍‍ କୁକ୍‌ଚି ଇଚାର୍‌, “ଆସେଙ୍ଗ୍‌ ଇନାକା କିତାସ୍‍ନା ? ଇ ମାନାୟ୍‌ ତ ଆଦିକ୍‌ କାବା କାମାୟ୍‌ କିନାନା । ");
INSERT INTO peg_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","ଜଦି ଆସେଙ୍ଗ୍‌ ହେୱାନିଂ ଇ ଲାକେ ପିସ୍ତିହିନାସ୍, ତା ଆତିସ୍‌ ୱିଜ଼ାର୍‌ ତା ତାକେ ପାର୍ତି କିତାର୍‌, ଆରେ ରମିୟର୍‍ ୱାଜ଼ି ମାଦାଂ ଇ ମନ୍ଦିର୍‌ ଆରି ଜାତିତିଂ ରି କୁଦାତିଂ ନସ୍ଟ କିତାର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","ମାତର୍‌ ହେୱାର୍‌ ବିତ୍ରେ ହେ ବାର୍ହୁ କାଜିଂ, ବାଚିକିୟା ଆଜ଼ି ମାଚି ମୁଡ଼୍‌ ମାପ୍ରୁହେବାକିନାକାନ୍‌ କୟାପା ଇଚାନ୍‌, “ଏପେଙ୍ଗ୍‌ ଏଚେକ୍‌ ବକ୍‌ୱା ! ଏପେଙ୍ଗ୍‌ ଇଦାଂ ବୁଜା ଆଉଦେରା; ");
INSERT INTO peg_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","ୱିଜ଼ୁ ଜାତି ୱିଜ଼୍‌ୱାଦାଂ ମାନାୟାର୍‌ ବିତ୍ରେ ରକାନ୍‌ ଜେ ହାନାକା ମି ପାକ୍ୟାତାଂ ହାର୍‌, ଇଦାଂ ପା ଏପେଙ୍ଗ୍‌ ବୁଜା ଆଉଦେରା ।” ");
INSERT INTO peg_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","କୟାପା ଇଦାଂ ନିଜେ ମାନ୍ତ ଇନ୍‌ୱାଦାଂ ମାଚାନ୍‌ ମାତର୍‌ ହେୱାନ୍‌ ହେ ବାର୍ହୁନି ମୁଡ଼୍‌ ମାପ୍ରୁହେବାକିନାକାନ୍‌ ଆଜ଼ି ମାଚିଲେ ଇ ବେଣ୍‌ବାକ୍‌ଣାୟ୍‌କିନାକାନ୍‌ ତା ୱେଇଦାଂ ଇଞ୍ଜି ମାଚାନ୍‌, ଜିସୁ ୱେଚ୍‌ଚି ମାଚାନ୍‌ ଜେ ରାଜିନି ଜିହୁଦି ଜାତିନି ଇଚିସ୍‌, ");
INSERT INTO peg_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","ଆରେ କେବଲ୍‌ ହେ ଜାତି କାଜିଂ ଆକାୟ୍‌, ମତର୍‌ ଇସ୍ୱର୍ତି ଚିନ୍‍ବିନ୍‍ ହିମ୍‌ଣାକାଂ ପା ରୁଣ୍ଡାୟ୍‌ କିଜ଼ି ରବେ କିନି କାଜିଂ ହାଦେଂ ହାନାନା, ଇଦାଂ କାଜିଂ ଇ ବେଣ୍‌ବାକ୍‌ଣାୟ୍‌କିନାକା ଇଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","ଲାଗିଂ ହେ ନାଜିଂତାଂ ଜିହୁଦି ନେତାର୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ଅସ୍ତେଙ୍ଗ୍‌ ଇଞ୍ଜି କୁଟ୍‌ କିତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","ଲାଗିଂ, ଜିସୁ ଜିହୁଦିର୍‌ ବିତ୍ରେ ଆରେ ଡିହାଆୱାଦାଂ ବୁଲାଚାଲା ଆୱାତାନ୍‌, ମାତର୍‌ ହେୱାନ୍‌ ହେ ବାହାତାଂ ହସିହାଲ୍‍ଜି ବାଟାନି କଚଣ୍‌ ମାନି ନିପ ଏପ୍ରୟିମ୍‌ ତର୍‌ଦି ର ବସ୍ତିତ ହାଚାନ୍‌, ଆରେ ହେୱେନ୍‌ ଚେଲାର୍‌ ଲାହାଙ୍ଗ୍‌ ହେବେ ମାନ୍‌ଗାତାନ୍ । ");
INSERT INTO peg_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","ଜିହୁଦିର୍ତି “ନିସ୍ତାର୍‌” ପାର୍ବୁ ଲାଗେ ମାଚାତ୍‌, ଆରେ ରାଜିତ ମାନି ମାନାୟ୍‌ ଆଦିକ୍‌ ଜାର୍‌ ଜାର୍‌ତିଂ ସକଟ୍‌ କିନି କାଜିଂ ନିସ୍ତାର୍‌ ପାର୍ବୁ ଆଗେ ଜିରୁସାଲମ୍‌ତ ହାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","ହେବେତାଂ ହେୱାର୍‌ ଜିସୁଙ୍ଗ୍‌ ଡେକୁ ଡେକୁ ମନ୍ଦିର୍‌ତ ନିଲ୍‌ଚି ମାନି ସମୁତ ରକାନ୍‌ ଆରେ ରକାନିଂ ଇଞ୍ଜେଙ୍ଗ୍‌ ଲାଗାତାର୍‌, “ଏପେଙ୍ଗ୍‌ ଇନାକା ମାନେ କିନାଦେରା ? ହେୱେନ୍‌ ପାର୍ବୁତିଂ ୱାନାନ୍‌ କି ଆକାୟ୍‌ ?” ");
INSERT INTO peg_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","ମୁଡ଼୍‌ ମାପ୍ରୁହେବାକିନାକାନ୍‌ ଆରି ପାରୁସିର୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ଆହ୍‌ନି କାଜିଂ ହେୱେନ୍‌ ଇମେତାକେ ମାନାନ୍‌, ଇଦାଂ ଜଦି ଇନେର୍‌ ପୁନାର୍‌, ହେଦାଂ ହପ୍‍ତେଂ ବଲ୍‌ ହିଜ଼ିମାଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","ୱିସ୍ତି ବିତ୍ରେ ନିସ୍ତାର୍‌ ପାର୍ବୁନି ଚଅ ଦିନ୍‌ ଆଗେ ଜିସୁ ବେତ୍‌ନିୟା ହାଚାନ୍‌; ଇମ୍‌ଣି ଲାଜାର୍‌ତିଂ ଜିସୁ ହାତାକାର୍‌ ବିତ୍ରେ ନିକ୍‌ଚି ମାଚାନ୍, ହେୱେନ୍‌ ହେ ବାହାତ ମାଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","ଲାଗିଂ ହେୱେର୍‌ ହେ କାଜିଂ ହେ ବାହାତ ର ନାଣାବଜି ଜାଲ୍‌ଦି କିତାର୍‌; ମାର୍ତା ହେବା ହିନାକା ଦାଇତ୍‌ ମାଚାତ୍‌, ଆରେ ଇମ୍‌ଣାକାର୍‌ ହେୱାର୍‌ ଲାହାଂ ତିନିହିଙ୍ଗ୍‌ କୁଚ୍‌ଚି ମାଚାର୍‌, ଲାଜାର୍‌ ହେୱାର୍‌ ବିତ୍ରେତାଂ ରକାନ୍‌ ମାଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","ହେ ପାଦ୍‌ନା ମରିୟମ୍‌ ଆଦା ଲିଟର୍‌ ଆଦିକ୍‌ ଦାମ୍‌ନି ହାର୍ଦାକା ଜଟାମାଂସି ଚିକାଣ୍‌ ତାସ୍‌ ଜିସୁ ପାନାତ ହେଦାଂ ୱାକ୍‌ତାତ୍‌ ଜାର୍‌ ତେମୁଲ୍‌ତାଂ ହେ ପାନା ନୁସ୍‌ତାତ୍, ଆରେ ଚିକାଣ୍‌ ବାସ୍‍ନାତିଂ ଇଲ୍‌ ବାସ୍‌ନା ଆତାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","ମାତର୍‌ ଜିସୁ ଚେଲାହିର୍‌ ବିତ୍ରେ ଇସ୍କାରିୟତିୟ ଜିହୁଦା ତର୍‌ଦାକାନ୍‌ ଇମ୍‌ଣି ଚେଲା, ଇନେନ୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ସାତ୍ରୁ କେଇଦ ସର୍‌ପି କିଦେଙ୍ଗ୍‌ ହାଲ୍‌ଜି ମାଚାନ୍‌, ହେୱାନ୍‌ ଇଚାନ୍‌, ");
INSERT INTO peg_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“ଇ ବାସ୍‌ନା ଚିକାଣ୍‌ ତିନ୍‌ସ ରୁପା ଟାକାଂ ପ୍ରସି ଇନେକିଦେଂ ହିଲାୱାକାରିଂ ହିୟାଆୱାତାତ୍ ?” ");
INSERT INTO peg_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","ହେୱାନ୍‌ ଜେ ହିଲ୍‍ୱାକାରିଂ କାଜିଂ ଚିନ୍ତା କିଜ଼ି ମାଚାନ୍‌ ଇଞ୍ଜି ଇଦାଂ ଇଚାନ୍‌, ହେଦାଂ ଆକାୟ୍‌, ମାତର୍‌ ହେୱାନ୍‌ ରକାନ୍‌ ଚର୍‌, ଆରେ ହେ କଚଣ୍‌ ଡାବୁଙ୍ଗ୍‌ମଣା ମାଚିଲେ, ହେବେ ଇନା ଇନାକା ଇଡ଼୍‌ଜି ମାଚାକା, ହେଦାଂ ହେୱାନ୍‌ ଚର୍‌ କିଜ଼ି ଅଜ଼ି ମାଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","ମାତର୍‌ ଜିସୁ ଇଚାନ୍‌, “ଇଦେଲିଂ ପିସ୍ତି ହିୟାଟ୍, ଇନେସ୍‌କି ନା ହାକି ଦିନ୍‌ କାଜିଂ ହେଦେଲ୍‌ ଇଦାଂ ଇଡ୍‌ଦେଂ ଆଡ୍‌ନାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","କାକୁଲ୍‌ତିୟାର୍‌ ତ ସବୁ ନାଞ୍ଜିଙ୍ଗ୍‌ ମି କଚଣ୍‌ ମାନାର୍‌, ମତର୍‌ ଆନ୍‌ ସବୁ ନାଞ୍ଜିଙ୍ଗ୍‌ ମି କଚଣ୍‌ ମାନ୍‍ଙ୍ଗୁଙ୍ଗ୍ ।” ");
INSERT INTO peg_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","ଇବେତାଂ ବେସିହେନି ଜିହୁଦିର୍‌ ମାନାୟ୍‌ ହେୱାନ୍‌ ବେତ୍‌ନ୍ୟାତ ମାନାନ୍‌ ଇଞ୍ଜି ପୁଞ୍ଜି କେବଲ୍‌ ଜିସୁ କାଜିଂ ଆକାୟ୍‌, ମତର୍‌ ଇମ୍‌ଣି ଲାଜାର୍‌ତିଂ ହେୱାନ୍‌ ହାତାକାର୍‌ ବିତ୍ରେ ନିକ୍‌ଚି ମାଚାନ୍, ତାଙ୍ଗେଙ୍ଗ୍‌ ହୁଡ଼୍‌ନି କାଜିଂ ପା ୱାତାର୍ । ");
INSERT INTO peg_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","ହେବେ ଲାଜାର୍‌ତିଂ ପା ଅହ୍‌ନାସ୍‌ ଇଞ୍ଜି ମୁଡ଼୍‌ ମାପ୍ରୁହେବାକିନାକାନ୍‌ ୱେଚ୍‍ପା ଆତାର୍‌, ");
INSERT INTO peg_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","ଇନାକିଦେଂକି ହେଦାଂ କାଜିଂ ଜିହୁଦିର୍‌ ବିତ୍ରେତାଂ ଆଦିକ୍‌ ହେୱାରିଂ ମାନିକିୱାଦାଂ ମାଚାର୍‌ ଜିସୁ ତାକେ ପାର୍ତି କିଜ଼ି ମାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","ତା ଆର୍‌ର୍କାତ୍‌ ନାଜିଂ ନିସ୍ତାର୍‌ ପାର୍ବୁତିଂ ୱାଜ଼ି ମାଚି ହେନି ମାନାୟାର୍‌ ଜିସୁ ଜିରୁସାଲମ୍‌ତ ୱାନାନା ଇଞ୍ଜି ୱେଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","ହେଦାଂ କାଜିଂ କାଜ୍‌ରି ଡାଡ଼୍‌ ଆସ୍ତି ତାଙ୍ଗେଙ୍ଗ୍‌ ବେଟାଆନି କାଜିଂ ହସି ହାଚାର୍‌ “ଆରି ଗାଜା କାଟ୍‌ତାଂ ଇଞ୍ଜେଙ୍ଗ୍‌ ଲାଗାତାର୍‌, ହସାନ୍ନା ଇସ୍ୱର୍‌ତି ଦନ୍ୟବାଦ୍‌ କିୟାଟ୍‌ । ମାପ୍ରୁ ତର୍‌ଦାଂ ଇନେର୍‌ ୱାନାରା, ହେୱାନ୍‌ ଦନ୍ୟ; ଦନ୍ୟ ଇସ୍ରାଏଲ୍‌ନି ରାଜା ।” ");
INSERT INTO peg_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","ଆରେ, ଜିସୁ ର ଗଦହିମ୍‌ଣା ଜପି କୁଚ୍‌ଚି ୱାଜ଼ି ମାଚାନ୍‌, ଇଦାଂ ଦରମ୍ ସାସ୍ତର୍‌ତ ଇନେସ୍‌ ଲେକା ଆତାତ୍‌ନ୍ନା, ");
INSERT INTO peg_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“ଏ ସିୟନ୍‌ନି ଗାଡ଼୍‌ ! ପାଣ୍ଡ୍ରା ଆମା, ହୁଡ଼ାଟ୍‌, ମି ରାଜା ୱାନାନା, ହେୱାନ୍‌ ଗଦ ହିମ୍‌ଣା ଜପି କୁଚି ୱାନାନା ।” ");
INSERT INTO peg_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","ହେ ଚେଲାହିର୍‌ ପର୍ତୁମ୍‌ ଇ ୱିଜ଼ୁ ବିସ୍ରେ ବୁଜା ଆୱାତାର୍‌, ମାତର୍‌ ଜିସୁ ଜାଜ୍‌ମାଲ୍‌ ପାୟା ଆତି ପାଚେ ଇ ୱିଜ଼ୁ ବିସ୍ରେ ଜେ ହେ ବିସ୍ରେ ଲେକା ଆଜ଼ି ମାଚାତ୍‌, ଆରେ ହେଦାଂ କାଜିଂ ହେୱାର୍‌ ଜେ ଇ ୱିଜ଼ୁ କିଜ଼ି ମାଚାର୍‌, ହେଦାଂ ହେୱାର୍‌ ମାନ୍ତ ଏତୁୱାତାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","ଆରେ, ହେୱାନ୍‌ ଲାଜାର୍‌ତିଂ ଦୁଗେର୍‌ତାଂ ହିର୍‌ବିସ୍‌ ହାତାକାର୍‌ ବିତ୍ରେ ନିଙ୍ଗ୍‌ନି ୱେଡ଼ାଲିଂ ଇମ୍‌ଣି ମାନାୟାର୍‌ ହେ ଲାହାଙ୍ଗ୍‌ ମାଚାର୍‌, ହେୱାର୍‌ ସାକି ହିଦେଂ ଲାଗାତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","ଇଦାଂ କାଜିଂ ମାନାୟାର୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ମିହାଆଦେଂ ହାଲ୍‌ଜି ମାଚାର୍‌, ଇନାକିଦେଂକି ହେୱାନ୍‌ ଇ କାବାଆନି କାମାୟ୍‌ କିତାନ୍‌ନ୍ନା ଇଞ୍ଜି ହେୱାର୍‌ ୱେନ୍‌ଞ୍ଜି ମାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","ହେବେତାଂ ପାରୁସିର୍‌ ହେୱେର୍‌ ହେୱାର୍‌ ଇନ୍‌ବା ଆତାର୍‌, “ହୁଡ଼୍‍ନାଦେରା ତ, ଆପେଂ ଇନା କିଦେଙ୍ଗ୍‌ ଆଡୁପା ମା ୱିଜ଼ାର୍‌ ସେସ୍ଟା କାମାୟ୍‌ ଆଉତା; ହୁଡ଼ାଟ୍‌, ପୁର୍ତି ଜାକ୍‌ ତା ପାଚେ ହାଚାତେ ।” ");
INSERT INTO peg_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","ପାର୍ବୁ ସମୁତ ପ୍ରାର୍ତାନା କିନି କାଜିଂ ୱାଜ଼ି ମାନି ମାନାୟାର୍‌ ବିତ୍ରେ କେତେକ୍‌ ଗ୍ରିକ୍‌ ମାନାୟାର୍‌ ମାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","ହେୱାର୍‌ ଗାଲିଲିନି ବେତ୍‌ସାଇଦାନିକାନ୍ ପିଲିପ୍‌ ତାକେ ୱାଜ଼ି ତାଙ୍ଗ୍‌ ଗୱାରି କିଜ଼ି ଇଚାର୍‌, “ମାପ୍ରୁ, ଜିସୁଙ୍ଗ୍‌ ହୁଡ଼୍‌ଦେଂ କାଜିଂ ମା ଇଚା ।” ");
INSERT INTO peg_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","ପିଲିପିପ ହାଲ୍‌ଜି ଆନ୍ଦ୍ରିୟଙ୍ଗ୍‌ ଇଚାନ୍‌, ଆରେ ଆନ୍ଦ୍ରିୟ ଆରି ପିଲିପ୍‌ ହାଲ୍‌ଜି ଜିସୁଙ୍ଗ୍‌ ୱେଚ୍‍ଚାର୍‍ । ");
INSERT INTO peg_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","ଜିସୁ ହେୱାରିଂ ଉତର୍‌ ହିତାନ୍‌, “ମାନାୟ୍‌ ମାଜ଼ି ଜାଜ୍‌ମାଲ୍‌ ପାୟା ଆନି କାଜିଂ ସମୁ ଏକାୱାତାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","ହାତ୍‍ପା ହାତ୍‌ପା ମିଙ୍ଗେଙ୍ଗ୍‌ ଇଞ୍ଜ୍‌ନାଙ୍ଗା, ଗଁମ୍‌ ମାଞ୍ଜି ଜଦି ଚିକ୍‌ଲା ଆର୍ଜି ହାୱିତିସ୍‍, ତା ଆତିସ୍‌ ହେଦାଂ ରଞ୍ଜି ମତର୍‌ ମାନ୍‌ଗାନାତ୍‌ ମାତର୍‌ ଜଦି ହାନାତ୍‌ ତା ଆତିସ୍‌ ଆଦିକ୍‌ ପାଡ଼୍‌ ଆହ୍‌ନାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","ଇନେର୍‌ ଜାର୍‌ ଜିବୁନ୍‌ତିଂ ଜିଉ ଗିଆନ୍‌ କିନାନ୍‌ । ହେୱେନ୍‌ ହେଦାଂ ଆରାୟ୍‌ କିନାନ୍‌, ଆରେ ଇନେର୍‌ ଜାର୍‌ ଜିବୁନ୍‌ତିଂ ଇ ପୁର୍ତିତ ଗିଣ୍‌ କିନାନ୍‌, ହେୱାନ୍‌ ହେଦାଂ ୱିଜ଼୍‌ୱି ଜିବୁନ୍‌ କାଜିଂ ରାକ୍ୟା କିନାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","ଇନେର୍‌ ଏଚେକାଡ଼୍‌ଦ ହେବା କାରିୟା, ଲାଗିଂ ହେୱାନ୍‌ ନା ଲାହାଙ୍ଗ୍‌ ୱାୟେନ୍‌; ଆରେ ଆନେଙ୍ଗ୍‌ ଇମେତାକେ ମାନ୍‌ଗାନାଙ୍ଗ୍‌, ନା ହେବା କାରିୟା ପା ହେବେ ମାନ୍‌ଗାନାନ୍‌; ଇନେର୍‌ ଏଚେକାଡ଼୍‌ଦ ନାଙ୍ଗ୍‌ ହେବା କିଦ୍‌ନାନ୍‌, ଲାଗିଂ ଆବା ହେୱାନିଂ ସସ୍‌ କିନାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“ନଙ୍ଗ୍‌ ନା ୱାସ୍କି ଦକ୍‍ଦକ୍‌ ଆଦ୍‌ନାତା, ଆରେ ଆନ୍‌ ଇନାକା କିନାଂ ? ବାୱା ନାଙ୍ଗ୍‌ ଇ ସମୁତାଂ ରାକ୍ୟା କିଦା ? ମାତର୍‌ ଇଦାଂ କାଜିଂ ତ ଆନ୍‌ ଇ ସମୁ ବିତ୍ରେ ୱାତାଂନା । ");
INSERT INTO peg_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","ବାୱା, ଜାର୍‌ ତର୍‌ ଜାଜ୍‌ମାଲ୍‌ କିୟା ।” ହେବେଣ୍ଡାଂ ବାଦାଡ଼୍‌ତାଂ ଇ ବେରଣ୍‌ ଆତାତ୍‌, “ଆନ୍‌ ହେଦାଂ ପାଣ୍‌ କିତାଂନ୍ନା, ଆରେ ରଗ ପାଣ୍‌ କିନାପ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","ଲାଗିଂ ଲାଗେ ନିଲ୍‌ଚି ମାନି ଲକୁ ଇଦାଂ ୱେନ୍‌ଞ୍ଜି, ବାଦାଡ଼୍‌ ଗାର୍ଜା ଆତାତ୍‌ ଇଞ୍ଜି ଇଚାର୍‌ ବିନ୍‌ ଲଗୁ ଇଚାର୍‌, “ରୱାନ୍‌ ଦୁତ୍‌ ଇୱାନିଂ ବେଣ୍‌ ଇଚାଙ୍ଗ୍‌ନା ।” ");
INSERT INTO peg_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","ଜିସୁ ଉତର୍‌ ହିତାନ୍‌, “ନା କାଜିଂ ଇ ବେରଣ୍‌ ଆୱାତାତ୍‌ନା, ମତର୍‌ ମି କାଜିଂ ଆତାତ୍‌ନ୍ନା । ");
INSERT INTO peg_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","ନଙ୍ଗ୍‌ ଇ ପୁର୍ତିତ ବିଚାର୍ଣ୍ଣା ଏକାୱାତାତ୍‌; ନଙ୍ଗ୍‌ ଇ ପୁର୍ତିନି ମୁଡ଼୍‌ଦାକାର୍‌ ବାର୍ତ ତୁହିୟା ଆନାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","ଆରେ, ଆନ୍‌ ଜଦି ପୁର୍ତିତାଂ ଜପି ନିଙ୍ଗ୍‍ନାଂ, ତା ଆତିସ୍‌ ୱିଜ଼ାକାରିଂ ନିଜାର୍‌ ତାକେ ଜେଲ୍‍ନାଙ୍ଗ୍ ।” ");
INSERT INTO peg_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","ହେୱାନ୍‌ ଇମ୍‌ଣି ବାନି ହାକି କିଦେଙ୍ଗ୍‌ ହାନାନା, ହେବେନି କାବୁଲ୍‍ ହିଜ଼ି ଇଦାଂ ୱେଚ୍‌ଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","ହେବେଣ୍ଡାଂ ମାନାୟାର୍‌ ତାଙ୍ଗ୍‌ ଉତର୍‌ ହିତାର୍‌, “କ୍ରିସ୍ଟ ସବୁ ଦିନ୍‌ କାଜିଂ ମାନାନ୍‌ ଇଞ୍ଜି ଆପେଂ ମସାତି ବିଦିତାଂ ୱେଚ୍‍ଚାପ୍‍ନା, ବାଟିଙ୍ଗ୍‌ ମାନାୟ୍‌ ମାଜ଼ି ଆୱିତିସ୍ପା ଜପି ନିଂନାନ୍‌ ଇଞ୍ଜି ଏନ୍‌ ଇନେସ୍‌ ଇନାୟା ? ଇ ମାନାୟ୍‌ ମାଜ଼ି ଇନେର୍‌ ?” ");
INSERT INTO peg_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","ହେବେଣ୍ଡାଂ ଜିସୁ ହେୱାରିଂ ଇଚାନ୍‌, “ଆରେ ଅଲପ୍‍ ସମୁ ମତର୍‌ ଅଜଡ଼୍‌ ମି ବିତ୍ରେ ମାନାତ୍‌ । ମାଜ୍‌ଗା ଇନେସ୍‌ ମିଙ୍ଗ୍‌ ଚିଞ୍ଜ୍‍ମେତ୍, ଇଦାଂ କାଜିଂ ମି ତାକେ ଅଜଡ଼୍‌ ମାନୁ ମାନୁ ବୁଲାବୁଲି କିୟାଟ୍‌; ଜେ ମାଜ୍‌ଗାତ ବୁଲାବୁଲି କିନାନ୍‌, ହେୱାନ୍‌ ଇମେତାକେ ହାନାନା, ହେଦାଂ ହେୱାନ୍‌ ପୁନୁନ୍ । ");
INSERT INTO peg_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","ଏପେଙ୍ଗ୍‌ ଇନେସ୍‌ ଅଜଡ଼୍‌ନି ହିମ୍‌ଣାଂ ଆଡ, ହେଦାଂ କାଜିଂ ଅଜଡ଼୍‌ ମି ତାକେ ମାନୁ ମାନୁ ଅଜଡ଼୍‌ତ ପାର୍ତି କିୟାଟ୍‌ । ଜିସୁ ଇ ସବୁ କାତା ଇଞ୍ଜି ହାଚାନ୍‌ ଆରି ହେୱାର୍‌ତାଂ ଡ଼ୁଗ୍‌ଜି ମାଚାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","ମାତର୍‌ ହେୱାର୍‌ ମୁମ୍‌ଦ ଇସ୍ୱର୍‌ ଏଚେକ୍‌ କାବା କାମାୟ୍‌ କିଜ଼ି ମାଚାନ୍‌, ଆତିସ୍‌ପା ହେୱାର୍‌ ହେୱାନ୍‌ ତାକେ ପାର୍ତି କିୱାଦାଂ ମାଚାର୍‌, ");
INSERT INTO peg_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","ଇନେସ୍‌କି ବେଣ୍‌ବାକ୍‌ଣାୟ୍‌ କିନାକାନ୍‌ ଜିସାୟ୍‌ତି କାଜିଂ ଲେକାଆତି ଇ ବଚନ୍‌ ପୁରାଆନାତ୍, “ଏ ମାପ୍ରୁ, ମା କାବୁର୍‍ ୱେନ୍‌ଞ୍ଜି ଇନେର୍‌ ପାର୍ତି କିତାର୍‌ନା ? ଆରେ ଇନେର୍‌ ମାପ୍ରୁତି ମାରା ତାକେ ହତାତ୍‍ନା ?” ");
INSERT INTO peg_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","ଇଦାଂ କାଜିଂ ଜିସାୟ୍‌ ଆରେ ଇନାନ୍ନା, ହେୱାର୍‌ ପାର୍ତି କିଦେଙ୍ଗ୍‌ ଆଡ୍‌ୱାଦାଂ ମାଚାର୍‌, ଲାଗିଂ ଜିସାୟ୍‌ ଆରେ ଇଚାଙ୍ଗ୍‌ନା, ");
INSERT INTO peg_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“ଜିସୁ ହେୱାର୍‌ତି କାଣ୍‌କୁ କାଣା କିତାନ୍‌ନ୍ନା, ଆରେ ହେୱାର୍‌ତି ମାନ୍‌ ଆଟ୍‌ୱା କିତାନ୍‌ନ୍ନା, ଇନେସ୍‌ ହେୱାର୍‌ କାଣ୍‌କୁତାଂ ହୁଡ଼୍‌ଦେଂ ଆଡୁର୍‌ ଆରି ମାନ୍ତ ବୁଜା ଆଦେଂ ଆଡୁର୍‌, ଆରେ ମାସ୍‍ଦି ୱାଉର୍‍, ଆରେ ଆପେଂ ହେୱାରିଂ ଉଜ୍‌ କିଉପ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","ଜିସାୟ୍‌ ଇ ସବୁ ଇଚାନ୍‌, ଇନାକିଦେଂକି ହେୱାନ୍‌ ହେ ଗାଜା ପାଣ୍‌ ହୁଡ଼୍‌ତାନ୍‌ ଆରେ ହେ ବିସ୍ରେ ଇଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","ଆତିସ୍‌ପା ମୁଡ଼୍‌ଦାକାର୍‌ ବିତ୍ରେ ପା ଆଦେକ୍‌ ତାତାକେ ପାର୍ତି କିତାର୍‌, ମାତର୍‌ ଏଚେକାଡ଼୍‌ଦ କୁଟୁମ୍‌ ପାଗ୍ରି ଆନାର୍‌, ପାଣ୍ଡ୍ରୁତିଂ ଇଦାଂ କାଜିଂ ପାରୁସିର୍‌ କାଜିଂ ହେଦାଂ ମାନିକିୱାଦାଂ ମାଚାର୍‌, ");
INSERT INTO peg_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","ଇନାକିଦେଂକି ହେୱାର୍‌ ଇସ୍ୱର୍‌ତାଂ ପାଣ୍‌ ବାଟା ଇଚିସ୍‌ ମାନାୟାର୍‌ତାଂ ଜାଜ୍‌ମାଲ୍‌ ଜିଉ ନତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","ଜିସୁ ଗାଜା କାଟ୍‌ତାଂ ଇଚାନ୍‌, “ଇନେର୍‌ ନା ତାକେ ପାର୍ତି କିତାର୍‌, ହେୱାନ୍‌ କେବଲ୍‌ ନା ତାକେ ପାର୍ତି କିଉନ୍‌, ମତର୍‌ ନା ପକ୍ତିତି ହାଉକାର୍‍ତାକେ ପାର୍ତି କିତାର୍‌; ");
INSERT INTO peg_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","ଆରେ, ଜେ ନାଙ୍ଗ୍‌ ହୁଡ଼୍‍ଦାତାନ୍‍ନା, ହେୱାନ୍‌ ନା ପକ୍ତିତି ହାଉକାର୍‍ତିଂ ପା ହୁଡ଼୍‌ତାନ୍‌ନା । ");
INSERT INTO peg_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","ଆନ୍‌ ପୁର୍ତି ତାକେ ଅଜଡ଼୍‌ ଆଜ଼ି ୱାତାଂନା, ଇନେର୍‌ ନା ତାକେ ପାର୍ତି କିତାର୍‌, ହେୱାନ୍‌ ଇନେସ୍‌ ମାଜ୍‌ଗାତ ବାହା କିଉନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","ଇନେର୍‌ ଜଦି ନା ବଚନ୍‌ ୱେନ୍‌ଞ୍ଜି ମାନିକିଉନ୍‌, ତା ଆତିସ୍‌ ଆନ୍‌ ତାଦାଙ୍ଗ୍‌ ବିଚାର୍‌ କିଉଙ୍ଗ୍‌; ଇନାକିଦେଂକି ଆନ୍‌ ଜଗତ୍‍ତାକେ ବିଚାର୍‌ କିଦେଙ୍ଗ୍‌ ୱାୱାଦାଂ ଇଚିସ୍‌ ପୁର୍ତିତିଂ ମୁକ୍ତି କିଦେଙ୍ଗ୍‌ ୱାତାଂନା । ");
INSERT INTO peg_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","ଜେ ନାଙ୍ଗ୍‌ ମୁନା କିଦ୍‌ନାର୍‌ ଆରି ନା ବଚନ୍‌ତିଂ ମାନିକିଉର୍‌, ନା ମୁମ୍‌ଦ ତା ବିଚାର୍‌ ଆନାତ୍‌; ଆନ୍‌ ଇମ୍‌ଣି ବଚନ୍‌ ଇଚାଙ୍ଗ୍‌ନା, ହେଦାଂ ହାରିହାରା ଦିନ୍ତ ହେୱାନ୍ତି ବିଚାର୍ଣ୍ଣା କିନାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","ଇନାକିଦେଂକି ଆନ୍‌ ନା ତାକେଣ୍ଡାଂ ଜାର୍‌ ଆଦିକାର୍‌ ତାଙ୍ଗ୍‌ ଇନ୍‌ୱାତାଂନ୍ନା, ମତର୍‌ ଆନ୍‌ ଇନାକା ଇନାଂ ଆରି ଇନାକା ହପ୍‍ନାଂ, ହେଦାଂ ନା ପକ୍ତିତି ହାଉକାର୍‌ ବାୱା ନାଙ୍ଗେଙ୍ଗ୍‌ ବଲ୍‌ ହିତ୍‍ତାନ୍ନା; ");
INSERT INTO peg_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","ଇଚିସ୍‌ ଆନ୍‌ ପୁନାଙ୍ଗ୍‌ ହେ ବଲ୍‌ ୱିଜ଼୍‌ୱି ଜିବୁନ୍‌ ହିଦ୍‌ନାନ୍‌ ମାଞ୍ଜିଆବା ନାଙ୍ଗେଙ୍ଗ୍‌ ଇନାକା ଇଞ୍ଜେଙ୍ଗ୍‌ ବଲ୍‌ ହିତ୍‌ନ୍ନା କେବଲ୍‌ ଏଚେକ୍‌ ଆନ୍‌ ଇନାଙ୍ଗା ।” ");
INSERT INTO peg_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","ନିସ୍ତାର୍‌ ପାର୍ବୁ ଆନି ଆଗେ ଜିସୁ ଇ ପୁର୍ତିତାଂ ଆବା ତାକେ ଜାର୍‌ ହାନି ସମୁ ଏକାୱାତାକା ପୁଞ୍ଜି, ପୁର୍ତିତ ମାନି ଜାର୍‌ନି ଇମ୍‌ଣି ମାନାୟାରିଂ ହେୱାନ୍‌ ଜିଉ ନଜ଼ି ୱାଜ଼ି ମାଚାନ୍‌, ହେୱାର୍‌ କାଜିଂ ବେସି ଜିଉନତାନ୍‍ । ");
INSERT INTO peg_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","ଆରେ, ନାଣାବଜି ସମୁତ, ଏଚେକାଡ଼୍‌ଦ ସୟ୍‌ତାନ୍‌ ସିମନ୍‌ତି ଇସ୍କାରିୟତିୟ ମେହି ଜିହୁଦା ମାନ୍‌ତ ଜିସୁଙ୍ଗ୍‌ ସତ୍ରୁ କେଇଦ ହେଲାୟ୍‌ କିଦେଙ୍ଗ୍‌ କାଜିଂ କାବୁର୍‌ କିଜ଼ି ମାଚାନ୍‌, ");
INSERT INTO peg_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","ହେ ଏଚେକାଡ଼୍‌ଦ, ଆବା ଜେ ୱିଜ଼ୁ କେଇଦ ୱିଜ଼ୁ ବିସ୍ରେ ହେଲାୟ୍‌ କିତାନ୍‌ନ୍ନା ଆରି ହେୱାନ୍‌ ଜେ ଇସ୍ୱର୍‌ତାଂ ୱାତାନ୍ନା, ଆରେ ଇସ୍ୱର୍‌ ତାକେ ହାନାନା ଇଦାଂ ପୁଞ୍ଜି ମାଚାନ୍‌, ");
INSERT INTO peg_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","ଇଦାଂ ପୁଞ୍ଜି ହେୱାନ୍‌ ଚିଞ୍ଜେଙ୍ଗ୍‌ କୁଚ୍‌ଚି ତାକେଣ୍ଡାଂ ନିଙ୍ଗ୍‌ଜି ଜାର୍‌ ହେନ୍ଦ୍ରା ଉନ୍‌ଦି ର ତୁଆଲ୍‌ ଅଜ଼ି ଜାର୍‌ ମ୍ଡେଙ୍ଗାତ ଗାଚ୍ୟା ଆତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","ହେ ପାଚେ ହେୱାନ୍‌ ବାହାତ ଏଜ଼ୁଂ ୱାକ୍‍ତାନ୍, ଆରେ ଚେଲାର୍‍ତି ପାନାଙ୍ଗ୍‌ ନୁସ୍‌ଜ଼ି ଜାର୍‌ ମ୍ଡେଙ୍ଗାତ ଗାଚ୍ୟା ଆଜ଼ି ମାଚି ତୁଆଲ୍‌ ହୁଦାଂ ନେନ୍‌ଦେଂ ଲାଗାତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","ଜିସୁ ସିମନ୍‌ ପିତର୍‌ ତାକେ ୱାତାନ୍‌; ଇନେନ୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ଇଚାନ୍‌, “ମାପ୍ରୁ, ଏନ୍‌ ଇନାକା ନା ପାନା ନୁଜ଼୍‌ଦାତାଇନା ?” ");
INSERT INTO peg_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","ଜିସୁ ତାଙ୍ଗେଙ୍ଗ୍‌ ଉତର୍‌ ହିତାନ୍‌, “ଆନ୍‌ ଇନାକା କିନାଙ୍ଗା, ହେଦାଂ ନଙ୍ଗ୍‌ ପୁନୁଦେର୍‌, ମାତର୍‌ ପାଚେ ବୁଜାନାଦେର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","ପିତର୍‌ ହେୱାନିଂ ଇଚାନ୍‌, “ଏନ୍‌ ମୁଡ଼୍‌କେ ଇନାୱାଡ଼ାଂ ପା ନା ପାନା ନୁଜ଼୍‌ଜି ହିଦୁୟ୍ ।” ଜିସୁ ତାଙ୍ଗେଙ୍ଗ୍‌ ଉତର୍‌ ହିତାନ୍‌, “ଜଦି ଆନ୍‌ ମିଙ୍ଗ୍‌ ନୁସ୍‍ଦିୱିତିସ୍, ତା ଆତିସ୍‌ ନା ହୁକେ ମିଦାଙ୍ଗ୍‌ ଇନାକା ବାଗ୍‌ ହିଲୁତ୍‍ ।” ");
INSERT INTO peg_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","ସିମନ୍‌ ପିତର୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ଇଚାନ୍‌, “ମାପ୍ରୁ, କେବଲ୍‌ ନା ପାନା ଆକାୟ୍‌, ମତର୍‌ ନାଦାଂ କେଇ ଆରି କାପ୍‌ଡ଼ା ପା ।” ");
INSERT INTO peg_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","ଜିସୁ ତାଙ୍ଗ୍‌ ଇଚାନ୍‌, “ଇନେନ୍‌ ଇବାତାନ୍‌ନ୍ନା, ହେୱାନ୍ତି ପାନା ନୁସ୍‌ଦି ପିସ୍ତି ଆରେ ଇନାକା ଲଡ଼ା ଆକାୟ୍‌, ହେୱାନ୍‌ ହାତେ ସକଟ୍‌; ଏପେଙ୍ଗ୍‌ ସକଟ୍‌ କାଦେର୍‌, ମାତର୍‌ କେବଲ୍‌ ରକାନ୍‌ ଆକାୟ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","ଇନାକିଦେଂକି ଇନେର୍‌ ତାଙ୍ଗ୍‌ ସତ୍ରୁ କେଇଦ ହେଲାୟ୍‌ କିନାନ୍‌, ଜିସୁ ହେୱାନିଂ ପୁଞ୍ଜି ମାଚାନ୍‌; ପାଚେ ହେୱାନ୍‌ ଇଚାନ୍‌, “ଏପେଙ୍ଗ୍‌ ରୱାନିଂ ପିସ୍ତି ୱିଜ଼ାକାଦେର୍‌ ସକଟ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","ହେ ପାଚେ ଜିସୁ ହେୱାର୍‌ତି ପାନା ନୁଜ଼୍‌ଜି ହିଜ଼ି ଜାର୍‌ ହେନ୍ଦ୍ରା ଉସ୍ପିସ୍‌ ଆରେ ରଗ ଜାର୍‌ ଗାଦିତ କୁଚ୍‌ଚି ପାଚେ ହେୱାରିଂ ୱେନ୍‌ବାତାନ୍‌, “ଆନ୍‌ ମି କାଜିଂ ଇନାକା କିତାଂନ୍ନା, ହେଦାଂକି ଏପେଙ୍ଗ୍‌ ବୁଜା ଆତାଦେର୍ଣ୍ଣା ?” ");
INSERT INTO peg_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","“ଏପେଙ୍ଗ୍‌ ନାଙ୍ଗେଙ୍ଗ୍‌ ଗୁରୁ ଆରି ମାପ୍ରୁ ଇଞ୍ଜି କୁକ୍ତାନାଦେରା, ଆରେ ହାତ୍‌ପା ଇନାଦେରା; ଇନାକିଦେଂକି ଆନ୍‌ତ ହେୱାଙ୍ଗ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","ଆରେ, ମାପ୍ରୁ ଆରି ଗୁରୁ ଜେ ମିୱାଙ୍ଗ୍‌ ଆନ୍‌, ଆନ୍‌ ଜଦି ମିୱାଙ୍ଗ୍‌ ପାନା ନୁଜ଼୍‌ଜି ହିତ୍‍ତାଂନ୍ନା, ତେବେ ମିଦାଙ୍ଗ୍‌ ପା ରକାନ୍‌ ଆରେ ରକାନ୍ତି ପାନା ନୁସ୍‌ନାକା ଲଡ଼ା । ");
INSERT INTO peg_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","ଇନାକିଦେଂକି ମି କାଜିଂ ଆନ୍‌ ଇନେସ୍‌ କିତାଂନ୍ନା, ଏପେଙ୍ଗ୍‌ ପା ହେ ଲାକେ କିୟାଟ୍‌, ଇଦାଂ କାଜିଂ ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ର ଉତର୍‌ମୁଡ଼୍‌ ଚଚ୍‌ଚାତାଂନ୍ନା । ");
INSERT INTO peg_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","ହାତ୍‌ପା ହାତ୍‌ପା ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ଇଞ୍ଜ୍‌ନାଙ୍ଗା, ଆଡ଼ିଏନ୍‌ ଜାର୍‌ ହାଉକାର୍‌ତାଂ ଆଦେକ୍‌ ମୁଡ଼୍‌ଦାକାନ୍‌ ଆକାୟ୍‌, ଆୱିତିସ୍‌ ପକ୍ୟାତାକାର୍‌ ଜାର୍‌ ପକ୍‍ତାକାନ୍‌ତାଂ ମୁଡ଼୍‌ଦାକାନ୍‌ ଆକାୟ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","ନଙ୍ଗ୍‌ ଏପେଙ୍ଗ୍‌ ଇ ସତ୍‌ ପୁଚାଦେର୍‌ଚି, ତେବେ ହେ ଲାକେ କିତିସ୍‌ ଏପେଙ୍ଗ୍‌ ଦନ୍ୟ । ");
INSERT INTO peg_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“ଆନ୍‌ ମିଙ୍ଗ୍‌ ୱିଜ଼ାକାର୍‌ ବିସ୍ରେ ଆନ୍‌ ଇ କାତା ଇଞ୍ଜୁଙ୍ଗା; ଆନ୍‌ ଇମ୍‌ଣାକାରିଂ ବାଚି କିତାଙ୍ଗ୍‌ନା, ହେୱାରିଂ ଆନ୍‌ ପୁନାଙ୍ଗ୍‌ ମାତର୍‌ ସାସ୍ତର୍‌ନି ଇ ବଚନ୍‌ ହାତ୍‌ପା ସତ୍‌ ଆନାତ୍‌ । ହେବେ ଏଲେଙ୍ଗ୍‌ ଗିଟାନାତା, ଇନେନ୍‌ ନା ଆରାଣ୍‌ ତିନାନ୍‌, ହେୱାନ୍‌ ନା ବିରୁଦ୍‌ତ ଲାତ୍‌ ତଗ୍‌ନାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","ହେଦାଂ ଗିଟାନି ସମୁତ, ଆନ୍‌ ହେୱାନ୍‍ନେ ଇଞ୍ଜି ଏପେଙ୍ଗ୍‌ ଇନେସ୍‌ ପାର୍ତି କିନାଦେର୍‌, ଇଦାଂ କାଜିଂ ହେଦାଂ ଗିଟାଆନି ଆଗେ ଆନ୍‌ ନଙ୍ଗ୍‌ ମିଙ୍ଗ୍‌ ୱେଚ୍‌ଚାନାଙ୍ଗା ଆନ୍‌ ଜେ ହେୱାଙ୍ଗ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","ହାତ୍‌ପା ହାତ୍‌ପା ଆନ୍‌ ମିଙ୍ଗ୍‌ ୱେଚ୍‍ଚାନାଙ୍ଗା, ଇନେର୍‌ ନା ପକ୍ତି ଲଗାଂ ଇଟ୍‌ନାର୍‌, ହେୱାର୍‌ ନାଙ୍ଗ୍‌ ଇଡ଼୍‌ଦାନାର୍‌ ଆରି ଇନେର୍‌ ନାଙ୍ଗ୍‌ ଇଡ଼୍‌ଦାନାର୍‌, ହେୱାନ୍‌ ନାଙ୍ଗ୍‌ ପକ୍ତିତି ହାଉକାର୍‌ତିଂ ଇଟ୍‌ନାର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","ଜିସୁ ଇ ୱିଜ଼ୁ କାତା ୱେଚ୍‌ଚି ପାଚେ ଜିବୁନ୍ତ ଦୁକ୍‌ କିତାନ୍‌ ଆରି ଚଞ୍ଜିୟାଆଜ଼ି ସାକି ହିିଜ଼ି ଇଚାନ୍‌, “ହାତ୍‌ପା ହାତ୍‌ପା ଆନ୍‌ ମିଙ୍ଗ୍‌ ଇଞ୍ଜ୍‌ନାଙ୍ଗା, ମି ବିତ୍ରେ ରକାନ୍‌ ନାଙ୍ଗ୍‌ ସତ୍ରୁ କେଇଦ ହେଲାୟ୍‌ କିଦ୍‌ନାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","ଜିସୁ ହେ ବିସ୍ରେ ୱେଚ୍‌ଚାନ୍‌, ହେ ବିସ୍ରେ ବୁଦି ବାମ୍‌ଣ୍ଡା ଆଜ଼ି ଚେଲାର୍‌ ହାରି ହୁଡ଼୍‍କାଆଦେଂ ଲାଗାତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","ଜିସୁ ଚେଲାର୍‌ ବିତ୍ରେ ରୱାନ୍‌ ଇନେରିଂ ଜିସୁ ଜିଉନଜ଼ି ମାଚାନ୍‌ ହେୱାନ୍‌ ଜିସୁ ତିନାବାଗାଂ କୁଚ୍‌ଚି ତିନ୍‌ଜି ମାଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","ଇଚିସ୍‌ ସିମନ୍‌ ପିତର୍‌ ହେୱାନିଂ ଚଚ୍‍ଚି କିଜ଼ି ଇଚାନ୍‌, “ହେୱାନ୍‌ ଇନେର୍‌ କାତା ଇନାନ୍ନା, ହେଦାଂ ୱେନ୍‌ବାଟ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","ହେୱାନ୍‌ ହେ ଲାକେ କୁଚ୍‌ଚି ମାନ୍‌ଞ୍ଜି ଜିସୁ ନେଞ୍ଜେଡାକିତ ଇଡ଼ିୟା ଆଜ଼ି ତାଙ୍ଗ୍‌ ୱେନ୍‌ବାତାନ୍‌, “ମାପ୍ରୁ, ହେୱାନ୍‌ ଇନେର୍‌ ?” ");
INSERT INTO peg_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","ଲାଗିଂ ଜିସୁ ଉତର୍‌ ହିତାନ୍‌, “ଇନେର୍‌ କାଜିଂ ଆନ୍‌ ଇ ରୁଟି ରଞ୍ଜି କ୍ଡୁକ୍‌ନାଂ ଆରି ଇନେରିଂ ହେଦାଂ ହିନାଂ, ହେୱାନ୍‌ ।” ହେବେ ହେୱାନ୍‌ ହେ ରୁଟିତିଂ କ୍ଡୁକ୍‌ଚି ହେଦାଂ ଅଜ଼ି ସିମନ୍‌ ଇସ୍କାରିୟତିୟ ମେହି ଜିହୁଦାଙ୍ଗ୍‌ ହିତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","ହେୱାନ୍‌ ରୁଟି ପାୟା ଆତି ପାଚେ ସୟ୍‌ତାନ୍‌ ତାଙ୍ଗ୍‌ ବିତ୍ରେ ହଟାତ୍‌ । ହେବେ ଜିସୁ ତାଙ୍ଗ୍‌ ଇଚାନ୍‌, “ଇନାକା କିନାକା ମାନାତ୍‌, ହେଦାଂ ବେଗି କିୟା ।” ");
INSERT INTO peg_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","ମାତର୍‌ ହେୱାନ୍‌ ତା ଇଦାଂ ଇନାକିଦେଂ ଇଚାନ୍‌ ତାଙ୍ଗ୍‌ ଇ କାତା ଇଞ୍ଜି ମାଚାନ୍‌, ହେଦାଂ ତିଞ୍ଜେଙ୍ଗ୍‌ କୁଚ୍‌ଚି ମାଚି ଲକୁ ବିତ୍ରେ ଇନେର୍‌ ପୁନ୍‌ୱାତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","ଇନାକିଦେଂକି ଜିହୁଦା ତାକେ ଡାବୁଙ୍ଗ୍‌ମଣା ମାଚିଲେ, ପାର୍ବୁ କାଜିଂ ଇନା ଇନାକା ଲଡ଼ା, ହେଦାଂ କଡ଼୍‌ଦେଂ ଆୱିତିସ୍‌ ଅର୍କିତାରିଂ ଅଲପ୍‍ ଦାନ୍‌ ହିଦେଂ ଜିସୁ ତାଙ୍ଗ୍‌ ଇଚାନ୍‌ ଇଞ୍ଜି ଇନେ ଇନେର୍‌ ବାବି କିତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","ତା ପାଚେ ଇସ୍କାରିୟତିୟ ହେୱାନ୍‌ ରୁଟି ତିନ୍‌ଞ୍ଜି ହେୱାନ୍‌ ହେ ସାଙ୍ଗେ ହସି ହାଚାନ୍‌, ହେ ଏଚେକାଡ଼୍‌ଦ ନାଣା ସମୁ । ");
INSERT INTO peg_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","ହେୱାନ୍‌ ହସି ହାଚି ପାଚେ ଜିସୁ ଇଚାନ୍‌, “ନଙ୍ଗ୍‌ ମାନାୟ୍‌ ମାଜ଼ି ଜାଜ୍‌ମାଲ୍‌ ପାୟା ଆତାନ୍‌ ଆରି ତା ତାକେ ଇସ୍ୱର୍‌ ପା ପାଦ୍‌ପାୟାଆତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","ଜଦି ଇସ୍ୱର୍‌ ତା ତାକେ ପାଦ୍‌ପାୟାଆତିସ୍, ତେବେ ଇସ୍ୱର୍‌ ପା ତାଙ୍ଗେଙ୍ଗ୍‌ ଜାର୍‌ତାକେ ପାଦ୍‌ ପାୟାନାକା କିନାନ୍‌, ଆରେ ବେଗି ହେୱାନିଂ ଜାଜ୍‌ମାଲ୍‌ କିନାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","ଜିସୁ ଇଚାନ୍‌ “ଏ ବପାର୍‌,” ଆନ୍‌ ଆରେ ଅଲପ୍‍ ସମୁ ମି ହୁକେ ମାନାଂ । ଏପେଙ୍ଗ୍‌ ନାଙ୍ଗ୍‌ ଡେକ୍ତାନାଦେର୍‌; ଆରେ, ଆନ୍‌ ଇମ୍‌ଣି ବାହାତ ହାନାଙ୍ଗା, ଏପେଙ୍ଗ୍‌ ହେ ବାହାତ ହାଞ୍ଜେଙ୍ଗ୍‌ ଆଡୁଦେର୍‌, ଇଦାଂ ଆନ୍‌ ଇନେସ୍‌ ଜିହୁଦି ନେତାର୍‌ ଇଚାର୍‌, ହେ ଲାକେ ନଙ୍ଗ୍‌ ଏପେଙ୍ଗ୍‌ ପା ଇନାଦେରା । ");
INSERT INTO peg_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","“ଏପେଙ୍ଗ୍‌ ରକାନ୍‌ ଆରେ ରକାନିଂ ଜିଉନୱାଟ୍, ଇ ପୁନି ବଲ୍‌ ଆନ୍‌ ମିଙ୍ଗ୍‌ ହିଦ୍‍ନାଙ୍ଗା; ଆନ୍‌ ଇନେସ୍‌ ମିଙ୍ଗ୍‌ ଜିଉ ନତ୍‍ତାଂନା, ଏପେଙ୍ଗ୍‌ ପା ହେ ଲାକେ ରକାନ୍‌ ଆରେ ରକାନିଂ ଜିଉନନାକା ମାନାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","ଜଦି ମିଦାଙ୍ଗ୍‌ ରକାନ୍‌ ଆରେ ରକାନ୍‌ ତାକେ ଜିଉନବାନାକା ମାଚିସ୍‌, ତା ଆତିସ୍‌ ଏପେଙ୍ଗ୍‌ ଜେ ନା ଚେଲା, ଇଦାଂ ୱିଜ଼ାକାର୍‌ ହେଦାଂ ପୁଞ୍ଜେଙ୍ଗ୍‌ ଆଡ୍‌ନାର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","ସିମନ୍‌ ପିତର୍‌ ତାଂ ୱେନ୍‌ବାତାନ୍‌, “ମାପ୍ରୁ, ଏନ୍‌ ଇମେତାକେ ହାନାୟା ?” ଜିସୁ ଉତର୍‌ ହିତାନ୍‌, “ଆନ୍‌ ଇମେତାକେ ହାନାଙ୍ଗା, ଏପେଙ୍ଗ୍‌ ନଙ୍ଗ୍‌ ନା ପାଚେ ପାଚେ ହାଞ୍ଜେଙ୍ଗ୍‌ ଆଡୁଦେର୍‌ ? ଆନ୍‌ ନି କାଜିଂ ଜାର୍‌ ଜିବୁନ୍‌ ହିନାଙ୍ଗ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","ପିତର୍‌ ହେୱାନିଂ ୱେନ୍‌ବାତାନ୍‌, “ମାପ୍ରୁ, ଆନ୍‌ ନଙ୍ଗ୍‌ ଇନେକିଦେଂ ନି ପାଚେ ପାଚେ ହାଞ୍ଜେଙ୍ଗ୍‌ ଆଡୁଙ୍ଗ୍‌ ? ଆନ୍‌ ନି କାଜିଂ ଜାର୍‌ ଜିବୁନ୍‌ ହିଦେଂ ଆଡ୍‌ନାଂ ।” ");
INSERT INTO peg_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","ଜିସୁ ଉତର୍‌ ହିତାନ୍‌, “ଏନ୍‌ ଇନାକା ନା କାଜିଂ ଜାର୍‌ ଜିବୁନ୍‌ ହିନାୟ୍ ? ହାତ୍‌ପା ହାତ୍‌ପା ଆନ୍‌ ନିଙ୍ଗେଙ୍ଗ୍‌ ୱେଚ୍‍ଚାନାଙ୍ଗା, ଗାଞ୍ଜା କୁଜ଼ୁ କ୍ଡେନିହିଂ ଏନ୍‌ ନାଙ୍ଗ୍‌ ତିନିହଟ୍‌ ପାର୍ତି କିଦୁୟ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","“ମି ମାନ୍‌ ବିଲ୍‌କି ଆମେତ୍‌, ଏପେଙ୍ଗ୍‌ ଇସ୍ୱର୍‌ ତାକେ ପାର୍ତି କିୟାଟ୍‌, ନା ତାକେ ପା ପାର୍ତି କିୟାଟ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","ନା ଆବାର୍‌ ଇଞ୍ଜ ଜବର୍‌ ବାହାଂ ମାନିଂ; ଜଦି ହଲ୍‍ୱିତିସ୍‍, ତା ଆତିସ୍‌ ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ୱେଚ୍‍ଚାତାଂମା, ଆନ୍‌ ମି କାଜିଂ ବାହା ଜାଲ୍‌ଦି କିଦେଙ୍ଗ୍‌ ହାନାଙ୍ଗା; ");
INSERT INTO peg_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","ଆରେ, ଆନ୍‌ ହାଲ୍‌ଜି ମି କାଜିଂ ବାହା ଜାଲ୍‌ଦି କିତିସ୍‌ ଆରେ ରଗ ୱାନାଙ୍ଗ୍, ଆରେ ଆନ୍‌ ଇମ୍‌ଣି ବାହାତ ମାନାଂ, ଏପେଙ୍ଗ୍‌ ପା ଇନେସ୍‌ ହେ ବାହାତ ମାନାଦେର୍‌, ହେଦାଂ କାଜିଂ ମିଙ୍ଗ୍‌ ଜାର୍‌ତାକେ ଅଜ଼ି ହାଞ୍ଜ୍‌ନାଂ । ");
INSERT INTO peg_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","ଆରେ, ଆନ୍‌ ଇମ୍‌ଣି ବାହାତ ହାନାଙ୍ଗା, ହେ ହାଜ଼ି ଏପେଙ୍ଗ୍‌ ପୁନାଦେର୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","ତମା ଜିସୁଙ୍ଗ୍‌ ୱେନ୍‌ବାତାନ୍‌, “ମାପ୍ରୁ, ଏନ୍‌ ଇମ୍‌ଣି ବାହାତ ହାନାୟା, ହେଦାଂ ଆପେଂ ପୁନୁପ୍‌; ହାଜ଼ି ଇନେସ୍‌ ପୁଞ୍ଜେଙ୍ଗ୍‌ ଆଡ୍‌ନାପ୍‌ ?” ");
INSERT INTO peg_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","ଜିସୁ ତାଙ୍ଗ୍‌ ଇଚାନ୍‌, “ଆନ୍‌ ହାଜ଼ି, ହାତ୍‌ପା ଆରି ଜିବୁନ୍‌; ନା ହିଜ଼ି ହାଲ୍‍ୱିତିସ୍ ଇନେର୍‌ ଆବା ତାକେ ହାଲୁନ୍ । ");
INSERT INTO peg_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","ଜଦି ଏପେଙ୍ଗ୍‌ ନାଙ୍ଗ୍‌ ପୁଞ୍ଜିମାଞ୍ଚିସ୍, ତା ଆତିସ୍‌ ନା ଆବାଂ ପା ପୁଚାଦେର୍ମା; ନଙ୍ଗ୍‌ ତାଙ୍ଗ୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ପୁନାଦେରା ଆରି ତାଙ୍ଗ୍‌ ହୁଡ଼୍‌ତାଦେର୍ଣ୍ଣା ।” ");
INSERT INTO peg_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","ପିଲିପ୍‌ ଜିସୁଙ୍ଗ୍‌ ଇଚାନ୍‌, “ମାପ୍ରୁ, ମାଙ୍ଗେଙ୍ଗ୍‌ ଆବାଂ ଚଞ୍ଜ୍‌ୟା ଆୟିକିଦା, ହେଦାଂ ମା କାଜିଂ ସାରି ।” ");
INSERT INTO peg_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","ଜିସୁ ହେୱାନିଂ ଇଚାନ୍‌, “ପିଲିପ୍‌, ଏଚେକ୍‌ ଦିନ୍‌ ଆନ୍‌ ମି ହୁଦାଂ ମାନାଙ୍ଗା, ଆରେ ଏନ୍‌ ଇନାକା ନାଙ୍ଗ୍‌ ପୁଞ୍ଜୁୱାତାଦେର୍ ? ଇନେର୍‌ ନାଙ୍ଗ୍‌ ହୁଡ଼୍‍ଦାତାର୍‍ନା, ହେୱାନ୍‌ ଆବାଂ ହୁଡ଼୍‌ତାନ୍‌ନା; ମାଙ୍ଗେଙ୍ଗ୍‌ ଆବାଂ ଚଚିକିଦା ଇଞ୍ଜି ଏପେଙ୍ଗ୍‌ ଇନେସ୍‌ ଇନାଦେରା ? ");
INSERT INTO peg_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","ଆନ୍‌ ଜେ ଆବା ତାକେ ମାନାଂ ଆରି ଆବା ନା ତାକେ ମାନାନ୍‌, ଇ କାତା ଇନାକା ପାର୍ତି କିଉଦେରା ? ଆନ୍‌ ମିଙ୍ଗ୍‌ ଜେ ୱିଜ଼ୁ ବଚନ୍‌ ଇନାତ୍‌,” ହେ ସବୁ ନା ଜାର୍‌ତାଂ ଇନୁଙ୍ଗ୍, “ମାତର୍‌ ଆବା ନା ତାକେ ମାନ୍‌ଞ୍ଜି ଜାର୍‌ କାମାୟ୍‌ କିନାନା । ");
INSERT INTO peg_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","ଆନ୍‌ ଜେ ଆବା ତାକେ ମାନାଂ ଆରି ଆବା ଜେ ନା ତାକେ ମାନାନ୍‌, ନା ଇ କାତା ପାର୍ତି କିୟାଟ୍‌, ଆୱିତିସ୍‌ ନା କାମାୟ୍‌ ହୁଡ଼୍‌ଜି ପାର୍ତି କିୟାଟ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","ହାତ୍‌ପା ହାତ୍‌ପା ଆନ୍‌ ମିଙ୍ଗ୍‌ ଇଞ୍ଜ୍‌ନାଙ୍ଗା, ନା ତାକେ ଇନେର୍‌ ପାର୍ତି କିତାର୍‌, ଆନ୍‌ ଇମ୍‌ଣି ଇମ୍‌ଣି କାମାୟ୍‌ କିନାଙ୍ଗା, ହେୱାନ୍‌ ପା ହେ ସବୁ କିନାନ୍‌, ଆରେ ହେ ସବୁ ବାଟା ଆଦିକ୍‌ ଗାଜା କାମାୟ୍‌ କିନାନ୍‌, ଇନାକିଦେଂକି ଆନ୍‌ ଆବା ତାକେ ହାନାଙ୍ଗା । ");
INSERT INTO peg_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","ଆରେ, ଆବା ଇନେସ୍‌ ମାଜ଼ି ତାଙ୍ଗ୍‌ ଜାଜ୍‌ମାଲ୍‌ ପାୟା ଆନାନ୍‌, ଇଦାଂ କାଜିଂ ଏପେଙ୍ଗ୍‌ ନା ତର୍‌ଦ ଇନାକା ପା ଏନ୍ତିତିସ୍‌, ହେଦାଂ ଆନ୍‌ ହିଦ୍‌ନାଂ । ");
INSERT INTO peg_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","ଜଦି ଏପେଙ୍ଗ୍‌ ନା ତର୍‌ଦ ଇନାକାପା ବିସ୍ରେ ନାଙ୍ଗ୍‌ ଏନ୍ତାନାଦେର୍‌, ଆନ୍‌ ହେଦାଂ କିନାଙ୍ଗ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“ଜଦି ଏପେଙ୍ଗ୍‌ ନାଙ୍ଗ୍‌ ଜିଉନଦ୍‍ନାଦେର୍, ତା ଆତିସ୍‌ ନା ବଲ୍‌ ସବୁ ମାନିକିନାଦେର୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","ଆରେ, ଆନ୍‌ ଆବାଂ ଗୱାରି କିନାଂ, ଆରେ ମି ହୁଦାଂ ସବୁ ଦାନ୍‌ ମାନି କାଜିଂ ହେୱାନ୍‌ ମିଙ୍ଗ୍‌ ଆରେ ରକାନ୍‌ ଉପ୍‌କାର୍‌ କିଦ୍‌ନାକାନିଂ ହିଦ୍‌ନାନ୍‌, ");
INSERT INTO peg_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","ହେୱାନ୍‌ ଆନାନା ହାତ୍‌ପାନି ଜିବୁନ୍ତିଂ ହିଦ୍‌ନାନ୍‌ । ପୁର୍ତି ତାଙ୍ଗ୍‌ ଇଡ୍‌ଦେଂ ଆଡୁତ୍‌, ଇନାକିଦେଂକି ପୁର୍ତି ତାଙ୍ଗ୍‌ ହୁଡ଼ୁତ୍‌ କି ପୁନୁତ୍; ମାତର୍‌ ଏପେଙ୍ଗ୍‌ ତାଙ୍ଗ୍‌ ପୁନାଟ୍‌, ଇନାକିଦେଂକି ହେୱାନ୍‌ ମି ହୁକେ ମାନ୍‍ଗାନାନ୍‍, ଆରେ ହେୱାନ୍‌ ମି ୱାସ୍କିତ ମାନ୍‌ଗାନାନ୍ ।” ");
INSERT INTO peg_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“ଆନ୍‌ ହାଚି ପାଚେ ମିଙ୍ଗ୍‌ ଟୁରା ହିମ୍‌ଣା କିଜ଼ି ପିସ୍ତି ହାଞ୍ଜୁଙ୍ଗ୍, ଆନ୍‌ ମି ତାକେ ମାସ୍‌ଦି ୱାନାଙ୍ଗ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","ଅଲପ୍‍ ମାତର୍‌ ସମୁ ମାନାତ୍‌, ପୁର୍ତି ନାଙ୍ଗ୍‌ ଆରେ ହୁଡ଼୍‍ଦୁତ୍‌; ମତର୍‌ ଏପେଙ୍ଗ୍‌ ନାଙ୍ଗ୍‌ ହୁଡ଼୍‌ଦାନାଦେର୍, ଇନାକିଦେଂକି ଆନ୍‌ ଜିତାକାଂ, ଏପେଙ୍ଗ୍‌ ପା ଜିତାକାଦେର୍ ମାନାଦେର୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","ଆନ୍‌ ଜେ ନା ଆବା ତାକେ ଆରେ ଏପେଙ୍ଗ୍‌ ଜେ ନା ତାକେ ଆରି ଆନ୍‌ ମି ତାକେ ମାନାଂ, ଇଦାଂ ହେ ଦିନ୍‌ ୱାତିସ୍‌ ଏପେଙ୍ଗ୍‌ ପୁନାଦେର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","“ଇନେର୍‌ ନା ବଲ୍‌ ସବୁ ୱେନ୍‌ଞ୍ଜି ମାନିକିନାର୍‌, ହେୱାନ୍‌ ନାଙ୍ଗ୍‌ ଜିଉ ନଦ୍‌ନାନ୍‌, ଆରେ ଇନେର୍‌ ନାଙ୍ଗେଙ୍ଗ୍‌ ଜିଉ ନଦ୍‌ନାନ୍‌, ନା ବାୱା ତାଙ୍ଗ୍‌ ଜିଉ ନନାନ୍, ଆରେ ଆନ୍‌ ହେୱାନିଂ ଜିଉ ନନାଂ ଆରି ତା ଲାଗାଂ ଜାର୍‌ତିଂ ହପ୍‌ନାଙ୍ଗ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","ଜିହୁଦା, ଇସ୍କାରିୟତିୟ ଜିହୁଦା ହିଲ୍‌ୱାତାନ୍‌ ହେୱାନିଂ ୱେନ୍‌ବାତାନ୍‌, “ଏ ମାପ୍ରୁ, ଇଦାଂ ଇନେସ୍‌ ଆନାତ୍‌ ? ଜାର୍‌ତିଂ ପୁର୍ତି ତାକେ ୱେଚ୍‌ୟାୱାଦାଂ ମା ତାକେ ଇନେସ୍‌ ହପ୍‍ନାଦେର୍‌ ?” ");
INSERT INTO peg_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","ଜିସୁ ହେୱାନିଂ ଉତର୍‌ ହିତାନ୍‌, “ଜଦି ଇନେର୍‌ ନାଙ୍ଗ୍‌ ଜିଉନଦ୍‌ନାନ୍‌, ତା ଆତିସ୍‌ ହେୱାନ୍‌ ନା ବଚନ୍‌ ମାନିକିନାନ୍, ଆରେ ନା ଆବା ହେୱାନିଂ ଜିଉ ନନାନ୍, ଆରେ ଆପେଂ ହେ କଚଣ୍‌ ୱାଜ଼ି ଆବା ଆରି ଆନ୍‌ ବାହା କିନାପ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","ଇନେର୍‌ ନାଙ୍ଗ୍‌ ଜିଉ ନଦୁନ୍‌, ହେୱାନ୍‌ ନା ବଚନ୍‌ ମାନିକିଉନ୍‌, ଆରେ ଇମ୍‌ଣି ବଚନ୍‌ ଏପେଙ୍ଗ୍‌ ୱେନାଦେରା, ହେଦାଂ ନାଦାଂ ଆକାୟ୍‌, ମତର୍‌ ନା ପକ୍ତିତି ମୁଣିକା ଆବାତି ।” ");
INSERT INTO peg_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“ଆନ୍‌ ମି ଲାହାଙ୍ଗ୍‌ ମାନ୍‌ଞ୍ଜି ମାନ୍‌ଞ୍ଜି ମିଙ୍ଗ୍‌ ଇ ୱିଜ଼ୁ କାତା ଇନ୍‌ଞ୍ଚାଙ୍ଗ୍‌ନ୍ନା । ");
INSERT INTO peg_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","ହେ ଉପ୍‌କାର୍‌ କିଦ୍‍ନାକାନ୍, ଇଚିସ୍‌ ଇମ୍‌ଣି ପୁଇପୁୟା ଜିବୁନ୍‍ତିଂ ବାୱା ନା ତର୍‌ଦ ପକ୍ତାନାନ୍‌, ହେୱାନ୍‌ ମିଙ୍ଗ୍‌ ୱିଜ଼ୁ ବିସ୍ରେ ହିକ୍ୟା ହିଦ୍‌ନାନ୍‌, ଆରେ ଆନ୍‌ ମିଙ୍ଗ୍‌ ଇନା ଇନାକା ଇଞ୍ଚାଙ୍ଗ୍‌ନ୍ନା, ହେ ସବୁ ମିଙ୍ଗେଙ୍ଗ୍‌ ଏତୁକିୟ୍‌ କିଦ୍‌ନାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“ଆନ୍‌ ମିଙ୍ଗ୍‌ ନା ସୁସ୍ତା ହିଜ଼ି ହାନାଙ୍ଗା, ନା ଜାର୍‌ତି ସୁସ୍ତା ମିଙ୍ଗ୍‌ ଦାନ୍‌ କିଦ୍‌ନାଙ୍ଗା; ପୁର୍ତି ଇନେସ୍‌କି ଦାନ୍‌ କିଦ୍‌ନାତ୍‌, ଆନ୍‌ ମିଙ୍ଗ୍‌ ହେ ଲାକେ ଦାନ୍‌ ହିଦୁଙ୍ଗା । ମି ମାନ୍‌ ଦୁକ୍‌ କି ପାଣ୍ଡ୍ରା ଆମେତ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","“ଆନ୍‌ ଜେ ହାନାଙ୍ଗା ଆରି ମି ତାକେ ମାସ୍‌ଦି ୱାନାଙ୍ଗ୍‌, ନା ଇ କାତା ତ ୱେଚାଦେର୍ଣ୍ଣା । ଜଦି ଏପେଙ୍ଗ୍‌ ନାଙ୍ଗ୍‌ ଜିଉନଜ଼ି ମାନ୍‍ଞ୍ଚିସ୍, ତା ଆତିସ୍‌ ଆନ୍‌ ନା ଆବା କଚଣ୍‌ ହାନାଙ୍ଗା ଇଞ୍ଜି ୱାରି କିତାଦେର୍‌ମା, ଇନାକିଦେଂକି ବାୱା ନା ତାଙ୍ଗ୍‌ ଗାଜାକାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","ଆରେ, ହେଦାଂ ଗିଟାଆନି ସମୁତ ଏପେଙ୍ଗ୍‌ ଇନେସ୍‌ ପାର୍ତି କିନାଦେର୍‌, ଇଦାଂ କାଜିଂ ହେଦାଂ ଗିଟାଆନି ଆଗେ ଆନ୍‌ ନଙ୍ଗ୍‌ ମିଙ୍ଗ୍‌ ୱେଚ୍‍ଚାତାଂନା । ");
INSERT INTO peg_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","ଆନ୍‌ ମି ଲାହାଙ୍ଗ୍‌ ଆରେ ଆଦିକ୍‌ ସମୁ କାତାବାର୍ତା କିଦୁଙ୍ଗ୍, ଇନାକିଦେଂକି ପୁର୍ତିନି ମୁଡ଼୍‌ଦାକାନ୍‌ ୱାନାନା; ଆରେ, ନା ତାକେ ତାଦାଙ୍ଗ୍‌ ଇନାକା ହିଲୁତ୍‌; ");
INSERT INTO peg_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","ମାତର୍‌ ଆନ୍‌ ଜେ ବାୱାଙ୍ଗ୍‌ ଜିଉ ନନାଂ ଆରି ବାୱାତି ବଲ୍‌ ଲାହାଂ କାମାୟ୍‌ କିନାଙ୍ଗ୍‌, ଇଦାଂ ଇନେସ୍‌ ପୁର୍ତି ପୁଞ୍ଜେଙ୍ଗ୍‌ ଆଡ଼୍‌ଦାତାତ୍‌, ଇଦାଂ କାଜିଂ ଇ ଲାକେ ପୁଞ୍ଜ୍‌ନାତ୍‌ ।” “ୱାଡୁ, ଆସେଙ୍ଗ୍‌ ଇ ବାହାତାଂ ହାନାସ୍ ।” ");
INSERT INTO peg_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“ଆନ୍‌ ହାତ୍‌ପା ଅଙ୍ଗୁର୍‌ କୁଡ଼ି, ଆରେ ନା ଆବା କାମ୍‌ଲିୟା । ");
INSERT INTO peg_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","ନା ତାକେ ମାନି ଇମ୍‌ଣି କେନ୍ଦାଂ ପାଡ଼୍‌ ଆହ୍‌ୱିତିସ୍‌, ହେଦାଂ ହେୱାନ୍‌ କାଦ୍‍ଦି ତୁହିନାନ୍‍; ଆରେ ଇମ୍‌ଣି କେନ୍ଦାଂ ପାଡ଼୍‌ ଆହ୍‌ନାତ୍‌, ଆଦିକ୍‌ ପାଡ଼୍‌ ଆହ୍‌ନି କାଜିଂ ହେୱାନ୍‌ ହେଦାଂ ନିର୍ମଲ୍‌ କିନାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ଇମ୍‌ଣି ବେରଣ୍‌ ଇନ୍‌ଞ୍ଚାଙ୍ଗ୍‌ନ୍ନା, ହେଦାଂ କାଜିଂ ଏପେଙ୍ଗ୍‌ ସକଟ୍‌ ଆତାଦେର୍ଣ୍ଣା । ");
INSERT INTO peg_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","ନା ତାକେ ମାନାଟ୍‌, ହେବେ ଆନ୍‌ ମି ତାକେ ମାନାଂ । କେନ୍ଦାଂ ଇନେସ୍‌ ଅଙ୍ଗୁର୍‌ କୁଡ଼ିତ ମାନ୍‌ୱିତିସ୍‌ ଜାର୍‌ତାଂ ପାଡ଼୍‌ ଆସ୍ତେଙ୍ଗ୍‌ ଆଡୁତ୍‌, ହେ ଲାକେ ଏପେଙ୍ଗ୍‌ ପା ନା ତାକେ ମାନ୍‌ୱିତିସ୍‌ ପାଡ଼୍‌ ଆସ୍ତେଙ୍ଗ୍‌ ଆଡୁଦେର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“ଆନ୍‌ ଅଙ୍ଗୁର୍‌ କୁଡ଼ି, ଏପେଙ୍ଗ୍‌ କେନ୍ଦାଂ, ଇନେର୍‌ ନା ତାକେ ମାନ୍‍ଙ୍ଗାନାନ୍ ଆରି ଆନ୍‌ ଇନେର୍‌ ତାକେ ମାନାଂ, ହେୱାନ୍‌ ବେସି ପାଡ଼୍‌ ଆହ୍‌ନାନ୍‌; ଇନାକିଦେଂକି ନା ପିସ୍ତି ଏପେଙ୍ଗ୍‌ ଇନାକା କିଦେଙ୍ଗ୍‌ ଆଡୁଦେର୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","ଇନେର୍‌ ଏଚେକାଡ଼୍‌ଦ ନା ତାକେ ମାନ୍‌ୱିତିସ୍‌, ତା ଆତିସ୍‌ ହେଦାଂ କାତ୍‌ଦି କେନ୍ଦାଂ ଲାକେ ବାର୍ତ ତୁହିୟା ଆନାତ୍‌ ଆରି ୱାଜ୍‍ଜି ହାନାତ୍‌, ଆରେ ଲକୁ ହେୱାକାଂ ରୁଣ୍ଡାୟ୍‌ କିଜ଼ି ନାଣିତ ତୁହିନାର୍ ଆରି ହେୱାଙ୍ଗ୍‌ କାଡ଼୍‍ଜିହାନିକ୍‍ ।” ");
INSERT INTO peg_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","“ଏପେଙ୍ଗ୍‌ ଜଦି ନା ତାକେ ମାନାଦେର୍‌, ଆରେ ନା ବଚନ୍‌ ମି ତାକେ ମାଚିସ୍‌, ତା ଆତିସ୍‌ ଇମ୍‌ଣି ବିସ୍ରେ ଇଚା କିନାଦେର୍‌, ହେଦାଂ ଏନାଟ୍‌, ଆରେ ମି କାଜିଂ ହେଦାଂ ହିଦ୍‍ନାନ୍‍ । ");
INSERT INTO peg_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","ଏପେଙ୍ଗ୍‌ ବେସି ପାଡ଼୍‌ ଆସ୍ତିସ୍‌ ନା ଆବା ଜାଜ୍‌ମାଲ୍‌ ପାୟା ଆନାନ୍‌, ଆରେ ଏନେଙ୍ଗ୍‌ ନା ହାତ୍‌ପା ଚେଲା ଆନାୟ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","ଆବା ଇନେସ୍‌ ନାଙ୍ଗ୍‌ ଜିଉନତାନ୍‌ନା, ଆନ୍‌ ପା ହେ ଲାକେ ମିଙ୍ଗେଙ୍ଗ୍‌ ଜିଉନତ୍‍ତାଙ୍ଗ୍‌ନା; ନା ଜିଉନଦ୍‍ନିତ ତିର୍‌ ଆଜ଼ି ମାନାଟ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","ଆନ୍‌ ଇନେସ୍‌ ନା ଆବାତି ବଲ୍‌ ମାନି କିଜ଼ି ତାଦାଙ୍ଗ୍‌ ଜିଉନନିତାକେ ତିର୍‌ ଆଜ଼ି ମାନାଙ୍ଗା, ହେ ଲାକେ ଏପେଙ୍ଗ୍‌ପା ଏଚେକାଡ଼୍‌ଦ ନା ବଲ୍‌ ମାନିକିନାଦେର୍‍, ତା ଆତିସ୍‌ ନା ଜିଉନନିତାକେ ତିର୍‌ ଆଜ଼ି ମାନାଦେର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“ନା ୱାରି ଇନେସ୍‌ ମି ତାକେ ମାନାତ୍‌, ଆରେ ମି ୱାରି ଇନେସ୍‌ ବାର୍ତି ଆନାତ୍‌, ଇଦାଂ କାଜିଂ ଆନ୍‌ ଇ ୱିଜ଼ୁ ମିଙ୍ଗେଙ୍ଗ୍‌ ୱେଚ୍‍ଚାତାଙ୍ଗ୍ । ");
INSERT INTO peg_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","ଆନ୍‌ ଇନେସ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ଜିଉନତ୍‍ତାଂନ୍ନା, ଏପେଙ୍ଗ୍‌ ରକାନ୍‌ ଆରେ ରକାନିଂ ବିତ୍ରେ ଜିଉନବାଆଡୁ, ଇଦାଂ ନା ବଲ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","ଜାର୍‌ ହାଙ୍ଗ୍‌ଦାକାରିଂ କାଜିଂ ଜାର୍‌ ଜିବୁନ୍‌ ହିନି ବାଟା ଇନେର୍‌ତି ଆରେ ଆଦିକ୍‌ ଗାଜା ଜିଉନନାକା ହିଲୁତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ଇମ୍‌ଣି ବଲ୍‌ ହିଦ୍‍ନାଙ୍ଗା, ହେଦାଂ ଜଦି ମାନିକିନାଦେର୍‌, ତେବେ ଏପେଙ୍ଗ୍‌ ନା ହାଙ୍ଗ୍‌ଦାକାଦେର୍ । ");
INSERT INTO peg_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ଆରେ ଆଡ଼ିଏନ୍‌ ଇଞ୍ଜି ଇଞ୍ଜୁଙ୍ଗା, ଇନାକିଦେଂକି ହାଉକାର୍‌ ଇନାକା କିନାନ୍‌, ଆଡ଼ିଏନ୍‌ ହେଦାଂ ପୁନୁନ୍, ମାତର୍‌ ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ହାଙ୍ଗ୍‌ଦାକାର୍‌ ଇଞ୍ଜି ଇଞ୍ଚାଙ୍ଗ୍‌ନ୍ନା, ଇନାକିଦେଂକି ଆନ୍‌ ନା ଆବାତାଂ ଇନା ଇନାକା ୱେଚାଙ୍ଗ୍‌ନା, ହେ ସବୁ ମିଙ୍ଗେଙ୍ଗ୍‌ ୱେଚ୍‍ଚାତାଙ୍ଗ୍ । ");
INSERT INTO peg_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","ଏପେଙ୍ଗ୍‌ ନାଙ୍ଗ୍‌ ବାଚି କିଦ୍‍ୱାତାଦେର୍ଣ୍ଣା, ମାତର୍‌ ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ବାଚି କିତ୍‍ତାଙ୍ଗ୍‍ନ୍ନା, ଆରେ ଏପେଙ୍ଗ୍‌ ଇନେସ୍‌ ହାଲ୍‌ଜି ପାଡ଼୍‌ ଉବ୍‌ଜାଣ୍‌ କିନାଦେର୍‌ ଆରି ମିୱାଙ୍ଗ୍ ପାଡ଼୍‌ ତିର୍‌ମାନ୍‌ଙ୍ଗାନାତ୍, ଇଦାଂ କାଜିଂ ମିଙ୍ଗେଙ୍ଗ୍‌ ବାଚି କିତ୍‍ତାଙ୍ଗ୍‍ନ୍ନା । ହେବେ ଏପେଙ୍ଗ୍‌ ନା ତର୍‌ଦ ଆବାଂ ଇନାକା ଏନ୍‌ନାଦେର୍‌, ହେୱାନ୍‌ ହେଦାଂ ମିଙ୍ଗେଙ୍ଗ୍‌ ହିଦ୍‌ନାନ୍‌; ");
INSERT INTO peg_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","ଏପେଙ୍ଗ୍‌ ଇନେସ୍‌ ରକାନ୍‌ ଆରେ ରକାନିଂ ଜିଉନୱାଟ୍‌, ଇଦାଂ କାଜିଂ ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ଇ ୱିଜ଼ୁ ବଲ୍‌ ହିଦ୍‍ନାଙ୍ଗା ।” ");
INSERT INTO peg_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“ଜଦି ମିଙ୍ଗେଙ୍ଗ୍‌ ପୁର୍ତି ଗିଣ୍‌ କିତ୍‍ତିସ୍, ତେବେ ମିଙ୍ଗେଙ୍ଗ୍‌ ଗିଣ୍‌ କିଦ୍‌ନି ଆଗେ ହେଦାଂ ଜେ ନାଙ୍ଗ୍‌ ଗିଣ୍‌ କିତ୍‌ତାତ୍‌ନ୍ନା, ଇଦାଂ ପୁନାଟ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","ଏପେଙ୍ଗ୍‌ ଜଦି ପୁର୍ତିତାଂ ଉବ୍‌ଜାଣ୍‌ ଆତାଦେର୍ମା, ତେବେ ପୁର୍ତି ମିଙ୍ଗେଙ୍ଗ୍‌ ଜାର୍‌ ଲକୁର୍ ପୁଞ୍ଜି ଜିଉ ନତାତ୍ମା; ମାତର୍‌ ଏପେଙ୍ଗ୍‌ ପୁର୍ତିତାଂ ଉବ୍‌ଜାଣ୍‌ ଆୱାତାୟ୍‌ନା, ନଲେ ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ପୁର୍ତିତାଂ ବାଚି କିତ୍‌ତାତ୍‌ନ୍ନା, ଇଦାଂ କାଜିଂ ପୁର୍ତି ମିଙ୍ଗ୍‌ ଗିଣ୍‌ କିଦ୍‌ନାତ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","ଆଡ଼ିଏନ୍‌ ଜାର୍‌ ହାଉକାର୍‍ତାଙ୍ଗ୍ ଗାଜା ଆକାୟ୍‌, ଆନ୍‌ ମିଙ୍ଗ୍‌ ଇ ଇମ୍‌ଣି ବଚନ୍‌ ୱେଚ୍‍ଚାତାଙ୍ଗ୍‍ନା, ହେଦାଂ ଏତୁ କିୟାଟ୍‌ । ହେୱାର୍‌ ଜଦି ନାଙ୍ଗ୍‌ ଇଣ୍‌ କିତ୍‌ତାର୍‌ନା, ତା ଆତିସ୍‌ ମିଙ୍ଗ୍‌ ପା ଇଣ୍‌ କିଦ୍‌ନାର୍‌, ହେୱାର୍‌ ଜଦି ନା ବଚନ୍‌ ମାନିକିତାର୍ଣ୍ଣା, ତା ଆତିସ୍‌ ମି ବଚନ୍‌ ପା ମାନିକିନାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","ମାତର୍‌ ହେୱାର୍‌ ନା ପକ୍ତି ହାଉକାର୍‍ତିଂ ପୁନ୍‌ୱାଦାଂ ମାଚିଲେ ନା ତର୍‌ କାଜିଂ ମିଙ୍ଗ୍‌ ପା ଇ ସବୁ କିଦ୍‌ନାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","ଜଦି ଆନ୍‌ ୱାଜ଼ି ହେୱାରିଂ ଇନ୍‌ୱାଦାଂ ମାଚିସ୍‌, ତା ଆତିସ୍‌ ହେୱାର୍‌ତି ପାପ୍‌ ଆୱାତାତ୍ମା; ମାତର୍‌ ନଙ୍ଗ୍‌ ହେୱାର୍‌ତି ପାପ୍‌ ବିସ୍ରେ ହେୱାର୍‌ ଇନେର୍‌ ପା ଚଚା କିଦେଙ୍ଗ୍‌ ଆଡୁର୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","ଇନେର୍‌ ନାଙ୍ଗ୍‌ ଗିଣ୍‌ କିଦ୍‌ନାର୍‌, ହେୱାନ୍‌ ନା ଆବାଂ ପା ଗିଣ୍‌ କିନାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","ଇମ୍‌ଣି କାମାୟ୍‌ ୱିଜ଼ୁ ଆରେ ଇନେର୍‌ କିତାତାର୍ଣ୍ଣା, ଆନ୍‌ ଜଦି ହେ ୱିଜ଼ୁ ହେୱାର୍‌ ବିତ୍ରେ କିୱାଦାଂ ମାଚିସ୍‌, ତା ଆତିସ୍‌ ହେୱାର୍‌ତି ପାପ୍‌ ଆୱାତାତ୍ମା; ମାତର୍‌ ନଙ୍ଗ୍‌ ହେୱାର୍‌ ହୁଡ଼୍‌ତାର୍‌ନା, ଆରେ ନାଙ୍ଗ୍‌ ଆରି ନା ଆବା ରିୟାରିଂ ଗିଣ୍‌ କିତ୍‌ତାର୍‌ନା । ");
INSERT INTO peg_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","ମତର୍‌ ହେୱାର୍‌ ବିନାସୁନ୍‍ରେ ନାଙ୍ଗ୍‌ ଗିଣ୍‌ କିତ୍‍ତାର୍, ହେୱାର୍‌ତି ମସାତି ବିଦିତ ଲେକାଆତି ଇ ବଚନ୍‌ ଇନେସ୍‌ ପୁରା ଆନାତ୍‌, ଇଦାଂ କାଜିଂ ଏଲେଙ୍ଗ୍‌ ଗିଟା ଆନାତା । ");
INSERT INTO peg_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“ଆବାତି ତାକେଣ୍ଡାଂ ଆନ୍‌ ମି ଲାଗାଂ ଇମ୍‌ଣି ଉପ୍‌କାର୍‌ କିଦ୍‌ନାକାନିଂ ପକ୍ତାନାଂ, ଆବା ତାକେଣ୍ଡାଂ ହତି ହେ ହାତ୍‌ପାନି ଜିବୁନ୍‌ ୱାତିସ୍ ନା ବିସ୍ରେ ସାକି ହିଦ୍‌ନାନ୍‌; ");
INSERT INTO peg_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","ଆରେ, ଏପେଙ୍ଗ୍‌ ପା ସାକି, ଇନାକିଦେଂକି ଏପେଙ୍ଗ୍‌ ଆରମ୍‌ତାଂ ନା ହୁକେ ମାନାଦେରା ।” ");
INSERT INTO peg_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“ଏପେଙ୍ଗ୍‌ ଇନେସ୍‌ ପାର୍ତି କିଉଦେର୍‌, ଇଦାଂ କାଜିଂ ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ଇ କାତା ଇଞ୍ଜ୍‌ନାଙ୍ଗା । ");
INSERT INTO peg_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","ମିଙ୍ଗେଙ୍ଗ୍‌ ଲକୁ ହେୱାର୍‌ କୁଟୁମ୍‌ ଇଞ୍ଜାଙ୍ଗ୍‌ ପାଗ୍ରି କିଦ୍‌ନାର୍‌ । ଏଲେଙ୍ଗ୍‌ବାର୍ତି ସମୁ ୱାନାତା ଏଚେକାଡ଼୍‌ଦ ବାବିକିଦ୍‍ନାର୍‍ ଜେ ମିଙ୍ଗେଙ୍ଗ୍‌ ଅସ୍ତିନି କାଜିଂ ହେୱାର୍‌ ଇସ୍ୱର୍‌ତିଂ ହେବା କିନାରା । ");
INSERT INTO peg_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","ଆରେ, ହେୱାର୍‌ ଇଦାଂ ୱିଜ଼ୁ କିନାର୍‌, ଇନାକିଦେଂକି ହେୱାର୍‌ ଆବାଂ କି ନାଙ୍ଗ୍‌ ପୁଞ୍ଜ୍‍ୱାତାର୍ଣ୍ଣା । ");
INSERT INTO peg_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","ମତର୍‌ ଇ ସବୁ ଗିଟାଆନି ସମୁ ଏକାୱାତିସ୍‌, ଆନ୍‌ ଜେ ମିଙ୍ଗେଙ୍ଗ୍‌ ୱେଚ୍‍ଚି ମାନ୍‍ଞ୍ଚାଙ୍ଗ୍, ଇଦାଂ ଇନେସ୍‌ ଏପେଙ୍ଗ୍‌ ଏତୁ କିନାଦେର୍‌, ଇଦାଂ କାଜିଂ ଆନ୍‌ ଇ ୱିଜ଼ୁ କାତା ମିଙ୍ଗେଙ୍ଗ୍‌ ୱେଚ୍‍ଚାତାଂନ୍ନା ।” ");
INSERT INTO peg_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","ମାତର୍‌ ନଙ୍ଗ୍‌ ଆନ୍‌ ନା ପକ୍ତିତି ହାଉକାର୍‍ତାକେ ହାନାଙ୍ଗା, ଆରେ ଏପେଙ୍ଗ୍‌ “ଇମ୍‌ଣି ବାହାତ ହାନାୟା” ଇଞ୍ଜି ମି ବିତ୍ରେ ଇନେର୍‌ ନାଙ୍ଗ୍‌ ୱେନ୍‌ବା ଆଦୁଦେରା । ");
INSERT INTO peg_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","ମତର୍‌ ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ଇ ୱିଜ଼ୁ କାତା ଇଞ୍ଜି ମାଚିଲେ ମି ମାନ୍‌ ଦୁକ୍‌ତ ବାର୍ତି ଆତାତ୍‌ନ୍ନା । ");
INSERT INTO peg_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","ମାତର୍‌ ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ହାତ୍‌ପା ଇଞ୍ଜ୍‌ନାଙ୍ଗା, ନା ହାନାକା ମି କାଜିଂ ହାର୍‌, ଇନାକିଦେଂକି ଆନ୍‌ ହାଲ୍‍ୱିତିସ୍ ହେ ଉପ୍‌କାର୍‌ କିନାକାନ୍‌ ମି ତାକେ ୱାଉନ୍, ମତର୍‌ ଆନ୍‌ ହାଚିସ୍ ହେୱାନିଂ ମି ତାକେ ପକ୍ତାନାଂ । ");
INSERT INTO peg_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","“ହେୱାନ୍‌ ୱାଜ଼ି ପାପ୍‌, ଦାର୍ମି ଆରି ବିଚାର୍‌ ବିସ୍ରେ ପୁର୍ତିତିଂ ହାତ୍‌ପା ପାର୍ମାଣ୍‍ ହିନାନ୍‌; ");
INSERT INTO peg_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","ହେୱାନ୍‌ ୱେଚ୍‌ଚାନାନ୍‌ ଜେ ନା ତାକେ ପାର୍ତି କିୱାକାର୍‌ ନେ ପାପ୍‌; ");
INSERT INTO peg_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","ଦାର୍ମି ବିସ୍ରେ ହେୱାର୍‌ ବୁଲ୍‌ ଇନାକିଦେଂକି ଆନ୍‌ ଆବା ତାକେ ହାନାଙ୍ଗା ଆରି ଏପେଙ୍ଗ୍‌ ନାଙ୍ଗ୍‌ ଆରେ ହୁଡ଼୍‍ଦୁଦେର୍; ");
INSERT INTO peg_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","ବିଚାର୍ଣ୍ଣା ବିସ୍ରେ ହେୱାର୍‌ ବୁଲ୍‌ ଇନାକିଦେଂକି ଇ ଜଗତ୍‌ତ ମୁଡ଼୍‌ଦାକାନ୍‌ ବିଚାର୍ଣ୍ଣା ଆତାତେ ।” ");
INSERT INTO peg_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ଆଦିକ୍‌ କାତା ଇଞ୍ଜ୍‌ନାକା ମାନାତ୍‌, ମତର୍‌ ଏପେଙ୍ଗ୍‌ ନଙ୍ଗ୍‌ ହେ ସବୁ ହୁନ୍‍ଞ୍ଜେଙ୍ଗ୍ ଆଡୁଦେର୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","ମାତର୍‌ ହେୱାନ୍‌, ହାତ୍‌ପା ଜିବୁନ୍‌ ୱାତିସ୍ ହେୱାନ୍‌ ୱିଜ଼ୁ ହାତ୍‌ପା ବୁଜାଆଦେଂ ସାକ୍ତି ହିଦ୍‌ନାନ୍‌, ହେୱାନ୍‌ ଜାର୍‌ ଆଦିକାର୍‌ ସାକ୍ତିତାଂ ଇନାକା ଇଞ୍ଜୁନ୍‌ ଇସ୍ୱର୍‌ ତାକେ ଇନାକା ୱେଚାର୍‌ନା ଏଚେକ୍‌ ହେୱାନ୍‌ ଚଚ୍‌ନାନ୍‌ ଇନାକା ଗିଟା ଆଦେଂ ହାନାତା, ହେଦାଂ ମିଙ୍ଗେଙ୍ଗ୍‌ ୱେଚ୍‌ଚାନାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","ହେୱାନ୍‌ ନାଙ୍ଗ୍‌ ଜାଜ୍‌ମାଲ୍‌ ହିଦ୍‍ନାନ୍‍, ଇନାକିଦେଂକି ହେୱାନ୍‌ ନା ବିସ୍ରେ ସବୁ କାତା ଅଜ଼ି ମିଙ୍ଗେଙ୍ଗ୍‌ ଜାଣାୟ୍‌ କିଦ୍‌ନାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","ଇନା ଇନାକା ଆବାତି, ହେ ସବୁ ନାଦାଂ; ଇଦାଂ କାଜିଂ ଆନ୍‌ ଇଚାଂ, ପୁଇପୁୟା ଜିବୁନ୍‌ ହେୱାନ୍‌ ନା ବିସ୍ରେ ଅଜ଼ି ମିଙ୍ଗେଙ୍ଗ୍‌ ଜାଣାୟ୍‌ କିଦ୍‌ନାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“ମତର୍‌ ଅଲପ୍‍ ସମୁ ମାନାତ୍‌, ଏପେଙ୍ଗ୍‌ ଆରେ ନାଙ୍ଗ୍‌ ହୁଡ଼୍‍ଦୁଦେର୍‍, କେତ୍‌ଦିନ୍‌ ପାଚେ ଏପେଙ୍ଗ୍‌ ନାଙ୍ଗେଙ୍ଗ୍‌ ହୁଡ଼୍‍ଦାନାଦେର୍ ।” ");
INSERT INTO peg_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","ହେବେଣ୍ଡାଂ ତା ଚେଲାହିର୍‌ ବିତ୍ରେତାଂ ଇନେ ଇନେର୍‌ ରକାନ୍‌ ଆରେ ରକାନିଂ ଇଚାର୍‌, “ଅଲପ୍‍ ମତର୍‌ ସମୁ ମାନାତ୍‌, ଏପେଙ୍ଗ୍‌ ନାଙ୍ଗେଙ୍ଗ୍‌ ହୁଡ଼୍‍ଦୁଦେର୍, କେତ୍‌ଦିନ୍‌ ପାଚେ ଏପେଙ୍ଗ୍‌ ନାଙ୍ଗେଙ୍ଗ୍‌ ହୁଡ଼୍‍ଦାନାଦେର୍ ଆରି ଆନ୍‌ ଆବାତି ଲାଗେ ହାନାଙ୍ଗା, ଇ ଇମ୍‌ଣି କାତା ହେୱାନ୍‌ ମାଙ୍ଗେଙ୍ଗ୍‌ ଇଞ୍ଜ୍‌ନାନା, ଇଦାଂ ଇନାକା ?” ");
INSERT INTO peg_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","“ଅଲପ୍‍ ସମୁ ଇଞ୍ଜି ହେୱାନ୍‌ ଇନାକା ଇନାନ୍ନା ? ହେୱାନ୍‌ ଇନାକା ଇନାନ୍ନା, ଆପେଂ ବୁଜାଆଦେଂ ଆଡୁପା ।” ");
INSERT INTO peg_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","ହେୱାର୍‌ ତାଙ୍ଗ୍‌ ୱେନ୍‌ବେଦେଂ ଇଚା କିନାରା ଇଞ୍ଜି ପୁଞ୍ଜି ଜିସୁ ହେୱାରିଂ ଇଚାନ୍‌, “ଅଲପ୍‍ ମତର୍‌ ସମୁ ମାନାତ୍‌, ଏପେଙ୍ଗ୍‌ ନାଙ୍ଗ୍‌ ହୁଡ଼୍‍ଦୁଦେର୍, ଆରେ ରଗ ଅଲପ୍‍ ସମୁ ପାଚେ ଏପେଙ୍ଗ୍‌ ନାଙ୍ଗ୍‌ ହୁଡ଼୍‍ଦାନାଦେର୍, ଆନ୍‌ ଇ ଇମ୍‌ଣି କାତା ଇନ୍‍ଞ୍ଚାଙ୍ଗ୍, ହେ ବିସ୍ରେ ଅଜ଼ି ଏପେଙ୍ଗ୍‌ ଇନାକା ରକାନ୍‌ ରିକାର୍‌ ବେଣ୍‌ବାଟ୍‌ କିନାଦେରା ? ");
INSERT INTO peg_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","ଆନ୍‌ ହାତ୍‌ପା ମିଙ୍ଗେଙ୍ଗ୍‌ ଇଞ୍ଜ୍‌ନାଙ୍ଗା, ଏପେଙ୍ଗ୍‌ ଆଡ଼୍‌ବାନାଦେର୍‌ ଆରି ଦୁକ୍‌ କିନାଦେର୍‌, ମାତର୍‌ ପୁର୍ତି ୱାରି କିନାତ୍‌; ଏପେଙ୍ଗ୍‌ ଦୁକ୍‌ ଆନାଦେର୍‌, ମାତର୍‌ ମିଦାଙ୍ଗ୍‌ ଦୁକ୍‌ ୱାରିତାଂ ବାର୍ତି ଆନାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","କନାତ କୁଚ୍‌ଚେଂ ସମୁ ଏକାୱାତିସ୍‌ କଗ୍‌ଲେ ପାୟା ଆନାତ୍‌; ମାତର୍‌ ହେଦେଲ୍‌ ହିମ୍‍ଣା ଗାଟାଆତି ପାଚେ ପୁର୍ତିତ ରକାନ୍‌ ମାନାୟ୍‌ ଜଲମ୍‌ ଆତାନ୍ନା, ଇ ୱାରି କାଜିଂ ଆରେ କସ୍ଟତିଂ ଏତୁ କିଉତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","ହେ ଲାକେ ଏପେଙ୍ଗ୍‌ ନଙ୍ଗ୍‌ ଦୁକ୍‌ ପାୟାଆନାଦେରା, ମାତର୍‌ ଆନ୍‌ ଆରେ ରଗ ମିଙ୍ଗେଙ୍ଗ୍‌ ଚଞ୍ଜିୟାଆଦ୍‌ନାଂ, ଆରେ ମିଦାଙ୍ଗ୍‌ ୱାସ୍କିତାଂ ୱାର୍‌ୟା ଆନାତ୍‌ ଆରି ଇନେର୍‌ ମିତାଙ୍ଗ୍ ମିଙ୍ଗେଙ୍ଗ୍‌ ୱାରି ଜେଲ୍‌ଜି ଅଦୁର୍ ।” ");
INSERT INTO peg_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","“ହେ ଦିନ୍‌ ନାଙ୍ଗ୍‌ ଇନାକା ୱେନ୍‌ବା ଆଦୁଦେର୍‌ । ହାତ୍‌ପା ହାତ୍‌ପା ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ଇଞ୍ଜ୍‌ନାଙ୍ଗା, ଜଦି ଏପେଙ୍ଗ୍‌ ଆବାଂ ଇନାକାପା ଏନ୍‌ନାଦେର୍‌, ବାଟିଙ୍ଗ୍‌ ନା ତର୍‌ଦ ହେୱାନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ହେଦାଂ ହିଦ୍‌ନାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","ଇ ପାତେକ୍‌ ଏପେଙ୍ଗ୍‌ ନା ତର୍‌ଦ ଇନାକା ଏନ୍ତାୱାତାଦେର୍ଣ୍ଣା, ନଙ୍ଗ୍‌ ଏନାଟ୍‌ ଏପେଙ୍ଗ୍‌ ହେଦାଂ ପାୟାନାଦେର୍‌ ମିଦାଙ୍ଗ୍‌ ୱାରି ଇନେସ୍‌ ବାର୍ତି ଆନାତ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ୱାଚ୍‍କା ଚଚ୍‍ଚି ଇ ସବୁ କାତା ଇଞ୍ଚାଙ୍ଗ୍‌ନ୍ନା; ସମୁ ୱାନାତା, ଏଚେକାଡ଼୍‌ଦ ଆନ୍‌ ଆରେ ୱାଚ୍‍କାଙ୍ଗ୍‍ ଚଚ୍‍ଚି ମିଙ୍ଗେଙ୍ଗ୍‌ ୱେଚ୍‍ଚୁଙ୍ଗ୍, ମାତର୍‌ ଆବାତି ବିସ୍ରେ ପୁଟ୍‍ତେରଚେ ମିଙ୍ଗେଙ୍ଗ୍‌ ଜାଣାୟ୍‌ କିଦ୍‍ନାଂ । ");
INSERT INTO peg_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","ହେ ଦିନ୍‌ ଏପେଙ୍ଗ୍‌ ନା ତର୍‌ଦ ତାଙ୍ଗେଙ୍ଗ୍‌ ଏନ୍ତାନାଦେର୍‌, ଆରେ, ଆନ୍‌ ଜେ ମିଦାଙ୍ଗ୍‌ ପାକ୍ୟାତ ଆବାଂ ଗୱାରି କିନାଙ୍ଗ୍‌, ଇଦାଂ ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ଇଞ୍ଜୁଙ୍ଗା; ");
INSERT INTO peg_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","ଇନାକିଦେଂକି ଆବା ନିଜେ ମିଙ୍ଗେଙ୍ଗ୍‌ ଜିଉନଦ୍‍ନାନ୍, ଲାଗିଂ ଏପେଙ୍ଗ୍‌ ନାଙ୍ଗେଙ୍ଗ୍‌ ଜିଉନଦ୍‍ନାଦେରା ଆରି ଆନ୍‌ ଜେ ଇସ୍ୱର୍‌ ତାକେଣ୍ଡାଂ ୱାତାଙ୍ଗ୍‍ନା, ହେଦାଂ ଏପେଙ୍ଗ୍‌ ପାର୍ତି କିତାଦେର୍ଣ୍ଣା । ");
INSERT INTO peg_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","ଆନ୍‌ ଆବାତାଂ ଜଗତ୍‍ତାକେ ୱାତାଙ୍ଗ୍‍ନା; ଆରେ ରଗ ଆନ୍‌ ପୁର୍ତି ପିସ୍ତି ଆବା ତାକେ ହାନାଙ୍ଗା ।” ");
INSERT INTO peg_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","ଇ କାତା ୱେନ୍‌ଞ୍ଜି ଚେଲାହିର୍‌ ଇଚାର୍‌, “ହୁଡ଼ା, ନଂ ଏନ୍‌ ରାକୁକିଜ଼ି ୱେଚ୍‍ଚାନାୟା ଆରି ୱାଚ୍‍କା ଚଚ୍‍ଚି କାତା ଆରେ ଇନୁୟା । ");
INSERT INTO peg_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","ନଙ୍ଗ୍‌ ଆପେଂ ଇଦାଂ ପୁନାପ୍‌ ଜେ ଏନ୍‌ ଜେ ସବୁ ବିସ୍ରେ ପୁନାୟ୍‌ ଆରେ ଇନେରିଂ ୱେନ୍‌ବେଦେଂ ଲଡ଼ା ଆକାୟ୍‌, ହେଦାଂ ନଙ୍ଗ୍‌ ଆପେଂ ପୁଚାପ୍; ଇସ୍ୱର୍‌ ତାକେଣ୍ଡାଂ ଏନ୍‌ ୱାତାୟ୍‍ନ୍ନା ଇଞ୍ଜି ଆପେଂ ଇଦାଂ ହୁକେ ପାର୍ତି କିନାପା ।” ");
INSERT INTO peg_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","ଜିସୁ ହେୱାରିଂ ଉତର୍‌ ହିତାନ୍‌, “ଏପେଙ୍ଗ୍‌ ଇନାକା ନଙ୍ଗ୍‌ ପାର୍ତି କିନାଦେରା କି ? ");
INSERT INTO peg_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","ହୁଡ଼ାଟ୍‌, ସମୁ ୱାନାତା, ଆଁ, ୱାତାତେ, ଏଚେକାଡ଼୍‌ଦ ଏପେଙ୍ଗ୍‌ ଚିନ୍‍ବିନ୍‍ ଆଜ଼ି ୱିଜ଼ାକାଦେର୍ ଜାର୍‌ ଜାର୍‌ ଇଞ୍ଜ ହନ୍‍ଚି ହାନାଦେର୍, ଆରେ ନାଙ୍ଗେଙ୍ଗ୍‌ ରୱାନିଂ ପିସ୍ତି ହାନାଦେର୍; ଆତିସ୍‌ପା ରକାଂ ଆକାୟ୍‌, ଇନାକିଦେଂକି ଆବା ନା ହୁକେ ମାନାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","ଏପେଙ୍ଗ୍‌ ଇନେସ୍‌ ନା ତାକେ ମାନ୍‌ଞ୍ଜି ସୁସ୍ତା ପାୟା ଆଡୁ, ଇଦାଂ କାଜିଂ ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ଇ ସବୁ ବିସ୍ରେ ଇନ୍‌ଞ୍ଚାଙ୍ଗ୍‌ନ୍ନା । ପୁର୍ତିତ ମି କାଜିଂ ଦୁକ୍‌ ମାନାତ୍‌, ମାତର୍‌ ସାସ୍‌ ଆହାଟ୍‌; ଆନ୍‌ ପୁର୍ତିତିଂ ଜିଣା ଆତାଙ୍ଗ୍‌ନା ।” ");
INSERT INTO peg_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","ଜିସୁ ଇ ୱିଜ଼ୁ ବେରଣ୍‌ ଇଞ୍ଜି ସାର୍ଗେନିପ ଜପି ହୁଡ଼୍‌ଜି ଇଚାନ୍‌, “ଆବା, ସମୁ ଏକା ୱାତାତେ; ନି ମାଜ଼ିଙ୍ଗ୍‌ ଜାଜ୍‌ମାଲ୍‌ କିୟା, ଇନେସ୍‌ ମାଜ଼ି ନିଙ୍ଗେଙ୍ଗ୍‌ ପାଣ୍‌ କିଦ୍‌ନାନା, ");
INSERT INTO peg_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","ଏପେଙ୍ଗ୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ୱିଜ଼ାର୍‌ ମାନାୟାରିଂ ଆଦିକାର୍‌ ହିତାୟ୍‌ନା, ହେୱେରିଂ ୱିଜ଼୍‌ୱି ଜିବୁନ୍‌ ହିଦେଂ ଇଞ୍ଜି ତାଙ୍ଗେଙ୍ଗ୍‌ କେଇଦ ୱିଜ଼ୁ ବଜ୍‌ ଜପି ଆଦିକାର୍‌ ହିତାଦେର୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","ଆରେ, ରକାନ୍‌ ମତର୍‌ ହାତ୍‌ପା ଇସ୍ୱର୍‌ ଜେ, ଏନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ଆରି ମି ପକ୍ୟାତାକାନ୍‌ ଜିସୁ କ୍ରିସ୍ଟଙ୍ଗ୍‌ ପୁନାକା ନେ ୱିଜ଼୍‌ୱି ଜିବୁନ୍‌ ଆନାନ୍‌, ");
INSERT INTO peg_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","ଏପେଙ୍ଗ୍‌ ନାଙ୍ଗେଙ୍ଗ୍‌ ଇମ୍‌ଣି କାମାୟ୍‌ କିଦେଙ୍ଗ୍‌ ହିତ୍‌ତାଦେର୍ଣ୍ଣା, ହେଦାଂ ଆନ୍‌ ୱିସ୍ତି ପୁର୍ତିତ ମିଙ୍ଗେଙ୍ଗ୍‌ ଜାଜ୍‌ମାଲ୍‌ କିଦ୍‌ନାଙ୍ଗା । ");
INSERT INTO peg_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","ଆରେ ନଙ୍ଗୟ୍‌ ଏ ଆବା, ପୁର୍ତିନି ଉବ୍‌ଜାଣ୍‌ ଆଗେ ମି ହୁଦାଂ ନା ଇମ୍‌ଣି ପାଣ୍‌ ମାଚାତ୍‌, ତା ପାଚେ ଏପେଙ୍ଗ୍‌ ନାଙ୍ଗେଙ୍ଗ୍‌ ନି ଜାଜ୍‌ମାଲ୍‌ ନାଙ୍ଗ୍‌ ହିଦା ।” ");
INSERT INTO peg_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“ଏପେଙ୍ଗ୍‌ ନାଙ୍ଗେଙ୍ଗ୍‌ ପୁର୍ତି ବିତ୍ରେ ଇମ୍‌ଣି ମାନାୟାରିଂ ଦାନ୍‌ କିନାଦେର୍‌, ଆନ୍‌ ହେୱାର୍‌ ଲାଗେ ନି ତର୍‌ ୱେଚ୍ୟାତାନ୍‌; ହେୱାର୍‌ ମିୱାର୍‌ ମାଚାର୍‌ ଆରି ଏପେଙ୍ଗ୍‌ ହେୱାରିଂ ନାଙ୍ଗେଙ୍ଗ୍‌ ଦାନ୍‌ କିତ୍‌ତାୟ୍‌, ଆରେ ହେୱାର୍‌ ନି ବଲ୍‌ ପାଲି କିନାରା । ");
INSERT INTO peg_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","ଏପେଙ୍ଗ୍‌ ନାଙ୍ଗେଙ୍ଗ୍‌ ଇନା ଇନାକା ଦାନ୍‌ କିତ୍‌ତାଦେର୍ଣ୍ଣା, ହେ ୱିଜ଼ୁ ଜେ ନିଙ୍ଗ୍‌ ତାଙ୍ଗ୍‌ ଆତାତ୍‌ନ୍ନା, ଇଦାଂ ହେୱାର୍‌ ନଙ୍ଗୟ୍‌ ବୁଜାଆତାର୍ଣ୍ଣା; ");
INSERT INTO peg_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","ଇନାକିଦେଂକି ଏପେଙ୍ଗ୍‌ ନାଙ୍ଗେଙ୍ଗ୍‌ ଜେ ୱିଜ଼ୁ ବଚନ୍‌ ଦାନ୍‌ କିନାଦେର୍‌, ଆନ୍‌ ହେୱେରିଂ ହେ ସବୁ ଦାନ୍‌ କିତାଙ୍ଗ୍‌ନା, ଆରେ ହେୱାର୍‌ ଇଡ୍‌ତାର୍‌ନ୍ନା, ଆରେ ଆନ୍‌ ଜେ ମିତାଙ୍ଗ୍ ୱାନାଙ୍ଗା, ହେଦାଂ ହାତ୍‌ପାରଚେ ପୁଚାର୍ଣ୍ଣା ଆରି ଏପେଙ୍ଗ୍‌ ନାଙ୍ଗେଙ୍ଗ୍‌ ପକ୍‌ତାତାୟ୍‌ନା ଇଞ୍ଜି ପାର୍ତି କିନାୟା ।” ");
INSERT INTO peg_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“ଆନ୍‌ ହେୱାର୍‌ କାଜିଂ ଗୱାରି କିନାଙ୍ଗା; ପୁର୍ତିତିଂ ଇଞ୍ଜି ପାର୍ତାନା କିଉଙ୍ଗା, ମାତର୍‌ ଏପେଙ୍ଗ୍‌ ନାଙ୍ଗେଙ୍ଗ୍‌ ଇମ୍‌ଣାକାରିଂ ହିତାଦେର୍‌ନା, ହେୱାର୍‌ କାଜିଂ ପାର୍ତାନା କିନାଙ୍ଗା, ଇନାକିଦେଂକି ହେୱାର୍‌ ମିୱାର୍‌; ");
INSERT INTO peg_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","ଇନା ଇନାକା ନାଦାଂ, ହେ ୱିଜ଼ୁ ମିଦାଙ୍ଗ୍‌, ଆରେ ଇନା ଇନାକା ମିଦାଙ୍ଗ୍‌, ହେ ୱିଜ଼ୁ ନାଦାଂ; ଆରେ, ଆନ୍‌ ହେୱାର୍‌ ତାକେ ଜାଜ୍‌ମାଲ୍‌ ପାୟା ଆତାଙ୍ଗ୍‌ନା । ");
INSERT INTO peg_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","ଆନ୍‌ ଆରେ ଇ ପୁର୍ତିତ ମାନୁଙ୍ଗା, ମାତର୍‌ ଇୱାର୍‌ ପୁର୍ତିତ ମାନାର୍‌; ଆରେ, ଆନ୍‌ ସାକ୍ତି କାଜିଂ ମି ଲାଗେ ହାନାଙ୍ଗା । ପୁଇପୁୟା ଆବା, ମି ତର୍‌ଦ ହେୱାରିଂ ରାକ୍ୟା କିୟା ଇମ୍‌ଣି ତର୍‌ ଏନ୍‌ ନାଙ୍ଗେଙ୍ଗ୍‌ ହିତ୍‌ତାୟ୍‌ନା, ହେ ଲାକେ ଆପେଂ ଇନେସ୍‌କି ଏକ୍‌, ହେୱାର୍‌ ହେ ଲାକେ ଏକ୍‌ ଆନାର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","“ହେୱାର୍‌ ଲାହାଙ୍ଗ୍‌ ମାନି ସମୁତ ଆନ୍‌ ହେୱାରିଂ ମି ତର୍‌ଦାଂ ରାକ୍ୟା କିଜ଼ି ୱାତାଙ୍ଗ୍‌ନା ଇମ୍‌ଣି ତର୍‌ ଏନ୍‌ ନାଙ୍ଗେଙ୍ଗ୍‌ ହିତ୍‌ତାଦେର୍ଣ୍ଣା, ଆରେ ଆନ୍‌ ହେୱାରିଂ ଜାଗ୍ରତ୍‌ତାଂ ରାକ୍ୟା କିତାଙ୍ଗ୍‌ନା ଆରି ସାସ୍ତର୍‌ତ ଇନେସ୍‌ ଜିତା ଆନାତ୍‌, ଇଦାଂ କାଜିଂ ନାସ୍‌ ଆନି କାଡ଼୍‌ଦେ ପିସ୍ତି ହେୱାର୍‌ ବିତ୍ରେ ରୱାନ୍‌ ଇନେନ୍‌ ନସ୍ଟ ଆୱାତାର୍ଣ୍ଣା । ");
INSERT INTO peg_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","ମାତର୍‌ ଅଙ୍ଗୟ୍‌ ଆନ୍‌ ମି ଲାଗେ ହାନାଙ୍ଗା, ଆରେ ହେୱାର୍‌ ୱାସ୍କିତ ନା ୱାରି ଇନେସ୍‌ ବାର୍ତି ଆନାତ୍‌, ହେଦାଂ କାଜିଂ ପୁର୍ତିତ ମାନୁ ମାନୁ ଆନ୍‌ ଇ ସବୁ ଇଞ୍ଜ୍‌ନାଙ୍ଗା । ");
INSERT INTO peg_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","ଆନ୍‌ ହେୱାରିଂ ନି ବଚନ୍‌ ହିତ୍‌ତାଙ୍ଗ୍‌ନା, ଆରେ ପୁର୍ତି ହେୱାରିଂ ଗିଣ୍‌ କିନାତା, ଇନାକିଦେଂକି ଆନ୍‌ ଇନେସ୍‌ ଇ ପୁର୍ତିତ ଆକାୟ୍‌, ହେୱାର୍‌ ହେ ଲାକେ ଇ ପୁର୍ତିତାଂ ୱାୱାତାଙ୍ଗ୍‌ନା । ");
INSERT INTO peg_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","ଏପେଙ୍ଗ୍‌ ହେୱାରିଂ ପୁର୍ତି ତାଙ୍ଗ୍‌ ଅୱାଟ୍‌ ଇଞ୍ଜି ଆନ୍‌ ପାର୍ତାନା କିନାଙ୍ଗା, ମାତର୍‌ ହେୱାରିଂ ସୟ୍‌ତାନ୍‌ ତାଙ୍ଗ୍‌ ରାକ୍ୟା କିୟା ଇଞ୍ଜି ଗୱାରି କିନାଙ୍ଗା । ");
INSERT INTO peg_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","ଆନ୍‌ ଇନେସ୍‌ ପୁର୍ତିତ ଆୱାତାଂନା, ହେୱାର୍‌ ହେ ଲାକେ ପୁର୍ତିତାଂ ଆକାୟ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","ହାତ୍‌ପା କାଜିଂ ହେୱାରିଂ ପୁଇପୁୟା କିୟାଟ୍‌, ମିଦାଙ୍ଗ୍‌ ବଚନ୍‌ ନେ ସତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","ଏନ୍‌ ନାଙ୍ଗେଙ୍ଗ୍‌ ଇନେସ୍‌ ପୁର୍ତିତ ପକ୍‌ତାତାୟ୍‌ନା, ଆନ୍‌ ପା ହେୱେରିଂ ହେ ଲାକେ ପୁର୍ତିତ ପକ୍‌ତାଙ୍ଗ୍‌ନା । ");
INSERT INTO peg_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","ଆରେ, ହେୱାର୍‌ ପା ଇନେସ୍‌ ହାତ୍‌ପା ହୁକେ ପୁଇପୁୟା ଆନାର୍‌, ଇଦାଂ କାଜିଂ ଆନ୍‌ ହେୱାରିଂ କାଜିଂ ନିଙ୍ଗେଙ୍ଗ୍‌ ପୁଇପୁୟା କିଦ୍‌ନାଙ୍ଗ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“ଆନ୍‌ କେବଲ୍‌ ଇୱାର୍‌ କାଜିଂ ଗୱାରି କିଜ଼ି ପାର୍ତାନା କିଉଙ୍ଗା, ମତର୍‌ ଇୱାର୍‌ ବଚନ୍‌ ହୁକେ ଇମ୍‌ଣାକାର୍‌ ନା ତାକେ ପାର୍ତି କିତାର୍‌, ହେୱାର୍‌ କାଜିଂ ପା ପାର୍ତାନା କିନାଙ୍ଗା, ");
INSERT INTO peg_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","ହେୱାନ୍‌ ୱିଜ଼ାର୍‌ କାଜିଂ ପା ପାର୍ତାନା କିଜ଼ି ମାଚାନ୍‌ । ହେୱାର୍‌ ୱିଜ଼ାକାର୍‌ ଏକ୍‌ ଆନାର୍‌; ଇଦାଂ ନା ପାର୍ତାନା । ଆବା, ଏନ୍‌ ଇନେସ୍‌କି ନା ତାକେ ଆରି ଆନ୍‌ ନି ତାକେ ମାନାଙ୍ଗ୍‌, ହେୱାର୍‌ ପା ହେ ଲାକେ ଇନେସ୍‌କି ଏନ୍‌ନାଙ୍ଗ୍‌ ପକ୍‌ତାତାନ୍‌ ଇଞ୍ଜି ପୁର୍ତି ପାର୍ତି କିଦ୍‌ନାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","ଆରେ, ଏନ୍‌ ନାଙ୍ଗେଙ୍ଗ୍‌ ଇମ୍‌ଣି ପାଣ୍‌ ହିତ୍‌ତାୟ୍‌ନା, ଆନ୍‌ ହେୱାରିଂ ହେଦାଂ ହିତାଙ୍ଗ୍‌ନା, ଇନେସ୍‌ ଆପେଂ ଇନେସ୍‌କି ଏକ୍‌, ହେୱାର୍‌ ହେ ଲାକେ ଏକ୍‌ ଆନାର୍‌; ");
INSERT INTO peg_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","ଆନ୍‌ ହେୱାର୍‌ ତାକେ, ଆରେ ଏନ୍‌ ନା ତାକେ, ଇନେସ୍‌ ହେୱାର୍‌ ହାର୍‌ ଆଜ଼ି ଏକ୍‌ ଆନାର୍‌, ଇନେସ୍‌ ପୁର୍ତି ବୁଜାଆନାତ୍‌ ଜେ, ଏନ୍‌ ନାଙ୍ଗେଙ୍ଗ୍‌ ପକ୍‌ତାତାୟ୍‌, ଆରେ ନାଙ୍ଗେଙ୍ଗ୍‌ ଇନେସ୍‌କି ଜିଉନତାୟ୍‌, ହେୱାରିଂ ପା ହେ ଲାକେ ଜିଉନତାୟ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“ଏ ଆବା, ଏନ୍‌ ନାଙ୍ଗେଙ୍ଗ୍‌ ଇମ୍‌ଣାକାରିଂ ହିତ୍‌ତାୟ୍‌ନା, ଆନ୍‌ ଇମେତାକେ ମାନେଙ୍ଗ୍‌, ହେୱେର୍‌ ପା ଇନେସ୍‌ ହେବେ ନା ଲାହାଙ୍ଗ୍‌ ମାନେର୍‌ ଆରି ପୁର୍ତି ୱିଜ଼୍‌ନି ଆଗେ ଏନ୍‌ ନାଙ୍ଗେଙ୍ଗ୍‌ ଜିଉନଜ଼ି କିଦ୍‌ନି କାଜିଂ ନାଙ୍ଗେଙ୍ଗ୍‌ ଇମ୍‌ଣି ପାଣ୍‌ ହିତ୍‌ତାୟ୍‌ନା, ନା ହେ ପାଣ୍‌ ହେୱାର୍‌ ଇନେସ୍‌ ହୁଡ଼୍‌ନାର୍‌, ଇଦାଂ ନା ମାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","ଏ ଦାର୍ମି ଆବା, ପୁର୍ତି ନିଙ୍ଗେଙ୍ଗ୍‌ ପୁଞ୍ଜୁୱାତାତ୍‌ନା, ମାତର୍‌ ଆନ୍‌ ନିଙ୍ଗେଙ୍ଗ୍‌ ପୁଞ୍ଚାଙ୍ଗ୍‌ନା; ଆରେ, ଇଦାଂ ଜେ ନାଙ୍ଗେଙ୍ଗ୍‌ ପକ୍‌ତାତାୟ୍‌, ହେଦାଂ ଇୱାର୍‌ ପୁଚାର୍ଣ୍ଣା; ");
INSERT INTO peg_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","ଆରେ ଏନ୍‌ ନାଙ୍ଗେଙ୍ଗ୍‌ ଇମ୍‌ଣି ଜିଉତ୍‌ ଜିଉନତାୟ୍‍ନା, ହେଦାଂ ଇନେସ୍‌ ହେୱାର୍‌ ତାକେ ମାନାତ୍‌ ଆରି ଆନ୍‌ ହେୱାର୍‌ ତାକେ ମାନ୍‌ଗାନାଙ୍ଗ୍‌, ଇ କାଜିଂ ଆନ୍‌ ହେୱାରିଂ ନି ତର୍‌ ୱେଚ୍‌ଚାତାଂନା ଆରି ୱେଚ୍‌ନାଙ୍ଗ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","ଜିସୁ ଇ ପାର୍ତାନା ୱିଜ଼ୁ କାତା ଇଞ୍ଜି ଜାର୍‌ ଚେଲାର୍‌ ଲାହାଙ୍ଗ୍‌ କିଦ୍ରଣ ନାଗୁଡ଼୍‌ କନାନି ଆଣ୍ଟିପାଡ଼୍‌କାତ ହସି ହାଚାର୍‌ । ହେବେ ରଞ୍ଜାଙ୍ଗ୍‌ ବାଡ଼୍‌ ମାଚାତ୍‌, ଆରେ ହୱାନ୍‌ ଆରେ ତା ଚେଲାହିର୍‌ ହେବେ ହଟାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","ଇମ୍‌ଣି ଜିହୁଦା ତାଙ୍ଗେଙ୍ଗ୍‌ ସତ୍ରୁ କେଇଦ ହେଲାୟ୍‌ କିତାନ୍‌, ହେୱାନ୍‌ପା ହେ ବାହା ପୁଞ୍ଜି ମାଚାନ୍‌, ଇନାକିଦେଂକି ଜିସୁ ବେସିହଟ୍‌ ଜାର୍‌ ଚେଲାହିର୍‌ ଲାହାଙ୍ଗ୍‌ ହେ ବାହାତ ହାଲ୍‌ବିସ୍‌ ମାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","ଲାଗିଂ, ଜିହୁଦା ମେଲ୍ୟାର୍‌ ଆରେ ମୁଡ଼୍‌ ମାପ୍ରୁହେବା କିନାକାର୍‌ ଆରି ପାରୁସିର୍‌ତାଂ ପାୟାତାକାର୍‍ ମନ୍ଦିର୍‌ କାନାକାର୍‌ ବଇଟା, ଜୁଜ୍‌ରା ଆରି ଆତିୟାର୍‌ ଆସ୍ତି ହେବେ ୱାତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","ହେବେତାଂ ଜିସୁ, ହେ କାଜିଂ ଇନା ଇନାକା ଗିଟା ଆଦେଂ ହାନାତା, ହେ ୱିଜ଼ୁ ପୁଞ୍ଜି ଆଗେ ୱାଜ଼ି ହେୱାରିଂ ୱେନ୍‌ବାତାନ୍‌, “ଏପେଙ୍ଗ୍‌ ଇନେରିଂ ଡେକ୍‌ନାଦେରା ?” ");
INSERT INTO peg_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","ହେୱାର୍‌ ଜିସୁଙ୍ଗ୍‌ ଉତର୍‌ ହିତାର୍‌, “ନାଜରିତିୟ ଜିସୁଙ୍ଗ୍‌ ।” ହେୱାନ୍‌ ହେୱାରିଂ ଇଚାନ୍‌, “ଆନ୍‌ ହେୱାନ୍‌ ।” ଇମ୍‌ଣି ଜିହୁଦା ତାଙ୍ଗ୍‌ ସାତ୍ରୁ କେଇଦ ସର୍‌ପି କିତାନ୍‌, ହେୱାନ୍‌ପା ହେୱାର୍‌ ଲାହାଙ୍ଗ୍‌ ନିଲ୍‌ଚି ମାଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","ଜିସୁ ଏଚେକାଡ଼୍‌ଦ ହେୱାରିଂ ୱେଚ୍‌ଚାନ୍‌, “ଆନ୍‌ ହେୱାନ୍‌,” ହେ ପାଦ୍‌ନା ହେୱାର୍‌ ପାଚ୍‌ ଗୁଚା ଆଜ଼ି ମେଦ୍‌ନିତ ଗୁର୍‌ତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","ହେବେଣ୍ଡାଂ ହେୱାନ୍‌ ହେୱାରିଂ ଆରେ ରଗ ୱେନ୍‌ବାତାନ୍‌, “ଏପେଙ୍ଗ୍‌ ଇନେରିଂ ଡେକ୍‌ନାଦେରା ?” ହେୱାର୍‌ ଇଚାର୍‌, “ନାଜରିତିୟ ଜିସୁଙ୍ଗ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","ଜିସୁ ଉତର୍‌ ହିତାନ୍‌, “ଆନ୍‌ ଜେ ହେୱାନ୍‌, ଇୱାନ୍ତ ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ୱେଚ୍‌ଚାତାଂ । ଲାଗିଂ ଏପେଙ୍ଗ୍‌ ଜଦି ନାଙ୍ଗ୍‌ ଡେକ୍ତାନାଦେରା, ତା ଆତିସ୍‌ ଇୱାରିଂ ହାଞ୍ଜେଙ୍ଗ୍‌ ପିସ୍ତି ହିୟାଟ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","ଜିସୁ ଇଦାଂ ଇଚାନ୍‌, ଇନେସ୍‌ ତା ଲେକାଆତି ବଚନ୍‌ ପୁରା ଆନାତ୍‌, “ଏନ୍‌ନାଙ୍ଗ୍‌ ଇନେରିଂ ହିତ୍‌ତାୟ୍‌ନା, ହେୱାର୍‌ ବିତ୍ରେ ଆନ୍‌ ରକାନିଂ ପା ଆରାୟ୍‌ କିୱାତାଂନା ।” ");
INSERT INTO peg_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","ସିମନ୍‌ ପିତର୍‌ ଲାଗାଂ କାଣ୍ଡା ମାଚିଲେ ହେୱାନ୍‌ ହେଦାଂ ହପ୍‌ଚି ମୁଡ଼୍‌ ମାପ୍ରୁହେବାକିନାକାନ୍‌ ଆଡ଼ିଏନିଂ ଡତାନ୍‌ ଆରି ତା ତିନି କିତୁଲ୍‌ ନାଟ୍‌ଚି ତୁହିତାନ୍‌; ହେ ଆଡ଼ିଏନ୍ତି ତର୍‌ ମାଲ୍‌କ । ");
INSERT INTO peg_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","ହେବେଣ୍ଡାଂ ଜିସୁ ପିତର୍‌ତିଂ ଇଚାନ୍‌, “କାଣ୍ଡା ଇଟ୍‌ନିତାକେ ଇଟା; ଆବା ନାଙ୍ଗ୍‌ ଇମ୍‌ଣି ବାହା ହିତ୍‌ନ୍ନା, ଆନ୍‌ ଇନାକା ହେବେ ଗସ୍‍ତେଙ୍ଗ୍‌ ଆଡୁଙ୍ଗ୍‌ ?” ");
INSERT INTO peg_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","ଇଦାଂ ପାଚେ ରମିୟ ନେତାର୍‌ନି ମେଲ୍ୟାର୍‌, ମୁଡ଼୍‌ମେଲ୍ୟା, ଆରେ ଜିହୁଦିର୍‌ ମେଲ୍ୟାର୍‌ ଜିସୁଙ୍ଗ୍‌ ଆସ୍ତି ଗାଚ୍‌ଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","ଆରେ ତାଙ୍ଗେଙ୍ଗ୍‌ ଗାଚ୍‌ଚି ପର୍ତୁମ୍‌ ହାନାନ ତାକେ ଅତାର୍‌, କୟାପା ପତ୍‍ଲେହି ମାଚାନ୍‌ ଇନାକିଦେଂକି ହେୱାନ୍‌ ହେ ବାର୍ହୁନି ମୁଡ଼୍‌ ମାପ୍ରୁହେବା କିନାକାର୍‌ ମାଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","ମାନାୟାର୍‌ ବିତ୍ରେ ରକାନ୍‌ ହାନାକା ହାର୍‌ ଇଞ୍ଜି ଜିହୁଦିରିଂ ଜେ ୱେଚ୍‌ଚି ମାଚାନ୍‌, ଇୱାନ୍‌ ହେ କୟାପା । ");
INSERT INTO peg_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","ସିମନ୍‌ ପିତର୍‌ ଆରି ଆରେ ରକାନ୍‌ ଚେଲାହି ଜିସୁ ପାଚେ ପାଚେ ହାଲ୍‌ଜି ମାଚାର୍‌ । ହେ ଚେଲା ମୁଡ଼୍‌ ମାପ୍ରୁହେବାକିନାକାନିଂ ଚିନା ଜାଣା ମାଚାନ୍‌ ଆରି ଜିସୁତି ହୁକେ ମୁଡ଼୍‌ ମାପ୍ରୁହେବାକିନାକାନ୍‌ ହାକ୍‌ଡ଼ିତ ହଟାର୍‌; ");
INSERT INTO peg_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","ମାତର୍‌ ପିତର୍‌ ବାର୍ତ ଦୁୱେର୍‌ତ ଲାଗେ ନିଲ୍‌ଚି ମାଚାନ୍‌ । ଲାଗିଂ, ହେ ଇମ୍‌ଣି ବିନ୍‌ ଚେଲା ମୁଡ଼୍‌ ମାପ୍ରୁହେବାକିନାକାନ୍‌ ମେହାଣ୍‍ ମାଚାନ୍‌, ହେୱାନ୍‌ ବାର୍ତ ହାଲ୍‌ଜି ଦୁୱେର୍‌ କାନାକାନିଂ ୱେଚ୍‌ଚି ପିତର୍‌ତିଂ ବିତ୍ରେ ତାହିୱାତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","ହେବେ ହେ ଦୁୱେର୍‌ତ କାନାକାଦେଲ୍‍ ଆଡ଼ିଏଣି ପିତର୍‌ତିଂ ଇଚାତ୍‌, “ଏନ୍‌ ପା ଇନାକା ଇ ମାନାୟ୍‌ତିଂ ଚେଲାର୍‌ ବିତ୍ରେ ରକାୟ୍‌ ଆକାୟ୍‌ ?” ପିତର୍‌ ଇଚାନ୍‌, “ଆନ୍‌ ଆକାୟ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","ପିନି କାଜିଂ ଆଡ଼ିୟା ଆରି କାନାକାର୍‌ ନାଣିଆହି କିଜ଼ି ହେବେ ନିଲ୍‌ଚି କାଇଜି ମାଚାର୍‌; ପିତର୍‌ ପା ହେୱାର୍‌ ଲାହାଙ୍ଗ୍‌ ନିଲ୍‌ଚି ନାଣି କାଇଜି ମାଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","ମୁଡ଼୍‌ ମାପ୍ରୁହେବାକିନାକାନ୍‌ ଜିସୁଙ୍ଗ୍‌ ତା ଚେଲାହିର୍‌ ବିସ୍ରେ ଆରି ହେ ହିକ୍ୟା ବିସ୍ରେ ୱେନ୍‌ବାତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","ଜିସୁ ତାଙ୍ଗେଙ୍ଗ୍‌ ଉତର୍‌ ହିତାନ୍‌, “ଆନ୍‌ ପୁର୍ତି ତାକେ ହପ୍‌ଚି କାତା ଇଚାଙ୍ଗ୍‌ନା; ଇମେତାକେ ୱିଜ଼ାର୍ ଜିହୁଦିର୍‌ ରୁଣ୍ଡା ଆନାର୍‌, ଇ ଲାକେ କୁଟୁମ୍‌ ଇଞ୍ଜ ଆରି ମନ୍ଦିର୍‌ତ ଆନ୍‌ ନିତ୍ରେ ହିକ୍ୟା ହିନାଙ୍ଗା; ଆନ୍‌ ଲୁକାମ୍‍ରେ ଇନାକା ହିୱାତାଂନ୍ନା ");
INSERT INTO peg_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","ନାଙ୍ଗ୍‌ ଇନେକିଦେଂ ୱେନ୍‌ବା ଆଦ୍‌ନାଦେରା ? ଆନ୍‌ ହେୱାରିଂ ଇନାକା ଇଚାଙ୍ଗ୍‌ନା, ଇନେର୍‌ ୱେଚାର୍‍ନା, ହେୱାରିଂ ୱେନ୍‌ବାଟ୍; ହୁଡ଼ାଟ୍‌, ଆନ୍‌ ଇନା ଇନାକା ଇଚାଙ୍ଗ୍‌ନା ହେୱାର୍‌ ହେୱିଜ଼ୁ ପୁନାର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","ଜିସୁ ଇଦାଂ ଇଚିଲେ ମେଲ୍ୟାର୍‌ ବିତ୍ରେ ରକାନ୍‌ ଜିସୁଙ୍ଗ୍‌ ଚାପ୍‌ଡ଼ା ଇଡ଼୍‌ଜି ଇଚାନ୍‌, “ଏନ୍‌ ମୁଡ଼୍‌ ମାପ୍ରୁହେବାକିନାକାନିଂ ଏନେଙ୍ଗ୍‌ ଉତର୍‌ ହିନାୟା ?” ");
INSERT INTO peg_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","ଜିସୁ ତାଙ୍ଗେଙ୍ଗ୍‌ ଉତର୍‌ ହିତାନ୍‌, “ଜଦି ଆନ୍‌ ବାନ୍ୟା ଇଚାଂ, ତା ଆତିସ୍‌ ୱିଜ଼ାରିଂ ମୁମ୍‌ଦ ବାନ୍ୟା ପାର୍ମାଣ୍‍ ହିୟା; ମାତର୍‌ ଜଦି ହାର୍‌ ଇନ୍‌ଚାଙ୍ଗ୍‌, ତା ଆତିସ୍‌ ଇନେକିଦେଂ ନାଙ୍ଗେଙ୍ଗ୍‌ ମାଡ଼୍‌ଜି କିଦ୍‌ନାୟା ?” ");
INSERT INTO peg_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","ହେବେ ହାନାନ ତାଙ୍ଗେଙ୍ଗ୍‌ ଗାଚ୍ୟା ଆତାକାନିଂ ମୁଡ଼୍‌ ମାପ୍ରୁହେବାକିନାକାର୍ କୟାପା ଲାଗେ ପକ୍‌ତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","ୱିସ୍ତି ବିତ୍ରେ ସିମନ୍‌ ପିତର୍‌ ନିଲ୍‌ଚି ନାଣି କାଇଜି ମାଚାନ୍‌ । ହେବେଣ୍ଡାଂ ହେୱାର୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ୱେନ୍‌ବାତାର୍, “ଏନ୍‌ ପା ଇନାକା ହେ ଚେଲାର୍‌ ବିତ୍ରେ ରୱାୟ୍‍ ଆକାୟ୍‌ ?” ମାତର୍‌ ପାର୍ତି କିୱାଦାଂ ଇଚାନ୍‌, “ଆକାୟ୍‌ ଆନ୍‌ ଆକାୟ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","ମୁଡ଼୍‌ ମାପ୍ରୁହେବା କିନାକାନ୍‌ ଆଡ଼ିୟାର୍‌ ବିତ୍ରେ ରୱାନ୍‌, ଇଚିସ୍‌ ପିତର୍‌ ଇନେର୍‌ତି କିତୁଲ୍‌ ରାସ୍‌ଦି ମାଚାନ୍‌, ତା ହାଙ୍ଗ୍‌ଦାକାନ୍ ରକାନ୍‌ ଇଚାନ୍‌, “ଆନ୍‌ ଇନାକା ନିଙ୍ଗ୍‌ ତା ଲାହାଙ୍ଗ୍‌ ବାଡ଼୍‌ଦ ହୁଡ଼୍‌ଜି ମାଞ୍ଜ୍‌ୱାତାଂ ?” ");
INSERT INTO peg_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","ହେବେଣ୍ଡାଂ ପିତର୍‌ ଆରେ ରଗ ପାର୍ତି କିୱାତାନ୍‌; ଆରେ ହେ ଦାପ୍ରେ କୁଜ଼ୁ କ୍ଡେତାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","ପାଚେ ହେୱାର୍‌ ଜିସୁଙ୍ଗ୍‌ କୟାପାଙ୍ଗ୍‌ ଲାଗାଂ ବାଙ୍ଗ୍‌ଲାତ ଅତାର୍‌ ନାଡ଼ିସ୍‌ ଆଜ଼ି ମାଚାତ୍‌; ଆରେ, ହେୱାର୍‌ ଇନେସ୍‌ ବିଟାଡ଼୍‌ ଆୱାଦାଂ ନିସ୍ତାର୍‌ ପାର୍ବୁନି ବଜି ମାନିକିଦେଂ ଆଡ୍‌ନାର୍‌, ଇଦାଂ କାଜିଂ ନିଜେ ବାଙ୍ଗ୍‌ଲା ବିତ୍ରେ ହଣ୍‌ୱାତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","ଲାଗିଂ, ପିଲାତ ହେୱାର୍‌ତାଂ ହସି ୱାଜ଼ି ୱେନ୍‌ବାତାନ୍‌, “ଇ ମାନାୟ୍‌ ବିରୁଦ୍‌ତ ଏପେଙ୍ଗ୍‌ ଇମ୍‌ଣି କାତା ତାହିୱାନାଦେରା ?” ");
INSERT INTO peg_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","ହେୱାର୍‌ ତାଙ୍ଗ୍‌ ଉତର୍‌ ହିତାର୍‌, “ଇ ମାନାୟ୍‌ ଜଦି ପାପ୍ୟା ଆୱାଦାଂ ମାଚିସ୍‌, ତା ଆତିସ୍‌ ଆପେଂ ତାଙ୍ଗେଙ୍ଗ୍‌ ନି କେଇଦ ହେଲାୟ୍‌ କିଦ୍‌ୱାତାପ୍‌ମା ।” ");
INSERT INTO peg_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","ହେବେଣ୍ଡାଂ ପିଲାତ ହେୱାରିଂ ଇଚାନ୍‌, “ଏପେଙ୍ଗ୍‌ ଇୱାନିଂ ଅଜ଼ି ହାଲ୍‌ଜି ମି ବିଦି ଲାହାଙ୍ଗ୍‌ ଇୱାନ୍ତି ବିଚାର୍‌ କିୟାଟ୍‌ ।” ଜିହୁଦିର୍‌ ହେୱାନିଂ ଇଚାର୍‌, “ଇନେରିଂ ପାରାଣ୍‌ ଡାଣ୍ଡ୍‌ ହିଦେଂ ମା ଆଦିକାର୍‌ ହିଲୁତ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","ଜିସୁ ଇମ୍‌ଣି ବାନି ହାକି କିଦେଙ୍ଗ୍‌ ହାନାନା, ହେବେତାଂ ୱେଚ୍‌ଚି ହେୱାନ୍‌ ଇମ୍‌ଣି ବଚନ୍‌ ଇଚାନ୍‌ ହେଦାଂ ଇନେସ୍‌ ପୁରା ଆନାତ୍‌, ଇଦାଂ କାଜିଂ ହେୱାର୍‌ ଇଦାଂ ଇଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","ପିଲାତ ବାଙ୍ଗ୍‌ଲା ବିତ୍ରେ ହଣ୍‌ଜି ଜିସୁଙ୍ଗ୍‌ କୁକ୍‌ଚି ତାଙ୍ଗ୍‌ ୱେନ୍‌ବାତାନ୍‌, “ଏନ୍‌ ଇନାକା ଜିହୁଦିର୍‌ ରାଜା ?” ");
INSERT INTO peg_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","ଜିସୁ ଉତର୍‌ ହିତାନ୍‌, “ଏନ୍‌ ଇନାକା ନିଜ୍‌ତାଙ୍ଗ୍ ଇଦାଂ ଇଚାୟ୍‌ନା, କି ବିନ୍‌ଲଗୁ ନା ବିସ୍ରେ ନିଙ୍ଗ୍‌ ଇଦାଂ ଇଞ୍ଚାର୍‌ନା ?” ");
INSERT INTO peg_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","ପିଲାତ ଉତର୍‌ ହିତାନ୍‌, “ଆନ୍‌ ଇନାକା ରକାଂ ଜିହୁଦି ? ନି ଜାତିନିକାର୍ ଆରି ମୁଡ଼୍‌ ମାପ୍ରୁହେବାକିନାର୍ ନିଙ୍ଗେଙ୍ଗ୍‌ ମା କେଇଦ ହେଲାୟ୍‌ କିତ୍‌ତାର୍ଣ୍ଣା; ଏନ୍‌ ଇନାକା କିତାୟ୍‌ନା ?” ");
INSERT INTO peg_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","ଜିସୁ ଉତର୍‌ ହିତାନ୍‌, “ନା ରାଜି ଇ ପୁର୍ତି ବିସ୍ରେ ଆକାୟ୍‌; ଜଦି ନା ରାଜି ଇ ପୁର୍ତି ବିସ୍ରେ ଆତାତ୍ମା, ତା ଆତିସ୍‌ ଆନ୍‌ ଇନେସ୍‌ ଜିହୁଦି ନେତାର୍‌ କେଇଦ ହେଲାୟ୍‌ ଆୱାତାଂମା, ହେଦାଂ କାଜିଂ ନା ହେବା କିନାକାର୍‌ ଜୁଜ୍‌ କିତାର୍ମା; ମାତର୍‌ ନା ରାଜି ହାତ୍‌ପା ବିସ୍ରେ ଆକାୟ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","ହେବେଣ୍ଡାଂ ପିଲାତ ହେୱାନିଂ ୱେନ୍‌ବାତାନ୍‌, “ତା ଆତିସ୍‌ ଏନ୍‌ ରୱାୟ୍‍ ରାଜା କି ?” ଜିସୁ ଉତର୍‌ ହିତାନ୍‌, “ଏନ୍‌ ତ ଇଞ୍ଜ୍‌ନାୟା, ଆନ୍‌ ରକାଂ ରାଜା । ଆନ୍‌ ଇନେସ୍‌ ହାତ୍‌ପା ପାକ୍ୟାତ ସାକି ହିନାଙ୍ଗ୍, ଇଦାଂ କାଜିଂ ଆନ୍‌ ଜଲମ୍‌ ଆତାଙ୍ଗ୍‌ନା ଆରି ପୁର୍ତି ୱାତାଙ୍ଗ୍‍ନା । ଇନେନ୍‌କି ହାତ୍‌ପାନି ମାଜ଼ି, ହେୱାନ୍‌ ନା କାତା ୱେନାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","ପିଲାତ ଜିସୁଙ୍ଗ୍‌ ଇଚାନ୍‌, “ହାତ୍‌ପା ଇନାକା ?” ଇଦାଂ ଇଞ୍ଜି ପିଲାତ ଆରେ ଜିହୁଦି ତାକେ ବାର୍ତ ହାଲ୍‌ଜି ହେୱାରିଂ ଇଚାନ୍‌, “ଆପେଂ ଇବେ ଇନାକାପା ଦସ୍‌ ପାୟା ଆଉପା ।” ");
INSERT INTO peg_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","ମାତର୍‌ ନିସ୍ତାର୍‌ ପାର୍ବୁ ୱେଡ଼ାଲିଂ ମି କାଜିଂ ରୱାନିଂ ମୁକ୍‌ଡ଼ାୟ୍ କିନାପ୍‌, ଇଦାଂ ମି ରିତି ନିତି ମାନାତ୍‌; ଲାଗିଂ, “ଜିହୁଦିର୍‌ ରାଜାଙ୍ଗ୍‌ ଆପେଂ ମି କାଜିଂ ମୁକ୍‌ଡ଼ାୟ୍ କିଜ଼ି ହିଦ୍‍ନାପ୍ ଇଞ୍ଜି ଇନାକା ମି ମାନ୍‌ କିନାଦେରା କି ?” ");
INSERT INTO peg_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","ହେବେ ହେୱାର୍‌ ଆରେ ରଗ କିକିରାଡିଂ କିଜ଼ି ଇଚାର୍‌, “ଇ ମାନାୟ୍‌ ଆକାୟ୍‌, ମାତର୍‌ ବାରବାଙ୍ଗ୍ ।” ଇ ବାରବା ରକାନ୍‌ ଚରେନ୍‌ ମାଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","ତା ପାଚେ ପିଲାତ ଜିସୁଙ୍ଗ୍‌ ଅଜ଼ି ହାଲ୍‌ଜି କର୍‌ଡା ଟ୍ରାକି କିତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","ଆରେ, ମେଲ୍ୟାର୍‌ ୱାଡ଼ି ମୁକୁଟ୍‌ ରଚ୍‌ଚି ତା କାପ୍‌ଡ଼ାତ ତୁଜ଼ି କିତାର୍ ଆରି ହେୱାନିଂ କାହ୍‌ରାତି କାଲାର୍‌ ବାନି ଆଙ୍ଗି ଉସ୍ପି କିତାର୍‌; ");
INSERT INTO peg_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","ହେୱାର୍‌ ତା ତାକେ ୱାଜ଼ି ଇଚାର୍‌, “ଏ ଜିହୁଦିର୍‌ ରାଜା, ଜୁଗ୍‌ ଜୁଗ୍‌ ମାନା” ଆରେ, ହେୱାର୍‌ ହେୱାନିଂ ଚାପ୍‌ଡ଼ା ଇଡ଼୍‌ଦେଂ ଲାଗାତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","ପିଲାତ ଆରେ ରଗ ବାର୍ତ ହାଲ୍‌ଜି ହେୱାରିଂ ଇଚାନ୍‌, ହୁଡ଼ାଟ୍‌, “ଆପେଂ ଜେ ତା ତାକେ ଇନାକାପା ଦସ୍‌ ପାୟା ଆଉପା,” ଇଦାଂ ଇନେସ୍‌ ଏପେଙ୍ଗ୍‌ ପୁନାଦେର୍‌, “ଇଦାଂ କାଜିଂ ଆପେଂ ତାଙ୍ଗେଙ୍ଗ୍‌ ମି ତାକେ ହପ୍‍ଚି ତାତ୍‌ପ୍‌ନା ।” ");
INSERT INTO peg_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","ହେବେଣ୍ଡାଂ ଜିସୁ ହେ ୱାଡ଼ି ମୁକୁଟ୍‌ ଆରି କାହ୍‌ରାତି କାଲାର୍‌ ବାନାନି ଆଙ୍ଗି ଉସ୍ପିସ୍‌ ବାର୍ତ ୱାତାନ୍ । ପିଲାତ ହେୱାରିଂ ଇଚାନ୍‌, ହୁଡ଼ାଟ୍‌, ଇୱାନ୍‌ “ହେ ମାନାୟ୍‌ !” ");
INSERT INTO peg_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","ହେବେଣ୍ଡାଂ ମୁଡ଼୍‌ ମାପ୍ରୁହେବାକିନାକାନ୍‌ ଆରି ମନ୍ଦିର୍‌ କାନାକାର୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ହୁଡ଼୍‌ଜି କିକିରାଡିଂ କିଜ଼ି ଇଚାର୍‌, “କ୍ରୁସ୍‌ତ ଦୁପାଟ୍‌, କ୍ରୁସ୍‌ତ ଦୁପାଟ୍‌ ।” ପିଲାତ ହେୱାରିଂ ଇଚାନ୍‌, “ଏପେଙ୍ଗ୍‌ ହେୱାନିଂ ଅଜ଼ି କ୍ରୁସ୍‌ତ ଦୁପାଟ୍‌, ଇନାକିଦେଂକି ଆପେଂ ତା ତାକେ ଇନାକାପା ଦସ୍‌ ପାୟା ଆଉପା ।” ");
INSERT INTO peg_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","ଜିହୁଦିର୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ଉତର୍‌ ହିତାର୍‌, “ମାଦାଂ ରଞ୍ଜାଙ୍ଗ୍‌ ବିଦି ମାନାନ୍‌ ଆରି ହେ ରିତି ହୁକେ ହେୱାନ୍‌ ହାନି ଲଡ଼ା, ଇନାକିଦେଂକି ହେୱାନ୍‌ ଜାର୍‌ତିଂ ଇସ୍ୱର୍‌ ମାଜ଼ି ଇଞ୍ଜି ଇନାନ୍ନା ।” ");
INSERT INTO peg_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","ହେବେଣ୍ଡାଂ ପିଲାତ ଇ କାତା ୱେନ୍‌ଞ୍ଜି ଆଦିକ୍‌ ପାଣ୍ଡ୍ରା ଆତାନ୍‌; ");
INSERT INTO peg_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","ଆରେ, ହେୱାନ୍‌ ଆରେ ରଗ ବାଙ୍ଗ୍‌ଲାତ ହଣ୍‍ଗିସ୍ ଜିସୁଙ୍ଗ୍‌ ୱେନ୍‌ବାତାନ୍‌, “ଏନ୍‌ ଇମେଣ୍ଡାଂ ୱାତାୟ୍‌ନା ?” ମାତର୍‌ ଜିସୁ ତାଙ୍ଗେଙ୍ଗ୍‌ ଉତର୍‌ ହିୱାତାନ୍ । ");
INSERT INTO peg_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","ହେବେଣ୍ଡାଂ ପିଲାତ ତାଙ୍ଗେଙ୍ଗ୍‌ ଇଚାନ୍‌, “ନାଙ୍ଗେଙ୍ଗ୍‌ କାତା ଇଞ୍ଜୁୟା ? ନିଙ୍ଗେଙ୍ଗ୍‌ ମୁକ୍‌ଡ଼ାୟ୍ କିଦେଙ୍ଗ୍‌ ମା ଆଦିକାର୍‌ ମାନାତ୍‌ ଆରି ନିଙ୍ଗେଙ୍ଗ୍‌ କ୍ରୁସ୍‌ତ ଦୁପ୍‌ତେଦେଂ ମା ଆଦିକାର୍‌ ମାନାତ୍‌, ଇଦାଂ କି ଏନ୍‌ ପୁନୁୟା ?” ");
INSERT INTO peg_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","ଜିସୁ ଉତର୍‌ ହିତାନ୍‌, “ଜଦି ଇସ୍ୱର୍‌ ତାଙ୍ଗ୍‌ ହତ୍‌ୱାଦାଙ୍ଗ୍‌ ମାଚିସ୍‌, ତା ଆତିସ୍‌ ନା ବିରୁଦ୍‌ତ ନିନ୍ଦାଂ ଇନାକାପା ଆଦିକାର୍‌ ମାନ୍‌ୱାତାତ୍‌ମା, ଲାଗିଂ ଜେ ନାଙ୍ଗେଙ୍ଗ୍‌ ନି କେଇଦ ହେଲାୟ୍‌ କିତାଙ୍ଗ୍‌ନା, ତା ପାପ୍‌ ଅଲପ୍‍ ।” ");
INSERT INTO peg_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","ହେବେଣ୍ଡାଂ ପିଲାତ ଜିସୁଙ୍ଗ୍‌ ମୁକ୍‌ଡ଼ାୟ୍ କିଦେଙ୍ଗ୍‌ ସେସ୍ଟା କିତାନ୍‌, ମାତର୍‌ ଜିହୁଦିର୍‌ କିକିରାଡିଂ କିଜ଼ି ଇଚାର୍‌, “ଜଦି ଏନ୍‌ ଇ ମାନାୟ୍‌ତିଂ ମୁକ୍‌ଡ଼ାୟ୍ କିନାୟ୍‌, ତା ଆତିସ୍‌ ଏନ୍‌ ସମ୍‌ରାଟ୍‌ତିଂ ସାଙ୍ଗ ଆକାୟ୍‌; ଇନେର୍‌କି ଜାର୍‌ତିଂ ରାଜା ଇଞ୍ଜି ଇନାନ୍‌, ହେୱାନ୍‌ କାଇସର୍‌ତିଂ ବିରୁତ୍‌ତାଂ କାତା ଇନାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","ପିଲାତ ଇ ୱିଜ଼ୁ କାତା ୱେନ୍‌ଞ୍ଜି ଜିସୁଙ୍ଗ୍‌ ହପ୍‌ଚି ତାସି “କାଲ୍‌କୁମଣ୍ଡମ୍‌,” ଇନେରିଂ ଏବ୍ରି ବାସାତ “ଗବ୍‌ବତା,” ଇଞ୍ଜି ଇଚାନ୍‌, ହେ ବିଚାର୍‌ କିନି ବାହାତ କୁଚ୍‌ଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","ହେ ଦିନ୍‌ ନିସ୍ତାର୍‌ ପାର୍ବୁନି ଜାଲ୍‌ଦି କିନି ଦିନ୍‌, ଆରେ ହେୱାଡ଼ାଂ ବେସିଆଉତିସ୍ ୱେଡ଼ାଲିଂ ସମୁ ଆଜ଼ି ମାଚାତ୍‌ । ଆରେ, ପିଲାତ ଜିହୁଦିରିଂ ଇଚାନ୍‌, “ହୁଡ଼ାଟ୍‌, ମି ରାଜା !” ");
INSERT INTO peg_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","ହେବେଣ୍ଡାଂ ହେୱାର୍‌ କିର କିତାର୍‌, “ତାଙ୍ଗେଙ୍ଗ୍‌ ଅହାଟ୍‌, ଅହାଟ୍‌, କ୍ରୁସ୍‌ତ ଦୁପାଟ୍‌ ।” ପିଲାତ ହେୱାରିଂ ଇଚାନ୍‌, ଆପ୍‌ ଇନାକା ମି ରାଜାଙ୍ଗ୍‌ କ୍ରୁସ୍‌ତ ଦୁପ୍‍ନାପ୍‌ କି ? ମୁଡ଼୍‌ ମାପ୍ରୁହେବାକିନାକାର୍‌ ଉତର୍‌ ହିତାର୍‌, “କାଇସର୍‌ତିଂ ପିସ୍ତି ମାଙ୍ଗେଙ୍ଗ୍‌ ଆରେ ରାଜା ଇନେର୍‌ ହିଲୁନ୍ ।” ");
INSERT INTO peg_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","ହେବେଣ୍ଡାଂ ହେୱାନ୍‌ ଇନେସ୍‌ କ୍ରୁସ୍‌ତ ଦୁପ୍‌ୟା ଆତାନ୍‌ମା, ଇଦାଂ କାଜିଂ, ହେୱାନ୍‌ ହେୱାନିଂ ହେୱାର୍‌ ଇଚାତାଂ ହେଲାୟ୍‌ କିତାନ୍‌, ତା ପାଚେ ଜିସୁଙ୍ଗ୍‌ ଅଜ଼ି ହାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","ଆରେ, ଜିସୁ ନିଜେ କ୍ରୁସ୍‌ ପିଣ୍‌ଜି ନିନ୍ଦାଣ୍‌ ତର୍‌ନି ବାହାତ ହାଚାନ୍‌, “ଇମ୍‌ଣାକା ଏବ୍ରି ବାସାତାଂ ଗଲ୍‌ଗତା ଇଞ୍ଜି ଇନାର୍‌, ହେବେ ହସି ହାଚାର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","ହେବେ ହେୱାର୍‌ ଜିସୁଙ୍ଗ୍‌ କ୍ରୁସ୍‌ତ ଦୁପ୍‌ତାର୍‌ ଆରି ତା ଲାହାଙ୍ଗ୍‌ ଆରେ ରିୟାରିଂ ଦୁପ୍‌ତାର୍‌, ରିକଣ୍ଡାଂ ରିକାରିଙ୍ଗ୍ ଆରି ମାଦି ଜିସୁଙ୍ଗ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","ଆରେ, ପିଲାତ ର ଦାବା କାଗଜ୍‌ ପା ଲେକିକିଜ଼ି କ୍ରୁସ୍‌ ଜପି ଡାଚ୍‌ଚାନ୍‌ । “ହେବେ ଲେକା ମାଚାତ୍‌, ନାଜରିତିୟ ଜିସୁ, ଜିହୁଦିର୍‌ ରାଜା । ");
INSERT INTO peg_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","ଜିହୁଦିର୍‌ ବିତ୍ରେ ହେନି ଇ ଦାବା କାଗଜ୍‌ ପଡ଼ି କିତାର୍‌, ଇନାକିଦେଂକି ଇମ୍‌ଣି ବାହାତ ଜିସୁଙ୍ଗ୍‌ କ୍ରୁସ୍‌ତ ଦୁପ୍‌ଚି ମାଚାର୍‌, ହେଦାଂ ଗାଡ଼୍‌ନି ଲାଗେ ମାଚାତ୍‌; ଆରେ, ହେ କାଗଜ୍‌ ଏବ୍ରି, ଲାଟିନ୍, ଆରି ଗ୍ରିକ୍‌ ବାସାତ ଲେକା ଆଜ଼ି ମାଚାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","ଲାଗିଂ ଜିହୁଦିର୍‌ ମୁଡ଼୍‌ ମାପ୍ରୁହେବାକିନାକାର୍ ପିଲାତଂ ଇଚାର୍‌, ଜିହୁଦିର୍‌ ରାଜା ଇଞ୍ଜି ଲେକିକିୱାଦାଂ ଇଚିସ୍‌ ଆନ୍‌ ଜିହୁଦିର୍‌ ରାଜା ଇଞ୍ଜି ହେୱାନ୍‌ ଇଚାନ୍‌, ଇଦାଂ ଲେକିକିୟାଟ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","ପିଲାତ ଉତର୍‌ ହିତାନ୍‌, “ଆପେଂ ଇମ୍‌ଣାକା ଲେକିକିତାପ୍‌ନା, ଲେକିକିତାପ୍‌ନା ।” ");
INSERT INTO peg_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","ମେଲ୍ୟାର୍‌ ଜିସୁଙ୍ଗ୍‌ କ୍ରୁସ୍‌ତ ଦୁପ୍‌ଚି ପାଚେ ହେୱାନ୍ତି ଆଙ୍ଗି ଅଜ଼ି ଚାରି ବାଟା କିତାର୍‌, ୱିଜ଼ାକାର୍‌ ମେଲ୍ୟାର୍‌ କାଜିଂ ର ର ବାଟା, ଆରେ ହେୱାର୍‌ ହେୱାନ୍ତି ଆଙ୍ଗି ପା ଅତାର୍‌ । ହେ ଆଙ୍ଗି ଡ଼ଚିଆ ଆୱାଦାଂ ଜପିତାଂ ତାରେନ୍‌ ପାତେକ୍‌ ୱିଜ଼ୁ ଡ଼ଚ୍‌ୟା ଆଜ଼ି ମାଚାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","ଲାଗିଂ ମେଲ୍ୟାର୍‌ ରକାନ୍ ଆରେ ରକାନିଂ ଇଚାର୍‌, “ଇଦାଂ ହେନ୍ଦ୍ରା କେଚୁସ୍, ମାତର୍‌ ଇଦାଂ ଇନେର୍‌ତି ଆନାତ୍‌, ହେଦାଂ କାଜିଂ ଦରମ୍‌ଗୁଲି କିନାସ୍‌,” ଇନେସ୍‌କି ଦରମ୍‌ ସାସ୍ତର୍‌ତାକେ ଇ ବଚନ୍‌ ପୁରା ଆନାତ୍‌, ହେୱାର୍‌ ଜାର୍‌ ଜାର୍‌ ବିତ୍ରେ ନା ଆଙ୍ଗି ବାଟା କିତାର୍‌, “ଆରେ ନା ଆଙ୍ଗି କାଜିଂ ଦରମ୍‌ଗୁଲି କିତାର୍‌ । ଲାଗିଂ ମେଲ୍ୟାର୍‌ ଇ ସବୁ କିତାର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","ମାତର୍‌ ଜିସୁତି କ୍ରୁସ୍‌ ଲାଗେ ହେ ତେହି ମରିୟମ୍‌, ହେୱାନ୍‌ ତେହି ତଣ୍‌ଦେହି, କଲପାତି ଡକ୍ରୁହି ମରିୟମ୍‌, ଆରି ମଗ୍‌ଦଲିନି ମରିୟମ୍‌ ନିଲ୍‌ଚି ମାଚିକ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","ଜିସୁ ଜାର୍‌ ଆୟା ଆରି ଇମ୍‌ଣି ଚେଲାଂ ଜିଉନଜ଼ି ମାଚାନ୍‌, ହେ ଲାଗାଂ ନିଲ୍‌ଚି ମାନାକା ହୁଡ଼୍‌ଜି ତାଡ଼ିଙ୍ଗ୍ ଇଚାନ୍‌, “ହୁଡ଼ା ନି ମାଜ଼ି !” ");
INSERT INTO peg_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","ତା ପାଚେ ହେୱାନ୍‌ ହେ ଚେଲାଂ ଇଚାନ୍‌, ହୁଡ଼ାଟ୍‌, “ଇଦେଲ୍‌ ମିଞ୍ଜି ଆୟା !” ଆରେ, ହେ ସମୁତାଂ ହେ ଚେଲା ତାଙ୍ଗେଙ୍ଗ୍‌ ଜାର୍‌ ଇଞ୍ଜ ଅଜ଼ି ହାଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","ଇଦାଂ ପାଚେ ଜିସୁ ଦରମ୍‌ ସାସ୍ତର୍‌ ବଚନ୍‌ ଇନେସ୍‌ ପୁରା ଆନାତ୍‌, ଇଦାଂ କାଜିଂ ୱିଜ଼ୁ ବିସ୍ରେ ନଂଗୟ୍ ୱିସ୍ତାତ୍‍ନା ଇଞ୍ଜି ପୁଞ୍ଜି ଇଚାନ୍‌, “ନାଙ୍ଗେଙ୍ଗ୍‌ ଏସ୍‌କି କିଦ୍‌ନାତା ।” ");
INSERT INTO peg_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","ହେବେ କେନିରାସ୍‌ ବାର୍ତି ର ବାହା ମାଚାତ୍‌; ଲାଗିଂ ହେୱାର୍‌ କେନିରାସ୍‌ ବାର୍ତି ର ରୁଆ ଉଚୁଟିଂ ଏଜପନାଲତ ଡେଙ୍ଗା ବେଡ୍‌ଗା ଆହି କିଜ଼ି ତାଙ୍ଗ୍‌ ମୁମ୍‌ ଲାଗାଂ ହିତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","ହେବେଣ୍ଡାଂ ଜିସୁ ହେ କେନିରାସ୍‌ ଉଣ୍‌ଜି ଇଚାନ୍‌, ୱିସ୍ତାତ୍; ଆରେ, ହେୱାନ୍‌ କାପ୍‌ଡ଼ା ତାରେନ୍‌ କିଜ଼ି ଜିବୁନ୍‌ ପିସ୍ତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","ହେ ଦିନ୍‌ ଜାଲ୍‌ଦି କିନି ଦିନ୍‌ ମାଚିଲେ, ଗାଗାଡ଼୍‌ ଇନେସ୍‌ ଜମ୍‌ନିବାର୍‌ ନାଜିଂ କ୍ରୁସ୍‌ ଜପି ମାନ୍‍ଗୁତ୍ ଇନାକିଦେଂକି ହେ ଜମ୍‌ନିବାର୍‌ ଗାଜା ଦିନ୍‌ ମାଚାତ୍‌, ହେଦାଂ କାଜିଂ ହେୱାର୍‌ତି କାଲ୍‌କୁ ଡ୍ରିକ୍‍କାଟ୍‌ ଆରି ହେୱାରିଂ କ୍ରୁସ୍‌ତ ତାଙ୍ଗ୍‌ ତାରେନ୍‌ ଜୁତ୍‌ତାଟ୍‌ ବିନ୍‌ ବାହାତ ଅୟାଆୟେର୍‌ ଇଞ୍ଜି ଜିହୁଦି ନେତାର୍‌ ପିଲାତଂ ଗୱାରି କିତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","ଲାଗିଂ ମେଲ୍ୟାର୍‌ ୱାଜ଼ି ପର୍ତୁମ୍‌ ନିକାନିଂ କାଲ୍‌ ଆରି ତା ହୁଦାଂ ଇମ୍‌ଣି ରକାନ୍‌ କ୍ରୁସ୍‌ତ ଦୁପ୍‌ୟା ଆଜ଼ି ମାଚାନ୍‌, ତା କାଲ୍‌ ପା ଡ୍ରିକ୍‌ତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","ମତର୍‌ ହେୱାର୍‌ ଜିସୁତି ଲାଗେ ୱାଜ଼ି ହେୱାନ୍‌ ହାତାନେ ଇଞ୍ଜି ହୁଡ଼୍‌ଜି ହେୱାନ୍ତି କାଲ୍‌ ଡ୍ରିକ୍‌ୱାତାର୍, ");
INSERT INTO peg_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","ମେଲ୍ୟାର୍‌ ବିତ୍ରେ ରକାନ୍‌ ବାଲାତାଂ ହେୱାନିଂ କଚଣ୍‌ତ କୁନ୍‌ତାନ୍‌, ଆରେ ଦାପ୍ରେ ନେତେର୍‌ ଆରି ଏଜ଼ୁଂ ହତ୍‌ତିକ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","ଇନେର୍‌ ହୁଡ଼୍‌ତାର୍‌ନା, ହେୱାନ୍‌ ସାକି ହିନାନା, ଇନେସ୍‌କି ଏପେଙ୍ଗ୍‌ ପା ପାର୍ତି କିୟାଟ୍‌; ଆରେ, ହେୱାନ୍ତି ସାକି ହାତ୍‌ପା, ଆରେ ହେୱାନ୍‌ ଜେ ହାତ୍‌ପା ଇନାନ୍ନା, ଇଦାଂ ହେୱାନ୍‌ ପୁନାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","ଇନାକିଦେଂକି ଦରମ୍‌ ସାସ୍ତର୍‌ ଇ ବଚନ୍‌ ପୁରା ଆଦେଂ କାଜିଂ ଇ ୱିଜ଼ୁ ବିସ୍ରେ ଗିଟା ଆତାତ୍‌, “ହେୱାନ୍ତି ଉଚୁକ୍‌ ପା ପ୍ଡେନ୍‌ ଡ୍ରିଙ୍ଗୁତ୍ ।” ");
INSERT INTO peg_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","ଆରେ ରଗ ଦରମ୍‌ ସାସ୍ତର୍‌ ଆରେ ର ବଚନ୍‌ ଇଦାଂ ଲେକାଆତାତ୍‌ନା, ହେୱାର୍‌ ଇନେରିଂ ଅସ୍ତାର୍‌, ହେୱାନ୍‌ କାଜିଂ ହୁଡ଼୍‌ନାନ୍ । ");
INSERT INTO peg_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","ଇ ସବୁ ଗଟ୍‌ଣା ପାଚେ, ଇମ୍‌ଣି ହାରାମାତିୟାତି ଜସେପ୍‌ ଜିସୁତି ରକାନ୍‌ ଚେଲା ମାଚାନ୍‌, ମାତର୍‌ ଜିହୁଦି ନେତାର୍‌ ପାଣ୍ଡ୍ରୁତିଂ ଡ଼ୁଗ୍‌ଜି ମାଚାନ୍‌, ହେୱାନ୍‌ ଜିସୁତି ଗାଗାଡ଼୍‌ ଅଦେଂ କାଜିଂ ପିଲାତଂ ଗୱାରି କିତାନ୍‌ । ହେବେ ପିଲାତ ପିସ୍ତି ହିତାନ୍‌ । ଲାଗିଂ ହେୱାନ୍‌ ୱାଜ଼ି ହେୱାନ୍ତି ଗାଗାଡ଼୍‌ ଅତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","ଇମ୍‌ଣି ନିକଦିମ୍‌ ପର୍ତୁମ୍‌ ନାଣା ସମୁତ ହେ ଲାଗାୟ୍‌ ୱାଜ଼ି ମାଚାନ୍‌, ହେୱାନ୍‌ ପା କମ୍‌ସେକମ୍‌ ତିରିସ୍‌ କେଜି ବାସ୍‌ନା ଚିକାଣ୍‌ ମିହାଆତି ଅଙ୍ଗୁର୍‌ ତାହିୱାତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","ହେୱାର୍‌ ଜିସୁତି ଗାଗାଡ଼୍‌ ଅଜ଼ି ଜିହୁଦିର୍ତି ମାଡ଼ା ମୁଚ୍‌ନି ବିଦି ଲାକେ ହେଦାଂ ହାର୍‌ଦି ବାସ୍‌ନା ଜିନିସ୍‌ ହୁକେ କୱାଣ୍‌ ହେନ୍ଦ୍ରାତ ହୁର୍ପାତାର୍ । ");
INSERT INTO peg_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","ହେୱାନ୍‌ ଇମ୍‌ଣି ବାହାତ କ୍ରୁସ୍‌ ଦୁପ୍‌ୟା ଆଜ଼ି ମାଚାନ୍‌, ହେ ବାହାତ ର ବାଡ଼୍‌ ମାଚାତ୍‌, ଆରେ ହେ ବାଡ଼୍‌ଦ ର ପୁନି ଦୁଗେର୍‌ ମାଚାତ୍‌, ହେବେ ଇନେର୍‌ ଇନାୱାଡ଼ାଂ ଇଟ୍ୟା ଆୱାଦାଂ ମାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","ଆରେ, ଜିହୁଦିର୍ତି ଜାଲ୍‌ଦି କିନି ଦିନ୍‌ କାଜିଂ ହେ ବାହାତ ହେୱାର୍‌ ଜିସୁଙ୍ଗ୍‌ ଇଟ୍‌ତାର୍‌, ଇନାକିଦେଂକି ହେ ଦୁଗେର୍‌ ଲାଗାୟ୍‌ ମାଚାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","ସାତ୍‌ ଦିନ୍‌ନି ପର୍ତୁମ୍‌ ରଇବାର୍‌ ନାଜିଂ ନାଣାଙ୍ଗେ ମାଜ୍‌ଗା ମାନୁ ମାନୁ ମଗ୍‌ଦଲିନି ମରିୟମ୍‌ ଦୁଗେର୍‌ ଲାଗେ ହାଲ୍‌ଜି ହେବେତାଂ କାଲ୍‌ ଗୁଚ୍‌ଆତାକା ହୁଡ଼୍‌ତିକ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","ଲାଗିଂ ହେଦେଲ୍‌ ହଞ୍ଚି ହାଲ୍‌ଜି ସିମନ୍‌ ପିତର୍‌ ଆରି ଜିସୁ ଇନେରିଂ ଜିଉନଜ଼ି ମାଚାନ୍‌, ହେ ବିନ୍‌ ଚେଲା ଲାଗେ ୱାତାତ୍‌, ଆରେ ହେୱାରିଂ ଇଚାତ୍‌, “ହେୱାର୍‌ ଦୁଗେର୍‌ତାଂ ମାପ୍ରୁଙ୍ଗ୍‌ ଅଜ଼ି ହାଚାର୍ଣ୍ଣା, ଆରେ ତାଙ୍ଗେଙ୍ଗ୍‌ ଇମେତାକେ ଇଡ୍‌ତାର୍‌ନ୍ନା, ହେଦାଂ ଆପେଂ ପୁନୁୱାତାପ୍‌ନା ।” ");
INSERT INTO peg_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","ହେବେତାଂ ପିତର୍‌ ଆରି ହେ ବିନ୍‌ ଚେଲା ଦୁଗେର୍‌ ଲାଗେ ହାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","ହେୱାର୍‌ ରିୟାର୍‌ ରସମାନ୍‌ ହନ୍ତେଙ୍ଗ୍‌ ଲାଗାତାର୍‌, ଆରେ ହେ ବିନ୍‌ ଚେଲା ପିତର୍‌ତିଂ ପାଚେ କିଜ଼ି ଆଗେ ଦୁଗେର୍‌ ତାକେ ଏକାତାନ୍‌, ");
INSERT INTO peg_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","ଆରେ, ଟଡ଼୍‌ଜି ବିତ୍ରେ ହୁଡ଼୍‌ତାନ୍‌ ହାରୁ କୱାଣ୍‌ ହେନ୍ଦ୍ରା ୱିଜ଼ୁ ଆର୍ତାକା ହୁଡ଼୍‌ତାନ୍‌, ଆତିସ୍‌ପା ହେୱାନ୍‌ ବିତ୍ରେ ହଣ୍‌ୱାତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","ପାଚେ ସିମନ୍‌ ପିତର୍‌ ପା ତାପାଚେ ପାଚେ ୱାଜ଼ି ଏକାୱାତାର୍‌ ଆରି ଦୁଗେର୍‌ ବିତ୍ରେ ହଣ୍‌ଜି ହୁଡ଼୍‌ତାର୍‌ ଜେ, ହାରୁ କୱାଣ୍‌ ହେନ୍ଦ୍ରାଙ୍ଗ୍‌ ଆର୍‌ତିକ୍‌ନା, ");
INSERT INTO peg_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","ଆରି ତା କାପ୍‌ଡ଼ାତ ଇମ୍‌ଣି ତୁୱାଲ୍‌ ଗାଚ୍ୟା ଆଜ଼ି ମାଚାନ୍‌ ହେଦାଂ ହାରୁ କୱାଣ୍‌ ହେନ୍ଦ୍ରା ଲାହାଙ୍ଗ୍‌ ମାନ୍‌ୱାଦାଂ ବିନ୍‌ ର ବାହାତ ଡାବା ଆଜ଼ି ମାଚାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","ହେପାଦ୍‌ନା ଇମ୍‌ଣି ବିନ୍‌ ଚେଲା, ଇମ୍‌ଣାକାନ୍‌ ଆଗେ ଦୁଗେର୍‌ ଲାଗେ ୱାଜ଼ି ମାଚାନ୍‌ ହେୱାନ୍‌ ପା ବିତ୍ରେ ହଣ୍‌ଜି ହୁଡ଼୍‌ତାନ୍‌ ଆରି ପାର୍ତି କିତାନ୍‌; ");
INSERT INTO peg_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","ଇନାକିଦେଂକି ହାତାକାର୍‌ ବିତ୍ରେ ହେୱାରିଂ ଜେ ନିଙ୍ଗି କିୟାଆନାତ୍‌, ସାସ୍ତର୍‌ ଇ ବଚନ୍‌ ହେୱାର୍‌ ହେପାତେକ୍‌ ବୁଜାଆୱାଦାଂ ମାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","ପାଚେ ଚେଲାର୍‌ ହେୱାର୍‌ ଇଞ୍ଜ ହାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","ମାତର୍‌ ମରିୟମ୍‌ ଆଡ଼୍‌ଜି ଆଡ଼୍‌ଜି ବାର୍‌ତ ଦୁଗେର୍‌ ଲାଗେ ନିଲ୍‌ଚି ମାଚାତ୍‌; ପାଚେ, ଆଡ଼୍‌ଜି ଆଡ଼୍‌ଜି ହେଦେଲ୍‌ ଟଡ଼୍‌ଜି ଦୁଗେର୍‌ ବିତ୍ରେ ହୁଡ଼୍‌ତାତ୍‌, ");
INSERT INTO peg_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","ଆରେ ଜିସୁତି ଗାଗାଡ଼୍‌ ଇମ୍‌ଣି ବାହାତ ଇଡ଼୍‌ଜି ମାଚାର୍‌, ହେବେନି କାପ୍‌ଡ଼ା ଲାଗାଂ ରୱାନ୍‌ ଆରି ପାନା ଲାଗାଂ ଇ ଲାକେ ରିୟାର୍‌ ଡ଼ିଞ୍ଜ୍‌ନି ହେନ୍ଦ୍ରା ଉସ୍ପିତି ଦୁତ୍‌ତିଂ କୁଚ୍‌ଚି ମାନାକା ହୁଡ଼୍‌ତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","ହେୱାର୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ଇଚାର୍‌, “ଏ ଆୟା, ଇନେକିଦେଂ ଆଡ଼୍‌ବାନାୟା ?” ହେଦେଲ୍‌ ହେୱାରିଂ ଇଚାତ୍‌, “ଇମ୍‌ଣାକାର୍‌ ନା ମାପ୍ରୁଙ୍ଗ୍‌ ଅଜ଼ି ହାଚାର୍ଣ୍ଣା, ଆରେ ତାଙ୍ଗେଙ୍ଗ୍‌ ଇମ୍‌ଣି ବାହାତ ଇଡ୍‌ତାର୍‌ନ୍ନା, ହେଦାଂ ଆନ୍‌ ପୁନୁଙ୍ଗ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","ହେଦେଲ୍‌ ଇଦାଂ ଇଞ୍ଜି ପାଚ୍‌ବାଗାଂ ବୁଲାଆଜ଼ି ଜିସୁଙ୍ଗ୍‌ ନିଲ୍‌ତାକା ହୁଡ଼୍‌ତିକ୍‌, ମାତର୍‌ ହେୱାନ୍‌ ଜେ ଜିସୁ, ହେଦାଂ ପୁନ୍‌ୱିତିକ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","ଜିସୁ ତାଙ୍ଗେଙ୍ଗ୍‌ ଇଚାନ୍‌, “ଏ ଆୟା, ଇନେକିଦେଂ ଆଡ଼୍‌ବାନାୟା ? ଇନେରିଂ ଦାହ୍‌ନାୟା ?” ହେଦେଲ୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ବାଡ଼୍‌ନି ହାଉକାର୍‌ ଇଞ୍ଜି ବାବି କିଜ଼ି ମାଚାତ୍‌, ମାନିନି, “ଏନ୍‌ ଜଦି ତାଙ୍ଗେଙ୍ଗ୍‌ ଅଜ଼ି ହାଚାୟ୍‌ନା, ତା ଆତିସ୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ଇମ୍‌ଣି ବାହାତ ଇଡ଼୍‌ତାଦେର୍ଣ୍ଣା, ନାଙ୍ଗେଙ୍ଗ୍‌ ୱେଚ୍‌ଚାଟ୍‌, ଆରେ ଆନ୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ଅଜ଼ି ହାନାଂ ।” ");
INSERT INTO peg_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","ଜିସୁ ତାଙ୍ଗେଙ୍ଗ୍‌ ଇଚାନ୍‌, “ମରିୟମ୍‌ ।” ହେଦେଲ୍‌ ବୁଲାଆଜ଼ି ଏବ୍ରି ବେରଣ୍‌ତାଂ ତାଙ୍ଗେଙ୍ଗ୍‌ ଇଚାତ୍‌, “ରାବ୍‌ବୁନି” ଇଚିସ୍‌ ଏ ଗୁରୁ । ");
INSERT INTO peg_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","ଜିସୁ ତାଙ୍ଗେଙ୍ଗ୍‌ ଇଚାନ୍‌, “ନାଙ୍ଗେଙ୍ଗ୍‌ ଆସ୍ତି ମାଞ୍ଜ୍‌ମାଟ୍‌,” ଇନାକିଦେଂକି ଆନ୍‌ ଇ ପାତେକ୍‌ ଆବା ଲାଗାଂ ହାଲୁଙ୍ଗେ, “ମାତର୍‌ ନା ଟଣ୍ଡାର୍‌ ଲାଗେ ହାଲ୍‌ଜି ଇନାଟ୍‌, ଆନ୍‌ ନା ଆବାଂ ଆରି ମିଞ୍ଜି ଆବାଂ, ନା ଇସ୍ୱର୍‌ ଆରି ମି ଇସ୍ୱର୍‌ ଲାଗାଂ ଦୁମ୍‌ନାଙ୍ଗା ।” ");
INSERT INTO peg_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","ମଗ୍‌ଦଲିନି ମରିୟମ୍‌ ହାଲ୍‌ଜି, ଆନ୍‌ ମାପ୍ରୁଙ୍ଗ୍‌ ହୁଡ଼୍‌ତାଙ୍ଗ୍‌ନା, ଆରେ ହେୱାନ୍‌ ନାଙ୍ଗେଙ୍ଗ୍‌ ଇ ସବୁ ୱେଚ୍‌ଚାତାନ୍ନା ଇଞ୍ଜି ଚେଲାରିଂ କାବୁର୍‌ ୱେଚ୍‌ଚାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","ହେ ନାଜିଂ, ଇଚିସ୍‌ ସାତ୍‌ ଦିନ୍‌ନି ପର୍ତୁମ୍‌ ରଇବାର୍‌ ନାଜିଂ ମ୍ଡିକା ସମୁତ ଏଚେକାଡ଼୍‌ଦ ଚେଲାର୍‌ ଇମ୍‌ଣି ଇଞ୍ଜ ମାଚାର୍‌, ହେବେ ଦୁୱେର୍‌ଙ୍ଗ୍‌ ଜିହୁଦିର୍‌ ପାଣ୍ଡ୍ରୁତିଂ ବନ୍ଦ୍‌ ମାଚାତ୍‌, ହେ ପାଦ୍‌ନା ଜିସୁ ୱାଜ଼ି ମାଦି ନିଲ୍‌ଚି ହେୱେରିଂ ଇଚାର୍‌, “ମିଦାଙ୍ଗ୍‌ ସୁସ୍ତା ଆଏତ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","ଆରେ, ଇଦାଂ ଇଞ୍ଜି ହେୱାନ୍‌ ହେୱେରିଂ ଜାର୍‌ କଚଣ୍‌ ଆରି ପାନା ଚଚ୍‌ଚାନ୍‌ । ହେବେତାଂ ଚେଲାର୍‌ ମାପ୍ରୁଙ୍ଗ୍‌ ହୁଡ଼୍‌ଜି ୱାର୍‌ୟା ଆତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","ଜିସୁ ହେୱେରିଂ ଆରେ ରଗ ଇଚାନ୍‌, “ମିଦାଙ୍ଗ୍‌ ସୁସ୍ତା ଆଏତ୍‌; ଆବା ଇନେସ୍‌କି ନାଙ୍ଗେଙ୍ଗ୍‌ ପକ୍‌ତାତାନ୍ନା, ଆନ୍‌ ପା ହେ ଲାକେ ମିଙ୍ଗେଙ୍ଗ୍‌ ପକ୍ତାନାଙ୍ଗା ।” ");
INSERT INTO peg_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","ହେୱାନ୍‌ ଇଦାଂ ଇଞ୍ଜି ହେୱାର୍‌ ଜପି ନେନ୍‌ଜି ହେୱେରିଂ ଇଚାନ୍‌, “ପୁଇପୁୟା ଜିବୁନ୍‌ତିଂ ଇଟ୍ୟା ।” ");
INSERT INTO peg_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","ଏପେଙ୍ଗ୍‌ ଜଦି ଇନେରିଂ ପାପ୍‌ କେମା କିନାଦେର୍‌, “ତାଦାଂ ପାପ୍‌ କେମା ଆନାତ୍‌; ଆରି, ଜଦି ଇନେର୍‌ତି ପାପ୍‌ କେମା କିଉଦେର୍‌, ତାଦାଂ ପାପ୍‌ କେମା ଆଉତ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","ମାତର୍‌ ଜିସୁ ଏଚେକାଡ଼୍‌ଦ ୱାଜ଼ି ମାଚାନ୍‌, ହେପାଦ୍‌ନା ବାରଜାଣ୍‌ ବିତ୍ରେ ତମା ତର୍‌ଦାକାନ୍‌ ରକାନ୍‌, ଇମ୍‌ଣାକାନିଂ “ଦିଦୁମ୍‌” ଇନାର୍‌ ହେୱାନ୍‌ ହେୱାର୍‌ ଲାହାଙ୍ଗ୍‌ ହିଲ୍‌ୱାତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","ଲାଗିଂ, ବିନ୍‌ ଚେଲାର୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ଇଚାର୍‌, “ଆପେଂ ମାପ୍ରୁଙ୍ଗ୍‌ ହୁଡ଼୍‌ତାପ୍‌ନା ।” ତମା ହେୱାନ୍‌ ହେୱେରିଂ ଇଚାନ୍‌, “ତା କେଇଦ ୱାଡ଼ିଙ୍ଗ୍‌ ଚିନ୍‌ସବୁ ହୁଡ଼୍‌ୱିତିସ୍‌ ଆରି ହେ ସବୁ ବାହାତ ନା ୱାଚ୍‌କାଙ୍ଗ୍‌ ହୁଡ଼୍‌ୱିତିସ୍‌ ଆରି ହେ କାଲ୍‌କୁ ନା କେଇ ହୁଡ଼୍‌ୱିତିସ୍‌ ଆନ୍‌ ଇନାୱାଡ଼ାଂପା ପାର୍ତି କିଉଙ୍ଗ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","ଆଟ୍‌ ଦିନ୍‌ ପାଚେ ତା ଚେଲାର୍‌ ଆରେ ରଗ ବିତ୍ରେ ମାଚାର୍‌ ଆରି ତମା ହେୱାର୍‌ ଲାହାଙ୍ଗ୍‌ ମାଚାନ୍‌ । କାପାଟ୍‌ ସବୁ ବନ୍ଦ୍‌ ମାନି ସମୁତ ଜିସୁ ୱାଜ଼ି ମାଦି ନିଲ୍‌ଚି ଇଚାନ୍‌, “ମିଦାଙ୍ଗ୍‌ ସୁସ୍ତା ଆଏତ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","ପାଚେ ହେୱାନ୍‌ ତମାଙ୍ଗ୍‌ ଇଚାନ୍‌, “ଇନ୍‌ଟାଙ୍ଗ୍‌ କେଇ ଲାମାୟ୍‌କିଦା ନା କେଇ ହୁଡ଼ା, ନା କାଲ୍‌କୁ ହୁଡ଼ା; ପାର୍ତି କିୱାକାର୍‌ ଆଜ଼ି ପାର୍ତି କିୟାଟ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","ତମା ତାଙ୍ଗେଙ୍ଗ୍‌ ଉତର୍‌ ହିତାନ୍‌, “ନା ମାପ୍ରୁ, ନା ଇସ୍ୱର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","ଜିସୁ ତାଙ୍ଗେଙ୍ଗ୍‌ ଇଚାନ୍‌, “ଏନ୍‌ ଇନାକା ନାଙ୍ଗ୍‌ ହୁଡ଼୍‌ଜି ପାର୍ତି କିଦ୍‌ନାୟା ? ଇମ୍‌ଣାକାର୍‌ ହୁଡ଼୍‌ୱାଦାଂ ପାର୍ତି କିତାର୍‌, ହେୱାର୍‌ ଦନ୍ୟ ।” ");
INSERT INTO peg_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","ଜିସୁ ଚେଲାର୍‌ ମୁମ୍‌ଦ ଇ ଲାକେ ବେସି ଆରି ବିନ୍‌ବିନ୍‌ ବାନି କାବାଆନି କାମାୟ୍‌ କିତାନ୍‌ନ୍ନା, ହେ ୱିଜ଼ୁ ଇ ପତିତ ଲେକା ଆୱାତାତ୍‌ନା । ");
INSERT INTO peg_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","ମାତର୍‌ ଏପେଙ୍ଗ୍‌ ଇନେସ୍‌ ପାର୍ତି କିନାଦେର୍‌ ଜେ ଜିସୁ ଇସ୍ୱର୍‌ ମାଜ଼ି କ୍ରିସ୍ଟ ଆତାନ୍ନା, ଆରେ ପାର୍ତି କିଜ଼ି ଇନେସ୍‌କି ଏପେଙ୍ଗ୍‌ ହେ ତର୍‌ଦାଂ ଜିବୁନ୍‌ ପାୟା ଆନାଦେର୍‌, ଇଦାଂ କାଜିଂ ଇ ୱିଜ଼ୁ ଲେକାଆତାତ୍‌ନା । ");
INSERT INTO peg_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","ଇଦାଂ ପାଚେ ଜିସୁ ତିବିରିୟା ହାମ୍‌ଦୁର୍‌ ଗୁଟିତ ବାରଜାଣ୍‌ ଚେଲାରିଂ ଆରେ ରଗ ଚଞ୍ଜିୟାଆତାନ୍‌ । ହେୱାନ୍‌ ଇ ଲାକେ ଚଞ୍ଜିୟାଆତାନ୍‌; ");
INSERT INTO peg_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","ସିମନ୍‌ ପିତର୍‌, ତମା, ଇମ୍‌ଣାକାନିଂ ଦିଦୁମ୍‌ ଇନାର୍‌, ଗାଲିଲିନି କାନାନିକାନ୍‌ ନିତନିୟେଲ୍‌, ଜେବ୍‌ଦି ମାଜ଼ିର୍‌ ଆରି ତା ଚେଲାର୍‌ ବିତ୍ରେତାଂ ଆରେ ରିକାର୍‌ ରବେ ମାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","ସିମନ୍‌ ପିତର୍‌ ହେୱାରିଂ ଇଚାର୍‌, “ଆନ୍‌ ମିନ୍‌କୁ ଆସ୍ତେଙ୍ଗ୍‌ ହାନାଙ୍ଗା ।” ହେୱାର୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ଇଚାର୍‌, “ଆପେଂ ପା ମି ଲାହାଙ୍ଗ୍‌ ହାନାପ୍‌ ।” ହେୱାର୍‌ ହସି ହାଲ୍‌ଜି ଡଙ୍ଗାତ କୁଚ୍‌ଚାର୍‌, ଆରେ ହେ ମ୍ଡିକା ବିର୍‌କୁଲ୍‌ ଆସ୍ତେଙ୍ଗ୍‌ ଆଡ୍‌ୱାତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","ମାତର୍‌ ଅଜଡ଼୍‌ ଆତି ପାଚେ ଜିସୁ ଗୁଟିତ ନିଲ୍‌ତାନ୍‌; ଆତିସ୍‌ପା ହେୱାନ୍‌ ଜିସୁ ଇଞ୍ଜି ଚେଲାର୍‌ ପୁନ୍‌ୱାତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","ଜିସୁ ହେୱେରିଂ ଇଚାନ୍‌, “ହିମ୍‌ଣାଂ, ମି ତାକେ ଇନାକା ଇଚୁକ୍‌ ତିନାକା ମାନାତ୍‌ ?” ହେୱାର୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ଉତର୍‌ ହିତାର୍‌, “ହିଲୁତ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","ଜିସୁ ହେୱେରିଂ ଇଚାନ୍‌, “ଡଙ୍ଗାନି ତିନିପାଡ଼୍‌କା ଲାଗାୟ୍‌ ଜାଲ୍‌ ଇଡ଼ାଟ୍‌, ଆରେ ଏପେଙ୍ଗ୍‌ ପାୟା ଆନାଦେର୍‌ ।” ହେବେଣ୍ଡାଂ ହେୱାର୍‌ ଜାଲ୍‌ ଇଡ଼ିତାର୍‌, ଆରେ ଏଚେକ୍‌ ମିନ୍‌କୁ ହେସ୍‌ତିକ୍‌ ଜେ, ହେୱାର୍‌ ହେଦାଂ ଜେଲ୍‌ଦେଂ ସାକ୍ତି ହିଲାତାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","ହେବେତାଂ ଜିସୁ ଇମ୍‌ଣି ଚେଲାହିଂ ଜିଉନଜ଼ି ମାଚାନ୍‌, ହେୱାନ୍‌ ପିତର୍‌ତିଂ ଇଚାନ୍‌, “ଇୱାନ୍ତ ମାପ୍ରୁ ।” ସିମନ୍‌ ପିତର୍‌ ଇୱାନ୍ତ ମାପ୍ରୁ ଇଞ୍ଜି ୱେନ୍‌ଞ୍ଜି ଡୁମ୍‌ଣ୍ଡା ଗାଗାଡ଼୍‌ ଆଜ଼ି ମାଚିଲେ ଜାର୍‌ ହେନ୍ଦ୍ରା ପର୍‌ଚି ହାମ୍‌ଦୁର୍‌ତ ଗୁମ୍‌ତାନ୍‌; ");
INSERT INTO peg_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","ମାତର୍‌ ବିନ୍‌ ଚେଲାର୍‌ ମିନ୍‌କୁ ବାର୍ତି ଆଜ଼ି ମାଚି ଜାଲ୍‌ ଜେଲ୍‌ଜି ଜେଲ୍‌ଜି ହାରୁ ଡଙ୍ଗାତ ୱାତାର୍‌, ଇନାକିଦେଂକି ହେୱାର୍‌ ଗୁଟିତାଂ ଆଦିକ୍‌ ଦେହା ହିଲ୍‌ୱାତାର୍‌, କେବଲ୍‌ ଆଦେକ୍‌ ଦୁଇସ ଆତ୍‌ ଦେହା ମାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","ହେୱାର୍‌ ଗୁଟିତ ଜୁଜ଼ି ହେବେ ରିକାଙ୍ଗ୍‌ ନାଣି, ଆରେ ହେ ଜପି ୱାସ୍ତି ମିନ୍‌ ଆରି ରୁଟି ଇଡ଼୍‌ଜି ମାଚାକା ହୁଡ଼୍‌ତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","ଜିସୁ ହେୱେରିଂ ଇଚାନ୍‌, “ଏପେଙ୍ଗ୍‌ ନଙ୍ଗୟ୍‌ ଇମ୍‌ଣି ମିନ୍‌ ଆସ୍ତାଦେର୍ଣ୍ଣା, ହେବେଣ୍ଡାଂ ଉଚୁଙ୍ଗ୍‌ ତାଡୁ ।” ");
INSERT INTO peg_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","ସିମନ୍‌ ପିତର୍‌ ହାଲ୍‌ଜି ସହେ ପଚାସ୍‌ତିନ୍‌ ଗାଜା ଗାଜା ମିନ୍‌କୁତ ବାର୍ତି ଆଜ଼ି ମାଚି ଜାଲ୍‌ ଗୁଟିତ ଜେଲ୍‌ଜି ତାତାର୍‌; ଆରେ ଏଚେକ୍‌ ମିନ୍‌କୁକାଂ ପା ଜାଲ୍‌ ନାଡ୍‌ୱାତାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","ଜିସୁ ହେୱେରିଂ ଇଚାନ୍‌, “ୱାଜ଼ି ତିନାଟ୍‌ ।” ଚେଲାର୍‌ ବିତ୍ରେ ଇନେନ୍‌ “ଏନ୍‌ ଇନାକାୟ୍‌” ଇଞ୍ଜି ତାଙ୍ଗେଙ୍ଗ୍‌ ୱେନ୍‌ବେଦେଂ ସାସ୍‌ କିୱାଦାଂ ମାଚାର୍‌, ଇନାକିଦେଂକି ହେୱାନ୍‌ ଜେ, ମାପ୍ରୁ, ଇଦାଂ ହେୱାର୍‌ ପୁଞ୍ଜିମାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","ଜିସୁ ୱାଜ଼ି ରୁଟି ଆସ୍ତି ହେୱେରିଂ ହିତାନ୍‌, ଆରେ ହେ ଲାକେ ମିନ୍‌କୁ ପା ହିତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","ହାତାକାର୍‌ ବିତ୍ରେ ନିଙ୍ଗ୍‌ତି ପାଚେ ଜିସୁ ଚେଲାରିଂ ଇୱାନ୍‌ ତିନି ହଟ୍‌ ଚଞ୍ଜିୟାଆତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","ହେୱାର୍‌ ଚିଚିପାଚେ ଜିସୁ ସିମନ୍‌ ପିତର୍‌ତିଂ ୱେନ୍‌ବାତାନ୍‌, “ଏ ଜହନ୍‌ତି ମାଜ଼ି ସିମନ୍‌, ଏନ୍‌ ଇନାକା ନାଙ୍ଗେଙ୍ଗ୍‌ ଇୱାର୍‌ତାଂ ବେସି ଜିଉନଦ୍‌ନାୟା ?” ସିମନ୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ଇଚାନ୍‌, “ଆଁ, ମାପ୍ରୁ, ଆନ୍‌ ଜେ ନିଙ୍ଗେଙ୍ଗ୍‌ ୱାରି କିଦ୍‌ନାଙ୍ଗା ।” ହେଦାଂ ଏନ୍‌ ପୁନାୟ୍‌ । “ହେୱାନ୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ଇଚାନ୍‌, ନା ମେଣ୍ଡାକାଂ ହାରାୟ୍‌କିୟା ।” ");
INSERT INTO peg_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","ହେୱାନ୍‌ ଆରେ ରଗ ରିହା ତାଙ୍ଗେଙ୍ଗ୍‌ ୱେନ୍‌ବାତାନ୍‌, “ଏ ଜହନ୍‌ ମେହି ସିମନ୍‌, ଏନ୍‌ ଇନାକା ନାଙ୍ଗ୍‌ ଜିଉନଦ୍‌ନାୟା ?” ହେୱାନ୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ଇଚାନ୍‌, “ଆଁ, ମାପ୍ରୁ, ଆନ୍‌ ଜେ ନିଙ୍ଗେଙ୍ଗ୍‌ ୱାରି କିଦ୍‌ନାଙ୍ଗା ।” ହେଦାଂ ଏନ୍‌ ପୁନାୟ୍‌ । ହେୱାନ୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ଇଚାନ୍‌, “ନା ମେଣ୍ଡାକାଂ ହାରାୟ୍‌ କିୟାଟ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","ଜିସୁ ତିନ୍‌ତର୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ୱେନ୍‌ବାତାନ୍‌, “ଏ ଜହନ୍‌ ମେହି ସିମନ୍‌, ଏନ୍‌ ଇନାକା ନାଙ୍ଗେଙ୍ଗ୍‌ ୱାରି କିଦ୍‌ନାୟା ?” ଏନ୍‌ ଇନାକା ନାଙ୍ଗେଙ୍ଗ୍‌ ୱାରି କିଦ୍‌ନାୟା, ଇଦାଂ ଇଞ୍ଜି ହେୱାନ୍‌ ତିନ୍‌ତର୍‌ ପିତର୍‌ତିଂ ୱେନ୍‌ବିତିଲେ ହେୱାନ୍‌ ଦୁକ୍‌ ଆଜ଼ି ତାଙ୍ଗେଙ୍ଗ୍‌ ଇଚାନ୍‌, “ମାପ୍ରୁ, ଏନ୍‌ ୱିଜ଼ୁ ବିସ୍ରେ ପୁନାୟ୍‌; ଆନ୍‌ ଜେ ନିଙ୍ଗେଙ୍ଗ୍‌ ୱାରି କିଦ୍‌ନାଙ୍ଗା, ହେଦାଂ ଏନ୍‌ ପୁନାୟ୍‌ ।” ଜିସୁ ତାଙ୍ଗେଙ୍ଗ୍‌ ଇଚାନ୍‌, “ନା ମେଣ୍ଡାକାଂ ହାରାୟ୍‌କିୟା ।” ");
INSERT INTO peg_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","ହାତ୍‌ପା ହାତ୍‌ପା ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ଇଞ୍ଜ୍‌ନାଙ୍ଗା, ବେଣ୍ଡିୟା ମାନି ସମୁତ ଏନ୍‌ ଜାର୍‌ ଗାଚ୍ୟା ଆଜ଼ି ଇମେନିପ ମାନ୍‌, ହେ ନିପ ବୁଲାଆଜ଼ି ମାଚାୟ୍‌, ମାତର୍‌ ବୁଡ଼ାଆତିସ୍‌ ଏନ୍‌ ଜାର୍‌ କେଇ ଲାମାୟ୍‌ କିନାୟ୍‌ ଆରି ବିନ୍‌ ନିକାନ୍‌ ନିଙ୍ଗ୍‌, ଗାଚ୍‌ଚି, ଇମେନିପ ନି ମାନ୍‌ ମାନ୍‌ଗୁତ୍‌, ହେନ୍‌ଟାଂ ନିଙ୍ଗେଙ୍ଗ୍‌ ଅଜ଼ି ହାଞ୍ଜ୍‌ନାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","ହେୱାନ୍‌ ଇନେସ୍‌ ବାନି ହାକିଦାଣ୍ଡ୍‌ ହୁକେ ଇସ୍ୱର୍‌ତିଂ ଜାଜ୍‌ମାଲ୍‌ କିନାନ୍‌, ହେବେ ଚଚ୍‌ଚି ହିିଜ଼ି ହେୱାନ୍‌ ଇଦାଂ ଇଚାନ୍‌ । ଇଦାଂ ୱେଚ୍‌ଚି ପାଚେ ହେୱାନ୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ଇଚାନ୍‌, “ନା ପାଚେ ପାଚେ ୱାଡ ।” ");
INSERT INTO peg_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","ଜିସୁ ଇମ୍‌ଣି ଚେଲାହିଂ ଜିଉନଜ଼ି ମାଚାନ୍‌ ଆରି ଜେ ମ୍ଡିକା କୁଲେର୍‌ଉଣି ସମୁତ ତାଙ୍ଗେଙ୍ଗ୍‌ ନେଞ୍ଜେଡାକିତ ଇଡ଼ିୟା ଆଜ଼ି, “ମାପ୍ରୁ, ନିଙ୍ଗେଙ୍ଗ୍‌ ଇନେନ୍‌ ବେରିୟାର୍‌ କେଇଦ ହେଲାୟ୍‌ କିଦ୍‌ନାନ୍‌ ଇଞ୍ଜି ୱେନ୍‌ବିସ୍‌ ମାଚାନ୍‌, ହେ ଚେଲାଙ୍ଗ୍‌ ପିତର୍‌ ମାସ୍‌ଦି ପାଚେ ୱାଜ଼ି ମାନାକା ହୁଡ଼୍‌ତାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","ପିତର୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ହୁଡ଼୍‌ଜି ଜିସୁଙ୍ଗ୍‌ ୱେନ୍‌ବାତାନ୍‌, “ମାପ୍ରୁ, ଇୱାନ୍‌ ବିସ୍ରେ ଇନାକା ଇଞ୍ଜ୍‌ନାୟା ?” ");
INSERT INTO peg_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","ଜିସୁ ତାଙ୍ଗେଙ୍ଗ୍‌ ଇଚାନ୍‌, ନା, ୱାନି ପାତେକ୍‌ ହେୱାନ୍‌ ମାନେନ୍‌ ଇଞ୍ଜି “ଜଦି ଆନ୍‌ମାନ୍‌ କିନାଙ୍ଗ୍‌, ତା ଆତିସ୍‌ ହେବେ ମିଦାଙ୍ଗ୍‌ ଇନାକା ମାନାତ୍‌ ? ଏପେଙ୍ଗ୍‌ ନା ପାଚେ ୱାଡ ।” ");
INSERT INTO peg_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","ହେବେଣ୍ଡାଂ ହେ ଚେଲା ଜେ ହାଉନ୍‌ ଇଞ୍ଜି, ଟଣ୍ଡାର୍‌ ବିତ୍ରେ ଇ ବେରଣ୍‌ ୱିଣ୍‌ଜି ହାତାତ୍‌, ମାତର୍‌ ହେୱାନ୍‌ ହାଉନ୍‌ ଇଞ୍ଜି ଜିସୁ ତାଙ୍ଗେଙ୍ଗ୍‌ ୱେଚ୍‌ୱାଦାଙ୍ଗ୍‌, ମାତର୍‌ “ନା ୱାନି ପାତେକ୍‌ ହେୱାନ୍‌ ମାନେନ୍‌ ଇଞ୍ଜି ଜଦି ଆନ୍‌ମାନ୍‌ କିନାଙ୍ଗ୍‌, ତା ଆତିସ୍‌ ହେବେ ମିଦାଙ୍ଗ୍‌ ଇନାକା ମାନାତ୍‌ ଇଞ୍ଜି ଇଞ୍ଜି ମାଚାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","ଜେ ଇ ୱିଜ଼ୁ ବିସ୍ରେ ସାକି ହିନାନା ଆରି ଇ ୱିଜ଼ୁ ଲେକିକିତାନ୍‌ନା, ହେୱାନ୍‌ ହେ ଚେଲା; ଆରେ, ହେ ସାକି ଜେ, ହାତ୍‌ପା, ହେଦାଂ ଆପେଂ ପୁନାପ୍‌ । ");
INSERT INTO peg_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","ଆରେ, ଜିସୁ ଆରି ବେସି ବେସି କାମାୟ୍‌ ପା କିଜ଼ି ମାଚାନ୍‌; ହେୱାଙ୍ଗ୍‌ ୱିଜ଼ୁ ଜଦି ରଞ୍ଜାଙ୍ଗ୍‌ ରଞ୍ଜାଙ୍ଗ୍‌ କିଜ଼ି ଲେକା ଆତାତ୍ମା, ତା ଆତିସ୍‌ ଏଚେକ୍‌ ପତିଙ୍ଗ୍‌ ଲେକା ଆତିକ୍‌ମା ଜେ, ନା ବାବ୍‌ନାତ ୱିଜ଼ୁ ପୁର୍ତିତ ପା ହେ ୱିଜ଼ୁ ଇଟ୍‌ନି କାଜିଂ ବାହା ଆୱାତାତ୍ମା ।");
INSERT INTO peg_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","ଏ ୱାରିନି ତିୟପିଲ୍‌, ଇମ୍‌ଣି ଦିନ୍‌ ଜିସୁ ଜାର୍‌ ବାଚିକିତି ପକ୍ୟାତାକାରିଂ ପୁଇପୁୟା ଜିବନ୍‌ ଲାହାଙ୍ଗ୍‌ ବଲ୍‌ ହିଜ଼ି ଜପି ଅୟାତାନ୍‌, ");
INSERT INTO peg_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","ବାଦାଡ଼୍‌ତ ଦୁମ୍‌ନି ପାତେକ୍‌ ଇମ୍‌ଣି ସବୁ କାମାୟ୍‌ କିଜ଼ି ମାଚାର୍‌ ଆରି ବଲ୍‌ ହିଜ଼ି ମାଚାର୍‌, ହେ ୱିଜ଼ୁ ବିସ୍ରେ ଲେକିକିଜ଼ି ମାଚାଙ୍ଗ୍‌ । ବାଦାଡ଼୍‌ତ ଦୁମ୍‌ନି ଆଗେ ଇମ୍‌ଣାକାରିଂ ହେୱାନ୍‌ ଜାର୍‌ ପକ୍ୟାତାକାର୍‌ ଲାକେ ବାଚି କିଜ଼ି ମାଚାନ୍‌, ହେୱାରିଂ ହେୱାନ୍‌ ପୁଇପୁୟା ଜିବୁନ୍‌ ସାକ୍ତିତାଂ ବଲ୍‌ ହିଜ଼ି ମାଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","ଜିସୁ ପା ଜାର୍‌ ଦୁକ୍‍ବଗ୍‍ ପାଚେ ଆଦେକ୍‌ ପାର୍ମାଣ୍‍ ହୁକେ ହେୱାର୍‌ ତାକେ ଜାର୍‌ତିଂ ଜିଜ଼ି ମାନାକା ଚଚ୍‍ଚାନ୍, ଆରେ ରିକଡ଼ି ଦିନ୍‌ ପାତେକ୍‌ ତାଇନାତ୍‌ ହେୱାରିଂ ଚଞ୍ଜ୍ୟା ଆଜ଼ି ଇସ୍ୱର୍‌ତି ରାଜିନି ବିସ୍ରେ ଇଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","ରଗ ହେୱାର୍‌ ହୁକେ ଚିଞ୍ଜେଙ୍ଗ୍‌ କୁଚ୍‍ନି ୱେଡ଼ାଲିଂ ଜିସୁ ହେୱାରିଂ ଇ ବଲ୍‌ ହିଜ଼ି, “ଏପେଙ୍ଗ୍‌ ଜିରୁସାଲମ୍‌ତାଂ ହାଲ୍‌ମାଟ୍‌, ମାତର୍‌ ଆବାତି ଇମ୍‌ଣି ପାର୍ମାଣ୍‌ ବିସ୍ରେ ନା ତାଙ୍ଗ୍‌ ୱେଚାଦେର୍ଣ୍ଣା, ହେବେ କାସିମାନାଟ୍; ");
INSERT INTO peg_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","ଇନେକିଦେଂକି ଜହନ୍‌ ଏସ୍‌ତ ବାପ୍ତିସିମ୍‌ ହିତାନ୍‌ ସତ୍‌, ମାତର୍‌ ଅଲପ୍‍ ଦିନ୍‌ ବିସ୍ରେ ପୁଇପୁୟା ଜିବୁନ୍‌ତ ବାପ୍ତିସିମ୍‌ ଆନାଦେର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","ଲାଗିଂ ହେୱାର୍‌ ରବେ ରୁଣ୍ଡା ଆଜ଼ି ହେୱାନିଂ ଗୱାରି କିଦେଙ୍ଗ୍‌ ଲାଗାତାର୍‌; “ଏ ମାପ୍ରୁ, ଏନ୍‌ ଇନାକା ଇ ସମୁତ ଇସ୍ରାଏଲ୍‌ କେଇଦ ଆରେରଗ ରାଜିନି ବଜ୍‌ ହେଲାୟ୍‌ କିନାୟା ?” ");
INSERT INTO peg_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","ହେୱାନ୍‌ ହେୱାରିଂ ଇଚାନ୍‌, “ଇମ୍‌ଣି ୱିଜ଼ୁ କାଡ଼୍‌ କି ସମୁ ଆବା ଜାର୍‌ ଆଦିକାର୍‌ ତାରେନ୍‌ ଇଡ଼୍‌ତାନ୍ନା ହେଦାଂ ମିଦାଙ୍ଗ୍‌ ପୁନି ବିସ୍ରେ ଆକାୟ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","ମାତର୍‌ ପୁଇପୁୟା ଜିବୁନ୍‌ ମି ଜପି ଜୁଜ଼ି ୱାତିସ୍, ଏପେଙ୍ଗ୍‌ ସାକ୍ତି ପାୟାନାଦେର୍‌, ଆରେ ଜିରୁସାଲମ୍‌ ୱିଜ଼ୁ ଜିହୁଦା ରାଜି ଆରି ସମିରଣ୍‌ ଆରେ ପୁର୍ତିନି ହାରିହାରା ହାନ୍ଦି ପାତେକ୍‌ ପା ନା ସାକି ଆନାଦେର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","ହେୱାନ୍‌ ଇ ୱିଜ଼ୁ କାତା ଇଚି ପାଚେ ହେୱାର୍‌ ହୁଡ଼ୁ ହୁଡ଼ୁ ହେୱାନ୍‌ ଜପି ଅୟାତାନ୍‌, ଆରେ ଅଲପ୍‍ ବାଦାଡ଼୍‌ତ ହେୱାନିଂ ହେୱାର୍‌ ନଞ୍ଜର୍‌ତାଂ ଦେହା ଆତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","ଜିସୁ ହାଲୁ ହାଲୁ ହେୱାର୍‌ ବାଦାଡ଼୍‌ ନିପ ମିଟ୍‍କିୱାଦାଂ ହୁଡ଼୍‍ନାରା, ଇ ଲାକେ ସମୁତ, ହୁଡ଼ାଟ୍‌, ଡ଼ିଞ୍ଜ୍‍ନି ହେନ୍ଦ୍ରା ଉସ୍ପାତାକାର୍‍ ରିକାର୍‌ ଆଣ୍ଡ୍ରାଙ୍ଗ୍‌ ହେୱାର୍‌ ଲାଗାଂ ଇକାୱାତାର୍‌, ");
INSERT INTO peg_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","ଆରେ ହେୱାର୍‌ ଇଚାର୍‌, “ଏ ଗାଲିଲିୟର୍ ଲକୁ, ଇନାକିଦେଂ ଏପେଙ୍ଗ୍‌ ବାଦାଡ଼୍‌ ନିପ ହୁଡ଼୍‌ଜି ନିଲ୍‍ତାଦେର୍ଣ୍ଣା ? ଇ ଇମ୍‌ଣି ଜିସୁ ମିତାଙ୍ଗ୍ ବାଦାଡ଼୍‌ତ ଅୟାତାନ୍‌, ହେୱାନିଂ ଏପେଙ୍ଗ୍‌ ଇନେସ୍‌ ବାନି ବାଦାଡ଼୍‌ତ ହାନାକା ହୁଡ଼୍‍ତାଦେର୍, ହେୱାନ୍‌ ହେ ଲାକେ ମାଜ଼୍‌ଦି ୱାନାନ୍ ।” ");
INSERT INTO peg_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","ଇଦାଂ ପାଚେ ପକ୍ୟାତାକାର୍‌ ଜିତ୍‌ ଇନି ମାଡ଼ିତାଂ ଜିରୁସାଲମ୍‌ତ ମାସ୍‌ଦି ୱାତାର୍ । ହେ ଜିରୁସାଲମ୍‌ ଲାଗେ, ର ଜମ୍‍ନିବାର୍‌ନି ହାଜ଼ି ର କିଲମିଟର୍‌ ଦେହା ମାଚାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","ହେୱାର୍‌, ଇଚିସ୍‌ ପିତର୍‌, ଜହନ୍‌, ଜାକୁବ୍‌, ଆନ୍ଦ୍ରିୟ, ପିଲିପ୍‌, ତମା, ବାର୍ତଲମି, ମାତିଉ, ଆଲପିତି ମେହି ଜାକୁବ୍‌, ତିର୍‍କାଡ଼୍‍ ସିମନ୍‌ ଆରି ଜାକୁବ୍‌ତି ମେହି ଜିହୁଦା, ଜିରୁସାଲମ୍‌ ଗାଡ଼୍‌ ବିତ୍ରେ ହଣ୍‌ଜି, ଇମ୍‌ଣି ଜପ୍‌ଣି ବାକ୍ରାତ ହେୱାର୍‌ ବାହା କିଜ଼ି ମାଚାର୍‌, ହେବେ ହାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","ଇୱାର୍‌ ୱିଜ଼ାର୍‌ କଗ୍‍ଲେରାହିଂ ହୁକେ ଆରି ଜିସୁତି ତେହି ମରିୟମ୍‌ ଆରି ହେୱାର୍‌ତି ଟଣ୍ଡାର୍‌ ଲାହାଙ୍ଗ୍‌ ର ମାନ୍ତ ପାର୍ତାନାତ ଲାଗା ଆଜ଼ି ମାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","ହେ ପାର୍ତାନା ୱେଡ଼ାଲିଂ ପିତର୍‌ ତର୍‌ଦି ଟଣ୍ଡାର୍‌ ବିତ୍ରେ ମାଦି ଇଞ୍ଜ ଇଚାନ୍‌ ହେବେ ଜିସୁ ଆନ୍‌ମାନ୍‌ତାଂ ଚକଡ଼ି ଜାଣ୍‌ ରବେ ମାଚାର୍‌, ");
INSERT INTO peg_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“ଟଣ୍ଡାର୍‌, ଆରେ ତଣ୍‌ଦେକ୍‌ ଇମ୍‌ଣି ଇସ୍କାରିତ୍‌ ଜିହୁଦା ଜିସୁଙ୍ଗ୍‌ ଆହ୍‌ନି ମାନାୟାରିଂ ହାଜ଼ି ଚଚ୍‍ଚି ମାଚାନ୍‌, ହେ ବିସ୍ରେ ପୁଇପୁୟା ଜିବୁନ୍‌ ପୁର୍ବେତାଂ ଦାଉଦ୍‌ତି ୱେଇଦାଂ ଇନାକା ଇଞ୍ଜି ମାଚାର୍‌, ହେ ସାସ୍ତର୍‌ ବଚନ୍‌ ପୁରାଦେଂ ଲଡ଼ା ମାଚାତ୍‌; ");
INSERT INTO peg_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","ଇନାକିଦେଂକି ହେୱାନ୍‌ ମା ଦଲ୍‌ଦ ରୱାନ୍‌ ଇଞ୍ଜି ଗାଣାକିୟାଜ଼ି ମାଚାନ୍‌ ଆରି ହେବା ପାଦ୍‍ତ ମେହାଆଜ଼ି ମାଚାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","ଇ ମାନାୟ୍‌ ଜିହୁଦା ଅଦାର୍ମି ମଲ୍‌ ହୁକେ ର ବୁମି କଡ଼୍‌ଜି ମାଚାନ୍‌, ଆରେ, ହେୱାନ୍‌ କାପ୍‌ଡ଼ା ଇଡ଼୍‌ୟାଜ଼ି ଆର୍ତିଲେ ହେୱାନ୍ତି ପଟ ପାଡ଼୍‍ତାତ୍ ଆରି ୱାହିଂ ହସି ହାଚିକ୍‍; ");
INSERT INTO peg_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","ଆରେ, ଇଦାଂ ଜିରୁସାଲମ୍‌ ଗାଡ଼୍‌ଦ ବାହାକିତି ୱିଜ଼ାକାର୍‌ ପୁଚିଲେ ହେ ବୁମି ହେୱାର୍‌ତି ଜାର୍‌ ବେରଣ୍‍ତ “ହକଲ୍‌ଦମା” ଇଚିସ୍‌ “ନେତେର୍‌ ବୁମି” ଇଞ୍ଜି ପୁଟାତାତ୍‍ । ");
INSERT INTO peg_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","“ଆରେ ପତିତ ଲେକାମାନାତ୍‌, ‘ହେୱାନ୍ତି ବାହା ମେଲାୟେତ୍, ହେବେ ଇନେର୍‌ ବାହା କିମେନ୍‍ ।’ ଆରି ହେୱାନ୍‌ କାମାୟ୍‌ତ ଆରେ ବିନ୍‌ନିକାନ୍‌ ପାୟାୟେନ୍ ।” ");
INSERT INTO peg_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","“ଲାଗିଂ, ମାପ୍ରୁ ଜିସୁ ଜହନ୍‌ ହୁକେ ବାପ୍ତିସିମ୍‌ ଅନି ସମୁତାଂ ଆରମ୍‌ କିଜ଼ି, ମା ଲାଗାଂ ଜପିତାଂ ଅୟାନି ଦିନ୍‌ ପାତେକ୍‌ ଏଚେକ୍‌ ସମୁ ମା ବିତ୍ରେ ବୁଲା ଚାଲା ଆଜ଼ି ମାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","ହେ ସମୁ ଇମ୍‌ଣି ମାନାୟାର୍‌ ମା ହାଙ୍ଗ୍‌ଦାକାର୍‌ ଆତାର୍ଣ୍ଣା, ହେୱାର୍‌ ବିତ୍ରେତାଂ ଜହନ୍‌ ବାପ୍ତିସିମ୍‌ ଅଜ଼ି ମା ଲାହାଂ ହେୱାନ୍ତି ଆରେ ନିଂନାକା ସାକି ଆଦେଂ ଲଡ଼ା ।” ");
INSERT INTO peg_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","ହେବେ ହେୱାର୍‌ ରିୟାରିଂ, ଇଚିସ୍‌ ଜସେପ୍‌ତିଂ, ଇନେରିଂ ବର୍ସବା ଇଞ୍ଜି ଇନାର୍‌ ଆରି ଇନେର୍‌ର୍ତି କୁକ୍‌ନି ତର୍‌ ଜୁସ୍ତ, ଆରି ମତିୟ ବିନେ ତର୍‌ ହିତାର୍‌, ");
INSERT INTO peg_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","ଇ ପାର୍ତାନା କିତାର୍‌, “ମାପ୍ରୁ ସବୁ ଲକାର୍‌ତି ଚିନ୍ତା ପୁନି ମାପ୍ରୁ ଇ ରିୟାର୍‌ ବିତ୍ରେତାଂ ମି ହୁକେ ଇନେର୍‌ ବାଚି କିୟାତାନ୍‌ ମାଙ୍ଗେଙ୍ଗ୍‌ ୱେଚ୍‌ଚାଟ୍‌, ");
INSERT INTO peg_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","ଇ ମାନାୟ୍‌, ଜିହୁଦାତି ବାହାତ ପକ୍ୟାତି ହେବା ପାଦ୍‌ କାମାୟ୍‌ କିନାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","ଆରେ, ହେୱାର୍‌ ହେ ରିୟାର୍‌ କାଜିଂ ଦରମ୍‌ଗୁଲି କିତାର୍‌, ଆରେ ମତିୟ ତର୍‌ଦ ଦରମ୍‌ଗୁଲି ନିଂତାତ୍; ହେବେ ହେୱାନ୍‌ ଏଗାର୍ ଜାଣ୍‌ ପକ୍ୟାତାକାର୍‌ ଲାହାଂ ମିହାତାନ୍ । ");
INSERT INTO peg_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","ଜିହୁଦିର୍‌ତି ପେଣ୍ଟିକସ୍ଟ ପାର୍ବୁ ଦିନ୍‌ ଏକାୱାତିଲେ, ୱିଜ଼ାର୍‌ ର ବାହାତ ରୁଣ୍ଡାଜ଼ି ମାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","ଆରେ, ହାଚାଟ୍ରେ ବେସି ଦୁକାନି ଗାର୍ଜାନ୍‌ ଲାକେ ର ଗାର୍ଜାନ୍‌ ହାଚାଟ୍ରେ ବାଦାଡ଼୍‌ତାଂ ୱାଜ଼ି, ଇମ୍‌ଣି ଇଞ୍ଜ ହେୱାର୍‌ କୁଚ୍‌ଚି ମାଚାର୍‌, ହେ ଇଲ୍‌ନି ୱିଜ଼େନିପ ମେଙ୍ଗ୍‌ତାତ୍, ");
INSERT INTO peg_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","ଆରେ ନାଣି ଲାକେ ୱେନ୍ଦୁଲିଂ ହେୱାର୍‌ତି ନଞ୍ଜର୍‌ ଆଜ଼ି ରଞ୍ଜାଙ୍ଗ୍‌ ରଞ୍ଜାଙ୍ଗ୍‌ କିଜ଼ି ହେୱାର୍‌ତି ୱିଜ଼ାରିଂ ଜପିତାଂ ଡୁତାତ୍ । ");
INSERT INTO peg_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","ହେବେ ୱିଜ଼ାକାର୍‌ ପୁଇପୁୟା ଜିବୁନ୍‌ତ ବାର୍ତି ଆତାର୍‌, ଆରେ ଜିବୁନ୍‌ ହେୱାରିଂ ଇନେସ୍‌ ଇଞ୍ଜେଙ୍ଗ୍‌ ସାକ୍ତି ହିତାତ୍, ହେ ଲାକେ ହେୱାର୍‌ ବିନ୍‌ ବିନ୍‌ ବେରଣ୍‍ତ କାତା ଇଞ୍ଜେଙ୍ଗ୍‌ ଲାଗାତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","ଇ ସମୁତ ପେଣ୍ଟିକସ୍ଟ ପାର୍ବୁ ପାଲି କିନି ଉଦେସ୍‌ତ ବାଦାଡ଼୍‌ ତାରେନ୍‌ ମାନି ସବୁ ଜାତିତାଂ ପୁଜାରିର୍‌ ଜିହୁଦିର୍‌ ୱାଜ଼ି ଜିରୁସାଲମ୍‌ତ ବାହା କିଜ଼ି ମାଚାର୍‌; ");
INSERT INTO peg_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","ଆରେ, ହେ ଗାର୍ଜାନ୍‌ ୱେଚିଲେ, ହେନି ଲକୁ ରୁଣ୍ଡା ଆଜ଼ି କ୍ରିସ୍ଟଙ୍ଗ୍‌ ପାର୍ତି କିନାକାର୍‌ ଜାଣ୍‍କେ ଜାର୍‌ ଜାର୍‌ ବେରଣ୍‍ତ ହେୱାରିଂ କାତା ଇନାକା ୱେନ୍‌ଞ୍ଜି କାବା ଆତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","ଆରେ, “ହେୱାର୍‌ କାବା ଆରି ବକ୍‍ୱା ଆଜ଼ି ଇଞ୍ଜେଙ୍ଗ୍‌ ଲାଗାତାର୍‌, ହୁଡ଼ାଟ୍‌, ଇ ଇମ୍‌ଣି ମାନାୟାର୍‌ କାତା ଇନାରା, ହେୱାର୍‌ ୱିଜ଼ାର୍‌ ଇନାକା ଗାଲିଲିୟର୍‌ ଆକାୟ୍‌ ? ");
INSERT INTO peg_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","ୱାଟିଙ୍ଗ୍‌, ଆସେଙ୍ଗ୍‌ ଇନେସ୍‌ ଜାଣ୍‍କେ ଇନାକା ଜାର୍‌ ଜାର୍‌ ବାସା ବେରଣ୍‌ କାତା ୱେନାସା ? ");
INSERT INTO peg_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","ପାର୍ତିୟା, ମାଦିୟା ଆରି ଏଲାମି, ଆରେ ମେସପଟାମିଆ, ଜିହୁଦା ଦେସ୍ ଆରି କାପ୍ପାଦକିଆ, ପନ୍ତ ଆରି ଆସିଆ, ");
INSERT INTO peg_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","ପ୍ରୁଗିଆ ଆରି ପଂପୁଲିଆ, ମିସର୍‌ ଆରି କୁରିଣି ଲାଗେନି ଲିବିଆ ନିପନି ଲକୁ, ଆରି ରମ୍‌ତାଂ ୱାଜ଼ି ମାନି ଜିହୁଦି ଆରି ଜିହୁଦି ଦରମ୍‌କିନାକାର୍, ");
INSERT INTO peg_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","ଆରେ କ୍ରିତିୟ ଆରି ଆରବିୟ ଲକୁ ଜେ ଆସେଙ୍ଗ୍‌, ଆସେଙ୍ଗ୍‌ ଜାର୍‌ ଜାର୍‌ ବାସାତ ଜିହୁଦିରିଂ ଇସ୍ୱର୍‌ତି ଗାଜା ଗାଜା ସାକ୍ତି କାମାୟ୍‌ନି କାତା ଇନାକା ୱେନାସା ।” ");
INSERT INTO peg_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","ଆରେ, ୱିଜ଼ାକାର୍‌ କାବା ଆରି ବୁଦିବାଣା ଆଜ଼ି ହାରି ଇଞ୍ଜେଙ୍ଗ୍‌ ଲାଗାତାର୍‌, “ଇଦାଂ ଅରତ୍‌ ଇଚିସ୍‌ ଇନାକା ?” ");
INSERT INTO peg_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","ମାତର୍‌ ବିନ୍‌ଲଗୁ ପାର୍ତି କିନାକାରିଂ ଗ୍ଡାଜ଼ି ଇଚାର୍‌, “ଇୱେର୍‌ ପୁନି ଅଙ୍ଗୁର୍‌ ରାସ୍‌ତ ହଚ୍‌ଚାର୍ଣ୍ଣା ।” ");
INSERT INTO peg_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","ମାତର୍‌ ପିତର୍‌ ଏଗାର୍ ଜାଣ୍‌ ହୁକେ ଇଞ୍ଜ ଗାଜା କାଟ୍‌ତାଂ ହେୱାର୍‌ ତାକେ ଇଞ୍ଜି ଇଚାନ୍‌, ଏ ଜିହୁଦିର୍‌ ଲଗୁ ଆରି ଜିରୁସାଲମ୍‌ନି ୱିଜ଼ାକାଦେର୍, ଏପେଙ୍ଗ୍‌ ଇଦାଂ ପୁନାଟ୍‌ ଆରି ନା ବଚନ୍‌ ୱେନାଟ୍‌ । ଆନ୍‌ ଇ ବିସ୍ରେ ବୁଜାୟ୍‌ କିଦ୍‌ନାଙ୍ଗ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","ଇନାକିଦେଂକି ଏପେଙ୍ଗ୍‌ ଇନେସ୍‌ ବାବି କିନାଦେରା, ଇୱାର୍‌ ହେ ଲାକେ ହଚ୍‌ୱାତାର୍ଣ୍ଣା, ଲାଗିଂ ନଙ୍ଗ୍‌ ସମୁ ନାଡ଼ିହିଂ ନଅ ଗଣ୍ଟା ମତର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","ମାତର୍‌ ଜୟେଲ୍‌ ଇଞ୍ଜି ମାଚାନ୍‌, ବେଣ୍‌ବାକ୍‌ଣାୟ୍‌କିନାକାର୍‌ ତାଙ୍ଗ୍‌ ଇନାକା ଲେକାମାନାତ୍‌, ଇଦାଂ ହେ ବିସ୍ରେ । ");
INSERT INTO peg_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","“ଇସ୍ୱର୍‌ ଇନାନ୍‌, ସେସ୍‌ କାଡ଼୍‌ଦ ଏଲେଙ୍ଗ୍‌ କିନାଙ୍ଗ୍‌, ଆନ୍‌ ୱିଜ଼ାର୍‌ ଜପି ନା ଜିବୁନ୍‌ ବେସି ବାବ୍ରେ ହିନାଙ୍ଗ୍‌, ହେବେ ମି ହିମ୍‍ଣା ୱାକ୍‍ଡ଼ାର୍ ବେଣ୍‌ବାକ୍‌ଣାୟ୍‌କିନାକାନ୍‌, ଆରେ ମି ଦାଙ୍ଗ୍‌ଣାର୍ ହୁଡ଼୍‍ନାର୍‍, ଆରେ ମି ପ୍ରାଚିନାର୍‌ କ୍ଡେଞ୍ଜ୍‍ନାର୍, ");
INSERT INTO peg_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","ଆଁ, ହେ କାଡ଼୍‌ଦ ଆସେଙ୍ଗ୍‌ ଆଡ଼ିୟାଣି, ଆଣ୍ଡ୍ରାଙ୍ଗ୍‌ ଆରି କଗ୍‌ଲେହିମ୍‌ଣାଂ, ଜପି ଜାର୍‌ ଜିବୁନ୍‌ ହିନାଙ୍ଗ୍‌, ହେବେ ହେୱାର୍‌ ବେଣ୍‌ବାକ୍‌ଣାୟ୍‌କିନାକାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","ଆସେଙ୍ଗ୍‌ ଜପିନି ବାଦାଡ଼୍‌ତ ବାର୍‍ବିନ୍ କାବାନି କାମାୟ୍‌, ଆରେ ତାରେନ୍‍ନି ପୁର୍ତିତ ବାର୍‍ବିନ୍ ଚିନ୍‌କୁ, ନେତେର୍‌, ନାଣି ଆରି ବେସି କଦା ଚଚ୍‍ଚାନାପ୍ । ");
INSERT INTO peg_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","ମାପ୍ରୁତି ସିଗ୍ ଆରି ଜାଜ୍‌ମାଲ୍‌ନି ଦିନ୍‌ ୱାନି ଆଗେ, ୱେଡ଼ା ମାଜ୍‍ଗା ଆନାତ୍‌, ଆରି ଲେଞ୍ଜ୍ ନେତେର୍‌ ଆନାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","ଆରେ, ଏଲେଙ୍ଗ୍‌ ଗିଟାନାତ୍ ଜେ, ଇନେର୍‌ ମାପ୍ରୁତି ତର୍‌ଦ ପାର୍ତାନା କିନାନ୍‌, ହେୱାର୍‌ ରାକ୍ୟା ପାୟା ଆନାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“ଏ ଇସ୍ରାଏଲିୟନି ଲକୁ, ଇ ୱିଜ଼ୁ କାତା ୱେନାଟ୍‌ । ନାଜରିତିୟ ଜିସୁ ବାର୍‍ବିନ୍ ସାକ୍ତିନି କାମାୟ୍‌, କାବାନି କାମାୟ୍‌ ଆରି ଚିନ୍‌କୁ ହୁକେ ମି ଲାହାଂ ଇସ୍ୱର୍‌ତି ପକ୍ୟାତି ମୁଣିକା ଇଞ୍ଜି ପାର୍ମାଣ୍‍ ଆତାନ୍ନା, ହେୱାନ୍‍ତାଂ ଇସ୍ୱର୍‌ ଜେ ମିଙ୍ଗେଙ୍ଗ୍‌ ପା ଇ ୱିଜ଼ୁ କାମାୟ୍‌ କିତାନ୍‌ନ୍ନା, ଇଦାଂ ଏପେଙ୍ଗ୍‌ ଇଦାଂ ପୁନାଟ୍‌ ଇନାକିଦେଂକି ମି ବିତ୍ରେ ଇ ୱିଜ଼ୁ ଗଟ୍‌ଣା ବାର୍ତି ଆତାତ୍‌ନ୍ନା” ");
INSERT INTO peg_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","ଇସ୍ୱର୍‌ ତା ଉପାୟ୍‌ ଇସାବ୍ରେ ଜିସୁଂ ମି କେଇଦ ହେଲାୟ୍‌ କିନି କାଜିଂ ତିର୍‌ କିଜ଼ି ମାଚାନ୍‌ ଆରେ ଏପେଙ୍ଗ୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ଅଦାର୍ମି ହୁକେ କୁରୁସ୍‌ତ ଦୁପ୍‌ଚି ଅସ୍ତି ମାଚାଦେର୍‌; ");
INSERT INTO peg_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","ମାତର୍‌ ଇସ୍ୱର୍‌ ହାକିତାଂ ମୁକ୍‌ଡ଼ାୟ୍ କିଜ଼ି ଇସ୍ୱର୍‌ ହେୱାନିଂ ନିକ୍‍ତାନ୍ନା, ଇନାକିଦେଂକି ହେୱାନ୍‌ ଜେ ହାକିତାଂ ଗାଚ୍‍ୟାନାନ୍ ହେଦାଂ ମୁଡ଼େଆକାୟ୍ । ");
INSERT INTO peg_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","ଦାଉଦ୍‌ ତ ହେୱାନ୍ତି ବିସ୍ରେ ଇଚାନ୍ନା, “ନା ମୁମ୍‌ଦ ନିତ୍ରେ ମାପ୍ରୁଙ୍ଗ୍‌ ହୁଡ଼୍‌ତାଂ, ଇନାକିଦେଂକି ଆନ୍‌ ଇନେସ୍‌ ବିପ୍ତି ଆମେଙ୍ଗ୍, ହେଦାଂ କାଜିଂ ହେୱାନ୍‌ ନା ବୁଜ୍‌ଣି ପାଡ଼୍‍କାତ ମାନାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","ଲାଗିଂ ନା ମାନ୍ତ ୱାରି, ଆରି ନା ୱେନ୍ଦୁଲ୍ ସାର୍ଦା ଆତାତ୍‌, “ଆରେ ନା ଗାଗାଡ଼୍‌ ପା ବାର୍ସିତ ବାହା କିନାତ୍‌, ନା ବାର୍ସିତ ବାହା କିନାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","ଇନାକିଦେଂକି ଏନ୍‌ ନା ୱାସ୍କିତିଂ ପାତାଲ୍‌ତ ପିସ୍ତୁୟ୍, କି ଜାର୍‌ ପୁଇପୁୟା ହେବାକାରିୟାଂ ଜିରା ଆଦେଂ ହିଉୟ୍ । ");
INSERT INTO peg_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","ଏନ୍‌ନାଙ୍ଗ୍‌ ଜିବୁନ୍‌ନି ହାଜ଼ି ଚଚ୍‌ଚାତାୟ୍‍ନା, ଏନ୍‌ ଲାଗେ ମାନାକା ଏନ୍‌ ଜାର୍‌ ଲାଗେ ନାଂ ୱାରିତ ବାର୍ତି କିଦ୍‍ନାୟ୍ ।” ");
INSERT INTO peg_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“ଏ ଇସ୍ରାଏଲ୍‌ ଟଣ୍ଡାର୍‌ ଆରି ତଣ୍‌ଦେକ୍‌, ଆବା ଲାତ୍ରା ମୁଣିକା ଦାଉଦ୍‌ତି ବିସ୍ରେ ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ପୁଟ୍‍ତେ ଇଞ୍ଜେଙ୍ଗ୍‌ ଆଡ୍‌ନାଂ ଜେ, ହେୱାନ୍‌ ହାତାନ୍, ଆରେ ଦୁଗେର୍‍ ପାୟାତାନ୍‌, ଆରେ ହେୱାନ୍ତି ଦୁଗେର୍‌ ନେଞ୍ଜେଙ୍ଗ୍‌ ପାତେକ୍‌ ମା ବିତ୍ରେ ମାନାତ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","ରାଜା ଦାଉଦ୍‌ ରୱାନ୍‌ ବେଣ୍‌ବାକ୍‌ଣାୟ୍‌କିନାକାର୍‌ ବାବ୍ରେ ହେୱାନ୍ତି ନେତେର୍‌ତାଂ ଗାଟାତି ରୱାନିଂ ହେୱାନ୍ତି ଗାଦିତ ରାଜା କିଜ଼ି କୁଚି କିନି କାଜିଂ ଇସ୍ୱର୍‌ ହେୱାନିଂ ପାର୍ମାଣ୍‌ କିଜ଼ି ମାଚାନ୍‌ ଇଞ୍ଜି ପୁନ୍‌ଞ୍ଜି ମାଚାନ୍‌, ");
INSERT INTO peg_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","ଇଦାଂ ପୁଚିଲେ ହେୱାନ୍‌ ଆଗେନିକା କେଞ୍ଜ୍‌ନାକା ହୁକେ କ୍ରିସ୍ଟତି ଆରେ ନିଂନାକା ବିସ୍ରେ ଇଚାନ୍‌, ଇନାକିଦେଂକି ହେୱାନ୍‌ ପାତାଲ୍‌ତ ତୁହିକିୟା ଆୱାତାନ୍‌, କି ହେୱାନ୍ତି ଗାଗାଡ଼୍‌ କି ଗାଗାଡ଼୍‌ତ ଜିରା ଆୱାତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","ଇ ଜିସୁତି ଇସ୍ୱର୍‌ ନିକ୍‍ତାନ୍ନା, ହେ ବିସ୍ରେ ଆସେଙ୍ଗ୍‌ ୱିଜ଼ାକାସ୍ ସାକି । ");
INSERT INTO peg_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","ଜିସୁ ତା ଆବା ଇସ୍ୱର୍‌ତି ବୁଜ୍‌ଣି ବାଗାଙ୍ଗ୍‌ ଆରେ ନିଙ୍ଗ୍‌ତାନ୍ନା, ଆରି ଆବାତି ପାର୍ମାଣ୍‌ ଇସାବ୍ରେ ହେୱାନ୍‌ତାଂ ପୁଇପୁୟା ଜିବୁନ୍‌ ପାୟାତାନ୍ନା, ଏପେଙ୍ଗ୍‌ ନଙ୍ଗ୍‌ୟ୍‌ ହୁଡ଼୍‌ନାଦେରା ଆରି ୱେନାଦେରା ହେଦାଂ ତା ଦାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","ଇନାକିଦେଂକି ଦାଉଦ୍‌ ନିଜେ ବାଦାଡ଼୍‌ତ ଦୁମ୍‍ୱାଦାଂ ମାଚାନ୍‌, ମତର୍‌ ହେୱାନ୍‌ ନିଜେ ଇନାନ୍ନା, ମାପ୍ରୁ ନା “ମାପ୍ରୁଙ୍ଗ୍‌ ଇଚାନ୍, ");
INSERT INTO peg_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","ଆନ୍‌ ଇମ୍‌ଣି ପାତେକ୍‌ ମି ସାତ୍ରୁରିଂ ମି ପାନା ତାରେନ୍‌ ଇଟ୍‍ୱାତାପ୍‍ନା, ହେ ପାତେକ୍‌ ମା ବୁଜ୍‍ଣିତ କୁଚ୍‌ଚି ମାନାଟ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“ଲାଗିଂ, ୱିଜ଼ୁ ଇସ୍ରାଏଲ୍‌ ପୁନେର୍‌ ଜେ, ଇମ୍‌ଣି ଜିସୁଙ୍ଗ୍‌ ଏପେଙ୍ଗ୍‌ କ୍ରୁସ୍‌ତ ଅସ୍ତାଦେର୍, ହେୱାନିଂ ଇସ୍ୱର୍‌, ମାପ୍ରୁ ଆରି କ୍ରିସ୍ଟ ରି ପାଦ୍‍ତ ବାଚିକିତାନ୍ନା ।” ");
INSERT INTO peg_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","ଇ କାତା ୱେନ୍‌ଞ୍ଜି ହେୱାର୍‌ତି ମାନ୍ତ ରାସ୍‍ ଆଜ଼ି ହାଚାତ୍‌, ଆରେ ହେୱାର୍‌ ପିତର୍‌ ଆରି ବାକି ପକ୍ୟାତାକାର୍‌ରିଂ ଇଚାର୍‌, “ଟଣ୍ଡାର୍‌, ଆସେଙ୍ଗ୍‌ ଇନାକା କିନାସ୍‌ ?” ");
INSERT INTO peg_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","ହେବେ ପିତର୍‌ ହେୱାରିଂ ଇଚାନ୍‌, “ଏପେଙ୍ଗ୍‌ ମାନ୍‌ବାଦ୍‌ଲାୟ୍‌ କିୟାଟ୍‌, ଆରେ ଜାର୍‌ ଜାର୍‌ ପାପ୍‌ କେମା କାଜିଂ ସବୁଜାଣ୍ ଜିସୁ କ୍ରିସ୍ଟତି ତର୍‌ଦ ବାପ୍ତିସିମ୍‌ ଆଡୁ; ତା ଆତିସ୍‌ ଏପେଙ୍ଗ୍‌ ପୁଇପୁୟା ଜିବୁନ୍‌ତି ଦାନ୍‌ ପାୟାନାଦେର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","ଇନାକିଦେଂକି ଇ ଇସ୍ୱର୍‌ତି ପାର୍ମାଣ୍‌ ମି କାଜିଂ, ମି ହିମ୍‌ଣାୱାକ୍‍ଡ଼ା କାଜିଂ, ଆରେ ଇସ୍ୱର୍‌ତି କୁକ୍ୟାତି ଦେହା ଦେହାତାଂ ମାନି ଏଚେକ୍‌ ମାନାୟାରିଂ ମାପ୍ରୁ ମା ଇସ୍ୱର୍‌ ତା ତାକେ କୁକ୍‍ତାନାନ୍, ହେ ୱିଜ଼ାକାର୍‍ କାଜିଂ ଆନାତ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","ଆରି ବିନ୍‌ବିନ୍‌ ବେସି କାତା ହୁକେ ସାକି ହିଦେଂ ଲାଗାତାନ୍‌ ଆରି ହେୱାରିଂ ଉପ୍‌ଦେସ୍‌ ହିଜ଼ି ଇଚାନ୍‌, “ଇ ଇଲ୍‌ ଲାତ୍ରାତାଂ ଏପେଙ୍ଗ୍‌ ରାକ୍ୟା ପାୟା ଆଡୁ ।” ");
INSERT INTO peg_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","ହେବେ ଇମ୍‌ଣାକାର୍‌ ହେୱାନ୍ତି ବଚନ୍‌ ୱାସ୍କିତ ଇଡ୍‌ତାର୍‌, ହେୱାର୍‌ ବାପ୍ତିସିମ୍‌ ଅତାର୍‌, ଆରେ ହେ ଦିନ୍‌ ଆନାର୍‌ କିନ୍ଦା ତିନ୍‍ହାଜାର୍ ଲକୁ ଦଲ୍‌ ହୁକେ ମେହା ଆତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","ହେୱାର୍‌ ପକ୍ୟାତାକାର୍‌ ହିକ୍ୟା ମେହାବିଡ଼ାତ, ରୁଟି ଡ୍ରିକ୍‍ନିତ ଆରି ପାର୍ତାନାତ ର ମାନ୍‌ ଆଜ଼ି ମାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","ଆରେ, ଲକୁ କାବାନି କାମାୟ୍‌ ପାଣ୍ଡ୍ରାଦେଂ ଲାଗାତାର୍‌, ପକ୍ୟାତାକାର୍‌ ହୁଦାଂ ପା ଆଦେକ୍‌ କାବା କାମାୟ୍‌ ଆରି ଚିନ୍‌କୁ ଆଦେଂ ଲାଗାତାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","ମତର୍‌ ଇମ୍‌ଣାକାର୍‌ ପାର୍ତି କିତାର୍‍, ହେୱାର୍‌ ହାରିତିଂ ୱିଜ଼ାକାର୍‍ ରବେ ମାନ୍‌ଞ୍ଜି ସବୁ ଜିନିସ୍‌ ସିଦାସାଦା ସମ୍ପତି ଇଞ୍ଜି ଗିୟାଣ୍ କିଜ଼ି ମାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","ଆରେ ହେୱାର୍‌ ଜାର୍‌ ଜାର୍‌ ସମ୍ପତି ପ୍ରହି, ଇନେର୍‌ର୍ତି ଇନେସ୍‌ ଲଡ଼ା, ହେ ଲାକେ ୱିଜ଼ାକାରିଂ ପାସ୍‍ପିସ୍‍ ହିଦେଂ ଲାଗାତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","ଆରେ, ହେୱାର୍‌ ର ମାନ୍‌ ଆଜ଼ି ନିତ୍ରେ ମନ୍ଦିର୍‌ତ ମେହାଜ଼ି ମାଚାର୍‌ ଇଲ୍‌କୁ ଇଲ୍‌କୁ ରୁଟି ଡ୍ରିକ୍‌ଚି ୱାରିତାଂ ଆରି ହୁଦାର୍‌ ମାନ୍ତ ତିନାଉଣା କିଜ଼ି ");
INSERT INTO peg_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","ଇସ୍ୱର୍‌ତିଂ ଦନ୍ୟବାଦ୍‌ କିଜ଼ି ମାଚାର୍‌ ଆରି ୱିଜ଼ାକାର୍ ମାନାୟାର୍‌ତି ଲାଡ୍‍ ଆଜ଼ି ମାଚାର୍‌ । ଆରେ, ମାପ୍ରୁ ରାକ୍ୟା ଗାଟାତି ଲକାଂ ନିତ୍ରେ ମଣ୍ଡ୍‌ଲି ଦଲ୍‌ ହୁକେ ପାର୍ତି ମେହାୟ୍‍ କିଦେଙ୍ଗ୍‌ ଲାଗାତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","ଦିନେକ୍‌ ପାର୍ତାନାନି ସମାନ୍‌ ସମୁତ, ଇଚିସ୍‌ ମିକାହାରେସ୍‌ ତିନ୍‌ ଗଣ୍ଟା ୱେଡ଼ାଲିଂ, ପିତର୍‌ ଆରି ଜହନ୍‌ ମନ୍ଦିର୍‌ତ ହାଲ୍‌ଜି ମାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","ଏଲେଙ୍ଗ୍‌ ୱେଡ଼ାଲିଂ ଜଲମ୍‌ତାଂ ଚଟା ରୱାନ୍‌ ମାନାୟ୍‌ ପିଣ୍ତିୟା ଆଜ଼ି ହାଲ୍‌ଜି ମାଚାନ୍‌, ମନ୍ଦିର୍‌ତ ହଣାକାର୍‍ ମାନାୟାର୍‍ତାଂ ବିକ୍ୟା ଏନ୍‌ନି କାଜିଂ ଲକୁ ହେୱାନିଂ ନିତ୍ରେ ହେବେ ହଲ୍‍ନି ତର୍‌ ନି ଦୁୱେର୍‌ତ ଇଡ୍‌ବିସ୍ ମାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","ହେୱାନ୍‌ ପିତର୍‌ ଆରି ଜହନ୍‌ତିଂ ମନ୍ଦିର୍‌ତ ହଣ୍ଡେଙ୍ଗ୍‌ ହାନିହିଂ ହୁଡ଼୍‌ଜି ଗୱାରି କିଜ଼ି ବିକ୍‌ ଏନ୍ତେଙ୍ଗ୍‌ ଲାଗାତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","ପିତର୍‌ ଆରି ଜହନ୍‌ତାଙ୍ଗ୍‌ ର ଲୟାତ ହୁଡ଼୍‌ତାର୍‌, ଆରେ ପିତର୍‌ ଇଚାନ୍‌, “ମା ନିପ ହୁଡ଼୍‍ଦା ।” ");
INSERT INTO peg_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","ହେବେ ହେୱାନ୍‌ ହେୱାର୍‌ ତାଙ୍ଗ୍‌ ଅଲପ୍‍ ଗାଟାନି ଆହାତ ହେୱାର୍‌ ନିପ ହୁଡ଼୍‌ଜି ମାଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","ମତର୍‌ ପିତର୍‌ ଇଚାନ୍‌, “ରୁପା କି ହନା ନାଦାଂ ହିଲୁତ୍‍, ମତର୍‌ ନାଦାଂ ଇନାକା ମାନାତ୍‌, ହେଦାଂ ଆନ୍‌ ନିଂ ହିଦ୍‍ନାଙ୍ଗା, ନାଜରିତିୟ ଜିସୁ କ୍ରିସ୍ଟତି ତର୍‌ଦ ତାଙ୍ଗା ।” ");
INSERT INTO peg_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","ଆରେ, ହେୱାନ୍‌ ତା ତିନା କେଇ ଆସ୍ତି ହେୱାନିଂ ନିକ୍‍ତାନ୍‍, ହେବେଣ୍ଡାଂ ଦାପ୍ରେ ହେୱାନ୍ତି ପାନା ଆରି କାଲ୍‍ନି ଗାଟିଂ ସବୁ ବାଡ଼୍‍କାସ୍‌ ଆତାନ୍‌, ");
INSERT INTO peg_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","ହେୱାନ୍‌ ତଗ୍‍ଜି ନିଲ୍‍ତାନ୍, ଆରେ, ତାଙ୍ଗ୍‍ଦେଂ ଲାଗାତାନ୍‌, ଆରେ ହେୱାନ୍‌ ତାଙ୍ଗୁ ତାଙ୍ଗୁ ଆରି ତଗ୍‌ଜି ତଗ୍‌ଜି, ଆରେ ଇସ୍ୱର୍‌ତିଂ ପାର୍ତାନା କିଉ କିଉ ହେୱାର୍‌ ହୁକେ ମନ୍ଦିର୍‌ତ ହଟାନ୍‍ । ");
INSERT INTO peg_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","ହେବେ ମାନି ମାନାୟାର୍‌ ୱିଜ଼ାକାର୍‌ ହେୱାନିଂ ତାଂନାକା ଆରି ଇସ୍ୱର୍‌ତିଂ ଜୁୱାର୍‌ କିନାକା ହୁଡ଼୍‍ତାର୍‍; ");
INSERT INTO peg_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","ଆରେ ଇମ୍‌ଣି ରୱାନ୍‌ ମନ୍ଦିର୍‌ନି ହଲ୍‍ନି ଦୁୱେର୍‌ ଲାଗେ କୁଚ୍‌ଚି ବିକ୍‌ ଏନ୍‌ଚି ମାଚାନ୍‌, ଇୱାନ୍‌ ହେ ଲକୁ ଇଞ୍ଜି ହେୱାର୍‌ ଚିନ୍‌କିତାର୍‌, ଆରେ ତାଙ୍ଗ୍‌ ଇନାକା ଗିଟାତାତ୍‍ନ୍ନା, ହେଦାଂ ହୁଡ଼୍‌ଜି ହେୱାର୍‌ ବେସି ବକ୍‍ୱା ଆରି କାବା ଆଜ଼ି ହାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","ହେୱାନ୍‌ ପିତର୍‌ ଆରି ଜହନ୍‌ତିଂ ଆସ୍ତି ମାନି ୱେଡ଼ାଲିଂ ଲକୁ ୱିଜ଼ାକାର୍‌ ବେସି କାବା ଆଜ଼ି ସଲମନ୍‌ତି ମଣ୍ଡମ୍‌ତ ହୁଡ଼୍‌ଜି ହେୱାର୍‌ତି ଲାଗେ ରଚେ ହନ୍‍ଚି ୱାତାର୍‍ । ");
INSERT INTO peg_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","ପିତର୍‌ ହେଦାଂ ହୁଡ଼୍‌ଜି ମାନାୟାରିଂ ଉତର୍‌ ହିତାନ୍‌, “ଏ ଇସ୍ରାଏଲିୟର୍‌ ଲକୁ, ଏପେଙ୍ଗ୍‌ ଇନେକିଦେଂ ଇ ମାନାୟ୍‌ ବିସ୍ରେ କାବା ଆନାଦେରା ? କି ଆସେଙ୍ଗ୍‌ ଇନେସ୍‌ ଜାର୍‌ ସାକ୍ତି କି ଲବାୟ୍‌ ବାଡ଼୍‌କାସ୍‌ତାଂ ଇୱାନିଂ ତାଂଦେଂ ସାକ୍ତି ହିତାପ୍‌ନା, ହେଦାଂ ବାବି କିଜ଼ି ମା କାଜିଂ ଇନେକିଦେଂ ମାପ ହୁଡ଼୍‍ଦାନାଦେରା ? ");
INSERT INTO peg_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","ଅବ୍ରାହାମ୍‌, ଇସ୍‌ହାକ୍‌ ଆରି ଜାକୁବ୍‌ତି ଇସ୍ୱର୍‍, ମା” ବୁଡାର୍ତି ଇସ୍ୱର୍‌, ଜାର୍‌ ଆଡ଼ିଏନ୍‌ ଜିସୁଙ୍ଗ୍‌ ୱିଜ଼୍‌ୱି ଜାଜ୍‌ମାଲ୍‌ କିତାନ୍‌ନ୍ନା; ମାତର୍‌ ଏପେଙ୍ଗ୍‌ ହେୱାନିଂ ମୁଡ଼୍‌ ତାକେ ହେଲାୟ୍‌ କିନାଦେର୍‌ । ଏଲେଙ୍ଗ୍‌ କି ବିଚାର୍‌ କାର୍‌ୟା ହେୱାନିଂ ମୁକ୍ତି କିଦେଙ୍ଗ୍‌ ତିର୍‌ କିଜ଼ି ମାଚାନ୍‌ ପା ହେୱାନିଂ ପିଲାତ ମୁମ୍‌ଦ ପାର୍ତି କିୱାତାଦେର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","ଏପେଙ୍ଗ୍‌ ହେ ପୁଇପୁୟା ଆରି ଦାର୍ମି ଲଗାଂ ପାର୍ତି କିନାଦେର୍‌, ଆରେ ରୱାନ୍‌ ନାର୍‍ମାରୁଙ୍ଗ୍ ଇନେସ୍‌ ମି କାଜିଂ କେମା କିୟାନାତ୍‌, ଇଦାଂ ପାର୍ତାନା କିତାଦେର୍‌, ");
INSERT INTO peg_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","ମାତର୍‌ ଜିବୁନ୍‌ନି ହାଜ଼ି ଚଚ୍‌ନାକାନିଂ ଅସ୍ତାର୍‌, ହେୱାନିଂ ଇସ୍ୱର୍‌ ହାତାକାର୍‌ ବିତ୍ରେ ନିକ୍‌ତାନ୍ନା, ଆପେଂ ହେବେନି ସାକି । ");
INSERT INTO peg_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","ଆରେ, ହେୱାନ୍ତି ତର୍‌ଦ ପାର୍ତି କିତିଲେ ଇ ଇମ୍‌ଣି ମାନାୟ୍‍ତିଂ ଏପେଙ୍ଗ୍‌ ହୁଡ଼୍‍ନାଦେରା ଆରି ପୁଚାଦେର୍ଣ୍ଣା, ଇୱାନିଂ ଜିସୁ ତର୍‌ଦ ବାଡ଼୍‍କାସ୍‌ କିତାଂନ୍ନା; ଆଁ, ହେୱାନ୍ତି ହୁଦାଂ ହିତ୍‍ତି ପାର୍ତି ମି ୱିଜ଼ାକାର୍‌ ମୁମ୍‌ଦ ଇୱାନିଂ ପୁରା ଉଜ୍‌ କିତାଂନ୍ନା । ");
INSERT INTO peg_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“ଆରେ ନଙ୍ଗ୍‌, ଏ ଇସ୍ରାଏଲ୍‌ ଟଣ୍ଡାର୍‌ ଆରି ତଣ୍‌ଦେକ୍‌, ମି ମୁଣିକାର୍‍ ଇନେସ୍‌, ଏପେଙ୍ଗ୍‌ ପା ହେ ଲାକେ ଗିୟାନ୍‍ହିଲ୍‍ୱି କାଜିଂ ଇଦାଂ କିତାଦେର୍ଣ୍ଣା ଇଞ୍ଜି ଆନ୍‌ ପୁନାଙ୍ଗ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","ମାତର୍‌ ଇସ୍ୱର୍‌ ଜାର୍‌ କ୍ରିସ୍ଟ ଦୁକ୍‍ବଗ୍ ବିସ୍ରେ ୱିଜ଼ାକାର୍‌ ବେଣ୍‌ବାକ୍‌ଣାୟ୍‌କିନାକାର୍‌ ୱେଇଦାଂ ଇନା ଇନାକା ପୁର୍ବେତାଂ‍ ସୁଣାୟ୍‌ କିଜ଼ି ମାଚାର୍‌, ହେ ସବୁ ହେୱାନ୍‌ ଇ ବାନି ପୁରା କିତାନ୍‌ନ୍ନା । ");
INSERT INTO peg_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","ଲାଗିଂ, ଇନେସ୍‌ ମିଦାଂ ପାପ୍‌ କେମା ଆନାତ୍‌, ଇଦାଂ କାଜିଂ ମାନ୍‌ବାଦ୍‌ଲାୟ୍‌ କିଜ଼ି ଇସ୍ୱର୍‌ ନିପ ମାଜ଼୍‌ଦି ୱାଡୁ, ");
INSERT INTO peg_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","ତା ଆତିସ୍‌ ମାପ୍ରୁତି ଲାଗାଂ ସୁସ୍ତାନି ସମୁ ଇକାୱାନାତ୍; ଆରେ, ମି କାଜିଂ ଆରେନିଂତି କ୍ରିସ୍ଟଙ୍ଗ୍‌, ଇଚିସ୍‌ ଜିସୁଙ୍ଗ୍‌ ହେୱାନ୍‌ ପକ୍ତାନାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","ୱିଜ଼ୁ ବିସ୍ରେ ଆରେ କିଦେଙ୍ଗ୍‌ ଇମ୍‌ଣି ସମୁନି କାତା ବେସି ପ୍ଡାଡ଼୍‌ନିକାଡ଼୍‌ଦାଂ ଇସ୍ୱର୍‌ ଜାର୍‌ ପୁଇପୁୟା ବେଣ୍‌ବାକ୍‌ଣାୟ୍‌କିନାକାର୍‌ ୱେଇ ହୁଦାଂ ୱେଚ୍‍ଚାନ୍ନା, ହେ ସମୁ ଏକାୱାୱି ପାତେକ୍‌ ହେୱାନିଂ ହାତେ ବାଦାଡ଼୍‌ତ ଇଟ୍ୟା ଆଦେଂ ଆନାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","ଇ ବିସ୍ରେ ମସା ଇଞ୍ଜି ମାଚାନ୍‌, ମି ମାପ୍ରୁ ଇସ୍ୱର୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ଟଣ୍ଡାର୍‌ ବିତ୍ରେ ନା ଲାକେ ରୱାନ୍‌ ବେଣ୍‌ବାକ୍‌ଣାୟ୍‌କିନାକାର୍‌ ପକ୍ତାନାନ୍‌ । ହେୱାନ୍‌ ଜାର୍‌ ମାନାୟାରିଂ ବିତ୍ରେତାଂ ରୱାନ୍‌ ଆନାନ୍‌ ହେୱାନ୍‌ ମିଙ୍ଗ୍‌ ଇନାକା ୱେଚ୍‍ଚାନାନ୍, ହେ ସବୁ ବିସ୍ରେ ଏପେଙ୍ଗ୍‌ ପାଲି କିନି ଲଡ଼ା । ");
INSERT INTO peg_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","ମାତର୍‌ ଏଲେଙ୍ଗ୍‌ ଗିଟାନାତ୍‍ ଜେ, ଇମ୍‌ଣି ୱାସ୍କି ହେ ବେଣ୍‌ବାକ୍‌ଣାୟ୍‌କିନାକାର୍‌ ବଚନ୍‌ ୱେନୁନ୍‍, ଇସ୍ୱର୍‌ତି ମାନାୟାର୍‌ ବିତ୍ରେ ନସ୍ଟ ଆନାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","ଆଁ, ସାମୁୟେଲ୍‌ ଆରି ହେୱାନ୍ତି ପାଚେନି ସମୁତାଂ ଏଚେକ୍‌ ବେଣ୍‌ବାକ୍‌ଣାୟ୍‌କିନାକାର୍‌ କାତା ଇଚାର୍ଣ୍ଣା, ହେୱାର୍‌, ୱିଜ଼ାକାର୍‌ ପା ଇ କାଡ଼୍‌ ବିସ୍ରେ ବେଣ୍‌ କିତାର୍ଣ୍ଣା । ");
INSERT INTO peg_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","ଏପେଙ୍ଗ୍‌ ହେ ବେଣ୍‌ବାକ୍‌ଣାୟ୍‌କିନାକାର୍‌ ହିମ୍‌ଣାଂ, ଆରେ ମି ଲାତ୍ରା ହୁକେ ପୁର୍ତିନି ୱିଜ଼ୁ କୁଟୁମ୍‍ ଆସିର୍ବାଦ୍‌ ପାୟାନାର୍, ଇ ବଚନ୍‌ ଇସ୍ୱର୍‌ ଅବ୍ରାହାମ୍‌ତି ଇଞ୍ଜି ମି ବୁଡ଼ାଲୁର୍‍ ହୁକେ ଇମ୍‌ଣି ନିୟମ୍‌ ରଚ୍‌ଚି ମାଚାନ୍‌, ଏପେଙ୍ଗ୍ ହେ ନିୟମ୍‌ନି ହିମ୍‍ଣାକାଦେର୍ । ");
INSERT INTO peg_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","ଇସ୍ୱର୍‌ ପର୍ତୁମ୍‌ ମି କାଜିଂ ଜାର୍‌ ହେ ଆଡ଼ିଏନ୍‌ନିଂ ବାଚି କିତାନ୍‌, ୱିଜ଼ାରିଂ ବାନ୍ୟା ହାଜ଼ିତାଂ ମାସ୍‌ନି ଆସିର୍ବାଦ୍‌ ହିନାନ୍‌ ଇଞ୍ଜି ପକ୍‌ତାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","ହେୱାର୍‌ ମାନାୟାର୍‌ ଲାଗେ କାତା ଇ ୱାଡ଼ାଲିଂ ମାପ୍ରୁହେବାକିନାକାନ୍‌ ମନ୍ଦିର୍‌ନି ମୁଡ଼୍‌ମେଲ୍ୟା ଆରି ସାଦୁକିର୍‌ ହେୱାର୍‌ ଲାଗେ ଏକାୱାତାର୍‌; ");
INSERT INTO peg_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","ହେୱାର୍‌ ରିସା ଆଜ଼ି ମାଚାର୍‌, ଇନାଦେଂକି ଜିସୁ ଇଚାନ୍‌ ପକ୍ୟାତାକାର୍‌ ଲକୁରିଂ ହିକ୍ୟା ହିଜ଼ି ହାତାକାର୍‌ ଆରେ ନିଂନାକା ଇଞ୍ଜି ପାର୍ମାଣ୍‍ କିଜ଼ି ମାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","ଆରେ, ହେୱାର୍‌ ହେୱାରିଂ ଆସ୍ତି ଆର୍କାତ୍‌ ଦିନ୍‍ ପାତେକ୍‌ ଜଇଲ୍‌ ଇଞ୍ଜ ଇଟ୍‌ତାର୍‌, ଇନାକିଦେଂକି ହେ ୱେଡ଼ାଙ୍ଗ୍‌ ମ୍ଡିକାହାରେସ୍ ଆଜ଼ି ମାଚାତ୍ । ");
INSERT INTO peg_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","ମାତର୍‌ ହେୱାର୍‌ତି ହିକ୍ୟା ୱେନ୍‌ଞ୍ଜି ମାନି ବେସି ହେନି ମାନାୟାର୍‌ ହେବେ ପାର୍ତି କିତାର୍‌, ହେୱାର୍‌ତି ବାଡାନାକା ଲମର୍ ପାଞ୍ଚ୍ ହାଜାର୍‌ ଆତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","ତା ଆର୍କାତ୍‌ ନାଜିଂ ଜିହୁଦି ମୁଣିକାର୍‌, ପ୍ରାଚିନ୍‌ ଆରି ସାସ୍ତର୍‌ ଗୁରୁ ଜିରୁସାଲମ୍‌ତ ରୁଣ୍ଡାତାର୍‌; ");
INSERT INTO peg_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","ହେୱାର୍‌ ମୁଡ଼୍‌ ମାପ୍ରୁହେବାକିନାକାନ୍‌ ହାନାନ, କୟାପା, ଜହନ୍‌, ଆଲେକ୍‌ଜାଣ୍ଡର୍‌, ଆରେ ମାପ୍ରୁହେବାକିନାକାନ୍‌‍ ନି ବଁସ୍‌ନି ୱିଜ଼ାର୍‌ ଲକୁ ମାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","ହେୱାର୍‌ ପକ୍ୟାତାକାରିଂ ମାଦ୍‍ଣି ବାହାତ ନିଲି କିଜ଼ି ୱେନ୍‍ବେଦେଂ ଲାଗାତାର୍‌, ଇନେସ୍‌ ସାକ୍ତିତ କି ଇମ୍‌ଣି ତର୍‌ଦ “ଏପେଙ୍ଗ୍‌ ଇଦାଂ କିତାଦେର୍ଣ୍ଣା ?” ");
INSERT INTO peg_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","ହେବେ ପିତର୍‌ ପୁଇପୁୟା ଜିବୁନ୍‌ତ ବାର୍ତି ଆଜ଼ି ହେୱାରିଂ ଇଚାନ୍‌, “ଏ ମାନାୟାର୍ତି ମୁଣିକା ଆରି ପ୍ରାଚିନାର୍‌,” ");
INSERT INTO peg_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","ନେଞ୍ଜେଙ୍ଗ୍‌ ଜଦି ରୱାନ୍‌ ରଗ୍ୟା କାଜିଂ କିଜ଼ି ମାଚି ହାର୍ଦି କାମାୟ୍‌ ବିସ୍ରେ ମାଂ ପର୍‌ସନ୍‌ ୱେନ୍‍ବିତିସ୍‌ ଜେ, ଇ ମାନାୟ୍‌ ଇନା ଉପାୟ୍‍ତ ଉଜ୍‌ ଆତାନ୍ନା, ");
INSERT INTO peg_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","ତା ଆତିସ୍‌ ଏପେଙ୍ଗ୍‌ ୱିଜ଼ାକାଦେର୍‌ ଆରି ୱିଜ଼ୁ ଇସ୍ରାଏଲ୍‌ ଲକୁ ପୁନାଟ୍‌, ଇମ୍‌ଣି ନାଜରିତିୟ ଜିସୁ କ୍ରିସ୍ଟଙ୍ଗ୍ ଏପେଙ୍ଗ୍‌ କ୍ରୁସ୍‌ତ ଅସ୍ତାଦେର୍, ଇନେରିଂ ଇସ୍ୱର୍‌ ହାକିତାଂ ବିତ୍ରେ ନିକ୍‌ତାନ୍ନା, ହେୱାନ୍ତି ତର୍‌ଦାଂ ଆଁ ହେୱାନ୍ତି ହୁକେ ଇ ମାନାୟ୍‍ ଉଜ୍‌ ଆଜ଼ି ମି ମୁମ୍‌ଦ ନିଲ୍‌ତାନ୍ନା । ");
INSERT INTO peg_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","ଇଲ୍‌ ରଚ୍‍ନାକାଦେର୍, ଇମ୍‌ଣି କାଲ୍‌ ଇଟ୍‌ୱାତାର୍‌ ହେ କାଲ୍‌ନେ, ଇଲ୍‌ନି ମୁଡ଼୍‌କାଲ୍‌ ଆତାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","ହେୱାନିଂ ପିସ୍ତି ଆରେ ଇନେର୍‌ ତାକେ ମୁକ୍ତି ହିଲୁତ୍‌, ଇନାକିଦେଂକି ଇମେତାଂ ମାଂ ମୁକ୍ତି ଗାଟାଦେଂ ଆନାତ୍‌, ବାଦାଡ଼୍‌ତ ତାରେନ୍‌ ମାନାୟ୍‌ ବିତ୍ରେ ଆରେ ଇନାକାପା ତର୍‌ ହିୟାୱାତାତ୍‍ନା । ");
INSERT INTO peg_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","ହେୱାର୍‌ ପିତର୍‌ ଆରି ଜହନ୍‌ ସାସ୍‌ ହୁଡ଼୍‌ଜି ଆରି ହେୱାର୍‌ ଜେ ଅସିକ୍‌ତି ଆରି ଗିୟାନ୍‌ ହିଲ୍‍ୱି ଲଗୁ, ଇଦାଂ ବୁଜାଜ଼ି କାବା ଆତାର୍‌, ଆରେ ହେୱାର୍‌ ଜିସୁତି ହୁଦାଂ ମାଚାର୍‌ ଇଞ୍ଜି ହେୱାରିଂ ଚିନିକିତାର୍, ");
INSERT INTO peg_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","ଆରେ ହେ ଉଜ୍‌ ଆଜ଼ି ମାଚି ମାନାୟ୍‍ତିଂ ହେୱାର୍‌ ହୁକେ ଇଞ୍ଜ ମାନାକା ହୁଡ଼୍‌ଜି, ବିରୁଦ୍‌ତ ମୁଡ଼େ ଇଞ୍ଜେଙ୍ଗ୍‌ ଆଡ୍‌ୱାତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","ପାଚେ ହେୱାରିଂ ସବାତାଂ ହସି ହାଞ୍ଜେଙ୍ଗ୍‌ ବଲ୍‌ ହିଜ଼ି ହେୱାର୍‌ ରକାନ୍‌ ଆରେ ରକାନ୍ ବିତ୍ରେ ବୁଜାବୁଜି କିଜ଼ି ଇଞ୍ଜେଙ୍ଗ୍‌ ଲାଗାତାର୍‌, ");
INSERT INTO peg_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","ଇ ମାନୟାରିଂ ଇନାକା କିନାସ୍‌ “ଇନାକିଦେଂକି ଇୱାର୍‌ତାଂ ଜେ, ର ଗାଜା କାବା କାମାୟ୍‌ ଆତାତ୍‌ନ୍ନା, ଇଦାଂ ଜିରୁସାଲମ୍‌ ନିକାରିଂ ତାକେ ୱିଣ୍‍ତାତ୍‍ନ୍ନା, ଆରେ ଆସେଙ୍ଗ୍‌ ହେଦାଂ ପାର୍ତି କିୱାଦାଂ ଆଡୁସ୍; ");
INSERT INTO peg_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","ମାତର୍‌ କାତା ଇନେସ୍‌ ମାନାୟ୍‌ ବିତ୍ରେ ଆରେ ବେସି ମେଙ୍ଗ୍‍ମେତ୍, ଇଦାଂ କାଜିଂ ଜିସୁ ତର୍‌ଦ ଇମ୍‌ଣି ମାନାୟ୍‍ତିଂ ଆରେ ମୁଡ଼୍‌କେ ଇନ୍‍ୱି କାଜିଂ ହେୱାରିଂ ଚିମ୍‌ରା କିନାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","ପାଚେ ପିତର୍‌ ଜହନ୍‌ତିଂ କୁକ୍‌ଚି ଜିସୁତି ତର୍‌ ମୁଡ଼୍‌କେ କାତା ଇନ୍‍ୱି କାଜିଂ ଆରି ହିକ୍ୟା ହିୱି କାଜିଂ ଡାଟ୍‌ ବଲ୍‌ ହିତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","ମାତର୍‌ ପିତର୍‌ ଆରି ଜହନ୍‌ ହେୱାରିଂ ଉତର୍‌ ହିତାର୍‌, “ଇସ୍ୱର୍‌ତି କାତା ୱେନି ବାଟା ମି କାତା ୱେନାକା ଇସ୍ୱର୍‌ତି କାଣ୍‍କୁତ ଦାର୍ମି କି ମିଚ୍‌, ହେଦାଂ ଏପେଙ୍ଗ୍‌ ବିଚାର୍‌ କିୟାଟ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","ଇନାକିଦେଂକି ଆପେଂ ଇନାକା ଇନାକା ହୁଡ଼୍‍ତାପ୍‍ନ୍ନା ଆରି ୱେଚାପ୍‍ନ୍ନା, ହେ ସବୁ ଇନ୍‌ୱାଦାଂ ମାଞ୍ଜେଙ୍ଗ୍ ଆଡୁପ୍ ।” ");
INSERT INTO peg_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","ହେବେ ହେୱାର୍‌ ଲକୁ କାଜିଂ ହେୱାରିଂ ଡାଣ୍ଡ୍‌ ହିଦେଂ ଇମ୍‌ଣାକା ପା ହାଜ଼ି ଗାଟାୱାତିଲେ ହେୱାରିଂ ଆଦିକ୍‌ ପାଣ୍ଡ୍ରୁ ଚଚ୍‍ଚି ପିସ୍ତି ହିତାର୍‌, ୱାଟିଙ୍ଗ୍‌ ଇନାକା ଗିଟାଜ଼ି ମାଚାତ୍‌, ହେଦାଂ କାଜିଂ ଲକୁ ୱିଜ଼ାର୍ ଇସ୍ୱର୍‌ତି ଜାଜ୍‌ମାଲ୍‌ କିଦେଙ୍ଗ୍‌ ଲାଗାତାର୍‌, ");
INSERT INTO peg_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","ଇମ୍‌ଣି ମାନାୟ୍‌ ତାକେ ହେ ଉଜ୍‌ ଆନାକା କାବା କାମାୟ୍‌ କିୟାଜ଼ି ମାଚାତ୍‌, ହେୱାନ୍ତି ରିକଡ଼ି ବାର୍ହୁତାଂ ଆଦିକ୍‌ ଆଜ଼ି ମାଚାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","ହେୱାର୍‌ ମୁକ୍‌ଡ଼ା ଆଜ଼ି ଜାର୍‌ ହାଙ୍ଗ୍‌ଦାକାର୍‌ ଲାଗେ ହାଚାର୍‌ ଆରି ମୁଡ଼୍‌ ମାପ୍ରୁହେବାକିନାକାନ୍‌ ଆରି ପ୍ରାଚିନାର୍‌ ହେୱାରିଂ ଇନାକା ଇନାକା ଇଞ୍ଜି ମାଚାର୍‌, ହେ ସବୁ ୱେଚ୍‍ଚାର୍ । ");
INSERT INTO peg_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","ପାର୍ତି କିନାକାର୍‌ ହେଦାଂ ୱେନ୍‌ଞ୍ଜି ରମାନ୍ତ ଇସ୍ୱର୍‌ତି ଲାଗେ ଗାଜାକାଟ୍‌ତାଂ ପାର୍ତାନା କିଜ଼ି ଇଚାର୍‌, “ଏ ମାପ୍ରୁ ଏନ୍‌ ବାଦାଡ଼୍‌ତ, ପୁର୍ତି, ହାମ୍‌ଦୁର୍‌ ଆରି ହେ ସବୁ ବିତ୍ରେ ୱିଜ଼ୁ ବିସ୍ରେ ଉବ୍‌ଜାଣ୍‌ କିତାୟ୍‌ନା ");
INSERT INTO peg_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","ଏନ୍‌ ଜାର୍‌ ଆଡ଼ିଏନ୍‌ ମା ଆବା ଦାଉଦ୍‌ତି ୱେଇ ହିଜ଼ି ପୁଇପୁୟା ଜିବୁନ୍‌ ହୁଦାଂ ଇ କାତା ଇଚାୟ୍‍ନା, ପାର୍ତିକିୱି ଜିହୁଦି ଇନେକିଦେଂ ରିସା କିତାର୍‌, ଆରେ ମାନାୟାର୍‌ ଇନେକିଦେଂ ୱାରାକା ବିସ୍ରେ ହାନ୍ଦାୟ୍‍ କିତାର୍‌ ? ");
INSERT INTO peg_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","ମାପ୍ରୁତି ବିରୁଦ୍‌ତ ଆରି ହେୱାନ୍ତି ସିଗ୍‌ଆତାକାର୍‌ ବିରୁଦ୍‌ତ, ପୁର୍ତିନି ରାଜାର୍‌ ଜାଲ୍‌ଦି ଆତାର୍‌, ଆରେ ମୁଣିକାର୍‌ ରବେ ରୁଣ୍ଡାତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","ଇନାକିଦେଂକି ମି ଇମ୍‌ଣି ପୁଇପୁୟା ଆଡ଼ିଏନ୍‌ ଜିସୁଙ୍ଗ୍‌ ଏନ୍‌ ସିଗ୍‌ କିତାୟ୍, ହାତ୍‌ପାନେ ହେୱାନ୍ତି ବିରୁଦ୍‌ତ ହେରଦ୍‌ ଆରି ପନ୍ତିୟ ପିଲାତ ରିକାର୍‌ ପାର୍ତିକିୱି ଜିହୁଦି ଆରି ଇସ୍ରାଏଲ୍‌ ଲକୁ ହୁଦାଂ ଇ ଗାଡ଼୍‌ଦ, ");
INSERT INTO peg_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","ନି ଜଜନା ହୁଦାଂ ଜେ ୱିଜ଼ୁ ଗିଟାନାତ୍ ଇଞ୍ଜି ପୁର୍ବେତାଂ ବାଚି ଆଜ଼ି ମାଚାତ୍‌, ହେଦାଂ କିଦେଙ୍ଗ୍‌ ରବେରୁଣ୍ତା ଆତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","ଆରେ ନଙ୍ଗ୍‌, ଏ ମାପ୍ରୁ, ହେୱାର୍‌ତି ପାଣ୍ଡ୍ରୁନିକାରିଂ ମେହା; ଆରେ, ନି ଆଡ଼ିୟାରିଂ ପୁରା ସାସ୍‌ ହୁକେ ନି ବଚନ୍‌ ଇଞ୍ଜେଙ୍ଗ୍‌ ସାକ୍ତି ହିଦା, ");
INSERT INTO peg_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","ଆରେ ହେ ସାଙ୍ଗେ ସାଙ୍ଗେ ନି ପୁଇପୁୟା ଆଡ଼ିଏନ୍‌ ଜିସୁତି ତର୍‌ଦ ଉଜ୍‌ କିଦେଙ୍ଗ୍‌ କାଜିଂ ଆରି ଚିନ୍‌କୁ ଆରି କାବାନି କାମାୟ୍‌ କିଦେଙ୍ଗ୍‌ କାଜିଂ ନି କେଇ ଲାମାୟ୍‍ କିଦା ।” ");
INSERT INTO peg_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","ହେୱାର୍‌ ପାର୍ତାନା କିତି ପାଚେ, ଇମ୍‌ଣି ବାହାତ ରବେ ରୁଣ୍ଡାଜ଼ି ମାଚାର୍‌, ଇମ୍‌ଣି ବାହାତ ରବେ ମାଚାର୍‌, ହେଦାଂ କମ୍ପାତାତ୍, ଆରେ ୱିଜ଼ାକାର୍‌ ପୁଇପୁୟା ଜିବୁନ୍‌ତ ପୁରା ଆଜ଼ି ସାସ୍‍ତ ଇସ୍ୱର୍‌ତି କାବୁର୍‌ ଇଞ୍ଜେଙ୍ଗ୍‌ ଲାଗାତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","ପାର୍ତି କିନାକାରିଂ ଲକୁ ର ୱାସ୍କି ଆରି ର ପାରାଣ୍‍ତ ମାଚାର୍‌; ହେୱାର୍‌ତି ବିତ୍ରେ ଇନେର୍‌ପା ଜାର୍‌ ସଂପତିତାଂ ଇଚୁକ୍‌ ଜାର୍ତି ଇଞ୍ଜି ଇନ୍‌ୱାଦାଂ ମାଚାର୍‌, ମତର୍‌ ହେୱାର୍‌ତି ୱିଜ଼ୁ ବିସ୍ରେ ସିଦାସାଦା ମାଚାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","ପକ୍ୟାତାକାର୍‌ ଗାଜା ସାକ୍ତି ହୁକେ ମାପ୍ରୁ ଜିସୁତି ଆରେ ନିଂନାକା ବିସ୍ରେ ସାକି ହିଦେଂ ଲାଗାତାର୍‌, ଆରେ ଇସ୍ୱର୍‌ ୱିଜ଼ାକାର୍‌ ଜପି ବେସି ଦୟା କିଜ଼ି ମାଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","ଲାଗିଂ ହେୱାର୍‌ ବିତ୍ରେ ଇନେରିଂ ଇନାକାପା ଅବାବ୍‌ ହିଲ୍‌ୱାତାତ୍‌, ଇନାକିଦେଂକି ଏଚେକ୍‍ ଲକାର୍ତି ବୁମି କି ଇଲ୍‌ ମାଚାତ୍‌, ହେୱାର୍‌ ହେଦାଂ ପ୍ରସି ଦନ୍‍ନି ମଲ୍‌ ତାସି, ");
INSERT INTO peg_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","ଆରେ ଜାଣ୍‍କେ ରୱାନିଂ ତାଦି ଅବାବ୍‌ ହୁଡ଼୍‌ଜି ପକ୍ୟାତାକାର୍‌ ଚେଲାରିଂ ପାସ୍‍ପିସ୍ ମାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","ଆରେ, ଜସେପ୍‌ ତର୍‌ନି ବାହାତ ଜଲମ୍‌ ଆଜ଼ି ମାନି ଲେବି ଲାତ୍ରାନି ରୱାନ୍‌ ସାଇପ୍ରସ୍‌ ଜାତିନି ଲକୁ, ଇନେରିଂକି ପକ୍ୟାତାକାର୍‌ ବର୍ଣ୍ଣବା ଇଞ୍ଜି କୁକ୍‌ନି ତର୍‌ ହିଜ଼ି ମାଚାର୍‌ ଅନୁବାଦ୍‌ କିତିସ୍‌ “ଇଦାଂ ନି ଅରତ୍‌ ଦୁକ୍‌ସାରାୟ୍‌ନି ମାଜ଼ି,” ");
INSERT INTO peg_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","ହେୱାନ୍ତି ରଞ୍ଜି ବୁମି ମାଚାତ୍‌; ହେୱାନ୍‌ ହେଦାଂ ପ୍ରସି ହେବେନି ଟାକାଂ ତାସି ପକ୍ୟାତାକାର୍‌ତି ପାନା ତାରେନ୍‌ ଇଡ୍‍ତାନ୍ । ");
INSERT INTO peg_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","ହନନିୟ ତର୍‌ଦାକାନ୍‌ ରୱାନ୍‌ ମୁଣିକା ଜାର୍‌ ଡକ୍ରି ସପିରା ଲାହାଂ ଅଲପ୍‍ ଜମି ପ୍ରତାର୍‌, ");
INSERT INTO peg_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","ମାତର୍‌ ଡକ୍ରୁହି ର ମାନ୍‌ କିଜ଼ି ହେବେନି ମଲ୍‍ତାଂ ଅଲପ୍‍ ଡ଼ୁକ୍‌ଚି ଇଡ଼୍‌ଜି ବାଗ୍‌ ମତର୍ ତାହି ପକ୍ୟାତାକାର୍‌ତି ମୁମ୍‌ଦ ଇଡ୍‍ତାନ୍ । ");
INSERT INTO peg_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","ହେବେ ପିତର୍‌ ଇଚାନ୍‌, ଏ “ହନନିୟ, ପୁଇପୁୟା ଜିବୁନ୍‌ ଲାଗେ ମିଚ୍‌ ଇଞ୍ଜେଙ୍ଗ୍‌ ଆରି ବୁମିନି ମଲ୍‍ଦାଂ ଅଲପ୍‍ ଡ଼ୁକ୍‌ଚି ଇଡ୍‌ଦେଂ ଇନାକିଦେଂ ସୟ୍‌ତାନ୍‌ ନି ମାନ୍ତ ପୁରା ଆଦିକାର୍‌ କିତ୍‌ତାତ୍‌ନ୍ନା ? ");
INSERT INTO peg_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","ପ୍ରୱି ଆଗେ ହେଦାଂ ଇନାକା ଆୱାଦାଂ ମାଚାତ୍‌ ? ଆରେ, ପ୍ରତି ପାଚେ ହେବେନି ମଲ୍ କି ନି ନିଜ୍‍ନି ଆଦିକାର୍‌ ହିଲ୍‌ୱାତାତ୍‌ ? ୱାଟିଙ୍ଗ୍‌ ଏନ୍‌ ଇନେସ୍‌ ଜାର୍‌ ମାନ୍ତ ଇନାକିଦେଂ ଇ ବିସ୍ରେ ବାବି କିତାୟ୍ ? ଏନ୍‌ ଜେ ମାନାୟ୍‌ ଲାଗେ ମିଚ୍‌ ଇଚାୟ୍, ହେଦାଂ ଆକାୟ୍‌, ମତର୍‌ ଇସ୍ୱର୍‌ତି ଲାଗେ ମିଚ୍‌ ଇଚାୟ୍ ।” ");
INSERT INTO peg_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","ଇ କାତା ୱେନ୍‌ଞ୍ଜି ସାଙ୍ଗେ ସାଙ୍ଗେ ହନନିୟ ତୁହିୟାଜ଼ି ପାରାଣ୍‌ ପିସ୍ତାନ୍‌ । ହେବେ ଏଚେକ୍‌ ଲକୁ ଇଦାଂ ୱେଚାର୍‌, ୱିଜ଼ାକାର୍‌ ବେସି ପାଣ୍ଡ୍ରା ଆତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","ଆରେ, ଦାଂଣାର୍ ନିଂଜି ହେୱାନିଂ ହେନ୍ଦ୍ରାତ ହୁର୍ପାତାର୍ ଆରି ବାର୍ତ ଅଜ଼ି ହାଲ୍‌ଜି ମୁଚ୍‍ଚାର୍‍ । ");
INSERT INTO peg_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","ତିନି ଗଣ୍ଟା ପାଚେ ହେୱାନ୍ତି ଡକ୍ରୁହି ୱାତାତ୍, ମତର୍‌ ଇନାକା ଗିଟାତାତ୍‍ନ୍ନା, ହେଦାଂ ହେଦେଲ୍‌ ପୁନ୍‌ୱାଦାଂ ମାଚାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","ଆରେ, ପିତର୍‌ ହେଦେଲିଂ ୱେନ୍‌ବାତାନ୍‌, ୱେଚ୍‌ଚା ତ, “ଏପେଙ୍ଗ୍‌ ଇନାକା ଏଚେକ୍‌ ଟାକାକାଂ ବୁମି ପ୍ରତାଦେର୍ ?” ହେଦେଲ୍‌ ଇଚାତ୍‌, “ଆଁ, ଏଚେକ୍‍ନେ ।” ");
INSERT INTO peg_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","ହେବେ ପିତର୍‌ ହେଦେଲିଂ ଇଚାନ୍‌, ମାପ୍ରୁତି “ଜିବୁନ୍‌ତିଙ୍ଗ୍‌ ପରିକ୍ୟା କିଦେଙ୍ଗ୍‌ କାଜିଂ ଏପେଙ୍ଗ୍‌ ଇନାକିଦେଂ ର ମାନ୍ତ ବେଣ୍‍ କିତାଦେର୍, ହୁଡ଼ାଟ୍‌, ଇନେର୍‌ ନି ଡକ୍ରାଂ ମୁଚ୍‍ଚାର୍ଣ୍ଣା, ହେୱାର୍‌ ଦୁୱେର୍‌ ଲାଗେ ଇକାୱାତାରେ, ଆରେ ହେୱାର୍‌ ନିଂ ବାର୍ତ ପିଣ୍ଡ୍‌ଜି ଅଜ଼ି ହାଞ୍ଜ୍‍ନାର୍ ।” ");
INSERT INTO peg_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","ହେଦାପ୍ରେ ହେଦେଲ୍‌ ହେୱାନ୍ତି ପାନା ତାରେନ୍‌ ତୁହିଆ ଆଜ଼ି ପାରାଣ୍‌ ପିସ୍ତାତ୍, ଆରେ, ଦାଂଣାର୍ ବିତ୍ରେ ୱାଜ଼ି ହେଦେଲିଂ ହାତାକା ହୁଡ଼୍‌ଜି ବାର୍ତ ଅତାର୍‌ ଆରି ହେଦେଲ୍‌ ଡକ୍ରାହି ଲାଗେ ହେଦେଲିଂ ମୁଚ୍‌ଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","ହେବେ ୱିଜ଼ୁ ମଣ୍ଡ୍‌ଲି ଆରି ଏଚେକ୍‌ ଲକୁ ଇ ସବୁ ବିସ୍ରେ ୱେଚାର୍‌, ହେୱାର୍‌ ୱିଜ଼ାକାର୍‌ ବେସି ପାଣ୍ଡ୍ରା ଆତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","ପକ୍ୟାତାକାର୍‌ତି ହୁଦାଂ ମାନାୟାର୍‌ ବିତ୍ରେ ବେସି ଆଡ୍‍ୱି ଆରି କାବାନି କାମାୟ୍‌ ଆଦେଂ ଲାଗାତାତ୍‌, ଆରେ ୱିଜ଼ୁ ମଣ୍ଡ୍‌ଲି ରମାନ୍‌ ସଲମନ୍‌ତି ମଣ୍ଡମ୍‌ତ ରୁଣ୍ଡାଜ଼ି ମାଚାର୍‌, ");
INSERT INTO peg_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","ମାତର୍‌ ମାନାୟ୍‌ ବିତ୍ରେତାଂ ଇନେର୍‌ ହେୱାର୍‌ ହୁଦାଂ ମେହାଆଦେଂ ସାସ୍‌ କିୱାଦାଂ ମାଚାର୍‌; ଆତିସ୍‌ ପା ବିନ୍‌ ଲକୁ ହେୱାରିଂ ୱାରି କିଜ଼ି ମାଚାର୍‌, ");
INSERT INTO peg_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","ମାତର୍‌, ଆରେ ଆଦିକ୍‌ତାଂ ଆଣ୍ଡ୍ରାଂ ଆରି କଗ୍‍ଲେକ୍ ମାପ୍ରୁ ତାକେ ପାର୍ତି କିଜ଼ି ଇ ଦଲ୍‌ଦ ମେହାଆଦେଂ ଲାଗାତାର୍‌, ");
INSERT INTO peg_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","ଏଲେଂକି, ପିତର୍‌ ୱାନି ୱେଡ଼ାଲିଂ କେବଲ୍‌ ହେୱାନ୍ତି ଡ଼ିଗା ଇନେସ୍‌ ରଗ୍ୟାର୍ ତାକେ ଇନେର୍‌ ଇନେର୍‌ ଜପି ଆର୍‍ନାତ୍, ଇଦାଂ କାଜିଂ ଲକୁ ହେୱାରିଂ ହାକ୍‍ଡ଼ିତ ପିଣ୍ଡ୍‌ଜି ଆଜ଼ି, ଟାଟି ଆରି କାଟେଲ୍‌ତ ଇଡ୍‌ବିସ୍ ମାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","ଜିରୁସାଲମ୍‌ତ ଚାରିବେଣ୍‍ତି ବସ୍ତିତାଂ ମାନାୟାର୍‌ ପା ରଗ୍ୟାରିଂ ଆରି ବାନ୍ୟା ଜିବୁନ୍‌ ହୁଦାଂ ଆହ୍ୟାତି ଲୁଗାରିଂ ତାହି ରୁଣ୍ଡା ଆଜ଼ି ମାଚାର୍‌, ଆରେ ହେୱାର୍‌ ୱିଜ଼ାକାର୍‌ ଉଜ୍‌ ଆତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","ପାଚେ ମୁଡ଼୍‌ ମାପ୍ରୁହେବାକିନାକାନ୍‌ ଆରି ହେୱାର୍‌ତି ହାଙ୍ଗ୍‌ଦି ୱିଜ଼ାକାର୍‌, ଇଚିସ୍‌ ସାଦୁକିର୍‌ କୁଦା, ପକ୍ୟାତାକାର୍‌ ଜପି ଆକାର୍‍ତ ରିସା ଆଜ଼ି ନିଂତାର୍ ");
INSERT INTO peg_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","ଆରି ପକ୍ୟାତାକାର୍‌ରିଂ ଆସ୍ତି ଗାଚ୍‌ଚି ସାଦା ଜଇଲ୍‍ତ ଇଟ୍‌ତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","ମାତର୍‌ ରୱାନ୍‌ ମାପ୍ରୁତି ଦୁତ୍‌, ନାଣାୱେଡ଼ାଲିଂ ଜଇଲ୍‍ନି ଦୁୱେର୍‌ରିଂ ରିକ୍‍ତାତ୍‌ ଆରି ହେୱାରିଂ ହପ୍‍ଚି ତାସି ଇଚାତ୍‌, ");
INSERT INTO peg_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“ହାଲାଟ୍‌, ମନ୍ଦିର୍‌ ବିତ୍ରେ ଇଞ୍ଜ ମାନାୟାରିଂ ଇ ପୁନି ଜିବୁନ୍‌ନି ବିସ୍ରେ ୱିଜ଼ୁ ବଚନ୍‌ ଇନାଟ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","ଇଦାଂ ୱେନ୍‌ଞ୍ଜି ହେୱାର୍‌ ନାଡ଼ିହିଂ ମନ୍ଦିର୍‌ତ ହଣ୍‌ଜି ହିକ୍ୟା ହିଦେଂ ଲାଗାତାର୍‌ । ୱିସ୍ତି ବିତ୍ରେ ମୁଡ଼୍‌ ମାପ୍ରୁହେବାକିନାକାନ୍‌ ଆରି ପକ୍ୟାତାକାରିଂ ତା ଚେଲାର୍‌ ୱାଜ଼ି ଗାଜା ସବା ଆରି ଇସ୍ରାଏଲ୍‌ ହିମ୍‌ଣାଂତି ପ୍ରାଚିନାର୍‌ କୁକ୍‌ଚି ରବେ କିତାର୍‌, ଆରେ, ହେୱାରିଂ ତାଇୱାନି କାଜିଂ ଜଇଲ୍‌ତ ଲକାଂ ପକ୍ତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","ମାତର୍‌ ହେବା କିନାକାର୍‌ ହାଲ୍‌ଜି ଜଇଲ୍‌ ଇଞ୍ଜ ହେୱାରିଂ ଗାଟାୱାଦାଂ ମାସ୍‌ଦି ୱାଜ଼ି ଇଚାର୍‌, ");
INSERT INTO peg_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“ଆପେଂ ହୁଡ଼୍‌ତାପ୍‌, ଜଇଲ୍ ଇଞ୍ଜ ଆଟ୍‌ୱା କିଜ଼ି ଗେସ୍ତାକା ମାନାତ୍‌ ଆରି ଦୁୱାରିଂକାଂ ଜାଗ୍‌ୱାଡ଼ାର୍‌ ନିଲ୍‌ତାର୍ଣ୍ଣା, ମତର୍‌ ଦୁୱେର୍‌ ଜେତିଲେ, ଜଇଲ୍‌ ଇଲ୍‌ ଆପେଂ ଇନେରିଂ ଗାଟାୱାତାପ୍ ।” ");
INSERT INTO peg_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","ଇ ସବୁ କାତା ୱେନ୍‌ଞ୍ଜି ମନ୍ଦିର୍‌ନି ଜାଗ୍‌ୱାଡ଼ାର୍‌ ଆରି ମୁଡ଼୍‌ ମାପ୍ରୁହେବାକିନାକାନ୍‌ ଇବେନି ଦସା ଇନାକା ଏତ୍‌ କିଜ଼ି ପକ୍ୟାତାକାର୍‌ ବିସ୍ରେ କାବା ଆଦେଂ ଲାଗାତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","ଏଲେଙ୍ଗ୍‌ ୱେଡ଼ାଲିଂ ରୱାନ୍‌ ମାନାୟ୍‌ ୱାଜ଼ି ହେୱାରିଂ କାବୁର୍‌ ହିତାନ୍‌, “ହୁଡ଼ାଟ୍‌, ଏପେଙ୍ଗ୍‌ ଇମ୍‌ଣି ଲୁଗାଂ ଜଇଲ୍‍ ଇଞ୍ଜ ଇଡ଼୍‌ଜି ମାଚାଦେର୍‌, ହେୱାର୍‌ ମନ୍ଦିର୍‌ ଇଞ୍ଜ ମାନାୟାର୍‍ତିଂ ହିକ୍ୟା ହିନାରା ।” ");
INSERT INTO peg_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","ମନ୍ଦିର୍‌ନି ମେଲ୍ୟାର୍‌ କାମ୍‌ଲିୟାର୍‌ ଲାହାଙ୍ଗ୍‌ ହାଲ୍‌ଜି ପକ୍ୟାତି ଚେଲାରିଂ ଆରେରଗ ତେୟ୍‌ ୱାତାର୍‌ । ହେୱାର୍‌ ଇନେସ୍‌ବାନି ପା ପାଣ୍ଡ୍ରା ଆୱାତାର୍‌, ଇନାକିଦେଂକି ହେୱାରିଂ ପାଣ୍ଡ୍ରୁ ମାଚାତ୍‌ ଜେ ମାନାୟାର୍‌ ହେୱାର୍‌ ଜପି କାଲ୍‌କୁ ଇଡ଼୍‌ନାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","ହେୱାର୍‌ ହେୱାରିଂ ତାହି ଗାଜା ସବା ମୁମ୍‌ଦ ନିଲି କିୟ୍‍କିତାର୍ । ହେବେଣ୍ଡାଂ ମୁଡ଼୍‌ ମାପ୍ରୁହେବାକିନାକାନ୍‌ ହେୱାରିଂ ୱେନ୍‌ବାତାନ୍‌, ");
INSERT INTO peg_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“ଆପେଂ ମିଙ୍ଗେଙ୍ଗ୍‌ ଇ ତର୍‌ଦ ହିକ୍ୟା ହିଦେଂ ବେସି ଆଟ୍‌ୱା ଲାକେ ମୁନାକିଜ଼ି ମାନ୍‍ଞ୍ଚାପ୍, ମାତର୍‌ ହୁଡ଼ାଟ୍‌, ଏପେଙ୍ଗ୍‌ ଇନାକିନାଦେରା ମି ହିକ୍ୟାତ ଜିରୁସାଲମ୍‌ ପୁରା କିଜ଼ି ହେ ମାନାୟ୍‍ତି ନେତେର୍‌ନି ଦସ୍‌ ମା ଜପି ଲାଦି କିଦେଂ ମାନ୍‍କିନାଦେରା ।” ");
INSERT INTO peg_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","ମାତର୍‌ ପିତର୍‌ ଆରି ଆଦେକ୍‌ ପକ୍ୟାତାକାର୍‌ ଉତର୍‌ ହିତାର୍‌, “ଆପେଂ ଇସ୍ୱର୍‌ତିଂ ମାନିକିନାପ୍‌ ମାନାୟାରିଂ ମାନି କିଉପ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","ଇମ୍‌ଣି ଜିସୁଙ୍ଗ୍‌ ଏପେଙ୍ଗ୍‌ କ୍ରୁସ୍‌ତ ଡ଼ଇ କିଜ଼ି ଅସ୍ତି ମାଚାଦେର୍‌, ମା ବୁଡାର୍ତି ଇସ୍ୱର୍‌ ହେୱାନିଂ ହାକିତାଂ ନିକ୍‌ତାନ୍ନା । ");
INSERT INTO peg_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","ଆରେ, ହେୱାନ୍‌ ଇନେସ୍‌ ଇସ୍ରାଏଲ୍‌ତିଂ ମାନ୍‌ବାଦ୍‌ଲାୟ୍‌ ଆରି ପାପ୍‌ କେମା ଦାନ୍‌ କିନାନ୍‌, ଇଦାଂ କାଜିଂ ଇସ୍ୱର୍‌ ଜାର୍‌ ବୁଜ୍‌ଣି କେଇ ହୁଦାଂ ହେୱାନିଂ ଗାଜାକାନ୍ ଆରି ମୁକ୍ତିକିନାକାନ୍ ଲାକେ ଗାଜା କିତାନ୍‌ନ୍ନା । ");
INSERT INTO peg_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","ଆରେ, ଆପେଂ ଇ ୱିଜ଼ୁ କାତା ବିସ୍ରେ ସାକି, ଆରେ ଇମ୍‌ଣି ପୁଇପୁୟା ଜିବୁନ୍‌ ଇସ୍ୱର୍‌ ହେୱାନ୍ତି ବଲ୍‌ ମାନିକିନାକାରିଂ ହିତ୍‍ତାନ୍ନା, ହେୱାନ୍‌ ପା ସାକି ।” ");
INSERT INTO peg_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","ଇ କାତା ୱେନ୍‌ଞ୍ଜି ଗାଜା ସବାନି ମାନାୟାର୍‌ ବେସି ରିସା ଆତାର୍‌ ଆରି ପକ୍ୟାତାକାରିଂ ଅହ୍‌ନି କାଜିଂ ରୁହାୟ୍‍ କିଦେଙ୍ଗ୍‌ ଲାଗାତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","ମାତର୍‌ ଗମଲିୟେଲ୍‌ ତର୍‌ନି ରକାନ୍‌ ପାରୁସି, ଇନେନ୍‌କି ସାସ୍ତର୍‌ ଗୁରୁ ଆରି ୱିଜ଼ାକାର୍‌ ଲାଗେ ସନ୍‌ମାନ୍‌ ପାୟାଜ଼ି ମାଚାନ୍‌, ହେୱାନ୍‌ ଗାଜା ସବାତ ନିଲ୍‌ଚି ପକ୍ୟାତାକାରିଂ ଅଲପ୍‍ ସମୁ କାଜିଂ ହପ୍‍ତେଂ ବଲ୍‌ ହିତାନ୍‌, ");
INSERT INTO peg_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","ଆରେ ହେୱାନ୍‌ ହେୱାରିଂ ଇଚାନ୍‌, “ଏ ଇସ୍ରାଏଲିୟନି ଲକୁ, ଇୱାର୍‌ କାଜିଂ ଏପେଙ୍ଗ୍‌ ଇନାକା କିଦେଙ୍ଗ୍‌ ଜାଲ୍‌ଦି ଆନାଦେରା, ହେ ବିସ୍ରେ ଜାଗ୍ରତ୍‌ ଆଡୁ । ");
INSERT INTO peg_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","ଇନାକିଦେଂକି ଇଦାଂ ଆଗେ ତିଉଦା ନିଂଜି ଜାର୍‌ତିଂ ରୱାନ୍‌ ଗାଜା ମାନାୟ୍‌ ଇଞ୍ଜି ଇଚାନ୍‌, ଆରେ ଚାର୍‌ସ ଲକୁ ତା ହୁଦାଂ ମେହା ଆତାର୍‌, ଆସା କିତାର୍‌ ହେୱାନ୍‌ ହାତାନ୍‌, ଆରେ ଏଚେକ୍‌ ଲକୁ ତାଙ୍ଗ୍‌ ବାର୍ସି କିତାର୍‌, ହେୱାର୍‌ ୱିଜ଼ାର୍‌ ଜେଡ଼େକେତ୍ ଆତାର୍‌ ଆରି କାମାୟ୍‌ କିଦେଙ୍ଗ୍‌ ଆଡ୍‌ୱାତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","ହେ ମାନାୟ୍‌ ପାଚେ ଲକୁ ଗାଣାକିନାକା ୱେଡ଼ାଲିଂ ଗାଲିଲିୟ ଜିହୁଦା ନିଂଜି ମାନାୟାରିଂ ତା ପାଚେ ଜେଲ୍‍ଜି ଅଜ଼ି ଗଣ୍ଡ୍‌ଗଲ୍‌ କିୟ୍‍କିତାନ୍; ହେୱାନିଂ ଅସ୍ତାର୍‌, ଆରେ ଏଚେକ୍‌ ଲକୁ ତାଙ୍ଗ୍‌ ବାର୍ସି କିଜ଼ି ମାଚାର୍‌, ହେୱାର୍‌ ୱିଜ଼ାକାର୍‌ ଜେଡ଼େକେତ୍ ଆଜ଼ି ହାଚାର୍ । ");
INSERT INTO peg_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","ନଙ୍ଗ୍‌ ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ଇଞ୍ଜ୍‌ନାଙ୍ଗା, ଏପେଙ୍ଗ୍‌ ଇ ଲକୁ କାଜିଂ ଇନାକା କିୱାଦାଂ ହେୱାରିଂ ପିସ୍ତି ହିଆଟ୍, ଇନାକିଦେଂକି ଇ ରୁହାୟ୍‌ କି ଇ କାମାୟ୍‌ ଜଦି ମାନାୟ୍‍ତାଂ ଆଜ଼ି ମାଚିସ୍‌, ତା ଆତିସ୍‌ ହେଦାଂ କ୍ଡାୱାସ୍‍ ଆଜ଼ି ହାନାତ୍‌; ");
INSERT INTO peg_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","ମାତର୍‌ ଜଦି ହେଦାଂ ଇସ୍ୱର୍‌ତାଂ ଆଜ଼ି ମାଚିସ୍‌, ତା ଆତିସ୍‌ ଏପେଙ୍ଗ୍‌ ହେୱାରିଂ ନସ୍ଟ କିଦେଙ୍ଗ୍‌ ବାର୍ସି ଆଦେଂ ଆଡୁଦେର୍‌, ଏଚେକାଡ଼୍‌ଦ ଏପେଙ୍ଗ୍‌ ଇସ୍ୱର୍‌ତି ବିରୁଦ୍‌ତ ଜୁଜ୍‌ କିନାଦେରା ଇଞ୍ଜି ଚଞ୍ଜ୍ୟାନାଦେର୍ ।” ଗାଜା ସବାନି ମାନାୟାର୍‌ ଗମଲିୟାତି କାତା ମାନି କିତାର୍‌ ");
INSERT INTO peg_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","ହେୱାର୍‌ ହେୱାନ୍ତି କାତାତ ବାର୍ସି ଆତାର୍‌, ଆରେ ପକ୍ୟାତାକାର୍‌ରିଂ ଲାଗାଂ କୁକ୍‌ଚି ହେୱାରିଂ କର୍‌ଡା ତାଂ ଟ୍ରାକ୍‌ତାର୍‌ ଆରି ଜିସୁତି ତର୍‌ଦ କାତା ଇନ୍‍ୱି କାଜିଂ ବଲ୍‌ ହିଜ଼ି ପିସ୍ତାର୍ । ");
INSERT INTO peg_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","ହେବେ ହେୱାର୍‌ ଜେ ଜିସୁ ତର୍‌ କାଜିଂ ଅପ୍‌ମାନ୍‌ ବଗ୍‌ କିଦେଙ୍ଗ୍‌ ଲଡ଼ା ଇଞ୍ଜି ଇନ୍ୟାଜ଼ି ମାଚାର୍‌, ହେଦାଂ କାଜିଂ ହେୱାର୍‌ ୱାରି କିଉ କିଉ ଗାଜା ସବାତାଂ ହସି ହାଚାର୍‌; ");
INSERT INTO peg_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","ଆରେ ହେୱାର୍‌ ନିତ୍ରେ ମନ୍ଦିର୍‌ତ ଆରି ହିକ୍ୟା ହିଦେଂ ଆରି ଜିସୁ ଜେ କ୍ରିସ୍ଟ, ଇ ନେକ୍ରିକାବୁର୍‌ ସୁଣାୟ୍‌ କିଦେଙ୍ଗ୍‌ ଟେବା ଆୱାତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","ଇ ୱେଡ଼ାଲିଂ, ଏଚେକାଡ଼୍‌ଦ ଚେଲାର୍‌ ବାଡା ଆଜ଼ି ମାଚାର୍‌, ହେୱାଡ଼ାଂ ଗ୍ରିକ୍‌ ବାସାନିକାର୍ ଜିହୁଦିର୍‌ ଏବ୍ରିୟ ବାସାନି ଜିହୁଦି ବିରୁଦ୍‍ତ ନିନ୍ଦା କିଦେଙ୍ଗ୍‌ ଲାଗାତାର୍‌, ଇନାକିଦେଂକି ନିତ୍ରେ ହେବା କିଦେଙ୍ଗ୍‌ ହେୱାର୍‌ତି ରାଣ୍ଡିକାଂ ପାଚାରି କିୱାଦାଂ ମାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","ହେବେ ବାର୍‌ ଜାଣ୍‌ ଚେଲାର୍‌ ପାର୍ତି କିନାକାର୍‌ ଲାଗାୟ୍ କୁକ୍‌ଚି ଇଚାର୍‌, “ଇସ୍ୱର୍‌ତି ବଚନ୍‌ ପର୍‌ଚାର୍‍ ପିସ୍ତି କାଦି ପାସ୍‍ପେଦେଂ ମା ହେବାତ ମାନାକା ହାର୍‌ ଆକାୟ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","ଲାଗିଂ ଏ ଟଣ୍ଡାର୍‌ ଆରି ତଣ୍‌ଦେକ୍‌, ଇମ୍‌ଣାକାରିଂ ଆସେଙ୍ଗ୍‌ ଇ କାମାୟ୍‌ତ ବାଚି କିଦେଙ୍ଗ୍‌ ଆଡ୍‌ନାସ୍‌, ଏପେଙ୍ଗ୍‌ ଡାକ୍‍ପୁଟାତାକାର୍ ଆରି ଜିବୁନ୍‌ ଆରି ଗିୟାନ୍ତ ପୁରା ସାତ୍‌ ଜାଣ୍‍ତିଂ ମି ବିତ୍ରେ ସାକି ହିନାକାରିଂ ବାଚି କିଜ଼ି ତିର୍‌ କିୟାଟ୍‌; ");
INSERT INTO peg_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","ମାତର୍‌ ଆସେଙ୍ଗ୍‌ ପାର୍ତାନାତ ଆରି ବଚନ୍‌ ପର୍‌ଚାର୍‌ ହେବା କାମାୟ୍‌ତ ରଲାକେ ଲାଗା ଆଜ଼ି ମାନାସ୍ ।” ");
INSERT INTO peg_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","ଇ କାତା ୱିଜ଼ୁ ମାନାୟାର୍‌ ନଞ୍ଜର୍‍ତ ହାର୍‌ ଚଞ୍ଜାନାତ୍, ଆରେ ହେୱାର୍‌ ପାର୍ତି ଆରି ପୁଇପୁୟା ଜିବୁନ୍‌ତ ବାର୍ତି ସ୍ତିପାନ୍‌ ତର୍‌ନି ରୱାନ୍‌ ମୁଣିକାଂ, ଆରେ ପିଲିପ୍‌, ପ୍ରକର, ନିକାନର୍‌, ତିମନ, ପାର୍ମନା ଆରି ପର୍ତୁମ୍‌ ଆନ୍ତିୟକିଆନି ପାର୍ତିକିୱି ଜିହୁଦି ନିକଲାୟତିଂ ବାଚି କିଜ଼ି, ");
INSERT INTO peg_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","ପକ୍ୟାତାକାର୍‌ତି ମୁମ୍‌ଦ ଏକାତାର୍‌, ଆରେ ହେୱାର୍‌ ହେୱାର୍‌ତି କାପ୍‌ଡ଼ା ଜପି କେଇ ଇଡ଼୍‌ଜି ପାର୍ତାନା କିତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","ଇଦାଂ ପାଚେ ଇସ୍ୱର୍‌ତି ବଚନ୍‌ ଆଦିକ୍‌ ମେଙ୍ଗ୍‍ତାତ୍ ଆରେ ଜିରୁସାଲମ୍‌ତ ଚେଲାର୍‌ ଲମର୍‌ ବାଡାଦେଂ ଲାଗାତାତ୍‌; ଆରେ, ମାପ୍ରୁହେବାକିନାକାନ୍‌ ବିତ୍ରେତାଂ ବେସି ହେନି କ୍ରିସ୍ଟଙ୍ଗ୍‌ ପାର୍ତି କିନାକାର୍‌ ଆତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","ସ୍ତିପାନ୍‌ ଦୟା ଆରି ସାକ୍ତିତ ବାର୍ତି ଆଜ଼ି ଲକୁ ବିତ୍ରେ ଗାଜା ଗାଜା କାବାନି କାମାୟ୍‌ ଆରି କାମାୟ୍‌ କିଦେଙ୍ଗ୍‌ ଲାଗାତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","ମାତର୍‌ ଲିବର୍ତିନ, କୁରିଣିୟ ଆରି ଆଲେକ୍‌ଜାଣ୍ଡ୍ରିୟ ଗାଡ଼୍‌କୁକାଂ ବାହା କିନାକାର୍‌ ତର୍‌ଦ ଡାକ୍‌ପୁଟା ଜିହୁଦିର୍‌ତି ପାର୍ତାନା ଇଲ୍‌ନି କେତେ ଜାଣ୍‌, ଆରେ କିଲିକିୟା ଆରି ଆସିଆ ନିକାର୍‌ କେତେକ୍‌ ଲକୁ ନିଙ୍ଗ୍‌ଜି ସ୍ତିପାନ୍‌ ହୁଦାଂ କାତା ବାର୍ତା କିଦେଙ୍ଗ୍‌ ଲାଗାତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","ମତର୍‌ ହେୱାନ୍‌ ଇମ୍‌ଣି ଗିୟାନ୍‌ ଆରି ଜିବୁନ୍‌ତିଂ ସାକ୍ତିତ କାତା ଇଞ୍ଜି ମାଚାନ୍‌, ହେୱାର୍‌ ହେଦାଂ ବିରଦ୍‍ କିଦେଙ୍ଗ୍‌ ଆଡ୍‌ୱାତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","ହେବେ ହେୱାର୍‌ ମାନାୟାର୍‌ରିଂ ଲାଞ୍ଜ୍‌ ହିଜ଼ି ପୁସ୍‌ରାୟ୍‍ କିତାର୍, ଆରେ ହେୱାର୍‌ ଇଚାର୍‌, “ଆପେଂ ଇଦାଂ ମସା ଆରି ଇସ୍ୱର୍‌ତି ବିରୁଦ୍‌ତ ନିନ୍ଦା ବଚନ୍‌ ଇନାକା ୱେନାପା ।” ");
INSERT INTO peg_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","ଆରେ, ହେୱାର୍‌ ମାନାୟାରିଂ, ଆରେ ପ୍ରାଚିନ୍‌ ଆରି ସାସ୍ତର୍‌ ଗୁରୁରିଂ ରିସା କିଜ଼ି ହେୱାନିଂ ମାଡିବହାତାର୍ ଆରି ହେୱାନିଂ ବାଡ଼୍‌କାସ୍‌ତାଂ ଆଜ଼ି ଗାଜା ପଞ୍ଚାଦିତ ତାହିୱାତାର୍‌, ");
INSERT INTO peg_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","ଆରେ ମିଚ୍‌ ସାକିରିଂ ନିଲି କିତାର୍‌; ହେୱାର୍‌ ଇଚାର୍‌, “ଇ ମାନାୟ୍‌” ଇ ପୁଇପୁୟା ବାହା ଆରି ମସାତି ବିଦି ବିରୁଦ୍‌ତ ବଚନ୍‌ ଇଞ୍ଜେଙ୍ଗ୍‌ ଲାଗାତାନ୍‌, ");
INSERT INTO peg_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","ଇନାକିଦେଂକି ନାଜରିତିୟ ହେ ଜିସୁ ଇ ମନ୍ଦିର୍‌ ସେସ୍‌ କିନାନ୍‌, ଆରେ ମସା ମାଂ ଇନା ଇନା ରିତିନିତି ହିତ୍‍ତାନ୍ନା, ହେ ସବୁ ବାଦ୍‌ଲାୟ୍‌ କିନାନ୍‌ ଇଞ୍ଜି ହେୱାନ୍‌ ଇନାକା ଆପେଂ ୱେଚାପ୍ନା । ");
INSERT INTO peg_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","ହେ ଏଚେୱେଡ଼ାଲିଂ ଗାଜା ପଞ୍ଚାଦିତ କୁଚ୍‌ଚି ମାନି ୱିଜ଼ାର୍‌ ତାଙ୍ଗ୍‌ ହୁଡ଼୍‌ଜି ସ୍ତିପାନ୍‌ ମୁମ୍‌ ବାଦାଡ଼୍‌ତ ଦୁତ୍‌ତି ମୁମ୍‌ ଲାକେ ହୁଡ଼୍‌ତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","ହେବେ ମୁଡ଼୍‌ ମାପ୍ରୁହେବାକିନାକାନ୍‌ ୱେନ୍‌ବାତାନ୍‌, “ଇଦାଂ ୱିଜ଼ୁ ଦାବା ହାତ୍‌ପା କି ?” ");
INSERT INTO peg_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","ସ୍ତିପାନ୍‌ ଇଚାନ୍‌, “ଏ ଟଣ୍ଡାର୍‌ ଆରି ଆବାର୍‌, ୱେନାଟ୍‌ । ମା ଆବା ଅବ୍ରାହାମ୍‌ ହାରଣ୍‌ ଗାଡ଼୍‌ଦ ବାହା କିନି ଆଗେ ଏଚେକାଡ଼୍‌ଦ ହେୱାନ୍‌ ମେସପଟାମିଆତ ଦେସ୍‌ତ ମାଚାନ୍‌, ହେ ଏଚେକାଡ଼୍‌ଦ ହେୱାନ୍‌ ଜାଜ୍‌ମାଲ୍‌ନି ଇସ୍ୱର୍‌ ହେୱାନିଂ ଚଞ୍ଜ୍ୟା ଆଜ଼ି ଇଚାନ୍‌, ");
INSERT INTO peg_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","ଏନ୍‌ ପାର୍ତାନା ଜାର୍‍ ଦେସ୍‌ତାଂ ଆରି ଜାର୍‌ ୱାସ୍କିନିକାରିଂ ବିତ୍ରେ ହସି ୱା, ଆରେ ଆପେଂ ନିଂ ଇମ୍‌ଣି ଦେସ୍ ଚଚ୍‍ଚାନାପ୍‍, ହେ ଦେସ୍‌ତ ହାଲା ।” ");
INSERT INTO peg_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","ହେବେ କଲ୍‌ଦିୟର୍‌ ଦେସ୍‌ତାଂ ହସି ହେୱାନ୍‌ ହାରଣ୍‌ତ ବାହା କିତାନ୍‌, ଆରେ ତା ଆବାତି ହାତି ପାଚେ, ହେବେତାଂ ଏପେଙ୍ଗ୍‌ ନଙ୍ଗ୍‌ ଇମ୍‌ଣି ଦେସ୍‌ତ ବାହା କିତାଦେର୍‌ନା, ଇ ଦେସ୍‌ତିଂ ଇସ୍ୱର୍‍ ହେୱାନିଂ ତାସି ୱାତାନ୍‌, ");
INSERT INTO peg_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","ଆରେ, ହେୱାନ୍‌ ହେୱାନିଂ ହେବେ ଇମ୍‌ଣାକା ପା ଆଦିକାର୍‌ ହିୱାତାନ୍, କି, ର ପାନା ଇଡ୍‌ଦେଂ ଅଲପ୍‍ ବୁମି ହିୱାତାନ୍‌, ଆରେ ହେ ଏଚେକାଡ଼୍‌ଦ ଅବ୍ରାହାମ୍‌ତି ହିମ୍‌ଣାଂ ହିଲ୍‍ୱିତିସ୍‍ ପା ହେୱାନ୍‌ ହେୱାନିଂ ଆରି ହେୱାନ୍ତି ୱାନିବାର୍ହୁନି ଲାତ୍ରାତିଂ ହେଦାଂ ଆଦିକାର୍‌ କିଦେଙ୍ଗ୍‌ କାଜିଂ ହିନାଂ ଇଞ୍ଜି ପାର୍ମାଣ୍‌ କିତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","ଇସ୍ୱର୍‌ ଇ ଲାକେ ଇଚାନ୍‌, “ହେୱାନ୍ତି ଲାତ୍ରା ବିଦେସ୍‌ତ ବାହା କିତାର୍‌ ଆରି ହେ ବାହାତ ଲକୁ ହେୱାରିଂ ଚାଲିସ୍‌ ବାର୍ହୁ ପାତେକ୍‌ ଆଡ଼୍‌ୟାତ ଇଡ଼୍‌ଜି ହେୱାର୍‌ କାଜିଂ ଉତ୍‍ପାତ୍ କିତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","ଆରେ, ଇସ୍ୱର୍‌ ଇଚାନ୍‌, ହେୱାର୍‌ ଇମ୍‌ଣି ଜାତିତ ହେବା କିନାକାନ୍‌ ଆନାନ୍‌, ଆନ୍‌ ତାତି ବିଚାର୍‌ କିନାଂ; ତା ପାଚେ ହେୱାର୍‌ ହେ ଦେସ୍‌ତାଂ ହସି ୱାଜ଼ି ଇ ବାହାତ ମା ପାର୍ତାନା କିତାର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","ଆରେ, ହେୱାନ୍‌ ହେୱାରିଂ ସୁନ୍ନତ୍‌ ନିୟମ୍‌ ହିତାନ୍‌, ଆରେ ତାହୁଦାଂ ଅବ୍ରାହାମ୍‌ ଇସ୍‌ହାକ୍‌ତିଂ ଜଲମ୍‌ ହିଜ଼ି ଆଟ୍‌ ଦିନ୍‌ତାଂ ହେୱାନିଂ ସୁନ୍ନତ୍ କିତାନ୍‌; ଇସାହାକ୍‌ ଜାକୁବ୍‌ଙ୍ଗ୍‌, ଆରେ ଜାକୁବ୍‌ତି ବାର ଆବାଲାତ୍ରାରିଂ ଜଲମ୍‌ ହିଜ଼ି ହେ ଲାକେ ସୁନ୍ନତ୍‌ କିତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“ଜାକୁବତି ହିମ୍‌ଣାଂ ହେୱାର୍‌ ଟଣ୍ଡାର୍‌ ଜସେପ୍‌ତିଂ ଡାରା ଆଜ଼ି ମିସର୍‌ତ ଅନି କାଜିଂ ହେୱାନିଂ ପ୍ରତାର୍, ମତର୍‌ ଇସ୍ୱର୍‌ ହେୱାନ୍‌ ହୁଦାଂ ମାଚାନ୍‌, ");
INSERT INTO peg_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","ଆରେ, ହେୱାନ୍ତି ସବୁ ଦୁକ୍‍ତାଂ ହେୱାନିଂ ଉଦାର୍‌ କିଜ଼ି ମିସର୍‌ନି ରାଜା ପାର ମୁମ୍‌ଦ ହେୱାନିଂ ଦୟା ଆରି ଗିୟାନ୍‍ ହିତାନ୍‌; ହେବେ ପାର ହେୱାନିଂ ମିସର ଆରି ଜାର୍‌ତି ୱିଜ଼ୁ ଇଲ୍‍କୁନି ସାସନ୍‍କାର୍‍ୟା ବାବ୍ରେ ବାଚି କିତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","ପାଚେ ସବୁ ମିସର୍‌ ଆରି କିଣାନ୍‌ତ କାତାର୍ ଆର୍‌ତାତ୍‌, ଆରେ ବେସି ଦୁକ୍ ଗିଟାତାତ୍, ଆରେ ମା ଆଗେନି ବୁଡ଼ାଲୁର୍ କାଦି ପାୟା ଆୱାତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","ମାତର୍‌ ମିସର୍‌ତ କାଦି ମାନାତ୍‌ ଇଞ୍ଜି ୱେନ୍‌ଞ୍ଜି, ଜାକୁବ୍‌ ତା ମେହିରିଂ ପର୍ତୁମ୍‌ ପକ୍‌ତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","ହେବେ ହେୱାର୍‌ ଆରେ, ରିହା ହାନି ୱାଡ଼ାଲିଂ ଜସେପ୍‌ ତା ଟଣ୍ଡାର୍‌ ଲାଗାଂ ଜାଣାଚିନା ଆତାନ୍‌, ଆରେ ପାର ଜସେପ୍‌ତି ପାର୍ତାନାନି ଜାଣାଚିନା ଆତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","ତା ପାଚେ ଜସେପ୍‌ ତା ଲାତ୍ରାହି ଜାକୁବ୍‌ ଆରି ତିନିକଡ଼ି ପନ୍ଦର ଜାଣ୍‌ ୱାସ୍କି ପାର୍ତାନା ୱିଜ଼ାକାରିଂ କୁକିକିଦେଂ ମାନ୍‌ କିତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","ହେବେ ଜାକୁବ୍‌ ଆରେ ମିସର୍‌ତ ହାଚି ପାଚେ, ହେୱାନ୍‌ ନିଜେ ଆରି ମା ଆବା ଲାତ୍ରାର୍ ହାତାର୍, ");
INSERT INTO peg_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","ଆରେ, ହେୱାର୍‌ ହାତି ମଡ଼୍‌ ସିକିମ୍‌ତ ଅୟାଜ଼ି, ଅବ୍ରାହାମ୍‌ ହେବେ ହମର ହିମ୍‍ଣାୱାକ୍‍ଡ଼ା ତାଙ୍ଗ୍‌ ଇମ୍‌ଣି ଦୁଗେର୍‌ ରୁପା ମଲ୍‌ ହିଜ଼ି କଡ଼୍‌ଜି ମାଚାନ୍‌, ହେବେ ମୁଚ୍‌ୟାତାନ୍ ।” ");
INSERT INTO peg_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“ମାତର୍‌ ଇସ୍ୱର୍‌ ଅବ୍ରାହାମ୍‌ ଲାଗେ ଇମ୍‌ଣି ପାର୍ମାଣ୍‌ କିଜ଼ି ମାଚାନ୍‌, ହେ ପାର୍ମାଣ୍‌ ପୁରା ଆନି ୱେଡ଼ାଲିଂ ଲାଗେ ଆତିଲେ, ମା ଲକୁ ମିସର୍‌ ଦେସ୍‌ତ ବାଡାଜ଼ି ବେସି ଆଜ଼ି ନିଂତାର୍ । ");
INSERT INTO peg_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","ୱିସ୍ତି ପାଚେ ମିସର୍‌ତ ଆରେ ରୱାନ୍‌ ରାଜା ଆତାନ୍‌, ହେୱାନ୍‌ ଜସେପ୍‌ତିଂ ପୁନ୍‌ୱାଦାଂ ମାଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","ହେୱାନ୍‌ ମା ଜାତି କାଜିଂ ଚକ୍‍ଲିଆ ଚିନ୍ତା କିତାନ୍‌, ଆରେ, ମା ଆବା ଲାତ୍ରାର୍ ଇନେସ୍‌ ଜାର୍‌ ଜାର୍‌ ହିମ୍‍ଣାଂ ଜିଜ଼ି ମାନ୍‍ୱି କାଜିଂ ବାର୍ତ ତୁହିନାନ୍ । ");
INSERT INTO peg_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","ହେ ସମୁତ ମସା ଜଲମ୍‌ ଆତାନ୍‌, ହେୱାନ୍‌ ଇସ୍ୱର୍‌ତି କାଣ୍‌କୁକାଂ ବେସି ହଲ୍‍ଜି ମାଚାନ୍‌ ଆରି ତିନି ମାସ୍‍ ପାତେକ୍‌ ତା ଲାତ୍ରାହି ଇଞ୍ଜ ପହାକିୟା ଆଜ଼ି ମାଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","ପାଚେ ହେୱାନ୍‌ ଏଚେକାଡ଼୍‌ଦ ବାର୍‍ତ ତୁହିୟା ଆତାନ୍‌, ହେ ଏଚେକାଡ଼୍‌ଦ ପାରତି ଗାଡ଼୍‌ହି ହେୱାନିଂ ନିକ୍‌ଚି ଅଜ଼ି ତା ହିମ୍‌ଣା ଲାକେ ପହା କିତାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","ଆରେ, ମସା ମିସରିୟର୍‌ତି ସବୁ ବିଦ୍ୟାତ ସିକିତ୍ ଆଜ଼ି ବଚନ୍‌ ଆରି କାମାୟ୍‌ତ ଜାଣାଚିନା ଆତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","ମସାତି ରିକଡ଼ି ବାର୍ହୁ ପୁରାନି ୱେଡ଼ାଲିଂ ତା ଟଣ୍ଡାର୍‌, ଇଚିସ୍‌ ଇସ୍ରାଏଲ୍‌ ହିମ୍‌ଣାକାଂ ହେବା କିନି କାଜିଂ ହେୱାନ୍ତି ମାନ୍ତ ଉବ୍‌ଜା ଆତାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","ହେୱାର୍‌ ବିତ୍ରେ ରକାନ୍‌ କାଜିଂ ରୱାନ୍‌ ମିସରିୟର୍‌ ଅନ୍ୟାୟ୍‌ କିଜ଼ି ମାନାକା ହୁଡ଼୍‌ଜି, ମସା ତା ରାକ୍ୟାକିଦେଂ ମିସରିୟ ରୱାନ୍‌ କାଜିଂ ପାର୍ମାଣ୍‌ ଅଜ଼ି ହେୱାନିଂ ଅସ୍ତାର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","ହେୱାନ୍ତି କେଇ ହୁଦାଂ ଇସ୍ୱର୍‌ ଜେ ହେୱାନ୍‌ତି ଟଣ୍ଡାର୍‌ରିଂ ମୁକ୍ତି କିନାନା, ଇଦାଂ ହେୱାର୍‌ ବୁଜାନାର୍ ଇଞ୍ଜି ହେୱାନ୍‌ ବାବି କିଜ଼ି ମାଚାନ୍‌, ମତର୍‌ ହେୱାର୍‌ ବୁଜାୱାତାର୍ । ");
INSERT INTO peg_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","ଆର୍କାତ୍‌ ନାଜିଂ ହେୱାନ୍‌ ରିୟାର୍‌ ଇସ୍ରାଏଲିୟରିଂ ଗଣ୍ଡ୍‌ଗଲ୍‌ କିଜ଼ି ମାନାକା ହୁଡ଼୍‌ତାନ୍‌ ଆରି ହେୱାର୍‌ ବିତ୍ରେ ସୁସ୍ତା ମେହାୟ୍‌ କିଦେଙ୍ଗ୍‌ ସେସ୍ଟା କିତାନ୍‌ । ହେୱାନ୍‌ ଇଚାନ୍‌, “ୱେନାଟ୍‌, ଏପେଙ୍ଗ୍‌ ରିୟାଦେର୍‌ତ ଇସ୍ରାଏଲିୟ ଟଣ୍ଡାର୍‌ । ଇନେକିଦେଂ ଏଲେଙ୍ଗ୍‌ ଅନ୍ୟାୟ୍‌ କିନାଦେରା ?” ");
INSERT INTO peg_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","ମାତର୍‌ ଇମ୍‌ଣି ପାଡ଼୍‍ହା ଇଞ୍ଜି କାଜିଂ ଅନ୍ୟାୟ୍‌ କିଜ଼ି ମାଚାନ୍‌, ହେୱାନ୍‌ ମସାଙ୍ଗ୍‌ ତିଗ୍‍ଜି ଇଚାନ୍‌, “ଇନେର୍‌ ନିଂ ମା ଜପି ମୁଣିକା ଆରି ବିଚାର୍‌କାର୍‌ୟା ଲାକେ ବାହି ହିତ୍‍ତାନ୍ ?” ");
INSERT INTO peg_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","“ନିହିଂ ଇନେସ୍‌ ହେ ମିସରିୟର୍‌ତିଂ ଅସ୍ତି ମାଚାୟ୍‌, ହେ ଲାକେ ନାଙ୍ଗ୍‌ ଅସ୍ତେଦେଂ ମାନ୍‌ କିଦ୍‌ନାୟା ?” ");
INSERT INTO peg_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","ଇ କାତା ୱେନ୍‌ଞ୍ଜି ମସା ମିଦିୟନ୍‌ ଦେସ୍‌ତ ବାହା କିତାନ୍‌; ହେବେ ହେୱାନ୍ତି ରିଆର୍‌ ହିମ୍‌ଣାଂ ଜଲମ୍‌ ଆତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","ପାଚେ “ରିକଡ଼ି ବାର୍ହୁ ବାର୍ତି ଆତିଲେ, ସିନୟ୍‌ ମାଡ଼ିନି ବାଟାତ ରୱାନ୍‌ ଇସ୍ୱର୍‌ତି ଦୁତ୍‌ର୍‌ ବୁଟାତ ନାଣିଅଜଡ଼୍‍ତ ହେୱାନିଂ ଚଞ୍ଜ୍ୟାତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","ମସା ହେଦାଂ ହୁଡ଼୍‌ଜି କାବା ଆତାନ୍‌, ଆରେ ହାର୍‌ ଲାକେ ହୁଡ଼୍‌ଦେଂ କାଜିଂ ଲାଗେ ହାନି ୱେଡ଼ାଲିଂ ମାପ୍ରୁତି ଇ କାତା ୱେଚାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","“ଆନ୍‌ ମି ବୁଡାଆକର୍ତି ଇସ୍ୱର୍‌, ଅବ୍ରାହାମ୍‌, ଇସ୍‌ହାକ୍‌ ଆରି ଜାକୁବ୍‌ତି ଇସ୍ୱର୍‌ । ହେବେ ମସା ତ୍ରିଗ୍‍ଜି ହାର୍‌ ହୁଡ଼୍‌ଦେଂ ସାସ୍‌ କିୱାତାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","ତା ପାଚେ ମାପ୍ରୁ ହେୱାନିଂ ଇଚାନ୍‌, “ନି ପାନାତାଂ ପାଣ୍ଡାଇଙ୍ଗ୍‌ ଉନ୍ଦା, ଇନାକିଦେଂକି ଏନ୍‌ ଇମ୍‌ଣି ମେଦ୍‌ନିତ ନିଲ୍‍ତାୟ୍‍ନା, ହେଦାଂ ପୁଇପୁୟା ମେଦ୍‌ନି । ");
INSERT INTO peg_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","ମିସର୍‌ତ ମା ଇମ୍‌ଣି ଲକୁ ମାନାର୍‌, ଆପ୍‌ ହେୱାର୍‌ତି ଦୁକ୍‌ ହୁଡ଼୍‍ତାପ୍‍ନ୍ନା ଆରି ହେୱାର୍‌ତି ଆଡ଼ାକୁକା ୱେଚାପ୍‍ନ୍ନା, ଆରେ ହେୱାରିଂ ଉଦାର୍‌ କିନି କାଜିଂ ଜୁତ୍‍ତାପ୍‍ନ୍ନା; ଆରେ ନଂ ୱା, ଆନ୍‌ ନିଂ ମିସର୍‍ତ ପକ୍ତାନାଂ ।” ");
INSERT INTO peg_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“ଇନେର୍‌ ନିଂ ମୁଡ଼୍‌ଦାକାନ୍‌ ଆରି ବିଚାର୍‌କାର୍‌ୟା ଲାକେ ବାଚି କିତ୍‌ତାନ୍‌ ଇଞ୍ଜି ଇଞ୍ଜି ଇ ଇମ୍‌ଣି ମସାଙ୍ଗ୍‌ ହେୱାର୍‌ ମାନିକିୱାଦାଂ ମାଚାର୍‌, ହେୱାନିଂ ଇସ୍ୱର୍‌ ବୁଟାତ ଚଞ୍ଜ୍ୟା ଆଜ଼ି ଦୁତ୍‌ତି ଉପ୍‌କାର୍‌ତାଂ ସାସନ୍‌ ଆରି ଉଦାର୍‌କାର୍‌ୟା କିଜ଼ି ପକ୍‌ତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","ଇ ମୁଣିକା ମିସର୍‌ ଦେସ୍‌, ନେତେର୍‌ ହାମ୍‌ଦୁର୍‌ ଆରି ରିକଡ଼ି ବାର୍ହୁ ପାତେକ୍‌ ବାଟାତ ବାର୍‍ବିନି କାବାନି କାମାୟ୍‌ ଆରି ଚିନ୍‌କୁ ସାଦନ୍‌ କିଜ଼ି ହେୱାରିଂ ହପ୍‍ଚି ତାହିୱାତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","ମସା ନିଜେ ଇସ୍ରାଏଲ୍‌ନି ମାନାୟାରିଂ ଇଞ୍ଜି ମାଚାନ୍‌, ଇସ୍ୱର୍‌ ନାଂ ଇନେସ୍‌ ପକ୍ତାତାନ୍‌ ହେ ଲାକେ ମି ଲାଗାଂ ରୱାନ୍‌ ବେଣ୍‌ବାକ୍‌ଣାୟ୍‌କିନାକାର୍‌ ପକ୍ତାନାନ୍‌, ହେୱାନ୍‌ ମି ଜାର୍‌ ଟଣ୍ଡାର୍‌ ବିତ୍ରେ ରୱାନ୍‌ ଆନାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","ଇ ମୁଣିକା ମଣ୍ଡ୍‌ଲି ବିତ୍ରେ ମାନ୍‌ଞ୍ଜି ସିନୟ୍‌ ମାଡ଼ିତ ହେୱାନ୍‌ ହୁକେ କାତା ଇଞ୍ଜିମାଚି ଦୁତ୍‌ତି ଆରି ମା ଆକର୍‌ ବିତ୍ରେ ମାଦ୍‌ଣାକାନ୍‌ ମାଚାନ୍‌; ହେୱାନ୍‌ ମିଙ୍ଗ୍‌ ଦାନ୍‌ କିଦ୍‍ଦେଂ କାଜିଂ ଜିଜ଼ି ମାନାକା ବଚନ୍‌ ପାୟାତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“ମାଦାଂ ଆବାର୍‌ଲାତ୍ରା ହେୱାର୍‌ ହେୱାନ୍ତି କାତା ମାନିକିୱାଦାଂ ହେୱାନିଂ ମାନ୍‌ କିୱାତାର୍‌, ଆରେ ଜାର୍‌ ଜାର୍‌ ମାନ୍ତ ମିସର୍‌ ଦେସ୍‌ତ ମାସ୍‌ଦି ହାଲ୍‌ଜି ହାରଣ୍‌ଙ୍ଗ୍‌ ଇଚାର୍‌, ");
INSERT INTO peg_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","ହେଦାଂ ହେୱାର୍‌ ହାରଣ୍‌ଙ୍ଗ୍‌ ଇଚାର୍‌, ମା ଆଗେ ଆଗେ ହାନି କାଜିଂ ମା କାଜିଂ ପେନ୍‌କୁକାଂ ରଚା, ଇନାକିଦେଂକି ଇ ଇମ୍‌ଣି ମସା ମାଙ୍ଗେଙ୍ଗ୍‌ ମିସର୍‌ ଦେସ୍‌ତାଂ ହପ୍‌ଚି ତାଇୱାତ୍‌ତାନ୍‌, ତା କାଜିଂ ଇନାକା ଗିଟାତାତ୍‍ନ୍ନା, ହେଦାଂ ଆପେଂ ପୁନୁପ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","ଆରେ, ହେ ସମୁତ ହେୱାର୍‌ ର ବାଚି ରଚ୍‌ଚାର୍‌ ଆରି ହେ ପୁତ୍‌ଡ଼ା ଇସାବ୍‌ରେ ପୁଜାକିଦେଙ୍ଗ୍‌ ଜାର୍‌ ଜାର୍‌ କେଇ ରଚ୍‌ଚି ଆଡ଼୍‍ମାଡ଼୍‍ତିଂ ବଜି କିଜ଼ି ୱାରି କିଦେଙ୍ଗ୍‌ ଲାଗାତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","ମାତର୍‌ ଇସ୍ୱର୍‌ ମାସ୍‌ଦି ହେୱାରିଂ ବାଦାଡ଼୍‌ତ ହୁକାକାଂ ପାର୍ତାନା କିଦେଙ୍ଗ୍‌ ପିସ୍ତି ହିତାର୍‌, ଇନେସ୍‌ ବେଣ୍‌ବାକ୍‌ଣାୟ୍‌କିନାକାର୍‌ ପତିତ ଲେକା ମାନାତ୍‌, “ଏ ଇସ୍ରାଏଲ୍‌ ଲାତ୍ରା ! ବାଟାତ ରିକଡ଼ି ବାର୍ହୁ ପାତେକ୍‌, ଏପେଙ୍ଗ୍‌ ମା କାଜିଂ ପସୁ ପୁଜା ଆରି ଆକାତ୍‌ କିୱାଦାଂ ମାଚାଦେର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","ଲାଗିଂ ଏପେଙ୍ଗ୍‌ ପାର୍ତାନା କିନି କାଜିଂ ଇମ୍‌ଣି ପୁତ୍‌ଡ଼ାଂ ରଚ୍‌ଚି ମାଚାର୍‌, ମଲକର୍‌ ତୁମ୍‌ ଆରି ରମ୍ପା ପେନ୍‍କୁନି ହୁକାତିଂ ଏପେଙ୍ଗ୍‌ ଅଜ଼ି ପୁଜା କିତାର୍ ।” ଲାଗିଂ ଆପ୍‌ ବାବିଲନ୍‌ତ, ଆନ୍‌ଟି ବାଗାଙ୍ଗ୍‌ ପକ୍ତାନାଙ୍ଗ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“ବାଟାତ ମା ଆଗେନି ଆବାର୍‌ଲାତ୍ରା ଲାହାଂ ଇସ୍ୱର୍‌ତି ମାନାକା ତାକେ ସାକି ତୁମ୍‌ ମାଚାତ୍‌ । ଇସ୍ୱର୍‌ ମସାଙ୍ଗ୍‌ ଇନେସ୍‌ ରଚ୍‌ଚି ୱେଚ୍‌ଚି ମାଚାନ୍‌ ଆରି ମସାଂ ଇମ୍‌ଣି ହାର୍ଦାକା ଚଚ୍‌ଚି ମାଚାନ୍‌, ଇଦାଂ ହେ ଲାକେ ରଚ୍‌ୟାଜ଼ି ମାଚାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","ଆରେ, ମା ଆକର୍‌ ହେଦାଂ ଗାଟାଜ଼ି, ଇସ୍ୱର୍‌ ହେୱାର୍‌ ମୁମ୍‍ଦାଂ ଇମ୍‌ଣି ଜାତିରିଂ ହପ୍‍ଚି ତୁହିତାର୍, ହେ ଜାତିରିଂ ଆଦିକାର୍‌‌ତ ହେୱାର୍‌ ଜିହସୁୟତି ଇଚି ହଣ୍‌ଜି ହେଦାଂ ଦାଉଦ୍‌ତି ୱେଡ଼ାଂ ପାତେକ୍‌ ଇଡ଼୍‌ତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","ହେୱାନ୍‌ ଇସ୍ୱର୍‌ କାଣ୍‍କୁତ ଦୟା ପାୟାଜ଼ି ଜାକୁବ୍‌ତି ଇସ୍ୱର୍‌ କାଜିଂ ର ଇଲ୍‌ ରଚ୍‍ନି କାଜିଂ ପାର୍ତାନା କିତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","ମାତର୍‌ ସଲମନ୍‌ ହେୱାନ୍ତି କାଜିଂ ର ମନ୍ଦିର୍‌ ଇଲ୍‌ ରଚ୍‍ଚାନ୍ ।” ");
INSERT INTO peg_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“ଆତିସ୍‌ପା ଇନେର୍‌ ସିଗ୍‌ଦାକାନ୍‌ ଇସ୍ୱର୍‌, ହେୱାନ୍‌ କେଇଦ ରଚ୍‌ଚି ଇଲ୍‌ ବାହା କିଉନ୍‌ ! ଇନେସ୍‌କି ବେଣ୍‌ବାକ୍‌ଣାୟ୍‌କିନାକାର୍‌ ଲେକିକିତାନ୍ନା ।” ");
INSERT INTO peg_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","ମାପ୍ରୁ ଇଚାନ୍‌ “ବାଦାଡ଼୍‌ତ ମା ଗାଦି, ପୁର୍ତି ମା ପାନା ତାରେନ୍‌, ମାପ୍ରୁ ଇଚାନ୍ନା, ଏପେଙ୍ଗ୍‌ ମା କାଜିଂ ଇନେସ୍‌ବାନି ଇଲ୍‌ ରଚ୍‌ନାଦେର୍ ? କି ମା ଜମ୍‌ନି ବାହା ଇମେତ୍‌ ? ");
INSERT INTO peg_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","ମା କେଇ ଇନାକା ଇ ୱିଜ଼ୁ ବିସ୍ରେ ଉବ୍‌ଜାଣ୍‌ କିୱାତାଂନା ?” ");
INSERT INTO peg_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","ସ୍ତିପାନ୍‌ ଆରେ ଇଚାନ୍‌ “ଏପେଙ୍ଗ୍‌ ଏଚେକ୍‌ ଅମାନ୍ୟା । ମି ମାନ୍ତ ଏଚେକ୍‌ ଅସୁନ୍ନତ୍‌ । ଇସ୍ୱର୍‌ତି ବଚନ୍‌ କାଜିଂ ଏପେଙ୍ଗ୍‌ ୱେନ୍‌ୱାକାଦେର୍‌ । ଏପେଙ୍ଗ୍‌ ସମାନ୍‌ ମି ଆଗେନି ଆବା ଲାତ୍ରା ଲାକେ; ଏପେଙ୍ଗ୍‌ ତାଇନାତ୍‌ ପୁଇପୁୟା ଜିବୁନ୍‌ତିଂ ବିରଦ୍‍ କିନାଦେରା । ");
INSERT INTO peg_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","ବେଣ୍‌ବାକ୍‌ଣାୟ୍‌କିନାକାର୍‌ ବିତ୍ରେ ଇନେରିଂ ମି ଆକର୍‌ କେତେୱାଦାଂ ମାଚାର୍‌ ? ଇନେର୍‌ ହେ ଦାର୍ମି ମୁଣିକା ୱାନି ବିସ୍ରେ ଆଗେତାଂ ୱେଚ୍‌ଚି ମାଚାର୍‌, ହେୱାରିଂ ହେୱାର୍‌ ଅସ୍ତାର୍‌; ନଙ୍ଗ୍‌ ଏପେଙ୍ଗ୍‌ ହେୱାନିଂ ସାତ୍ରୁ କେଇଦ ହେଲାୟ୍‌ କିଜ଼ି ଅସ୍ତାଦେର୍; ");
INSERT INTO peg_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","ଏପେଙ୍ଗ୍‌ ଦୁତ୍‌ର୍‌ ହୁଦାଂ ଆଗେନି ବିଦିତାଂ ଗାଟାଜ଼ି ମାଚାଦେର୍‌, ମତର୍‌ ବିଦି ପାଲି କିୱାତାଦେର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","ଗାଜା ସବାନି ମାନାୟାର୍‌ ୱିଜ଼ୁ କାତା ୱେନ୍‌ଞ୍ଜି ହେୱାର୍‌ ମୁମ୍‍ରାତ୍‍ତାର୍, ଆରେ ହେୱାନ୍‌ କାଜିଂ ଟାଡାଙ୍ଗ୍‌ ରେତି କିଦେଙ୍ଗ୍‌ ଲାଗାତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","ମାତର୍‌ ହେୱାନ୍‌ ପୁଇପୁୟା ଜିବୁନ୍‌ତ ବାର୍ତି ଆଜ଼ି ବାଦାଡ଼୍‌ତ ର କାଣ୍‍ଗାତ ହୁଡ଼୍‌ତାନ୍‌, ଆରି ଇସ୍ୱର୍‌ତିଂ ଜାଜ୍‌ମାଲ୍‌ ଆରି ଜିସୁଙ୍ଗ୍‌ ଇସ୍ୱର୍‌ତି ବୁଜ୍‌ଣି ପାଡ଼୍‍କା ନିଲ୍‌ଚି ମାନାକା ହୁଡ଼୍‌ଜି ଇଚାର୍‌, ");
INSERT INTO peg_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","ହେୱାନ୍‌ ଇଚାନ୍‌ “ହୁଡ଼ାଟ୍‌, ଆନ୍‌ ବାଦାଡ଼୍‌ତ ଜେୟାତି ଆରି ମାନାୟ୍‍ ମାଜ଼ିଙ୍ଗ୍‌ ଇସ୍ୱର୍‌ତି ବୁଜ୍‌ଣି ବାଗାଙ୍ଗ୍‌ ନିଲ୍‌ଚି ମାନାକା ହୁଡ଼୍‍ନାଙ୍ଗା ।” ");
INSERT INTO peg_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","ମତର୍‌ ହେୱାର୍‌ ଗାଜାକାଟ୍‌ତାଂ କିକିରାଡିଂ କିଜ଼ି ଜାର୍‌ ଜାର୍‌ କିତୁଲ୍‍ତିଂ ଗେସ୍‍ତାର୍, ଆରେ ପାଡ଼୍‌କାତାଙ୍ଗ୍‌ ଆଜ଼ି ହେୱାନ୍ତି ଜପି ମାଡିବହା ଆତାର୍‌, ");
INSERT INTO peg_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","ଆରେ, ହେୱାର୍‌ ହେୱାନିଂ ଗାଡ଼୍‌ଦାଂ ହପ୍‍ଚି କାଲ୍‌କୁ ଇଡ୍‌ଦେଂ ଲାଗାତାର୍‌; ଆରେ, ମିଚ୍‌ ସାକିର୍‌ ସାଉଲ୍‌ ଇନି ରୱାନ୍‌ ଦାଂଣେନ୍‍ତି ପାନା ଲାଗାୟ୍‌ ଜାର୍‌ ଜାର୍‌ ହେନ୍ଦ୍ରାଙ୍ଗ୍‌ ଇଡ୍‌ତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","ହେୱାଡ଼ାଂ ହେୱାର୍‌ ସ୍ତିପାନ୍‌ତିଂ କାଲ୍‌କୁ ଇଡ଼୍‌ଜି ମାଚାର୍‌, ହେୱାଡ଼ାଂ ହେୱାନ୍‌ ପାର୍ତାନା କିଜ଼ି ଇଚାନ୍‌, “ଏ ମାପ୍ରୁ ଜିସୁ, ନା ଜିବୁନ୍‌ତିଂ ଇଟା ।” ");
INSERT INTO peg_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","ଆରେ, ହେୱାନ୍‌ ମେଣ୍ଡାଙ୍ଗ୍‌ କୁନ୍ଦିକିଜ଼ି ଗାଜାକାଟ୍‌ତାଂ କୁକ୍‌ଚି ଇଚାନ୍‌, “ଏ ମାପ୍ରୁ, ଇ ପାପ୍‌ ଇୱାର୍‌ ବିରୁଦ୍‌ତ ଗାଣା କିମା ।” ହେୱାନ୍‌ ଇଦାଂ କାଣ୍‌କୁ ଜୁଚ୍‍ଚି ହାତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","ସାଉଲ୍‌ ହେୱାନ୍ତି ପାରାଣ୍‌ ନାସ୍ତ ରାଜି ମାଚାନ୍‌ । ସାଉଲ୍‌ ମଣ୍ଡ୍‌ଲି ଜପି ନିନ୍ଦା କିନାକା । ହେ ଦିନ୍‌ ଜିରୁସାଲମ୍‌ତ ମାନି ମଣ୍ଡ୍‌ଲି କାଜିଂ ବେସି ନିନ୍ଦା ଆତାତ୍‌, ହେବେ ପକ୍ୟାତାକାର୍‌ତି ପିସ୍ତି ଆଦେକ୍‌ ୱିଜ଼ାକାର୍‌ ଜିହୁଦା ରାଜି ଆରି ସମିରଣ୍‌ ନିପ ଚାରିବେଣ୍‌ତାଂ ଚିନ୍‍ବିନ୍ ଆଜ଼ି ହାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","ଆତିସ୍‌ପା କେତେ ଜାଣ୍‌ ହୁଦାର୍ ଲଗୁ ସ୍ତିପାନ୍‌ତିଂ କବର୍‌ ହିଜ଼ି ହେୱାନ୍‌ କାଜିଂ ବେସି ଦୁକ୍‌ କିତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","ମତର୍ ସାଉଲ୍‌ ଇଲ୍‌କୁ ଇଲ୍‌କୁ ହଣ୍‌ଜି ଆଣ୍ଡ୍ରାରିଂ ଆରି କଗ୍‍ଲେକାଂ ଜେଲ୍‍ଜି ତାହି ଜଇଲ୍‌ ଇଞ୍ଜ ହେଲାୟ୍‌ କିଜ଼ି ମଣ୍ଡ୍‌ଲିତିଂ ବୁଡାୟ୍‌ କିଦେଙ୍ଗ୍‌ ଲାଗାତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","ହେବେ ପାର୍ତି କିନାକାର୍‌ ଜେଡ଼େକେତେ ଆଜ଼ି ମାଚାର୍‌, ହେୱାର୍‌ ଚାରିବେଣ୍‌ତାଂ ବୁଲା ଆଜ଼ି ନେକ୍ରିକାବୁର୍‌ନି ବଚନ୍‌ ସୁଣାୟ୍‌ କିଦେଙ୍ଗ୍‌ ଲାଗାତାର୍ । ");
INSERT INTO peg_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","ଆରେ, ପିଲିପ୍‌ ସମିରଣ୍‌ତ ମୁଡ଼୍‌ ଗାଡ଼୍‌ଦ ହାଲ୍‌ଜି ମାନାୟାର୍‌ ଲାଗେ କ୍ରିସ୍ଟତି ନେକ୍ରିକାବୁର୍‌ ସୁଣାୟ୍‌ କିଦେଙ୍ଗ୍‌ ଲାଗାତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","ଆରେ, ମାନାୟାର୍‌ ପିଲିପ୍‌ତି କାତା ୱେନ୍‌ଞ୍ଜି ଆରି ହେୱାନ୍ତି କିତି କାବା କାମାୟ୍‌ ସବୁ ହୁଡ଼୍‌ଜି ରମାନ୍ତ ହେୱାନ୍ତି କାତା ମାନ୍‌ ହିଜ଼ି ମାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","ଇନାକିଦେଂକି ବାନ୍ୟା ଜିବୁନ୍‌ ବେସି ଲକୁତାଂ ହେ ଜିବୁନିଂ ଗାଜାକାଟ୍‍ତ କିକିରାଡିଂ କିଜ଼ି ହସି ୱାଦେଂ ଲାଗିତିକ୍‍; ଆରେ ବେସି ହିର୍‍କୁଲ୍‍ରଗ୍ୟାର୍ ଆରି ଚଟାର୍‌ ଉଜ୍‌ ଆତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","ହେବେ ଗାଡ଼୍‌ଦ ବେସି ୱାରିୟା ଆତାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","ମାତର୍‌ ସିମନ୍‌ ତର୍‌ନି ରକାନ୍‌ ମାନାୟ୍‌ ଇଦାଂ ଆଗେ ହେ ଗାଡ଼୍‌ଦ ଜତର୍‍ କାମାୟ୍‌ କିଜ଼ି ଜାର୍‌ତିଂ ରକାନ୍‌ ଗାଜା ମାନାୟ୍‍ ଇଞ୍ଜି ଇଞ୍ଜି ସମିରଣିୟ ଜାତିତିଂ କାବା କିଜ଼ି ମାଚାନ୍‌; ");
INSERT INTO peg_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","ଇସ୍ୱର୍‌ତି “ଇମ୍‌ଣି ସାକ୍ତିତିଂ ଗାଜା ଇଞ୍ଜି ଇନ୍ୟାନାତ୍, ହାରୁକାର୍‍ତାଂ ଗାଜା ପାତେକ୍‌ ୱିଜ଼ାକାର୍‌ ଇୱାନ୍‌ ହେୱାନ୍‌ ଇଞ୍ଜି ହେୱାନିଂ ମାନି କିଜ଼ି ମାଚାର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","ହେୱାର୍‌ ହେୱାନିଂ ମାନି କିନାକା ଇଦାଂ ଜେ, ହେୱାନ୍‌ ବେସି ଦିନ୍ ଆତାତ୍‌ ଜାର୍‌ ଜତର୍‌ କାମାୟ୍‌ ହୁଦାଂ ହେୱାରିଂ କାବା କିଜ଼ି ମାଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","ମାତର୍‌ ପିଲିପ୍‌ ଇସ୍ୱର୍‌ତି ରାଜି ଆରି ଜିସୁ କ୍ରିସ୍ଟତି ତର୍‌ ବିସ୍ରେ ନେକ୍ରିକାବୁର୍‌ ସୁଣାୟ୍‌ କିତିଲେ ହେୱାର୍‌ ଏଚେକାଡ଼୍‌ଦ ହେୱାନ୍ତି କାତାତ ପାର୍ତି କିତାର୍‌, ହେ ଏଚେକାଡ଼୍‌ଦ ଆଣ୍ଡ୍ରାଙ୍ଗ୍‌ ଆରି କଗ୍‌ଲେକ୍‌ ୱିଜ଼ାର୍‌ ବାପ୍ତିସିମ୍‌ ଅଦେଂ ଲାଗାତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","ଆରେ, ସିମନ୍‍ ନିଜେ ପା ପାର୍ତି କିଜ଼ି ବାପ୍ତିସିମ୍‌ ଅତାନ୍‌ ଆରି ପିଲିପ୍‌ତି ହାଙ୍ଗ୍‌ ହାଙ୍ଗ୍‌ ମାଚାନ୍‌, ଆରେ ବାର୍‍ବିନ୍‍ ଚିନ୍‌କୁ ଆରି ଗାଜା ଗାଜା ସାକ୍ତିନି କାମାୟ୍‌ ହୁଡ଼୍‌ଜି କାବା ଆଦେଂ ଲାଗାତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","ସମିରଣିୟ ଲକୁ ଜେ ଇସ୍ୱର୍‌ତି ତର୍‌ଦାଂ ବଚନ୍‌ ମାନି କିତାର୍ଣ୍ଣା, ଇଦାଂ ଏଚେକାଡ଼୍‌ଦ ଜିରୁସାଲମ୍‌ତ ମାନି ପକ୍ୟାତାକାର୍‌ ୱେଚାର୍‌, ହେ ଏଚେକାଡ଼୍‌ଦ ହେୱାର୍‌ ପିତର୍‌ ଆରି ଜହନ୍‌ତିଂ ହେୱାର୍‌ ଲାଗେ ପକ୍ତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","ହେୱାର୍‌ ହାଲ୍‌ଜି, ହେ ଲକୁ ଇନେସ୍‌ ପୁଇପୁୟା ଜିବୁନ୍‌ ପାୟାନାର୍, ଇଦାଂ କାଜିଂ ହେୱାର୍‌ କାଜିଂ ପାର୍ତାନା କିତାର୍‌, ");
INSERT INTO peg_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","ଇନାକିଦେଂକି ଇ ପାତେକ୍‌ ହେୱାନ୍‌ ହେୱାର୍‌ ବିତ୍ରେ ଇନେର୍‌ ଜପି ପା ପୁଇପୁୟା ଜିବୁନ୍‌ ଜୁଦ୍‍ୱାଦାଂ ମାଚାତ୍‌, କେବଲ୍‌ ହେୱାର୍‌ ମାପ୍ରୁ ଜିସୁତି ତର୍‌ଦ ବାପ୍ତିସିମ୍‌ ଆଜ଼ି ମାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","ହେ ଏଚେୱେଡ଼ାଲିଂ ପିତର୍‌ ଆରି ଜହନ୍‌ ହେୱାର୍‌ ହେୱାର୍‌ତି ଜପି କେଇ ହିତାନ୍, ଆରେ ହେୱାର୍‌ ପୁଇପୁୟା ଜିବୁନ୍‌ ଗାଟା ଆତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","ପକ୍ୟାତାକାର୍‌ତି କେଇ ହିତି ହୁଦାଂ ଜିବୁନ୍‌ ୱାନାକା ହୁଡ଼୍‌ଜି, ସିମନ୍‌ ହେୱାରିଂ ଟାକାଂ ହିଜ଼ି ଇଚାନ୍‌, ");
INSERT INTO peg_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","“ନାଙ୍ଗ୍‌ ପା ଇ ସାକ୍ତି ହିଦାଟ୍, ଇନେସ୍‌ ଆନ୍‌ ଇମ୍‌ଣାକାନ୍‌ ମାନାୟ୍‌ ତାରେନ୍‌ କେଇ ହିନାଙ୍ଗ୍, ହେୱାନ୍‌ ପୁଇପୁୟା ଜିବୁନ୍‌ ଗାଟାନାନ୍ ।” ");
INSERT INTO peg_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","ମାତର୍‌ ପିତର୍‌ ହେୱାନିଂ ଇଚାନ୍‌, ନି ଟାକାଂ “ନି ହୁଦାଂ କର୍ଚ ଆୟେକ୍‌, ଇନାକିଦେଂକି ନି ଟାକାଂ ହୁଦାଂ ଇସ୍ୱର୍‌ତି ଦାନ୍‌ କଡ଼୍‌ଦେଂ ବାବି କିତାୟ୍ । ");
INSERT INTO peg_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","ଇ ବିସ୍ରେ, ନି ବାଗ୍‌ ହିଲୁତ୍‍ କି ଆଦିକାର୍‌ ହିଲୁତ୍‌, ଇନାକିଦେଂକି ଇସ୍ୱର୍‌ତି ମୁମ୍‌ଦ ନି ମାନ୍ତ ହୁଦାର୍‌ ଆକାୟ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","ଲାଗିଂ, ନି ଇ ବାଡ଼୍‍ପାଣ୍‍ତାଂ ମାନ୍‌ବାଦ୍‌ଲାୟ୍‌ କିଜ଼ି ମାପ୍ରୁତି ତାକେ ପାର୍ତାନା କିୟା, ଇନେସ୍‌ ଆତିସ୍‌ଚି ନି ମାନ୍ତ ହାନ୍ଦାୟ୍ କିନାକା କେମା ଆଦ୍‌ନାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","ଇନାକିଦେଂକି ନି ଅଦାର୍ମି ବିସ୍ରେ ବାର୍ତି ଆଜ଼ି ପାପ୍‌ ତାକେ ଗାଚ୍ୟା ଆତାତ୍‌ନ୍ନା ଇଞ୍ଜି ଆନ୍‌ ହୁଡ଼୍‍ନାଙ୍ଗା ।” ");
INSERT INTO peg_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","ହେବେ ସିମନ୍‌ ଜହନ୍‌ ଆରି ପିତର୍‌ତିଂ ଇଚାନ୍‌, ଏନ୍‌ ଇନାକା ଇନାକା ଇଞ୍ଚାୟ୍, ହେବେତାଂ ଇମ୍‌ଣାକା ପା ବିସ୍ରେ ଇନେସ୍‌ ନା କାଜିଂ ପଡ଼ାମେତ୍, ଇଦାଂ କାଜିଂ “ଏପେଙ୍ଗ୍‌ ନା କାଜିଂ ମାପ୍ରୁତି ଲାଗେ ପାର୍ତାନା କିୟା ।” ");
INSERT INTO peg_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","ଇ ବାନି ହେୱାର୍‌ ସାକି ହିଜ଼ି ଆରି ମାପ୍ରୁତି ବଚନ୍‌ ଇଞ୍ଜି ସମିରଣିୟାର୍‌ତି ଆଦେକ୍‌ ନାସ୍‌କୁକାଂ ନେକ୍ରିକାବୁର୍‌ ସୁଣାୟ୍‌ କିଉ କିଉ ଜିରୁସାଲମ୍‌ତ ମାସ୍‌ଦି ହାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","ପାଚେ ମାପ୍ରୁତି ରୱାନ୍‌ ଦୁତ୍‌ ପିଲିପ୍‌ତିଂ ଇଚାତ୍‌, “ନିଙ୍ଗା, ବୁଜ୍‌ଣି ବାଗାଙ୍ଗ୍‌ ଇମ୍‌ଣି ହାଡ଼ାକ୍ ଜିରୁସାଲମ୍‌ତାଂ ଇଦାଂ ଗଜ୍ଜା ନିପ ହାଲ୍‌ଜି ମାନା,” ହେ ନିପ ହାଡ଼ାକ୍ତ ହାଲା । ହେଦାଂ ଚିମ୍‌ରା ବାହା ମାଚାତ୍‌ । ନେଜେୱିଗା ଚିନ୍ତା କିୟାଆଉତା । ");
INSERT INTO peg_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","ହେବେତାଂ ହେୱାନ୍‌ ନିଂଜି ହାଚାନ୍‌ । ଆରେ ହୁଡ଼ାଟ୍‌, ଇତିଓପିଆ ଦେସିୟାର୍ତି କଣ୍ଡାକି ତର୍‌ନି ରାଣିତି ତାରେନ୍‌ ରଞ୍ଜେଲ୍‌ ଗାଜା ପାଦ୍‌ ପାୟାତି ଇତିଓପିଆନି ବେଜୁ, ଇନେର୍‌ ତାଦେଲ୍‍ତି ୱିଜ଼ୁ ଦନ୍‍କଟିନି ସାସନ୍‌ କାର୍‌ୟା ମାଚାନ୍‌, ହେୱାନ୍‌ ପାର୍ତାନା କିନି କାଜିଂ ଜିରୁସାଲମ୍‌ତ ୱାଜ଼ି ମାଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","ହେୱାନ୍‌ ମାସ୍‌ଦି ହାଲୁ ହାଲୁ ଜାର୍‌ ହାଗାଡ଼୍‌ତ କୁଚ୍‌ଚି ଜିସାୟ୍‌ ବେଣ୍‌ବାକ୍‌ଣାୟ୍‌କିନାକାର୍‌ ସାସ୍ତର୍‌ ଗାଜାକାଟ୍‌ତାଂ ପଡ଼ି କିଜ଼ି ମାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","ହେୱେଡ଼ାଂ ପୁଇପୁୟା ଜିବୁନ୍‌ ପିଲିପ୍‌ତିଂ ଇଚାତ୍‌, “ଲାଗେ ହାଲ୍‌ଜି ଇ ଗାଗାଡ଼୍‌ ହୁଦାଂ ମାନା ।” ");
INSERT INTO peg_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","ହେବେ ପିଲିପ୍‌ ହଞ୍ଚିହାଲ୍‍ଜି ହେୱାନ୍‌ ଜିସାୟ୍‌ ବେଣ୍‌ବାକ୍‌ଣାୟ୍‌କିନାକାର୍‌ ସାସ୍ତର୍‌ ପଡ଼ି କିନାକା ୱେନ୍‌ଞ୍ଜି ୱେନ୍‌ବାତାନ୍‌, “ଏନ୍‌ ଇନାକା ପଡ଼ି କିନାୟା, ହେଦାଂ ଇନାକା ବୁଜାନାୟା ?” ");
INSERT INTO peg_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","ହେୱାନ୍‌ ଇଚାନ୍‌, “ଇନେର୍‌ ନାଙ୍ଗ୍‌ ବୁଜାୟ୍‌ ହିଦ୍‍ୱିତିସ୍ ଆନ୍‌ ଇନେସ୍‌ ବୁଜାଦେଂ ଆଡ୍‌ନାଂ ?” ଆରେ, ହେୱାନ୍‌ ପିଲିପ୍‌ ଦୁମ୍‌ଜି ୱାଜ଼ି ତା କଚଣ୍‌ତ କୁଚ୍‌ଚେଙ୍ଗ୍ ଗୱାରି କିତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","ସାସ୍ତର୍‌ନି ଇମ୍‌ଣି ବାଗ୍‌ ହେୱାନ୍‌ ପଡ଼ି କିଜ଼ି ମାଚାନ୍‌, ହେଦାଂ ଇଦାଂ, ହେୱାନ୍‌ ମେଣ୍ଡା ଲାକେ “ହାନି କାଜିଂ ଅୟାତାନ୍‌, ଆରେ ତଲ୍‍ ଉନ୍ଦ୍‍ନି ମୁମ୍‌ଦ ମେଣ୍ଡାହିମ୍‌ଣା ଇନେସ୍‌ ପ୍ଡକ ମାନ୍‍ଙ୍ଗାନାତ୍, ହେ ଲାକେ ହେୱାନ୍‌ ତା ମୁମ୍‌ ଜେୟା ଆୱାତାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","ହେୱାନ୍ତି ଅପ୍‌ମାନ୍‌ ଆନିହିଙ୍ଗ୍‌ ହେୱାନ୍ତି ଡାଣ୍ଡ୍‌ ମାସ୍‍ଦି ହାଚାତ୍ । ହେୱାନ୍ତି ଲାତ୍ରା ଇନେର୍‌ ହାନ୍ଦାୟ୍‌ କିଦେଙ୍ଗ୍‌ ଆଡ୍‌ନାର୍‌ ? ଇନେକିଦେଂକି ହେୱାନ୍ତି ଜିବୁନ୍‌ନି ପୁର୍ତିତାଂ ମାସ୍‌ଦି ହାଚାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","ବେଜୁ ଉତର୍‌ ହିିଜ଼ି ପିଲିପ୍‌ତିଂ ଇଚାନ୍‌, ଆନ୍‌ ନିଂ ପାର୍ତାନା କିଦ୍‍ନାଂ, “ବେଣ୍‌ବାକ୍‌ଣାୟ୍‌କିନାକାର୍‌ ଇନେର୍‌ ବିସ୍ରେ ଇ ବେରଣ୍ ଇଚାନ୍ନା ? ଜାର୍‌ ବିସ୍ରେ କି ଆରେ ଇନେର୍‌ ବିସ୍ରେ ?” ");
INSERT INTO peg_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","ହେବେ ପିଲିପ୍‌ ୱେଇ ଜେସି ସାସ୍ତର୍‌ ଇ ବଚନ୍‍ତାଂ ହାଂଜି ହେୱାନ୍‌ ତାକେ ଜିସୁତି ନେକ୍ରିକାବୁର୍‌ ପର୍‌ଚାର୍‌ କିତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","ଆରେ, “ହେୱାର୍‌ ହାସ୍‌ଦ ହାଲୁ ହାଲୁ ର ଏଜ଼ୁଂ ମାନି ଲାଗେ ଏକାତାର୍; ହେବେ ବେଜୁ ଇଚାନ୍‌,” ଇବେ ତ ଏଜ଼ୁଙ୍ଗ୍ ମାନିକ୍‌, ନା ବାପ୍ତିସିମ୍‌ ଆନି କାଜିଂ ଇନାକା ବାଦା ମାନାତ୍‌ କି ? ");
INSERT INTO peg_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","ପିଲିପିପ ଇଚାନ୍‌, ଏନ୍‌ ୱିଜ଼ୁ ୱାସ୍କି ହୁଦାଂ ଜଦି ପାର୍ତି କିନାୟ୍‌, ତା ଆତିସ୍‌ ହେବେ ହେୱାନ୍‌ ଉତର୍‌ ହିତାନ୍‌, ଜିସୁ କ୍ରିସ୍ଟ ଜେ ଇସ୍ୱର୍‌ତି ମାଜ଼ି, ଇଦାଂ ଆନ୍‌ ପାର୍ତି କିନାଙ୍ଗା । ");
INSERT INTO peg_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","ଆରେ, ହେୱାନ୍‌ ଗାଗାଡ଼୍‌ ନିଲି କିଦେଙ୍ଗ୍‌ ବଲ୍‌ ହିତାନ୍‌, ଆରେ ପିଲିପିପ ଆରି ବେଜୁ ରିୟାର୍‌ ଏଜ଼ୁଙ୍ଗ୍ ବିତ୍ରେ ଜୁଜ଼ି ହାଚାର୍‌, ଆରେ ପିଲିପ୍‌ ହେୱାନିଂ ବାପ୍ତିସିମ୍‌ ହିତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","ହେୱାର୍‌ ଏଜ଼ୁଙ୍ଗ୍ ବିତ୍ରେତାଂ ନିଂଜି ୱାଜ଼ି, ମାପ୍ରୁତି ଜିବୁନ୍‌ ପିଲିପ୍‌ତିଂ ଅଜ଼ି ହାତାତ୍‌, ଆରେ ବେଜୁ ହେୱାନିଂ ଆରେ ହୁଡ଼୍‍ୱାତାନ୍; ଆତିସ୍‌ପା ହେୱାନ୍‌ ୱାରି କିଉ କିଉ ଜାର୍‌ ହାସ୍‍ଦିଂ ହାଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","ମାତର୍‌ ପିଲିପ୍‌ ଅସ୍‌ଦଦ୍‌ ତର୍‌ନି ଗାଡ଼୍‌ଦ ଚଞ୍ଜ୍ୟା ଆତାନ୍‌, ଆରେ ହେୱାନ୍‌ ହାଲୁ ହାଲୁ ଗାଡ଼୍‌ଦ ଗାଡ଼୍‌ଦ ନେକ୍ରିକାବୁର୍‌ ସୁଣାୟ୍‌ କିଜ଼ି କାଇସରିୟା ଦେସ୍‌ତ ହାଲ୍‌ଜି ଏକାତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","ମାତର୍‌ ସାଉଲ୍‌ ଇ ପାତେକ୍‌ ପା ମାପ୍ରୁତି ଚେଲାର୍‌ ବିରୁଦ୍‌ତ ପାଣ୍ଡ୍ରୁ ଆରି ପାରାଣ୍‍ନାସ୍ କାତା ଇଞ୍ଜି ମୁଡ଼୍‌ ମାପ୍ରୁହେବାକିନାକାନ୍‌ ଲାଗେ ହାଚାନ୍‌, ");
INSERT INTO peg_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","ଆରେ, ଇ ହାଜ଼ିନି ଇମ୍‌ଣି ଆଣ୍ଡ୍ରେନ୍‌ କି କଗ୍‍ଲେକ୍ ଚଞ୍ଜ୍ୟା ଆତିସ୍‌, ହେୱାରିଂ ଇନେସ୍‌ ଗାଚ୍‌ଚି ଜିରୁସାଲମ୍‌ତ ତାତେଙ୍ଗ୍‌ ଆଡ୍‌ନାନ୍‌, ଇଦାଂ କାଜିଂ ଦମ୍ମେସକ୍‌ନି ୱିଜ଼ୁ ପାର୍ତାନା ଇଲ୍‌ ଲାଗେ ହେୱାନ୍‍ତାଂ ଆକି ଏନ୍ତାର୍ । ");
INSERT INTO peg_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","ପାଚେ ହେୱାନ୍‌ ହାଲୁ ହାଲୁ ଦମ୍ମେସକ୍‌ନି ଲାଗାୟ୍‌ ଆତିଲେ, ହାଚାଟ୍ରେ ବାଦାଡ଼୍‌ତାଂ ଅଜଡ଼୍‌ ହେୱାନ୍‌ ଚାରିବେଣ୍‍ତିଂ ତ୍ରିପ୍‍କି ନିଂତାତ୍ । ");
INSERT INTO peg_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","ହେବେ ହେୱାନ୍‌ ମେଦ୍‌ନିତ ଗୁର୍‌ଜି ହେୱାନ୍‌ କାଜିଂ ଇ କାଟ୍‌ ୱେଚାନ୍, “ଏ ସାଉଲ୍‌, ଏ ସାଉଲ୍‌, ଇନାକିଦେଂ ନାଙ୍ଗ୍‌ ନିନ୍ଦା କିଦ୍‌ନାୟା ?” ");
INSERT INTO peg_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","ହେୱାନ୍‌ ଇଚାନ୍‌, “ଏ ମାପ୍ରୁ, ଏନ୍‌ ଇମ୍‌ଣାକାୟ୍‌ ?” ଆରେ ହେୱାନ୍‌ ଇଚାନ୍‌, ଇନେରିଂ ଏନ୍‌ ନିନ୍ଦା କିଦ୍‌ନାୟା ହେୱାନ୍‌ ଆନ୍‌ ହେ ଜିସୁ ? ");
INSERT INTO peg_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","“ମାତର୍‌ ନିଙ୍ଗା, ଗାଡ଼୍‌ଦ ହଣ୍‍ଗା, ଆରେ ନିଂ ଇନାକା କିଦେଙ୍ଗ୍‌ ଆନାତ୍‌, ହେଦାଂ ୱେଚ୍‌ୟାନାତ୍ ।” ");
INSERT INTO peg_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","ଇମ୍‌ଣି ଲକୁ ହେୱାନ୍‌ ହୁକେ ହାଲ୍‍ଜି ମାଚାର୍, ହେୱାର୍‌ ହେ ଗାର୍ଜାନ୍‌ ଆନାକା ୱେନ୍‌ଞ୍ଜି ଇନେରିଂ ହୁଡ଼୍‍ୱିତିଲେ କାବା ଆଜ଼ି ନିଲ୍‌ଚି ମାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","ଆରେ, ସାଉଲ୍‌ ମେଦ୍‌ନିତାଂ ନିଙ୍ଗ୍‌ଜି ଏଚେକାଡ଼୍‌ଦ ଜାର୍‌ କାଣ୍‌କୁ ମେସ୍‍ତାନ୍, ହେ ଏଚେକାଡ଼୍‌ଦ ହେୱାନ୍‌ ମୁଡ଼େ ହୁଡ଼୍‌ଦେଂ ଆଡ୍‌ୱାତାନ୍‌ । ଲାଗିଂ ହେୱାର୍‌ ସାଉଲ୍‌ତି କେଇ ଆଜ଼ି ହେୱାନିଂ ଦମ୍ମେସକ୍‌ତ ଅତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","ଆରେ, ହେୱାନ୍‌ ତିନି ଦିନ୍‌ ପାତେକ୍‌ କାଣା ଆଜ଼ି ମାଚାନ୍‌, ଆରେ ହେ ସମୁତ ହେୱାନ୍‌ ମୁଡ଼େ ତିନ୍‍ୱାତାନ୍ କି ଉଣ୍‍ୱାତାନ୍ । ");
INSERT INTO peg_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","ଦମ୍ମେସକ୍‌ତ ହନନିୟ ତର୍‌ନି କ୍ରିସ୍ଟତି ଚେଲା ମାଚାନ୍‌, ମାପ୍ରୁ ହେୱାନିଂ ଚଞ୍ଜ୍ୟା ଆଜ଼ି ଇଚାନ୍‌, “ହନନିୟ ।” “ହେୱାନ୍‌ ଇଚାନ୍‌, ଏ ମାପ୍ରୁ, ଇଚାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","ହେବେଣ୍ଡାଂ ମାପ୍ରୁ ହେୱାନିଂ ଇଚାନ୍‌, “ନିଙ୍ଗା, ହାଣ୍‍କୁ ତର୍‌ନି ହାଜ଼ିତ ହାଲ୍‌ଜି ଜିହୁଦା ଇଞ୍ଜ ତାର୍ସ ଗାଡ଼୍‌ନି ସାଉଲ୍‌ ତର୍‌ନି ରୱାନ୍‌ ମୁଣିକାତିଂ ଆନ୍‌ମାନ୍‌ କିୟା; ହେୱାନ୍‌ ପାର୍ତାନା କିନାନା; ");
INSERT INTO peg_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","ଆରେ, ହେୱାନ୍‌ ଇନେସ୍‌ ନଂଜର୍ ଗାଟାନାନ୍, ଇଦାଂ କାଜିଂ ହନନିୟ ତର୍‌ନି ରୱାନ୍‌ ମାନାୟ୍‌ ୱାଜ଼ି ହେୱାନ୍‌ ଜପି କେଇ ହିତ୍‍ତାନ୍‌ ଇଞ୍ଜି କେଚ୍‌କଣ୍‌ ହୁଡ଼୍‌ତାନ୍‌ନ୍ନା ।” ");
INSERT INTO peg_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","ମାତର୍‌ ହନନିୟ ଉତର୍‌ ହିତାନ୍‌, “ମାପ୍ରୁ ଜିରୁସାଲମ୍‌ତ ମି ପୁଇପୁୟାର୍‌ କାଜିଂ ଇ ମାନାୟ୍‌ ଜେ ଏଚେକ୍ ବିଦ୍‌ବାଦ୍‌ କିତାନ୍‌ନ୍ନା, ହେଦାଂ ଆନ୍‌ ଆଦେକ୍‍ତାଂ ଇ ମାନାୟ୍‌ ବିସ୍ରେ ୱେଚାଙ୍ଗ୍‌ନା । ");
INSERT INTO peg_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","ଆରେ, ଇ ବାହାତ ଏଚେକ୍‍ ଲଗୁ ନି ତର୍‌ଦ ପାର୍ତାନା କିନାରା, ହେୱାରିଂ ଗାଚ୍‍ନି କାଜିଂ ହେୱାନ୍‌ ମୁଡ଼୍‌ ମାପ୍ରୁହେବାକିନାକାନ୍‌ ତାରେନ୍‌ତାଂ ଆଦିକାର୍‌ ଗାଟାତାନ୍ନା ।” ");
INSERT INTO peg_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","ମାତର୍‌ ମାପ୍ରୁ ହେୱାନିଂ ଇଚାନ୍‌, “ହାଲା, ଇନାକିଦେଂକି ହେୱାନ୍‌ ପାର୍ତିକିୱି ଜିହୁଦି, ରାଜା ଆରି ୱିଜ଼ାର୍‌ ଇସ୍ରାଏଲ୍‌ନି ହିମ୍‌ଣାଂ ମୁମ୍‌ଦ ମା ତର୍‌ ପିଣ୍ତିନି କାଜିଂ ମା ରୱାନ୍‌ ବାଚିକିତି ଲଗୁ; ");
INSERT INTO peg_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","ଲାଗିଂ ନା ତର୍‌ କାଜିଂ ହେୱାନିଂ ଜେ ବେସି ଦୁକ୍‌ ବଗ୍‌ କିଦେଙ୍ଗ୍‌ ଆନାତ୍‌, ହେଦାଂ ଆନ୍‌ ନିଜେ ତାଙ୍ଗ୍‌ ୱେଚ୍‌ନାଙ୍ଗ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","ହେବେଣ୍ଡାଂ ହନନିୟ ହାଲ୍‌ଜି ହେ ଇଞ୍ଜ ହଣ୍‍ଗାତାନ୍, ଆରେ ହେୱାନ୍ତି ଜପି କେଇ ହିଜ଼ି ଇଚାନ୍‌, “ସାଉଲ୍‌ ଟଣ୍ଡେନ୍‌,” ମାପ୍ରୁ, ଇଚିସ୍‌ ଇମ୍‌ଣି ଜିସୁ ନି ୱାନି ହାସ୍‌ଦ ନିଂ ଚଞ୍ଜ୍ୟାତାନ୍, ଏନ୍‌ ଇନେସ୍‌ ହୁଡ଼୍‌ଦେଂ ଆଡ୍‌ନାୟ୍‌ ଆରି ପୁଇପୁୟା ଜିବୁନ୍‌ତ ପୁରା ଆ, ଇଦାଂ କାଜିଂ ହେୱାନ୍‌ ନାଙ୍ଗ୍‌ ପକ୍ତାତାନ୍ନା । ");
INSERT INTO peg_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","ହେ ଦାପ୍ରେ ସାଉଲ୍‌ତି କାଣ୍‍ଗାତାଂ ମିନ୍‌ ପାଡ଼ିଂ ଲାକେ ଇନାକା ହତ୍‍ତାତ୍ ଆରି ହେୱାନ୍‌ ହୁଡ଼୍‌ତାନ୍‌; ଆରେ, ହେୱାନ୍‌ ନିଙ୍ଗ୍‌ଜି ବାପ୍ତିସିମ୍‌ ଅତାନ୍‌, ");
INSERT INTO peg_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","ଆରେ ହେୱାନ୍‌ ତିନ୍‌ଞ୍ଜି ବାଡ଼୍‍କାସ୍‌ ଆତାନ୍‌ । ଇଦାଂ ପାଚେ ହେୱାନ୍‌ ଦମ୍ମେସକ୍‌ତ ମାନି ଚେଲାର୍‌ ହୁକେ କେତେକ୍‌ ଦିନ୍‌ ମାଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","ଆରେ, ଜିସୁ ଜେ ଇସ୍ୱର୍‌ତି ମାଜ଼ି, ଇଦାଂ ହେୱାନ୍‌ ମାଲାୱାଦାଂ କୁଟୁମ୍‌ ଇଞ୍ଜ ଲାଗାଂ ସୁଣାୟ୍‌ କିଦେଙ୍ଗ୍‌ ଲାଗାତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","ଆରେ, ଇମ୍‌ଣାକାର୍‌ ହେୱାନ୍ତି କାତା ୱେଚାର୍‌, ହେୱାର୍‌ ୱିଜ଼ାକାର୍‌ କାବା ଆଜ଼ି ଇଞ୍ଜେଙ୍ଗ୍‌ ଲାଗାତାର୍‌, ଇ ତର୍‌ ଆଜ଼ି ପାର୍ତାନା କିନି ମାନାୟାର୍‌ତିଂ ଜେ “ଜିରୁସାଲମ୍‌ତ ଦାଣ୍ଡ୍‌ ହିଜ଼ି ମାଚାନ୍‌, ଆରେ ଇନେସ୍‌ ହେୱାରିଂ ଗାଚ୍‌ଚି ମୁଡ଼୍‌ ମାପ୍ରୁହେବାକିନାକାନ୍‌ ଲାଗେ ଅଦେଂ ଆଡ୍‌ନାନ୍‌, ହେ କାମାୟ୍‍ତିଂ ଇ ବାହାତ ୱାଜ଼ି ମାଚାନ୍‌, ଇୱାନ୍‌ କି ହେୱାନ୍‌ ଆକାୟ୍‌ ?” ");
INSERT INTO peg_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","ମାତର୍‌ ସାଉଲ୍‌ ବେସି ହଟ୍‌ ସାକ୍ତିତାଂ ନିଙ୍ଗ୍‍ତାନ୍, ଆରେ ଇୱାନ୍‌ ଜେ କ୍ରିସ୍ଟ, ଇଦାଂ ପାର୍ମାଣ୍‌ କିଜ଼ି ଦମ୍ମେସକ୍‌ ନିକାରିଂ ଜିହୁଦିରିଂ ଉତର୍‌ ହିଦେଂ ଆଡ୍‌ୱାତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","ବେସି ଦିନ୍‌ ହାଚି ପାଚେ ଜିହୁଦିର୍‌ ସାଉଲ୍‌ତିଂ ଅହ୍‌ନି କାଜିଂ ହୁତୁର୍‌ କିତାର୍‌; ");
INSERT INTO peg_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","ଆତାର୍‌ ହେୱାର୍‌ତି ଗାଣ୍‌ଜୁ ସାଉଲ୍‌ତି କିତୁଲ୍‍ତ ୱାତାତ୍ । ଆରେ, ହେୱାର୍‌ ଇନେସ୍‌ ତାଙ୍ଗ୍‌ ଅସ୍ତେଙ୍ଗ୍‌ ଆଡ୍‌ନାର୍‌, ଇଦାଂ କାଜିଂ ୱେଡ଼ାନାଣା ପା ଗାଡ଼୍‌ନି ଦୁୱେର୍‌ତ ସବୁ କାସି ମାନ୍‍ବାତାର୍, ");
INSERT INTO peg_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","ମାତର୍‌ ହେୱାନ୍ତି ଚେଲାର୍‌ ନାଣାଲିଂ ତାଙ୍ଗ୍‌ ଅଜ଼ି ର ଟପାତ କୁୱାଡ଼୍‌ ହିଜ଼ି ତାରେନ୍‌ ଜୁତ୍‍ତାର୍ । ");
INSERT INTO peg_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","ପାଚେ ହେୱାନ୍‌ ଜିରୁସାଲମ୍‌ତ ହାଲ୍‌ଜି ଚେଲାର୍‌ ହୁକେ ମିହାଦେଂ ସେସ୍ଟା କିଜ଼ି ମାଚାନ୍‌; ମତର୍‌ ହେୱାନ୍‌ ଜେ ରୱାନ୍‌ ଚେଲା, ଇଦାଂ ପାର୍ତି କିୱାଦାଂ ୱିଜ଼ାକାର୍‌ ତାଙ୍ଗ୍‌ ପାଣ୍ଡ୍ରାଜ଼ି ମାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","ମାତର୍‌ ବର୍ଣ୍ଣବା ତାଙ୍ଗ୍‌ ରଚେ ଅଜ଼ି ପକ୍ୟାତାକାର୍‌ତି ଲାଗେ ତାହିୱାତାନ୍‌, ଆରେ ହାସ୍‌ଦ ହେୱାନ୍‌ ଇନେସ୍‌ ମାପ୍ରୁତି ଚଞ୍ଜ୍ୟାତାକା ଆରି ହେୱାନ୍‌ ଜେ ହେୱାନ୍‌ ହୁକେ କାତାବାର୍ତା କିଜ଼ି ମାଚାନ୍‌, ଆରେ ଇନେସ୍‌ବାନି ହେୱାନ୍‌ ଦମ୍ମେସକ୍‌ତ ଜିସୁତି ତର୍‌ଦ ସାସ୍‌ତାଂ ପର୍‌ଚାର୍‌ କିଜ଼ି ମାଚାନ୍‌, ଇ ସବୁ ହେୱାନ୍‌ ହେୱାର୍‌ତି ଲାଗେ ବାକ୍‌ଣାୟ୍‌ କିତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","ଆରେ, ସାଉଲ୍‌ ପକ୍ୟାତାକାର୍‌ ଲାହାଂ ମାଚାନ୍‌ ଆରି ୱିଜ଼ୁ ଜିରୁସାଲମ୍‌ତ ଚାର୍‌ବେଣ୍‌ତାଂ ହାଲ୍‌ଜି ସାସ୍‌ ଲାହାଂ ମାପ୍ରୁତି ତର୍‌ ବିସ୍ରେ ପର୍‌ଚାର୍‌ କିତାର୍‌ ");
INSERT INTO peg_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","ମାପ୍ରୁତି ତର୍‌ ସାସ୍‌ ହୁକେ ପର୍‌ଚାର୍‌ କିଦେଙ୍ଗ୍‌ ଲାଗାତାନ୍‌, ଆରେ ହେୱାନ୍‌ ଗ୍ରିକ୍‌ ବେଣ୍‍ନିକାର୍ ଜିହୁଦିର୍‌ ହୁକେ କାତାବାର୍ତା ଆରି ବେଣ୍‍ବାଟ୍ କିଜ଼ି ମାଚାନ୍‌, ମତର୍‌ ହେୱାର୍‌ ତାଙ୍ଗ୍‌ ଅସ୍ତେଙ୍ଗ୍‌ କାଜିଂ ସେସ୍ଟା କିଦେଙ୍ଗ୍‌ ଲାଗାତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","ହେଦାଂ ପୁଞ୍ଜେଙ୍ଗ୍‌ ଆଡ଼୍‍ତିଲେ ପାର୍ତି କିନି ଟଣ୍ଡାର୍‌ ତାଙ୍ଗ୍‌ କାଇସରିୟାତ ଅଜ଼ି ହାଲ୍‌ଜି ତାର୍ସତ ପକ୍‍ଚିତୁହିତାର୍ । ");
INSERT INTO peg_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","ଇ ବାନି ସାର୍ତେ ଜିହୁଦା ରାଜିତ, ଗାଲିଲି ଆରି ସମିରଣ୍‌ତ ମଣ୍ଡ୍‌ଲି ସାସ୍‌ନି ବାଲ୍‍ବଲାୟ୍‌ ପାୟାଜ଼ି ଆରି ମାପ୍ରୁତି ପାଣ୍ଡ୍ରୁତ ବେବାର୍‍ କିଜ଼ି ସୁସ୍ତା ବଗି କିତାର୍, ଆରେ ପୁଇପୁୟା ଜିବୁନ୍‌ ଉପ୍‍କାର୍‍ତାଂ ବାଡାଦେଂ ଲାଗାତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","ନଙ୍ଗ୍‌ ପିତର୍‌ ସବୁ ନିପ ବୁଲାଆଜ଼ି ଲୁଦନିକାର୍‍ ପୁଇପୁୟାର୍‌ ଲାଗେ ପା ୱାତାର୍ । ");
INSERT INTO peg_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","ହେ ବାହାତ ହେୱାନ୍‌ ଏନିୟ ତର୍‌ନି ରୱାନିଂ ହୁଡ଼୍‌ତାନ୍‌, ହେୱାନ୍‌ ଆଟ୍‌ ବାର୍ହୁ ପାତେକ୍‌ କାଟେଲ୍‌ତ ହୁଞ୍ଜି ମାଚାନ୍‌; ତାଙ୍ଗ୍‌ ହିର୍‍କଲ୍‍ ଆଜ଼ି ମାଚାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","ପିତର୍‌ ହେୱାନିଂ ଇଚାନ୍‌, “ଏନିୟ, ଜିସୁ କ୍ରିସ୍ଟ ନିଂ ଉଜ୍‌ କିତ୍‌ତାନ୍‌ନା; ନିଙ୍ଗା, ନି ଟାଟି ଜାଲ୍‌ଦି କିୟା । ହେବେ ହେୱାନ୍‌ ଦାପ୍ରେ ନିଙ୍ଗ୍‍ତାନ୍ ।” ");
INSERT INTO peg_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","ଆରେ, ଲୁଦ ଆରି ସାରଣନିକାର୍ ୱିଜ଼ାର୍‌ ତାଙ୍ଗ୍‌ ହୁଡ଼୍‌ଜି ମାପ୍ରୁନିପ ଲେଉଟାତାର୍ । ");
INSERT INTO peg_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","ଜାପତ ଟାବିତା ତର୍‌ନି ରଞ୍ଜେଲ୍‌ ଆଡ଼୍‌ୟାଣି ମାଚାତ୍‌, ତାଦାଂ ଗ୍ରିକ୍‌ ତର୍‌ ଅରତ୍‌ ଦର୍କା । ଇଚିସ୍‌ “ହରିଣି” ମାଚାତ୍‌, ହେଦେଲ୍‌ ତା ସବୁ ସମୁ ହାର୍‌ଦି କାମାୟ୍‌ତ ଆରି ହିଲ୍‌ୱାକାରିଂ ହେବା କିଜ଼ି ମାଚାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","ହେୱେଡ଼ାଲିଂ ହେଦେଲ୍‌ ବେମାର୍‌ ଆଜ଼ି ପାରାଣ୍‌ ପିସ୍ତାତ୍, ହେବେ ହେୱାର୍‌ ତାଙ୍ଗ୍‌ ଇତ୍‍ପିସ୍‌ ଜପ୍‍ଣି ବାକ୍ରାତ ହୁଚ୍‍ପାତାର୍ । ");
INSERT INTO peg_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","ଆରେ, ଲୁଦ ଜାପନି ଲାଗେ ମାଚିଲେ ଚେଲାର୍‌ ପିତର୍‌ ଲୁଦତ ମାନାନ୍‌ ଇଞ୍ଜି ୱେନ୍‌ଞ୍ଜି, “ରିୟାର୍‌ ମାନାୟ୍‍ତିଂ ହେୱାନ୍‌ ଲାଗେ ପକ୍‌ଚି ଇଦାଂ ଗୱାରି କିତାର୍‌, ମା ଲାଗେ ବେଗି ୱା ।” ");
INSERT INTO peg_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","ଲାଗିଂ ପିତର୍‌ ନିଙ୍ଗ୍‌ଜି ହେୱାର୍‌ ହୁକେ ହାଚାନ୍‌ । ହେୱାନ୍‌ ୱାତିଲେ, ହେୱାର୍‌ ହେଦେଲିଂ ହେ ଜପ୍‍ଣି ବାକ୍ରାତ ଅଜ଼ି ହାଚାର୍‌, ଆରେ ରାଣ୍ଡିକ୍‌ ୱିଜ଼େକିକ୍‍ ତାଙ୍ଗ୍‌ ହେଦେଲିଂ ବେଡ଼ି କିଜ଼ି ଆଡ଼୍‌ବିସ୍‌ ଆଡ଼୍‌ବିସ୍‌ ଦର୍କା ହେୱାର୍‌ ହୁକେ ମାନି ୱେଡ଼ାଲିଂ ଇମ୍‌ଣି ସବୁ ଆଙ୍ଗି ଆରି ହେନ୍ଦ୍ରାଙ୍ଗ୍‌ ରଚ୍‌ଚି ମାଚାର୍‌, ହେ ସବୁ ଚଚ୍‍ଚେଂ ଲାଗିତିକ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","ମାତର୍‌, ପିତର୍‌ ୱିଜ଼ାରିଂ ହପ୍‍ଚି ମେଣ୍ଡାଙ୍ଗ୍‌ କୁନ୍ଦିକିଜ଼ି ପାର୍ତାନା କିତାନ୍‌, ଆରେ ହାତି ଗାଗାଡ଼୍‌ ନିପ ମାସ୍‌ଦି ଇଚାନ୍‌, “ଟାବିତା, ନିଙ୍ଗା ।” ହେବେ ହେଦେଲ୍‌ କାଣ୍‌କୁ ମେଲା କିତାତ୍‌, ଆରେ ପିତର୍‌ତିଂ ହୁଡ଼୍‌ଜି ନିଂଜି କୁଚ୍‍ଚାତ୍ । ");
INSERT INTO peg_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","ଆରେ, ହେୱାନ୍‌ କେଇ ଲାମାୟ୍‌ କିଜ଼ି ହେଦେଲିଂ ନିକ୍‌ତାନ୍‌ ଆରି ସାଦୁରିଂ ଆରି ରାଣ୍ଡିକାଂ କୁକ୍‌ଚି ହେଦେଲିଂ ଜିଜ଼ି ମାନାକା ଚଚ୍‌ଚାନ୍ ");
INSERT INTO peg_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","ଇ କାତା ଜାପତ ସବୁନିପ ଜାଣାତାତ୍ ଆରି ଆଦେକ୍‌ ମାପ୍ରୁ ତାକେ ପାର୍ତି କିତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","ଆରେ, ପିତର୍‌ ବେସି ଦିନ୍‌ ଜାପତ ସିମନ୍‌ ତର୍‌ନି ରୱାନ୍‌ ତଲ୍‌ ରଚ୍‌ନାକାନ୍‌ ଇଞ୍ଜ ବାହା କିତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","କାଇସରିୟା ଲକ୍‌ କର୍ଣ୍ଣଲିୟ ତର୍‌ନି ରୱାନ୍‌ ମୁଣିକା ମାଚାନ୍‌, ହେୱାନ୍‌ “ଇତାଲିକ ତର୍‌ନି ମେଲ୍ୟାର୍ତି ରୱାନ୍‌ ପାଞ୍ଚ୍‌କଡ଼ି ମୁଡ଼୍‍ମେଲ୍ୟାର୍ ମାଚାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","ହେୱାନ୍‌ ରୱାନ୍‌ ହୁଦାର୍, ଆରେ ଇଞ୍ଜିବାହାଁୟ୍‌ ଇସ୍ୱର୍‌ତିଂ ପାଣ୍ଡ୍ରାଜ଼ି ମାଚାର୍‌ । ହେୱାନ୍‌ ଜିହୁଦି ଗରିବରିଂ ବେସି ଦାନ୍‌ ହିଜ଼ି ମାଚାନ୍‌, ଆରେ ତାଇନାତ୍‌ ଇସ୍ୱର୍‌ତି ଲାଗେ ପାର୍ତାନା କିଜ଼ି ମାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","ଦିନେକ୍‌ ମିକାହାରେସ୍‌ ତିନ୍‌ ଗଣ୍ଟା ୱେଡ଼ାଲିଂ ହେୱାନ୍‌ ହାତ୍‍ପା ରଚେ ର କେଚ୍‌କଣ୍‌ ହୁଡ଼୍‌ତାନ୍, ଇନେସ୍‌ ଇସ୍ୱର୍‌ତି ରଞ୍ଜେଲ୍‌ ଦୁତ୍‌ ହେୱାନ୍‌ ଲାଗେ ୱାଜ଼ି ଇନାତା, “ଏ କର୍ଣ୍ଣଲିୟ ।” ");
INSERT INTO peg_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","ହେୱାନ୍‌ ବାଦାଡ଼୍‌ତ ଦୁତ୍‌ ହୁଡ଼୍‌ଜି ପାଣ୍ଡ୍ରାଜ଼ି ଇଚାନ୍‌, “ଏ ମାପ୍ରୁ, ଇନାକା ?” ହେୱାନ୍‌ ହେୱାନିଂ ଇଚାନ୍‌, ନି ପାର୍ତାନା ଆରି ଦାନ୍‌ ସବୁ ଏତ୍‌ କିଜ଼ି ପୁଜା ଲାକେ ଜପି ଇସ୍ୱର୍‌ତି ଲାଗେ ନିଂତାତ୍‍ନା । ");
INSERT INTO peg_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","ନଙ୍ଗ୍‌ ଏନ୍‌ ଜାପତ ମାନାୟ୍‌ ପକ୍‌ଚି ସିମନ୍‌ ପିତର୍‌ତିଂ କୁକ୍‌ଚି ତାହିୱା, ହେୱାନ୍ତି ବିନ୍‌ ତର୍‌ ପିତର୍‌, ");
INSERT INTO peg_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","ହେୱାନ୍‌ ସିମନ୍‌ ତର୍‌ନି ରୱାନ୍‌ ତଲ୍‌ ରଚ୍‌ନାକାନ୍‌ ଗତେନ୍‌ ଲାକେ ବାହା କିନାନା, ହେୱାନ୍ତି ଇଲ୍‌ ହାମ୍‌ଦୁର୍‌ ଗୁଟିତ । ");
INSERT INTO peg_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","ହେୱାନ୍‌ ହୁଦାଂ ବେଣ୍‌ ଇଞ୍ଜି ମାଚି ଦୁତ୍‌ ହାଚି ପାଚେ ହେୱାନ୍‌ ଜାର୍‌ ଇଲ୍‌ନି ଆଡ଼୍‌ୟାର୍‌ ବିତ୍ରେ ରିୟାରିଂ, ଆରେ ହେୱାନ୍ତି ହେବା କିଜ଼ିମାନି ମେଲ୍ୟାର୍‌ ବିତ୍ରେ ରୱାନ୍‌ ଦାର୍ମି ମେଲ୍ୟାଙ୍ଗ୍ କୁକ୍‌ତାନ୍‌, ");
INSERT INTO peg_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","ଆରେ ହେୱାରିଂ ୱିଜ଼ୁ କାତା ବୁଜାୟ୍‌ କିଜ଼ି ଜାପତ ପକ୍‌ତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","ଆର୍କାତ୍‌ ନାଜିଂ ହାଲୁ ହାଲୁ ଏଚେକାଡ଼୍‌ଦ ଗାଡ଼୍‌ନି ଲାଗେ ଆତାର୍‌, ହେପାଦ୍‌ନା ପିତର୍‌ ୱେଡ଼ା ବାର୍‌ ଗଣ୍ଟା ୱେଡ଼ାଲିଂ ପାର୍ତାନା କିନି କାଜିଂ ଜେଗନ୍‌ ଜପି ହାଚାନ୍‌, ");
INSERT INTO peg_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","ଆରେ ହେୱାନ୍‌ ନାସ୍‌କି ଆଜ଼ି ଚିଞ୍ଜେଙ୍ଗ୍‌ ମାନ୍‌ କିତାନ୍‌, ମତର୍‌ ହେୱାର୍‌ କାଦି ଜାଲ୍‌ଦି କିନି ୱେଡ଼ାଲିଂ ହେୱାନ୍‌ କେଚ୍‌କଣ୍‌ ହୁଡ଼୍‌ତାନ୍‌; ");
INSERT INTO peg_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","ହେୱାନ୍‌ ହୁଡ଼୍‌ତାନ୍‌ ବାଦାଡ଼୍‌ତ ଜେୟାତାତ୍‍ନ୍ନା, ଆରେ ର ତାଡ଼ିୟା ତାରେନ୍‌ ୱାନାତା, ଇନେସ୍‌ ର ଗାଜା ହେନ୍ଦ୍ରା ଚାରି କନାତ ଆହ୍‌ୟା ଆଜ଼ି ପୁର୍ତି ଜପି ଜୁତ୍‍ୟାଦ୍ନାତା; ");
INSERT INTO peg_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","ହେବେ ପୁର୍ତିନି ସବୁବାନି ଚାର୍‌ ଗଡ଼ିଆ ଜାତ୍‌କୁ, ରାଙ୍ଗାନିକିଂ ଆରି ବାଦାଡ଼୍‌ନି ପଟିଙ୍ଗ୍‌ ମାନିଙ୍ଗ୍ । ");
INSERT INTO peg_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","ଆରେ, ହେୱାନ୍‌ କାଜିଂ ଇ କାତା ଆତାତ୍‌, “ଏ ପିତର୍‌, ନିଙ୍ଗା, ପାଗ୍‍ଜି ତିନା ।” ");
INSERT INTO peg_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","ମାତର୍‌ ପିତର୍‌ ଇଚାନ୍‌, “ଆକାୟ୍‌, ମାପ୍ରୁ, ଆନ୍‌ ଇନାୱାଡ଼ାଂ ପା ଇମ୍‌ଣି ପୁଇପୁୟା ହିଲ୍‌ୱାକା ଆରି ରାଡ଼ା ଆତାକା ଜିନିସ୍‌ତିଂ ତିନ୍‍ୱାତାଂନ୍ନା ।” ");
INSERT INTO peg_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","ଆରେ ରିହା ହେୱାନ୍‌ କାଜିଂ ଇ କାତା ଆତାତ୍‌, “ଇସ୍ୱର୍‌ ଇନାକା ସକଟ୍‌ କିତାନ୍‌ନ୍ନା, ହେଦାଂ ଏନ୍‌ ବିଟାଡ଼୍‌ ଇଞ୍ଜି ଇନ୍‌ମା ।” ");
INSERT INTO peg_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","ଇ ବାନି ତିନ୍‌ହଟ୍‌ ଆତାତ୍‌, ଆରେ ହେ ଦାପ୍ରେ ହେଦାଂ ଉଲ୍‌ଟି ବାଦାଡ଼୍‌ତ ନିକ୍‍ଚି ଅୟାତାତ୍ । ");
INSERT INTO peg_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","ପିତର୍‌ ଇମ୍‌ଣି ଦର୍ସନ୍ ଗାଟାଜ଼ି ମାଚାନ୍‌, ହେବେନି ଅରତ୍‌ ଇନାକା, ହେଦାଂ ବାବି କିଜ଼ି ବୁଦିବାମ୍‍ଡା ଆନି ୱେଡ଼ାଲିଂ, ହୁଡ଼ାଟ୍‌, କର୍ଣ୍ଣଲିୟତି ପକ୍ୟାତି ଲକୁ ସିମନ୍‌ତି ଇଲ୍‌ ଡେକ୍‌ଚି ଦୁୱେର୍‌ ଲାଗେ ନିଲ୍‌ଚି ମାଚାନ୍‌, ");
INSERT INTO peg_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","ହେଦାଂ କୁକ୍‌ଚି ହେୱାର୍‌ ୱେନ୍‍ବାତାର୍ ପିତର୍‌ କୁକ୍‌ନି ତର୍‌ “ସିମନ୍‌ ହେବେ ଗତେନ୍‌ ଲାକେ ବାହା କିନାନା କି ଆକାୟ୍‌ ?” ");
INSERT INTO peg_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","ପିତର୍‌ ହେ କେଚ୍‌କଣ୍‌ ବିସ୍ରେ ବାବି କିନି ୱେଡ଼ାଲିଂ ପୁଇପୁୟା ଜିବୁନ୍‌ ତାଙ୍ଗ୍‌ ଇଚାତ୍‌, “ହୁଡ଼ା, ତିନ୍‌ ଜାଣ୍‌ ଲକୁ ନିଂ ଡେକ୍‍ତାନାରା । ");
INSERT INTO peg_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","ନିଙ୍ଗା ଜାଲ୍‌ଦି ଆଜ଼ି ତାରେନ୍‌ ହାଲା ଆରି ହେୱାର୍‌ ଲାହାଂ ହାଜେଙ୍ଗ୍‌ ଚିନ୍ତା କିମା, ଇନାକିଦେଂକି ଆନ୍‌ ହେୱାରିଂ ପକ୍ତାତାଂନା ।” ");
INSERT INTO peg_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","ହେବେ ପିତର୍‌ ହେ ମାନାୟାର୍‌ ଲାଗେ ହାଲ୍‌ଜି ଇଚାନ୍‌, ହୁଡ଼ାଟ୍‌, ଏପେଙ୍ଗ୍‌ ଇନେରିଂ ଡେକ୍‌ନାଦେରା, “ଆନ୍‌ ହେୱେନ୍‌ । ଏପେଙ୍ଗ୍‌ ଇନା ଲଡ଼ାତିଂ ୱାତାଦେର୍ଣ୍ଣା ?” ");
INSERT INTO peg_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","ହେୱାର୍‌ ଇଚାର୍‌, “କର୍ଣ୍ଣଲିୟ ତର୍‌ନି ରୱାନ୍‌ ପାଞ୍ଚ୍‌କଡ଼ି ମେଲ୍ୟାର୍‌ ମୁଡ଼୍‍ଦାକାନ୍, ହେୱାନ୍‌ ଦାର୍ମି ଲଗୁ ଆରି ଇସ୍ୱର୍‌ତିଂ ପାଣ୍ଡ୍ରା ଆନାକାନ୍‌, ଆରେ ୱିଜ଼ୁ ଜିହୁଦି ଜାତିର୍‍ ଲାଗେ ଡାକ୍‍ପୁଟାଲଗୁ ହେୱାନ୍‌ ଜାର୍‌ ଇଞ୍ଜ ନିଂ କୁକିକିଦେଂ ପକ୍‌ଚି ନି ତାଙ୍ଗ୍‌ ସାକି କାତା କାଜିଂ ପୁଇପୁୟା ଦୁତ୍‌ ହୁଦାଂ ସିଦାବଲ୍ ଗାଟାତାନ୍ନା ।” ");
INSERT INTO peg_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","ହେବେ ହେୱାନ୍‌ ହେୱାରିଂ ବିତ୍ରେ କୁକ୍‌ଚି ଅଜ଼ି ହେୱାରିଂ ହେବା କିତାନ୍‌ । ତା ଆର୍କାତ୍‌ ନାଜିଂ ହେୱାନ୍‌ ନିଂଜି ହେୱାର୍‌ ହୁକେ ହାଚାନ୍‌, ଆରେ ଜାପତ ନି ପାର୍ତି କିନି ଟଣ୍ଡାର୍‌ ବିତ୍ରେ କେତେକ୍‌ ଜାଣ୍‌ ହେୱାନ୍‌ ହୁଦାଂ ହାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","ଆର୍କାତ୍‌ ନାଜିଂ ହେୱାର୍‌ କାଇସରିୟାତ ହଟାର୍, ଆରେ, କର୍ଣ୍ଣଲିୟ ଜାର୍‌ ୱାସ୍କି ଆରି ଲାଗେନି ହାଙ୍ଗ୍‌ଦାକାରିଂ କୁକ୍‌ଚି ରୁଣ୍ଡାୟ୍‌ କିଜ଼ି ହେୱାରିଂ କାସି ମାଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","ପିତର୍‌ ହଟିଲେ କର୍ଣ୍ଣଲିୟ ହେୱାନିଂ ଗିଟାଜ଼ି ସାରାଣ୍ ତାରେନ୍‌ ଆର୍ଜି ହେୱାନିଂ ଜୱାର୍‌ କିତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","ମାତର୍‌ ପିତର୍‌ ହେୱାନିଂ ନିକ୍‌ଚି ଇଚାନ୍‌, “ନିଲା ଆନ୍‌ ପା ରୱାଙ୍ଗ୍‌ ମାନାୟ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","ହେବେ ହେୱାନ୍‌ ହେୱାନ୍ତି ହୁଦାଂ କାତା କିଉ କିଉ ବିତ୍ରେ ହାଲ୍‌ଜି ହୁଡ଼୍‌ତାନ୍‌, ଜବର୍‌ ଲକୁ ରୁଣ୍ଡା ଆତାର୍ଣ୍ଣା, ");
INSERT INTO peg_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","ଆରେ ହେୱାନ୍‌ ହେୱାରିଂ ଇଚାନ୍‌, ବିନ୍‌ ଜାତିନି ଇମ୍‌ଣି ଲକୁ ହାଙ୍ଗ୍‌ ମେହାନାକା ନଲେ ତା ଲାଗେ ବାନ୍ୟା ଜିହୁଦି ମାନାୟ୍‌ ପାକ୍ୟାତ ଇନେସ୍‌ ବିଦି ହିଲୁତ୍‌, ହେଦାଂ “ଏପେଙ୍ଗ୍‌ ପୁଚାଦେର୍ଣ୍ଣା; ଆତିସ୍‌ପା ଇମ୍‌ଣି ଲକୁରିଂ ରାଡ଼ା କି ସକଟ୍‍ ଆକାୟ୍‌ ଇଞ୍ଜି ଇନ୍‍ୱି କାଜିଂ ଇସ୍ୱର୍‌ ନାଙ୍ଗ୍‌ ଚଚ୍‍ଚାତାନ୍ନା । ");
INSERT INTO peg_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","ହେଦାଂ କାଜିଂ ନାଙ୍ଗ୍‌ କୁକ୍‍ତାତାନ୍ନା ଆନ୍‌ ପା ଆପତି କିୱାଦାଂ ୱାତାଂ । ଲାଗିଂ ଆନ୍‌ ୱେନ୍‌ବାଆଦ୍‍ନାଂ, ଇନାକିଦେଂ ଏପେଙ୍ଗ୍‌ ନାଙ୍ଗେଙ୍ଗ୍ କୁକିକିତାଦେର୍ଣ୍ଣା ?” ");
INSERT INTO peg_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","କର୍ଣ୍ଣଲିୟ ଇଚାନ୍‌, “ତିନି ଦିନ୍‌ ଆଗେ ସମାନ୍‌ ଇ ୱେଡ଼ାଲିଂ ଆନ୍‌ ଜାର୍‌ ଇଞ୍ଜ ମିକାହାରେସ୍‌ ତିନ୍‌ ଗଣ୍ଟା ୱେଡ଼ାଲିଂ ପାର୍ତାନା କିଜ଼ି ମାଚାଙ୍ଗ୍; ତ୍ରିପ୍‌କୁ, ଡ଼ିଞ୍ଜ୍‍ନି ହେନ୍ଦ୍ରା ଉସ୍ପାତାକାନ୍ ରୱାନ୍‌ ମୁଣିକା ନା ମୁମ୍‌ଦ ଇଞ୍ଜ ଇଚାନ୍, ");
INSERT INTO peg_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","କର୍ଣ୍ଣଲିୟ, ନି ପାର୍ତାନା ୱେନ୍ୟା ଆତାତ୍‌ନ୍ନା; ଆରେ, ନି ଦାନ୍‌ ସବୁ ଇସ୍ୱର୍‌ତି ମୁମ୍‌ଦ ଏତାୟ୍‌ କିୟାତାତ୍‍ନ୍ନା । ");
INSERT INTO peg_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","ଲାଗିଂ, ଜାପତ ଲକୁ ପକ୍‌ଚି ପିତର୍‌ ତର୍‌ନି କୁକ୍‌ନି ସିମନ୍‌ ଲାଗାଂ କୁକ୍‌ଚି ତାହିୱା, ହେୱାନ୍‌ ହାମ୍‌ଦୁର୍‌ ଗୁଟିତ ସିମନ୍‌ ତଲ୍‌ ରଚ୍‌ନାକାନ୍‌ ଇଞ୍ଜ ଗତେନ୍‌ ଲାକେ ବାହା କିତାନ୍‌ନା । ");
INSERT INTO peg_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","ଇଦାଂ କାଜିଂ ଆନ୍‌ ମାଲାୟ୍‍ କିୱାଦାଂ ନି ତାକେ ଲକୁ ପକ୍ତାତାଂ, ଆରେ ଏନ୍‌ ଜେ ୱାତାୟ୍‍ନା, ହାର୍‌ କିତାୟ୍‌ନା । ଲାଗିଂ, ମାପ୍ରୁ ନିଂ ଇନାକା ସବୁ ବଲ୍‌ ହିତ୍‍ତାନ୍ନା, ହେଦାଂ ୱେଞ୍ଜେଙ୍ଗ୍‌ କାଜିଂ ଆପେଂ ୱିଜ଼ାପ୍ ଇସ୍ୱର୍‌ତି ମୁମ୍‌ଦ ଏକାୱାତାପ୍ନା ।” ");
INSERT INTO peg_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","“ହେବେ ପିତର୍‌ ମୁମ୍‌ ରିକ୍‌ଚି ଇଚାନ୍‌, ହାତ୍‌ପାନେ ଇସ୍ୱର୍‌ ଜେ ମୁକ୍‍ମେଟ୍ କିଉନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","ମତର୍‌ ୱିଜ଼େ ଜାତିତ ଜେ ଇନେର୍‌ ହେୱାନିଂ ପାଣ୍ଡ୍ରାଜ଼ି ଦାରୁମ୍ କାମାୟ୍‌ କିତାର୍‌, ହେୱାନ୍‌ ଜେ ହେୱାନ୍ତି ଲାଗେ ଇଟ୍ୟାନାର୍, ଇଦାଂ ଆନ୍‌ ସତ୍‌ କାମାୟ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","ହେୱାନ୍‌ତ ଜିସୁ କ୍ରିସ୍ଟତି ହୁକେ ସୁସ୍ତାନି ନେକ୍ରିକାବୁର୍‌ ପର୍‌ଚାର୍‌କିଇ କିଜ଼ି ଇସ୍ରାଏଲ୍‌ ମାଜ଼ିର୍‌ ଲାଗାଂ ଇ ବଚନ୍‌ ପକ୍‌ତାନ୍‌; ହେ ଜିସୁ କ୍ରିସ୍ଟ ୱିଜ଼ାର୍‌ ମାପ୍ରୁ । ");
INSERT INTO peg_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","ଏପେଙ୍ଗ୍‌ ପୁନାଦେର୍‌ ଜେ ବାପ୍ତିସିମ୍‌ ଜହନ୍‌ତି ସମୁତାଂ ହେ ନେକ୍ରିକାବୁର୍‌ ଗାଲିଲିତାଂ ଆରମ୍‌ କିଜ଼ି ସବୁ ଜିହୁଦାତି ବଚନ୍‌ ପର୍‌ଚାର୍‌ ଆତାତ୍‌ନ୍ନା, ");
INSERT INTO peg_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","ନାଜରିତିୟ ଜିସୁତି କାତା, ଇନେସ୍‌ ଇସ୍ୱର୍‌ ହେୱାନିଂ ପୁଇପୁୟା ଜିବୁନ୍‌ ଆରି ସାକ୍ତିତ ସିଗ୍‌ କିତାର୍‌, ଆରେ ହେୱାନ୍‌ ହାର୍‌ କିଉ କିଉ ଆରି ସୟ୍‌ତାନ୍‌ କିତି ବେମାର୍‌ ୱିଜ଼ୁ ଲୁଗାଂ ଉଜ୍‌ କିଉ କିଉ ୱିଜ଼େ ବୁଲାତାନ୍, ଇନାକିଦେଂକି ଇସ୍ୱର୍‌ ହେୱାନିଂ ଆଡାଜ଼ି ମାଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","ଆରେ, ହେୱାନ୍‌ ଜିହୁଦିର୍‌ତି ଦେସ୍ ଆରି ଜିରୁସାଲମ୍‌ତ ଇନାକା ଇନାକା କିତାନ୍‌, ଆସେଙ୍ଗ୍‌ ହେ ସବୁନି ସାକି; ହେୱାନିଂ ହେୱାର୍‌ କ୍ରୁସ୍‌ତ ଡ଼ସି ଅସ୍ତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","ହେୱାନିଂ ଇସ୍ୱର୍‌ ତିନି ଦିନ୍‌ତାଂ ଆରେ ନିକ୍‌ତାନ୍ନା; ଆରେ ହେୱାନ୍‌ ମାନାୟାର୍‌ ତାକେ ଚଞ୍ଜ୍‌ୟାତାନ୍‌; ");
INSERT INTO peg_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","ୱିଜ଼ାର୍‌ ଲକୁ ସିଦା ଆଦେଂ ହିୱାତାନ୍, ମତର୍‌ ଇସ୍ୱର୍‌ତି ହୁଦାଂ ଆଗେ କିତି ସାକି ଜେ ଆସେଙ୍ଗ୍‌, ମା ସିଦା ଆଦେଂ ହିତାନ୍‌ । ହେୱାନ୍‌ ହାକିତାକେଣ୍ତାଂ ନିଂତି ପାଚେ ଆପେଂ ହେୱାନ୍ତି ଲାହାଙ୍ଗ୍‌ ତିନାଉଣା କିତାପ୍, ");
INSERT INTO peg_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","ଆରେ ମାନାୟାର୍‌ ଲାଗେ ସୁଣାୟ୍‌ କିଦେଙ୍ଗ୍‌, ଆରେ ହାତି ଆରି ଜିଜ଼ି ମାନାୟାର୍ତି ବିଚାର୍‌କାର୍‌ୟା ଆଦେଂ କାଜିଂ ଇସ୍ୱର୍‌ ହେୱାନିଂ ବାଚି କିତାନ୍‌ନ୍ନା ଇଞ୍ଜି ସାକିହିଦେଂ ହେୱାନ୍‌ ମାଂ ବଲ୍‌ ହିତ୍‍ତାନ୍ । ");
INSERT INTO peg_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","ଇନେର୍‌କି ହେୱାନ୍‌ ତାକେ ପାର୍ତି କିତାର୍‌, ହେୱାନ୍‌ ଜେ ହେୱାନ୍ତି ତର୍‌ନି ସାକ୍ତିତ ପାପ୍‌ କେମା ପାୟାନାନ୍‌, ଇଦାଂ ୱିଜ଼ୁ ବେଣ୍‌ବାକ୍‌ଣାୟ୍‌କିନାକାର୍‌ ହେୱାନ୍ତି ବିସ୍ରେ ସାକି ହିନାର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","ପିତର୍‌ ଇ ସବୁ ହିକ୍ୟା ହିନି ୱେଡ଼ାଲିଂ ଏଚେକାଡ଼୍‌ଦ ଲଗୁ ବଚନ୍‌ ୱେନ୍‌ଞ୍ଜି ମାଚାର୍‌, ହେ ୱିଜ଼ାର୍‌ ଜପି ପୁଇପୁୟା ଜିବୁନ୍‌ ଜୁତ୍‍ତାତ୍ । ");
INSERT INTO peg_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","ହେବେ ପିତର୍‌ ହୁଦାଂ ୱାତି ସୁନ୍ନତ୍‌ ପାର୍ତି କିନାକାର୍‌ ୱିଜ଼ାର୍‌ ପାର୍ତିକିୱି ଜିହୁଦିର୍‌ ଜପି ପା ପୁଇପୁୟା ଜିବୁନ୍‌ ହିନାକା ହୁଡ଼୍‌ଜି କାବା ଆତାର୍‌; ");
INSERT INTO peg_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","ଇନାକିଦେଂକି ହେୱାର୍‌ ଜିହୁଦି ପାର୍ତି କିନାକାର୍‌ ବାର୍‍ବିନ୍ ବେଣ୍‍ତ କାତା ଇନାକା ଆରି ଇସ୍ୱର୍‌ତି ଦନ୍ୟବାଦ୍‌ କିଜ଼ି ମାନାକା ୱେନ୍‌ଞ୍ଜି ମାଚାର୍‌, ହେପାଦ୍‌ନା ପିତର୍‌ ଉତର୍‌ ହିତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“ଇ ଇମ୍‌ଣି ଲକୁ ମା ଲାକେ ପୁଇପୁୟା ଜିବୁନ୍‌ ପାୟା ଆତାର୍ଣ୍ଣା, ଇୱାର୍‌ ଇନେସ୍‌ ବାପ୍ତିସିମ୍‌ ଆଉର୍‌, ହେଦାଂ କାଜିଂ କି ଇନେର୍‌ ଏଜ଼ୁଙ୍ଗ୍ ମୁନା କିଦେଙ୍ଗ୍‌ ଆଡୁର୍‌ ?” ");
INSERT INTO peg_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","ଆରେ, ହେୱାନ୍‌ ହେୱାରିଂ ଜିସୁ କ୍ରିସ୍ଟତି ତର୍‌ଦ ବାପ୍ତିସିମ୍‌ ହିନି କାଜିଂ ବଲ୍‌ ହିତାନ୍‌ । ପାଚେ ହେୱାର୍‌ ଅଲପ୍‍ ଦିନ୍‌ ମାଞ୍ଜେଙ୍ଗ୍ କାଜିଂ ହେୱାନିଂ ଗୱାରି କିତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","ପାର୍ତିକିୱି ଜିହୁଦିର୍‌ ପା ଜେ ଇସ୍ୱର୍‌ତି ବଚନ୍‌ ଇଡ୍‍ତାର୍‍ନା, ଇଦାଂ ପକ୍ୟାତାକାର୍‌ ଆରି ଜିହୁଦା ରାଜିତ ମାନି ପାର୍ତି କିନି ଟଣ୍ଡାର୍‌ ୱେଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","ଆରେ, ଏଚେକାଡ଼୍‌ଦ ପିତର୍‌ ଜିରୁସାଲମ୍‌ତ ୱାତାନ୍, ହେ ଏଚେକାଡ଼୍‌ଦ ସୁନ୍ନତ୍‌ ଆତି ଚେଲାର୍‌ ହେୱାନ୍‌ ହୁଦାଂ ବିଚାର୍‌ କିଜ଼ି ଇଚାର୍‌, ");
INSERT INTO peg_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","“ଏନ୍‌ ପାର୍ତିକିୱି ଜିହୁଦି ଲକାରିଂ ଇଞ୍ଜ ହଟ୍‍ପିସ୍ ହେୱାର୍‌ ହୁକେ ଚିଚାୟ୍‍ନା ।” ");
INSERT INTO peg_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","ମାତର୍‌ ପିତର୍‌ ସବୁ କାତାତିଂ ବୁଜାୟ୍‌ କିଦେଙ୍ଗ୍‌ ଆରମ୍‌ କିଜ଼ି ଇଚାନ୍‌, ");
INSERT INTO peg_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“ଆନ୍‌ ଜାପ ଗାଡ଼୍‌ଦ ପାର୍ତାନା କିଜ଼ି ମାଚାଙ୍ଗ୍ ଆରି ଦର୍ସନ୍ ଗାଟାତାଂ, ର ପାଡ଼୍‌କାତାଙ୍ଗ୍‌ ୱାନାତା, ଇନେସ୍‌ ର ଗାଜା ହେନ୍ଦ୍ରା ଚାରି କନାତ ଆସ୍ତି ବାଦାଡ଼୍‌ତାଂ ହେଦାଂ ହୁଡ଼୍‌ତାଂ, ହେଦାଂ ନା” ଲାଗାଂ ଟେବାତାତ୍‌, ");
INSERT INTO peg_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","ଆରେ ବାଦାଡ଼୍‌ତାଂ ହେଦାଂ ନା ପାତେକ୍‌ ୱାତାତ୍; ଆନ୍‌ ହେଦାଂ ହୁଡ଼୍‌ଜି ଚିନ୍ତା କିଦେଙ୍ଗ୍‌ ଲାଗାତାଂ ଆରି ହେବେ ପୁର୍ତିନି ଚାରିଗଡ଼ିୟା ଜାତ୍‌, ରାନ୍ତି ପସୁ, ରାଚ୍‍କୁ ପାଣା ଆରି ପ୍ରୁତିନି ପଟିଙ୍ଗ୍‌ ସବୁ ହୁଡ଼୍‌ତାଂ, ");
INSERT INTO peg_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","ଆରେ, ନାଙ୍ଗ୍‌ ଇଞ୍ଜିମାଞ୍ଚି ର କାତା ପା ଆନ୍‌ ୱେଚାଙ୍ଗ୍‌, ଏ ପିତର୍‌, “ନିଙ୍ଗା, ପାଗ୍‍ଜି ତିନା ।” ");
INSERT INTO peg_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","ମାତର୍‌ ଆନ୍‌ ଇଚାଙ୍ଗ୍‌, ଆକାୟ୍‌, ମାପ୍ରୁ, ରାଡ଼ା କି ସକଟ୍‍ ହିଲ୍‍ୱି ଜିନିସ୍‌ ନା ମୁମ୍‌ଦ ଇନାୱାଡ଼ାଂ ହଟ୍‍ପି କିୱାତାଂନା । ");
INSERT INTO peg_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","ମାତର୍‌ ରିହା ବାଦାଡ଼୍‌ତାଂ ର କାଟ୍‌ ଉତର୍‌ ହିତ୍‍ତାତ୍, “ଇସ୍ୱର୍‌ ଇନାକା ସକଟ୍‌ କିତାନ୍‌ନ୍ନା, ଏନ୍‌ ହେଦାଂ ବିଟାଡ଼୍‌ ଇଞ୍ଜି ଇନ୍‌ମା ।” ");
INSERT INTO peg_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","ଇ ବାନି ତିନି ହଟ୍‌ ଆତାତ୍‌, ପାଚେ ୱିଜ଼ୁ ଆରେରଗ ବାଦାଡ଼୍‌ତ ଅୟାତାତ୍ । ");
INSERT INTO peg_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","ଆରେ ହୁଡ଼ାଟ୍‌, ଦାପ୍ରେ ତିନ୍‌ ଜାଣ୍‌ ମାନାୟ୍‌, ଆପେଂ ଇମ୍‌ଣି ଇଞ୍ଜ ମାଚାପ୍, ହେବେନି ମୁମ୍‌ଦ ୱାଜ଼ି ନିଲ୍‌ତାର୍‌, ହେୱାର୍‌ କାଇସରିୟାତାଂ ନା ତାକେ ପକ୍ୟାଜ଼ି ମାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","ଆରେ, ମୁଡ଼େ ଆନ୍‌ମାନ୍‌ କିୱାଦାଂ ହେୱାର୍‌ ହୁଦାଂ ହାଞ୍ଜେଙ୍ଗ୍‌ କାଜିଂ ପୁଇପୁୟା ଜିବୁନ୍‌ ନାଙ୍ଗ୍‌ ୱେଚ୍‍ଚାତାତ୍ । ଆରେ, ଇ ଚଅ ଜାଣ୍‌ ପାର୍ତି କିନି ଟଣ୍ଡାର୍‌ ପାନା ହୁଦାଂ ତାରେନ୍‌ ହାଚାର୍‌, ଆରେ ଆପେଂ ହେ କର୍ଣ୍ଣଲିୟା ଇଲ୍‌ ହଟାପ୍ । ");
INSERT INTO peg_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","ହେୱାନ୍‌ ଇନେସ୍‌ ରୱାନ୍‌ ଦୁତ୍‌ ତାକେ ଦର୍ସନ୍ ପାୟାଜ଼ି ମାଚାନ୍‌, ହେଦାଂ ମାଙ୍ଗେଙ୍ଗ୍ ୱେଚ୍‍ଚାତାନ୍, ହେ ଦୁତ୍‌ ଇନେସ୍‌ ହେୱାନ୍ତି ଇଞ୍ଜ ଇଚାନ୍‌, ଜାପତ ଲକୁ ପକ୍‌ଚି ପିତର୍‌ କୁକ୍‌ନି ତର୍‌ ସିମନ୍‌ତିଂ କୁକ୍‌ଚି ତାହିୱାଡୁ; ");
INSERT INTO peg_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","ଇନେର୍‌ ୱିଜ଼ାର୍‌ ବଚନ୍‌ ହୁଦାଂ ଏପେଙ୍ଗ୍‌ ଆରି ମି ୱିଜ଼ାର୍‌ ଇଲ୍‌ନିକାର୍ ରାକ୍ୟା ଆନାର୍‌, ହେୱାନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ହେ ସବୁ ୱେଚ୍‍ଚାନାନ୍ । ");
INSERT INTO peg_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","ପାଚେ ଆନ୍‌ କାତା ଇଞ୍ଜେଙ୍ଗ୍‌ ଆରମ୍‌ ୱେଡ଼ାଲିଂ ପୁଇପୁୟା ଜିବୁନ୍‌ ଆଗ୍‌ଦ ମା ଜପି ଜୁତ୍‌ତି ଲାକେ ହେୱାର୍‌ ଜପି ପା ଜୁତ୍‍ତାତ୍ । ");
INSERT INTO peg_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","ହେପାଦ୍‌ନା ମାପ୍ରୁତି ଇ ବଚନ୍‌ ନା ଏତୁ ୱାତାତ୍‌, ଜହନ୍‌ ୱିଜ଼ାକାରିଂ ଉତର୍‌ ହିତାନ୍‌, “ଜହନ୍‌ ହିନା ଏସ୍‍ଉଙ୍ଗ୍‍ତାଂ ବାପ୍ତିସିମ୍‌ ହିତାନ୍‌ ହାତ୍‌ପା ମତର୍‌ ଏପେଙ୍ଗ୍‌ ପୁଇପୁୟା ଜିବୁନ୍‌ତାଂ ବାପ୍ତିସିମ୍‌ ଆନାଦେର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","ଲାଗିଂ, ଆସେଙ୍ଗ୍‌ ମାପ୍ରୁ ଜିସୁ କ୍ରିସ୍ଟତି ତାକେ ପାର୍ତି କିନି ୱେଡ଼ାଲିଂ ଇସ୍ୱର୍‌ ଇନେସ୍‌ ଦାନ୍‌ ହିିଜ଼ି ମାଞ୍ଚାନ୍, ହେ ଲାକେ ଏଚେକାଡ଼୍‌ଦ ହେୱାରିଂ ପା ହାରି ଦାନ୍‌ ହିତାନ୍‌, ଆନ୍‌ ଇନେର୍‌ ଜେ ଇସ୍ୱର୍‌ତିଂ ବାଦା ହିଦେଂ ଆଡ଼୍‍ତାଂମା ? ");
INSERT INTO peg_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","ଇ ସବୁ କାତା ୱେଚିଲେ ହେୱାର୍‌ ଚିମ୍‌ରା ଆତାର୍‌ ଆରି ଇସ୍ୱର୍‌ତିଂ ଜାଜ୍‌ମାଲ୍‌ କିଜ଼ି ଇଚାର୍‌, “ୱାଟିଙ୍ଗ୍‌” ଇସ୍ୱର୍‌ ପାର୍ତିକିୱି ଜିହୁଦିର୍‌ ପା ପୁଇପୁୟା ଜିବୁନ୍‌ ପାୟାନି କାଜିଂ ମାନ୍‌ବାଦ୍‌ଲାୟ୍‌ ଦାନ୍‌ କିତାନ୍‌ନ୍ନା । ");
INSERT INTO peg_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","ୱିସ୍ତି ବିତ୍ରେ ସ୍ତିପାନ୍‌ କାଜିଂ ଗିଟାଜ଼ି ମାଚି ଦୁକ୍‌ କାଜିଂ ଇମ୍‌ଣାକାର୍‌ ଜେଡ଼େକେତ୍‍ ଆଜ଼ି ମାଚାର୍‌, ହେୱାର୍‌ ପୈନିକିଆ, କୁପ୍ର ଆରି ଆନ୍ତିୟକିଆ ପାତେକ୍‌ ବୁଲା ଆଜ଼ି ଆପ୍‍କା ଜିହୁଦିରିଂ ପିସ୍ତି ଆରେ ଇନେର୍‌ ତାକେ ବଚନ୍‌ ପରଚାର୍‌ କିୱାଦାଂ ମାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","ମାତର୍‌ ହେୱାର୍‌ତି ବିତ୍ରେ କେତେକ୍‌ ସାଇପ୍ରସ୍‌ ଆରି କୁରିଣିୟ ଲକୁ ଆନ୍ତିୟକିଆତାଂ ୱାଜ଼ି ଗ୍ରିକ୍‌ ତାକେ ପା କାତା ଇଞ୍ଜି ମାପ୍ରୁ ଜିସୁତି ନେକ୍ରିକାବୁର୍‌ ପରଚାର୍‌ କିଦେଙ୍ଗ୍‌ ଲାଗାତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","ଆରେ, ହେୱାର୍‌ ଲାହାଂ ମାପ୍ରୁତି କେଇ ମାଚାତ୍‌, ଆରେ ବେସି ମାନାୟ୍‌ ପାର୍ତି କିଜ଼ି ମାପ୍ରୁନିପ ମାସ୍‌ଦି ୱାତାର୍ । ");
INSERT INTO peg_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","ହେୱାର୍‌ତି ବିସ୍ରେତି କାବୁର୍‌ ଜିରୁସାଲମ୍‌ ମଣ୍ଡ୍‌ଲିତ ୱେନ୍ୟାତାତ୍, ହେବେ ହେୱାର୍‌ ଆନ୍ତିୟକିଆ ପାତେକ୍‌ ବର୍ଣ୍ଣବାଙ୍ଗ୍‌ ପକ୍ତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","ହେୱାନ୍‌ ଏକିସ୍ ଇସ୍ୱର୍‌ତି ଦୟା ହୁଡ଼୍‌ଜି ୱାର୍‌ୟା ଆତାନ୍‌, ଆରେ ଇନେସ୍‌ ହେୱାର୍‌ ମାନ୍‌ନି ର ମାନ୍ତ ମାପ୍ରୁତି କାଜିଂ ଜେଲ୍‍ୟା ଆଜ଼ି ମାନାର୍‌, ହେଦାଂ କାଜିଂ ୱିଜ଼ାରିଂ ୱାରିକିୟ୍‌ କିତାର୍‌; ");
INSERT INTO peg_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","ଇନାକିଦେଂକି ବର୍ଣ୍ଣବା ରୱାନ୍‌ ହାର୍‌ଦି ମୁଣିକା, ଆରେ ପୁଇପୁୟା ଜିବୁନ୍‌ ଆରି ପାର୍ତିତ ବାର୍ତି ମାଚାନ୍‌ । ଇ ବାନି ବେସି ବେସି ମାନାୟ୍‌ ମାପ୍ରୁ ତାକେ ମେହା ଆତାର୍‌ । । ");
INSERT INTO peg_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","ପାଚେ ହେୱାନ୍‌ ସାଉଲ୍‌ତିଂ ଡେକ୍‌ନି କାଜିଂ ତାର୍ସତ ହସି ହାଚାନ୍‌, ");
INSERT INTO peg_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","ଆରେ, ହେୱାନ୍‌ ହେୱାନିଂ ଗାଟାଜ଼ି ଆନ୍ତିୟକିଆତ ତାହିୱାତାନ୍‌ । ହେୱାର୍‌ ବାର୍ତି ର ବାର୍ହୁ ପାତେକ୍‌ ମଣ୍ଡ୍‌ଲି ହୁଦାଂ ମାନ୍‌ଞ୍ଜି ବେସି ଲୁଗାଙ୍ଗ୍ ହିକ୍ୟା ହିତାନ୍‌, ଆରେ ଆନ୍ତିୟକିଆତ ଚେଲାର୍‌ ପର୍ତୁମ୍‌ କ୍ରିସ୍ଟିୟାନ୍‌ ଇଞ୍ଜି ଇନ୍ୟା ଆତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","ହେ ୱେଡ଼ାଲିଂ କେତେକ୍‌ ଜାଣ୍‌ ବେଣ୍‌ବାକ୍‌ଣାୟ୍‌କିନାକାର୍‌ ଜିରୁସାଲମ୍‌ତାଂ ଆନ୍ତିୟକିଆତ ୱାତାର୍ । ");
INSERT INTO peg_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","ହେୱାର୍‌ ବିତ୍ରେ ଆଗାବ ତର୍‌ନି ରୱାନ୍‌ ମୁଣିକା ନିଂଜି ସବୁ ପୁର୍ତିତ ବେସି କାତାର୍ ଆର୍ଣ୍ଣାତ୍ ଇଞ୍ଜି ଜିବୁନ୍‌ ହୁଦାଂ ୱେଚ୍‌ଚାନ୍‌; ହେଦାଂ କ୍ଲାଉଦିଅତି ସମୁ ମାନି ୱେଡ଼ାଲିଂ ଗିଟାତାତ୍ । ");
INSERT INTO peg_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","ହେବେ ଚେଲାର୍‌ ସବୁ ଜାଣ୍‌ ଜାର୍‌ ସାକ୍ତି ହୁଦାଂ ଜିହୁଦା ରାଜି ନିକାର୍‌ ପାର୍ତି କିନି ଟଣ୍ଡାର୍‌ କାଜିଂ ହେବା ପକ୍ତେଙ୍ଗ୍ ତିର୍‌ କିତାର୍‌, ");
INSERT INTO peg_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","ଆରେ ହେୱାର୍‌ ପା ହେଦାଂ କିଜ଼ି ବର୍ଣ୍ଣବା ଆରି ସାଉଲ୍‌ତି କେଇଦ ପ୍ରାଚିନାର୍‌ତି ଲାଗେ ପକ୍ତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","ଆନ୍‍ମାନ୍‍ରେ ହେ ୱେଡ଼ାଲିଂ ହେରଦ୍‌ ରାଜା ମଣ୍ଡ୍‌ଲିନି କେତେକ୍‌ ଜାଣ୍‍ତିଂ ହର୍‌ବର୍‌ କିନି କାଜିଂ କେୟ୍‌ କିତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","ହେୱାନ୍‌ ଜହନ୍‌ତି ଟଣ୍ଡେନ୍‌ ଜାକୁବ୍‌ଙ୍ଗ୍ କାଣ୍ଡାତାଂ ଅସ୍ତାନ୍ । ");
INSERT INTO peg_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","ଆରେ ଜିହୁଦିର୍‌ ହେବେ ସତକ୍‍ ଆନାକା ହୁଡ଼୍‌ଜି ହେୱାନ୍‌ ପିତର୍‌ତିଂ ପା ଗେସ୍‌ତାର୍‌ । ହେ ୱେଡ଼ାଲିଂ ହଇୱି ରୁଟିନି ପାର୍ବୁ ମାଚାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","ପାଚେ ହେରଦ୍‌ ତାଙ୍ଗ୍‌ ଆସ୍ତି ଜଇଲ୍‍ତ ଇଡ୍‍ତାନ୍, ଆରେ, ନିସ୍ତାର୍‌ ପାର୍ବୁ ପାଚେ ହେୱାନ୍‌ ତାଙ୍ଗ୍‌ ମାନାୟାର୍‌ ଲାଗେ ହପ୍‍ଚି ତାହିୱାଦେଂ କାଜିଂ ମାନ୍‌ କିଜ଼ି ୱିଜ଼ୁ କୁଦାନି ଚାରି ଜାଣ୍‌ ଲାକେ ମାଞ୍ଜି ଚାର୍‍ଗଟା ମେଲ୍ୟା କୁଦା ଲାଗେ ତାଙ୍ଗ୍‌ କାତେଂ ଇଞ୍ଜି ହେଲାୟ୍‌ କିତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","ଲାଗିଂ, ପିତର୍‌ ଜଇଲ୍‍ତ ଗେହ୍ୟା ଆଜ଼ି ମାଚାନ୍‌, ମତର୍‌ ତା କାଜିଂ ମଣ୍ଡ୍‌ଲି ହୁଦାଂ ରମାନ୍ତ ଇସ୍ୱର୍‌ତି ଲାଗେ ପାର୍ତାନା କିଜ଼ି ମାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","ପାଚେ ହେରଦ୍‌ ଇମ୍‌ଣି ଦିନ୍‌ ପିତର୍‌ତିଂ ହପ୍‍ଚି ତାତେଙ୍ଗ୍‌ ହାଲ୍‌ଜି ମାଚାନ୍‌, ହେ ଆର୍କାତ୍‌ ନାଣାଲିଂ ରିଣ୍ଡି ହିକ୍‌ଡ଼ିଂତାଂ ଗାଚ୍ୟା ଆଜ଼ି ରି ମେଲ୍ୟାର୍ତି ବିତ୍ରେ ହୁଞ୍ଜି ମାଚାନ୍‌, ଆରେ ଜାଗ୍‌ୱାଡ଼ାର୍‌ ଦୁୱେର୍‌ ମୁମ୍‌ଦ ଜଇଲ୍ ରାକ୍ୟା କିଜ଼ି ମାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","ଆରେ ହୁଡ଼ାଟ୍‌, ତ୍ରିପ୍‌କୁ ମାପ୍ରୁତି ରୱାନ୍‌ ଦୁତ୍‌ ଏକାତାତ୍‌, ଆରେ ବାକ୍ରା ଅଜଡ଼୍‌ ଆତାତ୍‌, ଆରେ ଦୁତ୍‌ ପିତର୍‌ ତିଙ୍ଗ୍‌ ନେଞ୍ଜେଡାକିତ ଇଡ଼୍‌ଜି ତାଙ୍ଗ୍‌ ନିକ୍‌ଚି ଇଚାନ୍‌, “ବେଗି ନିଙ୍ଗା ।” ହେବେ ତା କେଇଦାଂ ହିକ୍‌ଡ଼ିଂ କ୍ଡୁସ୍‌ଦି ହାଚିକ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","ଆରେ, ଦୁତ୍‌ ତାଙ୍ଗ୍‌ ଇଚାତ୍‌, “ମ୍ଡେଙ୍ଗାଙ୍ଗ୍‍ ଗାଚ୍ୟା ଆରି ପାଣ୍ଡାୟ୍‌ ତୁଜ଼ା ।” ପିତର୍‌ ହେ ଲାକେ କିତାନ୍‌ ! ଆରେ ଦୁତ୍‌ ତାଙ୍ଗ୍‌ ଇଚାନ୍‌, “ଗାଗାଡ଼୍‌ତ ହେନ୍ଦ୍ରା ତୁହିଜି ନା ପାଚେ ପାଚେ ୱା ।” ");
INSERT INTO peg_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","ପିତର୍‌ ହସି ହେୱାନ୍ତି ପାଚେ ପାଚେ ହାଚାନ୍‌, ମାତର୍‌ ଦୁତ୍‌ତାଂ ଇନାକା କିୟାତାତ୍, ହେଦାଂ ଜେ ହାତ୍‌ପା, ହେୱାନ୍‌ ହେଦାଂ ବୁଜାୱାଦାଂ କେଚ୍‌କଣ୍‌ ହୁଡ଼୍‍ନାନା ଇଞ୍ଜି ବାବି କିଜ଼ି ମାଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","ଏଚେକାଡ଼୍‌ଦ ହେୱାର୍‌ ପର୍ତୁମ୍‌ ଆରି ରିଣ୍ଡି ଜାଗ୍‍ୱାଡ଼ାର୍ କୁଦା ନାସି, ଇମ୍‌ଣି ଲୱା ଦୁୱାର୍ ହିିଜ଼ି ଗାଡ଼୍‌ଦ ହାଞ୍ଜେଙ୍ଗ୍‌ ଆନାତ୍‌, ହେଦାଂ ଲାଗେ ୱାତାର୍, ହେ କାଡ଼୍‌ଦ ହେ ଦୁୱେର୍‌ ଜାର୍‌ ମାନ୍ତିଙ୍ଗ୍ ହେୱାର୍‌ କାଜିଂ ମେଲା ଆଜ଼ି ହାଚାତ୍‌, ଆରେ ହେୱାର୍‌ ହସିହାଲ୍‍ଜି ର ହାକ୍‍ଡ଼ିତ ହାରିହାରା ପାତେକ୍‌ ହାଚାର୍‌, ଆରେ ଦାପ୍ରେ ହେ ଦୁତ୍‌ ତା ତାକେଣ୍ଡାଂ ମାୟା ଆଜ଼ି ହାଚାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","ହେୱାଡ଼ାଂ ପିତର୍‌ ଚେତ୍‌ନା ଆଜ଼ି ଇଚାନ୍‌, ମାପ୍ରୁ ଜେ ଜାର୍‌ ଦୁତ୍‌ତିଂ ପକ୍‌ଚି ହେରଦ୍‌ କେଇଦାଂ ଆରି ଜିହୁଦିର୍‌ ଲକୁତାଂ ୱିଜ଼ୁ ଆହାତାଂ ନାଂ ଉଦାର୍‌ କିତ୍‌ତାନ୍‌ନା, “ଇଦାଂ ଆନ୍‌ ନଙ୍ଗ୍‌ ହାତ୍‌ପା ପୁଚାଙ୍ଗ୍ ।” ");
INSERT INTO peg_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","ହେୱାନ୍‌ ଇ କାତା ଜାଗ୍ରତ୍‌ ଆଜ଼ି ମାର୍କ କୁକ୍‌ନି ଜହନ୍‌ତି ତେହି ମରିୟମ୍‌ ଇଞ୍ଜ ୱାତାନ୍; ହେ ବାହାତ ବେସି ରୁଣ୍ଡା ଆଜ଼ି ପାର୍ତାନା କିଜ଼ି ମାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","ପିତର୍‌ ବାର୍ତି ଦୁୱେର୍‌ତ ଇଡ଼୍‍ତିଲେ, ରଦା ତର୍‌ନି ରଞ୍ଜେଲ୍‌ ଆଡ଼ିଏଣି ଇନେର୍‌ ଇଞ୍ଜି ୱେନ୍‍ବେଦେଂ ହାଚାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","ହେୱାନ୍‌ ପିତର୍‌ତି କାଟ୍‌ ବେସି ୱାରି କାଜିଂ ଦୁୱେର୍‌ ଜେୱାଦାଂ ବିତ୍ରେ ହଞ୍ଚି ହାଲ୍‌ଜି, ଦୁୱେର୍‌ ଲାସେଙ୍ଗ୍ ପିତର୍‌ ନିଲ୍‌ତାନ୍ନା ଇଞ୍ଜି ଇଚାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","ହେୱେକ୍‌ ହେଦେଲିଂ ଇଚିକ୍‌, “ଏନ୍‌ ବାଇରି । ମାତର୍‌ ହେୱେକ୍‌ ହେଦାଂ ସତ୍‌ ଇଞ୍ଜି ଆଟ୍‌ୱା ଲାକେ ଇଞ୍ଜେଙ୍ଗ୍‌ ଲାଗିତିକ୍‌ । ହେୱେକ୍‌ ଇଚିକ୍‌ ଇୱାନ୍‌ ହେୱାନ୍ତି ଦୁତ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","ମାତର୍‌ ପିତର୍‌ ଦୁୱାର୍‍ତ ତାୟ୍‍ନାତ୍ ଇଡ଼୍‌ଜି ମାଚାନ୍‌, ଆରେ ହେୱେକ୍‌ ଜେସି ହେୱାନିଂ ହୁଡ଼୍‌ଜି କାବା ଆତିକ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","ମାତର୍‌ ହେୱାନ୍‌ ହେୱାରିଂ ଚିମ୍‌ରା ଆଜ଼ି ମାଞ୍ଜେଙ୍ଗ୍ କାଜିଂ କେଇ ଜିଞ୍ଜି, ମାପ୍ରୁ ଇନେସ୍‌ ତାଙ୍ଗ୍‌ ଜଇଲ୍‌ ତାଂ ହପ୍‍ଚି ତାହିୱାତାନ୍ନା, ହେଦାଂ ହେୱେକ୍‌ ଲାଗେ ହାନ୍ଦାୟ୍ କିତାନ୍‌ । ଆରେ ହେୱାନ୍‌ ଇଚାନ୍‌, “ଇ ୱିଜ଼ୁ କାତା ଜାକୁବ୍‌ ଆରି ପାର୍ତି କିନି ଟଣ୍ଡାର୍‌ରିଂ ୱେଚାଟ୍‌ । ଆରେ, ହେୱାନ୍‌ ହାଲ୍‌ଜି ବିନ୍‌ ବାହାତ ତାଂଜି ହାଚାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","ନାଡ଼ିସ୍ ଆତି ପାଚେ ପିତର୍‌ ଇମେ ହାଚାନ୍‌ ଇଞ୍ଜି ମେଲ୍ୟାର୍‌ ବିତ୍ରେ ବେସି ୱିଣ୍‍ତାତ୍ । ");
INSERT INTO peg_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","ଆରେ ହେରଦ୍‌ ହେୱାନିଂ ଡେକ୍‌ଚି ଗାଟାୱିତିଲେ ଜାଗ୍‌ୱାଡ଼ାରିଂ ପର୍‌ସନ୍‌ କିତି ପାଚେ ହେୱାରିଂ ଅସ୍ତେଙ୍ଗ୍‌ କାଜିଂ ବଲ୍‌ ହିତାନ୍‌ । ପାଚେ ହେୱାନ୍‌ ଜିହୁଦା ରାଜିତାଂ କାଇସରିୟାତ ହାଲ୍‌ଜି ହେବେ ମାନ୍‍ଗାତାନ୍ । ");
INSERT INTO peg_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","ହେ ଏଚେକାଡ଼୍‍ଦ ହେରଦ୍‌ ରାଜା ସର ଆରି ସିଦନ୍‌ ଲକୁ ଜପି ବୟଙ୍କାର୍ ରିସା ଆଜ଼ି ମାଚାନ୍‌, ଲାଗିଂ ହେୱାର୍‌ ବିତ୍ରେତାଂ ର ଦଲ୍‌ ହେୱାନିଂ ଚଞ୍ଜ୍‌ୟା ଆଦେଂ ହାଚାର୍‌ । ପର୍ତୁମ୍‌ ହେୱାର୍‌ ହୁଞ୍ଜ୍‌ନି ଇଲ୍‌ତ ଦାୟିତ୍‌ତ ମାନି ବ୍ଲାସ୍ତତିଂ ବୁଜାୟ୍‌ କିଜ଼ି ତା ଉପ୍‌କାର୍‌ ପାୟାତାର୍‌ । ତା ପାଚେ ହେୱାର୍‌ ହେରଦ୍‌ତି ଲାଗାଂ ହାଲ୍‌ଜି ସୁସ୍ତା ବିକ୍ୟା କିତାର୍‌, ଇନେକିଦେଂକି ହେରଦ୍‌ତି ରାଜିତାଂ ହେୱାର୍‌ତି ଦେସ୍‌ତାଂ ଗାଦି ଗାଦି ଆଡ଼୍‌ମାଡ଼୍‌ ହାଲ୍‍ଜି ମାଚାତ୍ । ");
INSERT INTO peg_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","ଲାଗିଂ ର ତିର୍‌ କିତି ନାଜିଂ ହେରଦ୍‌ ରାଜା ହେନ୍ଦ୍ରା ଉସ୍ପିସ୍‌ ଗାଦିତ କୁଚ୍‌ଚି ହେୱାର୍‌ତି ଲାଗେ ସୁଣାୟ୍‌ କିତାନ୍‌, ");
INSERT INTO peg_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","ହେବେ ମାନାୟାର୍‌ ଆଲା ଆଜ଼ି ଇଞ୍ଜେଙ୍ଗ୍‌ ଲାଗାତାର୍‌, “ଇଦାଂ ତ ଇସ୍ୱର୍‌ତି କାଟ୍‌, ମାନାୟ୍‍ତି କାଟ୍‌ ଆକାୟ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","ହେ ଦାପ୍ରେ ମାପ୍ରୁତି ରଞ୍ଜେଲ୍‌ ଦୁତ୍‌ ହେରଦ୍‌ତିଂ ମାଡ଼୍‍ଜି କିତାତ୍‌, ଇନାକିଦେଂକି ହେୱାନ୍‌ ଇସ୍ୱର୍‌ତିଂ ଜାଜ୍‌ମାଲ୍‌ ହିୱାତାନ୍, ଆରେ ହେୱାନ୍‌ ପ୍ଡି ହୁଦାଂ ତିନ୍ୟା ଆଜ଼ି ପାରାଣ୍‌ ପିସ୍ତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","ମାତର୍‌ ଇସ୍ୱର୍‌ତି ବଚନ୍‌ ଆଦିକ୍‌ ମେଙ୍ଗ୍‌ଦେଂ ଲାଗାତାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","ପାଚେ ବର୍ଣ୍ଣବା ଆରି ସାଉଲ୍‌ ଜାର୍‍ତି ଲକାରିଂ ହେବାକାମାୟ୍‌ ୱିସ୍ତି ଜହନ୍‌ତିଂ କୁକ୍‌ନି ତର୍‌ ମାର୍କ ହାଙ୍ଗ୍‌ ଅଜ଼ି ଜିରୁସାଲମ୍‌ତ ଲେଉଟା ଆଜ଼ି ହାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","ହେପାଦ୍‌ନା ଆନ୍ତିୟକିଆନି ମଣ୍ଡ୍‌ଲିତ ବର୍ଣ୍ଣବା, ସିମିୟନ୍‌, ଇନେରିଂ ନିଗର ଇଞ୍ଜି ଇନାର୍‌, କୁରିଣିୟ ଲୁକିୟ, ସାମନ୍ତରାଜା ହେରଦ୍‌ତି ରଚେ ପହାକିତି ମନହେମ ଆରି ସାଉଲ୍‌, ହେୱାର୍‌ ବେଣ୍‌ବାକ୍‌ଣାୟ୍‌କିନାକାର୍‌ ଆରି ଗୁରୁର୍‌ ମାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","ହେୱାର୍‌ ମାପ୍ରୁତି ହେବା ଆରି ଉପାସ୍‌ କିନି ୱେଡ଼ାଲିଂ ପୁଇପୁୟା ଜିବୁନ୍‌ ଇଚାତ୍‌, “ଇମ୍‌ଣି କାମାୟ୍‌ କାଜିଂ ଆପ୍‌ ବର୍ଣ୍ଣବା ଆରି ସାଉଲ୍‌ତିଂ ବାଚି କିତାପ୍‌ନ୍ନା, ହେଦାଂ କାଜିଂ ହେୱାରିଂ ବିନେ କିୟାଟ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","ହେବେ ହେୱାର୍‌ ଉପାସ୍‌ ଆରି ପାର୍ତାନା କିତି ପାଚେ ହେୱାର୍‌ ଜପି କେଇ ହିଜ଼ି ହେୱାରିଂ ହେଲ ହିତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","ଇ ବାନି ବର୍ଣ୍ଣବା ଆରି ସାଉଲ୍‌ ପୁଇପୁୟା ଜିବୁନ୍‌ ହୁଦାଂ ପକ୍ୟା ଆଜ଼ି ସେଲୁକିଆତ ହାଚାର୍‌; ହେବେତାଂ ହେୱାର୍‌ ହାମ୍‌ଦୁର୍‌ ଜାଜ୍‌ତ ଦୁମ୍‌ଜି କୁପ୍ରତ ହାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","କାମ୍‌ଲିୟାର୍‌ ସାଲାମି ବସ୍ତିତ ଏକିତି ପାଚେ ଜିହୁଦିର୍‌‍ତି ୱିଜ଼ୁ ପାର୍ତାନା ଇଲ୍‌ତ ଇସ୍ୱର୍‌ତି ବଚନ୍‌ ପୁଚାର୍ କିଦେଙ୍ଗ୍‌ ଲାଗାତାର୍‌; ଆରେ, ଜହନ୍‌ ମାର୍କ ପା ହେବାକାର୍‌ୟା ଲାକେ ହେୱାର୍‌ ହୁକେ ମାଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","ଆରେ, ହେୱାର୍‌ ୱିଜ଼ୁ ଏସ୍‍କୁପ୍‍ଲି ବୁଲା ଆଜ଼ି ପାପତ ୱାଜ଼ି ରୱାନ୍‌ ଚୁଟ୍‍କି ଚାକ୍ରାୟ୍‌ ବେଣ୍‌ବାକ୍‌ଣାୟ୍‌କିନାନ୍‌ନିଂ ହୁଡ଼୍‌ତାର୍‌; ହେୱାନ୍‌ ରୱାନ୍‌ ଜିହୁଦି, ଆରେ ତା ତର୍‌ ବର୍ଜିସୁ । ");
INSERT INTO peg_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","ହେୱାନ୍‌ ସାସନ୍‌ କାର୍‍ୟା ସେର୍ଗିୟ ପାଉଲ୍‌ ସାଙ୍ଗ୍‌ ମାଚାନ୍‌, ହେ ସାସନ୍‍କାର୍‍ୟା ରୱାନ୍‌ ବୁଦିକାର୍‍ୟା ମୁଣିକା । ହେୱାନ୍‌ ଇସ୍ୱର୍‌ତି ବଚନ୍‌ ୱେଞ୍ଜେଙ୍ଗ୍‌ ମାନ୍‌ କିଜ଼ି ବର୍ଣ୍ଣବା ଆରି ସାଉଲ୍‌ତିଂ ଲାଗାଂ କୁକ୍‌ତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","ମାତର୍‌ ହେ ଚୁଟ୍‍କି ଅଲ୍ଲିମା ଇଦାଂ ତା ଗ୍ରିକ୍‌ ତର୍‌ । ହେୱାରିଂ ବାଦା ହିତାତ୍‌ ଇନାକିଦେଂକି ହେୱାନ୍‌ ସାସନ୍‍କାର୍‍ୟାଙ୍ଗ୍ କ୍ରିସ୍ଟ ପାର୍ତି କିନାକାର୍‌ କାଜିଂ ଅଲ୍‌ଗା କିଜ଼ି ଇଡ଼୍‌ଦେଂ ଚେସ୍ଟା କିଜ଼ି ମାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","ମତର୍‌ ସାଉଲ୍‌, ଇନେରିଂ ପାଉଲ୍‌ ପା ଇନାର୍‌, ପୁଇପୁୟା ଜିବୁନ୍‌ତ ବାର୍ତି ଆଜ଼ି ତାଙ୍ଗ୍‌ ମିଟ୍‌କିୱାଦାଂ ହୁଡ଼୍‌ଜି ଇଚାନ୍‌, ");
INSERT INTO peg_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","ଏ “ସୟ୍‌ତାନ୍‌ ମାଜ଼ି, ୱିଜ଼ୁ ବାନି ଟକ୍‍ୱା ଆରି କାପ୍‍ଟିତ ମାନ୍‌ତ ବାର୍ତି, ଆରେ ୱିଜ଼ୁ ବାନି ଦାର୍ମିତିଂ ନି ସାତ୍ରୁରିଂ, ଏପେଙ୍ଗ୍‌ ମାପ୍ରୁତି ସିଦା ହାଜ଼ିତିଂ ବାଂଟା କିଦେଙ୍ଗ୍‌ କାମାୟ୍‌ କିନାୟା ? ");
INSERT INTO peg_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","ଆରେ ନଙ୍ଗ୍‌ ହୁଡ଼ାଟ୍‌, ମାପ୍ରୁତି କେଇ ମି ଜପି ମାନାତ୍‌, ଏପେଙ୍ଗ୍‌ କାଣା ଆଜ଼ି ଏଚେକ୍ ଗାଡ଼ି ପାତେକ୍‌ ୱେଡ଼ା ହୁଡ଼ୁଦେର୍ ।” ହେ ଦାପ୍ରେ ଗୁକ୍‍ଟା ଆରି ମାଜ୍‍ଗା ତାଙ୍ଗ୍‌ ଡାବାୟ୍‍ କିତାତ୍‌, ଲାଗିଂ ତାଙ୍ଗ୍‌ କେଇ ଆସ୍ତି ହାଜ଼ି ଚଚେଂ କାଜିଂ ହେୱାନ୍‌ ଇନ୍‍ଟିଂ ହାନ୍‍ଟିଂ ବାଇବିକଲ୍‍ ଆଜ଼ି ମାନାୟ୍‍ତିଂ ଡେକ୍‌ତେଂ ଲାଗାତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","ହେ ସାସନ୍‍କାର୍‍ୟା ଇ ଗଟ୍‌ଣା ହୁଡ଼୍‌ଜି ପାର୍ତି କିତାନ୍‌ ଇନାକିଦେଂକି ମାପ୍ରୁତି ସିକ୍ୟା ୱେନ୍‌ଞ୍ଜି କାବା ଆଜ଼ି ପାର୍ତି କିତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","ପାଚେ ପାଉଲ୍‌ ଆରି ତା ହାଙ୍ଗ୍‌ଦାକାର୍‌ ପାପ୍‌ ତର୍‌ନି ବାହା ଏଜ଼ୁକାଂ ହାଲ୍‌ଜି ପଂପୁଲିଆନି ପର୍ଗିତ ୱାତାନ୍; ଜହନ୍‌ ତର୍‌ନି ମାର୍କ ହେୱାରିଂ ଇବେତାଂ ପିସ୍ତି ଜିରୁସାଲମ୍‌ତ ମାସ୍‌ଦି ହାଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","ହେୱାର୍‌ ପର୍ଗିତାଂ ହସି ୱାଜ଼ି ପିସିଦିଆନି ଆନ୍ତିୟକିଆତ ଇକାତାର୍, ଆରେ ଜମ୍‌ନିବାର୍‌ତ କୁଟୁମ୍‌ ଇଞ୍ଜ ହାଲ୍‌ଜି କୁଚ୍‌ଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","ଆରେ, ବିଦି ଆରି ବେଣ୍‌ବାକ୍‌ଣାୟ୍‌କିନାକାର୍‌ ସାସ୍ତର୍‌ ପଡ଼ିକିତି ପାଚେ ପାର୍ତାନା ଇଲ୍‍ନି ମୁଣିକାର୍ ହେୱାର୍‌ତି ତାକେ ସାସ୍‌ ହିଜ଼ି ଇଦାଂ ୱେଚ୍‌ଚି ପକ୍‌ତାନ୍‌, “ଟଣ୍ଡାର୍‌, ଦୁକ୍‌ସାରାୟ୍‌ କିନାକା ଲକାର୍ କାଜିଂ ଜଦି ଏପେଙ୍ଗ୍‌ ଇମ୍‌ଣି ବୁଜାନି କାତା ମାନାତ୍‌, ଲାଗିଂ ୱେଚ୍‍ଚାଟ୍ ।” ");
INSERT INTO peg_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","ହେବେ ପାଉଲ୍‌ ନିଲ୍‌ଚି କେଇଦାଂ ୱାଚ୍‍କା ଚଚ୍‍ଚି ଇଞ୍ଜେଙ୍ଗ୍‌ ଲାଗାତାନ୍‌, “ଏ ଇସ୍ରାଏଲିୟ ଲକୁ ଆରି ଇସ୍ୱର୍‌ତିଂ ପାଣ୍ଡ୍ରା ଆନାକାର୍‌, ପାର୍ତିକିୱି ଜିହୁଦି ନା କାତା ୱେନାଟ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","ଇ ଇସ୍ରାଏଲ୍‌ ଜାତିନି ଇସ୍ୱର୍‌ ମା ଆବାଲାତ୍ରାରିଂ ବାଚି କିତାନ୍‌, ଆରେ ହେୱାର୍‌ ମିସର୍‌ ଦେସ୍‌ତ ବାହା କିଜ଼ିମାନି ୱେଡ଼ାଲିଂ ହେୱାରିଂ ନିକ୍‌ତାନ୍‌, ଆରେ ସାକ୍ତିନି ବାପାଙ୍ଗ୍ ହୁଦାଂ ମିସର୍‌ତାଂ ହେୱାରିଂ କାଡାୟ୍‌ କିଜ଼ି ତାହିୱାତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","ପାଚେ ରିକଡ଼ି ବାର୍ହୁ ପାତେକ୍‌ ବାଟାତ ହେୱାନ୍‌ ହେୱାରିଂ ଚିନ୍ତା ହୁଞ୍ଚାନ୍, ");
INSERT INTO peg_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","ଆରେ କିଣାନ୍‌ ଦେସ୍‌ତ ସାତ୍‌ଗଟା ଜାତିତିଂ ବୁଡାୟ୍‌ କିଜ଼ି ତା ବାଚିକିତି ମାନାୟାରିଂ ହେ ଦେସ୍‌ ହିତାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","ଇଦାଂ ପାଚେ ବେଣ୍‌ବାକ୍‌ଣାୟ୍‌କିନାକାର୍‌ ସାମୁୟେଲ୍‌ ପାତେକ୍‌ ବିଚାର୍‌କାର୍‌ୟାରିଂ ବାଚି କିତାର୍‌ । “ଇଦାଂ ପାଚେ ବେଣ୍‌ବାକ୍‌ଣାୟ୍‌କିନାକାନ୍‌ ସାମୁଏଲ୍‌ତି ପାତେକ୍‌ ବିଚାର୍‍କାର୍‍ୟାରିଂ ବାଚି କିତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","ତା ପାଚେ ହେୱାର୍‌ ର ରାଜା ଗାଟାଦେଂ କାଜିଂ ପାର୍ତାନା କିତାର୍‌, ଆରେ ଇସ୍ୱର୍‌ ରିକଡ଼ି ବାର୍ହୁ ପାତେକ୍‌ ବିନ୍ୟାମିନ୍‌ କୁଟୁମ୍‌ନି କିସ୍ତି ମେହି ସାଉଲ୍‌ତିଂ ହେୱାନ୍‌ ହିତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","ପାଚେ ଇସ୍ୱର୍‌ ହେୱାନିଂ ଗାଦିତାଂ ଜୁତ୍‌ତି ହେୱାର୍‌ତି ରାଜା ଆଦେଂ କାଜିଂ ଦାଉଦ୍‌ତିଂ ନିକ୍‌ତାନ୍‌; ହେୱାନ୍‌ ପା ତା ବିସ୍ରେ ସାକି ହିଜ଼ି ଇଚାନ୍‌, ଆନ୍‌ ଜିସିୟତି ମେହି ଦାଉଦଂ ଗାଟାତାପ୍‍ନା, ହେୱାନ୍‌ ମା ମାନ୍ତ କାତା ଇନାନ୍‌, ହେୱାନ୍‌ ୱିଜ଼ୁ ବିସ୍ରେ ହାଂଜି ନା ଇଚା ମାନି କିନାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","ତା ଲାତ୍ରାତାଂ ଇସ୍ୱର୍‌ ପାର୍ମାଣ୍‌ ହୁଦାଂ ଇସ୍ରାଏଲ୍‌ କାଜିଂ ରୱାନ୍‌ ମୁକ୍ତିକିନାକାନ୍ ଇଚିସ୍‌ ଜିସୁତିଂ ଉବ୍‌ଜାଣ୍‌ କିତାନ୍‌ନ୍ନା । ");
INSERT INTO peg_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","ଜିସୁ ତା କାମାୟ୍‌ ଆରମ୍‌ କିନି ଆଗେ ଜହନ୍‌ ସବୁ ଇସ୍ରାଏଲ୍‌ ଲକୁତାକେ ଆକ୍‌ତୁ ମାନ୍‌ବାଦ୍‌ଲାୟ୍‌ନି ବାପ୍ତିସିମ୍‌ ସୁଣାୟ୍‌ କିଜ଼ି ମାଚାନ୍‌; ");
INSERT INTO peg_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","ଆରେ, ଜହନ୍‌ ଜାର୍‌ କିତି କାମାୟ୍‌ କିଉ କିଉ ଇଚାନ୍‌, “ଆନ୍‌ ଇନେନ୍‌ ଇଞ୍ଜି ଏପେଙ୍ଗ୍‌ ବାବି କିନାଦେରା, ଆନ୍‌ ହେୱାଙ୍ଗ୍‌ ଆକାୟ୍‌ । ମତର୍‌ ହୁଡ଼ାଟ୍‌, ନା ପାନାନି ପାଣ୍ଡାଇଙ୍ଗ୍‌ ଡରି ରିକ୍‌ତେଂ ଆନ୍‌ ସମାନ୍‌ ଆକାୟ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“ଏ ଟଣ୍ଡାର୍‌, ଅବ୍ରାହାମ୍‌ତି ଲାତ୍ରାନି ହିମ୍‍ଣାୱାକ୍‍ଡ଼ା ଆରି ମି ବିତ୍ରେତାଂ ଇସ୍ୱର୍‌ତିଂ ପାଣ୍ଡ୍ରା ଆନାକାର୍‌ ମା ଲାଗେ ଇ ମୁକ୍ତିନି ବଚନ୍‌ ପକ୍ୟା ଆତାତ୍‌ନ୍ନା । ");
INSERT INTO peg_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","ଇନାକିଦେଂକି ହେୱାନ୍‌ ଜେ ମୁକ୍‌ଡ଼ାତି ମୁଣିକା ଇଲ୍‌ ପୁନ୍‌ୱାଦାଂ ମାଚାର୍‌ ଜିରୁସାଲମ୍‌ତ ବାହା କିନାକାର୍ ଆରେ ହେୱାର୍‌ତି ବିଚାର୍‌ କାର୍‌ୟା ହେୱାନିଂ, ଆରେ ନିତ୍ରେ ଜମ୍‌ନିବାର୍‌ତ ପାଟ୍ ପଡ଼ିକିନାକା ବେଣ୍‌ବାକ୍‌ଣାୟ୍‌କିନାକାର୍‌ ବଚନ୍‌ ସବୁ ପୁନ୍‍ୱିତିଲେ ହେୱାନିଂ ଦସି କିଜ଼ି ହେ ୱିଜ଼ୁ ପୁରା କିତାନ୍‌, ");
INSERT INTO peg_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","ଆରେ, ହେୱାନ୍ତି ପାରାଣ୍‍ ଡାଣ୍ଡ୍‌ନି ଇମ୍‌ଣାକା ପା ନିଂ ଗାଟାୱିତିଲେ ହେୱାନିଂ ଅସ୍ତେଙ୍ଗ୍‌ କାଜିଂ ପିଲାତଙ୍ଗ୍‌ ଗୱାରି କିତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","ଆରେ, ହେୱାନ୍ତି ବିସ୍ରେ ଦର୍ମ ସାସ୍ତର୍‌ତ ଇନାକା ସବୁ ଲେକା ଆତାତ୍‌ନ୍ନା, ହେ ୱିଜ଼ୁ ହେୱାର୍‌ ପୁରା କିତି ପାଚେ ହେୱାନିଂ କ୍ରୁସ୍‌ତାଂ ଜୁତ୍‌ତି ତାହି ଦୁଗେର୍‌ତ ମୁଚ୍‌ଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","ମାତର୍‌ ଇସ୍ୱର୍‌ ହେୱାନିଂ ହାତାକାର୍‍ତାଂ ନିକ୍‌ତାନ୍ନା, ");
INSERT INTO peg_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","ଆରେ, ଇମ୍‌ଣାକାର୍‌ ହେୱାନ୍ତି ହୁଦାଂ ଗାଲିଲିତାଂ ଜିରୁସାଲମ୍‌ତ ୱାଜ଼ି ମାଚାର୍‌, ହେୱାର୍‌ ବେସି ଦିନ୍‌ ପାତେକ୍‌ ହେୱାନିଂ କେଚ୍‌କଣ୍‌ ପାୟାତାର୍‌; ହେୱାର୍‌ ନଙ୍ଗ୍‌ ଇସ୍ରାଏଲ୍‌ ମାନାୟାର୍‌ ଲାଗାଂ ହେୱାନ୍ତି ସାକି ଆନାପ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","ଆରେ, ଆବାଲାତ୍ରାତି ଲାଗେ କିତି ପାର୍ମାଣ୍‌ ବିସ୍ରେ ଆପେଂ ମିଙ୍ଗେଙ୍ଗ୍‌ ଇ ନେକ୍ରିକାବୁର୍‌ ୱେଚ୍‍ଚାନାପା, ");
INSERT INTO peg_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","ଇସ୍ୱର୍‌ ଜିସୁଙ୍ଗ୍‌ ନିକ୍‌ଚି ହେୱାର୍‌ତି ହିମ୍‌ଣାଂ ଜେ ଆସେଙ୍ଗ୍‌, ମା କାଜିଂ ହେ ପାର୍ମାଣ୍‌ ପୁରା କିତାନ୍‌ନ୍ନା, ଇନେସ୍‌ ଗିତ ସଂଗିତା ଦୁଇ ବାଗ୍‌ତ ନାନ୍ଦ୍‍ତ ପା ଲେକାମାନାତ୍‌, ଏନ୍‌ ନା ମାଜ଼ି, ନେଞ୍ଜେଙ୍ଗ୍‌ ଆନ୍‌ ନିଂ ଆବା ଆତାଂନା ।” ");
INSERT INTO peg_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","ଆରେ ଦୁଗେର୍‌ତ ବୁଡାଦେଂ ପିସ୍‌ସି ହିୱାଦାଂ ହେୱେନିଂ ହାକିତାଂ ନିକ୍‌ତେଂ ଇସ୍ୱର୍‌ ଇ କାତା ଇଚାନ୍‌; ଦାଉଦ୍‌ ହିଜ଼ି ମାନି ପାର୍ତି ଇସାବ୍ରେ ଆନ୍‌ ମିଙ୍ଗେଙ୍ଗ୍‌ ପୁଇପୁୟା ଆରି ହାତ୍‌ପା ଦୟା ଦାନ୍‌ କିଦ୍‌ନାଙ୍ଗ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","ଆରେ, ହେୱାନ୍‌ ପା ଆରେ ରଞ୍ଜାଙ୍ଗ୍‌ ନାନ୍ଦ୍‍ତ ଇଚାନ୍ନା, “ଏନ୍‌ ଜାର୍‌ ପୁଇପୁୟା ହେବାକାର୍‌ରିଂ ନସ୍ଟ ଆଦେଂ ହିଉୟ୍ ।” ");
INSERT INTO peg_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","ଦାଉଦ୍‌ ତ ଜାର୍‌ ହାରି ୱେଡ଼ାନି ମାନାୟାର୍‌ ବିତ୍ରେ ଇସ୍ୱର୍‌ତି କିତି ଆଗେ ହୁଦାଂ ହେବାକିନାକା କାମାୟ୍‌ କିତିପାଚେ କାଣ୍‍କୁଜୁଞ୍ଚାନ୍ ଆରି ଜାର୍‌ ଆବା ଲାତ୍ରାର୍ ଲାଗେ କବର୍‍ ପାୟା ଆଜ଼ି ଜିରା ଆତାନ୍‌; ");
INSERT INTO peg_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","ମାତର୍‌ ଇନେରିଂ ଇସ୍ୱର୍‌ ନିକ୍‌ତାନ୍ନା, ହେୱାନ୍‌ ନସ୍ଟ ଆୱାତାନ୍ନା । ");
INSERT INTO peg_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","ଲାଗିଂ, ଏ ଟଣ୍ଡାର୍‌ ଏପେଙ୍ଗ୍‌ ପୁନାଟ୍‌, ମସାତି ଲାହାଂ ମୁକ୍‌ଡ଼ା ଆଦେଂ ଆଡ୍‌ୱାତାର୍‌, ମାପ୍ରୁ ଜିସୁ ହୁକେ କେବଲ୍‌ ପାପ୍‌ କେମାନି ଆପେଂ ପର୍‌ଚାର୍‌ କିୟା ଆନାତା । ");
INSERT INTO peg_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","ମସାତି ବିଦି ହୁଦାଂ ପାପ୍‌ କେମା ପାୟାୱିତି ୱିଜ଼ାର୍‌ ହେ ଜିସୁ ହୁକେ ପାର୍ତି କିନି କାଜିଂ ହେ ପାପ୍‌ କେମା ପାୟାନାର୍‌ ଇଦାଂ ଏପେଙ୍ଗ୍‌ ବୁଜାନି ଲଡ଼ା । ");
INSERT INTO peg_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","ଲାଗିଂ ଜାଗ୍ରତ୍‌, ଏଚେକାଡ଼୍‌ଦ ବେଣ୍‌ବାକ୍‌ଣାୟ୍‌କିନାକାର୍‌ ସାସ୍ତର୍‌ର୍ତ ଇନାକା ଇନ୍ୟାତାତ୍‍ନ୍ନା, ହେଦାଂ ଇନେସ୍‌ ମି କାଜିଂ ଗିଟାମେତ୍, ");
INSERT INTO peg_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","“ଏ ମାନିକିୱି ଲଗୁ, ଏପେଙ୍ଗ୍‌ ହୁଡ଼୍‌ଜି, ଆରେ କାବା ଆଜ଼ି ନସ୍ଟ ଆଡୁ; ଲାଗିଂ ଆନ୍‌ ମି ୱେଡ଼ାଲିଂ ର କାମାୟ୍‌ ପୁରା କିତାଂନ୍ନା, ଜଦି ଇନେର୍‌ ହେ କାମାୟ୍‌ ମି ତାକେ ହାନ୍ଦାୟ୍ କିତିସ୍‌, ୱାଟିଙ୍ଗ୍‌ ଏପେଙ୍ଗ୍‌ ମୁଡ଼୍‌କେ ହେଦେଲିଂ ପାର୍ତି କିମାଟ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","ପାଉଲ୍‌ ଆରି ବର୍ଣ୍ଣବା ହସି ହାନି ୱେଡ଼ାଲିଂ, ଇନେସ୍‌ ଆର୍କାତ୍‌ ଜମ୍‌ନିବାର୍‌ତ ହେ ସବୁ ବଚନ୍‌ ହେୱାରିଂ ଇନ୍ୟାନାତ୍ ? ଇଦାଂ କାଜିଂ ହେୱାର୍‌ ଗୱାରି କିଦେଙ୍ଗ୍‌ ଲାଗାତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","ମିଟିଂ ଇଲ୍‌ ୱିଜ଼ୁତି ପାଚେ ଜିହୁଦି ଆରି ଜିହୁଦି ମାତ୍‍ଣିୟାର୍ ପାର୍ତିକିୱି ଜିହୁଦିର୍‌ ବିତ୍ରେ ବେସି ପାଉଲ୍‌ ଆରି ବର୍ଣ୍ଣବାତି ପାଚେ ପାଚେ ହାଚାର୍‌, ହେୱାର୍‌ ପକ୍ୟାତାକାରିଂ ହୁକେ କାତାବାର୍ତା କିଜ଼ି ଇସ୍ୱର୍‌ତି ଦୟାତ ତିର୍‌ ଆଜ଼ି ମାଞ୍ଜେଙ୍ଗ୍ ହେୱାରିଂ ରାଜ଼ି କିକିତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","ଆରେ, ଆର୍କାତ୍‌ ଜମ୍‌ନିବାର୍‌ତ ୱିଜ଼ାକାର୍‌ ଗାଡ଼୍‌ନି ଲକୁ ମାପ୍ରୁତି ବଚନ୍‌ ୱେଞ୍ଜେଙ୍ଗ୍‌ କାଜିଂ ରୁଣ୍ଡା ଆତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","ମାତର୍‌ ଜିହୁଦିର୍‌ ମାନାୟାରିଂ ହୁଡ଼୍‌ଜି ରିସାତ ବାର୍ତି ଆତାର୍‌, ଆରେ ନିନ୍ଦା କିଉ କିଉ ପାଉଲ୍‌ତି କାତାତ ଆଡୁଙ୍ଗ୍‌ ଆଦେଂ ଲାଗାତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","ହେବେଣ୍ଡାଂ ପାଉଲ୍‌ ଆରି ବର୍ଣ୍ଣବା ସାସ୍‌ତାଂ ଇଚାର୍‌, ଆଗେ ମି ଲାଗେ ଇସ୍ୱର୍‌ତି ବଚନ୍‌ ଇନାକା ମାଚାତ୍‌; ଏପେଙ୍ଗ୍‌ ହେଦାଂ ମୁନାକିଜ଼ି ଜାର୍‌ ଜାର୍‌ତିଂ ୱିଜ଼୍‌ୱି ଜିବୁନ୍‌ନି ଆଟ୍‌କାଡ଼୍‌ ଇଞ୍ଜି ବିଚାର୍‌ କିଜ଼ି ମାଚିଲେ, ହୁଡ଼ାଟ୍‌, ଆପେଂ ପାର୍ତିକିୱି ଜିହୁଦି ତାକେ ହାନାପା, ");
INSERT INTO peg_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","ଇନାକିଦେଂକି ମାପ୍ରୁ ମାଂ ଇ ବାନି ବଲ୍‌ ହିତ୍‌ତାର୍ଣ୍ଣା, “ଆପେଂ ପାର୍ତିକିୱି ଜିହୁଦି ଅଜଡ଼୍‌ ଲାକେ ମିଙ୍ଗ୍‌ ରଚ୍‍ଚାତାପ୍‍ନ୍ନା, ଇନେସ୍‌ ଏପେଙ୍ଗ୍‌ ପୁର୍ତିନି ହାନ୍ଦି ପାତେକ୍‌ ମୁକ୍ତିନି ଲାକେ ଆନାଦେର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","ପାର୍ତିକିୱି ଜିହୁଦିର୍‌ ଇଦାଂ ୱେନ୍‌ଞ୍ଜି ୱାର୍‌ୟା ଆତାର୍‌; ଆରେ, ମାପ୍ରୁତି ବଚନ୍‌ନି ଜାଜ୍‌ମାଲ୍‌ କିଦେଙ୍ଗ୍‌ ଲାଗାତାର୍‌, ଆରେ ଏଚେକ୍‌ ମାନାୟ୍‌ ୱିଜ଼୍‌ୱି ଜିବୁନ୍‌ନି କାଜିଂ ବାଚିକିୟା ଆଜ଼ି ମାଚାଦେର୍‌, ହେୱାର୍‌ ପାର୍ତି କିତାର୍‌, ");
INSERT INTO peg_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","ଆରେ ୱିଜ଼ୁ ନିପ ମାପ୍ରୁତି ବଚନ୍‌ ମେଙ୍ଗ୍‌ଜି ହାତାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","ମାତର୍‌ ଜିହୁଦି ଦରମ୍‌ ପାର୍ତିକିୱି ଜିହୁଦିର୍‌ ଗାଜା କଗ୍‍ଲେକାଂ ଆରି ଗାଡ଼୍‌ନି ମୁଡ଼୍‍ଦି ମୁଡ଼୍‍ଦି ମୁଣିକାରିଂ ଜିହୁଦିର୍‌ ଚେଗାୟ୍‌ କିତାର୍‌, ଆରେ ପାଉଲ୍‌ ଆରି ବର୍ଣ୍ଣବାତି ଜପି ନିନ୍ଦା ଗିଟାୟ୍‍ କିଜ଼ି ଜାର୍‌ ହାନ୍ଦିତାଂ ହେୱାରିଂ ହପ୍‍ଚି ତୁହିତାର୍ । ");
INSERT INTO peg_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","ହେବେଣ୍ଡାଂ ପକ୍ୟାତାକାର୍‌ ଜାର୍‌ ଜାର୍‌ ପାନାନି ଦୁଡ଼ି ହେୱାର୍‌ ବିରୁଦ୍‌ତ ଡ଼ାତ୍‍ତି ଇକନିୟତ ହାଚାର୍‌, ");
INSERT INTO peg_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","ଆରେ ଆନ୍ତିକିୟ ଚେଲାର୍‌ ୱାରିତ ଆରି ପୁଇପୁୟା ଜିବୁନ୍‌ତ ବାର୍ତି ଆଦେଂ ଲାଗାତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","ଇକନିୟତ ପା ହେ ଲାକେ ଗିଟାତାତ୍; ପାଉଲ୍‌ ଆରି ବର୍ଣ୍ଣବା ଜିହୁଦିର୍‌ ପାର୍ତାନା ଇଞ୍ଜ ହଣ୍‌ଜି ଏଲେଙ୍ଗ୍‌ ପର୍‌ଚାର୍‌ କିତାର୍‌ ଜେ, ଜିହୁଦି ଆରି ଗ୍ରିକ୍‌ତି ବିତ୍ରେ ବେସି ଲକୁ ପାର୍ତି କିତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","ମାତର୍‌ ଇମ୍‌ଣି ଜିହୁଦିର୍‌ ପାର୍ତି କିୱାତାର୍‌, ପକ୍ୟାତାକାର୍‌ ପାର୍ତିକିୱି ଜିହୁଦି ୱାସ୍କିତିଂ ଟିଉଲାୟ୍‌ କିଜ଼ି ଟଣ୍ଡାର୍‌ ବିରୁଦ୍‌ତ ବାନ୍ୟା ବାବ୍‍ନା ହପ୍‍ଚି ହିତାର୍ । ");
INSERT INTO peg_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","ପାଉଲ୍‌ ଆରି ବର୍ଣ୍ଣବା ବେସି ଦିନ୍‌ ପାତେକ୍‌ ହେ ବାହାତ ମାନ୍‌ଞ୍ଜି ମାପ୍ରୁତି ଜପି ବାର୍ସି କିଜ଼ି ସାସ୍‌ତାଂ ପର୍‌ଚାର୍‌ କିତାର୍‌; ଆରେ, ହେୱାର୍‌ତି କେଇ ହୁଦାଂ ବାର୍‍ବିନ୍ ଚିନ୍‌କୁ ଆରି କାବାନି କାମାୟ୍‌ କିଜ଼ି ଜାର୍‌ ଦୟାନି ବଚନ୍‌ ପାକ୍ୟାତ ସାକି ହିତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","ମତର୍‌ ଗାଡ଼୍‌ନି ଲକୁ ରିବାଗ୍‌ ଆତାର୍‌, ହେୱାର୍‌ ବିତ୍ରେତାଂ କେତ୍‌ଜାଣ୍‌ ଜିହୁଦିରିଂ ଆରି କେତେକ୍‌ ପକ୍ୟାତାକାର୍‌ରିଂ ବାଚି କିତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","ଏଚେକାଡ଼୍‌ଦ ପାର୍ତିକିୱି ଜିହୁଦିର୍‌ ଆରି ଜିହୁଦିର୍‌ ହେୱାର୍‌ତି ମୁଣିକା ହୁଦାଂ ହେୱାର୍‌ତି ଉତ୍‍ପାତ୍ କିଦେଙ୍ଗ୍‌ ଆରି କାଲ୍‌କୁ ଇଡ୍‌ଦେଂ ତିର୍‌ କିତାର୍‌, ");
INSERT INTO peg_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","ହେ ଏଚେକାଡ଼୍‌ଦ ପକ୍ୟାତାକାର୍‌ ହେଦାଂ ପୁଞ୍ଜି ଲୁକାୟନିଆନି ଲୁସ୍ତ୍ରା ଆରି ଦର୍ବି ଗାଡ଼୍‌, ଆରେ ଚାରିବେଣ୍‍ତି ନିପ ହନ୍‍ଚି ହାଚାର୍‌, ");
INSERT INTO peg_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","ଆରେ ହେୱାର୍‌ ନେକ୍ରିକାବୁର୍‌ ସୁଣାୟ୍‌ କିଦେଙ୍ଗ୍‌ ଲାଗାତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","ଲୁସ୍ତ୍ରାତ ରୱାନ୍‌ ମାନାୟ୍‌ ମାଚାନ୍‌, ହେୱାନ୍ତି ପାନା ବେମାର୍‌, ହେୱାନ୍‌ ଆୟା ପଟତାଂ ଚଟା, ଆରେ ହେୱାନ୍‌ ଇନାୱାଡ଼ାଂ ତାଂୱାଦାଂ ମାଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","ହେ ମାନାୟ୍‌ ପାଉଲ୍‌ତି ପର୍‌ଚାର୍‌ ୱେନ୍‌ଞ୍ଜି ମାଚାନ୍‌ । ପାଉଲ୍‌ ତାଙ୍ଗ୍‌ ମିଟ୍‌କିୱାଦାଂ ହୁଡ଼୍‌ଜି ଉଜ୍‌ ଆନି କାଜିଂ ତା ପାର୍ତି ମାଚିଲେ ହୁଡ଼୍‌ଜି ଗାଜା କାଟ୍‌ତାଂ ଇଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","ପାଉଲ୍‌ ଗାଜାକାଟ୍‍ତାଂ ଇଚାନ୍‌ “ପାନାତ ବଜ୍‌ ହିଜ଼ି ହାଣ୍‌କୁ ଆଜ଼ି ନିଲା ।” ହେବେ ହେୱାନ୍‌ ଚାର୍‌ବେଣ୍‌ତାଂ ତାଂଦେଂ ଲାଗାତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","ପାଉଲ୍‌ ଇନାକା କିତାନ୍‌ନ୍ନା, ଲକୁର୍ ହେଦାଂ ହୁଡ଼୍‌ଜି ଲୁକାୟନିଆ ବାସାତ ଗାଜାକାଟ୍‍ତ ଇଞ୍ଜେଙ୍ଗ୍‌ ଲାଗାତାନ୍‌, “ପେନ୍‍କୁ ମାନାୟ୍‌ ଲାକେ ମା ବିତ୍ରେତାଂ ଜୁଜ଼ି ୱାତାନ୍ନା ।” ");
INSERT INTO peg_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","ହେୱାର୍‌ ବର୍ଣ୍ଣବାତିଂ ଜିଅସ୍‌ ନଲେ ପେନ୍‍କୁ ଆରି ପାଉଲ୍‌ ମୁଡ଼୍‌ଦାକାନ୍‌ ମାଚିଲେ ହେୱାନିଂ ହେରମିସ୍‌ ନଲେ ବାଗ୍‌ ପେନ୍‌ ଇଞ୍ଜି ଇଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","ଗାଡ଼୍‌ ମୁମ୍‌ଦ ମାନି ଜିଅସ୍‌ ମନ୍ଦିର୍‌ତ ମାପ୍ରୁହେବାକିନାକାନ୍‌ କେତେକ୍‌ ସଣ୍ଡ୍‌ ଆରି ପୁଇମାଡ଼୍‌ ନି ଦୁୱେର୍‌ ଲାଗେ ତାହି ୱାଜ଼ି ପକ୍ୟାତାକାର୍‌ ହୁଦାଂ ପୁଜା ହିଦେଂ ମାନ୍‌ କିଜ଼ି ମାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","ମାତର୍‌ ପକ୍ୟାତାକାର୍‌, ଇଚିସ୍‌ ବର୍ଣ୍ଣବା ଆରି ପାଉଲ୍‌ ଇଦାଂ ୱେନ୍‌ଞ୍ଜି ଜାର୍‌ ଜାର୍‌ତିଂ ହେନ୍ଦ୍ରା କେଚ୍‌ଚି ଲକୁ ବିତ୍ରେ ବେଗି ହଞ୍ଚିହାଲ୍‍ଜି ଗାଜାକାଟ୍‌ତାଂ ଇଞ୍ଜେଙ୍ଗ୍‌ ଲାଗାତାର୍‌; ");
INSERT INTO peg_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“ଏ ଗାଜାକାଦେର୍, ଇନାକିଦେଂ ଇ ୱିଜ଼ୁ କିନାଦେରା ? ଆପେଂ ପା ମି ଲାକେ ମାନାୟ୍‌କାପ୍, ମି ଲାଗାଂ ଇ ନେକ୍ରିକାବୁର୍‌ ପର୍‌ଚାର୍ କିତାପ୍ନା, ଇନେସ୍‌ ଏପେଙ୍ଗ୍‌ ଇ ସବୁ ଆହାର୍ ଆଡ଼୍‍ମାଡ଼୍‍ତାଂ ମାସ୍‌ଦି ଜିଜ଼ି ମାନାକା ଇସ୍ୱର୍‌ତି କାଜିଂ ମାସ୍‍ଦାନାର୍ । ହେୱାନ୍‌ ବାଦାଡ଼୍‌ତ ସବୁ, ପୁର୍ତି, ହାମ୍‌ଦୁର୍‌ ଆରି ହେ ସବୁତ ମାନି ୱିଜ଼ୁ ଉବ୍‌ଜାଣ୍‌ କିତାନ୍‌ନ୍ନା; ");
INSERT INTO peg_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","ହେୱାନ୍‌ ଆଗେତାଂ ଆଣ୍ଡ୍ରାଂ ଦାରାମେରା ୱିଜ଼ୁ ଜାତିନି ଲଗାଂ ଜାର୍‌ ଜାର୍‌ ହାସ୍‌ଦ ତାଂଦେଂ ପିସ୍ତି ହିଜ଼ି ମାଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","ଆତିସ୍‌ପା ହେୱାନ୍‌ ଜାର୍‌ତିଂ ସାକି ହିଲ୍‍ୱି କାଜିଂ ଇଟ୍‍ୱାତାନ୍ନା, ଇନାକିଦେଂ ହେୱାନ୍‌ ହାର୍‌ କିତ୍‌ତାନ୍‌ନା, ଆରେ ଆକାସ୍‌ତାଂ ବାର୍ହା ଆରି ପାଡ଼୍‍ହିନି କାଡ଼୍‌ ହିଜ଼ି ଇଟ୍‌କାଡ଼୍‌ ଆରି ୱାରିତାଂ ମିଙ୍ଗେଙ୍ଗ୍‌ ମାନ୍ତ ସାରି କିତ୍‌ତାନ୍‌ନା ।” ");
INSERT INTO peg_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","ଇ ସବୁ କାତା ଇଞ୍ଜି ହେୱାର୍‌ ବେସି କସ୍ଟତ ହେୱାର୍‌ କାଜିଂ ପୁଜା କିତିଲେ ଲକୁରିଂ ଚିମ୍‌ରା କିତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","ମାତର୍‌ ଆନ୍ତିୟକିଆ ଆରି ଇକନିୟତାଂ ହେବେ ଜିହୁଦିର୍‌ ୱାଜ଼ି ଲକୁରିଂ ବୁଜାୟ୍‌ କିତାର୍‌, ଆରେ ପାଉଲ୍‌ତିଂ କାଲ୍‌କୁ ଇଡ଼୍‌ଜି ହେୱାନ୍‌ ହାତାନ୍ନା ଇଞ୍ଜି ବାବି କିଜ଼ି ବାର୍ତ ଜେଲ୍‍ଜି ଅତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","ମତର୍‌ ଚେଲାର୍‌ ହେୱାନିଂ ଚାର୍‍ବେଣ୍‍ତାଂ ନିଲ୍‍ତିଲେ ହେୱାନ୍‌ ନିଂଜି ଗାଡ଼୍‌ଦ ହଟାନ୍ । ଆର୍କାତ୍‌ ନାଜିଂ ବର୍ଣ୍ଣବାତି ହୁଦାଂ ଦର୍ବିତ ହସି ହାଚାର୍ । ");
INSERT INTO peg_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","ପାଉଲ୍‌ ଆରି ବର୍ଣ୍ଣବା ହେ ଦର୍ବିତ ନେକ୍ରିକାବୁର୍‌ ସୁଣାୟ୍‌ କିଜ଼ି ଆରି ହେନିରିଂ ଚେଲା ଆତାକା ପାଚେ ଲୁସ୍ତ୍ରା, ଇକନିୟ ଆରି ଆନ୍ତିୟକିଆତ ମାସ୍‌ଦି ୱାତାର୍, ");
INSERT INTO peg_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","ଆରେ, ହେ ବାହାକାଂ ଚେଲାର୍‍ତି ୱାସ୍କିତିଂ ସୁସ୍ତା କିତାର୍‌ ଆରି ପାର୍ତିତ ଡାଟ୍‌ ମାନି କାଜିଂ ହେୱାରିଂ ୱାରିକିୟ୍‌ କିଜ଼ି ଇଚାର୍‌, ବେସି ଦୁକ୍‌ କସ୍ଟ ପା ହିଜ଼ି ମାଂ “ଇସ୍ୱର୍‌ତି ରାଜିତ ହଣ୍ଡେଙ୍ଗ୍‌ ଆନାତ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","ଆରେ, ହେୱାର୍‌ ହେୱାର୍‌ କାଜିଂ ଜାଣ୍‍କେ ମଣ୍ଡ୍‌ଲିତ ପ୍ରାଚିନାରିଂ ବାଚି କିଜ଼ି ଉପାସ୍‌ ହୁଦାଂ ପାର୍ତାନା କିତାର୍‌, ଆରେ ଇମ୍‌ଣି ମାପ୍ରୁ ତାକେ ହେୱାର୍‌ ପାର୍ତି କିଜ଼ି ମାଚାର୍‌, ହେୱାନ୍ତି କେଇଦ ହେୱାରିଂ ହେଲାୟ୍‌ କିତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","ପାଚେ ହେୱାର୍‌ ପିସିଦିଆ ନିପ ହିଜ଼ି ପଂପୁଲିଆତ ୱାତାର୍, ");
INSERT INTO peg_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","ଆରେ ପର୍ଗିତ ବଚନ୍‌ ପର୍‌ଚାର୍‌ କିଜ଼ି ଆତାଲିଆତ ହାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","ହେବେତାଂ ଜାଜ୍‌ତ ଦୁମ୍‌ଜି ହେୱାର୍‌ ଆନ୍ତିୟକିଆତ ମାସ୍‌ଦି ୱାତାର୍‌, ହେୱାର୍‌ ଇମ୍‌ଣି କାମାୟ୍‌ କିଜ଼ି ମାଚାର୍‌, ହେଦାଂ କିନି କାଜିଂ ଇସ୍ୱର୍‌ତି ଦୟାତ ହେଲାୟ୍‌ କିୟା ଆଜ଼ି ହେ ବାହାତାଂ ହସି ମାଚାର୍‍ । ");
INSERT INTO peg_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","ହେୱାର୍‌ ଆନ୍ତକିଆତ ଏକିସ୍‌ ମଣ୍ଡ୍‌ଲିନି ମାନାୟାରିଂ ରବେ କିତାର୍‌, ଇସ୍ୱର୍‌ ହେୱାର୍‌ କାଜିଂ ଇନାକା ସବୁ କିଜ଼ି ମାଚାତ୍‌ ଆରି ପାର୍ତିକିୱି ଜିହୁଦିର୍‌ କାଜିଂ ପାର୍ତିନି ଦୁୱେର୍‌ ଇନେସ୍‌ ଜେସି ମାଚାର୍‌ ହେ ସବୁ ହେୱେକାଂ ୱେଚ୍‍ଚାର୍ । ");
INSERT INTO peg_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","ଆରେ, ହେୱାର୍‌ ଚେଲାର୍‌ ହୁଦାଂ ବେସି ଦିନ୍‌ ପାତେକ୍‌ ମାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","ଇଦାଂ ବିତ୍ରେ ଏଚେକ୍‌ ଲକୁ ଜିହୁଦା ରାଜିତାଂ ୱାଜ଼ି ପାର୍ତି କିନି ଟଣ୍ଡାର୍‌ରିଂ ଇ ହିକ୍ୟା ହିଦେଂ ଲାଗାତାର୍‌, “ମସାତି ବିଦି ଇସାପ୍ରେ ଏପେଙ୍ଗ୍‌ ସୁନ୍ନତ୍‌ ଆୱିତିସ୍‌ ରାକ୍ୟା ପାୟାଦେଂ ଆଡୁଦେର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","ଇବେ ପାଉଲ୍‌ ଆରି ବର୍ଣ୍ଣବାତି ହେୱାର୍‌ ହୁକେ ବେସି ଜିକାଟାଣା ଆରି କାତାତ ଜିକାଜିକି ଆତିଲେ ଟଣ୍ଡାର୍‌ ପାଉଲ୍‌ ବର୍ଣ୍ଣବ୍‍ବା ଆରି ଜାର୍‌ ବିତ୍ରେ ଆରେ ଏଚେଜାଣ୍ ଇ ପର୍‌ସନ୍‌ ଅଜ଼ି ଜିରୁସାଲମ୍‌ତ ପକ୍ୟାତାକାର୍‌ ଆରି ପ୍ରାଚିନାର୍‌ ଲାଗେ ହାଲେର୍ ଇଞ୍ଜି ତିର୍‌ କିତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","ଲାଗିଂ, ମଣ୍ଡ୍‌ଲି ହେୱାରିଂ ହାଜ଼ି ଚଚ୍‍ଚି ହେଲ ହିତି ପାଚେ ହେୱାର୍‌ ପୈନିକିଆ ଆରି ସମିରଣ୍‌ ହିଜ଼ି ହାଲୁ ହାଲୁ ପାର୍ତିକିୱି ଜିହୁଦିର୍‌ ମାନ୍‌ବାଦ୍‌ଲାୟ୍‌ ବିସ୍ରେ ହାନ୍ଦାୟ୍‍ କିଜ଼ି ୱିଜ଼ାର୍‌ ଟଣ୍ଡାର୍‌ତି ବେସି ୱାରିହପ୍‌ତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","ପାଚେ ହେୱାର୍‌ ଜିରୁସାଲମ୍‌ତ ଇକିସ୍‌ ମଣ୍ଡ୍‌ଲି, ଆରେ ପକ୍ୟାତାକାର୍‌ ଆରି ପ୍ରାଚିନାର୍‌ ହୁଦାଂ ବାନ୍ଦାୟ୍‌ ପାୟାତାର୍‌, ଆରେ ଇସ୍ୱର୍‌ ହେୱାର୍‌ ଲାହାଙ୍ଗ୍‌ ମାନ୍‌ଞ୍ଜି ଇନେସ୍‌ ୱିଜ଼ୁ କାମାୟ୍‌ କିଜ଼ି ମାଚାନ୍‌, ହେ ସବୁ ହାନ୍ଦାୟ୍‍ କିତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","ମାତର୍‌ ପାରୁସି କୁଦାନି କେତେକ୍‌ ଜାଣ୍‌ ପାର୍ତିନିକାର୍‌ ନିଂଜି ଇଚାର୍‌, “ପାର୍ତିକିୱି ଜିହୁଦିର୍‌ ଚେଲାରିଂ ସୁନ୍ନତ୍‌ କିନାସ୍‌ ଆରି ମସାତି ବିଦି ମାନି କିଦେଙ୍ଗ୍‌ କାଜିଂ ହେୱାରିଂ ବଲ୍‌ ହିନାକା ଲଡ଼ା ।” ");
INSERT INTO peg_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","ପାଚେ ଇ ବିସ୍ରେ କାତାବାର୍ତା କିନି କାଜିଂ ପକ୍ୟାତାକାର୍‌ ଆରି ପ୍ରାଚିନାର୍‌ ରୁଣ୍ଡା ଆତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","ବେସି କାତାବାର୍ତା ଆତି ପାଚେ ପିତର୍‌ ନିଂଜି ହେୱାରିଂ ଇଚାନ୍‌, “ଏ ଟଣ୍ଡାର୍‌, ତଣ୍‌ଦେକ୍‌ ଏପେଙ୍ଗ୍‌ ପୁଚାଦେର୍ଣ୍ଣା ଜେ, ନା ୱେଇ ହୁଦାଂ ପାର୍ତିକିୱି ଜିହୁଦିର୍‌ ଇନେସ୍‌ ନେକ୍ରିକାବୁର୍‌ ୱେନ୍‌ଞ୍ଜି ପାର୍ତି କିତାର୍‌, ଇଦାଂ କାଜିଂ ବେସି ଦିନ୍‌ ଆଗେ ଇସ୍ୱର୍‌ ବିତ୍ରେତାଂ ନାଙ୍ଗ୍‌ ବାଚି କିତ୍‌ତାନ୍‌ନା । ");
INSERT INTO peg_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","ୱାସ୍କି ପୁନି ଇସ୍ୱର୍‌ ମାଂ ଇନେସ୍‌ ପୁଇପୁୟା ଜିବୁନ୍‌ ହିତ୍‍ତାନ୍ନା, ପାର୍ତିକିୱି ଜିହୁଦିର୍‌ ପା ହେ ଲାକେ ହିଜ଼ି ହେୱାର୍‌ ପାକ୍ୟାତ ସାକି ହିନାନା । ");
INSERT INTO peg_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","ଆରେ, ହେୱାନ୍‌ ମାଂ ଆରି ହେୱାର୍‌ ବିତ୍ରେ ଇନାକାପା ବିନ୍‌ ତାରେନ୍‌ ଇଟ୍‌ୱାଦାଂ ପାର୍ତି ହୁକେ ହେୱାର୍‌ ମାନ୍ତ ସକଟ୍‌ କିତାନ୍‌ନ୍ନା । ");
INSERT INTO peg_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","ଲାଗିଂ ଇମ୍‌ଣି ଜୁୱାଣ୍ଡ୍‌ତ ମାଂ ଆବା ଲାତ୍ରା ଆରି ଆସେଙ୍ଗ୍‌ ପିଣ୍‌ଦେଂ ସାକ୍ତି ହିଲୁତ୍‌, ହେ ଜୁୱାଣ୍ଡ୍‌ ଚେଲାର୍‌ ନିପିତ ହିଜ଼ି ଇନାକିଦେଂ ଏପେଙ୍ଗ୍‌ ଇସ୍ୱର୍‌ତିଂ ପରିକ୍ୟା କିନାଦେରା ? ");
INSERT INTO peg_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","ଆକାୟ୍‌ ଇଦାଂ ସମାନ୍‌ ଆକାୟ୍‌ ହେୱାର୍‌ ଇନେସ୍‌ ପାର୍ତି କିଜ଼ି ରାକ୍ୟା ଆତାର୍ଣ୍ଣା, ଆପେଂ ପା ସମାନ୍‌ ହେ ଲାକେ ପାର୍ତି କିଜ଼ି ମାପ୍ରୁ ଜିସୁତି ଉପ୍‌କାର୍‌ ଦୟା ପାୟାତାପ୍‌ନା ।” ");
INSERT INTO peg_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","ଇବେ ସବାନିକାର୍ ଚିମ୍ରା ଆତାର୍‌, ଆରେ ବର୍ଣ୍ଣବା ଆରି ପାଉଲ୍‌ ହୁଦାଂ ପାର୍ତିକିୱି ଜିହୁଦିର୍‌ ବିତ୍ରେ ଇସ୍ୱର୍‌ ଇନେସ୍‌ ୱିଜ଼ୁ ଚିନ୍‌କୁ ଆରି କାବାନି କାମାୟ୍‌ କିଜ଼ି ମାଚାନ୍‌, ହେୱାର୍‌ ତାଙ୍ଗ୍‌ ହେବେନି ବିସ୍ରେ ୱେଞ୍ଜେଙ୍ଗ୍‌ ଲାଗାତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","ହେୱାର୍‌ କାତା ୱିସ୍ତି ପାଚେ ଜାକୁବ୍‌ ଉତର୍‌ ହିଜ଼ି ଇଚାନ୍‌, “ଏ ଟଣ୍ଡାର୍‌, ଆରି ତଣ୍‌ଦେକ୍‌ ନା କାତା ୱେନାଟ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","ଇସ୍ୱର୍‌ ଜାର୍‌ ତର୍‌ କାଜିଂ ପାର୍ତିକିୱି ଜିହୁଦିର୍‌ ବିତ୍ରେତାଂ କୁଦା ମାନାୟ୍‌ ଇଟ୍‌ଦେଂ ଇଞ୍ଜି ଇନେସ୍‌ ପର୍ତୁମ୍‌ ହେୱାର୍‌ କାଜିଂ ଦୟା ହୁଡ଼୍‌ଜି ମାଚାନ୍‌, ହେଦାଂ ସିମନ୍‌ ବୁଜାୟ୍‌ କିତାନ୍‌ନ୍ନା । ");
INSERT INTO peg_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","ଆରେ, ବେଣ୍‌ବାକ୍‌ଣାୟ୍‌କିନାକାର୍‌ ବଚନ୍‌ ଇଦାଂ ସବୁ ପୁରା ବାବ୍ରେ ମେହା ଆନାତା, ଇନେସ୍‌ ସାସ୍ତର୍‌ତ ଲେକାମାନାତ୍‌, ");
INSERT INTO peg_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘ମାପ୍ରୁ ଇନାନ୍‌’ ଇଦାଂ ପାଚେ ଆନ୍‌ ମାସ୍‌ଦି ୱାନାଙ୍ଗ୍‌ ଆରି ଦାଉଦ୍‌ତି ମୁନ୍‌ଚି ଇଲ୍‌ ଆରେ ରଚ୍‍ନାଙ୍ଗ୍, ଆନ୍‌ ତାଦାଂ ଦୁଡ଼ି ମାସ୍‍ତାକା ସବୁ ଆରେ ରଚ୍‍ଚି ହେଦାଂ ଆରେ ରଗ ସାକ୍ତି କିନାଙ୍ଗ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","ସବୁ ମାନାୟ୍‌ ଜାତି ନା ଲାଗାୟ୍‌ ପାର୍ତାନା କିଦେଙ୍ଗ୍‌ ୱାନାର୍‌, ଇମ୍‌ଣି ପାର୍ତିକିୱି ଜିହୁଦି ମା ତର୍‌ଦ ଡାକ୍‌ପୁଟା ହେୱାର୍‌ ମାପ୍ରୁଙ୍ଗ୍‌ ଡେକ୍‌ନାର୍‌, ସବୁ ସାଦନ୍‌ କାର୍‌ୟା ମାପ୍ରୁ ଇଦାଂ ଇନାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","ପ୍ଡାନି ସମୁତାଂ ଇସ୍ୱର୍‌ ଜାର୍‌ ୱିଜ଼ୁ କାମାୟ୍‌ ୱେଚ୍‌ଚାତାନ୍ନା ।” ");
INSERT INTO peg_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","ଲାଗିଂ, “ନା ବିଚାର୍‌ ଇଦାଂ,” ପାର୍ତିକିୱି ଜିହୁଦିର୍‌ ବିତ୍ରେ ଇମ୍‌ଣାକାର୍‌ ଇସ୍ୱର୍‌ ନିପ ମାସ୍‍ଦାନାର୍, ହେୱାରିଂ ଆପ୍‌ କସ୍ଟ ହିଉପ୍, ");
INSERT INTO peg_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","ମତର୍‌ ପୁତ୍‌ଡ଼ାକାଂ ପୁଜାକିନାକା ବିସ୍ରେ ବିଟାଡ଼୍‌, ଲକାର୍‌ ଦାରି, ଆତାକା ହୁଦାଂ ହାତି ପାରାଣିଙ୍ଗ୍‌ ଆରି ନେତେର୍‌ତାଂ ବିନେ ମାନି କାଜିଂ ଆପ୍‌ ହେୱାରିଂ ଲେକି କିନାପ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","ଇନାକିଦେଂକି ପ୍ଡାନି କାଡ଼୍‍ଦାଂ ସବୁ ଗାଡ଼୍‌ଦ ମସାତି ବିଦି ସୁଣାୟ୍‌ କିଦେଙ୍ଗ୍‌ ମାନାର୍‌, ଲାଗିଂ ପାତି ଜମ୍‌ନିବାର୍‌ତ ପାର୍ତାନା ଇଲ୍‌ ୱିଜ଼ୁ ହେୱାନ୍ତି ବିଦି ପାଟ୍ ସୁଣାୟ୍‌ କିୟାନାତା । ");
INSERT INTO peg_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","ହେପାଦ୍‌ନା ପକ୍ୟାତାକାର୍‌ ଆରି ପ୍ରାଚିନାର୍‌ ୱିଜ଼ାର୍‌ ମଣ୍ଡ୍‌ଲି ହୁଦାଂ ଜାର୍‌ତିଂ ବିତ୍ରେ ମାନାୟାର୍‌, ଇଚିସ୍‌ ଟଣ୍ଡାର୍‌ ବିତ୍ରେ ଆଦିକ୍‌ ବର୍ସବା ତର୍‌ଦ ଡାକ୍‍ପୁଟ ଜିହୁଦା ଆରି ସିଲାତିଂ ବାଚି କିଜ଼ି ପାଉଲ୍‌ ଆରି ବର୍ଣ୍ଣବା ଲାହାଙ୍ଗ୍‌ ଆନ୍ତିୟକିଆତ ପକ୍‍ତେଂ ବାଚି କିତାର୍‌, ");
INSERT INTO peg_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","ଆରେ, ପାର୍ତି କିନାକାରିଂ ହେୱାର୍‌ତି କେଇଦ ଇଦାଂ ଲେକି କିଜ଼ି ପକ୍ତାର୍‌ । “ଆନ୍ତିୟକିଆ, ପାର୍ତି କିନାର୍ ସିରିୟା ଆରି କିଲିକିୟାନି ପାର୍ତିକିୱି ଜିହୁଦି ଟଣ୍ଡାର୍‌ରିଂ ପକ୍ୟାତାକାର୍‌ ଆରି ପ୍ରାଚିନ୍‌ ଟଣ୍ଡାର୍‌ରିଂ ଜୱାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","ଆପେଂ ୱେଚାପ୍‍ନ୍ନା ଜେ, ଆପେଂ ଇମ୍‌ଣି ମାନାୟାରିଂ ଇମ୍‌ଣାକା ପା ବଲ୍‌ ହିଉପେ, ମା ବିତ୍ରେ ଇବାନି ଏଚେକ୍ ଲଗୁ କାତା ହୁଦାଂ ମି ୱାସ୍କିତିଂ ତିର୍‌ କିୱାଦାଂ ମିଙ୍ଗ୍‌ କସ୍ଟ କିତ୍‍ତାର୍ଣ୍ଣା; ");
INSERT INTO peg_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","ଲାଗିଂ ଆସେଙ୍ଗ୍‌ ୱିଜ଼ାସ୍‌ ରବେ ଆଜ଼ି କେତ୍‌ ଜାଣ୍‌ କାବୁର୍‌ ଅନାକାରିଂ ବାଚି କିଜ଼ି ମି ତାକେ ପକ୍‌ତିନି କାଜିଂ ତିର୍‌ କିନାପା । ହେୱାର୍‌ ମା ୱାରିନି ହାଙ୍ଗ୍‌ୱାରି ବର୍ଣ୍ଣବା ଆରି ପାଉଲ୍‌ତି ଲାହାଂ ହାନାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","ଇ ଟଣ୍ଡାର୍‌ ମାପ୍ରୁ ଜିସୁ କ୍ରିସ୍ଟତି ହେବାତ ଜାର୍‌ ଜିବୁନ୍‌ତିଂ ବିପଦ୍‌ କିତାର୍ଣ୍ଣା । ");
INSERT INTO peg_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","ଲାଗିଂ ଆପେଂ ଜିହୁଦା ଆରି ସିଲାତିଂ ମି ତାକେ ପକ୍ତାନାପା । ଆପେଂ ଇନାକା ଲେକିକିତାପ୍‌ନା ହେଦାଂ, ହେୱାର୍‌ ହାର୍‌ ବାବ୍ରେ ହେଦାଂ ମିଙ୍ଗେଙ୍ଗ୍‌ ୱେଚ୍‌ଚାନାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","ଇନାକିଦେଂକି ପୁତ୍‍ଡ଼ା ଲାଗେ ପୁଜାକିତି ଆକାତ୍‌, ନେତେର୍‌, ନେଞ୍ଜ୍‍ୱି ହୁଦାଂ ହାତି ପାରାଣିତି ଜେ ଆରି ଲକାର୍‍ ଦାରିତାଂ ବିନେ ମାନାକା, ଇ ଏଚେକ୍‌ ଲଡ଼ାନି ବିସ୍ରେ ପିସ୍ତି ମି ଜପି ଆରେ ଆଦିକ୍‌ ବଜ୍‌ ହିଦ୍‍ୱାଦାଂ ପୁଇପୁୟା ଜିବୁନ୍‌ ଆରି ମା ନଂଜର୍‌ତ ବେସି ଇଚା ଆତାତ୍‌, ");
INSERT INTO peg_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","ହେ ଏଚେଗଟା ନିୟମ୍‌ ଆତାତ୍‌ ପୁତ୍‌ଡ଼ାକାଂ ଉଦେସ୍‌ ତାଂ ପୁଜାକିତି ଇମ୍‌ଣାକା କାଦି ତିନୁଦେର୍‌, ନେତେର୍‌ ଉଣୁଦେର୍‌, ଗାଡେଲ୍‌ ତ୍ଡିପ୍‌ଚି ଇମ୍‌ଣି ଜିବୁନିକାଂ ଜେଇ ତିନୁଦେର୍‌ ଆରି ଦାରିତାଂ ଦେହା ମାନାଟ୍‌ । ଇ ସବୁ କାମାୟ୍‌ କିୱାଦାଙ୍ଗ୍‌ ଜାଗ୍ରତ୍‌ ମାଚିସ୍‌, ମିଦାଙ୍ଗ୍‌ ହାରା ଆନାତ୍‌ । ମା ବାନ୍ଦାୟ୍‌ ଇଟାଟ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","ହେବେ କାବୁର୍‌ ହିନାକାର୍‌ ହେଲୱେୟ୍‌ ଅଜ଼ି ଆନ୍ତିୟକିଆତ ୱାତାର୍, ଆରେ ଚେଲାରିଂ ରୁଣ୍ଡାୟ୍‌ କିଜ଼ି ଚିଟି ହିତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","ହେୱାର୍‌ ହେଦାଂ ପଡ଼ି କିଜ଼ି ଦୁକ୍‌ସାରାୟ୍‌ ଗାଟାଜ଼ି ୱାର୍‌ୟା ଆତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","ଆରେ, ଜିହୁଦା ଆରି ସିଲା ନିଜ୍‍ ନିଜ୍‍ ପା ବେଣ୍‌ବାକ୍‌ଣାୟ୍‌କିନାକାର୍‌ ମାଚିଲେ ଆଦେକ୍‌ କାତା ହୁଦାଂ ଟଣ୍ଡାର୍‌ରିଂ ୱାରିକିୟ୍‌ କିଜ଼ି ହେୱାରିଂ ସୁସ୍ତା କିତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","ଆରେ, ହେୱାର୍‌ ହେବେ ଏଚେକ୍‌ ଦିନ୍‌ ମାଚି ପାଚେ ହେୱାର୍‌ ପକ୍‌ଚି ମାଚି ଲକୁ ଲାଗାୟ୍‌ ମାସ୍‌ଦି ହାଞ୍ଜେଙ୍ଗ୍‌ ପାର୍ତି କିନି ଟଣ୍ଡାର୍‌ତାଂ ସୁସ୍ତାତ ହେଲ ଅତାର୍‌, ");
INSERT INTO peg_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","ମାତର୍‌ ସିଲା ହେବେ ମାଞ୍ଜେଙ୍ଗ୍ ହାର୍‌ ବାବି କିତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","ପାଉଲ୍‌ ଆରି ବର୍ଣ୍ଣବା ଆନ୍ତିୟକିଆତ ମାନ୍‌ଞ୍ଜି ଆରେ ବିନ୍‌ ବିନ୍‌ ଆଦେକ୍‌ ଲକୁ ଲାହାଙ୍ଗ୍‌ ପା ମାପ୍ରୁତି କାତା ହିକ୍ୟା ହିଜ଼ି ନେକ୍ରିକାବୁର୍‌ ସୁଣାୟ୍‌ କିଦେଙ୍ଗ୍‌ ଲାଗାତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","କେତେକ୍‌ ଦିନ୍‌ ପାଚେ ପାଉଲ୍‌ ବର୍ଣ୍ଣବାଙ୍ଗ୍‌ ଇଚାନ୍‌, ଆସେଙ୍ଗ୍‌ ଇମ୍‌ଣି ସବୁ ଗାଡ଼୍‌ଦ ମାପ୍ରୁତି କାତା ପର୍‌ଚାର୍‌ କିଜ଼ି ମାଚାସ୍, ହେ ୱିଜ଼ୁ ଗାଡ଼୍‌ଦ “ନଙ୍ଗ୍‌ ମାସ୍‍ଦି ହାଲ୍‍ଜି ଟଣ୍ଡାରିଂ ବେଟାଜ଼ି, ହେୱାର୍‌ ଇନେସ୍‌ ମାନାର୍‌ ହୁଡ଼୍‌ନାସ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","ହେବେ ଜହନ୍‌ ମାର୍କ ତର୍‌ନି ଡାକ୍‍ପୁଟା ଜହନ୍‌ତିଂ ପା ହାଙ୍ଗ୍‌ ଅଦେଂ କାଜିଂ ବର୍ଣ୍ଣବାତି ମାନ୍‌ ମାଚାତ୍‌; ");
INSERT INTO peg_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","ମାତର୍‌ ହେୱାନ୍‌ ହେୱାରିଂ ପିସ୍ତି ପଂପୁଲିଆତ ୱାଜ଼ି ମାଚାନ୍‌ ଆରି ହେୱାର୍‌ ଲାହାଙ୍ଗ୍‌ କାମାୟ୍‌ତ ହାଲ୍‍ୱାଦାଂ ମାଚାନ୍‌, ହେୱାନିଂ ହାଙ୍ଗ୍‌ଦ ଅଦେଂ ପାଉଲ୍‌ ହାର୍‌ ବାବି କିୱାତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","ହେବେ ବେସି ଗଣ୍ଡ୍‌ଗଲ୍‌ ଆତିଲେ ହେୱାର୍‌ ହାରି ବିନେ ଆତାର୍‌, ବର୍ଣ୍ଣବା ମାର୍କଙ୍ଗ୍‌ ହାଙ୍ଗ୍‌ ଅଜ଼ି ଜାଜ୍‌ତ କୁଚ୍‌ଚି କୁପ୍ରତ ହାଚାର୍‌, ");
INSERT INTO peg_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","ମାତର୍‌ ପାଉଲ୍‌ ସିଲାଙ୍ଗ୍ ବାଚି କିଜ଼ି ଟଣ୍ଡାର୍‌ ହୁଦାଂ ମାପ୍ରୁତି ଦୟାତ ହେଲାୟ୍‌ ଆଜ଼ି ହାଚାର୍‌, ");
INSERT INTO peg_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","ଆରେ ହେୱାନ୍‌ ସିରିୟା ଆରି କିଲିକିୟା ହିଜ଼ି ହାଲୁ ହାଲୁ ମଣ୍ଡ୍‌ଲିକାଂ ବାଡ଼୍‌କାସ୍‌ କିତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","ପାଚେ ପାଉଲ୍‌ ଦର୍ବି ଆରି ଲୁସ୍ତ୍ରାତ ପା ୱାତାର୍, ଆରେ ହୁଡ଼ାଟ୍‌, ହେ ବାହାତ ତିମତି ତର୍‌ଦ ରୱାନ୍‌ ଚେଲା ମାଚାନ୍‌, ହେୱାନ୍‌ ରୱାନ୍‌ ପାର୍ତିନି ଜିହୁଦି କଗ୍‌ଲେନି ମାଜ଼ି ମାତର୍‌ ହେୱାନ୍‌ତି ଆବା ରୱାନ୍‌ ଗ୍ରିକ୍‌ ଲଗୁ । ");
INSERT INTO peg_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","ଲୁସ୍ତ୍ରା ଆରି ଇକନିୟତ ମାନି ପାର୍ତି କିନି ଟଣ୍ଡାର୍‌ ହେୱାନ୍ତି ସାକି ଡାକ୍‍ପୁଟାୟ୍‍ କିଜ଼ି ମାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","ତାଙ୍ଗେଙ୍ଗ୍ ହାଙ୍ଗ୍‌ଦ ଅଦେଂ ପାଉଲ୍‌ ଇଚା କିତାନ୍‌, ଆରେ ହେ ସବୁ ନିପ ମାନି ଜିହୁଦିର୍‌ କାଜିଂ ତାଙ୍ଗ୍‌ ଅଜ଼ି ସୁନ୍ନତ୍‌ କିତାନ୍‌; ଇନାକିଦେଂକି ତିମତି ଲାତ୍ରାହି ରୱାନ୍‌ ଗ୍ରିକ୍‌ ଲଗୁ ଇଞ୍ଜି ୱିଜ଼ାକାର୍‌ ପୁଞ୍ଜି ମାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","ଆରେ, ହେୱାର୍‌ ବିନ୍‌ ବିନ୍‌ ବସ୍ତି ହିଜ଼ି ହାଲୁ ହାଲୁ ଜିରୁସାଲମ୍‌ନି ପକ୍ୟାତାକାର୍‌ ଆରି ପ୍ରାଚିନାର୍‌ ହୁଦାଂ ରଚ୍‌ଚି ବଲ୍‌ ବିଚାର୍‌ ସବୁ ମାନି କିଦେଙ୍ଗ୍‌ ପାର୍ତି କିନାକାର୍‌ ଲାଗେ ହେଲାୟ୍‌ କିବିସ୍‍ ମାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","ଇ ବାନି ମଣ୍ଡ୍‌ଲି ନିକାର୍‌ ପାର୍ତିତ ଡାଟ୍‌ ଆଜ଼ି ଦିନ୍‌ତିଂ ଦିନ୍‌ ଇସାବ୍‌ରେ ବାଡାଦେଂ ଲାଗାତାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","ପୁଇପୁୟା ଜିବୁନ୍‌ ହେୱାର୍‌ ଆସିଆ ଦେସ୍‌ତ ପର୍‌ଚାର୍‌ କିଦେଙ୍ଗ୍‌ ମୁନା କିତ୍‌ଲେ ହେୱାର୍‌ ପ୍ରୁଗିଆ ଆରି ଗାଲାତିୟ ନିପ ହାଚାର୍‌, ");
INSERT INTO peg_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","ଆରେ, ହେୱାର୍‌ ମୁସିଆ ଲାଗାୟ୍‍ତ ଏକିସ୍ ବିତୁନିଆତ ହାଞ୍ଜେଙ୍ଗ୍‌ କାଜିଂ ସେସ୍ଟା କିତାର୍‌, ମତର୍‌ ଜିସୁତି ଜିବୁନ୍‌ ହେୱାରିଂ ହାଞ୍ଜେଙ୍ଗ୍‌ ହିୱାତାତ୍ । ");
INSERT INTO peg_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","ଲାଗିଂ ହେୱାର୍‌ ମୁସିଆ ଲାଗେ ହିଜ଼ି ତ୍ରୟାତ ୱାତାର୍ । ");
INSERT INTO peg_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","ଆରେ, ନାଣାଲିଂ ପାଉଲ୍‌ ର କେଚ୍‌କଣ୍‌ ଗାଟାତାନ୍‍, ମାକିଦନିଆନି ରୱାନ୍‌ ମାନାୟ୍‍ ଇଞ୍ଜ ତାଙ୍ଗ୍‌ ଗୱାରି କିଜ଼ି ଇନାନ୍ନା, ମାକିଦନିଆ ନାସି “ୱାଜ଼ି ମାଂ ଉପ୍‌କାର୍‌ କିଦା ।” ");
INSERT INTO peg_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","ପାଉଲ୍‌ ଇ କେଚ୍‌କଣ୍‌ ଗାଟାତି ପାଚେ ଆପେଂ ଦାପ୍ରେ ମାକିଦନିଆତ ହାଞ୍ଜେଙ୍ଗ୍‌ ଜାଲ୍‌ଦି କିତାପ୍, ଇନାକିଦେଂକି ହେୱାର୍‌ ଲାଗାୟ୍‌ ନେକ୍ରିକାବୁର୍‌ ପର୍‌ଚାର୍‌ କିଦେଙ୍ଗ୍‌ ଇସ୍ୱର୍‌ ମାଂ କୁକ୍‍ତାନ୍ନା ଇଞ୍ଜି ଆପେଂ ବୁଜାତାପ୍ । ");
INSERT INTO peg_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","ଲାଗିଂ ତ୍ରୟାତାଂ ଜାଜ୍‌ତ ଆପେଂ ହାଣ୍‍କୁ ହାସ୍‌ଦ ସାମତ୍ରାକିତ ହାଚାପ୍‌ ଆରି ଆର୍କାତ୍‌ ନାଜିଂ ନିୟାପଲିତ ଏକାତାପ୍ । ");
INSERT INTO peg_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","ହେବେତାଂ ପିଲିପିତ ହାଚାପ୍, ଇଦାଂ ମାକିଦନିଆନି ହେ ରାଜି ର ମୁଡ଼୍‌ ଗାଡ଼୍‌, ଆରେ ର ରମିୟ କଲ୍‍ନି, ହେ ଗାଡ଼୍‌ଦ ଆପେଂ କେତେକ୍‌ ଦିନ୍‌ ମାଚାପ୍ । ");
INSERT INTO peg_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","ଜମ୍‌ନିବାର୍‌ତ ଆପେଂ ଗାଡ଼୍‌ ଦୁୱାର୍‍ତାଂ ହସି ନାଗୁଡ଼୍‌ ଗୁଟିତ ହାଚାପ୍, ହେବେ ପାର୍ତାନାନି ବାହା ମାନାତ୍‌ ଇଞ୍ଜି ଆପେଂ ବାବି କିଜ଼ି ମାଚାପ୍, ଆରେ ଆପେଂ କୁଚ୍‌ଚି ରୁଣ୍ଡାଜ଼ି ମାନି ଆୟାତାଡ଼ିକାଂ କାତା ଇଞ୍ଜେଙ୍ଗ୍‌ ଲାଗାତାପ୍ । ");
INSERT INTO peg_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","ଆରେ, ତୁୟାତିରା ଗାଡ଼୍‌ଦ ୱାଙ୍ଗାବାର୍ତି ହେନ୍ଦ୍ରା ପ୍ରନି ଲୁଦିଆ ତର୍‌ନି ରଞ୍ଜେଲ୍‌ ତାଡ଼ି ମାଚାତ୍, ହେଦେଲ୍‌ ଜେ ଇସ୍ୱର୍‌ତିଂ ପାର୍ତାନା କିନାକାଦେଲ୍‌ ମାଚାତ୍‌, ହେଦେଲ୍‌ ମା କାତା ୱେନ୍‌ଞ୍ଜି ମାଚାତ୍‌ । ହେଦେଲ୍‌ ଇନେସ୍‌ ପାଉଲ୍‌ତି ଇଚି ବିସ୍ରେ କାଜିଂ ମାନ୍ତ ଦିଆନ୍‌ କିତାତ୍‌, ଇଦାଂ କାଜିଂ ମାପ୍ରୁ ହେଦେଲିଂ ମାନ୍‌ ଜେସି ହିତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","ଆରେ, ହେଦେଲ୍‌ ଆରି ତାଦେଲ୍‍ତି ପାର୍ତାନା ବାପ୍ତିସିମ୍‌ ଆତି ପାଚେ ହେଦେଲ୍‌ ମାଂ ଗୱାରି କିଜ଼ି ଇନ୍‍ଞ୍ଚାତ୍, ଏପେଙ୍ଗ୍‌ ଜଦି ନାଙ୍ଗ୍‌ “ମାପ୍ରୁତି ଲାଗେ ପାର୍ତି ଇଞ୍ଜି ବିଚାର୍‌ କିଜ଼ି ମାଞ୍ଚିସ୍, ୱାଟିଙ୍ଗ୍‌ ନା ଇଞ୍ଜ ୱାଜ଼ି ବାହା କିୟାଟ୍‌” ଆରେ, ହେଦେଲ୍‌ ମାଂ ଅସି ହାଞ୍ଚାତ୍‍ । ");
INSERT INTO peg_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","ଦିନେକ୍‌ ଆପେଂ ପାର୍ତାନା ବାହାତ ହାଲ୍‌ଜି ମାନି ୱାଡ଼ାଙ୍ଗ୍‌ ର ବାନ୍ୟା ଜିବୁନ୍‍ କଡ଼୍‌ତି ଆଡ଼ିଏଣି ଗାଡ଼୍‌ଚେଂ ବେଟା ଆତାପ୍‌ । ତା ବିତ୍ରେ ମାନି ପୁଦାନି ସାକ୍ତି ହୁକେ ହେଦେଲ୍‌ ଆଗେନି କାତା ଇଞ୍ଜି ମାଚାତ୍‌ । ହେଦେଲ୍‌ ମାନାୟାର୍‌ତି କାରୁମ୍‍ ଗାଣାକିଜ଼ି, ହାଉକାରିଂ କାଜିଂ ବେସି ଟାକାଂ ଆଦାୟ୍‌ କିଜ଼ି ମାଚାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","ହେଦେଲ୍‌ ପାଉଲ୍‌ ଆରି ମା ପାଚେ ପାଚେ ୱାଜ଼ି କିକିରାଡିଂ କିଜ଼ି ଇଞ୍ଜେଙ୍ଗ୍‌ ଲାଗାତାତ୍‌, “ଇ ମୁଣିକାର୍‍ ର ଇସ୍ୱର୍‌ତି ଆଡ଼ିୟାର୍‌, ହେୱାର୍‌ ମିଙ୍ଗ୍‌ ମୁକ୍ତିନି ହାଜ଼ି ଜାଣାୟ୍‍କିଦ୍‍ନାରା ।” ");
INSERT INTO peg_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","ହେଦେଲ୍‌ ବେସି ଦିନ୍‌ ପାତେକ୍‌ ଇଦାଂ କିତାତ୍‌ । ମତର୍‌ ପାଉଲ୍‌ ରିସା ଆଜ଼ି ମାସ୍‌ଦି ହେ ଜିବୁନ୍‌ତିଙ୍ଗ୍ ଇଚାନ୍‌, ତା ତାଙ୍ଗ୍‌ ହସି ହାଞ୍ଜେଙ୍ଗ୍‌ ଆନ୍‌ ନିଂ “ଜିସୁ କ୍ରିସ୍ଟତି ତର୍‌ଦ ବଲ୍‌ ହିଦ୍‍ନାଙ୍ଗା ।” ଇବେଣ୍ଡାଂ ହେଦେଲ୍‌ ହେ ଦାପ୍ରେ ହସି ହାଚାତ୍ । ");
INSERT INTO peg_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","ମତର୍‌ ତା ମାପ୍ରୁ ମୁଣିକାର୍ତି ଜାର୍‌ତିଂ ଲାବ୍‌ ଆହା ହାଚାକା ହୁଡ଼୍‌ଜି ପାଉଲ୍‌ ଆରି ସିଲାତିଂ ଆଜ଼ି ହେୱାରିଂ ଚକ୍‍ବାହାତ ସାସନ୍‍କାର୍‍ୟାର୍ତି ଲାଗେ ଜାଲ୍‍ଜି ଅତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","ଆରେ, ହେୱାର୍‌ ହେୱାରିଂ ବିଚାର୍‍କାର୍‍ୟାର୍ତି ଲାଗେ ତାହି ଇଚାର୍‌, “ଇ ମାନାୟାର୍‌ ଜିହୁଦି, ଇୱାର୍‌ ମା ଗାଡ଼୍‌ଦ ଗଣ୍ଡ୍‌ଗଲ୍‌ କିନାରା । ");
INSERT INTO peg_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","ମା, ରମିୟ ଲକାର୍‍ତି ଇମ୍‌ଣି ସବୁ ରିତିନିତି ଇନାକା କି ମାନି କିନାକା ବିଦି ଆକାୟ୍‌, ହେଦାଂ ଇୱାର୍‌ ପର୍‌ଚାର୍‌ କିନାରା ।” ");
INSERT INTO peg_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","ହେବେ ଲକୁ ପା ହେୱାର୍‌ତି ବିରୁଦ୍‌ତ ନିଂତାର୍, ଆରେ ବିଚାର୍‍କାର୍‍ୟାର୍‍ ପାଉଲ୍‌ ଆରି ସିଲାତି ହେନ୍ଦ୍ରା ଉନ୍‌ନ୍ଦି ହେୱାରିଂ ବାଡ୍‍ଗେମାଡ୍‍ କିଦେଙ୍ଗ୍‌ କାଜିଂ ବଲ୍‌ ହିତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","ହେୱାର୍‌ ହେୱାରିଂ ବେସି ଟ୍ରାକି କିୟ୍‍କିତି ପାଚେ ଜଇଲ୍‌ ଇଞ୍ଜ ଇଡ଼୍‌ଜି ହେୱାରିଂ ଜାଗ୍ରତ୍‌ତାଂ ରାକ୍ୟା କିନି କାଜିଂ ଜଇଲ୍‌ ଇଟ୍‍ନାକାନିଂ ଆଟ୍‌ୱା ବଲ୍‌ ହିତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","ହେୱାନ୍‌ ଇ ବାନି ଆଟ୍‌ୱା ବଲ୍‌ ଗାଟା ଆଜ଼ି ହେୱାରିଂ ବିତ୍ରେ ଜଇଲ୍‌ ଇଞ୍ଜ ଇଡ଼୍‌ଜି ହେୱାର୍‌ତି ପାନାତ ଗାଜା କୁଟ୍‌ଲା ଗାଚ୍‌ଚାର୍‍ । ");
INSERT INTO peg_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","ମାତର୍‌ ମାଦିମାଦାନାଣା ପାଉଲ୍‌ ଆରି ସିଲା ଇସ୍ୱର୍‌ତି ଲାଗାୟ୍‌ ପାର୍ତାନା ଆରି ଗୁଣ୍‍ମାଣି କିଜ଼ି ମାଚାର୍‌, ଆରେ ବନ୍ଦିର୍ ୱେନ୍‍ଞ୍ଜି ମାଚାର୍ । ");
INSERT INTO peg_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","ହେ ଏଚେକାଡ଼୍‌ଦ ହାଚାଟ୍ରେ ଏଲେଙ୍ଗ୍‌ ଗାଜା ମେଦ୍‌ନି ଦାଲ୍‍କା ଆତାତ୍‌ ଜେ, ଜଇଲ୍‌ ଇଲ୍‌ନି କୁନାଦି ଡ୍ରିଙ୍ଗ୍‌ଦେଂ ଲାଗାତାତ୍‌, ଆରେ ଦାପ୍ରେ ୱିଜ଼ୁ ଜଇଲ୍‌ ଦୁୱେର୍‌ ଜେୟା ଆତାତ୍‌, ଆରେ ସବୁ ଜାଣ୍‍ତି ହିକ୍‌ଡ଼ି ଗାଟି ରିଂଜି ହାଚିକ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","“ଇବେ ଜଇଲ୍‌ ଇଲ୍‌ ଇଟ୍‍ନାକାନ୍ ହୁଚ୍‍କାଣ୍‍କୁତାଂ ନିଂଜି ଜଇଲ୍‌ ଇଲ୍‌ନି ଦୁୱେର୍‌ ମେଲା ଆତାକା ହୁଡ଼୍‌ଜି ବନ୍ଦିର୍ ହନ୍‌ଚି ହାଚାର୍ଣ୍ଣା ଇଞ୍ଜି ବାବି କିଜ଼ି, କାଣ୍ଡା ହପ୍‍ଚି ଜାର୍‌ତିଂ ଅହ୍ୟାଦେଂ ହାଲ୍‍ଜି ମାଚାନ୍‍ ।” ");
INSERT INTO peg_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","ମାତର୍‌ ପାଉଲ୍‌ ବେସି ଗାଜାକାଟ୍‌ତାଂ କୁକ୍‌ଚି ଇଚାନ୍‌, “ଜାର୍‌ତିଂ ଇମ୍‌ଣାକା ପା ନସ୍ଟ କିମା, ଇନାକିଦେଂକି ଆପେଂ ୱିଜ଼ାକାପ୍ ଇବେ ମାନାପ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","ହେବେ ହେୱାନ୍‌ ବଇଟା ତାତେଙ୍ଗ୍‌ ଇଞ୍ଜି ଗୁମ୍‌ଜି ପାଣ୍ଡ୍ରୁତିଂ ତ୍ରିଗ୍‍ଜି ତ୍ରିଗ୍‍ଜି ପାଉଲ୍‌ ଆରି ସିଲାତି ମୁମ୍‌ଦ ଗୁର୍ତାନ୍, ");
INSERT INTO peg_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","ଆରେ ହେୱାରିଂ ବାର୍ତ ତାହି ଇଚାନ୍‌, “ମାପ୍ରୁର୍, ରାକ୍ୟା ପାୟାଦେଂ କାଜିଂ ନାଙ୍ଗ୍‌ ଇନାକା କିଦେଙ୍ଗ୍‌ ଆନାତ୍‌ ?” ");
INSERT INTO peg_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","ହେୱାର୍‌ ଇଚାର୍‌, “ମାପ୍ରୁ ଜିସୁ ତାକେ ପାର୍ତି କିୟାଟ୍‌, ତା ଆତିସ୍‌ ଏପେଙ୍ଗ୍‌ ୱିଜ଼ୁ କୁଟୁମ୍‍ ରାକ୍ୟା ପାୟାନାଦେର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","ପାଚେ ହେୱାର୍‌ ତାଙ୍ଗ୍‌ ଆରି ତା ଇଞ୍ଜ ମାନି ୱିଜ଼ାରିଂ ମାପ୍ରୁତି ବଚନ୍‌ ଇଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","ଆରେ, ହେୱାନ୍‌ ହେୱାରିଂ ନାଣା ହେ ସମୁତ ଅଜ଼ି ହେୱାର୍‌ତି ଟ୍ରାକ୍ୟାତି ଗାୱ୍‌ ସବୁ ନୁସ୍ତାନ୍, ଆରେ, ହେୱାନ୍‌ ଆରି ହେୱାନ୍ତି ପାର୍ତାନା ହେ ଦାପ୍ରେ ବାପ୍ତିସିମ୍‌ ଆତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","ହେବେ ହେୱାନ୍‌ ହେୱାରିଂ ଜାର୍‌ ଇଞ୍ଜ ଅସି ହାଲ୍‍ଜି କାଦି ଚିଚ୍‌ପାତାନ୍‌, ଆରେ ୱିଜ଼ୁ ପାର୍ତାନା ହୁକେ ଇସ୍ୱର୍‌ ତାକେ ପାର୍ତି କିଜ଼ି ଜବର୍‌ ୱାର୍‌ୟା ଆତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","ନାଡ଼ିସ୍ ଆତିଲେ ବିଚାର୍‌କାର୍‌ୟାର୍‌ ଜାମାନିରିଂ ଇଦାଂ ଇଞ୍ଜି ପକ୍ତାର୍‌, “ହେ ଲକୁରିଂ ପିହାଟ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","ଇବେଣ୍ଡାଂ ଜଇଲ୍‌ ଇଲ୍‌ ପାଉଲ୍‌ତିଂ ଇ କାତା ଇଞ୍ଜି ୱେଚ୍‌ଚାନ୍‌, ମିଙ୍ଗେଙ୍ଗ୍‌ ପିସ୍ତି ହିଦେଂ କାଜିଂ “ବିଚାର୍‌କିନାକାର୍‌ ଲକୁ ପକ୍ତାତାର୍ଣ୍ଣା । ଲାଗିଂ ନଙ୍ଗ୍‌ ହସି ୱାଜ଼ି ସୁସ୍ତାତ ତାଂଜି ହାଲାଟ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","ମାତର୍‌ ପାଉଲ୍‌ ହେୱାରିଂ ଇଚାନ୍‌, “ରମିୟ ଲକୁ ଜେ ଆପେଂ, ମା ବିଚାର୍‌ କିୱାଦାଂ ହେୱାର୍‌ ରିସାରେ ମାଂ ଟ୍ରାକ୍‍ତି ପାଚେ ଜଇଲ୍‌ତ ତୁହିଦାତାର୍ଣ୍ଣା, ଆରେ ନଙ୍ଗ୍‌ କି ଲୁକାମ୍‍ରେ ମାଂ ପିସ୍‌ସି ହିଦ୍ନାରା ? ହେଦାଂ ଆଉତ୍‌, ମତର୍‌ ହେୱାର୍‌ ନିଜେ ୱାଜ଼ି ମାଂ ବାର୍ତ ଅଦେର୍ ।” ");
INSERT INTO peg_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","ଇବେଣ୍ଡାଂ ଜାମାନିର୍ ବିଚାର୍‍କାର୍‍ୟାରିଂ ଇ ୱିଜ଼ୁ ବଚନ୍‌ ଜାଣାୟ୍‌ କିତାର୍‌, ଆରେ ହେୱାର୍‌ ଜେ ରମିୟ ଲକୁ, ଇଦାଂ ୱେନ୍‌ଞ୍ଜି ହେୱାର୍‌ ପାଣ୍ଡ୍ରା ଆତାର୍‌, ");
INSERT INTO peg_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","ଆରେ, ହେୱାର୍‌ ୱାଜ଼ି ହେୱାରିଂ ଗୱାରି କିତାର୍‌, ଆରେ ହେୱାରିଂ ଜଇଲ୍‌ ଇଞ୍ଜାଙ୍ଗ୍‌ ହପ୍‍ଚି ତାସି ଗାଡ଼୍‌ଦାଂ ହସିହାଞ୍ଜେଙ୍ଗ୍ କାଜିଂ ହେୱାରିଂ ଗୱାରି କିତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","ହେବେଣ୍ଡାଂ ପାଉଲ୍‌ ଆରି ସିଲା ଜଇଲ୍‌ ତାଂ ହସିହାଲ୍‍ଜି ଲୁଦିଆତି ଇଲ୍‌ଦ ହଟାର୍, ଆରେ ଟଣ୍ଡାର୍‌ ଲାହାଙ୍ଗ୍‌ ବେଟା ଆଜ଼ି ହେୱାରିଂ ୱାରିକିୟ୍‌କିନି ପାଚେ ହାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","ପାଚେ ହେୱାର୍‌ ଆଂପିପଲି ଆରି ଆପଲନିଆ ହିଜ଼ି ହାଲ୍‌ଜି ତେସ୍‌ଲନିକିତ ୱାତାର୍‌; ହେବେ ଜିହୁଦିର୍‌ତି ର ପାର୍ତାନା ଇଲ୍‌ ମାଚାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","ପାଉଲ୍‌ ତା ରିତି ଇସାବ୍ରେ ହେୱାର୍‌ ଲାଗାଂ ହାଚାନ୍‌, ଆରେ ତିନି ଗଟା ଜମ୍‌ନିବାର୍‌ ପାତେକ୍‌ ସାସ୍ତର୍‌ ବଚନ୍‌ ଅଜ଼ି ହେୱାରିଂ ବୁଜାୟ୍‌ କିତାନ୍‌, ");
INSERT INTO peg_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","ଆରେ, କ୍ରିସ୍ଟତି ଜେ ଦୁକ୍‌ବଗ୍‌ ଆରି ହାତାକାର୍‌ ବିତ୍ରେ ନିଂନାକା ଲଡ଼ା ମାଚାତ୍‌, ଆରେ ହେୱାନ୍‌ ଇମ୍‌ଣି ଜିସୁଙ୍ଗ୍‌ ହେୱାର୍‌ ଲାଗାଂ ସୁଣାୟ୍‌ କିନାନା, ହେୱାନ୍‌ କ୍ରିସ୍ଟ, ଇବେନି ନିର୍ମଲ୍‌ ପାର୍ମାଣ୍‌ ହିତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","ହେବେଣ୍ଡାଂ ହେୱାର୍‌ ବିତ୍ରେ କେତେକ୍‌ ଜାଣ୍‌ ପାର୍ତି କିଜ଼ି ପାଉଲ୍‌ ଆରି ସିଲାତି ଲାହାଙ୍ଗ୍‌ ମେହା ଆତାନ୍‌; ଆରେ, ଜିହୁଦି ପାର୍ତାନା କିନାକାର୍ ଗ୍ରିକ୍‌ତି ବିତ୍ରେ ହେନି ଲକୁ ଆରି ଆଦେକ୍‌ କଗ୍‍ଲେକ୍ ହେୱାର୍‌ ଲାହାଙ୍ଗ୍‌ ମେହାତିକ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","ମାତର୍‌ ଜିହୁଦିର୍‌ ଆକାର୍‍ତ ରିସା ଆଜ଼ି ବାଜାର୍ଣ୍ଣି କେତେକ୍‌ ବାନ୍ୟା ମାନାୟାର୍‌ ଲାହାଙ୍ଗ୍‌ ଅଜ଼ି ଲକୁ ଗହ୍‌ଲି କିଜ଼ି ଗାଡ଼୍‌ଦ ଗଣ୍ଡ୍‌ଗଲ୍‌ କିୟ୍‍କିତାର୍, ଆରେ ଜାସୋନତିଂ ଇଞ୍ଜ ମାଡିବହା ଆଜ଼ି ହେୱାରିଂ ମାନାୟାର୍‌ ଲାଗାୟ୍‌ ହପ୍‍ଚି ତାତେଙ୍ଗ୍‌ କାଜିଂ ସେସ୍ଟା କିତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","ମତର୍‌ ହେୱାରିଂ ଗାଟାୱିତିଲେ ହେୱାର୍‌ ଜାସୋନ ଆରି କେତେକ୍‌ ଟଣ୍ଡାର୍‌ ଗାଡ଼୍‌ନି ସାସନ୍‌କାର୍‌ୟାର୍‌ ଲାଗାୟ୍‌ ଜେଲ୍‍ଜି ତାହି ଗାଜାକାଟ୍‌ତାଂ କୁକ୍‌ଚି ଇଚାର୍‌, “ଇୱାର୍‌ ଇମ୍‌ଣି ମାନାୟାର୍‌ ପୁର୍ତିତିଂ ଉଲ୍‍ଟାପଲ୍‍ଟା କିଜ଼ି ତୁହିତାରେ, ହେୱାର୍‌ ଇବେ ପା ୱାତାର୍ଣ୍ଣା; ହେୱାରିଂ ଜେସନ୍‌ ଇଡ୍‌ତାନ୍ନା । ");
INSERT INTO peg_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","ଜାସୋନ ହେୱାର୍‌ ଇଲ୍‌ ଇଟ୍‌ତାନ୍ନା । ଜିସୁ ତର୍‌ଦ ଆରେ ରୱାନ୍‌ ରାଜା ମାନାନ୍‌ ଇଞ୍ଜି ଇଞ୍ଜି ଇୱାର୍‌ ୱିଜ଼ାର୍‌ କାଇସର୍‌ତି ବଲ୍‌ ମାନିକିନାରା ।” ");
INSERT INTO peg_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","ହେୱାର୍‌ତି ଇ କାତା ୱେନ୍‌ଞ୍ଜି ଲକୁ ସବୁ ଆରି ସାସନ୍‌କାର୍‌ୟାର୍‌ ରିସା ଆଜ଼ି ଗଣ୍ଡ୍‌ଗଲ୍‌ କିତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","ପାଚେ ହେୱାର୍‌ ଜାସୋନ ଆରି ହେୱାନ୍ତି ହାଂଙ୍ଗ୍‌ୱାର୍‍ତାଂ ଜାମ୍‌ଲି ଅଜ଼ି ହେୱାରିଂ ପିସ୍ତି ହିତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","ଆରେ, ଟଣ୍ଡାର୍‌ ଆରି ତଣ୍‌ଦେକ୍‌ ମାଲାୱାଦାଂ ପାଉଲ୍‌ ଆରି ସିଲାଙ୍ଗ୍‌ ନାଣାକାଡ଼୍‍ଦ ବେରିୟାତ ପକ୍‍ଚିହିତାର୍; ହେୱାର୍‌ ହେ ବାହାତ ଏକିସ୍‌ ଜିହୁଦିର୍‌ତି ପାର୍ତାନା ଇଞ୍ଜ ହାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","ତେସ୍‌ଲନିକିତ ମାନି ଜିହୁଦିର୍‌ତାଂ ଇୱାର୍‌ ହାର୍ଦାକାର୍‌ ମାଚାର୍‌ । ଇୱାର୍‌ ପୁରା ୱାରିତାଂ ବଚନ୍‌ ଇଟ୍‌ତାର୍‌, ଆରେ ଇ ୱିଜ଼ୁ ହାତ୍‌ପା କି ଆକାୟ୍‌, ହେଦାଂ ପୁଞ୍ଜେଙ୍ଗ୍‌ କାଜିଂ ଦିନ୍‌କେ ସାସ୍ତର୍‌ନି ପର୍‌ସନ୍‌ ଡେକ୍‌ଚି ମାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","ଲାଗିଂ ହେୱାର୍‌ତି ବିତ୍ରେ ଆଦେକ୍‌ ଆରି ଗ୍ରିକ୍‌ତି ବିତ୍ରେ ଆଦେକ୍‌ ମୁସ୍ତିଦାର୍ ତାଡ଼ିକ୍‍ ଆରି ଆଣ୍ଡ୍ରା ହିମ୍‍ଣାଂ ପା ପାର୍ତି କିତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","ମାତର୍‌ ଏଚେକାଡ଼୍‌ଦ ତେସ୍‌ଲନିକିୟ ଜିହୁଦିର୍‌ ପୁଚାର୍ ଜେ, ଇସ୍ୱର୍‌ତି ବଚନ୍‌ ପାଉଲ୍‌ତି ହୁଦାଂ ବେରିୟାତ ପା ପର୍‌ଚାର୍‌ ଆନାତା, ହେ ଏଚେକାଡ଼୍‌ଦ ହେୱାର୍‌ ହେ ବାହାତାଂ ପା ୱାଜ଼ି ଲକୁରିଂ ଟିଉଲାୟ୍‌ ଆରି ରିସା କିତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","ହେବେଣ୍ଡାଂ ଟଣ୍ଡାର୍‌ ମାଲାୱାଦାଂ ପାଉଲ୍‌ତିଂ ହାମ୍‌ଦୁର୍‌ ନିପ ହାନି କାଜିଂ ପକ୍ତାର୍‌, ଆରେ ସିଲା ଆରି ତିମତି ହେ ବେରିଆତ ମାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","ମାତର୍‌ ଇମ୍‌ଣାକାର୍‌ ପାଉଲ୍‌ତିଂ ଏତେନ୍‌ସ୍‌ ଅଜ଼ି ହାଚାର୍‌, ହେୱାର୍‌ ତାଙ୍ଗ୍‌ ଏତେନ୍‌ସ୍‌ ପାତେକ୍‌ ତାଇୱାତାର୍‌, ଆରେ ସିଲା ଆରି ତିମତି ଇନେସ୍‌ ବେଗି ତା ଲାଗାୟ୍‌ ୱାନାର୍, ଇ ବଲ୍‌ ଗାଟାଜ଼ି ହେୱାର୍‌ ହାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","ଏତେନ୍‌ସ୍‌ତ ପାଉଲ୍‌ ହେୱାର୍‌ କାଜିଂ ମାନି ୱେଡ଼ାଲିଂ ହେ ଗାଡ଼୍‌ଦ ପୁତ୍‍ଡ଼ାତ ବାର୍ତି ହୁଡ଼୍‌ଜି ତା ଜିବୁନ୍‌ତ ରିସା ଆଜ଼ି ନିଂତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","ଲାଗିଂ ହେୱାନ୍‌ ପାର୍ତାନା ଇଞ୍ଜ ଜିହୁଦିର୍‌ ଲାହାଂ ଇସ୍ୱର୍‌ତି ପାର୍ତାନା କିନାକାନ୍‌ ପାର୍ତିକିୱି ଜିହୁଦି ଲାହାଂ ଇ ବିସ୍ରେ ସବୁ ନାଞ୍ଜିଙ୍ଗ୍‌ କାତା ବାର୍ତା କିଦେଙ୍ଗ୍‌ ଲାଗାତାର୍‌ । ବସ୍ତି ବାଜାର୍ ଚକ୍‍ତି ବାହାକାଂ ବୁଲାଚାଲା ଆଜ଼ି ମାନି ପାତିଦିନ୍ ଇମ୍‌ଣାକାର୍‌ ହୁଦାଂ ହୁଡ଼୍‍କା ଆଜ଼ି ମାଚାର୍, ହେୱାରିଂ ଉପ୍‌ଦେସ୍‌ ହିଜ଼ି ମାଚାନ୍ । ");
INSERT INTO peg_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","ହେବେଣ୍ଡାଂ “ଏପିକୁରିୟ ଆରି ସ୍ତୟିକ” କେତେକ୍‌ ହୁଡ଼୍‍ନାକାର୍‍ ପା ତା ହୁଦାଂ କାତାବାର୍ତା କିଦେଙ୍ଗ୍‌ ଲାଗାତାର୍‌, ଆରେ ଇନେର୍‌ ଇନେର୍‌ ଇଚାର୍‌, “ଇ କାଡ଼୍‌ଦେ ଇନାକା ଇଞ୍ଜେଙ୍ଗ୍‌ ଇଚା କିନାନା ?” ଆରେ ଇନେର୍‌ ଇନେର୍‌ ଇଚାର୍‌, ହେୱାନ୍‌ ପୁଦାଙ୍ଗ୍‌ତି ବିସ୍ରେ ପର୍‌ଚାର୍‌ କିନାକାନ୍‌ ଲାକେ ପୁନ୍ୟାନାତା । ଇନାକିଦେଂକି ହେୱାନ୍‌ ଜିସୁ ଆରି ଆରେ ନିଂନାକା ବିସ୍ରେନି ନେକ୍ରିକାବୁର୍‌ ପର୍‌ଚାର୍‌ କିଜ଼ି ମାଚାନ୍ ହେୱାର୍‌ ଇଦାଂ ଇଚାର୍‌ ");
INSERT INTO peg_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","ପାଚେ ହେୱାର୍‌ ପାଉଲ୍‌ତିଂ ଆରିୟପାଗତ ଗାଜା ସବାତ ଅସି ହାଲ୍‍ଜି ଇଚାର୍‌, ଇଦାଂ ଜେ ପୁନି ହିକ୍ୟା “ଏନ୍‌ ହିନାୟା, ହେଦାଂ ଇନାକା ଇଞ୍ଜି ଆପେଂ ପୁଞ୍ଜେଙ୍ଗ୍‌ ଆଡ୍‌ନାପ୍‌ କି ? ");
INSERT INTO peg_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","ଇନାକିଦେଂକି ଏନ୍‌ କେତେକ୍‌ କାବା ବିସ୍ରେ ମାଂ କିତୁଲ୍‍ତ ପୁନି କିତ୍‍ତାୟ୍‍ନା, ଲାଗିଂ, ଇ ୱିଜ଼ୁ କାତାନି ଅରତ୍‌ ଇନାକା, ଆପେଂ ହେଦାଂ ପୁଞ୍ଜେଙ୍ଗ୍‌ ଇଚା କିନାପା !” ");
INSERT INTO peg_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","ଆତିନିୟ ଲକୁ ୱିଜ଼ାର୍ ଆରି ହେବେ ବାହାକିନି ବିଦେସିର୍ କେବଲ୍‌ ଇମ୍‌ଣାକା ପୁନି କାତା ଇନାକା ଆରି ୱେନାକା ପିସ୍ତି ଆରେ ଇନାକାତ ବେସି ସମୁ ବିତାୟ୍‌ କିୱାଦାଂ ମାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","ଇବେଣ୍ଡାଂ ପାଉଲ୍‌ ଆରିୟପାଗନି ମାଦ୍‍ଣି ବାହାତ ନିଲ୍‌ଚି ଇଚାନ୍‌, “ଆତିନିୟ ଲଗୁ, ଏପେଙ୍ଗ୍‌ ଜେ ୱିଜ଼ୁ ବିସ୍ରେ ଗାଜା ଦେବି ଲବାୟ୍‌ କିନାଦେରା, ଇଦାଂ ଆନ୍‌ ହୁଡ଼୍‍ନାଙ୍ଗା ।” ");
INSERT INTO peg_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","ଇନାକିଦେଂକି ଆନ୍‌ ବୁଲାନି ସମୁତ ମି ପୁଜାକିତି ୱିଜ଼ୁ ଦିନିସ୍‌ ହୁଡ଼ୁ ହୁଡ଼ୁ ର ଗାର୍‌ଣି ପା ହୁଡ଼୍‌ତାଂ, ଇମ୍‌ଣି ଜପି ଇ କାତା ଲେକା ଆତାତ୍‌ନ୍ନା, “ପୁନ୍‍ୱିତି ଇସ୍ୱର୍‌ତି ଉଦେସ୍‌ତ ପେନ୍‍କୁତି କାଜିଂ ! ଲାଗିଂ, ଏପେଙ୍ଗ୍‌ ପୁନ୍‌ୱାଦାଂ ଇନେରିଙ୍ଗ୍‌ ପୁଜା କିନାଦେରା, ଆନ୍‌ ତାଙ୍ଗ୍‌ ମି ଲାଗାୟ୍‌ ପର୍‌ଚାର୍‌ କିନାଙ୍ଗା ।” ");
INSERT INTO peg_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","ଇମ୍‌ଣି ଇସ୍ୱର୍‌ ପୁର୍ତିତ ଆରି ତାରେନ୍‍ନିକା ୱିଜ଼ୁ ଆଡ଼୍‌ମାଡ଼୍‌ ଉବ୍‌ଜାଣ୍‌ କିତାନ୍‌ନ୍ନା, ହେୱାନ୍‌ ବାଦାଡ଼୍‌ତ ଆରି ପୁର୍ତିନି ମାପ୍ରୁ ଆତିଲେ କେଇରଚ୍‌ଚି ମନ୍ଦିର୍‌ତ ବାହା କିଉନ୍‌, ");
INSERT INTO peg_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","କି ହେୱାର୍‌ତି ଇମ୍‌ଣାକା ଅବାବ୍‌ ମାଚିଲେ ମାନାୟ୍‌ କେଇ ହୁଦାଂ ଉଜ୍‌ କିଜ଼ି ହେୱାନ୍‌ ହେବା କିୟା ଆଉନ୍‌, ଲାଗିଂ ହେୱାନ୍‌ ନିଜେ ୱିଜ଼ାରିଂ ଜିବୁନ୍‌ନି, ନେନ୍‍ଞ୍ଜେଙ୍ଗ୍ ଆରି ୱିଜ଼ୁ ଆଡ଼୍‌ମାଡ଼୍‌ ଦାନ୍‌ କିଦ୍‌ନାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","ରୱାନ୍‌ ମାନାୟ୍‌ତାଂ ହେୱାନ୍‌ ନାର୍‌ ଜାତିତିଂ ଉବ୍‌ଜାୟ୍‌ କିତାନ୍‌ନା ଆରି ତା କାତାଂ ହେୱାର୍‌ ପୁର୍ତିନି ବିନ୍‌ ବିନ୍‌ ବାହାତ ବାହା କିନାରା ଆଗେ ଇସ୍ୱର୍‌ ବାଚି କିତାନ୍‌ନ୍ନା । ");
INSERT INTO peg_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","ହେୱାର୍‌ତି ଉଦେସ୍‌ ମାଚାତ୍‌, ୱିଜ଼ାର୍‌ ଇନେସ୍‌ ହେୱାର୍‌ତି ଦାସ୍‌ଜ଼ି ପାୟାନାର୍‌ । ମାତର୍‌ ହାତ୍‌ପା ଇସ୍ୱର୍‌ ଇନେର୍‌ତାଂ ଦେହା ଆକାୟ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","ଇନାକିଦେଂକି “ହେୱାନ୍ତି ତାକେ ମା ପ୍ଡେନ୍, ହାନାକା ଆରି ଜିଜ଼ି ମାନାକା ।” ଇନେସ୍‌ ମା ଜାର୍‌ କେର୍ଣ୍ଣାକାର୍ତି ବିତ୍ରେ ପା କେତେକ୍‍ ଜାଣ୍‍ ଇଚାର୍ଣ୍ଣା, “ଇନାକିଦେଂକି ଆପେଂ ପା ହେୱାନ୍ତି ଲାତ୍ରା ।” ");
INSERT INTO peg_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","ୱାଟିଙ୍ଗ୍‌, ଆପେଂ ଇସ୍ୱର୍‌ତି ଲାତ୍ରା ଆତିଲେ ଇସ୍ୱର୍‌ତି ଚିନ୍‌ ଲାକେ ମାନାୟ୍‌ ରଚ୍‍ନାକାନ୍‍ ଆରି ହାନ୍ଦାୟ୍‍ କିନାକାନ୍ ଇସାପ୍ରେ ବଲତ୍କାର୍‌ କିଜ଼ି ହନା କି ରୁପା କି କାଲ୍‌ ଲାକେ ବାବିକିନାକା ମା ଲଡ଼ା ଆକାୟ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","ମାନାୟାର୍‌ ଇସ୍ୱର୍‌ତିଂ ପୁନ୍‌ୱି ୱେଡ଼ାଲିଂ ହେୱାନ୍‌ ଦସ୍‌ ଆହ୍‍ୱାଦାଂ ମାଚାନ୍‌, ମାତର୍‌ ନଙ୍ଗ୍‌ ହେୱାନ୍‌ ସବୁତିଂ ୱିଜ଼ାକାରିଂ ହେୱାରିଂ ପାପ୍‌ ହାଜ଼ିତାଂ ମାନ୍‌ବାଦ୍‌ଲାୟ୍‌ କିଦେଙ୍ଗ୍‌ ବଲ୍‌ ହିନାଙ୍ଗା । ");
INSERT INTO peg_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","ଇନାକିଦେଂକି ଇମ୍‍ଣି ନାଜିଂ ହେୱାନ୍‌ ଜାର୍‌ କିତି ମୁଣିକାର୍‍ ହୁଦାଂ ଦାର୍ମିନି ପୁର୍ତିନି ବିଚାର୍‌ କାମାୟ୍‌ କିନାନ୍‌, ଏପେଙ୍ଗ୍‌ ର ନାଜିଂ ତିର୍‌ କିତାନ୍‌ନ୍ନା, ଆରେ ହେଦେଲିଂ ହାକିତାକେଣ୍ତାଙ୍ଗ୍ ବିତ୍ରେ ନିକ୍‍ତାନ୍ନା ଇ ବିସ୍ରେ ୱିଜ଼ାର୍ତି ଲାଗେ ଜାଣାୟ୍‌ କିତାନ୍ନା । ");
INSERT INTO peg_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","ହାତାକାର୍‌ ଆରେ ନିଂନାକା କାତା ୱେନ୍‌ଞ୍ଜି ଇନେର୍‌ ଇନେର୍‌ ଗ୍ଡାଇଦେଂ ଲାଗାତାର୍‌ ଆରେ ଇନେର୍‌ ଇନେର୍‌ ଇଚାର୍‌, ଆପେଂ ଆରେ ରଗ “ମିତାଙ୍ଗ୍ ଇ ବିସ୍ରେ ୱେନାସ୍ ।” ");
INSERT INTO peg_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","ଇ ବାନି ପାଉଲ୍‌ ହେୱାର୍‌ ବିତ୍ରେତାଂ ହସି ହାଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","ମାତର୍‌ ଇନେର୍‌ ଇନେର୍‌ ଲକୁ ତା ପାକ୍ୟା ଆଜ଼ି ପାର୍ତି କିତାର୍‌; ହେୱାର୍‌ତି ବିତ୍ରେ ଏରିୟପାଗିୟ ଦିୟନୁସିୟ, ସବାନି ରୱାନ୍‌ ଦାମାରି ତର୍‌ନି ରଞ୍ଜେଲ୍‌ ତାଡ଼ି ଆରି ହେୱାର୍‌ ହୁଦାଂ ଆରେ କେତେକ୍‌ ଲକୁ ମାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","ଇ ୱିଜ଼ୁ ଗଟ୍‌ଣା ପାଚେ ହେୱାନ୍‌ ଏତେନ୍‌ସ୍‌ତାଂ ହାଲ୍‌ଜି କରନ୍ତିତ ୱାତାନ୍ । ");
INSERT INTO peg_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","ଆରେ, ହେୱାନ୍‌ ଆକ୍ୱିଲା ତର୍‌ନି ରୱାନ୍‌ ଜିହୁଦିଙ୍ଗ୍‌ ବେଟା ଆତାନ୍‌, ପନ୍ତ ହେୱାନ୍ତି ଜଲମ୍‌ ବାହା; ହେୱାନ୍‌ ଅଲପ୍‍ ଦିନ୍‌ ଆତାତ୍‌ ଜାର୍‌ କଗ୍‌ଲେ ପ୍ରିସ୍କିଲ୍ଲା ଲାହାଙ୍ଗ୍‌ ଇତାଲିଆତାଂ ୱାଜ଼ି ମାଚାର୍, ଇନାକିଦେଂକି କ୍ଲାଉଦିଅ ୱିଜ଼ାର୍‌ ଜିହୁଦିରିଂ ରମ୍‌ତାଂ ହସି ହାଞ୍ଜେଙ୍ଗ୍‌ ବଲ୍‌ ହିଜ଼ି ମାଚାନ୍‌ । ହେୱାନ୍‌ ହେୱାର୍‌ ଲାହାଙ୍ଗ୍‌ ବେଟାୟ୍‌ କିଦେଙ୍ଗ୍‌ ହାଚାନ୍‌, ");
INSERT INTO peg_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","ଆରେ, ହାରିବେପାରିର୍‍ ମାଚିଲେ ହେୱାର୍‌ ହୁକେ ବାହା କିତାର୍‌, ଆରେ ହେୱାର୍‌ କାମାୟ୍‌ କିଦେଙ୍ଗ୍‌ ଲାଗାତାର୍‌, ଇନାକିଦେଂକି ବେପାର୍ତ ହେୱାର୍‌ ତୁମ୍‌ ରଚ୍‍ନାକାର୍‍ ମାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","ଆରେ, ପାତି ଜମ୍‌ନିବାର୍‌ତ ହେୱାନ୍‌ ପାର୍ତାନା ଇଲ୍‌ ଆଲ୍‌ଚାନା ହିଜ଼ି ଜିହୁଦି ଆରି ଗ୍ରିକ୍‌ରିଂ ପାର୍ତି ବାଡାୟ୍‌ କିଦେଙ୍ଗ୍‌ ସେସ୍ଟା କିତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","ଏଚେକାଡ଼୍‌ଦ ସିଲା ଆରି ତିମତି ମାକିଦନିଆତାଂ ୱାତାର୍, ହେ ଏଚେକାଡ଼୍‌ଦ ପାଉଲ୍‌ ବଚନ୍‌ ପର୍‌ଚାର୍‌ତ ବେସି ମାନ୍‍ଦିଆନ୍‍ ମାନ୍‌ଞ୍ଜି, ଜିସୁ ଜେ କ୍ରିସ୍ଟ ଆନାନ୍‌, ଇଦାଂ ଜିହୁଦିର୍‌ତି ଲାଗାୟ୍‌ ସାକି ହିବିସ୍‌ ମାଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","ମତର୍‌ ହେୱାର୍‌ ଆପତି ଆରି ନିନ୍ଦା କିତିଲେ ହେୱାନ୍‌ ଜାର୍‌ ହେନ୍ଦ୍ରା ଡ଼ାତ୍‍ତି ହେୱାରିଂ ଇଚାନ୍‌, “ମି ନେତେର୍‌ ମି କାପ୍‌ଡ଼ା ଜପି ଆରେତ୍‌, ଆନ୍‌ ପାପି ଆକାୟ୍‌ ନଙ୍ଗ୍‌ ପାର୍ତିକିୱି ଜିହୁଦିର୍‌ ଲାହାଙ୍ଗ୍‌ ହାନାଂ ।” ");
INSERT INTO peg_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","ହେବେଣ୍ଡାଂ ହେୱାନ୍‌ ହେ ବାହାତାଂ ହାଲ୍‌ଜି ତିତସ୍‌ ଜୁସ୍ତ ତର୍‌ନି ରୱାନ୍‌ ଇସ୍ୱର୍‌ତି ପୁଜା କିନାକାନ୍‌ ଇଞ୍ଜ ହାଚାନ୍‌, ହେଦାଂ ପାର୍ତାନା ଇଲ୍‌ତିଙ୍ଗ୍ ଲାଗାଜ଼ି ମାଚାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","ମତର୍‌ ପାର୍ତାନା ଇଲ୍‌ନି ମୁଣିକା କ୍ରିସ୍ଟ ଆରି ଇଲ୍‌ନିକାର୍ ମାପ୍ରୁ ତାକେ ପାର୍ତି କିତାର୍‌, କରନ୍ଥିୟ ବିତ୍ରେ ଆଦେକ୍‌ ୱେନ୍‌ଞ୍ଜି ପାର୍ତି କିଦେଙ୍ଗ୍‌ ଲାଗାତାର୍‌ ଆରି ବାପ୍ତିସିମ୍‌ ଆତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","ଆରେ, ମାପ୍ରୁ ନାଣା ହୁଡ଼୍‍ନାକା ହୁଦାଂ ପାଉଲ୍‌ତିଂ ଇଚାନ୍‌, “ପାଣ୍ଡ୍ରା ଆମା, ଚିମ୍‌ରା ଆୱାଦାଂ ପର୍‌ଚାର୍‌ କିୟା, ");
INSERT INTO peg_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","ଇନାକିଦେଂକି ଆପ୍‌ ମି ଲାହାଙ୍ଗ୍‌ ମାନାପ୍‌, ଇମ୍‌ଣି ଲଗୁ ପା ମି କେତି କିଦେଙ୍ଗ୍‌ ନିଂ ମାଡିବହା ଆଦୁନ୍, ଲାଗିଂ ମାୱାର୍ ଆଦେକ୍‌ ଲକୁ ଇ ଗାଡ଼୍‌ଦ ମାନାର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","ଆରେ, ହେୱାନ୍‌ ହେୱାର୍‌ ଲାଗାୟ୍‌ ଇସ୍ୱର୍‌ତି ବଚନ୍‌ ହିକ୍ୟା ହିଜ଼ି ବାର୍ହେକ୍‍ ଆଦା ହେବେ ବାହା କିତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","ମତର୍‌ ଗାଲ୍ଲିୟନ୍‌ ଆକାୟାନି ରମିୟ ସାସନ୍‍କାର୍‍ୟା ମାନି ୱେଡ଼ାଲିଂ ଜିହୁଦିର୍‌ ପାଉଲ୍‌ତି ବିରୁଦ୍‌ତ ର ମାନ୍‌ ଆଜ଼ି ନିଂଜି ତାଙ୍ଗ୍‌ ଗାଦି ଲାଗାୟ୍‌ ତାହି ଇଚାର୍‌, ");
INSERT INTO peg_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","“ଇ ମାନାୟ୍‌” ବିଦିନି ଉଲ୍‍ଟା ବାବ୍ରେ ଇସ୍ୱର୍‌ତି ପାର୍ତାନା କିଦେଙ୍ଗ୍‌ ଲକାରିଂ ଟିଉଲାୟ୍‌ କିନାକା । ");
INSERT INTO peg_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","ମତର୍‌ ପାଉଲ୍‌ ମୁମ୍‌ ରିକ୍‌ଚି କାତା ଇଞ୍ଜେଙ୍ଗ୍‌ ଜାଲ୍‌ଦି ଆତିହିଂ, ଗାଲ୍ଲିୟନ୍‌ ଜିହୁଦିରିଂ ଇଚାନ୍‌, ଇନେସ୍‌କିତିସ୍‌ପା ଅନ୍ୟାୟ୍‌ କି ବାନ୍ୟା କାମାୟ୍‌ ଜଦି ଆଜ଼ି ମାଚିସ୍‌ ୱାଟିଙ୍ଗ୍‌, ହେ ଜିହୁଦିର୍‌, କାଲେତାଂ ମି କାତା ୱେନାକା ହାରାୱାତାତ୍‍ମା; ");
INSERT INTO peg_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","ମତର୍‌ ଜଦି ଇ ସବୁ ଆପ୍‍କା ବଚନ୍‌, ତର୍‌ ଆରି ମି ବିଦି ବିସ୍ରେ କିର ଆନାତ୍‌, ୱାଟିଙ୍ଗ୍‌ ଏପେଙ୍ଗ୍‌ ନିଜେ ହେଦାଂ ବୁଜାନାଦେର୍‌; ଆନ୍‌ ଇ ସବୁ ବିସ୍ରେ ବିଚାର୍‌କାର୍‌ୟା ଆଦେଂ ଇଚା କିଉଙ୍ଗା । ");
INSERT INTO peg_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","ଆରେ, ଇଦାଂ ଇଞ୍ଜି ହେୱାନ୍‌ ଗାଦି ବାହାତାଂ ପେସ୍ତାର୍ । ");
INSERT INTO peg_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","ହେବେଣ୍ଡାଂ ୱିଜ଼ାର୍‌ ପାର୍ତାନା ଇଲ୍‌ନି ମୁଣିକା ସସ୍ଥନାତିଂ ଆସ୍ତି ଗାଦି ବାହାତ ଟ୍ରାକ୍‍ତେଂ ଲାଗାତାର୍‌; ମତର୍‌ ଗାଲ୍ଲିୟନ୍‌ ହେ ୱିଜ଼ୁ ବିସ୍ରେ ହୁଡ଼୍‌ୱାତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","ପାଉଲ୍‌ ବେସି ଦିନ୍‌ ପାର୍ତି କିନି ଟଣ୍ଡାର୍‌ ଆରି ତଣ୍‌ଦେକ୍‌ ଲାହାଂ ଇଦାଂ ପାଚେ ପାଉଲ୍‌ ବେସି ଦିନ୍‌ ବାହା କିତାନ୍‌ । ତା ପାଚେ ହେୱାନ୍‌ ପିସ୍ତି ପ୍ରିସ୍କିଲ୍ଲା ଆରି ଆକ୍ୱିଲା ଲାହାଂ ସିରିୟାନି ଏସ୍‌ ଜାଜ୍‌ତ ହାଚାର୍‌ । କେଙ୍କ୍ରେୟାତାଂ ଏସ୍‌ ଜାଜ୍‌ ଆରମ୍‌ କିନି ଆଗେ ତାଙ୍ଗେଙ୍ଗ୍‌ ର ମାନ୍ତ ଇସାବ୍ରେ ହେୱାନ୍ତି କାପ୍‌ଡ଼ା କୁରାୟ୍‍ କିୟ୍‍କିତାର୍ । ");
INSERT INTO peg_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","ପାଚେ ହେୱାର୍‌ ଏପିସତ ୱାତାର୍, ଆରେ ହେୱାନ୍‌ ହେ ବାହାତ ହେୱାରିଂ ପିସ୍ତି ନିଜେ ପାର୍ତାନା ଇଞ୍ଜ ହଣ୍‌ଜି ଜିହୁଦିରିଂ ଲାହାଙ୍ଗ୍‌ ଆଲ୍‌ଚାନା କିତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","ଆରେ, ହେୱାର୍‌ ତାଙ୍ଗ୍‌ ଆଦିକ୍‌ ସମୁ ମାଞ୍ଜେଙ୍ଗ୍ ଗୱାରି କିତିଲେ, ହେୱାନ୍‌ ରାଜି ଆୱାତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","ମତର୍‌ ହେୱାନ୍‌ ହେଲ ଅଜ଼ି ଇଚାନ୍‌, “ଇସ୍ୱର୍‌ତି ଇଚା ଆତିସ୍‌ ଆରେ ରଗ ମି ତାକେ ମାସ୍‌ଦି ୱାନାଙ୍ଗ୍” ହେୱାନ୍‌ ଜାଜ୍‌ତ ହାଲ୍‌ଜି ଏପିସତ ମାସ୍‌ଦି ହାଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","କାଇସରିୟାତ ଏକିସ୍ ହେୱାନ୍‌ ଜାଜ୍‌ ତାଂ ଜୁତାନ୍‌, ଆରେ ହାଲ୍‌ଜି ମଣ୍ଡ୍‌ଲିତିଂ ମେହାଜ଼ି ଆନ୍ତିୟକିଆତ ତାଂଜି ହାଚାନ୍ । ");
INSERT INTO peg_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","ହେ ବାହାତ କେତେକ୍‌ ସମୁ ମାଚି ପାଚେ ହେୱାନ୍‌ ହାଚାନ୍‌, ଆରେ ଦାଡ଼ିତାଂ ଗାଲାତିୟ ନିପ ଆରି ପ୍ରୁଗିଆ ହିଜ଼ି ହାଲୁ ହାଲୁ ଚେଲାର୍‌ ୱିଜ଼ାରିଂ ସୁସ୍ତା କିଜ଼ି ମାଚାନ୍ । ");
INSERT INTO peg_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","ୱିସ୍ତି ବିତ୍ରେ ଆପଲ୍ଲ ତର୍‌ନି ରୱାନ୍‌ ଜିହୁଦି ଏପିସତ ୱାତାନ୍‌, ହେୱାନ୍ତି ଜଲମ୍‌ ବାହା ଆଲେକ୍‌ଜାଣ୍ଡ୍ରିୟ; ହେୱାନ୍‌ ହାର୍‌ ବେରଣ୍‌ କିନାକାନ୍‍ ଆରି ଦରମ୍‌ ସାସ୍ତର୍‌ତ ଆଡ୍‌ନାକାନ୍‌ ମାଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","ଇ ମୁଣିକା ମାପ୍ରୁତି ହାଜ଼ି ବିସ୍ରେ ସିକ୍ୟା ପାୟା ଆଜ଼ି ମାଚାନ୍‌, ଆରେ ଜିବୁନ୍‌ତ ରିସାଜ଼ି ଜିସୁତି ବିସ୍ରେ ହାର୍‌ଦି ହିକ୍ୟା ହିଜ଼ି ମାଚାନ୍, ମାତର୍‌ ହେୱାନ୍‌ ଆପ୍‍କା ଜହନ୍‌ତି ବାପ୍ତିସିମ୍‌ ବିସ୍ରେ ପୁଞ୍ଜି ମାଚାନ୍‌; ");
INSERT INTO peg_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","ହେୱାନ୍‌ ପାର୍ତାନା ଇଲ୍‌ ସାସ୍‌ ଲାହାଙ୍ଗ୍‌ କାତା ଇଞ୍ଜେଙ୍ଗ୍‌ ଲାଗାତାନ୍‌ । ମତର୍‌ ପ୍ରିସ୍କିଲ୍ଲା ଆରି ଆକ୍ୱିଲା ତା କାତା ୱେନ୍‌ଞ୍ଜି ତାଙ୍ଗ୍‌ ଜାର୍‌ତି ଲାହାଙ୍ଗ୍‌ ଇଡ଼୍‌ଜି ଆଦିକ୍‌ ଟିକିନିକି ବାବ୍ରେ ଇସ୍ୱର୍‌ତି ହାଜ଼ି ବିସ୍ରେ ତାଙ୍ଗ୍‌ ହିକ୍ୟା ହିତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","ହେୱାନ୍‌ ଆକାୟା ଦେସ୍‌ତ ହାନି କାଜିଂ ଇଚା କିତିଲେ ଟଣ୍ଡାର୍‌ ତାଙ୍ଗ୍‌ ବାର୍ସି ହିଜ଼ି ତାଙ୍ଗ୍‌ ଇଟ୍‌ନି କାଜିଂ ଚେଲାରିଂ ଲେକିକିତାନ୍ । ହେୱାନ୍‌ ହେବେ ଏକିସ୍‌, ଇମ୍‌ଣାକାର୍‌ ପାର୍ତି କିଜ଼ି ମାଚାର୍, ଇସ୍ୱର୍‌ତି ଦୟା ହୁଦାଂ ହେୱାର୍‌ତି ବେସି ଉପ୍‌କାର୍‌ କିତାନ୍‌, ");
INSERT INTO peg_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","ଇନାକିଦେଂକି ଜିସୁ ଜେ କ୍ରିସ୍ଟ, ଇଦାଂ ଦରମ୍‌ ସାସ୍ତର୍‌ତ ହୁଦାଂ ପାର୍ମାଣ୍‍ କିଜ଼ି ହେୱାନ୍‌ ହପ୍‌ନି ସାକ୍ତି ଲାହାଙ୍ଗ୍‌ ଜିହୁଦିର୍‌ତି ଜିକାଟାଣା ସବୁ ଆରାୟ୍‌ କିଦେଙ୍ଗ୍‌ ଲାଗାତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","ଆପଲ୍ଲ କରନ୍ତିତ ମାନି ୱେଡ଼ାଲିଂ ପାଉଲ୍‌ ୱେଡ଼ାହନି ବିତ୍ରେ ହିଜ଼ି ହାଲ୍‌ଜି ଏପିସ ଗାଡ଼୍‌ଦ ଏକାତାନ୍‌ ହେବେ ହେୱାନ୍‌ କେତେକ୍‌ ଚେଲାରିଂ ଚଞ୍ଜ୍ୟାତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","ହେୱାନ୍‌ ହେୱାରିଂ ୱେନ୍‌ବାତାନ୍‌, “ପାର୍ତି କିନି ୱେଡ଼ାଲିଂ ଇନାକା ପୁଇପୁୟା ଜିବୁନ୍‌ତିଂ ଗାଟାଜ଼ି ମାଚାଦେର୍‌ କି ?” ହେୱାର୍‌ ତାଙ୍ଗ୍‌ ଉତର୍‌ ହିତାର୍‌, ଆକାୟ୍‌ “ପୁଇପୁୟା ଜିବୁନ୍‌ ଜେ ମାନାତ୍‌, ଇଞ୍ଜି ଆପେଂ ୱେନ୍‍ୱାତାପ୍ନା ।” ");
INSERT INTO peg_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","ଲାଗିଂ ହେୱାନ୍‌ ୱେନ୍‌ବାତାନ୍‌, “ୱାଟିଙ୍ଗ୍‌ ଏପେଙ୍ଗ୍‌ ଇନାକାତ ବାପ୍ତିସିମ୍‌ ଆଜ଼ି ମାଚାଦେର୍‌ ?” “ହେୱାର୍‌ ଇଚାର୍‌, ଜହନ୍‌ତି ବାପ୍ତିସିମ୍‌ତ ।” ");
INSERT INTO peg_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","ହେବେଣ୍ଡାଂ ପାଉଲ୍‌ ଇଚାନ୍‌, “ଜହନ୍‌ ମାନ୍‌ବାଦ୍‌ଲାୟ୍‌ କିନି ବାପ୍ତିସିମ୍‍ତ ବାପ୍ତିସିମ୍‌ ହିଜ଼ି, ଜିସୁ ପାଚେ ଇନେର୍‌ ୱାନାନ୍, ହେୱାନ୍‌ ତାକେ, ଇଚିସ୍‌ ଜିସୁତି ତାକେ ପାର୍ତି କିଦେଙ୍ଗ୍‌ ଆନାତ୍‌ ଇଞ୍ଜି ଜହନ୍‌ ଇସ୍ରାଏଲ୍‌ ଲକୁରିଂ ଇଞ୍ଜି ମାଚାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","ହେୱାର୍‌ ଇଦାଂ ୱେନ୍‌ଞ୍ଜି ମାପ୍ରୁ ଜିସୁତି ତର୍‌ଦ ବାପ୍ତିସିମ୍‌ ଆତାର୍‌, ");
INSERT INTO peg_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","ଆରେ ପାଉଲ୍‌ ହେୱାର୍‌ ଜପି କେଇ ଇଟ୍‍ତିଲେ, ପୁଇପୁୟା ଜିବୁନ୍‌ ହେୱାର୍‌ ଜପି ଜୁତ୍‌ତାନ୍‌, ଆରେ ହେୱାର୍‌ ବାର୍‍ବିନ୍‍ ବାସାତ କାତା ଇଞ୍ଜେଙ୍ଗ୍‌ ଆରି ବେଣ୍‌ବାକ୍‌ଣାୟ୍‌କିନାକାନ୍‌ ପା ଇଞ୍ଜେଙ୍ଗ୍‌ ଲାଗାତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","ହେୱାର୍‌ ୱିଜ଼ାର୍‌ ଆନ୍‌ ମାନ୍ତ ବାର୍ ଜାଣ୍‌ ଆଣ୍ଡ୍ରାହିମ୍‌ଣାଂ ମାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","ପାଚେ ହେୱାନ୍‌ ପାର୍ତାନା ଇଞ୍ଜ ହଣ୍‌ଜି ତିନ୍‌ ମାସ୍‍ ପାତେକ୍‌ ସାସ୍‌ ଲାହାଙ୍ଗ୍‌ ଇସ୍ୱର୍‌ତି ରାଜି ବିସ୍ରେ ଉପ୍‌ଦେସ୍‍ ହିଜ଼ି ପାର୍ତି ବାଡାୟ୍‌ କିଦେଂ ସେସ୍ଟା କିଦେଙ୍ଗ୍‌ ଲାଗାତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","ମତର୍‌ ହେ ଏଚେକାଡ଼୍‌ଦ ଏଚେକ୍‌ ଲକୁ ଆଟ୍‌ୱା ଆରି ଅମାନ୍ୟା ଆଜ଼ି ଲକୁର୍‍ ମୁମ୍‌ଦ ହେ ହାଜ଼ି ବିସ୍ରେ ନିନ୍ଦା କିଦେଙ୍ଗ୍‌ ଲାଗାତାର୍‌, ହେ ଏଚେକାଡ଼୍‌ଦ ହେୱାନ୍‌ ହେୱାରିଂ ପିସ୍ତି ଚେଲାରିଂ ବିନେ କିତାନ୍‌, ଆରେ ନିତ୍ରେ ତୁରାନ୍ନନି ଇଲ୍‌ ଆଲ୍‌ଚାନା କିଦେଙ୍ଗ୍‌ ଲାଗାତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","ଇ ବାନି ରି ବାର୍ହୁ ପାତେକ୍‌ ଆତାତ୍‌; ହେବେ ଆସିଆ ନିକାର୍‌ ଜିହୁଦି ଆରି ଗ୍ରିକ୍‌ ୱିଜ଼ାର୍‌ ମାପ୍ରୁତି ବଚନ୍‌ ୱେଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","ଆରେ, ଇସ୍ୱର୍‌ ପାଉଲ୍‌ତିଂ କେଇ ହୁଦାଂ ଆବିୱିତି ସାକ୍ତିନି କାମାୟ୍‌ କିଜ଼ି ମାଚାନ୍‌, ");
INSERT INTO peg_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","ଏଲେଂକି ପାଉଲ୍‌ ତା ଗାଗାଡ଼୍‍ତାଂ ରୁମାଲ୍ କି ତୁୱାଲ୍‌ ରଗ୍ୟାର୍‌ ଲାଗେ ତାହିୱାତିସ୍, ହେୱାର୍‌ ତାଙ୍ଗ୍‌ ରଗ୍‌ ପିସ୍ତି ହାଲ୍‌ଜି ମାଚାତ୍‌ ଆରି ବାନ୍ୟାପୁଦା ହସି ହାଲ୍‍ଜି ମାଚିକ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","ମତର୍‌ ବୁଲାନି ଜିହୁଦିର୍‌ ଚୁଟ୍‍କିଆର୍‍ ବିତ୍ରେ କେତେକ୍‌ ଜାଣ୍‌ତିଂ ବାନ୍ୟାପୁଦା ଲାଗାଜ଼ି ମାଚି ଲକୁର୍‍ ଜପି ମାପ୍ରୁ ଜିସୁତି ତର୍‌ ଇଚିଲେ କସ୍ଟ ଆଜ଼ି ଇଚିକ୍‌, ଇମ୍‌ଣି ଜିସୁଙ୍ଗ୍‌ “ପାଉଲ୍‌ ସୁଣାୟ୍‌ କିଦେଙ୍ଗ୍‌ ଲାଗାନାନା, ଆନ୍‌ ମିଙ୍ଗ୍‌ ହେୱାନ୍ତି ବଲ୍‌ ହିଦ୍‍ନାଙ୍ଗା ।” ");
INSERT INTO peg_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","ଆରେ, ସ୍କେବା ତର୍‌ନି ରୱାନ୍‌ ଜିହୁଦି ମୁଡ଼୍‌ ମାପ୍ରୁହେବା କିନାକାନ୍‌ତି ସାତ୍‌ଜାଣ୍‌ ମାଜ଼ିର୍‌ ଇ ଲାକେ କିଜ଼ି ମାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","ହେବେ ବାନ୍ୟାପୁଦା ହେୱାରିଂ ଉତର୍‌ ହିତାନ୍‌, “ଆପ୍‌ ଜିସୁଙ୍ଗ୍‌ ପୁନାପ୍‌ ଆରି ପାଉଲ୍‌ତିଂ ଚିନିକିତାପ୍‌ନ୍ନା; ମତର୍‌ ଏପେଙ୍ଗ୍‌ ଇମ୍‍ଣାକାଦେର୍ ?” ");
INSERT INTO peg_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","ହେ ଏଚେକାଡ଼୍‌ଦ ବାନ୍ୟାପୁଦା ଆହ୍ୟାତି ଲଗୁ ହେୱାର୍‌ତି ଜପି ଗୁମ୍‌ଜି ସାକ୍ତିତାଂ ହେୱାନ୍‌ ରିୟାରିଂ ଆରାୟ୍‌ କିଜ଼ି ହେୱାରିଂ ଦାକା କିତାତ୍‌ ଜେ, ହେୱାର୍‌ ନାଗ୍‍ଡ଼ା ଆରି ଗାଅଦାଆ ଆଜ଼ି ହେ ଇଲ୍‌ତାଙ୍ଗ୍‌ ହସି ହାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","ଇ କାତା ଏପିସ ନିକାର୍‌ ଜିହୁଦି ଆରି ଗ୍ରିକ୍‌ ୱିଜ଼ାର୍‌ ପୁଚାର୍ । ହେବେ ୱିଜ଼ାର୍‌ ପାଣ୍ଡ୍ରା ଆତାର୍‌, ଆରେ ମାପ୍ରୁ ଜିସୁତି ତର୍‌ ଜାଜ୍‌ମାଲ୍‌ ଆଦେଂ ଲାଗାତାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","ଆରେ, ପାର୍ତିନିକାର୍‌ ବିତ୍ରେ ଆଦେକ୍‌ ୱାଜ଼ି ଜାର୍‌ ଜାର୍‌ କାମାୟ୍‌ ମାନିକିତାର୍‌ ଆରି ୱେଚ୍‍ଚେଂ ଲାଗାତାର୍‌, ");
INSERT INTO peg_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","ଆରେ ମନ୍ତର୍‌ କାମାୟ୍‌ କିନାକାର୍ ଆଦେକ୍‌ ଜାର୍‌ ଜାର୍‌ ପତି ତାହିୱାଜ଼ି ରୁଣ୍ଡାୟ୍‌ କିଜ଼ି ୱିଜ଼ାକାର୍‌ ମୁମ୍‌ଦ ହୁଡ଼୍‌ଜ଼ି ତୁହିତାର୍; ହେୱାର୍‌ ହେ ସବୁନି ମଲ୍‌ ହିସାବ୍‍ କିତିଲେ ହେଦାଂ ରିକଡ଼ି ଦସ୍‌ ହାଜାର୍‌ ରୁପା ଟାକାଂ ଇଞ୍ଜି ହୁଡ଼୍‌ତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","ଇ ଲାକେ ମାପ୍ରୁତି ବଚନ୍‌ ସାକ୍ତିତାଂ ବାଡାଦେଂ ଆରି ଆଦିକ୍‌ ସାକ୍ତି ଆଦେଂ ଲାଗାତାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","ଇ ୱିଜ଼ୁ ବିସ୍ରେ ୱିସ୍ତି ପାଚେ ପାଉଲ୍‌ ମାକିଦନିଆ ଆରି ଆକାୟା ହିଜ଼ି ଜିରୁସାଲମ୍‌ତ ହାଞ୍ଜେଙ୍ଗ୍ ମାନ୍‌ତ ତିର୍‌ କିଜ଼ି ଇଚାନ୍‌, “ହେବେ ହାଚି ପାଚେ, ନାଙ୍ଗ୍‌ ରମ୍‌ତ ପା ହାଞ୍ଜେଙ୍ଗ୍‌ ଆନାତ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","ଆରେ, ଇମ୍‌ଣାକାର୍‌ ହେୱାନ୍ତି ହେବା କିଜ଼ି ମାଚାର୍, ହେୱାର୍‌ ବିତ୍ରେ ତିମତି ଆରି ଏରାସ୍ଟ, ଇ ରିୟାରିଂ ମାକିଦନିଆତ ପକ୍‌ଚି ହେୱାନ୍‌ ନିଜେ ଅଲପ୍‍ କାଡ଼୍‌ ପାତେକ୍‌ ଆସିଆ ଦେସ୍‌ତ ମାଚାନ୍ । ");
INSERT INTO peg_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","ହେ ୱେଡ଼ାଲିଂ ଇ ହାଜ଼ି ବିସ୍ରେ ବେସି ଅଜ଼ି ଏପିସିତ ବେସି ଗଣ୍ଡ୍‌ଗଲ୍‌ ଆତାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","ଇନାକିଦେଂକି ଦିମିତ୍ରିୟ ତର୍‌ନି ରୱାନ୍‌ ହନାରି ଆର୍ତେମିନି ରୁପା ମନ୍ଦିର୍‌ ରଚ୍‌ଚି ମାଚାନ୍‌, ଆରେ ବାନାରଚ୍‍ନାକନ୍ ବେସି ଲାବ୍‍ କିଜ଼ି ମାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","ହେୱାନ୍‌ ହେୱାରିଂ ଆରି “ହେ ବେପ୍ରିୟାର୍ ବାନାରଚ୍‍ନାକାରିଂ କୁକ୍‌ଚି ଇଚାନ୍‌, ମାପ୍ରୁର୍, ଇ ବେପାର୍‌ ହୁଦାଂ ଆପେଂ ଦନ୍‍ ପାୟାନାପ୍‌ ଇଞ୍ଜି ଏପେଙ୍ଗ୍‌ ପୁନାଦେରା; ");
INSERT INTO peg_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","ଆରେ, କେଇରଚ୍‌ଚି ପୁତ୍‌ଡ଼ାଂ ଇସ୍ୱର୍‌ ଆକାୟ୍‌ ଇଞ୍ଜି ଇଞ୍ଜି ଇ ପାଉଲ୍‌ କେବଲ୍‌ ଏପିସତ ଆକାୟ୍‌, ମତର୍‌ ୱିଜ଼ୁ ଆସିଆତ ଦେସ୍‌ତ ଜବର୍‌ ମାନାୟ୍‍ତିଂ ବୁଜାୟ୍‌ କିୟ୍‌ କିଜ଼ି ଇନାନା, ଇଦାଂ ଏପେଙ୍ଗ୍‌ ହୁଡ଼୍‍ନାଦେରା ଆରି ୱେନାଦେରା । ");
INSERT INTO peg_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","ଇବେ ଜେ କେବଲ୍‌ ମା ଇ ବେପାର୍‍ନି ବାନ୍ୟା ତର୍‌ ଆନାକା ପାଣ୍ଡ୍ରୁ ମାନାତ୍‌, ହେଦାଂ ଆକାୟ୍‌, ମତର୍‌ ଇମ୍‌ଣି ଗାଜା ପେନ୍‌ ଆର୍ତେମିତି ୱିଜ଼ୁ ଆସିଆ ଆରି ପୁର୍ତି ଜାକ୍‌ ପାର୍ତାନା କିତାର୍‌, ହେୱାନ୍ତି ମନ୍ଦିର୍‌ ପା ଉଣା ଆନାକା ଆରି ତାଦାଂ ସନ୍‍ମାନ୍ ନସ୍ଟ ଆଦେଂ ପା ଗିଟାନି ପାଣ୍ଡ୍ରୁ ମାନାତ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","ଇ କାତା ୱେନ୍‌ଞ୍ଜି ହେୱାର୍‌ ରିସାତ ବାର୍ତି ଆଜ଼ି ରାଟୁ କିଜ଼ି ଇଞ୍ଜେଙ୍ଗ୍ ଲାଗାତାର୍‌, ଏପିସିୟର୍‌ତି “ଆର୍ତେମି ଗାଜା ପୁତ୍‌ଡ଼ା ଜୟ୍‌ ଆଏତ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","ଇବେଣ୍ଡାଂ ଗାଡ଼୍‌ କିରତ ବାର୍ତି ଆତାତ୍‌, ଆରେ ହେୱାର୍‌ ର ମାନ୍‌ତାଂ ପାଉଲ୍‌ତି ରଚେ ହାଚାକାନ୍ ମାକିଦନିଆନି ଗାୟ ଆରି ଆରିସ୍ତାର୍କତିଂ ଆସ୍ତି ମେଲ୍ୟାର୍‌ ବୁମିତ ହନ୍‍ଞ୍ଚି ହାଚାର୍ । ");
INSERT INTO peg_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","ଇବେ ପାଉଲ୍‌ ଲକୁ ବିତ୍ରେ ହାଞ୍ଜେଙ୍ଗ୍‌ ଇଚା କିତାନ୍‌, ମତର୍‌ ଚେଲାର୍‌ ତାଙ୍ଗ୍‌ ହାଞ୍ଜେଙ୍ଗ୍‌ ହିୱାତାର୍ । ");
INSERT INTO peg_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","ଆରେ, ଆସିଆନି ମୁଡ଼୍‌ କାମାୟ୍‌ କିନାକାର୍ ବିତ୍ରେତାଂ ପା ଏଚେକ୍‌ ଜାଣ୍‌ ହେୱାନ୍ତି ହାଙ୍ଗ୍‌ଦାକାର୍‌ ମାଚିଲେ ଲକୁ ପକ୍‌ଚି ମେଲ୍ୟାର୍‌ ବୁମି ବିତ୍ରେ ସାସ୍‌ ହିଲ୍‌ୱାଦାଂ ହାଲ୍‍ୱି କାଜିଂ ତାଙ୍ଗ୍‌ ଗୱାରି କିତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","ହେ ଏଚେକାଡ଼୍‌ଦ ଇନେର୍‌ ଇନେର୍‌ ଇ କାତା, ଇନେର୍‌ ଇନେର୍‌କି ହେ କାତା ଇଞ୍ଜି କିକିରାଡିଂ କିଜ଼ି ମାଚାର୍‌, ଇନାକିଦେଂକି ସବା ରାଟୁତ ବାର୍ତି ଆଜ଼ି ମାଚାତ୍‌, ଆରେ ହେୱାର୍‌ ଜେ ଇନାକିଦେଂ ରବେରୁଣ୍ତା ଆତାର୍ଣ୍ଣା, ହେଦାଂ ଆଦେକ୍‌ ପୁନ୍‌ୱାଦାଂ ମାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","ଆରେ, ଜିହୁଦିର୍‌ ଆଲେକ୍‌ଜାଣ୍ଡର୍‌ତିଂ ଆଗେ ହପ୍‍ଚି ତାହିୱାତିଲେ ଲକୁ ବିତ୍ରେତାଂ ଇନେର୍‌ ଇନେର୍‌ ତାଙ୍ଗ୍‌ ଟିଉଲାୟ୍‌ କିତାର୍‌; ହେବେ ଆଲେକ୍‌ଜାଣ୍ଡର୍‌ କେଇଦାଂ ଚଚ୍‍ଚି ଲକୁର୍‍ ଲାଗାୟ୍‌ ହେୱାର୍‌ତି ପାକ୍ୟାଜ଼ି ଇଞ୍ଜେଙ୍ଗ୍‌ ଇଚା କିତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","ମତର୍‌ ହେୱାନ୍‌ ରୱାନ୍‌ ଜିହୁଦି ଇଞ୍ଜି ହେୱାର୍‌ ପୁଚାର୍, ହେ ଏଚେକାଡ଼୍‌ଦ ୱିଜ଼ାର୍‌ କାଟ୍‌ତ ରି ଗଣ୍ଟା ପାତେକ୍‌ କିକିରାଡିଂ କିଜ଼ି ଇଞ୍ଜେଙ୍ଗ୍‌ ଲାଗାତାର୍‌, ଏପିସିୟର୍‌ତି “ଆର୍ତେମି ଗାଜା ପୁତ୍‌ଡ଼ା ଜୟ୍‌ ଆଏତ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","ପାଚେ ଗାଡ଼୍‌ନି ମୁସ୍ତିଦାର୍‌ ଲକୁ ୱିଜ଼ୁତିଂ ସୁସ୍ତା କିଜ଼ି ଇଚାର୍‌, “ଏ ଏପିସିୟନି ଲକୁର୍, ଏପିସ ଗାଡ଼୍‌ ଜେ ଗାଜା ପୁତ୍‌ଡ଼ା ଆର୍ତେମି ମନ୍ଦିର୍‌ ଆରି ବାଦାଡ଼୍‌ ତାଂ ଜୁଜ଼ି ୱାଜ଼ିମାନି ପୁତ୍‌ଡ଼ା ମନ୍ଦିର୍‌ନି କାର୍‌ନିୟା, ଇଦାଂ ଇନେର୍‌ ପୁନ୍‍ୱାତାର୍ଣ୍ଣା ? ");
INSERT INTO peg_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","ଇନେର୍‌ ମାନିକିଉର୍‌ ଇ ସବୁ କାତା ଡ୍ରିଙ୍ଗ୍‍ୱିତିଲେ ମିଦାଙ୍ଗ୍‌ ସୁସ୍ତା ଆନାକା ଆରି ବାବିକିୱି କାମାୟ୍‌ କିୱି କାତା । ");
INSERT INTO peg_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","ଇନାକିଦେଂକି ଇ ଇମ୍‌ଣି ଲକୁରିଂ ଏପେଙ୍ଗ୍‌ ତାହିୱାତାଦେର୍ଣ୍ଣା, ଇୱାର୍‌ତ ମନ୍ଦିର୍‌ ଚରି କିନାକାର୍‌ ଆକାୟ୍‌ କି ମା ଦେବିତିଂ ନିନ୍ଦା କିନାକାର୍ ଆକାୟ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","ଲାଗିଂ ଜଦି ଇନେର୍‌ର୍ତି ବିରୁଦ୍‌ତ ଦିମିତ୍ରିୟ ଆରି ତା ହାଂଙ୍ଗ୍‌ଦାକାନ୍‌ ବାନାରଚ୍‍ନାକାର୍ତି ଇନାକାପା କାତା ମାଚିସ୍‌, ତା ଆତିସ୍‌ ବିଚାର୍ଣ୍ଣା ଇଲ୍‌ ଜେତାକା ମାନାତ୍‌ ଆରି ସାସନ୍‍କାର୍‍ୟାର୍ ମାନାର୍‌; ହେୱାର୍‌ ହାରି ବିରୁଦ୍‌ତ ଦାବା କିଏର୍ । ");
INSERT INTO peg_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","ମତର୍‌, ଜଦି ମିଦାଙ୍ଗ୍‌ ବିନ୍‌ ଇମ୍‌ଣି ଦାବା ମାଚିସ୍‌, ୱାଟିଙ୍ଗ୍‌ ନିୟମ୍‌ କିତି ର ସବାତ ତା ରୁଜୁକ୍‌ ଆନାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","ଇନାକିଦେଂକି ହାତ୍‌ପାନେ ନେଞ୍ଜେଙ୍ଗ୍‌ନି କିର ଅଜ଼ି ମା ବିରୁଦ୍‌ତ ଦାବା ଆନି ପାଣ୍ଡ୍ରୁ ମାନାତ୍‌; ଆପେଂ ଇ କିର ଇମ୍‌ଣି କାରଣ୍‌ ଚଚ୍‍ଚେଙ୍ଗ୍ ଆଡୁପ୍ ।” ");
INSERT INTO peg_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","ଇଦାଂ ଇଞ୍ଜି ହେୱାନ୍‌ ସବାନି ୱିଜ଼ାରିଂ ହେଲୱେୟ୍‌ ହିତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","ହେ ଗଣ୍ଡ୍‌ଗଲ୍‌ ଚିମ୍‌ରା ଆତି ପାଚେ ପାଉଲ୍‌ ଚେଲାରିଂ କୁକ୍‌ଚି ହେୱାରିଂ ୱାରିକିୟ୍‌କିନି ପାଚେ, ଆରେ ହେୱାର୍‌ ତାଙ୍ଗ୍‌ ହେଲୱେୟ୍‌ ଅଜ଼ି ମାକିଦନିଆତ ହାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","ହେୱାନ୍‌ ଇମ୍‌ଣି ନିପ ହିଜ଼ି ହାଲ୍‌ଜି ହେୱାନ୍‌ ମାନାୟାରିଂ ବେସି ୱାରିକିୟ୍‌କିନି ପାଚେ ଗ୍ରିସ୍‌ତ ୱାତାନ୍ । ");
INSERT INTO peg_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","ହେୱାନ୍‌ ହେ ବାହାତ ତିନ୍‌ ମାସ୍‍ ମାଞ୍ଜି ଏଚେକାଡ଼୍‌ଦ ଜାଜ୍‌ତ ଦୁମ୍‌ଜି ସିରିୟାତ ହାଞ୍ଜେଙ୍ଗ୍‌ ସେସ୍ଟା କିତାନ୍‌, ଏଚେୱାଡ଼ାଂ ଜିହୁଦିର୍‌ ପାଉଲ୍‌ତିଂ ବିରୁଦ୍‌ତ ହାତୁର୍‍ କିତିଲେ ହେୱାନ୍‌ ମାକିଦନିଆ ହିଜ଼ି ମାସ୍‍ଦିହାଞ୍ଜେଙ୍ଗ୍ ବାବି କିତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","ଆରେ ବେରିୟାନିକାର୍ ପୁରତି ମାଜ଼ି ସପାତ୍ର, ତେସ୍‌ଲନିକିୟ ନିକାର୍‌ ବିତ୍ରେ ଆରିସ୍ତାର୍କ ଆରି ସେକୁନ୍ଦ, ଦର୍ବିନି ଗାୟ, ତିମତି, ଆରେ ଆସିଆନି ଲକୁ ବିତ୍ରେ ତୁକିକ ଆରି ତ୍ରପିମ ତା ହାଙ୍ଗ୍‌ଦାଂ ହାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","ଇୱାର୍‌ ୱିଜ଼ାର୍‌ ଆଗେ ହାଲ୍‌ଜି ତ୍ରୟାତ ମାଙ୍ଗେଙ୍ଗ୍‌ କାସି ମାନ୍‍ଞ୍ଚାନ୍ । ");
INSERT INTO peg_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","ଆରେ, ହଇୱି ରୁଟିନି ପାର୍ବୁ ପାଚେ ଆପେଂ ଜାଜ୍‌ତ ଦୁମ୍‌ଜି ପିଲିପିତାଂ ହାଜ଼ି ଆସ୍ତାପ୍‌, ଆରେ ପାଞ୍ଚ୍‌ ଦିନ୍ତ ତ୍ରୟାତ ହେୱାର୍‌ ଲାଗାୟ୍‌ ୱାତାପ୍; ହେ ବାହାତ ଆପେଂ ସାତ୍‌ ଦିନ୍‌ ମାଚାପ୍ । ");
INSERT INTO peg_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","ଆପେଂ ସାତ୍‌ନି ପର୍ତୁମ୍‌ ରଇବାର୍‌ ନାଜିଂ ଏଚେକାଡ଼୍‌ଦ ତିଞ୍ଜେଙ୍ଗ୍‌ ରବେରୁଣ୍ତା ଆଜ଼ି ମାଚାପ୍, ପାଉଲ୍‌ ହେ ଏଚେୱାଡ଼ାଂ ଆର୍କାତ୍‌ ନାଜିଂ ହାନାନ୍‍ ଇଞ୍ଜି ଜାଲ୍‌ଦି ଆଜ଼ି ମାଚିଲେ ହେୱାରିଂ ଉପ୍‍ଦେସ୍‌ ହିଦେଂ ଲାଗାତାନ୍‌ ଆରି ଆଦାନାଣା ପାତେକ୍‌ ଲାମା କାତା ହିତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","ଇମ୍‌ଣି ଜପ୍‍ଣି ବାକ୍ରାତ ଆପେଂ ରବେ ରୁଣ୍ଡାଜ଼ି ମାଚାସ୍, ହେ ବାକ୍ରାତ ବେସି ବଇଟାଂ କାଚା ଆଜ଼ି ମାଚିକ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","ଆରେ, ଚିଟ୍‌କି ଜପି ଇଉତୁକ ତର୍‌ନି ରୱାନ୍‌ ଦାଂଣେନ୍ ଲଗୁ କୁଚ୍‌ଚି ମାଚାନ୍‌, ହେୱାନିଂ ବେସି ହୁଚ୍‍କାଣ୍‍କୁ ହସି ମାଚିକ୍‌; ଆରେ ପାଉଲ୍‌ ଆରେ ଡେଙ୍ଗା ଉପ୍‌ଦେସ୍‌ କିତିଲେ ହେୱାନ୍‌ ହୁଚ୍‍କାଣ୍‍କୁ ମାୟାତାଂ ତିନି ପାଉଚ୍‍ତାଂ ତାରେନ୍‌ ଆର୍ତାନ୍, ଆରେ ତାଙ୍ଗ୍‌ ନିକ୍‍ତି ୱେଡ଼ାଲିଂ ହେୱାନ୍‌ ହାତାନ୍ନା ଇଞ୍ଜି ପୁନ୍ୟାତାତ୍ । ");
INSERT INTO peg_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","ହେବେ ପାଉଲ୍‌ ତାରେନ୍‌ ଜୁଜ଼ି ୱାଜ଼ି ତାଙ୍ଗ୍‌ ପମ୍‌ଜି ଇଚାନ୍‌, “ଚିନ୍ତା କିମା, ଇନାକିଦେଂକି ଇୱାନ୍‌ ତାକେ ଜିବୁନ୍‌ ମାନାତ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","ପାଚେ ହେୱାନ୍‌ ଜପି ହାଲ୍‌ଜି ରୁଟି ଡ୍ରିକ୍‌ଚି ଚିଚାନ୍, ଆରେ ହେୱାର୍‌ ଲାହାଙ୍ଗ୍‌ ନାଡ଼ିହିଙ୍ଗ୍ ଆନି ପାତେକ୍‌ ବେସି କାତାବାର୍ତା କିଜ଼ି ହାଜ଼ି ଆସ୍ତାନ୍ । ");
INSERT INTO peg_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","ଆରେ, ହେୱାର୍‌ ହେ କାଡ଼୍‌ଦେଙ୍ଗ୍‌ ଜିଜ଼ି ମାନାକା ଗାଟାଜ଼ି ଆଦିକ୍‌ ୱାରିକିୟ୍‌କିନି କାଜିଂ ହେୱାର୍‌ ଆଦିକ୍‌ ହେୱାରିଂ ଆରି ଇଞ୍ଜ ଅସି ହାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","ମତର୍‌, ଆପେଂ ଆକ୍‌ତୁ ଜାଜ୍‌ତ ଦୁମ୍‌ଜି ଆସସ୍‌ତ ହାଚାପ୍, ହେବେତାଂ ପାଉଲ୍‌ତିଂ ଅସି ହାନି କାଜିଂ ବାବି କିଜ଼ି ମାଚାପ୍, ଇନାକିଦେଂକି ହେୱାନ୍‌ ନିଜେ ହାଜ଼ିତ ହାଞ୍ଜେଙ୍ଗ୍‌ କାଜିଂ ଇଚା କିଜ଼ି ହେ ବାନି ତିର୍‌ କିଜ଼ି ମାଚାନ୍ । ");
INSERT INTO peg_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","ଏଚେକାଡ଼୍‌ଦ ହେୱାନ୍‌ ମାଂ ଆସସ୍‌ତ ବେଟା ଆତ୍‍ତାନ୍, ଆପେଂ ତାଙ୍ଗ୍‌ ଜାଜ୍‌ତ ଅଜ଼ି ମିତୁଲିନିତ ଏକାତାପ୍, ");
INSERT INTO peg_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","ଆରେ ହେ ବାହାତାଂ ଜାଜ୍ ରିକ୍‌ଚି ଆପେଂ ଆର୍କାତ୍‌ ନାଜିଂ କିୟସ୍‌ ମୁମ୍‌ଦ ଏକାୱାତାପ୍, ରି ଦିନ୍‌ନ୍ତାଙ୍ଗ୍‌ ଜାଜ୍‌ ସାମତ ଡୁକାୟ୍‍କିତାପ୍ ଆରି ଆର୍କାତ୍‌ ଦିନା ମିଲିତତ ଏକାତାପ୍ । ");
INSERT INTO peg_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","ଇନାକିଦେଂକି ପାଉଲ୍‌ତି ଆସିଆତ ଇନେସ୍‌ ସମୁ ମାଞ୍ଜେଙ୍ଗ୍ ଆମେତ୍‌, ଇଦାଂ କାଜିଂ ହେୱାନ୍‌ ଏପିସ ପିସ୍ତି ହାଞ୍ଜେଙ୍ଗ୍‌ ବିଚାର୍‌ କିଜ଼ି ମାଚାନ୍‌, ଲାଗିଂ ଆତିସ୍‌ କାତେ ପେଣ୍ଟିକସ୍ଟ ନାଜିଂ ଜିରୁସାଲମ୍‌ତ ଏକିନି କାଜିଂ ହେୱାନ୍‌ ତିର୍‍କାଡ଼୍‍ ଆବିସ୍ ମାଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","ମିଲିତତାଂ ପାଉଲ୍‌ ଏପିସତ ଲକୁ ପକ୍‌ଚି ମଣ୍ଡ୍‌ଲିନି ପ୍ରାଚିନାରିଂ ଜାର୍‌ ଲାଗେ କୁକ୍‌ଚି ତାହିୱାତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","ହେୱାର୍‌ ତା ଲାଗାୟ୍‌ ଏକିତିଲେ ହେୱାନ୍‌ ହେୱାରିଂ ଇଚାନ୍‌, ରମିୟ ରାଜିନି “ଆସିଆତ ମାନି ପର୍ତୁମ୍‌ ଦିନ୍‌ତାଂ ଆନ୍‌ ୱିଜ଼ୁ ସମୁ ମି ବିତ୍ରେ ଇନେସ୍‌ ଚିନ୍ତା କିତାଂ, ");
INSERT INTO peg_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","ପୁରାବାର୍ତି ହୁଦାର୍ ମାନ୍ତ ମେଣ୍ଡାଙ୍ଗ୍‌କୁନ୍ଦି ହୁଦାଂ ଜିହୁଦିର୍‌ତି ବାର୍‍ବିନ୍‍ କୁଟ୍‌ କାଜିଂ ନାଙ୍ଗ୍‌ ଇମ୍‌ଣି ଇମ୍‌ଣି ପରିକ୍ୟା ଗିଟାଜ଼ି ମାଚାତ୍‌, ହେ ସବୁ ପା ଇନେସ୍‌ ମାପ୍ରୁତି ହେବା କିଜ଼ି ମାଚାଙ୍ଗ୍, ");
INSERT INTO peg_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","ଏପେଙ୍ଗ୍‌ ପୁନାଟ୍‌ ଜେ, ଆନ୍‌ ମାନାୟାର୍‌ ଲାଗାଂ ପର୍‌ଚାର୍‌ କିନି ସମୁତ ଆରି ମି ଇଲ୍‌ ଉପ୍‌ଦେସ୍‌ ହିନି ସମୁତ ମି ଉପ୍‌କାର୍‌ ଆନି ଲାକେ ଇମ୍‌ଣାକା ପା ବିସ୍ରେ ୱେଚ୍‍ଚେଂ, ବନ୍ଦ୍‌ କିୱାଦାଂ ମାଚାଙ୍ଗ୍‌ ");
INSERT INTO peg_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","ହିକ୍ୟା ହିଦେଂ ମଦାୱାଦାଂ ଇସ୍ୱର୍‌ ତାକେ ମାନ୍‌ବାଦ୍‌ଲାୟ୍‌ ଆରେ, ମା ମାପ୍ରୁ ଜିସୁତି କାଜିଂ ପାର୍ତିନି ବିସ୍ରେ ଜିହୁଦି ଆରି ଗ୍ରିକ୍‌ତି ଲାଗାୟ୍‌ ସାକି ହିଜ଼ି ମାଚାଙ୍ଗ୍ ହେଦାଂ ଏପେଙ୍ଗ୍‌ ପୁନାଟ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","ନଙ୍ଗ୍‌ ହୁଡ଼ାଟ୍‌, ଆନ୍‌ ପୁଇପୁୟା ଜିବୁନ୍‌ତ ଉଦେସ୍‌ ପାୟାଜ଼ି ଜିରୁସାଲମ୍‌ତ ହାନାଙ୍ଗା, ହେ ବାହାତ ନା କାଜିଂ ଇନାକା ସବୁ ଗିଟାନାତ୍‌, ହେଦାଂ ଆନ୍‌ ପୁନୁଙ୍ଗ୍‌, ");
INSERT INTO peg_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","ନା କାଜିଂ ଜେ ହିକ୍‌ଡ଼ି ଗାଚ୍‍ନାକା ଆରି ଦୁକ୍‌ ମାନାତ୍‌, କେବଲ୍‌ ଏଚେକ୍‌ ପୁନାଙ୍ଗ୍‌, ଇଦାଂ ପୁଇପୁୟା ଜିବୁନ୍‌ ଗାଡ଼୍‌ଦ ବସ୍ତିତ ସାକି ହିତ୍‍ତାନ୍ନା । ");
INSERT INTO peg_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","ମାତର୍‌ ଆନ୍‌ ଇନେସ୍‌ ନା ସମାନ୍‌ ହାଜ଼ିନି ହାରିହାରା ପାତେକ୍‌ ହନ୍ତେଙ୍ଗ୍‌ ଆଡ୍‌ନାଙ୍ଗ୍‌, ଆରେ ଇସ୍ୱର୍‌ତି ଦୟାନି ନେକ୍ରିକାବୁର୍‌ ପାକ୍ୟାତ ସାକି ହିନି କାଜିଂ ମାପ୍ରୁ ଜିସୁତାଂ ଇମ୍‌ଣି ହେବାନି କାମାୟ୍‌ ପାୟାତାନ୍ନା, ହେଦାଂ ଇନେସ୍‌ ପୁରାକିଦେଂ ଆଡ୍‌ନାୟ୍‌, ଇଦାଂ କାଜିଂ ଆନ୍‌ ଜାର୍‌ ଜିବୁନ୍‌ତିଂ ହାର୍ଦାକା କିୱାଦାଂ ହେଦାଂ ହାରୁ କିନାଙ୍ଗା ।” ");
INSERT INTO peg_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","ଆରେ ନଙ୍ଗ୍‌ ହୁଡ଼ାଟ୍‌, ଇମ୍‌ଣାକାର୍‌ ବିତ୍ରେ ଆନ୍‌ “ଇସ୍ୱର୍‌ତି ରାଜି ସୁଣାୟ୍‌ କିଦେଙ୍ଗ୍‌ ଇଞ୍ଜି ବୁଲାଆତାଂ, ଏଲେଙ୍ଗ୍‌ ଜେ ଏପେଙ୍ଗ୍‌ ୱିଜ଼ାକାଦେର୍‌, ଆରେ ହୁଡ଼ାଟ୍‌ ନା ମୁମ୍‌ ହୁଡ଼ୁଦେର୍ ଇଞ୍ଜି ଆନ୍‌ ପୁନାଙ୍ଗ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","ଲାଗିଂ ଆନ୍‌ ଜେ ୱିଜ଼ାକାର୍ତି ନେତେର୍‌ନି ପାପି ଆକାୟ୍‌, ଇଦାଂ ଆନ୍‌ ନେଞ୍ଜେଙ୍ଗ୍‌ ମିଙ୍ଗ୍‌ ସାକି ହିଦ୍‍ନାଙ୍ଗା । ");
INSERT INTO peg_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","ଆନ୍‌ ଇସ୍ୱର୍‌ତି ଇଚା ୱିଜ଼ୁ କିତାକା ମିଙ୍ଗେଙ୍ଗ୍‌ ଜାଣାୟ୍‍କିଦେଂ ମଦାୱାଦାଂ ମାଚାଙ୍ଗ୍ । ");
INSERT INTO peg_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","ଏପେଙ୍ଗ୍‌ ଜାର୍‌ ଜାର୍‌ ବିସ୍ରେ, ଆରେ ଇମ୍‌ଣି ମଣ୍ଡ୍‌ଲିତିଂ ଇସ୍ୱର୍‌ ଜାର୍‌ ଜାର୍‌ ନେତେର୍‌ତ କଡ଼୍‌ତାର୍‌ନ୍ନା, ତା ହେ ମଣ୍ଡ୍‌ଲିତିଂ ପାଲି କିଦେଙ୍ଗ୍‌ କାଜିଂ, ପୁଇପୁୟା ଜିବୁନ୍‌ ଜେ ମିଙ୍ଗେଙ୍ଗ୍‌ ୱିଜ଼ୁ ମାନ୍ଦା ବିତ୍ରେ ମୁଣିକା ଲାକେ ବାଚି କିତାର୍ଣ୍ଣା, ହେୱାର୍‌ତି ବିସ୍ରେ ଜାଗ୍ରତ୍‌ ମାନାଟ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","ଆନ୍‌ ପୁନାଙ୍ଗ୍‌, ଆନ୍‌ ହାନି ପାଚେ ମି ବିତ୍ରେ ବଇଁକାର୍‌ ହୁଣ୍ଡାର୍‌ ବୁର୍କାଙ୍ଗ୍ ୱାନିକ୍‌ ଆରି ମାନ୍ଦାତିଂ ଚିର୍‌ବିର୍‌ କିୱାଦାଂ ପିହୁକ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","ଆରେ, ଲକ୍‌ ମି ବିତ୍ରେତାଂ ପା ନିଂଜି ଚେଲାରିଂ ଜାର୍‌ତିଂ ପାଚେ ଜାଲ୍‍ଜି ଅଦେଂ କାଜିଂ ଉଲ୍‍ଟା କାତାଂ ଇନାର୍‌, ଇଦାଂ ଆନ୍‌ ପୁନାଙ୍ଗ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","ଲାଗିଂ, ଏପେଙ୍ଗ୍‌ କାସି ମାନାଟ୍‌, ଆରେ ଆନ୍‌ ତିନି ବାର୍ହୁ ପାତେକ୍‌ ୱେଡ଼ାନାଣା ମେଣ୍ଡାଙ୍ଗ୍‌ କୁନ୍ଦିକିଜ଼ି ଜାଣ୍‍କେ ରୱାନିଂ ଚେତ୍‌ନା ହିଦେଂ ଜେ ଜମ୍‍ୱାଦାଂ ମାଚାଙ୍ଗ୍, ଇଦାଂ ଏତୁ କିୟାଟ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","“ନଙ୍ଗ୍‌ ଆନ୍‌ ମିଙ୍ଗ୍‌ ମାପ୍ରୁ ତାକେ ଆରି ହେୱାନ୍ତି ଦୟାନି ବଚନ୍‌ ଲାଗେ ହେଲାୟ୍‌ କିଦ୍‌ନାଙ୍ଗା, ହେୱାନ୍‌ ମିଙ୍ଗ୍‌ ହାର୍‌ କିଦ୍‌ନି କାଜିଂ ଆରି ପୁଇପୁୟା କିଦ୍‍ଦେଂ ୱିଜ଼ାର୍‌ ବିତ୍ରେ ଆଟ୍‌ୱା କିଦ୍‌ନି ଆରି ଇସ୍ୱର୍‌ତି ମାନାୟାରିଂ ସବୁ ଦୟା ମିଙ୍ଗେଙ୍ଗ୍‌ ହିଦ୍‌ଦେଂ ରାଜି । ");
INSERT INTO peg_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","ଆନ୍‌ ଇନେରିଂ ରୁପା କି ହନା କି ହେନ୍ଦ୍ରା ଲବ୍ କିୱାଦାଂ ମାଚାଙ୍ଗ୍ । ");
INSERT INTO peg_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","ନା ଇ କେଇ ରିଣ୍ଡାଂ ଜେ ନାୱାଙ୍ଗ୍‌ ଆରି ନା ହାଙ୍ଗ୍‍ଦାକାର୍‍ତି ଅବାବ୍‌ ବାର୍ତି କାଜିଂ ହେବାକିନାକା କିଜ଼ି ୱାନାଙ୍ଗା, ଇଦାଂ ଏପେଙ୍ଗ୍‌ ନିଜେ ପୁନାଟ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","ଗାଟାନି ତାଂ ଦାନ୍‌ ହିନାକା ଆଦିକ୍‌ ୱାରି ମାନ୍‌ଗାନାତ୍‌, ନିଜେ ମାପ୍ରୁ ଜିସୁତି ଇ ବଚନ୍‌ତିଂ ଏତୁ କିଜ଼ି ଇ ବାନି କସ୍ଟ କାମାୟ୍‌ ହୁଦାଂ ଆସେଙ୍ଗ୍‌ ନାଦାର୍‌ ଲକୁରିଂ ଉପ୍‌କାର୍‌ କିନି ଲଡ଼ା, ଇ ବିସ୍ରେ ସବୁ ୱେଡ଼ାଂ ମିଂ ହାର୍ଦାକା ଚଚ୍‌ଚାତାଂନା ।” ");
INSERT INTO peg_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","ଇ ସବୁ କାତା ଇଚି ପାଚେ, ହେୱାନ୍‌ ମେଣ୍ଡାଙ୍ଗ୍‌ କୁନ୍ଦିକିଜ଼ି ୱିଜ଼ାର୍‌ ଲାହାଙ୍ଗ୍‌ ହେୱାର୍‌ ପାର୍ତାନା କିତାନ୍‌, ");
INSERT INTO peg_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","ଆରେ, ହେୱାର୍‌ ବେସି ଆଡ଼୍‌ବିସ୍‌ ପାଉଲ୍‌ତିଂ ପମ୍‌ଜି ହେୱାନିଂ ଡନ୍‍ଞ୍ଜେଙ୍ଗ୍ ଲାଗାତାର୍‌, ");
INSERT INTO peg_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","ହେୱାର୍‌ ହେୱାନ୍ତି ମୁମ୍‌ ଆରେ, ଆରେ ରଗ ହୁଡ଼ୁର୍ ଇଞ୍ଜି ପାଉଲ୍‌ ଇମ୍‌ଣି କାତା ଇଞ୍ଜି ମାଚାନ୍‌, ହେଦାଂ କାଜିଂ ବେସି ଦୁକ୍‌ କିତାର୍‌ । ପାଚେ ହେୱାର୍‌ ତାଙ୍ଗ୍‌ ଜାଜ୍‌ ପାତେକ୍‌ ଅସି ହାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","ହେୱାର୍‌ତାଂ ହେଲ ଅସି ଆପେଂ ଜାଜ୍‌ତ ଦୁମ୍‌ଜି ହାଣ୍‍କୁ ହାଜ଼ିତ କସ୍‌ତ ୱାତାପ୍, ଆର୍କାତ୍‌ ନାଜିଂ ରଦାତ, ଆରେ ହେ କାଟାକାଟା ହାଲ୍‌ଜି ପାତାର୍‌ତ ୱାତାପ୍ । ");
INSERT INTO peg_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","ହେବେତାଂ ଆପେଂ ପୈନିକିଆତ ନାସି ହାଲ୍‍ଜି ମାନି ର ଜାଜ୍‌ ଗାଟାଜ଼ି ଆପେଂ ହେବେ ଦୁମ୍‌ଜି ଚାଲାତାପ୍ । ");
INSERT INTO peg_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","ପାଚେ କୁପ୍ର ହୁଡ଼୍‍ୱିତିଲେ ଆପେଂ ଡେବ୍ରି ବାଗାଙ୍ଗ୍‌ ପିସ୍ତି ସିରିୟାତ ଚାଲାଜ଼ି ଟାୟର୍‌ ଇକାତାପ୍‌, ଇନାକିଦେଂକି ହେବେ ଜାଜ୍‌ତାଂ ଜିନିସ୍‍ ଜୁତ୍‌ନାକା ମାଚାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","ହେବେତାଂ ଚେଲାରିଂ ଡେକ୍‌ଚି ହେୱାରିଂ ବେଟା ଆଜ଼ି ସାତ୍‌ ଦିନ୍‌ ହେବେ ମାଚାପ୍‍, ଆରେ, ପାଉଲ୍‌ ଇନେସ୍‌କି ଜିରୁସାଲମ୍‌ତ ହାଲୁନ୍‍, ଇଦାଂ କାଜିଂ ହେୱାର୍‌ ଜିବୁନ୍‌ତାଂ ହେୱାନିଂ ଇଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","ହେ ସାତ୍‌ ଦିନ୍‌ ମାଚି ପାଚେ ହେ ବାହାତାଂ ହାଚାପ୍, ଆରେ ହେୱାର୍‌ ୱିଜ଼ାର୍‌ କଗ୍‌ଲେ ଆରି ହିମ୍‍ଣାୱାକ୍‌ଡ଼ା ହୁକେ ମାଙ୍ଗେଙ୍ଗ୍‌ ଗାଡ଼୍‌ନି ବାର୍ତ ପାତେକ୍‌ ମାଙ୍ଗେଙ୍ଗ୍‌ ପିସ୍ତେଙ୍ଗ୍‌ ୱାତାର୍, ଆରେ, ଆପେଂ ହାମ୍‍ଦୁର୍‌ ଗୁଟିତ ମେଣ୍ଡାଙ୍ଗ୍‌କୁନ୍ଦି କିଜ଼ି ପାର୍ତାନା କିତାପ୍, ");
INSERT INTO peg_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","ପାଚେ ଆପେଂ ଜାଜ୍‌ତ ଦୁମ୍‍ତାପ୍, ଆରେ ହେୱାର୍‌ ଇଞ୍ଜ ମାସ୍‌ଦି ହାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","ଆପେଂ ଟାୟର୍‌ତାଂ ଏସ୍‌ଜାଜ୍‌ତାଂ ହାନାକା ୱିସ୍ତି ପାତଲ୍‌ମାଇତ ଏକାତାପ୍ ଆରି ଟଣ୍ଡାର୍‌ରିଂ ଜୱାର୍‌ କିଜ଼ି ର ଦିନ୍‌ ହେୱାର୍‌ ହୁକେ ମାଚାପ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","ଆର୍କାତ୍‌ ନାଜିଂ ଆପେଂ କାଇସରିୟାତ ହାଚାପ୍, ଆରେ ସାତ୍‌ ଜାଣ୍‍ତି ବିତ୍ରେ ମାନି ନେକ୍ରିକାବୁର୍‌ ପର୍‌ଚାର୍‌ କିନାକାନ୍‌ ପିଲିପ୍‌ତି ଇଞ୍ଜ ହଣ୍‌ଜି ହେୱାନ୍‌ ହୁକେ ମାଚାପ୍ । ");
INSERT INTO peg_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","ହେୱେକ୍‌ ଚାରି ଜାଣ୍‌ ଜିପଲିକ୍‌ ଗାଡ଼୍‌ଚେକ୍‌, ବେଣ୍‌ବାକ୍‌ଣାୟ୍‌କିନିକିକ୍‌ ମାଚିକ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","ହେ ବାହାତ ଆପେଂ ବେସି ଦିନ୍‌ ମାଚି ପାଚେ ଆଗାବ ତର୍‌ନି ରୱାନ୍‌ ବେଣ୍‌ବାକ୍‌ଣାୟ୍‌କିନାକାର୍‌ ଜିହୁଦା ରାଜିତାଂ ୱାତାନ୍ । ");
INSERT INTO peg_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","ହେୱାନ୍‌ ମା ଲାଗାୟ୍‌ ୱାଜ଼ି ପାଉଲ୍‌ତି ମ୍ଡେଙ୍ଗାଙ୍ଗ୍‌ ଗାଚ୍‌ୟାନାକା ଡରି ଅଜ଼ି ଜାର୍‌ କେଇଦ ଗାଚ୍‌ଚି ଇଚାନ୍, “ପୁଇପୁୟା ଜିବୁନ୍‌ ଇଦାଂ ଇନାନ୍‌, ଇ ମ୍ଡେଙ୍ଗାଙ୍ଗ୍‌ ଗାଚ୍‌ୟାତି ବେଲ୍‌ଟ୍‌ ମୁଣିକାତିଂ ଜିରୁସାଲମ୍‌ ନିକାର୍‌ ଜିହୁଦିର୍‌ ଏପେଙ୍ଗ୍‌ ଗାଚ୍‌ଚି ପାର୍ତିକିୱି ଜିହୁଦିର୍‌ କେଇଦ ହେଲାୟ୍‌ କିତାର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","ଇ ୱିଜ଼ୁ କାତା ୱେନ୍‌ଞ୍ଜି ଜିରୁସାଲମ୍‌ତ ହାଲ୍‌ୱି କାଜିଂ ଆପେଂ ଆରି ହେ ବାହାନି ଲକୁ ତାଙ୍ଗ୍‌ ଗୱାରି କିତାପ୍ । ");
INSERT INTO peg_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","ହେବେ ପାଉଲ୍‌ ଉତର୍‌ ହିତାନ୍‌, “ଏପେଙ୍ଗ୍‌ ଆଡ଼୍‌ବିସ୍‌ ଆରି ମାନ୍ତ କସ୍ଟ ହିଜ଼ି ଇନାକା କିନାଦେରା ? ଇନାକିଦେଂକି ଆନ୍‌ ମାପ୍ରୁ ଜିସୁତି ତର୍‌ କାଜିଂ ଜିରୁସାଲମ୍‌ତ କେବଲ୍‌ ଗାଚ୍ୟା ଆଦେଂ ଜାଲ୍‌ଦି, ହେଦାଂ ଆକାୟ୍‌, ମତର୍‌ ହାଦେଂ ପା ଜାଲ୍‌ଦି ମାନାଂ ।” ");
INSERT INTO peg_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","ଆପେଂ ହେୱାରିଂ ବୁଜାୟ୍‌ କିକିୟ୍‌ କିଦେଙ୍ଗ୍‌ ଆଡ୍‌ୱାଦାଂ ହେବେ ରିସା ଆଜ଼ି ଇଚାପ୍‌, “ମାପ୍ରୁତି ଇଚା ପୁରା ଆୟେତ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","ଆପେଂ ଇ କେତେକ୍‌ ଦିନ୍‌ ପାଚେ ଆଡ଼୍‌ମାଡ଼୍‌ ଅଜ଼ି ଜିରୁସାଲମ୍‌ତ ଚାଲାତାପ୍ । ");
INSERT INTO peg_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","ଆରେ, ମା ହାଙ୍ଗ୍‌ଦାଂ କାଇସରିୟାତ ପା କେତେକ୍‌ ଜାଣ୍‌ ଚେଲାର୍‌ ହାଚାର୍‌, ହେୱାର୍‌ ସାଇପ୍ରସ୍‌ ମନାସୋନ ତର୍‌ନି ରୱାନ୍‌ ପ୍ଡାନି ଚେଲାଂ ହାଙ୍ଗ୍‌ଦାଂ ତାହିୱାତାର୍‌, ହେୱାନ୍ତି ଇଞ୍ଜ ମାଦାଂ ମାନାକା ମାଚାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","ଆପେଂ ଜିରୁସାଲମ୍‌ତ ଏକିତିଲେ, ପାର୍ତି କିନି ଟଣ୍ଡାର୍‌ ମାଂ ୱାରିତାଂ ଇଡ୍‌ଦାତାର୍ । ");
INSERT INTO peg_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","ଆର୍କାତ୍‌ ନାଜିଂ ପାଉଲ୍‌ ମାହୁଦାଂ ଜାକୁବ୍‌ ଇଞ୍ଜ ହାଚାନ୍‌, ଆରେ ହେ ବାହାତ ୱିଜ଼ାର୍‌ ପ୍ରାଚିନାର୍‌ ରୁଣ୍ଡାତାର୍ । ");
INSERT INTO peg_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","ହେୱାନ୍‌ ହେୱାରିଂ ଜୱାର୍‌ କିତି ପାଚେ, ଇସ୍ୱର୍‌ ପାର୍ତିକିୱି ଜିହୁଦିର୍‌ ବିତ୍ରେ ଇମ୍‌ଣି ସବୁ କାମାୟ୍‌ ହେୱାନ୍ତି ହେବା କାଜିଂ ସାଦନ୍‌ କିଜ଼ି ମାଚାନ୍‌ ରଞ୍ଜାଙ୍ଗ୍‌ ରଞ୍ଜାଙ୍ଗ୍‌ କିଜ଼ି ହେ ସବୁ ହେୱାର୍‌ ଲାଗାଂ ୱେଚ୍‌ଚି ମାଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","ହେୱାର୍‌ ହେଦାଂ ୱେନ୍‌ଞ୍ଜି ଇସ୍ୱର୍‌ତିଂ ଜାଜ୍‌ମାଲ୍‌ କିଦେଙ୍ଗ୍‌ ଲାଗାତାର୍‌, ଆରେ ତାଙ୍ଗ୍‌ ଇଚାର୍‌, “ଏ ଟଣ୍ଡେନ୍‌, ଜିହୁଦିର୍‌ତି ବିତ୍ରେ ଜେ ଏଚେକ୍‌ ହାଜାର୍‌ ପାର୍ତି କିନାର୍‌, ଇଦାଂ ଏପେଙ୍ଗ୍‌ ହୁଡ଼୍‌ନାଦେରା, ହେ ୱିଜ଼ୁ ମସାତି ବିଦି ପାକ୍ୟାତ ଆଗେ । ");
INSERT INTO peg_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","ଆରେ, ପାର୍ତିକିୱି ଜିହୁଦିର୍‌ ବିତ୍ରେ ବାହା କିନାକାର୍ ୱିଜ଼ାର୍‌ ଜିହୁଦିରିଂ ଜାର୍‌ ଜାର୍‌ ହିମ୍‌ଣାକାଂ ସୁନ୍ନତ୍‌ କିୱି ଆରି ବିଦିବିଦାଣି ଲାହାଙ୍ଗ୍‌ ଚାଲାୱାଦାଂ ଇଞ୍ଜି, ମସାତି ବିଦି ପିସ୍ତେଙ୍ଗ୍‌ କାଜିଂ ଏପେଙ୍ଗ୍‌ ଜେ ହେୱାରିଂ ହିକ୍ୟା ହିଜ଼ି ମାନାଟ୍‌, ମି ବିସ୍ରେ ଇ କାବୁର୍‌ ହେୱାର୍‌ ହିତ୍‌ତାର୍ଣ୍ଣା । ");
INSERT INTO peg_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","ଲାଗିଂ ଇନାକା କିୟାନାତ୍‌ ? ଏପେଙ୍ଗ୍‌ ୱାତାଦେର୍ଣ୍ଣା ଇଞ୍ଜି ହେୱାର୍‌ ହାତେ ୱେନାର୍ । ");
INSERT INTO peg_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","ଲାଗିଂ ଆପେଂ ମିଙ୍ଗ୍‌ ଇନାକା ୱେଚ୍‍ଚାନାପା, ହେଦାଂ କିୟାଟ୍‌ । ମା ଲାଗେ ଚାରି ଜାଣ୍‌ ଲକ୍‌ ମାନାର୍‌, ହେୱାର୍‌ ରଞ୍ଜାଙ୍ଗ୍‌ ଅଡ଼୍‍ଗା ଆତାର୍ଣ୍ଣା; ");
INSERT INTO peg_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","ହେୱାରିଂ ଅଜ଼ି ହେୱାର୍‌ ହୁକେ ଜାର୍‌ତିଂ ସକଟ୍‌ କିୟାଟ୍‌, ଆରେ ହେୱାର୍‌ତି କାପ୍‌ଡ଼ା ହେନ୍‍ନାକା ଲସ୍ କାଉଡ଼ି ପିଣ୍ତାଟ୍, ତା ଆତିସ୍‌ ହେୱାର୍‌ ମି ବିସ୍ରେ ଇମ୍‌ଣି ସବୁ କାବୁର୍‌ ଗାଟାତାର୍ଣ୍ଣା, ହେବେତାଂ ଜେ ମୁଡ଼େ ହାତ୍‌ପା ଆକାୟ୍‌, ଆୱିତିସ୍‌ ଏପେଙ୍ଗ୍‌ ଜେ ନିଜେ ପା ମସାତି ବିଦି ମାନି କିଜ଼ି ଚିନ୍ତା କିନାଦେରା, ଇଦାଂ ୱିଜ଼ାକାର୍‌ ପୁନାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","ମତର୍‌ ଇମ୍‌ଣି ପାର୍ତିକିୱି ଜିହୁଦିର୍‌ ପାର୍ତି କିତାର୍ଣ୍ଣା, ହେୱାର୍‌ ଲାଗାଂ ଆପେଂ ର ଆକି ଲେକିକିଜ଼ି ବଲ୍‌ ହିତାପ୍‌ନା ଜେ, ମା ରାଜି ଇସାବ୍ରେ ହେୱାର୍‌ ପୁତ୍‍ଡ଼ା ଲାଗାଂ ପୁଜାକିତି ଆତାତ୍‌ ତିନୁର୍‌, ନେତେର୍‌ ଉଣୁର୍‌, ହାକ୍‌ମଡ଼ିକିତି ଜାତ୍‌ ଜାଇ ତିନୁର୍‌ ଆରି ଦାରିତାଂ ଦେହା ମାନ୍‌ଗାନାର୍‌, ଆପେଂ ଇଦାଂ ବିଚାର୍‌ କିଜ଼ି ଲେକି କିତାପ୍‌ନ୍ନା ।” ");
INSERT INTO peg_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","ପାଉଲ୍‌ ହେବେଣ୍ଡାଂ ହେ ଲଗାଂ ଅଜ଼ି ଆର୍କାତ୍‌ ନାଜିଂ ହେୱାର୍‌ ହୁକେ ଜାର୍‌ତିଂ ସକଟ୍‌ କିଜ଼ି ମନ୍ଦିର୍‌ ବିତ୍ରେ ହଟାନ୍, ଆରେ ହେୱାର୍‌ତି କେତ୍‌ଜାଣ୍‍ତିଂ କାଜିଂ ଆକାତ୍‌ ପୁଜା ଆନି ପାତେକ୍‌ ସକଟ୍‍ କାମାୟ୍‌ତ କେତେକ୍‍ ଦିନ୍‌ ଲାଗାନାତ୍, ହେଦାଂ ୱେଚ୍‌ଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","ହେ ସାତ୍‌ ଦିନ୍‌ ପୁରା ଆଜ଼ି ୱାତାନ୍, “ଆସିଆନି ଜିହୁଦିର୍‌ ମନ୍ଦିର୍‌ତ ପାଉଲ୍‌ତିଂ ହୁଡ଼୍‌ଜି ଲକୁରିଂ ଟିଉଲାୟ୍‌ କିତାର୍‌, ଆରେ ହେୱାନିଂ ଆସ୍ତି କିକିରାଡିଂ ଆଜ଼ି ଇଞ୍ଜେଙ୍ଗ୍‌ ଲାଗାତାର୍‌, ");
INSERT INTO peg_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","ଏ ଇସ୍ରାଏଲିୟନି ଲକୁ, ସାଇଜ କିଦାଟ୍‌; ସବୁ ବାହାତ ଇମ୍‌ଣି ମାନାୟ୍‌ ମା ଜାତି, ମସାତି ବିଦି ଆରି ଇ ବାହା ବିରୁଦ୍‌ତ ୱିଜ଼ାରିଂ ହିକ୍ୟା ହିନାନ୍‌, ହେୱାନ୍‌ ଇୱାନ୍‌; ଆରେ ପା ଗ୍ରିକ୍‌କାରିଂ ପା ମନ୍ଦିର୍‌ ବିତ୍ରେ ତାସି ପୁଇପୁୟା ବାହାତ ବିଟାଡ଼୍‌ କିତାନ୍‌ନ୍ନା ।” ");
INSERT INTO peg_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","ଇନାକିଦେଂକି ହେୱାର୍‌ ଆଗେ ଗାଡ଼୍‌ ବିତ୍ରେ ପାଉଲ୍‌ ଲାହାଙ୍ଗ୍‌ ଏପିସିୟନି ତ୍ରପିମତିଂ ହୁଡ଼୍‌ଜି ମାଚାର୍‌, ଆରେ ପାଉଲ୍‌ ହେୱାନିଂ ମନ୍ଦିର୍‌ ବିତ୍ରେ ତାହିୱାନାର୍‍ ଇଞ୍ଜି ଇଟ୍‌କାଡ଼୍‌ କିଜ଼ି ମାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","ଇବେଣ୍ଡାଂ ଗାଡ଼୍‌ ସବୁ ୱିଣ୍‍ତାତ୍, ଲକୁ ରବେ ହନ୍ତାର୍‌, ଆରେ ହେୱାର୍‌ ପାଉଲ୍‌ତିଂ ଆସ୍ତି ମନ୍ଦିର୍‌ ବାର୍ତ ଜେଲ୍‍ଜି ତାହିୱାତାର୍‌; ଆରେ ହେ ଦାପ୍ରେ ଦୁୱେର୍‌ ସବୁ ଗେସ୍‍ତାର୍ । ");
INSERT INTO peg_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","ଆରେ, ହେୱାନିଂ ହେୱାର୍‌ ଟ୍ରାକ୍‍ତେଂ କାଜିଂ ସେସ୍ଟା କିତିଲେ, ୱିଜ଼ାର୍‌ ଜିରୁସାଲମ୍‌ ଗଣ୍ଡ୍‌ଗଲ୍‍ତ ବାର୍ତି ଆତାତ୍‌ନ୍ନା ଇଞ୍ଜି ରମିୟ ମେଲ୍ୟାର୍‍ ହାଜାର୍‌ ମୁସ୍ତିଦାର୍ ଲାଗେ କାବୁର୍‌ ୱାତାତ୍ । ");
INSERT INTO peg_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","ହେବେଣ୍ଡାଂ ହେ ଦାପ୍ରେ ମେଲ୍ୟା ଆରି ପାଞ୍ଚ୍‌କଡ଼ି ମେଲ୍ୟାର୍‍ ଅସି ହେୱାର୍‌ ଲାଗେ ହନ୍ତାର୍‌ । ହେୱାର୍‌ ହାଜାର୍‌ ମୁସ୍ତିଦାର୍ ଆରି ମେଲ୍ୟାରିଂ ହୁଡ଼୍‌ଜି ପାଉଲ୍‌ତିଂ ଟ୍ରାକ୍‍ତେଂ ବନ୍ଦ୍‌ କିତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","ହେ ଏଚେକାଡ଼୍‌ଦ ହାଜାର୍‌ ମୁସ୍ତିଦାର୍ ଲାଗେ ୱାଜ଼ି ହେୱାନିଂ ଆସ୍ତି ରିଣ୍ଡି ହିକ୍‌ଡ଼ିଂତାଂ ହେୱାନିଂ ଗାଚ୍‍ଚେଂ ବଲ୍‌ ହିତାନ୍‌, “ଆରେ ହେୱାନ୍‌ ଇନେନ୍‌ ଆରି ଇନାକା କିତାନ୍‌ନ୍ନା ଇଞ୍ଜି ୱେନ୍‌ବାତାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","ହେବେ ଲକୁ ବିତ୍ରେ ଇନେର୍‌ ଇ କାତା, ଇନେର୍‌ ଇନେର୍‌ ହେ କାତା ଇଞ୍ଜି କିକିରାଡିଂ କିଦେଙ୍ଗ୍‌ ଲାଗାତାର୍‌ । ଆରେ, ହେ ଗଣ୍ଡ୍‌ଗଲ୍‍ନି ଇନାକିଦେଂକି ହାତେନେ ମୁଡ଼େ ପୁଞ୍ଜେଙ୍ଗ୍‌ ଆଡ଼୍‍ତିଲେ ହେୱାନିଂ ମେଲ୍ୟାର୍‌ ମାନି ବାହାତ ଅଦେଂ କାଜିଂ ବଲ୍‌ ହିତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","ଆରେ, ଏଚେକାଡ଼୍‌ଦ ହେୱାନ୍‌ ପାଉଜ୍‌ ଜପି ୱାତାନ୍, ହେ ଏଚେକାଡ଼୍‌ଦ ଲକୁ ରିସା କାଜିଂ ମେଲ୍ୟାର୍‌ ପାଉଲ୍‌ତିଂ ପିଣ୍ଡ୍‌ଜି ଅଦେଂ ଲାଗାତାର୍‌, ");
INSERT INTO peg_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","ଇନାକିଦେଂକି ତାଙ୍ଗ୍‌ ଅହାଟ୍‌ ଇଞ୍ଜି ବେସି ଲକୁ ପାଚେ ହାଲୁ ହାଲୁ କିକିରାଡିଂ କିଜ଼ି ଅହାଟ୍‌, “ଅହାଟ୍‌ ଇଞ୍ଜି ମାଚାର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","ହେୱାର୍‌ ପାଉଲ୍‌ତିଂ ବାହା ବିତ୍ରେ ଅଦେଂ କାଜିଂ ଜାଲ୍‌ଦି କିନି ୱେଡ଼ାଲିଂ ହେୱାନ୍‌ ହାଜାର୍‌ ମେଲ୍ୟାରିଂ ଇଚାନ୍‌, “ଆନ୍‌ ମିଙ୍ଗ୍‌ ଇନାକା ଇଞ୍ଜେଙ୍ଗ୍‌ ଆଡ୍‌ନାଂ କି ?” ହେବେଣ୍ଡାଂ ହେୱାନ୍‌ ଇଚାନ୍‌, “ଏନ୍‌ କି ଗ୍ରିକ୍‌ ପୁନାୟ୍‌ ?” ");
INSERT INTO peg_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","ଲାଗିଂ, “ଇ ଆଗେ ଇମ୍‌ଣି ମିସରିୟର୍‌ ଲକୁ ରାଟୁ କିଜ଼ି ଚାରି ହାଜାର୍‌ କାଙ୍ଗାରୁଙ୍ଗ୍‌ ବାଟାତ ଅଜ଼ି ମାଚାର୍‌, ଏନ୍‌ କି ହେୱାନ୍‌ ଆକାୟ୍‌ ?” ");
INSERT INTO peg_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","ହେବେଣ୍ଡାଂ ପାଉଲ୍‌ ଇଚାନ୍‌, “ଆନ୍‌ତ ରୱାନ୍‌ ଜିହୁଦି, ତାର୍ସ ଗାଡ଼୍‌ନି ଲକୁ, କିଲିକିୟାନି ର ଗାଜା ଗାଡ଼୍‌ନି ମାନାୟ୍‌; ଇ ଲକୁରିଂ କାତା ଇଞ୍ଜେଙ୍ଗ୍‌ କାଜିଂ ନାଙ୍ଗ୍‌ ଦାଇତ୍‌ ହିଦେଂ କାଜିଂ ଆନ୍‌ ନିଂ ଗୱାରି କିଦ୍‌ନାଙ୍ଗା ।” ");
INSERT INTO peg_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","ହେୱାନ୍‌ ଦାଇତ୍‌ ହିତିଲେ ପାଉଲ୍‌ ପାଉଜ୍‌ ଇଞ୍ଜ ଲକୁରିଂ କେଇ ହୁଦାଂ ଚଚ୍‍ଚାନ୍; ଆରେ, ୱିଜ଼ାର୍‌ ଚିମ୍ରା ଆତି ପାଚେ ହେୱାନ୍‌ ଏବ୍ରି ବେରଣ୍‌ତ ହେୱାରିଂ ଇଞ୍ଜେଙ୍ଗ୍‌ ଲାଗାତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","ଟଣ୍ଡାର୍‌ ଆରି ଆବାକାଦେର୍, “ଆନ୍‌ ନଙ୍ଗ୍‌ ମି ଲାଗେ ଇମ୍‌ଣି ନା ପାକ୍ୟାତାଂ ସାକି କାତା ଇଞ୍ଜ୍‌ନାଙ୍ଗା, ହେଦାଂ ୱେନାଟ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","ହେୱାନ୍‌ ହେୱାର୍‌ ଲାଗେ ଏବ୍ରି ବେରଣ୍‌ତ କାତା ଇନାକା ୱେନ୍‌ଞ୍ଜି ହେୱାର୍‌ ଆଦିକ୍‌ ଚିମ୍‌ରା ଆଜ଼ି ମାଚାର୍‌ । ହେବେଣ୍ଡାଂ ହେୱାନ୍‌ ଇଚାନ୍‌, ");
INSERT INTO peg_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“ଆନ୍‌ ରକାଂ ଜିହୁଦି, କିଲିକିୟାନି ତାର୍ସତ ନାଦାଂ ଜଲମ୍‌, ମତର୍‌ ଆନ୍‌ ଇ ଗାଡ଼୍‌ଦ ପହାପାଲି ଆତାଙ୍ଗ୍‌ନା, ମା ଆବାଲାତ୍ରାତି ହାରୁ ବିଦି ଲାହାଙ୍ଗ୍‌ ଗମଲିୟେଲ୍‌ତି ମୁମ୍‌ଦ ତାରେନ୍‌ କୁଚ୍‌ଚି ହିକ୍ୟା ପାୟାତାଂନା, ଏପେଙ୍ଗ୍‌ ୱିଜ଼ାକାଦେର୍‌ ନେଞ୍ଜେଙ୍ଗ୍‌ ଇନେସ୍‌ ୱାରି କାଦେର୍, ଇସ୍ୱର୍‌ତି ପାକ୍ୟାତ ଆନ୍‌ ପା ହେ ଲାକେ ଆଗେ ମାଚାଙ୍ଗ୍; ");
INSERT INTO peg_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","ଆନ୍‌ ଇ ମାପ୍ରୁତି ହାଜ଼ିତ । ଆଣ୍ଡ୍ରେନ୍‌ ଆରି କଗ୍‍ଲେ ୱିଜ଼ାରିଂ ଗାଚ୍‌ଚି ଜଇଲ୍‌ତ ତୁହିଜି ହାନି ପାତେକ୍‌ କସ୍ଟ ହିଜ଼ି ମାଚାଙ୍ଗ୍ । ");
INSERT INTO peg_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","ନା ଇ କାତା ଜେ ହାତ୍‌ପା, ମୁଡ଼୍‌ ମାପ୍ରୁହେବାକିନାକାନ୍‌ ଆରି ଗାଜା ସବାନି ବୁଡ଼ାଲୁର୍‌ ଇଦାଂ ନି ସାକି । ଇ ମାନାୟାରିଂ ବନ୍ଦି କିଜ଼ି ଆରି ହିକ୍‌ଡ଼ିଂତାଂ ଗାଚ୍‌ଚି ଦାଣ୍ଡ୍‌ କିନି କାଜିଂ ଜିରୁସାଲମ୍‌ତ ତାସି ୱାନି କାଜିଂ ଆନ୍‌ ମୁଡ଼୍‌ ମାପ୍ରୁହେବାକିନାକାନ୍‌ତାଂ ଜିନାଜାଣା ଆକି ଅଜ଼ି ଦମ୍ମେସକ୍‌ତ ମାନି ଜିହୁଦି ଟଣ୍ଡାର୍‌ ଲାଗାଂ ହାଚାଙ୍ଗ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","ମତର୍‌ “ଆନ୍‌ ହାଲୁ ହାଲୁ ଦମ୍ମେସକ୍‌ନି ଲାଗେ ଆତିଲେ, ଆତିସ୍‌ ମୁଣ୍ଡାମେଦାନ୍‌ତ ହାଚାଟ୍ରେ ନା ଚାରିବେଣ୍‌ତାଂ ବାଦାଡ଼୍‌ତାଂ ଗାଜା ଅଜଡ଼୍‌ ଆତାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","ହେବେ ଆନ୍‌ ମେଦ୍ନିତ ଗୁର୍ତାଙ୍ଗ୍, ଆରେ ନା କାଜିଂ ଇ ବଚନ୍‌ ୱେଚାଙ୍ଗ୍‌, ସାଉଲ୍‌, ସାଉଲ୍‌, ଇନାକିଦେଂ ନାଙ୍ଗ୍‌ ଇଣ୍‌ କିଦ୍‌ନାୟା ?” ");
INSERT INTO peg_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","ଆନ୍‌ ଉତର୍‌ ହିତାଂ, “ମାପ୍ରୁ, ଏନ୍‌ ଇମ୍‌ଣାକାୟ୍‌ ?” ଲାଗିଂ ହେୱାନ୍‌ ଇନ୍‍ଞ୍ଚାନ୍, “ଏନ୍‌ ଇମ୍‌ଣି ନାଜରିତିୟ ଜିସୁତିଂ ନିନ୍ଦା କିନାୟା, ଆନ୍‌ ହେୱାଙ୍ଗ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","ଇମ୍‌ଣାକାର୍‌ ନା ଲାହାଙ୍ଗ୍‌ ମାଚାର୍‌, ହେୱାର୍‌ ହେ ଅଜଡ଼୍‌ ହୁଡ଼୍‌ତାର୍‌ ହାତ୍‌ପା, ମତର୍‌ ଇନେର୍‌ ନାଙ୍ଗେଙ୍ଗ୍ କାତା ଇଞ୍ଚାର୍, ହେୱାନ୍ତି କାଟ୍‌ ୱେନ୍‍ୱାତାର୍ । ");
INSERT INTO peg_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","ହେବେ ଆନ୍‌ ଇଚାଙ୍ଗ୍‌, “ମାପ୍ରୁ ଇନାକା କିନାଙ୍ଗ୍‌ ?” ଲାଗିଂ ମାପ୍ରୁ ନାଙ୍ଗ୍‌ ଇଞ୍ଚାନ୍, “ନିଙ୍ଗା, ଦମ୍ମେସକ୍‌ତ ହାଲା, ଇସ୍ୱର୍‌ ଇମ୍‌ଣି ୱିଜ଼ୁ କାମାୟ୍‌ କିନି କାଜିଂ ନିଂ କିଆତାତ୍‍ନ୍ନା, ହେ ସବୁ ନିଂ ହେବେ ଇନ୍ୟାନାତ୍ ।” ");
INSERT INTO peg_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","ହେ ଅଜଡ଼୍‌ନି ଜାଜ୍‌ମାଲ୍‌ କାଜିଂ ଆନ୍‌ ହୁଡ଼୍‌ଦେଂ ଆଡ୍‌ୱିତିଲେ, ନା ଲାହାଙ୍ଗ୍‌ ମାନି ଲକୁ ହୁଦାଂ ତାଂଜି ଦମ୍ମେସକ୍‌ତ ତାଇୱାତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","“ହେ ଗାଡ଼୍‌ଦ ହନନିୟ ତର୍‌ ନି ସାକି ମାନାୟ୍‌ ମାଚାନ୍‌ । ହେୱାନ୍‌ ମା ବିଦି ପାଲି କିଜ଼ି ମାଚାନ୍‌ ଆରି ହେବେ ବାହା କିଜ଼ିମାନି ଜିହୁଦିର୍‌ ୱିଜ଼ାକାର୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ମାନି କିଜ଼ି ମାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","ନା ଲାଗେ ୱାଜ଼ି ଲାଗେ ନିଲ୍‌ଚି ନାଙ୍ଗ୍‌ ଇଞ୍ଚାନ୍, ସାଉଲ୍‌ ‘ଟଣ୍ଡେନ୍‌, ହୁଡ଼୍‌ନି ସାକ୍ତି ଗାଟା ଆ ।’ ହେ ପାଦ୍‌ନା ଆନ୍‌ ହେୱାନିଂ ହୁଡ଼୍‌ତାଂ ।” ");
INSERT INTO peg_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","ଆରେ, ହେୱାନ୍‌ ଇଞ୍ଚାନ୍, “ମା ଆବାଲାତ୍ରାତି ଇସ୍ୱର୍‌ ହେୱାନ୍ତି ଇଚା ପୁଞ୍ଜେଙ୍ଗ୍‌ କାଜିଂ ଆରି ହେ ଦାର୍ମି ଲଗାଂ ହୁଡ଼୍‌ଦେଂ କାଜିଂ, ଆରେ ହେୱାନ୍ତି ୱେଇଦାଂ କାତା ୱେଞ୍ଜେଙ୍ଗ୍‌ କାଜିଂ ନିଂ ବାଚି କିତ୍‌ତାନ୍‌ନା, ");
INSERT INTO peg_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","ଇନାକିଦେଂକି ଏନ୍‌ ଇନା ଇନାକା ହୁଡ଼୍‍ତାୟ୍‍ନା ଆରି ୱେଚାୟ୍‍ନା, ହେ ସବୁ ବିସ୍ରେ ୱିଜ଼ୁ ଲକୁ ଲାଗେ ହେୱାନ୍ତି ସାକି ଆତାୟ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","ଆରେ, ନଙ୍ଗ୍‌ ଏନ୍‌ ଇନାକିଦେଂ ମାଲା ଆନାୟା ? ନିଙ୍ଗା, ବାପ୍ତିସିମ୍‌ ଆ, ଆରେ ହେୱାନ୍ତି ତର୍‌ଦ ପାର୍ତାନା କିଜ଼ି ଜାର୍‌ ପାପ୍‌ ସବୁ ନୁଜ଼ିତୁହିୟା ।” ");
INSERT INTO peg_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","“ଇଦାଂ ପାଚେ ଆନ୍‌ ଜିରୁସାଲମ୍‌ତ ମାସ୍‍ଦି ୱାଜ଼ି ମନ୍ଦିର୍‌ତ ପାର୍ତାନା କିନି ୱେଡ଼ାଲିଂ କେଚ୍‌କଣ୍‌ତ ହୁଡ଼୍‌ତାଂ । ");
INSERT INTO peg_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","ମାପ୍ରୁଙ୍ଗ୍‌ କେଚ୍‌କଣ୍‌ତ ହୁଡ଼୍‌ତାଂ, ହେୱାନ୍‌ ନାଙ୍ଗେଙ୍ଗ୍ ଇଞ୍ଚାନ୍, ମାଲା ଆୱାଦାଂ ବେଗି ଜିରୁସାଲମ୍‌ତାଂ ହସିହାଲା, ଇନାକିଦେଂକି ହେୱାର୍‌ ନା ବିସ୍ରେନି ସାକି ଇଡ୍‍ଡୁର୍ ।” ");
INSERT INTO peg_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","ହେବେଣ୍ଡାଂ ଆନ୍‌ ଇଚାଙ୍ଗ୍‌, “ମାପ୍ରୁ ଆନ୍‌ ଜେ ନି ତାକେ ପାର୍ତି କିନାକାରିଂ ପାର୍ତାନା ଇଲ୍‌ ଆସ୍ତି ବନ୍ଦିତ ତୁହିଜି ମାଚାଙ୍ଗ୍ ଆରି ଟ୍ରାକ୍‌ଚି ମାଚାଙ୍ଗ୍, ଇଦାଂ ହେୱାର୍‌ ନିଜେ ପୁନାର୍‌, ");
INSERT INTO peg_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","ଆରେ, ଏଚେକାଡ଼୍‌ଦ ନି ସାକି ସ୍ତିପାନ୍‌ତିଂ ନେତେର୍‌ ହପ୍‌ୟା ଆଜ଼ି ମାଚାତ୍‌, ହେ ପାଦ୍‌ନା ଆନ୍‌ ପା ଲାଗେ ନିଲ୍‌ଚି ହେଦାଂ ରାଜି ମାଚାଙ୍ଗ୍, ଆରେ ଅସ୍ତାକାର୍ ହେନ୍ଦ୍ରା ଇଡ଼୍‌ଜି କାସି ମାଚାଙ୍ଗ୍ ।” ");
INSERT INTO peg_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","ହେବେଣ୍ଡାଂ ମାପ୍ରୁ ନାଙ୍ଗେଙ୍ଗ୍ ଇଞ୍ଚାନ୍, “ହାଲା ଇନାକିଦେଂକି ଆପ୍‌ ନିଂ ଦେହା ପାର୍ତିକିୱି ଜିହୁଦିର୍‌ ଲାଗେ ପକ୍ତାନାପ୍ ।” ");
INSERT INTO peg_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","ମାନାୟାର୍‌ ଇ ପାତେକ୍‌ ହେୱାନ୍ତି କାତା ୱେନ୍‌ଞ୍ଜି ଗାଜା ୱେଇଦାଂ ଇଚାର୍‌, “ଏପେଙ୍ଗ୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ ପୁର୍ତିତାଂ ଦେହା କିୟାଟ୍‌, ଇନାକିଦେଂକି ତାଦାଂ ଜିଜ଼ି ମାନି ଲଡ଼ା ଆକାୟ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","ଆରେ, ଏଚେକାଡ଼୍‌ଦ ହେୱାର୍‌ କିକିରାଡିଂ କିଜ଼ି ଜାର୍‌ ଜାର୍‌ ହେନ୍ଦ୍ରା ତୁହିଜି ବାଦାଡ଼୍‌ ନିପ ଦୁଡ଼ି ତୁହିଦେଂ ଲାଗାତାର୍‌, ");
INSERT INTO peg_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","ହେ ଏଚେୱେଡ଼ାଲିଂ ହାଜାର୍‌ ମେଲ୍ୟାର୍‌ ହେୱାନିଂ ଗାଡ଼୍‌ ବିତ୍ରେ ଅଦେଂ ବଲ୍‌ ହିତାନ୍‌, ଆରେ, ଲକୁ ଇନାକିଦେଂ ତା ବିରୁଦ୍‌ତ ଏପେଙ୍ଗ୍‌ କିକିରାଡିଂ କିନାରା, ଇଦାଂ ପୁଞ୍ଜେଙ୍ଗ୍‌ କାଜିଂ କର୍‌ଡା ଇଡ଼୍‌ନି ହୁଦାଂ ତା ପରିକ୍ୟା କିନି କାଜିଂ ବଲ୍‌ ହିତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","ମାତର୍‌ ହେୱାର୍‌ ହେୱାନିଂ ଡରି ଗାଚ୍‌ନି ସମୁତ ପାଉଲ୍‌ ହେବେ ମାନି ରୱାନ୍‌ ମୁସ୍ତିଦାର୍‍ତିଂ ଇଚାନ୍‌, “ଇମ୍‌ଣି ପାପ୍‌ତ ଇ ପାତେକ୍‌ ବିଚାର୍‌ କିୟାୱାଦାଂ ମାନି ରୱାନ୍‌ ରମିୟ ଦାଙ୍ଗ୍‌ଣେନ୍‌ତିଂ କର୍‌ଡା ଇଡ଼୍‌ନାକା ଇନାକା ବିଦି ?” ");
INSERT INTO peg_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","ହେ ପାଞ୍ଚ୍‌କଡ଼ି ମୁସ୍ତିଦାର୍ ଇଦାଂ ୱେନ୍‌ଞ୍ଜି ହାଜାର୍‌ ମୁସ୍ତିଦାର୍‍ତ ଲାଗେ ହାଲ୍‌ଜି ତାଙ୍ଗ୍‌ ହେ କାତା ୱେଚ୍‌ଚି ଇଚାନ୍‌, “ଏନ୍‌ ଇନାକା କିଦେଙ୍ଗ୍‌ ହାନାୟା ? ଇୱାନ୍ତ ରୱାନ୍‌ ରମିୟ ।” ");
INSERT INTO peg_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","ହେବେଣ୍ଡାଂ ହାଜାର୍‌ ମୁସ୍ତିଦାର୍ ୱାଜ଼ି ତାଙ୍ଗ୍‌ ଇଚାନ୍‌, ନାଙ୍ଗ୍‌ ୱେଚ୍‌ଚା, “ଏନ୍‌ କି ରକାୟ୍‌ ରମିୟ ? ପାଉଲ୍‌ ଇଚାନ୍‌ ଆଁ ।” ");
INSERT INTO peg_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","ହେବେଣ୍ଡାଂ ହାଜାର୍‌ ମୁସ୍ତିଦାର୍ ଉତର୍‌ ହିତାନ୍‌, “ବେସି ଡାବୁଙ୍ଗ୍‌ ହିିଜ଼ି ଇ ପାଦ୍‌ ପାୟାତାଂନା । ପାଉଲ୍‌ ଇଚାନ୍‌, ମତର୍‌ ଆନ୍‌ ଜଲମ୍‌ତାଂ ରମିୟ ଦାଂଣାର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","ୱାଟିଙ୍ଗ୍‌ ଇମ୍‌ଣାକାର୍‌ ତାଙ୍ଗ୍‌ ପରିକ୍ୟା କିଦେଙ୍ଗ୍‌ ସେସ୍ଟା କିଜ଼ି ମାଚାର୍, ହେୱାର୍‌ ହେ ଦାପ୍ରେ ହେବେତାଂ ଚିମ୍ରା ଆତାର୍‌, ଆରେ ହାଜାର୍‌ ମୁସ୍ତିଦାର୍ ପା ହେୱାନ୍‌ ଜେ ରୱାନ୍‌ ରମିୟ, ଇଦାଂ ବୁଜାତିଲେ ଆରି ତାଙ୍ଗ୍‌ ଗାଚ୍‍ଚେଂ ପାଣ୍ଡ୍ରା ଆତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","ମତର୍‌ ଇନାକିଦେଂ ହେୱାନ୍‌ ଜିହୁଦିର୍‌ତି ହୁଦାଂ ଦାବା ଆତାନ୍ନା, ହେଦାଂ ହାତ୍‌ପା ରଚେ ପୁଞ୍ଜେଙ୍ଗ୍‌ ଇଚାତ ହେୱାନ୍‌ ତା ଆର୍କାତ୍‌ ନାଜିଂ ହେୱାନ୍ତି ଗାଟି ରିକ୍‌ଚି ମୁଡ଼୍‌ ମାପ୍ରୁହେବାକିନାକାନ୍‌ ଆରି ସବୁ ଗାଜା ସବାତିଂ ରବେ ୱାନି କାଜିଂ ବଲ୍‌ ହିତାନ୍‌, ଆରେ ପାଉଲ୍‌ତିଂ ଅସି ହେୱାର୍‌ ମୁମ୍‌ଦ ନିଲି କିତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","ଆରେ, ପାଉଲ୍‌ ଗାଜା ସବା କାଜିଂ ସମାନ୍‌ ହୁଡ଼୍‌ଜି ଇଚାନ୍‌, “ଟଣ୍ଡାର୍‌, ଆନ୍‌ ଇ ଦିନ୍‌ ପାତେକ୍‌ ପୁରା ହାର୍‌ଦି ଚିନ୍ତା ଇସ୍ୱର୍‌ତି ସାକ୍ୟତ ଆଚାର୍‌ ବେବାର୍‌ କିଜ଼ି ୱାତାଂନ୍ନା ।” ");
INSERT INTO peg_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","ହେବେଣ୍ଡାଂ ମୁଡ଼୍‌ ମାପ୍ରୁହେବାକିନାକାନ୍‌ ହାନାନ ପାଉଲ୍‌ ଲାଗେ ନିଲ୍‌ଚି ମାନି ଲୁଗାଂ ତା ମୁମ୍‌ଦ ଇଡ୍‌ଦେଂ କାଜିଂ ବଲ୍‌ ହିତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","ହେ ଏଚେକାଡ଼୍‌ଦ ପାଉଲ୍‌ ତାଙ୍ଗ୍‌ ଇଚାନ୍‌, “ଏ ଡିଞ୍ଜିନି ବାଡ଼୍‌, ଇସ୍ୱର୍‌ ନିଂ ଇଡ଼୍‍ଦାନାନ୍, ଏନ୍‌ ରଞ୍ଜେମାଡ୍ ମସାତି ବିଦି ଇସାପ୍‌ରେ ନା ବିଚାର୍‌ କିଦେଙ୍ଗ୍‌ କୁଚ୍‌ଚି ମସାତି ବିଦି ବିରୁଦ୍‌ତ ନାଙ୍ଗ୍‌ ଇଡ଼ିକିଦ୍‌ନି କାଜିଂ କି ବଲ୍‌ ହିନାୟା ?” ");
INSERT INTO peg_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","ହେବେ ଲାଗେ ନିଲ୍‌ଚି ମାନି ଲକୁ ଇଚାର୍‌, “ଏନ୍‌ କି ଇସ୍ୱର୍‌ତି ମୁଡ଼୍‌ ମାପ୍ରୁହେବାକିନାକାନ୍‌ନିଂ ନିନ୍ଦା କିନାୟା ?” ");
INSERT INTO peg_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","ଆରେ ପାଉଲ୍‌ ଇଚାନ୍‌, “ଏ ଇସ୍ରାଏଲ୍‌ନି ଟଣ୍ଡାର୍‌, ହେୱାନ୍‌ ମୁଡ଼୍‌ ମାପ୍ରୁହେବାକିନାକାନ୍‌ ଇଞ୍ଜି ଆନ୍‌ ପୁନ୍‌ୱାଦାଂ ମାଚାଙ୍ଗ୍‌; ଇନାକିଦେଂକି ଦରମ୍‌ ସାସ୍ତର୍‌ତ ଲେକା ମାନାତ୍‌, ଏପେଙ୍ଗ୍‌ ଜାର୍‌ ଲକ୍‌ତି ମୁଣିକାତିଂ ସାଇପ୍‌ ହିଉଦେର୍ ।” ");
INSERT INTO peg_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","ମତର୍‌ ପାଉଲ୍‌ ର ବାଗ୍‌ ସାଦୁକି ଆରେ ଆଣ୍ଟି ବାଗ୍‌ ପାରୁସି ଇଞ୍ଜି ପୁଞ୍ଜି ଗାଜା ସବାତ ଗାଜାକାଟ୍‌ତାଂ ଇଚାନ୍‌, “ଏ ଇସ୍ରାଏଲ୍‌ନି ଟଣ୍ଡାର୍‌, ଆନ୍‌ ରୱାଙ୍ଗ୍ ପାରୁସି ଆରି ପାରୁସିତି ମେହି; ଆରେ ଇ ବାର୍ସି, ଇଚିସ୍‌ ହାତାକାର୍ତି ଆରେ ନିଂନାକା ବିସ୍ରେ ଆନ୍‌ ବିଚାର୍‌ କିଆନାଙ୍ଗା ।” ");
INSERT INTO peg_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","ହେୱାନ୍‌ ଇ କାତା ଇଚିଲେ ପାରୁସି ଆରି ସାଦୁକିର୍‌ ବିତ୍ରେ ଗଣ୍ଡ୍‌ଗଲ୍‌, ଆରି ସବାତ କୁଦାଗଡ଼୍‍ ଗିଟାତାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","ଇନାକିଦେଂକି ସାଦୁକିର୍‌ ଆରେ ନିଂନାକା, ବାଦାଡ଼୍‌ତ ଦୁତ୍‌ କି ପୁଇପୁୟା ଜିବୁନ୍‌ ହିଲୁତ୍‌ ଇଞ୍ଜି ଇନାର୍‌, ମତର୍‌ ପାରୁସିର୍‌ ହାରି ମାନି କିତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","ଇବେ ବେସି ଗଣ୍ଡ୍‌ଗଲ୍‌ ଗିଟାତାତ୍‌, ଆରେ ପାରୁସିର୍‍ତି କୁଦାନି କେତେକ୍‌ ସାସ୍ତର୍‌ ଗୁରୁର୍‌ ନିଂଜି ଜିକାଟାଣା କିଜ଼ି ଇଚାର୍‌, “ଆପେଂ ଇ ମାନାୟ୍‌ତାକେ ଇମ୍‌ଣାକା ପା ଦସ୍‌ ହୁଡ଼ୁପା, ପୁନ୍‌ୱାକା ଇମ୍‌ଣାକା ଜିବୁନ୍‌ କି ବାଦାଡ଼୍‌ତ ଦୁତ୍‌ ହେୱାନ୍‌ ହୁଦାଂ କାତା ଇଚାନ୍ନା ।” ");
INSERT INTO peg_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","ଇ ବାନି ବେସି ଗଣ୍ଡ୍‌ଗଲ୍‌ ଆତିଲେ, ଏଚେକାଡ଼୍‌ଦ ପାଉଲ୍‌ ହେୱାର୍‌ ହୁଦାଂ ଗାଣ୍ଡ୍ରା ଗାଣ୍ଡ୍ରା ଆନାନ୍‌, ଇ ପାଣ୍ଡ୍ରାଜ଼ି ହାଜାର୍‌ ହାଜାର୍‌ ମେଲ୍ୟାର୍‌ ହେୱାର୍‌ ବିତ୍ରେ ତାଙ୍ଗ୍‌ ବଲତ୍‌କାର୍‌ କିଜ଼ି ଗାଡ଼୍‌ ବିତ୍ରେ ଅଜ଼ି ତାତେଙ୍ଗ୍‌ କାଜିଂ ମେଲ୍ୟାରିଂ ହାଞ୍ଜେଙ୍ଗ୍‌ ବଲ୍‌ ହିତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","ହେ ନାଣା ମାପ୍ରୁ ତା ଲାଗେ ଇଞ୍ଜ ଇଚାନ୍‌, “ସାସ୍‌ ଆହା, ଇନାକିଦେଂକି ଏନ୍‌ ଇନେସ୍‌ ଜିରୁସାଲମ୍‌ତ ମା ବିସ୍ରେ ସାକି ହିତାୟ୍‌ନା, ହେ ଲାକେ ନିଂ ରମ୍‌ତ ପା ସାକିହିଦେଂ ଆନାତ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","ଦିନ୍‌ ଆତିଲେ, ଜିହୁଦିର୍‌ କୁଦା କୁଦା ଆଜ଼ି ପାଉଲ୍‌ତିଂ ଅହ୍‌ୱି ପାତେକ୍‌ କାଦିପିଦି ଡୁତିସ୍ ସାଇପ୍‌ ଆନାପ୍‌ ଇଞ୍ଜି ରାଣ୍‍ତ ଜାର୍‌ ଜାର୍‌ତିଂ ଇଡ୍‌ତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","ଇ ହାତୁର୍‌ କିଜ଼ିମାନି ଲକୁ ରିକଡ଼ି ଜାଣ୍‍ତାଂ ଆଦିକ୍‌ ମାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","ହେୱାର୍‌ ମୁଡ଼୍‌ ମାପ୍ରୁହେବାକିନାକାନ୍‌ ଆରି ପ୍ରାଚିନାର୍‌ ଲାଗେ ୱାଜ଼ି ଇଚାର୍‌, “ଆପେଂ ପାଉଲ୍‌ତିଂ ଅହ୍‌ୱି ପାତେକ୍‌ ମୁଡ଼େ ତିଞ୍ଜେଙ୍ଗ୍‌ କପ୍‌ ଇଞ୍ଜି ଜାର୍‌ ଜାର୍‌ତିଂ ଆଟ୍‌ୱା ରାଣ୍‍ ଅତାପ୍‌ନ୍ନା । ");
INSERT INTO peg_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","ଇଚିସ୍‌, ଏପେଙ୍ଗ୍‌ ଆଦିକ୍‌ ହାର୍‌ କିଜ଼ି ହେୱାନ୍ତି ବିଚାର୍‌ କିଦେଙ୍ଗ୍‌ ମାନ୍‌ କିନାନା ଇଞ୍ଜି ହାତୁର୍‌ କିଜ଼ି ତାଙ୍ଗ୍‌ ମି ଲାଗେ ତାତେଙ୍ଗ୍‌ କାଜିଂ ନଙ୍ଗ୍‌ ଗାଜା ସବା ଲାହାଙ୍ଗ୍‌ ହାଜାର୍‍ ମୁସ୍ତିଦାର୍‍ତିଂ ୱାରି କିୟାଟ୍‌ । ହେୱାନ୍‌ ମି ଲାଗେ ତାନି ଆଗେ ଆପେଂ ହେୱାନିଂ ଅସ୍ତେଙ୍ଗ୍‌ ଜାଲ୍‌ଦି ମାନାପ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","ମତର୍‌ ପାଉଲ୍‌ ବାଣ୍‌ଜା ମେଲ୍ୟାର୍‌ ଡ଼ୁଗ୍‌ଜି ମାନାକା କାତା ୱେନ୍‌ଞ୍ଜି ୱାଜ଼ି ବସ୍ତି ବିତ୍ରେ ହଣ୍‌ଜି ପାଉଲ୍‌ତିଂ ୱେଚ୍‌ଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","ହେବେଣ୍ଡାଂ ପାଉଲ୍‌ ରୱାନ୍‌ ହାଜାର୍‌ ମୁସ୍ତିଦାର୍‍ତିଂ କୁକ୍‌ଚି ଇଚାନ୍‌, “ଇ ଦାଂଣେନ୍ତିଙ୍ଗ୍ ହାଜାର୍‍ ମୁସ୍ତିଦାର୍ ଲାଗେ ଅହାଟ୍‌, ଇନାକିଦେଂକି ତାଙ୍ଗ୍‌ ୱେଚ୍‌ଚେଙ୍ଗ୍‌ କାଜିଂ ଇୱାନ୍ତି ଅଲପ୍‍ କାତା ମାନାତ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","ଲାଗିଂ ହେୱାନ୍‌ ହେୱାନିଂ ହାଜାର୍‍ ମୁସ୍ତିଦାର୍ ଲାଗାୟ୍‌ ଅସି ହାଲ୍‍ଜି ଇଚାନ୍‌, “ବନ୍ଦି ପାଉଲ୍‌ ଜାର୍‌ ଲାଗେ ନାଙ୍ଗ୍‌ କୁକ୍‌ଚି ନି ଲାଗେ ଇ ଦାଂଣେନ୍ତିଙ୍ଗ୍ ତାହିୱାଦେଂ କାଜିଂ ଗୱାରି କିତ୍‌ତାନ୍‌, ନିଂ ଇଞ୍ଜେଙ୍ଗ୍‌ କାଜିଂ ଇୱାନ୍ତି ଅଲପ୍‍ କାତା ମାନାତ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","ହାଜାର୍‌ ମୁସ୍ତିଦାର୍ ହେୱାନିଂ କେଇ ଆସ୍ତି ତାଙ୍ଗ୍‌ ମାନାୟାର୍‌ ଲାଗାୟ୍‌ ଅଜ଼ି ୱେନ୍‌ବାତାନ୍‌, “ନାଙ୍ଗ୍‌ ୱେଚ୍‍ଚିନି କାଜିଂ ନିନ୍ଦାଂ ଇନାକା ମାନାତ୍‌ ?” ");
INSERT INTO peg_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","ହେୱାନ୍‌ ଇଚାନ୍‌, ପାଉଲ୍‌ ବିସ୍ରେ ଆଦିକ୍‌ ହାର୍‌ କିଜ଼ି ଡେକ୍‍ନି କାଜିଂ କପଟ୍‍ତାଂ “ଜିହୁଦିର୍‌ ତାଙ୍ଗ୍‌ ନିହିଂ ଗାଜା ସବା ଲାଗାୟ୍‌ ତାହିୱାଦେଂ କାଜିଂ ନିଂ ଗୱାରି କିଦ୍‌ନି କାଜିଂ ରମାନ୍‌ ଆତାର୍ଣ୍ଣା । ");
INSERT INTO peg_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","ମାତର୍‌ ହେୱାର୍‌ତି କାତା ରାଜ଼ି ଆମାଟ୍‌; ଇନାକିଦେଂକି ରିକଡ଼ି ଜାଣ୍‍ତାଂ ଆଦିକ୍‌ ଲକୁ ହେୱାନିଂ ଅହ୍‌ୱି ପାତେକ୍‌ ତିନା ଉଣା କିଉପ୍‌ ଇଞ୍ଜି ପାର୍ମାଣ୍‌ କିଜ଼ି ଡ଼ୁଗ୍‌ଜି ମାଚାର୍‌ । ନଙ୍ଗ୍‌ ହେୱାର୍‌ ନି ବୁଜାୟ୍‌ କିନାକା କାସି ଜାଲ୍‌ଦି ଆଜ଼ି ମାଚାର୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","ହେବେଣ୍ଡାଂ ହାଜାର୍‍ ମୁସ୍‌ତିଦାର୍ ହେ ଦାଂଣେନ୍ତିଙ୍ଗ୍ ହେଲୱେୟ୍‌ ହିଜ଼ି ତାଙ୍ଗ୍‌ ବଲ୍‌ ହିତାନ୍‌, “ଏନ୍‌ ଜେ ଇ ୱିଜ଼ୁ କାତା ନାଙ୍ଗ୍‌ ୱେଚ୍‌ଚାତାୟ୍‍ନା, ହେଦାଂ ଇନେରିଂ ୱେଚୁୟ୍ ।” ");
INSERT INTO peg_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","ପାଚେ ହେୱାନ୍‌ ରିକାର୍‌ ପାଞ୍ଚ୍‍କଡ଼ି ମୁସ୍ତାଦାର୍‍ତିଂ କୁକ୍‌ଚି ଇଚାନ୍‌, କାଇସରିୟା ପାତେକ୍‌ “ହାନି କାଜିଂ ନାଣା ନଅ ଗଣ୍ଟା ସମୁତ ଦସ୍‌ କଡ଼ି ମେଲ୍ୟାର୍‌, ତିନ୍‍କଡ଼ି ଦସ୍‌ ଜାଣ୍‌ ଗଡ଼ା ଦୁମ୍‍ନାକାର୍ ଆରି ଦସ୍‌କଡ଼ି ବାଲାସ୍ତାକାରିଂ ଜାଲ୍‌ଦି କିୟାଟ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","ଆରେ, ହେୱାର୍‌ ଇନେସ୍‌ ପାଉଲ୍‌ ପସୁ ଜପି କୁଚି କିଜ଼ି ସାସନ୍‍କାର୍‍ୟା ପେଲିକସ୍‌ତି ଲାଗାୟ୍‌ ରାକ୍ୟା ହିଲ୍‍ୱାଦାଂ ଅସି ହାନାର୍, ଇଦାଂ କାଜିଂ ହେଦାଂ ଜାଲ୍‌ଦି କିନି କାଜିଂ ହେୱାନ୍‌ ବଲ୍‌ ହିତାନ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","ଆରେ, ହେୱାନ୍‌ ଇ ଲାକେ ର ଆକି ଲେକିକିତାନ୍ । ");
INSERT INTO peg_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“ଗାଜା ସାଏବ୍ ସାସନ୍‍ କାର୍‍ହା ପେଲିକସ୍‌ତିଂ କ୍ଲାଉଦିଆ ଲୁସିୟାତି ଜୱାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","ଜିହୁଦିର୍‌ ଇ ଲକ୍‌ତିଂ ଆସ୍ତି ଅସ୍ତେଙ୍ଗ୍‌ ହାନି ସମୁତ ଆନ୍‌ ମେଲ୍ୟାର୍ତି ହୁଦାଂ ହାଲ୍‌ଜି ହେୱାନ୍‌ ରୱାନ୍‌ ରମିୟ ଇଞ୍ଜି ପୁଞ୍ଜି ଇୱାନିଂ ଉଦାର୍‌ କିତାଂ । ");
INSERT INTO peg_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","ଇମ୍‌ଣି କାରଣ୍‌ତାଂ ହେୱାର୍‌ ଇୱାନ୍‌ ବିରୁଦ୍‌ତ ଦସି କିନାରା, ହେଦାଂ ପୁଞ୍ଜେଙ୍ଗ୍‌ ମାନ୍‌ କିଜ଼ି ଆନ୍‌ ଇୱାନିଂ ହେୱାର୍‌ତି ଗାଜା ସବା ଲାଗାୟ୍‌ ଅସି ହାଚାଙ୍ଗ୍ । ");
INSERT INTO peg_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","ପାରାଣ୍‍ ଡାଣ୍ଡ୍‌ କି ହିକ୍‌ଡ଼ି ଗାଚ୍ୟାନି ଜଗ୍ ଇମ୍‌ଣାକା ପା ବିସ୍ରେ ଇୱାନିଂ ବିରୁଦ୍‌ତ ଦାବା କିୱାଦାଂ ହେୱାର୍‌ତି ବିଦି ବାବ୍ରେ ଗଣ୍ଡ୍‌ଗଲ୍‌ ବିସ୍ରେ ଦାବା କିୟାତାତ୍‍ନ୍ନା ଇଞ୍ଜି ଆନ୍‌ ବୁଜାତାଂ । ");
INSERT INTO peg_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","ଇ ଲକ୍‌ ବିରୁଦ୍‌ତ ମାନ୍‌ ପାଚିକିତାର୍‌ ଇଞ୍ଜି ନାଙ୍ଗ୍‌ କାବୁର୍‌ ହିତ୍‌ତିଲେ ଆନ୍‌ ଇୱାନିଂ ମାଲା ଆୱାଦାଂ ନି ଲାଗାୟ୍‌ ପକ୍ତାତାଂ, ଇୱାନ୍ତି ଦାବାକିନାକାରିଂ ପା ନି ମୁମ୍‌ଦ ଇୱାନ୍‌ ବିରୁଦ୍‌ତ ସାକି ହିଦେଂ ବଲ୍‌ ହିତାଂ ।” ");
INSERT INTO peg_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","ହେବେଣ୍ଡାଂ ମେଲ୍ୟାର୍‌ ପାୟାତି ବଲ୍‌ତାଂ ପାଉଲ୍‌ତିଂ ଅଜ଼ି ମାଜ୍‍ଗାତ ତାଙ୍ଗ୍‌ ଆନ୍ତିପାତ୍ରିତ ତାହିୱାତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","ଆର୍କାତ୍‌ ନାଜିଂ ମେଲ୍ୟାର୍‌ ଗଡ଼ା ଦୁମ୍‍ନାକାରିଂ ତା ହୁଦାଂ ହାନି କାଜିଂ ଗାଡ଼୍‌ଦ ମାସ୍‌ଦି ହାଚାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","ପାଚେ ଗଡ଼ା ଦୁମ୍‍ନାକାର୍ କାଇସରିୟାତ ୱାଜ଼ି ସାସନ୍‍କାର୍‍ୟାଙ୍ଗ୍ ଆକି ହିତାର୍‌, ଆରେ ପାଉଲ୍‌ତିଂ ପା ହେୱାନ୍‌ କେଇଦ ହେଲାୟ୍‌ କିତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","ହେ ଆକି ପଡ଼ି କିତି ପାଚେ, ହେୱାନ୍‌ ଇମ୍‌ଣି ରାଜିନି ଲଗୁ ଇଞ୍ଜି ୱେନ୍‌ବାତାନ୍‌, ଆରେ, ହେୱାନ୍‌ ଜେ କିଲିକିୟାନି ଲଗୁ, ଇଦାଂ ପୁଞ୍ଜି ");
INSERT INTO peg_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","ଆରେ ହେୱାନ୍‌ ଇଚାନ୍‌, ନି ଦାବାକାରିୟାର୍‍ ପା ଇକାୱାତାର୍, “ଆନ୍‌ ନି କାତା ୱେନାଙ୍ଗ୍ ।” ଆରେ ହେୱାନ୍‌ ହେରଦ୍‌ତି ବାଙ୍ଗ୍‌ଲାତ ତାଙ୍ଗ୍‌ ଇଡ୍‌ଦେଂ କାଜିଂ ବଲ୍‌ ହିତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","ପାଞ୍ଚ୍ ଦିନ୍‌ ପାଚେ ହାନାନ ମୁଡ଼୍‌ ମାପ୍ରୁହେବାକିନାକାନ୍‌ କେତେକ୍‌ ପ୍ରାଚିନାରିଂ ଆରି ତର୍ତୁଲ୍ଲ ତର୍‌ ନି ରୱାନ୍‌ ଅକିଲ୍‌ ହୁଦାଂ କାଇସରିୟାତ ୱାତାନ୍, ଆରେ ହେୱାର୍‌ ପାଉଲ୍‌ତି ବିରୁଦ୍‌ତ ସାସନ୍‍କାର୍‍ୟା ଲାଗେ ଦାବା କିତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","ହେୱାନିଂ କୁକିକିତିଲେ ତର୍ତୁଲ୍ଲ ହେୱାନିଂ ଦାବା କିଜ଼ି ଇଞ୍ଜେଙ୍ଗ୍‌ ଲାଗାତାନ୍‌, “ଏ ଗାଜା ସାଏବ୍ ପେଲିକସ୍‌, ନି ହୁଦାଂ ଆପେଂ ଜେ ମି ରାଜି ବେସି ସୁସ୍ତା ପାୟାତାପ୍‌ନା, ଆରେ ନି ପ୍ରାତିପାଡ଼୍‍ଦ ଇ ଜାତି କାଜିଂ ବାରବିନ୍‍ କାମାୟ୍‌ ଆତାତ୍‌ନ୍ନା, ");
INSERT INTO peg_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","ଇଦାଂ ଆପେଂ ସବୁ ବାବ୍ରେ ଆରି ସବୁ ବାହାତ ବାର୍ତି ପେଲିକସ୍‌ତିଂ ୱାରି ଲାହାଙ୍ଗ୍‌ ମାନି କିତାପ୍‌ନ୍ନା । ");
INSERT INTO peg_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","ମତର୍‌ ଆନ୍‌ ଇନେସ୍‌ ଆଦିକ୍‌ ୱାହି କିଦୁଙ୍ଗ୍, ଇଦାଂ କାଜିଂ ଏନ୍‌ ଜାର୍‌ ଦୟା ଗୁଣ୍‍ତ ମାଦାଂ ଏଚେଗଟା କାତା ୱେଞ୍ଜେଙ୍ଗ୍‌ କାଜିଂ ଆନ୍‌ ନିଂ ଗୱାରି କିଦ୍‌ନାଙ୍ଗା । ");
INSERT INTO peg_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","ଇନାକିଦେଂକି ଆସେଙ୍ଗ୍‌ ଇ ଲକ୍‌ତିଂ ମାର୍‍ଡି ଲାକେ ପୁର୍ତିନି ୱିଜ଼ୁ ୱିଜ଼ାର୍‌ ଜିହୁଦିର୍‌ତି ବିତ୍ରେ କୁର୍ଲି କିବାନାକାନ୍ ଆରି ନାଜରିତିୟ କୁଦାନି ରୱାନ୍‌ ମୁଡ଼୍‌ ନେତା ଇଞ୍ଜି ପୁଚାପ୍‌ନ୍ନା; ");
INSERT INTO peg_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","ଆରେ ପା ଇୱାନ୍‌ ମନ୍ଦିର୍‌ ବିଟାଡ଼୍‌ କିଦେଙ୍ଗ୍‌ ସେସ୍ଟା କିଜ଼ି ମାଚାନ୍, ମତର୍‌ ଆପେଂ ଇୱାନିଂ ଆସ୍ତାପ୍ ଆରେ ମି ବିଦି ଇସାପ୍ରେ ଇୱାନ୍ତି ବିଚାର୍‌ କିଦେଙ୍ଗ୍‌ ଇଚା କିଜ଼ି ମାଚାପ୍ । ");
INSERT INTO peg_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","ମତର୍‌ ହାଜାର୍‍ ମୁସ୍ତିଦାର୍ ଲୁସିୟା ୱାଜ଼ି ଜବର୍‌ ବଲତ୍‌କାର୍‌ତାଂ ଇୱାନିଂ ମା କେୟ୍‌ଦାଂ କିସ୍ଟ ଅତାନ୍‌, ");
INSERT INTO peg_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","ଆରେ, ଇୱାନ୍ତି ଦାବାକାର୍‍ୟାରିଂ ନି ମୁମ୍‌ଦ ଇକାୱାନି କାଜିଂ ବଲ୍‌ ହିତାନ୍‌ । ଇ ଇମ୍‍ଣି ୱିଜ଼ୁ ବିସ୍ରେ ଆପେଂ ଡେକ୍‌ଚି ଇଦାଂ ବିରୁଦ୍‌ତ ଦାବା କିନାପା, ଏନ୍‌ ନିଜେ ଇୱାନିଂ ପର୍‌ସନ୍‌ କିତିସ୍‌ ହେ ସବୁ ପୁଞ୍ଜେଙ୍ଗ୍‌ ଆଡ୍‌ନାୟ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","ଜିହୁଦିର୍‌ ପା ଦାବାତ ମିହାଜ଼ି ଇ ୱିଜ଼ୁ କାତା ହାତ୍‌ପା ଇଞ୍ଜି ଇଞ୍ଚାର୍ । ");
INSERT INTO peg_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","ହେବେଣ୍ଡାଂ ସାସନ୍‍କାର୍‍ୟା କାତା ଇନି କାଜିଂ ପାଉଲ୍‌ତିଂ ଚଚ୍‍ଚିଲେ, ହେୱାନ୍‌ ଉତର୍‌ ହିତାନ୍‌, “ଏନ୍‌ ଆଦିକ୍‌ ବାର୍ହୁ ଆତାତ୍‌ ଇ ଜାତିନି ବିଚାର୍‌କାର୍‌ୟା ମାନାନ୍‌ ଇଞ୍ଜି ପୁନିକାଜିଂ ଆନ୍‌ ସାସ୍‍ତ ନା ପାକ୍ୟା ବାଚି କିନାଙ୍ଗା । ");
INSERT INTO peg_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","ବାର ଦିନ୍‌ତାଂ ଆଦିକ୍‌ ଆଉତ୍‌ ଆନ୍‌ ପାର୍ତାନା କିନି କାଜିଂ ଜିରୁସାଲମ୍‌ତ ହାଲ୍‍ଜି ମାଚାଙ୍ଗ୍, ଇଦାଂ ଏନ୍‌ ପୁଞ୍ଜେଙ୍ଗ୍‌ ଆଡ୍‌ନାୟ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","ଆରେ, ଇୱାର୍‌ ମନ୍ଦିର୍‌ତ କି ପାର୍ତାନା ଇଞ୍ଜ କି ଗାଡ଼୍‌ଦ ନାଙ୍ଗେଙ୍ଗ୍ ଇନେର୍‌ ହୁଦାଂ ଗଣ୍ଡ୍‌ଗଲ୍‌ କିନାକା କି ଲକାଂ ଟିଉଲାୟ୍‌ କିନାକା ହୁଡ଼୍‍ଦାୱାତାର୍ଣ୍ଣା, ");
INSERT INTO peg_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","ଆରେ, ନଙ୍ଗ୍‌ ଇୱାର୍‌ ନା ବିରୁଦ୍‌ତ ଇମ୍‍ଣି ୱିଜ଼ୁ ବିସ୍ରେ ଅଜ଼ି ଦାବା କିନାରା, ହେ ସବୁ ନି ଲାଗେ ପାର୍ମାଣ୍‌ କିଦେଙ୍ଗ୍‌ ଆଡୁର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","ମତର୍‌ ଇୱାର୍‌ ଇନେରିଂ ର ବିନ୍‍ଦର୍ମି କୁଦା ଇଞ୍ଜି ଇନାର୍‌, ଆନ୍‌ ହେ ହାଜ଼ି ଇସାପ୍ରେ ମା ଆବା ଲେତ୍ରାତି ଇସ୍ୱର୍‌ତି ପାର୍ତାନା କିଜ଼ି ମାନାଂ; ଇନା ଇନାକା ମସାତି ବିଦି ଇସାପ୍‌ରେ ଆରି ଇନା ଇନାକା ବେଣ୍‌ବାକ୍‌ଣାୟ୍‌କିନାକାର୍‌ ସାସ୍ତର୍‍ତ ଲେକା ମାନାତ୍‌, ହେ ସବୁ ଆନ୍‌ ପାର୍ତି କିନାଙ୍ଗ୍‌; ");
INSERT INTO peg_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","ଆରେ, ଦାର୍ମି ଆରି ଅଦାର୍ମି ରିୟାର୍‌ ଆରେ ନିଂନାକା ଆନାତ୍‌ ଇଞ୍ଜି ଇନାକା ଇୱାର୍‌ ନିଜେ କାସି ମାନାର୍‌, ଆନ୍‌ ପା ଇସ୍ୱର୍‌ତାଂ ହେ ଲାକେ ବାର୍ସି ଇଡ୍‍ତାଂନା ଇଞ୍ଜି ନି ଲାଗେ ମାନି କିନାଙ୍ଗା । ");
INSERT INTO peg_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","ଇ ଏତ୍‌ ତାଂ ଆନ୍‌ ପା ନିଜେ ନିତ୍ରେ ଇସ୍ୱର୍‌ତି ଆରି ମାନାୟ୍‍ତି କାଜିଂ ଦସି ହିଲ୍‌ୱି ଚିନ୍ତା ରାକ୍ୟା କିଦେଙ୍ଗ୍‌ ଜାତୁନ୍ କିଜ଼ି ମାନାଙ୍ଗା ।” ");
INSERT INTO peg_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","“ବେସି ବାର୍ହୁ ପାଚେ ଆନ୍‌ ନା ଜାତି ଲାଗେ ଦାନ୍‌ ତାତେଙ୍ଗ୍‌ କାଜିଂ ଆରି ପୁଜା ହିନି କାଜିଂ ଜିରୁସାଲମ୍‌ତ ହାଲ୍‌ଜି ମାଚାଙ୍ଗ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","ହେ ୱେଡ଼ାଲିଂ ଇୱାର୍‌ ନାଙ୍ଗେଙ୍ଗ୍ ମନ୍ଦିର୍‌ତ ସକଟ୍‌ ଆଜ଼ି ମାନାକା ହୁଡ଼୍‌ଜି ମାଞ୍ଚାର୍; ଆନ୍‌ ଇମ୍‌ଣାକା ପା ଲକୁରିଂ ନଲେ ଗଣ୍ଡ୍‌ଗଲ୍‍ତ ମେହା ଆୱାଦାଂ ମାଚାଙ୍ଗ୍ । ");
INSERT INTO peg_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","ମାତର୍‌ ଆସିଆନି କେତେକ୍‌ ଜିହୁଦିର୍‌ ମାଚାର୍‌; ଜଦି ହେୱାର୍‌ତି ନା ବିରୁଦ୍‌ତ ଇମ୍‌ଣାକା ପା କାତା ମାଚିସ୍‌, ତାଆତିସ୍‌ ନି ମୁମ୍‌ଦ ଏକିସ୍ ଦାବା କିନାକା ହେୱାର୍‌ତି ହାର୍‌ ଆତାତ୍ମା । ");
INSERT INTO peg_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","ଆରେରଗ ଆନ୍‌ ଗାଜା ସବା ମୁମ୍‌ଦ ଇଞ୍ଜି ମାଚାଙ୍ଗ୍‌ ଆନ୍‌ ଇମ୍‌ଣି ପାପ୍‌ତ ବାନ୍ୟା ଆଜ଼ି ମାଚାଙ୍ଗ୍‌, ହେଦାଂ ଇବେ ମାନି ଇ ମାନାୟାର୍‌ ଇଞ୍ଜେର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","ଆତିସ୍‌ପା ଆନେଙ୍ଗ୍‌ ର କାତା ଇଞ୍ଜି ମାଚାଙ୍ଗ୍‌, ହେୱାର୍‌ ବାହାତ ଇଞ୍ଜ ମାନି ସମୁତ ଆନ୍‌ ଆଟ୍‌ୱା କିଜ଼ି ଇଞ୍ଜି ମାଚାଙ୍ଗ୍‌, ହାକିର୍‌ ଆରେ ନିଂନାକା ଇଞ୍ଜି ଆନ୍‌ ପାର୍ତି କିଜ଼ି ମାଚିଲେ ନେଞ୍ଜେଙ୍ଗ୍‌ ନି ହୁଦାଂ ବିଚାର୍‌ କିୟାନାଙ୍ଗା ।” ");
INSERT INTO peg_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","ମତର୍‌ “ପେଲିକସ୍‌ ହେ ହାଜ଼ି ବିସ୍ରେ ଏଚେକ୍ ଆଦିକ୍‌ ହାତୁର୍‌ ପୁଞ୍ଜି ମାଚିଲେ ବିଚାର୍‌ ଟେବାୟ୍‌ କିଜ଼ି ଇଚାନ୍‌, ହାଜାର୍‍ ମୁସ୍ତିଦାର୍ ଲୁସିୟା ୱାତିସ୍ ଆପ୍‌ ମିଦାଙ୍ଗ୍‌ ବିସ୍ରେ ତିର୍‌ କିନାପ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","ଆରେ, ହେୱାନ୍‌ ପାଞ୍ଚ୍‍କଡ଼ି ମୁସ୍ତିଦାର୍‍ତିଂ ହେୱାନ୍ତି ଇମ୍‌ଣାକା ପା ୱାସ୍କିନି ଜାର୍‌ ଲଗାଂ ହେୱାନ୍ତି ହେବାକିନାକା କାଜିଂ ମୁନା କିୱାଦାଂ, ଆରେ ତା ବନ୍ଦି ଲାକେ ରାକ୍ୟା କିଜ଼ି ତା କାଜିଂ କୱାଣ୍ ଚିନ୍ତା କିଦେଙ୍ଗ୍‌ ବଲ୍‌ ହିତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","କେତେକ୍‌ ଦିନ୍‌ ପାଚେ ପେଲିକସ୍‌ ଦ୍ରୁସିଲା ତର୍‌ନି ଜାର୍‌ ଜିହୁଦିୟା ଡକ୍ରୁହି ଲାହାଙ୍ଗ୍‌ ୱାଜ଼ି ପାଉଲ୍‌ତିଂ କୁକ୍‌ଚି କ୍ରିସ୍ଟ ଜିସୁତିତାକେ ପାର୍ତି ବିସ୍ରେ ହେୱାନ୍‌ ତାକେ ୱେଚାନ୍ । ");
INSERT INTO peg_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","ମତର୍‌ ହେୱାନ୍‌ ଦାର୍ମି, ୱାସ୍କିତିଂ ଆରି ୱାନିଦିନ୍ତ ବିଚାର୍‌ କାମାୟ୍‌ ବିସ୍ରେ କାତା ଇନି ସମୁତ ପେଲିକସ୍‌ ପାଣ୍ଡ୍ରା ଆଜ଼ି ଉତର୍‌ ହିତାନ୍‌, “ନଙ୍ଗ୍‌ ଏପେଙ୍ଗ୍‌ ହାଲାଟ୍‌, ସୁବିଦା ସମୁ ପାୟାତିସ୍ ଆପ୍‌ ମିଙ୍ଗ୍‌ କୁକିକିଦ୍ନାପ୍ ।” ");
INSERT INTO peg_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","ଆରେ ପା ପାଉଲ୍‌ ତାଙ୍ଗ୍‌ ଟାକାଂ ହିଦ୍‌ନାଂ ଇଞ୍ଜି ହେୱାନ୍‌ ଆହା କିଜ଼ି ମାଚାନ୍‌; ହେଦାଂ କାଜିଂ ରଗତିଂ ରଗ ତାଙ୍ଗ୍‌ କୁକ୍‌ଚି ତା ଲାହାଙ୍ଗ୍‌ କାତାବାର୍ତା କିବିସ୍‍ ମାଚାନ୍ । ");
INSERT INTO peg_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","ମାତର୍‌ ଦୁଇ ବାର୍ହୁ ବାର୍ତି ଆତି ପାଚେ ପର୍କିୟ ପେସ୍ଟ ପେଲିକସ୍‌ତି ପାଦ୍‍ତ ବାଚି କିୟାତାନ୍‌, ଆରେ ପେଲିକସ୍‌ ଜିହୁଦିର୍‌ତି ବଲ୍‍ବଲାୟ୍‍ ଆଦେଂ ଇଚା କିଜ଼ି ପାଉଲ୍‌ତିଂ ବନ୍ଦି ଅବସ୍ତାତ ଇଡ଼୍‌ଜି ହାଚାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","ହେବେଣ୍ଡାଂ ପେସ୍ଟ ଆଦିକାର୍‌ ପାଦ୍‍ ଇଟି କିଜ଼ି ତିନି ଦିନ୍‌ ପାଚେ କାଇସରିୟାତାଂ ଜିରୁସାଲମ୍‌ତ ହାଚାନ୍‌, ");
INSERT INTO peg_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","ଆରେ, ମୁଡ଼୍‌ ମାପ୍ରୁହେବାକିନାକାନ୍‌ ଆରି ଜିହୁଦିର୍‌ତି ମୁଡ଼୍‌ ମୁଣିକାର୍ ପାଉଲ୍‌ତି ବିରୁଦ୍‌ତ ତା ଲାଗେ ଗୱାରି କିତାର୍‌, ");
INSERT INTO peg_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","ଆରେ ହେୱାନ୍‌ ଇନେସ୍‌ ତାଙ୍ଗ୍‌ ଜିରୁସାଲମ୍‌ତ କୁକ୍‌ଚି ପକ୍ତାନାନ୍‌, ଇଦାଂ କାଜିଂ ଗୱାରି ଆଗେ ତା ବିରୁଦ୍‌ତ ଇ ଦୟା ପାର୍ତାନା କିତାର୍‌, ଆରେ, ହେୱାର୍‌ ତାଙ୍ଗ୍‌ ହାସ୍‌ଦ ଅହି କିନି କାଜିଂ ଡ଼ୁଗ୍‌ଜି କୁଚ୍‌ଚାର୍ । ");
INSERT INTO peg_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","ହେବେ ପେସ୍ଟ ଉତର୍‌ ହିତାନ୍‌, “ପାଉଲ୍‌ କାଇସରିୟାତ ଗେହ୍ୟାଜ଼ି ମାନାନା, ଆରେ ଆନ୍‌ ପା ବେଗି ହେବେ ହାନାଙ୍ଗ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","ଲାଗିଂ, ମି ବିତ୍ରେ ଇମ୍‌ଣାକାର୍‌ ସାକ୍ତିକାଟାକାନ୍‌, ହେୱାର୍‌ ମା ଲାହାଙ୍ଗ୍‌ ହାଲ୍‌ଜି ହେ ଲକ୍‌ନି ଜଦି ଇମ୍‌ଣାକା ପା ଦସ୍‌ ମାଚିସ୍‌, ତେବେ ତା ବିରୁଦ୍‌ତ ଦାବା କିୟାଟ୍‌ ।” ");
INSERT INTO peg_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","ପାଚେ ହେୱାନ୍‌ ହେୱାର୍‌ ବିତ୍ରେ ଆଟ୍‌ କି ଦସ୍‌ ଦିନ୍‌ତାଂ ଆଦିକ୍‌ ମାନ୍‌ୱାଦାଂ କାଇସରିୟାତ ମାସ୍‌ଦି ହାଚାର୍‌, ଆରେ ଆର୍କାତ୍‌ ନାଜିଂ ଗାଦିତ କୁଚ୍‌ଚି ପାଉଲ୍‌ତିଂ ତାନି କାଜିଂ ବଲ୍‌ ହିତାନ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","ପାଉଲ୍‌ ୱାତିଲେ ଜିରୁସାଲମ୍‌ତାଂ ୱାତାକାର୍‌ ଜିହୁଦିର୍‌ ହେୱାନ୍ତି ଚାରିବେଣ୍‌ତାଂ ବେଡ଼ି କିଜ଼ି ନିଲ୍‌ତାର୍‌ ଆରି ତା ବିରୁଦ୍‌ତ ବେସି ଗାଜା ଦାବା କିତାର୍‌ । ମତର୍‌ ହେୱାର୍‌ ଇ ସବୁ ପାର୍ମାଣ୍‌ କିଦେଙ୍ଗ୍‌ ରାଜି ଆୱାତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","ହେବେ ପାଉଲ୍‌ ଜାର୍‌ ପାକ୍ୟା ପାଡ଼୍‌କା କିଜ଼ି ୱେଚ୍‌ଚାନ୍‌, “ଜିହୁଦିର୍‌ନି ମସାତି ବିଦି ବିରୁଦ୍‌ତ କି ମନ୍ଦିର୍‌ ବିରୁଦ୍‌ତ କି କାଇସର୍‌ତି ବିରୁଦ୍‌ତ ଆନ୍‌ ଇନାକାପା ପାପ୍‌ କିୱାତାଂନ୍ନା ।” ");
INSERT INTO peg_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","ମତର୍‌ ପେସ୍ଟ ଜିହୁଦିର୍‌ତି ଦୟା ଆଦେଂ ଇଚା କିଜ଼ି ପାଉଲ୍‌ତିଂ ଉତର୍‌ ହିତାନ୍‌, “ଏନ୍‌ କି ଜିରୁସାଲମ୍‌ତ ହାଲ୍‌ଜି ହେ ବାହାତ ମା ମୁମ୍‌ଦ ଇ ସବୁ ବିସ୍ରେ ଅଜ଼ି ବିଚାର୍‌ ଆଦେଂ ଇଚା କିନାୟା ?” ");
INSERT INTO peg_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","ମତର୍‌ ପାଉଲ୍‌ ଇଚାନ୍‌, “ଆନ୍‌ କାଇସର୍‌ତି ଗାଦି ତାରେନ୍‌ ନିଲ୍‌ତାଂନ୍ନା, ହେ ବାହାତ ବିଚାର୍‌ ଆନାକା ମାନାତ୍‌ । ଆନ୍‌ ଜିହୁଦିର୍‌ତି କାଜିଂ ଇନାକାପା ଅନ୍ୟାୟ୍‌ କିୱାତାଂନ୍ନା, ଏନ୍‌ ପା ହେଦାଂ ଏଚେକ୍‌ ହାର୍‌ ଇଞ୍ଜି ପୁନାୟ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","ୱାଟିଙ୍ଗ୍‌, ଜଦି ଆନ୍‌ ଅନ୍ୟାୟ୍‌ କିତାକାଂ ଆଜ଼ି ମାଚିସ୍‌ ଆରି ହାକି ଜଗ୍ ଇନାକାପା କାମାୟ୍‌ କିଜ଼ି ମାଚିସ୍‌, ତା ଆତିସ୍‌ ଆନ୍‌ ହାକି ବଗ୍‌ କିଦେଙ୍ଗ୍‌ ମୁନା କିଦୁଙ୍ଗା; ମତର୍‌ ଇୱାର୍‌ ନା ବିରୁଦ୍‌ତ ଇନାକା ସବୁ ଦାବା କିନାରା, ହେ ସବୁ ବିତ୍ରେ ଜଦି ପାଦେକ୍‍ ପା ସତ୍‌ ଆକାୟ୍‌, ତା ଆତିସ୍‌ ଇମ୍‌ଣି ମାନାୟ୍‌ ପା ହେୱାର୍‌ କେଇଦ ନାଙ୍ଗ୍‌ ହେଲାୟ୍‌ କିଦେଙ୍ଗ୍‌ ଆଡୁର୍‌ । ଆନ୍‌ କାଇସର୍‌ତି ସାରାଣ୍‍ତ ବିଚାର୍ଣ୍ଣା ଆଦେଂ କାଜିଂ ପାର୍ତାନା କିନାଙ୍ଗା ।” ");
INSERT INTO peg_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","ହେବେ ପେସ୍ଟ ମତ୍ରିମଣ୍ଡଲ୍‌ ଲାହାଙ୍ଗ୍‌ ବୁଜାସୁଜା କିଜ଼ି ଉତର୍‌ ହିତାନ୍‌, ଏନ୍‌ “କାଇସରିୟାତି ସାରାଣ୍‍ତ ବିଚାର୍ଣ୍ଣା ଆଦେଂ କାଜିଂ ପାର୍ତାନା କିତାୟ୍‌ନା, ଏନ୍‌ କାଇସର୍‌ ଲାଗେ ହାନାୟ୍ ।” ");
INSERT INTO peg_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","କେତେକ୍‌ ଦିନ୍‌ ହାଚି ପାଚେ ରାଜା ଆଗ୍ରିପ୍‌ପା ଆରି ବର୍ଣ୍ଣିକି କାଇସରିୟାତ ୱାଜ଼ି ପେସ୍ଟତିଂ ବେଟା ଆତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","ହେୱାର୍‌ ବେସି ଦିନ୍‌ ହେ ବାହାତ ମାଚିଲେ, ରାଜା ଆଗେ ପେସ୍ଟ, ପାଉଲ୍‌ତି କାତା ୱେଚ୍‌ଚି ଇଚାନ୍‌, “ପେଲିକସ୍‌ ରୱାନ୍‌ ଲଗାଂ ବନ୍ଦି କିଜ଼ି ଇଡ଼୍‌ଜି ହାଚାନ୍ନା । ");
INSERT INTO peg_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","ଆନ୍‌ ଜିରୁସାଲମ୍‌ତ ମାନି ସମୁତ ଜିହୁଦିର୍‌ତି ମୁଡ଼୍‌ ମାପ୍ରୁହେବାକିନାକାନ୍‌ ଆରି ପ୍ରାଚିନାର୍‌ ତା ବିସ୍ରେ ନା ଲାଗେ ଗୱାରି କିଜ଼ି ତା ବିରୁଦ୍‌ତ ଦଣ୍ଡ୍‌ବଲ୍‌ ପାର୍ତାନା କିତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","ଆନ୍‌ ହେୱାରିଂ ଉତର୍‌ ହିତାଂ, ଇନାକାନ୍‌ ଆରି କାତା ନାହାଁୟ୍ ମୁକାମୁକି ଆୱି ପାତେକ୍‌, ଆରେ କାତା ନାହାତି ବିରୁଦ୍‌ତ ବିଚାର୍‌ କିଜ଼ିମାନି ଦାବା ସମୁତ ୱାସ୍କିପାକ୍ୟା ପାଡ଼୍‌କା କିନି ସୁବିଦା ପାୟାୱି ପାତେକ୍‌ ହେୱାନିଂ ହେଲାୟ୍‌ କିନାକା ରମିୟର୍‌ତି ବିଦି ଆକାୟ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","ଲାଗିଂ ହେୱାର୍‌ ନା ହାଙ୍ଗ୍‍ଦାଂ ଇ ବାହାତ ୱାତିଲେ, ଆନ୍‌ ମାଲାୱାଦାଂ ଆର୍କାତ୍‌ ନାଜିଂ ଗାଦିତ କୁଚ୍‌ଚି ହେ ମାନାୟ୍‌ତିଂ ତାତେଙ୍ଗ୍‌ କାଜିଂ ବଲ୍‌ ହିତାଂ । ");
INSERT INTO peg_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","ଦାବାକାରିର୍‌ ଇଞ୍ଜ, ଆନ୍‌ ଇନେସ୍‌ବାନି ଦସ୍‌ନି କାତା କାସି ମାଚାଙ୍ଗ୍, ହେ ଲାକେ ଇନାକାପା ଦାବା ହେଦାଂ ବିସ୍ରେ ତାୱାତାର୍ । ");
INSERT INTO peg_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","ମତର୍‌ ହେୱାର୍‌ତି ଜାର୍‌ ଦାରୁମ୍ ଆରେ ଜିସୁ ତର୍‌ ନି ରୱାନ୍‌ ହାତି ମୁଣିକା, ଇନେରିଂ ପାଉଲ୍‌ ଜିଜ଼ି ମାଚାନ୍‌ ଇଞ୍ଜି ଇଞ୍ଜି ମାଚାନ୍‌, ହେ ସବୁ ବିସ୍ରେ ତା ବିରୁଦ୍‌ତ ହେୱାର୍‌ତି ଏଚେକ୍‌ କୁର୍ଲି ମାଚାତ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","ଇ ୱିଜ଼ୁ ବିସ୍ରେ ଇନେସ୍‌ବାନି ଡେକ୍‍ନାଙ୍ଗ୍ ଇଞ୍ଜି ଆନ୍‌ ବୁଦିବାଣା ଆଜ଼ି, ହେୱାନ୍‌ ଜିରୁସାଲମ୍‌ତ ହାଲ୍‌ଜି ହେବେ ଇ ୱିଜ଼ୁ ବିସ୍ରେ ବିଚାର୍‌ ଆଦେଂ କାଜିଂ ଇଚା କିନାନ୍‌ କି ଆକାୟ୍‌, ଇଦାଂ ୱେନ୍‌ବାତାଂ । ");
INSERT INTO peg_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","ମତର୍‌ ପାଉଲ୍‌ ରାଜାର୍‍ତାଂ ରାଜା ବିଚାର୍‌ କାଜିଂ ଇଟ୍ୟାନି କାଜିଂ ପାର୍ତାନା କିତିଲେ, ଆନ୍‌ ତାଙ୍ଗେଙ୍ଗ୍‌ କାଇସର୍‌ତି ଲାଗେ ପକ୍‌ୱି ପାତେକ୍‌ ବନ୍ଦି କିଜ଼ି ଇଡ୍‌ଦେଂ ବଲ୍‌ ହିତାଂ ।” ");
INSERT INTO peg_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","ହେବେଣ୍ଡାଂ ଆଗ୍ରିପ୍‌ପା ପେସ୍ଟତିଂ ଇଚାନ୍‌, “ଆପେଂ ପା ନିଜେ ହେ ଲକ୍‌ନି କାତା ୱେଞ୍ଜେଙ୍ଗ୍‌ ଇଚା କିନାପା ।” ହେୱାନ୍‌ ଇଚାନ୍‌, “ୱିଗା ଏପେଙ୍ଗ୍‌ ତାଦି କାତା ୱେନାଦେର୍ ।” ");
INSERT INTO peg_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","ଲାଗିଂ, ଆର୍କାତ୍‌ ନାଜିଂ ଆଗ୍ରିପ୍‌ପା ଆରି ବର୍ଣ୍ଣିକି ଗାଜା ବିଡ଼୍‌ତ ୱାଜ଼ି ମୁଡ଼୍‌ ମୁଡ଼୍‌ ମେଲ୍ୟାର୍‌ ଆରି ଗାଡ଼୍‌ନି ମୁଡ଼୍‌ ମୁଡ଼୍‌ ମୁଣିକାର୍ ହୁଦାଂ ବିଚାର୍ଣ୍ଣା ବାହାତ ହଟିଲେ ପେସ୍ଟତି ବଲ୍‌ ଇସାବ୍‌ରେ ପାଉଲ୍‌ତିଂ ତାହିୱାୟାତାନ୍ । ");
INSERT INTO peg_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","ହେବେ ପେସ୍ଟ ଇଚାନ୍‌, “ଏ ରାଜା ଆଗ୍ରିପ୍‌ପା ଆରି ମାହୁଦାଂ ଇ ବାହାତ ମାଚି ଗାଜାଲଗୁ କାଦେର୍, ଏପେଙ୍ଗ୍‌ ଇ ଲକ୍‌ତିଂ ହୁଡ଼୍‌ନାଦେରା, ଇୱେନ୍ ବିରୁଦ୍‌ତ ଜିରୁସାଲମ୍‌ତ ଆରି ଇ ବାହାତ ପା ଜିହୁଦି ଲକୁ ମା ଲାଗେ ଗୱାରି କିଜ଼ି ତାଦାଂ ଆରେ ଜିଜ଼ି ମାନାକା ହାର୍‌ ଆକାୟ୍‌ ଇଞ୍ଜି ଚେରା ଆତାର୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","ମାତର୍‌ ହେୱାନ୍‌ ହାକି ଜଗ୍ ଇନାକାପା କାମାୟ୍‌ କିୱାତାନ୍ନା ଇଞ୍ଜି ଆନ୍‌ ବୁଜାତାଂ, ଆରେ ହେୱାନ୍‌ ନିଜେ ଜାରାର୍‌ତାଂ ରାଜା ଲାଗେ ବିଚାର୍‌ ଆନି କାଜିଂ ପାର୍ତାନା କିତିଲେ ଆନ୍‌ ତାଙ୍ଗ୍‌ ପକ୍‌ନି କାଜିଂ ତିର୍‌ କିତାଙ୍ଗ୍‌ । ");
INSERT INTO peg_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","ନା ମାପ୍ରୁତି ଲାଗେ ତା ବିସ୍ରେ ଲେକିକିନି କାଜିଂ ନାଦାଂ ଇନାକାପା ସତ୍‌ ବିସ୍ରେ ଆକାୟ୍‌ । ଲାଗିଂ ବିଚାର୍‌ କିଜ଼ି ଇନେସ୍‌ ଆନ୍‌ ଲେକିକିନି କାଜିଂ ଇଚୁଟିଂ ପାୟାଦେଂ ଆଡ୍‌ନାଙ୍ଗ୍‌, ହେଦାଂ କାଜିଂ ତାଙ୍ଗ୍‌ ମିବେ, ବେସିନି, ଏ ରାଜା ଆଗ୍ରିପ୍‌ପା, ମି ମୁମ୍‌ଦ ତାତାଂନ୍ନା; ");
INSERT INTO peg_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","ଇନାକିଦେଂକି ବନ୍ଦିତିଂ ପକ୍ତିନି ସମୁତ ତା ବିରୁଦ୍‌ତ ଦାବାକାଂ ଇନ୍‌ୱି କାଜିଂ ନାଙ୍ଗେଙ୍ଗ୍ ମେହାଆୱି ଲାକେ ବୁଜା ଆଦ୍‌ନାତା ।” ");
INSERT INTO peg_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","ହେବେଣ୍ଡାଂ ଆଗ୍ରିପ୍‌ପା ପାଉଲ୍‌ତିଂ ଇଚାନ୍‌, “ନିଙ୍ଗେଙ୍ଗ୍‌ ଜାର୍‌ ପାକ୍ୟାତ କାତା ଇନି କାଜିଂ ହେଲ ହିଆତାତ୍ । ହେ ଏଚେକାଡ଼୍‌ଦ ପାଉଲ୍‌ କେଇ ମେଲାୟ୍‌ କିଜ଼ି ଜାର୍‌ ପାକ୍ୟାତ ଇଞ୍ଜେଙ୍ଗ୍‌ ଲାଗାତାନ୍‌,” ");
INSERT INTO peg_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“ଏ ରାଜା ଆଗ୍ରିପ୍‌ପା, ଜିହୁଦିର୍‌ ନା ବିରୁଦ୍‌ତ ଇମ୍‍ଣି ୱିଜ଼ୁ ଦାବା କିନାରା, ହେ ବିସ୍ରେ ଆନ୍‌ ଜେ ନେଞ୍ଜେଙ୍ଗ୍‌ ନି ଲାଗେ ଜାର୍ତିଙ୍ଗ୍‍ ୱେଚ୍‌ଚେଙ୍ଗ୍‌ ପାବ୍‌ ପାୟାତାଂନା, ଇଦାଂ କାଜିଂ ଆନ୍‌ ଜାର୍‌ତିଂ ୱାରି ବାବି କିନାଙ୍ଗା, ");
INSERT INTO peg_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","ବେସିଆତିସ୍‌ ଇ ଇନାକିଦେଂକି ଜେ, ଏନ୍‌ ଜିହୁଦିର୍‌ ବିତ୍ରେ ଚାଲାତି ସବୁ ରିତିନିତି ଆରି ମାନ୍‌ ବିସ୍ରେ ବେସି ପୁନାୟ୍‌; ଇଦାଂ କାଜିଂ ସାସ୍‌ ଆଜ଼ି ନା କାତା ୱେଞ୍ଜେଙ୍ଗ୍‌ କାଜିଂ ଆନ୍‌ ନିଂ ଗୱାରି କିଦ୍‌ନାଙ୍ଗା । ");
INSERT INTO peg_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","ବେଣ୍ଡ୍‌ୟା କାଡ଼୍‌ତାଂ ଆଗେତାଂ ଜାର୍‌ ଜାତି ବିତ୍ରେ ଆରି ଜିରୁସାଲମ୍‌ତ ନା ଆଚାର୍‌ ଚିନ୍ତା ଜିହୁଦିର୍‌ ୱିଜ଼ାକାର୍‌ ପୁନାର୍‌; ");
INSERT INTO peg_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","ହେୱାର୍‌ ନାଙ୍ଗେଙ୍ଗ୍ ପର୍ତୁମ୍‌ତାଂ ପୁନ୍‌ଞ୍ଜି ମାଚିସ୍‌ ଜଦି ଇଚା କିନାନ୍‌, ୱାଟିଙ୍ଗ୍‌ ସାକି ହିଜ଼ି ଆଡ୍‌ନାର୍‌ ଜେ, ଆନ୍‌ ମା ଦରମ୍‌ନି ସବୁତାଂ ଆଟ୍‌ୱା ମାନ୍‌ ଇସାପ୍ରେ ପାରୁସି ଆଜ଼ି ଜିଜ଼ି ମାଚାଂ ।” ");
INSERT INTO peg_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","ଆରେ, ମା ଆବା ଲାତ୍ରା ଲାଗାଙ୍ଗ୍ ଇସ୍ୱର୍‌ ଇମ୍‌ଣି ପାର୍ମାଣ୍ କିଜ଼ି ମାଚାନ୍‌, ହେ ପାର୍ମାଣ୍‌ନି ବାର୍ସି କାଜିଂ ଆନ୍‌ ବିଚାର୍‌ ଆନି କାଜିଂ ନଙ୍ଗ୍‌ ନିଲ୍‌ତାଂନ୍ନା । ");
INSERT INTO peg_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","ମା ବାର୍ ପାର୍ତାନା ହେ ପାର୍ମାଣ୍‌ନି ପାଡ଼୍‌ ଗାଟାନି ଆହାତ ୱେଡ଼ାନାଣା ର ମାନ୍ତ ଇସ୍ୱର୍‌ତି ପାର୍ତାନା କିନାରା । ଏ ରାଜା, ବାର୍ସି କାଜିଂ ଆନ୍‌ ଜିହୁଦିର୍‌ତି ହୁଦାଂ ଦାବା ଆନାଙ୍ଗା । ");
INSERT INTO peg_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","ଇସ୍ୱର୍‌ ଜେ ହାତାକାରିଙ୍ଗ୍‌ ନିକ୍‌ତାନ୍ନା, ହେଦାଂ ଇନାକିଦେଂ ଏପେଙ୍ଗ୍‌ ବିଚାର୍‌ତ ପାର୍ତିକିୱାକାଦେର୍‌ ଇଞ୍ଜି ବୁଜା ଆନାତା ? ");
INSERT INTO peg_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","“ନାଜରିତିୟ ଜିସୁତି ତର୍‌ ବିରୁଦ୍‌ତ ନାଦାଂ ଆଦିକ୍‌ କାମାୟ୍‌ ଜେ ମାନାତ୍‌, ଇଦାଂ ଆନ୍‌ ନିଜେ ବାବି କିଜ଼ି ମାଚାଙ୍ଗ୍ । ");
INSERT INTO peg_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","ଆରେ, ଜିରୁସାଲମ୍‌ତ ଆନ୍‌ ଇଦାଂ ପା କିଜ଼ି ମାଚାଙ୍ଗ୍, ମୁଡ଼୍‌ ମାପ୍ରୁହେବାକିନାକାନ୍‌ ତାରେନ୍‌ ଆଦିକାର୍‌ ପାୟା ଆଜ଼ି ପୁଇପୁୟାର୍‌ ବିତ୍ରେ ଆଦେକ୍‌ତିଂ ଜଇଲ୍‌ତ ଗେସ୍‌ସି କିଜ଼ି ମାଚାଙ୍ଗ୍, ଆରେ, ହେୱାର୍‌ତି ପାରାଣ୍‌ ଦାଣ୍ଡ୍‌ ସମୁତ ଆନ୍‌ ପା ହେୱାର୍‌ତି ବିରୁଦ୍‌ତ ନା ମାନ୍‌ ପାକ୍ୟାତାଂ ହିଜ଼ି ମାଚାଙ୍ଗ୍, ");
INSERT INTO peg_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","ଆରେ ୱିଜ଼ୁ କୁଟୁମ୍‌ ଇଞ୍ଜ ରଗତିଂ ରଗ ହେୱାରିଂ ଡାଣ୍ଡ୍‌ ହିଜ଼ି ଜିସୁତିଂ ନିନ୍ଦା କିନି କାଜିଂ ହେୱାରିଂ ବଲତ୍କାର୍ କିଜ଼ି ମାଚାଙ୍ଗ୍, ଆରେ ହେୱାର୍‌ତି ବିରୁଦ୍‌ତ ବେସି ବାଡା ଆଜ଼ି ବିଦେସ୍‌ନି ଗାଡ଼୍‍କୁ ପାତେକ୍‌ ପା ହେୱାରିଂ ନିନ୍ଦା କିଜ଼ି ମାଚାଙ୍ଗ୍ ।” ");
INSERT INTO peg_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","“ଇ ଇସାପ୍‌ରେ ମୁଡ଼୍‌ ମାପ୍ରୁହେବାକିନାକାନ୍‌ ତାରେନ୍‌ ଆଦିକାର୍‌ ଆରି ବଲ୍‌ ଆକି ଅଜ଼ି ଦମ୍ମେସକ୍‌ତ ହାନି ସମୁତ, ");
INSERT INTO peg_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","ଏ ଏଗ୍ରିପା ରାଜା, ମୁଣ୍ଡାମେଦାନ୍‌ କାଡ଼୍‌ଦ ହାଜ଼ି ବିତ୍ରେ ଆକାସ୍‌ତାଂ ଆଦିକ୍‌ ଡ଼ିଞ୍ଜ୍‌ନାକା ଅଜଡ଼୍‌ ଆରି ନା ଉପ୍‌କାର୍‌ ନିକାରିରିଂ ଚାରିବେଣ୍‌ତାଂ ଚଞ୍ଜ୍ୟାନାକା ହୁଡ଼୍‌ତାଂ । "