﻿USE sofia;
DROP TABLE IF EXISTS sofia.pdo_vpl;
CREATE TABLE pdo_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES pdo_vpl WRITE;
INSERT INTO pdo_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Teopilu henu takau pinelangkai, Orao mia henuto mperokuhi meꞌukiꞌo lele kumonoo henu umarito tegagi ai olondo. ");
INSERT INTO pdo_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Romeꞌukiꞌo lele menggena henu romerongoio umbu ai orao mia henu sumueꞌo lowono henu tegagi umbu ai pamulaꞌano, karoꞌamba paleleꞌo ka pauꞌakito. ");
INSERT INTO pdo_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Gagi kupesuꞌuio wusuꞌo lowono umbu ai pamulaꞌano kanoꞌamba kuputuio umukiꞌo lowono nie gagi lele henu teꞌatora moiko tiamiu. ");
INSERT INTO pdo_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Kupowowau menggena unie kau toꞌorio motae mbio henu pinaguruꞌako ndi ikomiuka suꞌu mentee. ");
INSERT INTO pdo_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Tempono i Datu Herode gagi datu ai wute Yudea, nio aso mia Petewawo Pesomba ai Sakaria neeno, umbu ai tobuno i Abia, neeno somborino i Elisabe, umono mboꞌu inuleno i Haruni. ");
INSERT INTO pdo_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Tinuwuro sombori nie mentee ai aroRo Ue Ala. Oruo irono mpihe montonda parenta ka songkaRo Ue ka lalau winowauro henu lano mentee. ");
INSERT INTO pdo_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Kanggo lalau anaro akono i Elisabe biita ka iroto mosuꞌo. ");
INSERT INTO pdo_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Ai aso olo, hawe tempono tobuno i Abia moꞌangga ai Raha Mempori, i Sakaria palakuꞌo anggaꞌano mompowea pesomba ai aroRo Ue Ala. ");
INSERT INTO pdo_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Montonda loterei, henu mondee romewowauo Petewawo Pesomba, i Sakaria tiniso mendamo mosunu dupa ai Bolongko Mempori ai laro Raha Mempori. ");
INSERT INTO pdo_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Tekonaino i Sakaria mosunu dupa ai laro Bolongko Mempori, mia orao mpekakai ai arono Raha Mempori. ");
INSERT INTO pdo_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Tempo laꞌa malaꞌekaRo Ue Ala mesabahako ndi Sakaria. Malaꞌeka laꞌa menggoti ai koana posunua dupa. ");
INSERT INTO pdo_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Tempono i Sakaria sumueꞌo malaꞌeka laꞌa, kano tekangga ka momee. ");
INSERT INTO pdo_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Kanggo nopotae malaꞌeka, “Indo momee, Sakaria! Ue Ala rumongoio kakaimu. Somborimu i Elisabe minggi meꞌanaꞌakeo aso ana ntama. Aineengakeokaa i Yohane. ");
INSERT INTO pdo_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ikomiu olo mangaꞌu ka manangai ka orao mia minggi memangaꞌu tempono ana laꞌa pineꞌanaꞌako! ");
INSERT INTO pdo_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Akono umono minggi gagi mia langkai ai aroRo Ue Ala ka indono poꞌinu anggoro ka inunga mesueno henu mompokomolangu. Umono minggi buke ako Penao Mempori umbu ai laro kompono ineno. ");
INSERT INTO pdo_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Umono olo mowawo orao mia Isaraeli mepokule mororongoi ndi Ue, Ue Alaro. ");
INSERT INTO pdo_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Umono minggi pasadiaꞌo bawaaRo i Ue ambono i Ue hawe ai laro tolino nie. Penao Mempori minggi moweeꞌakeo pabawa kano poli moꞌangga menggena nabi Elia. Umbu mbio henu inanggano, mia mosuꞌo olo mehohawaꞌo euno ana-anaro. Ka umono minggi waweiro mia henu lano mpororongoi gagi mpororongoi euno ndi Ue. Ka pompewowoloro gagi lalompande euno. Gagi umboro mebehe tuwu mentee.” ");
INSERT INTO pdo_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Kanoꞌamba i Sakaria mesikeno ndi malaꞌeka laꞌa, “Helinde kaku toꞌorio motae pinau miu sie olo gagi? Akono iaku ka somboringgu oto mosuꞌo.” ");
INSERT INTO pdo_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Sumangki i malaꞌeka, “Iaku nie i Gabaraeli. Iaku ataRo Ue Ala kaa iaku tinena hawe paleleꞌo kareba henu moiko tiamu. ");
INSERT INTO pdo_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Menteꞌano, mbio henu kupauꞌakomu nie olo tegagi bano haweto tempono. Kanggo akono lau peꞌale-aleo pinaunggu, lau bisa mepau, hawe kano tegagi henu kupauꞌo nie.” ");
INSERT INTO pdo_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Tempo sie, mia orao meꞌeꞌemango i Sakaria bano peluarako. Mia orao mengkohali-hali akombio kano epie ngako umono ai laro Bolongko Mempori. ");
INSERT INTO pdo_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Tempono meluarako, andono bisa mepau ndi umboro. Butukaa megambara ako kaeno kaa kolekono lano bisa mepau. Pokotombaꞌano romentoꞌorio mia orao motae Ue Ala umari mokokiteoakeo aso kegagia ai laro Bolongko Mempori. ");
INSERT INTO pdo_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Towono umari anggaꞌano ai Raha Mempori, i Sakaria mekule ai rahano. ");
INSERT INTO pdo_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Lanolaa epie, i Elisabe somborino momeni, ka umono meꞌuko ai laro raha olimo wule epieno. ");
INSERT INTO pdo_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Nopotae i Elisabe, “Pokotombaꞌano Ue Ala tumulungiaku ka umoninio kokohenunggu.” ");
INSERT INTO pdo_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Tempono i Elisabe tekonai momeni onoo wuleno, Ue Ala tumenaꞌo malaꞌeka Gabaraeli lumeko ai inie Nasare ai Galilea. ");
INSERT INTO pdo_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Ue Ala tumenaꞌo malaꞌeka Gabaraeli lumeko ndi Maria moluale henu taipo huru meꞌaso poturi saru tama. I Maria sie oto mesambora ka aso tama meneengako i Yusupu umbu inuleno i Daudi. ");
INSERT INTO pdo_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Malaꞌeka laꞌa hawe ndi Maria nopotae, “Tabea, iko henu nopehohawako i Ue, Ue Ala rumoronganiko.” ");
INSERT INTO pdo_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Rumongoio pau sie, i Maria tekangga kano kosike-sikeno ai laro aroano mbio pengkonoano tabea laꞌa. ");
INSERT INTO pdo_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Nopotae malaꞌeka ndi Maria, “Indo momee Maria, ako iiko takau Ropehohawaꞌo Ue Ala. ");
INSERT INTO pdo_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Menteꞌano iko minggi momeni kaa meꞌanaꞌakeo aso ana ntama kaa neengakeo i Yesu. ");
INSERT INTO pdo_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","I Yesu minggi gagi maramba kaa minggi ninee AnaRo Ue Ala Henu Laloako Pabawa. Ue Ala mokogagiꞌo i Yesu datu menggena datu Daudi, ue mpuꞌuNo, ");
INSERT INTO pdo_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","kaa Umono minggi gagi datu henu parentaꞌo inuleno i Yako henu lalau tampulaꞌano kaa pomparentaꞌaNo lano huru tampula.” ");
INSERT INTO pdo_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Nopotae i Maria ndi malaꞌeka laꞌa, “Helinde kano masa gagi akono amboku pesombori?” ");
INSERT INTO pdo_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Sumangki i malaꞌeka, “Penao Mempori minggi metii ndi iko, kaa pabawaRo Ue Ala Henu Laloako Pabawa olo rumoronganiko. Ooto usie iiko minggi meꞌanaꞌakeo ana henu mempori, ninee anaRo Ue Ala. ");
INSERT INTO pdo_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Kupauꞌakomu motae i Elisabe petiamu henu rompotae biita kaa ooto mosuꞌo laꞌa, oto momeni aso ana ntama kaa unie wule koꞌonoono. ");
INSERT INTO pdo_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Ako ndi Ue Ala lalau henu tai gagi.” ");
INSERT INTO pdo_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Nopotae i Maria, “Menteꞌano iaku nie ataRo Ue Ala, nogagito menggena nineemu sie.” Umari laꞌa malaꞌeka lumeko bintango ai Maria. ");
INSERT INTO pdo_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Towono lumeko malaꞌeka laꞌa, lumekoto i Maria ai inie langkai ai wute tamungku Yudea. ");
INSERT INTO pdo_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Tempono hawe lehea, i Maria lumeko ai rahano i Sakaria, ka pendamono, i Maria metabea ndi Elisabe. ");
INSERT INTO pdo_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Tempono i Elisabe rumongoio petabeano i Maria, ana henu ai laro kompono i Elisabe meleluako mangaꞌu. Kaa i Elisabe nororonganio Penao Mempori, ");
INSERT INTO pdo_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","kano kumora, “Ikoto mia binarakati ai olono lowono irowai! Nobarakatiꞌo ana henu minggi pineꞌanaꞌakomu laꞌa! ");
INSERT INTO pdo_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Ainei iaku nie kano ineNo Uenggu hawe ndi iaku? ");
INSERT INTO pdo_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Menteꞌano tempono kurongoio petabeamu laꞌa, ana henu ai laro komponggu meleluako mangaꞌu. ");
INSERT INTO pdo_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Meꞌurakoto akono pompeꞌalo-alo motae mbio henu pinauRo Ue Ala ndi iiko olo gagi!” ");
INSERT INTO pdo_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Kanoꞌamba nopotae i Maria, “Aroanggu umundeꞌiRo i Ue, ");
INSERT INTO pdo_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","ka sumanganggu mangaꞌu akono Ue Ala tumolosiaku. ");
INSERT INTO pdo_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Noꞌoꞌaroanganggu maupono iaku nie ataRo henu tetotoako! Perorongoi! Mompamula hilinie lowono mia motae iaku mangaꞌu. ");
INSERT INTO pdo_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Akono Ue Ala Henu Laloako Pabawa mowowau kegagia langkai ndi iaku. Mempori neeRo. ");
INSERT INTO pdo_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Ai sombo-sombo amapano tempo Ue Ala konggo mompehohawa lowono inuleno mia henu momee ka melangkai iRo. ");
INSERT INTO pdo_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ako kaeRo henu takau moroso Rosia-siaꞌo mia mompelangka-langkai ");
INSERT INTO pdo_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Datu-datu Ropenaohakeo umbu ai potorono kaa mia karampini inengka gagi mia henu pinelangkai. ");
INSERT INTO pdo_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Mia mokoninggo olo pinoko mowoto ako moikoꞌa. Mia suugi tinamba ai laro kae molie. ");
INSERT INTO pdo_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Rotulungiro to Isaraeli ataRo, akono laRo kumulupeo ginantiRo mehohawakito, ");
INSERT INTO pdo_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","ka Ue Ala lano huru kulupeo mbio henu ginantiRo ndi ue mpuꞌundo, Ropehohawaꞌo ai Burahima ka inuleno hawe lalau tampulaꞌano.” ");
INSERT INTO pdo_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Ai Maria moꞌia i rahano i Elisabe, baraꞌura otolu wule epieno, kanoꞌamba mekule ai rahano i Nasare. ");
INSERT INTO pdo_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Haweto wuleno i Elisabe meꞌana. Nopeꞌanaꞌakeo aso ana ntama. ");
INSERT INTO pdo_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Towono petengi-tengi rahano kaa petiano rumongoio motae i Elisabe takau Ropehohawaꞌo Ue Ala, umboro memangaꞌu mperongangakeo. ");
INSERT INTO pdo_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Tempono rewu-rewu laꞌa tinuwuno oalu olo, umboro mehawe minggi mengkiteo rewu-rewu laꞌa tinindi. Kaa minggi menengakeo i Sakaria menggena neeno umano, ");
INSERT INTO pdo_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","kanggo ineno motae, “Indo! Umono olo nineengako i Yohane.” ");
INSERT INTO pdo_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Rompotae, “Lalau umbu ai petiamiu nie henu meneengako i Yohane.” ");
INSERT INTO pdo_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ka umboro megambara ako kaero mpesikeno ndi Sakaria ainei neeno rewu-rewu sie. ");
INSERT INTO pdo_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","I Sakaria moꞌema wasu poꞌukiꞌa kano ukiꞌo, “Neeno i Yohane.” Lowono mia mengkohali-hali. ");
INSERT INTO pdo_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Tempo laꞌa bingkosako telipa pongu elono i Sakaria kano pepau ka moꞌunde ndi Ue Ala. ");
INSERT INTO pdo_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Memomeeto petengi-tengi rahano kaa kareba laꞌa telele hawe ai lowono tamungku ai Yudea. ");
INSERT INTO pdo_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Lowono mia henu rumongoio kegagia laꞌa kosike-sikeno ai laro aroaro, “Gagi mbio soongka rewu-rewu laꞌa!” Akono Ue Ala rumoronganio. ");
INSERT INTO pdo_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","I Sakaria, umano i Yohane, nororonganio Penao Mempori kano pompohawe pau umbu ndi Umboro Ue Ala. Nopotae, ");
INSERT INTO pdo_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Memaito kato unde-undeꞌiRo i Ue, Alaro to Isaraeli! Umboro oto hawe mosakoi bawaaRo ka mokolipahiro. ");
INSERT INTO pdo_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Ue Ala moweeꞌakito pongkadudui henu takau moroso, umbu ai inuleno i Daudi ataRo. ");
INSERT INTO pdo_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Tempo isaꞌa telalo umbu ndi umboro nabi-nabi bininikiRo, Oto Roweeꞌakito i Ue ginantiRo. ");
INSERT INTO pdo_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Olo Ropokolipakito umbu ai uwelindo kaa umbu ai pabawaro mia henu memokokatongakito. ");
INSERT INTO pdo_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Ka Nopokoꞌenaho pompehohawaRo tiano ue mpuꞌundo, ginantiRo henu mempori laꞌa olo Ropokosangkaꞌo. ");
INSERT INTO pdo_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Ue Ala metando ndi Burahima umando. ");
INSERT INTO pdo_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Ka meganti minggi kumaduduikito umbu ai uwelindo, gagi andoto lei memomee tumondaꞌiRo Ue Ala. ");
INSERT INTO pdo_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Bano menggena usie ikito mentuwu mempori ka mentee i aroRo tempono ikito da mentuwu. ");
INSERT INTO pdo_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Kaa kumonoo iiko, ananggu, iiko minggi ninee nabiRo Ue Ala Henu Laloako Pabawa. Ka iiko olo tinena seꞌelu pasadiaꞌo sala haweꞌaRo i Ue. ");
INSERT INTO pdo_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Iiko olo paleleꞌo ndi bawaa kato mempoli kinadudui, bano i Ue tumolosio halaro. ");
INSERT INTO pdo_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Moiko aroaRo Ue Alando mehohawakito. Umono hawe kumaduduikito. Menggena mataꞌolo henu saba eri-erio, ");
INSERT INTO pdo_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Hilaꞌato nopompowea wantaRo tiano mia henu tuwu ai laro wongi-wongiꞌa ka momeeꞌa. Ue Ala wawokito ai sala manangaiꞌa.” ");
INSERT INTO pdo_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Anano i Sakaria laꞌa kolangka-langkai ka tetambai moroso pompeꞌalo-alono. Umono moꞌia ai konde one, hawe tempono mokoꞌenaho koroino ndi to Isaraeli. ");
INSERT INTO pdo_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Tempo laꞌa i Datu Langkai Agutusi tumenaꞌo lowono mia henu moꞌia ai Roma mepeꞌuki nee karo dinoa. ");
INSERT INTO pdo_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Ooto unie podoaꞌa mia henu amba-ambano kaa tempo sie i Kireniu io gubenuru ai Siria. ");
INSERT INTO pdo_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Tempo sie lowono mia lumeko mepeꞌuki neeno ai inie ue mpuꞌuro. ");
INSERT INTO pdo_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","I Yusupu mboꞌu mewunggoako umbu ai inie Nasare ai Galilea lumeko ai inie Beteleme wute Yudea inie nioꞌano i datu Daudi, akono i Yusupu inuleno i Datu Daudi. ");
INSERT INTO pdo_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","I Yusupu mepeꞌuki nee meronga i Maria samborano henu tekonai momeni. ");
INSERT INTO pdo_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Tekonairo ai Beteleme, hawe tempono i Maria meꞌana. ");
INSERT INTO pdo_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","I Maria meꞌanaꞌakeo aso ana ntama, henu amba-ambano. Notongoho rewu-rewu sie ako aso mpole bana, kanoꞌamba mokoturio ai laro dula bimba meꞌihi range, akono ando lalau poꞌianga ai raha peratoꞌa ");
INSERT INTO pdo_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ai wongi laꞌa nio pompakambi tekonai mogagai bimba ai tonga konde. ");
INSERT INTO pdo_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Bingkosako malaꞌeka mesabahako ndi umboro, karo memomee ako nio wanta umbu ndi Ue henu wantahiiro. ");
INSERT INTO pdo_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Nopotae malaꞌeka, “Indo momee! Ako iaku mowawo kareba moiko tiamiu, ooto kareba mangaꞌua tiano lowono mia. ");
INSERT INTO pdo_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Olo nie ai Beteleme oto pineꞌanaꞌako Datu Pongkadudui ooto i Kerisitu, Ue. ");
INSERT INTO pdo_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Tinieto tondonino, ikomiu minggi mehaweꞌo io rewu-rewu hinawu ako tahu beri kaa pinolero ai dula bimba meꞌihi range.” ");
INSERT INTO pdo_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Bingkosako malaꞌeka laꞌa meronga orao malaꞌeka mesueno umundeꞌiRo Ue Ala, karompotae, ");
INSERT INTO pdo_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Maramba Ue Ala henu ai wawo langi! Kaa roodo ndi mia tolino henu mokomangaꞌuo i Ue!” ");
INSERT INTO pdo_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Towono malaꞌeka mpekule ai suruga, ropotae pompakambi laꞌa aso mia kaa aso mia, “Maito kato kiteo mbio henu gagi ai Beteleme menggena pinauRo i Ue ndi ikito.” ");
INSERT INTO pdo_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Pompari-pari umboro meleko karo mehaweꞌo i Maria kaa i Yusupu saru rewu-rewu laꞌa henu tekonai pinolero ai laro dula bimba. ");
INSERT INTO pdo_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Towono pompakambi mesueꞌo rewu-rewu laꞌa, romempauꞌo mbio pauno malaꞌeka mongkono rewu-rewu laꞌa. ");
INSERT INTO pdo_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Kaa lowono mia mengkohali-hali rumongoio pauro pompakambi laꞌa. ");
INSERT INTO pdo_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Kanggo ai Maria numaaꞌo ai laro aroano kano penonohoꞌo. ");
INSERT INTO pdo_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Pompakambi laꞌira mpekule ai konde kaa ai laro koleko-lekoaro, romeꞌunde-undeꞌiRo Ue Ala rompotae, “Maramba Ue Ala” akono lowono henu romerongoio kaa kinitoro, gagi menggena pauro malaꞌeka. ");
INSERT INTO pdo_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Towono sangka oalu olo tinuwuno, rewu-rewu laꞌa tinindi ka pinowea nee i Yesu, nee pinauro malaꞌeka ambono nomomeniꞌakeo ineno. ");
INSERT INTO pdo_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Hawe tempono i Yusupu ka ai Maria mowowau hada powohoki koroi umarino meꞌana montonda songkaro i Musa. Gagi romewaweo mboꞌu rewu-rewu laꞌa meleko ai Yerusale meweangakeo ndi Ue Ala. ");
INSERT INTO pdo_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Ako nio teꞌuki ai songkaRo i Ue, “Lowono ana ntama henu amba-ambano olo pineweangako ndi Ue Ala.” ");
INSERT INTO pdo_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Ka umboro mboꞌu mowawo pesomba ooto aso ntimba kou-kou ba oruo anano marapati, menggena henu teꞌuki ai songkaRo i Ue. ");
INSERT INTO pdo_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Tempo laꞌa ai Yerusale nio aso mia neeno i Simeo, umono mentee tuwuno ka metenunu ndi Ue Ala, ka meteꞌema tempono Ue Ala kumaduduio Isaraeli. Umono nororonganio Penao Mempori. ");
INSERT INTO pdo_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Ka oto nopauꞌakeo Penao Mempori ndi umono lanolei maate bano taipo nosueꞌo Datu Pongkadudui henu ginantiRo Ue Ala. ");
INSERT INTO pdo_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Penao Mempori waweo ai Simeo mendamo ai Raha Mempori. Tempo laꞌa i Yusupu kaa i Maria mewaweo i Yesu mendamo ai Raha Mempori minggi meweangakeo anaro ndi Ue Ala montonda Songkaro i Musa. ");
INSERT INTO pdo_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Kano aleo i Simeo rewu-rewu laꞌa nopapasio kaa moꞌunde ndi Ue Ala, nopotae, ");
INSERT INTO pdo_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Hilinie Ue, aroanoto ataMiu nie maate momoiko, akono oto pokosangkaꞌo gantiMiu. ");
INSERT INTO pdo_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Akono kusueꞌoto ako matanggu Mpupongkadudui umbu ndi Ikomiu, ");
INSERT INTO pdo_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","henuto Ikomiu palenaꞌo tiano lowono tongku. ");
INSERT INTO pdo_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Mpupongkadudui laꞌa menggena wanta henu wantahio sala tiano tongku henu mesue mehawe ndi aroMiu, wanta laꞌa minggi mokogagiꞌo to Isaraeli bawaa Miu pinelangkai.” ");
INSERT INTO pdo_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Umano ka ineno rewu-rewu laꞌa kohali-hali rumongoio mbio henu pinauno i Simeo kumonoo anaro. ");
INSERT INTO pdo_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","I Simeo barakatiꞌiro ka motae ndi Maria ineNo, “Rewu-rewu nie ooto bininikiRo Ue Ala, minggi modontai ka mowueꞌako orao mia to Isaraeli. Umono gagi petondongino umbu ndi Ue Ala henu laro tarimaꞌo mia orao. ");
INSERT INTO pdo_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Ako helinie minggi sinue mbio henu nio ai laro aroaro. Kaa iiko Maria, minggi masusa ngako aroamu menggena kono sale ponai.” ");
INSERT INTO pdo_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Nio mboꞌu aso nabi irowai henuto mosuꞌo neeno i Hana, anano Panueli, inuleno i Asere. Butukaa opitu ntaꞌu nopebawaaꞌakeo somborino, ");
INSERT INTO pdo_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","akono somborino oto maate. Kaa umono andono mesombori mboꞌu ka hilinie tinuwuno ooto halopulu ka opaa ntaꞌu. Sombo meene ka sombo wongi umono nio ai Raha Mempori, mekakai saru mepuasa, mesomba ndi Ue Ala. ");
INSERT INTO pdo_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Tempono i Yusupu ka i Maria tekonai lehea, ai Hana lumeko umbedahiiro kano undeꞌiRo Ue Ala ka nopauꞌo mongkono rewu-rewu laꞌa ndi lowono mia henu umeꞌemango tempono Ue Ala mokolipaho Yerusale. ");
INSERT INTO pdo_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Umarino i Yusupu ka i Maria wowauo hada powohoki koroi kaa meweangakeo anaro ndi Ue montonda songkaRo i Ue, iro mpekule ai Nasare inie poꞌiangaro ai Galilea. ");
INSERT INTO pdo_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Rewu-rewu laꞌa kolangka-langkai ka moroso, umono pande takau ka Nopehohawaꞌo Ue Ala. ");
INSERT INTO pdo_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Sombo-sombo ntaꞌu mia mosuꞌono i Yesu lumeko ai Yerusale montonda perame-rameꞌa Pasa mewowoloꞌo tepokolipaharo to Isaraeli umbu ai wute Masiri. ");
INSERT INTO pdo_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Tempono tinuwuno i Yesu hopulo ka oruo ntaꞌu, umboro meleko mperame-rame menggena mondeeno. ");
INSERT INTO pdo_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Umari mperame-rameꞌa iro mpekule, kanggo i Yesu, Ana-ana laꞌa da moꞌia ai Yerusale, kanggo lano toꞌorio mia mosuꞌoNo. ");
INSERT INTO pdo_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Rokoaraꞌaraa tumondaꞌiro mia orao mperonga-rongaro. Towono aso olo mengkoleko-leko amba romewusuꞌO ai olono petia kaa tepotoꞌoriro. ");
INSERT INTO pdo_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Kanggo laro haweꞌO, gagi umboro mepokule euno ai Yerusale wusuꞌo i Yesu. ");
INSERT INTO pdo_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Towono koꞌotoluno olo rompetewusu amba rohaweꞌO ai Raha Mempori, i Yesu tekonai mentoro rumongoio pauro Guru Agama ka mesikeno ndi umboro. ");
INSERT INTO pdo_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Lowono mia lehea mengkohali-hali rumongoio pandeNo i Yesu sumangkiꞌo pesikenoro Guru Agama. ");
INSERT INTO pdo_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Mia mosuꞌoNo mboꞌu kohali-hali kumiteo. Nopotae ineno, “Ana, mbiokee kau powowau menggena unie ndi ikami? UmaMu ka iaku masusa aroa mami mewusuKo.” ");
INSERT INTO pdo_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Sumangki i Yesu, “Mombiokee ikomiu wusu Aku? Lai toꞌoriokee Iaku matantu nio ai rahaRo UmaNggu?” ");
INSERT INTO pdo_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Kanggo laro toꞌorio mbio henu nineeno i Yesu. ");
INSERT INTO pdo_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Umari laꞌa i Yesu kaa mia mosuꞌoNo mpekule ai Nasare, kaa Umono mpihe mororongoi ndi mia mosuꞌoNo. Lowono henu tegagi nie nonaaꞌo ineNo ai laro aroano. ");
INSERT INTO pdo_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","I Yesu kolangka-langkai ka pande saru nopehohawaꞌiRo Ue Ala ka romemangaꞌuꞌakeo mia. ");
INSERT INTO pdo_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Ai taꞌu hopulo ka olimo tendamo pomparentano i Datu Langkai Tiberiu, tempono i Gubenuru Pontiu Pilatu gagi kapala daera ai Yudea, i Datu Herode momparenta ai wute Galilea. I Pilipu petiano i Datu Herode momparenta ai wute Iturea ka Tarakoniti, ka i Lisania momparenta ai Abilene. ");
INSERT INTO pdo_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Henu gagi Petewawo Pesomba Langkai ooto i Hanasi ka i Kayapa. Ai taꞌu laꞌa Ue Ala mepau ndi Yohane anano i Sakaria ai konde one. ");
INSERT INTO pdo_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Lumeko i Yohane tumondaꞌo wute wiwi korono Yarade ka pauꞌo oliwiRo Ue Ala. I Yohane kokora-kora, “Mentesisito umbu ai winowaumiu henu mosaꞌa ka peweangakeoto koroimiu dinolo, ka Ue Ala minggi umoninio halamiu.” ");
INSERT INTO pdo_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Mbio henu winowauno i Yohane menggena henu teꞌuki ai surano nabi Yesaya, “Nio mia kokora-kora ai konde one, Palenaꞌoto sala tiaRo i Ue, pokomomoliꞌo sala tiaRo. ");
INSERT INTO pdo_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Lowono bangkano minggi hinowui, lowono tamungku ka mungku pinoko melembo. Sala henu monggedo-nggedo pinokomomoli, ka sala henu mebingkoso hinowui. ");
INSERT INTO pdo_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Lowono mia aso wawontolino minggi sumueꞌo Mpupongkadudui umbu ndi Ue Ala!” ");
INSERT INTO pdo_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Orao mia hawe moꞌema karo dinolo. I Yohane mepauꞌakero, “Ikomiu mia henu mosaꞌa gaumiu menggena ule meꞌeto! Ainei motae ikomiu telipahako umbu podosaRo Ue Ala henu amba ramai? ");
INSERT INTO pdo_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Pokoꞌenaho ai laro tinuwumiu bano ikomiuto tesisi umbu winowaumiu henu mosaꞌa. Indo koaraꞌaraa, ikomiu lano dinosa akono ikomiu inuleno i Burahima. Pewowoloꞌo, umbu ai wasu-wasu nie Ue Ala poli mowowau mia gagi inuleno tiano i Burahima. ");
INSERT INTO pdo_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","PodosaRo Ue Ala menggena ndamu henuto tepalena minggi pontuehi kau hawe ai haka-hakano. Lowono kau henu lano moiko wueno minggi tinuehi ka sinunu.” ");
INSERT INTO pdo_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Mia orao mpesikeno ndi Yohane, “Gagi mbiokee kimpowowau?” ");
INSERT INTO pdo_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Sumangki i Yohane, “Mia mompeꞌue oruo kalambino, weeꞌakeo aso mia henu tainio kalambi, ka mia henu orao kaangano tia-tiaꞌo ndi mia henu tainio kaangano.” ");
INSERT INTO pdo_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Toposima mboꞌu hawe ndi Yohane moꞌema dinolo, rompesikeno “Guru, mbiokee kimpowowau?” ");
INSERT INTO pdo_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Sumangki i Yohane, “Indo poꞌema torea umbu henu pinatantu.” ");
INSERT INTO pdo_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Nio mboꞌu sorodadu mesikeno, “Helinde menggena ikami? Mbio henu kiwowauo?” Sumangki i Yohane, “Indo rukuhio baineitokaa, indo porukuhi ako pau lano mentee. Sangka oto umbu ai gadimu!” ");
INSERT INTO pdo_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Tempo laꞌa orao mia momperorohi kaa kosike-sikeno menteekee i Yohane Datu Pongkadudui henu romeꞌeꞌemango. ");
INSERT INTO pdo_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Oto kano potae i Yohane ndi umboro, “Iaku dumolo komiu ako uwoi, kanggo minggi hawe mia henu takau langkai pabawaNo kaseko iaku. Sekonopo mowowo onggono sipatuNo mboꞌu iaku lano koono. Umono minggi dumolo komiu ako Penao Mempori ka apui. ");
INSERT INTO pdo_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ai kaeNo nio duku minggi dumukuꞌo pae hawe moroa. Pae henuto moroa minggi nonaaꞌo ai tuꞌora, kanggo ota olo sinunu ai apui henu lano huru maate!” ");
INSERT INTO pdo_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","I Yohane mompowea orao oliwi mesueno, kaa paleleꞌo Kareba Moiko ndi mia orao. ");
INSERT INTO pdo_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","I Yohane tumeguruꞌo i Datu Herode akono norampasio i Herodia somborino petiano ka mboꞌu akono mowowau gau mosaꞌa henu mesue. ");
INSERT INTO pdo_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Kanggo i Datu Herode notambaio mboꞌu halano, nopondamoho i Yohane ai laro tarungku. ");
INSERT INTO pdo_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Masano lowono mia siire umari medinolo, i Yesu mboꞌu hawe kano dinolo. Ka tekonaiNo mekakai langi tewungge, ");
INSERT INTO pdo_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","ka Penao Mempori metii ai wawoNo menggena manu-manu marapati. Ka terongoi pauRo Ue Ala motae, “Ikoto AnaNggu henu Kupehohawaꞌo. Ikoto henu mokomangaꞌuo aroaNggu.” ");
INSERT INTO pdo_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Tempono i Yesu pamulaꞌo anggaꞌano, baraꞌura tolupulu ntaꞌuno. Motonda pohawero mia, Umono anano i Yusupu. Yusupu anano i Eli, ");
INSERT INTO pdo_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","anano i Matati, anano i Lewi, anano i Malaki, anano i Yanai, anano i Yusupu, ");
INSERT INTO pdo_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","anano i Matika, anano i Amosi, anano i Nahumi, anano i Heseli, anano i Nagai, ");
INSERT INTO pdo_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","anano i Maati, anano i Matika, anano i Simei, anano i Yoseki, anano i Yoda, ");
INSERT INTO pdo_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","anano i Yohana, anano i Resa, anano i Serubabe, anano i Sealitie, anano i Neri, ");
INSERT INTO pdo_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","anano i Malaki, anano i Adi, anano i Kosami, anano i Elimada, anano i Ere, ");
INSERT INTO pdo_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","anano i Yesua, anano i Eliese, anano i Yorimi, anano i Matati, anano i Lewi, ");
INSERT INTO pdo_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","anano i Simeo, anano i Yahuda, anano i Yusupu, anano i Yonami, anano i Eliaki, ");
INSERT INTO pdo_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","anano i Melea, anano i Mina, anano i Matata, anano i Nata, anano i Daudi, ");
INSERT INTO pdo_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","anano i Isai, anano i Obe, anano i Boasi, anano i Salamo, anano i Nahaso, ");
INSERT INTO pdo_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","anano i Abinada, anano i Adimini, anano i Arini, anano i Heseroni, anano i Peresi, anano i Yahuda, ");
INSERT INTO pdo_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","anano i Yako, anano i Isaki, anano i Burahima, anano i Tera, anano i Nahori, ");
INSERT INTO pdo_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","anano i Serugi, anano i Rehu, anano i Pelegi, anano i Ebere, anano i Salamo, ");
INSERT INTO pdo_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","anano i Kenani, anano i Arapasa, anano i Semu, anano i Noha, anano i Lameki, ");
INSERT INTO pdo_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","anano i Metusala, anano i Heno, anano i Yaredi, anano i Mahaleli, anano i Kenani, ");
INSERT INTO pdo_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","anano i Enosi, anano i Seti, anano i Adama, anaRo Ue Ala. ");
INSERT INTO pdo_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","I Yesu buke ako Penao Mempori pekuleNo umbu ai korono Yarade. Penao Mempori waweꞌiRo leko ai konde one. ");
INSERT INTO pdo_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Patopulu olo epieno Nopoꞌia ai konde one, lehea i Yesu noꞌaraꞌarahakeo Ueno onisu. Aso tempo laꞌa i Yesu lano huru monggaa mbio-mbio, ooto kaNo mokoninggo. ");
INSERT INTO pdo_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Kano potae Ueno onisu ndi Yesu, “Iiko anaRo Ue Ala, tenaꞌoto wasu nie kano gagi roti.” ");
INSERT INTO pdo_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Nopotae i Yesu, “Nio ai laro Sura Tutulu, mia tuwu lano butu umbu ai roti.” ");
INSERT INTO pdo_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Umari laꞌa Ueno onisu waweo i Yesu ai poꞌianga henu medongke, butu aso pebiroꞌakaa nopokokiteoꞌakeo pomparentaꞌa ai wawontolino. ");
INSERT INTO pdo_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Nopotae Ueno Onisu ndi Yesu, “Lowono pabawa kaa sugiꞌa minggi kuweeꞌakoMu, akono lowono nie akuto wineaꞌako kaa iaku minggi meweangakeo ndi baineitokaa henu inehenggu. ");
INSERT INTO pdo_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Bau penggolutu mesomba ndi iaku, lowono sie minggi gagi tiaMu.” ");
INSERT INTO pdo_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Nopotae i Yesu, “Nio ai laro Sura Tutulu, pesombaio Ue Alamu ka butu ndi Umboro au petenunu.” ");
INSERT INTO pdo_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Umari laꞌa Ueno onisu waweo i Yesu ai mumunge Raha Mempori ai Yerusale, kano potae, “Iiko anaRo Ue Ala, pedontaihakoto umbu endea, ");
INSERT INTO pdo_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","akono nio ai laro Sura Tutulu, Ue Ala minggi tumenaꞌo malaꞌekaRo gumagaiKo. ");
INSERT INTO pdo_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Kaa malaꞌeka minggi sumakaKo, kau tai telano ai wasu.” ");
INSERT INTO pdo_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Nopotae i Yesu, “Nio ai laro Sura Tutulu, indo araꞌarahakeo Ue Alamu!” ");
INSERT INTO pdo_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Towono Ueno onisu umari moꞌaraꞌarahakeo i Yesu ako manggerupa sie Ueno onisu bintango i Yesu kaa mowusu tempo henu moiko. ");
INSERT INTO pdo_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Kanoꞌamba i Yesu buke ako pabawaRo Penao Mempori tekonaiNo mekule ai Galilea kaa teleleto kareba mongkono winowauNo ai poꞌianga sie. ");
INSERT INTO pdo_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","I Yesu mompaguru ai lowono Raha Pesombaꞌa kaa lowono mia umundeꞌiRo. ");
INSERT INTO pdo_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","I Yesu hawe ai Nasare, ai inie Nopinokolangkai. Ai olo penao-naoꞌa to Yahudi, menggena mondeeno i Yesu leko ai Raha Pesombaꞌa. I Yesu menggoti minggi mobata Sura Tutulu. ");
INSERT INTO pdo_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Kaa mia henu moꞌangga ai Raha Pesombaꞌa moweeꞌakeO sura henu inukino ai Yesaya. Nowunggeho paluluno sura laꞌa, Nohaweꞌo laino nie kaa Nobataꞌo, ");
INSERT INTO pdo_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“PenaoRo i Ue nio ndi Iaku, Ue Ala rumosongaNggu mowawo Kareba Moiko tiaro mia karampini, Iaku tinena mompalele motae Ue Ala minggi mokolipahiro mia tinarungku, mokomosueꞌiro mia memorawu kaa mokolipahiro mia binobarasa, ");
INSERT INTO pdo_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","kaa Iaku paleleꞌo haweRo i Ue kumaduduio bawaaRo.” ");
INSERT INTO pdo_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","I Yesu palulungo euno Sura Tutulu kano weeꞌo ndi mia henu moꞌangga ai Raha Pesombaꞌa kanoꞌamba mentoro. Lowono mia ai laro Raha Pesombaꞌa mekokoongo mbio pinauno i Yesu. ");
INSERT INTO pdo_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Kaa i Yesu mompamula mepau ndi umboro, “Laino Sura Tutulu henu kubataꞌo hieno oto Kupokosangkaꞌo tempono ikomiu merongoio.” ");
INSERT INTO pdo_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Mbio henu pinauno i Yesu takau moiko ooto karo mokomenteeꞌo pauNo kanggo loꞌoka romentoꞌorio i Yesu nie anano i Yusupu gagi umboro mengkohali-haliꞌakeo. ");
INSERT INTO pdo_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Kanggo i Yesu tumoꞌorio mbio henu rompewowoloꞌo ooto kaNo potae, “Kutoꞌorio ikomiu minggi motae ndi Iaku menggena unie, ‘Datoro pokotombaꞌo koroiMu. Mbio tandangkohali-hali henu kimerongoio umari tegagi ai Kapenau wowauo mboꞌu ai inieMu.’ ” ");
INSERT INTO pdo_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ka Nopotae mboꞌu, “Pewowoloꞌo, lalau nabi tinarima ai inieno.” ");
INSERT INTO pdo_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Kanggo Iaku mompauꞌakomu pau henu mentee, tempono i Elia tuwu, ai lowono wute to Isaraeli tegagi abalaa mokoninggoꞌa akono otolu ntaꞌu kaa entonga lano huru use. Tempo laꞌa orao irowai waalu ai Isaraeli. ");
INSERT INTO pdo_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Ue Ala lano tenaꞌo i Elia lumeko ndi irowai waalu to Isaraeli, kanggo lumeko ndi aso irowai waalu ai Sarapa ai wute Sidoni. ");
INSERT INTO pdo_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Helilaꞌa mboꞌu tempono i nabi Elisa masa orao to Isaraeli memelowe, kanggo lalau napono teꞌaso mia henu pinokotomba sangarino i Naama to Siria. ");
INSERT INTO pdo_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Lowono mia ai laro Raha Pesombaꞌa mentekuda takau rumongoio pauno i Yesu. ");
INSERT INTO pdo_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Karo mpenggoti kaa mentambaꞌo i Yesu meluarako umbu ai inie langkai kanoꞌamba waweꞌO leko ai tamungku mewingke henu umbedano inie langkai laꞌa karo minggi medontaio lehea. ");
INSERT INTO pdo_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Kanggo i Yesu meꞌoloꞌako ai oloro mia orao kano polao. ");
INSERT INTO pdo_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Umbu ai Nasare i Yesu mineꞌi ai inie langkai Kapenau ai wute Galilea kaa ai olo penao-naoꞌa to Yahudi i Yesu mompaguru orao mia ai laro Raha Pesombaꞌa. ");
INSERT INTO pdo_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","I Yesu mompaguru kaa mebitara buke ako pabawa ooto karo mentengiri. ");
INSERT INTO pdo_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ai laro Raha Pesombaꞌa laꞌa nio aso mia nopendamohio penao mosaꞌa kumora mekora ngako, ");
INSERT INTO pdo_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Hei Yesu mia Nasare, minggi mbio kami? Minggi hawe bobarasa kami? Kutoꞌorio Ikomiu henu Mempori umbu ndi Ue Ala.” ");
INSERT INTO pdo_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Kanggo i Yesu rumambasio, Nopotae, “Indo pogero! Peluarakoto umbu ai mia sie!” Penao mosaꞌa mepasiꞌakeo mia laꞌa ai arono mia orao kanoꞌamba meluarako kanggo lano belaio mia laꞌa. ");
INSERT INTO pdo_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Lowono mia henu mesueꞌo mengkohali-hali kaa mengkopau-pau aso mia ka aso mia, “Indokaa iko ako pabawa ka pepauNo, i Yesu parentaꞌo penao mosaꞌa mpeluarako kaa umboro mpeluarako!” ");
INSERT INTO pdo_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Gagi kareba mongkono mbio henu nopowowau ka pinauno i Yesu telele ai lowono inie henu umbeda umbu ai poꞌianga laꞌa. ");
INSERT INTO pdo_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Kanoꞌamba i Yesu bintango Raha Pesombaꞌa kaa meleko ai rahano i Simo. Ineno somborino i Simo tekonai mokokoseo, rompoꞌema ndi Yesu kano tulungio. ");
INSERT INTO pdo_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","I Yesu menggoti ai aso hileno poturiano kano tambaꞌo mokokoseono. Masa toomba hakino ineno somborino i Simo ka mompari-pari mewangu parakaiꞌiro. ");
INSERT INTO pdo_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Towono soo mataꞌolo, lowono mia ai inie langkai laꞌa mehawe mewaweo petiaro henu manggerupa hakiro kano pinokotomba. I Yesu dumanggiho uluro aso mia ka aso mia karo tomba. ");
INSERT INTO pdo_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Penao mosaꞌa mpeluarako mboꞌu umbu ai orao mia karo kokora-kora, “Ikomiu AnaRo Ue Ala!” Kanggo i Yesu rumambasiꞌiro penao mosaꞌa laꞌira karo indoro mpepau, akono romentoꞌorio Umonoto Datu Pongkadudui. ");
INSERT INTO pdo_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Eri-erio i Yesu bintango inie laꞌa lumeko ai poꞌianga henu molimbo. Orao mia mewusuꞌo i Yesu kaa tempono rohaweꞌo, romerokuhio indoNo bintangiro. ");
INSERT INTO pdo_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Kanggo i Yesu motaeꞌakero, “Iaku nie minggi mowawo Kareba Moiko mongkono PomparentaꞌaRo Ue Ala ai inie-inie langkai mesueno, akono usieto Iaku tinena hawe ai tolino nie.” ");
INSERT INTO pdo_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Akono usie i Yesu lumeko montutulu umbu ai aso Raha Pesombaꞌa melimba-limba ai Raha Pesombaꞌa mesueno ai wute Yudea. ");
INSERT INTO pdo_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Ai aso tempo, i Yesu menggoti ai wiwi Towa Genesare. Lehea orao mia mpeburo-buroso minggi merorongoio pauRo Ue Ala. ");
INSERT INTO pdo_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","I Yesu sumueꞌo oruo bangka ai wiwi towa, ueno bangka laꞌira iroto mpetii kaa tekonai mpowohoki jalaro. ");
INSERT INTO pdo_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","I Yesu mewueꞌako ai aso bangka, ooto bangkano i Simo, kaa Notenaꞌo i Simo dumadaꞌo bangkano laꞌa olai tedei umbu ai wiwino. I Yesu mentoro ai wawo bangka laꞌa kaa mompaguru mia orao. ");
INSERT INTO pdo_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","UmariNo mompaguru, I Yesu motae ndi Simo, “Boseꞌo bangkamu leko ai onalongano, kaa petadiakeo jala porakomu bou.” ");
INSERT INTO pdo_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Sumangki i Simo, “Guru, aso wongito nie kimpojala lalau napo teꞌaso bou kimpohawe, kanggo akono Ikomiu tumenaꞌaku, humbee taꞌalu, iakuto metadiakeo mboꞌu jala nie!” ");
INSERT INTO pdo_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Towono rowowauo menggena pinauno i Yesu, orao ngako rompohawe bou hawe-hawe minggi teberi jalaro. ");
INSERT INTO pdo_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ooto karo mpekawesi ndi wali-waliro ai bangka mesueno. Kaa umboro mehawe karo mperonga-ronga umihiio oruono bangka laꞌira buke ako bou hawe minggi toondu. ");
INSERT INTO pdo_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Towono i Simo Peturu sumueꞌo mbio henu tegagi, umono menggolutu ai arono i Yesu, kano potae, “Ue, bintangangguto! Ako iaku nie mia tehala.” ");
INSERT INTO pdo_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Akono i Simo kaa lowono mia peronga-rongano mengkohali-hali ako oraono bou henu rompohawe. ");
INSERT INTO pdo_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Hilaꞌato mboꞌu wali-waliro ooto i Yakobu kaa i Yohane, oruo irono anano i Sebedeu. Kanoꞌamba i Yesu motae ndi Simo, “Indo momee! Mompamula olo nie Aku mokogagiko topojala mia.” ");
INSERT INTO pdo_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Kano i Simo kaa wali-walino, mediiꞌo bangkaro hawe ai wiwino towa, karoꞌamba mebintango lowo-lowono kaa tumondaꞌo i Yesu. ");
INSERT INTO pdo_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Aso olo, i Yesu ai aso inie. Lehea nio aso tama henu melowe ai lowono koroino. Towono nosueꞌo i Yesu, kano penggolutu ai arono i Yesu kaa moꞌema, “Uma, bau buuku Ikomiu poliꞌo mokotombaꞌo hakinggu!” ");
INSERT INTO pdo_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","I Yesu tumeteakeo kaeNo ka uminiꞌo mia mahaki laꞌa kaa motae, “Iaku buuku, tombato!” Tempono i Yesu motae menggena ulaꞌa, oto tomba hakino mia melowe laꞌa. ");
INSERT INTO pdo_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Kanggo i Yesu lano beheꞌakeo mia melowe laꞌa pauꞌo ndi aineitokaa, kaNo potae, “Lekoto pokokiteo koroimu ndi Petewawo Pesomba. Pompowea pesomba akono ikoto tomba menggena henu tinenano i Musa, gagi tondonino motae ikoto tomba.” ");
INSERT INTO pdo_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Kanggo mbio henu winowauNo oto telele ndi mia orao, kaa orao mia mehawe minggi merorongoio pinauNo kaa kano pinokotomba umbu ai hakiro. ");
INSERT INTO pdo_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Umari laꞌa i Yesu lumeko mekakai ai aso poꞌianga henu molimbo. ");
INSERT INTO pdo_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Nio aso olo, i Yesu tekonai mompaguru kaa nio mboꞌu to Parisi kaa Guru Agama pentoro perorongoi, umboro mehawe umbu ai Yerusale, umbu ai lowono inie langkai ai wute Galilea kaa umbu ai wute Yudea. PabawaRo i Ue nio ndi i Yesu tiano mompokotomba mia mahaki. ");
INSERT INTO pdo_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Kano nio baꞌopioꞌiro mia hawe mewaweo aso mia luuka pinokoturi ai ompeo dali. Kaa umboro powusu sala minggi mewaweo mia luuka laꞌa ai laro raha karo menaꞌo ai arono i Yesu. ");
INSERT INTO pdo_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Kanggo akono oraono mia lehea, umboro laro mentepondamo. Ooto karo mewueꞌakeo ai wawono ato. Kanoꞌamba romelompaho ato, kaa romeꞌuluiho meronga saru ompeo dalino ai arono i Yesu ai olono mia orao. ");
INSERT INTO pdo_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Towono Nosueꞌo i Yesu langkai pompeꞌalo-aloro, Nopotae, “Petia, halamu oto tinolosi.” ");
INSERT INTO pdo_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Guru agama kaa to Parisi mompamula mpepau-pau aso mia kaa aso mia, “Aineiokee mia nie mokodedeikiꞌo Ue Ala? Aineiokee henu bisa montolosi hala bano taibutu Umboro Ue Ala?” ");
INSERT INTO pdo_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Notoꞌorio i Yesu mbio henu pinewowoloro. Gagi Ropotae, “Akombio ikomiu kosike-sikeno ai laro aroamiu? ");
INSERT INTO pdo_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Undee henu moruana, motae, ‘Halamu oto tetolosi’, ba motae, ‘Pewanguto kau koleko-leko!’ ");
INSERT INTO pdo_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Kanggo hilinie Iaku mokoꞌenaho ndi ikomiu, kai mentoꞌorio kaa motae ai wawontolino nie Ana Manusia makuasa montolosi hala.” Kanoꞌamba i Yesu mepauꞌakeo mia henu luuka laꞌa, “Pewanguto, engkaho ompeo dali poturiamu kau pekule!” ");
INSERT INTO pdo_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Masa menggoti mia laꞌa ai arono mia orao, noꞌengkaho ompeo dalino kaa mekule, ai koleko-lekoano noꞌunde-undeꞌiRo Ue Ala. ");
INSERT INTO pdo_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Lowono mia mentengiri karo undeꞌiRo Ue Ala. Umboro memomee kaa mpotae, “Mbio henu kinitondo olo nie takau mompoko kohali-hali!” ");
INSERT INTO pdo_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Towono i Yesu meluarako umbu ai raha laꞌa Nosueꞌo toposima meneengako i Lewi tekonai mentoro ai raha toposima. Nopotae i Yesu ndi umono, “Tonda Akuto.” ");
INSERT INTO pdo_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Menggoti i Lewi kaa nobintango lowo-lowono, kaa tumondaꞌo i Yesu. ");
INSERT INTO pdo_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Umari laꞌa i Lewi mowowau perame-rameꞌa tiano i Yesu ai rahano. Orao toposima kaa mia mesueno mehawe mponggaa merongaꞌakero. ");
INSERT INTO pdo_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Kanggo baꞌopioꞌiro to Parisi kaa Guru Agama koꞌise-ise ndi anaguruno i Yesu karompotae, “Akombio ikomiu mponggaa kaa mpoꞌinu mperonga-ronga saru toposima kaa mia ntehala?” ");
INSERT INTO pdo_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","I Yesu sumangkiꞌiro, “Lanoꞌo mia moroso henu momparalu datoro, kanggo mia mahaki. ");
INSERT INTO pdo_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Iaku nie hawe lanoꞌo minggi mompeboi mia mentee, kanggo mia ntehala karo mentesisi.” ");
INSERT INTO pdo_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Kano nio mia motae ndi Yesu, “Anaguruno i Yohane kaa anaguruno to Parisi hora mepuasa kaa mekakai, kanggo anaguruMu monggaa kaa moꞌinu.” ");
INSERT INTO pdo_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","I Yesu sumangkiꞌiro ako sirime, “Bisakee ikomiu tumenaꞌo totokamu mepuasa ai perame-rameꞌa, tekonai umbuwoke tama dakonggo mperonga-rongaꞌakero? Matantu uuhu! ");
INSERT INTO pdo_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Kanggo amba hawe tempono umbuwoke tama laꞌa inalo umbu ndi umboro. Tempo laꞌa karoꞌamba mpepuasa.” ");
INSERT INTO pdo_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Umari laꞌa i Yesu mompauꞌakero mboꞌu sirime henu mesue, “Lalau mia moꞌalo bana umbu ai kalambi henu woꞌu kanoꞌamba notombiliꞌakeo ai kalambi henu mosuꞌo, akono kalambi henu woꞌu laꞌa olo teberi. Kaa mboꞌu bana umbu ai kalambi mosuꞌo kaa bana umbu ai kalambi henu woꞌu laꞌa lano tepokono. ");
INSERT INTO pdo_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Hilaꞌaka mboꞌu lalau mia molingi anggoro henu woꞌu ai kandu kuli henu mosuꞌo, akono anggoro woꞌu laꞌa minggi noberiho kandu kuli laꞌa, olo tesolo anggorono kaa kandu kulino masola. ");
INSERT INTO pdo_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Anggoro henu woꞌu olo liningi ai kandu kuli henu woꞌu. ");
INSERT INTO pdo_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Hilaꞌaka mboꞌu lalau mia henu behe moꞌinu anggoro henu woꞌu umari moꞌinu henu epie. Akono umono minggi motae, ‘Anggoro epie sie takau moꞌahi.’ ” ");
INSERT INTO pdo_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Ai aso olo penao-naoꞌa to Yahudi, tekonai i Yesu telalo ai lere batari, anaguruNo moꞌopu batari. Ropomongguꞌo batari laꞌa karo mengkaango. ");
INSERT INTO pdo_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Baꞌopioꞌiro to Parisi motae, “Akombio ikomiu mpowowau menggena ulaꞌa henu lano bineheako ai laro songka agama ai olo penao-naoꞌa to Yahudi?” ");
INSERT INTO pdo_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Sumangki i Yesu, “Ambo hurukee ai mebataꞌo mongkono henu winowauno i Daudi tempono umono ka miano memokoninggo? ");
INSERT INTO pdo_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","I Daudi mendamo ai laro RahaRo Ue Ala kano aleo roti henu pinesombaꞌako ndi Ue Ala, kano kaango. Kanoꞌamba noweeꞌakero mboꞌu ndi wali-walino. Sekonopo montonda songka agamando butukaa Petewawo Pesomba henu bisa monggaa roti laꞌa.” ");
INSERT INTO pdo_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Umari laꞌa i Yesu motae mboꞌu ndi umboro, “Ana Manusia pabawa ai wawono olo penao-naoꞌa to Yahudi!” ");
INSERT INTO pdo_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ai aso tempo ai olo penao-naoꞌa to Yahudi henu mesueno, i Yesu lumeko mompaguru ai Raha Pesombaꞌa. Lehea nio aso mia henu luuka kae koanano. ");
INSERT INTO pdo_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Guru agama kaa to Parisi mempoporoꞌo i Yesu bano komba mompokotomba ai olo penao-naoꞌa to Yahudi kano niokaa sala pasalaꞌo i Yesu. ");
INSERT INTO pdo_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Kanggo Notoꞌorio i Yesu pinewowoloro. Okaa i Yesu kano potaeꞌakeo mia henu luuka kaeno aso hile laꞌa, “Penggotito kau mai endea ai aroNggu!” Mia laꞌa menggoti kano leko ai arono i Yesu. ");
INSERT INTO pdo_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Kanoꞌamba nopotae i Yesu ndi umboro, “Iaku mesikeno ndi ikomiu, mbiokee henu moiko topowowau ai olo penao-naoꞌa to Yahudi, mowau henu moikokee ba mowau henu mosaꞌakee? Mongkaduduikee ba mobobarasakee?” ");
INSERT INTO pdo_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","I Yesu menggito mebolili ndi lowono mia kanoꞌamba motaeꞌakeo mia luuka kae koanano, “Teteakeo kaemu!” Kano teteakeo kaeno kaa kaeno masa toomba. ");
INSERT INTO pdo_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Kanggo Guru Agama kaa to Parisi mentekuda ngako karo pepatudu ba helinde rominggi membiongo i Yesu. ");
INSERT INTO pdo_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Tempo laꞌa i Yesu lumeko mekakai ai torukuno. Lehea i Yesu mekakai ndi Ue Ala aso ngkau wongi. ");
INSERT INTO pdo_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Towono eri-erio, i Yesu meboio lowono anaguruNo, kaNo binikio hopulo ka oruo mia umbu ndi umboro, Noneengakero mia tinena. Umboroto, ");
INSERT INTO pdo_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","I Simo (henu ninee i Peturu), kaa i Andaria haeno, i Yakobu kaa i Yohane, i Pilipu kaa i Barotolomeu, ");
INSERT INTO pdo_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","i Matiu kaa i Toma, i Yakobu anano Alapeu, kaa i Simo (henu ninee mia Seloti), ");
INSERT INTO pdo_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","i Yudasi anano i Yakobu kaa i Yudasi Isikario henu amba minggi umasaꞌo i Yesu. ");
INSERT INTO pdo_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Kanoꞌamba i Yesu meronga-ronga hopulo ka oruo anaguruNo laꞌa mpineꞌi umbu ai torukuno meleko ai lembono. Lehea oto menterombu orao anaguruNo i Yesu henu mesueno kaa orao mboꞌu mia mehawe umbu ai lowono inie ai wute Yudea, umbu ai inie langkai Yerusale, kaa umbu ai inie langkai Tirusu kaa Sidoni oruo inie langkai ai wiwintahi. ");
INSERT INTO pdo_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Umboro memai minggi merongoio pompaguruno i Yesu kaa pinokotomba umbu ai hakiro. Kaa i Yesu mboꞌu mompokotomba mia henu marasai, akono nopendamohiro penao mosaꞌa. ");
INSERT INTO pdo_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Lowono mia merokuhi uminiꞌo i Yesu, akono nio pabawa henu meluarako umbu ai koroiNo henu mompokotomba lowono mia lehea. ");
INSERT INTO pdo_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","I Yesu kumikiteiro anaguruNo kaa Nopotae, “Memangaꞌuto ikomiu mia mekarampini, ako ikomiuto miano PomparentaꞌaRo Ue Ala! ");
INSERT INTO pdo_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Memangaꞌuto ikomiu henu hilinie memokoninggo, ako ikomiu minggi memowoto! Memangaꞌuto ikomiu henu hilinie mpeꞌiwi, ako ikomiu amba mpoꞌawa! ");
INSERT INTO pdo_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Memangaꞌuto ikomiu taꞌalu nomokokatongakomiu mia, tinadi, pinepaukiako kaa pinokomosaꞌa neemiu hangano Ana Manusia! ");
INSERT INTO pdo_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Tempono ikomiu pinokomarasai menggena ulaꞌa, aimemangaꞌuto kaimpenari-nari akono langkai saromiu ai suruga. Pewowoloꞌo, menggena ulaꞌa mboꞌu nabi-nabi tempo isaꞌa nobobarasaꞌo ue mpuꞌuro mia henu hilinie mokomarasaikomiu. ");
INSERT INTO pdo_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Kanggo memasolato ikomiu henu hilinie mesugi, ako ikomiu umari mpohawe manangaia! ");
INSERT INTO pdo_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Memasola komiuto henu hilinie mowoto, ako ikomiu minggi memokoninggo! Memasola komiuto henu hilinie mpoꞌawa, ako ikomiu minggi memasusa aroa kaa mpeꞌiwi! ");
INSERT INTO pdo_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Memasola komiuto, bano lowono mia meꞌunde-unde komiu, ako helilaꞌa mboꞌu ue mpuꞌuro isaꞌa mpoꞌunde nabi-nabi lano mentee.” ");
INSERT INTO pdo_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Kanggo ndi ikomiu henu rumorongoiAku tempo nie, Aku pauꞌakomiu oliwi nie, pehohawaꞌo io uwelimu, kaa powowauto henu moiko ndi mia henu mokokatongakomu. ");
INSERT INTO pdo_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Rosongiroto mia henu tumandoko kaa pekakaiꞌakeroto mia henu mepaukiakomu. ");
INSERT INTO pdo_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Bano mia tumampeleko ai kombisimu henu aso hileno, poꞌinengoto mboꞌu kano tampeleꞌo kombisimu henu aso hileno. Kaa bano mia rumontungo hawumu poꞌineengo kano aleo mboꞌu kalambimu. ");
INSERT INTO pdo_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Bano nio mia moꞌema bambiotokaa ndi iiko, poweeꞌakeoto kaa taꞌalu romeꞌaleo henumu, indoto emango mboꞌu. ");
INSERT INTO pdo_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Powowauto ndi mia mesue menggena inehemiu rowowauꞌakomiu. ");
INSERT INTO pdo_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Bano ikomiu butu mehohawaꞌo mia henu mehohawakomiu mbiokee saromiu? Sekolopo mia ntehala mboꞌu nopehohawaꞌo mia henu mehohawaꞌiro! ");
INSERT INTO pdo_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Kaa baimpowowau henu moiko ndi mia henu mowowau moiko ndi ikomiu, mbiokee saromiu? Sekolopo mia ntehala loꞌokaa mowowau menggena ulaꞌa! ");
INSERT INTO pdo_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Kaa baimpoꞌutangakeo doi ndi mia henu bisa mokuleꞌo, mbiokee saromiu? Sekolopo mia ntehala loꞌokaa moꞌuta ndi mia tehala, karoꞌamba umemango euno menggena oraono ropoꞌutangakeo! ");
INSERT INTO pdo_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Menteꞌano lanolaahilaꞌa! Kanggo ikomiu pehohawaꞌiroto uwelimiu kau powowau henu moiko ndi umboro. Ai poꞌutangakeroto kaa indoto emango euno. Taꞌalu helilaꞌa saromiu langkai kaa ikomiu minggi gagi ana-anaRo Ue Ala Henu Pinelangkai. Akono moiko aroaRo Ue Ala ndi mia henu lano toꞌorio montarima kase kaa mboꞌu ndi mia henu mosaꞌa gauro. ");
INSERT INTO pdo_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Pokoꞌenahoto aroa pompehohawamiu menggena Umamu mboꞌu nopokoꞌenaho aroa pompehohawaNo!” ");
INSERT INTO pdo_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Indoto dosango mia mesue, kano ikomiu mboꞌu lano dosango Ue Ala. Indoto podenda mia mesue, kano ikomiu mboꞌu lano dendako Ue Ala. Oninio halano mia mesue, kano Ue Ala mboꞌu umoninio halamiu. ");
INSERT INTO pdo_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Pompoweeto ndi mia mesue kano Ue Ala mboꞌu moweeꞌakomiu, ikomiu minggi pinowea meꞌalu menggena sinaꞌu henu inihi buke ngako ka dinatopi hawe kano sawiko.” ");
INSERT INTO pdo_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Kanoꞌamba i Yesu mompauꞌakero aso sirime, “Bano mia morawu mowawo mia morawu, manasa oruo irono modonta ai wolo. ");
INSERT INTO pdo_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Lalau anaguru lumaloo pandeno guruno. Kanggo anaguru henuto umari mepaguru, minggi gagi menggena guruno. ");
INSERT INTO pdo_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Akombio kai sueꞌo subingkau mopulino petiamu, sekonopo lau sueꞌo polengkau ai matamu? ");
INSERT INTO pdo_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Helinde ikomiu pauꞌakeo petiamu, ‘Mai petia, iaku umoniniakomu subingkau mopulimu umbu ai matamu,’ sekonopo lau sueꞌo polengkau henu ai matamu? O mia mompemiamoiko! Luarakeo seꞌelu polengkau henu ai laro matamu. Kanoꞌamba ikomiu mosue takau kaa bisa lumuarakeo subingkau henu ai laro matano petiamu.” ");
INSERT INTO pdo_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Puꞌuno kau henu moiko lanolei mewue henu mosaꞌa. Hilaꞌaka mboꞌu puꞌuno kau henu tai moiko lanolei mewue henu moiko. ");
INSERT INTO pdo_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Lowono puꞌuno kau tetoꞌori umbu ai wueno. Umbu ai tolonu lanolei inopu wua ara, kaa umbu ai seko merui lanolei inopu wua anggoro. ");
INSERT INTO pdo_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Mia henu moiko mepau henu moiko akono aroano buke ako moikoꞌa. Mia henu mosaꞌa gauno mepau henu mosaꞌa akono aroano buke ako aroa mosaꞌa. Akono mbio henu pinaundo ooto henu meluarako umbu ai aroando.” ");
INSERT INTO pdo_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Mbiokakee kau koraꞌIaku, ‘Ue, Ue,’ kanggo lailaꞌa lumeluꞌo mbio henu Kupauꞌakomiu? ");
INSERT INTO pdo_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Sombo mia henu mai ndi Iaku kaa rumongoio pauNggu kaa lumeluꞌo, Kupoweꞌakomiu sirime menggena mbio Kuponggenahiro. ");
INSERT INTO pdo_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Umboro menggena mia henu mowangu raha kano kekeo wute hawe teꞌonalo kanoꞌamba nowowauo pentoroꞌano raha ai wawo wasu. Tempono hawe moowo merumpa, raha laꞌa lano terowa, akono moroso pentoroꞌano. ");
INSERT INTO pdo_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Kanggo mia henu rumongoio pauNggu kaa lano lumeluꞌo, umono menggena mia henu mowangu raha ai wawo wute kanggo lalau pentoroꞌano rahano. Tempono hawe moowo merumpa, raha laꞌa ronga terowa, kaa mobea ngako masolano!” ");
INSERT INTO pdo_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Umarino i Yesu mompaguru lowono sie ndi mia orao, Umono lumeko ai inie langkai Kapenau. ");
INSERT INTO pdo_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Lehea nio aso kapala sorodadu to Roma. Umono mompeꞌue aso ata henu nopehohawaꞌo ngako, ata laꞌa mahaki mapari. ");
INSERT INTO pdo_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Tempono kapala sorodadu laꞌa rumongoio motae i Yesu nio ai inie langkai Kapenau, notenaꞌo baꞌopio mia mosuꞌono to Yahudi lumeko tepohaweꞌakeo i Yesu kaa moꞌema kano i Yesu mai mokotombaꞌo atano. ");
INSERT INTO pdo_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Towono romentepotowoꞌakeo i Yesu, rompotae, “Kimpoeꞌma takau, Kai tulungio kapala sorodadu laꞌa. Umono tekonoano bai tulungio, ");
INSERT INTO pdo_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","ako umono mehohawaꞌo tongkundo ka umonoto henu mobaraꞌa kami powangua Raha Pesombaꞌa.” ");
INSERT INTO pdo_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Umari sie i Yesu lumeko merongangiro. Towono i Yesu umbeda ai rahano kapala sorodadu laꞌa, kapala sorodadu laꞌa montena wali-walino mompohawe oliwi ndi Yesu, “Indoto Ai peladeki mai ai rahanggu, akono iaku nie lano koono tumarima Komiu ai laro rahanggu, ");
INSERT INTO pdo_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","okaa mboꞌu laku taha hawe ai aroMiu. Kanggo Ai pepautokaa ‘Tombato’, matantu atanggu laꞌa toomba. ");
INSERT INTO pdo_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Ako iaku nie nio henu parenta akukaa iaku nio mboꞌu sorodadu henu kuparentaꞌo, baku potaeꞌakeo, ‘Leko!’ Olo lumeko, baku potaeꞌakeo, ‘Mai!’ Olo mai. Helilaꞌaka mboꞌu baku potaeꞌakeo atanggu, ‘Wowauoto unie!’ Olo nowowauo.” ");
INSERT INTO pdo_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","I Yesu kohali-hali rumongoio pau laꞌa, kanoꞌamba mewolili ndi mia orao henu tumondaꞌiro ka Nopotae, “Oponie Kupohawe pompeꞌalo-alo henu langkai, ambo huru Kuhaweꞌo maupo ai olono tongku Isaraeli!” ");
INSERT INTO pdo_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Tempono umboro henu tinena hawe ai rahano kapala sorodadu, ata laꞌa oto toomba. ");
INSERT INTO pdo_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Kanoꞌamba i Yesu lumeko ai inie langkai Nai, mperonga-ronga saru anaguruNo kaa mia orao henu tumondaꞌiro. ");
INSERT INTO pdo_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Towono i Yesu umbeda ai pangalomba inie langkai laꞌa, nio baꞌopioꞌiro mia tekonai mompoꞌaha buleka ana monguro henuto maate mpeluarako umbu ai inie langkai. Ana monguro laꞌa ana henu aso-aso umbu ai mia waalu. Orao mia umbu ai inie langkai laꞌa tumondaꞌo ineno. ");
INSERT INTO pdo_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Ka towono i Ue sumueꞌo ineno ana ntama laꞌa, telelu aroa pompehohawano ka Nopotaeꞌakeo, “O ine, indoto peꞌiwi!” ");
INSERT INTO pdo_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Kanoꞌamba i Yesu umumbedahio buleka mia maate laꞌa ka Nodanggiho. Gagi mia henu mpolembara buleka laꞌa mpenao-nao. Ka i Yesu motae, “Oo ana monguro, Kupotaeꞌakomu, pewanguto!” ");
INSERT INTO pdo_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ana monguro henu maate laꞌa muule oto kano pentoro ka mepau. Kanoꞌamba i Yesu meweangakeo ndi ineno. ");
INSERT INTO pdo_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Lowono mia mentengiri ka mpoꞌunde-unde ndi Ue Ala. Nio henu motae, “Ue Ala oto montena nabi henu langkai hawe ai olondo,” ka nio mboꞌu henu motae, “HaweꞌiRoto Ue Ala kumaduduikito bawaaRo.” ");
INSERT INTO pdo_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Tepalele oto kareba mongkono i Yesu ai lowono wute Yudea kaa petengi-tengi wute Yudea. ");
INSERT INTO pdo_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Towono i Yohane rumongoio umbu ndi anaguruno lele kumonoo mbio henu winowauno i Yesu, nopeboio oruo anaguruno, ");
INSERT INTO pdo_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","ka notenaꞌiro lumeko mesikeno ndi Yesu, “Ikomiutokee Datu Pongkadudui ginantiRo Ue Ala isaꞌama henu minggi hawe? Ba danio mboꞌukee mia henu minggi kimeꞌeꞌemango?” ");
INSERT INTO pdo_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Anaguruno i Yohane laꞌa lumeko ndi Yesu ka motae, “I Yohane Puumpodolo tumena kami mesikeno ndi Ikomiu ba Ikomiuto kee mia ginantiRo i Ue Ala henu minggi hawe ba danio mboꞌukee mia henu minggi kimeꞌeꞌemango?” ");
INSERT INTO pdo_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Tempo laꞌa i Yesu mompokotomba orao mia umbu ai manggerupa haki kaa marasaiꞌa, kaa montamba orao penao mosaꞌa kaa mboꞌu mompokotomba mia morawu karo mposue. ");
INSERT INTO pdo_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Gagi i Yesu sumangkiꞌo anaguruno i Yohane, “Aimpekuleto ndi Yohane ka pauꞌakeo mbio henu ai sueꞌo ka ai rongoio, mia henu morawu oto mosue, mia henu luuka oto koleko-leko, mia henu melowe oto toomba, mia henu mobongo oto morongoi, mia maate oto muule ka mia karampini olo mohawe pompokomoroso aroa kaa Kareba Moiko. ");
INSERT INTO pdo_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Memangaꞌuto mia henu mpihe mompeꞌalo-alo ndi Iaku kaa henu tumarima Aku.” ");
INSERT INTO pdo_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Towono mia tinenano i Yohane laꞌa mpekule, i Yesu mepau ndi mia orao mongkono tinuwuno i Yohane kaa Nopotae, “Mbiokakee aileko mponggito ai konde one? Monggito seko henu pinurino angikee? Lanoꞌo. ");
INSERT INTO pdo_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ba ikomiu lumeko minggi monggito mbio? Mia henu meparewa moikokee? Lanoꞌo mboꞌu. Bano mia meparewa moiko ka tuwu manangai olo moꞌia ai rahano datu. ");
INSERT INTO pdo_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Gagi mombio kai meleko? Minggi mponggito nabikee? Mentee, i Yohane meꞌalu langkai kaa nabi. ");
INSERT INTO pdo_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Kumonoo ai Yohane nio teꞌuki ai Sura Tutulu helinie, Nopotae Ue Ala, ‘Tinieto tinenaNggu’ ‘MeseꞌelumiKo, umono mowungge sala tiaMu!’ ");
INSERT INTO pdo_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Pewowoloꞌo, ai olono mia henu pineanaꞌako lalau maupo teꞌaso mia henu lalolangkai kaseko ai Yohane Puumpodolo, kanggo henu dedeiki ngako ai laro PomparentaꞌaRo Ue Ala lalolangkai kaseko ai Yohane.” ");
INSERT INTO pdo_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Lowono mia ka mboꞌu toposima henu rumongoio pauno i Yesu, umboroto mia henu mompeꞌalo-alo ndi Ue Ala, ako umboro umarito nodoloꞌiro i Yohane. ");
INSERT INTO pdo_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Kanggo to Parisi kaa Guru Agama laro mentarimaꞌo poꞌeheRo Ue Ala ai laro tinuwuro, ooto laro mebehe nodoloꞌiro i Yohane. ");
INSERT INTO pdo_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Kanoꞌamba i Yesu motae, “Menggena mbiokee Kuponggenahiiro mia tempo nie? ");
INSERT INTO pdo_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Umboro menggena ana-ana henu mpentoro ai pasa karo mpesangki-sangki, ‘Ikami mpenani-nani mangaꞌua, kanggo ikomiu lailaꞌa mpenari, ikami mpenani-nani mokokolaro, kanggo ikomiu lailaꞌa mpeꞌiwi.’ ");
INSERT INTO pdo_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Menggena ulaꞌa mboꞌu ikomiu, akono tempono i Yohane Puumpodolo hawe, umono mepuasa kaa lano poꞌinu anggoro, kanggo ikomiu mpotae, ‘Umono nopendamohio onisu!’ ");
INSERT INTO pdo_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Kanoꞌamba Ana Manusia hawe, Umono monggaa kaa moꞌinu anggoro, kanggo ikomiu mpotae, ‘Kiteo mia laꞌa! Umono mesoko, molangu, ka mewali-waliꞌakeo toposima ka mia henu tehala.’ ");
INSERT INTO pdo_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Napono helilaꞌa pandeꞌa umbu ndi Ue Ala mehanga ai lowono mia henu tumarimaꞌIro.” ");
INSERT INTO pdo_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Nio aso to Parisi neeno i Simo. Meboio i Yesu mai monggaa ai rahano. I Yesu lumeko ai rahano kaa mentoro monggaa. ");
INSERT INTO pdo_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ai inie langkai laꞌa nio irowai henu tumuwu ntehala. Tempono rumongoio i Yesu tekonai monggaa ai rahano i Simo, lumekoto umono mowawo buli-buli henu winowau umbu ai wasu puala meꞌihi boka mana moꞌahi. ");
INSERT INTO pdo_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Irowai laꞌa menggoti ai bungkuno i Yesu umbeda ai kareNo, kano peꞌiwi hawe kano mowaha kareno i Yesu ako uwoi matano. Kanoꞌamba nopaisio kareno i Yesu ako wuuno hawe mosuꞌi. Umari laꞌa noꞌikiꞌo kareno i Yesu kano bokaio ako boka mana moꞌahi. ");
INSERT INTO pdo_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Towono nosueꞌo i Simo henu winowauno irowai laꞌa, nopotae ai laro aroano, “Taꞌalu mentee suꞌu mia nie nabi konggonokaa Notoꞌorio irowai henu bokaio kareNo laꞌa ooto irowai henu tuwu ai laro hala.” ");
INSERT INTO pdo_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Nopotae i Yesu ndi Simo, “Nio minggi Kupauꞌakomu.” Sumangki i Simo, “Pauꞌoto Guru.” ");
INSERT INTO pdo_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","I Yesu motae, “Nio oruo mia henu mepasua ndi mia henu moꞌutangakero doi, aso mia moꞌuta lima etu doi pera, kaa aso mia mboꞌu moꞌuta lima pulu doi pera. ");
INSERT INTO pdo_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Akono laro pokobaraꞌo pasuaro, gagi andono inema mboꞌu. Bano pohawemu aineiakero henu mehohawaꞌo mia henu moꞌutangakero doi?” ");
INSERT INTO pdo_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Sumangki i Simo, “Bano pohawenggu, mia henu orao pasuano.” Nopotae i Yesu ndi Simo, “Mentee sangkimu sie.” ");
INSERT INTO pdo_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Kanoꞌamba i Yesu menggito ndi irowai laꞌa kano potaeꞌakeo i Simo, “Iaku hawe ai rahamu kanggo lau pasadiaꞌo uwoi wohokino kareNggu. Kiteo irowai nie, nowohokio kareNggu ako uwoi matano amba nopaisio ako wuuno. ");
INSERT INTO pdo_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Iiko Simo lau towoꞌAku ka umikiꞌAku, kanggo irowai nie mompamula kuhawe lano huru menao-nao umikiꞌo kareNggu. ");
INSERT INTO pdo_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Iiko Simo lau bokaio uluNggu, kanggo irowai nie noboakaio kareNggu ako boka mana moꞌahi. ");
INSERT INTO pdo_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Gagi Kupauꞌakomu Simo, irowai nie oto orao nopokoꞌenaho pompehohawano akono halano irowai nie henu orao ooto tinolosi. Mia henu dei-dei halano tinolosi, dei-dei mboꞌu nopokoꞌenaho pompehohawano.” ");
INSERT INTO pdo_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Kanoꞌamba i Yesu mepauꞌakeo irowai laꞌa, “Halamu oto tinolosi.” ");
INSERT INTO pdo_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Mia mesue henu mpentoro monggaa saru i Yesu, kopau-pau ai laro aroaro, “Nokoaraꞌaraa Umonoto Ue Ala kano poli montolosi hala!” ");
INSERT INTO pdo_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Kanggo i Yesu mepauꞌakeo irowai laꞌa, “Hangano pompeꞌalo-alomu ndi Iaku, ikoto kinadudui. Pekuleto ai laro mangaꞌua.” ");
INSERT INTO pdo_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Lano epie umari laꞌa i Yesu meronga hopulo ka oruo anaguruNo lumeko mompalele Kareba Moiko mongkono PomparentaꞌaRo Ue Ala ai sombo inie kaa sombo inie langkai. ");
INSERT INTO pdo_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Nio mboꞌu baꞌopioꞌiro irowai henu tumondaꞌo i Yesu. Umboro oto pinokolipa umbu ai penao mosaꞌa ka pinokotomba umbu ai hakiro. Umboro laꞌa ooto i Maria henu ninee Madalena henu pinokolipa umbu ai opitu penao mosaꞌa. ");
INSERT INTO pdo_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Ai Yohana, somborino i Kusa, petewawo mia henu mpoꞌangga ai poꞌiangano datu Herode, ai Susana ka orao irowai mesueno. Ako nioro, rotulungio i Yesu kaa anaguruNo. ");
INSERT INTO pdo_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Orao mia mengkohawe-hawe umbu ai orao inie langkai mai ndi Yesu. Tempono romenterombu, i Yesu mompauꞌakero sirime menggena unie, ");
INSERT INTO pdo_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Nio aso mia henu melere leko morawo wuku pinaho, tekonaino morawo nio henu modonta ai wiwi sala. Wuku pinaho laꞌa nololaꞌango mia kaa nokaango manu-manu hawe pinggo. ");
INSERT INTO pdo_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Kaa mboꞌu nio henu modonta ai wute mewasu-wasu. Tempono mesabi wuku pinaho laꞌa molau akono wuteno mosuꞌi. ");
INSERT INTO pdo_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Nio mboꞌu henu modonta ai laro seko. Akono tuwu meronga seko, wuku pinaho laꞌa teꞌasisi hawe maate. ");
INSERT INTO pdo_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Kanggo nio mboꞌu wuku pinaho laꞌa henu modonta ai wute monuwo, kano tuwu kolangka-langkai ka mewue aso etu lukano.” UmariNo mompauꞌakero sirime laꞌa, i Yesu motae, “Ainei mebiri, noporongoito!” ");
INSERT INTO pdo_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Anaguruno i Yesu mpesikeno ndi Yesu mbio pengkonoano sirime laꞌa. ");
INSERT INTO pdo_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","I Yesu sumangkiꞌiro, “Ikomiu oto pinowea pandeꞌa kai mentoꞌorio menggena mbio pomparentaRo Ue Ala, kaa ulaꞌa lano pinauꞌako ndi mia orao. Kanggo mia mesue pinaguruꞌako sirime, karo mpeꞌiꞌindoongo, kanggo laro mentoꞌorio mbio henu tegagi kaa romperorongoiakeo kanggo laro mentoꞌorio.” ");
INSERT INTO pdo_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Tinieto pengkonoano sirime laꞌa, wuku pinaho laꞌa ooto pauRo Ue Ala. ");
INSERT INTO pdo_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Wuku pinaho henu modonta ai wiwi sala laꞌa menggena pauRo Ue Ala henu norongoio mia. Kanggo hawe Ueno Onisu rumontungo pauRo Ue Ala laꞌa umbu ai aroaro, hawe karo tai kinadudui akono laro pompeꞌalo-alo ndi PauRo Ue Ala. ");
INSERT INTO pdo_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Wuku pinaho henu modonta ai wute mewasu menggena PauRo Ue Ala henu tempono romerongoio mia, momoiko romentarimaꞌo. Kanggo PauRo Ue Ala laꞌa lano mehaka ai laro aroaro. Butu saraikaa ropompeꞌalo-alo kaa tempono hawe masusaꞌa, tetadi pompeꞌalo-aloro. ");
INSERT INTO pdo_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Wuku pinaho henu modonta ai laro rui menggena PauRo Ue Ala henu romerongoio mia, kanggo umboro konanta-nanta ako tuwuaro, sugiꞌa ka manangaia. Gagi lowono sie mebisiꞌiro karo laro mewue henu moiko. ");
INSERT INTO pdo_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Wuku pinaho henu modonta ai wute monuwo menggena PauRo Ue Ala henu romerongoio mia, karo menaaꞌo ai laro aroaro henu takau moiko. Umboro mewue mpihe akono moroso pompeꞌalo-aloro.” ");
INSERT INTO pdo_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Kanoꞌamba i Yesu tumiangiakero mboꞌu sirime nie, “Lalau mia henu mokomeleaꞌo palita kanoꞌamba pupungakeo ako gumba ba numaaꞌo ai totono poturia. Kanggo olo numaaꞌo ai wawono dalika, kano lowono mia henu mendamo ai laro raha laꞌa sumueꞌo mowineno. ");
INSERT INTO pdo_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Akono lowono henu hilinie lano tetoꞌori matantu amba tetoꞌori kaa lowono henu hilinie tewuni, amba minggi winungge kaa sinue suꞌu. ");
INSERT INTO pdo_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Ooto usie, kai pesuꞌuio temomoiko ba helinde ikomiu merongoio PauRo Ue Ala. Akono sombo mia henu tumarimaꞌo PauRo Ue Ala, Ue Ala minggi tumiangiakeo pandeꞌa kano takau tumoꞌorio. Kanggo sombo mia henu lano tumarimaꞌo pauRo Ue Ala, napono nopewowoloꞌo motae notoꞌorio tedei, usie mboꞌu minggi Roꞌaleo Ue Ala umbu ndi umono.” ");
INSERT INTO pdo_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","IneNo kaa baꞌopioꞌiro petiano i Yesu hawe minggi tepohaweꞌakeo i Yesu kanggo laro tepohawe ako oraono mia. ");
INSERT INTO pdo_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Oto kano nio mia lehea motaeꞌakeo ndi Yesu, “Guru, ineMiu kaa petiaMiu nio ai bungkuno. Umboro minggi tepohaweꞌakoMiu.” ");
INSERT INTO pdo_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Kanggo i Yesu motae ndi umboro, “IneNggu kaa petiaNggu ooto umboro henu rumongoio kaa lumeluꞌo pauRo Ue Ala.” ");
INSERT INTO pdo_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Ai aso olo i Yesu saru anaguruNo mpeꞌula ai bangka. I Yesu motae ndi umboro, “Maito kato mpebangka meleko ai sakino towa.” Pewungguako iroto. ");
INSERT INTO pdo_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Tekonairo mpebangka, i Yesu tekoturi. Bingkosako nio angi maꞌo mepuuri ai towa ka uwoi mendamo ai laro bangka, oto karo pohawe abalaa kaa minggi saabu bangkaro. ");
INSERT INTO pdo_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","AnaguruNo lumikeio i Yesu, karompotae, “Guru, guru, ikitoto minggi mesaabu!” I Yesu mewangu kaa rumambasio io angi ka pue henu rumumpaꞌo bangkaro. Io angi ka pue laꞌa menao kano towa laꞌa gagi mondoto. ");
INSERT INTO pdo_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Kanoꞌamba i Yesu motae ndi umboro, “Mombio kai tai pompeꞌalo-alo ndi Iaku?” Gagi anaguruNo mentengiri ka memomee karo mpepau-pau aso mia ka aso mia, “Takau makuasa Mia nie, hawe-hawe io angi kaa pue tumondaꞌo parentaRo!” ");
INSERT INTO pdo_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Kanoꞌamba i Yesu ka anaguruNo pebangka mpotilalo hawe ai wute Gerasa ai sakino towa Galilea. ");
INSERT INTO pdo_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Tempono i Yesu metii umbu ai bangka, nio aso tama henu rompendamohio penao mosaꞌa hawe tumowokio i Yesu. Mia laꞌa umbu ai inie langkai. Oto epie lano peparewa ka lano behe moꞌia ai raha kanggo ineheno moꞌia ai puuwesu ponaꞌanga mia maate. ");
INSERT INTO pdo_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Towono tama laꞌa sumueꞌo i Yesu, umono kumora kaa menggolutu ai arono i Yesu kano pepau mekora, “Ikomiu minggi mbionganggukee o Yesu AnaRo Ue Ala Henu Pinelangkai? Kupoꞌema ndi Ikomiu indo bobarasa aku!” ");
INSERT INTO pdo_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Mia henu rompendamohio penao mosaꞌa laꞌa motae menggena ulaꞌa akono i Yesu oto tumenaꞌiro penao mosaꞌa mpeluarako umbu ai koroino. Menggoeto umono rompendamohio penao mosaꞌa, gagi maupo kaeno ka kareno inonggo ako rante ka umono ginagai takau, umono da poli mokobiteho ranteno kano waweo penao mosaꞌa ai konde molimbo. ");
INSERT INTO pdo_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","I Yesu mesikeno ndi tama laꞌa, “Aineikee neemu?” Nosangkiꞌo, “Neenggu ai ‘Legio’,” pengkonoano “masowu-sowu.” Nosangkiꞌo menggena ulaꞌa akono oto orao penao mosaꞌa mendamo ai koroino. ");
INSERT INTO pdo_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Penao mosaꞌa laꞌira mpoꞌema ndi Yesu, kano indoro mentinamba leko ai wingke matea. ");
INSERT INTO pdo_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ai leeno tamungku umbeda umbu ai poꞌianga laꞌa nio orao ngako boe tekonai mpowusu kaanga. Onisu mosaꞌa laꞌira mpoꞌema ndi Yesu karo mebineheako mpendamo ai boe laꞌira kaa i Yesu tumarimaꞌo. ");
INSERT INTO pdo_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Gagi onisu mosaꞌa laꞌira meluarako umbu ai tama laꞌa karo mpendamo ai boe laꞌira. Kanoꞌamba boe laꞌira mpolao leki wiwi wingke karo mpetoa ai towa hawe karo memate moꞌonu. ");
INSERT INTO pdo_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Towono mia henu mpogagai boe laꞌira sumueꞌo mbio henu tegagi, rompelulu lumeko ai inie langkai ka inie petengi-tengino mompauꞌakero mia mbio henu sinuero. ");
INSERT INTO pdo_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Gagi mia laꞌira meleko minggi mengkiteo mbio henu tegagi. Toworo mehawe ndi Yesu, lehea romehaweꞌo tama henuto pinokolipa umbu ai penao mosaꞌa laꞌa oto mentoro umbeda ai kareno i Yesu. Tama laꞌa oto meparewa ka pompewowolono oto moiko. Masa memomee umboro ndi Yesu. ");
INSERT INTO pdo_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Pompakambi boe laꞌira henu sumueꞌo suꞌu mbio henu tegagi laꞌa mompauꞌakero helinde tama pinendamohiro penao mosaꞌa laꞌa pinokolipa. ");
INSERT INTO pdo_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Akono romemomee, lowono mia henu moꞌia ai Gerasa motae ndi Yesu, “Lekoto kaa bintanggami.” Gagi i Yesu meꞌula ai bangka minggi mekule ai Galilea. ");
INSERT INTO pdo_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Tama henu oto pinokolipa umbu ai penao mosaꞌa laꞌa moꞌema kano petonda ndi Yesu. Kanggo i Yesu tumenaꞌo mekule, Nopotae, ");
INSERT INTO pdo_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Pekuleto ka paleleꞌo lowono henuto Rowowauo Ue Ala ndi iko.” Gagi tama laꞌa mekule kaa paleleꞌo ndi mia ai lowono inie ai inie langkai laꞌa mbio henu nowowauo i Yesu ndi umono. ");
INSERT INTO pdo_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Pekuleno i Yesu umbu ai sakino towa Galilea, Umono oto romeꞌeꞌemango mia orao kaa umboro memangaꞌu mentowokio i Yesu. ");
INSERT INTO pdo_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Hawe aso mia petewawo Raha Pesombaꞌa neeno i Yairu. Umono menggolutu ai arono i Yesu ka moꞌema kano i Yesu lumeko ai rahano. ");
INSERT INTO pdo_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Akono anano henu aso-asono tekonai mahaki mapari. Ana laꞌa ana irowai, ka tinuwuno hopulo ka oruo ntaꞌu. Tekonai i Yesu lumeko ai rahano i Yairu orao mia mpeburo-buroso ai horiNo. ");
INSERT INTO pdo_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ai oloro mia orao laꞌira, nio aso irowai henu hopulo ka oruo ntaꞌu mahaki kereaꞌa. Pinggo oto lowono agaagano nopakeꞌo meꞌole ai sando kanggo lalau baineitokaa mia henu poli pokotombaꞌo. ");
INSERT INTO pdo_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Irowai laꞌa umumbedahio i Yesu umbu ai bungkuNo kano danggiho tapuno ndole-ndole hawuno. Umari laꞌa masa tomba hakino. ");
INSERT INTO pdo_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","I Yesu mesikeno, “Aineike dumanggihaKu?” Lowono mia lalau mengaku. Nopotae i Peturu, “Guru, orao mia bolilingi Komiu, umboro peburo-buroso ai horiMiu!” ");
INSERT INTO pdo_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Kanggo i Yesu motae, “Nio mia dumanggihaKu. Kutoꞌorio akono nio pabawa meluarako umbu ai koroiNggu.” ");
INSERT INTO pdo_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Irowai laꞌa oto notoꞌorio motae winowauno laꞌa oto tetoꞌori, oto kano wiiwi hawe menggolutu ai arono i Yesu. Kanoꞌamba nopepau ndi mia orao akombio kano danggiho i Yesu kaa motae hakino masa toomba. ");
INSERT INTO pdo_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","I Yesu motae ndi irowai laꞌa, “AnaNggu, ako pompeꞌalo-alomu ndi Iaku, hakimu toomba. Lekoto ai laro mangaꞌua.” ");
INSERT INTO pdo_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Tekonaino i Yesu mepau, hawe aso mia tinena umbu ai rahano i Yairu motae, “Anamiu oto maate, tobuku mboꞌu pokomapariꞌo ai Guru lumeko ai rahamiu.” ");
INSERT INTO pdo_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Tempono i Yesu rumongoio pau laꞌa, Nopotae ndi Yairu, “Indo momee, masa pompeꞌalo-aloto ndi Iaku kaa anamu olo muule.” ");
INSERT INTO pdo_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Hawero ai rahano i Yairu, lalau mia henu nobeheakeo i Yesu mendamo ai bolongko butukaa ai Peturu, ai Yohane, ai Yakobu ka mia mosuꞌono ana-ana laꞌa. ");
INSERT INTO pdo_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Lowono mia lehea tekonai mpeꞌiwi mokokolaro ako ana-ana laꞌa oto maate. Kanggo i Yesu mepauꞌakero, “Indoto mpeꞌiwi. Ana-ana laꞌa lano maate, butukaa moturi.” ");
INSERT INTO pdo_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Rompoꞌawaꞌakeo i Yesu, akono romentoꞌorio ana-ana laꞌa oto maate. ");
INSERT INTO pdo_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Kanoꞌamba i Yesu uminiꞌo kaeno ana-ana laꞌa ka motae, “Pewanguto ana!” ");
INSERT INTO pdo_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Gagi masa mepenao mboꞌu ana-ana laꞌa kaa masa menggoti. Umari laꞌa i Yesu tumenaꞌiro pakango. ");
INSERT INTO pdo_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Mia mosuꞌono ana-ana laꞌa kohali-hali. Kanggo i Yesu lano beheꞌakero pauꞌo ndi baineitokaa mbio henu tegagi laꞌa. ");
INSERT INTO pdo_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","I Yesu meboiꞌiro hopulo ka oruo anaguruNo karo mpepokosi kaa i Yesu moweeꞌiro roso ka pabawa karo bisa montamba penao mosaꞌa kaa mompokotomba lowono haki. ");
INSERT INTO pdo_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Kanoꞌamba tumenaꞌiro lumeko mompokotomba mia memahaki ka paleleꞌo Kareba Moiko mongkono pomparentaRo Ue Ala. ");
INSERT INTO pdo_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Amboro meleko i Yesu umoliwingiro. Nopotae, “Indo powawo mbio-mbio, tuko, pontongo, kaanga, doi, ba parewa peꞌeumiu. ");
INSERT INTO pdo_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Bai tinarimato ai aso raha, poꞌiato lehea hawe tempono ai mebintango inie langkai laꞌa. ");
INSERT INTO pdo_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Bano nio inie lano tarima komiu, mpeluarakoto umbu ai inie sie ka tandamio awu umbu ai karemiu, gagi tondonino Ue Ala minggi dumosaꞌiro.” ");
INSERT INTO pdo_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Umari laꞌa anaguruNo mpewunggoako meleko ai inie mesueno paleleꞌo Kareba Moiko mongkono PomparentaꞌaRo Ue Ala ka mompokotomba mia mahaki ai lowono poꞌianga. ");
INSERT INTO pdo_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","I Datu Herode henu momparenta ai wute Galilea, rumongoio lowono tandangkohali-hali henu winowauno i Yesu. Umono kohali-hali akono nio mia motae i Yesu ooto ai Yohane Puumpodolo henuto muule. ");
INSERT INTO pdo_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Nio mboꞌu mia henu motae, “Ai Elia hawe euno.” Kaa nio mboꞌu mia motae, “Ue Ala momuleꞌo euno aso nabi henu isaꞌa.” ");
INSERT INTO pdo_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Kanggo i Datu Herode motae, “Oto kutenaꞌo mia umimpahio uluno i Yohane. Gagi, aineikee menteeꞌano mia sie? Oto orao kareba kurongoio mongkono mia sie.” Oto kano ai Datu Herode merokuhi kano tepohawe saru i Yesu. ");
INSERT INTO pdo_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Mpekulero mia tinena laꞌira, umboro pauꞌo ndi Yesu lowono henu umarito rowowauo. Kanoꞌamba i Yesu umuluakero lumeko mpepahe umbu ai oraongano mia, kaa lumeko umbeda umbu ai inie Besaida karo bisa pekokoꞌasoi. ");
INSERT INTO pdo_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Kanggo towono romentoꞌorio mia orao mbio henu tegagi, umboro mpetonda ndi Yesu. I Yesu tumarimaꞌiro kaa mepau ndi umboro mongkono Pomparentaro Ue Ala, kaa Umono mboꞌu mompokotomba mia mahaki ai oloro. ");
INSERT INTO pdo_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Towono wundu olo, kohopulo ka oruo anaguruNo lumeko ndi Yesu ka rompotae, “Guru, tenaꞌiroto mia niire karo meleko mpowusu kaanga ka raha peratoꞌa ai inie petengi-tengino poꞌianga nie, akono poꞌianga nie tesimpi ka molimbo.” ");
INSERT INTO pdo_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Kanggo i Yesu sumangkiꞌiro, “Ikomiuto henu moweꞌakero kaanga.” Ka rompotae, “Butukaa olimo roti ka oruo bou henu nio ndi ikami. Ikamikee henu leko mpoꞌoli kaanga tiaro mia niire?” ");
INSERT INTO pdo_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","(Baraꞌura nio olimo sowu tama lehea). Kano potae i Yesu ndi anaguruNo, “Tenaꞌiro mia niire mpentoro mperombu, baraꞌura aso mperombunga lima pulu mia.” ");
INSERT INTO pdo_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","AnaguruNo laꞌa mewowauo menggena pauno i Yesu ndi umboro ka tumenaꞌiro mpentoro. ");
INSERT INTO pdo_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Kanoꞌamba i Yesu umaleo olimo roti ka oruo bou laꞌa kano pekakai moꞌunde ndi Umboro Ue Ala. Umari laꞌa Nosebu-sebungo roti ka bou laꞌa kanoꞌamba Nopeweangakeo ndi anaguruNo, kano umboroto henu montia ndi mia orao. ");
INSERT INTO pdo_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Lowono mia mponggaa hawe mowoto. Umari laꞌa anaguruno i Yesu mokosiꞌo toreano roti kaa bou laꞌa, hopulopo ka oruo taru lowono. ");
INSERT INTO pdo_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Aso tempo i Yesu tekonai mekakai aso-asono ka anaguruNo mboꞌu nio lehea. I Yesu mesikeno ndi umboro “Bano pohawero mia orao, aineikee Iaku nie?” ");
INSERT INTO pdo_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Sumangki anaguruNo, “Nio mia henu motae Ikomiu i Yohane Puumpodolo, nio mboꞌu henu motae Ikomiu nabi Elia, kaa nio mboꞌu mia motae Ikomiu nabi henu isaꞌa muule euno.” ");
INSERT INTO pdo_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Umari laꞌa i Yesu mesikeno ndi umboro, “Bano pohawemiu, ainei suꞌukee Iaku nie?” Sumangki i Peturu, “Ikomiuto Datu Pongkadudui umbu ndi umboro Ue Ala.” ");
INSERT INTO pdo_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Kanoꞌamba i Yesu motae ndi anaguruNo, “Indo takau pauꞌakero mia mesue motae Iakuto Datu Pongkadudui.” ");
INSERT INTO pdo_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","I Yesu motae ndi anaguruNo, “Iaku nie Ana Manusia, matantu minggi marasai ngako ka laro tarima Aku io mia mosuꞌono to Yahudi, lowono kapala Petewawo Pesomba, Guru Agama. Umboro minggi pepateaKu. Kanggo koꞌotoluno olo Iaku minggi pinokomule euno.” ");
INSERT INTO pdo_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Kanoꞌamba i Yesu motae ndi lowono mia lehea, “Ainei minggi tumonda Aku, indono tondaꞌo poꞌeheno kaa nopoꞌahango kau pinotamba sombo-sombo olo ka tumonda Aku mpihe. ");
INSERT INTO pdo_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Akono bainei meotuhakeo tinuwuno ai tolino nie, lano pohawe tuwua lalau tampulaꞌano. Kanggo bainei meweangakeo tinuwuno akono tondaꞌAku minggi mohawe tuwua lalau tampulaꞌano. ");
INSERT INTO pdo_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Lalau bua-buano mompeꞌue aso wawontolino taꞌalukaa mokomarasaio tinuwuno. ");
INSERT INTO pdo_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Bainei lano umakuio motae umono anaguruNggu ka mokokohenu ako pepauNggu, gagi Iaku, Ana Manusia, laKu behe mboꞌu umakuio mia laꞌa gagi anaguruNggu, tempono Iaku hawe soongka buke ako marambaꞌa, marambaꞌa henu RoweAku umbu ndi Ue Ala, UmaNggu, meronga malaꞌeka-malaꞌeka mempori. ");
INSERT INTO pdo_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Kai mentoꞌorio, umbu ai olomiu endea nio henu lanolei maate bano taipo sumueꞌo PomparentaRo Ue Ala.” ");
INSERT INTO pdo_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Baraꞌura oalu olo umariNo mepau menggena ulaꞌa, i Yesu meꞌeka mekakai ai tamungku ka Umono umuluakero ai Peturu, ai Yohane ka ai Yakobu lumeko saru Umono. ");
INSERT INTO pdo_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Tekonaino i Yesu mekakai, raꞌiNo meꞌeu ka parewaNo gagi mopute mongkilo. ");
INSERT INTO pdo_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Bingkosako nio oruo tama mebitara saru i Yesu ooto i Musa ka i Elia. ");
INSERT INTO pdo_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Oruo irono laꞌa mewanta ka mebitaraꞌakeo i Yesu mongkono mateaNo henu minggi pinokosangka ai Yerusale. ");
INSERT INTO pdo_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Tempono i Yesu tekonai mekakai, i Peturu ka oruo walino tekoturi. Bingkosako umboro mpewangu kaa romesueꞌo i Yesu mewanta ka oruo nabi menggoti ai horiNo. ");
INSERT INTO pdo_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Tempono koꞌoruo mia laꞌa minggi bintango i Yesu, i Peturu motae, “Guru, moiko takau tempomami endea nie. Helindekee bakimpowangu otolu laika, aso tiaMiu, aso tiano i Musa, aso tiano i Elia.” I Peturu mepau menggena usie akono lano toꞌorio mbio henu pinauno. ");
INSERT INTO pdo_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Tekonaino i Peturu mepau, hawe seru tumabobongiro, karo memomee. ");
INSERT INTO pdo_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Umbu ai laro seru romerongoio Ue Ala mepau, “Tinieto AnaNggu henu Kubinikio. Aimperongoika ndi Umono!” ");
INSERT INTO pdo_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Towono andono terongoi pau umbu ai laro seru, romesueꞌo bututokaa i Yesu lehea. AnaguruNo henu sumueꞌo mbio henu umari tegagi tempo laꞌa laro huru mepaukio ndi baineitokaa. ");
INSERT INTO pdo_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Moꞌoruno i Yesu ka anaguruNo mineꞌi umbu ai tamungku, orao mia mpeburo-buroso mentowoꞌIro. ");
INSERT INTO pdo_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Bingkosako aso mia ntama umbu ai olono mia orao laꞌa kumora, “Guru, mai kiteo ari ananggu ka tulungio, butu aso-asono nie ananggu! ");
INSERT INTO pdo_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Bano penao mosaꞌa oto mendamo, bingkosako umono kokora-kora ka mongkodi-kodi hawe kano mewure pinduno. Penao mosaꞌa laꞌa mpihe bobarasaꞌo ananggu ka lano behe meleurako umbu ai koroino. ");
INSERT INTO pdo_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Umarito kupoꞌema ndi anaguruMiu karo tambaꞌo penao mosaꞌa laꞌa kanggo laro poliꞌo.” ");
INSERT INTO pdo_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Kanoꞌamba i Yesu mepau, “Oo ikomiu mia henu lano pompeꞌalo-alo ka ikomiu mia henu lano mentee tinuwumiu, minggi hawe teꞌepieꞌako mboꞌukee ku pebawaaꞌakomiu ka minggi hawe teꞌepieꞌako mboꞌukee Kusabara? Waweo ramai anamu sie!” ");
INSERT INTO pdo_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Tempono ana-ana laꞌa lumeko umumbedahio i Yesu, penao mosaꞌa laꞌa mepopasiꞌakeo ana-ana laꞌa hawe kano mongkodi-kodi. Kanggo i Yesu rumambasio penao mosaꞌa laꞌa kano peluarako ka masa toomba ana-ana laꞌa. Kanoꞌamba i Yesu mokuleꞌo ana-ana laꞌa ndi umano. ");
INSERT INTO pdo_vpl VALUES ("LK9_43a","072_9_43a","LUK","9","43a","43a","Lowono mia henu lehea mentengiri kumiteo pabawaRo Ue Ala henu langkai. ");
INSERT INTO pdo_vpl VALUES ("LK9_43b","072_9_43b","LUK","9","43b","43b","Tempono mia da mentengiri mengkiteo lowono henu nowowauo i Yesu, Umono mepau ndi anaguruNo, ");
INSERT INTO pdo_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Aimperorongoi temomoiko kaa indo kolupeo pinauNggu nie, Ana Manusia minggi pineweangako ai pabawano mia tolino.” ");
INSERT INTO pdo_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Kanggo laro mentoꞌorio anaguru mbio henu pinauno i Yesu, akono da tewuni ndi umboro. Gagi laro mentoꞌorio, ka umboro memomee mpesikeno ndi Yesu mbio pengkonoano pinauNo laꞌa. ");
INSERT INTO pdo_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Aso tempo anaguruno i Yesu mpegalo mongkono ainei henu lalolangkai ai oloro. ");
INSERT INTO pdo_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","I Yesu tumoꞌorio pinewowoloro, gagi Noꞌaleo aso ana-ana mai ai horiNo. ");
INSERT INTO pdo_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Kanoꞌamba i Yesu motaeꞌakero ndi anaguruNo, “Mia henu tumarimaꞌo ana-ana nie ai laro neeNggu, matantu notarimaꞌAku, ka mia henu tumarimaꞌAku tumarimaꞌo Umboro Ue Ala henu tumenaꞌAku. Akono mia henu lalodedeiki ai olomiu, umonoto henu lalolangkai.” ");
INSERT INTO pdo_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Nopotae i Yohane, “Guru, kimesueꞌo mia montamba onisu ai laro neeMiu, ka kimpotaeꞌakeo, ‘Indo pakeꞌo neeNo guru mami’, akono umono lanoꞌo miando.” ");
INSERT INTO pdo_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Nopotae I Yesu, “Indo meꞌontongo mia mempakeꞌo neeNggu, ako mia henu lano umewa komiu pengkonoano umboro meꞌini ndi ikomiu.” ");
INSERT INTO pdo_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Towono umbeda tempono i Yesu teꞌengka ai suruga, Nopokomanotoꞌo aroaNo lumeko ai inie langkai Yerusale. ");
INSERT INTO pdo_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Gagi i Yesu montena baꞌopio mia meseꞌelumio minggi pasadiaꞌo lowono henu noparaluꞌo i Yesu. Gagi mia tinenaNo laꞌa meleko ka mpendamo ai aso inie ai Samaria. ");
INSERT INTO pdo_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Kanggo to Samaria ai inie laꞌa laro behe tumarimaꞌo i Yesu, akono menteeꞌano i Yesu minggi lumeko ai Yerusale. ");
INSERT INTO pdo_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Tempono oruo anaguruNo ooto ai Yakobu ka i Yohane rumongoio motae to Samaria laꞌa laro mentarimaꞌo i Yesu, rompotae, “Ue, ineheMiukee ba kimpoꞌema apui umbu ai suruga metii mokoropuꞌo mia niire?” ");
INSERT INTO pdo_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","I Yesu mewolili kano tekudahakero i Yakobu ka i Yohane. ");
INSERT INTO pdo_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Umari sie karo meleko ai inie mesue. ");
INSERT INTO pdo_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Tempono i Yesu ka anaguruNo motilalo ai Yerusale, nio aso mia motae ndi Yesu, “Minggi kutonda Komiu bainderiotokaa Aileko.” ");
INSERT INTO pdo_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Sumangki i Yesu, “Dahulampu nio aano ka manu-manu nio toruino, kanggo Ana Manusia lalau poturiaNo.” ");
INSERT INTO pdo_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Kanoꞌamba i Yesu mepauꞌakeo mia mesue, “TondaꞌAku.” Kanggo nopotae mia laꞌa, “Uma, poweeꞌaku tempo ari aku lumeko tumanungo umanggu.” ");
INSERT INTO pdo_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","I Yesu motae, “Poꞌinengoto mia maate tumanungo mia maate. Kanggo iiko lekoto ka paleleꞌo Kareba Moiko mongkono PomparentaꞌaRo Ue Ala.” ");
INSERT INTO pdo_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ka nio mboꞌu mia mesue motae, “Guru, minggi kutonda Komiu kanggo indopoꞌari iaku mekule ka metompa ndi mia mosuꞌonggu.” ");
INSERT INTO pdo_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Nopotae i Yesu ndi mia laꞌa, “Lowono mia henu motengko kanggo menggito ai bungku, lano koono ai laro PomparentaꞌaRo Ue Ala.” ");
INSERT INTO pdo_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Umari laꞌa i Yesu montiso mboꞌu pitupulu anaguru mesueno, kanoꞌamba Notenaꞌiro meleko mpeꞌoru-oruo meseꞌelumio ai sombo inie langkai ka poꞌianga henu minggi Nolekoꞌario. ");
INSERT INTO pdo_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Nopotae ndi umboro, “Mia henu oto tekono tumarimaꞌo Kareba Moiko menggena pae henu oto tempono sinowi. Orao henu minggi sinowi kanggo dei-dei mia henu minggi mesowi. Gagi, aimpoꞌemato ndi Ue Ala, ueNo sowiꞌa nie, kano pasadiaꞌo mia henu minggi sumowiꞌo sowiꞌa sie. ");
INSERT INTO pdo_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Aimelekoto! Kaa mpeꞌiꞌindoongo Iaku tumena komiu menggena bimba ai olono dahulampu. ");
INSERT INTO pdo_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Indo powawo doi ba kandu-kandu tahine ba sandala mesueno. Indo petabea ndi baineitokaa ai laro koleko-lekoamiu. ");
INSERT INTO pdo_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Baimpendamo ai aso raha, pauꞌo seꞌelu, ‘Roodo tiamiu.’ ");
INSERT INTO pdo_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Bano lehea nio mia henu mangaꞌuno moikoꞌa, petabeamiu laꞌa minggi moꞌia ndi umono, kanggo bano uuhu, petabeamu laꞌa minggi mepokule ndi iiko. ");
INSERT INTO pdo_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Aimpoꞌiato ai raha laꞌa, indo mpelimba-limba. Tarima oto kaanga henu nopalenaꞌakomiu, akono mia henu moꞌangga konggonokaa mohawe sarono. ");
INSERT INTO pdo_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Baimpendamo ai aso inie langkai kaa romentowokomiu momoiko, mengkaangoto mbio henu rompopalenaꞌakomiu. ");
INSERT INTO pdo_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Ka pokotombaꞌo mia memahaki henu lehea, ka paleleꞌakero motae, ‘Kanggo pewowoloꞌo unie, andono epie mboꞌu PomparentaꞌaRo Ue Ala tegagi ai olomiu.’ ");
INSERT INTO pdo_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Kanggo bai mpendamohio aso inie langkai ka laro mentarimakomiu, ai mpeluarakoto ai sala kai mengkumora, ");
INSERT INTO pdo_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Napono popawu ai inie langkaimiu nie henu mekampi ai karemami, kimentandamio gagi tondonino motae Ue Ala minggi dumosakomiu. Kanggo pewowoloꞌo unie, Oto hawe tempono PomparentaꞌaRo Ue Ala tegagi ai olomiu! ");
INSERT INTO pdo_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Kupauꞌakomiu, ai Tampulaꞌano Wawontolino, dosaro mia ai inie langkai laꞌa lalomobea kaseko dosaro mia ai inie langkai Sodomo!’ ” ");
INSERT INTO pdo_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Memasola komiuto mia Korasi! Memasola komiuto mia Besaida! Akono bano tuduano isaꞌa ai Tirusu ka ai Sidoni tegagi tandangkohali-hali menggena henu tegagi ai olomiu, matantu umboro oto mentesisi umbu ai halaro ka meparewa umbu ai karu ka monaa popawu ai uluro, gagi tondonino pompesosooro. ");
INSERT INTO pdo_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Ai Tampulaꞌano Wawontolino, mia Tirusu ka Sidoni da moruana tinolosi kaseko ikomiu. ");
INSERT INTO pdo_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ka ikomiu mia Kapenau! Ikomiu mpewowoloꞌo, ikomiu minggi pinelangkai ka Rotarimakomiu ai suruga? Uuhu, kanggo Ue Ala minggi mokodedeiki komiu ka Rotadikomiu ai naraka!” ");
INSERT INTO pdo_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Kanoꞌamba i Yesu motae ndi anaguruNo, “Aineio rumongoi komiu, norongoiAku, ka aineio lano tumarima komiu, umono mboꞌu lano tarimaꞌAku. Kaa aineio lano tarimaꞌAku, umono mboꞌu lano tarimaꞌo Umboro henu tumenaꞌAku.” ");
INSERT INTO pdo_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Karoꞌamba mpekule kopitupulu anaguru mesueno ndi Yesu. Saru memangaꞌu rompotae, “Ue, sekonopo onisu metuundu ndi ikami, tempono kimentambaꞌiro ai laro neeMiu.” ");
INSERT INTO pdo_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Ka i Yesu motae ndi umboro, “Oto Kusueꞌo Ueno Onisu modonta umbu ai langi menggena koliki. ");
INSERT INTO pdo_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Menteeꞌano! Akuto moweeꞌakomiu roso ka pabawa. Gagi ikomiu minggi numangio lowono pabawano Ueno onisu ka bano ikomiu molaꞌa ule ka kasi-kasi, ikomiu lailei mpohawe masolaꞌa. ");
INSERT INTO pdo_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Napono menggena ulaꞌa indolei memangaꞌu akono onisu metuundu ndi ikomiu, kanggo ai memangaꞌu akono neemiu oto teꞌuki ai suruga.” ");
INSERT INTO pdo_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ai tempo laꞌa mangaꞌu i Yesu akono buke ako Penao Mempori ka Nopotae, “Uma, Ueno langi kaa wawontolino! Iaku montarimakase ndi Ikomiu, akono Ikomiu mewuniakeo lowono sie umbu ai mia henu pande ka mia pinaguru, kanggo Ikomiu tumisoꞌakeo ndi mia henu tai pinaguru. Ooto henu mokomangaꞌuo aroaMiu Uma ");
INSERT INTO pdo_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Lowono oto Roweeꞌakune UmaNggu ndi Iaku. Lailei napono teꞌaso mia tumoꞌorio Iaku anaRo, butukaa UmaNggu. Ka lailei napono teꞌaso mia henu tumoꞌorio UmaNggu butukaa Iaku ka mia henu Kubinikio karo bisa mentoꞌorio UmaNggu.” ");
INSERT INTO pdo_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Umari laꞌa i Yesu mewolili ndi anaguruNo ka Nopotaeꞌakero, “Meꞌura komiuto akono oto aimesueꞌo henuto tegagi hilinie. ");
INSERT INTO pdo_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Pewowoloꞌo, orao nabi ka datu mokomposue mbio henu aimesueꞌo hilinie, kanggo laro mesueꞌo, kaa mokomporongoi mbio henu aimerongoio hilinie, kanggo laro merongoio.” ");
INSERT INTO pdo_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Aso tempo nio aso Guru Agama hawe umaraꞌarahakeo i Yesu, nopotae, “Guru, mbioke kupowowau kakupohawe tuwua lalau tampulaꞌano?” ");
INSERT INTO pdo_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Sumangki I Yesu, “Mbio henu teꞌuki ai laro songkaro i Musa? Mbio henu bataꞌo lehea?” ");
INSERT INTO pdo_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Sumangki Guru Agama, “Pehohawaꞌo Ue Alamu, aso bobokoono aroamu, aso bobokoono sumangamu, lowono morosomu, lowono pompewowolomu kaa pehohawaꞌo peꞌaso miamu menggena au pehohawaꞌo koroimu.” ");
INSERT INTO pdo_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Nopotae i Yesu, “Mentee usie, leluꞌoto kau pohawe tuwua lalau tampulaꞌano.” ");
INSERT INTO pdo_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Kanggo minggi mokomenteeꞌo koroino, nopotae Guru Agama, “Aineiokee peꞌaso mianggu?” ");
INSERT INTO pdo_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Sumangki i Yesu telalo ai aso sirime menggena unie, “Nio aso mia umbu ai inie Yerusale mineꞌi ai inie Yeriko, ai tonga sala umono tinowoki mia mosaꞌa gauro, romeꞌaleo lowono parewano, merodoho hawe minggi maate, karoꞌamba mebintango. ");
INSERT INTO pdo_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Ai tempo sie telalo aso mia Petewawo Pesomba lumaloo sala laꞌa, nosueꞌo mia kolero-lero minggi maate, loꞌoka metalili lumeko. ");
INSERT INTO pdo_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Umari laꞌa telalo mboꞌu aso to Lewi henu moꞌangga ai Raha Pesombaꞌa, towonosueꞌo mia laꞌa, metalili mboꞌu lumeko. ");
INSERT INTO pdo_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Kanoꞌamba nio aso to Samaria, tekonai lumaloo sala laꞌa, towonosueꞌo mia laꞌa, telelu aroa pompehohawano. ");
INSERT INTO pdo_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Noleko umumbedahio, nowohokio mobelano ako boka panimbulu kaa anggoro, kano wewesio mobelano. Kanoꞌamba nowueꞌakeo ai kalideno, ka nowaweo hawe ai raha peratoꞌa kano parakaio. ");
INSERT INTO pdo_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Moꞌoruno nopoweꞌakeo doi oruo pera ndi ueno raha peratoꞌa, nopotae, ‘Parakaio mia nie, bano nio tai sombono, amba ku euꞌo baku pekule.’ ” ");
INSERT INTO pdo_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Nopotae i Yesu ndi Guru Agama, “Montonda pohawemu, ainei umbu otolu mia laꞌa henu gagi peꞌaso miano mia binobarasa laꞌa?” ");
INSERT INTO pdo_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Nopotae Guru Agama, “Mia henu mompehohawa.” Nopotae i Yesu, “Pekuleto, kau leluꞌo menggena ulaꞌa!” ");
INSERT INTO pdo_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Kanoꞌamba i Yesu ka anaguruNo motilaloakeo koleko-lekoaro, karo mehawe ai aso inie. Lehea nio aso irowai meneengako i Marita tumarimaꞌo i Yesu ai rahano. ");
INSERT INTO pdo_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Nio petiano ai Marita neeno ooto ai Maria. I Maria nie henu mpihe mentoro umbeda ai kareNo i Yesu merorongoiakeo pompaguruNo. ");
INSERT INTO pdo_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Kanggo ai Marita mpihe maritu parakaio i Yesu. Gagi noleko ndi Yesu kano potae, “Ue, mombiokee Ikomiu poꞌinenganggu parakaiKomiu aso-asonggu? Lau pehohawaꞌakukee? Tenaꞌoto petianggu sie mokowaliaku!” ");
INSERT INTO pdo_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Kanggo nosangkiꞌo Ue Yesu, “Marita, Marita! Iiko nanta-nanta ka mokorituꞌo koroimu ako manggerupa anggaꞌa, ");
INSERT INTO pdo_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","kaisaꞌa butukaa aso henu paralu. Ka i Maria oto mobiniki henu moiko, henu lano poli inalo umbu ndi umono.” ");
INSERT INTO pdo_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Aso tempo i Yesu tekonai mekakai ai aso poꞌianga. Towono umari mekakai aso anaguruNo motae, “Ue, paguru kami mekakai, menggena henu nopaguruꞌakeo i Yohane ndi anaguruno.” ");
INSERT INTO pdo_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","I Yesu sumangkiꞌiro Nopotae, “Tabulu ikomiu minggi mpekakai, potaeto menggena unie, Uma mami, aroanoto lowono mia melangkai Komiu akono Ikomiu Ue Ala henu mempori. Aroanoto Ikomiu hawe kaa momparenta ai wawontolino. ");
INSERT INTO pdo_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Poweeꞌakami sombo olo kaangamami henu sangka. ");
INSERT INTO pdo_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Ka tolosio halamami, Tulungikami ai tempono ikami meꞌinaraꞌarahako, gagi indo kimpowowau hala. Kaa pokolipakami umbu ai pompopandei.” ");
INSERT INTO pdo_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Umari laꞌa i Yesu moweꞌakero sirime, “Bano nio umbu ai olomiu henu lumeko ai rahano petiano entonga wongi ka motae, ‘Petia poweeꞌakune ari teꞌotolu rotimu, ambapo ku euꞌo, ");
INSERT INTO pdo_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","akono aso mia wali-walinggu ai koleko-lekoano telalo ai rahanggu. Kanggo ando lalau mboꞌu kaanga henu minggi kupalenaꞌakeo!’ ");
INSERT INTO pdo_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Kaa, bano petiamu laꞌa sumangki umbu ai laro rahano, ‘Tulungiꞌaku ari, indo pokorituꞌaku, ooto kupupungo ono ka iroto mpoturi ananggu, gagi laku tekoꞌalo mewangu ka moweeꞌakomu inemamu.’ ” ");
INSERT INTO pdo_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","I Yesu motae mboꞌu, “Kupauꞌakomu, napono iiko wali-walino, lano minggi behe mewangu kaa moweeꞌakomu mbio inemamu. Kanggo akono lalau mokokohenumu moꞌema mpihe, gagi nopewangu moweeꞌakomu mbio pinaralumu.” ");
INSERT INTO pdo_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Ooto usie Kupauꞌakomiu, “Aimpoꞌemato mpihe ndi Ue Ala, kai amba pinowea, aimpowusuto mpihe, kai amba mpohawe, aimpekundu-kunduto, kano ono winunggehakomu. ");
INSERT INTO pdo_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Akono baineitokaa mia henu moꞌema olo mosako ka baineitokaa mia henu mowusu olo mohawe kaa baineitokaa mia mekundu-kundu olo winunggehako ono. ");
INSERT INTO pdo_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Ai olomiu niokee uma henu moweeꞌakeo anano ule meꞌipo bano poꞌema bou? ");
INSERT INTO pdo_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Ba moweeꞌakeo kasi-kasi, bano poꞌema suꞌului manu? ");
INSERT INTO pdo_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Gagi, sekolopo mia henu mosaꞌa gauno loꞌoka notoꞌorio moweeꞌakeo henu moiko ndi anano, otokaa Umamu henu ai suruga, Umboro moweeꞌakeo Penao Mempori ndi baineitokaa mia henu mpoꞌema ndi Umboro!” ");
INSERT INTO pdo_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Aso tempo i Yesu montamba penao mosaꞌa umbu ai mia henu tailomompau ako pinogauno penao mosaꞌa. Peluarakono penao mosaꞌa, mia laꞌa masa mepau. Mengkohali-halito mia orao henu sumueꞌo kegagia laꞌa. ");
INSERT INTO pdo_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Kanggo nio mia henu motae, “Umono montamba penao mosaꞌa ako pabawano Besebu, ponggawano penao mosaꞌa.” ");
INSERT INTO pdo_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Nio mboꞌu mia minggi mowusu halano i Yesu, gagi karompoꞌema kano Umono mowowau aso tandangkohali-hali pompokoꞌenaho motae Ue Ala henu tumenaꞌO. ");
INSERT INTO pdo_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Kanggo i Yesu tumoꞌorio mbio henu nio ai laro aroaro ka pompewowoloro, gagi Nopotaeꞌakero “Bano aso pomparentaꞌa henu miano mpihe mpeꞌuweli, konggonokaa pomparentaꞌa laꞌa lano moroso, ka aso sombori henu mpihe mpeꞌua, konggonokaa mentesia-sia. ");
INSERT INTO pdo_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Hilaꞌato mboꞌu ai laro pomparentano Ueno Onisu, bano iroka mpihe mpeꞌuweli, konggonokaa pomparentaꞌano laꞌa lano moroso. Gagi lano mentee bano ikomiu mpotae Iaku montamba penao mosaꞌa umbu ai pabawano Besebu. ");
INSERT INTO pdo_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Mia henu tumonda komiu mboꞌu montamba penao mosaꞌa, lanoꞌokee rompontamba penao mosaꞌa ako pabawaRo Ue Ala? Gagi ako pabawano aineio umboro montamba penao mosaꞌa? Mbio henu rowowauo mia henu tumonda komiu laꞌa mokoꞌenaho motae lano mentee paumiu laꞌa. ");
INSERT INTO pdo_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Iaku montamba onisu ako pabawaRo Ue Ala, ooto laꞌa tondonino motae oto hawe tempono PomparentaꞌaRo Ue Ala tegagi ai olomiu.” ");
INSERT INTO pdo_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Ueno onisu menggena ueno raha henu moroso ka mpihe gumagaio rahano ako badili. Gagi lalau mia henu bisa rumontungo lowono agaagano. ");
INSERT INTO pdo_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Kanggo bano nio mia henu takau moroso hawe sumapoio kaa nonangio ueno raha laꞌa, kano rontungo lowono badili pinerorohino, kanoꞌamba tumiatiaꞌo lowono rinontuno. ");
INSERT INTO pdo_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Bainei lano tondaꞌAku, umono umewaꞌAku, kaa bainei lano tulungiꞌAku, umono sumolangio anggaꞌaNggu!” ");
INSERT INTO pdo_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Kanoꞌamba i Yesu motae, “Taꞌalu penao mosaꞌa meluarako umbu ai mia, umono moꞌeko-ekoa ai konde molonda mowusu penao-naoꞌano kanggo lano pohawe. Ooto kano potae, ‘Laluombo kupekule ai rahanggu isaꞌa, ooto mia henu umari kubintango!’ ");
INSERT INTO pdo_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Towono nopekule, nohaweꞌo mia laꞌa oto gagi menggena raha henu moroa kaa momoiko. ");
INSERT INTO pdo_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Kanoꞌamba noleko ka mowawo opitu onisu henu takau mosaꞌa kaseko umono. Karo mpendamo ka mpoꞌia ai larono mia laꞌa. Ka pokoꞌariano mia laꞌa tetiangi mosaꞌa tinuwuno umbu henu seꞌeluno.” ");
INSERT INTO pdo_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Tempono i Yesu da mepau, aso irowai umbu ai oloro mia orao motae ndi Umono, “Takau mangaꞌu ineMiu henu meꞌanaꞌakoMiu ka moꞌuokoMiu!” ");
INSERT INTO pdo_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","I Yesu motae, “Henu takau memangaꞌu ooto mia henu rumongoio pauRo Ue Ala ka lumeluꞌo!” ");
INSERT INTO pdo_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Tekonaino i Yesu rompewuwuio mia orao, Nopotilaloꞌakeo pauNo ka Nopotae, “Mosaꞌangguto gauro mia ai tempo nie. Rompoꞌema tandangkohali-hali karo pompeꞌalo-alo ndi Iaku, kanggo larolei pinowea saliwano tandangkohali-hali nabi Yunusu. ");
INSERT INTO pdo_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Helinde nabi Yunusu gagi tandangkohali-hali tiaro mia ai Niniwe, helilaꞌaka mboꞌu Ana Manusia minggi gagi tandangkohali-hali tiaro mia tempo nie. ");
INSERT INTO pdo_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Ai tempono Tampulaꞌano Wawontolino, datu irowai umbu ai Selata olo muule merongaꞌakero mia tempo nie, ka dumosaꞌiro. Isaꞌa ratu irowai laꞌa hawe umbu ai tapuno tolino rumorongoio pompaguruno i Solema henu lalompande. Kanggo endea ka tempo nie nio henu lalolangkai kaseko ai Solema. ");
INSERT INTO pdo_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ai Tampulaꞌano Wawontolino, to Niniwe olo muule merongaꞌakero mia tempo nie, ka dumosaꞌiro. Akono to Niniwe laꞌa oto mentesisi umbu ai halaro tempono i Yunusu montutuluꞌakero. Kanggo endea ka tempo nie nio henu lalolangkai kaseko ai Yunusu!” ");
INSERT INTO pdo_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Lalau mia henu mosunu palita kano leko wunio ba nopupungo ako baso. Kanggo olo nonaaꞌo ai wawono dalika gagi lowono mia henu mendamo ai raha laꞌa sumueꞌo wantano. ");
INSERT INTO pdo_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Matamu oto palitano koroimu, bano matamu molino lowono koroimu mowine, kanggo bano matamu morawu-rawu, lowono koroimu wongi-wongi. ");
INSERT INTO pdo_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Gagi aimpegagaikaa kano mowine henu ai koroimu indono gagi wongi-wongi. ");
INSERT INTO pdo_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Kanggo bano aso koroimu mowine kaa lalau napo asontia henu wongi-wongi, aso koroimu olo mowine menggena mowineno palita.” ");
INSERT INTO pdo_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Umarino i Yesu mompaguru, nio aso to Parisi meboiꞌIro lumeko monggaa ai rahano. Gagi Umono lumeko monggaa lehea. ");
INSERT INTO pdo_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Mia Parisi laꞌa kohali-hali, kumiteo i Yesu monggaa lano wohokio seꞌelu kaeNo menggena atora agama Yahudi. ");
INSERT INTO pdo_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Kanggo Ue Yesu motaeꞌakero, “Ikomiuka suꞌu to Parisi baimpolodui butukaa ai bungkuno kumbaꞌa ka kangkiri aimewohokio. Kanggo ai laro aroamiu buke ako aroa mosaꞌa ka meraaho. ");
INSERT INTO pdo_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","O ikomiu mia mebeebe, lanoꞌokee Ue Ala henu mokogagiꞌo koroimiu ka henu mokogagiꞌo mboꞌu mbio henu nio ai laro aroamiu? ");
INSERT INTO pdo_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Kanggo tia-tiaꞌakero mbiotokaa henu nio ndi iiko ai laro moputeno aroamiu ndi mia karampini, ako hilaꞌaka ikomiu gagi moroa ai aroRo Ue Ala. ");
INSERT INTO pdo_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Memasola ikomiuto to Parisi! Ako ikomiu mompowea pesomba tia hopulono ndi Umboro Ue Ala, hawe-hawe umbu ai wueno leremiu henu lalau olino menggena bungantulasi kaa lemorompa kaa manggerupa inehu mesueno, kanggo laimpehohawaꞌiRo Ue Alamu ka ikomiu memobea aso hile. Menteeꞌano ulaꞌakaa henu aimewowauo ka indo mengkulupeo henu mesueno. ");
INSERT INTO pdo_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Memasola komiuto to Parisi! Mangaꞌumiu mentoro ai pentoroꞌa pinelangkai ai laro Raha Pesombaꞌa, kaa mangaꞌumiu pinelangkai ai pasa. ");
INSERT INTO pdo_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Memasola komiuto, ikomiu menggena kaburu henu nololaꞌango mia akono tainio misano.” ");
INSERT INTO pdo_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Aso mia umbu ai oloro Guru Agama motae ndi Yesu, “Guru, Ikomiu mokodedeiki kami ako pauMiu sie!” ");
INSERT INTO pdo_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Kanggo sumangki i Yesu, “Memasola komiuto mboꞌu, Guru Agama! Ikomiu mokorituꞌo mia orao ako atora agama henu mobea tinonda. Kanggo ikomiu lailaꞌa tumondaꞌo atora sie. ");
INSERT INTO pdo_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Memasola komiuto! Ikomiu mowowau kaburu tiaro nabi-nabi henu pinepatero ue mpuꞌumiu. ");
INSERT INTO pdo_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Gagi ikomiu meinduꞌo motae ikomiu mokomenteeꞌo gauro ue mpuꞌumiu henu mpepateꞌiro nabi-nabi kai mpowowau euno kabururo. ");
INSERT INTO pdo_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Akono usieto isaꞌa ako pandeRo Ue Ala motae, ‘Iaku minggi tumenaꞌo nabi-nabi ka mia tinenaNggu ndi umboro, asontia olo pinepate ka asontia olo binobarasa! ");
INSERT INTO pdo_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Ulaꞌa Rowowauo Ue Ala kano lowono mia tempo nie dinosa akono rea pompepatea henu rowowauo ndi lowono nabi umbu pompamulaꞌano tolino, ");
INSERT INTO pdo_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","mompamula umbu ai Habeli pinepate hawe ai Sakaria henu pinepate ai olono posunua pesomba ka Raha Pesombaꞌa.’ Kupauꞌakomiu, ‘Lowono mia tempo nie olo dinosa akono lowono sie. ");
INSERT INTO pdo_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Memasola komiuto Guru Agama! Akono ai meꞌaleoto umbuꞌano pandeꞌa kanggo lailaꞌa mpendamo ka mia henu merukuhi minggi mpendamo lai mebeheꞌiro mpendamo.’ ” ");
INSERT INTO pdo_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Towono i Yesu bintango poꞌianga laꞌa, to Parisi ka Guru Agama takau umuwelio i Yesu, gagi umboro mpihe merukuhi mpesikeno manggerupa ndi Yesu. ");
INSERT INTO pdo_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Ooto karo mpowusu sala umbu ai pauno i Yesu karo poli pasalaꞌo i Yesu. ");
INSERT INTO pdo_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Tempo laꞌa masowu-sowu mia menterombu ka mpeburo-buroso umbeda ndi Yesu, hawe-hawe kano nio mia henu linolaꞌa kareno. Kanoꞌamba i Yesu mompamula mompaguru, amba-ambano ndi anaguruNo, Nopotaeꞌakero, “Aimpegaga-gagaikaa umbu ndi mia mompemiamoiko ooto to Parisi. ");
INSERT INTO pdo_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Lowono mbio henu lano tetoꞌori olo tetoꞌori. ");
INSERT INTO pdo_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Henu pinau mewuni-wuni olo tetoꞌori mia orao ka henu pinau mehaho-haho ai laro bolongko minggi pinalele ndi mia orao. ");
INSERT INTO pdo_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Kupauꞌakomiu, o wali-waliNggu indo momeeꞌakero mia henu bisa mompepate koroi kanggo laro mempoli mpowowau meꞌalu ka usie. ");
INSERT INTO pdo_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Menteeꞌano olo Kutisoꞌakomiu ndi ainei ai memomee. Momeeto ndi Ue Ala! Akono pabawaRo Ue Ala lanolaꞌa butu mompepate kanggo saru montadi mia ai laro naraka! Mperorongoioka henu Kupauꞌakomiu, momeeto ndi Umboro Ue Ala! ");
INSERT INTO pdo_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Olimo dii-dii inasa oruo mata doi henu dedeiki. Kanggo lalau napo teꞌaso henu Rokulupeo Ue Ala. ");
INSERT INTO pdo_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Maupo doano nanggeno wuumiu Rotoꞌorio Ue Ala. Gagi indo momee! Akono olimiu takau masuli kaseko dii-dii. ");
INSERT INTO pdo_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Kupauꞌakomiu, ‘Lowono mia henu umakuiꞌAku ai arono mia orao, Ana Manusia mboꞌu olo umakuio ai arono malaꞌeka-malaꞌekaRo Ue Ala. ");
INSERT INTO pdo_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Kanggo mia henu humapuꞌAku ai arono mia orao, umono mboꞌu olo Kuhapuio ai arono malaꞌeka-malaꞌekaRo Ue Ala. ");
INSERT INTO pdo_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Bano nio mia moluarako pau umewaꞌo Ana Manusia, umono olo tinolosi, kanggo mia henu meꞌuru-uruꞌo Penao Mempori, lanolei tinolosi halano. ");
INSERT INTO pdo_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Bano ikomiu winawo minggi binitara ai Raha Pesombaꞌa ba ai aroro mia henu momparenta ba mia henu langkai potorono, indo momee helinde ikomiu minggi umaropiꞌiro ka mbio henu minggi sangkiꞌo. ");
INSERT INTO pdo_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Akono tempo laꞌa mboꞌu Penao Mempori minggi paguru komiu helinde ikomiu minggi sumangkiꞌiro.’ ” ");
INSERT INTO pdo_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Aso mia umbu ai olono mia orao mepau ndi Yesu, “Guru, pepauꞌakeo petianggu kano tia-tiaꞌokaa agaaga henu binintano mia mosuꞌomami ndi iaku.” ");
INSERT INTO pdo_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Kanggo i Yesu motae, “Petia, ainei umengkahaKu gagi poꞌutuhi kara-kara tumiaꞌo agaaga ai olomiu?” ");
INSERT INTO pdo_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Kanoꞌamba i Yesu mepau ndi mia orao henu nio lehea, “Aimpegaga-gagai pekokoongo, indo memesoko. Akono napono agaagando orao kanggo tuwuando nie lanolaꞌa umbu ai sugiꞌa.” ");
INSERT INTO pdo_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Kanoꞌamba Nopauꞌakero aso sirime, “Nio aso mia suugi, henu mompeꞌue lere henu malua ka wueno lereno orao ngako. ");
INSERT INTO pdo_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Mia suugi laꞌa kopau-pau ai laro aroano, ‘Ando lalau mboꞌu ponaꞌanga wueno lerenggu. Mbio henu olo kuwowauꞌo?’ ");
INSERT INTO pdo_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Kanoꞌamba mepau mboꞌu ai laro aroano, ‘Ooto unie henu minggi kuwowauꞌo, minggi kutenaꞌo mia betaho tuꞌoranggu kaku amba mowangu mboꞌu tuꞌora henu langkai, leheato kunaaꞌo lowono wueno lere kaa lowono agaaganggu.’ ");
INSERT INTO pdo_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Kanoꞌamba iaku motae ai laro aroanggu, ‘Iaku mia suugi kaa agaaganggu sangka tiano mataꞌu-taꞌu epieno. Hilinie iaku moꞌiaꞌia tokaa, monggaa, moꞌinu ka mompemasana!’ ");
INSERT INTO pdo_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Kanggo Ue Ala mepau ndi mia suugi sie, ‘Hei mia bebe, wongi nie penaomu minggi inalo umbu ai koroimu, gagi tiano aineiokee sugiꞌa pinokosimu sie?’ ");
INSERT INTO pdo_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Kanoꞌamba i Yesu pauꞌo pengkonoano sirime laꞌa, ‘Hilaꞌato gagino mia henu suugi butu tiano koroino, kanggo lano suugi ai aroRo Ue Ala.’ ” ");
INSERT INTO pdo_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Umari laꞌa i Yesu mepau ndi anaguruNo, “Gagi Kupauꞌakomiu, ‘Indo nanta-nanta mongkono tuwuamiu, mbio henu minggi mengkaango bambio henu minggi pinakemiu.’ ");
INSERT INTO pdo_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Akono tuwua laloako mabua kaseko kaanga ka koroi laloako mabua kaseko parewa. ");
INSERT INTO pdo_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Pekokoongo paa-paa, umboro laro mporawo, laro mpesowi, laro pompeꞌue tuꞌora kanggo Ue Ala motuwuꞌiro. Ikomiu takau masuli kaseko orao manu-manu! ");
INSERT INTO pdo_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Lalau napo teꞌaso mia umbu ai olomiu henu ako nanta-nantano nopoliꞌo mokomentaaꞌo tinuwuno napo aso olo tokaa. ");
INSERT INTO pdo_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Gagi, mongkono henu dedeiki tokaa lai mempoliꞌo meleluꞌo, ikomiu indoto konanta-nanta mongkono henu mesue! ");
INSERT INTO pdo_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Pekokoongo helinde tuwuno bunga baku, lano poꞌangga, lano pontanu bana. Kanggo Kupauꞌakomiu, Datu Solema henu takau suugi mboꞌu lano meparewa henu moiko menggena bunga laꞌa! ");
INSERT INTO pdo_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Seko ai konde olo nie tuwu ka moꞌoru olo sinongko hawe pinggo, kanggo Ue Ala parakaio seko laꞌa moiko ngako. Meꞌalu takau Roparakai komiu Ue Ala, kanggo ikomiu lai pompeꞌalo-alo lahi! ");
INSERT INTO pdo_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Gagi, indoto nanta-nanta kaa bulalingo mongkono mbio henu minggi kinaa ka minggi ininu. ");
INSERT INTO pdo_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Akono lowono sie mpihe romewusuꞌo mia henu lano pompeꞌalo-alo ndi Ue Ala. Kanggo Umando henu ai suruga Rotoꞌorio mbio henu pinaralumiu. ");
INSERT INTO pdo_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Pokoseꞌeluꞌo PomparentaꞌaRo Ue Ala ai laro tinuwumiu, gagi lowono sie olo Rotiangiakomiu. ");
INSERT INTO pdo_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Indo momee! Bano butu dei-dei doamiu, ako mangaꞌu Umamiu mondamokomiu ai laro PomparentaRo. ");
INSERT INTO pdo_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Asaꞌo agaagamu, ka peweangakeo doino ndi mia karampini! Powowauto bangi-bangi henu tai huru mosuꞌo, ooto agaaga henu ninaa ai suruga. Agaaga laꞌa lano tetadi akono lano pokonakoo mia ka lano kaango ane. ");
INSERT INTO pdo_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Naaꞌo agaagamu ai suruga akono ainderio agaagamu nopoꞌia, lehea mboꞌu aroamu nopoꞌia!” ");
INSERT INTO pdo_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Aimpegagaikaa umaroꞌo lowono henu tegagi. Ikomiu olo meparewa mpihe ka palitamiu olo melea mpihe. ");
INSERT INTO pdo_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Menggena ata minggi mpeteteꞌema ponggawaro mekule umbu ai posaraꞌa pesomboriꞌa. Gagi, bano pekule ka mekundu-kundu ai ono, mongkado rowunggeho ono laꞌa. ");
INSERT INTO pdo_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Memangaꞌuto ata henu nohaweꞌo ponggawaro tekonai mpeteteꞌema. Kupauꞌakomiu, aimpeꞌale-aleo, ponggawa laꞌa olo tumenaꞌiro pentoro mponggaa, ka umono meparewa menggena ata kano parakaiꞌiro. ");
INSERT INTO pdo_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Memangaꞌuto ata laꞌa taꞌalu ponggawaro humaweꞌiro tekonai mpeteteꞌema, napono nohawe entonga wongi ba umbeda meene! ");
INSERT INTO pdo_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Pewowoloꞌo! Bano ueno raha tumoꞌorio tempono mia monako hawe, olo nogagaio mia monako laꞌa indono pendamo ai laro rahano. ");
INSERT INTO pdo_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Moikono ikomiu mboꞌu mpihe mpegagai akono laimentoꞌorio tempono Ana Manusia minggi hawe.” ");
INSERT INTO pdo_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","I Peturu mesikeno, “Ue, sirime nie pinokonoꞌako butu tiamami ba mboꞌu saru tiaro lowono mia?” ");
INSERT INTO pdo_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Sumangki i Ue, “Aineio ata henu metenunu ka paande? Umonoto mia henu noꞌengkaho ponggawano gagi petewawo tiaro ata mesueno ka poweeꞌakero kaanga ai tempo mponggaanga. ");
INSERT INTO pdo_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Memangaꞌuto ata laꞌa bano ponggawaro mekule kano nohaweꞌo tekonai poꞌangga! ");
INSERT INTO pdo_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Kupauꞌakomiu, ‘Ponggawa laꞌa olo nopeꞌale-aleꞌakeo lowono agaagano ndi mia momparakai laꞌa.’ ");
INSERT INTO pdo_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Kanggo bano ata laꞌa motae ai laro aroano, ‘Da epie kanoꞌamba mekule ponggawanggu,’ ooto kano rodoho lowono ata laꞌa kano ponggaa, moꞌinu hawe kano molangu, ");
INSERT INTO pdo_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","kanggo ponggawano mekule ai tempo olo lano tetoꞌori gagi ata laꞌa olo pinepate ka ginau menggena mia henu lano pompeꞌalo-alo ndi Ue Ala. ");
INSERT INTO pdo_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Bano nio ata henu tumoꞌorio ineheno ponggawano kanggo lano leluꞌo olo sinepi temekora. ");
INSERT INTO pdo_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Kanggo sombo ata henu lano toꞌorio ineheno ponggawano kaa mowowau henu lano mentee olo sinepi meꞌoꞌarai. Akono mia henuto pinowea orao olo orao mboꞌu inema umbu ndi umono, ka mia henuto pineꞌalo-aloakeo orao olo orao mboꞌu inema umbu ndi umono.” ");
INSERT INTO pdo_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","I Yesu motae, “Iaku hawe mowawo apui teposisalaꞌa ai wawontolino. IneheNggu ngako bano meleato apui teposisalaꞌa laꞌa! ");
INSERT INTO pdo_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Danio marasaia henu olo Kuhoringo. Ka lano todo ngako aroaNggu bano taipo tegagi marasaia laꞌa! ");
INSERT INTO pdo_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Indo mengkoꞌaraꞌara Iaku nie hawe mowawo roodo ai wawontolino. Kupotaeꞌakomiu, lanoꞌo roodo kanggo teposisalaꞌa. ");
INSERT INTO pdo_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Mompamula tempo nie ai laro sombori henu olimo mia olo teposisala, otolu umewaꞌo oruo mia, ba oruo umewaꞌo otolu mia. ");
INSERT INTO pdo_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Uma olo umewaꞌo ana ntamano ka ana ntama olo umewaꞌo umano, ine olo umewaꞌo ana irowaino ka ana irowai umewaꞌo ineno, ineno tama umewaꞌo somborino ana ntamano ka somborino ana ntama umewaꞌo ineno tama.” ");
INSERT INTO pdo_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Kanoꞌamba i Yesu mepau ndi mia orao, “Bano nio seru meꞌumbulako metotosooka, ikomiu mpotae, ‘Minggi use’ masa tii suꞌu use. ");
INSERT INTO pdo_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Taꞌalu ikomiu mesueꞌo angi mepuuri umbu ai selata, ikomiu mpotae, ‘Minggi meꞌolo’ kaa meꞌolo suꞌu. ");
INSERT INTO pdo_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Ikomiu mia mompemiamoiko! Tondonino langi ka tolino aimentoꞌorio, kanggo mombio kai laimentoꞌorio henu minggi gagi tempo nie? ");
INSERT INTO pdo_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Akombio kai lai mempoliꞌo bano butu ikomiu henu putuio mbio henu mentee? ");
INSERT INTO pdo_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Taꞌalu ikomiu meronga uwelimiu lumeko meꞌaro ndi mia pomparenta, perukuhito tepomoiko saru uwelimiu ai tonga sala, kano lano wawoko ndi mia poꞌutuhi kara-kara, ka mia poꞌutuhi kara-kara meweangakomu ndi petotoino ka petotoino mondamoko ai laro tarungku. ");
INSERT INTO pdo_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Kupauꞌakomu, iiko laulei linuarako umbu ai tarungku bano lano leso baraꞌo posurumu.” ");
INSERT INTO pdo_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Ai tempo laꞌa baꞌopio mia umumbedahio i Yesu pauꞌo lele mongkono mia Galilea henu pinepateno i Gubenuru Pilatu. Umboro laꞌa pinepate tekonai mogere pinotuwu henu minggi pinesombaꞌako ndi Ue Ala. ");
INSERT INTO pdo_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","I Yesu mepau ndi umboro helinie, “Gagi ikomiu mengkararaa mia Galilea sie takau orao halano kaseko mia Galilea mesueno, kano pinepate menggena usie? ");
INSERT INTO pdo_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Kupauꞌakomiu, ‘Matantu uuhu!’ Kanggo bano ikomiu lai mentesisi, lowomiu mboꞌu minggi maate menggena umboro. ");
INSERT INTO pdo_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Usieto mboꞌu menggena hopulo ka oalu mia henu maate ai Siloa tempono notumpaiꞌiro manara laꞌa. Indo koꞌaraꞌara, takau orao halaro kaseko lowono mia mesue henu moꞌia ai Yerusale. ");
INSERT INTO pdo_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","‘Matantu uuhu!’ Kupotae ndi komiu pihepo mboꞌu, bano ikomiu lai mentesisi umbu ai halamiu, lowomiu mboꞌu minggi maate menggena umboro.” ");
INSERT INTO pdo_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Umari laꞌa i Yesu mompauꞌakero mboꞌu sirime nie, “Nio aso mia ueno lere anggoro, mompeꞌue aso ngkau puꞌuno ara henu pinaho ai lereno. Aso olo umono lumeko mowusu wueno ara laꞌa, kanggo lalau nopohawe. ");
INSERT INTO pdo_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Gagi, nopotae ndi mia henu parakaio lereno, ‘Kiteo, ooto otolu ntaꞌu kuhawe mowusu wue ara ai puꞌuno nie, kanggo lano huru kupohawe napo teꞌaso. Tuehioto puꞌu ngkau nie! Lalau buano notuwu ai wute nie!’ ");
INSERT INTO pdo_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Kanggo nosangkiꞌo mia henu parakaio lereno laꞌa, ‘Ponggawa, poꞌinengoto kano tuwu aso ntaꞌupo mboꞌu. Minggi kubingkuꞌo wute mebolili ka morawohakeo pupu. ");
INSERT INTO pdo_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Kembuano taꞌu ramai olo mewue. Bano taimewue, tuehioto!’ ” ");
INSERT INTO pdo_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Ai aso olo penao-naoꞌa to Yahudi, i Yesu tekonai mompaguru ai laro aso Raha Pesombaꞌa. ");
INSERT INTO pdo_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Lehea nio aso irowai henuto hopulo ka oalu ntaꞌu nopendamohio penao mosaꞌa ooto kano mahaki hawe kano bongkohu kaa lano bisa mboꞌu menggoti momoli. ");
INSERT INTO pdo_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Tempono i Yesu sumueꞌo irowai laꞌa, Nopeboio kaa Nopotae ndi umono “Ine, hakimiu oto toomba!” ");
INSERT INTO pdo_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Kanoꞌamba i Yesu dumanggiho uluno irowai laꞌa ako kaeNo, bingkosako irowai laꞌa momoli nopenggoti ka noꞌunde-undeꞌiRo Ue Ala. ");
INSERT INTO pdo_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Kanggo petewawo Raha Pesombaꞌa tekuda, akono i Yesu mompokotomba mia ai olo penao-naoꞌa to Yahudi, kano potae ndi mia orao, “Nio onoo olo poꞌanggaꞌa, aimemaito ai olo laꞌa kai pinokotomba, indonoꞌo memai ai olo penao-naoꞌa to Yahudi!” ");
INSERT INTO pdo_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Kanggo Nopotae i Ue Yesu, “Ikomiu nie mia mompemiamoiko! Ai olo penao-naoꞌa to Yahudi lowono mia mokolipaho sapi ba kalideno umbu ai lolano ka waweo ai poꞌinungaro. ");
INSERT INTO pdo_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Endea nio aso irowai umbu ai inuleno i Burahima henuto hopulo ka oalu ntaꞌu noꞌonggoꞌo Ueno Onisu, bano pohawemiu lano moikokee umono pinokolipa umbu ai onggono ai olo penao-naoꞌa to Yahudi?” ");
INSERT INTO pdo_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Tempono i Yesu motae menggena ulaꞌa, lowono mia henu umewaꞌO gagi mokokohenu, kanggo wali mia memangaꞌu akono lowono tandangkohali-hali henu winowauNo. ");
INSERT INTO pdo_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","I Yesu motae, “Bano Iaku minggi mompake io sirime, menggena mbiokee Kuponggenaho PomparentaꞌaRo Ue Ala? ");
INSERT INTO pdo_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Usie menggena wuku pinaho henu dedeiki ngako henu rinawo mia ai lereno. Wuku laꞌa tuwu hawe gagi puꞌu ngkau langkai ka manu-manu metorui ai sampa-sampano.” ");
INSERT INTO pdo_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Ka Nopotae mboꞌu, “Menggena mbiokee Kuponggenaho PomparentaꞌaRo Ue Ala? ");
INSERT INTO pdo_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Usie menggena tape henu noholaꞌo aso irowai ai laro tolupulu kilo tarigu hawe kano teꞌili lowo.” ");
INSERT INTO pdo_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Kanoꞌamba i Yesu motilalo ai Yerusale, ai koleko-lekoaNo i Yesu mompaguru mongkono PomparentaꞌaRo Ue Ala ai inie-inie ka inie-inie langkai. ");
INSERT INTO pdo_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Ka nio aso mia mesikeno ndi Yesu, “Ue, butu deideikee mia henu pinowea tuwua tainio tampulaꞌano?” ");
INSERT INTO pdo_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Sumangki i Yesu ndi lowono mia henu nio lehea, “Aimperukuhito pendamo ai ono henu masipa. Kupauꞌakomiu, orao mia merukuhi minggi mendamo kanggo laro tepondamo. ");
INSERT INTO pdo_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Tempono ueno raha menggoti ka modampo onono, ikomiu mpenggoti ai arono raha ka mekundu-kundu ai onono ka mpotae, ‘Ponggawa, wunggehakami onomiu!’ Kanggo umono sumangki, ‘Laku toꞌorio umbuꞌa miu!’ ");
INSERT INTO pdo_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Ikomiu minggi mesumangki, ‘Ikami umari mponggaa ka mpoꞌinu mperongangaKomiu, ka Ikomiu mboꞌu umari mompaguru ai inie langkaimami!’ ");
INSERT INTO pdo_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Kanggo Umono olo motae mboꞌu ndi ikomiu, ‘Laku toꞌorio umbuꞌamiu. Polao umbu ai aroNggu, ikomiu henu pelelu mosaꞌa! ");
INSERT INTO pdo_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Tempono ikomiu sumueꞌo ai Burahima, ai Isaki kaa ai Yako mperonga lowono nabi memangaꞌu ai laro PomparentaꞌaRo Ue Ala, ikomiu olo mpeꞌiwi sesedu kaa marasai akono ikomiu pinetadiako ai bungkuno! ");
INSERT INTO pdo_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Orao mia olo mehawe umbu ai lowono siuno poꞌianga ai wawontolino ka olo memangaꞌu ai laro PomparentaꞌaRo Ue Ala. ");
INSERT INTO pdo_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Mia henu hilinie pineꞌuru-uru, ai tempo laꞌa olo pinelangkai. Mia henu hilinie pinelangkai, ai tempo laꞌa olo pineꞌuru-uru.’ ” ");
INSERT INTO pdo_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ai tempo laꞌa nio baꞌopio mia Parisi hawe ndi Yesu ka rompotae, “Lekoto, polaoakeo poꞌianga nie akono Datu Herode minggi mepateKo.” ");
INSERT INTO pdo_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Nosangkiꞌiro, “Lekoto ka pauꞌakeo ndi dahulampu sie, ‘Olo nie ka moꞌoru Iaku montamba onisu ka mompokotomba mia mahaki, ka koꞌotoluno olo Kupokoꞌumario anggaꞌaNggu.’ ");
INSERT INTO pdo_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Kanggo olo nie, moꞌoru ka teꞌepua Iaku matantu motilaloakeo koleko-lekoaNggu, akono lano moiko bano aso nabi pinepate ai saliwano inie langkai Yerusale. ");
INSERT INTO pdo_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","O mia Yerusale! Ikomiuto henu pepateiro nabi-nabi! Ka meratuꞌiro ako wasu hawe maate lowono mia tinenaRo Ue Ala! Oto menggopio Iaku moꞌosu rumombungo ana-anamiu menggena ineno manu kumasipapaꞌo ana-anano ai totono panino, kanggo lai mebehe! ");
INSERT INTO pdo_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Matantuno rahamu nie bininta kano gagi molimbo. Kanggo Kupauꞌakomiu, andolei sueꞌAku mboꞌu hawe ai tempono ikomiu mpotae, Rinosoto Umono henu hawe ai laro neeRo Ue Ala.” ");
INSERT INTO pdo_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Aso tempo ai olo penao-naoꞌa to Yahudi, i Yesu lumeko monggaa ai rahano aso petewawono to Parisi. Lowono to Parisi henu lehea takau rompekokoongo mbio henu minggi Nowowauo i Yesu. ");
INSERT INTO pdo_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Bingkosako hawe aso tama henu mahaki lambangkare kaa lambangkae, mentoro ai arono i Yesu. ");
INSERT INTO pdo_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Kanoꞌamba i Yesu mesikeno ndi Guru Agama kaa to Parisi, “Moikokee mompokotomba ai olo penao-naoꞌa to Yahudi ba uuhukee?” ");
INSERT INTO pdo_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Kanggo umboro butu mengkomino. Kanoꞌamba i Yesu uminio ka mokotombaꞌo mia mahaki laꞌa, ka Notenaꞌo lumeko. ");
INSERT INTO pdo_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Kanoꞌamba i Yesu mepau ndi umboro, “Aineiokee ai olomiu henu lano ronga wueꞌakeo bano anano ba sapino tedonta ai laro bunto napono ai olo penao-naoꞌa to Yahudi?” ");
INSERT INTO pdo_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Guru agama kaa to Parisi laro mentaha mesumangki. ");
INSERT INTO pdo_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","I Yesu sumueꞌo orao totoka mobiniki pentoroꞌa henu pinelangkai, gagi i Yesu mompauꞌakero pompaguru nie. ");
INSERT INTO pdo_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Bano nio mia meboikomiu lumeko ai posaraꞌa pesomboriꞌa, indo pentoro ai poꞌianga henu pinelangkai. Baraꞌura mia laꞌa oto mompeboi mia mesueno henu lalo pinelangkai kaseko iiko, ");
INSERT INTO pdo_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","indono ueno posaraꞌa leko ndi iiko kaa mepauꞌakomu, ‘Weeꞌakeo pentoroꞌamu ndi mia nie. Gagi iiko mokokohenu melimba mentoro ai tetotoakoano.’ ");
INSERT INTO pdo_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Kanggo bano iiko pineboi ai posaraꞌa, pentoroto ai tetotoakoano. Gagi baraꞌura ueno posaraꞌa mai kaa mepauꞌakomu, ‘Petia, pelimbato ai pentoroꞌa pinelangkai ai arono. Gagi menggena usie iiko mohawe pompelangkai umbu penggitoro totoka mesue. ");
INSERT INTO pdo_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Akono bainei mompelangka-langkai olo pinokodedeiki, kanggo bainei meꞌurumako olo pinelangkai.’ ” ");
INSERT INTO pdo_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Umari laꞌa i Yesu mepauꞌakeo ueno posaraꞌa, “Bano iiko mompeboi mia mai mponggaa tonga olo ba wongi ai rahamu, indo peboio wali-walimu ba petiamu ba petia umbedamu ba petengi-tengi rahamu henu mesugi, akono matantu umboro poli umowohio winowaumu ndi umboro. ");
INSERT INTO pdo_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Kanggo bai minggi mowowau posaraꞌa, peboiꞌiroto mia karampini, mia salantuwu, mia luuka kaa mia morawu. ");
INSERT INTO pdo_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Iiko minggi binarakati, ako mia siire laro mempoli umuwohio winowaumu henu moiko. Kanggo Ue Ala henu minggi umuwohiko henu moiko ai tempono mia memoiko pinomule umbu ai matea.” ");
INSERT INTO pdo_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Rumongoio pauno i Yesu laꞌa, aso mia umbu ai totoka mepau ndi Yesu, “Meuraꞌoto mia henu pineboi monggaa merongaꞌakeRo Ue Ala ai laro PomparentaꞌaRo Ue Ala henu amba ramai.” ");
INSERT INTO pdo_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Kanggo i Yesu mepau ndi mia laꞌa, “Aso tempo nio aso mia mowowau posaraꞌa langkai ka mompeboi orao mia. ");
INSERT INTO pdo_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Towono oto hawe tempono posaraꞌa laꞌa minggi pinamula, ueno pomposara tumenaꞌo atano lumeko ndi mia henu pineboi ka motaeꞌakero, ‘Memaito ako lowono oto tepalena.’ ");
INSERT INTO pdo_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Kanggo umboro sisingge mpoꞌema karo minaꞌapi. Mia henu koꞌaso motae ndi ata laꞌa, ‘Tabeamu, dapoku umari moꞌoli wute pelereꞌa danie gagi minggi kuleko kumiteo ari.’ ");
INSERT INTO pdo_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Mia henu mesue motae, ‘Tabeamu, dapoku umari moꞌoli olimo timbano sapi kaa minggi kuꞌaraꞌarahakeo moꞌanggaꞌako.’ ");
INSERT INTO pdo_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Mia henu mesue mboꞌu motae, ‘Tabeamiu, da sarai kupesombori, gagi laku lei mai.’ ");
INSERT INTO pdo_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Ata laꞌa mekule ka pauꞌakeo ponggawano lowono henu tegagi. Tekuda ngako ponggawano kano potae ndi atano, ‘Temongkadoto leko ai sala langkai ka sala dedeiki ai laro inie langkai. Umari laꞌa waweiro ramai mia karampini, mia salantuwu, mia morawu kaa mia luuka.’ ");
INSERT INTO pdo_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Umarino umanggaꞌo mbio henu nopinarentaꞌako, ata laꞌa melapuru ndi ponggawano, ‘Ponggawa, oto kuleluꞌo mbio henu oto aitenaꞌaku kanggo da orao pentoroꞌa henu molie.’ ");
INSERT INTO pdo_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Umari laꞌa ponggawa laꞌa mepau mboꞌu ndi atano, ‘Lekoto ai sala langkai kaa sala dedeiki ai saliwano inie langkai. Dadasiꞌiro baineitokaa mia hinawemu karo memai kano bukekaa rahanggu.’ ");
INSERT INTO pdo_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ka ai mpewowoloꞌo! Lalau napo teꞌaso mia henu umarito kupeboio laꞌa minggi lumeꞌoleꞌongo kaanga henu kupalenaꞌakero!” ");
INSERT INTO pdo_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Umari laꞌa orao mia henu tumondaꞌo i Yesu ai laro koleko-lekoaNo. Nopewolili ndi umboro ka Nopotae, ");
INSERT INTO pdo_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Bano sombo mia henu mai ndi Iaku ka lano mokokatongakeo umano, ineno, somborino, anano, petia tamano ba petia irowaino, otokaa koroino, umono lano bisa gagi anaguruNggu. ");
INSERT INTO pdo_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Mia henu lano behe poꞌahango kau pinotambano kaa tumondaꞌAku, lano bisa gagi anaguruNggu. ");
INSERT INTO pdo_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Pompotuimu minggi tumondaꞌAku Kupokopenggenaho menggena sirime nie, Taꞌalu nio ai olomiu minggi mowangu aso manara, matantu seꞌeluno nominggi mentoro dumoaꞌo doi henu minggi pinake mowangu manara kano toꞌoriokaa oto sangkakee ba ambokee doino laꞌa hawe kano umari anggaꞌa laꞌa. ");
INSERT INTO pdo_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Indonoꞌo teꞌingga butu notuꞌaio mowangu pentoroꞌano raha kaa lano tuꞌaio mokoꞌumario. Akono bano romesueꞌo mia teꞌingga olo rompoꞌawaꞌakeo ");
INSERT INTO pdo_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","ka rompotae, ‘Umono mowangu manara kanggo lano tuꞌaio mokoꞌumario. ");
INSERT INTO pdo_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Ba sirime mesueno, taꞌalu aso datu mompeꞌue hopulo sowu sorodadu, kanggo datu mesue mompeꞌue ruapulu sowu sorodadu minggi sumapoio, matantu datu henu mompeꞌue hopulo sowu sorodadu olo mentoro ari tumimbatimbaꞌo, pontuaikee meꞌewaꞌo uweli laꞌa. ");
INSERT INTO pdo_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Bano toꞌorio motae sorodaduno laro pokonangio uwelino laꞌa, gagi tempono da olai uwelino, umono minggi montena baꞌopioꞌiro mia lumeko mpoꞌema karo mentepomoiko.’ ” ");
INSERT INTO pdo_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Kanoꞌamba i Yesu motae, “Hilaꞌato mboꞌu ikomiu. Taꞌalu lai mebintango lowono henumiu, lai mebisa gagi anaguruNggu. ");
INSERT INTO pdo_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Ohio laꞌa moiko, kanggo bano ohio andono mokara lalau buano, ");
INSERT INTO pdo_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","lano moiko tiano lere maupo gagi pupu. Pokotombaꞌano ohio laꞌa tinadi. Ainei mebiri, noporongoito!” ");
INSERT INTO pdo_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Ai aso olo, umboro toposima kaa mboꞌu orao mia ntehala menggena mondeeno hawe mperorongoi pompaguruNo i Yesu. ");
INSERT INTO pdo_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Masa mpoꞌamu-amu to Parisi kaa Guru Agama sumueꞌo kegagia laꞌa, rompotae, “Eii, Umono tumarimaꞌiro mia ntehala kaa monggaa merongangiro!” ");
INSERT INTO pdo_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Ooto kano i Yesu mompauꞌakero sirime nie, ");
INSERT INTO pdo_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Bano nio aso mia umbu ai olomiu nie mompeꞌue aso etu bimba, kanoꞌamba notoꞌorio tetadi aso bimbano laꞌa, mbiokee henu minggi nowowauo? Konggonokaa nobintango sio pulu kaa osio bimbano laꞌa ai konde meseko kano leko wusuꞌo bimba henu tetadi laꞌa hawe kano konaio. ");
INSERT INTO pdo_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Towono nohaweꞌo bimba henu tetadi laꞌa, umono mompemangaꞌu ka nosinggemalaꞌo bimba laꞌa kano waweo mekule ai lembarano. ");
INSERT INTO pdo_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Haweno ai raha, nopeboio wali-walino kaa petengi-tengi rahano ka nopotae, ‘Maito kato memangaꞌu akono oto kuhaweꞌo bimbanggu henu tetadi!’ ");
INSERT INTO pdo_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Kupauꞌakomiu, ‘Menggena ulaꞌato mboꞌu Ue Ala kaa lowono mia henu moꞌia ai suruga memangaꞌu ngako tempono romesueꞌo aso mia tehala henu tesisi, kaseko sio pulu kaa osio mia henu mentee tinuwuro henu romengkoꞌaraꞌara laro memparalu mentesisi.’ ” ");
INSERT INTO pdo_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Kanoꞌamba i Yesu mompauꞌakero mboꞌu aso sirime. Nopotae, “Bano nio aso irowai henu mompeꞌue hopulo doi pera kaa tetadi aso mata doi, konggonokaa mosunu palita kano roahio laro rahano kanoꞌamba wusuꞌo takau aso doi perano henu tetadi laꞌa hawe kano haweꞌo. ");
INSERT INTO pdo_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Towono nohaweꞌo doi perano laꞌa, nopeboio wali-walino kaa lowono petengi-tengi rahano kano potae, ‘Maito kato memangaꞌu akono oto kuhaweꞌo doi peranggu henu tetadi!’ ");
INSERT INTO pdo_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Iaku motaeꞌakomiu, ‘Menggena ulaꞌato mboꞌu malaꞌeka-malaꞌekaRo Ue Ala memangaꞌu akono aso mia tehala henu tesisi!’ ” ");
INSERT INTO pdo_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","I Yesu pauꞌakero mboꞌu sirime nie, “Nio aso uma mompeꞌue oruo ana ntama. ");
INSERT INTO pdo_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Nopotae ana poꞌohuo ndi umano, ‘Uma, poweeꞌakuto hilinie agaagando henu gagi tianggu.’ Gagi umano tumiaꞌo agaagaro ndi koꞌoruo anano. ");
INSERT INTO pdo_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Bakoꞌopiono olo, ana poꞌohuo laꞌa umasaꞌo lowono agaaga tiano kanoꞌamba lumeko ai poꞌianga henu olai ngako. Lehea nosia-siaꞌo doino montonda manggerupa ineheno. ");
INSERT INTO pdo_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Towono pinggoto doino, tegagi abalaa mokoninggoꞌa ai poꞌianga laꞌa ooto kano marasai tinuwuno. ");
INSERT INTO pdo_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Gagi umono lumeko moꞌema anggaꞌa ndi aso ponggawa henu lehea. Mia laꞌa moweeꞌakeo anggaꞌa ooto mogagai boe ai lere. ");
INSERT INTO pdo_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Mokoninggo ngako ana poꞌohuo laꞌa hawe-hawe nomokokumaango paka boe laꞌa kanggo lalau napo teꞌaso mia henu moweeꞌakeo kaanga. ");
INSERT INTO pdo_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Kanoꞌamba nopenonohoꞌo tinuwuno ka nopepau ai laro aroano, ‘Lowono mia henu moꞌangga ndi umanggu mentorea kangaaro, kanggo iaku endea minggi maate ako ninggo! ");
INSERT INTO pdo_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Laluombo kupekule ndi umanggu ka motaeꞌakeo, Uma, akuto tehala ndi Ue Ala kaa ndi ikomiu. ");
INSERT INTO pdo_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Andono kono iaku nie ninee anamiu. Uma, poꞌinengangguto gagi mia sinaromiu.’ ");
INSERT INTO pdo_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Gagi umono mewungguako mekule ndi umano. Da olai oto nosueꞌo umano ana poꞌohuono laꞌa oto kano telelu aroa pompehohawano. Melulu umano tumowoꞌo ana poꞌohuono laꞌa kano rakoꞌo ka umikiꞌo. ");
INSERT INTO pdo_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Nopotae ana poꞌohuo laꞌa ndi umano, ‘Uma, akuto tehala ndi Ue Ala kaa ndi ikomiu. Andono kono iaku nie ninee anamiu.’ ");
INSERT INTO pdo_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Kanggo umano motaeꞌakero atano, ‘Pongkado mai waweeo parewa henu moiko, kaa pokonoꞌakeo sisi ai tongisono, kaa sapatu ai kareno. ");
INSERT INTO pdo_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Kaa aleoto ana sapi henu monuwo, sampaꞌo ka nahuakito kato mponggaa kaa memangaꞌu! ");
INSERT INTO pdo_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Akono ananggu menggena oto maate, kanggo hilinie tuwu euno, umono menggena oto tetadi kanggo hilinie hinawe euno.’ Gagi pompamula iroto pomposara. ");
INSERT INTO pdo_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Tempono posaraꞌa laꞌa tegagi, amba anano tekonai ai lere. Towono nopekule kaa oto umbeda ai rahano, norongoio maroa mia mpenani kaa mpenari. ");
INSERT INTO pdo_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Kano peboio aso ata kaa mesikeno ndi umono, ‘Pombio mia kano memaroa ai raha?’ ");
INSERT INTO pdo_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Sumangki ata laꞌa, ‘Haemiu oto mekule gagi umamiu mosampaꞌakeo ana sapi henu monuwo akono oto nohaweꞌo anano da tuwu moroso.’ ");
INSERT INTO pdo_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Gagi tekudato amba ana laꞌa ka lano behe mendamo ai raha. Oto kano peluarako umano umoꞌahitio kano pendamo. ");
INSERT INTO pdo_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Nopotae ndi umano, ‘Oto mataꞌu-taꞌu kupoꞌangga tiamiu ka laku huru umewa komiu, kanggo lai huru moweeꞌakune aso ana bembe kakupowowau posaraꞌa saru wali-walinggu. ");
INSERT INTO pdo_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Kanggo anamiu laꞌa oto nopinggoꞌo agaagamiu, noleko mebawaa saru bandara, kanggo dapono hawe ikomiu mosampaꞌakeo aso ana sapi henu monuwo!’ ");
INSERT INTO pdo_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Nopotae umano ndi anano henu amba-ambano, ‘Ananggu, iikokaa mpihe meronga iaku, kaa lowono agaaganggu oto agaagamu mboꞌu. ");
INSERT INTO pdo_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Kanggo haemu laꞌa menggena oto maate, kanggo hilinie tuwu euno, umono menggena oto tetadi kanggo hilinie hinawe euno. Gagi paralu ikito mpowowau posaraꞌa kaa memangaꞌu.’ ” ");
INSERT INTO pdo_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","I Yesu motae mboꞌu ndi anaguruNo, “Nio aso mia suugi mompeꞌue aso topoꞌurusu doi ka agaagano. Mia suugi laꞌa rumongoio lele motae topoꞌurusu doi ka agaagano laꞌa oto nosia-siaꞌo doi ka agaagano. ");
INSERT INTO pdo_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Gagi mia suugi laꞌa meboio topoꞌurusu doi ka agaagano kano potae, ‘Ooto kurongoio lele motae lano mentee inanggamu. Oto kaku peboiko ka minggi kupenaohakomu. Kanggo seꞌeluno kupoꞌema kau ukiꞌo lowono doi ka agaaganggu henu au urusuꞌo kau amba weeꞌakune.’ ");
INSERT INTO pdo_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Topoꞌurusu doi ka agaaga kopau-pau ai laro aroano, ‘Gagi mbiokee henu kupowowau hilinie? Akono ponggawanggu laꞌa matantu nopenaohakune. Moꞌangga ai lere laku moroso, ka moꞌema-ema iakukaa mboꞌu mokokohenu. ");
INSERT INTO pdo_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Nio akalanggu baku pinenaohako umbu ai anggaꞌanggu nie. Iaku minggi mowusu mia henu behe tumarimaꞌAku ai raharo.’ ");
INSERT INTO pdo_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Kanoꞌamba topoꞌurusu doi ka agaaga laꞌa meboio teꞌoꞌaso mia henu mepasua ndi ponggawano. Umono mesikeno ndi mia henu amba-ambano, ‘Opiokee pasuamu ndi ponggawanggu?’ ");
INSERT INTO pdo_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Sumangki mia laꞌa, ‘Aso etu kusi boka saitu.’ Kano potae mboꞌu ndi mia laꞌa, ‘Tinie sura pasuamu, pentoroto ka ukiꞌo serio gagi lima pulu kusi tokaa.’ ");
INSERT INTO pdo_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Kanoꞌamba nopotae ndi mia henu koꞌoruo, ‘Opiokee pasuamu?’ Sumangki mia laꞌa, ‘Aso sowu karu batari.’ Nopotae mboꞌu ndi mia laꞌa, ‘Tinie sura pasuamu, ukiꞌo serio gagi oalu etu karu tokaa.’ ");
INSERT INTO pdo_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Towono mia suugi laꞌa rumongoio mbio henu nowowauo topoꞌurusu doi ka agaaga henu megaupi laꞌa, nopotae, ‘O petia, ikoka suꞌu lalompande.’ ” Kanoꞌamba i Yesu motae ndi anaguruNo, “Mentee suꞌu mia ai tolino nie lalompande umurusuꞌo tinuwuro mia tolino kaseko mia henu tuwu ai laro mowineꞌa ka tumondaꞌo parentaRo Ue Ala.” ");
INSERT INTO pdo_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Ooto kaKu pesuꞌuio motae ndi ikomiu, “Pakeoto sugiꞌa ai tolino nie mpowusu wali-walimiu, gagi bano sugiꞌamiu ai tolino nie oto pinggo, ikomiu minggi tinarima ai raha henu lalau tampulaꞌano.” ");
INSERT INTO pdo_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Sombo mia henu metenunu ai laro kara-kara henu dedeiki oloka metenunu mboꞌu ai laro kara-kara henu langkai. Kanggo sombo mia henu megaupi ai laro kara-kara henu dedeiki, umono megaupi mboꞌu ai laro kara-kara henu langkai. ");
INSERT INTO pdo_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Gagi bano lau pineꞌalo-alo umurusuꞌo agaaga ai tolino nie, matantu Ue Ala mboꞌu laRolei meꞌalo-alo komiu agaagaRo henu ai suruga. ");
INSERT INTO pdo_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ka bano ikomiu lano metenunu moꞌurusu agaagano mia tolino, aineikee henu behe moweeꞌakomiu tuwua lano huru tampula? ");
INSERT INTO pdo_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Lalau ata henu poli momparakai oruo ponggawa. Akono bano menggena ulaꞌa minggi nomokokatoꞌakeo henu asono ka nopehohawaꞌo henu mesueno, ba umono minggi metenunu ndi henu asono kaa lano periongo henu mesueno. Lai mebisa mpesomba ndi umboro Ue Ala ka mpesombaio doi.” ");
INSERT INTO pdo_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Tempono to Parisi rumongoio pompaguruno i Yesu laꞌa, rompoꞌawaꞌakeO, akono mangaꞌuro io doi. ");
INSERT INTO pdo_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Kanggo i Yesu motaeꞌakero, “Ikomiu mokomenteeꞌo koroimiu ai arono mia mesue, kanggo Ue Ala tumoꞌorio mbio henu nio ai laro aroamiu. Akono mbio henu romentengiriꞌakeo mia Romokokatoꞌakeo Ue Ala. ");
INSERT INTO pdo_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Songkaro i Musa kaa lowono surano nabi, mpihe pinake hawe ai tempono i Yohane Mpuupodolo. Mompamula tempo laꞌa Kareba Moiko mongkono PomparentaꞌaRo Ue Ala mpihe pinalele kaa mia merokuhi karo tepondamo ai laro PomparentaꞌaRo Ue Ala. ");
INSERT INTO pdo_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Kanggo da moruana langi kaa wawontolino puuta kaseko aso titi umbu ai songkaro i Musa lano gagi. ");
INSERT INTO pdo_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Bainei notepobindaꞌakeo somborino kaa mesombori mboꞌu saru irowai mesueno, tama laꞌa mososabo. Kaa bainei mesombori saru irowai henu notepobindaꞌakeo somborino, tama laꞌa mososabo mboꞌu.” ");
INSERT INTO pdo_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Kanoꞌamba i Yesu paguruꞌiro mboꞌu ako sirime nie, “Nio aso mia suugi henu mpihe meparewa moiko kaa masuli. Manangai tinuwuno ka mowowau posaraꞌa sombo olo. ");
INSERT INTO pdo_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Nio mboꞌu aso mia karampini henu moꞌema-ema neeno ai Lasaru henu mereke aso koroino, pinolero ai pangaso rahano mia suugi laꞌa. ");
INSERT INTO pdo_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","I Lasaru mokompongga toreano kaanga henu modonta umbu ai wawo megano mia suugi laꞌa. Kanggo henu takau mokoburu io dahu hawe sumilaꞌeo rekeno. ");
INSERT INTO pdo_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Kanoꞌamba maate mia karampini laꞌa ka romewaweo malaꞌeka ai poꞌianga pinelangkai ai awino i Burahima ai suruga. ");
INSERT INTO pdo_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Mia suugi laꞌa maate mboꞌu kano kinaburu. Tekonai marasai ngako nohoringo ai laro naraka, umono mesonge kano sueꞌo umbu ai olaingano i Burahima mentoro ka nio i Lasaru ai horino. ");
INSERT INTO pdo_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Kano petulura mia suugi laꞌa, ‘O Uma Burahima, pehohawaꞌaku! Iakuto takau marasai ai laro apui naraka nie. Tenaꞌoto i Lasaru sie dumalongo tongisono ai laro uwoi ka mai wahaꞌo elonggu, kano morini-rini!’ ");
INSERT INTO pdo_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Kanggo nosangkiꞌo i Burahima, ‘O ana, pewowoloꞌo tempono au tuwu ai tolino. Ikoto tuwu manangai kanggo i Lasaru tuwu marasai. Hilinie endea umono mohawe manangaiꞌa ka serio iiko marasai. ");
INSERT INTO pdo_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ka mboꞌu ai olondo nie oto winowau wingke henu onalo, gagi lakibisa mesaki serio kaa iko lau bisa mai endea.’ ");
INSERT INTO pdo_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Mia suugi laꞌa motae mboꞌu, ‘Bano helilaꞌa kupoꞌema suꞌu ndi ikomiu uma, tenaꞌoto umono lumeko ai raharo umanggu. ");
INSERT INTO pdo_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Akono danio olimo iropo peꞌaso komponggu. Tenaꞌo i Lasaru lumeko mompotoꞌoriꞌakero karo indoro mpendamo ai poꞌianga henu marasaiꞌa nie.’ ");
INSERT INTO pdo_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Kanggo i Burahima motae, ‘Ndi umboro nio sura songkaro i Musa kaa suraro nabi. Poꞌinengiroto karo meleluꞌo mbio henu teꞌuki lehea.’ ");
INSERT INTO pdo_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Sumangki mia suugi laꞌa, ‘Lano sangka bano butu ulaꞌa. Kanggo bano nio aso mia henuto maate lumeko ndi umboro, iro minggi mentesisi.’ ");
INSERT INTO pdo_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Kanggo nopotae i Burahima ndi mia suugi laꞌa, ‘Taꞌalu umboro laro mentondaꞌo mbio henu teꞌuki ai laro songkaro i Musa ka suraro nabi, larolei pompeꞌalo-alo maupo nio mia henu muule lumeko mompauꞌakero.’ ” ");
INSERT INTO pdo_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Nopotae i Yesu ndi anaguruNo, “Konggonoka nio mbio henu romewowauo mia karo mentehala. Kanggo memasolato mia henu ako gauro, mia mesue mowowau hala. ");
INSERT INTO pdo_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Daloꞌo moiko bano umono pineꞌeno-enoꞌako wasu henu langkai ai weꞌuno, kanoꞌamba pinetadiako ai laro ntahi henu onalo, kaseko ako gauno aso mia umbu ai mia henu mompeꞌalo-alo henu lano moroso nie mowowau hala, umono olo dinosa mobea. ");
INSERT INTO pdo_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Pekarieꞌo koroimiu! Bano petiamiu mowowau hala kai mpeꞌetahakeokaa, ka bano umono mompesosoo kai oninio halano. ");
INSERT INTO pdo_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Maupo nopowowau mboꞌu hala ndi iiko menggopitu aso olo kaa menggopitu mboꞌu nohawe ndi iiko kaa motae, ‘Iaku mompesosoo, pehohawaꞌaku ka oninio halanggu’, gagi iiko olo umoninio halano.” ");
INSERT INTO pdo_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Kanoꞌamba anaguruNo laꞌira mpotae ndi Ue Yesu, “Ue, pokomorosoꞌo pompeꞌalo-alomami.” ");
INSERT INTO pdo_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Nopotae Ue Yesu, “Bano nio pompeꞌalo-alomiu henu langkaino menggena wuku rawoho tokaa, ikomiu poli mpotae ndi puꞌuno ara nie, ‘Tewekato iiko ka tepaho ai tahi,’ matantu olo notondaꞌo parentamu.” ");
INSERT INTO pdo_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Kanoꞌamba i Yesu motilaloꞌakeo pompaguruNo, “Taꞌalu ai olomiu nio henu mompeꞌue aso ata henu motengko ai lere ba mompakambi bimbamiu, towono pekule ata laꞌa umbu ai lere, konggonokaa lailei mpotae ndi umono, ‘Mai pendamo kato mponggaa.’ ");
INSERT INTO pdo_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Kanggo ikomiu olo mpotae ndi ata laꞌa, ‘Ponahuꞌakune kaanga. Pakeꞌo parewa poꞌangga ai laro raha kaa emanganggu hawe kaku umari monggaa. Umaripo laꞌa kau amba monggaa.’ ");
INSERT INTO pdo_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Matantu lailei montarimakase ndi ata laꞌa maupono umarito noparakai komiu. ");
INSERT INTO pdo_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Hilaꞌato mboꞌu ikomiu. Bano ikomiu umarito umanggaꞌo lowono henu Rotenaꞌakomiu Ue Ala, potaeto, ‘Ikami butukaa ata lalau tuduno, ikami butu meꞌanggaꞌo mbio henu kimentinenaꞌako.’ ” ");
INSERT INTO pdo_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Ai laro koleko-lekoaro lumeko ai Yerusale, i Yesu ka anaguruNo lumaloo tidano wute Samaria ka Galilea. ");
INSERT INTO pdo_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Temporo mpendamo ai aso inie, hopulo tama henu memelowe hawe tumowoꞌo i Yesu kanggo umboro mpenggoti umbu olai ");
INSERT INTO pdo_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","ka mengkumora, “Yesu, Guru, pehohawa kami!” ");
INSERT INTO pdo_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Tempono i Yesu sumueꞌiro Nopotae, “Aimelekoto ndi Petewawo Pesomba tisoꞌakero koroimiu.” Tekonairo mengkoleko-leko, masa tomba lowero. ");
INSERT INTO pdo_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Aso mia umbu ai oloro, tempono nosueꞌo koroino oto tomba, umono mekule ndi Yesu kano kokora-kora umundeꞌiRo Ue Ala. ");
INSERT INTO pdo_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Kanoꞌamba umono menggolutu ai arono i Yesu kano poꞌunde kaa montarimakase. Mia laꞌa to Samaria. ");
INSERT INTO pdo_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Kanoꞌamba i Yesu motae, “Lanoꞌokee hieno nio hopulo mia henu toomba? Ainderioto henu osioꞌiro? ");
INSERT INTO pdo_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Akombio kano butukaa mia henu lanoꞌo to Yahudi nie henu mekule montarimakase ndi Ue Ala?” ");
INSERT INTO pdo_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Kanoꞌamba i Yesu motae ndi mia laꞌa, “Pewanguto, kau pekule. Akono pompeꞌalo-alomu ndi Iaku, iiko toomba.” ");
INSERT INTO pdo_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Baꞌopioꞌiro to Parisi mpesikeno ndi Yesu, “Teꞌepiepo PomparentaꞌaRo Ue Ala pinamula?” I Yesu sumangki, Nopotae, “Pompamulaꞌano PomparentaꞌaRo Ue Ala lano penggena ako petondonino henu sinueno matando, ");
INSERT INTO pdo_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","ka mboꞌu mia lano bisa motae, ‘PomparentaꞌaRo Ue Ala nio endea’ ba ‘nio lehea’. Akono menteeꞌano PomparentaꞌaRo Ue Ala ai wawontolino oto nio ai olomiu.” ");
INSERT INTO pdo_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Umari laꞌa i Yesu motae ndi anaguruNo, “Amba hawe tempono ikomiu moꞌosungakeo tempono Ana Manusia hawe komenggoruono, henu buke ako marambaꞌa ka manangaia ai tempo henu amba ramai. Kanggo lailei mesueꞌo. ");
INSERT INTO pdo_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Tempo laꞌa olo rompotae mia ndi ikomiu, ‘Kiteo, i Yesu nio endea!’ ba ‘Umono nio lehea!’ Kanggo indo aimpeꞌale-aleo kaa indo meleko ai poꞌianga henu nineero. ");
INSERT INTO pdo_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Akono ai olo haweno Ana Manusia menggena wanta koliki henu mokomowineꞌo langi umbu ai tapuno langi hawe ai tapuno langi mesueno. ");
INSERT INTO pdo_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Kanggo seꞌeluno Iaku Ana Manusia olo humoringo orao marasaia ka mia henu tuwu ai tempo nie laro mentarimaꞌAku. ");
INSERT INTO pdo_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Menggena tinuwuro mia tempono i Noho hilaꞌato mboꞌu henu minggi tegagi ai tempo haweꞌano Ana Manusia. ");
INSERT INTO pdo_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Mia mponggaa, mpoꞌinu, mpesombori ka pinokosombori, hilaꞌato mpihe hawe kano i Noho mendamo ai laro bangka, kanoꞌamba hawe lolowi karo meropu lowo. ");
INSERT INTO pdo_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Hilaꞌato mboꞌu tempono i Loꞌoti. Mia mponggaa mpoꞌinu, mpoꞌasa mpoꞌoli, mpompaho kaa mpowangu raha. ");
INSERT INTO pdo_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Kanggo tempono i Loꞌoti meluarako umbu ai Sodomo, use apui ka balera metii umbu ai langi karo meropu lowo. ");
INSERT INTO pdo_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Hilaꞌato notegagi soongka bano Ana Manusia mokoꞌenaho koroiNo. ");
INSERT INTO pdo_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Ai olo laꞌa mia henu tekonai ai wawono ato raha indono petii umaleo agaagano ai laro raha. Hilaꞌa mboꞌu mia henu tekonai ai lere, indono pekule ai rahano. ");
INSERT INTO pdo_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Ai mpewowoloꞌo mbio henu umarito tegagi ndi somborino ai Loꞌoti! ");
INSERT INTO pdo_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Akono bainei henu merokuhi kumaduduio tinuwuno olo tetadi tinuwuno. Kanggo bainei henu tetadi tinuwuno akono Iaku, umono olo kinadudui. ");
INSERT INTO pdo_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Kupauꞌakomiu, ai wongi laꞌa oruo mia meꞌaso mpoturi, aso mia minggi nowaweo malaꞌeka kaa aso mia minggi bininta. ");
INSERT INTO pdo_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Oruo irowai tekonai meronga-ronga mogili batari, henu aso minggi winawo kaa henu asono minggi bininta.  ");
INSERT INTO pdo_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Kaa bano oruo mia tekonai moꞌangga ai lere, aso minggi winawo kaa asono minggi bininta.” ");
INSERT INTO pdo_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","AnaguruNo mesikeno ndi Yesu, “Ainderiokee ulaꞌa minggi tegagi, Ue?” Ka Nosangkiꞌiro, “Ainderio nio bake mewoo, lehea paa-paa mpewuwui.” ");
INSERT INTO pdo_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Umari laꞌa i Yesu paguruꞌiro anaguruNo ako sirime karo mpihe mpekakai ka lano tampula pomperorohiaro. ");
INSERT INTO pdo_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Nopotae i Yesu, “Ai aso inie langkai nio aso poꞌutuhi kara-kara henu lano momee ndi Umboro Ue Ala ka lano peꞌiꞌindongo peꞌasomiano. ");
INSERT INTO pdo_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ai inie langkai laꞌa nio mboꞌu aso waalu henu mpihe lumeko moꞌema kano i poꞌutuhi kara-kara laꞌa tumulungio umaropio uwelino. ");
INSERT INTO pdo_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Baꞌopio epieno poꞌutuhi kara-kara laꞌa lano behe tumulungio waalu laꞌa. Kanggo amba nopotae ai laro aroano, ‘Maupo laku momee ndi Umboro Ue Ala ka laku peꞌiꞌindongo peꞌaso mianggu, ");
INSERT INTO pdo_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","kanggo akono waalu laꞌa mpihe mokorituꞌaku, moikoꞌano kutulungio umaropio kara-karano. Kano indono mpihe mai mokorituꞌaku.’ ” ");
INSERT INTO pdo_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Kanoꞌamba Ue Yesu motae, “Pekokoongo mbio henu nopauꞌo poꞌutuhi kara-kara henu lano mentee leluno laꞌa! ");
INSERT INTO pdo_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Bano behe tumulungio kara-karano waalu laꞌa, matantu Ue Ala olo tumulungiꞌiro umboro henu bininikiRo gagi miaRo henu mpihe moꞌema sombo olo. Umboro larolei telaa tumulungiꞌiro. ");
INSERT INTO pdo_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Peꞌale-aleoto motae, Ue Ala ronga tumulungiꞌiro umaropio kara-kararo. Maupono menggena ulaꞌa, tempono Iaku, Ana Manusia hawe euno, ambono matantu Kuhaweꞌo mia ai tolino nie henu da pompeꞌalo-alo ndi Iaku.” ");
INSERT INTO pdo_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Kanoꞌamba ndi baꞌopioꞌiro henu meꞌale-aleo motae laro ntehala ai aroro Ue Ala, ka metotoakero peꞌasomiano, i Yesu mompauꞌakero sirime nie, ");
INSERT INTO pdo_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Nio oruo mia lumeko ai Raha Mempori ka mpekakai, aso to Parisi ka asono mboꞌu toposima. ");
INSERT INTO pdo_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","To Parisi laꞌa menggoti aso-asono kaa mekakai, ‘O Ue Ala, iaku moꞌunde ndi Ikomiu, akono laku penggena mia mesue, laku ponako, laku pesetaki, ka laku pososabo. Ka iaku mboꞌu moꞌunde akono laku penggena saru toposima nie. ");
INSERT INTO pdo_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Ai laro opitu olo iaku mepuasa oruo olo ka tia hopulo henu kupohawe umbu ai poꞌanggaꞌanggu kupesombaꞌako ndi Ikomiu Ue Ala.’ ");
INSERT INTO pdo_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Kanggo toposima laꞌa menggoti halaꞌolai umbu ai mia mesueno ka lano taha mesonge ai langi, nolori-loriho radano ka motae, ‘Oo Ue Ala, pehohawaꞌaku mia tehala nie.’ ");
INSERT INTO pdo_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Kupauꞌakomiu, ‘Toposima nie mekule ai rahano oto tinolosi halano kanggo to Parisi laꞌa lano tinolosi. Akono bainei melangkaiꞌo koroino olo pinetotoako ka bainei meꞌurumako koroino olo pinelangkai.’ ” ");
INSERT INTO pdo_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Baꞌopioꞌiro mewaweo ana-anaro henu da dedeiki ndi Yesu, kano i Yesu uminiꞌo uluro ka barakatiꞌiro. Tempono anaguruNo sumueꞌo ulaꞌa romeꞌontongiro. ");
INSERT INTO pdo_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Kanggo i Yesu meboio ana-ana laꞌira ka Nopotae ndi anaguruNo, “Poꞌinengiroto mai ndi Iaku, kaa indo mebentengiro, akono mia henu menggena unieto henu minggi gagi miaRo PomparentaꞌaRo Ue Ala. ");
INSERT INTO pdo_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Pewowoloꞌo! Bainei lano tarimaꞌo PomparentaꞌaRo Ue Ala menggena ana-ana dedeiki nie, umono lano tinarima gagi miaRo PomparentaꞌaRo Ue Ala.” ");
INSERT INTO pdo_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Aso petewawo to Yahudi mesikeno ndi Yesu, “Guru henu moiko, mbio henu olo kuwowauo kakupohawe tuwua lalau tampulaꞌano?” ");
INSERT INTO pdo_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Kanggo i Yesu loꞌoka mesikeno, “Akombio kau potae Iaku moiko? Butukaa Ue Ala henu moiko lalau mboꞌu mesueno. ");
INSERT INTO pdo_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Oto kau toꞌorio songkaRo Ue Ala nie, ‘Indo pososabo, indo pompepate, indo ponako, indo pesetaki mongkono peꞌaso miamu kaa pelangkaiꞌiro mia mosuꞌomu.’ ” ");
INSERT INTO pdo_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Kanoꞌamba petewawo to Yahudi laꞌa motae, “Lowono songkaRo Ue Ala laꞌa oto kuwowauo umbu da kumonguro.” ");
INSERT INTO pdo_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Rumongoio pauno petewawo to Yahudi laꞌa, i Yesu motaeꞌakeo, “Danio asopo mboꞌu henu olo au wowauo, pekuleto ka asaꞌo lowono agaagamu kau amba tumiatiaꞌo doino ndi mia karampini. Gagi ikomiu olo mohawe agaaga ai suruga. Umari laꞌa mai ndi Iaku kau tondaꞌAku.” ");
INSERT INTO pdo_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Tempono norongoio mbio henu nopauꞌo i Yesu laꞌa, masusa ngako aroano, akono umono suugi ngako ka lano behe umasaꞌo agaagano. ");
INSERT INTO pdo_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","I Yesu tumoꞌorio motae masusa ngako aroano petewawo to Yahudi laꞌa. Ooto kano potae, “Mapari suꞌu mia suugi gagi miaRo PomparentaꞌaRo Ue Ala! ");
INSERT INTO pdo_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Akono da moruana aso unta mendamo ai aano supe kaseko mia suugi gagi miaRo PomparentaꞌaRo Ue Ala.” ");
INSERT INTO pdo_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Toworo merongoio pauNo laꞌa, rompotae, “Bano helilaꞌa menteꞌano lalau mia henu olo kinadudui.” ");
INSERT INTO pdo_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Nopotae i Yesu, “Mbio henu lano poli nowowauo mia, poli Rowowauo Ue Ala.” ");
INSERT INTO pdo_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Kanoꞌamba i Peturu motae, “Helinde menggena ikami? Oto kimebintango lowono henumami ka tumonda Komiu.” ");
INSERT INTO pdo_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","I Yesu motaeꞌakero, “Kupauꞌakomiu, sombo mia henu nobintango rahano, somborino, petiano, mia mosuꞌono ba ana-anano ako PomparentaꞌaRo Ue Ala, ");
INSERT INTO pdo_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","olo notarimaꞌo saro umbu ndi Ue Ala henu maluka-luka ai laro tinuwuno hilinie ka ai tempo henu ramai Ue Ala olo meweangakeo tuwua lalau tampulaꞌano.” ");
INSERT INTO pdo_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","I Yesu meboio hopulo ka oruo anaguruNo ka motaeꞌakero, “Hilinie ikito mpeꞌeka ai Yerusale. Leheato lowono henu inukiro nabi mongkono Iaku, Ana Manusia, olo pinokosangka. ");
INSERT INTO pdo_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Akono Iaku olo pineweangako ndi mia henu lanoꞌo to Yahudi, Iaku olo pineꞌewe-ewe, pinesantalikiako ka inunui. ");
INSERT INTO pdo_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Amba laꞌa umboro minggi sumepiaKu ka mepateaKu, kanggo ai koꞌotoluno olo Iaku olo muule.” ");
INSERT INTO pdo_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Lowono pinauno i Yesu laꞌa lalau henu romentoꞌorio anaguruNo. Pengkonoano da tewuni umbu ndi umboro gagi laro mentoꞌorio mbio henu pinauNo laꞌa. ");
INSERT INTO pdo_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Tempono i Yesu ka anaguruNo oto umbeda ngako ai inie langkai Yeriko, nio aso mia morawu mentoro moꞌema-ema ai wiwi sala. ");
INSERT INTO pdo_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Akono norongoio memaroa mia henu mentelalo, umono mesikeno, “Nio mbiokee?” ");
INSERT INTO pdo_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Rompotaeꞌakeo, “I Yesu mia Nasare laꞌa telalo.” ");
INSERT INTO pdo_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Oto kano kumora, “Oo Yesu, Anani Daudi, pehohawaꞌaku!” ");
INSERT INTO pdo_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Kanggo umboro henu koleko-leko ai arono i Yesu tumenaꞌo kano indono pogero. Kanggo loꞌoka tetambai langkai nokumora, “Anani Daudi, pehohawaꞌaku!” ");
INSERT INTO pdo_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","I Yesu menao-nao ka tumenaꞌiro waweo mia morawu laꞌa ndi Umono. Tempono oto ai horiNo, i Yesu sumikenoo, ");
INSERT INTO pdo_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Io mbio inehemu kaKu powowauꞌakomu?” Mia morawu laꞌa sumangki, “Ue, kaku bisa mosue.” ");
INSERT INTO pdo_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Kanoꞌamba i Yesu mepau, “Bano helilaꞌa, penggitoto! Akono pompeꞌalo-alomu ndi Iaku, ikoto toomba!” ");
INSERT INTO pdo_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Ka tempo laꞌa mboꞌu mia laꞌa mosue, kano tondaꞌiro i Yesu ka umunde-undeꞌiRo Ue Ala. Lowono mia henu kumiteo kegagia laꞌa mboꞌu umunde-undeꞌiRo Ue Ala. ");
INSERT INTO pdo_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Towono i Yesu mendamo ai inie langkai Yeriko, Umono koleko-leko tumondaꞌo sala ai inie langkai laꞌa. ");
INSERT INTO pdo_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Lehea nio aso ponggawano toposima henu suugi, neeno ai Sakeu. ");
INSERT INTO pdo_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Umono mokosumueꞌo i Yesu, kanggo lano pokosueꞌo akono umono owu-owundu ka orao mia lehea. ");
INSERT INTO pdo_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Gagi umono melulu meseꞌelumiiro, kano pomone ai puꞌuno kau ara kano sueꞌokaa i Yesu henu minggi lumaloo sala laꞌa. ");
INSERT INTO pdo_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Towono i Yesu hawe ai puꞌuno kau ara laꞌa, Nopesonge kano potae, “Oo Sakeu, pongkadoto petii, akono ineheRo Ue Ala Iaku merato ai rahamu.” ");
INSERT INTO pdo_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Mongkado-kado ai Sakeu metii kaa mangaꞌu ngako tumarimaꞌiro i Yesu ai rahano. ");
INSERT INTO pdo_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Lowono mia henu kumiteo kegagiaꞌa laꞌa koꞌise-ise, rompotae, “Eii, umono leko merato ai rahano mia ntehala.” ");
INSERT INTO pdo_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Kanggo ai Sakeu menggoti ka motae ndi Ue Yesu, “Ue, entonga umbu ai agaaganggu nie minggi kupeweeangakeo ndi mia karampini, ka bainei henu huru kusetakio mongkono simano minggi kupokuleꞌo opaa lukano.” ");
INSERT INTO pdo_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Kanoꞌamba i Yesu motaeꞌakeo ai Sakeu, “Olo nie iiko ka lowono mia ai laro rahamu oto kinadudui, akono iiko mboꞌu inuleno i Burahima. ");
INSERT INTO pdo_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Akono Iaku, Ana Manusia, hawe mowusu ka kumaduduio mia henu tesampu.” ");
INSERT INTO pdo_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Tekonairo da merorongoio ai Yesu mepau, Umono mompauꞌakero aso sirime. Akono tempo laꞌa Umono umbeda umbu ai Yerusale, ka romengkoꞌaraꞌara oto minggi pinamula PomparentaꞌaRo Ue Ala. ");
INSERT INTO pdo_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Nopotae helinie, “Nio aso mia umbu ai inuleno datu lumeko olai ai inie langkaino datu kano inengka gagi datu. Umari laꞌa umono olo mekule momparenta ai inieno. ");
INSERT INTO pdo_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ambono pewungguako, nopeboio hopulo atano kano weeꞌakeo teꞌoꞌasoro doi wulaa. Nopotaeꞌakero, ‘Aimpebalu-baluto ako doi sie hawe kaku pekule.’ ");
INSERT INTO pdo_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Kanggo mia ai inieno laꞌa memokokatongakeo mia henu minggi inengka gagi datu laꞌa. Gagi towono nopewungguꞌako, umboro montena baꞌopioꞌiro lumeko ndi datu langkai henu minggi umengkaho mia laꞌa gagi datu ai wutero, rompotae, ‘Laki mebehe mia laꞌa gagi datu ai iniemami.’ ");
INSERT INTO pdo_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Napono laro mebehe, mia umbu ai inuleno datu laꞌa loꞌoka inengka gagi datu, kanoꞌamba mekule ai inieno. Haweno lehea notenaꞌo mia meboio kohopulo atano kano toꞌorio opio saro rompohawe umbu ai pebalu-baluro sombo mia. ");
INSERT INTO pdo_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Ata henu koꞌaso hawe ka motae, ‘Oo datu, iakuto mobalu-balu ako aso doi wulaa henu ai weeꞌakune ka hilinie iakuto mohawe hopulo doi wulaa.’ ");
INSERT INTO pdo_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Datu laꞌa motaeꞌakeo, ‘Mentee winowaumu sie, iiko ata henu moiko. Akono iiko metenunu ai laro kara-kara henu dedeiki, iiko minggi momparenta ai hopulo inie langkai.’ ");
INSERT INTO pdo_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Kanoꞌamba ata henu koꞌoruo hawe ka motae, ‘Oo datu, iakuto mobalu-balu ako aso doi wulaa henu ai weeꞌakune ka hilinie iakuto mohawe olimo doi wulaa.’ ");
INSERT INTO pdo_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Nopotae ndi ata laꞌa, ‘Iiko minggi momparenta ai olimo inie langkai.’ ");
INSERT INTO pdo_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Kanoꞌamba ata henu mesueno hawe ka motae, ‘Oo datu tinie doi wulaamiu, loꞌoka kutongoho ai laro lenso. ");
INSERT INTO pdo_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Kumomeeꞌakomiu datu, akono ikomiu mia mosia. Ikomiu umaleo mbio henu lanoꞌo henumiu ka mesowi henu lano huru ai merawoho.’ ");
INSERT INTO pdo_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Datu laꞌa motae ndi umono, ‘Eii iiko ata henu moluwe, iaku minggi dumosako menggena paumu laꞌa. Ikoto tumoꞌorio motae iaku nie mosia, henu umaleo mbio henu lanoꞌo henunggu ka mesowi henu lano huru kurawoho. ");
INSERT INTO pdo_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Bano menggena ulaꞌa akombio lai peweangakeo doinggu ndi mia henu moꞌutangakeo doi kakupohawe sarono?’ ");
INSERT INTO pdo_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Kanoꞌamba datu laꞌa mepau ndi mia henu mpenggoti ai horino, ‘Aleo doi henu nio ndi umono ka weeꞌakeo ndi atanggu henu mompeꞌue hopulo doi wulaa laꞌa.’ ");
INSERT INTO pdo_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Kanggo umboro mpotae, ‘O Datu, umono oto mompeꞌue hopulo doi wulaa.’ ");
INSERT INTO pdo_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Nosangkiꞌo datu laꞌa, ‘Kupauꞌakomiu, sombo mia henu metenunu umanggaꞌo mbio henu Roweeꞌakeo Ue Ala ndi umono minggi pinowea mboꞌu. Kanggo bainei henu lano metenunu umanggaꞌo mbio henu nopinowea, mbio henu danio ndi umono minggi inalo mboꞌu. ");
INSERT INTO pdo_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Hilinie waweo ramai umboro henu mokokatongakune ka henu tai mebeheaku gagi daturo ka pepateiroto ai aronggu!’ ” ");
INSERT INTO pdo_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","UmariNo mompauꞌakero sirime laꞌa, i Yesu meseꞌelungiro koleko-leko ai aroro meꞌeka ai Yerusale. ");
INSERT INTO pdo_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Towono umbeda ai inie Bepage ka Betania ai Torukuno Saitu, i Yesu tumenaꞌo oruo anaguruNo. ");
INSERT INTO pdo_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Nopotae, “Lekoto ai inie ai aromiu laꞌa, baimpendamoto teꞌingga, ikomiu minggi humaweꞌo anano kalide ambono huru pinengarai henu inonggo umbeda rahano mia. Wowoho onggono ka waweo ramai. ");
INSERT INTO pdo_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Bano nio mia mesikeno ndi ikomiu, ‘Akombio kai mewowoho onggono?’ Sangkiꞌo menggena unie, ‘Ue Yesu paraluꞌo.’ ” ");
INSERT INTO pdo_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Kanoꞌamba melekoꞌiroto anaguruNo laꞌa, ka romehaweꞌo lowono gagi menggena mbio henu nopauꞌo i Yesu. ");
INSERT INTO pdo_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Tekonairo mowowo onggono anano kalide laꞌa, ueno motaeꞌakero, “Akombio kai mewowoho onggono kalide sie?” ");
INSERT INTO pdo_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Rosangkiꞌo, “Ue Yesu paraluꞌo.” ");
INSERT INTO pdo_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Kanoꞌamba romewaweo anano kalide laꞌa ndi Yesu, karo empehio pentoroꞌano ako kalambiro ka romentulungio i Yesu mewueꞌakeo ai kalide laꞌa. ");
INSERT INTO pdo_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Tempono i Yesu mengaraio kalide laꞌa mia orao mewolaꞌo kalambiro ai sala henu nolaloo i Yesu. ");
INSERT INTO pdo_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Tempono i Yesu umbeda ai Yerusale, ai sala monturungako umbu ai Torukuno Saitu, anaguruNo ka lowono mia henu mpihe tumondaꞌiro mompamula memangaꞌu ka umunde-undeꞌiRo Ue Ala ako suara langkai akono lowono tandangkohali-hali henuto romesueꞌo. ");
INSERT INTO pdo_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Rompotae, “Rinosoto Datu henu tinenaRo Ue Ala, roodo ai suruga ka maramba ai poꞌianga henu takau medongke!” ");
INSERT INTO pdo_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Baꞌopioꞌiro to Parisi umbu ai olono mia orao laꞌa mpotae ndi Yesu, “Guru, tenaꞌiroto karo mengkomino.” ");
INSERT INTO pdo_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Nopotae i Yesu, “Peꞌale-aleoto! Baro mengkomino, wasu niire olo mengkumora.” ");
INSERT INTO pdo_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Tempono i Yesu oto umbeda ngako umbu ai Yerusale, Nokiteo inie langkai laꞌa, ka Nopeꞌiwikio, ");
INSERT INTO pdo_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Nopotae, “Wainto ngako ikomiu mia Yerusale! Moikono olo nie aimentoꞌorio helinde kai tepomoiko mboꞌu saru Ue Ala ka peꞌaso miamu, kanggo hilinie ikomiu laimentoꞌorio! ");
INSERT INTO pdo_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Minggi hawe tempono uwelimiu mebolilingo iniemiu ako wala ka sumapoi komiu ka mpihe umewa komiu umbu ai lowono poꞌianga. ");
INSERT INTO pdo_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Umboro minggi mokoropukomiu oo Yerusale saru lowono mia ai inie langkaimiu, ka lalau napo teꞌaso wasu henu ropoꞌineengo tepoꞌapi. Unie tegagi akono laimentoꞌorio tempono Ue Ala hawe kumaduduikomiu.” ");
INSERT INTO pdo_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Kanoꞌamba i Yesu mendamo ai puu Raha Mempori kano mompamula tumambaꞌiro henu mpoꞌasa-asa lehea. ");
INSERT INTO pdo_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Nopotaeꞌakero, “Nio teꞌuki ai laro Sura Tutulu, ‘RahaNggu minggi gagi poꞌianga pekakaiꞌa.’ Kanggo oto ai mebaliꞌo gagi pewuniaro mia henu mponako.” ");
INSERT INTO pdo_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Sombo olo i Yesu mompaguru ai Raha Mempori. Umboro kapala Petewawo Pesomba ka Guru Agama saru petewawo to Yahudi merokuhi karo bisa pasalaꞌo ka mpepateo i Yesu. ");
INSERT INTO pdo_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Kanggo laro mentoꞌorio bambio henu minggi romewowauo, akono lowono mia mpihe mpoꞌia ai horiNo ka inehero merorongoio pompaguruno i Yesu. ");
INSERT INTO pdo_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Aso olo tekonaino i Yesu mompaguru kaa paleleꞌo Kareba Moiko ndi mia orao ai puu Raha Mempori, haweꞌiroto lehea Kapala Petewawo Pesomba, Guru Agama ka mia mosuꞌono to Yahudi ");
INSERT INTO pdo_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","ka rompotae ndi Yesu, “Kua pauꞌakami ako pabawa mbio Ikomiu wowauo lowono nie? Aineiokee henu moweeꞌaKomiu pabawa laꞌa?” ");
INSERT INTO pdo_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Sumangki i Yesu, “Iaku mboꞌu minggi mesikeno, kua pauꞌaKune, ");
INSERT INTO pdo_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","ai Yohane modolo ako pabawano aineio? Ako pabawaRo Ue Ala ba umbu ai pabawano mia tolino?” ");
INSERT INTO pdo_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Kanoꞌamba umboro mpebitara ai oloro, “Batompotae, ‘Umbu ai pabawaRo Ue Ala,’ Umono olo motae ndi ikito, ‘Bano helilaꞌa, ikomiu lano mentee akoro lano mpeꞌale-aleo mbio henu pinauno ai Yohane.’ ");
INSERT INTO pdo_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Kanggo batompotae, Umbu ai pabawaro mia tolino, lowono mia niire olo meratukito ako wasu hawe kato memate, akoro mpeꞌale-aleo ai Yohane io nabi.” ");
INSERT INTO pdo_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Gagi umboro mesumangki, “Laki mentoꞌorio ako pabawano aineio ai Yohane modolo.” ");
INSERT INTO pdo_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Kanoꞌamba i Yesu motaeꞌakero, “Bano helilaꞌa, Iaku mboꞌu laKu lei pauꞌakomiu ako pabawano aineio Kuwowauo lowoakoano nie.” ");
INSERT INTO pdo_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Kanoꞌamba i Yesu mompauꞌakero mia orao sirime mesueno, “Nio aso mia mowungge lere anggoro, kanoꞌamba nopesaroꞌakeo lereno ndi mia henu moꞌangga lere kanoꞌamba mewungguako lumeko ai inie mesueno ka epie nopoꞌia lehea. ");
INSERT INTO pdo_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Towono hawe tempono poꞌopua wue anggoro, ueno lere laꞌa montena atano lumeko ndi mia henu umanggaꞌo lereno laꞌa karo poweeꞌakeo asontia tiano umbu ai wueno lere laꞌa. Kanggo loꞌoka romerodoho ata laꞌa ka rotenaꞌo mekule ka lano powawo mbio-mbio. ");
INSERT INTO pdo_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Umari laꞌa umono montena mboꞌu ata henu mesueno, kanggo ata laꞌa mboꞌu loꞌoka rinodo ka pinokokohenu karo mentenaꞌo mekule ka lano powawo mbio-mbio. ");
INSERT INTO pdo_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Kanoꞌamba ueno lere laꞌa montena mboꞌu ata henu koꞌotolu, kanggo ata laꞌa loꞌoka rinodo mboꞌu hawe kano mobela kanoꞌamba pinetadiako ai saliwano lere laꞌa. ");
INSERT INTO pdo_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Pokoꞌariano ueno lere laꞌa motae, ‘Mbiotokaa mboꞌu henu kupowowau? Iaku minggi tumenaꞌo ananggu henu takau kuꞌoꞌoloio, matantu umono olo romemomeꞌakeo ka ropelangkaiꞌo’. ");
INSERT INTO pdo_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Kanggo towono mia henu umanggaꞌo lere laꞌa sumueꞌo anano ueno lere laꞌa, umboro mpepau-pau ‘Umonoto nie henu minggi meꞌueꞌo agaagano umano, maito kato mpepateo, kano agaagano laꞌa gagi henundo.’ ");
INSERT INTO pdo_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Karo membaerio anano ueno lere laꞌa hawe ai saliwano lere anggoro laꞌa karo pepateo.” Kanoꞌamba i Yesu mesikeno, “Gagi bano pekule ueno lere anggoro laꞌa, mbiotokaa henu minggi nopowowau ndi mia henu umanggaꞌo lere anggoro laꞌa? ");
INSERT INTO pdo_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Matantu umono olo hawe mepateiro mia henu umanggaꞌo lere anggoro laꞌa kanoꞌamba nopeꞌale-aleꞌakeo lereno ndi mia henu umanggaꞌo lere anggoro henu mesueno.” Rumongoio pau laꞌa mia laꞌira sumangki ndi Yesu, “Indono tegagi menggena ulaꞌa!” ");
INSERT INTO pdo_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","I Yesu menggito ndi umboro ka Nopotae, “Bano helilaꞌa mbio pengkonoano PauRo Ue Ala henu teꞌuki ai laro Sura Tutulu nie, Wasu henu tinadiro mia mperaha oto gagi wasu pentoroꞌano raha henu takau paralu. ");
INSERT INTO pdo_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Bainei henu modonta ai wawono wasu laꞌa olo tewuro, ka bainei henu nodusingo wasu laꞌa olo telata.” ");
INSERT INTO pdo_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Guru Agama kaa Kapala Petewawo Pesomba mentoꞌorio motae umboroto pengkonoano sirimeno ai Yesu laꞌa, ooto karo mperokuhi merakoꞌo i Yesu ai tempo laꞌa kanggo umboro memomee ako mia orao. ");
INSERT INTO pdo_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Akono usie Guru Agama ka Kapala Petewawo Pesomba kumikiteo i Yesu. Umari laꞌa rompobara baꞌopioꞌiro henu mompemiamoiko lumeko poporooꞌo i Yesu. Umboro tumenaꞌiro mpesikeno ndi Yesu karo haweꞌokaa halano i Yesu umbu ai pesangkiNo, karo bisa mpeweangakeo ndi Gubenuru kano inutuhi. ");
INSERT INTO pdo_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Mia henu mentinena poporoꞌo ai Yesu laꞌa mepau ndi Yesu, “Guru, kimentoꞌorio lowono pau kaa pompaguruMiu laꞌa mentee kaa Ikomiu mboꞌu lai mompoponggito, menteeꞌano Ikomiu paguru kami ineheRo Ue Ala ai laro tinuwumami.” ");
INSERT INTO pdo_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Gagi ikami minggi mpesikeno, “Bano montonda songkaro i Musa loꞌoka bisakee kimpobara sima ndi Datu Langkai?” ");
INSERT INTO pdo_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Kanggo loꞌoka notoꞌorio i Yesu io akalaro henu mosaꞌa oto kaNo potaeꞌakero, ");
INSERT INTO pdo_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Kua popokiteoꞌAkune aso doi pera, raꞌino kaa neeno aineikee inuki lehea?” RosangkiꞌIro, “Raꞌino kaa neeno ai Datu Langkai.” ");
INSERT INTO pdo_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Nopotae i Yesu ndi umboro, “Bano helilaꞌa weeꞌakeo ndi Datu Langkai mbio henu gagi tiano kaa weeꞌakeo ndi Ue Ala mbio henu gagi tiaRo!” ");
INSERT INTO pdo_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Gagi mia tinena hieno laro mpohawe halano ai Yesu umbu ai pesangkiNo ai arono mia orao laꞌira. Umboro mentengiri rumongoio sangkino i Yesu laꞌa ooto karomengkomino. ");
INSERT INTO pdo_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Baꞌopioꞌiro to Saduki, mia henu lano mpeꞌale-aleo mongkono mia maate olo muule, hawe ndi Yesu karo mpesikeno ndi Umono, ");
INSERT INTO pdo_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Guru, ai Musa moꞌuki ai atora tiando kato mpetenunu, ‘Bano aso tama maate ka nio somborino kanggo lalau anaro, gagi petiano tama laꞌa olo sumomboriꞌo waaluno petiano laꞌa kano niokaa anano.’ ");
INSERT INTO pdo_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Nio opitu tama mpetia. Ana henu amba-ambano mesombori saru aso irowai, kanoꞌamba maate ambono nio anaro. ");
INSERT INTO pdo_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Kanoꞌamba ana henu koꞌoruo sumomboriꞌo waaluno petiano, kanggo ka mboꞌu maate ambono nio anaro. ");
INSERT INTO pdo_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Menggena mpihe ulaꞌa notegagi ndi tama henu koꞌotolu hawe ana henu koꞌopitu. ");
INSERT INTO pdo_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Pokoariano waalu laꞌa mate mboꞌu. ");
INSERT INTO pdo_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Gagi koꞌopitu tama henu mpetia oto umari romesomboriꞌo irowai laꞌa. Bano helilaꞌa, tempono mia maate pinokomule teꞌingga, aineiakero henu gagi somborino waalu laꞌa?” ");
INSERT INTO pdo_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","I Yesu sumangkiꞌiro, “Mia tuwu ai wawontolino nie, mesombori kaa sinombori, ");
INSERT INTO pdo_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","kanggo sombo mia henu pinatantuRo Ue Ala tekonoako mohawe tuwua henu amba ramai ka pinokomule umbu ai matea, lano pesombori ba lano sinombori. ");
INSERT INTO pdo_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Tinuwuro menggena malaꞌeka gagi larolei maate. Umboro ana-anaRo Ue Ala, akono umboro oto pinokomule umbu ai matea. ");
INSERT INTO pdo_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Mongkono muleꞌano mia maate, oto nopauꞌo ai Musa mbio henu tegagi ai laro seko merui henu tesongko. Tempo laꞌa Ue Ala mepau ndi Musa ‘Iakuto Ue Alani Burahima, Ue Alani Isaki kaa Ue Alani Yako.’ ");
INSERT INTO pdo_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Umboro lanoꞌo Ue Alaro mia maate, kanggo Ue Alaro mia tuwu, akono ai aroRo lowono mia tuwu.” ");
INSERT INTO pdo_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Baꞌopioꞌiro Guru Agama motae, “Guru, sangkiMiu laꞌa mentee suꞌu.” ");
INSERT INTO pdo_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Umari laꞌa, lalau mboꞌu mia henu taha mpesikeno ndi Yesu. ");
INSERT INTO pdo_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Kanoꞌamba i Yesu motae ndi umboro, “Helindekee karo bisa mpepau motae ai Datu Pongkadudui oto inuleno ai Daudi? ");
INSERT INTO pdo_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Akono ai Daudi, umonono motae ai laro sura Penani mpoꞌunde, Ue Ala mepau ndi Uenggu, pentoroto ai aso hile kuanaNggu ka momparenta gagi Datu, ");
INSERT INTO pdo_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Hawe kaKu wowauo lowono uweliMiu gagi metuundu ndi Ikomiu. ");
INSERT INTO pdo_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Gagi bano ai Daudi numeengo Datu Pongkadudui io Ueno, helinde kano bisa nopotae Datu Pongkadudui inuleno ai Daudi?” ");
INSERT INTO pdo_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Tekonai mia orao mperorongoi mbio nopompau i Yesu, Umono motae ndi anaguruNo, ");
INSERT INTO pdo_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Aimpegaga-gagai ndi Guru Agama. Mangaꞌuro mengkoleko-leko saru mempakeꞌo parewa mentaa henu moiko, mangaꞌu kano pinelangkai ai pasa, mangaꞌu mpentoro ai poꞌianga pinelangkai ai laro Raha Pesombaꞌa kaa ai pesamboraꞌa. ");
INSERT INTO pdo_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Umboro megaupio mia waalu kaa meꞌaleo raharo. Akoro minggi mewunio halaro laꞌa, gagi baro mpekakai epie ngako. Kanggo matantu Ue Ala dumosaꞌiro takau mobea.” ");
INSERT INTO pdo_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Tempono i Yesu ai Raha Pesombaꞌa, Nopekokoongo mia suugi pompondamo doi pesomba ai tabala ponaꞌanga pesomba. ");
INSERT INTO pdo_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Kano pekokoongo mboꞌu aso waalu henu karampini mompondamo oruo rumisi doi pera. ");
INSERT INTO pdo_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Kanoꞌamba i Yesu motae menggena unie, “Pekokoongo, menteꞌano waalu henu karampini nie mompowee pesomba meꞌalu orao kaseko lowono mia niire. ");
INSERT INTO pdo_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Akono mia suugi laꞌira pompowea umbu ai toreano agaagaro kanggo waalu henu takau karampini nie meweangakeo lowono niono.” ");
INSERT INTO pdo_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Ai tempo laꞌa nio baꞌopioꞌiro mpepau-pau helinde moikono Raha Mempori laꞌa binungabunga ako wasu henu memongkilo ka ako manggerupa parewa henu pinesombaꞌako ndi Ue Ala. Gagi i Yesu motaeꞌakero, ");
INSERT INTO pdo_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Nio tempono soongka lowono henu aimesueꞌo nie olo rinesa hawe kano tainio aso wasu henu tepoꞌapi ai wawono wasu henu mesueno.” ");
INSERT INTO pdo_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Umboro mpesikeno ndi Yesu, “Guru, teꞌepiekee noꞌamba tegagi? Mbiokee tondonino bano haweto tempono olo tegagi?” ");
INSERT INTO pdo_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","I Yesu sumangkiꞌiro, “Ai mpetangganakaa, indono ikomiu sinetaki. Akono orao mia olo amba hawe ka mempakeꞌo neeNggu, ka motae, ‘Iakuto i Datu Pongkadudui ka tempono oto umbeda!’ Kanggo ikomiu indoto mentondaꞌiro. ");
INSERT INTO pdo_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Indoto ai memomee lahi tabulu ikomiu mporongoi kareba mongkono peteaꞌa ka peꞌuwelia. Lowono nie olo tegagi seꞌelu, kanggo usie menteꞌano amboka tempono tampulaꞌano wawontolino.” ");
INSERT INTO pdo_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Kanoꞌamba i Yesu motae mboꞌu, “Olo tegagi peꞌuwelia ai olono tongku ka ai olono nagara. ");
INSERT INTO pdo_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Bainderiotokaa olo tegagi leelu henu langkai, abalaa mokoninggoꞌa ka haki lele. Olo tegagi mboꞌu kegagia henu mompokomomee ka tandangkohali-hali henu lalolangkai umbu ai langi. ");
INSERT INTO pdo_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Kanggo ambono tegagi lowono sie, ikomiu minggi rinako ka binobarasa, ikomiu minggi binitara ai Raha Pesombaꞌa ka tinarungku ka ikomiu winawo ai aroro datu ka topomparenta akono neeNggu. ");
INSERT INTO pdo_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Usieto tempomiu kai paleleꞌo Kareba Moiko umbu ndi Ue Ala. ");
INSERT INTO pdo_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Gagi pokomorosoꞌo aroamiu ka indo nanta-nanta bambio sangkimiu mokomenteeꞌo koroimiu. ");
INSERT INTO pdo_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Iakuto nie henu moweeꞌakomiu pandeꞌa mbio henu mentee minggi ai mempauꞌo hawe kano uwelimiu lano poli umewa ba gumalokomiu. ");
INSERT INTO pdo_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Helilaꞌato mboꞌu mia mosuꞌomu, petiamu, sambompihemu ka wali-walimu olo tumudukomiu ka baꞌopioꞌiro ai olomiu minggi pinepate. ");
INSERT INTO pdo_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Kaa lowono mia memokokatongakomiu akono neeNggu. ");
INSERT INTO pdo_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Maupono helilaꞌa, aso ngkau wuu tokaa ai ulumiu lanolei tetadi. ");
INSERT INTO pdo_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Bano ikomiu konggo mpihe metenunu ndi Iaku, ikomiu amba mpohawe tuwua lalau tampulaꞌano.” ");
INSERT INTO pdo_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Bano ikomiu mesueꞌo Yerusale rosapoio sorodadu, ai mentoꞌorioto motae, teresano oto umbeda. ");
INSERT INTO pdo_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Ai tempo laꞌa mia henu moꞌia ai Yudea iro mpolao lumeko ai torukuno. Mia ai laro inie langkai karo mpeluarako umbu lehea, ka mia henu moꞌia ai bungkuno inie langkai indoro mpendamo ai laro inie langkai, ");
INSERT INTO pdo_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","akono usieto tempono Ue Ala olo modosa tongku nie, kano lowono henu inukiro nabi mongkono podosaꞌa olo pinokosangka. ");
INSERT INTO pdo_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Masolato ine henu da tekonai momeni ba henu da mompoꞌuo rewu-rewu ai tempo laꞌa! Akono olo hawe marasaiꞌa henu takau langkai ai lowono wute ka Ue Ala olo dumosango tongku niire. ");
INSERT INTO pdo_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Nio henu olo pinepate ako ponai ka nio mboꞌu henu olo winawo gagi mia tinarungku ai inie mesue, ka orao tongku henu tai meꞌale-aleꞌiRo Ue Ala olo lumolaꞌango Yerusale hawe kano pinggo tempo henuto pinatantuRo Ue Ala tiaro.” ");
INSERT INTO pdo_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Minggi nio tandangkohali-hali henu sinue ai mataꞌolo, wule ka tonggimo. Ka ai tolino lowono tongku minggi memomee ka mebulalingo umaropio pue ka bombano tahi. ");
INSERT INTO pdo_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Lowono mia olo mengkinggimo ako mbio henu olo tegagi ai tolino nie, akono lowono henu nio pabawaro ai langi olo baali. ");
INSERT INTO pdo_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Ai tempo laꞌa olo romesueꞌo Ana Manusia hawe ai laro seru ako lowono pabawa ka marambaRo. ");
INSERT INTO pdo_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Bano lowono laꞌa mompamula tegagi, penggotito temoroso ka mpesonge, akono Ue Ala ronga minggi kumaduduikomiu!” ");
INSERT INTO pdo_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Kanoꞌamba i Yesu pauꞌakero sirime nie, Nopotae, “Peꞌiꞌindongo puꞌu ngkau ara ka lowono puꞌu ngkau mesueno. ");
INSERT INTO pdo_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Bano aimesueꞌo ai puꞌu ngkau laꞌa oto melewe monguro ai mentoꞌorioto motae minggi hawe tempo meꞌolo. ");
INSERT INTO pdo_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Hilaꞌato mboꞌu bai mesueꞌo lowono henu umari Kupauꞌo laꞌa tegagi ai minggi mentoꞌorio motae PomparentaꞌaRo Ue Ala oto umbeda. ");
INSERT INTO pdo_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Kupotaeꞌakomiu, ambonopo romemate lowo mia tempo nie, olo tegagi lowono nie. ");
INSERT INTO pdo_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Langi ka wute olo tampula, kanggo pauNggu lanolei huru tampula.” ");
INSERT INTO pdo_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Pegaga-gagaito, indono ikomiu mpihe maritu ako posaraꞌa ka moꞌinu inunga henu mompokomolangu ba mpihe nanta-nanta mongkono tuwuamiu. Indono ikomiu lano mesadia bano Ana Manusia bingkosako hawe melomohako. ");
INSERT INTO pdo_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Akono olo tampulaꞌano laꞌa olo hawe menggena oho ndi lowono mia ai wawontolino nie. ");
INSERT INTO pdo_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Pegaga-gagaito ka pekakai sombo-sombo tempo kai memoroso umaropio lowono henu olo tegagi laꞌa, ka ikomiu pontuꞌai mpenggoti ai arono Ana Manusia bano hawe mobitara.” ");
INSERT INTO pdo_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Sombo meene i Yesu mompaguru ai Raha Mempori kanggo sombo wongi meluarako leko mewongi ai tamungku Saitu. ");
INSERT INTO pdo_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Kanoꞌamba eri-erio orao mia hawe ai laro Raha Mempori minggi rumongoio pompaguruno i Yesu. ");
INSERT INTO pdo_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Olo langkai Roti Lano Metape henu ninee Pasa oto umbeda. ");
INSERT INTO pdo_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Baꞌopioꞌiro kapala Petewawo Pesomba ka Guru Agama mpowusu sala ba helinde karo poli mpepateo i Yesu laro mentoꞌorio mia, akoro memomee ndi mia orao. ");
INSERT INTO pdo_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Kanoꞌamba aso mia umbu ai kohopulo ka oruo anaguruno i Yesu oto i Yudasi henu ninee mboꞌu Isikario, nopendamohio Ueno Onisu. ");
INSERT INTO pdo_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Gagi umono lumeko ndi Kapala Petewawo Pesomba ka kapala pogagai Raha Mempori ka mpepatudu ba helinde kano poli meweangakeo i Yesu ndi umboro. ");
INSERT INTO pdo_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Umboro memangaꞌu takau ka tepoꞌaso aroaro poweeꞌakeo doi. ");
INSERT INTO pdo_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","I Yudasi meꞌindu ka mompamula tempo laꞌa umono mowusu tempo henu moiko henu laro mentoꞌorio mia orao minggi meweangakeo i Yesu ndi umboro. ");
INSERT INTO pdo_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Haweto tempono Olo langkai Roti Lano Metape, ooto usie tempono bimba Pasa olo ginere. ");
INSERT INTO pdo_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Gagi i Yesu tumenaꞌo ai Peturu ka i Yohane, “Lekoto pasadiaꞌakito kaanga Pasa.” ");
INSERT INTO pdo_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Rompotae ndi Umono, “Uma, ainderio ineheMiu kipasadiaꞌo?” ");
INSERT INTO pdo_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Sumangki i Yesu, “Baimpendamo ai laro inie langkai Yerusale, ikomiu minggi tepotowoꞌakeo aso tama henu mowawo kusi meꞌihi uwoi. Tondaꞌo hawe bainderio raha tetutuano, ");
INSERT INTO pdo_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","ka pauꞌakeo ndi ueno raha laꞌa, Guru mesikeno ndi ikomiu ‘Ainderio bolongko poꞌiangaNggu meronga anaguruNggu minggi mponggaa kaanga Pasa?’ ");
INSERT INTO pdo_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ueno raha laꞌa olo tumisoꞌakomiu aso bolongko henu langkai ai wawono, henuto nio mega ka parewa mesueno. Leheato ai pasadiaꞌo lowono.” ");
INSERT INTO pdo_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Gagi lumekoto ai Peturu ka i Yohane ai inie langkai Yerusale karo humaweꞌo menggena henu pinauno i Yesu. Karo palenaꞌo kaanga Pasa lehea. ");
INSERT INTO pdo_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Towono haweto tempono, i Yesu mentoro monggaa Pasa meronga saru anaguruNo. ");
INSERT INTO pdo_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Kanoꞌamba Nopepau ndi umboro, “Moꞌosu ngako Iaku monggaa Pasa nie merongakomiu, ambono Kumarasai. ");
INSERT INTO pdo_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Otokaa Kupotaeꞌakomiu, laKu lei monggaa kaanga Pasa nie mboꞌu hawe kano pengkonoano ponggaanga Pasa nie pinokosangka ai laro PomparentaꞌaRo Ue Ala.” ");
INSERT INTO pdo_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Umari laꞌa Noꞌaleo aso kangkiri meꞌihi anggoro kaNo pekakai moꞌunde-unde ndi Ue Ala, kano potae, “Aleoto ka inungo umbu ai kangkiri nie ka weeꞌakeo ndi walimiu. ");
INSERT INTO pdo_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Iaku mepau ndi ikomiu, umari Pasa nie, andoKu lei moꞌinu mboꞌu anggoro hawe kano gagi PomparentaꞌaRo Ue Ala ai wawontolino.” ");
INSERT INTO pdo_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Umari laꞌa i Yesu umaleo roti kaNo pekakai moꞌunde-unde ndi Ue Ala, kanoꞌamba Nosebu-sebungo roti laꞌa ako kaeNo kano weeꞌakero ka motae, “Tinieto koroiNggu henu pineweangako tiamiu, powowauto unie kai meꞌaroangaNggu.” ");
INSERT INTO pdo_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Hilaꞌaka mboꞌu umarino monggaa roti, Noweeꞌakero kangkiri meꞌihi anggoro ndi anaguruNo ka motae, “Anggoro nie ooto pegantiRo Ue Ala henu woꞌu henu pinokomentee ako reaNggu, rea henu tesolo tiamiu.” ");
INSERT INTO pdo_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“Kanggo pesuꞌuio, mia henu minggi meweangaKune nio endea meronga Iaku! ");
INSERT INTO pdo_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Ana Manusia menteeꞌano olo maate menggena henu pinatantuRo Ue Ala kanggo masolato mia henu meweeangaKune!” ");
INSERT INTO pdo_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Karo pompamula kosike-sikeno aso mia ka aso mia, “Ainei umbu i olondo nie henu mowowau menggena usie?” ");
INSERT INTO pdo_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Umari laꞌa anaguruno i Yesu mpegalo mongkono ainei henu lalolangkai potorono ai oloro. ");
INSERT INTO pdo_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Oto usie kano potae i Yesu ndi umboro, “Lowono Datuno tongku henu lano toꞌorio Ue Ala mpowowau montonda poꞌehero ndi paliliro ka lowono mia henu langkai pabawano inehero ninee ‘pontulungi palili’. ");
INSERT INTO pdo_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Kanggo ikomiu indo helilaꞌa, moikono mia henu lalolangkai ai olomiu nogagito menggena mia henu lalodedeiki ka petewawo nogagito mia momparakai. ");
INSERT INTO pdo_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Ainekee henu lalolangkai, mia henu mentoro monggaa ba mia henu momparakai? Matantu mia henu mentoro monggaa laꞌa. Kanggo Iaku nio ai olomiu menggena mia momparakai. ");
INSERT INTO pdo_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Ikomiu mpihe meronga Iaku ai masusaꞌa henu Kuhaweꞌo. ");
INSERT INTO pdo_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Okaa usie Iaku minggi moweeꞌakomiu pabawa kai bisa momparenta menggena UmaNggu moweAku pabawa kaKu momparenta. ");
INSERT INTO pdo_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Gagi ikomiu minggi mponggaa ka mpoꞌinu merongangiaKu ai laro pomparentaꞌaNggu, ka ikomiu lowo minggi mpentoro ai kadera pentoroꞌa henu pinelangkai kai pomparenta ai kohopulo ka oruo tongku Isaraeli.” ");
INSERT INTO pdo_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Kanoꞌamba i Yesu motae ndi Peturu, “Simo, Simo, pekokoongo! Ueno Onisu oto moꞌema tempo ndi Ue Ala minggi umaraꞌarahakomiu, menggena pae pinokosisingge umbu ai kulino. ");
INSERT INTO pdo_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Kanggo Akuto mekakaiꞌakomu, kano lano tebali pompeꞌalo-alomu ai tempo iiko inaraꞌarahako ka taꞌalu ikoto mentesisi ka mekule euno ndi Iaku, pokomorosoꞌokaa pompeꞌalo-aloro petiamu.” ");
INSERT INTO pdo_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Nopotae i Peturu, “Ue, iaku mesadia mendamo ai tarungku ka maate meronga Ikomiu!” ");
INSERT INTO pdo_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Kanggo Nopotae i Yesu, “Kupauꞌakomu Peturu, eri-erio ambono manu kekereꞌo, menggotoluto iiko humapuAku.” ");
INSERT INTO pdo_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Kanoꞌamba i Yesu mepau ndi anaguruNo, “Da ai mpewowoloꞌokee tempono Kutenakomiu lumeko mowawo Kareba Moiko ka laKu behekomiu mowawo doi, kandu-kandu ka sandala, niokee makuramiu?” RomesangkiꞌO, “Lalau.” ");
INSERT INTO pdo_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Nopotae i Yesu, “Kanggo hilinie, bainei mompeꞌue doi ba kandu-kandu olo nowaweo ka bainei lano pompeꞌue ponai olo noꞌasaꞌo kalambino kano poꞌoli ponai. ");
INSERT INTO pdo_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Akono, Kupauꞌakomiu motae olo pinokosangka ndi Iaku mbio henu teꞌuki ai laro laino Sura Tutulu nie, ‘Umono olo dinoa ai oloro mia ntehala.’ Menteꞌano, lowono mbio henu teꞌuki mongkono Iaku tekonai tegagi.” ");
INSERT INTO pdo_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Rompotae, “Ue, tinie nio oruo ponai.” Nosangkiꞌiro, “Sangka oto!” ");
INSERT INTO pdo_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Kanoꞌamba i Yesu bintango inie langkai laꞌa ka menggena mondeeno lumeko ai torukuno Saitu, ka anaguruNo merongaꞌakeO. ");
INSERT INTO pdo_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Tempono mehawe lehea, Nopotaeꞌakero, “Aimpekakaikaa indono ikomiu mentedonta ai laro pompopandei.” ");
INSERT INTO pdo_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Kanoꞌamba i Yesu lumeko olai tedei umbu ndi umboro, baraꞌura aso peratuꞌa wasu, kano penggolutu ka mekakai. ");
INSERT INTO pdo_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Nopotae i Yesu, “O Uma, bano Ikomiu behe, pokoꞌolaiꞌaKune marasaia nie, kanggo lanoꞌo montonda poꞌeheNggu aroanoto nogagi montonda poꞌeheMiu.” ");
INSERT INTO pdo_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Aso malaꞌeka umbu ai suruga mesabahako ndi Umono ka mokomorosoꞌO. ");
INSERT INTO pdo_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Ako mobeano marasaia henu Nohoringo, ooto kaNo mompesuꞌui mekakai hawe teꞌiti mokoꞌiwoNo menggena iti-itino rea ai wute. ");
INSERT INTO pdo_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Umari mekakai, i Yesu mekule ndi anaguruNo kanggo Nohaweꞌiro tekonai mpoturi akoro memomaloi ka masusa aroaro. ");
INSERT INTO pdo_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Nopotaeꞌakero, “Mombiokee kai mpoturi? Mpewangu kai mpekakai kano indono ikomiu mentedonta ai laro pompopandei.” ");
INSERT INTO pdo_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Tekonaino i Yesu da mepau, mehawe mia orao, ka i Yudasi aso mia umbu ai kohopulo ka oruo anaguruNo henu waweꞌiro. Kanoꞌamba i Yudasi lumeko tumowoꞌo i Yesu kano ikiꞌO. ");
INSERT INTO pdo_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Kanggo i Yesu mepauꞌakeo, “Yudasi, telalo umikiꞌAkukee kau peweangakeo Ana Manusia?” ");
INSERT INTO pdo_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Tempono umboro henu meronga-rongaꞌakeo i Yesu lehea mengkiteo mbio henu minggi tegagi, rompotae, “Ue, paralukee ikami umewaꞌiro ako ponai?” ");
INSERT INTO pdo_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Kanoꞌamba, aso mia umbu ai oloro umimpahio atano Petewawo Pesomba Langkai ako ponai hawe kano tebite biri kuanano. ");
INSERT INTO pdo_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Kanggo nopotae i Yesu, “Hilaꞌato!” Kanoꞌamba Noꞌiniꞌo birino mia laꞌa ka Noposombuo. ");
INSERT INTO pdo_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Kanoꞌamba i Yesu mepau ndi umboro Kapala Petewawo Pesomba ka kapala pogagai Raha Mempori saru mia mosuꞌono to Yahudi henu mehawe lehea minggi merakoꞌO, Nopotae, “Ai mengkaraakee Iaku nie mia henu mosaꞌa gauNggu kai mehawe mpowawo ponai ka tarasulu minggi merakoꞌAku? ");
INSERT INTO pdo_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Kaisaꞌa sombo-sombo olo Iaku merongakomiu ai Raha Mempori, ka lai merakoꞌAku. Kanggo unieto tempono, ikomiu mpeleluako ka pabawano Ueno Onisu peleluako mboꞌu.” ");
INSERT INTO pdo_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Umboro merakoꞌo i Yesu karo mewaweO ai rahano Petewawo Pesomba Langkai. Ka ai Peturu metonda umbu olai. ");
INSERT INTO pdo_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Ai tongano puu raha laꞌa mia pomposaki apui ka umboro mpentoro mebolilingo mpominu. I Peturu mboꞌu mentoro ai oloro. ");
INSERT INTO pdo_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Aso ata irowai sumueꞌo i Peturu mentoro umbeda apui, nopekokoongo kano potae, “Mia nie mboꞌu meronga-ronga saru i Yesu.” ");
INSERT INTO pdo_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Kanggo i Peturu mehapu, nopotae, “Uuhu, laku toꞌorio mia laꞌa.” ");
INSERT INTO pdo_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Lano epie umari laꞌa, nio mia mesue sumueꞌo i Peturu ka motae, “Iiko mboꞌu mia henu tumondaꞌiRo!” Kanggo i Peturu sumangki, “Uuhu, lanoꞌo iaku!” ");
INSERT INTO pdo_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Baraꞌura aso langku umari laꞌa, aso mia mesue mboꞌu mepau mompesuꞌui, “Mentee mia nie tumondaꞌo i Yesu ako umono mboꞌu mia Galilea.” ");
INSERT INTO pdo_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Kanggo nopotae i Peturu, “Mbio pinaumu sie, laku toꞌorio!” Tempo laꞌa mboꞌu tekonaino i Peturu mepau, manu kekereꞌo. ");
INSERT INTO pdo_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","I Yesu mewolili ka menggito ndi Peturu. Kano tekewolo i Peturu henu umari nopauꞌo i Yesu ndi umono, “Ambono kekereꞌo manu olo nie, iiko oto menggotolu humapuAku.” ");
INSERT INTO pdo_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Kano peluarako i Peturu umbu lehea ka meꞌiwi sesedu. ");
INSERT INTO pdo_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Mia orao henu tekonai gumagaio i Yesu, mpoꞌihe-ihengo ka romerodohO. ");
INSERT INTO pdo_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Romempupungo raꞌiNo ka mesikeno, “Kua pauꞌo ainei henu rumodoKo.” ");
INSERT INTO pdo_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Da orao mboꞌu pau pompoꞌewe-ewe henu romempauꞌakeO. ");
INSERT INTO pdo_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Ka towono meene umboro umbu ai mia mosuꞌono to Yahudi, Kapala Petewawo Pesomba ka Guru Agama mpepokosi minggi pebitara, kanoꞌamba i Yesu winawo ai arono Mpupobitara Agamaro. ");
INSERT INTO pdo_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Rompotae, “Taꞌalu ikoto Datu Pongkadudui, pauꞌakamito.” Nopotae i Yesu, “Napono Kupauꞌakomiu, lailei pompeꞌalo-alo, ");
INSERT INTO pdo_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","ka napono Kupesikeno bambio ndi ikomiu, lailei mesumangki. ");
INSERT INTO pdo_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Kanggo mompamula hilinie Ana Manusia olo mentoro ai kuanaRo Ue Ala Henu Lalopabawa.” ");
INSERT INTO pdo_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Rompotae lowo, “Taꞌalu helisie, menteekee Ikoto nie anaRo Ue Ala?” Nosangkiꞌiro i Yesu, “Ikomiukaa henu mempauꞌo motae Iaku anaRo Ue Ala.” ");
INSERT INTO pdo_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ka rompotae, “Lano paralu mboꞌu tompowusu sabi! Ikitoto umari merongoio umbu ai pinduNo.” ");
INSERT INTO pdo_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Kanoꞌamba mpenggoti lowono mpupoꞌutuhi kara-kara laꞌa karo mewaweo i Yesu ai arono i Gubenuru Pilatu. ");
INSERT INTO pdo_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Lehea umboro mompuꞌu pasalaꞌo i Yesu, rompotae, “Kimehaweꞌo Mia nie mokotesampuꞌo tongkumami, Umono mompoꞌusi mia karo indoro mpobara sima ndi Datu Langkai ka Noꞌumakuio motae Umonoto i Kerisitu oto Datu.” ");
INSERT INTO pdo_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Kanoꞌamba i Gubenuru Pilatu mesikeno ndi Yesu, “Ikotokee datuno to Yahudi?” Sumangki i Yesu, “Ikomiukaa henu pauꞌo.” ");
INSERT INTO pdo_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Gagi i Gubenuru Pilatu motae ndi baꞌopioꞌiro Kapala Petewawo Pesomba ka mia orao laꞌira, “Laku haweꞌo mapo teꞌaso halano Mia nie.” ");
INSERT INTO pdo_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Kanggo tetiangi mokora rodadario i Gubenuru Pilatu, rompotae, “Ako pompaguruNo, Nopoꞌusiꞌo palili ai lowono wute Yudea, teꞌumbu ai wute Galilea hawe endea.” ");
INSERT INTO pdo_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Rumongoio pauro laꞌa i Gubenuru Pilatu mesikeno, “To Galileakee Mia nie?” ");
INSERT INTO pdo_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Tempono i Gubenuru Pilatu tumoꞌorio motae i Yesu umbu ai wute pomparentaꞌano Datu Herode, notenaꞌiro karo mewaweo i Yesu ndi Datu Herode, henu tempo laꞌa tekonai ai Yerusale mboꞌu. ");
INSERT INTO pdo_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Tempono ai Datu Herode sumueꞌo i Yesu, mangaꞌu ngako aroano. Ako epieto nomokokumiteO ka oto menggoe norongoio mongkono i Yesu ka momperorohi olo kumiteO i Yesu mowowau aso tandangkohali-hali. ");
INSERT INTO pdo_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Gagi orao henu nopesikenoꞌakeo ndi Yesu, kanggo lalau napo teꞌaso henu nosangkiꞌo i Yesu. ");
INSERT INTO pdo_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Tempo laꞌa baꞌopioꞌiro Kapala Petewawo Pesomba ka Guru Agama lumeko ai arono karo pepau langkai mentulurio i Yesu. ");
INSERT INTO pdo_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Gagi mompamulato i Datu Herode ka sorodadu-sorodaduno mpoꞌewe-eweꞌo i Yesu ka mpesantalikiꞌakeO. RopokonoꞌakeO parewa pompelangkai gagi pompoꞌihe-ihero ndi Umono ka Datu Herode tumenaꞌiro pokuleꞌO ndi Gubenuru Pilatu. ");
INSERT INTO pdo_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Mompamula olo laꞌa ai Datu Herode ka ai Gubenuru Pilatu mewali-wali kaisaꞌa seꞌeluno umboro teposisala. ");
INSERT INTO pdo_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Kanoꞌamba i Gubenuru Pilatu pokosiꞌiro Kapala Petewawo Pesomba, petewawo to Yahudi ka palili, ");
INSERT INTO pdo_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","ka potaeꞌakero, “Ikomiu mewaweo Mia nie ndi iaku ako tuluri henu motae Umono mokotesampuꞌo tongkumiu. Pekokoongo, ai mengkiteo temponggu paresaꞌo Mia nie ai aromiu, lalau napo teꞌaso halaNo menggena henu ai tuluriꞌakeO. ");
INSERT INTO pdo_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Menggenakaa saru i Datu Herode, lalau nopohawe napo teꞌaso halaNo oto kano pokuleꞌakami. Menteeꞌano lalau napo teꞌaso hala henu Nowowauo hawe kano tekonoako pinotamba. ");
INSERT INTO pdo_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Gagi minggi kutenaꞌo sorodadunggu sumepiꞌO umari laꞌa kupokolipahO.”  ");
INSERT INTO pdo_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Ai Gubenuru Pilatu motae menggena usie akono mondeeno umono olo mokolipaho aso mia tinarungku tiano mia orao ai sombo olo Pasa. ");
INSERT INTO pdo_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Kanggo lowono mia henu lehea mengkumora, “Pepateo Mia sie! Pokolipahakami ai Baraba!” ");
INSERT INTO pdo_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Ai Baraba tinarungku akono morukai ai inie langkai laꞌa ka mompepate mia. ");
INSERT INTO pdo_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Ai Gubenuru Pilatu minggi mokolipaho i Yesu, gagi nopepau mboꞌu tetiangi mekora ndi mia orao laꞌira. ");
INSERT INTO pdo_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Kanggo mia orao mengkokora-kora, “Potambaꞌo Mia sie! Potambaꞌo Mia sie!” ");
INSERT INTO pdo_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Ka komenggotoluno ai Gubenuru Pilatu mepau ndi umboro, “Mbio suꞌukee winowauNo henu mosaꞌa? Lalau kuhaweꞌo napo teꞌaso winowauNo henu mosaꞌa kaNo pinokonoako pinotamba, gagi minggi kutenaꞌo sorodadunggu sumepiꞌO kaku amba mokolipaHo.” ");
INSERT INTO pdo_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Kanggo tetiangi langkai romengkumora dumadario ai Gubenuru Pilatu kano i Yesu pinotamba. Pokoꞌariano umboro ponangi ako kokora-koraro. ");
INSERT INTO pdo_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Gagi i Gubenuru Pilatu putuio tumondaꞌo poꞌemaro mia orao. ");
INSERT INTO pdo_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Ka nopokolipaho i Baraba henu romeꞌemango, oto mia henu tinarungku akono morukai ka mompepate mia. Kanggo i Yesu nopeweangakeo ndi umboro karo mpowowau montonda poꞌehero. ");
INSERT INTO pdo_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Kanoꞌamba sorodaduno to Roma laꞌira mewaweo i Yesu meluarako umbu ai inie langkai Yerusale. Tempono koleko-leko, umboro tepotowoꞌakeo ai Simo umbu ai inie langkai Kirene, henu tekonai mendamo ai inie langkai Yerusale. Romentahango ka medadasio kano poꞌahango kau pinotambano i Yesu ka koleko-leko ai bungkuno i Yesu. ");
INSERT INTO pdo_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Orao ngako mia henu tumonda bungkuꞌO. Ai oloro nio orao irowai henu mpeꞌiwi sesedu ka mokokolaroꞌakeo i Yesu. ");
INSERT INTO pdo_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Kanggo i Yesu mewolili ka motaeꞌakero, “Oo irowai-irowai Yerusale! Indoto mpeꞌiwikiaKu! Mpeꞌiwikioto koroimiu ka ana-anamiu! ");
INSERT INTO pdo_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Akono minggi hawe tempono mia mpotae, ‘Memeꞌuraꞌiroto irowai henu biita, henu laro huru mpeꞌana, ka laro huru mompoꞌuo!’ ");
INSERT INTO pdo_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Ai tempo laꞌa mia minggi mpotae, ‘Aroanoto lowono tamungku dumusinggami ka lowono torukuno humuwuinggami!’ ");
INSERT INTO pdo_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Akono bano umboro mpowowau menggena unie ai puꞌu ngkau henu da tuwu, mbioto henu minggi romewowauo ai puꞌu ngkau henuto mosuꞌi?” ");
INSERT INTO pdo_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Sorodaduno to Roma laꞌira mowawo mboꞌu oruo mia mesueno henu mosaꞌa gauro henu minggi pinotamba meronga i Yesu. ");
INSERT INTO pdo_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Temporo mehawe ai poꞌianga henu ninee Takuꞌulu, lehea baꞌopioꞌiro sorodaduno to Roma potambaꞌo i Yesu meronga oruo mia henu mosaꞌa gauro laꞌa, aso mia ai kuanaNo ka aso mia ai manggaliNo. ");
INSERT INTO pdo_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Kanoꞌamba i Yesu mepau, “Uma, oninioto halaro, akono laro mentoꞌorio mbio henu winowauro.” Kanoꞌamba sorodadu laꞌira mpetia-tiaꞌo parewaNo i Yesu telalo ai loterei. ");
INSERT INTO pdo_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Orao mia menggoti lehea mesueꞌo lowono kegagia laꞌa. Umboro petewawo to Yahudi tekonai mpoꞌihe-ihengo i Yesu, rompotae, “Mia mesue Nokaduduio, bano loꞌoka suꞌu mentee Mia nie Datu Pongkadudui henu bininikiRo Ue Ala, poꞌinengoto kano Umonono kumaduduio koroiNo.” ");
INSERT INTO pdo_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Umboro sorodadu mboꞌu mpoꞌihe-ihengo i Yesu, rompopoꞌinuakeo anggoro mosilu ndi Yesu, ");
INSERT INTO pdo_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","ka rompotae, “Bano Ikoto datuno to Yahudi, kaduduio koroiMu!” ");
INSERT INTO pdo_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ai wawo uluno i Yesu ai kau pinotamba laꞌa pinotako inuki, “Tinieto datuno to Yahudi.” ");
INSERT INTO pdo_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Aso mia henu mosaꞌa gauno henu pinotamba ai aso hileno i Yesu mboꞌu moꞌihe-ihengo, nopotae, “Lanoꞌokee Ikomiu Datu Pongkadudui? Bano menggena ulaꞌa, kaduduio koroiMu ka ikami!” ");
INSERT INTO pdo_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Kanggo mia henu mosaꞌa gauno henu asono meꞌuaꞌo, nopotae, “Laulaꞌa momeeke iiko ndi Ue Ala? Akono iiko pinotamba menggena Umono! ");
INSERT INTO pdo_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Menteeꞌano Mia nie lalau napo teꞌaso winowauNo henu mosaꞌa, kanggo ikito tekonoano bato dinosa akono powowaundo henu mosaꞌa.” ");
INSERT INTO pdo_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Kanoꞌamba nopotae, “O Yesu pewowoloꞌo akukaa tempono Ikomiu hawe gagi Datu.” ");
INSERT INTO pdo_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","I Yesu motae ndi umono, “Kupauꞌakomu, menteꞌano olo nie iiko minggi meronga Iaku ai suruga.” ");
INSERT INTO pdo_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","45","Baraꞌura langku hopulo ka oruo tonga olo, mataꞌolo lano mewanta ka lowono poꞌianga lehea gagi worikidi hawe langku otolu wundu olo. Bana poꞌolosi henu mpihe nio ai Bolongko Mempori ai Raha Mempori teberi tepeꞌoruo. ");
INSERT INTO pdo_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Kanoꞌamba i Yesu kumora, “O Uma, ai laro kaeMiu Kupeweangakeo penaoNggu!” UmariNo mepau menggena ulaꞌa, i Yesu maate. ");
INSERT INTO pdo_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Tempono kapala sorodadu sumueꞌo kegagia laꞌa, noꞌundeꞌiRo Ue Ala, nopotae, “Mentee suꞌu Mia nie lano tehala!” ");
INSERT INTO pdo_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Lowono mia henu menterombu mpengginggito lehea, mengkiteo mbio henu tegagi. Rompekule memokokolaro ka pompesosoo. ");
INSERT INTO pdo_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Tempo laꞌa wali-walino i Yesu ka baꞌopioꞌiro irowai henu tumondaꞌo i Yesu umbu ai Galilea, umboro mpenggoti halaꞌolai ka mengkiteo kegagia laꞌa. ");
INSERT INTO pdo_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Nio aso mia neeno i Yusupu, umbu ai inie langkai Arimatea ai wute Yudea. Umono meꞌaroa moiko ka pinelangkai ka umono meteteꞌema tempono Ue Ala momparenta gagi datu. Maupono umono miano Mpupobitara Agama, kanggo lano tumarimaꞌo mbio henu umari pinotuhi ka henu romewowauo. ");
INSERT INTO pdo_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Gagi umono lumeko ndi Gubenuru Pilatu ka umemango bakeno i Yesu. ");
INSERT INTO pdo_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Kanoꞌamba nopotiingo bakeno i Yesu kano tongoho ako bana mopute ka nopoleroo ai laro aso kaburu ai torukuno mewasu. Kaburu laꞌa ambono huru pinake. ");
INSERT INTO pdo_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Lowono laꞌa tegagi umbeda ai olo penao-naoꞌa to Yahudi. ");
INSERT INTO pdo_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Baꞌopioꞌiro irowai henu mehawe meronga i Yesu umbu ai Galilea, tumondaꞌo i Yusupu. Romengkiteo kaburu laꞌa ka ba helinde nopinolero bakeno i Yesu ai larono. ");
INSERT INTO pdo_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Umari laꞌa umboro mpekule ai Yerusale. Umboro umaturuꞌo rampa-rampa ka boka mana moꞌahi tiano bokaino bakeno i Yesu. Ka ai olo penao-naoꞌa to Yahudi, umboro mpenao-nao montonda songkaro i Musa. ");
INSERT INTO pdo_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Da eri-erio ngako ai olo Minggu, baꞌopioꞌiro irowai meleko ai kaburu mpowawo rampa-rampa henuto ropatokaꞌo. ");
INSERT INTO pdo_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Romehaweꞌo wasu pupuno kaburu laꞌa oto tebanggule. ");
INSERT INTO pdo_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Toworo mpendamo, andoro mehaweꞌo bakeno i Yesu lehea. ");
INSERT INTO pdo_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Tekonairo mpenggoti kaa mengkokondoro ako kegagia laꞌa, bingkosako oruo mia mekalambi mongkikilo mpenggoti ai horiro. ");
INSERT INTO pdo_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Umboro memomee ngako karo mpenggolutu. Kanggo oruo mia laꞌira mepau ndi umboro, “Akombio kai mewusuꞌo Mia henu tuwu ai oloro mia maate? ");
INSERT INTO pdo_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Umono lalau endea, kanggo Umono oto muule. Pewowoloꞌo mbio henu huru Nopauꞌakomiu tempono Umono da merongakomiu ai Galilea, ");
INSERT INTO pdo_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","motae, ‘Ana Manusia olo pineweangako ndi mia ntehala, kanoꞌamba pinotamba, ka koꞌotoluno olo Umono olo muule.’ ” ");
INSERT INTO pdo_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Gagi rompewowoloꞌo pauno i Yesu laꞌa. ");
INSERT INTO pdo_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Ka toworo mpekule umbu ai kaburu, ropauꞌakero lowono kegagia laꞌa ndi hopulo ka aso anaguruNo ka mia mesue henu mpetonda ndi Yesu. ");
INSERT INTO pdo_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Irowai-irowai henu mompauꞌakero kegagia laꞌa ooto i Maria Madalena, ai Yohana, ai Maria ineno i Yakobu ka irowai-irowai mesueno. ");
INSERT INTO pdo_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Kanggo anaguruno i Yesu laro mpeꞌale-aleꞌiro akono romengkoꞌaraꞌara irowai laꞌira butu mpesambureki. ");
INSERT INTO pdo_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Kanggo ai Peturu menggoti kano pelulu lumeko ai kaburu. Kano penggou-nggou mesisimi ka nosueꞌo bututokaa bana mopute henu nio lehea. Kanoꞌamba i Peturu mekule ka kosike-sikeno ai laro aroano mbio henu umari tegagi. ");
INSERT INTO pdo_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ai olo laꞌa mboꞌu oruo mia henu metonda ndi Yesu tekonai koleko-leko lumeko ai inie henu ninee Emau, baraꞌura hopulo ka aso kilo olaino umbu ai Yerusale. ");
INSERT INTO pdo_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Tekonairo koleko-leko, umboro mepau-pau kumonoo lowono henu umari tegagi. ");
INSERT INTO pdo_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Temporo mpebita-bitara ka moluarako pohawero, bingkosako i Yesu hawe ka koleko-leko merongaꞌakero. ");
INSERT INTO pdo_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Kanggo nio henu lumingoꞌo mataro, oto karo tai bisa tumoꞌorio i Yesu. ");
INSERT INTO pdo_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Kanoꞌamba i Yesu sumikenoiro, “Mbioto henu ai mebitaraꞌo ai laro koleko-lekoamiu nie?” Gagi umboro mpenao-nao ka raꞌiro mehanga mokokolaro. ");
INSERT INTO pdo_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Kanggo aso mia umbu ai oloro, henu meneengako Keleopa, mesikeno, “Butu Ikomiukee mia umbu olai henu hawe ai Yerusale henu tai tumoꞌorio mongkono lowono kegagia henu umari tegagi sarai nie?” ");
INSERT INTO pdo_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Kanoꞌamba i Yesu mesikeno mboꞌu, “Kegagia mbiokee?” RosangkiꞌO, “Kegagia mongkono i Yesu mia Nasare. Umono nabi henu buke ako pabawa ai laro lowono pauNo ka winowauNo ai aroRo Ue Ala maupo ai aroro lowono tongkundo. ");
INSERT INTO pdo_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Kanggo umboro Kapala Petewawo Pesomba ka petewawo agamando meweangakeo kano dinosa, umari laꞌa Umono pinotamba. ");
INSERT INTO pdo_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Kaisaꞌa ikami pomperorohi motae Umonoto henu minggi mokolipaho tongku Isaraeli umbu ai to Roma uweliro. Ka olo nie koꞌotoluno olo umarino kegagia laꞌa. ");
INSERT INTO pdo_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Kanggo nio baꞌopioꞌiro irowai umbu ai miamami mokotekangga kami. Da eri-erio ngako iroto meleko ai kaburu, ");
INSERT INTO pdo_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","kanggo laro mehaweꞌo bakeno i Yesu lehea. Karoꞌamba mpekule ka mompauꞌakami motae umboro mposue malaꞌeka. Malaꞌeka laꞌira motaeꞌakero i Yesu muule. ");
INSERT INTO pdo_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Gagi baꞌopioꞌiro walimami lumeko mboꞌu ai kaburu ka romehaweꞌo menggena henu pinauro irowai laꞌira kanggo laro mesueꞌo i Yesu.” ");
INSERT INTO pdo_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Kanoꞌamba i Yesu motae ndi umboro, “Ikomiukaa suꞌu mebenge! Mapari ngako meꞌale-aleo mbio henu umari pinauro nabi! ");
INSERT INTO pdo_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Lanoꞌokee seꞌeluno Datu Pongkadudui olo humoringo lowono marasai laꞌa kanoꞌamba tumarimaꞌo marambaꞌaNo?” ");
INSERT INTO pdo_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Kanoꞌamba i Yesu nopauꞌakero lowono pengkonoano mbio henu teꞌuki ai laro Sura Tutulu mongkono koroiNo umbu ai surano nabi Musa hawe ai lowono suraro nabi. ");
INSERT INTO pdo_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Temporo umbeda ai inie tinungkairo, i Yesu helau minggi motilaloꞌakeo koleko-lekoaNo. ");
INSERT INTO pdo_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Kanggo rodadasiO ka motae, “Poꞌiato meronga ikami, akono oto minggi wongi ka oto minggi soo olo.” Gagi i Yesu mendamo ka moꞌia merongaꞌakero. ");
INSERT INTO pdo_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Tempono rompentoro minggi mponggaa, i Yesu umaleo roti, mekakai moꞌunde ndi Ue Ala kanoꞌamba Nosebu-sebungo roti laꞌa ka Noweeꞌakero. ");
INSERT INTO pdo_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Tempo laꞌa masa lalau mboꞌu mbio henu lumingoꞌo mataro, gagi rotoꞌorio motae Umonoto i Yesu. Ka Umono oto molio umbu ai penggitoaro. ");
INSERT INTO pdo_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Karoꞌamba mpepau aso mia ka aso mia, “Okaa tekono aroando laloako mangaꞌu tekonai Nopepau ndi ikito ai tonga sala ka tempono Nopauꞌakito pengkonoano ihino Sura Tutulu.” ");
INSERT INTO pdo_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Ai tempo laꞌa mboꞌu, umboro mpenggoti ka mpekule ai Yerusale. Lehea romehaweꞌo kohopulo ka aso anaguruno i Yesu tekonai menterombu saru mia mesue henu metonda ndi Yesu. ");
INSERT INTO pdo_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Kanoꞌamba umboro henu ai Yerusale pauꞌakero oruo mia laꞌa, “Menteeꞌano i Yesu oto muule ka mesabahako ndi Simo.” ");
INSERT INTO pdo_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Kaa oruo iro laꞌa pauꞌakero mboꞌu mongkono mbio henu tegagi ai tonga sala ka helinde romentoꞌorio i Yesu tekonaiNo mosebu-sebu roti. ");
INSERT INTO pdo_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Tekonairo da mpepau-pau mongkono kegagia laꞌa, bingkosako i Yesu menggoti ai oloro ka mepauꞌakero, “Roodo tiamiu!” ");
INSERT INTO pdo_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Umboro tekangga ka memomee akoro mengkoꞌaraꞌara umboro mposue onisu. ");
INSERT INTO pdo_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Kanggo i Yesu mepauꞌakero, “Mombio kai memomee? Mombio kai mendoondoo ai laro aroamiu? ");
INSERT INTO pdo_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Kiteo kaeNggu ka kareNggu. Iakuto unie! Iniꞌo ka kiteoto, akono onisu lalau bauno ka wukuno, menggena henu ai mengkiteo ndi Iaku.” ");
INSERT INTO pdo_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Tekonaino mepau, i Yesu tumisoꞌakero kaeNo ka kareNo. ");
INSERT INTO pdo_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Kanggo amboro mpeꞌale-aleo suꞌu akono umboro mangaꞌu ka da mengkohali-hali kumiteo i Yesu. Ooto kano i Yesu motaeꞌakero, “Niokee kaangamiu endea?” ");
INSERT INTO pdo_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ka roweeakeO asontia bou sinunu. ");
INSERT INTO pdo_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Noꞌaleo kano kaango ai aroro. ");
INSERT INTO pdo_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Kanoꞌamba Nopotaeꞌakero, “Unieto pauNggu henu Kupauꞌakomiu i tempo kaKu da merongakomiu motae lowono henu inuki mongkono Iaku ai laro songkano i Musa, suraro nabi ka sura Mpenani ka Mpoꞌunde olo pinokosangka.” ");
INSERT INTO pdo_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Kanoꞌamba i Yesu wunggeho pompewowoloro karo mentoꞌorio ihino Sura Tutulu. ");
INSERT INTO pdo_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Nopotae ndi umboro, “Nio teꞌuki ai laro Sura Tutulu motae, Datu Pongkadudui olo marasai ka koꞌotoluno olo Umono muule. ");
INSERT INTO pdo_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Ka mboꞌu mongkono tesisiꞌa ka pontolosia hala olo pinalele ai laro neeNo ndi lowono tongku, mompamula umbu ai Yerusale. ");
INSERT INTO pdo_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Ikomiuto sabiNggu henu minggi paleleꞌo lowono kegagia nie. ");
INSERT INTO pdo_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Ka Iaku olo mompokasu mbio henu oto ginantiRo UmaNggu. Aimpoꞌiato ai inie langkai nie hawe ikomiu pinokonoako pabawa umbu ai suruga.” ");
INSERT INTO pdo_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Kanoꞌamba i Yesu wawoꞌiro meluarako umbu ai Yerusale hawe umbeda ai inie Betania. Lehea Noꞌengkaho kaeNo kaa Norosongiro. ");
INSERT INTO pdo_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Tekonai Norosongiro, Umono teposuangako umbu ndi umboro ka teꞌengka ai suruga. ");
INSERT INTO pdo_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Umboro mpenggolutu mesombaiO kanoꞌamba rompekule ai Yerusale buke ako mangaꞌua. ");
INSERT INTO pdo_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Pokoꞌariano sombo olo romehawe ai Raha Mempori ka umunde-undeꞌiRo Ue Ala.");
ALTER TABLE pdo_vpl ADD FULLTEXT(verseText);
UNLOCK TABLES;
