﻿USE sofia;
DROP TABLE IF EXISTS sofia.pbb_vpl;
CREATE TABLE pbb_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES pbb_vpl WRITE;
INSERT INTO pbb_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Jesukristo ji'j nyafxiiteywe'sx kimtewap txãatxku pta'sxi' ayte'. Jesukristo' Abrahan Davxid ji'kh yu'. ");
INSERT INTO pbb_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abrahana' Isaak neyku yu', naapkaçxha' Isaakha', Jakob neyku yu'. Aça' Jakoba', Judáwe'sx neyku yu'. ");
INSERT INTO pbb_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Juda' Fxares vxite' Zara neyku yu', aça' njĩ'ja' Tamarku yaase yu'. Fxaresa' Esrom neyku yu', naapkaçxha' Esroma', Aram neyku yu'. ");
INSERT INTO pbb_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Arama', Aminadab neyku yu', naapkaçxha' Aminadaba' Naason neyku yu'. Aça' Naasona', Salmón neyku yu'. ");
INSERT INTO pbb_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmona' Booz neyku yu', naapkaçxha' njĩ'ja' Rahabku yaase yu'. Booza' Obed neyku yu', aça' njĩ'ja' Rutku yu'. Obeda' Isaí neyku yu', ");
INSERT INTO pbb_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","naapkaçxha' Isaía', jxkaahsa Davxid neyku yu'. Aça' jxkaahsa Davxida', Salomón neyku yu', aça' Salomón njĩ'ja' Urias nyu yu'k nyafxíi txãak yu'. ");
INSERT INTO pbb_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomona' Roboam neyku yu', naapkaçxha' Roboama', Abias neyku yu'. Aça' Abiasa', Asa neyku yu'. ");
INSERT INTO pbb_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Aça' Asa', Josafxat neyku yu', naapkaçxha' Josafxatha', Joram neyku yu'. Jorama', Uzias neyku yu'. ");
INSERT INTO pbb_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uziasa' Jotam neyku yu', naapkaçxha' Jotama', Akaz neyku yu'. Aça' Akaza' Ezekías neyku yu'. ");
INSERT INTO pbb_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezekiasa' Manasés neyku yu', aça' Manasesa' Amón neyku yu', naapkaçxha' Amona' Josías neyku yu'. ");
INSERT INTO pbb_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josiasa' Jekoniaswe'sx neyku yu'. Txãa ensutx Israelwe'sxa' Babilonia kiwen jxũna u'jni yuu. ");
INSERT INTO pbb_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Aça' Jekoniasa' Salatiel neyku yu', naapkaçxha' Salatiela', Zorobabel neyku yu'. ");
INSERT INTO pbb_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zorobabela' Abiud neyku yu', aça' Abiuda' Eliakim neyku yu'. Eliakima', Azor neyku yu'. ");
INSERT INTO pbb_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azora' Sadok neyku yu', aça' Sadokha', Akim neyku yu', naapkaçxha' Akima' Eliud neyku yu'. ");
INSERT INTO pbb_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliuda' Eleazar neyku yu', aça' Eleazara' Matán neyku yu', naapkaçxha' Matana', Jakob neyku yu'. ");
INSERT INTO pbb_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jakoba' Jose neyku yu', naapkaçxha' Jose' Maria nmi'k yu', Kristo Jesus yaasesa njĩ'j. ");
INSERT INTO pbb_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Abrahan ji'jtx isate', katorce ney u'jweçtek Davxida' upxhna ũsu'. Aça' Davxid ji'jtx isate', ki' vxite katorce ney u'jweçtetx Israelwe'sxa' Babilonia kiwen jxũna u'jni yuu. Txãajũ ki' isani ki' vxite katorce ney u'jweçtek Kristo' upxhna ũsu'. ");
INSERT INTO pbb_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Jesukristo upxni' na'wẽk yuu: Jesus njĩ'j Maria' José yakh imi'ya' puutx we'wenik ji'phu'. Nawa ih fxi'zemey, nasa ji'phuk Dxus Espiritu kaavxya'ja'jni. ");
INSERT INTO pbb_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Txajx nmi' Josea' txãawe'sx leytxi kxtey nwẽese'jna fxi'zesak yu'. Nawa Maria nasa ji'phuni yu's khuẽswe'sxtxi pãatxhĩ'khmée, paaçte txuteeya'wak yu' nasa jiyunimeete. ");
INSERT INTO pbb_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Sa' txã'wẽ yajkxna ũsiyna, ksxa'wte Dxus angel vxyaaçxa na'jĩk: —José, Davxid ji'j, iidx nyu yuuwa'jsa Maria's jxpa'gaya' wa'lnu, na'wẽ nasa ji'pha' nawa txã' Dxus Espiritu kaavxya'ja'jni'. ");
INSERT INTO pbb_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Maria nçxi'k ãaga vxyaate', txã'sa' Jesus yasene'ga. Txã'wẽ kxsusni yuuna, txãa pa'gatey txajx nasa pkaltewe'sxtxi nwe'wewa'jsa' jĩnak we'we. ");
INSERT INTO pbb_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Txã'wẽ yuuk, nawa txãniitey Dxus yuwe pta'sxsa's Dxusíi kaaũusuthe'the' na'wẽk we'we txãa kxtey yuukahnçxáak txã'wẽ yuu. ");
INSERT INTO pbb_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Txã' na'wẽk we'we: Teeçx kna'sa' teeçx nçxi'k ji'phuna. Txã' Emanwel kxsusni yuuna jĩk. Txãa Emanwel jĩnisa': Dxusa' kwe'sx yakh ũsa' jĩni'. ");
INSERT INTO pbb_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Txajũ' Josea' deeniijũ yajkxçxa', Dxus angel we'weni's nwẽese'jçxa Maria txajx nyu yuuwa'jsa's nvxihtme'. ");
INSERT INTO pbb_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Nawa ptam na'wẽ ih yu' fxi'zemeeta', María nçxi'k ãaga yuupkaçx. Sa' Maria nçxi'k ãaga yuute', txã'sa' Jesus yasek ki'p. ");
INSERT INTO pbb_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Jesusa' Belen çxhabtek upx, Judea kiwete. Txãn ensu txãa kiwesu jxkaahsa' Herodesku yu'. Naapkaçxha' Jerusalen çxhabte maz piçthẽ'j pa'jtx sek kãani kiwejuwe'sx estrelxatx jiisa. ");
INSERT INTO pbb_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Sa' na'jĩnatx pẽjx: —¿Mtee ũsna judiuwe'sxtxi jxkaahwa'jsa ãçxh u'se upxsa? Kwe'sxa' txajx upxni's pta'sxsa estrelxa's uytha'w sek kãani kiweju, txãasatha'w weçxaya' yuwé'. ");
INSERT INTO pbb_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Txã'jĩte', Herodesa' wala kuh yajkxku, txã'wẽy Jerusalen çxhabte nasawa jxukaysa. ");
INSERT INTO pbb_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Txajũ' jxkaahsa' sacerdote npiiçthẽ'jwe'sx vxite' ley kaapiya'jsawe'sx jxukaysatx pa'yaçxa' paapẽjxku: —Kristo' ¿mteega upxwa'jsa yu'? jĩte', pta'sxtxi: ");
INSERT INTO pbb_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","—Judea kiwete Belen çxhabtek upxwa'jsa yu'. Txajíik Dxus yuwe pta'sxsa' na'jĩna fxi'j: ");
INSERT INTO pbb_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Judá kiwete Belen çxhab txã'wẽ maa çxhabtewa jxthaakwe ãhmeekwesame'. Txãa pa'gatey Belen çxhabuh teeçx npiiçthẽ'jsa kasehçxa Adx nasa Israelwe'sxtxi jxpe'jwa'jsa' jĩ'k. ");
INSERT INTO pbb_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Txã'jĩte', Herodesa' estrelxa's uysaatx paaçte pa'yaçxa pẽjxku: —¿Makwe txaçx yuuçna estrelxa vxyaani? jĩna wala ew paapẽjxçxak ");
INSERT INTO pbb_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Belenna kaah na'jĩna neewe'weçxa: —Kxte me'jwe, sa' wala ew paapẽyine'kwe txãa luuçx ma'wẽsatewa. Sa' ew jiyuçxa', adxa's pta'sxine'kwe, aça' adxwa weçxaya' u'jwe'nja jĩte', ");
INSERT INTO pbb_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","estrelxa's uysaawe'sxa' u'jtx. Naapkaçxha' sek kãani kiweju estrelxa uyne'ta txãa estrelxa' txãawe'sx yaçte vxyaana u'jçxa mteene' luuçx ũsu' txãa kajkwete pa'jçxak kxtee yuju. ");
INSERT INTO pbb_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Txã'wẽ estrelxa ki' vxyaate', wala weçxatx, ");
INSERT INTO pbb_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","sa' yatte u'kaçxa luuçxa's uytxi njĩ'j yakh. Sa' peejxũkweçxa' luuçxa's weçxatx. Txã'wẽ yũuçxatx txãawe'sx peeswa'j jxũçxa u'jni's phaadeçxa pees: vxyuu beh, incienso vxite' miçxa. ");
INSERT INTO pbb_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Txã'wẽ yũuniijũ' kus ksxa'wte pta'sxnitx yuu Herodes tasxna ki' sxawedkahmén. Aça' vxite dxi'jsutx sxawedna u'j. ");
INSERT INTO pbb_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Estrelxa's uysaawe'sx u'jnijũ', José ksxa'wte', Dxus angel vxyaaçxa na'jĩk: —Kiiteçxa me'j ũphna Egipto kiwen luuçxkuẽ's pe'jçxa petx njĩ'j yã'jçxa. Sa' kxtee ũsune'ga adx ki' pta'sxpkaçx. Txã'wẽme', Herodesa' luuçxkuẽ's ikhya' pakweya'wa' jĩte', ");
INSERT INTO pbb_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Jose' kusçxáa pe'jna Egipto kiwen u'kh. ");
INSERT INTO pbb_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Sa' kxteetx ũsu' Herodes uupkaçx. Dxus yuwe pta'sxsa we'weçxa': Egiptoju pa'yath Adx Nçxi'ka's jĩk txãa kxtey yuukahnçxáak txã'wẽ yũu. ");
INSERT INTO pbb_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Estrelxa's uysaawe'sx txã'wẽ Herodesa's weeçxsa na'wẽ vxite dxi'jsu u'jni's jiyuçxa', seena' wala ũusaçxak. Sa' luuçxtxi kiikhe'kh Belen çxhabtewe'sx vxite' peeku'jsuwe'sx yã'jçxa jxuka, luuçx e'z anxu ji'phsate kãhpkaçx. Estrelxa's uysaawe'sxa' makwe txaçx yã'j yuuçtewa pta'sxne'ta txã'sna jiyuçxak txã'wẽ e'z anxu ji'phsate kãhpkaçx kiikhe'jna ũsu' Herodesa'. ");
INSERT INTO pbb_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Dxus yuwe pta'sxsa Jeremias na'jĩna fxi'jni kxtey yuuk: ");
INSERT INTO pbb_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Teeçx ahte Ramá yaasesate pthũusek Seena' pebeena nxus we'weni. Txã' Rakelku txã'wẽ ũ'ne' txajx luuçx pa'gate, Sa' kisxi'çme', txã'wẽtx ikhni yuu naa pa'ga jĩ'k. ");
INSERT INTO pbb_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Egipto kiwete ũsçxa José ksxa'wte', Dxus angel vxyaaçxa na'jĩk Herodes uuniijũ': ");
INSERT INTO pbb_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","—Ãçxha' luuçxa's ikh wẽesawa uuyã'jtx, aça' pe'jçxa sxawedna me'j Israel kiweníi jĩte', ");
INSERT INTO pbb_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Jose' sxawedna u'kh Israel kiwen luuçx petx njĩ'j yã'jçxa. ");
INSERT INTO pbb_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Nawa Herodes pa'gate nçxi'k Arkelao Judeate jxkaahna ũste jiyuçxa', ũukhku kxtee pa'jya' yu'. Sa' ksxa'wte' pta'sxnik yuu, txãasak Galilea kiwen u'j. ");
INSERT INTO pbb_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Kxtee pa'jçxa', teeçx çxhab Nasaret yaasesatek u'p-ya' u'j. Nyafxiitey Dxus yuwe pta'sxsawe'sx we'weçxa', Jesusa' Nasareno ya'kxsusuna jĩ'tx txã'jĩni kxtey yuukahnçxáak txã'wẽ yũu. ");
INSERT INTO pbb_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Txãa ensu' Juan Bautista' Dxus yuwe's pta'sxna pa'kh Judea kiwesu nasa u'pnimeesu. ");
INSERT INTO pbb_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Sa' na'jĩ'k: —Pkaltxi nvxihtçxa Dxus tasxte misxawedwe. Txã'wẽme', Dxus jxkaahwa'j ena' ãjxã'kh jĩ'k. ");
INSERT INTO pbb_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Naa Juana'sku we'wena fxi'j Dxus yuwe pta'sxsa Isaiasa' na'jĩna: Nasa u'pnimée kiwesu sus we'weni pthũusek: Dxus pa'jwa'ja's mpheu'jwe, Dxi'ja's ku'le phaadena jĩ'k. ");
INSERT INTO pbb_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Juana' kamelxo khas atxh athçxa kha'txku jxtudu'. Sa' txajx ũ'nisa yu', khã'sx wala çxhi'dx miltxi yu'. ");
INSERT INTO pbb_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Kxtee wẽse'jya' pa'jtx Jerusalenuwe'sx vxite' Judea kiwesuwe'sx jxuka vxite' Jordan yu'wala utxasuwe'sxwa. ");
INSERT INTO pbb_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Sa' txã'wẽ pkalsatha'w jĩna Dxusa's perdon pẽjxna pa'jsatxi' Juana' Jordan yu'walate bautisaĩ'k. ");
INSERT INTO pbb_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Nawa fxariseowe'sx vxite' saduceowe'sx txã'wẽ thegya' yuhte uyçxa', Juana' na'jĩ'k: —I'kwe'sxa' ul weesweesa ji'ji'kwe txãa pa'ga kastigo seena'sa yuja', aça' txajũ iyuwa'ja's ¿kimga pta'sx? ");
INSERT INTO pbb_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Txã'wẽ kastigo seena'saju iyuwa'ja's jiyuyã'jçxa', ewçxáa yũuna mfxi'zewe, kxah maawa ew fxi'zeni's uysa': Naawe'sxa' pkaltxi nvxihtçxa Dxus luuçx yuh yuuta sũjutxna. ");
INSERT INTO pbb_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Txã'jĩte', i'kwe'sxa' na'wẽ iiwejçx yaakxnuwe: Kwe'sxa' Abrahan ji'tha'w na' pkalsameetha'w sũhna yaakxwa'j ji'phmée i'kwe. Na'jĩ'th na': Naa kwet yuhtxwa Abrahan ji'j vxit-ya' ãjana Dxusa'. ");
INSERT INTO pbb_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Txã'wẽ ew fxi'zemeete', ama' ih yã'j ũsa' fxtũutasxtxi spẽ'thya'. Maa fxtũutasxwa ew yũnsameetxi' spẽ'thçxa ipxte kabwa'jçxáa yuuna. ");
INSERT INTO pbb_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Adxa' i'kwe'sxtxi' yu'teçxáath bautisaĩ' pkaltxi nvxihtçxa Dxus tasxte sxawedsatxi'. Nawa adx e'suh vxite yuja' txã' Dxus Espiritu ipx na'wẽsate bautisaĩna. Txã' adxte jxthaakwe ãjawa'jsa', aça' adxa' txajx pelgatxiçxáa yuhtxwa ũsya' seelpimeesath. ");
INSERT INTO pbb_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Txã' skuutxh kweejxa'jni plaatu's kusete at yã'jçxa ũsa' na' skuutxha's tamaju txudena sũupi'jna. Txã'wẽ yũuçxa skuutxha's jxaawuuna. Nawa tama yu'sa' kabuna ipx bagaçxte yuhwa ũçxhawa'jmeesate jĩ'k. ");
INSERT INTO pbb_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Naapkaçxha' Jesusa' Galilea kiweju yuhçxa Jordan yu'wala pukate Juan ũsnite pa'kh, Juan yu'te bautisãykahn. ");
INSERT INTO pbb_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Nawa Juana' Jesusa's bautisãy wẽemeeçxa na'jĩk: —Wejx yuuwa idx adxa's bautisãywa'jsag, sa' ¿ma'wẽga adxa's pi'ki' idxa's bautisãykahn? jĩte', ");
INSERT INTO pbb_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Jesusa' na'wẽk pas: —Dxus jxthãasni's kxtey yuuní wejx ewna jĩte', Juana' kxtey nwẽese'kh. ");
INSERT INTO pbb_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Aça' Jesusa' yu'te ya'bautisãyçxa kasejeçpkaçxha', cielu' phaatek, aça' Jesusa' uyku Dxus Espiritu tub çxihme na'wẽsa txajx kajkwete kĩjaçte. ");
INSERT INTO pbb_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Aça' we'weniwa pthũusek cieluju na'jĩna: —Naaíi Adx Nçxi'k wala wedxnisa'. Txãa pa'ga wala weçxana ũsthu jĩk. ");
INSERT INTO pbb_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Txajũ' Dxus Espiritu' Jesusa's pe'jna u'kh nasa u'pnimée kiwesu, kxteea' eçxthẽ'j ĩsxii wẽeni fxi'zeya'. ");
INSERT INTO pbb_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Sa' kuarenta en kuarenta kus kĩhwa ũ'mée u'pçxa', Jesusa' wẽek. ");
INSERT INTO pbb_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Aça' eçxthẽ'ja' Jesus tasxte utxaaçxa na'jĩnak we'we ewmée vxit wẽeçxa: —Dxus Nçxi'k dxihçxa', naa kwettxi pan myuukaah jĩte', Jesusa' na'wẽk pas: ");
INSERT INTO pbb_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","—Dxus librute na'jĩ'k: Nasa' pan yakhçxáa yu' ĩtxi fxi'zemeetxna, naasáa jxuka Dxus we'weni yakh yuuçxáa ĩtxi fxi'zetxna jĩk. ");
INSERT INTO pbb_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Txajũ' eçxthẽ'ja' Jesusa's pe'jna u'kh Jerusalen çxhabna, sa' kxteea' dxuus yatte ẽete kaateka'jçxa, ");
INSERT INTO pbb_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","na'wẽk jxkaah: —Dxus Nçxi'k dxihçxa', ay ẽejũ mũph. Txãa pa'gatey Dxus librute na'wẽk we'we': Dxusa' txajx angeleswe'sxtxi jxkaajana idxa's nwe'wekahn. Aça' txãawe'sxa' kusete jxpa'gatxna, Iidx çxida kwette kpã'yuukahmen jĩna fxi'jni' jĩte', ");
INSERT INTO pbb_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Jesusa' na'wẽk pas: —Vxite ahte Dxus librute' na'wẽk we'we': Idxna jxpe'jsa Dxusa's jxkaahwa'j ji'phmeeg jĩna fxi'jni' jĩk. ");
INSERT INTO pbb_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Txajũ' eçxthẽ'ja' ki' pe'jna u'kh vxiç walate, sa' txãajũ maa kiwesu çxhabtxiwa seena' zhiçxkwesa's kaavxya'jak. ");
INSERT INTO pbb_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Sa' na'jĩk: —Adxa's peejxũkweçxa neewe'wene'ga aça' adxa' na'sa' jxuka idxa's ũsu'nja jĩte', ");
INSERT INTO pbb_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Jesus pasçxa': —Eçxthẽ'j, adx tasxu mtxutée, txãa pa'gatey Dxus librute na'jĩ'k: Idxna jxpe'jsa Dxusçxá's neewe'wewa'ja', sa' txãaçxá's selpiwa'ja' jĩna fxi'jni' jĩte', ");
INSERT INTO pbb_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","eçxthẽ'ja' Jesus tasxu txuteek, aça' Dxus angeleswe'sxa' pu'çxya' pa'jtx. ");
INSERT INTO pbb_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Juan Bautista' kxuuphni ũsa' jĩni's Jesusa' jiyuçxa', Galilea kiwen u'kh. ");
INSERT INTO pbb_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Nawa Nasaret çxhabte yu' yujumée, Kapernaum çxhabtek u'p-ya' u'j. Txãa çxhaba' Zabulón vxite' Nefxtalí kiwe txãa ja'dasuk ũsu' ĩkh pukaga. ");
INSERT INTO pbb_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Txã'wẽ yũuk nawa Dxus yuwe pta'sxsa Isaias fxi'jni kxtey yuukahnçxáak txã'wẽ yũu. Txã' na'jĩnak fxi'j: ");
INSERT INTO pbb_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Zabulón Nefxtalí txãawe'sx kiwesu u'psa, Vxite' ĩkh pukasu dxi'j u'jna ũsa' txãa ja'dasu u'psa, Vxite' Jordan yu'kuteju, sek kãani ju'guwe'sx, Vxite' Galilea kiwesu judiu ji'jmeesawe'sx ");
INSERT INTO pbb_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Txãa nasa' çxhi'dxte ũssa na'wẽ ũsçxawa, Eena'sa's uytxi. Sa' uuníi na'wẽçxáa yã'j ũstewa, Eena'sa' kweethku jĩ'k. ");
INSERT INTO pbb_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Txajũ' Jesusa' Dxus yuwe's pta'sxya' takhku: —I'kwe'sxa' pkaltxi nvxihtçxa Dxus tasxte misxawedwe. Txã'wẽme', Dxus jxkaahwa'j ena' ãjxã'kh jĩ'k. ");
INSERT INTO pbb_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Jesusa' Galilea ĩkh pukasu u'jweççxa', e'z pxakhtxi uyku, Adres vxite nyakha's Simon Pedro jĩ'tx txãawe'sxtxi. Txãawe'sxa' wedx uwesaatx yu', txãasatx wedx ukhe's ĩkhte akhna ũsu'. ");
INSERT INTO pbb_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Aça' Jesusa' na'jĩk: —Adx yakh myuhwe, aça' Dxus jĩi nasaa pkhakhwa'jsa vxitu'nja i'kwe'sxtxi'. ");
INSERT INTO pbb_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Txã'jĩçpkaçxha', wedx ukhetx nvxihtçxa txãa yakh u'jtx. ");
INSERT INTO pbb_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Aça' Jesusa' txãajũ wejkuẽ u'jnaçxáa, vxite e'z pxakhtxi uyku, Zebedeo nçxi'kwe'sx Jakobo vxite' Juan txãawe'sxtxi. Txãawe'sxa' barkote ney yakhtxi u'p yu', wedx ukhe's pã'khna. Aça' Jesusa' pa'yak. ");
INSERT INTO pbb_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Naapkaçxha' barko vxite' txãawe'sx neyna nvxihtna'wa Jesus yakh u'jtx. ");
INSERT INTO pbb_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jesusa' Galilea kiwe jxukak pekũh, judiuwe'sx pkhaakheni yat-su Dxus jxkaahwa'j yuwe ewsa's pta'sxna, txã'wẽy nasa kĩh weete ãça'satxwa jxuka nuykatxhik. ");
INSERT INTO pbb_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Txajũ' Siria kiwesuwe'sx jxuka jiyutx Jesus txã'wẽ yũuni's. Txãa pa'gatx fxiyfxiy ãça'satxwa jxuka jxũna pa'j, aka ji'phsa vxite' eçx iiyamunisa vxite' wẽeçxpa'jsa vxite' ẽseya' ãjasameetxwa jxuka. Txã'wẽsatxku Jesusa' nuykatxhi. ");
INSERT INTO pbb_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Txajũ' Jesus yakh pi'kxna u'juya' nasa wala utxaatx, Galileajuwe'sx vxite' Dekapolis kiwesuwe'sx vxite' Jerusalenuwe'sx vxite' Judea kiwesuwe'sx vxite' Jordan yu'kutejuwe'sx. ");
INSERT INTO pbb_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Nasa wala kuh kasehte uyçxa', Jesusa' txajx txhitxhnisawe'sxtxi thã'thek pe'jna u'j. Aça' txãawe'sxa' txajx tasxte utxaate', ");
INSERT INTO pbb_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","na'wẽk kaapiya'jya' takh: ");
INSERT INTO pbb_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Wala yuh weçxa yuja' Dxusa's peejxçxa pakwesáa yakha', txãa pa'gatey txã'wẽ yũusa' Dxus jxkaahna ũsnite u'kaya' ãjawa'jsata' naa pa'ga. ");
INSERT INTO pbb_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Wala yuh weçxa yuja' ewmeete fxi'zeni's jiyuçxa ũ'nena Dxusa's yaakxsa yakha', txãa pa'gatey txã'wẽ yũusa' Dxus kvxiisxa'jni yuuwa'jsata' naa pa'ga. ");
INSERT INTO pbb_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Wala yuh weçxa yuja' wa'lmée Dxus tasxte utxasáa yakha', txãa pa'gatey txã'wẽ yũusá' naa kiwe jxuka txãawe'sx jĩiçxaçxáa yuuna pa'jwa'jsa' naa pa'ga. ");
INSERT INTO pbb_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Wala yuh weçxa yuja' Dxus dxi'pte ew fxi'zewa'ja's yuuçxáa ũusuh jxuka yajkxçxa pakwesáa yakha', txãa pa'gatey txã'wẽ yũusaatxi' Dxusa' pu'çxhina. ");
INSERT INTO pbb_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Wala yuh weçxa yuja' vxitetx peeygãhna fxi'zesa yakha', txãa pa'gatey txã'wẽ yũusa' Dxus peeygãanitx fxi'ze' naa pa'ga. ");
INSERT INTO pbb_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Wala yuh weçxa yuja' ũuste kĩh pkala's yuhwa ka'ga'jmée fxi'zesa yakha', txãa pa'gatey txã'wẽ yũusa' Dxusa's uyya' ãjawa'jsata' naa pa'ga. ");
INSERT INTO pbb_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Wala yuh weçxa yuja' puiimée fxi'zewa'ja's pakwesáa yakha', txãa pa'gatey txã'wẽ yũusa' Dxus luuçxta' naa pa'ga. ");
INSERT INTO pbb_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Wala yuh weçxa yuja' Dxus yakh fxi'zepa'ga yahçena fxi'zesa yakha', txãa pa'gatey txã'wẽ yũuni fxi'zeçxawa Dxus jxkaahna ũsnite u'kawa'jsata' naa pa'ga. ");
INSERT INTO pbb_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","I'kwe'sxa' wala yuh weçxana mfxi'zewe, adxna nwẽese'pha'gaçxáa nasa' wẽesxuna pkxuuna kĩjkĩhwa ewmée nuywe'weçtewa. ");
INSERT INTO pbb_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Txãa pa'gatey cielute' wala yuh jxpa'gawa'j ji'phi'kwe naa pa'ga. Dxus yuwe pta'sxsa txãniiteywe'sxtxi txã'wẽtx pkxuu na' ãçxhwa txã'wẽyçxáa yuutxna, nawa nxusmée weçxana mfxi'zewe. ");
INSERT INTO pbb_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","I'kwe'sxa' nega na'wẽ naa kiwete pẽethewa'jsa i'kwe. Nawa nega' sxũukãhçxa', ¿ma'wẽ pẽethejekx? Kĩh yũuwa'j yuhwa selpimeena, naasáa puhbçxa nasaa wakhi'khi'jwa'jçxáa yuuna. ");
INSERT INTO pbb_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","I'kwe'sxa' naa kiwete eena' kweethsa i'kwe. Teeçx çxhab thã'j vxiçga ũssa' ¿nasa uynimée ũsma'k? ");
INSERT INTO pbb_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Lampara's aphçxa txajxa' txã'wẽ ya'pki'ta'çme', wejxwa ãatek ya'txaja', yatte jxuka kweethkahn. ");
INSERT INTO pbb_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Txã'wẽy i'kwe'sxwa eena' mkweethwe nasaa dxi'pte, kxah i'kwe'sx ew fxi'zeni's uyçxa', Dxus ewsa ũsyuju'ga jĩna we'wetxna i'kwe'sx Tata cielute ũssa's. ");
INSERT INTO pbb_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Moises ley vxite' Dxus yuwe pta'sxsawe'sx kaapiya'jni txãatx nwẽese'jya'méene' yuwé' sũhna yaakxnuwe adxa's. Txã'wẽ yũuya' yuwe'çmeeth, wejxwa txãa leya's jxthaakwe ew ãate kaajiyu'jya'th yuwé'. ");
INSERT INTO pbb_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Isath pta'sxi', cielu petx kiwe yã'jçxa skhẽwpkaçx txãa leytxi' le'çxkuẽçxáa yuhwa e'skhẽ nvxihtmée jxuka nwẽese'jwa'tha'. ");
INSERT INTO pbb_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Txãa pa'ga maawa txãa ley jxkaahnitx wala le'çxkuẽesa kĩhtewa selpiwa'jmeesa na'wẽ thegte txãatxi' nvxihtçxa, nasatxwa txã'wẽ yũuya' íiçxáa kaapiya'jana na', txã'wẽ yũusa' Dxus jxkaahna ũsnite le'çxkuẽçxáa seelpisa' jĩni yuuna. Nawa txãa leytxi le'çxkuẽçxáa yuhwa nvxihtmée jxuka nwẽese'jçxa vxitetxwa txã'wẽy nwẽese'jya' kaapiya'jsa', Dxus jxkaahna ũsnite wala seelpisa' jĩni yuuna. ");
INSERT INTO pbb_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Na'jĩ'th na': i'kwe'sxa' kaapiya'jsawe'sx vxite' fxariseowe'sx fxi'zenite jxthaakwe ew fxi'zemeeçxa', bagaçxte yuhwa Dxus jxkaahna ũsnite u'kaya' ãjameene'kwe. ");
INSERT INTO pbb_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","I'kwe'sx yaçgawe'sxtxi na'jĩna kaapiya'jni's iiwẽse'jne'kwe: Nasa ikhwa'jme'. Txã'wẽme', nasa ikhsatxi's maatxwa kastigãywa'j yuuna jĩ'tx. ");
INSERT INTO pbb_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Nawa adxa' na'wẽth jxkaaja': Nasa yu's ikhmeeçxawa, peekx yakhthẽ'ja's ũusçxa yaakxpa'gaçxáa txãawa yuuwesa kastigãywa'j yuuna. Meeçxawa peekx yakhthẽ'ja's wáa açewe'wena aça' txã'sa' khuẽswe'sx tasxte jxũna u'jni yuuna. Sa' peekx yakhthẽ'ja's wẽesxute', txã'sa' kastigo infxiernote akhwa'j yuuna. ");
INSERT INTO pbb_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Txã'wẽ Dxusna peeswa'j ofxreda's jxũna pa'jçxa altalte akhmey yaakiwá'ga iidx yakhthẽ'j idxa's açeni's, ");
INSERT INTO pbb_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","sa' txãa ofxreda's altal pukate nvxihtna'wa u'jwene'ga iidx yakhthẽ'ja's perdon pẽjxya'. Txã'wẽ yũuçxa txãa ofxreda's altalte akhene'ga. ");
INSERT INTO pbb_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Maawa idxa's açesa pãatxhĩ'khçxa khuẽs tasxna jxũna u'jweçte', khuẽs tasxte pa'jmey dxi'kha mpuutxwe'we khuẽs tasxte jxũna u'khamen. Txã'wẽme' khuẽsa' policiawe'sxtxi dukhte', txãawe'sxa' karcelte txajatxna. ");
INSERT INTO pbb_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Adxa' isath we'we', txajũyã'ja' kasejxa' ãjameene'ga vxyu nmeh ji'phuni's dukhmeeçxa yu'. ");
INSERT INTO pbb_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","I'kwe'sxa' iiwẽse'jne'kwe na'jĩna nyafxiitey kaapiya'jni's: Ptamsayã'ja' vxite yakh pkal yuuwa'jme' jĩni's. ");
INSERT INTO pbb_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Nawa adxa' na'wẽth jxkaaja': Vxite yakh yu' pkal yuumeeçxawa, teeçx u'ya's ewmée yajkxçxa thegni yakhçxáa, pkal yã'kh yu' txajx ũuste. ");
INSERT INTO pbb_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Yafxa' idxa's pkalte kweete'phçxãh yuuçte', kutxi'jçxa mwãatah. Wejxwa teeçx yafxçxá's ivxiituçxa', kakwe jxuka yu' infxiernote akhni yuunimée wejx ewa'. ");
INSERT INTO pbb_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Meeçxa' paçu kuse txã'wẽ pkalte kweete'phçxãh yuuçte', spẽ'thçxa mwãatah. Wejxwa teeçx kuseçxá's ivxiituçxa', kakwe jxuka yu' infxiernote akhni yuunimée wejx ewa'. ");
INSERT INTO pbb_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Txã'wẽy nyafxiitey na'jĩna pta'sxni'swa iiwẽse'jne'kwe: Maawa nyu yakh txuteeççxa', txãa txuteni's eçte fxi'jçxa nvxiitwa'ja' jĩnatx kaapiya'ja'. ");
INSERT INTO pbb_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Nawa adxa' na'wẽth jxkaaja': Nyua' vxite yakh pkal yũuteçxáa nmi'a' txuteeya' ãjana. Txã'wẽme', pkal yũusameete peekxçxáa nmi'a' txuteeçxa', vxite yakh pkalte weteewa'ja's dxi'j phaadesa yuuna. Txãa pa'ga maa piçthẽ'jwa txãa u'y nvxiitnisa yakh ptamuuçxa', txãawa pkaltek wetesá yuuna pa'ja'. ");
INSERT INTO pbb_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","I'kwe'sx yaçgawe'sxtxi na'wẽ kaapiya'jni'swa iiwẽse'jne'kwe: Dxus yase's kxsusçxa jurãyni's ĩsxiimée kxtey yuuwa'ja' jĩ'tx. ");
INSERT INTO pbb_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Nawa adxa' na'wẽth jxkaaja': Kxtey yuune'jmeeçxa', ma'wẽsaçxáa yuhtxwa kxsusna jurãywa'jme'. Cielu's kxsusna jurãynuwe, txã' Dxus jxkaahna ũsni' naa pa'ga. ");
INSERT INTO pbb_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Sa' kiwe'swa kxsusna jurãynuwe, txãa kiwe' dxuus çxida txaahwa'j vxitnisa' naa pa'ga. Sa' Jerusalennawa kxsusna jurãynuwe, txãa çxhaba' jxkaahsa çxhaba' naa pa'ga. ");
INSERT INTO pbb_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Sa' peekx dxikthe's kxsusnawa jurãynuwe, txãa pa'gatey idxa' kĩhte yuhwa seelpimeesag Dxus dxi'pte naa pa'ga. Txãasa teeçx dxkhasçxáa yuhnawa çxihme vxit-ya' ãjawa'jsameeg, sa' khũçxwa vxit-ya' ãjameene'ga. ");
INSERT INTO pbb_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Jurãywa'j peejxme', isasa's teeçx jwedçxáa mwe'wewe, jiiçxa' jii íith jĩna, jiimeeçxa' jiimeeth jĩna. Txã'wẽme', ĩsxiina we'wenisa' eçxthẽ'j kwe'we'jni'. ");
INSERT INTO pbb_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","I'kwe'sxa' iiwẽse'jne'kwe na'jĩna nyafxiitey kaapiya'jni's: Iidx yafxa's kpã'vxitte', ka'tuwa txã'wẽy myũu. Sa' iidx ki'tha's çxkahdete', ka'tuwa txã'wẽy myũu jĩ'tx. ");
INSERT INTO pbb_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Nawa adxa' na'wẽth jxkaaja': Idxna ewmée yũusa's ka'tuja' iideewenu. Txã'wẽ yũumée, iidx dxi'pga pehtxate', ka'tu ju'guwe'sxnawa petxakahn mes. ");
INSERT INTO pbb_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Meeçxawa idxa's pãatxhĩ'khçxa iidx kmiisa's kusa'jaçte', jxkaaçni atxhnawa mes jxũna u'khan. ");
INSERT INTO pbb_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Teeçx ta'gute pa'j tu'sçxa nvxiht-ya' u'jwa'ja's jxkaathe', e'z ta'gute pa'j nvxiht-ya' me'j. ");
INSERT INTO pbb_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Maawa kĩhçxáawa idxa's thãaste', mes. Sa' pki'the', wa'lwa'jme' ji'phçxa'. ");
INSERT INTO pbb_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Nyafxiitey na'jĩna kaapiya'jni'swa iiwẽse'jne'kwe: Nasatxi' mpeeygãh, nawa açesa yuutxi' peeygãanu jĩ'tx. ");
INSERT INTO pbb_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Nawa adxa' na'wẽth jxkaaja': I'kwe'sxtxi açesatxi' mpeeygãhwe, sa' kxsewna ewmée we'wesatxi' ka'tu' ewçxáa mwe'wewe. Açesatxi' ew yũuna mfxi'zewe. Wẽesxuna pkxuusatxi' txãawe'sx pa'gate Dxusa's mneewe'wewe nwe'wekahn. ");
INSERT INTO pbb_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Txã'wẽ yũuçxaçxáa i'kwe'sx Tata cielute ũssa luuçxçxa txã'wẽ yuune'kwe. Txã' maa nasatxwa seka's kaakweethe'je'k, ewsa ma'k yuu meeçxa' ewmeesa ma'k yuu nawa jxukaysatx. Sa' txã'wẽy nusnawa kaja'k, ew yũusa ma'k yuu meeçxa' ewmée yũusa ma'k yuu nawa jxukaysatx. ");
INSERT INTO pbb_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Txã'wẽ i'kwe'sxtxi peeygãasaçxáatx ka'tuwa peeygãhçxa', ew yũusatha'w ¿jĩya' ãjama'kwe? Makwe nasa ewmeesa gobierno jĩi vxyu pkhakhsawe'sxwa txã'wẽ yũuwa'jçxáa yu'sa' ãja'tx aça'. ");
INSERT INTO pbb_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","I'kwe'sx yakhthẽ'jwe'sxçxáatx weçxate', ¿kĩh ew yũuni yaasena? Txã'wẽ yũuwa'j yu'sa' Dxusna jiimeesawa kxteytxi yũ'. ");
INSERT INTO pbb_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","I'kwe'sx Tata cielute ũssa' maa yakhwa jxuka ewsa' naa pa'ga i'kwe'sxwa txã'wẽy mfxi'zewe. ");
INSERT INTO pbb_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","I'kwe'sx ew yũuni's nasa uyçxa ew we'we jxthãasçxa mjĩini's wala mpa'yajkxwe. Txã'wẽ ew we'we jxthãasçxaçxáa ew yũuna fxi'zete', iidx Tata cielute ũssa' kĩh yuhwa dewemeena. ");
INSERT INTO pbb_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Txãa pa'ga peejxsatx kĩhçxáawa peesu'ççxa', nasa uykahn sũhçxa nasa ksxavxyte txã'wẽ yũunu. Ãateçxáa ew we'wesawe'sxçxáatx txã'wẽ yũ' judiuwe'sx pkhaakheni yat-su vxite' klxiikhunsu, nasa' uyçxa' ew yuh yũ'k jĩna tuuthe'j jxthãasçxatx txãawe'sxa' txã'wẽ yũ'. Nawa adxa' isath we'we': Txã'wẽ yũuçxa', nasaa pwe'sx tuuthe'jniçxáatx fxi'ze'. ");
INSERT INTO pbb_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Nawa peejxsatx kĩhçxáawa peesu'ççxa', kim yuhwa jiyunimeete paaçte txã'wẽ myũu. ");
INSERT INTO pbb_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Aça' paaçte txã'wẽ yũuçte iidx Tata uyçxa', idxa's deweena. ");
INSERT INTO pbb_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","I'kwe'sxa' Dxus yakh puutx we'weççxa', ãateçxáa ew we'wesawe'sx na'wẽ yũunuwe. Txãawe'sxa' judiuwe'sx pkhaakheni yat-su vxite' klxiikhunsu yujuçxatx Dxus yakh puutx we'wena pekũju' nasa uykahn sũhçxa. Isath we'we', txã'wẽ yũuçxa' nasaa tuuthe'jniçxáatx fxi'ze'. ");
INSERT INTO pbb_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Nawa idxa' Dxus yakh puutx we'weççxa', yat dxiite u'kaçxa vxitxa's aphçxa kim yuhwa uynimeete mpuutxwe'we. Aça' txã'wẽ paaçte puutx we'wete', iidx Tata cielute ũssa' deweena. ");
INSERT INTO pbb_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Dxus yakh puutx we'weççxa', lxisasáa na'wẽ txã'snaíiçxáa kuh us peenana ũswa'jme'. Dxusa's jiimeesaçxáatx txã'wẽ yũ', wala we'wete', Dxusa' wẽse'jena sũhçxa. ");
INSERT INTO pbb_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Txãawe'sx na'wẽy yũunuwe. Txã'wẽ yũumeetewa, i'kwe'sx Tata' jiiyã'ja' i'kwe'sx peejini's pẽjxumeyna. ");
INSERT INTO pbb_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Txãa pa'ga i'kwe'sxa' na'wẽçxáa Dxus yakh puutx we'wena na'jĩne'kwe: Kwe'sx Tata cielute ũssa Idxa' bagaçxtewa jxtuhthe nes yuune'ga. ");
INSERT INTO pbb_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Iidx jxkaahwa'j ena'sçxáatha'w ũythasu', Naa kiwete idx ma'wẽne'ga jxthãasu' txã'snaçxáa kxtey tee yuu cielute na'wẽy. ");
INSERT INTO pbb_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Kwe'sx ũ'wa'j een isa peejini's meen pees. ");
INSERT INTO pbb_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Kwe'sx ewmée yũuni's meen peltunaĩ, kwe'sxwa ma'wẽtka'w peltunãy kwe'sxtxi ewmée yũusatx txã'wẽy. ");
INSERT INTO pbb_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ewmeete wetekahmén, meen nwe'we. Txãa pa'gatey idx yuuçxáa kĩhtewa jxuka ãjawa'jsag, sa' bagaçxtewa idx yuuçxáa jxkaahna nes yuuwa'jsag. ");
INSERT INTO pbb_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Txã'wẽ i'kwe'sxwa ewmée yũusatx peltunãyte', i'kwe'sx Tata cielute ũssawa peltunaĩna i'kwe'sxtxi. ");
INSERT INTO pbb_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Nawa ewmée yũusatx peltunaĩmeete', i'kwe'sx Tatawa peltunaĩmeena i'kwe'sxtxi. ");
INSERT INTO pbb_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","I'kwe'sxa' yũunaççxa', maa nasawa uykahn sũhçxa ãate kaavxya'ja'jwa'jme'. Ãateçxáa ewtha'w jĩsaçxáatx txã'wẽ yũ' nasa jiyukahn. Isath we'we': Txã'wẽ yũuçxa' nasaa tuuthe'jniçxáatx fxi'ze'. ");
INSERT INTO pbb_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Nawa idx txã'wẽ yũunaççxa', dxi'pna pçxhĩ'çxçxa dxkhasnawa ew mkid, ");
INSERT INTO pbb_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","kxah idx yũunani's ãate kaavxya'ja'jmeete', nasa jiyumeetxna, naasáa iidx Tata yuuçxáa jiyuçxa idxa's deweena. ");
INSERT INTO pbb_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Naa kiwete kĩjkĩhwa ji'phuwa'ja's pa'pçxunuwe. Txã'wẽme', wes ũ'we'tx, aça' izwa suwu'tx. Naapkaçxha' peswé' pa'jçxa ji'phuni's kutxi'ji'tx. ");
INSERT INTO pbb_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Wejxwa cielute ji'phuwa'jçxá's wala mpa'pçxuwe. Kxteea' weswa ũ'meena, aça' izwa suwmeena, pesweewa kutxi'jmeena. ");
INSERT INTO pbb_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Txãa pa'gatey mtee jxaawni ji'phçxa', kxte yuuçxáak wejx jxthaakwe yajkxna ya'fxi'ze'. ");
INSERT INTO pbb_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Yafxa' kakwe's ewte kaafxi'ze'jsata'. Txã'wẽ iidx yafxa' ewsaçxá's thegsate', iidx kakwe' ewte sxiigmée fxi'zena. ");
INSERT INTO pbb_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Nawa iidx yafxa' ewmeesaçxá's thegsate', iidx kakwe' jxuka ewmeete çxhi'dxteçxáa fxi'zena. Txã'wẽ eena'te ew kaafxi'ze'jwa'jsa yuu ewmeete çxhi'dxtewe'sxa'sçxáa thegsate', bagaçxte yuhwa eena'te fxi'zewa'ja's ya'ji'phumeena. ");
INSERT INTO pbb_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Kim yuhwa e'z patrontxi selpiiya' ãjameena. Txã'wẽ vxiteçxá's wedxna fxi'zeçxa', vxite patron yu'sa' açena. Sa' teeçxsa jxkaahniçxá's kxtey yuuçxa', vxite patron jxkaahni yu'sa' kxtey yuuya' ãjameena. Txã'wẽy naa kiwete ji'phuni's pa'pçxuna Dxusnawa selpiina yuuya' ya'ãja'çme'. ");
INSERT INTO pbb_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Na'wẽth yu'kxpeje': I'kwe'sxa' kĩh yuhwa kuh yajkxmée mfxi'zewe, ¿kĩh ũ'wekxtha'w? sa' ¿kĩh athekxtha'w? sũhna. Txãa pa'gatey ũ'nisate jxthaakwe peejxsa ĩtxi fxi'zeni's ji'phyã'ji'kwe, sa' athnisate jxthaakwe peejxsa kakwe'swa ji'phyã'ji'kwe naa pa'ga. ");
INSERT INTO pbb_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Mthegwe ẽesu fxuusa vxiçxakwetx. Txãawe'sxa' uja'çmeeta', sa' ũ' pkhakhe'çwameeta', sa' tee jwedte jxaawu'çwameeta'. Txã'wẽtewa i'kwe'sx Tata cielute ũssa' txãa vxiçxakwetxi' peejxmeek sã'jĩ'. I'kwe'sxa' txãa vxiçxakwete jxthaakwe pa'gasa i'kwe, aça' wejx txã'wẽ sã'jĩna. ");
INSERT INTO pbb_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Txã'wẽ wala pa'pçxuçxa' ¿i'kwe'sx maaçxá' peena medio metro thaakwe walaaya' ãja'kwe'? ");
INSERT INTO pbb_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","¿Kĩjxa'çxáakwe txakwe pa'pçxu' i'kwe'sx athwa'j ropaçxá's? Mthegwe kite tasxtxi. Txãawe'sxa' mjĩ'çmeeta', sa' khaswa pudu'çmeeta', nawa ma'wẽta zhiçxkwe walá'. ");
INSERT INTO pbb_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Na'jĩ'th na': Jxkaahsa Salomon yuhwa txãa kite tasx na'wẽ yu' zhiçxkwe iijxũme' makwe wala ji'phsaçxawa. ");
INSERT INTO pbb_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Txã'wẽ kite tasxa' ãçxhíi yu' zhiçxkwe ũsçxawa, kuskusa' ipxte kabwa'jçxáak yu', nawa txã'wẽsa'swa Dxusa' wala zhiçxkwe pheu'ju'k na' i'kwe'sxtxi' wejx thaakwe ew pheu'juna. Txãa sũjxa' ãja'çmeene'kwe. ");
INSERT INTO pbb_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Txãa pa'ga i'kwe'sxa' kĩh yuhwa kuh yajkxmée mfxi'zewe, ¿kĩh ũ'wekxtha'w? sa' ¿kĩh athekxtha'w? sũhna. ");
INSERT INTO pbb_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Dxusna jiimeesaçxáatx txã'wẽ kuh yajkxna fxi'ze'. Nawa i'kwe'sxa' cielute Tata ji'phi'kwe txã' jxuka jiia' i'kwe'sx peejini's. ");
INSERT INTO pbb_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Txãa pa'ga i'kwe'sxa' Dxus yakh fxi'zewa'ja's khuẽ'y wejx thaakwe mpa'pçxuwe, txajũyã'ja' kĩhwa thẽymée vxyaana. ");
INSERT INTO pbb_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Ãçxha' jiyui'kwe na' kuskuskhẽwe'sxa's ũythasna pa'pçxunuwe. Txã'wẽme', kuskuskhẽ' pa'pçxuwa'j thaakwe thẽysa pa'jana een isa fxiyfxiysa. ");
INSERT INTO pbb_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Ma'wẽsatewa jiimeeçxa', ewmeesata' jĩna nuywe'wewa'jme', Dxus dxi'pte i'kwe'sxwa ewmeesa yuuya'mée. ");
INSERT INTO pbb_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Txã'wẽme', vxitesatx nuywe'wete', Dxusa' i'kwe'sxtxiwa ewmeesata' jĩçxa kastigaĩna nuywe'wepa'ga. I'kwe'sx ma'wẽ juuna' yũute', Dxuswa txã'wẽyçxáa juuna' kastigaĩna. ");
INSERT INTO pbb_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Iidx yakhthẽ'j yafxte kxtã' le'çxkuẽesa khẽeçxa ũste ¿ma'wẽ uyuki'g iidx yafxte yu' fxtũ pe'la yuu walasa khẽeçxa ũste txã's khuẽ'y kutxi'jmeeçxa'? ");
INSERT INTO pbb_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Sa' ¿ma'wẽ iidx yakhthẽ'ja's kxtã' le'çxkuẽsa iidx yafxte ji'phgu txã'sa' kutxi'jith jĩna we'weki'g, txã'wẽ iidx yafxte yu' fxtũ pe'la walasa's ji'phçxa'? ");
INSERT INTO pbb_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Ãakheçxáa ew we'wena u'jusa, iidx yafxte fxtũ pe'la walasa's khuẽ'y mkuutxi'j. Txã'wẽ yũuçxa iidx yakhthẽ'j yafxte kxtã' le'çxkuẽsa's ew uyçxa kutxi'jya' ãjane'ga. ");
INSERT INTO pbb_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Dxus yuwe's alkutx ũswa'jme', sa' kuçxitxwa ũswa'jme'. Txã'wẽme', jxuka wa'khi'khi'jçxa ũusaçxayã'jçxa', ũssa i'kwe'sxtxi íiçxáa wa'kxya' kũjutxna. ");
INSERT INTO pbb_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Dxusa's mpẽjxwe, aça' ũsuna, sa' pakweçxa', uyuune'kwe. Vxitxte mtu'kakawe, aça' phaadena. ");
INSERT INTO pbb_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Txã'wẽ maawa pẽysa' jxpa'gana, aça' pakwesá' uyuuna. Vxitxte tu'kakate', phaadeni yuuna. ");
INSERT INTO pbb_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","I'kwe'sx pwe'sx maaçxa' i'kwe'sx luuçx pan thãaste', ¿kweta's ũsma'kwe? ");
INSERT INTO pbb_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Meeçxa' wedx thãaste', ¿ula's ũsma'kwe? ");
INSERT INTO pbb_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","I'kwe'sxa' Dxus dxi'pte ewmeesaçxawa, i'kwe'sx luuçxtxi' ewsaçxáa i'kwe peesu', aça' i'kwe'sx Tata cielute ũssa' wejx thaakwe ewsa's peesuna thãassatxi'. ");
INSERT INTO pbb_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Bagaçxtewa i'kwe'sxtxi maa nasawa ewçxáa yũuna fxi'ze jxthãasçxa', i'kwe'sxwa txã'wẽy maa nasatxwa ewçxáa yũuna mfxi'zewe. Txãa pa'gatey Moises ley vxite' Dxus yuwe pta'sxsawe'sx fxi'jniwa txã'wẽçxaçxáatx jxkaaja'. ");
INSERT INTO pbb_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Vxitx pteezte me'kawe. Txã'wẽme', vxituwa'the u'kawa'j vxitxa' wala tape', aça' dxi'jwa txã'wẽy tape'. Kxteea' wala kuhsa u'kana ũsta'. ");
INSERT INTO pbb_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Naapkaçxha' vxitumée Dxus tasxte pa'jwa'j vxitxa' pteeza', aça' dxi'jwa txã'wẽy pteeza'. Kxtee yu' kuhmeeçxáa u'kana ũsta'. ");
INSERT INTO pbb_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Dxus jxkaahnisatha'w jĩna ĩsxiisatxi' mpa'yajkxwe. Txãawe'sxa' i'kwe'sx tasxte yu' piisxáa kakwe yakhtxi vxya', nawa ũuste yu' yu'kh eçx weeswée na'wẽsata'. ");
INSERT INTO pbb_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","I'kwe'sxa' txãawe'sx fxi'zeni's jiyune'kwe. Miiyajkxwe: Uwa's çhũçh tasxte ya'ude'çme', sa' brewa's khãas tasxte ya'ude'çme'. ");
INSERT INTO pbb_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Txã'wẽ fxtũu tasx ewsa' ewsaçxáak yũnu', aça' fxtũu tasx ewmeesa' ewmeesaíiçxáak yũnu'. ");
INSERT INTO pbb_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Fxtũu tasx ewsa' ũ' ewmeesa's yũnya' ãjameena. Txã'wẽy fxtũu tasx ewmeesa' ũ' ewsa's yũnya' ãjameena. ");
INSERT INTO pbb_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Maa fxtũu tasxwa ewmée yũnsa's spẽ'thçxa ipxte ya'kabu'k. ");
INSERT INTO pbb_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Txãa pa'ga txãawe'sx fxi'zeni's uyçxa jiyune'kwe ma'wẽsatewa. ");
INSERT INTO pbb_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Yuwejuçxáa adxa's ew we'wesa jxuka yu' cielute Dxus jxkaahna ũsnite u'kawa'jsameeta', naasáa adx Tata jxthãasni's kxtey yuusaçxáa cielute u'kawa'jsata'. ");
INSERT INTO pbb_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Txãasa cielute u'kawa'j en ãhte', wala yuh maawa adxa's na'jĩtxna: Kwe'sxtxi jxpe'jsa mwẽese'j: Kwe'sxa' iidx yuwe's pta'sxtha'w, sa' iidx yase's kxsusçxa eçxthẽ'jtxwa kutxi'tha'w, sa' kim yuhwa ãjanimeesa'swa kaavxya'ja'tha'w maz uswa jĩtxna. ");
INSERT INTO pbb_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Nawa adxa' na'jĩna pasu'nja: Bagaçxte yuhwa adx jxpe'jnisa yu'çmeei'kwe, naa pa'ga i'kwe'sxtxi' jiimeeth. Ewmée yũuna fxi'zesa' adx tasxtewe'sx meei'kwe. ");
INSERT INTO pbb_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Maawa adx jxkaahni's wẽse'jçxa kxtey yuusa', yat txajxa' jiisa na'wẽsa yuuna: Txãa yata's kwette kaaçxida'jçxa txahte', ");
INSERT INTO pbb_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","nus pa'jna, wejxa wala kiitena, yu' walaana yuuçxawa, yata's suwme', kwette kaaçxida'jçxa txaahnipa'ga. ");
INSERT INTO pbb_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Nawa maawa adx jxkaahni's wẽse'jçxawa kxtey yuusame', yat txajxa' jiimeesa na'wẽsa yuuna: Txãa yata's kwetmuseteçxáa txahte', ");
INSERT INTO pbb_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","nus pa'jna, wejxa wala kiitena, yu' walaana yuute', txãa yata' weteçxa jxuka suweek jĩk. ");
INSERT INTO pbb_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Txajũ' Jesus we'wena jxã'the', nasa' wala kuh yajkxna neeyũutx txajx kaapiya'jni's wẽse'jçxa, ");
INSERT INTO pbb_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","txã'wẽ leya's kaapiya'jsawe'sx na'wẽmée, nwẽese'jwa'ja's ũukhnus we'wena kaapiya'pha'ga. ");
INSERT INTO pbb_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Jesusa' thã'j vxiçu kĩhte', nasa iiméh wala kuh pkhaakhetx. ");
INSERT INTO pbb_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Aça' teeçx piçthẽ'j wã'jy wee seena' kazxsate ãça'sa Jesus tasxte utxaaçxa peejxũkweçxa na'jĩnak pxthaa we'we: —Adxa's peeygãhçxa' nuykatxhine'ga naa weeju jĩte', ");
INSERT INTO pbb_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Jesusa' na'jĩnak kuseju jxa'dx: —Ahçemée peeygãanisag, naa pa'ga katxhiçxa mneeyũu jĩçpkaçxha', txãa wã'jy weeju katxhiçxak neeyũu. ");
INSERT INTO pbb_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Aça' Jesusa' na'wẽk jxkaah: —Maa yuhtxwa pta'sxmeene'ga, naasáa sacerdote yuuçxáana iidx kakwe's txwesya' me'j. Sa' Moises ma'wẽga jxkaaja' txã'sçxáa kxtey yuune'ga, kxah nasa jxukaysa jiyutxna idx ew katxhiçxa neeyũutewa jĩk. ");
INSERT INTO pbb_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Txajũ' Jesusa' Kapernaum çxhabte pa'the', soldau kpiitan romanowe'sx utxaaçxa' pxthaa we'wek na'jĩna: ");
INSERT INTO pbb_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","—Adx yatte jxpe'jnisa uuya' yã'j ũsa' ẽseya' ãjameeçxa jĩte', Jesus pasçxa': ");
INSERT INTO pbb_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","—Adxa' u'jçxa nuykatxhi'nja jĩk. ");
INSERT INTO pbb_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Aça' kpiitana' na'wẽk pas: —Adxa' iidx dxi'pte kĩhte yuhwa seelpimeesath. Txãasath adx yatte iidx pa'jni's thaame', naasáa çxhãçxhana jĩna mwe'we aççxáa adx jxpe'jnisa' katxhina. ");
INSERT INTO pbb_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Adxwa ma'wẽtka walasa jxkaahnitxi' nwẽese'je', sa' adxna nwẽese'jsa soldauwe'sx iijxpe'th txãawe'sxtxi teeçxsa's me'j jĩte', adx jxkaahni's kxtey yu'k. Sa' vxite's pa'yate', txãawa kxtey nwẽese'je'k. Sa' adxna selpisa's kĩh jxkaathewa kxtey yu'k jĩk. ");
INSERT INTO pbb_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Txã'wẽ we'weni's Jesusa' wẽse'jçxa', wala kuh yajkxku, sa' na'jĩnak we'we txãa yakh yuusatxi': —Isath we'we', Israelwe'sx jxukaysa mteewe'sx yuhwa txã'wẽ adx we'weteçxáa katxhina sũhsa yu' iiuymeeth naa piçthẽ'j na'wẽsa yu'. ");
INSERT INTO pbb_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Na'jĩ'th na', judiu ji'jmeeçxawa wala yuh pa'jatxna sek kãanijũwe'sx vxite' sek khẽenijuwe'sx majũwe'sxwa jxuka, sa' Abrahan, Isaak, Jakob txãawe'sx yakh ũ'ya' kaçxhiitxna cielute Dxus jxkaahna ũsnite. ");
INSERT INTO pbb_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Naapkaçxha' kxtee ũswa'jsata' jĩnisa yu', kutxi'jçxa çxhi'dx walate akhni yuutxna. Kxteea' seena' yuh pebeena ki'thtxi ksuusu'jutxna ũukhna jĩk. ");
INSERT INTO pbb_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Sa' Jesusa' ki' we'wek kpiitana's: —Yatna me'j, aça' idx ma'wẽne'ga jxthãasu' txã' kxtey yuuna jĩçpkaçxha', txãa kpiitan jxpe'jnisa' katxhinik yuu. ");
INSERT INTO pbb_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Txajũ' Jesusa' Pedro yatnak u'j, sa' kxteea' Pedro nyu njĩ'ja' kakwesekte uuya' ũstek uy. ");
INSERT INTO pbb_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Aça' kusete jxa'dxku, naapkaçxha' kakweseka' ũçxhak. Txajũ' txãa u'ya' kiiteçxa selpiiya' kasejk. ");
INSERT INTO pbb_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Sa' txãa en jxuka çxhi'dxiçte', Jesus tasxte wala jxũna pa'jtx eçx iiyamunisatx. Aça' tee dxi'j we'weni yakhçxáa txãa eçxtxi' ũusuh kutxi'kh, sa' ãça'sa jxukaysatx nuykatxhik. ");
INSERT INTO pbb_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Nyafxíi Dxus yuwe pta'sxsa Isaiasa' na'jĩnak we'we: Txãaíik kwe'sx çxhãçxhamée fxi'zeni vxite' kwe'sx ãça'na fxi'zeni's jxuka txuhde jĩ'k txã'jĩni kxtey yuukahnçxáak txã'wẽ yũu. ");
INSERT INTO pbb_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Txã'wẽ nasa wala pkhaakhete', Jesusa' ĩkh kuten u'jwe'nja'w jĩnak we'we. ");
INSERT INTO pbb_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Txã'jĩte', ley kaapiya'jsa teeçxsa Jesus tasxte utxaaçxa', na'jĩk: —Idx yakh yuu wẽeth idx mtee u'jweçtewa jĩte', ");
INSERT INTO pbb_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Jesus pasçxa': —Yu'kh niimal yuhwa deewa'j kafx ji'phta', txã'wẽy vxiçxakwewa yat ji'phta'. Nawa Dxus Nçxi'k Nasa Yuusa' mtee yuhwa txajx dxiktheçxáa yuja'swa khikhwa'j ji'phme'. ");
INSERT INTO pbb_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Naapkaçxha' Jesusna nwẽese'jsa teeçxsa' na'jĩnak we'we: —Adxa's mkaah adx tata khuẽ'yna pedaawa'j ji'phthu jĩte', ");
INSERT INTO pbb_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Jesus pasçxa': —Uusaawe'sxa' peekx uusáa pwe'sx ya'pedaatxna. Aça' idxa' adx yakh txutemée myuh jĩk. ");
INSERT INTO pbb_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Txajũ' Jesusa' barkote khẽek aça' txãa yakh u'jusawe'sxa' pi'kxna u'jtx. ");
INSERT INTO pbb_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Txã'wẽ ĩkhte u'jweçpkaçxha', wejxaa wala sẽjk, aça' yu'tũçxhasa' barko's aphya'wak yu'. Nawa Jesusa' deenik yu'. ");
INSERT INTO pbb_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Aça' txãa yakh u'jusawe'sxa' fxĩtxtxi na'jĩna: —Kwe'sxtxi jxpe'jsa, meen nwe'we. Txã'wẽme', ĩkh dxiikhẽ khẽjeçtha'w jĩte', ");
INSERT INTO pbb_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","na'wẽk pas: —¿Kĩjxa'kwe txakwe wala ũukhu'? ¿I'kwe'sxa' Dxusna yajkxya' yu' ew jiimeewá'kwe? jĩçxa', kiiteçxa wejxa vxite' ĩkh txãatx we'wek, aça' jxuka yujuk. ");
INSERT INTO pbb_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Txã'wẽ yũute', barkote u'jsawe'sxa' wala kuh yajkxçxa na'jĩnatx we'we: —Naa piçthẽ'ja' ¿kimna açki'tx wejxa ĩkh txã'wẽsa yuhwa nwẽese'je'? jĩ'tx. ");
INSERT INTO pbb_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Txajũ' Jesusa' ĩkh kuteju Gadara kiwete pesathe', e'z piçthẽ'j uusáa pedani kafxju kasehçxa Jesus tasxte utxaatx. Txãa e'zsa' eçx iiyamunisatx yu', txãasatx iiméh seena' weeswée yu', txãa pa'ga txãa dxi'jsu kim yuhwa skhẽwya' ãja'çmeeta'. ");
INSERT INTO pbb_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Txãa eçx iiyamunisa' na'jĩnatx sus we'we: —Dxus Nçxi'k Jesus, kwe'sx nxuste ũswa'j en ãhmeyna, ¿nxuste akhya' yuwe'wá'ga? jĩ'tx. ");
INSERT INTO pbb_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Kxsũ thã'jsu kuçxi wala ũsu'tx aphna. ");
INSERT INTO pbb_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Aça' txãa eçxa' Jesusa's pxthaa we'wetx: —Kwe'sxtxi neeuççxa', txãa kuçxi ũussu khẽeya' u'khan mkaah. ");
INSERT INTO pbb_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Txã'jĩte', Jesusa' kxtey yuukaakh. Aça' txãa eçxa' nasa ũusuh kasehçxa txãa kuçxi ũustetx khẽe. Txã'wẽ yũute', txãa kuçxi' penxakhẽ peluçxa ĩkhkhẽ khẽeçxa jxuka uutx. ");
INSERT INTO pbb_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Aça' kxsũ kuçxi thegsa' ũukhçxa wuwuuçxáa çxhabna u'jçxa pta'sxtxi kĩh yũuni'swa jxuka. Sa' txãa e'z piçthẽ'j eçx iiyamunisawe'sxtxi kĩh yũutewa jxukatx pta'sx. ");
INSERT INTO pbb_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Txajũ' çxhabte nasa jxuka thegya' u'jtx Jesus ũsnite. Sa' uyçxa' Jesusa's txãawe'sx kiweju kasehna u'khaahtx. ");
INSERT INTO pbb_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Txajũ' Jesusa' barkote khẽeçxa sxawedçxa txajx çxhabtey ki' pa'kh. ");
INSERT INTO pbb_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Aça' kxteea' teeçx piçthẽ'j ẽseya' ãjasame'stxi yakhna pa'j. Txã'wẽ yakhna pa'jsawe'sxa' Jesusa' nuykatxhiyujuna sũhni's jiyuçxa', ãça'sa's na'wẽk we'we Jesusa': —Çxhãçxha myajkx. Iidx pkala' peltunãyni yã'jtx neeyũu jĩte', ");
INSERT INTO pbb_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","ley kaapiya'jsawe'sx maaíi yu' na'wẽtx yajkx: Naa piçthẽ'ja' Dxusa's iiweeçx we'wena ãjawa'jmeea'sku we'we' sũju'tx. ");
INSERT INTO pbb_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Nawa txãawe'sx yaakxni's Jesus jiyuçxa', na'jĩnak we'we: —¿Kĩh yuutekwe txã'wẽ ewmée yaaki'? ");
INSERT INTO pbb_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","¿Maa thẽymeesakx? Iidx pkala' peltunãyni yã'jtx neeyũu ¿jĩniá'? Meeçxa': Kiiteçxa me'j ¿jĩniá'? ");
INSERT INTO pbb_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Makwe thẽysatewa Dxus Nçxi'k Nasa Yuusa' naa kiwete pkaltxi peltunãyya' ãjawa'jsa' naa pa'ga kaajiyu'j ya'wath ãçxha'. Txajũ' ẽseya' ãjasame's na'wẽk we'we: —Kiiteçxa, iidx deeni's tu'sçxa yatna me'j jĩte', ");
INSERT INTO pbb_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","txãa ẽseya' ãjasameea' kiitena'wa u'kh txajx yatna. ");
INSERT INTO pbb_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Txã'wẽ yũuni's nasa uyçxa', ũukhtxi. Sa' Dxusna weçxana tuuthe'jtx txã'wẽ çxhãçxhawa'ja's Dxusa' peesne' sũhçxa. ");
INSERT INTO pbb_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Jesusa' txajũ u'jçxa', teeçx piçthẽ'j Mateo yaasesa txã'wẽ gobierno jĩi vxyu pkhakhna u'pte uyçxa', na'wẽk we'we: —Adx yakh myuh jĩna. Aça' Mateo' kiiteçxa Jesus yakh u'kh. ");
INSERT INTO pbb_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Txajũ' Jesusa' ũ'ya' yatte u'kak, aça' gobierno jĩi vxyu pkhakhsawe'sx vxite' pkalsawe'sxwa wala kuh u'katx vxite' Jesus yakh u'jusawe'sx yã'jçxa. ");
INSERT INTO pbb_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Aça' txã'wẽ yũuni's fxariseowe'sx uyçxa' pẽjxtxi Jesus yakh u'jusawe'sxtxi na'jĩna: —¿Ma'wẽçxaga i'kwe'sxtxi kaapiya'jsa' gobierno jĩi vxyu pkhakhsawe'sx vxite' pkalsawe'sx yakh ũ'wé'? ");
INSERT INTO pbb_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","jĩni's Jesus wẽse'jçxa', na'wẽk we'we: —Yu'çe'jsa's jxpeejxmeeta' aka ji'phmée wẽt ũssa', naasáa ãça'sa yuuçxáa yu'çe'jsa's jxpeejxta'. ");
INSERT INTO pbb_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Mpiyawe Dxus librute na'wẽ fxi'jni ũsa' txã'sna: Tajkx ikhçxa Dxusa's weçxana kabni yu'sa' jxpeejxmeeth. Adxa' vxitetx peeygãaniçxá'sthu jxthãasu' jĩ'k. Adxa' nasa ewsatx pakweya' kĩhmeeth, naasáa pkalsatx pakweya'çxáath kĩh, kxah ewmée yũuna fxi'zeni's nvxihtçxa Dxus tasxte sxaweduutxna. ");
INSERT INTO pbb_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Txajũ' Juan Bautista yakh u'jusawe'sxa' Jesus tasxte utxaaçxa na'wẽtx pẽjx: —¿Kĩh yuupa'gatka'w kwe'sx vxite' fxariseowe'sx txakwe wala yũuna', naapkaçxha' idx yakh u'jusawe'sx yu' yũuna'çmeeta'? jĩte', ");
INSERT INTO pbb_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Jesusa' na'wẽk pas: —Miiyajkxwe: ¿bodate pi'kxnisa' ũ'mée nxusna ũswa'jsatxmanx novxio' txãawe'sx yakh nee ũsiite'? Naasáa novxio's txãawe'sx tasxuh txuhdete yuuçxáa yũunaatxna. ");
INSERT INTO pbb_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Ropa ĩisxsate tela u'sesa yakh ya'pã'khe'çme'. Txã'wẽme', tela u'sesa' jweeíiçxáak sude' ĩisxsa's, aça' sutenisa' jweeíiçxáa wala suteena. ");
INSERT INTO pbb_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Txã'wẽy beka u'se aahnisa's slun ĩisxsate ya'awu'çme'. Txã'wẽme', beka u'sesa slun ĩisxsa's sude'k, aça' beka yakh slun yakh e'zíi vxitu'tx. Txãa pa'ga beka u'sesa's slun u'sesate awwa'ja'. Txã'wẽ yu', maa yuhwa vxitumeetxna. ");
INSERT INTO pbb_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Jesus txã'wẽ we'wena ũspkaçxha', judiu pkhaakhenite npiiçthẽ'jsa' Jesus tasxte peejxũkweçxa na'wẽk we'we: —Adx niisa' uuyã'kh. Nawa idx yuhçxa kuseju jxa'dxwaça', ĩtxi yuuna jĩte', ");
INSERT INTO pbb_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Jesusa' kiitena'wa txãa yakh u'kh, txãa yakh u'jusawe'sx yã'jçxa. ");
INSERT INTO pbb_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Txã'wẽ u'jweçpkaçxha', teeçx u'y doce anxu kakwe yu'te ãça'na u'jusa Jesus e'ste paaçte kũhçxa, atxh vxiçte kpaajxa'dxku. ");
INSERT INTO pbb_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Atxh vxiçteçxáawa jxa'dxwaça', katxhi'nja sũhçxak txã'wẽ yũu. ");
INSERT INTO pbb_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Nawa Jesusa' jiyuçxa txãa u'ya's thegçxa na'wẽk we'we: —Ũukhnuwe, wejxwa katxhini i'kwe neeyũu, txã'wẽ katxhi'nja sũhçxane'kwe txã'wẽ yũu naa pa'ga jĩte', txãa dudtey katxhiçxak neeyũu. ");
INSERT INTO pbb_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Txajũ' Jesusa' txãa npiiçthẽ'jsa yatte pa'jçxa uyku pedaaçte nxusna tukawa'jsa músiku jxuka pheu'jçxa ũste. Aça' nasa' nxusna wala ũ'nena ũste', ");
INSERT INTO pbb_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","na'wẽk jxkaah: —Ayjxu mkaasehwe. Luuçxa' uunime', deeniçxáa ũsa' jĩte', nasa' npeevxysxijkatx. ");
INSERT INTO pbb_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Nawa Jesusa' nasatx kasejkaahçxa dxiite u'kana'wa, txãa luuçxa's pu'kisuçpkaçxha', kiitek. ");
INSERT INTO pbb_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Aça' txã'wẽ yũuni's txãa kiwesu jxuka tuuthe'jnik yuu. ");
INSERT INTO pbb_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Txajũ' Jesus kasehna u'jweçte', uyya' ãjasamée e'ztxi sus we'wena yuwé': —Davxid Nçxi'k, kwe'sxtxi mpeeygãh jĩna. ");
INSERT INTO pbb_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Txajũ' Jesusa' yatte u'kate', txãa uyya' ãjasameewe'sxa' utxaana kũhtx. Aça' Jesusa' na'wẽk pẽjx: —¿Uywa'ja's ũsuna sũju'kwe' i'kwe'sxa'? jĩte', txãawe'sx pasçxa': —Txãa sũju'íitha'w jĩtx. ");
INSERT INTO pbb_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Aça' Jesusa' txãawe'sx yafxte jxa'dxku na'jĩna: —I'kwe'sx jxthãasni' kxtey yuuna jĩçpkaçxha', ");
INSERT INTO pbb_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","txãawe'sx yafxa' ewuutx. Aça' Jesusa' wala neewe'wek na'jĩna: —Kim yuhtxwa pta'sxmeene'kwe jĩtewa, ");
INSERT INTO pbb_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","txajũ kasehna' txãa kiwesu jxuka pta'sxtxi Jesus txã'wẽ yũuni's. ");
INSERT INTO pbb_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Txãawe'sx kasehna u'jweçpkaçxha', Jesus tasxte vxite piçthẽ'j nuypa'jtx, we'weya' ãjasamée eçx iiyamunisa's. ");
INSERT INTO pbb_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Aça' Jesusa' txãa eçxa's ũusuh kutxi'the', txãa piçthẽ'ja' we'weya' ãjak. Txã'wẽ yũute', nasa' wala kuh yajkxtxi na'jĩna: —Israel kiwete bagaçxte yuhwa na'wẽsa yu' iiuymeetha'w jĩ'tx. ");
INSERT INTO pbb_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Nawa fxariseowe'sx yu' na'wẽtx we'we: —Naa piçthẽ'ja' eçxtxi nasa ũusuh kutxi'ji'k, nawa eçxthẽ'j pu'çxteçxáak txã'wẽ yũ' jĩ'tx. ");
INSERT INTO pbb_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jesusa' çxhab walasu çxhab le'çxkwesu judiuwe'sx pkhaakheni yat iisa kaapiya'jnak pekũju'. Sa' Dxus jxkaahwa'ja'swa pta'sxna vxite' wee ma'wẽsate nasa ãça'satxwa nuykatxhina kĩh akatxwa jxuka kaykase'je'k. ");
INSERT INTO pbb_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Sa' Jesusa' txãa nasatx thegçxa', txãawe'sxtxi peeygãjk txã'wẽ nxusna çxhãçxhameekuẽ piisxáa namu ji'phmeesa na'wẽ ũspa'ga. ");
INSERT INTO pbb_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Sa' txãa yakh u'jusawe'sxtxi na'wẽk we'we: —Isath we'we', mjĩia' seena' wala', nawa mjĩisa yu' kuh meeta'. ");
INSERT INTO pbb_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Txãa pa'ga mjĩi namu's mpẽjxwe mjĩiwa'jsa kaakhan jĩk. ");
INSERT INTO pbb_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Txajũ' Jesusa' txãa yakh u'jusa docesatx pa'yaçxa na'wẽ yũuya' ãjawa'ja'sku ũs: eçxtxi nasa ũusuh kutxi'jna kĩh weete ãça'satxwa nuykatxhina, kĩh aka ji'phtewa jxuka yu'çe'jya' ãjawa'ja'sku ũs. ");
INSERT INTO pbb_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Txãa docesawe'sxa' na'wẽtx yaase yu': Nyafxtewe'sxa' Simonku yu', txã'sa' Pedro jĩ'tx. Vxite' txajx nyakh Adres. Vxite' Zebedeo nçxi'ktxi yu', Jakobo Juan pxakhsa. ");
INSERT INTO pbb_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Vxite' Fxelipe, Bartolomé, Tomás, vxite' Mateo gobierno jĩi vxyu pkhakhsa. Vxite' Alfxeo nçxi'k Jakobo, vxite' Lebeo txã'snaíiçxáa Tadeo jĩ'tx. ");
INSERT INTO pbb_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Vxite' Simonku yu', kananista nasa. Vxite' Judas Iskariote, Jesusa's açesawe'sx kusete dukhwa'jsa. ");
INSERT INTO pbb_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Txãa yakh u'jusa docesatx Jesusa' na'wẽk neewe'weçxa kaah: —Judiu ji'jmée vxite nasa kiwesu' u'jnuwe, sa' Samaria kiwesu çxhab ũstxna kxsũwa u'jnuwe, ");
INSERT INTO pbb_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","wejxwa Israel ji'j piisxakuẽ na'wẽ jxpubana ũsta' kxsũçxáa me'jwe. ");
INSERT INTO pbb_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Sa' pta'sxine'kwe Dxus jxkaahwa'j ena' ãjxã'kh jĩna. ");
INSERT INTO pbb_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Ãça'satxwa nuykatxhine'kwe, uusaatxwa ki' ĩtxi vxitune'kwe, wã'jy wee kazx ji'phsatxwa nuykatxhine'kwe. Eçxtxiwa nasaa ũusuh kutxi'jine'kwe. I'kwe'sx txã'wẽ ãjawa'ja's vxyupa'gamée i'kwe jxpa'ga na', nuykatxhipa'ga vxyu pẽjxmeene'kwe. ");
INSERT INTO pbb_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Kĩh vxyu yuhwa jxũmée me'jwe. ");
INSERT INTO pbb_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Ya'ja, spaatu, khãabu txãaçxáa yuhtxwa jxũmée me'jwe, naasáa teeçx kmiisaçxáa jxũçxa me'jwe, txãa pa'gatey mjĩisa' puuçni fxi'zewa'jsa'. ");
INSERT INTO pbb_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","I'kwe'sxa' çxhab wala meeçxa' çxhab le'çxkwesu mtee pa'jçxawa, kxtee paadejene'kwe nasa ewsa tasxsu, vxite ahte u'jwa'j en ãhpkaçx. ");
INSERT INTO pbb_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Yatte pa'jçxa, ewçxáa we'wena weçxana pa'jane'kwe. ");
INSERT INTO pbb_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Txãa yatte nasa ew jxpa'gate', Dxus yakh weçxana fxi'zewa'ja's pta'sxine'kwe. Nawa txã'wẽ yũumeete', pta'sxmeene'kwe. ");
INSERT INTO pbb_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Sa' i'kwe'sxtxi jxpa'gamée, pta'sxni'swa wẽse'jya' wa'lte', yatte ma'k yuu meeçxa' çxhabte ma'k yuu nawa txajũ kasejeççxa', i'kwe'sx çxidate kiwe tuhda's sakweekweçxa kasejene'kwe kxah yuuwesa yuutxna. ");
INSERT INTO pbb_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Isath we'we', Dxus kastigãywa'j en ãhte', txã'wẽ yũusa nasa' seena' yuh ya'kastigaĩtxna, Sodoma Gomoçxa çxhabsu nasate jxthaakwe. ");
INSERT INTO pbb_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Mwẽese'jwe, adxa' i'kwe'sxtxi piisxakuẽ na'wẽ kajaçthu yu'kh eçx ksxavxysu. Aça' i'kwe'sxa' ikhwe'sxte ul na'wẽ jxpa'yakx mfxi'zewe, nawa iideewewa'j yu'sa' ji'phmée tub çxihme na'wẽ myuuwe. ");
INSERT INTO pbb_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Mpa'yajkxwe, txã'wẽme' nasa' i'kwe'sxtxi uweçxa khuẽswe'sx tasxte dukhetxna, sa' judiuwe'sx pkhaakheni yat-suwa pãpatxna. ");
INSERT INTO pbb_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Kxsũçxáa kuutxa'jmée ne'jwe'sx tasxsu vxite' jxkaahsa tasxte yuhwa pe'jna u'jni yuune'kwe, adx yuwe's pta'sxpa'ga. Txã'wẽ yũutewa, kxsũwa txãawe'sx dxi'pte tuuthe'jeíiçxáa ne'kwe adxa's vxite' judiu ji'jmeesa dxi'ptewa. ");
INSERT INTO pbb_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Txã'wẽ khuẽswe'sx tasxsu kuutxa'the', kuh yaakxnuwe, ãçxha' ¿ma'wẽ pasukxtha'w? sũhna. Txãa pa'gatey txã'wẽ yũuçpkaçxha', Dxusa' i'kwe'sxtxi kaaũusuthe'jena ma'wẽ paswa'ja'swa. ");
INSERT INTO pbb_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","I'kwe'sx ũus yaakxniju we'wemeene'kwe; Dxus Espiritu i'kwe'sxtxi kwe'we'jena. ");
INSERT INTO pbb_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Peekx nwe'sxíiçxáa txãawe'sx nyakhtxi ahçeçxa kiikhe'jetxna. Aça' neywe'sxa' peekx nçxi'ktxi ahçeçxa kiikhe'jetxna, naapkaçxha' nçxi'kwe'sxa' neywe'sxtxi ahçeçxa kiikhe'jetxna. ");
INSERT INTO pbb_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Adxna nwẽese'pha'ga naa kiwete nasa jxukay i'kwe'sxtxi açetxna. Txã'wẽtewa, ũukhmée çxhãçxha uu entepkaçx fxi'zesa' txãawe'sx ũusa' Dxus nwe'weni yuutxna. ");
INSERT INTO pbb_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Txã'wẽ ahçeçxa ikhya' pakweeçpkaçxha', txãa çxhabuh kasehçxa vxite ahte me'jwe. Isath we'we', i'kwe'sx txã'wẽ Israelwe'sx çxhabsu jxuka pekũhmeyna, Dxus Nçxi'k Nasa Yuusa' kĩijana. ");
INSERT INTO pbb_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Piyasa' maa yuhwa kaapiya'jsate jxthaakwemeeta'. Txã'wẽ selpisa' patronte jxthaakwesame'. ");
INSERT INTO pbb_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Kaapiya'jsa ma'wẽ pkxuuni yuute', piyasaawa txã'wẽy nxuswa'ja's jxpa'gawa'jsata'. Aça' selpisaawa patron ma'wẽ pkxuuni yuute', txãawa txã'wẽy nxuswa'ja's jxpa'gawa'jsa'. Yat namu's Eçxthẽ'j jĩna kxsusçxa', txajx jxpe'jnisa yuutxi' wejx txã'jĩna we'wetxna. ");
INSERT INTO pbb_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Txã'wẽ yũutewa, nasatxi' ũukhnuwe. Adx we'weni' kĩh yuhwa txã'wẽ paaçte yu' neeyũuwa'jsame', sa' kĩh yuhwa txã'wẽ sũthçxa jiyunimée yu' neeyũumeena. ");
INSERT INTO pbb_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Adxa' i'kwe'sxçxáatxthu we'we', nawa txãa we'weni's nasa ma'wẽsatxwa jxuka ãate mwe'wewe. Sa' naa ja'date ayteçxáa we'weni's msuuwa jxuka mwe'wewe. ");
INSERT INTO pbb_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Kakweçxá's ikhsa's ũukhwa'jme'. Txãawe'sxa' ũus yu'sa' ikhya' ãjameetxna. Wejxwa kakwe petx ũus yã'jçxa infxiernote kaajxa' ãjawa'jsa's wejx ũukhwa'ja'. ");
INSERT INTO pbb_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","E'z vxiçxakwetx teeçx centawote ¿txweyu'çyuhmeetxna' wakx? Txã'wẽ pa'gameekwesaçxawa, maa yuhwa kiwekhẽ wete'çmeeta', i'kwe'sx Tata' txã'wẽ jxthãasmeete yu'. ");
INSERT INTO pbb_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","I'kwe'sx dxikthete dxkhas yuhwa jxuka isani ũsta'. ");
INSERT INTO pbb_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Ũukhnuwe, i'kwe'sxa' txãa vxiçxakwete jxthaakwe pa'gasai'kwe. ");
INSERT INTO pbb_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Maawa ũukhmée adx ju'gu we'wesatxi', adxwa adx Tata cielute ũsa' txajx tasxte txãawe'sx ju'gu we'we'nja. ");
INSERT INTO pbb_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Nawa maawa nasatx ũukhçxa adxa's jiimeeth jĩna ĩsxiijana txã'sa' adxwa txã'wẽyçxáa jiimeeth jĩna we'we'nja adx Tata cielute ũsa' txajx tasxte. ");
INSERT INTO pbb_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Naa kiwete yahçemée fxi'zewa'ja's nvxiht-ya' kĩhmeeth, nxuste yahçena fxi'zewa'ja's nvxiht-ya'th kĩh. ");
INSERT INTO pbb_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Adxna nwẽese'pha'gaçxáa neya' nçxi'ka's açena, naapkaçxha' njĩ'ja' niisa's açena, aça' swegra' nkuẽmyu's açena. ");
INSERT INTO pbb_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Txã'wẽ adxna nwẽese'pha'ga peekx yattewe'sxíiçxáa yaaçeni fxi'zetxna. ");
INSERT INTO pbb_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Maawa adx yu's yajkxmée naasáa ney vxite' njĩ'j txãawe'sxçxáatx jxthaakwe yaakxsa', adxa's selpiiya' ãjameetxna. Txã'wẽy maawa adx yu's yajkxmée naasáa nçxi'k vxite' niisa txãawe'sxçxáatx jxthaakwe yaakxsa' adxa's selpiiya' ãjameetxna. ");
INSERT INTO pbb_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Makwe thẽysa uuwa'jma'k pa'j nawa txãatxi' yajkxmée fxi'zesame' adx tasxte selpiiya' ãjameena. ");
INSERT INTO pbb_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Naa kiwete peekx ĩtxi fxi'zewa'jçxá's ya'nwe'wesa', cielute fxi'zewa'j thaakwe ewsa yu'sa' ivxiituna. Naapkaçxha' adxna nwẽese'pha'ga naa kiwete ĩtxi fxi'zeni's yajkxmée ivxiitusa' cielute ĩtxi fxi'zewa'j yu'sa' ivxiitumeena. ");
INSERT INTO pbb_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Maawa i'kwe'sxtxi wa'lmée jxpa'gasa', adxnawa jxpa'gasaçxa txã'wẽ yuuna. Sa' adxna jxpa'gaçxa', adxna jxkaahsanawa jxpa'gasa yuuna. ");
INSERT INTO pbb_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Dxus yuwe pta'sxsa txãawe'sxa' Dxus jxkaahnisata', aça' maawa txãawe'sxtxi wa'lmée ew jxpa'gasa', Dxus peesni's jxpa'gawa'jsata', Dxus yuwe pta'sxsatx peesni's íiçxáa. Sa' nasa ewsatx jxpa'gasa' ewsaçxa txã'wẽ yuuna, sa' nasa ewsatx dewenisa's íiçxáa jxpa'gana. ");
INSERT INTO pbb_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Isath we'we': Adxna nwẽese'jsa makwe wala ãhmeekwesatewa txã'sna yu'fxizeçxáawa yussa' dewenisa yuuna. ");
INSERT INTO pbb_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Jesusa' ma'wẽ yũuwa'ja'swa txãa yakh u'jusa docesatx pta'sxna jxã'jçxa', txajũ kasehna u'kh txãa kiwesu çxhab le'çxkwesu kaapiya'jya'. ");
INSERT INTO pbb_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Aça' Jesus txã'wẽ yũuni's Juan Bautista kxuuphni ũsçxa jiyuçxa', txajx jxpe'jnisatx Jesus tasxna kaakh ");
INSERT INTO pbb_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","na'jĩna pẽjxya': —Kristo naa kiwete kĩiwa'jsa ũsu'k idxa' ¿txãa dxihgá', meeçxa' vxite ũythasuwá'nja'w? jĩte', ");
INSERT INTO pbb_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Jesusa' na'wẽk pas: —U'jçxa Juana's pta'sxine'kwe adx na'wẽ yũuna fxi'ze'th txã'sa' yafxju uyi'kwe sa' kaapiya'jni'swa wẽse'ji'kwe txã'sna: ");
INSERT INTO pbb_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","uyya' ãjasameewa uyu'tx, legsawa katxhiçxa legmeetx neeyũ', wã'jy wee kazx ji'phsawa katxhinitx neeyũ', wẽse'jya' ãjasameewa wẽse'jya' ãja'tx, uuniisawa ki' ĩtxi yu'tx, sa' naa kiwete pxthaakuẽesa yuutxi' Dxus tasxte pa'jwa'ja's pta'sxnik yuu jĩne'kwe. ");
INSERT INTO pbb_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Aça' adxa's kuh yajkxna jxpubasamée yakh yu' wala yuh weçxa yuja'. ");
INSERT INTO pbb_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Txajũ' txãa pẽysa Jesus tasxu u'the', Jesusa' Juan ma'wẽsatewa pta'sxku kxtee wẽse'jsa nasatxi' na'jĩna: —Nasa u'pnimée kiwete', i'kwe'sxa' ¿kĩhnakwe thegya' u'j? ¿Khĩih tasx wejxate ẽse'sesa's wá'kwe thegya' u'j? ");
INSERT INTO pbb_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Kxte' ¿kĩh ũski sũhçxakwe thegya' u'j? Meeçxa' ¿teeçx piçthẽ'j ropa zhiçxkwesa athçxa u'pna sũhçxa wá'kwe thegya' u'j? I'kwe'sxa' peekx jii i'kwe txã'wẽ ropa zhiçxkwesa athsa' jxkaahsawe'sx yat-suçxáatx u'pu'. ");
INSERT INTO pbb_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Kxte' ¿kimnakwe uy? Dxus yuwe pta'sxsa's wá'kwe uy. Isa txã'sna yuh uyne'kwe, nawa Dxus yuwe pta'sxsa maatewa jxthaakwesa's i'kwe uy. ");
INSERT INTO pbb_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Txã'sna we'weçxak Dxus librute na'jĩ': Adxa' yuwee pta'sxsa kajaçthu iidx yaçte, Iidx pa'jwa'ja's pheu'khan jĩna fxi'jni'. ");
INSERT INTO pbb_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Isath we'we', naa kiwete maa nasa yuhwa Juan Bautistate jxthaakwe walasa yu' kasehnimeeta' ãçxpkaçx. Makwe txã'wẽtewa, ãçxh naa ensuwe'sx maatewa jxthaakwe le'çxkuẽesaçxawa Dxus jxkaahnite u'kasa' Juan Bautistate jxthaakwe walasata'. ");
INSERT INTO pbb_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Juan Bautista pa'jnijũjx Dxus jxkaahni ena' açeni ũsa' ãçxpkaçx, txãa pa'gatx kaaknayu'jya'mée çxhãçxha puiina fxi'ze'. ");
INSERT INTO pbb_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Nawa Dxus jxkaahwa'j ena's Moises ley vxite' Dxus yuwe pta'sxsa txãawe'sxa' txagaçxhíitx pta'sx Juan Bautista pa'phkaçx. ");
INSERT INTO pbb_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","I'kwe'sxa' jiyu wẽeçxa', jxpa'yakx mwẽese'jwe: na'wẽ Dxus yuwe pta'sxsawe'sx we'weçxa', Dxus jxkaahwa'j en ãjaçpkaçxha', Elias pa'jana jĩ'tx txãak yu' Juan Bautista'. ");
INSERT INTO pbb_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Na'wẽ pta'sxya'wath txã'sna wẽse'jwa'jsa ũsçxa', mwẽese'jwe. ");
INSERT INTO pbb_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Naa ensu nasatxi' ¿ma'wẽ kaaja'da'the wejx ewki? Nawa txãawe'sxa' luuçx le'çxkuẽ na'wẽsata': luuçxçxáatx plaasasu pweesa'jya' kaçxçxa', txãawe'sx namikutx na'jĩna sus we'we': ");
INSERT INTO pbb_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Zhiçxkwetha'w kuvxí', nawa ku'ju'çmeei'kwe. Sa' nxus nxustha'w memu', nawa ũ'ne'çmeei'kwe jĩnatx we'we'. ");
INSERT INTO pbb_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Txã'wẽsaçxa i'kwe Juan Bautista's na'wẽ we'we': Eçx ji'phçxak txã'wẽ ũ'we'çmée, sa' vxinowa tudxi'çme' jĩna i'kwe açewe'we'. ");
INSERT INTO pbb_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Txãa e'su Dxus Nçxi'k Nasa Yuusáa pa'jçxa txã'wẽ ũ'na tudxna yuute', na'wẽi'kwe açewe'we': Wala pũ'we', sa' txã'wẽyku wala tudxi'. Pkalsawe'sx vxite' gobierno jĩi vxyu pkhakhsawe'sx yakh namiku' jĩna i'kwe açewe'we'. I'kwe'sxa' jiimeeçxai'kwe txã'jĩ'. Nawa maawa jiyuwa'jsa yuutxi' Dxusa' kaajiyu'juna adx ma'wẽsatewa jĩk. ");
INSERT INTO pbb_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Txajũ' Jesusa' juuna'k we'we maa çxhabsuçxahne' wejx wala txã'wẽ kim yuhwa ãjanimeesa's kaavxya'ja'jna ũsu' kxsũuwe'sx nasatx. Txãa nasa' pkaltxi nvxihtçxa Dxus tasxte sxawedmeene'ta naa pa'ga na'jĩk: ");
INSERT INTO pbb_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","—Korazín çxhabte nasa vxite' Beçaida çxhabte nasa txãawe'sx yakha' wala yuh seena' ũukhũukha'. Txã'wẽ Tiro çxhabte nasa vxite' Sidon çxhabte nasa txãawe'sx ksxavxysu txã'wẽ kim yuhwa ãjanimeesa's kaavxya'ja'jwaça', txãawe'sxa' pkaltxi nvxihtçxa Dxus tasxte sxawedni yã'j yuutxna. ");
INSERT INTO pbb_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Nawa na'jĩ'th na': Dxus kastigãywa'j en ãhte', Tiro çxhabte nasa vxite' Sidon çxhabtewe'sxte jxthaakwe txãawe'sxa' ya'kastigaĩtxna. ");
INSERT INTO pbb_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Aça' Kapernaum çxhabte nasa i'kwe'sx yu' cielute u'kawa'jsa yuhne'tka'w ¿sũju'kwe'? Txã'wẽmée wejx infxiernoteçxáa u'jwa'jsa i'kwe. Txã'wẽ Sodoma çxhabte kim yuhwa ãjanimeesa's kaavxya'ja'jwaça', txãa çxhaba' ãçxpkaçx ũs yuuna. ");
INSERT INTO pbb_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Txãa pa'ga na'jĩ'th na': Dxus kastigãywa'j en ãhte', Sodoma kiwesu nasate jxthaakwe i'kwe'sxa' ya'kastigaĩne'kwe jĩk. ");
INSERT INTO pbb_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Txãa ensu' Jesusa' na'jĩnak Dxus yakh puutx we'we: —Tata, cielute vxite' naa kiwete jxkaahsa idxa' txakwe wala kĩhtewa jxuka jiisawe'sx yuutxi' kaajiyu'jmeeçxawa, pxthaa ãhmeekwesa yuutxi' kaajiyu'jg, txãa pa'gath txakwe wala weçxá' idxa's. ");
INSERT INTO pbb_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Idxa' txã'wẽg yũu, iidx jxthãasni' txã'wẽne' yu' naa pa'ga. ");
INSERT INTO pbb_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Adx Tata' kĩhnawa jxuka adxçxaçxáanak dukh. Nawa Dxus Nçxi'k ma'wẽsatewa kim yuhwa ew yu' jiimeeta', naasáa adx Tata yuuçxáa jiia'. Txã'wẽy kim yuhwa ew yu' jiimeeta' adx Tata's, naasáa Nçxi'k yuuçxáa ew jiia' Neya's. Txãasak maawa jiyu wẽesa yuutxi' Nçxi'ka' kaajiyu'ju' Ney kimtewa. ");
INSERT INTO pbb_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Maawa ũuste wẽtmée wahtxna fxi'zesa' adx tasxte myuhwe jxukaysa, aça' adxa' weçxana thẽymée fxi'zewa'ja's ũsu'nja. ");
INSERT INTO pbb_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Adx jxkaahni's wa'lmée jxpa'gaçxa, adx na'wẽy fxi'zeya' mpiyawe, txãa pa'gatey adxa' juuna'meekwe ũusuh jxuka peeygãhnath jxkaaja'. Txãa pa'ga weçxana thẽymée fxi'zewa'ja's ji'phune'kwe. ");
INSERT INTO pbb_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Adx jxkaahni' walame', sa' nwẽese'jwa'jwa thẽymeesata' jĩk. ");
INSERT INTO pbb_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Txãa ensu' Jesusa' skuutxh ehsuk skhẽuuç yu' sapatu jxkaase ente. Aça' txãa yakh u'jusawe'sxa' wẽeçxa skuutxhtxi çxuktedeçxa ũ'tx. ");
INSERT INTO pbb_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Txã'wẽ yũute', fxariseowe'sx uyçxa' na'wẽtx we'we Jesusa's: —¿Uyu'gá' idx yakh u'jusawe'sxa' na'wẽ yuuçta' mjĩi enmée jxkaase entewa? jĩte', ");
INSERT INTO pbb_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Jesusa' na'wẽk pta'sx: —I'kwe'sxa' ¿iilẽeymeewá'kwe? Teeçx ente' Davxida' txãa yakh u'jusawe'sx yakh wẽeçxa' na'wẽk yũu: ");
INSERT INTO pbb_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Dxuus yatte u'kaçxa', kxtee pantxi ũ'k txãatxi' kim yuhwa ũ'wa'j ji'phmeeta' naasáa sacerdote yuuçxáatx ũ'wa'jsa yu'. ");
INSERT INTO pbb_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","I'kwe'sxa' Moises leytewa ¿iilẽeymeewá'kwe? Kxte pta'sxçxa', dxuus yatte sacerdotewe'sxa' jxkaase'çmeeta' makwe jxkaase entewa jĩ'k. Txã'wẽ jxkaase ente jxkaasemeete', pkalna ¿sũju'çmeekwe'? ");
INSERT INTO pbb_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","I'kwe'sxa' mjiyuwe: Ayte' dxuus yatte jxthaakwe jxtuhthesa ũsa'. ");
INSERT INTO pbb_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","I'kwe'sxa' jiyu'çmeewá'kwe Dxus librute na'jĩ'k: Vxitetx peeygãaniçxá'sthu adxa' jxthãasu', tajkx ikhçxa altalte kabni's peejxmeeth jĩ'k. Txã'jĩni's jiyuwaça', kwe'sxtxi' ũusaçxana açewe'wemeene'kwe, txã'wẽçxáa yũunisa' pkalme' naa pa'ga. ");
INSERT INTO pbb_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Txãa pa'gatey sapatu jxkaase entewa Dxus Nçxi'k Nasa Yuusáa jxkaahwa'j ji'pha' jĩk. ");
INSERT INTO pbb_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Jesusa' txajũ u'jçxa', judiuwe'sx pkhaakheni yattek u'ka. ");
INSERT INTO pbb_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Kxteea' teeçx piçthẽ'j teeçx kuse udxnisa kẽese'jya' ãjasameek u'p yu'. Aça' Jesusa's ewmée vxit wẽeçxa na'wẽtx pẽjx: —Jxkaase entewa nuykatxhite ¿ewmanx? jĩte', ");
INSERT INTO pbb_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Jesusa' na'wẽk pas: —I'kwe'sx teeçx piisxáa ji'phte' txãa piisxá' jxkaase ente ewmeekhẽ khẽete', ¿u'jçxa kutxi'jmeema'kwe jxkaase entewa? ");
INSERT INTO pbb_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Nasa' piisxaate jxthaakwe pa'gasa', aça' wejx txã'wẽ ew yũuwa'ja' makwe jxkaase entewa. ");
INSERT INTO pbb_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Txã'wẽ pasçxa txãa piçthẽ'ja's na'wẽk we'we: —Kuse's mku'le'j jĩte', txã'wẽy yuuk, naapkaçxha' txajx kuse' ewuuk ka'tuwe'sx na'wẽy. ");
INSERT INTO pbb_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Aça' fxariseowe'sxa' kasehçxa Jesusa's ikhya' puutx we'wetx. ");
INSERT INTO pbb_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Txã'wẽ yũuçte Jesus jiyuçxa', txajũ kasehna u'kh, aça' nasa wala u'jtx txãa yakh. Jesusa' ãça'sa ma'wẽsatxwa jxukak nuykatxhi, ");
INSERT INTO pbb_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","nawa kim yuhtxwa pta'sxkaahme' nuykatxhisa kimtewa. ");
INSERT INTO pbb_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Dxus yuwe pta'sxsa Isaias we'weni kxtey yuukahnçxáak txã'wẽ neewe'we. Isaiasa' na'jĩk: ");
INSERT INTO pbb_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Adxna selpiwa'jsa naa piçthẽ'ja'sthu txhitxh. Txãasa peeygãhna weçxana ũsthu, Sa' adx Espiritu's ũsu'nja, Aça' adx ew yũuwa'ja's pta'sxina maa nasatxwa jxuka. ");
INSERT INTO pbb_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Txã' puiiwameena, sa' ãate susnawa fxi'zemeena. Txãa pa'ga txajx we'weni' kĩh yuhwa pthũusemeena klxiikhunsu. ");
INSERT INTO pbb_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Makwe pxthaa ãhmeekwesatewa txã' ahçemeena, Sa' çxhãçxha fxi'zewa'ja's ji'phmeeyã'thewa, txã' ivxiitumeena, Naa kiwete zhiçxkwe txajx jxkaahwa'j en ãhpkaçx. ");
INSERT INTO pbb_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Aça' nasa' ma'wẽsawa jxuka txã'sçxáana ũythasutxna jĩ'k. ");
INSERT INTO pbb_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Txajũ' Jesus tasxte jxũna pa'jtx uyya' ãjasamée we'weya'wa ãjasamée eçx iiyamunisa's. Aça' Jesusa' nuykatxhite', txãa piçthẽ'ja' uyya' ãjak, sa' we'weya'wa ãjak. ");
INSERT INTO pbb_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Txã'wẽ yũute', nasa jxukaysa ũukh yajkxna na'wẽtx kuh jwed we'we': —Naa piçthẽ'ja' Davxid Nçxi'k íina jĩ'tx. ");
INSERT INTO pbb_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Txã'jĩni's fxariseowe'sx wẽse'jçxa', na'jĩtx: —Naa piçthẽ'ja' eçxtxi nasaa ũusuh kutxi'ji'k nawa eçxthẽ'j pu'çxteçxáak txã'wẽ ãja' jĩ'tx. ");
INSERT INTO pbb_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Txã'wẽ yajkxna ũste Jesus jiyuçxa', na'wẽk we'we: —Maa kiwetewa gobierno' peekx nasatxíiçxáa ahçeçxa puiiçxa', çxhãçxhameena. Txã'wẽy çxhab ma'k yuu meeçxa' teeçx yattewe'sx ma'tx yuu nawa puutx yahçena puiiçxa', puutx pçuutxna. ");
INSERT INTO pbb_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Txã'wẽy eçxthẽ'jwa txajx jxkaahnisa eçx yakhíiçxáa puiiçxa', çxhãçxhamée puutx pçuutxna. ");
INSERT INTO pbb_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","I'kwe'sx adxna we'weçxa', eçxthẽ'j pu'çxteçxáak eçxtxi kutxi'ji' jĩna i'kwe we'we'. Aça' txã'wẽ dxihte', txã'wẽ i'kwe'sx yakh u'jusawe'sxwa eçxtxi kutxi'jya' ãja'tx jĩ'i'kwe aça' txã'wẽ ãjawa'ja's ¿kimki'k ũs? Txã'wẽ i'kwe'sx yakh fxi'zesaíiwa ãate kaajiyu'ju'tx i'kwe'sx jxpubani's. ");
INSERT INTO pbb_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Adxa' eçxtxi kutxi'ji'th Dxus Espiritu pu'çxte'. Nawa i'kwe'sxtxi Dxusçxaçxáa jxkaahwa'j en ãhne' txãa pa'ga ne'tka txã'wẽ yũ'. ");
INSERT INTO pbb_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Maawa piçthẽ'j çxhãçxhasa iiyamuni's kusa'jya' u'jçxa', txãa piçthẽ'j çxhãçxhasa khuẽ'yna tudmeeçxa yu', kusa'jya' ãjameena. Txã's khuẽ'yna tudçxa yuuçxáa kusa'jya' ãjana. ");
INSERT INTO pbb_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Adx ju'gu yuusame' açesaçxa txã'wẽ yuutxna. Sa' adxa's pu'çxsame', yupsaaçxa txã'wẽ yuutxna. ");
INSERT INTO pbb_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Na'jĩ'th na', nasa kĩhwa ewmée yũuni kĩhwa Dxusna ewmée nuywe'wetewa txãatxi' jxuka ya'peltunaĩna. Nawa Dxus Espiritu's açewe'wete', bagaçxte yuhwa peltunãywa'jmée yuuna. ");
INSERT INTO pbb_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Sa' maawa Dxus Nçxi'k Nasa Yuusa's ewmée nuywe'wesa's peltunãywa'j yuuna. Nawa Dxus Espiritu's ewmée nuywe'wesa yuuçxáana peltunãywa'jmée yuuna naa kiwete cielutewa. ");
INSERT INTO pbb_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Fxtũu tasx ewsa' ewku yũnu'. Nawa fxtũu tasx ewmeesa' ewmeek yũnu'. Fxtũu tasx ma'wẽsatewa yũnte yuuçxáak ya'jiyu'. ");
INSERT INTO pbb_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Ewmeesa luuçx i'kwe'sxa' ¿ma'wẽ ew we'weya' ãjaki'kwe, ũuste yuu ewmeesa ji'phçxa'? Txãa pa'gatey ũuste yaakxni'sku ya'we'we'. ");
INSERT INTO pbb_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Nasa ewsa' ewsaçxá'sku we'we', txajx ũuste' ewsaçxá's ji'phna naa pa'ga. Naapkaçxha' nasa ewmeesa' ewmeesaçxá'sku we'we', txajx ũuste' ewmeesaçxá's ji'phna naa pa'ga. ");
INSERT INTO pbb_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Adxa' na'jĩ'th na': Dxus kastigãywa'j ente' jxuka pta'sxi ji'phutxna kĩhwa jxuka ewmée we'weni's. ");
INSERT INTO pbb_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Idx ma'wẽ we'weni'swa jxuka paapẽyni yuuna, txajũ yuuwema'g yuu meeçxa' yuuwemeema'g yuu nawa ya'jiyuna. ");
INSERT INTO pbb_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Txajũ' fxariseowe'sx vxite' ley kaapiya'jsawe'sx Jesusa's na'jĩnatx pẽjx: —Txã'wẽ kim yuhwa ãjanimeesa's kwe'sxtxi mkaavxya'ja' jĩte', ");
INSERT INTO pbb_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Jesus pasçxa': —Nasa ewmeesa ĩsxiisawe'sxa' kim yuhwa ãjanimeesa'stxi kaavxya'ja'khaja'. Nawa txã'wẽ yũumée Dxus yuwe pta'sxsa Jonas fxi'zeniçxáana ya'pta'sxina. ");
INSERT INTO pbb_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Jonaswa ma'wẽga wedx tutxhte tekh en tekh kus u'pu', txã'wẽy Dxus Nçxi'k Nasa Yuusaawa tekh en tekh kus kiwe dxiiga ũsuna. ");
INSERT INTO pbb_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Dxus kastigãywa'j en ãhte', Niniwe çxhabtewe'sxa' naa ensuwe'sxtxi' ewmeete nvxiitutxna, txãa pa'gatey Jonas Dxus yuwe's pta'sxiçpkaçxha', Niniwetewe'sxa' pkaltxi nvxihtçxa wa'lmée Dxus tasxte utxaatx. Aça' ayte' Jonas na'wẽsaçxáamée jxthaakwesa ũsa', nawa txãa yu'sa' wa'lu'tx. ");
INSERT INTO pbb_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Txã'wẽy Dxus kastigãywa'j en ãhte', jxu'j kiwete jxkaahsa u'ya' naa ensuwe'sxtxi' ewmeete nvxiituna, txãa pa'gatey txã'wẽ jxu'j kiwejuwa txãa u'ya' yuwe'k Salomon pta'sxniçxá'swa wa'lmée wẽse'jya'. Aça' ayte' Salomonte jxthaakwesa ũsa', nawa txãa yu'sa' wa'lu'tx. ");
INSERT INTO pbb_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Eçxa' nasa ũusuh kasehçxa kiwe uhdxsu pekũhna u'juçxawa u'pwa'j uymeeçxa': ");
INSERT INTO pbb_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Sxawedu'nja kasehth txãa yatnay sũju'k. Txajũ' sxawedna pa'jçxa', txãa piçthẽ'ja's uyuuna yata's ma'wẽ ew pheu'jçxa padçxa txaahni ũs yuukx txã'wẽ. ");
INSERT INTO pbb_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Txajũ' u'jçxa vxite siete eçx txãate jxthaakwe ewmeesatx jxũna pa'jçxa txãa piçthẽ'j ũuste jxuka khẽjetxna, aça' txãa piçthẽ'ja' iiméh jxthaakwe ewmeesa yuuna. Txã'wẽ yuuwa'j en pa'jana naa nasa ewmeesatxi' jĩk. ");
INSERT INTO pbb_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jesus txã'wẽ nasatx we'wena ũsiyna, njĩ'j vxite' nyakhwe'sx txãa yakh we'weya' pa'jçxa ekate ũsu'tx. ");
INSERT INTO pbb_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Aça' kxte ũssa teeçxsa' Jesusa's pta'sxku: —Iidx mama iidx nyakhwe'sx idx yakh puutx we'weya' pa'jçxa ay ekate ũsta' jĩte', ");
INSERT INTO pbb_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Jesusa' na'wẽk we'we pta'sxsa's: —Adx mama adx nyakhwe'sxa' kimtewa jiimeewá'kwe jĩçxa', ");
INSERT INTO pbb_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","txãa yakh u'jusawe'sxtxi kuseju vxijxaçxa: —Naawe'sxçxáa adx mama, adx nyakhwe'sxta'. ");
INSERT INTO pbb_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Txãa pa'gatey maawa adx Tata cielute ũsa' txajx jxthãasni's kxtey yuusaaçxáa txã'wẽ adx nyakh, adx npe'sx, adx mama na'wẽsata' jĩk. ");
INSERT INTO pbb_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Txãa enteyíiçxáa Jesusa' yatuh kasehçxa ĩkhwala pukate ũsya'k u'j. ");
INSERT INTO pbb_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Aça' txajx ũsnite wala nasa pkhaakhete', Jesusa' barkotek khẽe. Aça' nasa yu' ĩkh pukatee neeyũutx. ");
INSERT INTO pbb_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Txajũk wala kaapiya'j ejemplo kaaja'da'jçxa na'jĩna: —Skuutxh uuhsa' ujxa' kasejk. ");
INSERT INTO pbb_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Aça' uhna u'jweçte', msuuíi yu' dxi'jsutx ũsxi skuutxh fxiwa'. Aça' vxiçxakwe pa'jçxa skuutxh fxiwtxi ũ'tx. ");
INSERT INTO pbb_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Vxite ahsu' kwet kajkwesutx ũsxi, kiwe wejkuẽçxáa ji'phsu. Aça' kxsũ ũsxisa' wala dud buçxatx kiwe walameene'ta ya'fxihb txãa pa'ga. ");
INSERT INTO pbb_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Nawa sek açxaate' jxuka uhdxtxi, iiwehçeya' ãjameene'ta naa pa'ga. ");
INSERT INTO pbb_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Vxite skuutxh fxiwa' çhũçh ksxavxysutx ũsxi, aça' çhũçh khuẽ'y walaaçxa', skuutxha's aphçxa ivxiitutx. ");
INSERT INTO pbb_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Nawa vxite ahsu' kiwe wala ewsu ũsxitx, sa' wala yũntxi. Maa tasxíi yu' cien, vxite' sesenta, vxite' treinta nxinx txã'wẽtx çut. ");
INSERT INTO pbb_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Na'wẽ pta'sxni's jiyuwa'jsa ũsçxa', jiyune'kwe jĩk. ");
INSERT INTO pbb_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Txajũ' txãa yakh u'jusawe'sxa' Jesus tasxte utxaaçxa na'wẽtx pẽjx: —¿Kĩjxa'ga ejemplo kaaja'da'jçxaçxáa nasatx pta'sxi'? jĩte', ");
INSERT INTO pbb_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","na'wẽk pas Jesusa': —Dxus jxkaahni ensu ma'wẽ yũuwa'ja'swa kim yuhwa jiyunimeesa's i'kwe'sx yuutxi's kaajiyu'jwa'ja'. Nawa vxite yuutxi's kaajiyu'jwa'jme'. ");
INSERT INTO pbb_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Txãa pa'gatey jiyuwa'jsa's jweeíiçxáa ãate ya'kaajiyu'juna, wala jiyukahn. Nawa jiyuwa'jmeesa's ya'kaajiyu'jmeena, wejxwa le'çxkweçxáawa jiiwáa yuuna txã's yuhnawa kusa'jni yuuna. ");
INSERT INTO pbb_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Txãa pa'gath ejemplo kaaja'da'jçxaçxáa we'we'. Txã'wẽ yuukahníi txãawe'sxa' uyçxawa, uysamée na'wẽ jiyu'çmeeta', sa' wẽse'jçxawa wẽse'jsamée na'wẽ nwẽese'je'çmeeta'. ");
INSERT INTO pbb_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Txãawe'sx fxi'zewa'ja's Dxus yuwe pta'sxsa Isaias we'weni' kxtey yuuk. Txã' na'wẽk we'we: I'kwe'sxa' wẽse'jewá'kwe, nawa jiyumeene'kwe. Uyuwá'kwe, nawa txãana sũhmeene'kwe. ");
INSERT INTO pbb_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Txãa pa'gatey txãa nasa ũusa' jxuka ewmeesaçxáa yuuna pa'jni'. Txãa pa'gatx wẽse'jya' wa'lu', Sa' txãawe'sx yafxju uykahmén, Txãawe'sx thũ'wẽjuwa wẽse'khamen, Yafxa' jxuka aphanita' txãawe'sx ũuste ew jiyukahmén. Txãa pa'gatx adx tasxte pa'ja'çmée adx nuykatxhikahn jĩ'k. ");
INSERT INTO pbb_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Nawa i'kwe'sx yakha' wala yuh weçxa yuja' i'kwe'sx yafxju yuu uyi'kwe, sa' i'kwe'sx thũ'wẽju yuu wẽse'ji'kwe naa pa'ga. ");
INSERT INTO pbb_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Isath we'we', maazkuẽesawa Dxus yuwe pta'sxsa vxite' nasa ewsa nyafxiiwe'sxwa uy wẽetx i'kwe'sx uyna ũsi'kwe txã'sna, nawa uymeeta'. Wẽse'j wẽetx i'kwe'sx wẽse'jna ũsi'kwe txã'sna, nawa wẽse'jmeeta'. ");
INSERT INTO pbb_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Ãçxha' mjiyuwe skuutxh uuhsa's kaaja'da'jçxa pta'sxni's. ");
INSERT INTO pbb_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Naa kiwete Dxus jxkaahwa'ja's pta'sxni's wẽse'jçxawa jiyusame', skuutxh fxiw dxi'jsu ũsxisáa na'wẽsata': Nasa' Dxus yuwe's wẽse'thewa, eçxthẽ'ja' pa'jçxa ũusuh kutxi'jina. ");
INSERT INTO pbb_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Skuutxh fxiw kwet kajkwesu ũsxisa' Dxus yuwe's wala weçxana jxpa'gasa na'wẽsata'. ");
INSERT INTO pbb_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Nawa Dxus yuwe's açxamée çxhãçxha yaakxsa' çxhãçxha'çmeeta'. Txã'wẽ Dxus yuwe's jxpa'gapa'ga, pkxuuwa'j en pa'theçxáa jxuka fxĩykaja'tx. ");
INSERT INTO pbb_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Skuutxh fxiw çhũçh ksxavxysu ũsxisa' Dxus yuwe's wẽse'jçxawa naa kiwetewe'sxçxá's wejx wala yajkxna ji'phunisaçxá's pa'pçxusa na'wẽsata'. Aça' txã'wẽsaçxá's wejx wala yajkxte', txãaçxáa jxuka knayu'k Dxus yuwe yu'sa' kaapeçxkana'jna. ");
INSERT INTO pbb_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Nawa skuutxh fxiw kiwe ewte ũsxisa' Dxus yuwe's wẽse'jçxa kxtey yuusáa na'wẽsata': Skuutxh spiigawa ma'wẽga cien vxite' sesenta vxite' treinta nxinx ji'phu', txã'wẽyku txãawe'sx ũuste Dxus yuwe' wala pena' jĩk. ");
INSERT INTO pbb_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Jesusa' vxite ejemplo na'wẽk kaaja'da'jçxa pta'sx: —Naa kiwete Dxus jxkaahni ente Dxus yuwe ewsaçxá's pta'sxtewa, na'wẽ yuuna: Teeçx mjĩisa' txajx kiwete fxiw ewsa'sku uh. ");
INSERT INTO pbb_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Nawa jxukaysa dejeçpkaçxha', uuthasx namu's açesa pa'jçxa ũ'nimeesa'sku skuutxh ksxavxyte uhçxa u'j. ");
INSERT INTO pbb_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Aça' skuutxh buçxaçpkaçxha', txãa ksxavxyte jxũth tasx ũ'nimeesawa vxyaak. ");
INSERT INTO pbb_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Txã'wẽ yũute', selpisaawe'sxa' na'jĩnatx namu's pta'sxya' u'j: Idxa' fxiw ewsaçxá'sgu uh, aça' naa jxũth tasx ewmeesa' ¿ma'wẽ yũuçxaga buçxa? jĩte', ");
INSERT INTO pbb_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","namu' na'wẽk pas: Maa açesa uhne'ta jĩk. Txajũ' selpisaawe'sxa' pẽjxtxi: ¿Txãa jxũth tasx ewmeesa's khubeya' u'jmtha'w? jĩte', ");
INSERT INTO pbb_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","namu' na'wẽk we'we: Kuçx yuunuwe. Txã'wẽme', petx skuutxh tasx yã'jçxa ya'khubeetxna. ");
INSERT INTO pbb_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Manvxihtwe, peekx walaatxna, skuutxh wakawa'j en ãhpkaçx. Txãa ente adxa' jxkaaja'nja mjĩisatxi', aça' jxũth tasx ewmeesa khuẽ'yna jxuka khubeçxa tudutxna kabwa'j. Txã'wẽ yũuçxa skuutxha's adx yatte jxaawuutxna jĩk. ");
INSERT INTO pbb_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Jesusa' na'wẽk pta'sx vxite ejemplo kaaja'da'jçxa: —Naa kiwete Dxus jxkaajxa' takhni ena' na'wẽsa': Teeçx mjĩisa' mostasa fxiwa's kiwete ujk. ");
INSERT INTO pbb_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Txãa fxiwa' maa maa fxiwtewa thaakwe le'çxkuẽesa'. Nawa buçxayã'jçxa', maa ũ'tasxtewa jxthaakwek walá'. Aça' txã'wẽ seena' walaate', vxiçxakwe yuhwa pa'jçxa ku'tasu yaatu'tx jĩk. ");
INSERT INTO pbb_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Vxite ejemplo kaaja'da'jçxa na'wẽk pta'sx: —Naa kiwete Dxus jxkaahni ena' na'wẽ yũuwa'jsa': Teeçx u'y panu'juççxa', tekh libra skuutxh ũ'wete lewadura's ka'dte ma'wẽ jxuka pẽethejekx txã'wẽ yũuwa'jsa' jĩk. ");
INSERT INTO pbb_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Jesusa' ejemplo kaaja'da'jçxa yuuçxáak pta'sxi' nasa jxukaysatx. Ejemplo kaaja'da'jmée yu', pta'sxi'çme'. ");
INSERT INTO pbb_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Txã'wẽ yũuwa'ja's Dxus yuwe pta'sxsa na'jĩna fxi'kh txãak kxtey yuu. Na'wẽk fxi'j: Kim yuhtxwa kaajiyu'jnimeesa ũsyã'jtx yu' naa kiwe's vxitiyna txã'sna pta'sxi'nja ejemplo kaaja'da'jçxa yuuçxáa jĩnak fxi'j. ");
INSERT INTO pbb_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Txajũ' Jesusa' nasa tasxuh txuteeçxa yattek u'ka, aça' txãa yakh u'jusawe'sxa' utxaaçxa na'wẽtx pẽjx: —Jxũth tasx ewmeesa's kaaja'da'jna we'weni's ãate mkaajiyu'j jĩte', ");
INSERT INTO pbb_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Jesusa' pta'sxku: —Fxiw ewsana uuhsa' Dxus Nçxi'k Nasa Yuusá'. ");
INSERT INTO pbb_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Aça' uuthasx jĩnisa' naa kiwe'. Fxiw ewsa jĩna we'we'th txãa yu' nasa Dxus jxkaahnite ũswa'jsatxthu txã'jĩ'. Sa' eçxthẽ'j nasa yuutxi' jxũth tasx ewmeesa jĩ'th. ");
INSERT INTO pbb_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Aça' jxũth tasx ewmeesa's uuhsa yu', eçxthẽ'jíiçxá'. Skuutxh wakawa'j en jĩ'th txãa yu' naa kiwe pçuwa'ja'sthu txã'jĩ'. Aça' ũ'a's pkhakhsa', Dxus angeleswe'sxta'. ");
INSERT INTO pbb_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Jxũth tasx ewmeesa's ma'wẽta pkhakhçxa ipxte abu' çxhavxykahn, txã'wẽy yũuni yuuna naa kiwe pçuute'. ");
INSERT INTO pbb_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Dxus Nçxi'k Nasa Yuusá' angeleswe'sxtxi kajana txã'wẽ ewmée yũuna vxitetx pkalte kweete'jna ũssawe'sxtxi txajx jxkaahna ũsnijũ kutxi'jçxa ");
INSERT INTO pbb_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","ipx walate akhkahn. Kxteea' seena' yuh pebeetxna ki'thtxi ksuusu'jna. ");
INSERT INTO pbb_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Naapkaçxha' Dxus jxthãasni's kxtey yuusa' sek na'wẽ eena' kweethetxna Tata cielute jxkaahna ũsnite. I'kwe'sxa' jiyuwa'jsa ũsçxa', jiyune'kwe. ");
INSERT INTO pbb_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Naa kiwete Dxus jxkaahna ũsni ena' iiméh seena' pa'gasa's kiwe dxiite sũthçxa txaahni na'wẽsa': Teeçx piçthẽ'jwa ma'wẽ txã'wẽ pa'gasa's uyçxa', ãçxhíi yu' jxũna u'jya' ãjameeçxa kxteyçxáa wejx ew sũthçxa txajakx, sa' wala weçxana u'jçxa txajx ji'phuni's jxuka txweyçxa txãa vxyuju kiwe's weyuukx mteene' ewsa's sũthçxa txah txãa kiwe's txã'wẽysa'. ");
INSERT INTO pbb_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Naa kiwete Dxus jxkaahna ũsni ena' na'wẽsa': Perla zhiçxkwesa's weysaawa ma'wẽ pakweçxa ");
INSERT INTO pbb_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","teeçx perla iiméh pa'gasa's uyçxa', txajx ji'phuni's jxuka txweyçxa txãa vxyuju perla's weyuukx txã'wẽysa'. ");
INSERT INTO pbb_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Naa kiwete Dxus jxkaahna ũsni ente' na'wẽ yũuwa'ja': Wedx ukhe'swa ma'wẽ ĩkhwalakhẽ akhte', wedx ma'wẽsatxwa jxuka pkhakhekx. ");
INSERT INTO pbb_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Aça' wedx uwesá' ukhe's tuhmete kutxi'jçxa wedxtxi txhitxhya' kaçxçxa ewsa's kanastate ãsxçxa', ewmeesatxi' ĩkhwalakhẽ ãsxitxki ");
INSERT INTO pbb_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","txã'wẽy yuutxna Dxus angeleswe'sxa' naa kiwe pçuwa'j en ãhte'. Sa' txãawe'sxa' ewmeesatxi' ewsa ksxavxyuh txhitxhçxa ipx walate akhetxna. ");
INSERT INTO pbb_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Kxteea' seena' yuh pebeetxna ki'thtxi ksuusu'jna. ");
INSERT INTO pbb_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Txã'wẽ kaapiya'jni's Jesusa' na'jĩnak pẽjx: —¿I'kwe'sxa' jxuka jiyukwe' na'wẽ pta'sxni's? jĩte', txãawe'sxa': —Jiyuíitha'w jĩnatx pas. ");
INSERT INTO pbb_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Aça' Jesusa' na'wẽk we'we: —Dxus jxkaahwa'j ena's jiyusa' ley kaapiya'jsawa ma'wẽ nyafxíi kaapiya'jni's piyaçxa kaapiya'jni u'sesa'swa jxpa'gaçxa wala jiisa yuukx txã'wẽy e'z jwed jiisa yuutxna jĩk. ");
INSERT INTO pbb_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Naa ejemplotx Jesusa' pta'sxna jxã'jçxa', txajũ u'kh txajx kiwen. ");
INSERT INTO pbb_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Kxteea' judiuwe'sx pkhaakhenitek kaapiya'jna ũsu'. Aça' nasa' kuh yajkxna na'jĩ'tx: —Naa piçthẽ'ja' ¿mteeki'k txakwe wala piya txã'wẽ ãjaya'? ¿Ma'wẽ yũuçxaga txã'wẽ kim yuhwa ãjanimeesa's kaavxya'ja'ja'? ");
INSERT INTO pbb_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Naaíi ¿karpintero nçxi'k meená', aça' njĩ'ja' Maria meená'? Aça' txajx nyakhwe'sxa' Jakobo, Jose, Simon, vxite' Judas txãawe'sxta', ");
INSERT INTO pbb_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","aça' txajx npe'sxwe'sxwa ayte kwe'sx yakh ũsta'. ¿Majũki'k piya na'wẽ kĩhnawa jxuka ãjawa'ja's? ");
INSERT INTO pbb_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Txã'wẽ jiitx yu', txãa pa'gatx Jesus we'weni's kxtey yuumée. Nawa Jesusa' na'wẽk we'we: —Dxus yuwe pta'sxsa' peekx kiwesu vxite' peekx yattewe'sx weeçxni yuuçxáa fxi'zetxna maawa jĩçxa', ");
INSERT INTO pbb_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","kim yuhwa ãjanimeesa's jwee yu' kaavxya'ja'jme', txãawe'sxa' txajx we'weni's kxtey nwẽese'jmeeta' naa pa'ga. ");
INSERT INTO pbb_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Txãa ensu' Herodesa' Galilea kiwetek ne'jwe'sx yu', sa' Jesus kĩjkĩhwa ew yũuni's jiyuçxa', ");
INSERT INTO pbb_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","txãa yakh ũssawe'sxtxi na'wẽk we'we: —Txãa piçthẽ'ja' Juan Bautistane' ki' ĩtxi yuu. Txãasane' txã'wẽ kim yuhwa ãjanimeesa'swa kaavxya'ja'jya' ãja' jĩk. ");
INSERT INTO pbb_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Herodesa' Juan Bautista's na'wẽ yũuçxaga ikh: Juana's tudçxa karcelte ktxaaja'kha, nawa Herodes nyakh Fxelipe nyu Herodias pa'gaçxáane' txã'wẽ karcelte ktxaaja'j. ");
INSERT INTO pbb_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Txãa ensu' Juan Bautista' Herodesa's we'weçxa': —Iidx yakhthẽ'j nyua's kusa'jçxa iidx nyu na'wẽ jxpe'jwa'j ji'phmeeg jĩte', ");
INSERT INTO pbb_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Herodesa' Juana's ikhe'nja sũhne'. Nawa nasa jxukaysa Juan ju'guçxaçxáane'ta ũsu', Juana' Dxus yuwe pta'sxsapa'ga. Txãa pa'gane' ũukhçxa ikhmée karcelteçxáa txah. ");
INSERT INTO pbb_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Nawa teeçx ente' Herodesa' txajx upxni en anxu ãhte fxiesta vxitte', Herodias niisa' nasa pi'kxnisa dxi'pte wala zhiçxkwe ku'jya' kasehne'. Txãa pa'ga Herodesa' iiméh wala weçxaçxa, ");
INSERT INTO pbb_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","kĩh pẽjxtewa jxuka ũsu'nja jĩnane' puutx we'we txãa kna'sa's. ");
INSERT INTO pbb_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Txajũ' njĩ'j yu'kxpehte', txãa kna'sa' na'wẽga pẽjx Herodesa's: —Juan Bautista dxikthea's plaatute akhçxa ũsune'ga jĩte', ");
INSERT INTO pbb_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","ne'jwe'sx Herodesa' wala nxusçxawa, txã'wẽ yã'jne' kĩh pẽjxtewa ũsya' puutx we'we nasa pi'kxnisa dxi'pte, txãa pa'ga kxtey yũuya' neeyũuyã'jçxa', ");
INSERT INTO pbb_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Juan dxikthea's spẽ'thkaahne' karcelte. ");
INSERT INTO pbb_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Aça' dxikthea's plaatute akhçxa ũste', txãa kna'sa yu' njĩ'ja'sne' dukh. ");
INSERT INTO pbb_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Txã'wẽ yũute', Juan Bautista yakh pi'kxna u'jusawe'sxa' pa'jçxa uuníi kakwe's jxũna u'jçxa pedaane'ta. Sa' u'jçxa Jesusa's pta'sxne'ta. ");
INSERT INTO pbb_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Txã'wẽ Herodesa' Juan Bautista's ikhku jĩni's Jesusa' jiyuçxa', barkote khẽeçxa u'kh teeçx ahte kim yuhwa u'pnimeesate pa'jya'. Nawa Jesus mtee pa'jya' u'thewa jiyuçxa nasa' çxhabu kasehçxa Jesus pa'jwa'the pakwena u'jtx çxidaçxáa. ");
INSERT INTO pbb_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Aça' Jesusa' barkoju kasejeççxa' uyku nasa wala kuh ũste, sa' txãawe'sxtxi peeygãhçxa nuykatxhik ãça'satx pe'jçxa nuypa'jnisatxi'. ");
INSERT INTO pbb_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Txajũ' kusna kĩjaçte', txãa yakh u'jusawe'sxa' Jesus tasxte utxaaçxa na'wẽtx we'we: —Kusuçyã'ja', naapkaçxha' aysu' kim yuhwa u'pnimeesa'. Aça' nasatxi' mkaah çxhabsu pa'jçxa kĩhçxáawa weyçxa ũ'kahn jĩte', ");
INSERT INTO pbb_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Jesusa' na'wẽk pas: —Txãawe'sxa' ũ' weyya' u'jwa'j peejxmeena. I'kwe'sx mpuuçwe jĩte', ");
INSERT INTO pbb_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","na'wẽtx pas: —Kwe'sxa' kĩhwa wala yu' ji'phmeetha'w. Tahç pan e'z wedxçxáa ji'phtha'w jĩte', ");
INSERT INTO pbb_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Jesusa': —Txãatxi' mneejxũhwe jĩnak jxkaah. ");
INSERT INTO pbb_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Txajũ' nasatx kaçxkaakh txaksũ. Sa' tahç pan e'z wedxtxi jxpa'gaçxa, cielute pagayçxa Dxusa's weçxaçxa pantxi pe'ltedek. Txã'wẽ yũuçxak txãa yakh u'jusawe'sxtxi ũs, aça' txãawe'sxa' ũsu'stxi nasatx. ");
INSERT INTO pbb_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Aça' jxukaysa ũ'çxa txikte', doce kanastate utatx kijxasaatx pkhakh. ");
INSERT INTO pbb_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Ũ'sawe'sxa' cinko mil piçthẽ'jtx yu', u'ywe'sx vxite' luuçxwe'sxtxi yu'. ");
INSERT INTO pbb_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Txajũ' Jesusa' txãa yakh u'jusawe'sxtxi barkote yaçte kaakh, sa' txãa yu' kxtee neeyũuk nasa txuteena u'jsatx weçxana. ");
INSERT INTO pbb_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Txajũ' nasa jxuka txuteena u'the', thã'j vxiçna u'kh txãaçxáa Dxus yakh puutx we'weya'. Jxuka çxhi'dxni yã'thewa, Jesusa' kxtee nee ũsíiçxáak yu'. ");
INSERT INTO pbb_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Naapkaçxha' barko' ĩkh pxãjũy u'jweçku yu'. Aça' wejxaa wala kiiteçxa, dxi'puh sẽhçxa barko's yupku. ");
INSERT INTO pbb_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Aça' khikhyna sẽjxa'wate', Jesusa' utxaana kũjk ĩkh kajkwega çxidaçxáa. ");
INSERT INTO pbb_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Aça' ĩkh kajkwega txã'wẽ yuhte uyçxa', barkote u'jsawe'sxa' ũukhna na'jĩnatx sus we'we: —Eçxa'stha'w uy jĩte', ");
INSERT INTO pbb_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Jesusa' na'wẽk we'we: —Ũukhnuwe, adxthu jĩte', ");
INSERT INTO pbb_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Pedro we'weçxa' na'jĩk: —Adxthu jĩ'g na' txãa dxihçxa', adxwa txã'wẽy ĩkh kajkwesu çxidaçxáa yujxa' ãjakahn mkaah jĩte', ");
INSERT INTO pbb_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Jesusa': —Txã'wẽçxa' myuh jĩnak we'we. Aça' Pedro' barkojũ sa'jçxa, Jesus tasxte pa'j u'jya' u'jweçku yu' ĩkh kajkwesu. ");
INSERT INTO pbb_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Nawa wejxa seena' çxhãçxha ũste', ũukhku. Sa' txã'wẽ ũukhpa'gaçxáa ĩkh dxiikhẽ khẽjeççxa', susku we'we: —Meen nwe'we jĩçpkaçxha', ");
INSERT INTO pbb_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Jesusa' pu'kisçxa na'jĩk: —¿Kĩjxa'ga Dxusa's yu' yajkxmée, ũukhwa'jçxá's yajkx? jĩçxa', ");
INSERT INTO pbb_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Jesusa' barkote Pedro yakh khẽjeçpkaçxha', wejxaa wala' jxuka yujuk. ");
INSERT INTO pbb_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Aça' barkote ũssa' Jesus tasxte peejxũkweçxa na'wẽtx we'we: —Isa, idxa' Dxus Nçxi'k yuh yu'ga jĩtx. ");
INSERT INTO pbb_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ĩkhuy ktejkaçxa', Genesaret kiwete pa'jtx. ");
INSERT INTO pbb_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Aça' kxsũ nasa' Jesus pa'jni's jiyuçxa txãa kiwesu nasatx jxuka pta'sxte', nasa' ãça'satx jxuka Jesus tasxte nuypa'jtx, ");
INSERT INTO pbb_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","na'jĩna pxthaa we'wena: —Iidx atxh vxiçteçxáawa makhya'dxi'j jĩçxa, txã'wẽ jxa'dxsa' jxuka katxhiçxatx neeyũ'. ");
INSERT INTO pbb_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Fxariseowe'sx vxite' ley kaapiya'jsa txãawe'sxa' Jerusalen çxhabu pa'jçxa', maaíi yu' na'jĩnatx Jesus tasxte utxáa: ");
INSERT INTO pbb_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","—Idx yakh u'jusawe'sxa' ¿kĩh yũuçxata yaçgawe'sx kaapiya'jnitxi' kxtey yu'çmée, txã'wẽ kusekhẽ yu' kaahmée ũ'wé'? ");
INSERT INTO pbb_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Txã'jĩte', Jesuswa pẽjxku na'jĩna: —I'kwe'sxwa ¿kĩh yũuçxakwe i'kwe'sx yaçgawe'sx kaapiya'jniçxá's nwẽese'jçxa' Dxus jxkaahni yu'sa' kxtey yu'çmée? ");
INSERT INTO pbb_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Dxusa' na'wẽk jxkaaja': Iidx tata iidx mama txãawe'sxtxi' peeygãhna pu'çxwa'ja'. Aça' txã'wẽ yũumée neywe'sxtxi açewe'wesa' uu ena's ji'phuna jĩ'k. ");
INSERT INTO pbb_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Nawa i'kwe'sxa' yaçga kaapiya'jniçxá's nwẽese'jçxa Dxus jxkaahni yu'sa' kxtey yuumée ũsi'kwe. ");
INSERT INTO pbb_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","I'kwe'sx yaçgawe'sxa' na'wẽtx kaapiya'ja': Maa nasawa neywe'sxtxi peeygãhna pu'çxmée, adx ji'phuni i'kwe'sxtxi pu'çxwa'ja's Dxusna dukhe'nja jĩna we'weçxaçxáa, neywe'sxtxi' pu'çxmeetewa ewa' jĩ'tx. ");
INSERT INTO pbb_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Yuwejuçxáa ew we'weçxa', ũuste yu' ewmeeçxáa yaakxsai'kwe, aça' Dxus yuwe pta'sxsa Isaiasa' isa yuh Dxus we'weni's na'jĩna fxi'jne': ");
INSERT INTO pbb_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Naa nasa' yuweju yu' adxa's yaaki'tha'w jĩçxawa, ũusuh yu' adxa's yaaki'çmeeta'. ");
INSERT INTO pbb_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Naa kiwete nasaa kaapiya'jniçxá's kxtey yuuna ũsçxa, txã'wẽ Dxus jxkaahni'stha'w kxtey yu' jĩte', kxul yuhna jĩ'k. ");
INSERT INTO pbb_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Txajũ' nasatx pa'yaçxa na'wẽk we'we Jesusa': —Jiyuya' mwẽese'jwe. ");
INSERT INTO pbb_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Kĩh ũ'wa tutxhteçxáa khẽesa yu', nasatx ewmeesa vxitu'çme', naasáa ũusuh ewmée yaakxnisa yuuçxáak nasatx ewmeesa vxitu'. ");
INSERT INTO pbb_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Txajũ' Jesus yakh u'jusawe'sxa' utxaaçxa na'wẽtx we'we: —Idx txã'wẽ we'wete', fxariseowe'sxa' ũusaçxanatx neeyũu jĩte', ");
INSERT INTO pbb_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Jesus pasçxa': —Kĩh tasxwa adx Tata cielute ũssa uuhnisamée yu'sa' khubeni yuuwa'ja'. ");
INSERT INTO pbb_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Aça' ũukhnuwe. Txãawe'sxa' yafx ji'phmeesa, yafx ji'phmeesa nwe'sxtxi pe'jna u'jusaçxáata'. Txã'wẽ yafx ji'phmeesa yafx ji'phmeesa nwe'sxtxi pe'jna u'juçxa', e'zíi kafxkhẽ khẽjetxna. ");
INSERT INTO pbb_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Txã'jĩte', Pedro' Jesusa's na'jĩnak pẽjx: —Ejemplo kaaja'da'jçxa we'weni's ãate mpeeta'sx jĩte', ");
INSERT INTO pbb_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Jesusa' na'jĩnak we'we: —¿I'kwe'sxwa jiyu'çmeewá'kwe? ");
INSERT INTO pbb_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Kĩh ũ'wa tutxhkhẽçxáak u'jwe', sa' txajũ ki' kaseje'k. ");
INSERT INTO pbb_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Nawa ũusuh yaakxnisa yuuçxáak nasa's ewmeesa vxitu'. ");
INSERT INTO pbb_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Txãa pa'gatey ũusujk kaseje' ewmée yaakxnisa, nasatx ikh wẽenisa, ptamçxawa vxitesa yakh fxi'zeni, ma'wẽsa yakhwa pkal yuuna fxi'zeni, pesweeni, ĩsxiina ewmée nuywe'weni, Dxusna açewe'weni. ");
INSERT INTO pbb_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Txã'wẽ yaakxnisatx nasa's ewmeesa vxitu'. Nawa kusekhẽ yu' kaahmée ũ'nisaçxáa yu', nasatx ewmée vxitu'çme'. ");
INSERT INTO pbb_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Jesusa' txajũ kasehçxa u'kh Tiro vxite' Sidon kiwen. ");
INSERT INTO pbb_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Aça' teeçx u'y Kanaanuwe'sx txãa kiwete pa'jçxa u'psa' Jesus tasxte pa'kh pxthaa we'wena: —Davxid ji'j, ũ'kwe's meen peeygãh. Ũ'kwe niisa's eçx iiyamute', iiméh wala pxthaa yuuna ũsa' jĩtewa, ");
INSERT INTO pbb_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Jesusa' ma'wẽçxáa yuhwa pasme'. Aça' Jesus yakh u'jusawe'sxa' Jesusa's we'wetx na'jĩna: —Kwe'sx e'ste kuçx susna yuukahmen yatna mkaah jĩte', ");
INSERT INTO pbb_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Jesusa' na'jĩnak pas: —Piisxakuẽ na'wẽ vxituna ũssa Israelwe'sxçxáatxku pakweya' kaah Dxusa' jĩtewa, ");
INSERT INTO pbb_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","txãa u'ya' sxuuna' yuumée utxaana kũhçxa txajx tasxte peejxũkwek: —Ũ'kwe's meen pu'çx jĩna. ");
INSERT INTO pbb_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Aça' Jesusa' na'jĩnak we'we: —Luuçx ũ'wa'ja's kusa'jçxa alkutx ũswa'jme' ");
INSERT INTO pbb_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","jĩtewa, txãa u'y pasçxa': —Isa yuh we'we'g. Nawa alku' pejka ũ'we'tx mesa tasxsu pan pe'la ũsxisaçxáatxwa jĩte', ");
INSERT INTO pbb_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Jesus we'weçxa': —Dxusa' pu'çxyujuna sũhwa'j yuuçxá's i'kwe yaaki', txãa pa'ga i'kwe pẽyni' kxtey yuuna jĩçpkaçxha', txãa dudtey txãa u'y niisa' katxhinik neeyũu. ");
INSERT INTO pbb_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Jesusa' txajũ kasehçxa Galilea ĩkh pukasuk u'j. Sa' thã'j vxiçtek tejka. ");
INSERT INTO pbb_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Aça' nasa wala pa'jtx txajx tasxte ãça'satx pe'jçxa, legsa, uyya' ãjasamée, we'weya' ãjasamée, ẽseya' ãjasameetx. Aça' txã'wẽ wala kuh ãça'satx Jesus tasxte nuypa'the', txã' nuykatxhik. ");
INSERT INTO pbb_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Txã'wẽ we'weya' ãjasameewa we'weya' ãjatx, aça' ẽseya' ãjasameewa katxhitx, aça' legsawa ew u'jya' ãjatx, naapkaçxha' uyya' ãjasameewa uyya' ãjatx. Aça' nasa' wala kuh yajkxna Israelwe'sx Dxusa's wala weçxatx. ");
INSERT INTO pbb_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Txajũ' Jesusa' txãa yakh u'jusawe'sxtxi pa'yaçxa na'wẽk we'we: —Naa nasa' ayte adx yakh tekh en yã'j ũsta', sa' kĩh yuhwa ũ'wa'j ji'phmeeta', txãa pa'gath peeygãja', sa' puuçmée yu' kaahme'nja. Txã'wẽme' dxi'the u'jya' çxhãçxhameetxna jĩte', ");
INSERT INTO pbb_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","na'wẽtx pas: —Nawa ¿kĩhte txakwe wala ũ' uyuukxtha'w nasa txãazkuẽesa ũ'wa'j? Ayte' kim yuhwa u'p kiweme' aça' jĩte', ");
INSERT INTO pbb_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Jesusa' pẽjxku: —I'kwe'sxa' ¿maz pan ji'phkwe? jĩte', txãawe'sx pasçxa': —Siete pan, wedx kuhmeekuẽçxáa ji'ptha'w jĩnatx pas. ");
INSERT INTO pbb_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Aça' nasatxi' kiwesu kaçxkaahçxa', ");
INSERT INTO pbb_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","siete pan vxite' wedxtxi jxpa'gana'wa Dxusa's weçxak. Txã'wẽ yũuçxak pe'ltedeçxa txãa yakh u'jusawe'sxtxi ũs, aça' txãawe'sxa' nasatx ũsu'stxi. ");
INSERT INTO pbb_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Jxukaysa ũ'çxa txikte', kijxaasa's pkhakhtxi, aça' siete kanastate utak neeyũu. ");
INSERT INTO pbb_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Ũ'sawe'sxa' kuatro mil ãhtx yu', nawa u'y vxite' luuçx txãawe'sx yuutxi' isaniméek kxaz yu'. ");
INSERT INTO pbb_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Txã'wẽ yũuçxa Jesusa' nasatx kaahçxa', txãa yu' barkote khẽeçxa Magdala kiwenku u'j. ");
INSERT INTO pbb_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Fxariseowe'sx vxite' saduceowe'sxwa pa'jçxa', Jesus ewmée yũutewa kpajkxya' sũhçxa pẽjxtxi: —Cieluju kĩhçxáawa mkaavxya'ja'j jĩna. ");
INSERT INTO pbb_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Nawa Jesus pasçxa' na'jĩk: —Kusna sek khẽjeçte', kuskusa' sekuuna, ew kusuça' jĩ'i'kwe. ");
INSERT INTO pbb_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Sa' kusíi we'weçxa', ãçxha' en ewmée yuuna, tãaphçxáa ũsa' jĩ'i'kwe. Yuwejuçxáa ew we'weçxa', ũuste yu' ewmeeçxáa yaakxsa, en ma'wẽ yũuwa'ja'swa jiyu'i'kwe i'kwe'sxa'. Nawa naa ensu na'wẽ seena'sa vxyaaça' txãa yu'sa' jiyuya' ãja'çmeei'kwe kĩh yũuya' txã'wẽ yũuçtewa. ");
INSERT INTO pbb_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Naa nasa ewmeesa' cieluju seena'sa's kaavxya'ja'j jxthãasu'tx. Nawa peena yu' kaavxya'ja'jmeete ewna, naasáa Jonasa' ma'wẽga yuu txã'sçxáana ya'pta'sxina jĩna we'weçxaçxáa nvxihtçxa u'kh. ");
INSERT INTO pbb_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Jesus yakh u'jusawe'sxa' ĩkhwala kuten u'jweççxawa, peçxkanaçxa pan yu' jxũmeeta u'j. ");
INSERT INTO pbb_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Kxtee pa'jçxa', Jesusa' na'wẽk we'we: —Mpa'yajkxwe, fxariseo vxite' saduceowe'sx lewadura ewmeesa's jĩte', ");
INSERT INTO pbb_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","txãawe'sxa' na'wẽtx puutx paapẽyi': —Pan jxũmeetha'w aça' kxahne' txã'wẽ we'we' jĩ'tx. ");
INSERT INTO pbb_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Txã'wẽ we'weni's Jesus jiyuçxa' na'jĩk: —¿Maa sũhçxakwe pan ji'phmeetha'w jĩna we'wé'? Pan ji'phmeetewa, Dxusa' thẽymée sã'jĩna sũhwa'j yu'sa' ji'phmeewá'kwe. ");
INSERT INTO pbb_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Adxa' na'wẽ tahç pan yakhçxáa cinko mil nasatx thẽyméeth sã'jĩ aça' kijxaasa's maz kanasta pkhakhçxawa txã'sa' yaakiçmeewá'kwe. ");
INSERT INTO pbb_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Vxite ente' txã'wẽy siete pan yakhçxáa kuatro mil nasatx thẽymeeth sã'jĩ aça' kijxaasa's maz kanasta pkhakhçxawa yaakiçmeewá'kwe. ");
INSERT INTO pbb_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","I'kwe'sxa' jiyumeewá'kwe adxa' pana's we'weçxa txã'wẽ mpa'yajkxwe fxariseo vxite' saduceowe'sx lewadura ewmeesa's jĩ'çmeeth. ");
INSERT INTO pbb_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Txajũ' jiyutx Jesusa' txã'wẽ pante ka'dnisa lewadura's we'wemée, fxariseo vxite' saduceowe'sx kaapiya'jni's we'weçxa txã'jĩni's. ");
INSERT INTO pbb_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Jxkaahsa Fxilipo vxitni çxhab Cesarea ja'dasu pa'jçxa', Jesusa' na'jĩnak pẽjx txãa yakh u'jusawe'sxtxi: —Dxus Nçxi'k Nasa Yuusa's ¿kimna jĩnata we'we' nasa'? jĩte', ");
INSERT INTO pbb_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","na'wẽtx pta'sx: —Maaíi yu' Juan Bautistana jĩ'tx. Vxite we'wesa' Eliasna jĩ'tx. Aça' vxite we'wesa' Jeremiasna meeçxa' vxite kasehne' Dxus yuwe pta'sxsa jĩ'tx jĩna pta'sxte', ");
INSERT INTO pbb_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Jesus pẽjxçxa': —I'kwe'sxa' ¿kimna jĩ'kwe? jĩte', ");
INSERT INTO pbb_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simon Pedro' na'wẽk pas: —Idxa' Dxus ĩtxisa Nçxi'kgu, txajx tasxu yuusa jĩte', ");
INSERT INTO pbb_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Jesusa' pasku na'jĩna: —Jonas nçxi'k Simon, idx yakha' wala weçxa yuja'. Idxa's naa kiwete piçthẽ'j kaajiyu'jmeeta'. Adx Tata cielute ũssa yuuk kaajiyu'j adxa' Dxus ĩtxisa Nçxi'ktewa. ");
INSERT INTO pbb_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Idxa' Pedro yaaseg aça' idxwa ma'wẽga adxa's ew jiyu txã'wẽy maawa ew jiyuwa'ja's idx yakh nvxiitu'nja. Aça' txã'wẽ ew jiyunijũ' eçxthẽ'j yuhwa knaymeena Dxus luuçxtxi'. ");
INSERT INTO pbb_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Dxus jxkaahna ũsnite pa'jwa'j dxi'ja's phadewa'ja's idxa's ũsu'nja, aça' idxa' maatxwa we'weçxa': Pkaltxi' Dxusa' peltunaĩna jĩte', peltunãyni yũutxna. Nawa peltunaĩmeena jĩte', peltunãynimée neeyũutxna jĩk. ");
INSERT INTO pbb_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Txajũ' Pedrowe'sxtxi neewe'wek, Jesusa' Dxus tasxu yuusa yuh yu'ga jĩna maa yuhtxwa pta'sxkahmén. ");
INSERT INTO pbb_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Txãa entek Jesusa' nyafxçxah pta'sx txãa yakh u'jusawe'sxtxi na'jĩna: —Jerusalenna u'jwa'j ji'pthu. Kxteea' wala pkxuuni yu'nja judiu nthẽ'jsawe'sx vxite' sacerdote npiiçthẽ'jwe'sx vxite' Dxus leya's kaapiya'jsa txãawe'sx kusete. Txãawe'sxa' ikhetxna, nawa tekh ente' ki' ĩtxi yu'nja jĩna pta'sxte', ");
INSERT INTO pbb_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Pedro' Jesusa's fxiite pe'jna u'jçxa na'wẽk yu'kxpeh: —Idxa's txã'wẽ yũuwa'j yu'sa' Dxusa' jxthãasmeewaça', ewna jĩte', ");
INSERT INTO pbb_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Jesusa' yu'thegçxa na'wẽk we'we Pedro's: —Eçxthẽ'j, adx tasxuh mtxutée. Idxa' suw wẽenaçxáa ũsgu. Dxus jxthãasni yu'sa' kxtey yuumée, naa kiwega nasaa yaakxniçxá'sgu kxtey yuu wẽje'. ");
INSERT INTO pbb_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Txajũ' Jesusa' txãa yakh u'jusawe'sxtxi ki' we'wek: —Maawa adx yakh yuu wẽeçxa', peekx kakwe jxthãasni's kĩhnawa jxuka nvxihtçxa yuuçxáa adx yakh yujxa' ãjane'kwe, makwe pxthaa yuuwa'j seena'sa ma'k yuu nawa txã'sa' ũukhmée. ");
INSERT INTO pbb_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Txã'wẽme', naa kiwete peekx ĩtxi fxi'zewa'jçxá's ya'nwe'wesa', Dxus yakh fxi'zewa'j yu'sa' ivxiituna. Nawa adx yakh fxi'zepa'gaçxáa naa kiwete ĩtxi fxi'zeni's yajkxmée ivxiitusa', Dxus yakh fxi'zewa'j yu'sa' ivxiitumeena. ");
INSERT INTO pbb_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Makwe naa kiwetewe'sx yu'sa' jxuka knayçxawa peekx ũus yu's ivxiitute', ¿kĩhteçxá' selpiima'k? Peekx ũusa's ivxiituyã'the', ¿kimçxa' nwe'wema'k? ");
INSERT INTO pbb_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Jxpa'yakxmeete', Dxus Nçxi'k Nasa Yuusa' ki' kĩijana Ney eena' kweethni pxãhte txajx angeleswe'sx yakh, aça' ma'wẽçxah yũusaaçxawa teeçxsa na'wẽçxah jxpa'gatxna. ");
INSERT INTO pbb_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Isath we'we', ayte ũssa maaíi yu' nee uumey uyuune'kwe txã'wẽ Dxus Nçxi'k Nasa Yuusa' jxkaajxa' pa'jni's jĩnak pta'sx. ");
INSERT INTO pbb_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Seis en skhẽwniite', Jesusa' pe'jna u'kh Pedro vxite' pxakhsa Jakobo Juan txãawe'sxtxi teeçx vxiç walate. ");
INSERT INTO pbb_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Sa' kxtee pa'jçxa', txãawe'sx dxi'pte Jesusa' wala zhiçxkwe yu'pthehçxak vxyaa. Txajx dxi'pa' sek na'wẽk eena' khi'khi', aça' txajx athni ropa' seena' zhiçxkwe çxihme yuuk. ");
INSERT INTO pbb_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Naapkaçxha' Moises vxite' Elias txãawe'sxa' Jesus yakh puutx we'wenatx vxyaa. ");
INSERT INTO pbb_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Txã'wẽ uyçxa', Jesusna na'wẽk we'we Pedro': —Ayte' kwe'sx ũswa'j wala ewa'. Aça' idx ewna jĩte', tekh wa'kuẽ txaja'nja'w, vxite' iidx jĩi vxite' Moises jĩi vxite' Elias jĩi. ");
INSERT INTO pbb_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Txã'jĩna Pedro' we'wena ũsiyna, tãaph seena' zhiçxkwe çxihmesa kũhçxa aphku. Aça' txãa tãaphte na'jĩnak we'weni pthũuse: —Na' adx Nçxi'k wala wedxnisa', txãa pa'ga wala weçxana ũsthu. Txã'sa' nwẽese'jna kxtey myuuwe jĩni's ");
INSERT INTO pbb_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Pedrowe'sxa' wẽse'jçxa', wala ũukhçxa kiwega pkipha wetetx. ");
INSERT INTO pbb_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Aça' Jesusa' txãawe'sxtxi jxa'dxçxa na'wẽk we'we: —Ũukhmée mkiitewe jĩte', ");
INSERT INTO pbb_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","kiiteçxa' Moiseswe'sxtxi' uymeeyã'tha', naasáa Jesusçxáa yã'kh ũs yu'. ");
INSERT INTO pbb_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Txajũ' thã'ju sa'jna u'jweççxa', Jesusa' na'jĩnak jxkaah: —Kim yuhtxwa pta'sxmeene'kwe txã'wẽ uyni's, Dxus Nçxi'k Nasa Yuusáa uuçxawa ki' ĩtxi yuupkaçx jĩte', ");
INSERT INTO pbb_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Pedrowe'sxa' Jesusna na'wẽtx pẽjx: —Dxus leya's kaapiya'jsawe'sx pta'sxçxa', Elias khuẽ'y yaçte pa'jana jĩ'tx, sa' ¿ma'wẽ yuuwa'jsakx açki'tx txã'jĩ'? jĩte', ");
INSERT INTO pbb_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Jesusa' na'wẽk pta'sx: —Isa, Elias khuẽ'y yuh yaçte pa'jwa'jsa yu'k, aça' isa yuh pta'sxi'ne'ta. ");
INSERT INTO pbb_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Adxa' na'jĩ'th na', Eliasa' yaçte pa'jyujk. Txã'wẽtewa nasa' jiyumeeçxa, txã'sa' kĩjkĩhwa yũutx. Aça' Dxus Nçxi'k Nasa Yuusáawa wala pkxuuni yuuna txãawe'sx kusetey jĩk. ");
INSERT INTO pbb_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Aça' Pedrowe'sxa' jiyutx Jesusa' Juan Bautistana yajkxçxa we'weçtewa. ");
INSERT INTO pbb_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Txajũ' txãawe'sxa' sxawedna kĩjaçte', nasa wala pkhaakhena ũsu'tx. Aça' teeçx piçthẽ'j Jesus tasxte peejxũkwena kũhçxa', na'wẽk pxthaa we'we: ");
INSERT INTO pbb_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","—Adx nçxi'ka's meen peeygãh, wẽeçxpa'jçxa iiméh seena' pxthaa yuuna ũsa'. Maa enteya' ipxkhẽwa khẽje'k, sa' yu'khẽwa khẽje'k. ");
INSERT INTO pbb_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Aça' idx yakh u'jusawe'sx tasxte jxũna kũhtewa, nuykatxhiya' ãjameeta' jĩte', ");
INSERT INTO pbb_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Jesusa' na'jĩnak pas: —Dxusa' pu'çxhina sũhwa'j yu'sa' ji'phmeesata' naa nasa'. ¿Bagaçxpkaçx i'kwe'sx yakh pu'çxna ũs ya'watka? ¿Bagaçxpkaçx ãjamée fxi'ze ya'wakwe? Luuçxa's ayte mneejxũhwe jĩte', ");
INSERT INTO pbb_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","jxũna kũjuçpkaçxha', Jesusa' eçxa's juuna' we'weçxa kutxi'kh luuçx ũusu, aça' txãa dudtey katxhinik neeyũu. ");
INSERT INTO pbb_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Jesus yakh u'jusawe'sxa' Jesusa'sçxáa fxii pa'yaçxa, na'jĩnatx pẽjx: —Kwe'sxa' ¿kĩh yũuçxakxtha'w eçxa's kutxi'jya' ãjamée? jĩte', ");
INSERT INTO pbb_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Jesusa' pta'sxku: —Dxusa' pu'çxhina sũhwa'j yuuçxá's yaakxpa'gamée i'kwe ãjamée. Isath we'we', Dxusa' pu'çxhina sũhwa'ja's mostasa fxiw na'wẽ le'çxkuẽesaçxáawa ji'phwaça', naa vxiç wala's we'weni yakhçxáa fxiite ki'pxa' ãjane'kwe. Dxusa' pu'çxhina sũhwa'j yuuçxá's yajkxwaça', i'kwe'sx yakha' kĩh yuhwa thẽysameena. ");
INSERT INTO pbb_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Na'wẽsa eçxa' thẽymée yu' kasehmeena, wala yũunaana Dxus yakh puutx we'wete yuuçxáa kasejena jĩk. ");
INSERT INTO pbb_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Txajũ' Galilea kiwete ũsçxa', Jesusa' txãa yakh u'jusawe'sxtxi' pta'sxku: —Dxus Nçxi'k Nasa Yuusa's nasa ewmeesa kusete dukhni yuuwa'ja'. ");
INSERT INTO pbb_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Aça' ikhetxna, nawa tekh ente' ki' ĩtxi yuuna jĩna pta'sxte', txãawe'sxa' wala nxustxi. ");
INSERT INTO pbb_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Jesusa' txãa yakh u'jusawe'sx yakh Kapernaum çxhabte pa'the', dxuus yattewe'sx vxyuu pkhakhsawe'sxa' Pedro's thegya' u'jçxa na'wẽtx pẽjx: —I'kwe'sxtxi kaapiya'jsa' ¿dukheçmeewá' dxuus yattewe'sx vxyu's? jĩte', ");
INSERT INTO pbb_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Pedro we'weçxa': —Dukhe'íik jĩnak pas. Sa' Pedro' Jesus ũsni yatte kũjuçpkaçxha', Jesusa' na'jĩnak we'we: —Simon, idxa' ¿maa sũju'ga? Naa kiwete jxkaahsawe'sxa' vxyu kaapkhakhe'jçxa', ¿kimtxi pẽywa'ja' jĩ'ta? ¿Jxkaahsa ji'jwe'sxwa dukhe'ta', meeçxa' txãa ji'jmée ekajuwe'sxçxáa wá'nta dukhe'? jĩte', ");
INSERT INTO pbb_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Pedro' na'wẽk pas: —Ekajuwe'sxçxáatx dukhe' jĩk. Aça' Jesusa' na'wẽk we'we: —Txã'wẽyã'the', jxkaahsa ji'jwe'sxa' dukhwa'jsameeta'. ");
INSERT INTO pbb_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Nawa kim yuhtxwa kaaũusçxa'jya'mée idxa' u'jçxa ĩkhwalate wedx yũhza's akhene'ga, sa' nyafxte wedx kãasa's kaawayi'jçxa uyuune'ga teeçx vxyu ji'phna. Txãa yakh dukhene'ga adx pa'gate vxite' iidx pa'gate yã'jçxa jĩk. ");
INSERT INTO pbb_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Txãa ensu' Jesus yakh u'jusa docesawe'sxa' txajx tasxte utxaaçxa na'wẽtx pẽjx: —Naa kiwete Dxus jxkaajxa' kĩi ente' ¿maa wejx jxthaakwe walasakxtha'w? jĩte', ");
INSERT INTO pbb_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Jesusa' teeçx luuçxkuẽ's pa'yaçxa txãawe'sx ksxavxyte txahçxa ");
INSERT INTO pbb_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","na'wẽk we'we: —Isath we'we', i'kwe'sxa' iiwejçx yaakxni's nvxihtçxa naa luuçx na'wẽ yuumeeçxa yu', Dxus jxkaahna ũsnite u'kaya' ãjameene'kwe. ");
INSERT INTO pbb_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Txã'wẽ kĩhtewa ãhmeekwesa naa luuçx na'wẽ yuusa yuuçxáa, Dxus jxkaahna ũsnite' maatewa jxthaakwe walasa yuuna. ");
INSERT INTO pbb_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Maa nasawa adxna jxpa'gaççxa ma'wẽ weçxana jxpa'gatx txã'wẽy weçxana naa luuçxkuẽ na'wẽsatx jxpa'gana txã' adxna jxpa'gasa yuuna. ");
INSERT INTO pbb_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Adxna jxpa'gasa ãhmeekwesatx maawa pkalte kweete'jsa's txhikhte skuutxh ũ'khni kweta's tudçxa ĩkh wala dxiikhẽ akhwaççxáa, wejx ewna. ");
INSERT INTO pbb_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Naa kiwete ewmeesa' bagaçxtewa nes yuutxna. Nawa naa kiwete ewmeesa yakha' seena' yuh ũukhũukha'. Sa' maawa txã'wẽ pkalte kweete'jena txãa yu' weh yuhwa iyumeena. ");
INSERT INTO pbb_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Txãa pa'ga iidx kuse ma'k yuu meeçxa' iidx çxida ma'k yuu nawa txã'wẽ pkalte kweete'jpçxãh yuuçte', txã'sa' spẽ'thçxa mwãatah. Txã'wẽ pçuwa'jmée ipx walate e'z kuse e'z çxida ji'ph akhni yuu na'wẽ', wejxwa pçumée ĩtxi fxi'zewa'the çxida ji'phmée legkuẽçxáawa kxtee u'kani wejx ewa'. ");
INSERT INTO pbb_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Iidx yafx txã'wẽ pkalte kweete'jpçxãh yuuçte', kutxi'jçxa mwãatah. Infxierno ipxte e'z yafx ji'ph ũs na'wẽ', wejxwa pçumée ĩtxi fxi'zewa'the teeçx yafx yakhçxáawa u'kani wejx ewa'. ");
INSERT INTO pbb_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Naawe'sx ãhmeekwesa maa yuhtxwa açenuwe. Na'jĩ'th na': naawe'sxtxi pi'kxna u'jusa angeleswe'sxa' cielute adx Tata tasxte nes yuusaata'. ");
INSERT INTO pbb_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Txã'wẽme', Dxus Nçxi'k Nasa Yuusa' vxitusatx nwe'weya'k kĩh. ");
INSERT INTO pbb_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","I'kwe'sxwaççxáawa ¿na'wẽ yũumeema'kwe? Cien piisxáa ji'phçxa', teeçxsa' vxitute', nowenta y nwewesatx vxiçsũ nvxihtçxa piisxáa vxitusa's pakweya' ¿u'jmeema'kwe? ");
INSERT INTO pbb_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Sa' uyçxa', vxite vxitusamée nowenta y nwewesate jxthaakwe peeygãhna weçxaane'kwe. ");
INSERT INTO pbb_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Txã'wẽy i'kwe'sx Tata cielute ũssawa teeçxçxáa yuhwa vxitu jxthãasu'çme' naawe'sx ãhmeekwesatewa. ");
INSERT INTO pbb_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Iidx yakhthẽ'j idxa's ewmée yũute', txã'sçxáan pa'yaçxa mkaajiyu'j ewmée yũuni's. Iidx we'weni's nwẽese'jewáana aça' iidx yakhthẽ'j yakh kxtee yuwe ewuune'ga. ");
INSERT INTO pbb_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Nawa nwẽese'jmeewáana aça' testigo teeçx meeçxa' e'z txahçxa txãawe'sx dxi'pte we'wene'ga, kxah txãa e'z testigosa' jiyutxna iidx yuwe ewuuya' pa'pçxuni's. ");
INSERT INTO pbb_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Txãa e'z testigo dxi'pte nwẽese'jmeete', dxuus yatte jxkaahsawe'sxtxi mpeeta'sx. Aça' txãawe'sxtxiwa nwẽese'jmeeçxa', yakhthẽ'j na'wẽmée Dxusna jiimeesa na'wẽçxáa nvxiitni yuuna. ");
INSERT INTO pbb_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Isath we'we': I'kwe'sxa' yuwetxi's naa kiwete pheu'the', cielutewa Dxus dxi'pte pheu'jni yuutxna. Nawa i'kwe'sxa' yuwetxi's pheu'jmeete', cielutewa Dxus dxi'pte pheu'jnimée yuutxna. ");
INSERT INTO pbb_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Na'jĩ'th na': I'kwe'sx kĩh yũune'jçxawa e'zsaçxáawa txã'wẽ yuute ewna jĩna puutx we'weçxa, Dxusa's pi'kine'kwe ma'wẽ yuuwa'ja'swa aça' adx Tata cielute ũssa' kxtey yuuna. ");
INSERT INTO pbb_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Txãa pa'gatey e'z ma'tx yuu meeçxa' tekh ma'tx yuu nawa adxa's yajkxna pkhaakheçxa ũste', adxa' txãawe'sx ksxavxyte ũswa'jsath jĩk. ");
INSERT INTO pbb_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Txajũ' Pedro' Jesus tasxte utxaaçxa', na'jĩnak pẽjx: —Yakhthẽ'j adxa's ewmée yũusa's ¿maz us peltunãywa'j yuukx, meeçxa' sietepkaçxçxáa ewmanx? jĩte', ");
INSERT INTO pbb_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jesusa' na'wẽk pta'sx: —Sietepkaçxçxáa ewna jĩya'wameeth. Sietesaçxaçxáa setenta ãhpkaçx peltunãywa'ja' jĩk. ");
INSERT INTO pbb_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Txãa pa'gatey Dxus jxkaahwa'j en ãhte', na'wẽ yuuna: Teeçx jxkaahsa' txã'sna selpisaawe'sx yuultxi pẽyiçku yu'. ");
INSERT INTO pbb_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Yuulsatx teeçxsa na'wẽçxah pẽjxna u'jweçpkaçxha', teeçx jxũna kũhtx iiméh seena' wala yuulsana. ");
INSERT INTO pbb_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Txãa selpisa' kĩh yakh yuhwa dewewa'j ji'phmeek yu'. Aça' patrona' txãa yuulsa's txweykaakh txajx nyu, txajx luuçx, txajx ji'phuni yã'jçxa jxuka txãa yuula's dewewa'j. ");
INSERT INTO pbb_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Txajũ' selpisa' patron tasxte peejxũkweçxa pxthaa we'wek: Adxa's meen peeygãh. Txãa yuula's jxuka dukhe'nja jĩte', ");
INSERT INTO pbb_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","patrona' peeygãhna yuula's peltunãyçxa ewte nvxihtku. ");
INSERT INTO pbb_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Nawa txãa peltunãynisa' kasehna u'jçxa', vxite selpisáa txã'sna walameekuẽ yuulsa'sku uy, sa' txhikhte uweçxa ikheçku yu': Adxna yuulgu txã'sna mdukh jĩna. ");
INSERT INTO pbb_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Txajũ' txãa yuulusa' peejxũkweçxa na'jĩnak pxthaa we'we: Adxa's meen peeygãh, jxuka dukhe'nja jĩtewa, ");
INSERT INTO pbb_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","kxtey yuumée wejxwa karcelna jxũna u'jçxa kxtee txajk txãa yuula's dukhpkaçx. ");
INSERT INTO pbb_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Txã'wẽ yuuçte vxite selpisaawe'sx uyçxa', wala nxustxi. Sa' u'jçxa pta'sxtxi txã'wẽ ewmée yũusáa patrona's. ");
INSERT INTO pbb_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Aça' patrona' ewmée yũusa's pa'yaçxa na'wẽk we'we: Selpisáa peethãhwe, adxa' iidx yuula's jxuka peltunãythu, pxthaag we'we txãa pa'ga. ");
INSERT INTO pbb_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Aça' idxwa txã'wẽy idxna yuulusa's peeygãhna peltunãywa'j ji'phgu, adxwa ma'wẽtka peeygãh idxa's txã'wẽy jĩçxa', ");
INSERT INTO pbb_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","txãa patrona' wala ũusaçxaçxa, kastigãykaakh yuula's jxuka dukhpkaçx. ");
INSERT INTO pbb_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Txã'jĩçxa', Jesusa' na'wẽk pta'sx: —Teeçxsa na'wẽçxah ũusuh jxuka peltunaĩmeewá'kwe i'kwe'sx yakhthẽ'jwe'sxtxi, aça' adx Tata cielute ũssawa txã'wẽy kastigaĩna i'kwe'sxtxi' jĩk. ");
INSERT INTO pbb_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Txã'wẽ we'wena jxã'jçxa', Jesusa' Galileaju kasehna u'jçxa Judea kiwesu Jordan yu'kutetek pa'j. ");
INSERT INTO pbb_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Kxte ũste', nasa wala pa'jtx, aça' nuykatxhik ãça'satx. ");
INSERT INTO pbb_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Naapkaçxha' fxariseowe'sx maaíi yu' Jesus tasxte utxaana kũhçxa na'wẽtx pẽjx, pasya' sxiigte' ewmée vxit-ya' sũhçxa: —Ptamsaçxawa, nyu kĩjkuẽçxáa ãhmée yũuteçxáa txãapa'ga wãatahte ¿ewmanx? jĩte', ");
INSERT INTO pbb_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Jesusa' na'wẽk pas: —I'kwe'sxa' ¿Dxus librute iilẽeymeewá'kwe? Kxtee we'weçxa': Dxusa' nyafxiitey e'zíitx ja'daçxajk vxit piçthẽ'j petx u'y yã'jçxa. ");
INSERT INTO pbb_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Txãa pa'ga piçthẽ'ja' peekx neywe'sx tasxu txuteeçxa peekx nyu yuuwa'jsa yakh utxaawa'jsa', txã'wẽ e'zçxawa teeçxsaçxáa na'wẽ yuuna pa'jya' jĩ'k Dxus librute'. ");
INSERT INTO pbb_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Txã'wẽ yũunijũ', e'zmée teeçxçxáak yuuna pa'ja'. Txãa pa'ga Dxus pũpxçxa nvxiitniijũ' ptamsayã'ja' txuteewa'jsameeta'. ");
INSERT INTO pbb_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Txã'jĩte', na'wẽtx pẽjx: —Txã'wẽte', Moisesa' ¿kĩjxa'ga peekx nyu yakh txuteeçxa eç vxitçxa nyu's ũsçxa txuteewa'ja' jĩna jxkaaja'? jĩte', ");
INSERT INTO pbb_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Jesusa' na'wẽk pas: —I'kwe'sx txã'wẽ Dxus jxkaahni's nwẽese'jmeeçxa nyu yakh txuteena fxi'zepa'ga íiçxáak Moisesa' txã'wẽ yũuwa'ja's nvxiht. Nawa txã'wẽ yũuwa'ja's nyafxiitey Dxus nvxiitnisa yu'çme'. ");
INSERT INTO pbb_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Adxa' na'jĩ'th na': Nyu txã'wẽ vxite piçthẽ'j yakh pkal yuuna fxi'zesameete wáa nyu's wãatahçxa vxite u'y yakh ptamuuna na' txã'wẽ vxite yakh ptamuupa'ga pkal kazx yuusáa yuuna. Meeçxawa nmi' wãataanisa u'y yakh maawa ptamuuna na' txã'wẽ u'y wãataanisa yakh ptamuupa'ga pkal kazx yuusaaíiçxáa yuuna jĩte', ");
INSERT INTO pbb_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Jesus yakh u'jusawe'sxa' na'wẽtx we'we: —Txã'wẽte', ptamumée fxi'zeni wejx ewna jĩtx. ");
INSERT INTO pbb_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Aça' Jesusa' na'wẽk pas: —Txã'wẽ yuja', nawa jxukay yu' ptamumée fxi'zeya' ãja'çmeeta', naasáa kimnane' Dxusa' ptamumée fxi'zewa'ja's nvxiht txãaçxáa ptamumée fxi'zeya' ãjana, vxite' ptamumée Dxusçxáana selpiina fxi'zewa'jsata'. ");
INSERT INTO pbb_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Na'wẽsa yu' ptamumée fxi'zeya' ãja'tx: Maaíi yu' ptamumée fxi'zeya' upxsatxna, aça' vxitetxi's naa kiwete piçthẽ'jwe'sx íiçxáatx ptamumée fxi'zewa'ja's vxitu', aça' vxite' ptam yuumée Dxusçxáana selpiina fxi'zewa'jsata'. Ptamumée fxi'zeya' ãjasa', ptamumée fxi'zetxna jĩk. ");
INSERT INTO pbb_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Txajũ' Jesus tasxte luuçxkuẽ nuypa'jtx, luuçx dxikthesu peekizeçxa Dxus kusete neewe'wekahn. Nawa Jesus yakh u'jusawe'sxa' ũusçxa we'wetx nuypa'jsatx. ");
INSERT INTO pbb_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Aça' Jesusa' na'wẽk we'we: —Luuçxkuẽ adx tasxte yuusaatxi' kuçx yupnuwe, txãa pa'gatey cielute Dxus jxkaahna ũsnisa' naa luuçxkuẽwe'sx na'wẽsa jĩi íiçxá'. ");
INSERT INTO pbb_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Txã'jĩçxa', luuçxkuẽwe'sx dxikthesu peekizeçxa Dxus kusete neewe'weçxa', txajũ u'kh. ");
INSERT INTO pbb_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Txãa e'su' teeçx piçtakx Jesus tasxte pa'jçxa na'wẽk pẽjx: —Kaapiya'jsa wala ewsa, mpeeta'sx. ¿Kĩh ew yũuçxa pçumée ĩtxi fxi'zewa'ja's ji'phuki'th? jĩte', ");
INSERT INTO pbb_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Jesus pasçxa': —¿Kĩh yuupa'gaga adxa's ewsa jĩ'? Ew yũusa' teeçx yuuçxáa ũsa' txã' Dxusa'. Aça' pçumée ĩtxi fxi'zewa'ja's ji'phu wẽeçxa', Dxus jxkaahnitxi' kxtey myuu jĩte', ");
INSERT INTO pbb_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","piçtakxa': —¿Maatxna? jĩna pẽjxte', Jesusa' pta'sxku: —Dxusa' na'wẽk jxkaaja': Nasa ikhwa'jme', ptamsayã'ja' vxite yakh pkal yuuwa'jme'. Pesweewa'jme'. Vxitetx ĩsxiina nuywe'wewa'jme'. ");
INSERT INTO pbb_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Neywe'sxtxi peeygãhna ewçxáa yũuna fxi'zewa'ja'. Peekíi ma'wẽga ya'peeygãja' txã'wẽy mpeeygãh vxite nasatxwa jĩte', ");
INSERT INTO pbb_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","piçtakx pasçxa': —Txãatxi' le'çxkuẽjũjx kxtey yuunath waláa, aça' ¿kĩh wejx peejxna? jĩte', ");
INSERT INTO pbb_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jesus pasçxa': —Dxus jxkaahnitxi' jxuka kxtey nwẽese'jsa yuu wẽeçxa', u'jçxa iidx ji'phunitxi' jxuka txweyçxa ji'phmeekuẽsatx mes. Sa' txã'wẽ yũuçxa' cielute ji'phsa yuune'ga. Txã'wẽ yũuçxa adx yakh myuh jĩte', ");
INSERT INTO pbb_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","txãa piçtakxa' txã'wẽ wẽse'jçxa' nxusnak u'j, wala ji'phsa yu'k txãa pa'ga. ");
INSERT INTO pbb_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Txajũ' Jesusa' na'wẽk we'we txãa yakh u'jusawe'sxtxi: —Isath we'we', ji'phsa yakha' wala yuh thẽya' Dxus jxkaahna ũsnite u'kawa'j. ");
INSERT INTO pbb_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Na'jĩ'th na': kamelxo txakwesa' ¿ma'wẽ yũz kafxga khẽwya' ãjakx? Aça' ji'phsa yakha' txãate jxthaakwe thẽya' Dxus jxkaahna ũsnite u'kawa'j. ");
INSERT INTO pbb_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Txã'jĩni's wẽse'jçxa', Jesus yakh u'jusawe'sxa' wala kuh yajkxtxi, sa' txãawe'sx pwe'sx na'wẽtx puutx ya'paapẽyi': —Txã'wẽte', ¿kimçxá' ewte neeyũuya' ãjama'k? jĩte', ");
INSERT INTO pbb_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Jesus thegçxa' na'wẽk we'we: —Nasa' Dxus yakhmée yu', ewte neeyũuya' ãjameeyuhtxna. Nawa Dxus yakh yu', kĩh yuhwa thẽysa meea'. ");
INSERT INTO pbb_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Txã'jĩte', Pedro' na'wẽk pẽjx: —Kwe'sxa' idx yakh yujxa' kwe'sx ji'phuni's jxuka nvxihttha'w, sa' ¿kĩh jxpa'gakxtha'w? jĩte', ");
INSERT INTO pbb_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jesusa' na'jĩnak pta'sx: —Isath we'we', naa kiwete pkalsa's jxuka yu'pthehçxa ewsaçxaçxáa yuuwa'j en ãhte', Dxus Nçxi'k Nasa Yuusá' pa'jçxa jxkaajxa' takheçpkaçxha', adx yakh yuusáa i'kwe'sx docesawa adx yakh jxkaahsa yuune'kwe Israel ji'j docesatx. ");
INSERT INTO pbb_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Maawa jxukaysa txã'wẽ adx yakh yujxa'çxáa txãawe'sx yat, kiwe, nyakhwe'sx, npe'sxwe'sx, neywe'sx, nyu, nçxi'kwe'sx, niisawe'sx txãatx jxuka nvxiit-sa' txãa nvxiitnisate jxthaakwe wala jxpa'gatxna, sa' pçumée ĩtxi fxi'zewa'ja'swa jxpa'gatxna. ");
INSERT INTO pbb_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Nawa jxpa'yakxmeete', makwe yaçtewe'sxçxawa, nmehtewe'sx yuutxna; naapkaçxha' nmehtewe'sx yu', yaçtewe'sx yuutxna jĩk. ");
INSERT INTO pbb_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Dxus jxkaahni ente mjĩisa' na'wẽ yũuni yuutxna: Teeçx mjĩi namu' kusíi kasehçxa mjĩisa pakweya' u'kh, uuthasxte uwa udewa'jsa. ");
INSERT INTO pbb_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Sa' mjĩiwa'jsa yakh puutx we'wek teen mjĩini's ãh dukhya'. Txã'wẽ yũuçxa mjĩi ehn kaakh. ");
INSERT INTO pbb_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Sa' kusíi las nwewe yuuçpkaçxha', ki' kasejk, sa' vxite kĩh mjĩiwa ji'phmée plaasasu u'jusatx uyçxa', ");
INSERT INTO pbb_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","txãatxi' na'wẽk we'we: Me'jwe mjĩiya' adx mjĩi ehte, teen uta mjĩinite ãh dukhe'nja jĩte', txãawe'sxa' u'jtx mjĩiya'. ");
INSERT INTO pbb_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Txajũ' mjĩi namu' ẽepxãh wala ki' kasejk, sa' kusuçte las trestewa ki' kasejk, txãatxwa txã'wẽy mjĩiya' kaakh. ");
INSERT INTO pbb_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Txajũ' kusuçte las cinkote plaasasu ki' kasehçxa', vxite uyku kĩh mjĩiwa ji'phmée u'jusatx. Txãawe'sxtxiwa na'wẽk we'we: I'kwe'sxa' ¿kĩh yũuçxa mjĩi ji'phmée u'jukwe teen uta? jĩte', ");
INSERT INTO pbb_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","txãawe'sxa' na'wẽtx pas: Kimwa mjĩiya' pa'yameeta' jĩte', mjĩi namu' kaakh txajx mjĩi ehte: U'jçxa adx mjĩi ehte mjĩine'kwe aça' adxa' wala ew dukhe'nja jĩk. ");
INSERT INTO pbb_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Txajũ' jxuka kuste', mjĩi namu' pa'yak kxtee kmãaji'jsa's na'jĩna: Mjĩisatxi' pa'yaçxa mdukh, nawa nmeh mjĩiya' pa'jsatx khuẽ'y nyafxte dukhçxa teen uta mjĩisatxi' nmehte dukhna jxã'jane'ga jĩte', ");
INSERT INTO pbb_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","kxtey yuuk. Aça' kusuçte las cinkote mjĩiya' pa'jsa khuẽ'y utxaaçxa teeçxsa na'wẽçxah jxpa'gatx teen uta mjĩinite ãhçxaçxáa. ");
INSERT INTO pbb_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Txajũ' kusíi mjĩiya' pa'jsa': Kwe'sxa' jxthaakwe jxpa'ga'nja'w sũhna ũsçxawa, txakweíiçxáa jxpa'gaçxa' ");
INSERT INTO pbb_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","ũusçxa we'wetx mjĩi namu's na'jĩna: ");
INSERT INTO pbb_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Naawe'sxa' nmeh pa'jçxa naasáa teeçx ora yuuçxáatx mjĩi. Nawa dukhni yu'sa' kwe'sx nakweíiçxáatx jxpa'ga. Naapkaçxha' kwe'sx yu' teen utatha'w mjĩi, sekte yaaçxana wantãyna jĩte', ");
INSERT INTO pbb_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","mjĩi namu' na'jĩnak pas: Namiku, idx yakh ewmée yũuçmeeth. Adxa' teen uta mjĩini's ãh dukhe'nja jĩna idx yakh puutx we'wete', ewna ¿jĩmeegá'? ");
INSERT INTO pbb_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Txãasa iidx mjĩini's ãh dukhni's jxpa'gaçxa me'j. Idxna nakweth dukh txakweçxaçxáa dukheçthu nmeh mjĩiya' pa'jsatxwa. ");
INSERT INTO pbb_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Nawa adx jĩ'sa' ma'wẽ yũuweçxtewa kxtey yu'nja. Meeçxa' adx ew yũuni's idxa' ¿açe'wá'ga? jĩk mjĩi namu'. ");
INSERT INTO pbb_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Txã'wẽ yũuwa'jsata' nmehtewe'sxa' yaçtewe'sx yuutxna, naapkaçxha' yaçtewe'sxa' nmehtewe'sx yuutxna. Txãa pa'gatey pa'yanisa yu' wala kuhta', nawa txhitxhnisa yu' kuhmeeta' jĩk. ");
INSERT INTO pbb_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Jesusa' Jerusalen dxi'the u'jweççxa', txãa yakh u'jusawe'sx docesatx fxiite pe'jna u'jçxa na'jĩnak pta'sx: ");
INSERT INTO pbb_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","—I'kwe'sxa' jii i'kwe Jerusalenna u'jweçtha'w. Kxteea' Dxus Nçxi'k Nasa Yuusa's uweçxa dukhni yuuna sacerdote npiiçthẽ'j vxite' ley kaapiya'jsawe'sx kusete. Aça' txãawe'sxa' ikhwa'j vxitçxa ");
INSERT INTO pbb_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","judiu ji'jmée vxite nasatx dukhetxna, txãawe'sxa' weeçxna pãpana kluuskhẽ ki'pçxa ikhkahn. Nawa tekh ente' ki' ĩtxi yuuna jĩk. ");
INSERT INTO pbb_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Txajũ' Jakobo Juan njĩ'j Zebedeo nyua' txãa e'z nçxi'ksa yakh Jesus tasxte peejxũkwena utxaatx, txãawe'sx pẽyni's Jesusa' kxtey yuukahn. ");
INSERT INTO pbb_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Aça' Jesusa': —¿Kĩjkwe yũu jxthãasu'? jĩte', Jakobowe'sx njĩ'ja' na'wẽk we'we: —Idxa' naa kiwete jxkaajxa' kĩhçxa', ũ'kwe luuçx naa e'zsatx iidx pukakhẽ pdxi'p kaçxwa'ja's ũsune'ga jĩte', Jesus we'weçxa': ");
INSERT INTO pbb_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","—I'kwe'sxa' jiimeeçxai'kwe txã'wẽ pẽyi'. Adx na'wẽy pxthaa yuuçxa uuwa'ja's ũukhmée jxpa'gaya' ¿ãjama'kwe i'kwe'sxa'? jĩte': —Ãja'nja'w jĩnatx pas. ");
INSERT INTO pbb_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Aça' Jesusa' pta'sxku: —Isa, i'kwe'sxa' adx na'wẽy pxthaa yuuçxa uuwa'ja's ji'phuyujune'kwe. Nawa txã'wẽ adx pukakhẽ pdxi'p kaçxwa'j yu'sa' adx ũsu'çmeeth. Txã'sa' naasáa adx Tata yuuçxáa ũsuna kiim jĩi pheu'jçxa ji'phna txã'sna jĩk. ");
INSERT INTO pbb_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Aça' diezsawe'sxa' ũusaçxatx Jakobowe'sx txã'wẽ pẽyni's wẽse'jçxa. ");
INSERT INTO pbb_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Nawa Jesusa' pa'yaçxa na'wẽk we'we: —I'kwe'sxa' peekx jii i'kwe, naa kiwete jxkaahsa' txãawe'sx nasatx juuna'tx jxkaaja', aça' txã'wẽy npiiçthẽ'jsawa txãawe'sx jxpe'jnisatx juuna'tx jxkaaja'. ");
INSERT INTO pbb_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Nawa i'kwe'sx yu' txã'wẽ juuna' jxkaahwa'jsamée i'kwe, wejx yuuwa i'kwe'sxa' walasa yuu wẽeçxa', vxitesa kusete selpisáa yuuwa'j ji'phi'kwe. ");
INSERT INTO pbb_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Aça' i'kwe'sx maawa txã'wẽ vxitesatx jxkaahsa yuu wẽeçxa', vxitee jxkaahni fxi'zewa'ja'. ");
INSERT INTO pbb_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Txãa pa'gatey Dxus Nçxi'k Nasa Yuusáa yuhwa txã'sna selpii jxthãasya' kĩhme', wejxwa nasatx nwe'wena selpiiya' kĩhçxak ya'dukh nxuste uuya' jĩk. ");
INSERT INTO pbb_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Txajũ' Jeriko çxhabuh kasehna u'jweçte', nasa' iimeh wala yuwe'tx Jesus e'ste. ");
INSERT INTO pbb_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Txãa dxi'the e'ztxi kaçxçxa u'p yu' uyya' ãjasamée. Sa' Jesus skhẽwni's wẽse'jçxa' sustxi we'we: —Davxid ji'j, kwe'sxtxi meen peeygãh jĩte', ");
INSERT INTO pbb_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","nasa' ũusçxa we'wetx sxuuna' yuukahn. Nawa txãawe'sxa' jweeíiçxáatx sus we'we: —Davxid ji'j, kwe'sxtxi meen peeygãh jĩna. ");
INSERT INTO pbb_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Aça' Jesusa' yujuçxa txãa uyya' ãjasameetxi' pa'yaçxa na'wẽk pẽjx: —¿Kĩjkwe yũu jxthãasu'? jĩte', ");
INSERT INTO pbb_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","txãawe'sx pasçxa': —Kwe'sx yafxtxitha'w phaade jxthãasu' jĩte', ");
INSERT INTO pbb_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Jesusa' peeygãhçxa txãawe'sx yafxsu jxa'dxiçpkaçxha', txãa dudtey uyya' ãjaçxa Jesus yakh u'jtx. ");
INSERT INTO pbb_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Jerusalente utxaana pa'jaççxa', Betfxagé çxhabkuẽte khuẽ'y pa'jtx. Txãa çxhabkuẽ' Oliwos vxiç utxagak ũsu'. Txajũ' Jesusa' txãa yakh u'jusawe'sx e'zsatx na'jĩnak kaah: ");
INSERT INTO pbb_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","—Ay dxi'pga çxhabkuẽ ũsa' kxtee me'jwe, sa' kxteea' uyuune'kwe buçxu luuçx njĩ'jsa tudni ũsna txã'sa' jxũkhwedeçxa jxũne'kwe. ");
INSERT INTO pbb_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Jxũna yuhte uyçxa' pẽyiwáatxna aça' kwe'sxtxi jxpe'jsa' peejxa', nawa txaçxmeyna kaasxwedu'juna jĩne'kwe. ");
INSERT INTO pbb_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Dxus yuwe pta'sxsa we'weni' kxtey yuuk. Txã' na'jĩnak fxi'j: ");
INSERT INTO pbb_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Sion çxhabte nasatx na'jĩna pta'sxine'kwe: Mthegwe, i'kwe'sxtxi jxkaahsa yuja', Pxthaakwesa na'wẽ thegna, buçxu luuçxte a'jçxa, Aça' txãa buçxu njĩ'ja' ktũ'se'jnisa' jĩna fxi'jni'. ");
INSERT INTO pbb_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Txajũ' txãawe'sxa' u'jçxa Jesus ma'wẽ jxkaathe', kxtey yuutx. ");
INSERT INTO pbb_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Sa' buçxu njĩ'ja's jxũna pa'jtx luuçx yã'jçxa. Txajũ' buçxu luuçx kastxaja'jnimeesa's txãawe'sx atxhtxi pustxi, aça' Jesusa' txãate a'kh. ");
INSERT INTO pbb_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Nasa wala kuh pi'kxna u'jsawe'sx yu', txãawe'sx atxhtxi dxi'jsutx pusna u'jwe' Jesus skhẽwwa'jsu. Maaíi yu' ẽjxa spẽ'thçxa txã'wẽytxi dxi'jsu pusna u'jwe'. ");
INSERT INTO pbb_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Aça' nasa' yaçte u'jsa vxite' e'ste yuusa txãawe'sx jxukaysa na'jĩnatx sus we'wena u'jwe': —Dxus kaahnisa wala yuh jxtuhthesa yuja' jxkaahsa Davxid ji'j. Dxusa's weçxaaga wala ew yũupa'ga jĩ'tx. ");
INSERT INTO pbb_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Txajũ' Jesusa' Jerusalente u'kate', kxtee nasa jxukaysa seena' wala sustxi na'jĩna paapẽjxna: —Na' ¿kimna? jĩte', ");
INSERT INTO pbb_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","pta'sxtxi na'jĩna: —Naaíi Dxus yuwe pta'sxsa Jesusa', Galilea kiwesu Nasaret çxhabtewe'sx jĩ'tx. ");
INSERT INTO pbb_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Txã'wẽ yũuni e'su' Jesusa' dxuus yatte u'kaçxa jxuka eka kasxisxku kxtee txweyna ki' weyna ũssatx. Sa' vxyu yu'pthehna ũsni mesa vxite' tub çxihme txweyna u'pnitxwa jxuka pũsxku. ");
INSERT INTO pbb_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Sa' na'wẽk we'we: —Dxus librute' na'wẽk we'we': Adx yata' Dxus yakh puutx we'wena ũswa'jçxá' jĩ'k. Nawa i'kwe'sxa' peswée pkhaakhena ũsni kafx na'wẽçxáa vxitçxa ji'phi'kwe jĩk. ");
INSERT INTO pbb_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Kxtee dxuus yatte maaíi yu' Jesus tasxte utxaatx, uyya' ãjasamée, çxida legsa, aça' txãawe'sxtxi' nuykatxhik. ");
INSERT INTO pbb_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Nawa sacerdote npiiçthẽ'jwe'sx vxite' ley kaapiya'jsawe'sx txãawe'sxa' ũusaçxatx, txã'wẽ kim yuhwa ãjanimeesa's kaavxya'ja'the' kxtee dxuus yatte ũssa luuçxa' sus we'weçxa' jxkaahsa Davxid ji'ja's wala weçxa'tha'w jĩna susni's wẽse'jçxa. ");
INSERT INTO pbb_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Sa' Jesusa's pẽjxtxi: —Na'wẽ we'wena ũsta' txã'sa' ¿wẽse'je'ga'? jĩte', Jesusa' pasku: —Wẽse'je'íith. Nawa i'kwe'sxa' ¿iilẽeymeekwe'? txã'wẽ yũuwa'ja's Dxus librute na'jĩnak we'we': Luuçx le'çxkuẽ vxite' çxu'çxsawa txã'wẽ zhiçxkwe tuuthe'jwa'ja'sgu vxit jĩ'k. ");
INSERT INTO pbb_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Txajũ' Jesusa' kxtee nvxihtçxa u'kh çxhabu kasehna sa' Betania çxhabtek pe'te. ");
INSERT INTO pbb_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Kuskuskhẽ' Jesusa' çxhabna ki' sxawedna u'jweççxa', wẽek. ");
INSERT INTO pbb_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Sa' dxi'j pukate higwera fxtũu tasx ũste uyçxa', thegya' utxaak. Nawa kĩh yũn yuhwa uyme', eççxáak ji'ph yu'. Aça' txãa fxtũu tasxa's na'wẽk we'we: —Ãçxha' peena yu' yũnmeene'ga jĩçpkaçxha', naa dudtey fxtũu tasxa' uhdxku. ");
INSERT INTO pbb_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Txãa yakh u'jusawe'sxa' txã'wẽ uyçxa', wala kuh yajkxna na'wẽtx pẽjx Jesusa's: —Fxtũu tasxa' ¿kĩh yũuçxaga txakwe wala dud uhdx? jĩte', ");
INSERT INTO pbb_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Jesusa' na'wẽk pas: —Isath we'we': Kuh jwed yajkxmée Dxusa' pasyujuna sũhwa'jçxá's yajkxçxa', adx vxitthu txã'wẽçxáamée, na'wẽ yũuya'wa ãjane'kwe: Naa vxiç wala ayjxu u'jçxa ĩkh walate tee khẽe jĩne'kwe, aça' kxtey yuuna. ");
INSERT INTO pbb_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","I'kwe'sxa' kĩh pẽjxçxawa Dxus yakh puutx we'wene'kwe Dxusa' pasuna sũhna, sa' txã'wẽ yũuçxa' jxpa'gane'kwe jĩk. ");
INSERT INTO pbb_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Txajũ' Jesusa' dxuus yatte u'kaçxa kaapiya'jaçpkaçxha', sacerdote npiiçthẽ'jwe'sx vxite' judiu nthẽ'jsawe'sx kũhçxa' na'wẽtx pẽjx: —¿Kĩh yũupa'gaga txã'wẽ dxuus yatte jxuka suw? ¿Kimga jxkaah txã'wẽ yũuwa'ja's? jĩte', ");
INSERT INTO pbb_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","na'wẽk pas: —Adxwa i'kwe'sxtxi pẽjx ya'wath, aça' adx pẽyni's pasya' ãjate', adxwa pta'sxi'nja kim jxkaathe txã'wẽ yũuçxawa. ");
INSERT INTO pbb_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Juana's ¿kimga jxkaah yu'te bautisãykahn? ¿Dxus wá' jxkaah, meeçxa' naa kiwete piçthẽ'jwe'sx wáa ne'ta jxkaah? jĩte', txãawe'sx pwe'sx puutx ya'paapẽyi'tx: —Dxusne' jxkaah jĩna paste', txã'wẽte' ¿mjĩitekwe nwẽese'jmée? jĩna. ");
INSERT INTO pbb_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Aça' naa kiwega nasa jxkaahnine' yu' jĩya'wa ãjame'nja'w. Txã'wẽme', nasa jxukaysa Juan ju'guçxaçxáatx we'we', Dxus jxkaahnine' yu' jĩna txãatxtha'w ũukhu' jĩnatx puutx we'we. ");
INSERT INTO pbb_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Sa' ãjameeçxa', Jesusa's na'wẽçxáatx pas: —Jiimeetha'w jĩna. Aça' Jesuswa txã'wẽyçxáak pas: —Adxwa pta'sxme'nja kim jxkaathe txã'wẽ yũuçxawa jĩk. ");
INSERT INTO pbb_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Txajũ' Jesusa' na'wẽk we'we: —I'kwe'sxa' ũus miiyajkxwe, na'wẽ kaaja'da'jçxa pẽjxya'wath: Teeçx piçthẽ'ja' e'z nçxi'kku ji'phu', sa' teeçxsa's na'wẽk jxkaah: Ãçxha' adx mjĩi ehte uwa uhdeya' me'j jĩte', ");
INSERT INTO pbb_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","nçxi'k pasçxa': U'j wẽemeeth jĩçxawa, ũus yajkxna u'pçxa', mjĩiya' u'kh. ");
INSERT INTO pbb_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Txajũ' neya' vxite nçxi'ka'swa txã'wẽy jxkaakh. Aça' txã' na'wẽk pas: Ewna, u'jwe'nja jĩçxawa u'jme'. ");
INSERT INTO pbb_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Ãçxha' i'kwe'sxtxi ¿ma'wẽga thegu'? ¿Maasaga ney jxthãasni's kxtey yuu? jĩte', txãawe'sx pasçxa': Nyafxte jxkaahnisa nçxi'k jĩtx. Aça' Jesusa' na'wẽk we'we: —Isath we'we', gobierno jĩi vxyu pkhakhsawe'sx vxite' u'ywe'sx pkal yuuna fxi'zesa txãawe'sx khuẽ'y Dxus jxkaahnite u'katxna, naapkaçxha' i'kwe'sxa' u'kaya' ãjamée ũsi'kwe. ");
INSERT INTO pbb_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Txãa pa'gatey Juan Bautista' kaapiya'jna pa'kh pçumée ĩtxi fxi'zewa'ja's. Txã'wẽtewa, i'kwe'sxa' jxpa'gameei'kwe. Naapkaçxha' gobierno jĩi vxyu pkhakhsawe'sx vxite' u'ywe'sx pkal yuuna fxi'zesa txã'wẽsa yu' jxpa'gatx. Nawa i'kwe'sxa' yafxju uyçxawa pkaltxi nvxihtçxa Dxus tasxte sxawedmeei'kwe. ");
INSERT INTO pbb_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Vxite ejemplo na'sna mwẽese'jwe: Teeçx kiwe namu' uuthasx vxitku, sa' peeku'j uphçxa teeçx ahte uwa's ku'swa'j txajk, sa' ẽete tejkaçxa jxuka thegwa'j yatwa txajk. Txã'wẽ yũuçxa txãa kiwe's mjĩisatx pki'jçxa jxu'j dxi'kh u'j. ");
INSERT INTO pbb_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Uwa thẽ'jwa'j en ãhte', txã'sna selpisaatx kaakh kiwee pki'jnipa'ga pẽjxya'. ");
INSERT INTO pbb_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Nawa kiwee pki'jsawe'sxa' txãa selpisaatx uweçxa maaíi yuutxi' pãpana vxitetx ikhna vxitetxi' kwet wãatatahnatx yũu. ");
INSERT INTO pbb_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Txã'wẽ yũute', kiwe namu' jweeíiçxáak kuh kaahna ũsu' selpisaatx. Nawa kiwee pki'jsawe'sxa' jxukaytxi txã'wẽçxaçxáatx yũu. ");
INSERT INTO pbb_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Txajũ' nmehte' txajx nçxi'k yuunak kaah: Adx nçxi'ka's kuçx txã'wẽ yũumeewáatxna sũhçxa. ");
INSERT INTO pbb_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Nawa kiwee pki'jsawe'sxa' nçxi'ka's uyçxa', txãawe'sx pwe'sx na'wẽtx puutx we'we': Ney uute' naa txã'wẽ kiwe's iiyamuwa'jsa', aça' txã'sa' ikhega kiwe' kwe'sx jĩi yuukahn jĩ'tx. ");
INSERT INTO pbb_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Txã'jĩyã'jçxa', uweçxa txãa kiwejũ kutxi'jçxa ikhtxi. ");
INSERT INTO pbb_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Txã'wẽ pta'sxçxa', Jesusa' na'jĩnak pẽjx: —Txã'wẽ yũute', kiwe namu pa'jçxa', ¿kĩh yũukx kiwee pki'jsawe'sxtxi'? jĩte', ");
INSERT INTO pbb_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","na'wẽtx pas: —Txãa ewmeesatxi' peeygãhmée ikhçxa txãa kiwe's vxitetx pki'jina kiwee pa'ga namu's wa'lmée dukhwa'jsatx jĩtx. ");
INSERT INTO pbb_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Aça' Jesusa' na'wẽk we'we: —I'kwe'sxa' ¿bagaçxte yuhwa iilẽeymeewá'kwe Dxus librute na'jĩna fxi'jni's? Yat txaahsawe'sxa': Naa kweta's selpime' jĩçxa wãatahtx. Nawa txãa íik yat makwesanawa çxhãçxha neewewa'jsa yuuna pa'j. Txã'wẽ neewewa'jsa yuuna pa'jwa'ja's Dxusku vxitçxa nvxiht. Txãa pa'ga kwe'sx yakha' wala weçxa yuja' ¿jĩ'çmeena'? ");
INSERT INTO pbb_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Txã'wẽ açepa'ga íiçxáath na'jĩ': Dxus jxkaahni's i'kwe'sxtxi kusa'jçxa vxite nasatx ũsni yuuna, kiwe namu's pki'pha'ga wa'lmée dukhkahn. ");
INSERT INTO pbb_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Sa' maawa txãa kwet kajkwega wetesa' jxuka çxkateteena, meeçxawa txãa kwet nasa kajkwekhẽ weteçxa' jxuka ku'çxina jĩk. ");
INSERT INTO pbb_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Aça' sacerdote npiiçthẽ'jwe'sx vxite' fxariseowe'sxa' jiyutx txãawe'sxtxi íiçxáa we'weçxa txã'jĩni's. ");
INSERT INTO pbb_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Sa' tud wẽeçxawa ũukhtxi, txã'wẽ nasa' Jesus ju'guçxaçxáatx ũs yu', Dxus yuwe pta'sxsa' jĩna txãa pa'ga. ");
INSERT INTO pbb_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jesusa' vxite ejemplo kaaja'da'jçxak pta'sx na'jĩna: ");
INSERT INTO pbb_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","—Dxus jxkaahni ente' na'wẽ yũuna: Teeçx jxkaahsa' txajx nçxi'ka's kaaba'jçxa fxiesta vxitku. ");
INSERT INTO pbb_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Sa' txãa jxkaahsa' selpisaatx jxkaakh pi'kxnisatx pa'yakahn. Nawa txãawe'sxa' wa'lçxa yuwe'çmeeta'. ");
INSERT INTO pbb_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Txã'wẽtewa, ki' jxkaakh vxite selpisaatx na'jĩna: Pi'kxnisatxi' yuukajane'kwe. Ũ'wa'ja's jxuka pheu'jniyã'j ji'pthu, tajkx kaaniisxi'jnisatx kiikhe'th, aça' myuhwe boda fxiestate jĩ'k jĩne'kwe. ");
INSERT INTO pbb_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Txã'wẽ kxtey yuutewa, pi'kxnisawe'sxa' nwẽese'jmée wejxwa txãawe'sx uuthasxsu vxite' txãawe'sx vxyu knaynisuçxáatx u'j. ");
INSERT INTO pbb_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Aça' vxite yu' selpisaatx uweçxa wala pãpatx ikhpkaçx. ");
INSERT INTO pbb_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Txã'wẽ yũute', jxkaahsa' seena' wala ũusaçxak, sa' txajx soldauwe'sxtxi kaakh txãa nasa ikhsatx ka'tuwa ikhçxa txãawe'sx çxhaba's jxuka kabkahn. ");
INSERT INTO pbb_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Txajũ' jxkaahsa' na'wẽk we'we txã'sna selpisaatx: Boda fxiestate ũ'wa'j jxuka pheu'jniyã'j ũsa', nawa pi'kxnisawe'sxa' wa'lçxa pa'jmeeta'. ");
INSERT INTO pbb_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Aça' ãçxha' me'jwe klxiikhunsuwe'sxtxi pi'kxya' maatxwa jxuka boda fxiestate yuukahn. ");
INSERT INTO pbb_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Txã'jĩte', selpisaawe'sxa' klxiikhunsu u'jçxa maatxwa jxuka pkhakhtxi ewsa ma'k yuu meeçxa' ewmeesa ma'k yuu nawa jxuka. Aça' fxiesta yatte jxuka nasa utatx. ");
INSERT INTO pbb_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Txajũ' jxkaahsa' pi'kxnisatx thegya' u'kaçxa', uyku teeçx piçthẽ'j txã'wẽ boda fxiestate athni ropa yakhmée u'pte. ");
INSERT INTO pbb_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Sa' na'wẽk we'we: Namiku, idxa' ¿kĩjxa'ga ayte u'ka', boda fxiestate athni ropa ji'phmeeçxa'? Txã'jĩte', txãa piçthẽ'ja' pasmée sxuuna'k neeyũu. ");
INSERT INTO pbb_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Aça' jxkaahsa' mesate puuçuçsatx na'jĩnak jxkaah: Naa piçthẽ'ja's uweçxa mtudwe çxida petx kuse yã'jçxa, sa' ekaju kutxi'jçxa çxhi'dx walate makhwe, kxte' ki'thtxi ksuusu'jna ũ'nena ũukhkahn. ");
INSERT INTO pbb_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Txãa pa'gatey wala yuh pa'yatewa, jxukay yu' utxaawa'jsameeta' jĩk. ");
INSERT INTO pbb_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Txajũ' fxariseowe'sxa' u'jçxa txãawe'sx pwe'sx puutx we'wetx Jesusa's ewmeete nvxiit wẽeçxa. ");
INSERT INTO pbb_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Txã'wẽ yũuçxa' txãawe'sx ju'gu ũssa vxite' Herodes nasa txãawe'sxtxi' kaahtx Jesusa's na'jĩna pẽykahn: —Kaapiya'jsa, idxa's jiitha'w, kĩhtewa isasaçxáanag we'we'. Sa' Dxus tasxte pa'jwa'j dxi'ja'swa ew yuuçxáag kaapiya'ja'. Nasaa jxkaahna yu'kxpehnitx nwẽese'je'çmeeg, txãa pa'gatey idxa' nasa ewsa na'wẽ thegsatx jiyumey ju'gu yu'çmeeg. ");
INSERT INTO pbb_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Idxa' ¿ma'jĩki'g? Jxkaahsa Cesara's vxyu dukhte ¿ewmanx? Meeçxa' ¿dukhmeete wáa ewna? jĩte', ");
INSERT INTO pbb_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Jesusa' na'wẽk pas txãawe'sx ewmée yaakxni's jiyuçxa': —Adx dxi'pteçxáa ew we'weçxa', ũuste yu' ewmée yaakxsawe'sx, ¿kĩjxa'kwe adxa's ewmeete nvxiit wẽeçxa txã'wẽ pẽyí'? ");
INSERT INTO pbb_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Dukhwa'j vxyu's mneejxũhwe jĩte', teeçx vxyu's jxũna kũhtx. ");
INSERT INTO pbb_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Aça' Jesusa' thegçxa' na'wẽk pẽjx: —¿Kiim dxi'pa's ki'pnina, sa' kiim yase's fxi'jnina naa vxyute'? jĩte': ");
INSERT INTO pbb_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","—Cesar dxi'pa's ji'pha', sa' txajx yase's fxi'jni' jĩnatx pas. Txajũ' Jesusa' na'wẽk jxkaah: —Cesar jĩ's Cesara's dukhwa'ja', sa' Dxus jĩ's Dxusna dukhwa'ja' jĩte', ");
INSERT INTO pbb_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","paapẽysawe'sxa' wala kuh yajkxna neeyũutx, sa' txajũ u'jtx. ");
INSERT INTO pbb_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Txãa entey saduceowe'sx maaíi yu' Jesusa's thegya' pa'jtx. Nasa' uuyã'jçxa' peena yu' ĩtxi yuuwa'jsameeta' jĩna we'wesatx yu' txãa saduceowe'sxa'. Txãasa na'wẽtx paapẽjx: ");
INSERT INTO pbb_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","—Kaapiya'jsa, meen peeta'sx. Moises we'weçxa': Maa piçthẽ'jwa luuçx ji'phumey nyu's nvxihtçxa uute', uusáa nyakha' txãa u'y neeyũusáa yakh kabawa'jsa', aça' txãate luuçxa' uusáa nçxi'k na'wẽ neeyũuna jĩ'k. ");
INSERT INTO pbb_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Aça' kwe'sxa' jiitha'w siete piçthẽ'j pxakhtxi u'pu'. Aça' nyafxtewe'sxa' kabaçxawa luuçx ji'phumey uuk, txajx nyua's nyakh e'stewe'sx jĩi nvxihtçxa. ");
INSERT INTO pbb_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Aça' nyakh e'stewe'sxwa txã'wẽyçxáa nyakh tekhtewe'sx jĩi nvxihtçxak uu, sa' txã'wẽçxaçxáatx yũu siete pxakhsay. ");
INSERT INTO pbb_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Aça' nmehte' txãa u'ywa uuk. ");
INSERT INTO pbb_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Txã'wẽ uuçxawa ki' ĩtxi yuu ente', ¿maa yakh isa nyu yuuwa'jsakx? txã'wẽ kxaz pxakhsatxíi txãa u'yçxaçxáa iimi'sa' na' jĩte', ");
INSERT INTO pbb_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Jesusa' na'wẽk pta'sx: —I'kwe'sxa' Dxus librute fxi'jni ũsa' txã' isa yuhna sũju'çmeei'kwe, sa' Dxusa' kĩjxa'wa jxuka ãjana sũju'çwameei'kwe. Txãasa jxpubana ũsi'kwe. ");
INSERT INTO pbb_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Uusaawe'sxa' ki' ĩtxi yuuçxa' peena yu' kabana fxi'zewa'jsameeta'. Txãawe'sxa' cielute ũssa Dxus angeleswe'sx na'wẽsaçxáa yã'tha'. ");
INSERT INTO pbb_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Nawa uuçxa ki' ĩtxi yuuwa'ja's i'kwe'sxa' iilẽeymeewá'kwe Dxusíiwa na'wẽk we'we: ");
INSERT INTO pbb_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Abrahan, Isaak, Jakob txãawe'sx Dxusthu adxa' jĩ'k. Uuçxawa ki' ĩtxi yuusaawe'sx Dxusthu jĩçxak txã'jĩ'. ");
INSERT INTO pbb_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Txã'wẽ wẽse'jçxa', wala kuh yajkxna neeyũutx txã'wẽ zhiçxkwe Jesus kaapiya'pha'ga. ");
INSERT INTO pbb_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Jesus txã'wẽ saduceowe'sxtxi sxuuna' vxitni's fxariseowe'sx jiyuçxa', pkhaakhetx. ");
INSERT INTO pbb_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Sa' Dxus ley kaapiya'jsa teeçxsa' Jesus tasxte utxaak pẽjxya' ewmée pastewa jiyu wẽeçxa. Sa' na'wẽk pẽjx: ");
INSERT INTO pbb_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","—Dxus leya' maatewa jxthaakwesa' ¿maana? jĩte', ");
INSERT INTO pbb_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Jesus pasçxa': —Dxusa's ũusuh jxuka yajkxçxa txãa yuuçxáana selpiina fxi'zewa'ja' bagaçxte yuhwa txutemée uu entepkaçx. ");
INSERT INTO pbb_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Naa txã'wẽ jxthaakwesa'. ");
INSERT INTO pbb_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","E'stewe'sxa' txã'wẽydxi'a': Peekíi ma'wẽga ya'peeygãja', txã'wẽy mpeeygãh vxite nasatxwa. ");
INSERT INTO pbb_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Dxus jxkaahni naa e'zsaçxáa Moises leytxi jxuka ãhsata', txã'wẽy Dxus yuwe pta'sxsawe'sx kaapiya'jnitxwa jxuka jĩk. ");
INSERT INTO pbb_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Fxariseowe'sx pkhaakheçxa kxtee nee ũsiyna, ");
INSERT INTO pbb_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","Jesusa' na'wẽk pẽjx: —Kristo' ¿kimna sũju'kwe i'kwe'sxa'? ¿Kiim nçxi'kna sũju'kwe? jĩte', txãawe'sx pasçxa': —Davxid nçxi'kna sũju'tha'w jĩte', ");
INSERT INTO pbb_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Jesusa' na'wẽk we'we: —Txã'wẽte', ¿ma'wẽçxaga Davxida's Dxus Espiritu kaayaki'the' Kristo's we'weçxa' na'jĩ: ");
INSERT INTO pbb_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Adxna jxpe'jsa Kristo's Dxusa' na'jĩk: Adx pukate paçu ju'gte mkaaçx, Idxna açesatx idxçxaçxáana nwẽese'jwa'ja's vxitna jxã'phkaçx jĩk. ");
INSERT INTO pbb_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Txã'wẽ Davxidíiwa Kristo's we'weçxa': Adxna jxpe'jsa jĩnak kxsusu' aça' Kristo' ¿ma'wẽçxa Davxid nçxi'k yuukx? jĩte', ");
INSERT INTO pbb_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","kim yuhwa teeçx yuweçxáawa pasya' ãjameeta', sa' txajũyã'ja' peena yu' pẽjxmeeta' kim yuhwa. ");
INSERT INTO pbb_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Txajũ' Jesusa' na'jĩnak we'we txãa yakh u'jusawe'sx petx vxite nasa yã'jçxa: ");
INSERT INTO pbb_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","—Ley kaapiya'jsa vxite' fxariseowe'sx txãawe'sxa' Moises leya's wala ew jiisa txãa leya's nwẽese'jwa'ja's jxkaahsatha'w sũju'tx. ");
INSERT INTO pbb_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Txã'wẽyã'the', i'kwe'sxa' mwẽese'jwe ley ewsa ma'wẽ jxkaathe' txãa yu'sa' jxuka. Nawa txãawe'sx na'wẽ yu' yũuna fxi'zenuwe. Txãawe'sxa' nasa yuutxi' leya's nwẽese'jwa'ja's jxkaahçxawa txãawe'sx yu' leya's nwẽese'je'çmeeta'. ");
INSERT INTO pbb_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Tũ'swa'j iiméh wala duhsa pheu'ju'tx txã'sa' kim yuhwa çxhãçxhameena. Txã'wẽsa'stxi nasatx ktũ'se'je', nawa txãawe'sx yu' le'çxkuẽ kuseteçxáa yuhwa at pu'çxhi'çmeeta'. ");
INSERT INTO pbb_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Maawa uykahn sũhçxa iiwejçx iiwejçx yajkxna ãate yu' kĩhwa yu'tx Dxusna yaakiçtha'w jĩna. Txãasatx Dxus jxkaahni's eçte fxi'jçxa kajate akhçxa dxiktheuy vxite' kusesu tudçxa fxi'ze'. Sa' nasa jiyuni fxi'zeya' sũhçxa athni ropawa thaakwe jxu'jsa iijxũçxatx fxi'ze'. ");
INSERT INTO pbb_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Fxiesta yat-su pi'kxni u'jçxa', kaçxni wejx ewsaçxáanatx pakwe' iiwejçx yajkxna. Sa' judiuwe'sx pkhaakhenisuwa txã'wẽytxi yu'. ");
INSERT INTO pbb_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Klxiikhunsu msuuwa nasatx wala ewçxáa we'wena weçxaa jxthãasnatx pekũju', kaapiya'jsa jĩna kxsus jxthãasna. ");
INSERT INTO pbb_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Nawa i'kwe'sxa' txã'wẽ kaapiya'jsa jĩna kxsus jxthãasna fxi'zenuwe. Txãa pa'gatey i'kwe'sxa' kaapiya'jsamée maa yakhwa jxuka pxakhsaçxáai'kwe, naasáa kaapiya'jsa' teeçx yuuçxáa ji'phi'kwe txã' Dxus kaahni Kristo'. ");
INSERT INTO pbb_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","I'kwe'sxa' naa kiwetewe'sxtxi' kim yuhnawa tata jĩna kxsusnuwe, txãa pa'gatey teeçx Tata yuuçxáa ji'phi'kwe txã' cielute ũsa'. ");
INSERT INTO pbb_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Sa' npiiçthẽ'j jxpe'jsa jĩna kxsus jxthãasnawa fxi'zenuwe, txãa pa'gatey Npiiçthẽ'j jxpe'jsa' teeçx yuuçxáa ji'phi'kwe txã' Kristo'. ");
INSERT INTO pbb_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Maatxwa selpiina fxi'zeçxa yuuçxáa jxtuhthesa yuune'kwe. ");
INSERT INTO pbb_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Txã'wẽme', maawa peekíiçxáa walasath sũhna iiwejçx iiwejçx yaakxsa' ãhmeekuẽsa yuuna, nawa ãhmeekwesath sũhna fxi'zesa' walasa yuuna. ");
INSERT INTO pbb_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Ley kaapiya'jsa vxite' fxariseowe'sx ãateçxáa ew we'weçxa' ũuste yu' ewmeeçxáa yaakxsa, i'kwe'sx yakha' seena' yuh ũukhũukha', txã'wẽ Dxus jxkaahnite u'kawa'ja's apha'i'kwe maawa u'kakahmén. Sa' vxitesatx ka'ga'jmeeçxa', i'kwe'sxçxáa yuhwa u'kaçmeei'kwe, txãa pa'ga ũukhũukha'. ");
INSERT INTO pbb_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Ley kaapiya'jsa vxite' fxariseowe'sx ãateçxáa ew we'weçxa' ũuste yu' ewmeeçxáa yaakxsa, i'kwe'sx yakha' seena' yuh ũukhũukha'. Vxiudawe'sx yattxi kusa'jçxa txãa kusa'jnitx kaapeçxkana'jya' sũhçxa wala jxu'j lisa'i'kwe. Txã'wẽ yũupa'ga i'kwe'sxa' jxthaakwe Dxus kastigãyni yuune'kwe. ");
INSERT INTO pbb_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Ley kaapiya'jsa vxite' fxariseowe'sx ãateçxáa ew we'weçxa' ũuste yu' ewmeeçxáa yaakxsa, i'kwe'sx yakha' seena' yuh ũukhũukha'. Mtee mteewa pekũju'i'kwe nasatx i'kwe'sx ju'gu tuphy wẽeçxa i'kwe'sx kaapiya'jni's pta'sxna. Nawa nasatx knayçxa', txãa nasatxi' i'kwe'sx ũswa'j infxiernotey nvxiit-sa i'kwe yu'. ");
INSERT INTO pbb_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","I'kwe'sx yakha' seena' yuh ũukhũukha', jiimeeçxa na'jĩna i'kwe kaapiya'ja' naa pa'ga: Puutx we'weni's kxtey yu'nja jĩçxa dxuus yata'sçxáa kxsusna jurãyni's kxtey yuumeetewa, kĩh yuumeena. Nawa dxuus yatte vxyuu beja's kxsusna jurãyni's yuuçxá' kxtey yuuwa'j yuja' jĩ'i'kwe. ");
INSERT INTO pbb_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Jiimée luuku we'wesa, Dxus dxi'pte' ¿kĩh wejx jxthaakwe ewsakx, vxyuu beja' meeçxa' dxuus yata'? E'zíi ¿Dxus jĩiçxaçxáa meetxna'? ");
INSERT INTO pbb_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Txã'wẽy na'jĩ'i'kwe: Dxuus yatte altala'sçxáa kxsusna jurãynisa's kxtey yuumeetewa, kĩhwa yuumeena. Nawa altalte kabwa'ja's kxsusna jurãynisa's yuuçxá' kxtey yuuwa'j yuja' jĩ'i'kwe. ");
INSERT INTO pbb_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Jiimée luuku we'wesa, Dxus dxi'pte' ¿kĩh wejx jxthaakwe ewsakx, dxuus yatte altala' meeçxa' altalte kabnisa'? E'zíi ¿Dxus jĩiçxaçxáa meetxna'? ");
INSERT INTO pbb_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Maawa dxuus yatte altala's kxsusna jurãysa' txã'sçxáana kxsussa yu'çme'. Altalte kabnisa'swa jxukak kxsussa yu'. ");
INSERT INTO pbb_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Txã'wẽy maawa dxuus yata's kxsusna jurãysa' txã'sçxáana kxsussa yu'çme'. Kxtee ũssa Dxus ĩtxisa's kxsussak yu'. ");
INSERT INTO pbb_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Txã'wẽy cielu's kxsusna jurãysa' cieluçxáana kxsussa yu'çme'. Dxus jxkaahna ũsni's jxukak kxsussa yu' petx Dxus yã'jçxa. ");
INSERT INTO pbb_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Ley kaapiya'jsa vxite' fxariseowe'sx ãateçxáa ew we'weçxa' ũuste yu' ewmeeçxáa yaakxsa, i'kwe'sx yakha' seena' yuh ũukhũukha'. I'kwe'sx ũusteçxáa yajkxçxa kaapiya'jçxa', putatxhã' ma'k yuu meeçxa' me'sukwe ma'k yuu komino ma'k yuu txã'wẽsatx diez eç uhdeçxa' teeçx eça's kutxi'ji'kwe Dxus jĩ' jĩna. Nawa Dxus ley jxkaahçxa': Dxus dxi'pte ew fxi'zena, vxite nasatx peeygãhna, Dxusa's ũusuh jxuka yajkxna txã'wẽ yũuwa'ja' jĩ'k txãa isa jxkaahni yu's kxtey yu'çmeei'kwe. Nawa na'wẽ Dxus jĩ' jĩ'i'kwe txãa yu's nvxiitwa'j yu'me'. ");
INSERT INTO pbb_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Jiimée kaapiya'jsa, fxĩsx le'çxkwesa yuutxi' a'çha'i'kwe, nawa kamelxo walasa yu'sa' uymeeçxa jxkhẽeje'i'kwe. ");
INSERT INTO pbb_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Ley kaapiya'jsa vxite' fxariseowe'sx ãateçxáa ew we'weçxa' ũuste yu' ewmeeçxáa yaakxsa, i'kwe'sx yakha' seena' yuh ũukhũukha'. Waso ma'k yuu meeçxa' plaatu ma'k yuu txã'wẽsatx ekaju yu' wala ew pkhi'khi'i'kwe, nawa dxiikhẽ yu' vxite jĩitx pesweeçxa abnisaçxáa uta ji'phta'. ");
INSERT INTO pbb_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Fxariseo jiyu'çmeeg. Dxiikhẽ khuẽ'y pkhi'kxwa'ja' waso vxite' plaatutx, kxah ekajuwa jxuka ate yuuna. ");
INSERT INTO pbb_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Ley kaapiya'jsa vxite' fxariseowe'sx ãateçxáa ew we'weçxa' ũuste yu' ewmeeçxáa yaakxsa, i'kwe'sx yakha' seena' yuh ũukhũukha'. Uusáa pedani's kajkwekhẽ pçxiime'the', zhiçxkwek vxya'. Nawa dxiite yu' uusáa dxi'thçxáa utak kazx putana ũsu'. ");
INSERT INTO pbb_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","I'kwe'sxa' txã'wẽysa i'kwe. Ãakhẽ yu' nasaa dxi'pte wala ew na'wẽ thegu'i'kwe. Nawa ũuste yu' kazx ewmée yaakxnisaçxáa uta ũsa'. ");
INSERT INTO pbb_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Ley kaapiya'jsa vxite' fxariseowe'sx ãateçxáa ew we'weçxa' ũuste yu' ewmeeçxáa yaakxsa, i'kwe'sx yakha' seena' yuh ũukhũukha'. I'kwe'sxa' ewkuẽ pheu'jna nes yu' Dxus yuwe pta'sxsa vxite' nasa ewsa txãawe'sxtxi pedaní kafxsu. ");
INSERT INTO pbb_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Sa' na'jĩ'i'kwe: Kwe'sx yaçgawe'sx fxi'zeni ente kwe'sx ũswaça', kwe'sxa' ikhwa'jme'ntka'w yu' Dxus yuwe pta'sxsatxi' jĩ'i'kwe. ");
INSERT INTO pbb_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","I'kwe'sxa' Dxus yuwe pta'sxsawe'sxtxi ikhsa nwe'sxi'kwe, txãasa i'kwe txãa ikhsawe'sxtxi' kwe'sx ji'j yaçgawe'sx jĩna we'we'. ");
INSERT INTO pbb_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","I'kwe'sx yaçgawe'sx kĩhne'ta yũusa yu', aça' i'kwe'sxwa txã'wẽy yũuna nes yuune'kwe. ");
INSERT INTO pbb_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Ul weeswée seena'sa ji'j, ¿ma'wẽ yũuçxa infxiernote kastigãywa'the pa'jmée yuuki'kwe? ");
INSERT INTO pbb_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Txã'wẽsa yã'ji'kwe na' i'kwe'sxa' maaíitxi' kluuskhẽ ki'pna ikhna, vxitetxi's judiuwe'sx pkhaakheni yaçu pãpana, vxitetxi's ahçeçxa çxhab iisa ikhya' pakwena nes yuukahn adxa' kaajxa'wath Dxus yuwe pta'sxsa vxite' kĩhtewa wala jiisa vxite' kaapiya'jsa txãawe'sxtxi. ");
INSERT INTO pbb_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Txã'wẽ Abela's ikhnijũjx nasa ewsatx ikhya' takhçxa Berekias nçxi'k Zakariasa's Dxus altal pukate ikhi'kwe txãa entepkaçx ikhnisatx i'kwe'sxçxaçxáa yuuwesa yuune'kwe. ");
INSERT INTO pbb_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Isath we'we' nyafxiitey ikhnisatxi's nasa naa ensuwe'sx txã'wẽ yuuwesa yuutxna. ");
INSERT INTO pbb_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Jerusalente nasa, i'kwe'sxa' Dxus jxkaahnisa txajx yuwe's pta'sxsawe'sxtxi ikhe'i'kwe, maaíitxi' kwet wãatatahna. Maz uswa pkhakhçxa nwe'we wẽeth i'kwe'sx luuçxtxi, atalxwa ma'wẽga luuçxkuẽtxi's fxuu ku'ta dxiite ãsxi' txã'wẽy, nawa wa'li'kwe. ");
INSERT INTO pbb_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Mwẽese'jwe: i'kwe'sx ũsni' thegnimée neeyũuna. ");
INSERT INTO pbb_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Na'jĩ'th na': peena yu' adxa's uymeene'kwe, Dxus tasxu yuusa wala ewsa yuja' jĩna we'wewa'j en ãhpkaçx. ");
INSERT INTO pbb_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Dxuus yatu kasehçxa Jesusa' u'jweçpkaçxha', txãa yakh u'jusawe'sxa' utxaaçxa we'wetx dxuus yata's pta'sxna. ");
INSERT INTO pbb_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Aça' Jesusa' na'wẽk pas: —Txã'wẽ yuh seena' zhiçxkwe wala'. Nawa na'jĩ'th na': jxuka pçuuna, aça' txãa yattewe'sx teeçx kwetçxáa yuhwa kẽese'jnimeesa yu' neeyũumeena jĩk. ");
INSERT INTO pbb_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Txajũ' Oliwos vxiçnatx u'j. Kxtee pa'jçxa Jesus kaçxçxa u'pte', txãa yakh u'jusawe'sx maaíi yu' na'jĩnatx we'we paaçte: —Meen peeta'sx, ¿bagaçx txã'wẽ jxuka pçuukx? Sa' iidx kĩiwa'j en vxite' naa kiwe pçuwa'j en ãjaçte', ¿kĩh seena'sa vxyaakx? jĩte', ");
INSERT INTO pbb_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Jesusa' pta'sxku: —Mpa'yajkxwe, i'kwe'sxtxi kaypuba'jwe'sxte. ");
INSERT INTO pbb_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Txã'wẽme', wala pa'jatxna adx yase's kxsusna na'jĩna: Dxus kaahnisa Kristoth jĩtxna, sa' txã'wẽ yũuçxa wala kaypuba'jatxna ĩsxiina. ");
INSERT INTO pbb_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","I'kwe'sxa' wẽse'jene'kwe gweçxa msuu msuuwa u'pa' jĩni. Txã'wẽ yũutewa i'kwe'sxa' ũukhnuwe, txã' nmeh en yu' me'. ");
INSERT INTO pbb_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Gobierno' vxite kiwete gobierno yakh puiitxna, naapkaçxha' puutx jxu'j kiwejũ pwe'sxwa puiitxna. Txã'wẽ mtee mteewa jxuka gweçxa kiiteena. Sa' wẽje enwa pa'jana, wee seena'sawa pa'jana, ehdwa seena'sa u'jwetxna mtee mteewa. ");
INSERT INTO pbb_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Txã'wẽ seena'sa pa'jçxawa txãa yu' nyafxte nxusya' takhnisaçxáa yuuna. ");
INSERT INTO pbb_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Txajũ' i'kwe'sxtxi uweçxa dukhetxna pãpana ikhkahn, sa' naa kiwete mteewe'sxwa jxukaysa açetxna adx jxkaahni's nwẽese'pha'gaçxáa. ");
INSERT INTO pbb_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Txã'wẽ yũute', maazkuẽesawa Dxus tasxu txuteetxna, sa' puutx yahçena vxitesa uweçxa ikhwa'ja's vxitutxna. ");
INSERT INTO pbb_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Wala ĩsxiisa vxyaatxna, adxa' Dxus kaahni yuhth jĩna nasa maazkuẽesatxwa ĩsxiijatxna. ");
INSERT INTO pbb_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Sa' ewmée yũuna fxi'zewa'jçxáa txakwe wala pa'the', puutx ya'peeygãhna fxi'zewa'j yu'sa' ivxiitutxna maazkuẽesawa. ");
INSERT INTO pbb_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Nawa uu entepkaçx Dxus yakh txutemée fxi'zesa' ewte neeyũutxna. ");
INSERT INTO pbb_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Naapkaçxha' Dxus jxkaahwa'ja's pta'sxnisa' maa kiwetewa jxuka pta'sxni yuuna mteewe'sxwa jxuka jiyukahn. Txã'wẽ yũunijũ nmeh ensa pa'jana. ");
INSERT INTO pbb_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Na'wẽ yũuwa'ja's jxpa'yakx lẽeyçxa jii mfxi'zewe Dxus yuwe pta'sxsa Daniela' pta'sxna fxi'kh dxuus yatte kazx ewmée yũuna pa'jwa'ja's. Aça' txã'wẽ seena' kazxsa pa'jçxa dxuus yatte u'kaçte uyçxa', ");
INSERT INTO pbb_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Judea kiwesuwe'sxwa jxuka ũphna u'jwene'kwe vxiç walasu ũsya'. ");
INSERT INTO pbb_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Sa' ẽe yat-su ũssawa sa'jçxa kĩhçxáanawa kutxi'jwa'j en ji'phumeetxna. ");
INSERT INTO pbb_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Txã'wẽy mjĩi ehsu u'jusawa txajx atxha's nikxya' yatna u'jwa'j ençxáa yuhwa ji'phumeetxna. ");
INSERT INTO pbb_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Txãa ente' u'ywe'sx nasa ji'phsa meeçxawa luuçx ãpãkuẽ ji'phsawe'sxa' wala yuh pxthaa yuutxna. ");
INSERT INTO pbb_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","I'kwe'sxa' Dxusa's mpẽjxwe txã'wẽ nus ente meeçxawa jxkaase ente ũphna u'jwa'j yuukahmén. ");
INSERT INTO pbb_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Txã'wẽ txãa ente' seena' yuh wala nxuswa'j yuuna. Naa kiwe's pheu'jiyna bagaçxte yuhwa txã'wẽsa yu' iiu'pume', sa' txã'wẽsa skhẽwniijũyã'ja' peena yu' u'pumeena txã'wẽysa yu'. ");
INSERT INTO pbb_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Dxusa' en txã'wẽ seena'sa's txaçxmée vxitmeete yu', kim yuhwa ĩtxi neeyũumeetxna. Nawa txajx nasa txhitxhnisatx peeygãhçxa, en txã'wẽ seena'sa's txaçxmeeçxáa vxituna. ");
INSERT INTO pbb_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Maawa i'kwe'sxtxi we'weçxa', mthegwe Kristo ayte ũsa' jĩtxna, meeçxawa kxtee ũsa' jĩtxna, nawa txã'jĩni's nwẽese'jnuwe. ");
INSERT INTO pbb_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Txãa pa'gatey wala ĩsxiisa pa'jatxna, adxa' Dxus yuwe pta'sxsath sa' Dxus kaahnisa Kristoth jĩtxna, txã'wẽ kim yuhwa ãjanimeesa's kaavxya'ja'jatxna kaypuba'j wẽeçxa. Txã'wẽ yũuçxa maaíitxi' kaypuba'jatxna Dxus txhitxhnisa yuhtxwa. ");
INSERT INTO pbb_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Txã'wẽ yũuwa'ja's pta'sxyã'th i'kwe'sxtxi dxiikhẽy. ");
INSERT INTO pbb_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Txãa pa'ga nwẽese'jmeene'kwe makwe txã'wẽ kxtee ũsa' nasa u'pnimeete jĩtewa meeçxa' ay dxiite ũsa' jĩtxna. ");
INSERT INTO pbb_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Txãa pa'gatey Dxus Nçxi'k Nasa Yuusáa kĩi ente', kpi'sxwa ma'wẽga sek kãanijũ kwehneçxa' sek khẽenijũwa vxya' txã'wẽyçxáa yuuna naa dudte jxukaysa dxi'pte. ");
INSERT INTO pbb_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Kakwe uuniisa mkaa ũstewa kxtee pkhaakhetxna mẽewẽjxa' ũ'ya'. ");
INSERT INTO pbb_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Txã'wẽ seena' nxuswa'j en skhẽuuçpkaçxha', seka' çxhi'dxina, aça' a'te' kweethmeena. Naapkaçxha' estrelxa ũsxitxna, ẽe walasu kĩh seena'sawa jxuka kẽese'jni yuutxna. ");
INSERT INTO pbb_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Txã'wẽ yũunijũ', Dxus Nçxi'k Nasa Yuusáa kĩiwa'ja's kaajiyu'jsa vxyaana cieluju, aça' naa kiwete nasa maazkuẽesawa ũ'netxna Dxus Nçxi'k Nasa Yuusáa txã'wẽ cieluju tãaph pxãhte seena' zhiçxkwe vxyaana yuhte uyçxa. ");
INSERT INTO pbb_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Sa' txajx angeleswe'sxtxi jxkaajana seena' sus tujkaçxa txajx txhitxhnisatxi' pkhakhkahn naa kiwetewe'sx mtee mteewe'sxwa jxukaysatx. ");
INSERT INTO pbb_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Naa ejemplo's peçxkananuwe: higwera fxtũu tasxa' eç ubuçxa ki' u'se yeeçuçte uyçxa', yũnya'watewa jiyu'i'kwe. ");
INSERT INTO pbb_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Txã'wẽy na'wẽ seena'sa vxyaaçte uyçxa', jii mfxi'zewe, pçuwa'j en utxaaçte txã'wẽ yuuna. ");
INSERT INTO pbb_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Isath we'we', naa ensu nasa' uumey txã'wẽ seena'satx uyuune'kwe. ");
INSERT INTO pbb_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Cielu naa kiwe jxuka skhẽuutxna, nawa adx we'weni yu' kxtey yuumey yu' skhẽwmeetxna. ");
INSERT INTO pbb_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Nawa kĩh ente kĩh orate txã'wẽ yũuwa'j yu'sa' kim yuhwa jiimeeta', cielute angeleswe'sx Dxus Nçxi'k txãawe'sx yuhwa, naasáa Dxus yuuçxáa jiia'. ");
INSERT INTO pbb_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Noe entewa ma'wẽga yuu txã'wẽyçxáa yuuna, Dxus Nçxi'k Nasa Yuusáa kĩi entewa. ");
INSERT INTO pbb_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Txãa ensu nasa' ĩkh utameyna yu' wala weçxana ũsu'tx ũ'na tudxna kabana Noe arkate u'kapkaçx. ");
INSERT INTO pbb_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Sa' Dxus kastigo's jiimée ũsíi, ĩkh utate jxuka pçuuçyã'jçxaçxáatx jiyu, txã'wẽyçxáa jiyumeetxna Dxus Nçxi'k Nasa Yuusáa kĩi entewa. ");
INSERT INTO pbb_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Txãa ente' e'z piçthẽ'j mjĩina ih ũsutxna, aça' teeçxsa's jxũna u'jni yuuna, nawa vxite's nvxiitni yuuna. ");
INSERT INTO pbb_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Txã'wẽy e'z u'y ih ũ'khna ũsutxna, aça' teeçxsa's jxũna u'jni yuuna, nawa vxite's nvxiitni yuuna. ");
INSERT INTO pbb_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","I'kwe'sxa' jxpa'yakx meswe. Txã'wẽme', kĩh ente kĩh orate Dxus Nçxi'k kĩiwa'jsatewa jiimeei'kwe. ");
INSERT INTO pbb_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Nawa jxpa'yakx meswe. Yat namuwa ma'wẽ peswée kĩh orate yuhtewa jiyuçxa' dehmée jxpa'yakx ũythasna u'pukx yatte pesweekahmén, txã'wẽy myũuwe. ");
INSERT INTO pbb_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Txãa pa'ga i'kwe'sxwa jxuka pheu'jçxa meswe. Txã'wẽme', yajkxmée ũsiyna Dxus Nçxi'k Nasa Yuusa' kĩhçxáa yuuna. ");
INSERT INTO pbb_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Selpisáa ¿maa ewki patron neewe'weçxa nvxihtte kxte yattewe'sxtxi kwẽeje'jmée sã'jĩwa'jsa? ");
INSERT INTO pbb_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Patron neewe'weçxa nvxiitni's jxuka kxtey yuuna ũste patrona' thegna pa'the', txãa selpisáa yakha' wala yuh weçxa yuhna. ");
INSERT INTO pbb_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Isath we'we': txã'wẽ yũusa's patrona' txajx ji'phuni's jxuka neewe'weçxa nvxiituna. ");
INSERT INTO pbb_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Nawa selpisáa ewmeesa' patron pa'jya' jxthẽeyuuna sũhçxa ");
INSERT INTO pbb_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","kxte vxite selpisaatx pkxuuna tũusaawe'sx yakh tudxna ũ'na yũuna ũste', ");
INSERT INTO pbb_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","yajkxmée ũsiyna patrona' kĩh ente kĩh oratewa pa'jçxáa yuuna. ");
INSERT INTO pbb_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Sa' seena' wala nxus nxus kastigãina txã'wẽ yuwejuçxáa ew we'weçxa' ũuste yu' ewmeeçxáa yaakxsawe'sxtxi na'wẽy. Txajũyã'ja' txãa selpisáa ewmeesa' seena' wala pebeena ki'thtxi ksuusu'jna. ");
INSERT INTO pbb_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Dxus jxkaahwa'j en ãhte', na'wẽ yuuna: Diez kna'sawa ma'wẽta lampara aceite awniisa's atçxa boda yatna u'j novxio's jxpa'gaya', txã'wẽy yuutxna. ");
INSERT INTO pbb_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Txãa kna'sawe'sx tahçsa' jxpa'yakxmeeçxa pheu'jmeetx u'j, sa' vxite tahçsa' jxpa'yakxçxa jxuka pheu'jçxatx u'j. ");
INSERT INTO pbb_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Tahçsa' ew ũus yajkxmeeçxa', lampara yu'sa' jxũçxa u'jçxawa aceite yu' jxũmeetx u'j pçuute ki' awwa'j. ");
INSERT INTO pbb_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Nawa vxite tahçsa' aceite jxũçxatx u'j lamparatewe'sx pçuute' ki' awwa'j. ");
INSERT INTO pbb_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Novxio pa'jya' jxthẽeyuute', txãawe'sxtxi wala deewẽe yuute' dehtx. ");
INSERT INTO pbb_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Txajũ' kuspxãh yuuçte', pthũusek na'jĩna sus we'weni: Novxio yujxã'ja', aça' jxpa'gaya' myuhwe jĩni. ");
INSERT INTO pbb_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Naapkaçxha' kna'sawe'sx kxazíi kiiteçxa lampara's pheu'jtx. ");
INSERT INTO pbb_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Aça' tahçsa jxpa'yakxmée u'jsawe'sxa' vxite tahçsatx aceite thãastxi: Le'çxkuẽçxáawa peesune'kwe. Txã'wẽme', kwe'sx pki'tanisa' ũçxhaça' jĩnatx we'we. ");
INSERT INTO pbb_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Nawa kna'sawe'sx jxpa'yakx pheu'jçxa u'jsa' na'wẽtx pas: Ũsme'nja'w. Txã'wẽme', kwe'sx jĩi yuhwa ãhmée ji'ptha'w, aça' i'kwe'sxtxi ũswa'j yu' wejx ãhmeena. Wejx yuuwa me'jwe weyya' jĩ'tx. ");
INSERT INTO pbb_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Txã'wẽ tahçsa jxpa'yakxmeeçxa aceite weyya' u'jweçpkaçxha', ptamusá novxio' pa'kh. Aça' jxpa'yakx ũythãssawe'sxa' boda yatte novxio yakh u'kaçpkaçxha', vxitxa's aphtxi. ");
INSERT INTO pbb_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Txãa e'suyã'jtx vxite kna'sawe'sx kũhçxa: Meen phaade jĩna we'we. ");
INSERT INTO pbb_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Nawa pasçxa': Isa, adxa' i'kwe'sxtxi' jiimeeth jĩk. ");
INSERT INTO pbb_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","I'kwe'sxa' jxpa'yajkx meswe. Txã'wẽme', kĩh ente kĩh orate Dxus Nçxi'k Nasa Yuusáa pa'jwa'ja's jiimeei'kwe. ");
INSERT INTO pbb_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Teeçx piçthẽ'jwa ma'wẽga vxite kiwen u'jweççxa', txã'sna selpisaawe'sxtxi pa'yaçxa txajx vxyu's neewe'weçxa ũsçxa u'j, txã'wẽ yũuna Dxus jxkaahwa'j en ãhte'. ");
INSERT INTO pbb_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Txãa piçthẽ'ja' selpisáa teeçxsa's vxyu tahç milku ũs, sa' vxite's e'z milku ũs, sa' vxite's teeçx milku ũs, teeçxsa na'wẽçxah makwesa's sxiigmée iijxũya' ãjawa'jsatewa txakweçxáak ũsçxa u'j. ");
INSERT INTO pbb_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Teeçx selpisáa tahç mil vxyu jxpa'gasa', txãa vxyu's kmãaji'jçxa ki' vxite tahç mil íik ãh knay. ");
INSERT INTO pbb_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Txã'wẽy e'z mil jxpa'gasawa ki' vxite e'z mil íik ãh knay. ");
INSERT INTO pbb_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Nawa teeçx milçxáa jxpa'gasa' patron vxyu's kafxi'jçxa kiwetek pedáa. ");
INSERT INTO pbb_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Patrona' wala txaçxte ki' sxawedna pa'jçxa', txãa selpisaawe'sxtxi vxyu ũsni's ki' pẽjxku. ");
INSERT INTO pbb_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Nyafxte' tahç mil vxyu jxpa'gasa khuẽ'y utxaana kũhçxa ki' vxite tahç mil íik ãh kaasxwedu'j na'jĩna patrona's: Idxa' tahç milgu ũs, aça' ki' vxite tahç mil íith knay kmãaji'jçxa jĩte', ");
INSERT INTO pbb_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","patrona' na'wẽk we'we: Idxa' vxyu'sa' psuwmeeg wala ew kmãaji'j. Txã'wẽ le'çxkuẽçxáasanawa psuwmée kmãaji'pha'ga, wejx walasanawa neewe'weçxa iidx kusete nvxiitu'nja. Ãçxha' me'ka adx yakh weçxana ũsya' jĩk. ");
INSERT INTO pbb_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Txajũ' vxite selpisáa e'z mil jxpa'gasawa kũjk na'jĩna patrona's: Idxa' e'z milçxáag ũs, nawa txã'sa' kmãaji'jçxa ki' vxite e'z mil íith ãh knay jĩte', ");
INSERT INTO pbb_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","patrona' na'wẽk pas: Idxa' vxyu'sa' psuwmeeg wala ew kmãaji'j. Txã'wẽ le'çxkweçxáasanawa psuwmée ewgu kmãaji'pha'ga ãçxha' txãate jxthaakwe walasanawa nvxiitu'nja iidx kusete. Me'ka adx yakh weçxana ũsya' jĩk. ");
INSERT INTO pbb_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Txajũ' teeçx milçxáa jxpa'gasawa kũjk patrona's na'jĩna: Idxa' wala weesweetewa jiith, sa' iidx uuthasxmeesuwa jxukag pkhakhe' kĩhwa uhmeeçxawa. ");
INSERT INTO pbb_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Txãa pa'ga ũukhçxa iidx vxyu's jxaawthu kiwete pedaaçxa. Nawa ãçxha' dukheçthu idx makwene'ga ũs txã'sa' jĩte', ");
INSERT INTO pbb_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","patrona' na'wẽk pas: Idxa' seelpimée watxkuẽg. Adxa' txã'wẽ juuna'çxa kĩhwa uhmeeçxawa vxite jĩitx pkhakhsatewa jiith jĩ'g na', ");
INSERT INTO pbb_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","¿mjĩtega adx vxyu's bankoga jxaawmée txãate jxthaakwekuẽ nuypehnaçxa kaasxwedu'jya'? jĩçxa', ");
INSERT INTO pbb_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","kxtee ũssatx na'wẽk jxkaah: Txãa piçthẽ'j vxyu mil ji'phsa's kusa'jçxa diez mil ji'phsa's meswe. ");
INSERT INTO pbb_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Txãa pa'gatey ji'phsa's jweeíiçxáa jxthaakwe ũswa'ja' wala ji'phukahn. Nawa ji'phmeesa's jxuka kusa'jwa'ja' le'çxkuẽçxáa ji'phuni'swa. ");
INSERT INTO pbb_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Sa' txãa piçthẽ'j seelpimeesa's uweçxa ekaju çxhi'dx walate makhwe. Kxte' seena' yuh pebeena ki'thtxi ksuusu'jna ũswa'ja' jĩk. ");
INSERT INTO pbb_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Dxus Nçxi'k Nasa Yuusa' jxkaahsa yuuçxa angeleswe'sx ksxavxyte kĩhçxa txajx jxkaahwa'the kaçxhiina. ");
INSERT INTO pbb_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Txajũ' nasa' naa kiwete mtee mteewe'sxwa jxuka pkhaakhetxna txajx tasxte, aça' teeçxsa na'wẽçxah txhitxhçxa txudena, piisxáa-thegsawa ma'wẽga fxii txudé' piisxáa vxite' kaplatx txã'wẽy. ");
INSERT INTO pbb_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Sa' piisxaatxi' paçu ju'gu txahçxa', kaplatxi' jebu ju'gu txajana. ");
INSERT INTO pbb_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Txã'wẽ yũuçxa jxkaahsa' we'wena paçu ju'gu ũssatxi' na'jĩna: Adx Tata peeygãanisa, i'kwe'sxa' myuhwe txã'wẽ naa kiwe's vxitiyna i'kwe'sx jxkaahwa'j pheu'jni ũsa' txã'sna jxpa'gaya'. ");
INSERT INTO pbb_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Txãa pa'gatey i'kwe'sxa' adxa's sã'jĩ i'kwe wẽena u'jute'. Sa' yũ'wẽena u'jute', yusi'kwe. Nasa ekajuwe'sx na'wẽ u'jute', deewa'j pki'ji'kwe. ");
INSERT INTO pbb_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Athwa'j ropa ji'phmée u'jute', ropa ũsi'kwe. Uuya' ũste', thegya' pa'ji'kwe. Karcelte ũste', kxteewa thegya' pa'ji'kwe jĩte', ");
INSERT INTO pbb_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","nasa ew yũusa' na'jĩtxna: Idxa' ¿bagaçx wẽena u'jutetka'w uyçxa ũ' puuç? ¿Bagaçx yũ'wẽena u'jutetka'w tudxwa'j ũs? ");
INSERT INTO pbb_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Idxa' ¿bagaçx txã'wẽ ekajuwe'sx na'wẽ u'jute uyçxatka'w deewa'j pki'j? ¿Bagaçx txã'wẽ ropa ji'phmée u'jutetka'w ropawa ũs? ");
INSERT INTO pbb_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Bagaçx ãça'na ũstetka'w thegya' pa'j? ¿Bagaçx karcelte ũstetka'w kxteewa thegya' pa'j? jĩtxna. ");
INSERT INTO pbb_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Aça' jxkaahsa' na'wẽ pasuna: Isath we'we', adx yakhthẽ'jwe'sx makwe wala pxthaa ãhmeekwesaçxawa ayte ũsta' txãatx txã'wẽ yũusa' adxna pu'çxsaçxa i'kwe txã'wẽ yũu jĩna. ");
INSERT INTO pbb_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Txajũ' jebu ju'gu ũssatxi' jxkaahsa' na'jĩna we'wena: Adx tasxu mtxuteewe, i'kwe'sxa' ewmeetewe'sx yã'ji'kwe. Txãa pa'ga eçxthẽ'j jĩi eçxthẽ'j angeleswe'sx jĩi pheu'jni ũsa' infxierno ipx wala kxtee me'jwe jĩna jxkaajana. ");
INSERT INTO pbb_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Txã'wẽ adx wẽena u'jutewa, puuçmeei'kwe. Yũ'wẽena u'jutewa tudxwa'j ũsmeei'kwe. ");
INSERT INTO pbb_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Nasa ekajuwe'sx na'wẽ u'jutewa, deewa'j pki'jmeei'kwe. Ropa ji'phmée u'jutewa, athwa'j ũsmeei'kwe. Ãça'na ũstewa, thegya' pa'jmeei'kwe. Sa' karcelte ũstewa, kxteewa thegya' pa'jmeei'kwe jĩte', ");
INSERT INTO pbb_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","txãawe'sxa' na'wẽ pasutxna: Idxa' ¿bagaçx wẽena u'jutetka'w puuçmée? ¿Bagaçx yũ'wẽena u'jutetka'w tudxwa'j ũsmée? ¿Bagaçx ekajuwe'sx na'wẽ u'jutetka'w deewa'j pki'jmée? ¿Bagaçx ropa ji'phmée u'jutetka'w athwa'j ũsmée? ¿Bagaçx ãça'na ũstetka'w thegya' pa'jmée? ¿Bagaçx karcelte ũstetka'w kxteewa thegya' pa'jmée? jĩtxna. ");
INSERT INTO pbb_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Aça' jxkaahsa' na'wẽ pasuna: Isath we'we', naa nasa pxthaa ãhmeekuẽsatx kĩhte yuhwa pu'çxmeei'kwe na' adxna pu'çxsameeçxai'kwe txã'wẽ yuu jĩna. ");
INSERT INTO pbb_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Txãa pa'ga ew yũusame' infxierno ipx pçuwa'jmeete khẽeya' u'jwetxna, naapkaçxha' ew yũusawe'sxa' bagaçxtewa pçuwa'jmée ĩtxi fxi'zewa'ja's ji'phutxna. ");
INSERT INTO pbb_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Jesusa' txã'wẽ pta'sxna jxã'jçxa', txãa yakh u'jusawe'sxtxi na'jĩnak we'we: ");
INSERT INTO pbb_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","—I'kwe'sxa' jii i'kwe Paskua fxiesta ãjxa' e'z ençxáa yã'j peejxa', aça' txãa ente' Dxus Nçxi'k Nasa Yuusa's uweçxa dukhni yuuna kluuskhẽ a'kxçxa ikhkahn jĩk. ");
INSERT INTO pbb_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Txãa entey sacerdote npiiçthẽ'jwe'sx, ley kaapiya'jsawe'sx, judiu nthẽ'jsawe'sxa' pkhaakhetx sacerdote npiiçthẽ'j Kaifxas yat patxute, ");
INSERT INTO pbb_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","sa' txãawe'sx pwe'sx puutx we'wetx nasa jiyunimeete paaçte Jesusa's uweçxa ikhya'. ");
INSERT INTO pbb_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Txãasatx fxiesta ente yu' txã'wẽ ikhya'mée puutx we'we nasa wala suskahmen. ");
INSERT INTO pbb_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Txãa ensu' Jesusa' Betania çxhabte Simon wã'jy weeju katxhisa yattek ũsu'. ");
INSERT INTO pbb_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Aça' teeçx u'y utxaana kũjk aceite wẽt putasa's fxraskote uta awniisa wala pa'gasa's atçxa. Sa' Jesus kaçxçxa u'pte', txajx dxikthekhẽk jxuka aw. ");
INSERT INTO pbb_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Txã'wẽ yũuni's Jesus yakh u'jusawe'sx uyçxa', na'jĩnatx ũusçxa we'we: —¿Txakwe yuja' wala psuwmanx? ");
INSERT INTO pbb_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Txã'wẽ yũupkaçxte wejxwa pa'gate txweyçxa txãa vxyu's puuplesatx peeswaçne' wejx ew yu' jĩte', ");
INSERT INTO pbb_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Jesus wẽse'jçxa' na'wẽk we'we: —¿Kĩjkwe kuçx susu' naa u'ya's? Na'wẽ yũunisa' psuwnisame'. ");
INSERT INTO pbb_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Puuplesa' bagaçxtewa i'kwe'sx yakh nes yuutxna. Nawa adxa' i'kwe'sx yakh nes yuuwa'jsameeth. ");
INSERT INTO pbb_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Naa u'y adx kakwekhẽ aceite wẽt putasa's awku, nawa adx uute pedaawa'ja's pheu'jnaçxáak txã'wẽ yũu. ");
INSERT INTO pbb_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Isath we'we': Naa kiwete mtee mteewa Dxus yuwe's pta'sxna pekũhsa' naa u'y txã'wẽ yũuni'swa ja'da pta'sxni yuuna peçxkanamée jĩk. ");
INSERT INTO pbb_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Txajũ' Jesus yakh u'jusa docesatewe'sx Judas Iskariote yaasesa' sacerdote npiiçthẽ'jwe'sx yakh puutx we'weya' u'jçxa ");
INSERT INTO pbb_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","txãawe'sxtxi na'jĩk: —Jesusna uweçxa dukhte' ¿maz deweeki'kwe? jĩte', txãawe'sxa' treinta vxyutx deweya' neeyũu. ");
INSERT INTO pbb_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Txajũ' Jesusa's ma'wẽ yũuçxa txãawe'sx kusete dukhya' ãjawa'ja's wala pakwek. ");
INSERT INTO pbb_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Pan lewadura ji'phmée ũ'ni fxiesta en ãjaçte', Jesus yakh u'jusawe'sxa' txajx tasxte utxaaçxa na'wẽtx pẽjx: —Paskuate ũ'wa'ja's ¿mteega pheu'j jxthãasu'? jĩte', ");
INSERT INTO pbb_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","na'wẽk jxkaah: —Jerusalenna me'jwe, kxtee teeçx piçthẽ'ja's jii i'kwe txã'sna na'jĩne'kwe: Kwe'sxtxi kaapiya'jsa' na'jĩnak yuwe kaah: Adx uuwa'j en utxaak, aça' iidx yatte Paskua's yu'skhẽwya'wath adx yakh u'jusawe'sx yakh jĩne'kwe jĩte', ");
INSERT INTO pbb_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","txãa yakh u'jusawe'sxa' Jesus jxkaahni's kxtey yuutx, sa' ũ'wa'ja's pheu'jtx. ");
INSERT INTO pbb_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Txajũ' jxuka çxhi'dxiçte', Jesusa' docesawe'sx yakh kaçxku mesate ũ'ya'. ");
INSERT INTO pbb_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Sa' ũ'na u'pçxa', na'wẽk we'we: —Isath we'we', i'kwe'sx yakh u'jusa teeçxsa' adxa's açesawe'sx kusete dukhya'wa' jĩte', ");
INSERT INTO pbb_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","txãawe'sxa' wala nxusçxa paapẽjxtxi teeçx teeçxçxah: —¿Adx ma'th? jĩna. ");
INSERT INTO pbb_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Aça' Jesusa' pta'sxku: —Maa txã'wẽ adx yakh ja'daçxah kuse's akhena plaatukhẽ txãa txã'wẽ adxa's açesawe'sx kusete dukhwa'jsa'. ");
INSERT INTO pbb_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Dxus Nçxi'k Nasa Yuusa' ma'wẽ uuwa'jsatewa Dxus librute pta'sxi'k txã'sa' kxtey yuuya'wa'. Nawa adxa's açesawe'sx kusete dukhsa' ¡seena' yuh nxuste khẽjena! Txãa piçthẽ'ja' naa kiwete wejx yuuwa upxmeewaçne' wejx ew yu' jĩte', ");
INSERT INTO pbb_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Judasa' pẽjxku: —Meeçxa' ¿adxwá'ntkakx? jĩte', Jesus pasçxa': —Idxíig jĩk. ");
INSERT INTO pbb_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ũ'na u'pçxa', Jesusa' pana's jxpa'gana'wa Dxusa's weçxaçxa pe'ltedek, sa' txãa yakh u'jusawe'sxtxi ũsu'sku na'jĩna: —Mẽ'we, naa pana' adx kakwe na'wẽsa' jĩçxa', ");
INSERT INTO pbb_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","waso'swa jxpa'gana'wa Dxusa's weçxaçxa txãawe'sxtxi ũsku na'jĩna: —Jxukaysa mtudxwe naa wasotewe'sxa's. ");
INSERT INTO pbb_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Naa wasotewe'sxa' adx ee na'wẽsa'. Dxusa' maazkuẽesa pkaltxiwa khũkhçxa nwe'wewa'ja's vxitku, nawa adx eea's pkawçxa yuuçxáak txã'wẽ nwe'wewa'ja's vxit. ");
INSERT INTO pbb_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Nawa na'jĩ'th na': ãçxhũyã'ja' peena yu' tudxme'nja naa uwa yu'a's, naasáa adx Tata jxkaahwa'j enteçxáa yã'j ki' i'kwe'sx yakh pkhaakheçxa tudxi'nja jĩk. ");
INSERT INTO pbb_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Txajũ' Dxusna weçxana memna jxã'jçxa', u'jtx Oliwos thã'j vxiçna. ");
INSERT INTO pbb_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Aça' kxtee pa'jçxa', Jesusa' na'jĩnak we'we: —Naa kuste' i'kwe'sx jxukaysa adxçxáana nvxihtçxa txuteene'kwe. Txãa pa'gatey txã'wẽ yũuwa'ja's Dxus librute na'jĩ'k: Piisxáa-thegsa's ikhte', piisxá' jxuka ũphuutxna jĩ'k. ");
INSERT INTO pbb_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Nawa adxa' uuçxawa ki' ĩtxi yuuçxa' i'kwe'sx yaçte u'jwe'nja Galilean jĩte', ");
INSERT INTO pbb_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Pedro' na'wẽk pas: —Makwe vxite yu' idxçxáana nvxihtçxa txuteetewa, adx yu' txã'wẽ yũume'nja jĩte', ");
INSERT INTO pbb_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Jesus pasçxa': —Isath we'we', naa kuste atalx we'wemeyna idxa' Jesusa's jiimeeth jĩna tekh us ĩsxiijane'ga jĩte', ");
INSERT INTO pbb_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Pedro' na'wẽk we'we: —Makwe idx yakh ja'datey uuwa'jma'k kaseh, nawa idxa's jiimeeth jĩna yu' ĩsxiime'nja. Aça' txãa yakh u'jusawe'sx jxukaysa txã'wẽçxaçxáatx we'we. ");
INSERT INTO pbb_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Txajũ' Jesusa' txãa yakh u'jusawe'sx yakh Geçemaní yaasesate pa'jçxa', na'wẽk we'we: —Ayte mkaaçxwe, naapkaçxha' adxa' Tata yakh puutx we'weya' u'jweçthu jĩçxa', ");
INSERT INTO pbb_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Pedro vxite' Zebedeo nçxi'k e'zsatx pe'jçxak u'j. Sa' ũuste wala nxus ũusuthete', na'jĩk: ");
INSERT INTO pbb_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","—Txakwe wala pxthaa yuuçxa uuwa'ja's yajkxte', wala nxus yuja'. Aça' i'kwe'sxa' aytee neeyũuçxa dehmée jxpa'yakx me'pwe adx na'wẽy jĩçxa', ");
INSERT INTO pbb_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Jesusa' jxu'jmée u'jçxaçxáa txkaa pkipha weteçxa Dxus yakh puutx we'wek na'jĩna: —Tata, idxa's ewuweçxte', adxa's meen nwe'we txakwe wala pxthaa yuuwa'ja's jxpa'gakahmen. Nawa adx jxthãasni yu'sa' kxtey yuumeeçxawa, iidx jxthãasniçxá's kxtey meen yũu. ");
INSERT INTO pbb_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Txajũ' Jesusa' ki' sxawedku Pedrowe'sx tasxtey, sa' dehna ũste uyçxa' na'wẽk we'we Pedro's: —Adx yakh jxpa'yakx dehmée ũsya' ãjameewá'kwe teeçx oraçxáawa. ");
INSERT INTO pbb_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Ewmeete weteya'mée jxpa'yakx dehmée me'pwe Dxus yakh puutx we'wena. I'kwe'sxa' ũusuh yu' çxhãçxhai'kwe yaaki', nawa i'kwe'sx kakwe yu' çxhãçxhaçme' kxtey yuuya'. ");
INSERT INTO pbb_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Txajũ' Jesusa' ki'kin u'jçxa', na'jĩnak Dxus yakh puutx we'we: —Tata, txakwe wala pxthaa yuuwa'ja's yu'pthejxa' ewuweçxmeete', iidx jxthãasni kxtey yuuwaççxáa ewna jĩçxa', ");
INSERT INTO pbb_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Pedrowe'sx tasxte ki' sxawedçxa', txãawe'sx yafx çxhãçxhameete ki' dehna ũstek uy. ");
INSERT INTO pbb_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Sa' nyafxíi na'wẽyçxáa we'weçxa tekh uswa ki' u'kh, Dxus yakh puutx we'weya'. ");
INSERT INTO pbb_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Txã'wẽ yũuçxak Pedrowe'sx tasxna sxawedna kũhçxa', na'wẽ we'we: —Ãçxh yuuçxá' mdejxujíiwe jxkaaseya'. Dxus Nçxi'k Nasa Yuusa's pkalsawe'sx kusete dukhwa'j en ãjk. ");
INSERT INTO pbb_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Aça' kiiteçxa u'jwega. Adxa's açesawe'sx kusete dukhwa'jsa' yujxã'ja' jĩk. ");
INSERT INTO pbb_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Jesus kxtee we'wena nee ũsiyna, Judasa' pa'kh. Txã' docesatewe'sxíiçxáak yu'. Aça' txãa yakh nasa wala kuh pa'jtx kçxilx vxite' fxtũ atçxa. Txãawe'sxa' sacerdote npiiçthẽ'jwe'sx vxite' judiu nthẽ'jsawe'sx jxkaahnisatx yu'. ");
INSERT INTO pbb_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Judasa' na'jĩnaga yu'kxwe'weçxa pe'jna yuwé' Jesusa's tudkahn: —Ma'sna dxi'pte adx weçxa'nja txã'sna tudçxa jxũna u'jwene'kwe jĩnaga we'we. ");
INSERT INTO pbb_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Txãasak Jesus tasxte utxaaçxa na'wẽ we'we: —Kwe'sxtxi jxpe'jsa jĩna'wa weçxak. ");
INSERT INTO pbb_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Aça' Jesusa' na'jĩk: —Namiku, ¿kĩjxa' yuhga? jĩçpkaçxha', tudtxi jxũna u'jya'. ");
INSERT INTO pbb_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Txã'wẽ tuduçpkaçxha', Jesus yakh pi'kxna u'jusa teeçxsa' kçxilxa's jxkuutxi'jçxa sacerdote npiiçthẽ'ja's selpisáa thũ'wẽ's spẽ'thku. ");
INSERT INTO pbb_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Aça' Jesusa' we'wek: —Iidx kçxilxa's mjxaaw. Txã'wẽme', jxukay maawa kçxilxuh puiisa', kçxilxteyçxáa uuwa'jsata'. ");
INSERT INTO pbb_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Adx Tata's maazkuẽe angeleswe'sxwa adxna nwe'wewa'jsa pẽjxte', kxtey yuuna sũju'çmeewá'ga. ");
INSERT INTO pbb_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Txã'wẽ pẽjxte', kxtey yuuyujuna, nawa Dxus librute' nyafxiitey pta'sxni yã'kh yu' ãçxh na'wẽ tuduçta' txã' kxtey yuukahn, aça' nwe'wewa'jsa pẽjxme'nja. ");
INSERT INTO pbb_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Txã'jĩçxa' tudsatxku we'we: —Adxa' pesweethas i'kwe adxa's tudxa' kçxilx petx fxtũ atçxa pa'j. Adxa' kaapiya'jya' een isath dxuus yatte i'kwe'sx ksxavxyte nes yu'. Nawa txagaçxhíi yu' tudmeei'kwe. ");
INSERT INTO pbb_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Nawa Dxus yuwe pta'sxsawe'sx fxi'jçxa nvxiitni kxtey yuukahnçxáa txã'wẽ yuuça' jĩk. Naapkaçxha' Jesus yakh u'jusawe'sxa' txã'sçxáana nvxihtçxa jxuka ũphna u'jtx. ");
INSERT INTO pbb_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Aça' Jesusa's tudçxa jxũna u'jtx sacerdote npiiçthẽ'j Kaifxas tasxte. Kxteea' ley kaapiya'jsa vxite' judiu nthẽ'jsawe'sx txãawe'sxtxi pkhaakheçxa ũs yu'. ");
INSERT INTO pbb_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Aça' Pedro' e'ste jxu'j neeyũuçxak yuhna ũsu', sacerdote npiiçthẽ'j yat patxute u'kapkaçx, sa' kxtee policiawe'sx yakh kaçxçxa neeyũuk kĩh yũutewa uyya'. ");
INSERT INTO pbb_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Naapkaçxha' sacerdotewe'sx, judiu nthẽ'jsawe'sx vxite' jxukay kxtee pkhaakheçxa ũssawe'sxa' Jesusa's kiikhe'jya' sũhçxa kĩhçxáawa ĩsxiiwa'jsa pakwe'tx. ");
INSERT INTO pbb_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Makwe nasa maazkuẽesa kĩhçxáawa pta'sxna kũhtewa, ĩsxiiniçxáak kaseje'. Nawa nmehte' e'z nasa ĩsxiisa kũhçxa na'wẽtx pta'sx: ");
INSERT INTO pbb_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","—Naa piçthẽ'ja' na'jĩ'k: Adxa' naa dxuus yata's pẽtxçxa tekh ente' ki' txaja'nja jĩ'k jĩna pta'sxte', ");
INSERT INTO pbb_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","sacerdote npiiçthẽ'ja' kiiteçxa Jesusa's na'wẽk we'we: —¿Kĩh yũuçxaga ma'wẽçxáawa pasu'çmée? Meeçxa' ¿isa yuh txã'jĩwá'nta? jĩtewa, ");
INSERT INTO pbb_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Jesusa' pasme'. Aça' sacerdote npiiçthẽ'ja' na'wẽk we'we: —Dxus ĩtxisa dxi'pte jurãyçxa isasaçxá's mpeeta'sx. Idxa' ¿Kristo Dxus Nçxi'k dxihgá'? jĩte', ");
INSERT INTO pbb_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jesus pasçxa': —Idxa' isag we'we'. Adxa' i'kwe'sxtxi na'jĩ'th na': Dxus Nçxi'k Nasa Yuusa's uyuune'kwe Dxus pukate kaçxçxa u'pte sa' cieluju tãaph pxãhte kĩjaçtewa uyuune'kwe jĩte', ");
INSERT INTO pbb_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","sacerdote npiiçthẽ'ja' ũusaçxaçxa peekx athni ropa's sudek na'jĩna: —Naa piçthẽ'ja' txajx yuweju yuu açewe'wek Dxusa's, aça' ¿kĩjxa'çxáa testigo jwee pejiikxtha'w? Txajx açewe'weni's i'kwe'sxíiwa wẽse'ji'kwe. ");
INSERT INTO pbb_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Sa' ãçxha' ¿maa sũju'kwe? jĩte', txãawe'sxa' na'wẽtx pas: —Txã' yuuwesa', txãa pa'ga ikhwa'j yuuna jĩtx. ");
INSERT INTO pbb_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Txajũ' Jesus dxi'pte fxne'sx avxythethçxa uyiitx, aça' vxite' dxi'ptetx uka'ka na'jĩna: ");
INSERT INTO pbb_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","—Idxa' Kristo dxihçxa', mjiyu kimga dxi'pte ujka. ");
INSERT INTO pbb_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Txã'wẽ yuuçpkaçxha', Pedro' ekaju patxutek kaçxçxa u'pu'. Aça' teeçx kna'sa selpisáa utxaana kũhçxa na'wẽk we'we: —Idxwa Jesus Galileajuwe'sx yakh u'jusag jĩte', ");
INSERT INTO pbb_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Pedro' jxukaysa dxi'pte: —I'kwe we'weni's jiimeeth jĩnak ĩsxii. ");
INSERT INTO pbb_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Txajũ' Pedro' vxitxte kasehna u'jweçpkaçxha', vxite kna'sa selpisaawa uyçxa' kxtee ũssatx na'wẽk pta'sx: —Naa piçthẽ'jwa Nasarettewe'sx Jesus yakh u'jute uythu jĩte', ");
INSERT INTO pbb_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Pedro' ki' ĩsxiik jurãyna: —Txãa piçthẽ'ja's adxa' jiimeeth jĩk. ");
INSERT INTO pbb_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Txaçxmeynaçxáa kxtee ũssawe'sx Pedro tasxte utxaaçxa na'wẽtx we'we: —Isa, ĩsxiimée idxwa txãawe'sx yakh u'jusag. Txã'wẽçxaíi iidx we'weni' peedame' jĩte', ");
INSERT INTO pbb_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","ki' jurãyçxa na'wẽk we'we: —Txãa piçthẽ'ja's jiimeeth, isa Dxus uyte. Txã'jĩna ũspkaçxha', atalx we'wek. ");
INSERT INTO pbb_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Aça' Pedro' yajkxku Jesus na'jĩna we'weni's: Atalx we'wemeyna, idxa' tekh us ĩsxiijane'ga jiimeeth jĩni's. Txã's yajkxçxa', Pedro' eka kasehçxa seena' wala nxusna ũ'nek. ");
INSERT INTO pbb_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Txajũ' khikhyna sẽjeçte', sacerdote npiiçthẽ'jwe'sx vxite' judiu nthẽ'jsawe'sx txãawe'sxa' puutx we'wetx Jesusa's kiikhe'jya'. ");
INSERT INTO pbb_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Sa' tudçxa jxũna u'jtx ne'jwe'sx Poncio Pilato tasxte kuutxa'jya'. ");
INSERT INTO pbb_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Jesusna kuuwe'jsa Judasa' Jesusa's ikhwa'j vxitni's jiyuçxa', iiméh wala nxusku. Txã'wẽ yũumeewaça' ewne' yu' sũhçxa treinta vxyutxi' kaasxwedu'jya' u'kh sacerdotewe'sx vxite' judiu nthẽ'jsawe'sx tasxna na'jĩna: ");
INSERT INTO pbb_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","—Adxa' ãhmeeth yũu, txã'wẽ piçthẽ'j kĩhtewa yuuwemeesa's ikhkahn kuuwe'pha'ga jĩte', txãawe'sxa' na'wẽtx pas: —Kwe'sxa' ¿jiitka'wá'? Txã'wẽ yũusa idx jiine'ga jĩçxa jxpa'gameete', ");
INSERT INTO pbb_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Judasa' txãa vxyu's dxuus yatte wãatahna'wa u'jçxa ya'jythujkku. ");
INSERT INTO pbb_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Txã'wẽ yũute', sacerdotewe'sxa' txãa vxyu's pkhakhçxa na'wẽtx puutx we'we: —Naa vxyu's ofxreda kajate akhya' ãjame'nja'w. Txã'wẽme', nasa's kiikhe'jni vxyua' naa pa'ga jĩçxa', ");
INSERT INTO pbb_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","txãa vxyuju mitxh umsáa kiwe'stxi wey, nasa ekajuwe'sx pa'jçxa uusaatx pedaawa'j. ");
INSERT INTO pbb_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Txãa pa'ga ãçxpkaçx txãa kiwe' ee pkawnisa kiwe' jĩ'tx. ");
INSERT INTO pbb_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Aça' Dxus yuwe pta'sxsa Jeremias we'weni kxtey yuuk. Txã' na'wẽk we'we: Israelwe'sx makwetene'ta txweyya' puutx we'we txãa treinta vxyu's jxpa'gaçxatx ");
INSERT INTO pbb_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","mitxh umsáa kiwe's wey, Dxusa' adxa's jxkaakh kiwe weykahn txã'sa' kxtey yuutx jĩnak fxi'j. ");
INSERT INTO pbb_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Jesusa' ne'jwe'sx tasxte jxũna u'jnik yuu, aça' txã' na'jĩnak pẽjx: —Idx wáa txã'wẽ judiuwe'sxtxi jxkaahsane'ga jĩte', Jesus pasçxa': —Idxa' isag we'we'. Adxa' txã'wẽsaíith jĩk. ");
INSERT INTO pbb_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Txajũ' sacerdotewe'sx vxite' judiu nthẽ'jsa txãawe'sxa' Jesusa's ewmeesag jĩna we'wete', Jesusa' pasu'çme'. ");
INSERT INTO pbb_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Aça' Pilato' na'wẽk we'we: —Idxa's na'wẽtx kĩhtewa jxuka ewmeesa' jĩna yuwe ũsu' aça' wẽse'jeçmeewá'ga jĩtewa, ");
INSERT INTO pbb_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Jesusa' kĩhwa pasme'. Txã'wẽ pasmeete', ne'jwe'sxa' ma'wẽ yũuya'çxáa yuhwa ãjameeçxa', na'wẽ yũuya'k yajkx. ");
INSERT INTO pbb_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Fxiesta ensu' ne'jwe'sxa' teeçx preesu txhweete'k ma'sna nasa pẽyitxna txã'sna. ");
INSERT INTO pbb_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Aça' txãa fxiesta ensu' teeçx preesu jxtuhthesa ũsu'k Barabas yaasesa. ");
INSERT INTO pbb_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Kxajk Pilato' na'jĩna pẽjx txãawe'sx pkhaakheçxa ũssatx: —I'kwe'sxa' ¿kimnakwe txhweete jxthãasu'? ¿Barabasna', meeçxa' Kristo jĩ'i'kwe txã'sna wáa kaatxhweete'je'nja? ");
INSERT INTO pbb_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Txã'wẽ Jesusa's ahçeçxa txajx tasxte dukhtewa jiyuçxak txã'jĩ. ");
INSERT INTO pbb_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pilato' jxkaahna u'pnite u'pte', txajx nyua' na'jĩnaga yuwe kaah: Txãa piçthẽ'j yuuwemeesa yakha' kuçx yuumeena. Txã'wẽme', ãçxh kus iiméh seena' ũukhũukh ksxa'wthu txãa piçthẽ'j ma'wẽ yũuwa'jsatewa. ");
INSERT INTO pbb_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Txã'jĩna pta'sxtewa, sacerdotewe'sx vxite' judiu nthẽ'jsa txãawe'sxa' nasatx knaytxi yu'kxwe'weçxa, txã'wẽ Barabasa's txhweeteçxa Jesusa's kiikhe'jwa'ja's pẽykahn. ");
INSERT INTO pbb_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Txã'wẽtewa, ne'jwe'sxa' ki' pẽjxku na'jĩna: —Naa e'zsatxi' i'kwe'sxa' ¿ma'snakwe kaatxhweete'j jxthãasu'? jĩte', txãawe'sxa' na'wẽtx pas: —Barabasna metxhwete jĩte', ");
INSERT INTO pbb_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilato we'weçxa': —Barabasa's txhweeteçxa', naa Jesusa's Kristo jĩ'i'kwe txã'sa' ¿kĩh yũutka? jĩte', jxukaysa pasçxa': —Kluuste mkaafxuçu'j jĩ'tx. ");
INSERT INTO pbb_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Aça' Pilato' na'wẽk pẽjx: —¿Kĩhga ewmée yũu? jĩte', txãawe'sxa' ki' sus we'weçxa': —Kluuste mkaafxuçu'j jĩ'tx. ");
INSERT INTO pbb_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Txajũ' Pilato' kĩhwa yũuya' ãjanimeeteçxáa nasa' jweeíiçxáa seena' wala suste', yu' jxũukaahçxa nasaa dxi'pte txajx kusetx kweeçxak na'jĩna: —Naa piçthẽ'j kĩhtewa yuuwemeesa's ikhni's adxa' yuuwemeesath. Txã'sa' i'kwe'sx pasune'kwe jĩte', ");
INSERT INTO pbb_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","nasa jxukaysa we'weçxa': —Txã'sa' kwe'sx luuçx yã'jçxa jxuka paswa'jsatha'w jĩ'tx. ");
INSERT INTO pbb_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Txajũ' Pilato' kaatxhweete'kh Barabasa's, nawa Jesusa's kaapeçxukwe'jçxa kluuste fxuçkahn dukhku. ");
INSERT INTO pbb_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Txã'wẽ yũute', soldauwe'sxa' ne'jwe'sx u'pnite ka'ga'jçxa, soldauwe'sx jxukaysatx pa'yaçxa Jesusa's jxuka kxtadçxatx yuju. ");
INSERT INTO pbb_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Txajũ' ksũupi'jçxa atxh behsatx kaathe'j. ");
INSERT INTO pbb_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Sa' çhũçha's korona na'wẽ vxitçxa dxikthete ki'ptxi. Paçu kuseju yu', fxtũu zuzkuẽtx kaatu'j. Txã'wẽ yũuçxatx txajx tasxte peejxũkwe: —Judiuwe'sxtxi jxkaahsath jĩ'ne'ga jĩna weeçxna. ");
INSERT INTO pbb_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Sa' fxne'sx avxythethna fxtũ's kusa'jçxa, dxikthegatx pekwe'kwe. ");
INSERT INTO pbb_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Txã'wẽ Jesusa's weeçxna jxã'jçxa', txãa atxh behsa's ksũupi'jçxa Jesus ropa's ki' kaathe'jtx. Txã'wẽ yũuçxatx kluuskhẽ fxuçya' jxũna u'j. ");
INSERT INTO pbb_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Txajũ kasehna u'jweççxa', teeçx piçthẽ'j Cirenejũwe'sx Simon yaasesa yakhtxi pu'jykhẽw. Sa' Jesus yakhni kluusa's txã'snatx kxaakhe'j. ");
INSERT INTO pbb_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Txã'wẽ yũuçxatx pa'j teeçx ahte Golgota yaasesate. Txãa yu' Uusá Dxikthé Dxi'thçxáasa jĩni'. ");
INSERT INTO pbb_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Kxteea' vxinote yaasa's awçxatx Jesusa's yus wẽe. Nawa txã'sa' yuwete isaçxaçxáa tudxme'. ");
INSERT INTO pbb_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Kluuskhẽ a'kxçxa', soldauwe'sxa' swerte kaahtx Jesus athni ropa's maa soldau knaytewa jiyuya'. Dxus yuwe pta'sxsa' na'jĩnak we'we txã' kxtey yuuk: Swerte kaahçxa adx ropa's txudeedetx txãawe'sx pwe'sx jĩnak we'we. ");
INSERT INTO pbb_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Txã'wẽ yũuçxatx kxtee thegna kaçx. ");
INSERT INTO pbb_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Sa' txajx dxikthé kakwey fxi'jçxa ki'ptxi kĩh yũusate ikhçxawa na'jĩna pta'sxna: Naaíi Jesus Judiuwe'sxtxi Jxkaahsa' jĩnak fxi'jni yu'. ");
INSERT INTO pbb_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Sa' Jesus pukakhẽ pdxi'ptxi e'z pesweetx ki'pni yuu kluuskhẽ. ");
INSERT INTO pbb_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Aça' kluus tasxuy uykhẽwsa' na'jĩnatx wẽesxu' dxiktheetx kaawũhna: ");
INSERT INTO pbb_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","—Dxuus yata's pẽtxçxa tekh ente' ki' kiissathẽ'j, idxa' ya'menwe'we. Dxus Nçxi'k dxihçxa', kluusuh msa'j jĩ'tx. ");
INSERT INTO pbb_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Txã'wẽy sacerdotewe'sx, ley kaapiya'jsawe'sx, fxariseowe'sx, vxite' judiu nthẽ'jsawe'sx txãawe'sx pwe'sx na'jĩnatx weeçx we'we': ");
INSERT INTO pbb_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","—Vxite yuutxi' nwe'wek, nawa peekíi yu' ya'nwe'weya' ãja'çme'. Israelwe'sxtxi Jxkaahsa dxihçxa', kluusuh sa'jana aç yuuçxáa ĩsxiija'çmeega sũju'nja'w. ");
INSERT INTO pbb_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Dxus Nçxi'kthu jĩ'k na' Dxusnane' neewe'we', aça' txã'sa' ãçxhíi Dxusa' nwe'wena, nwe'weya' ãjaçxa yu' jĩ'tx. ");
INSERT INTO pbb_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Aça' kluuskhẽ fxuçni ki'pnisa peswée yuhwa wẽesxu pu'çxhi'tx. ");
INSERT INTO pbb_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Txajũ' ẽepxãh walajũjx çxhi'dxçxa kusuçte las trestepkaçxku çxhi'dx naa kiwete jxuka. ");
INSERT INTO pbb_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Aça' las tres ãjaçpkaçxha', Jesusa' na'jĩnak sus we'we: —Eli, Eli, ¿lama sabaktani?—txã' na'jĩni': Adx Dxusgu sa' ¿mjĩi pa'gaga adxa's thegmée nvxiht? jĩni'. ");
INSERT INTO pbb_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Aça' kxtee ũssa' txã'jĩni's wẽse'jçxa', na'wẽtx we'we: —Dxus yuwe pta'sxsa Eliasa's pa'yaça' jĩ'tx. ");
INSERT INTO pbb_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Naapkaçxha' teeçxsa' wuwuuna u'jçxa esponja's vxino puste akhçxa fxtũu vxiçte ki'pçxa yuwete utxak çxazxakahn. ");
INSERT INTO pbb_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Nawa vxite yu' na'jĩ'tx: —Kuçx yuunu. Aan Elias pa'jana nwe'weya' jĩ'tx. ");
INSERT INTO pbb_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Txajũ' Jesusa' ki' seena' sus we'weçxa' uuk. ");
INSERT INTO pbb_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Naapkaçxha' dxuus yatte txudenisa liensu pesath a'kxnisa' puupxãjkhẽ sutek kute ẽeju kiwete kĩh. Naapkaçxha' ehdwa çxhãçxha u'the', penxa yuhwa upetx, ");
INSERT INTO pbb_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","aça' uusaawe'sx pedaní kafxwa phaatete', Dxusna jxpa'gaçxa uusaawe'sxa' ki' ĩtxi yuutx. ");
INSERT INTO pbb_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Aça' Jesus uuçxawa ki' ĩtxi yuuniijũ' txãawe'sxa' pedaní kafxu kasehçxa Jerusalente u'kate', maazkuẽesawa uytxi. ");
INSERT INTO pbb_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Txajũ' kxtee Jesusna jxpa'yakx thegna ũssawe'sx vxite' soldau kpiitan txãawe'sxa' wala ũukhtxi ehd u'jna vxite' kĩhwa seena' yũuni's uyçxa. Sa' na'wẽtx we'we: —Isa, naa piçthẽ'ja' Dxus Nçxi'k yuh yu'ga jĩ'tx. ");
INSERT INTO pbb_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Kxteea' kuh u'ytxi ũsu' jxu'ju thegna, txãawe'sxa' Jesusna selpiina u'jusatx yu' Galileajũjx yuusa. ");
INSERT INTO pbb_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Txãawe'sx ksxavxyte' Maria Magdalena, vxite Maria Jakobo Jose njĩ'j, vxite' Zebedeo nyu txãawe'sxtxi yu'. ");
INSERT INTO pbb_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Kusna kĩjaçte', teeçx piçthẽ'j wala ji'phsa Jose yaasesa Arimatea çxhabuwe'sxku pa'j. Txãawa Jesus yakh u'jusak yu'. ");
INSERT INTO pbb_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Txãa piçthẽ'ja' Pilato tasxte u'jçxa', Jesus kakwe's pẽjxku, aça' Pilato' yuwe kaakh tee dukh jĩna. ");
INSERT INTO pbb_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Txajũ' Josea' Jesus kakwe's spajkxçxa liensu fxinusatek yap. ");
INSERT INTO pbb_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Sa' kwet penxate u'se kafxi'jçxa ji'phu'k peekx kakwe's pedaawa'j txkaa khikhçxa', u'kani kafxte yu' kwet walasaju aphçxak u'j. ");
INSERT INTO pbb_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Kxtee txã'wẽ yũuçte', pedaní kafx dxi'puh utxatx thegna u'pu' Maria Magdalena vxite Mariawa. ");
INSERT INTO pbb_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Jxkaasena fxi'zeya' jxuka pheu'jna jxã'jnijũ kuskuskhẽ' sacerdote npiiçthẽ'jwe'sx vxite' fxariseo txãawe'sxa' Pilato tasxte u'jçxa na'wẽtx we'we: ");
INSERT INTO pbb_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","—¿Wẽse'gá', ne'jwe'sx? Txãa ĩisxihthẽ'ja' nee ĩtxi u'juçxa', uuçxawa tekh ente' ki' ĩtxi yu'nja jĩni'stha'w yajkx. ");
INSERT INTO pbb_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Txãa pa'ga mkaah pedaní kafxte wala ew aphkahn tekh entepkaçx. Txã'wẽ yũumeete', txãa yakh u'jusawe'sxa' kus pa'jçxa kakwe's pesweetxna, sa' e'suyã'ja' na'jĩna we'wetxna nasatx: Uuçxawa ki' ĩtxi yuuga jĩtxna. Aça' txã'wẽ yũuçxa ĩsxiini' nyafxíi ĩsxiinite thaakwesa yuuna jĩte', ");
INSERT INTO pbb_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilato' na'wẽk we'we: —Soldauwe'sx kxtee ũsta' txãatx pe'jçxa me'jwe, sa' pedaní kafxte wala ew maphwe. I'kwe'sxtxi ma'wẽ wejx ew thegte', txã'wẽ myũuwe. ");
INSERT INTO pbb_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Txã'jĩte', u'jçxa pedaní kafxte wala ew aphçxa txãa aphni kajkwete selxo ki'ptxi, sa' jxpa'yakx thegna ũswa'jsa soldauwe'sx txahtx. ");
INSERT INTO pbb_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Jxkaase en skhẽwniijũ kuskuskhẽ mjĩiwa'j en ãanite wala kusíitey Maria Magdalena vxite Maria yakh txãawe'sxa' u'jtx pedaní kafxte thegya'. ");
INSERT INTO pbb_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Naapkaçxha' ehd seena' çxhãçxha u'kh, txã'wẽ Dxus angel cieluju kĩhçxa pedaní kafxte aphni kweta's kiispa'ga. Sa' txãa yu' txãa kwet kajkwete kaçxçxa ");
INSERT INTO pbb_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","kpi'sx kweneni na'wẽk khikhyna u'p yu', aça' txajx athni ropa' seena' zhiçxkwe çxihme yu'tx. ");
INSERT INTO pbb_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Aça' soldauwe'sxa' txã'wẽsa's uyçxa', ũukhnite jxuka yayaçxa uuníi na'wẽtx wete. ");
INSERT INTO pbb_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Aça' txãa u'ywe'sxtxi' Dxus angela' na'wẽk we'we: —Ũukhnuwe, adxa' jiith, Jesusna kluuste fxuçtxi txã'sna i'kwe'sxa' thegya' yuji'kwe. ");
INSERT INTO pbb_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Nawa ayte' meeyã'ja'. Uuniijũ ki' ĩtxi yuuçxa u'kh ma'wẽga pta'sx txã' kxtey yuuk. Mkaane'ta khikh txkaa myuhwe thegya'. ");
INSERT INTO pbb_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Sa' wala dud me'jwe, txãa yakh u'jusawe'sxtxi na'wẽ pta'sxya': Uuçxawa ki' ĩtxi yuuçxa Galilea kiwen u'jweça' i'kwe'sx yaçte. Kxtee puutx uyuune'kwe jĩna pta'sxine'kwe. Txã'wẽ pta'sxwa'th ji'phu i'kwe'sxtxi jĩk Dxus angela'. ");
INSERT INTO pbb_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Txajũ' u'ywe'sxa' wala dud wuwuuna u'jtx Jesus yakh u'jusawe'sxtxi pta'sxya' ũukhnawa ũuste wẽt wẽt yajkxna. ");
INSERT INTO pbb_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Naapkaçxha' Jesusa' txãawe'sx u'jweçte dxi'the vxyaaçxa weçxana kũjk. Aça' txãawe'sxa' Jesus tasxte peejxũkweçxa txajx çxidatx psxa'dçxa weçxatx. ");
INSERT INTO pbb_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Aça' Jesusa' na'jĩk: —Ũukhmée me'jwe, sa' adx yakhthẽ'jwe'sxtxi pta'sxine'kwe Galilea kiwen u'jçxa kxtee adxa's puutx uyuune'kwe jĩnak pta'sxkaah. ");
INSERT INTO pbb_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","U'ywe'sx txã'wẽ u'jweçpkaçxha', pedaniite thegna ũssa soldauwe'sx maaíi yu' u'jtx Jerusalente sacerdotewe'sxtxi pta'sxya' kĩh yũuni'swa jxuka. ");
INSERT INTO pbb_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Txajũ' sacerdotewe'sxa' judiu nthẽ'jsawe'sx tasxte u'jçxa puutx we'wetx. Txã'wẽ yũuçxa soldauwe'sxtxi' wala vxyu dukhtxi. ");
INSERT INTO pbb_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Sa' na'wẽtx we'wekaah: Kuspxãh kwe'sx deenite Jesus yakh u'jusawe'sx pa'jçxa uuníi kakwe's pesweeta jĩne'kwe i'kwe'sxa'. ");
INSERT INTO pbb_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Aça' txã'wẽ yuh dehne'ta sũhçxa ne'jwe'sxa' i'kwe'sxtxi ewmeete nvxiit wẽjewáana, nawa kwe'sx u'jçxa txãa yakh puutx we'we'nja'w i'kwe'sx ju'gu txã'wẽ yũukahmén. ");
INSERT INTO pbb_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Txã'wẽ kwe'we'the', soldauwe'sxa' vxyu's jxpa'gaçxa kxtey yuutx. Aça' txãasatx judiuwe'sxa' ãçxpkaçx txã'wẽçxáa pta'sxi'. ");
INSERT INTO pbb_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Txã'wẽ yũuyã'the', Jesus yakh u'jusa oncesawe'sxa' Galilean u'jtx, thã'j vxiçte mteene' Jesus pta'sx kxtee. ");
INSERT INTO pbb_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Sa' Jesusa's uyçxa', peejxũkweçxa weçxatx, nawa vxiteíi yu' txãamée wáana sũhna kuhtx yaaki'. ");
INSERT INTO pbb_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Txajũ' Jesusa' txãawe'sx tasxte utxaaçxa na'wẽk we'we: —Cielute vxite' naa kiwetewa adxnaçxaçxáak neewe'weni yuu jxkaahwa'ja's. ");
INSERT INTO pbb_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Txãasath i'kwe'sxtxi jxkaaja': Me'jwe Dxus yuwe's pta'sxya' maa kiwetewa nasa jxukaysatx. Txã'wẽ yũuçxa' yu'te bautisaĩne'kwe, Dxus vxite' Dxus Nçxi'k vxite' Dxus Espiritu txãawe'sxtxi neewe'weçxa. ");
INSERT INTO pbb_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Sa' Dxusa's nwẽese'jwa'ja's kaapiya'jane'kwe kĩhtewa jxuka, adx ma'wẽtka i'kwe'sxtxi jxkaah txã'wẽy. Mjiyuwe, ãçxhũyã'ja' een isa bagaçxtewa i'kwe'sx yakh nes yuuya'wath naa kiwe pçuupkaçx jĩk. ");
INSERT INTO pbb_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Dxus Nçxi'k Jesukristo fxi'zeni's pta'sxnisa na'wẽk takh: ");
INSERT INTO pbb_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Txãniitey Dxus yuwe pta'sxsa Isaiasa' na'jĩnaga fxi'j Dxus we'weni's: Teeçx adx yuwe pta'sxsa's kajaçthu iidx yaçte, iidx dxi'ja's pheu'khan. ");
INSERT INTO pbb_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Nasa u'pnimée kiwesu sus we'wenik pthũuse' na'jĩna: Dxus pa'jwa'ja's mpheu'jwe, dxi'ja's ku'le phaadena jĩ'k. ");
INSERT INTO pbb_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Txã'wẽ Isaias we'weni kxtey yuuwa'j ãhte', Juana' nasa u'pnimée kiwesu vxyaak nasatx bautisãyna. Sa' na'jĩnak pta'sxi': —Pkaltxi nvxihtçxa Dxus tasxte misxawedwe, yu'te ya'bautisãyna, kxah i'kwe'sxtxi' Dxusa' peltunaĩna. ");
INSERT INTO pbb_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Juan we'weni's wẽsẽ'jya' pa'jtx Judea kiwesuwe'sx vxite' Jerusalenuwe'sxwa. Sa' pkalsatha'w jĩna Dxusa's perdon pẽjxna pa'jsatxi' Juana' Jordan yu'walate bautisaĩ'k. ");
INSERT INTO pbb_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Juana' kamelxo khas atxh athçxa kha'txku jxtudu', sa' txajx ũ'nisa yu' khã'sx wala çxhi'dx miltxi yu'. ");
INSERT INTO pbb_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Sa' Dxus yuwe's na'jĩnak pta'sxi' nasatx: —Adx e'suh teeçx yuja' txã' adxte jxthaakwe ãjãwa'jsa'. Adxa' txajx pelgatxi wesçxáa yuhtxwa khihbxa' ãjãwa'jmeesath. ");
INSERT INTO pbb_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Adxa' i'kwe'sxtxi' yu' yakhçxáath bautisãyya' ãjã', naapkaçxha' txã' i'kwe'sx ũuste Dxus Espiritu's kxu'akhe'jya' ãjãwa'jsa' jĩ'k. ");
INSERT INTO pbb_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Txãn ensu' Jesusa' Nasaret çxhabu kasejk Galilea kiweju. Sa' Juan tasxte pa'the', Jordan yu'walate bautisãyku. ");
INSERT INTO pbb_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Aça' yu'ju kasejeççxa', uyku cielu phaateeçte. Naapkaçxha' Espiritu' tub çxihme na'wẽsa txajx kajkwekhẽ kĩjaçtek uy. ");
INSERT INTO pbb_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Sa' cieluju teeçx na'jĩna we'weniwa pthũusek: —Idxa' adx Nçxi'k wala wedxnisag. Iidxpa'ga wala weçxana ũsthu jĩk. ");
INSERT INTO pbb_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Txãa dudtey Espiritu' Jesusa's pe'jna u'kh nasa u'pnimée kiwesu. ");
INSERT INTO pbb_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Aça' Jesusa' kuarenta enku kxtee u'pu' yu'kh niimal ksxavxyte. Kxtee u'pte', eçxthẽ'ja' pa'kh ewmée vxit wẽeçxa. Aça' txãa e'su' Dxus angeleswe'sxwa pa'jtx pu'çxya'. ");
INSERT INTO pbb_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Juana's karcelte kxuuphni e'su', Jesusa' Galilea kiwen u'kh Dxus jxkaahwa'ja's pta'sxya'. ");
INSERT INTO pbb_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Sa' na'jĩnak pta'sx: —Ena' ãjãça'. Dxus jxkaahwa'j ena' utxa ũsa'. Aça' i'kwe'sxa' pkaltxi nvxihtçxa Dxus tasxte misxawedwe, sa' Dxus yuwe ewte nvxiitwa'jsa's ũuste myu'akhwe jĩ'k. ");
INSERT INTO pbb_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Txãa e'su' Jesusa' Galilea ĩkh wala pukasu u'jweççxa', uyku pxakhsatx Simon Adreswe'sxtxi. Txãawe'sxa' wedx uwesaatx yu', txãasatx wedx ukhe's ĩkh walate akhna ũsu'. ");
INSERT INTO pbb_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Aça' Jesusa' pa'yak: —Adx yakh myuhwe, aça' i'kwe'sxtxi' Dxus jĩi nasaa pkhakhwa'jsa vxitu'nja. ");
INSERT INTO pbb_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Txã'jĩçpkaçxha', txãawe'sxa' wedx ukhe's nvxihtna' Jesus yakh u'jtx. ");
INSERT INTO pbb_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Txajũ' Jesusa' ki' u'jçxa', Zebedeo nçxi'kwe'sx pxakhsatxku uy, Jakobo Juanwe'sxtxi. Txãawe'sxa' wedx ukhe's pã'khnatx u'p yu' barkote. ");
INSERT INTO pbb_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Aça' pa'yak. Naapkaçxha' txãawe'sxa' ney Zebedeo's vxite pu'çxsa yakh barkote nvxihtna', Jesus yakh u'jtx. ");
INSERT INTO pbb_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Txajũ' Kapernaum çxhabte pa'jçxa', Jesusa' kaapiya'jya' takhku sapatu jxkaase ensu judiuwe'sx pkhaakhenite. ");
INSERT INTO pbb_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Aça' Jesus kaapiya'jni's wẽsẽ'jçxa', nasa' wala kuh yajkxna neeyũutx, txã'wẽ leya's kaapiya'jsawe'sx na'wẽmée, nwẽese'jwa'ja's ũukhnus we'wena kaapiya'pha'ga. ");
INSERT INTO pbb_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Txãa pkhaakheni yatte teeçx piçthẽ'j eçx iiyamunisak ũsu', sa' na'jĩnak sus we'we: ");
INSERT INTO pbb_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","—Jesus, Nasarethuwe'sx, kwe'sxtxi' ¿kĩh ya'waga? ¿Ivxiituya' wá'ga yuwé'? Idx kimtewa jiith. Idxa' Dxus kaahnisag jĩte', ");
INSERT INTO pbb_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Jesusa' na'jĩnak ũusçxa we'we txãa eçxa's: —Sxuuna' myũu, sa' naa piçthẽ'j ũusu mkaaseh jĩna jxkaathe', ");
INSERT INTO pbb_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","txãa eçxa' nasa's kaywẽçxpa'jna juuna' kweeyi'jçxa kasejk. ");
INSERT INTO pbb_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Txã'wẽ yũute', nasa' jxukaysa ũukhçxa na'wẽtx puutx paapẽyi': —Naa piçthẽ'ja' ¿kimna? Txajx we'weni' ¿kĩhtxki açki'tx eçx yuhwa nwẽesẽ'je'? jĩ'tx. ");
INSERT INTO pbb_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Jesus txã'wẽ yũuni's wala dud jiyutx Galilea kiwesuwe'sx jxuka. ");
INSERT INTO pbb_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Txajũ' judiuwe'sx pkhaakheni yatu kasehçxa', Simon Adreswe'sx yatnak u'j, Jakobo Juan yakh. ");
INSERT INTO pbb_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Aça' kxtee yu' Simon nyu njĩ'ja' kakwesektek ãçã'na ũsu'. Aça' Jesusa's pta'sxtxi txã'wẽ ãçã'sa ũsa' jĩna. ");
INSERT INTO pbb_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Txajũ' Jesusa' kũhçxa kuseju pu'kisku, naapkaçxha' dudtey kakweseka' ũçxhak. Txajũ' kiiteçxa selpiiya' kasejk. ");
INSERT INTO pbb_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Txajũ' çxhi'dxna kĩjaçte', jxuka ãçã'satx Jesus tasxte nuypa'jtx vxite' eçx luuku vxitnisatxwa. ");
INSERT INTO pbb_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Aça' çxhabte nasa' jxuka kũhtx vxitxte thegya'. ");
INSERT INTO pbb_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Txajũ' Jesusa' nuykatxhik fxiyfxiy wee ji'phsatxwa, sa' eçx luuku vxit-satxwa wala kutxi'kh nasaa ũusu. Txãa eçxa' Jesus kimtewa jiitx yu' nawa kwe'we'jme'. ");
INSERT INTO pbb_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Txã'wẽ yũuni khikhiiçte nee çxhi'dxtey, Jesusa' Dxus yakh puutx we'weya' u'kh çxhab ekaju. ");
INSERT INTO pbb_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Aça' Simona' vxite yakh Jesusna pakweya' u'kh. ");
INSERT INTO pbb_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Sa' uyçxa' pta'sxku: —Jxukaysa idxa's jxpeejxta' jĩtewa, ");
INSERT INTO pbb_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Jesus pasçxa': —Ay utxasuwe'sx vxitewa peejxta' Dxus yuwe ewsa's, aça' kxsũ u'jwega. Txã'wẽ pta'sxna pekũjxa' íiçxáath naa kiwete kĩh jĩk. ");
INSERT INTO pbb_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Sa' eçx iiyamuçxa luuku vxit-satx nasaa ũusu kutxi'jna Galilea kiwesu jxuka pekũjk Dxus yuwe's pta'sxna, vxite' judiuwe'sx pkhaakhenisuwa. ");
INSERT INTO pbb_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Txãn ensu' teeçx piçthẽ'j wã'jy wee seena' kazxsate ãçã'sa Jesus tasxte peejxũkweçxa na'jĩk: —Adxa's nuykatxhiwá'ga ahçemeeçxa' jĩna pxthaa we'wete', ");
INSERT INTO pbb_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Jesusa' peeygãhna kuseju jxa'dxçxa': —Ahçeme'nja, naa pa'ga katxhiçxa mneeyũu jĩçpkaçxha', ");
INSERT INTO pbb_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","txãa wã'jy weeju katxhiçxak neeyũu. ");
INSERT INTO pbb_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Txajũ' Jesusa' txãa piçthẽ'ja's wala neewe'weçxa kaakh na'jĩna: ");
INSERT INTO pbb_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","—Adx we'wenitxi' jxpa'yakxçxa, maa yuhtxwa pta'sxmeene'ga, naasáa sacerdoteçxá's iidx kakwe's txwesya' me'j. Sa' txãa weeju katxhipa'ga Dxusna peesune'ga Moises ma'wẽga jxkaah txã'wẽy, kxah nasa jxukaysa jiyutxna idx ew katxhiçxa neeyũutewa jĩnak neewe'we. ");
INSERT INTO pbb_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Nawa txãa piçthẽ'ja' nasa jxukaysatx pta'sxku, Jesus ma'wẽ yũuni'swa jxuka. Txãa pa'gaçxáa Jesusa' maa çxhabte yuhwa ãate pa'jya' ãjãmeeçxa', çxhab ekaju nasa meesuçxáak u'ju'. Makwe txã'wẽ yũutewa, txajx tasxte yu' majũwe'sxwa pa'jna nestxi yu'. ");
INSERT INTO pbb_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Maz en skhẽwniijũ' Jesusa' ki'kin pa'kh Kapernaum çxhabte. Aça' nasa jiyutx Jesusa' pa'jçxa teeçx yatte ũsa' jĩni's. ");
INSERT INTO pbb_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Txãasatx naa dudte nasa wala pkhaakheçxa yat vxitxte jxuka uta, aça' Jesusa' Dxus yuwe's pta'sxku. ");
INSERT INTO pbb_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Naapkaçxha' pahz piçthẽ'jsa teeçx ẽsẽya' ãjãsameea's yakhçxatx Jesus tasxte nuypa'j. ");
INSERT INTO pbb_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Nawa nasaa ksxavxyte Jesus tasxte kuutxa'jya' ãjãmeeçxa', yat kajkweju phaadeçxatx Jesus ũsnikhẽ nuykĩh aadasga khikhçxa. ");
INSERT INTO pbb_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Txajũ' ãçã'sa's nuypa'jsawe'sxa' Jesusa' nuykatxhiyujuna sũhni's jiyuçxa', txãa ãçã'sa's we'wek Jesusa': —Iidx pkala' peltunãyni yã'jtx neeyũu jĩte', ");
INSERT INTO pbb_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Dxus leya's kaapiya'jsawe'sx wẽsẽ'jna u'psa maaíi yu' na'wẽtx yajkx: ");
INSERT INTO pbb_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","—¿Ma'wẽçxaga naa piçthẽ'ja' txã'wẽ we'we'? Dxus yuuçxáa pkaltxi peltunãyya' ãjawa'jsa', aça' jweeju yu' ¿kimçxá' peltunãyya' ãjãma'k? Aça' Dxusa's iiweeçx we'wena ũsa' sũjũ'tx. ");
INSERT INTO pbb_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Nawa Jesusa' txãawe'sx yaakxni's jiyuçxa na'jĩk: —¿Kĩh yuutekwe txã'wẽ yaaki'? ");
INSERT INTO pbb_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","¿Maa thẽymeesakx? Iidx pkala' peltunãyni yã'jtx neeyũu ¿jĩniá'? Meeçxa': Kiiteçxa iidx deeni's tu'sçxa me'j ¿jĩniá'? ");
INSERT INTO pbb_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Makwe thẽysatewa Dxus Nçxi'k Nasa Yuusa' naa kiwete pkaltxi peltunãyya' ãjãwa'jsa' naa pa'ga kaajiyu'jya'wath ãçxha'. Txajũ' ãçã'sa's na'jĩk: ");
INSERT INTO pbb_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Idxa'sthu we'we': Kiiteçxa iidx deeni's tu'sçxa yatna me'j jĩçpkaçxha', ");
INSERT INTO pbb_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","ãçã'sa' dudtey kiitena'wa txajx deeni's tu'sçxa u'kh, nasa thegna ũsiyna. Txajũ' jxukaysa wala kuh yajkxna Dxusna weçxana na'jĩ'tx: —Bagaçx yuhwa na'wẽ yũuni yu's iiuymeetha'w jĩ'tx. ");
INSERT INTO pbb_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Txãa e'su' Jesusa' ki' u'kh ĩkh wala pukan. Aça' txajx tasxte nasa wala pkhaakhete', Dxus yuwe's kaapiya'kh. ");
INSERT INTO pbb_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Txãajũ ki' u'jçxa', Alfxeo nçxi'k Levxia'sku uy, gobierno jĩi vxyu pkhakhna u'pte. Sa': —Adx yakh myuh jĩna pa'yaçpkaçxha', Levxia' kiitena' Jesus yakh u'kh. ");
INSERT INTO pbb_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Txajũ' Jesusa' txãa yakh u'jusawe'sx yakh Levxi yatte ũ'ya' u'kate', gobierno jĩi vxyu pkhakhsawe'sx vxite' pkalsawe'sxwa wala kuhsa pkhaakheçxa' Jesus yakh mesate ũ'ya' kaçxtxi. ");
INSERT INTO pbb_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Aça' Dxus leya's kaapiya'jsawe'sx vxite' fxariseowe'sxa' Jesusa' nasa txã'wẽsa ksxavxyte u'pte uyçxa', pẽjxtxi Jesus yakh u'jusawe'sxtxi: —I'kwe'sxtxi kaapiya'jsa ¿ma'wẽçxaga gobierno jĩi vxyu pkhakhsawe'sx vxite' pkalsawe'sx yakh ũ'wé'? jĩte', ");
INSERT INTO pbb_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","txã'wẽ pẽyiçte Jesus wẽsẽ'jçxa' na'jĩk: —Yu'çe'jsa's jxpeejxmeeta' aka ji'phmée wẽt ũssa', naasáa ãçã'sa yuuçxáa yu'çe'jsa's jxpeejxta'. Adxa' naa kiwete nasa ewsatx pakweya' kĩhmeeth, pkalsatx pakweya'çxáath kĩh jĩk. ");
INSERT INTO pbb_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Teeçx ente', Juan yakh u'jusa vxite' fxariseowe'sx yakh u'jusa txã'wẽ yũunaana ũste', nasa' paapẽjxtxi Jesusa's: —¿Juan yakh u'jusa vxite' fxariseowe'sx yakh u'jusawe'sxa' yũuna'tx, aça' idx yakh u'jusawe'sx yu' ¿kĩh yuuçxata yũuna'çmée? jĩte', ");
INSERT INTO pbb_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Jesusa' na'wẽk kaaja'da'jna pas: —¿Novxiowe'sx kaba ente pi'kxnisa' yũunaaya' ãjãma'tx? novxio txãawe'sx yakh nee ũsiite'. Kabani fxiesta pçumeyte', yũunaaya' ãjãmeetxna. ");
INSERT INTO pbb_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Nawa novxio' txãawe'sx tasxu txuteewa'j en pa'jana, txãjũ isa yũunaatxna. ");
INSERT INTO pbb_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Ropa ĩisx suteniite, tela u'sesa yakh ya'pã'khe'çme'. Txã'wẽme', tela u'sesa' jweeíiçxáak sude' ĩisxsa's. ");
INSERT INTO pbb_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Txã'wẽy beka u'se aahnisa's slun ĩisxsate ya'awu'çme'. Txã'wẽme', beka u'sesa' slun ĩisxsa's sude'k, aça' beka yakh slun yakh e'zíi vxitu'tx. Txãa pa'ga beka u'sesa's slun u'sesate awwa'ja' jĩk. ");
INSERT INTO pbb_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Teeçx sapatu jxkaase ente', Jesusa' skuutxh ehsuk skhẽw. Aça' txãa yakh u'jusawe'sxa' skuutxhtxi çxuktedeçxa ũ'tx. ");
INSERT INTO pbb_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Aça' fxariseowe'sxa' na'wẽtx pẽjx: —¿Uyu'gá' idx yakh u'jusawe'sxa' ma'wẽçxata mjĩi en meetewa txã'wẽ yũ'? jĩte', ");
INSERT INTO pbb_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Jesusa' na'wẽk pas: —I'kwe'sxa' Dxus librute iilẽeymeewá'kwe Davxida' ¿kĩhga yuu? txãa yakh pi'kxna u'jusawe'sx yakh teeçx ente' wẽeçxa'. ");
INSERT INTO pbb_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Sacerdote npiiçthẽ'j Abiatar ente' dxuus yatte u'kaçxa, kxtee pantxi ũ'k, sa' txãa yakh u'jusatxwa ũsu'sku. Txãa pana' naasáa sacerdotewe'sxçxáa ũ'wa'the jiiçxawa txã'wẽk yũu. ");
INSERT INTO pbb_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","I'kwe'sxa' mjiyuwe: Jxkaase ena' nasatx selpiwa'jsa íiçxá', nawa suwwa'jsa yu' me'. ");
INSERT INTO pbb_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Txãa pa'ga Dxus Nçxi'k Nasa Yuusa' jxkaahwa'j ji'pha' makwe sapatu jxkaase entewa jĩk. ");
INSERT INTO pbb_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Vxite sapatu ente' Jesusa' ki'kin judiuwe'sx pkhaakheni yatte u'kak. Aça' kxte' teeçx piçthẽ'j teeçx kuse udxnisa kẽese'jya' ãjãsameek u'p yu'. ");
INSERT INTO pbb_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Aça' fxariseowe'sxa' Jesusa's peethegu'natx ũsu', sapatu jxkaase ente nuykatxhite' pãatxhĩ'khya' sũhçxa. ");
INSERT INTO pbb_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Txajũ' Jesusa' txãa piçthẽ'ja's pa'yaçxa nasaa pxãhte kxuuju'jçxa', ");
INSERT INTO pbb_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","na'wẽk paapẽjx vxite kxtee ũssatx: —Sapatu jxkaase entewa pu'çxte ¿ewmanx? meeçxa' ¿pu'çxwa'jmeemanx? Nasa's nwe'wete ¿ewmanx? meeçxa' nwe'wemeete ¿ewmanx? jĩte', txãawe'sxa' pasmée sxuuna'tx neeyũu. ");
INSERT INTO pbb_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Txã'wẽ fxariseowe'sxa' Jesus we'weni's jxpa'gaya' wa'lte', Jesusa' txãawe'sxtxi ũusçxa thegçxa na'jĩnak we'we txãa piçthẽ'j kuse udxnisa's: —Kuse's mku'le'j jĩçpkaçxha', txajx kuse' ewuuk. ");
INSERT INTO pbb_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Txajũ' fxariseowe'sxa' Jesusa's ikhya' puutx we'weya' u'jtx Herodes ju'gsawe'sx yakh. ");
INSERT INTO pbb_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Naapkaçxha' Jesusa' txãa yakh u'jusawe'sx yakh u'kh ĩkh wala pukan. Aça' Galileaju nasa wala kuh u'jtx Jesus e'stey. ");
INSERT INTO pbb_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Txã'wẽ Jesus kĩjkĩhwa ew yũuni's nasa jiyuçxa', majũwe'sxwa Jesus tasxte pa'jtx thegya', Judeajuwe'sx, Jerusalenuwe'sx, Idumeajuwe'sx, Jordan yu'wala kutejuwe'sx, vxite' Tiro, Sidon çxhab peeku'juwe'sxwa. ");
INSERT INTO pbb_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","10","Nasa txã'wẽ wala pa'the', maazkuẽe ãçã'satxwa nuykatxhik, aça' jxukaysa Jesusa's kpaajxa'dxçxa katxhi wẽesa txajx tasxteçxaçxáa utxaaçxa akaaçxpçxãhtx yuuna ũsu'. Txãa pa'gak Jesusa' txãa yakh u'jusawe'sxtxi jxkaah teeçx barko ih ji'phukahn akaaçxhiçte kxtee khẽewa'j. ");
INSERT INTO pbb_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Aça' eçx iiyamunisawe'sxa' Jesusa's uyçxa, txajx tasxte peejxũkwena na'jĩnatx we'we': —Idxa' Dxus Nçxi'kgu jĩte', ");
INSERT INTO pbb_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Jesusa' txãawe'sxtxi' wala juuna' we'wek kimtewa ãate kaajiyu'khamen. ");
INSERT INTO pbb_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Txãa e'su' Jesusa' thã'the u'kh kuh nasatx pi'kxçxa. ");
INSERT INTO pbb_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Aça' kxtee kãhçxa', doce nasatx txhitxhku txãa yakh u'juwa'jsa, txãawe'sxtxi' Dxus yuwe's pta'sxya' kaajxa'. ");
INSERT INTO pbb_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Txã'wẽ txhitxhçxa', ãçã'satxwa nuykatxhina eçx luuku vxit-satxwa ũusu kutxi'jya' ãjãwa'ja's ũsku. ");
INSERT INTO pbb_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Txãa doce nasa' na'wẽ yaaseta': Simon, txã'sa' Pedro yasek ki'p. ");
INSERT INTO pbb_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Vxite' Zebedeo nçxi'kwe'sx pxakhsa Jakobo Juanwe'sxtxi yu'. Txãa pxakhtxi' Boanerges jĩnatx kxsuusu', nasa juuna'sa pa'ga. ");
INSERT INTO pbb_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Vxite' Andrés, Fxelipe, Bartolomé, Mateo, Tomás, Alfxeo nçxi'k Jakobo, Tadeo, vxite' Simón kananista nasa, ");
INSERT INTO pbb_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","vxite' Judas Iskariote, Jesusa's açesawe'sx kusete dukhwa'jsa. Jesusa' thã'ju sxawedçxa', teeçx yattek u'ka, txajx txhitxhnisawe'sx yakh. ");
INSERT INTO pbb_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Txã'wẽy nasa iiméh wala kuh pkhaakhete', ũ'wa'j en yuhwa ji'phumeeta'. ");
INSERT INTO pbb_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Txajũ' Jesus nwe'sxa' txã'wẽ yũuni's jiyuçxa', Jesusa' luuku yuune' sũhçxa pe'jna u'jya' pa'jtx. ");
INSERT INTO pbb_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Aça' Dxus leya's kaapiya'jsawe'sxwa Jerusalenu pa'jçxa' na'jĩ'tx: —Naa piçthẽ'ja' eçxthẽ'ja's yuu ũuste ji'pha'. Txã'wẽçxaíik eçxtxi nasaa ũusuh kutxi'jya' ãjã' jĩte', ");
INSERT INTO pbb_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Jesusa' nasatx pa'yaçxa na'wẽk pta'sx jiyukahn: —¿Ma'wẽçxa eçxthẽ'ja' eçxthẽ'ja's íiçxáa kutxi'jya' ãjã'kx? ");
INSERT INTO pbb_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Maa kiwetewa gobierno' peekx nasatx íiçxáa ahçeçxa puiiçxa', çxhãçxhameena. ");
INSERT INTO pbb_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Txã'wẽy teeçx yattewe'sxwa puutx yahçena puiiçxa', pçuutxna puutx uuna. ");
INSERT INTO pbb_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Aça' txã'wẽy eçxthẽ'jwa txajx jxkaahnisa eçx yakh íiçxáa puiiçxa', çxhãçxhamée puutx pçuutxna. ");
INSERT INTO pbb_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Kim yuhwa ewteçxah yu' nkuusa'jya' ãjãmeetxna, yat namu khuẽ'ya's tudmeeçxa yu'. Aça' txã'wẽ tudçxa yuuçxáa nkuusa'jya' ãjãtxna. ");
INSERT INTO pbb_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","I'kwe'sxa' mpa'yajkxwe: Nasa naa kiwete kĩhwa ewmée yũuni kĩhwa Dxusna ewmée nuywe'wetewa txãatxi' jxuka ya'peltunaĩna. ");
INSERT INTO pbb_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Nawa Dxus Espiritu's açewe'wete', bagaçxte yuhwa peltunãynimée yuuna, uu kiwen kaahwa'jçxáa nvxiituna jĩk. ");
INSERT INTO pbb_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Nasa we'weçxa': Eçxthẽ'ja's ũuste ji'pha' jĩpa'gak txã'wẽ pta'sx Jesusa'. ");
INSERT INTO pbb_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Naapkaçxha' pa'jtx Jesus njĩ'j vxite' nyakhwe'sx jxuka. Sa' ekate kũhçxa, Jesusa's pa'yakaahtx. ");
INSERT INTO pbb_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Aça' Jesus yakh dxiite u'psa' pta'sxtxi na'jĩna: —Iidx mama iidx nyakhwe'sx pa'jçxa ekate ũsta', sa' idxa'stxi yuukaja' jĩte', ");
INSERT INTO pbb_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Jesusa' na'wẽk pas: —¿Kimtxikwe adx mama adx nyakhwe'sx jĩna we'wé'? ");
INSERT INTO pbb_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Sa' txã'wẽ pta'sxsatx thegçxa' na'jĩk: —Adx mama adx nyakhwe'sxa' naata'. ");
INSERT INTO pbb_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Dxus jxkaahni's nwẽese'jna kxtey yuusáa yuuçxáa, adx nyakh, adx npe'sx, adx mama na'wẽsata' jĩk. ");
INSERT INTO pbb_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Jesusa' ki'kin ĩkh wala pukate kaapiya'jya' kasehte', nasa iiméh wala kuh pkhaakheçxa utaaçte', Jesusa' barkote khẽeçxak pta'sx. Aça' nasa yu' ĩkh wala pukate neeyũutx wẽsẽ'jna. ");
INSERT INTO pbb_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Txajũ' kĩjkĩhwa pta'sxku ejemplo yakh kaaja'da'jna. Sa' na'wẽk kaapiya'j: ");
INSERT INTO pbb_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","—Mwẽesẽ'jwe: Skuutxh uuhsa' ujxa' kasejk. ");
INSERT INTO pbb_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Aça' mteeíi yu' dxi'jsu ãasu neeyũute', vxiçxakwe ũ'tx. ");
INSERT INTO pbb_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Vxite ahsu' kwet kajkwesutx neeyũu kiwe peççxáa ji'phsu. Sa' kiwe jwetmée ya'fxihbçxa' dudtxi buçxa. ");
INSERT INTO pbb_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Nawa sek açxaate' jxuka uhdxku, weçe dxiimeene' ji'phu' naa pa'ga. ");
INSERT INTO pbb_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Vxite ahsu' çhũçh ksxavxysutx ũsxi, aça' çhũçh walaaçxa jxuka aphte', çutmeeta'. ");
INSERT INTO pbb_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Vxite ahsu' kiwe ewsatek ũsxi, sa' buçxaçxa wala ew çuttxi. Maa tasxíi yu' treinta, vxite' sesenta, vxite' cien nxinxtxi çut. ");
INSERT INTO pbb_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Na'wẽ pta'sxthu txã'sa' jiyuwa'jsa ũsçxa', jiyune'kwe jĩk. ");
INSERT INTO pbb_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Txajũ' nasa kuhsa yu' u'the, Jesusçxáak neeyũu, doce txhitxhnisawe'sx vxite nasa yakh. Aça' txãawe'sxa' paapẽjxtxi txãa ejemplo's ma'jĩnitewa jiyuya'. ");
INSERT INTO pbb_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Aça' Jesusa' pta'sxku: —Dxus jxkaahni ensu ma'wẽ yũuwa'ja'swa kim yuhwa jiyunimeesa's i'kwe'sx yuutxi's kaajiyu'jwa'ja'. Nawa jiyuwa'jmeesatxi's ejemplo yakhçxáa pta'sxwa'ja', ");
INSERT INTO pbb_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","kxah uyçxawa, uysamée na'wẽçxáa neeyũutxna, sa' wẽsẽ'jçxawa, wẽsẽ'jsamée na'wẽçxáa neeyũuçxa Dxus tasxte sxawedmeetxna, aça' txãawe'sxtxi' Dxusa' peltunaĩmeena. ");
INSERT INTO pbb_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Txajũ' na'wẽk ãate kaajiyu'j: —I'kwe'sxa' naa ejemplo's jiyu'çmeewá'kwe. Txã'wẽçxa' ¿ma'wẽ vxite ejemplotxwa jiyuki'kwe? ");
INSERT INTO pbb_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Skuutxh uuhsa' Dxus yuwe's pta'sxsa na'wẽsa'. ");
INSERT INTO pbb_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Maa nasaíi yu' skuutxh fxiw dxi'jsu ũsxisáa na'wẽsata': Dxus yuwe's wẽsẽ'jçxa ũuste jxpa'gatewa, eçxthẽ'j pa'jçxa txãa yuwe's ũusu kutxi'jina. ");
INSERT INTO pbb_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Vxite nasa' skuutxh fxiw kwet kajkwesu ũsxisáa na'wẽsata': Dxus yuwe's ãçxhíi yu' weçxanatx jxpa'ga'. ");
INSERT INTO pbb_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Nawa ũusuh jxuka yajkxçxa jxpa'gameeçxa', Dxus yuwe's ahçeçxa pkxuuwa'j en pa'theçxáa txaçxmeyna wete'tx. ");
INSERT INTO pbb_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Aça' vxite nasa' skuutxh fxiw çhũçh ksxavxysu ũsxisáa na'wẽsata': txãawe'sxa' Dxus yuwe's wẽsẽ'thewa, ");
INSERT INTO pbb_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","naa kiwete kĩjkĩhwa ji'phu wẽenisaçxáa ũuste jxuka khẽeçxa Dxus yuwe yu'sa' kaapeçxkana'juna. ");
INSERT INTO pbb_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Nawa maa nasaíi yu' skuutxh fxiw kiwe ewsate ũsxiçxa ma'wẽta maaíi yu' treinta, vxite' sesenta vxite' cien nxinx pehna, txã'wẽ Dxus yuwe ũuste penawa'jsa'. ");
INSERT INTO pbb_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Txajũ' vxite ejemplo na'wẽk pta'sx: —Lampara's pki'taçxa ¿kaja dxiite meeçxa' atũu dxiite sũthnisatxná'? Txã'wẽ yũumée, lampara's ãatek ya'txaja', eena' kweethkahn. ");
INSERT INTO pbb_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Makwe sũttewa, uynimée yu' kĩh yuhwa neeyũumeena. Sa' txã'wẽy makwe ũusteçxáa yaakxnisa'swa jiyunimée yu' neeyũumeena. ");
INSERT INTO pbb_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Jiyuwa'jsa ũsçxa', jxpa'yakx mwẽesẽ'jwe jĩçxa', ");
INSERT INTO pbb_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","na'wẽk pta'sx: —Adx kaapiya'jni's jxpa'yakx mwẽesẽ'jwe. I'kwe'sx wa'lmée wẽsẽ'the', Dxusa' jxthaakwe kaajiyu'juna. ");
INSERT INTO pbb_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Dxus yuwe's jiyuwa'jsa's kaajiyu'jni yuuna. Nawa Dxus yuwe's jiyuwa'jmeesa's kaajiyu'jnimée yuuna jĩk. ");
INSERT INTO pbb_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Jesusa' vxite ejemplo pta'sxku: —Dxus naa kiwete jxkaajxa' pa'jnisa' na'wẽsa': Teeçx piçthẽ'j mjĩisa' fxiwa's kiwete uhçxaçxáa ");
INSERT INTO pbb_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","u'jwe'k sa' txaçxku thegya' pa'jaçmée. Aça' uuhnisa' buçxaçxa wala'k, nawa uuhsa yu' jiimeek yu' ma'wẽ buçxana walaaçtewa. ");
INSERT INTO pbb_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Fxiwa' kiwete ujxã'the', peekxçxáa buçxa'k kĩhwa yuumeetewa, nyafxte' tasx khuẽ'y wala'k, txã'wẽ yuuçxak spiiga kaseje', txãa e'su'k nxinx kaseje', ");
INSERT INTO pbb_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","aça' thẽ'j ente', pkhakhya' kaseje'tx. ");
INSERT INTO pbb_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Vxite ejemplok pta'sx Jesusa': —Dxus naa kiwete jxkaajxa' takhnisa's ¿kĩh yakh kaaja'da'ja'kxtha'w aç jiyuki'kwe? ");
INSERT INTO pbb_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Mostasa fxiw na'wẽsa' aça' txãa yakh kaaja'da'ja'nja'w. Txãa fxiwa' maa maa fxiwtewa thaakwe musekuẽta', ");
INSERT INTO pbb_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","nawa kiwete ujxã'the', maa ẽjxã tasxtewa jxthaakwek waláa, seena' wala çxhã'px kasehna. Aça' vxiçxakwe yuhwa txãa ẽjxã ksxavxysu yaat-ya' ãjã'tx. Naa kiwete Dxus jxkaajxa' takhnisa' txã'wẽysa'. ");
INSERT INTO pbb_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Jesusa' Dxus yuwe's txã'wẽk pta'sxi' wala kuh ejemplo kutxi'jna, jiyuwa'jsa' jiyuya' ãjãkahn. ");
INSERT INTO pbb_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ejemplo ji'phmée yu' kaapiya'ja'çme'. Nawa txãa yakh u'jusawe'sx yuutxi's kĩh ejemplo'swa jxuka khiyu'jçxak nvxiitu'. ");
INSERT INTO pbb_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Txãa entey çxhi'dxna kĩjaçte', Jesusa' na'jĩk txãa yakh u'jusawe'sxtxi': —U'jwega ĩkh wala kuten jĩte', ");
INSERT INTO pbb_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","nasatx nvxihtna' Jesusa's pe'jna u'jtx txãawe'sx khẽeçxa u'pni barkote. Aça' vxite barkowa ihtey u'jtx. ");
INSERT INTO pbb_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Ĩkh wala pxãjũy u'jweçpkaçxha', wejxaa wala kiiteçxa barko's ĩkh dxiikhẽ akhya'wak yu', yu'a's barkote yuutaçxa. ");
INSERT INTO pbb_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Naapkaçxha' Jesusa' deenik yu', barko e'ste kaçxçxa dxikthe's peedxikiga khikhçxa. Aça' txãa yakh u'jusawe'sxa' Jesusa's fxĩtxtxi na'jĩna: —Ĩkh dxiikhẽ khẽjeçtha'w aça' ¿kwe'sxtxi' peeygãja'çmeega'? jĩte', ");
INSERT INTO pbb_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Jesusa' kiiteçxa, wejxa's we'wek yujukahn petx ĩkh yã'jçxa. Naapkaçxha' wejxa yujute', ĩkhwa yujuk. ");
INSERT INTO pbb_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Txajũ' Jesusa' txãa yakh u'jusawe'sxtxi' na'jĩk: ¿Kĩh yuuçxakwe Dxus yu's yajkxmée txakwe wala ũukhú'? jĩk. ");
INSERT INTO pbb_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Txã'wẽ wejxa yuhwa nwẽese'the', txãawe'sxa' wala kuh yajkxna neeyũutx na'jĩna: —Naa piçthẽ'ja' ¿kim yujkx, açki'tx wejxa ĩkh txã'wẽsa yuhwa nwẽesẽ'jé'? jĩ'tx. ");
INSERT INTO pbb_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Txajũ' ĩkh wala kute Gadara kiwete pa'jtx. ");
INSERT INTO pbb_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Aça' Jesus barkoju kasejeçpkaçxha', teeçx piçthẽ'j eçx iiyamunisa uusáa pedani kafxu kasehçxa Jesus tasxte utxaak. ");
INSERT INTO pbb_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Txãa piçthẽ'ja' uusáa pedani kafxsuk u'psa yu', aça' txã'sa' kim yuhwa çam kadenaju tudçxa jxpe'jya' ãjã'çmeeta'. ");
INSERT INTO pbb_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Çxida petx kuse yã'jçxa maazkuẽe uswa tudtewa, nuywejiméek çxuktedeçxa pũsxi'. Aça' kim yuhwa ãjã'çmeeta' tudçxa jxpe'jya' yu'. ");
INSERT INTO pbb_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","En ma'k yuu kus ma'k yuu nawa vxiçsu vxite' uusáa pedani kafxsu weynak pekũjũ' kwet-su kpã'yuuna. ");
INSERT INTO pbb_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Nawa Jesusa's jxu'the uyçxa', wuwuuna u'jçxa txajx tasxte peejxũkwek ");
INSERT INTO pbb_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","sus we'wena: —¿Adxa's kĩh yũuya'waga? Jesus, Dxus ĩtxĩsa Nçxi'k. Dxus pa'ga adxa's peeygãhçxa txakwe seena' wala nxuste yu' kaahnu jĩk. ");
INSERT INTO pbb_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Jesusa' eçx luuku vxit-sa's we'weçxa': Naa piçthẽ'j ũusu mkaaseh jĩpa'gak txã'jĩ'. ");
INSERT INTO pbb_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Txajũ' Jesusa' pẽjxku: —¿Kĩh yaasega? jĩte', pta'sxku: —Legion yaaseth, wala kuhtha'w naa pa'ga jĩk. ");
INSERT INTO pbb_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Sa' txãa eçx luuku vxit-sa' wala pxthaa we'wek txãa kiwejũ kutxi'khamen. ");
INSERT INTO pbb_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Txajũ' kxsũ vxiç ja'dasũ wala kuçxi ũsu'tx aphna. ");
INSERT INTO pbb_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Aça' eçx luuku vxit-sa' na'jĩnatx pxthaa we'we: —Kuçxi ũuste khẽeya' u'khan kwe'sxtxi mkaah jĩte', ");
INSERT INTO pbb_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Jesusa' txãa eçx luuku vxit-satx kuçxi ũuste u'kaya' kaakh. Txajũ' txãa eçx luuku vxit-sa kuçxi ũuste khẽete', kuçxi' luuku yuuçxa penxakhẽ peluçxa yu'teçxaçxáa khẽeçxa jxuka uutx. Txãa kuçxi' dos mil ãhtx yu'; ");
INSERT INTO pbb_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Txã'wẽ yũute', kuçxi thegsa ũukhçxa wala dud pta'sxya' u'jtx çxhabsu vxite' çxhab ekaju jxuka. Aça' nasa' wala pa'jtx thegya', kĩh yũutewa uyya'. ");
INSERT INTO pbb_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Sa' Jesus ũsnite pa'jçxa uytxi txãa piçthẽ'j eçx luuku vxitnisa' wẽt yã'j ropa ji'ph u'pte. Txã'wẽ uyçxa wala ũukhtxi. ");
INSERT INTO pbb_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Txajũ' ma'wẽ yũuçxa eçx luuku vxitnisa katxhini vxite' kĩh yũuçxa kuçxi uuni'swa uysaawe'sxa' jxuka pta'sxtxi nasa thegya' pa'jsatxi's. ");
INSERT INTO pbb_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Txajũ' nasa' Jesusa's ũusçxa we'wetx txãawe'sx kiwejũ u'khan. ");
INSERT INTO pbb_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Aça' Jesusa' ki' sxawedxa' barkote khẽjeçpkaçxha', eçx luuku vxitnijũ katxhisa' wala pxthaa we'wek pe'jçxa u'khan. ");
INSERT INTO pbb_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Nawa Jesusa' pe'jna u'jmée na'wẽk jxkaah: —Iidx yatna me'j, sa' iidx nwe'sxtxi pta'sxine'ga idxa's Dxus peeygãhçxa ma'wẽ ew yũuni'swa. ");
INSERT INTO pbb_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Txajũ' txãa piçthẽ'ja' u'jçxa, Dekapolis çxhabsu jxuka pta'sxku Jesus ma'wẽ yũuçxa nuykatxhini'swa. Aça' nasa' wala kuh yaaki'tx jxukaysa. ");
INSERT INTO pbb_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Txajũ' Jesusa' ĩkh wala kutejũ barkote khẽeçxa pesahçxa kxtee ũste', nasa wala pa'jtx txajx ũsnite. ");
INSERT INTO pbb_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Aça' judiuwe'sx pkhaakhenite npiiçthẽ'jsa Jairo yaasesa' Jesus tasxte peejxũkweçxa ");
INSERT INTO pbb_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","na'wẽk pxthaa we'we: —Adx niisakuẽ' uuçyã'ja', aça' uukahmén myuh jxa'dxya' iidx kuseju jĩte', ");
INSERT INTO pbb_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","txãa yakh u'kh Jesusa'. Aça' nasa iiméh wala pehnaçxa, dxi'the zuuna'çxáatx u'jweç yu'. ");
INSERT INTO pbb_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Aça' txãa nasa ksxavxyte teeçx u'y kakwe yu' vxyaate doce anxuyã'j ãçã'na u'jusak kaseh. ");
INSERT INTO pbb_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Sa' txãa ãçã'sa' wala pxthaa yuusa yu'k yu'çe'jsatx paapẽjxna. Sa' makwe yu'çe weyna txajx ji'phuni jxuka pçuutewa, kĩh yuhwa yu'çe yuumée jweeíiçxáak jxthaakwena u'jweç yu'. ");
INSERT INTO pbb_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Txajũ' txãa u'ya' Jesus kĩh yũusaatewa jiyuçxa' paaçte e'su kũhçxa, kpaajxa'dxku txajx atxhkhẽ. ");
INSERT INTO pbb_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Txã'wẽ Jesus atxhkhẽ kpaajxa'dxçxaçxáa katxhi'nja sũhçxak txã'wẽ yũu. ");
INSERT INTO pbb_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Sa' txã'wẽ jxa'dxiçpkaçxha', kakwe yu' vxyaame', aça' txãa dudtey txajx kakwete wẽt yã'kh yajkx. ");
INSERT INTO pbb_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Txajũ' Jesusa' teeçx ãçã'sa txajx atxhkhẽ jxa'dxçxa katxhini's jiyuk, sa' nasaa ksxavxyte u'jweçíi yu'thegçxa', na'jĩk: —¿Kimga adx atxhkhẽ jxa'dx? jĩte', ");
INSERT INTO pbb_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Pedrowe'sxa' na'wẽtx pas: —Nasaa ksxavxyte zuuna'çxáa u'jweçgu sa' ¿ma'wẽga kimga jxa'dx jĩna we'wé'? jĩtewa, ");
INSERT INTO pbb_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Jesusa' nasaa ksxavxysu thegu'gku kim jxa'dxtewa uyya'. ");
INSERT INTO pbb_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Txajũ' txãa u'ya' txã'wẽ naa dudte ew katxhini's ĩsxiimée pta'sxna ũukhna Jesus tasxte yayan kũhçxa peejxũkwek. ");
INSERT INTO pbb_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Aça' Jesusa' na'wẽk we'we: —I'kwe' ũusuh jxuka yajkxçxane'kwe katxhiya' sũhçxa adx tasxte utxáa, txãa pa'ga katxhini i'kwe neeyũu. Ãçxha' ãçã'mée wẽt me'jwe weçxana jĩk. ");
INSERT INTO pbb_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Jesusa' txã'wẽ we'wena nee ũsiyna, Jairo yatu yuusa kũhçxa' Jairo's pta'sxtxi: —Iidx niisakuẽ' uuyã'kh, aça' kuçx pa'pçxunu kaapiya'jsa's pe'jna u'jya' jĩte', ");
INSERT INTO pbb_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Jesusa' wẽsẽ'jçxa, Jairo's kvxiisxa'kh na'jĩna: —Nxusnu. Adx ewuwa'ja'sçxáa myajkx jĩçxa', ");
INSERT INTO pbb_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Jesusa' vxite yuutxi's pe'jmée, pxakhsa Jakobo Juan vxite' Pedro txãawe'sxçxáatxku pe'jçxa u'j. ");
INSERT INTO pbb_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Sa' Jairo yatte pa'jçxa', uyku nasa wala ũ'nena ũste. ");
INSERT INTO pbb_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Sa' dxiite u'kaçxa we'wek: —¿Kĩjxa'kwe txakwe wala ũ'né'? Luuçxa' uunime', Ĩ'neeçxáa deeni' jĩte', ");
INSERT INTO pbb_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","nasa' Jesusa's npeevxysxijkatx. Aça' Jesusa' nasatx jxuka eka kutxi'jçxa, txãa luuçx neywe'sx vxite' txãa yakh yuusa tekhsa txãawe'sx yakh uusáa ũsnite utxaaçxa, ");
INSERT INTO pbb_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","kuseju pu'kisçxa na'wẽk we'we: —Talita kumi—txã' na'jĩni': Ijçxa'sthu we'we' mkiiteçx jĩni'. ");
INSERT INTO pbb_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Txã'jĩçpkaçxha' txãa uusá' kiiteçxa u'juya' ãjãk. Aça' Jesus txã'wẽ uusá's ki' ĩtxĩ vxitte uyçxa', wala kuh yajkxtxi. ");
INSERT INTO pbb_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Txajũ' Jesusa' wala neewe'wek maa yuhtxwa pta'sxkahmén, sa' txãa luuçxa's puuçkaakh. Txãa luuçxa' doce anxu ji'phsak yu'. ");
INSERT INTO pbb_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jesusa' txãa çxhabu kasehçxa', txajx u'pni çxhab Nasaretnak sxawedna u'j txãa yakh u'jusawe'sx yakh. ");
INSERT INTO pbb_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Sa' sapatu jxkaase ente' judiuwe'sx pkhaakhenitek kaapiya'jna ũsu', aça' nasa jxukaysa wẽsẽ'jçxa', kuh yajkxna na'jĩtx: —Naa piçthẽ'ja' ¿mteega txakwe wala kĩjxa'wa piya? ¿Kim kaapiya'theki'k txakwe wala kĩjkĩh yũuya'wa ãjã'? ");
INSERT INTO pbb_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Naaíi kwe'sx jiyunisa karpintero' Maria nçxi'k. Sa' txajx nyakhtxiwa jiitha'w, Jakobo, Jose, Judas, Simon txãawe'sxta'. Aça' txajx npe'sxwe'sxwa naa çxhabtey u'pta'. Txã'wẽ kwe'sx jiyunisa' jĩçxatx Jesus kaapiya'jni's nwẽesẽ'jya' wa'l. ");
INSERT INTO pbb_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Txajũ' Jesusa' na'wẽk we'we txãa nasatx: —Mteewe'sxwa Dxus yuwe pta'sxsa yu'sa' wa'lmeetx jxpa'ga'. Nawa peekx kiwetewe'sx yu' jxpa'ga'çmeeta' vxite' peekx nwe'sx, peekx yattewe'sx. ");
INSERT INTO pbb_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Txã'jĩçxa' kxteea' mazkuẽçxáa nuykatxhiçxaçxáa jwee yu' kĩhwa yũume'. ");
INSERT INTO pbb_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Sa' Jesusa' nxusnak neeyũu, txã'wẽ txajx kiwetewe'sx nwẽesẽ'jmeete. Txajũ' Jesusa' vxite çxhabsuk pta'sxya' kaseh. ");
INSERT INTO pbb_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Sa' txãa yakh u'jusa docesatx pa'yaçxa', eçx luuku vxit-satx nasa ũusu kutxi'jya' ãjãwa'ja's ũsçxa', e'z e'zku kaah. ");
INSERT INTO pbb_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Nawa khãabuçxá's atçxa kĩh yuhwa tu'sméek u'khaah, ya'ja, vxyu, kaame txã'wẽsatx. ");
INSERT INTO pbb_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Sa' pelgatxiçxáa paatçxa teeçx kmiisa yakhçxáak u'khaah. ");
INSERT INTO pbb_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Sa' na'wẽ yũuwa'ja'sku pta'sx: Maa yatte paadejxa' pa'jyã'jçxa', kxteeçxáa paadehna ũsune'kwe txajũ ki' kasehna u'phkaçx. ");
INSERT INTO pbb_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Sa' mteeíi yu' i'kwe'sx pta'sxni's wẽsẽ'j wẽemeeçxa yat pki'jmeete', txãajũ kasejene'kwe i'kwe'sx çxidate kiwe tuhda's sakweekweçxa, kxah yuuwesa yuutxna. Isath we'we': Dxus kastigãywa'j en ãhte', txãawe'sxa' Sodoma Gomoçxa çxhabtewe'sxte jxthaakwe kastigo's knayuutxna txã'wẽ i'kwe'sxtxi jxpa'gaya' wa'lpa'ga. ");
INSERT INTO pbb_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Txã'wẽ Jesus jxkaahte', txãawe'sxa' kasehtx Dxus yuwe's pta'sxna, pkaltxi nvxihtçxa Dxus tasxte misxawedwe jĩna. ");
INSERT INTO pbb_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Sa' eçx luuku vxit-satxwa nasa ũusu kutxi'jna maazkuẽe ãçã'satxwa aceite dxikthekhẽ awna nuykatxhitx. ");
INSERT INTO pbb_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Txã'wẽ Jesus kĩjkĩhwa ew yũuni's ne'jwe'sx Herodes jiyuçxa': —Juan Bautistane' uuçxawa ki' ĩtxĩ yuu, txãasane' kĩjkĩh yũuya'wa ãjã' jĩte', ");
INSERT INTO pbb_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","vxite nasa we'weçxa': —Naa piçthẽ'ja' Dxus yuwe pta'sxsa Eliasna jĩ'tx. Naapkaçxha' vxite we'weçxa': —Txãniiteywa ma'wẽta Dxus yuwe pta'sxsa kaseje', txã'wẽysana jĩnatx ũsu'. ");
INSERT INTO pbb_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Nasa txã'wẽ we'wete', Herodeswa we'weçxa': —Juan Bautista txhikha's na'wẽ kaaspẽ'the'th txãane' ki' ĩtxĩ yuuçxa kiite jĩk. ");
INSERT INTO pbb_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Herodesa' Juana's na'wẽ yuuçxaga kiikhe'j: Herodesa' Juana's kadenaju tudçxa karcelte ktxaaja'khu'ga, Herodias ahçeçxa ewmée yuwe ũspa'ga. Txãa Herodiasa' Fxelipe nyuuk yu', aça' Fxelipe yu' Herodes nyakhíiçxáak yu'. Nawa Herodesa' Fxelipe nyu Herodiasa's kusa'jçxa txajx nyu na'wẽk jxpe'j. ");
INSERT INTO pbb_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Txãa pa'ga ku'ga Juana' Herodesa's na'jĩna yu'kxpeh: Iidx yakhthẽ'j nyu's kusa'jçxa' iidx nyu na'wẽ jxpe'jni' ewme' jĩni's ");
INSERT INTO pbb_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Herodias jiyuçxa', Juana's ahçeçxa ikh wẽeçxawa ãjã'çmeeku'ga. ");
INSERT INTO pbb_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Juana's Herodias ikhya' ãjãkahmén, Herodesa' karcelteku'ga ktxaaja'j nwe'wena. Juana' Dxus dxi'pte kĩhte yuhwa jxpubamée wala ew fxi'zesatewa Herodesa' jiine' yu', txãasane' ũukhçxa nwe'we, sa' Juan pta'sxni's Herodesa' kxtey yuuçmeeçxawa wa'lmeeku'ga weçxana wẽsẽ'je'. ");
INSERT INTO pbb_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Herodesa' txajx upxni en anxu ãa iisak fxiesta vxitu'. Txãasak teeçx ente' fxiesta ki'p txajx jxkaahni npiiçthẽ'jsa vxite' Galileate jxtuhthesatx pi'kxçxa. Txãa fxiestatene' Herodiasa' Juana's ewmée yũuwa'ja's uy. ");
INSERT INTO pbb_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Txajũ' Herodias niisa' txãa fxiestate pa'jçxa' wala zhiçxkwe ku'jne' pi'kxnasa dxi'pte. Aça' ne'jwe'sx Herodes uyçxa' na'jĩku'ga txãa kna'sa's: —Ijçxa kĩh pẽjxtewa, adxa' ũsu'nja. ");
INSERT INTO pbb_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Dxus uyte, içxa pẽyni's kĩhnawa ũsuçxá'nja, meeçxa' adx jxkaahna ũsni kiwe's pẽjxyuhtewa pxãhn txuhdeçxa ũsu'nja jĩte', ");
INSERT INTO pbb_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","txãa kna'sa' kasehna u'jçxa, txajx njĩ'ja'sku'ga paapẽjx: —¿Kĩh pẽyi'ki'th? jĩna. Aça' njĩ'j pasçxa': —Juan Bautista dxikthea's mpẽyçxi jĩnaku'ga jxkaah. ");
INSERT INTO pbb_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Txajũ' txãa kna'sa' Herodes tasxte ki' kũhçxa': —Ãçxhíi Juan Bautista dxikthea's plaatute akhçxa mah jĩte', ");
INSERT INTO pbb_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","ne'jwe'sx Herodesa': Kĩh pẽjxtewa ũsu'nja jĩna nasaa dxi'pte jurãyyã'jçxa', ĩsxiiya' ãjãmeeku'ga. ");
INSERT INTO pbb_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Txajũ' Herodesa' dudtey teeçx soldau's kaakhu'ga Juan dxikthea's nikxya'. ");
INSERT INTO pbb_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Aça' txãa soldau' karcelna u'jçxa', Juan txhikha's spẽ'thçxa, plaatute akhçxa jxũna kũjku'ga txãa kna'sa's ũsya'. Aça' txãa yu' jxpa'gaçxa', txajx njĩ'ja'sku'ga dukh. ");
INSERT INTO pbb_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Txã'wẽ yũute', Juan yakh u'jusawe'sx jiyuçxa', txãa uuni kakwe's kiisçxa pedaaku'ta. Txã'wẽ yũuni'sne' Herodesa' yajkx. ");
INSERT INTO pbb_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Txã'wẽ e'z e'z jxkaahnisawe'sxa' Jesus tasxte ki' sxawedna pa'jçxa', txãawe'sx ma'wẽ kaapiya'jna kĩhçxa yũuçxawa Jesusa's jxuka pta'sxtxi. ");
INSERT INTO pbb_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Txã'wẽ nasa txakwe wala pa'jna ũste', txãawe'sxa' ũ'wa'j en yuhwa uyméetx fxi'zena ũsu'. Txãa pa'gak Jesus we'weçxa': —Mejkawe, dudte jxkaaseya' nasaa yatmeesu jĩ'. ");
INSERT INTO pbb_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Txajũ' Jesusa' txãa yakh u'jusawe'sxçxáatx pe'jçxa, barkote khẽeçxa u'kh, nasaa yatmeesu pa'jçxa jxkaaseya'. ");
INSERT INTO pbb_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Txã'wẽ Jesus u'jweçte nasa wala uyçxa', mtee pa'jya' u'jweçtewa jiyutx. Txãasatx txãawe'sx khuẽ'y yaçte pa'j Jesus pa'jwa'the maa çxhabuwe'sxwa wuwuuçxáa u'jçxa. ");
INSERT INTO pbb_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Aça' Jesus barkoju kasejeççxa', uyku nasa wala kuh pkhaakhena ũste. Sa' txãawe'sxtxi's peeygãjk txã'wẽ piisxáa namu ji'phmeesa na'wẽ txãawe'sxçxáa ũste. Txajũ' Dxus yuwe's wala kaapiya'kh. ");
INSERT INTO pbb_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Kxtee kaapiya'jna ũsiyna kusuçte', txãa yakh u'jusawe'sxa' txajx tasxte utxaaçxa na'wẽtx we'we: —Aysu nasaa yatmeete ũsiyna, kusuça'. ");
INSERT INTO pbb_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Aça' nasatxi' mkaah, kxah yat-su meeçxawa çxhabkuẽ utxasu ũsta' kxsũ pa'jçxa ũ'wa'j weyuutxna. Txã'wẽme' ayte' kĩhwa ji'phmeeta' jĩte', ");
INSERT INTO pbb_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Jesus pasçxa': —I'kwe'sx mpuuçwe jĩnak jxkaah. Aça' txãawe'sxa' na'wẽtx pas: —Kwe'sxa' doscientos peso pan weyya' u'jçxa puuçuwá'nja'w jĩte', ");
INSERT INTO pbb_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Jesusa' pẽjxku: —¿Maz pan ji'phkwe? Me'jwe thegya' jĩna. Aça' pan uyçxa', pta'sxtxi: —Tahç pan, e'z wedxçxáatha'w uy jĩna. ");
INSERT INTO pbb_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Txajũ' Jesusa' nasatxi' txaksũ kaçxkaakh fxiifxii txuteeçxa. ");
INSERT INTO pbb_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Aça' cien ãh vxite' cinkwenta kxaztxi fxiifxii txuteeçxa kaçx. ");
INSERT INTO pbb_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Naapkaçxha' Jesusa' tahç pan e'z wedxtxi uweçxa, cielute pagayçxa Dxusa's weçxana'wa pantxi pe'ltedeçxa txãa yakh u'jusawe'sxtxi' ũsku, nasatx jxuka ũsu'skahn. Sa' wedxtxiwa txã'wẽyku ũsu's jxukaysatx. ");
INSERT INTO pbb_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Txã'wẽ yũute', jxukaysa ũ'çxa txiktxi neeyũu. ");
INSERT INTO pbb_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Txajũ' txãa pan vxite' wedx pe'ltedenisa neeyũute' pkhakhçxa', doce kanastate utatx pkhakh. ");
INSERT INTO pbb_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Aça' nasa yu' piçthẽ'jçxáatx isani cinko mil ãhtx yu'. ");
INSERT INTO pbb_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Txajũ' Jesusa' txãa yakh u'jusawe'sxtxi barkote kaateka'jçxa yaçte kaakh Beçaidan. Txã'wẽ yũuçxa' txãa yu' kxtee neeyũuk nasa txuteena u'jsatx weçxana. ");
INSERT INTO pbb_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Sa' nasa jxuka txuteena u'jweçpkaçxha', Dxus yakh puutx we'weya' u'kh thã'the. ");
INSERT INTO pbb_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Jxuka çxhi'dxna jxã'jaçte', barko' ĩkh pxãjũy u'jweçku yu', Nawa Jesus yu', ĩkh kutetee ũsíiçxáak yu'. ");
INSERT INTO pbb_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Sa' khikhyna sẽjeçte', Jesusa' uyku Beçaidan u'jsawe'sxtxi's wejxa yupte, barko's kaajxa' çxhãçxhamée ĩkhsu u'jute. Txajũ', Jesusa' txãawe'sxtxi kpajkxya' ĩkhsu u'jçxa, txãawe'sx pukasu utxa sẽhçxa, barko's phyahçna skhẽuuçku yu'. ");
INSERT INTO pbb_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Aça' barkote u'jsawe'sxa' txã'wẽ ĩkhsu u'jweçte uyçxa', eçxa'stha'w uy sũhçxa sustxi pebée. ");
INSERT INTO pbb_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Txã'sa' jxukaysatx uyçxa ũukh. Naapkaçxha' Jesusa' we'wek: —Ũukhnuwe. Adxthu jĩna. ");
INSERT INTO pbb_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Txajũ' Jesusa' barkote khẽjeçpkaçxha', wejxa' yujuk. Aça' txãawe'sxa' iiméh wala ũukh yajkxna kuh we'wenatx neeyũu. ");
INSERT INTO pbb_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Txã'wẽ Dxus Nçxi'kçxa kĩjxa'wa ãjãwa'jsaçxak kuhmée pan yakh nasa txaazkuẽesatx sã'jĩ' sũhwa'j yu'sa' ji'phmeene'ta yu', txãasatx txakwe wala kuh yajkxna neeyũu. ");
INSERT INTO pbb_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Txajũ' Genesaret kiwete pesahçxa', barko's ĩkh pukatetx tudçxa txah. ");
INSERT INTO pbb_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Aça' barkoju sa'jaçpkaçxha', txãa kiwesuwe'sx nasa' jiyutx Jesus pa'jni's. ");
INSERT INTO pbb_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Sa' txãa kiwesu ãçã'satx jxuka pkhakhçxa yakhna pa'jtx Jesus mtee ũstewa. ");
INSERT INTO pbb_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Txajũ' Jesusa' çxhabna ma'k u'j, meeçxa' yat-su ma'k pa'jya' u'j, meeçxa' dxi'the ma'k u'jweç yuu nawa txajx skhẽwwa'jsutx ãçã'satx khikhe'. Txã'wẽ yũuçxatx skhẽuuçte' wala pxthaa we'we', txajx atxh vxiçteçxáawa ãçã'satx khya'dxi'khan. Aça' maawa txajx atxh vxiçteçxáawa jxa'dxsa', jxuka katxhiçxatx neeyũ'. ");
INSERT INTO pbb_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Txajũ' fxariseowe'sx vxite' Dxus leya's kaapiya'jsawe'sxwa Jerusalenu pa'jçxa Jesus tasxte utxaatx thegya'. ");
INSERT INTO pbb_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Aça' Jesus yakh u'jusawe'sxa' kusekhẽ' yu' kaahmée ũ'weçte uyçxa', açewe'wetx fxariseowe'sxa'. ");
INSERT INTO pbb_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Yaçgawe'sx ma'wẽ jxkaathe' Judiuwe'sxa' jxukaysa na'wẽ kuh jwed yũuwa'ja'stxi nwẽesẽ'jẽ' ewmeesa pẽethekahmén jĩçxa: ");
INSERT INTO pbb_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Merkaujũ pa'jçxa', kusekhẽ yu' kaahwa'ja' jĩ'tx. Sa' waso, mitxh, kĩhwa iijxũni çam yuutxi' jxuka kajkwekhẽ yu' kaahçxa iijxũwa'ja' jĩnatx kaapiya'ja'.) ");
INSERT INTO pbb_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Txãasatx fxariseowe'sx vxite' Dxus leya's kaapiya'jsawe'sxa' na'jĩna Jesusa's pẽjx: —Idx yakh u'jusawe'sxa' ¿kĩh yũuçxata yaçgawe'sx kaapiya'jnitxi' kxtey yu'çmée, kusekhẽ yu' kaahmée ũ'wé'? jĩte', ");
INSERT INTO pbb_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Jesusa' na'wẽk pas: —I'kwe'sxa' yuwejuçxáa ew we'weçxa', ũuste yu' ewméeçxáa yaakxsai'kwe aça' Isaiasa' isa yuh Dxus we'weni's na'jĩna fxi'jne': Naa nasa' yuweju yu' adxa's yaaki'tha'w jĩçxawa, Ũusuh yu' adxa's yaaki'çmeeta'. ");
INSERT INTO pbb_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Naa kiwete nasaa kaapiya'jniçxá's kxtey yuuna ũsçxa, Txã'wẽ Dxus jxkaahni'stha'w kxtey yu' jĩte', kxul yuhna jĩna Dxus we'weni'sku fxi'j Isaiasa'. ");
INSERT INTO pbb_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","I'kwe'sxa' Dxus jxkaahni yu'sa' nvxihtçxa, naa kiwega nasaa kaapiya'jniçxá's i'kwe nwẽesẽ'jna wala ew ki'su' na'wẽ yũuna: waso, mitxh, kĩjkĩhtxwa txã'wẽ i'kwe ki'su' yu' kaahna. ");
INSERT INTO pbb_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Na'jĩ'th na': i'kwe'sxa' naa kiwega nasaa kaapiya'jniçxá's nwẽesẽ'jna ki'sçxa', Dxus jxkaahni yu'sa' nvxihti'kwe. ");
INSERT INTO pbb_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","I'kwe'sx na'wẽ yũuni's myajkxwe wakx: Moisesa' na'jĩnak fxi'j: Iidx tata iidx mama txãawe'sxtxi' peeygãhna pu'çxwa'ja' jĩ'k. Aça' txã'wẽ yũumée, neywe'sxtxi açewe'wesa' uu ena's ji'phuna jĩ'k. ");
INSERT INTO pbb_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","13","I'kwe'sx yaçgawe'sxa' na'wẽtx kaapiya'ja': Maa nasawa neywe'sxtxi peeygãhna pu'çxmée, adx ji'phuni i'kwe'sxtxi pu'çxwa'ja's Dxusna dukhe'nja jĩna we'weçxaçxáa, neywe'sxtxi' pu'çxmeetewa ewa' jĩ'tx. Nawa i'kwe'sxa' txã'wẽ yaçgawe'sx kaapiya'jniçxá's kxtey nwẽese'jçxa', Dxus jxkaahni yu'sa' kxtey yu'çmeei'kwe, naasáa Dxus jxkaahnimeeçxáatx i'kwe kĩjkĩhnawa jxuka kxtey yu'. ");
INSERT INTO pbb_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Jesusa' ki'kin nasatx we'weçxa' na'jĩk: —Mwẽesẽ'jwe jxukaysa, ew jiyuya': ");
INSERT INTO pbb_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Kĩh ũ'wa tutxhteçxáa khẽesa yu', nasatx ewmeesa vxitu'çme'. Naasáa ũusuh ewmée yaakxnisa yuuçxáak nasatx ewmeesa vxitu'. ");
INSERT INTO pbb_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Aça' maawa jiyuwa'jsa ũsçxa', jiyune'kwe jĩçxak nvxiht. ");
INSERT INTO pbb_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Txajũ' Jesusa' nasatx txuteeçxa' yattek u'ka. Aça' txãa yakh u'jusawe'sxa' jiyumeeçxa' pẽjxtxi txã'wẽ pta'sxni's. ");
INSERT INTO pbb_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Aça' Jesusa' na'wẽk we'wena pta'sx: —¿I'kwe'sxwa jiyu'çmeewá'kwe? Kĩh ũ'wa tutxhteçxáa khẽeçxa', nasatx ewméesa yu' vxitmeena sũju'çmeewá'kwe. ");
INSERT INTO pbb_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Txãa pa'gatey kĩh ũ'wa ũuste yu' u'kamée tutxhteçxáa khẽeçxa', txajũ ki' kaseje'k jĩk. Jesusa' txã'wẽ we'weçxa': ũ'nisa yu' kĩhwa jxuka ewsaçxaçxáata' jĩçxak txã'jĩ'. ");
INSERT INTO pbb_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Nawa ũusuh ewmée yaakxnisa yuuçxáak nasa's ewmeesa vxitu'. ");
INSERT INTO pbb_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Txãa pa'gatey, kazx yaakxni, ptamsaçxawa vxite yakh kazx yuuna fxi'zeni, kazx yuuni, nasa ikhni, ");
INSERT INTO pbb_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","pesweeni, vxite jĩ's kusa'jçxa ji'phu wẽeni, pthãaweni, ĩsxĩini, vxitetx ahçena fxi'zeni, wẽesxuni, kazx we'wena fxi'zeni, iiwejçx iiwejçx yajkxna fxi'zeni, kĩhtewa ewmeeçxáa yũuna fxi'zeni ");
INSERT INTO pbb_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","txã'wẽ ewmée yaakxnisa' ũustewe'sxta'. Txãasatx txã'wẽ kaaũusuthe'jçxa, nasa's ewmeesa vxitu'. ");
INSERT INTO pbb_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Jesusa' txãajũ kasehçxa', Tiro Sidon çxhab ja'dasuk pekũjxa' u'j. Sa' kxsũ pa'jçxa', teeçx yatte u'kaçxa, kim yuhwa jiyu jxthãasme'. Nawa kim yuhwa jiyunimeete u'juya' yu' ãjãme'. ");
INSERT INTO pbb_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Txajũ' teeçx u'y Sirofxenicia kiwetewe'sxa' Jesus pa'jni's jiyuçxa pa'kh. Sa' tasxte peejxũkweçxa pxthaa we'wek: —Niisa ji'phthu txã'sa' eçx luuku vxit-sak iiyamu. Aça' txãa eçxa's nuukutxi'jine'ga ũusu jĩna pi'kxte', ");
INSERT INTO pbb_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Jesus pasçxa na'jĩk: —Mũythaswe, luuçx khuẽ'y ũ'kahn. Txã'wẽ luuçx ũ'wa'ja's kusa'jçxa alkutx ũswa'jme' jĩte', ");
INSERT INTO pbb_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","txãa u'y pasçxa': —Isa yuh we'we'g, txã'wẽ yuja'. Nawa alku' mesa dxiisu ũsçxa', pejka ũ'wẽ'tx luuçx ũ' pe'yaçxáatxwa jĩte', ");
INSERT INTO pbb_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Jesus pasçxa': —Isa, txã'wẽ yuja'. Aça' me'jwe, i'kwe jxthãasni's uyuune'kwe, eçx luuku vxit-sa' i'kwe niisa ũusu kasejxã'kh jĩte', ");
INSERT INTO pbb_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","txãa u'ya' yatna sxawedçxa uyku, eçxa' ũusu kasehte' wẽt yã'j kamaga ũste. ");
INSERT INTO pbb_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Jesusa' ki'kin Tiro kiwejũ kasehçxa, Sidon çxhabuy vxite' Dekapolis kiwey uykhẽwna u'jçxa, Galilea ĩkh walatek pa'j. ");
INSERT INTO pbb_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Kxteea' teeçx piçthẽ'j wẽsẽ'jya' we'weya'wa ãjãsame'stxi Jesus tasxte nuypa'jçxa pxthaa we'we nuykatxhikahn. ");
INSERT INTO pbb_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Aça' Jesusa' txãa ãçã'sa's nasameete fxii pe'jna u'jçxa, thũ'wẽ kafxte pdxi'p jxa'dxna'wa, txajx fxne'sxa's kuse vxiçte kuuçhe'jna', thunetewa jxa'dxku. ");
INSERT INTO pbb_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Sa' ũusdxi'na cielute pagayçxa: —¡Efxata!—jĩk, tee phaate jĩçxak txã'jĩ'. ");
INSERT INTO pbb_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Txã'jĩçpkaçxha', thũ'wẽ kafxa' phaatetx, aça' thunewa ewuute', ew we'weya' ãjãk. ");
INSERT INTO pbb_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Txajũ' txãa nasatxi' Jesusa' wala neewe'wek, txã'wẽ yũuni's kim yuhtxwa pta'sxkahmén. Txã'wẽ ew neewe'wetewa, jweeíiçxáatx mtee mteewa pta'sxna jxã'j. ");
INSERT INTO pbb_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Txã'wẽ yũute', nasa jxukaysa wala kuh jwed yaaki'tx na'jĩna: —Ãçã' ma'wẽsatxwa jxukak pu'çxhi'. Wẽsẽ'jya' ãjãsameetxwa kwẽesẽ'je'kh, sa' we'weya' ãjãsameetxwa kwe'we'je'kh jĩ'tx. ");
INSERT INTO pbb_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Txãa entey nasa iiméh wala kuh pkhaakheçxa kĩh yuhwa ũ'wa'j ji'phmeete', Jesusa' txãa yakh u'jusawe'sxtxi pa'yaçxa na'jĩk: ");
INSERT INTO pbb_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","—Naa nasa' tekh en yã'j adx yakh ũsta', nawa kĩh yuhwa ũ'wa'j ji'phmeeta' aça' adxa' peeygãja'th. ");
INSERT INTO pbb_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Kĩh yuhwa puuçmée yatna kaathe', maaíi yu' jxu'juwe'sxta' na' wẽeçxa dxi'the çxhãçxhameetxna jĩte', ");
INSERT INTO pbb_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","txãa yakh u'jusawe'sx pasçxa': —¿Ma'wẽ puuçya' ya'ãjãkx, aysũ' nasaa yatçxáa yuhwa meeta' aça'? jĩte', ");
INSERT INTO pbb_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Jesus pẽjxçxa': —I'kwe'sxa' ¿maz pan ji'phkwe? jĩte': —Sieteçxáa ji'ptha'w jĩnatx pas. ");
INSERT INTO pbb_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Txajũ' Jesusa' nasatx kiwesu kaçxkaahçxa', siete pantxi jxpa'gaçxa Dxusna weçxana'wa, pe'ltedeçxa txãa yakh u'jusawe'sxtxi ũsu'sku, nasa txazkuẽesatx puuçkahn. Aça' txãawe'sxa' kxtey yuutx. ");
INSERT INTO pbb_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Sa' wedxwa ji'phu'tx kuhmeekwe, aça' Jesusa' Dxusna weçxana'wa, txãa wedxtxi txudeedekaakh. ");
INSERT INTO pbb_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Aça' jxukaysa txiktxi ũ'. Txãa ũ' kijxaate' siete kanastate utatx pkhakh. ");
INSERT INTO pbb_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Txãa ente txã'wẽ ũ'sa' kuatro mil ãhtx yu'. Txajũ' Jesusa' nasatx kaahna'wa, ");
INSERT INTO pbb_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","txãa yu' barkote khẽek txãa yakh u'jusawe'sx yakh Dalmanuta kiwen u'jya'. ");
INSERT INTO pbb_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Kxtee pa'the', fxariseowe'sxwa pa'jçxa Jesus yakh puutx we'wetx. Sa' ma'wẽ yũutewa jiyuya' Jesusa's pẽjxtxi: —Cieluju kĩhçxáawa mkaavxya'ja'j jĩna. ");
INSERT INTO pbb_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Txã'jĩte', Jesusa' wala nxus yajkxna na'jĩk: —Naa nasa' ¿kĩjxa'ki'tx txã'wẽ cieluju kaavxya'ja'j jxthãasu'? Isa yu' txãa nasatxi' kĩhwa kaavxya'ja'jnimée wejx ewna jĩk. ");
INSERT INTO pbb_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Txã'jĩçxa', nasatx nvxihtna' ki'kin barkote khẽena'wa ĩkh kuten u'kh. ");
INSERT INTO pbb_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Sa' peçxkanaçxa ũ'wa'j yu' ji'phmée barkote u'jweççxatx yajkx. Naasáa teeçx pançxáatx ji'ph yu'. ");
INSERT INTO pbb_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Txajũ' Jesusa' na'wẽk jxpa'yakx kaah: —Mpa'yajkxwe, Herodes vxite' fxariseowe'sx lewadura ewmeesa's jĩte', ");
INSERT INTO pbb_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Jesus yakh u'jusawe'sxa' txãawe'sx pwe'sx na'jĩnatx puutx we'we: —Pan ji'phmeetha'w, txãa pa'gane' txã'jĩ' jĩtx. ");
INSERT INTO pbb_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Aça' Jesus wẽsẽ'jçxa na'jĩk: —¿Maa sũhçxakwe txã'wẽ pan ji'phmeetha'w jĩna we'wé'? ¿Ãçxpkaçx jiyu'çmeewá'kwe, pan ji'phmeetewa thẽymée sã'jĩni's yaaki'çmeewá'kwe? ¿I'kwe'sx ũuste khẽje'çmeewá'? ");
INSERT INTO pbb_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","I'kwe'sxa' yafxju yu' uyçxawa, jiyuya' yu' ãjã'çmeewá'kwe, sa' adxa' kĩhnawa thẽymée ãjãni's yaaki'çmeewá'kwe. ");
INSERT INTO pbb_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Miiyajkxwe wakx: Tahç pantxi txudeedeçxa cinko mil nasatx puuçte', ¿maz kanastakwe pkhakh kijxasaatxi'? jĩte', txãawe'sx pasçxa': —Doce kanastatha'w pkhakh jĩtx. ");
INSERT INTO pbb_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","—Aça' siete pantxi txudeedeçxa kuatro mil nasatx puuçte', ¿maz kanastakwe pkhakh kijxasaatxi'? jĩte', txãawe'sx pasçxa': —Siete kanastate utatha'w pkhakh jĩtx. ");
INSERT INTO pbb_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Aça' Jesus we'weçxa': —Txã'wẽ thẽymée yũunisatxi' yaaki'çmeewá'kwe sane'kwe txã'wẽ ũ'wa'j pan ji'phmeetha'w jĩna we'we'. ");
INSERT INTO pbb_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Txajũ' Jesusa' Beçaida çxhabte pa'the', kxteea' teeçx piçthẽ'j uyya' ãjãsame'stxi nuypa'j, nuykatxhikahn pxthaa we'wena. ");
INSERT INTO pbb_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Aça' Jesusa' txãa uyya' ãjãsamée kusete pu'kisçxa, çxhab eka pe'jna u'jçxa', yafxte fxne'sx sxũsxna'wa yafxte jxa'dxku. Txã'wẽ yũuçxa pẽjxku: —¿Ma'wẽçxá' uyu'gá'? jĩte', thegu'gçxa': ");
INSERT INTO pbb_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","—Nasa' fxtũu tasx na'wẽçxáatx vxya', nawa ẽsẽ'se'tx jĩk. ");
INSERT INTO pbb_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Txajũ' Jesusa' ki'kin txajx kuseju yafxte jxa'dxku, aça' yafxa' phaatete' ew uyya' ãjãk. ");
INSERT INTO pbb_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Txajũ' Jesusa' neewe'wek: —Çxhabsu u'kameene'ga, sa' maa yuhtxwa pta'sxmeene'ga iidx yafxtxi kim phaadetewa jĩnak yatna kaah. ");
INSERT INTO pbb_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Jesusa' txãajũ ki' u'kh txãa yakh u'jusawe'sx yakh kasehçxa. Sa' Fxilipo vxitni çxhab Cesarea ja'dasuk pekũjxa' u'jweç yu'. Txajũ' dxi'the u'jweçíi txãawe'sxtxi pẽjxku na'jĩna: —Adxa's ¿kimna jĩ'ta nasa'? jĩte', ");
INSERT INTO pbb_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","txãawe'sx pasçxa': —Maaíi yu': Juan Bautistana jĩ'tx. Aça' vxite we'weçxa': Eliasna jĩ'tx. Aça' vxite we'wesa': Txãniiteywa ma'wẽta Dxus yuwe pta'sxsa kaseje' txã'wẽysana jĩ'tx jĩte', ");
INSERT INTO pbb_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Jesusa' na'jĩnak pẽjx: —Aça' i'kwe'sxa' ¿kimna sũju'kwe? Txã'wẽ pẽjxte', Pedro pasçxa': —Idxa' Kristo, Dxus tasxu yuusag jĩte', ");
INSERT INTO pbb_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Jesusa' maa yuhtxwa pta'sxkaahme'. ");
INSERT INTO pbb_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Txajũ' Jesusa' pta'sxku: —Dxus Nçxi'k Nasa Yuusa' wala pkxuuni pa'ga yuuna, sa' judiu nthẽ'jsawe'sx vxite' sacerdote npiiçthẽ'jwe'sx vxite' Dxus leya's kaapiya'jsawe'sx ahçeçxa kiikhe'jetxna. Aça' uuçxawa tekh ente' ki' ĩtxĩ yuuna jĩk. ");
INSERT INTO pbb_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Jesusa' txã'wẽk ew ãate pta'sx. Aça' Pedro' Jesusa's fxiite pe'jna u'jçxa, yu'kxpejk. ");
INSERT INTO pbb_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Txã'wẽ yu'kxpehte', Jesusa' vxitetx yu'thegçxa', Pedro's na'jĩnak pas: —Eçxthẽ'j, adx tasxu mtxutée. Idxa' Dxus jxthãasni yu'sa' kxtey yuumée, naa kiwete nasaa yaakxniçxá'sgu kxtey yuu wẽjẽ' jĩçxa', ");
INSERT INTO pbb_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Jesusa' txãa yakh yuusawe'sxtxi pa'yaçxa na'jĩk: —Maa nasawa adx yakh yuu wẽeçxa', peekx kakwe jxthãasni's kĩhnawa jxuka nvxihtçxa yuuçxáa adx yakh yujxa' ãjãne'kwe, makwe thẽysa uuwa'j ma'k pa'j nawa txã'sa' yajkxmée. ");
INSERT INTO pbb_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Nawa naa kiwete ĩtxĩ fxi'zewa'jçxá's ya'nwe'wesa', Dxus yakh fxi'zewa'j yu'sa' ivxiituna. Naapkaçxha' Dxus yuwe's nwẽesẽ'jçxa adx yakh fxi'zepa'ga naa kiwete ĩtxĩ fxi'zeni's yajkxmée ivxiitusa', Dxus yakh fxi'zewa'j yu'sa' ivxiitumeena. ");
INSERT INTO pbb_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Makwe naa kiwetewe'sx yu'sa' jxuka knayçxawa peekx ũus yu's ivxiitute', ¿kĩhteçxá' selpiima'k? ");
INSERT INTO pbb_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Peekx ũusa's ivxiituyã'the', ¿kimçxa' nwe'wema'k? ");
INSERT INTO pbb_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Maa nasawa adxa's jxpa'gaya' wa'lna adx pta'sxnitxwa wa'lutxna nasa ewmeesa açewe'wete aça' txã'wẽ yũusa's Dxus Nçxi'k Nasa Yuusaawa Dxus angeleswe'sx yakh eena' kweethna kĩhçxa' jxpa'gaya' wa'luna jĩk. ");
INSERT INTO pbb_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Txajũ' ki'kin we'weçxa' na'jĩk Jesusa': —Isath we'we', ayte ũssa maaíi yu' uumey uyuune'kwe Dxus naa kiwete jxkaajxa' kĩini's jĩk. ");
INSERT INTO pbb_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Txajũ' seis en skhẽwniite', Jesusa' thã'j walate pe'jna u'kh Pedro Jakobo Juan txãawe'sx tekhsaçxáatx. Kxtee pa'the', Jesus kakwe' fxiyku zhiçxkwe yu'ptheh txãawe'sx yafxte. ");
INSERT INTO pbb_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Txajx athni ropa' yãdx na'wẽk zhiçxkwe çxihme yuu; naa kiwete maa yuhwa txã'wẽ zhiçxkwe çxihme yu' thethya' ãjãmeetxna. ");
INSERT INTO pbb_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Naapkaçxha' Pedrowe'sx yafxte vxyaatx Elias vxite' Moises. Txãawe'sxa' Jesus yakhtxi puutx we'wena ũsu'. ");
INSERT INTO pbb_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Aça' Pedro' txã'wẽ uyçxa', Jesusa's na'jĩk: —Ayte' kwe'sx ũswa'j wala ewa'. Aça' tekh wa' txajaga, teeçxsa' iidx jĩi, vxite' Moises jĩi, vxite' Elias jĩi jĩk. ");
INSERT INTO pbb_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Pedrowe'sxa' weçxaniite ũukhsa na'wẽtx neeyũu, txãasak Pedro' weçxaniite txã'wẽ we'we. ");
INSERT INTO pbb_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Txajũ' tãaph kĩhçxa aphku, aça' tãaph dxiiju na'wẽk we'weni pthũuse: —Na' adx Nçxi'k wala wedxnisa', aça' txã'sa' nwẽesẽ'jna kxtey myuuwe jĩçpkaçxha' ");
INSERT INTO pbb_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Pedrowe'sxa' thegu'gçxawa, Moiseswe'sxtxi uymeeta', naasáa Jesusçxáa yã'j ũstetx uy. ");
INSERT INTO pbb_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Aça' thã'ju u'jweççxa', Jesusa' Pedrowe'sxtxi' wala neewe'wek: —Ãçxhíi yu' maa yuhtxwa pta'sxmeene'kwe txã'wẽ uyni's, naasáa Dxus Nçxi'k Nasa Yuusáa uuçxawa ki' ĩtxĩ yuuniijũ pta'sxine'kwe. ");
INSERT INTO pbb_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Txã'wẽ neewe'weni's kxtey nwẽesẽ'jtx kim yuhtxwa tuuthe'jmée. Nawa txãawe'sx pwe'sx yu' puutx paapẽyĩ'tx: Uuyã'jçxa', ¿ma'wẽ ki' ĩtxĩ yuukx? jĩna. ");
INSERT INTO pbb_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Txajũ' na'wẽ kaapiya'jni'stxi Jesusa's paapẽjx: —Dxus leya's kaapiya'jsawe'sxa' Elias khuẽ'y yaçte pa'jana jĩ'tx sa' ¿ma'wẽ yuuwa'jsakx açki'tx txã'jĩ'? jĩte', ");
INSERT INTO pbb_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Jesusa' na'wẽk pta'sx: —Isa, Elias khuẽ'y yuh yaçte pa'jçxa jxuka pheu'jwa'jsa yu'k aça' isa yuh pta'sxi'ne'ta. Txã'wẽy Dxus Nçxi'k Nasa Yuusa's we'weçxa': wala pxthaa yuuna nasa ahçeçxa pkxuuni jĩna Dxus librute fxi'jni ũsa' txãawa isa yuja'. ");
INSERT INTO pbb_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Eliasa' pa'jana jĩ'tx aça' Eliasa' pa'jyujk, nawa txã'sa' kĩjkĩhwa yũutx Dxus librute ma'wẽ fxi'jni ũsna txã'wẽy. ");
INSERT INTO pbb_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Txajũ' Jesusa' vxitesa neeyũutx kxtee sxawedna kĩjaçte', nasa wala pkhaakhena ũsu'tx. Aça' Dxus leya's kaapiya'jsawe'sx yu' txãawe'sx yakhtxi wala we'wena ũsu'. ");
INSERT INTO pbb_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Naapkaçxha' Jesus yuhtewa jiimée ũsiyna, Jesus pa'jaçyã'the uyçxa', nasa' jxukaysa ũukh yajkxnatx weçxaya' utxáa. ");
INSERT INTO pbb_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Txajũ' Dxus leya's kaapiya'jsawe'sxtxi' Jesusa' pẽjxku: —¿Kĩh yũupa'ga txakwe weeçx we'wena ũskwe? jĩte', ");
INSERT INTO pbb_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","txãa nasa wala ksxavxyte teeçxsa' Jesusa's na'jĩnak pta'sx: —Adx nçxi'ka's eçx luuku vxit-sa iiyamute' we'weya' ãjã'çme' txã'snath ayte nuypa'j. ");
INSERT INTO pbb_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Txãa luuçxa' mtee ũstewa eçx luuku vxit yã'the', ki'thtxi ksuusu'jna yuwesu bu'çxçxáak sẽhna weté'. Txã'wẽ yũuna wala talxiça'. Aça' idx yakh u'jusawe'sxtxi' pi'kxyã'th nuykatxhikahn, nawa ãjãmeeta' jĩte', ");
INSERT INTO pbb_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Jesus pasçxa': —Dxusa' pu'çxhina sũhwa'j yu'sa' ji'phmeesata' naa nasa'. ¿Bagaçxpkaçx i'kwe'sx yakh pu'çxna ũs ya'watka? ¿Bagaçxpkaçx ãjãmée fxi'ze ya'wakwe? Txãa luuçxa's mneejxũhwe ayte jĩte', nuykũhtx Jesus tasxte. ");
INSERT INTO pbb_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Aça' eçx luuku vxit-sa' txãa luuçxa's kaywẽçxpa'ja'the', kiwesu wetek yuwesu bu'çxçxáa sẽhna. ");
INSERT INTO pbb_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Txajũ' Jesusa' luuçx neya's pẽjxku: —Txã'wẽ ãçã'ni ¿makwe txaçx yuuçna? jĩte': —Le'çxíik txã'wẽ yu'. ");
INSERT INTO pbb_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Sa' maa entey yu' txaçxmeynak wẽeçxpa'jçxa ipxte khẽena yu'khẽwa khẽena uupçxãh yuuna u'ju'. Aça' kxahth idx yakh ewupçxãhte', ma'wẽçxáawa pu'çxhine'ga peeygãhçxa jĩna pi'ki' jĩte': ");
INSERT INTO pbb_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","—Idx yuu txã'wẽ Dxusa' pu'çxhina sũhte yu', kĩhwa jxuka kxtey yuuna txã'wẽ yaakxsa's jĩte', ");
INSERT INTO pbb_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","luuçx neya' susku we'wena pxthaa pi'kx: —Dxusa' pu'çxyujuna sũju'th, sa' adx ũuste txã'wẽ yaakxwa'ja's jweeíiçxáa wala meen kaajiyu'j jĩk. ");
INSERT INTO pbb_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Txajũ' Jesusa' nasa wala kuh pkhaakhena utaaçte uyçxa', eçx luuku vxit-sa's na'jĩnak we'we: —Eçx luuku vxit-sa kwe'we'je'çmeeg, sa' wẽsẽ'jwe'sxte thũ'wẽtxwa aphgu, nawa ãçxha' adx we'weni's nwẽesẽ'jçxa ũusu mkaaseh, peena yu' u'kameene'ga jĩte', ");
INSERT INTO pbb_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","eçx luuku vxit-sa' txãa luuçxa's sus kweeyi'jna kaywẽçxpa'ja'jçxa kasejk. Aça' txãa luuçxa' uuníi na'wẽk wetena neeyũu. Kxahtx nasa we'weçxa': —Ãçxha' pejka uuk jĩna we'we'. ");
INSERT INTO pbb_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Nawa Jesusa' kuseju pu'kisku, aça' txãa luuçxa' kiitek. ");
INSERT INTO pbb_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Jesusa' txãajũ u'jçxa', teeçx yattek u'ka. Aça' txãa yakh u'jusawe'sxa' pẽjxtxi: —Kwe'sxa' ¿kĩh yũuçxakxtha'w eçxa's kutxi'jya' ãjãmée? jĩte', ");
INSERT INTO pbb_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Jesusa' pta'sxku: —Na'wẽsa eçxa' thẽymée yu' kasehmeena, wala yũunaana Dxus yakh puutx we'wete yuuçxáa kasejena jĩk. ");
INSERT INTO pbb_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","31","Txajũ ki' u'jçxa', Galilea kiwenku u'j. Sa' kxteea' txãa yakh u'jusawe'sxtxik kaapiya'jwa'j ji'phu' naa pa'ga kim yuhwa jiyu jxthãasme'. Sa' dxi'the u'jweççxa', na'wẽk txajx uuwa'ja's pta'sx: —Dxus Nçxi'k Nasa Yuusá's nasa ewmeesa kusete dukhni yuuwa'ja', aça' txãawe'sxa' ikhetxna. Aça' uuçxawa, tekh ente' ki' ĩtxĩ yuuna jĩtewa, ");
INSERT INTO pbb_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","txãa yakh u'jusawe'sxa' jiyumeeta', nawa pẽjxya' yu' ũukhtxi. ");
INSERT INTO pbb_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Sa' Kapernaum çxhabte teeçx yatte pa'jçxa', txãa yakh u'jusawe'sxtxi paapẽjxku na'jĩna: —I'kwe'sxa' dxi'the yuhçxa', ¿kĩjkwe puutx we'we'? jĩtewa, ");
INSERT INTO pbb_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","txãawe'sxa' thaameçxa pasmeeta' txã'wẽ dxi'the yuhçxa', ¿maa wejx jxthaakwe walasakxtha'w? jĩna puutx we'weçxawa. ");
INSERT INTO pbb_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Txajũ' Jesusa' docesatx pa'yaçxa kaçxçxa pta'sxku: —Maatewa jxthaakwe walasa yuu wẽeçxa', iiwejçx yajkxmée maatxwa jxuka selpiiçxa yuuçxáa jxthaakwe walasa yuuna. ");
INSERT INTO pbb_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Txã'jĩçxa' teeçx luuçxkuẽ's txãawe'sx ksxavxyte txahçxa kusete yakhçxa na'wẽk we'we: ");
INSERT INTO pbb_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","—Maa nasawa adxna wa'lmée jxpa'gasa' adx na'wẽy luuçx na'wẽkwesatxwa ahçemée jxpa'gatxna. Txã'wẽ yũusa' adxna jxpa'gasaçxa txã'wẽ yuutxna. Sa' adxna jxpa'gasa' adxçxáana jxpa'gamée, adxna kaahsa'swa jxpa'gasa yuutxna jĩk. ");
INSERT INTO pbb_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Txajũ' Juana' na'wẽk pta'sx: —Idx ¿ma'jĩki'g? Kwe'sxa' teeçx piçthẽ'j uytha'w txã' eçx luuku vxit-satx nasaa ũusu kutxi'ji'k Jesusku jxkaaja' jĩna we'weçxa. Nawa txã'sa' jwee yu' txã'wẽ yũukaahmeetha'w kwe'sx yakh u'jusame' naa pa'ga jĩte', ");
INSERT INTO pbb_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Jesus pasçxa': —Txã'wẽ yũunuwe, txãa pa'gatey adx yase's kxsuusçxa eçx luuku vxit-satx nasaa ũusu kutxi'jsa' adxa's açewe'wemeena kim yuhwa. ");
INSERT INTO pbb_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Maawa kwe'sxtxi açewe'wesamée yu', kwe'sxtxi pu'çxsa íiçxáatxna. ");
INSERT INTO pbb_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Na'jĩ'th na': I'kwe'sxa' Dxus luuçxi'kwe naapa'ga maawa i'kwe'sxtxi peeygãhna teeçx tasa yu'çxáawa yusuna txã'sa' dewení yuuna. ");
INSERT INTO pbb_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","—Mpa'yajkxwe, txã'wẽme' luuçxkuẽ adxa's yaakxsatx pkalte kweete'jena txã'sa' txhikhte skuutxh ũ'khni kweta's tudçxa ĩkh wala dxiikhẽ akhwaççxáa, wejx ewna. ");
INSERT INTO pbb_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Meeçxawa iidx kuse txã'wẽ pkalte idxa's kweete'jeçte', mespẽ'th. E'z kuse yakh uu kiwete khẽe na'wẽ', wejxwa teeçx kuseçxáa ji'phçxawa pçumée ĩtxĩ fxi'zewa'the u'kani wejx ewa'. Txã'wẽme' uu kiwete ipx wala seena'sa bagaçxte yuhwa ũçxhawa'jsame'. ");
INSERT INTO pbb_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Kxteea' bagaçxte yuhwa wesa' çxhavxyna pçuwa'jsameeta', aça' ipx seena'sawa ũçxhawa'jsame'. ");
INSERT INTO pbb_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Txã'wẽy iidx çxidawa pkalte kweete'jeçte', txã'swa mespẽ'th. E'z çxida yakh uu kiwete khẽe na'wẽ', wejxwa teeçx çxidaçxáa ji'phçxawa pçumée ĩtxĩ fxi'zewa'the u'kani wejx ewna. Txã'wẽme' infxiernote ipxa' bagaçxte yuhwa ũçxhawa'jsame'. ");
INSERT INTO pbb_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Kxteea' bagaçxte yuhwa wesa' çxhavxyna pçuwa'jsameeta', aça' ipx seena'sawa ũçxhawa'jsame'. ");
INSERT INTO pbb_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Txã'wẽy iidx yafxwa pkalte kweete'jpçxãh yuuçte', mkuutxi'j. E'z yafx yakh infxiernote khẽe na'wẽ', wejxwa teeçx yafx yakhçxáawa Dxus jxkaahna ũsnite u'kani wejx ewna. ");
INSERT INTO pbb_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Txã'wẽme' kxteea' bagaçxte yuhwa wesa' çxhavxyna pçuwa'jsameeta', aça' ipx seena'sawa ũçxhawa'jsame'. ");
INSERT INTO pbb_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Txãa pa'gatey txãa ipxa' kaapçu'ju'jwa'jsame'. ");
INSERT INTO pbb_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Nega' wala seelpisa'. Nawa sxũukãhte', ¿ma'wẽ kselpi'jya' ewuutxki? I'kwe'sxa' nega na'wẽy selpiina mfxi'zewe, jxukaysa yakh ewçxáa. ");
INSERT INTO pbb_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Jesusa' Kapernaum çxhabu kasehçxa', Judea kiwen vxite' Jordan yu'wala kutenku u'j kxsũ pekũjxa'. Sa' Jordan yu'wala kuteju ũste', wala nasa pkhaakhe'tx txajx ũsnite. Aça' kxteewa kaapiya'ja'kh vxite ahsũ na'wẽy. ");
INSERT INTO pbb_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Naapkaçxha' fxariseowe'sxa' Jesus tasxte utxaaçxa' na'wẽtx paapẽjx, pasya' sxiigte' ewmée vxit-ya' sũhçxa: —Ptamsaçxawa, nyu's wãatãhte ¿ewmanx? jĩte', ");
INSERT INTO pbb_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Jesus pasçxa': —Jiimeewá'kwe Moises jxkaahni's jĩna pẽjxte', ");
INSERT INTO pbb_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","txãawe'sx pasçxa': —Moises jxkaahçxa', nyu's wãatãjxa' ewuweçxte', nyu kazx yuuna fxi'zeni's eçte fxi'jçxa dukhçxak txuteekaja' jĩte', ");
INSERT INTO pbb_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Jesus pasçxa': —Moisesa' txã'wẽ yũuwa'ja's nvxiht yujk, nawa peekx nyu kĩhwa yũumeetewa wãatãhna fxi'zepa'ga íiçxáak txã'wẽ yũuwa'ja's nvxiht, peekxçxáa yu' wãatãjxa' ãjãkahmén. ");
INSERT INTO pbb_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Nawa Dxusa' nyafxiitey naa kiwe's pheu'jíi e'zíitx ja'daçxajk vxit piçthẽ'j petx u'y yã'jçxa. ");
INSERT INTO pbb_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Aça' txãa pa'ga piçthẽ'ja' peekx neywe'sx tasxu txuteewa'jsa', nyu yuuwa'jsa yakh utxaaya', ");
INSERT INTO pbb_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","txã'wẽ e'zçxawa, teeçxsaçxáa na'wẽ yuuna pa'jya'. Aça' txã'wẽ yũuniijũ' e'zmée teeçxçxáak yuuna pa'ja'. ");
INSERT INTO pbb_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Txãa pa'ga Dxus pũpxçxa nvxiitni ptamsayã'txhi' kim yuhwa txuhdeya' ãjãwa'jsameeta' jĩk. ");
INSERT INTO pbb_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Txajũ' Jesusa' teeçx yatte u'kate', txãa yakh u'jusawe'sxa' txã'wẽ pta'sxni's ki' pẽjxtxi. ");
INSERT INTO pbb_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Aça' Jesusa' pta'sxku: —Maa piçthẽ'jwa peekx nyu's wãatãhçxa vxite yakh ptamuuçxa', pkalte weteena, peekx nyu's wãatãhçxa vxite yakh ptamuupa'ga. ");
INSERT INTO pbb_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Aça' u'ywa txã'wẽy nmi'a's wãatãhçxa vxite yakh ptamuuçxa', txãawa pkalteyçxáa weteena peekx nmi'a's wãatãhçxa vxite yakh ptamuupa'ga jĩk. ");
INSERT INTO pbb_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Txãa e'su' Jesus tasxte luuçxkuẽtx nuypa'jtx Dxus kusete neewe'wekahn. Aça' Jesus yakh u'jusawe'sxa' yuptxi luuçxkuẽtx nuypa'jsatx. ");
INSERT INTO pbb_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Txã'wẽ yũute', Jesusa' na'jĩnak ũusçxa we'we: —Luuçxkuẽ adx tasxte yuusaatxi' kuçx yupnuwe, txãa pa'gatey Dxus jxkaahna ũsnisa' naa luuçxkuẽwe'sx na'wẽsa jĩi íiçxá'. ");
INSERT INTO pbb_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Na'jĩ'th na': maawa luuçxkuẽ na'wẽ Dxus jxkaahwa'j ena's wa'lmée jxpa'gameeçxa yu', bagaçxte yuhwa Dxus tasxte u'kaya' ãjãmeetxna. ");
INSERT INTO pbb_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Txã'jĩna'wa luuçxkuẽtx yakhna' dxikthesu peekizeçxa Dxus kusete neewe'wek. ");
INSERT INTO pbb_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Txajũ' Jesusa' vxite ahn u'jweçte', teeçx piçtakx dxi'the wuwuuna kũhçxa', Jesus tasxte peejxũkwek na'wẽ paapẽjxna: —Kaapiya'jsa wala ewsa mpeeta'sx. Adxa' ¿ma'wẽ yũuçxa pçuwa'jmée ĩtxĩ fxi'zewa'ja's ji'phuki'th? jĩte', ");
INSERT INTO pbb_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jesus pasçxa': —¿Kĩh yuupa'gaga adxa's ewsa jĩ'? Naa kiwete' teeçx nasaçxáa yuhwa ewsa yu' meeta'. Dxus yuuçxáa ewsa ũsa'. ");
INSERT INTO pbb_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Idxa' jiine'ga Dxus jxkaahni na'wẽsatxi': Ptamsa' vxite yakh pkal yuuwa'jme', nasa ikhwa'jme', pesweewa'jme', vxitetx ĩsxiina nuywe'wewa'jme', vxitee jĩitx kusa'jwa'jme'. Neywe'sxtxi peeygãhna ewçxáa yũuna fxi'zewa'ja' jĩte', ");
INSERT INTO pbb_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","txãa piçtakx txã'wẽ wẽsẽ'jçxa' na'wẽk pas: —Txã'wẽ jxkaahnisatxi' le'çxkuẽjũjx jxuka kxtey yuunath waláa jĩte', ");
INSERT INTO pbb_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jesusa' txãa piçtakxa's peeygãhna thegçxa' na'jĩk: —Na'wẽ yũuwa'jçxáa peejxa': Iidx ji'phuni's jxuka txweyçxa, puuple ji'phmeesatx peesya' me'j. Txã'wẽ yũuçxa', cielute ji'phsa yuune'ga. Txã'wẽ yũuçxa adx yakh myuh, makwe seena' nxussa pa'thewa txãatxi' yajkxmée jĩte', ");
INSERT INTO pbb_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","txãa piçtakxa' wala ji'phsa yu'k, sa' txã'wẽ wẽsẽ'jçxa', wala nxusna u'kh. ");
INSERT INTO pbb_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Txajũ' Jesusa' nasatx thegçxa' pta'sxku txãa yakh u'jusawe'sxtxi: —Maawa wala ji'phsa yakha' Dxus jxkaahna ũsnite u'kawa'j wala yuh thẽya' jĩte', ");
INSERT INTO pbb_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","txãa yakh u'jusawe'sx wẽsẽ'jçxa', jiyumée kuh jwed yajkxnatx neeyũu. Aça' Jesusa' ãatek pta'sx: —Naa kiwete ji'phuniçxá's jxthaakwe yaakxsa yakha' wala yuh thẽya' Dxus jxkaahnite u'kawa'ja'. ");
INSERT INTO pbb_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Maawa wala ji'phsa' Dxus jxkaahnite wala thẽy u'katxna. Aça' txã'wẽ thẽysa's yajkxte yu', kamelxo yuhwa thẽymée wáa yũz kafxga u'kaya' ãjãtxna jĩk. ");
INSERT INTO pbb_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Txã'wẽ wẽsẽ'jçxa', wala kuh yajkxna na'wẽtx puutx paapẽyi': —Txã'wẽte', ji'phsa' ¿kimçxá' cielute u'kaya' ãjama'tx? jĩte', ");
INSERT INTO pbb_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jesusa' txãawe'sxtxi thegçxa' na'wẽk we'we: —Naa kiwete nasa' Dxus ũsnite u'ka wẽeçxa txãawe'sx kakwejuçxáa pa'pçxuçxa' ãjãmeetxna. Nawa Dxusna pi'kxçxa yu', thẽymée ãjãtxna. Dxus yakha' kĩh yuhwa thẽysa meea'. ");
INSERT INTO pbb_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Txajũ' Pedro' na'wẽk we'we: —Kwe'sxa' idx yakh yujxa', kwe'sx ji'phuni's jxuka nvxihttha'w kĩhnawa jĩte', ");
INSERT INTO pbb_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Jesusa' na'wẽk pta'sx: —Adxa' isath we'we': Dxus yuwe ewsa's jxpa'gaçxa adx yakh fxi'ze wẽeçxa', kĩhnawa jxuka nvxiitutxna yat, kiwe, nyakhwe'sx, npe'sxwe'sx, neywe'sx, nyu, nçxi'kwe'sx, niisawe'sx txã'wẽsatx. ");
INSERT INTO pbb_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","Aça' txã'wẽ yũusa' makwe yahçena fxi'zeçxawa txãawe'sx nvxiitniite puutejka jxthaakwe wala uyuutxna naa kiwetey: yat, kiwe, nyakhwe'sx, npe'sxwe'sx, njĩ'jwe'sx, nçxi'kwe'sx, niisawe'sx txã'wẽysatx. Sa' vxite kiwete', pçumée ĩtxĩ fxi'zewa'ja's jxpa'gatxna. ");
INSERT INTO pbb_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Nawa jxpa'yakxmeete', makwe yaçtewe'sxçxawa, nmehtewe'sx yuutxna; naapkaçxha' nmehtewe'sx yu', yaçtewe'sx yuutxna jĩk. ");
INSERT INTO pbb_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Jesusa' Jerusalente pa'jya' u'jweçku yu', aça' txãa yakh u'jusawe'sxa' ũukhçxa e'stetx u'jwe' Jesusa's yaçte akhçxa. Txajũ' Jesusa' docesaçxáatx fxiite pa'yaçxa pta'sxku txã'sa' kĩh yũuya'watewa: ");
INSERT INTO pbb_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","—I'kwe'sxa' jii yã'ji'kwe Jerusalente pa'jya' u'jweçtha'w. Aça' kxte' Dxus Nçxi'k Nasa Yuusa's uweçxa dukhni yuuna Dxus leya's kaapiya'jsawe'sx vxite' sacerdote npiiçthẽ'jwe'sx kusete. Aça' txãawe'sxa' ikhwa'j vxitçxa judiu ji'jmée vxite nasatx dukhetxna ikhkahn. ");
INSERT INTO pbb_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Aça' txãa nasa' npeevxysxijkana peçxujkwena fxne'sx avxythethna txã'wẽ yũuçxa ikhetxna. Nawa tekh ente' ki' ĩtxĩ yuuna jĩk. ");
INSERT INTO pbb_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Txajũ' Zebedeo nçxi'kwe'sx Jakobo vxite' Juan txãawe'sxa' Jesus tasxte utxaaçxa na'wẽtx pẽjx: —Kwe'sxa' idxa'stha'w pẽyi' kwe'sx pẽyni's kxtey yuukahn jĩte', ");
INSERT INTO pbb_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Jesusa' pẽjxku: —¿Kĩjkwe yũu jxthãasu'? jĩna. ");
INSERT INTO pbb_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Aça' txãawe'sx e'zsa' na'wẽtx pẽjx: —Idxa' naa kiwete jxkaajxa' kĩhçxa', kwe'sx e'zsatx iidx pukakhẽ pdxi'p kaçxwa'ja's ũsune'ga jĩnatx pẽjx. ");
INSERT INTO pbb_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Aça' Jesus pasçxa': —I'kwe'sxa' jiimeeçxa i'kwe txã'wẽ pẽyi'. I'kwe'sxa' adx na'wẽy pxthaa yuuçxa uuwa'ja's ũukhmée jxpa'gaya' ¿ãjama'kwe? jĩna pẽjxte', ");
INSERT INTO pbb_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","txãawe'sxa': —Ãja'nja'w jĩnatx pas. Aça' Jesusa' na'wẽk pta'sx: —Isa, i'kwe'sxa' adx na'wẽy pxthaa yuuçxa uuwa'ja's ũukhmée ji'phuyujune'kwe. ");
INSERT INTO pbb_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Nawa adx pukakhẽ pdxi'p kaçxwa'ja's adx ũsu'çmeeth pẽysatx. Txã'sa' txãn ente kim jxpa'gawa'jsa yuuna txã'sçxáa ũsni yuuna jĩk. ");
INSERT INTO pbb_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Aça' vxite diezsawe'sx txã'wẽ Jakobowe'sx pẽyni's wẽsẽ'jçxa' ũusaçxatx txãawe'sxtxi'. ");
INSERT INTO pbb_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Txã'wẽ yũute', Jesusa' pa'yaçxa na'wẽk yu'kxpeh: —I'kwe'sxa' miiyajkxwe: Naa kiwete jxkaahsa walasa' nasatx jxuka jxkaaja'tx juuna'çxáa yuuna khaawãsxi'jna. ");
INSERT INTO pbb_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Nawa i'kwe'sxa' txã'wẽy yuuwa'jsameei'kwe. Makwe jxthaakwesaçxawa, wejxwa vxitetx selpiina mfxi'zewe. ");
INSERT INTO pbb_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","I'kwe'sxa' walasa yuu wẽeçxa', vxitee jxkaahni selpisáa myuuwe. ");
INSERT INTO pbb_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Txãa pa'gatey Dxus Nçxi'k Nasa Yuusáa yuhwa txã'sna selpíi jxthãasya' kĩhme', wejxwa maazkuẽe nasatxwa nwe'wena selpiiya' kĩhçxak ya'dukh nxuste uuya'. ");
INSERT INTO pbb_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Txajũ' Jerikote pa'jçxa', Jesusa' txãa yakh u'jusawe'sx vxite' kuhsa yakh çxhabu kasehna u'jweçte', teeçx piçthẽ'j uyya' ãjãsameek dxi'j pukate lmusxnu thãasna u'pu'. Txã' Bartimeok yaase yu', Timeo nçxi'k. ");
INSERT INTO pbb_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Sa' Jesus Nasarethuwe'sx utxaaçte wẽsẽ'jçxa', na'jĩnak sus we'wena u'pu': —Jesus, Davxid ji'j, adxa's meen peeygãh jĩna. ");
INSERT INTO pbb_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Aça' nasa yu': —Sxuuna' myuu, kuçxgu susu' jĩtewa, jweeíiçxáak sus we'we: —Davxid ji'j, adxa's meen peeygãh jĩna. ");
INSERT INTO pbb_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Txajũ' Jesusa' tudte yujuçxa, pa'yakaakh. Aça' pa'yatx na'jĩna: —Kiiteçxa ũukhmée myuh, Jesusa' idxa's pa'yaça' jĩçpkaçxha', ");
INSERT INTO pbb_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","txajx atxha's nvxihtçxa ũphçxak kiiteçxa Jesus tasxte utxáa. ");
INSERT INTO pbb_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Txajũ' Jesusa' ¿kĩhga yũu jxthãasu'? jĩna pẽjxte', txãa uyya' ãjãsamée pasçxa': —Adxa' uyya' ãjã wẽjẽ'th jĩk. ");
INSERT INTO pbb_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Aça' Jesus we'weçxa': —Kaauyu'juna sũhçxane'ga adxa's pi'kx txãa pa'ga ãçxha' uyna mneeyũu jĩçpkaçxha' uyya' ãjãk, sa' Jesus e'stey u'kh pi'kxna. ");
INSERT INTO pbb_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Txajũ' Jesusa' Jerusalenna u'jweççxa', e'z çxhabkuẽ Betania Betfxagé utxatek pa'j. Txãa çxhaba' Oliwos vxiç dxi'pgatx neeyũ'. Aça' kxtee pa'jçxa' txãa yakh u'jusawe'sx e'zsatx yaçte kaakh na'jĩna: ");
INSERT INTO pbb_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","—Çxhab le'çxkuẽ vxya'k kxtee me'jwe. Sa' kxtee pa'jçxa', teeçx buçxu kim yuhwa a'jnimeesa tudni ũsna txã'sna jxũkhwedeçxa jxũna yuweene'kwe. ");
INSERT INTO pbb_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Txã'wẽ yũuçte kim pẽyiwáatxna aça' kwe'sxtxi jxpe'jsak nikxya' kaah nawa ki' kaasxwedu'juna jĩne'kwe. ");
INSERT INTO pbb_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Txã'jĩte', txãawe'sxa' u'jçxa buçxu's uytxi vxitx pukate dxi'j ju'gu tudni ũste. Aça' jxũna u'jya' jxũkhwedeçtxi yu'. ");
INSERT INTO pbb_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Naapkaçxha' kxtee thegna ũssa' we'wetx: —Buçxu's ¿kĩh yũuya' jxũkhwedeçkwe? jĩna. ");
INSERT INTO pbb_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Txajũ' Jesus ma'wẽne' kwe'we'j txã'wẽy txãawe'sxa' pasteçxáa jxũna kaahtx. ");
INSERT INTO pbb_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Txajũ' txãa buçxu's Jesus tasxte nuykũhçxa', txãawe'sx atxhtxi tpegu'gçxa pustxi, aça' Jesusa' a'jçxa u'kh. ");
INSERT INTO pbb_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Naapkaçxha' vxite yu' Jesus u'jwa'j dxi'jsu yaçtetx txãawe'sx atxhtxi pusna u'jwe', aça' vxite' ẽjxã spẽ'thçxatx txã'wẽy dxi'jsu pusna u'jwe' yaçsu. ");
INSERT INTO pbb_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Naapkaçxha' yaçte u'jsa vxite' e'ste yuusa txãawe'sxa' na'jĩnatx weyna u'jwe': —Dxus kaahnisa wala yuh jxtuhthesa yuja'. ");
INSERT INTO pbb_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Wala yuh ew jxkaajana, kwe'sx yaçgawe'sx Davxid na'wẽy. Dxusa's weçxaaga wala ew yũupa'ga jĩ'tx. ");
INSERT INTO pbb_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Jesusa' txã'wẽk Jerusalente u'ka dxuus yatte pa'j. Sa' dxuus yatte kĩh ũstewa jxuka thegçxaçxáa ki' kasehna u'kh Betania çxhabnay doce txãa yakh u'jusawe'sx yakh, kusuçyã'kh yu' naa pa'ga. ");
INSERT INTO pbb_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Txajũ' kuskuskhẽ' Jesusa' Betania çxhabu ki' kasehçxa' wẽek. ");
INSERT INTO pbb_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Sa' higwera-tasx wala yehçsa ũste uyçxa', thegya' u'kh yũn ji'phwáana sũhçxa. Nawa yũnmée eççxáak ji'ph yu', yũn en meek yu' naa pa'ga. ");
INSERT INTO pbb_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Txajũ' Jesusa' na'jĩnak we'we txãa fxtũu tasxa's: —Naa fxtũu tasxte yũnni's kim yuhwa ũ'meetxna peena yu' jĩna we'weçte', txãa yakh u'jusawe'sxa' wẽsẽ'jnatx ũsu'. ");
INSERT INTO pbb_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Txajũ' Jesusa' Jerusalen çxhabte ki' sxawedna pa'jçxa', dxuus yatte u'kaçxa kxtee kĩjkĩhwa txweyna ki' weyna ũssatx eka kasxisxku, vxyu yu'pthehsa mesa vxite' tub çxihme txweysa kaçxni pagutx jxuka pũsxna. ");
INSERT INTO pbb_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Sa' kxtee kĩjkĩhwa tu'sçxa pa'jsatx kaakũju'jme'. ");
INSERT INTO pbb_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Txajũ' na'jĩnak yu'kxpeh: —Dxus librute' na'wẽ fxi'jni ũsa': Adx yata' Dxus yakh puutx we'wena ũswa'j yatçxá' nasa majũwe'sxwa jĩ'k. Nawa i'kwe'sxa' peswée pkhaakhena ũsni kafx na'wẽçxáa vxitçxa ji'phi'kwe jĩte', ");
INSERT INTO pbb_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Dxus leya's kaapiya'jsawe'sx vxite' sacerdote npiiçthẽ'jwe'sx wẽsẽ'jçxa', ma'wẽçxáawa yũuçxa ikhya' ãjãwa'ja's pakwetx. Nawa isa ikhya' yu' ũukhtxi, nasa thaakwe kuhsa yu' Jesus kaapiya'jni's nwẽesẽ'jsaçxaçxáa ũspa'ga. ");
INSERT INTO pbb_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Txajũ' jxuka çxhi'dxiçte', Jesusa' txãa çxhabuh kasehna u'kh. ");
INSERT INTO pbb_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Kuskuskhẽ kusíi kxuy jxkhẽuuççxa', higwera fxtũu tasxa' weçete pa'j udxni ũstetx uy. ");
INSERT INTO pbb_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Aça' Pedro' Jesus we'weni's yajkxçxa na'jĩk: —Mtheg naa higwera fxtũu tasxa's jũ'na we'weçxa': naa fxtũu tasxte yũnni's kim yuhwa ũ'meetxna peena yu' jĩnag we'we txãa fxtũu tasxa' jxuka uhdxga jĩte', ");
INSERT INTO pbb_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Jesusa' na'wẽk pas: —I'kwe'sxa' kĩh pẽyiççxawa, kuh jwed yajkxmée Dxusa' kxtey yuuna sũhnaçxáa mpẽjxwe. ");
INSERT INTO pbb_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Adxa' isath we'we': maawa Dxusa's txã'wẽ ũusuh jxuka yajkxna, naa vxiç wala ayjxu u'jçxa ĩkh walate me'j khẽeya' jĩtxna aça' kxtey yuuna. ");
INSERT INTO pbb_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Kxtey yuuwa'ja's adxa' jiiçxath txã'wẽ i'kwe'sxtxi' Dxus yakh puutx we'wekaja' pẽyni's jxpa'gayã'tha'w sũhna. ");
INSERT INTO pbb_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Sa' Dxus yakh puutx we'wena ũsíi yaakiwá'kwe vxitesa yakh ãhmée yũuni's. Sa' txã'wẽ yajkxçxa', txãa yakh peltunãyya' u'jwene'kwe, kxah i'kwe'sx Tata cielutewe'sxwa i'kwe'sx pkaltxi peltunaĩna. ");
INSERT INTO pbb_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Nawa i'kwe'sx txã'wẽ vxitesa yakh ãhmée yũuni's peltunaĩmeete', i'kwe'sx Tata cielutewe'sxwa i'kwe'sx pkaltxi' peltunaĩmeena jĩk. ");
INSERT INTO pbb_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Txajũ' Jerusalente sxawedna pa'jçxa, dxuus yat-su u'jute', sacerdote npiiçthẽ'jwe'sx vxite' Dxus leya's kaapiya'jsawe'sx vxite' judiu nthẽ'jsawe'sx Jesus tasxte utxaaçxa', ");
INSERT INTO pbb_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","na'jĩnatx pẽjx: —Idxa' ¿kimga saga dxuus yatte txã'wẽ juuna' yũu? ¿Kimga txã'wẽ yũuya' jxkaah? jĩte', ");
INSERT INTO pbb_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Jesus pasçxa': —Adxwa i'kwe'sxtxi' pẽjx ya'wath aça' adx pẽyni's pasune'kwe. Txã'wẽ yũ' adxwa pta'sxi'nja kim jxkaathe txã'wẽ yũuçxawa. ");
INSERT INTO pbb_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Sa' pẽjxku na'jĩna: —Juan Bautista's ¿kimga jxkaah bautisãyya'? ¿Dxusá', meeçxa' naa kiwega piçthẽ'já'? Mpaaswe jĩnak pẽjx. ");
INSERT INTO pbb_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Txajũ' txãawe'sx pwe'sx na'jĩnatx puutx we'we': —Dxusne' jxkaah jĩ'nja'w aça' txã'wẽte' ¿mjĩya'kwe Juan pta'sxni's jxpa'gamée? jĩna pasuna. ");
INSERT INTO pbb_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Meeçxa' naa kiwetewe'sxne'ta jxkaah jĩwaçwa, kxul yuhna, nasa jxukaysa Juana's we'weçxa': Dxus jxkaahnisa' jĩ'tx. ");
INSERT INTO pbb_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Txã'jĩna ũukh we'weçxaçxáa: —Kwe'sxa' jiimeetha'w jĩnaçxáatx Jesusa's pas. Aça' Jesusa' na'jĩk: —Adxwa pta'sxme'nja kim jxkaathe txã'wẽ yũuçxawa jĩk. ");
INSERT INTO pbb_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Txajũ' Jesusa' naa ejemplo yakhku kaaja'da'jna pta'sx: —Teeçx piçthẽ'ja' txajx kiwete uwa wala uhçxa, ktadxíi jxuka uphku, sa' uwa ee thegwa'j yatwa txahçxa uwa thẽ'the ũhdeçxa ku'swa'j yatwa fxii txajk. Txã'wẽ yũuçxak txãa kiwete mjĩiwa'jsatx ew neewe'wena nvxihtçxa jxu'j kiwen u'j. ");
INSERT INTO pbb_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Txajũ' uwa thẽ'jwa'j en ãhte', txã'sna selpisáa teeçx kaakh kxtee mjĩisatx pẽjxya' txãa jĩi yuuwa'ja's. ");
INSERT INTO pbb_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Nawa txãa kiwete mjĩisawe'sxa' pẽjxna pa'jsa's uweçxa wala pkxuutx, sa' kĩh yuhwa dukhmeetx kaah. ");
INSERT INTO pbb_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Aça' kiwe namu' vxite selpisáa ki' kaakh txã'snawa wala wẽesxuna kwet wãatãtãhna dxikthesu kpã'vxittxi. ");
INSERT INTO pbb_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Txajũ' kiwe namu' ki' kaakh vxite selpisáa, aça' txã'sa' ikhtxi. Txãa e'su' maazkuẽe selpisaawa kaakh, aça' txãawe'sxtxi' maaíi yuutxi' kpã'vxitna, vxitetxi' ikhtxi. ");
INSERT INTO pbb_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Txã'wẽ yũute', teeçx nçxi'k wala wedxnisa ji'phuk txã'snak nmehte kaah, adx nçxi'ka's pejka nwẽesẽ'jetxna sũhna. ");
INSERT INTO pbb_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Nawa txãa kiwete mjĩisawe'sxa' txãa nçxi'ka's uyçxa': Naa nçxi'k txã'wẽ naa kiwe's uwewa'jsana, aça' txã'sa' ikhçxa kiwe's kwe'sx iiyamu'nja'w jĩnatx puutx we'we. ");
INSERT INTO pbb_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Sa' txãa nçxi'ka's uweçxa ikhçxa uuníi kakwe's txãa kiweju kutxi'jtx jĩnak pta'sx. ");
INSERT INTO pbb_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Txã'wẽ pta'sxçxa Jesusa' pẽjxku: —Txã'wẽ yũute', kxtee kiwe namu' ¿kĩh yũukx? Txãa sxawedna pa'jçxa, kxtee mjĩisatxi's ikhçxa kiwe's vxitetx ũsuna sũju'th jĩk. ");
INSERT INTO pbb_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Dxus librute na'wẽ fxi'jni ũsa' txã'sa' iilẽeymeewá'kwe i'kwe'sxa': Yat txaahsawe'sxa': Naa kweta' seelpime' jĩçxa wãatãhtx. Nawa txãaíik yat makwesanawa çxhãçxha neewewa'jsa yuuna pa'j. ");
INSERT INTO pbb_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Txã'wẽ neewewa'jsa yuuna pa'jwa'ja's Dxusku vxitçxa nvxiht, Txãa pa'ga kwe'sx yakha' wala weçxa yuja' ¿jĩ'çmeena'? ");
INSERT INTO pbb_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Txajũ' Dxus leya's kaapiya'jsawe'sx vxite' sacerdote npiiçthẽ'jwe'sxa' txãa ejemplo' txãawe'sxtxi we'wenitewa jiyuçxa', Jesusa's uweçxa tud wẽetx. Nawa nasatx ũukhçxa tudmée u'jtx. ");
INSERT INTO pbb_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Txajũ' fxariseowe'sx vxite' Herodes nasa txãawe'sxtxi pa'yaçxatx maz kaah Jesus tasxte, kĩh ewmée we'wetewa kpajkxya'. ");
INSERT INTO pbb_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Aça' txãawe'sxa' na'wẽtx paapẽjx Jesusa's: —Idxa's kwe'sxa' jiitha'w. Idxa' isasaçxá'sgu we'we', Dxus tasxte pa'jwa'j dxi'ja's kaapiya'jna. Sa' nasaa jxkaahna yu'kxpehnitx nwẽese'je'çmeeg, txãa pa'gatey idxa' nasa ewsa na'wẽ thegsatx jiyumey ju'gu yu'çmeeg. Idx ¿ma'jĩki'g? Jxkaahsa Cesara's vxyu dukhte ¿ewmanx? Meeçxa' dukhmeete wáa ¿ewna? jĩna pẽjxte', ");
INSERT INTO pbb_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Jesusa' txãawe'sx ũuste ewmée yajkxçxa txã'wẽ pẽyni's jiyuçxa', na'wẽk pas: —¿Kĩjxa'kwe adxa's ewmeete nvxiit wẽeçxa txã'wẽ pẽyí'? Vxyu's mneejxũhwe wakx, thegya'wath jĩte', ");
INSERT INTO pbb_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","teeçx vxyu's jxũna kũhtx, aça' thegçxa' na'jĩk: —Ayte' ¿kiim dxi'pa's ki'pnina, sa' kiim yase's fxi'jnina? jĩte', txãawe'sx pasçxa': —Cesar dxi'pa's ki'pçxa Cesar yase's fxi'jni' jĩtx. ");
INSERT INTO pbb_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Aça' Jesusa' na'wẽk jxkaah: —Cesar jĩ's Cesara's dukhwa'ja', sa' Dxus jĩ's Dxusa's dukhwa'ja' jĩte', paapẽysawe'sxa' pasya' ãjãmée kuh yajkxnatx neeyũu. ");
INSERT INTO pbb_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Txajũ' saduceowe'sxtxi paapẽjxya' kũh Jesus tasxte. Txãawe'sxa' uusaawe'sxa' peena yu' ĩtxĩ yuumeetxna sũhna yaakxsatx yu'. Sa' Jesus tasxte kũhçxa', pẽjxtxi: ");
INSERT INTO pbb_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","—Idxa' jiine'ga, Moisesa' na'wẽk fxi'jçxa nvxiht: Maa piçthẽ'jwa nyu ji'phçxawa, luuçx ji'phumey uute', uusáa nyakha' txãa neeyũusáa u'y yakh kabaana aça' txãate luuçx nyafxtewe'sxa' uusáa nçxi'k na'wẽ neeyũuna jĩnak fxi'j. ");
INSERT INTO pbb_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Kwe'sxa' jiitha'w siete piçthẽ'j pxakhtxi u'p yu'. Sa' nyakh nthẽ'jsa' iiyuuçxawa luuçx ji'phumey uuk. ");
INSERT INTO pbb_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Aça' nyakh e'stewe'sxa' txãa u'y neeyũusáa yakh kabaçxawa, txãawa luuçx ji'phumey uuk. Sa' tekhtewe'sx nyakhwa txãa u'y neeyũusa's íiçxáak kaba. Nawa txãawa txã'wẽyçxáak yuu. ");
INSERT INTO pbb_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Aça' sietesay teeçx u'ysaçxaçxáana kabana jxã'jçxawa, txã'wẽçxaçxáatx yuu. Nmehte' txãa u'ywa uuk. ");
INSERT INTO pbb_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Aça' uusaawe'sx ki' ĩtxĩ yuu ente', txãa u'ya' ¿maa yakh isa nyu yuuwa'jsakx cielute'? jĩnatx paapẽjx. ");
INSERT INTO pbb_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Aça' Jesusa' na'wẽk pta'sx: —I'kwe'sxa' Dxus libru's jiimeei'kwe, sa' Dxus tasxte ma'wẽ fxi'zewa'ja'swa jiimeeçxa' jxpubana ũsi'kwe. ");
INSERT INTO pbb_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Nawa uusaawe'sxa' ki' ĩtxĩ yuuçxa', nyu ji'phuwa'jsa meeta'. Kxte' kaaptamu'jna ũskiweme', txãa pa'gatey cielute' txãawe'sxa' angeleswe'sx na'wẽsaçxáa yã'tha'. ");
INSERT INTO pbb_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","I'kwe'sxa' jxpubanuwe: Uusaawe'sxa' ki' ĩtxĩ yuuwa'jsa yuhta'. I'kwe'sxíiwa Moises librute iilẽeyne'kwe: Kxte' çhũçh yu'kh behna ũsni pxãjũ na'wẽk Dxusa' we'we: Adxa' Abrahan, Isaak, Jakob txãawe'sx Dxusthu jĩk. ");
INSERT INTO pbb_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Dxusa' uusaawe'sx Dxusme', txã' ĩtxĩsawe'sx Dxusa'. Aça' i'kwe'sxa' wala jxpubana ũsi'kwe jĩk. ");
INSERT INTO pbb_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Txã'wẽ pãapẽjxte', Jesus sxiigmée pasuçte wẽsẽ'jna ũsu'k Dxus ley kaapiya'jsa teeçxsa'. Sa' txãawa na'wẽk pẽjx: —Dxus leya' maatewa jxthaakwesa' ¿maana? jĩte', ");
INSERT INTO pbb_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jesusa' pta'sxku: —Dxus ley maatewa jxthaakwesa nyafxtewe'sxa' na'wẽ': Israelwe'sx, mwẽesẽ'jwe: Kwe'sxtxi taki'sa Dxusa' teeçx yuuçxá'. ");
INSERT INTO pbb_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Txã'sa' ũusuh jxuka yajkxçxa txãa yuuçxáana selpiina fxi'zewa'ja' bagaçxte yuhwa txutemée uu entepkaçx. ");
INSERT INTO pbb_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Aça' e'stewe'sxa' txã'wẽydxi'a': Peekíi ma'wẽga ya'peeygãja', txã'wẽy mpeeygãh vxite nasatxwa. Naa ley e'zsa maatewa jxthaakwesata' jĩte', ");
INSERT INTO pbb_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Dxus leya's kaapiya'jsa pasçxa': —Ew yuh pta'sxgu. Dxusa' teeçxçxáa yuh ũsa', aça' vxite Dxus yu' meeta'. ");
INSERT INTO pbb_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Sa' txã'wẽ ũusuh jxuka yajkxçxa txãa yuuçxáana bagaçxte yuhwa txutemée selpiina fxi'zeçxa, txã'wẽy ma'wẽ peekíi ya'peeygãja'kx txã'wẽ vxite nasatxwa peeygãhna fxi'zeni' Dxusna peesna maazkuẽe niimalwa altalte kabnite jxthaakwe ewsa' jĩk. ");
INSERT INTO pbb_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Txajũ' Dxus leya's kaapiya'jsa txã'wẽ jxpa'yakx paste', Jesusa' na'jĩk: —Dxus jxkaahnite u'kaya' utxa ũsgu jĩk. Aça' txajũyã'ja' vxite yu' peena pẽjxmeeta'. ");
INSERT INTO pbb_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Txajũ' Jesusa' dxuus yatte nasatx kaapiya'jna na'wẽk pta'sx: —Dxus ley kaapiya'jsawe'sxa' ¿ma'wẽteki'tx Kristo' Davxid nçxi'ka' jĩna pta'sxi'? ");
INSERT INTO pbb_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Naapkaçxha' Dxus Espiritu kaayaki'the' Davxida' Kristo's we'weçxa' na'jĩk: Adxna jxpe'jsa Kristo's Dxusa' na'jĩk: Adx pukate paçu ju'gte mkaaçx, Idxna açesatx idxçxaçxáana nwẽese'jwa'ja's vxitna jxã'phkaçx jĩk. ");
INSERT INTO pbb_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Aça' Kristo' ¿ma'wẽçxa Davxid nçxi'k yuukx? Davxid íiwa Kristo's we'weçxa': Adxna jxpe'jsa jĩk. Txã'wẽ Jesus pta'sxte', nasa txazkuẽesay wala weçxana wẽsẽ'je'tx. ");
INSERT INTO pbb_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Txajũ' Jesusa' na'wẽ yu'kxpehnak kaapiya'j: —Dxus ley kaapiya'jsawe'sxtxi' jxpa'yakx me'juwe. Txãawe'sxa' ropa jxu'jsa athçxatx nasatx weçxaa jxthãasna pekũju' msuuwa. ");
INSERT INTO pbb_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Sa' judiuwe'sx pkhaakhenisuwa kaçxni wejx ewsaçxáanatx pakwé', vxite' sã'jĩya' pi'kxni yat-suwa txã'wẽytxi yu'. ");
INSERT INTO pbb_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Sa' vxiudawe'sx kĩh ji'phuni'swa jxuka kusa'jçxatx txãa pesweni's kaapeçxkana'jya' wala jxu'j we'wena lisá'. Txã'wẽ yũupa'ga txãawe'sxa' wejx jxthaakwe Dxus kastigãyni yuutxna jĩk. ");
INSERT INTO pbb_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Sa' Jesusa' dxuus yatte vxyu ãsxni dxi'pte kaçxçxa thegnak u'pu' ofxreda ãsxya' kũusatx. Aça' maaíi yu' vxyu wala ji'phsa' seena' wala akhetx. ");
INSERT INTO pbb_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Naapkaçxha' teeçx u'y vxiuda puuplesa kũhçxa', e'z vxyuu musxkuẽçxáak akh. ");
INSERT INTO pbb_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Aça' Jesusa' txãa yakh u'jusawe'sxtxi pa'yaçxa na'wẽk pta'sx: —Naa u'y vxiuda' kĩh yuhwa ji'phmeesaçxawa maa maatewa jxthaakwek akh. ");
INSERT INTO pbb_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Vxite yu' akhe'tx, nawa txãawe'sx peejinimée kijxasaçxáanatx akhe'. Nawa naa u'ya' kĩh yuhwa ji'phmeesaçxawa txajx ũ' weywa'ja's jxukak akh jĩnak pta'sx. ");
INSERT INTO pbb_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Txajũ' Jesusa' dxuus yatu kasejeçte', txãa yakh u'jusa teeçxsa' na'jĩnak we'we: —Mtheg, naa yata' na'wẽ seena' wala txaahni' kwet zhiçxkwesa yakh jĩte', ");
INSERT INTO pbb_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Jesus pasçxa': —Naa yat wala's wá'ga thegu', aça' txã'wẽ yuja'. Nawa jxuka pçuuna, aça' teeçx kwetçxáa yuhwa kẽese'jnimeesa yu' neeyũumeena jĩk. ");
INSERT INTO pbb_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Sa' txajũ kasehçxa', Oliwos thã'j dxuus yat dxi'ptek neeyũ' kxteetx u'j. Kxtee pa'jçxa Jesusa' kaçxçxa u'pte', Pedro, Jakobo, Juan, Adres txãawe'sxa' na'wẽtx paaçte pẽjx: ");
INSERT INTO pbb_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","—Bagaçx txã'wẽ dxuus yata' pçuwa'jsakx txã'sa' pta'sxwaça', sũju'tha'w. Sa' txã'wẽ yuuwa'j en ãjãçte', ¿kĩhçxa yuukx? txã'snatha'w jiyu wẽjẽ' jĩte', ");
INSERT INTO pbb_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Jesusa' pta'sxku: —Mpa'yajkxwe kaypuba'jwe'sxte. ");
INSERT INTO pbb_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Txã'wẽme', wala kasejetxna: Adxíi Kristoth jĩna. Txã'wẽ yũuçxa maaíi yuutxi' wala kaypuba'jatxna. ");
INSERT INTO pbb_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Sa' i'kwe'sxa' wẽsẽ'jene'kwe gweçxa u'pa' sa' aysuwa gweçxa pa'jana jĩni's, nawa ũukhmeene'kwe. Txã'wẽ kxtey yuuyujuna, nawa nmeh en meea'. ");
INSERT INTO pbb_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Aça' gobierno' vxite kiwete gobierno yakh puutx puiitxna. Naapkaçxha' puutx jxu'j kiwejũ pwe'sxwa puutx puiitxna. Mtee mteewa seena' ehd u'jwena. Seena' wẽjẽ enwa pa'jana. Sa' nasawa wala susutxna gobiernotx açewe'wena. Nawa pxthaa nxuswa'j en takhnaçxáa txã'wẽ yuuna. ");
INSERT INTO pbb_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Nawa i'kwe'sxa' jxpa'yakx meswe. Txã'wẽme' judiu nthẽ'jsawe'sx kusete i'kwe'sxtxi dukhçxa, txãawe'sx pkhaakhenite nuypa'jçxa pkxuutxna. Sa' i'kwe'sxa' adxna selpiiya' utxaapa'ga ahçeçxa ne'jwe'sx tasxsu vxite' jxkaahsa tasxsu kuutxa'jni yuune'kwe. Txã'wẽ kxsũ pa'jçxa', jxkaahsawe'sxtxiwa pta'sxya' ãjãne'kwe adx kaapiya'jni's. ");
INSERT INTO pbb_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Nmeh en utxaaçte', Dxus yuwe ewte nvxiitwa'jsa's mtee mteewa jxuka pta'sxni yuuna. ");
INSERT INTO pbb_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Txã'wẽ i'kwe'sxtxi' jxkaahsa kusete dukhya' jxũna u'the', ¿ma'wẽ pasukxtha'w? sũhna kuh yaakxnuwe ũukhna. Dxusa' txãa dudte kaaũusuthe'jena txã'sçxáa mwe'wewe, txãa pa'gatey i'kwe'sx we'wewa'jsameei'kwe. Dxus Espiritu i'kwe'sx ũuste kaayaki'jwa'jsa' i'kwe'sx we'wewa'ja's, aça' txã'sçxáa we'wewa'jsai'kwe. ");
INSERT INTO pbb_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Naa kiwete nasa' peekx nyakhtxi ahçeçxa kiikhe'jetxna, aça' neywe'sxwa peekx nçxi'ktxi ahçeçxa kiikhe'jetxna. Txã'wẽy nçxi'kwe'sxwa neywe'sxtxi ahçeçxa kiikhe'jetxna. ");
INSERT INTO pbb_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","I'kwe'sxa' adxna selpiipa'gaçxáa naa kiwetewe'sx jxuka yaaçeni fxi'zene'kwe. Nawa uu entepkaçx Dxus yakh txutemée fxi'zeçxa', ewte neeyũune'kwe. ");
INSERT INTO pbb_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Na'wẽ fxi'jni's jiyuya' jxpa'yakx mlẽeywe: Dxus yuwe pta'sxsa Daniela' fxi'kh dxuus yatte kazx ewmée yuuna pa'jwa'ja's. Aça' txã'wẽ kxtey yuuçte uyçxa', Judea kiwete ũssa nasa' çxhab peeku'j yu'khsuçxaçxáa ũphna kasejene'kwe. ");
INSERT INTO pbb_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Aça' txã'wẽ seena' yuuçyã'the', ẽe yat-su u'psa ũphna sa'jçxawa, kĩh yuhwa kutxi'jwa'j en ji'phumeetxna. ");
INSERT INTO pbb_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Txã'wẽy mjĩi ehsu u'jusawa txajx atxhçxá'swa yatuh kutxi'jya' pa'jwa'j en ji'phumeetxna. ");
INSERT INTO pbb_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Txãa ensu' nasa ji'phsa vxite' luuçx ãpãkuẽ ji'phsa' wala yuh nxus pxthaa yuutxna. ");
INSERT INTO pbb_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","I'kwe'sxa' Dxusna mpi'kxwe, txã'wẽ ũphwa'j ena' nus ente yuukahmén. ");
INSERT INTO pbb_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Txã'wẽme' iiméh seena' wala nxuswa'j en yuuna. Naa kiwe's Dxus pheu'jiyna, bagaçxte yuhwa nxuswa'j en txã'wẽsa yu' u'pu'çme', sa' txãa skhẽwniijũyã'ja' bagaçxte yuhwa txã'wẽy nxussa yu' u'pumeena. ");
INSERT INTO pbb_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Kwe'sxtxi taki'sa Dxusa' txã'wẽ seena' nxuswa'j ena's txaçxmée vxitmeete yu', naa kiwete nasa kim yuhwa ĩtxĩ neeyũumeetxna. Nawa txã'wẽ seena' nxuswa'j en u'puwa'ja's Dxusa' txaçxmeek vxit txajx nasa txhitxhnisatx peeygãhçxa. ");
INSERT INTO pbb_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Txajũ' maaíi yu' i'kwe'sxtxi na'jĩtxna: Myuhwe thegya', Kristo' ayte ũsa' jĩtxna. Meeçxawa: Me'jwe thegya', Kristo' kxtee ũsa' jĩtewa, i'kwe'sxa' kxtey yuunuwe. ");
INSERT INTO pbb_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Txãa ensu' wala ĩsxĩisa kasehçxa: Kristotha'w jĩtxna, naapkaçxha' vxite': Kwe'sxa' Dxus yuwe pta'sxsatha'w jĩna pekũjutxna, kaypuba'j wẽeçxa kĩjkĩhwa kaavxya'ja'jna. Jxpa'yakxmeete', Dxus txhitxhnisa yuhtxwa kaypuba'jatxna. ");
INSERT INTO pbb_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Aça' txã'wẽ yũuwe'sxte, adxa' dxiikhẽy pta'sxiçthu i'kwe'sx jxpa'yakx ũskahn. ");
INSERT INTO pbb_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Nawa txã'wẽ nxusni en skhẽwniijũ', seka' çxhi'dxina, aça' a'tewa kweethmeena. ");
INSERT INTO pbb_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Naapkaçxha' estrelxa' cielujũ ũsxitxna, aça' kĩjkĩhwa seena' walasa ẽe walate ũstxna txãawa jxuka kẽese'jni yuutxna. ");
INSERT INTO pbb_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Txã'wẽ yũunijũ', Dxus Nçxi'k Nasa Yuusa's uyuutxna tãaph pxãhte seena' zhiçxkwe kweethna kĩjaçte. ");
INSERT INTO pbb_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Sa' kĩhçxa' txajx angeleswe'sxtxi jxkaajana txajx nasa txhitxhnisa mtee mteewa ũstxna txãatx jxuka pkhakhkahn. ");
INSERT INTO pbb_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Naa ejemplo's peçxkananuwe: higwera fxtũu tasx u'se yeeçuçte uyçxa', jiyu'i'kwe yũnya'watewa. ");
INSERT INTO pbb_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Txã'wẽy na'wẽ pta'sxthu txãatx uyçxa', jii mfxi'zewe nmeh ena' utxaaçna sũhna. ");
INSERT INTO pbb_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Isath we'we': txã'wẽ seena' nxuswa'j ena's uyuutxna naa ensu nasa uumey. ");
INSERT INTO pbb_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Cielu naa kiwe jxuka skhẽuutxna, nawa adx we'weni' jxuka kxtey yuumey yu' skhẽwmeetxna. ");
INSERT INTO pbb_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Nawa txã'wẽ Dxus Nçxi'k kĩh orate kĩiwa'jsatewa, txãa en yu'sa' kim yuhwa jiimeeta' cielute Dxus angeleswe'sxwa jiimeeta', aça' Dxus Nçxi'k íi yuhwa jiime', naasáa Dxus yuuçxáa jiia'. ");
INSERT INTO pbb_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Txãa pa'ga i'kwe'sxa' wala jxpa'yakx meswe, Dxusna yuuçxáa neewe'wena. Txã'wẽme' jiimeei'kwe bagaçx kĩiwa'jsatewa. ");
INSERT INTO pbb_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Txã' na'wẽ yuuna: Teeçx piçthẽ'j jxu'j kiwen u'jweççxa', yatu kasehmey selpisaatx teeçxsa na'wẽçxah mjĩi ũsçxa kxtee jxpa'yakx ũskahn teeçx thegwa'jsa txajana. ");
INSERT INTO pbb_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Txã'wẽy i'kwe'sxwa wala jxpa'yakx meswe. Txã'wẽme' jiimeei'kwe çxhi'dxiçte ma'k yuu, meeçxa' kuspxãh atalx we'weçte ma'k yuu, meeçxa' kusíi ma'k yuu nawa pa'jçxáa yuuna. ");
INSERT INTO pbb_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Txã'wẽme' yajkxmée ũsiyna, naa dudte pa'jçxáa wáa yuuna. ");
INSERT INTO pbb_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","I'kwe'sxçxáatx pta'sxmée, jxukaysatxthu pta'sxi' jxpa'yakx ũskahn. ");
INSERT INTO pbb_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Paskua's ũ'ni vxite' pan lewadura ji'phmée ũ'ni fxiesta txãa e'z fxiesta ãjxa' e'z ençxáak peejx yu'. Txãa ente Dxus leya's kaapiya'jsawe'sx vxite' sacerdote npiiçthẽ'jwe'sxa' puutx we'wetx ma'wẽ yũuçxa kimwa jiyunimeete Jesusa's kiikhe'jya' ãjãwa'ja's. ");
INSERT INTO pbb_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","—Nawa fxiesta entemée kiikhe'je'nja'w. Txã'wẽme', nasa wala susutxna jĩnatx puutx we'we. ");
INSERT INTO pbb_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Naapkaçxha' Jesusa' Betaniate Simon wã'jy weeju katxhisa yattek u'p yu'. Aça' kxtee u'pte', teeçx u'y wẽt putasá kĩh yuhwa ka'dnimeesa wala pa'gasa's atçxak kũh. Sa' fxrasko's uhdçxa Jesus dxikthekhẽk aw. ");
INSERT INTO pbb_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Aça' kxtee ũssa' maaíi yu' ũusaçxatx txãawe'sx pwe'sx na'jĩna: —¿Kĩh yũupa'gaçxáaga naa wẽt putasá txakwe pa'gasa's kxul psuwú'? ");
INSERT INTO pbb_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Wejx yuuwa trescientos pesote txweyçxa puupletx pu'çxya' ewne' yu' jĩnatx txãa u'ya's ahçena wẽesxũu. ");
INSERT INTO pbb_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Aça' Jesusa' na'jĩnak we'we: —¿Kĩjxa'kwe wẽesxú'? Kuçx yuunuwe. Na'wẽ yũuk txã' kxul vxituni yuume'. ");
INSERT INTO pbb_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Puupletx peeswaç ewne' yu' jĩ'i'kwe na' puuplesatxi' bagaçxtewa peesya' ãjãne'kwe, i'kwe'sx yakh nes yuutxna naa pa'ga. Nawa adxa' i'kwe'sx yakh nes yuuya'wameeth. ");
INSERT INTO pbb_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Adx uute adx kakwete sxũsxwa'ja's ma'wẽçxáawa yũuk adx uumeyna. ");
INSERT INTO pbb_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Isath we'we', naa kiwete mtee mteewa Dxus yuwe's pta'sxna pekũhsa', naa u'y txã'wẽ yũuni'swa ja'da pta'sxni yuuna peçxkanamée jĩk. ");
INSERT INTO pbb_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Txajũ' txãa yakh u'jusa teeçxsa Judas Iskariote' sacerdote npiiçthẽ'jwe'sx kusete Jesusa's dukhya' puutx we'weya' u'kh. ");
INSERT INTO pbb_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Aça' txãawe'sxa' wala weçxana vxyu dukhya' neeyũutx. Txajũ' Judasa' ¿ma'wẽ yũuçxa Jesusa's açesawe'sx kusete dukheki'th? sũhna wala yajkxku. ");
INSERT INTO pbb_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Pan lewadura ji'phmée ũ'ni fxiesta en ãjãçte', Paskua'jwa'j piisxaatx ikhe' txãa ente' txãa yakh u'jusawe'sxa' Jesusa's pẽjxtxi: —¿Paskuatewe'sxa's ũ'ya' mtee pheu'jya' kaajxa'waga? jĩte', ");
INSERT INTO pbb_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","txãa yakh u'jusawe'sx e'zsatx na'wẽk jxkaah: —Me'jwe Jerusalenna. Sa' kxtee teeçx piçthẽ'j uyuune'kwe yu' mitxha's yakhçxa u'jweçte. Sa' e'stey u'jwene'kwe, ");
INSERT INTO pbb_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","aça' txãa mtee u'kate', i'kwe'sxwa kxtee u'kaçxa yat namu's pẽyine'kwe: ¿Mtee piesa ũsuki'g Paskuatewe'sxa's pheu'jçxa adx yakh u'jusawe'sx yakh ũ'wa'ja's? jĩnak kwe'sxtxi jxpe'jsa' yuwe kaah jĩne'kwe. ");
INSERT INTO pbb_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Aça' txã' pta'sxina ẽe yatte teeçx piesa walasa pheu'jniyã'jsa. Kxtee Paskuate ũ'wa'ja's pheu'june'kwe. ");
INSERT INTO pbb_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Txã'wẽ jxkaathe', txãawe'sxa' çxhabna u'jçxa' Jesus ma'wẽ jxkaahni's jxuka kxtey uyçxa', Paskuate ũ'wa'ja's pheu'jtx. ");
INSERT INTO pbb_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Jxuka çxhi'dxiçte', Jesuswa kxtee pa'kh txãa yakh u'jusawe'sx yakh. ");
INSERT INTO pbb_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Sa' mesate ũ'na u'pçxa', na'jĩk: —Isath we'we', ayte adx yakh ũ'na u'psa teeçxsa' adxa's açesawe'sx kusete dukhya'wa' jĩte', ");
INSERT INTO pbb_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","jxukaysa nxus we'wena puutx ya'paapẽyĩ'tx: —Meeçxa' ¿adx wáa txã'wẽ açesawe'sx kusete dukhwa'jsane'tka? jĩnatx jxukaysa txã'wẽçxaçxáa we'we'. ");
INSERT INTO pbb_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Aça' Jesusa' pta'sxku: —Adx yakh u'jusa teeçxsa' maa txã'wẽ adx yakh ja'daçxah kuse's plaatukhẽ akhena txãa adxa's açesawe'sx kusete dukhwa'jsa'. ");
INSERT INTO pbb_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Dxus Nçxi'k Nasa Yuusa' ma'wẽ uuwa'jsatewa Dxus librute pta'sxi'k txã'sa' kxtey yuuyujuna. Nawa adxa's açesawe'sx kusete dukhsa' seena' yuh nxuste khẽjena. Txãa piçthẽ'ja' wejx yuuwa naa kiwete kasehmeewaçne' wejx ew yu' jĩnak we'we. ");
INSERT INTO pbb_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Nee ũ'na u'píi, Jesusa' pana's jxpa'gaçxa Dxusna weçxana'wa pe'ltedeçxa ũsu'sku na'jĩna: —Mẽ'we, naa pana' adx kakwe na'wẽsa' jĩçxa', ");
INSERT INTO pbb_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","waso'swa jxpa'gaçxa Dxusna weçxana'wa jxukaysatx tudxkaathe', jxukaysa tudtxi txãa wasotewe'sxa's. ");
INSERT INTO pbb_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Aça' Jesusa' na'wẽk we'we: —Naa wasotewe'sxa' adx ee na'wẽsa', maazkuẽesatewa ãh uwuwa'jsa'. Dxusa' txã'wẽk adx eea's pkawçxa yuuçxáa i'kwe'sxtxi nwe'wewa'ja's nvxiht u'se pheu'jçxa. ");
INSERT INTO pbb_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Isath we'we': Ãçxhũyã'ja' peena yu' tudxme'nja naa uwa yu'a's, naasáa Dxus jxkaahwa'j ente yuuçxáa ki' tudxi'nja. ");
INSERT INTO pbb_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Txajũ' Dxusna weçxana memçxa', Oliwos vxiçna u'jtx. ");
INSERT INTO pbb_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Kxtee pa'jçxa', Jesusa' na'wẽk pta'sx: —Dxus librute we'weçxa': piisxáa-thegsa's ikhte', piisxá' jxuka ũphuutxna jĩ'k txãa pa'ga naa kuste' i'kwe'sxa' adx tasxu jxuka ũphuune'kwe. ");
INSERT INTO pbb_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Txã'wẽ yuutewa, adxa' ki' ĩtxĩ yuuçxa i'kwe'sx yaçte u'jwe'nja Galilean jĩte', ");
INSERT INTO pbb_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Pedro pasçxa': —Vxite yu' makwe ũukhçxa ũphtewa, adx yu' txã'wẽ yũume'nja jĩk. ");
INSERT INTO pbb_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Aça' Jesusa' na'wẽk pta'sx: —Idxa's isath we'we', naa kuste atalx e'z us we'wemeyna, tekh us ĩsxĩijaç yuune'ga adxa's jiimeeth jĩna. ");
INSERT INTO pbb_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Txã'jĩtewa, Pedro' jweeíiçxáak çxhãçxha we'we': —Makwe idx yakh ih uune'jçxawa, idxa's jiimeeth jĩna yu' ĩsxĩime'nja jĩte', jxukaysa txã'wẽçxaçxáatx we'we. ");
INSERT INTO pbb_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Txajũ' teeçx ahte pa'jtx, Geçemaní yaasesate. Sa' Jesusa' txãa yakh u'jusawe'sxtxi: —Ayte me'pwe, naapkaçxha' adxa' Dxus yakh puutx we'weya' u'jweçthu jĩçxa', ");
INSERT INTO pbb_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Pedro, Jakobo, Juan txãawe'sxçxáatx pe'jçxa u'kh. Txajũ' Jesusa' wala nxus yajkxçxa', ");
INSERT INTO pbb_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","na'jĩnak pta'sx: —Txakwe wala pxthaa yuuçxa uuwa'ja's yajkxte', wala nxus yuja'. Aça' i'kwe'sxa' ayte dehmée me'pwe jĩçxa', ");
INSERT INTO pbb_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","jxu'jmeekuẽ u'jçxa kiwega pkipha weteçxa Dxusna pẽjxku txã'wẽ seena' yuuçxa uuwa'ja's yu'pthejkahn na'jĩna: ");
INSERT INTO pbb_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Tata, idx yakha' kĩh yuhwa thẽysa yu' meea'. Aça' txã'wẽ seena' nxuste uuwa'jũ meen nwe'we. Nawa adx jxthãasni's kxtey yuumeeçxawa, iidx jxthãasniçxá's kxtey meen yũu jĩk. ");
INSERT INTO pbb_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Txajũ' Jesusa' txãa tekhsatx thegya' kũhçxa', dehna ũstek uy. Sa' Pedro's we'wek: —Dehmée u'pkaathe', ¿teeçx oraçxáawa ĩtxĩ u'pmée dehwá'ga? ");
INSERT INTO pbb_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Ewmeete weteya'mée, Dxus yakh puutx we'wena me'pwe dehmée. I'kwe'sxa' ũusuh yu' çxhãçxhai'kwe yaaki', nawa kakwe yu' çxhãçxhaçme' kxtey yuuya'. ");
INSERT INTO pbb_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Txajũ' ki'kin Jesusa' u'jçxa', txã'wẽyçxáak we'wena Dxus yakh puutx we'we'. ");
INSERT INTO pbb_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Sa' thegya' ki' sxawedçxa', txã'wẽy deeni ũstek uyna kũh, txãawe'sx yafxa' dee wẽeçxa çxhãçxhaçmeene'ta naa pa'ga. Txã'wẽ Jesus uyna kũhte, ma'wẽ pasya' yuhwa ãjã'çmeeta'. ");
INSERT INTO pbb_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Txajũ' tekh uswa txãawe'sxtxi thegna kũhçxa', Jesusa' na'jĩk: —Ãçxh yuuçxá' jxkaaseya' mdejxujíiwe. Nawa ãçxha' pejka en ãjk, Dxus Nçxi'k Nasa Yuusa's ewmeesawe'sx kusete dukhwa'j. ");
INSERT INTO pbb_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Txã'wẽyã'ja' aça' kiiteçxa mejkawe. Adxa's açesawe'sx kusete dukhwa'jsa' yujxã'ja' jĩk. ");
INSERT INTO pbb_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Kxtee we'wena nee ũsiyna, Judasa' kũjk. Txãa yu' Jesus yakh u'jusa docesatewe'sxíiçxáak yu', aça' txãa Judas yakh nasa wala kũhtx kçxilx fxtũ txã'wẽ atçxa. Txãawe'sx yu' Dxus leya's kaapiya'jsawe'sx vxite' sacerdote npiiçthẽ'jwe'sx vxite' judiu nthẽ'jsawe'sx jxkaahnitx yu'. ");
INSERT INTO pbb_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Judasa' Jesusna uwewa'jsatx na'wẽku'ga yu'kxwe'weçxa pe'jna yuwé': Ma'sna dxi'pte weçxa'nja txã'sna i'kwe'sxa' tudçxa jxũna u'jwene'kwe jĩnaga yu'kxwe'we. ");
INSERT INTO pbb_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Txajũ' Jesus tasxte utxaana kũhçxa': —Kwe'sxtxi jxpe'jsa jĩçxa weçxak. ");
INSERT INTO pbb_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Naapkaçxha' nasa' Jesusa's tudtxi jxũna u'jya'. ");
INSERT INTO pbb_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Txã'wẽ Jesusa's tuduçte', Jesus yakh u'jusa teeçxsa' kçxilxa's jxkuutxi'jçxa sacerdote npiiçthẽ'jna selpisáa thũ'wẽ's spẽ'thku. ");
INSERT INTO pbb_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","49","Txajũ' Jesusa' nasatxi' na'jĩk: —Adxa' een isath dxuus yatte kaapiya'jna ũsu' i'kwe'sx ksxavxyte. Nawa txagaçxhíi yu' tudmeeçxa', ãçxh yu' peswéethasi'kwe kçxilx petx fxtũ atçxa pa'j, tudçxa jxũna u'jya'. Nawa Dxus librute fxi'jni ũsa' txãa kxtey yuukahn txã'wẽ yuuça' jĩnak we'we. ");
INSERT INTO pbb_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Txajũ' Jesus yakh u'jusawe'sxa' txã'sçxáana nvxihtçxa jxuka ũphna u'jtx. ");
INSERT INTO pbb_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Naapkaçxha' teeçx piçtakx dee pa'çxni yakhçxáak Jesus e'stey u'jweç yu', aça' txã'snawa tuduçtxi yu'. ");
INSERT INTO pbb_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Nawa dee pa'çxni's nvxihtçxa, iyuna u'kh sũpxçxáa. ");
INSERT INTO pbb_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Txajũ' Jesusa's sacerdote npiiçthẽ'j tasxte nuypa'jtx. Aça' kxte' sacerdotewe'sx, judiu nthẽ'jsawe'sx Dxus leya's kaapiya'jsawe'sx jxukay pkhaakhetx. ");
INSERT INTO pbb_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Aça' Pedro' Jesus e'ste jxu'kh neeyũuna u'jna ũsu', sacerdote npiiçthẽ'j yat patxute pa'phkaçx. Sa' patxute neeyũuk policiawe'sx yakh ipx bajçxna. ");
INSERT INTO pbb_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Naapkaçxha' sacerdotewe'sx vxite' judiu nthẽ'jsawe'sx jxukay pkhaakheçxa, Jesus ewmée yũuni's pakwetx, ewmée yũuni's kpajkxçxa kiikhe'jya' sũhçxa. Nawa uymeeta'. ");
INSERT INTO pbb_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Txã'wẽ uymeetewa maaíi yu': Jesusa' yuuwesa yuja' jĩna yuwe ũsu'tx. Nawa txãawe'sx pta'sxni' isamée fxiyfxiyçxáak kaseje'. ");
INSERT INTO pbb_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Txã'wẽtewa maaíi yu' na'wẽtx we'weya' yajkx: ");
INSERT INTO pbb_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","—Jesus we'weçxa': Naa dxuus yat nasaa txaahni's pẽtxçxa, tekh ente' ki' vxite txaja'nja nasa vxitnimeesa jĩna we'weni's kwe'sxa' iiwẽsẽ'tha'w jĩnatx pãatxhĩ'khe'. ");
INSERT INTO pbb_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Makwe txã'wẽ we'wetewa, txãawa isamée íiçxáak kaseje'. ");
INSERT INTO pbb_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Txajũ' sacerdote npiiçthẽ'ja' kiiteçxa', Jesusa's na'wẽk we'we: —Na'wẽtx pãatxhĩ'khe' ¿txã'sa' ma'wẽçxáawa pasya'wameegá'? Meeçxa' ¿isa yuh txã'jĩwá'nta? jĩtewa, ");
INSERT INTO pbb_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Jesusa' teeçx yuweçxáa yuhwa pasme'. Aça' sacerdote npiiçthẽ'ja' ki'kin pẽjxku: —¿Idxa' Kristo, Dxus Nçxi'k dxihgá'? jĩte', ");
INSERT INTO pbb_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Jesus pasçxa': —Txã'wẽíith. Aça' i'kwe'sxa' uyuune'kwe Dxus Nçxi'k Nasa Yuusa' Dxus pukate kaçxçxa u'pte. Sa' cieluju tãaphte kĩjaçtewa uyuune'kwe jĩk. ");
INSERT INTO pbb_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Txajũ' sacerdote npiiçthẽ'ja' peekx athni ropa's ũusçxa sudeçxa na'wẽk we'we: —¿Kĩjxa'çxáa testigo jwee pejiikxtha'w? ");
INSERT INTO pbb_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","I'kwe'sx wẽsẽ'jna ũste na'wẽk Dxusa's açewe'we. Aça' i'kwe'sxa' ¿maa sũjũ'kwe? jĩte', jxukaysa pasçxa': —Txã'sa' ikhteçxáa ewna jĩtx. ");
INSERT INTO pbb_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Txajũ' vxite yu' dxi'pte fxne'sx avxythethna dxi'pa's aphçxatx uka'kana na'jĩ': —Mjiyu wakx ¿kimga idxa's uka'ka'? jĩnatx npeevxysxika'. Aça' policiawe'sxwa txã'wẽytxi dxi'pte uka'ka'. ");
INSERT INTO pbb_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Pedro' patxute ũste', teeçx u'y sacerdote npiiçthẽ'ja's selpisáa kũhçxa', ");
INSERT INTO pbb_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Pedro's uyku txã'wẽ ipx bajçxna u'pte. Sa' dxi'pte ew thegçxa, na'jĩnak we'we: —Idxwa Nasarethuwe'sx Jesus yakh u'jusag jĩte', ");
INSERT INTO pbb_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Pedro' ĩsxĩik: —Adxa' txã'sa' jiimeeth kimnane'kwe we'we na'swa jĩçxa', kasehna u'jçxa ekajuk ũsu'. Naapkaçxha' atalx we'wek. ");
INSERT INTO pbb_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Aça' txãa u'ya' Pedro's ki' uyçxa' kxtee ũssatxi' na'jĩnak pta'sx: —Naa piçthẽ'ja' pejka Jesus yakh yuh u'jusa' jĩnak we'we. ");
INSERT INTO pbb_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Nawa Pedro yu' ki'kin ĩsxĩik. Aça' txãa e'su' kxtee ũssawa Pedro's na'jĩnatx we'we: —Isa, idxa' txãa yakh yuh u'jusag. Galileajuwe'sxçxa íig txãjũ nasa na'wẽ we'we' jĩte', ");
INSERT INTO pbb_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Pedro' ũusçxa we'wena jurãyku: —Isa Dxus uyte, i'kwe'sx kxsuusu'i'kwe txãa piçthẽ'ja's jiimeeth jĩçpkaçxha', ");
INSERT INTO pbb_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","atalxa' e'z us we'wek. Txajũ' Pedro' Jesus we'weni's yajkxku: Atalx e'z us we'wemeyna, idxa' tekh us ĩsxĩijaç yã'j yuune'ga adxa's jiimeeth jĩni's. Aça' Jesus we'weni kxtey yuute', Pedro' wala ũ'nek. ");
INSERT INTO pbb_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Txajũ' khikhyna sẽjẽçte', sacerdotewe'sx judiu nthẽ'jsawe'sx, Dxus leya's kaapiya'jsawe'sx yã'jçxa walasa pwe'sx pkhaakheçxa Jesusa's tudçxa jxũna u'jtx Pilato tasxte kuutxa'jya'. ");
INSERT INTO pbb_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Aça' Pilato' Jesusa's na'jĩnak pẽjx: —¿Idx wáa judiuwe'sxtxi jxkaahsane'ga? jĩte', Jesusa' pasku: —Txã'wẽ íith. Isa yuh we'weg jĩk. ");
INSERT INTO pbb_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Txajũ' sacerdotewe'sxa' Jesusa' kĩhtewa jxuka ewmeesa' jĩnatx yuwe ũsu'. ");
INSERT INTO pbb_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Aça' Pilato' ki' we'wek Jesusa's: —Mwẽesẽ'j, idxa's na'wẽtx kĩhtewa jxuka ewmeesa' jĩna yuwe ũsu', aça' ¿ma'wẽçxáawa pasya'wameegá'? jĩte', ");
INSERT INTO pbb_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Jesusa' teeçx yuweçxáa yuhwa we'weme', aça' Pilato' kujk yajkxna neeyũu. ");
INSERT INTO pbb_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Pilato' Paskua fxiesta iisa teeçx preesu txhweete'k nasaa pẽyni's. ");
INSERT INTO pbb_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Txãa ensu' kxte preesu ũsu'k Barabás yaasesa. Txãa piçthẽ'ja' vxite nasa yakh pkhaakheçxa gobierno yakh puíi kiisçxa nasatx wala kiikhe'jsa npiiçthẽ'kh yu'. Txãa pa'gak preesu ũsu'. ");
INSERT INTO pbb_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Txajũ' kxtee nasa pa'jsa', Pilato's pẽjxtxi fxiesta iisa ma'wẽne' yũ' txã'sa' ãçxwa txã'wẽy yũukahn. ");
INSERT INTO pbb_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Aça' Pilato' pẽjxku: —I'kwe'sxa' ¿judiuwe'sxtxi jxkaahsa'skwe txhweete jxthãasu'á'? jĩk. ");
INSERT INTO pbb_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Nawa Pilato yu' sacerdote ne'jwe'sxa' Jesusa's ahçeçxa dukhtewa jiiçxak txã'wẽ we'we. ");
INSERT INTO pbb_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Nawa sacerdotewe'sxa' nasa jxukaysatx yu'kxwe'wetx, wejxwa Barabasna mitxhwete jĩkahn. ");
INSERT INTO pbb_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Aça' Pilato' pẽjxku: —I'kwe'sx we'weçxa', Judiuwe'sxtxi Jxkaahsa jĩ'i'kwe ¿txã'sa' kĩjkwe yũu jxthãasu'? jĩte', ");
INSERT INTO pbb_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","txãawe'sx sus we'wena pasçxa': —Txã'sa' kluuskhẽ mkaafxuçu'j jĩtx. ");
INSERT INTO pbb_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Txajũ' Pilato' pẽjxku: —Txã'wẽ yũukahna' naa piçthẽ'ja' ¿kĩhga ewmée yũu? jĩtewa, txãawe'sx yu': —Kluuskhẽ mkaafxuçu'j jĩnaçxáatx sus we'we'. ");
INSERT INTO pbb_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Aça' Pilato' nasa yakh ew neeyũu wẽeçxa, Barabasa's txhweetekaakh, sa' Jesus yu'sa' kaapeçxukwe'jçxa kluuskhẽ fxuçkahn dukhku. ");
INSERT INTO pbb_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Txajũ' soldauwe'sxa' Jesusa's jxũna u'jtx txãawe'sx ũsni patxute. Sa' soldauwe'sx jxukaysatx kxteeçxaçxáatx pa'ya. ");
INSERT INTO pbb_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Khĩçxatx Jesusa's jxkaahsa ropa na'wẽsa kaapã'çxi'jçxa, dxikthete yu' çhũçh korona vxitçxa kaafxĩkhe'j. ");
INSERT INTO pbb_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Txajũ' na'wẽ sus weyna: —Judiuwe'sxtxi jxkaahsath jĩ'ne'ga jĩnatx weeçx we'we. ");
INSERT INTO pbb_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Sa' dxikthega fxtũu zuzsaju pekwe'kwena, fxne'sx avxythethnatx txajx tasxte peejxũkwe'. ");
INSERT INTO pbb_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Txã'wẽ yũuna jxã'jçxa', jxkaahsa ropa na'wẽsa's ksũupi'jçxa, txajx ropa's ki' kaathe'jtx. Txã'wẽ yũuçxatx kluuskhẽ fxuçya' jxũna u'j. ");
INSERT INTO pbb_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Aça' çxhabu kasehna u'jweçte', teeçx piçthẽ'j Simon yaasesa's puutx uyçxa soldauwe'sxa' txã'snatx Jesus yakhni kluusa's kxaakhe'jçxa pe'jna u'j. Txãa Simon yu' Alejandro Rufxowe'sx neyku yu', Cirene kiwetewe'sx. ");
INSERT INTO pbb_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Txajũ' Jesusa's teeçx ahte Golgota yaasesatetx pe'jna u'j. Txãa Golgota yu' Uusáa Dxikthé Dxi'thçxáasa jĩni'. ");
INSERT INTO pbb_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Kxtee pa'jçxa', vxinote yaasa ka'daçxatx yus wẽe, nawa Jesusa' tudxme'. ");
INSERT INTO pbb_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Txajũ' kluuskhẽ fxuççxa', soldauwe'sxa' Jesus ropatxi's txudeedeçxa swerte kaahtx txajx kaaçni atxha's maa soldau knaytewa jiyuya'. ");
INSERT INTO pbb_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Kusíi las nwewetetx Jesusa's kluuskhẽ fxuç. ");
INSERT INTO pbb_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Sa' kĩh yũusate txã'wẽ kluuskhẽ fxuççxawa pta'sxna fxi'jçxa ki'ptxi kluus vxiçte: Judiuwe'sxtxi Jxkaahsa' jĩna. ");
INSERT INTO pbb_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","E'z nasa seena' yuuwesa yu'tx txãawe'sx yakhtxi Jesusa's pdxi'p kluuskhẽ fxuç. ");
INSERT INTO pbb_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Aça' Dxus librute fxi'jni' kxtey yuuk: Nasa ewmeesathas yuuwesa yakhku ki'pni yuu jĩna fxi'jni'. ");
INSERT INTO pbb_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Txajũ' kluus tasxuy uykhẽwsa' dxikthetx kaawũhnatx weeçx we'we': —Dxuus yata's idxa' pẽtxçxa tekh ente' ki' kiisu'nja ¿jĩ'çmeegá'? ");
INSERT INTO pbb_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Txã'wẽ ãjãwa'jsaçxa' ¿mjĩitega kluusuh peekíi iyuçxa sa'ja'çmée? jĩ'tx. ");
INSERT INTO pbb_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Aça' Dxus leya's kaapiya'jsawe'sx, vxite' sacerdotewe'sxwa na'jĩnatx weeçx we'we': —Vxite yuutxi' nwe'weçxawa, peekíi yu' ya'nwe'weya' ãjã'çme'. ");
INSERT INTO pbb_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Israelwe'sxtxi jxkaahsa Kristoth jĩ'k na' txã'wẽ dxihçxa', ãçxhíi kwe'sx uyna ũste kluusuh sa'jana aç yuuçxáa txã'wẽ dxih yu'ga sũjũ'nja'w jĩ'tx. Txã'wẽy txãa yakh kluuskhẽ fxuçni u'psawe'sxwa Jesusa's wẽesxu'tx. ");
INSERT INTO pbb_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Txajũ' ẽepxãh wala ãanite', naa kiwete jxuka çxhi'dxku kusuçte las trestepkaçx. ");
INSERT INTO pbb_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Txã'wẽ çxhi'dxni las tres ãjãçpkaçxha', Jesusa' na'jĩnak sus we'we: —Eloi, Eloi ¿lama sabaktani? jĩk. Txã': Adx Dxusgu sa' ¿mjĩi pa'gaga adxçxáana nvxiht? jĩni'. ");
INSERT INTO pbb_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Aça' nasa kxtee wẽsẽ'jna ũssa' Eliasa's pa'yaça' jĩtx. ");
INSERT INTO pbb_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Naapkaçxha' teeçxsa' wuwuuna u'jçxa, vxino pussate esponja's akhçxa fxtũute açhçxa Jesus yuwete utxak çxazxakahn. Sa' na'jĩk: —Sxuuna' thegna meswe, aan Eliasa' kluusuh spajkxya' pa'jana jĩk. ");
INSERT INTO pbb_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Txajũ' Jesusa' ki'kin sus we'wenitee uuna kãjk. ");
INSERT INTO pbb_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Naapkaçxha' dxuus yatte txudenisa liensu pesath a'kxnisa' peekxçxáa sutek puupxãjkhẽ kute ẽeju kiwete kĩh. ");
INSERT INTO pbb_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Aça' kluus dxi'pte ũssa soldau kpiitana' Jesus txã'wẽ sus we'weçxa uuçte uyçxa', na'wẽk we'we: —Naa piçthẽ'ja' isa Dxus Nçxi'k yuh yu'ga jĩk. ");
INSERT INTO pbb_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Txã'wẽy u'ywe'sxwa jxu'ju thegna ũsu'tx. Aça' txãawe'sx ksxavxyte', Salomé, vxite' Maria Magdalena vxite' Maria Jakobo Josewe'sx njĩ'j txãawe'sxtxi yu'. (Txãa Jakobo's nuuçxsa' jĩ'tx). ");
INSERT INTO pbb_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Naa tekh u'ysa' Jesusa's selpiina u'jusatx yu' Galilea kiwesu. Nawa txãawe'sxçxáamée, vxite u'ywe'sxwa Jesus yakh ih Jerusalente pa'jsatx ũsu'. ");
INSERT INTO pbb_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Jxkaasewa'j en ãjãçte', kĩhnawa jxuka pheu'jçxatx nvxiitu'. ");
INSERT INTO pbb_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Txãa pa'gak kusuçte' José Arimateajũwe'sxa' Pilato tasxte ũukhmée utxáa Jesus kakwe's pẽjxya'. Txãa José yu' judiu ne'jwe'sxsa íiçxáak yu', sa' Dxus jxkaahwa'j ena' dud ãhwaça' sũhna yaakxsak yu'. ");
INSERT INTO pbb_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Txã'wẽ Jesusa' uuyã'kh jĩni's jiyuçxa', Pilato' wala kuh yajkxçxa soldau kpiitana's pa'yak pẽjxya' txã'wẽ Jesus uudxihtewa jiyuya'. ");
INSERT INTO pbb_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Txajũ' kpiitana': Jesusa' uuyã'kh jĩna pta'sxte', Pilato' Jesus kakwe's jxũna u'khaakh. ");
INSERT INTO pbb_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Aça' Josea' Jesus kakwe's spajkxçxa, liensu fxinusa weyçxa kxteek yap. Sa' jxũna u'jçxa kwet kafx u'se phadenisa ji'phuk txkaa khikhçxa, u'kani kafxte yu' kwet walasajuk aph. ");
INSERT INTO pbb_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Txã'wẽ yũuçte', Maria Magdalena vxite Maria José njĩ'j txãawe'sxa' Jesus kakwe's mkaa khikheçtewa uytxi. ");
INSERT INTO pbb_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Txajũ' jxkaase en skhẽwniite', Maria Magdalena vxite' Maria Jakobo njĩ'j, vxite' Salomé txãawe'sxa' wẽt putasá weytxi Jesus kakwete sxũsxya' u'jya'. ");
INSERT INTO pbb_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Txajũ' kuskuskhẽ wala kusíi u'jtx, sa' sek kãjaçte' pedaní kafxte pa'jtx. ");
INSERT INTO pbb_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Sa' kxtee pa'jaççxa', na'jĩnatx txãawe'sx pwe'sx we'we': —¿Kim pedaní kafxte aphnisa kwet wala's kiisukx? jĩ'tx. ");
INSERT INTO pbb_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Txajũ' pedaní kafxte thegçxa', aphnisa kwet wala' kiisçxa pukate ki'pni u'ptetx uy. ");
INSERT INTO pbb_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Aça' pedaní kafxte u'kaçxa', teeçx piçtakx ropa çxihmesa jxu'jsa athçxa paçu ju'gu kaçxçxa u'pte uyçxa', wala ũukhtxi. ");
INSERT INTO pbb_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Nawa txãa piçtakxa' na'wẽk pta'sx: —Ũukhnuwe. I'kwe'sxa' Jesus Nasarethuwe'sxa's kluuskhẽ fxuçni uuk txã'snai'kwe pakwé'. Nawa txã' ĩtxĩ yuuyã'kh, txãasa ayga meeyã'ja'. Aça' khikhniga mthegwe wakx, kĩhwa meea' jĩçxa' kaakh na'jĩna: ");
INSERT INTO pbb_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Txãa yakh u'jusawe'sx vxite' Pedro txãawe'sxtxi na'jĩne'kwe: Jesusa' i'kwe'sx yaçte u'jweça' Galilean, aça' kxtee txã'sa' uyuune'kwe ma'wẽga uumeywa pta'sx txã'sa' kxtey yuuna jĩkaathe', ");
INSERT INTO pbb_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","txãawe'sxa' pedaní kafxu wala ũukhna ũphna u'jçxa, kuh yaakxnite vxitesa yuutxi' dxi'the kim yuhtxwa pta'sxmeetx u'j. ");
INSERT INTO pbb_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Txã'wẽ jxkaase en skhẽwnijũ' Jesusa' ki' ĩtxĩ yuuçxa', Maria Magdalena khuẽ'yna vxyaak, na'wẽ siete eçx luuku vxit-satx kutxi'kh txã'sna. ");
INSERT INTO pbb_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Aça' txãa u'ya' Jesus yakh u'jusawe'sx tasxna u'jçxa, pta'sxku. Txãawe'sxa' nxusçxa ũ'nenatx u'p yu'. ");
INSERT INTO pbb_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Sa' Jesusa' ĩtxĩ yuuga aça' ũ'kwe' uythu jĩna pta'sxtewa, weh yuhwa txã'wẽ yũune' sũjũ'çmeeta' txãawe'sxa'. ");
INSERT INTO pbb_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Txãa entey Jesusa' ki' vxyaak fxiy yuuçxa, txãa yakh u'jusawe'sx e'zsa dxi'the u'jweçte. ");
INSERT INTO pbb_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Aça' txãawe'sxwa ki' sxawedçxa, Jesusa's txã'wẽ uytha'w jĩna vxitetx pta'sxtewa, txã'wẽ uyne'ta sũjũ'çmeeta'. ");
INSERT INTO pbb_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Txã'wẽ pta'sxna jxã'jaçpkaçxha', txãa yakh u'jusa oncesa mesate kaçxçxa u'pte ki' vxyaaçxa', na'jĩk: —¿Kĩh yuuçxakwe adxa'sa' ki' ĩtxĩ yuune' sũjũ'çmée? Adx pta'sxni's ũuste yu'akhya' ãjã'çmeei'kwe, sa' ĩtxĩ yuute uysáa pta'sxtewa txã'wẽ uyne'ta sũjũ'çmeei'kwe. ");
INSERT INTO pbb_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Txajũ' na'jĩnak jxkaah: —Me'jwe, Dxus yuwe's pta'sxya' nasa jxukaysatx maa kiwete mteewa jxuka. ");
INSERT INTO pbb_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Aça' maawa adxa's ũusuh jxuka yajkxna jxpa'gaçxa yu'te ya'bautisaĩna txã' nwe'weni yuuna. Nawa adxa's ũusuh jxuka yajkxna jxpa'gasame' Dxus kastigo's knayuuna. ");
INSERT INTO pbb_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Adxa's ũusuh jxuka yajkxna jxpa'gasa' na'wẽ yũuya' ãjãtxna: Adx pu'çxte', eçx luuku vxit-satxwa nasaa ũusuh kutxi'jitxna. Sa' yuwe fxiysajuwa we'wetxna. ");
INSERT INTO pbb_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Ul wesweetxwa kuseju uweetxna. Sa' makwe weneno's tudxtewa, kĩh yuhwa kãaçã'jmeena kakwete. Sa' ãçã'sa kakwete peekiizeçxa, Dxus yakh puutx we'wete', katxhitxna jĩk. ");
INSERT INTO pbb_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Txã'wẽ yu'kxpehni e'su', kwe'sxtxi jxpe'jsa Jesusa' cielun pe'jna u'jni yuuçxa, Dxus pukate kaçxku paçu ju'gte. ");
INSERT INTO pbb_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Aça' txãa yakh u'jusawe'sxa' u'jçxa', Dxus yuwe's mtee mteewa pta'sxtxi. Txã'wẽ kwe'sxtxi jxpe'jsa pu'çxte', kĩjkĩh yũuya'wa ya'ãjãk, txãa pa'gatx txajx we'weni' isasa yuhna sũhwa'ja's ji'phu'.");
INSERT INTO pbb_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","4","Adx namiku Teófxilo, idxa's khiyu'jna fxi'jaçthu kwe'sx ensu na'wẽ yuuk txã'sna. Txã'sa' txã'wẽ yũuya' takheçíyna, Kristo yakh u'jusawe'sxa' ma'wẽçxahne'ta ew uy txã'wẽytxi txãawe'sxa' kwe'sxtxi pta'sx, aça' txã'sa' maawa txã'wẽyta ew pta'sxna fxi'jçxa nvxiit wẽe. Txãa pa'ga adxwa ma'wẽçxahne' yũu txã'sa' wala ew jxpa'yakx paapẽjxçxa idxna pta'sxna fxi'jaçthu, kxah isa yuh pta'sxi'ne'ta sũjũne'ga. ");
INSERT INTO pbb_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Judea kiwete ne'jwe'sx Herodes ensu', teeçx sacerdote Zakarias yaasesak u'pu'. Txãa yu', sacerdote ne'jwe'sx Abias ji'kh yu'. Aça' txajx nyu Elisabet yu', Aarón ji'kh yu'. ");
INSERT INTO pbb_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ptamíi Dxus jxkaahnitxi' nwẽesẽ'jsatx yu', txãa pa'ga Dxus dxi'pte ew fxi'zesatx yu'. ");
INSERT INTO pbb_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Nawa txãawe'sxa' luuçx ji'phmeetx yu', Elisabetha' luuçx ji'phuwa'jsameene' yu' naa pa'ga. Khĩçxawa wala thẽ'khwe yã'j yu'tx. ");
INSERT INTO pbb_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Zakarias yakh ũssawe'sxtxi dxuus yatte selpiwa'j en ãhte', na'wẽk yuu: ");
INSERT INTO pbb_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Dxuus yat altalte wẽt putasá incienso's kabxa' u'kawa'jsa kimtewa jiyuya', sacerdotewe'sxa' swerte na'wẽsa kutxi'jtx. Aça' kxteea' Zakariasku kaseh. ");
INSERT INTO pbb_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Txajũ' Zakariasa' Dxus altalte wẽt putasa's kabuçte', nasa pa'jsa' jxukaysa ekajuçxáatx Dxus yakh puutx we'wena ũsu'. ");
INSERT INTO pbb_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Naapkaçxha' Zakariasa's vxyaak Dxus jxkaahni teeçx angel altal pukate paçu ju'gte. ");
INSERT INTO pbb_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Aça' Zakariasa' txã's uyçxa', kuh yajkxna wala ũukhku. ");
INSERT INTO pbb_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Nawa txãa angel yu' na'jĩk: —Zakarias, ũukhnu. Iidx pxthaa we'weni's Dxus pasçxa kxtey yuuça', aça' iidx nyu Elisabetha' luuçx ji'phuna. Txãa luuçxa's Juan yasene'ga. ");
INSERT INTO pbb_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Txã'wẽ yuute', idxa' wala weçxana neeyũune'ga, aça' maawa txã'wẽçxaçxáa weçxaatxna txajx upxni's jiyuçxa', ");
INSERT INTO pbb_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","txãa pa'gatey txãa luuçxa' Dxus dxi'pte walasa yuuwa'jsa'. Txãasa kĩhwa ktũ'ju'jwa'jsa yu'sa' tudxmeena, naasáa Dxus Espiritu yuuçxáana ũuste jxuka ji'phuna njĩ'j tutxhu yuu kasehmey. ");
INSERT INTO pbb_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Sa' Israel kiwesuwe'sxtxi maazkuẽesatxwa taki'sa Dxus tasxtey ki' kuutxa'jana. ");
INSERT INTO pbb_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Txãa Juana' Dxus Nçxi'k yaçte pekũjuna, sa' Dxus yuwe pta'sxsa Elias Espiritu kĩhtewa ãjawa'jsa's ji'phu'k txã'sna íiçxáa ji'phuna. Txãasa neywe'sxtxi luuçx yakh kaapui'jmée kaafxi'ze'jena, sa' nwẽesẽ'jsameetxwa nwẽesẽ'jya' kaapiya'jana. Txã'wẽ yũuna nasatx pheu'juna Dxus Nçxi'ka's jxpa'gakahn jĩte', ");
INSERT INTO pbb_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zakariasa' na'jĩnak pẽjx: —Kwe'sxa' ptamíi wala thẽ'jyã'tha'w, aça' ¿ma'wẽ yũuçxa iidx txã'jĩni' kxtey yuune'thewa ew jii neeyũuki'th? jĩk. ");
INSERT INTO pbb_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Aça' Dxus angela' pta'sxku: —Adxa' Dxusna selpiina fxi'zesa Gabrielthu. Txãa pa'gak adxa's jxkaah, idxa's naa yuwe ewsa's pta'sxkahn. ");
INSERT INTO pbb_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Nawa adx pta'sxni's txã'wẽ dxih yuuna sũhmeeg naa pa'ga ãçxhíi we'weya' ewumée neeyũune'ga iidx nçxi'k upxpkaçx jĩk. ");
INSERT INTO pbb_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Dxuus yat dxiite txã'wẽ jxthẽeyũute', ekaju nasa yu' Zakariasa's ũythasnatx ũsu', ¿kĩh yuuçxaki'k txakwe jxthẽeyũu? sũhna. ");
INSERT INTO pbb_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Txajũ' Zakariasa' kasehçxa', we'weya' ãjãmeeçxa', kuseju vxijxaçxaçxáak khiyu'ju'. Aça' txã'wẽ yũute', dxuus yat dxiite kĩja' uyyuhne' sũjũ'tx nasa yu'. Sa' Zakariasa' txã'wẽesa neeyũuk. ");
INSERT INTO pbb_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Dxuus yatte selpiina jxã'jçxa', Zakariasa' txajx yatna u'kh. ");
INSERT INTO pbb_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Txãa ensu' Zakarias nyu Elisabetha' nasa ji'ph neeyũuçxa', txajx yatu kasehmeek u'pu' tahç a'tepkaçx, naa sũhna: ");
INSERT INTO pbb_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Ãçxha' ũ'kwe Dxusa' na'wẽk yũu, aça' nasa' ũ'kwe's peena yu' açewe'wemeetxna sũhna. ");
INSERT INTO pbb_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Elisabetha' nasa ji'ph neeyũuni seis a'teju', Dxusa' angel Gabriela's Galileasu teeçx çxhab Nasaret yaasesatek kaah, ");
INSERT INTO pbb_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","teeçx kna'sa Maria yaasesa yatte pa'jçxa' yuwe pta'sxkahn. Txãa kna'sa yu', teeçx piçthẽ'j Jose yaasesa yakh iimi'ya' puutx we'weçxak u'p yu'. Txãa Jose' jxkaahsa Davxid ji'kh yu'. ");
INSERT INTO pbb_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Aça' Dxus angela' Maria u'pnite pa'jçxa' na'jĩk: —Dxusa' ijçxa yakh ũsa', naa pa'ga Dxus bediciona's maa maa u'ytewa jxthaakwe jxpa'gaçxa u'pi'çxa. Txãasa weçxana me'pçxi ewçxáa jĩte', ");
INSERT INTO pbb_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Maria' Dxus angel we'weni's wẽsẽ'jçxa thegçxa', kujk yajkx ¿ma'wẽteki'k txã'jĩ'? sũhna. ");
INSERT INTO pbb_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Aça' Dxus angela' na'jĩk: —Maria, ũukhnuçx, Dxus peeygãanisa i'çxa. ");
INSERT INTO pbb_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Txãa pa'ga ãçxhíi teeçx luuçx pihç ji'ph neeyũuçxa txã'sa' Jesus yasene'çxka. ");
INSERT INTO pbb_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Txãa luuçxa' jxtuhthe walasa yuuwa'jsa'. Txãasa cielute Dxus Nçxi'k ya'kxsusuna. Aça' txã'sa' Dxusa' jxkaahwa'jsa vxituna, yaçgathẽ'j Davxid na'wẽysa. ");
INSERT INTO pbb_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Kxah Israelwe'sxtxi kiiwey jxkaajana, nawa txajx jxkaahni' bagaçxte yuhwa pçumeena jĩk. ");
INSERT INTO pbb_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Txajũ' Maria' txãa angela's pẽjxku: —¿Ma'wẽ txã'wẽ yuja' yũukx? Ũ'kwe' kna'sa nmi' ji'phmeeth açyuja' jĩte', ");
INSERT INTO pbb_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","angela' na'wẽk pta'sx: —Dxus Espiritu' içxa kakwe's txãaçxaçxáa jxuka iiyamuna. Txã'wẽ yuuniteçxáa nasa vxyaana. Txãa pa'ga luuçx upxsa' Dxus jĩi yuuna, sa' Dxus Nçxi'k ya'kxsusuna. ");
INSERT INTO pbb_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Txã'wẽy içxa pukakhẽ nyakh Elisabethwa luuçx pihç ji'phuya'wa', thẽ'khuẽ yã'jçxawa. Bagaçx yuhwa nasa ji'phusameeçxawa, ãçxha' seis a'te yã'j yuuça' nasa ji'phuni. ");
INSERT INTO pbb_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Dxus yakha' kĩh yuhwa thẽysa yu' meea' jĩna pta'sxte', ");
INSERT INTO pbb_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Maria pasçxa': —Txã'wẽ', ũ'kwe' Dxusna selpisáa ne'tka, aça' ũ'kwe's Dxusa' kxtey yuuna na'wẽg pta'sx txã'sa' jĩk. Txajũ' Dxus angela' Maria tasxu txuteena u'kh. ");
INSERT INTO pbb_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Txãa ensuy Maria' jxthẽeyũumée u'kh Judea thã'jsu teeçx çxhab ũsu'k kxtee pa'jya'. ");
INSERT INTO pbb_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Sa' Zakarias yatte pa'jçxa', Maria' Elisabetha's weçxak. ");
INSERT INTO pbb_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Maria weçxana we'weni's wẽsẽ'jeçpkaçxha', Elisabet nasa tutxhtewe'sxa' ẽsẽk. Naapkaçxha' Dxus Espiritu' Elisabet ũuste jxuka kaajiyu'kh. ");
INSERT INTO pbb_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Aça' Elisabetha' Maria's na'jĩnak sus we'we: —Dxusa' ijçxa's maa maa u'ytewa jxthaakwek bedekĩy, sa' txã'wẽyku içxa nçxi'ka'swa bedekĩy. ");
INSERT INTO pbb_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Aça' ũ'kwe' ¿kĩhte seelpitka açga ũ'kwe's Nwe'wesa njĩ'ja' thegya' pa'já'? ");
INSERT INTO pbb_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Içxa weçxana we'weni's wẽsẽ'jeçpkaçxha', ũ'kwe luuçx tutxhtewe'sxa' ẽsẽk weçxana. ");
INSERT INTO pbb_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Dxus we'weni' kxtey yuuna sũhpa'ga, kxtey yuuya'wa' aça' weçxana mfxi'zeçx jĩk. ");
INSERT INTO pbb_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Aça' Maria we'weçxa': Ũ'kwe' ũusuh jxukath Dxusa's weçxá'. ");
INSERT INTO pbb_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Sa' ũ'kwe Dxus nwe'wesa's ũuste peçxkanameeth weçxana fxi'ze'. ");
INSERT INTO pbb_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Txã'wẽ makwe pxthaa ãhmeekuẽtewa, Dxusa' peeygãhçxa txã'sna selpiwa'jsa vxitku. Aça' ãçxhũyã'ja' ũ'kwe's Dxus txhitxhnisak yu' jĩna nes yuutxna maa nasawa jxuka. ");
INSERT INTO pbb_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Txã'wẽ yaakxkahníiçxáak Dxus txakwe walasa ũ'kwe's txakwe ew yũu. Txã' wala peeygãasa'. ");
INSERT INTO pbb_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Txãasa maawa txã'sna nwẽesẽ'jsatxi' bagaçxtewa peeygãhna nes yuuna. ");
INSERT INTO pbb_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Dxusa' kĩjkĩhnawa jxukak vxit, sa' ũuste iiwejçx yaakxsatxwa kpaasu'jme'. ");
INSERT INTO pbb_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Jxkaahsatxwa txãawe'sx jxkaahnijũ kutxi'kh, Sa' kĩhtewa ãhmée pxthaakuẽsatxi' walasak vxit. ");
INSERT INTO pbb_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Kĩhwa ji'phmée peejiina fxi'zesatxi' txãawe'sx peejini's jxukak ũs. Sa' wala ji'phsa yuutxi'sa' kĩhwa ji'phmeek nvxiht. ");
INSERT INTO pbb_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Txã's selpisáa Israel nasatxi' pu'çxku, Sa' peeygãhna fxi'zewa'ja's peçxkaname'. ");
INSERT INTO pbb_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Ma'wẽne' kwe'sx yaçgawe'sx Abrahanwe'sxtxi bagaçxtewa ew yũuya' neeyũu, txã'sa' kxteyku yuu jĩk. ");
INSERT INTO pbb_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Txajũ' Maria' Elisabet yakh tekh a'te u'pçxak txajx yatnay ki' sxawedna u'j. ");
INSERT INTO pbb_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Txãa ensu' Elisabet ãçã'wa'j ãhte', luuçx pihç ji'phuk. ");
INSERT INTO pbb_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Aça' Elisabet nwe'sx vxite' namikuwe'sxwa jiyuçxa', weçxaya' u'jtx Dxusa' Elisabetha's txã'wẽ ew yũupa'ga. ");
INSERT INTO pbb_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Txajũ' teeçx ki'sute', luuçxa's cirkuncidãyya' u'jtx. Sa' ney yase Zakariastxi ki'p wẽe. ");
INSERT INTO pbb_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Nawa njĩ'j we'weçxa': —Txã'wẽmée wejxwa Juan yasewa'ja' jĩte', pi'kxna u'jsawe'sx pasçxa': ");
INSERT INTO pbb_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","—I'kwe nwe'sxa' maa yuhwa Juan yaasesa meetx yu' aça' ¿ma'wẽtekwe Juan yase ki'p wẽjẽ'? jĩ'tx. ");
INSERT INTO pbb_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Txajũ' neya's pẽjxtxi ma'wẽ yasewa'thewa. ");
INSERT INTO pbb_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Aça' neya' Juan yasewa'ja' jĩnak fxi'jçxa ũs. Txã'wẽ yũute', jxukaysa kuhtx yajkxna neeyũu. ");
INSERT INTO pbb_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Txãa dudtey Zakarias ki' we'weya' ewuuçxa', Dxusa's seena' wala weçxak. ");
INSERT INTO pbb_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Txã'wẽ yũute', kxsũ utxasũ u'psa' wala ũukh we'wena neeyũutx. Aça' Judea thã'jsuwe'sxwa txã'wẽ yũuni's jxuka jiyutx puutx ya'pta'sxna. ");
INSERT INTO pbb_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Txã'wẽ jiyuçxa', na'wẽtx yajkxna puutx paapẽyĩ': —Isa, txãa luuçxa' Dxus bedekĩynisane' yu' sa' ¿ma'wẽ yũuwa'jsakx? jĩ'tx. ");
INSERT INTO pbb_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Txajũ' Juan ney Zakariasa's Dxus Espiritu txajx ũuste kwe'we'the', na'jĩnak ãate pta'sx: ");
INSERT INTO pbb_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Israelwe'sxtxi jxpe'jsa Dxusa' kĩhtewa jxuka ewsa'. Kwe'sxa' txajx nasatha'w, aça' nwe'weya' kĩhçxa', ewte nvxihtku. ");
INSERT INTO pbb_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Dxusna selpisáa Davxid ji'thewe'sx teeçx kaakh kĩhtewa jxuka nwe'weya' ãjãwa'jsa. ");
INSERT INTO pbb_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Nyafxiitey Dxus yuwe pta'sxsawe'sx yakhwa na'wẽk puutx we'we nwe'weya' kaahwa'ja's: ");
INSERT INTO pbb_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Kwe'sxtxi açesawe'sx kuseju nwe'weçxa ewte nvxiitu'nja, ");
INSERT INTO pbb_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Sa' kwe'sx yaçgawe'sxtxiwa peeygãhna, txã'wẽ adx puutx we'weni yuutxi' le'çxkuẽçxáa yuhwa peçxkaname'nja jĩ'k. ");
INSERT INTO pbb_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Sa' kwe'sx yaçgawe'sx Abrahan yakhwa txã'wẽyku na'wẽ puutx we'wena jurãy: ");
INSERT INTO pbb_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Kwe'sxtxi açesawe'sx kuseju nwe'weçxa ewte nvxiitu'nja, aça' ũukhmée mselpiiwe, ");
INSERT INTO pbb_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Adx yuuçxáana nwẽesẽ'jna uu entepkaçx jĩ'k. ");
INSERT INTO pbb_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Aça' adx nçxi'kkuẽ idxa' Dxus ĩtxĩsa yuwee pta'sxsa yuuçxa, kwe'sxtxi Nwe'wesa pa'jwa'ja's pheu'jna pekũjune'ga yaçte. ");
INSERT INTO pbb_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Kxah nasa' pkalpa'ga peltunãywa'ja's maawa jiyuçxa, ewte neeyũuwa'ja's ji'phutxna. ");
INSERT INTO pbb_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Kwe'sx Dxusa' peeygãhçxa, cielujuy sek na'wẽ kaakweethe'kh, ");
INSERT INTO pbb_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Çxhi'dxte uu ente na'wẽ yã'j ũstewa, wẽt eena'te nvxiht-ya'. Sa' kwe'sxtxiwa jxpubamée ewte kaafxi'ze'jya'k txã'wẽ yũu jĩnak we'we Zakariasa'. ");
INSERT INTO pbb_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Txajũ' Juana' walaana u'kh Dxus yuwe's jiyuna, sa' nasa u'pnimée kiwesuk u'p-ya' u'j, Israelwe'sxtxi pta'sxya' kasehwa'j en ãhpkaçx. ");
INSERT INTO pbb_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Txãn ensu' Romate jxkaahsa Augusto Cesara' txajx jxkaahni kiwesu nyafxçxah nasatx jxuka eçte ãsxkahn jxkaakh, ");
INSERT INTO pbb_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Siriate u'psa ne'jwe'sx Cirenio yaasesa's. ");
INSERT INTO pbb_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Aça' jxukaysatx u'jwa'j ji'phu' txãawe'sx upxni çxhabte, eçte ãsxkahn. ");
INSERT INTO pbb_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Txãa pa'gak Jose' Nasaret çxhab Galilea kiweju kasehna u'j Judea kiwen Belen çxhab Davxid upxnite, Jose' Davxid ji'kh yu' naa pa'ga. ");
INSERT INTO pbb_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Belenna u'jweççxa', txajx nyu yuuwa'jsa Maria yakhku u'j. Nawa Maria' nasak ji'ph yu'. ");
INSERT INTO pbb_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Aça' Belente ũsíyna, Maria's ãçã'wa'j en ãhte', ");
INSERT INTO pbb_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","kxtee ji'phuk nyafx nçxi'kkuẽ's. Sa' paadeewa'j yat ãhmeete', klaa sã'jĩni yattek luuçxkuẽ's yapçxa khikh. ");
INSERT INTO pbb_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Belen utxasu kuswa dehméetx piisxáa-thegsa u'p yu'. ");
INSERT INTO pbb_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Naapkaçxha' Dxus angel teeçx vxyaak txãawe'sx u'pnisu jxuka eena' kweethna. Aça' txãawe'sxa' wala ũukhtxi. ");
INSERT INTO pbb_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Nawa Dxus angela' na'wẽk we'we: —Ũukhnuwe, yuwe ewsa jxũna yuhth, txã'sa' maawa jxuka wala weçxaatxna. ");
INSERT INTO pbb_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Ãçxha' Davxid çxhabte teeçx upxku i'kwe'sxtxi nwe'wewa'jsa txã' Dxus kaahni Kristo'. ");
INSERT INTO pbb_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Aça' thegya' u'jçxa', uyuune'kwe luuçxkuẽ's yapçxa klaa sã'jĩni yatga khikhni ũste jĩçpkaçxha', ");
INSERT INTO pbb_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","txãa dudtey txãa angel yakh wala kuh angel cielujũwe'sx vxyaatx, Dxusna weçxana: ");
INSERT INTO pbb_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","¡Dxus ẽe walatewe'sxa' seena' yuh ew yuuk! Naa kiwete nasa wẽtwẽt fxi'zewa'ja's ũsku peeygãhçxa jĩ'tx. ");
INSERT INTO pbb_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Txajũ' angeleswe'sxa' cielun ki' sxawedna u'jweçpkaçxha', piisxáa-thegsawe'sxa' puutx we'wetx: —Belenna u'jwega Dxus pta'sxni's thegya' kĩh yũutewa uyu'nja'w jĩna. ");
INSERT INTO pbb_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Txajũ' wala dud u'jtx Belenna, sa' Mariawe'sxtxi' uytxi txã'wẽ luuçxkuẽ's klaa sã'jĩni yatga khikhçxa u'pte. ");
INSERT INTO pbb_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Sa' luuçxa's uyçxa', Dxus angel ma'wẽ we'weni'swa jxuka pta'sxtxi Mariawe'sxtxi. ");
INSERT INTO pbb_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Txajũ' vxitetxwa txã'wẽçxaçxáa pta'sxte', wala kuh we'wena neeyũutx. ");
INSERT INTO pbb_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Nawa Maria yu', txã'wẽ yũuni's jxuka peçxkanamée ũusteçxáak yajkxna fxi'ze'. ");
INSERT INTO pbb_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Txajũ' piisxáa-thegsawe'sxa' Dxus angel ma'wẽ pta'sxtewa txã' kxtey yuutewa uyçxa', Dxusa's wala weçxana sxawedna u'jtx. ");
INSERT INTO pbb_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Upxnijũ teeçx ki'sute' luuçxkuẽ's cirkuncidãyya' u'jçxa txãa entey JESUS yasetx, Maria nasa ji'phumeyna Dxus angel ma'wẽne' yase's pta'sx txã'wẽytxi yase. ");
INSERT INTO pbb_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Moises leya' nasate ãçã'satx ma'wẽne' ki'skaja' aça' Maria' txãa entxi kxtey yuuçxa', Jose yakh luuçxkuẽ's Jerusalen çxhabna jxũna u'jtx, dxuus yatte Dxusna weçxana neewe'weya'. ");
INSERT INTO pbb_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Dxus leyte we'weçxa': Nyafxte piçkuẽ yũute', Dxus jĩi nvxiitwa'ja' jĩ'k txãa pa'gatx Dxusna neewe'weya' u'j. ");
INSERT INTO pbb_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Vxite ahte Dxus leyte we'weçxa': e'z tub çxihme meeçxawa tub luuçx jxũna u'jçxa dxuus yatte ikhwa'ja' jĩ'k aça' txã'wẽy yũuya' u'jtx. ");
INSERT INTO pbb_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Txãn ensu' Jerusalen çxhabte' teeçx piçthẽ'j Simeon yaasesak u'pu'. Txãa piçthẽ'ja' Dxusna yuuçxáak neewe'wena fxi'zesa yu', ¿bagaçx Israelwe'sxtxi nwe'wewa'jsa pa'jakx? sũhna ũythãsna. Aça' Dxus Espiritu' Simeona's kaajiyu'kh ");
INSERT INTO pbb_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Nwe'wewa'jsa Dxus kaahni Kristo's uumey uywa'ja's. ");
INSERT INTO pbb_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Sa' Dxus Espiritu' Simeona's kaayaki'kh dxuus yatna u'jwa'ja's, aça' u'jçxa' uyku txã'wẽ Jesus njĩ'jwe'sxa' Dxus ley jxkaahni's kxtey yuuya' Jesusa's nuypa'jaçte. ");
INSERT INTO pbb_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Aça' Simeona' txãa luuçxkuẽ's yakhçxa na'jĩnak Dxusna weçxa: ");
INSERT INTO pbb_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Idxa' adx yakh puutx we'weni's kxtey yuug na' ãçxhã' adx uuwa'ja's ũsune'ga weçxana uukahn. ");
INSERT INTO pbb_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Nwe'wesa's nasa jxukaysa dxi'pte kaag. ");
INSERT INTO pbb_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Aça' txã'sa' adx yafxju yuu uythu. ");
INSERT INTO pbb_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Txãaíi Israel nasa meetxwa eena' kweethwa'jsa' na' Israelwe'sx yuutxi' jweeíiçxáa weçxweçxa kaayaki'jwa'jsa' jĩ'k. ");
INSERT INTO pbb_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Simeona' txãa luuçxkuẽ's txã'wẽ we'wete', Jose ptamwe'sxa' kuhtx yajkxna neeyũu. ");
INSERT INTO pbb_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Aça' Simeona' bedekĩyçxa', Jesus njĩ'j Maria's pta'sxku: —Mwẽesẽ'çx, naa luuçxkuẽ' Israelwe'sxtxi wala kçxhãaçxha'jwa'jsa' nawa txã'sna jiyusamée yu' wala jxpubawa'jsata'. Mpa'yajkxwe wakx txã'sa' wala açetxna. ");
INSERT INTO pbb_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Aça' maaçxah txã'wẽ açewa'jsatxna aça' maaçxah txã'wẽ jxpa'gawa'jsatewa txã'wẽ yũunisa içxa ũusuy we'thu yãjãni na'wẽ yuuna jĩk. ");
INSERT INTO pbb_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Kxteea' Fxanwel niisa, Aser ji'kh ũsu' wala thẽ'khuẽsa Ana yaasesa. Txã' Dxusna selpisaak yu' sa' wala kna'satey iimi'k nawa siete anxute' nmi'a' uuk. ");
INSERT INTO pbb_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Ãçxha' nmi' uuni oçxenta y kuatro anxu', nawa dxuus yatte pu'vxitumée een isak Dxusna selpiina, orãyna nes yu'. ");
INSERT INTO pbb_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Sa' Ana' utxaana kũhçxa, Dxusna weçxaçxa' pta'sxku Israelwe'sxtxi nwe'wewa'jsa's ũythãsna ũssawe'sxtxi's: Naa luuçx txã'wẽ yũuwa'jsa' jĩna. ");
INSERT INTO pbb_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Txajũ' Dxus jxkaahni leya's kxtey yuuçxa', Galilea kiwesu txãawe'sx çxhab Nasaretnay Maria Josewe'sxa' sxawedtxi. ");
INSERT INTO pbb_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Aça' luuçxkuẽ' walaana u'kh Dxus yuwe's jweeíiçxáa piyana, txã'sa' Dxusíi pu'çxhi'ne' naa pa'ga. ");
INSERT INTO pbb_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Jesus njĩ'jwe'sxa' anxu iisatx Jerusalen çxhabna Paskua fxiestan u'jwe'. ");
INSERT INTO pbb_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Sa' Jesus doce anxu ji'phpkaçxha', Jerusalen çxhabna fxiestate ki' u'jtx, ma'wẽne'ta anxu iisa u'jwe' txã'wẽy. ");
INSERT INTO pbb_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Aça' fxiesta pçuute', Maria Jose yakh sxawedna u'jtx. Sa' txãawe'sx jiyunimeete Jesusa' Jerusalentee neeyũuk. ");
INSERT INTO pbb_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Nawa njĩ'jwe'sx yu', Jesusa' nasa wala ksxavxyte yuhna sũhnaçxáatx teen uta dxi'the u'j. ");
INSERT INTO pbb_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Txajũ' nwe'sx ksxavxysu jxuka pakweçxawa uymeeçxa', Jerusalen çxhabnay pakweya' sxawedtxi. ");
INSERT INTO pbb_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Sa' tekh ensu' dxuus yatte ley kaapiya'jsawe'sx ksxavxyte wẽsẽ'jna paapẽjxna u'ptetx uy. ");
INSERT INTO pbb_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Txã'wẽ luuçxkuẽçxáaçxawa txakwe wala leya's jiiçxa ew paste', jxukaysa kxtee wẽsẽ'jna ũssa' wala kuh yaaki'tx. ");
INSERT INTO pbb_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Txajũ' njĩ'jwe'sx uyçxa', kuhtx yajkx sa' njĩ'ja' na'jĩk: —Idxa' ¿kĩjxa'ga pta'sxmée txã'wẽ neeyũu? Kwe'sxa' wala nxusna pakwetha'w jĩte', ");
INSERT INTO pbb_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Jesus pasçxa': —Adxa' Adx Tata jxthãasniçxá's selpiina u'pthu aça' ¿kĩjxa'kwe adxa's pakwé'? jĩte', ");
INSERT INTO pbb_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","txajx pasni'sa' jiyuya' ãjãmeeta'. ");
INSERT INTO pbb_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Txajũ' Jesusa' neywe'sx yakh Nasaretnay sxawedna u'jçxa txãawe'sxtxi nwẽesẽ'jnak fxi'ze. Aça' txajx njĩ'ja' ma'wẽ we'weni'swa jiyumeeçxawa txajx ũuste peçxkana yu' meek yajkxna fxi'ze'. ");
INSERT INTO pbb_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Txajũ' Jesusa' walaana u'kh Dxus yuwe's jweeíiçxáa piyana, sa' Dxus dxi'pte ew yũuçxak fxi'ze, nasaa dxi'ptewa txã'wẽy. ");
INSERT INTO pbb_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Tiberio Cesar Romate jxkaahna u'pni kince anxusu' Poncio Pilato' Judeate ne'jwe'sxku yu' aça' Herodesa' Galileate ne'jwe'sxku yu'. Naapkaçxha' txajx nyakh Fxelipe' Iturea vxite' Trakonitete ne'jwe'sxku yu'. Aça' Lisaniasa' Abiliniate ne'jwe'sxku yu'. ");
INSERT INTO pbb_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Naapkaçxha' sacerdote npiiçthẽ'jwe'sx yu' Anas vxite' Kaifxas txãawe'sxtxi yu'. Txãn ensuk Dxusa' txajx yuwe's nasa u'pnimeesu pta'sxya' u'khan pa'ya Zakarias nçxi'k Juana's. ");
INSERT INTO pbb_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Aça' Juana' Jordan yu'wala utxasu msuu msuuwa jxuka pekũjk nasatx pta'sxna: —I'kwe'sx pkaltxi nvxihtçxa Dxus tasxte sxawedçxa yu'te mkhẽewe ya'bautisãyna, i'kwe'sxtxi Dxus peltunãykahn jĩ'k. ");
INSERT INTO pbb_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Dxus yuwe pta'sxsa Isaias na'jĩna fxi'jni' kxtey yuuk: Nasa u'pnimée kiwesu sus we'wenik pthũuse' na'jĩna: Dxus pa'jwa'ja's mpheu'jwe, Txã' thẽymée pa'khan. ");
INSERT INTO pbb_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Kiwe kafx u'psuwa jxuka yuutawa'j yuuna, Sa' thã'j wala vxite' vxiç ma'k yuu nawa jxuka uukwe'jni yuutxna. Dxi'j ta'gusawa ku'le'jni yuutxna. Dxi'j ewmeesa's pheu'jni yuutxna. ");
INSERT INTO pbb_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Aça' nasa jxukaysa uyuutxna nwe'wewa'jsa Dxus kaahnisa's jĩna fxi'jni'. ");
INSERT INTO pbb_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Juan tasxte ya'bautisãyya' pa'jsatxi' na'jĩnak we'we: —I'kwe'sxa' ul weesweesa ji'ji'kwe, txãa pa'ga kastigo seena'sa yuja' aça' txajũ iyuwa'ja's ¿kimga pta'sx? ");
INSERT INTO pbb_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Txã'wẽ kastigo seena'saju iyuwa'ja's jiyuyã'jçxa', ewçxáa yũuna mfxi'zewe, kxah maawa uysa': Naawe'sxa' pkaltxi nvxihtçxa Dxus tasxte sxawed yuhta sũjũtxna. Txã'jĩte', kwe'sxa' Abrahan ji'tha'w sũhna iiwejçx yajkxna fxi'zewa'jme'. Na'jĩ'th na': I'kwe'sxçxáamée naa kwet yuhtxwa Abrahan ji'j vxit-ya' ãjãna Dxusa'. ");
INSERT INTO pbb_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Txã'wẽ ewçxáa yũuna fxi'zemeete', ama' ih yã'j ũsa' fxtũu tasxtxi spẽ'thya'. Maa fxtũu tasxwa ew yũnmeena aça' spẽ'thçxa ipxte kabwa'jçxáa yuuna jĩnak yu'kxpeh. ");
INSERT INTO pbb_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Txã'jĩte' nasa' paapẽjxtxi: —¿Kĩhçxa yũuna ewçxáa fxi'zekxtha'w? jĩte', ");
INSERT INTO pbb_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Juan pasçxa': —E'z atxh ji'phçxa', ji'phmeesa'sa' teeçx ũswa'ja'. Aça' ũ'niwa jxthaakwe ji'phçxa', vxite ji'phmeesa's puuçwa'ja' jĩk. ");
INSERT INTO pbb_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Txã'wẽy gobierno jĩi vxyu pkhakhsawe'sxwa yu'te ya'bautisãyya' utxaaçxa', Juana's na'wẽtx paapẽjx: —Mpeeta'sx, kwe'sxa' ¿ma'wẽ yũuna fxi'zekxtha'w? jĩte', ");
INSERT INTO pbb_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Juan pasçxa': —Ley makwene' vxyu's pẽykaja' txã'sçxáana mpẽjxwe, ĩsxĩiçxa thaakwe pẽjxmée jĩk. ");
INSERT INTO pbb_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Txajũ' soldauwe'sxwa maaíi yũ' txã'wẽy pẽjxtxi: —Kwe'sxa' ¿ma'wẽ yũuna fxi'zekxtha'w? jĩte', txãawe'sxtxiwa pta'sxku Juana': —Maa nasa yuhtxwa juuna' we'weçxa txãawe'sx jĩitx kusa'jnuwe kĩh yuhnawa. Sa' kĩh yuhwa yuuwemeetewa ĩsxĩiçxa pãatxhĩ'khna fxi'zenuwe. Sa' i'kwe'sxtxi makwe dewetewa txãa yakhçxáa weçxana mfxi'zewe. ");
INSERT INTO pbb_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Txã'wẽ we'wena ũste', nasa wẽsẽ'jsa yu' wala yajkxna ũsu'tx: Meeçxa' ¿naa wáa Kristona? sũhna. ");
INSERT INTO pbb_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Aça' Juana' jxukaysatx pta'sxku: —Adxa' bautisãyna naasáa yu'teçxáath akhe'. Nawa adx e'suh vxite yuja', txã' Dxus Espiritu ipx na'wẽsa's i'kwe'sx ũuste kxu'akhe'jya' ãjãwa'jsa'. Aça' adxa' txajx pelgatxi wesçxáa yuhtxwa khihbxa' ãjãwa'jmeesath. ");
INSERT INTO pbb_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Txã' yujxa' skuutxh kweejxa'jni plaatu's kusete at yã'jçxa ũsa'. Sa' kweejxa'jçxa skuutxha's jxaawuuna, nawa tama'sa' ipx bagaçxte yuhwa ũçxhawa'jmeesate kabuna jĩk. ");
INSERT INTO pbb_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Txã'wẽk wala kuh jwed yu'kxpehna Dxus yuwe's pta'sxi' Juana'. ");
INSERT INTO pbb_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Sa' ne'jwe'sx Herodesa'swa yu'kxpejk txã'wẽ nyakh Fxelipe nyu Herodiasa's kusa'jçxa, txãa yakh nyu na'wẽ fxi'zeçxa vxite' kĩhwa ewmeeçxáak yũuna ũsu'. Aça' txãa pa'gak txã'wẽ yũuwa'jme' jĩna yu'kxpeh Juana'. ");
INSERT INTO pbb_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Nawa Herodesa' nwẽesẽ'jepkaçxte jweeíiçxáak thaakwe ewmée yũu, Juana's karcelte kaakxuupha'jna. ");
INSERT INTO pbb_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Txã'wẽ yũumeyna Juana' nasatx yu'te bautisãyna ũste', Jesuswa pa'jçxa yu'te ya'bautisãyku. Sa' oraĩçpkaçxha', cielu' phaatek. ");
INSERT INTO pbb_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Aça' Dxus Espiritu' Jesus kajkwete tub çxihme na'wẽsak vxyaana kĩh. Naapkaçxha' cieluju na'wẽ we'wenik pthũuse: —Idxa' adx Nçxi'k wala wedxnisag, aça' iidxpa'ga wala weçxana ũsthu jĩni. ");
INSERT INTO pbb_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jesusa' treinta anxu ji'phçxak Dxus yuwe's pta'sxya' takh. Jesusa' Jose nçxi'ka' jĩnisak yu'. Josea', Eli nçxi'kku yu'. ");
INSERT INTO pbb_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Elia', Matat nçxi'kku yu'. Matatha', Levxi nçxi'kku yu'. Levxia', Melki nçxi'kku yu'. Melkia', Jana nçxi'kku yu'. Jana', Jose nçxi'kku yu'. ");
INSERT INTO pbb_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Josea', Matatias nçxi'kku yu'. Matatiasa', Amos nçxi'kku yu'. Amosa', Nahum nçxi'kku yu'. Nahuma', Esli nçxi'kku yu'. Esli', Nagai nçxi'kku yu'. ");
INSERT INTO pbb_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagaia', Maat nçxi'kku yu'. Maatha', Matatias nçxi'kku yu'. Matatiasa', Semei nçxi'kku yu'. Semei', Jose nçxi'kku yu'. Josea', Juda nçxi'kku yu'. ");
INSERT INTO pbb_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Juda', Joana nçxi'kku yu'. Joana', Resa nçxi'kku yu'. Resa', Zorobabel nçxi'kku yu'. Zorobabela', Salatiel nçxi'kku yu'. Salatiela', Neri nçxi'kku yu'. ");
INSERT INTO pbb_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri', Melki nçxi'kku yu'. Melkia', Adi nçxi'kku yu'. Adi', Kosam nçxi'kku yu'. Kosama', Elmodam nçxi'kku yu'. Elmodama', Er nçxi'kku yu'. ");
INSERT INTO pbb_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Era', Joswe nçxi'kku yu'. Joswe', Eliezer nçxi'kku yu'. Eliezera', Jorim nçxi'kku yu'. Jorima', Matat nçxi'kku yu'. ");
INSERT INTO pbb_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Matatha', Levxi nçxi'kku yu'. Levxia', Simeon nçxi'kku yu'. Simeona', Juda nçxi'kku yu'. Juda', Jose nçxi'kku yu'. Josea', Jonan nçxi'kku yu', Jonana', Eliakim nçxi'kku yu'. ");
INSERT INTO pbb_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliakima', Melea nçxi'kku yu'. Melea', Mainan nçxi'kku yu'. Mainana', Matata nçxi'kku yu'. Matata', Natan nçxi'kku yu'. ");
INSERT INTO pbb_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Natana', Davxid nçxi'kku yu'. Davxida', Isaí nçxi'kku yu'. Isaía', Obed nçxi'kku yu'. Obeda', Booz nçxi'kku yu'. Booza', Salmon nçxi'kku yu'. Salmona', Naason nçxi'kku yu'. ");
INSERT INTO pbb_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Naasona', Aminadab nçxi'kku yu'. Aminadaba', Aram nçxi'kku yu'. Arama', Esrom nçxi'kku yu'. Esroma', Fxares nçxi'kku yu', Fxaresa', Juda nçxi'kku yu'. ");
INSERT INTO pbb_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Juda', Jakob nçxi'kku yu'. Jakoba', Isaak nçxi'kku yu'. Isaakha', Abrahan nçxi'kku yu'. Abrahana', Tare nçxi'kku yu'. Tare', Nakor nçxi'kku yu'. ");
INSERT INTO pbb_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nakora', Serug nçxi'kku yu'. Seruga', Ragau nçxi'kku yu'. Ragaua', Peleg nçxi'kku yu'. Pelega', Heber nçxi'kku yu'. Hebera', Sala nçxi'kku yu'. ");
INSERT INTO pbb_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sala', Kainan nçxi'kku yu'. Kainana', Arfxaxad nçxi'kku yu'. Arfxaxada', Sem nçxi'kku yu'. Sema', Noe nçxi'kku yu'. Noe', Lamek nçxi'kku yu'. ");
INSERT INTO pbb_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamekha', Matusalen nçxi'kku yu'. Matusalena', Enok nçxi'kku yu'. Enokha', Jared nçxi'kku yu'. Jareda', Mahalaleel nçxi'kku yu'. Mahalaleela', Kainan nçxi'kku yu'. ");
INSERT INTO pbb_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kainana', Enos nçxi'kku yu'. Enosa', Set nçxi'kku yu'. Setha', Adan nçxi'kku yu'. Adan yu', Dxus kuseju yuu pheu'jnisak yu'. ");
INSERT INTO pbb_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Dxus Espiritu Jesusa's jxpe'jya' jxukate vxyaanijũ', Jesusa' Jordan yu'walaju kasejk, aça' Espiritu' pe'jna u'kh nasa u'pnimeesu. ");
INSERT INTO pbb_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Kxteea' kuarenta en kĩh yuhwa ũ'mée u'pçxa', wẽek. Aça' eçxthẽ'ja' pa'kh ewmée vxit wẽeçxa. ");
INSERT INTO pbb_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Sa' pa'jçxa na'jĩk: —Dxus Nçxi'k dxihçxa', naa kweta's pan myuukaah jĩte', ");
INSERT INTO pbb_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Jesus pasçxa': —Nasa' pan yakhçxáa yu' ĩtxĩ fxi'zemeetxna, naasáa jxuka Dxus we'weni yakh yuuçxáa ĩtxĩ fxi'zetxna jĩna fxi'jni ũsa' Dxus librute' jĩnak pas. ");
INSERT INTO pbb_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Txajũ' eçxthẽ'ja' teeçx thã'the Jesusa's pe'jna u'jçxa', txãa vxiçu mtee mtee çxhab walatxwa kaavxya'ja'jçxa, ");
INSERT INTO pbb_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","na'jĩk: —Naa çxhabtxi petx kiwe kĩjkĩhtxwa jxuka idxçxaçxá's ũsu'nja. Na' jxuka adx kuseteçxaçxáa dukhnisata' aça' maawa adx wedxnisa yu'sa' ũsuçxá'nja. ");
INSERT INTO pbb_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Idxwa adx tasxte peejxũkweçxa neewe'wene'ga aça', jxuka iidx jĩiçxaçxáa yuutxna jĩte', ");
INSERT INTO pbb_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Jesus pasçxa': —Idxna jxpe'jsa Dxusçxá's neewe'wewa'ja', sa' txãaçxá's selpiwa'ja' jĩ'k Dxus librute aça' eçxthẽ'j adx tasxu me'j jĩk. ");
INSERT INTO pbb_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Txãa e'su', eçxthẽ'ja' Jesusa's Jerusalenna pe'jna u'jçxa, dxuus yat ẽete kaateka'jçxa' na'jĩk: —Dxus Nçxi'k dxihçxa', kute ayjxu mũph kiwekhẽ. ");
INSERT INTO pbb_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Txãa pa'gatey Dxus librute we'weçxa': Txajx angeleswe'sxtxi jxkaajana idxa's nwe'wekahn. ");
INSERT INTO pbb_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Aça' angeleswe'sxa' kusete jxpa'gatxna, iidx çxida kwette kpã'yũukahmén jĩte', ");
INSERT INTO pbb_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Jesus pasçxa': —Dxus librute': Idxna jxpe'jsa Dxusa's jxkaahwa'j ji'phmeeg jĩ'k jĩna paste', ");
INSERT INTO pbb_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","eçxthẽ'ja' ãjãmée yã'jçxa', Jesusa's nvxihtçxa u'kh sa' maz en yu' vxyaame'. ");
INSERT INTO pbb_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Txajũ' Jesusa' Dxus Espiritu jxpe'jni ki' Galileate sxawedna pa'the', txãa kiwesu nasa' jxuka Jesusçxaçxá'stxi we'we' kĩjkĩhwa yũ'k jĩna. ");
INSERT INTO pbb_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Txajũ' Jesusa' judiuwe'sx pkhaakhenisu Dxus yuwe's kaapiya'the', jxukaysa wala weçxana tuuthe'je'tx. ");
INSERT INTO pbb_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Txajũ' Jesusa' Nasaretnak u'j, txajx walaní çxhabna. Sa' kxte pa'jçxa', sapatu jxkaase ensu' ma'wẽne' yũ' txã'wẽy, judiuwe'sx pkhaakhenite u'kaçxa yujuk Dxus libru's lẽeyya'. ");
INSERT INTO pbb_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Aça' Dxus yuwe pta'sxsa Isaias libru'stxi ũs. Aça' na'wẽ fxi'jnikhẽk libru's phaade: ");
INSERT INTO pbb_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Dxus Espiritu' adx yakh ũsa', Txãasak adxa's txhitxh yuwe ewsa's puupletx pta'sxkahn. Ũuste nxusna u'psatxku kvxiisxa'jya' adxa's kaah, Yuuwesa preesutx nwe'wewa'ja'sku pta'sxya' kaah, Sa' uysameetxi' kaauyu'jna, Pkxuunisatxi' nwe'weçxa, ");
INSERT INTO pbb_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Jxukasa weçxana neeyũuwa'j anxu ãani's pta'sxya'k kaah jĩni's lẽeyçxa', ");
INSERT INTO pbb_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Jesusa' libru's aphçxa, judiuwe'sx pkhaakhenite pu'çxsa's dukhna'wa, kaçxku. Aça' jxukaysa judiuwe'sx pkhaakhenite ũssa' ivxiitumeetx Jesusa's thegna neeyũu ũythãsna. ");
INSERT INTO pbb_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Aça' Jesusa' na'jĩnak pta'sx: —Na'wẽ fxi'jnisa's wẽsẽ'ji'kwe txã' ãçxhã' kxtey yuuwa'j en ãjk jĩk. ");
INSERT INTO pbb_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Txajũ' jxukaysa Jesusa's ewçxáatx we'wena kuh yajkxna neeyũu, txã'wẽ zhiçxkwe pta'sxte'. Sa' puutx paapẽyi'tx: —Naa piçthẽ'ja' ¿Jose nçxi'k meená'? jĩte', ");
INSERT INTO pbb_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Jesus pasçxa': —Isa yuuwa i'kwe'sxa' adxa's naa sũjũ'ne'kwe: Yu'çe'jsa, idxíi mya'yu'çe'j. Sa' na'jĩya'wane'kwe: Kapernaumte kĩjkĩhwa ew yũuk jĩni's wẽsẽ'je'tha'w txãatxi' txã'wẽy myũu ayte iidx kiwetewa jĩya'wane'kwe jĩçxa', ");
INSERT INTO pbb_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","ki' we'wek: —Isath we'we': Dxus yuwe pta'sxsa' peekx kiwesu' weeçxni yuuçxáa fxi'zetxna maawa. ");
INSERT INTO pbb_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Dxus yuwe pta'sxsa Elias ensu Israel kiwesu' wala kuh vxiuda ũsu'tx, na'wẽ tekh anxu y medio nus pa'jmeete', wala wẽjẽ pa'kh txãa ensu. ");
INSERT INTO pbb_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Nawa Dxusa' Eliasa's kxazkuẽ vxiuda tasxsu jxuka yu' kaahmée, naasáa Sidon çxhab wala pukasu Sareptate teeçx vxiuda tasxte yuuçxáak kaah. ");
INSERT INTO pbb_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Txã'wẽy Israel kiwesu' wã'jy weete wala ãçã'sa ũsu'tx, Dxus yuwe pta'sxsa Eliseo ensu. Nawa maa yuhtxwa nuykatxhimée, naasáa Naaman Siria kiwetewe'sx yuuçxá'sku nuykatxhi jĩte', ");
INSERT INTO pbb_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","wẽsẽ'jçxa', judiuwe'sx pkhaakhenite u'psa' wala ũusaçxana, ");
INSERT INTO pbb_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","kiiteçxa Jesusa's çxhabuh kutxi'jtx. Txãa çxhab Nasaret yu', thã'j vxiçgak ũsu', aça' txãa penxa vxiçuhtx ukapajkxya'wa yu'. ");
INSERT INTO pbb_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Nawa Jesusa' txãawe'sx ksxavxysu uymeyna skhẽwçxa u'kh. ");
INSERT INTO pbb_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Txajũ' Jesusa' Galileate Kapernaum çxhabte pa'jçxa', sapatu jxkaase ensu' Dxus yuwe's pta'sxna ũsu'k. ");
INSERT INTO pbb_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Aça' nasa' wala kuh yajkxna wẽsẽ'je'tx, txã'wẽ Dxusa's nwẽese'jwa'ja's ũukhnus pta'sxpa'ga. ");
INSERT INTO pbb_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Aça' kxte judiuwe'sx pkhaakhenite teeçx piçthẽ'j u'pu'k, eçx iiyamunisa. Txã' susku na'jĩna we'we: ");
INSERT INTO pbb_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","—Jesus Nasarethuwe'sx, kwe'sxtxi' ¿kĩhga yũu wẽjẽ'? Kuçx yuunu. Meeçxa' ¿ivxiituya'wagá'? Idx kimtewa jiith. Idxa' Dxus kaahnisag jĩte', ");
INSERT INTO pbb_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Jesusa' txãa eçx luuku vxit-sa's juuna'k na'jĩna we'we: —Sxuuna' myuu, sa' naa piçthẽ'j ũusuh mkaaseh jĩte', txãa eçxa' txãa piçthẽ'ja's nasaa ksxavxysu pẽtxçxa txajx ũusuh kasejk kĩh yuhwa kpã'vxitmée. ");
INSERT INTO pbb_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Txã'wẽ yũute', jxukaysa ũukhçxa txãawe'sx pwe'sx na'jĩnatx puutx we'we': —Jesusa' ¿kimki saki'k txã'wẽ juuna' jxkaahna we'weteçxáa eçx yuhwa nwẽesẽ'jçxa' kaseje'? jĩ'tx. ");
INSERT INTO pbb_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Aça' Jesus txã'wẽ yũuni's msuuwa jxukatx wala tuuthe'je' txãa ja'dasu. ");
INSERT INTO pbb_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Txajũ' Jesusa' judiuwe'sx pkhaakhenijũ kasehçxa', Simon yattek pa'j. Aça' Simon nyu njĩ'ja' wala kakwesekte ãçã'na ũsu'k. Txajũ' Jesusa's pxthaa we'wena pta'sxtxi. ");
INSERT INTO pbb_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Aça' Jesusa' ãçã'sa tasxte kũhçxa kakwesek ũçxhakahn we'wek. Naapkaçxha' kakweseka' ũçxhate', kiiteçxa selpiiya' kasejk. ");
INSERT INTO pbb_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Txajũ' sek khẽjẽçte', nasa kĩjkĩh weeteçxah ãçã'satxwa jxuka Jesus tasxte nuypa'jtx. Aça' ãçã'sa kakwesu kuseju jxa'dxçxaçxáa jxuka nuykatxhik. ");
INSERT INTO pbb_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Txãa ãçã'sawe'sx maaíi yu' eçx luuku vxit-sa's ũuste ji'phtewa txãa eçxwa suhs na'jĩna kasehtx: —Idxa' Dxus Nçxi'kgu jĩna. Txãawe'sxa' Dxus Nçxi'ktewa jiitx yu'. Nawa Jesusa' juuna' we'weçxa jwee yu' kwe'we'jme'. ");
INSERT INTO pbb_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Khikhiiçte', Jesusa' çxhab eka jxu'j lajkxsuk kaseh. Nawa nasa' kxteewa pakwena pa'jtx, vxite ahsu u'khamén neevxisxaya'. ");
INSERT INTO pbb_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Nawa Jesusa' na'wẽk pta'sx txãawe'sxtxi': —Dxus jxkaahwa'j yuwe's pta'sxwa'j ji'pthu vxite çxhabsuwa. Txã'wẽ yũuya' íiçxáa kaahnisath jĩk. ");
INSERT INTO pbb_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Txãasak Galilea kiwesu judiuwe'sx pkhaakhenisu Dxus yuwe's pta'sxna pekũh. ");
INSERT INTO pbb_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Teeçx ente' Jesusa' Genesaret ĩkh pukate ũste', nasa' kxtee zuuna'çxáatx utana pa'j Dxus yuwe's wẽsẽ'j wẽeçxa. ");
INSERT INTO pbb_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Txajũ' Jesusa' e'z barko ĩkh pukasu namu ji'phmée ũstek uy, namu wedx-uwesaawe'sx yu' kasehçxa, wedx ukhetx thethnatx ũs yu'. ");
INSERT INTO pbb_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Aça' Jesusa' teeçx barko Simon jĩite khẽeçxa', yu'te wejkuẽ u'jçxak, kxtee kaçxçxa, Dxus yuwe's pta'sx nasatx. ");
INSERT INTO pbb_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Sa' Dxus yuwe's pta'sxna jxã'jçxa', Simona's na'jĩk: —Barko's ĩkh wala pxãhte pa'j jxũna u'jçxa txkhẽe ukhe's makh wedx uweya' jĩte', ");
INSERT INTO pbb_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simon pasçxa': —Kwe'sxa' teeçx kus utatha'w mjĩina pe'te, nawa teeçx wedxçxáa yuhwa uwemeetha'w. Nawa iidx jxkaahni's kxtey yu'nja jĩçxa', ");
INSERT INTO pbb_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","kxtey yuute', wedx wala kuh khẽetx, aça' ukhe' suteeçku yu'. ");
INSERT INTO pbb_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Txajũ' vxite barkote ũssatx pu'çxya' yuukahn kuseju pa'yatx. Aça' txãawe'sxwa kũhçxa', kasxisx pu'çxçxa txãawe'sx jĩitewa ãsxtxi. Nawa e'z barkotey utaçxa dujuaate', ĩkh dxiikhẽ khẽeya'watx yu'. ");
INSERT INTO pbb_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Txã'wẽ yuute', Simon Pedro' Jesus tasxte peejxũkweçxa na'jĩk: —Adxa' pkalsath aça' adx tasxu mtxutée jĩk. ");
INSERT INTO pbb_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Kxaazkuẽe wedx khẽete', Simon Pedro' wala ũukhçxak txã'jĩ', aça' nasa kxtee ũssawa txã'wẽytxi ũukh. ");
INSERT INTO pbb_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Zebedeo nçxi'kwe'sx Jakobo Juan txãawe'sxa' Simon yakh wedx uwe pu'çxna u'jusatx yu' sa' txãawe'sxwa txã'wẽytxi wala ũukh. Nawa Jesusa' Simona's na'jĩk: —Ũukhnu, ãçxhũyã'ja' peena yu' wedx uwen u'jumée nasatx Dxus jĩi pkhakhsa yuune'ga jĩte', ");
INSERT INTO pbb_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","barkotx ĩkh pukatee jxuka nvxihtna'wa Jesus yakh u'jtx. ");
INSERT INTO pbb_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Jesusa' teeçx çxhabte ũste', teeçx piçthẽ'j wã'jy wee seena' kazx ji'phsak pa'j. Sa' Jesusa's uyna'wa, kĩiçhuçxa peejxũkwek na'jĩna: —Adxa's nuykatxhiwá'ga ahçemeeçxa' jĩte', ");
INSERT INTO pbb_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Jesusa' kuseju jxa'dxna'wa, na'jĩk: —Ahçeme'nja, naa pa'ga katxhiçxa mneeyũu jĩçpkaçxha', txãa wã'jy weeju katxhiçxak neeyũu. ");
INSERT INTO pbb_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Aça' Jesusa' na'wẽk jxkaah: —Maa yuhtxwa pta'sxmeene'ga, naasáa sacerdoteçxá's iidx kakwe's txwesya' me'j. Sa' txãa weeju katxhipa'ga Dxusna peesune'ga Moises ma'wẽga jxkaah txã'wẽy, kxah nasa jxukaysa jiyutxna idx ew katxhiçxa neeyũutewa jĩnak jxkaah. ");
INSERT INTO pbb_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Tuuthe'khameetewa, nasa' jweeíiçxáatx Jesus ew yũuni's tuuthe'je'. Aça' wẽsẽ'jya' wala pkhaakhe'tx, ãçã'satxwa kĩh weejuwa nuykatxhikahn. ");
INSERT INTO pbb_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Nawa Jesusa' nasa u'pnimeesu u'jçxak, Dxus yakh puutx we'we'. ");
INSERT INTO pbb_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Jesusa' teeçx çxhabte Dxus yuwe's pta'sxna ũste', kxteea' fxariseowe'sx vxite' Dxus leya's kaapiya'jsawe'sxwa Galileaju Judeaju vxite' Jerusalenu txajũwe'sx pa'jçxatx kxsũ kaçxçxa u'pu'. Aça' Dxus pu'çxni yakha' Jesusa' ãçã'satxwa nuykatxhi'k. ");
INSERT INTO pbb_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Txajũ' ẽsẽya' ãjãsameea's yakhçxa nuypa'jtx. Sa' Jesus tasxte pa'j nuykũh wẽetx. ");
INSERT INTO pbb_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Nawa nasa wala ũste', u'kaya' ãjãmeeçxa yat ẽete tejkaçxatx txkhẽ nuykĩh ãçã'sa's Jesus ũsnikhẽ. ");
INSERT INTO pbb_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Txajũ' ãçã'sa's yakhsawe'sxa' Jesusa' nuykatxhiyujuna sũhni's jiyuçxa', ãçã'sa's na'jĩk: —Iidx pkala' peltunãyni yã'jtx neeyũu jĩte', ");
INSERT INTO pbb_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Dxus leya's kaapiya'jsawe'sx vxite' fxariseowe'sxa' ũuste na'wẽtx yajkxna u'pu': Naa piçthẽ'ja' ¿kiimna saga Dxusa's iiweeçx we'wé'? Dxus yuuçxáa pkaltxi peltunãyya' ãjawa'jsa', aça' jweeju yu' ¿kimçxá' peltunãyya' ãjãma'k? sũjũ'tx. ");
INSERT INTO pbb_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Aça' Jesusa' txãawe'sx ũuste yaakxni's jiyuçxa' na'jĩk: ");
INSERT INTO pbb_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","—¿Kĩh yũutekwe txã'wẽ yaakí'? ¿Maa thẽymeesakx? Iidx pkala' peltunãyni yã'jtx neeyũu ¿jĩniá'? Meeçxa': Kiiteçxa me'j ¿jĩniá'? ");
INSERT INTO pbb_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Txã'wẽ thẽysatewa Dxus Nçxi'k Nasa Yuusá' naa kiwete pkaltxi peltunãyya' ãjãwa'jsa' naa pa'ga kaajiyu'jya'wath ãçxha' jĩçxa', txajũ' txãa ẽsẽya' ãjãsameea's we'wek: —Idxa'sthu we'we': Kiiteçxa iidx deeni's tu'sçxa yatna me'j jĩte', ");
INSERT INTO pbb_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","dudtey txãa ãçã'sa' kiitena' txajx deeni's tu'sçxa yatna u'kh, Dxusna weçxana tuuthe'jna. ");
INSERT INTO pbb_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Jxukaysa kxtee ũssa' wala kuh yajkxna we'wena, Dxusçxáanatx weçxana tuuthe'je' sa' txã'wẽ ũukhnawa na'jĩ'tx: —Bagaçx yuhwa txã'wẽ yũunisa yu'sa' iiuymeetha'w jĩ'tx. ");
INSERT INTO pbb_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Txãa skhẽwa', Jesusa' kasehçxa', gobierno jĩi vxyu pkhakhsa Levxi yaasesa's vxyu pkhakhnite kaçxçxa u'pte uyçxa': —Adx yakh myuh jĩte', ");
INSERT INTO pbb_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Levxia' kiitena'wa kĩhnawa jxuka nvxihtçxa Jesus yakh u'kh. ");
INSERT INTO pbb_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Txãa e'su', Levxia' txajx yatte fxiesta wala ewsa vxitku Jesusa's pi'kxçxa'. Aça' kxte' gobierno jĩi vxyu pkhakhsawe'sx wala kuhsa vxite' nasa ma'wẽsawa Jesus yakh ih mesate kaçxtxi. ");
INSERT INTO pbb_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Aça' fxariseowe'sx vxite' ley kaapiya'jsawe'sxa' Jesus yakh u'jusawe'sxtxi' na'wẽtx açewe'we: —I'kwe'sxa' ¿ma'wẽtekwe txã'wẽ gobierno jĩi vxyu pkhakhsawe'sx yakh vxite' pkalsawe'sx yakh ũ'wé'? jĩte', ");
INSERT INTO pbb_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Jesus pasçxa': —Yu'çe'jsa's jxpeejxmeeta' aka ji'phmée wẽt ũssa', naasáa ãçã'sa yuuçxáa yu'çe'jsa's jxpeejxta'. ");
INSERT INTO pbb_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Adxa' nasa ewsatx pakweya' kĩhmeeth, naasáa pkalsatx pakweya'çxáath kĩh, kxah ewmée yũuna fxi'zeni's nvxihtçxa Dxus tasxte sxaweduutxna jĩk. ");
INSERT INTO pbb_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Txajũ' txãawe'sxa' Jesusa's na'wẽtx paapẽjx: —¿Ma'wẽçxata Juan yakh u'jusa vxite' fxariseowe'sx yakh u'jusa txãawe'sxa' tahtatey yũunaana Dxus yakh puutx we'wena fxi'ze'? Naapkaçxha' idx yakh u'jusawe'sx yu' yũunameetx fxi'ze' jĩte', ");
INSERT INTO pbb_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Jesus pasçxa': —I'kwe'sxa' ¿ptamu en fxiestate', pi'kxnisatxi' kaayũuna'jya' ãjãma'kwe, novxio txãawe'sx yakh nee ũsiite'? ");
INSERT INTO pbb_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Nawa novxio' txãawe'sx tasxu txuteewa'j en pa'jana, txajũ isa yũunaatxna jĩçxa', ");
INSERT INTO pbb_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","naa ejemplo's kaaja'da'jnak pta'sx: —Ropa ĩisx suteniite, tela u'sesa yakh ya'pã'khe'çme'. Txã'wẽme' tela u'sesa' jweeíiçxáak sude' ĩisxsa's. ");
INSERT INTO pbb_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Sa' txã'wẽy beka u'se aahnisa's slun ĩisxsate ya'awu'çme'. Txã'wẽme' beka u'sesa' slun ĩisxsa's sude'k, aça' beka yakh slun yakh e'zíi vxitu'tx. ");
INSERT INTO pbb_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Txãa pa'ga beka u'sesa's slun u'sesate awwa'ja'. Txã'wẽ yu', maa yuhwa vxitumeetxna. ");
INSERT INTO pbb_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Aça' maawa beka jxaawniisa's tudxsa', beka u'sesa's yu' tudxya' wa'lu'k, jxaawniisaçxáa jxthaakwe ewa' jĩçxa. ");
INSERT INTO pbb_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Teeçx sapatu jxkaase ente', Jesusa' skuutxh ehsu u'jweçte', txãa yakh u'jusawe'sxa' skuutxhtxi ũhdena nxinxtxi sũupi'jçxa ũ'tx. ");
INSERT INTO pbb_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Aça' fxariseowe'sx maaíi yu' pẽjxtxi: —I'kwe'sxa' ¿mjĩipa'gakwe mjĩi en meetewa txã'wẽ yũ'? jĩte', ");
INSERT INTO pbb_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Jesusa' na'wẽk pas: —I'kwe'sxa' Dxus librute iilẽeymeewá'kwe' Davxida' ¿kĩhga yũu? txãa yakh pi'kxna u'jusawe'sx yakh teeçx ente' wẽeçxa', ");
INSERT INTO pbb_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","dxuus yatte u'kaçxa kxtee pantxi ũ'k, sa' txãa yakh u'jusawe'sxtxiwa ũsu'sku. Txãa pana' naasáa sacerdotewe'sxçxáa ũ'wa'the jiiçxawa txã'wẽk yũu. ");
INSERT INTO pbb_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Aça' Dxus Nçxi'k Nasa Yuusaawa makwe sapatu jxkaase entewa jxkaahwa'j ji'pha' jĩk. ");
INSERT INTO pbb_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Vxite sapatu jxkaase ensu', Jesusa' judiuwe'sx pkhaakhenite u'kaçxa, Dxus yuwe's pta'sxya' takhku. Aça' kxte' teeçx piçthẽ'j paçu kuse udxnisak u'p yu'. ");
INSERT INTO pbb_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Aça' Dxus leya's kaapiya'jsawe'sx vxite' fxariseowe'sxa' Jesusa's peethegu'natx ũsu' txã'wẽ sapatu jxkaase entewa nuykatxhite' pãatxhĩ'khya' sũhçxa. ");
INSERT INTO pbb_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Nawa Jesusa' peethegu'sawe'sx txã'wẽ ũus yaakxni's jiyuçxa', na'jĩk txãa piçthẽ'j kuse udxnisa's: —Kiiteçxa, nasaa pxãhte myuju jĩte', txãa piçthẽ'ja' nasaa pxãhtek yuju. ");
INSERT INTO pbb_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Aça' Jesusa' nasa kxte ũssatx na'jĩk: —I'kwe'sx ¿ma'jĩki'kwe? Sapatu jxkaase entewa, pu'çxte ¿ewmanx? meeçxa' ¿pu'çxwa'jmeemanx? Nasa's nwe'wete ¿ewmanx? meeçxa' nwe'wemeete ¿ewmanx? jĩçxa', ");
INSERT INTO pbb_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Jesusa' nasatx thegçxa', txãa ãçã'sa's na'wẽk jxkaah: —Kuse's mku'le'j jĩçpkaçxha' txã'wẽy yũute', txajx kuse' ewuuk. ");
INSERT INTO pbb_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Nawa vxitesa yu' wala ũusaçxatx, sa' puutx paapẽyi'tx: Jesusa's ¿ma'wẽ yũuçxa ewmeete nvxiitukxtha'w? jĩna. ");
INSERT INTO pbb_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Txãn ensuy Jesusa' Dxusna pẽjxya' u'kh thã'the sa' teeçx kus utak Dxusna pẽjxna pe'te. ");
INSERT INTO pbb_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Sa' khikhyna sẽhte', txã'sna pi'kxna u'jusa kuhsatx pa'yaçxa', doce nasa txhitxhku txajx jxkaahwa'j. ");
INSERT INTO pbb_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Txãawe'sxa' naaçxahtx yu': Simon, txã'sa' Pedro yasek ki'p. Vxite' nyakh Adres, txajũ' Jakobo, Juan, Fxelipe, Bartolomé, ");
INSERT INTO pbb_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateo, Tomas, Alfxeo nçxi'k Jakobo, Simon kananista nasa, ");
INSERT INTO pbb_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Jakobo nyakh Judas, vxite' Judas Iskariote, Jesusa's açesawe'sx kusete dukhwa'jsa. ");
INSERT INTO pbb_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Jesusa' txãa yakh u'jusawe'sx yakh thã'j vxiçu jxsa'jna kĩhçxa', teeçx ahte txaktek yuju nasa wala kuhsawe'sx yakh. Txãa nasa' Judea kiwesuwe'sx, Jerusalen çxhabuwe'sx, vxite' ĩkh wala pukasu Tiro Sidon çxhabsuwe'sxtxi Jesus pta'sxni's wẽsẽ'jya' pa'j, aça' vxite' ãçã'sa Jesus nuykatxhikahntxi pa'j. ");
INSERT INTO pbb_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Sa' eçx luuku vxit-satx ũuste ji'phsawa Jesus kutxi'the', katxhiçxatx neeyũ'. ");
INSERT INTO pbb_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Aça' nasa jxukaysa kxte ũssa' Jesusa's jxa'dxya' wala pa'pçxu'tx, txã'wẽ jxa'dxçxaçxáa maawa katxhiçtetx uyu', txãasatx txã'wẽy yũu wẽjẽ'. ");
INSERT INTO pbb_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Txajũ' Jesusa' txãa yakh u'jusawe'sxtxi thegçxa', na'jĩk: —I'kwe'sxa' kĩhwa ji'phmeeçxawa kuh yajkxmée weçxana mfxi'zewe, txãa pa'gatey Dxus jxkaahna ũsni' i'kwe'sx jĩ' naa pa'ga. ");
INSERT INTO pbb_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","I'kwe'sxa' ãçxhíi yu' wẽena ũsçxawa weçxana meswe, txãa pa'gatey wala sã'jĩni yuune'kwe. I'kwe'sxa' ãçxhíi yu' nxusna ũsçxawa weçxana meswe, txãa pa'gatey sxijkana fxi'zewa'ja's jxpa'gawa'jsai'kwe. ");
INSERT INTO pbb_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","I'kwe'sxa' Dxus Nçxi'k Nasa Yuusa's nwẽesẽ'pha'ga ewmeesathas i'kwe'sx yasetx açewe'wena txãawe'sx tasxu kutxi'jna txã'wẽ yũuçtewa, weçxana mfxi'zewe. ");
INSERT INTO pbb_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Txãniitey Dxus yuwe pta'sxsawe'sxtxiwa txã'wẽtx pkxuu na' ãçxwa txã'wẽyçxáa yuutxna. Nawa nxusmée weçxana mfxi'zewe, txãa pa'gatey cielute peesni's jxpa'gawa'j ji'phi'kwe. ");
INSERT INTO pbb_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Nawa ji'phsawe'sx ãçxhíi weçxana fxi'zeni pçunijũ', wala yuh nxuste pa'jane'kwe. ");
INSERT INTO pbb_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","I'kwe'sxa' ãçxhí' wẽt txikna ũsi'kwe, nawa e'su pxthaa yuh wẽjẽne'kwe. I'kwe'sxa' ãçxhí' sxijkana ũsi'kwe, nawa e'su nxusna ũ'nene'kwe. ");
INSERT INTO pbb_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","I'kwe'sx yu', ãçxhíi yu' maa maa nasawa ewçxáa tuuthe'jni fxi'zeçxawa, e'su nxuste neeyũune'kwe. Nyafxiiteywa Dxus yuwe's pta'sxsatha'w jĩna ĩsxĩina u'jusatxi' txã'wẽtx ewsata' jĩna tuuthe'je'. ");
INSERT INTO pbb_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Nawa ayte wẽsẽ'jna ũssa i'kwe'sxtxi' na'wẽth jxkaaja': Puíi jxpakwesatxi' mpeeygãhwe. Açesatxi' ew yũuna mfxi'zewe. ");
INSERT INTO pbb_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Ewmée nuywe'wesatxi's ka'tu' ewçxáa mwe'wewe. Wẽesxusatxi' txãawe'sx pa'gate Dxusa's mneewe'wewe. ");
INSERT INTO pbb_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Idxa's pukakwetga pehtxate', ka'tuwe'sxa'swa petxakahn mes. Maaí' atxha's kusa'jaçyã'the', puiimée kmiisa yuhnawa mes. ");
INSERT INTO pbb_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Pe'wsa's mes, sa' iidx jĩ's kusa'jçxa', dukhmeetewa pãatxhĩ'khna pẽynu. ");
INSERT INTO pbb_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Maa nasawa i'kwe'sxtxi ewçxáa yũuna fxi'ze jxthãasçxa', i'kwe'sxwa txã'wẽy maa nasatxwa ewçxáa yũuna mfxi'zewe. ");
INSERT INTO pbb_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","I'kwe'sxtxi peeygãasaçxáatx ka'tuwa peeygãhçxa', ew yũusatha'w ¿jĩya' ãjãma'kwe? Makwe nasa ewmeesaçxawa txã'wẽ peeygãasaçxáatx peeygãjxa' yu' ãjã'tx aça'. ");
INSERT INTO pbb_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","I'kwe'sxtxi ew yũusaçxáatx ka'tuwa ew yũuçxa', i'kwe'sxa' ew yũusatha'w ¿jĩya' ãjãma'kwe? Makwe pkalsaçxawa txã'wẽ ew yũusaçxáatx ew yũuya' yu' ãjã'tx. ");
INSERT INTO pbb_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Sa' i'kwe'sxtxi ki' kaasxwedu'jya' ãjãwa'jsaçxá's pki'jçxa', i'kwe'sxa' pu'çxsatha'w ¿jĩya' ãjãma'kwe? Makwe nasa ewmeesaçxawa, txã'wẽ kaasxwedu'jya' ãjãwa'jsaçxáatx pki'jya' yu' ãjã'tx. ");
INSERT INTO pbb_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Wejxwa i'kwe'sxa' puíi jxpakwesaatx peeygãhna fxi'ze ji'phi'kwe, sa' pki'jçxawa jxthaakwe kaasxwedu'juna sũhmée mfxi'zewe. Txã'wẽ ew yũusaatxi' Dxusa' wala deweena, aça' i'kwe'sxa' cielute Dxus luuçx yuune'kwe, txãa pa'gatey Dxus cielutewe'sxa' txã'sna yaakxsamée makwe ewmeesatewa ka'tu' ewçxáa yũuna ũsa'. ");
INSERT INTO pbb_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","I'kwe'sxa' peeygãasa myuuwe, i'kwe'sx Tatawa ma'wẽ peeygãasana txã'wẽy. ");
INSERT INTO pbb_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Ma'wẽsatewa jiimeeçxa', ewmeesata' jĩna we'wewa'jme', txã'wẽ yũupa'ga i'kwe'sxwa Dxus dxi'pte ewmeesa yuuya'mée. Vxitetx nuywe'wewa'jme', ka'tuwa nuywe'wekahmén. Ãhmée yũusaatx peltunãywa'ja', Dxuswa i'kwe'sxtxi peltunãykahn. ");
INSERT INTO pbb_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Vxitetx peeswa'ja', ka'tuwa i'kwe'sxtxi Dxusa' peeskahn. Makwe isaçxa vxitetx peeste', ka'tuwa i'kwe'sxtxi Dxusa' txãa isanitey ew uta pu'kisu'sna zuuna' ãsxçxa peesnisa's jxpa'gane'kwe. ");
INSERT INTO pbb_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Teeçx ejemplo kaaja'da'jçxa' na'wẽk pta'sx: —¿Yafx ji'phmeesa' vxitewa txã'wẽysa's dxi'the pe'jna u'jya' ãjãma'k? ¿E'zíi kafxkhẽ khẽemeema'tx? ");
INSERT INTO pbb_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Piyasá' kaapiya'jsate jxthaakwesame'. Nawa maawa jxuka piyan jxã'jçxa yuuçxáa, kaapiya'jsa na'wẽy yuuna. ");
INSERT INTO pbb_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","¿Ma'wẽçxa iidx yakhthẽ'j yafxte kxtã' le'çxkuẽesa khẽeçxa ũstewa, uyya' ãjãki'g? iidx yafxte yu' fxtũ pe'la yuu walasa khẽeçxa ũste'. ");
INSERT INTO pbb_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","¿Ma'wẽçxa iidx yakhthẽ'ja's pẽyiki'g: Iidx yafxte kxtã'a's kutxi'ji'nja jĩna? iidx yafxte yu', fxtũ pe'la walasa khẽeçxa u'ptewa txãa yu'sa' uymeeçxa'. Ãakhẽçxáa ew we'wena u'jusathẽ'j, iidx yafxte fxtũ pe'la walasa khuẽ'yna mkuutxi'j, sa' txã'wẽ yũuçxaçxáa iidx yakhthẽ'j yafxte kxtã' le'çxkuẽsa's kutxi'jya' ãjãne'ga. ");
INSERT INTO pbb_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Fxtũu tasx ewsa', ewsaíiçxáak yũnu', nawa fxtũu tasx ewmeesa', ewmeesa íiçxáak yũnu'. ");
INSERT INTO pbb_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Fxtũu tasx ma'wẽsatewa yũntek isa ew ya'jiyu'. Brewa's khãas tasxte ya'ude'çme', sa' uwa's çhũçh tasxte ya'ude'çme'. ");
INSERT INTO pbb_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Nasa ewsa' ewçxáatx we'we', ewsa's ũuste ji'phna txãa pa'ga. Nawa nasa ewmeesa', kazxçxáatx we'we', txãa pa'gatey ũuste yuu, kazxsa u'pna aça' we'wenisa' ũusuhne' kaseje' naa pa'ga. ");
INSERT INTO pbb_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","I'kwe'sxa' adxa's Jxpe'jsa jĩ'i'kwe sa' ¿kĩh yuuçxakwe adx jxkaahni's kxtey yu'çmée? ");
INSERT INTO pbb_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Maa nasawa adx tasxte utxaaçxa', adx we'weni's nwẽesẽ'jçxa jxkaahni's kxtey yũusa' txã' na'wẽsa': ");
INSERT INTO pbb_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Teeçx piçthẽ'ja' yu'wala pukate kwet walate kaaçxida'jçxa yat txajk. Txajũ' yu' walaaçxa', kxsũ afxihbna skhẽwçxawa yata's kẽesẽ'jme', kwette kaaçxida'jçxa txaahnipa'ga. ");
INSERT INTO pbb_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Nawa maa nasawa adx we'weni's wẽsẽ'jçxawa, adx jxkaahni's kxtey yuumeena txã' teeçx piçthẽ'ja' yu'wala pukate yata's kwetmuse kajkweteçxáa txaahni na'wẽsa'. Yu' walaaçxa', tũçxhaçxa txãa yata's pẽtxçxa jxuka suwku. ");
INSERT INTO pbb_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Txajũ' Jesusa' nasatx Dxus yuwe's pta'sxna jxã'jçxa', Kapernaum çxhabna u'kh. ");
INSERT INTO pbb_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Txãa çxhabte' teeçx kpiitan ũsu'k romanowe'sx. Sa' txãa kpiitana' teeçx selpisáa ji'phu'k wala peeygãanisa. Nawa wala ãçã'çxa uuya'wayã'kh yu'. ");
INSERT INTO pbb_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Txajũ' kpiitana' Jesusa' ma'wẽsatxwa nuykatxhi'k jĩni's wẽsẽ'jçxa', judiuwe'sx pkhaakhenite npiiçthẽ'jsatx jxkaakh Jesusa's pxthaa we'weya', txã'sna selpisa's nuykatxhiya' yuukahn. ");
INSERT INTO pbb_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Aça' txãawe'sxa' Jesusa's utxaaçxa', na'jĩnatx pxthaa pi'kxna we'we: —Txãa kpiitana'sa' idx pu'çxwaça' ewna sũjũ'tha'w. ");
INSERT INTO pbb_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Txã' kwe'sxtxi peeygãhçxa pkhaakhewa'j yat yuhwa ktxaaja'kh naa pa'ga jĩte', ");
INSERT INTO pbb_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Jesusa' txãawe'sx pe'jni u'kh. Nawa yat utxa pa'jaçteçxáa, kpiitana' txajx namikutx kaakha Jesusa's na'jĩkahn: —Adxa' wala ãhmeekwesath aça' wejx yuuwa adx yatte u'kaya' yuhmée tee yuu. ");
INSERT INTO pbb_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Adxa' txã'wẽ ãhmeekwesaçxa íiçxáath idxa's adx yuu pakweya' yujxa' thaame. Aça' wejx yuuwa txãjũçxáa yuwejuçxáa mwe'we aççxáa adxa's selpisa' katxhina. ");
INSERT INTO pbb_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Adxwa jwee npiiçthẽ'jsa jxkaahni's nwẽesẽ'jna ũsthu, nawa jweeju adx jxkaahnisa soldau ji'pthu. Sa' txãawe'sxtxi' teeçxsa's me'j jĩte', adx jxkaahni's kxtey yu'k. Sa' vxite's pa'yate', txãawa kxtey nwẽesẽ'je'k. Sa' adxa's selpisa's kĩh jxkaathewa, kxtey yu'k jĩnak yuwekaah. ");
INSERT INTO pbb_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Txajũ' na'wẽ kpiitan yuwe kaahni's Jesus wẽsẽ'jçxa', kuh yajkxnak neeyũu. Sa' e'ste yuusatx thegçxa' na'jĩk: —Isath we'we', Israelwe'sx mteewe'sx yuhwa txã'wẽ adx we'weteçxáa katxhina sũhsa yu' iiuymeeth naa kpiitan na'wẽsa yu' jĩk. ");
INSERT INTO pbb_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Txajũ' jxkaahnisawe'sxa' yatnay sxawedçxa', kpiitan jxpe'jnisa' katxhyã'j u'ptetx uy. ");
INSERT INTO pbb_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Txãa e'su', Jesusa' teeçx çxhab Nain yaasesatek pa'jya' u'j, txãa yakh u'jusawe'sx vxite nasa kuhsa yakh. ");
INSERT INTO pbb_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Sa' çxhabte u'kaçte', teeçx uusá's pedaaya' nasa wala kuh u'jweçtek uy. Txãa uusá' vxiuda nçxi'k txãaçxáasak yu'. ");
INSERT INTO pbb_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Aça' Jesus uyçxa', txãa vxiuda's peeygãhçxa kvxiisxa'jna: —Ũ'nenuçx jĩnak we'we. ");
INSERT INTO pbb_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Sa' Jesusa' utxaaçxa, taula's jxa'dxku. Aça' yakhçxa u'jsa', nee yujutx. Naapkaçxha' Jesusa' uusá's na'jĩk: —Piçtakx, mkiite jĩ'th idxa's jĩte', ");
INSERT INTO pbb_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","uusá' kaçxçxa we'wek. Aça' Jesusa' njĩ'ja's dukhku. ");
INSERT INTO pbb_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Na'wẽ yũuni's nasa uyçxa', jxukaysa wala ũukhçxawa, txã'wẽytxi Dxusa's wala weçxana na'jĩ': —Dxus jxkaahni wala yuhsa kwe'sx ksxavxyte vxyaak jĩ'tx. Sa' ki' we'weçxa': —Dxusa' txajx nasatx pu'çxya' kĩjk jĩ'tx. ");
INSERT INTO pbb_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Txajũ' Jesus txã'wẽ yũuni's nasa jxuka jiyutx Nain çxhab peeku'jsuwe'sx vxite' Judea kiwesuwe'sxwa jxuka. ");
INSERT INTO pbb_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Jesus txã'wẽ yũuni's Juan Bautista' jxuka jiyuk Juan yakh u'jusawe'sx pta'sxte'. Sa' txãa yakh u'jusa e'zsatx pa'yaçxa', ");
INSERT INTO pbb_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Jesus tasxna kaakh paapẽjxya': —Idxa' ¿isa Kristo naa kiwete kĩiwa'jsa ũsu'k txãa dxihgá', meeçxa' vxite ũythasuwá'nja'w? jĩnak pẽykaah. ");
INSERT INTO pbb_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Aça' e'z jxkaahnisa' Jesus tasxte pa'jçxa' txã'wẽy pẽjxtxi: —Juan Bautista' kwe'sxtxi' kaakh idxa's paapẽjxya': ¿Kristo naa kiwete kĩiwa'jsa ũsu'k txãa dxihgá', meeçxa' vxite ũythasuwá'nja'w? jĩnatx pẽjx. ");
INSERT INTO pbb_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Sa' txã'wẽ paapẽysawe'sx pa'jaçte', Jesusa' nasa wala kĩjkĩh wee kazxsate ãçã'satxwa nuykatxhik, eçx luuku vxit-satx ũuste ji'phsa vxite' uyya' ãjãsamée maazkuẽesatxwa jxuka nuykatxhik. ");
INSERT INTO pbb_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Sa' Jesusa' paapẽysawe'sxtxi' na'wẽk pas: —I'kwe'sx ma'wẽne'kwe wẽsẽ'jna uy txã'wẽy pta'sxine'kwe Juana's na'jĩna: Uyya' ãjãsameewa uyu'tx. Aça' legsawa katxhiçxa legmeetx neeyũ'. Wã'jy wee kazx ji'phsawa katxhinitx neeyũ'. Aça' wẽsẽ'jya' ãjãsameewa wẽsẽ'jya' ãjã'tx. Uuniisawa ki' ĩtxĩ yu'tx. Sa' naa kiwete pxthaakuẽsa yuutxi' Dxus tasxte pa'jwa'ja's pta'sxnik yuu. ");
INSERT INTO pbb_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Aça' adxa's kuh yajkxna jxpubasame', weçxana fxi'zesa yuuna jĩnak pta'sxkaah. ");
INSERT INTO pbb_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Juan yuwe kaahnisawe'sx u'the', Jesusa' Juan ma'wẽsatewa pta'sxku na'jĩna: —Nasa u'pnimée kiwesu' i'kwe'sxa' ¿kĩja'skwe thegya' u'j? ¿Khĩih tasx wejxate ẽsẽ'sesa's wá'kwe thegya' u'j? ");
INSERT INTO pbb_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","¿Khĩmeeçxa' teeçx piçthẽ'j ropa zhiçxkwesa athçxa u'pna sũhçxa wá'kwe thegya' u'j? I'kwe'sxa' jii i'kwe txã'wẽ ropa zhiçxkwesa athçxa wẽt weçxana fxi'zesa' jxkaahni yat-suçxáatx u'pu'. ");
INSERT INTO pbb_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","¿Kim yuunakwe thegya' u'j? ¿Dxus yuwe pta'sxsa's wá'kwe thegya' u'j? Isa txã'wẽ dxih yuuçxa' Dxus yuwe pta'sxsate teeçx jxthaakwe walasa's ne'kwe uy. ");
INSERT INTO pbb_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Juana's we'weçxak Dxus librute na'wẽ pta'sxi': Adx yuwee pta'sxsa's iidx yaçte kajaçthu, Iidx pa'jwa'ja's pheu'khan jĩna fxi'jni'. ");
INSERT INTO pbb_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Na'jĩ'th na': naa kiwete Dxus yuwe pta'sxsate maa maatewa jxthaakwesa' Juan Bautistak yu'. Txã'wẽtewa, maawa makwe ãhmeekwesaçxawa Dxus jxkaahnite u'kasa yu', Juante jxthaakwesa yuutxna jĩte', ");
INSERT INTO pbb_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Juan bautisãynisa nasa jxukaysa vxite' gobierno jĩi vxyu pkhakhsa txãawe'sx wẽsẽ'jçxa', Dxusa' maa yakhwa jxuka ewsana sũhnatx neeyũu. ");
INSERT INTO pbb_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Nawa fxariseowe'sx vxite' ley kaapiya'jsawe'sx Juan bautisãynimeesa yu', txãawe'sxtxi Dxus ew yũu wẽeni yu'sa' jxpa'gamée ahçetx. ");
INSERT INTO pbb_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Aça' Jesusa' na'jĩk: —Naa ensu nasatxi' ¿kiim yakh kaaja'da'jaki'th? ¿Kiim na'wẽta yu'? ");
INSERT INTO pbb_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Luuçx le'çxkuẽ na'wẽtx yu'. Txãawe'sxçxáatx plaasasu pweesa'jya' kaçxçxa, vxite luuçxtxi sus pa'yana na'jĩ': Zhiçxkwetha'w tujkana kuvxí' nawa ku'ju'çmeei'kwe. Sa' nxus nxustha'w memu', nawa ũ'ne'çmeei'kwe jĩ'tx. Txã'wẽsata' naa entewe'sxa'. ");
INSERT INTO pbb_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","I'kwe'sxa' Juan Bautista's eçx luuku vxit-sa's ji'phna txãasak pan ũ'mée vxinowa tudxi'çmée jĩ'i'kwe, txã'wẽ kĩhwa ũ'mée tudxpa'gameeçxáa. ");
INSERT INTO pbb_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Nawa Dxus Nçxi'k Nasa Yuusáa kĩhçxa', ũ'we'th, tudxi'th, aç yu': Naa thẽ'ja' wala pũ'we', wala tudxsa'. Gobierno jĩi vxyu pkhakhsawe'sx vxite' pkalsawe'sx yakh namiku' jĩ'i'kwe. ");
INSERT INTO pbb_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","I'kwe'sxa' jiimeeçxai'kwe txã'jĩ'. Nawa maawa jiyuwa'jsa yuutxi' Dxusa' kaajiyu'juna adx ma'wẽsatewa jĩk. ");
INSERT INTO pbb_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Teeçx fxariseo' Jesusa's pi'kxku sã'jĩya', aça' Jesusa' txãa fxariseo yatna u'jçxa', mesate kaçxku ũ'ya'. ");
INSERT INTO pbb_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Naapkaçxha' teeçx u'y iiméh kazx ewmée yũuna u'jusa txãa çxhabtey u'psa jiyuk Jesusa' fxariseo yatte ũ'ya' u'jni's. Sa' teeçx fxrasko aceite wẽt putasana atçxa fxariseo yatte pa'kh. ");
INSERT INTO pbb_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Sa' ũ'nena utxaana kũhçxa', yafx yu'ju Jesus çxidatx pkhi'kxku. Khĩçxak txajx dxkhasju adxi'jçxa weçxá'. Sa' aceite wẽt putasa's Jesus çxidakhẽ awku. ");
INSERT INTO pbb_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Txã'wẽ yũuni's fxariseo Jesusa's pi'kxsathẽ'j uyçxa', na'wẽk yajkx: Naa piçthẽ'j isa Dxus yuwe's pta'sxsa dxihwaça', jiyuna naa u'ya' pkalsa ewmeesaçxa txã'wẽ çxidatx pkhi'kxna aceite awna u'ptewa sũjũ'k. ");
INSERT INTO pbb_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Aça' Jesusa' na'jĩk: —Simon, idxa's na'wẽ we'wewa'j ji'pthu jĩte', fxariseo pasçxa': —Mwe'we jĩte', ");
INSERT INTO pbb_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Jesusa' na'jĩk: —Teeçx piçthẽ'ja's e'z nasatx yuul yu' vxyu pki'jçxa. Teeçxsa' kinientos pesok yuul yu'. Aça' vxite' cinkwenta pesok yuul yu'. ");
INSERT INTO pbb_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Aça' e'zíi txãawe'sx yuultxi dukhya' ãjãmeete', vxyuu pki'jsa' txãawe'sxtxi' peltunãyku. Aça' ¿maa sũjũki'g txãa yuulusa e'zsatx maaki'k wejx thaakwe weçxa pki'jsa's? jĩte', ");
INSERT INTO pbb_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simon pasçxa': —Wala yuulusane' wejx thaakwe weçxa jĩte', Jesusa': —Isa yuh we'we'g, jĩk. ");
INSERT INTO pbb_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Txajũ' Jesusa' txãa u'ya's thegçxa' Simona's na'jĩk: —Adxa' iidx yatte pa'thewa, yu' ũsmeeg adx çxidatx pkhi'kwa'j. Nawa naa u'ya's mtheg, txajx yafx yu'juk pkhi'khi' sa' txajx dxkhasjuk adxi'j. ");
INSERT INTO pbb_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Adxa's weçxameeg. Nawa naa u'ya' ayte u'kaíin nvxiitnime' adx çxidatx weçxana. ");
INSERT INTO pbb_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Adx jxkwetkhẽ aceite awmeeg. Nawa naa u'ya' aceite wẽt putasaak aw adx çxidakhẽ. ");
INSERT INTO pbb_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Na'jĩ'th na', pkal iiméh wala kazxsatewa peltunãyni neeyũusa' txã'wẽyku wala wedxna utxá' peltunãysa's. Nawa walamée peltunãynisa' jwee yu' weçxana utxa'çme'. ");
INSERT INTO pbb_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Txajũ' txãa u'ya's we'weçxa': —I'kwe' peltunãyni yã'ji'kwe jĩk. ");
INSERT INTO pbb_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Aça' pi'kxnasa Jesus yakh ũ'na u'psa' txãawe'sx pwe'sx na'wẽtx puutx we'we': —Naa piçthẽ'ja' ¿kiimki saki'k pkalsa yuhtxwa peltunaĩ'? jĩ'tx. ");
INSERT INTO pbb_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Aça' Jesusa' na'wẽk we'we txãa u'ya's: —Adx peltunaĩna sũhçxane'kwe adx tasxte utxáa naa pa'ga ewte yã'ji'kwe neeyũu na' ãçxha' wẽt weçx weçxa me'jwe jĩk. ");
INSERT INTO pbb_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Txãa e'su' Jesusa' maazkuẽe çxhabsuwa pekũjk Dxus jxkaahwa'j ena's pta'sxna txãa yakh u'jusawe'sx docesa yakh, çxhab le'çxkuẽsu walasuwa txã'wẽy. ");
INSERT INTO pbb_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Vxite' u'ywe'sxwa pi'kxna u'ju'tx na'wẽ eçxtxi kutxi'jna kĩh weete ãçã'satxwa nuykatxhik txã'wẽ yuuniisa, aça' txãa ksxavxyte teeçxsa' Maria Magdalena yaasesa txajx ũusuh siete eçxtxi kutxi'kh txãak yu'. ");
INSERT INTO pbb_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Vxite' Herodesa's pu'çxsa Çxusa nyu Juanak yaasesa yu', vxite' Susanak yaasesa yu'. Kuh u'ysatx Jesusa's pu'çxna u'jusa yu' txãawe'sx ji'phuni kĩjkwe yakhçxáawa. ");
INSERT INTO pbb_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Txajũ' çxhabuwe'sx wala nasa kasehtx, Jesusa's thegya'. Aça' nasa txaazkuẽe pkhaakhete', Jesusa' ejemplo yakhku pta'sx na'jĩna: ");
INSERT INTO pbb_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","—Skuutxh uuhsa' uujxa' kasejk. Aça' msuuíi yu' maz nxinx dxi'jsu ãasu neeyũute', nasa waakhi'khi'jiçte, vxiçxakwewa fxiwçxa ũ'tx. ");
INSERT INTO pbb_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Aça' msuuíi yu', kwet-sutx ũsxi. Nawa buçxaçxawa kiwe ew ji'phmeete', tuphaameeçxa jxuka uhdxtxi. ");
INSERT INTO pbb_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Msuuíi yu', çhũçh ksxavxysutx ũsxi. Aça' çhũçhwa ja'da buçxaçxa' skuutxha's aphçxa ivxiitutx. ");
INSERT INTO pbb_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Sa' vxite ahsu' kiwe ewsatek ũsxi. Txãa yu' walaaçxa teeçx tasxçxáa cien nxinxtxi ji'phu. Txajũ' Jesusa' suhsku na'jĩna we'we: —Jiyuwa'jsa ũsçxa', jiyune'kwe jĩk. ");
INSERT INTO pbb_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Txajũ' txãa yakh u'jusawe'sxa' Jesusa's pẽjxtxi txãa ejemplo's ma'jĩnitewa jiyuya'. ");
INSERT INTO pbb_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Aça' Jesus pasçxa' na'jĩk: —Dxus jxkaahni ensu ma'wẽ yũuwa'ja'swa kim yuhwa jiyunimeesa's i'kwe'sx yuutxi's ãate kaajiyu'ju'nja. Nawa vxite yuutxi' ejemplo yakhçxáath pta'sxi', kxah makwe uyçxawa, uysamée na'wẽçxáa neeyũutxna. Sa' pta'sxni's wẽsẽ'jçxawa, jiyumée neeyũutxna. ");
INSERT INTO pbb_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Naa ejemplo' na'wẽsa': Skuutxh fxiwa' Dxus yuwe jĩni'. ");
INSERT INTO pbb_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Aça' maz nxinx dxi'jsu ũsxisá', nasa Dxus yuwe's wẽsẽ'thewa eçxthẽ'ja' kutxi'jina wẽsẽ'jçxa yu'akhni's jĩni'. Txã'wẽ Dxus yuwe's ũusuh kutxi'the', txãawe'sx ũusa' vxituna. ");
INSERT INTO pbb_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Aça' maz nxinx kwet-su ũsxisá', nasa Dxus yuwe's jxpa'gaçxa maz en yu' weçxana wẽsẽ'jna fxi'zetxna. Nawa ũuste ew yu'akhmeeçxa', thẽysa nxusu en pa'theçxáa, Dxus tasxu ki' txuteetxna jĩni'. ");
INSERT INTO pbb_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Aça' maz nxinx çhũçh ksxavxysu ũsxisá', nasa wẽsẽ'jçxawa, naa kiwetewe'sx ji'phu wẽeniçxá's yajkxna pa'pçxuna ewmeesuçxáa weçxweçxa fxi'zesa jĩni'. Sa' Dxus yuwe's peçxkanatxna, aça' kxul íiçxáa yuuna. ");
INSERT INTO pbb_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Nawa nasa ũus ewsa Dxus yuwe's jxpa'yakx wẽsẽ'jçxa nwẽesẽ'jna Dxus yakhçxáa u'juçxa', kĩhsuwa ewçxáa yũuna fxi'zena, txã' maz nxinx yu' kiwe ewsate ũsxisáa na'wẽta'. ");
INSERT INTO pbb_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Lampara's atũu dxiite aphçxa txajxa' txã'wẽ ya'pki'taçme'. Wejxwa ẽetek ya'txaja' eena' kweethkahn, kxah maawa u'kasa' eena'te u'kakahn. ");
INSERT INTO pbb_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Makwe paaçte sũthnisaçxawa, kĩh yuhwa ãate vxyaamée yu' neeyũuwa'jme'. Sa' makwe ũusteçxáa yaakxnisa'swa, kim yuhwa ãate jiyunimée yu' neeyũuwa'jme'. ");
INSERT INTO pbb_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Txã'wẽyã'the', ew mwẽesẽ'jwe. Maawa wa'lmée wẽsẽ'the', jxthaakwe kaajiyu'juna Dxusa'. Nawa wẽsẽ'jya' wa'lsa's, kaajiyu'jnimée yuuna. Jxuka kusa'jni yuuna. ");
INSERT INTO pbb_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Txajũ' Jesus ũsnite pa'jtx njĩ'j vxite' nyakhwe'sx. Nawa nasa wala ũste', Jesus tasxte utxaaya' ãjãmeeta'. ");
INSERT INTO pbb_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Aça' kxtee ũssa teeçxsa' Jesusa's pta'sxku na'jĩna: —Iidx mama, iidx nyakhwe'sx, iidx npe'sxwe'sx idxa's thegya' pa'jçxa ekate ũsta', sa' idxa's peejxta' jĩte', ");
INSERT INTO pbb_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Jesus pasçxa': —Dxus yuwe's wẽsẽ'jçxa' kxtey yuutxna txã'wẽ yuusaaçxáa, adx mama, adx nyakh, adx npe'sxwe'sx na'wẽsata' jĩk. ");
INSERT INTO pbb_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Teeçx ente' Jesusa' txãa yakh u'jusawe'sx yakh barkote khẽeçxa': —Vxite ahn ĩkh kuten u'jwega jĩçxa' u'jtx. ");
INSERT INTO pbb_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Nawa ĩkh pxãjũy u'jweçpkaçxha' Jesusa' dejk. Naapkaçxha' wejxaa wala seena' kiiteçxa, yu'a's barkote yuutaçku yu'. Aça' barko' ĩkh dxiikhẽ khẽeya'wak yu'. ");
INSERT INTO pbb_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Txajũ' Jesusa's fxĩtxtxi na'jĩna: —Kwe'sxtxi jxpe'jsa mkiite, ĩkh dxiikhẽ khẽjẽçtha'w jĩte', Jesus kiiteçxa' wejxaa wala petx ĩkh yã'jçxa yujukaathe', jxuka yujuk, aça' kĩh yuhwamée ewçxáak neeyũu. ");
INSERT INTO pbb_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Txajũ' txãa yakh u'jusawe'sxtxi' na'jĩk: —¿Mjĩiçxakwe Dxusa' pu'çxhina sũhna yajkxmée? jĩte', txãa yakh u'jusawe'sxa' ũukhçxa txãawe'sx pwe'sxçxáatx na'jĩna puutx we'we': —Naa piçthẽ'ja' ¿kimki açki'tx wejxaa wala ĩkh txã'wẽsa yuhwa nwẽese'je'? jĩ'tx. ");
INSERT INTO pbb_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Txajũ' pejka Gadara kiwete pesahtx Galilea ĩkh kuteju. ");
INSERT INTO pbb_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Aça' Jesusa' txãa kiwete pa'jaçte', kxte' teeçx çxhabuwe'sx piçthẽ'j kasejk Jesus yakh puutx uyya'. Txãa piçthẽ'ja' wala txaçxyã'j eçx luuku vxitni u'ju'k. Sa' ropa athmée yattewa u'psameek yu', naasáa uusáa pedaní kwet kafxsuçxáak u'psa yu'. ");
INSERT INTO pbb_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Sa' Jesusa's uyçxa', tasxte peejxũkweçxa', na'jĩnak suhs we'we: —Jesus, Dxus ĩtxisa Nçxi'k, adxa'sa' ¿kĩhga yũu wẽjẽ'? Adxa's nxuste ũswa'the akhkahmén pxthaath we'we' jĩk. ");
INSERT INTO pbb_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Jesusa' txãa eçx luuku vxit-sa's ũusu kaseh kajaçku yu', txãa pa'gak txã'wẽ we'we'. Txãa eçxa' ũuste khẽeçxa nasa's luuku vxitpa'gatx, kadenaju kuse petx çxida yã'jçxa tud wẽe. Nawa kĩh yuhnawa weji'meek çxuktede'. Txã'wẽ yuuçxak txãa eçx luuku vxit-sa' nasa u'pnimeesu jxũna u'jwe' txãa piçthẽ'ja's. ");
INSERT INTO pbb_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Txajũ' Jesusa' txãa eçxa's pẽjxku: —¿Kĩh yaasega? jĩte': —Legion yaaseth jĩnak pas. Txãa piçthẽ'j ũuste wala kuh eçx khẽeçxa ũsu'tx, txãasak legion yaaseth jĩna pas. ");
INSERT INTO pbb_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Sa' txãa eçx luuku vxit-sa' Jesusa's pxthaa we'wetx kafx wala seena' ũukhũukhsakhẽ akhkahmén. ");
INSERT INTO pbb_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Sa' kxsũ thã'jsũ kuçxi wala ũsu'tx aphna, aça' txãa kuçxi ũussu khẽeya' u'jwa'ja'stxi Jesusa's pẽjx pxthaa we'wena. Aça' Jesusa' kuçxi ũussu khẽeya' u'khaakh. ");
INSERT INTO pbb_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Txajũ' txãa eçx luuku vxit-sa txãa piçthẽ'j ũusu kasehçxa, kuçxi ũussu khẽete', txãa kuçxi' penxakhẽ peluçxa, ĩkh walakhẽ khẽeçxa jxuka uutx. ");
INSERT INTO pbb_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Aça' kuçxi thegsa' txã'wẽ yũute uyçxa', ũukhçxa pta'sxya' wala dud u'jtx çxhabna vxite' çxhab peeku'jsuwa jxuka. ");
INSERT INTO pbb_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Aça' kĩh yũutewa uyya' nasa' thegya' pa'jtx. Sa' Jesus ũsnite kũhçxa', uytxi eçx luuku vxit-sa' txãa piçthẽ'j ũusu jxuka kasehte', Jesus tasxte wẽt yã'j ropa athçxa kaçxçxa u'pte. Sa' wala ũukhtxi. ");
INSERT INTO pbb_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Aça' txãa piçthẽ'j eçx luuku vxitnisa' ma'wẽ yũuçxa katxhitewa uysa' kxtee thegya' pa'jsatx pta'sxtxi. ");
INSERT INTO pbb_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Txãa pa'gaçxáa Gadara kiwesuwe'sx jxukaysa ũukhçxa Jesusa's txãa kiweju kasehna u'khaahtx. Txã'jĩyã'the', Jesusa' barkote khẽeçxa ki' sxawedku. ");
INSERT INTO pbb_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Aça' txãa piçthẽ'j luuku vxitnijũ katxhisa' Jesusa's pxthaa we'wek pe'jçxa u'khan. Nawa Jesusa' txajx yatnak u'khaah na'jĩna: ");
INSERT INTO pbb_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","—Iidx yatna sxawedna me'j, sa' mtuuthe'j idxa's Dxus na'wẽ ew yũuni's jĩte', txãa piçthẽ'j u'jçxa', çxhabsu jxuka pta'sxku Jesus ma'wẽ ew yũuni'swa jxuka. ");
INSERT INTO pbb_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Txajũ' Jesusa' Galilea kiwetey ki' sxawedna pesathe', nasa ũythãsna ũssa' wala weçxana jxpa'gatx. ");
INSERT INTO pbb_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Kxte' teeçx piçthẽ'j judiuwe'sx pkhaakhenite npiiçthẽ'jsa Jairo yaasesak pa'j. Sa' txãa piçthẽ'ja' Jesus tasxte peejxũkweçxa', pxthaa we'wek txajx yatna yuukahn. ");
INSERT INTO pbb_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Kxtee yu' txajx niisa teeçxçxáasa doce anxu ji'phsa ãçã'çxa uuwa'theçxáa yã'kh ũs yu' naa pa'ga. Aça' Jesusa' u'jweçte', txãa yakh u'jsa nasa wala kuh dxi'the utaçxáatx u'jna ũsu'. ");
INSERT INTO pbb_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Txãa nasa kuh ksxavxyte teeçx u'y doce anxu yã'j kakwe yu' vxyaate ãçã'sak kaseh. Sa' txãa u'ya' txajx vxyu's jxuka pebak yu'çe'jsatx dewena, nanwa maa yuhwa nuykatxhiya' ãjãmeeta'. ");
INSERT INTO pbb_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Aça' txãa u'ya' Jesus e'ste utxaaçxa, atxh vxiçkhẽ kpaajxa'dxku, naapkaçxha' txãa dudtey kakwe yu'a' yujuk. ");
INSERT INTO pbb_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Txajũ' Jesusa' paapẽjxku: —¿Kimga adxa's jxa'dx? jĩna. Aça' jxukaysa: Maa yuhwa jxa'dxmeetha'w jĩte', Pedro vxite' txãa yakh u'jusa' na'jĩtx: —Nasaa ksxavxyte zuuna'çxáa u'jna ũsgu sayuja' ¿ma'wẽga kimga jxa'dx jĩna pẽyí'? jĩte', ");
INSERT INTO pbb_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Jesus pasçxa': —Teeçxsa adxa's jxa'dxyujk, txã'wẽ adxa's jxa'dxpa'gaçxáa ãçã'çxawa katxhiçxak neeyũu adx pu'çxte jĩk. ");
INSERT INTO pbb_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Aça' txãa u'y ma'wẽ yũuni'swa Jesusa' jiyute', txajx tasxte ũukhna yayana kũhçxa peejxũkwek. Sa' nasaa dxi'pte jxuka pta'sxku ãçã'çxa Jesus atxhte jxa'dxçxa' txãa dudtey katxhiçxa neeyũuni's. ");
INSERT INTO pbb_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Txajũ' Jesus we'weçxa': —Katxhi'nja sũhçxane'kwe adx tasxte txã'wẽ yũuya' yuwé' txãa pa'ga ãçxha' katxhi'kwe neeyũu na' weçxana me'jwe jĩk. ");
INSERT INTO pbb_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Kxtee nee Jesus we'wena ũsíyna, judiuwe'sx pkhaakhenite npiiçthẽ'jsa Jairo yatu yuusa teeçx pa'jçxa', Jairo's pta'sxku: —Iidx niisa' uuyã'kh, aça' Jesusa's kuçx pe'jna yuunu jĩte', ");
INSERT INTO pbb_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Jesus wẽsẽ'jçxa': —Nxusnu, adxçxá's myajkx aççxáa iidx niisa' katxhina jĩk. ");
INSERT INTO pbb_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Txajũ' Jairo yatte pa'jçxa', vxite yuutxi' ka'ga'jmée, naasáa Pedro, Jakobo, Juan, vxite' kna'sa neywe'sxtxiçxáak ka'ga'j. ");
INSERT INTO pbb_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Kxte' nxus we'wena ũ'nenatx ũsu'. Nawa Jesus we'weçxa': —Ũ'nenuwe, txãa kna'sa' uunime', naasáa deeniçxá' jĩte', ");
INSERT INTO pbb_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","kxtee ũssa' npeevxysxijkatx, uuníi ũste txã'jĩpa'ga. ");
INSERT INTO pbb_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Txajũ' Jesusa' uuniisa's kuseju pu'kisna' suhsku we'we: —Kna'sa, mkiiteçx jĩna. ");
INSERT INTO pbb_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Naapkaçxha', dudtey ĩtxĩ yuuçxa kiitek, aça' Jesusa' puuçkaakh. ");
INSERT INTO pbb_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Aça' neywe'sxa' wala kuh yajkxna weçxana thegtxi. Nawa Jesusa' maa yuhtxwa pta'sxkaahme' txã'wẽ uuniitewa ĩtxĩ vxitni's. ");
INSERT INTO pbb_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Jesusa' txãa yakh u'jusa docesatx kxteeçxah pa'yaçxa' kĩh weete ãçã'satxwa nuykatxhiya' ãjãwa'ja's ũsku, eçx luuku vxit-satxwa nasa ũusu kutxi'khan. ");
INSERT INTO pbb_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Txã'wẽ yuuçxak kaah Dxus jxkaahwa'j ena's pta'sxna ãçã'satxwa nuykatxhikahn. ");
INSERT INTO pbb_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Sa' na'wẽk yu'kxpeh: —Dxi'the kĩh yuhwa jxũmée me'jwe khãabu, ya'ja, vxyu, kaame txã'wẽsatx. Kmiisa yuhwa e'z yu' jxũçxa u'jnuwe. ");
INSERT INTO pbb_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Maa yatte paadejxa' pa'jyã'jçxa', kxteeçxáa paadehna ũsune'kwe txajũ ki' kasehna u'phkaçx. ");
INSERT INTO pbb_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Maa çxhabteya' i'kwe'sxtxi jxpa'gameete', i'kwe'sx çxidate kiwe tuhda's sakweekweçxa kasejene'kwe, kxah Dxus yuwe's makwe jxpa'gameeçxawa, yuuwesa yuutxna jĩnak yu'kxpeh. ");
INSERT INTO pbb_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Txajũ' txãawe'sxa' kasehçxa', çxhab le'çxsũ mtee mteewa jxuka Dxus yuwe's pta'sxna ãçã'satxwa nuykatxhinatx pekũh. ");
INSERT INTO pbb_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Txajũ' ne'jwe'sx Herodesa' Jesus kĩjkĩhwa ew yũuni's jiyuçxa', wala kuh yajkxku, txã'wẽ maaíi yu' Juan Bautistane' uuçxawa ki' ĩtxĩ yuu jĩ'tx txãa pa'ga. ");
INSERT INTO pbb_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Aça' vxite yu', Dxus yuwe's pta'sxsa Eliasne' ki' vxyaa jĩ'tx. Naapkaçxha' vxite we'weçxa': Dxus yuwe pta'sxsawe'sx jwee yaçgaywe'sxne' ki' ĩtxĩ yuu jĩ'tx. ");
INSERT INTO pbb_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Nawa Herodes yu' na'jĩ'k: —Adxíith Juan Bautista txhikha's kaaspẽ'the'j txãana. Txãameeçxa' jwee yu' ¿kimçxah txakwe kĩjkĩhwa yũuya' ãjãkx? jĩ'k. Txãasak Herodesa' txakwe uy wẽjẽ' Jesusa's. ");
INSERT INTO pbb_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Jesus kaahnisawe'sxa' ki' sxawedna pa'jçxa', txãawe'sx kĩhçxahne'ta yũu txã'sna pta'sxtxi Jesusa's. Txajũ' Jesusa' txãawe'sxçxáatx fxiite pe'jna u'kh Beçaida çxhab ja'dasu nasa u'pnimeesu. ");
INSERT INTO pbb_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Nawa nasa' jiyuçxa', txãawe'sxwa Jesus e'stey u'jtx. Aça' Jesusa' jxpa'gaçxa', Dxus ma'wẽ jxkaahwa'ja'swa pta'sxku sa' ãçã'satxwa nuykatxhik. ");
INSERT INTO pbb_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Txajũ' kusuçte', Jesus yakh u'jusawe'sx docesa' na'jĩtx Jesus tasxte utxaaçxa: —Nasatxi' mkaah, çxhabsu paadee yat-su ũ' weyçxa ũ'kahn. Txã'wẽme' ayte' nasa yat utxameesũ ũstha'w jĩte', ");
INSERT INTO pbb_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Jesus pasçxa': —I'kwe'sxíiwa mpuuçwe jĩk. Aça' txãawe'sx pasçxa': —Tahç pan, e'z wedxçxáa ji'ptha'w. Kwe'sxa' çxhabna weyya' u'jmeete yu', ãhmeena naazkuẽesatx puuçwa'j jĩtx. ");
INSERT INTO pbb_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Nasa yu', piçthẽ'jçxáa cinko mil ãhtx yu'. Nawa Jesusa' txãa yakh u'jusawe'sxtxi' na'jĩk: —Cinkwenta txuhdeçxa fxiifxii txaksu mkaaçxi'jwe jĩte', ");
INSERT INTO pbb_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","txãawe'sxa' txã'wẽy nasatx jxukay kaykaçxhi'tx. ");
INSERT INTO pbb_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Txajũ' Jesusa' tahç pan e'z wedxtxi jxpa'gana'wa cielute pagayçxa, Dxusna weçxana orãyku. Sa' pe'ltedeçxa txãa yakh u'jusawe'sxtxi ũsku, nasa jxukaysatx ũsu'skahn. ");
INSERT INTO pbb_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Txajũ' jxukaysa ũ'çxa txikte', kijxasaatx doce kanastate utatx pkhakh. ");
INSERT INTO pbb_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Teeçx ente Jesusa' txãa yakh u'jusawe'sx yakhçxáa fxii txuteena u'jçxa Dxusna orãyna u'pçxa', txãawe'sxtxi pẽjxku: —Nasa' adxa'sa' ¿kimna jĩ'ta? jĩte', ");
INSERT INTO pbb_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","txãawe'sx pasçxa': —Maaí': Juan Bautistana jĩ'tx. Vxite': Eliasna jĩ'tx. Aça' vxite yu': Dxus yuwe pta'sxsa txãniiteywe'sx uuniiçxawa ĩtxĩ yuusaana jĩ'tx jĩte', ");
INSERT INTO pbb_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Jesus pẽjxçxa': —Txajũ' i'kwe'sxa' adxa'sa' ¿kimna sũjũ'kwe? jĩte', Pedro pasçxa': —Idxa' Kristo, Dxus tasxu yuusag jĩk. ");
INSERT INTO pbb_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Txajũ' wala neewe'wek Jesusa' Dxus tasxu yuusa Kristo' jĩna maa yuhtxwa pta'sxkahmén. ");
INSERT INTO pbb_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Txajũ' na'wẽk pta'sx: —Dxus Nçxi'k Nasa Yuusá' wala pkxuuni yuuwa'ja's jxpa'gawa'j pejka peejxyuja', txãa pa'ga judiu nthẽ'jsawe'sx vxite' sacerdote npiiçthẽ'jwe'sx vxite' Dxus leya's kaapiya'jsawe'sx ahçeçxa ikhetxna. Nawa uuçxawa tekh ente' ki' ĩtxĩ yuuna jĩnak pta'sx. ");
INSERT INTO pbb_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Txajũ' jxukaysatx na'jĩk: —Maawa adx yakh yuu wẽeçxa', peekx kakwe jxthãasni's kĩhnawa jxuka nvxihtçxa yuuçxáa adx yakh yujxa' ãjãne'kwe, makwe pxthaa yuuwa'j seena'sa een isa ma'k pa'jnawa txã'sa' ũukhmée. ");
INSERT INTO pbb_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Maa nasawa naa kiwete ĩtxĩ fxi'zewa'jçxá's ya'nwe'wesa' Dxus yakh fxi'zewa'j yu'sa' ivxiituna. Nawa maa nasawa adx yakh fxi'zepa'gaçxáa naa kiwete ĩtxĩ fxi'zeni's yajkxmée ivxiitusa', Dxus yakh fxi'zewa'j yu'sa' ivxiitumeena. ");
INSERT INTO pbb_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Nasa' naa kiwetewe'sxçxá's jxuka knayçxa', txajx ũus yu's ivxiitute', ¿kĩhte selpiikx, peekx ũus yu's nwe'wemeete'? ");
INSERT INTO pbb_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Maa nasawa adxa's jxpa'gaya' wa'lna adx pta'sxnitxwa wa'lutxna aça' Dxus Nçxi'k Nasa Yuusaawa adx Tata eena' kweethniite Dxus angeleswe'sx yakh jxkaajxa' kĩhçxa', txã'wẽ yũusatxi' jxpa'gaya' wa'luna. ");
INSERT INTO pbb_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Isath we'we', ayte ũssa uuméy uyuune'kwe Dxus jxkaajxa' kĩini's jĩk. ");
INSERT INTO pbb_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Txã'wẽ we'weni teeçx ki'su skhẽwniite', Jesusa' thã'the orãyya' u'kh Pedro, Jakobo, Juan txãawe'sx yakh. ");
INSERT INTO pbb_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Jesusa' orãyna u'piyna, txajx dxi'pa' fxiyku zhiçxkwe yu'ptheh, aça' txajx athni ropawa txã'wẽytxi çxihme kwehnesa yuu. ");
INSERT INTO pbb_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Txajũ' txãa yakha' e'z piçthẽ'jtx puutx we'wena vxyaa, teeçxsa' Moises vxite' Elias txãawe'sxtxi yu'. ");
INSERT INTO pbb_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Jxuka zhiçxkwe eena' kweethni pxãhte Jesus ma'wẽ nxus pxthaa yuuçxa Jerusalente uuwa'ja'stxi we'we'. ");
INSERT INTO pbb_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pedrowe'sxa' wala dee wẽeçxawa, dehmée u'pçxa' uytxi, Jesus eena' kweethni vxite e'zsa txãa yakh ũssatx. ");
INSERT INTO pbb_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Txajũ' txãa e'z piçthẽ'jwe'sxa' Jesusa's txuteena u'jweçte', Pedro' na'jĩk: —Ayte' kwe'sx ũswa'j wala ewa', aça' tekh wa' txajaga, teeçxsa' iidx jĩi, vxite' Moises jĩi, vxite' Elias jĩi jĩk. Nawa Pedro' ũus yuu yajkxméy we'wesaçxáak yu'. ");
INSERT INTO pbb_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Naapkaçxha' tãaph kĩhna'wa, jxuka aphku. Aça' wala ũukhtxi tãaph dxiite neeyũuçxa. ");
INSERT INTO pbb_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Txajũ' tãaph dxiiju na'wẽk we'we: —Na' adx Nçxi'k wala wedxnisa', aça' txã'sa' nwẽesẽ'jna kxtey myuuwe jĩnik pthũuse. ");
INSERT INTO pbb_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Txã'wẽ we'wenijũ', Jesusçxáa yã'j ũstetx uy. Sa' txãawe'sxa' sxuuna'tx neeyũu, sa' txãn ensu' kim yuhtxwa pta'sxmeeta' txã'wẽ uyni's. ");
INSERT INTO pbb_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Sa' kuskuus enkhẽ', thã'ju kĩjaçte', nasa wala kuh Jesusa's pu'thegya' kasehtx. ");
INSERT INTO pbb_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Aça' teeçx piçthẽ'ja' nasaa ksxavxyte ũssa' sus we'weçxa': —Adx nçxi'k teeçxçxáa ji'pthu txã'sa' meen theg. ");
INSERT INTO pbb_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Txã'sa' eçx luuku vxit-sa uweçxa kaywẽçxpa'ja'jna kweeyi'jna wala pkxu'k sa' txhwete wẽjẽ'çme'. Txã'wẽ yũute', yuwesu bu'çxçxáak sẽjẽ'. ");
INSERT INTO pbb_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Idx yakh u'jusawe'sxtxi' pxthaa we'weyã'th, txãa eçxa's adx nçxi'k ũusu kutxi'khan. Nawa txãawe'sxa' ãjãmeeta' jĩte', ");
INSERT INTO pbb_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Jesus pasçxa': —Dxusa' pu'çxhina sũhwa'j yu'sa' ji'phmeesata' naa nasa'. ¿Bagaçxpkaçx i'kwe'sx yakh pu'çxna ũs ya'watka? ¿Bagaçxpkaçx ãjãmée fxi'ze ya'wakwe? Mneejxũh iidx nçxi'ka's jĩte', ");
INSERT INTO pbb_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","txãa piçtakxa' Jesus tasxte utxaana kũjũçpkaçxha', txãa eçx luuku vxit-sa' kaywẽçxpa'ja'jçxa pẽtxku. Nawa Jesusa' juuna' we'weçxa eçx luuku vxit-sa's ũusu kutxi'the', txãa piçtakxa' ew katxhik aça' Jesusa' neya's dukhku. ");
INSERT INTO pbb_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Aça' Dxus txakwe wala ew yũute', jxukaysa wala kuh yajkxtxi. Na'wẽ yũuni's nasa wala kuh yajkxna ũspkaçxha', Jesusa' txãa yakh u'jusawe'sxtxi' na'wẽk we'we: ");
INSERT INTO pbb_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","—Na'sa' ew wẽsẽ'jçxa peçxkananuwe: Dxus Nçxi'k Nasa Yuusá's nasa ewmeesa kusete dukhni yuuwa'ja' jĩtewa, ");
INSERT INTO pbb_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","txãa yakh u'jusawe'sx yu' jiyuya' ãjãmeeta', txãawe'sx jiyuwa'jmeene' yu' naa pa'ga. Sa' txã'wẽçxawa pẽjx yu' meeta' ũukhçxa. ");
INSERT INTO pbb_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Txajũ' Jesus yakh u'jusawe'sxa' txãawe'sx pwe'sx puutx paapẽyi'tx: —Ayte' kwe'sx pwe'sx ¿maa wejx jxthaakwe walasakxtha'w? jĩna. ");
INSERT INTO pbb_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Nawa kĩh yajkxçxa txã'wẽ puutx we'weçtewa Jesusa' jiyuçxa', teeçx luuçxkuẽ's txajx pukate txahçxa' na'jĩk: ");
INSERT INTO pbb_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","—Adxa's wedxsa' maawa naa luuçx na'wẽsatx ahçemée jxpa'gasa', adxa's jxpa'gasa yuutxna. Sa' adxa's jxpa'gasa', adxa's jxkaahsanawa jxpa'gasa yuutxna. I'kwe'sx pwe'sx maa txã'wẽ ãhmeekwesa na'wẽ yajkxna fxi'zena txãa yuuçxáa jxthaakwe walasa yuuna jĩk. ");
INSERT INTO pbb_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Txajũ' Juan we'weçxa': —Kwe'sxtxi jxpe'jsa mwẽese'j. Teeçx piçthẽ'j iidx yase's kxsusçxa eçx luuku vxit-sa's nasaa ũusu kutxi'jiçte kwe'sxa' uyçxa', txã'wẽ yũunu jĩnatha'w we'we, kwe'sx yakh u'jusameek yu' naa pa'ga jĩte', ");
INSERT INTO pbb_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Jesus pasçxa': —Maawa kwe'sxtxi açewe'wesamée yu' kwe'sxtxi pu'çxsa íiçxáatxna, aça' txãawe'sxtxi' kuçx txã'wẽ yuunuwe jĩk. ");
INSERT INTO pbb_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Txajũ' Jesus cielun u'jwa'j en utxaaçte', ũukhmée Jerusalen çxhabna u'jya' kasejk. ");
INSERT INTO pbb_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Sa' u'jweççxa', yaçte yuwe kaakh, aça' txãawe'sxa' Samaria kiwete teeçx çxhabtetx deewa'j yat pakweya' u'j. ");
INSERT INTO pbb_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Nawa txãa çxhabtewe'sxa' Jesus Jerusalenna u'jweçte uyçxa', jxpa'ga wẽemeeta'. ");
INSERT INTO pbb_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Txajũ' txã'wẽ yũute', Jakobo, Juanwe'sxa' Jesusa's na'jĩtx: —Kwe'sxa' cieluju ipx kaakĩjĩ'jçxa txãa nasatxi' peba jxthãaswaça', kwe'sxa' kxtey yu'nja'w Dxus yuwe pta'sxsa Eliaswa ma'wẽga yũu txã'wẽy jĩte', ");
INSERT INTO pbb_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Jesusa' thegçxa' na'jĩnak yu'kxpeh: —I'kwe'sxa' jiyu'çmeei'kwe ma'wẽ yũuwa'ja'swa. ");
INSERT INTO pbb_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Dxus Nçxi'k Nasa Yuuçxawa, adxa' nasatx pebaya' yuwe'çmeeth, naasáa nwe'weçxa ewte nvxiht-ya'çxáath kĩh jĩk. Txajũ' vxite çxhabnatx u'j. ");
INSERT INTO pbb_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Txãawe'sx dxi'the u'jweçte', teeçx piçthẽ'j Jesusa's na'jĩk: —Jxpe'jsa, idx yakh yuu wẽeth, idx mtee u'jweçtewa jĩte', ");
INSERT INTO pbb_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Jesus pasçxa': —Yu'kh niimal yuhwa deewa'j kafx ji'phta', aça' vxiçxakuẽwa yat ji'phta'. Nawa Dxus Nçxi'k Nasa Yuusa' mtee yuhwa txajx dxiktheçxáa yuja'swa khikhwa'j ji'phme' jĩk. ");
INSERT INTO pbb_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Txajũ' Jesusa' vxite's pa'yak: —Adx yakh myuh jĩna. Aça' txãa pasçxa': —Jxpe'jsa, mũythãs, adx tata khuẽ'yna pedaaya' u'jweçthu jĩte', ");
INSERT INTO pbb_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Jesus pasçxa': —Uusaawe'sxa' peekx uusáa pwe'sx ya'pedaatxna. Aça' idxa' Dxus jxkaahwa'j ena'sçxáa pta'sxya' me'j jĩk. ");
INSERT INTO pbb_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Txajũ' vxite' na'jĩk: —Jxpe'jsa, adxa' idx yakh yuu wẽeth, nawa adx yattewe'sx khuẽ'ytxi neewe'weya' u'jweçthu jĩte', ");
INSERT INTO pbb_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Jesus pasçxa': —Maawa mjĩia's takhçxaçxáa e'su yu' thegsa' selpimeena Dxus ma'wẽ jxkaahwa'ja'swa pta'sxya' jĩk. ");
INSERT INTO pbb_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Txãa e'su' vxite setenta txhitxhçxa, e'z e'zku yaçte kaah, txajx pa'jwa'j çxhabsu mteewa jxuka. ");
INSERT INTO pbb_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Sa' na'jĩk: —Isa mjĩiwa'ja' wala yuh ũsa', nawa mjĩisa yu' kuhmeeta'. Aça' mjĩi namu's pxthaa we'wena mpẽjxwe nasa mjĩiwa'jsa txajx mjĩitewe'sx. ");
INSERT INTO pbb_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","I'kwe'sxa' jxpa'yakx me'jwe, piisxakuẽtx alum ksxavxysu na'wẽ kajaçthu naa pa'ga. ");
INSERT INTO pbb_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ya'ja, vxyu, pelgatxi txã'wẽsa jxũmée me'jwe. Sa' dxi'the nasa pu'jykhẽw yuhçxawa weçxana jxthẽeyuumeene'kwe. ");
INSERT INTO pbb_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Kiim yatte pa'jçxawa, ewçxáa we'wena weçxana pa'jane'kwe. ");
INSERT INTO pbb_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Aça' txãa yattewe'sx açesameeçxa', txã'wẽ weçxana pa'jni's ewçxáa jxpa'gatxna. Nawa jxpa'gameete', txajũ ki' u'jwene'kwe. ");
INSERT INTO pbb_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Sa' mtee ew jxpa'gatxna, txãa yatte paadejene'kwe, txãawe'sx kĩh sã'jĩni'swa ũ'na, txãa pa'gatey mjĩisa' ũ'wa'ja's jxpa'gawa'j ji'pha'. Aça' i'kwe'sxa' yat iisa paadehna pekũhnuwe. ");
INSERT INTO pbb_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Maa çxhabtewe'sx i'kwe'sxtxi jxpa'gate', kxtee ũsune'kwe kĩh puuçtewa wa'lmée jxpa'gana. ");
INSERT INTO pbb_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Sa' kxtee ãçã'satxwa nuykatxhiçxa na'wẽ pta'sxine'kwe: Dxus jxkaahna pa'jwa'j ena' i'kwe'sx yakh utxa ũsa'. ");
INSERT INTO pbb_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Nawa maa çxhabtewa i'kwe'sxtxi jxpa'gameete', txãa çxhabte jxuka na'jĩne'kwe: ");
INSERT INTO pbb_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","I'kwe'sxa' jxpa'gameeçxawa yuuwesa yuukahn i'kwe'sx çxhabte kxtã'tuhd yuhnawa sakweekweçxa u'jweçtha'w kwe'sx çxidate uweni's. Sa' makwe jxpa'gameeçxawa, jiyuçxa neeyũuçi'kwe: i'kwe'sxtxi Dxus jxkaahna pa'jwa'j ena' utxa ũsa' jĩne'kwe. ");
INSERT INTO pbb_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Na'jĩ'th na': Dxus kastigãywa'j ente', txãa çxhabtewe'sxa' Sodoma çxhabtewe'sxte jxthaakwe nxus ya'kastigaĩtxna. ");
INSERT INTO pbb_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Korazín çxhabte nasa, Beçaidatewe'sx yã'jçxa, seena' yuh nxuste neeyũuwa'ji'kwe. Ayte i'kwe'sx dxi'pte na'wẽth ãçã'satx nuykatxhina uusáatx fxĩtxna yũu na' Tiro vxite' Sidon çxhabtewa txã'wẽy yũuwaça', txãawe'sxa' pkaltxi nvxihtçxa Dxus tasxte sxawedni txaçxyã'j yuuna. ");
INSERT INTO pbb_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Dxus kastigãywa'j ente', Tiro vxite' Sidon çxhabte nasate jxthaakwe i'kwe'sxa' nxus kastigo's knayuune'kwe. ");
INSERT INTO pbb_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Aça' Kapernaum çxhabtewe'sxa' cielute u'jwa'jsath sũhna i'kwe yaaki', nawa infxiernote khẽeya' u'jwa'jsai'kwe. ");
INSERT INTO pbb_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Txãa çxhabtxi' txã'wẽ we'weçxa', setentasawe'sxtxi' na'jĩk: —Maa nasawa i'kwe'sx pta'sxni's wẽsẽ'jçxa', adxa'swa nwẽesẽ'jsa yuutxna. Sa' maawa i'kwe'sxtxi açesa', adxa'swa açesa yuutxna. Sa' adxa's açesa' adxçxáana ahçemée adxa's kaahsanawa açesa yuutxna jĩnak jxkaah. ");
INSERT INTO pbb_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Txajũ' setentasawe'sxa' wala weçxana ki' sxawedtxi na'jĩna: —Eçx luuku vxit-sa yuhwa idx pu'çxte', kwe'sxtxi' nwẽesẽ'je'tx jĩna pta'sxte', ");
INSERT INTO pbb_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Jesusa' na'jĩk: —Isa yuh pta'sxi'i'kwe adxa' uythu eçxthẽ'ja' cieluju kpi'sx kwehneni na'wẽ wetena kĩjaçte. ");
INSERT INTO pbb_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","I'kwe'sx txã'wẽ yũukahn íiçxáath adxa' kĩhtewa jxuka ãjãwa'ja's ũs, ul weeswée usmitx kĩjkĩh eçx seena'sawa i'kwe'sxtxi kpã'vxit-ya' ãjãkahmén. ");
INSERT INTO pbb_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Nawa eçx luuku vxit-sa i'kwe'sxtxi nwẽesẽ'pha'gaçxáa yu', weçxweçxa yaakxnuwe. Naasáa cielute i'kwe'sx yase fxi'jni ũsa' txãa pa'ga yuuçxáa weçxweçxa myajkxwe jĩçxa', ");
INSERT INTO pbb_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Jesusa' txajx ũuste wala weçxak txã'wẽ Dxus Espiritu pu'çxpa'ga. Sa' na'jĩk: —Tata, idxa's wala weçxa'th, idxa' cielute vxite' naa kiwete jxuka Namug. Txãasag naa kiwete wala jxtuhtesa yuutxi's kaajiyu'jmeeçxawa, ãhmeekwesa yuutxi's jiyuwa'ja's ũsgu. Iidx jxthãasni' txã'wẽne' yu' aça' txã'sa' kxtey yuug. ");
INSERT INTO pbb_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Adx Tata' kĩjkĩhtewa jiyuwa'ja's adxçxaçxá'sku dukh. Txãa pa'ga kim yuhwa jiyu'çmeeta' Dxus Nçxi'ka's, naasáa Ney yuuçxáa jiia'. Txã'wẽy Tata'swa kim yuhwa jiyu'çmeeta', naasáa Nçxi'k yuuçxáa jiia', sa' maatxwa Nçxi'k íi khiyu'theçxáa jiyuya' ãjãtxna adx Tata's. ");
INSERT INTO pbb_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Txã'jĩçxa' txãa yakh u'jusawe'sxtxi thegçxa', na'jĩk txãawe'sxçxáatx: —Ãçxh i'kwe'sx uyna ũsi'kwe txã'sna txãawe'sx yafxju uysá' wala yuh weçxawa'j ji'phta'. Txãa pa'gatey ãçxh i'kwe'sx uyna ũsi'kwe txã'sa' ");
INSERT INTO pbb_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","nyafxiitey Dxus yuwe pta'sxsawe'sx vxite' jxkaahsawe'sxwa wala yuh uy wẽetx, nawa uyya' ãjãmeeta'. Txã'wẽy zhiçxkwe pta'sxni's ãçxh i'kwe'sx wẽsẽ'jna ũsi'kwe txã'snawa wala yuh wẽsẽ'j wẽetx, nawa wẽsẽ'jya' ãjãmeeta' jĩk. ");
INSERT INTO pbb_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Txajũ' ley kaapiya'jsa teeçxsa Jesus tasxte utxaaçxa', ewmée vxit wẽeçxa na'wẽk paapẽjx: —Adxa' ¿ma'wẽ yũuçxa pçumée ĩtxĩ fxi'zewa'ja's ji'phuki'th? jĩte', ");
INSERT INTO pbb_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Jesus pasçxa': —Dxus leyte' ¿ma'wẽ fxi'jni ũsna açga lẽeyçxa jiyu'çmée? jĩte', ");
INSERT INTO pbb_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","ley kaapiya'jsa' na'wẽk pas: —Idxna jxpe'jsa Dxusa's ũusuh jxuka yajkxçxa bagaçxte yuhwa peena yu' txuteeya'mée utxaaçxa txãa yuuçxá's selpiina mfxi'ze. Sa' idx ma'wẽga ya'peeygãja', txã'wẽy vxite nasatxwa mpeeygãh jĩ'k jĩte', ");
INSERT INTO pbb_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Jesus we'weçxa': —Ew yuh pasgu. Txã'sa' kxtey yuuçxa', pçumée ĩtxĩ fxi'zewa'ja's ji'phune'ga jĩk. ");
INSERT INTO pbb_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Nawa ley kaapiya'jsa yu', txajx yuweteyçxáa ewmeete neeyũuyã'jçxa', na'wẽk pẽjx: —Txãa vxite nasa jĩ'k txãa yu' ¿kimtxna? jĩte', ");
INSERT INTO pbb_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Jesus pasçxa' na'wẽk kwentu'j: —Teeçx piçthẽ'j Jerusalenu kasehçxa' Jerikon u'jni dxi'jkhẽ u'jweçte', peswée dxi'the yupxa' kasehtx. Sa' kĩjkĩhne' jxũna u'jweç yu', txã's jxuka peswéetx. Sa' kpã'vxitçxa', uuwa'jçxáa yã'jtx nvxiht. ");
INSERT INTO pbb_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Peswée u'jni txaçxmeyna, teeçx sacerdote kĩhçxa' uyku txãa kpã'vxitnisa's, nawa pu'çxmée dxi'j skhẽwku. ");
INSERT INTO pbb_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Txã'wẽy Levxi ji'thewe'sxwa kĩhçxa' uyku, nawa txãawa pu'çxmée dxi'j skhẽwku. ");
INSERT INTO pbb_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Txajũ' teeçx piçthẽ'j Samariatewe'sx txãa dxi'khẽy kĩhçxa', kpã'vxitnisa's uyçxa', wala peeygãjk. ");
INSERT INTO pbb_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Sa' kpã'yũusa tasxte utxaaçxa', kpã'su aceite vxino yakh awna yu'çe'kh. Txajũ' txajx a'jni jibate yakhçxa ka'ja'kh, sa' paadee yatna pe'jna u'jçxa, kxte' kĩjkĩhwa peejxmeek sã'jĩ. ");
INSERT INTO pbb_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Kuskuus enkhẽ', txãa Samariatewe'sxa' u'jweççxa', e'z vxyu kutxi'jçxa, yat namu's dewek. Sa' na'wẽk neewe'we: Naa piçthẽ'j kpã'vxitnisa's meen sã'jĩ. Meeçxa' vxyu nvxiituçthu txãa ãhmeewáana nawa ki' sxawedna pa'jçxa, dukhe'nja txãa yuuluni's jĩk. ");
INSERT INTO pbb_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Jesusa' txã'wẽ pta'sxçxa na'wẽk pẽjx: —Idx ũus myajkx. Txãa tekhtewe'sxa' ¿maasaga ew yũusana' thegu'? jĩte', ");
INSERT INTO pbb_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","ley kaapiya'jsa pasçxa': —Kpã'vxitnisa's peeygãasa jĩte', Jesus pasçxa': —Idxwa txã'wẽy pu'çxna peeygãhna me'ju jĩnak jxkaah. ");
INSERT INTO pbb_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Txajũ' Jesusa' teeçx çxhab le'çxkuẽtek pa'jya' u'j. Txãa çxhabte teeçx u'y Marta yaasesa' txajx yatte jxpa'gak. ");
INSERT INTO pbb_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Sa' Marta' teeçx nyakhku ji'phu' Maria yaasesa. Aça' Maria yu', Jesus pta'sxniçxá's wẽsẽ'jya' txajx tasxte kaçxku. ");
INSERT INTO pbb_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Naapkaçxha' Marta yu', mjĩiniçxá's wala pa'pçxuna ũsçxa', Jesusa's utxaaçxa na'jĩk: —¿Uyu'çmeegá' na'wẽ ũ'kweçxáa wala mjĩina ũste', ũ'kwe nyakh yu' pu'çxhiçme'. Aça' mpu'çxkaah jĩte', ");
INSERT INTO pbb_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Jesus pasçxa': —Marta, i'kwe' wala yuh kuh jwed mjĩina tudumée ũsi'kwe. ");
INSERT INTO pbb_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Nawa jxthaakwe peejxsa yu' teeçx jwed yuuçxá'. Aça' Maria' wejx jxthaakwe peejxsa's wẽsẽ'je'ça' txã'sa' kim yuhwa kusa'jmeetxna jĩnak we'w e. ");
INSERT INTO pbb_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Teeçx ente' Jesusa' Dxusna orãynak u'pu' teeçx ahte, sa' orãyna jxã'the', txãa yakh u'jusa teeçxsa' na'jĩk: —Kwe'sxtxi mkaapiya'j, Dxus yakh puutx we'wena orãyya', Juanwa ma'wẽga txãa yakh u'jusawe'sxtxi' kaapiya'ja' txã'wẽy jĩte', ");
INSERT INTO pbb_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Jesus pasçxa': —Dxus yakh puutx we'wena oraĩççxa', na'jĩne'kwe: Kwe'sx Tata cielute ũssa, Idxa' bagaçxtewa wala jxtuhthesag. Iidx jxkaahwa'j ena'sçxáatha'w ũythasu'. Naa kiwete idx ma'wẽne'ga jxthãasu' txãa yu' jxuka kxtey tee yuu cielute na'wẽy. ");
INSERT INTO pbb_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Ãçxh kwe'sx ũ'wa'ja's meen pees. ");
INSERT INTO pbb_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Kwe'sx ewmée yũuni's meen peltunaĩ, kwe'sxwa peltunãytha'w kwe'sxtxi ewmée yũusatx txãa pa'ga. Ewmeete wetekahmén meen nwe'we jĩna oraĩne'kwe. ");
INSERT INTO pbb_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Txajũ' na'jĩnak we'we: —I'kwe'sxa' namiku yatte kuspxãh u'jçxa': Namiku, tekh pan mpeeki'j. ");
INSERT INTO pbb_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Dxi'j u'jsa adx namikuk yatte pa'j, aça' kĩh yuhwa ji'phmeeth puuçwa'j, ¿jĩmeema'kwe kĩhwa ji'phmeeçxa'? ");
INSERT INTO pbb_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Aça' dxiiju passa' na'jĩna: Adx luuçx deeni yã'tha', aça' kuçx susnu. Naapkaçxha' vxitxwa aphni yã'j ũsa', aça' kĩh yuhwa ũsya' ewume'nja jĩçxawa, ");
INSERT INTO pbb_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","jwee kuçx susna nes yuukahmén kiiteçxa kĩh pẽjxtewa jxuka ũsuna. Na'jĩ'th na': Namiku pa'gaçxáa kuspxãh kiiteçxa ew yũumée naasáa kuçx suskahménçxáa txã'wẽ yũuna. ");
INSERT INTO pbb_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Txãa pa'gath adxa' i'kwe'sxtxi Dxusna pẽykaja' aça' txã' ũsuna. Kĩh peejini'swa pakweçxa' uyuune'kwe. Vxitxte pa'yate' phaadena. ");
INSERT INTO pbb_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Na'jĩ'th na': maawa Dxusna pẽysa', jxpa'gana. Aça' pakwesa', uyuuna. Aça' vxitxte tu'kakate', phaadena. ");
INSERT INTO pbb_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Ũus miiyajkxwe: i'kwe'sx luuçx pan pẽjxte', ¿kweta's ũsma'kwe? Meeçxa' wedx pẽjxte', ¿ula's ũsma'kwe? ");
INSERT INTO pbb_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Meeçxawa ziç pẽjxte', ¿usmitxa's ũsma'kwe? ");
INSERT INTO pbb_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","I'kwe'sxa' Dxus dxi'pte ewmeesaçxawa, i'kwe'sx luuçxtxi' ewsaçxáa i'kwe peesu'. Aça' i'kwe'sx Tata cielutewe'sxa' wejx jxthaakwe ewsa Dxus Espiritu's peesuna pẽysatxi's jĩk. ");
INSERT INTO pbb_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Jesusa' eçx luuku vxit-sa kwe'we'jsame's piçthẽ'j ũusuh kutxi'the', txãa eçxa' ũusuh kasejk, aça' txãa piçthẽ'ja' we'weya' ãjak. Txã'wẽ yũute', nasa' wala kuh yajkxna neeyũutx. ");
INSERT INTO pbb_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Nawa vxite yu', na'jĩnatx we'we': —Eçxthẽ'j pu'çxteçxáak naa piçthẽ'ja' eçx luuku vxit-satxwa nasaa ũusuh kutxi'ji' jĩ'tx. ");
INSERT INTO pbb_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Naapkaçxha' vxite yu' Jesus kĩh yũutewa jiyuya' sũhçxa cielujũ seena'sa mkaavxya'ja'j jĩte', ");
INSERT INTO pbb_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Jesusa' txãawe'sx ewmée ũus yaakxni's jiyuçxa', kxtey yuumée na'wẽçxáak we'we: —Maa gobiernowa peekx nasa yakhíiçxáa puiiçxa', txãawe'sx pwe'sxíiçxáa jxuka pçuutxna. Maa yattewe'sxwa txãawe'sx pwe'sxíiçxáa puutx puiiçxa', txãawe'sx pwe'sxíiçxáa jxuka pçuutxna. ");
INSERT INTO pbb_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Txã'wẽy eçxthẽ'jwa txãawe'sx pwe'sxíiçxáa puutx puiiçxa', puutx pçuutxna. Adxa'sa' eçxthẽ'j pu'çxteçxáak eçx luuku vxit-satxwa nasa ũusu kutxi'jya' ãjã' jĩ'i'kwe txãa pa'gath txã'jĩ'. ");
INSERT INTO pbb_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Txã'wẽ dxihte', i'kwe'sx yakh u'jusatxwa eçxthẽ'jíiçxáane' pu'çxhi' eçx luuku vxit-satx kutxi'jya'. Ew yajkxwaç yu', i'kwe'sx yakh u'jusaíiçxáa i'kwe'sx jxpubani's khiyu'jwa'jsata'. ");
INSERT INTO pbb_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Adxa's eçxthẽ'j pu'çxmée, Dxus pu'çxteth eçx luuku vxit-satx nasaa ũusuh kutxi'ji'. Isa ew jiyuwaç yu', i'kwe'sxtxi Dxus jxkaahwa'j en ãjk txãa pa'ga txã'wẽ yũuçthu. ");
INSERT INTO pbb_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Teeçx piçthẽ'j çxhãçxhasa' kĩjkĩhwa txajx ji'phuni's ivxiituya'mée sũhçxa puiiwa'j tũ'sçxa yatte yupu'k ka'ga'jya'mée. ");
INSERT INTO pbb_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Nawa vxite wejx jxthaakwe çxhãçxhasa pa'jçxa', txãa yupsa's knayçxa puiiwa'ja'swa kusa'jna yuuçxa ji'phunitxi's txãak iiyamu. ");
INSERT INTO pbb_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Adx ju'gumée ũssa', adxa's açesata'. Aça' adx yakh pkhakh pu'çxsame' neeusaçxa txã'wẽ yuuna. ");
INSERT INTO pbb_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Eçx luuku vxit-sa' nasa ũusu kasehçxa', nasa u'pnimeesuk jxkaasewa'j pakwena u'ju'. Nawa uymeeçxa' naa sũju'k: Adx kasehni yatnay sxawedna u'jwe'nja sũhçxa ");
INSERT INTO pbb_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","ki' sxawedte' txãa nasa ũus yu' yata's ew padçxa txaahni na'wẽ ũstek uyna pa'ja'. ");
INSERT INTO pbb_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Sa' u'jçxa vxite siete eçx txãate jxthaakwe ewmeesatx nuypa'jçxa, txãa nasa ũuste pejka u'katx. Aça' txãa nasa' jxthaakwek ewmeesa yuuna pa'ja'. ");
INSERT INTO pbb_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Jesusa' txã'wẽ pta'sxiçpkaçxha', teeçx u'y nasaa ksxavxyte na'jĩnak sus we'we: —Idxna kçxu'çxusa mama yakha' seena' yuh wala weçxa yuhna jĩte', ");
INSERT INTO pbb_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Jesus pasçxa': —Txã'wẽme', wejxwa Dxus we'weni's wẽsẽ'jçxa', txajx jxkaahnitxi's kxtey yuusáa yakhçxáa seena' wala weçxa yuja' jĩk. ");
INSERT INTO pbb_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Txajũ' nasa' Jesus we'weni's wẽsẽ'jya' txajx tasxte pkhaakhesatxi' na'jĩnak we'we: —Nasa ewmeesa naa ensuwe'sxa' kĩhçxáawa seena'sa kaavxya'ja'khaja'tx. Nawa kĩh yuhwa jwee yu' kaavxya'ja'jmée, naasáa Dxus yuwe pta'sxsa Jonas ma'wẽsaga yu' txã'sçxáana khiyu'the ewna. ");
INSERT INTO pbb_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Jonaswa ma'wẽga Níniwe çxhabte nasa ewmeesatx khiyu'j, txã'wẽy Dxus Nçxi'k Nasa Yuusaawa naa ensu nasa ewmeesatx khiyu'jsa'. ");
INSERT INTO pbb_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Naa ensu nasatx Dxus kastigãywa'j en ãhte', txãniitey jxu'j kiwete jxkaahsa u'ythẽ'ja' ãçxga nasatxi' ewmeete nvxiituna. Txãa u'ya' txakwe jxu'juwe'sx yuhçxawa, wa'lméek Salomon pta'sxniçxá'swa wẽsẽ'jya' pa'j. Naapkaçxha' ãçxh yu' Salomonte jxthaakwesa ayte ũsa' nawa wa'lu'tx naa pa'ga txãa u'ya' ewmeete nvxiituna. ");
INSERT INTO pbb_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Txã'wẽy Níniwe çxhabtewe'sxwa Dxus kastigãywa'j en ãhte', naa ensu nasatx ewmeete nvxiitutxna. Txãawe'sxa' Jonas pta'sxniçxá'swa wẽsẽ'jçxa', txãawe'sx pkaltxi nvxihtçxa Dxus tasxte sxawedtxi. Naapkaçxha' ãçxh yu' Jonaste jxthaakwesa ayte ũsa' nawa wa'lu'tx naa pa'ga Níniwe çxhabtewe'sxa' ewmeete nvxiitutxna. ");
INSERT INTO pbb_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Lampara's atũu dxiite aphçxa txajxa' txã'wẽ ya'pki'taçme', wejxwa ẽetek ya'txaja' eena' kweethkahn, kxah maawa u'kasa' eena'te u'kakahn. ");
INSERT INTO pbb_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Peekx kakwete yafxa' lampara na'wẽsata'. Aça' iidx yafxa' suwenimée ewçxa' iidx kakwete jxuka eena' kweethna nes yuuna. Nawa iidx yafx ewmée suweniite', iidx kakwe' jxuka çxhi'dxteçxáa neeyũuna. ");
INSERT INTO pbb_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Iidx kakwete kĩhte yuhwa çxhi'dxsamée jxuka eena'saçxáa ũste', jxuka ew uyuune'ga, lamparawa ma'wẽga ew eena' kweethe' txã'wẽ. ");
INSERT INTO pbb_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Nawa mpa'yajkx. Txã'wẽme', eena' khikhysa ji'phgu txãa kweethmeete', çxhi'dxteçxáa neeyũune'ga. ");
INSERT INTO pbb_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Txajũ' Jesusa' txã'wẽ we'wena jxã'the', teeçx fxariseo txajx yatte sã'jĩya' pi'kxku. Aça' Jesusa' u'jçxa ũ'ya' kaçxku. ");
INSERT INTO pbb_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Txajũ' txãa fxariseo' naasũjk: Naa piçthẽ'ja' wala yuh fxiy yu'k kusekhẽ yu' kaahmée ũ'ya' kaçxku sũjũ'k. ");
INSERT INTO pbb_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Aça' Jesusa' na'jĩk: —Fxariseowe'sx i'kwe'sxa' plaatu waso ma'k yuu nawa txãa yuutxi' ekakhẽ yu' pkhi'khi'i'kwe. Nawa i'kwe'sx ũus dxiite yu', pesweena kĩjkĩhwa ewmeeçxáa yũunisaçxáa jxuka uta ũsa'. ");
INSERT INTO pbb_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","I'kwe'sxa' jiimeewá'kwe: Dxusa' kakwekhẽ ãakhẽwe'sxçxá's uyçxa', ũustewe'sx yu's uyu'çmeene' ¿sũjũ'wá'kwe? ");
INSERT INTO pbb_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Txã'wẽ kĩhwa ji'phmeesatx ũusuh jxuka peeygãhna lmusxnu peeswaça', ãakhẽçxáa yaatesa yuumeene'kwe. ");
INSERT INTO pbb_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Fxariseowe'sx, i'kwe'sx yakha' seena' yuh ũukhũukha', i'kwe'sxa' putatxhã', me'sukwe, kĩjkĩhwa uuthasxte ũsna txãa yu'sa' jxuka diesmo dukhçxawa, Dxus yu'sa' ũusu jxuka wedxna nwẽese'jna fxi'ze'çmeei'kwe naa pa'ga seena' yuh ũukhũukha'. Diesmo's dukhwa'j yuja', nawa Dxusna nwẽese'jni wejx jxthaakwe ewa'. ");
INSERT INTO pbb_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Fxariseowe'sx, i'kwe'sx yakh seena' yuh ũukhũukha', i'kwe'sxa' judiuwe'sx pkhaakhenisu kaçxni wejx ewsaçxáana i'kwe pakwé', sa' çxhabsu msuuwa ewkuẽçxáa weçxa jxthãasna i'kwe pekũju' naa pa'ga seena' yuh ũukhũukha'. ");
INSERT INTO pbb_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Ley kaapiya'jsawe'sx vxite' fxariseowe'sx, i'kwe'sx yakha' seena' yuh ũukhũukha', i'kwe'sxa' ãajuçxáa ew we'weçxa', ũus dxiiju yu' ewmeeçxáa yajkxna fxi'zepa'ga. I'kwe'sxa' uusáa pedani kafxa's aphnisa na'wẽi'kwe. Txãa kafxa's aphte', nasa' ma'wẽ dxiiga kĩh ũstewa jiimée kajkwesu skhẽuukx txã'wẽçxáa i'kwe jiyunimeete fxi'ze' jĩte', ");
INSERT INTO pbb_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","ley kaapiya'jsa pasçxa': —Kwe'sxtxig açewe'we' jĩtewa, ");
INSERT INTO pbb_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Jesusa' ki' we'weçxa': —Ley kaapiya'jsawe'sx, i'kwe'sx yakha' seena' yuh ũukhũukha', i'kwe'sxwa vxiteçxáatx txã'wẽ kim yuhwa ãjãwa'jmée thẽysa's ũsçxa', i'kwe'sx yu', ma'wẽkuẽçxáa yuhwa pu'çxhiçmeei'kwe naa pa'ga. ");
INSERT INTO pbb_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Txã'wẽy i'kwe'sx ji'j yaçgawe'sx txã'wẽ Dxus yuwe pta'sxsatx ikhçxa pedaate', i'kwe'sx yu' txãa pedani's zhiçxkwe vxitnai'kwe pheu'ju'. ");
INSERT INTO pbb_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Sa' txã'wẽ yũuçxa', kwe'sx ji'j yaçgawe'sx ew yuh yuutx jĩçxane'kwe txãawe'sx ikhçxa pedani's zhiçxkwe vxitna pheu'ju' naapa'ga i'kwe'sx yakha' seena' yuh ũukhũukha'. ");
INSERT INTO pbb_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Kxajíi Dxusa' txã'wẽ yũuni's we'weçxak na'jĩ': Adx yuwee pta'sxsa txãniitey ensuwa kaja'nja, sa' naa ensuwa kaja'nja. Nawa maaíitxi' ikhetxna, sa' vxite yuutxi' wala ahçena pkxuutxna jĩ'k. ");
INSERT INTO pbb_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Naa ensu nasa' jxukaysa kastigo's knayuutxna, ");
INSERT INTO pbb_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","txã'wẽ Abela's ikhnijũjx Dxus yuwe pta'sxsatx ikhçxa Zakariasa's ikhni entepkaçx ee pkawpa'ga. Txãa Zakarias yu'sa' dxuus yat patxute altal utxatetx ikh. Txãa pa'ga naa ensu nasatx Dxusa' kastigaĩna, txã'wẽ Dxus kaahnisatx ikhpa'ga. ");
INSERT INTO pbb_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Ley kaapiya'jsawe'sx, i'kwe'sx yakha' seena' yuh ũukhũukha', i'kwe'sxa' txakwe wala leya's jiisatha'w jĩçxawa, vxite yuutxi's kaapiya'ja'çmeei'kwe. Txãasa vxite jiyu wẽesatx i'kwe'sxa' yupnaçxáa ũsi'kwe jĩte', ");
INSERT INTO pbb_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","ley kaapiya'jsawe'sx vxite' fxariseowe'sxa' wala ũusaçxaçxa kĩhçxáawa wala paapẽjxtxi, ");
INSERT INTO pbb_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","kĩhteçxáawa ewmée paste' pãatxhĩ'khya' sũhçxa. ");
INSERT INTO pbb_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Txajũ' nasa iiméh seena' wala pkhaakheçxa jxuka utate', Jesusa' txãa yakh u'jusawe'sx khuẽ'ytxi na'wẽk we'we: —Fxariseowe'sx ewmée yũuna fxi'zeni's mpa'yajkxwe. Txã'wẽme' txãawe'sxa' ãajuçxáa ew we'weçxa', ũus dxiite yu', ewmeeçxáatx yaaki'. ");
INSERT INTO pbb_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Nawa makwe paaçte sũthnisaçxawa kĩh yuhwa ãate vxyaamée yu' neeyũumeena, sa' makwe ũusteçxáa yaakxnisawa kĩh yuhwa jiyunimée yu' neeyũumeena. ");
INSERT INTO pbb_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Txãa pa'ga i'kwe'sxa' kim yuhwa wẽsẽ'jnimeete wá'kwe we'we' nawa jxuka pthũusena. Meeçxa' i'kwe'sx ũusteçxáa wá'kwe ewmée yajkx, nawa maazkuẽe yat-suwa jxuka kaajiyu'jni yuuna. ");
INSERT INTO pbb_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Ãçxha', adx namiku i'kwe'sxtxi na'jĩ'th: Kakweçxá's ikhsatxi' ũukhnuwe. Txãawe'sxa' kakweçxá's ikhçxa', jwee yu' kĩhwa yũuya' ãjãmeetxna. ");
INSERT INTO pbb_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Nawa pta'sxiçthu kimna ũukhwa'thewa: Naa kiwete ĩtxĩ u'juni's kusa'jçxa', ũusa's infxiernote kaahwa'jsaçxá's ũukhna mfxi'zewe. Txã'sçxáa ũukhwa'ja'. ");
INSERT INTO pbb_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Tahç vxiçxakuẽtx e'z centawoteçxáak ya'txweyú'. Nawa makwe pa'gameesatewa Dxusa' teeçxçxáa yuhnawa peçxkanaméek thegna fxi'ze'. ");
INSERT INTO pbb_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","I'kwe'sx jxkwette dxkhas yuhwa jxuka isani ũsta'. Aça' i'kwe'sx yu' maazkuẽe vxiçxakuẽtewa jxthaakwe pa'gasai'kwe. Txãasa ũukhmée mfxi'zewe. ");
INSERT INTO pbb_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","I'kwe'sxtxi na'jĩçthu: maawa naa kiwete nasaa dxi'pte thaamemée Kristo jĩith jĩna ãate pta'sxsatxi', adxwa Dxus Nçxi'k Nasa Yuusa' txã'wẽy Dxus angeleswe'sx dxi'pte thaamemée: Na' adx nasata' jĩna pta'sxi'nja. ");
INSERT INTO pbb_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Nawa maawa naa kiwete nasaa dxi'pte thaameçxa Kristo's jiimeeth jĩna ĩsxĩijana aça' adxwa Dxus angeleswe'sx dxi'pte txã'sa' jiimeeth jĩ'nja. ");
INSERT INTO pbb_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Maawa Dxus Nçxi'k Nasa Yuusa's makwe açewe'wetewa, ya'peltunaĩna. Nawa Dxus Espiritu's açewe'wete', bagaçxte yuhwa peltunãynimée yuuna. ");
INSERT INTO pbb_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Na'jĩ'th na': i'kwe'sxtxi judiuwe'sx pkhaakhenisu meeçxa' khuẽswe'sx tasxte kuutxa'thewa, ũukhnuwe kuh yajkxna kĩh we'weki'th sũhna. ");
INSERT INTO pbb_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Txãa pa'gatey Dxus Espiritu' ma'wẽ we'wewa'ja'swa kaaũusuthe'jena txãa dudte jĩk. ");
INSERT INTO pbb_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Txajũ' teeçx piçthẽ'j nasaa ksxavxyte ũssa' Jesusa's na'jĩk: —Adx yakhthẽ'ja's meen we'we, tatawe'sx ji'phuni's pxãhn adx jĩi txudeekahn jĩte', ");
INSERT INTO pbb_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Jesus pasçxa': —¿Kimga adxa'sa' txudeedewa'jsa meeçxawa khuẽs na'wẽsa ki'p? jĩçxa', ");
INSERT INTO pbb_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","na'wẽk we'we: —Mpa'yajkxwe, naa kiwete ji'phuniçxá's yaakxnisa's. Txã'wẽme' naa kiwete kĩjkĩhwa ji'phuçxaçxáa txã'wẽ ĩtxĩ ya'fxi'ze'çme'. ");
INSERT INTO pbb_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Txajũ' Jesusa' na'wẽk ejemplo pta'sx: —Teeçx piçthẽ'j wala ji'phsa u'pu'k. Txajx kiwete uuthasx wala yũnku. ");
INSERT INTO pbb_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Aça' txãa ji'phsa' yajkxya' kaçxku: ¿Ma'wẽ yũuki'th? Mtee yuhwa adx ũ'a's jxuka jxaawya' ãjãnimeeth sũjũ'k. ");
INSERT INTO pbb_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Sa' yajkxku: Jiiyã'th ma'wẽ yũuwa'ja'swa. Ũ' jxaaw yattxi pẽtxya'wath, vxite wejx walasa txajxa'. Sa' kĩjkĩh ũ'wa thẽ'the' vxite' kĩh ji'phunitxwa kxtee jxaawu'nja. ");
INSERT INTO pbb_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Txajũ' adx ũuste na'jĩ'nja: Wala kĩhwa jxaawni ji'phgu, wala kuh anxu selpiwa'j. Ãçxha' mjĩimée kaasena kĩhwa ũ'na weçxweçxa miyajkx sũjũ'k. ");
INSERT INTO pbb_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Nawa Dxusa' na'jĩk: Ãhmeeg yaaki'. Naa kuste uuya'wag. Aça' iidx ji'phuni jxaawni' ¿kiim jĩi yuuwa'jtxna? jĩk. ");
INSERT INTO pbb_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Jesus we'weçxa': Txã'wẽk ya'yu' naa kiwete ji'phuniçxá's nuywalaana ũsçxa', Dxus dxi'pte yu' puuplek neeyũ' jĩk. ");
INSERT INTO pbb_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Jesusa' txãa yakh u'jusawe'sxtxi' na'wẽk yu'kxpeh: —I'kwe'sxa' ¿kĩhte ũ'wa'j uyuukxtha'w? Sa' ropawa ¿kĩhte uyuukxtha'w? sũhna pa'pçxunuwe. ");
INSERT INTO pbb_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Txã'wẽ yuukahmeníi ĩtxĩ fxi'zenisa' ũ'nite jxthaakwe ewsa', aça' txã'wẽy kakwewa ropate jxthaakwe ewsa'. ");
INSERT INTO pbb_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Vxiçxakuẽtx mthegwe wakx. Txãawe'sxa' uja'çwameeta', sa' ũ' jxaaw yatwa txahçxa ũ' pkhakhe'çwameeta'. Nawa Dxusa' txãawe'sxtxi' sã'jĩ'k na' i'kwe'sx yuutxi's wejx txã'wẽ sã'jĩna vxiçxakuẽte jxthaakwesai'kwe naa pa'ga. ");
INSERT INTO pbb_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","I'kwe'sxa' ¿maaçxá' iiméh wala pa'pçxuçxa peena medio metro thaakwe walaaya' ãjama'kwe? ");
INSERT INTO pbb_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Txã'wẽ ãjameeçxa', ¿kĩjxa'çxáakwe naa kiwetewe'sxçxáatx txakwe wala pa'pçxu'? ");
INSERT INTO pbb_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Kitetx mthegwe, ropa uyya' mjĩimeeçxawa ma'wẽta zhiçxkwe walá'. Isath we'we': Jxkaahsa Salomon txakwe ji'phsa yuhçxawa txãa kite na'wẽ yu' zhiçxkwesa ropa athme'. ");
INSERT INTO pbb_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Kite' teeçx en fxi'zena', kuskuuskhẽ' ipxte kabwa'jçxáa yã'thewa txã'wẽk zhiçxkwe pheu'j. Dxusa' txã'wẽy i'kwe'sx yuutxi's wejx ropa ewsa ũsna nes yuuna na's i'kwe Dxusa' txã'wẽ yuuna sũjũ'çmée. ");
INSERT INTO pbb_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Txã'wẽ yã'the', ũ'wa'j ¿kĩhte uyuukxtha'w? sũhna pa'pçxuna fxi'zenuwe. ");
INSERT INTO pbb_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Naa kiwete nasaçxáatx kakwete peejiniçxáana yajkxna fxi'ze'. Nawa i'kwe'sxa' cielute Tata ji'phi'kwe txã' jxuka jiiyã'ja' i'kwe'sx kĩh peejini'swa. ");
INSERT INTO pbb_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Txãa pa'ga wejxwa Dxus jxkaahnitewe'sxa's khuẽ'yna wejx thaakwe mpa'pçxuwe. Naa kiwetewe'sxtxi' wejx pa'pçxumeetewa, pejka yuh ũsni yuuna. ");
INSERT INTO pbb_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","I'kwe'sxa' kuhmeekwe i'kwe nawa ũukhnuwe, txãa pa'gatey i'kwe'sx Tata cielutewe'sxa' i'kwe'sxtxi peeygãhçxa txajx jxkaahna ũsni's i'kwe'sxtxi ũsya'wa'. ");
INSERT INTO pbb_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Ji'phunisa's txweyçxa jxpeejxsatx mpeeswe. Vxyu jxaawni suwewa'jmeesa mvxitwe. I'kwe'sx ji'phuni cielutewe'sxa' pçumeena, kxteea' kĩh peswée yuhwa u'kameena, sa' çxikaçxáa yuhwa suwmeena. ");
INSERT INTO pbb_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Mtee jxaawni ji'phçxa', kxte yuuçxáak wejx jxthaakwe yajkxna ya'fxi'ze'. ");
INSERT INTO pbb_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Jxuka pheu'jçxa lamparatx pki'taçxa ũythasna meswe. ");
INSERT INTO pbb_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Patrona' boda yatu sxawedna pa'jçxa', vxitxte tu'kakaçpkaçxha', selpisaawe'sxa' dudtey vxitxa's phaadeya' jxpa'yakx ũythasna ũssa na'wẽ myuuwe. ");
INSERT INTO pbb_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Jxpa'yakx ũste patron pa'the', selpisaawe'sx yakha' wala yuh weçxa yuhna. Isath we'we': Txã'wẽ jxpa'yakx ũssatxi' patrona' pheu'jçxa mesate kaaçxi'jina puuçya'. ");
INSERT INTO pbb_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Kuspxãh ma'k yuu meeçxa' khikhiiçte ma'k yuu nawa jxpa'yakx ũste pa'the', selpisaawe'sx yakha' wala yuh weçxa yuhna. ");
INSERT INTO pbb_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Ũus miyajkxwe wakx: Maa yat namuwa peswée kĩh orate txajx yatte pa'jwa'ja's jiyuwaça', dehmée jxpa'yakx ũsçxa' ka'ga'jmeena txajx yatte pesweewe'sxte. ");
INSERT INTO pbb_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","I'kwe'sxwa txã'wẽy pheu'jçxa jxpa'yakx meswe. Txã'wẽme', yajkxmée ũsiyna, Dxus Nçxi'k Nasa Yuusá' kĩhçxáa yuuna jĩk. ");
INSERT INTO pbb_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Txajũ' Pedro' na'wẽk pẽjx: —Naa ejemplo' ¿kwe'sx jĩiçxáa wáana meeçxa' jxukaysatx wá'ga pta'sxi'? jĩte', ");
INSERT INTO pbb_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Jesusa' na'wẽk pta'sx: —Maa patronwa yultumu nwẽesẽ'jsa ewsa's neewe'weçxa nvxiituna, txajx yatte mjĩisatx sã'jĩna nes yuukahn. ");
INSERT INTO pbb_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Aça' patron jxkaahni's kxtey yuuna ũste patron pa'the', txãa selpisáa yakha' wala yuh weçxa yuhna. ");
INSERT INTO pbb_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Isath we'we': Txã'wẽ yũusa's patrona' txajx ji'phuni's kĩjkĩhnawa jxuka txãa yultumuçxaçxá's neewe'weçxa thegkahn nvxiituna. ");
INSERT INTO pbb_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Nawa txãa yultumu': Adx patron dud pa'jmeena sũhçxa kxtee mjĩisatx pkxuuya' kiiteçxa, txãa yu' tudxna tũuya' kiitena. ");
INSERT INTO pbb_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Naapkaçxha' txajx patrona' sxaweduuna txã'wẽ yultumu' patron pa'jwa'ja's jiimeeçxa' ũythasmée ũsiyna. Sa' wala seena' kastigaĩna, nwẽesẽ'jsameewe'sxtxi ma'wẽ kastigaĩkx txã'wẽy. ");
INSERT INTO pbb_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Maa selpisaawa txajx patron jxthãasni's jiiçxawa kxtey nwẽesẽ'jsame', wala kujus kastigãyni yuuna. ");
INSERT INTO pbb_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Nawa maa selpisaawa patron jxkaahni's jiimeeçxa' ãhmée yũuna txã'sa' kujusmée ya'kastigaĩna. Maanawa wala ũsçxa', wala ya'pẽyina. Aça' maanawa jxthaakwe kĩhnawa neewe'weçxa', jxthaakwe ew jxpe'khaníi yuuna. ");
INSERT INTO pbb_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Naa kiwete ipx pki'taya' kĩisa na'wẽth kĩh, behnayã'j ũswaç ma'wẽ wala weçxaaki'th. ");
INSERT INTO pbb_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Adxa' uuwa'jsath txãasa wala nxusna u'juth uuwa'j en ãhpkaçx. ");
INSERT INTO pbb_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Naa kiwete puiimée wẽt kaafxi'ze'jya'ne' kĩh ¿sũjũ'wá'kwe adxa'sa'? Nawa txã'wẽ yũuya' kĩhmeeth. Adx pa'gateçxáa maa nasaíi yu' puutx yahçena puiina fxi'zetxna. ");
INSERT INTO pbb_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Ãçxhũyã'ja' teeçx yattewe'sx tahç nasaçxawa tekhsa' e'zsatx ahçena puutx txã'wẽçxaçxáa puiina fxi'zetxna. ");
INSERT INTO pbb_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Neya' nçxi'ka's açeyajkxna fxi'zena. Aça' nçxi'ka' neya's txã'wẽy yũuna fxi'zena. Njĩ'ja' niisa's ahçena fxi'zena, aça' niisa' njĩ'ja's txã'wẽy yũuna fxi'zena. Swegra' nkuẽmyu's açena, naapkaçxha' nkuẽmyu', swegra's açena. ");
INSERT INTO pbb_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Txajũ' Jesusa' na'wẽk we'we: —I'kwe'sxa' sek khẽenijũ tãaph kiitena yuhte', nus pa'jya'wa' jĩ'i'kwe, aça' kxtey yu'k. ");
INSERT INTO pbb_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Sa' wejxaaçte', sek ya'wa' jĩ'i'kwe, aça' kxtey yu'k. ");
INSERT INTO pbb_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","¿Ma'wẽ yuuçxa nus pa'jna ki' sek ya'watewa jiisatha'w jĩna ũuste yu' iiwejçx i'kwe yajkxna fxi'ze'? Sa' jiisaçxa' ¿ma'wẽtekwe naa ensu' kĩh yũuçtewa txã's yu' jiyu'çmée? ");
INSERT INTO pbb_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","I'kwe'sxa' ¿mjĩitekwe ewteçxah puutx we'wena yuwe's pheu'ju'çmée? ");
INSERT INTO pbb_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Maawa idxa's pãatxhĩ'khte', txãa yakh khuẽs tasxte utxaaya' u'jweççxa', dxi'the ewteçxah puutx we'wena yuwe's mpheu'jwe, kxah khuẽs tasxte kuutxa'jmeena. Txã'wẽme', khuẽsa' idxa's policia's dukhena, aça' policia yu', karcelte kxuuphana. ");
INSERT INTO pbb_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Na'jĩ'th na': Txajũyã'ja' vxyu nmeh ji'phuni's dukhmeeçxa yu', karceluh kasehmeene'ga jĩk. ");
INSERT INTO pbb_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Txãa ensuy nasa maaíi yu' Jesusa's na'wẽtx pta'sxna utxáa: —Galileajuwe'sxa' Dxusna weçxana neewe'weya' altalte kabwa'j tajkx ikheçpkaçxha', Pilato' txãawe'sxtxi' ikhkaakh, aça' txãawe'sx eea' takx ee yakh jxuka ka'duk jĩte', ");
INSERT INTO pbb_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Jesusa' na'jĩk: —Galileaju nasatx txã'wẽ yũute', txãa uusaawe'sxa' Galileasu nasate jxthaakwe pkalsane'ta yu', txãa pa'gatx txã'wẽ uu ena's ji'phu ¿sũjũkwé'? ");
INSERT INTO pbb_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Na'jĩ'th na': Txãawe'sxçxáa thaakwe pkalsa yu'çmeeta'. Aça' i'kwe'sxwa pkaltxi nvxihtçxa Dxus tasxte sxawedmeeçxa', txãawe'sx na'wẽyçxáa uuwa'jsai'kwe. ");
INSERT INTO pbb_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Txã'wẽy diecioçxo nasa Siloete toçxe kajkwekhẽ wetete' uutx txãa uusaawe'sxa' Jerusalen çxhabte u'psawe'sxte jxthaakwe yuuwesane'ta yu', txãa pa'gatx txã'wẽ uu ena's ji'phu ¿sũjũkwé'? ");
INSERT INTO pbb_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Na'jĩ'th na': txãawe'sxçxáa thaakwe yuuwesa yu'çmeeta'. Aça' i'kwe'sxwa pkaltxi nvxihtçxa Dxus tasxte sxawedmeeçxa', txãawe'sx na'wẽyçxáa uuwa'jsai'kwe. ");
INSERT INTO pbb_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Jesusa' naa ejemplo'sku pta'sx: —Teeçx piçthẽ'ja' higwera fxtũu tasxku txajx kiwete uhni ji'phu'. Sa' thegya' u'kh, yũnwáana sũhçxa. Nawa uyme'. ");
INSERT INTO pbb_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Txajũ' na'jĩk kxtee uuthasx thegsa's: Naa fxtũu tasx yũnuuçwáana sũhçxa adx thegya' pa'jna ũsni tekh anxuyã'ja', nawa teeçx yũn yuhwa uynimeeth. Aça' mespẽ'th, ¿mjĩya'çxáa kxul ũsya'wana? jĩte', ");
INSERT INTO pbb_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","uuthasx thegsa pasçxa': Menvxiht naa anxuçxáawa, aça' kiwe's luupe'jçxa sxaakwe'je'nja. ");
INSERT INTO pbb_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Aça' yũnne'jwáana. Txã'wẽ yũute yũnmeete, kaaspẽ'the'jene'ga jĩk. ");
INSERT INTO pbb_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Teeçx sapatu jxkaase ente', Jesusa' judiuwe'sx pkhaakhenitek kaapiya'jna ũsu'. ");
INSERT INTO pbb_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Aça' kxte' teeçx u'y diecioçxo anxuyã'j ãçã'na u'jusak ũsu', eçx luuku vxit-sa pkxuute ku'le u'juya' ãjasamée. ");
INSERT INTO pbb_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Aça' Jesus uyçxa', pa'yak: —I'kwe' naa weeju katxhiyã'ji'kwe jĩçxa', ");
INSERT INTO pbb_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Jesusa' ãçã'sa kakwete jxa'dxku. Naapkaçxha' txãa u'ya' dudtey ku'le'ya' ãjãçxa', seena' wala Dxusa's weçxana we'wek. ");
INSERT INTO pbb_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Jesusa' txã'wẽ sapatu jxkaase entewa ãçã'a's nuykatxhite', judiuwe'sx pkhaakhenite npiiçthẽ'jsa' ũusaçxaçxa nasatx na'jĩk: —Ki'su' seis en ji'pha' mjĩiwa'j. Aça' katxhi wẽeçxa' vxite ensu myuhwe. Nawa sapatu jxkaase ente yu', katxhiya'çxáa yu' pa'jnuwe jĩnak jxkaah. ");
INSERT INTO pbb_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Aça' Jesus pasçxa': —Ãateçxáa ew we'weçxa' ũuste yu' ewmeeçxáa yaakxsawe'sx mpaaswe: I'kwe'sx kla meeçxawa i'kwe'sx jiba tudni ũste', makwe jxkaase entewa jxũkhwedeçxa yu' yusya' ¿jxũna u'jmeema'kwe? ");
INSERT INTO pbb_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Naa u'ya' Abrahan ji'ja' nawa eçxthẽ'ja' diecioçxo anxuk kaãçã'jna ji'phu'. Aça' makwe jxkaase entewa eçxthẽ'j kuseju kusa'the ¿ewmeemanx? jĩte', ");
INSERT INTO pbb_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Jesusa's açeyaakxsawe'sxa' wẽsẽ'jçxa', thaametx. Nawa nasa jwee kuhsa yu' weçxa'tx, Jesus txakwe wala ew yũupa'ga. ");
INSERT INTO pbb_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Txajũ' Jesusa' na'jĩk: —Dxus jxkaahwa'j ena' ¿ma'wẽkx sũjũ'kwe? Txã'sa' ¿kĩh yakh kaaja'da'jaki'th? ");
INSERT INTO pbb_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Nawa na'wẽ': teeçx piçthẽ'j txajx kiwete mostasa fxiwa's uhte', ma'wẽ seena' walaakx. Aça' vxiçxakuẽ yuhwa txãa mostasa ku'tasu yaatutxki txã'wẽsa'. ");
INSERT INTO pbb_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Ki'kin vxite ejemplo na'wẽsa yakhku kaaja'da'jna pta'sx Dxus jxkaahwa'j ena's: ");
INSERT INTO pbb_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","—Teeçx u'ya' tekh libra skuutxh ũ'wete le'çxkwe lewadura's ka'dte', ma'wẽ jxuka pẽethẽjekx txã'wẽy yuuna jĩk. ");
INSERT INTO pbb_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Jesusa' Jerusalenna u'jweççxa', çxhabsu msuuwa iikaapiya'kh u'jwe'. ");
INSERT INTO pbb_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Aça' teeçxsa' na'wẽk pejx: —Dxus tasxte ewte neeyũuwa'jsa' ¿kuhmeewáatxna? jĩte', Jesus pasçxa': ");
INSERT INTO pbb_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","—I'kwe'sxa' wala yuh mpa'pçxuwe vxitx pteezte u'kaya'. Na'jĩ'th na': Maawa wala yuh u'ka wẽjẽtxna, nawa thẽytewa pa'pçxumeeçxa yu' u'kaya' ãjãmeetxna. ");
INSERT INTO pbb_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Yat namu' vxitxa's aphyã'the', i'kwe'sxa' ekaju neeyũuçxa' vxitxte tu'kakana na'jĩne'kwe: Vxitxa's meen phaade, kwe'sx u'kaya'watha'w jĩne'kwe. Nawa txãa pasçxa': Adxa' jiimeeth i'kwe'sxa' majũwe'sxne'kwe nawa jĩte', ");
INSERT INTO pbb_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","i'kwe'sxa' na'jĩne'kwe: Kwe'sxa' idx yakh txutemée mteewa u'jusatha'w. Aça' idxa' kwe'sx çxhabsuwa kaapiya'jg jĩwá'kwe. ");
INSERT INTO pbb_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Nawa txã' na'wẽ pasuna: Na'jĩyã'th na', i'kwe'sxtxi' jiimeeth majũwe'sxne'kwe nawa. Adx tasxu me'jwe, i'kwe'sxa' jxukay ewmée yũusaçxáa i'kwe jĩna. ");
INSERT INTO pbb_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Aça' i'kwe'sx yu' eka kutxi'jni neeyũuçpkaçxha', Abrahan, Isaak, Jakob vxite' Dxus yuwe pta'sxsa txãawe'sx yu' Dxus jxkaahna ũsnite ũste uyçxa', seena' wala ũ'nene'kwe ki'th yuhtxwa ksuusu'jna. ");
INSERT INTO pbb_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Ekaju neeyũusáa txã'wẽ nxuskahníi sek kãanijũwe'sx, sek khẽenijũwe'sx, majũ majũwe'sxwa jxuka pa'jya'wata', Dxus jxkaahna ũsnite u'kaya'. ");
INSERT INTO pbb_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Aça' kxtee u'kawa'jsa ãçxh maaíi yu' e'stewe'sx ũsta' txãa yu' yaçte yuutxna, naapkaçxha' yaçtewe'sx yu' e'ste yuutxna jĩk. ");
INSERT INTO pbb_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Txãa entey maz fxariseowe'sx pa'jçxa', Jesusa's na'jĩtx: —Me'j ayjxu. Txã'wẽme', Herodesa' idxa's ikhya'wa' jĩna pta'sxte', ");
INSERT INTO pbb_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Jesus pasçxa': —U'jçxa na'jĩne'kwe txãa thẽ'ja's: Ãçxh yakh kuskus yakh nee mjĩiwa'j ji'phthu eçx luuku vxit-satx nasa ũusu kutxi'jna ãçã'satxwa nuykatxhina. Sa' tekh ente' mjĩina jxã'ja'nja jĩ'k jĩne'kwe. ");
INSERT INTO pbb_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Adxa' nee u'juwa'j en ji'phíiçxáath tekh en ãhpkaçx, txãa pa'gatey Dxus yuwe pta'sxsa' Jerusalen ekaju yu' uuwa'j ji'phme'. ");
INSERT INTO pbb_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Jerusalentewe'sxa' Dxus yuwe pta'sxsatx ikhna Dxus kaahnisatxwa pãpana pkxuui'kwe. Nawa adxa' i'kwe'sxtxi' maazkuẽe uswa pa'yath nwe'weya', atalxwa ma'wẽga luuçxkuẽtx fxuu ku'ta dxiite yu'ãsxi' txã'wẽy yũuya', nawa nwẽesẽ'jmeei'kwe. ");
INSERT INTO pbb_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Txãa pa'ga mpa'yajkxwe. I'kwe'sx çxhaba' jxuka pçuuna sa' ãçxhũyã'ja' adxa's peena yu' uymeene'kwe, Dxus kaahni jxtuhthe ki' kĩiwa'j en ãhpkaçx jĩ k. ");
INSERT INTO pbb_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Teeçx sapatu jxkaase ente' Jesusa' fxariseo npiiçthẽ'j yattek ũ'ya' u'j. Aça' vxite fxariseowe'sx yu' peethegu'natx ũsu'. ");
INSERT INTO pbb_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Txãa yatte' teeçx piçthẽ'j çu'vxy weete ãçã'sak ũsu'. ");
INSERT INTO pbb_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Aça' Jesusa' na'jĩnak pẽjx ley kaapiya'jsawe'sx vxite' fxariseowe'sxtxi: —Sapatu jxkaase entewa ãçã'sa's nuykatxhite ¿ewmanx? jĩte', ");
INSERT INTO pbb_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","txãawe'sxa' pasmée sxuuna'tx neeyũu. Aça' Jesusa' txãa ãçã'sa's pa'yaçxa nuykatxhiçxak kaah. ");
INSERT INTO pbb_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Sa' fxariseowe'sxtxi' na'jĩk: —I'kwe'sx jiba meeçxawa i'kwe'sx kla kafxte khẽeçxa u'pte', ¿dudtey kutxi'jmeema'kwe jxkaase entewa? ");
INSERT INTO pbb_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Txã'jĩte', weh yuhwa pasya' ãjãmeeta'. ");
INSERT INTO pbb_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Fxiestate pi'kxnisa' kaçxni ewsaçxáatx txhitxhiçte uyçxa', Jesusa' na'wẽk yu'kxpeh: ");
INSERT INTO pbb_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","—Boda fxiestate i'kwe'sxtxi pi'kxte', kaçxní ewsu yu' kaçxnuwe. Txã'wẽme' vxite i'kwe'sxte jxthaakwe jxtuhthesa wáa pa'jana, ");
INSERT INTO pbb_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","aça' fxiesta namu' i'kwe'sxtxi kiisuna: Ayte' naajx kaçxwa'jçxá' jĩçxa. Aça' wala thaamena u'jwene'kwe kaçxní açxamée ewkhẽ kaçxya'. ");
INSERT INTO pbb_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Fxiestate i'kwe'sxtxi pi'kxte', wejxwa nmeh puzakhẽ mkaaçxwe, kxah i'kwe'sxtxi pi'kxsa uyçxa': Namiku, ay yaçkhẽ wejx ewkhẽ myuh kaçxya' jĩte', wala weçxana yaçkhẽ kaçxya' u'jwene'kwe. ");
INSERT INTO pbb_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Maawa walasath sũhna iiwejçx iiwejçx yaakxsa' thaamewa'jçxáa ji'phuna. Nawa ãhmeekwesa na'wẽçxáa yajkxna fxi'zesa' jxtuhthe wálasa yuuna. ");
INSERT INTO pbb_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Sa' fxiesta namu pi'kxsa'swa na'jĩk Jesusa': —Idxa' sã'jĩya' pi'kiççxa', iidx namikuwe'sxtxi yakhthẽ'jwe'sxtxi pukakhẽ npe'sxtxi meeçxawa utxasuwe'sx vxyu ji'phsatx pi'kxnu. Txã'wẽme' txãawe'sxwa kaasxwedu'ju'tha'w jĩna idxa's txã'wẽy sã'jĩya' pi'kitxna. ");
INSERT INTO pbb_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Aça' sã'jĩya' fxiesta vxituççxa', wejxwa puuple ãhmeekwesa legsa uysamée txã'wẽsaçxáatx mpi'kx sã'jĩya'. ");
INSERT INTO pbb_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Aça' txãawe'sxa' ka'tu' txã'wẽy kaasxwedu'jya' ãjãmeetxna idxa's. Nawa weçxana mneeyũu, txãa pa'gatey Dxusa' idxa's deweena Dxus luuçx ki' ĩtxĩ yuu ente' jĩk. ");
INSERT INTO pbb_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Txã'wẽ pta'sxni's wẽsẽ'jçxa', mesate u'psa teeçxsa' na'wẽk we'we Jesusa's: —Dxus jxkaahna ũsnite u'kaçxa ũ'sa yakha' wala yuh weçxa yuhna jĩte', ");
INSERT INTO pbb_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Jesusa' na'wẽk kwentu'j: —Teeçx piçthẽ'j fxiesta wala vxituççxa', nasa seena' wala kuh pi'kxku sã'jĩya'. ");
INSERT INTO pbb_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Sa' ũ'wa'j ora ãjãçte', teeçx selpisa's pa'yaya' kaakh: Ũ'ya' myuhwe, jxuka pheu'jniyã'j ũsa' jĩna pa'yakahn. ");
INSERT INTO pbb_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Nawa jxukaysa wa'lçxa na'wẽçxáatx pas: Nyafxtewe'sx pasçxa': Kiweth wey, sa' thegya' u'jwe ji'phthu. Aça' tee peltunaĩ jĩk. ");
INSERT INTO pbb_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Aça' vxite we'weçxa': Diez novxilxoth wey, sa' thegya' u'jweçthu. Naa pa'ga tee peltunaĩ jĩk. ");
INSERT INTO pbb_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Aça' tekhtewe'sxa' na'wẽk pas: Ãçxçxáatha'w ptamúu, sa' yujxa' tuduume'nja jĩk. ");
INSERT INTO pbb_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Txajũ' selpisá' sxawedna u'jçxa txajx patrona's jxuka pta'sxku. Aça' patrona' wala ũusaçxaçxa txã's selpisa's na'jĩnak jxkaah: Dudtey plaasasu klxiikhunsu ki' u'jçxa puuple ãhmeekwesa legsa yafx puuple uysamée txã'wẽsatx pi'kxçxa ayte pe'jna yuweene'ga jĩk. ");
INSERT INTO pbb_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Aça' selpisá' u'jçxa ki' sxawedna pa'jçxa': Iidx jxkaahni's kxtey yuuth, aça' pa'jtx. Nawa kaçxwa'j yu' nee ũsiyçxáata' jĩte', ");
INSERT INTO pbb_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","patrona' selpisá's na'jĩk: Ãçxha' çxhab ekaju jxu'juwe'sx vxite' dxi'j u'jsatxwa pi'kxçxa ayte ka'ga'jane'kwe makwe wa'luçtewa ãadxijimée, adx yatte utapkaçx. ");
INSERT INTO pbb_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Nawa nyafxte pi'kxnisa wa'ltxi txãawe'sx yuutxi' kaapa'ja'jme'nja adx yatte puuçya' jĩk. Txã'jĩnak kwentu'j Jesusa'. ");
INSERT INTO pbb_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Txajũ' Jesus e'ste nasa wala u'jweç yu'tx, aça' txãawe'sxtxi yu'thegçxa na'jĩk: ");
INSERT INTO pbb_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","—Maawa adx yakh yuusá' txajx ney, njĩ'j, nyu, luuçx, nyakhwe'sx, npe'sxwe'sxtxi nvxihtçxa txã'wẽy iiwejçx yajkxna fxi'zeni's uu entepkaçx nvxihtmeeçxa yu', adx yakh fxi'zeya' ãjãmeena. ");
INSERT INTO pbb_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Sa' makwe thẽyte uupçxãhtewa txãatxi' yajkxmée, adx yakh yuhmeeçxa yu' adx yakh fxi'zeya' ãjãmeena. ");
INSERT INTO pbb_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","I'kwe'sxa' yat wálasa txajxa'waçxa', jxuka jxã'jwa'j kĩjkĩhwa ãh ũstxmanx sũhna kaçxçxa ¿yajkxmeema'kwe? ");
INSERT INTO pbb_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Txã'wẽ yũumeete', kiwete pxãhn pa'j mjĩiçxaçxáa nvxihtte', maawa uysa' npeevxysxikatxna: ");
INSERT INTO pbb_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Jxã'jya' ãjãme' jĩna. ");
INSERT INTO pbb_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Txã'wẽy maa npiiçthẽ'jwa vxite npiiçthẽ'j yakh puiiya'waçxa', kaçxçxa ũus yajkxmeema'k: Naa diez mil soldau yakhçxáa weinte mil soldautx ¿knayma'th? sũhna. ");
INSERT INTO pbb_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Sa' ewupçxãhmeete', vxite npiiçthẽ'j utxameyna, yuwe kajana kuçx puiimée ewteçxah neeyũuya'. ");
INSERT INTO pbb_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Aça' txã'wẽy i'kwe'sxwa dxiikhẽy jxuka ũus yajkxçxa i'kwe'sx ji'phuni's nvxihtmeeçxa yu', adx yakh fxi'zeya' ãjãmeene'kwe. ");
INSERT INTO pbb_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Nega' selpi'k, nawa jxuka sxũukãhçxa' ¿ma'wẽ selpiikx? ");
INSERT INTO pbb_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Kiwete sxaakwe'jwa'jçxáa yuhwa selpi'çme', pubwa'jçxáak yu'. Jiyuwa'jsa ũsçxa', jiyune'kwe jĩk. ");
INSERT INTO pbb_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Gobierno jĩi vxyu pkhakhsawe'sx vxite' pkalsawe'sx jxukaysa Jesus pta'sxni's wẽsẽ'jya' utxaatx. ");
INSERT INTO pbb_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Txãa pa'gatx Dxus ley kaapiya'jsawe'sx vxite' fxariseowe'sxa' Jesusa's na'jĩna nuywe'we: —Naa piçthẽ'ja' wala fxiy yu'k, pkalsawe'sxtxi jxpa'gaçxa txãawe'sx yakhku ũ'we' jĩte', ");
INSERT INTO pbb_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Jesusa' naa ejemplo'sku pta'sx: ");
INSERT INTO pbb_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","—I'kwe'sxa' cien piisxáa ji'phçxa', teeçxsa' vxyaameete', vxite nowenta y nwewesatx kxsũu nvxihtçxa ¿piisxáa vxitusa's pakweya' u'jmeema'kwe uypkaçx? ");
INSERT INTO pbb_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Sa' piisxa's uyçxa', yakhçxa wala weçxana ");
INSERT INTO pbb_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","yatte pa'jçxa, namikuwe'sx vxite' kxsũu utxasuwe'sxtxi pa'yaçxa: Adx piisxáa vxitusa's uyyã'th, aça' adx yakh ja'da weçxa mpu'çxwe jĩna ¿pta'sxmeema'kwe? ");
INSERT INTO pbb_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Na'jĩ'th na': Cielutewa txã'wẽy nowenta y nwewe nasa ewsate jxthaakwe wala weçxa yuja' teeçx nasaçxáawa pkaltxi nvxihtçxa Dxus tasxte sxawedte'. ");
INSERT INTO pbb_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Txã'wẽy teeçx u'y diez vxyu musx ji'phçxa', teeçxsa wetete', ¿lampara's pki'taçxa yatte jxpa'yakx padna pakwemeema'k uypkaçx? ");
INSERT INTO pbb_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Sa' txãa vxyu's uyçxa' txajx namikuwe'sx vxite' kxsũu utxasuwe'sxtxi pa'yaçxa: Ũ'kwe vxyu wetesa's uythu, aça' ũ'kwe yakh ja'da weçxa mpu'çxwe jĩna ¿pta'sxmeema'k? ");
INSERT INTO pbb_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Na'jĩ'th na': Dxus angeleswe'sxtxiwa txã'wẽy weçxa yuja' teeçx nasaçxáawa pkaltxi nvxihtçxa Dxus tasxte sxawedte'. ");
INSERT INTO pbb_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Txajũ' Jesusa' vxite ejemplo na'wẽsak pta'sx: —Teeçx piçthẽ'j e'z nçxi'kku ji'phu'. ");
INSERT INTO pbb_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Aça' nuuçxsa' neya's na'jĩk: Tata, iidx ji'phuni adx jĩi yuuwa'ja's txuhdeçxa mah jĩte', neya' txuhdeçxa dukhku. ");
INSERT INTO pbb_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Aça' jxpa'gani maz enteçxáa txãa nçxi'k nuuçxsa' ney dukhni's jxuka pkhakhçxa jxu'j kiwen u'kh. Sa' kxteea' ewmée yũuna jxuka vxyu's psuwna pebak. ");
INSERT INTO pbb_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Txã'wẽ vxyu's psuwna pebaaçpkaçxha', wẽjẽ en pa'kh txãa kiwete. Aça' txãa piçtakxa' wẽeya' yajkxku. ");
INSERT INTO pbb_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Sa' kxsũ mjĩi pakweya' u'kh teeçx piçthẽ'j tasxte. Aça' txãa piçthẽ'j yu' kuçxi sã'jĩya'k kaah txajx tulte. ");
INSERT INTO pbb_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Txajũ' txãa piçtakxa' wẽeçxa kuçxi ũ'pusnawa ũ' wẽek. Nawa txã'wẽsaçxáa yuhnawa puuçmeeta' txãa piçtakxa's. ");
INSERT INTO pbb_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Txajũ' ũus yajkxya' kaçxçxa naa sũjk: Adx yu' ayte wẽeçxa uuya'wath, naapkaçxha' adx tata yatte mjĩisa piuna' kĩh yuhwa wẽemée ũstxna maazkuẽeçxawa. ");
INSERT INTO pbb_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Aça' adx tata yatna ki' sxawedna u'jçxa na'jĩ'nja: Tata, Dxus dxi'pte wala ãhmée yũuth, sa' idxa'swa txã'wẽythu wala ãhmée yũu. ");
INSERT INTO pbb_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Sa' nçxi'kçxawa ãçxha' iidx peeygãawa'jmeeyã'th. Nawa iidx piun na'wẽçxáawa meen jxpa'ga jĩ'nja sũhnak yajkx. ");
INSERT INTO pbb_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Txajũ' kiiteçxa ney yatna sxawedna u'kh. Aça' pa'jaçte', neya' jiyuk jxu'the yujíyna. Sa' nçxi'ka's peeygãhçxa pu'thegya' wuwuuna u'jçxa, psxa'dçxak weçxa. ");
INSERT INTO pbb_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Txajũ' nçxi'ka' na'jĩk neya's: Tata, Dxus dxi'pte wala ãhmée yũuth. Sa' idxa'swa txã'wẽythu wala ãhmée yũu. Nçxi'kçxawa, ãçxha' iidx peeygãawa'jmeeyã'th jĩte', ");
INSERT INTO pbb_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","neya' selpisaatx pa'yaçxa na'jĩnak jxkaah: Ropa ewsa kutxi'jçxa dud mkaathe'jwe. Sa' sultxhikhawa kusete ki'pçxa spaatuwa mpaathwe. ");
INSERT INTO pbb_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Teeçx tulu piçtakx niisxsa's nikxya' u'jçxa miikhwe, fxiesta vxitçxa ũ'ya'. ");
INSERT INTO pbb_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Adx nçxi'ka' uuníi na'wẽ yã'jçxawa ki'kin ĩtxĩ yuuk, sa' vxituna u'juçxawa ki' vxyaak jĩçxa', wala weçxana fxiesta vxittxi. ");
INSERT INTO pbb_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Naapkaçxha' nçxi'k nthẽ'jsa yu' mjĩi ehsu u'juçxa', sxawedna yatte pa'jaççxa', wẽsẽ'kh ku'jna tukani músika zhiçxkwesa's. ");
INSERT INTO pbb_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Sa' teeçx selpisá's pa'yaçxa pẽjxku: Yatte' ¿kĩh yũuna ũstxna? jĩte', ");
INSERT INTO pbb_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","selpisá' pta'sxku: Iidx nyakh jxu'j kiwen u'jsa ki' sxawedna pa'kh. Txãa pa'ga iidx tata' tulu niisxsa's kiikhe'jçxa fxiesta'jaça' jĩte', ");
INSERT INTO pbb_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","nyakh nthẽ'jsa' wala ũusaçxaçxa yatte u'kaya' wa'lku. Aça' neythẽ'ja' kasehçxa wala pxthaa we'wek u'kakahn. ");
INSERT INTO pbb_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Txajũ' txãa nçxi'k yu' na'jĩk neya's: Adxa' maazkuẽe anxu iidx tasxte bagaçx yuhwa wa'lmée selpiina ũstewa jiig. Nawa idxa' teeçx kaplakuẽçxáa yuhwa iiũsmeeg, adx namikuwe'sx yakh fxiesta'khan. ");
INSERT INTO pbb_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Nawa iidx nçxi'k txakwe wala u'y ewmeesa yakh vxyu's psuwna pebasáa yu'sa' tulu niisxsa's ikhçxag fxiesta'ja' jĩte', ");
INSERT INTO pbb_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","neythẽ'j pasçxa': Adx nçxi'k, isa yuh we'we'g. Idxa' bagaçxtewa adx yakh txutemée nesgu yu', naa pa'ga adx ji'phuni' kĩhwa jxuka iidx jĩiçxaçxáata'. ");
INSERT INTO pbb_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Txã'wẽ iidx nyakh uuníi na'wẽyã'jçxawa ki'kin ĩtxĩ yuuk sa' vxituna u'juçxawa ki' vxyaak txãa pa'ga weçxana pejka fxiesta'jwa'j ji'ptha'w jĩk neya'. ");
INSERT INTO pbb_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Txajũ' Jesusa' na'jĩnak kwentu'j txãa yakh u'jusawe'sxtxi: —Teeçx patron wala ji'phsa' teeçx yultumu ji'phu'k. Aça' txãa yultumu ewmée yũuni's pta'sxtxi: Iidx yultumu' iidx ji'phuni's wala psuwna ũsa' jĩte', ");
INSERT INTO pbb_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","txãa patrona' txajx yultumu's pa'yaçxa na'jĩk: Adx ji'phunitxi' wala psuwna ũsa' jĩ'tx sa' idxa' ¿kĩh yũuna ũsga? Txã'wẽ yã'jçxa', idxna neewe'weni adx ji'phuni's jxuka ki' mdukh adxna. Idxa' peena yu' adx yultumu selpiiya' ãjãmeene'ga jĩte', ");
INSERT INTO pbb_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","yultumu' ũus yajkxya' kaçxku: Ãçxha' ¿kĩh yũuki'th adx mjĩia's patron kusa'the'? Adxa' uuthasxte mjĩiya' yu' jiimeeth sa' lmusxnu thãasna u'jute yu' thaameyuhna. ");
INSERT INTO pbb_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Aça' patron tasxu kasehnijũ maawa txãawe'sx yat-su pe'jna sã'jĩkahn na'wẽ yũuya'k yajkx: ");
INSERT INTO pbb_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Patrona's yuulsatx teeçx teeçxçxah pa'yaçxa, nyafxte utxaasa's pẽjxku: Idxa' ¿maz yuulga adx patrona's? jĩte', ");
INSERT INTO pbb_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Cien taçxo aceite yuulthu jĩk. Aça' yultumu' na'jĩk: Iidx yuuluni eça' ayga ũsa' txã'sa' dud yuh khũkhçxa, yuula's cinkwentaçxáa mki'p jĩk. ");
INSERT INTO pbb_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Txajũ' vxite'sku pẽjx: Idxa' ¿makwe yuulga? jĩte', cien açxoba skuutxh yuulthu jĩk. Aça' yultumu' na'jĩk: Iidx yuuluní eça' ayga ũsa' txã'sa' dud yuh khũkhçxa, yuula's oçxentaçxáa mki'p jĩk. ");
INSERT INTO pbb_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Txajũ' txãa yultumu ewmeesa' txã'wẽ dudtey yũuni's patrona' jiyuçxa': Ma'wẽ fxi'zewa'ja'swa dud yuh ũus yaaki'k jĩk. Aça' naa kiwete nasa pkalsa' Dxus luuçxte jxthaakwetx dud ũus yaaki' txãawe'sx ma'wẽ puutx we'wewa'ja'swa. ");
INSERT INTO pbb_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Aça' adxa' i'kwe'sxtxi' yu'kxpeje'th txã'wẽy yũukahn, naa kiwete ji'phuni's psuwmée jxpa'yakx mkseelpi'jwe namiku vxitna. Kxah naa kiwete ji'phunisa pçuutewa, vxite kiwe pçuwa'jmeete i'kwe'sxtxi jxpa'gawa'jsa ji'phune'kwe. ");
INSERT INTO pbb_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Maawa le'çxkuẽçxáa ji'phçxawa jxpa'yakx jxpe'jsa', walasa'swa txã'wẽy jxpa'yakx jxpe'jena. Aça' maawa le'çxkuẽçxáatewa jxpa'yakxmée psuwna jxpe'jsa', walasa'swa txã'wẽyçxáa jxpa'yakxmée psuwuuna. ");
INSERT INTO pbb_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Txã'wẽ naa kiwete ji'phuni'sçxáa yuhwa jxpa'yakxmée psuwna fxi'zeçte', i'kwe'sxtxi' ¿kim neewe'weçxa nvxiitukx pçuwa'jmée ji'phuwa'ja's? ");
INSERT INTO pbb_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Peekx jĩimée vxite jĩi yuhtxwa jxpa'yakxmée psuwna fxi'zeçte', ¿kim ũsukx i'kwe'sx jĩi yuuwa'ja's? ");
INSERT INTO pbb_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Maa selpisáa yuhwa e'z patrontxi selpiiya' ãjãmeena. Txã'wẽ vxiteçxá's wedxna fxi'zeçxa', vxite patron yu'sa' açena. Sa' teeçxsa jxkaahniçxá's kxtey yuuçxa', vxite patron jxkaahni yu'sa' kxtey yuuya' ãjãmeena. Txã'wẽy Dxusna selpiina naa kiwete ji'phuni'swa pa'pçxuna e'z ahtey yajkxna fxi'zeya' ãjãmeena jĩte', ");
INSERT INTO pbb_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","fxariseowe'sxa' naa kiwete ji'phuniçxá's wejx pa'pçxuna fxi'zesa wẽsẽ'jçxa', Jesusa's weeçx we'wetx. ");
INSERT INTO pbb_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Aça' Jesusa' na'jĩk fxariseowe'sxtxi': —I'kwe'sxa' naa kiwete nasaa dxi'pte yu' wala ewsa na'wẽ fxi'ze'i'kwe. Nawa Dxusa' i'kwe'sx ũus yaakxnitxi' jxuka jiia'. Naa kiwete nasaçxáa i'kwe'sxtxi' ewsata' jĩte', Dxus yu' txã'jĩmeena. ");
INSERT INTO pbb_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Moises ley vxite' Dxus yuwe pta'sxsawe'sx kaapiya'jni' Juan Bautista entepkaçxtxi ũsu'. Kxajuk yuwe u'sesa' Dxus jxkaahwa'j ena's pta'sxni yuu, aça' maawa Dxus jxkaahnitewe'sx yuuya' wala pa'pçxu'tx. ");
INSERT INTO pbb_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Makwe cielu pçuuna, kiwewa pçuuna, nawa Dxus jxkaahni ley yu' weh yuhwa yu'pthehwa'jsame' bagaçxte yuhwa jĩk. ");
INSERT INTO pbb_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Maa piçthẽ'jwa peekx nyu's wãatãhçxa vxite yakh ptamuuçxa', txã' pkal yuuna. Aça' maa piçthẽ'jwa txãa u'y wãatãanisa yakh ptamuuçxa', txãawa pkal íiçxáa yuuna. ");
INSERT INTO pbb_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Txajũ' Jesusa' vxite kwentu na'wẽsak pta'sx: —Teeçx piçthẽ'j wala ji'phsa u'pu'k. Sa' ropa ewsa yuuçxáa athçxa een isak wala weçxana fxiesta vxitu'. ");
INSERT INTO pbb_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Txãa ji'phsa yat vxitxte teeçx puuple wã'jyçxáa uta ji'phsa Lasaro yaasesak kiwete kaçxçxa u'pu'. ");
INSERT INTO pbb_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Txãa puuple yu' wẽeçxa ji'phsa mesa tasxsu kĩh ũ' pe'laçxáawa ũsxisatx ũ'wẽn ũythasna u'pte', alku' kũhçxa txãa wã'jytxi teçxi'tx. ");
INSERT INTO pbb_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Nawa teeçx ente' txãa puuple' uuk. Aça' angeleswe'sxa' jxũna u'jtx wẽt ũsnite Abrahan yakh ũskahn. Txãa e'su' ji'phsawa uuk, aça' txã'sa' pedaatx. ");
INSERT INTO pbb_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Aça' ji'phsa' uusaawe'sx ũsni ksxavxyte pxthaa yaaçxana ũsçxa', pesayçxa jxu'the uyku Lasaro yu' Abrahan yakh wẽt weçxana u'pte. ");
INSERT INTO pbb_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Txajũ' na'jĩnak sus we'we: Tata Abrahan, adxa's meen peeygãh. Seena' yuh wala pa'ga yuuna ũsthu naa ipx wala açxate. Aça' Lasaro's mkaah txajx kuse vxiççxáanawa yu'te tuupha'jçxa adx thunete tuupha'jya' yuukahn jĩte', ");
INSERT INTO pbb_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Abrahan pasçxa': Nçxi'k, miiyajkx. Idxa' nee ĩtxĩ u'juy yu', wala yuh wẽt weçxana fxi'zesa yu'g. Naapkaçxha' Lasaro yu' wala pxthaa yuuna nxuste fxi'zek. Nawa ãçxha' ayte wẽt weçxana ũsa', naapkaçxha' idxa' wala yuh pxthaa yuuna ũsgu. ");
INSERT INTO pbb_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Pxthaag we'we' nawa penxa thkafx wala txuhdena ũsa', aça' ayjxuwe'sx kxtee pesah wẽeçxawa ãjãmeetxna, sa' txajuwe'sxwa ayte pesajxa' ãjãmeetxna jĩte', ");
INSERT INTO pbb_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","çxhavxysáa pasçxa': Txã'wẽyã'the', Tata Abrahan, idxa'sthu pxthaa we'we', aça' Lasaro's meen kaah adx tata yatna, ");
INSERT INTO pbb_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","kxte' tahç nyakh ji'pthu txãawe'sxtxi pta'sxya' adx ayte nakwe wala pxthaa yuuna ũsthu kxtee yuukahmén jĩte', ");
INSERT INTO pbb_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Abrahan pasçxa': Txãawe'sxa' Moises vxite' Dxus yuwe pta'sxsawe'sx fxi'jnitx ji'phta' na' txãatx wẽsẽ'jetxna jĩte', ");
INSERT INTO pbb_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","çxhavxysáa pasçxa': Tata Abrahan, txã'wẽ yuhta'. Nawa maaçxáawa uusaawe'sx ksxavxyu ĩtxĩ yuuçxa txãawe'sxtxi' pta'sxya' u'jwaça', pkaltxi nvxihtçxa Dxus tasxte ki' sxaweduutxna jĩk. ");
INSERT INTO pbb_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Aça' Abrahan pasçxa': Moises vxite' Dxus yuwe pta'sxsa txãawe'sxtxi nwẽesẽ'jmeeyã'jçxa', makwe uusaawe'sx ksxavxyu ki' ĩtxĩ yuuçxa pta'sxtewa, kxul yuhna jĩk. ");
INSERT INTO pbb_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jesusa' na'wẽk kaapiya'j txãa yakh u'jusawe'sxtxi: —Nasatx pkalte kweete'jsa yu' bagaçxtewa nes yuutxna. Nawa pkalte kweete'jsa' wala yuh nxus kastigo knayuuna. ");
INSERT INTO pbb_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Aça' txãa pkalte kweete'jsa's skuutxh ũ'khni kweta's txhikhte tudçxa ĩkh wala dxiikhẽ wãatãhwaç yuuçxáa wejx ewna, naa le'çxkwesatx pkalte kweete'khamen. ");
INSERT INTO pbb_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Txã'wẽ yũuya'mée jxpa'yakx me'juwe. Meeçxawa idxa's wáa ãhmée yũuna iidx yakhthẽ'j aça' txã'sa' myu'kxpeh. Txajũ' ãhmée yũusa': Meen peltunaĩ jĩte', idxa' peltunãywa'j ji'phgu. ");
INSERT INTO pbb_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Makwe teenteçxáa sietepkaçx ãhmée yũuçxawa, kxaz usíi idxa's perdon pẽjxya' pa'the', idxa' peltunãywa'j ji'phgu jĩk. ");
INSERT INTO pbb_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Txajũ' Jesus yakh u'jusawe'sxa' na'wẽtx pẽjx: —Dxusçxáana wejx çxhãçxha yajkxna fxi'zekahn kwe'sxtxi' meen pu'çx jĩte', ");
INSERT INTO pbb_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Jesus pasçxa': —Dxusa' pu'çxhina sũhwa'ja's mostasa nxinx na'wẽkuẽçxáawa ji'phwaça', naa fxtũu tasxa's khubeteçxáa ĩkh walate me'j khẽeya' jĩte', txãa fxtũu tasxa' kxtey yuuna jĩk. ");
INSERT INTO pbb_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","I'kwe'sxa' teeçx selpisáa ji'phte', txã' mjĩi ehsu u'juçxa kusuçte pa'the': Myuh ayte kaçxçxa ũ'ya' ¿jĩma'kwe? ");
INSERT INTO pbb_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Txã'jĩmée wejxwa na'wẽ kajane'kwe: Adx ũ'wa'j ĩiçe'jçxa mesate pheu'jçxa mtxah. Sa' adx ũ'na jxã'the, idxa' ũ'wene'ga jĩne'kwe. ");
INSERT INTO pbb_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Patrona' ¿selpisa's weçxama'k txã'wẽ kxtey yuupa'ga? Weçxameena. ");
INSERT INTO pbb_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Txã'wẽy i'kwe'sxa' Dxusa's selpiwa'jsai'kwe na' makwe txajx jxkaahni's jxuka kxtey yuuçxawa, weçxaa jxthãaswa'jsameei'kwe jĩk. ");
INSERT INTO pbb_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Txajũ' Jesusa' Jerusalenna u'jweççxa', Samaria vxite' Galilea kiwesuk skhẽwna u'j. ");
INSERT INTO pbb_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Aça' teeçx çxhabte' diez piçthẽ'j wã'jy wee kazx ji'phsatx Jesusa's puutx uyya' kaseh. Nawa jxu'theçxáa yujuçxa, ");
INSERT INTO pbb_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","na'jĩnatx sus we'we: —Kwe'sxtxi meen peeygãh jĩte', ");
INSERT INTO pbb_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Jesusa' txãawe'sxtxi' na'wẽk jxkaah: —I'kwe'sx kakwetx sacerdotewe'sxtxi txwesya' me'jwe jĩna jxkaathe', txãawe'sxa' dxi'the u'jweçtxi yu', naapkaçxha' txãa wã'jy we' naa dudte jxuka wẽetku. ");
INSERT INTO pbb_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Aça' teeçxsa' katxhiyã'jçxa', dxi'juu sxawedku Dxusa's sus we'wena weçxana. ");
INSERT INTO pbb_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Sa' Jesus tasxte kũhçxa' peejxũkwek: Weçx ew yũug jĩna. Txãa piçthẽ'j yu' Samariajũwe'sxku yu'. ");
INSERT INTO pbb_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Aça' Jesusa' na'jĩk: —¿Diezsaíi jxuka katxhimeewá'nta? Vxite nwewesa yu' ¿mteeta yuu? ");
INSERT INTO pbb_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","¿Naa piçthẽ'j vxite ajũwe'sxçxáa wá' Dxusna weçxaya' sxawed? jĩçxa', ");
INSERT INTO pbb_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","txãa piçthẽ'ja's na'jĩk: —Kiiteçxa me'j. Idxa' katxhinig neeyũu, txã'wẽ Dxusa' nuykatxhina sũhçxane'ga kxtey nwẽesẽ'j naa pa'ga jĩk. ");
INSERT INTO pbb_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Txajũ' fxariseowe'sxa' Jesusa's na'jĩnatx pẽjx: —¿Bagaçx Dxusa' isa naa kiwete jxkaajakx? jĩte', Jesus pasçxa': —Dxus naa kiwete jxkaahni's yafxju yu' ãate ya'uymeena. ");
INSERT INTO pbb_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Dxusa' jxkaajxa' pa'jçxa: Ãçxha' ayte ũsa' meeçxawa kxtee ũsa' jĩna ya'we'wemeena. Txãa pa'gatey i'kwe'sxa' Dxus jxkaahni enteyã'j ũsi'kwe. ");
INSERT INTO pbb_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Txajũ' txãa yakh u'jusawe'sxtxi na'jĩnak yu'kxpeh: —I'kwe'sxa' Dxus Nçxi'k Nasa Yuusáa naa kiwete kĩini's dud uy wẽjẽne'kwe, nawa dud yu' uymeene'kwe. ");
INSERT INTO pbb_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","I'kwe'sxtxi' nasa yu' na'jĩwáatxna: Ayte ũsa' meeçxa' kxtee ũsa' jĩtewa, u'jmeene'kwe sa' nwẽesẽ'jwameene'kwe. ");
INSERT INTO pbb_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Kpi'sx kwehnewaççxáa ma'wẽ naa dudte majũwa jxuka vxyaakx, txã'wẽyçxáa yuuna Dxus Nçxi'k Nasa Yuusáa pa'jwa'j en ãhte'. ");
INSERT INTO pbb_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Nawa txãa en ãhmeyna, Dxus Nçxi'k Nasa Yuusa' wala pa'ga yuuna naa ensu nasa yaaçeni. ");
INSERT INTO pbb_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Noé ensuwa ma'wẽga yuu, txã'wẽyçxáa yuuna Dxus Nçxi'k Nasa Yuusáa pa'jwa'j ensuwa. ");
INSERT INTO pbb_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Noé ensu nasa' kĩh yuhwa peejxmée ũ'na ptamuuna vxite' txãawe'sx niisatx kaaimi'a'jnatx ũsu'. Nawa Noé barkote u'kaçpkaçxha', nus wala pa'jçxa ĩkh utate' jxuka uutx. ");
INSERT INTO pbb_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Lot ensuwa txã'wẽytxi yũuna ũsu', kĩh yuhwa peejxmée ũ'na, uuthasx vxitna, txweyna, yatwa txã'wẽytxi wala txahna ũsu'. ");
INSERT INTO pbb_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Nawa Lot Sodomajũ kasejeçpkaçxha', cielujũ asufxre behna kĩhçxa jxukaysatx kabku. ");
INSERT INTO pbb_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Txã'wẽyçxáa yuuna Dxus Nçxi'k Nasa Yuusáa vxyaa entewa. ");
INSERT INTO pbb_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Txãa ente' ẽeyatte wáa u'psa yuuna, nawa sa'jçxa kĩhçxáanawa dxiiju kutxi'jwa'j ençxáa yuhwa ji'phumeena. Sa' maaíi yu' çxhab ekaju wáa u'ju yuuna, nawa yatna sxawedwa'j ençxáa yuhwa uymeena. ");
INSERT INTO pbb_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Lot nyuuwa ma'wẽga yuu txã'sna miiyajkxwe. ");
INSERT INTO pbb_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Txãa ente' maa nasawa naa kiwete ĩtxĩ fxi'zeniçxá's yaakxsa', Dxus yakh ĩtxĩ fxi'zewa'j yu'sa' ivxiituna. Nawa maawa naa kiwete ĩtxĩ fxi'zeni's yaakxsame', Dxus yakh ĩtxĩ fxi'zewa'ja's ji'phuna. ");
INSERT INTO pbb_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Na'jĩ'th na': Txãa kuste' teeçx kamaga e'z wáa dehna ũs yuutxna. Nawa teeçxsa's pehna u'jni yuuna, naapkaçxha' vxite yu' neeyũuna. ");
INSERT INTO pbb_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Txã'wẽy e'z u'y wáa kxteeçxah ũ'khna ũs yuutxna. Nawa teeçxsa's jxũna u'jni yuuna, naapkaçxha' vxite yu' neeyũuna. ");
INSERT INTO pbb_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Meeçxa' e'z piçthẽ'j wáa kxteeçxah mjĩina ũs yuutxna. Nawa teeçxsa's jxũna u'jni yuuna, naapkaçxha' vxite yu' neeyũuna jĩte', ");
INSERT INTO pbb_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Jesus yakh u'jusawe'sxa' na'wẽtx pẽjx: —¿Mtee txã'wẽ yuukx? jĩtx. Aça' Jesus pasçxa': —Kakwe kha'tx mkaa uuna ũstewa, mẽewẽjxa' ãate pkhaakhetxna jĩk. ");
INSERT INTO pbb_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Dxusa's peçxkanamée bagaçxtewa txãa yakh puutx we'wena nes yuukahn naa ejemplo'sku pta'sx Jesusa': ");
INSERT INTO pbb_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","—Teeçx çxhabte teeçx khuẽs u'pu'k, Dxusa's yaakxsamée sa' nasatxwa peeygãja'çme'. ");
INSERT INTO pbb_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Txãa çxhabte' teeçx u'y vxiudak u'pu', sa' khuẽs tasxte pãatxhĩ'khya' u'jna nesku yu': Ũ'kwe's meen nwe'we, açesa wala pkxu'tx jĩna. ");
INSERT INTO pbb_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Maazkuẽe uswa pa'thewa, txãa khuẽsa' pu'çxme', nawa na'wẽk yajkx: Dxusnawa yaakiçmeeth sa' nasa maa yuhtxwa peeygãasameeth. ");
INSERT INTO pbb_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Nawa naa vxiuda' wala kuçx tahtatey pa'ja'k aça' pu'çxhi'nja peena yu' pa'khamén jĩk. ");
INSERT INTO pbb_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","—Khuẽs ewmeesa yuhwa txã'wẽk pu'çxya' yajkx jĩk Jesusa'. ");
INSERT INTO pbb_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Dxusa' ¿txã'wẽyçxáa pu'çxmeema'k txajx txhitxhnisatxi'? Txã'wẽ kus ma'k yuu en ma'k yuu nawa pxthaa we'wena nes yuute' pu'çxya' jxthẽeyuumeena. ");
INSERT INTO pbb_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Na'jĩ'th na': Dxus Nçxi'k Nasa Yuusáa naa kiwete sxawedna kĩi entewa ¿txã'wẽ Dxus yakh pu'vxitumée neewe'wesa ũsma'tx yuu? jĩk. ");
INSERT INTO pbb_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Jesusa' na'wẽk vxite ejemplo pta'sx txã'wẽ maaíi yu' wala ewsatha'w sũhna vxite yuutxi' ahçena fxi'zesawe'sxtxi: ");
INSERT INTO pbb_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","—E'z piçthẽ'jtx dxuus yatte Dxus yakh weçxana puutx we'weya' u'ka. Teeçxsa' fxariseo', aça' vxite' gobierno jĩi vxyu pkhakhsak yu'. ");
INSERT INTO pbb_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Fxariseo yu' yujuçxa na'jĩnak Dxus yakh puutx we'we': Dxus, idxa's wala weçxa'th, adxa' vxite nasa na'wẽmeeth. Txãawe'sxa' pesweeta', ewmée kazxsata'. Sa' nyu ji'phçxawa vxite yakh pkal yuusata'. Aça' adxa' txã'wẽsameeth. Naa piçthẽ'j ayte ũsa' gobierno jĩi vxyu pkhakhsa txã'wẽsaçxáa yuhwa meeth. ");
INSERT INTO pbb_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Sa' ki'sute e'z us yũuna'th. Adx knayni kĩjkĩhnawa diesmo dukhe'th idxa's jĩk. ");
INSERT INTO pbb_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Naapkaçxha' gobierno jĩi vxyu pkhakhsa yu' jxu'theçxáa yujuçxa cielute yuhwa pagaymée naasáa txajx peçxuteçxáak iikakana Dxusa's na'jĩ': Dxus, adxa's meen peeygãh. Wala yuuwesath jĩnaçxáak we'we'. ");
INSERT INTO pbb_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Na'jĩ'th na': Gobierno jĩi vxyu pkhakhsa we'weni's Dxusa' pasne'. Nawa fxariseo yu' pasnimeene' yatna sxawedna u'j. Maawa iiwejçx iiwejçx yajkxçxa we'wesa', jxthaakwe ãhmeekwesa yuuna. Nawa maawa ãhmeekwesa na'wẽ yajkxna we'wesa' iiwejçx yaakxsate jxthaakwe ewsa yuuna jĩk. ");
INSERT INTO pbb_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Txajũ' nasa' Jesus tasxte txãawe'sx luuçxkuẽtx nuypa'jtx Dxus kusete neewe'wekahn. Aça' Jesus yakh u'jusawe'sxa' ũusçxa we'wetx luuçxkuẽtx nuypa'jsatx. ");
INSERT INTO pbb_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Nawa Jesusa' txãa yakh u'jusawe'sxtxi pa'yaçxa na'jĩk: —Luuçxkuẽ adx tasxte yuhte', kuçx yupnuwe, txãa pa'gatey Dxus jxkaahna ũsnisa' naa luuçxkuẽwe'sx na'wẽsa jĩi íiçxá'. ");
INSERT INTO pbb_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Isath we'we', maawa luuçxkuẽ na'wẽ Dxus jxkaahwa'j ena's wa'lmée jxpa'gameeçxa yu', bagaçxte yuhwa Dxus tasxte u'kameetxna jĩk. ");
INSERT INTO pbb_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Txajũ' teeçx piçtakx npiiçthẽ'jsa na'wẽk paapẽjx Jesusa's: —Idxa' wala ewgu kĩhsuwa jxuka, txãa pa'ga na'wẽth paapẽyi': ¿Ma'wẽ yũuçxa pçumée ĩtxĩ fxi'zewa'ja's ji'phuki'th? jĩte', ");
INSERT INTO pbb_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Jesusa' na'jĩk: —¿Kĩh yuupa'gaga adxa's ewsa jĩ'? Naa kiwete' teeçxçxáa yuhwa ewsa yu' meeta'? naasáa Dxus yuuçxáa ewsa ũsa'. ");
INSERT INTO pbb_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Pçumée ĩtxĩ fxi'zewa'ja's ji'phu wẽeçxa', Dxus jxkaahnitxi' jiig txãatxi' kxtey myuu. Txã' naata': Ptamsayã'ja' vxite yakh pkal yuuwa'jme'. Nasa ikhwa'jme'. Pesweewa'jme'. Vxitetx ĩsxĩina nuywe'wewa'jme'. Neywe'sxtxi peeygãhna ewçxáa yũuna fxi'zewa'ja' jĩte', ");
INSERT INTO pbb_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","txãa piçtakx pasçxa': —Txãatxi' le'çxkuẽjũjx jxuka kxtey yuunath waláa jĩk. ");
INSERT INTO pbb_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Aça' Jesus wẽsẽ'jçxa' na'wẽk jxkaah: —Txã'wẽtewa, nee peeji'. Iidx ji'phuni's jxuka txweyçxa, puuplesatx peesune'ga. Txã'wẽ yũuçxa', cielute ji'phsa yuune'ga. Txã'wẽ yũuçxa adx yakh myuh jĩte', ");
INSERT INTO pbb_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","txãa piçtakxa' wala nxusna neeyũuk, wala ji'phsa yu'k txãapa'ga. ");
INSERT INTO pbb_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Txã'wẽ nxuste', Jesusa' na'jĩnak we'we: —Maawa wala ji'phsa yakha', wala yuh thẽya' Dxus jxkaahna ũsnite u'kawa'ja'. ");
INSERT INTO pbb_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Aça' txã'wẽ thẽysa's yajkxte yu', kamelxo yuhwa thẽymée wáa yũz kafxga u'kaya' ãjatxna. ");
INSERT INTO pbb_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Txã'jĩte', na'wẽtx we'we: —Txã'wẽ thẽyte', ¿kim ewte neeyũuya' ãjãkx? jĩ'tx. ");
INSERT INTO pbb_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Aça' Jesusa' na'jĩk: —I'kwe'sxçxáa yu' ãjãmeene'kwe. Nawa Dxus yakh yu', kĩh yuhwa thẽysa meea' jĩte', ");
INSERT INTO pbb_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Pedro' na'wẽk we'we: —Kwe'sxa' idx yakh yujxa' kwe'sx ji'phuni's jxuka nvxihttha'w jĩk. ");
INSERT INTO pbb_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Aça' Jesus pasçxa' na'jĩk: —Isath we'we': Dxus jxkaahni's nwẽesẽ'jya' maawa yat, neywe'sx, nyakhwe'sx, nyu, nçxi'kwe'sx txã'wẽsatx nvxihtçxa', ");
INSERT INTO pbb_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","naa kiwete nee ũsíi txãa nvxiitnisate jxthaakwe jxpa'gatxna, sa' vxite kiwete' pçumée ĩtxĩ fxi'zewa'ja's ji'phutxna jĩk. ");
INSERT INTO pbb_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Jesusa' txãa yakh u'jusawe'sx docesatx fxiite pa'yaçxa na'wẽk pta'sx: —Ãçxha' Jerusalente pa'jya' u'jweçtha'w, aça' Dxus yuwe pta'sxsawe'sxa' fxi'jtx Dxus Nçxi'k Nasa Yuusá's ma'wẽ yũuwa'thewa txã' jxuka kxtey yuuna. ");
INSERT INTO pbb_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Dxus Nçxi'ka's vxite nasatx dukh ya'wata', aça' txãawe'sxa' npeevxysxijkana wẽesxuuna fxne'sx avxythethna yũuya'wata'. ");
INSERT INTO pbb_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Sa' wala peçxujkwena yuuçxa ikhetxna. Nawa tekh ente' ki' ĩtxĩ yuuna jĩtewa, ");
INSERT INTO pbb_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","txãa yakh u'jusawe'sxa' weh yuhwa jiyumeeta' sa' txã'wẽ kxtey yuutxna sũjũ'çwameeta'. ");
INSERT INTO pbb_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Txajũ' Jesusa' Jeriko çxhabte pa'jaçte', teeçx piçthẽ'j uysaméek dxi'j pukate kaçxçxa lmusxnu pẽjxna u'pu'. ");
INSERT INTO pbb_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Sa' nasa wala skhẽwna susuçte wẽsẽ'jçxa', pẽjxku: —¿Kĩh yuuçna? jĩna. ");
INSERT INTO pbb_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Aça' nasa pasçxa': —Jesus Nasarethuwe'sx aysu skhẽuuça' jĩte', ");
INSERT INTO pbb_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","uysame' na'jĩnak sus we'we: —¡Jesus, Davxid ji'j, adxa's meen peeygãh! jĩna pxthaa we'wete', ");
INSERT INTO pbb_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","nasa yaçte u'jsawe'sx yu': —Sxuuna' myuu jĩnatx wẽesxu we'we. Nawa txãa yu' jweeíiçxáak sus we'we: —¡Davxid ji'j, adxa's meen peeygãh! jĩna. ");
INSERT INTO pbb_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Txajũ' Jesusa' nee yujuçxa pe'jya' kaakh. Sa' utxaana kũhte', na'jĩk: ");
INSERT INTO pbb_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","—¿Kĩhga yũu jxthãasu'? jĩte': —Adxa' uyya' ãjã'çmeeth, txãasath uy wẽjẽ' jĩk. ");
INSERT INTO pbb_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Aça' Jesus we'weçxa': —Kaauyu'juna sũhçxane'ga adxa's pi'kx, txãa pa'ga ãçxha' uyna mneeyũu jĩçpkaçxha', ");
INSERT INTO pbb_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","txãa dudtey uyya' ãjãk, sa' Dxusna wala weçxana Jesus e'stey u'kh. Txã'wẽ uyya' ãjãte nasa uyçxa', txãawe'sxwa txã'wẽytxi Dxusa's wala weçxa. ");
INSERT INTO pbb_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Txajũ' Jesusa' Jeriko çxhabte pa'jçxa', txãa çxhabsu skhẽuuçku yu'. ");
INSERT INTO pbb_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Aça' kxte' teeçx piçthẽ'j wala ji'phsa Zakeo yaasesak ũsu'. Txãa yu' gobierno jĩi vxyu pkhakhsa npiiçthẽ'jsak yu'. ");
INSERT INTO pbb_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Txãa Zakeo' Jesus kimtewa jiyuya' puutx uy wẽeçxawa, nasaa wala ksxavxyte' ãjãme', txãa yu' le'çxkuẽek yu' naa pa'ga. ");
INSERT INTO pbb_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Sa' yaçte wuwuuçxa, sikómoro fxtũu tasxtek tejka Jesusa's uyya'. ");
INSERT INTO pbb_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Aça' Jesusa' kxuy uykhẽuuççxa', fxtũu tasxte pagayçxa Zakeo's we'wek: —Dudçxáa txajũ miisa'j, adxa' iidx yatte ãçxhíi pa'jwa'j ji'pthu jĩte', ");
INSERT INTO pbb_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Zakeo' dudçxáa sa'jçxa, Jesusa's weçxanak txajx yatte jxpa'ga. ");
INSERT INTO pbb_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Txã'wẽ yũute' nasa jxukaysa açewe'wetx: Jesusa' txãa piçthẽ'j pkalsa yattek pa'jya' u'j jĩna. ");
INSERT INTO pbb_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Txajũ' Zakeo' yujuçxa na'jĩnak we'we: —Adx ji'phuni's puupxãhn txuhdeçxa puupletx peesu'nja, sa' maaíitxi's ĩsxĩiçxa jxthaakwe wá'ntka vxyu kusa'j nawa kusa'jnite pahz us jxthaakwe kaasxwedu'ju'nja jĩte', ");
INSERT INTO pbb_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Jesusa' na'jĩk: —Naa piçthẽ'ja' Abrahan ji'kh yuu naa pa'ga naa yattewe'sx ewte neeyũuwa'j en pa'kh ãçxha'. ");
INSERT INTO pbb_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Dxus Nçxi'k Nasa Yuusa' txã'wẽ vxituna ũssatx pakweçxa ewte nvxiht-ya' íiçxáath kĩh jĩk. ");
INSERT INTO pbb_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Jesus we'weni's wẽsẽ'jsa yu', naa sũhnatx ũsu': Jesusa' Jerusalente pa'jaça' na' ãçxha' txãa jxkaahsa yuuna sũhnatx ũsu'. ");
INSERT INTO pbb_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Naa pa'ga na'wẽk kwentu'jna pta'sx: —Teeçx piçthẽ'j jxtuhthesa jxu'j kiwen u'kh, kxtee pa'jçxa jxkaahsa yuuçxa ki' sxawedxa'. ");
INSERT INTO pbb_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Nawa u'jmey, diez selpisaatx pa'yaçxa, kxazíitx txakweçxaçxáak vxyu ũsçxa na'jĩna neewe'we: Adx sxawedna pa'phkaçx naa vxyu yakh mjĩine'kwe nuypehnaya'. Txã'jĩçxak jxkaahsa yuuya' jxu'j kiwen u'j. ");
INSERT INTO pbb_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Nawa txajx kiwete nasa' jxkaahsa ki'pni's wa'lçxa, na'jĩnatx pãatxhĩ'khya' kaah txajx e'stey: Naa piçthẽ'j kwe'sxtxi jxkaahni's peejxmeetha'w jĩtewa, ");
INSERT INTO pbb_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","pejka jxkaahsa yuuçxa ki' sxawedku txajx kiweníi. Sa' pa'jçxa' selpisaatx vxyu ũsne' txãatx pa'yak, nasa iisa maz nuypehnatewa jiyuya'. ");
INSERT INTO pbb_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Aça' nyafxtewe'sx kũhçxa' na'jĩk: Iidx vxyu ũsgu txãate diezthu jxthaakwe nuypehna jĩte', ");
INSERT INTO pbb_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","jxkaahsa pasçxa': Wala ew selpiig. Txã'wẽ walameekuẽsa'swa ew jxpe'pha'ga, diez çxhabte jxkaahwa'jsa ne'jwe'sx ki'pu'nja jĩk. ");
INSERT INTO pbb_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Txajũ' vxitewa utxaaçxa na'jĩk: Iidx vxyu ũsgu txãate tahçthu jxthaakwe nuypehna jĩte', ");
INSERT INTO pbb_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","jxkaahsa pasçxa': Idxa' tahç çxhabte jxkaahwa'jsa ne'jwe'sx yuune'ga jĩk. ");
INSERT INTO pbb_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Txajũ' tekhtewe'sxwa utxaaçxa na'jĩk: Iidx vxyu ũsgu txã'sa' panxwelote yapçxa jxaawthu. Txã' ayga ũsa'. ");
INSERT INTO pbb_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Idxa' wala juuna' yu'g, txã'wẽ mjĩimeeçxawa vxyu pẽyi'g sa' iidx uuthasxmeetewa kxtee u'kaçxa jxuka pkhakhe'g. Aça' ũukhçxa iidx vxyu'sa' kmãaji'jmeeth jĩte', ");
INSERT INTO pbb_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","jxkaahsa pasçxa': Idxa' seelpimeeg. Iidx yuweteyçxáa ewmeete neeyũuçgu. Adxa' juuna'saçxa' mjĩimeeçxawa vxyu pẽjxna adx uuthasxmeetewa pkhakhsatewa jiiçxa', ");
INSERT INTO pbb_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","¿kĩh yũutega adx vxyu'sa' bankoga jxaawmée? pehnate adx sxawedna pa'jçxa' jxthaakwe kutxi'khan jĩk. ");
INSERT INTO pbb_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Sa' txãa jxkaahsa' na'jĩnak we'we kxtee ũssatx: Txãa vxyu's kusa'jçxa diez vxyu ji'phsa's meswe jĩte', ");
INSERT INTO pbb_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","txãawe'sx pasçxa': Txã' vxyu walayã'j ji'pha', aça' ¿ma'wẽ txã'síiçxáa ũsukxtha'w? jĩtewa, ");
INSERT INTO pbb_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","jxkaahsa pasçxa na'jĩk: Maawa jxpa'yakx jxpe'jçxa nuypenasa's jxthaakwe ũswa'j yuuna. Nawa jxpe'jya' ãjãmeeçxa nuypenasame's jxuka kusa'jwa'j yuuna, le'çxkuẽçxáa ji'phtewa. ");
INSERT INTO pbb_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Sa' adxa's ahçeçxa jxkaahsa yuukahmén pãatxhĩ'khsawe'sxtxi' ayte pe'jna kũhçxa adx uyna ũste miikhwe jĩk. ");
INSERT INTO pbb_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Txãa ejemplo's pta'sxna jxã'jçxa', Jerusalente pa'jya' u'kh. ");
INSERT INTO pbb_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Sa' Betfxagé vxite' Betania çxhab ũsu'tx Oliwos vxiç utxaga kxtee pa'jya'çxáa txãa yakh u'jusa e'zsatx kaakh ");
INSERT INTO pbb_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","na'jĩna: —Naaga çxhab ũsa' kxtee me'jwe. Sa' kxtee pa'jaççxa', teeçx buçxukuẽ uyuune'kwe kim yuhwa a'jnimeesa tudni ũsna. Txã'sa' jxũkhwedeçxa jxũna yuweene'kwe. ");
INSERT INTO pbb_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Jxũna yuhte', maaíi yu' pẽyiwáatxna aça': Kwe'sxtxi jxpe'jsak nikxya' kaah jĩne'kwe. ");
INSERT INTO pbb_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Aça' txã'jĩte' u'jçxa', Jesus ma'wẽne' we'we txã'wẽy uytxi. ");
INSERT INTO pbb_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Txajũ' buçxu's jxũkhwedeçte', namuwe'sxa' pẽjxtxi: —¿Kĩjxa' buçxu's jxũkhwedeçkwe? jĩte', ");
INSERT INTO pbb_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","txãawe'sx pasçxa': —Kwe'sxtxi jxpe'jsak nikxya' kaah jĩtx. ");
INSERT INTO pbb_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Sa' Jesus tasxte jxũna kũhçxa', txãawe'sx atxhtxi pusçxa Jesusa's ka'ja'jtx. ");
INSERT INTO pbb_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Txajũ' Jesus u'jwa'j dxi'jsu yaçtetx txãawe'sx atxhtxi pusna u'jwe'. ");
INSERT INTO pbb_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Sa' Oliwos vxiç e'skhẽ u'jweçpkaçxha', Jesus yakh yuusa nasa' Dxusa's wala weçxana weyya' takhtxi txã'wẽ Jesusa' kĩjkĩhwa ew yũuna u'juni's uyçxa. ");
INSERT INTO pbb_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Sa' na'jĩnatx weyi': —¡Dxus kaahni wala yuh ew jxkaahwa'jsa yuja'! ¡Dxus cielutewe'sxa's weçxaaga wala ew yũupa'ga! jĩ'tx. ");
INSERT INTO pbb_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Txajũ' nasaa ksxavxyte yuusa fxariseowe'sxa' na'jĩtx: —Iidx e'ste kuçx susna yuusatx mwe'we, sxuuna' yuukahn jĩte', ");
INSERT INTO pbb_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Jesus pasçxa': —Makwe txãawe'sx yu' sxuuna' yuutewa, kweta' Dxusa's tuuthe'jetxna jĩk. ");
INSERT INTO pbb_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Txajũ' Jerusalente utxa pa'jçxa', çxhaba's thegçxa ũ'nek ");
INSERT INTO pbb_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","na'jĩna: —I'kwe'sxa' wẽt kfxi'ze'jwa'jsa's jiyuçxa naa ente jxpa'gawaça', wala yuh ewna. Nawa i'kwe'sxa' jiimée ũsi'kwe na' jxpa'gameene'kwe. ");
INSERT INTO pbb_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Naa pa'ga i'kwe'sxtxi' nxuswa'j en pa'jana, aça' txãa ente' çxhaba's jxuka yupna ktadxiiçxa ");
INSERT INTO pbb_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","çxhaba's kĩh yuhwa nvxihtmée jxuka suwuutxna kxtee ũssatx ikhna. Sa' teeçx kwetçxáa yuhwa kẽese'jnimée yu' neeyũumeena, i'kwe'sx ksxavxyte Dxus kĩhtewa, jxpa'gameei'kwe naa pa'ga jĩk. ");
INSERT INTO pbb_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Txajũ' Jesusa' dxuus yatte u'kaçxa kxtee txweyna ũssatx jxuka eka kasxisxku ");
INSERT INTO pbb_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","na'jĩna: —Dxus librute na'wẽ fxi'jni': Adx yata' Dxus yakh puutx we'wena ũswa'j yatçxá' jĩna fxi'jni'. Nawa i'kwe'sx yu' peswée pkhaakhena ũsni kafx na'wẽçxáa vxitçxa ji'phi'kwe jĩk. ");
INSERT INTO pbb_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Jesusa' een isak dxuus yatte u'kaçxa kaapiya'ja'. Naapkaçxha' sacerdote npiiçthẽ'jwe'sx vxite' Dxus leya's kaapiya'jsawe'sx vxite' çxhabte ne'jwe'sx txãawe'sx yu': ¿Ma'wẽ yũuçxa ikhekxtha'w? jĩnatx puutx we'wena ũsu'. ");
INSERT INTO pbb_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Nawa ikhya' yu' ãjã'çmeeta', nasa jxukaysa Jesus ju'guçxaçxáatx ũsu' naa pa'ga. ");
INSERT INTO pbb_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Teeçx ente' Jesusa' dxuus yatte Dxus yuwe ewte nvxiitwa'jsa's pta'sxna ũste', sacerdote npiiçthẽ'j vxite' Dxus leya's kaapiya'jsa vxite' judiu nthẽ'jsa txãawe'sx pa'jçxa' ");
INSERT INTO pbb_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","na'jĩnatx pẽjx: —Idxa' ¿kim jxkaathega dxuus yatte txã'wẽ juuna' yũu? Kim jxkaathe txã'wẽ yũuçxawa mpeeta'sx jĩte', ");
INSERT INTO pbb_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Jesusa' na'wẽk pas: —Adxwa i'kwe'sxtxi' pẽjx ya'wath aça' txã'sa' mpaaswe. ");
INSERT INTO pbb_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Juan Bautista's ¿kimga jxkaah yu'te bautisãykahn? ¿Dxus wá' jxkaah meeçxa' naa kiwete piçthẽ'j jxkaahni wá' yu'? jĩte', ");
INSERT INTO pbb_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","txãawe'sx pwe'sx na'jĩnatx puutx we'we': —¿Ma'jĩna pasukxtha'w? Dxusne' jxkaah jĩwaçwa, txã'wẽ Dxus jxkaathe' ¿mjĩya'kwe Juan pta'sxni's jxpa'gamée? jĩna. ");
INSERT INTO pbb_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Aça' naa kiwete nasane'ta jxkaah jĩte', kwe'sxtxi kwet wãatatahçxa ikhetxna, nasa' jxukaysa Juana's ew jiita' Dxus yuwe pta'sxsatewa. Txãasa kwe'sxtxi' txã'wẽ yũutxna jĩ'tx. ");
INSERT INTO pbb_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Txajũ' Jesusa's pasçxa': —Juana's kimne' jxkaah bautisãykahn nawa jiimeetha'w jĩte', ");
INSERT INTO pbb_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Jesus pasçxa': —Adxwa kim jxkaathe txã'wẽ yũuçxawa pta'sxme'nja jĩk. ");
INSERT INTO pbb_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Txajũ' Jesusa' naa ejemplo'sku pta'sx: —Teeçx piçthẽ'ja' txajx kiwete jxuka uwa uhçxa mjĩisatx ew neewe'weçxa wala txaçx u'kh. ");
INSERT INTO pbb_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Sa' uwa thẽ'jeçte', kiwe namu' teeçx selpisa's kaakh kiweepa'ga pẽjxya'. Nawa kiwe's mjĩisawe'sxa' txãa selpisa's pãpãçxa kĩh yuhwa dukhmée kaahtx. ");
INSERT INTO pbb_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Aça' kiwe namu' vxite selpisa's ki' kaakh. Nawa txã'snawa txã'wẽy iiwẽesxuna pãpãçxa kĩh yuhwa dukhmée neeutx. ");
INSERT INTO pbb_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Txajũ' kiwe namu' ki' vxite selpisa's kaakh. Nawa kiwe's mjĩisawe'sxa' txã'snawa kpã'vxitçxa dukhmée neeutx. ");
INSERT INTO pbb_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Txã'wẽ yũute', nmehte' kiwe namu' na'jĩk: Ãçxha' ¿kĩh yũuki'th? Meeçxa' adx nçxi'k wedxnisa's kaja'nja. Aça' txã'sa' ũukhçxa txã'wẽ yũumeewáatxna jĩçxak kaah. ");
INSERT INTO pbb_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Aça' mjĩisawe'sxa' kiwe namu nçxi'ka's uyçxa', txãawe'sx pwe'sx na'jĩnatx puutx we'we: Ney uute', kiwe's naathẽ'j iiyamuwa'jsana. Aça' ikhega, khĩçxa kiwe's kwe'sx iiyamu'nja'w jĩçxa ");
INSERT INTO pbb_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","eka kutxi'jçxa ikhtxi jĩk. Txajũ' Jesusa' txã'wẽ pta'sxçxa' pẽjxku: —Txã'wẽ yũute', kiwe namu' txãa mjĩisawe'sxtxi' ¿kĩh yũukx? ");
INSERT INTO pbb_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Txã'wẽ yũupa'ga kiwe namu' txãa mjĩisawe'sxtxi' jxuka ikhçxa kiwe's vxitetx ũsuna jĩte', txã'wẽ pta'sxni's wẽsẽ'jçxa na'jĩtx: —Dxusa' kxtee pa'j yu' wedxmeena jĩ'tx. ");
INSERT INTO pbb_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Txã'wẽ paste', Jesusa' txãawe'sx dxi'psu thegçxa na'wẽk pta'sx: —Txã'wẽ yuune'jmeete', ¿kĩjxa'çxáaki'k Dxus librute na'wẽ we'we'?: Yat txaahsawe'sxa': Naa kweta' selpime' jĩçxa wãatãhtx, Nawa txãa íik yat makwesanawa çxhãçxha neewewa'jsa yuuna pa'j. ");
INSERT INTO pbb_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Aça' maawa txãa kwette iikasa' jxuka çxkateteetxna. Meeçxawa txãa kwet nasaa kajkwekhẽ weteçxa', jxuka ku'çxina jĩna fxi'jni'. ");
INSERT INTO pbb_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Txajũ' sacerdote npiiçthẽ'j vxite' ley kaapiya'jsawe'sxa' jiyutx txãa ejemplo' txãawe'sxtxi we'wenitewa. Sa' ũusaçxaçxa txãa dudtey Jesusa's tud wẽetx. Nawa Jesus ju'gusa nasa wala kuh ũste', ũukhçxa kĩhwa yũumeeta'. ");
INSERT INTO pbb_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Nawa kĩhteçxáawa ewmeete nvxiht-ya' sũhçxa thegsa kaahtx. Aça' txãawe'sxa' Jesusa's ew paapẽysa na'wẽ yuh we'wena utxaatx, jxkaahsa's ewmée we'wetewa jiyuçxa' ne'jwe'sxa's pãatxhĩ'khya' sũhçxa. ");
INSERT INTO pbb_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Sa' na'jĩnatx paapẽjx: —Kwe'sxa' idxa's jiitha'w. Idxa' isasaçxá'sgu pta'sxi', Dxus tasxte pa'jwa'j dxi'ja's kaapiya'jna. Sa' nasaa jxkaahna yu'kxpehnitx nwẽese'je'çmeeg, txãa pa'gatey idxa' nasa ewsa na'wẽ thegsatx jiyumey ju'gu yu'çmeeg. ");
INSERT INTO pbb_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Ãçxha' na'wẽtha'w jiyu wẽjẽ': Jxkaahsa Cesara's vxyu dukhte ¿ewmanx? meeçxa' dukhmeete ¿ewmanx? jĩte', ");
INSERT INTO pbb_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","ewmée yajkxçxa txã'wẽ pẽjxna ũstewa Jesusa' jiyuçxa na'jĩk: —¿Kĩjxa'kwe adxa's ewmeete nvxiit wẽjẽ'? jĩçxa ");
INSERT INTO pbb_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","txãawe'sxtxi' teeçx vxyu musx pẽjxku. Sa': —Naa vxyu' ¿kiim dxi'pa's ji'phna, sa' kiim yase's fxi'jnina? jĩte', txãawe'sx pasçxa': —Cesar dxi'pa's ji'pha' sa' txajx yase's fxi'jni' jĩtx. ");
INSERT INTO pbb_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Aça' Jesusa' na'wẽk jxkaah: —Cesar jĩ'sa' Cesara's dukhwa'ja'. Sa' Dxus jĩ'sa' Dxusna dukhwa'ja' jĩk. ");
INSERT INTO pbb_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Txã'wẽ nasaa dxi'pte isasaçxáana paste', Jesusa's ewmée vxit-ya' ãjãmeeçxa, kuh yajkxna sxuuna'tx neeyũu. ");
INSERT INTO pbb_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Txajũ' saduceowe'sx maaíi yu' Jesus tasxte paapẽjxya' pa'jtx. Nasa' uuyã'jçxa' peena yu' ĩtxĩ yuumeetxna sũhsatx yu' txãa saduceowe'sxa', txãasatx na'wẽ pẽjx: ");
INSERT INTO pbb_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","—Moisesa' na'jĩnak fxi'jçxa nvxiht: Maa piçthẽ'jwa luuçx ji'phumey nyu's nvxihtçxa uute', uusáa nyakha' txãa u'ya's iiyuuna, aça' txãate luuçxa' uusáa nçxi'k na'wẽ neeyũuna jĩnak fxi'j. ");
INSERT INTO pbb_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Aça' kwe'sxa' jiitha'w siete piçthẽ'j pxakhtxi u'pu', sa' nyakh nthẽ'jsa' iiyuuçxawa luuçx ji'phumey uuk. ");
INSERT INTO pbb_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Aça' nyakh e'stewe'sxku iiyuu txãa u'ya'síiçxáa. Nawa txãawa luuçx ji'phumey uuk. ");
INSERT INTO pbb_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Txajũ' nyakh tekhtewe'sxwa txãa u'ya's íiçxáak iiyuu. Txãawa luuçx ji'phumey uuk. Txã'wẽçxaçxáatx sietesay txãa u'yçxaçxá's iiyuuna jxã'j. Nawa maa yuhwa luuçx ji'phumey uutx. ");
INSERT INTO pbb_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Aça' nmehte' txãa u'ywa uuk. ");
INSERT INTO pbb_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Aça' uusaawe'sx ki' ĩtxĩ yuu ente', txãa u'ya' ¿maa yakh isa nyu yuuwa'jsakx? jĩte', ");
INSERT INTO pbb_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Jesus pasçxa': —Naa kiwete nasa' ptamuuna txãawe'sx luuçxtxiwa kaaptamu'ju'tx. ");
INSERT INTO pbb_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Nawa vxite kiwete pçumée ĩtxĩ fxi'zewa'the pa'jya' ãjãsa' ki' ĩtxĩ yuuçxa' txãawe'sxa' ptamuwa'jsameeta', sa' txãawe'sx luuçxtxiwa kaaptamu'jna ũswa'jsameeta', ");
INSERT INTO pbb_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","txãa pa'gatey txãawe'sxa' Dxus angeleswe'sx na'wẽsa yã'tha', sa' Dxus luuçx yã'tha' na' ĩtxĩ yuuyã'jçxa' peena yu' uuwa'jsameeta'. ");
INSERT INTO pbb_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Txã'wẽ uusaawe'sxa' ki' ĩtxĩ yuuwa'jsate íiçxáak Moisesíiwa jiyukahn na'wẽ fxi'jçxa nvxiht txajx librute. Kxteea' Dxusa' çhũçh yu'kh behna ũsni pxãjũ we'weçxa': Abrahan, Isaak, Jakob txãawe'sx Dxusthu jĩk. ");
INSERT INTO pbb_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Dxusa' uusaawe'sx Dxusme', naasáa ĩtxĩsawe'sx Dxusçxá'. Dxus tasxte' maa yuhwa uumée ĩtxĩ ũsta' jĩnak pta'sx. ");
INSERT INTO pbb_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Txajũ' Dxus leya's kaapiya'jsawe'sx we'weçxa': —Wala ew pta'sxgu jĩçxa, ");
INSERT INTO pbb_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","peena yu' kĩhwa jwee yu' pẽjxmeeta'. ");
INSERT INTO pbb_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Txajũ' Jesusa' na'wẽk pẽjx: —¿Ma'wẽteta Kristo' Davxid nçxi'ka' jĩna we'we' nasa'? ");
INSERT INTO pbb_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Naapkaçxha' Salmos librute Davxid we'weçxa yu' na'jĩ'k: Adxna jxpe'jsa Kristo's Dxusa' na'jĩk: Adx pukate paçu ju'gte mkaaçx, ");
INSERT INTO pbb_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Idxna açesatx idxçxaçxáana nwẽese'jwa'ja's vxitna jxã'phkaçx jĩk. ");
INSERT INTO pbb_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Davxida' Kristo's we'weçxa': Adxna jxpe'jsa jĩk, aça' Kristo' ¿ma'wẽ yuuçxa Davxid nçxi'k yuukx? ");
INSERT INTO pbb_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Nasa jxukaysa wẽsẽ'jna ũssa ksxavxyte Jesusa' txãa yakh u'jusawe'sxtxi na'jĩnak we'we: ");
INSERT INTO pbb_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","—Dxus leya's kaapiya'jsawe'sxtxi' mpa'yajkxwe. Txãawe'sxa' ropa jxu'jsa athçxa plaasasu msuuwa weçxa jxthãasnatx pekũjũ'. Sa' judiuwe'sx pkhaakhenisuwa kaçxní wejx zhiçxkwe ewsaçxáanatx pakwé'. Maa yat-su sã'jĩya' pi'kxtewa, txã'wẽytxi kaçxwa'j ewsaçxáana pakwé'. ");
INSERT INTO pbb_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Sa' vxiudawe'sx yattxiwa kusa'ja'tx, kĩjkĩh ji'phuni'swa jxuka. Nawa ewsata' sũjkahn wala jxu'j lisa'tx. Txã'wẽ yũupa'ga txãawe'sxa' wejx jxthaakwe Dxus kastigãyni yuutxna jĩnak pta'sx. ");
INSERT INTO pbb_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Wala ji'phsawe'sx dxuus yatte ofxreda wala ãsxiçtek uy Jesusa'. ");
INSERT INTO pbb_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Txã'wẽy teeçx vxiuda puuplesawa kũhçxa', e'z vxyuu musxkuẽ akheçte uyçxa' ");
INSERT INTO pbb_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","na'jĩk: —Isath we'we', naa vxiuda puuple' maatewa jxthaakwek wala akh. ");
INSERT INTO pbb_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Vxite yu' akhçxawa, neeyũusáa peejxmeesaçxáan yã'jtx akhe'. Nawa naa u'ya' kĩh yuhwa ji'phmeesaçxawa txajx ũ' weywa'ja's jxukak akh jĩk. ");
INSERT INTO pbb_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Txajũ' kxtee ũssa maaíi yu' dxuus yata's thegçxatx we'wena ũsu': Ofxreda peesni yakh wala yuh zhiçxkwe pheu'jna txaahni' jĩte', Jesusa' na'jĩk: ");
INSERT INTO pbb_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","—Ãçxhíi yu' txã'wẽ yuh zhiçxkwe thegna ũsa', nawa kĩh yuhwa nvxihtmée jxuka suwní yuuwa'j en pa'jana. Aça' teeçx kwetçxáa yuhwa kẽesẽ'jnimée yu' neeyũumeetxna naa yattewe'sx jĩk. ");
INSERT INTO pbb_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Txã'jĩte': —¿Bagaçx txã'wẽ yuukx? meeçxawa txã'wẽ yũuwa'j en ãjãçte' ¿kĩhçxa yuukx? jĩna pẽjxte', ");
INSERT INTO pbb_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","na'wẽk pta'sx: —I'kwe'sxtxi kaypuba'jwe'sxte mpa'yajkxwe. Txã'wẽme' wala kasejetxna Dxus kaahnisatha'w jĩna na'jĩna: Adxa' Kristoth, aça' ãçxha' nmeh en ãjk jĩtxna. Nawa txãawe'sxtxi' nwẽesẽ'jnuwe. ");
INSERT INTO pbb_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","I'kwe'sxa' wẽsẽ'jene'kwe gweçxa seena'sa yuja' jĩni, nawa txã' nyafxtewe'sxçxáata' aça' ũukhmeene'kwe. Nmeh en yu' ãhméy txã'wẽ yuuna. ");
INSERT INTO pbb_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Txajũ' ma'wẽ yũuwa'ja'swa jxuka pta'sxku na'jĩna: —Txãn en ãjãçte', gobierno' vxite kiwete gobierno yakh puiitxna. Naapkaçxha' puutx jxu'j kiweju pwe'sxwa puiitxna. ");
INSERT INTO pbb_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Sa' msuu msuuwa seena' ehd u'jwena. Wẽjẽwa txã'wẽ wala pa'jana. Naapkaçxha' kakwete wee seena'sawa pa'jana. Sa' cieluju kĩjkĩhwa seena'saçxáa vxyaatxna. ");
INSERT INTO pbb_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Nawa txã'wẽ seena' yũuwa'j en pa'jmeyna, i'kwe'sxtxi ahçeçxa preesu'jya' pakweetxna. Sa' judiuwe'sx pkhaakhenisuwa jxũna u'jwetxna: Nasa ewmeesa' jĩna. Txã'wẽ yũuna karceltewa txajatxna, i'kwe'sxa' adxna nwẽesẽ'pha'gaçxáa jxkaahsawe'sx tasxsu vxite' ne'jwe'sx tasxsuwa kuutxa'jni yuune'kwe. ");
INSERT INTO pbb_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Txã'wẽ yũute', Dxus yuwe's txãawe'sxtxiwa pta'sxwa'j en ji'phune'kwe. ");
INSERT INTO pbb_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","I'kwe'sxa' txãawe'sxtxi' ¿ma'wẽ pasukxtha'w? sũhna kuh yajkxmeene'kwe, ");
INSERT INTO pbb_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","txãa pa'gatey adxa' i'kwe'sxtxi açesawe'sxtxi ma'wẽ paswa'ja'swa kaaũusuthe'je'nja. Aça' txãawe'sxa': Ĩsxĩija'g jĩya' ãjãmeetxna maa yuhwa. ");
INSERT INTO pbb_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Sa' i'kwe'sx nwe'sxíi yuhwa açeni yuune'kwe, tatawe'sx, yakhthẽ'jwe'sx, namikuwe'sx preesu'jutxna. Aça' maaíi yu' ikhni yuune'kwe. ");
INSERT INTO pbb_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","I'kwe'sxa' adxna nwẽesẽ'pha'ga naa kiwete jxukaysa açeni yuune'kwe. ");
INSERT INTO pbb_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Nawa i'kwe'sx dxkhasçxáa yuhwa vxitumeetxna teeçxçxáa yuhwa. ");
INSERT INTO pbb_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","I'kwe'sxa' uu entepkaçx Dxus yakh txutemée fxi'zeçxa', Dxus tasxte ĩtxĩ fxi'zewa'ja's ji'phune'kwe. ");
INSERT INTO pbb_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Jerusalen çxhaba's soldauçxaçxáa jxuka ktadxiiçxa ũste uyçxa', ãçxha' naa çxhaba' jxuka pçuwa'jsana sũhna jii ũsune'kwe. ");
INSERT INTO pbb_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Naapkaçxha' Judeasuwe'sxa' ũphna u'jwetxna yu'khsu, aça' Jerusalen çxhabtewe'sxwa txãa çxhabu ũphna kasejetxna, vxite' çxhab ekajuyã'j ũssa' çxhabte u'kameetxna. ");
INSERT INTO pbb_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Txã'wẽme' txãn ensu' kastigo seena'sa yuuna Dxus librute ma'wẽga pta'sxi' txã' jxuka kxtey yuuna. ");
INSERT INTO pbb_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Aça' txãn ensu' nasa ji'phsa meeçxawa luuçx ãpãkuẽ ji'phsa' wala yuh pxthaa yuutxna, txã'wẽ txãa nasatx kastigo seena'sa pa'the', naa kiwete wala yuh nxuswa'j yuuna. ");
INSERT INTO pbb_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Maaíitxi's gweçxate ikhetxna, sa' vxite yuutxi's preesu'jçxa jxu'j kiwen jxũna u'jwetxna. Naapkaçxha' Jerusalen çxhaba's vxite nasa u'kaçxa jxuka suwçxa kxtee makwe txaçxwa ũsutxna. ");
INSERT INTO pbb_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Txã'wẽ yũunijũ' sek a'te estrelxa txãasu seena'çxáa vxyaatxna. Aça' naa kiwete nasa mtee mteewe'sxwa jxuka jxpubana iiméh wala ũukhutxna txã'wẽ ĩkh wala seena' yuuna susni's wẽsẽ'jçxa. ");
INSERT INTO pbb_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Txã'wẽ seena' yuuçte', naa kiwete nasa' ũukhçxa ũus yu'swa ivxiitutxna, naapkaçxha' ẽe walate kĩjkĩh ũssawa jxuka seena' kẽesẽ'jni yuutxna. ");
INSERT INTO pbb_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Txajũ' Dxus Nçxi'k Nasa Yuusa's uyuutxna, tãaph pxãhte sek na'wẽ seena' zhiçxkwe khikhyna kĩjaçte. ");
INSERT INTO pbb_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Txã'wẽ seena' yuuya' takheçte', i'kwe'sxa' ũukhmée weçxana ũythasna meswe, jwee yu' jxthẽeyuumée nwe'weni yuune'kwe jĩk. ");
INSERT INTO pbb_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Txãa e'su' vxite ejemplo pta'sxku: —Mthegwe higwera fxtũu tasx meeçxawa vxite fxtũu tasxtxi. ");
INSERT INTO pbb_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Sa' txãa fxtũu tasx yeeçuçte uyçxa', yũnya'watewa jiyu'i'kwe. ");
INSERT INTO pbb_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Txã'wẽy adx pta'sxni kxtey yuuçte uyçxa', Dxus naa kiwete kĩiwa'j en utxaaçna sũhna jii meswe. ");
INSERT INTO pbb_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Isath we'we': naa ensu nasa uumeyna, txã'wẽ kxtey yuuna. ");
INSERT INTO pbb_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Cielu naa kiwe jxuka skhẽuutxna, nawa adx we'weni' jxuka kxtey yuumey yu', skhẽwmeetxna. ");
INSERT INTO pbb_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Wala jxpa'yakx meswe, ewmée yũuna tũuna kĩjkĩhwa naa kiwetewe'sxçxá's yajkxna fxi'zenuwe. Txã'wẽme' Dxus yu's yajkxmée ũsiyna, Dxus kĩiwa'j en ãhçxáa yuuna. ");
INSERT INTO pbb_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Niimalwa jiimeeçxa' ma'wẽga yajkxte khẽje', txã'wẽyçxáa Dxus kĩiwa'j ena' kpaakina naa kiwete nasa mtee mteewe'sxtxiwa jxukaysatx. ");
INSERT INTO pbb_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","I'kwe'sxwa wala jxpa'yakx meswe, na'wẽ seena' yuuya'wa' txajũ iyuya'. Dxus yakh puutx we'wena nes myuuwe bagaçxtewa, sa' txã'wẽ yũuçxa' Dxus Nçxi'k Nasa Yuusáa tasxte utxaaya' ãjãne'kwe jĩk. ");
INSERT INTO pbb_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Jesusa' en yu' dxuus yattek kaapiya'ja', nawa kus yu' Oliwos vxiçnak u'jwe'. ");
INSERT INTO pbb_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Aça' nasa' een isa kuusíitx dxuus yatte pa'ja' Jesus kaapiya'jni's wẽsẽ'jya '. ");
INSERT INTO pbb_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Pan lewadura ji'phmée ũ'ni Paskua fxiesta ãjãçku yu'. ");
INSERT INTO pbb_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Aça' sacerdote npiiçthẽ'jwe'sx vxite' ley kaapiya'jsawe'sxa': Jesusa's ¿ma'wẽ yũuçxa ikhekxtha'w? jĩnatx txãawe'sx pwe'sx puutx we'wena ũsu'. Nawa nasa wala kuh Jesus ju'gusa ũste', ũukhu'tx. ");
INSERT INTO pbb_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Naapkaçxha' eçxthẽ'ja' Judas Iskariote ũuste u'kak. Txãa Judas yu', Jesus yakh u'jusa docesatewe'sxíiçxáak yu'. ");
INSERT INTO pbb_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Txajũ' txãa Judasa' puutx we'weya' u'kh sacerdote npiiçthẽ'jwe'sx vxite' dxuus yatte thegsawe'sxtxi, Jesusa's txãawe'sx kusete dukhya'. ");
INSERT INTO pbb_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Aça' txã'wẽ puutx we'wete', txãawe'sxa' vxyu dukhya' neeyũutx Judasa's. ");
INSERT INTO pbb_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Txajũ' Judasa' nasa uynimeete paaçte dukhwa'ja's pakwek. ");
INSERT INTO pbb_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Txajũ' pan lewadura ji'phmée ũ'ni fxiesta en ãjk. Txãa ente' piisxáa luuçxtxi ikhe' Paskuatewe'sx. ");
INSERT INTO pbb_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Aça' txãa ente' Jesusa' na'jĩnak jxkaah Pedro Juanwe'sxtxi: —Me'jwe Paskua fxiestate ũ'wa'ja's pheu'jya' jĩte', ");
INSERT INTO pbb_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","txãawe'sxa' pẽjxtxi: —¿Mteega pheu'j jxthãasu'? jĩte', ");
INSERT INTO pbb_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Jesus pasçxa': —Çxhabna u'jçxa kxtee pa'jaççxa', teeçx piçthẽ'j uyuune'kwe yu' mitxha's yakhçxa u'jweçte. Sa' e'ste u'jwene'kwe yatte u'kapkaçx. ");
INSERT INTO pbb_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Sa' kxtee pa'jçxa', yat namu's na'jĩne'kwe: Kwe'sxtxi jxpe'jsa' pẽjxya'k kaah: Paskua fxiestate txãa yakh u'jusawe'sx yakh ũ'wa'j ¿mtee piesa pheu'jni ũsna? jĩkaja'k jĩne'kwe. ");
INSERT INTO pbb_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Aça' yat namu' ẽe yatte piesa walasa pheu'jniyã'jsa's pta'sxina. Kxtee ũ'wa'ja's pheu'june'kwe jĩnak jxkaah. ");
INSERT INTO pbb_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Aça' Pedrowe'sxa' u'jçxa', Jesus ma'jĩni'swa jxuka kxtey uyçxa Paskua fxiestate ũ'wa'ja's pheu'jtx. ");
INSERT INTO pbb_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Txajũ' ũ'wa'j ora ãhte', Jesusa' txãa yakh u'jusawe'sx yakh kaçxku mesate ũ'ya'. ");
INSERT INTO pbb_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Sa' na'wẽk we'we: —¡Mazkuẽ uswa wala yuh yaaki'th, adxa's uu en pa'jmeyna, naa Paskua fxiestate i'kwe'sx yakh nmeh ũ'wa'ja's! ");
INSERT INTO pbb_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Na'jĩ'th na': ãçxha' ayte peena yu' naa Paskua fxiestatewe'sxa's ũ'me'nja, Dxus ki' jxkaajxa' pa'jwa'j en ãhpkaçx. ");
INSERT INTO pbb_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Txajũ' waso's uweçxa Dxusna weçxana orãyçxa', na'jĩk: —Jxpa'gaçxa jxukaysa mtudxwe naa wasotewe'sxa's. ");
INSERT INTO pbb_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Na'jĩ'th na': ãçxha' ayte peena yu' uwa yu'a's tudxme'nja, ki' Dxus jxkaajxa' pa'jwa'j en ãhpkaçx. ");
INSERT INTO pbb_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Txajũ' pana'swa Dxusna weçxana orãyçxa', pe'ltedeçxa txãawe'sxtxi ũsu'sku na'jĩna: —I'kwe'sx pa'gate adx kakwe' dukhwa'j yuuya'wa', aça' naa pana' adx kakwe na'wẽsa'. I'kwe'sx pa'gate adx pxthaa yuuçxa uuni's yajkxna txã'wẽ myũuwe bagaçxtewa. ");
INSERT INTO pbb_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ũ'na jxã'jçxa', waso's jxpa'gaçxa na'wẽk we'we: —Adx eea's pkawçxa yuuçxáak Dxusa' i'kwe'sxtxi nwe'wewa'ja's u'se pheu'jçxa nvxiht. Aça' naa wasotewe'sxa' adx ee na'wẽsa'. ");
INSERT INTO pbb_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Aça' ãçxha' adx yakh ũ'na u'pa' ay mesate txãa piçthẽ'ja' adxa's açesawe'sx kusete dukhya'wa'. ");
INSERT INTO pbb_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Dxus Nçxi'k Nasa Yuusá' ãçxha' pejka uuya'wayuja'. Adx uuwa'ja's ma'wẽne' Dxus nvxiht txã' kxtey yuuya'wa'. Nawa adxa's açesawe'sx kusete dukhsa' ¡seena' yuh nxuste khẽjena! jĩte', ");
INSERT INTO pbb_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Jesus yakh u'jusa pwe'sx puutx ya'paapẽyi'tx na'jĩna: Kwe'sx ksxavxytewe'sx ¿kim txã'wẽ dukhya'wakx? jĩ'tx. ");
INSERT INTO pbb_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Txajũ' txãawe'sx pwe'sx na'wẽ yũuwa'ja'stxi puutx ya'paapẽyi': —Ayte kwe'sx ksxavxytewe'sx ¿maa wejx jxthaakwe walasakx? jĩte', ");
INSERT INTO pbb_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Jesus pasçxa': —Naa kiwete jxkaahsawe'sxa' wala juuna'çxáa yuuna jxkaaja'tx. Txã'wẽtewa txãawe'sx yuutxi's wala ewsata' jĩ'tx nasa yu'. ");
INSERT INTO pbb_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Nawa i'kwe'sxa' txã'wẽ yũuna jxkaahwa'jsameei'kwe, wejxwa i'kwe'sxa' maaíi yu' jxthaakwe walasa ũsçxawa, nuuçxsa na'wẽ yuuwa'j ji'phi'kwe. Aça' maawa jxkaahwa'ja's ji'phsa', selpisáa na'wẽçxáa yuuwa'j ji'phi'kwe. ");
INSERT INTO pbb_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","¿Maa wejx jxthaakwe walasakx? ¿Puuçte mesate ũ'ya' kaçxsá wejx jxthaakwe walasamanx, meeçxa' puuçsa wáa wejx jxthaakwe walasana? Isa ew yajkxte', mesate ũ'ya' kaçxsá jxthaakwe walasana. Nawa adxa' i'kwe'sxtxi selpisáa na'wẽçxáa ũsthu. ");
INSERT INTO pbb_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Adxa' bagaçxtewa nxuste thẽyte fxi'zeçtewa i'kwe'sxwa adx yakh ja'da pxthaa yuuna nesi'kwe yu' nvxihtmée. ");
INSERT INTO pbb_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Txãa pa'ga adxa' i'kwe'sxtxi ũsu'nja jxkaahwa'ja's, adxa'swa ma'wẽga adx Tata jxkaahwa'ja's ũs txã'wẽy, ");
INSERT INTO pbb_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","kxah adx jxkaahna ũsnite pa'jçxa', adx yakh ih mesate ũ'wene'kwe, sa' Israelwe'sx ji'j docesatx jxkaahsa yuune'kwe. ");
INSERT INTO pbb_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Txajũ' Jesusa' Simona's na'wẽk pta'sx: —Simon, idxa' wala yuh mpa'yajkx. Txã'wẽme' eçxthẽ'ja' i'kwe'sxtxi pẽjxku skuutxh kweejxa'jsa na'wẽ yuuya'. ");
INSERT INTO pbb_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Nawa adxa' iidx pa'gate Dxusa's neewe'weth, Dxusçxáana yajkxna fxi'zekahn. Aça' idxa' Dxus tasxte ki' sxawedçxa', yakhthẽ'jwe'sxtxi kçxhãaçxha'jane'ga Dxus yakh txutemée fxi'zewa'ja's jĩte', ");
INSERT INTO pbb_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Simon pasçxa': —Adxa' karcelna ma'k yuu meeçxa' uuwa'j ma'k yuu nawa adxa' kĩhte yuhwa txuteme'nja jĩte', ");
INSERT INTO pbb_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Jesus ki' we'weçxa na'jĩk: —Pedro, idxa's na'jĩ'th na': ãçxhíi atalx we'wemeyna, idxa' tekh us ĩsxĩijaçyã'j yuune'ga adxa's jiimeeth jĩna. ");
INSERT INTO pbb_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Txã'wẽ pta'sxçxa' Jesusa' na'wẽk pẽjx: —Adxa' teeçx ente' i'kwe'sxtxi' Dxus yuwe pta'sxya' kaahçxa' kĩh yuhwa ji'phmeeth kaah, ya'ja, vxyu, pelgatxi txã'wẽsatx. Aça' i'kwe'sxtxi' dxi'the ¿kĩhçxá' peejiigá'? jĩte', txãawe'sx pasçxa': —Kwe'sxtxi' kĩh yuhwa peejime' jĩtx. ");
INSERT INTO pbb_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Aça' Jesus we'weçxa' na'jĩk: —Ãçxha' ya'ja ma'k yuu, vxyu ma'k yuu, kçxilx ma'k yuu nawa ji'phsa' jxũçxa me'jwe. Aça' kçxilx ji'phmeesa' atxha's txweyçxa kçxilx mweywe. ");
INSERT INTO pbb_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Txã'wẽme' Dxus librute we'weçxa': Ewmeesathas yuuwesa yakhku ki'pni yuu jĩk naa pa'ga ãçxha' adxa's jxuka txã'wẽy yuuya'wata' jĩte', ");
INSERT INTO pbb_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","txãawe'sx we'weçxa': —Ayte e'z kçxilx yu' ũsta' jĩte', Jesus pasçxa': —Txã'wẽçxa'. Txãaçxáa ewtxna jĩk. ");
INSERT INTO pbb_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Txajũ' Jesusa' ũ'na jxã'jçxa', txajũ kasehçxa', Oliwos vxiçna ki' u'kh. Aça' txãa yakh u'jusawe'sxwa e'stey u'jtx. ");
INSERT INTO pbb_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Kxtee pa'jçxa na'jĩk: —Dxus yakh puutx we'wena me'pwe, ewmeete weteya'mée jĩçxa', ");
INSERT INTO pbb_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","txãawe'sx tasxu jxu'jmeekuẽ txuteena u'jçxa peejxũkweçxa na'jĩnak Dxus yakh puutx we'we: ");
INSERT INTO pbb_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","—Tata, idxa's ewuweçxte', seena' nxuste uuwa'ju meen nwe'we. Nawa adx jxthãasni's kxtey yuumeeçxawa, iidx jxthãasniçxá's kxtey meen yũu jĩte', ");
INSERT INTO pbb_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Dxus angel cielujũwe'sx kvxiisxa'jna kçxhãaçxha'jya' kĩjk. ");
INSERT INTO pbb_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Txã'wẽme' wala yuh pxthaa nxusna Dxus yakh puutx we'wena u'pu'k naa pa'ga pẽ'ç yuhwa ee na'wẽsak wala pkaw. ");
INSERT INTO pbb_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Sa' Dxus yakh puutx we'wena jxã'jçxa' kiiteçxa u'kh Pedrowe'sxtxi thegya'. Nawa txãawe'sxa' deenitx yu', wala nxusçxa. ");
INSERT INTO pbb_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Aça' kũhçxa na'wẽk we'we: —¿Kĩjxa'kwe dejé'? Kiiteçxa Dxus yakh puutx we'wena me'pwe, ewmeete weteya'mée jĩk. ");
INSERT INTO pbb_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Jesusa' kxtee we'wena nee ũsiyna, nasa wala kũhtx. Aça' Jesus yakh u'jusa Judas yu' txãa nasa yaçte kũhçxa, Jesus tasxte utxaak pukakwette weçxaya'. ");
INSERT INTO pbb_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Aça' Jesusa' na'jĩk: —¿Judas, idxa' Dxus Nçxi'k Nasa Yuusa's weçxani yakh wáa kuuwe'jya'wane'ga? jĩte', ");
INSERT INTO pbb_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Jesus yakh u'jusawe'sxa' Jesusa's pẽjxtxi: —¿Txãa nasatxi's kçxilx yakh puiimtha'w? jĩtx. ");
INSERT INTO pbb_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Txajũ' Jesus yakh u'jusa teeçxsa yu' sacerdote npiiçthẽ'ja's selpisáa thũ'wẽ's spẽ'thku paçuwe'sxna. ");
INSERT INTO pbb_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Aça' Jesusa' we'wek: —Kxtee pa'j yu' yũunu jĩçxa', txãa thũ'wẽ spẽ'thnite jxa'dxçxa', ki' kaywẽtu'kh. ");
INSERT INTO pbb_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Sa' sacerdote npiiçthẽ'j vxite' dxuus yatte thegsawe'sx vxite' judiu nthẽ'jsawe'sx preesu jxũna u'jya' pa'jsatx we'wek: —Adxa' ¿pesweethas i'kwe'sxa' kçxilx petx fxtũ atçxawá'kwe adxa's preesu jxũna u'jya' yuwé'? ");
INSERT INTO pbb_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Adxa' i'kwe'sx yakh een isath dxuus yatte ũsu', nawa txagaçxhíi yu' tudxa' utxaameeçxa', jxuka çxhi'dxni naa orate yu' pejka preesu'jya' pa'ji'kwe jĩk. ");
INSERT INTO pbb_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Txajũ' Jesusa's tudçxa jxũna u'jtx sacerdote npiiçthẽ'j yatna. Aça' Pedro' Jesus e'ste jxu'j neeyũuçxak u'jna ũsu'. ");
INSERT INTO pbb_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Kxtee pa'jçxa' patxute ipx yuthçxatx bajçxya' kaçx. Aça' Pedrowa txãawe'sx yakh ih bajçxya' kaçxku. ");
INSERT INTO pbb_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Aça' teeçx u'y selpisá' Pedro txã'wẽ ipx pukate bajçxna u'pte', dxi'pte ew thegçxa na'jĩk: —Naa piçthẽ'jwa Jesus yakh u'jusa' jĩte', ");
INSERT INTO pbb_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Pedro' ĩsxĩik: —Adxa' jiimeeth txãa piçthẽ'j kxsusu'i'kwe txã'sa' jĩk. ");
INSERT INTO pbb_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Txajũ' txãa e'su' vxitewa uyçxa na'jĩk: —Idxwa txãawe'sx yakh u'jusag jĩte', Pedro pasçxa': —Isa, adxa' txãawe'sx yakh u'jusameeth jĩk. ");
INSERT INTO pbb_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Txãa skhẽwni teeçx orate' vxitek na'jĩna we'we: —Ĩsxĩimeete, naa piçthẽ'ja's uythu Jesus yakh u'jute. Txãa yakh u'jusaçxaíi, Galileajuwe'sxa' jĩte', ");
INSERT INTO pbb_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Pedro pasçxa': —Kĩhne'ga we'we' na'swa jiyuçmeeth. Txã'jĩna we'wena nee ũsiyna, atalx we'wek. ");
INSERT INTO pbb_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Aça' Jesusa' tuphiçxa Pedro dxi'pte thegte', Pedro' yajkxku Jesus we'weçxa': Ãçxh atalx we'wemeyna, tekh us ĩsxĩijaçyã'j yuune'ga jĩni's. ");
INSERT INTO pbb_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Txajũ' Pedro' eka kasehçxa seena' wala nxusna ũ'nek. ");
INSERT INTO pbb_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Txajũ' Jesus ũphwe'sxte yupna ũssa yu' weeçx we'wenatx pãpã'. ");
INSERT INTO pbb_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Sa' yafxtxi tudçxatx dxi'pte uka'ka' na'jĩna: —Aan jiyune'ga kim uka'kaçtewa. ");
INSERT INTO pbb_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Txã'jĩnatx wala kuh jwed we'wena wẽesxu'. ");
INSERT INTO pbb_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Sa' khikhyna sẽjẽçte', judiu nthẽ'jsa sacerdotewe'sx, Dxus leya's kaapiya'jsa txãawe'sx pkhaakheçxatx Jesusa's kxtee kuutxa'jçxa pẽjx: ");
INSERT INTO pbb_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","—Mpeeta'sx, idxa' ¿Kristo dxihgá'? jĩte', Jesus pasçxa': —Txã'wẽíith jĩtewa, isane' we'we' sũhmeene'kwe. ");
INSERT INTO pbb_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Sa' i'kwe'sxtxi adx paapẽjxwaçwa, pasya'wameei'kwe. Sa' adxa's txhweteya'wameei'kwe. ");
INSERT INTO pbb_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Nawa ãçxhũyã'ja' Dxus Nçxi'k Nasa Yuusá' Dxus ĩtxĩsa pukate kaçxya' u'jwena jĩk. ");
INSERT INTO pbb_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Aça' jxukaysa na'wẽtx pẽjx: —Na'jĩ'g na', idxa' Dxus Nçxi'kthu jĩne'ga jĩte', Jesus pasçxa': —Txã'wẽíith. I'kwe'sxa' isa i'kwe we'we' jĩk. ");
INSERT INTO pbb_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Aça' txãawe'sx we'weçxa': —¿Kĩjxa' jwee vxite testigo peejiikxtha'w? Kwe'sx thũ'wẽju yuutha'w txajx we'weni's wẽsẽ'j jĩ'tx. ");
INSERT INTO pbb_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Txã'wẽ yũuçxa' Jesusa's Pilato tasxna jxũna u'jtx. ");
INSERT INTO pbb_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Kxtee pa'jçxa' na'jĩnatx pãatxhĩ'kh: —Naa piçthẽ'ja' nasatx kaypuba'jna ũstetha'w uy, sa' Romate gobierno's dukhwa'jme'. Sa' Dxus txhitxhçxa kaahnisa adxthu jxkaahwa'jsa jĩ'k jĩte', ");
INSERT INTO pbb_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pilato' pẽjxku: —Idxa' ¿judiuwe'sxtxi jxkaahsa dxihgá'? jĩte', Jesus pasçxa': —Txã'wẽ íith, isag we'we' jĩk. ");
INSERT INTO pbb_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Aça' Pilato' sacerdote npiiçthẽ'jwe'sx nasa jxukaysatx na'wẽk we'we: —Naa piçthẽ'j yuuwe yuuni's uyu'çmeeth jĩtewa, ");
INSERT INTO pbb_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","txãawe'sx yu' jweeíiçxáatx sus we'wena na'jĩ': —Judeate nasa jxukaysatx jxuka kaypuba'jna jxã'jaça' txajx we'weni yakh, Galileaju takhçxa ãçxha' aysuwa jxuka pekũjuça' txã'wẽ yũuna jĩ'tx. ");
INSERT INTO pbb_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Txã'wẽ we'wete Pilato wẽsẽ'jçxa', nasatx pẽjxku: —Txãa piçthẽ'ja' Galileajũwe'sxwáana jĩna. ");
INSERT INTO pbb_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Aça': —Txajũwe'sxí'k jĩna pta'sxte', Galileate ne'jwe'sx Herodes tasxnak kaah, txãn ensu' Herodeswa Jerusalenteyku ũsu' naa pa'ga. ");
INSERT INTO pbb_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Aça' Herodesa' Jesusa's uyçxa', wala weçxak, txã'wẽ Jesusa' kĩhwa yu'k jĩni's wẽsẽ'jçxa' nyafxíik Jesus yakh puutx uy wẽena ũsu', cieluju kĩhçxáawa kaavxya'ja'the' txãawa uyu'nja sũhçxa. ");
INSERT INTO pbb_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Txajũ' Jesusa's kĩjkĩhwa wala pẽjxku, nawa pasme'. ");
INSERT INTO pbb_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Kxteewa sacerdote npiiçthẽ'jwe'sx vxite' Dxus leya's kaapiya'jsawe'sx kũhçxa wala juuna' we'wena yuwee ũstxi. ");
INSERT INTO pbb_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Aça' Herodesa' txajx soldauwe'sx yakh Jesusa's weeçx we'wena ahçeçxa jxkaahsa ropa na'wẽ zhiçxkwesa kaathe'jçxatx npeevxysxijkana ũsu'. Txã'wẽ yũuçxak Herodesa' Pilato tasxtey Jesusa's ki' kaah. ");
INSERT INTO pbb_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Pilato yakh Herodes yakha' nyafxíi yu' iipuiisatx yu', nawa txãn ente txã'wẽ yũuçxa' yuwe ewuutx. ");
INSERT INTO pbb_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Txajũ' Pilato' sacerdote npiiçthẽ'jwe'sx vxite' judiu nthẽ'jsawe'sx çxhabte nasa jxukaysatx kaapkhakhe'jçxa, ");
INSERT INTO pbb_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","na'jĩnak we'we: —I'kwe'sxa' naa piçthẽ'ja' nasatx kaypuba'jna ũsa' jĩçxa adx tasxte nuypa'ji'kwe. Aça' adxa' i'kwe'sx wẽsẽ'jna ũstey jxuka paapẽjxthu. Nawa kĩhte yuhwa ewmée yũuni's yu' uymeeth. ");
INSERT INTO pbb_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Aça' Herodeswa ewmée yũuni's uymeeçxa', ki'kin kaasxwedu'kh. I'kwe'sxíiwa jiyui'kwe naa piçthẽ'ja' yuuwesa kasehme'. Aça' ¿ma'wẽ ikhwa'j yuukx? ");
INSERT INTO pbb_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Txãa pa'ga ikhmée kaapeçxukwe'jçxaçxáa kaatxhweete'je'nja jĩte', ");
INSERT INTO pbb_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","18","nasa jxukaysa na'jĩnatx sus we'we: —Naa piçthẽ'ja's ikhçxa Barabasçxá's mitxhwete jĩ'tx. (Pilato' anxu iisak txãa fxiestate teeçx preesu txhweeté' nasa weçxaakahn naa pa'gatx txã'jĩ'.) ");
INSERT INTO pbb_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Txãa Barabas yu' çxhabte gobierno's puíi kiisçxa nasatx wala kiikhe'pha'ga karceltek txaahni ũsu'. ");
INSERT INTO pbb_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Txajũ' Pilato' Jesusa's txhweete wẽeçxa nasatx ki' pẽjxku. ");
INSERT INTO pbb_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Nawa txãawe'sx yu' jweeíiçxáatx sus we'we: —Kluuste pejka mkaafxuçu'j yuh jĩna. ");
INSERT INTO pbb_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Aça' Pilato' tekh uswa nasatx ki' we'wek na'jĩna: —Naa piçthẽ'ja' ¿kĩhga ewmée yũu? Adxa' makwe paapẽjxçxawa, ewmée yũuni's yu' uymeeth ikhkahn yuuwa. Txã'wẽ yuuwesa kasejeçme' aça' kaapeçxukwe'jçxaçxáa kaatxhweete'je'nja jĩtewa, ");
INSERT INTO pbb_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","txãawe'sx yu' jweeíiçxáatx sus ũusçxa we'wena kluuste fxuçkaah. Sacerdotewe'sx nasa jxukaysa txã'wẽ sus we'weni yakhçxáa pejka knaytxi txãawe'sx pẽyni's. ");
INSERT INTO pbb_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Txajũ' Pilato' txãawe'sx pẽyni's kxtey yuuk, ");
INSERT INTO pbb_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","sa' gobierno's puíi kiisçxa nasatx kiikhe'jsa yu'sa' karceluh kaakutxi'jçxa Jesus yu'sa' txãawe'sx kusete nvxihtku, kĩh yũu wẽeçxawa kxtey yuukahn. ");
INSERT INTO pbb_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Jesusa's kluuste fxuçya' jxũna u'jweççxa', teeçx piçthẽ'j Cirenejũwe'sx Simon yaasesa çxhabte pa'jaçte pu'jykhẽwçxa', kluusa's txã'sna kxaakhe'jçxatx Jesus e'stey pe'jna u'j. ");
INSERT INTO pbb_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Txã'wẽ yũuya' u'jweçte, nasa wala kuh u'jweç yu'tx. Txãa ksxavxyte u'ywe'sxwa txã'wẽtx wala kuhsa nxusçxa sus ũ'nena u'jna ũsu'. ");
INSERT INTO pbb_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Aça' Jesusa' txãawe'sxtxi yu'thegçxa': —Jerusalente u'ywe'sx, adxa's nxusçxa ũ'ne na'wẽ' wejx yuuwa i'kwe'sx fxi'zewa'ja's yajkxçxa mnxuswe, i'kwe'sx luuçx pa'gate. ");
INSERT INTO pbb_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Txã'wẽme' naa kiwete nxusu en yuja'. Txãa en pa'the', txãawe'sx luuçx pxthaa yuuçte uyçxa' na'jĩtxna: Bagaçx yuhwa nasa ji'phuçxa kçxu'çxu'jsamée yakha' txakwe nxus yuhmeena jĩtxna. ");
INSERT INTO pbb_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Txajũ' nasa' nxusna ũukhna vxiç wala upeçxa jxuka ikh jxthãasutxna, sa' thã'j le'çxkwesatxwa txã'wẽy yũu jxthãasutxna. ");
INSERT INTO pbb_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Fxtũu tasx buçxaçteçxáa yuhwa na'wẽtx yũ' na' fxtũu tasx ewsa ukawa'j en ãhte yu' wejx txã'wẽ yũutxna jĩk. ");
INSERT INTO pbb_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Jesus yakh ikhya' e'z piçthẽ'j wala yuuwesatx jxũna u'jtx. ");
INSERT INTO pbb_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Sa' teeçx ahte Uusáa dxikthé dxi'thçxáasa jĩnisate pa'jçxa', Jesusa's kluuskhẽ ki'ptxi, txã'wẽy e'z yuuwesatxwa teeçxsa's paçu, vxite's jebu. ");
INSERT INTO pbb_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Txã'wẽ kluuste fxuçuçte', Jesusa' na'jĩnak we'we: —Tata, meen peltunaĩ adxa's açesawe'sxtxi. Txãawe'sxa' jiimeeçxatx txã'wẽ yũ' jĩk. Txajũ' soldauwe'sxa' swerte kaahtx, Jesus athni ropa's maa soldau knaytewa jiyuya'. ");
INSERT INTO pbb_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Naapkaçxha' nasa kuhsa kxtee thegna ũssa vxite' judiu npiiçthẽ'jwe'sxwa Jesusa's weeçx we'wena npeevxysxijkatx na'jĩna: —Vxitetxwa nwe'weya' ãjã'k na' ãçxha' peekíi kluusuwa iyuna, Dxus txhitxhçxa kaahnisa dxihçxa' jĩ'tx. ");
INSERT INTO pbb_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Aça' soldauwe'sxwa weeçx we'wena utxaaçxa', vxino ewmeesa's yus wẽena ");
INSERT INTO pbb_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","na'jĩ'tx: —Idxa' judiuwe'sxtxi jxkaahsa dxihçxa', peekíi kluusu iyuçxa msa'j jĩ'tx. ");
INSERT INTO pbb_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Kluus vxiçte' griego, latin, hebreo yuweju fxi'jni na'jĩ'k: Naaíi Judiuwe'sxtxi Jxkaahsa' jĩ'k. ");
INSERT INTO pbb_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Txajũ' yuuwesa kluuskhẽ a'kxni u'psa teeçxsa' na'jĩk Jesusa's iiwẽesxuna: —Idxa' Kristo dxihçxa', peekíi kluusu iyuçxa kwe'sxtxiwa meen nwe'we jĩte', ");
INSERT INTO pbb_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","vxite' ka'tu pukakhẽ u'psa yu' na'jĩnak pas: —Idxa' yuuwesaçxa txã'wẽ seena' kastigãyni u'pçxawa, Dxusa's ũukhu'çmeewá'ga txã'wẽ wẽesxu'. ");
INSERT INTO pbb_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Kwe'sxa' isa yuuwesayuhtha'w, txãa pa'ga kastigãyni u'ptha'w. Nawa naa piçthẽ'ja' kĩhte yuhwa yuuwesa meek yu' jĩçxa', ");
INSERT INTO pbb_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Jesusa's na'wẽk we'we: —Iidx jxkaahwa'the pa'jçxa', adxa's yaakine'ga jĩte', ");
INSERT INTO pbb_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Jesus pasçxa': —Isath we'we', Dxus ũsnite ãçxhíi adx yakh ũsune'ga jĩk. ");
INSERT INTO pbb_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Txajũ' ẽepxãh yuuçpkaçxha', naa kiwete jxuka çxhi'dxku kusuçte las trestepkaçx. ");
INSERT INTO pbb_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Seka' kweethme', naapkaçxha' dxuus yatte txudenisa liensu pesath a'kxnisa' puupxãjkhẽk sute. ");
INSERT INTO pbb_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Naapkaçxha' Jesusa' na'jĩnak sus we'we: —Tata, iidx kusete adx ũusa's nvxiituçthu jĩna'wa uuk. ");
INSERT INTO pbb_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Txã'wẽ yũute', soldau kpiitan uyçxa', na'jĩnak Dxusna weçxa: —Isa, naa piçthẽ'ja' yuuwemeesa yuh yu'ga jĩk. ");
INSERT INTO pbb_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Aça' nasa jxukay kxtee ũssawa txã'wẽ yũute uyçxa', ¿txã'wẽ yuja' yuumanx? sũhnatx nxusna ũukhna u'j. ");
INSERT INTO pbb_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Aça' Jesusa's jiisawe'sx vxite' Galileajũjx Jesus yakh yuusa u'ywe'sxa' jxu'juçxáatx thegna ũsu' txã'wẽ yũuçte. ");
INSERT INTO pbb_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Kxte' teeçx piçthẽ'j José yaasesa ũsu'k. Txãa yu' Judea kiwete Arimatea çxhabtewe'sx judiu npiiçthẽ'j walasatewe'sxku yu'. ");
INSERT INTO pbb_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Txãa Jose' isa bagaçx Dxus jxkaajxa' takhekx sũhna ũythassak yu'. Txã'wẽçxaíik vxite judiu npiiçthẽ'jwe'sx Jesusa's ikhya' puutx we'weçte', txãa yu' wa'l. ");
INSERT INTO pbb_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Txajũ' txãa Jose' Pilato tasxte u'jçxa Jesus kakwe's pẽjxku. ");
INSERT INTO pbb_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Sa' kluusuh spajkxçxa liensute yapçxa kwet penxa u'se phaadeni kim yuhwa pedanimeegak khikh. ");
INSERT INTO pbb_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Txã'wẽ sapatu jxkaasewa'j en jxuka ãjãçku yu'. ");
INSERT INTO pbb_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Aça' u'ywe'sx Galileajũjx Jesus yakh pi'kxna yuusa' txãawe'sxwa u'jçxa kwet kafx pedani's uytxi Jesus kakwe's mkaa khikheçtewa. ");
INSERT INTO pbb_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Sa' yatna sxawedna u'jçxa, Jesus kakwete sxũsxwa'j jxuka pheu'jçxatx sapatu jxkaase ente ki'sna fxi'ze, Dxus jxkaahni's kxtey nwẽesẽ'j na. ");
INSERT INTO pbb_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Jxkaase en skhẽwnijũ kuskuskhẽ wala kusíi u'ywe'sxa' Jesus kakwete sxũsxwa'j pheu'jnisa's atçxa pedaní kwet kafxna u'jtx. Vxite u'ywa txãawe'sx yakh ja'da pi'kxna u'jtx. ");
INSERT INTO pbb_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Kxtee pa'jçxa', kafxte aphnisa kweta's fxiite ki'pni u'pte uyçxa', ");
INSERT INTO pbb_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","kafxte u'katx. Nawa Jesus kakwe yu'sa' uymeeta'. ");
INSERT INTO pbb_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Sa' wala ũukhna ma'wẽ yũuwa'ja's yuuwa jiimeetx ũsu', naapkaçxha' e'z piçthẽ'jtx ropa zhiçxkwe zmeena' çxihmesa athçxa txãawe'sx pukate vxyaa. ");
INSERT INTO pbb_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Aça' wala ũukhçxa kiwekhẽtx kĩiçhu, naapkaçxha' txãa piçthẽ'jwe'sxa' na'jĩtx: —Uusaawe'sx ksxavxyu ĩtxĩ yuusa's ¿kĩjxa'kwe pakwé'? ");
INSERT INTO pbb_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Ayte meeyã'ja'. Uuçxawa ki' ĩtxĩ yuuyã'kh. Galileate ũsçxa' na'jĩnak we'we txã'sa' miiyajkxwe: ");
INSERT INTO pbb_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Dxus Nçxi'k Nasa Yuusa's ewmeesawe'sx kusete dukhni yuuna, aça' txãawe'sxa' kluuskhẽ ki'pçxa ikhetxna. Aça' uuçxawa tekh ente' ki' ĩtxĩ kiiteena ¿jĩna pta'sxmeená'? ");
INSERT INTO pbb_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Txã'jĩte' Jesus we'weni's yajkxtxi. ");
INSERT INTO pbb_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Sa' pedaniijũ sxawedna u'jçxa ma'wẽ uyni'swa jxuka pta'sxtxi oncesatx, sa' Jesus yakh u'jusa vxitesatxwa pta'sxtxi. ");
INSERT INTO pbb_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Txã'wẽ pta'sxsa yu' Maria Magdalena, Juana, Jakobo njĩ'j Maria, vxite' u'ywe'sx ja'da u'jsa txãawe'sxtxi yu'. ");
INSERT INTO pbb_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Nawa Jesus yakh u'jusawe'sx yuutxi' luuku we'weni na'wẽçxáane' pthũuse' txãa u'ywe'sx pta'sxnisa yu', aça' isane'ta we'we' sũjũ'çmeeta'. ");
INSERT INTO pbb_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Txã'wẽtewa Pedro' wuwuuçxak thegya' u'j pedaní kafxte, sa' dxiiga kuyçxa', liensuçxá's puçte ki'pni u'pte uyçxa': ¿Txã'wẽ yuja' yuumanx? sũhna wala kuh yajkxna yatna sxawedku. ");
INSERT INTO pbb_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Txãa entey Jesus yakh u'jusa e'zsa' Emaus çxhabnatx u'jweç yu'. Txãa çxhaba' Jerusalenuh once kilometro ãh jxu'khak ũsu'. ");
INSERT INTO pbb_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Txãa e'zsa' jũ'nakhẽ kĩjkĩh yũuni'swa jxuka yajkxnatx puutx we'wena u'jweç yu'. ");
INSERT INTO pbb_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Txã'wẽ dxi'the we'wena u'jweçpkaçxha', Jesusa' vxyaaçxáa yuuçxa txãawe'sx yakh ja'da u'kh. ");
INSERT INTO pbb_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Txã'wẽtewa, txãawe'sx yu' uyçxawa, kimtewa jiyumeeta'. ");
INSERT INTO pbb_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Txajũ' Jesusa' pẽjxku: —¿Kĩjkwe txakwe puutx we'wena u'jwe'? ¿Kĩh yuupa'ga txã'wẽ nxusna u'jweçkwe? jĩte', ");
INSERT INTO pbb_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Kleofxas yaasesa teeçxsa' na'jĩnak pas: —Jũ'nakhẽçxáa Jerusalente txã'wẽ seena' nxus nxus yũunisa's majũwe'sxwa jxukatx jiyu, aça' idxçxáawá'ga jiyumée neeyũu kxtee ũsçxawa jĩte', ");
INSERT INTO pbb_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Jesusa' pẽjxku: —¿Kĩhga yuu? jĩna. Aça' txãawe'sxa' pta'sxtxi jxuka: —Jesus Nasarethũwe'sxa's seena' nxusnxus vxitçxa ikhni'stha'w ji'phu. Txã' Dxus yuwe pta'sxsa kĩjkĩh yũuya'wa ãjãsak yu', sa' Dxus dxi'pte vxite' nasaa ksxavxytewa txã'wẽk ewçxáa yũuna fxi'zesa yu'. ");
INSERT INTO pbb_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Txã'wẽtewa sacerdote npiiçthẽ'jwe'sx vxite' kwe'sx npiiçthẽ'jwe'sx yu' txã'sa' ikhwa'jçxáa vxitçxa dukhtxi, aça' kluuste fxuççxa ikhtxi. ");
INSERT INTO pbb_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Kwe'sx yu' Israelwe'sxtxi nwe'wewa'jsana sũjũ'tha'w, nawa kxtey yuume'. Txã'wẽ nxus yũuni ãçxha' tekh en yã'j yuuça'. ");
INSERT INTO pbb_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Aça' u'ywe'sx kwe'sx yakh ih pkhaakhena u'jusa maaíi yu' pedaní kafxte thegya' u'jçxa ");
INSERT INTO pbb_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","ki' sxawedçxa', kwe'sxtxi khãawãsxi'tx txãawe'sx pta'sxçxa': Uusáa kakwe yu's uymeeçxawa, angeleswe'sxçxáatxtha'w uy, aça' Jesusa' ĩtxĩ yuuk jĩ'tx jĩnatx kwe'sxtxi pta'sx txãa pa'gatha'w ũukh. ");
INSERT INTO pbb_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Aça' kwe'sx yakh u'jusa piçthẽ'j maaíi yu' pedaní kafxna u'jçxa u'ywe'sx ma'wẽne'ta pta'sx txã'wẽyçxáatha'w uy. Nawa Jesus yu'sa' uymeetha'w jĩnatx pta'sx jĩte', ");
INSERT INTO pbb_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Jesusa' na'wẽk we'we: —Dxus yuwe pta'sxsawe'sx we'weni's nakwe txaçxtewa, jiyuya' ãjã'çmée íiçxáai'kwe. ");
INSERT INTO pbb_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Kristo' cielute u'kamey, ¿seena' nxus pxthaa yuuwa'jsa yu'çmeená'? jĩçxa', ");
INSERT INTO pbb_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Dxus librute ma'wẽ fxi'jni'swa jxuka pta'sxya' takhku, txã's ma'wẽ yũuwa'ja'swa Moises we'wenijũjx takhçxa mtee pa'jne'ta Dxus yuwe pta'sxsawe'sx fxi'jçxa nvxiht kxtee pa'j. ");
INSERT INTO pbb_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Sa' txãawe'sx pa'jwa'j çxhabte pa'the', Jesus yu' u'jnik u'jweç yu'. ");
INSERT INTO pbb_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Aça' txãawe'sxa' na'jĩnatx neevxisxa: —Kwe'sx yakh ayte me'ka dejxa'. Txã'wẽme' kusuçyã'ja' na' çxhi'dxina jĩte', Jesusa' txãawe'sx yakh u'kak kxtee dejxa'. ");
INSERT INTO pbb_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Sa' txãawe'sx yakh mesate u'pçxa', Dxusna weçxana'wa pana's pe'ltedeçxa txãawe'sxtxi ũsu'sku. ");
INSERT INTO pbb_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Txã'wẽ yũunijũtx kimtewa jiyu. Naapkaçxha' Jesus yu' naa dudte txãawe'sx yafxju vxyaame'. ");
INSERT INTO pbb_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Aça' txãawe'sx pwe'sx na'jĩnatx puutx pta'sxi': —Jesusne' yu' aça' isa yuhne' kwe'sx ũuste seena' weçxweçxa ũusuthe' dxi'the yuhçxa Dxus librute fxi'jni's pta'sxiçte' jĩ'tx. ");
INSERT INTO pbb_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Sa' txãa oratey kiitena'wa ki' Jerusalen çxhabna sxawedçxa Jesus yakh u'jusa oncesawe'sxtxi uyna pa'jtx vxite nasa yakh pkhaakheçxa u'pte. ");
INSERT INTO pbb_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Aça' kxtee pkhaakhena u'psa yu' e'zsa Emausu sxawedsatx pta'sxtxi na'jĩna: —Isa, kwe'sxtxi jxpe'jsa' ki' ĩtxĩ yuuyuhga aça' Simonwa uyka jĩte', ");
INSERT INTO pbb_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Emausu sxawedna pa'jsawa pta'sxtxi dxi'the ma'wẽ puutx uyçxa we'weni'swa jxuka, sa' pana's txudedeçpkaçxha' ma'wẽ yũuçxa Jesustewa jiyuçxawa jxuka pta'sxtxi. ");
INSERT INTO pbb_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Txãawe'sxa' kxtee we'wena u'píyna, Jesusa' txãawe'sx pxãhte vxyaaçxáa yuuçxa na'jĩnak weçxa: —Ũukhmée weçxana meswe jĩte', ");
INSERT INTO pbb_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","txãawe'sx yu': anximusa's ne'tka'w uy sũhçxa ũukhuçtxi yu'. ");
INSERT INTO pbb_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Aça' Jesus we'weçxa': —¿Kĩh yuutekwe ũukhú'? Sa' pta'sxte', ¿kĩh yuuçxakwe isa yuhna sũjũ'çmée? ");
INSERT INTO pbb_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Mthegwe adx kuse petx adx çxida yã'jçxa. Vxitemée, adxthu. Aça' adxa's ew jiyuya' mjxa'dxwe. Adxa' anximusmeeçxa', dxi'th ji'phsath, sa' kakwe'swa ji'phsath. I'kwe'sx yafxte ma'wẽtka vxya' txãa yu'sa' jxuka ji'pthu. ");
INSERT INTO pbb_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Txã'jĩçxa', kuse petx çxida yã'jçxa ktheegu'kh. ");
INSERT INTO pbb_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Nawa txãawe'sxa' kuh yajkxna weçxaniiteçxáa Jesusna sũhna yaakxwa'j yu'sa' ji'phumeeta'. Txajũ' Jesusa' na'jĩk: —¿I'kwe'sxa' ũ'wa'j kĩhçxáawa ji'phmeekwe'? jĩte', ");
INSERT INTO pbb_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","wedx khakhni pe'la vxite' çxhi'dx mil txã'wẽsa'stxi ũs. ");
INSERT INTO pbb_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Aça' jxpa'gaçxa' txãawe'sx dxi'ptey uyna ũste ũ'k. ");
INSERT INTO pbb_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Sa' na'jĩnak we'we: —Adxna na'wẽ yũuk txã'snath adxa' i'kwe'sx yakh nee u'juy pta'sx. Moises ley fxi'jni vxite' Dxus yuwee pta'sxsawe'sx librute fxi'jni vxite' Salmos librute fxi'jni ũsta', adxa's ma'wẽ yũuwa'ja'swa txã' jxuka kxtey yuuna jĩnath pta'sx. ");
INSERT INTO pbb_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Txajũk Dxus librute fxi'jni's isa ew kaajiyu'j, ");
INSERT INTO pbb_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","sa' na'jĩk: —Kristo' uuwa'jsa', nawa tekh ente' ki' ĩtxĩ yuuna uusaawe'sx ksxavxyuh. ");
INSERT INTO pbb_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Aça' txã'wẽ yũuni's Jerusalenu pta'sxya' takhçxa maa maa kiwetewa jxuka pta'sxitxna, kxah nasa' pkaltxi nvxihtçxa Dxus tasxte sxawedte', Kristo' txãawe'sxtxi peltunaĩna jĩna fxi'jni ũsa'. ");
INSERT INTO pbb_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Aça' i'kwe'sxa' adx ma'wẽ yũuçxa ki' ĩtxĩ yuuni's uysaai'kwe na' txã'sa' pta'sxwa'j ji'phi'kwe. ");
INSERT INTO pbb_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Nawa mwẽesẽ'jwe: adx Tata i'kwe'sx jĩi kaajxa' neeyũuk txã'sa' kaja'nja jxpa'gakahn. Nawa txã'sa' jxpa'gamey yu', ay Jerusalentee meswe jxpa'gapkaçx jĩk. ");
INSERT INTO pbb_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Txãa e'su' txãa yakh u'jusawe'sxtxi pe'jna u'kh çxhab eka Betaniate pa'j. Sa' kusetx kiisçxa jxukaysatx bedekĩyku. ");
INSERT INTO pbb_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Txã'wẽ yũuçpkaçxha', cielun pe'jna u'jnik yuu txãawe'sxçxáatx nvxihtçxa. ");
INSERT INTO pbb_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Aça' txãawe'sxa' Jesus yuh yu'ga jĩna weçxana Jerusalen çxhabnay wala wẽtwẽt yajkxna sxawedtxi. ");
INSERT INTO pbb_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Sa' pu'vxitumeetx dxuus yatte Dxusna weçxana nes yu'.");
INSERT INTO pbb_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Nyafxiitey naa kiwe meeíin, Kristo' ũsyã'kh yu'. Txã' Dxus yakhku ũsu', sa' Dxus íiçxáak yu'. ");
INSERT INTO pbb_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Nyafxiiteya' txã'wẽk Dxus yakh ũssa yu'. ");
INSERT INTO pbb_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Dxusa' txã'sna neewe'weçxak kĩjkĩhnawa jxuka kvxiitu'j. Txãa pa'ga naa kiwete kĩjkĩhwa ũssa' jxuka txajx vxitniçxaçxáata'. Dxus yakh ũssa kĩjkĩhnawa vxitmeewaça', kĩh yuhwa mee yuutxna. ");
INSERT INTO pbb_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Uuçxa ki' ĩtxi yuuwa'ja's txãak ji'phu', sa' txãa íiçxáak nasatx eena'te kaafxi'ze'jwa'jsa yu'. ");
INSERT INTO pbb_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Txãa eena'sa' çxhi'dxte kweethku, aça' çxhi'dxsa' fxĩçxhaya' ãjame'. ");
INSERT INTO pbb_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Txãa eena'sa's tuuthe'jsa' teeçx piçthẽ'j Juan yaasesak yu' Dxus kaahni. ");
INSERT INTO pbb_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Txã' txãa eena'te kaafxi'ze'jwa'jsa's tuuthe'jsak yu', maawa txajx tuuthe'jni's wẽse'jçxa Kristo's ũuste jxpa'gakahn. ");
INSERT INTO pbb_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Juan yu' eena'te kaafxi'ze'jwa'jsa meek yu', naasáa eena'te kaafxi'ze'jwa'jsa's tuuthe'jsaçxáak yu'. ");
INSERT INTO pbb_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Naapkaçxha' nasatx eena'te kaafxi'ze'jwa'jsa Kristo' naa kiwete vxyaaççxáak yu'. ");
INSERT INTO pbb_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Sa' vxyaaçxa' naa kiwete fxi'zena ũsu'k. Txã'wẽtewa, naa kiwetewe'sxa' jiyumeeta', makwe txajx vxitnisaçxawa. ");
INSERT INTO pbb_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Txajx vxitni kiwete vxyaatewa, txajx ji'j jĩnisa' jxpa'gameeta'. ");
INSERT INTO pbb_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Makwe txajx ji'j jĩnisa jxpa'gameetewa, maaíi yu' txã's nwẽese'jçxa ũuste jxpa'gatx. Aça' txã'sna jxpa'gasatxi's Dxusa' txajx luuçx yuuwa'ja's ũsku. ");
INSERT INTO pbb_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Txãa pa'ga txãawe'sxa' naa kiwete neywe'sx kakweju kakwe yakh upxhi'tx neywe'sx jxthãasni txã'wẽsameeta', txãawe'sxa' Dxus luuçx yuuna pa'jsata'. ");
INSERT INTO pbb_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Nyafxiitey Dxus yakh ũssa' nasaa kakwe's jxpa'gaçxa kwe'sx yakh ũsu'k, isasaçxá's pta'sxna peeygãhna. Txãa pa'ga kwe'sxa' txajx fxi'zeni wala zhiçxkwesa's uytha'w, txãasa jiitha'w Dxus Nçxi'k teeçxçxáasatewa. ");
INSERT INTO pbb_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Txã'snak Juana' tuuthe'jna na'jĩna we'we: —Adxa' na'snath pta'sxi' i'kwe'sxtxi: Adx e'ste yuja' txã' adx naa kiwete upxmeyna we'sxku yu', txãa pa'ga adxte jxthaakwesa' jĩnak pta'sx. ");
INSERT INTO pbb_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Aça' kwe'sxa' txajx peeygãani makwe ne' yu' txã'sa' jxukatha'w jxpa'ga jxukaysa. ");
INSERT INTO pbb_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Nyafxí' juuna' jxkaahnisa ley Moises nvxihtku txã'sçxáanatha'w jxpa'ga, naapkaçxha' Jesukristo' isa Dxus peeygãani'sku nuypa'j txã'snatha'w jxpa'ga. ");
INSERT INTO pbb_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Nawa maa yuhwa Dxusa's iiuymeeta'. Txã'wẽtewa Dxus Nçxi'k teeçxçxáasa Ney yakh ih ũssa' kwe'sxtxi' kaajiyu'kh Dxus ma'wẽsatewa. ");
INSERT INTO pbb_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Jerusalente judiuwe'sxa' pẽjxya' kaahtx sacerdote vxite' levxitawe'sxtxi Juan kimtewa jiyuya'. ");
INSERT INTO pbb_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Aça' Juana' ãatek pta'sx: —Adxa' Kristomeeth jĩna. ");
INSERT INTO pbb_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Txajũ' ki'kin pẽjxtxi: —Txã'wẽçxa' ¿kimga? ¿Txãniitey Dxus yuwe pta'sxsa Elias wá'ga? jĩte', Juan pasçxa': —Txã'wẽmeeth jĩk. Aça' ki'kin pẽjxtxi: —Dxus yuwe pta'sxsa' pa'jana jĩ'tx txãa wá'ga jĩte': —Txãameeth jĩnak pas. ");
INSERT INTO pbb_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Txajũ' ki' pẽjxtxi: —Txã'wẽçxa' idxa' ¿kimga? Idxa' kĩh yũuna fxi'zesaçxawa mpeeta'sx. Txã'wẽme', kwe'sxtxi jxkaahsatx pta'sxya' u'jwa'j ji'ptha'w jĩte', ");
INSERT INTO pbb_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Juan pasçxa': —Dxus yuwe pta'sxsa Isaiasa' na'jĩnak we'we: Nasa u'pnimée kiwesu sus we'weni pthũusena: Dxus pa'jwa'ja's mpheu'jwe jĩna, nawa adx tuuthe'jna pekũhwa'ja's pta'sxnak txã'jĩ. ");
INSERT INTO pbb_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Juana's paapẽjxya' pa'jsa' fxariseowe'sx kaahnisatx yu', ");
INSERT INTO pbb_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","sa' ki'kin paapẽjxtxi: —Txã'wẽ Kristomeeth, sa' Eliaswa meeth, sa' Dxus yuwe pta'sxsa pa'jana jĩ'tx txãameeth jĩ'g sa' ¿kĩjxa'çxáaga nasatx yu'te bautisaĩ'? jĩte', ");
INSERT INTO pbb_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Juan pasçxa': —Adxa' yu'teçxáath bautisaĩ'. Nawa i'kwe'sx ksxavxyte teeçx ũsa' txã'sa' jiimeene'kwe. ");
INSERT INTO pbb_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Txã' adx e'su vxyaana, nawa txã' adxte jxthaakwesa'. Aça' adxa' txajx pelgatxi tudni wesçxáa yuhtxwa khihbxa' ãhmeekwesath jĩnak pas. ");
INSERT INTO pbb_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Juana' Jordan yu'wala kuteju sek kãani ju'gu Betábara yaasesatek txã'wẽ bautisãyna ũsu', aça' kxteetx txã'wẽ paapẽjxya' pa'jna ũsu'. ");
INSERT INTO pbb_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Kuskuskhẽ' Juana' Jesus yuhte uyçxa', na'wẽk we'we: —Mthegwe, naaíi Dxus kaahni piisxakuẽ', jxukaysa pkaltxi txudewa'jsa. ");
INSERT INTO pbb_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Aça' adxa' txã'sna we'weçxath txã'wẽ pta'sx: Adx e'su teeçx piçthẽ'j vxyaana, txã' adxte jxthaakwesa', txã' naa kiwete adx upxmeyna we'sxku yu' txãa pa'ga. ");
INSERT INTO pbb_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Txã'sa' adxíi yuuwa jiimeeth yu' kimtewa. Nawa Israelwe'sx txã's jiyukahn yu'teçxáawa bautisãyna ũsu'th. ");
INSERT INTO pbb_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Juana' ki'kin we'wek na'jĩna: —Dxus Espiritu's uythu cieluju tub çxihme na'wẽsa Jesus kajkwekhẽ kĩijaçte. ");
INSERT INTO pbb_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Txã'wẽtewa, adxa' nee jiimée íiçxáath yu' kimtewa. Nawa adxa's bautisãyya' kaahsa' pta'sxku: Espiritu's uyuune'ga teeçx piçthẽ'j kajkwete kĩijaçte', aça' txãa piçthẽ'ja' isa Dxus Espiritu's nasaa ũuste kxu'akhe'jsa yuuna jĩnak pta'sx. ");
INSERT INTO pbb_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Aça' ãçxha' uyçxa', jiyuth Dxus Nçxi'ktewa, sa' txã'snath tuuthe'je'. ");
INSERT INTO pbb_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Vxite kuskuskhẽ' Juana' ki' kxtey ũsu'k txãa yakh u'jusa e'zsa yã'jçxa. ");
INSERT INTO pbb_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Sa' Jesus jxkhẽuuçte uyçxa', Juana' na'jĩk: —Mthegwe, naaíi Dxus kaahni piisxakuẽ'. ");
INSERT INTO pbb_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Txã'jĩni's wẽse'jçxa', txãa e'zsa' Jesus e'stey u'jtx. ");
INSERT INTO pbb_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Aça' Jesusa' yu'thegçxa', txajx e'ste yuusatx uyku, sa' na'wẽk pẽjx: —¿Kĩjkwe pakwé'? jĩte', txãawe'sx pasçxa': —Kaapiya'jsa, ¿mteega u'pu'? jĩte', ");
INSERT INTO pbb_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Jesus pasçxa': —Mejkawe thegya' jĩk. Aça' txãawe'sxa' u'jçxa' jiyutx mtee u'psatewa. Sa' txãa yakh kxtee neeyũutx, kusuçyã'kh yu' naa pa'ga. ");
INSERT INTO pbb_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Juan we'weni's wẽse'jçxa Jesus e'stey u'jsa teeçxsa' Adresku yaase yu', Simon Pedro nyakh. ");
INSERT INTO pbb_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Aça' Adresa' txajx nyakh Simon khuẽ'yna nyafxte pta'sxya' u'kh: —Dxus tasxu yuusa Kristo jĩni's yuutha'w uy jĩna. ");
INSERT INTO pbb_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Txajũ' Adresa' txajx nyakh Simona's pe'jna kũjk Jesus ũsnite. Aça' Jesus uyçxa' na'jĩk: —Idxa' Jonas nçxi'k Simon yaaseg, nawa ãçxha' Cefxas yaseni neeyũune'ga. Cefxas yu', Pedro jĩni'. ");
INSERT INTO pbb_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Vxite kuskuskhẽ' Jesusa' Galilea kiwen u'jweççxa', Fxelipe's uyçxa': —Adx yakh myuh jĩnak pi'kx. ");
INSERT INTO pbb_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Fxelipe yu', Beçaida çxhabte u'psak yu', Adres Pedrowe'sxwa txãa çxhabteywe'sxtxi yu'. ");
INSERT INTO pbb_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Aça' Fxelipe' Natanaela's pta'sxya' u'jçxa' na'jĩk: —Moisesa' teeçx piçthẽ'ja' vxyaana jĩnak fxi'j ley librute, aça' Dxus yuwe pta'sxsa txãniiteywe'sxwa txã'snaíiçxáatx tuuthe'jna fxi'j txã'stha'w kwe'sxa' puutx uy. Txãa piçthẽ'ja' Jose nçxi'k Jesusa', Nasaret çxhabtewe'sxa' jĩte', ");
INSERT INTO pbb_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Natanael pasçxa': —Nasarette', ¿maaçxá' nasa ewsa kasejxa' ãjama'k? jĩte', Fxelipe pasçxa': —Mejka wakx thegya' jĩk. ");
INSERT INTO pbb_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Txajũ' Natanael utxaana kũjuçte Jesusa' uyçxa', na'jĩk: —Naa piçthẽ'j yuuçxa' Israel nwe'sx jxpubasamée nasa ewsa yuh yu'ga. ");
INSERT INTO pbb_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Txã'jĩte', Natanaela' pẽjxku: —¿Ma'wẽ yuuçxaga adxa's jiyu? jĩte', Jesus pasçxa': —Fxelipe pa'yameyna, idxa's uythu higwera fxtũu tasxte u'pte jĩte', ");
INSERT INTO pbb_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Natanaela' na'wẽk pas: —Idxa' Dxus Nçxi'kgu, Israelwe'sxtxi jxkaahsa jĩte', ");
INSERT INTO pbb_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Jesusa' na'jĩk: —Txã'wẽ higwera fxtũu tasxte u'pte idxa's uythu jĩteçxáa ¿adx kimtewa jiyuwá'ga? Txã'wẽyã'jçxa', naajũyã'ja' Dxus kaavxya'ja'jnitx wejx walasatx uyuune'ga jĩk. ");
INSERT INTO pbb_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Sa' ki' we'weçxa': —Adxa' isath we'we': cielu phaateçxa ũste', Dxus angeleswe'sxa' kĩhna tejkana ũste uyuune'kwe Dxus Nçxi'k Nasa Yuusáa kajkwekhẽ jĩk. ");
INSERT INTO pbb_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","3","Tekh en skhẽwniite', Galilea kiwesu Kaná çxhabte ptamusáa ũsu'tx. Aça' Jesuswa pi'kxni pa'jçxa ũsu'k, txãa yakh ih u'jusawe'sx yã'jçxa. Jesus njĩ'jwa kxtee ũsu'k, naapkaçxha' vxino pçuute', Jesusa's na'jĩnak pta'sx: —Vxino pçuk jĩk. ");
INSERT INTO pbb_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Aça' Jesusa' na'wẽk pas: —¿Kĩh yũukahnkwe adxa's txã'wẽ pta'sxi'? adx en yuu ãhmeya' jĩte', ");
INSERT INTO pbb_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","njĩ'ja' kxtee selpisaawe'sxtxi na'jĩk: —Txãa ma'wẽ jxkaathe', kxtey myũuwe jĩna. ");
INSERT INTO pbb_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Kxte' seis kiwe mitxh walasatx ũsu'. Txãa yu' judiuwe'sx khweeçxawa'j yu' awnisatx yu'. Mitxh iisa oçxenta meeçxawa cien litro yu' khẽesatx yu'. ");
INSERT INTO pbb_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Txajũ' Jesusa' jxkaakh kxtee selpisaawe'sxtxi': —Naa mitxhsu jxuka yu' uta mawwe jĩte', kxtey yuutx. ");
INSERT INTO pbb_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Txajũ' Jesusa' na'jĩnak we'we txãawe'sxtxi': Naa mitxhte le'çxkuẽ pa'kxçxa boda namu's me'jwe yusya' jĩte', txãawe'sxa' kxtey yuutx. ");
INSERT INTO pbb_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Txajũ' boda namu' tudxçxawa, jiyume' yu'a's txã'wẽ vxino vxitnitewa. Kxtee selpisaawe'sxçxáatx jii yu', yu'a's txã'wẽ vxino vxitnisatewa. Txajũ' boda namu' ptamusa's pa'yaçxa ");
INSERT INTO pbb_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","na'jĩnak we'we: —Maawa vxino ewsa's khuẽ'ytxi nyafxte yusu' pi'kxnisatx, txãa e'sutx vxino açxamée ewsa's yusu'. Nawa idxa' txã'wẽ yũumée vxino wejx ewsa'sgu nmehte yus jĩk. ");
INSERT INTO pbb_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Jesusa' Galilea kiwesu Kaná çxhabtek txã'wẽ kim yuhwa ãjãnimeesa's kaavxya'j. Txã'wẽ yũuçxak txajx ewuni's khiyu'j, aça' txãa yakh u'jusawe'sxa' jiyutx Jesus kimtewa. ");
INSERT INTO pbb_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Txãa e'su' Jesusa' Kapernaum çxhabnak u'j, txajx njĩ'j vxite' txajx nyakhwe'sx, txãa yakh u'jusawe'sx yã'jçxa. ");
INSERT INTO pbb_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Judiuwe'sx fxiesta Paskua en ãjãçte', Jesusa' Jerusalen çxhabna u'kh. ");
INSERT INTO pbb_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Sa' dxuus yatte u'kaçxa', bwey, piisxáa, tub çxihmetx txweyna ũstek uy, vxite' vxyuu yu'pthehna ũssatx. ");
INSERT INTO pbb_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Sa' Jesusa' txã'wẽ yũuna ũste uyçxa', kha'txa pheu'jçxa eka kasxisxku nasa vxite' niimaltxi jxuka. Sa' txã'wẽy vxyuu yu'pthehna ũsni mesatxwa jxuka pũsxku petx vxyu yã'jçxa. ");
INSERT INTO pbb_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Sa' kxtee tub çxihme txweysatxi' na'jĩk: —Naatxi' ayjxu jxuka mkaasxisxwe. Adx Tata yatte' txweyna vxyuu yu'pthehna ũswa'jme'. ");
INSERT INTO pbb_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Txã'jĩte', Jesus yakh u'jusawe'sxa' yajkxtxi Dxus librute na'wẽ fxi'jni's: Dxuus yatte' ewmée yũuni's weh yuhwa peejxmeeth jĩni's. ");
INSERT INTO pbb_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Txajũ' judiuwe'sxa' ũusçxa we'wenatx pẽjx: —Kim jxkaathe txã'wẽ yũuçxawa, kwe'sxtxi mpeeta'sx jĩte', ");
INSERT INTO pbb_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Jesus pasçxa': —Naa dxuus yata's pẽtxtewa, adxa' tekh ente' ki' kiisya' ãjãwa'jsath. ");
INSERT INTO pbb_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Txajũ' judiuwe'sxa' iiweeçx we'wena na'jĩtx: —Naa dxuus yata's kuarenta y seis anxutetx txahna jxã'j, aça' idxa' ¿tekh enteçxáa txajxa' ewuudxijíima'g? ");
INSERT INTO pbb_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Nawa Jesusa' txajx kakwe'sku dxuus yata' jĩna we'we'. ");
INSERT INTO pbb_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Aça' uuçxa ki' ĩtxi yuute', txãa yakh u'jusawe'sxa' yajkxtxi txã'wẽ we'weni's. Sa' Dxus libru' isane' we'we', aça' Jesuswa isasa's íiçxáane' we'we' sũhna ewtxi jiyu. ");
INSERT INTO pbb_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Judiuwe'sx fxiesta ente Jesus Jerusalente ũste', nasa wala kuh jiyutx Jesusa' Dxus tasxu yuusatewa, txã'wẽ kim yuhwa ãjãnimeesa's kaavxya'ja'pha'ga. ");
INSERT INTO pbb_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Nawa Jesusa' txãawe'sx ma'wẽsatewa jxuka jiiyã'kh yu', txãasak txã'wẽ jiyutx sũju'çmée. ");
INSERT INTO pbb_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Txãa nasa' txã'wẽsata' jĩna pta'sxi peejx yu'çme', txãa pa'gatey nasaa ũus yaakxnitx jxuka jiiyã'kh yu' naa pa'ga. ");
INSERT INTO pbb_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Teeçx fxariseo Nikodemo yaasesa u'pu'k. Txã' judiu npiiçthẽ'jsatewe'sxku yu'. ");
INSERT INTO pbb_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Txãa piçthẽ'ja' Jesus tasxte kus pa'jçxa', na'jĩk: Jiitha'w idxa's Dxusne' txã'wẽ kaah, kwe'sxtxi kaapiya'khan. Dxus pu'çxmeewaça', kim yuhwa ãjawa'jsame's kaavxya'ja'jmeena, idx na'wẽg yu' txã's jĩte', ");
INSERT INTO pbb_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Jesusa' na'wẽk pas: —Isath we'we', maawa ki' upxmeeçxa yu', Dxus jxkaahna ũsnite u'kaya' ãjameena. ");
INSERT INTO pbb_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Txã'jĩte', Nikodemo' na'wẽk pẽjx: —Nasa ĩisxyã'jsa' ma'wẽ ki' upxya' ãjakx? Njĩ'j tutxhte ki' u'kaçxa upxya' ãjama'k? jĩte', ");
INSERT INTO pbb_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Jesusa' pta'sxku: —Adxa' naa kakwe upxwa'ja's we'we'çmeeth. Maawa Dxus jxkaanite u'ka wẽeçxa', yu'te vxite' Dxus Espiritute upxwa'ja'sthu txã'jĩ'. ");
INSERT INTO pbb_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Nasaa kakwe' nasaa kakweteyçxáak upxhi', naapkaçxha' Dxus luuçxa' Dxus Espiritutek upxhi'. ");
INSERT INTO pbb_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Maawa ki' upxwa'ja' jĩ'th aça' fxiy yuh txã'wẽ we'we'k sũhna yaakxnu. ");
INSERT INTO pbb_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Wejxa'swa ma'wẽga susni's wẽse'jçxawa, majũ yuhte ki' maa dxi'j u'jweçtewa ya'jiyu'çmée, txã'wẽyku Dxus Espiritute upxni's ya'jiyu'çmée jĩte', ");
INSERT INTO pbb_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikodemo' jiyuya' ãjameeçxa' ki' pẽjxku: —¿Ma'wẽ txã'wẽ yuja' ki' ya'upxhikx? jĩte', ");
INSERT INTO pbb_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Jesus pasçxa': —Idxa' Israelwe'sxtxi kaapiya'jsaçxawa, na'wẽsa yuutxi' ¿jiimeewá'ga? ");
INSERT INTO pbb_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Isath we'we': Dxus Espiritute upxnisa' wejxa na'wẽsaçxá' txã' ma'wẽsatewa iiuythu sa' jiiçxath txã'jĩ'. Nawa i'kwe'sxa' jiyu'çmeei'kwe. ");
INSERT INTO pbb_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Naa kiwetewe'sxtxi we'wena pta'sxte jiyumeeçxa', ¿ma'wẽ jiyuki'kwe cielutewe'sxna pta'sxte'? ");
INSERT INTO pbb_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Maa yuhwa cielute u'kasa yu' meeta', naasáa cielujũ kĩisa yuuçxáa cielute u'kasa', Dxus Nçxi'k Nasa Yuusáa txã' cielutewe'sxa' naa pa'ga. ");
INSERT INTO pbb_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Dxus Nçxi'k Nasa Yuusa's ẽekhẽ a'kxçxa ki'pni yuuna, Moiseswa ma'wẽga nasa u'pnimée kiwete ũsçxa' ul weeswe's fxtũukhẽ a'kxçxa ki'p txã'wẽy, ");
INSERT INTO pbb_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","kxah maawa jxukay txã'sna uyçxa ũuste jxpa'gasa', bagaçxte yuhwa pçuwa'jmée ĩtxi fxi'zewa'ja's ji'phutxna vxitumée. ");
INSERT INTO pbb_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Dxusa' naa kiwete nasatx iiméh wala peeygãhçxa yuuçxáak txajx Nçxi'k teeçxçxáasanawa naa kiwete kaah, kxah maawa txã'sna ũuste jxpa'gaçxa' bagaçxte yuhwa pçumée ĩtxi fxi'zewa'ja's ji'phukahn vxitumée. ");
INSERT INTO pbb_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Dxusa' naa kiwete txajx Nçxi'ka's kaahçxawa, nasatx ewmeete nvxihtxa' kaahme', wejxwa nwe'weya'k kaah. ");
INSERT INTO pbb_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Maawa Dxus Nçxi'ka's ũuste jxpa'gasa', ewteyã'j neeyũutxna. Nawa txã'wẽ Dxus Nçxi'k teeçxçxáasana ũuste jxpa'gasame', ewmeeteyã'j neeyũuwa'jsata'. ");
INSERT INTO pbb_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Maawa ũuste jxpa'gasame', ewmeeteyã'jtx nvxiitni yu', txã'wẽ eena'sa naa kiwete kĩhtewa, ewmeeçxáa yũuna ũsçxa', çxhi'dxteçxáa wejx fxi'ze wẽepa'ga. ");
INSERT INTO pbb_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Sa' maawa jxukay ewmeeçxáa yũuna ũssa', eena'sa's ahçeçxa utxa'çmeeta' eena'te, txãawe'sx ewmée yũuni ãate vxyaakahmen. ");
INSERT INTO pbb_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Nawa ew yũuna fxi'zesa yu' eena'sa's utxa'tx, txãawe'sx ew yũuni' Dxus jxkaahnisatewa ãate vxyaakahn. ");
INSERT INTO pbb_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Txãa e'su' Jesusa' Judea kiwen u'kh txãa yakh u'jusawe'sx yã'jçxa. Sa' kxte' maz en ũsu'k nasatx yu'te bautisãyna. ");
INSERT INTO pbb_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Juanwa bautisãynak ũsu' teeçx ahte Enon yaasesate Salim utxate, txãa ja'dasu yu' ũsu'k naa pa'ga. Aça' Juana' nasa wala kuh yu'te bautisãyku. ");
INSERT INTO pbb_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Karcelte kxupmeynaçxáak txã'wẽ bautisãy. ");
INSERT INTO pbb_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Txajũ' judiuwe'sxa' Juan yakh u'jusawe'sxtxi paapẽjxtxi txã'wẽ bautisãyni's. ");
INSERT INTO pbb_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Aça' txãawe'sxa' Juana's pta'sxtxi na'jĩna: —Kaapiya'jsa, mwẽese'j. Sek kãani ju'gu Jordan yu'wala kutete ũste pta'sxgu txãa piçthẽ'jwa ãçxha' bautisãyna ũsa', aça' nasa jxukay txãa yakhçxaçxáa u'jweçta' jĩte', ");
INSERT INTO pbb_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Juana' na'wẽk pas: —Kim yuhwa txã'wẽ tuuthe'jni yuumeena, Dxus jxkaahnimeesa yu'. ");
INSERT INTO pbb_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","I'kwe'sxa' yaçtey adx pta'sxni's jiiyã'ji'kwe: Adxa' Kristomeeth, naasáa txajx yaçte kaahnisaçxáath jĩni's. ");
INSERT INTO pbb_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Naa ejemplo's mjiyuwe: Ptamu ente' novxio' novxia yakhku u'pu'. Aça' novxio namiku' pukate u'pçxa' wala weçxweçxa yaaki'k novxio we'weni's wẽse'jçxa. Adxwa txã'wẽythu wala weçxweçxa yaaki', Jesusa's tuuthe'jni's wẽse'jçxa. ");
INSERT INTO pbb_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Txã' jweeíiçxáa tuhthesa yuuna u'jwena, naapkaçxha' adxa' jweeíiçxáa ãhmeekwesa yuuwa'th. ");
INSERT INTO pbb_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Cielujũ kĩisa' maatewa jxthaakwe tuhthesa'. Kiwete ũssa' naa kiwetewe'sxta', sa' naa kiwetewe'sxçxá'stxi pta'sxi'. Nawa cielujũ kĩisa' maatewa jxthaakwe tuhthesa'. ");
INSERT INTO pbb_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Txã'wẽçxaíik txajx wẽse'jçxa uyni's pta'sxi', nawa kim yuhwa nwẽese'je'çmeeta' txajx we'weni's. ");
INSERT INTO pbb_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Nawa txajx pta'sxni's maaçxáawa nwẽese'jwaça', Dxusa' isak pta'sxi' sũhna jiyuna pa'jatxna. ");
INSERT INTO pbb_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Txã'wẽ Dxus jxkaahnisa' Dxus kwe'we'jni'sku we'we', txã'sa' Dxusa' txajx Espiritu's makwewa ũsu'k txãa pa'ga. ");
INSERT INTO pbb_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Neya' Nçxi'ka's wedxçxa kĩhnawa jxuka txajx kusete nvxihtku. ");
INSERT INTO pbb_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Aça' maawa Dxus Nçxi'ka's ũuste jxpa'gasa' pçumée ĩtxi fxi'zewa'ja's ji'phutxna. Nawa Dxus Nçxi'ka's nwẽese'jsame' pçumée ĩtxi fxi'zewa'ja's ji'phumeetxna, naasáa Dxus kastigo seena'saçxá's jxpa'gawa'jsata'. ");
INSERT INTO pbb_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Txã'wẽ Jesus tasxte nasa wejx wala utxaate', Jesusa' Juante jxthaakwe bautisãyni's fxariseowe'sxa' jiyutx. ");
INSERT INTO pbb_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Isa yu' Jesusa' bautisaĩ'çme', naasáa txãa yakh u'jusawe'sxçxáatx bautisaĩ'. ");
INSERT INTO pbb_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Nawa txã'wẽ fxariseowe'sx jiyuni's Jesus wẽse'jçxa', Judeajũ kasehna u'kh, Galilea kiwen. ");
INSERT INTO pbb_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Nawa Galilea kiwen u'jweççxa', Samaria kiwegak khẽwna u'jwa'j ji'phu'. ");
INSERT INTO pbb_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Sa' Samaria kiwesu' teeçx çxhab Sikar yaasesa ũsa' txãa çxhab peeku'thek pa'j txãa yakh u'jusawe'sx yã'jçxa. Txãa Sikar çxhaba' Jakob kiwe ũsku txajx nçxi'k Jose's txãa utxatek neeyũ'. ");
INSERT INTO pbb_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Txãa kiwete' Jakoba' txãniitey yu' kutxi'jni kafx nvxihtna ũsu'ne', aça' Jesusa' ẽepxãh wahtxna u'jweççxa', kxteek jxkaaseya' kaçx. ");
INSERT INTO pbb_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Naapkaçxha' teeçx u'y Samariasuwe'sxa' yu' pa'kxya' pa'the', Jesusa' na'jĩk: —Yu' mpeeswe tudxwa'j. ");
INSERT INTO pbb_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Txãapkaçxha' txãa yakh u'jusawe'sxa' çxhabna ũ' weyya' u'jnitx yu'. ");
INSERT INTO pbb_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Aça' txãa u'ya' na'jĩnak pas: —Idxa' judiu nasag, sa' ¿ma'wẽtega ũ'kwe's yu' thãasu'? ũ'kwe' Samariasuwe'sxthu açyuja' jĩk. (Judiuwe'sxa' Samariasuwe'sxtxi ahçeçxa we'we'ççxáa yuhwa meeta'.) ");
INSERT INTO pbb_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Txajũ' Jesusa' pta'sxku: —Dxusa' kĩh ũsya'watewa jiyuçxa txã'wẽy yu' thãassa' kimtewa jiyuwaça', adxa's yu' thãasune'kwe, aça' adxa' yu' pçuwa'jmeesa's peesu'nja jĩte', ");
INSERT INTO pbb_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","txãa u'ya' na'wẽk pas: —Naa kafxa' wala dxiia', aça' idxa' yu' pa'kxwa'j ji'phmeeg. Sa' ¿ma'wẽga ũ'kwe's yu' pçuwa'jmeesa's peesu'nja jĩ'? ");
INSERT INTO pbb_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Kwe'sx yaçgawe'sx Jakobku naa kafxa's phaade yu' pa'kxwa'j, aça' txajx nçxi'kwe'sxwa kxteetx pa'ki' tajkxtxi yuswa'j vxite' txãawe'sx tudxwa'j yã'jçxa. Aça' idxa' ¿kwe'sx yaçgawe'sx Jakobte jxthaakwe wáa walasane'ga? jĩte', ");
INSERT INTO pbb_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Jesus pasçxa': —Jxukay maawa ayte yu'a's tudxsa' yũ'wẽena nes yuutxna. ");
INSERT INTO pbb_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Nawa adx peesni yu'a's tudxçxa', bagaçxte yuhwa yũ'wẽemeetxna. Txãa pa'gatey adx peesni yu'a' txãawe'sx ũuste yu'ĩçh na'wẽ nes yuuna, pçuwa'jmée ĩtxi fxi'zewa'ja's ji'phukahn. ");
INSERT INTO pbb_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Txã'jĩte' txãa u'ya' na'jĩnak pas: —Txã'wẽte', txãa yu'a's mpees, kxah yũ'wẽewame'nja, sa' peena yu' naa kafxte pa'kxya' pa'jme'nja. ");
INSERT INTO pbb_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Aça' Jesus we'weçxa': —I'kwe nmi'a's me'jwe pa'yaya', sa' txãa yakh yuweene'kwe ayte' jĩte', ");
INSERT INTO pbb_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","txãa u'ya': —Nmi' ji'phmeeth jĩnak pas. Txajũ' Jesusa' na'jĩk: —Nmi' ji'phmeeth jĩçxa' isa yuh we'we'i'kwe. ");
INSERT INTO pbb_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Txã'wẽ nyafxíi yu' tahç nmi'i'kwe ji'phu', nawa ãçxwe'sxa' nmi' me', aça' isa yuh we'wei'kwe. ");
INSERT INTO pbb_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Txã'wẽ wẽse'jçxa', txãa u'ya' na'jĩnak pas: —Idxa' Dxus yuwe pta'sxsaíi ne'ga sũju'th. ");
INSERT INTO pbb_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Kwe'sx yaçgathẽ'jwe'sxa' naa vxiçtetx Dxusa's neewe'weya' pkhaakhe'. Nawa judiuwe'sx yu', Jerusalenteçxáa Dxusa's neewe'weya' pkhaakhewa'ja' jĩ'i'kwe jĩte', ");
INSERT INTO pbb_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Jesus pasçxa': —Ew mjiyuwe: naa vxiçte meeçxawa Jerusalenteçxáa Dxusa's neewe'wewa'jme'. Dxusa's mteewa neewe'wewa'j en ãjana. ");
INSERT INTO pbb_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Samariatewe'sxa' Dxusa's ma'wẽ neewe'wewa'ja'swa jiimeei'kwe. Nawa judiuwe'sxa' jiiçxatha'w Dxusa's neewe'we', nwe'wesa' judiu nwe'sxa' naa pa'ga. ");
INSERT INTO pbb_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Dxusa's neewe'wewa'j en ãjana jĩ'th txãa ena' ãjxã'kh. Aça' maawa ĩsxiimée ũusuh jxuka yajkxçxa Dxusa's ũusteçxáa neewe'wesa' ew yuutxna, kwe'sx Tata' txã'wẽ yũuni'sku jxthãasu' naa pa'ga. ");
INSERT INTO pbb_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Dxusa' kwe'sx na'wẽy kakwe ji'phme' na' mtee mteewa ũsa', aça' txã'sna neewe'wesa' ũusuh jxuka yajkxçxa neewe'wewa'ja' jĩte', ");
INSERT INTO pbb_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","txãa u'ya' na'wẽk pas: —Ũ'kwe' jiith Kristo Dxus tasxu yuhna, aça' txãa pa'jçxa jxuka ew pta'sxina jĩte', ");
INSERT INTO pbb_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Jesus pasçxa': —I'kwe yakh puutx we'wena u'psa adxíi Dxus tasxu yuusath jĩk. ");
INSERT INTO pbb_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Naapkaçxha' txãa yakh u'jusawe'sxa' sxawedna pa'jtx. Sa' Jesusa' txã'wẽ txãa u'y yakh puutx we'wena ũste uyçxa', kuh yajkxnatx neeyũu. Nawa ¿kĩjxa'ga txãa u'y yakh puutx we'we'? jĩna maa yuhwa paapẽyi'çmeeta'. ");
INSERT INTO pbb_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Txajũ' txãa u'ya' mitxha's kxtee txahna' u'kh çxhabsu nasatx pta'sxya': ");
INSERT INTO pbb_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","—Naa kiwete ma'wẽ fxi'zeni'swa teeçx piçthẽ'j jiyuk txã'sa' myuhwe thegya'. Txã' Kristo íina jĩna pta'sxte', ");
INSERT INTO pbb_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","çxhabtewe'sxa' thegya' u'jtx Jesus ũsnite pa'j. ");
INSERT INTO pbb_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Naapkaçxha' txãa yakh u'jusawe'sxa' Jesusa's na'jĩnatx we'we: —Idxa', ¿wẽemeegá'? Pan mẽ' jĩna. ");
INSERT INTO pbb_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Nawa Jesusa' na'wẽk pas: —I'kwe'sxa' jiimeei'kwe adx kĩh ũ'wa'j ji'phtewa. ");
INSERT INTO pbb_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Txã'jĩte', puutx paapẽyi'tx txãawe'sx pwe'sx: —Meeçxa' ¿maa nasa puuçya' kũhwá'ntakx? jĩna. ");
INSERT INTO pbb_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Aça' Jesusa' na'wẽk pta'sx: —Adx Tata jxthãasçxa mjĩiya' kaahni's kxtey yuuniçxáa, adx ũ'ni na'wẽsa'. ");
INSERT INTO pbb_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Ũ' thẽ'jwa'j pahz a'tey peejxa' jĩ'i'kwe i'kwe'sxa'. Nawa txã'wẽme'. Mjĩinisu mthegwe wakx, jxuka thẽ'jniyã'j ũsa', aça' pkhakhwa'jçxáa yã'j peejxa'. ");
INSERT INTO pbb_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Pkhakhna mjĩisa' deweni's jxpa'gawa'j ji'pha', aça' txãa pkhakhnisa' pçuwa'jmée ĩtxi fxi'zewa'jsata', kxah uuhsa' pkhakhsa yakh ja'daçxah weçxweçxa yajkxna neeyũutxna e'zíi. ");
INSERT INTO pbb_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Teeçxsa' uja'k, naapkaçxha' vxite' pkhakhe'k jĩni' isa yuja'. ");
INSERT INTO pbb_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","I'kwe'sxa' uuhsameei'kwe, nawa adxa' pkhakhya' kaath vxite nasa uuhnisu jĩk. ");
INSERT INTO pbb_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Txã'wẽ txãa u'y ũ'kwe ma'wẽ fxi'zeni'swa jxuka jiyuk jĩna pta'sxpa'ga, txãa çxhabte nasa kuhsa' Jesusa's ũuste jxpa'gatx. ");
INSERT INTO pbb_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Sa' Jesus ũsnite thegya' pa'jçxa', Jesusa's wala neevxisxatx txãawe'sx yakh kxtee pta'sxna neeyũukahn. Aça' e'z enku kxtee fxi'ze, Dxus yuwe's pta'sxna. ");
INSERT INTO pbb_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Aça' txã's wẽse'jçxa', Jesusa's ũuste jxpa'gasa' jweeíiçxáatx pehna. ");
INSERT INTO pbb_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Sa' txãa u'ya's na'wẽtx we'we: —I'kwe pta'sxniçxá's jiyumée, kwe'sx yuutha'w txajx we'weni's wẽse'jçxa jiyu Dxus tasxu yuusa Kristotewa, maatxwa jxuka nwe'wesa. ");
INSERT INTO pbb_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Txajũ' e'z en skhẽwniijũ', Jesusa' Samariajũ kasehna u'kh Galilea kiweníi. ");
INSERT INTO pbb_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Jesusíi we'weçxawa: Dxus yuwe pta'sxsa' maa yuhwa peekx kiwetey yu' wedxni fxi'ze'çmeeta' jĩk txãasak Galilean u'j. ");
INSERT INTO pbb_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Aça' Galileate pa'the', kxteewe'sx yu' wala weçxana jxpa'gatx, Jerusalen fxiestan u'jsa' uyne'ta Jesusa' ma'wẽ yũutewa txãasatx txã'wẽ yũu. ");
INSERT INTO pbb_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Jesusa' Galilea kiwete pa'kh Kaná çxhabte, yu'a's vxino vxitku nyafxíi kxtee. Aça' kxtey teeçx piçthẽ'j ũsu'k ne'jwe'sxa's jxkaah pu'çxsa. Txã' teeçx nçxi'k wala ãça'sa ji'phu'k Kapernaum çxhabte. ");
INSERT INTO pbb_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Sa' Galileatey Jesus sxawedna pa'jni's jiyuçxa', txãa piçthẽ'ja' puutx uyna kũhçxa', na'jĩnak pxthaa we'we: —Adx yatna mejka, adx nçxi'ka's nuykatxhiya'. Txã'wẽme', uuçyã'ja' jĩte', ");
INSERT INTO pbb_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Jesus pasçxa': —I'kwe'sxa' adx ãjani's kaavxya'ja'jmeete yu', adxa's jiyumeene'kwe kimtewa. ");
INSERT INTO pbb_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Txã'jĩte', txãa piçthẽ'j yu' na'jĩk: —Dud myuh, adx nçxi'k uumeyna. ");
INSERT INTO pbb_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Txajũ' Jesusa' na'jĩk: —Yatna sxawedna me'j. Iidx nçxi'ka' katxhiyã'jçxa ũsa'. Txã'jĩte', txãa piçthẽ'ja' Jesusa' isa yuh we'wene' sũhna yatna sxawedna u'kh. ");
INSERT INTO pbb_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Sa' yatte pa'jaçte', txã'sna selpisaawe'sx pu'thegya' kasehçxa' na'wẽtx pta'sx: —Iidx nçxi'ka' katxhiyã'kh jĩna pta'sxte', ");
INSERT INTO pbb_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","txãa piçthẽ'ja' pẽjxku: —Adx nçxi'k ãçã'sa' ¿ma'wẽga wẽtkuẽ' yajkx? jĩte': —Jũ'na la unatek kakwesek ũçxha jĩnatx pta'sx. ");
INSERT INTO pbb_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Aça' neya' yajkxku txãa oratey Jesusa': Iidx nçxi'ka' katxhiyã'jçxa ũsa' jĩni's. Txajũ' txãa piçthẽ'ja' Jesus kimtewa jiyuçxa' txajx ũuste jxpa'gak, yattewe'sxwa txã'wẽy. ");
INSERT INTO pbb_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Txã'wẽ Judeajũ sxawedna Galileate pa'jçxa ãça'sa's nuykatxhini yakha' e'z usyã'ja' Jesus ãjani's kaavxya'ja'jni'. ");
INSERT INTO pbb_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Txãa e'su' judiuwe'sx fxiesta en ãjaçku yu', aça' Jesusa' Jerusalenna ki' u'kh. ");
INSERT INTO pbb_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Txãa çxhabte' ĩikha'jni yu' ji'phu'tx piisxáa ka'ga'jni vxitx utxate. Txã' Betesda yaase' hebreo yuwete. Ãça'sa pa'jçxa ũswa'j tahç ahtek txudeni yu', yat pwa' na'wẽsa. ");
INSERT INTO pbb_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Kxte' wala kuh ãça'sa ũsu'tx, uyya' ãjasamée, çxida puuplesa, vxite' ẽseya' ãjasamée txã'wẽsatx ũythasna ũsu', yu' ẽseçpkaçxha' kxtee khẽeya' sũhna. ");
INSERT INTO pbb_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Txã'wẽ maa enteya' Dxus angel kĩhçxa yu'a's kẽese'je'k, naapkaçxha' maa yaçte khẽjena txã' jxuka katxhiçxak neeyũ' kĩh wee ji'phçxawa. ");
INSERT INTO pbb_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Kxteea' teeçx piçthẽ'j treinta y oçxo anxu ãça'na ũssak txkaa ũsu'. ");
INSERT INTO pbb_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Aça' txã'sna Jesus uyçxa' txakwe txaçx ãça'na ũste jiyuçxa', pẽjxku: —¿Katxhi wẽega'? jĩte', ");
INSERT INTO pbb_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","ãça'sa pasçxa': —Yu' ẽseçpkaçxha' yu'te adxa's akhwa'jsa kim yuhwa meeta'. Adx khẽe wẽjeçpkaçxha' vxite khuẽ'y khẽje'tx jĩte', ");
INSERT INTO pbb_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Jesusa' na'jĩnak jxkaah: —Kiiteçxa iidx pusçxa deeni's tũ'sçxa me'j jĩçpkaçxha', ");
INSERT INTO pbb_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","naa dudtey txãa piçthẽ'ja' katxhiyã'jçxak neeyũu. Sa' txajx pusçxa deeni's tũ'sçxa u'kh. Nawa judiuwe'sx ki'sni ente txã'wẽ dee pusni's tũ'sçxa u'jweçte uyçxa', ");
INSERT INTO pbb_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","judiuwe'sxa' na'wẽtx pẽjx txãa piçthẽ'j katxhisa's: —Ãçxha' ki'swa'j ena' aça' txã'wẽ tũ'sçxa u'juwa'j ji'phmeeg jĩte', ");
INSERT INTO pbb_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","txãa piçthẽ'ja' pasçxa na'jĩk: —Adxna nuykatxhisaíik txã'wẽ jxkaah: Iidx pusçxa deeni's tũ'sçxa me'j jĩpa'ga txã'wẽ tũ'sçxa u'jweçthu. ");
INSERT INTO pbb_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Aça' judiuwe'sxa' ki'kin paapẽjxtxi: —Txã'wẽ jxkaahsa' ¿kimga yu'? jĩte', ");
INSERT INTO pbb_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","txãa piçthẽ'j katxhisa' jiyuya' ãjame' kim txã'wẽ nuykatxhitewa. Kxteea' nasa wala kuh ũste', txãa katxhisa' jiimeek yu' maa dxi'j kasehçxa Jesusa' u'thewa. ");
INSERT INTO pbb_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Txãa e'su' Jesusa' dxuus yatte txãa piçthẽ'j katxhisa's puutx uyçxa', na'jĩk: —Ãçxha' katxhgu neeyũu na', naa weete jxthaakwe nxussa pa'khamen pa'yajkx mfxi'ze, ewmée yũuna u'jumée jĩte', ");
INSERT INTO pbb_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","txãa piçthẽ'j u'jçxa' judiuwe'sxtxi pta'sxku: —Adxna nuykatxhisa' Jesusga yu' jĩna. ");
INSERT INTO pbb_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Txãa pa'gatx judiuwe'sxa' Jesusa's ahçeçxa ikh wẽe, ki'sni ente txã'wẽ ãça'sa's nuykatxhipa'ga. ");
INSERT INTO pbb_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Txajũ' Jesusa' judiuwe'sxtxi na'wẽk we'we: —Adx Tata' naa entewa mjĩina ũsa', txãa pa'gath adxwa mjĩ'. ");
INSERT INTO pbb_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Txã'jĩte', judiuwe'sxa' jweeíiçxáatx Jesusa's ikh wẽena kiite. Txã'wẽ ki'swa'ja' jĩna jxkaahni leyçxá's nwẽese'jmée adx Tata' Dxusa' jĩ'k na' txãawa Dxus na'wẽysath jĩ'ne' sũhçxatx txã'wẽ ikh wẽena kiite. ");
INSERT INTO pbb_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Txajũ' Jesusa' na'wẽk pta'sx: —Isath we'we', adxa' Dxus Nçxi'kthu, nawa adxçxáa yu' mjĩiya' ãjame'nja. Adx Tata ma'wẽ mjĩite', txajx mjĩini's thegçxa yuuçxáath txã'wẽy mjĩiya' ãja'. ");
INSERT INTO pbb_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Txãa pa'gatey Tata' adxa's peeygãhçxa txãa kĩh mjĩiççxawa jxuka pta'sxi'k adxa's. Txãasa ãçxh uyi'kwe txãate jweeíiçxáa walasatx kaavxya'ja'jana, aça' txãatx uyçxa' i'kwe'sxa' kuh yajkxna neeyũune'kwe. ");
INSERT INTO pbb_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Tata' ma'wẽga uusaatx ĩtxi vxitu', txã'wẽy adxwa ĩtxi vxitu'nja maatxwa. ");
INSERT INTO pbb_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Ãçxha' Tata' yuuwesatx kastigãywa'ja's jxuka adxçxaçxáanak nvxiht, txãasa ãçxha' yuuwesatx kastigãywa'ja's Tata' kim yuhtxwa thegwa'jsame'. ");
INSERT INTO pbb_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Tata'swa ma'wẽta nwẽese'je', txã'wẽy adxnawa jxukaysa nwẽese'khanku txã'wẽ yũu. Adxna nwẽese'jsame' adxna kaahsa Tata'swa nwẽese'jsameeçxa txã'wẽ yuutxna. ");
INSERT INTO pbb_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Isath we'we': Maawa adx pta'sxni's jxpa'yajkx wẽse'jçxa adxna kaahsa's ũuste jxpa'gasa', bagaçxte yuhwa pçumée ĩtxĩ fxi'zewa'ja's ji'phutxna. Txã'wẽ yũusa' ewmeete nvxiitni yuumée, uuwa'ju kutxi'jçxa bagaçxte yuhwa pçumée ĩtxi fxi'zewa'the nvxiitnisa yuuna. ");
INSERT INTO pbb_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Isath we'we': Pçumée ĩtxi fxi'zewa'j en pa'jana jĩ'th txãa ena' ãçxhíia'. Aça' uusaawe'sxa' Dxus Nçxi'k we'weni's wẽse'jçxa kxtey yuusá' ĩtxi fxi'zewa'ja's ji'phutxna. ");
INSERT INTO pbb_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Txãa pa'gatey adx Tata' ĩtxĩ vxit-ya' ãjãwa'ja's ji'pha', sa' adxnawa ũsku txã'wẽ ĩtxi vxit-ya' ãjãwa'ja's. ");
INSERT INTO pbb_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Sa' yuuwesatx kastigãywa'ja'swa adxa'síiçxáak ũs, adxa' Dxus Nçxi'k Nasa Yuusath naa pa'ga. ");
INSERT INTO pbb_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Txã'wẽ Dxus Nçxi'k we'weni pthũusete', uusaawe'sxa' pedaniijũ kasehwa'j en pa'jana jĩna pta'sxte', fxiy yuh we'we'k sũhna yaakxnuwe. ");
INSERT INTO pbb_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Txãa en ãhte', uusaawe'sxa' pedaniijũ ĩtxi yuuçxa kasejetxna, ew yũuna fxi'zesa' ewte u'jya', naapkaçxha' ewmée yũuna fxi'zesa' ewmeete u'jya' ĩtxi yuutxna. ");
INSERT INTO pbb_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Adxçxáa yu' kĩjxa'wa ãjame'nja. Adx Tata jxkaatheçxáath yuuwesatx kastigaĩ'. Adx ũuste peekxçxáa yajkxçxa txã'wẽ yu'çmeeth, txãasa adx kastigãyni' isasata'. Adxna kaahsa ma'wẽ jxthãaste' txãaçxá'sthu kxtey yu'. ");
INSERT INTO pbb_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Adx ma'wẽsatewa kimwa pta'sxwa'jsa ji'phmée peekxçxáa txã'wẽsath jĩte', isa yuhna sũhwa'ja's ya'ji'phu'çme'. ");
INSERT INTO pbb_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Nawa txã'wẽ ãjawa'jsa yuja' jĩna adx ju'gu we'wesa ũsa', aça' adxa' jiith txajx we'weni' isasa yuja'. ");
INSERT INTO pbb_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","I'kwe'sxa' Juan tasxte paapẽjxya' kaaji'kwe, aça' txã' isa yuh pta'sxku adx kimtewa. ");
INSERT INTO pbb_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Adxa' naa kiwetewe'sx adx ju'gu we'weni's peejxmeeth. Nawa i'kwe'sxa' Juan pta'sxni's jiiyã'jçxa', thẽymée ewte neeyũuwa'ja's pakwekahnçxáath txã'jĩ. ");
INSERT INTO pbb_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Juana' eena'te kaafxi'ze'jwa'jsa's tuuthe'jsak yu', aça' i'kwe'sxa' wa'lmée i'kwe Juan pta'sxni's jxpa'gana ũsu' maz ençxáawa. ");
INSERT INTO pbb_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Nawa adxna tuuthe'jna isa pta'sxsa yu' mazwa ji'pthu, Juan pta'sxnite jxthaakwesa. Adx mjĩini' adxna tuuthe'jna isa pta'sxsata'. Na'wẽ mjĩith nawa adx Tata jxkaahniçxáatxthu txã'wẽ yu', Dxus kaahnisa yuh yu'ne' sũjkahn. ");
INSERT INTO pbb_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Txã'wẽy adxna kaahsawa isak pta'sxi' adxa's tuuthe'jna. Txã'wẽtewa, i'kwe'sxa' bagaçxte yuhwa txajx we'weni's iiwẽse'jmeene'kwe, sa' txã'sa' iiuywameene'kwe. ");
INSERT INTO pbb_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Sa' txajx kaapiya'jni'swa i'kwe'sx ũuste ji'phmeene'kwe, txãasa i'kwe jxpa'gaya' ãjã'çmée, adxa's Tata kaathewa. ");
INSERT INTO pbb_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","I'kwe'sxa' jxpa'yajkx i'kwe leeĩ', pçumée ĩtxĩ fxi'zewa'ja's ji'phuya'. Aça' txãa libru' adxa's pta'sxsaíiçxá'. ");
INSERT INTO pbb_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Makwe txã'wẽçxawa, i'kwe'sxa' adx tasxte utxa'çmeei'kwe ĩtxi fxi'zewa'ja's ji'phuya'. ");
INSERT INTO pbb_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Naa kiwete nasa adxa's tuuthe'jni's jxthãasu'çmeeth. ");
INSERT INTO pbb_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Adxa' i'kwe'sxtxi ew jiith, i'kwe'sxa' Dxusa's wedxi'çmée i'kwe. ");
INSERT INTO pbb_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Tata kaathe' yuwe'th, nawa i'kwe'sxa' adxa's jxpa'ga'çmée i'kwe. Nawa Dxus kaahnisamée vxite pa'jwaça', txãa yu'sa' jxpa'gane'kwe. ");
INSERT INTO pbb_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","¿Ma'wẽ yũuçxa adxa's jxpa'gaya' ãjaki'kwe, nasaa pwe'sx puutx ew tuuthe'jniçxáana jxthãasçxa, Dxus teeçxçxáasa tuuthe'jni yu'sa' jxpa'gameeçxa'? ");
INSERT INTO pbb_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Adx Tata tasxte i'kwe'sxtxi ewmée yuwe ũswa'jsana sũjuwá'kwe adxa' txã'wẽmeeth. Txã'wẽ i'kwe'sx ma'wẽsatewa adx Tata tasxte pta'sxsa' Moisesíiçxá', i'kwe'sx nakwe wala ewçxáa we'we'i'kwe txãa. ");
INSERT INTO pbb_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Moises we'weni's jiyuwaça', adxa's jxpa'gane'kwe, Moisesa' adxnaíiçxáak tuuthe'jna fxi'j naa pa'ga. ");
INSERT INTO pbb_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Nawa txajx fxi'jni's jxpa'gameeçxa', ¿ma'wẽ adx we'weni's jxpa'gaya' ãjaki'kwe? ");
INSERT INTO pbb_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Txãa ensu' Jesusa' Galilea ĩkh kuten u'kh, txãa ĩkha's Tiberias jĩ'tx. ");
INSERT INTO pbb_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Txã'wẽ naa kiwete kim yuhwa vxit-ya' ãjanimeesa's kaavxya'ja'jna ãça'satxwa nuyçxhãçxhapa'ga, nasa wala kuh pkhaakhena Jesus e'stey u'jtx. ");
INSERT INTO pbb_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Aça' Jesusa' thã'j vxiçna u'jçxa kxtee kaçxku txãa yakh u'jusawe'sx yã'jçxa. ");
INSERT INTO pbb_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Txajũ' Judiuwe'sx fxiesta Paskua en ãjaçku yu' txãa ensu'. ");
INSERT INTO pbb_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Aça' nasa wala pkhaakhena yuhte uyçxa', Jesusa' Fxelipe's na'jĩnak pẽjx: —¿Mtee ũ' weyuukxtha'w nasa jxukaysatx puuçwa'j? ");
INSERT INTO pbb_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Nawa Jesusa' Fxelipe ma'jĩtewa jiyuya'çxáak txã'wẽ pẽjx, ma'wẽ yũuwa'ja'swa jxuka jiiyã'jçxawa. ");
INSERT INTO pbb_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Aça' Fxelipe' na'wẽk pas: —Dos cientos peso pan weyçxa jxukaysatx pe'ltedeçxa peesu'swaçwa, ãhmeena jĩte', ");
INSERT INTO pbb_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Jesus yakh u'jusa Simon Pedro nyakh Adresa' na'wẽk pta'sx: ");
INSERT INTO pbb_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","—Ayte teeçx kuẽ e'z wedx tahç cebada pan ji'phsa ũsa'. Nawa kxazçxáasa yuja' ¿ãhma'k? jĩte', ");
INSERT INTO pbb_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Jesusa' txãa yakh u'jusawe'sxtxi': Mkaaçxi'jwe jxukaysatx jĩnak jxkaah. Aça' cinko mil piçthẽ'jsa kxaazkuẽesay txaksu kaçxna skhẽwtxi. ");
INSERT INTO pbb_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Aça' Jesusa' pantxi' jxpa'gaçxa', Dxusna weçxana'wa txãa yakh u'jusawe'sxtxi ũsu'sku. Aça' txãawe'sxa' kxaazkuẽesaytxi puuçna skhẽwtxi subapkaçx. Wedxnawa txã'wẽytxi yũu, makwe ũ'çxawa txikpkaçx. ");
INSERT INTO pbb_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Txajũ' jxukaysa txikna skhẽwte', Jesusa' jxkaakh txãa yakh u'jusawe'sxtxi': —Jxuka mepkhakhwe pe'la kijxasaatxi' kĩhwa vxitukahmen jĩte', ");
INSERT INTO pbb_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","doce kanastate utatx pkhakh txãa tahç cebada pan kijxasaatxi'. ");
INSERT INTO pbb_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Txã'wẽ Jesus yuuçxáa maa yuhwa ãjanimeesa's vxitte uyçxa', nasa' na'wẽtx weçxana we'we: —Naa yuuçxá' isa Dxus yuwe pta'sxsa yuh yu'ga, naa kiwete pa'jana jĩ'tx txãaga yu' jĩna weçxaçxa', ãadxijimée jxkaahwa'jsa ki'pxa'watx yu'. Aça' Jesus jiyuçxa', ");
INSERT INTO pbb_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","txãaçxáa txuteena u'kh thã'j vxiçte pa'j. ");
INSERT INTO pbb_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Çxhi'dxna kĩinite', Jesus yakh u'jusawe'sxa' ĩkh pukate kĩhçxa, ");
INSERT INTO pbb_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","barkote khẽena'wa ĩkhuy ktejkana u'jtx Kapernaumte pa'jya'. Txã'wẽ jxuka çxhi'dxni yã'thewa Jesusa' sxawedna kĩhmeyna, ");
INSERT INTO pbb_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","barko ĩkhuy u'jweçpkaçxha', wejxaa wala kiiteçxa ĩkha's seena' wala kẽese'kh. ");
INSERT INTO pbb_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Txã'wẽ seena' yuuçtewa ĩkh pxãhsu jxu'j u'jweççxa', Jesusa's ĩkh kajkwesu yuhte uytxi, sa' wala ũukhtxi. ");
INSERT INTO pbb_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Aça' Jesusa' na'wẽk we'we: —Ũukhnuwe, adxthu jĩte', ");
INSERT INTO pbb_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","wala weçxana jxpa'gatx barkote. Sa' yaakxnimeete naa dudtey ĩkh kutete pa'jtx. ");
INSERT INTO pbb_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","24","Kuskuskhẽ' Jesusa' kxtee meeyã'the', txãa yakh u'jusawe'sxwa meete', nasa' barkote khẽena' u'jtx Kapernaum çxhabna Jesusa's pakweya'. Txã'wẽ Jesus yakh u'jusawe'sx teeçx barkote khẽeçxa u'the', Jesus yu' txãawe'sx yakh u'jmeetewa jiyuçxane'ta pakweya' u'jna ũsu' ĩkh kuteju nasa neeyũusa'. Jesusa' Dxusna weçxaçxa pan puuçku txãa ja'date barko pa'jne'ta Tiberias çxhabuh yuusa, aça' txãatetx khẽeçxa pakweya' u'j. ");
INSERT INTO pbb_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Sa' ĩkh kutete pa'jçxa Jesusa's uyçxa pẽjxtxi: —Idxa' ¿ma'wẽnga ayte pa'j? jĩte', ");
INSERT INTO pbb_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Jesusa' na'wẽk pas: —Isath we'we', i'kwe'sxa' pana's txikpkaçx ũ'çxaçxáa i'kwe txã'wẽ adxa's pakwé'. Nawa adx txã'wẽ maa yuhwa ãjanimeesa's vxitthu txã's yu' jiyuçxa txã'wẽ yu'çmeei'kwe. ");
INSERT INTO pbb_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Txik ũ'çxa fxi'zewa'jçxá's pakwewa'jme', wejxwa ũ' bagaçxte yuhwa pçumée ĩtxi kaafxi'ze'jwa'jsa's pakweewa'ja'. Aça' Dxus Nçxi'k Nasa Yuusa' txã'wẽ pçumée ĩtxi fxi'zewa'ja's ũsu'nja, txã'wẽ yũuwa'ja's adx Tata' ũsku naa pa'ga jĩk. ");
INSERT INTO pbb_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Txã'jĩte', na'wẽtx pẽjx: —¿Ma'wẽ yũukxtha'w Dxus jxkaahnitxi' kxtey yuuna fxi'zeya'? jĩte', ");
INSERT INTO pbb_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Jesusa' pta'sxku: —Dxus jxkaahnitxi' kxtey yuu wẽeçxa', adxa's mpa'gawe, adxa' Dxus kaahnisath naa pa'ga jĩk. ");
INSERT INTO pbb_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Aça' ki'kin pẽjxtxi: —Idxa' Dxus kaahnisane'ga sũhna kwe'sx ew jiyukahn ãçxha' ¿kĩh kaavxya'ja'jya'waga? ");
INSERT INTO pbb_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Kwe'sx yaçgawe'sx manteywe'sxa' nasa u'pnimée kiwesu u'juçxa', ũ' maná yaasesa's ũ'tx. Aça' txã'wẽ yũuni's Dxus librute na'wẽk we'we': Dxusa' cielujũ ũ'a's puuçku jĩ'k. ");
INSERT INTO pbb_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Aça' txã'jĩte', Jesusa' na'wẽk pas: —Isath we'we', cielujũ ũ'a's Moises puuçme'. Cielujũ ũ'a's adx Tatak puuç. ");
INSERT INTO pbb_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Aça' Dxus puuçni ũ' cielujũ kĩisa' naa kiwetewe'sxtxi pçumée ĩtxi kaafxi'ze'jwa'jsa'. ");
INSERT INTO pbb_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Txã'jĩte', na'wẽtx pẽjx: —Kwe'sxtxi jxpe'jsa, cielujũ kĩisa ũ'a's pejka puuçune'ga kwe'sxtxiwa jĩte', ");
INSERT INTO pbb_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Jesusa' pta'sxku: —Ũ' ĩtxi kaafxi'ze'jwa'jsa' adxthu. Aça' maazkuẽesawa adx tasxte pa'jsa' bagaçxte yuhwa wẽemeetxna. Sa' txã'wẽy adxna ũuste jxpa'gasa' peena yu' yũ'wẽemeetxna. ");
INSERT INTO pbb_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Adxa' kimçxawa i'kwe'sxtxi pta'sxyã'th, nawa i'kwe'sxa' makwe uyçxawa, adxa's cielujũ kĩisana sũju'çmée i'kwe. ");
INSERT INTO pbb_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Makwe i'kwe'sx yu' adxa's jxpa'gameetewa, adx jxpe'khan Adx Tata dukhnisawe'sx yu' jxukaysa adx tasxteçxaçxáa pa'jatxna. Aça' maawa adx tasxte pa'jsatxi' ahçemée weçxana jxpa'ga'nja. ");
INSERT INTO pbb_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Txã'wẽ cielujũ kĩhçxawa peekx adx ũus yaakxniçxá's kxtey yuuya' yuwe'çmeeth. Adx Tata ma'wẽ yũukaathe' txã'sçxáanath kxtey yuuya' yuwé'. ");
INSERT INTO pbb_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Adx Tata' adx jxpe'khan dukhnisatxi' teeçxçxáa yuhwa ivxiitu jxthãasu'çme', kxajíi adxa' nmeh ente' ki' ĩtxi vxitu'nja. ");
INSERT INTO pbb_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Adxna kaahsa jxthãasni' na'wẽ': maawa jxukay Dxus Nçxi'ka's ũuste jxpa'gasa' pçumée ĩtxi fxi'zewa'ja's ji'phu jxthãasu'k. Txãa pa'ga txã'wẽ ũuste jxpa'gasatxi' adxa' nmeh ente' ki' ĩtxi vxitu'nja. ");
INSERT INTO pbb_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Txã'wẽ adxíi ũ' cielujũ kĩisath jĩpa'ga judiuwe'sxa' Jesusa's açewe'weya' takhtxi: ");
INSERT INTO pbb_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","—¿Naa pihçíi Jose nçxi'kmeená'? Sa' ¿ma'wẽga cielujũ kĩisath jĩna we'we'? Txã'jĩkahmeníi kwe'sxa' txajx neywe'sxtxi ew jiitha'w. ");
INSERT INTO pbb_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Txajũ' Jesusa' txã'jĩni's jiyuçxa', na'wẽk we'we: —Maa yuhwa txã'wẽ açewe'wen ũswa'j ji'phmeei'kwe. ");
INSERT INTO pbb_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Adxa' Tata jxkaahnisath aça' txãaíi adx tasxte kuutxa'the yuuçxáa txãatxi' jxukaysatx nmeh ente' ĩtxi vxitu'nja. ");
INSERT INTO pbb_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Txã'wẽ yũuwa'ja's Dxus yuwe pta'sxsa librute na'wẽ fxi'jni ũsa': Dxusa' kaapiya'jana jxukaysatx ¿jĩ'çmeená'? Kxajíi maawa adx Tata kaapiya'jni's wẽse'jçxa txajx jxkaahnitx kxtey yuusa yuuçxáa adx tasxte pa'jatxna. ");
INSERT INTO pbb_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Maa yuhwa Dxusa's iiuymeeta'. Adx yuuçxáa Dxus tasxu yuusath na' txã'sna iiuythu. ");
INSERT INTO pbb_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Adxa' isath we'we': Adxa's jxpa'gasa' pçumée ĩtxĩ fxi'zewa'ja's ji'phutxna, ");
INSERT INTO pbb_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","txãasa pçumée ĩtxĩ kaafxi'ze'jwa'jsa ũ'a', adxthu. ");
INSERT INTO pbb_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Kwe'sx yaçga manteywe'sx nasa u'pnimée kiwesu u'juçxa' maná yaasesa's ũ'çxawa, pejka uu ena's ji'phutx. ");
INSERT INTO pbb_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Nawa adxa' cielujũ kĩisa ũ'a'sthu pta'sxi', txã'sna ũ'çxa' uukahmen. ");
INSERT INTO pbb_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Adxíi cielujũ kĩisa ũ' ĩtxisath. Maawa txãa ũ'a's ũ'sa', bagaçxte yuhwa uumée ĩtxi fxi'zewa'ja's ji'phutxna. Aça' ũ' adx ũsu'nja txã' adx kakwe', kxah maa nasawa pçumée ĩtxi fxi'zewa'ja's ji'phukahn txã'wẽ adx kakwe's ũsu'nja. ");
INSERT INTO pbb_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Txã'jĩte', judiuwe'sxa' na'wẽtx puutx ya'paapẽyi': —Naa piçthẽ'ja' ¿ma'wẽ txajx kakwe's kwe'sxtxi puuçya' ãjakx? jĩte', ");
INSERT INTO pbb_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Jesusa' na'wẽk pta'sx: —Adxa' isath we'we': Dxus Nçxi'k Nasa Yuusáa kakwe's ũ'çxa txajx eenawa tudxmeeçxa yu', pçumée ĩtxi fxi'zewa'ja's ji'phumeene'kwe. ");
INSERT INTO pbb_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Aça' maawa adx kakwe's ũ'çxa adx eenawa tudxçxa yuuçxáa pçumée ĩtxi fxi'zewa'ja's ji'phutxna, kxah txã'wẽ yũusatxi' adxa' nmeh ente' ĩtxi vxitu'nja. ");
INSERT INTO pbb_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Txãa pa'gatey adx kakwe' peena yu' kwẽeje'jmeena, aça' adx eewa peena yu' kxũ'wẽ'jmeena. ");
INSERT INTO pbb_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Maawa adx kakwe's ũ'na txã'wẽy adx eenawa tudxsa', bagaçxtewa adx yakh ih ũsuna, aça' adxwa txãa yakh ih ũsu'nja. ");
INSERT INTO pbb_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Tata' adxna kaakh txã' ĩtxĩsa'. Txãa pa'ga adxwa ĩtxĩsath. Aça' adxwa Tata yakh ma'wẽ ĩtxĩsatka'w, txã'wẽy ĩtxĩ fxi'zewa'ja's ji'phutxna maawa adx kakwe's ũ'sa'. ");
INSERT INTO pbb_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Cielujũ kĩisa ũ'a'sthu pta'sxna we'we'. Kwe'sx yaçgawe'sx manteywe'sxa' maná yaasesa's ũ'çxawa pejka uu ena's ji'phutx. Nawa naa ũ'a' txãa maná na'wẽsame'. Maawa naa ũ'a's ũ'çxa', bagaçxte yuhwa pçumée ĩtxĩ fxi'zewa'ja's ji'phutxna jĩnak pta'sx. ");
INSERT INTO pbb_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Jesusa' txã'wẽk pta'sx Kapernaumte judiuwe'sx pkhaakhenite. ");
INSERT INTO pbb_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Aça' txã'wẽ kaapiya'jni's wẽse'jçxa', txãa yakh u'jusawe'sx maaíi yu' na'wẽtx we'we txãawe'sx pwe'sxçxáa: —Na'wẽ pta'sxni', wala thẽya' jiyuwa'j, aça' ma'wẽ yuhwa ya'jiyu'çme'. ");
INSERT INTO pbb_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Nasa jiyumeeçxa kuh jwed we'wena ũste Jesusa' jiyuçxa', na'jĩk: —Adx pta'sxni's jiyumeeçxa ũusçxa yaaki'wá'kwe. ");
INSERT INTO pbb_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Txã'wẽ jiyumée ũsçxawa, Dxus Nçxi'k Nasa Yuusa' cielun teekaçte uyçxa', ¿maa sũjuki'kwe? ");
INSERT INTO pbb_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Na'jĩ'th na': Dxus Espiritu' ĩtxi kaafxi'ze'jsa', aça' txãaçxá'sthu we'wena pta'sxi', naa kiwete ũ'çxa ĩtxĩ fxi'zeni's pta'sxi'çmeeth. Adxa' isath pta'sxi' Dxus yakh ĩtxĩ fxi'zewa'ja's. ");
INSERT INTO pbb_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Nawa maaíi yu' isane' pta'sxi' sũju'çmeei'kwe jĩk. Jesusa' dxiikhẽy jiiyã'kh yu' maa txã'wẽ açeçtewa, sa' kim ikhkahn dukhwa'jsatewa, txãa pa'gak dxiikhẽy txã'jĩna we'we. Sa' ki' we'weçxa': ");
INSERT INTO pbb_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","—I'kwe'sx maaíi yu' açeçte jiiçxath adx Tata kuutxa'the yuuçxáa txãawe'sxa' adx tasxte pa'jatxna jĩna we'we. ");
INSERT INTO pbb_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Jesus txã'wẽ pta'sxteçxáa, txãa yakh u'jusawe'sx maaíi yu' txuteena u'jtx. ");
INSERT INTO pbb_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Txajũ' Jesusa' pẽjxku docesatx: —¿I'kwe'sxwa adxa's txuteeçxa u'jya'wakwe'? jĩte', ");
INSERT INTO pbb_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simon Pedro' na'wẽk pas: —Kwe'sxa' ¿kim yakh u'jwekxtha'w? Idx yuuçxáa pçumée ĩtxĩ fxi'zewa'ja's pta'sxna ũsgu aça'. ");
INSERT INTO pbb_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Txãa pa'gatey kwe'sxa' idxa's jiyutha'w, txãasatha'w idxa' Kristo, Dxus ĩtxisa Nçxi'kne'ga sũju'. ");
INSERT INTO pbb_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Txã'jĩte', Jesus we'weçxa': —Adxa' i'kwe'sx docesatx txhitxhçxa pa'yatewa, teeçxsa' eçxthẽ'j jĩia' jĩnak pta'sx. ");
INSERT INTO pbb_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Jesusa' Simon nçxi'k Judas Iskariote's we'weçxak txã'jĩ, Judas txã'wẽ docesatewe'sxçxawa Jesusa's ikhkahn dukhya'wak yu' naa pa'ga. ");
INSERT INTO pbb_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Txajũ' Jesusa' Galilea kiwesuk u'ju'. Judea kiwesu yu' u'ju wẽeme', kxteea' judiuwe'sx ikhya' pakwenatx ũsu' naa pa'ga. ");
INSERT INTO pbb_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Judiuwe'sx fxiesta wa' vxitni en ãjaçku yu', ");
INSERT INTO pbb_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","aça' Jesus nyakhwe'sxa' na'wẽtx we'we: —Ayte ũsmée Judea kiwen me'j, kxah nasa iidx ju'guh ũssawe'sx uyuutxna idx na'wẽ yũ'g txã'sa's. ");
INSERT INTO pbb_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Maawa ãate tuuthe'j jxthãasuççxa', paaçsu u'jumeena. Na'wẽ kimwa ãjanimeesa's kaavxya'ja'g na' txãatxi' ãate mkaavxya'j maawa uykahn jĩnatx we'we'. ");
INSERT INTO pbb_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Nyakhwe'sxíi yuhwa Dxus Nçxi'kna sũju'çmeene'ta, txãasatx ũuste jxpa'gameeçxa' txã'wẽ we'we. ");
INSERT INTO pbb_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Txajũ' Jesusa' na'jĩnak pta'sx: —Adx u'jwa'j ena' ãhmeya', nawa i'kwe'sx yu' kĩh entewa u'jya' ewuçxáane'kwe. ");
INSERT INTO pbb_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Naa kiwetewe'sxa' i'kwe'sxtxi' açe'çmeeta', nawa adxa's açe'tx, txã'wẽ txãawe'sx ewmée yũuni's ãateth pta'sxi' txãa pa'ga. ");
INSERT INTO pbb_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","I'kwe'sxa' fxiestan me'jçxáawe. Adxa' yuhme'nja, adx u'jwa'j en ãhmeya' aça'. ");
INSERT INTO pbb_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Txã' we'weçxa', Jesusa' Galileatee neeyũuk. ");
INSERT INTO pbb_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Nawa txajx nyakhwe'sx u'jni e'su', Jesuswa fxiestan u'kh, kimwa jiyunimeete. ");
INSERT INTO pbb_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Aça' judiuwe'sxa' na'jĩnatx txãa fxiestate Jesusa's pakwena ũsu': —¿Mtee ũski txãa piçthẽ'ja'? jĩna. ");
INSERT INTO pbb_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Txãa fxiestate' Jesusa's nuywe'wesa yuuçxáatx susna ũsu'. Vxiteíi yu': Jesusa' ewsa yuja' jĩçpkaçxha', vxite yu': Ewmeesa', nasatx ĩsxiina u'jusaçxá' jĩnatx nuywe'we'. ");
INSERT INTO pbb_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Nawa Jesusa's ew we'wesa yu' maa yuhwa ãate yu' we'weçmeeta', judiuwe'sxtxi ũukhçxa. ");
INSERT INTO pbb_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Fxiesta pçuuna u'jweçpkaçxha', Jesusa' dxuus yatte u'kaçxa kaapiya'jya' takhku. ");
INSERT INTO pbb_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Aça' judiuwe'sxa' kuh yajkxnatx ũsu' txãawe'sx pwe'sxçxáa na'jĩna: —Naa piçthẽ'ja' ¿ma'wẽçxa txakwe wala jiina, maa kaapiya'jsa yakh yuhwa u'jusameeçxawa? ");
INSERT INTO pbb_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Aça' txã' we'weni's jiyuçxa', Jesusa' na'jĩnak pta'sx: —Na'wẽth kaapiya'ja' txã' adx peekx yajkxçxa kaapiya'jnisame'. Adxna jxkaakh txajx we'weni'sthu kaapiya'ja'. ");
INSERT INTO pbb_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Maawa Dxus jxthãasni's kxtey yuuwa'jsa ũsçxa', naa kaapiya'jni's jiyuna Dxus we'wenitewa, meeçxa' adx peekxçxáa yajkxçxa kaapiya'jnitewa. ");
INSERT INTO pbb_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Peekíiçxáa yajkxçxa we'wesa', jxtuhthesa yuuwa'jçxá'sku jxthãasu'. Nawa Dxusçxáana tuuthe'jsa', Dxus jxkaahniçxá'sku isa we'wena pta'sxi'. ");
INSERT INTO pbb_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Moisesa' leya's fxi'jçxa ¿i'kwe'sxtxi ũsyuhmeena' wakx? Txã'wẽtewa i'kwe'sxa' maa yuhwa ley jxkaahni's kxtey yu'çmeei'kwe. Txãasa i'kwe adxa's ikhya'çxáa yaaki' jĩte', ");
INSERT INTO pbb_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","nasa' na'wẽtx pas: —Eçxthẽ'j yakh ũsne'ga. ¿Kimga idxa's ikh wẽje'? ");
INSERT INTO pbb_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Txajũ' Jesusa' na'jĩnak we'we: —Ki'swa'j ente teeçx nasa ãça'sa's nuykatxhith txãa pa'gaçxáa i'kwe txakwe susya' kiite. ");
INSERT INTO pbb_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Nawa i'kwe'sx yu' ki'swa'j entewa luuçx pihçtxi cirkuncidaĩ'i'kwe, Moises jxkaahni's nwẽese'jçxa. Naa kxah i'kwe ãça'sa's adx nuykatxhini yu'sa' txakwe susu'. (Nawa ew jiyute yu', Moises txã'wẽ cirkuncidãywa'ja's jxkaahna takhme', jwee yaçgawe'sxtxi txã'wẽ jxkaah.) ");
INSERT INTO pbb_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","I'kwe'sxa' Moises leya's kxtey yuuya' sũhçxa i'kwe ki'swa'j entewa cirkuncidaĩ' luuçx pihçtxi'. Sa' ¿kĩjxa'kwe txakwe ũusçxa' adx teeçx piçthẽ'j ãça'sa's ki'swa'j ente nuykatxhiçxa nvxiitpa'gaçxáa? ");
INSERT INTO pbb_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","I'kwe'sxa' ew jiyumey yu' fxiyfxiyçxáa yajkxna we'wenuwe, naasáa ew jiyuçxa yuuçxáa txã'wẽ dxih yu'ga sũhna we'wewa'ja' jĩnak pta'sx. ");
INSERT INTO pbb_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Txajũ' Jerusalente nasa maaíi yu' na'wẽtx puutx paapẽyi': —¿Naa piçthẽ'ja'síi ikhya' pakwe'çmeetxna'? ");
INSERT INTO pbb_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Txã'wẽ pakweeçtewa, nasaa ksxavxyte yajkxyajkxmée we'wena ũsa', kim yuhwa ma'jĩnimeete. Meeçxa' ¿kwe'sx npiiçthẽ'jwe'sxa' ew yuh jiyuwá'ntakx naa piçthẽ'ja' Dxus tasxu yuusa Kristotewa? ");
INSERT INTO pbb_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Naa piçthẽ'ja' majuwe'sxtewa jiitha'w, aça' isa Dxus kaahni Kristo dxihwaça', txã'sa' txãa kiwejuwe'sxa' jĩni yuumeena jĩnatx we'we'. ");
INSERT INTO pbb_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Aça' Jesusa' dxuus yatte kaapiya'jna ũsíi, sus we'weçxa na'jĩk: —Adxa'sa' jiiyuji'kwe majũwe'sxtewa. Nawa adxa' peekx yuu wẽeçxaçxáa yuwe'çmeeth, Dxus kaahni ayte ũsthu. Txãa yuuçxáa isa we'wesa' txãa kaahsa's yu' i'kwe'sxa' jiyu'çmeei'kwe. ");
INSERT INTO pbb_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Txã'sa' adx yuuçxáa jiith, txajx tasxu kaahni ayte ũsthu naa pa'ga jĩk. ");
INSERT INTO pbb_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Txã'jĩte', tudçxa preesu jxũna u'j wẽetx, nawa kim yuhwa tud yu' meeta', txã'wẽ yũuwa'j en ãhmeyne' yu' naa pa'ga. ");
INSERT INTO pbb_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Txã'wẽtewa, wala kuh jiyutx Jesusa' kimtewa sa' na'jĩ'tx: —Dxus tasxu yuusa Kristo kĩhçxa', ¿naa piçthẽ'the jxthaakwe kĩjkĩhwa kaavxya'ja'jya' ãjãma'k? jĩnatx we'we'. ");
INSERT INTO pbb_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Nasa txã'wẽ Jesusa's tuuthe'jna ũste fxariseowe'sxa' wẽse'jçxa', sacerdote npiiçthẽ'jwe'sx yakh puutx we'weçxa', dxuus yat thegsawe'sxtxi kaahtx Jesusa's tudçxa jxũna yuukahn. ");
INSERT INTO pbb_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Aça' preesu'jya' kaahni's jiyuçxa', Jesusa' na'jĩnak we'we: —Adxna kaahsa tasxna sxawedna u'jya'wath na' i'kwe'sx yakh txaçxmeeçxáa pi'kxna ũsya'wath. ");
INSERT INTO pbb_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Aça' adxa's pakweçxawa uymeene'kwe, txãa pa'gatey adx u'jweçthu kxte' pa'jya' ãjãmeene'kwe naa pa'ga. ");
INSERT INTO pbb_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Txajũ' judiuwe'sxa' na'wẽtx puutx ya'paapẽjxya' takh: —Naa piçthẽ'ja' ¿mtee u'the txã'wẽ kwe'sxa' uymée yuukxtha'w? Meeçxa' ¿judiuwe'sx ũsta' vxite kiwesu griegowe'sx ksxavxysu aça' txãa griegowe'sxtxi wáa pta'sxya' u'jweçnakx? ");
INSERT INTO pbb_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Adxa's pakweçxawa uymeene'kwe, txãa pa'gatey adx u'jweçthu kxte' pa'jya' ãjãmeene'kwe naa pa'ga jĩnak we'we' sa' ¿ma'jĩçxaki'k txã'wẽ we'we'? jĩ'tx. ");
INSERT INTO pbb_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Fxiesta pçuuya' nmeh en yuuçte', Jesusa' yujuçxa na'jĩnak sus we'we': —Maawa yũ'wẽesa ũsçxa', adx tasxte myuhwe tudxya'. ");
INSERT INTO pbb_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Adxa's ũuste jxpa'gasatxi's txãawe'sx ũuste yu' pçuwa'jmeesa kasehna nes yuuna, Dxus librute we'we'k txã'wẽ. ");
INSERT INTO pbb_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Jesusa' txã'jĩna we'weçxa', txã'sna yaakxsa' Dxus Espiritu's jxpa'gawa'ja'sku pta'sxna txã'jĩ'. Txãa ensu' txãa Dxus Espiritu' pa'jmeyku yu', Jesus yuu cielun tejkameyku yu' naa pa'ga. ");
INSERT INTO pbb_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Nasa wala kuh pkhaakhena ũsnite maaíi yu' Jesus pta'sxni's wẽse'jçxa', na'wẽtx we'we: —Naa piçthẽ'ja' isa Dxus yuwe pta'sxsa yuhna jĩ'tx. ");
INSERT INTO pbb_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Aça' vxite yu' na'jĩ'tx: —Na' Dxus tasxu yuusa Kristona jĩ'tx. Nawa vxite we'weçxa': —Galileajũ yuja', ¿Kristo' kasehma'k? ");
INSERT INTO pbb_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Txã'wẽmeeteíik Dxus librute we'weçxa': Kristo' jxkaahsa Davxid nwe'sxçxa', Davxid upxni çxhab Belentey kasejena jĩ'k jĩnatx we'we'. ");
INSERT INTO pbb_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Txajũ' maaíi yu' Jesus ju'gu we'wenatx neeyũu, aça' vxite yu' Jesusa's ahçenatx neeyũu. ");
INSERT INTO pbb_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Aça' maaíi yu' preesu'jçxa jxũna u'j wẽeçxawa, maa yuhwa txã'wẽ yu' yũumeeta'. ");
INSERT INTO pbb_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Dxuus yat thegsawe'sxa' ki'kin sxawedna pa'the', sacerdote npiiçthẽ'jwe'sx vxite' fxariseowe'sxa' na'jĩnatx pẽjx: —¿Mjĩitekwe txãa Jesusa's preesu'jçxa jxũna yuwe'çmée? jĩte', ");
INSERT INTO pbb_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","txãawe'sx pasçxa': —Bagaçxte yuhwa naa piçthẽ'j na'wẽ zhiçxkwe pta'sxi'k txã'wẽsa yu' iiwẽse'jmeetha'w. Txãasatha'w preesu'jmée. ");
INSERT INTO pbb_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Txajũ' fxariseowe'sxa' wẽesxũ we'weçxa', na'jĩtx: —¿I'kwe'sxwa vxitesa na'wẽy ya'ĩsxiijaçwá'kwe? ");
INSERT INTO pbb_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","¿Kwe'sx npiiçthẽ'jwe'sx meeçxawa fxariseowe'sx maaçxá' txãa piçthẽ'j kaapiya'jni's jxpa'gaçxa ũste i'kwe'sxa' jiikwe'? ");
INSERT INTO pbb_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Nawa txãa piçthẽ'ja's nwẽese'jsa' leya's jiimeesata' na' iiméh seena' ewmeesa nwe'wewa'jmeesa yã'tha'. ");
INSERT INTO pbb_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Txã'jĩte', kxtee ũssa teeçx fxariseo Nikodemo yaasesa Jesus tasxte kus pa'jya' u'ju'ga txãa we'weçxa na'jĩk: ");
INSERT INTO pbb_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","—Yuuwesa's pa'yaçxa pẽjxmey yu', kastigãyya' ãjame'nja'w, kwe'sx leya' txã'wẽ jxkaaja'çme' jĩte', ");
INSERT INTO pbb_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","txãawe'sx pasçxa': —¿Idxwa Galileajũwe'sxwá'ga? Dxus libru's mtheg wakx, sa' jiyune'ga: Galileajũ yu', bagaçxte yuhwa Dxus yuwe pta'sxsa iikasehmeeta' jĩnatx açewe'we. ");
INSERT INTO pbb_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Txã'jĩçxa', puutx txuteena u'jtx txãawe'sx yatna. ");
INSERT INTO pbb_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Naapkaçxha' Jesusa' Jerusalenu kasehçxa Oliwos vxiçnak u'j. ");
INSERT INTO pbb_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Sa' kuskus kusíiçxáa dxuus yatte sxawedna pa'kh. Txajũ' nasa jxukaysa utxaate', Jesusa' kaapiya'jya' kaçxku. ");
INSERT INTO pbb_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Txajũ' ley kaapiya'jsawe'sx vxite' fxariseowe'sxa' teeçx u'y kazx yũuna ũste kpajkxçxa Jesus tasxte nuypa'jtx sa' pxãhte txahçxa' ");
INSERT INTO pbb_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","na'jĩtx: —Kaapiya'jsa, naa u'ya's kazx yũuna ũsíin kpajkxtha'w. ");
INSERT INTO pbb_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Txã'wẽ yũusatxi' Moises leya' kwet wãatatahçxak ikhkaja'. Aça' idxa' ¿ma'wẽ jxkaajaki'g? jĩnatx pẽjx. ");
INSERT INTO pbb_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","(Kxtee ãhmée we'wete', paatxhĩ'khya' sũhçxatx txã'wẽ paapẽyi'.) Nawa Jesusa' kĩiçhuçxak kiwete kuseju fxi'ja'. ");
INSERT INTO pbb_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Aça' maz uswa jwee pẽjxte', Jesusa' kaphuteçxa na'jĩk: —I'kwe'sxa' maaçxáawa pkal ji'phmeesa ũsçxa', txãa khuẽ'y naa u'y kakwete kwet mwãatahwe jĩçxa', ");
INSERT INTO pbb_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","ki' kĩiçhuçxa kiwete fxi'kh. ");
INSERT INTO pbb_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Aça' txã'jĩni's wẽse'jçxa': Kwe'sxwa pkalsane'tka'w sũhçxa, kasehna u'jtx teeçxteeçxçxah, nyafxte' jwee ĩisxsa khuẽ'ytxi kaseh. Txã'wẽ jxuka kasehna u'the', txãa u'yçxáak kxtee neeyũu Jesus ũsnite. ");
INSERT INTO pbb_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Aça' Jesusa' kaphuteçxa ley kaapiya'jsawe'sx jxuka kasehna u'jnite' txãa u'yçxáa ũste uyçxa', na'jĩk: —I'kwena paatxhĩ'khsawe'sxa' ¿mteeta yuu? ¿Maawa i'kwe's ewmeete nvxiht-ya' ãjãmeewá'nta? jĩte', ");
INSERT INTO pbb_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","txãa u'ya' na'jĩnak pas: —Maa yuhwa ãjãmeeta' jĩte', Jesusa' na'jĩk: —Adxwa i'kwe's ewmeete nvxihtme'nja. Me'jwe, nawa peena yu' ewmée yũuna u'junuwe jĩk. ");
INSERT INTO pbb_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Ki'kin nasa pkhaakhete', Jesusa' na'jĩnak we'we: —Adxa' eena'te kaafxi'ze'jsath, aça' maawa adx yakh yuusa' eena'te fxi'zewa'ja's ji'phutxna, sa' bagaçxte yuhwa çxhi'dxte fxi'zemeetxna. ");
INSERT INTO pbb_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Txajũ' fxariseowe'sxa' na'wẽtx we'we: —Idxa' peekíiçxáa ya'tuuthe'jna ũsgu aça' txã' kxul yuhna jĩte', ");
INSERT INTO pbb_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Jesus pasçxa': —Makwe peekíiçxá'ntka ya'tuuthe'je', nawa adx pta'sxni' ĩsxiinisame'. Txãa pa'gatey adxa' jiith majũwe'sxçxa' ki' maa dxi'j u'jweççxawa. Nawa i'kwe'sxa' jiimée i'kwe adx majũwe'sxtewa sa' maa dxi'j u'jweçtewa. ");
INSERT INTO pbb_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","I'kwe'sxa' peekx ũus yaakxnijũçxáa i'kwe txã'wẽ we'we', adx isa we'weni's jiyumey. Nawa adxa' jiimeeçxa yu' we'we'çmeeth. ");
INSERT INTO pbb_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Nasa ma'wẽsatewa isa jiyuçxath we'we', Tata' adxa's kaakh txãak ma'wẽ yũuwa'ja'swa adxa's pu'çxhi' txãa pa'ga. ");
INSERT INTO pbb_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","I'kwe'sx leyte' na'jĩ'k: Yuwe's jiisa e'zíi txãa na'wẽçxaçxáa we'wenisaçxáa selpiina jĩ'k. ");
INSERT INTO pbb_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Aça' isa we'wesa teeçxsa' adxíiçxáath. Aça' vxite' adxna kaahsa Tataíiçxá'. ");
INSERT INTO pbb_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Txã'jĩte', fxariseowe'sxa' na'jĩtx: —Iidx Tata' ¿mtee ũsna? jĩte', Jesus pasçxa': —I'kwe'sxa' adxa's jiyu'çmeei'kwe, sa' adx Tatanawa jiyu'çmeei'kwe. Adx kimtewa jiyuwaça', adx Tatanawa jiyune'kwe jĩnak pta'sx. ");
INSERT INTO pbb_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Dxuus yatte ofxreda ãsxni kaja pukate kaapiya'jna ũsçxa', txã'jĩnak pta'sx Jesusa'. Nawa maa yuhwa preesu'jya' ãjãmeeta', preesu'jwa'j en ãhmeyne' yu' naa pa'ga. ");
INSERT INTO pbb_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Jesusa' ki'kin we'weçxa na'jĩk: —Adxa' u'jweçthu, aça' i'kwe'sxa' makwe pakweene'kwe, nawa adxa's uymey i'kwe'sx pkalte uune'kwe. Txãasa adx u'jweçthu kxteea' pa'jya' ãjameene'kwe jĩna we'wete', ");
INSERT INTO pbb_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","judiuwe'sxa' na'jĩtx: —Meeçxa' ¿peekx kusetey uuya'wawáanakx, txãasa wá' adx u'jweçthu kxteea' pa'jya' ãjameene'kwe jĩna we'we'kx? jĩte', ");
INSERT INTO pbb_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Jesusa' pta'sxku: —I'kwe'sxa' aytewe'sxi'kwe, naapkaçxha' adxa' ẽejũwe'sxthu. Aça' i'kwe'sxa' naa kiwetewe'sxi'kwe, naapkaçxha' adxa' naa kiwetewe'sxmeeth. ");
INSERT INTO pbb_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Txã'wẽçxaíith i'kwe'sx pkalte uune'kwe jĩna pta'sxi'. Txã'wẽ Dxus kaahnisa' adxçxáath jĩna pta'sxtewa jiyumée yã'jçxa', i'kwe'sx pkalte uune'kwe jĩna pta'sxte', ");
INSERT INTO pbb_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","na'jĩnatx paapẽjx: —Txã'wẽçxa' ¿idxa' kimga? jĩte', Jesus pasçxa' na'jĩk: —Adxa' kimçxawa nyafxíi pta'sxyã'th. ");
INSERT INTO pbb_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Txãasa wala pta'sxwa'j ji'pthu i'kwe'sx ma'wẽsatewa ãate pta'sxna, txãa pa'gatey adxna kaahsa' ĩsxiisame', aça' adxa' txajx we'weni's wẽse'jçxa txã'wẽ íiçxáath pta'sxi' maawa jiyukahn jĩnak we'we. ");
INSERT INTO pbb_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Txã'wẽ Dxusa' adx Tata' jĩna Jesus pta'sxtewa jiyumeeta'. ");
INSERT INTO pbb_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Txãa pa'gak Jesusa' na'jĩna we'we: —I'kwe'sxa' Dxus Nçxi'k Nasa Yuusa's ẽete txahçxa yuuçxáa jiyune'kwe kimtewa, sa' peekxçxáa yu' we'wemée, wejxwa Tata kwe'we'jniçxá'sne' kaapiya'j sũjune'kwe. ");
INSERT INTO pbb_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Txãa pa'gatey adxna kaahsa', adx yakh ih ũsa', Tata' adxçxáa yu'sa' nvxiitu'çme', txajx jxthãasniçxá'sthu kxtey yu' naa pa'ga jĩk. ");
INSERT INTO pbb_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Txã'jĩna we'wete', nasa kuhsa Jesus ju'gu yuutx. ");
INSERT INTO pbb_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Txajũ' Jesusa' txajx ju'gu yuusaawe'sxtxi' na'jĩnak pta'sx: —Adx kaapiya'jni's jxpubamée nwẽese'jçxa', adx nasa yuuçxa ");
INSERT INTO pbb_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","ewsa's jiyune'kwe, aça' txãa ewsa' ewmeesajũ nwe'wena jĩte', ");
INSERT INTO pbb_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","txãawe'sxa' na'wẽtx pas: —Kwe'sxa' Abrahan ji'tha'w, sa' bagaçxte yuhwa ewmeete yu' fxi'zesameetha'w. Aça' idxa' ¿ma'wẽga ewmeesajũ nwe'weni yuune'kwe jĩna we'we'? jĩte', ");
INSERT INTO pbb_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Jesusa' pta'sxku: —Isath we'we', maawa ewmée yũuna fxi'zesa', ewmeete fxi'zesata'. ");
INSERT INTO pbb_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","I'kwe'sxa' peekx jii i'kwe: selpisa' yat namu na'wẽsame', naasáa peekx nçxi'k yuuçxáa yat namu na'wẽsa'. ");
INSERT INTO pbb_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Txãa pa'ga yat namu na'wẽsa Dxus Nçxi'k txã'wẽ ewmeesajũ nwe'wete yuuçxáa, isa ewmeete fxi'zesamée yuh yuune'kwe. ");
INSERT INTO pbb_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","I'kwe'sxa' Abrahan ji'thewa jiith, nawa adxa's ikh wẽje'i'kwe, adx kaapiya'jni's nwẽese'j wẽemeeçxaçxáa. ");
INSERT INTO pbb_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Adx Tata kwe'we'jniçxá'sthu pta'sxi', naapkaçxha' i'kwe'sxa' i'kwe'sx tata jxkaahniçxá's i'kwe kxtey yu' jĩte', ");
INSERT INTO pbb_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","txãawe'sxa' na'wẽtx pas: —Kwe'sx tata' Abrahana' jĩte', Jesus pasçxa': —Abrahan luuçxwaça', Abrahan na'wẽy yũune'kwe. ");
INSERT INTO pbb_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Txã'wẽtewa, adxna ma'wẽ Dxus kaapiya'the', txã'sçxáath isa pta'sxi'. Nawa i'kwe'sxa' adxa's ikhya' yuuçxáa i'kwe pa'pçxu'. Abrahana' bagaçxte yuhwa txã'wẽ yũume'. ");
INSERT INTO pbb_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","I'kwe'sx tata ma'wẽ yũute', i'kwe'sxwa txã'wẽy i'kwe yũ' jĩte', na'wẽtx pas: —Txã'jĩkahna', kwe'sxa' ¿ptamunimeesa luuçx wá'ntka'w? Kwe'sxa' teeçx tataçxáa ji'ptha'w, txã' Dxusa' jĩte', ");
INSERT INTO pbb_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Jesusa' na'jĩnak we'we: —Isa Dxusa' i'kwe'sx tatawaça', adxa's ahçemeene'kwe, adxa' Dxus tasxu kaahnith yuwé' txãasa ayte ũsthu. Adxa' peekxçxáa yu' yuwe'çmeeth, adxa'sa' Dxusku kaah. ");
INSERT INTO pbb_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Na'swa adx kaapiya'jni's jiyu'çmeei'kwe, txã'wẽ adx we'weni's nwẽese'je'çmeei'kwe, txãasa i'kwe jiyu'çmée. ");
INSERT INTO pbb_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","I'kwe'sx tata', eçxthẽ'ja', aça' i'kwe'sxa' txajx luuçxi'kwe. Txã'wẽçxaíi i'kwe txajx jxthãasni's kxtey yuu wẽje', eçxthẽ'ja' nyafxiitey nasaa kiikhe'jsa' naa pa'ga. Eçxthẽ'ja' bagaçxte yuhwa ewsa's yũ'çme', sa' bagaçxte yuhwa isa we'we'çme'. Txãa yuu txã'wẽesana na' ĩsxiinaçxáak we'we', sa' kaaĩsxiija'jsa'. ");
INSERT INTO pbb_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Nawa adx isa we'weni yu's nwẽese'je'çmeei'kwe. ");
INSERT INTO pbb_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","I'kwe'sxa' ¿maaçxa' adxa's pkalsa' jĩna ukhe'jya' ãjama'kwe? adxa' isasaçxá'sthu pta'sxi' aça'. Adx isasa's kaapiya'jaçte', ¿ma'wẽtekwe adx we'weni's nwẽese'je'çmée? ");
INSERT INTO pbb_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Dxus luuçxa' Dxus we'weni's nwẽese'je'tx. Nawa i'kwe'sxa' nwẽese'je'çmeei'kwe na' Dxus luuçx meei'kwe jĩk. ");
INSERT INTO pbb_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Txajũ' judiuwe'sxa' Jesusa's na'wẽtx açewe'we: —Idxa' Samariajũwe'sxgu, txãasa eçxthẽ'j yakh ũsgu aça' isatha'w txã'jĩ' jĩte', ");
INSERT INTO pbb_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Jesusa' na'wẽk pas: —Adxa' eçxthẽ'j yakh ũsmeeth, naasáa adx Tata's tuuthe'jsaçxáath. Nawa i'kwe'sxa' adxa's açe'i'kwe. ");
INSERT INTO pbb_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Adxa's weçxana tuuthe'jni's pakwe'çmeeth. Nawa teeçx ũsa' adxa's tuuthe'jsa txã' adx ma'wẽsatewa jiia'. ");
INSERT INTO pbb_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Isath we'we': Adx we'weni's kxtey yuusa', bagaçxte yuhwa uu ena's ji'phumeetxna. ");
INSERT INTO pbb_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Txã'jĩte', judiuwe'sxa' na'wẽtx we'we: —Ãçxhtha'w wejx ew jiyu, eçxthẽ'j yakh ũstewa. Abrahana' uuk sa' Dxus yuwe pta'sxsawe'sxwa uutx. Naapkaçxha' idxa' na'jĩ'g: Maawa adx we'weni's kxtey yuuçxa', bagaçxte yuhwa uu ena's ji'phumeetxna jĩ'g. ");
INSERT INTO pbb_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Kwe'sx yaçgawe'sx Abrahana' uuk sa' Dxus yuwe pta'sxsawe'sxwa uutx, aça' idxa' ¿Abrahante jxthaakwesa wá'ga? jĩte', ");
INSERT INTO pbb_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Jesusa' na'wẽk pas: —Adxíiçxáa ya'tuuthe'jna pta'sxi'nja na' txã' selpimeena. Nawa adxa's tuuthe'jsa' adx Tata' txã's i'kwe kwe'sx Dxusa' jĩna we'we'. ");
INSERT INTO pbb_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Nawa i'kwe'sxa' txãa Dxusa's jii yuuwa meei'kwe. Nawa adxa' txã'sa' ew jiith. Txã'wẽ txã'sa' ew jiiçxa jiimeeth jĩ'nja na', i'kwe'sx na'wẽy ĩisxihsa yu'nja. Nawa adxa' ĩsxiimée Dxusa's jiith, sa' txajx jxkaahni's kxteythu yu'. ");
INSERT INTO pbb_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","I'kwe'sx yaçgawe'sx Abrahana' adx naa kiwete pa'jwa'ja's jiyuçxa', wala weçxana yajkxku, sa' kxtey yuuni's jiyuçxa' wejxku wala weçxa. ");
INSERT INTO pbb_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Txã'jĩte', judiuwe'sxa' na'wẽtx weeçx we'we: —Idxa' cinkwenta anxu yuhwa mée ji'phgu, sa' ¿ma'wẽga txã'wẽ Abrahana's uy? jĩte', ");
INSERT INTO pbb_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Jesus pasçxa': —Isath we'we', Abrahan meeíin, adxa' ũsyã'th yu'. ");
INSERT INTO pbb_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Txã'jĩte', judiuwe'sxa' ũusaçxaçxa', Jesusa's kwet wãatatajxa'watx yu'. Nawa Jesusa' txãawe'sx ksxavxysuy dxuus yatu kasehna u'kh, kim yuhwa jiyunimeete. ");
INSERT INTO pbb_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Jesusa' u'jweççxa', teeçx piçthẽ'j naa kiwete upxhí uyya' ãjasame'sku puutx uy. ");
INSERT INTO pbb_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Aça' txãa yakh u'jusawe'sxa' Jesusa's na'wẽtx paapẽjx: —Naa piçthẽ'ja' ¿kĩh yuupa'gaki'k txã'wẽ yafx ji'phmée upxna ũsu'? ¿Txajx pkalpa'ga ma'k txã'wẽ nxus ji'phu, meeçxa' neywe'sx pkalpa'ga wá' txã'wẽ yuu? jĩte', ");
INSERT INTO pbb_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Jesus pasçxa' na'jĩk: —Txajx pkalpa'gawa me', sa' neywe'sx pkalpa'gawa meek txã'wẽ yuu, naasáa Dxus ewuni's ãate kaavxya'ja'khançxáak txã'wẽ yuu. ");
INSERT INTO pbb_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Txãa pa'ga kaahsa mjĩia's ãate kaavxya'ja'jna mjĩiwa'j ji'pthu nee en ũsiyna. Txã'wẽme' kus yã'the', kim yuhwa mjĩiya' ãjameena. ");
INSERT INTO pbb_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Adxa' naa kiwete nee ũsíiçxáawa, nasatx eena'te kaafxi'ze'jwa'jsath. ");
INSERT INTO pbb_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Txã'jĩçxa', kiwe's fxne'sxju tuupha'çxa txãa piçthẽ'j yafxte sxũsxna'wa, ");
INSERT INTO pbb_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","na'jĩnak jxkaah: —Me'j pkhi'kxya' Siloé yu'kafxte. (Txãa Siloea' Jxkaahnisa jĩni'.) Txajũ' txãa piçthẽ'ja' u'jçxa', yafxtxi pkhi'kxku, sa' uyna yã'kh sxawedna kũh. ");
INSERT INTO pbb_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Aça' txajx yat utxasuwe'sx vxite' nyafxíi txã'wẽ yafx ji'phmée upxsatewa ew jiisa' na'wẽtx we'we: —Naa piçthẽ'jí ¿nyafxí' lmusxnu pẽjxna u'psa meená'? jĩte', ");
INSERT INTO pbb_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","maaíi yu': —Txãaíik jĩ'tx. Naapkaçxha' vxite': —Txãa na'wẽ yuh thegu'k, nawa txãame' jĩ'tx. Nawa txãa piçthẽ'j yu': —Adxíith jĩk. ");
INSERT INTO pbb_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Txajũ' pẽjxtxi: —Idx upxnijũjx uyya' ãjameeçxa', ãçxha' ¿ma'wẽ yuuçxaga uyya' ãja'? jĩte', ");
INSERT INTO pbb_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","pta'sxku: —Teeçx piçthẽ'j Jesus yaasesa' kiwe's fxne'sxju tuupha'çxa adx yafxte sxũsxna'wa na'jĩk: Me'j pkhi'kxya' Siloé yu'kafxte jĩte', u'jna'wa pkhi'kxthu, aça' adx yafxa' phatetx aça' uyu'th jĩte', ");
INSERT INTO pbb_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","paapẽjxtxi: —Idxa's txã'wẽ kaahsa' ¿mtee ũsna? jĩte': —Jiimeeth jĩnak pas. ");
INSERT INTO pbb_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Txajũ' txãa piçthẽ'ja's pe'jna u'jtx fxariseowe'sx tasxna. ");
INSERT INTO pbb_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Jesus txã'wẽ kiwe's fxne'sxju tuupha'jçxa uyya' ãjasame's yu'çe'jni' ki'swa'j enne' yu'. ");
INSERT INTO pbb_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Aça' fxariseowe'sxa' ki' paapẽjxtxi txãa piçthẽ'ja's: —¿Ma'wẽ yũuçxaga ãçxha' uyya' ãja'? jĩte', na'jĩnak pta'sx: —Kiwe's fxne'sxju tuupha'çxa adx yafxte sxũsxku, aça' pkhi'kxthu sa' uyya' ãjath jĩk. ");
INSERT INTO pbb_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Txajũ' fxariseowe'sx maaíi yu' na'wẽtx we'we: —Txã'wẽ yũusa' Dxus luuçx meena, ki'swa'j ena's ki'su'çme' na' jĩte', vxite' na'wẽtx we'we: —Pkalsaçxa', ¿ma'wẽ txã'wẽ kim yuhwa ãjãnimeesa's kaavxya'ja'jya' ãjãkx? Txajũ' txãawe'sxíiçxáa txã'wẽ we'weçxa', puutx puiidxi'tx neeyũu. ");
INSERT INTO pbb_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Sa' txãa piçthẽ'ja's ki' paapẽjxtxi: —Iidx yafxa's yu'çe'jsa' ¿kimna sũju'ga? jĩte': —Txã' Dxus yuwe pta'sxsana sũju'th jĩnak pas. ");
INSERT INTO pbb_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Txã'wẽ upxnijũjx uyya' ãjasameeçxawa ãçxha' uyu'th jĩtewa, judiuwe'sx yu' txã'wẽne' yu' sũju'çmeeta'. Sa' txãa piçthẽ'j neywe'sxtxi pa'yaçxa', ");
INSERT INTO pbb_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","paapẽjxtxi: —¿Naa txã'wẽ i'kwe'sx luuçx upxnijũjx uyya' ãjasameena wakx? Sa' ¿ma'wẽ yũuçxaga ãçxha' uyya' ãja'? jĩte', ");
INSERT INTO pbb_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","neywe'sx pasçxa': —Na' kwe'sx luuçx yuja', txã'wẽ upxhíi uyya' ãjasameetewa txã'sa' jiitha'w. ");
INSERT INTO pbb_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Nawa jiimeetha'w ma'wẽ yũuçxane' ãçxha' uyya' ãja'. Sa' kim txã'wẽ yafxtxi' yu'çe'thewa txã'snawa jiimeetha'w. Txã's yuu mpẽjxwe, txã' thẽ'jsayã'ja' na' txãa pta'sxina. ");
INSERT INTO pbb_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Paapẽysatxi' ũukhçxatx txã'wẽçxáa pas. Txã'wẽme' maa txã'wẽ Jesusa' Dxus kaahni Kristo' jĩna tuuthe'jena txã'sa' fxariseowe'sxa' ahçeçxa peena yu' txãawe'sx pkhaakhenite kaapa'ja'jya'méetx ũsu'. ");
INSERT INTO pbb_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Aça' txã'wẽ yuuya'watetx ũukhçxa: Na' thẽ'jsayã'ja' na' txãa pta'sxina jĩnaçxáa pasu'. ");
INSERT INTO pbb_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Txajũ' fxariseowe'sxa' txãa piçthẽ'ja's ki' pa'yaçxa' na'wẽtx we'we: —Dxus dxi'pte ĩsxiimée mpeeta'sx. Kwe'sxa' jiitha'w iidx yafxtxi yu'çe'jsa' pkalsatewa jĩte', ");
INSERT INTO pbb_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","txãa piçthẽ'j pasçxa' na'jĩk: —Pkalsa wáana nawa adxa' jiimeeth. Adxa' na'wẽçxáa jiith: nyafxí' uyya' ãja'çmeeth, nawa ãçxha' uyu'th jĩte', ");
INSERT INTO pbb_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","ki' paapẽjxtxi: —¿Kĩhga yũu? sa' ¿ma'wẽçxah yũuçxaga iidx yafxtxi' yu'çe'j? jĩte', ");
INSERT INTO pbb_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","txã' na'wẽk pas: —Pta'sxyã'th, nawa pta'sxtewa açewe'we'çxáa i'kwe. Sa' ¿kĩjxa'kwe peena pta'sxkaja'? ¿I'kwe'sxwa txãa yakh u'ju wẽje'wá'kwe? jĩte', ");
INSERT INTO pbb_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","na'jĩnatx wẽesxũu: —Idxa' txãa yakh u'jusag. Nawa kwe'sxa' Moises jxkaahni's nwẽese'jsatha'w. ");
INSERT INTO pbb_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Kwe'sxa' jiitha'w Dxusa' Moises yakh puutx we'wek. Nawa txãa thẽ'ja's majũwe'sxtewa jiimeetha'w. ");
INSERT INTO pbb_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Txajũ' txãa piçthẽ'ja' na'wẽk we'we: —Wala yuh fxiya', adx yafxtxi yu'çe'jsa's majũwe'sxtewa i'kwe'sxa' jiyumeete'. ");
INSERT INTO pbb_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Maawa jiitha'w Dxusa' pkalsawe'sx we'weni's pasu'çme', naasáa Dxusna yajkxçxa txajx jxkaahni's kxtey yuusaçxáatxku Dxusa' pasu'. ");
INSERT INTO pbb_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Bagaçxte yuhwa iiwẽse'jmeetha'w upxhíi uyya' ãjasameetx ki' kaauyu'jni yu'sa'. ");
INSERT INTO pbb_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Adx yafxtxi yu'çe'jsa' Dxus kaahnisameewaça', txã'wẽ kaauyu'jya' ãjawa'jmeene' yu' jĩte', ");
INSERT INTO pbb_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","na'wẽtx wẽesxũu we'we: —Idxa' upxhí iidx ũuste pkalçxaçxáa uta ji'ph upxsag na' ¿ma'wẽtega kwe'sxtxi yu'kxpeh wẽje'? jĩna açewe'weçxa', neeutx peena yu' jxpa'gaya'mée. ");
INSERT INTO pbb_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Txajũ' Jesusa' txãa piçthẽ'ja's neeuni's jiyuçxa', ki' puutx uyçxa' na'wẽk pẽjx: —¿Dxus Nçxi'k kimtewa jiigá'? jĩte', ");
INSERT INTO pbb_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","txãa piçthẽ'j pasçxa': —Mpeeta'sx adx jiyukahn jĩna pẽjxte', ");
INSERT INTO pbb_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Jesusa' pta'sxku: —Idxa' Dxus Nçxi'ka's iiuyyã'jg. Adxíith, aça' idxa' txãa yakhgu puutx we'we'. ");
INSERT INTO pbb_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Txã'jĩte', txãa piçthẽ'ja' Jesus tasxte peejxũkweçxa': —Idxa' Dxus Nçxi'k yuh yu'ga sũju'th jĩte', ");
INSERT INTO pbb_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Jesusa' na'jĩnak pta'sx: —Adxa' na'wẽ yuuya'íiçxáath naa kiwete kĩh, uyya' ãjasameeçxawa uyya' ãjãkahn, aça' makwe uysaaçxawa uyya' ãjãkahmén. ");
INSERT INTO pbb_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Txajũ' fxariseowe'sx kxtee ũssa' txã'wẽ wẽse'jçxa', na'wẽtx pẽjx: —Kwe'sxwa uyya' ãjasameewá'ntka'w jĩte', ");
INSERT INTO pbb_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Jesusa' na'jĩnak pta'sx: —I'kwe'sxa' uyya' ãjãsamée dxihwaça', yuuwesamée yuune'kwe. Nawa uyu'tha'w jĩ'i'kwe na', txãa pa'ga Dxus dxi'pte' yuuwesai'kwe jĩk. ");
INSERT INTO pbb_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Isath we'we', maawa piisxáa ka'ga'jni vxitxtey u'kamée, vxite ahte vxitxtemée u'kasa' txã' pesweeta'. ");
INSERT INTO pbb_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Nawa vxitxte u'kasa' piisxáa-thegsaçxa txã'wẽ yuuna. ");
INSERT INTO pbb_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Aça' kxte vxitxte thegsa' vxitxa's phaade'k u'kakahn. Aça' piisxá' jiyu'tx jxpe'jsa we'weni's, txajũ' teeçxteeçxçxah kxsusna pa'yaçxa kxuuphnijũ kutxi'ji'k. ");
INSERT INTO pbb_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Sa' jxuka kasxisxçxa', piisxáa-thegsa' yaçtek u'jwe', aça' piisxa' txajx e'ste wa'lmeetx u'jwe', jxpe'jsa pa'yani's jiyu'ne'ta naa pa'ga. ");
INSERT INTO pbb_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Nawa nasa fxiysa pa'yate yu', u'jmée wejxwa ũphna u'jwe'tx, nasa fxiysa pa'yate jiyuçxatx txã'wẽ ũphu'. ");
INSERT INTO pbb_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jesusa' naa ejemplo's pta'sxnak kaapiya'j, nawa nasa' jiyumeeta' txã'wẽ pta'sxni's. ");
INSERT INTO pbb_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Nasa jiyumeete', Jesusa' na'jĩnak ki'kin pta'sx: —Isath we'we': Adxíi piisxáa u'kani vxitx na'wẽsath. ");
INSERT INTO pbb_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Adx pa'jmeyna yaçte pa'jsa' jxukay ĩsxiisa pesweeçxáatx yu'. Aça' piisxá' ũukhçxa utxaameeta'. ");
INSERT INTO pbb_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Adxíi vxitx na'wẽsath, aça' maawa adx tasxte u'kasa', nwe'weni yuutxna. Txajũyã'ja' ki' kasehn ki' u'kan txã'wẽ yuuna ũsçxawa, sã'jĩni nes yuutxna. ");
INSERT INTO pbb_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Ewmeesa' pesweena ikhna jxuka pebaya'çxáatx pa'ja', naapkaçxha' adxa' bagaçxte yuhwa pçumée ĩtxi fxi'zekahnthu yuwé'. ");
INSERT INTO pbb_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Adxa' piisxaatx ew jxpe'jsath. Aça' ew jxpe'jsa' piisxaatx peeygãhçxa nwe'wepa'gaçxáa txajx ĩtxi fxi'zeni's ivxiituya' ũsa'. ");
INSERT INTO pbb_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Nawa vxyuu pa'gaçxáa piisxaatx thegna ũssa' yu'kh eçx yuhte uyna'wa, piisxaatx thegmée ũphna u'jwe'tx, piisxáa-thegsa meena sa' piisxa' txãa jĩiwa meetxna, txãa pa'gatx txã'wẽ yũ'. Aça' txã'wẽ yũute', yu'kh eçxa' piisxaatx mazwa ikhe'k, naapkaçxha' ĩtxisa yu' ma'wẽwa ũphu'tx. ");
INSERT INTO pbb_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Txã'wẽ vxyuu pa'gaçxáa thegna ũsna, txãasane' ũphna u'jwe' piisxaatxi' thegmée. ");
INSERT INTO pbb_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Adxa' piisxaatx ew jxpe'jsath. Adx Tatawa ma'wẽ adxa's ew jiina aça' adxwa ew jiith Tata's, txã'wẽy adxwa piisxaatxi' ew jiith, aça' adx piisxaawa adxa's jiita'. Adx piisxaatx wedxçxa nwe'weya' adx ĩtxi fxi'zeni's ivxiituya'wath. ");
INSERT INTO pbb_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Txã'wẽy piisxáa vxite ji'pthu ayte kxuuphnimeesa txãatxwa nuypa'ja'nja. Aça' txãawe'sxwa adx pa'yani's nwẽese'jetxna. Txã'wẽ yũute', teeçx ahteçxaçxáa jxuka pkhakhni neeyũutxna teeçx jxpe'jsa yakhçxáa. ");
INSERT INTO pbb_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Txã'wẽ adx ĩtxi fxi'zeni's ya'ivxiituya'wath, nawa ĩtxi yuuwa'ja's ki' jxpa'gaya'wath, txãa pa'gak Tata' adxa's wedxi'. ");
INSERT INTO pbb_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Adx ĩtxi fxi'zeni's kim yuhwa kusa'jya' ãjameena. Adx yuuth peekíi ya'dukhe'. Sa' adx ĩtxi fxi'zeni's ya'dukhçxa uuya'wa ãja'nja sa' ki' ĩtxi yuuwa'ja'swa ki' jxpa'gaya' ãja'nja. Txã'wẽ yũukahnku adx Tata' adxa's kaah. ");
INSERT INTO pbb_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Txã'wẽ we'weni's judiuwe'sx wẽse'jçxa, kuh jwedtxi yajkxna neeyũu. ");
INSERT INTO pbb_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Maaíi yu' na'wẽtx ũusçxawe'we': —¿Kĩjxa'kwe nwẽese'je' eçxthẽ'j yakh ũsçxa luuku we'weni's? jĩ'tx. ");
INSERT INTO pbb_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Naapkaçxha' vxite' na'jĩ'tx: —Eçxthẽ'j yakh ũsçxa', kim yuhwa na'wẽ zhiçxkwe kaapiya'jya' ãjãmeena. Eçxthẽ'jçxa', txã'wẽ uyya' ãjasameetx kaauyu'jya' ¿ãjãma'k? ");
INSERT INTO pbb_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Dxuus yata's txahna jxã'jni's anxu iisatx fxiesta'ja' Jerusalen çxhabte. Sa' txãa fxiestatetx ũsu' nus ente. ");
INSERT INTO pbb_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Naapkaçxha' Jesusa' dxuus yat pwa' Salomon jĩi jĩnisuk pekũhna u'ju'. ");
INSERT INTO pbb_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Aça' judiuwe'sxa' txajx tasxte pkhaakheçxa na'wẽtx pẽjx: —¿Bagaçxpkaçx kwe'sxtxi kaypuba'jna ũsya'waga? Idxa' Dxus tasxu yuusa Kristoçxa', teehwed mpeeta'sx jĩte', ");
INSERT INTO pbb_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Jesusa' na'jĩnak pas: —Pta'sxyã'th, nawa adx we'weni's jxpa'ga'çmeei'kwe. Adx Tata jxkaathe', na'wẽ kĩhwa mjĩ'th, aça' adx mjĩini' ãate kaajiyu'ju'tx adx kimtewa. ");
INSERT INTO pbb_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Adx piisxáa meei'kwe jĩ'th na', isa i'kwe'sxa' txã'wẽsa yuji'kwe. Txãasa i'kwe adxa's jxpa'gaya' wa'lu'. ");
INSERT INTO pbb_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Adx piisxaatx jiith, aça' txãawe'sxa' adx pa'yani'swa wa'lmée nwẽese'je'tx, sa' adx yakh u'jwe'tx. ");
INSERT INTO pbb_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Txãasath txãawe'sxtxi' pçumée ĩtxi fxi'zewa'ja's peesu'. Aça' kim yuhwa adx kusejũ' kusa'jmeena, sa' bagaçxte yuhwa vxitumeetxna. ");
INSERT INTO pbb_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Adx Tata maatewa jxthaakwesak adx kusete dukh, aça' kim yuhwa kusa'jya' ãjameena adx Tata kusejũ'. ");
INSERT INTO pbb_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Tata adx yakha' txãa na'wẽçxaçxáatha'w. ");
INSERT INTO pbb_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Txã'jĩte', judiuwe'sxa' Jesusa's ki' kwet wãatatajxa'watx yu'. ");
INSERT INTO pbb_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Aça' Jesusa' we'wek: —Adx Tata pu'çxte i'kwe'sx dxi'pte mjĩi ewsaçxaçxáa wala kuh kaavxya'ja'th. Aça' adx mjĩi ewsa ¿maaga i'kwe'sxtxi ewmeena' thegu' açkwe adxa's kwet wãatatah wẽje'? jĩte', ");
INSERT INTO pbb_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","judiuwe'sx pasçxa' na'jĩtx: —Ew yũupa'ga txã'wẽ kwet wãatatajxa'wameetha'w. Nasaçxáag, naa kxahg Dxusthu jĩna Dxusa's weeçx we'we', txãa pa'ga txã'wẽ yũuya'watha'w. ");
INSERT INTO pbb_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Txajũ' Jesusa' na'wẽk we'we: —I'kwe'sx leyte i'kwe'sxtxi we'weçxa': Dxus i'kwe ¿jĩ'çmeena'? ");
INSERT INTO pbb_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Jiitha'w Dxus librute fxi'jni's maawa weeçx we'wewa'jme'. Maawa Dxus yuwe's jxpa'gasayã'ja', Dxus i'kwe jĩnak we'we Dxusa'. ");
INSERT INTO pbb_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Nawa adxa' txã'wẽsaçxáameeth. Adxa' Dxus yuu txhitxhçxa naa kiwete kaahnisath, aça' adxa's ¿ma'wẽ Dxusa's weeçx we'we'k Dxus Nçxi'kthu jĩna jĩya' ãjaki'kwe? ");
INSERT INTO pbb_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Meeçxa' adx Tata mjĩi kaahnimeesaçxáatx wáa mjĩina ũsne'tka aça' adx we'wenitxi' jxpa'ganuwe. ");
INSERT INTO pbb_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Nawa adx Tata mjĩi kaahnisatx yuh mjĩite', adx yu's jxpa'gameeçxawa, adx we'weniçxáatxwa miipa'gawe. Txã'wẽ yũuçxaçxáa jiyune'kwe, adx Tata' adx yakh ũsa', aça' adxa' Tata yakh ũstewa. ");
INSERT INTO pbb_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Txã'jĩte', Jesusa's preesu'jçxa jxũna u'j wẽetx. Nawa preesu'jmeyna, kasehna u'kh. ");
INSERT INTO pbb_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Txajũ' Jesusa' Jordan yu'wala kuten u'jçxa', Juan nyafxíi bautisãyna ũsu'k kxteek ũsu'. ");
INSERT INTO pbb_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Aça' nasa wala kuh thegya' pa'jçxa', na'wẽtx we'we: —Juana' kim yuhwa ãjanimeesatx kaavxya'ja'jmeeçxawa, pta'sxku naa piçthẽ'j pa'jçxa ma'wẽ yũuwa'ja'swa, aça' txã' ĩsxiinimée jxuka kxtey yuuk jĩ'tx. ");
INSERT INTO pbb_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Txajũ' kxtee ũssa nasa' wala kuhsa Jesus kimtewa jiyutx. ");
INSERT INTO pbb_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Betania çxhabte teeçx piçthẽ'j Lasaro yaasesak ãçã'na ũs yu', npe'sxwe'sx Maria Marta u'pni çxhabte. ");
INSERT INTO pbb_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Txãa ãçã'sa npe'sx Mariak txã'wẽ Jesus çxidakhẽ wẽt putasa's awçxa txajx dxkhasju adxi'jwa'jsa yu'. ");
INSERT INTO pbb_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Txãawe'sxa' pxakhíitx dxiy ãçã'na ũste', Jesusa's pta'sxkahn yuwe kaah: —Iidx namiku wedxnisa' wala ãçã'na ũsa' jĩna. ");
INSERT INTO pbb_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Txajũ' Jesusa' naa pta'sxni's wẽse'jçxa' na'jĩk: —Na'wẽ ãçã'na ũsçxawa, uuwa'jsa meea'. Naasáa Dxus ãjãni's ãate kaavxya'ja'jna, txã'wẽy Dxus Nçxi'k ãjani'swa kaavxya'ja'khançxáa txã'wẽ ãçã'na ũsa'. ");
INSERT INTO pbb_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Aça' Marta Maria txãawe'sx dxiy Lasaro yakha' Jesus wedxnisatx yu'. ");
INSERT INTO pbb_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Nawa Lasaro' wala ãçã'na ũsa' jĩna pta'sxni's wẽse'jçxawa, nee e'z eníik txajx u'junisu jxthẽeyũu. ");
INSERT INTO pbb_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Txãa e'z en skhẽwniijũ', Jesusa' na'jĩnak we'we txãa yakh u'jusawe'sxtxi: —Judea kiwen ki' u'jwega jĩte', ");
INSERT INTO pbb_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","txãawe'sxa' na'wẽtx pas: —Kaapiya'jsa, mwẽese'j. Txãwãsu' judiuwe'sxa' idxa's ikh wẽeçxa kwet wãatatajxa'watx yu', aça' ¿ma'wẽga kxtey ki' u'j wẽje'? jĩte', ");
INSERT INTO pbb_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Jesusa' na'wẽk pas: —Isa ena' doce ora ¿ji'phmeena'? Maawa en u'juçxa' yu'spẽ'themée fxi'zetxna, eena' kweethniitene'ta fxi'ze' naa pa'ga. ");
INSERT INTO pbb_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Nawa kus u'juçxa', yu'spẽ'thetxna, eena' kweethnite u'jupa'gamée. ");
INSERT INTO pbb_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Txajũ' na'jĩk Jesusa': —Kwe'sx namiku Lasaro' deeni', nawa adxa' fxĩtxya' u'jwe'nja jĩte', ");
INSERT INTO pbb_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","txãa yakh u'jusawe'sxa' na'jĩtx: —Deeniçxáa ũsçxa yu', fxĩtxte' kiiteena jĩtx. ");
INSERT INTO pbb_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Lasaro' uuni ũstek Jesusa' txã'wẽ we'we. Nawa txãa yakh u'jusawe'sxa' jiyumeeçxa', ĩ'née deenisaçxá'sne' we'we' sũju'ne'ta. ");
INSERT INTO pbb_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Txajũ' Jesusa' teehwedku ãate pta'sx: —Lasaro' uuni' jĩna. ");
INSERT INTO pbb_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","I'kwe'sxa' adx ãjani's uyçxa' adx kimtewa jiyukahn, ewçxá'ntka kxtee ũsu'çmée. Txã'wẽ uuniyã'j ũstewa, thegya' u'jwega jĩte', ");
INSERT INTO pbb_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Tomas melxisu jĩ'tx txã' na'wẽk we'we vxite pi'kxna u'jusawe'sxtxi: —Kwe'sxwa u'jwega Jesus yakh ja'da uuya' jĩk. ");
INSERT INTO pbb_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Jesus kxtee pa'jaçte', Lasaro's pedaní pahz enyã'kh yu'. ");
INSERT INTO pbb_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Aça' Betania çxhaba' Jerusalen çxhabuh e'z kilometro y medioçxáak jxu'kha ũsu'. ");
INSERT INTO pbb_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Aça' judiuwe'sxa' wala kuh pa'khu'ta txã'wẽ dxiy uute', npe'sxwe'sxtxi kvxiisxa'jya'. ");
INSERT INTO pbb_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Aça' txãa entey Jesusa' pa'jaça' jĩni's jiyuçxa', Marta' puutx uyya' kasejk. Nawa Maria' yatte neeyũuk. ");
INSERT INTO pbb_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Txajũ' Marta' Jesus yakh puutx uyçxa' na'jĩnak we'we: —Idx ayte ũssawaça', uuwa'jmeene' yu' ũ'kwe dxi'sxa'. ");
INSERT INTO pbb_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Nawa jiith Dxusa' jxuka ũsuna idx kĩh pẽjxtewa jĩte', ");
INSERT INTO pbb_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Jesusa' na'wẽk pas: —I'kwe dxiya' ĩtxi yuuna jĩte', ");
INSERT INTO pbb_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Marta' na'wẽk pas: —Ũ'kwe' jiith, uusaawe'sx ĩtxi yuu ente' ĩtxi yuuyujuna. ");
INSERT INTO pbb_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Nawa Jesusa' na'jĩk: —Adxíi uuniitewa ĩtxi vxit-sath, sa' pçumée ĩtxi fxi'zewa'ja'swa adxíi peessath. Maawa adxa's ũuste jxpa'gasa' makwe uuçxawa ki' ĩtxi yuutxna. ");
INSERT INTO pbb_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Aça' maawa nee ĩtxi ũssa' adxna ũuste jxpa'gaçxa', bagaçxte yuhwa uuwa'jmée ĩtxi fxi'zetxna. Adx we'weni' isa yuhtxna ¿sũju'kwe'? jĩte', ");
INSERT INTO pbb_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Marta pasçxa': —Txã'wẽ yuhna sũju'th. Idxa' Kristog, Dxus Nçxi'k naa kiwete kĩisa jĩk. ");
INSERT INTO pbb_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Txã'wẽ we'wena jxã'jçxa', Marta' yatna sxawedna u'kh nyakha's pa'yaya'. Sa' na'jĩnak susmée we'we: —Kaapiya'jsa ayte yã'j ũsa', sa' i'kwe's yuu kaakh. ");
INSERT INTO pbb_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Txã'jĩ'çpkaçxha', Maria' kiitena' wala dud u'kh Jesusa's puutx uyya'. ");
INSERT INTO pbb_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Jesusa' Betania çxhabte u'kameyku yu', Marta yakh mteene' puutx uy kxtee nee ũsiyçxáak yu'. ");
INSERT INTO pbb_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Aça' Maria' kiiteçxa wala dud skhẽwte', judiuwe'sx txãa yatte kvxiisxa'jna ũssa' e'stey u'jtx, pedaní kafxte wáa ũ'neya' u'jweçna sũhçxa. ");
INSERT INTO pbb_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Txajũ' Maria' Jesus tasxte kũhna'wa, peejxũkweçxa na'wẽk we'we: —Kwe'sxtxi jxpe'jsa, idx ayte ũssawaça', ũ'kwe dxi'sxa' uuwa'jmeene' yu' jĩnak we'we. ");
INSERT INTO pbb_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Txã'wẽ Maria vxite' judiuwe'sx pi'kxna yuusa ũ'neçte Jesusa' uyçxa', txãawa wala nxusçxa' ");
INSERT INTO pbb_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","pẽjxku: —¿Mteekwe pedáa? jĩte': —Myuh wakx thegya' jĩtx. ");
INSERT INTO pbb_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Aça' Jesusa' ũ'nek. ");
INSERT INTO pbb_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Txã'wẽ Jesus ũ'neçte uyçxa', judiuwe'sxa' na'jĩtx: —Mthegwe ma'wẽga wala peeygãja'. ");
INSERT INTO pbb_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Nawa maaíi yu' na'wẽtx we'we: —Naa piçthẽ'ja' uyya' ãjasameetxwa kaauyu'ju'k na' ¿kĩhçxáawa yũuya' ãjawa'jmée ma'k yu' Lasaro uukahmén? ");
INSERT INTO pbb_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Txajũ' Jesusa' ki'kin wala nxusna utxaak Lasaro's pedaní kafxte. Txãa kafxa' dxiiga pwa'ja'nik yu', aça' u'kani vxitxte yu' kwetku aphni yu'. ");
INSERT INTO pbb_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Jesusa' na'wẽk jxkaah: —Aphni kweta's mkiiswe jĩte', uusáa npe'sx Marta' na'jĩk: —Uuníi pahz enyã'ja', aça' phadete' ¿kazx putameema'k? jĩte', ");
INSERT INTO pbb_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Jesus we'weçxa': —Adx pta'sxnitxi' txã'wẽ yuhna sũhna ũuste jxpa'gaçxa', Dxus ma'wẽsatewa jiyune'kwe ¿jĩçmeetka'? ");
INSERT INTO pbb_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Txã'jĩte', txãa aphni kweta's kiistxi. Aça' Jesusa' cielute pagayçxa na'wẽk we'we: —Tata, adx pẽyni's pasu'g naa pa'ga weçxa'th. ");
INSERT INTO pbb_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Adxa' jiith, idxa' bagaçxtewa adxa's pasu'g. Nawa txã'jĩna ãateth weçxá', ayte nasa ũsta' txãawe'sx wẽse'jçxa', adxa'sa' Dxus kaahni yuh yu'ne' sũjkahn. ");
INSERT INTO pbb_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Txã'jĩçxa', Jesusa' susku we'we: —Lasaro, txãajũ mkaaseh jĩçpkaçxha', ");
INSERT INTO pbb_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","uusá' ĩtxi yuuçxa kasejk, çxida, kuse petx dxi'p yã'jçxa yapni. Aça' Jesusa' khibkaakh u'jya' ãjãkahn. ");
INSERT INTO pbb_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Uusá's ĩtxi vxitni's uyçxa', Maria's pi'kxna ũssa judiuwe'sxa' Jesusa's ũuste jxpa'gaçxatx neeyũu. ");
INSERT INTO pbb_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Nawa vxite judiuwe'sx açesa yu' fxariseowe'sx tasxna u'jçxa', Jesus txã'wẽ uusá's ĩtxĩ vxitni's pta'sxtxi. ");
INSERT INTO pbb_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Aça' fxariseowe'sxa' sacerdote npiiçthẽ'jwe'sx yakh pkhaakheçxa', na'jĩnatx puutx we'we: —Naa piçthẽ'ja' naa kiwete kim yuhwa ãjanimeesatx kaavxya'ja'jna kĩjkĩhwa yũuna ũsa'. Aça' ¿kĩh yuukxtha'w? ");
INSERT INTO pbb_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Txãa piçthẽ'ja's kĩhçxáawa yũumeete', nasa' jxukay txãa yakhçxaçxáa u'jwetxna. Aça' Romajũ nasa kwe'sx dxuus yata's ivxiituçxa', kwe'sxtxiwa ivxiitutxna. ");
INSERT INTO pbb_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Txajũ' txãa anxute sacerdote npiiçthẽ'j Kaifxasa' na'wẽk we'we: —I'kwe'sxa' ũus yajkxya'çxáa yuhwa ãjã'çmeei'kwe. ");
INSERT INTO pbb_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Kwe'sx ji'j jxuka yu' vxitukahmen wejxwa jxukasa pa'gate teeçx yuuçxáa vxituwaççxáa wejx ewna. Txã'wẽ yũuwa'ja's ũus yajkxya' i'kwe ãja'çmée. ");
INSERT INTO pbb_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Kaifxasa' txãa anxute' sacerdote npiiçthẽ'kh yu', sa' peekxçxáa txã'wẽ yajkxçxa we'wemeene'. Jesusa' judiuwe'sx jxukaysa pa'gate txãaçxáa uuwa'thene' Dxusa' Kaifxasa's txã'wẽ we'wewa'ja's kaaũusuthe'j. ");
INSERT INTO pbb_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Nawa judiuwe'sxtxi nwe'weya'çxáameene' txã'wẽ uuya'wa yu'. Dxus luuçx mtee mteewa ũstxna txãawe'sxtxiwa pkhakhya'k txã'wẽ uuya'wa yu'. ");
INSERT INTO pbb_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Aça' txãajũjx judiu npiiçthẽ'jwe'sxa' Jesusa's ikhya' puutx we'wetx. ");
INSERT INTO pbb_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Txãa pa'gak Jesusa' Judiuwe'sx ksxavxysu u'juya' ãjãmeeçxa', Judea kiwejũ kasehna u'j txãa yakh u'jusawe'sx yã'jçxa teeçx çxhab nasa u'pnimée ja'dasu Efxrain yaasesa ũsu'k kxtee ũsya'. ");
INSERT INTO pbb_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Txajũ' Judiuwe'sx fxiesta Paskua en ãjaçku yu'. Aça' wala kuh nasa' u'jtx Jerusalenna, Paskua fxiesta ãhmeyna txãawe'sx kakwete pkaltxi yaateçxa ũsya'. ");
INSERT INTO pbb_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Kxte' Jesusa's pakwena yã'jtx ũs yu' sa' dxuus yatte na'wẽtx puutx paapẽyi': —¿Ma'jĩki'kwe? Jesusa' fxiestate ũsya' ¿yuhmanx? ");
INSERT INTO pbb_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Txajũ' fxariseowe'sx vxite' sacerdote npiiçthẽ'jwe'sxa' neewe'wetx maaçxáawa Jesusa' fxiestate ũste jiyuçxa' txãawe'sxtxi pta'sxkahn tudxa' kaajxa'. ");
INSERT INTO pbb_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Paskua fxiesta ãjxa' seis en peejiyna, Jesusa' Betania çxhabna u'kh, Lasaro uuniitewa ĩtxi vxitku kxtee. ");
INSERT INTO pbb_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Kxteea' ũ'wa'j pheu'jtx Jesusna weçxana, naapkaçxha' Marta yu' puuçuçsak yu'. Aça' Lasaro' Jesus yakh kaçxku ũ'ya'. ");
INSERT INTO pbb_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Txajũ' Maria' teeçx libra ãjk wẽt putasáa wala pa'gasa's jxũna pa'jçxa', Jesus çxidakhẽ sxũsxçxa', txajx dxkhasjuk adxi'. Aça' yat dxiite txãa wẽt putasaçxáa jxuka utak. ");
INSERT INTO pbb_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Txajũ' Jesus yakh u'jusa Simon nçxi'k Judas Iskariote yaasesa' Jesusa's ikhkahn dukhwa'jsa' na'wẽk we'we: ");
INSERT INTO pbb_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","—¿Ma'wẽteki'k naa u'ya' wẽt putasa's tres cientos pesote txweyçxa nasa puuplesatx peesu'çmée? jĩk. ");
INSERT INTO pbb_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Nawa Judasa' puuplesatx pees jxthãasçxa txã'jĩçme'. Txã' vxyuu jxaawsak yu', nawa vxyuu pkhakhnitx kim yuhwa jiyunimée paaçte nkuutxi'ji'u'ga, txãasak txã'wẽ we'we'. ");
INSERT INTO pbb_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Txajũ' Jesusa' na'wẽk we'we: —Naa u'ya's txã'wẽ yuja' we'wewa'j ji'phmeeg. Naa wẽt putasa's adx kakwe's pedaaçtewe'sxku jxaawni ji'phu'. ");
INSERT INTO pbb_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Puuplesa' bagaçxtewa i'kwe'sx yakh nes yuutxna. Nawa adxa' jwee yu' i'kwe'sx yakh nes yuuwa'jsameeth jĩnak pta'sx. ");
INSERT INTO pbb_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Jesusa' Betaniate ũsa' jĩni's jiyuçxa', judiuwe'sx wala kuhsa pkhaakheçxa Jesusa's thegya' txãa çxhabna u'jtx. Nawa Jesusçxá's thegya' u'jmée, Lasaro's ja'datx thegya' u'j, txã'sa' uuniitewa Jesusa' ki' ĩtxi vxitku txãa pa'ga. ");
INSERT INTO pbb_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Txajũ' sacerdote npiiçthẽ'jwe'sxa' puutx we'wetx Lasaro'swa ikhya', ");
INSERT INTO pbb_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","txã's Jesus ĩtxi vxitpa'gaçxáa judiuwe'sx wala yã'j txuteeçxa Jesus yakhtxi u'jweç yu' naa pa'ga. ");
INSERT INTO pbb_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Jerusalente Paskua fxiestate nasa wala pa'tha. Sa' kuskus enkhẽ' Jesuswa Jerusalente fxiestate pa'jana jĩni's jiyuçxa', ");
INSERT INTO pbb_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","lamus eç spẽ'thçxa Jesusa's pu'thegya' kasehtx. Sa' na'jĩnatx sus we'we': —¡Dxus txakwe ewte, teeçx yuja' Dxus kaahni, Israelwe'sxtxi Jxkaahsa wala ewsa'! jĩnatx weçxá'. ");
INSERT INTO pbb_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Txajũ' Jesusa' teeçx buçxu ũste uyçxa', txãatek a'jçxa u'j, Dxus librute na'wẽ fxi'jni' txãa kxtey yuukahn: ");
INSERT INTO pbb_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Ũukhnuwe, Sion çxhabtewe'sx. Mthegwe, i'kwe'sxtxi Jxkaahsa yuja', teeçx buçxute a'jçxa jĩnak fxi'jni yu'. ");
INSERT INTO pbb_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Txãapkaçxhíi yu', Jesus yakh u'jusawe'sxa' jiyumeeta' txã'wẽ yũuni's. Nawa Jesus cielun u'jnite', jiyutx txã'wẽ fxi'jni' kxtey yuutewa. ");
INSERT INTO pbb_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","18","Txã'wẽ uusá's Jesus ĩtxi vxitpa'gatx nasa jiyuwẽesa' txakwe wala pu'thegya' kaseh, Lasaro's ĩtxi vxituçte' kxtee ih thegna ũssa' jiimeesatxwa pta'sxne'ta txãa pa'ga. ");
INSERT INTO pbb_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Txajũ' txã'wẽ nasa pu'thegya' kasehpa'gaçxáa fxariseowe'sxa' na'jĩnatx ũusçxa we'we' txãawe'sx pwe'sx: —Mthegwe wakx, kĩh yuhwa yũuya' ãjaçmeetha'w, naapkaçxçxáa nasa' jxukay Jesus yakhçxaçxáa u'jweçta' jĩ'tx. ");
INSERT INTO pbb_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Jerusalente fxiesta ente jxu'j kiwe Greciajũwe'sx pa'jçxa ũsu'tx. ");
INSERT INTO pbb_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Txajũ' Greciajũwe'sxa' Galilea kiwesu Beçaidatewe'sx Fxelipe's utxaana kũhçxa', na'wẽtx pxthaa we'we: —Jesusa'stha'w puutx uy wẽje' jĩte', ");
INSERT INTO pbb_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Fxelipe' u'jçxa Adresa's pta'sxku, sa' txajũ' e'zsay Jesusa's pta'sxya' u'jtx. ");
INSERT INTO pbb_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Aça' Jesus we'weçxa': —Dxus Nçxi'k Nasa Yuusa' uuçxa ki' ĩtxi yuuwa'j en ãjaça'. ");
INSERT INTO pbb_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Na'jĩ'th na': Teeçx skuutxh nxinxa' kiwete weteçxa uumeeçxa yu', pehnamée teeçxçxáa nes yuuna. Nawa uuçxa buçxaçxa', jweeíiçxáa penana. ");
INSERT INTO pbb_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Maawa naa kiwete ĩtxĩ fxi'zewa'jçxá's yaakxsa' pçuwa'jmée ĩtxĩ fxi'zewa'ja's ivxiitutxna. Nawa naa kiwete ĩtxĩ fxi'zeni's yaakxsame', pçuwa'jmée ĩtxĩ fxi'zewa'ja's ji'phutxna. ");
INSERT INTO pbb_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Maawa adxa's selpíi wẽeçxa', adx yakh yuweena, sa' adx mtee ũste' txãawa kxtey ũsya' ãjana adxna selpiisa'. Aça' maawa adxna selpisaatxi's adx Tata' tuuthe'jena. ");
INSERT INTO pbb_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Ãçxha' wala nxusna ũsthu, sa' ¿ma'jĩtka? Meeçxa' Tata, adxa's meen nwe'we pxthaa yuukahmen jĩte, ewwáanakx. Nawa txã'wẽ pxthaa yuuya'íiçxáath yuwé' na' txã'jĩme'nja. ");
INSERT INTO pbb_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Tata, maawa idxna jiyuwa'jçxá's mkaavxya'ja'j. Txajũ' cielujũ we'weni na'wẽk pthũuse: —Adxna jiyuwa'ja's kaavxya'ja'jyã'th. Nawa maawa adxa's jiyukahn ki' kaavxya'ja'jya'wath jĩnik pthũuse. ");
INSERT INTO pbb_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Aça' nasa' txã'wẽ cielujũ we'weni's wẽse'jçxa': —Kpi'sxne' txã'jĩ jĩ'tx, naapkaçxha' vxite yu': —Teeçx angelne' txã'wẽ we'we jĩ'tx. ");
INSERT INTO pbb_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Txajũ' Jesusa' na'jĩk: —Txã'wẽ we'weni' adxna pta'sxna we'weme', i'kwe'sxtxi pta'sxnak txã'wẽ we'we jiyukahn. ");
INSERT INTO pbb_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Ãçxha' naa kiwete jxukaysa yuuwesa yuuwa'j en ãjk, naapkaçxha' naa kiwete jxkaahna ũssa eçxthẽ'j yu' peena yu' jxkaajxa' ãjãwa'jmeete neeyũuna. ");
INSERT INTO pbb_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Txã'wẽ adxa's ẽekhẽ ki'pnijũ', jxukaytxi nwe'weya' ãjã'nja. ");
INSERT INTO pbb_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Txã'wẽ we'weçxak kaajiyu'j ma'wẽ uuya'waçxawa. ");
INSERT INTO pbb_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Txajũ' nasa' na'wẽtx we'we: —Kwe'sxa' Dxus librute leya's iiwẽse'tha'w, aça' Kristo' bagaçxte yuhwa uuwa'jmée ĩtxi u'juwa'jsa' jĩ'k. Aça' idxa' ¿ma'wẽga Dxus Nçxi'k Nasa Yuusa's ẽekhẽ ki'pni yuuna jĩna we'we'? Dxus Nçxi'k Nasa Yuusa' ¿kimna? jĩte', ");
INSERT INTO pbb_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Jesusa' na'jĩnak pas: —Eena'sa' i'kwe'sx yakh nee ũsuna, nawa maz ençxáa ũsuna. Txã'wẽte' eena'te fxi'zewa'ja's mpa'gawe, eena'sa nee ũsiyna, kxah çxhi'dxsa' i'kwe'sxtxi kpajkxmeena. Txã'wẽme', çxhi'dxte u'jusa' maa dxi'j ewsatewa jiyuya' ãjã'çme'. ");
INSERT INTO pbb_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Nee i'kwe'sx yakh ũsiyna, eena'sa's mjiyuwe, kxah eena'te fxi'zesa yuune'kwe. Txã'wẽ we'wena jxã'jçxa', Jesusa' u'jçxa vxyaame'. ");
INSERT INTO pbb_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Kim yuhwa ãjanimeesa's txakwe wala kaavxya'ja'thewa, nasa' jiyuya' ãja'çmeeta' Jesus kimtewa. ");
INSERT INTO pbb_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Nawa Dxus yuwe pta'sxsa Isaías fxi'jçxa nvxiitni' kxtey yuukahntxi txã'wẽ yuu: Kxte' na'jĩ'k: Kwe'sx pta'sxni's ¿kimçxá' jxpa'gata'? Dxusa' txajx ãjani's ¿kimtxiga kaavxya'ja'j? jĩ'k. Kristo's jiyuya' ãjawa'jsameene'ta yu', txãa pa'gak Dxus yuwe pta'sxsa Isaiasa' txã'wẽ fxi'jçxa nvxiht. ");
INSERT INTO pbb_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Sa' Isaiasa' ki' we'weçxa': ");
INSERT INTO pbb_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Dxusa' txãawe'sx yafxtxi aphku uyya' ãjãkahmén. Sa' txãawe'sx ũustxiwa nuywejik jiyukahmen, Sa' Dxus tasxte sxawedçxa katxhiwa'ja'swa nvxihtme' jĩ'k. ");
INSERT INTO pbb_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Jesus ma'wẽ yuuwa'jsatewa jiyuçxak Isaiasa' txã'wẽ we'wena fxi'j. ");
INSERT INTO pbb_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Txã'wẽtewa, judiuwe'sx wala kuhsa Jesus kimtewa jiyutx, maaíi yu' npiiçthẽ'jwe'sx yã'jçxa. Nawa fxariseowe'sx ahçeçxa txãawe'sx pkhaakhenijũ kutxi'jçxa peena yu' pa'jwa'jmée vxitkahmen, ãate yu' pta'sxi'çmeeta' ũukhçxa. ");
INSERT INTO pbb_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Txãawe'sxa' nasaa tuuthe'jniçxá's wejx ji'phu wẽeçxatx txã'wẽ yu'. ");
INSERT INTO pbb_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Txajũ' Jesusa' na'jĩnak we'we: —Maawa adxna ũuste jxpa'gasa', adxçxáana jxpa'gamée, adxna kaahsa Tatanawa jxpa'gana. ");
INSERT INTO pbb_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Txã'wẽy maawa adxna uysa', adx Tata'swa uysáa yuuna. ");
INSERT INTO pbb_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Adxa' nasatx eena'te kaafxi'ze'jya'th kĩh, kxah adxna ũuste jxpa'gasa' çxhi'dxte neeyũumeetxna. ");
INSERT INTO pbb_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Nawa maawa adx pta'sxni's wẽse'jçxawa kxtey nwẽese'jmeete', txã'wẽ yũusa's ewmeete nvxiitwa'jsa' adxmeeth. Adx yu' naa kiwetewe'sxtxi ewmeete nvxihtxa' yuwe'çmeeth, wejxwa nwe'weya'th yuwé'. ");
INSERT INTO pbb_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Adxa's wa'lçxa adx pta'sxnitxi' kxtey yuumeete', txã'wẽ yũusatx ewmeete nvxiitwa'jsa ũsa': ãçxh na'wẽ adx pta'sxna we'we'th txãa pta'sxnisa íiçxáa ewmeete nvxiitwa'jsata' nmeh ente'. ");
INSERT INTO pbb_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Txãa pa'gatey adxçxáa we'wena pta'sxiçmeeth. Adxna kaahsa Tataíik txã'wẽ pta'sxkaja', ");
INSERT INTO pbb_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","kxah adxa' jiith adx Tata we'weni' bagaçxte yuhwa pçumée ĩtxi kaafxi'ze'jwa'jsatewa. Aça' adx Tata ma'wẽ pta'sxkaathe', txã'sna íiçxáath adxwa pta'sxi' jĩnak we'we Jesusa'. ");
INSERT INTO pbb_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Paskua fxiesta ãjxa' teeçx ençxáa pejiiçku yu'. Aça' Jesusa' jiik yu' naa kiwe's nvxihtçxa Ney tasxna u'jwa'j en ãani's. Sa' naa kiwete txãa yakh u'jusawe'sxtxi' nyafxiitey ma'wẽne' peeygãh na', nmeh entepkaçxku peeygãh. ");
INSERT INTO pbb_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Jesusa' txãa yakh u'jusawe'sx yakh ũ'na u'ppkaçxha', eçxthẽ'ja' Simon nçxi'k Judas Iskariote's kaaũusuthe'jeçyã'kh yu' Jesusa's ewmeesa kusete dukhkahn. ");
INSERT INTO pbb_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Aça' Jesusa' jiik yu' Dxus tasxune' yuusa yu' sa' ki' Dxus tasxnay u'jwa'ja's. Sa' txã'wẽy jiik yu' Dxus ma'wẽçxah jxkaahwa'ja'swa txãaçxaçxá's dukhni'swa. ");
INSERT INTO pbb_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Txajũ' Jesusa' ũ'na u'píi kiitena'wa, atxhna ki'pçxa, toalxa's jxtuhdku. ");
INSERT INTO pbb_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Sa' kuse khweeçxaniite yu' awna', mesate ih ũ'na u'psa çxidatx pkhi'kxna', toalxaju adxi'k. ");
INSERT INTO pbb_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Sa' Simon Pedro çxidatx pkhi'kxya'wate', txã' na'wẽk we'we: —Kwe'sxtxi jxpe'jsa yuja', ¿adx çxidatx pkhi'kxma'g? jĩte', ");
INSERT INTO pbb_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Jesusa' na'wẽk pas: —Ãçxhíi yu' jiyumeene'ga na'wẽ yũuni's. Nawa e'su' jiyune'ga. ");
INSERT INTO pbb_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Txã'jĩtewa, Pedro' ki' na'jĩk: —Idxa' adx çxidatx pkhi'kxwa'jsameeg jĩte', Jesusa' na'jĩnak pta'sx: —Idxa's pkhi'kxmeete', adx yakh ũsya' ãjameene'ga jĩte', ");
INSERT INTO pbb_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Simona' na'wẽk pxthaa we'we: —Txã'wẽyã'the', çxidaçxáatx pkhi'kxmée, kuse petx dxikthé yã'jçxa meen pkhi'kx jĩk. ");
INSERT INTO pbb_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Nawa Jesusa' na'jĩk: —U'se pẽwçxa ũssa', jxuka ateyã'tha', kxah çxidaçxáatx pkhi'kxwa'j peejxta'. I'kwe'sxa' ateyã'ji'kwe, nawa jxukasa yu' ate ũsmeei'kwe. ");
INSERT INTO pbb_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Jxukaysa yu' ate ũsmeei'kwe jĩnak we'we, txã's ikhkahn dukhwa'jsa's we'weçxak txã'jĩ. ");
INSERT INTO pbb_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Txajũ' Jesusa' txãawe'sx çxidatx pkhi'kxna jxã'jçxa', atxha's jxkahçna' mesate ki' kaçxçxa na'jĩnak paapẽjx: —¿I'kwe'sxa' jiyu'kwe' adx txã'wẽ i'kwe'sx çxidatx pkhi'kxte'? ");
INSERT INTO pbb_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","I'kwe'sxa' adxa'sa' kaapiya'jsa, jxpe'jsa, jĩçxa', isa yuh we'we'i'kwe, adxa' txã'wẽsa yuhth naa pa'ga. ");
INSERT INTO pbb_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Adxa' kaapiya'jsa, jxpe'jsaçxawa i'kwe'sx çxidatx pkhi'kxthu aça' i'kwe'sxwa txã'wẽy çxidatx puutx ya'pkhi'kxna mfxi'zewe teeçxsa na'wẽçxaçxáa. ");
INSERT INTO pbb_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Adx na'wẽy yũuna fxi'zekahnthu i'kwe'sxtxi txã'wẽ selpíi. ");
INSERT INTO pbb_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Isath we'we', maawa selpisa' txajx patronte jxthaakwesame', aça' txã'wẽy kaahnisawa txã's kaahsate jxthaakwesame'. ");
INSERT INTO pbb_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Na'wẽ selpiwa'ja's jiyuçxa kxtey yuuna fxi'zeçxa', weçx weçxa fxi'zene'kwe. ");
INSERT INTO pbb_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","I'kwe'sx jxukaysa yuutxi' txã'jĩ'çmeeth. Jiith kimçxah adx txhitxhnisatewa. Nawa Dxus librute na'wẽ fxi'jni ũsa': Adx yakh ih ũ'saçxawa, adxa's ahçeçxa kiikhe'jya'wa' jĩna fxi'jni' kxtey yuukahnthu txã'jĩ'. ");
INSERT INTO pbb_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Ãçxhíi pta'sxiçthu, kxah kxtey yuute', adxa's ew jiyune'kwe Dxus Nçxi'kdxihtewa. ");
INSERT INTO pbb_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Isath we'we': maawa adx kaahnisa's jxpa'gaçxa', adxa'swa jxpa'gasa yuuna. Sa' adxçxáana jxpa'gamée, adxa's kaahsanawa jxpa'gasa yuuna. ");
INSERT INTO pbb_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Txã'jĩna jxã'jçxa', Jesusa' nxusnxus yajkxçxa ãatek we'we: —Isath txã'jĩ', i'kwe'sx yakh u'jusa teeçxsa' adxa's ahçeçxa ewmeesa kusete dukhya'wa' jĩk. ");
INSERT INTO pbb_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Txajũ' kimna txã'jĩtewa jiyumeeçxa', dxi'p iisaçxáatx puutx thegu' txãawe'sx pwe'sx. ");
INSERT INTO pbb_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Teeçxsa' Jesus pukate ih u'psa' Jesus wedxnisak yu'. ");
INSERT INTO pbb_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Aça' Simon Pedro' kimna txã'jĩtewa jiyu wẽeçxa', txãa ih u'psa's kuseju pta'sxku paapẽykahn. ");
INSERT INTO pbb_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Aça' Jesus pukate ih u'psa' tuphiçxa na'jĩnak paapẽjx: —Jxpe'jsa, mpeeta'sx ¿kim idxa's txã'wẽ ahçeçxa dukhwa'jsana? jĩte', ");
INSERT INTO pbb_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Jesusa' na'jĩnak pta'sx: —Pana's tuupha'jçxa maana ũsu'nja txãa adxa's dukhwa'jsa' jĩçxa', pana's tuupha'jna'wa Simon nçxi'k Judas Iskariote'sku ũs. ");
INSERT INTO pbb_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Aça' Judasa' pana's jxpa'gaçpkaçxha', eçxthẽ'ja' txajx ũuste u'kak. Aça' Jesusa' Judasa's na'jĩnak we'we: —Kĩh yũuya'waçxawa, dud kxtey myuu jĩte', ");
INSERT INTO pbb_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","mesate ũ'na u'psa' maa yuhwa jiyumeeta' txã'wẽ we'weni's. ");
INSERT INTO pbb_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Maaíi yu' na'wẽtx yaaki': Judasa' vxyu jxaawsate', kxah wá' Jesusa' fxiestate peejiwa'ja's weykaja', meeçxawa puuplesatx wá' kĩhçxáawa peeskaja' sũju'tx. ");
INSERT INTO pbb_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Naapkaçxha' Judasa' pana's ũ'na'wa kasehna u'kh. Txã'wẽ yuuçte', çxhi'dxni yã'kh yu'. ");
INSERT INTO pbb_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Judas u'jni e'su', Jesusa' na'wẽk pta'sx: —Dxus Nçxi'k Nasa Yuusá's ãçxha' tuuthe'jnik yuu, aça' Nçxi'kwa Neya's tuuthe'kh. ");
INSERT INTO pbb_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Dxus Nçxi'k Nasa Yuusa' Neya's tuuthe'jeçpkaçxha', Neywa Nçxi'ka's tuuthe'jena, nawa ãçxhíi txã'wẽ yuuya'wa'. ");
INSERT INTO pbb_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Adx nçxi'kkuẽwe'sx, jwee yu' txaçx ũsme'nja i'kwe'sx yakh. Adxa' judiuwe'sxtxi nyafxíi we'weçxa': I'kwe'sxa' adxa's pakweene'kwe. Nawa adx u'jweçthu kxte' yujxa' ãjameene'kwe jĩnath we'we, sa' i'kwe'sxtxiwa txã'wẽyçxáath we'we'. ");
INSERT INTO pbb_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","I'kwe'sx yakh nvxiituçthu u'se jxkaahnisa's, puutx ya'peeygãhna fxi'zewa'ja's. Adx ma'wẽtka i'kwe'sxtxi peeygãhna fxi'ze', txã'wẽy i'kwe'sxwa puutx ya'peeygãhna mfxi'zewe. ");
INSERT INTO pbb_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Txã'wẽ puutx ya'peeygãhna fxi'zete', maa nasawa jiyutxna i'kwe'sx adxa's nwẽese'jsatewa. ");
INSERT INTO pbb_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Txajũ' Simon Pedro' na'jĩnak Jesusa's paapẽjx: —Jxpe'jsa, ¿mtee u'jweçga? jĩte', Jesusa' na'jĩnak pta'sx: —Adx u'jweçthu kxte' yujxa' ãjameene'ga ãçxhíi yu'. Nawa e's yu' yuweene'ga jĩtewa, ");
INSERT INTO pbb_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Pedro' ki'kin paapẽjxku: —Jxpe'jsa ¿kĩh yuuçxa ãçxhíi yu' yujxa' ãjamée yuuki'th? Adx uuwa'ja's yuhwa ũukhya'mée ũsthu, idxa's peeygãaweete jĩte', ");
INSERT INTO pbb_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Jesus we'weçxa': —¿Isaga txã'jĩ'á'? Nawa adxa' na'jĩ'th na': atalx we'wemeyna, adxa's jiimeeth jĩna tekh us ĩsxiijaçyã'j yuune'ga jĩk. ");
INSERT INTO pbb_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Jesusa' na'jĩk: —I'kwe'sx ũuste fxĩikãhna nxusmée meswe. Wejx yuuwa Dxusçxá's yajkxna meswe, sa' adxnawa txã'wẽyçxáa yajkxna meswe. ");
INSERT INTO pbb_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Adx Tata ũsnite', jxkaasena ũswa'j wala ũsa'. Txã'wẽ méewaça', meea' jĩna pta'sxni yã'j yu'nja i'kwe'sxtxi. Txãa pa'ga i'kwe'sx kxtee pa'jwa'ja's pheu'jya' u'jweçthu. ");
INSERT INTO pbb_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Sa' u'jçxa kxtee i'kwe'sx pa'jwa'ja's pheu'jçxa', ki' sxawedu'nja i'kwe'sxtxi pe'jna u'jya', kxah i'kwe'sxwa adx ũsnitey adx yakh ih ũsune'kwe. ");
INSERT INTO pbb_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","I'kwe'sxa' jii i'kwe mtee u'jweçtewa, sa' dxi'jnawa jii i'kwe. ");
INSERT INTO pbb_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Txajũ' Tomasa' na'jĩnak pẽjx: —Jxpe'jsa, mtee u'jweçne'ga nawa kwe'sxa' jiimeetha'w, sa' dxi'ja'swa jiimeetha'w jĩte', ");
INSERT INTO pbb_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Jesusa' pta'sxku dxi'ja's: —Adx yuuçxáa Dxus tasxte kaapa'ja'jwa'jsath, sa' adx yuuçxáa kaypuba'jwa'jsameeth, sa' adx yuuçxáa ĩtxi kaafxi'ze'jwa'jsath. Aça' adxpa'ga yuuçxáa maawa adx Tata tasxte pa'jya' ãjatxna. ");
INSERT INTO pbb_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","I'kwe'sxa' adxa's jiyuwaça', adx Tata ma'wẽsatewa jiyune'kwe. Txã'wẽçxawa ãçxha' jiyu i'kwe, uyna ũsi'kwe txãa adx Tata'. ");
INSERT INTO pbb_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Txãa adx Tata' jĩte', Fxelipe' na'wẽk pẽjx: —Jxpe'jsa, iidx Tata's ãate mkaavxya'j kwe'sx uykahn. Txã'wẽçxáa peejxtha'w jĩte', ");
INSERT INTO pbb_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Jesusa' pta'sxku: —Adxa' i'kwe'sx yakh nakwe txaçx ũsthu aça' ¿ãçxh pa'jwa adxa's jiyumey wá'ga? Adxna uysa', adx Tatanak uyu'. Aça' ¿ma'wẽga Tata's mkaavxya'j jĩna pẽyi'? ");
INSERT INTO pbb_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Jiyu'çmée wá'ga, adxa' Tata yakh bagaçxtewa nesthu yu', aça' txã'wẽy Tatawa adx yakh nesa'. Na'wẽ we'we'th na' peekx ũusuh yajkxçxa txã'wẽ we'we'çmeeth. Tata adx yakh ũssa txãa we'wekaatheçxáath we'we'. ");
INSERT INTO pbb_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Jiyuçxa mneeyũuwe: Bagaçxtewa adxa' Tata yakh e'zsay ih nestha'w yu'. Txã'wẽ e'zíi ihne'ta fxi'ze' sũhmeeçxawa, adx mjĩinisaçxáatxwa uyçxa', Tata yakh ũssaçxak txã'wẽ ewsatx mjĩ' sũhna mneeyũuwe. ");
INSERT INTO pbb_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Isath we'we', adxna ũuste jxpa'gasa' adx na'wẽy mjĩiya' ãjatxna. Nawa txã'wẽçxáamée, adx mjĩinite jxthaakwe wala mjĩiya' ãjatxna, txã'wẽ ãjakahníiçxáa adxa' u'jweçthu Tata tasxna. ");
INSERT INTO pbb_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Sa' i'kwe'sxa' Tata's kĩh pẽywa'j ji'phçxawa, adxa's pẽyine'kwe aça' adxa' i'kwe'sx pẽyni's jxuka kxtey yu'nja, kxah Nçxi'kpa'gate Tata weçxani yuuna. ");
INSERT INTO pbb_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Na'jĩ'th na': adxa's kĩh pẽjxtewa jxuka kxtey yu'nja. ");
INSERT INTO pbb_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","I'kwe'sxa' adxa's peeygãjaççxa', adx jxkaahnitxi' nwẽese'jna kxtey myuuwe. ");
INSERT INTO pbb_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Aça' adx Tata's i'kwe'sx pa'gate neewe'we'nja, i'kwe'sxtxi pu'çxwa'jsa teeçx adx na'wẽysa's kaakhan. Txã' Dxus Espiritu isasaçxá's kaajiyu'jsa' txã' bagaçxtewa i'kwe'sx yakh nes yuuna. ");
INSERT INTO pbb_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Naa kiwetewe'sxa' txãa Espiritu's uyya' ãjameeçxa' jiyuya'wa ãjameetxna, txãasa jxpa'gaya'wa ãjameetxna. Nawa i'kwe'sxa' jii yã'ji'kwe, txãa Espiritu i'kwe'sx yakh ũstewa, sa' bagaçxtewa txutemée nes yuuna. ");
INSERT INTO pbb_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","I'kwe'sxçxáatx nvxihtxa'wameeth. Ki' sxawedu'nja i'kwe'sx yakh ũsya'. ");
INSERT INTO pbb_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Naajũ' txaçxmeynaçxáa nasa' adxa's peena yu' uymeetxna. Nawa adxa' uuwa'jsameeth, txãa pa'ga i'kwe'sxwa uuwa'jsameei'kwe, txãasa i'kwe'sx yu' adxa's uyuune'kwe. ");
INSERT INTO pbb_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Txajũ txãa ente ew jiyune'kwe adxa' Tata yakh nes yuusatewa, naapkaçxha' i'kwe'sxa' adx yakhi'kwe nes yu' aça' adxa' i'kwe'sx yakhthu nes yu'. ");
INSERT INTO pbb_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Adx jxkaahnitx nwẽese'jna kxtey yuuna fxi'zesa' adxa's isa ũusuh jxuka yaakxsaçxa txã'wẽ yuutxna. Aça' adx Tata' txã'wẽ yũusatxi' peeygãjana, aça' adxwa txã'wẽ yũusatxi' peeygãhçxa ãate vxyaana nes yu'nja. ");
INSERT INTO pbb_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Txã'jĩte', Judas Iskariotemée, vxite Judasa' na'wẽk pẽjx: —Jxpe'jsa, ¿kĩh yuuçxa kwe'sxçxáatx ãate vxyaaçxa', vxite nasa naa kiwetewe'sx yuutxi' vxyaamée yuuki'g? jĩte', ");
INSERT INTO pbb_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Jesus pasçxa': —Adxa's ũusuh jxuka yaakxsa' adx jxkaahnitx nwẽese'jna kxteytxi yu'. Aça' txã'wẽ yũusatxi' adx Tata' peeygãja'k. Aça' txã'wẽ nwẽese'jsa yakh yu' nes yu'nja'w Tata yakh. ");
INSERT INTO pbb_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Nawa adx jxkaahnitx nwẽese'jsame', adxa's yaakxsameeçxa txã'wẽ yuuna. Na'wẽ adx kaapiya'jnitx wẽse'ji'kwe txã' adxçxáa kaapiya'jnimeeta'. Adx Tata kaapiya'jnita'. ");
INSERT INTO pbb_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","I'kwe'sx yakh nee ũsíi na'wẽ pta'sxiçthu. ");
INSERT INTO pbb_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Nawa Dxus Espiritu's Tata' kajana adx na'wẽy i'kwe'sxtxi pu'çxna ũskahn txã' jxuka kaapiya'jana. Sa' na'wẽ kĩhwa pta'sxthu txãatxi'sa' jxuka kaayaki'jina. ");
INSERT INTO pbb_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","I'kwe'sx ũuste wẽt yajkxna fxi'zewa'ja's peesuçthu. Naa kiwete wẽt fxi'zewa'ja's nasa ũsu'tx txã'wẽsaçxá's peesuçmeeth. Adx ma'wẽtka ũuste wẽtçxáa yajkxna fxi'ze' txã's i'kwe'sxtxi peesuçthu. Txãa pa'ga fxĩikãhna ũukhmée meswe. ");
INSERT INTO pbb_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","U'jçxa ki' sxawedu'nja i'kwe'sx yakh ũsya' jĩni's wẽse'jyã'ji'kwe na', adxna isa wedxdxihçxa', weçxweçxa yaakine'kwe, txãa pa'gatey adxte jxthaakwesa adx Tata tasxna u'jweçthu naa pa'ga. ");
INSERT INTO pbb_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Dxiikhẽy pta'sxiçthu, kxah adx pta'sxni kxtey yuuna pa'the', isa yuh pta'sxi'ga sũjune'kwe. ");
INSERT INTO pbb_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","I'kwe'sx yakh jwee yu' we'wena ũsya' ãjame'nja, txãa pa'gatey naa kiwete jxkaahna ũssa eçxthẽ'ja' adxa's kĩhwa yũuya' ãjane'jmeeçxawa, yuja'. ");
INSERT INTO pbb_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Makwe ãjane'jmeeçxawa kxtey yuuna, kxah naa kiwete nasa jxukaysa jiyutxna, adx Tata's nwẽese'jçxa txajx jxkaahni's kxtey yuusatewa. Txã'jĩna jxã'jçxa', kiiteçxa ayjxu u'jwega jĩk. ");
INSERT INTO pbb_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Adxíi ũ'tasx na'wẽsath, aça' adx Tata' txãa tasxa's pheu'jsa na'wẽsa'. ");
INSERT INTO pbb_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Ku'ta yũnsameetxi' spẽ'the'k, nawa ku'ta yũnsatxi' sũupi'jna pheu'ju'k jxthaakwe yũnkahn. ");
INSERT INTO pbb_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","I'kwe'sxa' pheu'jniyã'j ũsi'kwe adx kaapiya'jni's nwẽese'pha'ga. ");
INSERT INTO pbb_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Adx yakh txutemée meswe, adxwa ma'wẽ i'kwe'sx yakh txutemée ũstka txã'wẽy. I'kwe'sxa' peekx jii i'kwe: ku'ta çxpiteçxa ũssa' yũnu'çme'. Txã'wẽy i'kwe'sxwa adx yakh txuteeçxa ũsçxa', Dxus dxi'pte selpiiya' ãjameene'kwe. ");
INSERT INTO pbb_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Adxa' ũ'tasx na'wẽsath aça' i'kwe'sxa' ũ'tasx ku'ta na'wẽsa i'kwe. Adx yakh txutemée ũsçxa', wala selpiine'kwe. Aça' adxwa i'kwe'sx yakh txutemée fxi'ze'nja. Adx yakhmée yu', i'kwe'sxa' kĩh yuhwa yũuya' ãjameene'kwe. ");
INSERT INTO pbb_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Aça' ũ'tasx ku'ta yũnsameetxi' ma'wẽga spẽethe'thçxa ya'kabu', txã'wẽy ya'yuuna adx tasxu txutesatxi'. ");
INSERT INTO pbb_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","I'kwe'sxa' adx yakh txutemée fxi'zeçxa adx kaapiya'jni's peçxkanameeçxa', kĩhwa pẽyine'kwe, aça' ya'ũsuna. ");
INSERT INTO pbb_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Adx kaapiya'jni's nwẽese'jçxa' Dxus dxi'pte wala selpiiya' ãjane'kwe. Aça' txã'wẽ yũute', adx Tata's wala tuuthe'jni yuuna. ");
INSERT INTO pbb_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Adx Tata' adxa's wala peeygãja'k, aça' adxa' txã'wẽythu i'kwe'sxtxi peeygãja'. Aça' adx peeygãanijũ txutemée meswe. ");
INSERT INTO pbb_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Adx jxkaahnitx nwẽese'jçxa', adx peeygãaniteçxáa fxi'zene'kwe, adxwa ma'wẽtka Tata jxkaahnitx nwẽese'jçxa' txajx peeygãaniteçxáa fxi'ze' txã'wẽy. ");
INSERT INTO pbb_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Na'wẽth pta'sx kxah adx ma'wẽtka weçxweçxa yajkxna fxi'ze', i'kwe'sxwa txã'wẽy bagaçxwa weçxweçxa yajkxna fxi'zene'kwe. ");
INSERT INTO pbb_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Adxa' na'wẽth jxkaaja': adx ma'wẽtka i'kwe'sxtxi peeygãja', i'kwe'sxwa txã'wẽy puutx ya'peeygãhna mfxi'zewe. ");
INSERT INTO pbb_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Namiku's nwe'weya' sũhçxa peekx ĩtxi fxi'zeni's ivxiitunisaçxáa peeygãani yaase'. ");
INSERT INTO pbb_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","I'kwe'sxa' isa adx namiku dxihçxa', adx jxkaahni's kxtey yuune'kwe. ");
INSERT INTO pbb_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Aça' txã'wẽ yũusatxi' peena yu' selpisáa jĩna kxsusme'nja. Selpisá' txajx patron kĩh yuuya'watewa jiiméek fxi'ze'. Nawa i'kwe'sxa' adx Tata we'wenitxi' jxuka jii i'kwe, txãa pa'ga adxna selpisáa i'kwe jĩna kxsusmée, adx namiku i'kwe jĩnaçxáa kxsuusu'nja. ");
INSERT INTO pbb_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","I'kwe'sx khuẽ'y adxa's txhitxhmeei'kwe, wejxwa adxthu i'kwe'sxtxi txhitxh. Sa' i'kwe'sx mteewa u'jçxa Dxus dxi'pte selpiina fxi'zekahnthu neewe'we', aça' i'kwe'sx txã'wẽ Dxus dxi'pte selpiina u'juni' kxul yuumeena. Txã'wẽ yũusatxi' adx Tata' jxuka ũsuna kĩh pẽjxtewa, adxa's pi'kxçxa pẽjxte'. ");
INSERT INTO pbb_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Na'wẽ yũuwa'ja'sthu i'kwe'sxtxi jxkaaja': Puutx ya'peeygãhna mfxi'zewe. ");
INSERT INTO pbb_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Naa kiwetewe'sxa' adxa's nyafxkhẽytxi ahçe na' i'kwe'sxtxiwa txã'wẽyçxáa açetxna, nawa nxusmée meswe. ");
INSERT INTO pbb_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","I'kwe'sxa' naa kiwetewe'sxwaça', nasa' wedxitxna, txãawe'sx pwe'sx ma'wẽta wedxi' txã'wẽy. Nawa adxa' i'kwe'sxtxi txhitxthu naa kiwejũ, txãa pa'gatx naa kiwetewe'sxa' i'kwe'sxtxi açe', naa kiwetewe'sxmée yã'ji'kwe naa pa'ga. ");
INSERT INTO pbb_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Miiyajkxwe adx na'jĩna we'weni's: Maawa selpisá' txajx patronte jxthaakwesame' jĩni's. Adxa' i'kwe'sxtxi jxpe'jsath na's yuhwa ikhya' pakwe'tx na' i'kwe'sxtxiwa txã'wẽyçxáa ikhya' pakweetxna. Sa' adx kaapiya'jni's nwẽese'jsa', i'kwe'sx kaapiya'jni'swa nwẽese'jetxna. ");
INSERT INTO pbb_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Adx pa'gaçxáa i'kwe'sxtxi pkxuutxna, adxna kaahsa's jiyumeeçxa. ");
INSERT INTO pbb_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Dxus jxkaahni's adx pta'sxya' kĩhmeewaça', txãawe'sxa' yuuwemeesa yuutxna. Nawa ãçxha' adx pta'sxni's jiyutx na' yuuwemeetha'w jĩya' ãjameetxna. ");
INSERT INTO pbb_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Adxna açesa' adx Tatanawa açesata'. ");
INSERT INTO pbb_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Txãawe'sx ksxavxysu kim yuhwa vxit-ya' ãjanimeesa's adx kaavxya'ja'jmeewaça', yuuwemeesa yuutxna. Nawa makwe txã'wẽ adx ãjani's kaavxya'ja'the uyçxawa, adxna açe'tx. Aça' adxna açesayã'j yu' adx Tatanawa açesata'. ");
INSERT INTO pbb_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Nawa txãawe'sx leyte na'wẽ fxi'jni ũsa': adxna ahçetx kĩhwa yuuwemeetewa jĩ'k txã' kxtey yuukahntxi txã'wẽ yũ'. ");
INSERT INTO pbb_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Nawa i'kwe'sxtxi pu'çxwa'jsa Dxus Espiritu isa ew kaajiyu'jwa'jsa's adx Tata tasxu kaja'nja txã' adx kimtewa ew kaajiyu'juna. ");
INSERT INTO pbb_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Aça' i'kwe'sxwa txã'wẽy adx kimtewa pta'sxine'kwe, i'kwe'sxa' nyafxíi i'kwe adx yakh ũssa yu' naa pa'ga. ");
INSERT INTO pbb_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","I'kwe'sxtxi pkxuute', nxusna wala kuh yaakxkahmen na'wẽ pta'sxiçthu: ");
INSERT INTO pbb_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","ahçeçxa judiuwe'sx pkhaakhenijũ kutxi'jçxa peena yu' jxpa'gameetxna i'kwe'sxtxi. Sa' txã'wẽçxáa yũumée i'kwe'sx maaíitxi' ikhetxna, nawa txãawe'sx yu' Dxusa's selpiina ũstha'w sũhna txã'wẽ yũutxna. ");
INSERT INTO pbb_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Txãa açesawe'sxa' adx Tata's jiimeeta', sa' adxnawa jiimeeta', txãasa txã'wẽ pkxuutxna. ");
INSERT INTO pbb_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Aça' kxahth yaçkhẽy txã'wẽ pta'sxi' na' txã'wẽ yũuwa'j en ãhte', adx pta'sxni's yaakine'kwe. Txã'wẽ pkxuuwa'ja's nyafxíi yu' pta'sxmeeth, txãa pa'gatey kĩhwa meek yu' adx i'kwe'sx yakh ũste'. ");
INSERT INTO pbb_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Nawa ãçxha' adxna kaahsa tasxte u'jweçthu. Nawa i'kwe'sxa' maa yuhwa pẽyi'çmeei'kwe ¿mtee u'jweçga? jĩna. ");
INSERT INTO pbb_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Txã'wẽ pẽjxmeeçxa ĩ'neeçxáa i'kwe wala nxusu', adx u'jweçthu jĩna pta'sxte'. ");
INSERT INTO pbb_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Nawa isath pta'sxi': adx u'jmeete', i'kwe'sxtxi pu'çxwa'jsa' kĩhmeena. Nawa adx u'jçxa', txã's kaja'nja. Txãa pa'ga pejka u'jwa'j yuh ji'pthu, i'kwe'sxtxi pu'çxwa'jsa's kaajxa'. ");
INSERT INTO pbb_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Aça' txã' naa kiwete kĩhçxa', nasatx Dxus dxi'pte yuuwe pkalsa yuhtha'w sũhwa'ja's kaaũusuthe'jena. Sa' Jesusa' kĩhte yuhwa yuuwemée ewsa maatxwa jxuka nwe'wewa'jsa yuh yu'ga sũhwa'ja'swa ew kaajiyu'juna. Txã'wẽy yuuwesatxi' Dxusa' ewmeete yuh nvxiituna sũhwa'ja'swa kaaũusuthe'jena. ");
INSERT INTO pbb_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Maawa adxa's jxpa'gaya' wa'lpa'ga txã'wẽ pkal yuuwesata'. ");
INSERT INTO pbb_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Adxa' maatxwa jxuka nwe'wewa'jsaçxaíi nwe'wewa'ja's vxitna uuçxa adx Tata tasxna u'the', peena yu' uymeene'kwe. ");
INSERT INTO pbb_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Sa' yuuwesa' ewmeete neeyũuwa'jsane'tka'w sũjkahníi naa kiwete jxkaahna ũssa eçxthẽ'j yuja'swa ewmeete yã'kh nvxiitni yuu. ");
INSERT INTO pbb_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","I'kwe'sxtxi wala pta'sxwa'j ji'phíiçxáath, nawa ãçxhíi yu' ew jiyuya' ãjameene'kwe. ");
INSERT INTO pbb_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Nawa Dxus Espiritu kĩhçxa', txãa ente i'kwe'sxtxi' jxuka ew kaajiyu'juna, txã' isa we'wenisaçxá's kaajiyu'jsa'. Txã' peekxçxáa we'wemée, Dxus kwe'we'jniçxá's pta'sxina, sa' kĩh yuuya'watewa dxiikhẽy kaajiyu'juna. ");
INSERT INTO pbb_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Adx ma'wẽsatewa ew jiia' na' txãasa i'kwe'sxtxiwa kaajiyu'juna, adxa's tuuthe'jsa' naa pa'ga. ");
INSERT INTO pbb_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Adx Tata ma'wẽsate', adxwa txã'wẽysa íiçxáath. Txãa pa'ga Espiritu' adx ma'wẽsatewa wejx ew kaajiyu'juna jĩnath pta'sxi'. ");
INSERT INTO pbb_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Ãçxha' adx Tata tasxna u'jwa'j ãjãça', aça' adxa's uymeene'kwe. Nawa vxite enkhẽ' adxa's ki' uyuune'kwe. ");
INSERT INTO pbb_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Txã'jĩte', txãa yakh u'jusawe'sxa' na'wẽtx puutx ya'paapẽyi': —¿Ma'jĩçxaki'k txã'wẽ we'we'? Ãçxha' adx Tata tasxna u'jwa'j ãjaça', aça' adxa's uymeene'kwe. Nawa vxite enkhẽ' ki' uyuune'kwe jĩ'k sa', ");
INSERT INTO pbb_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","¿kĩh we'weçxaki'k adx u'jwa'j ãjaça' jĩna we'we'? nawa kwe'sxa' jiyu'çmeetha'w. ");
INSERT INTO pbb_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Txã'wẽ jiyuwẽena ũsni's Jesusa' jiyuçxa' pta'sxku: —Adx Tata tasxna u'jwa'j ãjaça', aça' adxa's uymeene'kwe. Nawa vxite enkhẽ' ki' uyuune'kwe jĩnath we'we aça' ¿txã'sna wá'kwe i'kwe'sx pwe'sx jiyu wẽena puutx paapẽyi'? ");
INSERT INTO pbb_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Isath we'we': I'kwe'sxa' nxusna ũ'nene'kwe, aça' naa kiwete nasa yu' wala weçxaatxna. Nawa i'kwe'sxa' makwe nxusna ũsçxawa, nxusu en skhẽwte', weçxweçxa neeyũune'kwe. ");
INSERT INTO pbb_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Na's mjiyuwe: U'ywa nasa upxya'wate ãça'aççxa', wala pxthaa yu'k akate. Nawa luuçx upxte', weçxaweete txãa aka yuuni's peçxkana'k. ");
INSERT INTO pbb_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Txã'wẽy i'kwe'sxwa ãçxhíi yu' nxusu'i'kwe. Nawa adxa's ki' uyçxa', weçxweçxa yajkxna neeyũune'kwe. Aça' i'kwe'sx weçxweçxa yaakxni's kim yuhwa kusa'jya' ãjameena. ");
INSERT INTO pbb_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Txã'wẽ adxa's ki' uyniijũ', txajũyã'ja' jxuka jiisa adxa's paapẽywa'j ji'phumeene'kwe. Nawa adx Tata yu'sa' kĩhwa jxuka pẽjxya' ãjãne'kwe adxa's pi'kxçxa, aça' txã' jxuka ũsuna. ");
INSERT INTO pbb_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Nawa i'kwe'sxa' ãçxh pa'jwa adx Tata's kĩh yuhwa pẽynimée i'kwe adxa's pi'kxçxa. Mpẽjxwe wakx, sa' jxpa'gaçxa' wala weçxaane'kwe. ");
INSERT INTO pbb_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Ejemplo yakhçxáath kaaja'da'jna pta'sx i'kwe'sx jiyukahn. Nawa ãate pta'sxwa'j en ãhte', peena yu' ejemplo yakh kaaja'da'jna pta'sxme'nja, wejxwa teehwed ãateçxaçxáa pta'sxi'nja adx Tata ma'wẽsatewa. ");
INSERT INTO pbb_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Txã'wẽ ãate pta'sxwa'j en ãhte', i'kwe'sx yuu adx Tata's pẽjxya' ãjane'kwe, makwe adx yu' i'kwe'sx pa'gate we'we pu'çxmeetewa. ");
INSERT INTO pbb_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","I'kwe'sxa' adxa's wedxçxa jxpa'gai'kwe, Dxus tasxu yuusana sũhna. Txãa pa'gak adx Tata' i'kwe'sxtxi peeygãja'. ");
INSERT INTO pbb_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Adxa' Tata tasxu kasehçxa, naa kiwete yuwe'th, sa' ãçxha' naa kiwe's nvxihtçxa ki' u'jweçthu adx Tata tasxna jĩte', ");
INSERT INTO pbb_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","txãa yakh u'jusawe'sxa' na'jĩtx: —Ãçxh yuuçxa' ejemplo yakh kaaja'da'jmée, teehwed ãate pta'sxna ũsgu. ");
INSERT INTO pbb_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Ãçxha' jiyutha'w, idxa' kĩhnawa jxuka jiig. Txãa pa'gatha'w ew jiyu Dxus tasxu yuusatewa. Txãasa kim yuhwa idxa's paapẽywa'j ji'phmeeta' jĩte', ");
INSERT INTO pbb_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Jesusa': —¿Ãçxha' jiyu'kwe'? jĩnak we'we. ");
INSERT INTO pbb_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Ãçxha' ena' ãjk, aça' ãçxhíi i'kwe'sxa' teeçxsa na'wẽçxah fxiifxii txuteene'kwe, sa' adxçxáana nvxiitune'kwe. Nawa adxçxáa yu' neeyũume'nja, Tata' adx yakh ũsa' naa pa'ga. ");
INSERT INTO pbb_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Txã'wẽth adx yakh fxi'zewa'ja's jxuka pta'sxi', kxah adxa's neewe'weçxa', ũukhmée wẽtwẽt yaakine'kwe. Naa kiwete' thẽyte nxuste fxi'zewa'ja's ji'phune'kwe. Nawa adxa's çxhãçxha miiyajkxwe, txãa pa'gatey naa kiwete ewmeesa's adxa' knayyã'th naa pa'ga jĩk. ");
INSERT INTO pbb_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Jesusa' txã'wẽ pta'sxna jxã'jçxa', cielute pagayçxa Dxus yakh puutx we'wek na'jĩna: —Tata, ena' ãjk. Iidx Nçxi'k kimtewa nasa jiyukahn ãate mkaavxya'ja', kxah Nçxi'kwa idxa's ãate kaajiyu'juna nasatx. ");
INSERT INTO pbb_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Nasa jxukaysatx jxkaahwa'ja's adxna ũsgu, iidx ũsni yuutxi' jxukaysatx pçuwa'jmée ĩtxi fxi'zewa'ja's ũskahn. ");
INSERT INTO pbb_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Aça' pçuwa'jmée ĩtxi fxi'zewa'ja's ji'phu wẽeçxa', teeçx Dxusçxáa ũsgu txã'sna jiyuwa'j ji'phta', sa' txã'wẽy iidx kaahnisa Jesukristo'swa jiyuwa'j ji'phta'. ");
INSERT INTO pbb_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Adxa' naa kiwetewe'sxtxi' ew kaajiyu'th idx ma'wẽsatewa, sa' idx mjĩi kaahni's jxã'jyã'th. ");
INSERT INTO pbb_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Tata, naa kiwe meetey ma'wẽtka'w cielute ih weçxana ũsu', ãçxha' txã'sa' ki' mah kxtey ih weçxana ũswa'ja's. ");
INSERT INTO pbb_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Naa kiwejũ maaíitxi' txhitxgu, aça' txãawe'sxtxi' kaajiyu'th idx ma'wẽsatewa. Txãawe'sxa' iidx jĩitx yu', nawa adx jxpe'khangu ũs, aça' txãawe'sxa' nwẽese'jtx iidx jxkaahni's. ");
INSERT INTO pbb_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Sa' na'wẽ kĩjkĩhwa yũuya' ãja'th txãa ãjanisa' iidx jxkaahnitxna sũhwa'ja's ji'phutx. ");
INSERT INTO pbb_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Idx yuwe pta'sxkaahg txã'sa' pta'sxthu, aça' txãawe'sxa' jxpa'gaçxa ũuste yu'akhtxi. Sa' adxa' Dxus kaahnisa iidx tasxuh yuusatewa jiita'. ");
INSERT INTO pbb_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Adxa' txãawe'sxtxi' iidx kuseteth nvxihtna neewe'we'. Naa kiwete idxa's jiimeesa ũsta' txãawe'sx pa'gate neewe'we'çmeeth. Adx jxpe'khan ũsgu txãawe'sx pa'gateçxáath neewe'we', txãawe'sxa' iidx jĩita' naa pa'ga. ");
INSERT INTO pbb_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Jxuka adx jĩ' iidx jĩiçxaçxáata'. Aça' jxuka iidx jĩ' adx jĩiçxaçxáata'. Txãawe'sxpa'ga yuuçxáath txakwe wala weçxaawa'ja's ji'phu. ");
INSERT INTO pbb_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Adxa' naa kiwete txaçxmeeçxáa ũswa'j ji'phthu. Nawa txãawe'sxa' naa kiwete neeyũutxna, naapkaçxha' adxa' yuhth idx yakh ũsya'. Tata, adxna ũsgu txãawe'sxtxi meen jxpe'j jxpa'yakx, kxah teeçxsa na'wẽçxah idx yakh txutemée fxi'zetxna adxwa ma'wẽtka idx yakh txutemée fxi'ze' txã'wẽy. ");
INSERT INTO pbb_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Adxa' naa kiwete txãawe'sx yakh ũsçxa', idx pu'çxte' jxpa'yakxthu jxpe'jna fxi'ze adxa's jxpe'khan ũsgu txãawe'sxtxi's. Aça' jxukaysa yu' vxitumeeta', naasáa teeçx vxituwa'jsane' yu' txãa yuuçxáak vxitu, Dxus librute pta'sxna fxi'jni' kxtey yuukahn. ");
INSERT INTO pbb_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Ãçxha' yuhth idx ũsgu kxteey. Nawa naa kiwete nee ũsíi txã'wẽth idxa's neewe'we', kxah txãawe'sxa' ũukhmée weçxana fxi'zetxna, adxwa na'wẽth weçxana fxi'ze' txã'wẽy. ");
INSERT INTO pbb_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Iidx pta'sx kaahni's pta'sxthu adx jxpe'jnisatxi', nawa naa kiwetewe'sxa' txãawe'sxtxi açe'tx, adx jxpe'jnisawe'sxa' adx na'wẽy naa kiwetewe'sxmeeta' naa pa'ga. ");
INSERT INTO pbb_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Adx jxpe'jnisatxi' naa kiwejũ mkuutxi'j jĩ'çmeeth, naasáa eçxthẽ'j kaypuba'khamen meen nwe'we jĩnaçxáath neewe'we'. ");
INSERT INTO pbb_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Adxa' naa kiwetewe'sxmeeth, aça' txãawe'sxwa naa kiwetewe'sxmeeta'. ");
INSERT INTO pbb_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Txãawe'sxa' iidx jĩiçxáa yuukahn idxçxáa jxpe'jene'ga, isasa's kaapiya'jna. Iidx kaapiya'jni' kaypuba'jwa'jsame'. ");
INSERT INTO pbb_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Idxwa ma'wẽga adxa'sa' naa kiwete kaah, txã'wẽy txãawe'sxtxiwa kajaçthu. ");
INSERT INTO pbb_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Sa' txãawe'sx pa'gate adxwa iidx kusete neeyũuçthu, kxah txãawe'sxwa iidx jxpe'jwa'jyã'j neeyũutxna. ");
INSERT INTO pbb_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Txãawe'sx pa'gateçxáa neewe'weçmeeth. Txãawe'sx iidx yuwe's pta'sxte', maawa idxa's jiyuwa'jsa ũstxna txãawe'sx pa'gate ja'dath neewe'we'. ");
INSERT INTO pbb_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Txãawe'sx jxukaysa teeçxsa na'wẽçxaçxáa yajkxna kwe'sx yakh txutemée fxi'zekahnthu neewe'we', Tata, idxwa na'wẽ adx yakh fxi'zena ũsgu aça' adxwa idx yakh fxi'zena ũsthu txã'wẽy yuukahn. Txã'wẽ yuuçxa teeçxsa na'wẽçxaçxáa ih fxi'zetxna, kxah naa kiwetewe'sxa' jiyutxna adxa' iidx kaahnisatewa. ");
INSERT INTO pbb_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Idx yakh ih fxi'zewa'ja's adxa's ũsgu aça' txãawe'sxtxiwa idx yakh ih fxi'zewa'ja's adxa' ũsthu, adxwa idx yakh ma'wẽtka'w teeçxçxáa na'wẽ fxi'ze' txã'wẽy ih fxi'zekahn. ");
INSERT INTO pbb_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Adxa' txãawe'sx yakh fxi'zete', idxwa adx yakh fxi'zene'ga, kxah txãawe'sxa' teeçxçxáa na'wẽsa yuutxna. Aça' txã'wẽ yũute', naa kiwetewe'sxa' jiyutxna adxa' iidx kaahnisatewa. Sa' adxa's ma'wẽga peeygãja', txã'wẽygu peeygãja' naawe'sxtxiwa. ");
INSERT INTO pbb_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Tata, adxa's jxpe'khan ũsgu aça' txãawe'sxtxi' adx ũsnitey ihth ũs jxthãasu', naa kiwe meetey adxa's peeygãhçxa weçxana jxpe'jna ũsu'g txã'sa' uykahn. ");
INSERT INTO pbb_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Tata, idxa' wala yuh ewsatewa, naa kiwetewe'sxa' idxa's jiimeeta'. Nawa adx yu' jiith, aça' adx jxpe'jnisawa jiita' adxa' iidx kaahnisatewa. ");
INSERT INTO pbb_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Adx jxpe'jnisatxi' kaajiyu'th idx kimtewa, sa' kaajiyu'jna nes yu'nja, kxah idx adxa's peeygãani' txãawe'sx ũuste nes yuute', adxwa txãawe'sx ũuste nes yu'nja. ");
INSERT INTO pbb_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Jesusa' txã'wẽ neewe'wena jxã'jçxa', Cedron yu'kuten ktejkana u'kh, txãa yakh u'jusawe'sx yã'jçxa teeçx walta ũsa' kxtee u'kaya'. ");
INSERT INTO pbb_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Txãa waltate' Jesus yakh u'jusawe'sxa' maz uswa txãa yakh pkhaakheya' u'kasatx yu', naa pa'gak Jesusa's ikhkahn dukhwa'jsa Judasa' jii yu'. ");
INSERT INTO pbb_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Txãasak Judasa' jiiyã'jçxa', soldauwe'sxtxi pe'jçxa kxtee pa'j u'j dxuus yat thegsawe'sx yã'jçxa. Txãa dxuus yat thegsawe'sx yu', sacerdote npiiçthẽ'j vxite' fxariseowe'sx jxkaahnitx yu'. Vxite' fxtũ, vxite' kçxilx, vxite' lampara atçxatx pa'j. ");
INSERT INTO pbb_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Nawa Jesusa' txã'sna ma'wẽwa pkxuuçxa ikhwa'j ãhte jiiyã'jçxa', puutx uyya' kasejk. Sa' na'jĩk: —¿Kimnakwe pakwé'? jĩte', ");
INSERT INTO pbb_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","txãawe'sxa' na'wẽtx pas: —Jesus Nasarethuwe'sxa'stha'w pakwé' jĩte', Jesusa' na'jĩk: —Adxíi txãath. Aça' Judaswa kxtee txãawe'sx yakh ũsu'k, Jesusna kuuwe'jna. ");
INSERT INTO pbb_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Txajũ' adxíith jĩna Jesus we'weniteçxáa, Jesusa's tudwa'jsa' e'su ya'skaçxa kiwegatx wete. ");
INSERT INTO pbb_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Aça' Jesusa' ki' pẽjxku: —¿Kimnakwe pakwé'? jĩte', txãawe'sxa': —Jesus Nasarethuwe'sxa'stha'w pakwé' jĩnatx pas. ");
INSERT INTO pbb_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Aça' Jesus pasçxa': —Adxíith jĩna pta'sxyã'th. Aça' adxa's pakweeççxa', adx yakh u'jusawe'sx ayte ũsta' txãawe'sxtxi' kuçx yuunuwe u'khan jĩk. ");
INSERT INTO pbb_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Jesusa' nyafxíi we'weçxa': Tata adxna jxpe'khan ũsku txã' jxukaysa yu' vxitumeeta' txã'jĩni' kxtey yuukahnku txã'jĩ. ");
INSERT INTO pbb_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Naapkaçxha' Simon Pedro' kçxilx ya'kxnisa's jxkuutxi'jçxa teeçx piçthẽ'j thũ'wẽ paçuwe'sxa'sku spẽ'th. (Txãa piçthẽ'ja' sacerdote npiiçthẽ'ja's selpisáa Malko yaasek yu'.) ");
INSERT INTO pbb_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Aça' Jesusa' Pedro's na'jĩnak jxkaah: —Kçxilxa's wainutey myu'akh. Adx nxuste pxthaa yuuwa'ja'sku Tata' jxthãasu' aça' txã'sa' jxpa'gawa'jsameena sũju'wá'ga jĩk. ");
INSERT INTO pbb_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Txajũ' soldau npiiçthẽ'j txajx nasa yakh vxite' dxuus yat thegsawe'sx yã'jçxa Jesusa's tudçxa', ");
INSERT INTO pbb_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Anas tasxna khuẽ'y jxũna u'jtx. Txãa Anas duh Kaifxasa' sacerdote npiiçthẽ'kh yu' txãa anxute. ");
INSERT INTO pbb_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Txãa Kaifxasíik judiuwe'sxtxi na'jĩna we'wesa yu': Nasa jxukaysa pa'gate teeçx piçthẽ'jçxáa uuwaç wejx ewna jĩsak yu'. ");
INSERT INTO pbb_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Jesusa's tudçxa jxũna u'the', Simon Pedro' vxite piçthẽ'jyã'jçxa Jesus e'stey u'kh. Txãa vxite piçthẽ'j yu' sacerdote npiiçthẽ'j yakh jiisak yu', txãa pa'ga txãa npiiçthẽ'jsa yat patxute u'kak Jesus u'kanitey. ");
INSERT INTO pbb_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Nawa Pedro' u'kamée vxitx pukate neeyũuk. Txãasak sacerdote npiiçthẽ'j yakh jiisa' kxtee vxitxte thegsa yakh puutx we'weçxa Pedro's dxiite ka'ga'j. ");
INSERT INTO pbb_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Aça' vxitxte thegsa' pẽjxku Pedro's: —Idxa' ¿naa piçthẽ'j yakh u'jusameegá'? jĩte', Pedro pasçxa': —Txãa yakh u'jusameeth jĩk. ");
INSERT INTO pbb_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Txajũ' kxtee selpisaawe'sx vxite' dxuus yat thegsawe'sx yã'jçxa kumaçxa ipx yuthçxatx bajçxna ũsu' patxute. Aça' Pedrowa kxtee txãawe'sx yakh ipx pukate bajçxna ũsu'k. ");
INSERT INTO pbb_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Txajũ' Anasa' paapẽjxya' takhku Jesusa's: —Idx yakh u'jusawe'sxa' ¿kimtxna? aça' idxa' ¿kĩhga kaapiya'ja'? jĩte', ");
INSERT INTO pbb_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Jesusa' na'jĩnak pas: —Adxa' ãateçxaçxáa iiwe'weth nasa jxukaysa dxi'pte, judiuwe'sx pkhaakhenisu vxite' dxuus yatte judiuwe'sx jxukaysa ksxavxyte Dxus yuwe's kaapiya'jna. Adxa' paaçte yu' kĩhwa iipta'sxmeeth. ");
INSERT INTO pbb_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Aça' adxa's ¿kĩjxa'ga paapẽyi'? Adx pta'sxni's wẽse'jsatx mpaapẽjx, aça' txãawe'sxa' pta'sxitxna adx kĩh we'weni'swa. Txãawe'sxa' adx pta'sxni's jiita' na'. ");
INSERT INTO pbb_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Txã'wẽ we'wete', dxuus yat thegsawe'sx teeçx kxtee ũssa' kuseju Jesus dxi'pga pehtxaçxa', na'wẽk juuna' we'we: —Anasa' sacerdote npiiçthẽ'ja' aç yuja' ¿txã'wẽ pasu'gá'? jĩte', ");
INSERT INTO pbb_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Jesus pasçxa': —Adx ewmée we'wete', mpeeta'sx kĩhsu ewmée we'weçtewa. Nawa ewsaçxá's we'weçte', ¿ma'wẽtega adxa's txã'wẽ pkxú'? jĩnak pas. ");
INSERT INTO pbb_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Txã'wẽ yũunijũ' Anasa' Jesusa's tudni ũsíin, jxũna u'khaakh sacerdote npiiçthẽ'j Kaifxas tasxna. ");
INSERT INTO pbb_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Naapkaçxha' Pedro' ipx pukate bajçxna ũsíiçxáak yu'. Aça' kxtee ũssawe'sxa' na'wẽtx pẽjx: —Idxa' ¿naa piçthẽ'j yakh u'jusa yuh meega wakx? jĩte', Pedro': —Adxa' txãameeth jĩnak pas. ");
INSERT INTO pbb_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Aça' sacerdote npiiçthẽ'ja's selpisáa teeçxsa' na'jĩnak pẽjx: —Idxa's ¿uymeewá'ntka waltate txãa yakh ũste? (Txã'jĩna pẽysa' Pedro teeçx piçthẽ'j thũ'wẽ's spẽ'thku txãa piçthẽ'j nwe'sxku yu'.) ");
INSERT INTO pbb_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Txã'jĩna ki' pẽjxte', Pedro' ki'kin ĩsxiijaçpkaçxha', atalxa' we'wek. ");
INSERT INTO pbb_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Txajũ' Kaifxas yatu Jesusa's jxũna u'jtx ne'jwe'sx Pilato tasxte nuypa'jya'. Naapkaçxha' khikhiiçku yu'. Txajũ' judiuwe'sxa' ne'jwe'sx u'pnite u'kameeta', pkal pẽetheejena sũhçxa. Txã'wẽ pkal pẽetheethe', Paskuatewe'sxa's ũ'ya' ãjame'nja'w sũhçxatx u'kamée. ");
INSERT INTO pbb_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Txãa pa'gak Pilato' eka kasehçxa' na'jĩna paapẽjx: —Naa piçthẽ'ja' ¿kĩhga yuu aç txã'wẽ pãatxhĩ'khna yujkwe? jĩte', ");
INSERT INTO pbb_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","txãawe'sxa' na'wẽtx pas: —Kĩhwa yuuwemeewaça', iidx tasxte nuypa'jwa'jmeene'tka'w yu' jĩte', ");
INSERT INTO pbb_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pilato' na'jĩnak jxkaah: —Jxũna me'jwe, sa' i'kwe'sx ley ma'wẽ jxkaathe', kxtey yuune'kwe jĩte', judiuwe'sxa' na'jĩnatx we'we: —Kwe'sxa' judiuwe'sxtha'w na' ¿ma'wẽ ikh kaajxa' ãjakxtha'w? ");
INSERT INTO pbb_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Jesusa' ma'wẽ uuwa'jsaçxawa pta'sxku txãa pta'sxni' kxtey yuukahntxi txã'jĩna we'we. ");
INSERT INTO pbb_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Txajũ' Pilato' txajx u'pnite ki' kũhçxa', Jesusa's pa'yaçxa na'wẽk paapẽjx: —¿Idxa' judiuwe'sxtxi jxkaahsawá'ga? jĩte', ");
INSERT INTO pbb_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Jesusa' na'jĩk: —¿Iidx ũusuh yajkxçxaga txã'jĩ'á'? meeçxa' ¿vxitesa txã'jĩna adxa's kxsuusni's wẽse'jçxawá'ga txã'jĩ'? jĩte', ");
INSERT INTO pbb_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilato' na'wẽk pas: —Adxa' judiumeeth. Iidx nwe'sx vxite' sacerdote npiiçthẽ'jwe'sxtxi adx tasxte idxa's nuykũh, aça' idxa' ¿kĩhga ewmée yũu? jĩte', ");
INSERT INTO pbb_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Jesusa' pta'sxku: —Adx jxkaahwa'ja' naa kiweteme'. Txã'wẽ naa kiwete jxkaahwa'jsawaça', adx ju'gusawe'sxa' puiiwa'jne'ta yu', judiuwe'sx kusete adxa's dukhkahmen. Aça' naa kiwete jxkaahsameeth. ");
INSERT INTO pbb_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Txã'jĩte', Pilato' ki' pẽjxku: —Txã'wẽçxa' ¿idxa' jxkaahsa dxihgá'? jĩte', Jesusa' na'jĩk: —Idx kxsusu'g txã'wẽíith. Naa kiwete upxçxa isasaçxáana pta'sxya'th yuwé'. Maawa isasa's nwẽese'jwa'jsa' adx we'weni's jxpa'yakxtxi wẽse'je' jĩte', ");
INSERT INTO pbb_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilato' na'wẽk paapẽjx: —Na'wẽ isasa' jĩna we'we'g txã' ¿kĩhna? Txã'wẽ Jesusa's paapẽjxçxa', Pilato' ki' eka kasejk judiuwe'sxtxi na'jĩna pta'sxya': —Naa piçthẽ'j ewmée yũuni's kĩhte yuhwa uyu'çmeeth. ");
INSERT INTO pbb_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Nawa Paskua fxiesta iisa teeçx preesu kaatxhweete'je'i'kwe na' ¿ãçxwa txã'wẽy txhweete jxthãasu'kwe' naa judiuwe'sxtxi jxkaahsa's? jĩte', ");
INSERT INTO pbb_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","jxukaysa na'jĩtx: —Txã'sa' kaatxhweete'jnu. Barabasçxá's mkaatxhweete'j jĩnatx weyi'. Txãa Barabasa' iiméh jxthaakwe pesweesak yu'. ");
INSERT INTO pbb_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Txajũ' Pilato' Jesusa's jxũna u'jçxa peçxuukwekaakh. ");
INSERT INTO pbb_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Aça' soldauwe'sxa' çhũçhna tadx vxitçxa Jesus dxikthete kaafxĩkhe'jtx, sa' atxh behsa's kaapã'çxi'jçxatx na'jĩ': ");
INSERT INTO pbb_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","—¡Vxiwa, judiuwe'sxtxi jxkaahsa! Txã'jĩçxatx dxi'pga petxaatxa. ");
INSERT INTO pbb_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Txajũ' Pilato' ki' eka kasehçxa' na'wẽk we'we: —Mthegwe, naa piçthẽ'ja' ayte ũsa', nawa txã'sa' makwe paapẽjxçxawa txajx ewmée yũuni's uymeeth. ");
INSERT INTO pbb_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Txã'jĩ yã'the', Jesusa' kasejk dxikthete çhũçha's tadxçxa kaafxĩkhe'jni, sa' atxh behsa's kaapã'çxi'jni. Aça' Pilato' na'jĩnak we'we: —Ãçxha' ayte ũsa' txãa piçthẽ'ja's mthegwe. ");
INSERT INTO pbb_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Txã'jĩte', sacerdote npiiçthẽ'jwe'sx vxite' dxuus yat thegsawe'sx Jesusa's thegçxa' na'jĩnatx sus weyya' kiite: —Kluuste mkaafxuçu'j, kluuste mkaafxuçu'j jĩte', Pilato' na'jĩk: —I'kwe'sx jxpa'gaçxa kluuste mfxuçwe. Adxa' kĩh yuhwa ewmée yũuni's jiyuya' ãjameeth jĩte', ");
INSERT INTO pbb_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","judiuwe'sxa' na'jĩnatx we'we: —Kwe'sxa' ley ji'ptha'w txãa leya' ikhkaja'k, Dxus Nçxi'kthu jĩna u'jupa'ga. ");
INSERT INTO pbb_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Txã'jĩni's wẽse'jçxa', Pilato' jweeíiçxáak wala ũukhwa'j ji'phu. ");
INSERT INTO pbb_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Sa' txajx u'pnite u'kaçxa', na'jĩnak Jesusa's paapẽjx: —Idxa' ¿majũwe'sxga? jĩtewa, Jesusa' pasme'. ");
INSERT INTO pbb_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Aça' Pilato' na'jĩk: —¿Adxa's kĩh yuuçxaga pasu'çmée? ¿Jiimeewá'ga? adxa' kluuste fxuçkahn jxkaajxa'wa ãjawa'jsath, sa' txã'wẽy kaatxhweete'jya'wa ãjawa'jsath jĩte', ");
INSERT INTO pbb_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Jesusa' pasku: —Dxuspa'gameewaça', idxa' kĩjxa'yuhwa ãjawa'jsameeg adxa's. Nawa iidx kusete adxa's dukhsa' idxte jxthaakwe yuuwesa'. ");
INSERT INTO pbb_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Txã'jĩna we'wenijũ' Pilato' wala pa'pçxuk Jesusa's txhweetewẽeçxa. Nawa judiuwe'sxa' na'jĩnatx sus we'we: —Naa piçthẽ'ja's txhweteçxa', jxkaahsa Cesar namikumée yuune'ga. Maawa fxiy jxkaahsa' txã' Cesar ju'gusame'. ");
INSERT INTO pbb_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Txã'jĩni's wẽse'jçxa', Pilato' Jesusa's ekate pe'jna u'jçxa', jxkaahna u'pnite kaçxku. Txãa jxkaahna u'pni' Gabata yaasek yu' hebreo yuwete. Txã' Kwet Fxuçni jĩni'. ");
INSERT INTO pbb_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Paskua fxiesta ãjaçtek txã'wẽ yũuna ũsu'. Txajũ' Pilato' na'wẽk we'we judiuwe'sxtxi: —I'kwe'sxtxi jxkaahsa' ayte ũsa' jĩte', ");
INSERT INTO pbb_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","txãawe'sxa' na'wẽtx sus we'we: —¡Peekx uuna, kluuste mfxuç! jĩte', Pilato' na'wẽk we'we: —I'kwe'sxtxi jxkaahsa yuja's, ¿ma'wẽ kluuste fxuç kajaki'th? jĩte', sacerdote npiiçthẽ'jwe'sxa' na'wẽtx we'we: —Kwe'sxtxi jxkaahsa' Cesar yuuçxá'. Vxite jxkaahsa yu' ji'phmeetha'w. ");
INSERT INTO pbb_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Txã'wẽ we'we yã'the', Pilato' Jesusa's txãawe'sx kusete kluuste fxuçkahn dukhte', jxũna u'jtx. ");
INSERT INTO pbb_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Jesusa' txã'sna fxuçwa'j kluusa's yakhçxa çxhabu kasehna u'kh, teeçx ahte Gólgota yaase' kxtee pa'j. Txãa Gólgota yu', Uusáa Jxkwet Dxi'th jĩni' hebreo yuwete'. ");
INSERT INTO pbb_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Kxtee pa'jçxa' Jesusa's kluuste fxuçtxi, vxite e'z piçthẽ'jtx txã'wẽy, Jesusa's pxãhte txahçxa. ");
INSERT INTO pbb_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Txajũ' Pilato' kluus kajkwete na'wẽk ki'p kaah: Jesus Nasarethuwe'sx, judiuwe'sxtxi jxkaahsa jĩna fxi'jni's. ");
INSERT INTO pbb_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Aça' kluuste fxuçni' çxhab utxatek yu', naa pa'ga maazkuẽe judiuwa txãa fxi'jni's thegu'tx. Txãa fxi'jni', hebreo, griego, latin yuwejuk fxi'jni yu'. ");
INSERT INTO pbb_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Aça' sacerdote npiiçthẽ'jwe'sx vxite' judiu npiiçthẽ'jwe'sxa' na'jĩnatx Pilato's paatxhĩ'kh: —Judiuwe'sxtxi Jxkaahsa jĩna fxi'j na'wẽ, Adxa' Judiuwe'sxtxi Jxkaahsath jĩ'k jĩna fxi'jwaça', wejx ewna. ");
INSERT INTO pbb_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Nawa Pilato pasçxa' na'jĩk: —Adx txã'wẽ fxi'jni's kim yuhwa yu'pthehmeena. ");
INSERT INTO pbb_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Txajũ' soldauwe'sxa' Jesusa's kluuste fxuç yã'jçxa', Jesus athni's pahzsa txu'dedetx soldau iisa teeçxteeçx. Sa' atxha'swa txã'wẽytxi yũu wẽe, nawa txã' teehwedsaçxáak yu' kaçnimeesa. ");
INSERT INTO pbb_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Aça' soldauwe'sxa' na'wẽtx puutx we'we: —Txã's sudeya'mée swerte kaja'nja'w kim jĩi neeyũutewa jiyuya'. Soldauwe'sx txã'wẽ yũuni' Dxus librute na'wẽ fxi'jni kxtey yuuk: Adx athni's txãawe'sx pwe'sx txu'dedetx swerte kaahçxa jĩna fxi'jni'. ");
INSERT INTO pbb_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Txã'wẽ yũuçpkaçxha', Jesusa's fxuçni kluus pukate njĩ'jwa ũsu'k vxite' Jesus njĩ'j yũkwe, vxite' Kleofxas nyu Maria, vxite' Maria Magdalena. ");
INSERT INTO pbb_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Aça' Jesus njĩ'j pukate Jesus wedxnisa ih ũste Jesus uyçxa', njĩ'ja's na'jĩk: —Naa piçthẽ'ja' i'kwe's jxpe'jena nçxi'k na'wẽ jĩçxa', ");
INSERT INTO pbb_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","txãa piçthẽ'ja'swa na'jĩnak neewe'we: —Na'sa' iidx mama na'wẽ jxpe'jene'ga. Txã'jĩte', txãa piçthẽ'ja' txãa oratey Jesus njĩ'ja's txajx yatna pe'jna u'kh. ");
INSERT INTO pbb_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Txãa skhẽua', Jesusa' jiik yu' jxuka kxtey yuuna u'jweçtewa. Sa' Dxus librute ma'wẽ fxi'jni kxtey yuukahnku na'jĩna we'we: —Yũ'wẽeth jĩna. ");
INSERT INTO pbb_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Teeçx tasa vxino utak ũsu'. Aça' txãa vxinote esponja's tuupha'jçxa fxtũte açhçxa Jesus yuwete utxatx çxazxakahn. ");
INSERT INTO pbb_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Aça' Jesusa' esponja's çxazxaçxa', na'wẽk we'we: —Jxuka jxã'jnik neeyũu jĩna'wa, kĩiçhuna' uuk. ");
INSERT INTO pbb_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Aça' Paskua fxiesta en ãjaç yã'kh yu'. Txãa ena' wala ki'snisa yu'k. Aça' judiuwe'sxa' fxiesta ente uusaawe'sx kakwetx kluuskhẽ nvxiit wẽemeeçxa', Pilato's pẽjxtxi kluuskhẽ ki'pnisa çxidatx çxkadedeya' kaakhan, dud uute' kakwetx txajũ kiisya'. ");
INSERT INTO pbb_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Txajũ' soldauwe'sx u'jçxa çxidatx çxkadedetx teeçxsa khuẽ'yna, sa' vxitenawa txã'wẽytxi yũu Jesus pukakhẽ kluuskhẽ u'psa's. ");
INSERT INTO pbb_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Nawa Jesusnawa txã'wẽy yũuya' utxaana kũhçxa', uunii yã'j u'ptetx uy. Txãa pa'gatx Jesus çxidatx çxkadedemée. ");
INSERT INTO pbb_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Txã'wẽtewa, teeçx soldau yu' Jesus tabxte we'thuk yãja'. Aça' txã'wẽ yãjate', ee yu' yakhku uwu. ");
INSERT INTO pbb_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Txã'wẽ yũunisa's pta'sxsa' txajx yafxju yuuk uy, sa' isak we'we'. Sa' jiia' isa we'weççxawa, kxah i'kwe'sxwa txã'wẽ yuh yũune' sũhwa'ja's ji'phune'kwe. ");
INSERT INTO pbb_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Nawa Dxus librute' na'wẽ fxi'jni': Iidx dxi'thtxi' teeçxçxáa yuhwa çxkahdemeetxna jĩni kxtey yuukahntxi txã'wẽ yũu. ");
INSERT INTO pbb_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Dxus librutey vxite ajkhẽ na'wẽ fxi'jni ũsa': We'thu yãjaçxa', thegutxna jĩ'k. ");
INSERT INTO pbb_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Txã'wẽ yũuniijũ' Jose yaasesa Arimatea çxhabuwe'sxa' Pilato tasxte utxaak Jesus kakwe's pẽjxçxa jxũna u'jya'. Aça' Pilato' ewna jĩte', Josea' Jesus kakwe's pedaaya' jxũna u'kh. Naa Jose yu' Jesus ju'gsak yu', nawa judiuwe'sxtxi ũukhçxa kimwa jiyunimeene' u'jusa yu'. ");
INSERT INTO pbb_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Txajũ' Nikodemowa pa'kh, Jesus yakh kus puutx we'wesa. Txãa yu' treinta kilo ãjk yu'çe tũ'sçxa pa'j, miçxa aloe yakh ka'dnisa. ");
INSERT INTO pbb_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Txajũ' Jose' Nikodemo yakh Jesus kakwe's jxũna u'jçxa', yaptxi txãa yu'çe ka'dnisa yakh, judiuwe'sx ma'wẽne'ta uusáa kakwetx pedá' txã'wẽytxi yũu. ");
INSERT INTO pbb_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Jesusna kluuste fxuçni utxasu walta ũsu'k. Aça' txãa waltate' uusáa pedawa'j kafx u'sesa u'pu'k, kim yuhtxwa pedanimeesa. ");
INSERT INTO pbb_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Txkaatx Jesus kakwe's khikh, kafxa' utxatek u'pu' aça' ki'swa'j enwa ãjaçku yu' naa pa'ga. ");
INSERT INTO pbb_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Ki'sen khikhiiçte wala kusíi çxhi'dxtey Maria Magdalena' pedaní kafxte kũhçxa', kxtee aphni kweta's kiisniyã'j ũstek uy. ");
INSERT INTO pbb_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Txajũ' wuwuuçxáak u'j Simon Pedro vxite' Jesus wedxnisa tasxte pa'j. Sa' na'jĩnak pta'sx: —Kwe'sxtxi jxpe'jsa kakwe's jxũna u'jne'ta pedaniijũ, aça' jiyumeetha'w mkaane'ta khikh nanwa jĩte', ");
INSERT INTO pbb_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Pedrowe'sxa' teehwed pedani kafxte thegya' u'jtx. ");
INSERT INTO pbb_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","E'zíi wuwuuçxáatx u'j, nawa teeçxsa' thaakwe dud wuwuuçxa Pedro's phyahççxa' txãa khuẽ'y yaçte kũjk pedani kafxte. ");
INSERT INTO pbb_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Sa' kuyçxa' Jesus kakwe's yapnisaçxáa u'ptek uy. Nawa txã'wẽ uyçxawa, dxiite yu' u'kame'. ");
INSERT INTO pbb_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Txajũ' Pedrowa e'ste kũhçxa pedani kafxte u'kak, sa' txãawa uyku Jesus kakwe's yapnisaçxáa ki'pni u'pte. ");
INSERT INTO pbb_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Sa' Jesus dxikthé yapnisa yu' tpehgçxa fxiite ki'pni u'ptek uy. ");
INSERT INTO pbb_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Aça' yaçte kũusawa kafx dxiite u'kaçxa', txã'wẽ tpehgçxa ki'pni u'pte uyçxa', Jesusa' ĩtxi yuu yuhgakx sũhwa'ja's ji'phuk. ");
INSERT INTO pbb_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Nawa Jesusa' uuçxa ki' ĩtxi yuuna jĩna Dxus librute fxi'jni's jiyumeytxi yu'. ");
INSERT INTO pbb_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Txajũ' Pedro Juanwe'sxa' txã'wẽ uyçxa', yatna ki' sxawedna u'jtx. ");
INSERT INTO pbb_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Pedrowe'sx u'jweçpkaçxha', Maria Magdalena' pedaní kafx pukate ũ'nena neeyũuk. Txã'wẽ ũ'nena u'píi, kafx dxiiga kuyçxa' uyku ");
INSERT INTO pbb_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","e'z angeleswe'sx çxihmeçxáa iikãh jxaathsatx Jesus kakwe's khikhnite pdxi'p kaçxçxa u'pu', teeçxsa' dxikthé ja'date vxite' çxida ja'date. ");
INSERT INTO pbb_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Txajũ' angeleswe'sxa' na'wẽtx pẽjx: —I'kwe' ¿kĩh yũuçxa ũ'nena ũskwe? jĩte', na'jĩnak pas: —Ũ'kwe's jxpe'jsa's jxũna u'tha, aça' jiimeeth mkaane'ta khikh nanwa. ");
INSERT INTO pbb_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Txã'wẽ we'wepu'na' yu'thegçxa', teeçx piçthẽ'j yujuçxa ũstek uy. Nawa txã' Jesusna sũhme'. ");
INSERT INTO pbb_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Aça' Jesusa' na'jĩk: —I'kwe' ¿kĩh yuutekwe ũ'né'? sa' ¿kimnakwe pakwé'? jĩte', Maria' kxtee walta thegsa wá' txã'wẽ we'we' sũhçxa', na'wẽk pas: —Idx wá'ga ũ'kwe's jxpe'jsa kakwe's jxũna u'j na' mpeeta'sx mkaa khikhçxawa, ũ'kwe jxũna u'khan. ");
INSERT INTO pbb_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Txã'jĩte' Jesusa': —¡Maria! jĩnak kxsus. Aça' Maria tuphiçxa na'wẽk we'we hebreo yuweju: —¡Raboni! jĩk, txã' Kaapiya'jsa jĩni'. ");
INSERT INTO pbb_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Txajũ' Jesusa' na'jĩk: —Adxa's jxa'dxnuwe, Tata tasxna u'jmeythu naa pa'ga. Wejxwa adx yakhthẽ'jwe'sxtxi pta'sxya' me'jwe na'jĩna: Adx Tata' i'kwe'sx Tataíiçxá', sa' adx Dxusa' i'kwe'sx Dxusíiçxá' txajx tasxna u'jweçthu jĩnak pta'sxkaah jĩne'kwe. ");
INSERT INTO pbb_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Txã'wẽ pta'sxkaathe', Maria Magdalena' pta'sxya' u'kh: Jxpe'jsa's uythu, aça' txãak txã'jĩna pta'sxkaah jĩk. ");
INSERT INTO pbb_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Txãa ki'sen entey kusa' Jesus yakh u'jusawe'sxa' yatte u'kaçxa vxitxtxi jxuka aphçxatx ũsu', judiuwe'sxtxi ũukhçxa. Txã'wẽ ũspkaçxha', Jesusa' txãawe'sx pxãhte vxyaaçxa na'jĩnak weçxa: —Ũukhmée wẽt wẽtçxáa yajkxna meswe. ");
INSERT INTO pbb_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Txã'jĩçxa', txajx kuse kpã'tx pta'sxku, tabxte we'thu yãjani'swa txã'wẽy. Aça' txãawe'sxa' Jesusa's uyçxa' wala weçxweçxa yajkxtxi. ");
INSERT INTO pbb_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Txajũ' Jesusa' ki' we'weçxa na'jĩk: —Ũukhmée wẽtwẽtçxáa yajkxna meswe. Adx Tatawa ma'wẽga adxa's kaah txã'wẽy adxwa i'kwe'sxtxi kajaçthu. ");
INSERT INTO pbb_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Txã'jĩçxa', txãawe'sx kajkwesu puthku na'jĩna: —Miipa'gawe Dxus Espiritu's. ");
INSERT INTO pbb_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","I'kwe'sxa' maatxwa we'weçxa': I'kwe'sx pkaltxi' Dxusa' peltunaĩna jĩte', peltunãyni yuutxna. Nawa peltunaĩmeena jĩte', peltunãynimée neeyũutxna jĩk. ");
INSERT INTO pbb_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Jesus yakh u'jusaçxawa, Tomas melxisu jĩnisa' meek yu' Jesus txã'wẽ vxyaani ente yu'. ");
INSERT INTO pbb_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Aça' Tomas yu' uymeetewa, Jesus yakh u'jusa vxite yu' pta'sxtxi: —Kwe'sxtxi jxpe'jsa's uytha'w jĩna. Txã'wẽ pta'sxtewa, Tomasa' na'jĩk: —Kusete klaus kpã'vxitni's uyçxa txajx tabxte we'thu yãjani'swa uyçxa txkaa adx kuse's kaahmeeçxa yu', txã'wẽ ĩtxi yuune' sũhme'nja jĩk. ");
INSERT INTO pbb_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Txajũ' teeçx ki'su skhẽwniite', Jesus yakh u'jusawe'sxa' ki' pkhaakheçxa ũsu'tx teeçx yatte. Aça' txãa ente' Tomaswa txãawe'sx yakh pkhaakhena ũsu'k. Aça' makwe vxitxtxi aphçxa ũstewa, Jesusa' txãawe'sx pxãhte vxyaaçxáak yuu, sa' na'jĩk: —Ũukhmée wẽtwẽtçxáa yajkxna meswe jĩk. ");
INSERT INTO pbb_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Txã'wẽ we'weçxa', Tomasa'swa na'jĩk: —Adx kusete kpã'yuunitx thegçxa, txkaa iidx kuse's mkuupath, sa' adx tabxte we'thu yãjanigawa mkuupath. Txã'wẽ yũuçxa', kuh jwed yajkxmée, ĩtxi yuu yuhga sũhwa'jçxá's ji'phune'ga jĩte', ");
INSERT INTO pbb_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tomasa' na'jĩk: —¡Adxna jxpe'jsa yuhg, sa' adx Dxus yuhg! ");
INSERT INTO pbb_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Txajũ' Jesusa' na'jĩk: —Tomas, ãçxha' adxa's uyçxa', ĩtxi yuu yuhga sũhwa'ja's ji'phug. Nawa adxa's uymeeçxawa txã'wẽ ĩtxi yuu yuhne' sũhna yaakxsawa weçxweçxa fxi'zewa'jsata' jĩnak we'we. ");
INSERT INTO pbb_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Naa kiwete kim yuhwa ãjanimeesatx Jesusa' wala kuh kaavxya'ja'kh txãa yakh u'jusawe'sxtxi. Nawa jxuka yu' naa librute fxi'jnimeeta'. ");
INSERT INTO pbb_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Nawa Jesukristo' Dxus kaahni txajx Nçxi'k yuh yu'ga sũhna jiyuçxa' txã'sna jxpa'gaçxa', pçumée ĩtxi fxi'zewa'ja's ji'phukahn pta'sxna fxi'jnisaçxáata'. ");
INSERT INTO pbb_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Jesusa' Tiberias ĩkh wala pukate ki'kin na'wẽk vxyaa txãa yakh u'jusawe'sxtxi. ");
INSERT INTO pbb_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Kxtee pkhaakheçxatx ũs yu' Simon Pedro, vxite' Tomas melxisu jĩ'tx txãa, vxite' Natanael Galilea kiwesu Kaná çxhabtewe'sx, vxite' Zebedeo nçxi'kwe'sx, vxite' e'zsa. ");
INSERT INTO pbb_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Kxtee pkhaakheçxa ũsçxa', Simon Pedro' na'jĩnak we'we: —Wedx uweya' u'jweçthu jĩte': —Kwe'sxwa idx yakh yuhtha'w jĩnatx pas txãawe'sxwa. Sa' teeçx barkote khẽeçxa u'jtx. Nawa txãa kuste' teeçx wedx yuhwa uwemeeta'. ");
INSERT INTO pbb_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Khikhyna sẽjeçte', Jesusa' ĩkh pukate vxyaak. Nawa txãawe'sxa' jiyumeeta' kimtewa. ");
INSERT INTO pbb_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Txajũ' Jesusa' na'jĩnak pẽjx: —¿Teeçx wedxçxá' uwekwe'? jĩte': —Uwemeetha'w jĩna paste', ");
INSERT INTO pbb_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Jesusa' na'jĩnak jxkaah: —Wedx ukhe's paçu ju'gkhẽ makhwe, sa' uweene'kwe jĩte', txã'wẽy ukhe's akhçxa', yu'ju wezxçxawa kutxi'jya' çxhãçxhameeta', wedx iiméh kuh khẽepa'ga. ");
INSERT INTO pbb_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Txã'wẽ yũuni's uyçxa', Jesus yakh u'jusa wedxnisa' Pedro's na'jĩnak pta'sx: —¡Naate ũsa' txã' kwe'sxtxi jxpe'jsa'! Txã'jĩna we'weçpkaçxha', Pedro' txã'wẽ wẽse'jna' ropa's jathna'wa yu'khẽ khẽek Jesus tasxna u'jya'. (Ropa's pahdeçxak ũs yu', txãasak txã'wẽ yũu.) ");
INSERT INTO pbb_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Barkote neeyũusáa vxite yu' wedx ukhe's wezxna kũhtx, cien metroçxáak ũhdxte kũuwa'j peejx yu' naa pa'ga. ");
INSERT INTO pbb_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Txajũ' barkoju jxsa'jçxa', ipx yuthni çxhã'çxha kajkwega teeçx wedx petx pan khikhni ũstetx uy. ");
INSERT INTO pbb_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Txajũ' Jesus we'weçxa': —Ãçxh uwenisa wedxtxi mneejxũhwe jĩte', ");
INSERT INTO pbb_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Simon Pedro' barkote khẽena'wa wedx ukhe's wedx walasaçxaçxáa ji'phsa's wezxna kũjk ũhdxte pa'j. Ciento cinkwenta y tres wedxku ji'phu'. Kxaazkuẽe wedx ji'phçxawa, ukhe' suteme'. ");
INSERT INTO pbb_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Txajũ' Jesus pa'yaçxa': —Ũ'ya' myuhwe jĩk. Txã'wẽ pa'yate', txãa yakh u'jusawe'sxa' jxpe'jsatewa jiyuçxa', maa yuhwa: Idxa' ¿kimga? jĩna pẽyi'çmeeta'. ");
INSERT INTO pbb_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Aça' Jesusa' utxaana kũhçxa', pana's uwena'wa txãawe'sxtxi ũsu'sku, wedxnawa txã'wẽy. ");
INSERT INTO pbb_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Jesus uuçxa ki' ĩtxi yuunijũ naa yakha' tekh us vxyaak txãa yakh u'jusawe'sxtxi. ");
INSERT INTO pbb_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Txajũ' ũ'na jxã'jçxa', Jesusa' Simon Pedro's pẽjxku: —Jonas nçxi'k Simon, ¿ayte ũsta' txãawe'sxte jxthaakwega' adxa's wedxi'á'? jĩte', Pedro pasçxa': —Idxa' peekx jiig adx idxa's wedxiçtewa jĩte', Jesusa' na'wẽk neewe'we: —Txã'wẽçxa', adx piisxakuẽtx wedxna miipe'j jĩk. ");
INSERT INTO pbb_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Txajũ' Jesusa' Pedro's ki' pẽjxku: —Jonas nçxi'k Simon ¿adxa's wedxi'gá'? jĩte', Pedro pasçxa': —Idxa' jiig adx idxa's wedxiçtewa. Txã'jĩte', Jesusa' na'wẽk neewe'we: —Txã'wẽçxa', adx piisxaatx sã'jĩna miipe'j jĩk. ");
INSERT INTO pbb_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Tekh uswa ki' pẽjxku Jesusa': —Jonas nçxi'k Simon, ¿adxa's wedxi'gá'? Aça' Pedro' wala nxusku txã'wẽ tekh us ¿adxa's wedxi'gá'? jĩna pẽjxte'. Sa' na'jĩk: —Idxa' jxuka jiig adx idxa's wedxiçtewa jĩte', Jesusa' na'jĩnak neewe'we: —Txã'wẽçxa' adx piisxaatx jxpa'yakx miipe'j. ");
INSERT INTO pbb_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Isath we'we', nyafxíi piçtakxteya' ropa's peekíi jathe'g, sa' mtee u'j wẽeçxawa u'jwe'g. Nawa ĩisx yã'the', vxitesa' idxa's tudçxa jxũna u'jwetxna idx u'j wẽemeetewa. ");
INSERT INTO pbb_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Jesusa' txã'wẽ we'weçxa', Pedro ma'wẽ yũuni uuçxa Dxusa's ãate kaavxya'ja'jwa'ja's pta'sxnak txã'jĩ. Txajũ' Jesus we'weçxa': —Adx yakh myuhçxáa jĩnak pi'kx. ");
INSERT INTO pbb_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Pedro' yu'thegçxa' uyku Jesus wedxnisa's. Txãa wedxnisaíi nmeh kus ũ'weçte', Jesus pukate kaçxçxa u'pçxa' na'jĩnak pẽysa yu': Jxpe'jsa ¿kim idxa's dukhwa'jsana? jĩna. ");
INSERT INTO pbb_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Txã'sna Pedro uyçxa', na'jĩnak Jesusa's pẽjx: —Jxpe'jsa, naa piçthẽ'ja's ¿kĩh yuukx? jĩte', ");
INSERT INTO pbb_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Jesusa' na'wẽk pas: —Adx jxthãaste' naa piçthẽ'ja' uumée u'juma'k adx sxawedna kĩhpkaçx, nawa txã'sa' idxa' yaakxwa'j ji'phmeeg. Idxa' adx yakh fxi'zewa'jçxá's miiyajkx. ");
INSERT INTO pbb_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Jesus txã'wẽ we'wepa'ga, txãa piçthẽ'ja' uuwa'jsamée wáana sũhnatx ũsu' Jesus yakh u'jusawe'sx vxite yu'. Nawa uumeena jĩçxa Jesusa' txã'wẽ we'weme', naasáa adx jxthãaste', uumée u'juma'k adx sxawedna kĩhpkaçx, nawa idxa' txã'sa' yaakxwa'j ji'phmeeg jĩnaçxáak we'we. ");
INSERT INTO pbb_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Jesus we'weçxa' txã'wẽ uumeena jĩna we'wenisa piçthẽ'jíiçxáak pta'sxna fxi'j, aça' isasa yuja's we'we'k sũju'tha'w. ");
INSERT INTO pbb_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Txã'wẽ Jesus kĩjkĩhwa kaavxya'ja'jnitx jxuka pta'sxna fxi'jwaça', naa kiwete libru yuuwa khẽemeetxna sũju'th.");
INSERT INTO pbb_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Jesusa' nyafxte kĩhwa kaapiya'jna kĩjkĩhwa ew yũuk cielute tejkapkaçx txã'sna, Teofxilo, idxna pta'sxna adx libru nyafxte fxi'th. ");
INSERT INTO pbb_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Txã' cielun u'jmey, piçthẽ'jwe'sxtxi txhitxhku jxkaajxa', sa' ma'wẽçxah yũuwa'ja'swa kaapiya'kh Dxus Espiritu pu'çxte. ");
INSERT INTO pbb_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Sa' uuniijũ ki' ĩtxi kiiteçxa', nyafxíi na'wẽyçxáak petx kakwe yã'jçxa txãawe'sxtxi vxyaana ũsu' kuarenta entepkaçx. Txã'wẽ ĩtxi yuuyuhga sũhna ew jiyukahnku txã'wẽ vxyaana ũsu', sa' Dxus ma'wẽ jxkaahwa'ja'swa pta'sxnak ũsu'. ");
INSERT INTO pbb_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Sa' cielun u'jya'waçxa', txajx txhitxhnisawe'sx yakh nee ũsíi, Jesusa' neewe'wek Jerusalen çxhabuh u'jmée ũskahn na'jĩna: —Mũythaswe, adx Tata kaajxa' neeyũuk txã's jxpa'gapkaçx, adx i'kwe'sxtxi pta'sxthu txã'sna. ");
INSERT INTO pbb_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","I'kwe'sxa' jii i'kwe Juana' naasáa yu'teçxáak akhna bautisaĩ'. Nawa i'kwe'sxa' Dxus Espiritute yuu bautisãyni yuune'kwe jxukaysa ja'daçxah txaçxmeyna jĩnak we'we. ");
INSERT INTO pbb_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Txajũ' Jesus txhitxhnisawe'sxa' txãa yakh ũsçxa', paapẽjxtxi: —Ãçxha' idx wáa naa ensu Israelwe'sxtxi romanowe'sx kuseju nwe'wewa'jsane'ga jĩte', ");
INSERT INTO pbb_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Jesus pasçxa': —I'kwe'sxa' jiyuwa'jsamée i'kwe Israelwe'sxtxi nwe'wewa'j en bagaçxtewa. Dxus kwe'sx Tata yuuçxáa txã'wẽ yũuwa'j ena's jiia'. ");
INSERT INTO pbb_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Nawa Dxus Espiritu kĩhte', txãa yu's jxpa'gawa'jsa yuji'kwe, kĩhtewa jxuka ãjaya'. Sa' txã'wẽ yũunijũ kasehçxa u'jwene'kwe adxa's tuuthe'jya' Jerusalente, Judea kiwesu, vxite' Samaria kiwesu mtee mtee maa kiwetewa jxuka jĩnak jxkaah. ");
INSERT INTO pbb_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Txã'wẽ we'wena jxã'jnijũ txaçxmeyna, txãawe'sx thegna ũsiyna Jesusa' ẽete kiisnik yuu cielun pe'jna u'jya'. Naapkaçxha' tãaph kũhçxa aphku, aça' peena yu' vxyaame'. ");
INSERT INTO pbb_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Txã'wẽ Jesusa's cielun pe'jna u'jweçte', txãawe'sxa' cielute pagayna ũsiyna, e'z piçthẽ'j ropa çxihmesa athçxa txãawe'sx pukatetx vxyaa. ");
INSERT INTO pbb_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Txã'wẽ vxyaaçxa', na'wẽtx we'we: —Galileajuwe'sx, ¿kĩh yuupa'ga cielute pagayna ũskwe? Jesusa' i'kwe'sx ksxavxyuh ma'wẽ cielun u'jweçtekwe uy, txã'wẽyçxáa ki'kin kĩijana txãaíiçxáa jĩnatx pta'sx. ");
INSERT INTO pbb_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Txajũ' thã'j Oliwos yaasesaju u'jtx Jerusalen çxhabna sxawedna. (Txãa Oliwos vxiça' Jerusalen utxak yu' teeçx kilometroçxáak ãh jxu'j neeyũ'.) ");
INSERT INTO pbb_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Jerusalente pa'jçxa', txãawe'sx paadeeni ẽe yatte tejkatx Pedro, Jakobo, Juan, Adres, Fxelipe, Tomás, Bartolomé, Mateo, Jakobo Alfxeo nçxi'k, Simon kananista ju'gusa, vxite' Judas Jakobo nyakh txãawe'sxtxi yu'. ");
INSERT INTO pbb_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Txãawe'sxa' kxteetx tahtatey pkhaakhe' Dxus yakh puutx we'weya' jxukaysa yakh, Jesus nyakhwe'sx vxite' njĩ'j Maria, txã'wẽy vxite u'ywe'sx yã'jçxa. ");
INSERT INTO pbb_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Txãn ensuk Pedro' kxtee pkhaakhesawe'sx ciento weinte ksxavxyte yujuçxa na'jĩ: ");
INSERT INTO pbb_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","—Yakhthẽ'jwe'sx mjiyuwe: Judas ewmée yũuwa'ja's Davxida' fxi'kh Dxus Espiritu kaaũusuthe'jni's Dxus librute txã' kxtey yuuwa'jsa yuh yu'ne'. Txajíik Judasa' Jesusa's preesu'jwa'jsatx pe'jna kũhçxa dukh. ");
INSERT INTO pbb_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Judasa' kwe'sx yakh u'jusak yu', txãasak kwe'sx na'wẽy mjĩiwa'jsa yu'. ");
INSERT INTO pbb_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Nawa Jesusa's txweyni vxyuju kiwek wey, sa' kxteek tẽekhẽe dxiktheju sutenus wete, aça' meetu'ja' jxuka ubuk. ");
INSERT INTO pbb_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Txajũ' Jerusalentewe'sxa' txã'wẽ yũuni's jiyuçxa', txãa kiwe's Akéldama yasetx ki'p, txãawe'sx yuwete yu' Ee pkawni kiwe jĩnik yu'. ");
INSERT INTO pbb_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Judas uuwa'ja's we'weçxak Salmo librute na'jĩ': Txãa yatte u'pwa'jsa kim yuhwa neeyũumeetxna, Aça' txajx yata' namu ji'phmée peekx neeyũuna jĩ'k. Vxite ajkhẽwa na'wẽ fxi'jni': Txajx mjĩiwa'ja's vxite tee mjĩi jĩna fxi'jni'. ");
INSERT INTO pbb_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Txãa pa'ga kwe'sx ksxavxyte piçthẽ'j ũsta' kwe'sxtxi jxpe'jsa Jesus makwe txaçxne' kwe'sx yakh ũsu' txagaçxhíi txutemée pi'kxna u'jusa. ");
INSERT INTO pbb_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Txãawe'sxa' Jesusa's Juan bautisãynijũjx uyya' takhçxa cielun u'phkaçx uysaata' txãatx teeçx txhitxhiga, Jesus ĩtxi yuuni's tuuthe'jna kwe'sx yakh fxi'zewa'jsa jĩk. ");
INSERT INTO pbb_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Txajũ' e'ztxi pakweçxa ki'p, José Barsabás yaasesa's txã'sna íiçxáa Justo jĩnatx kxsuusu', vxite' Matiasna. ");
INSERT INTO pbb_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Sa' na'wẽtx Dxus yakh puutx we'we: —Idxa' maa maa nasa ũus yaakxni'swa jiig. Kwe'sxtxi meen mkhiyu'j naa e'zsatx maaçxahtxga txhitxh, ");
INSERT INTO pbb_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Judas pa'gatewe'sx, na'wẽ Judas txajx mjĩia's nvxihtçxa vxituk txajx pkalpa'ga txãa mjĩia's jxpa'gawa'jsa jĩnatx Dxus yakh puutx we'we. ");
INSERT INTO pbb_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Txajũ' swerte kaahtx kiim yase kasehtewa jiyuya', aça' Matias yasek kaseh. Txajũjx Matiasa' oncesawe'sx yakh utxaak pi'kxna u'juya'. ");
INSERT INTO pbb_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Pentekostes fxiesta en ãhte', jxukaysa kxteeçxaçxáatx pkhaakheçxa ũsu'. ");
INSERT INTO pbb_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Naapkaçxha' cieluju wejxaa wala na'wẽ susna kĩhçxa txãawe'sx ũsni yatte jxuka utak. ");
INSERT INTO pbb_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Naapkaçxha' ipx beeni na'wẽsatx jxukaysa kajkwesu vxyaa. ");
INSERT INTO pbb_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Aça' jxukaysa ja'daçxah txãawe'sx ũuste Dxus Espiritu yuuçxaçxáa jxuka khẽete', txã'sna jxpa'gaçxa maa nasa we'weni yuwe'swa we'weya' ãjatx, Dxus Espiritu maa yuweju we'wewa'ja's jxkaathe' txãaju. ");
INSERT INTO pbb_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Txãn ensu' Dxus jxkaahni's nwẽese'jsa judiuwe'sx maa maa kiwejũwa pa'jçxatx ũsu' Jerusalente. ");
INSERT INTO pbb_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Txajũ' txãa seena' susni's wẽse'jçxa', nasa jxukaysa pkhaakhetx. Sa' txã'wẽ teeçxsa na'wẽçxah txãawe'sx we'weni yuweju we'weni's jiyuçxa', wala kuh yajkxna neeyũutx ");
INSERT INTO pbb_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","¿Ma'wẽçxaki'tx txã'wẽ yũu? sũhna. Sa' txãawe'sx pwe'sx na'jĩnatx puutx paapẽyi': —Na'wẽ we'wena ũsta' txãawe'sxa' jxukay ¿Galileajũwe'sxmeetxná'? ");
INSERT INTO pbb_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Sa' ¿ma'wẽçxata nasa iisa kwe'sx yuweju we'weya' ãja'? ");
INSERT INTO pbb_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Ayte ũstha'w Partiajũwe'sx, Mediajũwe'sx, Elamjũwe'sx, Mesopotamiajũwe'sx, Judeajũwe'sx, Kapadociajũwe'sx, Pontojũwe'sx, Asia kiwejũwe'sx, ");
INSERT INTO pbb_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Fxrigia vxite' Panfxilia kiwejũwe'sx, Egipto vxite' Afxrika Cirene kiwetewe'sx, txã'wẽy Romajũwe'sxwa ayte ũstha'w. Maaíi yu' upxhíi judiuwe'sxtha'w, aça' vxite' judiumeeçxawa judiuwe'sx na'wẽy Dxus jxkaahni's nwẽese'jsa ũstha'w. ");
INSERT INTO pbb_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Txã'wẽy Kretajuwe'sx vxite' Arabiajuwe'sxwa ũstha'w. Nawa jxukaysa Dxus yuwe zhiçxkwesa'stha'w wẽse'je', kwe'sx we'weni yuweju pta'sxpa'ga jĩ'tx. ");
INSERT INTO pbb_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Txã'wẽ yũuni's jxukaysa wala kuh jwed we'wena ũsu'tx na'jĩna: —¿Kĩh yũuya' txã'wẽ yuuçki? jĩ'tx. ");
INSERT INTO pbb_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Naapkaçxha' vxite yu' açewe'wena npeevxysxijkana na'jĩ'tx: —Naawe'sxa' vxino pus tudxçxa tũuçxa txã'wẽ we'wen ũsta' jĩ'tx. ");
INSERT INTO pbb_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Txajũ' Pedro' Jesus jxkaahnisawe'sx oncesa yakh yujuçxa sus we'wena na'jĩk: —Judeatewe'sx vxite' Jerusalentewe'sx i'kwe'sxa' ew jiyuçxa neeyũuya' ew mwẽese'jwe adx pta'sxya'wath txã'sna: ");
INSERT INTO pbb_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Naa piçthẽ'jwe'sxa' tũunitxna jĩ'i'kwe nawa txã'wẽ meeta'. Kusíi las nweweçxá' aça' ¿ma'wẽ tũuni yuukxtha'w? ");
INSERT INTO pbb_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Na'wẽ yuuk txã' Dxus yuwe pta'sxsa Joel we'wek txãak kxtey yuu. Txã' na'jĩ'k: ");
INSERT INTO pbb_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Dxus we'weçxa': Nmeh ensu', adx Espiritu's naa kiwete nasa jxukaysatx makwewa ũsu'nja, Aça' i'kwe'sx nçxi'k i'kwe'sx niisa txãawe'sxa' adx yuwe's pta'sxitxna. Naapkaçxha' piçtakxwe'sxa' cieluju zhiçxkwesa vxyaani's uyuutxna, Aça' thẽ'jsawe'sxa' ewsa ksxa'utxna. ");
INSERT INTO pbb_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Sa' adxa's selpisaawe'sxtxi piçthẽ'j ma'k yuu meeçxa' u'y ma'k yuu nawa txãawe'sxtxi adx Espiritu's makwewa ũsu'nja, adx yuwe's pta'sxkahn. ");
INSERT INTO pbb_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Txajũ' cielujũ kim yuhwa uynimeesa zhiçxkwesa kaavxya'ja'ja'nja: Sa' naa kiwete' ũukhũukhsa kaavxya'ja'ja'nja: ee, ipx wala, aah wala txã'wẽsatx. ");
INSERT INTO pbb_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Aça' seka' kus na'wẽ çxhi'dxina, a'tewa ee na'wẽ beh yuuna. Nawa kwe'sxtxi nwe'wesa kĩiwa'j en zhiçxkwesa ãhmeyna txã'wẽ yuuna. ");
INSERT INTO pbb_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Aça' maawa jxukaysa Dxusa's neewe'wena fxi'zesa' txãa ente' nwe'weni yuutxna jĩ'k. ");
INSERT INTO pbb_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Ãçxha' Israelwe'sx mwẽese'jwe na'jĩya'wath: Jesus Nasarethũwe'sx Dxus kaahnisa i'kwe'sx ksxavxysu kĩjkĩhwa ewsaçxaçxáanak kaavxya'ja'j ãçã'satx nuykatxhina, uusaatx ĩtxĩ vxitna Dxus pu'çxte, Jesukristo' txã'wẽk yũu. Txã'wẽ yũuni's jiiyã'jne'kwe. ");
INSERT INTO pbb_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Nawa txã'sa' kluuste fxuççxa ikhkahn i'kwe'sxa' dukhi'kwe nasa ewmeesa kusete. Txã'wẽ uuwa'ja's Dxusne' txhitxhçxa nvxiht txãniitey, txãa pa'ga i'kwe txã'wẽ yũu. ");
INSERT INTO pbb_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Nawa Dxusa' ki' ĩtxi vxitçxa uuníi seena' ũukhũukhsaju kutxi'kh, txãa pa'gatey ikhsa' bagaçxtewa uuniiçxáa ji'phuya' yu' ãjawa'jsameek yu' naa pa'ga. ");
INSERT INTO pbb_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Jesus uuçxa ki' ĩtxi yuuwa'ja's Davxida' na'jĩnak pta'sx: Adxna jxpe'jsa' bagaçxte yuhwa pu'vxitumée adx yakh nesku yu'. Txã' adx pukate ũsa' paçu ju'gte, kĩh yuhnawa ũukhkahmén adxa's nwe'wena. ");
INSERT INTO pbb_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Txãa pa'gak adx ũuste txakwe wala weçxweçxa ũusuthe', aça' weçxaawa'j yuuçxá'sthu we'we'. Txãa pa'ga adx kakwe' ki' ĩtxi kiiteena sũhnaçxáa skhẽwu'nja, ");
INSERT INTO pbb_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Txãa pa'gatey idxa' adx ũusa's uusaawe'sx ũsnite nvxihtmeene'ga, Sa' idxa's selpisáa kakwe'swa suweepkaçx yu' khikhmeene'ga. ");
INSERT INTO pbb_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Pçuwa'jmée ĩtxi ũswa'the pa'jwa'ja's kaapiya'jg, Sa' iidx ũsnite weçxana ũswa'ja's yuuçxáa ũsune'ga jĩna fxi'jni'. ");
INSERT INTO pbb_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Yakhthẽ'jwe'sx ew mjiyuwe: Na'wẽ kwe'sx yaçgawe'sx Davxid we'wek txã' peekx uuwa'ja'síiçxáa txã'jĩ'çme'. Txã'wẽmeete íiçxáa Davxid uute' pedaatx, aça' txajx kakwe' txkaa ũsa' pedaní ãçxpkaçx. ");
INSERT INTO pbb_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Nawa Davxida' Dxus yuwe pta'sxsak yu'. Txãasak jii yu' Dxusa' teeçx ũsya' puutx we'wek txajx ji'thewe'sx txã' Kristok yu' Davxid na'wẽy jxkaahwa'jsa txã'snak jii yu'. ");
INSERT INTO pbb_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Kristo uuçxa ĩtxi kiiteeçte uyna ũssa na'wẽk pta'sx Davxida'. Txãasak na'jĩ: txajx ũusa' uusaawe'sx ũsnite neeyũumeena, aça' txajx kakwe kha'txwa suweemeena. ");
INSERT INTO pbb_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Davxid we'we'k Jesus txã'snak Dxusa' uuniijũwa ki' ĩtxi vxit, aça' kwe'sxa' jxukaysa uysaatha'w, txãasa ew jiitha'w. ");
INSERT INTO pbb_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Sa' txãa Jesusíik Dxus pukate paçu ju'gte kãhpkaçx pe'jna u'jni yuu. Sa' kxte' Ney ũsya' neeyũuk txajx Espiritu's txã'sa' jxpa'gaçxak txãa Espiritu's kwe'sxtxi makwewa ũs. Aça' txã'si'kwe i'kwe'sxa' jxuka uyna wẽse'j. ");
INSERT INTO pbb_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Davxid txã'wẽ cielute tejkame', txajíik Davxidíiwa na'jĩ': Dxusa' adxna jxpe'jsa's na'jĩk: Adx pukate paçu ju'gte mkaaçx, ");
INSERT INTO pbb_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","Idxna açesatx idxçxaçxá's nwẽese'jwa'ja's vxitna jxã'phkaçx jĩk. ");
INSERT INTO pbb_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Israelwe'sx jxukaysa ew mjiyuwe: Naa Jesusa's i'kwe'sxa' kluuste kaafxuçu'ji'kwe txã'snak Dxusa' Kristo jxkaahwa'jsa vxit. ");
INSERT INTO pbb_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Txã'jĩna pta'sxte wẽse'jçxa', ũuste wala nxus yajkxtxi. Sa' Pedrowe'sxtxi pẽjxtxi: —Yakhthẽ'jwe'sx, ãçxha' ¿ma'wẽ yũukxtha'w? jĩte', ");
INSERT INTO pbb_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Pedro pasçxa': —I'kwe'sx pkaltxi nvxihtçxa, Dxus tasxte misxawedwe, sa' Jesukristo's ũuste jxpa'gaçxa yu'tewa ya'bautisãywe, kxah i'kwe'sx pkaltxi peltunãyni yuuna. Txã'wẽ yũute', i'kwe'sxtxiwa Dxusa' txajx Espiritu's ũsuna. ");
INSERT INTO pbb_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Txãa pa'gatey Dxusa' txajx Espiritu's ũsya' neeyũuk txã' i'kwe'sx jĩi petx i'kwe'sx luuçx jĩi yã'jçxa', sa' maazkuẽesa majũwe'sxwa ũstxna Dxus pa'yanisa txãawe'sxwa jxpa'gatxna jĩ'k. ");
INSERT INTO pbb_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Txã'wẽ we'wena wala yu'kxpejk Pedro' na'jĩna: —Nasa ewmeesa ksxavxyte jxpubana fxi'zemée Dxus tasxte mutxaawe ewte neeyũuya' jĩnak pta'sx. ");
INSERT INTO pbb_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Aça' Pedro pta'sxni's nwẽese'jçxa yu'te ya'bautisãytxi. Txãa ente' tekh mil ãhtx Kristo's jxpa'ga. ");
INSERT INTO pbb_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Sa' Pedrowe'sx kaapiya'jni's piyaçxa', jxukaysa Dxusa's çxhãçxha yajkxnatx neeyũu. Sa' txutemée kxteeçxahtx pkhaakhena fxi'ze', Dxus yakh puutx we'wena, ũ'wa'ja'swa kxteeçxah ũ'na. ");
INSERT INTO pbb_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Txajũ' nasa jxukaysa wala kuh yajkxna ũsu'tx, naapkaçxha' Pedrowe'sxa' ãça'satx nuykatxhina kim yuhwa ãjanimeesa'swa kaavxya'ja'jnatx ũsu'. ");
INSERT INTO pbb_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Jxukaysa Kristo's jxpa'gasa' txutemeetx kxteeçxah fxi'ze', sa' kĩh ji'phuni'swa ja'daçxaçxáatx puutx peesu'sna fxi'ze'. ");
INSERT INTO pbb_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Sa' txãawe'sx ji'phuni's txweyçxa vxyu's kxteeçxah pkhakhçxatx peejiina fxi'zesatx peesu' txãawe'sx peejini's pu'çxna. ");
INSERT INTO pbb_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Een isatx dxuus yatte pkhaakhe', sa' ũ'wa'ja's yu' yat iisatx pi'ki' ũusuh jxuka weçxana, ");
INSERT INTO pbb_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","sa' Dxusnawa txã'wẽy weçxana. Txã'wẽ yũute', nasa' txãawe'sxtxi' wala ew we'we'tx. Aça' Dxusa' een isak txajx luuçxtxi' nuypehnana u'jwe' ewte neeyũuwa'jsatx. ");
INSERT INTO pbb_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Teeçx ente' Pedro Juan yakhtxi dxuus yatte kũjuç yu', kusuçte las treste Dxus yakh puutx we'wewa'j orate. ");
INSERT INTO pbb_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Kxte' teeçx piçthẽ'j upxhíi çxida puuple u'juya' ãjasameek u'p yu'. Txã'sa' een isatx yakhna kũhçxa dxuus yat Vxitx Zhiçxkwesa jĩnisa pukate ki'pu' kxtee nasa u'kasatx lmusxnu pe'wna u'pkahn. ");
INSERT INTO pbb_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Txãa puuple' Pedro Juan yakh dxuus yatte u'kaya' kũjuçte uyçxa', lmusxnu thãasku. ");
INSERT INTO pbb_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Aça' Pedrowe'sxa' txãa puuple dxi'pte ew thegçxa', Pedro' na'jĩk: —Mtheg kwe'sxtxi jĩte', ");
INSERT INTO pbb_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","txãa puuple' ¿kĩh peesya'watxki? sũhna ewku txãawe'sx dxi'pte theg. ");
INSERT INTO pbb_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Aça' Pedro we'weçxa': —Vxyu yu' kĩh yuhwa ji'phmeeth. Nawa adx ji'pthu txã'sçxáawa peesu'nja: Jesukristo Nasarethũwe'sx idxa's ãçxhíi nuykatxhina aça' kiiteçxa ew mneeyũu jĩna'wa, ");
INSERT INTO pbb_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Pedro' paçu kusete uwena' pu'kisku, aça' naa dudtey fxidxa' ku'lete', çxida' jxuka ewtxi neeyũu. ");
INSERT INTO pbb_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Txajũ' txãa ãça'sa' ũphçxak kiite, sa' u'juya' ãjaçxa txãawe'sx yakhíi dxuus yatte u'kak, ũphũuphna Dxusna weçxana tuuthe'jna. ");
INSERT INTO pbb_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Txajũ' txãa çxida puuple' txã'wẽ ũphũuphna Dxusna weçxana yuute nasa jxukaysa uyçxa', kuh yajkxna ũukhtxi. ");
INSERT INTO pbb_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Txãa nasa' çxida puuple's jiitx yu' txã'wẽ dxuus yat Vxitx Zhiçxkwesa jĩnisa pukate kaçxçxa lmusxnu thãasna u'psate. ");
INSERT INTO pbb_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Çxida puuple u'juya' ãjasameeçxawa katxhiyã'jçxa', Pedrowe'sxtxi uweçxa txhweetemée u'jute', nasa jxukaysa wala kuh yajkxna Pedrowe'sxtxi thegya' seena' wala kuh pkhaakhetx dxuus yat pwa' Salomon jĩi jĩ'tx kxtee. ");
INSERT INTO pbb_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Txã'wẽ nasa pkhaakhete', Pedro' na'jĩk: —Israelwe'sx, ¿kĩh yuupa'gakwe i'kwe'sxa' txã'wẽ ũukh we'wena kuh yaaki'? Naa piçthẽ'ja's kwe'sx txã'wẽ Dxus na'wẽ nuykatxhiçxa ew u'juwa'ja's peesuçthas i'kwe yajkxna kwe'sxtxi thegu'. ");
INSERT INTO pbb_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Mwẽese'jwe: Kwe'sx yaçgawe'sx Abrahan, Isaak, Jakob txãawe'sx Dxusa' txajx Nçxi'k Jesusa's cielute seena' jxtuhthesa vxitku na'wẽ i'kwe'sx yu' ahçeçxa jxkaahsa Pilato kusete dukhi'kwe. Aça' Pilato yu' txhweeteya' yajkxtewa, i'kwe'sx yu' kaatxhweete'jmée i'kwe, ");
INSERT INTO pbb_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","wejxwa kĩhwa yuuwemeesa', mitxhwete jĩpkaçxte, i'kwe'sx yu' teeçx piçthẽ'j wala yuuwesa ewmeesaçxá's i'kwe txhweete kaah. ");
INSERT INTO pbb_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Txã'wẽ yũuçxa i'kwe'sxa' Jesus ĩtxi kaafxi'ze'jwa'jsa yu'sa' kiikhe'ji'kwe. Nawa Dxusa' txã'sa' ki' ĩtxi vxitni's kwe'sxa' uysaatha'w, txãasa jiitha'w. ");
INSERT INTO pbb_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Txãasatha'w Jesusa' nuykatxhina sũhçxa txajx yase's kxsusna pi'kx, naa piçthẽ'j i'kwe'sx jiyunisa's nuykatxhikahn. Txãa Jesus nuykatxhipa'ga yuuçxáa naa piçthẽ'ja' jxuka ew katxhite', i'kwe'sx jxukaysa uyna ũsi'kwe. ");
INSERT INTO pbb_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Yakhthẽ'jwe'sx, txã'wẽ yũui'kwe nawa jiimeeçxane'kwe txã'wẽ yũu sũju'th, txã'wẽy jxkaahsawe'sxwa jiimeene'ta yu'. ");
INSERT INTO pbb_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Nawa i'kwe'sx txã'wẽ yũuwa'ja's Dxusa' yaçtey pta'sxku txajx yuwee pta'sxsawe'sxtxi na'jĩna: Kristo' wala pxthaa pa'ga yuuna jĩna aça' txã' kxtey yuukahn i'kwe txã'wẽ ikh. ");
INSERT INTO pbb_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Txã'wẽ yũupa'ga Dxus tasxte sxawedçxa i'kwe'sx pkalpa'ga perdon mpẽjxwe txãa pkaltxi khũkhni yuuya'. Txã'wẽ yũuçxa' weçxana ũswa'j ena's ji'phune'kwe, ");
INSERT INTO pbb_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Dxus kaahni Kristo Jesus jxkaajxa' kĩhte. Txã' i'kwe'sxtxi ew yũuwa'jsa' jĩnik yu' txãníi entey. ");
INSERT INTO pbb_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Ãçxhíi yu' Jesukristo' cieluteçxáa ũswa'jsa', Dxus naa kiwete kĩhnawa jxuka pheu'phkaçx. Nyafx entey Dxus yuwe pta'sxsawe'sx txã'wẽtx Kristo' naa kiwete jxkaajxa' kĩiwa'jsa' jĩna pta'sx naa pa'ga txã' kxtey yuuna. ");
INSERT INTO pbb_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Txã'wẽy Moiseswa na'jĩk: Dxusa' i'kwe'sx jĩi teeçx kaajxa'wa' i'kwe'sx ji'thewe'sx txajx yuwe's pta'sxwa'jsa, adxa's ma'wẽga kaah txã'wẽy. Txã's mwẽese'jwe, ma'wẽ jxkaathewa jxuka kxtey yuuna. ");
INSERT INTO pbb_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Txã'wẽme', maawa Dxus yuwe pta'sxsa's nwẽese'jsame', Israelwe'sx tasxuh txudeni neeyũuçxa jxukaysa vxituwa'tha' jĩk. ");
INSERT INTO pbb_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Ew mjiyuwe: Dxus yuwe pta'sxsa Samwel fxi'zenijũjxwe'sx jxukaysatx ãçxh naa ensu Kristo kĩiwa'ja'sçxaçxáa we'wena pta'sx. ");
INSERT INTO pbb_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Aça' i'kwe'sxa' Dxus yuwee pta'sxsawe'sx ji'ji'kwe, sa' txã'wẽy Dxusa' txãniitey Abrahan yakhwa puutx we'wek i'kwe'sxtxi ew yũuwa'ja's na'jĩna: Naa kiwete nasa' jxukaysa bediciona's jxpa'gatxna iidx ji'j pa'gate jĩna we'wek txã'snawa jxpa'gasai'kwe. ");
INSERT INTO pbb_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Txajíik Dxusa' txajx Nçxi'ka's nyafxte' i'kwe'sx tasxte khuẽ'yku kaah i'kwe'sxtxi nwe'wekahn, kxah i'kwe'sxa' teeçxsa na'wẽçxah ewmée yũuni's nvxiitkahnku txã'wẽ yũu jĩk. ");
INSERT INTO pbb_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Pedro Juan yakh nasatx we'wena ũsiyna, sacerdotewe'sx vxite' dxuus yatte thegsawe'sx npiiçthẽ'j vxite' saduceo txãawe'sx pa'jtx tud-ya'. ");
INSERT INTO pbb_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Txã'wẽ Jesuswa ma'wẽga ĩtxi yuu txã'wẽy uusaawe'sxwa ĩtxi yuuwa'ja' jĩna Pedrowe'sxa' nasatx kaapiya'jna ũste jiyuçxatx wala ũusaçxana pa'jçxa, ");
INSERT INTO pbb_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","preesu'jçxa karcelte kxuuph kuskuuspkaçx, kusuçyã'kh yu' naa pa'ga. ");
INSERT INTO pbb_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Nawa Pedrowe'sx pta'sxni's wẽse'jçxa Kristo's jxpa'gasa yu' seena' wala kuh yu'tx, piçthẽ'jçxáatx isani cinko miltxi yu'. ");
INSERT INTO pbb_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Kuskuus enkhẽ' judiuwe'sx npiiçthẽ'jwe'sx vxite' judiu nthẽ'jsawe'sx vxite' Dxus ley kaapiya'jsa ");
INSERT INTO pbb_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","vxite' sacerdote npiiçthẽ'j Anas vxite' Kaifxas, Juan, Alejandro vxite' jxukaysa sacerdote npiiçthẽ'j nwe'sxwa pkhaakhetx Jerusalente. ");
INSERT INTO pbb_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Sa' Pedrowe'sxtxi pe'jya' kaahçxa txãawe'sx ksxavxyte txahçxa paapẽjxtxi: —¿Kim pu'çxtekwe na'wẽ yũuya' ãja'? meeçxawa ¿kimga jxkaah? jĩte', ");
INSERT INTO pbb_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Pedro' txajx ũuste Dxus Espiritu's jxuka ji'phçxa', na'wẽk pas: —Judiu npiiçthẽ'jwe'sx, Israel nthẽ'jsawe'sx: ");
INSERT INTO pbb_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","I'kwe'sxa' paapẽyi'i'kwe kwe'sx ma'wẽ yũuçxa naa ãça'sa's nuykatxhitewa jiyuya'. ");
INSERT INTO pbb_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Aça' i'kwe'sx dxi'pte teehwed ãate pta'sxiçtha'w, kxah Israelwe'sx jxuka jiyutxna. Naa piçthẽ'j ayte i'kwe'sx dxi'pte ũsa' txã' Jesukristo Nasarethũwe'sx nuykatxhini ũsa'. Txãa Jesukristo's i'kwe'sxa' kluuste kaafxuçu'ji'kwe, nawa Dxusa' uuniijũ ki' ĩtxi vxitku. ");
INSERT INTO pbb_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Txãa Jesusa's i'kwe'sxa' ahçei'kwe yat txaahsawe'sxwa ma'wẽta: Naa kweta' selpime' jĩçxa wãatahtewa txãaíi wejx selpisáa yuu txã'wẽysak yu'. ");
INSERT INTO pbb_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Kim yuhwa txãa na'wẽy nasatx nwe'weya' ãjawa'jsa yu' meea' naa kiwete, naasáa Dxus kaahni Jesus yuuçxáa kwe'sxtxi nwe'wewa'jsa' jĩk Pedro'. ");
INSERT INTO pbb_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Pedrowe'sxa' kim yakh yuhwa piyana ũssamée naasáa Jesus yakh yuuçxáa piyana u'jusaçxawa weh yuhwa ũukhna sxiigmée we'wete', judiutx jxkaahsawe'sx wẽse'jçxa' kuhtx yajkx. ");
INSERT INTO pbb_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Txãapkaçxha' katxhisa piçthẽ'ja' txãawe'sx yakh ijk ũsu', aça' ewmée yũuna ũsi'kwe jĩya' ãjameeta'. ");
INSERT INTO pbb_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Txajũ' Pedrowe'sxtxi' eka kaseh kaahtx txãawe'sx pwe'sxçxáa puutx we'weya'. ");
INSERT INTO pbb_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Sa' na'wẽtx puutx we'we: —¿Kĩh yũukxtha'w naa e'z piçthẽ'jwe'sxtxi'? Txãawe'sxa' naa ãça'sa's txã'wẽ nuykatxhini's maa maawa Jerusalentewe'sx jxuka jiita', aça' kwe'sxa' txã'wẽ nuykatxhimeeta' jĩya' ãjame'nja'w. ");
INSERT INTO pbb_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Nawa mtee mteewa nasatx jwee tuuthe'khamen juuna' we'we'nja'w, kxah peena yu' Jesus kaapiya'jni's pta'sxmeetxna jĩçxa', ");
INSERT INTO pbb_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Pedrowe'sxtxi' ki' pa'yaçxa, wala juuna' we'wetx: —Ãçxha' peena yu' bagaçxte yuhwa Jesus kaapiya'jni's kaapiya'jmeene'kwe jĩte', ");
INSERT INTO pbb_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Pedrowe'sxa' na'wẽtx pas: —I'kwe'sx ũus miiyajkxwe. ¿I'kwe'sx jxkaahniçxá's nwẽese'jçxa', Dxus jxkaahni yu'sa' nwẽese'jmeete wáa ewna? ");
INSERT INTO pbb_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Kĩjkĩhwa kwe'sx yafxju yuu uyna wẽse'jna yuuni's weh yuhwa sxuuna' yuuya' ãjame'nja'w jĩte', ");
INSERT INTO pbb_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","judiutx jxkaahsawe'sxa' ma'wẽ yuhwa kaapeçxukwe'jya' ãjameeçxa', juuna' we'weçxaçxáa kaatxhweete'jtx. Txã'wẽme', nasa' jxukay Dxusçxáanatx tuuthe'jna ũsu' txã'wẽ ãça'sa katxhipa'ga. ");
INSERT INTO pbb_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Txãa katxhisa' kuarenta anxu jxthaakwek ji'phu'. ");
INSERT INTO pbb_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Txajũ' Pedrowe'sxa' txhweeteníi yuuçxa', u'jtx txãawe'sxtxi pi'kxna u'jusawe'sx tasxna. Kxte pa'jçxa', jxuka pta'sxtxi judiutx jxkaahsawe'sx ma'wẽ we'wete txã'wẽy. ");
INSERT INTO pbb_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Aça' txã'jĩni's wẽse'jçxa', jxukaysa Dxus yakh na'jĩnatx puutx we'we: —Cielu, kiwe, ĩkh wala, kxte kĩjkĩhçxah ũstxna txãatx jxuka vxit-sa Dxus, ");
INSERT INTO pbb_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","na'wẽg kwe'we'j idxna selpisáa Davxida's: ¿Kĩh yuupa'gata vxite nasa majũwe'sxwa txakwe ũusaçxana suste', nasa' kxulçxáawa ma'wẽ yũuwa'ja'swa pakwé'? ");
INSERT INTO pbb_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Naa kiwete jxkaahsa' weeçxi'tx, Aça' çxhabte npiiçthẽ'j pkhaakheçxa, Dxusa's ahçeçxa txã'wẽy Nçxi'knawa açe'tx jĩ'k. ");
INSERT INTO pbb_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Txã'jĩni kxtey yuuk. Txãa pa'gatx Herodes vxite' Poncio Pilato kxtee Israelwe'sx petx vxite nasa yã'jçxa iidx Nçxi'k Jesus kĩh pkal yuhwa ji'phmeesa's kaag txã'sna ahçeçxa naa çxhabte pkhaakhe, ");
INSERT INTO pbb_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","ma'wẽ yũuwa'ja'swa idx ma'wẽne'ga vxitçxa nvxiht txãnii entey txã'sa' jxuka kxtey yuuya'. ");
INSERT INTO pbb_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Nawa idxa' txãawe'sx ewmée yũuya' yaakxnijũ nwe'weçxa kwe'sxtxi meen kçxhãaçxha'j, kxah iidx yuwe's kĩhte yuhwa ũukhmée pta'sxi'nja'w. ");
INSERT INTO pbb_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Sa' idx pu'çxte', ãça'satxwa nuykatxhiçxa kĩjkĩhwa kaavxya'ja'ja'nja'w iidx Nçxi'k Jesusa's pi'kxçxa. ");
INSERT INTO pbb_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Txã'jĩna Dxus yakh puutx we'wena jxã'jaçpkaçxha', txãawe'sx pkhaakhenite' ehd u'kh, naapkaçxha' Dxus Espiritu' txãawe'sx ũuste khẽete', Dxus yuwe's ũukhméetx pta'sxi'. ");
INSERT INTO pbb_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Kristo's ũuste jxpa'gasa' teeçxsa ma'wẽ yũuwa'ja's yajkxte', jxukaysa txã'wẽçxaçxáa yũuwa'ja'sçxáatx yaaki'. Maa yuhwa na' adx jĩ' jĩmeetx fxi'ze'. Kĩhwa ji'phuni'sa' jxukaysa ja'daçxaçxáatx jxtxude'. ");
INSERT INTO pbb_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Jesus jxkaahnisawe'sxa' jweeíiçxáatx ũukhmée pta'sxi' Jesus uuçxawa ki' ĩtxi yuuni's, aça' Dxusa' jxukaysatx wala pu'çxhi'k. ");
INSERT INTO pbb_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Txãawe'sx ksxavxyte kim yuhwa jxpeejxsameetx yu'. Txã'wẽ maawa txãawe'sx kiwe vxite' yat txã'wẽsatx txweyçxa vxyu's jxũna pa'jçxa, ");
INSERT INTO pbb_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Jesus jxkaahnisawe'sx kusetetx dukhe', aça' txãawe'sxa' maaçxah jxpeejxtewa txãawe'sxtxi txudeede'tx. ");
INSERT INTO pbb_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Txãn ensu' teeçx piçthẽ'j levxita José yaasesa ũsu'k, Çxipre kiwete upxsa. Aça' Jesus jxkaahnisawe'sxa' Bernabé yasetx ki'p. Txãa yase yu', Kvxiisxa'jsa jĩni'. ");
INSERT INTO pbb_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Txãa piçthẽ'ja' txajx kiwe's txweyçxa vxyu's jxũna pa'jçxa Jesus jxkaahnisawe'sxtxi dukhku. ");
INSERT INTO pbb_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Txã'wẽy Ananiaswe'sx ptamwa txãawe'sx kiwe's txweytxi. ");
INSERT INTO pbb_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Ananiasa' kiwee txweyni vxyu's pxãhnçxáak jxũna u'jçxa jxuka dukheçthu jĩna Jesus jxkaahnisawe'sx kusete nvxiht. Txã'wẽ ĩsxiiwa'ja's ptamíi puutx we'weçxatx txã'wẽ yũu. ");
INSERT INTO pbb_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Aça' Pedro' na'wẽk we'we Ananiasa's: —Eçxthẽ'ja's ¿kĩjxa'ga iidx ũuste ka'ga'jna ũsu', txã'wẽ kiwee txweyni vxyu's pxãhnçxáa dukheççxa jxuka dukheçthu jĩna Dxus Espiritu's ĩsxiikahn? ");
INSERT INTO pbb_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Kiwe' iidx jĩine' yu', aça' txweyte' vxyuuwa iidx jĩine' yu'. Aça' ¿kĩjxa'ga teehwed isasaçxá's pta'sxmée ĩsxiiya' yajkx? Kwe'sxtxiçxáa ĩsxiimée, Dxusnawa ĩsxiig jĩk. ");
INSERT INTO pbb_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Txã'jĩni's wẽse'jna'wa, Ananiasa' uuniik wete. Aça' txã'wẽ yũuni's nasa maawa jxuka jiyusa' seena' wala ũukhwa'ja's ji'phutx. ");
INSERT INTO pbb_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Txajũ' piçtakxwe'sx kũhçxa, txãa uuníi kakwe's yapçxa pedaaya' jxũna u'jtx. ");
INSERT INTO pbb_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Txã'wẽ yũuni tekh ora skhẽuuçpkaçxha', Ananias nyu Safxirawa pa'kh, nmi' uuni's jiimée. ");
INSERT INTO pbb_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Aça' Pedro' pẽjxku: —Mpeeta'sxwe, ¿i'kwe'sx kiwe's kxaz pa'gateçxáa dxih txweykwe'? jĩna pẽjxte', txãa u'y pasçxa': —Isa, txã'wẽteçxáa yuh txweytha'w jĩnak pas. ");
INSERT INTO pbb_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Txajũ' Pedro' na'jĩnak we'we: —I'kwe'sxa' ¿kĩjxa'kwe Dxus Espiritu's ĩsxiiwa'ja's ptamíi puutx we'we'? I'kwe nmi'a' txã'wẽ ĩsxiipa'ga uute', txã'sna pedasáa ãçxhçxáa kũjuçta', sa' i'kwenawa jxũna u'jwetxna pedaaya' ");
INSERT INTO pbb_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","jĩçpkaçxha', txãa u'ywa Pedro tasxga uuniik wete. Aça' Ananiasna pedasáa piçtakxwe'sx kũhçxa, Safxirawa uuníi ũste uyçxa', jxũna u'jçxa nmi' pukasuy pedaatx. ");
INSERT INTO pbb_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Aça' Dxus yakh fxi'zesawe'sx txã'wẽy vxite nasawa txã'wẽ seena' yũuni's jiyuçxa', wala ũukhwa'j ji'phutx. ");
INSERT INTO pbb_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Jesus jxkaahnisawe'sxa' kim yuhwa ãjãnimeesa's kĩjkĩhwa kaavxya'ja'jnatx ũsu' çxhabte nasaa ksxavxysu. Sa' Dxus yakh fxi'zesawe'sx txãawe'sx pwe'sx yu' dxuus yat pwa'tetx pkhaakhe' Salomon jĩi jĩ'tx kxtee. ");
INSERT INTO pbb_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Nawa Dxus yakhmée fxi'zesa yu' kim yuhwa txãawe'sx yakh pkhaakhena utxa'çmeeta', txã'wẽ seena' yũute ũukhçxa. Nawa txãawe'sxa' ekaju yu' Dxus yakh fxi'zesatx wala ewçxáa we'wena fxi'ze'tx. ");
INSERT INTO pbb_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Txã'wẽtewa piçthẽ'j petx u'y yã'jçxa Kristo's txãawe'sx ũuste jxpa'gasa jweeíiçxáatx seena' wala pehnana u'j. ");
INSERT INTO pbb_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Txãjũ' ãça'satx aadaste kutxi'jçxa Pedro skhẽuwa'jsutx khikhe', kxah Pedro psxũ'ju'niçxá'swa jxpa'gasa' katxhitxna sũhçxatx txã'wẽ yũ'. ");
INSERT INTO pbb_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Jerusalen peeku'jsuwe'sxwa nasa seena' wala pa'jtx, txãawe'sx ãça'satx pe'jçxa vxite' eçx iiyamunisatxwa pe'jçxa, sa' jxukay nuykatxhinitx neeyũ'. ");
INSERT INTO pbb_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Txajũ' sacerdote npiiçthẽ'ja' kxtee ũssa saduceowe'sx yakh seena' wala ahçeçxa ");
INSERT INTO pbb_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Jesus jxkaahnisawe'sxtxi' tudçxa karcelte txahtx. ");
INSERT INTO pbb_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Nawa Dxus angel kus kũhçxa karcel vxitxa's phaadeçxa na'jĩçxak eka kutxi'j: ");
INSERT INTO pbb_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","—Dxus yatna ki' u'jçxa nasatxi' pta'sxine'kwe Dxus yakh fxi'zewa'ja's jĩte', ");
INSERT INTO pbb_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","wala kusíitey Dxus yatna u'jçxa pta'sxya' takhtxi. Naapkaçxha' sacerdote npiiçthẽ'j vxite' kxtee ũssa judiu nthẽ'jsawe'sx jxukaysa pkhaakheçxa Jesus jxkaahnisawe'sxtxi' karceluh kutxi'jya' kaahtx. ");
INSERT INTO pbb_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Aça' policiawe'sxa' karcelte uymeeçxa', pta'sxya' ki' sxawedtxi: ");
INSERT INTO pbb_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","—Karcel vxitxa' wala ew aphni ũsa', aça' kxtee thegsawa vxitxte lajkxméetx ũs yu'. Aça' kwe'sx kũhçxa vxitxa's phaadete', Pedrowe'sxa' meetx yu' jĩtx. ");
INSERT INTO pbb_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Txã'jĩna pta'sxte', sacerdote npiiçthẽ'jwe'sx vxite' kxtee dxuus yatte thegsawe'sx npiiçthẽ'j jxukaysa na'wẽtx yaaki': Naa yuwe' ¿ma'wẽ yũuwa'jsakx? sũjuçpkaçxha', ");
INSERT INTO pbb_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","teeçx piçthẽ'j pta'sxna kũjk: —Karcelte ktxaja'ji'kwe txãawe'sxa' dxuus yatte yã'j ki' kaapiya'jna ũsta' nasatx jĩk. ");
INSERT INTO pbb_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Txajũ' dxuus yatte thegsawe'sx npiiçthẽ'ja' policia yakh u'jçxa jxũna kũhtx kĩhwa pkxumée, Pedrowe'sx ju'gusa nasa' ũusaçxaçxa kwet wãatatahwe'sxte. ");
INSERT INTO pbb_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Sa' judiu nthẽ'jsawe'sx tasxte jxũna kũhte', sacerdote npiiçthẽ'ja' na'wẽk pẽjx: ");
INSERT INTO pbb_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","—Kwe'sxa' i'kwe'sxtxi' bagaçxte yuhwa peena yu' pta'sx kaahmeetha'w Jesus kaapiya'jni's. Aça' i'kwe'sxa' ¿kĩjkwe yuu? Naa Jerusalente mtee mteewa jxuka i'kwe'sx kaapiya'jni's yuutaçxa kwe'sxtxi yuuwesa vxit ya'wai'kwe Jesus uuni's. ");
INSERT INTO pbb_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Txã'jĩte', Pedrowe'sx pasçxa': —Kwe'sxa' nasaa jxkaahni yuutxi' nwẽese'jwa'j ji'phmeetha'w, naasáa Dxusçxáana nwẽese'jwa'jsatha'w. ");
INSERT INTO pbb_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Kwe'sx yaçgawe'sx txãawe'sx Dxusa' Jesusa's ki' ĩtxi vxitku kluuskhẽ a'kxçxa i'kwe'sx ikhni's. ");
INSERT INTO pbb_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Dxusa' txã'wẽ yũuçxa cielute txajx pukate paçu ju'gte ki'pçxa Jxkaahwa'jsak vxit, kxah Israelwe'sxa' txãawe'sx pkaltxi nvxihtçxa Dxus tasxte sxawedte, Jesusa' nwe'wena. ");
INSERT INTO pbb_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Txã'wẽ yũuni's kwe'sxa' jiitha'w, aça' Dxusa' txajx Espiritu's ũsku txã'sna nwẽese'jsatx txãa Espirituwa jiia' jĩte', ");
INSERT INTO pbb_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","judiu nthẽ'jsawe'sx jweeíiçxáa ũusaçxaçxa Pedrowe'sxtxi ikhya'watx yu'. ");
INSERT INTO pbb_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Nawa kxtee txãawe'sx ksxavxyte teeçx fxariseo Gamaliel yaasesa u'pu'k, Dxus leya's kaapiya'jsa wala jxtuhthesa. Txã' Jesus jxkaahnisawe'sxtxi eka dudte kutxi'khaahçxa, ");
INSERT INTO pbb_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","judiu nthẽ'jsawe'sxtxi na'wẽk we'we yujuçxa: —Israelwe'sx, naa piçthẽ'jwe'sxtxi na'wẽ yũuya'wai'kwe txã'sa' mpa'yajkxwe. ");
INSERT INTO pbb_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","I'kwe'sxa' miyajkxwe: teeçx ente' vxyaak teeçx piçthẽ'j Teudas yaasesa wala çxhãçxhasath jĩna, aça' txajx ju'gu u'jsa kuatrocientos nasatx yu'. Nawa txãa npiiçthẽ'ja's ikhnik yuu, aça' txajx nasa' jxuka pũsxite', txãa yuwe' pçuuk. ");
INSERT INTO pbb_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Txã'wẽ yũuni e'su, nasatx eçte ãsx ente', teeçx piçthẽ'j txã'wẽy vxyaak, Judas Galileajũwe'sx, aça' txajx ju'gusa nasa wala kuh utxaatx. Nawa txãa Judasa's ikhte', txajx ju'gusawa jxuka pũsxitx. ");
INSERT INTO pbb_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Txãa pa'ga naa piçthẽ'jwe'sxtxi' kuçx yuunuwe. Naa yuwe' piçthẽ'jwe'sxçxáa we'weniçxa yu', kĩhwa yũumeetewa pçuuna. ");
INSERT INTO pbb_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Nawa Dxus jĩi wáana aça' txã'sa' i'kwe'sxa' ivxiituya' ãjãmeene'kwe. Dxus yakh puiisáa yuuya'mée mpa'yajkxwe jĩte', ");
INSERT INTO pbb_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Isa yuh we'wek sũhnatx neeyũu jxukaysa. Txajũ' Jesus jxkaahnisawe'sxtxi pa'yaçxa': Ãçxha' peena yu' Jesus kaapiya'jni's pta'sxmeene'kwe jĩna we'weçxa, wala peçxujkweçxaçxáa txhwetetx. ");
INSERT INTO pbb_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Aça' Jesus jxkaahnisawe'sxa' judiu nthẽ'jsawe'sx tasxuh wala weçxana kasehtx txã'wẽ Jesus kaapiya'jni's pta'sxpa'ga pxthaa yuuwa'ja's ji'phutha'w sũhna. ");
INSERT INTO pbb_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Maa ente yuhwa sxuuna' fxi'zemée een isa Dxus yuwe's kaapiya'jna txã'wẽy Jesukristo ĩtxi yuuni'swa pta'sxna pekũhna nestxi yu' yat-su vxite' dxuus yatte. ");
INSERT INTO pbb_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Txãa ensu' Kristo's jxpa'gasawe'sx wala pehnate', kxtee griego yuweju we'wesawe'sxa' judiu yuweju we'wesawe'sxtxi ũusçxa we'wewa'j uytxi kwe'sx ji'j vxiuda yuutxi' ew sã'jĩmée ũsta' een isa peesni ũ'a's jĩte', ");
INSERT INTO pbb_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Jesus jxkaahnisawe'sx docesa jiyuçxa', Kristo's jxpa'gasawe'sxtxi jxuka pkhakhçxa na'jĩtx: —Dxus yuwe's pta'sxmée, sã'jĩwa'jçxá's jxthaakwe pa'pçxuya' yu' ãjãme'nja'w kwe'sxa'. ");
INSERT INTO pbb_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Txã'wẽ yũuya'mée i'kwe'sx yakh ũssa yakhthẽ'jwe'sx siete piçthẽ'j mtxhiitxhwe, Dxus dxi'pte ew fxi'zesa, Dxus Espiritu's ũuste jxpa'gasa, ma'wẽ yũuwa'ja'swa ew jiisatx. Txã'wẽ yuuçxa txãawe'sxtxi dukhe'nja'w sã'jĩna ũswa'j mjĩia's. ");
INSERT INTO pbb_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Aça' kwe'sxa' Dxus yuwe's kaapiya'jwa'jçxá's thegu'nja'w, Dxus yakh pu'vxitumée puutx we'wena jĩte', jxukaysa txã'wẽ yũuwa'ja's yajkxtxi. ");
INSERT INTO pbb_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Sa' Dxus yakh jxpubamée fxi'zesa Estebana'stxi txhitxh Dxus Espiritu's ũuste ji'phsa. Vxite' Fxelipe, Prókoro, Nikanor, Timón, Parmenas, Nikolas Antiokía çxhabuwe'sx txãawe'sxtxi txhitxhnisa neeyũu. Txãa Nikolasa' judiumeeçxawa judiuwe'sx na'wẽy yuuna fxi'zeya' utxasaak yu'. ");
INSERT INTO pbb_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Txãa piçthẽ'jtx txhitxhçxa', pe'jna u'jtx Jesus jxkaahnisawe'sx tasxte, aça' txãawe'sxa' dxikthesu peekizeçxa Dxus yakh puutx we'wetx txãawe'sx pa'gate. ");
INSERT INTO pbb_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Txajũ' Dxus yuwe' walaana u'kh, aça' Kristo's jxpa'gasawa Jerusalente seena' wala pehnak, txãa pa'ga kxtee judiuwe'sx sacerdote yuhwa Jesus kaapiya'jni's jxpa'gatx wala kuhsa. ");
INSERT INTO pbb_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Aça' Estebana' Dxus pu'çxte', kim yuhwa ãjanimeesa'swa kaavxya'ja'jnak fxi'ze' txãa çxhabte. ");
INSERT INTO pbb_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Txã'wẽ yũute', judiu vxite kiwejuwe'sx Cirene, Alejadría, Cilicia, Asia txãa kiwesuwe'sxa' Esteban yakh ũusçxa we'wena kasehtx. Txãawe'sxa' karceluh txhweetenisa txãawe'sx pwe'sxçxáa fxiitx pkhaakheni yat ji'phu'. ");
INSERT INTO pbb_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Nawa txãawe'sxa' pasya' ãja'çmeeta' Estebana' Dxus Espiritu kaaũusuthe'jni's we'wete'. ");
INSERT INTO pbb_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Txajũ' vxitetx vxyu dukhtxi txã'wẽ Moisesa's açewe'wena Dxusnawa açe'k jĩna ĩsxiina pãatxhĩ'khkahn. ");
INSERT INTO pbb_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Txã'wẽ yũuçxatx kaaũusçxa'j nasa ekajuwe'sx vxite' judiu nthẽ'jsawe'sx vxite' Dxus leya's kaapiya'jsawe'sxtxi. Sa' Estebana's tudçxa jxũna u'jtx judiu nthẽ'jsawe'sx tasxte. ");
INSERT INTO pbb_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Sa' pakwetx na'wẽ ĩsxiina pta'sxwa'jsa: Naa piçthẽ'ja' een isa dxuus yata's açewe'wena txã'wẽy Dxus leya'swa açewe'wena nesku yu'. ");
INSERT INTO pbb_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Jesus Nasarethũwe'sxa' naa dxuus yata's ivxiituçxa, Moises kaapiya'jni'swa ivxiituwa'jsa' jĩna kaapiya'jni's kwe'sxa' wẽse'tha'w. ");
INSERT INTO pbb_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Txã'jĩna ĩsxiite', judiu nthẽ'jsawe'sx vxite' kxtee pkhaakheçxa ũssa' Esteban dxi'pte thegçxa' Dxus angel na'wẽtetx uy. ");
INSERT INTO pbb_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Txajũ' sacerdote npiiçthẽ'ja' Estebana's pẽjxku: —¿Na'wẽ pta'sxi'tx txã' jxuka isa yuhna'? jĩte', ");
INSERT INTO pbb_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Estebana' pta'sxya' takhku: —Yakhthẽ'jwe'sx, na's mwẽese'jwe: Kwe'sx Dxus cielutewe'sxa' yaçgathẽ'j Abrahana's vxyaak Harán kiwete u'pxa' u'jmey nee Mesopotamia kiwete ũsiyna. ");
INSERT INTO pbb_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Sa' na'wẽk jxkaah: Iidx kiwe petx iidx nwe'sx jxuka nvxihtçxa me'j kiwe ũsya'wath kxtee. ");
INSERT INTO pbb_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Txã'jĩte', Abrahana' Kaldea kiweju kasehçxa Harán kiwetek u'pxa' u'j. Txajũ' Abrahan neya' Harán kiwete uute', Dxusa' Abrahana's pe'jna yuwe'k naa kiwete ãçxh ũsi'kwe kxtee. ");
INSERT INTO pbb_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Nawa Dxusa' Abrahana's naa kiwete nuypa'jçxa', kiwe le'çxkuẽçxáa yuhwa txagaçxhíi yu' ũsme'. Nawa idxa's e'suçxáawa naa kiwe's ũsu'nja, aça' idx uute', iidx luuçx jĩi neeyũuna jĩk. Txãn ensu' Abrahana' luuçx ji'phmeetewa txã'wẽk iidx luuçx jĩi jĩna puutx we'we. ");
INSERT INTO pbb_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Abrahan ji'j ma'wẽ fxi'zewa'ja'swa Dxusa' pta'sxku: Iidx ji'jwe'sxa' vxite kiwesu pkxuuna jxpe'jni kuatrocientos anxu fxi'zetxna. ");
INSERT INTO pbb_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Txã'wẽtewa txãa pkxuusawe'sxtxi' kastigaĩ'nja, kxah iidx ji'ja' txajũ kasehçxa naa kiwete adxa's selpiiya' yuwetxna jĩk. ");
INSERT INTO pbb_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Dxusa' Abrahan yakh puutx we'weçxa', txãa puutx we'weni's peçxkanaya'mée jĩçxa cirkuncidãy kaakh txajx luuçxtxi'. Txãa pa'gak Abrahana' txajx nçxi'k Isaak upxhni oçxo en ãjaçpkaçxha', cirkuncidãy. Txã'wẽy Isaakwa txajx nçxi'k Jakoba's cirkuncidãyku. Aça' Jakobwa txajx nçxi'kwe'sx docesatx txã'wẽyçxaçxáak yuu. Txãa Jakob nçxi'kwe'sx txã'wẽ Israelwe'sx ji'j docesa neywe'sxta'. ");
INSERT INTO pbb_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Txãa Jakob nçxi'kwe'sxa' nyakh Jose's ahçeçxa txweytxi, Egipto kiwen jxũna u'khan. Nawa Dxusa' José yakh txuteméek ũsu' nxuste fxi'zeçtewa nwe'wena. ");
INSERT INTO pbb_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Txãasak Egiptote jxkaahsa Fxaraon dxi'pte ew fxi'zewa'ja's ũs. Txã'wẽ yũute', Fxaraona' Jose's Egiptote ne'jwe'sx ki'pçxa jxkaahsa yata's thegwa'jsak nvxiht. ");
INSERT INTO pbb_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Txãn ensu' Egipto kiwete jxuka Kanaan kiwete yã'jçxa wala wẽje pa'kh kxũusu'jwa'jsa, aça' kwe'sx yaçgathẽ'ja' ũ'wa'j uymeeta'. ");
INSERT INTO pbb_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Nawa Jakoba' Egipto kiwete skuutxh txweywa'j ũsa' jĩni's jiyuçxa', txajx nçxi'k kwe'sx yaçgawe'sxtxi kaakh. Txãa entetx nyafxçxah Egipto kiwen u'j. ");
INSERT INTO pbb_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","E'su ki' u'the', Jose' pta'sxku: Adxa' i'kwe'sx nyakhthu jĩna. Aça' Egipto kiwete jxkaahsa' jiyuk Jose' kiim ji'thewa. ");
INSERT INTO pbb_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Txajũ' Jose' txajx ney Jakob petx nwe'sx jxukaysatx yuukaakh. Txãawe'sxa' setenta y cinko ãhtx yu'. ");
INSERT INTO pbb_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Txã'wẽ yũupa'gak Jakoba' Egipto kiwen u'pxa' u'jçxa kxtee uu, aça' kwe'sx ji'j nyafxtewe'sxwa txãa kiwetee uutx. ");
INSERT INTO pbb_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Nawa e'su txaçxte', José dxi'thtxi jxũna yuhçxa Sikem kiwetetx pedáa, Abrahana' Hamor nçxi'kwe'sxtxi kiwe weyku uusaatx pedawa'j jĩçxa kxtee. ");
INSERT INTO pbb_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Dxusa' Abrahana's kiwe ũswa'j en ãjaçte', Israelwe'sx Egiptote ũssa wala pehnatx. ");
INSERT INTO pbb_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Naapkaçxha' Egipto kiwete jxkaahwa'jsa' Jose's jiimeesak u'ka. ");
INSERT INTO pbb_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Txãa jxkaahsa' kwe'sx yaçgawe'sxtxi ahçena pkxuuya' takhku, luuçx u'se upxsatx kthegu'jmée uukahn. ");
INSERT INTO pbb_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Naapkaçxha' txãa ensu' Moiseswa upxku Dxus peeygãani wala zhiçxkwesa. Aça' neywe'sxa' yatte tekh a'te jxpe'jtx. ");
INSERT INTO pbb_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Nawa jwee yu' jxpe'jya' ãjameeçxa', yu'wala pukaga sũthte', jxkaahsa niisa uyçxa', txãak nuywala txajx luuçx na'wẽ vxitçxa. ");
INSERT INTO pbb_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Txãa pa'gak Moisesa' kĩhtewa jxuka kaapiya'jni yuu Egipto kiwetewe'sx na'wẽy, sa' kĩhtewa jxtuhthesak yu'. ");
INSERT INTO pbb_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Moisesa' kuarenta anxu ji'phuçxa', txajx nwe'sx Israelwe'sx ũsnite thegya' u'jya' yajkxku. ");
INSERT INTO pbb_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Kxtee ũsçxa uyku teeçx Egiptotewe'sx txã'wẽ Israelwe'sx teeçxsa's pkxuuna ũste, aça' Moisesa' ãhmeekwesa ju'gu yuuçxa Egiptotewe'sxa's ikhku. ");
INSERT INTO pbb_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Israelwe'sxa' Dxusne' kaah kwe'sxtxi nwe'weya' sũjkahnku txã'wẽ yũu Moisesa', nawa txãawe'sxa' txãa sũhmeeta'. ");
INSERT INTO pbb_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Kuskuskhẽ' Moisesa' uyku e'z Israelitawe'sx puiina ũste, sa' na'jĩnak nwe'we wẽe: I'kwe'sxa' pxakhsai'kwe, sa' ¿kĩjxa'kwe pui'? jĩte', ");
INSERT INTO pbb_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","vxite's uyisá' Moisesa's çxatxçxa na'jĩk: ¿Kimga idxa's npiiçthẽ'jsa kwe'sxtxi nwe'wewa'jsa na'wẽ vxitçxa nvxiht? ");
INSERT INTO pbb_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Jũ'na ma'wẽga Egiptotewe'sxa's ikh ¿txã'wẽy adxnawa ikhe'nja sũjuwá'ga? jĩte', ");
INSERT INTO pbb_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Moisesa' txãa kiweju ũphna u'jçxa Madian kiwenku u'j. Kxteek txajx kiwemeete pa'jçxa u'pu', sa' e'z luuçxku ji'phu. ");
INSERT INTO pbb_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Txãa kiwete Sinai vxiç utxasu nasa u'pnimeete kuarenta anxu fxi'zeçte', çhũçh tasxte ipx behnak vxyaa. Txãa pxãhte Dxus angela'sku uy. ");
INSERT INTO pbb_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Txã'wẽ uyçxa', Moisesa' kuh yajkxna utxaak ew thegya'. Naapkaçxha' Dxus we'weni na'wẽk pthũuse: ");
INSERT INTO pbb_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","Adxa' iidx yaçgawe'sx Abrahan, Isaak, Jakob txãawe'sx Dxusthu jĩte', Moisesa' ũukhna yayaçxa thegme'. ");
INSERT INTO pbb_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Aça' Dxusa' Moisesa's we'weçxa': Iidx pelgatxi's mpahde, ayte' kĩh pkal yuhwa ji'phmeesa ũsthu naa pa'ga. ");
INSERT INTO pbb_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Sa' Egiptote adx nasa pxthaa yuuni's uythu, sa' pxthaa we'weni'swa wẽse'th. Txãasath yuwé' nwe'weya'. Aça' adx jxkaahni's nwẽese'jçxa Egipto kiwen u'jwene'ga jĩk. ");
INSERT INTO pbb_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Israelwe'sxa' nyafxí' Moisesa's na'jĩnatx ahçe: ¿Kimga idxa's npiiçthẽ'jsa kwe'sxtxi nwe'wewa'jsa na'wẽ vxitçxa nvxiht? Txã'jĩna ahçetewa, Dxusa' çhũçh tasxte ipx ksxavxyuh vxyaaçxa', Moisesa's kaakh npiiçthẽ'jsa na'wẽ nwe'weya'. ");
INSERT INTO pbb_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Moisesku txã'wẽ kwe'sx yaçgawe'sxtxi Egipto kiwejuh kutxi'j txãa kiwete kĩjkĩhwa seena'sa kaavxya'ja'jçxa. Txã'wẽy Ĩkh Wala Behsajuwa kutxi'kh sa' nasa u'pnimeesu kuarenta anxuk txã'wẽ kim yuhwa ãjãnimeesa's kaavxya'ja'jna ũsu'. ");
INSERT INTO pbb_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Txãa Moisesíiçxáak Israelwe'sxtxi na'wẽ pta'sx: I'kwe'sx ji'j teeçxsa's kutxi'jçxa Dxusa' kaajxa'wa' txajx yuwe's pta'sxkahn, na'wẽk adxnawa kaah txã'wẽy. Aça' txã'sa' nwẽese'jwa'j ji'phi'kwe jĩk Moisesa'. ");
INSERT INTO pbb_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Moisesku txã'wẽ nasa u'pnimée kiwete ũsu' kwe'sx yaçga Israelwe'sx yakh. Sa' Dxus angel yakhwa Sinaí vxiç walate puutx we'weçxa kwe'sx yaçgawe'sxtxi pta'sxku. Sa' Dxus jxkaahna kwet taplate fxi'jnitxwa jxpa'gak kwe'sxtxi ũsya'. ");
INSERT INTO pbb_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Txã'wẽ yũutewa, kwe'sx yaçga Israelwe'sxa' Moisesa's nwẽese'jmée ahçeçxa, Egipto kiweníi sxawedxa'watx yu'. ");
INSERT INTO pbb_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Txajũ' Aarona's na'wẽtx we'we: Kwe'sxtxi pe'jna u'jwa'jsa dxus na'wẽsa mpheu'j. Txã'wẽme' Moises Egipto kiwejũ kwe'sxtxi kutxi'jsa kĩhne' yuu nawa vxyaame'. ");
INSERT INTO pbb_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Txã'jĩçxa' txãawe'sx kuseju klaa luuçx na'wẽ pheu'jçxa txã'snatx wala weçxana tajkx ikhçxa kab. ");
INSERT INTO pbb_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Txã'wẽ yũute', Dxusa' txãawe'sx tasxuh txuteek, ẽe walasu estrelxa ũsta' txãaçxáatx neewe'wekahn. Txã'wẽ yũuwa'ja's Dxus yuwe pta'sxsawe'sx librute na'wẽ fxi'jni': Israelwe'sxa' nasa u'pnimée kiwete kuarenta anxu ũsçxa', ¿adxna weçxaya'kwe tajkx ikhçxa kabna ũsu'á'? ");
INSERT INTO pbb_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Weh yuhwa txã'wẽ yũumée adxna weçxapkaçxte, Naasáa dxus ĩtximeesa Molokçxáanai'kwe txaja', Txã'wẽy estrelxa Renfxán yaasesa's i'kwe neewe'we' i'kwe'sx kuseju pheu'jnisatx. Txãa pa'ga i'kwe'sxtxi naa kiwejũ kutxi'jçxa Babilonia kiwen kaajxa'wath jĩna fxi'jni'. ");
INSERT INTO pbb_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Kwe'sx yaçgawe'sxa' nasa u'pnimée kiwete ũsçxa', Dxusna weçxana ũsni yat ji'phu'tx, Dxusa' ma'wẽne' Moisesa's vxitkaah txã'wẽy vxitçxatx ji'phu'. ");
INSERT INTO pbb_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Aça' txã'snatx kwe'sx yaçgawe'sx Joswé yakh yuusa' jxpa'gaçxa jxũna yuwé'. Sa' judiu ji'jmée vxite nasa ũsni kiwete ka'ga'jçxa, Davxid entepkaçxtxi ji'phu'. Txãa kiwe's Dxus pu'çxte vxite nasatx kutxi'jçxa txãawe'sxtxi iiyamu. ");
INSERT INTO pbb_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Dxus peeygãanisa Davxida' teeçx dxuus yat txaahwa'j pheu'kh kxtee Jakob ji'jwe'sx Dxus ũswa'j. ");
INSERT INTO pbb_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Nawa txãa dxuus yata's Salomonku txah. ");
INSERT INTO pbb_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Txã'wẽtewa, Dxus cielutewe'sxa' piçthẽ'jwe'sx txaahni yatte yu' ũswa'jsa yu'çme'. Txã'wẽçxaíik Dxusa' txajx yuwee pta'sxsa's na'wẽ kwe'we'j: ");
INSERT INTO pbb_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Cieluçxáa adx jxkaahna ũswa'ja', Aça' kiwe' adx çxida txahwa'jçxáa vxitnisa'. Txã'wẽte', ¿ma'wẽ adx ũswa'j yat txajaki'kwe naa kiwete? ¿Teeçx ahte adx jxkaasewa'j adx vxitnimeesa ũsmanx? ");
INSERT INTO pbb_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Nakwe seena' kĩjkĩhwa ũsta' nawa txã' jxuka adx vxitnisaçxaçxáata' jĩ'k Dxusa'. ");
INSERT INTO pbb_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Txã'wẽtewa, Dxus yuwe's i'kwe'sx ũuste jxpa'gaya' wa'lçxa thũ'wẽ's aphçxa i'kwe fxi'ze' Dxusa's jiimée na'wẽ. Bagaçxtewa Dxus Espiritu's ahçenaçxáa ũsi'kwe i'kwe'sx yaçgawe'sx na'wẽy. ");
INSERT INTO pbb_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","I'kwe'sx yaçgawe'sx ¿maaçxa' Dxus yuwe pta'sxsawe'sxtxi pkxuusamée ũstxmanx? Teeçx yuja' kĩh pkal yuhwa ji'phmeesa jĩna pta'sxsawe'sxtxi ikhtxi. Ãçxha' i'kwe'sxa' txãa pkal ji'phmeesa's ahçeçxa ikhi'kwe. ");
INSERT INTO pbb_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Dxus angel i'kwe'sxtxi Dxus leya's ũstewa, nwẽese'je'çmée i'kwe jĩte', ");
INSERT INTO pbb_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","txãawe'sxa' wẽse'jçxa', ki'thtxi ksuusu'jnatx ũusaçxa Estebana's. ");
INSERT INTO pbb_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Txã'wẽtewa, Estebana' Dxus Espiritu's ũuste jxukak ji'ph yu', sa' cielute pagayçxa Dxus u'pni seena' zhiçxkwesa's uyku, txã'wẽy Jesuswa Dxus pukate yujuçxa ũstek uy. ");
INSERT INTO pbb_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Sa' txã'wẽsa's uyçxa' na'jĩk: —Mthegwe, adxa' uyna ũsthu cielutewe'sx Dxus Nçxi'k Nasa Yuusá' Ney pukate ũsa' jĩçpkaçxha', ");
INSERT INTO pbb_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","txãawe'sxa' thũ'wẽtx yaaphçxa, sus weyçxa jxukaysa Estebana's ãaphtxi ikhya'. ");
INSERT INTO pbb_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Sa' çxhabuh kutxi'jçxa Estebana's açesawe'sxa' kwet wãatatahtx, txãawe'sx atxhtxi teeçx piçtakx Saulo yaasesa's kthegu'jçxa. ");
INSERT INTO pbb_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Kwet wãatatajaçpkaçxha', Estebana' na'jĩnak Dxus yakh puutx we'we: —Jesus, adx ũusa's miipa'ga jĩna'wa, ");
INSERT INTO pbb_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","peejxũkweçxa susku we'we na'jĩna: —Meen peltunaĩ na'wẽ yũuçta' txãawe'sxtxi'. Txã'wẽ we'wena'wa uuk Estebana'. ");
INSERT INTO pbb_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Estebana's ikheçte', Saulo' weçxanak ũsu'. Isa txãn entetx iiméh seena' ahçeya' takh Dxus yakh fxi'zesa Jerusalentewe'sxtxi. Txã'wẽ yũute', jxukaysa pũsxitx Judea kiwesu vxite' Samariasu, naasáa Jesus jxkaahnisawe'sxçxáatx neeyũu Jerusalente. ");
INSERT INTO pbb_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Estebana's ikhte', pedaaya' jxũna u'jtx Dxus yakh fxi'zesa yakhthẽ'jwe'sx wala ũ'nena. ");
INSERT INTO pbb_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Naapkaçxha' Saulo' Dxus yakh fxi'zesawe'sxtxi ahçeçxa yat iisak pakwena u'j txajũ juuna' yuuna kutxi'jçxa karcelte ktxaaja'jya' piçthẽ'j petx u'y yã'jçxa. ");
INSERT INTO pbb_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Nawa Jerusalen çxhabu ũphna u'jsa yu', Dxus yuwe's mteewa iipta'sxtxi u'jwe'. ");
INSERT INTO pbb_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Txajũ' Fxelipe' Samaria kiwete teeçx çxhabte pa'jçxa Kristo' kimtewa pta'sxku. ");
INSERT INTO pbb_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Aça' kxtee nasa pkhaakhesa' Fxelipe we'weni's wala jxpa'yajkx wẽse'jtx, sa' kim yuhwa ãjãnimeesa's kaavxya'ja'jni'swa uytxi. ");
INSERT INTO pbb_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Txã'wẽ maazkuẽe nasawa katxhinitx neeyũ' txã'wẽ txãawe'sx ũuste eçx ewmeesa sus weyna kasehte. Sa' txã'wẽy ẽseya' ãjasamée vxite' çxida puuple u'juya' ãjasameewa katxhitx. ");
INSERT INTO pbb_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Txã'wẽ yũute', txãa çxhabte nasa jxukaysa wala weçxana ũsu'tx. ");
INSERT INTO pbb_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Txãa çxhabte' teeçx dxijxuusáa Simon yaasesa' Samariate nasatx wala kaypuba'jna ũsu'k, adxa' kĩhtewa jxuka jiisath jĩna. ");
INSERT INTO pbb_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Aça' txã'snaçxaçxáatx nwẽese'jna weçxana ũsu' luuçx ma'k yuu thẽ'jsa ma'k yuu nawa jxuka na'jĩna: —Naa piçthẽ'ja's Dxusne' pu'çxhi' jĩ'tx. ");
INSERT INTO pbb_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Sa' txajx jxkaahni's jxukatx nwẽese'je', txã'wẽ txajx dxijxuuni yakh wala txaçxyã'j kaypuba'jna ũsu'ne' naa pa'ga. ");
INSERT INTO pbb_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Nawa Fxelipe' Dxus jxkaahwa'ja's pta'sxna pa'jçxa, Jesukristo' Dxus kaahnisa' jĩte' jiyuçxa', piçthẽ'j petx u'y yã'jçxa yu'te ya'bautisãytxi. ");
INSERT INTO pbb_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Aça' txã'wẽ txãa dxijxuusaawa Fxelipe pta'sxni's jiyuçxa', yu'te ya'bautisãyçxa Fxelipe yakh u'ju'k. Sa' txã'wẽ kĩjkĩhwa kaavxya'ja'the' txã'sna uyçxa' kujk yajkxna u'ju'. ");
INSERT INTO pbb_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Txajũ' Jesus jxkaahnisa Jerusalente ũssa' txã'wẽ Samariatewe'sxwa Dxus yuwe's txãawe'sx ũuste jxpa'gaçxa ya'bautisãytxi jĩni's jiyuçxa', kaahtx Pedro's Juan yakh. ");
INSERT INTO pbb_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Aça' kxtee txãawe'sx pa'jçxa', Dxus yakh puutx we'wetx Dxus yuwe's jxpa'gasa Samariatewe'sx pa'gate, Dxus Espiritu's jxpa'gakahn. ");
INSERT INTO pbb_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Txã'wẽme', nyafxíi yu' Dxus Espiritu's ji'phmeetx yu', naasáa Jesusa'sçxáatx jxpa'gaçxa yu'te ya'bautisãysa yu'. ");
INSERT INTO pbb_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Txajũ' Pedrowe'sxa' txãawe'sx dxikthesu peekizeçxa Dxus yakh puutx we'wete', Dxus Espiritu's jxpa'gatx. ");
INSERT INTO pbb_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Aça' txã'wẽ yũuteçxáa Dxus Espiritu kĩjaçte uyçxa', txãa dxijxuusáa Simona' vxyu ũs wẽek ");
INSERT INTO pbb_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","na'jĩna: —I'kwe'sx txã'wẽ ãjani's adxnawa mahwe, kxah adxwa dxikthesu peekizeteçxáa maawa Dxus Espiritu's jxpa'gatxna jĩte', ");
INSERT INTO pbb_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Pedro pasçxa': —Iidx vxyu' idx yakh ja'da vxituna, Dxus peesni's vxyu yakhgu wey wẽje' naa pa'ga. ");
INSERT INTO pbb_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Idxa' kwe'sx na'wẽy yuuwa'j yu'sa' le'çxkwe yuhwa jxpa'gawa'j ji'phmeeg, Dxus dxi'pte ewmeeg yaaki' naa pa'ga. ");
INSERT INTO pbb_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Txã'wẽ ewmée yũuwa'jçxá's yaakxni's nvxihtçxa, Dxusa's mneewe'we. Txã'wẽ yũute', peltunaĩwáana. ");
INSERT INTO pbb_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Txã'wẽme' iidx ũuste iiwejçx iiwejçx yaakxwa'jçxáana uta ji'phgu, aça' txã'wẽ yaakxnisa' jxuka idxa's tudçxa ji'pha' jĩte', ");
INSERT INTO pbb_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Simon pasçxa': —I'kwe'sxa' adx pa'gate Dxus yakh meen puutx we'wewe. Txã'wẽme', Dxusa' peltunãywe'sxmeeta' adxa's jĩk. ");
INSERT INTO pbb_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Txajũ' Jesus jxkaahnisawe'sxa' Dxus yuwe's pta'sxçxa txajũ kasehtx Samaria kiwesu vxite' çxhabkuẽsu Dxus yuwe's pta'sxya'. Sa' txã'wẽ yũuçxatx Jerusalenna ki' sxawed. ");
INSERT INTO pbb_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Txãa e'su' Dxus angela' Fxelipe's na'jĩnak jxkaah: —Ayjxu kasehçxa me'j Jerusalenu Gasa çxhabna u'jni dxi'jsu. Txãa dxi'ja' nasa u'pnimeesuk skhẽwna ũsu'. ");
INSERT INTO pbb_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Txã'jĩte', Fxelipe' txãa dxi'the u'jweççxa' teeçx piçthẽ'j eunuko Etiopía kiwejuwe'sx u'jweçtek uy. Txãa piçthẽ'ja' Etiopía kiwete reina Kadace tasxte vxyuu jxaawsak yu'. Sa' Dxusa's weçxaya' pa'jsak yu' Jerusalente. ");
INSERT INTO pbb_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Txãasak txajx kiweníi sxawedna txajx u'jni kaçxetilxate kaçxçxa Dxus yuwe pta'sxsa Isaias libru's lẽeyna u'jweç yu'. ");
INSERT INTO pbb_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Txajũ' Dxus Espiritu' Fxelipe's we'wek: Kaçxetilxate u'jsa's kpajkxya' me'j jĩte', ");
INSERT INTO pbb_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Fxelipe utxaana sẽhçxa' Isaias librute na'jĩna lẽeyni's wẽse'jçxa' pẽjxku: —¿Jiyu'gá' iidx lẽeyni's? jĩte', ");
INSERT INTO pbb_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","txãa piçthẽ'ja' na'jĩk: —¿Ma'wẽ yũuçxa jiyuki'th? kimwa pta'sxmeete' jĩçxa', Fxelipe's kaçxetilxate tejkaçxa pukate kaçxkaakh. ");
INSERT INTO pbb_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Sa' Dxus librute na'wẽ fxi'jni'sku lẽeyna u'jweç yu': Piisxakuẽ na'wẽk ikhya' jxũna u'jni yuu. Piisxakuẽwa ma'wẽga khas wakaçte' pebe'çmée, txã'wẽy txãawa pebeeme'. ");
INSERT INTO pbb_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Ãhmeekwesa na'wẽ yuupa'ga, nwe'wenimeek uu, Aça' txajx luuçx jĩnisa kim yuhwa neeyũumeeta'. Txã' naa kiwete txaçx fxi'zemeyna ikhnik yuu naa pa'ga. ");
INSERT INTO pbb_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Txajũ' txãa piçthẽ'j lẽeyna u'jsa' pẽjxku Fxelipe's: —Adxa's meen peeta'sx, Dxus yuwe pta'sxsa ayte we'we'k txã' ¿kimnaga we'we'? ¿Peekx uuwa'ja's wá' we'we'? meeçxa' ¿vxitesa uuwa'ja's wá' pta'sxi'? jĩte', ");
INSERT INTO pbb_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Fxelipe' txãa lẽeyni's pta'sxku: Na' Jesus uuwa'ja'sku we'we' jĩna. ");
INSERT INTO pbb_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Txajũ' teeçx ahte yu'te pa'jçxa', txãa piçthẽ'j Etiopiajuwe'sxa' na'jĩk: —Ayte yu' u'pa' aça' adxa' ãçxhíi ya'bautisãy wẽewaça', ¿ãjãma'th? jĩte', Fxelipe' na'jĩk: ");
INSERT INTO pbb_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","—Iidx ũusuh jxuka txã'wẽ Jesusa' Dxus Nçxi'kne' yu' sũhçxa yu', ya'bautisãyya' ãjane'ga jĩna pta'sxte', txãa piçthẽ'j pasçxa': —Jesukristo' Dxus Nçxi'k yuh yu'ne' sũju'th adxa' jĩk. ");
INSERT INTO pbb_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Txajũ' kaçxetilxa's kxuuju'jçxa, e'zíi yu'te kĩhçxa Fxelipe' bautisãyku txãa Etiopiajuwe'sxa's. ");
INSERT INTO pbb_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Txãa yu'ju kasejeçpkaçxha', Dxus Espiritu' Fxelipe's jxũna u'kh, aça' txãa Etiopiajuwe'sxa' peena yu' uymeeçxawa txajx dxi'the wala wẽtwẽt weçxana u'kh. ");
INSERT INTO pbb_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Txajũ' Fxelipe' Azoto çxhabte pa'jçxa', çxhab iisak Dxus yuwe's pta'sxna u'j, Cesarea çxhabte pa'phkaçx. ");
INSERT INTO pbb_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Naapkaçxha' Saulo yu' ikhwẽena nesku yu' Jesusa's nwẽese'jsawe'sxtxi. Txãasak sacerdote npiiçthẽ'j tasxna u'j, ");
INSERT INTO pbb_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","karta pẽjxya' Damasko çxhabna u'jçxa judiuwe'sx pkhaakheni yat-su Jesusa's nwẽese'jsatx pakweçxa' piçthẽ'j petx u'y tudçxa Jerusalenna preesu jxũna u'jya'. ");
INSERT INTO pbb_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Damaskote pa'jya' utxaana u'jweçpkaçxha', txajx dxi'pte uymeenusku cieluju eena'sa kweeth. ");
INSERT INTO pbb_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Aça' Saulo' weteçxa' wẽse'kh na'wẽ we'weni's: —Saulo, Saulo, ¿kĩh yũupa'gaga adxa's ahçeçxa pkxuuya' pakwé'? jĩte', Saulo' pẽjxku: ");
INSERT INTO pbb_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","—Idxa' ¿kimga? jĩna. Sa' na'wẽ we'weni'sku wẽse'j: —Adxíi Jesusthu, idx na'wẽ ahçeçxa pkxuuya' pakwe'g txãath. Idxa' peekíiçxáa ya'kpã'yuuwa'ja's pakwena ũsgu jĩte', ");
INSERT INTO pbb_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Saulo' ũukhnite yayana na'jĩk: —Idxa' ¿kĩhga yũu jxthãasu' adxa's? jĩte', na'wẽk pas Jesusa': —Kiiteçxa me'j çxhabna. Kxtee pa'the ya'pta'sxina kĩh yũuwa'ja'swa jĩk. ");
INSERT INTO pbb_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Txã'wẽ yũute', Saulo yakh u'jsa' wala ũukhtxi, txã'wẽ puutx we'wetewa kimnawa uymeeçxa. ");
INSERT INTO pbb_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Txajũ' Saulo' kiiteçxawa uyya' ãjame'. Aça' pu'kisçxa jxũna u'jtx Damaskon. ");
INSERT INTO pbb_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Kxte' tekh en uyya' ãjamée, txã'wẽy kĩhwa ũ'meek u'pu'. ");
INSERT INTO pbb_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Damaskote' Jesusna nwẽese'jsa Ananias yaasesak u'pu'. Txã'sa' Jesus vxyaaçxa na'wẽk we'we: —Ananias jĩna pa'yate', Ananias pasçxa': —¿Kĩh kaajxa'waga? jĩte', ");
INSERT INTO pbb_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Jesus we'weçxa': —Teeçx klxiikhun Ku'le yaasesate me'j. Kxtee pa'jçxa Judas yatte pẽyine'ga: Teeçx piçthẽ'j Tarsojuwe'sx Saulo yaasesa's peejxthu jĩna. Txãa piçthẽ'ja' Dxus yakh puutx we'wena u'pa'. ");
INSERT INTO pbb_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Sa' teeçx piçthẽ'j Ananias yaasesa pa'jçxa ki' uyya' ãjakahn txajx kakwete peekizeeçtek ksxa'w. ");
INSERT INTO pbb_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Txã'jĩna we'weni's wẽse'jçxa' Ananiasa' na'jĩk: —Adxa's maawa wala iipta'sxta' Jerusalente idx yakh fxi'zesawe'sxtxi txã'wẽ wala pkxuusa' txãa piçthẽ'ja' jĩ'tx. ");
INSERT INTO pbb_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Sa' ãçxwa naa çxhabte yuja' sacerdote npiiçthẽ'jwe'sxtxi karta pẽjxçxa idxna yaakxsawe'sxtxi preesu jxũna u'jya' jĩte', ");
INSERT INTO pbb_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Jesus pasçxa': —Idxa' me'jçxáa. Txãa piçthẽ'ja' adx txhitxhnisa' adx yuwe's pta'sxwa'jsa nasa vxite kiwejuwe'sxtxi, jxkaahsawe'sxtxi, sa' Israelwe'sxtxiwa pta'sxwa'jsa'. ");
INSERT INTO pbb_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Adxa' txãa piçthẽ'ja's pta'sxi'nja adxna selpiina u'jupa'ga makwe pkxuuni yuuwa'ja'swa jĩte', ");
INSERT INTO pbb_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Ananiasa' Saulo u'pni yatna u'jçxa', txajx kakwete peekizeçxa na'jĩk: —Yakhthẽ'j Saulo, dxi'the idx yuhte Jesus vxyaane' txãak adxa's kaah idx ki' uyya' ãjaçxa Dxus Espiritu's ũuste jxuka jxpa'gakahn jĩçpkaçxha', ");
INSERT INTO pbb_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","yafxte aphsa ubute', ki' uyya' ãjaçxa', kiiteçxa ya'bautisãyku. ");
INSERT INTO pbb_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Txajũ' ũ'wa'ja's ki' jxpa'gaçxa çxhãçxhak, sa' Damaskotee ũsu'k maz enwa Jesusa's nwẽese'jsawe'sx yakh. ");
INSERT INTO pbb_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Txajũ' Saulo' Dxus yuwe's pta'sxya' takhku judiuwe'sx pkhaakheni yat-su Jesusa' Dxus Nçxi'ka' jĩna. ");
INSERT INTO pbb_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Aça' wẽse'jsa jxukay kuh yajkxna na'wẽtx we'we': —¿Naa piçthẽ'jíi txã'wẽ Jerusalente Jesusa's neewe'wesatx ikh wẽena fxi'zesameená'? Sa' ¿txã'wẽy aytewe'sxtxiwa preesu jxũna u'jçxa sacerdote npiiçthẽ'jwe'sx kusete dukhya' sũhçxa yuusa yu'çmeená'? jĩ'tx. ");
INSERT INTO pbb_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Txã'jĩçtewa Saulo yu' jweeíiçxáak çxhãçxha pta'sxi' Jesusa' Dxus tasxu yuusa Kristo yuh yu'k jĩna, sa' kxtee Damaskote judiuwe'sxtxi ma'wẽ paswa'ja's yuhwa ji'phmeek nvxiitu'. ");
INSERT INTO pbb_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Txãa e'su txaçxte', judiuwe'sxa' Saulo's ikhya' puutx we'weçxa ");
INSERT INTO pbb_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","çxhabu kasehni vxitxte en kuswa yupna nestxi yuu. Aça' txã'wẽ yũuni's Saulo' jiyuk. ");
INSERT INTO pbb_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Aça' Saulo's pi'kxna u'jusawe'sxa' kusçxáa Saulo's kanasta walate akhçxa çxhab peeku'j uphnikhẽtx ekaju spajkx açesa kusejũ nwe'weya'. ");
INSERT INTO pbb_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Txãa e'su' Saulo' Jerusalente pa'jçxa', Jesusa's nwẽese'jsawe'sx yakh pkhaakhe wẽek. Nawa kxteewe'sx jxukaysa ũukhtxi Jesusa's nwẽese'jsameewáana sũhçxa. ");
INSERT INTO pbb_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Txã'wẽtewa Bernabé yu' pe'jna u'jçxa Jesus jxkaahnisawe'sx tasxte nuypa'jçxa na'wẽk pta'sx: —Saulo's Jesus vxyaak Damasko dxi'the u'jweçte, sa' txãa yakh puutx we'wek. Aça' Saulo' Damaskote pa'jçxa Jesus kaapiya'jniçxaçxá'sku pta'sxna ũsu' jĩna pta'sxte', Saulo's ũukhmée jxpa'gatx. ");
INSERT INTO pbb_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Aça' Jerusalente ũsu'k txãawe'sx yakh pkhaakhena. ");
INSERT INTO pbb_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Sa' judiuwe'sx griego yuweju we'wesa yakh ũukhmeek puutx we'we' Jesus kaapiya'jni's pta'sxna. Nawa txãawe'sx yu' ahçeçxa ikhya'watx yu'. ");
INSERT INTO pbb_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Aça' txã'wẽ yũuni's yakhthẽ'jwe'sx jiyuçxa', Saulo's pe'jna u'jtx Cesarea çxhabna. Txajũ Tarso çxhabnatx kaah. ");
INSERT INTO pbb_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Txajũ' Dxus yakh fxi'zesa Judea, Galilea, Samariasuwe'sxa' kim yuhnawa ũukhmée jweeíiçxáatx çxhãçxhana u'j Dxusçxáana nwẽese'jna. Aça' Dxus Espiritu pu'çxte', jweeíiçxáatx pehnana u'j. ");
INSERT INTO pbb_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Txajũ' Pedro' yakhthẽ'jwe'sxtxi Dxus yuwe's pta'sxya' kasehçxa', Lida çxhabte Jesusa's nwẽese'jsawe'sxtxiwa thegya' u'kh. ");
INSERT INTO pbb_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Kxte' teeçx piçthẽ'j Eneas yaasesa oçxo anxuk ãça'na ũsu' ẽseya' ãjameeçxa. ");
INSERT INTO pbb_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Aça' Pedro' na'jĩk: —Eneas, idxa's Jesukristo nuykatxhina. Aça' kiiteçxa iidx deeni's mkiis jĩçpkaçxha', txãa piçthẽ'ja' naa dudtey kiitek. ");
INSERT INTO pbb_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Aça' kxtee Lida çxhabte vxite' Sarón kiwete ũssa jxukaysa uyçxa', Jesusa's nwẽese'jya' utxaatx. ");
INSERT INTO pbb_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Txãn ensu' Jope çxhabte Jesusa's nwẽese'jsa teeçx u'pu'k Tabita yaasesa. Txã' griego yuwete' Dorkasku yaase yu'. Txãa u'ya' wala pu'çxna fxi'ze'k maawa peejxsatxi'. ");
INSERT INTO pbb_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Txãa ensu' Dorkasa' ãça'çxa uuk. Aça' uuníi kakwe's kpẽeu'jçxa ẽe yatgatx khikh. ");
INSERT INTO pbb_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Pedro ũsni Lida çxhaba' Jope çxhab yakh utxak yu'. Aça' Jope çxhabte Jesusa's nwẽese'jsawe'sxa' Pedro' Lida çxhabte ũsa' jĩni's jiyuçxa', e'z piçthẽ'j kaahtx Pedro's na'wẽ pta'sxya': —Jxthẽeyuumée Jope çxhabna myuh jĩte', ");
INSERT INTO pbb_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Pedro txãawe'sx yakh u'jçxa kxte pa'the', pe'jna u'jtx uusáa ũsniga. Aça' vxiudawe'sx jxukaysa ũ'nena pkhaakheçxa pta'sxtxi Dorkas nee ĩtxiy kmiisa umçxa peesnitx. ");
INSERT INTO pbb_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Txajũ' Pedro' jxukaysatx eka kutxi'jna'wa, peejxũkweçxa Dxus yakh puutx we'wena'wa uusá's thegçxa na'jĩnak we'we: —Tabita, mkiitewe jĩçpkaçxha', txãa uusá' thegçxa Pedro's uyna'wa kiiteçxa kaçxku. ");
INSERT INTO pbb_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Txajũ' Pedro' pu'kisçxa kxuuju'jna'wa, Dxus yakh fxi'zesawe'sx vxite' vxiudawe'sxtxi pa'yaçxa, ĩtxik dukh. ");
INSERT INTO pbb_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Txã'wẽ yũuni's Jope çxhabtewe'sx jxukaysa jiyuçxa', wala kuhsa Jesusa's nwẽese'jya' utxaatx. ");
INSERT INTO pbb_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Txajũ' Pedro' Jope çxhabte kuh enku ũsu' kha'tx weysáa Simon yatte. ");
INSERT INTO pbb_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Cesarea çxhabte teeçx soldau kpiitan Kornelio yaasesa u'pu'k. Txã' Italiajuwe'sx soldautx jxkaahsak yu'. ");
INSERT INTO pbb_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Txãa piçthẽ'ja' Dxusna weçxana fxi'zesak yu', txajx yattewe'sx jxukaysa yã'jçxa. Sa' Dxus yakh pu'vxituméek puutx we'wena fxi'ze', txã'wẽy vxyuuwa wala pu'çxhi'k judiuwe'sxtxi. ");
INSERT INTO pbb_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Teeçx ente kusuçte las treste' Dxus angel txajx tasxte u'kaçxa na'jĩna we'weçtek uy: —¡Kornelio! jĩna pa'yate', ");
INSERT INTO pbb_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","txãa piçthẽ'ja' wala ũukhna Dxus angela's thegçxa' na'wẽk pas: —¿Kĩh pẽjxga? jĩte', Dxus angel we'weçxa': —Idxa' txã'wẽ peejisaatx pu'çxna Dxus yakh pu'vxitumée puutx we'wena fxi'zeni's Dxusa' wẽse'kh. ");
INSERT INTO pbb_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Aça' idxa' Pedro's pe'jya' mkaah Jope çxhabna. ");
INSERT INTO pbb_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Txãa Pedro' kha'tx weysáa Simon yatte paadehna ũsa' ĩkh wala pukate. Aça' Pedro pa'jçxa pta'sxina idx ma'wẽ yũuwa'ja'swa jĩte', ");
INSERT INTO pbb_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","txãa angel u'jweçpkaçxha' Kornelio' e'z selpisáa vxite' teeçx soldau Dxus dxi'pte ew fxi'zesa txãawe'sxtxi pa'yaçxa, ");
INSERT INTO pbb_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","jxuka pta'sxna'wa Jope çxhabna kaakh. ");
INSERT INTO pbb_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Txãawe'sxa' kuskuskhẽ Jope çxhabte utxaana pa'jaçpkaçxha', ẽepxãh yuuçte' Pedro' tejkak ẽe yat pwa'te Dxus yakh puutx we'weya'. ");
INSERT INTO pbb_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Sa' Pedro' wala wẽek, aça' txajx ũ'wa'j pheu'juçtxi yu'. ");
INSERT INTO pbb_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Naapkaçxha' Pedro' uyku cielukhẽ tela wala na'wẽsa puutx vxiçte tudçxa nuykĩjaçte. ");
INSERT INTO pbb_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Kxte yu' niimal yu'kh eçx, ul, vxiçxakwe kazxsatx jxuka ãsxnisak ji'phu'. ");
INSERT INTO pbb_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Txajũ' na'wẽ we'weni'sku wẽse'j: —Pedro, kiiteçxa naa niimaltxi' ikhçxa mẽ' jĩte', ");
INSERT INTO pbb_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Pedro pasçxa': —Adxa' bagaçxte yuhwa na'wẽ niimal kazxsa yuutxi' ũ'wa'jsameeth jĩk. ");
INSERT INTO pbb_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Aça' ki' we'weni wẽse'kh: —Dxus yaatenisatxi' idxa' kazxsata' jĩwa'j ji'phmeeg ãçxha'. ");
INSERT INTO pbb_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Txã'wẽ tekh uswa vxyaaçxak, txãa tela wala na'wẽsa' ki' cieluníi pu'kisni yuu. ");
INSERT INTO pbb_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","¿Kĩh yũukahnki'k txã'wẽ vxyaa? sũhna Pedro u'ppkaçxha', Kornelio kaahnisa' pa'jtx Simon yata's paapẽjxna. ");
INSERT INTO pbb_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Sa' sustxi pa'yana kũh: —¿Naa yatte paadeesa Simon Pedro yaasesa ũsmeená'? jĩna. ");
INSERT INTO pbb_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Pedro' txã'wẽ uyni's ũus yajkxna u'piyna, Dxus Espiritu' we'wek: —Tekh piçthẽ'j idxa's paapẽjxna ũsta'. ");
INSERT INTO pbb_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Aça' kiiteçxa txãawe'sx yakh me'j kuh yajkxmée. Txã'wẽme', txãawe'sxa' adx kaahni yuhta' jĩte', ");
INSERT INTO pbb_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Pedro sa'jçxa Kornelio kaahnisawe'sxtxi pẽjxku: —¿Ma'jĩya'kwe yuwé'? I'kwe'sx pakwenisa' adxthu jĩte', ");
INSERT INTO pbb_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","txãawe'sxa' pta'sxtxi: —Soldau kpiitan Kornelio kaahni yuhtha'w. Txãa piçthẽ'ja' wala ew zhiçxkwe fxi'ze'k Dxusna nwẽese'jna, aça' txã'sa' judiuwe'sx jxukaysa wala wedxi'tx. Sa' teeçx ente' Dxus angel vxyaaçxa' idxa's pa'yakahn yuwe nvxihtga. Kxah Kornelio' jiyuna kĩh pta'sxwa'j ji'phne'ga txã'sna. ");
INSERT INTO pbb_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Txã'jĩte', Pedro' txajx deenite ka'ga'jçxa, kxte dehçxa kuskuskhẽ' Pedro' u'kh txãawe'sx yakh, aça' kxte Jope çxhabte yakhthẽ'jwe'sxwa u'jtx pi'kxna. ");
INSERT INTO pbb_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Kuskuskhẽ' Cesarea çxhabte pa'jtx, aça' kxte' Kornelio' ũythasnak ũsu' txajx nwe'sx vxite' txajx namiku yakh pkhaakheçxa. ");
INSERT INTO pbb_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Pedro pa'jaçpkaçxha', Kornelio' jxpa'gaya' kasehçxa Pedro tasxte peejxũkwek weçxana. ");
INSERT INTO pbb_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Nawa Pedro' pu'kisçxa na'wẽk we'we: —Adxa's peejxũkwenu. Adxa' idx na'wẽysa íiçxáath jĩçxa', ");
INSERT INTO pbb_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Kornelio yakh puutx we'wena dxiite u'kaççxa', kxte yu' wala kuh pkhaakheçxa ũstek uyna kũh. ");
INSERT INTO pbb_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Sa' Pedro' na'jĩk: —I'kwe'sxa' jiine'kwe, judiuwe'sxa' pkhaakhena puutx we'wewa'jsameeta' vxite nasa judiumeesa yakha'. Nawa Dxusa' adxa's pta'sxçxa', kim yuhnawa açekaahme'. ");
INSERT INTO pbb_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Txãa pa'gath pa'yaçpkaçxha', wa'lmée yuwé'. Ãçxha' adxa's mpeeta'sxwe kĩya'kwe yuukaah jĩte', ");
INSERT INTO pbb_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Kornelio' pta'sxku: —Ãçxha' pahz en yuuça' naapkaçxha' naa oratey las treste naa yattey kĩhwa ũ'mée Dxus yakhçxáa puutx we'wena u'pu'th. Naapkaçxha' teeçx piçthẽ'j athni ropa kwentetesa ji'phsa vxyaak. ");
INSERT INTO pbb_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Sa' na'wẽk we'we: Kornelio, idxa' txã'wẽ peejisaatx pu'çxna Dxus yakh puutx we'wena fxi'zeni's Dxusa' wẽse'kh. ");
INSERT INTO pbb_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Aça' Jope çxhabna mkaah, Simon Pedro yaasesa's pe'jya'. Txãa Pedro' kha'tx weysáa Simon yatte paadehna ũsa' ĩkh wala pukate. Aça' txã' ayte pa'jçxa puutx we'wena idx yakh jĩnak we'we. ");
INSERT INTO pbb_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Txã'wẽ jxkaah yã'the', jxthẽeyuumée pakweya' kaath. Aça' weçx yuwe'ne'ga. Ãçxha' ayte Dxus dxi'pte jxukaysa pkhaakheçxa ũstha'w, sa' wẽse'jya'watha'w ma'wẽne' Dxus we'wekaah txã'sna. ");
INSERT INTO pbb_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Txajũ' Pedro' pta'sxku: —Ãçxha' jiyuth Dxusa' kim yuhnawa ahçemée, ");
INSERT INTO pbb_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","maa kiwejuwe'sxçxawa txã'sna nwẽese'jna ew yũuna fxi'zesa yuutxi' jxpa'ga'çxáak. ");
INSERT INTO pbb_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Dxusa' Israelwe'sx ji'jtx yuwe kaakh Dxus yakh fxi'zewa'ja's Jesukristo yuuçxáa ũsuna sa' txãaíiçxáa naa kiwetewe'sx jxukaysatx jxkaajana jĩna. ");
INSERT INTO pbb_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","I'kwe'sxa' jiine'kwe na'wẽk yuu: Galileajũ takhçxa judiuwe'sx kiwete jxuka tuuthe'jnik yuu, Juan Dxus yuwe's pta'sxçxa yu'te bautisãynijũ. ");
INSERT INTO pbb_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Dxusa' Nasarethuwe'sx Jesusa's txajx Espiritu's ũste', Jesusa' kĩhtewa nuykatxhinak fxi'ze eçxthẽ'j kusete ũssatx. Dxusa' txãa yakhku ũsu' naa pa'gak txã'wẽ yũu. ");
INSERT INTO pbb_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Jesusa' txã'wẽ Judea kiwesu vxite' Jerusalente kĩhtewa ew yũuna fxi'zeni's kwe'sxa' jxuka uysaatha'w. Txã'sa' kluuskhẽ a'kxçxa ikhtxi. ");
INSERT INTO pbb_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Nawa Dxusa' tekh ente ki' ĩtxi vxitçxa kaavxya'ja'kh kwe'sxçxáatx, nasa jxukaysatx yu' mée. ");
INSERT INTO pbb_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Dxusa' maaçxahtxne' kwe'sxtxi txhitxh txãaçxáatxku vxyaa. Aça' kwe'sxa' txãa yakh pkhaakhena ũ'na fxi'zesatha'w uuçxa ki' ĩtxi yuunijũ. ");
INSERT INTO pbb_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Txajũ' txã' kwe'sxtxi kaakh txajx yuwe's nasatx na'wẽ pta'sxkahn: Dxusa' txãa Jesusa's txãaçxaçxáa kastigãywa'jsak vxitçxa ki'p naa kiwete ĩtxisa ma'tx yuu uusáa ma'tx yuu nawa jxukaysatx. ");
INSERT INTO pbb_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Txã'wẽy Dxus yuwe pta'sxsawe'sxwa yaçkhẽy we'wetx Jesusa' na'wẽ yũuwa'jsa' jĩna: Maawa jxukay txã's nwẽese'jsa' txãawe'sx pkaltxi peltunãyni yuutxna jĩnatx we'we. ");
INSERT INTO pbb_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Pedro' txã'wẽ pta'sxna ũsiyna, kxte wẽse'jna ũssawe'sx kakwete Dxus Espiritu kĩhte', jxukaysa jxpa'gatx. ");
INSERT INTO pbb_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Aça' Jesusna nwẽese'jsawe'sx judiu Pedro yakh yuusá' wala kuh yajkxna neeyũutx txã'wẽ judiuwe'sxmée vxite nasawa Dxus Espiritu's jxpa'gaçxa, ");
INSERT INTO pbb_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","txã'wẽ vxite yuweju we'wena Dxusa's tuuthe'jna ũste. ");
INSERT INTO pbb_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Txajũ' Pedro' na'jĩk: —Naa nasawa kwe'sx na'wẽy Dxus Espiritu's jxpa'ga yã'the', yu'te bautisãywa'ja's ¿kimçxá' yupxa' ãjama'k? jĩçxa', ");
INSERT INTO pbb_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","ya'bautisãy kaakh Jesukristo yasete. Txajũ' Pedro's neevxisxatx txãawe'sx yakh maz en kxtee ũskahn. ");
INSERT INTO pbb_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Jesus jxkaahnisa vxite' yakhthẽ'jwe'sx Dxus yakh fxi'zesa Judea kiwete ũssa' jiyutx txã'wẽ judiu ji'jmée vxite nasawa Dxus yuwe's jxpa'gatx jĩni's. ");
INSERT INTO pbb_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Sa' Pedro Jerusalen çxhabte sxawedna pa'the', kxte judiu cirkuncidãynisawe'sxa' ũusçxawe'wetx Pedro's na'jĩna: ");
INSERT INTO pbb_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","—¿Kĩjxa'ga judiumée vxite nasa tasxsu u'jçxa txãawe'sx yakh pkhaakheçxa ũ'we'? ");
INSERT INTO pbb_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Txajũ' Pedro' pta'sxku ma'wẽ yũuni'swa jxuka: ");
INSERT INTO pbb_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","—Adxa' Jope çxhabte Dxus yakh puutx we'wena u'pçxa uythu tela wala na'wẽsa puutx pahz vxiçte tudçxa ẽe walakhẽ kaahni kĩjk adx tasxte pa'j. ");
INSERT INTO pbb_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Aça' ew thegte', dxiite yu' niimal yu'kh eçx, ul, vxiçxakwe kazxsak ji'ph yu'. ");
INSERT INTO pbb_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Txajũ' na'jĩni'sthu wẽse'j: Pedro, kiiteçxa ikhçxa mẽ' jĩte', ");
INSERT INTO pbb_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","na'wẽth pas: Adxa' bagaçxte yuhwa na'wẽ niimal kazxsa yuutxi' ũ'wa'jsameeth. ");
INSERT INTO pbb_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Txajũ' ki' pthũusek cieluju we'weni: Dxus yaatenisatxi' idxa' kazxsata' jĩwa'j ji'phmeeg jĩk. ");
INSERT INTO pbb_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Txã'wẽ tekh uswa vxyaaçxak ẽe walate ki' pu'kisni yuu. ");
INSERT INTO pbb_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Naapkaçxha' Cesareaju kaahnisa tekh piçthẽ'j pa'jtx adxa's pakwena. ");
INSERT INTO pbb_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Aça' Dxus Espiritu' adxa's u'khaakh txãawe'sx yakh wa'lmée. Txajũ' Jope çxhabtewe'sx seis yakhthẽ'jwe'sx yakh u'jçxa' jxukaysa Kornelio yatte u'katha'w. ");
INSERT INTO pbb_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Aça' txãa piçthẽ'ja' pta'sxku Dxus angel vxyaaçxa na'wẽ we'weni's: Jope çxhabna Simon Pedro yaasesa's pa'yaya' mkaah. ");
INSERT INTO pbb_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Aça' txãa pa'jçxa pta'sxina iidx yatte jxukaysawe'sx Dxus yakh fxi'zewa'ja's. ");
INSERT INTO pbb_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Txã'wẽ pta'sxte', adx we'weçpkaçxha', Dxus Espiritu' txãawe'sx kakwete kĩjk, kwe'sx kakwetewa ma'wẽga nyafxíi kĩh txã'wẽy. ");
INSERT INTO pbb_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Txajũ' yajkxthu kwe'sxtxi jxpe'jsa Jesukristo na'wẽ we'weni's: Juana' yu'teçxáak akhna bautisaĩ'. Nawa i'kwe'sxa' Dxus Espiritute yuu bautisãyni yuune'kwe jĩni's. ");
INSERT INTO pbb_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Kwe'sxa' Jesukristo's nwẽese'pha'ga Dxusa' ma'wẽga txajx Espiritu's ũs, txã'wẽyku txãawe'sxtxiwa ũs. Aça' adxa' ¿ma'wẽ yũuçxa Dxus wedxni's wa'lna ũsuki'th? ");
INSERT INTO pbb_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Txajũ' Jerusalente ũssa yakhthẽ'jwe'sxa' wẽse'jçxa', peena yu' pasmée Dxusçxáanatx na'wẽ tuuthe'j: —Judiuwe'sxmée vxite nasatxwa Dxusa' ũsne' pkaltxi nvxihtçxa Dxus tasxte pçuwa'jmée fxi'zewa'ja's jĩnatx weçxá'. ");
INSERT INTO pbb_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Ãçxha' nyafxíi na'wẽ Estebana's ikhçxa vxite neeyũusáa yuutxi' ahçeçxa pkxuute', txãawe'sxa' ũphna u'jçxa' maaíi yu' Fxenice kiwen, vxite' Çxipre kiwesu, vxite' Antiokía çxhabsu kxsũ pa'jçxa vxite nasa yuutxi' pta'sxmée judiu ji'j pwe'sx yuuçxáatx pta'sxi' Dxus yuwe u'sesa's. ");
INSERT INTO pbb_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Nawa Dxus yakh fxi'zesa Çxipre vxite' Cirene kiwejuwe'sx maaíi yu' Antiokía çxhabte pa'jçxa', judiuwe'sxmeetxwa pta'sxtxi Jesus kaapiya'jni ewte fxi'zewa'ja's. ");
INSERT INTO pbb_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Aça' Dxus pu'çxte', txãawe'sxa' nyafxíi jxpubana fxi'zeni's nvxihtçxa Jesus kaapiya'jni's nwẽese'jtx. ");
INSERT INTO pbb_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Txã'wẽtx Dxusa's nwẽese'j jĩni's Jerusalente pkhaakhena ũssa' jiyuçxa', Bernabea's kaahtx Antiokía çxhabna. ");
INSERT INTO pbb_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Aça' Bernabea' kxte pa'jçxa' wala weçxak Dxus txã'wẽ pu'çxni's uyçxa. Sa' jxukaytxi yu'kxpejk jxpubamée ew Dxus yakh fxi'zekahn. ");
INSERT INTO pbb_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Txãa pa'gatey Bernabea' Dxus Espiritu's txajx ũuste jxuka jxpa'gaçxa Dxus yakh yuuçxáa fxi'zesak yu'. Txajũ' nasatx wala ya'knayku Dxus jĩi. ");
INSERT INTO pbb_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Txã'wẽ yũuçxa', Bernabea' Tarso çxhabna Saulo's pe'jya' u'jçxa', Antiokía çxhabte nuypa'kh. ");
INSERT INTO pbb_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Sa' kxte teeçx anxutx pkhaakhena ũsu' nasa ma'wẽsatxwa jxuka kaapiya'jna. Antiokíatetx nyafxçxah kristiano jĩna kxsusnisa yuu Kristo's nwẽese'jsawe'sxtxi. ");
INSERT INTO pbb_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Txãn ensu' Dxus yuwe pta'sxsawe'sx Jerusalenu yuusa pa'jtx Antiokíate. ");
INSERT INTO pbb_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Teeçxsa Agabo yaasesa' Dxus Espiritu kaajiyu'the', yakhthẽ'jwe'sx ksxavxyte yujuçxa: Judiuwe'sx kiwete jxuka wẽje en pa'jana jĩnak pta'sx. (Txã'wẽ pta'sxni' kxtey yuuk jxkaahsa Klaudio ente.) ");
INSERT INTO pbb_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Txã'wẽ wẽje en pa'jana jĩni's wẽse'jçxa', Dxus yakh fxi'zesa Antiokíatewe'sxa' txãawe'sx ji'phuni yakh pu'çxya' yajkxtxi yakhthẽ'jwe'sx Judea kiwetewe'sxtxi. ");
INSERT INTO pbb_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Txajũ' peeswa'ja's pkhakhçxa kaahtx Bernabé Saulo yakh Judeate ancianowe'sxtxi dukhkahn. ");
INSERT INTO pbb_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Txãn ensu' jxkaahsa Herodesa' pkxuuya' yajkxku Dxus yakh fxi'zesatx. ");
INSERT INTO pbb_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Sa' kçxilxuh kiikhe'kh Juan nyakh Jakobo's. ");
INSERT INTO pbb_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Txã'wẽ yũute' Jakobowe'sxtxi açesa judiuwe'sxa' weçxatx jxkaahsa Herodesa's, aça' Pedronawa preesu'khaakh kiikhe'jya'. Pan lewadura ji'phmée ũ'wa'j fxiesta entek txã'wẽ yũu. ");
INSERT INTO pbb_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Herodesa' Pedro's preesu tudçxa' karcelte ktxaaja'kh. Kuste pahz us yu'pthehna pe'tewa'jsa soldau txajk, yu'ptheh iisa pahz pahz yujukahn. Paskua fxiesta en skhẽwte nasaa ksxavxyte kutxi'jya' sũhçxak txã'wẽ yũu. ");
INSERT INTO pbb_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Aça' Pedro' karcelte wala ew yupni ũsu'k, nawa Dxus yakh fxi'zesawe'sx yu' Dxus yakh pu'vxituméetx puutx we'wena ũsu' Pedro pa'gate. ");
INSERT INTO pbb_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Herodesa' Pedro's nasaa ksxavxyte kutxi'jwa'j en ãjaçte', txãa kuste Pedro' dejk e'z soldau pxãhte, e'z kadenaju tudni. Naapkaçxha' vxite e'z soldau yu' karcel vxitxtetx yupna ũsu'. ");
INSERT INTO pbb_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Txãa dudte Dxus angel vxyaaçxáa yuute', karcelte jxuka eena'k kweeth. Txajũ' angela' na'jĩnak tu'kakana Pedro's fxĩtx: —Dud yuh mkiite jĩçpkaçxha', çam kadena' çxukwetetx Pedro kuseju. ");
INSERT INTO pbb_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Aça' ki' we'wek txãa angela': —Iidx jxtudni's ya'jytudçxa, pelgatxi's mpaath jĩte', Pedro' txã'wẽy yũuk. Txajũ' txãa angela' ki' we'wek: —Atxha's jxkaaççxa myuh adx e'stey jĩte', ");
INSERT INTO pbb_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Pedro' angel e'stey kasejk, isa angela' eka kutxi'jiçtewa ksxa'wnawáa ũsne'tka sũhnaçxáa yajkxna. ");
INSERT INTO pbb_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Nawa nyafx vxitxte soldau yupna ũsnite skhẽwçxa', e'ste vxitxte soldau yupna ũsnitewa skhẽwtxi. Sa' eka kasehwa'j çam vxitxte sẽjeçpkaçxha', txãa vxitxa' peekxçxáa phaatek. Aça' kasehçxa u'jtx klxiikhunsu. Txajũ' angela' Pedroçxáana nvxihtçxa u'kh. ");
INSERT INTO pbb_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Txajũ' Pedro' naasũjk: Ksxa'wnimeega yu', isa Dxusne' txajx angela's kaah Herodes kuseju adxa's nwe'weya', vxite' judiuwe'sxwa nakwe wala ewmée yũuya' ũythasu'tx txãaju nwe'wekahn sũhnak yajkx. ");
INSERT INTO pbb_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Pedro' txã'wẽ ew jiyuçxa' u'kh Juan Markos njĩ'j Maria yatna. Kxte' wala kuh pkhaakheçxa Pedro pa'gate Dxusa's neewe'wenatx ũsu'. ");
INSERT INTO pbb_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Kxte kũhçxa vxitxte uka'kate', teeçx luuçx u'y Rode yaasesak thegya' kaseh. ");
INSERT INTO pbb_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Nawa Pedro we'weni's jiyuçxa', vxitxa's phaademée weçxana ki' sxawedku dxiigay wuwuuçxáa: —Pedro' vxitxte ũsa' jĩna pta'sxya'. ");
INSERT INTO pbb_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Aça' na'jĩnatx we'we: —Luuku we'wena ũsi'çxa jĩtewa: —Ĩsxiija'çmeeth, isa yuja' jĩte': —Pedromée, txãa yakh pi'kxna u'jusa angelçxáana jĩtx. ");
INSERT INTO pbb_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Txã'wẽtewa, Pedro yu' vxitxte uka'kana nesku yu'. Aça' vxitxa's phaadeya' u'jçxa', Pedro's uyçxa wala kuh yajkxtxi. ");
INSERT INTO pbb_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Nawa sxuuna' yuukahn Pedro' kuseju pta'sxçxa', Dxus ma'wẽ karceluh nwe'weni's jxuka pta'sxku. Sa': —Jakobo vxite' kwe'sx yakhthẽ'jwe'sxtxi mpeeta'sxwe txã'jĩna'wa, txãa yu' kasehna u'kh vxite ahte. ");
INSERT INTO pbb_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Kuskuuskhẽ khikhynite', wala kuh yajkxna ũukhtxi soldauwe'sxa' txã'wẽ Pedro ma'wẽ yũutewa jiyumeeçxa. ");
INSERT INTO pbb_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Txajũ' jxkaahsa Herodesa' pakweya' kaakh, nawa uymeete' kxte karcelte thegsa soldautxku ikh kaah. Txãa e'suçxáa Herodesa' Judea kiweju kasehçxa Cesarea kiwetek u'pxa' u'j. ");
INSERT INTO pbb_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Herodesa' wala puiina ũsu'k Tiro Sidón kiwete nasa yakh. Txãa pa'gatx txãa nasa' Herodes tasxte mjĩisa Blasto yaasesa's vxyu dukhçxa txãa yakh u'j jxkaahsa tasxte utxaaçxa puiimée fxi'zewa'ja's puutx we'weya'. Txã'wẽ yũumeete', txãa nasa' jxkaahsa kiwejuçxáatx ũ'a's jxpa'gana fxi'zesa yu'. ");
INSERT INTO pbb_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Aça' jxkaahsa Herodesa' pta'sxku kĩh ente txajx tasxte utxaawa'ja'swa. Sa' txãa en ãhte', Herodesa' jxkaahsa athni ropatx athçxa txajx u'pnite kaçxçxa we'wek. ");
INSERT INTO pbb_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Txajũ' nasa' na'jĩnatx weçxana sus we'we: —Na'wẽ we'wesa' naa kiwete nasamée, Dxusa' jĩçpkaçxha', ");
INSERT INTO pbb_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","txãa dudtey Dxus angela' akasa ũsku Herodesa's, aça' jxuka wes ũ'te' uuk, txã'wẽ nasaa weçxani's weçxana yaakxpa'ga. ");
INSERT INTO pbb_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Nawa Dxus yuwe yu' jweeíiçxáak walaana u'j mtee mteewa pta'sxni. ");
INSERT INTO pbb_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Txajũ' Bernabé Saulowe'sxa' mjĩia's jxã'jçxa Jerusalenuh ki' sxawedtxi Juan Markosa's pe'jçxa. ");
INSERT INTO pbb_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Antiokía çxhabte pkhaakhena ũssa yakh ũsu'tx Dxus yuwe pta'sxsa vxite' Dxus leya's jiisawa: Bernabé, vxite' khũçx Simon jĩnisa, vxite' Lucio Cirene çxhabuwe'sx, vxite' Manaén Galileate jxkaahsa Herodes yakh ih walaasáa, vxite' Saulo'. ");
INSERT INTO pbb_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Txãawe'sxa' teeçx ente' Dxusna selpiina yũunaana ũste', Dxus Espiritu' na'wẽk we'we: —Saulo Bernabé yakh mkaahwe adxa's selpikahn, txãawe'sxa' adx pa'yanisata' mjĩiwa'jsa jĩk. ");
INSERT INTO pbb_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Txajũ' yũunaana jxã'jçxa', txãawe'sx dxikthesu peekizeçxa Dxusna neewe'wena' kaahtx. ");
INSERT INTO pbb_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Dxus Espiritu kaathe', Bernabé Saulowe'sxa' Seleucia çxhabna u'jçxa txajũ' barkote khẽeçxa ĩkh pxãhte Çxipre kiwentxi u'j. ");
INSERT INTO pbb_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Txãa kiwete Salamina çxhabte pa'jçxa', judiuwe'sx pkhaakheni yat-su Dxus yuwe's pta'sxya' takhtxi. Sa' Juan Markosnawa iipe'jtx yu' pu'çxwa'jsa. ");
INSERT INTO pbb_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Çxipre kiwe's pekũhna jxã'jaççxa', Pafxos çxhabtetx pa'j. Sa' kxte' teeçx judiu dxijxuusáa Barjesus yaasesa'stxi uy. Txãa piçthẽ'ja' wala ĩsxiisa yu'k Dxus yuwe pta'sxsath jĩna ĩsxiina. ");
INSERT INTO pbb_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Txãa dxijxuusá' kxte ne'jwe'sx wala jiisa Sergio Paulo tasxte mjĩisak yu'. Txãa ne'jwe'sxa' Dxus yuwe's wẽse'j wẽeçxa Bernabewe'sxtxi pa'yak. ");
INSERT INTO pbb_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Nawa txãa dxijxuusáa Elimasa' Bernabewe'sxtxi' kwe'we'j wẽeme', ne'jwe'sxa' Dxus yuwe's jiyukahmen. ");
INSERT INTO pbb_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Txã'wẽ yũute', Dxus Espiritu's ũuste jxuka ji'phsa Saulo Pablo yaasesa' dxijxuusáa dxi'pte ũusçxa thegçxa', na'jĩk: ");
INSERT INTO pbb_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","—Ĩsxiina fxi'zesa, ewmeesa, eçxthẽ'j luuçx, ewsa yu'sa' jxuka ahçena fxi'zesa ¿mjĩitega Dxus yuwe ewsa's yupmée fxi'ze'çmée? ");
INSERT INTO pbb_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Txãa pa'ga Dxusa' idxa's ãçxhíi kastigaĩna, aça' uyya' ãjamée fxi'zene'ga naa ensu' jĩçpkaçxha', txãa dudtey uyya' ãjameeçxa' maaçxáatxwa pakwek pu'kisçxa pe'jna u'khan. ");
INSERT INTO pbb_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Txajũ' kxte ne'jwe'sxa' txã'wẽ yũuni's uyçxa', Jesus kaapiya'jni's isa yuhna sũhna ũuste jxpa'gak. ");
INSERT INTO pbb_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Pablo vxite' txãa yakh pi'kxna u'jusa yã'jçxa barkote khẽeçxa Pafxos çxhabu kasehtx Panfxilia kiwete Perge çxhabte pa'jya'. Nawa Juan Markos yu' Perge çxhabte pa'jçxaçxáa ki' sxawedku Jerusalennay. ");
INSERT INTO pbb_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Pablowe'sxa' Perge çxhabu kasehçxa Pisidia kiwete Antiokía çxhabnatx u'j. Kxte pa'jçxa', jxkaase ensu' judiuwe'sx pkhaakheni yatte u'katx. ");
INSERT INTO pbb_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Aça' pkhaakheni yatte npiiçthẽ'ja' Dxus ley vxite' Dxus yuwe pta'sxsa fxi'jni's lẽeyna jxã'jçxa', na'wẽtx we'we: —Yakhthẽ'jwe'sx, kĩh we'wewa'j ji'phçxa', myu'kxpehwe nasatx ãçxhíi jĩte', ");
INSERT INTO pbb_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Pablo' kiitena'wa kuseju sxuuna' yuuwa'ja's pta'sxna'wa we'wek: —Israel ji'jwe'sx, vxite nasawa Dxusna nwẽese'jsa, jxpa'yakx mwẽese'jwe: ");
INSERT INTO pbb_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Israelwe'sx Dxusa' kwe'sx yaçgawe'sxtxi txhitxhçxa wala kpeena'kh Egipto kiwete nee ũsiyna, sa' txãa kiwejũ kutxi'kh kĩhwa seena'sa kaavxya'ja'jçxa. ");
INSERT INTO pbb_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Dxusa' nasa u'pnimée kiwete kuarenta anxu wantãyku nasa ãhmée yũuna fxi'ze'çtewa. ");
INSERT INTO pbb_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Sa' Kanaan kiwete nasatx jxuka ivxiituk txãa kiwe's kwe'sx yaçgawe'sxtxi ũsya'. ");
INSERT INTO pbb_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Txajũ' kuatrocientos cinkwenta anxu ãhpkaçx jxkaahwa'jsa ji'phmée kwe'sxtxi thegwa'jsa khuẽsçxáak nvxiht, Dxus yuwe pta'sxsa Samwel entepkaçx. ");
INSERT INTO pbb_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Txajũtx txãawe'sxíi pẽjx teeçx jxkaahwa'jsa, aça' Dxusa' ũsku kuarenta anxu jxkaahwa'jsa Cis nçxi'k Saul yaasesa's. Txãa piçthẽ'ja' Benjamin ji'kh yu'. ");
INSERT INTO pbb_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Txãa e'su' Dxusíi Saula's jxkaahnijũ kutxi'jçxa, Davxida'sku jxkaahwa'jsa ki'p. Sa' na'wẽk we'we: Isaí nçxi'k Davxid yuuçxáa adx jxkaahni's kxtey yuuwa'jsa uythu txã' adx wedxnisa' jĩk. ");
INSERT INTO pbb_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Jesusa' Davxid ji'thewe'sxku yu', aça' txã'snak Dxusa' nvxiht Israelwe'sxtxi nwe'wewa'jsa, nyafxiitey Dxusa' ma'wẽne' ũsya' neeyũu txã'sa' kxtey yuuk. ");
INSERT INTO pbb_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Jesus pa'jmeyna Juana' Israel nasa jxukaysatx pta'sxku: I'kwe'sx pkaltxi jxuka nvxihtçxa Dxus tasxte misxawedwe yu'te ya'bautisãyna jĩna. ");
INSERT INTO pbb_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Sa' Juana' txajx uu en utxaaçte', na'wẽk we'we: Adxa' i'kwe'sx ũythasu'i'kwe txãameeth. Adx e'ste teeçx yuja' txajx pelgatxi wesçxáa yuhnawa adxa' khihbxa' selpimeesath jĩk. ");
INSERT INTO pbb_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Yakhthẽ'jwe'sx Abrahan ji'j, vxite nasawa Dxusna nwẽese'jsa i'kwe'sx ewte neeyũuwa'ja's pta'sxnik yuu. ");
INSERT INTO pbb_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Nawa Jerusalente ũssa vxite' txãawe'sx npiiçthẽ'jsawa jiyumeeta' Jesusa' kimtewa. Sa' Dxus yuwe pta'sxsa fxi'jni'swa jiyumeeta' pkhaakheni yat-su jxkaase een isa lẽeyçxawa. Sa' txãawe'sxíiçxáa Jesusa's ewmeete nvxihtçxa', Dxus yuwe pta'sxsa fxi'jni txãawe'sx lẽeyni's kxtey yuutx. ");
INSERT INTO pbb_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Txã'wẽ Jesus ewmée yũuni's uymeeçxawa Pilato's yuwe ũstxi Jesusa's kiikhe'khan. ");
INSERT INTO pbb_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Txajũ' Dxus librute ma'wẽne' fxi'jni ũsu' txã'sa' jxuka kxtey yuuçxa', Jesusa's kluusu spajkxçxa pedaatx. ");
INSERT INTO pbb_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Nawa Dxusa' uuniijũ ki' ĩtxi vxitku. ");
INSERT INTO pbb_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Aça' Jesusa' wala kuh en vxyaak Galileajuwe'sx Jerusalenna pi'kxna yuusatx. Txãasa txãawe'sxa' Jesus kimtewa pta'sxsata'. ");
INSERT INTO pbb_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Txãa pa'ga kwe'sxwa i'kwe'sxtxi pta'sxiçtha'w nyafxiitey kwe'sx yaçgawe'sxtxi Dxusa' ũsya' neeyũuk txã'sna. ");
INSERT INTO pbb_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Kwe'sxa' yaçgawe'sx ji'tha'w, txãa pa'gak Dxusa' txajx ũsya' neeyũuni's kwe'sx yakh kxtey yuuçxa, Jesusa's uuniijũwa ĩtxi vxit, salmo doste na'wẽ fxi'jni ũsa' txã'wẽy: Idxa' adx nçxi'kgu. Aça' idxa's uuniijũwa ĩtxi vxitthu ãçxha' jĩk. ");
INSERT INTO pbb_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Uute' txãa kakwe' suweekahmen ĩtxi yuuwa'ja's Dxusa' pta'sxku txajx librute na'jĩna: I'kwe'sxtxi peeygãawa'ja's Davxid yakh puutx we'weth txã'sa' kxtey yu'nja jĩk. ");
INSERT INTO pbb_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Txãasak salmo vxite ajkhẽwa na'jĩ': Idxna selpisáa peeygãanisa kakwe's nvxihtmeene'ga suweewe'sxte jĩ'k. ");
INSERT INTO pbb_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Txã'wẽ we'weni' isa kxtey yuuyujk. Txajíik Davxida' txãn ensu' Dxus jxkaahni's kxtey yuuçxa e'su' uuk, aça' txajx kakwe's yaçgawe'sx pedaniitey pedaate', txajx kakwe' kxtee jxuka pçuuk. ");
INSERT INTO pbb_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Nawa Dxusa' Jesusa's uuniijũwa ĩtxi vxitku, aça' txãa kakwe' pçuume'. ");
INSERT INTO pbb_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Ãçxha' yakhthẽ'jwe'sx i'kwe'sxa' mjiyuwe: I'kwe'sx pkaltxi peltunãywa'ja's pta'sxi'tha'w, nawa peltunãywa'jsa' Jesus yuuçxá'. ");
INSERT INTO pbb_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Nyafxíi Moises leya's nwẽese'jçxawa, perdona's uymeei'kwe. Nawa Jesusna yajkxçxa nwẽese'jçxa', perdona's uyuune'kwe maawa. ");
INSERT INTO pbb_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Mpa'yajkxwe, txã'wẽme', nyafxíi Dxus yuwe pta'sxsa na'wẽ we'wetx txã' kxtey yuuwe'sxta': ");
INSERT INTO pbb_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Weeçxsawe'sx, mpa'yajkxwe. I'kwe'sx vxituwa'ja's mũukhwe. Txã'wẽme', adxíi Dxusthu na', Txã'wẽ yũuwa'j en ãhte', kĩhwa seena'çxáa yu'nja. Txã'wẽ yũuwa'ja's pta'sxtewa, i'kwe'sxa' jxpa'gameene'kwe jĩnatx we'we jĩk Pablo'. ");
INSERT INTO pbb_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Txajũ' Pablo' txã'wẽ pta'sxçxa', txãa yakh pi'kxna u'jusa yakh judiuwe'sx pkhaakheni yatu kasejeçte', kxte ũssa judiu ji'jmeeçxawa Pablowe'sxtxi ki' pi'kxtxi vxite jxkaase ente txã'wẽy pta'sxya' yuukahn. ");
INSERT INTO pbb_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Kxte pkhaakheni pçuute', judiuwe'sx wala kuhsa vxite' judiu ji'jmeeçxawa judiuwe'sx kaapiya'jni's jxpa'gasa Dxus yuwe's wala ew nwẽese'jçxa', Pablowe'sx kaapiya'jni's nwẽese'jsatx yuu. Aça' Pablowe'sxa' wala yu'kxpehtx Dxus peeygãanite wa'lmée fxi'zekahn. ");
INSERT INTO pbb_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Vxite ki'su jxkaase ente', çxhabte nasa jxukay pkhaakhetx Dxus yuwe's wẽse'jya'. ");
INSERT INTO pbb_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Nawa txã'wẽ nasa wala pkhaakhete', kxte judiuwe'sxa' wala ũusaçxaçxa Pablowe'sxtxi açewe'wena wẽesxutx. ");
INSERT INTO pbb_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Txã'wẽtewa, Pablowe'sxa' ũukhmeetx na'jĩna we'we: —Dxus yuwe's nyafxte i'kwe'sx judiu ji'j khuẽ'ytxi pta'sxwa'kh yu', kxahtha'w pta'sx. Nawa jxpa'gameeyã'ji'kwe pçumée ĩtxi fxi'zewa'ja's, aça' ãçxha' u'jweçtha'w judiumée vxite nasatx pta'sxya'. ");
INSERT INTO pbb_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Dxusa' kwe'sxtxi na'wẽk we'wena kaah: Nasa ksxavxysu eena' kweethwa'jsath nvxiht i'kwe'sxtxi', Sa' txã'wẽy maa kiwetewa ewsa's pta'sxwa'jsa jĩk. ");
INSERT INTO pbb_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Aça' judiu ji'jmée vxite nasa txã'jĩni's wẽse'jçxa', Dxus yuwe' wala ewsa yu'ga jĩna weçxaçxa maaçxahne'ta bagaçxte yuhwa pçumée ĩtxi fxi'zewa'jsa yu' txãa yu' jxukay Dxus yuwe's jxpa'gatx. ");
INSERT INTO pbb_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Txã'wẽk Dxus yuwe's pta'sxni yuu txãa kiwete jxuka. ");
INSERT INTO pbb_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Nawa txãa çxhabte judiuwe'sxa' nasa jxtuhthesa petx u'y yã'jçxa kxteeçxah puutx we'weçxa, Pablowe'sxtxi pkxuuya' yajkxtxi txãa kiwejũ kutxi'phkaçx. ");
INSERT INTO pbb_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Txã'wẽ yũute', Pablowe'sxa' txãawe'sx çxidate kiwe tuhda's sakweekweçxa u'jtx Ikonio çxhabna. ");
INSERT INTO pbb_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Nawa kxte nasa Dxus yuwe's nwẽese'jsa yu', wala weçxana neeyũutx, Dxus Espiritu's ũuste jxpa'gaçxa. ");
INSERT INTO pbb_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Pablowe'sxa' Ikonio çxhabte pa'jçxa', judiuwe'sx pkhaakheni yatte u'kaçxa, Dxus yuwe zhiçxkwesa's pta'sxte', wala jxpa'gatx judiuwe'sx vxite' judiuwe'sxmeesawa. ");
INSERT INTO pbb_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Nawa judiuwe'sx Jesus kaapiya'jni's açesa yu' judiu ji'jmée vxite nasatx ewmée yu'txwe'weçxa yakhthẽ'jwe'sxtxi açeyaakxwa'ja's vxittxi. ");
INSERT INTO pbb_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Txã'wẽ açepa'gaíiçxáatx Pablowe'sxa' jweeíiçxáa kxte txaçx ũsu', Dxusa' pu'çxhina sũhna ũukhmée pta'sxna. Aça' Pablowe'sx txã'wẽ Dxus peeygãani's pta'sxte', Dxusa' kxte nasa wẽse'jsa yuutxi' ewku kaajiyu'j Pablowe'sxtxi kĩhwa seena'sa's kaavxya'ja'jya' ãjawa'ja's ũsçxa. ");
INSERT INTO pbb_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Aça' txãa çxhabtewe'sxa' txuteetx, vxite' judiu açesawe'sx ju'gu, vxite' Pablowe'sx ju'gu. ");
INSERT INTO pbb_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Txajũ' judiuwe'sx vxite' judiuwe'sxmeesawa khuẽswe'sx yakh puutx we'wetx Pablowe'sxtxi wẽesxuna kwet wãatatahçxa ikhya'. ");
INSERT INTO pbb_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Nawa Pablowe'sx jiyuçxa', ũphna u'jtx Likaonia kiwete Listra Derbe çxhabna kxsũ jxuka pekũhçxa ");
INSERT INTO pbb_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Dxus yuwe ewte nvxiitwa'jsa's pta'sxya'. ");
INSERT INTO pbb_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Sa' Listra çxhabte pa'the', kxte' teeçx piçthẽ'j çxida ãça'sak u'pu'. Txã' upxhíi txã'wẽ yã'kh yu', sa' bagaçxte yuhwa u'juya' ãjasameek yu'. ");
INSERT INTO pbb_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Txãa piçthẽ'ja' Pablo pta'sxni'sku wẽse'jna u'pu'. Aça' Pablo' txajx dxi'pte thegçxa' jiyuk nuykatxhina sũhni's. ");
INSERT INTO pbb_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Sa' susku we'we: —Ku'le myuju jĩna. Naapkaçxha' txãa piçthẽ'ja' ũphçxa yujuna'wa ew yã'kh u'juya' ãja. ");
INSERT INTO pbb_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Pablo txã'wẽ yũuni's nasa uyçxa', na'wẽtx Likaonia yuweju weyna we'we: —¡Nasa na'wẽ yuuçxa dxuswe'sx kwe'sx tasxte kĩhtx! jĩçxa', ");
INSERT INTO pbb_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Bernabea's Jupiter jĩnatx kxsusu', sa' Pablo's Merkurio jĩnatx we'we', wejx thaakwe we'wesa yuupa'ga. ");
INSERT INTO pbb_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Txãawe'sx dxus Jupiter jĩ'tx txã'sna neewe'wena ũsni yata' çxhab peeku'thek ũsu', aça' kxte selpisáa sacerdote' kla jxũna pa'kh kite zhiçxkwesa khyũ'jũ'jçxa. Aça' nasa' Pablowe'sxtxi weçxana peejxũkweçxa neewe'weya'watx yu' txãa klatx ikhna. ");
INSERT INTO pbb_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Nawa Pablowe'sx jiyuçxa' txã'wẽ yũute nxusçxa peekx athni ropatx sudena'wa nasaa ksxavxyte kũhçxa na'jĩnatx sus we'we: ");
INSERT INTO pbb_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","—I'kwe'sxa' ¿kĩjxa'kwe txã'wẽ yũ'? Kwe'sxa' nasa i'kwe'sx na'wẽysa íiçxáatha'w. Sa' txã'wẽ yũuna fxi'zenisa' seelpimeesa' naa pa'ga nvxihtçxa Dxus ĩtxĩsa cielu's pheu'kh, kiwe, ĩkh wala kxte kĩhçxah ũstxna txãatx jxuka txã'snaçxáa selpiina neewe'wewa'ja' jĩna pta'sxya' yuusaçxáatha'w. ");
INSERT INTO pbb_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Txãa Dxusa' nyafxíi ensu' nasatxi' nvxihtku ma'wẽwa yũuna fxi'zekahn. ");
INSERT INTO pbb_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Nawa Dxus ũsyuhna sũjkahn kaajiyu'jna nesku yu', nus kaapa'ja'jna, uuthasxtxi ew kçxhãaçxha'jna, ũ'wa'ja's peejxmée peesna, wẽt fxi'zewa'ja'swa ũsna jĩnak pta'sx. ");
INSERT INTO pbb_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Txã'wẽ pta'sxçxak wala thẽyçxáawa pejka nasatx knay, txãawe'sxtxi weçxana kla ikhna peejxũkwekahmen. ");
INSERT INTO pbb_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Txãa e'su' judiuwe'sx Antiokía Ikonio çxhabuwe'sx pa'jçxa kxte nasatx ewmée yu'txwe'weçxa kwet wãatatahtx Pablo's. Txã'wẽ yũuçxa', uuyã'jne' sũhçxa wezxna u'jçxa çxhab ekahtx wãatãh. ");
INSERT INTO pbb_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Nawa kxteewe'sx Dxus yuwe's nwẽese'jsa yu', Pablo's thegya' u'the', Pablo' ki' ũus ji'phuçxa kiiteçxa ki' çxhabtey u'kak. Sa' vxite kuskuskhẽ' Bernabé yakh Derbe çxhabnatx u'j. ");
INSERT INTO pbb_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Derbe çxhabte pa'jçxa', Dxus yuwe ewte nvxiitwa'jsa's pta'sxçxa nasatx wala knaytxi Dxus jĩi. Txã'wẽ yũuçxatx sxawed Listra, Ikonio, Antiokía çxhabsu iipa'j. ");
INSERT INTO pbb_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Txãa çxhabsu pa'jçxa', Dxus yuwe's nwẽese'jsatx wala yu'kxpehtx Dxus jxkaahna ũsnite u'ka wẽeçxa' Dxus yakh txutemée fxi'zewa'ja', makwe pxthaa nxuswa'j en pa'thewa jĩna. ");
INSERT INTO pbb_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Sa' kxsũ pkhaakhena ũsnisu jxkaahwa'jsa ancianowa pakweçxa ki'ptxi. Txã'wẽ yũuçxatx yũunaaçxa Dxus kusete neewe'weçxa nvxiht. ");
INSERT INTO pbb_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Txajũ u'jçxa', Pisidia kiwesu skhẽwçxa Panfxilia kiwetetx pa'j. ");
INSERT INTO pbb_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Txãa kiwete Perge çxhabte Dxus yuwe's pta'sxçxa Atalia çxhabnatx u'j. ");
INSERT INTO pbb_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Txajũ' barkote khẽeçxa u'jtx Antiokía çxhabna, majũne'ta Dxus kusete neewe'weçxa mjĩiya' kaahnisa yuu txãa çxhabnay. ");
INSERT INTO pbb_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Antiokía çxhabte pa'jçxa', kxte pkhaakhena ũssa yakhthẽ'jwe'sxtxi pta'sxtxi Dxus ma'wẽne' txãawe'sxtxi pu'çxçxa judiu ji'jmée vxite nasatxwa Dxus yuwe's kaajiyu'j txã'sna. ");
INSERT INTO pbb_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Sa' Pablowe'sxa' kxte wala txaçx ũsu'tx Dxus yuwe's nwẽese'jsawe'sx yakh. ");
INSERT INTO pbb_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Txãa e'su' Judeajuwe'sx judiu Antiokía çxhabte pa'jçxa kxteewe'sxtxi na'wẽtx kaapiya'jna ũsu': Ya'cirkuncidãywa'j ji'phi'kwe Moises jxkaahni's kxtey yuuna. Txã'wẽ yũumeeçxa', ewte neeyũuya' ãjameene'kwe jĩna. ");
INSERT INTO pbb_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Aça' txã'wẽ kaapiya'the', Pablowe'sxa' wala juuna' puutx we'wetx txã'wẽ pta'sxsa yakh. Txajũ' kxte pkhaakhena ũssa yakhthẽ'jwe'sxa' Pablowe'sxtxi vxite kaapi'ki'jçxa Jerusalenna kaahtx Jesus jxkaahnisawe'sx vxite' anciano kxteewe'sx yakh txãa yuwe's paapẽjxna puutx we'wekahn. ");
INSERT INTO pbb_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Antiokía çxhabte pkhaakhesa yakhthẽ'jwe'sx kaathe', Fxenicia Samaria kiwesu skhẽwnatx u'j, judiu ji'jmée vxite nasawa Dxus yuwe's jxpa'gaçxa nyafxíi jxpubana fxi'zeni's nvxihttxi jĩna pta'sxna. Aça' kxsũ yakhthẽ'jwe'sxa' wala weçxatx txã'wẽ jiyuçxa'. ");
INSERT INTO pbb_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Pablowe'sx Jerusalente pa'the', kxte pkhaakhena ũssa vxite' Jesus jxkaahnisawe'sx ancianowe'sx yã'jçxa jxpa'gatx. Aça' Pablowe'sxa' jxuka pta'sxtxi txã'wẽ judiu ji'jmée vxite nasatxwa Dxusa' ewte neeyũuwa'ja's ũsku jĩna. ");
INSERT INTO pbb_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Nawa maaíi yu' kxte ũssa fxariseowe'sx Jesus kaapiya'jni's jxpa'gasaçxawa na'wẽtx we'we yujuçxa: Judiu ji'jmée vxite nasa ãçxh u'se Dxus yuwe's jxpa'gasawe'sxtxi' cirkuncidãyçxa, Moises jxkaahni leya's jxuka nwẽese'khan jxkaathe yuuna jĩtx. ");
INSERT INTO pbb_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Txajũ' Jesus jxkaahnisa vxite' ancianowe'sx yakh pkhaakheçxa txãa yuwe's pheu'jya' puutx we'wetx. ");
INSERT INTO pbb_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Txã'wẽ wala txaçx txãa yuwe's puutx we'wenijũ', Pedro' kiiteçxa na'wẽk we'we: —Yakhthẽ'jwe'sx, i'kwe'sxa' jii i'kwe Dxusa' adxa's txhitxhku txajx yuwe ewte nvxiitwa'jsa's pta'sxkahn judiu ji'jmée vxite nasatxwa, kxah txãawe'sxwa jiyukahn. ");
INSERT INTO pbb_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Dxusa' jiia' maaçxah nwẽese'jwa'jsatewa, txãasa íik vxite nasawa txã'sna nwẽese'jwa'jsa yuutxi's txajx Espiritu's ũs, kwe'sxtxiwa ma'wẽga txajx Espiritu's ũs txã'wẽy. ");
INSERT INTO pbb_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Dxusa' maa yuhtxwa nasa fxiisata' sũju'çme' kwe'sx yakh vxite nasa yakh. Txãasaíiçxáak vxite nasaçxawa Jesusa's yaakxsa yuutxi's txãawe'sx pkaltxi' peltunãy. ");
INSERT INTO pbb_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Dxus txã'wẽ yũuçxa nwe'wenisatxi's ¿kĩjxa'kwe i'kwe'sxa' jweeíiçxáa thẽysa's yuutxana jxkaah wẽje'? Txãa thẽysa's kwe'sx yaçgawe'sx yuhwa kxtey yuuya' ãjameeta', aça' kwe'sx yu' wejxtha'w ãjãmée. ");
INSERT INTO pbb_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Txã'wẽ kwe'sxa' txãa thẽysa's kxtey yũuya' ãjãmeetewa, Jesusa' peeygãhçxa yuuçxáane' kwe'sxtxi' nwe'we sũju'tha'w. Txãasane' vxite nasatxwa txã'wẽyçxáa nwe'we. ");
INSERT INTO pbb_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Pedro txã'wẽ we'wete', jxukaysa sxuuna'tx yuu, Pablowe'sx pta'sxni's wẽse'jya'. Aça' txãawe'sxa' pta'sxtxi Dxusa' txã'wẽk kim yuhwa ãjãnimeesa's kaavxya'ja'jya' ãjãwa'ja's kwe'sxtxi ũsçxa judiu ji'jmée vxite nasatxwa jxuka pu'çx jĩna. ");
INSERT INTO pbb_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Txãawe'sx pta'sxna jxã'the', Jakobok we'we: —Yakhthẽ'jwe'sx, mwẽese'jwe. ");
INSERT INTO pbb_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simon Pedro na'wẽk pta'sx judiu ji'jmée vxite nasatxwa Dxusa' nyafxçxah peeygãhçxa txãawe'sxtxi txhitxhku txajx luuçx yuuwa'jsa. ");
INSERT INTO pbb_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Txã'wẽ yuuwa'ja's Dxus yuwe pta'sxsawe'sx fxi'jtx txã' kxtey yuuk. Txãa fxi'jni' na'jĩ'k: ");
INSERT INTO pbb_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","Txã'wẽ yũunijũ sxawedçxa, ki' txaja'nja Davxid txaahni yat wetenisa's. Txãa wetenisa's pheu'jçxa u'se vxitçxa nvxiitu'nja. ");
INSERT INTO pbb_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Kxah maawa jxuka Dxusa's pakweya' ãjatxna, Maa kiwejuwe'sxwa adxa's jiyusa yu' jxuka. ");
INSERT INTO pbb_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Txã'wẽ yũuwa'ja's Dxusa' nyafxíi enteyku txã'wẽ we'wena kaajiyu'j. ");
INSERT INTO pbb_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Txãa pa'gath adxa' naasũju': Judiu ji'jmeeçxawa Dxusna nwẽese'jya' pakwesaatxi' kuçx kwe'sx leytxi nwẽese'jwa'ja's jxkaahmée, ");
INSERT INTO pbb_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","naasáa na'wẽ pta'sxna fxi'theçxáa ewna: Naa kiwega dxus ĩtximeesa's weçxaya' tajkx ikhni çxiçxa's ũ'wa'jme'. Sa' ptammeesa pkal yuuna fxi'zewa'jme'. Txã'wẽy tajkxnawa thukçxa ikhnisa çxiçxa's ũ'wa'jme', eenawa ũ'wa'jme'. ");
INSERT INTO pbb_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Txã'wẽ yũumeete', Moises leya's nyafxíi enteytxi txãasu we'wena pta'sxna yuhna ũsu' çxhab iisa judiuwe'sx pkhaakheni yat-su jxkaase ensu jĩk Jakobo'. ");
INSERT INTO pbb_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Txajũ' Jesus jxkaahnisawe'sx vxite' ancianowe'sx kxtee ũssa jxukaysa puutx we'wetx Pablowe'sx yakh Antiokía çxhabna kaajxa'. Sa' txhitxhtxi Judas Barsabás yaasesa's vxite' Silas txãawe'sx wala jxtuhthesatx. ");
INSERT INTO pbb_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Txãawe'sx yakh karta na'jĩna fxi'jçxa kaahtx: Jesus jxkaahnisawe'sx vxite' ancianowe'sx weçxana yuwe kajaçtha'w ayte ũssa yakhthẽ'jwe'sx jxukaysa yã'jçxa judiu ji'jmée vxite nasa Antiokíate ũssa i'kwe'sxtxi, vxite' Siria Cilicia kiwetewe'sxtxiwa. ");
INSERT INTO pbb_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Kwe'sxa' jiyutha'w kwe'sx yakh ũssa judiu maaíi yu' kwe'sx jxkaahmeetewa u'jçxa txãawe'sx kaapiya'jni yakh i'kwe'sxtxi kaypuba'jna ũsu'ne'ta Moises leya's nwẽese'jçxa ya'cirkuncidaĩne'kwe jĩna. ");
INSERT INTO pbb_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Txã'wẽ yũupa'ga kwe'sx jxukaysa na'wẽ yũuya' puutx we'weçxa kwe'sx yakh ũssatx txhitxhçxa i'kwe'sxtxi thegya' kajaçtha'w kwe'sx yakhthẽ'j Pablowe'sx ");
INSERT INTO pbb_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","na'wẽ nxus knaytxi kwe'sxtxi jxpe'jsa Jesukristo kaapiya'jni's pta'sxpa'ga txãawe'sx yakh. ");
INSERT INTO pbb_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Aça' kwe'sx kaahni Judas vxite' Silas txãawe'sx pa'jçxa i'kwe'sxtxi pta'sxitxna ma'wẽ yũuwa'ja'swa ew ãate. ");
INSERT INTO pbb_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","I'kwe'sxtxi' jwee yu' thaakwe jxkaahmée na'wẽçxáa yũuwa'ja'sku Dxus Espiritu' kwe'sxtxi kaaũusuthe'j: ");
INSERT INTO pbb_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Naa kiwega dxus ĩtxĩmeesa's weçxaya' tajkx ikhni çxiçxa's ũ'wa'jme', eenawa ũ'wa'jme', tajkxnawa thukçxa ikhnisa çxiçxa's ũ'wa'jme'. Ptammeesa pkal yuuna fxi'zewa'jme'. Na'wẽ neewe'we'tha'w txãatx kxtey yuuteçxáa ewna. Dxus yakh txutemée mfxi'zewe. ");
INSERT INTO pbb_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Txã'wẽ kaathe', Silaswe'sxa' Antiokíate pa'jçxa kxteewe'sx yakh pkhaakheçxa karta's dukhte', ");
INSERT INTO pbb_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","txãa karta's lẽeyçxa wala weçxatx txã'wẽ zhiçxkwe yu'kxpehna fxi'jni's uyçxa. ");
INSERT INTO pbb_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Txãa Silaswe'sxa' Dxus kĩh yũuya'watewa dxiikhẽy pta'sxya' ãjasatx yu', txãasa kxte yakhthẽ'jwe'sxtxi yu'kxpehna wala kçxhãaçxha'jtx. ");
INSERT INTO pbb_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Txãawe'sxa' kxte maz en ũsçxa ki' sxaweduuçte', kxte yakhthẽ'jwe'sxa' yuwe wala weçxaa kaahna kaahtx kimne'ta kaah txãawe'sx tasxnay. ");
INSERT INTO pbb_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Nawa Silas yu' kxte neeyũuya'k yajkx. ");
INSERT INTO pbb_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Txajũ' Pablowe'sxa' Antiokíate Dxus yuwe's kaapiya'jna nestxi yuu vxite yakhthẽ'jwe'sx yakh. ");
INSERT INTO pbb_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Txãa e'su' Pablo' Bernabea's na'jĩk: —Yakhthẽ'jwe'sxtxi ki' thegya' u'jwega maa çxhabsuçxah ne'tka'w Dxus yuwe's pta'sx kxsũ jxuka, ma'wẽ ũstewa uyya' jĩte', ");
INSERT INTO pbb_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Bernabea' Juan Markosna pe'jçxak u'j wẽe. ");
INSERT INTO pbb_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Nawa Pablo yu' pe'jna u'jya' wa'lku, txã'wẽ mjĩi pu'çxna jxã'jmée Panfxiliajũçxáa sxawedsa' sũhçxa. ");
INSERT INTO pbb_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Txajũ' puutx ũusçxa we'weçxa txuteetx. Bernabea' Juan Markosna pe'jçxa Çxipre kiwenku u'j, ");
INSERT INTO pbb_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","naapkaçxha' Pablo' Silasnak txhitxh, txãa yakh u'juwa'jsa. Aça' kxte yakhthẽ'jwe'sxa' txãawe'sxtxi Dxus kusete neewe'wena jxã'jaçpkaçxha', kasehtx. ");
INSERT INTO pbb_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Sa' u'jçxa Siria Cilicia kiwesu yakhthẽ'jwe'sxtxi kçxhãaçxha'jtx Dxus yuwe's pta'sxna. ");
INSERT INTO pbb_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Pablo Silas yakh Derbe Listra çxhabsu pa'jçxa kxte puutx uytxi Jesukristo's jxpa'gasa Timoteo yaasesa yakh. Txajx njĩ'ja' Jesukristo's jxpa'gasa judiu ji'thewa, Timoteo ney yu' judiu ji'jmée griegok yu'. ");
INSERT INTO pbb_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Listra Ikonio çxhabsu u'psa yakhthẽ'jwe'sx maawa jxukatx txãa Timoteo's wala tuuthe'je'. ");
INSERT INTO pbb_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Txajũ' Pablo' txãa Timoteo's pe'jçxa u'jya'k yajkx, sa' kaacirkuncidaĩ'kh txã'wẽ griego nçxi'ka' jĩna kxsũ judiuwe'sx açewe'wekahmén. ");
INSERT INTO pbb_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Sa' Jerusalente Jesus jxkaahnisa vxite' ancianowe'sx fxi'jni karta's jxukatx pta'sxna u'jwe' maa çxhabsuwa yakhthẽ'jwe'sxtxi. ");
INSERT INTO pbb_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Txã'wẽ jiyuçxa', kxsũ pkhaakhesawe'sxa' jweeíiçxáatx çxhãçxha Dxus yakh fxi'ze', aça' nasa yu' een isatx pehnana u'jwe' Jesus kaapiya'jni's nwẽese'jna. ");
INSERT INTO pbb_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Txajũ' Pablowe'sxa' Fxrigia Galaciasutx ktejkana u'j, Dxus Espiritu' Asia kiwesu jwee yu' Dxus yuwe's kaapta'sxi'jme' naa pa'ga. ");
INSERT INTO pbb_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Sa' Misia kiwete utxa kũhçxa', Bitinia kiwen u'jwe'nja'w sũhtewa, Espiritu' u'khaahme'. ");
INSERT INTO pbb_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Txã'wẽ yũuyã'the', Misia kiwen teehwed u'jçxa, Troas çxhabtetx pa'j ĩkh wala pukate. ");
INSERT INTO pbb_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Kxte ũsçxak Pablo' teeçx kuste ksxa'w teeçx piçthẽ'j Macedoniatewe'sx na'wẽ pxthaa we'wena ũste: Macedoniate ktejkaçxa, kwe'sxtxi myuh pu'çxya' jĩna. ");
INSERT INTO pbb_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Pablo ksxa'wte txã'wẽ pa'ya yã'the', Macedonia kiwen u'jya' pheu'tha'w, kwe'sxtxi' Dxus txã'wẽ kajaçna Macedoniatewe'sxtxi txajx yuwe ewte nvxiitwa'jsa's pta'sxya' sũhçxa. ");
INSERT INTO pbb_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Troas çxhabuh barkote khẽeçxa u'tha'w ĩkh pxãhte Samotracia kiwen. Sa' vxite kuskuskhẽ' Neapolis çxhabte pa'tha'w. ");
INSERT INTO pbb_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Txajũ ki' u'jçxa', Fxilipos çxhabte pa'jçxa maz en ũsu'tha'w. Txãa çxhaba' romanowe'sx iiyamunisa wala jxtuhthesa yu'k Macedonia kiwete. ");
INSERT INTO pbb_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Teeçx jxkaase ente' çxhab eka kasehtha'w yu'wala pukate Dxus yakh puutx we'weya' pkhaakhenite, sa' Dxus yuwe's pta'sxtha'w kxte u'y pkhaakhesatx. ");
INSERT INTO pbb_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Aça' kxte pkhaakhesa teeçxsa' Lidiak yaase yu', Tiatira çxhabuwe'sx, tela zhiçxkwesatx txweysáa. Txãa u'ya' Dxusna nwẽese'jsak txã'wẽ Pablo pta'sxni's wẽse'jna u'pu'. Aça' Dxusa' txajx ũuste kaajiyu'kh Pablo pta'sxni's. ");
INSERT INTO pbb_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Txajũ' txajx yattewe'sx yã'jçxa jxuka yu'te ya'bautisãyçxa', na'jĩnak kwe'sxtxi pxthaa we'wena pi'kx: —Ũ'kwe' Dxus yakh fxi'zewa'jsate i'kwe'sxa' ew jiiçxa', ũ'kwe yatte myuhwe dejxa' jĩçxa ãadxijimeeçxa pe'jna u'kh. ");
INSERT INTO pbb_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Teeçx ente nyafxíi ũsnitey u'jweççxa', puutx uytha'w teeçx kna'sa's eçxthẽ'j txajx ũuste kaajiyu'the pta'sxna u'jusa yakh. Txãa kna'sa' patron jxpe'jnisa ku'ga yu', sa' patronwe'sxtxi wala vxyu kaaknayu'ju'ku'ga txã'wẽ kĩhnawa ũuste jiyuçxa nasatx pta'sxna. ");
INSERT INTO pbb_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Txãa kna'sa' kwe'sx e'stey yuwe'k Pablo's na'wẽ sus we'wena: —Naa piçthẽ'jwe'sxa' cielute Dxusna selpisaata', txãasatx i'kwe'sxtxi' pta'sxi' ewte u'jwa'j dxi'ja's jĩna. ");
INSERT INTO pbb_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Maz enwa txã'wẽ yũute', nmehte' Pablo' kuçxçxa na'wẽk we'we txãa kna'sa ũuste u'psa eçxthẽ'ja's: —Jesukristo jxkaahni's nwẽese'jçxa, txãa kna'sa ũusuh mkaaseh jĩçpkaçxha', eçxthẽ'ja' kasejk. ");
INSERT INTO pbb_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Nawa patronwe'sxa' txãa kna'sa pa'gaçxáa vxyu knayna fxi'zeni's ivxiituyã'jçxa', Pablowe'sxtxi uweçxa çxhab pxãhte jxũna u'jçxa ");
INSERT INTO pbb_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","kxte khuẽswe'sxtxi na'jĩnatx pãatxhĩ'kh: —Naa piçthẽ'j judiuwe'sxa' wala kuçx yuuna ũsta' kwe'sx çxhabte. ");
INSERT INTO pbb_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Kĩhwa kwe'sxtxi selpiwa'jmeesaçxáanatx kaapiya'ja', aça' txã'sa' kxtey yuuya' ãjãme'nja'w, kwe'sxa' romano nasatha'w naa pa'ga jĩte', ");
INSERT INTO pbb_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","nasa' wala ũusaçxana ahçetx. Aça' khuẽswe'sxa' Pablowe'sxtxi ksũupi'jçxa peçxuukwe kaahtx. ");
INSERT INTO pbb_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Txã'wẽ wala pkxuuçxa', karcelte ktxaaja'jçxa kxte thegna ũssa's wala jxpa'yakx theg kaathe', ");
INSERT INTO pbb_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","kxte thegsa' karcel dxiite jwee dxiiju pe'jna u'jçxa telte çxidatx se'wçxak ki'p. ");
INSERT INTO pbb_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Nawa Pablowe'sx kuspxãh Dxus yakh puutx we'wena memna u'pte', vxite preesu' wẽse'jna u'ppkaçxha', ");
INSERT INTO pbb_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","ehd seena' çxhãçxha u'the', karcel vxitxa' jxuka phaatetx, aça' preesu tudni kadenawa çxuktetetx. ");
INSERT INTO pbb_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Txajũ' karcelte thegsa yajkxçxa', karcel vxitx jxuka phaateçxa ũste uyçxa', kçxilxa's kutxi'jçxa peekíiçxáa ya'ikhya'wak yu', preesu' jxuka kasehçxa u'jne'ta sũhna ũukhçxa. ");
INSERT INTO pbb_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Aça' Pablo' na'wẽk we'we: —Txã'wẽ yũunu. Jxuka ũstha'w ayte jĩte', ");
INSERT INTO pbb_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","karcelte thegsa' bela pki'taçxa ũukhna wuwuuçxáa kũhçxa, Pablowe'sx tasxte peejxũkwek. ");
INSERT INTO pbb_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Txajũ' Pablowe'sxtxi kutxi'jçxa na'wẽk pẽjx: —I'kwe'sxa' mpeeta'sxwe, ¿ma'wẽ yũuçxa Dxusa's uyuuki'th? jĩte', ");
INSERT INTO pbb_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Pablowe'sxa' na'wẽtx pta'sx: —Kwe'sxtxi jxpe'jsa Jesukristo's jxpa'gaçxa yuuçxáa Dxus yakh fxi'zewa'ja's uyuune'ga petx iidx yattewe'sx yã'jçxa jxuka. ");
INSERT INTO pbb_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Txajũ' Dxus yuwe's pta'sxtxi txajx yattewe'sx jxukaysatx. ");
INSERT INTO pbb_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Sa' karcelte thegsa' txãa kustey Pablowe'sx kpã'tx pkhi'kxna'wa txajx yattewe'sx yã'jçxa jxukaysa ya'bautisãytxi. ");
INSERT INTO pbb_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Txajũ' txajx yatna pe'jna u'jçxa puuçku, sa' wala weçxana ũsu'k Dxus yakh fxi'zewa'ja's ji'phutha'w jxukaysa jĩna. ");
INSERT INTO pbb_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Txajũ' khuẽswe'sxa' kusíi policia kaahtx karcelte thegsa tasxna Pablowe'sxtxi' txhweetekahn pta'sxya'. ");
INSERT INTO pbb_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Aça' karcelte thegsa' pta'sxku Pablo's: —Khuẽswe'sxa' txhweetekaahtx i'kwe'sxtxi'. Aça' kasehçxa ũukhmée me'jwe jĩte', ");
INSERT INTO pbb_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Pablo' na'wẽk we'we policiawe'sxtxi: —Kwe'sxa' romano nasatewa ahçeçxa nasa jxuka uyna ũste pkxuuçxa karcelte kxuuphtxi, kĩh yũupa'ga yuuwetewa txã'sa' jiyumey. Sa' ãçxha' paaçte kim yuhwa jiyunimeete txhweete'nja'w ¿sũjuwá'nta? Txã'wẽ yũuya' yu' ãjameetxna. Kwe'sxtxi kutxi'jya' txãawe'sx yuu yuwetxna jĩte', ");
INSERT INTO pbb_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","policiawe'sxa' u'jçxa khuẽswe'sxtxi txã'wẽy pta'sxte', txãawe'sxa' wala ũukhtxi, Pablowe'sxa' romano nasatewa jiyuçxa'. ");
INSERT INTO pbb_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Txajũ' khuẽswe'sxa' Pablowe'sx tasxna u'jçxa jxpubane'tka'w jĩna pxthaa we'weçxa karceluh kutxi'jçxa çxhabuh kaseh kaahtx. ");
INSERT INTO pbb_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Aça' Pablowe'sxa' karceluh kasehçxa', kxte çxhabte Lidia yatnatx u'j. Sa' ũukhmée meswe jĩna yakhthẽ'jwe'sxtxi kvxiisxa'jçxatx txajũ kaseh. ");
INSERT INTO pbb_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Pablo Silas yakh Anfxípolis Apolonia çxhabsu ktejkana u'jçxa, Tesalónika çxhabtetx pa'j judiuwe'sx pkhaakheni yatte. ");
INSERT INTO pbb_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Pablo' jxkaase ensu' tekh ki'supkaçxku Dxus libru ma'wẽne' we'we' txã'sna kaapiya'jna ũsu' judiuwe'sx pkhaakheni yatte. ");
INSERT INTO pbb_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Sa' ãatek pta'sx: —Dxus tasxuh yuusa' wala pxthaa yuuçxa uuçxawa ki' ĩtxi yuuwa'jsak yu', aça' adx i'kwe'sxtxi pta'sxi'th Jesus jĩna txãaíik Dxus tasxuh yuusa Kristo yu'. ");
INSERT INTO pbb_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Txajũ' judiuwe'sx maaíi yu' txã'wẽ Jesusa' Dxus tasxuh yuusa Kristo yuh yu'ne' sũhçxa Pablowe'sx ju'gutx yuu. Txã'wẽy wala kuh griego Dxusna nwẽese'jsawa utxaatx, vxite' u'ywa wala kuh utxaatx jxtuhthesawe'sx. ");
INSERT INTO pbb_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Txã'wẽ yũute', vxite judiuwe'sx Pablo pta'sxni's açesa yu' wala ũusaçxaçxa nasa ewmeesatx pkhakhçxa çxhabte wala seena' ksuusu'tx kuçx yuuna. Sa' Jasón yatte Pablowe'sxtxi pakweya' u'jtx txajũ kutxi'jçxa nasaa ksxavxyte dukhya'. ");
INSERT INTO pbb_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Nawa txãawe'sxtxi uymeeçxa', Jasón vxite' yakhthẽ'jwe'sx kxte ũssaçxáatxwa wezxna u'jçxa çxhabte khuẽs tasxte kuutxa'jçxa na'wẽtx wẽesxu: —Txãa nasa naa kiwe's jxuka kaypuba'jsawe'sx aytewa pa'tha, ");
INSERT INTO pbb_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","aça' Jasona' txajx yattega jxpa'ga. Txãawe'sxa' jxukaysa açe'tx Romate jxkaahsa leya's, txã'wẽ vxite jxkaahsa Jesus yaasesa ũsa' jĩçxa. ");
INSERT INTO pbb_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Txã'jĩna we'wete', khuẽswe'sx nasa jxukaysa wala seena' sustxi. ");
INSERT INTO pbb_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Nawa Jasón vxite' txãa yakh ũssawe'sxtxi vxyu kusa'jçxaçxáa txhweetetx. ");
INSERT INTO pbb_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Kxte yakhthẽ'jwe'sxa' txãa kustey wala dud kaahtx Pablowe'sxtxi' Berea çxhabna. Kxte pa'jna'wa u'jtx judiuwe'sx pkhaakheni yatna. ");
INSERT INTO pbb_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Kxte judiuwe'sxa' wala ew yu'tx Tesalonikatewe'sx na'wẽmée. Dxus yuwe's wala weçxana jxpa'gaçxa, een isatx Dxus librute pakwé' Pablowe'sx pta'sxni isa dxihtewa jiyuya'. ");
INSERT INTO pbb_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Txã'wẽ kxteewe'sx wala kuhsa jiyutx Pablo pta'sxni' isa yuh yu'ga sũhna, vxite' u'y griego jxtuhthesa petx piçthẽ'j yã'jçxa. ");
INSERT INTO pbb_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Nawa judiu Tesalonikatewe'sxa' txã'wẽ Pablo' Dxus yuwe's pta'sxna ũsa' Bereate jĩni's jiyuçxa', Berea çxhabna u'jçxa kxte nasatx wala seena' kaaũusçxa'jtx. ");
INSERT INTO pbb_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Aça' kxte yakhthẽ'jwe'sxa' jwee yu' kaajxthẽeyu'jmée Pablo's kaahtx Atenas dxi'j. Naasáa Silas Timoteo txãawe'sxçxáatx neeyũu Bereate. ");
INSERT INTO pbb_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Pablo yakh pi'kxna u'jsawe'sxa' Atenas çxhabna pa'jtx u'j. Sa' ki' Bereate sxawedna pa'jçxa', Pablo' i'kwe'sxtxi wala dud yuukaakh txãa yakh ũsya' jĩnatx pta'sx Silaswe'sxtxi'. ");
INSERT INTO pbb_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Pablo' Atenas çxhabte Silas Timoteo txãawe'sxtxi ũythasna ũsçxa', wala kuh yajkxna fxi'ze'k txãa çxhaba' naa kiwete dxus ĩtximeesaçxaçxáatxku txakwe wala ji'ph yu' naa pa'ga. ");
INSERT INTO pbb_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Txãasak judiuwe'sx pkhaakheni yatte judiuwe'sx yakh vxite' judiumeeçxawa Dxusa's yaakxsawe'sx yakh puutx we'we', sa' çxhab pxãhsuwa een isak we'we' Dxus ĩtximeesatx neewe'wesawe'sx yakh. ");
INSERT INTO pbb_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Txajũ' kxte epikúreo kaapiya'jni's piyana ũssawe'sx vxite' estóiko kaapiya'jni's piyana ũssawe'sx piçthẽ'ja' Pablo yakh puutx we'wetx, naapkaçxha' maaíi yu' na'jĩnatx we'we' txãawe'sx pwe'sx: —Naa thẽ'ja' ¿kĩjki'k txakwe wala we'we'? jĩ'tx. Naapkaçxha' vxite we'weçxa': —Dxus jiyunimeesatx kxsusnak pta'sxi' jĩ'tx. Pablo' Jesus uuçxa ki' ĩtxĩ yuuni's pta'sxpa'gatx txã'jĩna we'we'. ");
INSERT INTO pbb_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Txajũ' Pablo's teeçx ahte Areópago yaasesate pe'jna u'jçxa paapẽjxtxi: —Kwe'sxtxi meen peeta'sx na'wẽ yuwe u'sesa pta'sxi'g txã'sa' jiyu wẽetha'w. ");
INSERT INTO pbb_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Na'wẽ kĩhwa fxiysa pta'sxi'g txã'sa' ew ãate mkaajiyu'j jĩna. ");
INSERT INTO pbb_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Txã'wẽ Atenastewe'sxa' jxukaysa pkhaakheçxa kĩhwa u'se kaapiya'jni's wẽse'jna puutx paapẽjxnaçxáa fxi'zesatx yu', aça' vxite kiwejuwe'sx Atenaste u'p-ya' pa'jsawa txã'wẽytxi yu'. ");
INSERT INTO pbb_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Txajũ' Pablo' Areópagote txãawe'sx ksxavxyte yujuçxa we'wek: —Atenastewe'sx i'kwe'sxa' dxusa's wala yaakxsane'kwe sũju'th. ");
INSERT INTO pbb_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Msuuwa i'kwe'sx dxusa's neewe'wenisu thegna u'juçxa', uythu teeçx altalte na'wẽ fxi'jnisa: Jiyunimeesa Dxusa' jĩnisa. I'kwe'sx na'wẽ jiyunimeesa dxus jĩna neewe'wene'kwe txãa Dxus jiyunimeesa'sthu adxa' ãate kaajiyu'ju'. ");
INSERT INTO pbb_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Txãa Dxusku naa kiwe's vxitçxa kxte kĩjkĩhçxah ũstxna txãatxwa jxuka vxit. Txãa pa'ga txãaíi namu' naa kiwe, cielu yã'jçxa. Txã' piçthẽ'jwe'sx txaahni yat-su ũsu'çme'. ");
INSERT INTO pbb_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Txã' naa kiwete nasa pu'çxni fxi'zewa'jsame'. Txãaíik kwe'sx jxukaysa ĩtxĩ fxi'zewa'ja's ũs, kĩjkĩhnawa jxuka. ");
INSERT INTO pbb_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Sa' nasa maazkuẽesawa teeçx piçthẽ'j ji'jçxaçxáa yuuwa'ja's vxitçxa, msuuçxah u'pwa'jsatewa pta'sxna ena'swa txuhdek nus pa'jn ki' sekna yuuwa'ja's. ");
INSERT INTO pbb_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Dxusa' ũsna sũhçxa pakweçxa' thẽymée uykahnku txã'wẽ yũu. Aça' Dxusa's pakwete yu' kwe'sx yakh jxu'jmeete ũsa'. ");
INSERT INTO pbb_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Kwe'sxa' Dxus ũste íiçxáatha'w ĩtxi ẽse'sena fxi'zeya' ãja'. Dxus ũste íitx i'kwe'sx ji'j wala fxi'jya' jiisawe'sx na'wẽ we'we: Dxus taki'nitha'w jĩna. ");
INSERT INTO pbb_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Txã'wẽ Dxus taki'niyã'jçxa', piçthẽ'jwe'sx ũus yajkxçxa nasa na'wẽ piisani ũsta' vxyuu beh, vxyuu çxihme, kwet txã'wẽsa' kwe'sxtxi taki'satxna sũhwa'j ji'phmeetha'w. ");
INSERT INTO pbb_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Dxusa' nyafxíi ensuy yu' ma'jĩme' nasa' jiimeeçxa ma'wẽwa yũutewa. Nawa ãçxha' jxukaytxi jxkaaja'k pkaltxi nvxihtçxa Dxusa'sçxáa pakwekahn. ");
INSERT INTO pbb_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Txã'wẽme', Dxusa' teeçx ente naa kiwete yuuwesatx kastigãywa'jsa txhitxhku. Aça' txãa txhitxhnisa' kxtey yuuyujuna. Txã'wẽ yuuya' íiçxáak uuçxawa ki' ĩtxi yuu. ");
INSERT INTO pbb_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Txã'wẽ uuçxawa ki' ĩtxi yuuk jĩni's wẽse'jçxa', maaíi yu' weeçxtxi, naapkaçxha' vxite we'weçxa': —Vxite enkhẽ ki' pta'sxine'ga, txagaçx ki' wẽse'je'nja'w jĩ'tx. ");
INSERT INTO pbb_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Txã'jĩyã'the', Pablo' u'kh. ");
INSERT INTO pbb_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Nawa maaíi yu' Pablo pta'sxni isa yuhna sũhçxa txãa yakh utxaatx. Kxte utxaasaawe'sx teeçxsa' Dionisio Areópagote pkhaakhesatewe'sxku yu', sa' teeçx u'y Dámaris yaasesawa utxaak, vxite yã'jçxa. ");
INSERT INTO pbb_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Txãa e'su', Pablo' Atenasuh kasehçxa Korinto çxhabnak u'j. ");
INSERT INTO pbb_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Kxte' teeçx judiu Akila yaasesa yakhku puutx uy, Ponto kiwejuwe'sx. Akila txajx nyu Priscila yã'jçxa u'seçxáa Italiaju pa'jçxatx kxte ũsu', Romate jxkaahsa Klaudio' judiuwe'sxtxi txajũ jxuka kutxi'pha'ga. Aça' Pablo' txãawe'sx yatna u'jçxa Akilawe'sx yattek yuju. ");
INSERT INTO pbb_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Txãawe'sx na'wẽy tultu kaççxak txweyna fxi'zesa yu', txãasak kxte neeyũu txãawe'sx yakh mjĩina. ");
INSERT INTO pbb_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Sa' jxkaase ensu' judiuwe'sx pkhaakheni yatna u'jçxa, kxte judiuwe'sx vxite' judiumeesatxwa Dxus yuwe's pta'sxi'k Dxus jĩi knayya'. ");
INSERT INTO pbb_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Silas Timoteo yakh Macedonia kiweju pa'the', Pablo' vxite mjĩia's nvxihtçxa, Dxus yuwe pta'sxwa'the yuuçxáak yuju een isa, Jesusa' Dxus tasxuh yuusa Kristo yuh yu'k jĩna judiuwe'sxtxi kaajiyu'jna. ");
INSERT INTO pbb_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Nawa txãawe'sxa' txã'wẽ pta'sxni's jxpeejxmeetha'w jĩçxa ahçena weeçxwa'ja's uytxi. Aça' Pablo': —Adxa' yuuwemeeth, i'kwe'sxtxi pta'sx yã'th. Aça' yuuwesa' i'kwe'sxi'kwe peekx uuwa'ja's pakwena ũspa'ga jĩna txajx athni ropa's ya'tatak. Sa' txã'wẽ yũupa'ga ãçxha' u'jweçthu judiu ji'jmée vxite nasatx pta'sxya' jĩk. ");
INSERT INTO pbb_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Txã'jĩna'wa judiuwe'sx pkhaakheni yatuh kasehna'wa, teeçx piçthẽ'j Justo yaasesa yatnak u'j, judiuwe'sx pkhaakheni yat pukateyçxáa. Txãa piçthẽ'ja' Dxusna neewe'wena fxi'zesak yu'. ");
INSERT INTO pbb_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Txajũ' judiuwe'sx pkhaakheni yattewe'sx npiiçthẽ'jsa Krispo' txajx ũuste Jesusa's nwẽese'jya' yajkxku petx txajx yattewe'sx yã'jçxa jxuka. Txã'wẽy Korintotewe'sxwa wala kuhsa Kristo's jiyuçxa ũuste jxpa'gatx yu'te ya'bautisãyna. ");
INSERT INTO pbb_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Txãa e'su' Jesusa' teeçx kuste na'jĩnak vxyaaçxa we'we Pablo's: —Weh yuhwa ũukhmée Dxus yuwe's mpeeta'sx. Txã'wẽme', naa çxhabte adxna nwẽese'jwa'jsa wala ũs íiçxáata'. ");
INSERT INTO pbb_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Txãa pa'ga adxa' idx yakh pi'kxna ũsthu, aça' kim yuhwa idxa's ikhya' yu' ãjameetxna. ");
INSERT INTO pbb_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Txã'jĩyã'the', Pablo' Korinto çxhabte txãawe'sx ksxavxyte Dxus yuwe's kaapiya'jna ũsu'k anxu y medio ãhpkaçx. ");
INSERT INTO pbb_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Nawa Akaya kiwete ne'jwe'sx Galión ensu' judiuwe'sxa' Pablo's ahçeçxa khuẽs tasxte jxũna u'jtx. ");
INSERT INTO pbb_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Sa' na'jĩnatx pta'sx ne'jwe'sxa's: —Dxusa's nwẽese'jwa'ja's ley jxkaaja'k txãa jxkaahnijũ kasehçxa Dxusa's fxiy nwẽese'jwa'ja'sku kaapiya'ja' naa piçthẽ'ja' jĩte', ");
INSERT INTO pbb_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Pablo pasya'wagaçxha', ne'jwe'sx Galión khuẽ'y judiuwe'sxtxi we'wek: —Yuwe ewmeesa's adxa's pãatxhĩ'kheçwaça', pu'çxhiwá'nja i'kwe'sx pãatxhĩ'khni's. ");
INSERT INTO pbb_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Nawa i'kwe'sx pwe'sx fxi'zeni leyçxá' aça' txã'sa' i'kwe'sx pwe'sx mpheu'jwe. Adxa' txãasu' thegu ji'phmeeth jĩçxa, ");
INSERT INTO pbb_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","txajũ eka kutxi'kh. ");
INSERT INTO pbb_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Aça' judiuwe'sx pkhaakheni yatte npiiçthẽ'jsa Sostenesa's uweçxa, pãpatx griegowe'sx jxukaysa ne'jwe'sx dxi'pte. Nawa Galiona' kuçx ma'jĩme'. ");
INSERT INTO pbb_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Txã'wẽtewa, Pablo' wala kuh en ũsu'k kxte. Txãa e'suk kxte yakhthẽ'jwe'sxçxáatx nvxihtçxa, Siria kiwen u'jwa'j ji'phu barkote khẽeçxa Priscila Akila yã'jçxa. Txãa dxi'j u'jweççxa', Cenkrea çxhabte pa'jçxa barkote khẽemey txajx dxkhasa's jxuka ktxiidxi'k. Dxus yakh yuuçxáa fxi'zewa'ja's Dxus yakh puutx we'wenak txã'wẽ yũu. ");
INSERT INTO pbb_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Txajũ' Efxeso çxhabte pa'jçxa', Pablo' Priscila Akilawe'sxtxi nvxihtna'wa, judiuwe'sx pkhaakheni yatna u'kh, kxte judiuwe'sxtxi Dxus yuwe's kaajiyu'jya'. ");
INSERT INTO pbb_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Aça' txãawe'sxa' wala pxthaa we'wetx kuh en ũskahn. Nawa Pablo' kxtey yuumée, ");
INSERT INTO pbb_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","txajũ ki' kasejk na'jĩçxa: —Jerusalente fxiesta u'puya'wa' kxte ũswa'j ji'pthu. Nawa ki' sxawedu'nja i'kwe'sxtxi thegya', Dxus ma'wẽ jxthãaste' jĩna we'weçxa, Efxeso çxhabuh barkote khẽeçxa u'kh. ");
INSERT INTO pbb_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Sa' Cesarea çxhabte pa'jçxa', Jerusalennak u'j kxte pkhaakhesawe'sxtxi weçxaya'. Txajũ' Antiokía çxhabnak u'j. ");
INSERT INTO pbb_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Kxte maz en ũsçxaçxáa, txajũ ki' kasejk Galacia Fxrigia kiwesu nyafxíi pta'sxnisu jxuka pekũjxa', Dxus yakh fxi'zesawe'sxtxi kçxhãaçxha'jna. ");
INSERT INTO pbb_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Txãa ensu' teeçx judiu Apolos yaasesa Alejadría çxhabuwe'sx pa'kh Efxeso çxhabte, Dxus libru Moises fxi'jni's ew jiisa kaapiya'jya' sxiigmeesa. ");
INSERT INTO pbb_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Sa' Jesukristo kimtewa pta'sxni jiik yu', txãasak Juan yu'te bautisãyniçxáana jiiçxawa txajx jiyuni yu'sa' jxpubamée kaapiya'ja'. ");
INSERT INTO pbb_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Apolosa' judiuwe'sx pkhaakheni yatte u'kaçxa sxiigmeek pta'sxi'. Aça' Priscila Akilawe'sx jiyuçxa', txãa Apolos txã'sçxáa fxii pe'jna u'jçxa, jweeíiçxáatx ew pta'sx Jesukristo yakh fxi'zewa'ja's jxuka. ");
INSERT INTO pbb_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Aça' Apolosa' Akaya kiwen u'jweçte', yakhthẽ'jwe'sxa' u'jwa'ja's pu'çxçxa teeçx karta fxi'jtx Akayate yakhthẽ'jwe'sx wa'lmée jxpa'gakahn. Txã'wẽ Akayate pa'jçxa', wala pu'çxku Dxus peeygãhçxa nwe'wenisatx na'wẽ yũuna: ");
INSERT INTO pbb_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Jesusa' Dxus tasxuh yuusa Kristo yuh yu'k, i'kwe'sx ũythasni txã'sna i'kwe judiuwe'sx jxpuba jĩnak pta'sxi', Dxus librute ma'wẽ fxi'jni ũsna txãa yakh kaaja'da'jna. ");
INSERT INTO pbb_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Apolosa' Korinto çxhabte ũspkaçxha', Pablo' yaçkhẽy pekũhni kiwesu pa'jna u'jçxa Efxeso çxhabtek pa'j. Kxtea' Jesukristo's iiwẽse'jsa yakh puutx uyçxa', ");
INSERT INTO pbb_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","na'wẽk pẽjx: —I'kwe'sxa' Jesukristo's jiyunijũ' ¿Dxus Espiritu's jxpa'gakwe'? jĩte', na'wẽtx pas: —Dxus Espiritu's naa kiwete kaahnik yuu jĩniçxáa yuhnawa iiwẽse'jmeetha'w kwe'sxa'. ");
INSERT INTO pbb_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Txajũ' Pablo' pẽjxku: —I'kwe'sxa' ¿kĩh yũuya' sũhçxakwe ya'bautisãy? jĩte', txãawe'sx pasçxa': —Juan pta'sxçxa': Ya'bautisãywa'ja' jĩk aççxáatha'w ya'bautisãy jĩtx. ");
INSERT INTO pbb_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Txajũ' Pablo' na'wẽk pta'sx: —Juana' yu'te bautisãyku pkaltxi nvxihtçxa peena yu' pkalte fxi'zemeene'kwe, Dxus tasxuh yuusa Kristo adx e'ste yuja' txã'sna jxpa'gaya' jĩçxa bautisãysak yu' jĩte', ");
INSERT INTO pbb_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","txãawe'sxa' ya'bautisãytxi Jesusa's nwẽese'jya' sũhçxa. ");
INSERT INTO pbb_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Txajũ' Pablo' txãawe'sx dxikthesu peekizeçxa Dxusa's neewe'wete', Dxus Espiritu' txãawe'sx ũuste khẽek. Aça' vxite yuweju we'weya' ãjawa'ja's jxpa'gatx, sa' Dxus kĩh yũuya'watewa dxiikhẽy pta'sxya' ãjatx. ");
INSERT INTO pbb_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Txã'wẽ yũusa' doce piçthẽ'jtx yu'. ");
INSERT INTO pbb_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Pablo' kxte ũsçxa' judiuwe'sx pkhaakheni yatna u'jna nesku yu' tekh a'tepkaçx. Sa' nasatx ewku kaajiyu'ju' Dxus jxkaahwa'j ena's. ");
INSERT INTO pbb_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Nawa vxite yu' txã'wẽ pta'sxni's wẽse'j wẽemeeçxa, açewe'wetx nasaa ksxavxyte. Aça' Pablo' txãawe'sx tasxuh txuteeçxa Jesukristo's jxpa'gasawe'sxtxi pe'jna u'kh Tiranno kaapiya'jni yatna, sa' kxte' een isak pta'sxi' e'z anxupkaçx. ");
INSERT INTO pbb_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Aça' Asia kiwesu u'psa jxukaysa jiyutx judiu vxite' judiumeesawa Jesus kaapiya'jni's. ");
INSERT INTO pbb_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Txajũ' Dxus pu'çxte', Pablo' nuykatxhi'k kĩh weete ãça'satxwa jxuka. ");
INSERT INTO pbb_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Txã'wẽ yũuyã'the', Pablo ropa meeçxa' panxwelo kĩhçxáanawa jxũna u'jwe'tx ãça'sawe'sx jxa'dxkahn. Aça' txã's jxa'dxçxaçxáa kĩh weejuwa katxhi'tx, txã'wẽy eçxwa txãawe'sx ũusuh kaseje'tx. ");
INSERT INTO pbb_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Txã'wẽ yũute', judiuwe'sx dxijxuuçxa eçxtxi nasaa ũusuh kutxi'jsawe'sxwa Jesus yase's kxsusçxa eçxtxi kutxi'jya' na'wẽtx we'we': —Pablo kxsusnisa Jesus yasete jxkaajaçthu kasejkahn jĩnatx we'we'. ");
INSERT INTO pbb_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Txã'wẽ yũusa' sacerdote npiiçthẽ'j Escewa nçxi'k sietesatx txã'wẽ yu'. ");
INSERT INTO pbb_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Makwe txã'wẽ we'wetewa, eçxa' na'wẽk pas: —Jesusa's jiith kimtewa, sa' Pablo'swa iiuythu. Nawa i'kwe'sx yuutxi' jiimeeth kimtewa. ");
INSERT INTO pbb_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Txã'jĩna'wa txãa eçx iiyamunisa nasa' jxkaahna we'wesawe'sx kakwete ãaphçxa, txãawe'sx athni ropatx sudena kpã'vxitna yũute', txãawe'sxa' ũphna u'jtx sũpxçxáa. ");
INSERT INTO pbb_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Txã'wẽ yũuni's Efxeso çxhabte ũssa judiuwe'sx vxite' judiumeesawa jiyuçxa' Jesus yase's kxsusya' wala ũukhtxi, sa' Jesusa's weçxanaçxáatx fxi'ze'. ");
INSERT INTO pbb_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Txajũ' Pablo pta'sxni' ewsa yuhna sũhçxa maazkuẽesawa utxaatx txãawe'sx ewmée yũuna fxi'zeni's ãate pta'sxna. ");
INSERT INTO pbb_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Aça' txã'wẽy dxijxuuna fxi'zesawa jxukay txãawe'sx libru ewmeesatx jxũna pa'jçxa', jxukaysa dxi'pte kabtxi. Txãa libru' jxukaçxah yu' cinkwenta mil peso ãhtx pa'gasa yu'. ");
INSERT INTO pbb_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Txã'wẽ yũute', Dxus yuwe' jweeíiçxáak çxhãçxha walaana u'j. ");
INSERT INTO pbb_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Txãa e'su', Pablo' Jerusalenna u'jweççxa', Macedonia Akaya kiwesu pa'jna u'jya'k yajkx. Sa' Jerusalenuh Roma çxhabnawa u'jwe'nja sũhnak yajkx. ");
INSERT INTO pbb_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Txajũ' Macedonia kiwen kaakh txã'sna pu'çxna u'jusa Timoteo vxite' Erasto txãawe'sx e'zsatx. Nawa txãa yu' nee Asia kiwete ũsu'k maz en. ");
INSERT INTO pbb_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Txãn ensu' wala seena' sustxi Dxus yuwe's ahçeçxaçxáa. ");
INSERT INTO pbb_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Txãa yuwe kiissa yu' Demetrio vxyuu çxihme's dxus Diana ũsni yat na'wẽ pheu'jçxa txãa yakh mjĩisatx wala vxyu kaaknayu'jsak txã'wẽ yũu. ");
INSERT INTO pbb_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Sa' txãa yakh mjĩisa vxite' txãa na'wẽy pheu'jsatxwa jxuka pkhakhçxa na'jĩk: —I'kwe'sxa' jii i'kwe na'wẽ mjĩiçxa' kĩh yuhwa peejxmeetha'w vxyu uyu'. ");
INSERT INTO pbb_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Nawa i'kwe'sxa' iiwẽse'jne'kwe Pablo jĩnisa' naa çxhab Efxesoteçxáamée, Asia kiwete msuuwa nasatxi' jxuka txajx ju'gu tuphiça', txã'wẽ piçthẽ'jwe'sx pheu'jni dxusa' ĩtximeesata' jĩçxa. ");
INSERT INTO pbb_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Na'sa' mpa'yajkxwe. Txã'wẽ yũumeete', kwe'sx mjĩiniçxáa vxitumée, dxus Diana ũsni yat txakwe wala jxtuhthesa yuu vxituna. Aça' Asia kiwetewe'sx jwee vxite kiwetewe'sxwa dxus Diana txakwe zhiçxkwesa's jwee yu' nwẽese'jmeetxna. ");
INSERT INTO pbb_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Txã'jĩna we'wete', wala ũusaçxaçxa na'jĩnatx sus we'we: —¡Efxeso çxhabte dxus Diana yuuçxáa maatewa jxthaakwe jxtuhthesa'! jĩnatx sus. ");
INSERT INTO pbb_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Aça' txãa çxhabtewe'sx jxuka ũusaçxaçxa e'z piçthẽ'j Macedoniajũwe'sx Pablo's pi'kxna yuusa Gayo Aristarko txãawe'sxçxáatx uweçxa wezxna u'jtx çxhabte txãawe'sx ũsnite. ");
INSERT INTO pbb_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Pablo' kxte u'ka wẽek nasatx we'weya'. Nawa kxte yakhthẽ'jwe'sxa' ka'ga'jmeeta'. ");
INSERT INTO pbb_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Txã'wẽy Pablo namiku khuẽswe'sx jxtuhthesawa Pablo's kuçx kxte u'kakaahmeeta'. ");
INSERT INTO pbb_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Naapkaçxha' pkhaakhesa yu' kĩjkĩhwa ũusçxa we'wena seena'tx susna ũsu'. Nawa kxte pkhaakhe pu'çxsa jwee kuhsa yu' jiimeetx yu' kĩh yũupa'ga txã'wẽ pkhaakhetewa. ");
INSERT INTO pbb_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Nawa kxte ũssa maaíi yu' kĩh yũupa'ga ũusaçxana ũstewa jiisa', teeçx piçthẽ'j Alejandro yaasesa's pta'sxçxa nasaa ksxavxyte ukapajkxna nuykũhtx we'wewa'jsa. Aça' txãa piçthẽ'ja' sxuuna' yuuwa'ja's kuseju pta'sxçxa judiuwe'sxa' yuuwemeetha'w jĩna we'we wẽek. ");
INSERT INTO pbb_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Nawa judiu íiçxáatewa jiyuçxa', jxukaysa ki' sus we'wetx e'z ora ãhpkaçx na'jĩna: —¡Efxeso çxhabte dxus Diana yuuçxáa maatewa jxthaakwe jxtuhthesa'! jĩna. ");
INSERT INTO pbb_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Txajũ' çxhabte sekretario' pejka sxuuna' vxitçxa' na'jĩk: —Efxesotewe'sx mwẽese'jwe. Naa çxhabte nasa' dxus Diana ũsni yata's wala jxpa'yakx thegna vxite' Diana's piisanisa cieluju kĩjk txã'snawa txã'wẽy ew jxpe'jwa'jsatewa jxuka jiita' maa kiwetewe'sxwa. ");
INSERT INTO pbb_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Aça' ¿ma'wẽ yũuçxa txã'sa' thegmée nvxiht-ya' ãjatxki? Txã'wẽ yu' yuumeetxna. Txãa pa'ga wejx kuh yajkxmée sxuuna' myuuwe. ");
INSERT INTO pbb_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Txãa pa'gatey e'z piçthẽ'j i'kwe'sx jxũna kũji'kwe txãawe'sxa' i'kwe'sx dxus Diana's suwwameeta' sa' açewe'wenawa ũsmeeta'. ");
INSERT INTO pbb_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Meeçxa' Demetrio vxite' txãa yakh mjĩisawe'sxçxáa maa yakh iipuiisaçxawa, pãatxhĩ'khwa'j ji'phta', txãa pa'gatey khuẽswe'sx ũsta', aça' txãawe'sx tasxte pãatxhĩ'khya' u'jwetxna, kxah kaapdxi'pu'jçxa yuwe's pheu'jutxna kĩhteçxah yuuwesatewa. ");
INSERT INTO pbb_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","I'kwe'sxa' khuẽs tasxtemée i'kwe'sx pwe'sxçxáa puutx we'wewa'j ji'phçxawa, zhiçxkwe mpuutxwe'wewe txã'wẽ susmée. ");
INSERT INTO pbb_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Na'wẽ ãçxh susni yuwe's gobierno' paapẽyiwáana aça' seena' ewmeete neeyũuwa'the ũstha'w, kĩhwa yuuwemeete suspa'ga. ");
INSERT INTO pbb_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Txã'wẽ we'weçxa', kaapçu'juk txãa susni's. ");
INSERT INTO pbb_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Yuwe susni pçuute', Pablo' Dxus yakh fxi'zesawe'sxtxi pa'yaçxa wala ew yu'kxpehçxak txãawe'sxtxi weçxaçxa Macedonia kiwen u'j. ");
INSERT INTO pbb_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Txãa kiwesu jxuka pekũjk yakhthẽ'jwe'sx ũukhwe'sxte kçxhãaçxha'jna. Sa' txajũ' Grecia kiwenwa u'kh. ");
INSERT INTO pbb_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Kxte tekh a'te ũsçxa', barkote khẽeçxa Siria kiwen u'jya'wak yu'. Nawa judiuwe'sx ikhya'wata' txãa dxi'the jĩni's jiyuçxaçxáa, barkote u'jmée çxidaçxáa maa dxi'june' pa'j txã'wẽyku sxawedxa' yajkx, Macedonia kiwejuy uykhẽwna. ");
INSERT INTO pbb_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Txãa yakh pi'kxna u'jtx Sópater Bereajuwe'sx, Aristarko vxite' Segudo Tesalonikajuwe'sx vxite' Gayo Derbejuwe'sx vxite' Timoteo vxite' Tíkiko Trófximo txãawe'sxa' Asia kiwetewe'sxtxi yu'. ");
INSERT INTO pbb_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Txãa yakhthẽ'jwe'sxa' dxi'j pxãjũ yaçte u'jçxa Troas çxhabtetx kwe'sxtxi ũythas. ");
INSERT INTO pbb_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Pan lewadura ji'phmée ũ'ni fxiesta skhẽwniitetha'w kwe'sxa' kaseh, Fxilipos çxhabuh barkote khẽeçxa, sa' tahç ente' kpajkxtha'w Troas çxhabte. Kxte siete entha'w ũsu'. ");
INSERT INTO pbb_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Ki'sen ente', Dxus yakh fxi'zesawe'sx yakh pkhaakhetha'w kxteçxah pkhaakheçxa ũ'ya'. Naapkaçxha' Pablo' Dxus yuwe's kaapiya'kh. Txã'wẽ kuskuskhẽ' u'jwe ji'phçxa', txaçx kuspxãhnpkaçxku pta'sxna ũsu', ");
INSERT INTO pbb_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","teeçx piesate ẽete wala kuh lampara pki'tanisa ũsu'tx kxtee. ");
INSERT INTO pbb_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Aça' kxte teeçx piçtakx Eutiko yaasesak wentanate kaçxçxa u'pu'. Txã'wẽ Pablo' wala jxu'j we'wete', txãa piçtakxa' dee wẽeçxa dehna u'píi saapajkxku yat ẽe walaju, aça' uuniisa'stxi kiis. ");
INSERT INTO pbb_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Txã'wẽ yũute', Pablo' sa'jçxa, txãa uusa's psxa'dçxa na'wẽk we'we: —Yakhthẽ'jwe'sx, nxusnuwe, ki' ĩtxi yuuk jĩnak pta'sx. ");
INSERT INTO pbb_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Txajũ' Pablo' ki' ẽe yatte tejkaçxa Santa Cena's puuçku. Txã'wẽ yũuçxa khikhyna sẽhpkaçx pta'sxçxak u'j. ");
INSERT INTO pbb_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Txãa piçtakxa' ki' ĩtxi yuute', pe'jna u'jçxa jxukaysa wala weçxana neeyũutx. ");
INSERT INTO pbb_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Kwe'sxa' barkote khẽeçxa yaçte u'tha'w Asón çxhabna, Pablo's kxte ũythasya'. Naapkaçxha' txã' çxidajk u'j. ");
INSERT INTO pbb_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Asón çxhabujk kwe'sx yakh barkote khẽe, aça' txajũtha'w Mitilene çxhabna u'j. ");
INSERT INTO pbb_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Txajũ ki' kasehçxa vxite enkhẽ' Kío kiwe pukasutha'w skhẽw. Sa' vxite enkhẽ' Samos kiwetek barko' dudte utxaa. Txajũ ki' u'jçxa', teeçx ahte Trogilio yaasesate pa'jçxatha'w jxkaase. Txajũ' vxite enkhẽ' ki' u'jçxa' Mileto çxhabte pa'tha'w. ");
INSERT INTO pbb_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Pablo' Asia kiwete jxthẽeyuuya'mée, Efxeso çxhabte u'kame', Jerusalente dud pa'jçxa Pentekostes fxiestate ũsya' sũhçxa. ");
INSERT INTO pbb_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Sa' Mileto çxhabte pa'jçxa', Efxeso çxhabte ancianowe'sxtxi pa'yak na'wẽ we'weya': ");
INSERT INTO pbb_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","—Adxa' Asia kiwete nyafxçxah pa'jíi kĩhtka yũuna fxi'ze ãçxpkaçx txã'sa' i'kwe'sxa' jii i'kwe. ");
INSERT INTO pbb_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Judiuwe'sx açepa'ga txakwe wala nxuswa'j en pa'thewa, Jesukristo's een isa selpiina bagaçxtewa i'kwe'sxtxi ũ'ne petx khakh pu'çxna nesthu yu' kim yuhnawa iiwejçx we'wemée. ");
INSERT INTO pbb_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","I'kwe'sxtxi selpiwa'jsa Dxus yuwe's pta'sxmée yu' yuumée, nasaa ksxavxysu yat-suwa kaapiya'jna nesthu yu'. ");
INSERT INTO pbb_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Txã'wẽy judiuwe'sx vxite' judiu ji'jmée txãawe'sxtxiwa jxukaysatx pta'sxthu: Dxus tasxte sxawedxa' pkaltxi nvxihtçxa kwe'sxtxi jxpe'jsa Jesukristo'swa ũuste miipa'gawe jĩna. ");
INSERT INTO pbb_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Ãçxha' u'jweçthu Jerusalenna Espiritu kaahni. Nawa jiimée u'jweçthu kxte jwee kĩhçxa yuune'thewa. ");
INSERT INTO pbb_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Naasáa na'wẽ yuuçxáa jiith: maa çxhabte u'thewa Dxus Espiritu' pta'sxna nesku yu' karcelte kxuuphni wala nxuswa'j ji'phgu jĩna. ");
INSERT INTO pbb_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Nawa txã'sa' yaaki'çmeeth, sa' adx uuwa'ja's yuhwa ũukhu'çmeeth. Jesukristo neewe'wek Dxus peeygãani's txã'sna uu entepkaçx weçxana pta'sxna fxi'zewaççxáa, txã'wẽena sũju'th. ");
INSERT INTO pbb_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","Ayte i'kwe'sx yakh ũsçxa' Dxus jxkaahwa'j ena's pta'sxthu txã's wẽse'jsa aytewe'sxa' adxa's ãçxhuyã'ja' peena yu' uymeene'kwe sũju'th. ");
INSERT INTO pbb_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Nawa adxa' i'kwe'sxtxi kaapiya'jyã'th na' yuuwemeeth, ");
INSERT INTO pbb_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","txãa pa'gatey Dxus jxthãasni's paaçte nvxihtmée jxuka ãateçxaçxáath pta'sx naa pa'ga. ");
INSERT INTO pbb_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Aça' ãçxha' peekíi ya'mpa'yajkxwe, txã'wẽy Jesukristo ee pkawçxa weynisa Dxus luuçxtxiwa ew jxpe'jna, Dxus Espiritu' i'kwe'sxtxik thegwa'jsa nvxiht naa pa'ga. ");
INSERT INTO pbb_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Jiith adx u'the', vxite pa'jatxna Dxus yakh fxi'zesawe'sxtxi ivxiitu wẽena, sxĩ'j weesweewa ma'wẽta piisxaatx ivxiitu' txã'wẽy yũuya'. ");
INSERT INTO pbb_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Jxpa'yakxmeeçxa', i'kwe'sx pwe'sxíiwa kasejene'kwe isasa's pta'sxipkaçxte kaypuba'jwa'jçxá's pta'sxna Dxus yakh fxi'zesatx kaypuba'jna. ");
INSERT INTO pbb_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","I'kwe'sxa' miiyajkxwe, adxa' tekh anxuth teeçxsa na'wẽçxah yu'kxpehna ũsu' en petx kus yã'jçxa ũ'ne petx khakh. ");
INSERT INTO pbb_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","Ãçxha' yakhthẽ'jwe'sxtxi Dxusa's neewe'weçxa txajx kusete nvxiituçthu txajx kaapiya'jni's peçxkanamée fxi'zekahn, txãa pa'gatey txajx yuwe' kçxhãaçxha'jna weçxana kaafxi'ze'jçxa cielute txajx nwe'wenisa jxukaysa yakh ũswa'ja'swa ũsya' ãjawa'jsa'. ");
INSERT INTO pbb_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Adxa' i'kwe'sx yakh ũsçxa', vxyu, ropa, txã'wẽsa pees jxthãasna fxi'zemeeth kim yuhnawa. ");
INSERT INTO pbb_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","I'kwe'sxa' ew jii i'kwe txã'wẽ yũumée, adx kuseju mjĩiçxath kĩh peejini'swa uyu', vxite' adx yakh u'jusawe'sx jĩiwa txã'wẽy. ");
INSERT INTO pbb_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Txã'wẽ vxite jxpeejxsatx pu'çxwa'ja's kaapiya'jnath fxi'ze bagaçxtewa. Txã'wẽ yũukahníik Jesukristowa na'jĩ': Peessa yakh wejx weçxa yuja' jxpa'gasate jxthaakwe jĩ'k. ");
INSERT INTO pbb_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Pablo' we'wena jxã'jçxa', jxukaysa yakh peejxũkweçxa Dxus yakh puutx we'wek. ");
INSERT INTO pbb_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Txajũ' jxukaysa ũ'nena psxa'dçxa Pablo's weçxatx. ");
INSERT INTO pbb_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Txã'wẽ peena yu' uymeene'kwe jĩte', wala nxusna ũsu'tx, sa' pi'kxna u'jtx barkote khẽepkaçx. ");
INSERT INTO pbb_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Yakhthẽ'jwe'sxtxi nvxihtçxa, barkote khẽena'wa teehwed u'tha'w teeçx ahte Kos yaasesate. Sa' vxite enkhẽ' Rodas kiwete pa'tha'w. Txãajũ Pátara çxhabnatha'w u'j. ");
INSERT INTO pbb_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Pátara çxhabte pa'jçxa, teeçx barko uytha'w Fxenicia kiwen u'jsa, txãatetha'w khẽeçxa u'j. ");
INSERT INTO pbb_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Çxipre kiwe's uynatha'w skhẽw, txã' jebu ju'guk neeyũu. Txã'wẽ u'jçxatha'w Siria kiwete pa'j. Sa' Tiro çxhabte u'katha'w barko' kxte karga spãasxwa'kh ji'phu' naa pa'ga. ");
INSERT INTO pbb_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Kxte' Kristo's nwẽese'jsawe'sxtxitha'w uy, sa' siete entha'w ũsu' txãawe'sx yakh. Aça' txãawe'sxtxi Dxus Espiritu kaajiyu'the', Pablo's pta'sxtxi Jerusalenna u'jmeene'ga jĩna. ");
INSERT INTO pbb_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Txã'wẽtewa, siete en skhẽuuçpkaçxha', kasehtha'w. Aça' Kristo's nwẽese'jsawe'sx jxukaysa nyuuwe'sx petx luuçx yã'jçxa pi'kxna yuwe'tx çxhab ekaju kasehpkaçx. Sa' kxte ĩkh pukate peejxũkweçxa Dxus yakh puutx we'weçxa, ");
INSERT INTO pbb_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","psxa'dna weçxana'wa barkote khẽetha'w. Naapkaçxha' txãawe'sxa' sxawedtxi yatna. ");
INSERT INTO pbb_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Kwe'sxa' Tiro çxhabuh barkote u'jçxa, Tolemaida çxhabtetha'w pa'j. Kxte teeçx entha'w ũsu' yakhthẽ'jwe'sxtxi weçxana. ");
INSERT INTO pbb_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Vxite kuskuskhẽ' Pablo vxite' txãa yakh u'jusa yã'jçxa kasehtha'w Cesarea çxhabna u'jya'. Kxte pa'jçxa', Fxelipe yatna u'jçxa kxtetha'w deh. Txãa yu' Pedro txhitxhku siete diákono txãatewe'sxku yu' Jesukristo kaapiya'jni's jxpa'gaçxa pta'sxna pekũhsa. ");
INSERT INTO pbb_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Txãa Fxelipe' pahz niisa kna'sasak ji'phu', Dxus we'weni's pta'sxsa. ");
INSERT INTO pbb_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Kxte maz en ũspkaçxha', teeçx piçthẽ'j pa'kh, Agabo yaasesa Judea kiwejuwe'sx, Dxus kĩh yũuya'watewa dxiikhẽy pta'sxsa. ");
INSERT INTO pbb_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Txã' kwe'sxtxi puutx uyçxa', Pablo jxtudni's pẽjxçxa peekíiçxáa çxida petx kuse yakh ya'jytudçxa na'wẽk we'we: —Dxus Espiritu' pta'sxi'k, Jerusalente judiuwe'sxa' naa jxtudni namu's na'wẽ tudçxa vxite nasatx dukhetxna jĩk. ");
INSERT INTO pbb_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Txã'jĩni's wẽse'jçxa', kwe'sx vxite' Cesareatewe'sx yã'jçxa wala neevxisxatha'w Pablo's Jerusalenna u'khamen. ");
INSERT INTO pbb_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Nawa Pablo' na'wẽk pas: —¿Kĩjxa'kwe txakwe nxusna ũ'ne', adxna khaawãsxi'j wẽeçxa? Adxa' Jesukristo's selpiipa'ga tudniçxáa yuumée, Jerusalente uuwa'j ma'k yuu nawa txã'sa' ũukhu'çmeeth jĩk. ");
INSERT INTO pbb_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Neevxisxaya' ãjameeyã'jçxa', Dxus ma'wẽ jxthãaste' kxtey yuuna jĩnaçxáatha'w we'we. ");
INSERT INTO pbb_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Txãa e'su', pheu'jna'wa Jerusalenna u'tha'w. ");
INSERT INTO pbb_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Aça' Cesareate yakhthẽ'jwe'sx pi'kxna yuwe'tx, vxite' txãawe'sx yakh teeçx piçthẽ'j Çxipre kiwejuwe'sx, wala txaçxyã'j Dxus yakh fxi'zesa Mnasón yaasesawa yuwe'k. Aça' kwe'sxa' txajx yatte dejxa'tha'w puutx we'we. ");
INSERT INTO pbb_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Jerusalente pa'the', kxte yakhthẽ'jwe'sxa' wala weçxana jxpa'gatx. ");
INSERT INTO pbb_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Vxite enkhẽ' Pablo' kwe'sx yakh u'kh Jakobo yatna pa'jya', aça' kxtea' ancianowe'sx jxukaysatx ũsu'. ");
INSERT INTO pbb_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Pablo' weçxana jxã'jçxa', pta'sxku judiu ji'jmée vxite nasa ksxavxysuwa Dxus yuwe's pta'sxte', txãawe'sxtxi Dxus ma'wẽ yũuni'swa jxuka. ");
INSERT INTO pbb_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Aça' wẽse'jçxa', Dxusa's wala weçxaçxa na'wẽtx pta'sx Pablo's: —Yakhthẽ'j, idxa' jiiyã'jne'ga judiu ji'jwe'sx wala kuhsa Jesus kaapiya'jni's jxpa'gasa ũsta', sa' txãawe'sxa' Moises leya's nvxihtmeete ewna jĩ'tx. ");
INSERT INTO pbb_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Txãawe'sxa' na'jĩni'sta jiyu: Idxa' judiuwe'sx jxukaysatx vxite kiwejuwe'sxtxi kaapiya'jçxa Moises jxkaahni's nwẽese'jmeene'kwe, sa' i'kwe'sx luuçxtxiwa cirkuncidãimeene'kwe, kĩh yuhnawa kxtey yuuwa'jme', txã'jĩnak pta'sxi' jĩni's jiita'. ");
INSERT INTO pbb_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Sa' iidx pa'jni's jiyuçxa', txãawe'sxa' idxa's wẽse'jya' pkhaakhetxna, aça' ¿kĩh yũukxtha'w? ");
INSERT INTO pbb_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Wejxwa na'wẽ yũune'ga: Ayte pahz piçthẽ'j ũsta'. Txãawe'sxa' Dxus yatte u'kaya' ãjawa'ja's Moises ley jxkaaja'k txã'sa' kxtey yuuya' ũsta'. ");
INSERT INTO pbb_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Aça' idxa' txãawe'sxtxi dxuus yatna pe'jna u'jçxa ley jxkaahni ki'swa'ja's kxtey kxu'ju'june'ga petx idx yã'jçxa. Sa' kxte dukhwa'ja'swa idxçxaçxáa deweene'ga. Txajũ' txãawe'sxa' dxkhasa's ktxiidxi'jitxna idxwa txã'wẽy. Txã'wẽ leya's kxtey yuute', maawa jiyutxna txã'wẽ Pablo' leya's nvxiitwa'ja' jĩnak jxkaaja' jĩçxa' ĩsxiija'ne'ta sũhna. ");
INSERT INTO pbb_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Nawa judiu ji'jmée vxite nasaçxawa Jesus kaapiya'jni's jxpa'gasawe'sx yu' ley jxkaahni's kxtey yuuwa'j ji'phmeeta'. Txãawe'sxtxi' kwe'sxa' pta'sxna fxi'jyã'tha'w na'wẽ yũuwa'ja's: Dxus ĩtximeesatx weçxaya' tajkx ikhni çxiçxa's ũ'wa'jme', eenawa ũ'wa'jme', tajkxa's thukçxa ikhnisa çxiçxa'swa ũ'wa'jme', sa' ptammeesa' pkal yũuna fxi'zewa'jme' jĩna pta'sxnisaçxá's kxtey yuuwa'jsata' jĩtx. ");
INSERT INTO pbb_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Txajũ' Pablo' txãa pahz piçthẽ'jtx pe'jna u'jçxa', kuskus enkhẽ' ley jxkaahni's jxuka kxtey yuuçxak dxuus yat dxiite u'ka kĩh entepkaçx ki'sya'waçxawa txãatx pta'sxya'. ");
INSERT INTO pbb_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Sa' siete en ki'swa'jtx jxuka jxã'jaçpkaçxha', Asia kiwejuwe'sx judiuwe'sx pa'jçxa Pablo's dxuus yatte uyçxa', nasa jxukaysatx kaaũusçxa'jna'wa Pablo's tudçxa ");
INSERT INTO pbb_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","na'wẽtx sus we'we: —Israelwe'sx, mpu'çxwe. Naa piçthẽ'jíik msuuwa jxuka nasa jxukaysatx kaapiya'jna pekũju' kwe'sx ji'jtx açewe'wena, Moises leynawa txã'wẽy. Sa' dxuus yatnawa açewe'we'k. Sa' txã'wẽçxáa yũumée, ãçxha' judiu ji'jmée griegowe'sxtxiwa dxuus yat dxiite ka'gak kazx vxitna jĩ'tx. ");
INSERT INTO pbb_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Efxeso çxhabuwe'sx Trófximo yakh Pablo' Jerusalente ũste ne'ta uy, txãasatx dxuus yat dxiite ka'ga'jne' sũhçxa txã'jĩna we'we'. ");
INSERT INTO pbb_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Txã'jĩna pta'sxni seena' suste', nasa' wala dud kũhçxa Pablo's tudçxa dxuus yat ekaju wezxna kutxi'jiçpkaçxha', vxitxa's aphtxi. ");
INSERT INTO pbb_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Ikhya'watx yu', nawa komadante' jiyuk Jerusalen çxhabtewe'sx seena' susna ũsta' jĩni's. ");
INSERT INTO pbb_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Txajũ' komadante' soldau vxite' txãawe'sx pwe'sx jxtuhthesatx pkhakhçxa wuwuuçxáatx kũh nasa susna ũsnite. Aça' komadante vxite' soldauwe'sxtxi uyçxa', Pablo's ikhmeeta'. ");
INSERT INTO pbb_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Txajũ' komadante kũhçxa Pablo's e'z kadenajuk tudkaah. Txã'wẽ yũuçxak pẽjx ¿kimna sa' kĩhga yũu? jĩna. ");
INSERT INTO pbb_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Nawa nasa txã'wẽ jxukaysa sus we'wena ũste', komadante jiyuya' ãjameeçxa', kuartel yatna jxũna u'khaakh. ");
INSERT INTO pbb_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Kuartel yat vxitxte kũhnaçxáa soldauwe'sxa' Pablo's yakhçxatx u'j, txã'wẽ nasa' ikh wẽesa e'ste neeuna: ");
INSERT INTO pbb_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","—Naa piçthẽ'ja's ikhwa'ja' jĩna sus we'wena yuupa'ga. ");
INSERT INTO pbb_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Pablo's kuartel yatte ka'ga'jaçte', txã' na'wẽk we'we griego yuweju komadante's: —¿Maz yuweçxáawa kwe'we'jmeema'g? jĩte', komadante pasçxa': —Idxa' ¿griegowá'ga? ");
INSERT INTO pbb_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Txã'wẽçxa' ¿nyafxíi entey teeçx Egiptojuwe'sx na'wẽ nasa ikhsaçxaçxáatx kuatro mil ãh nasa u'pnimeete pkhakhçxa puii kiisku txãameene'ga? jĩte', ");
INSERT INTO pbb_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Pablo' na'jĩk: —Adxa' judiuth. Cilicia kiwete Tarso çxhab jxtuhthesatewe'sxthu. Aça' naa nasatx we'wewa'ja's ũsune'ga jĩte', ");
INSERT INTO pbb_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","komadante' ũythasku. Naapkaçxha' Pablo' kuartel vxitxte yujuna'wa kuseju sxuuna' yuuwa'ja's pta'sxte', jxuka sxuuna' yuutx, aça' na'wẽk we'we hebreo yuweju: ");
INSERT INTO pbb_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","—Yakhthẽ'j vxite' thẽ'jsawe'sx, mwẽese'jwe adx we'weni's jĩte', ");
INSERT INTO pbb_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","hebreo yuweju we'weni's wẽse'jçxa', wejxtxi sxuuna' yuu. Txajũ' Pablo' na'jĩk: ");
INSERT INTO pbb_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","—Adxa' judiuth, Cilicia kiwete Tarso çxhabte upxsa. Nawa ayte Jerusalente Gamaliel kaapiya'jni walasaath, kwe'sx yaçgawe'sx leya's wala ew nwẽese'jna. Bagaçxtewa Dxusa's ũusuh jxukath selpiina fxi'ze', naa ente i'kwe'sx ma'wẽkwe selpi' txã'wẽy. ");
INSERT INTO pbb_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Adxa' nyafxí' Jesus kaapiya'jni's nwẽese'jsatx ahçeçxa kiikhe'jna vxitetxi' tudçxa jxũna u'th piçthẽ'j petx u'y yã'jçxa karcelte txajxa'. ");
INSERT INTO pbb_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Sacerdote npiiçthẽ'j vxite' judiu nthẽ'jsawe'sx jxukaysa jiita' txã'wẽ Jesukristo yakh fxi'zesatx tudwa'ja's Damaskote yakhthẽ'j judiuwe'sxtxi pta'sxna karta pẽyni's. Txã'wẽ yũuçxath u'j tudçxa ay Jerusalente nuypa'jçxa kastigãyya'. ");
INSERT INTO pbb_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","Nawa adxa' ẽepxãh Damasko çxhabte utxaana pa'jaçpkaçxha', naa dudte ẽe walaju eenak kweeth adx dxi'pte uymeenus. ");
INSERT INTO pbb_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Aça' kiwega weteeçpkaçxha', na'wẽk we'weni pthũuse: Saulo, Saulo, ¿kĩh yũupa'gaga adxa's ahçeçxa pkxuuya' pakwé'? jĩte', ");
INSERT INTO pbb_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","pẽjxthu: Idxa' ¿kimga? Txajũ' na'wẽk pta'sx: Idx na'wẽ ahçeçxa pkxuuya' pakwe'g txãath Jesus Nasarethuwe'sx jĩk. ");
INSERT INTO pbb_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Aça' adx yakh u'jsa' txã'wẽ eena' kweethni's uyçxa wala ũukhtxi. Nawa adxa's we'weni yu'sa' jiyumeeta'. ");
INSERT INTO pbb_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Txajũ' adxa' na'jĩnath we'we: ¿Kĩhga yũu jxthãasu'? jĩte', Kiiteçxa Damaskon me'j, kxte ya'pta'sxina kĩh yũuwa'ja'swa jĩnak jxkaah. ");
INSERT INTO pbb_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Txã'wẽ eena' kweethnijũçxáa uyya' ãjãmeete', adx yakh pi'kxna u'jsawe'sxa' adxa's pu'kisçxa u'jtx Damaskote pa'j. ");
INSERT INTO pbb_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","Kxtea' teeçx piçthẽ'j u'pu'k Ananias yaasesa, Moises leya's jxuka nwẽese'jsa. Txã'wẽ nwẽese'pha'gatx kxte judiuwe'sxa' txãa Ananiasa's wala jxtuhthesa' jĩna we'we'. ");
INSERT INTO pbb_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Txãa Ananiasa' adxa's thegya' pa'jçxa', na'wẽk we'we: Yakhthẽ'j Saulo, idxa' uyya' ãjawa'ja's ki' mpa'ga jĩçpkaçxha', thegçxa' uyya' ãjath. ");
INSERT INTO pbb_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Txajũ' na'wẽk pta'sx: Kwe'sx yaçgawe'sxtxi jxpe'jsa Dxusa' idxa's nyafxiiteyku txhitxh txã'sna nwẽese'jwa'jsa, sa' kĩh pkal yuhwa ji'phmeesa's yafxju uyçxa txajx yuweju we'weni'swa wẽse'jwa'jsa. ");
INSERT INTO pbb_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Ãçxha' idxa' naa kiwete jxukaysa dxi'pte Dxus yuwe's pta'sxya' u'jwene'ga sa' ma'wẽçxahne'ga uyna wẽse'jna yuu txã'snawa pta'sxya'. ");
INSERT INTO pbb_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Sa' ¿kĩjxa'çxáa txakwe wala jxthẽeyuuki'g? Ãçxhíi kiitena'wa yu'te ya'bautisãyçxa Jesukristo's ũusuh jxuka miiyajkx iidx pkal peltunãyni yuukahn jĩnak jxkaah. ");
INSERT INTO pbb_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","Txãa e'su' Jerusalenna ki' sxawedçxa dxuus yatna Dxus yakh puutx we'weya' u'the', Jesusa' adxa's kxte vxyaaçxa, ");
INSERT INTO pbb_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","na'wẽk we'we: Jerusalenuh dudçxáa mkaaseh. Txã'wẽme', idxa' makwe pta'sxtewa nwẽese'jmeetxna jĩte', ");
INSERT INTO pbb_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","na'wẽth pas: Adx txã'wẽ judiuwe'sx pkhaakheni yat-su u'jçxa kxsũ idxna neewe'wesatx karcelte txahna vxitetxi' kxuuphsath. ");
INSERT INTO pbb_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Sa' idxna neewe'wena selpisáa Esteban eea's pkawuuçtewa uynath ũsu', txã'wẽ yũuni ewna sũhna. Sa' ikhsawe'sx atxhtxi thegsath yu' jĩtewa, ");
INSERT INTO pbb_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Jesusa' na'jĩnak jxkaah: Me'jçxáa, adxa' jxu'j kaajxa'wath judiu ji'jmée vxite nasatx pta'sxya' jĩk. ");
INSERT INTO pbb_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Txã'wẽ judiu ji'jmée vxite nasatx pta'sxya' jĩni's wẽse'jçxatx, ki' ũusaçxana na'jĩna sus we'we: —Txãa piçthẽ'ja's ikhteçxáa ewna. Peena yu' ĩtxi fxi'zemeena jĩ'tx. ");
INSERT INTO pbb_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Txã'wẽ sus we'wena, txãawe'sx atxhtxi ẽete wãatahna kiwe's paçxçxa txã'wẽy yuuteçxáa, ");
INSERT INTO pbb_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","komadante' Pablo's kuartel yatte ka'ga'khaahçxa peçxuukwekaakh, txã'wẽ yũuna khaawãsxi'jçxak pẽjxya'wa yu' kĩh yũupa'ga nasa' txã'wẽ wala ũusaçxana ahçetewa jiyuya'. ");
INSERT INTO pbb_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Nawa tuduçpkaçxha', Pablo' na'wẽk we'we kpiitana's: —I'kwe'sxa' romano nasa's peçxujkwete ¿ewmanx? kĩh yuuwetewa jiyumey. ");
INSERT INTO pbb_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Txã'wẽ we'wete', kpiitana' na'wẽk pta'sxya' u'j komadante's: —Na'wẽ yũuni's mpa'yajkx. Txã'wẽme', naa piçthẽ'ja' romano nasa' jĩte', ");
INSERT INTO pbb_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","komadante' Pablo tasxte utxaaçxa pẽjxku: —Isa idxa' ¿romano nasa dxihgá'? jĩna. Aça' Pablo pasçxa': —Txã'wẽ íith jĩk. ");
INSERT INTO pbb_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Txajũ' komadante we'weçxa': —Adxa' wala vxyu dukhçxaçxáa romano nasa yuuna pa'th jĩte', Pablo pasçxa': —Adxa' upxhíi txãa yã'th yu' jĩk. ");
INSERT INTO pbb_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Txajũ' Pablo's peçxuukwewa'jsa' kuçx yuumée nvxihttxi. Aça' komadante yuhwa txã'wẽ romano nasatewa jiyuçxa', wala ũukhku txã'wẽ tudpa'ga. ");
INSERT INTO pbb_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Judiuwe'sxa' kĩh yũupa'gane'ta Pablo's açe' nawa txã'sna jiyu wẽeçxa, kuskuskhẽ' komadante' jxkaakh sacerdote npiiçthẽ'jwe'sx vxite' judiu nthẽ'jsawe'sx jxukaysatx pkhaakhekahn. Txã'wẽ yũuçxak kadenatx khihbçxa txãawe'sx tasxte txah Pablo's. ");
INSERT INTO pbb_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Pablo' sacerdote npiiçthẽ'jwe'sx vxite' judiu nthẽ'jsawe'sx pkhaakhesatx thegçxa', na'wẽk we'we: —Yakhthẽ'jwe'sx, adxa' ãçxpkaçx Dxus dxi'pte jxpubath sũhwa'j yu'sa' ji'phmeeth jĩte', ");
INSERT INTO pbb_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","sacerdote npiiçthẽ'j Ananiasa' Pablo yuwega petxa kaakh pukate ih ũssatx. ");
INSERT INTO pbb_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Aça' Pablo' na'wẽk we'we: —Ãateçxáa ew we'weçxa' ũuste yu' ewmée yaakxpa'ga idxa's Dxus kastigaĩna. Idxa' ley jxkaahniçxá's kxtey yuusath ¿sũju'gá'? Txã'wẽçxa' ¿kĩjxa'ga adxa's petxakaja'? Leya' txã'wẽ jxkaaja'çme' jĩte', ");
INSERT INTO pbb_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","kxte ũssa' na'wẽtx we'we: —Dxusna selpisáa sacerdote npiiçthẽ'ja's txã'wẽ wẽesxuwa'j ji'phmeeg jĩte', ");
INSERT INTO pbb_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Pablo' pasçxa': —Dxusna selpisáa sacerdote npiiçthẽ'jna sũju'çme'ntka. Jiiwaça', txã'wẽ paswa'jmeene'tka yu'. Txã'wẽ yuukahmeníik Dxus librutewa na'wẽ pta'sxi': Iidx çxhabte jxkaahsa's juuna' we'wenu jĩ'k naa pa'ga. ");
INSERT INTO pbb_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Txajũ' kxte pkhaakhesawe'sxa' saduceo vxite' fxariseowe'sx txãawe'sxtewa jiyuçxa', Pablo' na'wẽk sus we'we: —Yakhthẽ'jwe'sx, adxa' fxariseo ji'j, fxariseo íiçxáath. Uusaawe'sxa' ki' ĩtxĩ yuuwa'jsa yuhta' sũhna yaakxsath. Txãa pa'ga yuuçxáa adxa's ewmeesa' jĩna ũsta'. ");
INSERT INTO pbb_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Txã'wẽ we'wete', fxariseo vxite' saduceowe'sx yakh txãawe'sx pwe'sx juuna' we'weçxa puutx txuteetx. ");
INSERT INTO pbb_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","(Saduceowe'sxa' uusaawe'sxa' ki' ĩtxi yuutxna sũju'çmeeta', sa' uute' nasaa ũus vxite' angeleswe'sx txã'wẽsa ũstxna sũju'çwameeta', naapkaçxha' fxariseowe'sxa' txã'wẽsa jxuka ũstxna sũju'tx, txãasatx puutx txutee.) ");
INSERT INTO pbb_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Txã'wẽ yũuçxa txãawe'sx pwe'sx wala sustxi ũusçxa we'wena. Aça' fxariseowe'sx ju'gusa ley kaapiya'jsawe'sx maaíi yu' kiiteçxa na'wẽtx we'we: —Naa piçthẽ'ja' ewmée yũusame'. Meeçxa' Dxus angel wá' yu', meeçxa' uusáa ũus wá' txã'wẽ vxyaa, nawa jiimeeçxa' kuçx we'wemeeyuga. Txã'wẽme', jiimeeçxa' Dxusa's wáa açewe'wesa yu'nja'w jĩ'tx. ");
INSERT INTO pbb_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Seena' ũusaçxana suste', komadante' Pablo's ikhewáatxna sũhna ũukhçxa soldautx yuukaahçxa, Pablo's kutxi'khaakh pkhaakhesa ksxavxyu kuartel yatnay jxũna u'khan. ");
INSERT INTO pbb_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Txãa kuste', Jesukristo' Pablo's vxyaaçxa na'wẽk we'we: —Pablo, ũukhnu. Ay Jerusalente na'wẽg we'we adxna pta'sxna, txã'wẽy we'wewa'j ji'phgu Romatewa jĩk. ");
INSERT INTO pbb_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Kuskuskhẽ' judiuwe'sx maaíi yu' Pablo's ikh wẽesa na'wẽtx puutx we'we: Pablo's ikhmeeçxa yu' kĩh yuhwa ũ'me'nja'w jĩna. ");
INSERT INTO pbb_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Txã'wẽ Pablo's ikhmeeçxa yu' kĩh yuhwa ũ'ya'mée puutx we'wesa' kuarenta piçthẽ'j jxthaakwetx yu'. ");
INSERT INTO pbb_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Txã'wẽ yũuwa'ja's puutx we'weçxatx u'j sacerdote npiiçthẽ'j vxite' judiu nthẽ'jsawe'sx tasxna na'jĩna pta'sxya': —Kwe'sxa' Pablo's ikhmeeçxa yu' kĩh yuhwa ũ'me'nja'w jĩnatha'w puutx we'we Dxus dxi'pte. ");
INSERT INTO pbb_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Aça' ãçxha' i'kwe'sx nthẽ'jsawe'sx jxuka pkhaakheçxa mpẽjxwe komadante's: Kuskusa' Pablo's mkaah kwe'sx tasxte, txajx yuwe's jwee ew paapẽjx ya'watha'w jĩna. Naapkaçxha' kwe'sxa' ayte pa'jmeyna ikhya' dxi'the yupu'nja'w jĩ'tx. ");
INSERT INTO pbb_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Txã'wẽ puutx we'weçte Pablo npe'sx nçxi'k jiyuçxa', Pablo's pta'sxya' u'kh kuartel yatna. ");
INSERT INTO pbb_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Aça' Pablo' jiyuçxa', teeçx kpiitana's pa'yaçxa na'wẽk we'we: —Naa luuçxa's meen pe'jna me'j komadante tasxna, txãa yakh puutx we'wewa'j ji'pha' jĩte', ");
INSERT INTO pbb_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","kpiitana' luuçxa's pe'jçxa komadante tasxte kũhçxa pta'sxku: —Karcelte ũssa Pablo' adxa's pa'yaçxa naa luuçxa's pe'jna kaakh, ayte idx yakh puutx we'wewa'j ji'pha' jĩte', ");
INSERT INTO pbb_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","komadante' luuçxa's kusete pu'kisna u'jçxa paaçte pẽjxku: —¿Kĩhga we'we wẽje'? jĩte', ");
INSERT INTO pbb_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","luuçxa' pta'sxku: —Judiuwe'sxa' na'wẽtx puutx we'we: Kuskusa' idxa's pẽyi'nja'w Pablo's kaakhan, judiu nthẽ'jsawe'sx tasxna yuuwe's jwee ew pẽjxya'watha'w jĩçxa. ");
INSERT INTO pbb_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Nawa txã'wẽ dxihna sũhçxa Pablo's kaahmeene'ga. Txã'wẽme', piçthẽ'j kuarenta jxthaakwesa Pablo's ikhmeeçxa yu' kĩh yuhwa ũ'me'nja'w jĩna Dxus dxi'pte puutx we'weçxa dxi'the yupna ũsta'. Sa' idx ma'jĩtewa txã'sçxáan ũythasna ũsta' jĩte', ");
INSERT INTO pbb_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","komadante' luuçxa's na'jĩna we'weçxak kaah: —Komadante's pta'sxthu jĩna kim yuhnawa pta'sxmeene'ga jĩçxa. ");
INSERT INTO pbb_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Txajũ' komadante' e'z kpiitantxi pa'yaçxa Cesarea çxhabna u'jya' pheu'khaakh. Doscientos soldau çxidaçxáa u'jwetxna, jibatewe'sx setenta, vxite' lansa ji'phsa doscientos, sa' ayjxu kasejetxna kus las nwewete. ");
INSERT INTO pbb_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Sa' txã'wẽy Pablo a'jwa'j jibawa pheu'khaakh, ne'jwe'sx Fxelix tasxte ikhmée ew dukhkahn. ");
INSERT INTO pbb_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Txãawe'sx yakh karta kaakh na'wẽ fxi'jçxa: ");
INSERT INTO pbb_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","Klaudio Lisias fxi'jaçthu ne'jwe'sx Fxelixa's weçxana. ");
INSERT INTO pbb_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Naa piçthẽ'ja's judiuwe'sxa' karcelte txahçxa ikhya'watx yu'. Nawa romano nasatewa jiyuçxa', adxa' soldau yakh u'jçxa nwe'weth. ");
INSERT INTO pbb_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","¿Kĩh yũupa'gaki'tx txã'wẽ açe'? sũhçxa jxũna u'th judiuwe'sx nthẽ'jsawe'sx tasxna. ");
INSERT INTO pbb_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Aça' txãawe'sx ley pa'gaçxáata txã'wẽ açe', nawa ikhya' yu' ãjawa'jmeek yu' sa' karcelte txajxa'wa ãjawa'jme'. ");
INSERT INTO pbb_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Nawa Pablo's ikhya' yuuçxáa jĩna puutx we'weçxa yupna ũsta' jĩni's jiyuth. Txãasa iidx tasxte kajaçthu. Pablo's açesatxwa we'weth kĩh yũupa'gane'kwe açe' nawa ne'jwe'sx tasxte u'jçxa puutx we'wene'kwe jĩth. Txã'wẽçxáath idxa's pta'sxi' jĩnak fxi'j. ");
INSERT INTO pbb_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Txajũ' soldauwe'sxtxi txã'wẽ jxkaajxã'the', Pablo's pe'jna'wa kusçxáa u'jtx Antípatris çxhabna. ");
INSERT INTO pbb_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Kuskuskhẽ' soldau çxidaçxáa u'jsa' ki' sxawedtxi kuartel yatna, naapkaçxha' jibatewe'sxa' u'jtx Pablo yakh. ");
INSERT INTO pbb_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Cesarea çxhabte pa'jçxa', karta's ũsna'wa Pablonawa dukhtxi ne'jwe'sxa's. ");
INSERT INTO pbb_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Txajũ' ne'jwe'sxa' karta's lẽeyçxa' pẽjxku Pablo's: ¿Majũwe'sxga? jĩna. Sa' Ciliciajũwe'sxtewa jiyuçxa', ");
INSERT INTO pbb_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","na'wẽk we'we: —Iidx yuuwe's jiyu'nja idxna açesawe'sx pãatxhĩ'khya' pa'the jĩk. Txajũ' Pablo's Herodes txaahni yatte kxuuphku thegwa'jsa txahçxa. ");
INSERT INTO pbb_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Tahç ente' sacerdote npiiçthẽ'j Ananiasa' pa'kh Cesarea çxhabte judiu nthẽ'jsawe'sx yã'jçxa, sa' teeçx yuwee pu'çxsa Tértulo yaasesa'sku pe'jçxa pa'j. Txãawe'sxa' utxaatx ne'jwe'sx tasxte Pablo' ewmeesa' jĩna pãatxhĩ'khya'. ");
INSERT INTO pbb_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Txajũ' Pablo's nuykũhte', Tértulo' Fxelixa's pta'sxku: —Weçx u'pu'ga, ne'jwe'sx. Iidx jxkaahnite, mteewa wẽt fxi'zena ũstha'w. ");
INSERT INTO pbb_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Mteewa txã'wẽçxaçxáa wẽt fxi'zena ũstha'w, Fxelix idx txã'wẽ ew yũupa'ga. Txãasatha'w wala weçxá'. ");
INSERT INTO pbb_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Nawa idxa's jwee yu' en kaavxitu'jya'wameeth, dudte meen mwẽese'j kwe'sx we'weni's. ");
INSERT INTO pbb_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Naa piçthẽ'ja' iiméh seena' ewmeesatewa kwe'sxa' kpajkxtha'w. Maa kiwesuwa jxuka judiuwe'sxtxi txuhdena puii kiisna ũsa'. Sa' txãaíi Nasarethuwe'sxa's nwẽese'jsa npiiçthẽ'ja'. ");
INSERT INTO pbb_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Dxuus yatte yuhwa nasa pkalsatx ka'ga'jya'wak yu' kazx vxitna. Txãa pa'ga kwe'sxa' tudtha'w, kwe'sx ley ma'wẽ jxkaathe' kxtey yuuya'. ");
INSERT INTO pbb_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Nawa komadante Lisias kwe'sx yakh ja'da wala juuna' kũhçxa kusa'kh, ");
INSERT INTO pbb_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","sa' açesawe'sxa' ne'jwe'sx tasxte pãatxhĩ'khya' u'jwetxna jĩnak jxkaah. Kwe'sx we'weni' ĩsxiinimée jxuka isatewa jiyuya' idx yuu mpẽjx naa piçthẽ'ja's jĩnak we'we. ");
INSERT INTO pbb_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Txajũ' judiuwe'sx kxte ih ũssawa txã' jxuka isasa yuja' jĩna we'wete', ");
INSERT INTO pbb_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","ne'jwe'sxa' kuseju pta'sxku Pablo's we'wekahn. Aça' Pablo' na'wẽk we'we: —Adxa' jiith idxa' wala kuh anxu yã'j kwe'sx kiwete jxkaahna ũsgu. Txãa pa'ga adxa' iidx dxi'pte ũukhmée pasya'wath adx ma'wẽsaçxawa. ");
INSERT INTO pbb_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Idx yuu mpaapẽjx txãawe'sx we'weni' isa dxihtewa jiyuya'. Dxusa's Jerusalente neewe'weya' adx pa'jni doce ençxáa yuuça'. ");
INSERT INTO pbb_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Adxa' txãa doce ensu' dxuus yatte nasatx kaapui'jna judiuwe'sx pkhaakheni yat-su çxhabte msuu yuhwa txã'wẽ yũuna ũsu'çmeeth. ");
INSERT INTO pbb_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Aça' ewmée yũunisa' naata' jĩna ãate kaavxya'ja'jya' yu' kim yuhwa ãjameetxna naa nasa'. ");
INSERT INTO pbb_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Nawa ãateth pta'sxi' Dxus tasxte pa'jwa'j dxi'ja's ãçxh u'se kaajiyu'jnisa' ĩsxiinisa' jĩ'tx txã'snath nwẽese'je' kwe'sx yaçgawe'sxtxi jxpe'jsa Dxusa's selpiina. Sa' txã'wẽ Dxus jxkaahni leyte fxi'jni vxite' Dxus yuwe pta'sxsawe'sx fxi'jnitx jxukath kxtey nwẽese'je'. ");
INSERT INTO pbb_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Txãawe'sxwa ma'wẽne'ta Dxusa's nwẽese'jna yaaki' txã'wẽyçxáath adxwa nwẽese'jna yaaki'. Uusaawe'sxa' ki' ĩtxi yuutxna ewsa ma'tx yuu meeçxa' ewmeesa ma'tx yuu nawa ja'daçxah sũhnath yaaki'. ");
INSERT INTO pbb_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Txãasath Dxus dxi'pte vxite' piçthẽ'jwe'sx dxi'ptewa yuuwemée fxi'zewa'ja's pa'pçxu'. ");
INSERT INTO pbb_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","Adxa' vxite kiwesu maz anxu pekũhna u'juçxa', adx kiwen u'th judiuwe'sxtxi vxyu peesya' kaahnitx dukhna Dxus ofxreda'swa ũsya'. ");
INSERT INTO pbb_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Adxa' txã'wẽ yũuna ley jxkaahni'swa ki'sna jxã'jçxa dxuus yatte ũspkaçxha', judiuwe'sx Asia kiwejuwe'sx pa'jçxa dxuus yatte uytxi. Nawa nasatx kĩh yuhwa kaapui'jna ũsu'çmeeth. ");
INSERT INTO pbb_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Txã'wẽ uysaawe'sx ayte pãatxhĩ'khya' yuuwa'j ji'phta', adx ewmée yũuna ũstewa uyçxa'. ");
INSERT INTO pbb_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Meeçxa' komadante pkhakhte judiu nthẽ'jsawe'sx vxite' sacerdote npiiçthẽ'jwe'sx kxte ũssa i'kwe'sxçxáawa adx ewmée yũuni's uywá'kwe na' mpeeta'sxwe. ");
INSERT INTO pbb_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Adxa' kxte ũsçxa', Uusaawe'sxa' ki' ĩtxi yuutxna jĩnaçxáath we'we txã'sna wá'kwe ewméek yuu sũju'kx jĩk. ");
INSERT INTO pbb_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Fxelixa's ew yã'kh pta'sxni yu', txãasak txã'wẽçxáa wẽse'jçxaçxáa: —Komadante Lisias pa'the, txãa yuwe's pheu'ju'nja jĩçxa nvxiht. ");
INSERT INTO pbb_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Txajũ' Fxelixa' kpiitana's jxkaakh: —Pablo's txhweetenu. Nawa jwee jxthaakwe juuna' yũumée miipe'j, sa' txajx namikuwe'sx yakh puutx we'wewa'ja'swa mes jĩk. ");
INSERT INTO pbb_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Maz en skhẽwniite', Fxelixa' txajx nyu Drusila yakh ki' kũhçxa Pablo's pa'ya kaakh, Jesukristo pta'sxni's we'wekahn. Txãa u'ya' judiuk yu'. ");
INSERT INTO pbb_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Aça' Pablo' pta'sxku Dxus dxi'pte ew fxi'zewa'ja', sa' peekx kakwe's ewmée yũuna jxpe'jwa'jme'. Txã'wẽme', nmeh ente' Dxusa' kastigaĩna jĩna we'wete', Fxelixa' wala ũukhçxa na'wẽk we'we: —Ãçxhíi yu' txã'wẽçxáa mpeeta'sx. Vxite ente adx en ji'phuçxa ki' pa'ya'nja jĩk. ");
INSERT INTO pbb_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Pablo' vxyu dukhe'nja txhwetekahn jĩwáana sũhçxak txã'wẽ maz uswa pa'ya Fxelixa' txãa yakh puutx we'weya'. ");
INSERT INTO pbb_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Txã'wẽ e'z anxupkaçx Pablo's karcelte jxpe'jna ũsçxaçxáa Fxelixa' ne'jwe'sx kasejk, aça' vxite ne'jwe'sx Porcio Fxestok u'ka. Nawa Fxelixa' judiuwe'sx yaaçeni fxi'ze wẽemeeçxa, Pablo's karcelte nvxihtku. ");
INSERT INTO pbb_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Txajũ' Fxesto' Cesarea çxhabte ne'jwe'sx u'kaçxa', tekh ente' Jerusalenna u'kh. ");
INSERT INTO pbb_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Kxte' sacerdote npiiçthẽ'jwe'sx vxite' judiu jxtuhthesawe'sxa' utxaatx Pablo' ewmeesa' jĩna pãatxhĩ'khya'. ");
INSERT INTO pbb_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","Sa' Pablo's pe'jya' mkaah Jerusalenna yuukahn jĩnatx pẽjx. Txãawe'sx yu' dxi'the ikhya' sũhçxatx txã'wẽ pẽjx. ");
INSERT INTO pbb_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Nawa Fxesto pasçxa': —Pablo' Cesareate preesu ũsa'. Aça' maz enteçxáa adxa' txãa çxhabnaíi u'jweçthu. ");
INSERT INTO pbb_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Txãasath na'jĩ': Txãa piçthẽ'j ewmée yũuni's pãatxhĩ'khwa'j ji'phçxa', i'kwe'sx jxtuhthesawe'sxa' adx yakh yuwetxna Cesarea çxhabna jĩk. ");
INSERT INTO pbb_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Fxesto' Jerusalente oçxo en jxthaakwe ũsçxaçxáa ki' sxawedku Cesarea çxhabna. Sa' kuskuskhẽ' yuwe paapẽyni yatte u'kaçxa kaçxna'wa, Pablo's yuukaakh. ");
INSERT INTO pbb_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Sa' kũjuçpkaçxha', judiuwe'sx Jerusalenuh pa'jsawa utxaatx kĩhtewa seena' ewmeesa' jĩna pãatxhĩ'khna. Nawa isasa yuja' jĩna ãate kaavxya'ja'jya' yu' ãjameeta'. ");
INSERT INTO pbb_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Txajũ' Pablo' na'wẽk pas: —Adxa' kĩhte yuhwa yuuwemeeth. Judiuwe'sx ley, Dxus yatna, Romate jxkaahsa Cesar maate yuhwa yuuwemeeth jĩte', ");
INSERT INTO pbb_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Fxesto' judiuwe'sx yakh ewte neeyũu wẽeçxa na'wẽk pẽjx Pablo's: —¿Jerusalenna u'jwẽega' iidx yuwe's kxte pheu'khan? jĩte', ");
INSERT INTO pbb_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Pablo pasçxa': —Adx yuwe's pheu'jwa'jsa tasxte yã'j ũsthu, Cesar ki'pni iidx tasxte. Adxa' judiuwe'sx yakh kĩhte yuhwa yuuwemeetewa idxa' ew jiig. ");
INSERT INTO pbb_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Meeçxa' adx uuwa'the ãhwáane'tka yuuwe yuu aça' txã'wẽte yu' uuwa'ja's wa'lme'nja. Nawa pãatxhĩ'khnisa kĩh yuhwa isameete yu', kim yuhwa pãatxhĩ'khsa kusete adxa's dukhya' ãjameena. Wejxwa Cesar paapẽyni wejx ewna jĩte', ");
INSERT INTO pbb_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Fxesto' vxite npiiçthẽ'jwe'sx yakh puutx we'weçxa', na'wẽk pta'sx Pablo's: —Cesar paapẽyni wejx ewna jĩ'g na' txajx tasxte pa'j u'jwene'ga jĩk. ");
INSERT INTO pbb_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Txajũ' maz en skhẽwniite', jxkaahsa Agripa vxite' Berenice yakh Cesarea çxhabte pa'jtx Fxesto's weçxaya'. ");
INSERT INTO pbb_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Kxte kuh entxi ũsu', aça' Fxesto' jxkaahsa's pta'sxku Pablo yuwe's: —Ayte teeçx piçthẽ'j preesu ũsa', Fxelix nvxiitni. ");
INSERT INTO pbb_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Adx Jerusalente ũste', sacerdote npiiçthẽ'jwe'sx vxite' judiu nthẽ'jsawe'sx pãatxhĩ'khtxi txãa piçthẽ'ja's ewmeete nvxiitkahn. ");
INSERT INTO pbb_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Aça' adxa' pta'sxthu: Romanowe'sx leya' maa yuhnawa ikh kaja'çme', pãatxhĩ'khsa yuuwesa yakh kaapdxi'pu'jçxa kim yuuwetewa jiyumey yu'. ");
INSERT INTO pbb_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Txajíi adxa' jxthẽeyuumée pãatxhĩ'khsawe'sx pa'jaçpkaçxha', kuskuskhẽ' yuwe paapẽyni yatte u'kana'wa txãa piçthẽ'ja's yuukaath. ");
INSERT INTO pbb_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Sa' ¿kĩh yũupa'ga yuuwekx? sũhna ũythasnath u'pu', nawa pãatxhĩ'khya' utxasaawe'sxa' ma'wẽ yuhwa ewmeete nvxiht-ya' ãjawa'jmeesaçxáanatx we'we. ");
INSERT INTO pbb_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Txãa piçthẽ'ja's açesawe'sxa' txãawe'sx Dxusa's neewe'wena fxi'zeni vxite' teeçx piçthẽ'j Jesus yaasesa uuçxawa ki' ĩtxi yuuk jĩna Pablo pta'sxni'sçxáatx we'we. ");
INSERT INTO pbb_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Txãa yuwe's adxa' ma'wẽ pheu'jya'wa ãjameeçxa', Pablo's pẽjxthu: ¿Jerusalenna u'j wẽega' kxte iidx yuwe's pheu'khan? jĩna. ");
INSERT INTO pbb_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Nawa txãa we'weçxa': Cesar paapẽyni wejx ewna jĩk, aça' txã'wẽ yã'the', aytee preesu ũsune'ga Cesar tasxte adx kaahpkaçx jĩnath we'we. ");
INSERT INTO pbb_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Txajũ' Agripa' na'wẽk we'we Fxesto's: —Txã'wẽyã'the', wẽse'je'nja txãa piçthẽ'j we'weni's jĩte', Fxesto pasçxa': —Kuskusíi wẽse'jene'ga jĩk. ");
INSERT INTO pbb_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Kuskuskhẽ' jxkaahsa Agripa vxite' Berenice vxite' soldau npiiçthẽ'jwe'sx vxite' çxhabte jxtuhthesa txãawe'sx yakh seena' zhiçxkwe susna u'kana kũhtx Fxesto u'pnite. Naapkaçxha' Pablo's yuu kaahçxa', ");
INSERT INTO pbb_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Fxesto' na'wẽk we'we: —Jxkaahsa Agripa vxite' ayte pkhaakhena kwe'sx yakh ũssawe'sx ksxavxyte txajaçthu naa piçthẽ'ja's. Judiuwe'sx maazkuẽesawa naa piçthẽ'ja's açewe'we'tx Jerusalente vxite' aytewa, sa' ikhteçxáa ewna jĩna nestxi yu'. ");
INSERT INTO pbb_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Nawa txã'wẽ ikhkahnwa kĩhtewa yuuwemeena'k thegu'. Nawa txãaíik Cesar paapẽyni wejx ewna jĩ'. Aça' txajx tasxna kaja'nja sũju'th. ");
INSERT INTO pbb_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Nawa kĩhte yuuwetewa txã'sna pta'sxna jxkaahsa's fxi'jwa'j yu' uymeeth. Txãasa ãçxha' jxkaahsa Agripa iidx tasxte txajaçthu, vxite' jxukaysa dxi'pte, aça' idx paapẽjxçxa kĩhte yuuwetewa kpajkxçxa pta'sxte adxa' eça's fxi'jçxa kaja'nja. ");
INSERT INTO pbb_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Txã'wẽme', kxulna'k thegu' preesu kaahçxawa yuuwe yuuni's pta'sxmeete '. ");
INSERT INTO pbb_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Txajũ' Agripa' na'wẽk Pablo's we'we: —Idx kĩh yũuna fxi'zeçxawa mpeeta'sx jĩte', Pablo' kuse's kiisçxa na'wẽk pta'sx: ");
INSERT INTO pbb_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","—Judiuwe'sxa' adxa's ewmeesa' jĩnatx pãatxhĩ'khe' txã'sa' jxkaahsa Agripa iidx dxi'pte ãate pta'sxwa'ja's ji'phuçxa' wala weçxa'th. ");
INSERT INTO pbb_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Idxa' jxuka ew jiig kwe'sx judiu ji'j fxi'zeni vxite' na'wẽ fxiyfxiyçxah yajkxçxa puutx we'we'tha'w txã'sna. Txãasa wejx wa'lmée mwẽese'j. ");
INSERT INTO pbb_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","Adx le'çxkuẽjũjx ma'wẽne'tka fxi'ze adx kiwete vxite' Jerusalente txã'sa' judiuwe'sx jxukaysa jiita'. ");
INSERT INTO pbb_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Fxariseowe'sxa' seena' juuna' jxkaaja'tx Dxus leya's jxuka kxtey yuukahn adxa' txãatewe'sxthu yu' piçtakxtey, aça' txãawe'sxa' jiita' na' txã'sa' pta'sxya' ãjatxna wa'lmeeçxa yu'. ");
INSERT INTO pbb_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Dxusa' kwe'sx yaçgawe'sx yakh puutx we'weçxa uusaawe'sxtxi ki' ĩtxĩ vxit-ya' neeyũuk txã'sa' kxtey yuuna sũhnath fxi'ze', naa pa'ga yuuçxáatx paapẽjxya' ayte nuypa'j. ");
INSERT INTO pbb_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Jxkaahsa Agripa mjiyu: Israelwe'sx docesate ji'j jxukaysatx ki' ĩtxi yuuwa'ja's ũythasu', txãasatx een isa petx kus Dxusa's selpi'. Txã'wẽ yũuwa'ja's ũythaspa'ga yuuçxáatx judiuwe'sx adxa's ewmeesa' jĩçxa açe'. ");
INSERT INTO pbb_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Dxusa' txã'wẽ uusaawe'sxtxi ĩtxi vxituna ¿sũju'çmeekwe' wakx i'kwe'sxwa? ");
INSERT INTO pbb_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","Adxa' nyafxíia' Jesus Nasarethuwe'sxa's ahçeçxa kĩhwa yu'nja sũhçxa, ");
INSERT INTO pbb_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Jerusalente sacerdote npiiçthẽ'jwe'sx jxkaathe', Jesus kaapiya'jni's nwẽese'jsawe'sx maazkuẽesatxwa karcelte txahth. Sa' ikheçte uyçxa', ew yuh yuuçta' sũhnath fxi'ze'. ");
INSERT INTO pbb_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Maazkuẽe uswa iipkxuuth, Jesus yase's açewe'wekahn. Msuuwa judiuwe'sx pkhaakheni yat-su txã'wẽçxaçxáath yuu. Sa' seena' pxũuskwe yuute', vxite kiwesuwa u'th, txã'wẽy ahçeçxa pkxuuya'. ");
INSERT INTO pbb_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","Txã'wẽ yũuya' sũhçxa, Damasko dxi'j u'jweçthu yu', sacerdote npiiçthẽ'jwe'sx kaahni. ");
INSERT INTO pbb_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Nawa jxkaahsa mwẽese'j: dxi'the u'jweçte ẽepxãh yuuçpkaçxha', sekte jxthaakwe eena'sa ẽejũ kweethku adx vxite' pi'kxna yuusáa jxukaysatx. ");
INSERT INTO pbb_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Txajũ' jxukaysa wetetha'w, naapkaçxha' adxa' wẽse'th hebreo yuweju na'wẽ we'weni's: Saulo, Saulo, ¿kĩjxa'ga adxa's ahçeçxa pkxuuya' pakwé'? Idxa' peekíiçxáa ya'kpã'yuuwa'ja's pakwena ũsgu jĩte', ");
INSERT INTO pbb_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","pẽjxthu: ¿Idxa' kimga? jĩte', pta'sxku: Adxa' Jesusthu, idx na'wẽ ahçeçxa pkxuuya' pakwe'g txãath. ");
INSERT INTO pbb_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Nawa ãçxha' mkiite. Ãçxh na'wẽ vxyaath sa' vxite entewa vxya'nja, aça' txã'wẽk vxyaa jĩna mteewa pta'sxya' u'jwene'ga adxna selpiina. ");
INSERT INTO pbb_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Idxa's nwe'we'nja judiuwe'sx kuseju, sa' judiu ji'jmée vxite nasa kiwesu kajaçthu kxsũwa nwe'we'nja. ");
INSERT INTO pbb_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","Txãawe'sx tasxsu kajaçthu, aça' idxa' txãawe'sx yafxtxi phaadene'ga, peena yu' çxhi'dxte fxi'zemée eena'sa's uykahn, sa' eçxthẽ'j kusete fxi'zemée Dxus yakh fxi'zekahn. Adxa's jxpa'gasa' txãawe'sx pkaltxi peltunãyni neeyũuçxa cielute ũswa'ja's jxpa'gatxna Dxus txhitxhnisawe'sx yakh ja'daçxah jĩk adxa's. ");
INSERT INTO pbb_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","Agripa, idxa'sthu pta'sxi': Txã'wẽ vxyaaçxa we'weni's wa'lmée kxtey nwẽese'jçxa ");
INSERT INTO pbb_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Damaskote ũssawe'sx khuẽ'ytxi pta'sxthu Dxus yuwe's, e'su' Jerusalente, vxite' Judea kiwesu jxuka. Sa' judiu ji'jmée vxite nasatxwa pi'kxthu, pkaltxi nvxihtçxa Dxusa's pakweçxa ew yũuna mfxi'zewe jĩna. ");
INSERT INTO pbb_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Txã'wẽ yũupa'gatx judiuwe'sxa' dxuus yatte adxa's tudçxa ikh wẽe. ");
INSERT INTO pbb_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Nawa Dxus pu'çxte', ãçxpkaçx Dxus yuwe's le'çxkwe yuhwa jxpubameeth pta'sxna fxi'ze' jxtuhthesa ma'tx yuu ma'wẽsatxwa jxukaysatx. Sa' Dxus yuwe pta'sxsawe'sx vxite' Moises pta'sxni txãaju bagaçxte yuhwa fxiy yu' pta'sxi'çmeeth. ");
INSERT INTO pbb_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Txãawe'sxa' na'wẽtx pta'sx: Dxus tasxuh yuusa Kristo' wala pxthaa yuuçxa uuçxawa ki' txãa khuẽ'y ĩtxĩ yuuna, sa' eena'te fxi'zewa'ja's pta'sxina kwe'sx ji'jtx txã'wẽy vxite kiweju nasatxwa jĩnatx pta'sx. Txã'wẽyçxáath adxwa pta'sxi'. ");
INSERT INTO pbb_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Pablo txã'wẽ we'wete', Fxesto' na'jĩnak sus we'we: —Pablo, luuku yuunig. Jwee wala piyaçxane'ga txã'wẽ luuku yuu jĩte', ");
INSERT INTO pbb_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Pablo pasçxa': —Ne'jwe'sx Fxesto idxa' mjiyu: Adxa' luukumeeçxa íith ũus yajkxçxa jxpubamée isasaçxáana pta'sxi'. ");
INSERT INTO pbb_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Txãa yuwe's jxkaahsa Agripa ayte u'pa' txãawa ew jiia'. Txãa pa'gath adxa' thaamemée pta'sxi' txajx dxi'pte. Naa yuwe' paaçte sũthçxa we'wenisame'. Txãa pa'ga jxkaahsawa txãa yuwe's ew jiina sũju'th. ");
INSERT INTO pbb_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","¿Dxus yuwe pta'sxsawe'sx we'weni's ew jiiyuhmeegá' wakx, jxkaahsa Agripa? Idxa' jiiyuhne'ga sũju'th jĩte', ");
INSERT INTO pbb_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Agripa' na'wẽk we'we: —Adxa's Kristo ju'gu vxit-ya' le'çxkuẽeg pejíi jĩte', ");
INSERT INTO pbb_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Pablo we'weçxa': —Le'çxkuẽe ma'k pejíi meeçxa' wala ma'k pejíi nawa idxçxáamée, ayte ãçxh wẽse'jna ũsta' txãawe'sx jxukaysatxku Kristo ju'gu yuu jxthãasu' Dxusa', adxwa ma'wẽtka Kristo ju'gu yuu txã'wẽy, nawa kadenaju tudnimée. ");
INSERT INTO pbb_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Pablo txã'wẽ we'wete', jxukaysa kiitetx, jxkaahsa, ne'jwe'sx, Berenice kxte ih pa'jsa jxuka. ");
INSERT INTO pbb_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Sa' fxiitx txuteena u'j, na'jĩna puutx we'weya' txãawe'sx pwe'sx: —Naa piçthẽ'ja' kĩh yuhwa yuuwemeesa' ikhkahn yuuwa. Sa' karcelteçxáa yuhwa ũswa'j ji'phme' jĩçxa', ");
INSERT INTO pbb_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Agripa' na'wẽk we'we Fxesto's: —Txã'wẽ txãaíi Cesar paapẽyni wejx ewna jĩmeewaça', naa piçthẽ'ja's txhweteya' ewna jĩk. ");
INSERT INTO pbb_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Italia kiwen kwe'sxtxi kaajxa' puutx we'weyã'jçxa', Pablo vxite preesu yã'jçxa dukhtxi Batalxón Augusto yaasesate kpiitan Julio kusete. ");
INSERT INTO pbb_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Txajũ' Adramitio çxhabte barko Asia kiwen u'jsate khẽetha'w, aça' Aristarkowa yuwe'k, Macedonia kiwete Tesalónika çxhabtewe'sx. ");
INSERT INTO pbb_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Kuskuskhẽ' Sidón çxhabte pa'tha'w. Aça' kpiitan Julio' Pablo's namiku yat-suk pa'jya' kaah txãawe'sx sã'jĩkahn. Txãa kpiitana' Pablo yakh wala ewsa yu'k, txãasak txã'wẽ yũu. ");
INSERT INTO pbb_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Sidón çxhabuh kasehçxa', Çxipre kiwe's jebu ju'gutha'w nvxihtna khẽw, wejxa yuppa'ga. ");
INSERT INTO pbb_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Txajũ' Cilicia Panfxilia kiwesu utxa skhẽwna u'jçxa, Lisia kiwete Mira çxhabtetha'w pa'j. ");
INSERT INTO pbb_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Kxtea' soldau kpiitana' teeçx barko Alejadriajuwe'sx Italia kiwen u'jsa'sku uy. Sa' kwe'sxtxi kxtek kaateka'j txajũ ki' u'jya'. ");
INSERT INTO pbb_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Nawa txã'wẽ wejxa yupna ũste', wala kuh en tuudkuẽçxah u'jçxa, wala thẽy pa'tha'w Gnido çxhab dxi'pte. Txajũ u'jçxa', Salmon kiwee dxi'psutha'w skhẽw, Kreta kiwesu ta'guna. ");
INSERT INTO pbb_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Sa' txãa kiwe pukasu wala thẽy u'jçxa, teeçx ahte pa'tha'w Bwenos Pwertos yaasesate. Txã' Lasea çxhab utxatek neeyũ'. ");
INSERT INTO pbb_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Txã'wẽ thẽy u'jçxa wala en ivxiitpa'ga, nus pa'jwa'j en utxaak ĩkhte u'jwa'j seena' ũukhũukhsa. Txãa pa'gak Pablo' yu'kxpeh ");
INSERT INTO pbb_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","na'jĩna: —Jxukaysa mwẽese'jwe, kwe'sx u'jwa'ja' wala ũukhũukha'. Barko petx karga vxituna, aça' kwe'sxwa uuwa'ja's ji'phuwá'nja'w. ");
INSERT INTO pbb_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Txã'jĩtewa, soldau kpiitana' Pablo's nwẽese'jmée barko namu vxite' barko thegsawe'sx we'weniçxá'sku nwẽese'j. ");
INSERT INTO pbb_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Kxte çxhaba' nus ente ũswa'j ewmeek yu'. Txãa pa'gatx jxukaysa u'jya' yajkx Kreta kiwete Fxenice çxhabte pa'jçxa nus ena's kxte yu'skhẽwya' sũhçxa, Fxenice çxhabte' nus ente ũswa'j ũukhũukh meek yu' naa pa'ga. ");
INSERT INTO pbb_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Bwenos Pwertos yaasesajũ kasejeçte yu', wejkuẽçxáak wejxana ũsu', aça' Fxenice çxhabte pa'jya' ãjawá'nja'w sũhçxa u'jtx Kreta kiwe pukasu tuudkuẽçxah. ");
INSERT INTO pbb_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Nawa wejkuẽ u'jweçpkaçxha', wejxaa wala kwe'sx u'jwa'j dxi'puh sẽhçxa barko's yupku. ");
INSERT INTO pbb_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Sa' txajũyã'ja' ma'wẽwa jxũna u'kh. Aça' barko's kaajxa' ãjameeyã'jçxa', kuçx yuumeetha'w wejxa ma'wẽwa jxũna u'khan. ");
INSERT INTO pbb_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Ĩkh pxãhte kiwe le'çxkuẽsa Klauda yaasesa e'ssutha'w skhẽw, kxsũa' wejxa txakwe çxhãçxhameek ũs yu'. Aça' barko le'çxkuẽ jxũçxa u'jnisa's wala thẽyçxáawa kaateka'jya' ãjãtha'w barko walate. ");
INSERT INTO pbb_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Txajũ' barko wala's lasu walaju pxãjũjx tudtha'w suweekahmen. Sa' txitx wala Sirte yaasesate wáa waçuya' u'jwena sũhna ũukhçxa, ẽete tela wala's spajkxtxi wejxa ma'wẽwa barko's jxũna u'khan. ");
INSERT INTO pbb_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Txã'wẽ wejxa seena' çxhãçxha ũste', kuskuskhẽ' karga's ĩkhkhẽ pũsxya' takhtxi. ");
INSERT INTO pbb_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Aça' tekh en yuuçte', kwe'sxíiwa ĩkhkhẽ pũsxya' pu'çxtha'w barko ẽseekahn. ");
INSERT INTO pbb_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Txã'wẽ wejxa seena' yuuna ũste', sek, estrelxa, kĩh yuhwa vxyaameeta' maazkuẽe enwa. Aça' kwe'sx yuuwa ĩtxĩ yuume'nja'w sũhwa'ja'sçxáatha'w ji'phu'. ");
INSERT INTO pbb_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Txã'wẽ maazkuẽe en kĩh yuhwa ũ'mée yuhna ũssatx Pablo' na'wẽk we'we: —I'kwe'sxa' adx we'weni's nwẽese'jçxa Kreta kiwejũ kasehmeewaça', na'wẽ nxus knayna ivxiituwa'jmeene'tka'w yu'. ");
INSERT INTO pbb_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Nawa ãçxha' ũukhnuwe. Ayte u'jsa kim yuhwa uumeetxna, makwe barko yu' suweeçxa vxitutewa. ");
INSERT INTO pbb_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Adxa' Dxusna selpisaath, aça' ãçxh kus Dxus angel vxyaaçxa ");
INSERT INTO pbb_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","na'wẽk we'we: Pablo, ũukhnu. Idxa' Romate jxkaahsa tasxte utxaawa'j ji'phgu, aça' txãa pa'ga Dxusa' nwe'weya'wa' ay barkote u'jsa jxukaysatx jĩk. ");
INSERT INTO pbb_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Txãa pa'ga i'kwe'sxa' ũukhmée çxhãçxha miiyajkxwe. Adxa' Dxusçxáanath yaaki', angel we'weni' kxtey yuuna sũhna. ");
INSERT INTO pbb_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Sa' ĩkh pxãhte kiwe le'çxkuẽsate nvxiitni yu'nja'w jĩk Pablo'. ");
INSERT INTO pbb_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Adria ĩkhte wejxa jxũna u'jni e'z ki'su ãjaçte', txãa kuspxãh yuuçpkaçxha', barkote thegsawe'sxa' kiwe utxasu u'jweççxatx jiyu. ");
INSERT INTO pbb_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Sa' makhwe ĩkh dxiitewa jiyuya' isatx, aça' treinta y seis metroçxáak dxii yu'. Txajũ' yaç yaçte u'jçxa ki' isatx, aça' kxtea' weintisiete metroçxáak dxii yu'. ");
INSERT INTO pbb_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Txajũ' penxate wáa iika'nja'w sũhna ũukhçxa, barko's neewewa'jsa pahz çam walatx ĩkhkhẽ akh barko e'skhẽ, wejxa jxũna u'khamen. Sa' wala ũukhna ũythastxi khijkxpkaçx. ");
INSERT INTO pbb_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Naapkaçxha' barkote thegsawe'sxa' barko yaçkhẽ vxite çam walatx ĩkhkhẽ akheçtha'w jĩnaçxáa barko le'çxkuẽ's ĩkhkhẽ spaakiçtxi yu', txãate khẽeçxa kasehna u'j wẽeçxa. ");
INSERT INTO pbb_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Nawa Pablo' pta'sxku soldau kpiitan vxite' soldauwe'sxtxi: —Naawe'sxa' barkojũ kasehna u'the', i'kwe'sxa' ĩtxi yuumeene'kwe jĩte', ");
INSERT INTO pbb_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","soldauwe'sxa' barko le'çxkuẽ tudni lasutx spẽ'thçxa ĩkhkhẽ wãatahtx barko le'çxkuẽ's. ");
INSERT INTO pbb_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Txajũ' Pablo' kusíitey neewe'wek jxukaysatx kĩhçxáawa ũ'kahn: —I'kwe'sx dehmée txã'wẽy ũ'wamée ũsni e'z ki'su yã'j yuuça'. ");
INSERT INTO pbb_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Aça' i'kwe'sxtxi neewe'we'th kĩhçxáawa ũ'kahn. Txã'wẽme', kasejxa' ya'çxhãçxhameena. Ãçxha' ũukhnuwe. I'kwe'sx maa yuhwa vxitumeene'kwe. ");
INSERT INTO pbb_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Txã'jĩna'wa, Pablo' jxukaysa dxi'pte Dxusa's weçxaçxa pana's ũ'k. ");
INSERT INTO pbb_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Txajũ' jxukaysa wejx ũukhmée txãawe'sxwa ũ'tx. ");
INSERT INTO pbb_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Barkote u'jsa jxukaçxah yu' doscientos setenta y seis nasatha'w yu'. ");
INSERT INTO pbb_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Kĩh ũ' wẽeçxawa txã'sna ũ'na jxã'jçxa', skuutxha's ĩkhkhẽ pũsxtha'w barko jweeíiçxáa ẽseekahn. ");
INSERT INTO pbb_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Khijkxna jxã'jnite', barkote thegsawe'sxa' jiyumeeta' maa kiwete pa'jçxawa. Nawa ĩkh pukasu kiwe ukwesa u'pte uyçxa', kxte nuypa'jya' ãjãwá'nja'w sũhçxa kxtetx u'jya' yajkx. ");
INSERT INTO pbb_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Sa' çam wala ĩkh dxiikhẽ akhnisa lasutx spẽ'thna'wa, tela's ẽete ki' kiisçxa, barko's tuudkuẽçxah jxũna u'jtx ukwete pa'jya'. ");
INSERT INTO pbb_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Nawa teeçx ahte ĩkh jwee yu' dxiimeete yu' seena' çxhãçxha ukapajkxna ũsu'k kxtek kũjxa' u'j barko'. Aça' barko ĩçha' kiwete waçuna kũhte', ma'wẽ yuhwa ẽseme', naapkaçxha' barko e'su yu'tũçxhasáa ujkana kũhçxa jxuka suwuuçku yu'. ");
INSERT INTO pbb_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Txã'wẽ yuuçte', soldauwe'sxa' preesutx jxuka ikhya'watx yu', pehdna kasehçxa iyuwe'sxte. ");
INSERT INTO pbb_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Nawa soldau kpiitana' Pablo's nwe'weya' yajkxku, sa' kiikhe'jmeeçxa na'wẽk jxkaah: —Maawa pehdxa' jiisa' i'kwe'sx khuẽ'y yaçte me'jwe, ");
INSERT INTO pbb_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","naapkaçxha' vxite' taplasu mkhẽewe, meeçxawa barko pe'lasu txã'wẽ yũuçxa mkaasehwe jĩte', txã'wẽ yũuçxa jxukay kiwete pa'tha'w uumée. ");
INSERT INTO pbb_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Kxte jxukaysa uumée pa'jçxatha'w jiyu txãa ĩkh pxãhte kiwe' Maltaga yaase yu'. ");
INSERT INTO pbb_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Kxte u'psa nasa' kwe'sxtxi wa'lmée jxpa'gaçxa, ipx wala yuthçxa kwe'sxtxi bajçxya' pi'kxtxi, nus txã'wẽ wala pa'jna ũspa'ga. ");
INSERT INTO pbb_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Txajũ' Pablo' e'kx uhdx pkhakhçxa, ipxte ãsxiçku yu', naapkaçxha' txãa ipx pxãjũ ul weeswee ũphna kasehçxa Pablo kusetek wa'kx. ");
INSERT INTO pbb_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Txã'wẽ Pablo kusete ul wa'kxte', kxte ũssa' na'wẽtx we'we txãawe'sx pwe'sx: —Naa piçthẽ'ja' nasa ikhsana. Makwe ĩkhte yu' uumeetewa, Dxusa' ĩtxi u'ju jxthãasmeene' jĩ'tx. ");
INSERT INTO pbb_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Aça' Pablo' kuse's yahtaçxa ula's ipxkhẽ akhku, nawa txajx kuse yu' kĩhwa yuume'. ");
INSERT INTO pbb_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Aça' nasa thegna ũssa yu' ¿Ma'wẽn uukx? sũhna jxukaysa ũythasnatx ũsu'. Nawa kĩhwa yuumeyna wala txaçx yuute': —Pablo' nasa ikhsamée wejxwa Dxusna jĩ'tx. ");
INSERT INTO pbb_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Txãa kiwete teeçx ne'jwe'sx jxtuhthesa u'pu'k Publio yaasesa. Txajx uuthasx ja'datetka'w pa'j kwe'sxa', aça' txãa piçthẽ'ja' kwe'sxtxi wala ew jxpe'kh tekh enpkaçx. ");
INSERT INTO pbb_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Txãa ensu' Publio neya' ãça'naga ũsu' kakwesekte eeçxáa uçxi'çxçxa. Aça' Pablo' thegya' u'jçxa, peekizeçxa Dxus yakh puutx we'wete', çxhãçxhak. ");
INSERT INTO pbb_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Txajũ' txãa kiwete vxite ãça'sawe'sxwa pa'jçxa', jxuka katxhiçxatx neeyũu. ");
INSERT INTO pbb_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Txajũ' kwe'sxtxi wala peeygãhçxa kĩjkĩhwa dxi'the peejini's jxukatx pees, barkote khẽeçxa ki' u'jya'wagaçxha'. ");
INSERT INTO pbb_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Malta kiwete tekh a'te ũsçxaçxáa, Alejadría kiwejuwe'sx barko kxte ũsu'k nus pĩipkaçx txãate khẽeçxatha'w u'j. Txãa barko' yaçte e'z dxus ĩtximeesatxku piisani ji'phu', Kastor vxite' Polux yase ji'phsa. ");
INSERT INTO pbb_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Txajũ kasehçxa', Sirakusa çxhabte pa'jçxa, tekh entha'w ũsu'. ");
INSERT INTO pbb_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Txajũ ki' u'tha'w kiwe pukagaçxaçxáa, sa' Regio çxhabtetha'w pa'j. Kuskuskhẽ' e'su wejxa sẽhte', thẽymée u'jya' ãjaçxa e'z enkhẽ' Puteoli çxhabte pa'tha'w. ");
INSERT INTO pbb_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Kxtea' puutx uytha'w yakhthẽ'jwe'sxtxi, aça' txãawe'sxa' pi'kxtxi txãawe'sx yatte teeçx ki'su ũskahn. Txajũ kasehçxatha'w Roma çxhabna u'j. ");
INSERT INTO pbb_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Romate yakhthẽ'jwe'sxa' kwe'sx yuhtewa jii yã'tha yu', sa' teeçx ahte Tres Tabernas yaasesa utxate teeçx çxhab ũsu'k Fxoro de Apio kxteta pu'thegya' yuwé'. Aça' Pablo' txãawe'sxtxi uyçxa', Dxusa's wala weçxana ũuste wẽt wẽtku yajkx. ");
INSERT INTO pbb_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Romate pa'jna'wa, soldau kpiitana' vxite preesutxi' dukhku kxte karcelte thegsa npiiçthẽ'ja's, nawa Pablo yu'sa' vxite yatte fxiik txah teeçx soldau thegwa'jsa txahçxa. ");
INSERT INTO pbb_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Kxte pa'jni tekh en skhẽwniite', Pablo' pa'ya kaakh kxte Romate judiu npiiçthẽ'jwe'sxtxi. Sa' pkhaakhete', na'wẽk we'we: —Adxa' kĩhwa ewmée yu' yũumeeth judiuwe'sxtxi, sa' kwe'sx yaçgawe'sx kaapiya'jni'swa ahçena fxi'ze'çmeeth. Makwe txã'wẽtewa, Jerusalente adxa's tudçxa romanowe'sxtxi dukhtxi. ");
INSERT INTO pbb_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Aça' romanowe'sxa' paapẽjxtxi, nawa ewmée yũuni's yu' uymeeçxa', adxa's txhweete wẽetx ikhwa'the nvxiht-ya' yu' ãjameeçxa. ");
INSERT INTO pbb_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Txã'wẽtewa, judiuwe'sx yu' kaatxhwete'jmeeta'. Aça' txã'wẽ yã'the', adxa' romanowe'sxtxi jxkaahsa Cesara'sthu pi'kx adx yuwe's paapẽykahn. Nawa judiuwe'sx adxna preesu'jsa yuutxi' pãatxhĩ'khya'wameeth. ");
INSERT INTO pbb_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Txãasath i'kwe'sxtxi pa'ya txã'jĩna pta'sxya'. Israelwe'sxa' ũythasu'tha'w Dxus tasxuh yuusa Kristo's txãa pa'ga yuuçxáa adxa' na'wẽ kadenaju tudni ũsthu. ");
INSERT INTO pbb_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Txã'wẽ pta'sxte', na'wẽtx we'we: —Judeajũ idxna nuywe'wena kaahni karta kĩhwa iijxpa'gameetha'w kwe'sxa', txajũ judiuwe'sx pa'jçxawa pta'sxi'çmeeta' idxa's açewe'weni yu'sa'. ");
INSERT INTO pbb_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Ãçxh u'se pta'sxni's mteewa jxukatx açewe'we', aça' txã'sa' idxa' ¿maa sũju'ga? Iidx yaakxni's jiyu wẽetha'w jĩçxa', ");
INSERT INTO pbb_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","vxite ente ki' pa'jya' neeyũuçxa txãa en ãhte', wala kuh pkhaakheçxa pa'jtx Pablo ũsni yatte. Aça' Pablo' kusíi pta'sxçxa kusna kĩhpkaçxku pta'sx Dxus jxkaahwa'ja's. Sa' Moises fxi'jni ley vxite' Dxus yuwe pta'sxsa txãniiteywe'sx fxi'jni ma'wẽçxahne'ta Jesusa's we'wena fxi'j txã'snak ãate kaajiyu'j. ");
INSERT INTO pbb_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Aça' maaíi yu' Pablo pta'sxni's wa'lmeetx jxpa'ga, nawa vxite yu' wa'ltxi. ");
INSERT INTO pbb_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Txã'wẽ maaíi yu' nwẽese'j wẽemeeçxa txuteena u'jweçte', Pablo' na'wẽk txãawe'sxtxi we'we: —Dxus yuwe pta'sxsa Isaiasa's Dxus Espiritu kwe'we'the', isa yuh na'jĩna pta'sxne' kwe'sx yaçgawe'sxtxi': ");
INSERT INTO pbb_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","U'jçxa txãa nasatxi' na'jĩna mpeeta'sx: I'kwe'sxa' wẽse'jçxawa, jiyumeene'kwe. Meeçxa' uyuwá'kwe, nawa jiyumeene'kwe. ");
INSERT INTO pbb_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Txãa pa'gatey txãawe'sx ũuste jiyuwa'j yu'sa' ji'phmée yã'tha', Sa' wẽse'jya'wa wa'lu'tx. Txãawe'sx yafxa' aphanita', uymeeçxa' nwẽese'jmeetxna. Sa' ũustewa ew jiyumeetxna. Sa' adx tasxtewa utxameetxna pkaltxi peltunãykahn jĩnak we'we. ");
INSERT INTO pbb_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","I'kwe'sxa' mjiyuwe: Ãçxhũyã'ja' Dxus ewte nvxiitwa'ja's judiu ji'jmée vxite nasaçxáatx pta'sxwa'ja', aça' txãawe'sxa' nwẽese'jetxna. ");
INSERT INTO pbb_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","Txã'wẽ Pablo we'wete', judiuwe'sxa' txãawe'sx pwe'sx wala kuh jwed we'wena u'jtx. ");
INSERT INTO pbb_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Pablo' e'z anxu utak yat pki'jçxa txaahni ũsu', sa' kxte thegya' pa'jsatx jxukaysatxku jxpa'ga'. ");
INSERT INTO pbb_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Kxtea' kim yuhwa kuçx yuuniméek fxi'ze' Dxus jxkaahwa'j ena's pta'sxna, txã'wẽy Jesukristo kaapiya'jni'swa ãatek pta'sxna fxi'ze'.");
INSERT INTO pbb_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Adxa' Jesukristo's selpisáa Pablo yaaseth. Aça' adxa's Dxusku txhitxçxa nvxiht, Kristo yuwe ewte nvxiitwa'jsa's pta'sxkahn. ");
INSERT INTO pbb_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","Dxusa' txãa yuwe ewte nvxiitwa'jsa's pta'sxni yuuna jĩna kfxi'ja'kh nyafxíi entey Dxusna selpisaawe'sxtxi. ");
INSERT INTO pbb_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","Aça' txãa Dxus yuwe ewte nvxiitwa'jsa' kwe'sxtxi jxpe'jsa Jesukristo Dxus Nçxi'ka'sku we'we'. Aça' Jesukristo' naa kiwete yu' jxkaahsa Davxid ji'thek upx kakwe yu'. ");
INSERT INTO pbb_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","Nawa kĩhtewa jxuka ãjawa'jsa Dxus Nçxi'ktewa Dxus Espiritu' kwe'sxtxi kaajiyu'kh Jesukristo's uuniijũ ĩtxi vxitçxa. ");
INSERT INTO pbb_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Sa' adxa's peeygãhçxa Jesukristo nwe'wete', Dxus txhitxnisath yuu, Jesukristo's selpiwa'jsa, kxah naa kiwete maa nasawa Jesukristo's jiyuçxa jxpa'gatxna txã'sna nwẽese'jya'. ");
INSERT INTO pbb_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","Aça' i'kwe'sxwa Jesukristo's jiyuçxa ne'kwe jxpa'ga, Dxusa' petx i'kwe'sxne' txhitxh Jesukristo tasxte pa'jwa'jsa txãa pa'ga nwẽese'jna ũsi'kwe. ");
INSERT INTO pbb_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Ãçxha' Roma çxhabtewe'sx i'kwe'sx jxukaysa jĩi naa karta's fxi'jçxa kajaçthu, i'kwe'sxa' Dxus peeygãhçxa txhitxnisai'kwe txãa yakh fxi'zesa. I'kwe'sxtxi' Dxusa' pu'çxhina vxite' kwe'sxtxi jxpe'jsa Jesukristo, txãa pa'ga Dxus yakhçxáa mfxi'zewe. ");
INSERT INTO pbb_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Jesukristo i'kwe'sxtxi pu'çxpa'ga Dxus yakh i'kwe'sx ew fxi'zeni's mteewa jxukatx ew we'we', txãa pa'ga adxa' Dxusa'sthu weçxá'. ");
INSERT INTO pbb_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Sa' na'wẽ Dxusa's nakwe wala selpi'th txajx Nçxi'k kaapiya'jni's ũusuh jxuka yajkxna txãa Dxusa' jiia' adxa' i'kwe'sx pa'gate bagaçxtewa txãa yakh puutx we'wena nes yuusaatewa. ");
INSERT INTO pbb_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","Txãasath i'kwe'sx tasxna yuhwaça' sũhçxa Dxus yakh puutx we'wena nes yu'. ");
INSERT INTO pbb_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","Sa' kxtee pa'jçxa' Dxus yakh fxi'zewa'ja's i'kwe'sxtxi pu'çxhi'nja sũju'th, jweeíiçxáa çxhãçxha fxi'zekahn. ");
INSERT INTO pbb_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","Sa' puutx kxteeçxah ya'pu'çxna Dxus yakh çxhãçxha fxi'zewa'ja's ji'phu'nja'w, txãa pa'gatey i'kwe'sxwa Dxusa's yaakxsa i'kwe adx na'wẽy. ");
INSERT INTO pbb_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Yakhthẽ'jwe'sxtxi pta'sxi'th: i'kwe'sx yakh puutx uyya' yuwe'nja sũhna maz uswa yajkxçxawa, ãçxpkaçx yujxa' yu' tudunimeeth. I'kwe'sx ksxavxysu Dxus luuçx yuuwa'jsa ũstxna txãatx Dxus jĩi knayya' yuwe'nja sũju'th, ma'wẽtka vxite kiwesuwa Dxus jĩi knay txã'wẽy. ");
INSERT INTO pbb_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Adxa' maa nasatxwa jxuka Kristo yuwe's pta'sxwa'j ji'pthu, çxhabtewe'sx ma'tx yuu, fxiy we'wesa ma'tx yuu, naa kiwete wala jiisa ma'tx yuu meeçxa' jiimeesa ma'tx yuu nawa ma'wẽsatxwa jxuka pta'sxwa'j ji'pthu. ");
INSERT INTO pbb_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Txãasa adxa' Kristo yuwe ewte nvxiitwa'jsa's pta'sxya' yuwe'nja sũhnaçxáa ũsthu Roma çxhabte i'kwe'sxtxiwa. ");
INSERT INTO pbb_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Adxa' Kristo yuwe ewte nvxiitwa'jsa's pta'sxya' weh yuhwa thaame'çmeeth, txãa pa'gatey Kristo' Dxus kaahnisa' maatxwa nwe'weya' ãjawa'jsa txã'sna ũuste jxpa'gasa yuutxi', judiu ma'tx yuu judiumeesa ma'tx yuu nawa maa nasatxwa jxuka nwe'wewa'jsa'. ");
INSERT INTO pbb_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Aça' nwe'wenisa yuuya', Kristo's ũusuh jxuka yajkxçxa jxpa'gate yuuçxáak Dxus dxi'pte yuuwemée ewsa yuuna ya'pa'ja'. Txã'wẽ yuuwa'ja's Dxus librute vxite ajkhẽwa na'jĩnak pta'sxi': Dxusa's ũusuh jxuka yajkxte yuuçxáa Dxus yakh fxi'zewa'ja's ya'ji'phuna jĩ'k. ");
INSERT INTO pbb_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Dxus kastigo seena'sa cieluju yuja' nasa ewmeesa jxukaysawe'sx jĩi, txãawe'sxa' ewmeete yuuçxáa fxi'zena isasa yu'sa' yupna ũsta' naa pa'ga. ");
INSERT INTO pbb_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","20","Txãa ente' Dxus ma'wẽsatewa jiimeetha'w yu' jĩya' ãjameetxna, txãa pa'gatey Dxus ma'wẽsatewa kaajiyu'jsa ũsta' Dxus pheu'jçxa nvxiitnisa txãatx kaajiyu'ju'. Txãa pa'gak naa kiwe's pheu'jçxa nvxiitnijũ' ew ya'jiyu' Dxusa' kĩhtewa jxuka ãjawa'jsa bagaçxtewa nes yuuwa'jsatewa. Aça' txãa ma'wẽsaçxawa kaajiyu'jnku txã'wẽ pheu'jçxa nvxiht. ");
INSERT INTO pbb_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","Txã'wẽ Dxusa' ũsyuhna sũhwa'j yu'sa' ji'phuçxawa, isate yu' Dxusa's weçxana nwẽese'jmée, naa kiwete kĩh yuhwa seelpimeesaçxá'stxi pakwena jxã'j. Aça' txã'wẽ yũupa'ga txãawe'sx ũusa' naa kiwete ewmeesa yuuçxá'sku yaakxwa'jsa neeyũu. ");
INSERT INTO pbb_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Txãawe'sx yu' jiitha'w jĩ'tx, nawa jiimeesatx yuuna pa'j. ");
INSERT INTO pbb_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","Txã'wẽ Dxus bagaçxte yuhwa pçuwa'jsamée kĩhtewa jxuka ãjawa'jsa' txã'sna neewe'wepkaçxte, naa kiwete pçuwa'jsa nasa na'wẽ piisaçxatx neewe'wena ũsu'. Sa' txã'wẽçxáa yũumée, fxuusá, yu'kh eçx txã'wẽsa na'wẽ vxitçxatx neewe'wena ũsu'. ");
INSERT INTO pbb_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Txã'wẽ yũupa'ga Dxusa' txãawe'sxtxi' pu'çxmée nvxihtku, peekx ewmée kazx yaakxniçxá's kxtey yuuna fxi'zekahn, kxahtx kĩhwa thaampa'saçxá's puutx ya'ewmée yũuna fxi'ze' teeçxsa na'wẽçxah. ");
INSERT INTO pbb_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","Txãawe'sxa' isa Dxus ĩtxisa yu'sa' jxpa'gaya' wa'lçxa, Dxusmeeçxá'stxi jxpa'ga. Txãasatx wejxwa Dxus kĩhnawa jxuka pheu'jçxa nvxiit-sa'síi neewe'wepkaçxte, naa kiwete Dxus pheu'jçxa nvxiitnisaçxá'stxi neewe'wena fxi'ze'. Txã'wẽ Dxus bagaçxtewa pçuwa'jmeesa's neewe'wewaç, wejx thaakwe ewsa', nawa txã'wẽ yũumeeta'. ");
INSERT INTO pbb_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","Txãa pa'ga Dxusa' pu'çxmée nvxihtku, txãawe'sx ewmée kazx yaakxniçxá's kxtey yuuna fxi'zekahn. Aça' u'y pwe'sxtxi pkal yuuna fxi'ze', txãawe'sx kakwe'síiçxáa suwwa'jsana pakwena. ");
INSERT INTO pbb_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","Txã'wẽy piçthẽ'jwe'sxwa nyu yakh zhiçxkwe fxi'zeni yu'sa' nvxihtçxa, puutx piçthẽ'j pwe'sxtxi pkal thaampa'saçxá's kxtey yuuna fxi'ze', peekx kakwe kazx yaakxniçxá's nwẽese'jna. Txã'wẽ yũuçxa peekx kakwejũjxçxáa ya'kastigãywa'ja's uyu'tx. ");
INSERT INTO pbb_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Txã'wẽ Dxusa's nwẽese'jya' wa'lyã'the', Dxusa' pu'çxmée nvxihtku, txãawe'sx kazx yaakxniçxá's nwẽese'jçxa peekx ma'wẽwa ewmée yũuna fxi'zekahn. ");
INSERT INTO pbb_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","Txãa pa'gatx ewmeesa yuuçxáa yuuna pa'j: pthãawesa, pkal yuunisa, ewsa's jiiçxawa ewmeeçxáa yũusáa, Dxus yu's yajkxmée ji'phu wẽeniçxá's yaakxsa, kĩhwa ewmeeçxáa yũusáa, vxitetx açeyaakxsa, nasa ikhsa, puii kiissa, ĩsxiisa, ewsa yu'sa' weeçxsa, ĩsxiiçxa kaapui'jsa, txã'wẽçxáa yũusaata'. ");
INSERT INTO pbb_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","Vxitetx ewmée nuywe'wesa, Dxusna açesa, puutx ya'wẽesxusá, peekíiçxáa iiwejçx yaakxsa, vxitee dxi'pte iiwejçx we'wesa, ewmée yũuwa'j u'sesa pakwena fxi'zesa, neywe'sxtxi nwẽese'jsamée, ");
INSERT INTO pbb_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","ewsa's jiyuya' wa'lsa, puutx we'weni's kxtey yuusamée, kim yuhnawa peeygãasamée, bagaçxte yuhwa yuwe ewuusamée, kim yuhnawa pu'çxsamée. ");
INSERT INTO pbb_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","Txãawe'sxa' wala ew jiita' txã'wẽ ewmée yũupa'ga Dxus kastigote uuwa'ja's. Txã'wẽ ew jiiçxawa, ewmeesa yuuçxáanatx kxtey yuuna fxi'ze'. Sa' ũus yuhwa ji'phmeesa yã'tha', txãasatx vxitesa ewmée yũuçte uyçxa', wejxwa kçxhãaçxha'jna fxi'ze'. ");
INSERT INTO pbb_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","Txã'wẽ ewmée yũupa'ga Dxus kastigo's jxpa'gawa'j ji'phta' jĩna idxa' açewe'weçxawa, txãa nasa ewmeesa na