﻿USE sofia;
DROP TABLE IF EXISTS sofia.paoNT_vpl;
CREATE TABLE paoNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES paoNT_vpl WRITE;
INSERT INTO paoNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Ka Te Pabe'e Jesus-witu oosoo ka David-ma'yoona suaketu, tamme Jew numu o'nosoo ekow pooha natuukwepu meno'o oo-toogoo manekena. Soo Jesus togesapa Jew numu, oosoo tuwazoo Abraham-ma'yoona suaketu, no'oko tamme Jew numu-wa'ne. ");
INSERT INTO paoNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Soo Abraham tooa Isaac mee nane'a. Soo Isaac tooa Jacob mee nane'a. Soo Jacob tooa Judah mee nane'a. Soo Judah ewow wanga'amu ga'yoo. ");
INSERT INTO paoNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judah waahoo nana'atse doodooamu-ga'yoo Perez-no Zerah mee nananeadu. Mu pea uga Judah kunoopea Tamar mee naneadu. Soo Perez tooa Ram mee nane'a. ");
INSERT INTO paoNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Soo Ram tooa Amminadab mee nane'a. Soo Amminadab tooa Nahshon mee nane'a. Soo Nahshon tooa Salmon mee nane'a. ");
INSERT INTO paoNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Mu Salmon noko Rahab tooa Boaz mee nane'a. Soo Boaz yise wawa'a nodukwadoo, Ruth mee naneadu, mu tooa Obed mee nane'a. Soo Obed tooa Jesse mee nane'a. ");
INSERT INTO paoNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Soo Jesse tooa David mee naneadu, ka mu Jew numu-kooba katudu. Soo David kumma'akoosoo nana Uriah mee naneadu nodukwa makoo Solomon mee naneadu tooa-ga'yoo. ");
INSERT INTO paoNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Soo Solomon tooa Rehoboam mee nane'a. Soo Rehoboam tooa Abijah mee nane'a. Soo Abijah tooa Asa mee nane'a. ");
INSERT INTO paoNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Soo Asa tooa Jehoshaphat mee nane'a. Soo Jehoshaphat tooa Joram mee nane'a. Soo Joram tooa Uzziah mee nane'a. ");
INSERT INTO paoNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Soo Uzziah tooa Jotham mee nane'a. Soo Jotham tooa Ahaz mee nane'a. Soo Ahaz tooa Hezekiah mee nane'a. ");
INSERT INTO paoNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Soo Hezekiah tooa Manasseh mee nane'a. Soo Manasseh tooa Amon mee nane'a. Soo Amon tooa Josiah mee nane'a. ");
INSERT INTO paoNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Soo Josiah tooa Jechoniah mee nane'a. O'no mu Jew numu wohomu Babylon numu mee nananeadu, ka mu Jew numu pummesoo tubewa-witoo mahuka, mu nedyaawekwuse. ");
INSERT INTO paoNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Soo Jechoniah tooa Shealtiel mee nane'a. Soo Shealtiel tooa Zerubbabel mee nane'a. ");
INSERT INTO paoNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Soo Zerubbabel tooa Abiud mee nane'a. Soo Abiud tooa Eliakim mee nane'a. Soo Eliakim tooa Azor mee nane'a. ");
INSERT INTO paoNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Soo Azor tooa Zadok mee nane'a. Soo Zadok tooa Achim mee nane'a. Soo Achim tooa Eliud mee nane'a. ");
INSERT INTO paoNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Soo Eliud tooa Eleazar mee nane'a. Soo Eleazar tooa Matthan mee nane'a. Soo Matthan tooa Jacob mee nane'a. ");
INSERT INTO paoNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Soo Jacob tooa Joseph mee nane'a, oo nodukwa Mary. Soo Mary yise ka Te Pabe'e Jesus dooa'adoo. ");
INSERT INTO paoNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Tamme oo sopedakwatoo soo Jesus, Te Pabe'e David-ma'yoo suaketu. Ooonne'yoona tamme oo sopedakwatoo soo Jesus Te Pabe'e. ");
INSERT INTO paoNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","19","Ka Te Pabe'e yaa'a teepu-koobatoo oo nadooa'adoopu-witu nu mu tuukwekwu. Soo Mary ka Joseph koomadookwuse yise Te Naa Besa Pooha-toohakwi koheahoo. Pana soo Joseph gi oo nakasopedakwatoo ka Mary Te Naa Pooha-toohakwi oo kooheana gi oo nodukwadookwu mee soonamme. Soo Joseph besa sootumatuguna gi numu tuukwe'e ka Mary kohea-kwitu, gi oo soomanasookwikuna. ");
INSERT INTO paoNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Oetu ewa soohanena, soo Joseph yise mee nose. Soo Te Naa tummatziwabe toha kasa-ga'yoo meeoo oo tuukwe, gi hownne'yoo ka Mary nodukwadookwuse, oosoo ka Te Naa Besa Pooha-toohakwi kohe'a. ");
INSERT INTO paoNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ka Mary saa'a tooa-doose, u sakwa yise Jesus mee oo nea, Numu Magwetzoidu, mee na'unnedu. Oosoo Jesus pumme nanumu, pumme naka'oedyukudu magwetzoikwudu, ka suda mu tumatuguna mu nemawunikukwu.” ");
INSERT INTO paoNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","O'nosoo soo Te Naa yadooawabe ka Te Pabe'e-witu waha. Meno'o yise toge oo-toogoosoo manepetu. Soo Te Naa yadooawabe mee unnepu, ");
INSERT INTO paoNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Soo tsuadumu gisoo nana-no suda manedu saa'a kohease, naatse dooa'adoodooa. Oosoo naatse Emmanuel mee naneadooa, Soo Te Naa tamme-no, mee na'unnedu.” ");
INSERT INTO paoNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Soo Joseph yise saa'a ka Mary nodukwadoo, ka Te Naa tummatzidu toha kasa-gakoo pumme netamma-kwa'ne. ");
INSERT INTO paoNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Pana soo Joseph gi ka Mary matzama, saa'a oo tooa'adoose ka oonga'a Jesus mee oo nea. ");
INSERT INTO paoNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Ka Jesus ka Bethlehem mee naneadu-kwi nadooa'adoose, saa'a susumudu numu taba tsebooena-kwana kemmadu, ka mu paatoozooba-witu sopedakwadoodu ka mu Jew numu-kooba katudu, Herod mee naneadu-baa petuse oo tubenga, ");
INSERT INTO paoNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","“Hano soo tuha'yoo nadooa'adoopu ka mu Jew numu-kooba katukwudu? Numme ka paatusooba poonne paba patakwetseapunne ka tsebooegese, ka oo nawuena ne tuukwedu. Yow numme petuhoo oo-matoo nanesootuhigena.” ");
INSERT INTO paoNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Soo Herod oo nakasutakuoo. ");
INSERT INTO paoNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Soo Herod yise ka mu Jew numu nanesootuhidu moohedu nanano sumu tuungu, yise mu tubengu, “Hanotoo yise soo Mu Pabe'e nawuekwu?” ");
INSERT INTO paoNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Umu yise meeoo, “Oona ka Bethlehem mee naneadu-kwitoo ka yaa teepu Judea mee naneadu-koobatoo nawue, mu nanatugwengapu-wa'nesoo. O'nosoo soo Te Naa yadooawabe tubotuguna Te Naa tunemamakwupu, ");
INSERT INTO paoNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Soo Bethlehem mee naneadu ka teepu Judah-koobatu unu nanenagapunnedu. Soo numu ka nuga Jew nanumu moohekwudu oonona saa'a kemmadooa,’ mee soo Te Naa mooasoo unnepu-ga'yoo.” ");
INSERT INTO paoNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Soo Herod yise ka pumme tummatzidu meeoo watze netamma, “Ka mu numu mu paatoozooba-witu sopedakwadoodu numu nu-matusoo taya.” Soo Herod yise meeoo mu tubenga, “Hannano'o soo paatoozooba mu poonnepu tsebooege?” Umu ka ooka tu pudu poonne-kwitu oo tuukwe'e. ");
INSERT INTO paoNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Soo Herod yise meeoo mu netamma, “Soo tuha'yoo Bethlehem-wi mee nu oo naka. Mu sakwa mease, ka oo mayudooase, e tuukwe, o'no nu punno'o oo-matoo nanesootuhikwu,” mee'e soo Herod mu esayikute. ");
INSERT INTO paoNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Umu paatoozooba sopedakwadoodu yise Bethlehem-witoo mease ka paatoozooba poonnesoo. ");
INSERT INTO paoNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Umu tubetse besa sokwama ka paatoozooba poonnesesoo oo nageka, umu paatoozooba sopedakwadoodu yise ka nobe ka tuha'yoo pukwi'yoona-wi petuga. ");
INSERT INTO paoNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Umu paatoozooba sopedakwadoodu yise ka nobe-kwi tzoonooakase, ka tuha'akoo poonne, ka oo pea Mary mee naneadu noko, umu oo-matoo nanesootuhi ooka tu hee-matu oo heme: unu nanenagadu oa tupe, ka besa kookwanadu, ka unu nanenakudu sanape numu ya'ena punoko natuguyina tuwazoo. ");
INSERT INTO paoNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ka mu nose-kwi umu paatoozooba sopedakwadoodu mee natuuya tuukwe, “Gi ka Herod-matoosoo kodyukapana. Atatamesoo nobe-kwitoo kodyuka.” ");
INSERT INTO paoNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Ka mu paatoozooba-witu sopedakwatoodu numu kodyukase, soo Joseph mee nose. Ka oo nose-kwi, soo Te Naa tummatzidu, toha kasa-ga'yoo oo-baa petuse mee yise ka Joseph netamma, “Yotsese, namamea ka teepu Egypt mee naneadu-kwitoo, ka Jesus noko Mary hanega. Osoo tutooepunne, nu saa'a mu tuukwedooa, o'no saa'a yise mu kodyudooa. Soo Herod ka Jesus watekwu ka Jesus batsakwuse.” ");
INSERT INTO paoNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Soo Joseph yise ka tuponnese ka tu nosepu mayoho ka Egypt-witoo togaba-ma namamea, tu nodukwa noko tu tooa'a nobeahooka. ");
INSERT INTO paoNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Umu ooosapa Egypt-wi ka Herod numu-kooba oo katu. Esoo namanedu Te Naa o'nosoo tunemamakwupu oo yadooawabe tubona meeoo, “Nu ka e dooa Egypt-wikoo bihookwu.” ");
INSERT INTO paoNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Soo Herod unutse suta'a ka mu numu ka paatoozooba-witu sopedakwatoodu gi pu-baa kodyu petugasoo, “Umuga sumuna e nemooaga,” mee soonamme. “Oosoo mu Pabe'e sumuna saa'a e kapikoo e tatsatsebooadooa,” mee soonammena. O'no yise ka mu tu tutukwutumawabe no'oko nana'atse, waha tomodu-toohatu dooake, mu oonga'a nokosoo ka Bethlehem-witu goe tuungu umu oo-tzage'e-kwitu tuwow. Meno'o ka soo tuha'yoo oonano'o tomopu mee oo sooyugwena ka umu paatoozooba-witu sopedakwadoodu pumme tuukwe-makoo. ");
INSERT INTO paoNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","O'nosoo soo Te Naa yadooawabe Jeremiah mee naneadu ekow botugu meno'o yise oo-toogoo manepetu. ");
INSERT INTO paoNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Ka mu Jew numu Ramah mee naneadu tubewa-gapunnedu-kwitu ewa'yoo numu tubetse unu sakwa'e. Umu tu doodooamu-kooba sakwina gi pumme netusoonaku-wa'ne ka tu doodooamu tuipu.” ");
INSERT INTO paoNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","20","Ka saa'a soo Herod yise ya'e. Ka oo ya'ese, soo Joseph nosesoo tuwazoo. Soo Te Naa tummatzidu, toha kasa-ga'yoo oo tuukwe'e ka oo nose-kwikoo punowsoo no'yoona kodyuka ka mu Jew nanumu tubewa-witoosoo, ka mu Jesus-noko Mary-nosoo. ");
INSERT INTO paoNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Umu oo too'e nebatsayagadu mooasoo tuipu. Ka kodyukamena, ");
INSERT INTO paoNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","soo Joseph meeoo tunaka soo Herod tooa Archelaeus mee naneadu ka tu naa kapi manese ka mu Jew numu-kooba meno'o katudu, ka Judea mee naneadu teepu-kooba. Ka meeow tunakase oto tu meakwu-ma sua'e. Soo oo nosepu punno'o gi oonow mu mea tuungu. Ooonne'yoona umu ka Nazareth mee naneadu ka teepu Galilee mee naneadu-kwi petuga. ");
INSERT INTO paoNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Ka o'nosoo Te Naa yadooawabe unne-kwa'nesoo manekena soo Te Pabe'e-witu. Mee'e soo Te Naa yadooawabe unnepu, “Oosoo ka Nazareth mee naneadu-wi'yoo kemmakwu.” ");
INSERT INTO paoNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Ka saa'a sumu'yoo nana John mee naneadu mu numu baa-wi matzakadyakwe oona gi hemma nadukadu pukwi naa-wi'yoona. Soo John mu numu pu-baa petudu mee netammayakwe. ");
INSERT INTO paoNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“E nakapunne, mu sakwa ka suda mu tumatuguna ma'wu, pudusoo soo Te Naa no'oko numu nemadabuekwu.” ");
INSERT INTO paoNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","O'nosoo soo Te Naa yadooawabe Isaiah ka John gisoo nadooa'adoo oo manekwuna, mee botugupu “Mana ka hemma nadukadu gi naa-kwi'yoona sumu'yoo nana ka Te Naa pooha-toohakwi numu tunesootabuekwu, ‘E nananumu mu sakwa muusoo nuummabetseapunne ka Te Pabe'e pudusoo petukwunoto. Mu sakwa kaaheno tusooyugwe, o'no mu besa oo nakabetseanokwu.’ ” ");
INSERT INTO paoNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Soo John puhu nagwese-kwi namasooana mokobu nate'a. Kua noko nota peha tukana oo-ma naakugwetzoinumme. ");
INSERT INTO paoNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Ewa'yoo numu tooe hanotu tooe oo-baa petudyakwe. ");
INSERT INTO paoNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Umu ka suda tu tumatugupu wahana yise mu nemawunidyakwe ka kaaheno meadabekwu mee tusooyugwese. Soo John yise ka Jordan mee naneadu hoo-kwi mu matzakadyakwe. ");
INSERT INTO paoNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Mu Sadducee-no Pharisee mee nananeadu numu nanesootuhi moohedu tooe gi tunaka'oedyukupana ka John-baa petugase, umu punno'o baa-wi oo namatzaka tuungu, soo John yise mee mu netamma, “Mu unu etza'a. Saa'a soo suta'yoo mu-matoosoo kodyukwu. Mu baa-wi mumme e matzaka tuungu pana mu gi ka mu tuma'emukwapu nematzagakwuna'e. ");
INSERT INTO paoNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Mu mooe'ugasoo sakwa ka suta mu manena tubetse ma'wukase ka besa tamme manese, o'no sakwa yise nu baa-wi mu matzaka. ");
INSERT INTO paoNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Gi besa nasooyugwena mee unnegonnopana, ‘Numme yaahoo Te Naa doodooamu numme ka Jew numuna.’ Mu tookwa gi oo nakasopedakwadoo soo Te Naa tooe hownnekoo tooe tu doodooamu mu mesoo mayugwe. ");
INSERT INTO paoNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Mu sakwa besa tumatugu. Mu ka ooosapa gi besa tumatuguna, mu kadoo namayugwekwusoo tooe haga tooe gi he-toogoo besa'yoo natunikwu. ");
INSERT INTO paoNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Nu ka baa-wi mu matzakase, mu ka sutakoo podo mu meana ma'wukase, ka besa'hoo podo meadabekwu. Pana soo Te Pabe'e pudusoo petukwu nuga oooonakwatusoo unu pooha-ga'yoo, nuga oooonakwa besa'yoo tuwazoo. Soo Te Pabe'e ka Te Naa Besa Pooha-matu-ma mu sootuhikwu, oosoo besa, gi totsabu mu mayugwekwu. ");
INSERT INTO paoNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Soo Te Pabe'e petuse ka mu numu yaa teepu-koobatu nemadabuedooa ka mu bebesow ka mu suta-nagakoo tzobadooa. Ka pepesahoo numu yise tu nobe-kwi nabaa'yookukwu. Mu suta'yoo numu gi tunaka'oedyukudu ka tubetse gi tokedu goso-witoo nama'anakwunikwu.” ");
INSERT INTO paoNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Soo Te Pabe'e oona Galilee mee naneadu-wi'yoona kemmase oona ka Jordan hooda-kwi ka John-baa petuga. ");
INSERT INTO paoNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Yise ka John baa-wi namatzaka tuungu. Soo John yise meeoo oo netamma, “How yise u nuga oooonakwasoo besa'yoo pana nuka baa-wi namatzaka tuungu?” ");
INSERT INTO paoNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Soo Te Pabe'e oo nanekwegea, “U sakwa nuka baa-wi matzaka, no'oko ka Te Naa unnepu mayohona.” ");
INSERT INTO paoNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Soo John yise ka Te Pabe'e baa-wi matzaka. Ka Te Pabe'e batzebuegena soo Te Naa Besa Pooha pa'anakwana kwe'na'a tubongo yotse punoonooeke-kwa'ne manegese oonaga mani petu. ");
INSERT INTO paoNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Soo Te Naa pa'anakwana yadooase mee unne, “Esoo Nuga Besa Tooa, nu-kwa'ne'yoosoo. Nu unu a soopedyana besa ma-matoo soonamme.” ");
INSERT INTO paoNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Soo Te Naa Besa Pooha ka Te Pabe'e sukwe oona numu-wanatoo taya oo nanesootuhi tuunguna. ");
INSERT INTO paoNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Soo Suta'yoo yise suda oo too'e nemadunaga'a. Watsu mano (40) tooi petuga nanesootuhina gi hemma tukana. ");
INSERT INTO paoNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ka saa'a yise soo Suta'yoo ka Te Pabe'e meeoo too'e netamma, “U sakwa nasootza'me ka Numu Manumudoopu Tooa'ana. U sakwa ka eka tupe tukaba mayugwese ka tsuayina a tuka.” Soo Te Pabe'e gi oo soonakabetseana, meeoo oo sukwe netamma, ");
INSERT INTO paoNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","“Soo E Naa meeoo unnepu, ‘Soo tukapu suu'mu nadukana gi numu magwetzoi-wa'ne'yoo. Ka Te Naa unnepu suu'mu nakabetseana mu numu namagwetzoikwu.’ ” ");
INSERT INTO paoNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Soo Suta'yoo yise ka Te Pabe'e oona Jerusalem-witoo pabow nobe, pukwi mu numu nanesootuhi-kwitoo bikea. Pa'atse'e ka pabow nanesootuhi nobe-kooba oo bi petugase ");
INSERT INTO paoNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","yise meeoo oo netamma, “U sakwa nanasookwugi manena ma-kooba'yoona nadawunihoo u ka Numu Manumudoopu Naa Dooa mee unnena. U gi namaniyaha-wa'ne'yoo ka u Naa u-kooba tueya'e. ‘Soo U Naa ume pumme tummatzidu toha kakasa-gakoo u-kooba tueya'e tuungukwu, umu pa'akoosoo u-gwuuhookwu.’ ” ");
INSERT INTO paoNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Soo Te Pabe'e yise meeoo oo netamma, “Nu gi ume unnena nakabetsea-wa'ne'yoo, soo Te Naa mooasoo meeoo unnepu, ‘Tamme sakwa gi ka Te Naa tooe hownnekoo tooe mapoonnepana, ha'oo sakwa oosoo mani mee sokwamadu-kwa'ne.’ ” ");
INSERT INTO paoNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","9","Soo Suta'yoo yise tuwazoo oo bi ka oona pa'a kiba-matoo petugase, mu no'obatusoo nana'atakoosoo numu ka teepu-koobatu oo tzapoonnekute. Soo Suta'yoo yise meeoo tuwazoo ka Te Pabe'e netamma, “O'nosoo nuka mu numu yaa teepu-koobatu moohe tuungu, umu yise no'yoona e nakabetseakwu. U ka nu-matoo nanesootuhina, nu ume mu nakabetsea tuungukwu.” ");
INSERT INTO paoNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Soo Te Pabe'e ka sutakoo meeoo netamma, “Nu gi u-matoo nanesootuhi-wa'ne'yoo. Soo Te Naa mee mooasoo tubotugupu, ‘Tamme sakwa ka Te Naa-matoo suu'mu nanesootuhi. Tamme sakwa ookow suu'mu nakabetsea.’ ” ");
INSERT INTO paoNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Soo Suta'yoo yise ka Te Pabe'e too'e nepetukuse oo soomabanase, oo-baa'yoo meahoo. Yise Te Naa tutummatziwabe, mu toha kakasa-ga'yoo oo-baa wupetuhoose, ka Te Pabe'e tummatzi. ");
INSERT INTO paoNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","16","Soo Te Pabe'e ka John nakwutamase oo nakase, ka teepu Galilee-witoo kodyuka. Ka Nazareth-wi nobe-ga pana ka Capernaum mee naneadu-witoo nowu'a. O'nosoo soo Te Naa yadooawabe Isaiah mee naneadu ka Te Pabe'e manekwuna mee botugupu. “Mu numu ka Capernaum-wi nonobe-ga'yoo uga gi Te Naa unnepu nakasopedakwatoodu. Wunametoo gi ka Te Naa unnepu naka pana meno'o yise umu Te Naa unnepu nakasopedakwadoose Te Pabe'e-wi tunaka'oedyukute.” ");
INSERT INTO paoNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Yaa manakwana soo Te Pabe'e yise mu numu ka Te Naa-witu nanesootuhi tunedyooekooha, mee yise mu netamma, “Mu sakwa ka sutakoo gi nakabetseapana, ka besa'hoo podo meadabe, o'no soo Te Naa no'oko pumme naka'oedyukudu sootuhikwu.” ");
INSERT INTO paoNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Waha'yoo nawanga'a pakwegana, mu Andrew-no Simon Peter mee nananeadu. Umu ka puma tu tuukwina ka banunadu-witoo wukwazuyakwe, soo Te Pabe'e ka pakumi meana mu poonnese meeoo mu netamma, ");
INSERT INTO paoNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","“Mu sakwa nu-no memease e tummatzimo. Nu mu tunedyooena mu e nakatzimokwu, o'no mu numu nu-kwitu naka'oedyukukwu.” ");
INSERT INTO paoNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Umu nawanga'a yise ka puma tu tuukwina ma'wuoogase yaa manakwana ka Te Pabe'e nakatzimodu manegakwu. ");
INSERT INTO paoNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Umu-tzage'e waha'yoo nawanga'a James-no John ka tu naa Zebedee mee naneadu-no punno'o oona sake-wi'yoona ka puma tu tuukwina mabetsabedyakwe. Soo Te Pabe'e ka banunadu kumi meadabena mu poonnegase mu nawanga'a bi. ");
INSERT INTO paoNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Umu yise ka tu sake noko tu naa ma'wukase ka Te Pabe'e-no memeahoo. ");
INSERT INTO paoNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Soo Te Pabe'e yise no'oko ka teepu Galilee mee naneadu-kooba'yoona no'oko mu tuoegoedu mabesakumena, yise mu nanesootuhi-wi'yoona tuwow mu numu tunedyooemena mee mu netamma, “Mu sakwa ka Te Naa naka'oedyuku, pudusoo soo Te Naa puusoo besa mu sootuhikwu.” ");
INSERT INTO paoNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Mana tooe hano tooe numu ka Te Pabe'e-witu naka, ka teepu Syria mee naneadu-witoo tooe. Mu numu tuoegoedu hane petudyakwe, tsoapayidu, ya'ehookayidu, gi yuyutsunga manepu numu tuwazoo. Soo Te Pabe'e yise mu mabesakuyakwe. ");
INSERT INTO paoNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Ewa'yoo numu yise oo nakatzipetu. Mana ka teepu Galilee-witu yise tuwazoo mana teepu Sumu Mano Nogadu-witu, Judea mee naneadu, yise ka Jerusalem mee naneadu-kwitu, ka hooodu Jordan mee naneadu ooenapatu numu tuwazoo ka Te Pabe'e-baa petudyakwe. ");
INSERT INTO paoNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Soo Te Pabe'e ewahoo numu pu-baa petudyidu poonne ka nanaewasoo mu manemena. Ka oonahoo po'woa-matoo mease, o katuse numme pumme nakatzimodu ");
INSERT INTO paoNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","putzage'e petuse ewow numu pumme nakapunne soo Te Pabe'e ka mu numu nanesootuhi tunedyooena mee unakwe, ");
INSERT INTO paoNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Tamme ka Te Naa sookwina oo sopedakwadoona tamme besakoo nasootuhikwu. Soo Te Naa puusoo te nemadunagakwu. ");
INSERT INTO paoNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Tamme ka yaa teepu-kooba'yoona suda te tumatuguna nemowunise, o'no suu'mu besa nasootuhikwu. Soo Te Naa besa te masokwamakukwu. ");
INSERT INTO paoNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Tamme besa'yoona ka gi nidyupuna, tamme nasootuhikwu. Saa'a soo Te Naa ka teepu besasoo matabuese, tamme gi moobegwaga oo-koobakwi gwetzoimokwu. ");
INSERT INTO paoNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Tamme nasootuhikwu ka Te Naa tubetse naka'oedyukuna. Soo Te Naa oe te tummatzikwu, ka besa pumme te nakabetse'a. ");
INSERT INTO paoNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Tamme ka kukumma'akoosoo numu tutuha sooyugwena besa nasootuhikwu. Soo Te Naa punno'o tamme tutuha sooyugwekwu. ");
INSERT INTO paoNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Ka Te Naa-tamme besa tusooyugwena tamme nasootuhikwu. O'no tamme ka Te Naa sopedakwadookwu. ");
INSERT INTO paoNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Ka nanakukumma'akoosoo numu nanapua'a neyugwena, tamme nasootuhikwu. O'no tamme Te Naa-wa'ne'yookwu. ");
INSERT INTO paoNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Ka Te Naa te nakabetse'a mu numu ka suda te matuguna, tamme nasootuhikwu. O'no soo Te Naa no'oko nasootuhipu tamme tu tuukwegapu ma te sootuhikwu. ");
INSERT INTO paoNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Mu ka mu numu mumme gi petzabena gi too mu-no mu napua'a, nanasuda nu-koobatoo esayina, mumme suda mu netamma sapa, gi suda sokwamapana, mu besa nasootuhikwu. ");
INSERT INTO paoNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Mu sakwa besa sokwama soo Te Naa saa'a ka tu yadooawabe-kwa'ne mu sootuhidooa, ka pu-baa mu petugase. Mu numu o'nosoo manakwana ooosapa ka Te Naa yadooawabe suda matugu. ");
INSERT INTO paoNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Soo ongabe puu ka tukapu besa makamakute, tamme tutunaka'oedyukudu mu numu besa-tamme moohekwu. Soo ongabe ka tu kamana kadoo'ookoo gi he-toogoo besa'yoo, oosoo yise nahanekwunikwu. Ooosoo tamme punno'o ka gi mu numu tummatzina ka gi kamadu ongabe-kwa'ne tamme gi he-toogoo besa'yoo. ");
INSERT INTO paoNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Tamme sakwa numu kootabuakudu-kwa'ne manepunne. Soo kootabuadu ka giba-ma'yoona puu kwinga'yoopana mesoo napoonne. ");
INSERT INTO paoNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Soo tukootabuakunoo ka paa'a'yoona kwinga'a-kwitoo mesoo kootabuakute. Soo numu nobe-kwitu puu ka kootabuapunnena numu no'oko hemma mesoo poonne. Gi soo numu ka tukootabuakunoo-kooba hemma hane. ");
INSERT INTO paoNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Yooonnekoo ewa'yoo numu ka besa manena, ka tukootabuakunoo-kwa'nesoo, o'no yise mu numu ka Te Naa netubetse'yikwu. ");
INSERT INTO paoNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","‘Soo Te Pabe'e ka te mooa tumayohope gi he-toogoo mayugwe,’ mee sumuna na'unnekwu. Pana soo Te Naa no'oko eka nabodu togesapa e mayugwe tuungu, gi kadoo'oo mu nemayugwe. ");
INSERT INTO paoNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Nu mu tuukwekwu, soo Moses ka o'nosoo umu te nanamooatupu oo tuukwepu no'yoona kaaheno manekekwu. Oosoo gi atasoo mane-wa'ne'yoo. ");
INSERT INTO paoNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Soo tooe haga tooe gi ka a nabotuguna nakabetseadu, tamme tu netammana, yise ka mu numu gi ooka nakabetsea tuunguna oosoo gi hee manekwu, ka Te Naa tamme oo nemadabue-wi oo manepetuse. ");
INSERT INTO paoNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Tamme sakwa unu tunakabetsea, ka umu nanesootuhibu numu tunedyooedu, ka mu nanesootuhidu-nagatu Pharisee mee nananeadu oooonakwasoo. O'no yise soo Te Naa te sootuhikwu. ");
INSERT INTO paoNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Umu te nanamooatupu mee te tuukwedu, ‘Tamme ka numu batsase, soo numu nehanedu sakwa punno'o te mesoo batsa.’ ");
INSERT INTO paoNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Pana nu mu tuukwekwu tamme ka te pua'a sutakuna tooetoo oo nesootzemana, te tuma'emukwana saa'a tamme matusoo kodyukwu. ");
INSERT INTO paoNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Tamme mooasoo yaa ka pabatsekoo nanesootuhi nobe-kwi petugonnose, ka Te Naa-matoo nanesootuhikwu. Tamme yise ka suda te pua'a te matuguna soomayuhoose ");
INSERT INTO paoNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","besasoo ka te pua'a-no hemma nemadabuese, yise o-no ka Te Naa-matoo nanesootuhikwu. O'no yise tamme besa nasootuhikwu. ");
INSERT INTO paoNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Tamme ka numu sudu matuguna soo numu ka numu nehanedu-kobenatoo te bikwuse tamme sakwa oo pua'adoo togesoo meadabena. ‘Ta sakwa oo soomu'wa,’ mee oo netamma. Tamme ka gi oo pua'agana, ka tunehanepe-wi petugase oosoo tamme-witu suda ka numu nehanedu-kobena'yoona te nemadabuekwu. Soo numu nehanedu yise ka mu tukwutumadu tamme wutuma tuungukwu. ");
INSERT INTO paoNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Tamme yise nakwutumatugukwu, ka tamme tu tunekwina te mamakwu-kwitootooe, mee'e nu mu tuukwe. ");
INSERT INTO paoNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Umu te nanamooatupu putoogoo tumayoho meana o'nosoo mee te tunetammakupu, ‘Tamme sakwa gi nanakukumma'a-nosoo nanapotammapana.’ ");
INSERT INTO paoNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Nu mu tuukwekwu tamme sakwa gi te pupua'a nodukwa-no tooe how tooe manepana, tamme tookwa mooasoo te soonamme-kwi suda tusooyugwe ka oo manena. ");
INSERT INTO paoNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Nu sakwa puu ka tumadinakwatu e pooe tzatsebooase oo takwasukwuni ka ookahoo suda nuka mayugwe. Tooe nu sumusoo pooe-gana natukuse sapa gi ha'oo, o'no gi no'yoona e tookoo ka nidu-kwitoo natzakwunikwu,” mee'e soo Jesus e-makoo te tunenagakute. ");
INSERT INTO paoNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","“Nu sakwa ka tumadinakwatu e mi tseka'ase oo wuni ka suda oo-ma tumatuguna. Tooe nu ka sumusoo mi-gapana gi ha'oo ka sutakoo e mi kadoo'oo mayugwese gi no'yoona e tookoo natunikwu. ");
INSERT INTO paoNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Soo te tumayohope meeoo, ‘Tamme sakwa ka nupoonnekwunikwuse oo botuguna oosoo gi hownne'yoo tamme ka te nodukwa-no napoonnekwunikwuse.’ ");
INSERT INTO paoNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Pana nu mu tuukwekwu tamme sakwa ka nodukwadoose gi te nodukwa poonnekwunipana, tamme tuma'emukwa ka oo poonnekwunise. Soo te nodukwa ka kumma'akoosoo pootammana, tamme oo mesoo poonnekwuni. Tamme sakwa gi a napoonnekwunina mogo'ne nodukwadoopana. ");
INSERT INTO paoNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Umu te nanamooatupu mee tuwazoo te tunedyoo'e, ‘Tamme sakwa ka Te Naa-makoo meesoo tunedyahana, ka namano hayu te unnese, tamme oo-toogoo manekwu.’ ");
INSERT INTO paoNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","37","Ka oo wahana, kaaheno oo waha, mee'e nu mu netamma, o'no mu numu besa mu sooyugwe. Yaatusoo hemma mamanepunne-makoo gi tunedyahapana. Yise gi too Te Naa manepunne-makoo tunedyahapana. Gi too tamme tammesoo nanedyahapana. No'okoo hemma, soo Te Naa matabuepu, no'yoona hee oo-tooha manepunne. ");
INSERT INTO paoNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Umu te nanamooatupu ooosapa mee te tunedyooedu, ‘Soo tooe haga tooe ka tu pua'a pooe tsetzatseboogese, oogow pooe sakwa punno'o natsetzatsebooge. Ka e tamma nadosawekuse, oogow tamma sakwa punno'o nadosaweku.’ ");
INSERT INTO paoNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Nu mu tuukwekwu tooe suda tamme tu matugu sapa, tamme sakwa gi umu-no nagoepana. Ka sumunakwatu te soba namatake'ehoose tamme sakwa oo sukwe tutzomunaku. O'no oosoo ka sumunakwatu matake'ehookwu tuwazoo. ");
INSERT INTO paoNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Tamme sakwa ka gi hownnekoo mu numu tumanagakuna, oosoo ka te kwasu gwuuse sapa, gi hownne'yoo. ");
INSERT INTO paoNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ka tooe haga tooe hemma tamme mu tzagwuhu tuungu-tzage'etoo sapa, tamme sakwa kwinga'atoosoo ooka oo tzagwuhukuka. ");
INSERT INTO paoNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Ka mu numu hemma tamme mu natuungu, tamme sakwa mu gea. ");
INSERT INTO paoNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Mu ka sumuna o nakadu ka o'nosoo mu numu meeoo unegayakwe, ‘Tamme sakwa te pupua'amu soobedyana ka tamme wohonedu gi petzape.’ ");
INSERT INTO paoNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Pana nu mu tuukwekwu tamme sakwa ka tamme wohonedu soobedya, too'e gi tamme mu soobedya sapa. Ka tamme mu nekusedya, tamme sakwa nanesootuhi besow umutoo nekwina. ");
INSERT INTO paoNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","O'no tamme ka Te Naa-wa'nesoo ka no'oko numu, tooe mu sutakoo sapa nanakwa'nesoo mu matugu. Soo Te Naa ka taba umu-koobatoo tsebooedu mada'e, ka powmabu tuwazoo. ");
INSERT INTO paoNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Soo Te Naa gi besa te sootuhi-wa'ne'yoo ka mu numu tamme-too besa'hoo suu'mu besa nanamatukuna nanasoobedya. Mu suta'yoo numu punno'o ka besa tu namatuguna soobedya. ");
INSERT INTO paoNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Tamme gi besa manakwe ka tamme pupua'amu suu'mu besa yadooena. Mu gi tunaka'oedyukudu puu besa mesoo nanapua'amu-ga'yoo. ");
INSERT INTO paoNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Tamme sakwa ka Te Naa, te pa'anakwatu-kwa'ne'yoo, no'obatusoo numu besa soobedya. ");
INSERT INTO paoNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Tamme sakwa gi naanamanepana, gi ooosapa numu poonnena suu'mu besa numu matugupana. Soo Te Naa te pa'anakwatu, besa te sootuhikwu ka gi nasootza'mena ooosapa besa te manakwe. ");
INSERT INTO paoNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Ka mu tutuha manedu te maka-kwa'ne, tamme sakwa gi numu tuukwepana ka tooe hano'yoona tooe oo manekwuse. Umu nanetzamedu numu ka Te Naa nakabetse'a mee nane'yugwedu suu'mu, oo manakwe. Umu ka mu tutuha manedu numu maka nobe-kobena'yoona, tooetoo nanesootuhi nobe-kwi'yoona mu numu maka, o'no mu numu mu poonnekwu. Mu numu mooasoo meeoo mu tuukwe, ‘Soo Te Naa mu sootubetsea'yi,’ pana ka numu koobena'yoona oo mu manakwe yise, ‘Umu besa manakwe,’ mee soo Te Naa gi mu netamma-wa'ne'yoo. ");
INSERT INTO paoNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Tamme sakwa mu tutuha manedu watzemaka. Gi sakwa haga oo sopedakwatoopana ka oo te manakwe, tooe te besa pupua'amu pana. ");
INSERT INTO paoNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Soo Te Naa te sootuhikwu, ka mu tutuha manedu te watze tummatza'e, ka te sopedakwadoona. ");
INSERT INTO paoNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","6","Tamme sakwa mana'yoona gi numu tamme poonne-kwi'yoona watze nanesootuhi gi namanasootza'me numu poonnena'yoona. O'no soo Te Naa toge manakwe mee te netammana, te sootuhikwu. Susumudu mu numu tunaka'oedyukudu mee nane'yugwedu nasootza'me, ka Te Naa-matoo papabatse nanesootuhina ka nanesootuhi nobe-kwi'yoona yise ona mu numu nonobe-kobena'yoona, tuwazoo. Mooasoo mu numu meeoo mu netamma, ‘Mu kaaheno manakwe,’ pana soo Te Naa gi mu sootuhi-wa'ne'yoo. ");
INSERT INTO paoNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Tamme sakwa gi sumu-kwa'nesoo u'na'wepana ka gi oo nakasopedakwatoona. Mu numu gi Te Naa-wi tunaka'oedyukudu oo manakwe. Umu meeoo sokwama numme ka ewa unnena numme nanakabetseakwu mee. ");
INSERT INTO paoNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Tamme sakwa gi ooosapa Te Naa ewasoo sumu-kwa'nesoo tuukwedyipana mooasoo soo Te Naa oo sopedakwatoo tooe gisoo pumme te tuukwe'e sapa. ");
INSERT INTO paoNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Mee sakwa no'yoona numu nanesootuhi. ‘U, Ne Naa ne pa'anikwatu u tubetse besa'yoo. ");
INSERT INTO paoNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","U no'oko numme-kooba poohakatudu. Numme no'oko numu yaa teepu-koobatu ume mu nakabetseana soogwa'e, ka u-baatu-kwa'nesoo. ");
INSERT INTO paoNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Nonotsa tu tabemea-kwi besa ne sootuhi. ");
INSERT INTO paoNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Ka ne tuma'emukwana soomu'wana, ka mu numu suda numme matugu numme puu oo soomu'wa. ");
INSERT INTO paoNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ne matzino, kaaheno ne mayugwe. O'no numme besa-kwitoo tsebooe petugakwu.’ ");
INSERT INTO paoNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Ka mu numu suda tamme matuguduna oo soomu'wase, o'no Te Naa, te pa'anakwatu punno'o oo soomu'wakwu ka suda te manakwe. ");
INSERT INTO paoNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Pana tamme ka gi oo soomu'wuna ka numu suda tamme matugu, Te Naa, Te pa'anakwatu punno'o gi oo soomu'wa-wa'ne'yoo ka suda te tumatugu. ");
INSERT INTO paoNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","17","Tamme ka te nanesootuhina manekuna gi nasootza'mepana ka gi tukapu tukapana nanesootuhina, tamme sakwa besa sokwamana besa namabetsea. Mu numu tunaka'oedyukudu mee naneyugwedu puu nasootzamena gi namabetseana suda sokwamadu-kwa'ne tabuamo'o. Mu numu mooasoo, ‘Umu toge manakwe,’ mee mu netamma, pana soo Te Naa yise gi oo manedu sootuhi-wa'ne'yoo. ");
INSERT INTO paoNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Tamme ka watze tukana nanesootuhina, soo Te Naa mooasoo gi te watzekute, ka mooasoo te sopedakwatoona besa te sootuhikwu. ");
INSERT INTO paoNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","20","Tamme sakwa ka Te Naa tamme sootuhikwuna ooosapa soogwipunne. Tamme ka oo-matu mease saa'a oo-baa'yoona soo Te Naa ooosapa besa te sootubetsea'yina ewa te nenagakwu. Tamme sakwa gi yaa teepu-koobatoosoo hemma te heegana mu numu unu nenagana soogwipana, gi ka teepu-koobatoo hemma ka Te Naa oooonakwa nenagapana. Umuoo ooonne'yoo kadoo'oo sukwe manepetugadyidu: susumudu natzasoo'adu, susumudu yungusanadooadu, susumudu natuduhatsasooadu. ");
INSERT INTO paoNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Soo unu te nenagapunnena ka Te Naa-baa gi kadoo namayugwedu, gi tuwazoo natutuhatzasooadu. Soo te pewu yise ooosapa ka unu te nenagapunne-kwi manepunnekwu. ");
INSERT INTO paoNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Soo te pooe tukootabuakunoo-kwa'ne'yoo. Tamme ka besa yaatu poonnena suu'mu tamme besa'yookwu, pana tamme ka sutakoo poonnena suta tusooyugwekwu. Tamme ka unu tammesoo besa tusooyugwena nasootuhikwu. ");
INSERT INTO paoNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ka tooe hemma tooe sutakoo soohanena ooosapa togano-kwi manepunne. Tamme ka waha-tamme tusooyugwena ooosapa ka togaba-witu-kwa'ne'yookwu. ");
INSERT INTO paoNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Gi tamme waha-tamme tusooyugwena tamme gi waahoo nakabetsea-wa'ne'yoo sumu-no'okwisoo, tamme sakwa ka Te Naa nakabetsea, gi sakwa tamme ewahoo hemma nananenagadu suu'mu te heegakwuna soogwipunne. Tamme puu gi nanokwisoo waahoo numu moohedu nakabetsea-wa'ne'yoo. Tamme sumuna sumuhoo besa soobedyana ka sumuoo gi petzabekwu. ");
INSERT INTO paoNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Nu mu tuukwekwu mu sakwa gi nasootookepana gi suda nasooyugwewunupana ka tukapu mu kutuugekwuna, ka baa mu heebena mu tuugekwuna, ka wunapu pukwi mu namasooakwuna mu tuugekwuna. Soo Te Naa ka gwetzoibu te sootuhikwu. ");
INSERT INTO paoNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Tamme sakwa ka mu hootseba'a soohanena umu puu gi hemma ha'oo yugwepana tu tukana ma'yu ka Te Naa pumme mabetse'a. Tamme puu mu hootseba'a oooonakwasoo nadatsungadu. Soo Te Naa suu'mu puu no'oko te mabetsea tuwazoo ka kwinga'atoo te gwetzoimokwuna. ");
INSERT INTO paoNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Tamme gi hownnekoosoo tammesoo kwinga'atoo te gwetzoimokwuna mada'e tamme sakwa yise gi ka tukapu te tuuge-kwitoo suda soonammekupana. ");
INSERT INTO paoNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Tooe ka wunapu pukwi mu namasooakwuna tuugepana gi oowetoo suda nasooyugwepana. Mu tonegea'a puu tubewabe-kwi naadu. Tooe umu puu gi hemma nakoobatoo matabuepana besa tatabu'a. ");
INSERT INTO paoNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Umu tonega'a ka Jew numu-kooba katudu Solomon mee naneadu kwasu oooonakwa besa tatabu'a. ");
INSERT INTO paoNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Soo Te Naa umuoo tonegea besa tatabua matabue, tooe yabesoo mu takwasuhookwuse sapa. Tamme sakwa ka ooka Te Naa tamme mabetseadu nakabetsea. ");
INSERT INTO paoNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Tamme sakwa yise gi suda sokwamapana ka ha'oo tukapu natoogoo tuugena tuwazoo baa natoogoo te tuugekwuna too'etoo ka wunapu pukwi te namasooana te tuugena tamme sakwa gi suda sokwamapana ");
INSERT INTO paoNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","ka umu gi tunaka'oedyukudu-kwa'ne umu puu gi hekwitoo sapa suda nasooyugwe. Mooasoo soo Te Naa te pa'anakwatu tamme-koobatoo te sopedakwadoo, puma te gwetzoina te sootuhi. ");
INSERT INTO paoNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Tamme sakwa ka Te Naa besa te nakabetseakwuna unu soogwi. Oosoo yise no'oko hemma puma te gwetzoina te sootuhikwu. ");
INSERT INTO paoNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Tamme sakwa yise gi suda oo sokwamakupana, ka saa'a hemma manekwuna. Tamme mooasoo togekoo suda namanatsa'yana oosoo puusoo oo-toogoo manemeana nasoomu'wadu. ");
INSERT INTO paoNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Tamme sakwa gi tunesootzimapana, gi tuwazoo suda numu netammapana, o'no soo Te Naa besa te sooyugwe. ");
INSERT INTO paoNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Tamme ka mu tummatzina, soo Te Naa oogow punowsoo te makodyukukwu. ");
INSERT INTO paoNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","4","Tamme sakwa gi te pua'a nesagwikupana, ka sagwane oo tuma'emukwase. Tamme sumuna ookowsoo tuma'emukwa. Hownnekoo yise mu ka mu pua'a pooe-wikoo tuutsekoo hemma mesoo poonne ka mummesoo pooe-wikoo hemma pabatsekoo katu sapa? ");
INSERT INTO paoNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Mooe'ugasoo mu sakwa mummesoo pooe-witu tzatsebooase, o'no mu yaatu poonnena, ka mu pua'a mesoo tummatza'e. Ooosoo sakwa mu ka suda mu tumatuguna yugwese, o'no mu ka mu pupua'amu mesoo tummatzi. ");
INSERT INTO paoNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Tamme sakwa ka mu numu gi tamme nakabetseadu, gi ka Te Naa besa unnepu tuukwepana. Umuoo ka Te Naa besa unnepu gi heesoobedyana, gi hemma sootubetseyi. ‘Oosoo gi hee,’ mee umuoo numu sokwamana te nekusegeakwu. ");
INSERT INTO paoNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","8","Tamme ka oo soogwina, nanetsagwayina, o'no tamme ookow nasootuhikwu. ");
INSERT INTO paoNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Ka mu tooa'a tukaba nekwa'e, mu puu gi tupe oo gea-wa'ne'yoo. ");
INSERT INTO paoNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ka pakwe oo nekwa'e, mu puu gi togogwa oo gea-wa'ne'yoo. ");
INSERT INTO paoNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Tooe tamme gi totoge'yoopana puu te dooamu besa matugu, soo Te Naa yise tamme besa matuguna te sootuhikwu. ");
INSERT INTO paoNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Tammesoo besa namatugu-kwa'ne sakwa tamme besa numu matugu. O'no yise tamme no'oko ka Te Naa tamme tunetammakuna mayohokwu. ");
INSERT INTO paoNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Tamme sakwa ka Te Naa besa podo meadabe, oosoo unu nameana tuutze hano'yoo, pana soo suta'yoo po paba hano'yoona suta-kwitoo name'a. Ewa'yoo numu ka sutakoo po nake. ");
INSERT INTO paoNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Pana soo Te Naa besa po tubetse nagwetzoidu-kwitoo name'a, gi moobegwa-ga'yoo. Oosoo tuutze hano'yoona huutse'yoo numu ekow nage. ");
INSERT INTO paoNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Tamme sakwa mu esagoedu numu, mu Te Naa yadooawabe mee nane'yugwedu gi naka'oedyukupana. Umuoo nunu'u-wa'ne'yoo numu kadoo'oo mayugwedu, too'e besa'yoo mee nane'yugwepana. ");
INSERT INTO paoNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","17","Mu ka mu ooonnekoo numu sopedakwadookwu ka suda mumme mu matugu-makoo. Tamme puu wuyupooe gi tsa'abu-makoo wuta'ne-wa'ne'yoo, wuyupe-makoo suu'mu. ");
INSERT INTO paoNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","No'yoona soo hee namasuadu tu pooe-kwa'nekoosoo suakute, susumudu besa'yoo, susumudu suta'yoo. ");
INSERT INTO paoNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Soo tsa'abu sutakoo pooe-ga'yoo gi pumme tuka-wa'ne'yoo, gi he-toogoo besa'yoo nuubetakwunina natuna'e. ");
INSERT INTO paoNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Susumudu numu eka sutakoo pooe-gakoo tsa'abu-kwa'ne'yoo mu tumatugu-makoo umu nasopedakwatoo ka gi he-toogoo besa'yoona. ");
INSERT INTO paoNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Umu Te Naa nakabetseana oo tubetse naka'oedyukudu suu'mu oo-baa petugakwu, gi umu Te Pabe'e nakabetseadu, mee naneyugwedu. ");
INSERT INTO paoNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Ka e kodyu petuse ewa'yoo numu mee e netammakwu, ‘U yow E Pabe'e. Nu ooosapa u unnepu mu numu tuukwedu. Nu mu tsoapa nematzagakwuni, ka mu tsoapagoedu-makoo. Nu ewa nanabesa tumadabuegena, u pooha-toohakwi.’ ");
INSERT INTO paoNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Pana nu mee mu netammakwu, ‘Mu gi nu-notu, gi nu-tsage'yoopana mu ewa numu nemooaga. Ooonne'yoo nu mu ta'ya.’ ");
INSERT INTO paoNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Ka besa e naka tumayohokudu puu nu tuukwekwu. Tupe besa nobetoodu-kwa'ne'yoo, oosoo puu ohobudu gi namanubue oo matabue. ");
INSERT INTO paoNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Tooe ka baa unu hoo'oo ka teepu putoohakwitu patokwenawunu sapa gi ano'a, oosoo ka besa namadabuepuna. ");
INSERT INTO paoNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Mu numu ka e unnena gi oo nakatumayohodu, ka nana tu nobe teepu-kooba oo sukwe matabuedu-kwa'ne'yoo. Soo oo nobe-toona ka baa unu hoo petuse patadyoomowkwu. ");
INSERT INTO paoNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ka tu powma petuse ka baa unu hoo'oo, unu tu hukwa petuse soo nobe gi besa namadabuena wunapowkwu tubetse paba suda unni petuse, gi hee nabena'e.” ");
INSERT INTO paoNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","29","Ka Te Pabe'e yadooamakwuse mu numu mee nananetamma, “Numme gi meeoo na'unnedu nakadu. Soo Te Pabe'e tubetse besa ka Te Naa unnepu-witu wahadyakwe, gi ka umu te nedyooedu-kwa'ne.” ");
INSERT INTO paoNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Soo Te Pabe'e yise ka giba-ma'yoona wuegena, ewa'yoo numu oo-ma tzabehooke. ");
INSERT INTO paoNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Sumu'yoo nana tookoo uayidu ka Te Pabe'e tuukwese nama oo pooha-matugu tuungu. ");
INSERT INTO paoNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Soo Te Pabe'e Jesus yise oo-ma pooha matuguse mee oo netamma, “Nu u mabesakukwu. ");
INSERT INTO paoNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","U sakwa ka mu numu nanesootuhikudu petuse, ka meno'o besa u manepu o tzapoonneku yise ka Moses tamme tunetamma-wa'nesoo Te Naa pooha tuwunikuse. Mu tzapoonneku ka u tookoo uayina namabesakuna. Pana gi ka mu numu tuukwepana ka ume e mabesakuse.” ");
INSERT INTO paoNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Soo Te Pabe'e yise ka Capernaum mee naneadu-wi petugase sumu'yoo mu tukwutumadu moohedu-matu, tubetse wawa'a, oo-baa petuse, meeoo oo netamma, “U sakwa e tummatzi. ");
INSERT INTO paoNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Soo tooebetse nuka tummatzidu gi yutsunga manepu oona e nobe-wi, unu nuummaba wumana. Nu ookahoo u mabesakukwuna sookwa'e.” ");
INSERT INTO paoNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Soo Te Pabe'e yise meeoo oo netamma, “Nu sakwa too'e oo mabesakuhoodooa.” ");
INSERT INTO paoNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Soo tukwutumadu moohedu yise meeoo oo netamma, “Nu gi mu-matu numu, mu Jew numme wakwawa'a nuutumooedu, tooe u gi nuga nobe-kwitoo kemmapana gi hownne'yoo. Nu oo sopedakwadoo u sakwa oo sukwe yadooese, soo e tummatzidu besa mane. ");
INSERT INTO paoNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Nu tuwazoo oo sopedakwatoo ka numu nu-toohatu puu nuka nakabetse'a, nu ka meeoo mu netamma'yina, ‘U sakwa mea,’ oosoo yise meahooyakwe. Nu ka mu bihooyina, mu yise numatoo kemmayakwe. Nu ka nuka tummatzidu mee netammana, ‘U sakwa yoo mane,’ oosoo yise e nakabetseayakwe.” ");
INSERT INTO paoNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Soo Te Pabe'e yise ka oo unnena nakase, ka mu numu meeoo netamma, “Yow yise soo tubetse tunaka'oedyukudu. No'oko ka mu Jew numu oooonakwasoo unu tunaka'oedyukute. ");
INSERT INTO paoNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","No'obatusoo numu tooe hanotutooe ka Te Naa-baa petuga ka oo ewa tukano'o, o'nosoo umu Te Naa nanayadooawabe: Abraham, Isaac, tuwazoo Jacob mee'e nananeadu ono onokwu. ");
INSERT INTO paoNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Tooe mu Jew numu yisetu, mee nanasoobedyadu gi oe'yookwu ka gi tunaka'oedyukuna. Umu togabu-witoo nakwuma'anakwunina, yise ooosapa sakwikwu, soo suda mu tumuduguna yise umu-matoosoo kodyukwu.” ");
INSERT INTO paoNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Soo Te Pabe'e yise ka tukwutumadu moohedu meeoo netamma, “U nobe-witoosoo mea. Nu mooasoo ka u tummatzidu mabesakupu, u ka tunaka'oedyukuna.” ");
INSERT INTO paoNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Soo Te Pabe'e yise ka mu nanesootuhimakwuse oe'yoona mease, ka Simon Peter-baa petuga. Soo Simon Peter yahe peawabe unu tuoeya'ena oo tookoo udutuna onahoo hape. Umu o nobe-witu ka Te Pabe'e oetu tuukwe'e. Soo Te Pabe'e ka peawabe-matoo mease, ");
INSERT INTO paoNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","oo mi-kooba matuguse oosoo besa mani. Oosoo peawabe yise yotseoose, mu tugoomahanekuhoose, mu tuka tuunguhoo. ");
INSERT INTO paoNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Oogowsoo yongona ewa'yoo tuoegoedu numu ka Te Pabe'e-baa nabi petudyakwe, tsoapagoedu tuwazoo. Oosoo umu-ma pooha matugumese no'oko mu tuoegoedu numu mabesaku. Soo Te Pabe'e ka tsoapa nematzagukwuniyakwe. ");
INSERT INTO paoNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","O'nosoo soo Te Naa yadooawabe Isaiah mee naneadu mee tuukwe yoo namanekwu mee tubotugu, “Soo Te Pabe'e te mabesakukwu ka te tuoego'e.” ");
INSERT INTO paoNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Soo Te Pabe'e ka mu numu tu na'oonnakwi ewa manemena mu poonnena, yise ka numme nakatzimodu ka banunadu oowenapatoo sake-wi mu natsemange tuungu. ");
INSERT INTO paoNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ka ooonnapa petugase, sumu'yoo nanesootuhibu numu tunedyooedu ka Te Pabe'e-baa petuse meeoo oo netamma, “Nu sakwa u-no mea tooe hano tooe u me'a sapa u-no manenumme.” ");
INSERT INTO paoNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Soo Te Pabe'e yise meeoo oo netamma, “U dea'a gi nobe-gakwu. Mu etza'a puu ka teepu-naga to-ga'yoo, mu hootseba'a mu sunngabe-ma nobe-doo pana nu gi nobe-ga'yoo.” ");
INSERT INTO paoNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Sumu'yoo nana ka Te Pabe'e-no manennummedu meeoo oo netamma, “Nu sakwa e nobe-wi mooe nummedooa. E naa ya'e, nu oo mooe nomatugudooase, o'no yise saa'a nu u-no manennummedooa.” ");
INSERT INTO paoNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Soo Te Pabe'e yise meeoo oo netamma, “U sakwa meno'osoo nu-no maneka. Mu gi tunaka'oedyukudu numu gi nuuno manedu saa'a puusoo tu nanumu tutu'ina nanomatugudooa.” ");
INSERT INTO paoNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Soo Te Pabe'e Jesus ka sake-wi tsebooeka ka umu pumme nakatzimodu-no. ");
INSERT INTO paoNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ka banunadu panowmookwi ne manekase unu hukwa petuhoo. Soo baa pabatse'e pakwutiwununa ne sake bakaanoga'a. Te Pabe'e mesoo uwedape. ");
INSERT INTO paoNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Umu oo nakatzimodu oo netupoonne mee unnese, “Uda! U sakwa tuponnese ne magwetzoi. Tamme sumuna badatu'ihookwu.” ");
INSERT INTO paoNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Soo Te Pabe'e meeoo mu netamma, “Gi suipana, mu gi e tubetse naka'oedyukute pana nu mu magwetzoihookwu.” O'no soo Te Pabe'e yise yotsehoose, ka baa noko hukwapa yooi tuunguhoo. Soo pakwutiwununa ka tu hukwamakwuse, punno'o yoo'ihoo. ");
INSERT INTO paoNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Numme Te Pabe'e nakatzimodu mee nananetammamo'o, “Uune! Yow esoo Te Pabe'e, unu pooha-ga'yoo. Soo hukwapa ka baa-no a nakabetse'a.” ");
INSERT INTO paoNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Waha'yoo tsoapagoedu naana ka teepu Gadara mee naneadu-kwi, oonow ka tupe tawaga-kwi nobe-ga'yoo, ka mu tuipu nakoonaga. Gi haga oo-toogoo mea-wa'ne'yoo. Mu naana ka unu susuta'yoona, numu tumaheyakwe no'oko numu kusegeayina. Soo Te Pabe'e ka banunadu natsemangegase oonow umu-tzage'e petuhoogase, ka sake-wi'yoona wuegase, ");
INSERT INTO paoNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","tsoapagoedu naana oo-baa pepetuhooga, papabatse apegeakoohase mee oo netamma, “Gi ne matzamapana. U ka no'okosoo hemma Manumudoopu Dooa. Gi suda ne yugwepana. Saa'a u kadoo ne mayugwekwu, gi meno'o.” ");
INSERT INTO paoNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Gi haa'no umu kwinga'a ewa'yoo hogu to'o. ");
INSERT INTO paoNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Mu tsoapa ka mu nanana-naga'yoona ka Te Pabe'e meeoo netamma, “U ka mu naana-nagakoo ne nemakuase numme sakwa mu hogu-naga mani petuga.” ");
INSERT INTO paoNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Soo Te Pabe'e mu tsoapa mee netamma, “Unudooe mea'a,” mu tsoapa yise ka mu nanana-naga'yoona kuowkase ka mu hogu-naga mani petuga. No'yoona mu hogu namatatanomanese ka bakumana'yoona ka baa-witoo sawehoose no'yoona padatuihoo. ");
INSERT INTO paoNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Mu hogu takonemodu yise ka Gadarea-witoo tatanomanegase, ka mu numu tuukwe petuga, ka mu hogu badatuihoona, yise ka Te Pabe'e ka tsoapagoedu nanana oo mabesakuna tuwazoo. ");
INSERT INTO paoNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Ewa'yoo numu ka Gadarea-wi'yoona kemmase, ka Te Pabe'e-baa petugase, ka Te Pabe'e tayakwuna'e, “Ne tsasoopedya sakwa u,” mee oo netammana. ");
INSERT INTO paoNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Soo Te Pabe'e ka sake-wi tsebooesesoo, ka banunadu pa'oenapatoo punowsoo kodyuka. ");
INSERT INTO paoNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Soo tuoeya'edu gi yutsungu manepu ka Te Pabe'e-baa natzakwu petuga. Soo Te Pabe'e mu sopedakwatoo ka mu naana pu-ma mu nasoonatza'e. Te Pabe'e yise ka gi yutsungadu nana meeoo netamma, “E pua'a, u sakwa besa soonamme. Nu ka u tuma'emukwana soomu'wakwu.” ");
INSERT INTO paoNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Susumudu mu Jew nanesootuhibu numu tunedyooedu meeoo sokwama, “Esoo hayoo suda unakwe. Masoogina ka Te Naa-wa'nesoo nasooyugwena meeoo unnewunu.” ");
INSERT INTO paoNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Soo Te Pabe'e mooasoo oo sopedakwatoo ka mu tusooyugwena yise meeoo mu netamma, “Gi suda tusooyugwepana. ");
INSERT INTO paoNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Mu gi e naka'oedyukute ka mu numu tuma'emukwana e soomu'wa-kwitu, pana mu oo poonnekwu ka eka nana e mabesakuse. ");
INSERT INTO paoNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","7","Mu yise oo sopedakwadookwu nu eka teepu-kooba ookow poohabe hee-ga'yoo, ka mu numu tuma'emukwana e soomu'wakwuna.” Soo Te Pabe'e yise ka nana gi yutsungadu meeoo netamma, “Wunuoose ka u kapa nobe-witoosoo tzagwuuka.” ");
INSERT INTO paoNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","No'yoona mu numu oo poonnese, oo soo'oedyukuse meeoo nana'unakwe, “Te Naa tubetse besa'yoo. Numme nanabesa namanedu yaa tabeno poonne. Te Pabe'e unu pooha-gana tamme-baa petu.” ");
INSERT INTO paoNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Nu Matthew, oonow ka putoogoo numu tzoonooadyikwi katuna numu tunekwidyakwe. Te Pabe'e o meana e poonnese ka o e katu, yise meeoo e netamma, “U sakwa e tummatzi, nu-nosoo manenumme.” Nu yotseoose oo-no meahoo. ");
INSERT INTO paoNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Ka saa'a soo Te Pabe'e e nobe-witoo nu-no mease numme tuka. Ewa'yoo mu numu tunekwidu o, tuma'emukwadu mee mu Pharisee ne ne'a, numme ka ewa'yoona onona ewatuka. ");
INSERT INTO paoNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Mu Pharisee ka Te Pabe'e poonnese numme-no tuka, meeoo yise ka pumme nakatzimodu netamma, “Oosoo Mu Pabe'e sakwa gi mu suda tutumatugudu-no tukapana, mu numu tunekwidu ooonne'yoo.” ");
INSERT INTO paoNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","13","Soo Te Pabe'e ka mu nakase, mee unakwe, “Nu yaa ka teepu-kooba petuse, ka mu tuma'emukwadu Te Naa-witu gi sopedakwadoodu tuukwekwu. Gi nu mu numu mooasoo kaaheno meadu mee nasooyugwedu Te Naa-witu sopedakwadoodu tunedyooekwu. Mu sakwa ka Te Naa unnena natunedyooe ka mee oo unakwe, ‘Nu mu numu besa nanamatuguna umu-makoo sookwa'e, gi tuwazoo nu hemma umu-nakwana sookwa'e.’ Soo pooha-ga'yoo puu tuoegoedu numu-doo suu'mu naba'e, gi ka gi tuooegoedu numu-doo. Nu puu ka mu tuma'emukwadu suu'mu tummatzikwu, gi ka mu besa nasooyugwedu numu.” ");
INSERT INTO paoNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Umu John pupua'amu-matu yise ka Te Pabe'e-baa petuse mee unakwe, “Numme ka mu Pharisee-no gi tukapana nanesootuhiyakwe. How yise umu ume nakatzimodu gi punno'o ooosoo tumatugu?” ");
INSERT INTO paoNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Soo Te Pabe'e mee mu nanekwegea, “Nu togesoo yaahoo umu-no, pudu nodukwadoodu-kwa'ne, umu puu ka nano'yoona besa sokwama. Pana pudusoo nu gi umu-no'yookwu, o'no yise saa'a umu e nakatzimodu gi tukapana nanesootuhidyikwu. ");
INSERT INTO paoNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Ka oohoo a manepunne mu gi hownnekoo ka mu numu pudu tumayohope noko ka mumme putoogoo mooa tumayohope mayua-wa'ne'yoo. Oosoo puu wanapu nadotsana-kwa'ne. U pudu wanapu ka mooa wanapu-ma dotsanase, oosoo gi toge tubuakwu. ");
INSERT INTO paoNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Mu gi hownnekoo eka mumme pudu natunetammakuna ka mu mooa tumayohope noko mayua-wa'ne'yoo.” ");
INSERT INTO paoNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Ka Te Pabe'e togesoo yadooawunu, soo mu nanesootuhidu nemadanagadu oo-baa petugase oo-kobena meatzedose oo nanetzakwiya'e yise meeoo unakwe, “E padu ya'ega'a, u sakwa kemmase oo-kooba pooha matuguse, oosoo sakwa besa mane.” ");
INSERT INTO paoNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Soo Te Pabe'e yise oo-no mea mu tunakatzimodu-no. ");
INSERT INTO paoNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","O'no yise togesoo mu mea'a soo sumu'yoo mogo'ne hoone tuoeya'edu, sumumano wahamatsebooekudu (12) tommo petugapu, ka Te Pabe'e ooonnakwana oo kwasu tzamow, ");
INSERT INTO paoNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","mee tusooyugwena, “Nu ka Te Pabe'e kwasu sukwe tzamowse besa manekwu.” ");
INSERT INTO paoNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Soo Te Pabe'e yise yabesoo oo pooha wumowse oo sopedakwatoo meeoo yise oo netamma, “U mooasoo besa mani, e naka'oedyukuna, besa soonamme.” Soo mogo'ne yise yabesoo puuhamakwu. ");
INSERT INTO paoNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","24","Ka oona Jairus nobe-wi petugase ewa'yoo numu sakwa'e soo Te Pabe'e yise meeoo mu netamma, “Puuwuna'yoopunne, esoo tsua'a gi ya'e, esoo sukwe u'we.” Umu numu oo-ma'yoona sukwe naneko'e. ");
INSERT INTO paoNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Ka mu numu puuwanakoo soo Te Pabe'e ka tsua'a mi-ma tzakaduse oo tzadyota. ");
INSERT INTO paoNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Esoo Te Pabe'e manena yise tooe hano tooe nawaha. ");
INSERT INTO paoNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Ka Te Pabe'e oe'yoona pudu meahoose, waha'yoo gi tutubootabuedu nanana umu-no tzabegease mu-nakwi meme'ana papaba meeoo oo netammamena, “Ne Pabe'e u sakwa ne sootuhi.” ");
INSERT INTO paoNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Ka nobe-kwi ka Te Pabe'e egease, mu gi tutubootabuedu oo-matoo memea; soo Te Pabe'e yise meeoo mu tubengu, “Mu haa'a oo soo'oedyukute ka nuka mumme mabesakukwuna?” Umu yise meeoo oo nanekwegea, “Aha, Ne Pabe'e.” ");
INSERT INTO paoNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Soo Te Pabe'e yise mu pooe-ma matuguse meeoo mu netamma, “Mu ka tunaka'oedyukuse namabesakukwu.” ");
INSERT INTO paoNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Mu nanana yise besa tubootabue mamani. Soo Te Pabe'e yise meeoo mu netamma, “Gi haka saa'a tuukwepana.” ");
INSERT INTO paoNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ooonne'yoopana umu yise mana teepu kaa'no oo waha kodyu. ");
INSERT INTO paoNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Ka togesoo ka Te Pabe'e mea, soo tsoapayidu gi yadooa manepu oo-baa nabi petu. ");
INSERT INTO paoNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Ka Te Pabe'e ka tsoapayidu nana mabesakuse, soo tsoapayidu nana yise yadooa mani. Mu numu yise no'yoona oo poonnedu meeoo unakwe, “Soo Te Pabe'e yow besa'yoo gi hee hannano'o yooonne'yoo ka te nanumu-nagatu napoonnedu.” ");
INSERT INTO paoNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Pana mu nananesootuhidu-matu meeoo, “Oosoo ka tsoapa moohedu sutakoo poohabe pooha-gana, ooonne'yoona oosoo yise ka sutakoo tu pooha-gana-ma mu tsoapa nematzagakwuniyakwe.” ");
INSERT INTO paoNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Soo Te Pabe'e yise mana tooe ka Te Naa unnepu wahanumme, mu numu tunedyooena, mu nanesootuhi-kwi'yoona tooe. Tooe hownnekoo tooe tuoeba mabesakute tuwazoo. ");
INSERT INTO paoNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Nana'ewow numu poonne mukwadu-kwa'ne mu manemo'o, tutuha mu soobedya, ka oo mu manemo'o gi too howsoo mane-wa'ne'yoo ka pumme tummatzikwudu kadoo'ookoo. Te Pabe'e yise tutuha mu soobedya. ");
INSERT INTO paoNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","“Gi haga ka Te Naa besa podosoo mu moohe-wa'ne'yoo,” mee soonammena. Te Pabe'e yise pumme nakatzimodu mee netamma, “Ewa'yoo mu numu ka Te Naa besa unnepu tu nakakwuna soogwidu. Pana gi ewa'yoo numu mu tuukwedu. ");
INSERT INTO paoNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Tamme sakwa ka Te Naa-matoo nanesootuhi mee unnena, ‘Ne Naa, U, ewowsoo numu sootuhi ka besa u unnepu wahakwudu. O'no yise ewa'yoo numu u-witu nakana, u nakasopedakwadookwu.’ ” ");
INSERT INTO paoNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Soo Te Pabe'e ka numme sumumano wahamatsebooeku (12) naana pumme nakatzimodu nabaatoo bise meeoo ne netamma, “Nu manatooe mu tayakwu mu nanesootuhibu mu numu tunedyooekwu. Nu mu pooha-makase mu tsoapa nematzagakwunikwu, no'obatusoo tuoebu-ma tu'oegoedu namabesakumokwuna tuwazoo.” ");
INSERT INTO paoNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Umu sumumano wahamatsebooekudu (12) nanana Te Pabe'e nayadooawabe mee nanane'a, Simon, soo Te Pabe'e Peter mee oo ne'a, Andrew, Peter pabe'e, James tu wannga'a John-no, mu naa Zebedee mee naneadu. ");
INSERT INTO paoNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Philip, Bartholomew, Thomas, nu Matthew uga numu tunekwidu, James, oo naa Alphaeus mee naneadu, Thaddeus, ");
INSERT INTO paoNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simon, ka Cana mee naneadu-wi'yoona kemmapu, soo Judas punno'o saa'a ka Te Pabe'e-toogoo pabenapu. ");
INSERT INTO paoNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","6","Soo Te Pabe'e ka gisoo numme pumme nakatzimodu mana tooe hano tooe ka Te Naa unnepu numu tunedyooe tayana, mee ne netamma, “Mu sakwa mu Jew numu-matoo suu'mu mea umuoo gi ka Te Naa besa podu me'a, gi ka mu susumudu tooe hownnekoo tooe numu-matoo meapana. ");
INSERT INTO paoNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Mu sakwa meadabena mu numu tuukwe, ‘Soo Te Naa petukwuna tzake'e manekena.’ ");
INSERT INTO paoNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Mu sakwa mu tu'oegoedu mabesaku, mu uagoedu, mu tsoapagoedu tuwazoo. Mu sakwa ka mu numu ya'edu mayodayisoo. Mu sakwa gi numu tunekwi, mu sukwe tummatziyi, soo Te Naa puu gi mu tunekwa'e mu sakwe sootuhiyakwe. ");
INSERT INTO paoNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Gi hemma puma mu tumu-wa'nekoo hanegapana. ");
INSERT INTO paoNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Gi hemma hanepana pukwi mu namasooa-wa'nekoo gi tuwazoo tunekwipana, umu mu nakapunnedusoo sakwa ka hemma mu soogwina mu tummatzi. ");
INSERT INTO paoNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Ka tooe hano tooe petugase mu sakwa besow numu mayuse oo nobe-kwi yise umu-baa'yoopunne. ");
INSERT INTO paoNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Mu ka kumma'akoosoo nobe-kwi egease besow mu numu oe nobe-gakoo nekwiku. ");
INSERT INTO paoNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Umu ka besa'yoo numuna nasootuhikwu. Umu ka suta'yoona soo besow mu nekwipu mu-matoosoo namakodyukakwu. ");
INSERT INTO paoNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Ka mu numu besa mu unnepu gi naka'oedyukute, ka numu nonobe-too meana, ka koosebu mu moko-makoo tata'ne mea. Ka oo mu manese umu oo sopedakwadookwu ka gi besa tu manena gi mu naka'oedyukute. ");
INSERT INTO paoNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Saa'a soo Te Naa mu numu nemadabuekwu, soo suda mu tumatugupu yise umu-matoosoo kodyukwu, ka o'nosoo namane-kwa'nesoo soo suta'yoo puu ka mu numu Sodom noko Gomorrah mee nananeadu-matoo kodyu, umu yise nakootzasooa. ");
INSERT INTO paoNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Mu numu pumatoo mumme e tayakwuna suta'yoo numu etza'a-wa'ne. Ka umu-baa'yoona mu sakwa unu besa sapa manena, besa mu matuguna, kaaheno Te Naa unnepu mu tunedyooe, umu sumuna mu too'e nemooagakwu. ");
INSERT INTO paoNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Mu sakwa besa mu eya'ena. Umu sumuna mu-toogoo pabenase, mu nagusedyakwu, ");
INSERT INTO paoNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","umu ka mu wakwawa'a numu moohedu-koobenatoo saa'a mu hanese, mu nanehanedooa. Mu saa'a nuupagetadooa. Mu gi e naka'oedyukudu saa'a gi mu petzabedooa. Mu yise nuga besa unnepu mu tuukwekwu. ");
INSERT INTO paoNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","20","Mu ka nakwutumase gi suda oo soonammekupana ka ha'yoo mu unnekwuna. Mu ka Te Naa besa pooha-toohakwi yadooakwu. Soo Te Naa mu unnekwuna mu tuukwekwu. ");
INSERT INTO paoNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","22","Mu numu nu-koobatoo gi mu petzabekwu. Mu nananumusoo sumuna mu nekwohonekwu. Mu sumuna nabatsakwu ka mu pabe'e tooetoo mu tooa'asoo mumme wahase. Pana mu ka e naka'oedyukumona, nu mu magwetzoikwu. ");
INSERT INTO paoNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Ka mu numu mumme suda matugu, kumma'a-witoosoo mease umuoo tunedyooe. Mu sakwa tooe hanotoo tooe mea. Nu sumuna petukwu gisoo ka nakwitu Jew numu-baa mu petuga'a. ");
INSERT INTO paoNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","25","Mu ka numu tunedyooena mu nu-wa'nesoo namatugukwu. Umu gi tunaka'oedyukudu puusoo Suta'yoo mee e ne'a. Umu mumme tuwazoo suda netammakwu. Pana oosoo gi hownne'yoo, o'no mu nu-wa'ne'yookwu. ");
INSERT INTO paoNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","27","Mu sakwa gi suipana ka besa e unnepu mu numu tuukwena. Tooe ka mumme e watze tuukwe sapa, saa'a mu sakwa numu nakana oo mesoo waha. ");
INSERT INTO paoNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Tamme sakwa ka mu numu tamme nekwoho'ne sapa, gi umu-ma suipana. Umu tooe te batsase sapa, gi hownnekoo te moogooa how yugwe-wa'ne'yoo. Tamme sakwa gi umu-ma naka'emukwapana, ka Te Naa unnena suu'mu toge'yooku. Te Naa suu'mu o te soonammena, te tookoo noko madipunnedu, Te Naa suu'mu sakwa tamme besa sooyugwena. ");
INSERT INTO paoNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","31","Pana soo Te Naa unu te nenaka. Mu hootseba'a puu gi haa'no nanenaka pana soo Te Naa mu soopedyana mu mabetse'a. Soo Te Naa puu gi e watzekute, no'oko tamme-witu sopedakwadoopunne. ");
INSERT INTO paoNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Mu ka mu numu yaa teepu-koobatu tuukwena, ‘Soo Jesus E Pabe'e,’ nu saa'a punno'o ka E Naa-kobena'yoona. ‘Mu nugatu,’ mee tuukwedooa. ");
INSERT INTO paoNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Mu ka ‘Jesus e Pabe'e,’ mee mu unne-ma nasookwina, nu saa'a punno'o ka E Naa-kobena'yoona, ‘Mu gi nugatu,’ mee ka Te Naa tuukwedooa. ");
INSERT INTO paoNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Mu sumuna mee sokwamakwu, ‘Nu ka Te Pabe'e petuku manese yaa manakwana, hee-no'yoona besa'yookwu.’ Pana gi! Mu numu mu nekwohonekwu ka nuka mu nanesootuha'e. ");
INSERT INTO paoNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Mu nanumupana mu wohonekwu. Mu gi tunaka'oedyukudu numu pummesoo naanapua'amu, tu yahe nokosoo mu wohonekwu, ka nuka mu naka'oedyukumanese. ");
INSERT INTO paoNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Mu numu tamme-baasoo nobe-ga'yoo sumuna punno'o te wohonekwu. ");
INSERT INTO paoNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Mu nuka no'okosoo hemma oooonakwa unu soobedyakwu. Mu sakwa ka mu naa, mu pea, noko mu doodoomu, oooonakwasoo unu e soobedya, o'no mu ka E Naa besa podo meadabekwu. ");
INSERT INTO paoNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Mu ka mee unnena, ‘Tooe nu ka Te Pabe'e-koobatoo nabatsase sapa, oosoo besa'yoo,’ o'no yise mu ka mumme e sooyugwe-kwa'ne'yoona, mu e nanumu manepunnekwu. ");
INSERT INTO paoNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Mu ka nu-koobatoo nasoomawunise nabatsase, nu ka tubetse gwetzoibu gi moobegwagakoo mu sootuhikwu. Mu ka mummesoo tookoo unu soobedyana, gi gwetzoibu-ma nasootuhi-wa'ne'yoo. ");
INSERT INTO paoNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Tooe haga tooe ka mu nuka nakatzimodu tummatzidu nuka tummatza'edu-kwa'nesoo manepunne. Soo tooe haga tooe nuka tummatzidu ka Te Naa tummatzidu-kwa'ne tuwazoo manepunne. ");
INSERT INTO paoNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Tamme ka Te Naa yadooawabe tummatzina, oosoo ka Te Naa yadooawabena, saa'a soo Te Naa te sootuhikwu ka ooka tu yadooawabe tu sootuhi-kwa'nekoosoo. Tamme ka kaaheno meadabedu numu tummatzina, oosoo ka Te Naa besa podo meana, saa'a soo Te Naa te sootuhikwu, ooka tu sootuhi-kwa'nekoosoo. ");
INSERT INTO paoNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ka tooe hownnekoo tooe besa sumuoo Te Naa doodooamu-matu te matugu, oosoo ka Te Naa dooa'ana, ka oo puudya'e, ba'utzutzudu oo sukwe bamagase sapa, soo Te Naa ka besow tamme-matusoo makodyukukwu,” mee'e soo Te Pabe'e. ");
INSERT INTO paoNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Soo Te Pabe'e yise ka mu waha matsebooekudu (12) pumme nakatzimodu tunedyooemakwuse, ka teepu Galilee mee naneadu-witoo mease mu numu nonokadu-kwi nanesootuhibu mu tunedyooemena. ");
INSERT INTO paoNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Soo John nakwutumana ka Te Pabe'e manepu-kwitu naka, yise ka mu tu pupua'amu-matu ka Te Pabe'e-matoo ta'ya mee mu tutubengatuunguna, ");
INSERT INTO paoNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","“U haa'a yow Te Pabe'e, pute soo Te Pabe'e saa'a petukwu?” ");
INSERT INTO paoNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Soo Te Pabe'e mee'e mu nanekwegea, “Mu sakwa ka John tuukwe ka mu poonnena, mu nakana tuwazoo. ");
INSERT INTO paoNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Ka umu gi tutubootabuedu numu tubootabue manese, mu toyomodu numu besa numme manese, mu gi nakatakedu numu nakadake manese, mu numu uagoedu besa maneyakwe, mu tuipu numu namayodasesoo, yise ka mu tutuha manedu numu ka Te Naa besa unnepu natuukwese. ");
INSERT INTO paoNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Mu ka ooosapa e naka'oedyukuna gi nu-ma nasookwina, besa nasootuhikwu.” ");
INSERT INTO paoNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Ka mu John pupua'amu kodyukase, soo Te Pabe'e ka John-witu mu numu tuukwe, “Ka o'nosoo nuga-kobenasoo mu numu oona giba-ma ka John-baa petugayakwe, soo John yise gi waha-tamme tusooyugwedu nana. ");
INSERT INTO paoNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Hemma mu poonnekwu mee mu sokwamana oo-matoo mea? Mu besa namasooadu, besa namadabuedu nana poonnekwu mee haa'a mu sokwama? Mu numu besa nanamadabuedu ka numu-kooba katudu nobe-witu. ");
INSERT INTO paoNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Soo John o Te Naa nayadooawabe, ookow Te Naa nayadooawabe mu nakakwuse oo-baa petuga'a. Soo John ka umu o'nosoo Te Naa nanayadooawabe oooonakwa besa'yoo. ");
INSERT INTO paoNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Soo John ka Te Naa besaa nayadooawabe. O'nosoo ka John-witu nabotugupu-ga'yoo soo Te Naa meeoo e netammapu-ga'yoo, ‘Ume-kobenasoo ka teepu-koobatoo nu e nayadooawabe tayakwu ka mu numu ume petukwu-kwitu tunesootabue tuunguna.’ ");
INSERT INTO paoNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Nu mu tuukwe soo John no'oko numu oooonakwa besa'yoo. Pana saa'a soo gi maawane'yoo numu Te Naa-tooha manedu ka John oooonakwasoo nasootuhikwu. ");
INSERT INTO paoNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Soo John baa-wi numu matzakadu ewow numu baa-witoo ka suda mu tutumatuguna patamatzakakwuna'e. Umu ka Te Naa besa unnepu naka'oedyuku manekeyakwe. ");
INSERT INTO paoNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","14","No'yoona o'nosoo mu Te Naa nanayadooawabe ka Elijah nuga-kobenasoo wahagena. Mu sakwa oo naka'oedyuku soo John ka Elijah-wa'ne'yoo, oosoo nu-kobenasoo petukwu. ");
INSERT INTO paoNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Mu sakwa besa oetu nakapunne. ");
INSERT INTO paoNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Nu mu-witu natugwengakwu. Mu doodooake-wa'ne'yoo gi besa mu pupua'amu-no tu'ate'a. Mu puapua'amu sumuna mee mu netamma, ");
INSERT INTO paoNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Numme mu tunekwukukwu. Numme saa'a nugagonnodooa, mee mu unnese, pana mu gi oo-toogoo manakwe. Mu ka suda ne sokwama, gi numme-no sakwa'e. Mu e unnepu gi heesoobedya.’ ");
INSERT INTO paoNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Soo John puu ka petuse, gi unu tuka, gi tuwazoo atsa baa hepe, umu yise meeoo ka John-witu netamma, ‘Soo John sutakoo pooha-ga'yoo numu poohadu.’ ");
INSERT INTO paoNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ka nuka mu-baa petugase mee tuwazoo mu e nesootze'ma, ‘Oosoo nana ewa tukana, umu suda tutumatugudu pupua'amu-ga'yoo.’ Umu besa'yoo numu ka Te Naa unnepu nakasopedakwadoona, ‘Besa'yoo,’ mee unnekwu.” ");
INSERT INTO paoNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Soo Te Pabe'e yise ka mu numu tooe tuukwe ka mooe'ugasoo pukwi'yoona nanabesa tu pooha manepu, umu ka tooe nanabesa oo pooha manepu poonnese sapa, gi oo soo'oedyukuna gi ka suta tu tumatuguna nematzagakwuna'e. ");
INSERT INTO paoNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Soo Te Pabe'e mee unakwe, “Mu numu ka mu Chorazin noko Bethsaida mee nananeadu-wi nonobe-ga'yoo mu tuma'emukwana mu-matoosoo kodyukwu. Nu mu too'e tuukwepana mu gi tunaka'oedyukute, ka suda mu tumatuguna gi mu nanekwahakwuna'e. ");
INSERT INTO paoNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Mu ka o'nosoo umu sutakoo numu ka mu Tyre noko Sidon mee nananeadu-witu oooonakwasoo suta-kwi manekwu ka saa'a Te Naa numu nemadabue-wi oo manepetuse. Umuoo otuoo numu sakwa uga ka besa e pooha manepu poonnese, umu sakwa sumuna ka suda tu tumatuguna nanekwahakwunise, tunaka'oedyuku mane. ");
INSERT INTO paoNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Mu numu yaa'a ka Capernaum-witu unu besa'yoo mee naneyugwe. Pana mu ma'emukwana mu-matoosoo kodyukwu. ");
INSERT INTO paoNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ka o'nosoo tu namane-kwa'ne'yoosoo soo suta'yoo puu ka Sodom mee naneadu-matoo kodyuse, umu nakootzasooa. Mu sumuna umuoo oooonakwa suda namatugukwu ka saa'a Te Naa numu nemadabuekwuse soo suta'yoo mu-matoosoo kodyukwu.” ");
INSERT INTO paoNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Soo Te Pabe'e punno'o tubetse besa soonammena meeoo nanesootuha'e, “Ne Naa u no'okosoo hemma ka teepu-koobatu yise ne pa'anakwitu tuwazoo nemadabue. U tubetse besa'yoo u ka umu u dooamu ka besa etzaga u unnepu nakasopedakwadookwuna mu sootuhipuna tooe gi unu mu natunedyooe sapa. Umu unu natunedyooepu gi gea u unnepu nakasopedakwatoo. ");
INSERT INTO paoNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Yooonnekoo u tusooyugwe-kwa'ne.” ");
INSERT INTO paoNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Soo Te Pabe'e yise ka mu numu mee netamma tuwow, “Soo E Naa no'okosoo hemma e sopedakwatoona e sootuhipu. Oosoo suu'mu e sopedakwatoo. Nu punno'o ka E Naa sopedakwatoona nu ka numu oetu nakasopedakwadookwuna mu mesoo tuukwe.” ");
INSERT INTO paoNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Soo Te Pabe'e yise ka mu numu mee netamma, “Mu numu ka gi manese, suda sokwamana sakwa nuka nanetzakwiya'e, o'no nu mu pewu-witu sootuhikwu. ");
INSERT INTO paoNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Mu sakwa ka e unnepu oo nakana, oo naka'oedyuku, nu ka besa'yoona, gi paba nasooyugwe. ");
INSERT INTO paoNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Mu ka e unnepu etzaga mesoo nakabetseanona, o'no saa'a mu besa sokwamakwu.” ");
INSERT INTO paoNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Soo Te Pabe'e yise numme pumme nakatzimodu-no oona tubewabe-too me'a. Numme tseagoena ka tumasuape-matu mabokana oo mahangemeana oo tuka. ");
INSERT INTO paoNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Mu nanesootuhidu Jew numu moohedu, Pharisee mee nananeadu, mu poonne, umu yise Te Pabe'e meeoo netamma, “Tamme Jew numu mooa tumayohona, o'no nanesootuhi tabeno gi hee how nuugwe. Umu u nakatzimodu ka te Jew numu tumayohope gi heesoobedya. Umu ka tumasuape mahangena oo tukamena ka nanesootuhi tabeba gi numu hemma how yugweno'o.” ");
INSERT INTO paoNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Soo Te Pabe'e yise meeoo mu netamma, “Mu ka sumuna uga oo naka ka o'nosoo soo besa tamme-kooba katudu, David mee naneadu, punno'o ka te Jew tumayohope takopapu ka tu pupua'amu-no tseagoena. ");
INSERT INTO paoNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Soo David ka Te Naa nanesootuhi nobe-wi petugase ka tu pupua'amu-no ka pooha tukaba tuka umu nanesootuhibu numu tunedyooedu suu'mu tukana. Oosoo ka Te Naa-nakwana gi hownne'yoo. ");
INSERT INTO paoNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Mu sakwa tuwazoo oo nea ka te tumayoho-wi soo Te Naa meeoo, ‘Oosoo gi hownne'yoo ka nanesootuhi tabeno mu nanesootuhi tunedyooedu puu, o'no tabeno hemma how mesoo yukwe ka pabow tu nanesootuhi nobe-wi'yoona.’ ");
INSERT INTO paoNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Nu yise ka pabow nanesootuhi nobe oooonakwa besa'yoo. ");
INSERT INTO paoNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Mu sakwa oo nakasopedakwadoo ka Te Naa unnena, ‘Mu ka nanatoo besa'yoona nuka mu sukwe hee-makapana oooonakwa'yoo nadatsuungu.’ O'no mu oo sopedakwadookwu numme tookwa gi tuma'emukwa. ");
INSERT INTO paoNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Nu yow mu Pabe'e. Nu no'oko hemma ka mu nanesootuhi-kwi mu nemadabuekwudu.” ");
INSERT INTO paoNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Onona mease soo Te Pabe'e ka mu nanesootuhidu-baa petuga. ");
INSERT INTO paoNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Soo nana sumu-nakwatu mi pasadu ka nanesootuhipe-wi. Mu Te Pabe'e manena nesootu'adyidu soo Te Pabe'e meeoo netamma, “Oosoo gi hownne'yoo haa'a nu ka nana mi mabesakuna ka nanesootuhi tabeba numme puu, o'no tabeba gi hemma how yugwe?” Umu ka Te Pabe'e numu mabesakute oo nesootu'adya'e. ");
INSERT INTO paoNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","12","Soo Te Pabe'e mu nanekwegea, “Aha, oosoo gi hownne'yoo ka besa tumatuguna ka o'no tabeba-wi. Mu muusoo punno'o oo manekwu. Soo mu kootsoo sumuna ka teepu tawaga-witoo wuese ka mu nanesootuhi tabeno mu yise puu oo tzatsebooakwu. Soo numu ka kootsoo oooonnakwasoo nadatsunga.” ");
INSERT INTO paoNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Soo Te Pabe'e yise ka nana meeoo netamma, “Matuhee.” Oosoo yise matuhese soo Te Pabe'e oo mi mabesakuhoo ka sumunakwatu-kwa'nesoo. ");
INSERT INTO paoNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Pana mu Jew numu Pharisee mee nananeadu oe'yoona mea'ase ka Te Pabe'e batsakwu mee'e oo-toogoo tunehane. ");
INSERT INTO paoNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","16","Soo Te Pabe'e ka pumme mu batsakwuna sopedakwadoose umu-baa'yoona meahoo. Ewa'yoo numu oo-no manekase oosoo yise mu tuoegoedu mabesaku yise meeoo mu netamma, “Mu numu saa'a gi tuukwepana.” ");
INSERT INTO paoNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ka o'nosoo Isaiah mee naneadu Te Naa yadooawabe tubotugupu-wa'nesoo manepetu. Isaiah meeoo tubotugupu. ");
INSERT INTO paoNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Soo Te Naa tummatzidu meno'o yow tamme-baa. Soo Te Naa oo-matoo besa soonammena ka oo netutzease o esoo Te Pabe'e. Soo Te Naa Tu Besa Pooha-ma oo sootuhise oosoo ka mu gi Jew numu tuukwekwu ka Te Naa umu magwetzoikwuna. ");
INSERT INTO paoNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Oosoo gi numu-no nahadu, gi paba yadooadu tuwazoo. ");
INSERT INTO paoNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Tooe ka mu gi nanatzooedu noko tutuha mamanedu suda namanatzaya sapa, soo Te Pabe'e mu magwetzoikwu. Soo Te Pabe'e ka mu pumme wohonedu tooe matzooekukwu. ");
INSERT INTO paoNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","No'obatusoo numu yise oo naka'oedyukukwu, Te Pabe'e yise mu magwetzoikwu.” ");
INSERT INTO paoNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Mu numu yise ka tsoapayidu nana ka Te Pabe'e-baa bi petu. Soo nana gi tubootabue, gi besa yadooa soo Te Pabe'e yise oo mabesaku. Soo nana yise besa tubootabue manese, besa yadooa tuwazoo. ");
INSERT INTO paoNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ewa'yoo numu ka nana namabesakuse oo poonnena, mee yise nananetamma, “Yow tookwa esoo nawahapunnedu Te Pabe'e, mooasoo tamme-baa petu.” ");
INSERT INTO paoNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Mu Pharisee numu yise ka mu numu unnegonnona nakase, gi ka Te Pabe'e soo'oedyukuna mee nana'unakwe, “Esoo nana numu nemooaga mu numu yise naka'emukwa, sutakoo poohagana ooonne'yoona esoo tsoapa nematzagakwunidyakwe.” ");
INSERT INTO paoNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Soo Te Pabe'e ka mooasoo pumme mu sooyugwena sopedakwadoona, mee mu netamma, “Mu numu ka pumme moohedu gi nakabetseana nanano nananepetukuna, soo mu moohedu gi mu numu moohe-wa'ne tabu'a, mu numu yise kadoo'oo sukwe namayugwekwu. ");
INSERT INTO paoNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Mu gi toge unakwe mu ka ‘Numu poohadu,’ mee e netammana. Soo numu poohadu gi hownnekoo nanesootuhina ka tsoapa numu-nagakoo nematzagakwuni-wa'ne'yoo. Soo Suta'yoo gi ka tsoapa numu-nagakoo nanematzagakwunina petzape, umu tsoapa ka oo tutummatzina. ");
INSERT INTO paoNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Mu Jew numu moohedu puu ka mu tsoapa numu-nagakoo nanesootuhina mu nematzagakuna'e. Mu puu gi numu poohadu mee mu ne'a. Mu sakwa gi nuka meeoo soobedyapana. ");
INSERT INTO paoNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ka Te Naa Besa Pooha-toohakwi nu nanesootuhina mu tsoapa nematzagakwuni, mu sakwa meno'o oo sopedakwadoo soo Te Naa no'oko numu sootuha'e. ");
INSERT INTO paoNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Nu ka mu susutakoo moohedu oooonakwasoo unu pooha-gana nuga pooha ooosapa oo matzooekute. Soo natzooedu nana puu ka tu hemma besa takonena gi hee oo matzooekute, pana ka numu tzakunase, o'no yise oo hemma hanekwu. Yooosoo nu ka sutakoo yugwese, o'no nu mu numu magwetzoikwu ka suta-makoo. ");
INSERT INTO paoNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Soo numu gi e nakabetseadu tookwa e wohonekwu. Tooe haga tooe nu-witu mu numu gi tunesootabuedu, oosoo punno'o e tumoo'oodu-kwa'nesoo manepunne. ");
INSERT INTO paoNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","32","Nu togesapa mu tuukwe'ekwu tooe haga tooe numu yise ka Te Naa suda netammana nuka tuwazoo, oosoo nasoomu'wakwu. Pana soo tooe haga tooe ka Te Naa Besa Pooha suda netammana gi nasoomu'wa-wa'ne'yoo. ");
INSERT INTO paoNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Tumasuape-wa'ne'yoo, soo tumasuape puu susumudu besa'yoo, susumudu suta'yoo. Tamme puu oo sopedakwatoo ka tumasuape hownnekoo soo besa'yoo tumasuape pooedoo'a, besa mesoo naduka. Mu tsa'abu pooe puu gi naduka-wa'ne'yoo. Susumudu numu eka sutakoo pooe-gakoo tsa'abu-wa'ne'yoo mu tumatugu-makoo umu nasopedakwatoo ka gi he-toogoo besa'yoona. ");
INSERT INTO paoNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Mu togogwa-wa'ne nanasoobedya, mu suda apegea ka suta'yoona. Tamme ka te unne-makoo nasopedakwadoo ka hownne'yoona. ");
INSERT INTO paoNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Mu ka besa'yoona besa manena besa apegea, pana ka suta'yoona suda manena, suda apegea. ");
INSERT INTO paoNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Pana nu mu tubetse tuukwekwu, mu saa'a oo nanekwahakwu how manena mu meeoo tooe unakwe, oo-makoo saa'a soo Te Naa mu nemadabuedooa. ");
INSERT INTO paoNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Mu kaaheno apegeana, soo Te Naa saa'a mu tookwa kaaheno'yoo mee mu netammadooa. Mu ka suda apegeana saa'a soo suta'yoo mu-matoosoo kodyukwu.” ");
INSERT INTO paoNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Yise mu susumudu nanesootuhidu tunedyooedu ka mu Pharisee mee nananeadu-nagatu ka Te Pabe'e mee netamma, “Nanasookwugi u tutumadabuena ne tzaponneku, o'no yise numme u soo'oedyukute.” ");
INSERT INTO paoNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Soo Te Pabe'e yise mee mu netamma, “Mu suta'yoo numu, mu gi e naka'oedyuku-wa'ne'yoo, ka nanasookwugi e manakwe e poonnese suu'mu. Nu ka o'nosoo Te Naa yadooawabe Jonah mee naneadu manepu-wa'nesoo manekwu. ");
INSERT INTO paoNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Soo Jonah puu ka pabatsekoo pakwe numua-wi pahe tabeno yise pahe togano tooiyakwe pana soo paba'yoo baa-kummanatoo oo mootzakwate soo Jonah yise ka yaa teepu-koobasoo petu. Nu punno'o oo-wa'nesoo pahe tabeno yise pahe togano nu natukuse, o'no yowsoo ka teepu-koobasoo petukwu. ");
INSERT INTO paoNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Ka Te Naa mumme nemadabuekwuse, mu numu ka Jonah besa naka'oedyukute ka oo nanekwaha ka Te Naa oo yadooakute. Mu suta'yoo mee unnekwu umuoo ka Jonah naka'oedyukuna nanekwaha. Tooe nu ka Jonah oooonakwa unu pooha-gapana mu gi e naka'oedyukuna gi ka suda mu manena nanekwuha. ");
INSERT INTO paoNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Soo mogo'ne mana taba meanakwatu numu-kooba katudu punno'o suta mu nemadabuekwu. Oosoo mogo'ne tubetse kwinga'a manakwana kemmadu Jew numu-kooba katudu, Solomon mee naneadu yadooana nakagese, ‘Unu soonamme,’ mee oo nakana. Tooe nu ka Solomon oooonakwa unu soonammepana mu gi e heesoobedya. ");
INSERT INTO paoNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Soo Te Pabe'e ka tsoapa-witu numu natugwe'ngakwu. Soo tsoapa ka numu-nagakoo namatsatsebooese, kumma'akoosoo punaga tu ekeahookwuna wate, pana ka gi tumayuna ");
INSERT INTO paoNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","o'no yise mee unakwe, ‘Nu punowsoo kodyukakwu.’ Ka numu punaga'yoo tumeahoopu mayuse oosoo numu sumuna gisoo ka Te Naa Besa Pooha-ma nasoonatza'ena. ");
INSERT INTO paoNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","O'no yise soo tsoapa natakwatsukwuhoo (7) kukumma'akoosoo tsoapa pumme oooonakwasoo unu susutakoosoo bise, ka punaga'yoona tu meapu-nagatoosoo kodyukakwu. Soo numu yise unusoo suda namanatzayakwe. Ooosoo tooe nu ka e suta'yoona too'e nematzagakwunise sapa umu gi e naka'oedyukute. Ooonne'yoona soo suta'yoo mu-tamme kemmakwu.” ");
INSERT INTO paoNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Togesoo ka Te Pabe'e mu numu yadooedyakwe oo pea oo wanga'amu-no petugonno. Puuwuna konnopunnenasoo ka mu numu-matu ka Te Pabe'e-witoo taya. ");
INSERT INTO paoNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Sumu'yoo meahoose ka Te Pabe'e tuukwe petuga, “U pea u wanga'amu-no u ba'e u-no apeageakwuse.” ");
INSERT INTO paoNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","50","Soo Te Pabe'e umu pumme nakatzimodu umu-matoo tayase mee yise oo netamma, “Umuoo suu'mu nu yaatoo nanumu-ga'yoo. Umuoo ka E Naa-matoo nanesootuhina. No'oko tooe haga tooe ka E Naa-matoo nanesootuhidu oo unnetusoo manedu umuoo nu tubetse nanumu-ga'yoo.” ");
INSERT INTO paoNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","O'no tabenasoo soo Te Pabe'e ka nobe-wi'yoona mease, ka banunadu-kumaba petuoogase oona katu. ");
INSERT INTO paoNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Mu numu tubetse ewa'yoo ka oo na'oonnakwi manepunnena oo taakoo'napunne, soo Te Pabe'e yise ka sake-wi tsebooese oe katu, mu numu ewa'yoo punno'o ka baa-kumana konnopunne. ");
INSERT INTO paoNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Soo Te Pabe'e mu tunedyooena mu natugwenga katu, mee mu netamma, “Soo nana tumasua'a. ");
INSERT INTO paoNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Susumudu soo oo pooe matu ka a nadapoohabe-witoo sawehoose mu hootseba'a mu sooa. ");
INSERT INTO paoNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Susumudu oo pooe tubebu'a-matu punno'o oona tupe-nagatoo gi tookapu teepu-ga-witoo sawehoose yabesoo naahoose sapa, ");
INSERT INTO paoNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","soo taba mu kootuikuhoo, umu ka gi tookaputoo tunahabena. ");
INSERT INTO paoNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Susumudu mu a pooe punno'o tsa'abu-nagatoo sawehoose, naase sapa, soo tsa'abu ka ewa naana mu tatsatsebooge. ");
INSERT INTO paoNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Susumudu besow teepu-koobatoo sawese besa naakese ewa pooetooa. ");
INSERT INTO paoNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Mu sakwa ka mumme e tunedyooe-makoo a nakasopedakwadoose mamakoo natunedyooe.” ");
INSERT INTO paoNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Numme Te Pabe'e nakatzimodu Te Pabe'e-baa petugase mee'e oo tubenga, “How manena u ka mu numu natugwenga?” ");
INSERT INTO paoNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Soo Te Pabe'e yise ne nanekwegease mee unakwe, “Mu e nakatzimodu mooasoo nasootuhipu. Mu mooasoo oo nakasopedakwadoo ka Te Naa unnepu. Mu nasootuhipu pana mu numu gisoo ookow nasootuha'e, ooonne'yoona nu meeoo mu natugwenga katu Te Naa nuka tunetammakuna. ");
INSERT INTO paoNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Soo tooe haga tooe numu ka sagwane tunaka'oedyukuse, saa'a oo-no meadabena unusoo tunaka'oedyuku manepetugakwu. Tooe haga tooe numu ka gi tunaka'oedyukuna hanobasoo gi tunaka'oedyuku manekwu. ");
INSERT INTO paoNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Ooonne'yoona nu mu numu natuukwe'nga. ‘Tooe mu numu oo poonnepana, umu gi ooka tu nakasopedakwatoona petzape. Tooe mu numu oo nakapana, gi oo naka'oedyukute.’ ");
INSERT INTO paoNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","O'nosoo Te Naa yadooawabe Isaiah mee naneadu mu numu manekwu-kwitu botugupu, mee na'unakwe, ‘Mu ooosapa ka Te Naa besa unnepu nakamo, pana gi oo soonaka'oedyukute. Mu tuwazoo tooe oo poonne pana gi oo soo nakasoopedakwadoo. ");
INSERT INTO paoNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Mu numu ka Te Naa besa unnepu tu nakasopedakwadookwuna gi petzape, too'e mumme tu tuukwe sapa. Mu sakwa ka mumme oo tuukwena naka'oedyukuna, mu poonnena nakasopedakwadoona, o'no sakwa mu nu-matoo kemmase, nu yise mu sootuhikwu.’ ");
INSERT INTO paoNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Nu mu sootuhikwu mu ka oo nakana, oo oedyukuna ka mumme e tuukwena, oo poonnena, oo nakasopedakwadoona ka e manena. ");
INSERT INTO paoNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Nu togesapa mu tuukwekwu, o'nosoo mu nanamooatupu ewa'yoo mu Te Naa yadooawabe, mu kukumma'yooosoo bebesa'yoo numu e tooe soopoonne pana e tooe soonaka pana gi hownnekoo oo mane-wa'ne'yoo. O'nosoo nu gi mu nanamooatupu-baa pana meno'o mu nasootuhipu nu ka mu-baa petuse. ");
INSERT INTO paoNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","E nakapunne nu ka e natugwenga-kwitu mu tunedyooekwu. Esoo natugwengapu-kwitu, tamme ka Te Naa naka'oedyukudu. ");
INSERT INTO paoNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Susumudu ka Te Naa unnepu naka pana gi oo oedyukuna ooonne'yoona ka a pooe a natapohabeku-kwitoo a sawe-kwa'ne'yoo. Soo a pooe ka Te Naa unnepu-kwa'ne'yoo. Soo gi toge'yoo ka Te Naa unnepu-witu mu numu nemooagatu, oosoo yise ka hootseba'a-wa'ne'yoosoo ka a ewana ka a pooe kwakwape oo totsopetahookwu. Yoo mu numu hanobasoo gi tunaka'oedyuku manekwu. Oosoo ka a pooe a nadapodo-wi namasuadu-kwa'nesoo. ");
INSERT INTO paoNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Susumudu numu-matoo sumuna ka tupe-nagatoo a pooe nabebu'a-kwa'ne'yoo ka Te Naa unnepu nakana, besa Te Naa unnepu-matoo nakasokwama. ");
INSERT INTO paoNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Mu nanewohonena mu numu yabesoo tunaka'oedyukumakwukwu. ");
INSERT INTO paoNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Susumudu numu sumuna ka a pooe mu tsa'abu-nagatoo sawe-kwa'ne'yookwu. Mu numu ka Te Naa unnepu nakapana ka ewa tu heetooana sumu petukute, yise ka teepu-kooba tooe hownnekoo tooe suda oo soonammekute. Esoo ka besa te too'e tunakapu tamatzooekukwu. ");
INSERT INTO paoNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Pana mu numu-matu ka a pooe besow teepuna namasuadu-kwa'ne'yoo, umu ka besa na'unnedu nakase oo naka'oedyukukwu. Umu ka besa-kwi natumasuakudu-kwa'ne'yookwu ka ewow besow pooe saawe-wa'ne ka Te Naa unnepu naka'oedyukute. Tamme ka Te Naa besa unnepu mu numu tuukwena, o'no ewa'yoo umu numu tunaka'oedyukukwu.” ");
INSERT INTO paoNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Soo Te Pabe'e yise kumma'akoosoo mu numu natugwenga tunedyooe tuwow. “Mu tunaka'oedyukudu ka mu gi tunaka'oedyudu-no namayu'a yaa teepu-koobatu. Ka nana tubewabe-ga'yoo-kwa'ne, soo numu tubewabe hee-ga'yoo puu ka besow tu pooe suu'mu masuakute. ");
INSERT INTO paoNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Mu numu yise tumasuamakwuse ka tu yongose utuika ka tu woho togabama tu tubewabe-wi petuse ka tsa'abu pooe ka besow tumasuape-nagatoo pebu'ase mea'a. ");
INSERT INTO paoNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Ka tumasuape besa naahookese, soo tsa'abu punno'o oo-nagakwi namayuadu naahooke. ");
INSERT INTO paoNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Soo tumasuadu tummatzidu mee oo netamma, ‘Numme oo sopedakwadoo ka besow a pooe mawe tubewabe-wi u masuase. How yise manena mu tsa'abue punno'o umu-nagakwi na'a?’ ");
INSERT INTO paoNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Soo tumasuadu mee'e mu nanekwegea, ‘Oosoo nuka woho'nedu ka sumuna mow manakwe.’ Umu oo tummatzidu mee oo netamma, ‘Numme sakwa mu tsa'abu tzanooedapebu'a.’ ");
INSERT INTO paoNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Soo tubewabe hee-ga'yoo mee'e mu nanekwegea, ‘Gi meno'osoo. Mu sumuna ka besow tumasuape nokosoo ka tsa'abu tzanooe'dakwunidooa ka meno'osoo oo manena. ");
INSERT INTO paoNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Ka tumasuape nayasakwuse, nu saa'a mu yasadu mee netammadooa, Ka tsa'abu mooe hanese, nana-ma mu wutamase mu tuni. O'no saa'a yise ka besow tu pooe e tubane nobe-kwi tubane.’ ” ");
INSERT INTO paoNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","32","Soo Te Pabe'e yise mu numu tuwazoo kumma'akoosoo natugwenga ka mu numu nanesootuhidu mane-kwitu. Sumu'yoo natugwengape meeoo yise oo soo puu ka tuutsekoo a pooe manakwana suakese ka saa'a naakese pabatse suakese paba manepetugase nana'emota ma'natooakwu. Mu hootseba'a yise oo ma'na-ma mesoo aata yoohoo soo nanesootuhibu manepunne. Meno'o numme tutunaka'oedyukute huutse'yoosoo ka saa'a ewow numu tunaka'oedyukudu manese ka tutsekoo a pooe paba naa petuga-kwa'ne manekwu nana'emota ma'naga-kwa'ne manepetugakwu. ");
INSERT INTO paoNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Soo Te Pabe'e ooosapa mu numu tuwazoo natugwengayakwe ka umu-matu tunaka'oedyukute ewa'yoosoo numu saa'a tunaka'oedyuku manekwu. Mee'e yise unakwe, “Ka mogo'ne tukaba tohanedyidu-kwa'ne. Oosoo puu ka tumayua'a hongobe noko mooe mayu'ase, ka saa'a soo oo tukabadoona besa koposekwu.” ");
INSERT INTO paoNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Soo Te Pabe'e ewow numu nanatuukwe'e hemma mu nakasopedakwatoo-kwikoo yise mu ewow numu mana'yoona saa'a ka nanatugwengapu tu nakatzimodu tunesootabuedooa. ");
INSERT INTO paoNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Soo o'nosoo Te Naa yadooawabe ka Te Pabe'e natugwengakwu-kwitu wahana, mee'e tubotugupu, “Nu mu Pabe'e mu natugwengakwu ka gi hannano'o mu nakapugana.” ");
INSERT INTO paoNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Soo Te Pabe'e ka mu numu baa'yoona me'ase ka nobe-kwi ka numme pumme nakatzimodu-no tzoonooahooka. Numme yise meeoo ka Te Pabe'e tubenga, “Numme gi ka natugwenga-kwitu nakasopedakwadoo, hayoo u unnena?” ");
INSERT INTO paoNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Soo Te Pabe'e yise mee'e ne nanekwegea, “Nu ka tumasuadu-kwa'ne'yoo. ");
INSERT INTO paoNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","No'yoona numu ka teepu-koobatu yaatuoo ka tubewabe-kwa'nesoo manepunne. Mu numu nuka nanesootuhidu bebesow a pooe-kwa'ne'yoo. Mu numu ka sutakoo nakabetseadu punno'o ka sutakoo tsa'abu sua-kwa'ne'yoo. ");
INSERT INTO paoNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Soo Gi Toge'yoo e wohonedu ka tsa'abu masuapu. Ka saa'a soo Te Naa eka teepu-koobatu mu numu nemadabuekwu. Mu toha kakasa-ga'yoo ka Te Naa tummatzikwu. ");
INSERT INTO paoNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","42","Nu ka mu toha kakasa-gakoo, nuka tummatzidu yaa teepu-koobatoo tayakwu, o'no umu ka mu tuma'emukwadu numu kadoo'oo mayugwekwu. Ka mu tsa'abu natunikwu-kwa'ne, umu ka sutakoo numu goso gi tookedu-witoo ma'anakwu. Umu suda sokwamana sakwikwu. O'no soo Te Naa ka teepu atasoo mayugwekwu. ");
INSERT INTO paoNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Umu numu Te Naa-matoo nanesootuhidu ooosapa padakwetseaakwu ka taba-kwa'ne, ka Te Naa-baa'yoona. Mu sakwa e nakapunnena a nakasopedakwadoo. ");
INSERT INTO paoNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Soo Te Naa God tubetse besa te sootuha'e tamme ka Te Pabe'e besa nakabetseana, ka yaa'a teepu-koobatu hemma te heegana oooonakwasoo besa'yoo mee oo sooyugwena, ka hemma puma tu tumuna tubewabe-wi watze nagoodu-kwa'ne. Soo numu ka oo mayuse oo watze tugukwusoo yise no'oko tu hemmama tumuse ka tabewabe tumukwusesoo, oosoo besa soonammena ka hemma puma tu tumukwuna nawatzetugu-matoo. ");
INSERT INTO paoNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Tamme sakwa oo tubetse soogwi ka Te Naa tamme sootuhikwuna. ");
INSERT INTO paoNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Soo numu puu unu nanenagadu tsomebe mayuhoose, ka unu oo sookwina no'oko tu hemma-ma tumuse yise ka umu tu soogwina tsomebe tumukwu. ");
INSERT INTO paoNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Ekow teepu-koobatu, mu tunaka'oedyukudu mu gi tunaka'oedyukudu-no namayu'a, umu ka pakwe nuukwi-kwa'ne'yoo. Soo numu puu ka puma tu tukwina ka paa-witoo tzakwekuse no'obatusoo pakwe hanehookwu susumudu besa'hoo, susumudu gi besa'hoo. ");
INSERT INTO paoNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Ka tu tukwinoo kaanohoose bakumanatoo oo tzapewoyaga. Oosoo ka besow pakwe tu kawona-wi hanemena ka sutakoo yise tapebuamena. ");
INSERT INTO paoNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ka Te Naa ka teepu atasoo yugwese mu toha kakasagakoo Te Naa tutummatziwabe mu numu nanasukwesoo yugwe, mu bebesahoo sugwesoo, mu sutakoo too sugwebasoo, ka mu pakwe nuukwi-kwa'ne. ");
INSERT INTO paoNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Mu suta'yoo ka goso gi tokedu-witoo nahanekwunikwu umu suda sokwamana sakwikwu. ");
INSERT INTO paoNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Mu haa'a ka mumme e tuukwena nakasopedakwatoo?” mee'esoo Te Pabe'e ka mu numu tubenga. Umu oo nanekwegea, “Aha numme tooe besa oo nakasopedakwatoo.” ");
INSERT INTO paoNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Soo Te Pabe'e yise mee mu netamma, “Soo mooa tumayohope sopedakwadoodu ka meno'o mumme e tunedyooepu nakasopedakwadoose, o'no oosoo besakoosoo mu numu tunedyooekwu. How'oo puu soo numu pudutupu nokosoo mooatupu hee-ga'yoo tu nobe-kwikoo yise mu wutzadyupa, 'yoo manepunnedu unu besa'yoo.” ");
INSERT INTO paoNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Soo Te Pabe'e ka mu natugwengamakwuse, ");
INSERT INTO paoNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","tu nanumu-baasoo kodyu petuga. Ka mu numu-baa nanesootuhi petuga, ka mu numu besasoo Te Naa-witu tuukwena. Mu numu oe oo nakapunnedu meeoo netamma, “Ha'oo yise soo Jesus besa yadooa, pana oosoo sukwe tamme-matusoo? ");
INSERT INTO paoNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Tamme oo sopedakwatoo oosoo Mary sukwe tooa. Mu James, Joseph, Judas, Simon yise a wanga'amu. ");
INSERT INTO paoNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Yise a punne'emu yow tamme-naga. Ha'oo yise soo Jesus unu pooha-ga'yoo?” ");
INSERT INTO paoNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ooonne'yoona yise umu gi ka Te Pabe'e naka'oedyukute. Soo Te Pabe'e yise mee'e mu netamma, “Ka yaa teepu-koobatu mu numu ka Te Naa yadooawabe naka'oedyukukwu, oogowsoo nanumu, oo nonopua'amu-no suu'mu gi.” ");
INSERT INTO paoNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Huutsekoosoo numu tuoegoedu-matu oetu soo Te Pabe'e mabesaku, umu ka gi tunaka'oedyukuna. ");
INSERT INTO paoNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Ka mu Jew numu-kooba katudu Herod mee naneadu ka Te Pabe'e Jesus besa tumatugu-kwitu pudu nakase oosoo mu pumme tummatzidu meeoo netamma. ");
INSERT INTO paoNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","“How haa'a soo John numu baa-wi matzakadu pumme te batsasesapa tuusootabuese, unu poohadooapu? Esoo Jesus John haa'a?” ");
INSERT INTO paoNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Ka o'nosoo soo Herod tu pabe'e nodukwa nodukwadoose, soo mogo'ne Herodias mee naneadu. ");
INSERT INTO paoNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","O'no soo John yise ka Herod ooosapa mee netammano'o, “Gi toge u manakwe. Gi ka Herodias nabaa'yookupana,” mee. ");
INSERT INTO paoNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Oosoo yise ka John unnena gi petzabena oo soobatsapana gi oo manakwe ka mu numu-ma suina. Mu numu ka John Te Naa yadooawabe oedyukute. ");
INSERT INTO paoNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Ka Herod nawuena sooma'yuna tabeno'o soo Herodias padu mu numu ewana-kobena'yoona oo nugakute. Soo Herod yise tubetse besa soonamme. ");
INSERT INTO paoNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Soo Herod yise ka pumme nugakudu meeoo oo netamma, “Tooe hemmadooe u soogwina nu u geakwu.” ");
INSERT INTO paoNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Soo tsuadumu yise ka tu pea tubengase soo pea yise meeoo, “Ka John koota tsekea'ase, yise ka oo wo hanese, yise tseda-wi oo wuna,” ");
INSERT INTO paoNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Soo Herod yise oo nesootu'adya'e ka John tu batsa tuungukwuna, pana ewa'yoo numu yise oo naka ka Herod unnena. ");
INSERT INTO paoNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Soo Herod yise mu tukwutumadu ka John koota tseka'a tuungu. ");
INSERT INTO paoNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Umu ka oo wo tseka'ase oo wo tseda-wi oo wunase, yise ka Herodias padu yongagea'a. Soo tsuadumu yise ka Herodias gea. ");
INSERT INTO paoNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Mu John pupua'amu ka oo nakase yise mease oo tugudooase ka Te Pabe'e tuukwe'e. ");
INSERT INTO paoNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Soo Te Pabe'e Jesus yise ka John nabatsana nakase Te Pabe'e ka tu nakatzimodu-no ka sake-wi kuase ka banunadu ninapatoo natzemangeka numu-wanatoo. Pana ewa'yoo numu ka mu meana nakase ka banunadu-kumi sogo mease oo takwi petuga. ");
INSERT INTO paoNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Soo Te Pabe'e yise ka sake-wi'yoona ka baa-kumabatoo ewow mu numu-baa petuga, oosoo oe'yoona tsebooeke. O'no yise soo Te Pabe'e tutuha mu soobedyana mu tuoegoedu mabesakute. ");
INSERT INTO paoNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ka tu yongokese, numme oo nakatzimodu oo-baa petuse meeoo oo netamma, “U sakwa mu ta'ya ka kwaya'yoona mu kemmase. Umu sakwa puusoo tu tukakwuna hownnekoo mayu.” ");
INSERT INTO paoNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Soo Te Pabe'e Jesus mee ne netamma, “Gi umu numu tayapana, mu sakwa muusoo yaanoko mu maka.” ");
INSERT INTO paoNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Numme ka Te Pabe'e meeoo netamma, “Manegeoo numme tutukutsekoo patzebonomadu tukaba-ga'yoo. Yise waahoo numme too pakwe-ga'yoo.” ");
INSERT INTO paoNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Soo Te Pabe'e meeoo ne netamma, “Yaa nu-matoo oo hanehooke.” ");
INSERT INTO paoNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","O'no yise soo Te Pabe'e mu numu ka pooena mu ne'aata'akuse ka manegeoo tutukutsekoo patzebonomadu tukaba, noko waahoo pakwe hemehoose toogoopatu poonnese nanesootuhi. O'no yise ka tukaba noko pakwe tzabokase umu pumme nakatzimodu mu ewow numu maka tuungu. ");
INSERT INTO paoNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Mu numu yise no'yoona togekoo tukase wutzu'me. Ka tu naduka makwuse numme ka mu tugupenina ka tukaba noko pakwe matsobase oosoo tukapu nagupenina sumu-mano'yoona waha-ma tsebooekudu (12) kawona-wi umu kaanokuhoo. ");
INSERT INTO paoNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Mu numu tubetse ewa'yoo namaka (5000 nanana). ");
INSERT INTO paoNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Soo Te Pabe'e yise ka numme pumme nakatzimodu suu'mu ka sake-wi taya. Umu ka banunadu ninapatoo natzemangekakwu. O'no yise soo Te Pabe'e ka mu ewow numu tuwazoo mu nobe-kwitoosoo ta'ya. ");
INSERT INTO paoNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Soo Te Pabe'e yise ka giba-matoo mease nanesootuha'e, ka tu yongokese oosoo puu suu'mu o. ");
INSERT INTO paoNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Ka sake mooasoo banamookwi manikease, unu hukwabetu soo paa unu bayutsungakooha. ");
INSERT INTO paoNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Awamooasoo gisoo tu tabuagena soo Te Pabe'e ka sake-witoo meahoo baa-koobakwi kemmaka'e. ");
INSERT INTO paoNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Numme tunakatzimodu sake-wi meana ka Te Pabe'e numme-tamme kemmaka'e oo poonne oo-ma unu sui. “Uda! Tsoapa tamme-tamme,” mee numme unnemo'o. ");
INSERT INTO paoNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Soo Te Pabe'e yise mee sookweta unne, “Gi suipana. Nu yow kemma.” ");
INSERT INTO paoNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Soo Peter yise mee oo netamma, “U ka togesapa Ne Pabe'ena ka paa-koobakwi namatoo e bikwu. O'no yise nu u oedyukukwu.” ");
INSERT INTO paoNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","“Yaatoo kemmow,” meeoo soo Te Pabe'e oo netamma. Soo Peter yise ka sake-wi'yoona wuese ka Te Pabe'e-tamme ka baa-koobakwi meahoo. ");
INSERT INTO paoNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ka hukwapa-ma suise too'e padadya'e. Pabatse wa'agenumme, “E Pabe'e e magwetzoi.” ");
INSERT INTO paoNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Soo Te Pabe'e ka paa-wikoo yabesoo oo tzatseboogese oo magwetzoihoo yise meeoo oo netamma, “Mow u ka gi e soo'oedyukuna. U sakwa yaa manakwana gi waha-tamme tusooyugwepana.” ");
INSERT INTO paoNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ka sake-wisoo mu kuase, soo hukwapa wuyooihoo. ");
INSERT INTO paoNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Mu naana ka sake-wi manepunnedu ka Te Pabe'e-matoo nanesootuhikooha, “U tookwa togesapa Te Naa Besaa Tooa.” mee yise oo netamma. ");
INSERT INTO paoNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Umu yise ka mangekase ka Gennesaret mee naneadu-kwi petuga. ");
INSERT INTO paoNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Mu nanana yise onoko ka Te Pabe'e poonnese oo sopedakwadoona oetu mana tooe nanatuukwe. Mu numu yise mu tu'oegoedu mu nuummadu oo-baa tsato petugonno. ");
INSERT INTO paoNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Mu tuoegoedu ka oo-baa petugadyina ka pukwi oo namasooana sukwe tzamayina, besa maniyakwe. ");
INSERT INTO paoNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Mu Jew numu nanesootuhipe papabe'e numu tunedyooedu ka mu Pharisee mee nananeadu-nagatu, ka Jerusalem mee naneadu-kwi'yoona kemmase, ka Te Pabe'e-baa petu. ");
INSERT INTO paoNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","Mu Pharisee yise meeoo ka Te Pabe'e netamma, “How manena mu u nakatzimodu ka te nanamooatupu tumayohope-too gi me'a? Oosoo te tumayohope puu mee te tunedyooe, tamme mooe mabatzagase yise tuka. Pana umu ume nakatzimodu gisoo namabatzagapana tuka.” ");
INSERT INTO paoNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Soo Te Pabe'e mee mu Pharisee nanekwegea, “Mu muusoo ka Te Naa tamme tunetammakupu tagotekena ka mu nanamooatupu tumahohona nagena.” ");
INSERT INTO paoNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Soo Te Naa unnepu mee na'unakwe, ‘Mu sakwa mu naanapua'amu besa matugu yise mu ka mu naanapua'amu suda netammadu sakwa nabatsa.’ ");
INSERT INTO paoNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Mumme putoogoo mooa tumayohona pana mu meeoo, ‘Tamme sumuna ka mu naanapua'amu mee netammakwu. “Nu ka Te Naa God tummatza'e, gi umu e naanapua'amu.” ’ ");
INSERT INTO paoNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Mu gi besa ka mu naanapua'amu matugu ka oo tumatuguna. Mu ka Te Naa tunetammana takopa ka mu mooa tumayohope ooosapa nagena. ");
INSERT INTO paoNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Mu ka Te Naa nakabetse'a mee mu naneyukwe. Soo o'nosoo Te Naa yadooawabe Isaiah togesapa mu netamma ka mee tubotuguna. ");
INSERT INTO paoNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Umu numu meeoo unnepana mu tupa sukwe apeakana gi mu tubetse sokwamana. Umu ka Te Naa gi nakabetsea. ");
INSERT INTO paoNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Umu ka Te Naa-matoo nanesootuha'e mee sukwe naneyugwepana ka mu numu aata-tammesoo ne'emukwa ka pummesoo tusooyugwena ka mu numu ewana mee netamma. “E nakapunne mummesoo tumayohope tumayoho, o'no Te Naa nakabetsea.” ’ ” ");
INSERT INTO paoNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Soo Te Pabe'e ka mu numu ewana mee netamma, “E nakapunne e nakasopedakwatoo. ");
INSERT INTO paoNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Mu sakwa e nakasopedakwatoo soo hemma mu tukana gi hownne'yoo Te Naa-nakwana. Soo suda te tumatuguna, yise gi besa soonammena, umuoo soo Te Naa gi petzape.” ");
INSERT INTO paoNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Umu oo nakatzimodu ka Te Pabe'e-tzage'etoo mease meeoo ka Te Pabe'e netamma, “U haa'a oo sopedakwatoo mu nanesootuhidu papabe'emu Pharisee mee nananeadu unu sutagonno ka ookow nakase?” ");
INSERT INTO paoNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","14","Soo Te Pabe'e meeoo mu nanekwegea, “Mu Pharisee nakatsasoopedya. Soo E Naa puusoo saa'a kadoo'oo mu mayugwedooa, umu Pharisee ka gi ooka naka'oedyukuna. Umuoo ka tsa'abu namasua-kwa'ne'yoo. Umuoo sukwe natuoona pepu'akwu tsa'abu-wa'ne. Umuoo gi tubootabuedu numu kumma'akoosoo gi tubootabuedu numu tzakadu-kwa'ne'yoo. Umu Pharisee gi kaaheno numu neyugwemodu. Umu ooonne'yoo numu ka teepu tawaga-kwitoo sawehookwu ka gi ka besa podo meana.” ");
INSERT INTO paoNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Soo Peter yise ka Te Pabe'e meeoo netamma, “U ka natugwengapu na'unnena ne tuukwe.” ");
INSERT INTO paoNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Mee yise soo Te Pabe'e oo nanekwegea, “Umu ume nakatzimodu gisoo besa e nakasopedakwatoona meeoo unakwe. ");
INSERT INTO paoNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Soo hemma te tukana puu te sapu-kwitoo meana yise kaaheno tsebooegea. ");
INSERT INTO paoNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Pana soo suda mu unnena ka meeoo tuwazoo mu suda tusooyugwe, oosoo suda mu mayugwe. ");
INSERT INTO paoNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Tamme ka suda tusooyugwena sumuna saa'a numu batsadooa, kumanosoo napootamana ka nanodukwana, tuduhana, esayina, suda numu-witu nemadabuena. ");
INSERT INTO paoNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Ka suda tumatuguna soo numu gi besa'yoo; tooe mu ka mu mooe tumayohope nagepana, oosoo gi besa mu mayugwe-wa'ne'yoo.” ");
INSERT INTO paoNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Soo Te Pabe'e Jesus ka numme tu nakatzimodu-no yise oona wawa'a tubewabe-witoo Tyre noko Sidon-witoo mease o petuga. ");
INSERT INTO paoNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","O'nona yise sumu'yoo wawa'a mogo'ne oo-baa petuse meeoo oo netamma, “E Pabe'e u sakwa e tummatzi, e padu unu tsoapaya'e ooka oo nematzagakwuniku.” ");
INSERT INTO paoNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Pana soo Te Pabe'e yise gi ka wawa'a mogo'ne nanekwege'a. Numme oo nakatzimodu yise meeoo ka Te Pabe'e netamma, “Ka mogo'ne taya, oosoo te nakwi nanetzakwiya'e kemmano'o.” ");
INSERT INTO paoNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Soo Te Pabe'e yise meeoo mu netamma, “Nu mu Jew numu suu'mu magwetzoigena.” ");
INSERT INTO paoNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Soo wawa'a mogo'ne yise oo-kobena meatzedo petusoo mee'esoo tuwazoo unne, “E Pabe'e, e tummatzi.” ");
INSERT INTO paoNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Soo Te Pabe'e yise oo sukwe nemapoonnena meeoo oo netamma, “Gi nu wawa'a sootummatzi. Numme Jew mu wakwawa'a sadu'u mee ne'a. Mu numu puu tu dooamu tukakwuna tu sadu'u gi maka.” ");
INSERT INTO paoNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Yise soo wawa'a mogo'ne mee punno'o nanekwegea, “Tooe sadu'u pana puu ka hemma nagupenina namaka. U sakwa nuga padu mabesaku u nanumu noko,” mee. ");
INSERT INTO paoNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Soo Te Pabe'e yise ka wawa'a mogo'ne meeoo netamma, “Besa'yoo u e naka'oedyukudu u ka meeoo unnena nu u tummatzikwu. U nobe-kwitoo yise kodyuka nu ka tsoapa mooasoo nematzagakwunihoo,” mee'e. Soo mogo'ne padu yise besa mani. ");
INSERT INTO paoNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Soo Te Pabe'e yise ka numme tu nakatzimodu-no oona mease, ka banunadu Galilee mee naneadu kumi me'a. Soo Te Pabe'e yise ka gibana manepetugase oonahoo katu. ");
INSERT INTO paoNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ewa'yoo numu oo-baa petudyipunne, nanakumma'akoosoo tuoe-ga'yoo susumudu toyodu, susumudu gi tubootabuedu, susumudu gi nummedu, susumudu gi apegeadu. Mu tuoegoedu numu no'yoona Te Pabe'e-kumaba natzapookwakute. Soo Te Pabe'e yise no'oko mu mabesaku. ");
INSERT INTO paoNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Mu numu yise mee nana'unakwe, “Mu gi apeageadu apegea mani, umu gi yuyutsungamodu nummenumme mani, mu totoyodu kaaheno mo mani, mu gi tutubooetubooedu punno'o yaatu poonne mani. Soo Te Naa tubetse besa'yoona tooe gi te Jew numu sapa te sootuha'e.” ");
INSERT INTO paoNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Saa'a yise soo Te Pabe'e numme pumme nakatzimodu mee netamma, “Nu mu numu sootuha'e. Umu pahe tabeno ooosapa nu-no'yoona, gi hemma tuka. Nu gi mu tayakwuni-wa'ne nuumma ka mu tzuago'e. Umu-matu sumuna mana po-witoo tsea'anooakwu, tamme sakwa mu maka.” ");
INSERT INTO paoNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Numme oo tunakatzimodu yise mee Te Pabe'e netamma, “Tamme gi mu maka-wa'ne'yoo. Tamme gi hownnekoo yaatuoo tukapu mayu-wa'ne'yoo.” ");
INSERT INTO paoNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","“Haa'noko tamme tukaba-ga'yoo?” mee soo Te Pabe'e. “Natakwatsukwu'yoo (7) tamme tukaba-gana yise tamme huuhoosoo dudutsekoo pakwe,” mee numme ka Te Pabe'e nanekwegea. ");
INSERT INTO paoNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Soo Te Pabe'e ka numu ewana ka teepu-kooba aata tuungu ");
INSERT INTO paoNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","yise ka natakwatsukwu'yoo tututsekoo tukaba tu mi-wi hemmase, ka pakwe nokosoo, Te Naa-matoo nanesootuha'e, yise ka tukaba tzabokase, ka pumme nakatzimodu mu ewow numu maka tuungu. ");
INSERT INTO paoNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","No'yoona numu yise wutzu'mehoo. Numme oo nakatzimodu ka mu tugupenina natakwatsukwuoo kawona kaanokuhoo. ");
INSERT INTO paoNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Umu tubetse ewatse'yoo numu yise oe (4000 naana). ");
INSERT INTO paoNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Soo Te Pabe'e noko yise mu numu nobe-kwitoo tayahoose ka sake-wi tsebooese, ka baa natzemangeka ka Magadan mee naneadu teepu-witoo mea numme pumme nakatzimodu-no. ");
INSERT INTO paoNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Mu nanesootuhidu moohedu ka mu Pharisee noko Sadducees mee nananeadu-nagutu kemmana ka Te Pabe'e nesootzemanasoo oo-baa petuhoose mee oo netamma, “Ka pa'anakwanasoo nanasookwugidu tumadipu ne tzapoonneku, o'no yise numme u naka'oedyukukwu.” ");
INSERT INTO paoNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Te Pabe'e mee mu netamma, “Mu oo sopedakwatoo mooa tabeno besa nuummapunnekwu ka yaa yongona gi tu koomeapunne. ");
INSERT INTO paoNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ka yaa togano ka muha nakagoapunne, mu oo sopedakwatoo mooa tomoapunnekwu. Mu mooasoo ka koomeba-witu sopedakwatoo pana mu gi oo nakasopedakwatoo ka teepu manekwuna ka nuka, mu Pabe'e petuse. ");
INSERT INTO paoNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Mu numu meno'o mommodu suta'yoo mu ka nanabesa e tumadina mumme e tzapoonneku tuunguna, o'no mu e soo'oedyukukwu mee nu unnena. Mu sakwa oo sopedakwatoo nuga hownne'yoona, nu ka Jonah-wa'ne'yookwu. O'nosoo soo Jonah puu pahe tabeno ka pakwe numua-wi'yoose sapa gwetzoise ka teepu-koobasoo tuwazoo nummenumme. Nu Jonah-wa'ne'yookwu. Ooonne'yoona nu ka ya'ese pahe tabeno manepunnese namayodakwu. O'no yise mu oo sopedakwadookwu, nu yow Mu Pabe'e.” ");
INSERT INTO paoNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Soo Te Pabe'e yise umu-baa'yoona mea numme pumme nakatzimodu-no ka banunadu natzemangeka. Numme oo nakatzimodu ka tukaba ne tunokwuna soomu'wake. Soo Te Pabe'e meeoo ne netamma, ");
INSERT INTO paoNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","“Mu sakwa ka mu Pharisee noko Sadducee tukaba namayana nuutumooe.” ");
INSERT INTO paoNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Numme yise mee nananetamma, “Oosoo meeoo unakwe ka gi tukaba te hanekese.” ");
INSERT INTO paoNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Soo Te Pabe'e oo sopedakwatoo ka ne unnena, yise mee ne netamma, “Mu tookwa gisoo e naka'oedyukute. ");
INSERT INTO paoNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Mu sakwa tooe gi tukaba-gapana gi suda oo sooyugwepana. Mu sakwa e nakasopedakwatoo, nu mu mabetseakwu. Mu sakwa oo soomayu sumu, nu ewow numu maka manegehoosoo (5) tukaba-gana. Mu oo sooma'yu ka ewow nagupenina muusoo tzoba. ");
INSERT INTO paoNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Nu mooasoo yise tuwow ewowsoo numu maka, natakwatse'yoo (7) tukaba-gana, mu yise ewowsoo tuwazoo hane ka a nagupenina. ");
INSERT INTO paoNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Mu sakwa tuwazoo oo sopedakwatoo nu gi tukaba-witu netamma. Mu sakwa ka mu Pharisee noko Sadducee tukaba namayuna nuutumooe.” ");
INSERT INTO paoNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Numme oo nakatzimodu yise ka Te Pabe'e nakasopedakwatoo, oosoo gi ka tukaba-witu netammana pana ne tuukwena gi ka mu Jew numu nanesootuhibu numu tunedyooedu nakabetseapana, umu ka besow ka sutakoo noko mayu'a. ");
INSERT INTO paoNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Soo Te Pabe'e ka Philippi mee naneadu teepu-wi petuga soo Te Pabe'e ka numme tunakatzimodu meeoo tubenga, “Ha'yoo mu nu-kwitu naka?” ");
INSERT INTO paoNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Numme tunakakatzimodu yise meeoo ka Te Pabe'e nanekwegea, “Susumudu umu-matu mee u netamma, ‘U ka sumuna John, numu baa-wi matzakadu.’ Susumudu yise punno'o meeoo, ‘U, Ne Naa yadooawabe Elijah mee naneadu, pute Jeremiah mee naneadu, tooe haga tooe sumuna ka umu Te Naa yadooawabe-matu.’ ” ");
INSERT INTO paoNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Soo Te Pabe'e ka numme pumme nakatzimodu meeoo netamma. “Mu puu ha'yoo e sooyugwe?” ");
INSERT INTO paoNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Soo Simon Peter oo nekwegea, “U yow Ne Pabe'e. U ka Te Naa Besaa Tooa'a.” ");
INSERT INTO paoNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Soo Te Pabe'e yise meeoo ka Simon Peter netamma, “U Simon, Jonah tooa, soo Te Naa tookwa u sootuhipuna u tunedyooepu. Ooonne'yoona u e nakasopedakwadoo. Sukwe numu gi nu-kwitu meeoo u tunedyooe-wa'ne'yoo. ");
INSERT INTO paoNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Yaa manakwana nu Peter mee u neakwu, Tupe mee na'unnedu. U tupe-wa'ne'yoo u e tubetse naka'oedyukute, nu yow U Pabe'e. U ka yaa teepu-koobatu nanesootuhikuna, soo te pa'anakwatu u nakasootuhikwu. O'no numme nanesootuhidu ka Etza'a suda unnepu matzooekukwu. ");
INSERT INTO paoNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Nu E Besa Pooha-matu-ma u sootuhikwu, u saa'a ewow numu ka nanesootuhibu tunedyooedooa. Soo E Besa Pooha nayadooana mooasoo Te Naa tunemamakwupu, ookow u punno'o mayohonokwu.” ");
INSERT INTO paoNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Soo Te Pabe'e meeoo ne netamma, “Gi meno'o e wahapana nu yow Mu Pabe'e.” ");
INSERT INTO paoNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Soo Te Pabe'e oowe manakwana ooosapa ka umu pumme nakatzimodu mee tuukwegena, “Nu Jerusalem-wi petugase mu Jew numu moohedu e kusedyana e batsakwu. Pana waha tabe mease nu tuusootabuekwusoo.” ");
INSERT INTO paoNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Soo Peter yise seagabatoo ka Te Pabe'e bise oo nesagwikuna mee'e oo netamma, “Nu ka Te Naa-matoo u nanesootuhikukwu. Soo Te Naa u sootuhise u gi nabatsakwu, gi yise meeoo tusooyugwepana.” ");
INSERT INTO paoNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Soo Te Pabe'e yise oo nakasopedakwadoose ka Peter-tamme nakwumanase mee oo netamma, “Gi ookow e tuukwepana. U sukwe numu-wa'ne tusooyukwe ka suta'yoona, u gi ka Te Naa-ma nasoonatza'e.” ");
INSERT INTO paoNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Soo Te Pabe'e yise numme nakatzimodu mee netamma, “Soo tooe haga tooe nuka naka'oedyukudu sakwa mee unne, ‘Gi hownne'yoo tooe nu ka Te Pabe'e-koobatoo nabatsase sapa, nu oo nagenokwu.’ ");
INSERT INTO paoNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Tooe haga tooe ka nu-koobatoo nasoomawunina oosoo namagwetzoikwu. Soo tooe haga tooe ka puusoo too'e namagwetzoina puusoo kadoo'oo namayugwekwu. ");
INSERT INTO paoNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Soo tooe haga tooe ka teepu-kooba'yoona ewow hee-gana ya'ese soo ewow oo hee-gana gi oo magwetzoi-wa'ne'yoo. ");
INSERT INTO paoNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Nu, Mu Pabe'e, ka E Naa pooha tooha-kwi ka umu Te Naa tummatzidu toha kakasa-ga-no petuse saa'a ka mu numu nemadabuekwu. ");
INSERT INTO paoNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Nu togesapa mu tuukwekwu susumudu meno'o yow mu konnodu-matu gisoo tuidu, mu ka Te Naa pooha-toohakwi e gwetzoina poonnekwu.” ");
INSERT INTO paoNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Naapahe tabe mease soo Te Pabe'e pihoo tu pupuamu oona kiba-matoo bika, mu oo pupua'amu mee nananeadu Peter-no, James, yise oo wannga'a John. ");
INSERT INTO paoNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Togesoo ka Te Pabe'e nanesootuha'e oo koba atasoo tubuaga'a, yise pukwi oo namasooana tohawiyanega'a, yise patakwetseapunne. ");
INSERT INTO paoNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Waha'yoo nanana Moses-no Elijah mee nananeadu yise oo-baa petuse oo-no yadoo'a. ");
INSERT INTO paoNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Soo Peter yise meeoo ka Te Pabe'e netamma, “Besa numme ka yaanona, ka oo u soomanakwe numme sakwa pahe tutukutsekoo tatza nobe mu matabuekukwu umme Elijah yise Moses.” ");
INSERT INTO paoNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Togesoo oo yadooawunu oosoo koomeba umu-kooba habagahoo petu. Oonaga'yoona yise soo Te Naa mu yadooe, “E Besaa Tooa unu e soobedyana, besa e masoonammedu, mu sakwa besa a nakabetsea.” ");
INSERT INTO paoNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Umu oo pupua'amu unu nakasui meatzedose oo-matoo nanesootuhigonno. ");
INSERT INTO paoNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Soo Te Pabe'e umu-matoo mease yise mu tzamase meeoo mu netamma, “Yosuhoo gi suipana.” ");
INSERT INTO paoNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Umu yise yaatu poonnese, soo Te Pabe'e suu'mu yise o. ");
INSERT INTO paoNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Umu ka giba-ma'yoona sawekese soo Te Pabe'e yise meeoo mu netamma, “Gi haga tuukwepana ka yaanoko mu poonnepu ka e namayodase saa'a mu numu tuukwe.” ");
INSERT INTO paoNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Numme Te Pabe'e nakatzimodu oo tubenga, “Ha'yoo unnena mu Jew numu nanesootuhi moohedu meeoo numu tunedyooe, ‘Soo Elijah mooe petugakwu’?” ");
INSERT INTO paoNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Soo Te Pabe'e meeoo mu nanekwegea, “Oosoo yoo kaaheno manepunne. Elijah mooe petuse hemma e mooe nemabetseabekupu. ");
INSERT INTO paoNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Mooasoo soo Elijah mu-baa petupu pana mu numu gi oo posopedakwadoo mee'e nu. Umu tooe how tooe Elijah sootunagapu oo batsapu. Umu nuka tuwazoo kusegeana e batsakwu.” ");
INSERT INTO paoNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","O'no numme oo nakatzimodu yise oo nakasopedakwadoo soo John Baa-wi Numu Matzakadu tookwa Elijah. Oosoo Te Pabe'e-kobenasoo nanekemmadu. ");
INSERT INTO paoNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Soo Te Pabe'e bihoo numme pumme nakatzimodu-no ka numu ewa-kwi petugonno sumu'yoo nana ka Te Pabe'e-baa meatzedohoose mee oo netamma, ");
INSERT INTO paoNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“U sakwa ka e tooa nanesootuhiku masoo ya'ehookayina sumutooe ka numu peta-kwitoo anoakayakwe yise ka baa-witoo wuehooyakwe tuwazoo. Oo manena masoo unu nuummaba wuma. ");
INSERT INTO paoNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Nu ka umu ume nakatzimodu-baa a bi petuse sapa umu gi a mabesakute.” ");
INSERT INTO paoNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Soo Te Pabe'e mee unakwe, “Mu gi e tubetse naka'oedyukute tooe nu wuna'me yaa mu-baa'yoose sapa. Mu sakwa e naka'oedyuku. Ka naatse yaa nu-baa bi petu.” ");
INSERT INTO paoNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Soo Te Pabe'e yise ka tsoapa ka naatse-nagakoo nematzagakwunihoose, soo naatse yise besa mani. ");
INSERT INTO paoNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Numme tunakatzimodu ka Te Pabe'e-no oetu watze nehanena mee unakwe, “How yise manena numme gi ka tsoapa nematzagakwuna'e?” ");
INSERT INTO paoNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","21","Soo Te Pabe'e mee ne netamma, “Mu gi oo nematzagakwuna'e mu ka gi tubetse tunaka'oedyukuna. Mu sakwa uga ka tubetse tunaka'oedyukuna tooe ka tuutsetse tunaka'oedyukuna sapa mu ka giba nooyooa tuunguna oosoo oo manikwu. Mu ka tubetse tunaka'oedyukuna tooe hemma tooe oo natuunguna o nageakwu.” ");
INSERT INTO paoNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Ka saa'a Galilee-wi ne petugase soo Te Pabe'e mee ne netamma, ");
INSERT INTO paoNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","“Umu e wohomu nu-ma tzakaduse, e batsakwu yise waha tabe mease nu saa'a e ya'e-kwikoo namayodakwu.” Numme oo tunakatzimodu suda nakasokwama ka Te Pabe'e meeoo unakwe. ");
INSERT INTO paoNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Soo Te Pabe'e numme pumme nakatzimodu-no ka Capernaum mee naneadu-wi petuga, soo pabatsekoo nanesootuhi nobe-witu tumasumudoodu ka Peter-baa petuoose mee oo tubenga, “Soo Jesus haa'a punno'o ka nanesootuhi nobe-witu tumanagayakwe?” ");
INSERT INTO paoNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","“Aha soo Te Pabe'e oo manekwu,” mee soo Peter oo nanekwegea. Ka nobe Te Pabe'e pukwe'yoo-kwi soo Peter egeagase soo Te Pabe'e mee oo mooe netamma, “Ha'yoo u oetu sooyugwe, Peter? Soo numu-kooba katudu puu gi pummesoo dooamu tunekwa'e, ka tu tumasumudookwi oosoo mu wakwawa'a suu'mu tunekwikwu haa'a?” “Mu wakwawa'a-makoo suu'mu,” mee'e soo Peter oo nekwegea. ");
INSERT INTO paoNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","“Nu tookwa ka Te Naa tooana gi tumanaga-wa'ne'yoo,” mee'e soo Te Pabe'e. ");
INSERT INTO paoNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","“Pana ta ka tumanagase umu gi taka sutakute.” Soo Te Pabe'e ka Peter pakwega tayase, mee oo netamma, “Ka banunadu-kwi petugase saa'a ka u mooe pakwe tutzatsebooana tupa-witu poonne ka u tumayu-ma saa'a ta-kooba tumanagahoo.” ");
INSERT INTO paoNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Numme Te Pabe'e nakatzimodu ka Te Pabe'e mee'e tubenga, “Haga saa'a ka numme-matu numu oooonakwa besa'yoo ka numme Te Naa-baa ne petugase?” ");
INSERT INTO paoNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Soo Te Pabe'e yise ka tuutsekoo tuha'akoo tzakwuhoose umu-naga oo tzakwunukuhoo. ");
INSERT INTO paoNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Yise mee unakwe, “Nu kaaheno mu tuukwekwu, mooe'ugasoo mu nanekwahakwu oo nematzagakwunikwu, mu yise tutugusekoo dooake-wa'ne'yookwu. O'no yise mu ka Te Naa-baa petugadooa. ");
INSERT INTO paoNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Mu ka tuha'a-kwa'ne manekoo petuse, mu gi numu oooonakwa besa'yoo mee nasooyugwena. Soo tuha'yoo yise e tubetse nakatzimodu-kwa'ne'yoo. O'no yise mu numu-oooonakwa besa'yookwu ka Te Naa-baa'yoona. ");
INSERT INTO paoNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Mu ka nuga dooamu pua'a-gana, o'no mu nuga pua'a tuwazoo. ");
INSERT INTO paoNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Soo tooe haga tooe ka umu nuga dooamu suta-kwitoo kwasenona ka mu tuma'emukwase, oosoo oo tuma'emukwana oo-matoosoo kodyukwu. ");
INSERT INTO paoNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Mu yaa'a teepu-koobatu numu ewa'yoo gi toge-tamme nakwasenodu, saa'a mu tuma'emukwana mu-matoosoo kodyukwu. ");
INSERT INTO paoNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Nu sakwa e-mi sukwe tseka'a yise gi ka suda namanedu mahane. Besa'yoo ka sumuoosoo mi-gana Te Naa-baa petugase, gi waahoo mi-gana ka ooosapa nikatu-kwitoo wue. Nu sakwa e kuku sukwe tseka'a ka gi togekoo podo meana. Besa'yoo ka sumuoosoo kuku-gana Te Naa-baa petugase, gi waahoo kuku-gana ka ooosapa nikatu-kwitoo wue. ");
INSERT INTO paoNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Nu sakwa tuwow e pooe sukwe tsepata ka gi togekoo soopoonnena. Besa'yoosoo ka sumuoosoo pooe-gana Te Naa-baa petugase, gi waahoo pooe-gana ka ooosapa nikatu-kwitoo wue. ");
INSERT INTO paoNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","11","Mu sakwa gi e dooamu matu suda matugupana mu toha kakasa-gakoo, Te Naa tummatzidu, ooosapa Te Naa-baatu, e dooamu mabetseana mu nanesootuhiku. ");
INSERT INTO paoNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Mu sakwa ekow nakasopedakwatoo, soo nana puu ka ewow tu seepu hee-gana, sumuoo watzekuse, oosoo ka mu ewow tu seepu ma'wukase ka sumuoo watekakwu. ");
INSERT INTO paoNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Yise ka oo mayuse ka mu ewow gi nawatzekudu oooonakwasoo besa oo-matoo soonammekwu. ");
INSERT INTO paoNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Soo Te Naa punno'o ooosoo tamme-koobatoo ka umu pumme dooamu nawatsekukwuna gi petzape. ");
INSERT INTO paoNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Ka tunaka'oedyukudu-matu suda pumme matuguse, u sakwa oo tuukwe gi numu nakana. Oosoo ka u nakabetseana, o'no u oo magwetzoikwu. ");
INSERT INTO paoNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Pana ka gi ume oo nakabetsea, u sakwa sumuoo tooetoo waahoo u pupua'amu-matu bikase onosoo apegea. O'no mu numu u-notu u nakase oo wahakwu. ");
INSERT INTO paoNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Oosoo ka gi mu nakabetseana, mu sakwa ka mu nanesootuhidu-baa petugase oo waha. Ka gi mumme oo nakabetsea, mu sakwa oo tsasoopedya. ");
INSERT INTO paoNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Nu kaaheno mu tuukwe, mu ka sumuoo numu meeoo neyugwese, soo Te Naa te pa'anakwatu punno'o ooosoo. ");
INSERT INTO paoNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Nu tuwazoo sumubatu kaaheno mu tuukwekwu, ka waahoo mu nagatu ka Te Naa-matoo nanetsagwayina, soo Te Naa mu nakasootuhikwu. ");
INSERT INTO paoNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Ka waahoo tooetoo pihoo nanano sumuse ka nuka mu naka'oedyukuna nu-matoo mu nanesootuha'e nu umu-no'yookwu.” ");
INSERT INTO paoNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Soo Peter yise ka Te Pabe'e mee tubenga, “Ne Pabe'e, huu sakwa nu ka e pua'a suda nuka matugu oo soomu'wa'yi? Natakwatsukwu (7) haa'a?” ");
INSERT INTO paoNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Soo Te Pabe'e meeoo oo nanekwegea, “Tooe hano sapa oo matuadyigena yise ka ooka oo nemakodyukuyakwe tamme sakwa ooosapa punno'o oo soomu'wano. ");
INSERT INTO paoNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Soo numu-kooba katudu puu ka mu pumme tummatzidu kutzina oo soogwa'e. ");
INSERT INTO paoNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Sumu'yoo nana ka numu-kooba katudu-baa nabi petu, tubetse ewow oo nakutzikudu gi hownnekoo oo tumanagakute. ");
INSERT INTO paoNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Soo numu-kooba katudu yise meeoo oo netamma, ‘U nodukwa, u doodooamu, no'oko hemma u hee-ga-ma u tumukwu, u ka gi hownnekoo punowsoo e tumanagaku-wa'ne manepunnena.’ ");
INSERT INTO paoNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Soo nana ka numu-kooba katudu meeoo netamma, ‘U sakwa e sootuhina, gi nuga hemma-ma tumupana. Nu sakwa tooe hownnekoo dooe no'oko punowsoo u tumanagaku.’ ");
INSERT INTO paoNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Soo numu-kooba katudu oo nakasootuhise meeoo oo netamma, ‘Gi hownne'yoo tooe u ka gi punowsoo e tumakodyukupana. U sakwa meno'o nobe-witoosoo kodyuka.’ ");
INSERT INTO paoNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Soo nana ka numu-kooba katudu tutuha soobedya yise mease sumuoo numu tapoegea huutsekoo pumme nakutzikudu. Oo-ma tzakaduse oo tooe matsongakwadyabe. ‘U sakwa ka nuka u nakutzikuna e tumanagaku,’ mee oo netamma. ");
INSERT INTO paoNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","‘Nu gi hownnekoo meno'o u tumanagaku-wa'ne'yoo pana nu saa'a no'oko tooe hownnekoo tooe ooka u makodyukudooa. U sakwa tutuha e soobedya.’ ");
INSERT INTO paoNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Pana oosoo gi tutuha oo soobedyana ka nana wutuma tu nakutzina oo tumanaga-witoo tooe. ");
INSERT INTO paoNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Mu numu-kooba katudu tummatzidu ka nana manena poonnena suda oo soobedya. Umu ka numu-kooba katudu-baa petugase ka nana manena oo tuukwe'e. ");
INSERT INTO paoNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Soo numu-kooba katudu ka nana nabatoo bise, meeoo oo netamma, ‘U suda manakwe. Nu mooasoo meeoo u netammapu, “Gi hownne'yoo tooe u gi ka u nakutzina tumanagapana.” ");
INSERT INTO paoNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","U puu ka u pua'a gi tutuha soobedya ka ume oo nakutzikute. U sakwa tutuha mu numu u soobedyana sootuhi, nu puu tutuha u soobedyana u sootuhipu.’ ");
INSERT INTO paoNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Soo numu-kooba katudu ka sutakoo nana besa tu matugukwuna gi petzabepana oo wutuma tuungu, no'oko tu nakutzina oo tumanaga-witoo tooe. ");
INSERT INTO paoNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Tamme ka te pupua'amu suda tamme matugupu gi soomu'wana soo te tuma'emukwana tamme-matoosoo kodyukwu.” ");
INSERT INTO paoNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Soo Te Pabe'e Jesus ka mu numu tunedyooemakwuse Galilee-wi'yoona mea, ka teepu Judea mee naneadu-koobatoo. Te Pabe'e ka meana ka hooodu Jordan mee naneadu mangeka. ");
INSERT INTO paoNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Ewa'yoo numu yise oo nagekase soo Te Pabe'e Jesus yise mu mabesakute. ");
INSERT INTO paoNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Mu Pharisee Te Pabe'e-baa petuse oo too'e nekwesekuna, ka numu nanodukwa napoonnekwuni-kwitu. ");
INSERT INTO paoNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Soo Te Pabe'e yise meeoo mu nanekwegea, “Mu ka tuneana o'nosoo ka Te Naa numu pudu manumudoose meeoo na'unakwe, ‘Nu ka nana noko mogo'ne manumu-doopu. ");
INSERT INTO paoNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Soo nana-no mogone ka nanodukwadoose tu naanapu'amu-kooba'yoona mease umu yise sumuoosoo numu-wa'ne'yoo.’ ");
INSERT INTO paoNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Soo Te Naa mee'e soo numu ka nanodukwadoose sakwa gi napoonnekwunipana.” ");
INSERT INTO paoNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Umu Pharisee yise meeoo ka Te Pabe'e netamma, “How yise soo Moses mooasoo ka meeoo tunetammana, ‘Soo numu ka napoonnekwunikwuse tubope-makoo napoonnekwuna'e?’ ” ");
INSERT INTO paoNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Soo Te Pabe'e yise meeoo mu nanekwegea, “Mu ka gi Te Naa nakabetseana ooonne'yoona soo Moses meeoo mu tunetammakute mu ka napoonnekwunikwuse tubope-makoo napoonnekwuna'e. Pana ka Te Naa numu pudu manumudoo-kwi manakwana meeoo nayadooa ka nanodukwadoose gi napoonnekwunipana.” ");
INSERT INTO paoNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Soo Te Pabe'e Jesus yise meeoo tuwazoo mu netamma, “Soo numu ka tu nodukwa poonnekwunise tooe gi kumma'akoosoo nana-no oo tuma'emukwa sapa ka kumma'akusoo nodukwadoose ma'emukwa. Oosoo suda tumatugudu.” ");
INSERT INTO paoNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Numme Te Pabe'e nakatzimodu mee ka Te Pabe'e netamma, “Numme sakwa gi uga nodukwadoopana sumuna puu numme saa'a napoonnekwunikwu.” ");
INSERT INTO paoNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","12","Soo Te Pabe'e mee ne netamma, “Susumudu numu gi hownnekoo nanodukwadoo-wa'ne'yoo umu ka tooe hownnekoo tooe namaniyahapugana, susumudu punno'o numu gi nanodukwadoo umu ka Te Naa suu'mu sooabegana. Gi no'yoona numu ka eka meeoo na'unnedu nakabetsea-wa'ne'yoo.” ");
INSERT INTO paoNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Mu numu tu dooamu ka Te Pabe'e-baa bi petudyakwe ka umu oo nanesootuhiku tuunguna mu sootuhi mee oo netammana. Numme Te Pabe'e nakatzimodu mu numu nesagwikute ka oo mu manakwe. ");
INSERT INTO paoNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Pana soo Te Pabe'e mee mu netamma, “Gi mu numu ka mu tu dooamu bi petudu nesagwikupana. Nu mu tutugutsekoo dooake nanesootuhikukwu umu-wa'nekoo sokwama-gakoo soo Te Naa besa dooamu-ga'yoo.” ");
INSERT INTO paoNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Soo Te Pabe'e yise mu dooake nanesootuhikuse umu-ma pooha matugumena mu sootuhina yise umu-baa'yoona mea. ");
INSERT INTO paoNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Sumu'yoo nana ka Te Pabe'e-baa petuga mee tutubenguna, “U tubetse besa'yoo nana ha'oo besa sakwa tuwow nu manese namagwetzoi?” ");
INSERT INTO paoNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Soo Te Pabe'e mee'e oo nanekwegea, “U sakwa gi nuka ka besa-witu tutubengapana, soo Te Naa suu'mu besa'yoo. U ka soonamagwetzoina u sakwa ka Te Naa unnepu suu'mu nakabetsea.” ");
INSERT INTO paoNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","“No'oko haa'a?” mee soo nana ka Te Pabe'e tutubenga. Soo Te Pabe'e meeoo oo nanekwegea, “Aha. U sakwa gi numu batsapana, gi numu nowuakupana, gi tuduhapana, gi esayipana numu-witu ");
INSERT INTO paoNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","besa tu naa noko tu pea sooyugwena. U sakwa unu mu numu-no nanasoobedya, mummesoo nasoobedya-kwa'ne.” ");
INSERT INTO paoNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","“Mooasoo nu ka a nabotugu-kwa'ne tumaduku,” mee soo nana, “Nu haa'a namagwetzoikwu?” ");
INSERT INTO paoNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Soo Te Pabe'e mee'e oo nanekwegea, “U sakwa no'oko u hemma-ma tumuse ka u nahemena ka mu tutuha manedu hanekuse, o'no yise u ewow hee-gakwu ka Te Naa-baa'yoona. O'no u yise e nakatzinummekwu.” ");
INSERT INTO paoNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Soo nana ka ewow hee-gana suda oo nakasoonammekuna mea. ");
INSERT INTO paoNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Soo Te Pabe'e numme pumme nakatzimodu mee netamma, “Nu kaaheno mu tuukwekwu. Soo ewow hee-ga'yoo numu unusoo manena namagwetzoikwu. ");
INSERT INTO paoNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Gi hownnekoo soo ewow hee-ga'yoo numu puusoo namagwetzoi-wa'ne'yoo.” ");
INSERT INTO paoNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Numme ka Te Pabe'e meeoo unakwe oo nakase mee'e punno'o unakwe, “Hownnekoo soo numu tutuha manedu namagwetzoikwu?” Numme meeoo sokwama soo ewow hee-ga'yoo numu besa nasootuhipuna namagwetzoa'e. ");
INSERT INTO paoNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Soo Te Pabe'e ne poo'nekwunihoose mee ne netamma, “Gisoo mu e nakasopedakwadoo, mu gi muusoo namagwetzoi-wa'ne'yoo. Soo Te Naa suu'mu mu magwetzoikwu.” ");
INSERT INTO paoNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Soo Peter yise meeoo oo netamma, “Numme no'oko hemma ne hee-gana ma'wugese ume nageke. Hemma yise numme hee-gakwu?” ");
INSERT INTO paoNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Soo Te Pabe'e yise mee'e ne nanekwegea, “Nu kaaheno mu tuukwekwu. Ka teepu atasoo manekese, nu ebe te pa'anakwa'yoona numu nemadabuekwu, mu yise e nakatzimodu punno'o no'oko mu (12) Jew numu nemadabuekwu. ");
INSERT INTO paoNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","No'yoona numu tu nobe ma'wukadu, tu nanumu, tu hemma, no'oko tu hee-gana, tu doodooamu, tu tubewabe, ka nuka nagena, ewowsoo besa no'obatusoo nasootuhikwu ka gi moobegwaga ka gwetzoibu-ma besa'hoo nasootuhikwu. ");
INSERT INTO paoNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Umu yaa'a teepu-koobatu meno'o numu moohedu, saa'a ka Te Naa-baa'yoona gi hee manepunnekwu. Umu meno'o gi maawa'ne'yoo yaa'a teepu-kooba manepunnedu, ka Te Naa-baa'yoona numu moohedooa.” ");
INSERT INTO paoNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Te Pabe'e togesoo te tunedyooemena. Esoo tamme oo tunedyooena ka Te Naa umu pumme tummatzidu besa sootuhi-witu mee yise oo netamma, “Soo Te Naa ka nana-wa'nesoo puu ka awamooasoo mu numu tu tubewabe-witu a pooe tzaboka tuungu. ");
INSERT INTO paoNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Esoo nana puu ka pumme tutzabokakudu tunemanagakute umu yise oo ne'oedyukute. ");
INSERT INTO paoNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Saa'a oogowsoo awamooa soo nana tubewabe hee-ga'yoo ka mu numu-nagatu gi hemma how yugwedu natummatzibu wategase mu ");
INSERT INTO paoNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","mayuse meeoo mu netamma, ‘Mu sakwa e tutzabokaku. Nu saa'a mu tumanagakudooa.’ ");
INSERT INTO paoNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ka tabeno tu manekese tu yongokese tuwazoo ooosoo tuwazoo manakwe. ");
INSERT INTO paoNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Gisoo tu taba egeaga'a soo nana tuwazoo measesoo ewasoo numu gi hemma howyugwedu too mayuse mee mu netamma, ‘Mu haa'a tabewano yow?’ ");
INSERT INTO paoNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Umu yise meeoo oo nanekwegea, ‘Aha, gi dea'a haga ne natummatzi tuungu.’ ‘Mu sakwa nuka tummatzi,’ mee yise soo nana mu netamma. ");
INSERT INTO paoNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Ka tu nayakwengase soo nana tubewabe-ga'yoo ka umu pumme tummatzidu moohedu mee netamma, ‘No'oko umu nuka tummatzigonnodu mu bise mu tumanagakuhoo. U sakwa ka umu nakwi petudu mooe tumanagakuhoo, o'no yise mu susumudu ooosoo ka umu mooe'ugasoo petudu tumanagaku tuwazoo.’ ");
INSERT INTO paoNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Umu numu nakwi petudu ka umu mooe'ugasoo petupu no'okosoo saa'a tumunagaku. ");
INSERT INTO paoNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Umu mooe tutummatzi petudu numu oooonakwakoosoo natumanakakukwu mee sokwamapunnepana, umu no'yoona nanano'okosoo natumanakakuhoo. ");
INSERT INTO paoNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Mu mooe tutummatzi petupu ka nana tubewabe-gakoo nesootzema mee unnena. ");
INSERT INTO paoNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘Ha'oo manena mu ne-nakwi petupunnedu numme no'okosoo natumanakakute? Numme yise tabewano yow tooe kootuise sapa umu nokosoo natumanakakute.’ ");
INSERT INTO paoNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Soo tubewabe hee-ga'yoo yise mu naka ka mu nenisago'e ka sumuoo umu-matu mee netamma, ‘E pua'a, nu kaaheno u tumatugukute. Nu ooka u gea ka ume e tuukwe-kwa'nesoo. ");
INSERT INTO paoNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Mu sakwa mumme e gea-matoo besa sokwama. Nu meeoo mesoo tusoohanena sumu no'okosoo mu mesoo tumanagakute. ");
INSERT INTO paoNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Esoo u natumanakakuna nugatu. U sakwa gi moogoo tusooyugwepana, nu ka no'oko numu sootuhina tooe gi haa'no mu tutzabokase sapa numu no'oko tumanagakute.’ ");
INSERT INTO paoNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Umu yaa'a teepu-koobatu meno'o numu moohedu saa'a ka Te Naa-baa'yoona gi hee manepunnekwu. Umu meno'o gi maawa'ne'yoo yaa'a teepu-kooba manepunnedu ka Te Naa-baa'yoona numu moohedooa.” ");
INSERT INTO paoNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Soo Te Pabe'e yise ka Jerusalem-witoo meana, numme tunakatzimodu bikase meeoo ne tuukwe, ");
INSERT INTO paoNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Jerusalem-wi te petugase mu numu-kobenatu yadooadu nu-ma tzakadukwu, o'no yise umu wakwawa'a-matoo e tzakakase yise umuoo nuka batsa tuungukwu. ");
INSERT INTO paoNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Umu wakwawa'a yise e nasootzamekukwu e wupagetana yise e batsakwu. Nu yise saa'a waha tabemease tuusootabuese namayodakwu.” ");
INSERT INTO paoNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Mu nawanga'a James-no John pea o ka Te Pabe'e-baa petuga. ");
INSERT INTO paoNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Soo Te Pabe'e yise mu pea meeoo tubenga, “Ha'yoo u unnena yow?” Soo mu pea yise meeoo ka Te Pabe'e netamma, “Ha'oo sakwa umu e doodooamu saa'a ka u-baa manepunnena ka numu u nemadunaga meakwuse?” ");
INSERT INTO paoNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Soo Te Pabe'e meeoo mu waahoo oo doodooamu netamma, “Mu gi a nakasopedakwatoo ka putoogoo e meakwuna. Nu nabatsakwu. Mu haa'a tooe punno'o oo-toogoosoo mea-wa'ne'yoo?” mee. Mu waha'yoo yise ka Te Pabe'e meeoo netamma, “Numme sakwa punno'o u-kwa'nesoo mesoo mane.” ");
INSERT INTO paoNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Soo Te Pabe'e mee'e mu nanekwegea, “Aha, mu nu-koobatoo nabatsakwu, mooasoo soo Te Naa oo nemamakwupu. Pana nu gi ka mu numu-kobena mu neyugwe-wa'ne'yoo.” ");
INSERT INTO paoNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Numme Te Pabe'e nakatzimodu mu unnena nakana ka mu James noko John unu nakasagwikute. ");
INSERT INTO paoNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Soo Te Pabe'e yise meeoo ne netamma, “Mu sakwa gi ooosapa numu-kooba nasooyugwepana ka yaa teepu-kooba'yoona. ");
INSERT INTO paoNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","28","Mu sakwa no'oko numu tummatzino, nu-kwa'ne. Nu puu ka yaa'a mu-baa petuse no'oko numu tummatza'e. Pudusoo nu mu numu-koobatoo nabatsakwu, o'no saa'a yise nu mu numu gwetzoibu-ma gi moobegwagakoo sootuhidooa.” ");
INSERT INTO paoNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Soo Te Pabe'e numme pumme nakatzimodu-no ka Jericho-wi'yoona mease ewa'yoo numu ne nakwisoo meadape. ");
INSERT INTO paoNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Oonow yise ka po-kumaba waha'yoo gi tutubootabuedu nanana yugwe. Umu ka Te Pabe'e pukumi mea oo nakana oo nanetsagwaya'e mee unnemo'o, “Ne Pabe'e ne nanesootuhiku.” ");
INSERT INTO paoNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Mu numu mu nakadu mu nesagwikute meeoo mu netamma, “Mu gi unnepana.” Pana umu yise ka Te Pabe'e pabasoo yadooeyakwe, “Ne Pabe'e ne nanesootuhiku.” ");
INSERT INTO paoNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Soo Te Pabe'e yise yoo'i petugase namatoo mu ba'e ka puba mu pepetuhoose mee soo Te Pabe'e mu tubenga, “Hownnekoo natummatzibu mu sookwa'e?” ");
INSERT INTO paoNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Umu gi tutubootabuedu nanana yise meeoo ka Te Pabe'e netamma, “Numme gi tutubootabuena yaatu ne poonnena soogwa'e.” ");
INSERT INTO paoNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Soo Te Pabe'e tutuha mu nakasoobedyana mu pooe-kooba matuguse. Umu yise tubootabue mamanikwate ka Te Pabe'e naka'oedyukuna. Umu naana yise ka podo Te Pabe'e-nakwi memea. ");
INSERT INTO paoNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Soo Te Pabe'e numme pumme nakatzimodu-no ka Jerusalem mee naneadu-kwitoo mea'a. Soo giba Olive mee naneadu oo-tzage'e. Ka Bethpage mee naneadu-tzage'e numme petuga. ");
INSERT INTO paoNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Soo Te Pabe'e yise waahoo numme pumme nakatzimodu-matu mee netamma, “Mu sakwa yaatoo ne ma'wukase ka Bethpage-witoo manekakwate. Onoko mu sumuoo tzagaze tooa'a-gakoo oo natzakunadu mayukwu. Oo tzadopase, nu-matoo oo wetzakake. ");
INSERT INTO paoNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","‘How mu mu yugwekwu?’ mee ka mu numu mumme tubenga, mu saa'a mee mu netammadooa, ‘Te Pabe'e mu soogwina, oosoo saa'a mu makodyukudooa.’ ” ");
INSERT INTO paoNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","O'no soo Te Naa yadooawabe tubotugupu mee na'unakwe ka meno'o Te Pabe'e manekwuna. ");
INSERT INTO paoNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Mu sakwa mu numu Jerusalem-wi nonobe-gakoo tuukwe soo mu-kooba katukwudu mu-baa petukwu tzagaze tooa'a-gakoo-kooba katuna. Esoo mu tumayohope ka numu nanapupua'amu-gakwuna wahadu.” ");
INSERT INTO paoNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Umu waha'yoo naana yise ka Te Pabe'e tumayohoku. ");
INSERT INTO paoNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Umu ka tzagaze nadooa'a ka Te Pabe'e-baa wetzaka petuse oo nasonatugukuse, soo Te Pabe'e yise oo-kooba tsebooese, oo-kooba katuno'o. ");
INSERT INTO paoNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ewa'yoo numu tu wunagapu ka po-kooba wupatzetagonno susumudu numu punno'o sunngabe ma'na ka Te Pabe'e-kobena tuoonana oo-ma oo podokute. Umu ka umu-kooba katudu ooosapa yoo tumatuguna besa oo sooyugwena yoo oo tumayohoku tabu'a. ");
INSERT INTO paoNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ewa'yoo numu yise Te Pabe'e na'ooonakwatu oo netubetseya'ena ewa unnegonno, “U yow Ne Tubetse Pabe'e, ne magwetzoidu. U meno'o numme-kooba katudu ka te namooatupu David-wa'ne'yoo, numme besa sokwama ka Te Naa-matoo, ka numme-matoo ume oo tayase. Soo Te Naa u tubetse sootuhikwu. Soo Te Naa saa'a puusoo ne magwetzoidooa.” ");
INSERT INTO paoNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Numme ewa'yoo ka Jerusalem-wi petugase ka Te Pabe'e-no, mu numu otuoo yise ne poonnese mee ne tubenga, “Haga masoohoo?” ");
INSERT INTO paoNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Numme ewa'yoo mu numu ka Te Pabe'e-notu meeoo mu nanekwegea, “Yow esoo Te Pabe'e Jesus ka Nazareth mee naneadu-kwitu ka Galilee mee naneadu teepu-koobatu kemmana.” ");
INSERT INTO paoNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","13","Soo Te Pabe'e ka Jerusalem-witoo mea, yise ka pabow nananesootuhi nobe-tzage'e kodyu petuga. Mu weehoo-ma tumudu poonne. Tu hemma tsanabedona, tu weeho-ma tumugonno tuwazoo. Soo Te Pabe'e yise ka hemma pukooba mu tuoona-na manapow, ka mu kadunoo tuwazoo, yise oekoo mu numu matzayubow. Soo Te Pabe'e meeoo mu netamma, “Mu ka nobeana gi-matoogoo meapana. Esoo pukwi'yoona tu nananesootuhina.” Soo Te Pabe'e yise mee mu netamma, “O'nosoo soo Te Naa yadooawabe ekow botugupu, ‘E nobe pukwi'yoona no'obatusoo numu nanesootuhina.’ Meno'o mu yise mi'yoona nanatuduha.” ");
INSERT INTO paoNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Umu gi tutubootabuedu, mu toyomodu ka Te Pabe'e-baa petudyakwe ka pukwi'yoona mu nanesootuhi-kwi'yoona soo Te Pabe'e yise mu mabesakumena. ");
INSERT INTO paoNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Mu Jew numu tutunehanedu oo poonne ka nanabesa Te Pabe'e pooha manakwe yise tuwow ka mu doodooake naka ka papaba ooka mu nesookwuga'e, “U yow Ne Pabe'e ne magwetzoidu. U tubetse besa'yoo.” Mu tutunehanedu yise mu nakasagwa'ekute. Umu yise ka Te Pabe'e meeoo ohobu netamma, “U sakwa ka mu doodooake u'newununa nedyooihoo.” ");
INSERT INTO paoNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Soo Te Pabe'e mee mu netamma, “Mu ka sumuna oo sopedakwatoo o'nosoo Te Naa yadooawabe meeoo tubotugupu, ‘U, Ne Naa mu tutugutsekoo doodooake besa ume nemadabue tuungu.’ ” ");
INSERT INTO paoNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Soo Te Pabe'e yise Bethany-witoo mease oonow tooi. ");
INSERT INTO paoNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Ka oo moo'a awamooa, soo Te Pabe'e numme pumme nakatzimodu-no ka Jerusalem-tamme mea. ");
INSERT INTO paoNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Soo Te Pabe'e ka meana, ka sunngabe Fig mee naneadu poonnese, oo-tamme mea ka tzuayaena. Unu sunngabe naka-ga'yoo gi pooe-ga'yoo. Soo Te Pabe'e yise ka sunngabe meeoo netamma, “Gi gea hannano'o u pooedooa-wa'ne'yoo.” mee. Soo sunngabe yise pasahoodooe. ");
INSERT INTO paoNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","O'no numme Te Pabe'e nakatzimodu ka sunngabe pasahoose oo poonnepunne, numme ka Te Pabe'e mee netamma, “Uune! How manena soo sunngabe yabesoo pasa?” mee'e. ");
INSERT INTO paoNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Soo Te Pabe'e yise meeoo ne netamma, “Mu sakwa a nakasopedakwadoo mu ka Te Naa naka'oedyukwu, gi waha-tamme tusooyugwepana soo Te Naa mu nakasootuhikwu ka mu nanesootuha'e. Mu ka tunaka'oedyukuna, mu punno'o nu-kwa'nesoo mesoo manakwe. Ka ooka mu natuungu, oosoo yise oo-toogoo manekwu. Mu unu pooha-ga'yoo. Gi hee unu manepunnekwu. ");
INSERT INTO paoNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Mu ka tunaka'oedyukuna ka Te Naa-matoo nanetzakwiya'ena, Te Naa mu nakasootuhikwu.” ");
INSERT INTO paoNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Soo Te Pabe'e ka pukwi'yoona mu nanesootuhi-wi petugase mu numu tunedyoo'e. Mu Jew numu tutunehanedu ka Te Pabe'e-baa petuse mee oo tubenga, “Haga pooha tunetamma-toohakwi u yoo manakwe?” ");
INSERT INTO paoNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Soo Te Pabe'e mu nekwegea, “Nu ka John-witu mu mooe tuukwekwu. Mu ka kaaheno e nanekwegease, o'no yise saa'a nu punno'o haga pooha-toohakwi 'yoo nu e manena mu tuukwekwu. ");
INSERT INTO paoNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Haga ka John meeoo netammana oosoo numu baa-wi matzaka, soo Te Naa God, pute oosoo puusoo oo sukwe manakwe?” Mu tutunehanedu yise puusoo nanano apegeagonnose, mee unakwe, “Tamme ka mee'e unnese, ‘Soo Te Naa God ka John meeoo netamma.’ Pana soo Te Pabe'e meeoo te netammakwu, ‘How yise manena mu ka John gi nakabetsea?’ ");
INSERT INTO paoNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","‘Pana soo John puusoo oo manakwe,’ mee te unnese, mu numu punno'o te kusekeakwu, soo John Te Naa nayadooawabe mee oo netammana oo naka'oedyukuna.” ");
INSERT INTO paoNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Umu yise mee ka Te Pabe'e nanekwegea, “Numme gi oo sopedakwatoo.” Soo Te Pabe'e yise mee mu netamma, “Nu punno'o gi mu tuukwe-wa'ne'yoo ka haga pooha-toohakwi, e pooha ma'nawena. ");
INSERT INTO paoNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Nu mu natugwengakwu, o'no saa'a mu e tuukwe hanotu umu-matu kaaheno manepunne. Waha'yoo tootooebetse tu naa-no nobe-ga'yoo. Soo mu naa sumuoo tu tooa mee netamma, ‘U sakwa yaa tabeno ka te tubewabe-witu hemma how yugwega.’ ");
INSERT INTO paoNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","‘Gi nu,’ mee oosoo ka tu naa nema'ese sapa saa'a mease ka tubewabe-witu hemma mahane. ");
INSERT INTO paoNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Soo mu naa yise ka sumuoo tuwazoo tu tooa meeoosoo netamma, ‘U sakwa ka te tubewabe-witu hemma oo tummatzi.’ ‘Unudooe e naa,’ mee unnese sapa gi oo-toogoo manakwe. ");
INSERT INTO paoNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Hanotu umu-matu ka tu naa nakabetse'a?” “Soo mooe'ugasootu,” mee'e mu numu tutunehanedu ka Te Pabe'e nanekwegea. Soo Te Pabe'e yise mee mu netamma, “Nu kaaheno mu tuukwekwu, umu numu tuma'emukwadu ka nuka oedyukuna, mu ka Te Naa-baa petugakwu, mu nananesootuhidu mee naneyugwedu punno'o sakwa e naka'oedyuku manese mu punno'o Te Naa-baa petugakwu. ");
INSERT INTO paoNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Ka John mu-baa petugase ka Te Naa besa po-witu mumme oo tuukwe'e, mu gi oo nakabetse'a. Mu tuma'emukwadu mee mu netammana suu'mu ka suda tu mamanenona nemawunina oo nakabetse'a. Mu yise mu poonne pana gi umu-wa'nesoo manakwe. ");
INSERT INTO paoNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Nu yaa meno'o mu tuukwekwu ka nana tubewabe hee-ga-kwitu. Oosoo nana mooe tumasu'akese yise oo na'ooonnakwitoo kooduadoose yise oo-toogoo tubane nobe-too. Ka tu tumasua-matu mu numu tunemanagakuse ka ooka mu mabetseakwu-kwitoo, yise oona kwinga'a mea. ");
INSERT INTO paoNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Ka tu tumasuana kwasuse, soo tumasuadu ka sumuoo tu tummatziwabe umu-matoo taya. Oo naamookwitu a tupooe oo hane tuunguna. ");
INSERT INTO paoNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Mu numu yise ka pumatoo natayadu petugase oo wupagetahoose gi a tupooe-matu oo hanekupana oo tayakwunihoo. ");
INSERT INTO paoNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Soo tumasuadu ewowsoo umu pumme tummatzidu oetoosoo taya pana umu tumasuape mabetseadu mu goehoo tuwazoo. ");
INSERT INTO paoNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Nakwitoo yise ka tu besa dooa umu-matoo taya mee tusooyugwena, ‘Umu sumuna besa e besaa tooa matugukwu.’ ");
INSERT INTO paoNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Pana umu tumasuape mabetseadu oo tooa pu-baa petuse mee'e nananetamma, ‘Esoo numu ka tubewabe hee-gea manekwu tamme sakwa a batsase, o'no tamme ka tubewabe hee-gakwu.’ ");
INSERT INTO paoNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Umu yise ka tabewabe-wikoo oo matzatseboogese oo batsahoo. ");
INSERT INTO paoNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Ha'oo soo tabewabe hee-ga'yoo, ka umu ookow mabetseadu yugwekwu ka umu-baa petugase?” mee soo Te Pabe'e tutubenga. ");
INSERT INTO paoNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","“Oosoo ka mu tuma'emukwana umu-matusoo makodyukukwuse kadoo mu mayugwekwu ka mu sutakoo. Ka penakwa tumasuase yise kukumma'akoosoo ka tu tumasuape mabetsea tuungukwu, kumma'a'yoosoo oo tubewa-kooba tumasuase oo naamookwitu oo hanekukwu,” mee'e umu ka Te Pabe'e nanekwegea. ");
INSERT INTO paoNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","43","Te Pabe'e yise mee mu netamma, “Nu mu tuukwekwu mu gi ka Te Naa-baa'yookwu mu ka gi e naka'oedyukuna. Mu numu nuka tubetse naka'oedyukudu suu'mu Te Naa-baa'yoona numu moohekwu. Mu oo sopedakwatoo ka o'nosoo Te Naa nayadooawabe mee'e nu-kwitu botugupu-ga'yoo, ‘Mu tupe nobe-toodu puu ka sumuhoo tupe moodyise, soo mu tumoodyina tookwa gi pumme wuni-wa'ne'yoo o ka nobe madipunnedu.’ Nu yow oosoo nanetammadu tupe Te Naa nobe madipunnedu. ");
INSERT INTO paoNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Nu yow ookow tupe-kwa'ne'yoo. O'no mu gi nuka naka'oedyukudu kadoo namayugwekoo. Ka numu nanemadabuekwu-kwi oo manepetuse umu gi e nakaheesoobedyadu kadoo'oo namayugwekwu.” ");
INSERT INTO paoNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Mu Jew numu tutunehanedu ka Te Pabe'e meeoo pumme natukwenga nakase umu oo nakasopedakwatoo soo Te Pabe'e tookwa umu-witu netamma. ");
INSERT INTO paoNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","“Hownnekoo sakwa tamme oo wutumahoo?” mee'e mu tutunehanedu sokwamapana mu tutunehanedu ka mu numu-ma suipunnena ka mu numu Te Pabe'e ka Te Naa yadooawabe mee'e oo oedyukuna. ");
INSERT INTO paoNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Soo Te Pabe'e yise mu natugwengasoo tuwazoo meeoo no'obatusoo numu nasootuhikwu gi Jew suu'mu mee yise tuukwe'e. ");
INSERT INTO paoNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Nu mu natugwengakwu ka numu-kooba katudu-kwitu. Soo numu-kooba katudu numu ewa tukakukwu ka tu tooa nodukwadookwuse. ");
INSERT INTO paoNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","4","Ka tu nanumusoo numu-kooba katudu ewa tukakwu-kwitoo bina, umu pumme tummatzidu umu tayase mee'e mu tuukwe'e saa'a, mee mu netammana, ‘Nu mooasoo tubatsase ka e tooa na'ewa tukakukwuna mamakwupunne. Mu sakwa yabesoo nu-matoo kemma.’ ");
INSERT INTO paoNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Pana umu oetoo oo nanumu oo tubina gi oo nakaheesoobedya. Sumu'yoo tu tubewabe-witoo meahoo, sumu'yoo punno'o hemma how yugwega. ");
INSERT INTO paoNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Mu susumudu yise ka mu numu-kooba katudu tummatzidu wohonena, mu goehoo. ");
INSERT INTO paoNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Soo numu-kooba katudu gi ka mu numu pumme tummatzidu oo pumme mu yugwena petzabena, tu tukwutumadu ta'ya, umu yise mu nobe tuni tuungu. ");
INSERT INTO paoNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Ka umu pumme tummatzidu yise mee'e netamma, ‘Soo e tooa nodukwadookwuno'o na'ewa tukakwudu mooasoo namamakwupunne. Umu yise e nanumu oetoo e tubina nagutza besa nanasooyugwe, gi kemma. ");
INSERT INTO paoNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Mana po-witoo mease tooe haga tooe nu-baa tuka tuungu, oo soomanedutooe.’ ");
INSERT INTO paoNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Umu oo tummatzidu yise mease no'oko numu tu poonnena tooe ka numu-kooba katudu nobe-kwi bi petu. Saa'a ewa'yoo numu oe manepetu. Umu yise namebatu susumudu bebesa'yoo susumudu too suta'yoo. Umu yise pukwi tu namasooakwuna nahemese yise na'ewa tuka. ");
INSERT INTO paoNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Soo numu-kooba katudu oe petuoose sumuoo nana mayuhoo gi namabetzapedu. ");
INSERT INTO paoNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Mee oo netamma, ‘E pua'a, ha'oo u gisoo namabetzapepana yow numu-baa?’ Soo nana gi hownnekoo oo nanekwegea. ");
INSERT INTO paoNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Soo numu-kooba katudu yise umu pumme tummatzidu mee netamma, ‘A tzakunase mabe ooosapa unu togano-kwitoo a tzakwuni, umu mabetuoo ooosapa suda sokwamana sagwipunnedu.’ ” ");
INSERT INTO paoNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Soo Te Pabe'e yise meeoo, “Nu ewow numu bipana huu'yoosoo oo-toogoo namabetzapedu suu'mu ka Te Naa ewa tukakwu-kwi'yookwu.” ");
INSERT INTO paoNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Mu Pharisee yise tunehanese ka Te Pabe'e unne-makoosoo oo nemadihookwu, mee oo-toogoo tunehane. ");
INSERT INTO paoNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Ka tunehanese mu punotusoo mu wakwawa'a numu pabe'e Herod mee naneadu-notu nanana ka Te Pabe'e-matoo tayase umu yise mee'e ka Te Pabe'e netammana, “U tubetse besa'yoona mu numu Te Naa-witu besa tunedyoo'e. U gi numu tutzeadu yise gi tuwazoo u numu nesootzemadu oo namanedu u gi heesoobedyadu. ");
INSERT INTO paoNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Numu pabe'e natumasumudookuyi-kwitu hayoo u sooyukwe mee numme u tubengagese?” ");
INSERT INTO paoNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Soo Te Pabe'e mooasoo oo sopedakwatoopunne ka pumme mu nemadikwuse yise meeoo mu netamma, “How yise mu manena e too'e nemooaga? Mooasoo mumme gi e watzekupunne sapa mu e too'e nemada'e. ");
INSERT INTO paoNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Ka namasumudoona a haneku.” Umu tu tumasumudoona-matu oo gea. ");
INSERT INTO paoNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Soo Te Pabe'e ka tumasumudoope pumme mu gease meeoo mu tubenga, “Haga ma-ma namanaka yise haga naneana tuwow ma-ma nabo'o?” mee. ");
INSERT INTO paoNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Umu yise meeoo, “Mu wawa'a pabe'e namanagana ma-ma, oo neneana tuwow ma-ma nabo'o,” mee. Soo Te Pabe'e yise meeoo tuwow mu netamma, “Tamme sakwa mu wakwawa'a numu pabe'e geasoo, umuoo nanumu tumadabuena. Tamme puu Te Naa tumadabuena Te Naa yise te hee-ga'yoo.” ");
INSERT INTO paoNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Umu ka Te Pabe'e unnena nakase besa sokwamana umu yise nasoomenakwase mea'a. ");
INSERT INTO paoNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Mu nananesootuhidu Sadducee mee nananeadu mee oo natunedyoo'e soo numu ka ya'ese otosoo soo moogooa mobegwa-ga'yoo. Oogowsoo tabeno umu-matu ka Te Pabe'e-baa petugase tu mooa tumayoho-witu oo tubenga, “Soo numu ka namano ya'ese gi hownnekoosoo gwetzoi-wa'ne'yoo oobenakwatoo haa'a?” Mee tuwazoo ka Te Pabe'e netamma, ");
INSERT INTO paoNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“O'nosoo Te Naa yadooawabe Moses mee naneadu ka meno'o te tumahohope te mayoho tuungu soo nana ka ya'ese, oo wannga'a sakwa ka oo nodukwa nodukwadoose oosoo yise ka tu pabe'e dooamudookukwu. ");
INSERT INTO paoNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Umu natakwatsukwu'yoo (7) nanakwanga'amu tamme numu-naga. Mu Pabe'e nodukwadoose, gisoo dooamudoona ya'e. ");
INSERT INTO paoNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Umu oo wanga'amu nanapenakwa oo too'e nodukwadooke pana gisoo oo-makoo dooamu-gana tu'i tzasooahooke. ");
INSERT INTO paoNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Soo mogo'ne punno'o saa'a ya'e. ");
INSERT INTO paoNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Soo numu ka tu ya'e-kwikoo namayodase ka ume unne-kwa'ne mane haga yise umu-matu ka mogo'ne nodukwa-gakwu, umu ka no'yoona oo nodukwa-gapana?” ");
INSERT INTO paoNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Soo Te Pabe'e yise mee mu nanekwegea, “Mu tookwa gi ka Te Naa tubetse unnena ka oo pooha noko nakasopedakwatoo, ka mu numu ya'e-kwikoo namayodakwuna. ");
INSERT INTO paoNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Soo numu ka tuise namayodase gi nananodukwamu-gakwu, umu ka umu Te Naa tutummatziwabe mu toha kakasa-ga-kwa'ne'yookwu. ");
INSERT INTO paoNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Mu ka sumuna Te Naa unnepu nabotuguna ne'a, ‘Umu mu nanamooatupu Abraham, Isaac, yise Jacob nu-matoo togesoo nanesootuhidu.’ ” ");
INSERT INTO paoNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Soo Te Pabe'e meeoo, “Tooe Mu Abraham, Isaac-no Jacob o'nosoo kadoo manepupana, umu togesoo gwetzoa'e umu ka Te Naa-matoo togesoo nanesootuhina.” ");
INSERT INTO paoNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Ewa'yoo mu numu ka Te Pabe'e nakadu mee nananetamma, “Tamme gi hannano'o yooonnekoo nakadu, Te Pabe'e besa numu tunedyooedu.” ");
INSERT INTO paoNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","35","Pana ka mu nananesootuhidu Pharisee mee nananeadu soo Sadducee gi hownnekoo ka Te Pabe'e nekwegea. Mu Pharisee mee tunakase umu pudu tunemadabue ka Te Pabe'e nemapoonnehookwu mee sokwamana. Umu Pharisee sumuoo punagatusoo ka Te Pabe'e mee tubenga tuungu, ");
INSERT INTO paoNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“O'nosoo soo Te Naa yadooawabe Moses ewow tumayohope te mayoho tuungu. Hanotu umu te tumayohope-nagatu unu besa'yoo pumme mooe datsunga-wa'ne'yoo?” ");
INSERT INTO paoNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Soo Te Pabe'e mee oo nanekwegea, “Tamme sakwa ka Te Naa besa soobedyana ooosapa meeoo sokwamamo. ");
INSERT INTO paoNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","O a besana. ");
INSERT INTO paoNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Soo penakwatu besa'yoo tumayohope te nakabetseakwuna punno'o mee'e, ‘Tamme sakwa no'oko numu besa soobedya tammesoo nasoobedya-kwa'ne.’ ");
INSERT INTO paoNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Tamme ka Te Naa no'oko mu numu besa soobedyana, tamme tookwa no'oko ka Te Naa tamme tunetammakuna nakabetse'a.” ");
INSERT INTO paoNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Mu Pharisee numu ka Te Pabe'e-baa sumu, soo Te Pabe'e yise mee mu Pharisee tubenga, ");
INSERT INTO paoNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Ha'yoo mu puu oo soobedya? Haga nakwana oosoo Te Pabe'e suaketu?” Umu Pharisee meeoo ka Te Pabe'e nanekwegea, “Ka numu-kooba katudu David mee naneadu-nakwana suakekwutu.” ");
INSERT INTO paoNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Soo Te Pabe'e yise mee mu netamma, “Soo David ka Te Naa pooha-toohakwi Te Pabe'e mee oo natuba'nga. Ka David tubotugu-kwi meeoo, ");
INSERT INTO paoNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Soo Te Naa ka Te Pabe'e mee netammapu, “U sakwa ooosapa e tumadinakwu katu ka umu ume wohonedu e matzooekuno'otoo.” ’ ");
INSERT INTO paoNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","How yise soo David Te Pabe'e mee oo natuba'nga ka punakwana oo nanekemma sapa?” mee'e soo Te Pabe'e mu Pharisee tubenga. ");
INSERT INTO paoNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Gi haga hownnekoo oo nanekwegea-wa'ne'yoo, umu yise gi hemmasoo oo tubengasoo mani. ");
INSERT INTO paoNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Soo Te Pabe'e Jesus yise ka mu numu ewana ka mu tunakatzimodu-nokosoo mee netamma, ");
INSERT INTO paoNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Mu Jew numu nanesootuhibu tunedyooe ka Moses kapi naneyugwena ka oo unnena numu tunedyooe. ");
INSERT INTO paoNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Mumme mu tunedyooena kaaheno'yoo pana umu puu gi oo-toogoo tumayohopana mu tunedyoo'e. Mu sakwa gi umu-wa'ne'yoo. ");
INSERT INTO paoNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Umu unu namanedu te mayoho tuungupana, gi te tummatzi sokwama. ");
INSERT INTO paoNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Umu sukwe nasootzamena ka tumayohope mayoho mee nane'yugwe. ");
INSERT INTO paoNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","7","Umu puu besa-kwi tu namasooa-ma nasootza'me numu pumme besa neyugwena pedukudu tuwazoo. Umuoo ka tu na'ewa tuka numu-kooba tunaneyugwena besa soobedya punno'o, o'no mu numu besa mu sooyugwekwu mee nasooyugwedu. ");
INSERT INTO paoNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Pana mu sakwa gi kumma'akoosoo numu nanesootuhibu tunedyooedu mee mumme netammadu sookwipana. Nu suu'mu yow kaahenotu ka nanesootuhibu numu tunedyooedu mu no'yoona sumu-kwa'ne'yoosoo. ");
INSERT INTO paoNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Mu sakwa gi tooe haga tooe ka teepu-koobatu Te Naa mee neapana, mu sumuoosoo Tubetse Naa-ga'yoo, oosoo yise ebe te pa'anakwa manepunne. ");
INSERT INTO paoNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Mu sakwa tuwazoo gi kumma'akoosoo ka yaa teepu-koobatu, Te Pabe'e, mee neapana. Nu suu'mu yow Mu Pabe'e. ");
INSERT INTO paoNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Soo unu nadatsungadu mu nagatusoo sakwa mu tummatzi. ");
INSERT INTO paoNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Ka te nasootza'me soo Te Naa gi besa te sooyugwe. Pana ka gi te nasootza'me soo Te Naa besa te soomadabu'e.” ");
INSERT INTO paoNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","14","Soo Te Pabe'e togesoo mu yadooedyakwe, “Mu nanesootuhibu numu tunedyooedu yise ka mu numu ka mu nanesootuhidu-nagatu Pharisee mee nananeadu-kwitu nu mu tuukwekwu. Mu tuma'emukwana mu-matoosoo kodyukwu mu ka nanesootuha'e mee sukwe naneyugwena. Mu ka mu numu Te Naa nakabetseakwuna takoho'ne ka mu gi oo nakabetseana. Ka Te Naa tamme a nameana ka natzakwona'a mu tzatuma-kwa'ne manepunne. ");
INSERT INTO paoNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Mu tubetse unu suta'yoona soo mu tuma'emukwana mu-matoosoo kodyukwu. Mu mana tooe momona sumuoo numu mu-ma nakatzabese mu mumme tumayohope oo tunedyooe gi ka Te Naa unnena, mu waha oo-koobakwisoo ka goso gi tokedu-tamme oo taya mummesoo mane-kwa'ne. ");
INSERT INTO paoNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Mu Pharisee tooe ka Te Naa-witu gi nakasopedakwadoopana ka mu numu too'e tunedyoo'e. Mu yise ka mu numu ne'emukwa. ‘Mu hee ka te nanesootuhi nobe-kwitu oa tupe namadabuedu ka Te Naa nahemagana tamme sakwa yise mu sootubetseya'e. Pana ka nanesootuhi nobe sakwa tamme gi sootubetseya'epana,’ mee mu. ");
INSERT INTO paoNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Soo nanesootuhi nobe Te Naa-tu ka oa tupe-kwa'ne'yoosoo. ");
INSERT INTO paoNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Mu oo netubetseya'e ka Te Naa nahemagana pana mu ka pukooba oo natuguna gi heesoobedya. ");
INSERT INTO paoNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Pana nanosoo umu Te Naa nahemagana. ");
INSERT INTO paoNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Tamme sakwa yise namekoosoo mu sootubetseya'e ");
INSERT INTO paoNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","ka oa tupe ka nanesootuhi nobe no'oko, umu no'yoona Te Naa tumadabuena. ");
INSERT INTO paoNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Tamme ka tamme-koobatu-kobena'yoona namayodase, tamme ka Te Naa ooka nemadabuedu nokosoo-kobena'yoona namayota. ");
INSERT INTO paoNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Mu nanesootuhidu numu tunedyooedu ka Pharisee mee nananeadu ka Te Naa o'nosoo unnepu tzamunetana numu tunedyooena mu ka Te Naa nakabetsea mee sukwe nane'yugwena. Mu ka gi haa'noko mu hee-gana-matu ka Te Naa geapana ka kaaheno Te Naa besa unnepu gi nakabetseana. Mu sakwa ka Te Naa mumme sooyugwe-kwa'ne'yoo, mu sakwa tuwazoo sakwane sapa ka Te Naa totsa'maka. Mu sakwa besa numu matuguna, besa'yoona, kaaheno tusooyugwena ka Te Naa-wi tubetse besa tunakabetsea. ");
INSERT INTO paoNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Mu ka gi kaaheno numu tunedyooena gi toge-tamme numu moohe. ");
INSERT INTO paoNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Mu Pharisee gi kaaheno numu tunedyooena umu-matoosoo kodyukwu. Mu ka numu poonnena'yoona besa nasooyugwena pana mu tusoohane gi toge'yoo. Mu suda totsa tusooyugwe, tuduhana, unu moogoobuna. Mu unu totsadu tseda-wa'ne'yoo numu puu ka oo na'oonnakwitu suu'mu gi madotzakuna oetu tooesoo totsa'a. ");
INSERT INTO paoNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Mu Pharisee tumamooagadu. Mu sakwa gi toge mu manena nematzaga, o'no mu besa'yookwu. ");
INSERT INTO paoNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Mu ka mu numu nakoopu-wa'ne'yoo oosoo puu besa namabetzape puuwanatu a napoonne-kwitu, soo tsoapa suu'mu oe. ");
INSERT INTO paoNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Mu besa tatabu'a ka numu mumme poonnekwi ooonne'yoo pana mu ka Te Naa gi nakabetseana unu e'esapu. ");
INSERT INTO paoNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Mu ka o'nosoo Te Naa nanayadooawabe nakoona mabetsabena, ");
INSERT INTO paoNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","mee nana'unakwe, ‘Tamme sakwa uga ka o'no mona Te Naa nanayadooawabe gi goe ka umu te nanamooatupu-wa'ne.’ ");
INSERT INTO paoNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Tooe mu meeoo sukwe unnepana mu nanamooatupu manena mu nakwisoo me'a. ");
INSERT INTO paoNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Mu punno'o umu-wa'ne'yoosoo. Ooosapa ka umu Te Naa nanayadooawabe goetabekwu. ");
INSERT INTO paoNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Mu togogwa-wa'ne'yoo. Mu-kwa'ne'yoo saa'a nanemadabuese ka goso gi tookedu-kwitoo natzakwunikwu. ");
INSERT INTO paoNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Ka yoo a manepunne nu ooosapa ka kaaheno Te Naa unnepu tunedyooekukwudu mu-matoo tayatabekwu, pana mu umu-matu goena, mu kusedyana, suda mu matuguna, mu tayapebuakwu, umu-matu tzakwenetakwu. ");
INSERT INTO paoNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","36","Mu oe naneyugwekwu ka no'oko Te Naa nanayadooawabe goena. Mu numu meno'o modu togesoo ooosapa manedape soo suta'yoo mu manetabena mu-matoosoo kodyukwu. ");
INSERT INTO paoNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Nu ewasoo mumme Jerusalem-witu numu tutuha soobedyayakwe, nu sakwa tooe ka hootze-wa'ne tu dooamu ka tu kasa-tooha hane mee nu tusooyugwe. Pana mu gi mumme oo e matuguna petzape. Mu nono'otsa umu Te Naa nanayadooawabe mu-matoo e tayayakwe oo batsayakwe. ");
INSERT INTO paoNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Ka saa'a mu-matu kadoo'oo namayugwese mu nogadu-kwitu numu kadoo'yookwu. ");
INSERT INTO paoNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Saa'a ka mu-baasoo e kodyu petuse mu mee unnedooa, ‘Yow soo Te Pabe'e wuna'me te wutooena.’ ” ");
INSERT INTO paoNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Soo Te Pabe'e ka numme pumme nakatzimodu ka pabatsekoo nanesootuhi nobe-kwi'yoona mea'a, numme yise ka nanesootuhi nobe-kwitu apegeamo'o. ");
INSERT INTO paoNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Soo Te Pabe'e yise mee ne netamma, “Besa oo poonne ka nanesootuhi nobe maasoo puu tupe namadabuena ka saa'a mu tupe no'yoona abedikwu gi sumu'yoo sapa wunukwu.” ");
INSERT INTO paoNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Soo Te Pabe'e yise ka tutsekoo giba Olive mee naneadu-ma poyase onow katu. Numme yise numu-wana'yoona mee oo tubenga, “Ha'oo saa'a numme oo sopedakwadoo tabuadooa hannano'o yoo namanese u kodyu petukwu ka yaatu teepu atasoo u mayugwekwu?” ");
INSERT INTO paoNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Soo Te Pabe'e mee ne nanekwegea, “Besa sapa gi kumma'akusoo numu mumme nemooagadu naka'oedyukupana. ");
INSERT INTO paoNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Ewa'yoo soo numu mee sumuna mu netammakwu, ‘Nu yow Mu Pabe'e,’ yise ewow numu nemoo'aga. ");
INSERT INTO paoNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Mu ka tu nana'akwe-kwitu nakakwu, tooetoo nana'akwekwu pana gi suipana. Tooe tu nana'akwedyakwe sapa gisoo atasoo ka yaatu teepu e yugwekwi manakwe. ");
INSERT INTO paoNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","8","Yoo namanekwu ka hemma suda manekwuse. Ewa-baatu numu kukumma'yoosoo nanagoena, tukapu natugena natseagoena, soo teepu yise yutsungayikwu. ");
INSERT INTO paoNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Saa'a numu mu wohonena ka mu numu moohedu mumme goe tuungukwu. No'obatusoo mu numu gi mu petzabekwu nu-koobatoo. ");
INSERT INTO paoNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ewa'yoo mu tunaka'oedyukudu-matu gi nu-kwi tunaka'oedyuku manese gi nanapetzabena nanakwohonekwu. ");
INSERT INTO paoNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ewa'yoo numu nu yow Te Naa yadooawabe mee naneyugwedu mu-baa petuse ewow numu nemooagakwu. ");
INSERT INTO paoNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Yise ewa'yoosoo soo numu suda tumatuguna tooe no'yoona mu numu gi nanapetzape manekwu. ");
INSERT INTO paoNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Pana mu sakwa ooosapa tunaka'oedyuku tooe mu numu mumme tumoo'oo, o'no mu namagwetzoikwu. ");
INSERT INTO paoNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Mooe'ugasoo no'obatusoo numu ka Te Naa besa na'unnedu natuukwekwu. Umu punno'o oo naka ka Te Naa numu magwetzoikwuna. O'no yise nu ka yaatu teepu atasoo yugwekwu. ");
INSERT INTO paoNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Tooe hemma tooe suta'yoo ka nananesootuhi nobe-kobena natzekwunukukwu. O'nosoo soo Te Naa yadooawabe Daniel mee naneadu yoo eka sutakoo namadabuena pumatoo tu nananesootuhikwuna botugupu. ");
INSERT INTO paoNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","O'no sakwa mu ka oo poonnese, Judea-wi'yoona yabesoo mea'a. ");
INSERT INTO paoNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Mu ka ona puuwana'yoona mu sakwa gi hemma hanepana mea'ahootooe. ");
INSERT INTO paoNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ka oona tubewabe-kwi'yoona mu sakwa gi mu wegea-kwitoo kodyupana. ");
INSERT INTO paoNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Mu momoko'ne kokoheadu yise mu nunuupetzekudu tutuha namanatzayakwe ka numu tuyamanese. ");
INSERT INTO paoNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Umu sakwa nanesootuhi, gi sakwa tommo tooetoo te nanesootuhi tabeno hee oo suda manepana. ");
INSERT INTO paoNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","O'no numu nanasuda manekwu. Gi hannano'o oo suda namatugupu-ga'yoo. ");
INSERT INTO paoNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Soo Te Naa umu tu nanumu tutuha soobedyana mu sootuhina ka suda mu nuugwena tzadyooikuse, o'no mu tunaka'oedyukudu namagwetzoikwu. ");
INSERT INTO paoNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Tooe haga tooe sumuna meeoo mu tuukwekwu, ‘Soo Te Pabe'e mooasoo kodyu petu,’ mee, gi oo naka'oedyukupana. ");
INSERT INTO paoNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Ewa tuwazoo na'esagoekwu, ‘Nu yow Mu Pabe'e mee na'unnekwu.’ Ewasoo mu numu moohedu numu nemooagayakwe. Ewa nanasookwugi hemma mu tzapoonnekukwu tooe hemma tooe mahanekwu ka umu e dooamu too'e nemooagana. ");
INSERT INTO paoNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Nu yaa meno'o ekow mu tuukwe'e. ");
INSERT INTO paoNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Ka tooe haga tooe mumme mee tuukwe, ‘Soo Te Pabe'e numme-baa, tooetoo mana numu-wanakoo oo nanepoonne, tooetoo ebe nobe-kwi,’ mee mu unakwe sapa gi oo poonne-gapana, gi mu naka'oedyukupana. ");
INSERT INTO paoNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Nu ka numu poowutzaba-kwa'ne oo yabe manikwu ka tukwukwetseba tabatsebue-nakwana ka koomeba pedakwana ka taba egea-tamme mani-kwa'nekoosoo, nu mu-baa kodyu petuhookwu soo numu no'yoona e poonnekwu. ");
INSERT INTO paoNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","O mu e naka'oedyukudu suu'mu nu-baa sumuhookwu. ");
INSERT INTO paoNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","O'no ka gi hemma besa manekwuse, soo taba toganohookwu, soo muha punno'o. Mu paatoosooba punno'o sawedyikwu. ");
INSERT INTO paoNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","No'yoona mu numu punno'o ka koomeba-nagakoo e pooha kodyu petukwuna poonnekwu. No'obatusoo gi tunaka'oedyukudu numu suda sokwamakwu. ");
INSERT INTO paoNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Soo tumooyagakunoo paba namooyagakuhookwu, ka e kemmana mu tuukwena. Nu ka mu nuka tummatzidu toha kakasa-gakoo, mooe tayakwu umuoo saa'a umu nuga tutzeana nu-kwi tunaka'oedyukudu manatutooe tsobakwu. ");
INSERT INTO paoNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Ka sunngabe pooedooakese, mu meeoo sokwamadooa, tamme tookwa tamatsebooe. ");
INSERT INTO paoNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Ka gi besa hemma manekese, mu yise oo sopedakwadookwu, nu tookwa pudusoo kodyu petukwu. ");
INSERT INTO paoNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Susumudu mu numu-matu ka hemma oo manedu poonnekwu gisoo ya'ena. ");
INSERT INTO paoNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Nuga unnepu besa na'unnedu, gi atasoo mane-wa'ne'yoo. ");
INSERT INTO paoNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Ka hannano'o oe e petuookwuna manepetuse gi haga ka teepu-koobatu oo sopedakwatoo. Mu toogoopatu Te Naa tutummatzidu puu gi, nu punno'o gi. Te Naa suu'mu oo sopedakwatoopunne ka hannano'o e petuookwuna. ");
INSERT INTO paoNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","39","Nu sumuna yabesoo umu-baa kodyu petukwu gi mu numu meeoo sokwamano'o. Ka gisoo e petu mu numu tooe how tooe ma'na'wekwu. Ka o'nosoo tu mane-kwa'nesoo ka nana Noah mee naneadu togesoo ka yaa teepu-kooba gwetzoinumme. Umu puu tukana, hebena, nananodukwadooyakwe ka o'no tabeno ka Noah ka sake-wi natzatumase. Mu numu puu ka gi ka Noah nakaheesoobedyana. O'no umu puu ka teepu patatzopahoose, batatuihoo ka gi oo nakaheesoobedyana. Ooosoo tuwazoo manekwu ka e kodyu petuse. ");
INSERT INTO paoNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Sumuna waha'yoo nanana ka tubewabe-wi'yoona, sumu'yoo nakwuhoogase, sumu'yoo nabenihookwu. ");
INSERT INTO paoNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Sumuna waha'yoo momoko'ne toosoona, sumu'yoo nakwuhoogase, sumu'yoo nabenihookwu. ");
INSERT INTO paoNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Mu sakwa nonotsu tabeno nuummabetsabena. Tooe hannano'o tooe nu kemmowgena, yongona, togano, awamooasoo. Nu sumuna gi mu nuummabetsabe mu mayu petukwu. ");
INSERT INTO paoNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Mu sakwa namabetzapepunne ka e kodyu petukwuna wutooena, soo numu puu namabetzapepunne ka tu nobe-kwitu natuduhakwuna sopedakwatoona, o'no soo hemma tuduhakwudu gi mu hemma tuduha-wa'ne'yoo. ");
INSERT INTO paoNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Mu sakwa yise ooosapa namabetzapepunne nu mu-baa petuhookwu gi meeoo mu sokwamano'o.” ");
INSERT INTO paoNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Soo Te Pabe'e meeoo tuwazoo unakwe, “Umu nuga besa yadooawabe mu e dooamu nehane aatakwu, unu sokwamana sakwa ooosapa besa e dooamu tummatzi. Umu yise ka nuka naka'oedyukudu nemabetseana ka e besa unnepu mu tunedyooena. ");
INSERT INTO paoNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Nu ka kodyu petuse umu e netutzeana ka umu nuka naka'oedyukudu besa mu nemabetsea mu mayu petuse, nu besa mu sootuhikwu. ");
INSERT INTO paoNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","O'no umu e hemma no'oko nemadunagakwu. ");
INSERT INTO paoNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Pana soo e yadooawabe ka suda tusooyugwena, gi yabesoo e petukwuna sookana. ");
INSERT INTO paoNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Oosoo yise umu tunaka'oedyukudu gi mu nemabetseana, tukana, ewa hebena mesoo baaya'ena tooe how tooe manekwu. ");
INSERT INTO paoNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","51","Nu yise gi oo soonamme-kwa'ne yabesoo kodyu petukwu. Nu yise ka umu gi tunaka'oedyukudu-noko oo tatsungukwu. O'no oosoo mu gi tunaka'oedyukudu-no suda sokwamano'o.” ");
INSERT INTO paoNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Soo Te Pabe'e meeoo tuwazoo unakwe, “Nu ka nuga kodyu petukwu-kwitu mu natugwengakwu. Mu sumumano'yoo (10) sususu'a ka nana wutooedu-wa'ne'yoo ka na'ewa tukakwu-kwitoo pumme oo bikakwuse. ");
INSERT INTO paoNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","4","Manege'yoo umu-matu ka mooasoo oo nakana ka tu tukootabuakunoo besa mabetsapunnena oo wutooepunne ewow yoohoo oo-kumabasoo hanepunne. Umu manege'yoo punno'o oo nakapunnedu gi tu tugootabuagunoo mabetse'a, oo sukwe wutooepunne. ");
INSERT INTO paoNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Soo nana gidya'e manegena umu oo wutooedu utuigana yise no'yoona utuihooga. ");
INSERT INTO paoNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","7","Togabeno umu nanetupoonne mee natuukwehoo, ‘Pudusoo soo nana petuookwu, tzage'e manegena yosuhoose oo-no mea'a mu ka tooe mooasoo namamakwupunne.’ No'yoona mu sususu'a yosuhoose tu tukootabugunoo mabetsabekooha. ");
INSERT INTO paoNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Mu gi oo-toogoo namabetzapepunnedu sukwe kemmadu ka tu tukootabuakunoo togega'a mu tu pupua'amu punotu too'e yoohoo natuungu. ");
INSERT INTO paoNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Umu pupua'amu yise mee mu nanekwegea, ‘Gi! Esoo yoohoo sumuna gi toge tamme-too toge'yoo. Mu sakwa muusoo yoohoo tumuhoo.’ ");
INSERT INTO paoNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Ka mu sususu'a yoohoo tumugase, soo mu wutooena nana petuhoo. Mu sususu'a mooasoo nuummabetsabepunnedu ka nana-no mea'a ka tu na'ewa tukakwu-kwitoo. Ka oe mu petugonnogase soo natzakwona'a natzadumahoose natseponoehoo. ");
INSERT INTO paoNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Saa'a umu yoohoo tumumodu yise saa'asoo ka natzakwona'a-wi too'e petugonno. Mee'e too'e unakwe, ‘Ne tutzakwonaku.’ ");
INSERT INTO paoNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Oosoo nana yise mee mu nanekwegea, ‘Mu mooasoo saa'asoo manasoo manemo. Manakwinga'a-witoosoo mea'a.’ ");
INSERT INTO paoNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Nu Mu Pabe'e ookow nana-wa'ne'yoo. Mu sakwa namabetzapepunnena nu-no mea ka tooe hannano tooe mumme e bi petugase.” ");
INSERT INTO paoNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Soo Te Pabe'e mee'e tuwazoo mu natugwenga, “Sumu'yoo numu puu ka meakwuse, ka hemma how pumme yugwekudu hemma nemanekuka. Ka tu'eyaedu meeoo netamma, ‘Gi u'wepana.’ ");
INSERT INTO paoNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ka sumuoo pumme tummatzidu manegeoo oa tupe oo heme, ka sumuoo pumme tummatzidu waahoo oa tupe oo heme, sumuoo tummatzidu sumuoo oa tupe oo gea. O'no soo nana mea. ");
INSERT INTO paoNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Soo oo tummatzidu ka manegeoo nahemedu hee-ma tumuna oo-masoo too tumuwununa sumumano (10) oe mama'e petuga. ");
INSERT INTO paoNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Soo tummatzidu ka waahoo nahemedu punno'o manegeoo nahemedu-kwa'nesoo manese watsu oo mama'e petuga. ");
INSERT INTO paoNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Soo oo tummatzidu ka sumuoo nageadu yise ka teepu-tooha oo sukwe kooohoo. ");
INSERT INTO paoNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Ka saa'a soo nana kodyu petuse mu pumme tummatzidu namatoo bi. ");
INSERT INTO paoNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ka umu tu hemepu-witu soosopedakwatoona soo oo tummatzidu manegeoo nahemekadu oo makodyuse yise manegeoo too oo-koobakwisoo oo heme. ");
INSERT INTO paoNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Soo nana meeoo oo netamma, ‘U punno'o besa manepu-ga'yoo u manegeoo nanakumma'akoosoo numu nemadabuekwu. Nu ewahoosoo u hanekukwu. U besa soonammekwu, yaa manakwana u nu-baa'yoona.’ ");
INSERT INTO paoNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Soo sumu'yoo oo tummatzidu punno'o ka waahoo oa tupe nahemedu meeoo ka nana netamma, ‘U waahoosoo oa tupe e hemese, nu onoko tzanabedose meno'o watsukwuoo oa tupe u makodyukukwu.’ ");
INSERT INTO paoNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Soo nana meeoo oo netamma, ‘U tookwa punno'o tubetse besa manepu-ga'yoo. U besa e nakabetsea tooe ka huutsekoo ume e hanekuse sapa. Nu ewahoosoo u hanekukwu. U punno'o besa soonammekwu, yaa manakwana u nu-baa'yookwu.’ ");
INSERT INTO paoNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Soo tummatzidu punno'o ka sumuoo oa tupe nageadu meeoo ka nana netamma, ‘U nenadu'yana. U ooosapa tooe hema soogwidu tooe gi numu tummatzipana. ");
INSERT INTO paoNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Nu ka u-ma suina gi oo sookwatzekuna teepu-tooha ka oa tupe kooohoo. Yaa'a yise soo u oa tupe.’ ");
INSERT INTO paoNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Soo nana yise meeoo oo netamma, ‘U unu suta'yoo, unu toetzebu. U mooasoo e sopedakwadoo ka e u manekwuna ka e tusoogwipunne. ");
INSERT INTO paoNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","U sakwa ka e oa tupe uga wutumase, o'no oosoo ewasoo manekwu.’ ");
INSERT INTO paoNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Ka oa tupe oo-makoo gwuuse ka nana sumumano (10) oa tupe makodyupu nagea. ");
INSERT INTO paoNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Soo tooe haga tooe ka pumme tu geana besakoo mabetseana ewowsoo nageakwu. Soo tooe haga tooe yise ka gi besa oo mabetseana oosoo umu-makoo nahanekwu. ");
INSERT INTO paoNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Soo gi besa tummatzidu ka unu togano-kwitoo natayakwu ka gi besa nanasoonamme-kwitoo. ");
INSERT INTO paoNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Ka Te Naa Besa Pooha tooha-kwi e petuse ka mu nuka tummatzidu toha kakasa-gakoo-no, nu saa'a ka mu numu nemadabuedooa ka Te Naa Besa Pooha-toohakwi. ");
INSERT INTO paoNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","No'obatusoo numu saa'a nu-baa e koobena manepetuse, nu yise mu tapokase mu nuga dooamu sukwesoo hanekwu. ");
INSERT INTO paoNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Nu ka mu nuga dooamu e tumadinakwa hanekwu ka mu susutakoo numu e oenakwa hanekwu. ");
INSERT INTO paoNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Ka umu e tumadinakwatu nu mee netammakwu, soo Te Naa namatoo mu bise Te Naa mu doodooamu-gakwu mu sootuhise, mu ooosapa Te Naa-baa'yookwu. Te Naa o'nosoo oo nemamakwupu gisoo ka teepu matabuena. ");
INSERT INTO paoNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Mu nasootuhikwu ka e tzuaya'e e makase, e bamaka ka e puudyi, e nabaa'yookute tooe e wawa'a sapa. ");
INSERT INTO paoNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Mu pukwi e namasooana e heemaka ka ooka e soogwa'e. Mu e tuoeya'e e mabetsea. Mu nu-baa nobe'ne ka e nakwutuma. ");
INSERT INTO paoNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Mu bebesa'yoo numu mee unnekwu, ‘Hannano'o numme u poonnena, u maka ka u tzuaya'e, yise ka u puudya'e u bamaka? ");
INSERT INTO paoNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Hannano'o numme u nabaa'yookute tooe u wawa'a sapa? Hannano'o pukwi u namasooana numme u heemaka ka ooka u soogwa'e? ");
INSERT INTO paoNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Ka u tuoeya'e haa'a u mabetse'a? Hannano'o u nakwutuma u nobe'ne?’ ");
INSERT INTO paoNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Nu mu tuukwekwu, ‘Mu ka umu e doodooamu-nagatu besa matuguna mu nuka besa matugudu-kwa'ne manepunne.’ ");
INSERT INTO paoNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Nu ka umu e oenakwatu yise mee netammakwu, ‘Mu sakwa nu-baa'yoona mea'a. Mu ka gi tookedu goso-witoo meakwu, ka sutakoo yise too ooka tummatzidu-no ka suta-too namadabuedu-kwitoo mu mea'akwu, ka gi e tummatzina ka mumme e soogwa'e. ");
INSERT INTO paoNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Mu gi e maka ka e tzuaya'e. Mu gi e bamaka ka e puudya'e. ");
INSERT INTO paoNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Mu gi e nabaa'yookute ka wawa'ana mu-baa e petugase. Mu pukwi e namasooana gi e heemaka, ka ooka e soogwa'e. Mu gi e mabetsea ka e tuoeya'e, ka e nakwutuma gi e nobe'ne.’ ");
INSERT INTO paoNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Nu oo sopedakwadoo umu punno'o mee e nanekwegeakwu, ‘Numme gi u nabaa'yookudu ka gi hannano'o u poonnena. Gi too u hee-makadu ka gi u poonnena, tooe u tuoeya'e sapa, tooe u nakwutuma sapa, gi hownnekoo u tummatzi ka gi u poonnena.’ ");
INSERT INTO paoNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Nu mee mu nanekwegeakwu, ‘Nu togesapa mu tuukwekwu. Mu gi nuka tummatza'e-kwa'ne manepunne ka umu e doodooamu gi tummatzina. ");
INSERT INTO paoNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Mu gi he-toogoo besa'yoo mee mu soobedyana. O mu suta'yoo numuna soo suda mu tumatuguna mu-matoosoo kodyukwu. Umu bebesa'yoo numu punno'o ooosapa Te Naa-baa'yoona besa nasootuhikwu.’ ” ");
INSERT INTO paoNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Soo Te Pabe'e mu numu natukwengamakwuse ka numme pumme nakatzimodu mee netamma. ");
INSERT INTO paoNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Mooa yongona tamme ka gi namayuadu tukaba ewa tukakwu. Ka tu na'ewa tukano'o nu sutakoo nana-wa'ne nakwuse natzakwenekwu. Oo nu nabatsa tabuakwu.” ");
INSERT INTO paoNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Mu Jew numu tutunehanedu ka pumme tubetse moohedu Caiaphas mee naneadu nobe-wi sumuhoo. ");
INSERT INTO paoNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Mu Jew numu tutunehanedu ka Te Pabe'e-witu watze tunehanese yise oo batsakwu mee tunehanena. ");
INSERT INTO paoNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Pana mu tutunehanedu ka mu numu-ma sua'e. “Tamme gi hownnekoo ka tu na'ewa nadukano'o ka Jesus wutama-wa'ne'yoo mu numu sumuna te goehookwu,” mee'e umu nananetamma. ");
INSERT INTO paoNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Soo Te Pabe'e oona Bethany-wi ka Simon mee naneadu-baa. ");
INSERT INTO paoNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Sumu'yoo mogo'ne oo-matoo kemma tupe osa-kwikoo besa kwanadu namakwanakuna unu nanenagadu gwuuna. Ookow ka Te Pabe'e kwo-kooba tokwuukwateoo ka oo tuka katu. ");
INSERT INTO paoNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Numme oo nakatzimodu ka mogo'ne manena poonnese oo nesootu'adya'e, meeoo yise, “How manena oo nahadyakwe ka besa kwanadu unu naneagadu namakwanakuna? ");
INSERT INTO paoNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Oosoo sakwa uga oo-ma tumuse mu tutuha manedu namadea.” ");
INSERT INTO paoNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Soo Te Pabe'e yise meeoo mu netamma, “A tsasoopedya. Gi a nesootu'adya'epana. Esoo mogo'ne besa manakwe. ");
INSERT INTO paoNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Mu tutuha manedu tooe hannano'o pana ooosapa mu-no'yookwu, pana nu yise gi ooosapa mu-no'yookwu. ");
INSERT INTO paoNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Oosoo ka namakwakuna nu-kooba tokwuukwateoo ka e nakoookwuna-kobena e natugukwuna tumayohokuna. ");
INSERT INTO paoNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Tooe hano tooe ka teepu-koobakwi soo besa nayadooadu numu natunedyooe-kwi ekow mogo'ne besa tumatugu-kwitu nawahakwu.” ");
INSERT INTO paoNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Sumu'yoo ka numme Te Pabe'e nakatzimodu-matu Judas Iscariot mee naneadu ka mu Jew tutunehanedu-baa petuse ");
INSERT INTO paoNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","mee mu netamma, “Mu ka Ne Pabe'e pukwi'yoona mumme e tuukwese, haa'noko sakwa mu e tumanagaku?” Mu Jew numu tutunehanedu yise pahe mano-ma tsebooekudu (30) oo tumanagakuhoo. ");
INSERT INTO paoNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Soo Judas yise mee soonamme, “Hownnekoo sakwa nu ka Jesus bika?” ");
INSERT INTO paoNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Ka Gi Namayuadu Tukaba na'ewa tukana oe manepetuse, numme Te Pabe'e nakatzimodu mee ka Te Pabe'e netamma, “Hano'yoona sakwa numme ka te nanesootuhi yongo tukakwuna mahanega?” ");
INSERT INTO paoNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Soo Te Pabe'e mee ne netamma, “Mu ka Jerusalem-wi petugase sumuoo nana tapoegakwu mee saa'a oo netamma, ‘Soo Te Pabe'e meeoo, “Soo e nabatsakwuna mooasoo tugana'a manegena. Nu ka umu nuka nakatzimodu-no ume nobe-kwi'yoona nanesootuhi yongo tukadooa.” ’ ” ");
INSERT INTO paoNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Numme ka Te Pabe'e tumayohokuna, ka ne nanesootuhi yongo tukakwuna mabetsabe. ");
INSERT INTO paoNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Ka tu yongose, soo Te Pabe'e Gi Namayuadu Tukaba numme-no tuka. ");
INSERT INTO paoNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Ka togesoo ne tuka, soo Te Pabe'e mee ne netamma, “Mu sakwa oo tubetse nakasopedakwadoo sumu'yoo mu-nagatu ka umu nuka wohonedu-matoo e bihookakwu.” ");
INSERT INTO paoNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Numme suda sokwamana nanasusumu'yoona ka Te Pabe'e mee tubengadyipunne, “Nu haa'a?” mee'e. ");
INSERT INTO paoNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Soo Te Pabe'e yise mee ne nanekwegea, “Sumu'yoo yaa nu-no tukadu. ");
INSERT INTO paoNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Pana saa'a oosoo umu e wohonedu nu-matoo bikekwu soo oo manedu tuma'emukwana oo-matoosoo kodyukwu.” ");
INSERT INTO paoNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Soo Judas Iscariot ka Te Pabe'e ka ooka wohonedu-matoo bikakwu. Oosoo yise ka Te Pabe'e meeoo tubenga, “Nu haa'a?” Soo Te Pabe'e yise meeoo ka Judas netamma, “O u mooasoo oo yadooahoo.” ");
INSERT INTO paoNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ka togesoo ne tuka aata soo Te Pabe'e ka tukaba gwuuhoose oo-koobatoo nanesootuhise oo tzabokahoo. Ookahoo numme pumme nakatzimodu hemehoose mee unakwe, “Mu sakwa eka tukaba tuka esoo nuga tookoo-matu-kwa'ne'yoo.” ");
INSERT INTO paoNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Soo Te Pabe'e yise ka tseda gwuuhoose ka atsa baa oe tuoonahoose oo-koobatoo nanesootuhise mee ne netamma, “Mu sakwa no'yoona mamatu hebe. ");
INSERT INTO paoNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Esoo nuga puupe-kwa'ne'yoo. Soo Te Naa mooasoo tunemamakwupu nu mu-koobatoo nabatsa. Ooonne'yoona yise soo Te Naa mu tuma'emukwana soomu'wakwu. ");
INSERT INTO paoNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Nu mu tuukwe'e nu ekow atsa baa ka yaa teepu-koobatu tubetse gi hebekwusoo, Te Naa ka te teepu mapudutupudoose, o'no yise nu tubetse pudutupusoo mu-no hebekwu.” ");
INSERT INTO paoNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Numme yise nanesootuhi hoobea negwuuna ka Olive mee naneadu po'woadu-matoo mea. ");
INSERT INTO paoNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Soo Te Pabe'e yise mee ne netamma, “Ka yaa togano suda tu namanekwuse mu e ma'wuookakwu. O'nosoo soo Te Naa yadooawabe tubotugupu, mee'e na'unakwe ka meno'o e manekwuna. ‘Soo seepu takonedu nabatsahookwu, mu seepu yise nana'emota petugwahookwu.’ ");
INSERT INTO paoNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Pana saa'a nu ka e ya'e-kwikoo namayodase mu-kobenasoo Galilee-wi mani petuhoogakwu.” ");
INSERT INTO paoNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Soo Peter meeoo ka Te Pabe'e netamma, “Umu sumuna u-kooba'yoona mea'akwu, nu gi umu-no meakwu,” mee'e. ");
INSERT INTO paoNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Soo Te Pabe'e meeoo ka Peter netamma, “Togesoo tu toganopunne, gisoo ka tsekana kwu'a waha-dooe oo yaka, pahe-dooe ona u numu tuukwekwu u gi e sopedakwatoo.” ");
INSERT INTO paoNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Soo Peter yise meeoo Te Pabe'e netamma, “Tooe umu e batsakwu mee unnepana gi nu meeoo unne-wa'ne'yoo.” Numme Te Pabe'e nakatzimodu no'yoona oo-wa'nesoo unakwe. ");
INSERT INTO paoNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Soo Te Pabe'e yise numme-no Gethsemane-wi petugase onona yise mee ne netamma, “Yowsoo aatapunne nu nanesootuhigakwu.” ");
INSERT INTO paoNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Mu Peter, James, John, o'no mea'a. Soo Te Pabe'e ");
INSERT INTO paoNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","mee mu netamma, “E pewu-kwitu tubetse suda nuumma. Mu sakwa yaahoosoo aatapunne. ");
INSERT INTO paoNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Soo Te Pabe'e sagwane umu kwinga'atoosoo meahoose, o teepu-kooba meatzedose, yise nanesootuhikooha. “E Naa Toogoopatu. Nuga Naa Toogoopatu. Nuka u tunetammakuse nu oo-toogoo meakwu. Ekow e pewu-kwitu suda nuummana, kadoo'oo mayugwe.” ");
INSERT INTO paoNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Soo Te Pabe'e yise ka umu pahe-matoo kodyukase, utua'e mu mayuhoo petugase mee mu netamma, “Mu sakwa nanesootuhipunne, o'no soo suta'yoo gi mu matzama. ");
INSERT INTO paoNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Mu gi oo mapu'a ka gi manese mee'e nu.” ");
INSERT INTO paoNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Soo Te Pabe'e yise penakwa nanesootuhigase, o'no yise tuwow mee unakwe, “E Naa nu tooe a nuukatupana oo-toogoo meakwu ka nuka u tunemayohokupu.” ");
INSERT INTO paoNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Yise tu pupua'amu-baa kodyu petuse, mu utua'e mu mayu petusoo. ");
INSERT INTO paoNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ka mu poonnese kodyukase meeoosoo nanesootuha'e. ");
INSERT INTO paoNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","46","Ka nanesootuhimakwuse ka umu tu pupua'amu-baasoo petugase meeoo mu netamma, “Yow, haa'a mu togesoo utua'e? Yosuhoo! Tamme mea'akwu, nu natzakwenekwu. Yaa soo suta'yoo nana kemma.” ");
INSERT INTO paoNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Togesoo ka Te Pabe'e yadooadyakwe soo Judas uga numme-notu, mu ewa'yoo tukwutumadu o-no numme-baa petugonno, tsegesa noko papabatsekoo hooope hehemana. Mu Jew numu tutunehanedu numme-matoo tutayana. ");
INSERT INTO paoNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Mooasoo soo Judas meeoo mu tunetammakupu, “Nu saa'a oo mitzadyamehoodooa, o'no u oo sopedakwadoodooa o soo Jesus.” ");
INSERT INTO paoNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Soo Judas ka Te Pabe'e yise mee netamma, “How u E Pabe'e?” yise oo mitzadya'mehoo. ");
INSERT INTO paoNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Soo Te Pabe'e yise mee oo netamma, “E pua'a. Yabesoo sakwa u oo manikwuna mayohohoo.” Mu naana ka Judas-notu yise ka Te Pabe'e-ma tsakatuhoo. ");
INSERT INTO paoNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Sumu'yoo numme-matu yise tsegesa-ma ka mu Jew numu tunehanedu pabe'e tummatzidu naka wuga'akwunihoo. ");
INSERT INTO paoNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Soo Te Pabe'e yise meeoo oo netamma, “U tsegesa mabesootugu. Soo tooe haga tooe ka tsegesa-ma mooemanedu nanagoedu, oosoo oo-masoo nabatsakwudu. ");
INSERT INTO paoNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Mu sakwa e unnena nakasopedakwatoo, nu ka E Naa ewow oo tutummatziwabe toha kakasa-gakoo sakwa mesoo natummatzi tuunguse uga. ");
INSERT INTO paoNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Pana nu ka gi umuoo natummatzi tuunguse, ka o'nosoo Te Naa yadooapu nabotugu-wa'nesoo manepunne.” ");
INSERT INTO paoNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Soo Te Pabe'e yise ka mu pumme gwuuhoodu mee netamma, “Nu gi suda tumatugudu, gi nu naduyadu, gi tuduhadu tuwazoo. Gi sakwa mu e tumahepana wobe-ma, tsegesa-ma tuwazoo. Tooe ka e nanesootuhi nobe-kwikoo sapa gi nu-ma tzakadupu-ga'yoo. Muusoo too'e. ");
INSERT INTO paoNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Mooasoo soo tubope ebeoo nabotugu o'nosoo Te Naa tamme tuukwe-kwa'nesoo.” No'yoona numme nakatzimodu yise suise oo-baa'yoona namapetukwahoo. ");
INSERT INTO paoNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Mu tutukwutumadu yise ka Te Pabe'e mu Jew numu tunehanedu pabe'e Caiaphus mee naneadu-baatoo bihooka. Mu Jew numu tutuhanedu ka Caiaphus-no watze tunehane ka Te Pabe'e-witu. ");
INSERT INTO paoNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Soo Peter kwinga'a mu-nakwi meadabena ka pukwi mu tutunehane-kwi petuhooga obe puuwanasoo. Soo Peter mu otuoo tutukwutumadu-baa katu, mee soonammena, “Howga umu ka Te Pabe'e yugwekwu?” ");
INSERT INTO paoNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Soo Jew numu pabe'e mu tutunehanedu-no ka Te Pabe'e too'e nebatsa, gi toge oo manena too'e nekwatepana, gi hemma nemama'yu. ");
INSERT INTO paoNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Tooe ewa'yoo numu ka Te Pabe'e-witu esayipana gi nanakwa'nesoo nanano tuukwe'e. Waha'yoo numu yise saa'a mee unnekwate “Esoo nana meeoo, ");
INSERT INTO paoNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","‘Nu ka nobe ka Te Naa pukwi'yoona te nanesootuhina kadoo'oo mesoo mayukwe yise pahe tabeba-wi oo mesoo mayota.’ ” ");
INSERT INTO paoNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Soo Caiaphas yise wunuoose ka Te Pabe'e mee'e netamma, “U sakwa ne tuukwe ka mu numu ume netamma-kwitu.” ");
INSERT INTO paoNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Pana soo Te Pabe'e yise gi. Soo Caiaphas yise tuwow mee oo netamma, “U sakwa togekoo tuukwe u haa'a too'e Te Pabe'e? U haa'a toogoopadu Te Naa Besaa Tooa?” ");
INSERT INTO paoNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Soo Te Pabe'e yise meeoo oo nanekwegea, “Aha, u besa unakwe. Nu togesapa mu tuukwe saa'a mu e poonnekwu Te Naa-baa'yoona e tunemadabue ka koomeba-kooba e kodyu petuse.” ");
INSERT INTO paoNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Soo Caiaphas tu kwasu makebuekooha. Yooonnekoo mu numu oo sopedakwatoo ka suda Te Pabe'e unnena oo nakasagwa'ekuhoose. Soo Caiaphas yise mee mu tutuhanedu netamma, “Oosoo suda unakwe ka Te Naa-wa'ne'yoo mee naneyugwena. Gi tamme manatusoo oetusoo wahakwutu sookwa'e. Mu muusoo oo naka ka suda oo unakwe mu sakwa ha'yoo oetu netamma. ");
INSERT INTO paoNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Hayoo mu sokwama?” Umu yise ka Caiaphas nanekwegease meeoo unne, “Soo Jesus sakwa nabatsa.” ");
INSERT INTO paoNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Umu-matu ka Te Pabe'e kobi-too toohegonno yise madopotona oo topagetagonno. Oo matatsena oo nematzama, ");
INSERT INTO paoNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","mee unnena, “U sakwa ne mesoo tuukwe ka ume topagetadu ka u pooha ume tuukwe u ka Te Pabe'e mee unnena.” ");
INSERT INTO paoNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Soo Peter tooesoo ka Te Pabe'e mu nehane puuwana tu nobe-kobena katu. Sumu'yoo tutummatzidu tsuadumu mee oo netamma, “U haa'a punno'o ka Jesus-notu?” ");
INSERT INTO paoNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Soo Peter yise no'oko mu numu tu na'oonnakwi manepunnedu mee netamma, “Nu gi oo-notu. Nu gi oo sopedakwatoo.” ");
INSERT INTO paoNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ka koodua nanatzakwona'a-witoo soo Peter meahoo. O'no yise kumma'yoosoo tsuadumu tutummatzidu punno'o oo poonnese mee ka mu numu o konnodu netamma, “Esoo nana uga ka Jesus-notu.” ");
INSERT INTO paoNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Soo Peter yise meesoo, “Nu gi ka nana sopedakwatoo, mee uga nu.” ");
INSERT INTO paoNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Saa'a sumu'yoo umu o konnodu-matu mee ka Peter netamma, “U tookwa umu-notu, u umu-matoo-wa'nesoo yadooakanga.” ");
INSERT INTO paoNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Soo Peter yise mee mu netamma, “Nu togesapa unakwe soo Te Naa sakwa gi e sootuhipana ka mumme e esaya'ekute. Nu gi ookow nana sopedakwatoo.” Toge, o'no soo tsekana kwu'a yagayakwe. ");
INSERT INTO paoNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Soo Peter yise oo soomayuhoo ka Te Pabe'e pumme netammapu, “Pahe u gi e nesopedakwadoopunnekwu gisoo ka tsekana kwu'a yaka.” Soo Peter puunuwatoo mease yaka ka tooe Te Pabe'e sopedakwatoopana gi oo nesopedakwadoose. ");
INSERT INTO paoNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Awamooasoo no'yoona mu Jew numu tutunehanedu ka Te Pabe'e batsakwu mee tunehane. ");
INSERT INTO paoNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Ka Te Pabe'e mi tzagunetowse ka mu otuoo numu-kooba katudu Pilate mee naneadu-matoo oo bika. Mu Jew tutunehanedu gi mu numu batsa-wa'ne'yoo. ");
INSERT INTO paoNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Soo Judas ka Te Pabe'e nabatsakwuna nakasopedakwatoose tubetse suda soonamme ka oo-ma tumuse mu numu tutunehanedu punowsoo mu too'e tumakodyukute. ");
INSERT INTO paoNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","“Nu suda manakwe nu ka mu tummatzina ka besow nana mu batsakwuse,” mee soo Judas unakwe. “U suda soonamme gi numme,” mee umu tutunehanedu oo netamma. ");
INSERT INTO paoNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Soo Judas yise ka mu tumakodyukuna ka pabatsekoo nanesootuhi nobe-wi'yoona sutahoose oo tabebuowse meahoo. Yise puusoo natzakwenehoose ya'ehoo. ");
INSERT INTO paoNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Mu Jew numu tutunehanedu ka oo tutabebuahoona tzobahoose mee unakwe, “Esoo numu nabatsa-kwi a natumanakana. Esoo suta'yoo gi ka nanesootuhi nobe-kwi natumasumudoodu-wa'ne'yoo.” ");
INSERT INTO paoNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Umu yise tubewa oo-ma tumuhookwu mee tunehane wakwawa'a numu pukwi nakoo'yikwuna. ");
INSERT INTO paoNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Meno'o yise esoo tubewabe, Numu Pu-koobatoo Nabatsapu, mee nane'a. ");
INSERT INTO paoNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","10","O'nosoo Te Naa nayadooawabe, Jeremiah mee naneadu, ka yoo tu namanekwuna o'nosoo wahapu. ");
INSERT INTO paoNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Soo Te Pabe'e yise ka Pilate-baa nabi petugase soo Pilate yise mee oo tubenga, “U haa'a ka Jew numu-kooba katukwudu?” Soo Te Pabe'e meeoo oo nanekwegea, “Aha, nu yow oosoo.” ");
INSERT INTO paoNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Mu Jew numu tutunehanedu nanasuda oo netamma, pana soo Te Pabe'e gi ha'yoo unakwe. ");
INSERT INTO paoNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Soo Pilate yise mee ka Te Pabe'e netamma, “Mu tutunehanedu tubetse suda u netamma. U sakwa ka mu tutunehanedu kaaheno nanekwegea.” ");
INSERT INTO paoNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Pana soo Te Pabe'e gisoo tuwazoo ha'yoo sukwe unakwe. Soo Pilate meeoo soonamme, “Nu gi o nakasopedakwatoo ha'oo manenaga masoo gi mu nanekwegea.” ");
INSERT INTO paoNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Nonotsa sumu tomoyina tu na'ewa tukano'o soo numu-kooba katudu sumuoo mu nakwutumadu-matu tzama'wuyakwe ka mu numu unnemakoosoo. ");
INSERT INTO paoNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Mu ewa'yoo numu sumuoo nakwutumadu unu sopedakwatoo Barabbas mee naneadu ewow numu goedu. ");
INSERT INTO paoNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Ka mu numu sumuse soo Pilate mee mu tubenga, “Hanotu umu-matu mu natzama'wukwuna soogwa'e Barabbas pute Jesus?” ");
INSERT INTO paoNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Soo Pilate oo sopedakwatoo ka mu numu Jew tutunehanedu ka Te Pabe'e gi mu petzape oo nuusoogwedu ooonne'yoona umu ka Te Pabe'e wutumase. ");
INSERT INTO paoNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Tooesoo ka Pilate oetu soohane oo nodukwa kumma'akoosoo oo-matoo taya mee oo tuukwe tuunguna, “Gi ka besa'hoo nana how yugwepana soo e nosena suda e masoonamme u ka oo batsa tuungukwuse.” ");
INSERT INTO paoNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Mu numu tutunehanedu mee'e ka ewow numu tunetammakute, “Ka Barabbas tzama'wuse ka Jesus batsa,” mee'e. ");
INSERT INTO paoNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","“Hanotu umu-matu nu tzama'wukwu?” mee'e soo Pilate tutubenga. “Barabbas,” mee mu numu no'yoona oo nanekwegea. ");
INSERT INTO paoNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","“Ha'oo yise nu oo yugwekwu ka Jesus Mu Pabe'e?” mee'e soo Pilate mu tubenga. Umu no'yoona oo nanekwegease mee unne, “Oo batsa.” ");
INSERT INTO paoNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Soo Pilate yise mee mu tubenga, “Ha'oo suda mu oo tumatuguse, oo batsa tuungu?” Pana umu tunenoyukwesoo, “Oo batsa.” ");
INSERT INTO paoNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Soo Pilate ka mu numu-ma suina meeoo mu netamma, “Nu tooe mu too'e tumayohokukwu mu Jesus batsa mee tunetamma gi yise nu hownnekoo oe naneyugwekwu.” Soo Pilate yise mu-kobena'yoona mabatzaka, ka umu-tammesoo ka Te Pabe'e nabatsana tzamunase, puu gi oe soonaneyugwena mee unnena. ");
INSERT INTO paoNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","No'yoona mu numu yise oo nanekwegea, “Oosoo gi hownne'yoo. Mooasoo numme no'yoona oo patza tuunguse. Gi too hownne'yoo tooe soo oo numme manena numme-matoosoo kodyuse.” ");
INSERT INTO paoNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Soo Pilate yise ka Barabbas tzama'wuse ka umu tutukwutumadu ka Te Pabe'e wupagetu tuunguse ooka mu batsa tuungu, oo taposa paa'a yise oo batsakwu. ");
INSERT INTO paoNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Mu tutukwutumadu yise ka Te Pabe'e tu nobe-witoo tzakakase no'yoona mu susumudu tutukwutumadu oo na'oonnakwi mani. ");
INSERT INTO paoNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Umu yise ka pukwi oo namadabuena tsakwumetahoose ka numu-kooba katudu-kwa'nesoo oo wunagayaku. ");
INSERT INTO paoNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Unutse monoga-kwi tuwow oo tzowupagaku tonobe-makoo a namadabue-kwi. Natzetono oo mi-wi tuguse oo-kobena meatzedona oo-ma'yoona naneko'e mee unnena, “U tookwa yow mu Jew numu-kooba katudu.” ");
INSERT INTO paoNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Umu oo kobitu toohena ka pumma oo natzetomasoo oo kwo-makoo oo wupageta. ");
INSERT INTO paoNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Ka oo-ma'yoona nanekoemakwuse umu oo kwasu-kwisoo oo kwaseakuse oo tzakahooka oo batsakwuse. ");
INSERT INTO paoNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Umu tutukwutumadu ka meadabena, Simon mee naneadu wegeahoo. Mu tutukwutumadu ka Simon nenoyukwe ka Te Pabe'e puma nataposakwuna oo hane tuunguna. ");
INSERT INTO paoNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Umu yise ka Numu Tzonoho mee naneadu-wi oo bi petuhooga. ");
INSERT INTO paoNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Yise umu atsa tutza'emukwa baa noko natusooabe mayuana oo too'e hebe tuungu, soo Te Pabe'e yise gi oo hepe. ");
INSERT INTO paoNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","36","Yise awamooa umu oo mi-makoo paa'a oo taposa. Mu tutukwutumadu yise oo kwasu natotsakwate. ");
INSERT INTO paoNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ka Te Pabe'e nataposana tzopanakwa wobe-matoo mee nabotugu, “Yaa esoo Jesus, ka mu Jew numu-kooba katudu.” ");
INSERT INTO paoNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Mu waha'yoo unu tutuduhadu punno'o ka Te Pabe'e na'enakwa nataposa. ");
INSERT INTO paoNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Mu numu ka Te Pabe'e moopa meana oo-ma'yoona naneko'e. ");
INSERT INTO paoNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Mu numu oo-moopa meadu oo-ma'yoo naneko'e ka Te Pabe'e mee netamma, “U meeoo unnepu u Te Naa nobe wudyoomase, pahe tabeba-wi besa oo matabuekwu. U sakwa ka unu tumadina mama'yoo wuekese, namagwetzoi.” ");
INSERT INTO paoNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Umu numu tutunehanedu oo-ma'yoo naneko'e mee unnena, ");
INSERT INTO paoNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“U mu numu magwetzoise, pana yise gi hownnekoo uusoo namagwetzoi. Ne hee Pabe'e u? Gi hownnekoo uusoo namagwetzoi ka naduyana mee unnepana. Uusoo yaa teepu-matoo wuese numme u naka'oedyukukwu. ");
INSERT INTO paoNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Masoo Te Naa Besaa Tooa mee naneyakwe Te Naa God sakwa oo magwetzoi ka Te Naa-wi oo tunaka'oedyukute mee oo unakwe.” ");
INSERT INTO paoNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Umu tutuduhadu oo na'enakwa natzakwenedu punno'o oo-ma'yoona naneko'e. ");
INSERT INTO paoNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Tabeno manakwana oona ka taba pahe-kwikoo tooe, ka teepu-koobakwitu toganopunne. ");
INSERT INTO paoNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ka pahe-kwikoo tooesoo toganopunne soo Te Pabe'e paba wa'agedyadooa, “Eloi, Eloi, lama sabachthani,” mee na'unnedu, “E Naa, E Naa, how manena u e matusookwuna'e?” ");
INSERT INTO paoNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Umu susumudu konnopunnedu-nagatu mee unne, “Masoo tookwa ka Elijah o'nosoo Te Naa yadooawabe mee naneadu bidyakwe.” ");
INSERT INTO paoNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Sumu'yoo umu-nagatu yabesoo tanomanegase yise suda kammadu baa yotsogadu-kooba hanese oodutsekoo hooope-ma oo tzetzabekuse ka Te Pabe'e baa tumakute. ");
INSERT INTO paoNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Pana mu susumudu meeoo, “Oo tsasoopedya. Sumuna soo Elijah tamme-baa tabua petuse oo magwetzoikwu.” ");
INSERT INTO paoNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Soo Te Pabe'e yise paba yadooase soo oo moogooa oo-naga'yoona tsebooegea. ");
INSERT INTO paoNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Soo wunapu ka Te Naa pooha pukwi'yoona numu nanesootuhidu-makoo nowmootoo natzakwenedu ka Te Pabe'e ya'ehoose soo wunapu pa'anakwana tubongo nowmootoo natzagebu'ehoo. Soo teepu yutsungakoohase mu tupe payooagonnona tsawekooha. ");
INSERT INTO paoNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Mu numu pukwi natuoonana-kwitu soo teepu pa'yooawununa mu numu pukwi natuoonana wonedihoo. Mu numu tu'ina Te Naa dooamu suu'mu tu natuoona-kwi'yoona tuusootabue. ");
INSERT INTO paoNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Ka Te Pabe'e tuusootabuese, o'no mu numu mooasoo tu nakoo-kwi'yoona tuusootabuepuna yosupu, umu ewow numu poonne ka Jerusalem-witu. ");
INSERT INTO paoNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Mu tukwutumadu pabe'e ka mu tukwutumaku ka Te Pabe'e eya'epunnedu umu no'oko hemma manewununa poonne ka teepu yutsungakoohase ka Te Pabe'e ya'ehoose umu yise unu suigonnona mee'e nana'unakwe, “Masoo tookwa too'e togesapa ka Te Naa Tooa'a.” ");
INSERT INTO paoNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Ewa'yoo momoko'ne punno'o onow kwinga'a konnopunnena oo poonnepunne umuoo ka Galilee-wi'yoona ka Te Pabe'e-no kemmapu oo tummatzina. ");
INSERT INTO paoNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Umuoo momoko'ne-nagatu pahe'yoo Mary Magdalene, yise Mary mu James noko Joseph pea, yise tuwazoo Zebedee nodukwa. ");
INSERT INTO paoNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","58","Ka tu pudu yongose soo nana Joseph mee naneadu ka Pilate-baa petuse ka Te Pabe'e tookoo oo natuungu, oosoo ka puusoo punno'o Te Pabe'e-wi tunaka'oedyukuna. Soo Pilate ka mu tutukwutumadu ka Te Pabe'e tookoo ka Joseph-tamme mu tzamuna tuungu. ");
INSERT INTO paoNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Soo Joseph yise ka Te Pabe'e tookoo tzakwekuse pudutupu toha wanapu hane petuse oe oo mabutooe. ");
INSERT INTO paoNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Mooasoo soo Joseph ka tupe-wi tutotawagase, ka sumu tabeno puusoo oe natugukwu mee soonammena. Ooweoo yise ka Te Pabe'e tookoo nanomatugu. Ka pabatsekoo tupe yise oo-kobenatoo tonanooehoose yise oe'yoona mea. ");
INSERT INTO paoNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Mu Mary Magdalene-no Mary punno'o ka pukwi oo nanomatuguna oowenapa oo poonnedyugwe. ");
INSERT INTO paoNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ookow moo'a mu Jew numu tutunehanedu no'yoona ka Pilate-baa petuga. ");
INSERT INTO paoNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Umu mee oo netamma, “Numme oo soomayu soo Jesus uga meeoo ka mu numu esaya'ekuyakwe ka saa'a ya'ese waha tabeno manese namayodakwu. ");
INSERT INTO paoNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","U sakwa watsukuoo umu u tutukwutumadu-matu pukwi oo natuguna waha tabeno mu tu'eya'e tuungu, o'no umu oo nakatzimodu sumuna gi oo tookoo tuduhadooa, oosoo tu ya'ekwikoo namayoda mee gi mu numu tuukwedooa. Ekow na'esaya'edu ka mooasoo Jesus unnena oooonakwa suta'yookwu,” mee mu tutunehanedu unakwe. ");
INSERT INTO paoNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","“Unu ooka mu tu'eya'e tuungu,” mee soo Pilate. ");
INSERT INTO paoNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Umu yise ka pukwi oo natugu-kwitoo mease unutse oo madumahoo, o'no gi haga oe egea-wa'ne'yoo, umu yise mu tutukwutumatu ooka eya'e tuungu. ");
INSERT INTO paoNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Yise ka nanesootuhi tabeba waha tabeno oo tabemease ka Te Pabe'e ya'ese oogow awamooasoo, mu Mary Magdalene-no Mary ka Te Pabe'e natugu-kwitu poonne memeahoo. ");
INSERT INTO paoNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Gisoo ka oe mu pepetuga'a soo teepu unu yutsungakooha yise soo Te Naa tummatzidu toha kasa-ga'yoo ka tupe oo koobenatu tonanooekwunihoose oo-kooba katuoo. ");
INSERT INTO paoNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Soo Te Naa tummatzidu besa kootabedooana tukwukwetseba-wa'ne yise besa toha namaso'a. ");
INSERT INTO paoNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Umu tutukwutumadu kwepekeagonnona, ka oo poonnese abedihooga ka sui nunugwehoose. ");
INSERT INTO paoNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ka mu momoko'ne pepetuhoogase soo Te Naa tummatzidu mee mu netamma, “Gi suipana, nu oo sopedakwatoo mu ka Te Pabe'e tookoo wate. ");
INSERT INTO paoNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Pana soo Te Pabe'e gi yow, mooasoo yotsepu ka tu unne-kwa'nesoo. Kekemowse ka pukwi oo natzatugupu poonne. ");
INSERT INTO paoNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Yabe memeahoose ka umu oo nakatzimodu tuukwe petuga Te Pabe'e tu ya'e-kwi'yoona mooasoo yotsepuna mu-kobenasoo Galilee-wisoo petuoogakwu. Ka o petuoogase, mu saa'a Te Pabe'e poonnedooa. O soomayuna ka Te Pabe'e mumme tuukwepu,” mee'e soo toha kasa-ga'yoo. ");
INSERT INTO paoNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Umu momoko'ne yise yabesoo ka pukwi'yoo oo natugupu-wi'yoona memeahoose, besa sokwama gisoo besa oo nakasopedakwadoopana, mu nakatzimodu tuukwega. ");
INSERT INTO paoNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Mu momoko'ne memeana ka Te Pabe'e Jesus wegease Te Pabe'e mee mu netamma, “Ha'oo mu?” Umu yise oo-tamme kekemmase oo-kobena meatzedokwatese oo kuku-kooba matuoonase oo-matoo nanesootuha'e. ");
INSERT INTO paoNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Soo Te Pabe'e Jesus yise mee mu netamma, “Gi suipana. Mu sakwa umu nuka nakatzimodu ka teepu Galilee-witoo taya, nu saa'a onoko mu tapoegeadooa.” ");
INSERT INTO paoNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Ka mu momoko'ne ka Jerusalem-witoo kokodyuse mu tutukwutumadu yise ka mu Jew numu tutunehanedu papabe'e-baa petugonno ka tu poonnena mu tuukwe. ");
INSERT INTO paoNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Mu tutunehanedu papabe'e ka mu tutukwutumadu ewatse'e tumanagakukwu. ");
INSERT INTO paoNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Mu tutunehanedu mee mu netamma. “Mu sakwa mu numu tuukwe ka umu Jesus nakatzimodu tookwa ka oo tookoo hanedooapu ka togano ne utuihoogase. ");
INSERT INTO paoNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ka Pilate ooka nakase numme saa'a ookow tuwazoo tumanagakudooa, o'no saa'a soo Pilate gi ha'oo mu yugwedooa.” ");
INSERT INTO paoNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Mu tutukwutumadu ka pumme tu tumanagakuna hemmase mu numu nemooaka. Yaa manakwana mu Jew numu yise ka Te Pabe'e tookoo natuduhapu mee'e pumme tu nemooagapu oo tubetse naka'oedyukudooa. ");
INSERT INTO paoNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Mu sumumano'yoona sumu-ma tsebooekudu (11) Te Pabe'e-wi tunaka'oedyukudu ka teepu Galilee mee naneadu-kwi petu ka giba-kumaba ka Te Pabe'e mooasoo pumme tunetammakupu-wi. ");
INSERT INTO paoNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Umu-matoo ka Te Pabe'e poonnese oo-matoo nanesootuhi. Pana umu-matu ka Te Pabe'e poonnese punno'o gi oo posopedakwadoo. ");
INSERT INTO paoNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Soo Te Pabe'e yise mee mu netamma, “Soo Te Naa no'oko tu besa pooha-ma e pooha sootuhi, ka ebe tamme-kooba Te Naa-baa noko yise ka yaa teepu-koobatu tuwazoo. ");
INSERT INTO paoNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Meno'o nu mu tuukwe'e mu sakwa ka tooe hano tooe manemona no'obatusoo numu nu-kwitu tunedyooe. Ka mumme naka'oedyukudu baa-wi matzaka Te Naa-koobatoo, nu-koobatoo, yise ka Te Naa Besa Pooha-koobatoo tuwazoo. ");
INSERT INTO paoNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Mu sakwa mu tunedyooena, o'no umu no'oko mumme e tuukwena mayohokwu. Nu ooosapa mu no'yookwu ka teepu mobegwanatoo tooe.”");
INSERT INTO paoNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","3","Nu sakwa Te Pabe'e Jesus Te Naa Tooa-witu, mu tuukwe. O'nosoo Te Pabe'e petukwu-witu, mu Te Naa yadooawabe tubotuguna yise meeoo, “Mana ka hemma nadukadu gi naa-wi'yoona sumu'yoo nana ka Te Naa pooha-toohakwi yadooakwu, ‘Mu sakwa muusoo namabetseapunne, ka Te Pabe'e pudusoo kodyu petukwuno'oto. Mu sakwa kaaheno tusooyugwepunne, o'no mu oo nakabetseanokwu.’ ” ");
INSERT INTO paoNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Ka saa'a sumu'yoo nana John mee naneadu ka numu baa-wi matzakadyakwe, oona ka hemma nadukadu pukwi gi naa-wi'yoona. Soo John ka mu numu ma'emukwapu, mu nanekwaha tuungu. “O'no soo Te Naa mu ma'emukwana soomu'wakwu,” mee mu netamma. Ka mu nanekwahakese, soo John yise baa-wi mu matzakakwu. ");
INSERT INTO paoNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ewa'yoo numu tooe hanotoo tooe oo-baa petudyakwe. Umu ka suda tu tumatugupu wahana yise oo nemawunidyakwe, ka kaaheno meadabekwu mee mu tusooyugwese, soo John yise Jordan mee naneadu ka hooo-kwi mu matzakadyakwe. ");
INSERT INTO paoNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Soo John a puhu nagwesena namadabue-wi kwaseana, yise mokobu-ma nate'a. Kua noko nota peha natumatzu'atoona tukana. ");
INSERT INTO paoNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Soo John yise mee mu numu netammayakwe, “Soo Te Pabe'e pudusoo petukwu, nuga ooonakwasoo unu pooha-ga'yoo, yise nuga ooonakwa tuwazoo besa'yoo. ");
INSERT INTO paoNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Nu baa-wi mu matzaka, mu ka sutakoo po ma'wukase, ka besa'hoo podo meadabekwu. Pana soo Te Pabe'e ka Tu Besa Pooha-ma mu sootuhikwu.” ");
INSERT INTO paoNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","O'no yise soo Te Pabe'e ka Nazareth, ka teepu Galilee mee naneadu-kooba'yoona kemmana ka John-baa petuhooga. Soo John yise ka Te Pabe'e baa-wi matzaka, ka hooodu Jordan mee naneadu-wi. ");
INSERT INTO paoNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Ka Te Pabe'e batsebooegena, o poonne ka Te Naa Besa Pooha pa'anakwana kwe'na'a tubongo punoonooekwuekedu-kwa'ne manegese oo-naga mani petu. ");
INSERT INTO paoNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Soo Te Naa pa'anakwana meeoo oo netamma, “U yow Nuga Besaa Tooa, nu-kwa'ne'yoosoo. Nu unu u soopedyana besa u-koobatu soonamme.” ");
INSERT INTO paoNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","13","Soo Te Naa Besa Pooha yise ka Te Pabe'e oona numu-wanatoo taya. Soo Te Pabe'e yise ka mu nunu'u-baa watsumano (40) too'i. Soo Suta'yoo oo-baa petugase oo too'e ma'emukwa pana soo Te Pabe'e gi oo-ma naka'emukwa. Mu toha kakasa-ga'yoo ka Te Pabe'e sootummatzise soo Te Pabe'e oo-toogoo tsebooe. ");
INSERT INTO paoNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Ka John nawutumase soo Te Pabe'e ka teepu Galilee mee naneadu-kwitoo nanesootuhibu mu numu tunedyooeme'a. ");
INSERT INTO paoNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Ka mu numu meeoo netamma, “Pudusoo Te Naa noko mu numu nemadabuekwu. Mu sakwa ka sutakoo gi nakabetseapana, yise ka Te Naa besa unnepu suu'mu naka'oedyuku.” ");
INSERT INTO paoNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Waha'yoo pakwe-gadu naana, nawanga'a Andrew-no Simon mee nananeadu, ka pumma tu tuukwina ka banunadu-witoo wukwazuyakwe, oonow soo Te Pabe'e ka bakumana me'a. ");
INSERT INTO paoNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Soo Te Pabe'e meeoo mu netamma, “Mu sakwa nu-no mease e nakatzimodu mane. Nu oo mu mayugwese, mu saa'a ka mu numu nuka nakatzimodu mayugwedooa.” ");
INSERT INTO paoNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Umu nawanga'a yise ka pumma tu tuukwina ma'wuhookase, ka Te Pabe'e nagegakwate. ");
INSERT INTO paoNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Umu tzage'e soo waha'yoo nawanga'a, James-no John, ka tu naa Zebedee mee naneadu-no ka tu naa sake-wi. Umu ka pumma tu tuukwina mabetsabedyakwe. Soo Te Pabe'e ka banunadu-kumana meadabena mu poonne, ");
INSERT INTO paoNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","yise umu nawanga'a tuwazoo bihooka. Umu yise ka tu sake noko tu naa ma'wuhookase, Te Pabe'e nakwisoo puno memeahoo. ");
INSERT INTO paoNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Soo Te Pabe'e yise ka Capernaum mee naneadu-wi petuga. Nanesootuhi tabeno ka mu nanesootuhi nobe-wi petugase, ka mu numu besasoo Te Naa-witu tuukwe'e. ");
INSERT INTO paoNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Mu numu yise ka Te Pabe'e-witu mee netamma, “Soo Te Pabe'e yow, oosoo tubetse besa ka Te Naa unnepu-witu wahadyakwe, gi ka te tunedyooedu-wa'ne'yoo.” ");
INSERT INTO paoNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Sumu'yoo nana tsoapayidu oe. ");
INSERT INTO paoNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Soo nana tsoapa-toohakwi wa'agese, ka Te Pabe'e meeoo netamma, “Uda! U haa'a kadoo'oo ne mayugwekwu? U sakwa ne tsasopedya. Numme u sopedakwatoo, u Jesus, noko Hemma Manumudoopu Besaa Tooa.” ");
INSERT INTO paoNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Soo Te Pabe'e ka tsoapa nematzagakwunihoo meeoo oo netamma, “Gi unnepana, mana-ga'yoona tsebooegea.” ");
INSERT INTO paoNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Soo tsoapa kwebebewununa yise paba wa'akese tsebooega. ");
INSERT INTO paoNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Mu numu yise mee nananetammakooha, “Uune'yoo! Numme gi hannano'o mownnekoo poohabe poonnedu. Soo Te Pabe'e puu sukwe yadooase ka tsoapa nematzagakwunihoo.” ");
INSERT INTO paoNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Mu numu yise ka Te Pabe'e-witu nanatuukwe ka teepu Galilee mee naneadu-koobakwitu. ");
INSERT INTO paoNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Soo Te Pabe'e yise watsukweoo tu pupua'amu-no ka mu nanesootuhi-wi'yoona mea'ase, ka Simon Peter-baa petuga. ");
INSERT INTO paoNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Simon Peter yahe peawabe unu tuoeya'ena, tu tookoo unu udutu hape. Umu oo nobe-witu ka Te Pabe'e tuukwe'e. ");
INSERT INTO paoNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Soo Te Pabe'e yise oo-baa petugase, oo mi-makoo oo tzadyoda. Oosoo yise yotseoose, saahoose, mu tukatuungu. ");
INSERT INTO paoNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Oogowsoo yongona tu taba egease, mu numu tuoegoedu ka Te Pabe'e-baa bi petudyakwe. ");
INSERT INTO paoNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Tubetse ewa'yoo mu numu ka nobe-kobena sumupunne. ");
INSERT INTO paoNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Soo Te Pabe'e umu numu-ma matuoonase, mu no'obatusoo tuoegoedu numu mabesaku, mu tsoapagoedu tuwazoo. Soo Te Pabe'e yise gi mu unne tuungu. Soo Te Pabe'e mu tsoapagoedu gi ooka mu wahakwuna petzape, umu ka oo sopedakwadoona. ");
INSERT INTO paoNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Oogow moo'a awamooa tooesoo tu toganopunne soo Te Pabe'e yotsese, oona numu-wanatoo mease nanesootuha'e. ");
INSERT INTO paoNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Saa'a soo Simon tu pupua'amu-no oo wateka. ");
INSERT INTO paoNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Ka oo mayuse, meeoo oo netamma, “Mu numu u kwate, u sakwa kodyugasoo,” mee. ");
INSERT INTO paoNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Pana soo Te Pabe'e mee mu netamma, “Mu numu mana tooe nonobe-gakoo sakwa nu ka Te Naa besa unnepu mu tuukwe. Soo e pooha meeoo e netamma, ‘Manatutooe mu numu ekow nanesootuhibu tunedyooe.’ ” ");
INSERT INTO paoNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Soo Te Pabe'e oona ka teepu Galilee mee naneadu-witu ka mu numu tuukwe'e, ka mu nanesootuhi-wi'yoona. ");
INSERT INTO paoNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Sumu'yoo nana unu tookoo uayidu, ka Te Pabe'e-baa petuga. Ka Te Pabe'e-baa petugase, nanesootuhina meeoo oo netamma, “U sakwa e mabesaku ka meeoo soonammena.” ");
INSERT INTO paoNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","42","Soo Te Pabe'e Jesus oo nakasootuhise, yise oo mi-makoo oo tzamahoose, mee oo netamma, “Nu u mabesakukwu. U besa manekwu. ");
INSERT INTO paoNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Yabesoo u sakwa ka te nanesootuhiwabe petuoose oo tzapoonneku ka besa manese, yise ka Te Naa ka Moses tamme netamma-wa'nesoo, oo tzapoonneku ka u tookoo uayina namabesakuse. Pana tubetse gi ka mu numu tuukwepana ka ume e mabesakuna.” ");
INSERT INTO paoNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Pana soo nana ewow mu numu tuukwe ka Te Pabe'e-witu, yise tooe hano'yoona tooe ewa'yoo numu oo-baa petudyakwe. Soo Te Pabe'e yise kwinga'a numu-wanatoo mea, gi yise punowsoo kodyuka'a. ");
INSERT INTO paoNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Huu tabe mease, soo Te Pabe'e ka Capernaum-wi kodyu petuga. Ewa'yoo numu yise oo petugana nakow, ");
INSERT INTO paoNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","yise oo-baa petudyakwe. Ka nobe kaa'no, ka natzakwuna-kobenakwi tuwazoo. Soo Te Pabe'e mu numu tunedyoo'e ka Te Naa-witu. ");
INSERT INTO paoNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Watsukwe'yoo nanana kapa-wikoo ka gi yutsungadu nana tzakwuhuna ka nobe-wi petuga. ");
INSERT INTO paoNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Umu ka Te Pabe'e-matoo oo tzakwuhookase sapa, ewa'yoo numu ka nobe-wi, umu gi hownnekoo oe tzoonoo'a. Umu yise ka nobe-koobatu tzatawagase, ka kapa-nokosoo tobongo oo tzakweku ka Te Pabe'e-kobenatoo. ");
INSERT INTO paoNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Soo Te Pabe'e oo sopedakwatoo, ka mu naana pumme mu naka'oedyukute, yise ka gi yutsungadu nana meeoo netamma, “E pua'a, nu ka u tuma'emukwana soomu'wakwu.” ");
INSERT INTO paoNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Umu Jew numu tunedyooedu o aatadu mee sokwama, ");
INSERT INTO paoNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Esoo hayoo suda na'unnedu unni. Masoogina ka Te Naa-wa'nesoo tusooyugwe, mee soonamme. Soo Te Naa suu'mu ka numu tuma'emukwana soomu'wa.” ");
INSERT INTO paoNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","9","Soo Te Pabe'e yise oo sopedakwatoo, ka mu tusooyugwena yise meeoo mu netamma, “Mu gi e naka'oedyukute nu ka mu numu tuma'emukwana soomu'wa, pana mu oo poonnekwu ka nana e mabesakuse. ");
INSERT INTO paoNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Mu yise oo sopedakwadookwu nu eka teepu-kooba ookow poohabe hee-ga'yoo, ka mu numu tuma'emukwana e soomu'wakwuna.” Soo Te Pabe'e yise ka nana gi yutsungadu meeoo netamma, ");
INSERT INTO paoNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Wunuoose ka u kapa nobe-witoo tzakwuka.” ");
INSERT INTO paoNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Soo nana yise ka tu kapa tzakwuhuna mea. No'yoona mu numu oo soo'oedyukuna meeoo, “Te Naa tubetse besa'yoo. Numme nanabesow namanedu yaa tabeno poonne. Numme gi haanano'o yooonnekoo poohabe poonnedu.” ");
INSERT INTO paoNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Soo Te Pabe'e yise ka banunadu-kumabasoo petugase, ewa'yoo numu oo-baa petudyakwe. Soo Te Pabe'e ka Te Naa unnepu mu tuukwe. ");
INSERT INTO paoNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Sumu'yoo nana Levi mee naneadu oonow natzakwuna-wi katuna tumasumudoodyakwe. Soo Te Pabe'e o meana oo poonne, ka o oo katu, yise meeoo oo netamma, “U sakwa umu e nakatzimodu-matu mane.” Soo Levi yotseoose, oo nageka. ");
INSERT INTO paoNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Saa'a soo Te Pabe'e ka Levi nobe-witoo oo-no mea, umu tukaga. Ewa'yoo numu tumasumudoodu o, tuma'emukwadu mee mu Pharisee mu ne'a, umu ka Te Pabe'e nagedu yise umu-no tuka. ");
INSERT INTO paoNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Mu Pharisee ka Te Pabe'e umu-no mu tuka mu poonnese, meeoo ka umu oo nakatzimodu netamma, “Umu mumme tunedyooedu sakwa gi suda tumatugudu numu-no tukapana, umuoo tumasumudoodu ooonne'yoo.” ");
INSERT INTO paoNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Soo Te Pabe'e ka mu nakase, mee unakwe, “Nu yaa ka teepu-kooba petu, ka mu tuma'emukwadu Te Naa-witu tuukwekwuse. Ka mu numu mooasoo kaaheno meadu mooasoo Te Naa-witu sopedakwatoo. Soo pooha-ga'yoo puu tuoegoedu numudoo suu'mu naba'e, gi ka besow numudoo, nu puu ka mu tuma'emukwadu suu'mu tummatza'e, gi ka besow numu.” ");
INSERT INTO paoNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Susumudu numu yise ka Te Pabe'e-baa petuse mee oo netamma, “Umu John pupua'amu yise ka mu Pharisee-no mee tunetamma, ‘Numme puu gi tukapana nanesootuhiyakwe.’ How yise umu ume nakatzimodu gi punno'o ooosoo tumatugu?” ");
INSERT INTO paoNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Soo Te Pabe'e mee mu nanekwegea, “Nu togesoo yaahoo umu-no, pudu nodukwadoodu-kwa'ne, umu puu ka nanano'yoona besa sokwama. ");
INSERT INTO paoNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Pana pudusoo nu gi umu-no'yookwu, o'no yise umu e nakatzimodu gi tukapana nanesootuhikwu. ");
INSERT INTO paoNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","22","Ka oohoo a manepunne mu gi hownnekoo ka mu numu pudu tumayohope no'oko ka mumme putoogoo mooa tumayohope mayua-wa'ne'yoo. Oosoo puu wanapu nadotsana-kwa'ne. U pudu wanapu ka mooa wanapu-ma dotsanase, oosoo gi toge tubuakwu. Mu gi hownnekoo eka mumme pudu natunetammakuna ka mu mooa tumayohope noko mayua-wa'ne'yoo.” ");
INSERT INTO paoNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Sumu nanesootuhi tabeno, soo Te Pabe'e yise umu pumme nakatzimodu-no ona tubewabe-too me'a. Umu tseagoena ka wada-matu mabokana, oo mahangeana oo tuka. ");
INSERT INTO paoNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Mu nanesootuhidu Jew numu moohedu, Pharisee mee nananeadu, mu poonne, umu yise ka Te Pabe'e meeoo netamma, “Umu u nakatzimodu gi ka te Jew tumayohope mayoho. Umu ka wada mahangeana oo tukadyakwe, esoo nanesootuhi tabeba, gi numu hemma howyugweno'o.” ");
INSERT INTO paoNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Soo Te Pabe'e yise meeoo mu netamma, “Mu sakwa oogow nea ka o'nosoo soo besa tamme-kooba katudu, David mee naneadu, punno'o ka ne Jew tumayohope takopa, ka tu pupua'amu-no tseagoena. ");
INSERT INTO paoNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Soo David ka Te Naa nanesootuhi nobe-witoo mease ka tu pupua'amu-no, soo nanesootuhibu numu tunedyooedu Abiatha mee naneadu, ka pooha tukaba mu maka, umu nanesootuhibu numu tunedyooedu suu'mu tukana. Soo Te Naa yise gi hayoo mu netamma. ");
INSERT INTO paoNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Soo Te Naa ka nanesootuhi tabeba nemadabue ka mu numu nasootuhi-kwi, gi sakwa mu numu o'no hemma how yugwe tuungu. ");
INSERT INTO paoNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Nu yow Mu Pabe'e. Nu mu manekwuna nemadabue ka nanesootuhi tabeno.” ");
INSERT INTO paoNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","O'no yise soo Te Pabe'e ka mu nanesootuhidu-baa petuga. Soo nana mi pasatopo'nepu gi miyutsengudu ka nanesootuhipe-wi. ");
INSERT INTO paoNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Mu tunesootzemadu yise ka Te Pabe'e poonnepunne how saa'a soo Te Pabe'e ka nana mi mabesaku. Umu ka Te Pabe'e how u nanesootuhi tabeno numu sootuha'e? Mee oo too'e netammakwuse. Oo wohonedu oo hoawipunne, ka gi hemma ha'oo nuugweno'o oo oo manakwe. ");
INSERT INTO paoNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Soo Te Pabe'e meeoo ka nana netamma, “Yaatoo kemma.” Soo nana ka Te Pabe'e-baatoo me'ahoo. ");
INSERT INTO paoNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Soo Te Pabe'e ka umu pumme poonnepunnedu meeoo netamma, “Ka pabow tabeba-wi gi hemma how nuugweno'o, o'no haa'a suta'yoo? Yise o'no tabeba haa'a mu gi ha'yoo oo sooyugwe? O'no haa'a mu gi namabesakukwu? O'no haa'a ka pabow mu tabebano'o, ya'epana gi how'neyoo?” Umu yise gi tunema'yuhoo. ");
INSERT INTO paoNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Soo Te Pabe'e yise gi besa mu sooyukwe mu soosawikuna, gi mu numu nakasootuha'e. Soo Te Pabe'e yise meeoo oo netamma ka gi mayutsungadu, “Matuhe.” Oosoo yise matuhe, oo mi namabesakuhoopu. ");
INSERT INTO paoNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Mu Pharisee oe'yoona mea'ase, mu wakwawa'amu numu pabe'e pupua'amu-no oetu nehanegonno, no'yoona mee tusoo'yukwe umu sakwa Te Pabe'e batsa mee. ");
INSERT INTO paoNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","12","Soo Te Pabe'e umu tunakatzimodu-no yise ka banunadu-kumaba petuga. Ewa'yoo mu numu, ka Te Pabe'e nakatza'e, mu tuoegoedu besa oo mayugwepu-witu nakadu tooe hano manakwanatu tooe, oo-matoo kemma. Mu tsoapagoedu ka Te Pabe'e-baa petuse, oo-kobena'yoona nanesootuhina meeoo oo netamma, “U yahoo. U ka Mu Numu Manumudoopu Tooa,” mee. Soo Te Pabe'e yise mee mu netammadyakwe, “Mu gi meeoo tuukwepana.” Soo Te Pabe'e ka mu tunakatzimodu mee netamma, “Mu sakwa ka sake mabegapunne, nu oe meahookwu.” Mu numu ka Te Pabe'e tu tsamowkwunu petzabena, umu nanamatsagawunu. ");
INSERT INTO paoNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Soo Te Pabe'e yise ka giba-matoo meahoose, ka umu pumme nakatzimodu bi, ka mu netutzease. ");
INSERT INTO paoNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Sumumano wahamatsebooekudu (12) umu-nagatu netutzease yise meeoo mu netamma, “Mu e yadooawabe manekwudu. Nu yise nanesootuhibu mu numu mu tunedyooe tayakwu. ");
INSERT INTO paoNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Mu pooha-gana tsoapa nematzakwunikwu.” ");
INSERT INTO paoNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Umu oo yadooawabe mee nanane'a Simon, soo Te Pabe'e Peter meeoo oo neahoo, ");
INSERT INTO paoNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","James tu wannga'a John-no, mu naa Zebedee mee naneadu. Soo Te Pabe'e ka James noko John Nunuadu-kwa'ne mee mu ne'a. ");
INSERT INTO paoNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andrew, Philip, Bartholomew, Matthew, Thomas, James, oo naa Alphaeus mee naneadu, Thaddeus, Simon, ka Cana mee naneadu-wi'yoona kemmadu, ");
INSERT INTO paoNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","soo Judas punno'o saa'a oobenakwa tukwutumadu ka Te Pabe'e-matoo bika. ");
INSERT INTO paoNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Soo Te Pabe'e tu nobe-wi kodyu petuga. Mu numu yise ka nobe-wi ewa mani petuga, soo Te Pabe'e ka umu tunakatzimodu-no mu mabetseana, gi ooosapa tuka. ");
INSERT INTO paoNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Mu nanumu gi oo manena nakana, umu yise meeoo sokwama, “Esoo emukwa. Numme sakwa nobe-witoo oo tzakaka,” mee. ");
INSERT INTO paoNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Mu Jew numu nanesootuhiwabe ka Jerusalem-wi'yoona kemma'ase, ka Te Pabe'e-baa petugase, ka Te Pabe'e nesootzemana meeoo, “Oosoo numu poohadu. Oosoo sutakoo pooha-gana ka tsoapa nematzagakwunidyakwe.” ");
INSERT INTO paoNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Soo Te Pabe'e yise meeoo mu netamma, “Sutakoo u pooha-gana gi hownnekoo tsoapa nematzagakwuni-kwa'ne'yoo. ");
INSERT INTO paoNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Ka yooonnekoo, mu numu sukwe nanayadooena, gi hownnekoo hemma nemamakwu ewa nanatumoo'oo. ");
INSERT INTO paoNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Mu naanapua'amu sukwe nanahase gi hemma nemamakwu-wa'ne'yoo. ");
INSERT INTO paoNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Mu numu poohadu naduyadu sutakoo pooha-ga'yoo, gi hownnekoosoo sutakoo nematzagakwuni-wa'ne'yoo. Mu sutakoo pooha-ga'yoo gi puusoo tu nanagoena petzape. ");
INSERT INTO paoNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Nu ka sutakoo ooonnakwa unu pooha-ga'yoo, yise nu tuwazoo unu nazoo'e. Nu mu mesoo matzooekute. ");
INSERT INTO paoNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Ka no'oko suda te tumatugupu soo Te Naa kadoo'oo mayugwekwu, ka ooka te nekwa'e. Ka Te Naa-witu gi suda netammapana tuwazoo. ");
INSERT INTO paoNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Pana ka ooka Te Naa Besa Pooha suta'yoo mee netammadu, soo Te Naa gi oo soomu'wakwu.” ");
INSERT INTO paoNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Mee soo Te Pabe'e mu netamma, ka tu Besa Pooha mu nesootze'ma. ");
INSERT INTO paoNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Soo Te Pabe'e pea-no oo wannga'amu yise petugonno, obe puuwana konno ka oo yadooadyakwe. ");
INSERT INTO paoNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Ewa'yoo mu numu oo nana'oonnakwi aatadu meeoo oo netamma, “U pea-no u wannga'amu obe puuwana'yoona u-no neyadoo'a.” ");
INSERT INTO paoNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Soo Te Pabe'e meeoo mu nanekwegea, “Haga e pea-no e kwangamu?” ");
INSERT INTO paoNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ka umu tu na'oonnakwi aatadu poonnese meeoo mu netamma, “Mu suu'mu yaatu e nanumu. ");
INSERT INTO paoNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Mu ka E Naa te pa'anakwatu nakabetseana, no'yoona mu ka E Naa nakabetseana, e tubetse nanumu.” ");
INSERT INTO paoNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Soo Te Pabe'e ka banunadu-kumaba'yoona mu numu tunedyoo'e. Ewa'yoo mu numu oo na'ena-kwi manepunne, soo Te Pabe'e yise ka sake-wi tsebooese oe katu; mu numu yise ka banunadu-kumaba konno. ");
INSERT INTO paoNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","O'no soo Te Pabe'e ewa mu numu tunedyooena, meeoo mu tuukwe'e, ");
INSERT INTO paoNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“E nakapunne, sumu'yoo nana ka tubewabe-wi tumasu'a. ");
INSERT INTO paoNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Susumudu soo oo pooe tumasua-matu ka a nadapodo-witoo sawemena, mu hootseba'a yise mu soo'a. ");
INSERT INTO paoNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Susumudu soo oo pooe punno'o unu tupe-ga-nagatoo sa'we, gi tookapu teepu-ga-witoo. Umu yabesoo naahoose sapa, ");
INSERT INTO paoNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","soo taba mu koopasakuhoo, umu ka gi tookapatoo tuna-gana. ");
INSERT INTO paoNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Susumudu tsa'abu-nagatoo sawe meana, naa pana mu tsa'abu ewa naana mu tatsatsebooa. ");
INSERT INTO paoNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Susumudu besow teepu-koobatoo sawehoose besa na'a. Umu tumasape ewa pooedoo'a.” ");
INSERT INTO paoNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Soo Te Pabe'e yise mu numu meeoo netamma, “Mu sakwa e nakapunne, mu ka besow naka-gana.” ");
INSERT INTO paoNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Umu Te Pabe'e nakatzimodu mu numu-no ka Te Pabe'e-baa petugase, mee'e oo tubenga, “Ha'oo manena u mu numu natugwe'nga?” ");
INSERT INTO paoNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Soo Te Pabe'e yise mu nekwegease mee unakwe, “Mu e nakatzimodu mooasoo nasootuhipu. Mu mooasoo oo nakasopedakwadoo, ka Te Naa unnepu. Mu nasootuhipu, pana mu numu gisoo ookow nasootuha'e, ooonne'yoona nu meeoo mu natugwengakatu Te Naa nuka tunetammakuna. ");
INSERT INTO paoNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","‘Mu ooosapa ka Te Naa besa unnepu nakamo, pana gi oo soonaka'oedyukute. Mu tuwazoo tooe oo poonne pana gi oo soonakasopedakwadoo. Mu sakwa ka mumme oo tuukwena naka'oedyukuna, mu poonnena nakasopedakwadoona, o'no sakwa mu nu-matoo kemmase, nu yise mu sootuhikwu.’ ");
INSERT INTO paoNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Mu haa'a ka nuga natuukwepu sopedakwadoodu? Ha'oo yise mu ka ekow na'unnepu mumme e tuukwe'e gi oo nakasopedakwatoo? ");
INSERT INTO paoNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Soo Te Naa yadooana ka numu tumasu'a-kwa'ne'yoo. Soo numu yise ka teepu-wa'ne'yoo. ");
INSERT INTO paoNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Soo numu ka teepuna tumasu'ana, susumu-kwi gi besa na'a. Soo numu ka Te Naa yadooana gi oo naka'oedyukute. Soo gi toge'yoo yise mu numu tza'emukwa. Mu natza'emukwadu yise ka po-koobatoo sawetu-wa'ne'yoo. ");
INSERT INTO paoNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Susumudu numu ooonne'yoo gi tunagadu-kwa'ne'yoo. Ka mooe'ugasoo susumudu besa sokwamana pumme tu nesootze'ma ");
INSERT INTO paoNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","yabesoo ka Te Naa yadooana soomu'wa. ");
INSERT INTO paoNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","19","Susumudu numu ka teepuna naadu, tsa'abu-wa'ne'yoo. Soo ooonne'yoo numu ewa tu hee-gana petukute. Ka tsa'abu-wa'ne'yoo yabesoo ewa'a, yise ka Te Naa yadooana gi naka'oedyukute. ");
INSERT INTO paoNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Susumudu soo numu besa tumasu'a, ka besow teepu-wi. Ewa'yoo mu numu tunaka'oedyukudu manekwu, tamme ka Te Naa besa unnepu mu tuukwena.” ");
INSERT INTO paoNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Soo Te Pabe'e yise mee mu netamma, “Tugootabuagunoo gi he-tooha sukwe nuunadu. Pa'a'yoona mu gootabuakupunnena, yise no'oko hemma gootabuakute. Soo e natugwengapu tugootabuagunoo-kwa'nesoo. ");
INSERT INTO paoNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Umu-wa'nekoosoo nu ka Te Naa-witu mu tunesootabuedooa. ");
INSERT INTO paoNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","25","Mu e naka'oedyukudu tubetse unu sokwamakwu, mumme e tuukwe-kwa'ne, mu yise unusoo besa tusopedakwadookwu. Mu gi e nakabetseadu no'oko oo soomu'wakwu.” ");
INSERT INTO paoNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Soo Te Pabe'e meeoo mu netamma, “Mu numu ka Te Naa unnepu-witu nakase e naka'oedyukudooa. Ooosapa mu manemokwu tumasu'ape-kwa'ne. Sumu'yoo nana puu ka tubewabe-wi wahabu masu'ase, ");
INSERT INTO paoNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","28","oosoo puu gi nasootabue yabesoo na'a. Tooe togano, tooe tabeno tooe, yabesoo na'a. Oo naa tabu'ana, tamme gi sopedakwatoo. ");
INSERT INTO paoNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Naakese, pa'a wunukese, yise ka naa makwuse, nakutadu.” ");
INSERT INTO paoNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Soo Te Pabe'e yise meeoo, “Mu ka e naka'oedyukuna ewa manese nu mu tuukwekwu. Meno'o huutse'yoosoo numu E Naa-wi tunaka'oedyute, ");
INSERT INTO paoNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","atsapooe-kwa'ne. Atsapooe tuutse'yoo ka namasuana, ");
INSERT INTO paoNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","oosoo puu pa'a naakese kwasu, mu hootseba'a yise oo-naga nobe-too.” ");
INSERT INTO paoNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","34","Soo Te Pabe'e ewow numu nanatuukwe'e, hemma mu nakasopedakwatoo-kwikoo, yise saa'a soo Te Pabe'e ka nanatugwengapu tu nakatzimodu watse tunesootabuedooa. ");
INSERT INTO paoNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Ka tu yongokese, soo Te Pabe'e yise mu pumme nakatzimodu mee netamma, “Tamme ka banunadu ooenapatoo meakwu.” ");
INSERT INTO paoNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Mu oo nakatzimodu mu numu ewatoo mease, ka Te Pabe'e-baa sake-wi tzoonooase ka baa natzemangega. Susumudu ka sake-wi umu-no. ");
INSERT INTO paoNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Unu hukwa petuse, baa ka sake-wi bakaanoho. ");
INSERT INTO paoNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Soo Te Pabe'e ka sake ooonnakwa habeno'o tu mi tzopedanena, atasoo u'wedape. Mu oo nakatzimodu suina, yise oo netupoonnese, mee oo netamma, “Ha'yoo u ne soobedya? How sakwa u ka ne badatu'ihoose?” ");
INSERT INTO paoNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Soo Te Pabe'e ka hukwapa noko baa yadooese, “Obeda sapa,” mee unne. Gi hukwa manise, gi hee yutsungapunne. ");
INSERT INTO paoNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Soo Te Pabe'e ka umu tunakatzimodu meeoo netamma, “Mu sakwa gi unu su'ipana, gisoo mu nuka togesoobedya.” ");
INSERT INTO paoNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Umu yise meeoo nananetamma, “Haga esoo nana? Soo hukwapa ka baa-no a nakabetsea.” ");
INSERT INTO paoNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Soo Te Pabe'e ka mu tunakatzimodu-no ka Gerase mee naneadu-kwitoo natzemange petuga. ");
INSERT INTO paoNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","4","Soo Te Pabe'e ka sake-wi'yoona tsebooekase, sumu'yoo nana tsoapayidu oo tapoegea. Esoo nana ka tupe tawaga-wi nobe-ga'yoo mu tu'ipu nakoo-kwi. Ewasoo oo mi-no oo kowpa natzakunedi'yakwe. Nonotsa yise soo nana oo mesoo tzahanekwunihooyakwe. Gadoo'oo haga natzooedu oo wutama-wa'ne'yoo. ");
INSERT INTO paoNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Soo nana nonotsa tabeno, tooetoo togano, tooe hano tooe oona manennumme mu tu'ipu natuoona-kwi, tooetoo giba-nagakwi wa'agenumme, puusoo ka tupe-ma natzebokana. ");
INSERT INTO paoNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Oosoo yise ka Te Pabe'e poonnese oo-baa tanomanepetuoo. ");
INSERT INTO paoNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Soo Te Pabe'e yise meeoo oo netamma, “U tsoapa mana-ga'yoo tsebooegea.” Soo tsoapa yise meeoo oo netamma, “How yise u nukadooe? Numme u sopedakwatoo. U Jesus, Numu Manumudoopu Tooa'a. Gi numme makadoo'ookupana.” ");
INSERT INTO paoNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Soo Te Pabe'e ka nana meeoo tubenga, “Ha'yoo u nane'a?” Soo tsoapa oo nanekwege'a, “Ka ewa'yoona numme, numme ewa nanane'a.” ");
INSERT INTO paoNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Umu tsoapa ewana meeoo oo netamma, “Gi ne tayapana ekow teepu-koobakoo.” ");
INSERT INTO paoNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ewa'yoo mu hogu ka giba-kumaba tuka konnomo'o. ");
INSERT INTO paoNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Umu tsoapa yise meeoo ka Te Pabe'e netamma, “U sakwa mu hogu-nagatoo ne taya.” ");
INSERT INTO paoNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Soo Te Pabe'e yise meeoo mu netamma, “Muusoo too'e.” Mu tsoapa yise ka mu hogu-naga mani. Mu hogu ka banunadu-kwi badatu'ihoo. ");
INSERT INTO paoNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","16","Mu naana yaatu, mu hogu mabetseadu ka mu hogu badatu'ihoose, mu naana nana'emota tatanomane, ka mu numu yise tuukwe'e. Umu no'yoona kemmase oo poonne. Pudusoo yise ewa'yoo numu ka Te Pabe'e-baa mani petu. Soo nana soonamme-kwitu besa manese, oosoo yise onow katu, tu hekwi namasooana. ");
INSERT INTO paoNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ewa'yoo mu numu ka Te Pabe'e-ma nasoosuina yise oo tayakwuna'e. ");
INSERT INTO paoNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Ka Te Pabe'e ka sake-wi tsebooedyakwe, soo nana ka Te Pabe'e meeoo netamma, “Nu u-no meakwu.” ");
INSERT INTO paoNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Soo Te Pabe'e yise meeoo ka nana netamma, “U sakwa gi nu-no meapana, u sakwa u nanumu-witoo kodyu. Te Naa besa ume tumadukugana mu tuukwe.” ");
INSERT INTO paoNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Soo nana yise kodyuka, ka teepu Sumumano (10) mee naneadu-kwitoo. No'yoona mu numu oo nakadu besa nakasokwama. ");
INSERT INTO paoNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Soo Te Pabe'e ka banunadu mana-kwi nummese, ewa'yoo numu oo-baa manega'a. ");
INSERT INTO paoNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Oosoo nana mu nanesootuhidu nematugudu, Jairus mee naneadu, ka Te Pabe'e-kobena meatzedo petuse ");
INSERT INTO paoNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","mee oo netamma, “E padu unu tuoeya'e. U sakwa yabe kemmase, oo-kooba pooha matuguse, oosoo sakwa besa manese, besa nuumma.” ");
INSERT INTO paoNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Soo Te Pabe'e yise oo-no mea. Ewa'yoo numu umu-no oo takoo'negea'a. ");
INSERT INTO paoNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Sumu'yoo mogo'ne hoone tuoeya'edu sumumano wahamatsebooekudu (12) tommo petuga. ");
INSERT INTO paoNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Mu poopooha-ga'yoo gi besa oo mayugwe. Oosoo yise no'oko tu hemma tzasoo'a petuga. Nahanobasoo manemena, yise hanobasoo manepetuga. ");
INSERT INTO paoNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Oosoo yise ooka Te Pabe'e-witu nakase, oo ooonakwana oo kwasu tzamow, mee toosoohanena, ");
INSERT INTO paoNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","“Nu sakwa oo kwasu sukwe tzamase, besa mane.” ");
INSERT INTO paoNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ka oo tzamase, soo oo puuhana yise pasahoo. Oo tookoo yise no'yoona besa nuumma, ka besa manese. ");
INSERT INTO paoNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Soo Te Pabe'e yise yabesoo tu pooha-matu yaahoose, oo sopedakwatoose umu-tamme nakwumunase, yise meeoo unne, “Haga e tzamow?” ");
INSERT INTO paoNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Umu oo nakatzimodu meeoo oo netamma, “Ewa'yoo numu u takoo'napunne. U yise meeoo, ‘Haga e tzamow?’ ” mee. ");
INSERT INTO paoNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Soo Te Pabe'e yaatu poohnamoo'ase, oo poonne ka oo manedu. ");
INSERT INTO paoNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Oosoo mogo'ne yise su'ise kwebebewunu. Ka tu manena sopedakwatoose, o'no yise ka Te Pabe'e-matoo kemmase oo nanekwahakute. ");
INSERT INTO paoNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Soo Te Pabe'e mee oo netamma, “U ka e naka'oedyukuna besa manese, saa'a mea.” ");
INSERT INTO paoNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Ka Te Pabe'e togesoo yadooawunu, oona ka Jairus nobe-wi'yoona kemmadu meeoo tuukwe'e, “U padu ya'eoo, gi ka Jesus u nobe-witoo bipana. Nagutza saa'asoo.” ");
INSERT INTO paoNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Soo Te Pabe'e oo nakase ka Jairus mee netamma, “Gi su'ipana. E nakabetsea.” ");
INSERT INTO paoNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Soo Te Pabe'e yise ka Jairus-no oo nobe-witoo memeakwate. Peter, James, John suu'mu umu-no ka Jairus nobe-witoo mea'a, meeoo susumudu nakatzimodu mu netamma, “Gi kemmapana numme-no.” ");
INSERT INTO paoNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Ka oonow mu petugase mu numu ewa'yoona sakwa'e. ");
INSERT INTO paoNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Soo Te Pabe'e yise ka nobe-wi egease, meeoo mu netamma, “Gi sakwipana. Esoo tsea'a gi ya'e, sukwe u'we.” ");
INSERT INTO paoNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Umu oo-ma'yoo naneko'e. Soo Te Pabe'e yise puuwanatoo mu taya. Ka tsea'a naanapua'amu-no ka umu punotu bina ka tsea'a habe-kwitoo mea'a. ");
INSERT INTO paoNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Soo Te Pabe'e yise ka tsea'a-matoo takwuese, oo mi-ma tzakaduse, meeoo oo netamma, “Yotseoo.” ");
INSERT INTO paoNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Soo tsea'a wahamatsebooekute (12) tomopu, yise tuponnese, yabesoo yotseoose, wununnumme. Mu numu otu oo poonnedu hayoo sapa sokwamahoo. ");
INSERT INTO paoNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Soo Te Pabe'e ka tsea'a naanapua'amu meeoo netamma, “Hemma manatu a maka.” Soo Te Pabe'e meeoo mu tunetammakute, “Gi haka tuukwepana kayoo e tumadukuse.” ");
INSERT INTO paoNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Soo Te Pabe'e umu tu nakatzimodu-nosoo ka Jairus nobe-wi'yoona tu nanumu-witoosoo kodyu petuga. ");
INSERT INTO paoNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Ka nanesootuhi tabeba oo manepetuse, soo Te Pabe'e numu-baa nanesootuhi petuga, ka mu numu besasoo Te Naa-witu tuukwe'e. Ewa'yoo numu oe oo nakapunne, meeoo nananetamma, “Soo Jesus besa yadooa, pana oosoo tamme-nagatusoo. Ha'oo yise esoo Jesus ka ekow yooonnekoo nageapu, Te Naa-witu tu sopedakwadoona? ");
INSERT INTO paoNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Esoo nana uga nobe-doodu yise yaa meno'o unu tu pooha-gana te tzapoonnekute. Tamme oo sopedakwadoo, oosoo Mary tooa. Mu James, Joseph, Judas, Simon yise oo wanga'amu. Yise oo punne'emu yow tamme-naga.” Yise umu gi ka Te Pabe'e naka'oedyukute. ");
INSERT INTO paoNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Soo Te Pabe'e mee mu netamma, “Ka yaa teepu-koobatu mu numu ka Te Naa yadooawabe naka'oedyukudu, yise umu oogowsoo nanumu, oo nonopua'amu-no gi.” ");
INSERT INTO paoNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Soo Te Pabe'e ka mu susumudu numu tuoegoedu-ma matuoona yise mu mabesaku. Huutse'yoo numu namabesaku, umu ka gi tunaka'oedyukuna. ");
INSERT INTO paoNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Te Pabe'e tutuha tu nanumu soobedya ka mu too'e tuukwese sapa, gi pumme mu naka'oedyukute. Soo Te Pabe'e yise oona tzatzage'e-kwisoo nanesootuhibu numu tunedyooennumme. ");
INSERT INTO paoNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Soo Te Pabe'e yise mu wahamatsebooekudu (12) tu nakatzimodu bise, meeoo mu netamma, “Nu mu pooha-makakwu, puma tsoapa mu nematzagakwunikwuna. Wakwaha'yoona saa'a gi hemma hemapana memea. ");
INSERT INTO paoNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Gi nadukadu tunopana, gi mago'o, gi puma hemma mu tumukwuna tuwazoo hemapana. ");
INSERT INTO paoNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Gi waahoo kwasu hemapana. Sumu-kwisoo tanegeana tuwow. ");
INSERT INTO paoNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ka mooe'ugasoo tunaka'oedyukudu nobe-wi egease, ooweoo umu-baa tooi, gi oonatooe tooinnummepana. ");
INSERT INTO paoNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Yise ka mu numu gi mumme naka'oedyukudu gi mu nobe-wi egeapana. Ka kooseba mu moko-matu tata'nese, oe'yoona saa'a memea. Mu numu tzapoonneku how suta'yoo tookwa umuoo numu.” ");
INSERT INTO paoNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Mu tunakatzimodu yise mea'ase, meeoo mu numu tuukwe me'a, “Gi suda manepana.” ");
INSERT INTO paoNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Yise ewow tsoapa nematzagakwunimena. Ewa'yoo mu numu tuoegoedu yoohoo, namagunana besa manakwe. ");
INSERT INTO paoNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","16","Ewa'yoo numu ka Te Pabe'e-witu nesoobedya. Susumudu numu meeoo, “Masoo sumuna soo John numu baa-wi matzakadu, tuusootabuese, unu poohadooa.” Susumudu numu meeoo oosoo ka sumuna Elijah. Susumudu punno'o meeoo, “Oosoo Jesus ka sumuna Te Naa-witu wahadu.” Mu numu pabe'e Herod mee naneadu, ka Te Pabe'e-witu nakase, yise meeoo, “Nu tukwutumadu ka John batsa tuungu. Oosoo yise sumuna tuusootabuepu?” ");
INSERT INTO paoNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Ka o'nosoo, soo Herod tu pabe'e nodukwa nodukwadoo, soo mogo'ne Herodias mee nane'a. ");
INSERT INTO paoNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Soo John ka Herod meeoo netammano'o, “Gi toge u manakwe, gi ka Herodias nodukwadoopana.” ");
INSERT INTO paoNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Soo Herodias unu sutana ka Herod ka John too'e batsa tuungu. ");
INSERT INTO paoNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Soo Herod yise ka John tu batsakwu-ma unu sua'e, ka John nanesootuhidu nana. Mu tukwutumadu ka John wutumow. Soo Herod besa ka John nakasoobedya pana oo yadooa-ma nakasua'e. ");
INSERT INTO paoNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Yise gea'a soo Herod tu nadooa'adoono'o tabeno mu numu papabe'emu-no ewa tuka. ");
INSERT INTO paoNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","23","Herodias padu tukawunuse yise mu numu nugakute. No'yoona yise oo nugana besa soobedya. Soo Herod mee oo netamma, “Hemma u? Tooe hemmadooe u soogwina nu u gea'akwu.” ");
INSERT INTO paoNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Soo tsuadumu tu pea tubenga, ");
INSERT INTO paoNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","“Hemma sakwa yise nu natuungu?” Yise soo oo pea meeoo oo netamma, “Ka John koota tsekowse, ka oo wo hanese, yise tseda-wi oo wuuna.” ");
INSERT INTO paoNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Soo Herod oo nesootu'adya'e ka oo batsa tuunguse, ewa mu numu oo unnena naka. ");
INSERT INTO paoNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Herod yise ka mu tukwutumadu ka John koota tsekea'a tuungu, ");
INSERT INTO paoNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","ka oo wo tseda-wi oo wuunase, ka Herodias yise yongagea. ");
INSERT INTO paoNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Mu John nakatzimodu oo nakase yise oo tookoo tugudooa. ");
INSERT INTO paoNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Umu Te Pabe'e nakatzimodu oo-baatoosoo kodyuse, ka Te Pabe'e no'oko ka tu manemopu-witu oo tuukwe. ");
INSERT INTO paoNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Soo Te Pabe'e meeoo mu netamma, “Tamme sakwa gi haa'no songapangapunne.” Ewa'yoo numu pooha namagunana meagonno, gi tu tuka-ma sokwamana manegonno. ");
INSERT INTO paoNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Soo Te Pabe'e yise umu tu nakatzimodu-no ka sake-wi, gi numu pumme poonne-kwitoo mea'a. ");
INSERT INTO paoNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Mu numu mu mea'ase, mu poonne. Ewa'yoo mu numu mu posoopedakwadoona oo nanatuukwe ka baa-kumi mu mea tu no'ata-kwi'yoona umu yise oo-baa sogo tatanomanepetuga. ");
INSERT INTO paoNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Soo Te Pabe'e yise ka sake-wi'yoona wue petuga ka baa-kumabatoo, ewa'yoo mu numu o, pukwi oo petuga-kwi. Mu numu sukwe mukwadu-kwa'ne mu posoobedyana, mu sootuhina yise mu tunedyoo'e. ");
INSERT INTO paoNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Yabesoo yise taba egaga'a, ");
INSERT INTO paoNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","mu tunakatzimodu ka Te Pabe'e meeoo netamma, “U sakwa mu ta'ya ka kwaya'yoona mu kemma'ase. Umu sakwa puusoo tu tukakwuna hownnekoo mayu.” ");
INSERT INTO paoNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Soo Te Pabe'e yise meeoo mu netamma, “Hemma sakwa tamme mu maka?” Mu tunakatzimodu yise meeoo, “Numme haa'a ka tukapu tumukwu? Ewa'yoo numu yaatu. Hanoko sakwa yise numme ka tukapu mu mayuku?” ");
INSERT INTO paoNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Soo Te Pabe'e yise meeoo mu netamma, “Huuhoo mu tukaba-ga'yoo? Mu sakwa oo poonnetooa.” Ka saa'a umu tunakatzimodu meeoo oo netamma, “Manegeoo numme tukaba-ga'yoo. Yise waahoo tuwazoo numme pakwe-ga'yoo.” ");
INSERT INTO paoNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","40","Soo Te Pabe'e meeoo ka mu tunakatzimodu, “Maa poohega-kooba sapa mu numu aata tuungu. Yoode'a, mu sakwa mu toonooba-wisoo aata.” ");
INSERT INTO paoNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Soo Te Pabe'e yise ka mu aatahoose, ka tukaba, noko pakwe hemahoose, toogoopadu poonnese, nanesootuhikooha. Yise ka tukaba noko pakwe tzabokase, umu pumme nakatzimodu, mu ewow numu maka tuungu. ");
INSERT INTO paoNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","44","Yise ewow numu maka (5000 nanana). Ka nanesootuhina ka tukaba noko pakwe toge'yookwunu ka mu numudoo negwa'e, umu yise ewa tukase, no'yoona wutzu'me. Mu Te Pabe'e nakatzimodu yise ooka pakwe, noko tukaba nagupenina ka wahamatsebooekudu (12) kawono, oo-ma kaanoku. ");
INSERT INTO paoNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Soo Te Pabe'e yise umu pumme nakatzimodu meeoo netamma, “Mu sakwa ka sake-wi kodyu, ka banunadu natzemangegase, yise ooka Bethsaida mee naneadu-kwitoo kodyuka. Mu numu ewana yise nu tayakwu.” ");
INSERT INTO paoNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Yise ka mu mea'ase soo Te Pabe'e ka giba-matoo mea, ka nanesootuhikwuse. ");
INSERT INTO paoNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","48","Ka yongona, ka sake-wi ka banunadu banaamoo-kwitoo, soo Te Pabe'e no'oko mu poonne. How gi besa natzemange, ka kwenahadu unu hukwawunu. O'no awamooasoo tu tabu'agena, soo Te Pabe'e ka banunudu-koobakwi kemmaka'e. Soo Te Pabe'e yise umu moopa too'e meahoo. ");
INSERT INTO paoNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","50","Mu tunakatzimodu oo poonnese unu suise, yise wa'agemo'o, “Uda tsoapa.” Soo Te Pabe'e mu yadooe, “Gi suipana. Nu yaahoo.” ");
INSERT INTO paoNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","52","Ka sake-wi umu-baa tsebooese, yise soo hukwapa kadoo manigea'a. Umu oo nakatzimodu gi gea'a oo pooha manena nakasopedakwadoona ka manegeoo tukaba nagoohanena, waahoo pakwe tuwow. Ka ewow numu oo makana poonne pana gi oo soo'oedyukute. ");
INSERT INTO paoNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Ka Gennesaret mee naneadu-kwi umu natzemange petuse, tu sake o tzakuna, ");
INSERT INTO paoNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","oe'yoona yise sawe. Mu numu ewana nosumuna ka oo nesopedakwatoona ");
INSERT INTO paoNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","oo nanatuukwe. Umu nanatuukwewunudu, mu tuoegoedu, mu nuummadu oo-baa bi petudyakwe. Susumudu oo-baa natzahedape petu. ");
INSERT INTO paoNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Umu yise Te Pabe'e kwasu-matu tzamase, no'yoona besa mane. ");
INSERT INTO paoNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Mu Jew numu nananesootuhipe papabe'e numu tunedyooedu ka mu Pharisee mee nananeadu-nagatu kemmana, ka Jerusalem mee naneadu-kwi'yoona kemmase, ka Te Pabe'e-baa. ");
INSERT INTO paoNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Umu ka Te Pabe'e nakatzimodu poonne, umu gisoo mabatzagapana tukagonno. ");
INSERT INTO paoNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Umu Jew-no Pharisee tumayohope-wi umu gi tuka ka gisoo mabatzagana ka tu nanamooatupu tumayohope. ");
INSERT INTO paoNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Umu ka hano mose tu tootsa mabatzakwuna'e. Tu tseda, pukwikoo tu saakwuna, batzakase oekoo saakwu. Ne nanamooatupu mee ne tunetammakuna, numme yise oo mayoho. ");
INSERT INTO paoNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Umu Jew tuukwewabe, mu Pharisee-no, ka Te Pabe'e meeoo netamma, “Mu u nakatzimodu sagwane ma'emukwapu-ga'yoo, gi tu mi mabatzakapana tuka. Umu te nanamooatupu ka tu nanumu meeoo netamma namabatzakase yise tuka.” ");
INSERT INTO paoNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Soo Te Pabe'e yise meeoo mu netamma, “How yise mu ka te nanamooatu besa nakana, gi Te Naa tuukwewabe naka? Soo Isaiah, ka mumme nemooagadu-witu meeoo unnepu. ‘Mu ka Te Naa nakabetse'a mee mu naneyakwe.’ Soo o'nosoo Te Naa yadooawabe togesapa mu netamma ka mee tubotuguna. ‘Umu numu meeoo unnepana mu tupa apeakana, gi mu tubetse sokwamana. Umu ka Te Naa gi nakabetse'a. ");
INSERT INTO paoNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Umu ka Te Naa-matoo nanesootuha'e mee sukwe naneyugwepana, ka mu numu aata-tammesoo ne'emukwakute, ka pummesoo tusooyugwena mu numu ewana mee netamma, “E nakapunne pummesoo tumayohope tumayoho o'no mu ka Te Naa nakabetse'a.” ’ ");
INSERT INTO paoNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Umu mee'e mu nanamooatu mu Te Naa unnepu-wa'nesoo.” ");
INSERT INTO paoNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Soo Te Pabe'e yise meeoo mu netamma, “Mu sakwa gi umu te nanamooatupu tuukwena naka'oedyukupana. Mu sakwa Te Naa suu'mu naka'oedyuku. ");
INSERT INTO paoNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Ka mooasoo soo Moses meeoo unnepu, ‘Te Naa noko ka numu tu naanapua'amu mabetsea tuungu. Soo tu naanapua'amu suda netammadu sakwa nabatsa.’ ");
INSERT INTO paoNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","12","Mumme putoogoo mooa tumayohona pana mu meeoo, tamme sumuna ka mu naanapua'amu mee netammakwu, ‘Nu ka Te Naa God tummatzi, gi umu e naanapua'amu tummatza'e.’ Mu gi besa ka mu naanapua'amu matugu, ka oo tumatuguna. Mu ka Te Naa tunetammana takopa, ka mu te nanamooatupu tumayohope ooosapa nagena. ");
INSERT INTO paoNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ewa'yoosoo te nanamooatupu unnepu mu numu ka gi besow tunedyooe, tamme sakwa ka Te Naa tuukwena suu'mu naka'oedyuku.” ");
INSERT INTO paoNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Soo Te Pabe'e yise meeoo mu ewa-kwikoo mu numu netamma. ");
INSERT INTO paoNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","16","“Mu sakwa e nakasopedakwatoo, soo hemma mu tukana gi hownne'yoo, Te Naa-nakwana. Soo suda te tumatuguna yise gi besa te soonammena yugwe, umuoo soo Te Naa gi petzape,” mee. ");
INSERT INTO paoNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Ka nobe-wi'yoona mu tunakatzimodu meeoo ka Te Pabe'e tubenga, “Ha'yoo u ka mu numu tuukwepu?” mee. ");
INSERT INTO paoNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","19","Soo Te Pabe'e meeoo mu nanekwege'a, “Mu sakwa o'nosoo e nakasopedakwatoo. Soo tooe hemma tooe te tukana gi hownne'yoo Te Naa-nakwana. Soo tukapu gi atasoo numu yugwe-wa'ne'yoo. Soo tukapu numu-nagakwi sukwe meadu.” Soo Te Pabe'e yise te tzapoonnekute tooe hownne'yoo numu tukapu besa'yoo. ");
INSERT INTO paoNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","“Ka suda te tumatuguna soo Te Naa gi petzape. ");
INSERT INTO paoNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","No'obatusoo suda te tusooyugwena, tuduhana, tubatsana, ");
INSERT INTO paoNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","moogoobuna, numu mooagana, numu nowuakuna. Kumma'akusoo nasoodyagena, numu nesootzemana, besa nasooyugwena, ");
INSERT INTO paoNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","ooonnekoo soo Te Naa gi petzape.” ");
INSERT INTO paoNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Soo Te Pabe'e yise oona tubewa-wi, Tyre mee naneadu-kumaba, ka nobe-wi watze petuga, gi haga oo sopedakwatoo. Mu numu puusoo yise oo mayuoo. ");
INSERT INTO paoNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Yise sumu'yoo wawa'a mogo'ne oo-baa petu. Ka Te Pabe'e-witu nakase ka tu padu tsoapaya'e ooka oo nematzagakwuni tuunguna. ");
INSERT INTO paoNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Soo Te Pabe'e yise oo nemapoonnena mee oo netamma, “Gi nu wawa'a sootummatza'e. Nuga nanumu suu'mu sakwa nu tummatzi. Numme Jew mu wakwawa'a sadu'u mee ne'a. 'Yoo manepunne mu numu puu gi tu dooamu tukakwuna tu sadu'u maka.” ");
INSERT INTO paoNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Soo wawa'a mogo'ne yise mee oo netamma, “Mu te dooamu puu tu tugupenina sadu'u maka. U sakwa nuga padu mabesaku u nanumu too,” mee. ");
INSERT INTO paoNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Soo Te Pabe'e yise ka wawa'a mogo'ne meeoo netamma, “Aha, besa'yoo u ka meeoo unnena, nu u tummatzikwu. U nobe-witoo kodyuka ka tsoapa nu mooasoo nematzagakwunipu.” ");
INSERT INTO paoNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Soo mogo'ne ka kodyu petugase, ka tu padu besa manepu, ka tu kapa-kooba oo habennumme oo mayuoo petuga. ");
INSERT INTO paoNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Soo Te Pabe'e yise ka Tyre mee naneadu-nakwana kodyuna ka Galilee banunadu-witoo mea. Soo Te Pabe'e yise ka Sidon mee naneadu-toogoo me'a. Ka teepu Sumumano'o Nogatudu mee naneadu. ");
INSERT INTO paoNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Onona mu numu ka Te Pabe'e-baa sumuoo nana bi petu. Oosoo nana gi nakatawagadu, gi besa yadooadu tuwazoo. Mu numu ka Te Pabe'e meeoo netamma, “U sakwa namekoosoo u mi-makooba matuoonase, eka nana mabesaku.” ");
INSERT INTO paoNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Soo Te Pabe'e yise ka nana bihooka mu numu ewanagakoo. Soo Te Pabe'e yise tu makoogoo ka nana naka-wi tsetuoonahoo. Ka tu makoogoo tu huutse-ma mobanase, ka nana ego-kooba tsetugu. ");
INSERT INTO paoNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Yise soo Te Pabe'e toogoopadu poonne. Nasongapose ka nana gi nakatawagadu meeoo netamma, “Yise nakatawaga.” ");
INSERT INTO paoNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Soo nana nakatawaga manese, besa yadooa mani. ");
INSERT INTO paoNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Soo Te Pabe'e yise meeoo mu numu netamma, “Gi sakwa mu haka tuukwepana,” pana mu numu gi oo nakabetseana oo nanatuukwe'e. ");
INSERT INTO paoNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Umu meeoo, “Uune! Soo Te Pabe'e unu tumada'e. Soo Te Pabe'e ka mu gi nakatawagadu nakadage ma'eyakwe, mu gi apegeadu besa apegea maneyakwe.” ");
INSERT INTO paoNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Mu numu ewana sumuna tusooase, gi hemma tuka, soo Te Pabe'e meeoo mu tu nakatzimodu netamma, ");
INSERT INTO paoNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Nu suda umu numu nuummakute, ka pahe tabeno gi hemma mu tuka, umu tseago'e. ");
INSERT INTO paoNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Nu ka nobe-witoo mu tayase, umu sumuna tsuawumehoekwu, umu-matu ka kwinga'a kemmase.” ");
INSERT INTO paoNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Umu oo nakatzimodu yise meeoo oo nanekwegea, “Ka tubetse numu-wana'yoona hownnekoo tamme ka nadukatu umutoo mayukwu?” ");
INSERT INTO paoNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Soo Te Pabe'e yise meeoo mu tubenga, “Haa'noko mu tukaba-ga'yoo?” Mu oo nakatzimodu yise meeoo, “Natakwatsukwu'yoo (7) tukaba.” ");
INSERT INTO paoNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Soo Te Pabe'e yise mu numu meeoo netamma, “Ma teepuna sapa aatapunne.” O'no yise ka tukaba hanese, oo-koobatoo nanesootuhise oo tzabokase, mu tu nakatzimodu mu numu ooka haneku tuungu, umu yise ka tukaba mu numu ewana haneku. ");
INSERT INTO paoNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Umu yise tuwazoo huutsekoo tutugutzekoo pakwe-ga'yoo; ka pakwe tuwazoo nanesootuhikuse mu tu nakatzimodu mu numu haneku tuungu. ");
INSERT INTO paoNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Mu numu yise ka tukase wutzumeoose, ka tunakatzimodu natakwatsukwuoo (7) kawona-witoo ooka a nagupenina tzoba. ");
INSERT INTO paoNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Tubetse ewa'yoo (4000) numu o. ");
INSERT INTO paoNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Soo Te Pabe'e yise mu numu nobe-witoo taya. Yabesoo yise ka tu sake-wi mu tu nakatzimodu-no kuowse onona ka teepu Delmanutha mee naneadu-kwitoo mea'a. ");
INSERT INTO paoNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Mu Pharisee ka Te Pabe'e-baa petugase oo nesootzemana mee oo netamma, “U sakwa mee tzapoonneku ka Te Naa Pooha-matu u hee-gana.” ");
INSERT INTO paoNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Soo Te Pabe'e yise mu nasoomenakwana, mee ka mu gi tunaka'oedyukudu netamma, “Mooasoo nu mu tzapoonnekuse sapa, mu gi oo soo'oedyukute. Nu gi mu tzapoonnekukwu, ka e pooha-gana.” ");
INSERT INTO paoNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Oosoo yise ka mu tunakatzimodu-no, ka mu Pharisee-baa'yoona mea'ase ka sake-wi tzoonooase ka baa natzemangeka. ");
INSERT INTO paoNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Umu oo nakatzimodu ka baa natsemanegase ka tu tukuba soomu'waka. Sumuoosoo tukaba yise tuno'o ka sake-wi. ");
INSERT INTO paoNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Soo Te Pabe'e yise meeoo mu netamma “Ka mu numu yadooedu namayuadu tukaba gi soogwipana.” ");
INSERT INTO paoNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Umu oo nakatzimodu yise gi oo nakasopedakwadoona yise meeoo nananetamma, “Soo Te Pabe'e te nesootze'ma ka tukaba te soomu'wakuse.” ");
INSERT INTO paoNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","18","Soo Te Pabe'e ka mu nakasopedakwadoose meeoo mu netamma, “Gi suipana ka gi tukuba-gana. Mu gisoo e pooha nakasopedakwatoo. ");
INSERT INTO paoNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Mu ka sumuna oo sooma'yu nu manegeoo tukaba-koobatoo nanesootuhi, oo ewakwuna soogwina. Nu yise ewow numu (5000) maka. Huoo kawona-witu ooka a nagupenina umu numu tzobahoo?” mee. Sumu'yoo mu oo nakatzimodu yise meeoo oo nanekwegea, “Wahamatsebooekudu (12) kawona-witu,” mee. ");
INSERT INTO paoNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Nu yise tuwow ewowsoo (4000) numu maka, natakwatsukwuoo (7) tukaba-gana, mu yise ewowsoo tuwazoo hane, ka a nagupenina. Huoo kawona-witu ooka a nagupenina umu numu (5000) tzobahoo?” Sumu'yoo mu oo nakatzimodu yise meeoo oo nanekwegea, natakwatsukwuoo (7) kawona-witoo mee. ");
INSERT INTO paoNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Soo Te Pabe'e yise meeoo unakwe, “Mu gi e nakasopedakwatoo, mu tuwazoo gi e naka'oedyukute.” ");
INSERT INTO paoNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Umu yise ka Bethsaida-wisoo kodyu petu. Susumudu numu ka Te Pabe'e-matoo gi tubootabuedu tsaka petu. Umu meeoo ka Te Pabe'e netamma, “U sakwa eka nana, gi tubootabuedu-ma matuguse a mabesaku.” ");
INSERT INTO paoNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Soo Te Pabe'e yise oo tsakakase oo pooe-witoo tooheoo. Yise o-kooba matuoonase, meeoo oo tubenga, “U haa'a tooe besa tubooha'e meno'o?” ");
INSERT INTO paoNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Soo gi tubootabuedu mee oo nanekwegea, “Nu meno'o yaatu poonnepana, ka mu numu-ma sogomeadu, sunngabe-kwa'ne posoobedya.” ");
INSERT INTO paoNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Soo Te Pabe'e oo pooe-kooba matuoonasoo, soo gi tubootabuedu besa manise besa tuboohwa'e. ");
INSERT INTO paoNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Soo Te Pabe'e meeoo oo netamma, “U sakwa kaaheno nobe-witoo mea, gi numu tuukwepana.” ");
INSERT INTO paoNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Soo Te Pabe'e yise mu tunakatzimodu-no ka Galilee-wi'yoona mea'a, ka Caesarea Philippi mee naneadu-kwitoo. Onow po-kumi sogo meana meeoo mu tubenga, “Hayoo mu nu-witu naka?” ");
INSERT INTO paoNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Umu oo nekwegea, “Susumudu numu meeoo u ka sumuna John baa-wi numu matzakudu. Susumudu numu meeoo u ka sumuna Elijah. Susumudu punno'o meeoo u ka sumuna Te Naa-witu wahadu.” ");
INSERT INTO paoNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Soo Te Pabe'e mu tubenga, “Hayoo mu nu-witu sooyugwe?” Soo Peter oo nekwegea, “U Te Tubetse Pabe'e,” mee. ");
INSERT INTO paoNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Soo Te Pabe'e meeoo mu netamma, “Gi e wahapana, nu yow Mu Pabe'e.” ");
INSERT INTO paoNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Soo Te Pabe'e yise meeoo mu tunakatzimodu tuukwe, “Mu numu yadooakudu gi e petzape, unu nananuumadu e wumakuse, e batsase, o'no yise pahe tooise saa'a nu tuusootabooedooa.” ");
INSERT INTO paoNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Soo Te Pabe'e toge kaaheno meeoo unakwe. Umu oo nakase soo Peter yise ka Te Pabe'e oetu meeoo watze tunesoobedyakute, “Gi soo hee oo manepunne. Gi umu u batsa.” ");
INSERT INTO paoNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Soo Te Pabe'e yise mu tunakatzimodu-matoo kodyuse meeoo ka Peter netamma, “Gi meeoo unnepana. Oosoo Suta'yoo u ne'emukwawunu. U sukwe numu soonamme-kwa'ne tusooyugwe, gi ka Te Naa soonamme-kwa'ne.” ");
INSERT INTO paoNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Soo Te Pabe'e yise no'oko mu numu, ka umu tunakatzimodu-nokosoo mee mu netamma, “Tooe haga tooe nu-wi tunaka'oedyukudu sakwa mee unne oosoo gi hownne'yoo, tooe mu ka nu-koobatoo nabatsase sapa, mu e nagenokwu. ");
INSERT INTO paoNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Tamme ka tammesoo too'e namagwetzoina tamme kadoo'oo namayugwekwu, mu ka nu-koobatoo kadoo'oo mesoo namayugwena mu namagwetzoikwu. ");
INSERT INTO paoNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Tamme ka teepu-kooba'yoona ewow hee-ga'yoo pana ka te ya'ese oosoo gi te magwetzoi-wa'ne'yoo. ");
INSERT INTO paoNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Gi oosoo te gwetzoina tumu-wa'ne'yoo. ");
INSERT INTO paoNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Tooe haga tooe nu-ma nasookwina, noko e unnepu tuwazoo, nu yise punno'o, saa'a mu-ma nasookwikwu, ka Te Naa pooha-toohakwi e petuse, ka toogoopadu e tutummatziwabe mu toha kakasa-gakoo-no.” ");
INSERT INTO paoNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Soo Te Pabe'e yise meeoo mu netamma, “Nu togesapa mu tuukwepu susumudu mu yaa konnodu gisoo tuina, e pooha-gana poonnekwu.” ");
INSERT INTO paoNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Oona ka sumuna sumu natakwatsu (7) tooise oosoo Te Pabe'e tu pupua'amu bikase, oona ka pa'a giba-ma'yoona nanesootuhi-ga. ");
INSERT INTO paoNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Ka togesoo oo nanesootuhiwunu soo pukwi oo namasooana atasoo tapu'a, besa toha patakwetseaawunu. ");
INSERT INTO paoNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","O'no yise waha'yoo nanana oo-baa petuoo, Elijah-no Moses mee'e nananeadu umu nanano yise yadoo'a. ");
INSERT INTO paoNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Soo Peter yise meeoo ka Te Pabe'e netamma, “Besa numme ka kemma'ase. Numme sakwa piho mu tatza nobe-tooku. O'no mu ka Elijah noko Moses-no susu'muoo,” ");
INSERT INTO paoNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","mee unne, ka gi tu unnena sopedakwadoona ka unu suise. ");
INSERT INTO paoNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Togesoo oo yadooawunu soo koomeba umu-kooba habaga petuoo. Te Naa yise ka koomeba-naga'yoona yadooakooha. “Yow esoo nuga Besaa Tooa, mu sakwa besa a nakabetsea.” ");
INSERT INTO paoNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Soo Te Pabe'e suu'mu yise umu-baasoo. Mu Elijah-no Moses kadoo'oo. ");
INSERT INTO paoNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Soo Te Pabe'e tu nakatzimodu-no ka giba-ma'yoona sawekese meeoo mu netamma, “Gisoo haka tuukwepana, ka mu poonnena. Ka kadoo e manese yise e yotsese, o'no suu'mu saa'a mu numu tuukwe.” ");
INSERT INTO paoNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Mu oo nakatzimodu yise ka Te Pabe'e nakase gi oo waha, pana yise meeoo nanatuubenga, “Ha'oo manena meeoo unakwe? Te Pabe'e haa'a ya'ese yise pudu yotsekwu?” ");
INSERT INTO paoNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Umu yise ka Te Pabe'e meeoo netamma, “Umu Te Naa yadooawabe meeoo unakwe, Elijah mooe petukoo, o haa'a togesapa numme natuukwe'e? O'no yise haa'a Te Pabe'e mu nakwi saa'a petudooa?” ");
INSERT INTO paoNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Soo Te Pabe'e yise meeoo mu netamma, “Aha, meeoo tubetse nabotugu. Mooe'ugasoo soo Elijah ka mu numu mooe tunesootabue petukwu. Nu yise oo-penakwa petuhoose suda punno'o namatugukoo. ");
INSERT INTO paoNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Mooasoo soo Elijah mooe kemmapu. Umu numu yise tooe how tooe ka Elijah yugwe, ka a nabotugu-kwa'nesoo.” ");
INSERT INTO paoNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","15","Soo Te Pabe'e yise tu pupua'amu-no ka mu tunakatzimodu-baasoo kodyu petu. Mu numu ewana ka Te Pabe'e poonnese besa sokwamase oo-tamme tatanomanega. Mu nananesootuhidu tuukwewabe, ka Te Pabe'e nakatzimodu-no mooasoo mu nanepetukute oe petuoo. ");
INSERT INTO paoNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Soo Te Pabe'e yise meeoo mu tubenga, “How manena umu nananepetukute?” ");
INSERT INTO paoNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Sumu'yoo nana ka Te Pabe'e meeoo netamma, “Nu e tooa'a u-baa too'e hane petu u kadoo'ookoosoo. Oosoo tsoapayaena gi besa yadoo'a. ");
INSERT INTO paoNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Tooe hano'yoona tooe, soo tsoapa oo-ma tabu'ana soo e tooa ya'eookayakwe. Nu umu ume nakatzimodu, ooka too'e nematzagakwuni tuungu. Umu gi oo mabu'a.” ");
INSERT INTO paoNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Soo Te Pabe'e meeoo mu netamma, “Mu gi e nakabetse'a, tooe nu wuna'me yaa mu-pa'yoopana mu gi e naka'oedyukute. Ka naatse tzakowke.” ");
INSERT INTO paoNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Soo naatse ka Te Pabe'e poonnese ya'ehooka. ");
INSERT INTO paoNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Soo Te Pabe'e meeoo, “Haa'no wuna'me soo naatse 'yoo manenumme?” Mee soo oo naa, “Tuha'a manakwanasoo. ");
INSERT INTO paoNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Susumudu soo tsoapa ka naatse too'e soobatsana goso-witoo oo wunapuyakwe, baa-witoo tuwazoo. U pooha haa'a ne sootuhi-wa'ne'yoo? Ne mesoo tummatza'e haa'a?” ");
INSERT INTO paoNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Soo Jesus yise oo nanekwegea, “U dea'a mooasoo e pooha-gana sopedakwatoo. Nuka u toge soobedyase, o'no nu u tummatzikwu.” ");
INSERT INTO paoNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Soo nana meeoo, “Sagwane nu u naka'oedyukute, pana unusoo ume e naka'oedyukuna nu sookwa'e.” ");
INSERT INTO paoNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Gisoo mu numu ewana petu, soo Te Pabe'e ka tsoapa kwinga'atoo nematzagakwunise mee oo netamma, “Yaanona mea. Gi kodyupana ka naatse-matoo.” ");
INSERT INTO paoNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Soo naatse paba yadooase, ya'eooka. Mu numu yise me'e, “Ya'ehoo haa'a?” ");
INSERT INTO paoNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Soo Te Pabe'e o mi-makoo oo tzadyota. Soo naatse besa manise yotseoo. Soo Te Pabe'e yise umu tu nakatzimodu-no, ka mu numu-baa'yoona mea'a. ");
INSERT INTO paoNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Ka nobe-kwi mu tzoonooase, umu Te Pabe'e nakatzimodu oo tubenga, “How manena numme gi oo nemabu'a?” ");
INSERT INTO paoNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Soo Te Pabe'e mu nekwegea, “Oosoo yooonne'yoo tsoapayaedu nanesootuhibu-ma nata'yadu.” ");
INSERT INTO paoNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Galilee-too umu watze mease ");
INSERT INTO paoNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","soo Te Pabe'e yise umu tunakatzimodu tuukwega'ase meeoo mu netamma, “Mu nuka wohonedu nu-ma tzakaduse, e batsase, saa'a nu pahe tabemease tuusootabuedooa.” ");
INSERT INTO paoNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Umu oo unnepu gi nakasopedakwatoo, pana umu ooka tu tubengakwuna-ma sua'e. ");
INSERT INTO paoNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Ka mu tunakatzimodu ka Capernaum-wi petugase, ka nobe-kwi'yoona soo Te Pabe'e mee mu tubenga, “Hekwitu mu nehane mu ka kemmana?” ");
INSERT INTO paoNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Mu Te Pabe'e nakatzimodu yise gi ka Te Pabe'e nanekwegea, ka numu ooonakwa besa-kwitu nehanena, “Soo tooe haga umu-nagatu ka mu ooonakwa besa'yoona oosoo ka Te Naa-baatoo mooe meakoo.” ");
INSERT INTO paoNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Soo Te Pabe'e yise no'oko mu tunakatzimodu nabatoo bise meeoo mu netamma, “Soo tooe haga tooe numu-kobena soo nadatsungadu, sakwa no'oko numu sumu-nakwi'yoona numu tummatzino.” ");
INSERT INTO paoNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Soo Te Pabe'e yise tuutsekoo tuha'akoo umu-baatoo bise, meeoo mu netamma, ");
INSERT INTO paoNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Mu ka tuutsekoo tuha'akoo nu-koobatoo besa soobedyana, mu tookwa nuka besa sobedya tuwazoo.” ");
INSERT INTO paoNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Soo John ka Te Pabe'e meeoo netamma, “Ka nana ka tsoapa nematzagakwunidu, numme poonne. Tooe oosoo nana gi numme ume nakatzimodu-matu pana u nanea-ma ka tsoapa nematzagakwuni. Numme yise meeoo oo netamma, ‘U sakwa gi ka Te Pabe'e nanea-ma ka tsoapa nematzagakwunipana,’ ” mee. ");
INSERT INTO paoNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Soo Te Pabe'e meeoo mu netamma, “Mu sakwa uga gi meeoo oo netammapana. Oosoo ka e nanea-ma ka tsoapa nematzagakwunikwuse oosoo tookwa gi e nekwohonekwu. ");
INSERT INTO paoNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Oosoo besa e tummatza'e. ");
INSERT INTO paoNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Tooe haga tooe ka e naka'oedyukuna tooe umu nuka tummatzidu bamagase sapa nu mu sukwe sootuhi meakwu.” ");
INSERT INTO paoNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Soo Te Pabe'e yise ka mu tunakatzimodu meeoo netamma, “Gi besa soo tooe haga tooe ka nuga dooamu ka gi togekoo podo mu tunedyooena. Nu sakwa puu sukwe badya'e, gi yise ka gi togekoo mu Te Naa dooamu tunedyooe. ");
INSERT INTO paoNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","48","Nu sakwa e mi sukwe tseka'a, gi ka suda namanedu mahane. Besa'yoo tooe ka sumuoosoo mi-geana Te Naa-baa petugase, gi waahoo mi-geana, ka niwunu-kwitoo wue. Nu sakwa e kuku sukwe tseka'agwuuni, gi ka gi togekoo podo mea. Besa'yoo tooe ka sumuoosoo kuku-gana ka Te Naa-baa petugase, gi waahoo kuku-gana ka niwunu-kwitoo wue. Nu sakwa tuwow e pooe sukwe tsepata, gi ka gi togekoo poonnena. Besa'yoo tooe ka sumuoosoo pooegeana ka Te Naa-baa petugase, gi waahoo pooegeana niwunu-kwitoo wue, owetuoo ooosapa nidabedu gi nimakwudu. Mu wo'abe yise ooosapa mu tookoo soo'adape. ");
INSERT INTO paoNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","No'yoona oowetuoo numu oo wumadooa. ");
INSERT INTO paoNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Ongabe puu ka tukapu besa makamakute, ka gi onga-gana gi hee besa kamma. Mu sakwa ongabe-kwa'ne'yoo. Mu sakwa besa nanapua'ana, besa sokwamamo.” ");
INSERT INTO paoNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","O'no yise ka tubewa, Judea mee naneadu-kwi'yoona, soo Te Pabe'e ewow numu tunedyooe'e. Ka hooodu, Jordan mee naneadu baa mangega. ");
INSERT INTO paoNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ewa'yoo tunesootzemadu numu, Pharisee mee nananeadu oo-baa petuse, meeoo oo tubenga, “Besa'yoo haa'a soo numu ka nanodukwadoose, yise napoonnekwunina?” ");
INSERT INTO paoNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Soo Te Pabe'e mee mu netamma, “Ha'yoo soo Moses ka mooo'asoo te tuukwe?” ");
INSERT INTO paoNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Umu mee oo nanekwege'a, “Ka mooo'asoo soo Moses mee tubo'o, tamme ka napoonnekwunina sakwa tubope-ma napoonnekwuni.” ");
INSERT INTO paoNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Soo Te Pabe'e yise meeoo mu netamma, “Te Naa gi meeoo te netamma. Pana mu gi Te Naa nakabetseana soo Moses yise ekow mu tuukwe. ");
INSERT INTO paoNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","O'nosoo, soo Te Naa ka numu pudu manumudoose meeoo, ‘Nu ka nana noko mogo'ne manumudoopu. ");
INSERT INTO paoNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Umu yise nanodukwadoose, soo nana tu naanapua'a-baa'yoona nomea. Tu nodukwa-no yise nobe-ga'yoo. ");
INSERT INTO paoNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Umu yise sumuoosoo numu-wa'ne'yoo. Gi waahoo numu-wa'ne'yoo.’ ");
INSERT INTO paoNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Soo Te Naa mee'e te netamma, ‘Ka nodukwadoose gi napoonnekwunipana.’ ” ");
INSERT INTO paoNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Ka nobe-kwi petugase, mu oo nakatzimodu ka a napoonnekwunipu-witu mee ka Te Pabe'e tubenga. ");
INSERT INTO paoNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","12","Soo Te Pabe'e mee mu nanekwegea, “Mu nanodukwa sakwa mesoo napoonnekwunipana, ka kumma'akoosoo nodukwadoose ma'emukwa.” ");
INSERT INTO paoNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Mu numu yise tu doodooamu ka Te Pabe'e-baa hane petudyakwe, umu oo nanesootuhiku tuunguna. Mu tunakatzimodu ka mu numu poonnena mu nesagwikute ka oo mu manakwe. ");
INSERT INTO paoNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Soo Te Pabe'e ka mu poonnena meeoo mu netamma, “Gi mu numu tu dooamu hane petudu tayapana, gi mu nesagwikupana. Nu mu dooake sootuhise, umu yise ka Te Naa-baatoo meakwu.” ");
INSERT INTO paoNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Soo Te Pabe'e yise meeoo unakwe, “Nu kaaheno mu tuukwekwu, mu mooe'ugasoo, nanekwahakwu, tutugutsekoo dooake-wa'ne'yookwu gi ma'emukwadu. O'no yise mu ka Te Naa-baa petugakwu.” ");
INSERT INTO paoNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Soo Te Pabe'e yise mu doodooake tzahedana, mu nanesootuhikuna, mu sootuhise umu-baa'yoona mea. ");
INSERT INTO paoNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Sumu'yoo nana ka Te Pabe'e-baa tanomane petugase oo-kobena meatzedose ka Te Pabe'e meeoo netamma, “U tubetse besa'yoo nana, ha'oo besa sakwa tuwow nu manese namagwetzoi?” mee. ");
INSERT INTO paoNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Soo Te Pabe'e yise meeoo oo nanekwegea, “U haa'a mee e netamma, u besa'yoo? Gi haga besa'yoo, Te Naa suu'mu besa'yoo. ");
INSERT INTO paoNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","U oo sopedakwatoo ka Te Naa tamme tuukwepu; gi numu batsapana, gi numu nowuakupana, gi tuduhapana, gi esayipana numu mane-witu, besa tu naa noko tu pea sooyugwena.” ");
INSERT INTO paoNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Soo nana yise meeoo oo netamma, “Mooasoo nu tuha'yoona meeoo na'unnedu nakabetseakena.” ");
INSERT INTO paoNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Soo Te Pabe'e yise, ka ooka besa soobedyana mee oo netamma, “U sakwa no'oko u hemma-ma tumuse, ka u nahemena ka mu tutuha manedu hanekuse, o'no yise u ewow hee-gakwu, ka Te Naa-baa'yoona. O'no u yise nuka nakatzinnummekwu.” ");
INSERT INTO paoNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Soo nana ka oo nakase suda soonamme ka ewow hee-gana. ");
INSERT INTO paoNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Ka nana mease, soo Te Pabe'e ka mu tunakatzimodu meeoo tuukwe, “Soo ewow hee-ga'yoo numu unusoo manena namagwetzoikwu.” ");
INSERT INTO paoNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","25","Mu tunakatzimodu ka Te Pabe'e nakase punno'o meeoo tutubenga, “Hownnekoo soo numu yise mesoo namagwetzoa'e?” Pana soo Te Pabe'e meeoo unakwe, “Soo numu gi puusoo namagwetzoi-wa'ne'yoo. Soo Te Naa suu'mu mu magwetzoikwu.” ");
INSERT INTO paoNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Mu tunakatzimodu mee oo netamma, “Kadoo'oo haga numu magwetzoi-wa'ne tabu'a.” ");
INSERT INTO paoNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Soo Te Pabe'e meeoo mu netamma, “Aha. Te Naa suu'mu numu magwetzoidu.” ");
INSERT INTO paoNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Soo Peter meeoo ka Te Pabe'e netamma, “Mooasoo numme no'oko ne hemma matusookwunikese, nanesootuhi mane.” ");
INSERT INTO paoNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","30","Soo Te Pabe'e yise meeoo mu netamma, “Tooe haga tooe tu nobe ma'wukadu, tu nanumu, no'oko hemma tu hee-gana, tu dooamu, tu tubewabe, ka nuka nagena ewowsoo besa no'obatusoo nasootuhikwu, meno'o manekwana. Mu nasootuhikwuna gi moobegwagakwu. ");
INSERT INTO paoNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Umu yaa'a teepu-koobatu meno'o numu moohedu, saa'a ka Te Naa-baa'yoona gi hee manepunnekwu. Umu meno'o gi mamaawa'ne'yoo, yaa'a teepu-kooba manepunnedu ka Te Naa-baa'yoona numu moohedooa.” ");
INSERT INTO paoNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Soo Jesus yise ka Jerusalem-witoo mea. Mu oo nakatzimodu mu numu-no nakasuipana oo nageka. Soo Te Pabe'e yise ka mu tunakatzimodu suu'mu watze tuukwe. ");
INSERT INTO paoNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Jerusalem-wi te petugase, mu numu-kobenatu yadooadu nu-ma tzakadukwu, yise umu wawa'a tibo-matoo e tzakakakwu, yise umu nuka batsa tuungukwu. ");
INSERT INTO paoNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Umu tibo'o yise e kobitoo toohena, e wupagetana, yise e batsakwu. Pahe tabe mease nu yise saa'a tuusootabuedooa.” ");
INSERT INTO paoNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Mu nawanga'a James-no John ka Te Pabe'e-baa petu, yise meeoo oo netamma, “U haa'a sakwa ne tummatzi?” ");
INSERT INTO paoNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Soo Te Pabe'e yise meeoo mu tubenga, “Hownnekoo sakwa nu mu tummatzi? Hemma mu soogwina?” ");
INSERT INTO paoNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Umu meeoo oo nanekwegea, “U ka pudusoo numu-kobena katukwuse, how sakwa numme ka u-baa sapa aatana?” ");
INSERT INTO paoNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Soo Te Pabe'e meeoo mu nanekwegea, “Nu nabatsase, namayodase yise saa'a ka numu-kobena katudooa. Mu haa'a punno'o ooosoo?” ");
INSERT INTO paoNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Mu waha'yoo ka Te Pabe'e meeoo netamma, “Numme sakwa punno'o ooosoo mesoo mane.” Soo Te Pabe'e mu nanekwegea mee, “Aha. Mu punno'o nu-kwa'nekoosoo wumakwu nu-koobatoo nabatsase, saa'a namayodakwu. ");
INSERT INTO paoNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Gi nu ka mu numu-kobena mu aata tuungu-wa'ne'yoo. Mooasoo soo Te Naa oo nemamakwupuna mu oo sopedakwatoo.” ");
INSERT INTO paoNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","No'yoona mu oo nakatzimodu mu nakase, ka James noko John unu sutakute. ");
INSERT INTO paoNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","45","Soo Te Pabe'e yise meeoo mu netamma, “Gi umu wakwawa'amu-kobena katudu-kwa'ne paba nasooyugwepana. Mu sakwa no'oko numu tummatzimo. Nu ooonne'yoo, ka yaa petuse, nu no'oko ka mu numu tummatza'e. Nu mu numu-koobatoo nabatsakwu, o'no saa'a mu numu gwetzoidooa.” ");
INSERT INTO paoNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Soo Te Pabe'e ka pumme nakatzimodu-no ka Jericho mee naneadu-too meakwu. Ewa'yoo mu numu umu-no oo-toogoo me'a. Ooosapa po kumabu katudu, soo nana gi tubootabuedu, Bartimaeus mee naneadu, nonotsu mu numu pu-moopaa meadu meeoo netammakayakwe, “E tummatzi.” ");
INSERT INTO paoNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Yise oosoo ka Te Pabe'e kemmana nakase, meeoo ka Te Pabe'e netamma, “U sakwa e sootuhi,” mee. ");
INSERT INTO paoNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Umu numu ewana oo nesagwikute, “Gi unnepana,” mee oo netamma. Oosoo ka Te Pabe'e pabasoo yadooe, “U sakwa e sootuhi.” ");
INSERT INTO paoNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Soo Te Pabe'e yise umu pumme nakatzimodu mee netamma, “Ka gi tubootabuedu, nu-baatoo bike.” Umu tunakatzimodu ka gi tubootabuedu nana mee netamma, “Besa nasooyugwese, yotse, soo Te Pabe'e yaa meno'o, u ba'e, mee.” ");
INSERT INTO paoNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Soo gi tubootabuedu nana yise tu naga'apu mawunise yotsehoo, yise ka Te Pabe'e-matoo takwue. ");
INSERT INTO paoNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Soo Te Pabe'e yise meeoo, “Hownnekoo sakwa nu u tummatzi?” Soo gi tubootabuedu meeoo, “Nu gi tubootabuena, enatu e poonnekwuna sookwa'e.” Soo Te Pabe'e yise mee oo netamma, ");
INSERT INTO paoNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","“Unudea, u ka e togesobedyase suu'mu, besa manekwu.” Oosoo gi tubootabuedu nana yise yaatu besa poonne manese, ka podo ka Te Pabe'e tuyohoka. ");
INSERT INTO paoNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Soo Te Pabe'e ka umu pumme nakatzimodu-no ka Jerusalem mee naneadu-kwitoo meana, ka Bethphage, noko Bethany mee nananeadu naamootoo mease, ka giba Olive mee naneadu tzage'e petuga. O'no soo Te Pabe'e waahoo umu pumme nakatzimodu-matu ");
INSERT INTO paoNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","meeoo netamma, “Ka Bethpage-witoo memeakwate. Onoko mu sumuoo tzagaze natzakunadu mayukwu, gisoo pukooba nakatudu. Oo tzadopase punowsoo saa'a oo wetzakake.” ");
INSERT INTO paoNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ka mu numu mumme tubenga, “How mu manakwe?” mee saa'a mu nekwegea, “Soo Te Pabe'e yabesoo a soogwina saa'a yise punowsoo a makodyukudooa.” ");
INSERT INTO paoNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Umu ka memease, ka tzagaze, ka nobe-kobena oo natzaku oo mayu petugase, oo tzadoopahoo. ");
INSERT INTO paoNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Mu numu o konnodu mee mu tubenga, “How yise manena mu a tzadoopa?” ");
INSERT INTO paoNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Umu ka Te Pabe'e unnena mu tuukwese, umu yise, “Muusoo too'e,” mee mu netamma. ");
INSERT INTO paoNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Mu waha'yoo naana yise ka tzagaze ka Te Pabe'e-baatoo tzakakase, wega oo-kooba hanese, soo Te Pabe'e ka mu wega-kooba katuno'o. ");
INSERT INTO paoNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Ewa'yoo numu tu wega ka po-kooba wupatzeta, susumudu numu punno'o sunngabe ma'na hanese, yise ka Te Pabe'e ooka podokute. ");
INSERT INTO paoNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ewa'yoo numu oo kumi meana ka Te Pabe'e nesootuhino'o, besa sokwamana, papaba apegeana, “U yow, U Ne Tubetse Pabe'e, no'oko numu magwetzoidu. ");
INSERT INTO paoNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","U numme-kooba katudu ka ne namooatupu David-wa'ne'yoo, numme besa sokwama soo Te Naa ka numme-matoo u tayase, soo Te Naa u tubetse sootuhikwu. Soo Te Naa saa'a puusoo te magwetzoikwu.” ");
INSERT INTO paoNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Soo Te Pabe'e Jerusalem-wi petugase, ka nanesootuhi nobe-kwitoo meahoo, no'oko hemma oetu besa sootse'ma, pana ka mooasoo unu yongona oo mane-gapu umu tunakatzimodu-no Bethany-witoo mea'a. ");
INSERT INTO paoNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","13","Ka ookow mooo'a awamooa, soo Te Pabe'e ka umu tunakatzimodu-no Bethany-wi'yoona mea'a. Oosoo ka meana, ka sunngabe Fig mee naneadu poonnese, oo-matoo mea, ka tzuaya'ena. Ka tamano, ka sunngabe pooe naa-kwi oo manepetuse, gisoo oo pooetoo'a oo mayu petu. Unu sunngabe naka-ga'yoo suu'mu. ");
INSERT INTO paoNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Soo Te Pabe'e yise ka sunngabe meeoo netamma, “Gi gea hannano'o u pooetooa-wa'ne'yoo.” Umu oo nakatzimodu oo naka. ");
INSERT INTO paoNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Umu Te Pabe'e ka pumme nakatzimodu-no ka Jerusalem-witoo mea'a, yise ka pabow nananesootuhi nobe tzage'e kodyu petuga. Mu weehoo-ma tumudu poonne. Tu hemma tsanabedona, tu seepu-ma tumugonno tuwazoo. Soo Te Pabe'e yise ka hemma pukooba mu tuoonana manapow, oo kadunoo tuwazoo, yise oekoo mu numu matzayubow. ");
INSERT INTO paoNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Soo Te Pabe'e meeoo mu netamma, “Mu ka nobe'ana gi ma-toogoo meapana. Esoo pukwi'yoona tu nananesootuhina.” ");
INSERT INTO paoNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Soo Te Pabe'e yise mee mu netamma, “O'nosoo soo Te Naa unnepu mee na'unakwe, ‘E nobe pukwi'yoona no'obatusoo numu nanesootuhina.’ Meno'o mu yise nanatuduha mi'yoona.” ");
INSERT INTO paoNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Soo numu pabe'e, ka mu numu-koobatoo yadooadu-no ka Te Pabe'e manena sopedakwatoose, oo-ma nakasua'e ka Te Pabe'e meeoo unakwe, yise oo nebatsa, ka ewow numu ooka nakatoge'yookute. ");
INSERT INTO paoNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ka yongo-nakwa, soo Te Pabe'e umu pumme nakatzimodu-no punowsoo kodyuka, ka Bethany-wi tooibodona. ");
INSERT INTO paoNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Tu pudu taba tsebooegena, soo Te Pabe'e ka mu tunakatzimodu-no Jerusalem-witoo mea'a. Ka sunngabe mooasoo pasapu oo poonne. ");
INSERT INTO paoNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Soo Peter ka Te Pabe'e unnena soomayuna mee oo netamma, “U ka etze'e ka sunngabe pasa tuungu, oosoo yise meno'o pasapu,” mee'e. ");
INSERT INTO paoNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","24","Soo Te Pabe'e yise meeoo mu netamma, “Aha. Mu ekow sooma'yu. Mu sakwa ka Te Naa naka'oedyukuse nanesootuhi. U ka tunaka'oedyukuna, u ka giba ka banunadu-naamookwitoo nooyooa tuunguse, oosoo oo-toogoo manikwu. ");
INSERT INTO paoNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","26","Ka nanesootuhi manese, mu sakwa ka mumme suda tumatugukudu soomu'wase. O'no Te Naa yise punno'o ka suda mu tumatuguna soomu'wakwu.” ");
INSERT INTO paoNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Ka Jerusalem-witoosoo kodyuse soo Te Pabe'e ka mu tunakatzimodu-no, ka nanesootuhi nobe-kobenakwi soo Te Pabe'e nanapedo meowbodote. Mu Jew numu tutunehanedu ka Te Pabe'e-baa petuse ");
INSERT INTO paoNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","mee oo tubenga, “Haga pooha tunetamma-toohakwi u yoo manakwe?” ");
INSERT INTO paoNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Soo Te Pabe'e mu nanekwegea, “Nu ka John-witu mu mooe tuukwekwu. Mu ka kaaheno e nanekwegease o'no yise saa'a nu punno'o haga pooha-toohakwi 'yoo nu e manena mu tuukwekwu. ");
INSERT INTO paoNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Haga ka John meeoo netammana oosoo numu baa-wi matzaka, soo Te Naa God, pute oosoo puusoo oo sukwe manakwe?” ");
INSERT INTO paoNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Mu tutunehanedu yise puusoo nanano apegeagonnose, mee unakwe, “Tamme ka mee'e unnese soo Te Naa God ka John meeoo netamma, soo Te Pabe'e meeoo te tubengakwu, ‘How yise manena mu ka John gi nakabetsea?’ ");
INSERT INTO paoNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Pana, ‘Soo John puusoo oo manakwe,’ mee te unnese mu numu punno'o te kusekakwu, soo John Te Naa nayadooawabe mee oo netammana, oo naka'oedyukuna.” ");
INSERT INTO paoNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Umu yise mee ka Te Pabe'e nanekwegea, “Numme gi oo sopedakwatoo.” Soo Te Pabe'e yise mee mu netamma, “Nu punno'o gi mu tuukwe-wa'ne'yoo ka haga pooha-toohakwi, e pooha ma'na'wena.” ");
INSERT INTO paoNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Soo Te Pabe'e ka mu numu-koobatoo yadooadu mee natugwenga, “Sumu'yoo nana puu tumasu'a. Soo nana tumasuase, oo na'oonnakwi koodua-doose, ka tu tumasuana toogoo tuubane nobe-too. Ekow nobe-kwikoo hoobadookwuse. Oosoo tuwazoo tueya'e nobe-toose, ka tumasuape-matu mu numu tuukwena ka tubewabe mu mabetseakwu-kwitoo, yise kwinga'a mea. ");
INSERT INTO paoNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Ka tu nayasa-wi oo manepetuse, oosoo sumuoo numu ka tabewabe-witoo taya, pumme naamookwitoo oo tupooegea tuunguna. ");
INSERT INTO paoNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Umu ka nana-ma tzakaduse oo mooedyakwehoo, yise oo taya, gi oo pooe makana. ");
INSERT INTO paoNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Soo tumasuadu yise punowsoo kumma'akoosoo pumme tummatzidu taya, umu numu yise suda manakwe, oo kwo-makoo oo wupageta gi hemma oo hanekute. ");
INSERT INTO paoNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","O'no yise soo tumasuadu ka kumma'akoosoo pumme tummatzidu taya tuwazoo. Umu yise oo patsow. Soo tumasuadu yise ewowsoo pumme tutummatzidu oetoo tayayakwe. Susumudu mu tutummatzidu oetoo natayadu nuupagetayakwe yise umu-matu punno'o nago'e. ");
INSERT INTO paoNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Nakwitoo ka tu besaa tooa tu nabenina umu-matoo taya mee tusooyugwena, ‘Umu ka e besaa tooa naka'oedyukuna gi how a yugwe-wa'ne'yoo.’ ");
INSERT INTO paoNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Pana mu numu meeoo nananetamma, ‘Esoo ka tumasuadu besaa tooa. Tamme ka a batsowse, ka oo teepu manikwu.’ ");
INSERT INTO paoNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Umu yise oo-ma tzakaduse oo batsase ka tumasuape-kwitoo oo wuwazuhoo.” ");
INSERT INTO paoNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Soo Te Pabe'e yise meeoo mu netamma, “Mu oo sopedakwatoo, soo tumasuadu sutakwu ka kodyu petuse, ka umu pumme tutummatzidu nagoese. O'no yise oosoo ka tabewabe kumma'akoosoo numu hane tuungukwu.” ");
INSERT INTO paoNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","11","Soo Te Pabe'e yise mee mu netamma, “Mu sakwa oo sopedakwadoo, ka o'nosoo Te Naa yadooawabe mee nu-witu botugu, ‘Mu tupe nobe-tootu tumoodyipu tupe tookwa besa'yoo tupe, ka penakwa mu nobe namadabue-kwi oosoo tupe unu nadatzenga petu. Soo Te Naa yoo tumadabue, tamme yise tubetse besa sokwama ma-koobatoo.’ ” ");
INSERT INTO paoNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Mu numu-koobatoo yadooadu ka Te Pabe'e too'e nekwutuma, ka pukwitu oo sopedakwatoose, umu ka mu numu-ma su'ina, sukwe me'a. ");
INSERT INTO paoNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Mu numu-koobatoo yadooadu-matu Pharisee, mu wakwawa'a numu pabe'e pupua'amu-no, ka Te Pabe'e-matoo nataya. Yow umuoo numu ka Te Pabe'e unu nesoonahadyakwedu. ");
INSERT INTO paoNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Umu ka Te Pabe'e meeoo netamma, “U tubetse besa'yoona, ka umu numu Te Naa-witu besa tunedyoo'e. U gi numu tutzeadu; yise gi tuwazoo u numu nesootzemadu. How haa'a sakwa tamme, ka mu wakwawa'a numu pabe'e tumanagaku?” ");
INSERT INTO paoNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Soo Jesus mu sopedakwatoo ka pumme mu nesoonahadyakwe yise meeoo mu netamma, “Gi sakwa mu e nesoonahadyakwepana, ka mu tumanagapu-matu e tzapoonneku.” ");
INSERT INTO paoNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Umu yise oo tzapoonnese soo Te Pabe'e yise meeoo mu netamma, “Haga mama namanaka, yise haga naneana mama nabo'o?” mee. Umu mee oo netamma, “Soo mu wakwawa'a pabe'e mama.” ");
INSERT INTO paoNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Soo Te Pabe'e yise meeoo mu netamma, “Tamme sakwa mu wakwawa'a numu pabe'e gea, esoo umuoo nanumu tumadabuena. Tamme sakwa ka Te Naa tumadabuena, ka Te Naasoo gea.” Mu numu besa o sukwe poo'nepebu'ahoo. ");
INSERT INTO paoNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Mu sumubaatu nanesootuhidu numu, Sadducee mee nananeadu, ka Te Pabe'e-baa petuga. Umu Sadducee meeoo nananesootuhidu, soo numu ka ya'ese sumu tammesoo me'adu. ");
INSERT INTO paoNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Umu meeoo ka Te Pabe'e tuukwe, “O'nosoo ka Moses tunetammapu umu mayohodu, ka tu pabe'e gi dooamu-gakoo kadoo'oo oo manese, soo penakwatu oo wannga'a sakwa oo nodukwadoose, tu pabe'e dooamu-dooku. ");
INSERT INTO paoNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Natakwatsukwe'yoo (7) mu nanakwanga'amu. Oosoo mu tubetse pabe'e ka ekow mogo'ne mooe nodukwa-ga'yoo. Ka tu mooe kooma kadoo manese, gi oo-makoo dooamu-ga'yoo. ");
INSERT INTO paoNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ka oo pabe'e ya'ese, oo wannga'a koomadoo. Ooka tuwazoo ya'ese, gisoo tuwow oo-makoo dooamu-ga'yoo. ");
INSERT INTO paoNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Umuoo natakwatsukwuoo (7) naana esoo mogo'ne nanasusu'mu mu koomadookese, gisoo umu-makoo dooamu-gana yise punno'o kadoo 'mane. ");
INSERT INTO paoNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Esoo mogo'ne yise ka saa'a namayodase haga kooma-gakwu? Mu no'yoona natakwatsukwu'yoo (7) nanakwannga'amu oo nodukwa-gakena,” mee'e umu oo nesootzemana unakwe. ");
INSERT INTO paoNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Soo Te Pabe'e meeoo mu Sadducee netamma, “Mu gi o nakasopedakwatoo ka Te Naa tubetse tunetammapu, tamme oo pooha netammapu. ");
INSERT INTO paoNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Mu sakwa yise ka saa'a namayodase mu toha kakasa-gakoo Te Naa tummatzidu-kwa'ne, mu gi mu nodukwa-gana soohanekwu. ");
INSERT INTO paoNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Mu ka oo naka'oedyukuna tooe mu tuise sapa. Mu saa'a gi moobegwaga gwetzoimokwu ka Te Naa-baa petugase. Te Naa tamme tunetammakuna. Moses ka pooewunudu niwunu oo-kobena wunu, soo Te Naa yise ka Moses meeoo netamma, ‘Mu Abraham, mu Isaac, mu Jacob puu tooesoo nu-matoo nanesootuha'e. Nu yise mu Nanesootuhi Naa.’ ” ");
INSERT INTO paoNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Soo Te Pabe'e yise meeoo mu netamma, “Te Naa gi mu tuipu Naa, mu togesoo modu suu'mu. Mu ka Te Naa nanetsagwayipana, mu tubetse gi oo naka'oedyukute.” ");
INSERT INTO paoNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Oosoo sumu'yoo nana mu tunedyooedu-matu, oona oo nakakwunu. Ka Te Pabe'e no'osoo pumme mu numu tubenga, besa mu nanekwege'a mee oo nakasoobedya, soo nana ka Te Pabe'e yise meeoo tubenga, “Hanotu umu-matu ka Te Naa unnepu ooonnakwa besa'yoo umu te tumayohope-matu?” ");
INSERT INTO paoNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Soo Te Pabe'e yise meeoo oo netamma, “Waha-baatu esoo na'unnepu Te Naa tamme tuukwepu besa'yoo. Mooe'ugasoo, ‘Soo Te Naa Te Manumudoopu. ");
INSERT INTO paoNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Tamme sakwa tubetse besa oo soobedya.’ ");
INSERT INTO paoNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Soo penakwatu yise meeoo. ‘Tamme sakwa mu numu besa soobedya tammesoo nasoobedya-kwa'ne.’ ” ");
INSERT INTO paoNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Soo nana meeoo oo netamma, “Besa'yoo soo nayadooape. Oosoo sumu'yoosoo, Te Naa Te Manumudoopu. O oosoo Te Naa. ");
INSERT INTO paoNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Tamme punno'o sakwa ka Te Naa besa soobedya. Soo penakwatu yise, tamme sakwa tammesoo besa nanasoobedya, tuwazoo. Umu waha'yoo no'okosoo nanesootuhipu ooonnakwa besa'yoo.” ");
INSERT INTO paoNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Soo Te Pabe'e yise mee oo netamma, “U unu soonammedu. U tookwa unu oo naka'oedyukukwu.” Umu numu yise naka nasookwise gi hemma ka Te Pabe'e tubenga mani. ");
INSERT INTO paoNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Soo Te Pabe'e yise ka pabow nanesootuhi nobe-kobena petu, umu ewa'yoo numu o manepunne. Soo Te Pabe'e yise meeoo mu numu netamma, “Umu ka Te Pabe'e tuukwewabe David-matu mee oo netamma. ");
INSERT INTO paoNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Pana soo David ka Te Naa pooha-toohakwi Te Pabe'e mee oo natuba'nga. Ka David tubotugu-kwi meeoo, ‘Soo Te Naa ka Te Pabe'e mee netammapu, “U sakwa ooosapa e tumadinakwu katu ka umu ume wohonedu e matzooekuno'otoo.” ’ ");
INSERT INTO paoNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","How yise soo David Te Pabe'e mee oo natuba'nga ka punakwana oo nanekemma sapa?” mee'e soo Te Pabe'e mu tubenga. ");
INSERT INTO paoNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","“Ka mu meeoo tuukwedu gi naka'oedyukupana, umu tu nanesookwugina sukwe soogwidu. Umu numu tunedyooedu unu besow namasoo'a. ");
INSERT INTO paoNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Ka paba tu na'ewa tukano'o, umu besa-kwi tu katuna soogwa'e. Ka nanesootuhi nobe-kwi'yoona, tuwazoo unu besa-kwi tu katuna soogwa'e. ");
INSERT INTO paoNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Umu yise ka mu pepeawabe hemma tuduhana mu nanesootuhikute. Umu sugwe'apa wuna'me mu nanesootuhikute. Umu gi besa numu tunedyooedu. Umu unu suda manedu tumatuguna, umu-matoosoo kodyukwu.” ");
INSERT INTO paoNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Soo Te Pabe'e mu owenapa mu poonne katu, ka mu numu ewana ka tumasumudoope-kwi tutuoonadyakwe. Susumudu mu naana ewow hee-ga'yoo ewa oe tutuoo'na. ");
INSERT INTO paoNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Sumu'yoo mogo'ne tu kooma kadoo'oo manekupu umu-tamme kemma. Gi hemma mapu'a, oosoo yise huutse oe tutuuoo'na. ");
INSERT INTO paoNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Soo Te Pabe'e yise mee mu tunakatzimodu netamma, “Yaa esoo mogo'ne. Esoo tu penebetu oe tuoonahoo. ");
INSERT INTO paoNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Yise mu naana gi ewa oe tutuoo'na ka a namasumutoo-kwi, tooe ewa oo hee-gapana. Esoo mogo'ne tu penebetu oe tuoonahoo. Gi haa'nokoo oe tuoona, pana a besana puma mu gwetzoina mee nu.” ");
INSERT INTO paoNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Ka nanesootuhi nobe-kwi'yoona, sumu'yoo mu tunakatzimodu-matu ka Te Pabe'e meeoo netamma, “Esoo nanesootuhi nobe tupe noko namadabuepu-ga'yoo. Mu yaatu tupe papaba'yoo. Esoo nanesootuhi nobe besa tabu'a.” ");
INSERT INTO paoNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Soo Te Pabe'e meeoo oo netamma, “Esoo nobe besa'yoo pana te wokwohomu no'oko a wuyoomedakwunikwu.” ");
INSERT INTO paoNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Umu yise ka tuutsekoo giba-ma, Olive mee naneadu-kwitoo mease o aata'a, ka nanesootuhi nobe poonne. Peter, James, John, Andrew yise mee oo watse tubenga. ");
INSERT INTO paoNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“How sakwa tamme oo sopedakwatoo tabua, ka nobe nuudyoomedakwuna? Hee te tzapoonnekukwu hannano'o oo manikwuna?” ");
INSERT INTO paoNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","6","Soo Te Pabe'e meeoo mu nanekwege'a, “Ewa'yoo numu meeoo naneyugwedu, yow numme Te Pabe'e. Nu gi mu esayaedu-matu, meeoo soo esayaedu mu tuukwekwu. Ewa'yoo mu numu nanemooagakwu. Gi mu naka'oedyukupana. ");
INSERT INTO paoNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Tooe hanotu tooe mu numu mesoo nanago'e. Gi saa'a su'ipana. Gi soo te teepu suda mane-wa'ne'yoo, gi meeoo hemma sooyugwepana. ");
INSERT INTO paoNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Mu numu yise nanano ewa nanagoekwu. Tooe hanotu tooe saa'a, soo te teepu yutsungadooa. Mu numu saa'a tseagoedooa. Gi besow saa'a hemma mu poonnedooa.” ");
INSERT INTO paoNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Soo Te Pabe'e yise mee mu netamma, “Mu sakwa namasootzema. Mu sumuna nahemase, mu nanehanedooa. Mu saa'a nuupagetadooa. Mu gi e naka'oedyukudu saa'a gi mu petzabedooa. Mu yise nuga besa unnepu mu tuukwedooa. ");
INSERT INTO paoNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","No'obatusoo mu numu saa'a e unnepu nakadooa. ");
INSERT INTO paoNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Mu ka nakwutumase, gi suda oo soonamekupana ka hayoo mu unnekwuna. Soo Te Naa Besa Pooha ooka mada'e. ");
INSERT INTO paoNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","13","Ewa'yoo mu numu gi e petzabedooa, mu nananumudooe suda mu matugudooa, yise mu goedooa saa'a. Ka umu gi e soo'oedyukudu, gi mumme numu petzabedu, gi e naka'oedyukudu, gi e ma'wukadu, nu magwetzoikwu. ");
INSERT INTO paoNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Tooe hemma tooe suta'yoo ka nanesootuhi nobe-kobena natzekwunukukwu. O'no sakwa mu ka oo poonnese, Judea-wi'yoona yabesoo mea'a. ");
INSERT INTO paoNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Oosoo tu nobe-kobena wununnummedu sakwa gi tu nobe-kwitu hemma gwuupana, yabesoo meeow. ");
INSERT INTO paoNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Soo tubewabe-kwitu hemma how yugwewunudu sakwa punno'o gi hemma gwuupana, gi tu nobe-kwitoo kodyupana, yabesoo meeow. ");
INSERT INTO paoNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Ka yabesoo mea'akwuse, mu koheadu-kwi gi besa, ka mu sutuba mea'akwuse mu oonga'a petzekudu punno'o. ");
INSERT INTO paoNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Umu sakwa nanesootuhi gi sakwa tommo hee oo suda manepana. ");
INSERT INTO paoNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Esoo gi besa a namanekwuna tubetse unu suda, gi hannano'o namanedu ka teepu namadabuese. ");
INSERT INTO paoNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Te Naa yise ka umu tu tutzeanana sootuhikwu, ka gi oo tzadyoo'ikuna gi haga namagwetzo'i-wa'ne'yoo. ");
INSERT INTO paoNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Tooe haga tooe sumuna meeoo mu tuukwekwu, ‘Soo Te Pabe'e mooasoo kodyu petu.’ Gi oo naka oedyukupana. ");
INSERT INTO paoNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Ewa tuwazoo na'esagoekwu, ‘Nu Yow Mu Pabe'e mee na'unnekwu.’ Ewasoo mu numu moohedu numu nemooagayakwe. Nanasookwugi hemma mu tzapoonnekukwu, tooe hemma tooe pooha mahanekwu, ka umu e dooamu too'e nemooagana. ");
INSERT INTO paoNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Mooasoo nu mu tuukwepu. Ooonne'yoona sakwa mu namasootzemapunne. ");
INSERT INTO paoNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","O'no ka gi hemma besa manekwuse, soo taba toganohookwu, soo muha punno'o. ");
INSERT INTO paoNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Mu paatoozooba punno'o sawedyikwu. ");
INSERT INTO paoNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","No'yoona mu numu punno'o ka koomeba-nagakoo e pooha kodyu petukwuna poonnekwu. ");
INSERT INTO paoNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Umu toha kakasa-ga'yoo e tutummatzikwutu, tooe hanotu tooe ka yaa teepu-kooba'yoona, mu e nanumu nu-baa hanepetukwu. ");
INSERT INTO paoNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Ka sunngabe pooedooase, mu meeoo sokwamadooa, tamme tookwa tamatsebooe. ");
INSERT INTO paoNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Ka gi besa hemma manekese, mu yise oo sopedakwadookwu, nu tookwa pudusoo kodyu petukwu. ");
INSERT INTO paoNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Susumudu mu numu-matu ka hemma oo manedu poonnekwu gisoo ya'ena. ");
INSERT INTO paoNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Nuga unnepu besa na'unnedu, gi atasoo naneyugwe-wa'ne'yoo. ");
INSERT INTO paoNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Ka hannano'o oe e petuookwuna manepetuse, gi haga ka teepu-koobatu oo sopedakwatoo. Mu toogoopatu Te Naa tutummatzidu puu gi, nu punno'o gi. Te Naa suu'mu oo sopedakwadoopunne ka hannano'o e petuookwuna. ");
INSERT INTO paoNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Mu sakwa ooosapa namasootzemapunne. ");
INSERT INTO paoNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Nu-kwa'nesoo, sumu'yoo numu puu ka meakwuse, ka hemma how pumme yugwekudu hemma nemanekuga. Ka tu'eyaedu meeoo netamma, ‘Gi u'wepana.’ ");
INSERT INTO paoNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","37","Mu sakwa nonotsu tabeno nuummabetsabena. Tooe hannano'o tooe nu kemmowgena, yongona, togano, awamooasoo. Nu sumuna gi mu nuummabetsape mu mayu petukwu.” ");
INSERT INTO paoNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Mooa yongona oetu, o'nosoo te manena te natzama'wukwuna soomayuna, yise ewa tukakwu, ka Gi Namayuadu Tukaba tukakwu. Soo Jew numu tutunehanedu ka Te Pabe'e watze nesootze'ma mee yise, “How sakwa tamme ka Jesus watze tzakadu tabuase, oo batsa? ");
INSERT INTO paoNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Tamme sakwa gi numu poonnena oo batsapana, mu numu tamme-no nagoedooa.” ");
INSERT INTO paoNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Soo Te Pabe'e ka Bethany-wi ka Simon Tookoo Pehe mee naneadu nobe-kwi. Mu tukawunu, sumu'yoo mogo'ne oe petuoo. Ka tupe osa-witu ka besa kwanadu nakwana'a gwuuna. Ka osa tsabadowse, ka Te Pabe'e kwo-kooba oo tuoonahoo. ");
INSERT INTO paoNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","5","Susumudu mu Te Pabe'e-batu ka mogo'ne manena nesootu'adya'e, “Oosoo sakwa gi oo nahadyagwepana ka besa kwanadu nakwana'a oosoo ewa nanenagadu. Oosoo sakwa oo-ma tumuse mu tutuha manedu namadea.” ");
INSERT INTO paoNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Soo Te Pabe'e yise meeoo mu netamma, “A tsasoopedya. Gi a nesootu'adya'epana. Esoo mogo'ne besa manakwe. ");
INSERT INTO paoNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Mu tutuha manedu tooe hannano'o pana ooosapa mu-no'yookwu, pana nu gi ooosapa mu-no'yookwu. ");
INSERT INTO paoNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Soo mogo'ne manena dea'a, e natugukwu-kwitoo a natumayohona. ");
INSERT INTO paoNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Tooe hano tooe ka teepu kaa'no, ka besa nayadooadu-kwi esoo mogo'ne manepu saa'a nanatugwengadooa. Oo-makoo tamme nanasoomayudooa.” ");
INSERT INTO paoNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Sumu'yoo mu Te Pabe'e nakatzimodu-matu Judas Iscariot mee naneadu ka mu Jew numu tutunehanedu-baa petuse mee mu netamma, “Nu oo sopedakwatoo ka Ne Pabe'e pukwi'yoona nu sumuna mu tuukwekwu.” ");
INSERT INTO paoNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Mu tutunehanedu besa sokwama ka oo nakase umu yise ka Judas tumasumudooku. Soo Judas yise meeoo soonamme, “Hownnekoo sakwa nu ka Te Pabe'e-matoo mu bika?” ");
INSERT INTO paoNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Yaa tabeno numme ka seepu tooa'a batsakwu, ka gi namayuadu tukaba noko oo ewa tukakwuse mu oo nakatzimodu yise ka Te Pabe'e tubenga, “Hano'yoona sakwa tamme ewa tuka?” ");
INSERT INTO paoNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Soo Te Pabe'e yise waahoo mu tunakatzimodu-matu tayase. Mee mu netamma, “Ka nana baa tzanodu mu saa'a wegeadooa. ");
INSERT INTO paoNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Mu saa'a ookow nageakadooa. Ka nobe-kwi oo egeakase oo-nosoo saa'a tzoonooahookwatese ka nana nobe-gakoo mee netamma, ‘Soo Te Pabe'e umu pumme nakatzimodu-no yaa u-baa'yoona nanesootuhi yongo tukakwu.’ ");
INSERT INTO paoNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Esoo nana nobe-ga'yoo yise mu tzapoonnekukwu, ka pa'atu nobe-kwi'yoona ka tukapu mu yonga tukakwuna mu saadooa.” ");
INSERT INTO paoNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Mu waha'yoo yise memea, ka Te Pabe'e unne-toosoo manekwuse. ");
INSERT INTO paoNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Ka tu yongose Te Pabe'e umu tunakatzimodu-no ka nobe-kwi petuga. ");
INSERT INTO paoNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Umu-no tukanasoo, Te Pabe'e mee unakwe, “Sumu'yoo mu-matu nu-no tukadu ka mu tukwutumadu nu-matoo bikekwu, umu yise e batsakwu.” ");
INSERT INTO paoNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Mu Te Pabe'e nakatzimodu oo nakase, suda nuummana, umu nanasusu'mu'yoona mee unakwe, “Nu haa'a?” ");
INSERT INTO paoNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Soo Te Pabe'e mu nekwegea, “Sumu'yoo mu-nagatu nu-no tukadu. ");
INSERT INTO paoNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Too'e soo Te Naa mooasoo, ‘U nabatsakwu,’ mee tunetammapana, saa'a oosoo umu e wohomu nu-matoo bikepu tuma'emukwana oo-matoosoo kodyukwu.” ");
INSERT INTO paoNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Mu tuka, soo Te Pabe'e tukaba gwuuhoose, oo-koobatoo nanesootuhise oo tzaboka. Yise umu tunakatzimodu hemese ooka mu tuka tuungu, mee unnena, “Esoo puu nuga tookoo-wa'ne'yoosoo.” ");
INSERT INTO paoNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Yise ka besow atsa baa yoongase oo-koobatoo nanesootuhise, ooka mu hebe tuungu. ");
INSERT INTO paoNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Soo Te Pabe'e mee'e unnena, “Esoo puu nuga puupe-wa'ne'yoosoo. Te Naa Toogoopatu besa unnena tunetammana, suda mu manepu-koobatoo e nabatsakwuse. ");
INSERT INTO paoNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Nu mu tuukwe'e nu ekow atsa baa ka yaa teepu-koobatu tubetse gi hebekwusoo, saa'a ka Te Naa ka te teepu mapudutupudoose, o'no yise nu tubetse pudutupusoo hebekwu.” ");
INSERT INTO paoNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Umu yise nanesootuhi hoobea nekwuna ka Olive mee naneadu tuutsekoo giba-matoo mea'a. ");
INSERT INTO paoNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Soo Te Pabe'e yise mee ne netamma, “Ka yaa togano suda tu namanikwuse mu e ma'wuookakwu. O'nosoo soo Te Naa yadooawabe mee'e tubotugupu, mee'e na'unakwe ka meno'o Te Pabe'e manekwuna. ‘Soo seepu takonedu nabatsahookwu, mu seepu yise nana'emota petugwahookwu.’ ");
INSERT INTO paoNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Nu saa'a e ya'ekwukoo namayodase, Galilee-witoo mu-kobenasoo meadooa. Mu saa'a, o nu-baa petugadooa.” ");
INSERT INTO paoNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Soo Peter meeoo ka Te Pabe'e netamma, “Mu u nakatzimodu sumuna u-kooba'yoona mea'akwu, nu gi umu-no meakwu.” ");
INSERT INTO paoNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Soo Te Pabe'e meeoo ka Peter netamma, “Togesoo tu toganopunne, ka tsekana kwu'a gisoo wahadooe oo yaka, u pahedooe oona numu tuukwekwu u gi e sopedakwatoo mee.” ");
INSERT INTO paoNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Soo Peter yise meeoo Te Pabe'e netamma, “Tooe umu e batsakwu mee unnepana nu gi meeoo unne-wa'ne'yoo, ka gi u-ma nasookwina.” Mu Te Pabe'e nakatzimodu no'yoona oo-wa'nesoo unakwe. ");
INSERT INTO paoNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Ka Olive namasu'a-wi petuse, Gethsemane mee naneadu, soo Te Pabe'e mu tunakatzimodu mee netamma, “Yowsoo aatapunne. Nu nanesootuhigakwu.” ");
INSERT INTO paoNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Mu Peter, James, John oo-no mea'a. ");
INSERT INTO paoNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Soo Te Pabe'e mee mu netamma, “E pewu-kwitu tubetse suda nuumma. Mu sakwa yaahoosoo aatapunne.” ");
INSERT INTO paoNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Soo Te Pabe'e sagwane umu kwinga'atoosoo meahoose, o ka teepu-kooba meatzedose, yise nanesootuhikooha. ");
INSERT INTO paoNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","“E Naa Toogoopatu. Nuga Naa Toogoopatu. Nuka u tunetammakuse nu oo-toogoo meakwu. Ekow e pewu-kwitu suda nuummana, kadoo'oo mayugwe.” Soo Te Pabe'e ka nanesootuhimakwuse ");
INSERT INTO paoNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","tu pupua'amu utua'e mu mayu petuga. Soo Te Pabe'e mee mu netamma, “How mu tubetse unu utuigapu-ga'yoo?” Soo Te Pabe'e ka Peter meeoo netamma, “U sakwa gi uwepana.” ");
INSERT INTO paoNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","No'oko yise meeoo netamma, “Mu sakwa nanesootuhi aata o'no soo suta'yoo gi mu matzama. Mu gi oo mapu'a ka gi manese mee'e nu.” ");
INSERT INTO paoNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Soo Te Pabe'e yise penakwa nanesootuhigase ka mooe'ugasoo tu nanesootuhi-kwa'nekoosoo nanesootuhi. ");
INSERT INTO paoNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Yise tu pupua'amu-baa kodyu petuse, mu utua'e mu mayu petusoo. ");
INSERT INTO paoNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","42","Yise nanesootuhigasoo tuwazoo saa'a umu-baasoo kodyu petu, tooesoo mu utua'e. Soo Te Pabe'e yise meeoo mu netamma, “Yow haa'a mu togesoo utua'e? Yosuhoo, tamme mea'akwu, meno'o oe mani petu, nu natzakwenekwu. Yaa soo suta'yoo nana kemma.” ");
INSERT INTO paoNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","45","Ka Te Pabe'e togesoo yadoo'a, Judas petuoo, mu Jew numu tutunehanedu mu tukwutumadu taya ka Judas noko. Pabatze'ekoo koodoo'oo noko tsegesa hemana. Soo Judas, ka Te Pabe'e-matoo tooe. Soo Judas yise oo-no namitzadya'me o'no umu oo sopedakwatoo. ");
INSERT INTO paoNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Umu yise ka Te Pabe'e-ma tsakatu. ");
INSERT INTO paoNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Sumu'yoo umu Te Pabe'e nakatzimodu-matu yise tsegesa-ma ka mu Jew numu tunehanedu pabe'e tummatzidu naka wuga'akwunihoo. ");
INSERT INTO paoNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Soo Te Pabe'e yise ka mu tukwutumadu meeoo netamma, “Nu gi suda tumatugudu, gi nu naduyadu, gi tuduhadu tuwazoo. Gi sakwa mu koodoo'oo-ma e tumahepana, tsegesa-ma tuwazoo. ");
INSERT INTO paoNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Tooe ka e nanesootuhi nobe-kwikoo sapa, mu gi nu-ma tzakadupu-ga'yoo. Muusoo too'e. Mooasoo soo tubope ebeoo nabotuku, o'nosoo Te Naa tamme tuukwe-kwa'nesoo.” ");
INSERT INTO paoNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Mu Te Pabe'e nakatzimodu oo-ma su'ise, ka Te Pabe'e-baa'yoona namabetugwahoo. ");
INSERT INTO paoNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Nu ka tooebetsena, ka Te Pabe'e nagwuuhoose, naga'apu-wi wunaga'a yaahoose ka Te Pabe'e-nakwi meano'o. ");
INSERT INTO paoNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Umu tukwutumadu e naga'apu-ma tsakatu, nu yise e naga'apu makwumahoose namameow. ");
INSERT INTO paoNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Umu yise ka Te Pabe'e na'enakwakoo oo puta-ma tzakaduse, ka Jew numu pabe'e-matu oo tsakaka. Umu tutunehanedu oo nehanekwu. ");
INSERT INTO paoNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Soo Peter kwinga'a mu nakwi me'a, ka Jew numu pabe'e nobe-kobena petugase, o yooekatu. ");
INSERT INTO paoNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Soo Jew numu pabe'e ka mu tutunehanedu-no ka Te Pabe'e too'e batsakwuse, gi toge oo manena too'e nemayupana gi hemma nemama'yu. ");
INSERT INTO paoNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","57","Susumudu nanana oo manena too'e wahana sukwe esago'e. Umu too'e tuukwepana kadoo'oo hee, tubetse gi hemma nemama'yu. ");
INSERT INTO paoNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Numme meeoo oo unakwe oo naka, ‘Nu ka nobe, ka Te Naa-matoo pukwi'yoona te nanesootuhina kadoo'oo mesoo mayugwe, yise pahe tabeba-wi oo mesoo mayota.’ ” ");
INSERT INTO paoNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Mu naana gi nanakwa'nesoo unakwe. ");
INSERT INTO paoNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Soo Jew numu pabe'e umu-kobena'yoona ka Te Pabe'e tubenga, “Togesapa haa'a umu nanana meeoo u netamma?” ");
INSERT INTO paoNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Soo Te Pabe'e tubetse gi hiyoo unakwe. Soo Jew numu pabe'e yise mee oo tubenga, “U haa'a Te Pabe'e? U haa'a toogoopatu Te Naa Tooa?” ");
INSERT INTO paoNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Soo Te Pabe'e mee oo nanekwegea, “Aha, mu oe'yoopana e poonnekwu, nu Te Naa Toogoopatu-kumaba katukwu. Saa'a nu koomeba-naga petuookwu, o'no yise mu e pooha poonnekwu.” ");
INSERT INTO paoNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Soo Jew numu pabe'e yise tubetse unu sutahoose tu kwasu tsakebu'ehoo, mee mu netamma, “Oosoo suda unakwe ka Te Naa-wa'ne'yoo mee naneyugwena. Gi tamme manatusoo oetusoo wahakwutu sookwa'e. ");
INSERT INTO paoNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Mu oo naka ka suda oo unakwe mu sakwa hayoo oetu netamma. Ha'yoo mu sokwama?” Mu numu tutunehanedu mee oo netamma, “Tamme sakwa oo batsa.” ");
INSERT INTO paoNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Yise o kobitoo toohegonno, o pooe kwudumowse, oo wupageta, mee yise oo netamma, “Ne tuukwe ka pooha-gana, haga u wupageta?” Mu tutukwutumadu oo-ma tzakaduse, yise oo koba mabatseoo. ");
INSERT INTO paoNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","67","Soo Peter yise ka Jew numu tunehanedu naa nobe-kobena pedana oe yooekatu. Sumu'yoo tsuadumu ka Jew numu tunehanedu naa hemma how yugwegudu, ka Peter meeoo netamma, “U haa'a yise ka Jesus nakatzimodu-matu?” mee. ");
INSERT INTO paoNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Soo Peter mee oo nanekwegea, “Nu gi oo sopedakwatoo.” Soo Peter meeowse ka natzakwona'a kumabu wunu. ");
INSERT INTO paoNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Soo tsuadumu ka mu numu o konnodu meeoo netamma, “Esoo nana ka Jesus nakatzimodu-matu.” ");
INSERT INTO paoNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Soo Peter ka mu numu-ma unu su'ina punno'o mee oo netamma, “Gi nu.” Pudusoo mu numu o toonoobatu meeoo oo netamma, “U tookwa togesapa yow ka Jesus nakatzimodu-matu. U ka Galilee-witu.” ");
INSERT INTO paoNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Soo Peter meeoo mu netamma, “Gi nu mu numu nemooagadu, nu gi umu-matu.” ");
INSERT INTO paoNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Yise tsekana kwu'a waha yaga. Soo Peter ka Te Pabe'e pumme netammana soomayuse, suda soonammena, yagakooha. ");
INSERT INTO paoNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Awamooasoo soo mu Jew numu tutunehanedu ka Te Pabe'e batsakwu mee tunehane. Yise ka Te Pabe'e mi tzakunase, ka teepu-kooba katudu naa, Pilate mee naneadu-kobena oo tzaka petuga. ");
INSERT INTO paoNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Soo Pilate mee ka Te Pabe'e tubenga, “U haa'a ka mu Jew numu-kooba katukwudu?” Soo Te Pabe'e oo nekwege'a, “Aha, nu yow oosoo.” ");
INSERT INTO paoNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Mu Jew numu tutunehanedu mee ka Te Pabe'e netamma, “Ewa u suda manakwe.” ");
INSERT INTO paoNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Soo Pilate yise mee ka Te Pabe'e netamma, “Umu tooe hayoo tooe u netamma. U haa'a gi oo naka, o'no u gi hayoo unakwe?” ");
INSERT INTO paoNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Pana soo Te Pabe'e gisoo tuwazoo hayoo sukwe unakwe. Soo Pilate meeoo soonamme, “Nu gi o nakasopedakwatoo ha'oo mane-naga masoo gi mu nanekwege'a.” ");
INSERT INTO paoNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Nonotsa sumu tomoyina tu na'ewa tukano'o soo numu-kooba katudu sumuoo mu nakwutumadu-matu tzama'wuyakwe, ka mu numu unne-makoosoo. ");
INSERT INTO paoNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","11","Ewa'yoo mu numu ka Pilate-baa petuse, yise meeoo oo netamma, “U sakwa sumuoo mu nakwutumadu-matu tzatsebooe.” Soo Pilate oo nesopedakwatoo ka Jew tutunehanedu gi Te Pabe'e soobetzabena, ooonne'yoona yise mu numu tutunehanedu ka Te Pabe'e wutuma. Soo Pilate meeoo mu tubenga, “Mu haa'a ka Mu Pabe'e Jesus tzama'wukwu?” Mu Jew numu tutunehanedu meeoo mu numu netamma, “Mu sakwa ka Pilate ka Barabbas tzatsebooe tuungu.” Oosoo nana, Barabbas mee naneadu, tu pupuamu-no nakwutumadu. Umu ka mu Roman numu-no nanagoena, susumudu mu numu-matu nagoehoo. ");
INSERT INTO paoNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Soo Pilate mu numu mee netamma, “Esoo nana nu-baa petu, mu Jew Numu-kooba Katudu mee naneadu. How yise nu oo yugwekwu?” ");
INSERT INTO paoNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Mu numu wa'agemo'o, “Oo tzakwenne. Oo batsa.” ");
INSERT INTO paoNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Soo Pilate mee mu netamma, “How tubetse suda oosoo manakwe?” Mu numu pabasoo wa'agemo'o, “Oo batsa.” ");
INSERT INTO paoNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Soo Pilate gi oo nebatsapana, yise mu numu puusoo oo nebatsana. Soo Pilate yise ka Barabbas, ka mu tukwutumadu tzama'wu tuunguse, ka Te Pabe'e wupagetase oo batsa, pa'a oo taposa mee tunetamma. ");
INSERT INTO paoNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Mu tukwutumadu ka Te Pabe'e, ka Pilate nobe-kwitoo tzakaka. No'yoona mu tukwutumadu oe sumuhoobetu. ");
INSERT INTO paoNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Umu numu-kobena'yoona o wunaga'ayaakuhoo, mono-ga-kwi oo tzowupagaku. ");
INSERT INTO paoNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Umu oo-ma'yoona naneko'ena, oo nematzamana, mee oo netamma, “U tookwa yow Jew Numu-kooba Katudu.” ");
INSERT INTO paoNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Umu hooope-ma oo kwo-makoo oo wupagetana, oo kobitoo toohena, o-kobena meatzedona oo nasootzamekuna, oo-ma'yoona nanekoena. ");
INSERT INTO paoNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Umu Te Pabe'e nanetza'mekumakwuse, oo namasooapu-wisoo oo matabue. Umu yise ka Te Pabe'e tsakakase, oo batsakwu. ");
INSERT INTO paoNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Umu tukwutumadu ka meadabena, Simon mee naneadu wegeahoo. Mu tukwutumadu ka Simon nenoyukwe ka Te Pabe'e puma nataposakwuna oo tzano tuunguna. ");
INSERT INTO paoNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ka Te Pabe'e Numu Tzonoho mee naneadu-kwi o bi petuga. ");
INSERT INTO paoNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Yise umu atsa tutza'emukwa baa, noko natusooabe mayuana oo tooe hebe tuungu, soo Te Pabe'e yise gi oo hepe. ");
INSERT INTO paoNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","25","Yise awamooa umu oo mi-makoo pa'a oo taposa. Mu tukwutumadu yise oo kwasu nanatotsakwate. ");
INSERT INTO paoNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ka sunngabe namadabue-ma puma oo nataposana meeoo natubo'o, “Yow esoo Jew Numu-kooba Katudu.” ");
INSERT INTO paoNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","28","Waha'yoo tutuduhadu punno'o ka Te Pabe'e na'enakwana nataposa. ");
INSERT INTO paoNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Mu numu oo-moopa meagonnona, oo-ma'yoo naneko'e mee unnena, “U meeoo unnepu, u Te Naa nobe wudyoomase, pahe tabewa-wi besa oo matabuekwusoo. ");
INSERT INTO paoNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","U sakwa ka unu tumadina mama'yoo wuekese, uusoo namagwetzoi.” ");
INSERT INTO paoNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Umu numu tutunehanedu oo-ma'yoo naneko'e mee unnena, “U mu numu magwetzoise, pana yise gi hownnekoo uusoo namagwetzoi-wa'ne'yoo. ");
INSERT INTO paoNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Hownne'yoo Ne Pabe'e U? Gi hownnekoo uusoo namagwetzoi-wa'ne'yoo, ka naduyana mee unnepana. Uusoo yaa teepu-matoo wuese, numme u naka'oedyukukwu.” Umu punno'o oo na'enakwa nataposadu oo-ma'yoo naneko'e. ");
INSERT INTO paoNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Tabeno manakwana oona ka taba pahe-kwikoo tooe, ka teepu-koobakwitu toganopunne. ");
INSERT INTO paoNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Pahe-kwikoo tapuakese soo Te Pabe'e paba wa'age yadooa, “Eloi, Eloi, lama sabachthani,” mee na'unnedu, “Nuga Naa, Nuga Naa, How manena u e matusookwuna'e?” ");
INSERT INTO paoNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Umu susumudu o konnopunnedu-nagatu mee unne, “Masoo tookwa ka Elijah, o'nosoo Te Naa yadooawabe mee naneadu bidyakwe.” ");
INSERT INTO paoNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Sumu'yoo umu-nagatu yabesoo tanomanegase, yise yotsogadu wanapu, suda kammadu baa oodutsekoo hooope-ma oo tzetzabekuse, ka Te Pabe'e tzatumakute. Pana mu susumudu meeoo, “Oo tsasoopedya. Sumuna soo Elijah tamme-baa tabua petuse oo magwetzoikwu.” ");
INSERT INTO paoNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","O'no soo Te Pabe'e paba wa'agese, ya'eoo. ");
INSERT INTO paoNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","39","Soo tukwutumadu ka Te Pabe'e poonne ka oo ya'ehoose, mee yise unne, “Masoo tookwa too'e togesapa ka Te Naa Tooa'a.” Soo wunapu ka Te Naa pooha pukwi'yoona numu nanesootuhidu-makoo naamootoo natzakwenedu, ka Te Pabe'e ya'ehoose, soo wunapu pa'anakwana tubongo oo naamootoo natzagebu'ehoo. Soo teepu yutsungakoohase, mu tupe payooagonnona sawekooha. ");
INSERT INTO paoNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","41","Ewa'yoo momoko'ne punno'o onow kwina'a konnopunnena oo poonnepunne, umuoo ka Galilee-wi'yoona ka Te Pabe'e-no kemmapu oo tummatzina. Umuoo momoko'ne-nagatu pahe'yoo, Mary Magdalene, yise Mary mu James noko Joseph pea, yise tuwazoo Zebedee nodukwa. ");
INSERT INTO paoNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Soo nana, Joseph mee naneadu, Arimathea-wikoo nobe-ga'yoo, ka numu tutunehanedu-matu, unu napetzabedu. Toogoopatu Te Naa ka teepu besa oo yugwekwunu wutooedu. Ka tu pudu yongoga'a soo Joseph ka Pilate nobe-kwi petuga yise oo tubenga, “How sakwa u ka Te Pabe'e tookoo e tzagea?” ");
INSERT INTO paoNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Soo Pilate mee unakwe, “Soo Jesus haa'a tubetse ya'epu?” Soo tukwutumadu nabise, yise natubenga, “Soo Jesus tubetse ya'epu haa'a?” Soo tukwutumadu, “Aha,” mee unakwe. ");
INSERT INTO paoNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Yise ka tukwutumadu nakase, soo Pilate ka Joseph mee oo netamma, “Yise a haneka.” ");
INSERT INTO paoNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Soo Joseph yise ka Te Pabe'e tookoo tzakwekuse toha wunapu hane petuse, oe oo manobea. Tupe tuwaga-kwi oo tugu. Pabow tupe o-kobenatoo tonanooehoo. ");
INSERT INTO paoNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Umu Mary Magdalene-no, Joseph pea Mary mee naneadu, ka Te Pabe'e natugu-kwitu poonnepunne. ");
INSERT INTO paoNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","2","Sumu tabe mease, oogow mooa awamooasoo taba pudu tsebooegena, pahe'yoo momoko'ne ka Te Pabe'e natugu-kwitoo mea'a. Mary Magdalene, James pea, yise Salome-no. ");
INSERT INTO paoNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Yise ka o meadabena meeoo unnemena, “Haga yise ka pabow tupe o-kobenatu tonanooekwunikwu?” ");
INSERT INTO paoNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Yise toogooonakwatu poohwise, soo paba'yoo tupe mooasoo natonanooekwunipu. ");
INSERT INTO paoNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Oe mu tzoonooase sumu'yoo tooebetse toha kasa-ga'yoo Te Naa tutummatzi-matu, toha namasooana o katu. Mu momoko'ne oo-ma suihoo. ");
INSERT INTO paoNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Soo tooebetse mee mu netamma, “Mu sakwa gi suipana. Mu ka Te Pabe'e Nazareth-witu wate; oosoo nabatsapu, oosoo kadoo'oo yaatu; mooasoo namayodapu. Poonne yaa oo habepu-witu kadoo'oo. ");
INSERT INTO paoNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Mu sakwa mease, Te Pabe'e nakatzimodu tuukwe, Peter tuwazoo. Mooasoo soo Te Pabe'e mu mooenakwasoo Galilee-witoo meapu. Onoko yise mu oo poonnekwu, mooasoo mu natuukwepu.” ");
INSERT INTO paoNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Umu momoko'ne yise o'no tatanomanega. Gi haga umu-matu sukwe yadoo'a, umu ka suihoose. ");
INSERT INTO paoNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Soo Te Pabe'e tu ya'e-kwi'yoona namayodase, unu awamooasoo ka Mary Magdalene natzapoonneku petu, ka Mary Magdalene-nagakoo natakwatsukwuoo (7) tsoapa ta'yakwunipu-ga'yoo ka o'nosoo. ");
INSERT INTO paoNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Mary saa'a ka umu Te Pabe'e nakatzimodu-matoo meahoose yise mu tuukwe petuga, umu yise oe'yoopana sagwa'e. ");
INSERT INTO paoNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","“Te Pabe'e pudu namayoda. Nu o poonne,” mee mu netamma. Umu Te Pabe'e nakatzimodu gi oo naka'oedyukute. ");
INSERT INTO paoNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Soo Te Pabe'e atasoo tabuana, waahoo nanana nobe-kwitoo mea'a. Yise umu-no manega. ");
INSERT INTO paoNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Umu ka Te Pabe'e sopedakwatoohoose punowsoo memeahoo mu tunakatzimodu tuukwe petuga. Pana umu tunakatzimodu gi mu naka'oedyukute. ");
INSERT INTO paoNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Penakwa mu Te Pabe'e nakatzimodu tuka, soo Te Pabe'e mu natzapoonneku, mee yise mu netamma, “How manena mu gi oo naka'oedyukute, tooe ka umu numu mumme tuukwe'e sapa? ");
INSERT INTO paoNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ka tooe hano tooe yaa teepu-kooba momona, mu sakwa ka Te Naa besa yadooapu wahamo, no'obatusoo numu tuukwe. ");
INSERT INTO paoNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Mu gi tunaka'oedyukudu, ka gi tookedu goso-witoo meakwu. Umu oe tunaka'oedyukudu yise baa-wi namatzakana namagwetzoikwu. ");
INSERT INTO paoNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Umu oe unu tunaka'oedyukudu toogoopatu yadooa-masoo yadooakoohakwu. ");
INSERT INTO paoNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Tooe togogwa tuwazoo mu tokuese, tooetoo mu sutakoo hebehoose sapa, mu gi nuummaba wuma-wa'ne'yoo. Yise mu umu-kooba matuguna, mu nanesootuhikuna, mu tuoegoedu besa manekwu.” ");
INSERT INTO paoNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Soo Te Pabe'e umu-no yadooamakwuse, yise toogoopatoo tsebooegase, ka Te Naa tumadinakwa katu petuga. ");
INSERT INTO paoNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Umu Te Pabe'e nakatzimodu tooe hano tooe numu besa o unnena tuukwemo'o, nanabesa tu tumadina pumme tu sootuhipu mu tzapoonekute. Esoo toge sapa. Maa'no sapa.");
INSERT INTO paoNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","2","Ka Te Pabe'e ka yaa teepu-kooba tamme-baa'yoona oo manepu-witu. O'no Te Pabe'e nakatzimodu ka oo poonnese ne tuukwe'e. Ewa'yoo numu mooasoo ka Te Pabe'e-witu botugu. ");
INSERT INTO paoNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Nu ka no'oko umu ooka poonnedu unnepu nenayodase besa oetu nakasopedakwadoose, meno'o e pua'a Theophilos nu u-matoo tubo'o, ");
INSERT INTO paoNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","o'no saa'a u punno'o oo nakasopedakwadookwu mee nu tusooyugwe. ");
INSERT INTO paoNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Oosoo sumu'yoo wa'etse, Zachariah mee naneadu, ka mu Jew numu Abijah mee naneadu nananesootuhidu-matu. Oo nodukwa punno'o unu peawabe, Elizabeth mee naneadu, oo naa punno'o ka nanesootuhi papabe'e-matu uga. ");
INSERT INTO paoNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Umuoo uga besa'yoo numu, no'oko ka Te Naa unnepu kaaheno nakabetse'a. ");
INSERT INTO paoNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Umuoo ooosapa gi dooamu-ga'yoo soo Elizabeth ka gi dooamudoo-wa'ne'yoona. ");
INSERT INTO paoNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","9","Mu Jew numu nanesootuhi papabe'e nanahoesoo ka tu tumayohoyina, ka pabatsekoo Jew nanesootuhipe nobe-kwi'yoona mayohoyakwe. Umu ka nanesootuhi nobe-kwitoo meakwudu, ka besa kookwanadu kootugukwudu. Sumu tabenoosoo Zachariah nanetutze'a. ");
INSERT INTO paoNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Ka besa kookwanadu nakootugukwuno'o oe manepetuse, soo Zachariah ka nanesootuhi nobe-kwi egeaka. Umu numu puuwanasoo konnopunnena nanesootuhigonno. ");
INSERT INTO paoNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Zachariah yise meeoo pooha tuusoobedyakooha. Sumu'yoo umu Te Naa tutummatziwabe mu toha kakasa-ga-matu petuhoose, ka besa kookwanadu pukwikoo nakootuguna-kumaba wunupunne. ");
INSERT INTO paoNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Soo Zachariah yise ka Te Naa tummatziwabe poonnese suihoo. ");
INSERT INTO paoNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Soo Te Naa tummatziwabe ka Zachariah mee netamma, “U sakwa gi suipana. Soo Te Naa tookwa u nanetsukwiya'ena naka. U nodukwa Elizabeth mee naneadu saa'a naatse tooa'agakwu. U yise John mee oo neakwu. ");
INSERT INTO paoNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ka oo nadooa'adoose, mu saa'a besa sokwamadooa, ewa'yoo numu saa'a punno'o ooosoo. ");
INSERT INTO paoNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Soo John besa'yoo numukwu, ka gisoo oo nadooa'adoo soo Te Naa tu Besa Pooha-ma oo sootuhikwu. Soo John sakwa ooosapa gi atsa tutza'emukwa baa hebepana, gi tooe hownnekoo puma tu nabaayina hebepana tuwazoo. ");
INSERT INTO paoNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","17","Saa'a ka nana manese, soo John unusoo pooha-gakwu ka Te Naa yadooawabe Elijah mee naneadu-kwa'ne. Ka Te Pabe'e gisoo petu, saa'a u tooa, John, mu numu oo-toogoo mooe nemamakwupunnedooa. Soo John ka mu numu Te Naa oemota manepu, ka oo besa podo mu makodyukwu. Soo John ka mu naanapua'amu tu doodooamu besa soobedya mayugwedooa. Soo John saa'a ewow Jew numu ka Te Naa mu naka'oedyuku-matusoo makodyudooa.” ");
INSERT INTO paoNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Soo Zachariah ka Te Naa tummatzidu toha kasa-gakoo mee netamma, “Mooasoo nu unu wa'etsena, e nodukwa punno'o unu peawabe. Hownnekoo yise nu oo sopedakwadoodooa u sumuna e nemooaka?” ");
INSERT INTO paoNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Soo Te Naa tummatzidu toha kasa-ga'yoo mee oo nanekwegea, “Gabriel mee nu nane'a. Nu Te Naa-nakwana kemmadu. Soo Te Naa-soo meeoo e netamma, nu u tuukwedooa ka besa na'unnedu. ");
INSERT INTO paoNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Meno'o manakwana, u gi yadooa manekwu, u ka ume e tuukwena gi naka'oedyukuna. Pana saa'a ka u tooa nawuese, u yadooasoo manedooa.” ");
INSERT INTO paoNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","No'yoona mu numu puuwanasoo konnodape ka Zachariah wutooena. “Ha'ooga manena oosoo gi yabe tsebooegena?” mee umu sokwama. ");
INSERT INTO paoNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Ka saa'a umu-matoo tsebooekese, yise sukwe miyutsu'nge, gi yadoo'a. “Soo wa'etse tuusoobedyadu-kwa'ne nuumma,” mee mu numu sokwama. ");
INSERT INTO paoNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Saa'a ka tu nananesootuhi pupua'amu tutumatzimakwuse, ka nanesootuhi nobe-kwi'yoona, Zachariah nobe-kwitoosoo kodyuka. ");
INSERT INTO paoNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Ka saa'a soo oo nodukwa, Elizabeth mee naneadu, kohea. Manege muha manepetuga, Elizabeth ooosapa nobe-kwisoo. ");
INSERT INTO paoNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Soo Elizabeth yise mee unakwe, “Soo Te Naa e tubetse sootuhipu. Meno'o manakwana numu gi e nesootzemakwu, gi dooamu-ga'yoo mee e netammana.” ");
INSERT INTO paoNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","27","Soo tsuadumu Mary mee naneadu, Nazareth mee naneadu-kwi nobe-ga'yoo. Soo Mary koomadookwuna Joseph mee naneadu saa'a oo nodukwadookwu. Soo Joseph ka umu ne Jew numu-kooba katudu, David mee naneadu-nakwana a numuhabena. Ka Elizabeth naapahe muha koheana oo manekase, soo Te Naa ka pumme tummatzidu, toha kasa-gakoo Gabriel mee naneadu ka Mary-matoo taya. ");
INSERT INTO paoNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Soo Gabriel ka Mary-baa petugase meeoo oo netamma, “Soo Te Naa tubetse besa u sootuhikwu.” ");
INSERT INTO paoNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Soo Mary oo-ma nakasua'e, “Hemmagina netamma?” mee soonammena. ");
INSERT INTO paoNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","33","Soo Gabriel yise mee ka Mary netamma, “Gi suipana. Soo Te Naa besa u-matoo soonammena, u sootuhikwu. Pudusoo u kohease saa'a u naatse oonga'a dooadookwu. U yise Jesus mee oo neakwu Numu Magwetzoidu mee na'unnedu. Oosoo unu pooha-gakwu, oosoo ka Te Naa-nakwana kemmakwuse. Soo Te Naa saa'a ooosapa tu doodooamu-kooba tueya'e tuungudooa ka mu namooatupu David-wa'nesoo soo David puu tu nanumu nehanegatudu. Gadoo hee oo ooonakwatu.” ");
INSERT INTO paoNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Soo Mary yise mee ka Gabriel tubenga, “Hownnekoo yise nu tooa'adookwu, nu ka gi hannano'o nanano habepuna?” ");
INSERT INTO paoNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Soo Gabriel yise mee oo nanekwegea, “Soo Te Naa ka tu Besa Pooha-ma oo u sootunagakwu. Ka oo Besa Pooha-toohakwi u koheakwu, oosoo tuha'yoo ka Te Naa Tooa'akwu. ");
INSERT INTO paoNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Soo u hama'a Elizabeth punno'o u-kwa'nesoo besa nasootuhipu. ‘Oosoo gi dooamu-doodu mogo'ne,’ mee mu numu ka o'nosoo oo nea pana oosoo yise mooasoo naapahe muha kohea. ");
INSERT INTO paoNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","No'yoona soo Te Naa unnepu togesapa manekena.” ");
INSERT INTO paoNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Soo Mary meeoo, “Nu Te Naa tummatziwabe. Tooe how tooe nuka Te Naa mayugwena besa'yoo.” Soo Gabriel yise meahoo. ");
INSERT INTO paoNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Gi haa'no obenakwatoo, soo Mary namahanese, mea oona giba-matoo ka teepu Judea mee naneadu-kwitoo, ka tu hama'a Elizabeth nobenega. ");
INSERT INTO paoNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Ka Zechariah nobe-kwi yise petugase, ka Elizabeth-no yadoo'a. ");
INSERT INTO paoNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","42","Soo Elizabeth ka Mary-no yadooadyakwe, oo wuma ka tu oonga'a yutsungahoose. Soo Elizabeth yise ka Te Naa Besa Pooha-toohakwi pumme oo wupetuhoose yadooakooha. Mee yise unnewunu, “Soo Te Naa tubetse besa u sootuhipu, u oonga'a nokosoo. ");
INSERT INTO paoNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Nu besa soonamme ka yaa nu-baa u petuse, ka tamme magwetzoikwudu u kohe'a, ka Te Naa ume besa sootuha'e. ");
INSERT INTO paoNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Ka u petuhoose nuka u yadooese, e oonga'a nu-naga'yoona yutsungahoo, ka besa soonammese. ");
INSERT INTO paoNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Soo Te Naa tubetse besa u sootuhi u ka tubetse besa no'oko oo unnepu naka'oedyukuna.” ");
INSERT INTO paoNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","47","Soo Mary tubetse besa soonammena nanesootuhikooha meeoo yise, “Soo Te Naa tubetse besa'yoo, numu magwetzoidu. Nu tubetse besa oo-matoo soonamme. ");
INSERT INTO paoNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Tooe gi e maawa'nekoo sapa soo Te Naa e soobedyana tubetse besa e sootuhi. Yaa manakwana mu numu ooosapa meeoo nu-kwitu wahakwu, ‘Soo Te Naa ka Mary tubetse sootuhipu.’ ");
INSERT INTO paoNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Soo Te Naa tubetse unu pooha-ga'yoo. ");
INSERT INTO paoNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Soo Te Naa oe manakwana te soobedyana tamme punno'o ka oo naka'oedyukuna besa nasootuhi. ");
INSERT INTO paoNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Soo Te Naa unu naduya hemma yugwedu, oosoo umu besa nasooyugwedu numu matzooekute, ");
INSERT INTO paoNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","mu numu-kooba aatadu nokosoo. Pana ka mu gi maawa'nekoo numu besa sootuha'e. ");
INSERT INTO paoNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Soo Te Naa ka mu tutuha manedu sootuha'e, pana mooasoo besa manepunne mee nasooyugwedu numu soo Te Naa tsasoopedya. ");
INSERT INTO paoNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","O'nosoo soo Te Naa ka te namooatupu Abraham mee netammapu, ‘Mu yow e nanumu besa sootuhikwu.’ Meno'o yise soo Te Naa ka mooasoo meeoo unnepuna yise ooosapa besa te sootuha'e.” ");
INSERT INTO paoNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Pahe muha soo Mary ka Elizabeth-baa'yoose tu nobe-kwitoosoo kodyukasoo. ");
INSERT INTO paoNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Ka saa'a yise soo Elizabeth naatse tooa'adoo. ");
INSERT INTO paoNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Oo nananumu-no oo nonopua'a besa sokwama ka oo nakase, soo Te Naa ka oonga'a-ma besa ooka sootuhise. ");
INSERT INTO paoNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Sumu nasatese, umu nanesootuha'e ka Jew numu tumayohokuna soo oonga'a Jew mane, oo nakakwuse tuwazoo. Umu oo nonopua'a ka oonga'a Zachariah mee tooe neahookwu, ka oo naa-wa'nesoo, ");
INSERT INTO paoNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","pana soo Elizabeth meeoo mu netamma, “Masoo John mee naneakwu.” ");
INSERT INTO paoNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Umu yise meeoo oo tubenga, “How yise John? Gi too haka u nananumu-matu John mee nane'a.” ");
INSERT INTO paoNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Umu ka Zachariah mayutzengese, oo mi yadoo'ena, oo tubenga, “Ha'yoo u ka u tooa'a naneamakakwu?” ");
INSERT INTO paoNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Soo Zachariah yise punno'o mu tumawahakuse pumma tu tubokwuna nekwa'e. ");
INSERT INTO paoNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ka pumme ooka tu gease, Zechariah yise meeoo oo-ma tubohoo, “Mooasoo masoo John mee nane'a.” O'no yise soo Zachariah tuapa nanakahoopetuhoosoo yadooase nanesootuhikoohase mee unnewunu, “Soo Te Naa tubetse besa'yoo.” ");
INSERT INTO paoNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","66","“Esoo ka Te Naa umu sootuhipu. Hownne'yookwu gina esoo tuha'yoo?” mee umu oo nonopua'amu sokwama. Gi haa'no oobenakwatoo mu numu ka teepu Judea mee naneadu-koobatu ka oona giba-na nonobe-ga'yoo, ka Zachariah Elizabeth-no unu moomooatupu dooa'adoose oo nanatukwena, punno'o meeoosoo, “Hownne'yookwugina oosoo tuha'yoo?” Umu ka Te Naa saa'a ooka sootuhikwuna sopedakwadoo, soo tuha'yoo ka Te Naa Besa Pooha-ma tu hee-gakwu. ");
INSERT INTO paoNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Soo Zachariah ka Te Naa pooha-toohakwi nanesootuhina mee unakwe, ");
INSERT INTO paoNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","73","“U, Ne Naa numme Jew numu ooosapa pumatoo nanesootuhidyina. U tubetse besa'yoo. U ka ne namooatupu Abraham mee naneadu meeoo netammapu u ka numme wohonedu-makoo ne magwetzoikwu mee. Meno'o yise u ka u unnepu oo-toogoo mayohogena. U mooasoo meeoo unnepu ka Ne Pabe'e numme-baa petuse, oosoo ka mu tunaka'oedyukudu David mee naneadu-nagatu tsuagetu. Oosoo Te Pabe'e unu poohagakwu ");
INSERT INTO paoNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","umu numme wohonedu tu pooha-ma matzooekukwu. Gi numme hemma-ma nasoosu'a. ");
INSERT INTO paoNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","U nakabetseana kaaheno ka u besa podo meadabekwu. ");
INSERT INTO paoNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Yise u e tooa John, ka Te Naa yadooawabe manekwu. U ka Te Pabe'e-kobenasoo meadabenokwu ka mu numu nemabetsea meakwu. ");
INSERT INTO paoNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","78","U meeoo ka mu numu tuukwekwu soo Te Naa te sootuhina te magwetzoina, te tuma'emukwana soomu'wakwu soo Te Pabe'e ka tutuha te soobedyana. Soo Te Naa ka Te Pabe'e tamme-baatoo ta'ya ka tabatsebooege-kwa'nekoo yaa teepu-koobatoo petuookwu. ");
INSERT INTO paoNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Mu numu, ka togaba-witu tuigadu oosoo mu tzapoonnekukwu ka besow po, o'no yise soo Te Naa mu magwetzoikwu.” ");
INSERT INTO paoNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Soo John ka saa'a, ka nana manekese, ka Te Naa pooha hee-ga'yoo. Mana giba-ma nobe-ga'yoo numu-wana, ka namamakwuse mu Jew numu nanesootuhibu tunedyooekwuse. ");
INSERT INTO paoNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","3","O'no yise soo mu Roman numu-kooba katudu, Augustus mee naneadu tubo mee tunetammana, “No'yoona numu sakwa tu naneana tzebotugu, ka tu nanamooatupu pukwi'yoona kemmapu-wisoo.” ");
INSERT INTO paoNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","5","Soo Joseph ka David-ma'yoona tsuaketu tu nanamooatupu, yise ka Bethlehem numu nokatu-kwi'yoona kemmapu ka Judea mee naneadu teepu-koobatu. Soo Joseph ka Mary-no yise ka Nazareth mee naneadu-wi'yoona Bethlehem-witoo memeakwate tu nananeana botugukwuse. Umu ka saa'a nanodukwadookwu. Mooasoo soo Mary paba kohe'a. ");
INSERT INTO paoNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","7","Umu yise Bethlehem-wi pepetugase, soo Mary yise naatse tooa'adoo. Oosoo mu oonga'a mu mooe tooa'a. Soo Mary yise wunapu-wi oo wutootase, ka pookoo tukanoo-kwi oo tzahabeku, umu ka gi hanosoo toikwuse. Mooasoo kakaa'no'yoo soo numu pukwi tooina. ");
INSERT INTO paoNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Mu seepu takonedu-matu tu seepu tako'ne, ona sukwe puuwana. ");
INSERT INTO paoNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Te Naa-baa'yoona mu tutakonedu-koobatoo pa'anakwana gootabua petuse mu gootabuakupunne, yise sumu'yoo Te Naa tummatziwabe, mu toha kakasa-gakoo-matu pa'anakwana umu-tamme wuegena. Mu tutakonedu tubetse unu sua'e. ");
INSERT INTO paoNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Soo Te Naa tummatzidu yise meeoo mu netamma, “Mu sakwa gi suipana. Nu besa mu tuukwegena, no'obatusoo numu besa masokwamakwudu. ");
INSERT INTO paoNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Yaa tabeno mooasoo soo Te Pabe'e nadooa'adoo, oona Bethlehem-witoo ka David pukwi'yoo kemmapu-wi'yoona. Soo Te Pabe'e mu magwetzoikwutu. ");
INSERT INTO paoNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Mu oo sopedakwadookwu nu togesapa mu tuukwe'e, mu oo mayukwu ka oonga'a wunapu-wi namabutooena, pookoo tukanoo-kwi oo natzahabekute.” ");
INSERT INTO paoNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Toge o'no, ewa'yoo mu Te Naa tutummatzidu toha kakasa-ga'yoo pa'anakwana umu-baa petugonnose nanesootuhina mee unnegonno, ");
INSERT INTO paoNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“U pa'anakwatu Ne Naa tubetse besa'yoo. U, Ne Naa ka mu numu-matoo besa soonammena yaa teepu-koobatoo mu sootuhina mu magwetzoikwu.” ");
INSERT INTO paoNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Umu Te Naa tutummatzidu toha kakasa-ga'yoo yise punowsoo toogoopatoosoo kodyuhoo. Mu tutakonedu yise meeoo nananetamma, “Tamme sakwa oona Bethlehem-witoo mease, oo poonne ka Te Naa tamme tuukwena.” ");
INSERT INTO paoNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Mu tutakonedu yise yabesoo mea'ase, Mary-no Joseph mayu petuga, yise ka oonga'a ka pookoo tukanoo-kwi oo natzahabekute. ");
INSERT INTO paoNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","20","Mu tutakonedu yise punnowsoo kodyuna, nanesootuhina mee unnemena, “Ne Naa, u tubetse besa'yoo. U, Ne Naa numme sootuhipu. Numme nanasookwugi pooha namanipu poonnena ka pooha na'unnewunudu naka. No'yoona tookwa soo ume unnepu togesapa.” Umu yise punowsoo meana mu numu tuukwemena, ka oonga'a tu poonnepu-witu. “Hownne'yookwugina soo oonga'a?” mee mu numu ka mu tutakonedu unnena nakadu sokwama. Soo Mary mu unnena soomayuna, yise ewa oetu soohaneyakwe. ");
INSERT INTO paoNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Namewatsu tabe mease ka mu Jew numu ka Te Naa pumme tunetammakapu mayohoyakwe umu ka oonga'a Jew numu manena tumayohokukwu. Jesus mee oo nea, ka Te Naa tummatziwabe ka toha kasa-gakoo pumme netamma-kwa'nesoo, gisoo ka Mary kohe'a. ");
INSERT INTO paoNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","24","Soo Mary ka tu hoone manena tatukwase, yise ka Joseph-no ka tu oonga'a Jesus tzahedana ka Jerusalem mee naneadu-kwitoo memea. Ka o pepetugase, ka pabow nanesootuhi nobe-kwitoo memea, soo Mary waahoo weeho ka Te Naa tzademe, ka Te Naa tunetammana mayohona. Soo Te Naa meeoo, “Soo numu mooe tooa tooe hannano pana nugatu.” ");
INSERT INTO paoNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Sumu'yoo besa'yoo wa'etse, Simeon mee naneadu, Jerusalem-wi nobe-ga'yoo. Oosoo ooosapa ka Te Naa-matoo nanesootuhina, ka tu Nanumu Magwetzoidu Te Pabe'e petukwuna wutooedu. ");
INSERT INTO paoNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Soo Te Naa ka Simeon ka Tu Besa Pooha-ma meeoo, tuusoobedyapu-ga'yoo, “Gisoo u ya'ena, u Nanumu Magwetzoikwudu poonnekwu.” ");
INSERT INTO paoNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Soo Te Naa Besa Pooha ka nanesootuhi nobe-kwitoo ka Simeon ta'ya. O'no yise mu Mary-no Joseph ka Jesus tzahedana pepetuoo, ka tumayohope mayohokwuse. ");
INSERT INTO paoNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Soo Simeon ka Jesus tzahedase, tu puta-wi oo hedapunnena, ka Te Naa-matoo nanesootuhiwunu mee unnewunu, ");
INSERT INTO paoNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","32","“U, Ne Naa, tubetse besa'yoo. Nu meno'o oo poonne numme-matoo u tutayana numu magwetzoikwudu. Oosoo saa'a mu gi Jew numu togesapa u unnepu tunedyooena yise mu Jew numu sootuhidooa. Wuna'me nu oo wutoo'e, ume nakabetseana. Nu gisoo ya'ena oo poonnekwu mee u e tuukwe. Meno'o yise nu besa soomanena mesoo ya'e, nu ka mooasoo oo poonnese.” ");
INSERT INTO paoNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","“Soo Simeon sumuna besa ka ne tooa-witu netamma,” mee mu Jesus naanapua'amu ka gi oo nakasopedakwadoopana besa oo nakasokwamakute. ");
INSERT INTO paoNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","35","Soo Simeon yise mu nanesootuhikuse, ka Mary meeoo netamma, “U tooa'a saa'a ka mu Jew numu suda tumatuguna tzapoonnekudooa, yise ka hayoo mu tusooyugwena. Umu-matu namagwetzoikwudu. Umu-matu punno'o kadoo namayugwekwu umu ka oo nekwohonena. U punno'o unu tutuha soonammekwu ka mu numu u tooa tumoo'ookese.” ");
INSERT INTO paoNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Toge o'no, tubetse unu peawabe, Anna mee naneadu, umu-baa petuhoo. Soo Anna tubetse besa'yoo numu. Besa'yoo uga kooma-gana ");
INSERT INTO paoNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","ka tu kooma ya'ese, unusoo besa'yoo ka wuna'me nonotsa awamooa nanesootuhiyakwe ka nanesootuhi nobe-kwi'yoona nanesootuhidyina, nonotsa yongona tuwazoo. Ewasoo gi tukapana nanesootuhiyakwe. Soo Anna Te Naa yadooawabe. ");
INSERT INTO paoNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ka Mary noko Joseph pu-baa pepetugase, Anna ka Te Naa-matoo nanesootuhi, “U, Ne Naa, tubetse besa'yoo. Yowsoo oonga'a te wutooena. Esoo tamme Jew numu magwetzoikwudu.” ");
INSERT INTO paoNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Joseph-no Mary ka tumayohope mayohose, ka Te Naa pumme netamma-kwa'ne ka tu teepu Galilee mee naneadu-kwitoo punowsoo kodyuka, ka Nazareth mee naneadu-kwitoo ka Te Pabe'e-nosoo. ");
INSERT INTO paoNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Soo Te Pabe'e Jesus mee naneadu naatse manekese, unu natzooena, unu soonamme, ka Te Naa pumme sootuha'e. ");
INSERT INTO paoNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Nonotsa sumu tomoyina soo Te Pabe'e Jesus naanapua'amu ka Jerusalem mee naneadu-kwitoo memeayakwe, nananesootuhina na'ewa tukayakwe, ka oo soomayuna, o'no mu Jew numu natzama'wu. ");
INSERT INTO paoNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Soo Te Pabe'e yise ka tooebetse manese, sumumano waha matsebuekudu (12) tomose, umu-no mea. ");
INSERT INTO paoNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","44","Soo Te Pabe'e Jesus naanapua'amu yise ka hemma namamakwuse, ka Jerusalem-wi'yoona memea. “Soo Jesus ka sumuna ta nananumu noko tu pupua'amu-no kemma,” mee umu sokwama. Pana soo Te Pabe'e ka Jerusalem-wisoo mani. O'no yongona umu oo too'e kwate tu nananumu-baatu. ");
INSERT INTO paoNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Pana umu-baatu kadoo'oo. Umu yise ka Jerusalem-witoosoo kokodyuka oo watena. ");
INSERT INTO paoNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Pahe tabe mease, umu oo mayu, ka nanesootuhi nobe-kwikoo mu nanesootuhibu numu tunedyooedu naka katuna ka nanesootuhibu-witu besasoo mu tutubengayakwe. ");
INSERT INTO paoNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","“Esoo besa oo nakasopedakwadoona mu mesoo nanekwegeayakwe, tooe togesoo naatsepana,” mee mu nanesootuhibu numu oo soobedya. ");
INSERT INTO paoNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","“How manena soo Jesus mow mu numu tunedyooedu yadooe katu?” mee oo naanapua'amu sokwama. Soo oo pea yise meeoo oo netamma, “Manatu tooe numme u too'e wate. U sakwa uga gi 'yoo suda ne matugupana.” ");
INSERT INTO paoNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Soo Te Pabe'e oo nanekwegease meeoo, “How yise manena mu e too'e wate? Mu mooasoo oo sopedakwatoo nu yaa E Naa-baa oo nakabetseana.” ");
INSERT INTO paoNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Soo Te Pabe'e naanapua'amu oo unnena gi nakasopedakwatoo. ");
INSERT INTO paoNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Umu yise ka Nazareth mee naneadu-kwitoo punowsoo kodyuka. Soo Te Pabe'e yise tu naanapua'amu besa nakabetsea. ");
INSERT INTO paoNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Nanakese unu soonamme manepetu soo Te Naa besa oo soobedya, mu numu punno'o. ");
INSERT INTO paoNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","2","Ka saa'a soo John ka Te Naa yadooawabe maneke, ka Tiberius mu Roman numu-kooba oo katu mooasoo ewasoo (15) tommokapu. ");
INSERT INTO paoNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Soo John yise ka giba-ma'yoo wuekese, ka baa hooodu Jordan mee naneadu-kumi meadabena, mu numu ma'emukwapu mu nanekwaha tuungu. “O'no soo Te Naa mu ma'emukwana soomu'wakwu,” mee mu netamma. Ka mu nanekwahakese, soo John yise baa-wi mu matzakakwu. ");
INSERT INTO paoNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Soo John ka o'nosoo Te Naa yadooawabe Isaiah mee naneadu pumme waha-kwa'ne manakwe. Isaiah meeoo tubotugu. “Mana ka gi hemma nadukadu naa-wi'yoona sumu'yoo nana ka Te Naa pooha-toohakwi mu numu tunesootabuekwu, ‘Mu sakwa muusoo namabetseapunne ka Te Pabe'e pudusoo petukwuno'oto. Mu sakwa kaaheno tuusooyugwepunne, o'no mu besa oo nakabetseanokwu.’ ");
INSERT INTO paoNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Meno'o mu numu ka unu nanakwohonedu sutakoo podo me'a. Nanekwahase, ka po kaaheno mayugwe. Soo Te Naa ka numu besa mayugwekese, mu oo nagenokwu. Soo Te Naa ka giba wuwuta'nena kaaheno mayugwese, mu tutuaga kwakwabedu kaanokukese, mu numu yise kaaheno oo podokoo besa meadabekwu. ");
INSERT INTO paoNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","No'obatusoo numu yise oo nakasopedakwadookwu ka Te Naa tamme magwetzoa'e.” ");
INSERT INTO paoNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Soo John ka mu numu pu-baa petudu mee netamma yakwe, “Mu unu etza'a. Saa'a soo mu tuma'emukwana mu-matoosoo kodyukwu. Mu baa-wi mumme e matzaka tuungu, pana mu gi ka mu tuma'emukwapu nematzagakwuna'e. ");
INSERT INTO paoNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Mu mooe'ugasoo sakwa ka suta mu manena tubetse ma'wukase, ka besa-tamme manese, o'no sakwa yise nu baa-wi mu matzakakwu. Gi besa nasooyugwena mee unnegonnopana, ‘Numme yaahoo Te Naa doodooamu, numme ka Jew numuna.’ Mu tookwa gi oo nakasopedakwadoo soo Te Naa tooe hownnekoo tooe tu doodooamu mu mesoo mayugwe. ");
INSERT INTO paoNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Mu sakwa besa tumatugu. Mu ka ooosapa gi besa tumatuguna mu kadoo'oo namayugwekwu. Tooe haga tooe gi he-toogoo besa'yoo natunikwu.” ");
INSERT INTO paoNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Ewa'yoo numu oo nakana oo tubengu, “Hownnekoo sakwa numme besa tumatugumo?” ");
INSERT INTO paoNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Soo John mee mu nanekwegea, “Mu sakwa ka tutuha manedu tummatzi. Tamme ka waha-batu hemma hee-gana sakwa sumuoo ka numu gi hee-gakoo gea. Ka tukapu-gana tamme sakwa mu tseagoedu maka.” ");
INSERT INTO paoNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Mu tumasumudoodu ka John-baa petuse baa-wi oo namatzaga tuunguna. “Hownnekoo sakwa numme besa tumatuguyi?” mu numu mee oo tutubengu. ");
INSERT INTO paoNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Soo John mu nanekwegea, “Mu ka mu tumasumutoona suu'mu haneyi.” ");
INSERT INTO paoNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Mu tukwutumadu punno'o oo tutubengu, “Hownnekoo sakwa numme besa natumunagakuna suu'mu oo natubesatuka?” Soo John mee mu nanekwegeana, “Mu sakwa gi mu numu nesuana hemma puma mu tumuna hanepana. Mu sakwa gi mu numu nemooagana mu esayikupana.” ");
INSERT INTO paoNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Mooasoo mu Jew numu oo sopedakwatoo ka tooe hannano tooe ka Te Pabe'e nanepetuna umu yise ka John Te Pabe'e mee sooyugwe. ");
INSERT INTO paoNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Soo John ka mu sokwamapunnena sopedakwadoona mee mu netamma, “Nu gi Mu Pabe'e. Nu gi oo-wa'ne unu pooha-ga'yoo. Nu baa-wi numu sukwe matzakayakwe. Soo Te Pabe'e nuga ooonakwa unu pooha-ga'yoo nuga ooonakwa besa'yoo. Soo Te Pabe'e ka Te Naa Besa Pooha-ma mu sootuhikwu oosoo suda mu manena mu nematzagakuse mu gi tunakabetseadu kadoo'oo namayugwekwu. ");
INSERT INTO paoNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Soo Te Pabe'e petuse ka mu numu yaa teepu-koobatu nemadabuedooa ka mu bebesow ka suta-nagakoo tzobadooa. Ka bebesow numu yise Te Naa nobe-kwi mu nabaa'yookukwu. Ka sutakoo numu gi tunaka'oedyukudu soo Te Pabe'e ka tubetse gi tokedu goso-witoo ma'anakwunikwu.” ");
INSERT INTO paoNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Meeoonekoo soo John ka o'nosoo ooosapa numu tunedyooe ka Te Naa besa unnepu-witu. ");
INSERT INTO paoNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","22","Soo John ka mu numu baa-wi matzadyakwe, soo Te Pabe'e punno'o oo-baa petugase yise baa-wi namatzaka. Ka Te Pabe'e nanesootuhiwunu, soo Te Naa Besa Pooha pa'anakwana kwe'na'a tubongo punoonooe yotsekwuge-kwa'ne yise oonaga manipetu. Soo Te Naa pa'anakwana yadooase, mee unne, “U yow E Besaa Tooa, nu-kwa'ne'yoosoo. Nu unu u soopedyana besa u-matoo soonamme.” Ka saa'a soo mu Jew numu-kooba numu nehane katudu Herod mee naneadu gi toge'yoo nana. Tu pabe'e nodukwa, Herodias mee naneadu, oo-makoo tsakahoose oo nodukwadoo. Soo John ka Herod manena nesootu'adya'ena mee oo netamma, “U sakwa gi ewa suda tumatugupana. U sakwa gi uga ka u pabe'e nodukwa nodukwadoopana.” Soo Herod gi oo nakabetsebena nanahano'obasoo ka John wutuma tuunguna. ");
INSERT INTO paoNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Soo Te Pabe'e ka pahemano (30) tommo manepetuse numu nanesootuhibu tunedyooe maneka. Soo Te Pabe'e ka Joseph tooa mee mu numu-matu unakwe. Soo Joseph naa Heli mee nane'a. ");
INSERT INTO paoNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Soo Heli naa Matthat mee nane'a. Soo Matthat naa Levi mee nane'a. Soo Levi naa Melchi mee nane'a. Soo Melchi naa Jannai mee nane'a. Soo Jannai naa Joseph mee nane'a. ");
INSERT INTO paoNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Soo Joseph naa Mattathias mee nane'a. Soo Mattathias naa Amos mee nane'a. Soo Amos naa Nahum mee nane'a. Soo Nahum naa Esli mee nane'a. Soo Esli naa Naggai mee nane'a. ");
INSERT INTO paoNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Soo Naggai naa Maath mee nane'a. Soo Maath naa Mattathias mee nane'a. Soo Mattathias naa Semein mee nane'a. Soo Semein naa Josech mee nane'a. Soo Josech naa Joda mee nane'a. ");
INSERT INTO paoNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Soo Joda naa Joanan mee nane'a. Soo Joanan naa Rhesa mee nane'a. Soo Rhesa naa Zerubbabel mee nane'a. Soo Zerubbabel naa Shealtiel mee nane'a. Soo Shealtiel naa Neri mee nane'a. ");
INSERT INTO paoNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Soo Neri naa Melchi mee nane'a. Soo Melchi naa Addi mee nane'a. Soo Addi naa Cosam mee nane'a. Soo Cosam naa Elmadam mee nane'a. Soo Elmadam naa Er mee nane'a. ");
INSERT INTO paoNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Soo Er naa Joshua mee nane'a. Soo Joshua naa Eliezer mee nane'a. Soo Eliezer naa Jorim mee nane'a. Soo Jorim naa Matthat mee nane'a. Soo Matthat naa Levi mee nane'a. ");
INSERT INTO paoNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Soo Levi naa Simeon mee nane'a. Soo Simeon naa Judah mee nane'a. Soo Judah naa Joseph mee nane'a. Soo Joseph naa Jonam mee nane'a. Soo Jonam naa Eliakim mee nane'a. ");
INSERT INTO paoNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Soo Eliakim naa Melea mee nane'a. Soo Melea naa Menna mee nane'a. Soo Menna naa Mattatha mee nane'a. Soo Mattatha naa Nathan mee nane'a. Soo Nathan naa David mee nane'a. ");
INSERT INTO paoNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Soo David naa Jesse mee nane'a. Soo Jesse naa Obed mee nane'a. Soo Obed naa Boaz mee nane'a. Soo Boaz naa Salmon mee nane'a Soo Salmon naa Nahshon mee nane'a. ");
INSERT INTO paoNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Soo Nahshon naa Amminadab mee nane'a. Soo Amminadab naa Ram mee nane'a. Soo Ram naa Hezron mee nane'a. Soo Hezron naa Perez mee nane'a. Soo Perez naa Judah mee nane'a. ");
INSERT INTO paoNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Soo Judah naa Jacob mee nane'a. Soo Jacob naa Isaac mee nane'a. Soo Isaac naa Abraham mee nane'a. Soo Abraham naa Terah mee nane'a. Soo Terah naa Nahor mee nane'a. ");
INSERT INTO paoNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Soo Nahor naa Serug mee nane'a. Soo Serug naa Reu mee nane'a. Soo Reu naa Peleg mee nane'a. Soo Peleg naa Eber mee nane'a. Soo Eber naa Shelah mee nane'a. ");
INSERT INTO paoNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Soo Shelah naa Cainan mee nane'a. Soo Cainan naa Arphaxad mee nane'a. Soo Arphaxad naa Shem mee nane'a. Soo Shem naa Noah mee nane'a. Soo Noah naa Lamech mee nane'a. ");
INSERT INTO paoNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Soo Lamech naa Methuselah mee nane'a. Soo Methuselah naa Enoch mee nane'a. Soo Enoch naa Jared mee nane'a. Soo Jared naa Mahalaleel mee nane'a. Soo Mahalaleel naa Cainan mee nane'a. ");
INSERT INTO paoNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Soo Cainan naa Enos mee nane'a. Soo Enos naa Seth mee nane'a. Soo Seth naa Adam mee naneadu. Ka Adam yise soo Te Naa manumudoopu. ");
INSERT INTO paoNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Ka Te Naa Besa Pooha-toohakwi'yoona Te Pabe'e ka Jordan hooodu-kumaba'yoona mea. Soo Te Naa Besa Pooha numu-wanatoo oo tayana oo nanesootuhi tuunguna. ");
INSERT INTO paoNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","3","Saa'a yise soo suta'yoo ka Te Pabe'e meeoo netamma, “U sakwa nanamanena nasootza'me ka Te Naa Tooa'ana. U sakwa eka tupe tukaba mayugwe, o'no u oo mesoo tuka.” ");
INSERT INTO paoNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Soo Te Pabe'e gi oo nakabetseana, mee unakwe, “Soo Te Naa meeoo, ‘Tukapu nadukana suu'mu gi numu magwetzoi-wa'ne'yoo.’ Soo Te Naa unnepu suu'mu numu magwetzoi.” ");
INSERT INTO paoNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Soo Suta'yoo yise pa'atoo ka Te Pabe'e bikase, oo tzapoonnekute no'yoona nana'ata'yoosoo numu ka teepu-koobatu. ");
INSERT INTO paoNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Soo Suta'yoo yise meeoo tuwazoo ka Te Pabe'e netamma, “O'nosoo nuka mu numu yaa teepu-koobatu e moohe tuungu, umu yise no'yoona e nakabetseakwu. ");
INSERT INTO paoNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","U ka nu-matoo nanesootuhina, nu ume mu nakabetsea tuungukwu.” ");
INSERT INTO paoNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Soo Te Pabe'e meeoo ka Sutakoo netamma, “Nu gi u-matoo nanesootuhi-wa'ne'yoo. Soo Te Naa unnepu mee mooasoo nabotugu, ‘Tamme sakwa ka Te Naa-matoo suu'mu nanesootuhi, ookow suu'mu nakabetsea.’ ” ");
INSERT INTO paoNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Soo Suta'yoo yise ka Te Pabe'e ka Jerusalem mee naneadu-witoo bika. Pa'atse'e ka pabow nanesootuhi nobe-kooba oo wunu tuunguse, ka Te Pabe'e mee netamma, “U sakwa nanamanena u ka Te Naa Tooa'ana. U sakwa ma-kooba'yoona nadawunihoo. ");
INSERT INTO paoNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","O'no soo Te Naa u magwetzoikwu oosoo ka meeoo nabotuguna, ‘Soo Te Naa umu pumme tummatzidu u mabetsea tuungu. ");
INSERT INTO paoNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","U gi tupe-ma tukwutza'nge-wa'ne'yoo, umu ka u tsipunnena.’ ” ");
INSERT INTO paoNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Soo Te Pabe'e yise ka Sutakoo meeoo netamma, “Nu gi umu unnena nakabetsea-wa'ne'yoo, oosoo ka meeoo nabotuguna. ‘Tamme gi ka Te Naa mapoonne, ha'oo sakwa oosoo mani mee sokwamana.’ ” ");
INSERT INTO paoNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Soo Suta'yoo yise ka Te Pabe'e-baa'yoona meahoo. “Sumuna penakwasoo nu ka Mu Pabe'e makwuhookwu,” mee soonammena. ");
INSERT INTO paoNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","15","Soo Te Pabe'e yise punowsoo kodyuka ka pummesoo teepu Galilee mee naneadu-witoo. Soo Te Pabe'e yise ka meadabena ka Te Naa Besa Pooha-toohakwi ka Te Naa unnepu numu tunedyooe mea ka Jew numu nanesootuhi nobe-wi'yoona tuwow. No'yoona ka teepu-koobatu mu numu oo nanatuukwe'e yise mee nana'unakwe'e, “Soo Te Pabe'e Jesus tubetse unu besow pooha-ga'yoo.” ");
INSERT INTO paoNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Soo Te Pabe'e ka Nazareth pukwi tu namananana-wisoo petuga. Ka nanesootuhi tabeba oe manepetuse, soo Te Pabe'e numu-baa nanesootuhi petuga ka ooosapa maneyina. ");
INSERT INTO paoNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Soo Te Pabe'e yise natunea tuungu. Oosoo yise wunuoohoo. Umu ka o'nosoo Te Naa yadooawabe Isaiah mee naneadu tubona nakea. Oo tsakwunowse oo-toogoo tu poonnemese ka oo mayuse ooka mu neakutu mee na'unnedu. ");
INSERT INTO paoNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Soo Te Naa Tu Besa Pooha-matu-ma e sootuhipu ka umu tutuha manedu gi how mane-wa'ne manepunnedu numu tu unnepu e tuukwe tuunguna. Ka Te Naa Pesa Pooha-ma ka mu nanasuda tu tumatugumasoo tzangedu umuoo suda tumatuguna soomu'wakwu mu sootuhina mu magwetzoikwu. Mu gi tutubootabuedu-kwa'ne manepunnedu nu sootuhina mu magwetzoikwu. Yise mu numu mukwapunnedu numu nanasuda namatugudu, ");
INSERT INTO paoNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","nu besa tuukwekwu. ‘Meno'o soo Te Naa mu magwetzoikwu.’ ” ");
INSERT INTO paoNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Soo Te Pabe'e yise oo neamakwuse o ka pumatoo a natubona mabutooese punowsoo ka tu tummatzidu geasoo yise ka numu tunedyooedu katunoo-wi katuhoo. No'yoona numu yise oo nakapunne. ");
INSERT INTO paoNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Soo Te Pabe'e yise meeoo mu netamma, “Yow meno'o soo o'nosoo a unnepu oo-toogoo manekena. Mu muusoo namakoo a poonne.” ");
INSERT INTO paoNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","“Soo Jesus nanabesa yadooapana masoo tamme-matusoo, masoo Joseph tooa. Ha'oo yise masoo besa yadoo'a?” Mee'e no'yoona mu tunakapunnedu nananetamma. ");
INSERT INTO paoNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Soo Te Pabe'e mee mu netamma, “Mu sumuna meeoo e netammakwu, ‘Mooasoo numme oo naka u ewow numu magwetzoikena ka Capernaum mee naneadu wi'yoona. U sakwa yaanona ka umesoo numu mabetsea,’ mee sumuna mu e netammakwu. ");
INSERT INTO paoNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Nu mu tuukwekwu mu wakwawa'a Te Naa yadooawabe etzaga naka'oedyuku pana mu oogowsoo nanumu oo nopua'amu-no gi oo naka'oedyuku-wa'ne'yoo. ");
INSERT INTO paoNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Ka tubetse o'nosoo oo namanepu-wa'ne, wuna'me (3 ½) tomopu gi tu pow'ma, ewa'yoo Jew numu natseagoe. Ewa'yoo mu Jew pepeawabe tu koomamu tuipu punno'o tseagoe ");
INSERT INTO paoNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","pana soo Te Naa gi mu maka. Soo Te Naa ka wawa'a peawabe ka Elijah makayidu suu'mu makana oo sootuha'e. ");
INSERT INTO paoNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ewa'yoo Jew numu unu tookoo pehe'uagoedu pana soo Te Naa gi ka Elisha umuoo mabesaku tuungu. Soo Te Naa ka Elisha ka wawa'a tookoo pehe uayidu Naaman mee naneadu mabesaku tuungu. Soo Te Naa ka umu wakwawa'a etzaga tunaka'oedyukudu sootuhikwu, gi mumme gi tutunaka'oedyukudu.” ");
INSERT INTO paoNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","29","Mu numu ka meeoo oo unakwe oo sutakuse yise ka nanesootuhi nobe-wikoo oo tayahoo. Yise oona wuta'ne-matoo oo tzakakase ka oo batsowkwuse. ");
INSERT INTO paoNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Pana soo Te Pabe'e mu tasegeyidoo meahoose mu namatsatsepooge, yise kokodyuka. ");
INSERT INTO paoNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Soo Te Pabe'e Jesus yise ka Capernaum mee naneadu-wi petuga. Toge, o'no mu nanesootuhigonno tabeno umu-baa petuga. Soo Te Pabe'e petugase, ka besowsoo ka Te Naa-witu mu numu tunedyooewunu. ");
INSERT INTO paoNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Mu numu yise oo nesookwuga'e oosoo tubetse besa ka Te Naa unnepu-witu wahamena, “Yow tookwa esoo Te Pabe'e,” mee'e mu numu. ");
INSERT INTO paoNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Sumu'yoo nana tsoapayidu oe. Soo tsoapa wa'agena ewa unnewunu ka Te Pabe'e meeoo netammabodote. ");
INSERT INTO paoNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Uda! U haa'a kadoo e mayugwekwu? U sakwa ne tsasoopedya. Nu u sopedakwatoo, u Jesus, ka No'oko Hemma Manumudoopu Besaa Tooa'a.” ");
INSERT INTO paoNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Soo Te Pabe'e ka tsoapa nematzagakwunihoo meeoo oo netamma, “Gi unnepana, managa'yoona tzebooegea.” Soo tsoapa ka oo-naga'yoona tsebooegease, ka nana wunapowkase sapa oosoo gi namanayaha. ");
INSERT INTO paoNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Mu numu yise mee nana'unnegonno, “Uune'yoo! Tamme ha'yoo gi hannano'o besa mownnekoo poohabe poonnedu. Esoo Te Pabe'e puu ka tsoapa nematzagakwunihoo, sukwe yadooase sapa.” ");
INSERT INTO paoNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Mu numu otuoo yise ka Te Pabe'e manipu poonnedu nanatuukwekooha ka saa'a yise ewa'yoo numu otuoo nanakwingadu oo nanatuukwegonno. ");
INSERT INTO paoNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Soo Te Pabe'e yise ka mu nanesootuhimakwuse oe'yoona mease, ka Simon Peter-baa petuga. Soo Simon Peter yahe peawabe unu tuoeya'ena oo tookoo unu udutuna onahoo hape. Umu o nobe-witu ka Te Pabe'e oetu tuukwe'e. ");
INSERT INTO paoNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Soo Te Pabe'e yise oo-baa wunu petugase meeoo oo netamma, “U mooasoo besa mani.” Oosoo peawabe yise yotseoose, mu tugoomahanekuhoose, mu tuka tuunguhoo. ");
INSERT INTO paoNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Oogowsoo yongona tu taba egowse, mu numu nana'atakoosoo tutu'oe-ga'yoo ka Te Pabe'e-baa natzato petudyakwe. Soo Te Pabe'e yise umu-ma pooha matugumena mu mabesakumena ");
INSERT INTO paoNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","mu tsoapagoedu nokosoo. Mu tsoapa yise mee unnegayakwe, “U yaahoo ka No'okosoo Hemma Manumudoopu Tooa'a.” Soo Te Pabe'e yise mu tsoapa tayayakwe. Soo Te Pabe'e gi ooka mu wahakwuna petzape, ka pumme mu sopedakwatoona. Ka mu tsoapa tsebooegeayakwe, mu tsoapagoedu numu yise besa maniyakwe. ");
INSERT INTO paoNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Oogow moo'a awamooa soo Te Pabe'e yise oona numu-wanatoo mea. Saa'a mu numu yise oo watena, oo mayuse, oo too'e nabaa'yoo tuungu. ");
INSERT INTO paoNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Pana soo Te Pabe'e mee mu sukwe netamma, “Mu numu manatooe nonobe-gakoo, nu ka Te Naa tamme mabetseakwuna-witu mu tuukwekwu. Soo Te Naa Besa Pooha meeoo e netamma, ‘Manatutooe mu numu ekow nanesootuhibu tunedyooe.’ ” ");
INSERT INTO paoNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Soo Te Pabe'e yise oona ka teepu Judea mee naneadu-wi'yoona ka mu numu tuukwe'emena, yise mu nanesootuhi-wi'yoona tuwazoo. ");
INSERT INTO paoNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Soo Te Pabe'e yise ka banunadu Gennesaret mee naneadu-kumaba wununa, ewow numu Te Naa unnepu tunedyooedyakwe. Ewa'yoo numu oo na'oonnakwi manepunne ka Te Naa unnepu soonakana. ");
INSERT INTO paoNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Waha'yoo sake o. Mooasoo soo mu tuukwidu Simon mee naneadu-no ka sake-wi'yoona tsebooese, ka puma tu tuukwina tzabazagadyakwe. ");
INSERT INTO paoNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Soo Te Pabe'e ka Simon sake-wi tsebooese, oo natzemange tuungu sagwane ka bakumanatoo. O'no oweoo ka sake-wi soo Te Pabe'e katuna ka Te Naa unnepu numu tunedyooe. ");
INSERT INTO paoNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Ka mu numu yadooemakwuse, soo Te Pabe'e ka Simon mee netamma, “U sakwa ma tookapu baa-ga-witoo natsenooyooe ka puma mu tuukwina ka baa-witoo tzasawekuse, mama tuukwina tutzakadukooha.” ");
INSERT INTO paoNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Soo Simon yise ka Te Pabe'e meeoo netamma, “Nu u nakabetseakwu tooe mooasoo numme togawano too'e tuukwise sapa gi hemma tzaku'a.” Umu yise ka Te Pabe'e netamma-kwitu wukwihoo. ");
INSERT INTO paoNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Tubetse ewa'yoo pakwe yise natzakadu, soo puma mu tuukwina yise natakebu'e. ");
INSERT INTO paoNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Umu ka mu tu pupua'amu James noko John mee nananeadu ka sumuoo sake-witu namatoo bise, mu natummatzi tuungu. Mu James-no John ka umu-baa pepetuoogase umu namekoosoo ka mu sake kaanokuhoose, mu sake yise nano too'e patatsopedihoo. ");
INSERT INTO paoNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","10","Soo Simon Peter ka tu pupua'amu James, John-no yise, o'no oo pudu sopedakwatoo ka Te Pabe'e unu pooha-gana, umu ka ewow pakwe mu tuukwina poonnese, soo Peter yise ka Te Pabe'e-matoo nanesootuhikooha mee unnewunu, “Uda! Nu ooosapa tuma'emukwanummedu. U tubetse besa'yoo. U sakwa gi nu tzage'e manepana.” Soo Te Pabe'e yise meeoo ka Peter netamma, “Gi nu-ma suipana. Wuna'me u pakwe-ganummedu. U sakwa nu-ma tsabegase ka Te Naa besa unnepu mu numu tunedyooemea e tummatzina.” ");
INSERT INTO paoNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Umu yise no'yoona ka bakumana petuse, Simon, James yise John no'oko ka tu hemma matusookwunise ka Te Pabe'e nakatzimodu mane. ");
INSERT INTO paoNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Umu yise ka Te Pabe'e-no meana ka numu nogadu-kwi petuga. Sumu'yoo nana unu tookoo uayidu onona, ka Te Pabe'e-baa petugase oo nanetsagwayina meeoo oo netamma, “U sakwa e mabesaku ka meeoo soonammena.” ");
INSERT INTO paoNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Soo Te Pabe'e Jesus yise oo-ma pooha matuguse mee oo netamma, “Nu u mabesakukwu, u besa manekwu. ");
INSERT INTO paoNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Ka besa manese. U sakwa ka mu Jew numu nanesootuhiwabe natzapoonnekuse ka Moses tamme tunetamma-kwa'nesoo ka Te Naa tuwuniku ka te tookoo uayina namabesaku-kwitoo. Gi saa'a mu numu tuukwepana ka ume e mabesakuna.” ");
INSERT INTO paoNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Ooonne'yoopana soo nana ka besa manise ka mu numu tuukwekooha ka Te Pabe'e-witu, yise ewa'yoo numu tuoegoedu oo takoona petu ka besa tu manekwuna sookwina. ");
INSERT INTO paoNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Soo Te Pabe'e yise kwinga'a numu-wanatoo mease nanesootuha'e. ");
INSERT INTO paoNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Saa'a soo Te Pabe'e ka mu numu tunedyooedyina ka Te Naa-witu. Susumudu naana ka mu numu Jew tumayohona numu tunedyooedu, susumudu yise mu nanesootuhibu tunedyooedu-nagatu Pharisee mee nananeadu mana kwinga'akwitu too'e petugase oonow aata'a. Soo Te Pabe'e Jesus ka Te Naa Besa Pooha-ma numu mabesakudyakwe. ");
INSERT INTO paoNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Huu'yoo nanana kapa-wikoo ka gi yutsungadu numu tzakwuhuna petuga. Umu ka Te Pabe'e-matoo napoohameapana, ");
INSERT INTO paoNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","ewow numu ka nobe-wikoo umu gi hownnekoo oe tzoonoo'a. Umu yise ka nobe-kooba tupoyase oo-koobatu tzatawagase ka kapa-nokosoo tobongo ka tuoeyaedu tzakweku ka Te Pabe'e-kobenatoo. ");
INSERT INTO paoNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Soo Te Pabe'e oo sopedakwatoo ka mu nanana puu-ma unu nasoonatza'e yise ka gi yutsungadu nana meeoo netamma, “E pua'a, nu ka u tuma'emukwana soomu'wakwu.” ");
INSERT INTO paoNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Umu Jew numu tunedyooedu mu Pharisee mee nananeadu-no o aatadu mee tusooyugwe manepunne, “Esoo hayoo suda na'unnedu unni. Masoogina Te Naa mee nasooyugwe. Soo Te Naa suu'mu ka numu tuma'emukwana soomu'wa.” ");
INSERT INTO paoNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","23","Soo Te Pabe'e yise oo sopedakwatoo ka mu tusooyugwena, yise meeoo mu netamma, “Mu gi e naka'oedyukute ka mu numu tuma'emukwana e soomu'wa pana mu oo poonnekwu ka eka nana e mabesakuse. ");
INSERT INTO paoNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Mu yise oo sopedakwadookwu nu eka teepu-kooba ookow poohabe hee-ga'yoo ka mu numu tuma'emukwana e soomu'wana.” Soo Te Pabe'e yise ka nana gi yotsungadu meeoo netamma, “Wunuoose ka u kapa nobe-witoo tzakwuka.” ");
INSERT INTO paoNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Soo nana ka tu kapa tzakwuhuna nobe-kwitoosoo meana, ooosapa meeoo unneno'o, “Te Naa tubetse besa'yoo.” ");
INSERT INTO paoNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","No'yoona mu numu oo soo'oedyukuna meeoo punno'o, “Te Naa tubetse besa'yoo. Numme nanabesa namanedu yaa tabeno poonne. Numme gi hannano'o yooonnekoo poohabe poonnedu.” ");
INSERT INTO paoNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Sumu'yoo nana Levi mee naneadu ka oonow putoogoo numu tzoonooadyakwe mu numu tunekwina tumasumudoodyakwe. Soo Te Pabe'e ka oetoo meana ka o oo katu oo poonnese yise meeoo oo netamma, “U sakwa umu-no nu-no manenumme.” ");
INSERT INTO paoNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Soo Levi yotseoose, oo-no tzabeka. ");
INSERT INTO paoNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Ka Levi nobe-wi'yoona paba natabetuka yise saa'a soo Te Pabe'e ka Levi nobe-witoo oo-no mea mu Pharisee mee nananeadu tuka. Ewa'yoo numu tumasumudoodu o, tuma'emukwadu mee nananeadu umu-no tuka. ");
INSERT INTO paoNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Mu Pharisee ka Te Pabe'e umu-no tuka oo poonnese, ka umu oo nakatzimodu nesootzemana meeoo mu netamma, “Umu gi toge manakwe umu-no tuka, umu tumasumudoodu mu nanumu suda dyugwedu.” ");
INSERT INTO paoNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","32","Soo Te Pabe'e ka oo unnena nakase, meeoo yise unakwe, “Nu yaa ka teepu-kooba namanumudoopu ka mu tuma'emukwadu Te Naa-witu tuukwekwuse. Ka mumme mooasoo besa nasooyugwedu numu nu gi hownnekoo mu tummatzi-wa'ne'yoo.” ");
INSERT INTO paoNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Umu Pharisee nanesootuhidu naana yise ka Te Pabe'e meeoo netamma, “Umu John nakatzimodu ka numme Pharisee-no gi tukapana nanesootuhiyakwe. How yise umu ume nakatzimodu gi punno'o ooosoo tumatugu?” ");
INSERT INTO paoNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Soo Te Pabe'e mee mu nanekwegea, “Nu togesoo umu-no'yoona, pudu nodukwadoodu-kwa'ne umu puu ka nanano'yoona besa sokwama. ");
INSERT INTO paoNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Pana pudusoo nu gi umu-no'yookwu, o'no yise saa'a umu e nakatzimodu gi tukapana nanesootuhikwu.” ");
INSERT INTO paoNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Soo Te Pabe'e ka mu tunedyooena mee tuwazoo mu tuukwe, “Ka oohoo a manepunne mu gi hownnekoo ka mu numu pudu tumayohope no'oko ka mumme putoogoo mooa tumayohope-noko mayua-wa'ne'yoo. U pudu wanapu ka mooa wanapu-ma dotsanase, oosoo gi toge tubuakwu. ");
INSERT INTO paoNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","38","Mu gi hownnekoo eka mumme pudu natunetammakuna ka mooa tumayohope noko mayua-wa'ne'yoo. ");
INSERT INTO paoNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Pana mu numu ka mumme e pudu tumayoho tuunguna gi nakabetzape. Mu ka mummesoo mooa tumayohona soonoyugwena. Mu ka mooatupu atsa tutza'emukwa baa hebedu numu-wa'ne'yoo. Oosoo puu gi pudu atsa tutza'emukwa baa petzape oosoo meeoo, ‘Soo mooatupu atsa tutza'emukwa baa besa kamma.’ ” ");
INSERT INTO paoNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Ka tu nanesootuhi tabeba-wi soo Te Pabe'e yise umu pumme nakatzimodu-no oona tubewabe-too meana unu tseagoena ka tumasuape-matu mabokamena oo mahangena o tukamena esoo mooasoo natumayohodu. ");
INSERT INTO paoNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Mu Jew numu nananesootuhidu, Pharisee mee nananeadu, mu poonnena, ka Te Pabe'e meeoo netamma, “Umu u nakatzimodu ka te Jew tumayohona gi heesoobedya. Umu ka tumasuape mahanegena oo tukana esoo nanesootuhi tabeba gi numu hemma how yukweno'o. Esoo tamme Jew numu mooa tumayohona, o'no nanesootuhi tabeno gi numu hemma how yukweno'o 'yoo manakwe.” ");
INSERT INTO paoNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Soo Te Pabe'e yise punno'o meeoo mu netamma, “Mu sakwa uga oo nea ka o'nosoo soo besa tamme-kooba katukwudu, David mee naneadu, punno'o ka te Jew tumayohona takopapu tu pupau'amu-no ka tseagoena. ");
INSERT INTO paoNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Soo David ka Te Naa nanesootuhi nobe-wi petugase, ka tu pupua'amu-no ka pooha tukaba tuka, umu nanesootuibu numu tunedyooedu suu'mu tukana. Oosoo ka Te Naa-nakwana gi hownne'yoo.” ");
INSERT INTO paoNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Soo Te Pabe'e meeoo mu netamma, “Nu yow Mu Pabe'e. Nu no'oko hemma ka mu nanesootuhi tabeba-wi mu nemadabuekwu.” ");
INSERT INTO paoNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ka tu nanesootuhi tabeno soo Te Pabe'e ka mu nanesootuhidu-baa petugase Te Naa-witu mu numu tunedyoo'e. Sumu'yoo nana tumadinakwatu tu mi pasatopo'nepu gi mayutsungadu oe numu-no. ");
INSERT INTO paoNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Umu Pharisee nanesootuhibu numu tunedyooedu, mu Jew nanana Pharisee mee naneadu-no ka Te Pabe'e besa eya'epunne oo sookwaha'yoo howga saa'a ekow nana oo mabesakudooa. O'no tabeno gi hemma how nuugweno'o, ooka saa'a how kadoo'oo oo mayugwekudooa. ");
INSERT INTO paoNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Soo Te Pabe'e oo tusooyugwena sopedakwatoo. Soo Te Pabe'e meeoo ka nana netamma, “Yaatoo kemma.” Soo nana ka Te Pabe'e-baatoo meahoo. ");
INSERT INTO paoNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Soo Te Pabe'e ka umu pumme poonnepunnedu meeoo netamma, “Ka pabow tabeba-wi gi hemma how nuugweno, o'no haa'a suta'yoo? Yise o'no tabeba haa'a mu gi ha'yoo oo sooyukwe o'no haa'a mu gi namabesakupana gi hownne'yoo? O'no haa'a ka pabow mu tabebano'o, ya'epana gi hownne'yoo?” ");
INSERT INTO paoNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Soo Te Pabe'e yise mu poohwise yise ka gi mayutsungadu meeoo netamma, “Matuhe.” Oosoo yise matuhe oo mi namabesakuhoopu. ");
INSERT INTO paoNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Umu tunesootzemadu suta'a yise nanano mee tunehane, “Tamme sakwa ka Jesus batsa.” mee'e. ");
INSERT INTO paoNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Soo Te Pabe'e yise oona giba-matoo mease togawano nanesootuha'e ka Te Naa-matoo. ");
INSERT INTO paoNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Ookow mooa awamooa soo Te Pabe'e ka umu pumme nakatzimodu namatoo ba'e. Sumu mano'yoona wahamatsebooekudu (12) umu-nagatu netutzea tu yadooawabe manekwudu. Umu mee nanane'a: ");
INSERT INTO paoNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Simon, soo Te Pabe'e Peter mee ookow nea'a; Andrew, Peter pabe'e, James, John, Philip, Bartholomew, ");
INSERT INTO paoNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matthew, James, oo naa Alphaeus mee naneadu, Simon, numu-no watze nagoedu mee tuwazoo naneadu, Judas ookow naa James mee nane'a, ");
INSERT INTO paoNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Soo Judas punno'o saa'a ka tukwutumadu ka Te Pabe'e-matoo nemanekukwudu. ");
INSERT INTO paoNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Soo Te Pabe'e yise ka mu pumme nakatzimodu-no ka giba-ma'yoona wuekese, oo tookanakwa yamoso-wi petugonnohoo. Ewa'yoo numu tooe hano'yoona tooe petudyipunne ka Te Pabe'e-baa. ");
INSERT INTO paoNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Susumudu ka Te Pabe'e nakahooyapunnedu, susumudu tuoegoedu natzatogedu, mu tsoapagoedu punno'o oo-baa natzatodu. ");
INSERT INTO paoNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","No'yoona mu tuoegoedu natzatodu ka Te Pabe'e tzamadyakwe ka oo pooha no'oko numu mabesakute. ");
INSERT INTO paoNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Soo Te Pabe'e yise ka umu pumme nakatzimodu meeoo netamma, “Tooe tamme ka meno'o tutuha manepana nasootuha'e, ka saa'a soo Te Naa yise unusoo te mabetseakwu. ");
INSERT INTO paoNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Tooe tamme ka meno'o tseagoepana nasootuha'e, saa'a tamme ka Te Naa-baa'yoona gi tutuugekwu. Tooe tamme yaano ka suda sokwamapana nasootuhikwu, saa'a tamme Te Naa-baa'yoona besa sokwamakwu. ");
INSERT INTO paoNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Mu ka mu numu mumme gi petzabena gi too mu-no mu napua'ana, nanasuda nu-koobatoo mumme tu netamma sapa gi suda sokwamapana mu besa nasootuhikwu. ");
INSERT INTO paoNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Mu sakwa gi oo nasoomenakwapana tooe how mumme tu yugwe, mumme suda tu netamma sapa. Mu ka saa'a Te Naa-baa petugase unusoo besa nasootuhikwu. Mu nanamooatupu puu mu Te Naa yadooawabe nanasuda matugu pana, meno'o yise umu ka Te Naa-baa'yoona besa sokwama, ka besa pumme tu sootuhise. ");
INSERT INTO paoNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Pana soo tooe haga tooe ka meno'o besa manepunne ka yaa teepu-kooba'yoona ookowsoo nasootamana, gi ha'yoo sokwamana, gi hemma toge soobedyana, umuoo gi nasootuhikwu, ka mooasoo umu yaa teepu-kooba'yoona besa sokwamana. ");
INSERT INTO paoNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Mu ka meno'o mu hee-gana paba sooyugwena oosoosoo mu takonepunnena mu gi hownnekoo nasootuha'e-wa'ne'yoo. ");
INSERT INTO paoNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Mu ka mu numu besa mu nemadabuena petukuna, ka saa'a mu gi nasootuhikwu. Mu numu puu ooosapa ka mu yaahoo Te Naa yadooawabe mee'e mumme tu nemooaka mu besa mu sooyugwe. ");
INSERT INTO paoNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Pana nu mu tuukwekwu tamme sakwa te wohomu besa soobedya yise besa mu matugu tooe umu gi te soobedya sapa. ");
INSERT INTO paoNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Ka tamme mu nekusegea, tamme sakwa ooosapa nanesootuhi besow umutoo nekwina. ");
INSERT INTO paoNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","31","Nu mu tuukwekwu tooe suda tamme tu matugu sapa, tamme sakwa gi umu-no nagoepana. Ka sumunakwatu te soba namatake'ehoose, tamme sakwa oo sukwe tutzomunaku. O'no oosoo ka sumunakwatu matake'yookwu tuwazoo. Tamme sakwa ka numu nakutzikuna gi hownnekoo oo tumanagakuna, oosoo ka te kwasu kwuse sapa, oosoo gi hownne'yoo tamme te wunagapu oo gease tuwazoo. Ka mu numu hemma tamme mu natuungu, tamme sakwa mu gea. ");
INSERT INTO paoNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Soo Te Naa gi besa'yoo numu mee te neakwu tamme ka sukwe numu tamme besa soobedyadu besa soobedyana. Mu suta'yoo numu puu besa nanasoobedya. ");
INSERT INTO paoNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Tamme gi besa manakwe ka besa te matugudu suu'mu besa matuguna. Mu gi tunaka'oedyukudu pana besa mesoo nanamatugu. Tamme sakwa no'obatusoo numu unu soobedya ka Te Naa-wa'ne'yoona. ");
INSERT INTO paoNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Tamme sakwa ka mu numu tamme nagutzikudu suu'mu tummatzina, tamme tookwa gi besa manakwe. Mu suta'yoo numu puu nanatummatza'e ka punowsoo oo namakodyukwuna sopedakwatoona. ");
INSERT INTO paoNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Tamme sakwa te wohomu besa soobedya, o'no soo Te Naa besa te sootuhikwu. Tamme ka Te Naa tamme-koobatu-wa'ne'yookwu. Soo Te Naa numu sootuhi tooe gi besa mu tumatugu sapa. ");
INSERT INTO paoNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Soo Te Naa puu tutuha numu soobedya, tamme sakwa punno'o ooosoo. ");
INSERT INTO paoNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Gi tunesootzemapana, gi tuwazoo suda numu netammapana, o'no soo Te Naa besa te sooyugwekwu. Tamme ka mu numu suda tamme matukupu soomu'wase, soo Te Naa punno'o te tuma'emukwana soomu'wakwu. ");
INSERT INTO paoNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Tamme ka mu numu tummatzina, soo Te Naa ookow punowsoo te makodyukukwu. ");
INSERT INTO paoNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Tamme sakwa unu besa a nakaduguse, o'no tamme kukumma'akoosoo mesoo tunedyoo'e. Tamme ka gi hemma nakasopedakwadoopana numu too'e tunedyooena, soo numu puu gi tubootabuena kumma'akoosoo gi tubootabuedu numu tzakadu-kwa'ne'yookwu. Umu nanosoo a tawaga-kwitoo sawehookwu. ");
INSERT INTO paoNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Soo numu tunedyooedu ka natunedyooedu ooonakwasoo tusopedakwatoo. Pana tamme ka no'okosoo hemma natunedyooese, tamme ka numu tunedyooedu-kwa'nesoo tusopedakwadookwu. ");
INSERT INTO paoNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","42","Tamme sakwa gi te pua'a nesagwikupana, ka sagwane oo tuma'emukwase. Tamme sumuna ookow ooonakwasoo tuma'emukwa. Hownnekoo yise mu ka mu pua'a pooe-wikoo tuutsekoo hemma mesoo poonne ka mummesoo pooe-wi hemma egease sapa. Mooe'ugasoo mu sakwa mummesoo pooe-witu tzatsebooase, o'no mu yaatu poonnena, ka mu pua'a mesoo tummatza'e. Ooosoo sakwa mu ka suda mu tumatuguna yugwese, o'no mu ka mu pupua'amu mesoo tummatza'e. ");
INSERT INTO paoNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","No'obatusoo tumasuape tu tupooe-kwa'nekoosoo suakute. Mu tumasuape ka besa'hoo a pooe-nakwana suaketu besa'yoo. Mu sutakoo tsa'abu pooe-nakwana suaketu-kwa'ne, mu punno'o gi besa'yoo. ");
INSERT INTO paoNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","No'obatusoo tumasuape ka pummesoo pooe-kwa'nesoo suaketu. ");
INSERT INTO paoNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Soo numu ka tumasuape-kwa'nesoo tu mane-makoo nasopedakwadookwu, tooe ha'oo soo numu ka besa'yoona tooetoo suta'yoona. ");
INSERT INTO paoNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Mu ka ‘Jesus E Pabe'e,’ mee'e natubangana mu sakwa e nakabetseayi. ");
INSERT INTO paoNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Ka besa e nakatumayohokudu nu tuukwekwu. ");
INSERT INTO paoNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Tupe-kooba besa nobe-toodu-kwa'ne'yoo, oosoo puu ohobu gi namanabue oo matabue. Tooe baa unu hoo'oo ka teepu putoohakwitu patokwanawunu sapa gi ano'a, oosoo ka besa namadabuepuna. ");
INSERT INTO paoNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Mu numu ka e unnena nakapana gi oo nakatumayohodu, ka nana tu nobe teepu-kooba oo sagwa matabuedu-kwa'ne'yoo. Soo oo nobe-toona ka baa unu hoo petuse kadoo'oo o patadyoomedikuoo. ");
INSERT INTO paoNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Soo Te Pabe'e ka mu ewow numu tunedyooemakwuse, oe'yoona mease, ka Capernaum mee naneadu-wisoo kodyu petuga. ");
INSERT INTO paoNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Soo mu tukwutumadu moohedu wawa'a gi Jew numu, sumuoo ka pumme tummatzidu-matu unu soobedya. Oosoo oo tummatzidu unu tuoeyina, ya'ega'a. ");
INSERT INTO paoNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Soo wawa'a gi Jew nana ka Te Pabe'e onow pupaa petugana nakase, mu Jew numu moohedu Te Pabe'e-matoo taya, oo bina ka pumme tummatzidu oo mabesaku tuunguna. ");
INSERT INTO paoNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Umu ka Te Pabe'e-baa petugase, mee oo netamma, “U sakwa eka wawa'a nana tummatzi. ");
INSERT INTO paoNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Soo wawa'a nana tamme Jew numu unu soobedyana, ka te nanesootuhi nobe te matabuekupu.” ");
INSERT INTO paoNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Soo Te Pabe'e yise umu-no mease ka wawa'a nana nobe tzage'e mu manigase, soo tukwutumadu moohedu tu pupua'amu ka Te Pabe'e-matoo taya mee oo netammana, “Nu sukwe wawa'a. Mu Jew numu numme wakwawa'a nuutumooedu. U sakwa gi ne nobe-kwi egeapana, gi hownne'yoo. ");
INSERT INTO paoNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Nu gi maawa'ne'yoona, gi u-matoo mea-wa'ne'yoo. Nu u soo'oedyukute u sukwe yadooahoose, oosoo e tummatzidu besa manekwu. ");
INSERT INTO paoNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Nu punno'o ka numu nanemadunagadyina sopedakwadoo. Nu puu ka nu-koobatusoo unnetoosoo manakwe.” ");
INSERT INTO paoNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Soo Te Pabe'e ka meeoo na'unnedu nakase, mee ka ewow numu netamma, “Yow yise soo nana tubetse tunaka'oedyukudu. Tooe gi tamme Jew numu-matu pana unu tunaka'oedyukute.” ");
INSERT INTO paoNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Ka tukwutumadu moohedu pupua'amu ka oo nobe-witoo kodyukase, soo oo tummatzidu mooasoo besa manepu. ");
INSERT INTO paoNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Oogow mooo'a soo Te Pabe'e umu tunakatzimodu-no yise ewa'yoo numu punno'o umu-no ka Nain mee naneadu-kwitoo kemmana. ");
INSERT INTO paoNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Sumu'yoo tooebetse ka mogo'ne penebe dooa ya'e. Soo oo pea o'nosoo tu kooma ya'ekupu. Ewa'yoo umu oo pea nonopua'amu oo-no mea ka tu tooa oo nomatugugakwuse. ");
INSERT INTO paoNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Soo Te Pabe'e ka mu wegease ka kadoo'oo manidu pea tutuha oo soobedyase mee oo netamma, “Gi yagapana.” ");
INSERT INTO paoNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Soo Te Pabe'e yise ka ya'edu tzamahoose, mu oo tzagwuudu yise konno pebu'ahoo. Soo Te Pabe'e ka ya'epu tooebetse'e mee netamma, “Yotsehoo.” ");
INSERT INTO paoNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Soo tooebetse katuhoose yadooakooha. Soo Te Pabe'e punowsoo nobe-kwitoo mu taya. ");
INSERT INTO paoNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Mu numu o konnopunnedu meeoo nana'unnekooha, “Uune! Esoo togesapa unu pooha-ga'yoo. Soo Te Naa te sootuhina, eka unu pooha-gakoo tu yadooawabe, tamme-matoo tayapu.” ");
INSERT INTO paoNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Mu numu yise oo nanatuukwekooha ka Te Pabe'e manipu, o'no yise no'yoona numu ka teepu-koobakwitu ka Te Pabe'e-witu naka, mu numu mana tzatzage'e-witu teepu-ga'yoo tooe. ");
INSERT INTO paoNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Mu John pupua'amu ka John tuukwe'e no'oko ka Te Pabe'e mane-kwitu. ");
INSERT INTO paoNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","20","Waahoo pumme pupua'amu-matu soo John taya ka Te Pabe'e-matoo. Soo John mee mu netamma, “Mu sakwa ka Jesus tutubenga, ‘U haa'a yow Te Pabe'e, pute soo Te Pabe'e saa'a petukwu?’ ” ");
INSERT INTO paoNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Ka oo-baa pepetugase, soo Te Pabe'e no'obatusoo tuoegoedu numu mabesakute: tsoapagoedu, gi tubootabuedu, tooe hownnekoo tooe tuoebu. ");
INSERT INTO paoNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Soo Te Pabe'e mu nanekwegea, “Mu sakwa ka John tuukwe ka mu poonnena, mu nakana tuwazoo: ka umu gi tubootabuedu numu tubootabue manese, mu toyomodu numu besa momona, mu gi nakatawagadu numu nakatage mu manese, mu numu uagoedu besa manese, mu tuipu numu namayodase, yise ka mu tutuha manedu numu ka Te Naa besa unnepu mu tuukwe. ");
INSERT INTO paoNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Pana mu ka ooosapa e naka'oedyukuna, gi nu-ma nasookwina, mu nasootuhikwu.” ");
INSERT INTO paoNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Ka mu John pupua'amu kokodyukase, soo Te Pabe'e ka John-witu mu numu tuukwe'e, “Ka o'nosoo nuga-kobenasoo, ka oona giba-ma umu uga ka John-baa petugayakwe. Soo John gi waha-tamme tusooyugwedu nana. ");
INSERT INTO paoNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","26","Soo John gi nanenagadu namasoo'a. Pana umu gi oo-makoo oo-matoo me'a. Mu ka John nakapunnekwuse oo-baa petuga, soo John ka Te Naa yadooawabena. Soo John ka umu o'nosoo Te Naa yadooawabe ooonakwa besa'yoo. ");
INSERT INTO paoNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Soo John ka Te Naa poena'ewabe. O'nosoo ka John-witu nabotugu soo Te Naa mee e netamma, ‘U-kobenasoo ka teepu-koobatoo nu e poena'ewabe tayakwu, ka mu numu ume petukwu-kwitu oo tunesootabue tuunguna.’ ");
INSERT INTO paoNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Soo John no'oko numu ooonakwa besa'yoo. Pana saa'a no'yoona numu nu-toohatu, ka John ooonakwasoo nasootuhikwu.” ");
INSERT INTO paoNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Ka mu numu mu tuma'emukwadu mee nananeadu-no ka Te Pabe'e John besa oo nemadabu'e, umu besa sokwama ka baa-wi pumme oo matzakadyakwe. Umu meeoo, “Soo Te Naa tubetse besa'yoo.” ");
INSERT INTO paoNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Pana umu nanesootuhibu numu tunedyooedu gi nanekwahana, ka John baa-wi namatzaka tuunguna, ka Te Naa pumme netamma-kwa'ne. ");
INSERT INTO paoNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Soo Te Pabe'e yise meeoo, “Nu mu gi tunaka'oedyukudu-kwitu mu tuukwekwu. ");
INSERT INTO paoNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Mu mu doodooake-wa'ne gi besa mu pupua'amu-no tuate'a. Mu pupua'amu sumuna mee unakwe, ‘Numme mu tunekwukukwu, mu saa'a nugagonno. Pana mu gi nuka.’ Mu pupua'amu yise mee tuwazoo mu netammakwu, ‘Numme ka suda mu sokwama, mu-no sagwikwu, pana mu gi sagwa'e.’ ");
INSERT INTO paoNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Soo John ka petuse, gi tuka, gi tuwazoo atsa baa hepe. ‘Soo John numu sukwe poohadu,’ mee mu. ");
INSERT INTO paoNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ka nuka mu-baa petugase, nu tukana, hepe, mu yise e nesootzema mee unnena, ‘Oosoo nana ewa tukana, sukwe baayina, umu tuma'emukwadu pupua'amu-gana.’ ");
INSERT INTO paoNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Umu sokwamadu numu ka Te Naa unnepu nakasopedakwadoona, ‘Besa'yoo,’ mee unnekwu.” ");
INSERT INTO paoNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","37","Soo nana Simon mee naneadu ka umu Pharisee mee nananeadu nanesootuhidu-nagatu, ka Te Pabe'e-nabatoo ba'e, oo tuka tuunguna. Sumu'yoo otuoosoo mogo'ne gi toge tumatugudu sapa tooe ka Te Pabe'e ka Simon nobe-wi'yoona ka mu ewa tukana naka. Soo mogo'ne yise besa kwanadu nakwanana tupe-ma namadabuepu osa-wi nakedadu hanena, ka Te Pabe'e-baa petuhooga. Soo Te Pabe'e o sekedabena tukadape, soo mogo'ne oo pepa wunuhoo petu. ");
INSERT INTO paoNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Soo mogo'ne yise yagana, ka oo kuku-koobatoo yaga pasawehoo. Yise meatzedose tu tzopuhu-ma oo mabasakuse, oo kuku mootuhikwuna'e, yise ka besa kwanadu nakwana'a oo kuku-koobatoo totsakwatese oo mawo'nge. ");
INSERT INTO paoNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Soo Simon ka mogo'ne yoo ka Te Pabe'e sootu'nagana poonnena oo sootu'adyina meeoo oo soobedya, “Esoo Jesus tookwa gi ka Te Naa pooha hee-ga'yoo. Masoo sakwa ka Te Naa pooha uga hee-gana soo oo pooha oo sopedakwadookwu, ka mogo'ne suta'yoona, o'no masoo sakwa uga gi ka mogo'ne natzamakupana.” ");
INSERT INTO paoNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Soo Te Pabe'e yise ka Simon soonammena pooha sopedakwadoo, meeoo yise oo netamma, “Nu besasoo u tuukwekwu.” Soo Simon yise ka Te Pabe'e mee netamma, “Ha'yoo u e tuukwekwu?” ");
INSERT INTO paoNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Soo Te Pabe'e oo nanekwegease meeoo, “Waha'yoo numu puu ka sumuoo numu nakutzikute. Sumu'yoo ewatse'e oo nakutzikute, sumu'yoo punno'o huutse'e oo nakutzikute. ");
INSERT INTO paoNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Umu waha'yoo yise gi hownnekoo oo tumanagakute. Soo mu kutzidu yise mee mu netamma, ‘Nu ka nuka mu nakutzikuna soomu'wakwu.’ Hanotu umu-matu yise unu oo soobedyakwu ka besa pumme oo sootunagase?” ");
INSERT INTO paoNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Soo Simon yise ka Te Pabe'e meeoo nanekwegea'a, “Soo ewa oo nakutzikudu, mee tuwa nu.” ");
INSERT INTO paoNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Soo Te Pabe'e ka mogo'ne-tamme nakwumunase, ka Simon meeoo netamma, “Nu ka u-baa petuse, u puu gi ka pukwi e tabatsagakwuna e bawununakute. Esoo mogo'ne puu ka e kuku tu yagapu-ma pakedyase yise ka tu tzopuhu-ma a mabasakute. ");
INSERT INTO paoNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Esoo mogo'ne puu ka besa nu-matoo soonammese e kuku mootuhikwuna'e, u puu gi e mootuhi ka ha'oo besa nu-matoo soonammena ka e petuse. ");
INSERT INTO paoNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ka besa kwanadu nakwanana e kuku-koobatoo totsakwate e kuku onokoo mawonge u puu yoohoo-ma sapa gi e tzopuhu mahane. ");
INSERT INTO paoNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Tooe masoo mogo'ne ewa tuma'emukwakepana, nu yise ka oo tuma'emukwapu soomu'wakwu, masoo ka unu e soobedyana. Nu ka mu numu tuma'emukwadu tuma'emukwana soomu'wa. Susumudu numu ka sagwane tuma'emukwana mee nasooyugwena gi unu e heesoobedya.” ");
INSERT INTO paoNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Soo Te Pabe'e yise ka mogo'ne meeoo netamma, “Nu no'oko ume tuma'emukwana soomu'wa.” ");
INSERT INTO paoNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","“Haga esoo numu tuma'emukwana soomu'wadu mee naneyugwedu?” mee mu numu tuka aatadu nanatubengu. ");
INSERT INTO paoNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Soo Te Pabe'e yise ka mogo'ne meeoo netamma, “U ka nuka naka'oedyukuse u namagwetzoikwu. Besa sapa manena mea.” ");
INSERT INTO paoNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Ka saa'a yise soo Te Pabe'e mana tooe hanotoo tooe ka teepu tanamooanumme ka Te Naa besa unnepu mu numu tunedyooena, mu oo nakatzimodu ooosapa oo-nosoo; ");
INSERT INTO paoNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","mu momoko'ne punno'o umu-no. Sumu'yoo mogo'ne Mary Magdalene mee naneadu oo-nagakoo soo Te Pabe'e uga natakwatsukwuhoo (7) tsoapa tayakwunipu ");
INSERT INTO paoNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","yise ewa'yoosoo momoko'ne unu besa mamanepunnedu ka Te Pabe'e umu oo nakatzimodu nokosoo hemma mu sookwina mu tumukuna mu tummatzidu. ");
INSERT INTO paoNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Ewa'yoo numu mana'yoona tooe ka Te Pabe'e-baa petudyakwe yise soo Te Pabe'e mu yadooena, mu natugwengayakwe mee unnena, ");
INSERT INTO paoNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Soo nana tumasua-ga. Yise susumudu soo oo pooe tumasua-matu ka a nadapodo-witoo sawe mea, yise ka puuwana mu kwakwape mu numu umu-koobakwi mona mu tatuikuna umu gi na'a. Mu hootseba'a yise punno'o mu sukwe soo'a. ");
INSERT INTO paoNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Susumudu soo oo pooe punno'o unu tupe-gakwitoo sawena, yabe naahookese, yise yabe tagwazuoo ka gi baa-gana. ");
INSERT INTO paoNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Susumudu a pooe punno'o tsaabu-nagatoo sawehoose, soo tsa'abu yise umu-no naana mu tatzatsebooahoo. ");
INSERT INTO paoNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Susumudu besow teepu-koobatoo sawehoose, yise besa na'a, nana'ewa pooedoo'a. Mu sakwa besa e nakapunne.” ");
INSERT INTO paoNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Umu Te Pabe'e nakatzimodu yise oo tubenga, “Ha'yoo oosoo unakwe?” ");
INSERT INTO paoNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Soo Te Pabe'e mee unakwe, “Nu ka Te Naa tuwatzetuguna mu tuukwekwu, mu mooasoo oo nakasopedakwadoona nasootuhipu; pana susumudu numu gisoo ookow nasootuha'e, ooonne'yoona nu meeoo mu natuugwengakute. Tooe mu numu e poonnepana, umu gi e posopedakwadoo. Tooe umu e nakapana, gi e nakasopedakwatoo. ");
INSERT INTO paoNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Soo mu nanatugwengana meeoo, soo a pooe ka Te Naa yadooa-kwa'ne'yoo. ");
INSERT INTO paoNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Susumudu ka Te Naa besa unnepu nakapana gi oo 'oedyukuna, soo gi toge'yoo yise mu tza'emukwana, mu natza'emukwadu yise ka po-koobatoo saweoopu-kwa'ne'yoo, yise gi namagwetzoi. ");
INSERT INTO paoNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Susumudu ka tupe-nagatoo sawehoopu-kwa'ne'yoo. A pooe besa oo-matoo soonamme, tamme yise tuwazoo gi tunaga-kwa'ne'yoo ka nanewohonena, tamme yabesoo tunaka'oedyukumakwu. ");
INSERT INTO paoNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Tamme ka a pooe mu tsa'abu-naga naadu-kwa'ne'yoo, susumudu ka Te Naa unnepu nakase, ewa tu hee toowana petukute, yise gi tunaka'oedyukute. ");
INSERT INTO paoNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Pana tamme ka a pooe besow teepuna namasuadu-kwa'ne'yoo. Tamme yise ka besow na'unnedu nakatuguna oo naka'oedyukute. ");
INSERT INTO paoNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Tamme ka tugootabuagunoo kootabuakuse hekooba oo wunakwu numu ooka poonne-kwi. Gi puu tamme hee-tooha oo watzetugu-wa'ne'yoo. ");
INSERT INTO paoNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Tugootabuagunoo-wa'nesoo sakwa tamme mu numu ka Te Naa unnena tuukwe. Tamme sakwa ka ooka mu naka'oedyukukwuna petsabena gi mu numu-makoo oo nekwatzetugu. ");
INSERT INTO paoNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Tamme sakwa ka Te Naa unnena besakoo nakow'ya. Tamme ka sagwane oo nakasopedakwadoona saa'a unusoo oo nakasopedakwadoo manepetugakwu. Tamme yise ka gi oo nakatuguna no'oko te natuukwepu soomu'wakwu.” ");
INSERT INTO paoNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Soo Te Pabe'e pea oo wanga'amu-no petugonnose yise gi hownnekoo oo tzage'e mane-wa'ne'yoo ka mu numu tubetse ewow. ");
INSERT INTO paoNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Soo Te Pabe'e yise meeoo natuukwe'e, “U pea-no u wanga'amu-no mabe puuwana konnopunne, u ba'e.” ");
INSERT INTO paoNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Pana soo Te Pabe'e mu numu meeoo netamma, “Umu sakwa tooe tuutooepunne, soo Te Naa tunetamma noko hemma ooonakwatu. Nu saa'a ka tunemamakwuoose, o'no saa'a nu mu tuukwedooa. Ka mu Te Naa unnepu nakabetseadu nu tubetse nanumu-ga'yoo.” ");
INSERT INTO paoNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Sumu tabeno soo Te Pabe'e umu pumme nakatzimodu-no sake-wi kuaka. “Tamme sakwa ooonakwatoo ka banunadu natsemangega,” mee soo Te Pabe'e mu netamma. ");
INSERT INTO paoNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Ka togesoo mu me'a soo Te Pabe'e uwehooka. Unu hukwabetu. Soo sake bakaanoga'a umu sumuna patatsopedihookwu. ");
INSERT INTO paoNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Umu Te Pabe'e nakatzimodu unu suihoose, oo netupoonne, mee oo netammana, “Tamme batatuihookwu.” Soo Te Pabe'e yise tupoonnese, ka hukwapa meeoo netamma, “Gi hukwapana,” ka baa tuwazoo meeoo, “Gi yutsungapana.” Umu yise gi yutsungahoo. Soo Te Pabe'e yise umu pumme nakatzimodu nesagwikute, ");
INSERT INTO paoNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","“Mu sakwa uga e naka'oedyuku.” Umu yise meeoo, “Uune! Yow esoo Te Pabe'e, unu pooha-ga'yoo. Soo hukwapa ka baa-no a nakabetse'a.” ");
INSERT INTO paoNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Soo Te Pabe'e ka mu tu nakatzimodu-no yise natsemangega, ka Galilee pa'ooenapa petuga, ka teepu Gerasenes mee naneadu-wi petu. ");
INSERT INTO paoNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Soo Te Pabe'e ka oho bakumana petugase ka sake-wi'yoona tsebooese ka sumuoo nana tsoapayidu oo tapoegea. Wuna'me manekapu soo nana gi kwaseana nummenumme. Ka po'woa-ma taage-wi mu numu nakoo-naga nobe-ga'yoo. ");
INSERT INTO paoNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Mu tsoapa unu natzooe oo mayugwe. Mu numu wehepu namadabue-ma oo too'e tzakunayipana oosoo oo mesoo wuka'akayina natzepooekuyakwe. Soo tsoapayidu nana Te Pabe'e poonnese oo-baa petuse, oo-kobena meatzedopetu. Soo Te Pabe'e ka tsoapa oo-nagakoo tayakwunikwuse soo tsoapa yise ka Te Pabe'e mee netamma, “U sakwa e tsasoopedya. U Jesus, No'oko Hemma Manumudoopu Tooa'a. U sakwa gi e wohonepana.” ");
INSERT INTO paoNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Soo Te Pabe'e yise ka tsoapa tubenga, “Ha'yoo u nane'a?” Oosoo yise mee oo nanekwegea, “Ewa'yoo mee numme nanane'a, numme ka tubetse ewa'yoona.” ");
INSERT INTO paoNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Umu tsotsoapa yise ka Te Pabe'e meeoo netamma, “Gi ka goso ooosapa nidabedu-witoo ne tayapana.” ");
INSERT INTO paoNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ewa'yoo hogu oona wuta'nedu pedakwana to'o. “U sakwa umuoo hogu-matoo ne tayase numme umu-naga manikwu,” mee mu tsotsoapa ka Te Pabe'e netamma. ");
INSERT INTO paoNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Soo Te Pabe'e yise mee mu netamma, “Muusoo too'e.” Mu tsotsoapa yise ka mu hogu-naga mani. Mu hogu yise tatanomanegase ka pagadudu-wi padatuihoo. ");
INSERT INTO paoNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","36","Mu hogu tatogudu tatanomanegase ka oo hemma manina poonnese no'oko mu numu tuukweyimo'o. Mu numu ka ooka nakowse ka Te Pabe'e-baa petugonno, soo nana ugasoo tsoapayidu besa manepu ka Te Pabe'e-kobena katu besa namasooapu-gana. Mu numu yise oo tu namanena nadugwengagonno. ");
INSERT INTO paoNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Mu numu otuoo ka Te Pabe'e-ma nasoosuise oo ta'ya. Soo Te Pabe'e mease yise ka sake-wisoo tsebooe. ");
INSERT INTO paoNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Soo nana ugasoo tsoapayidu ka Te Pabe'e-no too'e neme'a, pana soo Te Pabe'e mee oo netamma, ");
INSERT INTO paoNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“U sakwa u nobe-kwitoo mease u nanumu tuukwe ka Te Naa ume mabesakuse.” Soo Te Pabe'e yise punowsoo natsemangega. Soo nana ka pumme tu mabesakuse ka Te Pabe'e-witu no'oko numu tuukwe'e. ");
INSERT INTO paoNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Ka Te Pabe'e kodyu petuse mu numu ewa'yoo besa sokwama. ");
INSERT INTO paoNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Oona yise nana kemma, Jairus mee naneadu, mu nananesootuhidu nematugudu ka Te Pabe'e-kobena meatzedo petugase oo-matoo nanesootuhikooha yise tu nobe-witoo oo pa'e. ");
INSERT INTO paoNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Soo Jairus oo penebe padu pudu tsuadumu ya'egana. Soo Te Pabe'e yise Jairus-no mea, mu numu mu takoo'namena. ");
INSERT INTO paoNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Sumu'yoo mogo'ne hoone tuoeya'ena sumumano wahamatsebooekudu (12) tommo petuga too'e natzatona mu poopooha-ga'yoo mee naneyugwedu, gi besa oo mayugwe. ");
INSERT INTO paoNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Oosoo mogo'ne yise ka Te Pabe'e ooonakwi kemmahoose, ka oo kwasu pekwitu tzammahoo yise oosoo oo puuhana yooihoo. ");
INSERT INTO paoNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Soo Te Pabe'e yise meeoo, “Haga oosoo e tzamahoo?” Ka no'oko umu numu ooka gi nesopedakwatoo, Peter yise meeoo, “Ne Pabe'e, ewa'yoo numu u na'oonakwi u takoo'nagena!” ");
INSERT INTO paoNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Pana soo Te Pabe'e yise meeoosoo tuwow, “Haga e tzamahoo? Nu oo wuma ka e pooha tumabesakuhoose.” ");
INSERT INTO paoNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Soo mogo'ne yise ka Te Pabe'e pumme sopedakwatoose su'ise, kwebebewunu, yise ka Te Pabe'e-kobena meatzedose oo nanekwahakute no'oko mu numu nakana, ka yabesoo besa tu manina. ");
INSERT INTO paoNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Soo Te Pabe'e mee oo netamma, “U besa mani, ka e naka'oedyukuna. Mow yise ka besa manese nummenumme.” ");
INSERT INTO paoNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Soo Te Pabe'e togesoo ka mogo'ne yadoo'adyakwe, soo nana ka Jairus nobe-wi'yoona kemmadu ka Jairus meeoo tuukwe petu, “U padu mooasoo ya'eoo. Gi ka Jesus u nobe-witoo bipana, nagutza saa'asoo.” ");
INSERT INTO paoNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Soo Te Pabe'e oo nakatzama'yu ka Jairus meeoo oo tuukwewunu yise ka Jairus meeoo netamma, “Gi suda oo soonammekupana, e naka'oedyuku, u padu besasoo manekwu.” ");
INSERT INTO paoNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Soo Te Pabe'e yise ka Jairus-no nobe-witoo mea ka pepetugase gi haga tuwazoo oetoo nemeakute, mu Peter, James yise John suu'mu yise ka tsuatuma naanapua'amu-no oe tzoonooahoo. ");
INSERT INTO paoNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Umu numu oo na'oona-kwi manepunnena sakwigonno, soo Te Pabe'e meeoo mu netamma, “Gi sakwipana; esoo tsua'a gi ya'e, esoo tuusootabooekwu.” ");
INSERT INTO paoNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Umu oo-ma'yoona naneko'e, ka oo sopedakwatoona ka tsua'a ya'epu. ");
INSERT INTO paoNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Pana Te Pabe'e oo mi-ma tzakaduse, yise meeoo oo netamma, “Yotseoo.” ");
INSERT INTO paoNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Soo tsua'a yise tuponnese, yotseoo. Soo Te Pabe'e ka oo naanapua'amu meeoo netamma, “Hemma ka tsua'a manatu maka, esooga tzeaya'e.” ");
INSERT INTO paoNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Soo tsua'a naanapua'amu oo poo'ne pebu'ahoo ka tu padu yotseoose. Soo Te Pabe'e yise mee mu netamma, “Gi haka tuukwepana ka e manena.” ");
INSERT INTO paoNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Soo Te Pabe'e ka umu sumumano'yoona wahamatsebooekudu (12) pumme nakatzimodu nesumuse, yise meeoo mu netamma, “Nu yise nanesootuhibu mu numu mu tunedyooe tayakwu. Mu pooha-gana tsoapa nematzakwunikwu, noko tuoegoedu mabesakukwu tuwazoo, ");
INSERT INTO paoNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","yise meadabena mu numu tuukwe, ‘Pudusoo soo Te Naa besa te nemadabuekwu.’ ” ");
INSERT INTO paoNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Soo Te Pabe'e tuwazoo meeoo mu netamma, “Gi mu hemma hanegapana, mu kwasu, gi hemma puma mu tumukwuna tuwazoo, yise gi nadukadu. ");
INSERT INTO paoNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ka sumuoo nobe-kwi petugase gi meapana mu sakwa ononasoo kumma'a-kwitoosoo meadooa. ");
INSERT INTO paoNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ka mu numu besa na'unnepu gi mu naka'oedyukute, ka umu-baa'yoona meana, ka koosebu mu moko-makoo tata'neka. Ka 'yoo mu manena oo sopedakwadookwu umu suda manakwe ka gi mu nakapunnena. ");
INSERT INTO paoNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Mu yise meana nanesootuhibu mu numu tunedyooena yise ka tuoegoedu mabesaku mea'a tuwazoo.” ");
INSERT INTO paoNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","9","Ewa'yoo mu numu ka Te Pabe'e nesoobedyana, yise umu-matu meeoo, “Ha'oogina masoo Elijah?” umu-matu meeoo. “Oosoo Jesus ka umu Te Naa o'nosoo tuukwewabe-kwa'ne'yoo.” Mu Jew numu pabe'e Herod mee naneadu ka Jesus-witu nakase, yise meeoo, “Nu ka mu tukwutumadu ka John batsa tuungu. Oosoo John yise sumuna tuusootabuepu.” Soo Herod yise ka Te Pabe'e nepoonne. ");
INSERT INTO paoNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Soo Te Pabe'e ka mu tunakatzimodu-no numu-wanatoo mea ka Bethsaida mee naneadu-tamme. ");
INSERT INTO paoNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Mu numu ka mu meana nakase mu nageka. Oosoo Te Pabe'e Jesus yise besa soonammese ka Te Naa besa unnepu mu tunedyoo'e ka mu tuoegoedu mabesakuna. ");
INSERT INTO paoNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Ka tu taba ekowgase, mu wahamatsebooekudu (12) tunakatzimodu meeoo ka Te Pabe'e netamma, “Soo yaatu numu kwinga'yoona, kadoo'oo hee. U sakwa mu numu taya umu mana mease tu tukakwuna hanedooakwu.” ");
INSERT INTO paoNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Pana soo Te Pabe'e Jesus meeoo mu netamma, “Hemma sakwa tamme mu maka?” Mu oo nakatzimodu yise meeoo ka Te Pabe'e netamma, “Numme manegeoo tukaba-ga'yoo yise waahoo pakwe-ga'yoo. Pute sakwa numme mease mu ewow numu tukapu tumukudooa?” ");
INSERT INTO paoNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Tubetse ewa'yoo (5000) nanana o. O'no yise soo Te Pabe'e mu tunakatzimodu meeoo netamma, “Mu numu sakwa ka poohegea-kooba sapa aata'apunne.” ");
INSERT INTO paoNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Umu Te Pabe'e nakatzimodu yise pumme oo netamma-kwa'ne manese yise no'yoona aatahoo. ");
INSERT INTO paoNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Soo Te Pabe'e yise ka mu aatahoose ka tukaba noko pakwe hemahoose toogoopatu poonnese, nanesootuhikooha. O'no yise ka tukaba noko pakwe tzabokase, mu ewow numu ka umu pumme nakatzimodu maka tuungu. ");
INSERT INTO paoNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Mu numu no'yoona yise ewa tukase, wutzu'me. Ka mu numu wutzu'mese mu Te Pabe'e nakatzimodu ka a nagupenina tunoka wahamatsebooekudu (12) kawona kaanoku. ");
INSERT INTO paoNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Soo Te Pabe'e ka Te Naa-matoo nanesootuhi mu nakatzimodu oo-no. Soo Te Pabe'e ka umu tunakatzimodu meeoo tubenga, “Hownne'yoo oosoo nana mee mu numu nu-kwitu netamma?” ");
INSERT INTO paoNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Umu tunakatzimodu yise meeoo ka Te Pabe'e nanekwegea, “Susumudu numu, ‘Ume ka numu baa-wi matzakadu John’ mee netamma. Susumudu numu yise meeoo, ‘Soo Jesus Te Naa yadooawabe Elijah mee naneadu.’ Susumudu numu punno'o meeoo, ‘Ka mu Te Naa yadooawabe-matu.’ mee u-kwitu netamma.” ");
INSERT INTO paoNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Soo Te Pabe'e ka tu nakatzimodu meeoo netamma, “Ha'yoo mu puu e soobedya?” Soo Peter oo nekwegea, “U yow Ne Pabe'e ka Te Naa numme-matoo tutayana.” ");
INSERT INTO paoNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","22","Soo Te Pabe'e meeoo mu netamma, “Gi meno'o numu tuukwepana, nu yow Mu Pabe'e. Mu Jew numu yadooakudu gi e petzape, unu e kusekase, e batsase yise waha tooise saa'a nu tusootabooekwu.” ");
INSERT INTO paoNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Soo Te Pabe'e yise no'oko mu numu, ka umu tunakatzimodu-nokosoo mee mu netamma, “Tooe haga tooe nu-wi tunaka'oedyukudu sakwa mee unne oosoo gi hownne'yoo, tooe mu ka nu-koobatoo nabatsase sapa, mu e nagenokwu. ");
INSERT INTO paoNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Tamme ka tammesoo too'e namagwetzoina tamme kadoo'oo namayugwekwu, mu ka nu-koobatoo kadoo'oo mesoo namayugwena mu namagwetzoikwu. ");
INSERT INTO paoNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Tamme ka teepu-kooba'yoona ewow hee-ga'yoo pana ka te ya'ese oosoo gi te magwetzoi-wa'ne'yoo. ");
INSERT INTO paoNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Gi oosoo te gwetzoina tumu-wa'ne'yoo. Tooe haga tooe nu-ma nasookwina, no'oko e unnepu tuwazoo, nu yise punno'o, saa'a mu-ma nasookwikwu ka Te Naa pooha-toohakwi e petuse, ka toogoopatu e tutummatziwabe mu toha kakasa-ga-no. ");
INSERT INTO paoNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Nu togesapa mu tuukwepu susumudu mu yaa konnodu gisoo tuina e pooha-gana poonnekwu.” ");
INSERT INTO paoNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Sumu nasatese, soo Te Pabe'e ka umu tu pupua'amu tuukwe, mu Peter yise James noko John nano mu mea tuunguna, oona giba-matoo nanesootuhigakwuse. ");
INSERT INTO paoNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Togesoo oo nanesootuha'e oo koba atasoo tabuaga'a, yise pukwi oo namasooana tohawiya'negase patakwetseapunne. ");
INSERT INTO paoNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Yise waha'yoo nanana o'nosoo Te Naa yadooawabe Moses-no Elijah mee nananeadu oo-baa tabua petu. Umu punno'o patakwetseapunne. ");
INSERT INTO paoNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Nanano apegeadyakwe ka Te Pabe'e besa manekwuna ka Jerusalem-wi'yoona tamme-koobatoo oo nabatsakwuna. Soo Te Pabe'e yise te magwetzoikwu. ");
INSERT INTO paoNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Soo Peter tu pupua'amu-no usumeadyakwe umu ka tupoonnese umu ka mu pihoo o konnodu patagwetseapunne mu poonne. ");
INSERT INTO paoNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Mu Moses-no Elijah memeahookwuse, soo Peter gi ha'yoo unne-wa'ne'yoo, ka Te Pabe'e mee netamma, “Besa numme ka kemmase. Numme pihoo mu tatza nobe-dookukwu, u sumuoo mu Moses-no Elijah punno'o namesusu'mu.” ");
INSERT INTO paoNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Togesoo oo yadooadyakwe, soo koomeba mu haba-gakuhoo petu, umu-koobakwi manikese, mu tunakatzimodu sua'e. ");
INSERT INTO paoNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Soo Te Naa yise koomeba naga'yoona mu yadooe mee mu netamma, “Esoo yow E Besaa Tooa, nu a netutzea. Mu sakwa a nakabetsea.” ");
INSERT INTO paoNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Soo Te Pabe'e suu'mu yise umu-baa mani. Ka o'no umu gi haga tuukwe'e ka a namanina. ");
INSERT INTO paoNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ka giba-ma'yoona mu sawekese ewa'yoo mu numu yise mu takwi. ");
INSERT INTO paoNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Umu naga'yoona sumu'yoo nana yise ka Te Pabe'e meeoo netamma, “E tooa sakwa u mabesaku, oosoo tsoapayina gi besa manakwe. Oosoo e besaa tooa. ");
INSERT INTO paoNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Tooe hano'yoona tooe soo tsoapa oo-ma tabua'ana soo e tooa ya'eookayakwe, oobenakwatoo unu nuummaba wumayakwe. ");
INSERT INTO paoNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Nu umu ume nakatzimodu too'e nematzagakwuni tuungu umu yise gi oo mabu'a.” ");
INSERT INTO paoNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Soo Te Pabe'e yise meeoo mu netamma, “Mu gi e nakabetse'a tooe nu wuna'me yaa mu-baa'yoona mu gi e naka'oedyukute. Ka naatse yaatoo tzakowke.” ");
INSERT INTO paoNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Soo naatse ka Te Pabe'e poonnese ya'eooka. O'no soo Te Pabe'e ka tsoapa nematzagakwunise ka naatse magwetzoi ka tsoapa-makoo. Soo na'atse ka besa manise soo Te Pabe'e oo naa-matoo oo nemawunihoo. ");
INSERT INTO paoNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Mu numu yise ka Te Naa nesookwugi. Mu numu yise mee nananetamma, “Soo Te Pabe'e ka unu pooha-gana nanasookwugi tumadabue.” Soo Te Pabe'e ka umu pumme nakatzimodu mee netamma, ");
INSERT INTO paoNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Mu sakwa a tubetse soomayu ekow na'unnepu nu saa'a nakwutumakwu.” ");
INSERT INTO paoNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Umu oo nakatzimodu gi oo nakasopedakwadoo ka meeoo oo unakwe. A nawatzetugu-kwa'ne umu oo nakasoobedyana ooka tu tubengukwuna nasoogwa'e ka meeoo oo unakwe. ");
INSERT INTO paoNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Umu Te Pabe'e nakatzimodu puusoo gi nanatoge'yookute ka noo'yoo meeoo tusooyugwena, “Nu yow oo ooonakwatusoo.” ");
INSERT INTO paoNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Soo Te Pabe'e oo sopedakwatoo ka mu tusooyugwena, oosoo yise sumuoo ka tuha'akoo nabaa tzakwunukuna ");
INSERT INTO paoNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","umu pumme nakatzimodu mee netamma, “Sumuna mu no'yoona mee soonamme nu sakwa mu moohe. Soo sumu'yoo mu-matu gi maawa'ne nanasoobedyadu gi yoo tuha'a-kwa'ne saa'a mu moohedooa. Ka tuha'akoo tummatzina nu-koobatoo, ka nugatuna nuka tummatzidu-kwa'nesoo manepunne ka E Naa tuwow tummatzipunnesoo.” ");
INSERT INTO paoNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Yise soo John ka Te Pabe'e meeoo tuukwe'e, “Numme sumuoo nana poonne, ume pooha tooha-kwi tsoapa tayakwunidu. Numme yise meeoo oo netamma, ‘U sakwa gi mu tsoapa tayakwunipana ka Ne Pabe'e pooha-ma, ka gi numme tunakatzimodu-matuna.’ ” ");
INSERT INTO paoNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Soo Te Pabe'e yise meeoo oo netamma, “Mu sakwa uga gi meeoo ka nana netammapana. Tooe haga tooe e nanea-ma ka tsoapa nematzagakwunidu tookwa te tummatzidu, oosoo ka gi te wohonena.” ");
INSERT INTO paoNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Soo Te Pabe'e oo sopedakwatoo soo Te Naa pudusoo namatasoo oo bikwu. Soo Te Pabe'e yise meeoo tusooyugwe, “Nu sakwa ka Jerusalem-witoo mease mu numu-no nanesootuhi.” ");
INSERT INTO paoNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Susumudu tu pupua'amu-matu mooe taya ka mu wakwawa'a Samaritan mee nananeadu numu-matoo mu tutubenga tuunguna umu-baa tooikwu mee tusooyugwena. ");
INSERT INTO paoNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Mu Samaritan numu gi Jew numu toge'yookute ka Jerusalem-wi'yoona mu paba nananesootuha'yoo. Mu oo tutayana oo wegeatooase yise meeoo oo tuukwe, “Umu wakwawa'a gi u nenabaa'yookute.” ");
INSERT INTO paoNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Waha'yoo umu Te Pabe'e nakatzimodu-matu James-no John mee nananeadu mu nakase mee ka Te Pabe'e netamma, “Tamme sakwa ka Te Naa-matoo nanesootuhi umu wakwawa'a numu sakwa natuni.” ");
INSERT INTO paoNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Soo Te Pabe'e yise umu-tamme nakwumunase mee mu netamma, “Gi suda unnepana.” ");
INSERT INTO paoNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Umu yise kumma'abasoo numu-baa tooikwu. ");
INSERT INTO paoNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Ka podo-toogoo mu meadape soo nana ka Te Pabe'e meeoo netamma, “Nu tooe hano tooe u mea nu u nagenummekwu.” ");
INSERT INTO paoNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Soo Te Pabe'e yise meeoo oo netamma, “U ka nu-no'yoona gi nobe-gakwu. Mu etza'a puu ka teepu-naga to-ga'yoo, mu hootsebaa'a punno'o sunngabe-ma nonobe-ga'yoo, pana nu yise gi nobe-ga'yoo.” ");
INSERT INTO paoNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Soo Te Pabe'e ka sumuoo nana meeoo netamma, “U sakwa nu-no maneka.” Soo nana yise ka Te Pabe'e meeoo nanekwegea, “Nu sakwa e naa-no nummenummese, ka oo ya'ese oo tuguse, saa'a u-no tzabekadooa.” ");
INSERT INTO paoNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Soo Te Pabe'e meeoo oo netamma, “Meno'osoo nu-no maneka. Mu-matusoo gi tunaka'oedyukudu saa'a ka mu naa mabetseadooa.” ");
INSERT INTO paoNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Kumma'yoosoo nana punno'o meeoo, “E Pabe'e, nu sakwa punno'o u-no manenumme; pana mooe'ugasoo nu mu e nobe-kwitusoo mu mooe tuukwekase nu u-no tzabekadooa.” ");
INSERT INTO paoNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Te Pabe'e yise meeoo oo netamma, “Soo tooe haga tooe e naka'oedyukudu sakwa gi punowsoo kodyupana.” ");
INSERT INTO paoNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Soo Te Pabe'e ka ewahoo (70) numu tutunedyooemodu meeoo netamma, “Nu mu numu-matoo wakwaha-kwikoo mu tayamena ka pukwi e petugakwuna, ka Te Naa besa unnepu mu tuukwena. ");
INSERT INTO paoNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Gi haga ka Te Naa besa po-witu mu tuukwe. Ewa'yoo mu numu ka Te Naa besa unnepu nakasoogwidu. Pana hu'yoosoo ka Te Naa unnepu mu numu tunedyooedu. Tamme sakwa ka Te Naa-matoo nanesootuhi mee unnena, ‘U sakwa ewowsoo numu netutzea ka besa u unnepu wahakwudu. O'no yise ewa'yoo numu u-kwitu nakana, u naka'oedyukukwu.’ ");
INSERT INTO paoNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Mana mea, nu mu tayakwu mu sutahoo numu-nagatoo. ");
INSERT INTO paoNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Gi hemma hanegapana, gi nobenepana, gi mago'o, gi mu moko, yise gi numu yadooepana ka meana. ");
INSERT INTO paoNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Ka tooe hanotu nobe-kwi pudu egea-kakwuse besow mu numu oe nobe-gakoo mooe nekwiku. ");
INSERT INTO paoNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ka nanesootuhidu oo nobe-gakoo oo nanesootuhiku, oosoo besa'yookwu. Umu ka suta'yoona soo besow umu mu nekwipu mu-matooso namakodyukukwu. ");
INSERT INTO paoNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Tooe hano tooe mu-baa'yoona osoo saa'a tukana, hebena tuwazoo. Gi oo nasookwipana o mu natummatzina gi nana'atakoosoo nobe-toogoo me'a. ");
INSERT INTO paoNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Ka mana tooe hano tooe petugase, ka u namakana tuka, gi oo nabeatsegapana. ");
INSERT INTO paoNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Mu tuoegoedu nanesootuhikuna mu mabesakuna ka no'oko mu numu meeoo netamma, ‘Pudusoo soo Te Naa te nemadunagakwu.’ ");
INSERT INTO paoNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ka tooe hano tooe petugase ka mu numu gi mumme toge'yookute, gi umu-baa'yoopana. ");
INSERT INTO paoNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","Mu tsasoopedya, oe'yoona mea mu tunesootabue ka gi toge mu manena umu-matoosoo kodyukwu ka gi te oedyukuna. ");
INSERT INTO paoNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Nu yise mu tuukwe saa'a ka Te Naa mu numu nemadabuekwu, soo suda mu tumatugupu umu-matoosoo kodyukwu, ka o'nosoo tu namane-kwa'nesoo, soo suta'yoo puu ka Sodom mee naneadu-matoo namakodyukuse, umu nakootzasooa.” ");
INSERT INTO paoNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","14","Soo Te Pabe'e tuwow mee, “Mu numu ka mu Chorazin noko Bethsaida mee nananeadu-wi nonobe-ga'yoo tooe umu nana'ewasoo e besa pooha manekena poonnepana umu gi e oedyukute. Sumuna soo mu tuma'emukwana umu-matoosoo kodyukwu, nu ka oo too'e wahana, umu gi oo naka'oedyukuna. Mu numu ka Tyre noko Sidon-wi nonobe-ga'yoo ka o'nosoo sakwa ka mumme poonnena e oedyukuna gi uga nagoekwu. Ka Te Naa numu nemadabuekwuse mumme manena umu manepu ooonakwa suta'yoo. ");
INSERT INTO paoNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Mu numu ka Capernaum-witu nonobe-ga'yoo punno'o gisoo besa'yoo. Mumme ma'emukwana sumuna punno'o mu-matoosoo kodyukwu ka gi e oedyukuna punno'o. ");
INSERT INTO paoNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Soo tooe haga tooe unu e naka'oedyukute Te Naa naka'oedyukudu tuwazoo. Soo tooe haga tooe punno'o nuka gi toge'yookudu, Te Naa tuwazoo gi toge'yookute. Soo Te Naa yaatoo mu-matoo e taya.” ");
INSERT INTO paoNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Saa'a mu ewa'yoo nanana Te Pabe'e tutuyana oo-baasoo petugase mee oo netamma, “Numme u pooha-ma ka mu tsotsoapa nematzagakwunina, umu mea'ayakwe.” Soo Te Pabe'e yise mee mu netamma, ");
INSERT INTO paoNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","“Meno'o yise soo e wohonedu soo suta'yoo namatzooekuhoo. ");
INSERT INTO paoNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Nu mu besa pooha-makapu o'no soo suta'yoo gi hownnekoo mu matzooekute. Gi hee mu matzama-wa'ne'yoo. Tooe mu togogwa-kooba tatukuse sapa oosoo gi how mu yugwe-wa'ne'yoo. ");
INSERT INTO paoNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Ka mumme e pooha-maka gi ookow madumotseagapunne, pana soo gwetzoibu yise Te Naa mumme sootuhipu, o yisetu.” ");
INSERT INTO paoNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Soo Te Pabe'e punno'o tubetse besa soonammena meeoo nanesootuhi, “Ne Naa u no'okosoo hemma ka teepu-koobatu yise ne pa'anakwitu tuwazoo nemadabue. U tubetse besa'yoo u ka umu u dooamu ka besa etzaga u unnepu nakasopedakwadookwuna mu sootuhipuna, tooe gi unu mu natunedyooepu sapa. Umu unu natunedyooepu, gi gea u unnepu nakasopedakwadoo. Yooonnekoo u tusooyugwepu-kwa'ne.” ");
INSERT INTO paoNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Soo Te Pabe'e yise ka mu numu mee netamma tuwow, “Soo E Naa no'okosoo hemma e sopedakwatoona e sootuhipu. Oosoo suu'mu e sopedakwatoo. Nu punno'o ka E Naa sopedakwatoona nu ka numu oetu nakasopedakwadookwuna mu mesoo tuukwe.” ");
INSERT INTO paoNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","24","Soo Te Pabe'e yise ka umu pumme nakatzimodu mee netamma, “Soo Te Naa tubetse besa ka besa e unnepu nakasookwina. Pana umu te nanamooatupu gi ooka nasootuhi. Meno'o yise mu e poonnena ka besa e unnepu nakasopedakwatoo.” ");
INSERT INTO paoNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Ewa'yoo numu ka Te Pabe'e naka aata'a. Sumu'yoo nana ka mu Jew tumayohope numu tunedyooedu ka Te Pabe'e too'e nekwesekuna wunuoose mee oo tubenga, “Ha'oo besa sakwa saa'a nu manese ka ya'ese, ka Te Naa-baatoo mea?” ");
INSERT INTO paoNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Soo Te Pabe'e oo nanekwegea, “U ka te tumayohope nea, hayoo puu oosoo oetu na'unakwe?” ");
INSERT INTO paoNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Soo nana ka Te Pabe'e nanekwegea punno'o meeoo yise, “Tamme sakwa ka Te Naa unu soobedya, no'oko te sokwama-ma ka hemma how te yugwena tuwazoo. Tamme sakwa te pupua'amu tuwow besa soobedya, tammesoo nasoobedya-kwa'ne.” ");
INSERT INTO paoNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Soo Te Pabe'e yise meeoo oo netamma, “U togekoo e nanekwegea. U ka ekow unnepu nakabetseana, saa'a u ooosapa ka Te Naa-baa nobe-gakwu, ka ya'ese.” ");
INSERT INTO paoNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Soo nana yise tu tumatu'adyina sopedakwatoona ka Te Pabe'e mee tubenga, “Haga yise nuga pua'a?” ");
INSERT INTO paoNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Soo Te Pabe'e yise meeoo tuwow mu natugwengakooha, “Sumu'yoo Jew nana ka Jerusalem mee naneadu-wi'yoona tubongo meana ka Jericho mee naneadu-kwitoo. Umu tuduhadu oo mooedyugwese no'oko hemma oo-makoo hanehoo oo too'e batsahoo ka po-kumaba oo ma'wuhooka. ");
INSERT INTO paoNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Ka saa'a oosoo Jew nanesootuhidu o kemmana, oosoo ka unu namooedyugwepu nana onoko poonnese ka po oo tookana-kwi oo-moopa meahoo. ");
INSERT INTO paoNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Saa'a yise punno'o oosoo Jew nanesootuhidu tummatzidu o kemmana ka nana poonne oosoo yise punno'o oo-moopa meahoo. ");
INSERT INTO paoNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Sumu'yoo numu mu Jew gi petzabedu saa'a punno'o o kemma. Oosoo ka unu namooedyugwepu nana poonne, tutuha oo soobedyana tooe ka nana Jew sapa. ");
INSERT INTO paoNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Oosoo yise oo-matu meahoose natusooa-ma oo mahanese, ooka oo wupagakute. Ka tu pookoo-kooba o tzatsebooase ka numu tooi nobe-witu oo hanehoogase onanoko oo mabetsea. ");
INSERT INTO paoNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Awamooa yise ka tooi nobe hee-gakoo nana tumanagakuse mee oo netamma, ‘Ka namooedyugwepu e mabetseaku. U ka ewowsoo tzasooase, nu saa'a ooka u tumanagakudooasoo, nu ka kodyupetuse.’ ");
INSERT INTO paoNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Ha'oo yise, hanotu umu-matu ka nana unu namooedyugwepu pua'a?” ");
INSERT INTO paoNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Soo nana ka Te Pabe'e nanekwegea, “Esoo nana oo tummatzise oo pua'a mane.” Soo Te Pabe'e yise ka nana mee netamma, “U sakwa punno'o no'obatusoo numu soobedya, no'obatusoo pupua'amu-ga.” ");
INSERT INTO paoNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Mu Te Pabe'e yise ka mu pumme nakatzimodu-no ooosapa meadabena ka numu nokadu-kwi petugonno. Sumu'yoo mogo'ne Martha mee naneadu yise nabaa mu tuka tuungu. ");
INSERT INTO paoNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Soo Martha punne'e Mary mee naneadu ooosapa ka Te Pabe'e-kumaba katuna, oo nakakatu oo yadooadyakwe. ");
INSERT INTO paoNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Soo Martha gi namadamawunu, ka tukapu mu mahanekuwununa. Soo Martha yise ka Te Pabe'e mee netammadooa, “Nu ka tukapu gi namadamawunu, u sakwa ka Mary nuka tummatzi tuungu.” ");
INSERT INTO paoNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Soo Te Pabe'e ka Martha meeoo netamma, “Gi ka tukapu-witu suda nasooyugwewunupana. ");
INSERT INTO paoNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Soo e unnekatuna ka te tukakwuna ooonakwa'yoopunne. Soo Mary soo besa e nakasoobedyana. Ooonne'yoona gi nu a tayahoo.” ");
INSERT INTO paoNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Soo Te Pabe'e ka mana tooe hano'yoona tooe nanesootuhidyina tunemamakwuse soo sumu'yoo oo nakatzimodu meeoo oo netamma, “Ne Pabe'e, ne nanesootuhi tunedyooe, ka John umu tu nakatzimodu tunedyooe-kwa'nesoo.” ");
INSERT INTO paoNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Soo Te Pabe'e yise meeoo mu netamma, “Ka nanesootuhina mee unneyi, Ne Naa ne pa'anakwatu, u tubetse besa'yoo. U no'oko numme-kooba pooha katudu. Numme no'oko numu yaa teepu-koobatu ume mu nakabetseana soogwa'e, ka u-baatu-kwa'nesoo. ");
INSERT INTO paoNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Nonotsa tu tabe mea-kwi tukapu gi ne namatuugekwuna. ");
INSERT INTO paoNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Ka ne tuma'emukwana soomu'wana numme puu oo soomu'wa ka mu numu suda numme matugu. Ne matzino kaaheno ne mayugwe. O'no numme besa-kwitoo tsebooe petugakwu.” ");
INSERT INTO paoNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Soo Te Pabe'e yise umu pumme nakatzimodu meeoo netamma, “Tamme sakwa ooosapa nanetsagwayidyi. Mu numu nanetsagwayina 'yoo manepunne. How sakwa puu tamme ka togabeno ka tu pua'a nobe-witoo mease ka oo yadooe petugase mee unnena, ");
INSERT INTO paoNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","‘E pua'a mana kwinga'atu pudu petuhoose, nu gi hemma oo maka-wa'ne manepunne. U sakwa pihoo tukaba nano'hona e hemepunne?’ ");
INSERT INTO paoNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Sumuna soo u pua'a gi u tutzakwonakwu-wa'ne'yoo ka mooasoo habena, umu oo doodooamu tuwa mooasoo bokwa, oosoo yise gi yotsese u maka-wa'ne'yoo. ");
INSERT INTO paoNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Pana saa'a pumme u nenoyukwe oosoo yotsese ka natzakwona tzakwuna, yise u makakwu. Tamme nanesootuhidyina o'nosoo soo Te Naa te sootuhise ka natzakwona tzakwonase, te makakwu. ");
INSERT INTO paoNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","10","Nu yise meeoo mu netammakwu, tutubenguse u nageakwu, oo watena u oo mayukwu, tutokangese u natutzakwonakukwu. Soo tooe haga tooe tutubengadu oo nageakwu, soo tuwatedu oo mayukwu, soo tutokangedu oo natsakwonakukwu. ");
INSERT INTO paoNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","12","U puu ka u tooa'a ka pakwe nekwa'e gi togogwa oo gea-wa'ne'yoo. ");
INSERT INTO paoNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Tooe tamme gi totoge'yoopana puu te dooamu besa matugu, soo Te Naa yise tamme besa matugukwu Tu Besa Pooha-matu-ma te sootuhikwu.” ");
INSERT INTO paoNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Soo Te Pabe'e ka tsoapayidu nana gi besa yadooadu nanesootuhikuse, yise ka oo namabesakuhoose soo tsoapayidu nana besa manese, yadooawunu. Mu numu ka Te Pabe'e ka nana namabesakuse oo poonnena oo nesookwuga'e. ");
INSERT INTO paoNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Susumudu mu numu ka oo nakana yise meeoo nana'unakwe, “Esoo nana Jesus ka tsoapa nematzagakwunihoo. Oosoo ka umuoosoo pooha-ma oo mu yugwewunu.” ");
INSERT INTO paoNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Susumudu yise ka oo manena poonnena gi oo soo'oedyukuna unusoo oo pooha manikwuna nepoonne. ");
INSERT INTO paoNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Soo Te Pabe'e ka mooasoo pumme mu sooyugwena sopedakwadoona, mee mu netamma, “Mu numu ka pumme moohedu gi nakabetseana nanano nananepetukana, soo mu moohedu gi mu numu moohe-wa'ne tabu'a, mu numu yise kadoo'oo sukwe namayugwekwu. ");
INSERT INTO paoNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Mu gi toge unakwe mu ka, ‘Numu poohadu,’ mee e netammana. Soo numu poohadu gi hownnekoo nanesootuhina ka tsoapa numu-nagakoo nematzagakwuni-wa'ne'yoo. Soo suta'yoo gi ka tsoapa numu-nagakoo nanematzagakwunina petzape, umu tsoapa ka oo tutummatzina. ");
INSERT INTO paoNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Mu Jew numu moohedu puu ka mu tsoapa numu-nagakoo nanesootuhikuna mu nematzagakwuna'e. Mu puu gi numu poohadu mee mu ne'a. Mu sakwa gi nuka meeoo soobedyapana. ");
INSERT INTO paoNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ka Te Naa Besa Pooha-toohakwi nu nanesootuhina mu tsoapa nematzagakwuni, mu sakwa meno'o oo sopedakwadoo soo Te Naa no'oko numu sootuha'e. ");
INSERT INTO paoNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Nu ka mu susutakoo moohedu ooonakwasoo unu pooha-gana nuga pooha ooosapa oo matzoekute. Soo natzooedu nana puu ka tu hemma besa takonena gi hee oo matzooekute, ");
INSERT INTO paoNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","pana ka numu tzakunase o'no yise oo hemma hanekwu. ");
INSERT INTO paoNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Yooosoo nu ka sutakoo yugwese o'no nu mu numu magwetzoikwu ka suta-makoo. ");
INSERT INTO paoNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Soo tsoapa ka numu-nagakoo natayase, kumma'akoosoo puma tu kaduookwunu wate, pana gi tuma'yu, yise ka gi tuma'yuna meeoo unakwe, ‘Nu punowsoo kodyukakwu.’ ");
INSERT INTO paoNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Ka numu punaga'yoo tumeahoopu mayuse, oosoo numuna sumuna gisoo ka Te Naa Besa Pooha-ma nasoonatza'ena. ");
INSERT INTO paoNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","O'no yise soo tsoapa natakwatsukwu (7) kukumma'akoosoo tsotsoapa pumme ooonakwa unu susutakoosoo bise ka punaga'yoona tumeapu-nagatoosoo kodyukakwu. Soo nana yise unusoo suda namanatzayakwu.” ");
INSERT INTO paoNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Sumu'yoo mogo'ne oonow numu-naga wunudu ka oo nakase meeoo oo netamma, “U pea sakwa nasootuhi ka u dooa'adoose yise ka u petzekuse tuwazoo.” ");
INSERT INTO paoNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Pana soo Te Pabe'e meeoo oo netamma, “Oo mu numu ka Te Naa unnepu nakana, ka oo oedyukuna umu unu nasootuhikwu,” mee. ");
INSERT INTO paoNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Ka mu numu ewasoo manemena soo Te Pabe'e yise meeoo mu netamma, “Mu suta'yoo numu gi e naka'oedyukudu ka nanasookwugi besa e manena poonnese e naka'oedyukukwu suu'mu, mee mu tusooyugwe. Ka o'nosoo Te Naa yadooawabe, Jonah mee naneadu ");
INSERT INTO paoNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","ka mu wakwawa'a numu Te Naa unnepu tuukwena mu oo naka'oedyukute. Nu yise yow Mu Pabe'e mu-baa petuse pana mu gi e naka'oedyukute. ");
INSERT INTO paoNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","O'nosoo soo mogo'ne mana mu taba mea-nakwatu numu nehane katudu, puu kwinga'a kemma ka mu Jew numu-kooba katudu Solomon mee naneadu oo tunetammana nakakwuse, ‘Ka unu oo sopedakwadoo,’ mee neyugwena. Tooe nu ka Solomon ooonakwa unu tusopedakwadoopana mu gi e nakabetse'a. ");
INSERT INTO paoNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ka numu paba nanehaneno'o mu wakwawa'a ka Jonah naka'oedyukupu sakwa mu nemadabue ka mu meno'o gi nuka naka'oedyukudu, tooe nu ka Jonah ooonnakwa pooha-gakooapa. ");
INSERT INTO paoNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Soo besa e unnepu tukootabuakunoo kootabua-kwa'ne. Tamme puu ka oo kootabuakuse paa'a hee-kooba oo wuna. O'no soo tooe haga tooe petudu no'oko hemma mesoo poonne. Gi tamme puu kawona-tooha oo watzetugu. ");
INSERT INTO paoNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Soo te pooe puu tukootabuakunoo-kwa'ne'yoo. Tamme ka besow poonnena suu'mu tamme besa'yookwu, pana tamme ka sutakoo poonnena suta tusooyugwekwu. ");
INSERT INTO paoNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Tamme ka besow nakasopedakwatoo, ");
INSERT INTO paoNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","tamme besa'yookwu.” ");
INSERT INTO paoNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Ka Te Pabe'e yadooawunu, sumu'yoo nana nasootuhidu Pharisee mee nananedu-nagatu punno'o oo tuka tuungu. Oosoo yise oo-no tuka kaduhoo. ");
INSERT INTO paoNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Mu Jew numu tu mi mooe bakomase tuka, ka oo tumatuguna. Soo Jew nana yise meeoo soonamme, “How manena soo Jesus tuka gisoo tu mi bakomana?” ");
INSERT INTO paoNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Te Pabe'e yise mee ka nana netamma, “Mu Jew numu tumatuguna, puu besa ka mu tookoomatsu'a, pana soo mu soonammena togesoo totsa'a, ka numu mooa-gana mu suta'yoo. Ka tseda-kumitu suu'mu matsuana soo oetu togesoo totsa'a. ");
INSERT INTO paoNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Te Naa namekoo mu mi noko mu soonammena matabuepu. Te Naa yise namekoo gi mu totsana sookwa'e. ");
INSERT INTO paoNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","U ka mu tutuha manedu numu makana u besa'yoo. ");
INSERT INTO paoNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Mu Pharisee nananesootuhidu tooe gi haanoko hemma hanepana mu ka Te Naa tosamakayakwe. Mu besa manakwe ka oo tosamakana. Mu gi ka Te Naa besa unnepu nakabetsea ka Te Naa unu soobedyanaka kukumma'akoosoo numu besa matuguna, mee na'unnena. ");
INSERT INTO paoNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Mu Pharisee nananesootuhidu mu ka tu na'ewa tuka besa-kwi mooe aatahooyakwe, ka tu nananesootuha'e mu tuwazoo ooosoo. Mu kukumma'akoosoo numu, ‘Oosoo besa nanesootuhidu,’ mee mumme mu netammana soobedya. Mu tuma'emukwana saa'a mu-maatoosoo kodyukwu. ");
INSERT INTO paoNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Mu suda manakwe ka kukumma'akoosoo numu ne'emukwana ka Te Naa besa po oemota mu moohena.” ");
INSERT INTO paoNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Sumu'yoo ka nanesootuhibu tunedyooedu-matu ka Te Pabe'e mee netamma, “U suda numme-witu waha tuwazoo.” ");
INSERT INTO paoNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Soo Te Pabe'e yise mee oo netamma, “Mu nanesootuhibu numu tunedyooedu punno'o mu tuma'emukwadu mu-matoosoo kodyukwu. Mu ka mu kukumma'akoosoo numu unu namanedu tumayohope nage tuungu pana mu gi hownnekoo ooka mu mayoho tummatzi-wa'ne'yoo. ");
INSERT INTO paoNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Mu puu ka o'nosoo Te Naa yadooawabe besa nanomatuoo'na, ka umu mu nanamooatupu tugoena besa matabuena. ");
INSERT INTO paoNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Mu tookwa ka mu nanamooatupu tugoena toge'yookute, o'no mu ka mu nanomatuoonana besa matabu'e. ");
INSERT INTO paoNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Soo Te Naa gi hemma watzekudu mee unakwe, ‘Tooe nu ka umu e yadooawabe umu-matoo tayase sapa umu mu kusegana mu ko'ehookwu.’ ");
INSERT INTO paoNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","51","Mu oe naneyukwe ka no'oko Te Naa yadooawabe goese. ");
INSERT INTO paoNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Mu nanesootuhibu tunedyooedu ka puusoo gi ka Te Naa nakabetseana gi hownnekoo ka Te Naa nakabetsea-kwitu mu numu tunedyooe-wa'ne'yoo.” ");
INSERT INTO paoNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Ka Te Pabe'e meahookwuse mu Pharisee unu oo sutakuna oo tooe nemasutana, ");
INSERT INTO paoNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","o'no oosoo suda unnise umu ookow oe neyugwekwu mee too'e sokwamana. ");
INSERT INTO paoNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Ewa'yoo mu numu ka Te Pabe'e-baatoo kemmana, ka tubetse ewa'yoona ka Te Pabe'e takoo'na, nanakwukutzu'nena ka wogo manepunnena. Soo Te Pabe'e yise ka mu nakatzimodu tu tunedyooehookwuna pedukwunu meeoo yise, ");
INSERT INTO paoNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","“Mu sakwa gi suipana ka besa e unnepu mu numu tuukwe. ");
INSERT INTO paoNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Ka mu nawatze natuukwena sapa waha, ha'oo puu soo togano-kwitu puu ka tu tabua-kwitu waha. ");
INSERT INTO paoNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","E pupua'amu, nu mu tuukwe gi ka te tookoo batsakwudu-ma suipana, umu ka te tookoo suu'mu batsakwu gi ka te moogooa. Soo te moogooa gi hownnekoo nabatsa-wa'ne'yoo. ");
INSERT INTO paoNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Pana nu mu tuukwe ka yise pumma mu sui-wa'ne'yoo, oosoo Te Naa. Soo Te Naa suu'mu ka te tookoo noko te moogooa kadoo mesoo ma'yugwe. ");
INSERT INTO paoNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Mu hootseba'a puu gi haa'no nanenaka pana soo Te Naa mu soopedyana mu mabetse'a. ");
INSERT INTO paoNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Soo Te Naa puu gi te watzekute, ka te tzopuhutooe tatzengana ka te wo-matu. Gi suipana, tamme mu hootseba'a ooonakwasoo nadatze'nga. ");
INSERT INTO paoNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Mu ka mu numu tuukwena, ‘Soo Jesus E Pabe'e,’ nu saa'a ka E Naa tamme-koobatu, ‘Mu nugatu,’ mee tuukwedooa. ");
INSERT INTO paoNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Mu ka ‘Jesus E Pabe'e,’ mee mu unne-ma nasookwina, nu saa'a ka E Naa tamme-koobatu, ‘Mu gi nugatu,’ mee oo tuukwedoo'a. ");
INSERT INTO paoNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","No'yoona numu yise ka Te Naa suda netammana oosoo nasoomu'wakwu, pana mu ka Te Naa Besa Pooha suda netammana oosoo gi nasoomu'wa-wa'ne'yoo. ");
INSERT INTO paoNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Ka nakwutumuna ka nanehanena mu nanesootuhidu noko numu moohedu-kobena'yoona, gi ka mu unnekwuna suda soonammekupana. ");
INSERT INTO paoNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Soo Te Naa Besa Pooha ka mu unnekwuna mu tuukwekwu.” ");
INSERT INTO paoNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Sumu'yoo umu Te Pabe'e nakapunnedu-matu mee oo netammadooa, “U sakwa ka e pabe'e mee netammana oosoo ka ne naa hemma nu-no nowmoo.” ");
INSERT INTO paoNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Soo Te Pabe'e yise ka nana mee netamma, “Mu gi nuga nehanena.” ");
INSERT INTO paoNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Soo Te Pabe'e yise ka mu numu tuwow meeoo netamma, “Tamme sakwa gi moomoogoobupana. Tooe tamme how ewow hee-gapana oosoo gi numu magwetzoi-wa'ne'yoo.” ");
INSERT INTO paoNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Soo Te Pabe'e yise mu numu mee natugwengakooha, “Soo ewow hee-ga'yoo nana tubewabe-gana ewow besa hemma suaku. ");
INSERT INTO paoNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Oosoo mee soonamme, ‘Ha'oo sakwa nu mane? Nagutza ewa'yoo soo e tumasuana, gi toge e tubane nobe-kwi no'yoona nahane-wa'ne'yoo. ");
INSERT INTO paoNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Nu sakwa umu e tubane nobe tzadyoometase papabowsoo matabue. ");
INSERT INTO paoNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","O'no nu saa'a besa soonammekwu ka no'oko tumasuana oe hanese. Meeoo nu soonamme, nu ewa tubanese wuna'metoo mesoo meawunukwu. Nu gi hemma how yugwena sukwe tukana, hebena, besa soonammekwu.’ ");
INSERT INTO paoNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Soo nana tu ya'eookwuna gi sopedakwadoo. O'no togano soo nana ya'ehoo. No'yoona oo tumasuape kumma'yoosoo nahaneku. ");
INSERT INTO paoNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Tamme ka yaa teepu-kooba'yoona ewow hee-ga'yoo ka oo-mahoo nasoonatzina ka Te Naa gi nakabetseana tamme matu'adyipunne.” ");
INSERT INTO paoNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Soo Te Pabe'e umu tunakatzimodu meeoo netamma, “Gi suda oo sokwamakupana ka tukapu sumudooe tuugena, yise too ka pukwi mu namasooana. ");
INSERT INTO paoNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Soo numu gwetzooina ka tukapu ooonakwatu, ka pukwi numu namasooana ooonakwatu tuwow. ");
INSERT INTO paoNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Mu ka mu hootseba'a poonne, umu puu tooe gi tumasua pana mesoo tuka, soo Te Naa mu mabetsea. Soo Te Naa puu mu hootseba'a ooonakwasoo te soobedya. ");
INSERT INTO paoNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Tamme gi hownnekoo tammesoo kwinga'atoo te momokwuna mada'e, tamme sakwa yise gi ka te tuka-witu suda soonammekupana. ");
INSERT INTO paoNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Mu yise ka yooonnekoo tututsekoo gi soomadi how yise ka a pabana suda soonammekute. ");
INSERT INTO paoNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Ka mu tonegeadu puu soo Te Naa mabetse'a ka umu puu gi tuusoogwi tatabu'a. Umu ka Jew numu-kooba katudu, Solomon mee naneadu unu nananenagadu oo nemasooa'apu oo ooonakwa besa tatabu'a. ");
INSERT INTO paoNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Soo Te Naa umuoo tonegea'adu puu besa matabue. Tooe umuoo yabesoo takwasugwuuse sapa, oosoo Te Naa yise ooosoo ka pukwi te namasooana gi te namatuugekwuna ka oo nakabetseana. ");
INSERT INTO paoNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Tamme sakwa yise gi suda sokwamapana ka te tukakwuna, ka te hebekwuna kadoo'ookoo. ");
INSERT INTO paoNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Mooasoo soo Te Naa te pa'anakwatu oo sopedakwadoo, gi nawatzekudu. Umu gi tunaka'oedyukudu ooonnekoo yaa'a teepu-koobatu ka tukapu, ka pukwi tu namasooana ooosapa ookow ooonakwa sooyugwe. ");
INSERT INTO paoNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Tamme sakwa yise ka Te Naa nakabetseanona oosoo gi hemma te namatuugekukwu. ");
INSERT INTO paoNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Gi suda oo sokwamakapana, oosoo Te Naa besa te sootunaga'a. ");
INSERT INTO paoNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","No'oko mu hemma-ma tumuse mu tutuha manedu haneku, soo Te Naa te pa'anakwatu yise besakoo mu sootuhikwu. Soo Te Naa besasoo mu sootuhikwu, o'no ookow sakwa mu gi soomu'wapana. ");
INSERT INTO paoNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Tooe hee tooe mu tusoodyahana o mu manepunnekwu. ");
INSERT INTO paoNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Mu sakwa ooosapa namamakwupunne ka yaa teepu-koobasoo e kodyu petukwuse. ");
INSERT INTO paoNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Mu sakwa umu-wa'nesoo ka mu tuutooedu nehanedu petukwuse besa sokwama. ");
INSERT INTO paoNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Ka togesoo mu tubonne oosoo kodyu petuse umu nasootuhikwu. Oosoo puusoo tukapu mu makakwu. ");
INSERT INTO paoNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Ka tooesoo mu tubonne petuse tooe togabeno tooetoo tabua-tamme tunehanedu ka utuina besa sokwama. ");
INSERT INTO paoNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","40","Nu gi nuka meeoo mu soobedyano'o mu-kooba o petukwu. Ooonne'yoo mu sakwa yise namabetzapepunne.” ");
INSERT INTO paoNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Soo Peter yise mee ka Te Pabe'e tubenga, “U haa'a no'oko numu netammana, pute numme tunakatzimodu suu'mu?” ");
INSERT INTO paoNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Soo Te Pabe'e meeoo ka Peter nekwegea, “Soo nuga poena'ewabe netutzeana sakwa unu soonammena besa numu tummatzi. Umu yise ka nuka naka'oedyukudu mabetseana mu makakwu ka tukapu mu sookwa'e. ");
INSERT INTO paoNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Nu ka kodyu petuse umu e poena'ewabe ka umu nuka naka'oedyukudu besa mu mabetse'a mu mayu petuse, nu mu sootuhikwu. ");
INSERT INTO paoNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Nu besasoo mu sootuhikwu, no'oko hemma nemadabuekwu. ");
INSERT INTO paoNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Sumuna soo numu nanesootuhi moohedu ka meeoo tusooyugwena, ‘Gi soo Te Pabe'e yabesoo kodyu petukwu. Nu meno'o tooe how ka umu ooka naka'oedyukudu suu'mu suda matuguna ka ewa puusoo namakoo tusoohanena mesoo baaya'e.’ ");
INSERT INTO paoNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Nu yise ka kodyu petuse tooe hano tooe petukwu gi nuka meeoo mu soobedyano'o. O'no nu yise ka umu gi tunaka'oedyukudu-noko mu nanesootuhibu moohedu mu meeoo sooyugwe. ");
INSERT INTO paoNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Soo numu gi nuka nakabetseadu tooe oo sopedakwadoopana ka pumme e tuukwe'e soo suda mu tumatuguna umu-matoosoo kodyukwu. ");
INSERT INTO paoNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Soo numu gi oo nakasopedakwatoodu ka suta'yoona sagwane sapa nanekusekakwu. ");
INSERT INTO paoNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","50","Nu meno'o gi oo nasoomanekute ka nu-tamme kemmadu, ka nabatsakwuse. Nu sukwa tooe yabe soo oo tatukwahoo mee'e nu sooname. O'no nu saa'a ka teepu nemadabuekwu. Meno'o sakwa mooasoo oe manepetu mee nu soonamme. ");
INSERT INTO paoNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Mu sumuna mee sokwama meno'o ka Te Pabe'e petuse no'yoona numu nanapua'akwu. Pana gi oo manepunne. Umu gi tunaka'oedyukudu ka mu tunaka'oedyukudu tumoo'ookwu tooetoo tu nananumu sapa. ");
INSERT INTO paoNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","53","Esoo nana gi nuka heesoobedyadu sumuna pummesoo tooa, tooetoo tu naa tumoo'ookwu. Soo mogo'ne gi nuka heesoobedyadu sumuna punno'o ka tu padu, tu pea, tooetoo tu yahepeawabe tumoo'ookwu. Sumuna manege'yoo nananosoo nobe-ga'yoo nanatumuoo'ookwu, waha'yoo umu-matu pihoo tumoo'ookwu, tooetoo pahe'yoo ka umu waahoo nu-matoo nananesootuhidu tumoo'ookwu.” ");
INSERT INTO paoNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Soo Te Pabe'e yise ka mu ewow numu mee netamma, “Mu puu oo sopedakwatoo ka tu powmakwuse soo taba egea-tammetu unu koomeapunnekwu. ");
INSERT INTO paoNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Mu tuwazoo oo sopedakwatoo ka unu tu na'udutukwuse ka taba meanakwana hukwakwu. ");
INSERT INTO paoNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Pana mu gi e naka'oedyukute ka suda tumatuguna. ");
INSERT INTO paoNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Mu gi etzaga muusoo besa nanemadabue-wa'ne'yoo ka suda mu tumatugu-kwitu. Mu sakwa tuwazoo oo naka'oedyukuna mu sakwa kaaheno tumatugu. ");
INSERT INTO paoNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Mu sakwa yise ka mumme nehanekwudu-kobenatoo nabikwuse, tamme sakwa oo pua'adoo togesoo meadabena. Tamme ka gi oo pua'agana, ka tunehanepe-wi petugase oosoo tamme-witu suda nemadabuekwu. Soo numu nehanedu yise ka mu tukwutumadu tamme wutuma tuungukwu. ");
INSERT INTO paoNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Tamme yise nakwutumatugukwu, ka tamme tu tunekwina tumanagase suu'mu mee nu mu tuukwe'e.” ");
INSERT INTO paoNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Mu numu-matu ka Te Pabe'e meeoo tuukwe'e, “Mu numu-matu Galilee-wi'yoona kemmadu umu ka Jerusalem-witoo nanesootuhimidu. Soo mu Roman numu moohedu Pilate mee naneadu mu numu goehoo.” ");
INSERT INTO paoNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Soo Te Pabe'e yise ka mu numu mee netamma, “Mu ka sumuna mee sokwama umuoo numu Galilee-wi'yoona kemmadu tookwa ka mu Galilee numu ooonakwa unu tuma'emukwadu ooonne'yoona soo suta'yoo umu-matoosoo kodyukwu. ");
INSERT INTO paoNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Pana gi, soo suta'yoo mu-matusoo kodyukwu ka gi mu nanekwuha. ");
INSERT INTO paoNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Mu sumuna meeoo sokwama, ‘Umu numu nagoehoodu soo tukwutumadu nobe umu-koobatoo aanooahoo, umuoo tookwa hanobasoo suta'yoo numu ka mu Jerusalem-wi nonobe-gadu hanobasoo.’ ");
INSERT INTO paoNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Pana gi, mu ka gi mu tuma'emukwana wahana mu-tammesoo kodyuse kadoo mu mayugwekwu.” ");
INSERT INTO paoNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Soo Te Pabe'e yise mee mu tuukwe, “Sumu'yoo numu puu pogobesa tu tubewabe-wi masua. Saa'a meno'o soo pogobesa kwasu mee soonammena oetoo e petugayakwe pana gi pooedoo'a. ");
INSERT INTO paoNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Ka pumme tummatzidu yise mee netamma, ‘Pahe tomokapu, gisoo pooedooana. Masoo pogobesa gi he-toogoo besa'yoo numu sukwe kapamooaka. U sakwa a tuhewekwuni.’ ");
INSERT INTO paoNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Soo tummatzidu yise meeoo oo netamma, ‘Nu a na'oonnakwitu hewese pookoo kwedana ma-kooba hanese sumu tomoba-wi a mabetseakwu. ");
INSERT INTO paoNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Yise ka sumu tomoba-wi a pooe-dooase, oosoo besa'yookwu. Pana ka sumu tomoba-wi gi a pooe-tooase, o'no saa'a nu a tuhewekwunikwu.’ Yooonnekoosoo soo Te Naa ka mu Jew numu oetu tunenagakute, ka gi mu ma'emukwana mu waha, mu tuma'emukwana mu-matoosoo kodyukwu.” ");
INSERT INTO paoNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Sumu tu nananesootuha'e nasumu'u soo Te Pabe'e mu numu tunedyooedyakwe. ");
INSERT INTO paoNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Soo sumu'yoo mogo'ne wuna'me (18) tomopu manena tookoo tootzadyamedu. ");
INSERT INTO paoNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Soo Te Pabe'e ka mogo'ne tutuha manedu mee oo netamma, “Yaatoo kemmase nu u mabesakukwu.” ");
INSERT INTO paoNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Soo Te Pabe'e na'enakwa oo-ma matuoonahoose soo mogo'ne yise kaaheno nakwuma'ese mee unnetooe, “Soo Te Naa tubetse besa'yoo.” ");
INSERT INTO paoNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Soo nanesootuhibu nehanedu ka Te Pabe'e sutakuoo ka nanesootuhi tabebuno ka mogo'ne oo mabesakuhoose yise ka nehanedu-umu meeoo netamma, “Tamme Jew numu naapahe tabeno natzato'o, mu umuoo tabeba-wi mesoo nemabesakute. Pana ka te nanesootuhi tabeba-wi gi hee how nuukwu. O'no mu gi natzato'o-wa'ne'yoo.” ");
INSERT INTO paoNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Soo Te Pabe'e mee oo netamma, “U umesoo unnena takopadyakwe. Ka nanesootuhi tabeno mu puu ka mu pookoo tzadopayina oo bamagayakwe. ");
INSERT INTO paoNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Soo mogo'ne ka u pookoo-wa'ne soo suta'yoo wuna'me a tuoe tzatobotoo, nu yise o tzadopase ka gwetzoibu-ma oo sootuhise esoo yise besa mane, u yise e toge'yookuhoo, ka maka e mabetsakuoose ka nanesootuhi tabeba-wi.” ");
INSERT INTO paoNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Soo Te Pabe'e nesootzemadu gi hownnekoo oo nekwegea pana ewa'yoo numu oo besa'yookute ka Te Pabe'e besa manina. ");
INSERT INTO paoNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Soo Te Pabe'e mu numu natugwengasoo tuwazoo, “Nu mu tuukwekwu, ha'oo soo numu manekwu ka e naka'oedyukuna. Meno'o mu huutse'yoo nuka naka'oedyukudu pudusoo mu ewasoo manekwu. ");
INSERT INTO paoNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Ka wuyupe sua-kwa'ne. Oosoo puu tuutsekoo a pooe-nakwana suake, oo soo tunadooakese, naakese, nana'emota ma'nadooa petugakwu. Ka suube-kwa'ne'yoo mu hootseba'a puu ka oo ma'na-ma mesoo aata'a. Ooosoo mu manekwu ka e nanesootuhinona. ");
INSERT INTO paoNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","21","Ka mogo'ne tukabadoo-kwa'ne. Oosoo puu ka tumayu'a ka hongobe noko mooe mayu'a. Soo tumayu'a saa'a noko ka oo tugoohanetoo mani, soo tukaba yise pa'atse'e posehoo. Yooosoo yise soo numu ka e naka'oedyukuna.” ");
INSERT INTO paoNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Soo Te Pabe'e yise ka Jerusalem-tamme meano no'oko mu numu nokadu-too tu meana nanesootuhibu numu tunedyooemena. ");
INSERT INTO paoNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Sumu'yoo numu ka Te Pabe'e meeoo oo tubenga, “Hutse'yoosoo numu haa'a namagwetzoi?” Soo Te Pabe'e mee oo nanekwegea, ");
INSERT INTO paoNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Huutse'yoo mu tubetse tu'oedyukudu suu'mu namagwetzoikwu ka 'yoo a manepunne mu sakwa unu o petukuno ka mu namagwetzoikwuna. ");
INSERT INTO paoNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Ewa'yoo numu meno'o gi e nakaheesoobedyadu nu yise yotsese ka natzakwuna'a mu-nakwi tzatumowkwu mu puuwana'yoona oo too'e wa'agekwu mee unnena, ‘E Pabe'e e tutsakwonaku nu mi egeahookwu.’ Nu yise meeoo unnekwu, nu gi u sopedakwatoo. U tookwa gi besa tumatugupu. ");
INSERT INTO paoNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Mu yise mee e netammakwu, ‘U ne sopedakwadoo. Numme u-no ewa tukayakwe, u yise ne nobe-wi'yoona nanesootuhibu numu tunedyooeyakwe.’ ");
INSERT INTO paoNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Nu yise mee mu netammakwu, mu gi nu-notu ka suda mu manena manoyugwena, mu sakwa mea. Nu gi mu sopedakwadoo. ");
INSERT INTO paoNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Mu Jew numu gi tunaka'oedyukudu mu nanatuaganena sakwikwu umu ka te nanamooatupu no'oko Te Naa nanayadooawabe Te Naa-baakoo. ");
INSERT INTO paoNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","No'obatusoo numu Te Naa naka'oedyukudu ka eka teepu-koobatu ka Te Naa-baa petugakwu yise ooosapa oo-no'yookwu. ");
INSERT INTO paoNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Susumudu numu meno'o gi meeoo nanasoobedyadu mooe nasootuhidu, mu yise meeoo nanasoobedyadu numu-nagwi manekwu.” ");
INSERT INTO paoNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Susumudu numu ka mu nanesootuhi-nagadu ka mu Pharisee mee nananeadu ka Te Pabe'e-baa petuse mee oo netamma, “U sakwa yaanona mea soo mu numu-kooba katudu Herod mee naneadu u nebatsayagate.” ");
INSERT INTO paoNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Soo Te Pabe'e yise mee mu netamma, “Mu sakwa ookow etza'a mee tuukwe, ‘Gi haa'notoo nu yaanopunnekwu mu toegadu mabesakuna, mu magwetzoina, mu tsoapa nematzagakwunikwu ka E Naa nuka tunetammakupu nu mamakwuhoogena. ");
INSERT INTO paoNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Pudusoo nu Jerusalem-witoosoo kodyukwu mu numu Jerusalem-witu suu'mu nono'otsa ka Te Naa yadooawabe goeyakwe, otoo nu numu-koobatoo nabatsekwu ka E Naa tunetammana nu mamakwuookwu.’ ");
INSERT INTO paoNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","35","Nu wuna'me mumme Jerusalem-witu tutuha soobedya ka hootze tu dooamu ka tu kasa-tooha tuwatzetugu-kwa'ne. Pana mu gi oo mu namatuguna petzape. Mu no'oko umu Te Naa yadooawabe sukwe tagoehoo, tupe-ma. Pudusoo mu kadoo namayugwese mu nobe-kwitu, hee kadoo'yookwu. Saa'a ka mu-baasoo e petuse mu mee unnekwu, ‘Yow soo Te Pabe'e Te Naa pooha-toohakwi petu.’ ” ");
INSERT INTO paoNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Tu nanesootuhi tabeba-wi mu Pharisee nanesootuhidu moohedu ka Te Pabe'e tuka bi. Soo Te Pabe'e yise umu-no tuka, mu Pharisee oo e ya'epunne ka Te Pabe'e nesootzemakwuse. ");
INSERT INTO paoNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Sumu'yoo nana tookoo pawadu oo numu-no. ");
INSERT INTO paoNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Soo Te Pabe'e oo poonne ka umu Pharisee yoo Jew tumayohope sopedakwadoodu tubenga, “Ha'yoo soo mumme tumayohope? Besa'yoo, gi hownne'yoo haa'a ka nanesootuhi tabeno soo numu namabesakuna?” ");
INSERT INTO paoNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Pana umu gi oo nanekwegea. Soo Te Pabe'e yise ka tookoo pawadu nana tzamahoose oo mabesakuse oo nobe-kwitoo oo ta'ya. ");
INSERT INTO paoNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Ka mu Pharisee yise mee netamma, “Ka nanesootuhi tabeno mu dooa tawaga-kwitoo wuehoose, tooetoo mu kootsoo, ka gi hownnekoo oo tzeboo'e, mu puu oo tummatzikwu. Mu sakwa yise gi e nesootzemapana ka nana e tummatza'e.” ");
INSERT INTO paoNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Umu Pharisee gi hanotoosoo ha'yoo unne-wa'ne'yoo. ");
INSERT INTO paoNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Soo Te Pabe'e mu poonne ka susumudu mu numu nadukabidu besa nasooyugwena ka besow kadunoo-kwitu mooe ohomanakwe, oosoo yise mee mu netamma, ");
INSERT INTO paoNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Tamme ka na'ewa tuka-kwitoo tamme tubise, tamme sakwa gi besa nasooyugwena besa-kwitoo mooe ohomanepana. Tamme ka besow kadunoo-kwi mooe kaduhoose sumuna saa'a tamme ooonakwa besa'yoo oe petuhookwu. ");
INSERT INTO paoNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Soo numu oetoo te tuka bidu yise mee te netammakwu, ‘Yaa e besa pua'a petuhoo. U sakwa ookow kadunoo maka.’ Tamme yise sumuna gi besa oo nakwumakukwu ka oekoo tamme tu tayahoose. ");
INSERT INTO paoNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Ka tamme tubise, tamme sakwa gi ka hemma besa-kwitoo mooe ohomanepana. Soo numu te tuka bidu te manena poonnena sumuna mee te netammakwu, ‘U e besa pua'a yaa ka besa kadunoo-kwi katuse ka e pupua'a-baa, umu-no tuka.’ ‘Oosoo besa'yoo numu,’ mee umu numu oo manepunnedu, te sootubetseyina. ");
INSERT INTO paoNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Tamme ka tammesoo besa nasooyugwena, saa'a namanasookwikudooa. Tamme ka gi besa nasooyugwena saa'a, ‘Oosoo besa'yoo,’ mee nanetammakwu.” ");
INSERT INTO paoNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","14","Soo Te Pabe'e yise ka nana pumme tuka bidu meeoo netamma, “Tamme ka na'ewa tukana, tamme sakwa tutuha manedu, mu gi yutsungadu numu oetu bi tuungu. Umuoo gi hownnekoo ooonnekoo soo te tumakodyuku-wa'ne'yoo. Saa'a yise ka Te Naa te ya'e-wikoo tamme oo mayodase, te tumakodyuku-kwi tamme nasootuhikwu. Pana tamme ka tu pupua'amu te nananumu, yise ka besa manepunnedu te nanumu suu'mu tuka bise, umu saa'a punno'o te tuka bikwu, umuoo yise mooasoo te tumakodyukukute. Saa'a soo Te Naa gi ooonekwitoo te sootuhi-wa'ne'yoo.” ");
INSERT INTO paoNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Sumu'yoo numu ka Te Pabe'e-no tukana meeoo, “Mu numu ka Te Naa-no'yoona ewa besa nasootuhikwu mu ewa tukadu besa sokwamakwu.” ");
INSERT INTO paoNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Soo Te Pabe'e ka Te Naa paba ewa tuka-kwitu yise ka nana natukwenguna, “Sumu'yoo numu tu pupua'amu makakwuse mee soonammena, ");
INSERT INTO paoNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","ewa yongo saa tuungu, ewow tu pupua'amu oetoo bi. ");
INSERT INTO paoNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Pana mu oo pupua'amu mee oo sooyugwena sukwe nanemaweakooha sumu'yoo oo pua'a mee oo netamma, ‘Nu ka tubewabe heetoo'ase, nu oo tasootzemahookwu.’ ");
INSERT INTO paoNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Sumu'yoo punno'o meeoo, ‘Nu sumumano (10) kootsoo tumuhoose, nu umuoo poopoonnegakwu.’ ");
INSERT INTO paoNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Oosoo sumu'yoo punno'o meeoo, ‘Nu gi kemma-wa'ne meno'o manepunne, nu pudu nodukwadoohoose.’ ");
INSERT INTO paoNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Soo oo tayana ka kodyu petuse, ‘Umu gi kemmow-wa'ne meno'o manepunne,’ meeoo oo tuukwe. Soo nana suda oo nakwumaku ka ewa tukooma hane tuunguse tu pupua'amu gi kemma. Ka pumme tummatzidu yise mee netamma, ‘Manatutooe mu numu nemasumudoodooa, tooe hownnekoo tooe, mu tutuha manedu, mu gi unu besa mamanemodu nokosoo gi tutubootabuedu, tooe hownnekoo tooe umu ewa tukoohane, umu nu-no tukakwu.’ ");
INSERT INTO paoNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Saa'a mu numu oo bi petuse mee oo netamma, ‘Nu mooasoo nuka u netamma-kwa'ne manese sapa, ewowsoo tamme soogwa'e. Gisoo u nobe kaa'no.’ ");
INSERT INTO paoNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Soo nana yise ka pumme tummatzidu tayasoo too meeoo netamma, ‘U sakwa manatutooe mu numu masumudoo, yise e nobe kaanohookwu. ");
INSERT INTO paoNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Pana umu numu mooe'ugasoo e too'e bina umu gi nu-baatu yongo tuka-wa'ne'yoo.’ ” ");
INSERT INTO paoNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Ewa'yoo numu ka Te Pabe'e-nakwi meadape. Soo Te Pabe'e yooihoose umu-tamme nakwumunase mee mu netamma, ");
INSERT INTO paoNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Mu nuka no'okosoo hemma-ooonakwa unu soowabega. Mu sakwa ka mu naa, mu pea, mu nodukwa noko mu doodooamu, mu samoomu, muusoo sapa tuwow nuka mu-ooonakwa unu soowabega, o'no mu ka E Naa besa podo meadabekwu. ");
INSERT INTO paoNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Mu nu-koobatoo nasoomawunise tooe mu nabatsase sapa, o'no mu nu-no'yookwu. ");
INSERT INTO paoNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Mooe'ugasoo gisoo ka Te Naa besa podo meana, tamme sakwa oetu soohane, tamme haa'a tooe oo mane-wa'ne'yoo? ");
INSERT INTO paoNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Soo numu puu ka nobe-tookwuse ka gi oo nanenagakwuna mooe soohanena sukwe nobe-tookoohase, ona manikese, tukwumehoe petugase yise oto oo matusookwuni. O'no yise mu numu oo-ma'yoona nanekoe. ");
INSERT INTO paoNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","‘Ma how manedu masoo? Masoo sakwa uga mitu soohanese, o'no yise uga nobe-too.’ ");
INSERT INTO paoNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Tamme sakwa nakobenatusoo soohanena ka na'akwebu moohedu-wa'ne, oosoo tu manikwuna puu mooe soohanese numu-no nagoekwu. ");
INSERT INTO paoNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Oosoo ka mu tubetse ewow, ka gi mu matzooeku-wa'ne manepunnena, oosoo yise umu-no oetu nehanese mu tu pupua'amu-doose sumusoo nanano besa meadabekwu. ");
INSERT INTO paoNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Mu ka nu-no'yookwuse mu no'oko mu hee-gana matusookwunikwu, o'no gi hee mu tsitugukwu. ");
INSERT INTO paoNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Ongabe puu besa'yoo ka ongakamana. Ka gi ongakama manese, tamme gi hownnekoo oo madi-wa'ne'yoo. ");
INSERT INTO paoNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Oosoo gi he-toogoo besa'yoo ka gi kamana, tamme oo totsakwatekwuna'e. Ooosoo tamme ka Te Naa besa podo meadabena, ka te kammana kadoo manepetugase, Te Naa te totsakwatekwuna'e. Mu sakwa e nakapunne, o'no mu gi nasootuaganedooa.” ");
INSERT INTO paoNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Ewa'yoo umu tumasumudoodu-no kumma'akoosoo numu tuma'emukwadu ka Te Pabe'e yadooadyakwe oo-baa petuse oo nakapunne. ");
INSERT INTO paoNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Umu Pharisee nanesootuhibu numu tunedyooedu mee naneyugwedu ka Te Pabe'e nesootzemana mee unakwe, “Oosoo Jesus ka mu tuma'emukwadu pupua'amu-ga'yoo umu-no tukayakwe.” ");
INSERT INTO paoNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Soo Te Pabe'e yise meeoo mu natugwengayakwe. ");
INSERT INTO paoNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Tamme puu ka ewow seepu-gana sumuoo nawatsekuse ka mu ewow seepu ka giba-masoo ma'wukese ka sumuoo seepu nawatzekudu watehookakwu. ");
INSERT INTO paoNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Ka nawatzekudu seepu mayuse, tamme ka besa soonammena nobe-kwitoo oo tzanogakwu. ");
INSERT INTO paoNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Mee yise tamme ka te pupua'amu tuukwekwu, ‘Mu sakwa nu-no besa sokwamapunne, nu ka seepu nawatzekuse oo mayusoo.’ ");
INSERT INTO paoNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Ka umu Te Naa tutummatzidu mu toha kakasa-ga'yoo puu besa sokwamayakwe ka sumuoo numu tuma'emukwadu nanekwahayakwe, pana mu numu kaaheno meadu mee sukwe naneyugwedu mu toha kakasa-ga'yoo suda oo sokwamakute ka gi kaaheno mu nanekwaha. ");
INSERT INTO paoNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Soo mogo'ne puu sumumano (10) ese tupe-ma namadabuedu hee-ga'yoo yise sumuoo watzekuse toogootabuakuse tu nobe-kwitu wutzoo'nekwu oo watena. ");
INSERT INTO paoNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ka oo mayuse besa soonammena mee tu pupua'amu-noko tu nopua'amu tuukwe'e, ‘Nu besa soonamme ka e tuwatzekuna mayuse.’ ");
INSERT INTO paoNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Ooosoo umu Te Naa tutummatzidu mu toha kakasa-ga'yoo besa sokwamakwu ka sumuoo tuma'emukwadu namayuse ka Te Naa besa podo meno'o meakwu.” ");
INSERT INTO paoNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Soo Te Pabe'e yise meeoo natugwe'nga, “Sumu'yoo nana waahoo dooamu-ga'yoo. ");
INSERT INTO paoNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Soo oo penage ka tu naa meeoo netamma, ‘U sakwa ka hemma saa'a u ya'ese nuka u hanekukwuna meno'osoo e haneku.’ Soo mu naa yise tu hemmatu oo haneku. ");
INSERT INTO paoNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Saa'a yise soo oo tooa ka pumme tu hee-maga-ma tumuse yise kwinga'a-too mea. Ewa nanasuda manena yabesoo ka pumme tu hemma-gana pumatu tu tumupu tzasoo'ow. ");
INSERT INTO paoNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Ka saa'a ka tukapu unu natugeno'o, oosoo tsuayina ka tu hemma tzasooase gi hownnekoosoo ka tukapu tumu-wa'ne manepetu. ");
INSERT INTO paoNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Sumu'yoo nana oonow tabewa-ga'yoo hogu-ga'yoo oo nedya'we ka tu hogu oo maka tuunguna. ");
INSERT INTO paoNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Oosoo ka unu tsuayina ka ‘Umu hogu namakana sakwa nu tuka,’ mee soonamme ka gi hownnekoo ka nadukadu tamamayuna. ");
INSERT INTO paoNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Oowetu soohanese mee tusooyugwe, ‘Meno'o nu tsuaya'ega'a. Pana umu e naa tummatzidu puu besa namakayakwe ewa natugapeniyakwe. ");
INSERT INTO paoNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Nu sakwa nobe-kwitoo kodyuse ka e naa mee netamma, “Nu tubetse suda u masoonammekute, ka Te Naa tuwazoo. ");
INSERT INTO paoNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","U sakwa gi e natubangapana, nu ka suta'yoona, u sakwa e sukwe nedya'we.” ’ ");
INSERT INTO paoNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Oosoo yise nobe-kwitoo kodyuka gisoo pumme oo wupetuga'a soo oo naa ona o kemma o posopedakwudoose tutuha oo poosoopedyase oo-matoo tanomanese, oo masootuhi petuga. ");
INSERT INTO paoNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Soo oo tooa yise meeoo oo netamma, ‘Nu tubetse suda mu manuuma ka Te Naa tuwazoo. Mu sakwa gi e natubangapana, nu ka suta'yoona.’ ");
INSERT INTO paoNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Pana soo oo naa ka umu pumme tummatzidu mee netamma, ‘Yabesoo ka e dooa besa namasooapu hanekuooke, ma'negea'a tuwow, moko pukwi oo namadabuekwuna oo hanekuooke. ");
INSERT INTO paoNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Ka unu yoohoopu te tubatsakwuna kootsoo hanehoodooa oo batsahoose oo koomahanekooha. Tamme ewa tukase besa sokwamakwu. ");
INSERT INTO paoNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Oosoo ka yoo manepunnena nu ka e dooa watzekutu-kwa'ne mane ka oo petuse tooe nanasuda oo manenumme sapa, nu besa soonamme ka oo petuse. Umu yise ewa tukana too nuka.’ ");
INSERT INTO paoNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Saa'a soo oo pabe'e oona tubewabe-kwi'yoona kemmana, ka mu tunekwu'u mu nakana, ");
INSERT INTO paoNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","ka sumuoo umu tu naa tummatzidu-matu meeoo tubenga, ‘How manena umu nugadu-kwa'ne nanaka?’ ");
INSERT INTO paoNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Soo tutummatzidu yise meeoo oo tuukwe, ‘U wannga'a petuoosesoo, u naa ka unu yoohoopu kootsoo oo batsaku. U naa ka oo-matoo besa soonamme ka oo petuhoosesoo.’ ");
INSERT INTO paoNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Soo oo pabe'e sutahoose gi ka nobe-kwi eka. Soo oo naa oo-matoo tsebooekese oo too'e ba'e. ");
INSERT INTO paoNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Pana oosoo ka tu naa meeoo netamma, ‘Nu tubetse wuna'me ooosapa u nakabetseanumme. Pana u gi hannano'o hemma e geadu. Gi moosooe seepu tooa'a sapa, ewa e pupua'amu-no e tukakwuna e batsakute. ");
INSERT INTO paoNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Pana u tooa ka pumme u hemena ka mu sutakoo momoko'ne-matoo sukwe tzasoo'a, meno'o kodyu petuse u yise ka unu yoohoopu kootsoo oo batsakukwu.’ ");
INSERT INTO paoNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Soo oo naa yise mee oo nanekwegeadooa, ‘U e besaa tooa ooosapa nu-baatu. No'yoona soo nuga hee umetu-kwa'nesoo manepunne. ");
INSERT INTO paoNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Besa'yoo te ewa tukana ka besa ta sokwama. Yoo soo manepunne, soo u wannga'a uga nawatsekupu-kwa'ne manese, meno'o yise ka petuse tamme besa sokwama oo-matoo.’ Yooosoo soo Te Naa ka manatooe how tooe te manemose ka te kodyu petuse besa tamme-matoo soonammekwu.” ");
INSERT INTO paoNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Soo Te Pabe'e yise ka umu pumme nakatzimodu mee natugwenga, “Sumu'yoo nana hee-ga'yoo kumma'akoosoo numu tu hemma mabetsea tuungu. Saa'a yise mee oo naka, gi besa oo hemma meakute. ");
INSERT INTO paoNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Oosoo yise nabaatoo oo bise mee oo netamma, ‘U ka e hemma sukwe tzasoo'a mee nu u naka. Ka no'oko hemma e tumadabue tuunguna nu-matoosoo haneke, u gi hemma e mabetseakukwu yaa manakwana.’ ");
INSERT INTO paoNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Soo oo mameakudu mee soonamme, ‘Howga nu manekwu? Nu ka umu hemma how nuugwewununa gi mapu'ana gi mu numu e nedya'we-wa'ne'yoo. Nu mu numu hemma e natuunguna nasookwikute. ");
INSERT INTO paoNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Nu sakwa ka numu hemma sukwe hanekwu, o'no umu saa'a ka e nadayahoose e makadooa.’ ");
INSERT INTO paoNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Oosoo yise no'oko mu numu ka pumme nedya'wedu nagutzikudu nabaatoo bi. Ka mooe'ugasootu mee tubenga, ‘Haa'noko u ka e nedya'wedu nakutzikute?’ ");
INSERT INTO paoNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Oosoo meeoo oo nanekwege'a, ‘Ewatsekoo yoohoo, nu oo nakutzikute.’ Oosoo yise mee oo netamma, ‘Yaasoo u tumadabuepu. U sakwa oo naamookwitusoo ma-ma botugu.’ ");
INSERT INTO paoNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Ka sumuoo yise too meeoo tubenga, ‘U punno'o haa'noko oo nakutzikute?’ Oosoo meeoo oo nanekwegea, ‘Ewatsekoo weeda nu oo nakutzikute.’ Mee yise oo netamma, ‘Yaa punno'o ume tumadabuena huutsekoo mi botugu.’ ");
INSERT INTO paoNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Saa'a soo oo nedya'wedu yise ka tu hemma mameakudu manena naka, mee yise oo netamma, ‘U tubetse unu soonamme. U ka nawitu poohina.’ ");
INSERT INTO paoNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Ka yaa teepu-kooba'yoona mu gi tunaka'oedyukudu ooosapa nawitu poohi ka umu tunaka'oedyukudu soonamme. Tamme sakwa punno'o nawitu soohane. Tamme sakwa ka yaa teepu-kooba'yoona te hee-matu numu hanekuna, besa mu matuguna ewa pupua'amu-ga. O'no ka saa'a tamme ka Te Naa-baa petugase, soo Te Naa te sootuhikwu ka besa te tumatugu-koobatoo. ");
INSERT INTO paoNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Tamme ka gi unu nanenagadu he-koobatoo esagoena, tamme ka unu nanenagadu he-koobatoo esagoekwu tuwazoo. ");
INSERT INTO paoNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Yoo manepunne tamme ka yaa teepu-kooba'yoona ka gi te hemma kaaheno mabetseana, saa'a ka Te Naa-baa manepetugase tamme gi ka tubetse nasootuhipe nageakwu, tamme ka gi kaaheno mu tumatuguna mabetseana. ");
INSERT INTO paoNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ka yaa teepu-kooba'yoona ka gi kaaheno hemma mabetseana saa'a ka Te Naa-baa petugase, tamme gi tammesoo hownnekoo nasootuhipe nageakwu. ");
INSERT INTO paoNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Tamme gi hownnekoo waahoo soowabega-wa'ne'yoo. Sumuna tamme sumuoo besa soobedyana besa oo nakabetseakwu. Tamme gi namekoosoo soogwi-wa'ne'yoo ka Te Naa noko ka hemma ewow te hee-gana.” ");
INSERT INTO paoNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Mu Jew nanesootuhidu numu Pharisee mee nananeadu ooosapa tu natumanakakuna soogwipunnedu. Umu yise ka Te Pabe'e unnepu nakase gi oo nakaheesoobedyana oo-ma'yoona sukwe naneko'e. ");
INSERT INTO paoNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Soo Te Pabe'e yise mee mu netamma, “Mu ka mu numu mee tuukweyakwe, ‘Soo Te Naa besa ne sootuhise ewow ne heemaka numme ka besa'yoo numuna.’ Pana soo Te Naa gi mu watzekupunne ka yow teepu-kooba'yoona besa namanekwuna. Ka mu numu yaa teepu-kooba'yoona besa mee mu nasooyugwedu, saa'a ka Te Naa-baa petugase, ‘Gi hee,’ mee oosoo mu netammadooa. ");
INSERT INTO paoNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Ka John gisoo petu-kwitoo tooe mu ooosapa mu mooa tumayohope nageno'o. Pana meno'o numme ka Te Naa besa unnepu numu tunedyooena no'obatusoo numu tookwa etzaga eka mee soonamme. ");
INSERT INTO paoNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Pana soo Te Naa unnepu gi yise atasoo nuugwe-wa'ne'yoo, ooosapa manepunne. ");
INSERT INTO paoNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Mu yise meeoo, ‘Oosoo numu ka tu nodukwa poonnekwunise kumma'akoosoo mogo'ne nodukwadoose te tumayoho-kwi oosoo gi hownne'yoo,’ pana ka Te Naa tamme poonne-kwi mu ma'emukwa. Yise ka napoonnekwunina mogo'ne nodukwadoose, mu too tuma'emukwasoo esoo togesoo Te Naa unnepu.” ");
INSERT INTO paoNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Mee yise soo Te Pabe'e mu natugwenga tuwazoo, “Soo ewow hee-ga'yoo nana ooosapa unu nanenagadu namasooadu. Nonotsa tabeno besa tukayakwe. ");
INSERT INTO paoNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Nonotsa tabeno oo nobe-kumaba soo tutuha manedu nana unu uayidu, Lazarus mee naneadu habeyakwe. ");
INSERT INTO paoNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Ka ewow hee-gakoo nana tugutsa'abu natuunguyakwe. Mu sadu'u yise punno'o ooosapa oo ua-witu ekosebayakwe. ");
INSERT INTO paoNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Saa'a yise soo Lazarus ya'e. Umu toha kakasa-ga'yoo Te Naa tutummatzidu ka oo moogooa Te Naa-baatoo bika. Oobeoo petuoogase ka besow te namooatupu Abraham mee naneadu-kumaba katuse oo-no tuka. Soo ewow hee-ga'yoo nana punno'o ya'ese nakoo. ");
INSERT INTO paoNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Ka goso gi tookedu-wi petuga. Toogoopatu poonnese nakwinga'atoo ka Abraham poonne ka Lazarus oo-baa katu. ");
INSERT INTO paoNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ka Abraham wa'agese meeoo netamma, ‘E pua'a, u sakwa tutuha e soobedyase ka baa-wi Lazarus mamoogoo oo tsetzaka tuungu soo Lazarus sakwa ka e ego-koobatoo ooka oo pasaweku tuungu, esoo goso nuummabu e wumakute.’ ");
INSERT INTO paoNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Soo Abraham yise meeoo oo netamma, ‘Uga tooe oo sooma'yu ka togesoo ka teepu-kooba nummenummena, u uga ooosapa ewow hee-gana, oo-ma nasoonatzina, meno'o yise oosoo gi u magwetzo'i gi hemma nesoobedya tooe ka Lazarus tutuha manenumme sapa u gi oo tummatza'e. Meno'o Lazarus yise besa hee-gana u yise nuummaba wuma. ");
INSERT INTO paoNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Numme gi hownnekoo u tummatzi-wa'ne'yoo ka pabow tukapa ta naamookwi hape.’ ");
INSERT INTO paoNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","28","Soo uga ewow hee-ga'yoo nana yise ka Abraham mee oo netamma, ‘U sakwa umu manegeoo (5) e wanga'amu-matoo ka Lazarus taya, oosoo mu tuukwe ka e namanatzayina. O'no saa'a umu gi nu-kwa'nesoo manedooa.’ ");
INSERT INTO paoNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Soo Abraham yise meeoo oo netamma, ‘Umu haa'a gi mu Te Naa yadooawabe tubona neadu?’ ");
INSERT INTO paoNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Oosoo yise ka Abraham meeoo netamma, ‘Umu gi ka Te Naa nayadooawabe nakaheesoobedyadu pana mu ka Lazarus ya'epu oo sopedakwadoona ka pu-baasoo oo petugase, o'no umu oo oedyukukwu.’ ");
INSERT INTO paoNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Soo Abraham yise meeoo oo netamma, ‘Umu ka mooasoo gi Te Naa unnepu naka'oedyukuna tooe umu numu ya'ekwikoo namayoda pu-baa petuga sapa, umu gi oo naka'oedyuku-wa'ne'yoo.’ ” ");
INSERT INTO paoNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Soo Te Pabe'e yise pumme nakatzimodu mee netamma, “Ooosapa ewa'yoo numu ooonne'yoo, ka suta-kwitoo numu mesoo kwase nokayakwe. Soo suta'yoo umu-matoosoo kodyukwu. ");
INSERT INTO paoNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Umu ka sumuoo Te Naa tooa-matu kwase nokase, soo mu manena hanoba'yoonasoo umu-matoosoo kodyukwu. ");
INSERT INTO paoNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Tamme sakwa ooosapa ka te pua'a besa matuguna mu tummatzi yise ka te pua'a tamme suda matugu tamme sakwa oo tuukwe. Oosoo ka suda tu manena nemakodyuse tamme sakwa oo soomu'wakwuni. ");
INSERT INTO paoNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Tooe hano sapa oo matuadyigena yise ka ooka oo nemakodyukuyakwe tamme sakwa ooosapa punno'o oo soomu'wano.” ");
INSERT INTO paoNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Umu Te Pabe'e nakatzimodu oo-matu kemmase meeoo netamma, “Unusoo besa ne tu'oedyukukwuna ne sootuhi.” ");
INSERT INTO paoNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Soo Te Pabe'e yise meeoo mu netamma, “Tooe tamme tuutse te pewu katzookwanatuma tu'oedyukuna, ka sunngabe ooweoo baa-witoo anoa tuunguse oosoo yise te tunetammatusoo manekwu. ");
INSERT INTO paoNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Gi sakwa tamme pabow oo neyugwena Te Naa unnepu mayohonona, mooasoo tamme tu tunepohabekuna mayohodyina. Ka tummatzidu-kwa'ne oosoo puu ka puuwanatu mamakwuse nobe-kwi petu. ");
INSERT INTO paoNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Oosoo puu gi katuhoopetuse tukakoohakwu. Mooe'ugasoo oosoo ka pumme nedya'wedu tukakwuna mooe haneoose, ");
INSERT INTO paoNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","yise saa'a ka pumme nedya'wedu tukamakwuse, o'no yise punno'o tukakwu. Oosoo gi ha'yoo oo sooyugwe, ‘Nu ka mooasoo oo tu tunepohabekuna mayohodyina.’ ");
INSERT INTO paoNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Tamme ka Te Naa tunepohabekuna mayohodyina, gi sakwa tamme papaba oo sooyugwepana o te nagekwuna yaa manakwana.” ");
INSERT INTO paoNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Soo Te Pabe'e ka Jerusalem-witoo meana, ka umu Jew numu noko wakwawa'a numu tubewabe Samaria mee naneadu-kumi mea. ");
INSERT INTO paoNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Toge ka Samaria-wi oo egeakakwuse sumumano'yoo (10) nanana uagoedu oo wegeahoo. Umu gi oo tzage'e nuuyugwena, ");
INSERT INTO paoNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","mee oo sukwe netamma, “U Ne Pabe'e Jesus, u sakwa ne sootuhi.” ");
INSERT INTO paoNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Soo Te Pabe'e yise mee mu netamma, “Ka mu Jew numu nanesootuhiwabe tzapoonneku mu mooasoo namabesakuhoo.” Ka tooesoo mu meaga'a mu ua besa manika. ");
INSERT INTO paoNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Sumu'yoo wawa'a nana suu'mu ka tu ua namabesakuse besa soonammese ka Te Pabe'e-matoosoo kodyuhoodooa mee unneno'o, “Soo Te Naa tubetse besa'yoo.” ");
INSERT INTO paoNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","17","Ka Te Pabe'e-kobena petugase mee oo netamma, “U besa e sootuhi ka e mabesakuse.” Soo Te Pabe'e yise meeoo unakwe, “Nu sumumanoko (10) nanana mabesaku pana sumu'yoosoo umu-matu kodyutooa ka Te Naa besa pumme tumatugukupu waha. Umu sumu kadoopu (9) Jew nanana gi kodyu petu, umu sumuna ooosapa meaga'a. ");
INSERT INTO paoNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Esoo sumu'yoosoo wawa'a nana yise kodyu petu yise mu uagoedu e nanumu gi e heesoobedya tooe pumme e mabesakuse sapa.” ");
INSERT INTO paoNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Soo Te Pabe'e yise ka wawa'a meeoo netamma, “Tooe u wawa'a pana, u ka tunaka'oedyukuna namabesaku, meno'o yise u nobe-kwitoo mesoo kodyu.” ");
INSERT INTO paoNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Mu numu ka umu nananesootuhidu-nagatu Pharisee mee nananeadu ka Te Pabe'e mee tubenga, “Hannano'o soo Te Naa te nemadabuedooakwu?” Soo Te Pabe'e mee mu nanekwegea, “Gi tamme oo poonne-wa'ne'yoo ka tamme oo nemadabuekoohase. ");
INSERT INTO paoNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Numu gi meeoo unne-wa'ne'yoo, ‘Meno'o soo Te Naa te nemadabue,’ soo Te Naa ka mooasoo tamme-nagakwitoo nemadabuena.” ");
INSERT INTO paoNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","25","Soo Te Pabe'e yise ka pumme nakatzimodu meeoo netamma, “Mooe'ugasoo mu Jew numu meno'o yaa teepu-kooba gwetzoimodu, gi e naka'oedyukute. Umu e batsakwu. Saa'a mu sakwa e poonne mee tooe sokwamapana mu gi e poonne-wa'ne'yoo. Mu susumudu mu nemooagakwu mee mu netammakwu, ‘Soo Te Pabe'e mooasoo watze petuse oonowsoo numme-baa.’ Mu sakwa gi mu nakabetseapana. Nu tooe hano'yoona tooe mesoo napoonnekwu ka petuhoose tukwukwutzeba-kwa'ne. ");
INSERT INTO paoNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Ka gisoo e petu mu numu gi e nakaheesoobedyadu tooe how tooe ma'na'wekwu. Ka o'nosoo tu mane-kwa'nesoo ka nana Noah mee naneadu togesoo ka yaa teepu-kooba gwetzoi nummenumme. ");
INSERT INTO paoNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Umu puu gi oo nakaheesoobedyadu tooe pumme oo tooe tuukwe sapa tukana, hebena, tooe how tooe manakwe. Ka o'no tabeno ka Noah ka sake-wi tsebooese, powma petuse soo teepu patatsopowse mu numu ka teepu-koobatu no'yoona batatuihoo. ");
INSERT INTO paoNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Ka o'nosoo ka namanepu tuwow ka Lot togesoo eka teepu-kooba gwetzoinumme, mu numu puu tukana hebena, hemma tumuna, tumasuana, nobe-toodyakwe atasoo. ");
INSERT INTO paoNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Pana ka Lot ka Sodom-wi'yoona namame'a soo goso pa'anakwana powmadu-kwa'ne sawewunuse no'oko mu kootuikuoo. ");
INSERT INTO paoNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Ooosoo mu meno'o numu ma'na'wekwu, ka saa'a e kodyu petuse. ");
INSERT INTO paoNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Mu puu ka nobe-kobena'yoona tooetoo ona tubewabe-kwi'yoona, mu sakwa gi mu nobekwitoosoo kodyupana tooe ka mu hemma soomayupana. ");
INSERT INTO paoNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Mu sakwa ka Lot nodukwa manepu soomayu. Oosoo puu ka namameahoose wesabetugase, ongabe mani. ");
INSERT INTO paoNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Tamme ka tammesoo tooe namagwetzoina, tamme kadoo nuugwekwu, pana ‘Ka gi hownne'yoo tooe nu ka Te Pabe'e-koobatoo nabatsase sapa,’ mee unnena tamme namagwetzoikwu. ");
INSERT INTO paoNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Ka yaa teepu-koobasoo e petuse sumuna waha'yoo numu kapa-wi utuikwabekwu, sumu'yoo tunaka'oedyukudu nu-no manegakwu sumu'yoo gi e nakaheesoobedya umu natzapenihookwu. ");
INSERT INTO paoNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Sumuna waha'yoo momoko'ne oona'yoona toosoona, sumu'yoo tunaka'oedyukudu nu-no manekakwu sumu'yoo gi e nakaheesoobedyadu oosoo natzapenihookwu.” ");
INSERT INTO paoNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Sumu'yoo mu Te Pabe'e nakatzimodu-matu mee oo tubenga, “Hano'yoona oo namanekwu?” ");
INSERT INTO paoNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Soo Te Pabe'e mee mu nanekwegea, “Tooe hano'yoo tooe mu kwe'na'a puu ka hemma nabatsa-kwi sumuhookwu. O oosoo puu oo sopedakwadoo tabu'a.” ");
INSERT INTO paoNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Soo Te Pabe'e ka mu numu mee tunedyooe, “Tamme sakwa ooosapa nanetzakwiyino gi oo nasoomukwapana tooe gi yabesoo tamme tu nekwegea sapa.” Soo Te Pabe'e ka mu numu meeoo natugwe'nga, ");
INSERT INTO paoNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","“Sumu'yoo suta'yoo nana gi ka Te Naa-wi tunaka'oedyukudu, gi numu tutuha soobedyadu, mu numu-nehanedu. ");
INSERT INTO paoNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Nonotsa tabeno sumu'yoo peawabe oo-baa petuyina mee oo netammayakwe, ‘Oosoo e wohonedu suda e matugu. U sakwa e tummatzi.’ ");
INSERT INTO paoNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Wuna'me soo numu-koobatu nehanedu gi oo nakabetsea pana saa'a mee soonamme, ‘Tooe nu gi ka Te Naa-wi tunaka'oedyukuna gi mu numu tutuha soobedyapana, nu sakwa ka peawabe tumayohoku. ");
INSERT INTO paoNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Ka nonotsa tabeno e tubenguna e nesagwa'e.’ ” ");
INSERT INTO paoNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Mee tuwazoo soo Te Pabe'e unakwe, “Soo suta'yoo nana numu-nehanedu ka peawabe ooosapa pumme nanetsagwayi oo tumayohoku. ");
INSERT INTO paoNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Soo Te Naa ka umu tu doodooamu nakasootuhikwu ka nonotsa tabeno mu nanetzakwiyino'o, ka nonotsa togano tuwazoo. ");
INSERT INTO paoNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Umu nagutza tubetse wuna'me tuutooe, soo Te Naa yabesoo mu nanekwegeahookwu. Pana ka yaa teepu-koobasoo e kodyu petuse, sumuna mu numu tu'oedyukudu kadoo'yookwu.” ");
INSERT INTO paoNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Susumudu numu puusoo besa nasooyugwena kukumma'akoosoo numu suta'yoo mee sooyugwe ooonne'yoona soo Te Pabe'e mee mu natugwe'nga'a. ");
INSERT INTO paoNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Waha'yoo numu-ga ka mu nanesootuhidu tunehane-kwitoo memeakwate. Sumu'yoo ka mu nanesootuhidu Pharisee mee nananeadu-nagatu, sumu'yoo yise tuma'emukwadu. ");
INSERT INTO paoNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","12","Soo mu Pharisee-matu ka mu numu-wana wununa nanesootuhiwunu, ‘Ne Naa u tubetse besa'yoo. U nuka besa matabue gi ka numu-wa'nesoo. Nu ooosapa nono'otsa awamooa nanesootuhina pooha tuwunikwu punno'o. Mu susumudu numu suda sukwe manena unu moomoogoobana unu nanidyapu. Soo o wunudu tuma'emukwadu puu ooonne'yoo. Nu gi oo-wa'ne'yoo.’ ");
INSERT INTO paoNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Soo tuma'emukwadu nasookwina gi oetu poonnena sukwe nanesootuhikooha, ‘Nu tubetse ewa suda manakwe. U sakwa tutuha e soobedyana e tuma'emukwana soomu'wa.’ ");
INSERT INTO paoNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Ka mu nanesootuhimakwuse soo Te Naa mee unakwe, ‘Oosoo tuma'emukwadu besa manakwe ka tu tuma'emukwana nematzakwunina, nu yise oo sootuhikwu suda oo manepu soomu'wakwu. Soo Pharisee numu togesoo suta'yoo tu tuma'emukwana gi nematzagana, puusoo besa nasooyugwena.’ Tamme ka tammesoo besa nasooyugwena gi hee ka Te Naa-nakwana. Pana tamme ka tammesoo gi maawa'ne'yoo e mee nasooyugwena, o'no soo Te Naa te sootuhikwu.” ");
INSERT INTO paoNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Mu numu tu doodooamu tooe Te Pabe'e-baa bi petugonno umu mu nanesootuhiku tuunguna. Mu oo tunakatzimodu ka mu poonnena mu numu nesagwikute ka oo mu manegonno. ");
INSERT INTO paoNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","17","Pana soo Te Pabe'e meeoo mu tu nakatzimodu netamma, “Gi mu numu mu dooamu hane petugonnodu nedagonnopana. Mu tututsekoo dooake nu sootuhikwu.” Soo Te Pabe'e yise meeoo unakwe, “Nu kaaheno mu tuukwekwu. Soo tuha'yoo ka ha'yoo oo tuukwe oo naka'oedyukukwu. Mu sakwa ka tuha'a-kwa'ne tunaka'oedyukuna mu ka Te Naa-baa petugakwu.” ");
INSERT INTO paoNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Sumu'yoo numu moohedu ka Te Pabe'e meeoo tubenga, “U tubetse besa'yoo nana. Ha'oo besa sakwa tuwow nu manese namagwetzoi?” ");
INSERT INTO paoNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Soo Te Pabe'e yise meeoo oo nanekwegea, “U haa'a mee e netamma, ‘U besa'yoo,’ gi haga besa'yoo, Te Naa suu'mu besa'yoo. ");
INSERT INTO paoNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","U oo sopedakwatoo ka Te Naa tamme tuukwepu: gi numu batsapana, gi numu nowuakupana, gi tuduhapana, gi esayipana numu mane-witu, besa tu naa noko tu pea sooyugwena.” ");
INSERT INTO paoNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Soo nana yise meeoo oo netamma, “Mooasoo nu tuha'yoona meeoo na'unnedu nakabetseakena.” ");
INSERT INTO paoNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Soo Te Pabe'e ka nana unnena nakase mee oo netamma, “U sakwa no'oko u hemma-ma tumuse ka u nahemena ka mu tutuha manedu hanekuse, o'no yise u ewow hee-gakwu ka Te Naa-baa'yoona. O'no u yise nuka nakatzinummekwu.” ");
INSERT INTO paoNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Soo nana yise ka oo unnena nakase suda soonamme ka ewow hee-gana, tu hemma unu nenagana. ");
INSERT INTO paoNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","25","Soo Te Pabe'e oo poonnepunnena ka nana-witu meeoo netamma, “Oosoo ewow hee-ga'yoo tuheka-ma nasoonatzina gi puusoo namagwetzoi-wa'ne'yoo.” ");
INSERT INTO paoNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Mu oo tunakatzimodu ka Te Pabe'e nakase punno'o meeoo tutubenga, “Hownnekoo soo numu yise mesoo namagwetzoi?” ");
INSERT INTO paoNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Soo Te Pabe'e meeoo unakwe, “Soo numu gi puusoo namagwetzoi-wa'ne'yoo. Pana soo Te Naa suu'mu mu magwetzoikwu.” ");
INSERT INTO paoNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Soo Peter yise meeoo oo netamma, “Mooasoo numme no'oko hemma puu ne heegana ma'wugese u-no maneke.” ");
INSERT INTO paoNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","30","Soo Te Pabe'e yise mee mu netamma, “Tooe haga tooe, tu nobe ma'wukadu, tu nanumu noko hemma tu hee-gana tu doodooamu tu tubewabe, ka nuka nagena ewowsoo besa no'obatusoo nasootuhikwu, meno'o manakwana. Mu nasootuhikwuna gi moobegwagakwu.” ");
INSERT INTO paoNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","32","Soo Te Pabe'e ka Jerusalem-witoo umu tu nakatzimodu sukwesoo nesumudoose umu-no yadooana meeoo mu netamma, “Tamme ka Jerusalem-wi petugase, soo Te Naa yadooawabe o'nosoo nu-witu tubotugu oto nanemamakwu. Umu numu tutunehanedu nu-ma tzakadukwuse, ka mu tibo'o-matoo e tzamunase umu yise e batsakwu. ");
INSERT INTO paoNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Umu tibo'o yise e kobitoo toohegonno e wupagetana, yise e batsakwu. Pana nu yise saa'a pahe tabe mease tuusootabuedooa,” mee. ");
INSERT INTO paoNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Pana mu oo nakatzimodu yise gi oo nakasopedakwatoo yise meeoo nana'unakwe, “Ha'yoo na'unnedu tamme gi nakasopedakwatoo?” ");
INSERT INTO paoNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Ka Jericho tzage'e ka Jesus manekena sumu'yoo gi tubootabuedu nana oonow po-kumaba katuna ka mu numu natummatzi tuunguyakwe. ");
INSERT INTO paoNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Esoo gi tubootabuedu nana ka mu ewow numu pukumi meadu meeoo tubenga, “Ha'oo haa'a namanewunu?” mee. ");
INSERT INTO paoNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Mu numu yise meeoo oo netamma, “Soo Jesus yaa kemma.” ");
INSERT INTO paoNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Soo gi tubootabuedu yise meeoo ka Te Pabe'e netamma, “E Pabe'e e sootuhi.” ");
INSERT INTO paoNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ewa'yoo mu numu oo-na'oonnakwitu yise oo nedayakwe. “Gi unnepana,” mee oo netammayakwe. Pana soo gi tubootabuedu yise pabasoo ka Te Pabe'e yadooadyakwe, “U E Pabe'e, u sakwa e sootuhi.” ");
INSERT INTO paoNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Soo Te Pabe'e yise yoo'ipetu ka mu numu ka gi tubootabuedu tsaka tuungu. Soo Te Pabe'e ka pu-baa ka gi tubooetabooedu natzaka petuse meeoo oo tubenga, ");
INSERT INTO paoNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Hownnekoo natummatzi u sookwina?” mee. Soo gi tubootabuedu yise meeoo oo netamma, “Nu gi tubootabuena yaatu soopoonne.” ");
INSERT INTO paoNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Soo Te Pabe'e yise meeoo ka gi tubootabuedu netamma, “Mow u ka besa tunaka'oedyukuna, meno'o yise u yaatu poonnekwu.” ");
INSERT INTO paoNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Yabesoo yise soo gi tubootabuedu besa manise yaatu besa poonnena ka Te Pabe'e nakwi ka podo meadabekoo. Mu numu ka gi tubootabuedu nana namabesakuse oo poonnese yise ka Te Pabe'e nesookwugi. ");
INSERT INTO paoNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Soo Te Pabe'e ka Jericho mee naneadu-too meana. ");
INSERT INTO paoNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Sumu'yoo nana besa manepunnedu Zacchaeus mee naneadu ka tumasumudoope nemadunagadu oonow. ");
INSERT INTO paoNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ka Te Pabe'e soopoonne pana gi oo poonne. Nagutza ewatseoo mu numu ka meetze'e oo wunu. ");
INSERT INTO paoNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Ka sunngabe-ma tuboyahoo ka Te Pabe'e tu kumi meakwuse. ");
INSERT INTO paoNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Soo Te Pabe'e ka sunngabe-toohakwi meana anguse ka Zacchaeus poonnese mee oo netamma, “Yabeupu wueke nu u-baa'yookwu yaa tabeno.” ");
INSERT INTO paoNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Zacchaeus besa soonammese wuekese ka Te Pabe'e tu nobe-kwitoo bika. ");
INSERT INTO paoNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Mu numu ka Te Pabe'e nesootzemakooha mee oo netamma, “Soo Jesus ka tuma'emukwadu-baa'yookwu.” ");
INSERT INTO paoNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Soo Zacchaeus ka Te Pabe'e mee netamma, “Nu naamookwitu ka e hee-ga-matu mu tutuha manedu numu namadeakwu. Nu ka mu numu e tutuhana watsu oo-koobakwi nu oo makodyukudooa.” ");
INSERT INTO paoNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Soo Te Pabe'e yise meeoo, “Yaa tabeno-manakwana u ka u dooamu-no namagwetzoikwu. Yaa tabeno u Te Naa tooa manekwu. ");
INSERT INTO paoNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Nu yaa teepu-koobatoo nataya tuma'emukwadu magwetzoikwuse.” ");
INSERT INTO paoNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Mu numu ka Te Pabe'e nakapunnena, “Soo Te Pabe'e mooasoo ka Jerusalem tzage'e oosoo ka o petugase soo Te Naa mu numu-kooba katuna mu moohekwudu ka Te Pabe'e mayugwekwu,” mee mu numu sokwamapunne. Soo Te Pabe'e mu sokwamana sopedakwadoo yise mee mu netamma, “O'no umu oo nakasopedakwadookwu gi meno'osoo namanikwudu nu saa'a numu moohekwudu.” ");
INSERT INTO paoNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","13","Soo Te Pabe'e meeoo mu natugwe'nga, “Soo sumu'yoo nana ka numu-kooba katudu nanumu ka mu numu-kooba pumme tu neyugwese oosoo ka umu sumumano (10) pumme tummatzidu mee netamma, ‘Nu nanasusu'muhoo oa tupe mu hemegakwu. Mu saa'a mu ma'ewadooa. Nu kwinga'a meakwu ka no'oko tamme-kooba katudu-matoo oosoo mu-kooba katudu e nemayugwekwu. Nu yise nanemamakwutooase yise saa'a yowsoo kodyu petukwu, mu ka oa tupe ma'ewase saa'a nu-matoosoo oo makodyukudooa.’ ");
INSERT INTO paoNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Soo numu-kooba katudu yise mea susumudu mu numu otuoo ka nana gi petzabena sumuoo numu taya ka no'oko numu-kooba katudu-matoo mee oo tunetammakute, ‘Gi ookow nana ka numme-kooba katukwudu nemayugwepana, numme gi oo petzape.’ ");
INSERT INTO paoNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Pana oosoo numu-kooba katudu naneyugwese yise punowsoo kodyukakwu. Ka petugase, ka umu pumme tummatzidu nabatoo bi. ‘Howgena umu e tuma'ewaku?’ mee soonammena. ");
INSERT INTO paoNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Soo mooe'ugasoo oa tupe nageadu oo-baa petuse ");
INSERT INTO paoNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","mee oo netamma, ‘U sumuoo oa tupe e gea nu oo ma'ewase meno'o yise nu sumumano (10) u makodyukukwu.’ Soo numu-kooba katudu yise mee oo netamma, ‘U tubetse besa manepu-ga'yoo. U besa e tumatugukupu ka sumuoosoo ume e gease. Meno'o yise nu besa u sootunagakwu, nu sumumano (10) nanakumma'akoosoo numu-kooba u nemadabuekwu.’ ");
INSERT INTO paoNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Soo penakwatu oo-baa petuse, punno'o meeoo, ‘U sumuoosoo oa tupe e gease, nu yise punno'o oo ma'ewase meno'o mangeoo oa tupe nu u makodyukudooa.’ ");
INSERT INTO paoNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Soo numu-kooba katudu meeoo oo netamma, ‘U punno'o besa manepu-ga'yoo u manegeoo nanakumma'akoosoo numu-kooba nemadabuekwu.’ ");
INSERT INTO paoNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Kumma'yoosoo yise oo-baa petuhoose, mee oo netamma, ‘Yaa soo oa tupe nuka u geapu nu a makodyukukwusoo. Nu wanapu-naga a watzetugu. ");
INSERT INTO paoNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Nu oo watzetugu ka u-ma suina, u nenadu'ya. U ooosapa numu-makoo tusoogwipunnedu.’ ");
INSERT INTO paoNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","23","Soo numu-kooba katudu yise meeoo oo netamma, ‘Nu ka nenaduyana ooosapa numu-makoo tusoogwipunnedu, u sakwa uga ka ume e geana tooe how tooe sootunagase uga punno'o oo ma'ewa.’ ");
INSERT INTO paoNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Soo numu-kooba katudu yise ka mu numu oo konnodu mee netamma, ‘Ka oa tupe oo-makoo gwuuse ka nana sumumanoko (10) e makodyukudooadu saa'a gea.’ ");
INSERT INTO paoNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Mu numu yise meeoo netamma, ‘Mooasoo oosoo besa manepunne ewow oa tupe-ga'yoo. Ha'oo yise u oo-koobakwisoo oo tugeakwu?’ ");
INSERT INTO paoNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Pana soo numu-kooba katudu mu nanekwegea, ‘Soo numu ka pumme tu tugeana besa matuguna, oosoo ewasoo nageakwu. Soo numu yise ka gi toge tumatuguwunudu gi besa oo tzasooana umu-makoo nahanekwu. ");
INSERT INTO paoNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Meno'o yise ka umu nuka wohonedu ka numu-kooba e katukwu-kwi gi e petzabedu yaatoo masumudoose yaa e poonnena'yoo kadoo mu mayugwe.’ ” ");
INSERT INTO paoNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Soo Te Pabe'e ka meeoo unnemakwuse ka umu pumme nakatzimodu-no Jerusalem-kwitoo mea'a. ");
INSERT INTO paoNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Bethpage noko Bethany mee nananeadu-kumi meana ka po'woadu Olive mee naneadu tzage'e petuga. O'no yise soo Te Pabe'e waahoo pumme nakatzimodu-matu taya, meeoo mu netammana, ");
INSERT INTO paoNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“Ka Bethpage-witoo memeakwate. Onoko mu sumuoo tzagaze gisoo namadusoo'yookudu mayukwu, oo tsadopase nu-matoo oo wetzakake. ");
INSERT INTO paoNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ka numu mumme tubenga, ‘How mannena mu oo tzadoopa?’ mee mu nekwegea, ‘Ne Pabe'e oo soogwa'e.’ ” ");
INSERT INTO paoNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Mu waha'yoo naana yise memease pumme tu tuukwe-kwa'nesoo oo mayu petuga. ");
INSERT INTO paoNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Ka tzagaze mu tzadoopawunu, mu numu mu tubenga, “How manena mu a tzadoopa?” ");
INSERT INTO paoNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Umu yise mu nekwegea, “Soo Ne Pabe'e a nekwa'e.” O'no mu numu yise gi hayoo mu netamma. ");
INSERT INTO paoNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Mu waha'yoo naana yise ka tzagaze ka Te Pabe'e-baatoo tzakakase, wega oo-kooba hanese, soo Te Pabe'e ka mu wega-kooba katuno'o. ");
INSERT INTO paoNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Ewa'yoo numu wega ka po-kooba wupatzeta. ");
INSERT INTO paoNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Oosoo yise ka tuupetukana ka po'woadu Olive petakwana mea mu Te Pabe'e nakatzimodu yise papaba apegeana oo nesookwuga'e ka oo manena poonnena. ");
INSERT INTO paoNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Umu papaba apegeana, “U yow, Ne Tubetse Pabe'e ne magwetzoidu.” ");
INSERT INTO paoNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Ewa'yoo mu Pharisee-matu yise meeow ka Te Pabe'e netamma, “Mu ume nakatzimodu nesagwiku.” ");
INSERT INTO paoNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Soo Te Pabe'e yise mu nekwegea, “Ka umuoo gi unakwe, kukumma'yoosoo e nesookwugikwu.” ");
INSERT INTO paoNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Ka Jerusalem mee naneadu tzage'e soo Te Pabe'e manegana ka Jerusalem poonnese mu numu tutuha soonammeguna mu yagakute ");
INSERT INTO paoNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","mee unakwe, “Tooe meno'o pana mu sakwa oo soopedakwadoo, ka mumme e soomagwetzoikwuse pana mu gi e nakaheesoobedya. ");
INSERT INTO paoNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Saa'a umu mu wokwohomu mu na'oonakwi mani petuse mu takone petukwu, mu gi hownnekoo oo namatzatsebooe-wa'ne'yoo. Umu paa'a teepu tapo'wogese ka mu tupe koodeadoo-koobakwi mu-baa tsonooahookwu. ");
INSERT INTO paoNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Umu mu numu kadoo'oo ma'ese mu nobe wunabetahookwu ka yow Jerusalem-witu. Gi sumu'yoo sapa natapo'wogedu tupe namayukwu. Sukwe puuwapudooahookwu. Soo Te Naa meno'osoo mu mabetseana mu magwetzoikwu mee tooe soonammepana mu gi ka Te Naa nakaheesoobedya.” ");
INSERT INTO paoNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","46","Soo Te Pabe'e yise ka hemma-ma tumudu-matoo meahoo. Soo Te Pabe'e ka mu numu oe'yoona hemma-ma tumudu tayapebu'ahoo oosoo ka mu manena gi toge'yookuna. Ka mu tayana soo Te Pabe'e mee mu netamma, “Soo Te Naa ka umu o'nosoo tu yadooawabe ekow po tugupu, ‘Soo e nobe pukwi'yoona no'obatusoo numu nanesootuhikwu.’ Mu ka e nobe-kwi'yoo gi besa manakwe ka mi'yoona nanatuduhana.” ");
INSERT INTO paoNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","48","Nonotsa tabeno soo Te Pabe'e mu numu tunedyooe ka nanesootuhipe-kwi'yoona. Mu Jew numu tutunehanewabe ka Te Pabe'e batsakwu mee unnena oo hoawi pana gi hownnekoo oo batsa-wa'ne'yoo ka mu numu ewa oo na'oonnakwi mamanepunne numu yise mu Jew numu tutunehanewabe tu'eapunnena o'no umu gi hownnekoo how Te Pabe'e yugwe. ");
INSERT INTO paoNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Sumu ka Te Pabe'e mu numu tunedyooedyakwe ka Pabow Nanesootuhi Nobe-kobena'yoona umu Jew numu tutunehanedu-nagatu oo-baa petuse, ");
INSERT INTO paoNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","mee oo tubenga. “Haga meeoo u netammana u ka Pabow Nanesootuhi Nobe-kwi u tooe namabedakwabawunu?” Soo Te Pabe'e yise punno'o mee mu nanekwegea, “Nu punno'o ka John-witu mu tubengakwu. ");
INSERT INTO paoNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Mu ka e nanekwegease nu punno'o ka nuga pooha-witu mu tuukwekwu. ");
INSERT INTO paoNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Haga ka John meeoo netammana oosoo numu baa-wi matzaka soo Te Naa pute oosoo puusoo oo sukwe manakwe?” ");
INSERT INTO paoNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","6","Umu yise puusoo mee nananetamma, “Tamme ka meeoo oo nanekwegease, ‘Soo Te Naa ka John mu numu baa-wi matzaka tuungu,’ meeoo oo netamma. Esoo meeoo te netammakwu, ‘How yise mu ka John gi naka'oedyukute?’ Tamme meeoo ka Jesus netammase, puusoo oo manakwe, mu ewow numu punno'o te kusedyakwu umu ka oo naka'oedyukuna soo John Te Naa yadooawabe.” ");
INSERT INTO paoNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Umu yise mee ka Te Pabe'e nanekwegea, “Numme gi oo sopedakwatoo.” ");
INSERT INTO paoNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Soo Te Pabe'e yise mee mu netamma, “Nu punno'o gi hemma mu tuukwe-wa'ne'yoo.” ");
INSERT INTO paoNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Soo Te Pabe'e Jesus yise mu numu meeoo natugwenga, “Sumu'yoo nana tumasu'ana yise mu numu ooka mabetsea tuunguse, yise mea. ");
INSERT INTO paoNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Ka oo kwasuse, soo tumasuadu ka sumuoo tu tummatziwabe umu-matu taya. Oo naamookwitu a tupooe oo hane tuunguna. Mu numu yise ka pumatoo natayadu petugase oo wupagetahoose gi a tupooe-matu oo hanekupana oo tayakwunihoo. ");
INSERT INTO paoNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Soo tumasuadu yise tuwazoo kumma'akoosoo pumme tummatzi oetusoo taya. Mu numu yise tubetse suda manena oo wupagetana punowsoo oo ta'ya gi hemma oo geapana. ");
INSERT INTO paoNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","O'no yise soo tumasuadu ka kumma'akoosoo tuwazoo taya, ookow yise manayahoose punowsoo taya. ");
INSERT INTO paoNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Soo tumasuadu yise meeoo tusooyugwe, ‘Howga yise nu manekwu? Nu ka e besaa tooa tayakwu. Umu sakwa sumuna ookow e besaa tooa naka'oedyuku.’ ");
INSERT INTO paoNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Pana mu numu ka oo poonnese meeoo nana'unakwe, ‘Yow esoo ka tumasuadu besaa dooa. Tamme a batsowse, ka oo tubewabe manekwu,’ mee unnena. ");
INSERT INTO paoNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Umu yise ka tumasuape-wikoo oo matzatsepoogese oo batsa. ");
INSERT INTO paoNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Soo tumusuadu ka oo nakahoose ka tu tooa'a nabatsahoose unu suta'a, oosoo yise mu tumahese mu goe. O'no yise oosoo tumasuape hee-ga'yoo kumma'akoosoo numu hane tuungukwu.” Mu numu ka Te Pabe'e nakapunne oo unnena nakasopedakwadoose mee unne, “Suda hayoo.” ");
INSERT INTO paoNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Soo Te Pabe'e yise mee mu netamma, “Ka o'nosoo Te Naa nayadooawabe mee'e nu-kwitu botugupu-ga'yoo, ‘Mu tupe nobe-toodu puu ka sumuoo tupe moodyise. Soo mu tumoodyina tookwa gi pumme wuni-wa'ne'yoo o ka nobe madipunnedu.’ Nu yaahoo oosoo nanetammadu tupe Te Naa nobe madipunnedu. ");
INSERT INTO paoNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Nu yow tupe-kwa'ne'yoo. O'no mu gi nuka naka'oedyukudu kadoo namayugwekoo. Ka numu nanemadabuekwu-kwi oo manepetuse umu gi e nakaheesoobedyadu kadoo namayugwekwu.” ");
INSERT INTO paoNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Mu Jew numu tutunehanedu ka Te Pabe'e umu pukwitu netammana nakasopedakwatoona oo wutumahookwu mee unnegonno pana mu ewahoo Jew numu-ma sui. ");
INSERT INTO paoNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Umu tutunehanedu-matu ka Te Pabe'e oo-matoo taya mu tutubenga tuunguna ka Te Pabe'e nehoawipunnena oo tunedyooepu-kwitu oo hooawipunne yise ka wakwawa'a numu moohedu-tamme oo tzamunahookwu. ");
INSERT INTO paoNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Umu oo-matoo natayadu yise mee oo netamma, “Numme kaaheno numu u tunedyooena sopedakwatoo. U ooosapa Te Naa kaaheno unnepu numu tuukweno'o. U gi numu tuutzeadu, mu numu u-nakwana sumu'yoosoo. ");
INSERT INTO paoNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","U ka mu wakwawa'a-tamme mu teepu-kooba natunekwiyi-kwitu ha'yoo sooyugwe'e?” ");
INSERT INTO paoNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Soo Te Pabe'e ka pumme mu nanekwegeakwu-kwitoo pumme mu hoawipunnena sopedakwadoona, mee mu netamma, ");
INSERT INTO paoNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Mu tumanagana e tzapoonneku.” Umu yise sumuoo oo tzapoonnekute. “Haga namanagana ma-ma?” mee'e mu tubenga. Umu yise meeoo oo nanekwegea, “Ka mu Tibo-kooba katudu namanagana ma-ma.” ");
INSERT INTO paoNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Soo Te Pabe'e yise mee mu netamma, “Tamme sakwa mu Tibo'o numu pabe'e geasoo umuoo nanumu tumadabuena. Tamme puu Te Naa tumadabuena Te Naa yise te hee-ga'yoo.” ");
INSERT INTO paoNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Umu tutunehanedu-matu natayadu gi ha'yoo unni-kwa'ne'yoo ka ewow numu ka pumme nakapunne. ");
INSERT INTO paoNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Mu Jew numu nananesootuhidu Sadducee mee nananeadu oo naka'oedyukute soo numu gi hownnekoosoo ka ya'eyina soo oo moogooa ka Te Naa-baatoo me'a, gi too gwetzoi-wa'ne'yoo mee oo sooyugwedu. Susumudu umu-matu ka Te Pabe'e-baa petuse nanatugwe'nga. ");
INSERT INTO paoNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Mee yise umu oo netamma, “Ka o'nosoo soo Te Naa yadooawabe Moses mee naneadu mee tunetammapu, ‘Soo nana ka ya'ese soo oo wannga'a sakwa ka oo nodukwa nodukwadoose ka tu Pabe'e dooamu-dookukwu.’ ");
INSERT INTO paoNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Umu natakwatsukwu'yoo (7) nanakwannga'amu-witu. Soo mu pabe'e nodukwadoose, gisoo dooamu-gana ya'e. ");
INSERT INTO paoNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","31","Umu oo wanga'amu nanasu'mu nanapenakwa ookowsoo nodukwadoose sapa punno'o gisoo oo-makoo dooamu-doona tuipetuga. ");
INSERT INTO paoNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Saa'a soo mogo'ne punno'o ya'e. ");
INSERT INTO paoNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","U meeoo unnena, ‘Soo numu tu ya'ekwikoo natzadyodase,’ ka ume unne-kwa'ne mane haga yise umu-matu ka mogo'ne nodukwa-gakwu, umu ka no'yoona oo nodukwa-gapana?” ");
INSERT INTO paoNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Soo Te Pabe'e yise mee mu netamma, “Mu numu meno'o ka yaa teepu-kooba mommodu ooosapa nananodukwadooyikwu. ");
INSERT INTO paoNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Soo numu ka tuise namayodase gi nananodukwamu-gakwu, umu ka umu Te Naa tutummatziwabe, mu toha kakasa-ga-kwa'ne'yookwu. ");
INSERT INTO paoNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Umuoo Te Naa besa dooamu ka oo tummatzidu mu toha kakasa-ga-kwa'ne'yoo umuoo ooosapa gwetzoibu nasootuhipu. ");
INSERT INTO paoNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Tubetse togesapa soo Te Naa numu tu tui-kwikoo mayodakwu soo Moses pana meeoo te netamma ka numu tu tui-kwikoo namayodase. O'nosoo soo Moses ka niwunudu sawabe-kobena wunupunnena soo Te Naa mee oo netamma, ‘Nu yow mu Naa. Umu u nanamooatupu mee nananeadu Abraham, Isaac yise Jacob nu-matoo togesoo nanesootuhi.’ Mu Abraham, Isaac-no Jacob tookwa togesoo gwetzoimo'o umu ka Te Naa-matoo togesoo nanesootuhimona tooe o'nosoo tuipupana. ");
INSERT INTO paoNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Soo Te Naa no'oko mu numu moogooa gi watzekute.” ");
INSERT INTO paoNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Susumudu mu nanesootuhibu numu tunedyooedu-matu o konnopunnena ka Te Pabe'e mee netamma, “U besakoo mu tuukwe'e.” ");
INSERT INTO paoNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Umu yise gi hemmasoo oo tubenga-wa'ne mane. ");
INSERT INTO paoNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Soo Te Pabe'e yise mee mu netamma, “Umu nanesootuhibu numu tunedyooedu meeoo numu tunedyooe,” soo Te Pabe'e yise ka David-ma'yoona suaketu. Hownnekoo yise soo David ka Te Pabe'e natubangakwu? ");
INSERT INTO paoNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Tooe soo David puusoo ka tu hoobeadoo-kwi mee tubotugupana, ‘Soo Te Naa ka Te Pabe'e mee netammapu, “U sakwa ooosapa e tumadinakwa katu, ");
INSERT INTO paoNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","ka umu ume wohonedu e matzooekuno'otoo tooe.” ’ ");
INSERT INTO paoNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Nu ka David kobenatusoo, soo Te Naa ka yaa teepu-koobatoo e taya. Nu ka David-ma'yoona kemmadu, ooone'yoona soo David, ‘E Pabe'e,’ natubanga,” mee'e soo Te Pabe'e. ");
INSERT INTO paoNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Soo Te Pabe'e ka umu pumme nakatizmodu mee mu netammadyakwe ewa'yoo mu numu oo nakapunne, ");
INSERT INTO paoNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Mu sakwa gi mu Jew numu nanesootuhibu numu tunedyooedu-kwa'ne manepana. Umu puu besa-kwi tu namasooa-ma nasootza'mepunne numu pumme besa neyugwena petukudu. Umuoo ka tu na'ewa tuka numu-koobatu naneyugwena soobedyadu punno'o, o'no mu numu besa mu sooyugwekwu mee'e nasooyugwedu. ");
INSERT INTO paoNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Nanesootuha'e mee naneyugwe pana ka mu pepeawabe nobe umu-makoo tuduha tuwazoo. Umuoo tuma'emukwana umu-matoosoo kodyukwu ka suda mu tumatugu-kwi.” ");
INSERT INTO paoNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Soo Te Pabe'e ka umu ewow unu nanenagadu hee-gakoo numu tubebuamena mu poonnepunne. ");
INSERT INTO paoNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Sumu'yoo tutuha manedu peawabe tu penebetu oe tuoonahoo. ");
INSERT INTO paoNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Soo Te Pabe'e yise ka pumme nakatzimodu meeoo netamma, “Yow esoo besow mogo'ne. Esoo tu penebetu oe tuoo'na. ");
INSERT INTO paoNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Yise mu naana gi ewa oe tuoonana, ka a namasumutoo-kwi tooe ewa hee-gapana. Esoo mogo'ne tu penebetu oe tuoo'na. Gi haa'nokoo oe tuoo'na,” mee soo Te Pabe'e. ");
INSERT INTO paoNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Susumudu mu Te Pabe'e nakatzimodu yise ka nanesootuhi nobe-kwitu, ka mu nanenagadu besow tupe namadabuena oo poonnena oo nesookwuga'e. Soo Te Pabe'e yise meeoo mu netamma, ");
INSERT INTO paoNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Esoo yow meno'o mu poonnena esoo besa tabuadu yaanona nobe te wokwohomu saa'a no'oko a wudyoomedakwunidooa.” ");
INSERT INTO paoNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Mu Te Pabe'e nakatzimodu yise meeoo oo tubenga, “Hannano yise oo mani petukwu how saa'a numme oo sopedakwadoo tabuakwu?” ");
INSERT INTO paoNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Soo Te Pabe'e yise meeoo mu nanekwegea, “Gi kumma'akoosoo numu mumme nemooaga oo naka'oedyukupana. Ewa'yoosoo numu mee mu netammakwu, ‘Nu yow mu Pabe'e,’ mee mu nemooagana gi umu-ma naka'emukwapana. ");
INSERT INTO paoNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Mu tuwazoo ka tu nana'akwe-kwitu nakakwu, tooetoo nana'akwekwu pana gi oo-ma nakasuipana. Tooe yoo sumuna mooe namanekekwu sapa pana gisoo soo yaatu teepu atasoo e yugwekwuna oe manakwe. ");
INSERT INTO paoNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Tooe hanotu tooe saa'a soo te teepu suyugadooa. Ewa-baatu numu kukumma'yoosoo nanagoena, ");
INSERT INTO paoNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","tukapu natugena natseagoena soo teepu yise yutsungayikwu. Tooe hemma tooe mu koomeba-nagakoo poonnekwu.” ");
INSERT INTO paoNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Soo Te Pabe'e yise meeoo tuwazoo mu netamma, “Gisoo hemma 'yoo manakwe umu gi nananesootuhidu gi mu petzabena mu-ma tzakaduse mu wupagetana mu wutumetakwu. O'no yise mu numu-kooba katudu-kobena'yoona mu nanehanekwu nu-koobatoo. ");
INSERT INTO paoNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","O'no sakwa yise mu nukwitu mu tuukwe. ");
INSERT INTO paoNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Ka pumme mu nehanekwuse nakwutumase saa'a mu unnekwu-kwitu gi soohanepana. ");
INSERT INTO paoNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Nu saa'a ka mu nanehane nuusoo mu unnekwuna mu nemadabuekudooa, o'no saa'a soo mumme tumoo'oodu gi hanotu ha'yoo unnetooa. ");
INSERT INTO paoNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","19","Ewa'yoo mu numu gi e petzabedooa u nananumudooe suda u matugudooa yise mu goedooa saa'a. Tooe umu gi e soo'oedyukudu gi mumme numu petzabekwuse sapa, mu e naka'oedyukudu gi e ma'wukadu, nu mu magwetzoikwu. ");
INSERT INTO paoNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Mu ka te wokwohomu ka Jerusalem-na'oonnakwi manise mu poonnena mu oo sopedakwadookwu, pudusoo mu wokwohomu ka Jerusalem kadoo'oo ma'ekwuse. ");
INSERT INTO paoNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Mu numu Jerusalem-witu sakwa ka giba-matoo namamea'a umu oo tzage-kwitu sakwa punno'o mu-nosoo, gi sakwa haga Jerusalem-witoo namameapana. ");
INSERT INTO paoNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Soo Te Naa ka o'nosoo ka mumme too'e nemanana'wipu mu-matu gi oo nakahoyase meno'o yise mu-koobadooe. ");
INSERT INTO paoNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Mu momoko'ne kokoheadu yise mu nunupetzekudu tutuha namanatzayakwe ka numu tuyagoese. ");
INSERT INTO paoNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Susumudu numu nagoehookwu, susumudu punno'o ona tooe hano tooe kwinga'atoo nawetzakakwunihookwu. Tubetse wuna'metoo mu wakwawa'a ka Jerusalem-wi nonobe-gakwu. Saa'a ka Te Naa tunetammana namamakwuse, soo Te Naa ka mu Jew numu punowsoo Jerusalem-witoo nemakodyukukwu. ");
INSERT INTO paoNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Togesapa soo Te Naa ka yaatu tamme-koobatu atasoo yugwekwu. Ka tubetse baa unu bayutsungadyakwe mu numu oo-ma nakasui. ");
INSERT INTO paoNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Mu numu tubetse suikwu ka gi oo sopedakwadoona ka hemma yoo manakwe. ");
INSERT INTO paoNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","28","Mu e naka'oedyukudu saa'a gi nasootookepana ka yoo hemma manekwu, nu mu magwetzoikwu. Ka yaa teepu-koobatoo mu numu e poonnekwu ka e pooha patakwetseana tubongo ka koommeba naga-kwi e wuegena.” ");
INSERT INTO paoNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","30","Soo Te Pabe'e yise ka umu pumme nakatzimodu mee netamma, “Ka sunngabe pooedooagese mu puu oo sopedakwadoo ka pudusoo tatza manepetukwu. ");
INSERT INTO paoNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Ooonekoosoo mu ka yoo hemma suda manegena poonnekwu, mu oo soo'oedyukukwu pudusoo kodyu petukwuna. ");
INSERT INTO paoNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Mu numu meno'o yaa teepu-koobatu gisoo tuina ka Jerusalem kadoo nuugwekwuna poonnekwu. ");
INSERT INTO paoNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Esoo nuga unnepu besa na'unnedu gi hee atasoo a yugwe-wa'ne'yoo. ");
INSERT INTO paoNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","35","Mu gi tunaka'oedyukudu yaa teepu-koobatu gi ka e kodyu petukwuna sooma'yu. Ka tu manegonnona suu'mu sooma'yuna suda oo sokwamakute ka tooe how tooe manena. Nu gi nuka mu soogwino'o umu-baa petukwu. Mu sakwa nuka naka'oedyukudu gi hemma tu hee-gakwitu soohanekupana, gi suda oo sokwamakupana. Mu mooasoo namamakwupunne. ");
INSERT INTO paoNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Tamme sakwa yise Te Naa-matoo nanesootuhi oosoo ka suda ka mu gi naka'oedyukudu-tamme kemmadu-makoo te magwetzoikwu. O'no yise e petuse mu e dooamu nasootuhikwu.” ");
INSERT INTO paoNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Soo Te Pabe'e ka tuutsekoo po'woadu Olive mee naneadu-ma tooa'e. Nonotsa tabeno ka nanesootuhi nobe-kumabatoo meayina ka mu numu Te Naa besa unnepu tunedyooebodotu. ");
INSERT INTO paoNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Nonotsa awamooa mu numu awamooasoo sumuhooyakwe ka oo nakabodona. ");
INSERT INTO paoNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Mooa dyongona oetu, o'nosoo te manena te natzamawukwuna soomayuna, yise ewa tuka, Gi Namayuadu Tukaba tukakwu. ");
INSERT INTO paoNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Mu Jew numu tutunehanedu ka Te Pabe'e watze batsakwu mee'e sokwama pana ka mu numu-ma suipunne. ");
INSERT INTO paoNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Ka sumuoo Te Pabe'e nakatzimodu-matu, Judas mee naneadu soo suta'yoo ookow ma'emukwa. ");
INSERT INTO paoNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Soo suta'yoo ka mu tutunehanedu-matoo ka Judas taya mu tuukwe tuunguna oosoo mu tzapoonnekukwu ka Te Pabe'e pukwi'yoona, o'no mu oo watze tzakadukwu. ");
INSERT INTO paoNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Mu Jew numu tutunehanedu besa sokwamana, “Numme u tumanagakukwu,” mee'e ka Judas netamma. ");
INSERT INTO paoNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Soo Judas, “Nu ka Te Pabe'e-matoo mu bikakwu, gi numu poonnena,” mee tusooyugwe. ");
INSERT INTO paoNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Yaa tabenoo numme ka seepu tooa'a batsakwu, ka gi namayuadu tukaba noko ne ewa tuka-kwi manepetu. ");
INSERT INTO paoNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Soo Te Pabe'e yise ka Peter noko John meeoo netamma, “Mu sakwa mooe memeakwatese ka te nanesootuhi yongo tukakwuna mabetsabega.” ");
INSERT INTO paoNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Umu yise meeoo tubenga, “Hano'yoo yise numme tugoomahanegakwu?” ");
INSERT INTO paoNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Soo Te Pabe'e yise mee mu nanekwegea, “Ka Jerusalem-wi mu pepetugase mu sumuoo nana bano'osa tu tsoabu-kooba tokwuhudu wegeakwu. Mu saa'a ookow nagekadooa. Ka nobe-kwi oo egeakase oo-nosoo saa'a tzoonooahoo kwatese ");
INSERT INTO paoNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","ka nana oo nobe-gakoo mee saa'a netamma, ‘Soo Te Pabe'e umu pumme nakatzimodu-no yaa u-baa'yoona nanesootuhi yongo tukakwu.’ ");
INSERT INTO paoNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Esoo nana nobe-ga'yoo yise mu tzapoonnekukwu ka pa'atu nobe-kwi'yoona ka tukapu mu yongo tukakwuna mu saadooa.” ");
INSERT INTO paoNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Umu yise mooe memeow tu tukakwuna mahaneookwuse. ");
INSERT INTO paoNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Ka tu yongose, soo Te Pabe'e ka umu nakatzimodu-no tukana ");
INSERT INTO paoNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","mee mu netamma, “Nu tubetse unu mu-no e nanesootuhi yongo tukakwuna petzape gisoo nabatzana. ");
INSERT INTO paoNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Esoo te nanesootuhi yongo tukana ka numu-koobatu e nabatsakwuna oo wahadu ka seepu dooa nabatsa-kwa'ne. Yow nakwitu umu nanesootuhi tukakwuna e nabatsana-kobena.” ");
INSERT INTO paoNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Soo Te Pabe'e yise ka tseda gwuu'hoose atsa baa oekoo oo-koobatoo nanesootuhihoose umu pumme nakatzimodu mee netamma, “No'yoona sakwa mu ma-matu hebe. ");
INSERT INTO paoNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Nu mu tuukwe'e nu ekow atsa baa ka yaa teepu-koobatu tubetse gi hebekwusoo, saa'a Te Naa ka te teepu mapudutupudoose o'no yise nu tubetse pudutupusoo hebekwu.” ");
INSERT INTO paoNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Soo Te Pabe'e ka tukaba gwuu'hoose ka Te Naa-matoo nanesootuhihoose oo tzabokase yise mee mu netamma, “Yoonnekoo soo e tookoo mu-koobatoo natzabokakwu eka tukaba-wa'ne. E soomayu saa'a ka a tukana.” ");
INSERT INTO paoNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ka mu tukamakwuse ooosoo ka tseda-witu yukwe soo Te Pabe'e meeoo unnena, “Nu sakwa mu-koobatoo nabatsa. Soo atsa baa e puupe-wa'ne'yoosoo. ");
INSERT INTO paoNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Soo sumu'yoo numu ka umu nuka batsakwadu-tamme e tzamunahookwudu tamme-baa tuka. ");
INSERT INTO paoNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Mooasoo soo Te Naa meeoo tunetamma, nu ooonnekoo nabatsakwu. Pana saa'a oosoo umu wohomu nu-matoo bikepu tuma'emukwana oo-matoosoo kodyukwu.” ");
INSERT INTO paoNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Umu oo nakatzimodu yise mee nanatubenga, “Hanotugina tamme-matu yoo manekwu?” ");
INSERT INTO paoNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Umu Te Pabe'e nakatzimodu puusoo nanano nananepetukute. “Ka puusoo nana su'summe ka Te Pabe'e nakwasoo manepunnekwu,” mee'e nanatusooyugwena. ");
INSERT INTO paoNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","27","Soo Te Pabe'e ka mu nakana yise mee mu netamma, “Gi mu wakwawa'a numu-kooba katudu-kwa'ne, paba nasooyugwepana. Soo sumu'yoo mu-nagatu mooe natatsungadu sakwa mu tummatzi. Gi paba nananeyugwepana mu numu tummatzi, tooe nu mu Pabe'e pana nu ooosapa mu-kwitu poohigena. Mu sakwa e manena tuusoodyahana nu-kwa'nesoo. Soo sumu'yoo mu-nagatu mu mooe tatsungadu sakwa mu tummatzi. Mu ka numu tummatzidu gi heesoobedya. Pana nu mu Pabe'e, yise mu tummatza'e, mu sakwa nanatummatzi punno'o. ");
INSERT INTO paoNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","30","Mu nu-no tukakwu ka saa'a Te Naa-baa mu petukase. Mu yise nu-nosoo ka mu Jew numu nemadabuekwu mu ka ooosapa e naka'oedyukuna tooe mu numu nuka wohone sapa. ");
INSERT INTO paoNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","E besa pua'a Simon Peter, soo suta'yoo mu tapokakwu te manena gi petzabena. ");
INSERT INTO paoNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Pana nu u nanesootuhikute u sakwa gi e naka'oedyukumakwupana. Ka u unnekwuna saa'a nemakodyuse u sakwa umu ta pupua'amu besa mu nanesootuhi meakwuna mu nemayugwekwu.” ");
INSERT INTO paoNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Soo Simon Peter yise mee ka Te Pabe'e netamma, “Nu ooosapa u-no'yookwu tooe taka mu wutuma tooetoo taka mu goekwuse sapa.” ");
INSERT INTO paoNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Soo Te Pabe'e yise ka Simon Peter meeoo netamma, “Awamooasoo gisoo ka tsekuna kwu'a yaka, u saa'a pahe mu numu mee netammapunnedooa, ‘Nu maka Jesus gi sopedakwatoo.’ ” ");
INSERT INTO paoNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Soo Te Pabe'e yise ka umu pumme nakatzimodu meeoo tubenga, “Nu ka o'nosoo ka besa e unnepu mu numu mu tuukwe tuunguna ka mu tayase tooe gi mu hee-gakoo sapa, gi tuwow mu mago'o-gana, gi tuwazoo kumma'akoosoo mu moko-ga'yoo sapa. Mu puu uga hemma tuuke haa'a?” Umu mee oo nanekwegea, “Numme u unne-kwa'nesoo gi hemma tuuke.” ");
INSERT INTO paoNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Soo Te Pabe'e yise meeoo mu netamma, “Ka yaa manakwana ka mease ka mu hemma mago'o noko hanega ka ooone-gana. Mu ka gi segesa-gana ka mu wegabedo tutsanabedu. ");
INSERT INTO paoNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Soo nu-kwitu nanemamakwudu nabotugudu oo-toogoo manipetukwu. Mee oosoo na'unakwe, ‘Nu ka mu nanasuda tumatugudu-kwa'nesoo namatugukwu.’ ” ");
INSERT INTO paoNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Umu oo nakatzimodu mee oo netamma, “Mooasoo numme waahoo segesa-ga'yoo.” “Gi nu mownnekoo segesa netamma,” mee'e soo Te Pabe'e mu netamma. ");
INSERT INTO paoNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Soo Te Pabe'e yise ka umu pumme nakatzimodu-no ka nobe-kwi'yoona mea'ase ka po'woadu Olive mee naneadu-matoo petuga, oosoo ka uga ooosapa maneyina. ");
INSERT INTO paoNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Soo Te Pabe'e yise mee mu netamma, “Mu sakwa nanesootuhi. O'no mu ka sutakoo mumme nemooaka mu gi oo-ma nakatzabedooa.” ");
INSERT INTO paoNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Soo Te Pabe'e yise gi haa'no umu kwinga'atoo mease meatzedose mee nanesootuha'e, ");
INSERT INTO paoNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“E Naa, soo tubetse suda nuka tu yugwekwuna nu-tamme kemmana nu gi oo nasoomanekena. Ka ume nuka tunetammapu nu oo mayohokwu.” ");
INSERT INTO paoNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","O'no yise sumu'yoo soo Te Naa tummatziwabe soo toha kasa-ga'yoo oo-baa tabua petuse ka Te Pabe'e besakoosoo sootuhidooa. ");
INSERT INTO paoNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Togesoo ka pumme tu yugwekwuna oo soonammetugupunne soo oo nanekoonana ka teepu-koobatoo puupe pasawedu-kwa'ne manewunu. ");
INSERT INTO paoNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Soo Te Pabe'e ka nanesootuhimakwuse yotsese ka umu pumme nakatzimodu-baa petuhooga ka suda sokwamana mu utua'e mu mayu petuse, ");
INSERT INTO paoNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","mee mu netamma, “Mu sakwa gi utu'ipana. Yosuhoose nanesootuhigonno, o'no mu ka Sutakoo mumme nemooaga mu gi oo-ma nakatzabe-wa'ne'yoo.” ");
INSERT INTO paoNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Ka Te Pabe'e togesoo yadooawunu soo nana Judas mee naneadu mu tukwutumadu-no ewow numu oo-baa moohe petu. Oosoo ka Te Pabe'e-baa petuse oo mitzadya'me. O'no umu oo sopedakwatoohoo. ");
INSERT INTO paoNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Pana soo Te Pabe'e yise meeoo o netamma, “Judas how u suda e matugukwuse sapa e mitzadya'me?” ");
INSERT INTO paoNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Mu Te Pabe'e-no tunakatzimodu ka tukwutumadu poonnese meeoo ka Te Pabe'e tubenga, “Tamme haa'a umu-no nagoekwu?” ");
INSERT INTO paoNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Sumu'yoo mu Te Pabe'e nakatzimodu yise sumuoo mu Jew pabe'e tummatziwabe naka tseka'akwunihoo. ");
INSERT INTO paoNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Soo Te Pabe'e yise meeoo oo netamma, “Mow sapa.” Ka meeoo oo netammase ka nana naka pukwikoo oo nakwuga'ahoo-kooba matuguse soo oo naka besa mani. ");
INSERT INTO paoNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Soo Te Pabe'e yise ka mu Jew pabe'e tukwutumadu meeoo netamma, “Nu gi suda tumatugudu, gi naduyadu, gi tuduhadu tuwazoo. Gi sakwa mu koodoo'oo-ma e tumahepana, wobe-ma, tsegesa-ma tuwazoo. ");
INSERT INTO paoNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Tooe mu ka e nanesootuhi nobe-kwikoo sapa gi nu-ma tzakadupu-ga'yoo. Muusoo too'e. Mooasoo soo tubope ebeoo nabotuku o'nosoo Te Naa tamme tuukwe-kwa'nesoo. ");
INSERT INTO paoNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Mu tukwutumadu yise ka Te Pabe'e-ma tzakaduse oo bika ka mu Jew-numu tutunehanedu naa-matoo. Soo Peter kwinga'a mu-nakwi meadabe. ");
INSERT INTO paoNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Ka mu numu yise ka tunehane nobe-kobenakoo pedahoose soo Peter yise ka mu numu-naga katu. ");
INSERT INTO paoNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Sumu'yoo tseadumu yise ka Peter poonnese ka oo tsetsoogase yise meeoo unakwe, “Esoo nana ka Jesus-matu.” ");
INSERT INTO paoNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Pana soo Peter yise meeoo unakwe, “Nu gi ma-notu.” ");
INSERT INTO paoNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Ka mu numu togesoo aata'a, kumma'yoosoo numu ka Peter poonnese punno'o meeoosoo, “U punno'o umu-notu.” Pana soo Peter yise meeoo ka nana netamma, “Nu gi.” ");
INSERT INTO paoNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Togesoo mu tuutooe kumma'yoosoo numu punno'o ka Peter meeoo netamma. “U tubetse yow ka Jesus nakatzimodu-matu. U Galilee-witu.” ");
INSERT INTO paoNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Soo Peter meeoo mu netamma, “Nu gi mu numu nemooaga, nu gi umu-notu.” Togesoo ka Peter ookow nemayuyakwe soo tsekana kwu'a yagakooha. ");
INSERT INTO paoNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Soo Te Pabe'e yise ka Peter poonnega'a. Soo Peter yise oo soomayuhoo ka Te Pabe'e pumme netammapu. “Gisoo ka tsekana yaka pahe tooe u gi e nanenama'yoodooa.” ");
INSERT INTO paoNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Soo Peter pumme unnepu soomayuse yagakooha. ");
INSERT INTO paoNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Mu tutukwutumadu ka Te Pabe'e nasootzamekuna oo pooe wutumase yise oo wupageta. ");
INSERT INTO paoNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Yise meeoo oo tubenga, “U too'e no'okosoo gi hemma watzekudu, haga meno'o u wupageta?” ");
INSERT INTO paoNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Mu ewa'yoo tutukwutumadu ha'yoo tooe oo netammana oo-ma'yoona naneko'e. ");
INSERT INTO paoNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Ka tu tabuakese mu tutukwutumadu ka Te Pabe'e mu tunehanedu-koobenatoo hane petuga yise mu tutunehanedu meeoo oo tubenga. ");
INSERT INTO paoNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","68","“U haa'a yow soo nanetammadu Ne Pabe'e?” Soo Te Pabe'e mu nanekwegea, “Tooe mu mumme e tuukwe sapa gi mu e oedyuku-wa'ne'yoo. ");
INSERT INTO paoNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Saa'a mu e poonnekwu Te Naa toogoopatu-kumaba e katu numme mu tunemadabuekukwu.” ");
INSERT INTO paoNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Mu tutunehanedu yise meeoo oo tubenga, “U haa'a Te Naa Tooa?” Te Pabe'e yise meeoo, “Aha, nu yow soo Te Naa Tooa'a.” ");
INSERT INTO paoNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","“Oosoo ka meeoo naneyugwena puusoo gi toge-tamme kemmowgena,” mee mu tutunehanedu nana'unakwe. ");
INSERT INTO paoNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Mu numu tutunehanedu ka Te Pabe'e tzakunana ka tibo'o numu nehanedu Pilate mee naneadu-kobena oo bi petuga. ");
INSERT INTO paoNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Umu ka Te Pabe'e nemooyugwena ka Pilate mee netamma, “Numme eka nana mayu esoo ewa ka mu numu suda neyugwe. Gi ka mu Roman numu-kooba katudu ka mu tumasumudooyina hemepana, mee mu netamma, ‘Nu yow Mu Pabe'e ka mu Jew numu-kooba katukwudu,’ mee unakwe.” ");
INSERT INTO paoNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Soo Pilate yise ka Te Pabe'e tubenga, “U haa'a mu Jew numu-kooba katukwudu?” Soo Te Pabe'e meeoo, “Aha, o umesoo unnena.” ");
INSERT INTO paoNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Soo Pilate yise ka mu Jew numu tutunehanedu no'oko meeoo netamma, “Nu ka ma-no yadooase, yise esoo ka oo manepunne e tuukwe mu unnena tubetse oo ata'yoosoo. Esoo nana gi suda manakwe.” ");
INSERT INTO paoNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Pana mu tutunehanedu ooosapa mee unnegonno, “Esoo ka mu numu suda neyugwewunu, mana ka teepu Galilee mee naneadu-toogoo suda tuneyugwedu.” ");
INSERT INTO paoNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Soo Pilate ka meeoo mu unnegonno mu nakase mee mu tubenga, “Oosoo haa'a Galilee-wi'yoona kemmapu?” ");
INSERT INTO paoNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Umu mee oo nanekwegea, “Aha.” Soo Galilee numu-kooba katudu Herod mee naneadu punno'o Jerusalem-wi. Soo Pilate yise ka Te Pabe'e ka Herod-matoo nemawuni. Soo Te Pabe'e yise ka Herod pukwi'yoo-kwitoo tzakaka. ");
INSERT INTO paoNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Soo Herod besa soonamme ka Te Pabe'e puu-baa natzaka petugase. “Soo Jesus sumuna umu besa tu tumadipu-matu e tzapoonnekukwu. Wuna'me nu oetu nakakena besa oo poonne soonamme,” mee soo Herod soonammekatu. ");
INSERT INTO paoNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Ewa ka Te Pabe'e tubenga pana soo Te Pabe'e gi oo nanekwegea. ");
INSERT INTO paoNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Mu Jew numu tutunehanedu osoo konnopunnena no'obasoo nanasuda oo netammagonno. ");
INSERT INTO paoNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Soo Herod yise ka umu tutukwutumadu-no ka Te Pabe'e suda matuguna oo-ma'yoona nanekoena oo nasootzamekugonno. Umu unu nanenagadu-kwi oo kwaseakute mu Jew numu-kooba katudu mee oo netammana yise ka Pilate-matoosoo oo taya. ");
INSERT INTO paoNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Wuna'me mu ka Pilate-no Herod gi natoke'yookute pana ka yoo hemma manepetuse umu napua'ahoo. ");
INSERT INTO paoNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Ka Te Pabe'e-baa punowse petugase soo Pilate ka mu Jew numu tutunehanedu nesumuhoo. ");
INSERT INTO paoNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Yise mee mu netamma, “Mu ekow nana nu-baa bi petu. Esoo nana ka mu numu suda neyugwe gi ka numme-kooba katudu nakabetsea mu mee'e e tuukwena. Nu oetu soohanese masoo gi ka mu unnekwasoo manakwe. ");
INSERT INTO paoNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Nu tuwazoo ka Herod-matoo a too'e taya. Soo Herod punno'o gi how a yugwe ka gi how a manakwe. ");
INSERT INTO paoNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Masoo sakwa sukwe nuupageta yise natzama'wu mee nu mesoo unakwe.” ");
INSERT INTO paoNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","18","No'yoona mu numu ewa unnegonno, “Ka Barabbas ne tzama'wukuse ka Jesus batsa.” ");
INSERT INTO paoNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Soo Barabbas nakwutuma oosoo ka mu wakwawa'a tamme-kooba aatadu wohonekese numu goese ooetoo nakwutumadu. Soo mu wakwawa'a tumatuguna ka tabeba oe maneyakwe sumuoo nakwutumadu natzama'wuyakwe mu numu oo netutzeayina. ");
INSERT INTO paoNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Soo Pilate ka Te Pabe'e too'e netzama'wusoo pana ");
INSERT INTO paoNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","mu numu ewa unnegonno, “Oo tzakwenne, oo batsa.” ");
INSERT INTO paoNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Soo Pilate mee mu numu tubenga, “How manena mu ooka e batsa tuungu? Oosoo gi suda tumatugu. Nu oo wupagetase oo tzama'wukwu.” ");
INSERT INTO paoNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Pana mu numu papabatsesoo mee nana'unnegonno, “Oo batsa.” Soo Pilate yise mu nakabetsea. ");
INSERT INTO paoNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Soo Pilate yise ka mu tutukwutumadu ka Te Pabe'e batsa tuungu ka mu numu meeoo unakwe. ");
INSERT INTO paoNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Soo Pilate yise ka Barabbas tzama'wu tooe mu wakwawa'a numu-kooba aatadu oo wohonekese numu oo goese sapa. ");
INSERT INTO paoNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Sumu'yoo nana Simon mee naneadu ka Cyrene mee naneadu-wi'yoona kemmadu ka Jerusalem-witoo kemmadape. Mu tutukwutumadu Te Pabe'e tzemahudu oo wegeagena. Oo-ma tzakaduse ka Te Pabe'e puma nataposakwuna oo tokwu tuungu ka Te Pabe'e-nakwisoo. ");
INSERT INTO paoNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Ewa'yoo momoko'ne mu-nakwisoo punno'o meadape sakwina. ");
INSERT INTO paoNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Soo Te Pabe'e umu-tamme nakwumunase ka mu momoko'ne mee netamma, “Mu sakwa gi nu-koobatoo sagwipana. Mu sakwa muusoo yise ka mu doodooamu-koobatoo sakwi. ");
INSERT INTO paoNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Pudusoo Jerusalem-witu suda namanekwu mu doodooamu-makoo suda namanatzayakwe mu yise mee unakwe, ‘Mu numu gi doodooamu-ga'yoo tookwa besa namanatzi.’ ");
INSERT INTO paoNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Umu yise ka giba-matoo nanesootuhikoo mee unnena, ‘U sakwa numme-koobatoo aanooakase mee wumabema.’ ” Pana soo giba gi oo manakwe. ");
INSERT INTO paoNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Togesoo e gwetzoi sapa umu suda e yugwe tooe gi suda e manakwe sapa. Umu ka saa'a e batsase umu mumme numu Jerusalem-witu unu suda yugwekwu mu ka suda tumatuguse.” ");
INSERT INTO paoNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Mu waha'yoo tuduhadu punno'o ka Te Pabe'e-no natzakase nataposa. ");
INSERT INTO paoNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Mu tutukwutumadu yise ka Numu Tzonoho mee naneadu-kwi petugase ka sunngabe nuummadabue-ma oo taposa wahoo tutuduhadu naana naamookwi. ");
INSERT INTO paoNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Soo Te Pabe'e mee nanesootuhikooha, “E Naa u sakwa mu numu yaa manepunnedu ma'emukwana soomu'wa, umu gi oo nakasopedakwadoona yoo e yugwe.” Mu tutukwutumadu yise ka oo kwasu natotsakwate. ");
INSERT INTO paoNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Mu numu oona konnona Te Pabe'e tupoonnepunne mu Jew numu tutunehanedu oo-ma'yoona naneko'e. Mu Jew numu tutunehanedu ka Te Pabe'e mee netamma, “U puu kukumma'akoosoo magwetzoi mee unnepana meno'o sakwa yise u uusoo namagwetzoi u ka Te Pabe'e mee nane'yugwena.” ");
INSERT INTO paoNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Mu tutukwutumadu punno'o ka Te Pabe'e-ma'yoona naneko'ena. Umu yise ka suda kammadu baa suda manena ka Te Pabe'e too'e mapoonneku pana oosoo ");
INSERT INTO paoNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","yise gi oo hepe. Umu mee oo netamma, “U sakwa uusoo namagwetzoi, u ka pooha-gana mu Jew numu-kooba katudu mee naneyugwena.” ");
INSERT INTO paoNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ka Te Pabe'e tzopa ka sunngabe-ma soo wobe nataposa mee oo-ma natubo'o, “Yow soo Jew numu-kooba katudu.” ");
INSERT INTO paoNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Sumu'yoo mu tutuduhadu-matu ka Te Pabe'e-kumaba nataposadu mee oo netamma, “U ne Pabe'e mee naneyugwepana gi hownnekoo te magwetzoa'e.” ");
INSERT INTO paoNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Soo sumu'yoo tutuhadu punno'o ka Te Pabe'e-ma'yoona sooiwunudu mee netamma, “Gi meeoo unnepana. U sakwa ka Te Naa-wi tunaka'oedyuku ta punno'o nagoekwu. ");
INSERT INTO paoNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Ta ka tuma'emukwase sakwa oe tumanaga pana esoo nana puu gi tuma'emukwa.” ");
INSERT INTO paoNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Oosoosoo tuduhadu yise ka Te Pabe'e mee netamma, “Ka u pooha-toohakwi kodyu petuse, saa'a e sootuhi.” ");
INSERT INTO paoNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Soo Te Pabe'e mee oo netamma, “U sakwa oo nakasopedakwatoo yaa tabeno soo Te Naa ta sootuhikwu ka pu-baa ta pepetugase.” ");
INSERT INTO paoNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Tabeno manakwana oona ka taba pahe-kwitoo oo katu-kwikoo tooe, no'oko teepu-koobakwitu toganopunne. ");
INSERT INTO paoNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Soo taba koomeba-ma natzadoboyahoo. Soo wunapu ka Te Naa pooha pukwi'yoona mu pooha maneyina naamootoo natzakwenedu pa'anakwana tubongo oo naamootoo natzagebu'ehoo. ");
INSERT INTO paoNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Soo Te Pabe'e ka Te Naa mee nanetzakwiya'e, “E Naa meno'o u-matoo e moogooa meahookwu.” Yise soo Te Pabe'e ya'ehoo. ");
INSERT INTO paoNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Soo tueya'edu pabe'e ka a namanina poonnese mee unakwe, “Esoo nana tookwa togesapa besa'yoo.” ");
INSERT INTO paoNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ewa'yoo numu ka Te Pabe'e ya'ehoose oo poonne suda sokwamana ka suda oo matuguse yise nobe-kwitoo kodyu mee nana'unnena, “Tamme suda manakwe, tamme tuma'emukwa.” ");
INSERT INTO paoNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Umu Te Pabe'e soobedyadu umu momoko'ne Galilee-wi'yoona ka Te Pabe'e-no kemmapu oona kwinga'yoona oo poonne ka suda oo nuugwe. ");
INSERT INTO paoNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Sumu'yoo nana Joseph mee nane'a ka mu Jew numu tutunehanedu-matu, besa'yoo nana, kaaheno tumatugudu. ");
INSERT INTO paoNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Soo Joseph gi ka Jew numu tunehanedu nakabetzape ka Te Pabe'e mu nebatsa. Soo Joseph ka Te Naa tu nakabetseana sookwina. ");
INSERT INTO paoNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Soo Joseph ka Pilate-baa petugase ka Te Pabe'e tookoo oo natuungu. ");
INSERT INTO paoNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Soo Joseph ka oo tookoo hanehoose wunapu-wi oo mabutooe. Gisoo ka taba egea, ka tupe-naga natudotawaga gisoo numu pukwi nanomatuguna, ooweoo soo Joseph ka Te Pabe'e tookoo nanomatugu. ");
INSERT INTO paoNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Esoo ka nanesootuhi tabeno-kobenasoo namanena. ");
INSERT INTO paoNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Umu momoko'ne ka Te Pabe'e-no Galilee-wi'yoona kemma'adu ka Joseph nagegase ka Te Pabe'e nanomatuguna poonne. ");
INSERT INTO paoNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Umu nobe-kwitoo kodyukase nakwana'a matabue oo tookoo-kooba nahanekwudu. Umu ka Jew tumayohope mayohona gi kodyu ka nanesootuhi tabeno oo manese. ");
INSERT INTO paoNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Ookow mooo'a awamooasoo tu pudutabuagena mu momoko'ne Te Pabe'e tookoo pukwi nanomatugupu-wi petugonnohoo ka nakwana'a tu tumadabuepu hanena. ");
INSERT INTO paoNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Soo tseketadyadu tupe oo-kobena nahanepu puma oo namatumana namagonnonooekwunipu-ga'yoo. ");
INSERT INTO paoNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Umu oe tzoonooahookase sapa gi ka Te Pabe'e tookoo oekoo ma'yu. ");
INSERT INTO paoNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","“Hano soo Te Pabe'e tookoo?” mee umu nananetammadyakwe. Waha'yoo toha kakasa-ga'yoo umu-baa tapua petu besa patakwetseadu-kwi nanamasooana. ");
INSERT INTO paoNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Mu momoko'ne umu-ma nasoosuahoo. ");
INSERT INTO paoNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Mu toha kakasa-ga'yoo mee mu momoko'ne netamma, “Mu sakwa gi suipana. Gi ka togesoo nummenummedu numu ka numu tuipu-nagatu watepana. Te Pabe'e gwetzoi. ");
INSERT INTO paoNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Mu sakwa oo soomayu ka gisoo nabatsana oosoo mu tuukwe, ‘Pudusoo mu suta'yoo numu e batsakwu yise waha tabe mease nu namayodakwusoo.’ ” ");
INSERT INTO paoNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Mu momoko'ne yise ka Te Pabe'e unnepu sooma'yu, ");
INSERT INTO paoNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","10","ka oo nanomatugupu-wi'yoona mea'ase ka Te Pabe'e nakatzimodu no'oko tuukwe. ");
INSERT INTO paoNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Mu Te Pabe'e nanayadooawabe gi ka pumme mu tuukwepu naka'oedyukute sukwe meeoo tooe unakwe mee mu soobedyana. ");
INSERT INTO paoNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Soo Peter yotseoose ka Te Pabe'e uga nanomatugu-kwitoo tanomanegea. Ka oe petuoogase, oetu tomooe'ma pukwi oo namasooapu suu'mu oe kwakwape oosoo yise nobe-kwitoosoo mea mee soonamme, “Mu momoko'ne tookwa togesapa tuukwe ha'oogena yise mani?” ");
INSERT INTO paoNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","O'no tabenosoo waha'yoo nanana Te Pabe'e-wi tunaka'oedyukudu Emmaus mee naneadu-witoo memea kwinga nasogomea ka Jerusalem-wi'yoona. ");
INSERT INTO paoNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Umu ka memeadabena ka namani-kwitu nanatugwe'nga. ");
INSERT INTO paoNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Te Pabe'e mu hatsuhookase sapa ");
INSERT INTO paoNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","umu gi oo posopedakwadoo. ");
INSERT INTO paoNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Soo Te Pabe'e yise mee mu tubenga, “Hekwitu mu netammana?” Umu ka suda sokwamana wamepetu. ");
INSERT INTO paoNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Sumu'yoo umu-matu Cleopas mee naneadu mee oo netamma, “U suu'mu ka sumuna ka umu Jerusalem-witu-matu gi ka a namane-kwitu naka.” ");
INSERT INTO paoNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Soo Te Pabe'e yise oo tubenga, “Ha'oo tu namanise?” Umu yise meeoo, “Jesus-witu, oosoo unu pooha-ga'yoo ka Nazareth-witu kemmana. Ka Te Naa Besa Pooha-ma soo Jesus unu pooha-ga'yoo oosoo ka ewow numu mabesakuse yise Te Naa besa unnepu numu tuukwepu. ");
INSERT INTO paoNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","21","‘Soo Jesus tookwa Te Pabe'e. Oosoo ka mu Tibo'o tayakwuni,’ mee numme ooosapa sokwamadu. Pana umu tutunehanedu ka mu Tibo'o ooka batsa tuunguna. Etze'e tabe mea ka oo tu namanise. ");
INSERT INTO paoNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Yaa awamooa mu momoko'ne numme-matu besow ne tuukwe gi ne nakasopedakwadoona. Umu meeoo, ‘Awamooasoo numme mea'a ka pukwi Te Pabe'e nanomatugu-kwitoo, ");
INSERT INTO paoNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","pana Te Pabe'e kadoo'yoo. Numme ne tuusoobedya-kwikoo umu Te Naa tummatzidu mu toha kakasa-gakoo poonne umu mee ne tuukwe'e, “Te Pabe'e gwetzoi.” ’ ");
INSERT INTO paoNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Mu numme-nagatu-matu mu naana ka oo nanomatugu-kwitoo mea'a. Umu oo poonne petuga oosoo ka mu momoko'ne umu tuukwe-kwa'nesoo. Pana umu gi Te Pabe'e poonne.” ");
INSERT INTO paoNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Soo Te Pabe'e yise mee mu netamma, “Mu gisoo e nakasopedakwadoo. Mu gisoo oo naka'oedyukute ka o'nosoo Te Naa yadooawabe tamme tuukwena. ");
INSERT INTO paoNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","O'nosoo umu meeoo tubotugu, ‘Soo Te Pabe'e mooe nabatsase saa'a yise no'oko mu numu nemadabuekwu.’ ” ");
INSERT INTO paoNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Soo Te Pabe'e yise besasoo mu tuukwe'e ka o'nosoo Te Naa nanayadooawabe Te Pabe'e-witu mu numu tuukwekepu. Mooe'ugasoo soo Te Pabe'e ka Moses unnepu mu tuukwe'e penakwa yise umu susumudu Te Naa nanayadooawabe unnepu waha. ");
INSERT INTO paoNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Umu yise ka umu waahoo naana pukwitoo mea tzage'e manepetu. Pana soo Te Pabe'e oo-kwingadusoo meadu. ");
INSERT INTO paoNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Umu yise meeoo oo netamma, “Mooasoo yongoho pudusoo taba egeahookwu, u sakwa numme-baasoo tooi.” ");
INSERT INTO paoNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Ka mu tukakwuse, soo Te Pabe'e ka tukaba gwuuhoose oetu mu nanesootuhikukooha. Ka tunemamakwuse oo tzabokase umu-matoo oo mameaku. ");
INSERT INTO paoNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","O'no umu o posopedakwatoo oosoo yise gi tapu'aka. ");
INSERT INTO paoNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Umu yise mee u'unekwate, “Ka te sogo kemmadape, soo Te Pabe'e ka a nabotuguna besasoo ta tuukwe, ta yise besa oo nakasoobedya.” Umu yise yosuhoose ka Jerusalem-witoosoo kokodyuhooka, okow yongonasoo. ");
INSERT INTO paoNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Ka mu pepetugase no'yoona Te Pabe'e yadooawabe nanano o, ewa'yoo numu punno'o mu-kumisoo. ");
INSERT INTO paoNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Umu ka mu waahoo mee netamma, “Soo Te Pabe'e togesapa tu ya'e-kwikoo namayodu, Simon Peter ka Te Pabe'e poonne.” ");
INSERT INTO paoNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Umu waha'yoo yise mee mu netamma, “Soo Te Pabe'e numme-no sogomea. Ka o'nosoo Te Naa nanayadooawabe tubotuguna ka Te Pabe'e-witu besasoo ne tuukwe'e. Numme ka mooe'ugasoo gi oo posopedakwatoo. Saa'a ka oo nanesootuhise ka tukaba oo tzabokase, numme oo pudu posopedakwatoo.” ");
INSERT INTO paoNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Togesoo mu apegeagonno soo Te Pabe'e umu-baa tapu'a petuse mu yadoo'e. ");
INSERT INTO paoNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Umu nasoosuihoo, “Uda tsoapa,” mee sokwamahoo. ");
INSERT INTO paoNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Soo Te Pabe'e yise mee mu netamma, “Mu sakwa gi nu-ma suipana. Gi nu tsoapa. ");
INSERT INTO paoNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","40","Nu nuusoo yow ka e mi noko e kuku pumakoo e natzepotzetapu poonne. Mu e mesoo tzama. Soo tsoapa gi tookoope-ga'yoo.” ");
INSERT INTO paoNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Ka besa sokwamahoose umu gisoo oo soo'oedyukupana ka tsoapa mee oo sooyugwepunnena. Soo Te Pabe'e yise mee mu tubenga, “Mu haa'a hemma nadukadu hane?” ");
INSERT INTO paoNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Umu yise pakwe nano'hona oo magahoo ");
INSERT INTO paoNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","oosoo yise mu-kobena'yoosoo tukakooha umu yise oo sopedakwatoo soo Te Pabe'e tookwa togesapa nummenumme. ");
INSERT INTO paoNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Soo Te Pabe'e yise mee mu netamma, “Mooasoo nu ka mu-baa'yoona mu tuukwe'e no'oko ka Te Naa yadooawabe tubotuguna togesapa oo-toogoo namanekwu.” ");
INSERT INTO paoNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Soo Te Pabe'e yise ka Te Naa nanayadooawabe tu tubotugupu nanakasoopedekwadoo oo mayugwe. ");
INSERT INTO paoNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Mee mu netamma, “Mooasoo o'nosoo e manekwuna nanemamakwu. Nu nabatsase pahe tabe mease nu e ya'ekwikoo namayoda. ");
INSERT INTO paoNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Soo nu-kwitu besa na'unnedu no'obatusoo numu oo natuukwekwu, mooe'ugasoo yaa Jerusalem-wi'yoona yise mana kwinga'a-kwi. Mu numu yise tu tuma'emukwana nanekwahase mu tuma'emukwana nasoomu'wase mu nasootuhikwu ka nuka naka'oedyukuna. ");
INSERT INTO paoNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Mu ka nu-kwitu mu numu tuukwekwu ka e manena poonnena yise ka e unnepu nakana. ");
INSERT INTO paoNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Pudusoo nu mu poohamakakwu ka Te Naa unne-kwa'ne. Mu sakwa yaa Jerusalem-wisoo ka mumme e pooha-makanano'oto.” ");
INSERT INTO paoNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Saa'a yise Bethany-tamme meana soo Te Pabe'e mayodase mu nanesootuhikute. ");
INSERT INTO paoNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Toesoo mu nanesootuhikuwununa umu-baa'yoona toogoopatoo tsebooega. ");
INSERT INTO paoNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Umu Te Pabe'e tuukwewabe yise besa sokwamana ka Jerusalem-witoosoo kodyuka. ");
INSERT INTO paoNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Umu ooosapa ka pabatsekoo nanesootuhi nobe-kwi'yoona nanesootuhiyakwe, “U, Ne Naa tubetse besa'yoo,” mee unneyakwe.");
INSERT INTO paoNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","2","Gisoo ka teepu namadabue soo Te Pabe'e mooasoo o. Soo Te Pabe'e ka Te Naa-baa ka Te Naa-wa'ne'yoonasoo. ");
INSERT INTO paoNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Soo Te Naa ka Te Pabe'e no'oko hemma matabue tuungu. ");
INSERT INTO paoNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Soo Te Pabe'e yise ka ooosapa nummennummekwuse no'oko numu kootabuakute Tu Besa Pooha-ma. ");
INSERT INTO paoNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","15","Soo Te Pabe'e kootabuapunnena, togano-wi numu mesoo kootabuakute. Soo suta'yoo togabu-witu gi oo matzooeku-wa'ne'yoo. Soo Te Pabe'e tamme-baa petuse gi haa'noto tamme-nagakwi nummennumme. Soo Te Pabe'e ka tubetse kootabuadu ka mu numu yaa teepu-koobatu haneku petu. Soo Te Pabe'e ooosapa besa tusooyugwedu, numu besa matugu tuwazoo ka kaahenotu ooosapa tuwazoo waha. Numme ka Besa Poohabe poonne, soo Te Naa ka Tu Besaa Tooa'a ooka sootuhi. Soo nana John mee naneadu ka Te Naa tamme-tamme tutayana ka Te Pabe'e-witu mu numu oo tuukwe tuungu. Saa'a mu numu yise ka Te Pabe'e-wi tunaka'oedyukukwu. Soo John yise ka Te Naa Besa Pooha-toohakwi paba yadooase mee unne, “Yow esoo nana puwitu mumme e tuukweyina.” Mu yise mee unakwe, “Tooe esoo nuga kwannga'apana esoo ka Te Tubetse Pabe'e-notu esoo ka ooosapa gwetzoinnummekwuse. Ooonne'yoona tamme sakwa yise oo nakabetsea.” Soo John gi Te Pabe'e, oosoo ka Te Pabe'e-witu numu sukwe tuukwekwu. Ka mu numu meeoo tuukwekwu soo Te Pabe'e numu magwetzoikwu. Tooe soo Te Pabe'e o'nosoo ka teepu matabuese sapa, ka tu nanumu-baa petuse, susumudu umu-matu gi oo heesoobedya. Umu ka Te Pabe'e naka'oedyukudu suu'mu, Te Naa doodooamu manepetugakwu. Gi tamme hownnekoo tammesoo namagwetzoa'e soo Te Pabe'e ka gwetzoibu te sootuhikwu. Numme ka nanabesa oo pooha manena poonne. ");
INSERT INTO paoNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Soo Te Pabe'e no'oko hemma hee-gana, yise ewahoo nasootuhipe te sootuikwu. ");
INSERT INTO paoNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","O'nosoo soo Moses ka te nanamooatupu tuukwe'e, mee mu saa'a ka Te Naa-witu nakadooa. Saa'a yise soo Te Pabe'e Jesus te tuukwe soo Te Naa unu te soobedya. Soo Te Pabe'e togesapa te tuukwe. ");
INSERT INTO paoNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Gi haga ka Te Naa poonnedu, oo Besaa Tooa'a Jesus suu'mu ooosapa oo-no'yoodu oo sopedakwadoo. Soo Te Pabe'e ka Te Naa witu te tunesootabue. ");
INSERT INTO paoNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Mu Jew numu nanesootuhi moohedu Jerusalem-witu ka mu naana-matu yise ka mu tutummatzidu-no ka John-matoo nataya mee yise oo tubengu. “Haga u? U haa'a Te Pabe'e? U haa'a yow oosoo nanetammadu?” ");
INSERT INTO paoNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Soo John mee mu nanekwegea, “Gi nu.” ");
INSERT INTO paoNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","“U haa'a Elijah?” mee tuwazoo umu oo tubengu. Soo John yise meeoo, “Nu gi Elijah.” Umu yise tuwazoo oo tubenga, “U haa'a Te Naa yadooawabe numme-matoo oo tutayana o'nosoo nanetammadu?” “Gi!” mee soo John. ");
INSERT INTO paoNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Umu yise meeoo oo netamma, “Haga yise u? Ha'yoo saa'a numme mu numu numme tayadu tuukwedooa? U sakwa uusoo nakwitu ne tuukwe.” ");
INSERT INTO paoNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Soo John mee mu nanekwegea, “Nu yow soo nana Te Naa'a Pooha-tookwi, numu-wana nobe-ga'yoo mu numu nu-baa petudyana nu meeoo mu netamma, ‘Ka suda mu tumaduguna nematzagakwuni, ka Te Pabe'e pudusoo petukwuna tugana'a tzage'e manekena ne mu numu tunesootabue.’ Ka Te Naa yadooawabe, Isaiah mee naneadu e manena nanemamakwupu-witu oo nabotugupu.” ");
INSERT INTO paoNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","28","Mu Jew nanesootuhidu-nagatu Pharisee mee nananeadu, ka mu Jew numu moohedu-nagatu-no ka John-matoo nataya. Ka baa hooodu Jordan mee naneadu-kwi soo John baa-wi numu matzakayakwe, ka Bethany mee naneadu tzage'e'yoona. Mu Pharisee meeoo ka John netamma, “U gi Elijah, u gi Te Pabe'e, u gi tuwazoo Te Naa yadooawabe-matu, how yise manena u numu baa-wi matzakayakwe? Hownnekoo pooha tooha-kwi, yise haga mu numu baa-wi u matzaka tuungu?” Soo John yise mu nanekwegea, “Nu ka mu numu, baa-wi sukwe matzaka. Soo Te Pabe'e mu-noo'yoopana mu gi oo soopedakwatoo-wa'ne'yoo.” ");
INSERT INTO paoNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","33","Ooga mooa soo John ka Jesus Te Pabe'e poonne, pudamme oo kemma. Soo John yise Te Naa Besa pooha-toohakwi meeoo, “Yowsoo Te Pabe'e. Yow esoo nana mu numu nanasuda mamanena-koobatoo nabatsakwudu. Soo Te Naa ka mu numu baa-wi e matzaka tuungudu mee tuwazoo e netamma, ‘U ka mu Pabe'e posopedakwadookwu, ka E Besa Pooha-ma oo pooha nasootuhise. Soo E Besa Pooha yise ooosapa ka mu Pabe'e-naga'yookwu. Soo Te Pabe'e yise saa'a ka mu tunaka'oedyukudu ka E Besa Pooha-ma punno'o sootuhikwu.’ Nu ooosapa meeoo mu netammano'o, ‘Soo Te Pabe'e pudusoo petukwu.’ Tooe oosoo e wannga'a natubanga pana yow esoo Te Tubetse Pabe'e numu-koobenatusoo. Gisoo nu Te Pabe'e posopedakwadoo, nu mu numu baa-wi matzakakena, ooonne'yoona mu Jew numu oo nakasopedakwadoo ka Te Pabe'e pudusoo petukwuna.” Soo John yise mee unakwe, “Nu ka Te Naa Besa Pooha poonne, pa'anakwana, kwe'na'a tubongo wueketu-kwa'ne tabuakese ka Te Pabe'e-naga manipetu. ");
INSERT INTO paoNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Nu ka Pooha Nasootuhipe poonne, nu yise mu tuukwe oosoo Te Tubetse Pabe'e.” ");
INSERT INTO paoNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Ookow moooa soo John waahoo umu putoohakwi natunedyooemodu-no oona konnopunne. ");
INSERT INTO paoNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Ka Te Pabe'e pumoopa oo sogome'a oo poonnese, John mee mu netamma, “Mow masoo Te Pabe'e tamme-koobatoo nabatsakwudu.” ");
INSERT INTO paoNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Waha'yoo umu natunedyooemodu-matu oo nakahoose, ka Te Pabe'e-nakwi memeahoo. ");
INSERT INTO paoNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Soo Te Pabe'e wesase mu poonne ka tu nakwi mu memea'a. Soo Te Pabe'e yise mu tubengu, “Hemma mu?” Umu yise meehoo, “Hano u tooiyakwe?” ");
INSERT INTO paoNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Soo Te Pabe'e mu nanekwegea, “Nu-no kemmase muusoo oo poonnekwu.” Umu yise, oo-no memea, oonaa oo pukwi'yoo-witoo. O'no tabeno umu gi haa'no oona oo-baa'yoopunne. ");
INSERT INTO paoNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","41","Sumu'yoo mu waha-matu natunedyooemodu Te Pabe'e-nakwi meadu, Andrew mee naneadu, Simon Peter pabe'e ka tu wanga'a-baa petuoogase oo tuukwe, “Numme ka Te Pabe'e-no nanatapoegea.” ");
INSERT INTO paoNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Ka Simon yise Te Pabe'e-baa bi petuooga. Ka mu pepetuoogase soo Te Pabe'e ka Simon poonnese mee oo netamma, “U yow, Simon. Yaa mana-kwana'a nu Cephas mee ka u tubetse tunaka'oedyukute u neakwu.” ");
INSERT INTO paoNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Oogow mooo'a soo Te Pabe'e ka teepu Galilee mee naneadu-witoo meakwu, mee tusooyugwe. Soo Philip mee naneadu punno'o o. Soo Te Pabe'e mee ka Philip netamma, “U sakwa nu-no mea.” ");
INSERT INTO paoNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","45","Soo Nathanael mee naneadu oonow nobe-ga'yoo. Soo Philip yise ka Nathanael mayuse oo tuukwe'e, “Numme ka Te Pabe'e tapoega, soo Moses ka Te Naa yadooawabe-no o'nosoo oowetuoo botugu. Oosoo Jesus mee'e nane'a, o soo Joseph tooa'a, ka Nazareth mee naneadu-wi'yoona kemmadu.” ");
INSERT INTO paoNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Soo Nathanael yise mee unakwe, “Gi besa'yoo numu suu'mu, ka Nazareth-wi'yoona kemma.” Soo Philip yise meehoo, “Kemmase uusoo nama oo tapoegea.” ");
INSERT INTO paoNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Soo Te Pabe'e ka Nathanael poonne, meeoo yise, “Yow esoo Te Naa-wi tunaka'oedyukudu. Esoo gi suda tusooyugwedu.” ");
INSERT INTO paoNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Nathanael yise mee tutubengu, “Hownnekoo u e sopedakwatoo?” Soo Te Pabe'e mee oo nanekwegea, “Nu oona sunnga-toohakoo u pooha poonne gisoo ka Philip ume ba'e.” ");
INSERT INTO paoNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Soo Nathanael yise mee unakwe, “U yow Ne Pabe'e, u ka tamme Jew numu-kooba katukwutu.” ");
INSERT INTO paoNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Soo Te Pabe'e yise meeoo, “Nu u pooha poonnena mee e unakwe u haa'a e naka'oedyukute? ");
INSERT INTO paoNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Nu kaaheno mu tuukwe, mu saa'a ka Te Naa nanabesa oo tumada'e oo poonnekwu. Mu nuga mane-too ka Te Naa sopedakwadoo petugakwu, o tutusooyugwena, tuwazoo.” ");
INSERT INTO paoNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","2","Waha tabe mease ka teepu Galilee mee naneadu-kooba'yoona, ka Cana mee naneadu-kwi'yoona numu nanodukwadookwu. Soo Te Pabe'e ka numme tunakatzimodu-no oetu naba'e, soo Te Pabe'e pea punno'o. ");
INSERT INTO paoNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Togesoo ne tuka aata soo atsa baa nasoo'ahoo. Soo Te Pabe'e pea mee oo netamma, “Soo nahebedu punoko te tukana nasoo'ahoo.” ");
INSERT INTO paoNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Soo Te Pabe'e oo nanekwegea, “Gi hownnekoo nu meno'o mu tummatzi-wa'ne'yoo, e pooha manekwuna gisoo oe manepetu.” ");
INSERT INTO paoNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Ooonne'yoopana soo oo pea yise ka umu numu tummatzidu mee netamma, “Ka e tooa mumme tunetammaku-kwa'nesoo, saa'a mane.” ");
INSERT INTO paoNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Naapahe'yoo papabatse'yoo tupe-ma namadabuedu, pukwi baa mu tubanena umu tzage'e nahane. Mu Jew numu nanesootuhipu puma namayohona, pukwi mu mabatzagana. ");
INSERT INTO paoNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Soo Te Pabe'e mee mu netamma, “Baa-ma ka pukwi mu tubanena kaanoku.” Ka ooka mu kaanokuse, ");
INSERT INTO paoNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","soo Te Pabe'e mee'e mu netamma, “Ka baa-matu bayoongase, ka mu tuka-kooba poena'ewabe mooe bamaga.” ");
INSERT INTO paoNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Soo mu poena'ewabe ka baa-matu tumahoo, oosoo tookwa atsa baa manipu-ga'yoo. Soo mu poena'ewabe ka Te Pabe'e ooka sootunagahoona gi sopedakwatoo, umu numu tummatzidu suu'mu oo sopedakwatoo. ");
INSERT INTO paoNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Soo mu poena'ewabe ka nodukwadookwudu bihoose mee oo netamma, “Tooe haga tooe ka besow atsa baa numu mooe hebekuyakwe. Yise saa'a ka mu numu baagoehookase, umu ka gi tubetse besow mu numu hebekuyakwe. U nakwitoo ka besow nabeni.” ");
INSERT INTO paoNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Yow esoo nagutza mooe'ugasoo ka Te Pabe'e pooha manikepu, ka Cana-wi'yoona. Owe manakwana numme ka Te Pabe'e numme pooha tunedyooemona unukoosoo besa oo naka'oedyukute manika. ");
INSERT INTO paoNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Saa'a soo Te Pabe'e ka Capernaum mee naneadu-witoo mea, tu pea, tu wanga'amu, yise numme Te Pabe'e nakatzimodu-no. Numme punno'o huu tabenosoo o. ");
INSERT INTO paoNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Saa'a yise numme tunakatzimodu ka Te Pabe'e-no Jerusalem-witoo tuwazoo mea'a. Ka mu Jew numu ka o'no tu namagwetzoina soomayuna gi namayuadu tukaba nadukano'o tabeba-ga'yoo, o'no yise paba tukayakwe. ");
INSERT INTO paoNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Numme pabow nanesootuhi nobe-wi petuooga, oo-kobena'yoona ka tu nananesootuhino'o mu nanana kootsoo-ma tumu'u, seepu noko weeho tuwazoo, yise susumudu nanana o manepunnena ka mu wakwawa'a puma tumukwuna tzanabetokudyakwe numme mu poonne. ");
INSERT INTO paoNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Soo Te Pabe'e yise tugapoo nakweba'a-doose, ka puma mu tumuna mu kootsoo noko mu seepu tuwazoo, ka pabatsekoo nanesootuhi nobe-kumabakoo wumahukwunihoo. Ka pukooba mu tutzanabetokudyina tonabedahoose, ka oo-kooba natuoona tatapepu'a. ");
INSERT INTO paoNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Ka mu nanana weeho-ma tumudu mee netamma, “Mu sakwa mu hootseba'a haneooka, gi ka Te Naa-matoo pukwi'yoona te nanesootuhidyina nobe-kobena'yoona hemma-ma tumupana.” ");
INSERT INTO paoNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Numme ka Te Pabe'e tunakatzimodu ka saa'a oo sooma'yu ka o'nosoo Te Naa yadooawabe mesoo tubotugupu ka Te Naa unnepu, “E Naa ume ooosapa namatuguna, ka numu u-tamme suda tumaduguna nu gi petzape.” ");
INSERT INTO paoNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Susumudu mu Jew numu nanesootuhi papabe'e mee oo netamma, “U sakwa besa nanasookwugi ne tusootunagaku, o'no numme u oedyukukwu yow tookwa ka Te Naa tunetammana mayoho mee numme u sooyugwekwu.” ");
INSERT INTO paoNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Soo Te Pabe'e yise meeoo mu nekwegea, “Mu ka eka nanesootuhi nobe kadoo mayugwese, nu pahe tabeba-wisoo oo mayodakwusoo.” ");
INSERT INTO paoNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Mu Jew numu nanesootuhi papabe'e yise mee unakwe, “Esoo paba'yoo nanesootuhi nobe wu'na'me'yoosesoo namadabuepu. U yise ka sumu'yoonasoo hownnekoo u pahe tabeba-wisoo nanakwisoo a matabuehookwu?” ");
INSERT INTO paoNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Pana soo Te Pabe'e puusoo tu ya'e-kwikoo tu namayoda-kwitu netammana meeoo unakwe, umu yise gi oo nakasopedakwadoo. ");
INSERT INTO paoNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Ka saa'a Te Pabe'e tu ya'e-wikoo, pihoo tabeba-wisoo namayoduse, o'no numme ka oo unnepu pudu nakasopedakwadookooha, ka puusoo oo nanetammana. Numme yise oo naka'oedyukute ka Te Naa o'nosoo nanayadooawabe unnepu, yise ka Te Pabe'e unnepu togesapa nayadooadu. ");
INSERT INTO paoNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Ka mu Jew numu ewa tukano'o ka Jerusalem-wi'yoona, ewa'yoo numu ka nanabesa ka Te Pabe'e pooha manena poonnese oo naka'oedyuku. ");
INSERT INTO paoNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","25","Soo Te Pabe'e mu numu waha-tamme tusooyugwedu sopedakwadoo, mooasoo mu manekwuna gi watzekupunne, soo Te Pabe'e owetuoo mu numu pumme batsakwuna soopedakwedoo. Ka sukwe numu gi totogekoo mu sopedakwadoona. ");
INSERT INTO paoNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","2","Sumu'yoo nana Nicodemus mee naneadu ka umu nananesootuhi papabe'e-matu, ka Te Pabe'e-baa toga nobene petugase mee oo netamma, “Numme numu u sopedakwatoo u yow Te Naa-nakwana kemmadu, ka tu unnepu numme u tunedyooe tuunguna. U ka Te Naa besa pooha-ma nanabesa pooha manekena.” ");
INSERT INTO paoNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Soo Te Pabe'e mee oo netamma, “Nu kaaheno u tuukwekwu. Ka Te Naa nakabetsakwuse, u sakwa pudu nadooa'adoosoo.” ");
INSERT INTO paoNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Soo Nicodemus yise mee ka Te Pabe'e tubenga, “Mooasoo nu unu wa'etsena. Hownnekoo nu pudu nadooa'adookwusoo? Gi nu hownnekoo ka e pea nagasoo egease pudu nadooa'adookwusoo tuwazoo.” ");
INSERT INTO paoNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","6","Soo Te Pabe'e mee oo nanekwegea, “Nu kaaheno u tuukwekwu. U ka Te Naa-wi mooe tunaka'oedyukuse, o'no yise u ka Te Naa unnepu naka'oedyukukwu. Numu puusoo oo mada'e ka numu pudu nadooa'adoona, pana soo Te Naa Besa Pooha suu'mu, ka mu numu tunaka'oedyuku mayugwekwu. ");
INSERT INTO paoNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Gi a nasoomenakwupana, gi nagutza unu namanedu nu u netammakute. ");
INSERT INTO paoNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Soo Te Naa ka hukwapa-wa'ne'yoo. Soo hukwapa puu tooe how tooe hukwa-tabu'a, gi tamme oo poonne-wa'ne'yoo. Gi haga pukwi'yoona oo kemmana, yise pukwitoo oo meana sopedakwadoo. Gi haga oo sopedakwadoo hownnekoo soo Te Naa Besa Pooha mu numu tunaka'oedyuku mayugwekwu.” ");
INSERT INTO paoNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nicodemus yise mee unakwe, “Togesoo nu gi oo nakasopedakwatoo ka nuka u tuukwena.” ");
INSERT INTO paoNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Soo Te Pabe'e yise meeoo, “U sakwa ekow nakasopedakwadoo, u ka mu Jew numu mooasoo tunedyooennummena. ");
INSERT INTO paoNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Nu togesapa u tuukwekwu. Nu ka e sopedakwatoona, ka e poonnena tuwazoo, nu u tooe tuukwe pana u gi e naka'oedyukudu. ");
INSERT INTO paoNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Ka yaa teepu-koobatu ka numu sooabe, Te Naa-no sumusoo manepunnedu u gi oo naka'oedyukute too'e nu u tooe tuukwepana, ka hemma manepunnena ume e tuukwe u gi oo nakasopedakwatoo, u ka gi oo naka'oedyukuna. ");
INSERT INTO paoNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Gi haga yaa teepu-koobatu ka Te Naa manepunne-kwitu sopedakwadoo nu suu'mu, soo Te Pabe'e ka Te Naa ba'yoona kemmapuna oo sopedakwadoo. ");
INSERT INTO paoNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Ka o'nosoo mu te nanamooatupu manepu-wa'ne'yoo, ka togogwa pumme tokuese umu ka Te Naa nanetsagwaya'e. Soo Te Naa yise meeoo mu tunetammakute, ‘Ka weehepu togogwa-wa'ne matabuese, pa'a oo taposase, umu numu saa'a ookow poonnena gwetzoimodooa.’ ");
INSERT INTO paoNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Mu ka nuka nanetzakwiyina gwetzoikwu. O'nosoo te nanamoomooatupu-wa'nesoo ka pa'a e nataposase mu saa'a gwetzoidooa. ");
INSERT INTO paoNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Te Naa no'oko numu ka teepu-koobatu besa soobedyana, tu besa dooa tamme-koobatoo nemawuni. Tooe haga tooe nu-kwi tunaka'oedyukudu gi ya'ekwu ooosapa gwetzoinnummekwu. ");
INSERT INTO paoNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Soo E Naa ka yaa teepu-koobatu numu e magwetzoi tuunguna yaatoo e ta'ya, gi nagutza ka mu sutakoo numu kadoo e mayugwe tuunguna. ");
INSERT INTO paoNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Tooe haga tooe nu-wi tunaka'oedyukudu gwetzoikwu. Tooe haga tooe gi nuka heesoobedyadu sumu-tammesoo ya'ekwu, mooasoo soo Te Naa meeoo tunetammapu. ");
INSERT INTO paoNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Nu yow gwetzoibu manepunnena, ooonne'yoona susumudu numu nu-ma soonammetugu, umu gi e heesoobedyadu ka suda tu manena hemma ooonakwa sooyugwena. Soo suda mu tumaduguna umu-matoosoo kodyukwu. ");
INSERT INTO paoNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Soo tooe haga tooe suda manedu gi nuka petzape, gi tuwazoo nu-matoo kemma, oosoo ka suda tu manena soogwina ooosapa togano-kwi. ");
INSERT INTO paoNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Mu numu besa tumadugudu ka tu tumaduguna gi nasookwina, nu-matoo kemma, o'no no'yoona numu mu poonne umuoo tookwa Te Naa nakabetseadu.” ");
INSERT INTO paoNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Ka saa'a soo Te Pabe'e ka numme tunakatzimodu-no, ka teepu Judea mee naneadu-kwi petuse mu numu baa-wi matzaka. ");
INSERT INTO paoNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Soo John punno'o baa-wi numu matzakadyakwe, ka ewow baa-ga-kwi'yoona. ");
INSERT INTO paoNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","O'no soo John gisoo nakwutumana. ");
INSERT INTO paoNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Umu John pupua'amu, mu Jew nanesootuhiwabe-matu-no, ka baa-witu numu namatzakadyi-koobatoo nanepetukute. ");
INSERT INTO paoNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Umu John pupua'amu ka John-matoo mease mee oo netamma, “Soo nana Te Pabe'e mee u netammana, meno'o numu baa-wi matzakadyakwe. Ewa'yoo numu oomatusoo meadape.” ");
INSERT INTO paoNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Soo John yise meeoo, “Numme ka Te Naa numme tunetammekupu mayohodyakwe.” ");
INSERT INTO paoNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Mu mooasoo mee e unnena naka, “Nu gi mu Pabe'e, nu oo-kobenasoo yaatoo natayadu. Nu ka Te Pabe'e-witu numu tunesootabuadu. ");
INSERT INTO paoNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Ka numu nanodukwadoose, soo nana ka mogo'ne nodukwadoose oo kooma manekwu. Soo nana pua'a oo-baa sukwe wununa oo nakapunne. Oosoo punno'o besa soonamme ka nana nodukwadoodu besa soonamme. Ooonne'yoona nu besa soonamme ka mu numu Te Pabe'e-matoo mu mea, mu poonnena. ");
INSERT INTO paoNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Mu numu sakwa Te Pabe'e nakatzimo gi nuka.” ");
INSERT INTO paoNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Soo Te Pabe'e no'oko numu-koobatu ka Te Naa-baa'yoona kemmana, ka Te Naa manepunne-kwitu no'oko sopedakwatoo. Mu numu puu ka yaa teepu-koobatu hemma sopedakwadoona oo waha. ");
INSERT INTO paoNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Soo Te Pabe'e no'oko ka Te Naa-witu sopedakwadoona te too'e tuukwe'e, pana susumudu numu gi oo naka'oedyukute. ");
INSERT INTO paoNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Tooe haga tooe ka Te Pabe'e naka'oedyukuse soo Te Naa oo tubetse toge'yookute. ");
INSERT INTO paoNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Soo Te Naa ka Te Pabe'e tamme-matoo tayapu, oosoo ka Te Naa kaaheno unnena te tuukwe tuunguna. Soo Te Naa too'e no'oko ka tu Besa Pooha-matu-ma Te Pabe'e sootuhi. ");
INSERT INTO paoNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Soo Te Naa ka tu Tooa, Te Pabe'e Jesus, unu soobedyana too'e no'oko tu pooha oo-tamme nemawuni. ");
INSERT INTO paoNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Mu numu Te Pabe'e-wi tunaka'oedyukudu ooosapa gwetzoimokwu. Mu gi Te Pabe'e-wi tunaka'oedyukuna punno'o gi gwetzoibu nasootuhikwu, yise mu tuma'emukwana umu-matoosoo kodyukwu. ");
INSERT INTO paoNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Mu Jew nananesootuhidu Pharisee mee nananeadu, ka Te Pabe'e nuusookweta. Umu ka mee tunakana, ewa'yoo numu ka Te Pabe'e-wi tunaka'oedyuku manemena. ");
INSERT INTO paoNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Numme Te Pabe'e-matoo natunedyooemodu, ka numu baa-wi matzakadyakwe, soo Te Pabe'e gi baa-wi numu matzakadu. ");
INSERT INTO paoNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Numme ka Te Pabe'e-no ka teepu Judea mee naneadu-kwi'yoona mea'ase, ka Galilee mee naneadu-kwitoosoo kodyuka, soo Te Pabe'e ka mu Pharisee pumme nuusoogweda oo sopedakwadoona. ");
INSERT INTO paoNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ka oonow meana, numme ka teepu Samaria mee naneadu-toogoo me'a. ");
INSERT INTO paoNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Ka Samaria-wi numme ka Sychar mee naneadu-kwi petuga. ");
INSERT INTO paoNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","8","O'nosoo ka Jacob pahoda-kwi numme petuga, ka kwinga'a sogo mease, gi nadamanese. Ka tabeno tu manekese numme ka Te Pabe'e oo tamawuse, tukapu tumuga. Soo sumu'yoo mogo'ne baa-witoo kemmana oo-baa petuoo. Soo Te Pabe'e mee oo netamma, “Nu unu puudya'e nu baa soogwa'e.” ");
INSERT INTO paoNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Soo Samaritan mogo'ne mee ka Te Pabe'e netamma, “U Jew numu pana u nuka Samaritan numu banekwikute.” (Mu Jew numu ka mu Samaritan, gi petzabedu, gi unu mu yadoo'edu.) ");
INSERT INTO paoNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Soo Te Pabe'e mee ka Samaritan mogo'ne netamma, “U ka e pooha-gana gi sopedakwadoona gi ka E Naa ume sootuhikwuna tuwazoo, u sakwa uga ka oo tubengase soo Te Naa sakwa ka baa puu-ma nagwetzoidu u bamaka.” ");
INSERT INTO paoNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Soo mogo'ne yise mee oo netamma, “U gi tugapu-gana, gi too u wetooa-ga'yoo, soo pahodape tuwow tookapu'yoo. Hownnekoo yise u eka baa puma nagwetzoidu hanekwu? ");
INSERT INTO paoNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","U haa'a ka te namooatupu Jacob ooonakwa besowsoo pahodape-ga'yoo? Soo Jacob ne pahodakupu puma ookowsoo gwetzoina, umu oo doodooamu yise oo kootsoo punno'o puma gwetzoina.” ");
INSERT INTO paoNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Soo Te Pabe'e yise mee oo nanekwegea, “Tooe haga tooe ka ekow baa hebedu puudya'ekwusoo. ");
INSERT INTO paoNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Pana eka nuga pumme bamakana gi puudya'e-wa'ne'yoo. Oosoo eka baa, nuga pumme bamagana nanagatoo hebese, oosoo patzona-wa'ne gi pasa-wa'ne'yoo, numu ooosapa gwetzoinnummekwu.” ");
INSERT INTO paoNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Soo mogo'ne yise mee ka Te Pabe'e netamma, “U sakwa e bamaka, o'no nu gi puudya'ena gi yaatu bidya petuya'ekwu.” ");
INSERT INTO paoNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Soo Te Pabe'e yise mee oo netamma, “Ka u kooma bihoodooase yaasoo pepetuhoo.” ");
INSERT INTO paoNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","18","Soo mogo'ne mee oo netamma, “Nu gi kooma-ga'yoo.” Soo Te Pabe'e yise mee oo netamma, “U togesapa tuukwe'e, ka meeoo unnena, ‘Nu gi kooma-ga'yoo,’ mee. U manegeoo koomamu-gapu. Soo nana meno'o puno u nobe-gana gi u kooma.” ");
INSERT INTO paoNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Soo mogo'ne yise mee ka Te Pabe'e netamma, “Meno'o nu u sopedakwatoo u tookwa sumu'yoo ka umu Te Naa nanayadooawabe-matu. ");
INSERT INTO paoNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Umu ne nanamooatupu ekow giba-kooba'yoona nanesootuha'e, pana mu Jew yise meeoo tunetamma, ‘Tamme sakwa Jerusalem-wi'yoona nanesootuhi.’ Haga yise toge-koo?” ");
INSERT INTO paoNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","24","Soo Te Pabe'e mee oo nanekwegea, “Mu Samaritan numu nanesootuhi pana, togesoo gi oo nakasopedakwadoo. Numme ka Te Naa sopedakwatoo oosoo ka Te Pabe'e-no numme Jew-matu magwetzoipu. Mu numu tooe hano'yoona tooe nanesootuhikwu. Pudusoo mu tunaka'oedyukudu ka kaaheno Te Naa-matoo nanesootuhikwu, ka oo besa pooha pumme tummatza'e. ‘Yooonnekoo nu-matoo mu kaaheno nanesootuhiyakwe,’ mee'e soo Te Naa te netamma. Soo Te Naa unu pooha-gana ooonne'yoona tamme tooe hano'yoona tooe sakwa ka oo pooha-masoo oo-matoo nanesootuhi.” ");
INSERT INTO paoNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Soo mogo'ne yise mee oo netamma, “Nu oo sopedakwatoo soo Te Pabe'e yise pudusoo petukwu. Ka saa'a petuse oosoo no'okosoo hemma kaaheno te tuukwekwu.” ");
INSERT INTO paoNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Soo Te Pabe'e yise mee oo netamma, “Nu mooasoo yow. Nu Mu Pabe'e.” ");
INSERT INTO paoNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Numme ka Te Pabe'e ka mogo'ne-no yadoo'adyakwe oo poonnena umu-baa petuoogonno. Ha'ooga manena ka mogo'ne yadooedyakwe? Mee numme sookama pana gi mu tubenga. ");
INSERT INTO paoNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","32","Soo mogo'ne ka tu bano'osa mawuoogase ka tu nobe-witoo kodyuhooka. Numme ka Te Pabe'e mee netamma, “Mooasoo numme tukapu tumuhoodooa, yaatu tuka.” Soo Te Pabe'e mee ne netamma, “Nu atamasoo gwetzoidu.” ");
INSERT INTO paoNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Numme yise mee nananetamma, “Haga gina tukapu a makahoodooa?” ");
INSERT INTO paoNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Soo Te Pabe'e yise mee unakwe, “Nu ka E Naa tunetammana nakabetseana gwetzoa'e. ");
INSERT INTO paoNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","38","Mooasoo ewa'yoo ka Te Naa besa unnepu-witu mu numu tunedyooe. Ooonne'yoona meno'o mu numu mumme wutoo'e, ka Te Naa besa unnepu pumme tunedyooekwudu. Nu yise meeoo mu netammakwu mu numu nu-kwitu tuukwe, o'no ewa'yoo numu e naka'oedyuku manepetukwu, yise soo Te Naa gi mobegwa-ga mu sootuhikwu. Mu ka 'yoo mu manekwi nasootuhikwu. Mu yise ka mu numu ka Te Naa unnepu mooe tunedyooedu-no besa sokwamakwu ka mu numu nuka naka'oedyukuna mu nasootuha'e.” ");
INSERT INTO paoNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Toge, o'no soo mogo'ne ka petuoogase ka tu nanumu mu Samaritan numu, mee netamma petuga, “Kemmase ka nana wegeadooa oosoo no'oko e manepu gi nekwatsekute. Nu oo naka'oedyukute o oosoo Te Pabe'e.” Ewa'yoo numu yise ka Te Pabe'e-wi tunaka'oedyuku mane. Mu numu yise ka Te Pabe'e-baa petuhooga. ");
INSERT INTO paoNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Mu Samaritan numu yise mee ka Te Pabe'e netamma, “U sakwa yaa numme-baasoo.” Soo Te Pabe'e yise waha tabeno umu-baa. ");
INSERT INTO paoNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Ka Te Pabe'e unnepu nakase ewa'yoosoo numu tunaka'oedyuku mane. ");
INSERT INTO paoNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Umu ka mogo'ne mee netamma, “U ka Te Pabe'e-witu ne tuukwese numme tunaka'oedyuku mane, ka mooe'ugasoo numme ka nummesoo oo poonnese, oo nakana numme yise tubetse tunaka'oedyuku mane.” ");
INSERT INTO paoNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Waha tabe mease soo Te Pabe'e ka teepu Galilee mee naneadu-kwitoo mea. ");
INSERT INTO paoNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Mooasoo soo Te Pabe'e ne tuukwe'e ka Te Naa nayadooawabe nananumu gi ooka mu naka'oedyukuna. ");
INSERT INTO paoNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Ewa'yoo Galilee numu mooasoo ka tu pooha na'ewatuka-kwikoo ka Jerusalem-witu nanabesa ka Te Pabe'e pooha tumadugupu poonne. Ooonne'yoona ka Galilee-wi ka Te Pabe'e petugase mu numu besa oo matuku. ");
INSERT INTO paoNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Soo Te Pabe'e yise ka Cana-witoosoo kodyu petu. Soo numu moohedu tooa oona ka Capernaum-witu tuoeya'e. ");
INSERT INTO paoNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Soo numu moohedu ka Te Pabe'e ka teepu Galilee-wi petuna nakase, ka Te Pabe'e-baa petuse mee oo netamma, “E dooa unu tu'oedyuina ya'ega'a ona Capernaum-wi. U sakwa kemmase oo mabesakudooa.” ");
INSERT INTO paoNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Soo Te Pabe'e mee oo netamma, “Mu gisoo tunaka'oedyukute. Mu ka nanabesa e pooha manepu poonnese suu'mu oo naka'oedyukukwu.” ");
INSERT INTO paoNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Soo numu moohedu nana ka Te Pabe'e meeoo netamma, “U sakwa meno'osoo nu-no kemma, gisoo ka e tooa ya'e.” ");
INSERT INTO paoNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Soo Te Pabe'e mee oo netamma, “U sakwa kodyuka, u tooa mooasoo gwetzoikwu.” ");
INSERT INTO paoNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Soo numu moohedu ka Te Pabe'e naka'oedyukuse meahoo, togesoo ka oona tu nobe-kwitoo oo mea, soo oo tummatzidu nana oo wegeahoodooase mee oo tuukwe'e, “U tooa mooasoo besa manepu.” ");
INSERT INTO paoNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Soo numu moohedu ka pumme tummatzidu nana mee tubenga, “Hannano'o besa mani?” Oosoo yise oo nanekwegea, “Etze'e toge tabeno kadoo'e.” ");
INSERT INTO paoNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Soo nana oetu soomayuhoo, ka oona nokwikoo ha'yoo soo Te Pabe'e meeoo e netamma, “U tooa mooasoo besa namagwetzoipu.” Soo numu moohedu nana ka mu tu nobe-kwitu numu-no, ka Te Pabe'e naka'oedyuku mane. ");
INSERT INTO paoNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Yow esoo wahasoo ka Te Pabe'e nanabesa pooha tumadugupu, ka teepu Galilee-kooba'yoona. Gi haa'no'yoose ka teepu Judea mee naneadu-kwi'yoona oo kodyu petuse. ");
INSERT INTO paoNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Saa'a Te Pabe'e ka Jerusalem-wi petuga, ka mu Jew numu otuoo ewa pooha tuka-no'o. ");
INSERT INTO paoNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Ka Jerusalem-wi oo petugase, tuutse'ekoo banunadu Bethsaida mee naneadu na'oonnakwi manegeoo nahabatoo. ");
INSERT INTO paoNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","4","Ewa'yoo tuoegoedu numu oho. Susumudu gi tutubootabuedu, umu-matu gi modu, umu-matu gi yuyutsunga manepu. Umu ka Te Naa tummatzidu toha kasa-gakoo wutooena, ka pudusoo ka baa oo mayutsunga petukwuse. Soo mooe'ugasoo numu ka baa bayutsungawunudu-kwi ekadu besa maniyakwe. ");
INSERT INTO paoNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Sumu'yoo gi nummedu nana ewa (38) tomogapu oe numu-no. ");
INSERT INTO paoNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Soo Te Pabe'e oo poonne ka oona oo hape, yise soo gi nummedu nana wuna'me o hape, mee oetu naka. Soo Te Pabe'e mee oo tubengu, “U haa'a u namabesakuna soogwa'e?” ");
INSERT INTO paoNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Soo nana mee ka Te Pabe'e nanekwegea, “Ka bayutsungatu-kwitoo e tummatzikwudu kadoo haga. Kumma'yoosoo nonotsa nuka-kobenasoo ka baa-wi mooe ekeahooyakwe.” ");
INSERT INTO paoNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Soo Te Pabe'e yise mee oo netamma, “Yotseoose nummemanese, ka u wegea mahedase nobe-kwitoo kodyuka.” ");
INSERT INTO paoNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Esoo ka mu Jew numu nanesootuhi tabeno tooe, a namanena. ");
INSERT INTO paoNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Mu Jew numu nanesootuhi moohedu ka nana namabesakupu mee netamma, “Soo tamme putoogoo tumayohona, gi soo numu puusoo tu wegea maheta tamme nanesootuhi tabeno.” ");
INSERT INTO paoNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Oosoo nana besa manipu mee oo nanekwegea, “Soo nana e mabesakudu meeoo e netamma, ‘U besa manese, u wegea mahedase nummennumme,’ ” mee'e. ");
INSERT INTO paoNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Umu numu nanesootuhi moohedu yise mee oo tubenga, “Haga meeoo u netamma?” ");
INSERT INTO paoNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Soo nana gi oo sopedakwatoo ka Te Pabe'e, ka mu numu ewa-naga oo manise. ");
INSERT INTO paoNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Saa'a soo Te Pabe'e ka pabatsekoo nanesootuhi nobe-kwikoo oo mayuse mee oo netamma, “U meno'o besa manepu. Ka suda u tumaduguna ma'wu, u ka gi suda u tumaduguna ma'wuna, soo suda u tumaduguna u-matoosoo kodyuse u unusoo tuoeyidooa.” ");
INSERT INTO paoNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Soo nana yise mease ka mu Jew numu nanesootuhi moohedu tuukwe'e, “Soo Te Pabe'e e mabesaku.” ");
INSERT INTO paoNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Mu Jew numu nanesootuhi moohedu, ka Te Pabe'e nekwohone petu, oosoo ka nanesootuhi tabeno mu numu mabesakuna. ");
INSERT INTO paoNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Soo Te Pabe'e mee mu netamma, “Soo Nuga Naa, puu nonotsa tabeno numu sootuhidyakwe, gi oo ma'wudu. Nu punno'o oo-wa'ne'yoo.” ");
INSERT INTO paoNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Mu Jew numu nanesootuhi moohedu, ka Te Pabe'e unu batsa soogwa'e. Soo Te Pabe'e ka nanesootuhi tabeba-wi mu numu mabesakuna, yise meeoo unakwe, “Soo Te Naa nuga tubetse Naa.” Soo Te Pabe'e ka Te Naa-wa'ne'yoosoo mee nanetammadu. ");
INSERT INTO paoNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Soo Te Pabe'e mee mu netamma, “Nu kaaheno mu tuukwekwu. Nu ka E Naa tunetammana mayoho. Nu gi nugasoo manena suu'mu mayoho. ");
INSERT INTO paoNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Soo E Naa ka unu e soobedyana, ka hemma how tu yugwena e tzapoonnekute. Saa'a E Naa nanabesowsoo e tzapoonnekukwu. Nu yise punno'o mumme ooka tzapoonekukwu. O'no yise mu tunaka'oedyukudu meeoo, ‘Uune! Soo Te Naa tubetse besa'yoo.’ ");
INSERT INTO paoNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Soo E Naa puu mu numu mu ya'ekwikoo mayodakwu, nu punno'o gwetzoibu mu numu meeoo e soobedyana sootuhikwu. ");
INSERT INTO paoNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Soo E Naa gi ka mu numu saa'a nemadabuekwu, oosoo nu-tamme oo tzamunapu. ");
INSERT INTO paoNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Soo E Naa no'obatusoo numu nu-tooha manekwuna soogwa'e. Tooe haga tooe nuka gi heesoobedyadu, ka E Naa tookwa gi heesoobedyadu. ");
INSERT INTO paoNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Nu kaaheno mu tuukwekwu tooe haga tooe e unnena naka'oedyukudu, ka E Naa naka'oedyukudooa tuwazoo, umuoo ooosapa gwetzoibu nasootuhikwu. Umuoo tunaka'oedyukudu suda tumaduguna, soo Te Naa mooasoo soomu'wa, umuoo gi numu-no paba nanehanekwu, ka mooasoo Te Naa besa podo meana. ");
INSERT INTO paoNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Nu kaaheno mu tuukwekwu. Nu-matoo nanesootuhidu, tooe tuipu pana, saa'a ka e yadooase tu tutui-kwi'yoona yosuse, ka tunaka'oedyukuna, umuoo ka ooosapa gwetzoibu gi mobegwa-gakoo nasootuhikwu. ");
INSERT INTO paoNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Soo E Naa ka gwetzoibu-ma mu numu sootuhikwudu. Nu punno'o ooosoo. ");
INSERT INTO paoNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Soo E Naa ka mu numu tu nemadabuekwuna nu-matoo nemawuni, ooonne'yoona nu ka mu numu nemadabuekwu, nu ka Mu Pabe'ena. ");
INSERT INTO paoNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","29","Mu sakwa ekow naka'oedyuku. Pudusoo no'yoona mu tuipu numu yosukwu, ka e nakase, ka pumme e ba'e. Soo numu besa tumadugudu, besa nasootuhikwu, ka ooosapa gi moobegwaga nagwetzoidu. Umu suda tumadugudu, punno'o soo nanasuda mu tumaduguna umuoo-matoosoo kodyukwu. Umu suda sokwamana puusoo nasootuaganekwu. ");
INSERT INTO paoNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","O'no nu ka E Naa nuka tunetamma-kwa'nesoo numu paba nehanekwu. Nu besa numu nehanekwu, E Naa pooha-toohakwi nu numu nehanekwu nu gi nuusu'mu numu nehanekwu. ");
INSERT INTO paoNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Ka nuusoo nakwitu e nanekwaha mu gi hownnekoo e naka'oedyuku-wa'ne'yoo. ");
INSERT INTO paoNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Pana soo E Naa yise nu-witu wahana, o'no yise mu sakwa oo naka'oedyukute. Nu oo sopedakwatoo ka Te Naa nanekwahana oosoo kaaheno tuukwe. ");
INSERT INTO paoNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Mu mooasoo mu numu tayapu ka John nu-witu tubengakwudu. Soo John kaaheno mu tuukwepu. ");
INSERT INTO paoNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Mu numu yise ka John unnena soogwa'e. Nu oo sopedakwatoo ka mooasoo togesapa tuukwena. Nu mu nemayukute ka John nu-witu wahapu, o'no yise mu punno'o e naka'oedyukuse namagwetzoikwu. ");
INSERT INTO paoNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Soo John ka Te Naa Besa Po mu tzaponnekute, mu gi haa'noto besa sokwamapunne. ");
INSERT INTO paoNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Soo John unnepu ka mu numu nu-witu sopedakwatoo tummatzi. Ka nanabesa e tumadipu E Naa nuka tunetammakuna, mumme e tzapoonneku o'no mu numu oo sopedakwatoo soo Te Naa yaa mu-matoo e taya. ");
INSERT INTO paoNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Mu gi ka Te Naa nakana, gi tuwazoo oo poonne. Soo Te Naa nu-witu wahase, o'no yise yaatoo e taya. ");
INSERT INTO paoNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Mu gi ka Te Naa unnena naka'oedyukute mu ka gi oo naka'oedyukuna mumme oo tunetammakuna. ");
INSERT INTO paoNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Mu ka Te Naa unnepu nease numme namagwetzoikwu mee mu sokwamana. Pana nu-witu mu ne'a, ooonne'yoona mu sakwa e naka'oedyukuse mu namagwetzoi. ");
INSERT INTO paoNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Pana mu gi nu-matoo kemma, o'no nu gi ka gwetzoibu-ma mu sootuhi-wa'ne'yoo. ");
INSERT INTO paoNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Nu gi ka mu numu besa nu-witu tuukwedu wate pana ");
INSERT INTO paoNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","nu ka nuusoo oo sopedakwadoona, mu tookwa gi ka Te Naa besa soobedya. ");
INSERT INTO paoNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Tooe soo Te Naa mu-matoo e ta'yase sapa, mu gi e naka'oedyukute. Ka kumma'akoosoo atasoo numu tunedyooe petuse, mu oo naka'oedyukute, tooe Te Naa gi ooka ta'ya sapa. ");
INSERT INTO paoNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Mu ka mu numu mu besa'yoo mee mumme mu netammana besa soobedya, pana ka Te Naa meeoo unnena gi nakaheesoobedya. Mu gi hannano'o e naka'oedyuku-wa'ne'yoo. ");
INSERT INTO paoNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Soo Moses mu magwetzoidu tooe mu magwetzoi mee mu tusooyugwe sapa. Ka o'nosoo soo Moses te namooatupu ka Te Naa unnepu te tuukwe'e. Soo Moses ka suda mu tumaduguna ka Te Naa tuukwekwu. ");
INSERT INTO paoNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Tooe haga tooe ka Moses unnepu naka'oedyukudu nuka naka'oedyukukwu tuwazoo, soo Moses ka e manekwuna botuguse. ");
INSERT INTO paoNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Mu ka gi Moses tubotuguna naka'oedyukuna, mu tookwa nuka gi naka'oedyukute. ");
INSERT INTO paoNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","4","Saa'a ka tamano tu manegese soo Te Pabe'e ka numme tunakatzimodu-no, ka banunadu Galilee mee naneadu natsemangega. Numme ka giba-matoo poyase, oona aata'a. Umu ka mu tuoegoedu oo mabesakute oo poonnese ewa'yoo numu oo nageka. Soo Te Pabe'e ka pukwi'yoona tu kemmapu-witu wesase, ewahoo numu tu nakwi kemma mu poonne. ");
INSERT INTO paoNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","6","Soo Te Pabe'e tu manekwuna sopedakwatoona, ha'yoo saa'a soo Philip unnedooa mee soonammena, ka Philip mee tubenga, “Hanoko nadukadu tamme tumuse, noko umu numu makakwu?” ");
INSERT INTO paoNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Soo Philip oo nanekwegease meeoo oo netamma, “Soo nana tooe hemma tooe how yugwe, pumme tukapu puma tu tumuna suu'mu hee-ga'yoo, pana, oosoo gi toge'yoo, ka mu ewow numu makakwuse, ka tukapu ewa nanenaga.” ");
INSERT INTO paoNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Sumu'yoo punno'o ka Te Pabe'e nakatzimodu-matu Andrew mee naneadu mee unakwe, ");
INSERT INTO paoNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Esoo naatse manegeoo tukaba-ga'yoo, waahoo tutukutsekoo pakwe noko. Nagutza huutse'yoo, gi tamme no'oko mu numu maka-wa'ne'yoo.” ");
INSERT INTO paoNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Soo Te Pabe'e meeoo, “Ka mu numu ka pooega-kooba aata tuungu.” ");
INSERT INTO paoNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Soo Te Pabe'e yise ka mu manegeoo tutukutsekoo tukaba hemmahoose, ka Te Naa-matoo nanesootuhikooha. Ka numme pumme nakatzimodu yise hemehoose, noko mu numu aatadu ne maka tuungu, ka tutugutsekoo pakwe ooosoo tuwazoo ooosoo yugwe. ");
INSERT INTO paoNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Numu no'yoona togekoo yise tukahoo, ka noko numu wutzu'mese, soo Te Pabe'e numme tunakatzimodu mee netamma, “Noko ka tukapu nagupenidu masumudoo. Gi ka tukapu nahadyugwepana.” ");
INSERT INTO paoNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","“Numme sumumano wahamatsebooekudu (12) kawona kaanoku, ka tukapu nagupeni-ma, o soo manege'yoo tutukutse'yoo tukaba.” ");
INSERT INTO paoNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Mu numu ka Te Pabe'e besa tumadabuehoose, oo poonnese mee nananetamma, “Yow esoo Te Pabe'e Te Naa nayadooawabe. Wuna'me tamme ka Te Naa nakawutooepunne, ka yaa teepu-koobatoo ka Te Pabe'e oo tayakwuse.” ");
INSERT INTO paoNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Soo Te Pabe'e oo sopedakwadoo, ka mu numu-kooba katudu oo nemayugwekwuse, ooonne'yoona mu ma'wukase puu suu'mu oona ka giba-matoo meahoo. ");
INSERT INTO paoNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Ka yongona tu manepetuse numme oo nakatzimodu ka banunadu-kwitoosoo kodyuka. ");
INSERT INTO paoNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Ka tu toganokase sapa, soo Te Pabe'e gisoo numme-baa kodyu petu. Numme yise ka sake-wi kuase, ka Capernaum-witoo natsemangega. ");
INSERT INTO paoNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Unu hukwa petuse, soo baa unu bayutsungakooha. ");
INSERT INTO paoNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Numme banamoo-kwitoo natsemangega, o ne manikese numme ka Te Pabe'e poonne ka baa-koobakwi, oo kemmano'o ka sake tzage'e oo manikese numme sui. ");
INSERT INTO paoNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Soo Te Pabe'e mee ne netamma, “Nu yow, gi suipana.” ");
INSERT INTO paoNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Numme yise ka sake-wi oo netzatsebooase yabesoo ka bakumana petuga, Capernaum tzage'e. ");
INSERT INTO paoNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Oogow awamooa mu numu ka banunadu oowenapa'yoona mee nananetamma, “Soo Te Pabe'e umu pumme nakatzimodu-no sumuoo sake-ga'yoo. Ka togano tamme mu poonne ka mu tunakatzimodu ka sake-wi mu mea'ase. Soo Te Pabe'e gi umu-no.” ");
INSERT INTO paoNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Kukumma'yoosoo sake punno'o o ka Tiberias mee naneadu-wi'yoona kemmadu, ka oona etze'e Te Pabe'e pukwi'yoona nanesootuhina, mu numu pukwikoo oo makapu tzage'e petugadyakwe. ");
INSERT INTO paoNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","25","No'yoona mu numu oo poonne soo Te Pabe'e umu pumme nakatzimodu-no gi o, ewa'yoo numu yise ka sake-wi kuase ka Capernaum-witoo natzemangekase, ka Te Pabe'e watega. Umu ka Te Pabe'e mayuse meeoo oo tubenga, “Hannano u natsemangeke?” ");
INSERT INTO paoNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Soo Te Pabe'e mu numu ewana nanekwegea, “Nu togesapa mu tuukwe. Mu numu ewana ka tseako'ena suu'mu e wategena, ka tukapu suu'mu soogwina. Gi umu ka nanabesa e pooha manena poonnese e wate. ");
INSERT INTO paoNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","28","Gi ka nasoo'awunudu paba sooyugwepana, mu sakwa ka tukapu pumme numu nakugwetzoinnummena paba sooyugwe. Soo Te Naa nuka pooha-maka. Nu ookow tukapu puma mu nakugwetzoinnummena mu sootuhikwu.” Umu numu ewana yise oo tubenga, “Hownnekoo yise numme ka Te Naa nakabetseakwu?” ");
INSERT INTO paoNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Soo Te Pabe'e mu nanekwegea, “Nuka naka'oedyuku mee'e soo Te Naa unnena yaatoo e taya, o'no mu oo nakabetseakwu.” ");
INSERT INTO paoNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Umu numu yise meeoo oo netamma, “Sumu tuwazoo besa u tumadina ne tzapoonneku, o'no numme u naka'oedyukukwu. ");
INSERT INTO paoNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","O'nosoo soo Te Naa puu umu te nanamooatupu tukaba makamena. Soo Te Naa unnepu mee nabotugu, ‘Te Naa pa'anakwana tukaba puma mu nakugwetzoinnummena mu maka, umu yise oo tuka.’ ” ");
INSERT INTO paoNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Soo Te Pabe'e mee mu netamma, “Nu togesapa mu tuukwekwu, soo Moses gi ka mu nanamooatupu ka tukaba puma mu nakugwetzoinnumme maka. Pana meno'o soo Te Naa ka tukaba pummetusoo puma mu nakugwetzoinnummena-ma mu sootuha'e. ");
INSERT INTO paoNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Nu yow soo tukaba Te Naa-nakwana kemmadu. Soo Te Naa ekow tukaba-ma mu sootuhikwu, nu ka Te Naa-nakwana kemmapu, puma mu namagwetzoikwuna.” ");
INSERT INTO paoNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Umu numu yise mee ka Te Pabe'e netamma, “Meno'o manakwana u sakwa ooosapa 'yoonnekoo tukaba-ma ne sootuhi.” ");
INSERT INTO paoNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Soo Te Pabe'e yise mee mu netamma, “Nu yow soo tukaba mu sootuhikwudu ooosapa puma mu gwetzoimokwuna. Soo numu nuka naka'oedyukudu gi kumma'akoosoo tooe hownnekoo tukapu sookwi-wa'ne'yoo. Soo numu nuka naka'oedyukudu gi puudyi-wa'ne'yoo ka nuka nanetzakwiya'ena. ");
INSERT INTO paoNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Pana mumme e tuukwe-kwa'nesoo, mu ka nanabesa e tuyugwena poonnepana mu gi e nakabetsea. ");
INSERT INTO paoNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","No'yoona umu Te Naa tutzeana, nuka naka'oedyukute. Nu yise gi mu tsasoopedya-wa'ne'yoo. ");
INSERT INTO paoNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Nu ka Te Naa-baa'yoona kemma, nuka oo tunetammakuna mayohokwuse, gi nuusoo meeoo tusooyugwena. ");
INSERT INTO paoNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Soo Te Naa ka umu pumme naka'oedyukudu tuikwuna gi petzabena. Nu saa'a ka yaa teepu-koobasoo kodyu petuse, no'oko umuoo nuka naka'oedyukudu, mu tuipu tuwazoo mayosudooa. ");
INSERT INTO paoNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Soo Te Naa no'obatusoo numu nuka naka'oedyukuna, ooosapa gwetzoimokwuna soogwidu. Nu ka kodyu petuse umuoo tuipu mayosukwu.” ");
INSERT INTO paoNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","42","Umu Jew numu nanesootuhidu, yise ka Te Pabe'e nanetzamekute ka Te Pabe'e meeoo unakwe, “Nu yow ka tukapu-wa'ne'yoo numu puma nakugwetzoinnummena, Te Naa-baa'yoona kemmadu.” Umu Jew numu nanesootuhidu yise ka Te Pabe'e meeoo, “U, Ne Naa-witu esaya'e. U sukwe Jesus, ka Joseph tooa. Numme ka u naanapua'amu sopedakwatoo.” ");
INSERT INTO paoNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Soo Te Pabe'e yise mee mu netamma, “Gi e nanetzamekupana. ");
INSERT INTO paoNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Gi mu numu puusoo e naka'oedyuku-wa'ne'yoo. Soo Te Naa mu numu sootuhidyina umu nuka suu'mu naka'oedyukudu Te Naa doodooamu manekekwu. Nu ka petuse saa'a umu nuka nagemodu, mayosukwu, tooe mu tuipu sapa. ");
INSERT INTO paoNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Soo Te Naa yadooawabe o'nosoo mee tubotugu, ‘Soo Te Naa saa'a no'oko numu tunedyooedooa.’ Tooe haga tooe numu ka Te Naa unnena nakana, yise oo naka'oedyukudu, saa'a nu-matoo kemmadooa. ");
INSERT INTO paoNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Gi haga ka Te Naa poonnedu, nu suu'mu ka Te Naa poonne ka oo-baa'yoona kemmapuna. ");
INSERT INTO paoNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Nu togesapa mu tuukwekwu, no'yoona mu tunaka'oedyukudu ooosapa gwetzoimokwu. ");
INSERT INTO paoNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Nu yow soo tukapu-wa'ne'yoo puma numu nakugwetzoinnummena, ooosapa numu puma gwetzoimokwuna. ");
INSERT INTO paoNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Umu te nanamooatupu puu, ka sukwe nadukadu-ma namagwetzoimo'o, ka Te Naa pumme makana. Soo tukapu sukwe nawutzu'me, gi numu tubetse magwetzoa'e. ");
INSERT INTO paoNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","51","Nu yise yow soo puma numu tubetse gwetzoina tukapu-wa'ne'yoo, nu ka Te Naa-manakwana kemmadu. Esoo tukapu nugasoo tookoo-wa'ne'yoo, tooe haga tooe ka nuka tookoo tukase, ooosapa gi mobegwa-gakoo gwetzoimokwu. Nu ka mu-koobatoo nabatsase, o'no yise mu ooosapa gwetzoimokwu. Nu yaahoo soo tukapu numu puma nakugwetzoinnumme, nu puma mu gwetzoikwuna.” ");
INSERT INTO paoNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Mu Jew numu puusoo nananepetukukooha mee nana'unnena, “Ha'oo haa'a puusoo tu tookoo-matu tzapookana te makakwu, tamme pute yise oo tukakwu?” ");
INSERT INTO paoNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","54","Soo Te Pabe'e yise mee mu netamma, “Nu kaaheno mu tuukwe, nu yow mu Pabe'e. Tooe haga tooe nuka naka'oedyukudu ooosapa nu-no'yookwu. Nu ka tukapu numu puma nakugwetzoinnummekwuna. Soo e puupe ka baa mu hebena, puma mu namagwetzoina. Soo tooe haga tooe soogwetzoidu nu-ma suu'mu gwetzoikwu. Nu ka kodyu petuse mu tuiputoo'e saa'a namayosudooa. ");
INSERT INTO paoNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Soo e tookoo tubetse tukapu-wa'ne'yoo, yise e puupe punno'o tubetse baa-wa'ne'yoo. Nu-mamma ooosapa numu gwetzoimokwu. ");
INSERT INTO paoNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Tooe haga tooe ka e tookoo tukadu, yise ka e puupe hebedu ooosapa nu-no'yoopunne. ");
INSERT INTO paoNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Soo Te Naa yaatoo e tayase, nu yise ka Te Naa pooha-toohakwi mu-baa gwetzoinnumme. Tooe haga tooe ka e naka'oedyukuna, nu e pooha-ma mu sootuhikwu, o'no yise mu ooosapa gi mobegwa-gakoo gwetzoimokwu. ");
INSERT INTO paoNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Nu yow oo soo tukapu, puma numu nakugwetzoinnummekwuna, ka Te Naa-manakwana kemmadu. Tooe haga tooe nu-no'yoopunnedu ooosapa gwetzoinnummekwu. Soo tukapu te nanamooatupu pumatu tukapu, gi haa'noto numu magwetzoidu. Pana nu yow gwetzoibu mu sootuhikwudu.” ");
INSERT INTO paoNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Soo Te Pabe'e, meeoo mu numu netammadyakwe tooesoo ka nanesootuhi nobe-wi'yoona, ka Capernaum-wi'yoona. ");
INSERT INTO paoNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Ewa'yoo numu ka Te Pabe'e nakapunne pana gi oo nakatugu yise mee nananetamma, “Esoo nana tamme tunedyooena unusoo namanena nanaka'oedyukukwu.” ");
INSERT INTO paoNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Soo Te Pabe'e oo sopedakwatoo umu gi oo nakasopedakwadoo, ka oo unnewununa. Soo Te Pabe'e meeoo, “Mu sakwa gi nasootookepana, ka meeoo mumme e netamma. ");
INSERT INTO paoNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Mu sakwa sumuna gi oo naka'oedyuku tooe e poonnepana, ka Te Naa-matoosoo e koyukase. ");
INSERT INTO paoNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Mu numu gi puusoo namagwetzoi-wa'ne'yoo. Soo Te Naa-suu'mu mu magwetzoikwu. Soo nuga unnepu putoogoo ka Te Naa Besa Pooha mu naka'oedyukuna suu'mu mu sootuhikwu, o'no yise mu ooosapa gwetzoimokwu. ");
INSERT INTO paoNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Pana susumudu mu-matu gi e naka'oedyukute.” ");
INSERT INTO paoNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Soo Te Pabe'e yise mee mu netamma, “Nu mooasoo mu tuukwepu, soo numu gi puusoo nama e naka'oedyuku-wa'ne'yoo. Soo E Naa mee e netamma, ‘Mumme nu-kwi tunaka'oedyuku mayugwe,’ ” mee. ");
INSERT INTO paoNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Ewa'yoo numu gi oo naka'oedyukuna yise tu nonobe-witoo kodyuka. ");
INSERT INTO paoNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Soo Te Pabe'e yise numme sumumano wahamatsebooekudu (12) pumme nakatzimodu mee tubengu, “Mu haa'a punno'o e nasoomenakwu?” ");
INSERT INTO paoNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Soo Simon Peter yise ka Te Pabe'e nekwegea, “Numme ooosapa u-no'yookwudu. U ooosapa kaaheno ne tunedyooennumme. Numme ka gwetzoibu besa nakasoobedya. ");
INSERT INTO paoNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Numme u naka'oedyukuna, oo nakasopedakwatoo u yow Ne Tubetse Pabe'e.” ");
INSERT INTO paoNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Soo Te Pabe'e yise mee ne netamma, “Nu mumme sumumano wahamatsebooekudu (12) netutzea. Pana sumu'yoo mu-nagatu ooosapa gi nu-no'yoopunne.” ");
INSERT INTO paoNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Ka nana Judas Iscariot mee naneadu soo Te Pabe'e netammana meeoo. Tooe soo Judas sumumano wahamatsebooekudu (12) tunakatzimodu-nagatu pana soo Judas ka saa'a umu Te Pabe'e ooowemota mani, ka umu wohonedu-tamme mane, umuoo ka Te Pabe'e batzakwu mee tunetammana. ");
INSERT INTO paoNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Saa'a soo Te Pabe'e no'oko ka teepu Galilee mee naneadu-koobakwi numu tunedyooennumme. Soo Te Pabe'e ka teepu Judea mee naneadu-kwitoo gi me'a, mu Jew moohedu oonatuoo pumme nehooawi, pumme mu nepatza. ");
INSERT INTO paoNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Mu Jew numu nanesootuhi ewa tukakwuna tzage'e manegena, o'no umu numu sumuyakwe, nanasusu'mu tatza nobe-kwi nobegana, ka Te Naa-matoo nanesootuha'e ewa'yoo yise nasootuhiyakwe. ");
INSERT INTO paoNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","5","Umu Te Pabe'e wanga'amu gi oo oedyukute ka tu pabe'e. Umu oo wohonena mee oo netamma, “U sakwa Judea-witoo mea. U pooha tumadipe mu tunaka'oedyukudu oetuooo tzapoonnekukwu. U ka pooha-ga'yoo mee naneyugwena, gi oo nekwatzetugupana. U ka nanabesa tumadi mee unnena u sakwa no'oko numu tzapoonneku.” ");
INSERT INTO paoNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Soo Te Pabe'e mee mu nanekwegea, “Nu gi o mea-wa'ne manepunne, mu yise tooe hannano tooe mesoo mea. ");
INSERT INTO paoNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Nu ka mu numu suda tumadugu mu tuukwe'e, ooonne'yoona umu yise gi e petzape, pana umu mumme gi nekwoho'ne. ");
INSERT INTO paoNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Nu gi meno'o mu-no mea-wa'ne manepunne.” ");
INSERT INTO paoNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","10","Ka mu tu wanga'amu mease, soo Te Pabe'e punno'o huu tabeno ka Galilee-wisoo, saa'a puu suu'mu watze mea. ");
INSERT INTO paoNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Mu Jew numu moohedu ka mu numu-naga-kwitu ka Te Pabe'e too'e wate. Ewow numu too'e tubenga, “Hano soo Jesus?” ");
INSERT INTO paoNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Ka Te Pabe'e-witu ewa'yoo numu nanatuukwe. Susumudu umu-matu meeoo, “Soo Jesus besa'yoo nana,” pana susumudu punno'o meeoo, “Soo Jesus numu nemooagadu.” ");
INSERT INTO paoNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Mu numu ka Te Pabe'e-no'yoopunnedu ka mu Jew numu moohedu-ma suina, ka Te Pabe'e Jesus-witu watze nanatuukwe. ");
INSERT INTO paoNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Ka mu Jew numu pahe tabeno nanesootuhi ewa tuka-kwi manepetuse, soo Te Pabe'e ka pabow nanesootuhi nobe-kwi petuse yise nanesootuhibu-witu mu numu tuukwe'e. ");
INSERT INTO paoNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Mu numu mee nanatubenga, “Hownnekoo esoo nana no'okosoo hemma sopedakwatoo? Esoo gi hannano'o nanesootuhibu-witu natunedyooepu-ga'yoo.” ");
INSERT INTO paoNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Soo Te Pabe'e yise meeoo, “Nu ka Te Naa unnena mu tunedyooe. Nu gi nugasoo tusooyugwena mu tunedyoo'e. ");
INSERT INTO paoNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Tooe haga tooe ka E Naa nakabetseadu oo sopedakwadookwu oo naka'oedyukukwu, ka E Naa unnepu e waha. ");
INSERT INTO paoNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Soo tooe haga tooe pummesoo tusooyugwena wahakwu, besa pummesoo nanemadabuewununa soogwa'epunnedu. Nu ka toge kaahenotu E Naa unnepu mu tunedyooe, o'no mu Te Naa-matoo nanesootuhikwu. Nu togesapa mu tuukwe'e, nu gi esaya'e. ");
INSERT INTO paoNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Mu puu ka Moses putoogoo tumayohomeana naka'oedyukudu mee naneyugwe, pana mu puu gi oo nakabetse'a. Mu ka Moses nakabetseana, how manena mu e batsa soogwa'e?” ");
INSERT INTO paoNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Mu numu mee oo netamma, “Soo tsoapa haa'a u ma'emukwa? Gi haga u batsa-soogwa'e.” ");
INSERT INTO paoNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Soo Te Pabe'e yise mee mu netamma, “Suta'yoo nana mee mu e netamma, ka nanesootuhi tabeno numu e mabesakukena. ");
INSERT INTO paoNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","O'nosoo soo Moses ka mu nanamooatupusoo tumayohope mu tunedyoo'e, ooona'yoona numu kootze na'oonnakwitu natsekea, umu yise Jew numu maneyakwe. Mu nanamooatupu o'nosoo ka Moses-kobenasoo gwetzoimodu, oo ka tu doodooamu mooe yugwe. ");
INSERT INTO paoNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Mu puu ka Moses nakabetseana ka nanesootuhi tabeno sapa ka mu doodooamu oo yugweyakwe. Ooonne'yoona nu ka nanesootuhi tabeno sapa ka mu doodooamu oo yugweyakwe. Ooonne'yoona nu ka nanesootuhi tabeno ka nana mabesaku ");
INSERT INTO paoNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","mu sakwa gi e sutakupana, gi e nesootzemapana.” ");
INSERT INTO paoNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Susumudu mu numu-matu mee nananetamma, “Yaa esoo nana. Mu Jew moohedu batsayagana. ");
INSERT INTO paoNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Soo Jesus no'oko ne-kobena'yoona yadooadyakwe. Hownne'yoonagina mu numu moohedu a tsasoopedya? Te moohedu ka Te Pabe'e sumuna naka'oedyukute, ooonne'yoona oo tsasoopedya.” ");
INSERT INTO paoNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Susumudu punno'o meeoo, “Mana numme pukwi'yoona a kemmana sopedakwadoo pana, o'nosoo soo Te Naa yadooawabe meeoo tubotugu. ‘Gi haga pukwi'yoona oo kemmana soopedakootookwu.’ Numme ka nana pukwi'yoona kemmana sopedakwatoo ooonne'yoona numme meeoo oosoo tookwa gi Te Pabe'e-matu.” ");
INSERT INTO paoNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","29","Soo Te Pabe'e ka pabow nanesootuhi nobe-kumaba'yoona ka Te Naa Besa Pooha-toohakwi mee mu netamma, “Mu meeoo sokwama, mu ka Te Pabe'e sopedakwatoo mee, pana mu ka pukwi'yoona oo kemmana, tuwazoo gi sopedakwadoo. Mu gi ka E Naa yaatoo nuka tayadu nakasopedakwatoo, oosoo Nuga Naa, nu oo-baa'yoona kemmahoo. Pana E Naa unnena nu kaaheno mu tuukwe'e, nu gi nugasoo unnena wahadu.” ");
INSERT INTO paoNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Mu Jew numu tutunehanedu ka Te Pabe'e sookwutuma pana gi oo-toogoo manakwe, ka gisoo ka Te Pabe'e nabatsakwi oo manakwe. ");
INSERT INTO paoNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Ewa'yoo numu ka Te Pabe'e-noyoopunnedu mee nana'unakwe, “Esoo nana no'okosoo hemma nanabesa pooha mada'e, ooonne'yoona esoo nana tookwa Te Pabe'e. Soo Te Pabe'e ka petuse, oosoo no'okosoo hemma nanabesa pooha madikwu.” ");
INSERT INTO paoNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Mu Jew numu tutunehanedu ka mu numu unnena nakana nuusoogweda, ka mu tuukwutumadu ka Te Pabe'e wutuma tuungu, pana umu gi oo wutuma. ");
INSERT INTO paoNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Soo Te Pabe'e yise ka mu numu mee netamma, “Nu gi haa'noto mu-baa'yoopunnekwu. Pudusoo nu yise saa'a ka Te Naa-matoosoo kodyukakwu. ");
INSERT INTO paoNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Ooonne'yoona mu saa'a, unu e too'e soogwi pana gi e mayu-wa'ne'yoo. Mu nu-no too'e soogwedapana gi mu hownnekoo nu-noyoopunnekwu.” ");
INSERT INTO paoNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Mu numu yise mee nananetamma, “Hanogina oosoo meakwuse tamme gi oo nageka-wa'ne'yoo? Oosooga sumuna ka mu Jew numu tooetoo ka mu gi Jew numu-baa manekwuse. ");
INSERT INTO paoNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Hayoo unnena oosoo ka meeoo, ‘Mu e too'e soogwi pana gi e mayu-wa'ne'yoo, mu too gi e nageka-wa'ne'yoo, ka e kodyukase?’ ” ");
INSERT INTO paoNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Ka mu Jew numu ewa tuka nanesootuhi tabeno namamakwuhooga'a, soo Te Pabe'e wunuse ka Te Naa Besa Pooha-punagakoo mee unakwe, “Tooe haga tooe wuna'me tu gwetzoinnummekwuna gi mobegwa-gakoo soogwidu nu-toohatoo nasoomawunise, nasootuhikwu. ");
INSERT INTO paoNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Soo Te Naa unnepu mee na'unakwe oosoo, ‘Tooe haga tooe nuka naka'oedyukudu patzona-wa'ne gi pasa-wa'ne'yoo, ooosapa gi mobegwa-gakoo gwetzoibu nasootuhikwu.’ ” ");
INSERT INTO paoNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Soo Te Pabe'e ka Te Naa Besa Pooha ka mu tunaka'oedyukudu saa'a tusootuhi-kwitu te tuukwekwu. Soo Te Naa gisoo ka Tu Besa Pooha-matu-ma mu numu poohamaka, ka Te Pabe'e gisoo pubaatoo kodyu petuga'a.” ");
INSERT INTO paoNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Susumudu oo unnena nakase, mu numu-matu meeoo, “Oosoo tookwa Te Naa yadooawabe.” ");
INSERT INTO paoNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Mu susumudu punno'o mee, “Yow tookwa Te Pabe'e.” Umu-matu yise mee unakwe, “Oosoo tookwa gi Te Pabe'e, oosoo Galilee-wi'yoona kemmadu. Soo Te Pabe'e gi Galilee-wi'yoona kemmakwudu. ");
INSERT INTO paoNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Soo Te Naa unnepu meeoo, ‘Soo Te Pabe'e ka te namooatupu David ma'yoona suaketu. Oosoo ka Bethlehem mee naneadu-kwi'yoona kemmakwu, oosoo uga David pukwi'yoona kemmana.’ ” ");
INSERT INTO paoNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Mu numu yise nanapokihoo nana'atasoo tusooyugwegonnona. ");
INSERT INTO paoNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Mu susumudu numu ka Te Pabe'e nuusoogwetakugonno, pana gi haga yise oo wutuma. ");
INSERT INTO paoNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Mu tukwutumadu yise ka mu tutunehanedu-matoo kodyuka. Mu tutunehanedu ka mu tukwutumadu mee tubenga, “How manena mu gi ka Jesus wutuma?” ");
INSERT INTO paoNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Mu tukwutumadu meeoo mu nanekwegea, “Oosoo nanabesa unakwe, gi haga nana oo-wa'ne'yoo.” ");
INSERT INTO paoNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Mu tutunehanedu yise mee mu tukwutumadu netamma, “Mu haa'a punno'o oo naka'oedyukute? ");
INSERT INTO paoNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Numme tutunehanedu gi oo naka'oedyukute, numme mooasoo no'oko hemma sopedakwadoo, numu gi numme nemooaga-wa'ne'yoo. ");
INSERT INTO paoNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Mu gi tutusopedakwatoodu gi Te Naa unnena sopedakwadoo, mu tuma'emukwana umu-tamme kodyusoo.” ");
INSERT INTO paoNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Sumu'yoo umu-notu Nicodemus mee naneadu mee mu netamma, ");
INSERT INTO paoNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Oosoo meeoo nayadooa soo Te Naa unnepu, ‘Tamme sakwa ka nana-no mooe yadooase, ka ha'oo manekwuse oo sopedakwatoose, o'no tamme sumuna oo nehanese tamme oetu sopedakwadookwu, oosoo haa'a besa'yoo pute gi besa'yoo?’ ” ");
INSERT INTO paoNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Umu yise mee oo nanekwegea, “U punno'o umu Galilee-witu-kwa'ne yadooa-ka'nga. U sakwa ka Te Naa unnepu nease oo nakasopedakwadoo, soo Te Naa yadooawabe gi Galilee-wi'yoona kemmakwudu.” ");
INSERT INTO paoNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Ka Te Pabe'e tunemamakwuse, mu numu tu nonobe-kwitoosoo kodyudyipunne. ");
INSERT INTO paoNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Soo Te Pabe'e ka giba Olive mee naneadu-matoo kodyuka, oonow tooikwu mee soonammena. ");
INSERT INTO paoNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Oogow moo'a awamooasoo tu tabuagena, soo Te Pabe'e kodyuka, oona ka pabow nanesootuhi nobe-kobenatoosoo. Ewa'yoo numu oo nakadu oo-baa petudyipunne. Oonow katuna nanesootuhibu mu tunedyoo'e. ");
INSERT INTO paoNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Sumu'yoo mogo'ne mooasoo kooma-gapana kumma'akoosoo nana poota'ma. Mu nanesootuhibu numu tunedyooedu, ka mu Pharisee mee nananeadu-nagatu, ka mogo'ne poonnese ka Te Pabe'e-baa oo bi petuoo. ");
INSERT INTO paoNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Umu Jew nananesootuhidu mee ka Te Pabe'e netamma, “Numme eka mogo'ne kumma'akoosoo nana poota'ma a mayuhoo. ");
INSERT INTO paoNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Ka te tumayohope-wi soo Moses o'nosoo ka te nanamooatupu oo tuukwe-kwi, oosoo mee na'unakwe ka 'yoo manedu mogo'ne batsa. How tamme a yugwekwu?” ");
INSERT INTO paoNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Umu ka Te Pabe'e too'e nekusekuna, ka gi pumme oo nanekwagea umu oo nekwohone mee sokwamana. Soo Te Pabe'e natsekwu'ne katuhoose ka tu mamoogoo-ma, ka teepu-ma tubokooha. ");
INSERT INTO paoNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Mu nanesootuhibu numu tunedyooedu, ka Te Pabe'e ooosapa meeoo tubengadyakwe, “Yabe hayoo unne how sakwa tamme a ma'e?” ");
INSERT INTO paoNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Umu o suu'mu tubengadyakwe, soo Te Pabe'e yise, wunuoose mee mu netamma, “Unu tooe, tupe-ma oo tapagetahoo, oo ya'e-kwitoo tooe. Pana soo gi hannano'o tuma'emukwadu sakwa oo mooe tabe.” Soo Te Pabe'e yise natsekwu'ne katusesoo ka teepu-ma tutsebokoohasoo. ");
INSERT INTO paoNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Ka nasookwise mu nanesootuhibu numu tunedyooedu, ka mogo'ne meeoo netammadu, mu wakwa'etse mooe mea'a, yise mu tootooebetse umu benakwatoo punno'o mea'a. Ka mu petukwahookase, ");
INSERT INTO paoNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","soo Te Pabe'e wunuse ka mogo'ne meeoo tubenga, “Haga meno'o meeoo u netamma?” Soo mogo'ne meeoo ka Te Pabe'e nanekwegea, “Gi haga.” ");
INSERT INTO paoNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Soo Te Pabe'e meeoo ka mogo'ne netammasoo, “Nu punno'o gi. U nobe-kwitoosoo kodyuka. Yaa manakwana gi kumma'akoosoo nana poota'ma-pana.” ");
INSERT INTO paoNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Soo Te Pabe'e yise ka mu numu ka pabatsekoo nanesootuhi nobe-kumaba manepunnedu mee netamma, “Nu ka teepu-koobatu kootabedooakute, o'no mu numu ka Te Naa besa po poonnena oo nagenokwu. Mu numu nuka naka'oedyukudu gi togaba-wi'yookwu.” ");
INSERT INTO paoNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Mu Pharisee ka Te Pabe'e mee netamma, “U ka uusoo nanetammana esayidyakwe, ooonne'yoona numme yise gi u naka'oedyukute.” ");
INSERT INTO paoNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Soo Te Pabe'e yise meeoo, “Tooe nu nuusoo nanetamma pana, nu togesapa mu tuukwe'e. Nu ka pukwi'yoona e kemmana, yise ka pukwitoo e meakwuna mooasoo sopedakwadoo. Mu yise gi ekow nu-kwitu sopedakwatoo.” ");
INSERT INTO paoNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","16","Mu ka nuka nemadabuena gi togekoo tunemadabue, mu ka gi oo nakasopedakwadoona. Soo E Naa yaatoo nuka tayadu e tummatzikwu, nu yise kaaheno mu nemadabuekwu. Nu gi mu-kwa'ne'yoo, nu kaaheno mu tunemadabuekukwu. ");
INSERT INTO paoNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Soo te tumayohope meeoo, ‘Ka waahoo numu nawa'nesoo nanekwaha oosoo togesapa.’ ");
INSERT INTO paoNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Numme yise ka Te Naa-no waha'yoo ooonne'yoona nu yise kaaheno mu tuukwe.” ");
INSERT INTO paoNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Umu yise mee oo tubenga, “Haga yise u naa?” Soo Te Pabe'e mee mu nanekwegea, “Mu gi nu-kwitu sopedakwadoo, hownnekoosoo yise mu ka E Naa sopedakwadookwu?” ");
INSERT INTO paoNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Soo Te Pabe'e meeoo mu tunedyoo'e ka pabatsekoo nanesootuhi nobe-kobena'yoona, puu-kwikoo mu numu tumasumudoo tsage'yoona. Soo Te Pabe'e gi nakwutuma, ka gisoo oo nabatsa-kwi oo manakwe. ");
INSERT INTO paoNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Soo Te Pabe'e yise mu gi hemma heesoobedyadu mee netamma, “Ka pukwi'yoona e kemmapu-witoo e kodyuse, mu saa'a e tooe soogwikwu, pana mu gi e mayu-wa'ne'yoo. Suda mu tumadugu-kwisoo mu tuikwu. Mu gi nuga pukwitoo mea-kwitoo mea-wa'ne'yoo.” ");
INSERT INTO paoNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Mu Te Pabe'e gi heesoobedyadu, gi oo nakasoobedakwadoodu yise meeoo nananetamma, “Ha'oo manena meeoo unakwe? Puusoo haa'a nabatsakwuse?” ");
INSERT INTO paoNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Soo Te Pabe'e yise mee unakwe, “Mu ka sutakoo nakabetse'a, no'yoona mu numu ka teepu-koobatu moohedu punno'o ka sutakoo nakabetse'a. Pana nu ka Te Naa te pa'anakwatu nakabetse'a. ");
INSERT INTO paoNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Mu ka gi nuka naka'oedyukuna, mu ka togesoo suta'yoo numuna, tuikwu.” ");
INSERT INTO paoNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Umu yise oo tubenga, “How yise 'yoo u numme ata'yoosoo?” Soo Te Pabe'e yise meeoo mu netamma, “Nu ooosapa mu too'e tuukweno'o, pana mu gi e naka'oedyukute. ");
INSERT INTO paoNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Nu yise ka ewasoo suda mu tumadugu-kwitu mu mesoo tuukwe-wa'ne'yoo, pana nu gi. Soo E Naa'yatoo nuka tayadu, kaaheno mu nemadunagakwu. Nu no'oko mu tooe tuukwe'e, ka Te Naa nuka tunetammakuna.” ");
INSERT INTO paoNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Mu Jew numu moohedu gi oo nakasopedakwatoo, soo Te Naa ka Te Pabe'e-witu oo waha tuunguna, yaatoo oo taya. ");
INSERT INTO paoNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Soo Te Pabe'e mee unakwe, “Mu saa'a e nabatsase, susumudu mu-matu oo naka'oedyukukwu, nu mu Pabe'e. O'no mu oo sopedakwadookwu, nu gi nugasoo tusooyugwena mayohokwu, pana nu ka E Naa nuka tunetammakuna mu sukwe tuukwe'e. ");
INSERT INTO paoNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Soo E Naa yaatoo e tayase, ooosapa nu-no, gi e ma'wuka'a, nu ka ooosapa besa Te Naa nakabetseana.” ");
INSERT INTO paoNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Ka Te Pabe'e yadooadyakwe ewa'yoo numu oo naka'oedyuku manemena. ");
INSERT INTO paoNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Soo Te Pabe'e yise ka mu pudu tunaka'oedyukudu mee netamma, “Mu ka ooosapa o naka'oedyukuna nu mu doodooamu-gakoo. ");
INSERT INTO paoNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Mu yise ka kaahenotu sopedakwadookwu, gi mu numu ka suta-kwitoo namoohegakwu.” ");
INSERT INTO paoNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Umu yise meeoo, “Numme ka Abraham-ma'yoona suaketu. Ha'yoo u unnena meeoo unakwe tamme suta-kwitoo namoohegakwu?” ");
INSERT INTO paoNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Soo Te Pabe'e mee mu nanekwegea, “Nu kaaheno mu tuukwekwu. Soo tooe haga tooe nanasuda tu manena mayohodu ka sutakoo nakabetsea. ");
INSERT INTO paoNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Soo numu tummatziwabe, puu gi ka pumme nedyawedu nanumu. Pana soo numu nedyawedu dooa'a ooosapa nanumu nadatsungapunne. ");
INSERT INTO paoNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Nu Mu Pabe'e, nu ooosapa mu nanumu-gakwu, mu ka e naka'oedyukuna. Nu mu sootuhise, o'no mu gi suta-kwitoo namoohegakwu. ");
INSERT INTO paoNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Tooe mu Abraham-ma'yoona suakese sapa mu Te Naa dooamu mee nasokwama mu e batsa soogwa'e, mu ka gi e toge'yookuna. ");
INSERT INTO paoNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Nu ka Nuga Naa nuka tuukwena mu too'e tuukwe pana, mu ka suta-nakwana suakese, ooonne'yoona mu sutakoo nakabetsea.” ");
INSERT INTO paoNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Umu yise meeoo ka Te Pabe'e netamma, “Numme gi suta-nakwana suaketu, Abraham ne namooatupu.” Soo Te Pabe'e mee mu netamma, “Umu Abraham doodooamu ka Te Naa besa nakabetse'a Abraham-wa'nesoo. Mu gi Abraham doodooamu-wa'ne'yoona, gi tuwazoo Te Naa dooamu-wa'ne'yoo, ka gi Te Naa naka'oedyukuna. ");
INSERT INTO paoNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Mu yise e batsa soogwa'e tooe nu kaaheno mu tooe tuukwepana mu ka Te Naa nuka netamma-kwa'nesoo, soo te namooatupu Abraham gi mu-wa'ne'yoo. ");
INSERT INTO paoNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Mu ka oo manena kumma'akoosoo Naa-ga'yoo.” Umu mee ka Te Pabe'e netamma, “Numme gi kumma'akoosoo naa-ga'yoo. Numme sumuoosoo Naa-ga'yoo soo numu manumudoopu, ne tubetse Naa.” ");
INSERT INTO paoNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Soo Te Pabe'e yise mee mu netamma, “Mu ka Nuga Naa nenagana, mu sakwa unu e soobedya. Soo E Naa yaatoo e tayase, nu yise yow mu-baa petu. Gi nuusoo meeoo nasooyugwena. ");
INSERT INTO paoNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Mu gi e nakabetsea. Gi ka e una'wena nakapunne. ");
INSERT INTO paoNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Soo Suta'yoo, mu Naa, ooonne'yoona mu ookow nakabetse'a. Soo Suta'yoo ooosapa numu kadoo mayugwekena, ooosapa mu esaya'ekuna. ");
INSERT INTO paoNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Mu ka gi togekoo naka'oedyukute, ooonne'yoo mu gi e naka'oedyukute tooe kaaheno mumme e tuukwe'e sapa. ");
INSERT INTO paoNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","No'yoona mu e sopedakwadoo, nu ooosapa besa tumadugudu. Nu kaaheno mu tuukwepana mu gisoo e naka'oedyukute. ");
INSERT INTO paoNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Soo Te Naa doodooamu ooosapa oo nakabetse'a. Mu yise meeoo unnepana mu gi oo-no'yoopunne.” ");
INSERT INTO paoNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Mu Jew numu mee oo netamma, “U gi kaaheno numme-matu, u ka mu sutakoo numu-matu-kwa'ne'yoo. U tuma'emukwadu.” ");
INSERT INTO paoNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Soo Te Pabe'e mee mu netamma, “Nu gi tuma'emukwadu. Nu ka E Naa toge'yooku pana mu gi e toge'yookute, ooonne'yoona mu suda nu-kwitu waha. ");
INSERT INTO paoNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Nu gi nuusoo besa naneyugwena, soo Te Naa saa'a besa nu-kwitu waha. Soo Te Naa ka umu nu-kwitu esayidu nemadunagakwu. ");
INSERT INTO paoNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Nu kaaheno mu tuukwe tooe haga tooe e nakabetseadu gi ya'ekwu.” ");
INSERT INTO paoNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Mu Jew numu yise meeoo ka Te Pabe'e netamma, “Meno'o numme u sopedakwatoo u tuma'emukwadu. Soo te namooatupu Abraham puu ya'e, Te Naa nanayadooawabe punno'o no'yoona tuipu. U yise meeoo, tooe haga tooe e nakabetseadu gi ya'ekwu. ");
INSERT INTO paoNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","U haa'a ka Te namooatupu Abraham ooonakwa besa'yoo? Hownne'yoo, mee puu u uusoo nasooyugwe?” ");
INSERT INTO paoNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Soo Te Pabe'e mee mu nanekwegea, “Nu ka nuusoo nakwitu wahana, mu gi e naka'oedyukute. Pana soo nuga Naa, besow e poohamaka, ookow nuga netammana, ooonne'yoona mu numu nuka nesookwuga'e. Mu ka Te Naa-matoo nanesootuhidu mee nananeyugwedu. ");
INSERT INTO paoNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Pana mu gi ka E Naa sopedakwatoo, nu suu'mu ka E Naa sopedakwatoo. Nu gi esa'ya'e mu-kwa'nesoo, ooonne'yoona nu sakwa oetu mu tuukwe, ka Te Naa e sopedakwadoo-kwitu. ");
INSERT INTO paoNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Soo te namooatupu Abraham besa soonamme ka o'nosoo oo pooha poonnena ka yaa teepu-kooba e petukwuna.” ");
INSERT INTO paoNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Mu Jew numu moohedu meeoo oo netamma, “Soo Abraham tubetse o'nosoo ya'epu. U ka Abraham gi poonnedu. O'nosoo ume gisoo nadooa'adoo.” ");
INSERT INTO paoNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Soo Te Pabe'e yise mee mu netamma, “Nu oo-koobenasoo mooasoo gwetzoi, tubetse o'nosoo gisoo ka Abraham nadooa'adoo.” ");
INSERT INTO paoNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Umu yise tupe tzobakooha oo tatzagowkwu mee soogwamana. Pana soo Te Pabe'e mu manikwuna sopedakwadoo ka umu-baa'yoona yise ka pabow nanesootuhi nobe-wi'yoona watse meahoo. ");
INSERT INTO paoNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Soo nana gi tubootabuena nadooa'adoopu, oona po-kumaba katu. Soo Te Pabe'e umu pumme nakatzimodu-no oona meadabena oo poonne. ");
INSERT INTO paoNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Numme oo nakatzimodu ka Te Pabe'e mee tubenga, “Haga suda tumadugu-kwi esoo nana gi tubootabuena nadooa'adoopu, masoo nana haa'a puusoo suda tumaduguse, pute umu oo naanapua'amu?” ");
INSERT INTO paoNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Soo Te Pabe'e yise mee ne netamma, “Esoo nana gi tubootabuedu, suda oo tumaduguna gi oo-matoosoo kodyu, oo naanapua'amu suda tumaduguna gi oo dooa'a-matoo kodyu. O'nona eka gi tubootabuedu namabesakuse mu numu oo poonnese ka Te Naa nesookwuga'e. ");
INSERT INTO paoNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Tamme sakwa ka Te Naa nuka yaatoo tayadu nakabetsea. Pudusoo nu nabatsase gi mu-no'yookwu. ");
INSERT INTO paoNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Nu ka yaa teepu-kooba'yoopunnena ka mu numu tummatzina, umu ka Te Naa-witu nakasopedakwadookwu.” ");
INSERT INTO paoNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Soo Te Pabe'e yise ka teepu-koobatoo toohese ka tu huutsenoko ka pasakwabu mayuase, ka gi tubootabuedu nana popo'a-kooba oo matzabekuhoo. ");
INSERT INTO paoNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Soo Te Pabe'e yise meeoo oo netamma, “U sakwa meahoose ka patzona Siloam mee naneadu-kwi nabakomamitooa.” Soo gi tuboodabudu nana yise ka oonahoo nabakomamitooase, besa tubootabuena kodyu petuuoosoo. ");
INSERT INTO paoNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Mu numu uga, ka gi tubootabue oo poonnedu mee nana'unakwe, “Yow haa'a too'e, esoo nana uga oona po-kumaba katuna numu tumasumudoo tuunguyidu?” ");
INSERT INTO paoNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Susumudu numu meeoo nana'unakwe, “Aha mow oosoo nana.” Susumudu yise punno'o mee, “Gi esoo oosoo nana, oo-wa'nesoo sukwe tabuadu.” Soo nana yise mee unne, “Nu yow soo nana gi uga tubootabuedu.” ");
INSERT INTO paoNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Umu yise mee oo tubenga, “How manise u tubootabue mane?” ");
INSERT INTO paoNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Oosoo mee mu nanekwegea, “Sumu'yoo nana Jesus mee naneadu, pasagwabu e popo'a-kooba matzabekuse, yise ka patzona Siloam-witoo e bakomami tuungu. Nu ka bakomamitooase, besa tubootabue mani.” ");
INSERT INTO paoNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Umu yise meeoo oo tubengasoo, “Hano yise oosoo nana meahoo?” Oosoo uga gi tubootabuedu nana besa manena yise meeoo, “Nu gi oo sopedakwatoo.” ");
INSERT INTO paoNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Umu numu yise ka mu Jew nananesootuhidu numu Pharisee mee nananeadu-matoo ka nana bika. ");
INSERT INTO paoNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","15","Ka nanesootuhi tabeba-wi ka nana besa namabesakuse, mu Pharisee mee oo tubenga, “How manise u tubootabue mani?” Oosoo mee mu nanekwegea, “Soo Jesus tu huutsepu ka teepu noko pasagwabudoose e popo'a-kooba oo matzabekuhoose oo-koobatoo yise e bakomami tuunguse, nu yise bakomamitooase, yaatu poonne mani.” ");
INSERT INTO paoNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Susumudu mu Pharisee-matu mee unakwe, “Soo Jesus tookwa gi besa'hoo pooha-gana ka te nanesootuhi tabeba-wi numu mesoo mabesakute, masoo tookwa gi ka Te Naa-nakwana kemmadu.” Susumudu mu Pharisee-matu yise mee'e punno'o unakwe, “Ekow nana mow besa oo mayugwese oosoo tookwa Te Naa besa pooha hee-ga'yoo.” Umu yise oo-koobatoo nananepetukute. ");
INSERT INTO paoNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Umu yise, ka uga gi tubootabuedu nana mee tubenga, “Ha'yoo u ka nana ume mabesakudu-kwitu soobedya?” Oosoo mee mu nanekwegea, “Oosoo oo kaaheno Te Naa yadooawabe.” ");
INSERT INTO paoNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Mu Pharisee gi oo naka'oedyukute, ka nana uga gi tubootabuena. Umu yise oo naanapua'amu-witoo tuta'ya. ");
INSERT INTO paoNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Umu oo naanapua'amu nabi petuse, mu Pharisee mee, ka oo naanapua'amu tubenga, “Esoo haa'a mumme dooa? Yaa haa'a oosoo gi tubootabuena nadooa'adoodu? Ha'oo manese meno'o tubootabue mane?” ");
INSERT INTO paoNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","23","Mu Jew numu moohedu mooasoo mee tunetammapu, “Numme tooe haga tooe ka Jesus Te Pabe'e naka'oedyukudu ne Jew nanesootuhi nobe-kwikoo tayakwunihookwu.” Umu oo naanapua'amu ka mu Jew numu moohedu-ma suipunne, ka meeoo mu tunetamma. “Soo Jesus ne dooa mabesaku,” mee tu unnikwu-ma suipunne. Mu oo naanapua'amu mee mu nanengwegea, “Numme oo sopedakwadoo, esoo ne dooa oe manakwanasoo. Pana numme gi oo sopedakwatoo ka hownnekoo oo namabesakuse, ka ooka mabesakudu tuwazoo. Mooasoo masoo ewa tomopu, makowsoo tubenga.” ");
INSERT INTO paoNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Umu numu moohedu yise ka nana uga gi tubootabuedu nabatoosoo bihoo tuwazoo. Umu yise mee oo netamma, “U sakwa ka Te Naa-matoo nanesootuhi gi ka Jesus-matoo. Numme oo sopedakwatoo soo Jesus suda tumadugu.” ");
INSERT INTO paoNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Pana soo uga gi tubootabuedu meeoo mu nanekwegea, “Sumuna oosoo too'e suda tumadugudu, nu gi oo sopedakwadoo, pana nu oo sopedakwatoo, nu uga gi tubootabuedu, pana meno'o nu yaatu mesoo poonne.” ");
INSERT INTO paoNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Umu yise mee oo tubenga, “Ha'oo soo Jesus u sootunagase u yaatu mesoo poonne?” ");
INSERT INTO paoNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Oosoo mee mu nanekwegea, “Mooasoo nu mu tuukwe, pana mu gi e naka'oedyukute. Ha'oo manena mu ookowsoo e tubengayakwesoo? Mu haa'a punno'o ka Jesus nakatzimokwu mee sokwamana, mee sumu tutubengadyakwe?” ");
INSERT INTO paoNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Umu yise ka nana nakasagwa'ekuhoo yise meeoo oo netamma, “U ka sutakoo nana naka'oedyukuna meeoo unakwe. Pana numme puu ka Moses unnepu naka'oedyukute. ");
INSERT INTO paoNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Soo Moses yise uga, o'nosoo Te Naa yadooawabe. Numme ka Jesus gi Te Naa nayadooawabe mee oo unakwe sapa, gi oo naka'oedyukute.” ");
INSERT INTO paoNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","33","Soo nana yise mee mu nanekwegea, “Gi hannano'o hagaa 'yoonnekoo nana tunadooa'adoo-kwi manakwanasoo gi tubootabuedu mabesakudu. Soo Jesus ka gi tubootabuedu numu mesoo mabesakuna, oosoo kaaheno ka Te Naa ma'yoona kemmadu. Oosoo gi suta'yoo nana mee pumme netamma-wa'ne. Soo Jesus ka Te Naa nakabetseadu, ooonne'yoona oosoo ka Te Naa pooha-toohakwi numu mabesakute. Ooonne'yoona sakwa mu oo sopedakwadoo, soo Jesus, Te Naa yaatoo tutayana mee'e nu.” ");
INSERT INTO paoNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Mu Pharisee ka uga gi tubootabuedu nanekwegea, “U puu ka u nadooa'adoo-kwi manakwana tubetse suta'yoo. Gi hownnekoo u ne tunedyooe-wa'ne'yoo.” ");
INSERT INTO paoNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Soo Te Pabe'e ka oekoo ka nana natayakwunihoose oo naka, oo watega, soo Te Pabe'e ka oo mayuse mee oo netamma, “U haa'a ka Te Naa Tooa'a naka'oedyukute?” ");
INSERT INTO paoNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Soo nana yise mee ka Te Pabe'e nanekwegea, “Aha, nu ookow naka'oedyukute. Pana nu gi oo poonnedu, haga oosoo?” ");
INSERT INTO paoNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Soo Te Pabe'e Jesus yise meeoo, “Nu yow soo U Pabe'e Te Naa Tooa'a.” ");
INSERT INTO paoNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Soo nana yise mee unakwe, “Nu u naka'oedyukute.” Soo nana yise Te Pabe'e-matoo nanesootuhikooha. ");
INSERT INTO paoNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Soo Te Pabe'e mee unakwe, “Nu yaa teepu-kooba petu, ka umu gi Te Naa-witu nakasopedakwatoodu ka Te Naa pudu unnepu tunedyooegena, o'no saa'a umu besa oetu nakasopedakwadookwu. Susumudu mu-matu mooasoo oo nakasopedakwadoodu besa manepunne mee nasooyugwe pana, mu gi eka mumme e tunedyooena nakasopedakwadoo.” ");
INSERT INTO paoNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Mu Pharisee-matu ka Te Pabe'e meeoo unakwe oo naka. Umu yise ka Te Pabe'e meeoo netamma, “Numme gi ka Te Naa-witu nakasopedakwadoo, mee haa'a u unnena meeoo?” ");
INSERT INTO paoNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Soo Te Pabe'e mee mu nanekwegea, “Soo numu gi oo nakasopedakwadoodu, gi mu tuma'emukwana umu-matoosoo kodyu-wa'ne'yoo. Pana mu yise ka Te Naa-witu nakasopedakwadoo mee naneyugwedu soo mumme tuma'emukwana yise mu-matoosoo kodyukwu.” ");
INSERT INTO paoNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","2","Soo Te Pabe'e mee mu netamma, “Nu togesapa mu tuukwekwu. Soo tooe haga tooe ka seepu koodua natzakwona'adoo oe egeadu, oosoo kaaheno mu mabetseakwudu. Soo tooe haga tooe ka koodua-koobakwi oe tooe egeadu, tookwa gi toge manedu. ");
INSERT INTO paoNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","4","Soo tueya'edu ka umu mabetseadu sopedakwadoona, oosoo suu'mu oe natza'egeakwu. Soo seepu takonedu pummesoo seepu bihookakwu. Umu oo seepu yise, ka seepu koodua-wi'yoona kuowkase oo nagekakwu umu pumme takonedu tuapa nakasopedakwadoona. ");
INSERT INTO paoNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Pana umu seepu ka kumma'akoosoo tuapa nakahoose umu sukwe namamea'akwu.” ");
INSERT INTO paoNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Soo Te Pabe'e ka natugwenga makwuse, umu gi ka oo natugwengapu nakasopedakwadoo. ");
INSERT INTO paoNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","10","Soo Te Pabe'e yise meeoo tuwow, “Nu yow ka koodua natzakwona'a-wa'ne'yoo, sumuoosoo natzakwona'a-ga'yoo. Mu oo-toogoo oe egase nu ooosapa mu-kooba tueya'ekwu. Nu mu mabetseana, mu gi hemma namatuugekwu. Umu kukumma'a'yoosoo sumuna mooasoo nu-kobenasoo petugadu mee unnedu, ‘Nu mu magwetzoikwu.’ Umuoo esagoedu. Umuoo tuduhagetu-kwa'ne'yoosoo, umu nuka nagedu kadoo too'e mayugwedu. Mu e nanumu tooe kadoo mayugwekwudu. Pana umu nu-noyookwudu, gi ka mu numu nemooagadu nakatzabe-wa'ne'yoo. Nu yise yow petu, mu magwetzoikwutu, mu yise ooosapa gwetzoimona besa sokwamamokwu. ");
INSERT INTO paoNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","18","Nu yow ka mu mabetseakwuse, nu gi mu namanayahakwuna sookwa'e, nu ka mu-koobatoo nabatsakwuse, umu Te Naa naka'oedyukudu yise nu-no'yookwu. Soo E Naa besa e sooyugwe, nu ka oo tunetammapu mayohona mu numu magwetzoina, umu-koobatoo tuwazoo nabatsakwuse. Mu numu e batsakwu ka meeoo e soonamme, pana nu gi meeoo tusooyugwe. Nu pooha tumada'e, yise nu mesoo gwetzoa'ekwusoo, soo E Naa ka 'yoo e mane tuunguna. Nanakukumma'ayoosoo numu saa'a e naka'oedyukudooa. Nu yise sumusoo mu mayugwe petuse, mu mabetseana, mu-kooba tueya'edooa. Soo seepu takonedu gi mu seepu toge soobedya, ka puu gi mu hee-gana. O'no yise ka etza'a mu seepu-baa petuse, soo mu takonedu sukwe meahoo, oosoo ka gi mu seepu hee-soobedyana. Soo etza'a mu seepu-matu goehookwu, mu susumudu yise nana'emota petukwowkwu.” ");
INSERT INTO paoNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Mu Jew numu ka oo nakase ka Te Pabe'e unnepu-witu, nanano sukwe nanepetukute. ");
INSERT INTO paoNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Susumudu umu-matu mee unakwe, “Esoo nana tuma'emukwadu unu suta'a, gi oo nakabetseapana.” ");
INSERT INTO paoNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Susumudu umu-matu punno'o mee unakwe, “Soo tuma'emukwadu, gi mee ooonnekoo yadooa-wa'ne'yoo, masoo unu nesoonamme. Esoo nana, Te Pabe'e gi tubootabuedu numu mabesakupu.” ");
INSERT INTO paoNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Saa'a ka tu tommo petuse, mu Jew numu nanesootuhidu ewa tuka, umu ka oo soomayuna ka o'nosoo tu nanamooatupu ka Te Naa nanesootuhi nobe mu mabetsabepu. ");
INSERT INTO paoNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Soo Te Pabe'e oona wunudyinnumme, ka nanesootuhi nobe-matoo nahabadoodu-tooha, ka Solomon haba mee naneadu-tooha'yoona mu numu nanesootuhiyakwe, umu-baa. ");
INSERT INTO paoNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Mu Jew numu tutunehanedu oo na'oonnakwi manise mee oo tubenga, “U haa'a ne nanekwegeakwu? U haa'a Ne Pabe'e?” ");
INSERT INTO paoNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Soo Te Pabe'e mee mu nanekwege'a, “Nu mooasoo mu too'e tuukwe pana mu gi e naka'oedyukute. Nu ka E Naa nuka netamma-kwa'nesoo manakwe, mu sakwa uga e sopedakwatoo, pana mu gi e nakaheesoobedya. ");
INSERT INTO paoNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Mu tookwa gi nu-no'yookwudu. ");
INSERT INTO paoNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Umu nu-no'yoopunnedu e nakasopedakwadoo, yise e unnetoosoo mana'we. Nu mu sopedakwadoo, ");
INSERT INTO paoNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","mu yise ooosapa mu gwetzoimona petukudu. Gi haga nu oemota mu mayugwe-wa'ne'yoo. ");
INSERT INTO paoNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Soo E Naa umu e doodooamu mayugwepu, soo E Naa ka mu numu ooonakwasoo pooha-gana, gi haga ka E Naa oemota mu nemayugwe-wa'ne'yoo. ");
INSERT INTO paoNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Nu punno'o unu pooha-ga'yoo ka E Naa-wa'nekoosoo.” ");
INSERT INTO paoNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Mu Jew numu tutunehanedu tupe tzobakooha, ka Te Pabe'e unnena gi naka petzabena oo tatzagahookwu mee sokwamana. ");
INSERT INTO paoNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Soo Te Pabe'e mee mu netamma, “Ka E Naa nuka tunetammakuna nu mayohona ka mu numu tummatza'e, mu yise oowetoo e batsayagate.” ");
INSERT INTO paoNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Umu mee ka Te Pabe'e netamma, “Pana numme u batsakwu ka Ne Naa-wa'nesoo u naneyugwe. Gi numme ka besa u tumadugu-kwitu u batsakwu. U sukwe numu, numme-wa'nesoo pana u mee unakwe, ‘Nu ka Te Naa-wa'ne'yoosoo.’ ” ");
INSERT INTO paoNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Soo Te Pabe'e mee mu netamma, “Mu tookwa ka Te Naa unnepu ne'a, ka mee na'unnedu, ‘Soo Te Naa meeoo ka sukwe numu netamma, “Mu sakwa nu-kwa'ne'yoosoo.” ’ ");
INSERT INTO paoNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Soo Te Naa unnepu gi na'esayidu. Nu gi sukwe numu nu ka Te Naa tubetse yadooawabe. Ooonne'yoona mu sakwa gi e batsapana, tooe nu ka E Naa-wa'ne'yoo mee'e e unakwe sapa. ");
INSERT INTO paoNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Soo Te Naa yaa teepu-koobatoo e taya. Ha'oo manena mu, ‘Esaya'e,’ mee e netamma, ‘Nu Te Naa Tooa'a,’ mee e unakwe? ");
INSERT INTO paoNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","38","Mu sakwa ka Te Naa pooha-ma nanabesa e manekena naka'oedyuku, tooe mu gi e nakaheesoobedya pana. Mu sakwa oo naka'oedyuku, numme ka E Naa-no sumu'yoosoo.” ");
INSERT INTO paoNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Umu yise ka Te Pabe'e too'e wutumahookwu, pana soo Te Pabe'e mu namatzatsebooge. ");
INSERT INTO paoNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Numme natunedyooemodu, yise ka Te Pabe'e-no mea'a, ka Jordan hooodu kwingakwatoo, ka o'nosoo John numu baa-wi matzakapu-witoo. ");
INSERT INTO paoNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Onona ewa'yoo numu ka Te Pabe'e-matoo kemmadyakwe. Umu mee nananetamma, “Soo John puu gi pooha-gapana no'yoona ka John Te Pabe'e-witu wahapu meno'o oo-toogoo manekena.” ");
INSERT INTO paoNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Ooonne'yoona ewa'yoo numu onona ka Te Pabe'e-wi tunaka'oedyuku mane. ");
INSERT INTO paoNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","6","Soo nana Lazarus mee naneadu ka oona Bethany mee naneadu-kwi nobe-ga'yoo unu tuoeya'e. Lazarus ka umu tu susuakwumu Mary noko Martha mee nananeadu-no ka Te Pabe'e-no besa nanapua'a. Mu oo susuakwamu yise ka pumme tummatzidu ka Te Pabe'e-matoo taya. Oosoo yise ka Te Pabe'e-baa petugase mee oo netamma, “U pua'a Lazarus unu tuoeya'e.” Soo Te Pabe'e ka oo nakahoose mee unakwe, “Tooe oo ya'ese sapa, nu ka Te Naa Besa Pooha-toohakwi oo mayodakwu, o'no mu numu e nesookwugikwu, nu ka Te Naa Tooa'ana. Oo manepunnedu, umu e sopedakwatoo, nu ka yow Mu Tubetse Pabe'e-na. O'no mu numu eka poonnese mee unnekwu, ‘Soo Te Pabe'e tookwa unu pooha-ga'yoo.’ ” Soo Te Pabe'e ka Lazarus-witu nakase waha tabe mease, ");
INSERT INTO paoNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","yise numme pumme nakatzimodu mee netamma, “Tamme ka teepu Judea mee naneadu-kwitoosoo kodyu.” ");
INSERT INTO paoNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Numme yise ka Te Pabe'e punno'o mee netamma, “Te nanumu papabe'e otuoo tupe-ma u too'e tatsagapu. U sakwa gi oetoosoo kodyupana.” ");
INSERT INTO paoNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","10","Soo Te Pabe'e meeoo, “Nu meno'o yaahoo togesoo gwetzoinnumme. Gi hee meno'o e patza-wa'ne'yoo, gisoo nu E Naa nuka tunetammakupu mamakwu.” ");
INSERT INTO paoNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Soo Te Pabe'e yise mee ne netamma, “Te pua'a Lazarus sukwe u'we, tamme oo-matoo mease nu saa'a oo netupoonnedooa.” ");
INSERT INTO paoNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Numme oo nakatzimodu yise ka Te Pabe'e mee netamma, “Gi tookwa oosoo hownne'yoo ka sukwe uwena. Oosoo puusoo pudusoo tupoonnekoo.” ");
INSERT INTO paoNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Soo Te Pabe'e ka Lazarus ya'ena sopedakwadoo. Numme meeoo sokwama soo Lazarus tookwa sukwe u'we. ");
INSERT INTO paoNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Soo Te Pabe'e yise besasoo oetu ne tuukwe'e, “Soo Lazarus ya'epu.” ");
INSERT INTO paoNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Soo Te Pabe'e yise mee ne netamma, “Nu besa soonamme nu ka gi onona ka Lazarus ya'ehoose. O'no nu e besa pooha manena mu tzapoonnekukwu, o'no yise saa'a mu e naka'oedyukudooa. Meno'o tamme ka oo natugu-kwitoo mea'a.” ");
INSERT INTO paoNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Soo nana Thomas mee naneadu, Namatu mee tuwazoo naneadu, mee ne netamma, “Tamme sakwa ka Te Pabe'e-no mea'ase, o'no sumuna tamme saa'a ka Te Pabe'e-nosoo natagoedooa.” ");
INSERT INTO paoNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Ka oo Te Pabe'e-no ne petuhoogase mu numu meeoo ne tuukwe'e, “Mooasoo watsu tabe meakapu soo Lazarus ka tupe tawaga-kwi natugupuna.” ");
INSERT INTO paoNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","19","Soo Bethany ka Jerusalem tsage'yoona, ewa'yoo mu Jew numu ka Jerusalem nakwanatu kemmana mu Mary noko Martha-baa petugase, ka Bethany-wi'yoona mu netusoonakute, ka mu wannga'a ya'ese. ");
INSERT INTO paoNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Mu numu ka Martha meeoo tuukwe'e, “Soo Jesus mu pua'a mooasoo oo-na kemma.” Soo Martha yise oo wegea meahoo. Soo Mary ka gi oo nakana tu nobe-kwisoo. ");
INSERT INTO paoNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Soo Martha yise ka Te Pabe'e wege'owse mee oo netamma petuga, “U sakwa uga ka ne wannga'a tooesoo gwetzo'i petuse, oosoo uga gi ya'ekwu. ");
INSERT INTO paoNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Soo Te Naa ka pumme u nanetzakwiya'e u nakasootuhidyina mu numu besa mayugweyakwe.” ");
INSERT INTO paoNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Soo Te Pabe'e mee oo netamma, “Saa'a soo u wannga'a gwetzoise tuusootabuekwu.” ");
INSERT INTO paoNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Soo Martha yise ka Te Pabe'e mee netamma, “Aha, nu oo sopedakwatoo soo teepu saa'a atasoo manekwu, no'yoona mu tuipu tuusootabuekwu.” ");
INSERT INTO paoNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","26","Soo Te Pabe'e yise mee ka Martha netamma, “Nu ka mu numu mayodakwu. Soo tooe haga tooe nuka naka'oedyukudu, too'e ya'ese sapa nu mu matuusootabuese umu ooosapa gwetzoimokwu. U haa'a puu e naka'oedyukute?” ");
INSERT INTO paoNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Martha yise meeoo oo netamma, “Aha, nu u naka'oedyukute, u yow Ne Pabe'e, o'nosoo nanekemmapu.” ");
INSERT INTO paoNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Soo Martha yise ka Mary-matoo mease meeoo oo watse tuukwe, “Soo Te Pabe'e mooasoo petuoose u ba'e.” ");
INSERT INTO paoNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Soo Mary ka oo nakahoose, yotsekase ka Te Pabe'e-matoo meahoo. ");
INSERT INTO paoNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","31","Mooasoo ewa'yoo Jew numu petugonno ka Mary netusoonakuna. Ka Mary gi obeda yotseoose oo meahoose umu numu meeoo sokwama, “Oosoo tookwa ka tu wannga'a natugu-kwitoo meahoo.” Umu yise oo-nakwi mea'a. ");
INSERT INTO paoNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Soo Mary ka Te Pabe'e-baa petugase oo-kobena meatzedose, mee ka Te Pabe'e netamma, “U sakwa uga ka o'nosoo petuoose, e Pabe'e sakwa uga gi ya'e.” ");
INSERT INTO paoNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Soo Te Pabe'e ka Mary tu pupua'a-no mu sakwa'e mu poonnena, tutuha mu sooyugwe. ");
INSERT INTO paoNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Soo Te Pabe'e yise meeoo tutubenga, “Hano natzatugu?” Umu yise mee oo nanekwegea, “Kemmow, numme u tzapoonnekukwu.” ");
INSERT INTO paoNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Soo Te Pabe'e yise yaka. ");
INSERT INTO paoNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","37","Mu numu otuoo yise mee nana'unnegonno, “Masoo Jesus tookwa togesapa ka Lazarus unu soobedya.” Mu susumudu punno'o mee unnegonno, “Esoo Jesus puu ka gi tubootabuedu mabesaku, ka Lazarus sakwa uga tuwazoo ooosoo. Soo Lazarus uga gi ya'ekwu.” ");
INSERT INTO paoNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Soo Te Pabe'e yise tutuha soonammena, ka tupe tawaga-kwitoo ka Lazarus pukwi natugu-kwitoo mea. Ka tupe tawagana-kobena papabatse'yoo tseketadyadu tupe-ma oo nadatumapunne. ");
INSERT INTO paoNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Soo Te Pabe'e meeoo, “Ka tupe sekebatoo magonnonoekwuni.” Soo Lazarus suakwu Martha yise meeoo oo netamma, “Oosoo mooasoo watsu tabeno manekapu ka mi natzatuguna. Meno'o ka sumuna oosoo suda kwanakapu.” ");
INSERT INTO paoNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Soo Te Pabe'e yise meeoo oo netamma, “Mooasoo nu mee uga u tuukwepu, u ka tunaka'oedyukuna, o'no u ka Te Naa pooha tuyugwena poonnekwu.” ");
INSERT INTO paoNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Ka tupe mu magonnonoese, soo Te Pabe'e toogoopatu poonnese meeoo nanesootuhi, “Ne Naa u nanasookwuga'e, nu ka nono'otsa u nanetzakwi'yina u e nakasootuhiyakwe. ");
INSERT INTO paoNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Nu oo sopedakwadoo u ooosapa e nakasootuhidyidu. Nu meno'o yaanona u yadoo'e, o'no mu numu yaatu e naka'oedyukukwu, nu yaahoo U Besaa Tooa.” ");
INSERT INTO paoNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Soo Te Pabe'e yise pabatse'e ka Te Naa Besa Pooha-toohakwi mee unne, “Lazarus, yaatoo kemma.” ");
INSERT INTO paoNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Soo Lazarus yise, yaatoo tsebooeke, oo tookoo no'yoona wunapu-ma nakwutoota, oo-koobadooe. Soo Te Pabe'e yise ka mu numu meeoo netamma, “Ka a nakwutootana tzahanehoo.” ");
INSERT INTO paoNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Ewa'yoo mu numu Jerusalem-wi'yoona ka Mary-no kemmadu ka Te Pabe'e pooha manena poonnese oo soo'oedyukute. ");
INSERT INTO paoNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Pana susumudu umu-matu gi oo soo'oedyukudu, ka mu Pharisee Te Pabe'e tumoo'oodu-matoo mease ka Te Pabe'e besa pooha tuyugwepu mu tuukwe'e. ");
INSERT INTO paoNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Mu tutunehanedu-no mu Pharisee sumuhoose mee unakwe, “Soo Jesus ewa naduya pooha manekena. Ha'oo sakwa tamme oo sootunaga? ");
INSERT INTO paoNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Ka meno'o gi ooka te tzodyooikute no'yoona numu sumuna oo naka'oedyuku mani petugakwu. O'no sumuna mu Roman numu moohedu umu tukwutumadu yaatoo tayase umu ka te nanesootuhi nobe, yise no'oko te nanumu manepunnena kadoo mayugwekwu.” ");
INSERT INTO paoNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Sumu'yoo mu tutunehanedu pabe'e Caiaphas mee naneadu mee mu netamma, “Mu gi hemma sopedakwatoo. ");
INSERT INTO paoNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Tamme sakwa ka Jesus batsa, oosoo puu sukwe sumu'yoosoo nana. Tamme puu ewa'yoo. O'no tamme no'yoona gi tuikwu.” Gi puu pumme tusooyugwena yadoo'a. ");
INSERT INTO paoNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Oosoo ka mu tunehane pabe'ena, soo Te Naa pumme soonammetuguna oo yadooa tuunguna, oosoo yise meeoo, “Jesus no'oko ka mu tu nanumu-koobatoo nabatsakwu.” ");
INSERT INTO paoNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Soo Te Pabe'e gi ka mu tu nanumu-koobatoo suu'mu nabatsakwu, no'obatusoo numu-koobatoo nabatsakwu. ");
INSERT INTO paoNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Mu Jew tutunehanedu yise oo batsakwu mee tunehane. ");
INSERT INTO paoNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Soo Te Pabe'e ooonne'yoona tukena nuuyugwesapa, numme yise ka Te Pabe'e-no Ephraim mee naneadu-kwitoo me'a, onahoo sukwe hee-wanatoo. ");
INSERT INTO paoNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Soo tabeba tzage'e manekena ka mu pooha tumayohoyina, o'no umu gi namayadu tukaba ewa tukayakwe. ");
INSERT INTO paoNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Ewa'yoo numu ka Jerusalem-kwitoo ewa tuka mi. Mu numu yise ka Te Pabe'e watena mee nanatubenga, “Ha'oogena soo Jesus ka ewa tukape-kwitoo kemmakwu?” ");
INSERT INTO paoNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Mu tutunehanedu, mu numu meeoo netamma, “Ne tuukwe saa'a ka Jesus poonnese, o'no numme oo wutumowkwu.” ");
INSERT INTO paoNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Naapahe tabeno ka Gi Namayuadu Tukaba mu nanesootuhi ewa tukakwuna penipunne, soo Te Pabe'e ka Bethany-wi petuga Lazarus-baa oo nobe-kwi, ookow soo Te Pabe'e ka o'nosoo mayodapu oo ya'ekwikoo. ");
INSERT INTO paoNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Soo Lazarus hama'a Martha ewow numu ka Te Pabe'e noko maka, ka Lazarus tuwazoo. ");
INSERT INTO paoNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Togesoo mu tuka aata soo Martha punne'e, Mary, unu nanenagadu, besa kwanadu nakwana'a ka Te Pabe'e kuku-koobatu hanehoose, tu tzopuhu-ma oo-ma'wonge. Soo nakwana'a no'oko ka nobe-tootu besa kwanakupunne. ");
INSERT INTO paoNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Sumu'yoo umu Te Pabe'e nakatzimodu-matu Judas Iscariot mee naneadu mee unakwe. ");
INSERT INTO paoNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Masoo sakwa uga eka nakwana-ma tumu, gi a nahadyagwe ka mu tutuha manedu numu oo-ma tummatzi.” ");
INSERT INTO paoNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Soo Judas gi ka mu tutuha manedu numu heesoobedya. Soo Judas ka tumasumudoope mahaneyina oo-matu tuduhayakwe. ");
INSERT INTO paoNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Soo Te Pabe'e meeoo oo netamma, “Gi ka Mary meeoo netammapana. Esoo ka e nabatsakwuna tzage'e manekena, ooonne'yoona soo Mary 'yoo e sootunaga'a. ");
INSERT INTO paoNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Mu tutuha manedu numu ooosapa mu-no'yookwu, pana yise nu gi ooosapa mu-no'yookwu yaa teepu-kooba.” ");
INSERT INTO paoNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Ewa'yoo mu Jew numu ka Te Pabe'e, ka Mary nobe-kwi oo-baa nobenge oo sopedakwatoo. Umu ka Te Pabe'e poonnegetu, ka Lazarus tuwazoo. ");
INSERT INTO paoNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","11","Soo Te Pabe'e ka Lazarus oo ya'ekwikoo oo matuusootabu'ase, ewa'yoo mu numu ka Te Pabe'e-wi tunaka'oedyuku manegena. Mu yise tutunehanedu ka Lazarus nuusookwetakuna oo batsakwu mee'e tunehane. Ewa'yoo numu ka Jerusalem-witu ka Te Pabe'e ka Lazarus oo mayodase oo poonnedu nanekwahakooha. ");
INSERT INTO paoNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Ookow moo'a soo Te Pabe'e ka Jerusalem-witoo mea. ");
INSERT INTO paoNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","18","Ewa'yoo numu ka Jerusalem-wi numu-baa ewa nanesootuhi tukagetu oo naka ka Te Pabe'e kemmana. Mu numu ka mu nanekwahana nakadu, ka Te Pabe'e wegeaga, oo'oodutsekoo poohegakoo sunngabe ma'na hemmana. Umu papabatse nanakatsebooegonno, besa nesokwamana mee unnena, “Soo Te Naa meno'o te tummatzikwu. Soo Te Naa yaatoo Te Pabe'e tayapu. Soo Te Naa Te Pabe'e sootuhikwu. Esoo Te Pabe'e meno'o tamme-kooba tunehane katukwudu.” Soo Te Pabe'e tuutsekoo tzagaze-kooba katunoo'oo, ka Te Naa unnepu nabotugu-kwa'ne, “Mu numu saa'a, gi suipana. Soo mu-kooba katukwudu pudusoo petukwu tzagaze-kooba katuna.” Numme ka o'no gi oo nakasopedakwadoo. Saa'a ka Te Pabe'e tu ya'e-kwikoo namayodase numme oo 'oedyuku manepetu, no'oko ka Te Naa yadooawabe o'nosoo tubo tuguna. ");
INSERT INTO paoNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Mu Pharisee puusoo mee nananetamma, “Mu numu gi te nakabetse'a manegena, umu ka Jesus suu'mu naka'oedyukugonnona.” ");
INSERT INTO paoNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","21","Ka mu ewa nanesootuhi tuka, mu wakwawa'a mu Jew umu-no oe. ");
INSERT INTO paoNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Mu wakwawa'a ka Philip-matoo kemmase yise mee oo netamma, “Numme sakwa ka Jesus-no nanatapoegea.” Soo Philip ka Andrew tuukwe, umu yise nanosoo ka Te Pabe'e tuukwe. ");
INSERT INTO paoNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","24","Soo Te Pabe'e mee mu netamma, “Pudusoo nu mu numu suda mane-koobatoo nabatsakwu. O'no yise mu oo sopedakwadoodooa, yow nu mu Pabe'e, mu magwetzoi meakwudu. Ewa'yoo numu e naka'oedyukuna ooosapa gwetzoimokwu. Nu togekoo mu tuukwe. Nu ka hemma pooe-kwa'ne puu, ka teepu-tooha namasuase tooe suda manese sapa, ka suakese ewa pooedooakekwu, yooosoo nu punno'o manekwu. Ka e ya'ese e namayodase, ewa'yoo numu nunakwana nanesootuhi manekekwu. ");
INSERT INTO paoNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Tooe haga tooe gi nu-notu, ka gi moobekwa-gakoo nagwetzoidu gi nasootuhi-wa'ne'yoo. Tooe haga tooe nu-no meadabedu, oosoo ka tubetse gi moobekwu-gakoo nagwetzoidu nasootuhikwu. ");
INSERT INTO paoNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Soo tooe haga tooe nu-matoo nanesootuhidu ooosapa nu-no'yookwu. Soo E Naa yise ooosapa gi mobegwa-gakoo nanagwetzoidu mu sootuhikwu. ");
INSERT INTO paoNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Meno'o nu suda soonamme, nu yaa teepu-koobatoo kemma, mu numu-koobatoo nabatsakwuse. Gi nu ka E Naa mee netamma-wa'ne'yoo, ka nuka wohonedu-makoo e magwetzoi. ");
INSERT INTO paoNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","U, E Naa, ka mu numu u-matoo nanesootuhi mayugweke, mee nu u nanetzakwiya'e.” Soo Te Naa yise pa'anakwana mee oo nanekwegea, “Nu mooasoo nu-matoo nanetzakwiya'e mu mayugwepu, mu yise ooosapa manenokwu.” ");
INSERT INTO paoNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Ka Te Naa tuapa nakase mu susumudu numu oo konnopunnedu-matu mee nananetamma, “Nunuabu-wa'ne meeoo numme oo nakasoobedya.” Mu susumudu yise punno'o mee unne, “Sumuna soo toha kasa-ga'yoo ka Te Pabe'e yadooe.” ");
INSERT INTO paoNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Soo Te Pabe'e Jesus yise ka mu numu mee netamma, “Soo Te Naa pabatse'e e yadooe, nunua'adu-kwa'ne nanakahoo, o'no mu punno'o oo sopedakwadookwu ka nuka oo yadoo'e. ");
INSERT INTO paoNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","33","Pudusoo nu mu-koobatoo nabatsakwu.” Soo Te Pabe'e tuwazoo mee unakwe, “Nu no'obatusoo numu nuka nanesootuhi mayugwekwu. Saa'a mu gi tunaka'oedyukudu, soo suda mu tumadugupu umu-matoosoo kodyukwu. Nu ka Sutakoo, mu numu tuma'emukwa mayugwedu matzooekukwu.” ");
INSERT INTO paoNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Susumudu mu numu otuoo mee unakwe, “Numme mee oo naka, soo Te Naa unnepu meeoo na'unakwe, ‘Soo Te Pabe'e ooosapa gwetzoinnummekwu.’ U yise ka Ne Pabe'ena, u gi hownnekoo nabatsa-wa'ne'yoo.” ");
INSERT INTO paoNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","36","Soo Te Pabe'e mee mu nanekwegea, “Te Naa unnepu nu mumme numu tunesootabuekute, ooonne'yoona soo Te Naa yaa teepu-kooba mu-baa e manumudoopu. Ka e yaanoko e naka'oedyuku, nu yise saa'a ka tubetse nanagwetzoidu mu sootuhikwu. Mu ka sutakoo matzooekukwu ka nuga dooamuna, pudusoo nu E Naa-matoosoo kodyukakwu, mu yise gi hownnekoo e nagega-wa'ne'yoo.” Soo Te Pabe'e yise mease umu tu wohomu watze. ");
INSERT INTO paoNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","38","O'nosoo soo Te Naa yadooawabe Isaiah mee naneadu mee tubotugupu-ga'yoo, “Te Naa, gi haga pumme ne tuukwena naka'oedyukute, tooe umu ka nanabesa u tumaduguna poonnepana.” Mu numu ka Te Pabe'e poonne, ka nanabesa oo tumadugu. Pana ka Isaiah o'nosoo unnekwa'nesoo gi no'yoona umu oo naka'oedyukute. ");
INSERT INTO paoNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","40","Mee tuwazoo soo Isaiah unakwe, “Mu numu tusoomatzooena tooe ka Te Naa unnepu nakapana gi oo soonakabetse'a. Umu sakwa sumuna ka oo nakasopedakwadoona, ka suda tu tumaduguna ma'wuse e naka'oedyuku manese, nu mu mabesakukwu. Oo manena umu gi ka Te Pabe'e naka'oedyukute.” ");
INSERT INTO paoNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Soo Isaiah meeoo ka Te Pabe'e-witu waha, soo Isaiah ka Te Pabe'e pooha nakasopedakwatoona. ");
INSERT INTO paoNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Susumudu mu numu Jew numu-matu, yise susumudu mu Jew numu moohedu-matu, ka Te Pabe'e naka'oedyukute. Pudu mu Pharisee nanesootuhidu mee unakwe, “Numme ka tooe haga tooe Jesus-wi tunaka'oedyukudu tayakwunikwu.” Ooonne'yoona umuoo tunaka'oedyukudu gi nanekwaha. ");
INSERT INTO paoNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Umu gi oo nakaheesoobedya tooe ka Te Naa meeoo pumme netamma sapa. Pana ka mu numu pumme nesookwugina suu'mu besa soobedya. ");
INSERT INTO paoNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Soo Te Pabe'e tu besa pooha-toohakwi mee unakwe, “Numu nu-kwi tunaka'oedyukudu gi nuka suu'mu naka'oedyukute, umu ka Te Naa yaatoo nuka tayadu naka'oedyukute tuwazoo. ");
INSERT INTO paoNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Mu numu nuka sopedakwadoodu, ka Te Naa nuka yaa teepu-koobatoo tayase, ka nu mumme numu Te Naa-witu nakasopedakwadoo mayugwekwuse. ");
INSERT INTO paoNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Mu numu ka nu-kwi tunaka'oedyuku manese, gi ka suda tu tumadugu-ma sokwamakwu. ");
INSERT INTO paoNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Nu ka mu numu magwetzoikwuse yaa teepu-kooba petu, gi mu wohonekwuse. ");
INSERT INTO paoNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Tooe haga tooe gi e unnepu naka'oedyukudu saa'a, soo suda mu tuma'emukwana umu-matoosoo kodyukwu. ");
INSERT INTO paoNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","50","Nu gi e sukwe tusooyugwena wahana meeoo unakwe, ka Te Naa yaatoo nuka tayadu meeoo nuka netamma. Mu numu ka Te Naa nakabetseadu ooosapa gi moobegwaga gwetzoimokwu.” ");
INSERT INTO paoNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Soo Te Pabe'e ooosapa numme pumme nakatzimodu yaa teepu-koobatu unu soobedyadu. Ka gi namayadu tukaba nanesootuhi na'ewa tukakwuna oe manegena, soo Te Pabe'e unu ne soobedyana, soo Te Pabe'e ka oo sopedakwatoona, pudusoo nabatsase ka Te Naa-matoosoo kodyukakwu. ");
INSERT INTO paoNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Soo Suta'yoo mooasoo ka Judas Iscariot tunetammakupunne. Soo Te Pabe'e oo sopedakwatoo ka Te Naa-baa'yoona kemmase, saa'a yise oo-matasoo punowsoo kodyukakwu. ");
INSERT INTO paoNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Soo Te Pabe'e yise oo sopedakwatoo, soo Te Naa oo Pooha-makase no'yoona hee oo-toohakwi gwetzoimokwu. Soo Te Pabe'e numme pumme nakatzimodu-no yongo tukana, ");
INSERT INTO paoNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","soo Te Pabe'e yotseoose, tu naga'apu tzakwumowse, namatzua'a-ma wunateahoo. ");
INSERT INTO paoNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Ka baa pukwi mu tabatzaganoo-wi tuoonahoose, numme pumme nakatzimodu ne tabatzagakute, ne kuku mabasakute. ");
INSERT INTO paoNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Soo Te Pabe'e yise ka Peter-baa mani petu, soo Peter yise ka Te Pabe'e meeoo netamma, “U Ne Pabe'e. U gi nuka tabatzagakupana. Umu ooonne'yoo numu moohedu, gi numu tabatzagatudu.” ");
INSERT INTO paoNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Soo Te Pabe'e ka Peter meeoo nanekwegea, “Meno'o u ka 'yoo e manena gi nakasopedakwadoo, pana saa'a u besasoo oo nakasopedakwadookwu.” ");
INSERT INTO paoNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Soo Peter ka Te Pabe'e mee netamma, “Gi nuga kuku tabatzagapana.” Soo Te Pabe'e ka Peter nanekwegea, “Nu u tabatzagakuse, u e dooa'a manekwu. Nu ka gi u tabatzagakuna u gi e dooa'a mane-wa'ne'yoo.” ");
INSERT INTO paoNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Soo Peter ka Te Pabe'e yise mee netamma, “No'oko e tookoo e nabageaku, e kuku, e mi, e wo tuwazoo.” ");
INSERT INTO paoNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","11","Soo Te Pabe'e yise ka Peter mee netamma, “U mooasoo pudu nabagea u gi tootsa'a, u kuku suu'mu. Soo Te Naa mooasoo ka suda mu tumaduguna soomu'wapu, pana sumuoo mu-nagatu suda tumaduguna gi soomu'wa, oosoo ka tooesoo suda tumaduguyina.” Soo Te Pabe'e ka Judas Iscariot netammana ka oo sopedakwatoona, saa'a soo Judas ka umu Te Pabe'e wohonedu-no ka Te Pabe'e wutumakwu. ");
INSERT INTO paoNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Ka no'oko ne tabatzagakumakwuse, ka tu naga'apu-wi namadabuese oo katuhoosoo. ");
INSERT INTO paoNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Mee yise ne netamma, “Nu mu tuukwekwu ka how manena nu mu kuku tabatzagakute. Mu yise Ne Pabe'e mee e ne'a. Oosoo togesapa, nu Mu Pabe'e. ");
INSERT INTO paoNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Nu Mu Pabe'e mu tabatzagaku ooonne'yoona mu sakwa nanatummatzina, mu sakwa punno'o nanatabatzagaku. Mu sakwa gi paba nasooyugwepana tooe meeoo soonammepana. ");
INSERT INTO paoNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Ooosapa nu besa mu tummatzidu, ooonne'yoona mu sakwa besa nuga mumme matugu-kwa'nesoo besa nanamatugu. ");
INSERT INTO paoNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Nu togesapa mu tuukwe mu sakwa nanatummatzi, mu sakwa gi mee tusooyugwepana, ‘Nu nagutza besa'yoo gi ka E Pooha Pabe'e numu tummatzi-kwa'ne mane-wa'ne'yoo.’ ");
INSERT INTO paoNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Mu haa'a oo nakasopedakwatoo ka how manena nu mu tabatzagaku? Mu ka e unnepu nakabetseana, soo Te Naa mu sootuhikwu. ");
INSERT INTO paoNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Sumuoo mu-nagatu soo Te Naa gi sootuhikwu. Nu mu posopedakwatoonasoo mu netutzea, nuka tummatzikwutu. O'nosoo soo Te Naa yadooawabe meeoo tubo, “Sumu'yoo mu-nagatu nu-no tukadu e wohonekwu.” ");
INSERT INTO paoNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Gisoo oo tu namanakwe nu mu tuukwe'e, saa'a yise ka oo tunamanese mu mee unnekwu, ‘Soo Jesus togesapa Te Pabe'e.’ ");
INSERT INTO paoNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Nu togesapa mu tuukwe'e. Nu ka umu e nanayadooawabe numu-matu mu-matoo tayakwu, mu ka mu nakabetseana e doodooamu manekwu. Umu nuga doodooamu, E Naa doodooamu tuwazoo.” ");
INSERT INTO paoNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Soo Te Pabe'e yise suda soonammena mee tuwazoo ne netamma, “Sumu'yoo mu-nagatu saa'a e nemawunidooa, ka umu e wohomu-matoo.” ");
INSERT INTO paoNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Numme tunakatzimodu nanapoonnemo'o, numme gi oo sopedakwatoo ka haga oo netammana. ");
INSERT INTO paoNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Nu ka Te Pabe'e-kumaba katu, oosoo ka nuka unu soobedyana. ");
INSERT INTO paoNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Soo Peter e tsetzoogase mee unakwe, “Ka Te Pabe'e tubenga haga oosoo netamma.” ");
INSERT INTO paoNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Nu ka Te Pabe'e tzage'esoo nuuyugwese, ka Te Pabe'e tubenga, “Haga numme-matu u wohomu-matoo u nemawunikwu?” ");
INSERT INTO paoNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Soo Te Pabe'e mee e nanekwegea, “Nu ka egea tukaba-matoo a hooba-wi matzakase ka ookow nana geahookwu.” Soo Te Pabe'e ka tukaba hooba-wi, a namatzakana ka Judas Iscariot geahoo. ");
INSERT INTO paoNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","30","Soo Judas yise ka tukaba-matoo tukowse, soo suta'yoo Judas-ma katuoose oo-naga mani. Soo Te Pabe'e yise meeoo ka Judas netamma, “Yabeapu ka u tusoohane-kwa'ne mani.” Mooasoo tu toganokase soo Judas meahoo. Numme tuka aatadu gi oo nakasopedakwadoo ka Te Pabe'e meeoo ooka nema'ese. Ka Judas ka pumma ne tumukwuna hanedu, numme-matu yise meeoo sokwama, “Sumuna soo Te Pabe'e tukapu oo tumu tuungusoo, ka tu ewa tukapu-kwitoo.” Numme-matu punno'o meeoo sokwama, “Soo Te Pabe'e meeoo, ka mu tutuhamanedu-matu haneku.” ");
INSERT INTO paoNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","32","Soo Te Pabe'e mee ne netamma, “Meno'o soo Te Naa mu tzapoonnekukwu, nu Mu Pabe'e. Meno'o manakwana tamme ka Te Naa nesookwugikwu e mane-koobatoo. Pudusoo 'yoo namanekwu. ");
INSERT INTO paoNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Mu e besa doodooamu. Pudusoo nu gi mu-baa'yookwu. Mu e wate pana gi e mayu-wa'ne'yoo, ka mu Jew numu moohedu e tunetammaku-kwa'nesoo. ");
INSERT INTO paoNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Nu pudu tumayohope mu tuukwekwu, ‘Nuka mumme soobedya-kwa'ne, mu sakwa meno'o manakwana ooonnekoo soo nanasoobedyana. ");
INSERT INTO paoNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","No'obatusoo numu mu nakasopedakwadookwu, mu e doodooamu, ka besa mu nanasoobedya mu poonnena.’ ” ");
INSERT INTO paoNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Soo Simon Peter mee ka Te Pabe'e tubenga, “Howtoo ma'a u meakwu?” Soo Te Pabe'e mee oo nanekwegea, “Nu oona kwinga'a meakwu, ka Te Naa-matoo, mu gi hownnekoo nu-no mea-wa'ne'yoo. Pana nu saa'a mu bidooa.” ");
INSERT INTO paoNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Soo Simon Peter yise mee oo netamma, “Ha'yoo u unnena meeoo, mu gi meno'o nu-no mea-wa'ne'yoo? Nu u-no'yookwu ka unu u soobedyana tooe mu numu taka goekwuse sapa.” ");
INSERT INTO paoNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Soo Te Pabe'e yise mee oo netamma, “Nu u sopedakwadoo. U gi nu-no ya'ekwu, yaa togano u gi e nanenama'yookwu. Gisoo ka kwe'na'a kwu'a yaka u saa'a pahe tooe ka mu numu mee netammadooa, ‘Nu gi ka Jesus sopedakwatoo.’ U gi ooosapa nu-no'yoopunnekwu.” ");
INSERT INTO paoNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Soo Te Pabe'e yise numme pumme nakatzimodu mee netamma, “Gi suda sokwamapana. Mooasoo mu ka Te Naa nakabetsea, nuka nakabetsea tuwazoo. ");
INSERT INTO paoNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","3","Soo Te Naa nobe-kwitu ewow kapa-ga'yoo. Nu togesapa, nu gi esaya'e. Nu mease ka Te Naa-baa mu kapadookukwu. Saa'a nu yaasoo kodyu petuse, mu bikakwu Te Naa-matoo. O'no yise mu ooosapa nu-no'yookwu. ");
INSERT INTO paoNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Mu mooasoo oo sopedakwadoo ka a nameatabuana.” ");
INSERT INTO paoNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Soo Thomas yise ka Te Pabe'e mee netamma, “Numme gi oo sopedakwadoo ka pukwitoo u meakwuna. Numme gi a nameatabuana sopedakwatoo.” ");
INSERT INTO paoNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Soo Te Pabe'e yise mee oo netamma, “Nu ka besow podo mu moohekwu. Nu togesapa ka Te Naa-witu sopedakwatoo, nu ka mu numu ooosapa gwetzoimo-kwitoo mu moohekwu, gi tooe haga tooe hownnekoo puusoo ka Te Naa-baatoo mea-wa'ne, nu otu mu mesoo biga'a. ");
INSERT INTO paoNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Mu mooasoo e tubetse naka'oedyukute. Yaa manakwana mu ka Te Naa naka'oedyukuna, oo poonnekwu tuwazoo.” ");
INSERT INTO paoNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Soo Philip yise ka Te Pabe'e mee netamma, “Ka Te Naa ne tzapoonneku. O'no numme besa sokwamakwu.” ");
INSERT INTO paoNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Soo Te Pabe'e ka Philip mee netamma, “Wuna'me nu mu-baa, pana tooesoo mu gisoo e tubetse sopedakwatoo. Tooe haga tooe nuka poonnedu ka Te Naa tuwazoo poonne. ");
INSERT INTO paoNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Numme ka Te Naa-no nawa'ne'yoosoo. Nu gi nugasoo tusooyugwena nu mu tuukwe'e, pana E Naa nuka tunetammakuna nu waha. ");
INSERT INTO paoNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Mu sakwa ka mumme e tuukwena naka'oedyuku, numme ka Te Naa-no toge nawa'ne'yoosoo. Ooonne'yoona mu sakwa e naka'oedyuku, nu ka mu tuoegoedu mabesakuyakwe. ");
INSERT INTO paoNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Mu sakwa oo tubetse naka'oedyuku, nu pudusoo ka Te Naa-matoo kodyukakwusoo. Nu yise mumme nuka naka'oedyukudu ka Te Naa Besa Pooha-matu-ma mu sootuhise, o'no mu nu-kwa'nesoo punno'o, besa pooha nasootuhikwu. Mu punno'o nanasookwugi, nuga ooonakwasoo besa pooha manekwu. ");
INSERT INTO paoNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","14","Mu ka e naka'oedyukuna e nanetzakwiya'ena, nu mu nakasootuhikwu. O'no mu numu saa'a mee unnedooa, soo Te Naa tookwa besa'yoo. ");
INSERT INTO paoNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Tooe haga tooe mu-nagatu unu e soobedyadu, e nakabetseakwu. ");
INSERT INTO paoNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Nu ka Te Naa tuukwekwu, ‘U sakwa u Besa Pooha-matu-ma mu sootuhi.’ Soo Te Naa Besa Pooha yise ooosapa mu-no'yoona mu tummatzikwu. ");
INSERT INTO paoNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Soo Te Naa Besa Poohasoo ka kaahenotu mu tunedyooekwu. Ka Te Naa Besa Pooha mumme tummatzi, oosoo ooosapa mu-no'yoona, mu ka Te Naa besa podo meadabekwu. Mu gi tunaka'oedyukudu, gi ka Te Naa Besa Pooha sopedakwadoo, oosoo yise gi hownnekoo mu tummatzi-wa'ne'yoo. ");
INSERT INTO paoNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Tooe pudusoo mumme e ma'wugakwuse sapa, mu gi suda sokwama-wa'ne'yoo, ka mu-baatoosoo e kodyu petukwuse. ");
INSERT INTO paoNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Pudusoo mu gi tunaka'oedyukudu gi e poonne-wa'ne'yoo, mu suu'mu. Nu puu namayodakwu saa'a, mu punno'o ooosoo. ");
INSERT INTO paoNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Ka e namayodase, mu oo sopedakwadookwu, nu ka E Naatu, mu punno'o nugatuna, nu mummetu. ");
INSERT INTO paoNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Mu numu e nakabetseadu, besa tookwa e soobedya. Ka umuoo nuka unu soobedya, soo Te Naa tookwa punno'o unu umuoo soobedyakwu. Nu punno'o besa umuoo soobedyana mu tzapoonnekute nu umu-nosoo.” ");
INSERT INTO paoNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Soo Judas mee naneadu, gi Judas Iscariot, ka Te Pabe'e mee netamma, “Hownnekoo yise u ne natzapoonnekute, pana mu gi tunaka'oedyukudu gi u poonne-wa'ne'yoo?” ");
INSERT INTO paoNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Soo Te Pabe'e mee oo nanekwegea, “Tooe haga tooe nuka unu soobedyadu e nakabetseakwu. Soo Te Naa punno'o unu mu soobedyakwu. Numme ka Te Naa-no mu natubangakwu. ");
INSERT INTO paoNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Tooe haga tooe gi e nakabetseadu, tookwa gi e nakaheesoobedya. Nu ka E Naa nuka mumme e tuukwe tuunguna suu'mu mu tuukwe. ");
INSERT INTO paoNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Nu ka togesoo mu-baa'yoopunnena eka besa na'unnedu mu tuukweyakwe. ");
INSERT INTO paoNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Nu saa'a ka Te Naa-baa petugase, ka oo Besa Pooha-matu-ma mumme oo sootuhi tuungudooa. Soo Te Naa Besa Pooha no'oko hemma mu tunedyooekwu, no'oko hemma mumme e tuukwena mu tzasoomayukudooa. ");
INSERT INTO paoNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Nu besa mu masoonammekwu nuga besa soonamme-kwa'nesoo. Mu gi tunaka'oedyukudu gi hownnekoo besa soonamme-wa'ne'yoo. Gi suda soonammenapana, gi tuwazoo suipana. ");
INSERT INTO paoNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Mooasoo nu mu tuukwe'e, ‘Pudusoo nu nabatsakwuse, saa'a namayodase mu-baasoo kodyu petukwu.’ Mu tookwa gi e tubetse soobedya, mu sakwa uga ka e soobedyana besa sokwama, ka Te Naa-matoo e kodyukakwuse. Meno'o soo e Naa nuga ooonakwakoosoo pooha-ga'yoo. ");
INSERT INTO paoNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Nu ka a namanekwuna mu tuukwe, ka hemma oo manese mu e naka'oedyukukwu. ");
INSERT INTO paoNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Pudusoo nu gi mu-no yadooa-wa'ne'yoo. Soo Suta'yoo e tumoo'oogena, pana oosoo gi nuka matzooeku-wa'ne'yoo. ");
INSERT INTO paoNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Pana soo e Naa mu numu-koobatoo e nabatsa tuunguna, nu yise ka Te Naa nakabetseakwu. Mu numu oo sopedakwadookwu, nu tookwa E Naa besa soobedya. Tamme sakwa mea.” Umu yise ka nobe-kwi'yoona mea. ");
INSERT INTO paoNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Soo Te Pabe'e numme pumme nakatzimodu mee netamma, “Nu puu toesabooe namasua-kwa'ne'yoo, soo oo pooetooana mesoo nadukadu. Soo Te Naa puu ka tumasuadu ooka mabetseadu-kwa'ne'yoo. ");
INSERT INTO paoNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","No'yoona yise mu nuka naka'oedyukudu, ka tumasuape ma'na-wa'ne'yoo. Soo tooe haga tooe gi ka Te Naa nakabetseadu, ka toesabooe gi pooetooa-kwa'ne'yoo. Soo Te Naa ookow tsega'akwunise oo wunikwu. Mu numu ka Te Naa nakabetseadu ka toesabooe ewow besa pooetooa-kwa'ne'yoo. Soo Te Naa puu ookow mabetseana oosoo besasoo pooedoo'a. ");
INSERT INTO paoNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Mu ka tumasuape ma'na besa pooetooadu-kwa'ne'yoo, mu ka mumme e tuukwena naka'oedyukuna. ");
INSERT INTO paoNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Gi nu oemota manepana, nu yise punno'o gi mu ooowemota mane-wa'ne'yoo. Soo toesabooe ma'na-matu gi puusoo pooetoo-wa'ne'yoo, ka toesabooe-ma'yoona suu'mu. Yooonnekoo mu gi muusoo besa tumadugu-wa'ne'yoo, mu nu-no'yoona suu'mu, besa tumudugukwu. ");
INSERT INTO paoNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Umu mu-naga-kwitu nu-no'yoodu ka Te Naa nakabeatsedu. Tooe haga tooe nu oemota manegadu, gi besa tumadugu-wa'ne'yoo. ");
INSERT INTO paoNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Tooe haga tooe gi nu-no'yoodu, ka tumasuape ma'na-wa'ne nawunikwu, oosoo ka pasase, natapo'wokese, natunikwu. ");
INSERT INTO paoNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Mu ka nu-no'yoona ka mumme e tunedyooena nakabetseana, mu ka Te Naa-matoo nanesootuhina, oosoo yise mu nakasootuhikwu. ");
INSERT INTO paoNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Mu numu ka besa mu manakwe mu poonnena mee unnekwu, ‘Oosoo tookwa Te Pabe'e-matoo nanesootuhidu,’ umu yise mee tuwazoo unnekwu, ‘Te Naa besa'yoo,’ mee. ");
INSERT INTO paoNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Nu besa mu soobedya, ka Te Naa nuka soobedya-kwa'ne. Nu-no meadabe, o'no nu ooosapa besa mu soobedyakwu. ");
INSERT INTO paoNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Nu puu ka Te Naa nakabetseana, oosoo ooosapa besa e soobedyakwu. ");
INSERT INTO paoNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Nu tubetse besa soonammena nu eka mu tuukwe, o'no mu punno'o tubetse besa sokwamakwu. ");
INSERT INTO paoNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Nu besa mu soobedya, ooonne'yoona nu mee mu netamma, yooonnekoo sakwa mu besa nanasoobedyamo. ");
INSERT INTO paoNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Tooe haga tooe ka tu pua'a-koobatoo mesoo nabatsadu, tookwa tu pua'a besa soobedya. ");
INSERT INTO paoNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Tooe haga tooe nuka nakabetseadu puu nuga pua'a, nu sakwa oo-koobatoo mesoo nabatsa. ");
INSERT INTO paoNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Mu nuka sukwe tummatzimodu yaa manakwana e besa pupua'amu tuwazoo. Soo sukwe tutummatzidu puu gi ka pumme tu tunetammakukwudu manekwuna sopedakwadoo. Nu ka no'oko hemma ka Te Naa mumme e tuukwe tuunguna mu tuukwena ooonne'yoona mu tookwa e pupua'amu. ");
INSERT INTO paoNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Mu gi e netutzease nu yow Mu Pabe'e, pana nu mu netutzease o'no mu ka Te Naa nakabetsea, mu yise e wanga'amu. Nu ka Te Naa mu nakabetsea tuungu, o'no yise soo besa mu tumadugupu gi mobegwa-gakwu. Mu e naka'oedyukudu yise, ka e nanetsagwaya'ena, soo Te Naa yise no'oko mu nekwina mu sootuhikwu. ");
INSERT INTO paoNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Nu yise mee mu netamma, ‘Besa nanasoobedya,’ mee. ");
INSERT INTO paoNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Ka mu gi tunaka'oedyukudu numme wohonedu gi mumme mu petzabekwuse, mu sakwa oo soomayu ka mooasoo nuka mu mooe wohonena. ");
INSERT INTO paoNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Nu ka meno'o mu wanga'amu natubanga. Ooonne'yoona mu gi tunaka'oedyukudu gi mu petzape mu gi umu-matu. Umu puusoo nanasoobedya. ");
INSERT INTO paoNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Mooasoo nu mu tuukwe soo nuka nagedu nu-kwa'nesoo namadugukwu. Ka nuka tu wohone-kwa'nesoo, umu mumme wohonekwu. Ka gi nuka mu naka'oedyuku-kwa'ne, umu gi mumme naka'oedyukukwu. ");
INSERT INTO paoNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Umu ka gi Te Naa yaatoo nuka tayadu sopedakwadoona, ooonne'yoona umu gi e naka'oedyukuna mu wohonekwu. ");
INSERT INTO paoNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Ka gisoo umu e tunedyooe umu gi oo sopedakwatoo ka suda tumaduguna, pana meno'o umu oo sopedakwadoo, saa'a yise soo suda mu tumaduguna umu-matoosoo kodyukwu, ka gi mu nanekwuha. ");
INSERT INTO paoNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Soo tooe haga tooe gi e heesoobedyadu ka Te Naa gi heesoobedya tuwazoo. ");
INSERT INTO paoNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Tooe umu numu e mabesakute e poonnepana, umu meno'o ka Te Naa nokosoo ne woho'ne. Nu umu oe neyugwe ka gi nuka mu naka'oedyukute. ");
INSERT INTO paoNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","O'nosoo soo Te Naa yadooawabe mee tubotugu, ‘Tooe gi suda e tumadugu sapa umu e woho'ne,’ ka Te Naa yadooawabe unne-kwa'nesoo. ");
INSERT INTO paoNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Nu saa'a ka Te Naa-baa petugase, ka oo Besa Pooha-matu yaa teepu-koobatu sootuhi tuungudooa. Soo Te Naa Besa Pooha kaahenotu mu tunedyooekwu, yise ka mu numu nu-kwitu tuukwekwu. ");
INSERT INTO paoNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Ka mu numu e tunedyooe manakwana, mu e nakatzina ooosapa e nageno'o. Ka 'yoo hemma manepunne, mu punno'o mu numu nu-kwitu tuukwemokwu.” ");
INSERT INTO paoNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Soo Te Pabe'e togesoo numme pumme nakatzimodu yadooedyakwe mee yise ne netamma, “Mooasoo nu ekow mu tunedyooepu, o'no mu ooosapa e naka'oedyukumokwu. ");
INSERT INTO paoNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Mu numu ka Jew nanesootuhi nobe-kwikoo mu tayahoo, ka gi mu-no soonanesootuhina. Ka mu goena umu mee sokwamakwu, ‘Numme Te Naa tummatzidu.’ ");
INSERT INTO paoNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Pana umu mumme goedu puusoo nanemooaga, umu ka gi e naka'oedyukuna ka Te Naa tuwazoo gi naka'oedyukute. ");
INSERT INTO paoNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Nu ka a namanekwuna mu tuukwe, o'no mu saa'a ka mu numu mumme woho'ne oo soomayudooa ka mumme e tuukwena. Nu mooe'ugasoo ekow gi mu tuukwe'e, ka togesoo mu-baa'yoona. ");
INSERT INTO paoNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Meno'o yise nu ka Te Naa-matoosoo kodyukakwu. Gi haga mu-nagatu mee'e e tubengu, ‘Howtoo u meakwu?’ mee. ");
INSERT INTO paoNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Mu ka mee mumme e tuukwese, nu ka Te Naa-matoosoo kodyukukwu, mu suda sokwama. ");
INSERT INTO paoNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Nu kaaheno mu tuukwekwu, nu ka Te Naa-baasoo kodyu petugase, nu mu nanesootuhikukwu, o'no nu saa'a ka Te Naa Besa Pooha-matu punowsoo mu sootuhise mu besa sokwamadooa. ");
INSERT INTO paoNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","11","Ka Te Naa Besa Pooha petuse, mu numu saa'a ka tu ma'emukwana soomu'wadooa ka nu-kwi tunaka'oedyukuna. Nu ka gi wuna'me yaa teepu-kooba mu-baa'yookwuse, soo Te Naa Besa Pooha ka Te Naa Besa podo mu tunaka'oedyukudu moohekwu. Soo Te Naa mooasoo ka sutakoo nemamakwupu yaa teepu-kooba'yoona suda mumme wuyugwedu. ");
INSERT INTO paoNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Nu ewow mu tunedyooe pena'e, pana meno'o mu gisoo oo nakasopedakwadoo-wa'ne manepunne. ");
INSERT INTO paoNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Soo Te Naa Besa Pooha ka petuse ka toge kaaheno hemma manepunne-wikoo, mu tuukwekwu gi pummesoo tusooyugwe-kwikoo mu moohekwu. Soo Te Naa Besa Pooha saa'a ka hemma manegekwuna mu tunesootubuedooa. ");
INSERT INTO paoNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","15","Ka nu-kwitu tuwazoo, soo Te Naa Besa Pooha mu tunedyooedooa, o'no mu saa'a, ‘E Pabe'e,’ mee e natubangadooa. No'yoona hee Te Naa-toohakwi manepunnedu punno'o nugatu. ");
INSERT INTO paoNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Nu pudusoo nabatsakwu, pana huu oo tabe mease nu namayodase yaa teepu-koobasoo kodyu petukwu. O'no yise nu saa'a, ka Te Naa-matoosoo kodyukakwu.” ");
INSERT INTO paoNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Numme tunakatzimodu-matu mee nananetamma, “Tamme gi oo nakasopedakwadoo ka Te Pabe'e tamme tuukwena. Ha'yoo unnena meeoo unakwe, ‘Nu pudusoo nabatsase huu oo tabe mease namayodase kodyu petukwu yise saa'a ka Te Naa-matoosoo kodyukakwu? ");
INSERT INTO paoNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Ha'oo manena soo Te Pabe'e pudusoo meakwu?’ ” ");
INSERT INTO paoNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Soo Te Pabe'e oo sopedakwatoo numme oo tubengakwu ka ha'yoo unnena mee yise ne netamma, “Mu muusoo nanatubenga how manena nu mee unakwe, ‘Nu pudusoo nabatsakwu. Huu oo tooise namayodase, nu kodyu petukwu.’ ");
INSERT INTO paoNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Nu togesapa mu tuukwe'e ka umu e wohomu nuka batsase, mu suda sokwamana, sakwikwu. Mu gi tunaka'oedyukudu besa sokwamakwu. Pana mu ka suda sokwamase sapa, saa'a mu besa sokwamakekwu ka e kodyupetuse. ");
INSERT INTO paoNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Ka e nabatsase, mu ka mogo'ne dooa'a-doo-kwa'ne nuummawunukwu. Soo mogo'ne puu suda soonamme ka unu nuummaba wumana. Pana ka oonga'a nadooa'adoose soo mogo'ne ka tu nuummawununa soomu'wase ka oonga'a-matoo besa soonammekwu. ");
INSERT INTO paoNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Mu pudusoo suda sokwamakwu, pana ka e kodyu petuse mu besa sokwamakwu. Gi haga yise suda mu masokwama-wa'ne'yoosoo. ");
INSERT INTO paoNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","24","O'nosoo gi yoo manepunne, ka Te Naa-matoosoo e kodyukase mu gi hemma nuka tubenga-wa'ne'yoo. Mu ka Te Naa-matoo nanetzakwiya'e, oosoo mu nakasootuhikwu ka nuka mu naka'oedyukute. Meno'o manakwana mu ka Te Naa nanetzakwiyise soo Te Naa nu-koobatoo mu nakasootuhikwu, mu yise besa sokwamakwu. ");
INSERT INTO paoNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Nu mu tuukwe'e, mu tunedyooena, ka Te Naa-witu. Mu gi mu natuukwe-witu nakasopedakwadoo, pana pudusoo nu ka Te Naa-witu mu tuukwekwu, besa ooka mu nakasopedakwadoo-kwikoo. ");
INSERT INTO paoNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","27","Ka Te Naa-matasoo e kodyukase mu saa'a ookow nanetzakwiyidooa, nu-toohakwi. Mu besa e soobedyana e naka'oedyukute, ka Te Naa-baa'yoona yaa teepu-kooba e petuse. Mu ka nuka besa soobedyana, soo Te Naa punno'o mumme besa soobedyana, mu nakasootuhiyakwe. ");
INSERT INTO paoNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Nu ka Te Naa-baa'yoona kemmase yaa teepu-kooba petu. Pudusoo nu nabatsase, namayodase, ka Te Naa-matoosoo kodyukakwu.” ");
INSERT INTO paoNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Numme mee oo netamma, “Meno'o numme oo nakasopedakwatoo, ka numme u tuukwena. ");
INSERT INTO paoNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Meno'o manakwana numme oo naka'oedyukukwu, u no'oko hemma sopedakwadoo. U mooasoo oo sopedakwadoopunne, gisoo uga umu ne tubenga sapa. Numme oo naka'oedyukute, soo Te Naa yaa numme-baatoo u taya.” ");
INSERT INTO paoNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Soo Te Pabe'e mee ne netamma, “Mu meno'o e naka'oedyukute, ");
INSERT INTO paoNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","pana pudusoo mu nu oemota manegakwu. Pana nu gi nu suu'mu, soo Te Naa ka nu-no'yoona. ");
INSERT INTO paoNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Nu eka mu tuukwe'e, o'no mu besa sokwamakwu ka e naka'oedyukuna. Mu ka togesoo yaa teepu-kooba'yoona mu gi tunaka'oedyukudu, mu e tumoo'ooyikwu. Pana besa sokwama nu ka sutakoo umu gi tunaka'oedyukudu moohedu matzooekukwu.” ");
INSERT INTO paoNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Soo Te Pabe'e ka yadooamakwuse toogoopatu poonnese nanesootuhikooha, “E Naa, pudusoo umu e wohomu e batsakwu. Mu numu tunesootabue, nu togesapa u besa dooa. Nu yise punno'o ewow numu u-matoo nanesootuhi mayugwekwu. ");
INSERT INTO paoNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","3","U no'oko numu moohedu e mayugweke. Tooe haga tooe e naka'oedyuku u mayugwepu, nu punno'o ooosapa mu gwetzoimokwuna mu sootuhikwu, u numu manumudoopu nu yise Jesus Mu Pabe'e. Mu numu taka soo'oedyukudu ooosapa gwetzoimokwu. ");
INSERT INTO paoNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Nu no'oko nuka u tunetammakuna yaa teepu-koobatu mamakwu. Ooonne'yoona mu numu besa u nemadabuekwu nu-koobatoo. ");
INSERT INTO paoNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","O'nosoo gisoo ka teepu namadabu'e, ta nabaa'yoona, nawa'ne'yoosoo. ");
INSERT INTO paoNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","U mu numu-matoo nuka naka'oedyuku mayugweke. Nu yise punno'o ume mu nakasopedakwadoo tunedyooe. ");
INSERT INTO paoNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Umu ume doodooamuna, u yise nugatu mu mayugweke. Umu ume nakabetse'a, umu tuwazoo u naka'oedyukute, u yow no'oko hemma e nemadabuekute. ");
INSERT INTO paoNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","No'oko nuka u tunedyooepu nu mu numu tunedyooekwu. Umu oo naka'oedyukuna, oo sopedakwatoo nu u-baa'yoona yaa teepu-kooba petu, umu tuwazoo oo naka'oedyukute, u yaatoo e taya. ");
INSERT INTO paoNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Nu umu nuka naka'oedyukudu, suu'mu nanesootuhikute u sakwa mu sootuhi. ");
INSERT INTO paoNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","U ka mu nu-matoo nanesootuhidu doodooamu-ga'yoo. Umu ka ume doodooamuna, nuga doodooamu tuwazoo. Ka taga doodooamu besa manakwe mu numu oo sopedakwadookwu, nu tookwa besa'yoo. ");
INSERT INTO paoNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Pudusoo nu ka yaa teepu-kooba'yoona mease u-baasoo petugakwu. Pana umu e naka'oedyukudu, togesoo yaa teepu-kooba'yookwu. E Naa, u ooosapa besa'yoo. U unu poohagana, ka umu taka naka'oedyukudu mesoo mabetsea. Umu yise sumu-kwa'ne'yookwu, ta-kwa'ne, ta puu nawa'nesoo. ");
INSERT INTO paoNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Too'e no'yoona umu-matu togesoo e naka'oedyukute, u tunetamma-wa'nesoo. Nu ka umu-baa'yoona suta-makoo mu mabetseayakwe. Sumu'yoosoo nana nu oemota manekwu. Pudusoo oosoo kadoo'oo namayugwekwu. ");
INSERT INTO paoNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Pudusoo nu u-matoosoo kodyukakwu. Nu togesoo yaa teepu-kooba'yoona u-matoo nanesootuha'e, u ka umu nuka naka'oedyukudu sootuhikwu. Umu ka pumme u sootuhise besa sokwamakwu, nu-kwa'nesoo. ");
INSERT INTO paoNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","16","Nu ka u unnepu-witu mu tuukwe'e. Mu gi tunaka'oedyukudu ka mu taka naka'oedyukudu gi petzape, umu taka naka'oedyukudu ka nu-kwa'ne'yoona, gi umu-wa'ne'yoona. Umu e naka'oedyukudu gi ka taka wohonedu-kwa'ne'yoo. Nu mee nanesootuha'e ka suta-makoo ka yaa teepu-koobatu mabetsea mee, gi u, umu taka naka'oedyukudu gi eka teepu-koobakoo ta'ya. Soo taka naka'oedyukudu gi ooosapa ka teepu-kooba'yookwu nu-kwa'nesoo. ");
INSERT INTO paoNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","U umu taka naka'oedyukudu ka u unnepu naka'oedyukudu, ka togesapa oo na'unakwe, umu u tubetse nakabetseakwu. U yaa teepu-koobatoo e taya. ");
INSERT INTO paoNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Meno'o yise nu ka umu tunaka'oedyukudu tayakwu, umu ka no'obatusoo numu u unnepu tunedyooekwu. ");
INSERT INTO paoNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","O'no umu, u nakabetseakwu nu-kwa'nesoo, nu pudusoo umu-koobatoo nabatsakwu, o'no yise umu u tubetse nakabetseakwu. ");
INSERT INTO paoNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Umu taka naka'oedyukudu sootuhi. Nu-kwitu ka numu nanekwuhana nakadu sootuhi, o'no umu e naka'oedyukukwu. ");
INSERT INTO paoNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Ta nanosoo sumu-kwa'ne'yookwu, no'oko umu taka naka'oedyukudu mayugweke. Umu ta-no manese, mu numu oo sopedakwadookwu ka yaa teepu-koobatoo nuka u tayase. ");
INSERT INTO paoNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","U puu u yadooawabe ka yaa teepu-kooba'yoona e mayugwepunne, umu taka naka'oedyukudu punno'o nuga yadooawabe manepunne. Umu punno'o sumu-kwa'ne'yookwu, ta-kwa'ne, ta puu nawa'ne'yoosoo. ");
INSERT INTO paoNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Nu puu umu-no, u yise punno'o nu-nosoo. Umu yise sumu-kwa'ne'yookwu, ta-kwa'ne, ta puu nawa'ne'yoosoo. Ooonne'yoona mu gi tunaka'oedyukudu sakwa oo nakasopedakwatoo u yaatoo e taya, u ka umu taka naka'oedyukudu besa nanasoobedya mu mayugwekese nuka u soobedya-kwa'nesoo. ");
INSERT INTO paoNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","U, E Naa, ooosapa besa e soobedyadu, gisoo ka teepu namadabue sapa. U ka mu numu taka naka'oedyuku mayugwepu, o'no umu ta-baa ooosapa gwetzoimokwu. O'no umu ta-nawa'ne'yoo mee ta unnena nakasopedakwadookwu, yise taka nesookwugikwu. ");
INSERT INTO paoNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","U tubetse besa'yoo. Mu gi tunaka'oedyukudu yaa teepu-koobatu u-kwitu gi sopedakwadoo, nu suu'mu no'oko hemma u-kwitu sopedakwatoo. ");
INSERT INTO paoNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Nu u-kwitu besa mu tuukwepu, yise ooosapa u-kwitu mu tuukwennummekwu. Nu ooosapa umu-no'yookwu, o'no yise umu besa nanasoobedyakwu nuka u soobedya-kwa'ne.” ");
INSERT INTO paoNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Mooasoo soo Te Pabe'e ka tumasuape-naga'yoona nanesootuhi. Soo Te Pabe'e yise ka nanesootuhi-makwuse, ka numme pumme nakatzimodu-no ka duaga Kidron mee naneadu-too me'a. O numme ka tumasuape-naga mane-petuga. ");
INSERT INTO paoNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","3","Mu Pharisee numu ka numu-koobatoo yadooadu-no, ka mu tukwutumadu ka Judas Iscariot namoohe tuunguna. Soo Judas oo sopedakwatoo ka tumasuape-naga, pukwi'yoona mu nanesootuhidyina, ka Te Pabe'e ooosapa onatoo meayakwe ka numme pumme nakatzimodu-no. Soo Judas ka mu tukwutumadu ka Te Pabe'e-matoo bihooka. Umu ewahoo tukootabuakunooo, tsegesa noko wehe hehemana. ");
INSERT INTO paoNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Soo Te Pabe'e mooasoo oo sopedakwatoo ka tu namanekwuna, yise umu-matoo mease, mu tubengu, “Haka mu wate?” ");
INSERT INTO paoNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","6","Umu oo nanekwegea, “Ka Jesus Nazareth-wi'yoona kemmadu numme wate.” Soo Te Pabe'e meehoo, “Nu yow oosoo.” Umu no'yoona ka suise, petapenooyooese, ka teepu-koobatoo abedihoo. Judas togesoo umu-no. ");
INSERT INTO paoNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Soo Te Pabe'e mu tubengusoo, “Haka mu wate?” Umu oo nanekwegea, “Ka Jesus Nazareth-witu kemmana numme wate.” ");
INSERT INTO paoNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Soo Te Pabe'e yise meehoo, “Mooasoo nu mu tuukwe, ‘Nu yow oosoo.’ Mu ka nuka watena, umu e nakatzimodu tzama'wu.” ");
INSERT INTO paoNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Soo Te Pabe'e meehoo unakwe, o'no soo e unnena kaaheno'yookwu, “Nu gi sumuhoo watzekute ka umu nuka naka'oedyukudu-matu.” ");
INSERT INTO paoNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Soo Simon Peter yise ka tu tsegesa gwuuhoose, ka nana Malchus mee naneadu tumadinakwatu ka oo naka wuka'akwunihoo. ");
INSERT INTO paoNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Soo Te Pabe'e yise ka Peter mee'e netamma, “Maka u wehe namasootugu. Nu ka Te Naa nuka netamma-kwa'nesoo manekwu.” ");
INSERT INTO paoNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Mu Jew-no Roman tukwutumadu ka Te Pabe'e tzakunahoo ka oo wutumakwuse. ");
INSERT INTO paoNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Umu ka nana Annas mee naneadu-matoo oo tzakahooka. Soo Annas ka numu-koobatoo yadooadu, Caiaphas mee naneadu yahe. ");
INSERT INTO paoNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Soo Caiaphas mooasoo ka mu Jew numu ka Te Pabe'e-witu tuukwepu, “Oosoo nanenagakwu, sumu'yoosoo nana no'oko numu-koobatoo nabatsakwuse.” ");
INSERT INTO paoNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Ka Te Pabe'e togesoo ka Annas nobe-witoo nabigena, soo Simon Peter sumuhoo Te Pabe'e nakatzimodu-no mu-nakwi memeadape. Soo Te Pabe'e nakatzimodu ka Annas sopedakwatoo, yise ka Te Pabe'e-nosoo ka Annas nobe-kobenatoo meahoo. ");
INSERT INTO paoNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Soo Peter ka natzakwona'a-kumaba tooe wunu-petuga. Sumu'yoo numme Te Pabe'e nakatzimodu-matu kodyuse, ka mogo'ne ka natzakwona'a-wi tunekwegedyudu yadooebetuse, oosoo yise oe ka Peter tza'egahoo. ");
INSERT INTO paoNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Soo mogo'ne ka natzakwena'a-wi ka Peter tubengu, “U-ha'a sumu'yoo mu Jesus nakatzimodu-matu?” Soo Peter mee oo nanekwegea, “Nu gi umu-matu.” ");
INSERT INTO paoNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Unu utzutzuna, mu numu tummatzidu ka mu tukwutumadu-no puuwanakoo pedana, oe yoo'e. Soo Peter umu-baa yoo'e. ");
INSERT INTO paoNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Soo Annas ka Te Pabe'e tubengu ka numme pumme nakatzimodu-witu, yise ka numu oo tunedyooe-witu tuwazoo. ");
INSERT INTO paoNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Soo Te Pabe'e mee ka numu nehanedu moohedu nanekwegea, “No'yoona numu ka pukwitu pumme e tunedyooena sopedakwatoo. Umu ooosapa e nakayakwe, ka mu numu e tunedyooe ka nanesootuhi nobe-wi'yoona. Nu gi mu watze-tunedyooe. ");
INSERT INTO paoNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Mu gi nugasoo tubengu-wa'ne'yoo. Mu sakwa tooe haka tooe nuka nakadu tubengu. Umu oo sopedakwatoo ka e unnena.” ");
INSERT INTO paoNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Sumu'yoo tukwutumadu yise ka Te Pabe'e kobitu matatse'e. Soo tukwutumadu oo nesagwiku, “U sakwa gi ka tamme moohedu suda nanekwegeapana.” ");
INSERT INTO paoNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Soo Te Pabe'e yise meeoo, “Ka e esaya'e, u sakwa kaaheno e waha. U sakwa yise gi nuka matatze'epana, ka kaaheno e unakwe.” ");
INSERT INTO paoNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Soo Annas yise togesoo natzakunadu ka Te Pabe'e ka Caiaphas-matoo taya. Oosoo ka numu-koobatoo yadooadu. ");
INSERT INTO paoNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Saa'a tuwazoo umu-matu ka Peter meehoo tubengu, “U-ha'a sumu'yoo mu Jesus nakatzimodu-matu?” Soo Peter yise meehoo, “Gi, nu gi umu-matu.” ");
INSERT INTO paoNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Soo Peter pudutse'e sumuhoo nana naka wuka'akwunihoo. Oo nanumu yise mee ka Peter netamma, “Nu u poonne u ka Jesus-no oona ka tumasuape-kwi.” ");
INSERT INTO paoNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","“Nu gi o,” mee soo Peter, o'no yise soo kwe'na'a kwu'a yagakooha. ");
INSERT INTO paoNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Mooasoo mu Rome numu-kooba katudu ka Pilate netutzea, Jew numu oo moohe tuunguna. Oogow mooo'a awamooasoo, mu Jew numu moohedu ka Te Pabe'e Jesus Caiaphas-makoo tzakahooka, ka Pilate nobe-witoo. Tooe haga tooe gi ka mu wawa'a nobe-wi tzoonooa, ka gi umu-wa'ne'yoonosoo, ka hemma nayongotuka gi oo tuka, ka oo nabeatsegana, ka tu tumayohope meeoo na'unakwe. Umu Jew numu moohedu ka Pilate nobe-wi gi tzoonoo'a. ");
INSERT INTO paoNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Soo Pilate umu-matoo tsebooekese, mu tubengu, “Ha'oo suda esoo nana manakwe?” ");
INSERT INTO paoNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Umu oo nanekwegea, “Esoo ka suda tumaduguse, numme u-matoo a bike.” ");
INSERT INTO paoNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Soo Pilate mee mu netamma, “Mu sakwa mummesoo tumayohope-too a nemadabue.” Mu Jew numu moohedu ka Pilate meeoo netamma, “Soo numme Jew tumayohope meeoo, numme oo mesoo batsa, pana mu Roman numu moohedu ne wutumakwu, ka numu ne batsase.” ");
INSERT INTO paoNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Esoo 'yoo manepunne. O'no yise saa'a soo Te Pabe'e tu unne-kwa'nesoo sunngabe namadabue-ma nataposase, nabatsakwu. ");
INSERT INTO paoNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Soo Pilate ka tu nobe-wisoo ekeahoogase, ka Te Pabe'e tubengu, “U-ha'a mu numu-kooba katudu?” ");
INSERT INTO paoNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Soo Te Pabe'e mee ka Pilate nanekwegea, “Nu ka mu Jew numu Pabe'e, nu gi ka numu-kooba katudu mee mu nea-kwa'ne'yoo.” ");
INSERT INTO paoNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Soo Pilate yise mee Te Pabe'e netamma, “Nu gi Jew numu. U ka mu Jew numu Pabe'ena, how manena yise umu nu-matoo u taya? Ha'oo suda u tumadugu?” ");
INSERT INTO paoNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Soo Te Pabe'e mee ka Pilate nanekwegea, “Mu Jew numu u-matoo e ta'ya, umu e nakatzimodu gi nu-koobatoo nago'e. Nu saa'a mu numu-kooba katudu manekwu, ka Te Naa-baa petugase.” ");
INSERT INTO paoNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Soo Pilate yise oo tubengusoo, “U-ha'a numu-kooba katudu?” Soo Te Pabe'e oo nanekwegea, “Nu yaahoo Mu Tubetse Pabe'e. Nu yaa teepu-koobatoo nadooa'adoo, ka mu numu ka kaahenotu tuukwekwuse. Soo tooe haga tooe ka kaahenotu soonakadu sakwa e nakapunne.” ");
INSERT INTO paoNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Soo Pilate tutubengu, “Hee esoo kaahenotu?” Gi ka pumme oo nanekwegeakwuna wutoo'e, ka mu Jew numu moohedu-matoo tzebuegase, mee unakwe, “Gi nu suda a tumaduguna mamakoo nemama'yu. ");
INSERT INTO paoNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Soo ne tumayohope ka tu na'ewa tukano'o, sumu'yoo mu nakwutumadu-matu natzama'wuyakwe. Mu haa'a eka mu-kooba katudu e tzama'wutuungukwu?” ");
INSERT INTO paoNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Mu numu yise ka Te Pabe'e wohonena mee unne, “Gi, ka Barabbas tzama'wu.” Unu tutuhadu ka Barabbas mee nane'a. ");
INSERT INTO paoNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Soo Pilate ka mu tutukwutumadu tu nobe-kwitoo bihoose, yise meeoo mu netamma, “A wukwupageta.” ");
INSERT INTO paoNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Mu tutukwutumadu yise ka Te Pabe'e tzeabe tzowupaga'a-doose, oowehoo oo tzowupakakuhoo. Umu ka numu-kooba katudu kwasu-wa'ne tabuadu-wi oo kwaseyakuhoo. ");
INSERT INTO paoNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Umu ka Te Pabe'e-matoo kemmase, meeoo oo nanetza'mekute, “Yaa u mu Jew numu-kooba katudu.” Umu yise oo kobikoo oo totopagetahoo. ");
INSERT INTO paoNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Soo Pilate yise tsebooekese, ka mu Jew numu moohedu mee netamma, “Nu mu-matoosoo a tzakagekoo, pana nu meeoo esoo gi suda tumadugupu-ga'yoo.” ");
INSERT INTO paoNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Soo Te Pabe'e ka tzebooekese, tzeabe-wi tzowupagana, ka numu-kooba katudu kwasu-wa'nekwisoo namadabue. Soo Pilate mee mu netamma, “Yaa esoo nana. Muusoo how a yugwe.” ");
INSERT INTO paoNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Mu Jew numu moohedu ka pumme nakatzimodu-no oo poonnese, ewa unnekooha, “A tzakwenne, sunngaba namadabue-ma a taposa.” Soo Pilate meehoo mu netamma, “Mu sakwa a tzakakase, a tzakwenne. Nu meeoo esoo gi suda tumatuku.” ");
INSERT INTO paoNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Mu Jew numu moohedu yise meeoo, “Masoo meehoo, ‘Nu yaa ka Te Naa Tubetse Tooa.’ Soo Te Naa nayadooawabe, Moses mee naneadu, o'nosoo mee tubotugu, numme sakwa ka mee ooonnekoo esayidu batsa. Masoo sakwa nabatsa.” ");
INSERT INTO paoNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Soo Pilate ka mu nakase, unu sua'e. ");
INSERT INTO paoNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Ka Te Pabe'e-no nobe-wisoo tzoonooase, oo tubengu, “U haa'a ooonne'yoo?” Soo Te Pabe'e gi oo nanekwegea. ");
INSERT INTO paoNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Soo Pilate ka Te Pabe'e meehoo netamma, “U sakwa e nanekwegea, nu u nemadabuekwu. Nu ka u natzama'wukwuna, tooe too u nabatsakwuna meesoo natuungu.” ");
INSERT INTO paoNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Soo Te Pabe'e oo nanekwegea, “U oo mesoo manakwe, ka Nuga Naa te pa'anakwatu mee unakwe. Mu numu u-baatoo e tzakadu suda tumaduguna, saa'a umu-matoosoo kodyukwu.” ");
INSERT INTO paoNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Soo Pilate yise oo too'e netzama'wu, pana mu Jew numu moohedu ewa unnekooha, “U ka eka nana tzama'wuse, u ka mu Roman numu-kooba katudu woho. Tooe haga tooe meeoo unnedu, ‘Nu numu-kooba katudu,’ ka Rome-witu numu-kooba katudu netumoo'oo.” ");
INSERT INTO paoNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Soo Pilate ekow nakase, ka Te Pabe'e puuwanatu bihookase, yise ka numu moohedu katunoo-wi katu, oona ka Tupe-ma Napodopu mee naneadu-wi'yoona. ");
INSERT INTO paoNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","16","Soo Pilate yise ka mu Jew numu moohedu meeoo netamma, “Yaa'a soo mu Pabe'e.” Umu ewa unnekooha, “A tzakakase, a tzakwenne.” Soo Pilate yise mu tubengu, “Nu haa'a sakwa eka mu-kooba katudu tzakwenne?” Soo numu nanesootuhi moohedu meehoo, “Numme Rome-kooba katudu suu'mu nakabetsea. Numme gi kumma'asoo moohedu nakabetse'a.” Soo Pilate yise ka mu Roman tutukwutumadu ka Te Pabe'e tzakwenne tuungu. ");
INSERT INTO paoNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Soo Te Pabe'e yise ka sunngabe namadabuenna pumatoo tu natzakwenekwuna, puma tu nataposakwuna, tzanona me'a ka pumme tu wumahukase. Oona ka Numu Tzonoho mee naneadu-wi petuga. ");
INSERT INTO paoNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","O'no umu ka Te Pabe'e waahoo nanana noko, ka sunngabe namadabue-matoo tapotseda. Soo Te Pabe'e mu naamookwi mu waha'yoo oo nana'enakwa. ");
INSERT INTO paoNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Soo Pilate wobe-ma mu tubotuungu, ka Te Pabe'e tzopa nataposakwudu, mee o-ma natubo'o, “Yow soo Jesus, Nazareth-witu, mu Jew numu-kooba katudu.” ");
INSERT INTO paoNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Ewa'yoo Jew numu ka meeoo nabodu ne'a, soo pukwi mu natzakwenena ka Jerusalem tzage'e. Pahe-batu numu apeka-ma nabo'o: mu Jew numu; mu Roman numu; mu Greek numu apeka-kwikoo. ");
INSERT INTO paoNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Soo mu Jew numu moohedu ka Pilate meeoo netamma, “Gi ka ‘Mu Jew numu-kooba katudu,’ mee ma-ma tubopana, ‘Esoo nana meeoo, “Nu yaa Jew numu-kooba katudu,” ’ mee'e sakwa mu ma-ma tubo.” ");
INSERT INTO paoNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pana soo Pilate meeoo, “Nu mooasoo meeoo tubose, nu gi atasoo a yugwe-wa'ne'yoo.” ");
INSERT INTO paoNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","24","Watusukwe'yoo (4) tutukwutumadu ka Te Pabe'e ka sunngabe namadabue-ma taposahoo. Umu nanasusu'mu oo namasooape hanehoo. Umu yise meeoo, “Ka a kwasu tamme gi tzakebuepana, esoo sumuhoosoo pabahoo wunapu-kwi namadabu'e. Tamme sakwa eka wunapu nanatukuku.” Ka o'nosoo Te Naa unnepu nabotugu-kwa'nesoo, oo-toogoosoo mani petu, “Umu nanasu'mu ka oo namasooapu-matu hanehoose, ka oo kwasu nanatotzakwate.” A nabotugu-kwa'nesoo mu tutukwutumadu manakwe. ");
INSERT INTO paoNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Mu watsukwe'yoo momoko'ne ka Te Pabe'e natzakwene tzage'e konno, oo pea, oo pedoo-no, Mary mee naneadu Clopas nodukwa, yise Mary Magdalene. Nu, John, punno'o osoo wunupunne. ");
INSERT INTO paoNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Soo Te Pabe'e ka tu pea nu-baa oo wunu oo poonnese, meehoo tu pea netamma, “John meno'o yise umesoo tubetse tooa-wa'ne'yoo.” ");
INSERT INTO paoNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Nuka yise mee netamma, “Meno'o masoo yise umesoo tubetse pea-wa'ne'yoo.” Oowe manakwana Te Pabe'e pea ooosapa nu-no. ");
INSERT INTO paoNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Saa'a soo Te Pabe'e ka oo sopedakwadoose, no'oko ka Te Naa pumme tunetammakupu namamakwuse, mee unakwe, “Nu unu puudya'e.” Oosoo meehoo na'unakwe, o'nosoo ka Te Naa unnepu ka a nabotugu-kwa'nesoo manepunnekwu. ");
INSERT INTO paoNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Atsa baa suda kamadu suu'mu o nuuna, umu yise hooope-ma wanapu tzakunase, ka atsa baa-wi oo tzetsakase, ka Te Pabe'e tupa-wi oo tzematsu'a. ");
INSERT INTO paoNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Soo Te Pabe'e ka atsa baa tumase, meehoo, “Yaatoo namamakwuhoo.” Yise tzokwu'ehoose, ya'ehoo. ");
INSERT INTO paoNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Mu Jew numu moohedu gi ka mu numu tookoo paa'a nataposana petsape, ka oogow mooo'a paba nanesootuhikwuse oo tumaduguyina. Umu numu moohedu ka Pilate meehoo netamma, “Mu natzakwenedu mu kowpa mu wugote tuungu.” O'no umu yabesoo tu'ise, numme mu tookoo tzakwekukwu mee sokwamana. ");
INSERT INTO paoNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Mu tutukwutumadu yise oetusoo kodyuse, ka mu waahoo nanana ka Te Pabe'e nana'enakwa natzakwenedu kowpa wugotehoo. ");
INSERT INTO paoNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Pana soo Te Pabe'e mooasoo ya'epu, umu yise gi oogow kowpa wugote. ");
INSERT INTO paoNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Sumu'yoo mu tutukwutumadu-matu, ka Te Pabe'e ka tu tutokwateno-ma oo sapu kumanakoo oo tzeboosahootooa. Puupe-no baa yise oe manakwana papasawekooha. ");
INSERT INTO paoNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Esoo mumme e tuukwena kaaheno'yoo, nu nuusoo namakoo a poonne, o'no sakwa mu punno'o tunaka'oedyuku. ");
INSERT INTO paoNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","37","Ka soo Te Naa unnepu namamakwuhoo, mee oo unnepu, “Gi oo oho-matu nuugodekwu.” Yise oo unnepu, “Umu numu oo tzeboosahoodu yise o poonnedooa.” ");
INSERT INTO paoNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Sumu'yoo nana Joseph mee naneadu ka Arimathea mee naneadu-wi'yoona kemmadu, ka Te Pabe'e-wi tunaka'oedyukute. Soo Joseph gi haka tuukwe, ka mu Jew numu moohedu-ma suina. Soo Joseph yise ka Pilate mee tubengu, “How sakwa nu ka Jesus tookoo hane?” Soo Pilate yise meehoo, “Gi hownne'yoo.” Soo Joseph yise ka Te Pabe'e tookoo hanehooka. ");
INSERT INTO paoNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Joseph ka nana Nicodemus mee naneadu-no memea. Soo Nicodemus ewatsekoo natusoo'a hanepetu (myrrh noko aloe) gi numu tookoo tzapehekudu. ");
INSERT INTO paoNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Umu ka mu Jew numu tumayohope mayohona ka oo tookoo ka myrrh noko aloe-ma mawo'ngese, wanapu-wi oo toputooe. ");
INSERT INTO paoNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Ka Te Pabe'e natzakwenepu tzage'e ewa'yoo sunngabe toonoopa oona soo tupe tuwaga, gisoo haga pukwi natuguna. ");
INSERT INTO paoNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Ka tu paba nananesootuhikwuse, oogow tabeno yabesoo yongoga'a umu ka pukwi oo natzakwenepu tzage'ekoo ooka tupe tuwagana mayuse, oowe soo Te Pabe'e natugu. ");
INSERT INTO paoNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Awamooasoo togesoo tu toganopunne, ka tu nasateno'o, Mary Magdalene oo natugu-wi petuhooga, oo poonne soo tupe namanonooepu-ga'yoo ka teepu tawagana-kobenatu. Soo Te Pabe'e tookoo kadoo'oo oetu. ");
INSERT INTO paoNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Numme-baa tanomane petuhoo numme Simon Peter-no, mee ne tuukwe, “Umu ka Te Pabe'e tookoo hanehoogapu-ga'yoo, nu gi o sopedakwadoo pukwi ooka mu hanena.” ");
INSERT INTO paoNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Numme, John, yise Peter-no memeakwate oo natugu-witoo. ");
INSERT INTO paoNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Numme nanosoo tatanomanega, pana nu ka Peter tusoowunihooka, nu oe mooe petuhooga. ");
INSERT INTO paoNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Pana nu gi oe ega. Nu oetu sukwe tomoema petugase, oo poonne ka wanapu pukwi oo natoputoepu. ");
INSERT INTO paoNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Soo Simon Peter petuhoogase, oe egahookase ka mu wanapu o kwakwape mu poonne. ");
INSERT INTO paoNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Soo wanapu oo wo pukwi namabutoo dapepu besa namasoomedapu oo tzage'esoo hape. ");
INSERT INTO paoNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Nu yise oe egase, o poonnena oo naka'oedyukute Te Pabe'e namayodapu. ");
INSERT INTO paoNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Pana numme gisoo oo nakasopedakwatoo ka Te Naa unnepu, soo Te Pabe'e namayoda tu ya'e-wikoo mee'e. ");
INSERT INTO paoNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Numme yise nobe-witoo kokodyuka. ");
INSERT INTO paoNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Mary Magdalene ka pukwi o natugupu-kobena'yoona yaka. Yagana yise, ka pukwi oo natugupu-witu tooe poonnennumme. ");
INSERT INTO paoNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Waahoo toha kakasa-gakoo poonne oe mu yugwe, sumu'yoo ka Te Pabe'e tsotugu tabepu-wi, sumu'yoo yise o tatugudapepu-wi. ");
INSERT INTO paoNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Umu yise ka Mary tubengu, “Mogo'ne, how manena u yaka?” Soo Mary mee mu nanekwegea, “Umu ka Te Pabe'e tookoo hanehoogapu-ga'yoo. Nu yise gi o sopedakwatoo oo pukwi'yoona.” ");
INSERT INTO paoNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","O'no yise nakwumunase, ka Te Pabe'e poonne o oo wunu, pana gi oo posopedakwatoo. ");
INSERT INTO paoNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Soo Te Pabe'e meehoo oo netamma, “Mogo'ne, how manena u yaka? Haga u wate?” Soo Mary ka tumasuape mabetseadu mee oo soobedyana, mee oo netamma, “U ka oo haneoogase e tuukwe'e, hano u oo hane? Nu oo hanekwu.” ");
INSERT INTO paoNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Soo Te Pabe'e meehoo oo netamma, “Mary.” Soo Mary oo-tamme nakwumunase, ka mu Jew numu apeka-wikoo oo ne'a, “E Pabe'e.” ");
INSERT INTO paoNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Soo Te Pabe'e yise meehoo oo netamma, “Gi e tzamapana. Nu gisoo ka Te Naa-matoo kodyuka'a. Mease, umu nuka nakatzimodu tuukwe, nu ka Te Naa-matoo kodyukakwu.” ");
INSERT INTO paoNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Soo Mary Magdalene yise numme Te Pabe'e nakatzimodu-matoo mease, numme tuukwe'e, “Nu ka Te Pabe'e poonne.” O'no yise ka numme o netammapu ne tuukwe'e. ");
INSERT INTO paoNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Oogow togano numme Te Pabe'e nakatzimodu nanano ka nobe-wi natzepunoo'e, numme ka mu Jew numu moohedu-ma suina. Soo Te Pabe'e numme-baa tabua-petuse, mee ne netamma, “Besa'yoo.” ");
INSERT INTO paoNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Yise ka tu mi ne tzapoonnekute, ka pukwikoo tu nataboosahoopu noko. Numme tubetse besa sokwama ka Te Pabe'e poonnese. ");
INSERT INTO paoNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","“Besa'yoo,” mee soo Te Pabe'e ne netammasoo. “Ka Te Naa meeoo nuka netamma, nu yaa ekaoo teepu-kooba petu. Nu punno'o mu tuukwe, mana tooe hano tooe ka mu numu nu-witu tuukwemo.” ");
INSERT INTO paoNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Numme-koobatoo songaha'ase, meeoo unakwe, “Nu ka E Besa Pooha-matu-ma mu sootuhikwu.” ");
INSERT INTO paoNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Soo poohabe, ka mu numu suda tumaduguna puma mu nematzagakwunikwuna. Soo Te Naa yise ka suda mu tumaduguna soomu'wakwu. Mu ka gi mu tuukwena, umu gi hownnekoo ka suda tu tumaduguna nematzagakwuni-wa'ne'yoo. Soo suda mu tumaduguna yise umu-matoosoo kodyukwu. ");
INSERT INTO paoNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Sumu'yoo numme tunakatzimodu-matu Thomas mee naneadu gi numme-no, ka Te Pabe'e numme-baa petuse. ");
INSERT INTO paoNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Numme tunakatzimodu ka Thomas meehoo tuukwe, “Numme ka Te Pabe'e poonne.” O'no yise oosoo meehoo, “Nu ka oo mi-wi tawagadu poonnese, oe tzetuguse, ka tutokwatenoo tu'uadoopu-kooba matuguse suu'mu, nu oo naka'oedyukukwu.” ");
INSERT INTO paoNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Sumu nasatese, numme tunaka'oedyukudu ka nobe-wi sumuhoo, o'no soo Thomas numme-no. Tooe ka mu natzakwuna'a natzepunoo'e sapa, soo Te Pabe'e numme-baa petuse, mee soo unakwe, “Besa'yoo.” ");
INSERT INTO paoNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Yise soo Te Pabe'e ka Thomas mee netamma, “Ka e mi poonnese, mi tzetuguse, o'no sakwa u e tubetse naka'oedyuku.” ");
INSERT INTO paoNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Soo Thomas yise gisoo ka Te Pabe'e tzamana o naka'oedyuku. Thomas meeoo, “U Ne Tubetse Pabe'e. Nu u-matoo nanesootuhikwu.” ");
INSERT INTO paoNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Soo Te Pabe'e yise meehoo oo netamma, “U ka e poonnese suu'mu e naka'oedyukute. Mu numu gisoo e poonnedu oo sukwe naka'oedyukuyina unusoo nasootuhiyakwe.” ");
INSERT INTO paoNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Soo Te Pabe'e ewa nanabesa nanasoogwuga'e pooha manakwe ka numme tunakatzimodu punoko, ewa'yoo oo manepu gi nabo'otugu. ");
INSERT INTO paoNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Pana esoo mee na'unnedu nu botugu, o'no mu oo naka'oedyukukwu, soo Jesus Te Tubetse Pabe'e, ka Te Naa Besaa Tooa'a. Mu yise ka oo naka'oedyukuna mu ooosapa gi moobekwa-ga gwetzoimokwu. ");
INSERT INTO paoNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Saa'a soo Te Pabe'e numme-baasoo tapua petusoo ka banunadu, Tiberius mee naneadu-kumaba'yoona. 'Yoo yise namani. ");
INSERT INTO paoNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Numme, Simon Peter, Thomas Nathanael, e pabe'e James mee naneadu, yise waha'yoo tunakatzimodu, nanano o. ");
INSERT INTO paoNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Soo Simon Peter meeoo, “Nu tuukwigakwu.” Numme meeoo, “Numme u-no.” Numme yise sake-wi mea'a, pana togamano gi hemma tzakadu. ");
INSERT INTO paoNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Oogow awamooa, unu tu tapuakese, soo Te Pabe'e oona bakumana wunu, pana numme gi oo posopedakwadoo. ");
INSERT INTO paoNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Ne wa'agese meeoo, “E pupua'amu, mu haa'a gi tutzakadu?” Numme yise oo nanekwegea, “Gi tuwazoo.” ");
INSERT INTO paoNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Soo Te Pabe'e yise mee ne netamma, “Ka puma mu tuukwina ka sake tumadinakwatoo tzakweku, mu tuhanehookwu.” Numme yise oo manise, ka tuukwinoo tzamapana, ka ewow pakwe oekoo. ");
INSERT INTO paoNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Nu yise ka Peter meeoo netamma, “Masoo tookwa Te Pabe'e.” Soo Peter yise ka gi besa namasooana, wunagow yaahoose, ka baa-witoo nadawunihoose, bakumabatoo bahabehooka. ");
INSERT INTO paoNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Numme yise o nageka ka sake-wi, ka tuukwinoo ewow pakwe oekoo oo wupewo'yana. ");
INSERT INTO paoNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Numme ka bakumana petuhoogase, numme oo poonne, onoko nabedana pakwe, noko tukaba, o nanohotuku. ");
INSERT INTO paoNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Soo Te Pabe'e meeoo ne netamma, “Maka pakwe mu tutzagadu-matu hanehooke.” ");
INSERT INTO paoNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Simon Peter yise meahoose ka puma tu tuukwipu bakumabatoo tzabewo'yahoo. Ewa'yoo (153) papabatse'yoo pakwe pana soo puma mu tuukwipu gi natzakebue. ");
INSERT INTO paoNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Soo Te Pabe'e meeoo ne netamma, “Mu tukanna.” Numme gi mee oo tubengu, “Haga u?” nnumme ka mooasoo oo sopedakwadoona. ");
INSERT INTO paoNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Soo Te Pabe'e yise tukaba noko pakwe ne maka. ");
INSERT INTO paoNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Toge pahe (3) soo Te Pabe'e numme tunakatzimodu natzapoonnekute, ka tu ya'e-kwikoo namayodase. ");
INSERT INTO paoNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Ka ne tukamakwuse, soo Te Pabe'e ka Simon Peter meeoo netamma, “Simon, u John tooa. U haa'a noko hemma ooonakwasoo besa e soobedya?” Simon mee oo nanekwegea, “Aha, ne Pabe'e, u oo sopedakwatoo nu ume pua'a.” Soo Te Pabe'e yise meeoo oo netamma, “Umu nu-kwi tunaka'oedyukudu mabetsea.” ");
INSERT INTO paoNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Soo Te Pabe'e mee tuwazoo oo tubengasoo, “Simon, u haa'a unu e soobedya?” Soo Simon oo nanekwegeasoo, “Aha, Ne Pabe'e, u oo sopedakwatoo nu ume pua'a.” Soo Te Pabe'e yise meeoo oo netammasoo, “Ka umu nu-kwi tunaka'oedyukudu mabetsea.” ");
INSERT INTO paoNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Sumu tuwazoo soo Te Pabe'e oo tubengasoo, “Simon, u haa'a e pua'a?” Ka Peter suda nenuuma soo Te Pabe'e ka oo tubengasesoo, “U haa'a e pua'a?” Soo Simon meeoo, “U Ne Pabe'e, u no'okosoo hemma sopedakwatoo. U oo sopedakwatoo nu u pua'a.” Soo Te Pabe'e yise meeoo, “Umu nu-wi tunaka'oedyukudu mabetsea. ");
INSERT INTO paoNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Nu togesapa u tuukwekwu, tooebetse'ena u tooe hano tooe mesoo mea u petzabe-kwitoo. Pana u ka mooatupuyise kukumma'yoosoo numu u mitzakunakwu yise u tayakwu, gi u soomea-kwitoo.” ");
INSERT INTO paoNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","'Yooonnekoo soo Peter ka Te Naa-koobatoo nabatsakwu, me'esoo Te Pabe'e unnena. Yise meeoo oo netamma, “Nuka nageno.” ");
INSERT INTO paoNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Peter wesase e poonne, tu nakwi e me'a. ");
INSERT INTO paoNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Soo Peter yise ka Te Pabe'e tubengu, “Ne Pabe'e, Ha'oo yise masoo manekwu?” ");
INSERT INTO paoNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Soo Te Pabe'e Jesus oo nanekwegea, “Sumuna masoo nummennummekwu e kodyu-kwitootooe esoo gi ume pukwitoo suda soonammena. U sakwa nuka nage-no.” ");
INSERT INTO paoNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Ooonne'yoona susumudu tunaka'oedyukudu meeoo, “Soo John gi ya'ekwu.” Esoo gi togesapa. Te Pabe'e meeoo sukwe unakwe, “Sumuna masoo nummennummekwu e kodyu-kwitootooe, esoo gi ume pukwitoo suda soonammena.” ");
INSERT INTO paoNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Nu oosoo mu tunakatzimodu-matu oo poonnedu o botugu, ka a namanena. Tamme no'yoona oo sopedakwatoo esoo e tubona kaaheno'yoo a namanena. ");
INSERT INTO paoNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Soo Te Pabe'e ewa nanabesa pooha manakwe tuwazoo, nu gi toge besa no'oko mu bo-wa'ne'yoo, umu ewa'yoo. Nu umu-matusoo mu bokute, o'no mu punno'o ka Te Pabe'e-wi tunaka'oedyukukwu.");
INSERT INTO paoNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","5","Ka mooe'ugasoo numu-matoo tubose ka Te Pabe'e mane-kwitu mu tuukwe'e, yise ka mu numu yaa teepu-koobatu tunedyooe, o'no yise ka Te Pabe'e tu tunakatzimodu oo tunetammakuna mu tuukwe'e. Ka Te Pabe'e nabatsase oosoo tu ya'e-kwikoo namayodase umu pumme nakatzimodu ewasoo natzapoonekute. Ka Te Naa numu magwetzoina mu tuukwe'e. Mee tuwazoo mu netamma, “Soo John puu mu sootuhina baa-wi mu matzaka. Pudusoo soo Te Naa tu Besa Pooha-ma mu sootuhikwu. Mu sakwa Jerusalem-wi tuutooepunne ka Te Naa mumme sootuhi-kwitoo tooe.” ");
INSERT INTO paoNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Soo Te Pabe'e umu tu tuukwewabe-no oona giba-ma nanatapoegease, umu meeoo oo tubenga, “U haa'a yabesoo tamme Jew numu ka mu Tibo'o-makoo natzama'wukwuna natuungu umu yise gi te nemadunagakwu?” ");
INSERT INTO paoNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Soo Te Pabe'e meeoo mu nanekwege'a, “Mu gi oo sopedakwatoo ka hemma oo manekwuse, Te Naa ookow soomadabuekwu ka hemma oo manekwuna. ");
INSERT INTO paoNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Pana Te Naa Besa Pooha-ma mu nasootuhikwu. Oosoo mu pooha makakwu. Mu yise no'oko mu numu nu-kwitu tuukwemokwu: Mu numu Jerusalem-witu, Judea no'oko Samaria mee nananeadu teepu-koobatu tuwazoo, tooe hanotu tooe, tooe haga tooe ka teepu-koobatu.” ");
INSERT INTO paoNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Soo Te Pabe'e yise ka yadooamakwuse, toogoopatoo ka koomeba-naga tsobakase yise tubetse mea. ");
INSERT INTO paoNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Umu oo tuukwewabe oo poonnepunne. ");
INSERT INTO paoNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Mooasoo oo tsobakase sapa toogoopatu poonnepunne, waha'yoo toha kakasa-ga'yoo toha kwakwaseyaadu umu-baa petuse, meeoo mu netamma, “Toogoopatu poonnemakwu. Te Pabe'e Te Naa-matoosoo kodyuhooka. Sumu tabeno oosoo yaa teepu-koobasoo kodyu petukwu tu mea tabua-kwa'nesoo petu tabuadooa.” ");
INSERT INTO paoNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Mu oo tuukwewabe tubongosoo kodyu ka giba, Olive mee naneadu-ma'yoo, ka Jerusalem mee naneadu-kwitoo katzage'e o namea. ");
INSERT INTO paoNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Umu ka Te Pabe'e tuukwewabe tunetutzeana mee nananeadu: Peter, John, James, Andrew, Philip, Thomas, Bartholomew, James, Alphaeus tooa, Simon Zealot, Judas, James tooa. Ka Jerusalem-wisoo petuse ka waha nakooba yugwedu nobe-kwi huudooe tooipunne. ");
INSERT INTO paoNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Oowe'yoonow umu yise nanano nanesootuhiyakwe. Oosoo Te Pabe'e Jesus pea umu oo wanga'amu yise ewa'yoo momoko'ne umu-no. ");
INSERT INTO paoNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Sumu tu nanesootuhino'o, ewa'yoo (120) numu oe'yoona nanesootuhi. Soo Peter yotsese ka mu numu yadooe, meeoo yise mu netamma, ");
INSERT INTO paoNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","20","“E nanumu, tamme sakwa sumuoo nana netutzea ka numme Te Pabe'e tuukwewabe-no nadatsungakwudu. O'nosoo soo Judas uga numme-nagatu Te Pabe'e tuukwewabena natutzeadu. Pana yise oosoo ka mu tukwutumadu-matoo Te Pabe'e nemawuni, umu yise ka Te Pabe'e wutumase yise oo batsa.” Soo Judas ka suda tu tumadugu-kwi natumunagakute yise ka pumme tu tumanagaku-ma tubewa tumu. O'no yise ka suda nuummakese, puusoo nabatsa. Oosoo-kobena-tamme aanooaka. Ka tu sapu wubadow petuse, oo sagwa no'yoona tseboogeke oosoo yise ya'ehoo. Mu numu Jerusalem-wi nonobe-ga'yoo ka oo nakase yise ka tubewabe Pukwitu Nabatsapu mee'e oo ne'a. Soo Peter ka mu numu puno nanesootuhidu mee tuwazoo netamma, “O'nosoo soo David yise meeoo unakwe ka tu hoobeadoo-kwi soo Judas 'yoo manekwu mee tubopu, ‘Oosoo yise ka ya'ese, saa'a gi nasooma'yukwu.’ Sumuba tu hoobeadoo-kwi meeoo, ‘Kumma'yoosoo numu sakwa oo kapi nanekatuku.’ ");
INSERT INTO paoNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Tamme sakwa kumma'akoosoo numu netutzea ka Judas kapi ka Te Pabe'e-witu mu numu tuukwekwudu. Esoo nanetutzeadu sakwa oe manakwanasoo ooosapa tamme-no kemmadabedu ka John numu baa-wi matzakano'o manakwana yise ka Te Pabe'e nabaatoo pumme oo bino'otoo tooe.” ");
INSERT INTO paoNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Mu numu yise ka Peter meeoo unakwe oo nakapunnese, o'no yise mu numu waahoo nanana Matthias noko Joseph mee nananeadu netutzea. ");
INSERT INTO paoNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","25","Yise meeoo nanesootuhi, “U no'oko numu gi watzekudu. Yise u tunetutzeana ne tuukwe ka Judas kapi manedu, ka Te Pabe'e mu numu oo tuukwe-kwa'nesoo.” ");
INSERT INTO paoNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Ka onow ka mu numu tumayoho-kwikoo umu ka mu numu netutzea. Soo Matthias yise nanetutzea, numu-no Te Pabe'e-witu tuukwewabe-matu-no nadatsunga. ");
INSERT INTO paoNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Yise, o'no ka tunayasamakwuse, mu tunaka'oedyukudu nanano'o sumu, ka o'no tabewa-wi ka Te Naa-matoo nanesootuhina. ");
INSERT INTO paoNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Gi obeda yise unu hukwadu-kwa'ne nanakabetu, yise pa'anakwana ka nobe-kwi kangabetu. ");
INSERT INTO paoNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Hee goso-ga-kwa'ne'yoo no'oko umu-ma aatahoobetu. ");
INSERT INTO paoNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Oosoo Te Naa Besa Pooha mu tzapoonnekuna ka Te Naa umu sootuha'e. Oosoo Te Naa Besa Pooha no'oko umu oe manepunnedu, sootuhihoo umu yise nanakumma'amakoosoo yadooape-ma apegeakooha. ");
INSERT INTO paoNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","11","Ewa'yoo nananesootuhidu umu tzage'e nonobe-ga'yoo. Nanakumma'akoosoo teepu-koobatoo nadooamudoopu, pana meno'o yow Jerusalem-wi. Ka mu nakase, umu punno'o sumuhoo. Gi umu oo nakasopedakwatoo yise nanatubengamo'o, “Tamme nanakumma'akoosoo teepu-koobatu kemmana pana umuoo nanana no'yoona Galilee-witu. Ha'oo yise umu no'oko tamme yadooa-ma apegeagonno? Tamme nanasusu'mu'yoona mu naka ka tamme yadooa-ma mu apegeagonno ka no'oko ka Te Naa besa tumaduguna mu wahagonno.” ");
INSERT INTO paoNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Meeoo yise nananetamma, “How namani?” ");
INSERT INTO paoNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Umu-matu meeoo unakwe, “Umu tookwa baako'e.” ");
INSERT INTO paoNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Mu tuukwewabe yosuhoose, soo Peter paba yadooa ka mu Jew numu meeoo netamma, “E pupua'amu, besa e nakapunne. ");
INSERT INTO paoNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","‘Baako'e’ mee umu ne netamma. Gi numme. Tamme Jew numu gi atsa tutza'emukwa baa hebedu awamooasoo, ka gisoo tukana. Meno'o togesoo sumu kadoo'oopu-kwi (9) taba-gatu. ");
INSERT INTO paoNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Yowsoo Te Naa yadooawabe o'nosoo tamme oo tuukwepu. Te Naa yadooawabe Joel mee naneadu, mee tubotugupu, ");
INSERT INTO paoNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Te Naa meeoo te netamma, ‘Nu gisoo ka teepu atasoo yugwena, nuga pooha-matu no'oko nana'atakoosoo numu nanakumma'akoosoo poohabe-matu-ma sootuhidooa. Mu doodooamu tooe saa'a a unnena wahadooa. Tootooebetse'e saa'a pooha tuusoobedyadooa. Mu wakwa'etse saa'a punno'o pooha nosedooa. ");
INSERT INTO paoNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Mu momoko'ne, mu nanana e naka'oedyukudu saa'a nu E Besa Pooha-matu-ma sootuhidooa. Umu yise e unnepu wahamodooa. ");
INSERT INTO paoNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Tooe hownnekoo tooe saa'a nu mu tsapoonnekudooa ka hemma oo manekwuse, ka teepu-koobatoo tooetoo mu pa'anakwatoo: puupe, goso, kweedaba. ");
INSERT INTO paoNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Ka o'no tabeba-wi ka teepu atasoo oo yugwekwuse mu notu tonumapunnekwu. Soo muha unu atsakwedyana puupe-kwa'ne tabuadooa. ");
INSERT INTO paoNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Pana no'oko nuka nanetzakwiyidu nu magwetzoidooa.’ ");
INSERT INTO paoNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","E pupua'amu, soo Jesus Te Pabe'e. Soo Te Naa meeoo unakwe, ‘Oosoo Mu Pabe'e,’ mee'e. Mu oo sopedakwatoo ka besa mumme oo tumadugukupu ka Te Naa pooha-ma. ");
INSERT INTO paoNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Pana mu yise ka oo-ma tu natzakaduse, mu ka gi tunaka'oedyukudu wakwawa'a ooka batsa tuungu, ‘Pa'a o taposa,’ mee mu netamma. ‘Mu tunetamma-kwa'nesoo mu mani,’ mee soo Te Naa. ");
INSERT INTO paoNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Oo tunetamma-kwa'ne, gi tubetse ya'e saa'a petudooasoo. ");
INSERT INTO paoNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Soo Te Naa yadooawabe David mee naneadu ookow waha ka Te Pabe'e-witu te tuukwepuna. ‘Nu oo sopedakwatoo soo Te Naa ooosapa nu-notu. Nu gi hownnekoo nammayamoa-wa'ne'yoo ka ooosapa Te Naa nuka mabetsea. ");
INSERT INTO paoNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Nu yise besa soonamme oo nesookwaga'ena ka Te Naa mee oo netammana, nu oo sopedakwatoo e ya'ekwuna e namayodakwuna e nummekwunasoo. ");
INSERT INTO paoNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","U, Ne Naa gi e ya'ena petzape. U gi suda e tookoo manena soopetzape. ");
INSERT INTO paoNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Nu ka umetuna. U e magwetzoikwusesoo. Nu yise u-baa'yoona tubetse besa soonammekwu,’ mee soo David tubo. ");
INSERT INTO paoNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","E nanumu, ka David-witu nu mu tuukwekwu. Tamme oo sopedakwatoo ka o'nosoo ka David tamme mooe tuukwe'e. Oosoo puu ka ya'ese, natuguse, tamme oo sopedakwatoo ka pukwi oo nakoopu. Oosoo gi nakwitusoo waha. Oosoo Te Pabe'e-witu te tuukwe. ");
INSERT INTO paoNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Soo David oo sopedakwatoo ka Te Pabe'e saa'a nuugwekwuna. Soo Te Naasoo meeoo ka David tuukwe'e, ‘Sumu'yoo mu-nagatu Te Pabe'e manedooa. Oosoo mu nanumu moohedooa u-kwa'nesoo.’ ");
INSERT INTO paoNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Soo David ooka te tuukwe soo Te Pabe'e gi tubetse ya'e oo tookoo gi pehekwu. Oosoo tu ya'e-kwi'yoona namayodakwu. ");
INSERT INTO paoNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","33","Te Naasoo tuwow nakumma-baatoo oo ba'e, ka Te Pabe'e pooha-maka. Meno'o yise soo Te Pabe'e tu Besa Pooha-matu-ma ne sootuhi. Tamme oo nakana oo poonne. Soo Te Pabe'e toogoopatoo meapu. ");
INSERT INTO paoNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Soo David gi oo manakwe. Soo David ookahoo waha Te Pabe'e-witu meeoo unakwe, ‘Soo Te Naa ka Te Pabe'e nabaa katu tuungu. ");
INSERT INTO paoNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","Oosoo yise ka umu oo wokwohomu matzooekukwu.’ ");
INSERT INTO paoNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Ka Te Pabe'e-witu sakwa tamme Jew numu unusoo sopedakwatoo. Mu oo batsapu pana yise soo Te Naa ka Te Pabe'e oo mayugwese yise saa'a soo Te Pabe'e numu nemadunagakwu.” ");
INSERT INTO paoNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Umu numu ka Peter nakase, unu suda oo sokwamakuna ka tu manena yise meeoo oo netamma oo poena'ewabe-nokosoo, “Ha'oo sakwa numme manese kaaheno oo mayugwe?” ");
INSERT INTO paoNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Soo Peter mu nekwegease meeoo, “Mu sakwa ka suda mu manena ma'wu, baa-wi namatzakase mu numu ka Te Pabe'e naka'oedyuku. O'nosoo Te Naa no'oko mu sootuhise te ma'emukwana soomu'wakwunise ka Tu Besa Pooha-matu-ma mu sootuhi. ");
INSERT INTO paoNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Oosoo Te Naa unnegeapu mee, ‘Mu nanumu, mu dooamu, yise no'oko numu mana kwinga'a-kwitu no'yoona e tunetutzeana, umu e dooamu manekwu,’ mee unnena.” ");
INSERT INTO paoNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Soo Peter ewasoo meeoo mu numu tuukweyakwe, yise meeoo mu netamma, “Mu numu ewa suda manakwe yow meno'o. Soo Te Naa gi mu sootuhikwu, gi umu-wa'ne manepana, o'no saa'a mu namagwetzoikwu.” ");
INSERT INTO paoNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","42","Ewa'yoo (3,000) numu ka Peter naka'oedyuku ka o'no tabeno, umu baa-wi namatzaka. Umu nanesootuhiyakwe ka Te Naa tuukwewabe tu nakana pumme tunedyooe. Ka Te Pabe'e nabatsase oo soomayuna nanano tukana no'oko hemma nanatummatzina. ");
INSERT INTO paoNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Mu nanana Te Pabe'e tuukwewabe Te Naa besa pooha-toohakwi ewow numu mabesakuyakwe, nanasookwugi tumada'e. ");
INSERT INTO paoNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Mu Te Pabe'e-wi tunaka'oedyukudu no'oko ka hemma nanatummatza'e. ");
INSERT INTO paoNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Mu numu ewow hee-ga'yoo oo-ma tumuna, yise mu gi hee-gakoo tummatza'e. ");
INSERT INTO paoNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Nonotza tabeno ka pabow nanesootuhi nobe-kwitoo meayakwe. Nanano tukayina tu pupua'amu nobe-kwi'yoona tooe ka besa nanano sokwamana, ");
INSERT INTO paoNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","ka Te Naa-matoo nanesootuhidyina. No'yoona mu numu nesookwuga'e ka mu besow umu tunaka'oedyukudu nono'otsa tabeba-wi nana'ewasoo maneno'o ka Te Naa numu magwetzoa'e ka nanano mu nanesootuha'e. ");
INSERT INTO paoNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Nonotsa tatabeno pahe-kwikoo ka taba katu nananesootuhiyakwe, mu Peter-no John ka pabow Jew nanesootuhi nobe-wikoo nanesootuhiyakwe. ");
INSERT INTO paoNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Soo sumu'yoo nana ka tuha'yoonasoo gi nummedu natzakwu petuyakwe. Besa Tabuadu tupe koodua natzakwona'a mee naneadu-kumaba'yoo, soo nana oo natzatuguna mu numu nanesootuhigadu tukumi meadu tunekwi tabeyakwe. ");
INSERT INTO paoNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Sumu tabeno soo nana pumme tu tzakwumena, mu Peter noko John wegease, “Puma e tumukwuna e gea,” mee mu netamma. ");
INSERT INTO paoNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Umu yise besa oo poonnese soo Peter meeoo oo netamma, “E nakapunne.” ");
INSERT INTO paoNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Oosoo nana besa mu poonnekwunihoose yise meeoo soonamme, “How gina hemma e geakwu?” ");
INSERT INTO paoNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Soo Peter yise meeoo, “Nu gi hemma hee-gapana nu sakwa ka Jesus pooha-ma u tummatzi. Soo Te Pabe'e Jesus te ooonakwa naduyadu besa u mesoo yukwe u numme manikwu. U sakwa ka Te Pabe'e Jesus pooha-ma yotsehoose nummehoo meno'o.” ");
INSERT INTO paoNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Soo Peter yise ka nana gi nummedu oo mi-makoo oo tzadyota. O'no yise soo nana mesoo wunuoose, o natakwuninumme. ");
INSERT INTO paoNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","10","Ka besa tu kowpa noko tu tawetzoko natzooe manise ka Solomon haba mee naneadu-toohatoo, yise mu Peter noko John-no meahoo. Ka besa manise, ka Te Naa nanesootuhi numme. Mu numu yise oo poonnese meeoo unnegonno, “Yowsoo nana ka Besa Tabuadu tupe koodua natzakona'a-kwi'yoona numu ka hemma puma tu tumukwina natuungu katuyidu.” Ewa'yoo mu numu oo poonnese oo nesookwuga'e ka besa oo manise. ");
INSERT INTO paoNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Ewa'yoo mu numu sookweda kemma'ase ka nana mu Peter noko John-kumaba, ka haba Solomon mee naneadu-tooha mu konno mu poonne petuse, “Uune! U oo mabesaku,” mee mu numu unne. ");
INSERT INTO paoNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Ka mu numu petugonno, soo Peter meeoo mu netamma, “E nanumu, gi tammesoo pooha nanesootuhi-makoo soo nana besa mani. Gi meeoonekoo tusooyugwepana. ");
INSERT INTO paoNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","16","Ka Te Pabe'e Jesus pooha-toohakwi soo nana besa mani. Soo Te Naa te tuukwe'e ka tu Besaa Tooa'a Jesus Te Pabe'e. Tooe soo Te Pabe'e ooosapa ka Te Naa nakabetseadu pana mu oo batsa. Soo Pilate ka Te Pabe'e too'e netzama'wu. Mu yise ka Pilate meeoo netamma, ‘Gi oo tzama'wupana.’ Mu yise ka Pilate o'nosoo numu batsapu tzama'wu tuungu. Mu oo batsa ka numu gwetzoibu geadu pana Te Naa ka Te Pabe'e mesoo mayodu ka oo ya'ese. Numme nummesoo no'yoona oo tookoope poonne. Mu oo poonne ka nana gi nummedu. Soo Te Pabe'e pooha besa oo ma'e, numme oo soo'oedyukute ka besa ooka oo yugwese. ");
INSERT INTO paoNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Mu ka mumme moohedu-no ka Te Pabe'e batsa gi ka Jesus Te Pabe'e sopedakwadoona. ");
INSERT INTO paoNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Esoo Te Naa unnepu togesapa. Mooasoo soo Te Naa nanamooatupu yadooawabe o botugu ka Te Pabe'e nabatsakwuna. ");
INSERT INTO paoNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","20","Ka Te Naa sakwa ooosapa nanetzakwiyi yise ka sutakoo nema'wuni. Yise ka besatoosoo nummenumme. Soo Te Naa mu sootuhikwu ka sutakoo mu nema'nunise. ");
INSERT INTO paoNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Soo Te Pabe'e Jesus Te Naa netutseana ebe toogoopatoo meapu ka teepu saa'a atasoo yugwekwuse. O'no soo Te Pabe'e tamme-baa petuse te sootuhikwu. O'nosoo mu Te Naa yadooawabe ka Te Pabe'e-witu te nanamooatupu tuukwe. ");
INSERT INTO paoNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Sumu'yoo umu-nagatu Moses mee naneadu meeoo, ‘Te Naa saa'a tamme-matoo yadooawabe tayadooa, te nanumu-nagatu, nu-kwa'nekoosoo, yadooawabe. Mu sakwa oo nakabetsea saa'a. ");
INSERT INTO paoNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Soo tooe haga tooe gi ka Te Pabe'e tumayohokudu tookwa gi Te Naa doodooamu-matu.’ ");
INSERT INTO paoNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","No'oko soo Te Naa yadooawabe Te Pabe'e-witu te tuukwe. ");
INSERT INTO paoNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Yow tamme Te Naa doodooamu Te Naa yadooawabe-kwa'ne. Te Naa te sootuhi tamme o'nosoo tu tuukwe-kwa'ne. No'yoona tamme ekow sopedakwatoo. O'nosoo soo Te Naa ka sumuoo te nanumu-nagatu Abraham mee naneadu meeoo netamma, ‘Saa'a soo sumu'yoo u-ma'yoo tsuaketu petukwu. Mu no'obatusoo nana'atakoosoo numu nu sootuhikwu, ka hemma oo manese.’ ");
INSERT INTO paoNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Soo Te Pabe'e mooasoo tamme-baa petu. Soo Te Naa ka Te Pabe'e oo ya'e-kwikoo oo mayoduse, tamme mooe tuukwe. Oosoo te sootuhikwu ka sutakoo po ooemota te nakwumunase.” ");
INSERT INTO paoNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","4","Ewa'yoo (5000) numu tunakapunnedu ka Te Pabe'e Jesus-witu naka'oedyuku manepetuga. Ka Peter togesoo mu numu yadooewunu, mu numu nananesootuhidu Sadducee mee nananeadu-nagatu, mu Jew tukwutumadu-no oe petuhooga. Mu Sadducee ka gi numu namayoda-kwi tunaka'oedyukute. Umu ka Peter sutakute ka meeoo numu oo tunedyooe soo Te Pabe'e ka ya'ese namayoda. Mu Jew natukwutumawabe ka Peter noko John tukwutuma nobe-kwi wudumedow, ka mooasoo o togano-ga'a, nagutza saa'asoo ooka tu nehane-kwi. ");
INSERT INTO paoNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Oogow mooo'a mu Jew tutunehanedu Jerusalem-wi'yoona tunehane. ");
INSERT INTO paoNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Mu numu moohedu mee nanane'a Annas, Caiaphas, John, Alexander, ewow tu nananumu-no oe. ");
INSERT INTO paoNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Mu tutunehanedu yise mu tukwutumadu meeoo netamma, “Ka Peter noko John ne kobenatoo bitooa,” mee'e. Ka mu nabi petuhoose, mu tutunehanedu mu mooe ohobu tubengakooha. “Haga pooha-ma mu ka gi nummedu mabesakupu? Haga ooka mu mabesaku tuungu?” ");
INSERT INTO paoNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","9","Soo Peter ka Te Naa Besow Pooha-toohakwi mu Jew tutunehanedu nanekwegea, “Ha'oo mu ka besa ne manakwe sapa mu gi besa mee netamma? ‘Haga pooha-ma mu ka nana besa mayugwe?’ mee umu. ");
INSERT INTO paoNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Numme no'oko mu Jew numu noko mu tuukwekwu. Soo Te Pabe'e pooha besa oo mayugwe. Tooe mu ka Te Pabe'e batsa tuunguse sapa, soo Te Naa Pooha yise oo ya'e-kwikoo oo miyoda. Ookowsoo pooha-ma soo nana namagwetzoi. ");
INSERT INTO paoNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Ka te mooa nayadooawabe tubo-kwa'nesoo manekena mee'e, ‘Soo mumme nanesootuhi moohedu ka pumme tu tupe-makana wuni, soo Te Naa meeoo ka puma tu nobe-tookwuna netamma, “Mow soo tupe tubetsetu.” ’ Soo Te Pabe'e ookow tupe-kwa'ne'yoo. ");
INSERT INTO paoNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Te Pabe'e Jesus suu'mu te magwetzoikwudu. Gadoo'oo haga oogow-kumisoo te magwetzoi-wa'ne'yoo.” ");
INSERT INTO paoNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Mu tutunehanedu mu sopedakwatoo ka mu Peter noko John gi natunedyooepu yise mu tumadugu-kwitu sopedakwatoo ka Te Pabe'e Jesus-witu gi nasookwina mu waha. Mu Jew numu moohedu mu nesookwuga'e. Mu Jew tutunehanedu mu sopedakwatoo ka Te Pabe'e mu naka nagemo'o. ");
INSERT INTO paoNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Soo nana namagwetzoipu ooka Peter noko John-kumabasoo wunu, gi hownnekoo umuoo yise ha'yoo mu netamma-wa'ne'yoo. ");
INSERT INTO paoNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Mu tutunehanedu mu Peter noko John puuwanatoo tayahoo. ");
INSERT INTO paoNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“Ha'oo sakwa tamme mu naana sootunaga?” mee yise unnemo'o. Yise meeoo, “No'yoona mu numu Jerusalem-witu mee unakwe, ‘Masoo nana Te Naa pooha-ma besa manepu-ga'yoo!’ Gi hownnekoo tamme oo nesootu'adyae-wa'ne'yoo. ");
INSERT INTO paoNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Tamme sakwa mu naana neta, umu sakwa gi ka Te Pabe'e pooha-witu ka mu numu tuukwepana.” ");
INSERT INTO paoNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Mu Peter noko John oetusoo bise yise meeoo mu netamma, “Gi mu numu tuukwepana ka Mu Pabe'e pooha-witu.” ");
INSERT INTO paoNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Soo Peter yise meeoo mu tutunehanedu netamma, “Mu oo sopedakwatoo ka besa oo manepunnena, numme haa'a ka Te Naa nakabetseakwu pute mumme? Numme ka Te Naa nakabetseakwu gi mumme. ");
INSERT INTO paoNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Numme gi hownnekoo ka mu numu ka Te Pabe'e-witu tuukwemakwu-wa'ne'yoo.” ");
INSERT INTO paoNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Mu tutunehanedu tooe how tooe mu yugwekwu ka Te Pabe'e-witu gi mu wahamakwu. Umu yise mu sukwe tzama'wu ka gi hekwi sapa meeoo mu netammana. Mu tutunehanedu mu numu-ma sua'e ka Te Naa-matoo mu nanetzakwiya'e ka hemma manekwi. ");
INSERT INTO paoNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Soo Te Naa magwetzoipu nana mooasoo watsu mano tomopu (40). ");
INSERT INTO paoNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Mu Peter-no John yise pumme tu tzama'wuse, tu pupua'amu-matoosoo kodyuka. Mu Peter-no John yise mu tunehanedu unnena mu tuukwe'e. ");
INSERT INTO paoNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Umu yise no'yoona oo nakase, nanesootuha'e, Te Naa-matoo mee unnemo'o, “Te Naa numu manumudoopu. U no'okosoo hemma madidu. U no'okosoo hemma ne nemadunagapunnedu. ");
INSERT INTO paoNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","U, Ne Naa, ume pooha ka o'nosoo ne nanumu David mee naneadu ka ume naka'oedyukudu tubo tuungupu u-kwitu. ‘Mu wakwawa'a unu sutakugonnona ka Te Naa unu netumoo'oona oo-no nagoe sokwama pana gi how mane-wa'ne'yoo. ");
INSERT INTO paoNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Ewa'yoo nanakumma'yoosoo numu moohedu nana-no tooe how tooe ka Te Pabe'e Jesus Te Naa tuutzeana mooe yugwekwu,’ mee'e ");
INSERT INTO paoNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Meno'o tamme ekow poonne mesoo David yadooapu ka Herod-noko Pontius Pilate mu tukwutumadu-no mu te nanumu Jew-no tuwazoo apegea ka Te Pabe'e batsakwu mee unnena oosoo ume nakabetsea. U, Ne Naa, tunetutzeana, Te Pabe'e mee'e u. ");
INSERT INTO paoNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Ume tunetammana yoo saa'a manedooa. ");
INSERT INTO paoNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","U, Ne Naa, oo sooma'yu mu tunehanedu naana ka Peter noko John manayahakwu mee. Gi mu tutunehanedu naana-ma ne suikwununumme u natuungu, no'oko numu u-witu numme mesoo tuukwedooa. ");
INSERT INTO paoNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","U pooha-gana mu numu numme tzapoonnekukwu. U, Ne Naa, mu tuoegoedu besa manekwuna, ne tzapoonekwuna u pooha-ga'yoo.” ");
INSERT INTO paoNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Ka nanesootuhimakwuse soo mu nobe wudyutsungawunu. Oosoo Te Naa Besaa Pooha oo wudyutzengewunu. Oosoo Te Naa Besa Poohasoo umu wumana, umu gi sua'ena ka Te Naa unnena wahagonno. Umu yise ka Te Naa unnena mana kwaya'a-kwidooe wahammo'o. ");
INSERT INTO paoNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","O'no yise no'yoona mu tunaka'oedyukudu besa nana-matoo sokwama. No'okosoo hemma nanatummatza'e, gi hemma nananetumoo'e. ");
INSERT INTO paoNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Mu tuukwewabe meeoo ka Te Pabe'e-witu waha, “Soo Te Pabe'e ka namayodase tusootabuese, yise ka Te Naa pooha mu numu tzapoonnekute.” Soo Te Naa ka mu tunaka'oedyukudu sootuhi. ");
INSERT INTO paoNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","35","No'okosoo hemma mu tunaka'oedyukudu hee-ga'yoo ka Te Pabe'e tubewabe noko nobe-ma mu tumukukwu ka oo mu soomanakwe. Mu Te Pabe'e tuukwewabe tumasumudoona mu numu yise gi hee-gakoo ka hemma mu sookwina oo-matoo mu hanekute. ");
INSERT INTO paoNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Sumu'yoo nana Joseph mu Te Pabe'e tuukwewabe Barnabas mee oo ne'a, puusoo tubewa-ga'yoo ");
INSERT INTO paoNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","ka tubewa-ma tumuse, no'oko pumme tu tumanagakuna ka Te Pabe'e tuukwewabe heme. ");
INSERT INTO paoNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Pana soo nana Ananias mee naneadu, ka tu nodukwa Sapphira mee naneadu-no tu hemma-ma tumukwatekwu. ");
INSERT INTO paoNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Ka tu nodukwa-no oo nanenagana naamookwitoo mu hemekwu mee tunetamma. Ka oona mu tuukwewabe nobe-kwi petugase, a naamookwitusoo mu hemese, mee mu netamma, “No'oko nu mu hemekoo.” ");
INSERT INTO paoNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Soo Peter yise meeoo oo netamma, “How u yise manena u ka sutakoo nakabetsea? U yise ka Te Naa Besa Pooha nemooagana oo-matu manumaku ka tubewa-koobatoo, ne esayaekute, ‘No'oko numme mu hemekoo,’ mee ne tuukwena. ");
INSERT INTO paoNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Mummetu uga soo tubewabe ka gisoo oo-ma u tumu'u. Ka tubewabe-ma mu tumuse, soo mu natumunagakuna mummetu mani. Haoo u manena suda manakwe? ");
INSERT INTO paoNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","6","U Te Naa nemooaga, gi ka mu nanana suu'mu.” Ka meeoo na'unnedu soo Ananias nakase, ya'ehoose, aanooaka. Mu tootooebetse yise oo maputooehoose, oo hanegase, oo tugutooa. No'yoona umu oo nakadu unu sua'e. ");
INSERT INTO paoNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Ka saa'a manekese soo Ananias nodukwa Sapphira oe petuoo. Gisoo tu kooma ya'e-kwitu naka. ");
INSERT INTO paoNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Soo Peter yise meeoo oo tubenga, “Mow haa'a yise no'yoona mu natumanakakuna ka tubewabe-kwitu mu nahemmana?” “Aha, yow sapa ne hemmana,” mee'e soo Sapphira esiyihoo. ");
INSERT INTO paoNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Soo Peter yise meeoo oo netamma, “How manena mu ka Te Naa Besa Pooha soomapoonnetu-kwa'ne manakwe, ka Te Naa gi how mumme oo yukwe sapa?” Soo Peter yise meeoo, “Umu u kooma tugumodu mi pudu tzoonooagena, umu tuwazoo ume ooosoo yugwekwu.” ");
INSERT INTO paoNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","O'no yise Sapphira ya'ehoo, ka Peter-kumabatoo aanooaka. Mu tootooebetse oe tzoonooa petudu mooasoo oo ya'epu oo mayuoo petu. Umu yise oo tzakwuhukase, oona oo kooma-kumabasoo oo tugu. ");
INSERT INTO paoNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","No'yoona mu tunaka'oedyukudu ekow nakase, umu unu nakasui. ");
INSERT INTO paoNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Ka ewow tu nanumu poonnena mu Te Pabe'e tuukwewabe ewow numu mabesakute. Mu numu nanatabooegea besa nanano nanesootuhina, oona ka Solomon mee naneadu haba-wi ka Jew nanesootuhi nobe-kumaba. ");
INSERT INTO paoNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","14","Ewa'yoo mu numu yise Te Pabe'e unnena naka'oedyuku petuga. Gi haga oo sukwe manakwe, umu tubetse manedu. Mu gi tunaka'oedyukudu meeoo nananetamma, “Umu besa ka Te Naa oo naka'oedyukuna.” ");
INSERT INTO paoNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Oona puuwana po-kumaba mu numu tu pupua'amu tuoegoedu tzapokwakute, wegea-kooba tuwow. Ka Peter o-toogoo mea, sumuna o habagana wumase, sumuna besa manekwu mee sokwamana. ");
INSERT INTO paoNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Ewa'yoo numu petudyakwe Jerusalem-kumaba nonobe-ga'yoo tuutooe ka mu Te Pabe'e tuukwewabe besa tuukwena nakana. Umu mu pupua'amu tuoegoedu yise namagwetzoi. ");
INSERT INTO paoNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Soo mu Jew pabe'e ka tu pupua'amu-no unu ka Peter noko John nuusookwedakute. ");
INSERT INTO paoNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Umuoo ka mu Peter noko John pabenase umu nuudumedahoo. ");
INSERT INTO paoNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","O'no togano soo Te Naa tummatziwabe toha kasa-ga'yoo ka Peter noko John-baa wue petuse ka tukwutuma nobe natzakwona'a tzakwonow. Mu Peter noko John oekoo bihookase, meeoo mu netamma, ");
INSERT INTO paoNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Ka nanesootuhi nobe-kumabatoo memeahoo. Mu sakwa ka Te Pabe'e Jesus mumme magwetzoidyi-kwitu mu numu tuukwekwu.” ");
INSERT INTO paoNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Tu tabuagena, oona nanesootuhi nobe-kobena pepetugase, mu numu tunedyoo'e. Mu nanesootuhi pabe'e ka tu pupua'amu-no sumuhoo petuga, mu Jew tutunehanedu-no yise tunehane. Mu tutukwutumadu taya oona tukwutuma nobe-kwitoo mu Peter noko John mu bi tuunguna. ");
INSERT INTO paoNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Ka mu tutukwutumadu oona tukwutuma nobe-kwi petugase, mu Peter-no John kadoo oetu. Punowsoo mease, ka mu tutunehanedu meeoo tuukwe, ");
INSERT INTO paoNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Numme ka tukwutuma nobe natzepunnoe oo mayu ka tukwutumadu tooesoo tu'eya'ekatu, pana mu Peter-no John kadoo oetu.” ");
INSERT INTO paoNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Soo mu Jew pabe'e-no soo nanesootuhi nobe-kooba tukwutumadu naa mu naka, howga mu Peter noko John mani howgena hee manekwu ka yoo hemma manise? ");
INSERT INTO paoNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Sumu'yoo yise petuoose, mu tunehane-kwi'yoona meeoo unakwe, “Yow meno'o mu Peter-no John mu tukwutumana ka nanesootuhi nobe-kobena'yoona mu numu tunedyooe.” ");
INSERT INTO paoNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Mu tukwutumadu naa mu susumudu tukwutumadu-no mea'ase, mu Peter noko John bihoodooa. Mu tukwutumadu gi mu tubetse manoyukwe mu numu-ma su'ina, mu numu sumuna tupe-ma mu tapagetana mu tagoehoodooa. ");
INSERT INTO paoNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Mu numu pabe'e meeoo ka mu Peter noko John netamma, ");
INSERT INTO paoNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Numme mooasoo meeoo mu netammapu, ‘Gi ka Jesus-witu numu tunedyooepana.’ Pana mu no'oko numu Jerusalem-witu ekow tunedyooe. Mu yise ka Jesus nabatsa-kwi numme oe neyugwe.” ");
INSERT INTO paoNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Soo Peter yise ka umu susumudu Te Pabe'e tuukwewabe-no ka mu numu tutunehanedu meeoo netamma, “Tamme sakwa Te Naa unnena mayoho gi mumme sukwe unnena. ");
INSERT INTO paoNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","31","Te nanamooatupu pumatoo nanetzakwiyina soo Te Naa ka Te Pabe'e tamme-matoo tayapu. Mu ka sunngabe namadabue-ma oo tzakwenese, oo batsapu. Soo Te Naa ka Te Pabe'e Jesus ya'e-kwikoo mayoduse numu oo moohe tuungupu. Ka mu numu suda tumadugupu mu nemawuni tuunguna, o'no yise soo Te Naa ka suda mu tumudugupu soomu'wu. Soo Te Naa ka Te Pabe'e numu oo magwetzoi tuungu. ");
INSERT INTO paoNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Numme ooosapa mu numu tuukweno'o soo Te Naa yise ka tu Besa Pooha-ma mu tunaka'oedyukudu sootuhi. Soo Te Naa Besa Pooha ka mu numu tzapoonnekute Te Pabe'e pooha-ga'yoo.” ");
INSERT INTO paoNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Mu tutunehanedu nakasuta'a, ka mu Te Pabe'e tuukwewabe batsakwu ka mee mu tunetamma. ");
INSERT INTO paoNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Soo nana Gamaliel mee naneadu ka nananesootuhidu Pharisee mee nananeadu-matu yotsehoo. Esoo nana numu nanesootuhi tunedyooedu, yise no'yoona numu oo toge'yookute ka besa-tamme. Soo Gamaliel ka mu tutukwutumadu ka mu Te Pabe'e tuukwewabe oetu tzadyuba tuunguse. ");
INSERT INTO paoNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","O'no yise ka mu tutunehanedu meeoo netamma, “E nanumu, ka mu naana-witu mu tunemadabuepu-witu soohane. ");
INSERT INTO paoNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Ewa natomose soo nana Theudas mee naneadu mee'e unakwe, ‘Nu tubetse naduyadu.’ Yise ewa'yoo (400) nanana oo nagemo'o. Ka saa'a oo nabatsase, umu oo nagemodu nanapokise. ");
INSERT INTO paoNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Ka saa'a ka mu numu nadatsu'nga, soo nana Judas mee naneadu oona Galilee tubewabe-witu kemmana mu numu, ‘E nage’ mee mu netamma. Oosoo punno'o nabatsase, umu oo nagemodu nanapokise. ");
INSERT INTO paoNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Mu sakwa yise meno'o umuoo naana gi matzamapana. Mu tzama'wu. Ka sukwe numu unnena suu'mu oosoo gi hee. ");
INSERT INTO paoNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Soo Te Naa ka mu tummatzina mu gi hownnekoo how mu yugwe-wa'ne mu ka Te Naa tumoo'oogana.” ");
INSERT INTO paoNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Oo unne-kwa'nesoo umu manakwe ka mu Peter noko John oetu bise, ka tukwutumadu umu wupageta tuungu. Umu tutunehanedu meeoo yise mu Peter noko John netamma, “Gi Jesus-witu mu numu tuukwepana.” Mu yise natzama'wu. ");
INSERT INTO paoNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Mu Peter-no John yise mu tunehanedu-baa'yoona nemeahoo. Besa sokwamana, “Ta tookwa besa'yoo, o'no ka Te Pabe'e Jesus-koobatoo nuupageta,” mee yise unnemo. ");
INSERT INTO paoNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Ka nanesootuhi nobe-kobena nono'otsa sumuyakwe oona numu nobe-kwi tuwazoo. Umu ka Te Pabe'e Jesus-witu numu tunedyooena, yise no'oko numu ka Jesus Te Pabe'e-witu tuukwe. ");
INSERT INTO paoNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Mu tunaka'oedyukudu ewa manena, yise nananesootzema. Mu Greek-ma apegeadu numu meeoo, “Mu Hebrew-ma apegeadu tutuha manedu pepeawabe ewow tukapu hanekute, pana mu numme-batu Greek pepeawabe gi namaka.” ");
INSERT INTO paoNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Mu Te Pabe'e tuukwewabe no'oko tunaka'oedyukudu nesumudoose mee mu tuukwe, “Numme sakwa ka Te Naa unnepu-witu mu tuukwe. Gi numme yise ooosapa ka mu pepeawabemaka.” ");
INSERT INTO paoNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Natakwasukwuoo (7) naana sakwa netuutsease, umu sakwa mu pepeawabe ooosapa makayi. Umuoo nanana sakwa besa'yoona, Te Naa Besa Pooha-toohakwi unu sokwamana, tunakabetseana. ");
INSERT INTO paoNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","O'no sakwa numme ooosapa mesoo nanesootuhina ka Te Naa unnepu numu tuukwe. ");
INSERT INTO paoNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","No'yoona mu numu yise oo nepesa'yookute. Mu natakwatsukwu'yoo (7) nanana yise nanetutzea. Mee nananeadu: Stephen, Philip, Prochorus, Nicanor, Timon, Parmenas, Nicolaus. Soo Nicolaus yise wawa'a mu Jew numu-wa'nekoo nanesootuhidu, ka oona Antioch mee naneadu-kwitu kemmana. ");
INSERT INTO paoNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Mu tunaka'oedyukudu ka natakwatsukwuoo (7) nanana ka tuukwewabe-baa nabi petu. Soo mu tuukwewabe ka mu natakwatsukwuoo (7) nanana nanesootuhikuse, umu-kooba matugu. ");
INSERT INTO paoNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Ewa'yoo mu numu ka Te Naa unnepu nanatukwena mu tunaka'oedyukudu yise ewa mani petu ka Jerusalem-wi. Ewa'yoo mu Jew numu nananesootuhiwabe punno'o ka Te Pabe'e-wi tunaka'oedyukuna. ");
INSERT INTO paoNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Soo Stephen ka Te Naa Besa Pooha-toohakwi unu tunaka'oedyukute. Soo Stephen numu magwetzoi besa numu yugweyakwe tu pooha-toohakwi. ");
INSERT INTO paoNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Ewa'yoo mu Jew Greek-ma apegeadu ka Stephen-no nanepetukute. ");
INSERT INTO paoNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Soo Stephen unu pooha-gana unu soonammena umu yise gi togebesa how'yoo unne-wa'ne'yoo. ");
INSERT INTO paoNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Ewow yise mu nanana meeoo netamma umu yise oetoo esayina suda oo netamma, “Numme ka Stephen nakana te nanamooatupu tumayohope Moses unnepu gi numu mayoho tuungu. Soo Moses ka te nanamooatupu tumayohona te tunedyooe yise ka Te Naa tunetammana,” mee mu tunehanedu netamma. ");
INSERT INTO paoNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Ooonne'yoona mu numu ka umu pumme moohedu-no gi mu nepetzape. Ka Stephen numu-kobenatoo tzaka oo nehanekwuse. ");
INSERT INTO paoNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Mu oetu esayidu meeoo mu netamma, “Esoo nana ka te nanesootuhina too'e netakonedu, ka Te Naa nobe-kwi yise ka te nanamooatupu tumayohope ka Moses tamme tunedyooepu o gi te tumayoho tuungu. ");
INSERT INTO paoNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Numme yise oo unnena naka ka oosoo nana Jesus mee naneadu te nanesootuhi-nobe kadoo mayugwekwu, te nanamooatupu tumayohope ka Moses tamme tunedyooepu atasoo mayugwekwu.” ");
INSERT INTO paoNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Ewa'yoo mu numu ka tunehanekwi'yoona ka Stephen poonne oo koba atasoo tubuabodote ka unu pooha-ga-kwa'ne oo tapu'a. ");
INSERT INTO paoNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Soo nanesootuhi pabe'e yise meeoo oo tubenga, “Mu numu haa'a togesapa u-kwitu waha?” ");
INSERT INTO paoNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Soo Stephen oo nanekwegease no'oko mu numu meeoo netamma, “E nanumu, e nakapunne. Yaa nanesootuhi nobe-kwi'yoona suu'mu numu nanesootuha'e mee mu unnepana soo Te Naa namooatupu Abraham puu oona kwinga'a mu wakwawa'a tubewa-wi oo manepunne sapa Te Naa-matoo mesoo nanesootuhi, ka Mesopotamia mee naneadu-kwi'yoona. O'nosoo Te Naa ka Abraham natzapoonnekuse, ");
INSERT INTO paoNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","meeoo oo netamma, ‘U sakwa u nobe no'oko u nanumu ma'wukase, kumma'akoosoo teepu-kooba mea. Nu u pukwi'yookwunu u tzapoonnekukwu.’ ");
INSERT INTO paoNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Abraham yise oo tumayohoku. Ka tu naa-no mea ka teepu Chaldea mee naneadu-kwi'yoona mease yise Haran mee naneadu-kwi petuga. Oona'yoona soo Abraham naa ya'e. Soo Te Naa yise ka Abraham ekow teepu, eka tamme meno'o pukwi'yoo-koobatoo oo taya. ");
INSERT INTO paoNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Gisoo soo Te Naa oo teepu maka Abraham yise punno'o gisoo dooamu-ga'yoo. Gisoo soo Te Naa ka teepu-matu oo nemawunikute.” ");
INSERT INTO paoNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Soo Te Naa meeoo tuwazoo oo netamma, “Umu mu doodooamu saa'a wakwawa'a-naga nobe-gadooa. Mu wakwawa'a suda mu matugukwu, unu mu nedya'wena ewasoo tomoba-witoo (400) 'yoo yise namanekwu. ");
INSERT INTO paoNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","O'no saa'a yise mu wakwawa'a tuma'emukwana umu-matoosoo kodyudooa. O'no mu u-ma'yoona tseagekwudu saa'a yaa nu-baasoo nanesootuhi petudooa.” ");
INSERT INTO paoNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Soo Te Naa mu tumayoho tuungu, “Mu sakwa mu naatse doodooamu kootze na'oonnakwitu tsekea'a. O'no umu Te Naa dooamuna nasopedakwatookwu.” Abraham nodukwa naatse dooa'adoo, Isaac mee yise naneahoo. Sumu nasatese soo Abraham yise ka tu tooa tookoo tsekea'a. Ka saa'a yise soo Isaac ka tu tooa Jacob ooosoo yugwe. Soo Jacob yise punno'o umu tu sumumano wahamatsebooeku (12) tu nana'atse ooosoo yugwe. ");
INSERT INTO paoNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Soo Te Naa unnena togesapa manepu, mu Jacob doodooamu yise ka tu wannga'a Joseph mee naneadu unu nuusoogweda. Ooonne'yoona umu yise Joseph gi petzape. Umu oo papabe'e ka Joseph-ma tumu. Mu wakwawa'a ka Joseph tumuse ka Egypt-witoo oo bika. Ka oonow petugase, umu oo-ma tumu. Soo Te Naa ka Joseph sootuhi. ");
INSERT INTO paoNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Tooe how suda ka Joseph namatugu sapa Te Naa oo magwetzoi. Soo Egypt-witu numu moohetu Pharaoh mee naneadu ka Joseph sopedakwadoose, besa tusoohanedu mee oo soopedyana ka Joseph no'oko mu numu Egypt-witu moohe tuungu, pumme tummatzidu tuwazoo moohedu. ");
INSERT INTO paoNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Ka saa'a ka Egypt teepu nana'ena-kwitu gi bow'mana unu pasana gi hee na'a. Mu tubewa-ga'yoo unu suda manepunne. Mu te nanamooatupu gi nadukadu mayu. ");
INSERT INTO paoNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","“Ewa'yoo tukapu ka Egypt-wi,” mee soo Jacob tunaka. Mu tu doodooamu taya tukapu mu tumu tuunguna. ");
INSERT INTO paoNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Ka penakwa tu doodooamu tukapu tumu tuunguse, Joseph tu pabe'emu tuukwe'e, ‘Nu tubetse Joseph,’ mee yise ka Pharaoh-matoo mu bika. ");
INSERT INTO paoNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","15","Soo Joseph yise tu pabe'emu no'oko tu nanumu mu bi tuungu. No'yoona (75) mu Joseph nanumu Egypt-wi petuga. Umu ka saa'a osoo tu'ise punowsoo nahanekese, yow te teepu-wisoo natuoona. ");
INSERT INTO paoNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Ka Abraham o'nosoo mu Hamor numu-makoo mu tubewa tumu-kwi umu natuoona ona Shechem mee naneadu-kumaba. ");
INSERT INTO paoNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Mu numu ewasoo manemena. Soo Te Naa ka Abraham oo tuukwena pudusoo oo-toogoo namanekoo. ");
INSERT INTO paoNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Kumma'yoosoo nana mu numu-kooba katudu manekwu, gi uga ka Joseph heesoobedyadu. ");
INSERT INTO paoNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Oosoo nana mu te nanamooatupu tumoo'ookese suda mu yugwe. Mu numu tu oonga'a puuwana ma'wu tuungu. Umu yise tua'e. ");
INSERT INTO paoNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","O'no soo Moses mee naneadu nadooa'adoo. Besa tabuadu oonga'a. Pahe (3) muha umu nobe-kwisoo oo tzakwatse, ");
INSERT INTO paoNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","o'no yise puuwana ka oonga'a ma'wu. Soo mu numu-kooba katudu padu oo mayuse, yise oo tooaga. ");
INSERT INTO paoNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Ka saa'a yise oosoo Moses no'oko mu Egypt numu manena natunedyooe. Besa hemma how yugwedu. Besa unnedu. ");
INSERT INTO paoNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Soo Moses ka nana manese yise pummesoo nanumu-baa nobenega. ");
INSERT INTO paoNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Ka o petugase, sumu'yoo Egypt nana ka Jew nana unutse mooedyugwe. ");
INSERT INTO paoNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Soo Moses ka Egypt nana tutzagow ka tu nanumu-koobatoo. ");
INSERT INTO paoNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Soo Moses yise meeoo soonamme, ‘Umu e nanumu ka natzama'wukwuse oo sopedakwadookwu ka Te Naa nuka pooha-makase.’ Pana umu gi oo soo'oedyukute ka ooka moo'a oo petugase, waha'yoo Jew nanana nanagoehoo. Mu too'e tzadyooikuse, meeoo mu netamma, ‘Mu e nananumu gi muusoo nanagoepana.’ ");
INSERT INTO paoNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Soo nana unu tu pua'a koosekeowdu ka Moses tomatzakowse, meeoo oo netamma, ‘Numu u nemadunagadu mee u naneyugwe. ");
INSERT INTO paoNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Hownne'yoo u? Etze'e u sumuoo nana patsow. Meno'o haa'a yise u nuka batsakwu?’ ");
INSERT INTO paoNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Soo Moses oo nakase, soogweda meeow wakwawa'a teepu Midean mee naneadu-koobatoo. Oonow petugase oonatusoo nodukwadoose, waahoo nana'atse dooamudoo. ");
INSERT INTO paoNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","31","Wa'etse manekese soo Moses oona giba Sinai mee naneadu-kumaba'yoona, oonatu nipunne oo poonnese oetoo meahoo heega mee soonammena. Ka goso-baa oo petugase, Te Naa goso-wi'yoona oo yatooe. ");
INSERT INTO paoNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Nu yow, mu tubetse manumudoopu. Nu-matoo mu nanumu, mu nanamooatupuna Abraham, Isaac-no Jacob nanesootuhiyakwe.’ Soo Moses oetu tu poonnekwu-ma suise, kwepegawunu. ");
INSERT INTO paoNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Soo Te Naa meeoo oo netamma, ‘U moko tzakwumedow u pooha teepu-kooba 'wunu. ");
INSERT INTO paoNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Mu Egypt numu e dooamu suda matugu nu mu poonne. Mu e dooamu nanepagamo'o. Nu mu magwetzoidooa. Nu ume Egypt-witoo tayakwu. Umu saa'a mu tzama'wudooa.’ ");
INSERT INTO paoNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","36","Mooasoo soo Moses te nanamooatupu tumoodyina. Mooasoo umu meeoo oo netamma, ‘Numu u nemadunaga, mee'e u nane'yugwe. Hownne'yoo u?’ Ekow Moses Te Naa umu-matoo tayakwu. Oosoo mu nemadunagana mu moohedooa ka nidu-kwitu pumme tu pooha-makapu-ma. Oosoo nanasookwugi hemma mu tzapoonnekute ka Egypt-wi'yoona. Yise oona Atsa Baa mee naneadu-kumaba'yoona tuwazoo oosoo watsumano (40) tomoka tu nanumu mooheno'o ka oona gi etzaka tukapu namasua-kwi. ");
INSERT INTO paoNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Oosoo tu nanumu Te Pabe'e-witu tuukwe, “Sumu'yoo te nanumu-matoo petukwu. Nu ka Te Naa tuukwewabe-matu, oosoo punno'o ooonne'yookwusoo,” mee soo Moses tu nanumu netamma. ");
INSERT INTO paoNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Soo Moses tu nanumu-no petu ka giba-kumaba. Oo nobetu-ga ka giba-kumaba, soo Te Naa tummatziwabe soo toha kasa-ga'yoo saa'a oo yadooedooa ka giba-kooba'yoona. Soo Moses saa'a ka giba-ma'yoona wuekese tu nanumu Te Naa pooha unnena tuukwedooa. ");
INSERT INTO paoNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Mu te nanumu gi oo nakabetse'a umu ka Egypt numu tumayohonasoo petzabena. ");
INSERT INTO paoNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Ka Moses ka giba-matoo kodyukasesoo, umu ka oo pabe'e meeoo netamma, “Numme gi ka Moses unnena mayoho-wa'ne'yoo. Soo Moses ka Egypt-nakwana ne bi petu. Pana meno'o hanoga mea. U sakwa pummatoo te nanesootuhikwuna matabuega.” ");
INSERT INTO paoNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Umu yise kootsoo tooa'a-wa'ne tumadabuese, oo-matoo nanesootuha'e. Ewa nanuka ka oo mu tumadabue-matoo. Umu gi Te Naa-matoo nanesootuha'e. ");
INSERT INTO paoNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Soo Te Naa yise meeoo mu netamma, ‘Muusoo too'e, ka taba noko paatoosooba-matoo mu nanesootuhi.’ Soo Te Naa tuukwewabe mee umu-witu tubotugu. ‘Soo Te Naa mu Jew numu meeoo netamma, “Ewa (40) tomoka mu ka mana gi hemma naa-kwi'yoona, gi nu-matoo nanesootuhina. Mu nu-matoo nanesootuhi mee naneyugwe pana mu nanesootuhi nobe tsekatukuse ka taba-matoo nanesootuhi. ");
INSERT INTO paoNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Paatoosooba-matoo tuwazoo. Ooonne'yoona nu mu wakwawa'a numu oona kwinga'a Babylon mee naneadu teepu-koobatoo numu-matoo mu tzama'wukwu.” ’ ");
INSERT INTO paoNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Soo Te Naa yise ka Moses nanesootuhi nobe-too tuungu tooe hemma tooe puhu-makoo. Soo Moses yise oo tumayohoku ooka tu poonne tabua-kwa'ne. Ka tooe hano tooe mu numu momona ka nobe tzanomo'o. ");
INSERT INTO paoNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Ka Moses kadoo'oo manese, sumu'yoo nana Joshua mee naneadu ka Moses kapi manekwu. Mu numu ekow teepu-koobatoo ka nobe hanekekoo. Ka mu numu yow petuse, ewa'yoo wakwawa'a mooasoo yow nonobe-ga'yoo. Soo Te Naa mu wakwawa'a kadoo mayugwese umu yise otuoo mu teepu-wi nobe-dookwu. O'no yise soo nanesootuhi nobe ooosapa ka yow teepu-kooba'yookwu. Saa'a soo David nadooa'adoose, nana manepetuga. ");
INSERT INTO paoNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Soo Te Naa oo sootuhipu. ‘O'no sakwa nu Te Naa tupe nobe-dookuse,’ mee soo David tusooyugwe. ");
INSERT INTO paoNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Gi ooosapa oo tumadabue. Oo tooa Solomon mee naneadu oo nanesootuhi nobe-dooku. ");
INSERT INTO paoNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Soo Tamme Manumudoopu gi numu tumadabuena nobe soogwa'e. O'nosoo soo Te Naa yadooawabe meeoo tubotugu, ");
INSERT INTO paoNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","50","‘Soo Te Naa mee unakwe, “Nu pa'a mu-kooba katu, pana ka e kuku-ma ka teepu mesoo tamma. Nu no'okosoo hemma matabuepu. Mu gi toge nuga pukwi'yoo-wa'nekoo nobe matabue-wa'ne'yoo.” ’ ” ");
INSERT INTO paoNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Soo Stephen mee tuwazoo unakwe, “Mu yaatoo gi tunaka'oedyukuna gi tumayohodu. Mu nono'otsa Te Naa Besa Pooha netumoo'oo. ");
INSERT INTO paoNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Mu nanamooatupu ka Te Naa gi petzabedu. Mu yise punno'o ooosoo manakwe. Mu nanamooatupu ka Te Naa tuukwewabe no'oko suda matugupu-ga'yoo. Umu ka Te Pabe'e petukwuna wahadu yise nagoe. ");
INSERT INTO paoNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Te Naa tu tummatziwabe, ka toha kasa-gakoo mu-matoo taya tu unnena mu mayoho tuunguna, pana mu gi oo tumayohokute ka Te Pabe'e batsase.” ");
INSERT INTO paoNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Mu numu oo nakasutakute ka Stephen unnena gi nakabetsabena. ");
INSERT INTO paoNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Te Naa Besa Pooha tuusoobedyana, toogoopatu poonnese, ka Te Naa poonne. Soo Te Pabe'e ka Te Naa-kumaba 'wunu. ");
INSERT INTO paoNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Soo Stephen yise mu numu meeoo tuukwe, “Nu ka toogoopatu Te Pabe'e ka Te Naa-kumaba 'wunu oo pooha poonne.” ");
INSERT INTO paoNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","No'yoona mu numu tu naka-wi matugumo ka gi oo unnena soonakana, oo nesagwikuna. ");
INSERT INTO paoNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Ka Jerusalem-wikoo oo tzadoodooekase oonow petugase, mu oe oo neyugwedu tu wunagapu tzakwumetase, ka sumuoo nana, Saul mee naneadu-kobena mu tuoona petuga. Umu yise tupe-ma ka Stephen tatapageta. Umu oo batsa soogwina. ");
INSERT INTO paoNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Gisoo pummetu batsa soo Stephen mee nanesootuhi, “Ne Pabe'e Jesus, besa-kwitoo ka e moogooa hanega.” ");
INSERT INTO paoNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Measedose tuwazoo pabatse'e nanesootuhi, “Ka suda mu tumadugu-kwitu gi mu sootu'adyipana.” Oobenakwatoo soo Stephen ya'ehoo gi oo unnena soonakana, oo nesagwa'ekuna. ");
INSERT INTO paoNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","4","Mu nanana Te Naa-tamme nanesootuhidu ka Stephen nabatsana tzakwuhooka. Unu oo yagakuse oo tugu. Ewa'yoo numu ka mu tunaka'oedyukudu unu toomoo'oo. Soo Saul besa soonamme ka oo nabatsase yise oona nonobe-too Te Pabe'e naka'oedyukudu wate mu manoyugwena mu tsapewo'ya ka mu wutumetakwuse. Ewow nanana wutumeta momoko'ne nokosoo. Soo Saul yise mu tunaka'oedyukudu ka Jerusalem mee naneadu-witoo wateka mu goekwuse. Mu Te Pabe'e tuukwewabe suu'mu oesoo nabenihoo. Mu ewa'yoo tunaka'oedyukudu nana'emota petukwuhoo. Ka Jerusalem-wi'yoona, ka Judea noko Samaria mee nananeadu-kooba'yoo mea'a. Mu numu ka oonow meana soo Jesus Te Pabe'e mee mu tuukwemena. ");
INSERT INTO paoNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Soo Stephen pua'a, Philip mee naneadu oona Samaria mee naneadu teepu-wi petuga. Onow petugase ka mu oeteoo numu Te Pabe'e Jesus-witu tuukwe'e. ");
INSERT INTO paoNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","7","Ewow numu besa 'mayugwe. Ewa'yoo tsoapagoedu ka mu tsoapa umu-makoo tayakwunina. Umu tsoapa yise wa'ageyina meahooyakwe mu tsoapagoedu yise besa 'maneyakwe. Soo Philip yise mu numu ka Jesus-witu mu tuukwena, mu yise ka oo poonnena yise ka Philip besa nakabetse'a. ");
INSERT INTO paoNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Mu numu yise besa sokwama. ");
INSERT INTO paoNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Oona Samaria-wi sumu'yoo tupoohadu nana nobe-ga'yoo, Simon mee naneadu. “Nu besow pooha-ga'yoo,” mee mu nemooagana. ");
INSERT INTO paoNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","11","Mu numu yise oo naka'oedyukuna yise meeoo unakwe, “Oosoo tookwa Te Naa God.” Wuna'me yise 'manepetuga ka tu pooha-ma numahanena. ");
INSERT INTO paoNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Meno'o soo Philip ka Te Naa 'manepunne-kwitu mu numu tuukwe'e soo Jesus yise togesapa Te Pabe'e. Mu nanana-no momoko'ne ka oo naka'oedyukuna, baa-wi namatzaka. ");
INSERT INTO paoNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Soo Simon punno'o numu-no baa-wi namatzaka. Oosoo ka Philip nagennumme. Ka Philip pooha manakwe oo poonnena ka oo poohagana, Simon yise oo nasoodyagena. ");
INSERT INTO paoNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Te Pabe'e tuukwewabe oo nakase, ka mu Samaria-witu numu Te Naa unnepu naka'oedyukuna, mu waahoo nanana Jerusalem-witu, Peter noko John umu-matoo taya. ");
INSERT INTO paoNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","16","Samaria-wi petuga, mooasoo ewa'yoo Te Pabe'e-wi tunaka'oedyukudu baa-wi namatzakapu. Gisoo ka Te Naa Besa Pooha wumadu. ");
INSERT INTO paoNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Mu Peter-no John mu nanesootuhikuna umu-ma matuguna, umu yise ka Te Naa Besa Pooha-matu-ma nasootuhi. ");
INSERT INTO paoNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Simon punno'o o, oosoo ka mu tuukwewabe poonne umu ka mu nananesootuhidu-ma tubetse matuguyina, Simon yise meeoo mu netamma, ");
INSERT INTO paoNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","“Yaa'a, nu sakwa ka poohabe-matu tumu. Nu punno'o mu-kwa'ne'yookwu. Nu punno'o umu-ma matuguyina, umu ka Te Naa Besa Pooha-matu-ma nasootuhidooa.” ");
INSERT INTO paoNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Soo Peter meeoo oo netamma, “Soo Suta'yoo noko kadoo'oo u mayugwekwu. U ka Te Naa tamme sootuhipu too'e netumuna. ");
INSERT INTO paoNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","U tookwa gi numme-matu soo Te Naa u sopedakwatoo. U suta'yoo ka meeoo tusooyugwena. ");
INSERT INTO paoNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","23","Nu u sopedakwatoo u ooosapa suta'yoo. Soo hee ooosapa u-tamme gi toge'yookwu. Suda u tusooyugwena oo soomu'wuse, ka Te Naa-matoo nanesootuhi. Soo Te Naa ka suda u tusooyugwena gi sootu'adyidooa.” ");
INSERT INTO paoNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Simon yise ka Peter meeoo netamma, “Ka Te Naa-matoo nuka nanesootuhiku. O'no saa'a soo hee nuka u tuukwepu gi oo-toogoo manedooa.” ");
INSERT INTO paoNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Umu Peter-no John yise ka Te Naa unnena wahase, oona punowsoo kodyuka Jerusalem-witoo. Ka kodyuna, ka teepu mu Samaria-witu numu ka Te Naa unnena tuukwemena. ");
INSERT INTO paoNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Soo sumu'yoo Te Naa tummatzidu toha kasa-ga'yoo ka Philip-baa petugase, meeoo oo netamma, “U sakwa mease, gi ka po kaaheno habedu-too meapana, ka taba meana-kwi sakwa u ka Jerusalem-wi'yoona, mea ka Gaza mee naneadu-kwi u petugakwu.” ");
INSERT INTO paoNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","28","Sumu'yoo nana wuguna-wi me'a. Mooasoo Jerusalem-wi nanesootuhitooase, punowsoo pummesoo teepu-koobatoo kodyuna, Ethiopia mee naneadu-kwitoo. Soo nana mu numu tumanagana mabetseadu, ka Ethiopia numu moohedu mogo'ne tummatzidu. Paba tuneana kaduno'o, o'nosoo ka Te Naa yadooawabe, Isaiah mee naneadu tubona. ");
INSERT INTO paoNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Soo Te Naa Besa Pooha ka Philip meeoo netamma, “Ka nana hatsukase, oo-nosoo meakwuni.” ");
INSERT INTO paoNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Ka oo hatsukase, oo naka ka Isaiah tubo tuguna oo ne'a. Soo Philip yise oo tubenga, “U haa'a oo nakasopedakwadoo maka u tuneana?” ");
INSERT INTO paoNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Oo nanekwegease mee'e, “Gi, nu gi oo nakasopedakwatoo. Haga sakwa mitu e tuukwe? Nu-baa katuno.” ");
INSERT INTO paoNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Mee yise tuneakooha, “Soo seepu puu gi tunema'yu ka pummetu sebakwuse, pummetu batsakwuse tuwow. Umu-wa'nesoo soo Te Pabe'e gi hayoo unakwe. ");
INSERT INTO paoNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Umu ka Te Pabe'e-ma'yoo nanekoena, gi besa oo matuku. Mu numu suda manakwe ka Te Pabe'e batsase.” ");
INSERT INTO paoNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Soo nana ka Philip meeoo tubenga, “Haga-witu netamma, puusoo haa'a pute haka?” “Jesus-witu,” mee'e soo Philip oo nanekwegea, “Soo Jesus tubetse Te Pabe'e.” ");
INSERT INTO paoNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Soo Philip yise ka tu tuneana-witu oo tuukwese yise ka Te Pabe'e-witu tuwazoo oo tuukwe'e. ");
INSERT INTO paoNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","37","Ooosapa memeadape yise ka banunadu-kumaba pepetuga. Soo nana meeoo unakwe, “Yaa'a baa. U sakwa mi e matzaka.” ");
INSERT INTO paoNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Ka waguna tutziwabe yooi tuunguse, ka baa-witoo Philip-no memea. Soo Philip yise ka baa-wi oo matzaka. ");
INSERT INTO paoNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Ka baa-wi'yoona pakuase, soo Te Naa Besa Pooha ka Philip bihooka. Soo nana yise besa soonammena, tu nobe-kwitoo mea. ");
INSERT INTO paoNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Azotus mee naneadu toogoo, soo Philip mease, yise kwenaha-tamme meadooa, Caesarea mee naneadu-wi petu. No'okosoo putoogoo tu meatoo, ka Te Pabe'e-witu mu numu tuukwemena. ");
INSERT INTO paoNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Soo Saul sutawununa yise ka umu Te Pabe'e Jesus naka'oedyukudu goewunu. Soo Saul mu Jew numu moohedu meeoo netamma ka Jerusalem-wi'yoona. ");
INSERT INTO paoNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Ka Damascus mee naneadu-kwitoo mu Jew numu moohedu-matoo tupo, “Nuka tummatzi,” mee mu netamma. Umu Te Pabe'e Jesus naka'oedyukudu sakwa nakwutuma. O'no saa'a yise mu ka Jesus naka'oedyukudu Jerusalem-witoo bika. ");
INSERT INTO paoNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Soo Saul tu pupua'amu-no meana oona Damascus tzage'e manegase, hemma tukwukwutseba-wa'nekoo poonnese yise anoaka. ");
INSERT INTO paoNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Soo Te Pabe'e ka Saul meeoo netamma, “U suda a masoonammekute.” ");
INSERT INTO paoNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","“Haga u?” mee soo Saul unne. Soo Te Pabe'e yise meeoo, “Nu Jesus u yow ooosapa suda e masoonammennumme. ");
INSERT INTO paoNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Yotsese mea'ase ka Damascus-wi petugase u u manekwuna natuukwedooa.” ");
INSERT INTO paoNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Umu oo pupua'amu gi ha'yoo unni-kwa'ne'yoo ka oo naka pana gi haka poonnena. ");
INSERT INTO paoNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Soo Saul yotsese, oonatu too'e poonne pana gi tubootabue mani. Umu oo pupuamu oo mi-makoo oo tzakaka ka Damascus mee naneadu-kwitoo. ");
INSERT INTO paoNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Pahe tabeno maneka soo Saul ka gi tubootabue manese, gi tukana gi hemma hebena. ");
INSERT INTO paoNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","11","Sumu'yoo Te Pabe'e Jesus naka'oedyukudu Ananias mee naneadu Damascus-wi nobe-ga'yoo. Soo Te Pabe'e, “Ananias,” mee, uni mee tuusoobedyana. “Nu u naka,” mee soo Ananias oo nanekwegea. Soo Te Pabe'e yise meeoo, “Yotsese, meana ka Judas nobe-kwitoo ka Saul-witu tutubenga. Oona soo po kaaheno hape Judas ookow po-kumaba nobe-ga'yoo ka Saul no u yadooakwu. ");
INSERT INTO paoNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","U, Ananias, ka Saul-ma matuguse oosoo besa tubootabue 'manekwu, mee soo Saul tuusoobedya.” ");
INSERT INTO paoNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Soo Ananias meeoo unakwe, “Ewa'yoo numu ka Saul-witu e tuukwe. Soo Saul gi besa'yoo nana. Soo Saul ka Jerusalem-witu mu ume naka'oedyukudu wutumetana mu kutsedyina, mu wuko'e. ");
INSERT INTO paoNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Soo Saul yow petu ooosoo manekwuse.” ");
INSERT INTO paoNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Soo Te Pabe'e ka Ananias nekwegea, “Unu mease, nu oo netutzea ka Saul no'obatusoo numu nu-kwitu tuukwekwu, mee nu unakwe. Mu wakwawa'a moohedu, yise oo Jew nananumu. ");
INSERT INTO paoNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Ewa'yoosoo mu numu ka Saul nekwutumana, oo kutsedyana ka nu-kwitu pumme ka Saul tuukwe'e,” mee soo Ananias nose. ");
INSERT INTO paoNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Soo Ananias yise ka Judas nobe-kwi petugase, ka Saul-ma matuguse, meeoo oo netamma, “E pua'a, soo Te Pabe'e Jesus u-baa petudu u-nosoo nummedu u-matoo e taya. Ume oosoo magwetzoise. Yise ka besa'hoo tu pooha-matu-ma u sootuhi.” ");
INSERT INTO paoNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Hee sapaga ka Saul pooe-kwi'yoona sawehoose, oosoo besa tubootabue 'mani. Yotsese, yise soo Ananias baa-wi oo matzaka ");
INSERT INTO paoNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","saa'a ka tukase natzooesoo 'manepetuga. ");
INSERT INTO paoNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Soo Saul ka mu Jew numu meeoo tuukwe soo Jesus Te Pabe'e mee'e, yise ka mu Te Pabe'e naka'oedyukudu-baa huu tooiyakwe ka Damascus-wi. ");
INSERT INTO paoNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Ewa'yoo umu oo nakadu gi oo naka'oedyukuna mee unakwe, “Esoo nana mu Te Pabe'e naka'oedyukudu goepu ka Jerusalem-wi'yoona. Masoo yaatuoo mu Te Pabe'e Jesus naka'oedyukudu wutumetakwuse mu Jew numu moohedu yise Jerusalem-witoo mu bikakwu. Masoo meno'o meeoo te netamma oo naka'oedyuku soo Jesus Te Pabe'e.” ");
INSERT INTO paoNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Soo Saul nenagu'a ka Te Naa unnena Te Naa Besa pooha-toohakwi oo wahana unusoo poohatoo'a. Ka mu Jew numu tubetse tzapoonnekute soo Jesus Te Pabe'e. Umu numu gi hanotosoo hayoo unne-wa'ne'yoo. ");
INSERT INTO paoNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","25","Ka saa'a mu Jew numu tunehane ka Saul patsakuse tabewano, togawano oona natzakwuna'a-wi oo too'e potamana. Soo Saul mu naka ka pumme mu batsakwuse. Mu susumudu Te Pabe'e naka'oedyukudu ka pabatsekoo kawona-wikoo ka tupe nagoodeadoona ka mu numu nogaduna na'oonnakwidu habedu oonow tawaga-too natzakweku tugapoo-ma ka togano. ");
INSERT INTO paoNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Soo Saul ka Jerusalem-wi petugase mu Te Pabe'e naka'oedyukudu-no too'e nesumu'u. Umu sua'e ka gi tunaka'oedyukuna ka ookow puu Te Pabe'e Jesus oo naka'oedyukute. ");
INSERT INTO paoNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Soo Barnabas oo naka'oedyukuna oo bikea oona mu tuukwewabe-matoo. Soo Barnabas mee unakwe, “Esoo nana ka oona Damascus po-wi'yoona ka Te Pabe'e poonnese oo nakabetsea. Ka Damascus-wi masoosoo mu numu-ma suina ka Te Pabe'e Jesus pooha-toohakwi Jesus-witu mu numu tuukwe.” ");
INSERT INTO paoNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Soo Saul yise Jerusalem-wi mu tunaka'oedyukudu-no ka mu Jew numu-ma gi suina, mu nesumuse ka Te Pabe'e-witu mu tuukwe ka Te Naa Besa Pooha-toohakwi. ");
INSERT INTO paoNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Ka mu Jew numu Greek-ma yadooadu-no nanepetukute. Unu umu oo nesutakute umu ka oo batsakwu mee sokwamana. ");
INSERT INTO paoNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Mu Te Pabe'e-wi tunaka'oedyukudu o nakase oo bikea oona Caesarea mee naneadu-kwitoo oo nobe-kwitoosoo o kodyu tuunguna. ");
INSERT INTO paoNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Ka Saul tunaka'oedyuku 'manese, mu tunaka'oedyukudu ka teepu Judea, Galilee, Samaria mee nananeadu-koobatu gi how nuugwe, gi nuutumetana, gi namatzama. Umu ka Te Naa Besa Pooha-ma nasootuhise Te Naa podo mea. Ewa yise 'manepetuga. ");
INSERT INTO paoNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Ka saa'a soo Peter mu tunaka'oedyukudu oona kwaya'a-kwitu nobenedyinnumme. Oona ka Lydda mee naneadu-kwi petuga mu tunaka'oedyukudu nobengena. ");
INSERT INTO paoNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","34","Sumu'yoo nana Aeneas mee naneadu ka Lydda-wi nobe-ga'yoo, gi yutsungadu ooosapa habedabe namewatsu (8) tomokapu. Oo-baa soo Peter petugase meeoo oo netamma, “Soo Te Pabe'e Jesus u mabesakukwu. Yotsese, u kapa mabetsabe.” ");
INSERT INTO paoNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Ewa'yoo mu numu Lydda-wi nonobe-ga'yoo, yise ewa'yoo numu Sharon mee naneadu tubewa-witu oo poonnese oo naka'oedyuku soo Jesus Te Pabe'e. ");
INSERT INTO paoNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Sumu'yoo mogo'ne tunaka'oedyukudu Tunna mee naneadu oona Joppa mee naneadu-kwi nobe-ga'yoo. Ewa nanabesa tumadugupu. Ewow numu tutuha manedu gi hee-gakoo tummatza'e. ");
INSERT INTO paoNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Soo Tunna yise unu tuoeyaese ya'e. Mu oo pupua'amu oo tookoo pakedyase oona nobe-kooba tuutse'e nanobe-too-kwi oo tzatugu. ");
INSERT INTO paoNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Mu tunaka'oedyukudu oo sopedakwatoo ka Peter oona Lydda-wikoo soo Joppa ono natsage'e. Umu waha'yoo naana ka Peter ba'e, oo natummatzi tuunguna. ");
INSERT INTO paoNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Soo Peter ka nobe-kwi petuoose oosoo ka tuutse oo-kooba nanobe-too-kwitoo meahoo. No'yoona mu momoko'ne gi kookoomama-ga'yoo sakwina manegonno, ka wanapu pukwi tu namasooana ka Peter tzapoonnekute ka gisoo Tunna ya'e oo tumadabuena. ");
INSERT INTO paoNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Soo Peter yise no'oko puuwanatoo mu taya Te Naa-matoo meatzedose nanesootuhise ka Tunna tookoo yadoo'e, “Yotseoo Tunna.” Tunna yise mitu poonnegase ka Peter poo'nese katuoo. ");
INSERT INTO paoNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Soo Peter ka Tunna mi-makoo oo tzadyotase oo kuku-ma oo tzawunukuoo. Oo gwetzoina mu tunaka'oedyukudu tzapoonnekute, mu gi kookoomamu-gakoo nokosoo tuwazoo. ");
INSERT INTO paoNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Mu Joppa-witu ewa'yoo oo naka ka namanena yise ka Te Pabe'e Jesus-wi tunaka'oedyukuhoo. ");
INSERT INTO paoNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Sumu'yoo nana ka Joppa-witu Simon mee naneadu kootsoo puhu mahanedu. Soo Peter wuna'me ka Simon-baa. ");
INSERT INTO paoNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Sumu'yoo tukwutumadu naa, Cornelius mee naneadu oona ka Caesarea mee naneadu-wi nobe-ga'yoo. ");
INSERT INTO paoNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Soo Cornelius besa'yoo nana no'oko mu Jew tutuha manedu numu tummatzidu, no'yoona ka tu doodooamu-nosoo ka Te Naa-matoo nanesootuhiyakwe. Gi Jew numu, pana mu Jew-wa'nesoo nanesootuhiyakwe. ");
INSERT INTO paoNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Sumu tabeno pahe-kwikoo ka taba soo Cornelius nanesootuhina tuusoobedya. Te Naa tummatzidu toogoopa'yoona oo-baa petuse, mee oo netamma, “Cornelius.” ");
INSERT INTO paoNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Soo Cornelius oo poo'nese, oo-ma suise, mee unne, “Nu u nakapunne. Hemma u how e yukwe tuungu?” Soo Te Naa tummatzidu meeoo oo netamma, “Soo Te Naa u sootuhi, putamme u nanesootuhipu oo nekwegeana, ka u nanumudoo u tunekwipu tuwazoo. ");
INSERT INTO paoNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","6","U sakwa meno'o oona Joppa mee naneadu-kwitu nanana taya. Sumu'yoo nana, Simon Peter mee naneadu oonow, mu sakwa oo bidooa. Oosoo punno'o Simon mesoo naneadu, tu puhu mahanedu oo baa soo Simon Peter manepunne. Soo Simon nobe oona tubetse baa-kumaba,” mee tuusoobedya. ");
INSERT INTO paoNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","8","Soo Te Naa tummatzidu yise meahoo. Soo Cornelius tuponnese, ka mu waahoo nobe-kwi tutummatzidu ka Te Naa unnena mu tuukwe. Sumuoo tukwutumadu tuwow tuukwe. Oosoo ooosapa oo tummatzidu, ka Cornelius no'oko mu Jew numu-wa'ne nanesootuha'e. Oona Joppa mee naneadu-kwitoo mu taya. ");
INSERT INTO paoNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Oogow moo'a tabeno mu nanana wupetuga, soo Peter ka nobe-kooba poyase, nanesootuha'e. ");
INSERT INTO paoNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Ka saa'a yise unu tzuaya'ena, “Hemma sakwa nu tuka?” mee soonamme. Ka mu numu tu tukakwuna mabetsape soo Peter mee tuusoobedyow. ");
INSERT INTO paoNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Soo koomebaga tawaga mee nose. Pabatse'e hemma natzatobododu-kwa'ne tabuadu ka Peter noko ka teepu-tamme wuegena. ");
INSERT INTO paoNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Ka oo wue petuhoose, no'obatusoo hee oe, togogwa-no no'obatusoo nunu'u, no'obatusoo kwe'na'a. ");
INSERT INTO paoNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Soo Peter meeoo nanetamma, “Yabe yotsese, matu tuka.” ");
INSERT INTO paoNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Peter yise meeoo, “Nu gi mownnekoo tukadu. Ne nanamooatupu tunetammana numme mayoho, gi numme hemma mownnekoo tukadu.” ");
INSERT INTO paoNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Mee tuusoobedya, “Esoo besa'yoo gi suta'yoo soo Te Naa ka meeoo unnena, ‘Besa'yoo.’ ” ");
INSERT INTO paoNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Pahe tooe meeoo oo netammayakwe. O'no yise oosoo pabatse natzapogotugudu toogoonakwa yabetse'esoo tsebooehooka. ");
INSERT INTO paoNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Soo Peter meeoo soonamme, “Hayoo gena soo e tuusoobedyana e tuukwedu?” Mu natayadu ka oona Simon nobe-kwitoo mea, ka nobe-kobena, ka natzakwuna'a-kumaba konno petugase ");
INSERT INTO paoNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","yise meeoo tutubenga, “Soo Simon Peter haa'a mu-baa?” ");
INSERT INTO paoNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Soo Peter togesoo meeoo soonamme, “Ha'yoo gena soo e tuusoobedyapu e tuukwedu?” Soo Te Naa Besa Pooha meeoo oo netamma, “Mu nanana u kwate. ");
INSERT INTO paoNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Wuegase gi suipana umu-no mea. Nu ume mu bi tuungu, umu-no mea.” ");
INSERT INTO paoNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Soo Peter yise umu-baatoo wuese meeoo mu netamma, “Yaa'a nu. Hemma mu sookwa'e?” ");
INSERT INTO paoNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Umu oo nanekwegea, “Soo Cornelius mee naneadu, mu tukwutumadu moohedu, yaatoo ne ta'ya. Besa'yoo nana oosoo mu Jew numu-wa'ne Te Naa-witu tunaka'oedyukudu tuwazoo. Mu Jew numu unu oo nenaka. Soo toha kasa-ga'yoo mee ka Cornelius netamma, ‘U oo tuukwe u oosoo saa'a u nobe-kwitoo kemmadooa. Oosoo u tuukwekwu ka u soonakana.’ ” ");
INSERT INTO paoNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Soo Peter ka mu natayadu nabaa tooi tuungu. Soo Peter ka tu tabuase, ka mu nanana-no mea. Susumudu mu tunaka'oedyukudu Joppa-witu punno'o umu-no mea. ");
INSERT INTO paoNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","27","Sumu tooise, oogow mooa tabeno ka Caesarea mee naneadu-kwi petuga. Cornelius ka mu sookwipunnena tu nanumu no'oko tu pupua'amu ka Peter unnekwuna mu naka tuunguna. Mooasoo soo nobe kaanopunne. Soo Peter yise petuooga, Cornelius oo-matoo meahoose, oo-kobena meatzedoose oo-matoo nanesootuhikooha. Peter oo tzadyotase meeoo oo netamma, “Gi nu-matoo nanesootuhipana. Nu gi Te Naa God. Nu u-kwa'nesoo, sukwe numu.” Soo Peter oo-no yadooase ka nobe-kwi tzoonoowahooka. ");
INSERT INTO paoNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Ka nobe-kwi egease, no'oko mu numu oe manepunnedu meeoo netamma, “Mooasoo mu oo sopedakwatoo ka numme Jew tumadaguna. Numme ka mu gi Jew numu nobe-kwi gi nobe'nge. Gi too mu pupua'amu-ga'yoo. ");
INSERT INTO paoNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Pana mu ka e bise nu kemma. Nu gi e namanayahowkwu-ma sua'e. Soo Te Naa ookow e tzapoonnekute no'yoona numu nanakwa'ne'yoosoo. Hayoo u e netammakwuse yaatoo e bi?” ");
INSERT INTO paoNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Cornelius meeoo oo nanekwege'a, “Pahe tabeno manegapu, pahe-kwikoo, ka oona nobe-kwi'yoonasoo nu nanesootuha'e. Sumu'yoo nana nu-kobena tabu'a petu. Oo kwasu unu patakwetze'atu-kwa'ne tabu'a ");
INSERT INTO paoNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","meeoo yise e netamma, ‘Soo Te Naa u nanesootuhina nekwegea. U nanekwegeana sooma'yuna ka oo nanumu u tummatzipu. ");
INSERT INTO paoNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Mu numu-matu taya Joppa-witoo umu sakwa Simon Peter yaatoo bike. Oosoo Simon oo-no, oosoo Simon mee naneadu nana tupuhu mahanedu oo nobe ka tubetse baa-kumaba.’ ");
INSERT INTO paoNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Yabesoo nu nabaatoo mu ba'e, besa umu ka oo manese. No'yoona yise tamme yow Te Naa-kobena manepunne. U yise ka Te Naa unnepu ne tuukwekwu.” ");
INSERT INTO paoNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Soo Peter meeoo mu netamma, “Ka o'nosooga soo Te Naa mu Jew numu suu'mu besa soobedya, mu susumudu numu gi, mee nu soonamme. Meno'o nu oo sopedakwatoo soo Te Naa gi numu moodya'e. ");
INSERT INTO paoNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Oosoo ka tunaka'oedyukudu sootuha'e mu besa tumatugutu, mu gi Jew numu nokosoo. ");
INSERT INTO paoNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Soo Te Naa ne taya mu Jew numu-matoo mu tuukwe, mee ne netammana soo Te Naa sakwa tunaka'oedyukudu sootuhina ka Te Pabe'e Jesus tamme-koobatoo nemawuni. Oosoo no'oko-tamme Pabe'e. ");
INSERT INTO paoNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Mu ka sumuna mooasoo oowetuoo nakapunne, soo John mu numu baa-wi matzagadyakwe.” Soo meeoo na'unnedu no'oko Galilee mee naneadu tubewabe kaano nanakapunne. Oona Judea mee naneadu tubewabe-witooe. ");
INSERT INTO paoNT_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Ka Te Pabe'e Jesus-witu nawahana, soo Te Naa tu Besa Pooha-matu-ma oo sootuhi, mana yise besa manennumme, ka Te Naa pooha-masoo ka tsoapagoedu mabesaku. ");
INSERT INTO paoNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Numme yise besa oo tumaduguna poonne, mu Jew numu-nagatu. Ooonne'yoona yise umu Te Pabe'e tzakwenese oo batsa. ");
INSERT INTO paoNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Ka Te Pabe'e soo Te Naa mayoda, ka waha tabeno oo ya'edape. Ooonekoo ekow soo Te Naa te tzapoonnekute. ");
INSERT INTO paoNT_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Ka tu ya'e-kwi'yoona namayoduse gi no'yoona numu oo poonne. Numme suu'mu Te Naa tunetutzeana ookow waha. Numme ka Te Pabe'e poonne. Gi tsoapa, numme oo-no tukase, baa oo-no hepe. ");
INSERT INTO paoNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Mu numu meeoo ne tuukwe tuungu. Soo Te Naa puusoo oo netutzea. ‘Nu no'obatusoo mu numu nehanekwudu, mu gisoo ya'epu yise ya'epu tuwow.’ ");
INSERT INTO paoNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","O'nosoo no'yoona mu Te Naa nanamooatupu tuukwewabe ekow botugu ka Te Pabe'e-witu. Umu meeoo, ‘Soo Te Naa ka Te Pabe'e poohamaka. Te Pabe'e yise no'oko pumme naka'oedyukudu tuma'emukwana somu'wa.’ ” ");
INSERT INTO paoNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Ka Peter tooesoo umu-no yadooawunu soo Te Naa mu Cornelius noko oo pupua'amu besa'hoo tu Pooha-matu-ma mu sootuhi. ");
INSERT INTO paoNT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","46","Mu Jew numu ka Peter-no petudu, ka mu wakwawa'a nana'atasoo apegeagonno mu naka, ka Te Naa pooha pumme sootuha'e. Umu Jew numu ka Peter-no gi oo sopedakwatoo soo Te Naa no'oko numu gi Jew sapa ka tu Besa Pooha-matu-ma sootuhi. Soo Peter yise meeoo unakwe, ");
INSERT INTO paoNT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Tamme sakwa ka gi Jew numu baa-wi matzaka umu ka tamme-wa'ne'yoonasoo. Soo Te Naa puu Tu Besa Pooha-matu-ma mu sootuhi. ");
INSERT INTO paoNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Baa-wi sakwa mu namatzaka ka Te Pabe'e Jesus naka'oedyukuna.” Umu ka Peter nenuummaku numme-baasoo, huudooe tooipunne mee oo netammana. ");
INSERT INTO paoNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Mu tunaka'oedyukudu ka Judea mee naneadu teepu-koobatu mu naka ka mu wakwawa'a Te Naa unnena mu naka'oedyukute. ");
INSERT INTO paoNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Ka Peter Jerusalem-wi petugase, susumudu mu Jew numu-matu Te Pabe'e-wi tunaka'oedyukudu oo nesootze'ma, ");
INSERT INTO paoNT_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","meeoo yise oo netamma, “U gi te tumayohope mayoho u ka mu wakwawa'a-baa petugase, umu-no tuka.” ");
INSERT INTO paoNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Soo Peter yise no'oko tu manepu mu tuukwe, mee unakwe, ");
INSERT INTO paoNT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Nu ka oona Joppa mee naneadu-kwi'yoona nanesootuha'e. Ka nanesootuhina nu meeoo tuusoobedyana heegina tubongo ka teepu-koobatoo pa'anakwana wuegena. ");
INSERT INTO paoNT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Ka oo wue petuse nanakumma'yoosoo hee oe'yoona sa'we petuhoo: togogwa, nunu'u, nanakumma'yoosoo kwe'na'a nu oo poonne. ");
INSERT INTO paoNT_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Nuka meeoo netamma, ‘Yabe mu batsase, mu tuka.’ ");
INSERT INTO paoNT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Nu yise meeoo, ‘Gi numme putoogoo meana. Nu gi mownnekoo tukadu.’ ");
INSERT INTO paoNT_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Meeoo yise e netamma, ‘Soo Te Naa esoo besa'yoo, gi suta'yoo soo Te Naa ka meeoo unnena.’ ");
INSERT INTO paoNT_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Toge pahe nu meeoo natuukwe. No'yoona soo hee toogoopa nahanegapu, mee nu tuusoobedyana. ");
INSERT INTO paoNT_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Yabesoo pahe'yoo nanana petugono ka nobe e pukwi'yoopu-wi ka Caesarea mee naneadu-kwi'yoona umuoo natayapu. Umuoo yise petugono punowsoo e bigeakwuse. ");
INSERT INTO paoNT_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Soo Te Naa Besa Pooha meeoo e netamma, ‘Gi tunetutzeapana. Umu-no mea.’ Nu yise mu naapihoo tunaka'oedyukudu-no mea. Numme yise mu wakwawa'a nobe-kwi petuga. ");
INSERT INTO paoNT_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Oosoo meeoo mee tuukwe'e, ‘Soo Te Naa tummatziwabe oo nobe-kwi oo-baa petugase meeoo oo netamma, “Tooe haka tooe sakwa ka Joppa mee naneadu-kwitu ka Simon Peter mee naneadu bitooa. ");
INSERT INTO paoNT_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Soo Simon Peter ka petuse, mu tuukwetooa soo Te Naa unnepu yise ka mu nobe-kwitu, mu tummatziwabe nokosoo mu magwetzoitooa,” mee'e soo Te Naa tummatziwabe.’ ");
INSERT INTO paoNT_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Nu yise oetu mu tuukwe'e tooesoo e yadooawunu Te Naa Besa Pooha umu-ma mani petu. Ka o'nosoo tukwa'nesoo tamme ooka wumakwusoo. ");
INSERT INTO paoNT_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Nu yise oo sooma'yu ka o'nosoo Te Pabe'e Jesus tamme netammapu, ‘Soo John baa-wi mu matzaka pana Te Naa yise eka tu Besa Pooha-matu-ma mu sootuhi,’ mee'e. ");
INSERT INTO paoNT_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Soo Te Naa yise ka Tu Besa Pooha-matu-ma mu sootuhi ka Te Pabe'e Jesus te oedyukute. Meno'o punno'o tamme-wa'nesoo, ka Te Naa Besa Pooha-ma nasootuhipu. Nu gi ka Te Naa tumoo'oo-wa'ne'yoo uweoo.” ");
INSERT INTO paoNT_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Umu ka Peter tumoo'oodu, uga, oo nakase gi hanotusoo hayoo unne-wa'ne'yoo, ka Te Naa nesootuhina meeoo umu unakwe, “Yise meno'o mu wakwawa'a atasoo tu manena yugwese soo Te Naa mu magwetzoikwu.” ");
INSERT INTO paoNT_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Ka Stephen nabatsase ewa'yoo mu tunaka'oedyukudu mea ka mu numu pumme nehowa'e. Susumudu kwenaha-tamme ka tubetse baa kumi me'a Phoenicia mee naneadu teepu-koobatoo susumudu Cyprus-witoo natsemangega, umu-matu tuwow Antioch mee naneadu-kwitoo me'a ka meana ka Te Pabe'e-witu mu Jew numu tuukwe me'a. ");
INSERT INTO paoNT_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Pana umu-matoo ka mu wakwawa'a teepu Cyprus noko Cyrene mee nananeadu-witoo nadooamudoo, ka Antioch-wi petugase, mu wakwawa'a punno'o oetu natuukwe'e. ");
INSERT INTO paoNT_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Ka ooka mu waha Te Naa mu sootuhi. Ewa'yoo wakwawa'a mu nakana oo naka'oedyukute ka Te Pabe'e-witu. ");
INSERT INTO paoNT_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Mu tunaka'oedyukudu tooesoo Jerusalem-wi'yoona umu-witu nakase, sumuoo nana Barnabas mee naneadu umu-matoo ta'ya. Ka Antioch-wi ka Barnabas petugase ");
INSERT INTO paoNT_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","umu oo poonne ka ewow numu oo sootuha'e. Soo Barnabas besa umu-matoo soonammena ka Te Naa ooosapa naka'oedyukuna oo tumayohokuna. ");
INSERT INTO paoNT_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Soo Barnabas besa'yoo nana; unu tunaka'oedyukuna, ka Te Naa Besa Pooha hee-ga'yoo, ka saa'a mu tunaka'oedyukudu ewa manega. ");
INSERT INTO paoNT_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Soo Barnabas ka Paul watena Tarsus mee naneadu-kwi petuga. Soo Paul uga Saul mee naneadu. ");
INSERT INTO paoNT_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Oo mayuse punowsoo oo bika Antioch-witoo. Sumu tommo mu Barnabas-no Paul ka mu tunaka'oedyukudu tunedyooena ewow numu noko, yow ka Antioch-wi'yoona mu tunaka'oedyukudu, “Te Pabe'e nakanagemo'odu,” mee umu naneapu. ");
INSERT INTO paoNT_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","O'no yise umu Te Naa-witu numu tunedyooedu Jerusalem-wi'yoona ka Antioch-wi petuga. ");
INSERT INTO paoNT_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Sumu'yoo umu-matu Agabus mee naneadu 'wunuhoose ka Te Naa Besa Pooha wumana meeoo mu tuukwe, “Pudusoo no'yoona ka teepu-koobatu numu tseagoekwu.” Soo Te Naa unnepu oo-toogoo mani ka Claudius mee naneadu numu-kobena oo katu. ");
INSERT INTO paoNT_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Mu tunaka'oedyukudu Antioch-witu ka mu Judea-witu tunaka'oedyukudu tumasumutookute. Tu mapu'a noko umu mu haneku. ");
INSERT INTO paoNT_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Mu Barnabas-no Paul oo hanegase, umu tunaka'oedyukudu moohedu ka Judea-witu haneku. ");
INSERT INTO paoNT_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Mu Jew numu-kobena katudu Herod mee naneadu ka mu tunaka'oedyukudu kusega, gi besa mu sootunaga'a. ");
INSERT INTO paoNT_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Soo Herod ka tukwutumadu tsegesa-ma ka John pabe'e James batsa tuungu. ");
INSERT INTO paoNT_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Soo Herod soo tuwow ka Peter nebatsa ka mu Jew numu oosoosoo besa manuumakwu ka James oo batsase. Ka mu numu sumuse ka Te Naa nesootuha'e gi namayudu tukaba mu ewa tukano'o, soo Herod ka Peter mu wutuma tuungu. ");
INSERT INTO paoNT_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Mu nanana ooka na'eya'e tuungu ka oo tukwutuma nobe-kwikoo. Watsu-baa watsukwuoo naana ooka eya'e tuungu, ka mu ewa tukamakwuse ookow mooo'a umu oo nehanedooa mee unnena. ");
INSERT INTO paoNT_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Ka Peter nakwutumase, mu tunaka'oedyukudu ooosapa unu oo nanesootuhikute. ");
INSERT INTO paoNT_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Ka togano ka Peter nanehanekwuno'o umu oo ma'wetzogo-kwikoo nana'enakwu tukwutumadu-noko natzakunetu. Soo tukwutumadu yise ka natzakwuna-kumaba oo eya'epunne. Soo Peter uwegapu. ");
INSERT INTO paoNT_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Gi obeda soo pukwi mu utuina kootabu'a petu, yise sumu'yoo toha kasa-ga'yoo oe mani petuse, ka Peter matuponnese meeoo oo netamma, “Yabe yotseoo.” Soo Peter yotsehoose ka pummatu natzakunana ooetoosoo sawekuoo. ");
INSERT INTO paoNT_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Soo toha kasa-ga'yoo yise meeoo oo netamma, “Yabe yotseoose, namahaneoo. U nate noko u moko-wi namadabuehoo, wunagayowse e nakwi kemmow.” ");
INSERT INTO paoNT_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Soo Peter oo nagekase sapa, gi oo sopedakwatoo oo manese meeoo soonamme, “E nosena tookwa.” ");
INSERT INTO paoNT_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Wahaba, waahoo tukwutumadu moopa meme'a o umu pumme eya'edu, oona yise ka weehepu natzakwuna'a-wi pepetuooga, oosoo puusoo wonabe. Oe'yoona ku'owkase, ");
INSERT INTO paoNT_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","oonano'o manikase, soo toha kasa-ga'yoo oo ma'wuooga, mee yise soo Peter soonamme, “Gi tookwa e nosena. Soo Te Naa e tubetse magwetzoipu. Herod mu susumudu Jew numu-no e batsayagate. Pana soo Te Naa ka toha kasa-gakoo nuga magwetzoi tuungu. ");
INSERT INTO paoNT_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Nu sakwa John Mark pea-baatoo mea,” mee tusooyugwe. Ka John Mark pea Mary nobe-kwitoo mea. Ewa'yoo numu ka Peter nanesootuhikuna o. ");
INSERT INTO paoNT_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Ka nobe-kobena petuoogase ka natzakona'a doka'nge. Mary tummatzidu tsuadumu Rhoda mee naneadu ka oo nadoka'nge oetu poonne petuga. ");
INSERT INTO paoNT_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Soo tsuadumu oo sopedakwatoo ka Peter petuoona, besa soonammese gi ooosapa ka natzakwona'a tzakwuna oobe nobe-kwitoo tanomane mu numu meeoo tuukwe'e, “Peter oobeoo puuwana natzakwona-kwi 'wunu.” ");
INSERT INTO paoNT_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Mu numu gi oo naka'oedyukudu. “U koodeseya'e,” mee ka Rhoda netamma. Meeoo pumme mu netamma sapa mu tuukwe, “Togesapa soo Peter ebeoo petuhoo.” Umu yise meeoo, “Oosoo tookwa mooasoo nabatsapuna, te natzanakakute.” ");
INSERT INTO paoNT_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Soo Peter ooosapa tudokangedyakwe. Umu yise ka oo tzakwunase, ka Peter poonne. No'yoona apegeakooha oowetuoo nanatukwena. ");
INSERT INTO paoNT_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Ka Peter tu mi mayodase umu apegea makwuhoo. Soo Peter yise mu tuukwe'e, “Ka e nakwutumase, soo Te Naa e tummatzina yow e bipetu. Mu sakwa tunaka'oedyukudu ka James saa'a tuukwe mu susumudu tunaka'oedyukudu nokosoo.” Soo Peter yise kumma'akoosoo tubewa-witoo mea. ");
INSERT INTO paoNT_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Ka tu tabuase, mu tukwutumadu suda sokwama, umu ka Peter pukwi'yoona gi sopedakwadoona. ");
INSERT INTO paoNT_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Soo Herod oo too'e wate pana gi oo ma'yu. Soo Herod yise mu tukwutumadu ka Peter eya'edu goekwu mee'e unakwe. Soo Herod mease ka Caesarea mee naneadu-kwi nobetugu. ");
INSERT INTO paoNT_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","22","Ka saa'a mu numu sutakute ka Tyre noko Sidon-witu. Umu ka Herod pumme sakwa'ekuna gi petzabebena ka Herod tubewabe-witu tu tukapu hanena. Umu-matoo mease, ka Herod tummatzidu Blastus mee naneadu oo pua'adoo. Soo Blastus yise ka Herod noko mu tunehanekwuna nemadabue. Soo Herod yise tu besa kwasu-wi namahanena mu tunehane-wi petuooga. Ka mu numu-kobena katuse, mu numu yadoo'e. Mu numu besa oo sooyugwena meeoo oo netamma, “U, Ne Naa God-wa'ne.” ");
INSERT INTO paoNT_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Soo Herod yabesoo unu tuoeyihoo. Wo'abe tu tookoo sooawunu ya'ehoo ka meeoo soonammena, “Nu yow Te Naa God-wa'ne'yoo.” ");
INSERT INTO paoNT_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Ka yoo tu namanewunu, ewa'yoo numu oo naka ka Te Pabe'e-witu ka Herod manena naka'oedyukuna. ");
INSERT INTO paoNT_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Mu Paul-no Barnabas ka mu numu tu tummatzina mamakwuse Jerusalem-wi'yoona memea. John Mark umu-no memea. Ka Antioch mee naneadu-witoo kodyuka. ");
INSERT INTO paoNT_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Ka oonow mu pepetugase, mu susumudu tunaka'oedyukudu ka Antioch mee naneadu-kwi nonobe-ga'yoo. Umu-matu nanesootuhibu numu tunedyooedu, mu Barnabas-no Paul umu-no. ");
INSERT INTO paoNT_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Ka gi tukapana mu nanesootuha'e soo Te Naa Besa Pooha mu yadoo'e, “Nu ka Barnabas noko Paul netutzea, noko numu nu-kwitu mu tunedyooe tuunguna. Umuoo sakwa mu taya.” ");
INSERT INTO paoNT_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Mu tunaka'oedyukudu gi tukapana ka Paul noko Barnabas-ma pooha matuguse, mu nanesootuhikute yise mana mu taya. ");
INSERT INTO paoNT_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Soo Te Naa Besa Pooha ka Barnabas noko Paul tayase, umu ka Seleucia Cyrene mee naneadu-kwi pepetuga. Onona umu natzemangeka ");
INSERT INTO paoNT_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","ka Salamis mee naneadu-kwitoo. Ka oe pepetugase, mu Jew numu nanesootuhi nobe-kwi pepetuooga, mu Jew numu ka Te Naa unnena tuukwe. John Mark ka mu Paul noko Barnabas tummatza'e. ");
INSERT INTO paoNT_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Umu yise saa'a ka Paphos mee naneadu-kwi petugonnoga. Oosoo ka Salamis mee naneadu tubewabe oo'enakwa. Soo suta'yoo Jew numu poohadu Bar-Jesus mee naneadu o numu-no. ");
INSERT INTO paoNT_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Soo mu wakwawa'a moohedu Sergius Paulus mee nane'a, oosoo mu wakwawa'a moohedu besa tusooyugwedu, mu Barnabas noko Paul ka Te Naa-witu tutuubenga. ");
INSERT INTO paoNT_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Soo Bar-Jesus ka Sergius Paulus meeoo netamma, “Gi ka Paul noko Barnabas naka'oedyukupana.” ");
INSERT INTO paoNT_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Ka Te Naa God Besa Pooha punagakoo oo poonnese, meeoo unakwe. ");
INSERT INTO paoNT_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","“U mu numu gi toge neyugwedu. U ka sutakoo nunu'u-kwa'ne'yoo. U ka Te Naa tumoo'oona mu numu ka gi besow podo ta'ya. ");
INSERT INTO paoNT_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Soo suda u manena u-matoosoo kodyudooa gi u manena petzabena. U gi tubootabue manekwu ka suda u manena gi ma'wuna.” Yabesoo gi tubootabue manise, numu pumme tsakakwudu too'e kwate. ");
INSERT INTO paoNT_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Soo Sergius Paulus ka Bar-Jesus gi tubootabuedu poonne oosoo yise ka Te Pabe'e-witu naka'oedyukute yise ka Te Naa unnepu nesookwuga'e. ");
INSERT INTO paoNT_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Soo Paul tu pupua'amu-no ka Paphas-wi'yoona baa-koobakwi natzemangeka ka Perga mee naneadu-kwi pepetuga. Soo John Mark yise mu ma'wukase ka Jerusalem-witoo kodyuka, pummesoo nobe-kwitoo. ");
INSERT INTO paoNT_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Umu Paul-no Barnabas ka Perga mee naneadu-too memease, ka Antioch mee naneadu-kwi pepetuga ka teepu Pisidia-kooba. Ka te nanesootuhi tabebano'o umu ka mu Jew numu nanesootuhi nobe-kwitoo memea. ");
INSERT INTO paoNT_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Mu Jew nanesootuhidu nemadugudu ka Te Naa God unnena neamakwuse meeoo mu netamma, “E nanumu, manatu haa'a ha'yoosoo unnekwe?” ");
INSERT INTO paoNT_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Soo Paul oo wunuse mee mu netamma, “E nanumu-no mu tooe haga tooe Te Naa God naka'oedyukudu e nakapunne. ");
INSERT INTO paoNT_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Soo Te Naa God, pu-matoo tamme Jew numu nanesootuhina, ka mu te nanamooatupu netutsease, ka mu nanesootuhikuse ewa mu mayugwe ka Egypt-wi'yoona, ka mu wakwawa'a-wa'nekoo. Soo Te Naa yise unu pooha-ga'yoo ka Egypt-wikoo mu bikase, ");
INSERT INTO paoNT_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","mu mabetsea ewa (40) tomoka ka teepu gi numu tumasuana naa-kwi. ");
INSERT INTO paoNT_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Oosoosoo tuwow (7) natakwatsukwuoo-baatoo numu kadoo mayukwe ka Canaan mee naneadu teepu-kooba yise ka te nanamoo'atupu ookow teepu mu tzapokaku. ");
INSERT INTO paoNT_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Unu ewa (450) tomoka'a oosoo ka mu nana'akwedu-matu unu pooha-gakoo netutzease. O'no soo numu moohedu Samuel mee naneadu ka Te Naa God yadooawabe mane. ");
INSERT INTO paoNT_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Umu yise pukobena katudu nekwina, soo Te Naa ka Saul mee naneadu netutsea. Ewa (40) tomoka oosoo ka mu numu-kobena katuna. ");
INSERT INTO paoNT_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","O'no yise soo Te Naa oo nabatsakuse ka David yise netutsea ka numu-kobenatoo. Soo Te Naa God mee unakwe, ‘Soo David, Jesse dooa, oosoo nana e sookwi-kwa'ne'yoo. Ooosapa besa e nakabetseadu.’ ");
INSERT INTO paoNT_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Soo Te Naa God ka Te Pabe'e Jesus tamme Jew numu magwetzoidu matabuepu-ga'yoo. Soo Te Pabe'e Jesus David-matu mee'e soo Te Naa God te tuukwepu-ga'yoo. ");
INSERT INTO paoNT_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Ka Te Pabe'e Jesus gisoo Te Naa unnepu mu numu tuukwe petu, soo John mee naneadu meeoo mu numu tuukwe'e, ‘No'yoona mu Jew numu sakwa ka suda tu manena ma'wuse baa-wi namatzakase ka Te Naa God besa podo mea,’ mee. ");
INSERT INTO paoNT_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Soo John ka numu tu tunedyooena mamakwuse meeoo unakwe, ‘Nu Te Pabe'e mee haa'a mu e sooyugwe? Gi nu. Soo Te Tubetse Pabe'e saa'a petukwu. Nu gi oo-wa'ne'yoo. Oosoo e ooonakwa pooha-ga'yoo.’ ");
INSERT INTO paoNT_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","E nanumu, mu Abraham dooamu-matu yise mu susumudu numu Te Naa meeoo te tuukwe, ‘Nu mu magwetzoikwu.’ ");
INSERT INTO paoNT_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Mu numu Jerusalem-wi nonobe-ga'yoo ka mu pumme moohedu-no tooe nono'atsa ka Te Naa unnepu naka, ka oo tubona naneayakwe, pana gi yise ka Jesus Te Pabe'e sopedakwatoo. Gi oo nakasopedakwatoo ka Te Naa o'nosoo Te Pabe'e-witu oo waha. Umu ka Te Naa unnena gi naka'oedyuku pana oo mayoho. ");
INSERT INTO paoNT_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Umu gi hanotusoo suda na'unnedu ka Te Pabe'e-witu waha-wa'ne'yoo pana ka Pilate ooka batsa tuungu. ");
INSERT INTO paoNT_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","O'nosoo ka Te Naa tuukwewabe meeoo tubopu umu ka Te Pabe'e Jesus batsakwu. Umu yise tooesoo oo manakwe. Oosoo ka ya'ese, ka sunngabe namadabue-ma'yoona natzakwekuse, nakoo. ");
INSERT INTO paoNT_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Soo Te Naa oo matusootabuesoo. ");
INSERT INTO paoNT_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Ewa tabeba-wi oosoo umu-no Galilee-wi'yoona kemmadu natzapoonnekuyakwe. Umuoo naana mu numu oetuooo tuukwe. ");
INSERT INTO paoNT_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Meno'o numme Barnabas-no yow petu mu tuukwe ka Te Naa o'nosoo unnepu ka Te Naa ka Te Pabe'e Jesus tamme magwetzoi-kwitu. ");
INSERT INTO paoNT_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Meno'o toge oo-toogoosoo Te Naa unnepu manakwe. O'nosoo David meeoo tubope-ga'yoo ka penakwa hoobeabe-kwi meeoo unakwe Te Pabe'e witu, ‘Soo Te Naa meeoo unakwe, “U e dooa. Nu u tubetse Naa. Nu meno'o mu numu tuukwe'e.” ’ ");
INSERT INTO paoNT_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","35","Soo Te Naa meeoo unakwe, ‘Nu besa u tummatzikoo ka David e tuukwe-kwa'nesoo.’ Ka kumma'akoosoo David hoobea tubo-kwi tuwazoo meeoo, ‘U gi ka u tunetutzeana tookoo peheku-wa'ne'yoo.’ ");
INSERT INTO paoNT_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Soo David ka Te Pabe'e-witu meeoo tubo'o gi puusoo nakwitu. Soo David ka Te Naa pumme netammatoo manese, ya'e. Ka oo nakoose oo tookoo mooasoo pehewunu. ");
INSERT INTO paoNT_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Pana soo Te Pabe'e tookoo gi pehe. Te Naasoo oo matuusootabuesesoo. ");
INSERT INTO paoNT_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","E nanumu e naka, soo Te Pabe'e Jesus tamme-koobatoo nabatsase, soo Te Naa ka te tuma'emukwana sumu'wase te sootuhikwu. ");
INSERT INTO paoNT_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Ka te tunaka'oedyukute soo Te Naa te tuma'emukwana sumu'wa. Tamme ka te nanamooatupuna manena sukwe mayohona, ka Moses tamme tuukwe-kwa'ne. Soo Te Naa gi te tuma'emukwana sumu'wa tamme ka Te Pabe'e-wi gi tunaka'oedyukuna. ");
INSERT INTO paoNT_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","41","Umu meeoo tubo'o Te Naa meeoo unakwe, ‘E nakapunne. Mu ka gi sootunaka'oedyukuna, mu kadoo'oo namayugwekwu. Ka tooesoo u gwetzoa'e, nu u tummatzikwu. Tooe numu e tuukwe sapa mu gi oo naka'oedyuku-wa'ne'yoo.’ Mu sakwa oo naka'oedyuku, o'no gi mu kadoo'oo namayugwekwu ka mu o'nosoo Te Naa te tuukwe-kwa'ne.” ");
INSERT INTO paoNT_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Mu Paul noko Barnabas nanesootuhi nobe-kwi'yoona umu kukuowse umu meeoo mu netamma, “Ka penakwa nanesootuhikwuse, ka Te Naa unnena saa'a ne tuukwesoo.” ");
INSERT INTO paoNT_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Ewa'yoo mu Jew numu-no mu wakwawa'a mu Jew-kwa'ne nanesootuhi tabuadu ka Paul noko Barnabas-no mea. Paul-no Barnabas mu yadooena meeoo mu netamma, “Mu sakwa Te Naa besa podo ooosapa mea.” ");
INSERT INTO paoNT_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Ka penakwa nanesootuhi tabenoo ewa'yoo mu numu ka Antioch-wi sumu ka Te Naa unnena nakakwuse. ");
INSERT INTO paoNT_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Umu Jew numu moohedu unu suta'a ka ewow numu gi Jew numu pana oetoo kemma ka Paul nakana. Umuoo moohedu ka Paul noko Barnabas unnena netumoo'oo. ");
INSERT INTO paoNT_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Mu Paul-no Barnabas gi mu Jew numu unne-ma suina meeoo unakwe, “Mu ka Te Naa unnena mooe naka. Mu muusoo gi oo naka'oedyukuna mu yise gi nasootuha'e. Numme yise meno'o ka mu wakwawa'a Te Naa unnepu-witu tuukwekwu. ");
INSERT INTO paoNT_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Ka o'nosoo numu meeoo tuukwedu ka Te Naa unnena po tuguse te tuukwe'e. ‘U sakwa no'oko enatu tooe mu wakwawa'a nu-kwitu tuukwe. O'no mu e nakasopedakwadoo yise namagwetzoikwu,’ mee soo Te Naa.” ");
INSERT INTO paoNT_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Mu wakwawa'a oo nakase, besa sokwamana meeoo unakwe, “Soo Te Naa unnepu unu besa'yoo.” No'yoona umu Te Naa tunetutzeana tunaka'oedyukute. ");
INSERT INTO paoNT_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Soo Te Naa unnena yise tooe hanotu tooe yaa teepu-koobatu numu oo naka. ");
INSERT INTO paoNT_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","52","Mu Jew numu moohedu, mu momoko'ne ka mu Jew numu-kwa'ne nanesootuhidu, mu numu moohedu ka mu Paul noko Barnabas tumoo'oose, o'no yise umu ka Antioch-wi'yoona memea. Mu Paul-no Barnabas yise ka Antioch kooseba tu kuku-makoo tata'nese, mu numu tzapoonnekuna ka how suta'yoo umu. Ka Antioch-witu umu tunaka'oedyukudu besa sokwama ka Te Naa Besa Pooha-tooha tunaka'oedyukuna. Mu Paul-no Barnabas yise ka Iconium mee naneadu-wi pepetuga. ");
INSERT INTO paoNT_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Mu waha'yoo nanana, Paul-no Barnabas Iconium mee naneadu-witoo memea, ka mu Jew numu nanesootuha'e oe pepetuooga. Ewa-baatu numu o. Ewa'yoo umu-matu ka Paul soo'oedyukute ka Te Naa unnena oo waha. ");
INSERT INTO paoNT_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Mu Jew numu-matu gi mu Paul-no Barnabas soo'oedyukuna mu nesootzema mee mu wakwawa'a netamma, “Gi mu naka'oedyukupana.” ");
INSERT INTO paoNT_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Ka nanesootuhipe-kwi'yoona kukuowga. Wuna'me ka Iconium-wi gi mu numu-ma suina, mu numu ka Te Pabe'e besa unnepu tuukwe. Mu Paul-no Barnabas ka Te Pabe'e besa pooha punagakoo ewow numu mabesaku. ");
INSERT INTO paoNT_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Mu numu oowetuoo waha-tamme tusooyugwedu susumudu umu-matu tunaka'oedyukute too'esoo umu gi tunaka'oedyukudu. ");
INSERT INTO paoNT_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Mu gi tunaka'oedyukudu Jew mu wakwawa'a mu Jew moohedu-no ka Paul noko Barnabas tupe-ma tagoekwu mee tunetammana. ");
INSERT INTO paoNT_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Mu Paul-no Barnabas ka tu nanetammana nakase, yabesoo oe'yoona memeow. Yabesoo ka kumma'akoosoo teepu, Lycaonia mee naneadu-koobatoo memeahoo. Ka Lystra noko Derbe mee nananeadu-kwi pepetugase, ");
INSERT INTO paoNT_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Te Naa besa unnepu-witu mu numu tuukwe. ");
INSERT INTO paoNT_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Soo nana Lystra-witu tuutse-wi manakwana gi nummedu ");
INSERT INTO paoNT_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","ka Paul naka katu. Soo Paul ka nana poonnese, yise meeoo oo sooyugwe, “Esoo nana unu tunaka'oedyukudu pumme magwetzoi-wa'ne manepunne.” ");
INSERT INTO paoNT_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Soo Paul yise pabatse'e meeoo ka nana netamma, “Kaaheno u kuku-ma wunuhoo.” Soo nana gi nummedu yabesoo yotsehoose, yise numme 'mani. ");
INSERT INTO paoNT_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Ewa'yoo mu numu ka oo poonnena ka besa oo manise puusoo tu yadooa-wi mu nanesootuhikuna yise meeoo mu netamma, “Yaatoo umu pumatoo te nanesootuhina te pa'anakwana numu manise, meno'o yow tamme-baa.” ");
INSERT INTO paoNT_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Ewa'yoo mu numu ka Barnabas-wi meeoo sooyugwe, “Yow esoo pumatoo te nanesootuhina moohedu Zeus mee naneadu,” mee. Yise ka Paul-witu meeoo netamma, “Yow Zeus yadooawabe, Hermes mee naneadu.” ");
INSERT INTO paoNT_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Soo Zeus ka pabow nanesootuhi nobe-ga'yoo ka Lystra-kumaba mu nanesootuhiwabe mu kootsoo koomamu wetzaka ka tonegeadu umu-ma wusoena. O'no yise mu numu sakwa ka Barnabas nanetzakwiya'e mee sokwamana. ");
INSERT INTO paoNT_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Mu Paul-no Barnabas ka mu numu suda manakwe gi besa mu nakasoopedyase puusoo tu kwasu makebuese umu yabesoo mu numu-nagatoo memeahoose, papabatse mu yadooese meeoo, ");
INSERT INTO paoNT_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Gi numme-matoo nanesootuhipana. Numme mu-kwa'ne'yoosoo, sukwe numu, ka besow wahamodu. Gi too ka Zeus-matoo nanesootuhipana, oosoo gi kaaheno unnedu nana. Soo Te Naa no'oko hemma ka teepu-koobatu matabuepu. ");
INSERT INTO paoNT_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Soo Te Naa no'oko mu numu meeoo netamma, ‘Mu uga mummesoo soomea-kwa'ne mea tabu'a pana meno'o mu sakwa nu-matoo suu'mu nanesootuhi.’ Soo Te Naa mooasoo mu numu ka tu pooha tzapoonnekute. ");
INSERT INTO paoNT_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Soo Te Naa powmaba taya ewatse'yoo yise soo tukapu naa, tamme yise nasootuhi,” mee'e. ");
INSERT INTO paoNT_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Mu numu gi ka Te Naa-wi tunaka'oedyukudu togesoo ka Paul noko Barnabas-matoo tu nanesootuhina too'e soogwi, pana gi. ");
INSERT INTO paoNT_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Ka saa'a susumudu mu Jew numu Antioch noko Iconium-wi'yoona kemmadu petu. Mu numu Lystra-witu, “Soo Paul suta'yoo,” mee mu tuukwena. Umu oo too'e tatsagow tupe-ma oo tapagetana. Ka Lystra-wikoo yise oo tzapewuyaka, Paul ya'epu mee sokwamana. Pana gi! ");
INSERT INTO paoNT_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Mu tunaka'oedyukudu ka Paul na'oonnakwi sumuhoose, oosoo yise yotseoose, ka Lystra-witoo kodyuka. Ookow mooo'a, Barnabas-no ka Lystra-wi'yoona memea. Ka Derbe mee naneadu-kwitoo memeakwate. ");
INSERT INTO paoNT_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Mu Paul-no Barnabas ka Derbe-wi pepetuga ewow numu ka Te Naa besa unnepu-witu tuukwe. Ewa'yoo numu tunaka'oedyukudu mane. Mu Barnabas-no Paul kokodyukwate, Lystra, Iconium, noko Antioch Pisidia mee naneadu-too kokodyu. ");
INSERT INTO paoNT_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Ka memeadabenona, mu tunaka'oedyukudu, “Gi mu tunaka'oedyukuna ma'wupana,” mee mu netammana. Mee'e tuwazoo mu netamma, “Mu numu saa'a mu netumoo'ookwu, pana gi umu-ma suipana. Ka saa'a tamme ka Te Naa-matoo meakwu besa-kwitoo.” ");
INSERT INTO paoNT_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","No'oko putoogoo tu meana ooka moohedu netutzeamena mu tunaka'oedyukudu. Mu Paul-no Barnabas gi tukana mu nanesootuhikuna ka Te Naa mee netamma, “U, Ne Naa sakwa mu sootuhi. Besa mu mabetsea.” ");
INSERT INTO paoNT_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Umu ka teepu Pisidia mee naneadu-kwitoo, meme'a, ");
INSERT INTO paoNT_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","ka Perga-wi pepetugase, ka mu numu Te Naa unnepu tuukwe. ");
INSERT INTO paoNT_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Penakwa ka Attalia mee naneadu-kwi pepetugase, ka sake-wi Antioch-witoo punowsoo natzemangeka. Otoo mu nanesootuhidu mu ta'ya mana ka Te Naa besa unnepu waha. Meno'o yise mu Paul-no Barnabas oo manemakwu. ");
INSERT INTO paoNT_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Umu mu kokodyu petuse, mu tunaka'oedyukudu sumuse, mu Paul-no Barnabas ka tu mopu-witu mu numu tuukwe'e oosoo Te Naa ka Te Pabe'e Jesus-witu mu wakwawa'a tunaka'oedyukudu mayugwemena. ");
INSERT INTO paoNT_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Wuna'me yise umu o, ka mu tunaka'oedyukudu-baa. ");
INSERT INTO paoNT_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Mu Jew naana-matu ka Jew teepu-wi'yoona kemmase petugonno, ka mu Te Pabe'e naka'oedyukudu gi Jew numu yise meeoo netamma, “Mu sakwa ka ne nanamooatupu tunetammana mayoho, ka Moses numme tuukwepu. Mu kwu'a na'oonnakwitu sakwa natsekea'a. Mu ka 'yoo manese ka mu Jew numu-wa'nesoo manepunnekwu, o'no soo Te Naa mu magwetzoikwu.” ");
INSERT INTO paoNT_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Mu Paul-no Barnabas oo netumoo'oo ka meeoo mu Jew naana-matu unakwe. ");
INSERT INTO paoNT_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Mu Paul-no Barnabas, susumudu mu tunaka'oedyukudu-no nataya Jerusalem-witoo ka umu nananesootuhidu moohedu oowetuoo tubengakwuse, ka mu susumudu tunaka'oedyukudu ka saa'a puusoo gi oo naka toge'yookuna. Umu Paul-no Barnabas yise ka Phoenicia noko Samaria tubewa-too memeana mu tunaka'oedyukudu tuukwemena, ka mu wakwawa'a gi Jew numu ka Te Pabe'e-wi unu tunaka'oedyukuna. Mu tunaka'oedyukudu yise besa nakasokwama. ");
INSERT INTO paoNT_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Ka Jerusalem-wi petugase, mu tunaka'oedyukudu umu pumme moohedu-no besa nesokwama, ka mu nakana ka Te Naa-witu mu waha, ka Te Naa pumme sootuhipu. ");
INSERT INTO paoNT_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Susumudu numu ka mu nanesootuhidu-matu Pharisee mee nananeadu mee unakwe, “Umuoo wakwawa'a Te Pabe'e naka'oedyukudu sakwa ka tu kwu'a na'oonnakwitu natsekeaku, ka Moses tamme tunetammakupu ka tamme Jew nanamooatupu manena tumayohokuna.” ");
INSERT INTO paoNT_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Umu tunaka'oedyukudu moohedu tunehane oowetuoo nehanekwuse. ");
INSERT INTO paoNT_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Wuna'me umu nanano apegease, soo Peter 'wunuoose mee'e unakwe, “E nanumu, o'nosoo soo Te Naa e pooha nose-kwi meeoo e netamma, mu wakwawa'a ka Te Pabe'e-witu saa'a naka'oedyukudooa. ");
INSERT INTO paoNT_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Soo Te Naa oo sopedakwatoo pumme ka mu wakwawa'a noko ka tu Besa Pooha-matu-ma mu sootuhina tamme tu sootuhi-kwa'nesoo. ");
INSERT INTO paoNT_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Soo Te Naa tamme-wa'nesoo mu matabuepu, mu tuma'emukwana soomu'wa ka mu tunaka'oedyukute. ");
INSERT INTO paoNT_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Mu haa'a gi oo naka tooge'yookute ka Te Naa unnena, mu haa'a mu wakwawa'a tamme nanamooatupu manena mayoho tuungukwu? Umuoo tumayohope unu namanakwe. Tamme puu gi oo mayoho-wa'ne'yoo, umu te nanamooatupu punno'o gisoo. Tamme sakwa gi umu ooka mayoho tuungupana. ");
INSERT INTO paoNT_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Soo Te Pabe'e Jesus te magwetzoina te sootuha'e ka te tunaka'oedyukute. Umu wakwawa'a tamme-wa'ne'yoosoo,” mee soo Peter unakwe. ");
INSERT INTO paoNT_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","No'yoona mu numu gi tunemayuoose, ka Paul noko Barnabas nakapunne. Ka mu numu meeoo netamma, “Ka Te Naa numme pooha-maka-ma numme mu wakwawa'a besa mayugweyakwe.” Ewasoo nanabesa tu manepu-witu mu numu tuukwe. ");
INSERT INTO paoNT_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Umu yise ka apekeamakwuse, soo James mu numu meeoo netamma, “E nanumu, ");
INSERT INTO paoNT_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","mooasoo soo Peter te tuukwe'e, ka mooe'ugasoo soo Te Naa oo tzapoonne ka mu wakwawa'a tu sootuhina, yise umu-matu wakwawa'a tu dooamu mayugweke. ");
INSERT INTO paoNT_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","O'nosoo soo Te Naa tuukwewabe eka toge meeoosoo na'unnedu botugu, soo Te Naa meeoo te netamma, ");
INSERT INTO paoNT_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Nu ewow mu Jew numu tuma'emukwadu kadoo mayugwekwu. Saa'a yise nu ka mu David nanadooamu sootuhidooa. Ka tooe haga tooe anooase, nu oo mayodadooa. ");
INSERT INTO paoNT_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","O'no saa'a mu susumudu numu nu-kwitu naka'oedyukudooa. Susumudu mu wakwawa'a-matu saa'a nu e dooamu mayugwedooa,’ ");
INSERT INTO paoNT_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","mee soo Te Naa unakwe, o'no gisoo hemma oo manakwe.” ");
INSERT INTO paoNT_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Soo James ooosapa yadooadyakwe mee'e, “Yise nu meeoo tusooyukwe tamme sakwa gi unutu-kwikoo mu wakwawa'a tunedyooe ka Te Naa mu naka'oedyukute. ");
INSERT INTO paoNT_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Tamme sakwa umu-matoo tubo mee na'unnedu, ‘Gi hownne'yoo tooe mu gi tumayohona ka mu Jew numu tumayohope. Yoo oo sukwe 'mane: ka mu numu tooe hemma-too tooe nanesootuhidyidu tuka, gi umu-baatu tukapana. Ka nodukwa-gana gi kumma'akoosoo pootamapana. Gi too puupe tukapana. Gi ka hemma tookoo puu-gakoo tukapana tuwazoo. ");
INSERT INTO paoNT_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Yoo sakwa tamme mu mane tuungu mooasoo mu ka yoo tu namanena naka.’ ” ");
INSERT INTO paoNT_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","No'yoona mu tunaka'oedyukudu ka pumme moohedu-no meeoo tusooyugwe, “Numme sakwa mu Paul noko Barnabas ka mu nanana yaatu tamme-matu ka Antioch mee naneadu-witoo taya.” Waahoo nanana yise netutzea ka pumme moohedu-nagatu, Silas-no Judas mee nananeadu. ");
INSERT INTO paoNT_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Tubose, umu-noko oo taya, mee'e na'unnedu, “Mu ne nananumu mu ka tunaka'oedyukudu moohedu-matoo natayana: Mu wakwawa'a Antioch-witu tunaka'oedyukudu mana Syria noko Cilicia mee nananeadu teepu-witu. ");
INSERT INTO paoNT_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Numme meeoo tunaka, susumudu numu yaatuoo mu nemooagana mu nesagwa'e ka tooe ha'yoo tooe mu netammana. Numme gi umuoo mu-matoo ta'ya. Gi numme meeoo mumme mu netamma tuungu. ");
INSERT INTO paoNT_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Meno'o yise numme tunehanese, no'yoona meeoo unakwe, numme nanana tunetutzease mu tayakwu. Umu saa'a ne pupua'amu, Paul noko Barnabas-no kemmadooa. ");
INSERT INTO paoNT_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Mu Paul-no Barnabas too'e nagoehoo ka Te Pabe'e Jesus-koobatoo. ");
INSERT INTO paoNT_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Numme yise Judas noko Silas mu-matoo tayakwu. Eka tubope-kwa'nesoo, umu toge maawa'nesoo mu tuukwekwu. ");
INSERT INTO paoNT_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Ka Te Naa Besa Pooha-no numme meeoo sokwama besa mu ka gi numme Jew numu tumayohope mayohona. Yoo'oo suu'mu sakwa mu 'mane. ");
INSERT INTO paoNT_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Ka mu numu tooe hemmatoo tooe nanesootuhidyidu tuka gi umu-batu tukapana. Ka nodukwa-gana gi ma'emukwapana. Umuoo tumayohope mu nagena besa 'manekwu.” ");
INSERT INTO paoNT_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Mu tubope gwuudu ka mease Antioch-wi petuga. Umu tunaka'oedyukudu tunehane, umu yise ka tubope mu geahoo. ");
INSERT INTO paoNT_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Umu yise oo nease, besa sokwama ka besa oo na'unakwe. ");
INSERT INTO paoNT_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Umu Judas-no Silas yise ewow numu nanesootuhi tunedyoo'e. Tu nanesootuhipe-kwitu mu tuukwena, o'no umu unusoo oo naka'oedyukukwu. ");
INSERT INTO paoNT_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","34","Onosoo ka saa'a umu punowsoo kokodyuka. ");
INSERT INTO paoNT_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Paul-no Barnabas Antioch-wisoo. Umu onatu-nosoo ka Te Naa unnena numu tuukwe. ");
INSERT INTO paoNT_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Saa'a soo Paul ka Barnabas meeoo netamma, “Ta sakwa oona mu numu nono'ata-toosoo moga ka Te Naa God unnepu ta wahapu-witoo mu tunaka'oedyukudu nobengena, howga umu meno'o manakwe?” ");
INSERT INTO paoNT_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Soo Barnabas ka tu nanumu John Mark mee naneadu nepina. ");
INSERT INTO paoNT_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Soo Paul gi oo nepetzabena soo Mark gi umu-no tu nummena mamakwu, ka oona teepu Pamphylia mee naneadu-kwi'yoona nobe-kwitoosoo kodyu. ");
INSERT INTO paoNT_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Mu Paul-no Barnabas nanepetukuse, yise susumu'yoonasoo meakwu mee'e tunetamma. Mu Barnabas-no Mark, ka Cyprus mee naneadu teepu-witoo natsemangega. ");
INSERT INTO paoNT_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Soo Paul ka Silas netutzea puno meakwudu. Mu tunaka'oedyukudu mu nanesootuhikute soo Te Naa umu-kooba tueya'e. ");
INSERT INTO paoNT_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Umu memea oona ka tu memeatoo yise ka mu tunaka'oedyukudu ka Syria noko Cilicia mee nananeadu teepu-koobatu nanesootuhi tunedyooemena. ");
INSERT INTO paoNT_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Mu Paul-no Silas ka memeadabena ka Derbe mee naneadu-too memease ka Lystra mee naneadu-kwi pepetuga. Sumu'yoo tunaka'oedyukudu Timothy mee naneadu oonow nobe-ga'yoo. Oo pea Jew numu. Oo naa mu wakwawa'a numu-matu. ");
INSERT INTO paoNT_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","3","Ookow soo Paul naakwena ka susumudu tunaka'oedyukudu soo Timothy besa'yoo nana mee mu unakwe. Soo Paul yise ka Timothy Jew numu mayugwe mooasoo no'yoona mu Jew numu oo sopedakwadoo soo Timothy naa mu wakwawa'a numu-matu. ");
INSERT INTO paoNT_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Mu Paul, Silas, Timothy-no ka meadabena no'oko tooe hanotu tooe mu tunaka'oedyukudu meeoo tuukwemena. Tamme moohedu Jerusalem-witu meeoo mu netamma, “Gi ka mu Jew nanamooatupu tumayohope mayohopana.” ");
INSERT INTO paoNT_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Mu numu unu tunaka'oedyukudu nono'otsa tabemeakwi ewasoo tunaka'oedyuku manemena. ");
INSERT INTO paoNT_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Soo Te Naa Besa Pooha mu pihoo nanana ka teepu Asia mee naneadu-kwitoo gi nemeakute. Umu yise Phrygia noko Galatia mee nananeadu teepu-kumi me'a. ");
INSERT INTO paoNT_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Ka Mysia mee naneadu teepu-kooba petugase, soo Te Naa Besa Pooha ka teepu Bithynia mee naneadu-koobatoo gi mu nemeakute. ");
INSERT INTO paoNT_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Umu yise Mysia-too mease ka Troas mee naneadu-kwi petuga. Nu Luke, o'no o. Nu yise umu-no manika. ");
INSERT INTO paoNT_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Sumu tooise soo Paul meeoo nose, sumu'yoo nana Macedonia-wi'yoona kemmadu oo nose-kwi oo-baa petu, yise meeoo oo netamma, “Ka Macedonia mee naneadu teepu-koobatoo natzemangese, ne tummatzi.” ");
INSERT INTO paoNT_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Soo Paul ka meeoo nosese numme ka Te Naa-wi tunaka'oedyukuduna oosooga sumuna tu unnena oonow te waha tuunguna, numme yise Macedonia-witoo meakwu. ");
INSERT INTO paoNT_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Numme yise Troas-wi'yoona mea. Numme natzemangekase Samothrace-wi petuga. Ookow mooa numme tuwazoo natzemangeka, Neapolis-witoo sawe petuga. ");
INSERT INTO paoNT_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Numme yise Philippi-wi oona sogo mease oo petuga, soo Philippi ka teepu Macedonia-koobatu mooe nadatsunga. Mu numu otuoo Roman numu. Huu tabeno tooe numme o. ");
INSERT INTO paoNT_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Ka nanesootuhi tabebano numme ka Philippi hooonakwatoo mea ka paa hooodu-kumabaa petuga, mu Jew numu o sumuna nanesootuhiyakwe. Numme aatase, mu momoko'ne nananesootuhidu-no apegea. ");
INSERT INTO paoNT_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Sumu'yoo umu-matu ne nakapunnedu Lydia mee naneadu mogo'ne, Thyatira mee naneadu-witoo nadooa'adoopu. Oosoo Lydia Te Naa-matoo nanesootuhidu. Oo naka'oedyukute ka Te Pabe'e oowetuoo ka Paul pumme tuukwe. ");
INSERT INTO paoNT_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Ka saa'a Lydia ka umu puno baa-wi namatzakapu nenuummakuna mee unakwe, “Mu sakwa nu-baasoo ka e sopedakwatoose, nu punno'o ka Te Pabe'e-wi tubetse tunaka'oedyukudu.” Ne tubetse nenuummakute. ");
INSERT INTO paoNT_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Sumu numme oona pukwi'yoona mu Jew numu nanesootuhidyi-kwitoo meana, oosoo tsuaduma togogwa pooha-ga'yoo ne weke'ahoo. Ka tu togogwa pooha hemma manekwuna pumme oo tuukweyakwe soo tsuadumu mu numu tuukweyakwe. Mu numu ka tsuadumu meeoo neyugwedu ewa natumanakakute ka tsuadumu numu tuukwe-kwi. ");
INSERT INTO paoNT_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","18","Oosoo tsuadumu huu tabeno ne nagedyinnumme paba yadooanummena mee unnena, “Umuoo naana ka Te Matabuepu nayadooawabe. Umuoo mu tuukwekwu how soo Te Manumudoopu mu magwetzoi tabuakwu.” Soo Paul oo-matoo suda soonamme ka tsuadumu ooosapa oo manakwe. Soo Paul yise nakwumunase eka togogwa pooha meeoo netamma, “Ka Te Pabe'e pooha tooha-kwi nu u nematzakukwuni!” Yabesoo yise oosoo suta'yoo poohabe ka tsuadumu naga'yoona tsebooeka. ");
INSERT INTO paoNT_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Umu meeoo ka tsuadumu neyugwedu unu suta'a. Umu oo sopedakwadoona ka hemma manikwuna, yise gi haka natumanakakwu-wa'ne'yoo. ");
INSERT INTO paoNT_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Umu yise ka Paul noko Silas-ma tzakaduse mu numu nehanedu-matoo mu bika. Yise meeoo mu netamma, “Umu naana yow Jew numu, umu tamme-baa'yoona suda tuneyugwe.” ");
INSERT INTO paoNT_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Umu meeoo te netammana, “Numme Jew tumayohona mayoho.” Tamme no'yoona mu netumoo'oo ka gi mu Jew tumayohope tumayoho-wa'ne'yoona. Umuoo tumayohope gi tamme Roman numu tumayoho-kwa'ne'yoo. ");
INSERT INTO paoNT_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Mu numu unu sutana ka mu Paul noko Silas topagetakooha. Mu numu nehanedu yise mu kwasu tzakebooekwunihoose mu tukwutumadu mu Paul noko Silas wupageta tuungu. ");
INSERT INTO paoNT_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Ka saa'a wuna'me mu wupagetase, mu wutumetowse mu tueya'edu umu eya'e tuungu. ");
INSERT INTO paoNT_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Mu tueya'edu yise numu kwinga'a-kwitu-kwi mu wutumetase, mu kowpa wobe tasekeya-wi tsakunetahoo. ");
INSERT INTO paoNT_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Oona togabeno mu Paul-no Silas nanesootuhina tunekwu'upunne, mu susumudu nakwutumadu mu naka. ");
INSERT INTO paoNT_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Soo teepu unu yutsungakooha soo tukwutuma nobe punno'o. Soo tukwutumadu tutzakunedapu wugoomedihoo. ");
INSERT INTO paoNT_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Soo tu'eya'edu tupoonnese, ka tukwutuma nobe nanatzakwuna'a wuwonetahoopu mu mayuhoo. Oosoo puusoo too'e nabatsowkwu ka tu tsegesa-ma, mu nuutumedadu ka kuowka mee soonammena. ");
INSERT INTO paoNT_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Soo Paul pabatseoo yadooese meeoo oo netamma, “Gi uusoo namaguapana. Numme togesoo no'yoonasoo yow.” ");
INSERT INTO paoNT_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Soo tu'eya'edu tukootabuakunoo natuungubodote. Ka unu suise ka Paul-baatoo sookweda meahoose mu-kobena meatzedo petugase, ka unu pooha-ga'yoo mee mu soobedyana, ");
INSERT INTO paoNT_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","oobenakwa yise mu bihoogase mee mu tubenga, “Ha'oo sakwa nu manese namagwetzoi?” ");
INSERT INTO paoNT_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Umu meeoo oo nanekwegea, “Ka Te Pabe'e naka'oedyukuse, u namagwetzoikwu no'oko umu u nobe-kwitu tuwazoo.” ");
INSERT INTO paoNT_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Umu yise no'oko mu nobe-kwitu nokosoo ka Te Naa besa unnepu tuukwe. ");
INSERT INTO paoNT_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Oosoo mu bikease ka tu nuupagetapu-witu baa-ma batzaka, umu yise no'yoona oo nobe-kwitu-nosoo baa-wi namatzaka. ");
INSERT INTO paoNT_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Oosoo yise tu nobe-kwitoo mu bikease mu maka. Te Naa nesookwugana no'yoona oo sootoge'yookute, oo-matoo nanesootuha'e, ka mu Te Pabe'e-wi tunaka'oedyukudu-no. ");
INSERT INTO paoNT_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Ka tu tabuase, mu numu nehanedu mu tukwutumadu taya ka tukwutuma nobe-kwitoo. “Umu Paul noko Silas tzama'wu,” mee unnena. ");
INSERT INTO paoNT_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Soo tu'eya'edu ka Paul meeoo netamma, “Soo mu numu moohedu mumme e tzama'wu tuunguse mu sakwa meno'o nanosoo memea.” ");
INSERT INTO paoNT_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Soo Paul mu tukwutumadu meeoo netamma, “Numme umuoosoo numme tzama'wuna soogwa'e ka umuoosoo suda mane-kwi. Umu ewow numu-koobena'yoona ne wupageta gisoo ne nehanepana. Umu yise ne wutumeta, tooe numme togesapa Roman numupana. Mu Roman tumaduguna puu gi 'yoo ne matugu-wa'ne'yoo. Meno'o yise mikoo ne watze ta'ya.” ");
INSERT INTO paoNT_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Mu tukwutumadu ka mu numu nehanedu-baa petugase mu tuukwe. “Mu Paul-no Silas mu Roman numu-matu.” Mu numu nehanedu yise unu nakasua'e. ");
INSERT INTO paoNT_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Umu numu tunehanedu yise mu Paul noko Silas-baa, ka tukwutuma nobe-kwi petugase mu tzama'wuoo, suda nesokwamana ka mu kusegase. Umuoo punno'o onoko mu tayahookwu. ");
INSERT INTO paoNT_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Mu Paul-no Silas yise tukwutuma nobe-kwi'yoona memeahoose ka nobe-kwi pepetuhooga, ka mu tunaka'oedyukudu oetu meeoo netamma, “Unu ooosapa ka Te Naa unnepu oedyukuno.” Oe'yoona yise memea. ");
INSERT INTO paoNT_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Mu Paul-no Silas memeadabena ka tubetse baa kumana memeana ka mu Amphipolis noko Apollonia mee nananeadu-toogoo memease, Thessalonica mee naneadu-kwi pepetuga. Yise ka Jason mee naneadu-baa tooa'e. Mu Jew numu o nanesootuhi nobe-ga'yoo. ");
INSERT INTO paoNT_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Soo Paul ooka mu Jew numu nanesootuhi nobe-witoo meahoo ka ooosapa maneyina. Yise pahe nasateba-wi nanesootuhibu mu numu tunedyooeyakwe. Soo Paul mu numu ka Te Naa o'nosoo unnena tuukweyakwe oo nabo-kwa'nesoo hemma manegena. ");
INSERT INTO paoNT_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","“Soo Te Pabe'e nabatsase yise tuusootabue,” mee soo Paul mu netamma. “Soo Jesus Te Tubetse Pabe'e.” ");
INSERT INTO paoNT_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Susumudu mu Jew numu ka Paul noko Silas naka'oedyukute ka Te Pabe'e-witu pumme mu tuukwe, ewa'yoo wakwawa'a punno'o mu Jew-wa'nesoo nanesootuhidu, yise ewa'yoo unu nadatsungadu momoko'ne punno'o ka Te Pabe'e-wi tunaka'oedyukute. ");
INSERT INTO paoNT_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Susumudu mu Jew numu-matu mu nuusoogwedakuna, huuhoo umu totoetzeabu sutakoo nanana ka mu numu ka Paul noko Silas-matoo mu nemanekute. Mu numu yise sumuse, ka Jason nobe-kwi petugonnoga ka Paul noko Silas wategana, mu nehanekwu mee unnena. ");
INSERT INTO paoNT_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Ooonne'yoopana yise gi onoko mu ma'yu. Ka Jason noko susumudu mu tunaka'oedyukudu hemmowkase, ka tunehanepe-kwitu mu bihooga. Umu tu tunehanedu meeoo netamma, “Yow mu Paul-no Silas ena no'oko teepu-koobakwi suda tuneyugwedu. Yow yise umu meno'o pepetu.” ");
INSERT INTO paoNT_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Soo Jason mu numu-matu-no mu tummatzina, mu nabaa'yookute. Umu Paul-no Silas gi tamme-kobena katudu oedyukute. Umu pummesoo-kobena katudu oedyukudu, Mu Pabe'e Jesus mee naneadu. ");
INSERT INTO paoNT_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Mu numu, mu pumme moohedu-no naka suta'a ka mu unnena nakase. ");
INSERT INTO paoNT_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Umu ka Jason umu-kooba tumanaga tuunguse, o'no umu mu tzama'wukwu. ");
INSERT INTO paoNT_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","O'no togano mu tunaka'oedyukudu mu Paul noko Silas taya ona Berea mee naneadu-kwitoo. Mu Paul-no Silas yise Berea-wi pepetugase ka mu Jew numu-no nanesootuha'e. ");
INSERT INTO paoNT_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Mu otuoo Jew numu ka mu Jew numu Thessalonica-witu ooonakwa besa'yoo, umu ka Te Naa unnepu-witu besa nakasoobedyana. Umu ooosapa ka Te Naa besa unnepu nabona neadu, ka Paul unnena soonakatoge'yookuna. ");
INSERT INTO paoNT_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Ewa'yoo Jew numu oo soonaka'oedyukute, umu Greek momoko'ne ewa hemma hee-ga-nosoo, ewa'yoo Greek naana punno'o. ");
INSERT INTO paoNT_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Mu Jew numu Thessalonica-witu oo naka ka Paul ka Te Naa unnepu mu numu Berea-witu oo tuukwe. Umu yise o petugase, susumudu mu numu otuoo ka Paul tumoo'oona ka mu numu ka Paul ooemota mu tooe neyugwe. ");
INSERT INTO paoNT_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Mu tunaka'oedyukudu otuoo yise ka Paul ta'yase, mu Silas-no Timothy yise oso. Susumudu mu tunaka'oedyukudu ka Paul-no mea, oona ka tubetse baa-tamme. ");
INSERT INTO paoNT_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Ka Athens mee naneadu-wi petugase, soo Paul umu puno kemmadu punowsoo ta'ya, ka mu Silas noko Timothy yabesoo umu bi tuunguna. ");
INSERT INTO paoNT_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Ka mu Silas noko Timothy gisoo o pepetuga, soo Paul oona ka Athens-dootu sootsemadyinnumme. Ewa'yoo mu numusoo tumadabuena pummatoo mu nanesootuhidyina otuoo. Soo Paul suda soonamme ka pumatoo mu nanesootuhina ewow onoko poonnena. ");
INSERT INTO paoNT_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Ka mu Jew numu nanesootuhi tabeba oe maneyakwe, soo Paul meayina mu Jew numu noko mu wakwawa'a nanesootuhibu tunedyoo'e. Nonotsa tabeno ka Athens-witoo meayina ka mu numu hemma-ma tumudu Te Naa-witu tuukweyakwe. ");
INSERT INTO paoNT_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Susumudu mu numu atakoosoo nanesootuhibu Epicurean noko Stoic mee nananeadu-matu oonow. Paul umu-no yadoo'a. Meeoo umu unakwe ka Paul pumme tuukwe, soo Te Pabe'e tu ya'e-kwi'yoona namayodapu mee'e. Susumudu umu-matu meeoo nananetamma, “Oosoo Paul ooosapa sukwe yadooadu.” Susumudu punno'o meeoo, “Oosoo sumuna wakwawa'a naa nanesootuhi yadooawabe gi toogoope-gakoo te tuukwe.” ");
INSERT INTO paoNT_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Umu yise oona ka tu tunehaneyi-kwitoo ka Paul bika Areopagus mee naneadu-kwitoo. Umu yise meeoo oo netamma, “Yaanona u tooe hemma tooe ne mesoo tuukwekwu ka u tunaka-kwitu. ");
INSERT INTO paoNT_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Numme gi ooonnekoo nakadu. Meno'o numme oo pudu nakakwu. Numme yise punno'o oo nakasopedakwadookwu.” ");
INSERT INTO paoNT_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Mu numu oetuooo ooonne'yoo. Susumudu umu-matu Athens-witoo nadooamu-doopu, umu-matu punno'o oto nowu'apu ooosapa meeoo apegeamodu, besow pudu tusoohanepe tooetoo besa na'unnedu tutunakakwuna sookwipunnedu. ");
INSERT INTO paoNT_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Soo Paul ka mu tunehanedu-kobena wunuse, meeoo mu netamma, “Nu mu sopedakwadoo mu unu nanesootuha'e. ");
INSERT INTO paoNT_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Nu ka mana nummennummena ewow hemma mummesoo tumadabuena pummatoo mu nanesootuhidyina poonne. Nu sumuoo ka pukooba'yoona mu nanesootuhidyina poonne, meeoo oo-ma natubo'o, ‘Pu-matoo ka mu nanesootuhidyina gi mu nakasopedakwadoona.’ Meno'o nu ooka mu tuukwekwu mu tookwa ka Te Naa-matoo nanesootuhi, pana gi oo sopedakwatoo. ");
INSERT INTO paoNT_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Soo Te Naa no'oko hemma nemadugoopedoopu, no'oko hemma manumudoopu, ka yaa teepu-koobatu no'oko tamme-koobawitoo tuwazoo, ka taba, muha, yise no'oko mu paatoozoobu. ");
INSERT INTO paoNT_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Gi soo Te Naa tamme-makoo hemma soogwa'e ka puu te matabuepu-gana te songapu makase, tamme oo-ma yutsungamo'o te sootuha'e ka hemma te soogwa'e. ");
INSERT INTO paoNT_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Sumuoo mogo'ne noko nana mooe matabuepu, umu-ma'yoona yise tamme ewa numu manepetuga. Mooasoo soo Te Naa hemma nemamakwu. ");
INSERT INTO paoNT_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","O'no sumuna mu numu Te Naa watena, yise unusoo manena oetu nakasopedakwadoo. Umu sumuna oetu nakasopedakwadoo pana gi oo unu namanakwe ooka te nakasopedakwadoona. Yow yise soo Te Naa. ");
INSERT INTO paoNT_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Soo Te Naa gwetzoibu te sootuhipu. Mooasoo mu oo sopedakwadoo soo mu hoobeabe bodu meeoo unakwe ka oo bona. ‘Yow tamme ka Te Naa dooamu.’ ");
INSERT INTO paoNT_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Tamme oo sopedakwadoo ka Te Naa, gi oosoo mu numu tumadabuena pummatoo mu nanesootuhi-kwa'ne'yoo. Soo numu ka hemma matabuekwuse, oetuoo mooe soohanese, yise oo matabue. Tupe-ma, weehepu-ma, tooetoo oa tupe-ma oo matabue. Soo Te Naa God gi ooonne'yoo. ");
INSERT INTO paoNT_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Mu gi ooosapa besa tusooyugwedu soo Te Naa ooonne'yoopana mu nakasootuhi. Meno'o soo Te Naa no'oko numu tooe hanotu tooe mee'e netamma, ‘Mu sakwa suda mu tumaduguna ma'wu. ");
INSERT INTO paoNT_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Pudusoo ka teepu atasoo nu yugwekoo, nu bebesow mu-nagatu sootuhikwu, mu sutakoo numu soo suta'yoo umu-matoosoo kodyukwu.’ Soo Te Pabe'e namayodapu ka oo ya'ekwikoo, ooonne'yoona soo Te Naa no'obatusoo numu ka Te Pabe'e-toohakwi sootuhikwu ka pumme mu naka'oedyukute,” mee'e soo Paul ka mu tunehanedu netamma. ");
INSERT INTO paoNT_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Umu ka oo nakase, ka numu ya'ena namayoda-witu pumme oo tuukwese nana'atasoo tusooyugwe. Susumudu umu-matu ka Paul-ma'yoona naneko'e. Umu-matu meeoo unakwe, “Numme owetuoosoo unu besa soonakasopedakwadoo.” ");
INSERT INTO paoNT_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","34","Umu-matu yise tunaka'oedyukudu mane: ka mu tunehanedu-matu Dionysius mee naneadu, mogo'ne Damaris mee naneadu yise huu'yootooe numu tunaka'oedyuku mane punno'o. Soo Paul yise ka mu tunehane-kwi'yoona mea. ");
INSERT INTO paoNT_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Ka saa'a soo Paul yise ka Athens-wi'yoona mease, ona ka Corinth mee naneadu-wi petuga. ");
INSERT INTO paoNT_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Sumu'yoo Jew nana, Aquila mee naneadu Pontus-wi'yoona kemmana ooweoo nobe-ga'yoo. Ka tu nodukwa Priscilla mee naneadu-no ka Rome mee naneadu-kwi ka teepu Italy mee naneadu-wi uga nobe-ga'yoo. Soo Rome numu moohedu Claudius mee naneadu, ka mu Jew numu ka Rome-wikoo ta'ya. Mu Aquila tu nodukwa-no ka Corinth-wi pudu pepetuga. Soo Paul umu-baa nobe-gana, ");
INSERT INTO paoNT_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","umu-no ka tutzekadukupe matabu'e. ");
INSERT INTO paoNT_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Ka mu Jew numu nanesootuhi tabeba oe maneyakwe, soo Paul ka mu Jew numu nanesootuhi nobe-kwi petudyakwe, ka wakwawa'a noko soo Jesus Te Pabe'e mee'e mu tunedyoo'e. ");
INSERT INTO paoNT_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Mu Silas-no Timothy Macedonia-wi'yoona memeakwate. Ka Corinth-wi pepetugase, soo Paul ka tu tutzekadukupe tu matabueyina ma'wukase, ka mu Jew numu nono'otsa tabeno mee mu tuukweyakwe, “Soo Jesus o Te Tubetse Pabe'e.” ");
INSERT INTO paoNT_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","O'no yise mu Jew numu ka Te Naa noko ka Paul tumoo'oo. Soo Paul ka umu suda manakwe mee soonammena, meeoo mu netamma, “Muusoo gi Te Pabe'e naka'oedyukuna, soo Te Naa gi mu sootuha'e. Gi nuga mane-kwi nu mooasoo Te Pabe'e unnena mu too'e tuukwe. Meno'o yise nu mu tsasobedya nu nanesootuhibu mu wakwawa'a sukwe tunedyoo'e.” ");
INSERT INTO paoNT_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Ka mu Jew nanesootuhi nobe-wi'yoona yise mease, oona sumuoo gi Jew numu-matu nana Titus Justus mee naneadu-baa tooi petuga. Esoo nana Te Naa-wi tunaka'oedyukudu. ");
INSERT INTO paoNT_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Oo nobe oonahoo ka mu Jew nanesootuhidu moohedu Crispus mee naneadu no'oko ka tu nobe-kwitu-no Te Pabe'e naka'oedyuku mane. Ewa'yoo mu numu Corinth-witu ka Paul naka, umu yise tunaka'oedyukudu manedu, baa-wi namatzaka. ");
INSERT INTO paoNT_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Sumu togano soo Paul meeoo nose, soo Te Pabe'e-ga mee oo netamma, “Gi nu-kwitoo umu numu u tuukwe-ma suipana. ");
INSERT INTO paoNT_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Nu yow u-notusoo ewa'yoo tuwazoo mu numu yaatuoo nuka sootoge'yookute. U yow nu-mama naduya manepunnedu. Gi haga u matzooeku-wa'ne'yoo.” ");
INSERT INTO paoNT_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Sumu tomona naapahe muha, soo Paul ka mu tunaka'oedyukudu-baa'yoona ka Te Naa unnepu-witu mu tunedyoo'e. ");
INSERT INTO paoNT_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Soo nana, Gallio mee naneadu ka eweoo teepu Greece mee naneadu pudu nehanedu mane. Mu Jew numu nananemooedyugwese, ka Paul tumoo'oo oo-ma tzakaduhoose, ka tunehanepe-kobena oo bi petuhoo. ");
INSERT INTO paoNT_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Yise meeoo ka Gallio netamma, “Esoo nana ka mu numu atasoo tumayoho tuunguna gi numme tumayoho-wa'ne.” ");
INSERT INTO paoNT_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Gisoo ka Paul yadoo'a soo Gallio mee mu Jew numu netamma, “E nakapunne mu Jew numu. Oosoo Paul gi suda manakwe, nu gi mu nakabetseakwu. ");
INSERT INTO paoNT_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Mu sukwe nanepetukute. Mumme tumayohope-wi'yoona muusoo sakwa oo nemadabu'e nu gi ooka mu nemadabueku-wa'ne'yoo.” ");
INSERT INTO paoNT_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","No'oko yise ka tunehanepe-wikoo mu tayahoo. ");
INSERT INTO paoNT_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Umu Jew numu yise ka pumme nanesootuhi moohedu Sosthenes mee naneadu ka tunehane nobe-kobena'yoona unu mooedyugwe. Soo Gallio gi ha'yoo mu netamma. ");
INSERT INTO paoNT_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Wuna'me manepetuga soo Paul ka Corinth-wi. Saa'a mu tunaka'oedyukudu-baa'yoona mea, mu Priscilla-no Aquila, ono mangeka ka teepu Syria-tamme. Ka Cenchrae mee naneadu-wi petugase, ka Te Naa tu nagena tzapoonnena tu tzopuhu tseka'a. ");
INSERT INTO paoNT_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","20","Meadabena ka Ephesus mee naneadu-wi petuga, soo Paul ka mu Jew numu nanesootuhi nobe-wi petugase, soo Paul ka mu Jew numu-no yadooakwuse, otuoo mu numu oesoo nenuummakute. ");
INSERT INTO paoNT_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Soo Paul yise mee mu netamma, “Gi nu. Nu saa'a kodyu petudooa, ka Te Naa nuka meeoo netamma.” Mu Priscilla-no Aquila oso mamani, puu suu'mu soo Paul ka Ephesus-wi'yoona mea. ");
INSERT INTO paoNT_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Ka Caesarea mee naneadu-wi petugase, mu tunaka'oedyukudu-no nanesootuhi. O'nona meadabena ka Antioch-wi petuga. ");
INSERT INTO paoNT_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","O tooe huudooe tabemea, mu tunaka'oedyukudu-baa. Ooosapa meadabena ka mu teepu Galatia-no Phrygia mee naneadu-too meana, mu tunaka'oedyukudu ka Te Naa-witu tuukwe ooka mu naka'oedyuku-kwitoo mu nenoyukwe me'a. ");
INSERT INTO paoNT_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Sumu'yoo Jew nana Alexandria-witoo nadooa'adoopu, Apollos mee naneadu, unu soonammena oo sopedakwatoo ka Te Naa unnena nabotuguna. ");
INSERT INTO paoNT_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Oosoo Apollos mooasoo oo nakapana gisoo ka Te Naa po-witu natunedyooepu, ka Te Pabe'e po-witu mu tuukwekwuse sapa, ka John baa-wi numu matzakayina suu'mu oetu sopedakwadoona, ka Ephesus-wi petu. ");
INSERT INTO paoNT_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Mu yadooekooha gi mu numu-ma suina, ka mu Jew nanesootuhi nobe-wi'yoona. Mu Priscilla-no Aquila oo nakase, oo-matoo kekemmase, ewasoo ka Te Pabe'e-witu hemma oo tuukwe'e. ");
INSERT INTO paoNT_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Saa'a soo Apollos mee tusooyugwe, “Nu sakwa Greece-witoo natsemangega,” Mu tunaka'oedyukudu meeoo oo netamma, “U oto mea.” Umu yise mu tunaka'oedyukudu-matoo tubose, mu tuukwe, “Soo Apollos unnena togesapa.” Soo Apollos ka o petugase, ka Te Pabe'e naka'oedyukudu netummatza'e. Soo Te Naa yise mu nakasootuhina, ");
INSERT INTO paoNT_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","ewow numu tzapoonnekute ka mu Jew unnena gi togekoo. Soo Te Naa oo tzapoonne soo Jesus togesapa Te Pabe'e mee oo nabotugu. ");
INSERT INTO paoNT_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","7","Soo Paul ka Apollos togesoo Corinth-wikoo sogo meadabenona ka Ephesus mee naneadu-kwi petuga. Sumumano waha-ma tsebooekudu (12) naana o, mu tunaka'oedyukudu. Soo Paul mu mayuse, mu tubenga, “Soo Te Naa haa'a Tu Besa Pooha-matu-ma mu sootuhi, ka tunaka'oedyuku mu manese?” Umu meeoo oo nanekwegea, “Numme gi ka Te Naa Besa Pooha-witu nakadu.” Soo Paul tuwazoo meeoo mu tubenga, “Hownnekoo mu nasootuhise ka baa-wi namatzaka?” Umu meeoo oo tuukwe'e, “Soo John oetu numu tuukweyina yise numu matzakayakwe oo numme yugweyakwe ka tunaka'oedyuku ne maneyakwe.” Soo Paul yise meeoo mu netamma, “Soo John baa-wi numu matzaka ka sutakoo podo mu meadabepu mu nematzakakwunise, yise ka Te Naa besa podo mu meadape. Meeoo soo John mu tuukwekwuna'e. ‘Sumu'yoo ka saa'a e-nakwi kemmadooa. Ooka sakwa mu naka'oedyuku.’ Soo John netammana Te Pabe'e Jesus mee nane'a.” Mu numu ka Paul unnena nakase, baa-wi namatzaka ka Te Pabe'e-wi tunaka'oedyukuna. Soo Paul yise tu mi-ma mu wo-ma matuguyina, soo Te Naa yise tu Besa Pooha-matu-ma mu sootuhiyakwe. Umu yise nanakumma'akoosoo yadooa-ma apegeagonno, ka Te Naa Besa Pooha-ma oo unnena wahakono. ");
INSERT INTO paoNT_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Pahe muha-wi soo Paul mu Jew numu nanesootuhibu tunedyooeyakwe ewa ka Te Naa besow po-witu mu tuukwena. Soo Paul gi umu-ma sua'e. ");
INSERT INTO paoNT_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Susumudu mu Jew-matu tusoomatzooekuna gi oo naka'oedyukuna, suda ka Te Naa-witu netamma ka numu ewa-kwi'yoona. Soo Paul yise umu punno'o Te Pabe'e naka'oedyukudu-no ka Jew nanesootuhi nobe-kwi'yoona me'a. ");
INSERT INTO paoNT_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Waha tommo petuga, umu ka nono'otsa tabeno ka natunedyooe nobe Tyrannus mee naneadu-kwitoo numu tunedyooebodona. Paul ka Te Pabe'e unnena no'obatusoo numu modu tunedyoo'e ka teepu Asia mee naneadu-kwi'yoona. ");
INSERT INTO paoNT_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Soo Te Naa yise ka Paul ewow Tu Besa Pooha-matu-ma sootuhise oosoo yise ewahoo numu mabesaku. ");
INSERT INTO paoNT_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Mu numu besa mayugweyakwe. Susumudu numu ka wanapu noko kwasu-matu natzakebooena ka Paul-makoo tuhanena, ka mu tuoegoedu-matu hemedyakwe. Mu tuoegoedu yise besa maneyakwe, mu tzoapugoedu punno'o. ");
INSERT INTO paoNT_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Susumudu Jew numu mu tsoapa madidu mana tooe manemo'o ka mu tsoapa too'e nematzagakwunina. Umu ka Te Pabe'e pooha-ma gi nasootuhipu, mu tsoapa sukwe too'e tayakwunina ka Jesus nanea-ma. Umu meeoo ka tsoapa netammayakwe, “Nu u tayakwuna'e ka Paul ooosapa wahana ka Jesus nanea-ma.” ");
INSERT INTO paoNT_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Natakwatsukwu'yoo (7) nanakwannga'amu ka Jew nanesootuhidu moohedu, Sceva mee naneadu dooamu, uga tsoapa nematzagakwunidu. Umu ka tsoapa too'e nematzagakwuni, ");
INSERT INTO paoNT_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","pana soo tsoapa gi me'a, meeoo mu sukwe nanekwegea, “Nu ka Jesus sopedakwatoo, ka Paul tuwazoo. Mumme nu gi sopedakwadoo. Mu gi umu-wa'ne'yoo. Hownne'yoo mu?” ");
INSERT INTO paoNT_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Soo tsoapayaedu nana umu-koobatoo nadawunihoose, mu kwasu magebooekwunihoose, unu mu moomooedyugwese yise ka nobe-kwikoo mu matzayubahoo. ");
INSERT INTO paoNT_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","No'yoona numu ka o nakase Te Pabe'e pooha nesookwuga'e, “Besa'yoo,” mee ka Te Pabe'e Pooha netamma. ");
INSERT INTO paoNT_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","O'no yise ewa'yoo mu tunaka'oedyukudu ka suda tu manena nanekwahamena. ");
INSERT INTO paoNT_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Ka tu manepu mu numu uga poohadu ka sutakoo tu pooha pukwi nanabotuguna ka mu numu-kobena hane petuse mu tuna'e. Ooonnekoo mu tzapoonnemena ka suda tu manena ma'wukwuse oo nemawunina. Ka oetu tu nasoohane-kwi mu manenaga sumuna tubetse ewa nanenaga. ");
INSERT INTO paoNT_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Ka 'yoo tu namane-kwi soo Te Naa unnena umu-tamme nanakasopedakwadoo manekese, ewa'yoo numu ka Te Naa unne-kwitu naka'oedyuku manepetu. ");
INSERT INTO paoNT_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Obenakwa, soo Paul meeoo soonamme, “Nu sakwa mana ka teepu Macedonia noko Greece-too mease, ka Jerusalem mee naneadu-kwitoo. Onona yise ka Rome mee naneadu-kwitoo mea.” ");
INSERT INTO paoNT_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Waahoo nanana pumme tummatzidu, Timothy-no Erastus mee nananeadu, mooe taya nakobenasoo Macedonia-witoo. Sagwane wuna'me o ka Asia mee naneadu teepu-kooba. ");
INSERT INTO paoNT_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Ka gisoo Ephesus-wi'yoona oo me'a ewa'yoo numu Paul tuaganena ka Te Pabe'e unnepu-witu oo waha. Mu numu otuoo, gi Jew numu, Artemis mee naneadu numu tumadabue-matoo nanesootuha'e. Ka pabow nanesootuhi nobe-kwi soo Artemis namadabu'e Ephesus-wi. ");
INSERT INTO paoNT_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Soo Demetrius mee naneadu ka esekweehepu-ma ka mu nanesootuhi nobe-kwa'ne tutugutse tumadabuena ka umu pumme tummatzidu-no ewa oo-ma tumu'u. Mu numu yise tu nobe-kwi oo hanena oo-matoo nanesootuhi. ");
INSERT INTO paoNT_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","No'oko pukwa'ne tumadabuedu nesumuse, mee'e mu netamma, “E pupua'amu tamme 'yoo te tumadabue-ma gwetzoi. ");
INSERT INTO paoNT_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Esoo nana Paul yise ka mu numu meeoo netamma, ‘Gi ka numu tumadabue-matoo nanesootuhipana. Umu gi hee, gi toogoope-ga'yoo.’ Ewa'yoo numu oo nakabetse'a yow Ephesus-wi tuwazoo mana no'oko ka teepu Asia-kooba. ");
INSERT INTO paoNT_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Ka saa'a mu numu gi te tumadabuena petzabekwu, tamme Artemis nanesootuhi nobe noko ka Artemis tuwazoo gi petzabekwu. Esoo Artemis paba nanenagadu pummatoo mu nanesootuhina no'yoona Asia-koobatu noko yise ka te teepu-koobakwitu.” ");
INSERT INTO paoNT_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Umu ka ekow nakase, unu nakasagwa'e. No'yoona yise wa'agekoohase meeoo unnegonno, “Soo Artemis pummatoo ne nanesootuhina, Ephesus-wi naduyadu.” ");
INSERT INTO paoNT_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Pudusoo numu no'oko ka ootuoo nakase, umu-baa manekakwu. Umu waahoo ka Paul pupua'amu-ma tzakatu Gaius noko Aristarchus mee nananeadu ka Paul-no Macedonia-wi'yoona kekemmadu, yise pabow pukwikoo mu tunehaneyi-kwitoo mu bihooka. ");
INSERT INTO paoNT_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Soo Paul oetoo too'e neme'a, ka mu numu ewa-kwikoo mu yadooekwu mee soonammena pana mu tunaka'oedyukudu gi oetuoo oo meakute. ");
INSERT INTO paoNT_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Susumudu umu numu mooedu-matu Paul pupua'amu mee oo tuyatuukwe'e, “Gi ka mu tunehane-kwitoo meapana.” ");
INSERT INTO paoNT_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Mu numu nana'atasoo wa'agemo'o ka gi oo sopedakwatoona ka pukwitu mu nanesumuna. ");
INSERT INTO paoNT_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Sumu'yoo Jew, Alexander mee naneadu oe. Susumudu mu numu-matu ono apegea. ");
INSERT INTO paoNT_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Mu numu ka oo Jew oo sopedakwatoo oosoo gi Artemis-matoo nanesootuhidu, umu yise pabasoo wa'agekooha Atemis pummatoo ne nanesootuhina unu naduyadu. Ooosapa wa'agegonno wuna'metoo. ");
INSERT INTO paoNT_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Mu tunehanedu tubowabe mu numu yadooena mee mu netamma, “E pupua'amu, no'yoona numu oo sopedakwatoo tamme yow Ephesus-witu ka pabow Artemis nanesootuhi nobe mabetseadu. Tamme ka pooha tupe pa'anakwana tamme-matoo wuepu hee-ga'yoo. ");
INSERT INTO paoNT_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","No'yoona numu te sopedakwatoo, tamme togesapa ka Artemis-matoo nanesootuhidu. ");
INSERT INTO paoNT_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Umu nanana mu bi petuna, gi hemma tuduha ka te nanesootuhi nobe-kwitu. Gi umu ena suda tuukwe, ka Artemis-witu. ");
INSERT INTO paoNT_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Tamme tunehanewabe-gana tunehaneyakwe tuwazoo. Mu Demetrius umu punotu-no ka ha'yoo numu soonetammana umu sakwa mu tunehane-witoo meeoo mu netamma. ");
INSERT INTO paoNT_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Mu ka ewasoo ha'yoo soo'unena mu sakwa tunehanepe-kwikoo nanemadabue. ");
INSERT INTO paoNT_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Gi tamme ha'yoo ka Roman numu-kooba katudu tuukwe-wa'ne'yoo, ha'oo manena tamme yaa tabeno sumu'u. Umu sumuna mee te netamma ka te nanago'e. ");
INSERT INTO paoNT_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Mu sakwa no'yoona nobe-kwitoosoo kodyuka.” ");
INSERT INTO paoNT_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Ka saa'a hemma namamakwuse, soo Paul no'oko mu tunaka'oedyukudu nesumuse mu yadoo'e, ka Te Pabe'e unnepu-witu mu tuukwena. Yise ka Ephesus-wi'yoona natzemangeka ka Macedonia mee naneadu teepu-witoo. ");
INSERT INTO paoNT_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Ka meadabena ewow tunaka'oedyukudu tunedyooemena ka Greece mee naneadu teepu-kooba petuga. ");
INSERT INTO paoNT_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Pahe muha yise o. Syria-witoo natzemangekakwuse, ka mu Jew numu pumme batsayagate mu sopedakwatoona. “Nu sakwa kodyu Macedonia-too ka Jerusalem-witoo,” mee soo Paul tusooyugwe. ");
INSERT INTO paoNT_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Ewa'yoo numu oo-no mea. ");
INSERT INTO paoNT_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","No'yoona mu naana ka natzemangekase, ka Troas mee naneadu-kwi petuga. O ne wutooekwu. Nu Luke, yise Paul punno'o. ");
INSERT INTO paoNT_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Numme Philippi-wi gi namayudu tukaba mu ewa tukakwuse pepetuga. Numme yise umu-baa'yoona ka Philippi-wi'yoona memease natzemangekase, ka Troas mee naneadu-kwitoo. Manege tabe mease, numme ka umu-baa pepetuga ka Troas-wi. O numme sumu nasate. ");
INSERT INTO paoNT_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Naapahe tu tabemeano'o togano, numme nanano sumu nanesootuhina atsa baa hebena tukaba tukakwuse. Paul wuna'me mu yadoo'e ka oogow mooo'a Troas-wi'yoona meakwuse. ");
INSERT INTO paoNT_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Togabeno maneka numme ka nobe-kwikoo ewa tugootabuekuna. Pahe nana-kooba aatadu nobe-wi'yoona, ka numu sumu-koobatu-wi numme. ");
INSERT INTO paoNT_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Sumu'yoo tooebetse Eutychus mee naneadu ka naboonne'e natsatawaga-wi katu. Unu uwegapana ka Paul unnena naka katu. U'weoogase, yise ka naboonne'e natsatawaga-wi'yoona wuehoo. Mooasoo oo ya'ehoose umu oo too'e tsagwuuhoo. ");
INSERT INTO paoNT_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Soo Paul umu-matoo wuegase, ka oo-koobakwi habehoose oo hedapunnese oo ya'e-kwikoo oo tzakodyuhoo mu numu yise meeoo netammadooa, “Gi suda sokwamapana. Mooasoo nu a nemagwetzoihoo.” ");
INSERT INTO paoNT_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Oobe pa'atusoo mea'ase, umu no'yoona nanesootuhina ka Te Pabe'e pumme tunetammapu mayoho. Soo Paul yise ka tu tabatsebooe-witoo tooe mu yadoo'e. Soo Paul mu yadooemakwuse mea. ");
INSERT INTO paoNT_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Umu ka tooebetse gwetzoihoodu tu nobe-witoo bikase, yise unu besa sokwama. ");
INSERT INTO paoNT_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Ka Jerusalem-tamme numme meana ka Ephesus tzage'etoo natzemangeka. Soo Paul oto sogo meakwu mee unnega. ");
INSERT INTO paoNT_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Assos-wi'yoona numme-baa sake-wi tsebooese, no'yoona numme natsemangega ka Mitylene-witoo. ");
INSERT INTO paoNT_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Oogow mooo'a numme tuwazoo natsemangega ka tuutse pagadudu ooenapatoo Chios mee naneadu-witoo. Oogow mooo'a tuwazoo numme yise ka Samos mee naneadu-witoo. Oogow mooo'a tuwazoo numme yise ka Miletus mee naneadu-kwi petuga. ");
INSERT INTO paoNT_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Jerusalem-witu mu ewa tuka tzage'e manegena umu ka Te Naa nesookwuga'ena ka tu tumasuana besa su'a. O'no petugakwu mee soo Paul soonammena, ka Ephesus ka teepu Asia mee naneadu-wi gi yoowa'e. ");
INSERT INTO paoNT_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Soo Paul ka Miletus-wi petugase Ephesus-witoo sumuoo taya mu wakwa'etse-matoo, mu tunaka'oedyukudu moohedu Ephesus-wi nobe-ga'yoo nabatoo mu bi tuunguna. ");
INSERT INTO paoNT_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Ka pu-baa mu petuse, meeoo mu netamma. “Mu e sopedakwatoo, nu ka Te Naa besa podo ooosapa meadape. Nu ka mu-baa'yoona yaa Asia teepu-kooba'yoona. ");
INSERT INTO paoNT_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Nu ka Te Naa nakabetse'a, ‘Nu mu ooonakwa besa'yoo,’ mee gi soonammena. Nu yagana ka Te Naa-matoo mu nanesootuhikute. Nu ka mu-baa'yoona ooosapa suta-kwi ka mu Jew nuka tumoo'oo. ");
INSERT INTO paoNT_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Nu gi suina no'oko hemma mu tuukwe'e mumme tummatzi-wa'nekoo tooe haga tooe-kobena'yoona mu nobe-kwitu tuwazoo. ");
INSERT INTO paoNT_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Nu mu Jew noko mu wakwawa'a meeoo netamma ka sutakoo po ma'wukase ka Te Naa besa podo mea. Ka Te Pabe'e Jesus-wi tunaka'oedyukuna. ");
INSERT INTO paoNT_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Meno'o yise soo e pooha mee'e e netamma, ‘Jerusalem-witoo mea,’ pana nu gi oo sopedakwatoo how hemma manekwuna ka onona. ");
INSERT INTO paoNT_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Eka suu'mu nu sopedakwatoo no'oko Te Naa Besa Pooha mee e tuukweyakwe nu nakwutumakwu yise ewa suda namanedu nu-tamme kemmakwu. ");
INSERT INTO paoNT_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Pana gi hownne'yoo. Oosoo gi hee. Nu gi nuusoo namabetsea, nu ka Te Pabe'e nuka netamma mamakwukwu. No'oko numu nu ka besa na'unnedu tuukwekwu. Oosoo te magwetzoa'e ka te soobedyana.” ");
INSERT INTO paoNT_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","Soo Paul meeoo tuwazoo mu netamma, “Nu mooasoo mu tuukwepu ka Te Naa besa podo a nameadabena. Meno'o nu oo sopedakwatoo mu gi ka teepu-koobakoosoo e poonne-wa'ne'yoo. ");
INSERT INTO paoNT_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","27","Nu gi suina no'oko mu tuukwe ka Te Naa manekwuna. Gi nuga manena mu ka Te Naa besa po ma'wukase, ka ya'ese, gi Te Naa-matoo mease. ");
INSERT INTO paoNT_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Muusoo no'yoona nanamabetseana soo Te Naa Besa Pooha umu tunaka'oedyukudu mu mabetsea tuungu ka umu Te Naa naka'oedyukudu-nokosoo. Oosoo Te Pabe'e doodooamu mu mayugwe ka Te Pabe'e mu-koobatoo nabatsase. ");
INSERT INTO paoNT_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Nu oo sopedakwatoo ka e mease, saa'a ewa'yoo etza'a mu-baa petuse mu too'e nemooagana tooe ha'yoo tooe mu netammakwu. Ewow sumuna mu tunaka'oedyukudu kadoo mayugwekwu. ");
INSERT INTO paoNT_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Mu-matu sumuna ka etza'a podo manese, umu ka Te Naa naka'oedyukudu esayikuna tooe ha'yoo tooe mu tuukwena, umu ka mu tunaka'oedyukudu too'e ne'emukwakuna. ");
INSERT INTO paoNT_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Unu besa sapa, nu pahe tommoka ooosapa ka Te Naa-witu meeoo mu too'e tuukwegena ka mu-koobatoo tutuha nasooyugwena. ");
INSERT INTO paoNT_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","Meno'o yise nu ka Te Naa mumme sootuhi tuungu oo unnepu-noko ka numu oo sootuhina unu tunaka'oedyuku mu mayugwekwu. Soo Te Naa mu sootuhikwu tu unne-kwa'nesoo ka umu tu besa podo meadabedu-nokosoo. ");
INSERT INTO paoNT_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Nu gi mu-makoo hemma soogwa'e. ");
INSERT INTO paoNT_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Mu, mooasoo e sopedakwatoo, nuusoo e tukapu noko pukwi e kwasuena tumu'u umu nu-notu punno'o ooosoo. ");
INSERT INTO paoNT_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Mu e manena poonne ka mu tutuha manedu e tummatza'e, mu sakwa punno'o ooosoo. Mu oo sooma'yu ka Te Pabe'e tamme mee netamma, ‘Tamme besa nasootuhikwu ka kumma'akoosoo hemma numu tummatzina gi ka kumma'akoosoo numu-makoo hemma sookwipunnena.’ ” ");
INSERT INTO paoNT_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Soo Paul yise ka tunemamakwuse, meatzedose, nanesootuhikooha. ");
INSERT INTO paoNT_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","No'yoona umu oo-baatu sukwina oo hedana oo mootuhina ka oo tubetse meakwuse. ");
INSERT INTO paoNT_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Umu suda sokwama ka meeoo pumme oo netamma, “Nu gi hannano'o mu-baasoo kodyu petu-wa'ne'yoo.” Umu yise ka sake-witoo o-no mea pana, gi o-no oe ku'a. ");
INSERT INTO paoNT_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","3","Numme mu tunaka'oedyukudu-baa'yoona mea. Numme Jerusalem-tamme natzemangeka. Meadabena numme ka teepu Syria mee naneadu-kwi petuga ka Tyre mee naneadu-wi. Ka onona soo sake-wi nanodu natzasawekute. ");
INSERT INTO paoNT_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Numme mu tunaka'oedyukudu onoko mayuse umu-baa naapahe tooipunne. Ka Te Naa Besa Pooha-toohakwi umu ka Paul meeoo netamma, “Gi Jerusalem-witoo meapana.” Pana oosoo gi mu nakabetsea. ");
INSERT INTO paoNT_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Ka ne mea-kwi oo manepetugase numme ka sake-witoo mea. Mu tunaka'oedyukudu numme-no ne takwunikakwuse: nanana, momoko'ne, tu doodooamano. Numme oona pakumaba petugase, meatzedose, nanesootuha'e. ");
INSERT INTO paoNT_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Numme mu ma'wukase ka sake-wi tzoonooaka, umu yise nobe-kwitoo kodyu. ");
INSERT INTO paoNT_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Meadabena numme ka Ptolemais mee naneadu-kwi petuga. O numme mu tunaka'oedyukudu nobe'nge umu-baa numme tooi. ");
INSERT INTO paoNT_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Ooga mooo'a numme mea ka Caesarea mee naneadu-kwitoo. Philip mee naneadu mu nanesootuhidu tunedyooedu o nobe-ga'yoo. Oosoo umu natakwatsukwu'yoo-matu (7) a nanetutzeana ka mu gi koomamu-gakoo pepeawabe mabetseadu. ");
INSERT INTO paoNT_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Oosoo watsukweoo tsutsu'a padumu-ga'yoo ka hemma manekwuna numu tuukwedu. Umu-baa numme. ");
INSERT INTO paoNT_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Huu'oo tooise, sumu'yoo nana Agabus mee naneadu o petu ka teepu Judea mee naneadu-wi'yoona kemmadu. Oosoo punno'o umu-wa'ne'yoosoo ka hemma how manekwuna numu tuukweyakwe. ");
INSERT INTO paoNT_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Oosoo numme-baa petu. Oona ka Paul nate natuku oo gwuu'hoo. Ka nate-ma tu mi noko tu kuku namatzakunase, meeoo ne netamma, “Soo Te Naa Besa Pooha meeoo soo numu eka nate hee-ga'yoo mu Jew Jerusalem-witu yooonnekoo oo tzakunakwu. Oo oo yugwese umu ka mu wakwawa'a moohedu oo tzageakwu.” ");
INSERT INTO paoNT_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Numme ka o nakase, numme ka mu numu-no ka Paul too'e nenuumakute, “Gi Jerusalem-witoo meapana,” meeoo oo netammana. ");
INSERT INTO paoNT_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Soo Paul mee ne sukwe netamma, “Gi sukwipana mu suda e nesoonnumme. Ka Te Pabe'e Jesus-koobatoo oosoo gi hownne'yoo tooe e tzakunapana. E batsase sapa gi hownne'yoo.” ");
INSERT INTO paoNT_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Soo Paul gi ne nakabetse'a. Numme oo nema'wuse gi hayoosoo ooetuooo netamma. Nummesoo meeoo nananetamma, “Oo-toogoo manekwu.” ");
INSERT INTO paoNT_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","O'no yise numme namahanese ka Jerusalem-witoo mea. ");
INSERT INTO paoNT_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Susumudu Caesarea-witu tunaka'oedyukudu numme-no mease oona Mnason nobe-kwitoo ne bikea. O yise numme tooikwu. ");
INSERT INTO paoNT_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Numme Jerusalem-wi petuga, mu tunaka'oedyukudu besa numme-matoo sokwama ka pu-baa ne petugase. ");
INSERT INTO paoNT_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Oogow mooo'a soo Paul numme-no mea ka mu tunaka'oedyukudu moohedu, James mee naneadu-no ne apegeakwuse. No'yoona mu tunaka'oedyukudu moohedu oe. ");
INSERT INTO paoNT_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Soo Paul no'oko tu nummepu-witu mu tuukwe, “Soo Te Naa mu wakwawa'a sootuhi ka pumme mu naka'oedyukute ka nuga unne-wi.” ");
INSERT INTO paoNT_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Ookow nakase, mu tunaka'oedyukudu moohedu no'yoona ka Te Naa nesookwuga'e mee unnena, “Te Naa besa'yoona numu nakasootuhiyakwe ka mu wakwawa'a besa tu sootuhi-kwa'ne.” O'no yise ka Paul meeoo netamma, “Yow tamme-nagatu mu Jew numu tumayoho-kwi umu tooesoo oo naka'oedyukute. ");
INSERT INTO paoNT_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Ewa'yoo numu u-kwitu naka u ka mu Jew numu mu wakwawa'a-nagatu mee netamma, ‘Gi ka Jew tumayohona mayohopana,’ meeoo u-kwitu tu nana'esagoena numme naka. ");
INSERT INTO paoNT_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Umu ka u petuse oo naka. ");
INSERT INTO paoNT_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","U sakwa ka te tumayohona besa oo-toogoo a nameana mu tzapoonneku. Watsukwe'yoo naana numme-notu ka Te Naa meeoo netamma, ‘Numme mu Jew numu tumayohope mayohokwu.’ ");
INSERT INTO paoNT_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","U sakwa namahanese umu-no mease, oetoo mu natunekwina tumanaka. O'no yise ka mu tumamakwuse, mu tzopuhu no'oko wutseba. U ka oo manena no'yoona numu u sopedakwadookwu ka te tumayohona u mayohose. ");
INSERT INTO paoNT_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Gi hownne'yoo mu wakwawa'a ka Te Pabe'e Jesus-wi tunaka'oedyukudu, ka mu Jew numu tumayohona gi mayohona. Mooasoo numme umu wakwawa'a-matoo tubopu mee na'unnedu, ‘Gi hownne'yoo mu ka Jew tumayohona gi mayohona. Yoo sakwa mu sukwe mane. Gi ka numu tumadabuena pumatoo mu nanesootuhina nabeamakapu tukapana, puu-gakoo a tookoo tuwazoo. Gi nanakumma'akoosoo numu aahe pootammapana.’ ” ");
INSERT INTO paoNT_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Ookow mooo'a soo Paul namahanese, ka mu watsukwuoo nanana-no, yise ka pabow nanesootuhi nobe-witoo mea'a. Meeoo mu tuukwena, “Pudusoo tamme Jew tumayohope namamakwuse no'yoona ka Te Naa hemma nabeamakakwu.” ");
INSERT INTO paoNT_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Sumu nasateka mu Jew numu putoogoo ka tu nanesootuhina mu mayohokwuse. Mooasoo oo namamakwuga'a, mu Jew numu Asia-witu kemmana, ka Paul wohonedu, ka Paul poonne oona ka pabatsekoo nanesootuhi nobe-wikoo. Umu oo-ma tzakaduse, papaba apegeakooha, ");
INSERT INTO paoNT_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","ka mu ewow numu oetu meeoo netammabodote, “Ne nanumu, yabe ne tummatzi. Yaa'a esoo suta'yoo nana, ka mana tooe hano tooe numu tunedyooena tamme numu nekwohonena, te tumayohona tumoo'oodu, ka te nanesootuhi nobe nokosoo. Meno'o yise masoo te nanesootuhi nobe totsakute ka mu wakwawa'a, gi Jew numu, eka te pooha nobe-wi bi petuse.” ");
INSERT INTO paoNT_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Umudoo ka Paul nesootzemana ka sumuoo wawa'a Ka teepu Cilicia mee naneadu-wi. Paul-noko Asia-witu kemmadu poonnese, ka Jerusalem-witoo mu memeabodote. Umu ka Paul gi sootoge'yookute, “Ka tamme nanesootuhi nobe-wi wawa'a bi petuna,” meeoo oo sooyugwena pana soo Paul gi oo. ");
INSERT INTO paoNT_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Ewa'yoo mu numu Jerusalem-witu sumukooha, ka nanesootuhi nobe-wikoo puuwanatoo ka Paul tzabewo'yowkase, ka natzakwona'a tzadumow. ");
INSERT INTO paoNT_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Umu yise oo too'e batsowkwu. O'no yise mu Roman tukwutumadu pabe'e oo nakahoo ka namaniwunudu. ");
INSERT INTO paoNT_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Mu tukwutumadu ka mu numu sumu-kwitoo tatanomanega. Mu numu ka putamme mu tatanomanegena mu poonnese, ka Paul tu yugwegonnona ma'wuhoo. ");
INSERT INTO paoNT_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Mu tukwutumadu ka Paul-baa petugonnose, oo mi-ma tzakadu yise waahoo tukwutumadu naamookwi nama'wetzogoeyakuhoo. Mu moohedu meeoo yise mu numu tubenga, “Haga esoo nana? How suda esoo manakwe?” ");
INSERT INTO paoNT_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Mu numu nana'atasoo unnegonno soo tukwutumadu moohedu gi mu nakasopedakwatoo. Soo mu moohedu ka mu tukwutumadu yise meeoo netamma, “Oona tamme pukwi'yookwitu a bihooka.” ");
INSERT INTO paoNT_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Yise ka a natupoyano-wi petuhoose, mu tukwutumadu oo tokwuhooka ka mu numu ewana unu sutagonno. ");
INSERT INTO paoNT_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Umu mu-nakwi ooosapa mu nageno'o, “A batsa,” mee unnena. ");
INSERT INTO paoNT_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Ka nobe-kobena oo natzakwona-wi petuhoogase, mu Greek yadooa-ma soo Paul ka tukwutumadu moohedu mee netamma, “Nu sakwa u-no yadooa.” Soo mu moohedu oo nekwegea, “U tzakadoo Greek-ma mesoo yadoo'a? ");
INSERT INTO paoNT_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","U haa'a oosoo nana Egypt-witu kemmana ka pudu oosoo nana tutzanagoekuse, yise ewa (4000) naana mu tugoedu-nagatu ka giba-matoo bika?” ");
INSERT INTO paoNT_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Soo Paul meeoo oo nanekwegea, “Nu gi. Nu Jew numu. Nu ka Tarsus mee naneadu-wi numu-baa nabotugu. How sakwa nu ka mu numu-no yadooase?” ");
INSERT INTO paoNT_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","“Unudea,” mee soo tukwutumadu moohedu oo nema'e. Ka pa'a tu natupoyano-wi soo Paul wunuse, mayodahoo, mu numu yise gi tunemayuhoo, ka mu Jew numu yadooa-masoo mu numu yadooekooha. ");
INSERT INTO paoNT_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“E nanumu, e nakapunne. Nu gi hannano'o suda tumadugupu.” ");
INSERT INTO paoNT_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Mu numu ka pummesoo yadooa-ma ka Paul Jew-ma yadooakoohase, gi tunemayuhoo. ");
INSERT INTO paoNT_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","Soo Paul meeoo mu numu netamma, “Nu yow tubetse Jew. Nu ka Tarsus-witoo nadooa'adoopu pana Jerusalem-wi'yoona natunedyooepu. Nu besa ka tumayohope natunedyooepu ooka te nanamooatupu unne-gapu. Ka Gamaliel mu mooasoo sopedakwatoo, uga nuka ekow nanesootuhipe tunedyooepu. Nu ooosapa ka Te Naa-witu unu soohanedu, mu-kwa'ne'yoosoo. ");
INSERT INTO paoNT_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Nu uga umu Te Pabe'e podo meadu tumoo'oo. Nu yise mu naana noko momoko'ne umu-nagatu wutumetayakwe, susumudu nu go'e. ");
INSERT INTO paoNT_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Mu Jew numu tutunehanewabe no'yoona oo sopedakwatoo e unnena togesapa. Tubope e geana ka mu Jew numu moohedu tuukwena ka mu Jew numu Damascus-witu nuka tummatzi tuunguna. Numme e pupua'amu-no ka Damascus-witoo mea'a, ka mu Te Pabe'e naka'oedyukudu Damascus-witu yaa Jerusalem-witoo hane petuse ka mu wutumetakwuse. ");
INSERT INTO paoNT_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","Oona tabeno-nakwa ka Damascus tzage'e ne kemma hee sapaga tukwukwutsebu-wa'ne'yoo besa kootabuadu pa'anakwana ");
INSERT INTO paoNT_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","e wunapow. Nu nuka tu yadooese oo nakahoo, ‘U yow ooosapa suda e masoonammennumme.’ ");
INSERT INTO paoNT_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Nu oo tubenga, ‘Haga u?’ Mee yise e netamma, ‘Nu mu Pabe'e Jesus U suda e masoonamme ka e naka'oedyukudu tumoo'oona.’ ");
INSERT INTO paoNT_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Umu e pupua'amu nu-notu ka kootabuatu poonne pana gi Te Pabe'e unnena naka. ");
INSERT INTO paoNT_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Nu yise ka Te Pabe'e meeoo netamma, ‘Ha'oo yise nu manekwu?’ Soo Te Pabe'e meeoo e netamma, ‘Yotsese, ka Damascus-witoo mea. Ka o u petugase, u manekwuna u natuukwedooa.’ ");
INSERT INTO paoNT_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Nu ka kootapuape-ma kootupooseya'ehoo. Umu e pupua'amu yise ka Damascus-witoo e tzakaka. ");
INSERT INTO paoNT_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","Sumu'yoo nana, ka te Jew tumayohope besa mayohodu Ananias mee naneadu oonow. Mu Jew numu oonow nobe-ga'yoo mee sokwama, ‘Soo Ananias besa'yoo nana.’ ");
INSERT INTO paoNT_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Ka saa'a soo Ananias nu-baa petuoo, wunupunnese, mee e netamma, ‘Besa manese, mitu poonne.’ Nu yabetse esoo mitu poo'nese oo poo'ne. ");
INSERT INTO paoNT_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Mee yise e netamma, ‘Soo Te Naa te nanamooatupu pummatoo nanesootuhina ume netutzea. U sakwa Te Naa unnetoo mane ka Te Pabe'e poonnese oo unnena naka'oedyuku. ");
INSERT INTO paoNT_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","U sakwa oo waha u pooha poonnena, u pooha nakana tuwazoo. No'obatoosoo numu sakwa u tuukwe. ");
INSERT INTO paoNT_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Nu baa-wi u matzakakwu. U ka Te Pabe'e Jesus-matoo nanesootuhina, soo Te Pabe'e suda u tumaduguna u-makoo namatzakakwunikwu. O'no yise u besa nuummakwu.’ ");
INSERT INTO paoNT_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","Ka saa'a nu Jerusalem-witoo kodyukase, nu nanesootuhina, ka tammesoo nanesootuhi nobe-kwi'yoona, nu meeoo tuusoobedya. ");
INSERT INTO paoNT_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","E tuusoobedya-kwi Te Pabe'e nu-kumaba wunuse meeoo e netamma, ‘Yabe sapa Jerusalem-wi'yoona meahoo. Mu Jew numu gi u naka'oedyuku-wa'ne'yoo too'e nu-kwitu besa u wahasapa.’ ");
INSERT INTO paoNT_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Nu meeoo unakwe, ‘Umu sumuna e nakapunnekwu ka puusoo oo sopedakwatoona, nu uga umu u-kwi tunaka'oedyukudu ka ne tunehanedu-kobena'yoona kusekana, mu wutumeta. ");
INSERT INTO paoNT_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Nu, o'no o ka mu Jew numu ka Stephen tupe-ma natatzagaze, o wununa nu mu tummatza'e, ka mu wunagapu hemapunnena.’ ");
INSERT INTO paoNT_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Soo Te Pabe'e yise mee e netamma, ‘U sakwa mea. Nu oona kwinga'atoo mu wakwawa'a-matoo u tayakwu,’ ” mee'e soo Paul nanekwaha. ");
INSERT INTO paoNT_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Mu numu oo nakapunne ka “Wakwawa'a,” meesoo unnese, oo sopedakwatoose ka puu gi mu wakwawa'a petzabena umu yise paba mee unnegonno, “A batsa. Masoo gi he-toogoo besa'yoo, gi numme-wa'ne.” ");
INSERT INTO paoNT_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Umu wa'agena tu kwasu tzakebuekwunina toogoo-baa koosebu tapebu'agonno, ka oo manena, “Suta'yoo numu,” mee ka Paul netammana. ");
INSERT INTO paoNT_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Ewatse suda mu unnegonno soo mu Roman tukwutumadu pabe'e umu tu tukwutumawabe ka Paul ka tukwutumadu nobe-kwitoo bigase ooka mu wupageta tuungu. Soo mu moohedu ka Paul meeoo soobedyana oosoo sakwa sumuna pumme tu wupagetase, ka suda tu manena waha. ");
INSERT INTO paoNT_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Ka pummetu tzakunayakwe soo Paul ka tukwutumawabe moohedu putsage'e wunudu meeoo netamma, “Nu yaahoo Roman numu ooonne'yoona ka gisoo e nanehane, u gi e wupageta-wa'ne'yoo. Tamme Roman numu gi yoo nuugwe-wa'ne'yoo. Oosoo tamme tumayohope o.” ");
INSERT INTO paoNT_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Soo tukwutumawabe ka oo nakase meahoo ka pumme moohedu-matoosoo mease, meeoo oo netamma, “Tamme suda manakwe ka ekow nana wupagetakwuse. Esoo tookwa yise tamme Roman numu-matu.” ");
INSERT INTO paoNT_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Soo mu tukwutumadu moohedu ka Paul-baa petuse, meeoo oo tubenga, “U haa'a togesapa numme Roman numu-matu?” “Aha,” mee soo Paul. ");
INSERT INTO paoNT_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Soo mu tukwutumadu moohedu mee unakwe, “Nu Roman numu namayugwepu, nu ewa oo e mane-kwi tumanagapu.” Soo Paul yise meeoo, “Nu yow ooosapa tubetse Roman numu.” ");
INSERT INTO paoNT_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Ooka pumma tu wupagetakwuna hemana yabesoo umu oo tzama'wuhoo soo umu moohedu punno'o unu sua'e, oosoo oo sopedakwatoo ka Paul Roman numu manepunnena, umuoo sakwa uga gi oo tzakunapana. ");
INSERT INTO paoNT_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Oogow mooo'a soo tukwutumadu moohedu mee soonamme, “Hekwi mu Jew numu ka Paul oo yugwe?” Ka Paul nabatoo mu bi tuungu ka tukwutuma nobe-wikoo, yise ka mu Jew tunehanedu nesumudoose, ka Paul umu-kobena bi petu. ");
INSERT INTO paoNT_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Soo Paul gi umu-ma suina mu tunehanedu poonnese, mu mesoo yadooe, meeoo mu netamma, “E nanumu, nu ka ooosapa kaaheno tumadugunona oo sopedakwatoo, soo Te Naa punno'o e sopedakwatoo.” ");
INSERT INTO paoNT_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","O'no soo Jew numu tubetse moohedu Ananias mee naneadu ka Paul tzage'e konnodu-matu ka Paul kobikoo oo matake tuungu. ");
INSERT INTO paoNT_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Soo Paul meeoo ka Ananias netamma, “Soo Te Naa punno'o ume ooosoo yugwekwu. U gi besa'yoo pana u nasookwatsetuguna, besa nasooyugwe. U gi besa numu matugudu. U gi besa'yoo te tumayohope-toohakwi ka e nemadunagana tooe uusoo punno'o gi oo-toogoo tumayohopana meeoohoo. U sakwa uga umu gi e matake tuungupana.” ");
INSERT INTO paoNT_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Mu numu oo konnopunnedu ka Paul meeoo netamma, “U suda unakwe. U uga gi ka mu numu tubetse moohedu meeoo yadooe-wa'ne'yoo, soo Te Naa oo netutzeapu.” ");
INSERT INTO paoNT_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Soo Paul mu nekwegea, “Oosoo haa'a numu-kooba manepunnedu? Meeoo ooetuooo nabotuku, ‘Gi ka mumme moohedu suda netammapana.’ ” ");
INSERT INTO paoNT_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","8","Soo Paul oo sopedakwatoo ka mu tutunehanedu puu nanakuma-matoosoo mu nanesootuha'e. Susumudu umu-matu nananesootuhidu Sadducee mee nananeadu-matu. Umu gi oo naka'oedyukute ka numu tu nadya'e-wi'yoona yotsekwuna, yise mu toha kakasa-gakoo umu Te Naa tutummatzidu, mu tsoapa-witu tuwazoo. Susumudu umu-nagatu Pharisee mee nananeadu oo naka'oedyukute ka numu ya'ese mu yotsese, ka mu toha kakasa-gakoo tuwazoo ka tsoapa-nokosoo. Soo Paul yise mu tunehanedu yadooe, “Nu yow tubetse Pharisee nanesootuhidu. E naa punno'o ooosoo. Ooonne'yoona umu e tumoo'oogena, nu oo naka'oedyukute ka numu tu ya'e-wi'yoona mu yotsena.” ");
INSERT INTO paoNT_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Mu tunehanedu puusoo nanano nanepetukukooha. Wahaba manese apekeagonno. Umu Pharisee-matu Paul-witu mee netamma, “Esoo Paul gi suda manakwe. Soo toha kasa-ga'yoo sumuna tooe hemma tooe oo tuukwepu, tooetoo poohabe sumuna.” ");
INSERT INTO paoNT_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Umu tunehanedu papabatse nanepetukukooha. Soo tukwutumadu moohedu unu sua'e. Umu sakwa sumuna ka Paul unu ma'e, mee soonammena. Umu tu tukwutumawabe meeoo netamma, “Oo bihooga oona te nobe-witoo.” ");
INSERT INTO paoNT_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Oogow togano soo Paul meeoo nose. Soo Te Pabe'e oo-baa petuse meeoo oo netamma, “Gi numu-ma suipana. U mooasoo Jerusalem-wi nu-witu wahapu. Saa'a tuwow u Rome-wi nu-witu wahadooa.” ");
INSERT INTO paoNT_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","13","Oogow mooo'a mu Jew nanana (40) nanano meeoo tunetamma, “Numme gi tukana, gi too baa hebekwu, ka Paul nabatsano'otootooe.” ");
INSERT INTO paoNT_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Umu ka mu Jew numu tunehanedu-baa petuse, mee mu netamma, “Numme meeoo tubetse unakwe. Numme gi tukana, gi baa hebekoo, ka Paul nabatsa-kwitoo tooe.” ");
INSERT INTO paoNT_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Mu tunehanedu mu tukwutumadu moohedu meeoo netamma, “Numme ewasoo ka Paul hemma tubenga pena'e. Ka tunehanepe-witoo ka Paul bihooka. Numme namamakwupunnekwu, gisoo ka Paul tunehane-kwi nabi petu numme oo batsowkwu.” ");
INSERT INTO paoNT_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Soo Paul nanakwu mu naka ka mu unnena. Soo oo nanakwa yise ka mu tukwutumadu nobe-wi petugase, ka Paul-no yadoo'a. ");
INSERT INTO paoNT_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Soo Paul ka mu tukwutumadu moohedu meeoo netamma, “Ka tooebetse bihooka ka mumme moohedu-matoo. Esoo hemma oo watze tuukwekwu.” ");
INSERT INTO paoNT_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Soo tukwutumadu moohedu ka tooebetse bihookase, ka pumme moohedu-matu yise mee oo tuukwe, “Soo nakwutumadu Paul mee naneadu u-matoo ka tooebetse e bi tuungu. Esoo hemma u watze tuukwekwu.” ");
INSERT INTO paoNT_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Soo tukwutumadu tubetse moohedu ka tooebetse tzakowka numu-wanatoo, yise oo watze tubenga, “Hayoo u e tuukwekwuse?” ");
INSERT INTO paoNT_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Soo tooebetse oo nanekwegea, “Mu Jew numu watze tunehane. Mooo'a saa'a u ka Paul mu tunehanedu-matoo bikadooa. Umu meeoo u netammakwu, ‘Numme ka Paul ewasoo nakwitu tubengakwu.’ ");
INSERT INTO paoNT_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","U sakwa gi mu naka'oedyukupana. Ewa'yoo (40) mu Jew nanana gi tukana, gi hepe, ka Paul tu batsakwu-kwitoo tooe. Umu ka Paul watse hoawina, ka oo patsakwuse. Ume unnena umu meno'o wutooepunne.” ");
INSERT INTO paoNT_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Mu tukwutumadu tubetse moohedu ka tooebetse meeoo netamma, “Gi haka tuukwepana ka nuka u tuukwepu. U sakwa meno'o mea.” ");
INSERT INTO paoNT_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","24","Soo mu tukwutumadu tubetse moohedu waahoo tu tukwutumadu moohedu nabatoo mu bi tuungu. Ka pu-baa mu pepetuhoose, soo tukwutumadu tubetse moohedu meeoo mu netamma, “Ewatsekoo (470) tukwutumadu nehanepunne ka Paul-too namamakwupunne. Yaa togano oona sumu kadoopu-wikoo (9) mu saa'a mea'adooa ka Caesarea mee naneadu-tamme. Mu ka Paul besakoo bikakwu ka te moohedu Felix mee naneadu-matoo.” ");
INSERT INTO paoNT_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","26","Soo Claudius Lysias ka te moohedu Felix-matoo tubohoo mee na'unnedu. ");
INSERT INTO paoNT_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","“Yaa esoo nana, Paul mee naneadu, mu Jew numu mamatzakaduse, a too'e batsowkwu. Nu ka a Roman numu a sopedakwadoose numme umu tukwutumudu-no a magwetzoi. ");
INSERT INTO paoNT_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Saa'a nu a bikadooa ka mu Jew numu tunehanedu-matoo, ‘How manena umu meeoo a netamma?’ mee'e nu soonammena. ");
INSERT INTO paoNT_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Gi hekwi tookwa umu meeoo a netamma, a nebatsana. Gi tookwa esoo pumme wutuma-wa'ne. Ka tu tumayohope gi a tumayoho-kwi mee a netamma. ");
INSERT INTO paoNT_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Nu meeoo natuukweoo susumudu Jew numu ka Paul batsayagate mee. Ooonne'yoona nu yabesoo u-matoo a ta'ya. Nu too u-matu ka umu Paul tuaganedu ta'yakwu tuwazoo. Ume-kobena'yoona sakwa umu meeoo a netamma,” mee'e soo tukwutumadu pabe'e tubo'o. ");
INSERT INTO paoNT_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Umu tukwutumadu togawano meadabese, ka Paul Antipatris-wi bi petuga. ");
INSERT INTO paoNT_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Oogow mooo'a mu sogo meadu tukwutumadu punowsoo kodyuka tu nobe-kwitoo. Mu tukwutumadu poopookoo-ga'yoo ka Paul-nosoo meadabe ka Caesarea mee naneadu-kwitoo. ");
INSERT INTO paoNT_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Ka oonow petugase, ka Paul ooka Felix-matoo bika, yise ka tubope oo gea. ");
INSERT INTO paoNT_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Soo Felix ka tubope neahoose, ka Paul yise meeoo tubenga, “Hanotu teepu-koobatoo u nadooa'adoopu?” “Ka teepu Cilicia mee naneadu-koobatoo nu,” mee'e soo Paul. ");
INSERT INTO paoNT_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","Soo Felix yise meeoo oo netamma, “Ka mu numu ume tuaganedu petuse, nu saa'a u nehanedooa.” Felix ka mu tukwutumadu yise ka Paul wutuma tuungu pabatsekoo nobe-kwi, o'nosoo uga ka numu moohedu Herod mee naneadu nobe-wi. ");
INSERT INTO paoNT_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Ka saa'a huu oo tabe mease, soo mu Jew numu tubetse moohedu Ananias mee naneadu, susumudu mu Jew numu moohedu-no ka pukoobatoo yadooadu Tertullus mee naneadu-no petugonno. Ka Felix-kobena oo bi petuse ka Paul tubetse suda nemadabu'e. ");
INSERT INTO paoNT_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","3","Ka Paul Felix-kobena bi petuse soo Tertullus meeoo ka Felix netammakooha, “U numme Jew numu unu besa masokwama ka numu nehane manese. U ka besow gwetzoibu ne tummatza'e no'oko ka teepu-koobakwi. Numme u netubetseayikwu ka yoo u mane-kwi. ");
INSERT INTO paoNT_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","5","Numme gi u nematza'makwu. Gi haa'notse'e ne nakapunne, numme eka Paul-witu yabesoo u tuukweoo. Esoo Paul suda tuneyugwedu, numme Jew noko mu Roman numu tsanagoekuna no'oko ka teepu-koobakwi. Esoo nana Paul ka nanesootuhibu-wi mu moohedu ka Nazarene mee nananeadu-matu. ");
INSERT INTO paoNT_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","7","Ka ne nanesootuhi nobe suda too'e ma'e, numme yise mamatsakatu. ");
INSERT INTO paoNT_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","U sakwa uusoo oo tubenga, o'no yise u ume ne tuukwena naka'oedyukukwu.” ");
INSERT INTO paoNT_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","No'yoona mu Jew numu moohedu yise meeoo unakwe, “Soo numme-koobatoo yadooadu togesapa yadoo'a.” ");
INSERT INTO paoNT_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Soo Felix ka Paul tu mi-ma matuukwe ka oo yadooa tuunguna. O'no yise soo Paul meeoo oo netamma, “Ewasoo tommokapu u numu nehanena nu u sopedakwatoo. Nu nuusoo nakwitu u mesoo tuukwe, o'no yise u e unnekwuna nakasopedakwadookwu. ");
INSERT INTO paoNT_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","U oo sopedakwadookwu ka sumumano wahama tsebooekudu (12) tabe meapu, nu ka Jerusalem-wi'yoona nanesootuhidyina. ");
INSERT INTO paoNT_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Mu numu nuka tuakanedu ka nanesootuhi nobe-wikoo e mayu. Nu gi mu numu nesumuna, gi numu-no nanepetukute. Nu yise gi mu numu ka nanesootuhi nobe-wi'yoona tsanagoekute, gi tuwazoo ka Jerusalem-wi'yoona. ");
INSERT INTO paoNT_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Soo umu unnena gi tookoope-ga'yoo umu ka esagoena. ");
INSERT INTO paoNT_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Nu yise meeoo unnekwu nu ka Jesus podo me'a, kummasoo nanesootuhidu mee umu e netamma, pana nu gi ooohoo. Nu togesoo Te Naa-matoo nanesootuha'e, ka te nanamooatupu nanesootuhiputoo me'a. Yise nu no'oko ne tumayohope tumayohoku me'a, ka o'nosoo ka Te Naa-witu nabotugutoo. ");
INSERT INTO paoNT_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Nu umu-wa'nesoo tunaka'oedyukute, soo Te Naa mu bebesow tuipu numu mayodakwu pana mu susutakoo soo suda mu manena umu-matoosoo kodyukwu. ");
INSERT INTO paoNT_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Ooonne'yoona nu ooosapa besa'yoona o sopedakwatoo. Soo Te Naa e sopedakwatoo, mu numu punno'o. ");
INSERT INTO paoNT_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","Wuna'me nu mana nummennumme nanesootuhina, yaa yise nu nugasoo teepu-wi pudu kodyu petu. Ewa nu natumasumudookuse ka mu tutuha manedu e nanumu nu haneku petu. Nu ka nanesootuhipe-kwitoo tuwuniyakwe ka mu Jew numu tumayoho-kwa'ne. ");
INSERT INTO paoNT_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Mu Jew e mayuhoo, tu nanesootuhi nobe-kwikoo, nu ka mu Jew numu tumayohona mayohokwuse. Nu gi haga wawa'a-no. Nu tuwazoo gi tutsanagoekute. ");
INSERT INTO paoNT_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Susumudu Jew numu Asia mee naneadu-kwi'yoona kemmadu oe. Umuoo nu-ma tzakadu. Umuoo sakwa meno'o yownona, oetu waha ka how suda e tumadugu. ");
INSERT INTO paoNT_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Umu Jew numu nehanedu meno'o yaatoo sakwa oo waha ka suda e manena sopedakwatoona. Umu oho ka mu Jew tunehanedu-kobena e nanekwunukuse. ");
INSERT INTO paoNT_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Nuuga sumuna suda manakwe ka umu-naga'yoona paba meeoo unnewununa, ‘Nu nanehane mu-kobena'yoona ka oo naka'oedyukuna soo Te Naa ka tuipu numu matuusootabueyakwe.’ ” ");
INSERT INTO paoNT_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Mooasoo soo Felix ka Te Pabe'e po-witu sopedakwatoo. Ka tunehanepe neyooikuhoose mee mu netammana, “Ka mu tukwutumadu tubetse moohedu, Lysias mee naneadu, petuse, nu saa'a u nemamakwudooa.” ");
INSERT INTO paoNT_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Ka tukwutumadu moohedu Paul-kooba tueya'e tuungu. Tu soomane-kwa'nesoo ka oe'yoona masoo mesoo manakwe. Umu a pupua'amu punno'o a mesoo mabetse'a ");
INSERT INTO paoNT_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Huuoo tabe mease, soo Felix tu nodukwa ka Paul-witoo taya oo-no yadooakwuse. Umu ka Paul nakapunne ka tu tunaka'oedyuku-witu Te Pabe'e Jesus-witu oo waha. ");
INSERT INTO paoNT_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Soo Paul yise meeoo mu tuukwe, “Mu sakwa uga besa'yoo, ka gi kumma'amasoo emukwana, ka nanodukwana. Soo suda mu manena umu-matoosoo kodyukwu.” Soo Felix nakasu'ise yise meeoo oo netamma, “Meno'o sakwa u ka tukwutuma nobe-witoosoo namakodyuku. Nu saa'a u bidooa.” ");
INSERT INTO paoNT_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Soo Felix meeoo soonamme, “Soo Paul hemma e geakwu ka pumme e tzama'wuse,” pana soo Paul gi oo manakwe. Ooosapa ka Paul-witoo tutayayakwe ka oo-no yadooayina. ");
INSERT INTO paoNT_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Soo Felix gi ka Paul tzama'wu, ka mu Jew numu matubetseana, waha tomoka kumma'yoosoo nana, Porcius Festus mee naneadu, nanetutzease ka teepu-kooba numu moohedu Felix kapi mani. ");
INSERT INTO paoNT_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Soo Festus ka Caesarea-wi petuga, ka teepu-kooba numu moohedu manese. Ka saa'a pahe tabe mease, ka Jerusalem mee naneadu-witoo mea. ");
INSERT INTO paoNT_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Ka petugase, mu Jew tunehanedu oo-no yadoo'a ka Paul netumoo'oona. ");
INSERT INTO paoNT_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","Meeoo oo tubetse netamma, “Ka Paul Jerusalem-witoo ne tayaku.” Ka tooesoo oo kemma umu oo watse batsakwuse. ");
INSERT INTO paoNT_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Pana soo Festus meeoo unakwe, “Pudusoo nu kodyukakwu Caesarea-witoo. Soo Paul togesoo oonow nakwutuma. ");
INSERT INTO paoNT_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Umu mumme moohedu-matu sakwa nu-no mea. Onona umu ka Paul syda nabeoy wagadiia,” ");
INSERT INTO paoNT_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","“Soo Festus umu-baasoo namewatsu (8) tooetoo sumumano (10) tabe mea ka Caesarea-wisoo kodyu petuse. Oogow mooo'a yise tunehane. Ka Paul nakobenatoo mu bi tuungu. ");
INSERT INTO paoNT_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Ka Paul petuoose, mu Jew numu moohedu Jerusalem-witu mee unnekooha. “Ewa masoo suda tumayugwepu.” Gi hownnekoo umu kaaheno oo waha-wa'ne'yoo ka oo oo manakwe. ");
INSERT INTO paoNT_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Soo Paul ka Festus meeoo netamma, “Nu ka Jew tumayohope, no'oko ka ne nanesootuhina gi netumoo'oodu, ka mu Roman numu-kooba katudu tuwazoo.” ");
INSERT INTO paoNT_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Soo Festus ka mu Jew numu moohedu sootupua'apunnena hemma too besa umu-nakwana tusookwipunnena ooonne'yoona ka Paul meeoo netamma, “U sakwa Jerusalem-witoo mea. Onona sakwa tuwazoo u nanehane.” ");
INSERT INTO paoNT_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Soo Paul oo nekwegea, “Meno'o nu yow mu Roman numu tunehane-kwi. Yaanonasoo sakwa nu nanemamakwu. U oo tubetse sopedakwatoo nu gi ka mu Jew numu suda tumadugudu. ");
INSERT INTO paoNT_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Nu sakwa uga ka suta'yoona, ka hemma ha'oo suda yugwese, oetoo nabatsa-wa'ne'yoo, u sakwa yise e batsa. Pana nu gi e nabatsakwuna namame'a. Pana nu gi suda tumadugudu nu gi nuka mu netamma-kwa'ne manakwe. U gi nuka mu batsa tuungu-wa'ne'yoo. Tamme Roman numu-kooba katudu sakwa e tunetammaku.” ");
INSERT INTO paoNT_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Soo Festus tu pupua'amu-no yadooase, ka Paul meeoo netamma, “Unudea. U ka tamme-kooba katudu ume nemamakwu tuunguna, nu oo-matoo u tayakwu.” ");
INSERT INTO paoNT_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Ka saa'a sumu'yoo nana, Agrippa mee naneadu, tu hama'a, Bernice mee naneadu-no, ka Festus nobenge petuga. Soo Festus umu-kumabasoo teepu-koobatu moohe katudu. Soo Agrippa, Bernice-no ka Caesarea mee naneadu-wi pepetuga, ");
INSERT INTO paoNT_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","huu togano ka Festus-baa tooiyakwe. Soo Festus ka Paul-witu ka Agrippa tuukwe'e, “Sumu'yoo nana yow nu-baa Felix oo wutumase, oo ma'suka. ");
INSERT INTO paoNT_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Nu ka Jerusalem-wi petugase, mu Jew moohedu-no oowetoo nehane. Umu yise meeoo e netamma, ‘Ooka ne batsaku.’ ");
INSERT INTO paoNT_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Pana nu meeoo mu nanekwegea, ‘Soo ne Roman tumayohope yoo manepunne, mooe'ugasoo soo Paul ka mu pumme tuakanedu uga mooe nanekwegeakwu. O'no yise umu oo nemadubuekwu.’ ");
INSERT INTO paoNT_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Ka yaa mu petuse, ka saa'a oogow mooo'a awamooasoo nu mu nehane. Nu eka nana nakobenatoo mu bi tuungu. ");
INSERT INTO paoNT_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Umuga saa'a nanasuda oowetuoo e tuukwedooa mee nu soonamme. ");
INSERT INTO paoNT_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Pana gi! Umu ka tu nanesootuhipe-witu e tuukwekooha. Umu sumuoo nana-witu e tuukwe Jesus mee naneadu ya'ese, ‘Soo Jesus namayoda,’ mee soo Paul. ");
INSERT INTO paoNT_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Nu gi oo sopedakwatoo ka ooonnekoo e nemadabuekwuna. Nu yise ka Paul tubenga, ‘U haa'a sakwa nu-no Jerusalem-witoo mea? Onona sakwa sumuna nu besa u nemadabue.’ ");
INSERT INTO paoNT_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Pana gi! Soo Paul meeoo e netamma, ‘Soo tamme Roman-kooba katudu sakwa mitu puusoo nemadabue.’ Nu yise yowsoo oo tsitugu. Nu saa'a ka tamme-kooba katudu-matoo oo tayadooa.” ");
INSERT INTO paoNT_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","O'no yise soo Agrippa ka Festus mee netamma, “Nu ka Paul unnekwunu besa nakasoonamme.” “Unudea, mooo'a ta ka Paul nakadooa,” mee soo Festus oo nanekwegea. ");
INSERT INTO paoNT_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Oogow mooo'a Agrippa tu hama'a Bernice-no yise Festus besa nanamadabuena nanana-kwi sogo meadape ka pabatsekoo tunehane nobe-kwitoo. Mu tukwutumadu moohedu ka mu numu moohedu-no punno'o oe. Soo Festus mu tukwutumadu ka Paul bi tunngu. ");
INSERT INTO paoNT_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Soo Festus ka Agrippa, yise no'oko mu numu oe konnodu noke meeoo netamma, “Yow esoo Paul mee naneadu. Ekow nana no'yoona mu Jew yaatuoo yise Jerusalem-witu netumoo'oo. Umu ooosapa waagena meeoo e netammana, ‘Maasoo nana sakwa nabatsa.’ ");
INSERT INTO paoNT_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Pana nu yise gi hemma pukwi oo nabatsa-wa'nekoo nemamayu. Soo Pau puusoo meeoo unakwe, ‘Soo Roman numu-kooba katudu sakwa puusoo nu-witu nemadabue.’ Nu yise oo-matoo oo tayakwu. ");
INSERT INTO paoNT_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","27","Nu sakwa ka numu-kooba katudu-matoo tubo ka suda a tumadagupu. Nu gi ka Paul taya-wa'ne tabu'a ka gisoo suda oo tumadugupu nemamayuna. Nu gi hemma ma'yu e tubokwuna Nu yise e pua'a Agrippa, umu yaa manepunnedu no'oko yaa u-kobenatoo ka Paul bi tuungu. Tamme ka Paul-no yadooase oo unnena naksase, sumuna nu hemma saa'a bodooa.” ");
INSERT INTO paoNT_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Soo Agrippa mee ka Paul netamma, “Yise sakwa u nakwitu ne tuukwe. How manena mu Jew numu u netumoo'oo?” Soo Paul mayutsungadooase, ka umu moohedu Agrippa mee naneadu yadoo'ekooha. ");
INSERT INTO paoNT_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“Nu nuusoo nakwitu mu tuukwekwu. Nu oo sopedakwatoo nu besa soonamme ka mumme e mane-witu tuukwena. ");
INSERT INTO paoNT_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","U oo sopedakwatoo no'oko ka mu Jew tumayohona how puu umu tumadugu. U sakwa e nakapunnese gi yabesoo e nanekwegeapana. ");
INSERT INTO paoNT_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","Mooasoo no'yoona e sopedakwatoo nu umu-naga'yoona nanapu. Umu Jew numu ka Jerusalem mee naneadu-kwi nonobe-ga'yoo. ");
INSERT INTO paoNT_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Umu Jew numu oo sopedakwatoo ewasoo tommo petugapu, nu ka numme nanesootuhidu-matu Pharisee mee nananeadu-no. Umuoo ka mu Jew tumayohopu unu mayoho. Umuoo u mesoo tuukwe ka pumme u tubenga. ");
INSERT INTO paoNT_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","8","Nu yise meno'o nanehane ka o naka'oedyukuna soo Te Naa ka te namamooatupu meeoo tuukwepu, ‘Soo Te Naa mu numu tuipu mayodakwu,’ mee'e. No'yoona numme Jew numu ooosapa nanesootuhidu, Te Naa-matoo meakwu ka oo naka'oedyukuna. Esoo numu tunaka'oedyukuna gi unu manepunne, mu saa'a oo sopedakwadoodooa. ");
INSERT INTO paoNT_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","Nu o'nosoo uga ka umu Te Pabe'e naka'oedyukudu tooe how tooe nanasuda mu yugwe. ");
INSERT INTO paoNT_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Nu mu Jerusalem-witu tunaka'oedyukudu tumoo'ookese, ‘Ewow Te Pabe'e naka'oedyukudu wutumeta,’ ka mu Jew tunehanedu meeoo nuka netamma. Ka mu tunaka'oedyukudu mu tunehanedu-kobena negonnokuse, nu punno'o meeoo mu netamma, ‘Mu sakwa nagoepebu'a.’ ");
INSERT INTO paoNT_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Ewasoo nu mana umu nananesootuhi mamanepunnetoo meayina, ka umuoo wohonena. Umu sakwa suda Te Naa-witu waha mee nu soonammena. Nu tuwazaoo nanakwinga'akwi nummeyakwe mu wakwawa'a no'aata-too mu nanesootuhidu nekwohonena. ");
INSERT INTO paoNT_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","Mu Jew numu tunehanedu ka Damascus mee naneadu-witoo e tayana, umu Te Pabe'e naka'oedyukudu ootuoo wutumeta mee e netammana. ");
INSERT INTO paoNT_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Ka tabeno tu manekese numme ooosapa meadabena, pa'anakwana numme-koobatu besa kootabuapetu ka taba ooonakwa besa kootabuapunne, yaa ne na'oonnakwi ka e pupua'amu-no ne meadape. ");
INSERT INTO paoNT_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Numme no'yoona ka teepu-kooba pookwahoo. Haga sapaga ka Jew numuyadooa-wikoo e yadooewunu, ‘Saul, Saul u ooosapa suda e masoonammennumme, uusoo punno'o suda soonamme gi e naka'oedyukuna.’ ");
INSERT INTO paoNT_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Nu yise ka e tuapa nakana mee netamma, ‘Haga u?’ Soo e tuapa nakana meeoo unne, ‘Nu yow Jesus Mu Pabe'e. U ooosapa suda e masoonammennumme. ");
INSERT INTO paoNT_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","17","Meno'o yise yotse. Nu ume yadoo'e, ume nu netutzea, u sakwa mana nu-witu wahannumme. Esoo e tuusoobedyana u tuukwedooasoo. No'obatusoo numu nu-witu tuukwe, ");
INSERT INTO paoNT_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","nanakumma-baatusoo numu-matoo nu u tayakwu. Nu u tummatzina u magwetzoidooa ka umesoo nanumu ume tumoo'ookese, yise ka no'oko nanakumma'akoosoo numu ume tumoo'oo tuwow.’ ");
INSERT INTO paoNT_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","Nu ooosapa tumayohokena ka Te Pabe'e meeoo nuka netamma eka e tuusoobedya-wi. ");
INSERT INTO paoNT_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Mooe'ugasoo mu numu Damascus-witu nu Te Pabe'e-witu tuukwe, saa'a tuwow Jerusalem-wi yise ka teepu Judea mee naneadu-wi'yoona. Nu no'oko nanakumma'akoosoo numu nanesootuhikuna mu tunedyooemena. ‘Gi ka sutakoo podo meapana,’ mee nu mu netamma. ‘Ka gi besa mu tumaduguna nematzagase. Ka besa'hoo podo meadabe. Ka oo manena tamme oo tzapoonnekwu ka Te Naa podo meana.’ ");
INSERT INTO paoNT_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Nu ka e tuusoobedyana mayohona mu Jew numu nu-ma tzakadu, ka tu nanesootuhi nobe-kobena'yoona e tooe batsa. ");
INSERT INTO paoNT_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Ka mu Moses noko ka Te Naa yadooawabe numu mu tuukwepusoo nu mu numu tuukwe ka Te Pabe'e petukwu-witu numu oo magwetzoikwu-witu tuwow. ");
INSERT INTO paoNT_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Umu meeoo, ‘Oosoo Te Pabe'e nabatsase, numu-kobenasoo namayodakwu tu ya'e-wi'yoona,’ mee'e. Oosoo saa'a namekoosoo mu Jew noko mu wakwawa'a tuukwedooa ka Te Naa besa po-witu.” ");
INSERT INTO paoNT_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Ka Paul togesoo yadoo'a ka tu mane-kwitu oo wahadyakwe, soo Festus pabatse mee'e unne, “Paul, u gi sukwe soonamme. U ka nagutza wuna'me natunedyooedabena, oosoo u soonammena suda yugwe petu.” ");
INSERT INTO paoNT_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Soo Paul mee unne, “Nu gi hownne'yoo, nu oetu besa soohanena tubetse togekoo yadoo'a. ");
INSERT INTO paoNT_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Soo Agrippa no'oko Te Pabe'e-witu sopedakwadoo, ooonne'yoona nu etzaga oo-no yadooa. Soo Agrippa tookwa mooasoo oo sopedakwadoo ka e netamma-kwitu. Esoo e netammana gi tookapu-kwikoo a namanena.” ");
INSERT INTO paoNT_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Soo Paul yise ka Agrippa meeoo netamma, “U ka umu o'nosoo Te Naa tuukwewabe tubotuguna naka'oedyukute, nu u sopedakwadoo.” ");
INSERT INTO paoNT_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Tooesoo ka Paul yadooawunu, soo Agrippa mee oo netamma, “U gi nuka tunaka'oedyuku mayugwe-wa'ne'yoo.” ");
INSERT INTO paoNT_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Soo Paul ka Agrippa meeoo netamma, “Nu-kwa'nesoo dea'a yaahoo meno'o mu nanesootuhikukwu mu no'yoona e nakapunnedu, yaa tabeno Te Pabe'e tubetsedu-gakwu, pana gi mu nu-kwaVne mu natzakuna petzape.” ");
INSERT INTO paoNT_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Mu Agrippa, nanodukwa, ka Felix-no konnohoose, ");
INSERT INTO paoNT_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","ka nobe-kwi'yoona mea'a. Nanano apekase mee unakwe, “Esoo nana Paul tookwa gi suda manakwe. Gi pumme batsa-wa'ne manepunnena gi tuwazoo pumme wutumatugu-wa'ne'yoo.” ");
INSERT INTO paoNT_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Soo agrippa meeoo ka Felix netamma, “Esoo nana Paul mesoo natzama'w, pana ka te Roman numu-kooba katudu-matoo nemea. Ta sakwa yise oo-matoo a taya.” ");
INSERT INTO paoNT_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Soo Festus sake-wi ne tayakwu ka teepu Italy mee naneadu-kwitoo mee unakwe. Mu Roman numu moohedu ka tukwutumadu moohedu-no Julius mee naneadu ka Paul noko kukumma'akoosoo oo-no nakwutumadu mu eya'e tuungu. ");
INSERT INTO paoNT_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Numme ka sake-wi ");
INSERT INTO paoNT_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","oogow mooo'a ka Sidon-wi petuga. Soo Julius ka Paul besa matuguna, oosoo tu pupua'amu-baa nobe'nge. Umu Paul pupua'amu tooe hemma tooe oo sookwina oo ge'a. ");
INSERT INTO paoNT_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Sidon-wi'yoona numme mease, soo hukwapa atatamesoo hukwadyakwe gi ka ne mea-tamme. Numme yise oo kwutoohanakwu-kwi me'a ka pagadudu Cyprus mee naneadu-kumi. ");
INSERT INTO paoNT_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Numme ooosapa natsemangena ka mu Cilicia noko Pamphylia mee nananeadu teepu-kumi meadabena ka Myra noko Lycia mee nananeadu teepu-kooba petuga. ");
INSERT INTO paoNT_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Soo Julius sumuoo sake mayuhoo Alexandria-wi'yoona kemmana Italy-witoo meadu. Ooweoo numme no'yoona kuaka. ");
INSERT INTO paoNT_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Obeda numme natsemange ewa tabe meaka, numme unusoo manena ka Cnidus mee naneadu-kumi me'a. Soo hukwapa ne wumatzooejuna, numme gi hownnekoo oosapa meadabe-wa'ne. Numme yise oo kwutoohanakwu-kwi natsemange, ka pagadudu Crete mee naneadu ka Cape Salmone-kumi numme me'a. ");
INSERT INTO paoNT_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Numme ooosapa pakumi me'a unusoo manena numme Fair Havens mee naneadu sake pukwi dyooi-kwi petu ka Lasea mee naneadu-kumaba. ");
INSERT INTO paoNT_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Ewa tabe meaka, numme ka onona. Tommoba mooasoo tzage'e manekena. Soo Paul mu naana ka sake-koobatu mee tuya tuukwe'e. ");
INSERT INTO paoNT_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","“E pupua'amu, nu oo sopedakwatoo tamme ka ooosapa meadabena te nobeana tamme watzekukwu, te sake nokosoo, o'no sumuna tamme punno'o batuikwu.” ");
INSERT INTO paoNT_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","12","Umu sake-witu pabe'e hise soo sake hee-ga-no oo sopedakwatoo ka eak sake pukwi yooina gi besa'yoo gi pukwi tommo-wa'ne. Umu ka Phoenix mee naneadu-kwitoo sakwa tamme ninapa natzemangeka mee unakwe. Otuoo soo sake pukwi yooina ka Crete-kumaba tamme mesoo wutoohapunne pana taba egea-nakwatu gi, o yise tomokwu mee unnena. Soo Julius umuoo naka'oedyuku, pana ka Paul yaasoo sakwa tamme tommo mee oo unnena gi naka'oedyukute. ");
INSERT INTO paoNT_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Ka taba meana-nakwana soo hukwapa obeda hukwadyakwe. Mu sake mahanedu meeoo sokwama, “Numme mesoo mangega'a ka Phoenix-witoo,” mee'e. Ka sake baa-wi tsipunnedu tsatsebooase yise numme ka Crete-kumi me'a. ");
INSERT INTO paoNT_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Pudusoo unu kwenaha petuoo, unu hukwawunu. ");
INSERT INTO paoNT_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Soo hukwapa ka sake patodyakwekuooka unu ka pagadudu-makoo. Numme yise oo tsasoopedya, gi nasoomanese ka hukwapa ka sake patodyakwehookuse. ");
INSERT INTO paoNT_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","17","Numme ka tuutse pagadudu Clauda mee naneadu taba meana-kwi me'a. Otuoo sagwane wutoohapunne. Onona numme ka tuutsekoo sake ka pabatsekoo sake-kooba wutsabeku. Mu sake mahanedu tugapu-ma ka sake wunotake. O'no soo sake gi nuukote ka oo namadabuena. Umu suina meadape numme sakwa sumuna ka baapooe. Syrtis mee naneadu-kwitoo, mee sokwamana. Umu yise ka tu tumadabuena tzakwekuse, soo hukwapa ka sake wupoohedape. ");
INSERT INTO paoNT_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Ooosapa unu hukwadape, ookow mooo'a yise umu ka sake-wi tu nobea-matu tzapebu'a. ");
INSERT INTO paoNT_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Ookow mooo'a numme nummesoo mima ka sake-witu hemma tuwazoo tzapebu'a. ");
INSERT INTO paoNT_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Soo paba hukwapa huu tabe meaka ooosapa hukwadabena. Unu koomeapunnena soo taba ka mu paatoozooba-no gi napoonne-wa'ne'yoo. Numme sumuna no'yoona batu'ikwu mee numme sokwama. ");
INSERT INTO paoNT_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Numme gisoo tukana wuna'me maneka. Soo Paul yise numu-kobena wunuse mee unakwe, “E pupua'amu, o'nosoo sakwa mu e nakabetsea. Tamme sakwa uga Crete-wizoo. Tamme yise ka natzemangekase 'yoo suda hee manakwe. ");
INSERT INTO paoNT_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Pana gi suipana, gi haga tamme-matu ya'ekwu. Soo sake suu'mu kadoo'oo nama'ekwu. ");
INSERT INTO paoNT_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Nu oo sopedakwatoo ka togano soo toha kasa-ga'yoo Te Naa tummatzidu nuga nagena nu-baa petu. ");
INSERT INTO paoNT_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","Soo toha kasa-ga'yoo meeoo e netamma, ‘Gi suipana, Paul. Soo Te Naa ka Roman-kooba katudu ume nehane tuungu. U nanesootuhidu gi haga ka sake-koobatu batuidooa.’ ");
INSERT INTO paoNT_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Yise e pupua'amu, gi suipana. Nu oo naka'oedyukute ka Te Naa, nu tuwazoo oo sopedakwatoo soo hee oo unne-kwa'nesoo manekwu. ");
INSERT INTO paoNT_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Soo hukwapa mana tooe hano tooe pagadudu kumana te hane petugadooa.” ");
INSERT INTO paoNT_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","waha nasatese soo hukwapa tooesoo ka tubetse baa Mediterranean mee naneadu-koobakwi ne wumatzaka. Togabeno tu manekuse, ka mu sake-witu mahanedu meeoo sokwama, “Meno'o ka sumuna numme teepu tzagee.” ");
INSERT INTO paoNT_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Umu yise ka baa managahoose gi tubetse tookapu. Gi haa'no tu manepunnese umu tuwazoo oo managahoosoo. O'no yise tuwazoo gi unu tookapu. ");
INSERT INTO paoNT_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Umu suina watsukwuoo sake tzadyooikudu ka baa-witoo tzapebu'a. O'no soo sake gi tupe-matoo tape. Umu nanesootuha'e, “Soo sake sakwa gi nuukodepana gisoo tu tabu'a,” mee unnena. ");
INSERT INTO paoNT_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Mu sake-witu mahanedu too'e namamea'a ka sake-wi'yoona. Ka tuutsekoo sake umu baa-witoo tzakweku sukwe sapa, ka sake-kobenatu ooka tzadyooikudu tzasawekuna. ");
INSERT INTO paoNT_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Soo Paul ka Julius noko mu tukwutumadu mee netamma, “Ka mu dake-witu mahanedu mease, tamme gi hownnekoo namagwetzoi-wa'ne'yoo.” ");
INSERT INTO paoNT_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Mu tukwutumadu yise ka tugapoo ka tuutsekoo sake tsipunnedu tsekea'ahoose oo tzama'wuhoo. Mu sake-witu mahanedu yise gi hownnekoo namamea-wa'ne'yoo. ");
INSERT INTO paoNT_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Ka tu tabuagena soo Paul no'oko ka mu numu mee netamma, “Waha nasateka mu gi hemma tukana sukwe nanetzagwiyina. ");
INSERT INTO paoNT_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Mu sakwa Te Naa naka'oedyukute oo unnepu meeoo. ‘Gi haga tameme-matu nama'ehookwu, gi tuwazoo ya'ekwu.’ Mu sakwa meno'o tuka esoo puma mu gwetzoikwuna.” ");
INSERT INTO paoNT_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Soo Paul ka tunemamakwuse, ka tukaba gwuuhoose yise ka Te Naa-matoo nanesootuha'e, ka tukaba-matu tsaka'owse oo tukakooha. ");
INSERT INTO paoNT_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","No'yoona mu numu ka Paul tuka oo poonnese umu punno'o ka tukapu-matu tukakooha. ");
INSERT INTO paoNT_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","38","Ka no'oko mu tukamakwuse, umu ka tukapu nabenina tzapebu'a, ka baa-witu. O'no soo sake unusoo yayagwahookwu. Tubetse ewa'yoo (276) numu ka sake-koobatu. ");
INSERT INTO paoNT_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Ka tubuakese, mu sake-witu mahanedu gi ka teepu posopedakwatoo. Ka bakohapunnedu poonnena paba haanokwi otuba teepu-ga'yoo. Oto sakwa numme eka sake wunoo'yoo'ehoo petuga mee'e sokwama. ");
INSERT INTO paoNT_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Mu tugapoo yise tsebokow ka sake tsipunnedu-makoo yise tu tutsakahenookuna o-tamme tzameakute. Ka sake-kobenatu ka pabatsekoo wanapu namadabuena toogoopa tsadyota, o'no soo hukwapa ka sake-kobena-tamme wumatzaka ka a bakohapunne-kwitoo. ");
INSERT INTO paoNT_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Pana soo sake ka otuba-ma tzange petuga. Soo sake-kobenatu ka otuba-wi tzangehoo soo baa yise ka how wu'ma'nawena ka sake ooonnakwatu wuugodehoo. ");
INSERT INTO paoNT_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Mu tukwutumadu ka mu nakwutumadu neko'e. “O'no gi umu-matu namameakwu,” mee unnena. ");
INSERT INTO paoNT_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Soo Julius ka Paul soomagwetzoina mu netahoo ka meeoo mu unakwe. No'oko mu nanana besa babokwadu meeoo netamma, “Ka baa-witoo natakwatese ka teepu tamme babokwahooga.” ");
INSERT INTO paoNT_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Ka saa'a mu susumudu gi babokwadu ka sake-matu wobe poki-ma wawiyooana ka teepu-tamme patodyakwe. Yoo numme no'yoona manena ka teepu-kooba mani petuga. ");
INSERT INTO paoNT_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Ka teepu-kooba ne petugase, yow esoo pagadudu Malta mee naneadu mee numme natuukwe'e. ");
INSERT INTO paoNT_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Mu numu otuoo besa ne matuku. Unu utzutzupunnena, powmakooha. Umu yise ne pedakuhoo pumma ne yooekwuna. ");
INSERT INTO paoNT_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Soo Paul koona hanena, ka goso-kooba oo tuoonakwuse, togogwa yise ka koona-toha'yoona tsebooeke ka goso nayooekwumana. Ka Paul mi-makoo oo toguehoose, ooo-ma tubetse kuwayooakwunihoo. ");
INSERT INTO paoNT_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Mu numu oo poonne ka togogwa ka Paul mi-ma oo kukwiyooapunne, mee yise nananetamma, “Tooe esoo nana ka tubetse baa-wikoo namagwetzoise sapa, soo suda oo tumadugupu, oo-matoosoo kodyuna a batsowkwu, soo togogwa oo togu'ehoo.” ");
INSERT INTO paoNT_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Soo Paul yise ka togogwa ka goso-witoo tzawunihoo, gi how soo togogwa oo yugwe. ");
INSERT INTO paoNT_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Mu numu oo tooe wutooepunne, hannano'o ka saa'a pawahoodooa, tooetoo yabesoo ya'ehoodooa mee'e sokwamapunne. Wuna'me manikea soo Paul gi how manena, umu yise atasoo sokwamahoose mee nananetamma, “Esoo Paul tookwa pummatoo te nanesootuhina.” ");
INSERT INTO paoNT_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Soo numu moohedu Publius mee naneadu tubewa-ga'yoo, gi kwinga ka onona. Soo Publius besa ne matuguna numme oo-baa pahe tooiyakwe. ");
INSERT INTO paoNT_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Oo naa tu'oeyaena hape, unu oo tookoo udutuna, wuna'me manekapu nuummayina. Soo Paul oo-matoo mease oo-ma matuguse oo nanesootuhikuse, oosoo yise besa mani. ");
INSERT INTO paoNT_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Ka oo nakase no'yoona mu tuoegoedu numu ka pagadudu-koobatu ka Paul-baa petuyina besa namayugweyakwe. ");
INSERT INTO paoNT_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","12","Umu tuoegoedu besa maneyidu ewatse'e tooe hemma tooe na he'me. Yise pahe muha manese numme Italy-witoo natzemangeka. O'no ewasoo umu hemma ne hanekute ne sookwina. Sumu'yoo sake Alexandria-wi'yoona kemmana Nawa'ne'yoosoo mee naneadu punno'o ookowsoo pagadudu-kumaba tomopu-ga'yoo. Oo-kooba numme manega ka Rome-tamme. ");
INSERT INTO paoNT_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Numme ka Puteoli mee naneadu-wi petuse, oto numme ka sake-wi'yoona sawe petuga. ");
INSERT INTO paoNT_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Mu tunaka'oedyukudu numme oe tapoega. Umu yise, “Sumu nasateba-witoo sakwa mu numme-baa,” me'e ne netamma. Ononasoo numme ka Rome-witoo mea. ");
INSERT INTO paoNT_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Mu tunaka-'oedyukudu Rome-witu numme-witu nakadu mu Appius Forum noko three Taverns mee maneneadu-wi ka saa'a nawegeadooa. Soo Paul ka mu poonnese Te Naa-matoo nanesootuhikooha, besa soonammena. ");
INSERT INTO paoNT_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Ka Rome-wi ne petugase soo Paul puusoo nanobe-gakute, sumuoo tukwutumadu pumme eyaedu-no, ono soo Paul gi namamea'a mee'e umu oo sooyugwena. ");
INSERT INTO paoNT_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Pahe tabe meaka numme o petuse soo Paul mu Jew numu Rome-witu umu numu moohedu tu tunehane-witoo pa'e. Ka mu sumuse meeoo mu netamma, “E nanumu, nu gi hekwi te nanumu netumoo'oo-wa'ne'yoo. Nu te tumayohona ka te nanamooatupu pumakoo mu tumayohona gi takopadu. Mu Jew numu Jerusalem-witu meeoo e netammana, nu nakwutumana mu yise mu Roman numu-tamme e tzama'wu. ");
INSERT INTO paoNT_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Mu Roman numu e nemadabuese, e netzama'wu, umu ka oo nakase, ka gi suda e manakwe, nu gi pumme batsa-wa'ne. ");
INSERT INTO paoNT_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Mu Jew numu gi oo nakabetzape ka mu Roman numu nuka netzama'wu. Nu yise meeoo unakwe, ‘Nu ka mu Roman numu-kooba katudu nuka nemadabue tuungu,’ tooe nu gi suda na'unnedu e nanumu-tamme unnekwuse. ");
INSERT INTO paoNT_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Nu ka mu soopoonnena mu-no soodyadooana, ka Te Pabe'e-witu mu tuukwekwuse, ka Te Pabe'e-koobatoo nu nakwutumase.” ");
INSERT INTO paoNT_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Mu Jew numu moohedu meeoo ka Paul netamma, “Gi numme u-witu nabodu tubope kwu'u ka teepu Judea mee naneadu-witu. Gi mu te nanumu suda na'unnedu u-witu ne tuukwedu. ");
INSERT INTO paoNT_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Pana numme ume tusooyugwena soonakapunne ume nanesootuhi pupua'amu mu numu tooe hanotu tooe ooosapa mu netumoo'ooyakwe.” ");
INSERT INTO paoNT_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Umu Jew numu yise ka Paul-no tunemadabue, “O'no tabeno saa'a tamme nanatabooegadooa.” Ewa'yoo numu ka Paul-baa petudyakwe. Tabewano soo Paul ka Te Naa besa po-witu mu numu tuukwe'e. Soo Paul ka Te Naa unnena mu nemadabuekuna, ka Te Pabe'e-witu sakwa umu nakatoge'yookuse, oo-tamme mane. ");
INSERT INTO paoNT_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Susumudu umu-matu ka Te Pabe'e naka'oedyukute, susumudu punno'o gi. ");
INSERT INTO paoNT_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","29","Soo Paul yise ka mu gi tunakaoedyukudu meeoo netamma, “O'nosoo soo Te Naa Besa Pooha mu-kwitu mee'e unnepu, Mu tooe ka Te Naa besa pooha poonne oo unnepu nakapana, gi ka Te Naa naka'oedyukute. Mu gi ka Te Naa nakaheesoobedya. Mu sakwa ka Te Naa besa unnepu naka'oedyuku Te Naa-tamme mane, gi oemota, o'no soo Te Naa mu sootuhina, mu magwetzoikwu.’” Soo Paul yise meeoosoo mu netamma, “Mooasoo nu ka Te Naa besa unnepu mu tuukwepu. Yaa manakwana nu mu wakwawa'a gi Jew numu Te Pabe'e-witu tuukwekwu. Umu-matu oo naka'oedyukukwu.” Ka Paul meeoo unnese mu Jew numu puusoo nananepetukuna petukwahooka. ");
INSERT INTO paoNT_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","31","Waha tomoka soo Paul ka tu nobe-wi'yoona, oe tumanakana. No'obatusoo numu pumme nobengeketu soo Paul ka Te Pabe'e-witu tuukweyakwe. Mu Roman tukwutumadu punno'o gi ha'yoo ka Paul netamma. Yaatoo besakoo nanemamakwuhoobetu.");
INSERT INTO paoNT_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Ka Te Naa besa unnepu-witu, nu, Paul, mu-matoo tubo'o, ka Rome mee naneadu-wi nonobe-gakoo. Nu ka Te Pabe'e Jesus nakabetseadu, oosoo e netutzease, nu yise yaahoo yadooawabe mane yise mana mu numu e tuukwe tuungu ka besa tu unnepu-witu. ");
INSERT INTO paoNT_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","Ka besa Te Naa unnepu umu o'nosoo Te Naa yadooawabe mooasoo oo bo tugupu. ");
INSERT INTO paoNT_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","O'nosoo umu Te Naa yadooawabe oo waha ka Jesus, Te Naa Besaa Tooa'a-witu, meno'o yise soo na'unnedu togesapa oo-toogoo manepetu. Soo Te Pabe'e numu-wa'nesoo nadooa'adoo tabuapu. Oosoo ka David-manakwana kemmapu. ");
INSERT INTO paoNT_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","Pana oosoo tuwazoo ka Te Naa-wa'ne'yoo. Soo Te Naa Besa Tooa'a ooka te tzapoonnekute, ka tu Besa Pooha-ma oo ya'e-wikoo oo mayodase. ");
INSERT INTO paoNT_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Soo Te Pabe'e e sootuhi ka tu yadooawabe e mayugwese, ka manatooe e tayana, ka tu besa unnepu no'oko numu e tuukwe tuunguna. O'no umu oo naka'oedyukuna saa'a oo nakabetseadooa. ");
INSERT INTO paoNT_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","7","Mu punno'o ka Rome-witu ooosoo. Soo Te Naa mu tunetutzea ka Te Pabe'e doodooamu manekese, oosoo ka besa mu soobedyana. Nu meeoo mu nanesootuhiku soo Te Naa ka Te Pabe'e Jesus-no ooosapa mu sootuhinokwu yise mu magwetzoikwuse. ");
INSERT INTO paoNT_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Tooe hano tooe e nummenummetoo mu numu e tuukwe ka Te Pabe'e tu naka'oedyukuna. Nu ka Te Pabe'e nuka nakasootuha'e, Te Naa-matoo mu nanesootuhikute. ");
INSERT INTO paoNT_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","10","Nu ooosapa ka Te Naa-matoo nanesootuha'e, mu-toogoo besa'hoo natuunguna. Nu ka Te Naa tubetse nakabetseana, ka ena tooe hano tooe mu numu tuukwena, ka besa na'unnedu ka oo Besaa Tooa'a-witu. Oosoo oo sopedakwadoo nu ooosapa mu nanesootuhikuyakwe, nu sakwa mu-baatoo sumudooe mea, ka Te Naa meeoo nuka netamma. ");
INSERT INTO paoNT_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","Nu sakwa mu-baatoo mease, mu nanesootuhikuna. O'no mu unusoo besa kaaheno tusooyugwena, mu unusoo tunaka'oedyuku manepetugadooa. ");
INSERT INTO paoNT_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","Mu ka tu'oedyukuna oetoo e nehanese, tamme nanahoesoo oetu nemadabuese. O'no saa'a nu mu-baa besa petuga nuummadooa. ");
INSERT INTO paoNT_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Pana nu gisoo me'a, nu ka gi hownnekoo meana. Nu yise besa mu nobene soonamme, nu sakwa ka mu gisoo tunaka'oedyukudu tummatzi. Nu ka mooasoo tooe hano tooe gi Jew numu nanesootuhibu tunedyooese. ");
INSERT INTO paoNT_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Soo Te Naa meeoo e netamma, “No'oko tooe hownnekoo tooe numu-matoo mease, mu tuukwe.” ");
INSERT INTO paoNT_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Mu-matoo tuwazoo Rome-witoo. Nu unu oo soogwa'e mu-baa e petugakwuna, yise ka nanesootuhibu mu tunedyooekwuse, ");
INSERT INTO paoNT_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","nu gi e nanenasookwina soogwa'e mu numu mesoo tuukwena ka Te Naa unnepu. Soo tooe haga tooe ka Te Naa besa unnepu naka'oedyukudu, soo Te Naa pooha mu magwetzoikwu, mu Jew numu nokosoo mu gi Jew numu tuwazoo. ");
INSERT INTO paoNT_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Soo Te Naa besa unnepu te tuukwe'e, soo Te Naa meeoo, “Tamme besa'yoo numu, ka ooosapa tunaka'oedyukuna.” A nabotugu-kwa'nesoo, “Soo numu ka kaaheno Te Naa besa podo meana, puusoo nanemagwetzoikwu, oosoo ka tunaka'oedyukuna.” ");
INSERT INTO paoNT_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Tamme oo sopedakwadoo soo suda numu tumatuguna numu-matoosoo kodyukwu, ka ooosapa suda tumatuguna mu numu ka Te Naa togesapa unnena ne watzetugu. ");
INSERT INTO paoNT_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","22","Tooe mu numu gi Te Naa poonnepana, mu numu sumuna oo sopedakwadookwu ka Te Naa ka teepu matabuepu. Oosoo puusoo mu tzapoonnekute ka no'oko hemma besa tu matabuena, yise ka unu tu pooha-gana tuwazoo. Pana umu gi oo nesookwuga'ena, yise gi oo-matoo nanesootuhi tuwazoo. Umu sakwa oe naneyugwe, ka gi sootunaka'oedyukuna. Umu meeoo nanasooyugwe, “Numme tubetse unu sokwama.” Pana gi! Umu tookwa gi hemma sopedakwadoopana meeoo nasooyugwe. ");
INSERT INTO paoNT_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","Umu gi ka Te Naa-matoo nanesootuha'e, oosoo Te Naa yise no'okosoo pooha-ga'yoo gi ya'edu. Pana umu tooe hemma-too tooe nanesootuha'e gi pooha-gakoo: Numu-wa'nekoo, tooetoo kwe'na'a, etza'a, yise togogwa-matoo gi puusoo namagwetzoi-wa'nekoo, sukwe ya'eyakwedu. ");
INSERT INTO paoNT_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","26","Umuoo gi ka Te Naa-wi tu tunaka'oedyukuna petzape, Te Naa besa'yoona gi naka'oedyukute pumme nesookwugi-wa'nekoo, tu na'esayina suu'mu umu nakabetseadu. Umu gi ka pumme manumudoopu-matoo nanesootuha'e, yise pumme nesookwugi-wa'nekoo. Umu ka hemma namadabue-matoo nanesootuha'e. Ooonne'yoona soo Te Naa mu tsasoopedya, umu yise ka sutakoo podo meadape. Umuoo suda tusooyugwena, suda ka pummesoo tookoo yugwe. Umu no'obatusoo suda tu manena petzape. Mu momoko'ne ka gi toge-wikoo, ka tu puna mogo'ne mesoo ma'emukwana. ");
INSERT INTO paoNT_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","Mu nanana punno'o gi ka mu momoko'ne soogwina puusoo nana-ma tumanaka. Umuoo suda tubetse manakwe soo suda mu tumatuguna umu-matoosoo kodyukwu. ");
INSERT INTO paoNT_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Soo Te Naa gi how mu yugwe suda mee tusooyugwe sapa umu ka gi Te Naa soo'oedyukuna. ");
INSERT INTO paoNT_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","31","Umu yise tooe ha'oo tooe manakwe nanasuda: unu moomoogoobuna, nanidyapuna, tu pupua'amu nasoodyagena, nanahana, numu mesoo batsana, nana'esagoena, nanatumooagana, ewa suda nanatuukwena, Te Naa gi petzabena, suda nanadyadooena, nananesagwa'ena, nananesootzemana, besa nanasooyugwena, tu nanaanapu'amu gi nakabetseana, gi numu tutuha soobedyana, gi kaaheno tumatuguna, yise tooe ha'oonnekoo tooe suda namanedu oedyukuna. ");
INSERT INTO paoNT_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","Umu oo sopedakwadoopana ka Te Naa meeoo unnepu, “Soo numu 'yoo manedu sakwa ya'e.” Umu yise suda mesoo manakwe ka tu pupua'amu suta-witoo pumme moohe. ");
INSERT INTO paoNT_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","Numme Jew numu sakwa umu gi Jew numu gi nesootzemapana, numme punno'o ka ooosoo manena. Numme punno'o nummesoo oe naneyukwe ka tooe how tooe manena. ");
INSERT INTO paoNT_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","Tamme oo sopedakwadoo soo Te Naa kaaheno no'obatusoo umu numu suda manedu kadoo mayugwekwu. ");
INSERT INTO paoNT_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","Tamme sakwa gi meeoo sokwamapana, “Soo Te Naa nuka gi kadoo'oo mayugwe-wa'ne'yoo tooe suda e manakwe sapa. Nu umu ata'yoosoo.” ");
INSERT INTO paoNT_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","5","Soo Te Naa tubetse besa'yoo, gi etzaga sutadu. Oosoo ka oo te matuguna, o'no tamme sakwa ka suda te tumatuguna ma'wukase, yise ka oo besa podo meadabekwu. Pana tamme ka meeoo sokwamana, “Nu gi ka suda e tumatuguna ma'wu-wa'ne'yoo yise ka oo besa podo mea-wa'ne'yoo.” O'no yise tamme tammesoo ka sutakoo mabetseadu-kwa'ne tabu'a, tamme-matoosoo kodyukwu ka kaaheno nanasuu'mu numu manena umu-matoosoo kodyuse. ");
INSERT INTO paoNT_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","No'oko mu numu tumatugupu umu-matoosoo kodyukwu ha'oo ka mu besow tooetoo mu sutakoo. ");
INSERT INTO paoNT_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","11","Mu numu ooosapa besa manekwu umu ka besow podokoo soomeana, ka Te Naa besa pumme sootuha'e ooosapa nummenummena ka Te Naa-baa nobe-gakwu. Umu numu ka gi toge-witu nakabetseana puu suu'mu mee nasooyugwena nanasutatoo meadabekwu, yise kadoo namayugwekwu. Soo Te Naa no'okosoo hemma nana-kwa'nesoo matugukwu: mu Jew numu, mu gi Jew numu tuwazoo. ");
INSERT INTO paoNT_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","16","Soo numme Jew tumayohopu ne tuukwe'e, ka ne manekwuna. Numme ka kaaheno oo mayohona, numme besa'yoo mee'e soo Te Naa unnekwu. Tamme tammesoo oo naka, pana gi oo nakabetseana, tamme kadoo'oo namayugwekwu. Umu gi Jew numu gi ka te tumayohopu nakadu pana umu puusoo oo sopedakwatoo ka how besa manena, tooetoo suda manese. Umu ka Te Naa nakabetseana oo tzapoonnena oo sopedakwadoo ka Te Naa pumme mane tuunguna. Umu kadoo'oo namayugwekwu ka gi oo nakabetseana. 'Yoo tu namanekwuse, soo Te Naa ka Te Pabe'e numu watze tusooyugwena oo nemadabue tuunguna. Meeoo nu mana ka mu numu tuukwe. ");
INSERT INTO paoNT_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","Numme Jew sumuna unu ka te tumayoho-ma nasoonatza'e. ");
INSERT INTO paoNT_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","Te Naa-ma nana'unakwe ka mee unnena, numme nummesoo oo sopedakwatoo ka besa ka Te Naa numme mane tuunguna, ka ne tumayohopu natunedyooese. ");
INSERT INTO paoNT_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","20","Numme mu gi ooka sopedakwatoodu mesoo tunedyooe doodooake tuwazoo, soo ne tumayohopu ka Te Naa besa podokoo ne tzapoonnekute. ");
INSERT INTO paoNT_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","Aha, numme Jew ka besow po sopedakwatoo, pana numme gi oo nakabetse'a. Numme mu numu meeoo netamma, “Mu sakwa gi tuduhapana,” yise numme sumuna nummesoo tuduha. ");
INSERT INTO paoNT_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","Numme mu numu meeoo mu netamma, “Mu sakwa ka nananodukwana kukumma'amasoo emukwapana.” Numme, nummesoo, sumuna 'yoo suda manakwe. Numme meeoo, “Numme gi hemma namadabue-matoo nanesootuhi-wa'ne'yoo,” pana numme sumuna kumma'akoosoo numu natusooa tuduha. ");
INSERT INTO paoNT_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","24","Numme meeoo nana'unakwe, numme o sopedakwatoo no'oko ka Te Naa tumayohopu, numme oo nage tuunguna. Pana numme ka mu gi Jew numu suda ka Te Naa-witu mu netamma tuungu, ka numme gi oo unnena nakabetseana. ");
INSERT INTO paoNT_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","Numme meeoo, “Numme ka Te Naa tubetse dooamu, numme ka Jew numuna.” Numme ka Jew-na besa'yoo, numme ka Te Naa unnena nakabetseana. Pana numme ka gi oo unnena nakabetseana, numme gi Te Naa dooamu. ");
INSERT INTO paoNT_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","27","Mu gi Jew numu ka Te Naa unnena nakabetseadu Te Naa doodooamu numme Jew ooonakwasoo, besa'yoo umu ka Te Naa unnena nakabetseana. ");
INSERT INTO paoNT_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","Numme yise Te Naa doodooamu ka oo nakabetseana, ka sukwe Jew numuna. ");
INSERT INTO paoNT_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","Numme ka tunakabetseana soo Te Naa te soonammena sopedakwadoona te sootuhikwu. Oosoo gi hownne'yoo tooe mu numu te nesootzemapana. ");
INSERT INTO paoNT_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","Tamme sumuna meeoo unnekwu, “Oosoo gi hownne'yoo tooe Jew numupana oosoo gi Te Naa doodooamu te mayugwe-wa'ne'yoo.” ");
INSERT INTO paoNT_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","Pana gi! Oosoo besa'yoo ka Jew numuna, soo Te Naa ka tu unnepu numme Jew numu tuukwese. ");
INSERT INTO paoNT_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","Numme Jew numu gi oo nakabetsea, pana soo Te Naa ooosapa oo nakabetse'a, ka pummesoo unnepu. ");
INSERT INTO paoNT_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","Numu tooe esagoepana, soo Te Naa unnepu ooosapa togesapa. Meeoo nabotugu oo na'unne-kwa'nesoo, “Soo Te Naa ooosapa kaaheno'yoo ka tu yadooa-wi. Gi haga oo tuaga'ne, ‘Oosoo esaya'e,’ mee unnena.” ");
INSERT INTO paoNT_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","8","Sumuna numu-matu meeoo unnekwu, “Tamme ka suda manena, oosoo oo tzapoonne ka Te Naa besa'yoona. Soo Te Naa gi kaaheno'yoona oosoo ka mu numu tu ma'emukwana umu-matoosoo makodyukukwu,” mee mu sukwe numu unakwe. Pana gi! Te Naa ooosapa kaaheno'yoona; kaahenosoo mu numu nemadabuekwu. Susumudu numu-matu sumuna meeoo unnekwu, “Nu ka suda manena, nu ka Te Naa besa nemadabue, tamme sakwa yise suta'yoo, o'no soo Te Naa besa nanemadabuekwu,” mee umu. Susumudu numu esaya'e, nu meeoo unakwe, mee unnena. Mu numu suda unnedu sakwa oe naneyugwe. Pana soo suda mu tumatuguna umu-matoosoo nakwukodyukukwu. ");
INSERT INTO paoNT_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","Numme, Jew numu, nasootuha'e mu gi Jew numu-wa'nesoo. No'yoona tamme nanakwa'ne'yoosoo. Nu mooasoo meeoo mu netammapu ");
INSERT INTO paoNT_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","no'yoona tamme ka sutakoo po-toogoo mea'a, a nabotugu-kwa'nesoo, “Gi haga besa manakwe, gi haga kaaheno ka Te Naa besa podo me'a. Gi tamme-matu ka Te Naa sopedakwatoo. ");
INSERT INTO paoNT_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","Umu gi ka Te Naa tu nakabetseana petzape. ");
INSERT INTO paoNT_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","Umu ka Te Naa besa po ma'wukase, gi he-toogoo besa'yoo. ");
INSERT INTO paoNT_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","14","Umu esagoena, numu nesootzemana nanasuda unnena. ");
INSERT INTO paoNT_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","17","Umuoo mu numu nuummaba wumakuna suda mu yugwena, numu batsayakwe. Umu unu nidyapu. ");
INSERT INTO paoNT_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","Umuoo gi ka Te Naa tu nakabetseana soohanedu.” ");
INSERT INTO paoNT_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","Numme yise oo sopedakwatoo soo Te Naa meeoo te netammana, numme Jew numu oe nane'yakwe, ka mu gi Jew numu-wa'nesoo. Numme punno'o ka gi Te Naa nakabetseana. ");
INSERT INTO paoNT_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","Soo ne tumayoho tabuana oo tzapoonne tamme no'yoona tuma'emukwa, gi tamme oo tzapoonne ka te besa'yoona. ");
INSERT INTO paoNT_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","Numme Jew ooosapa meeoo sokwamayakwe, soo Te Naa besa'yoo mee te netammakwu, ka te tumayohope te nakabetsea ka umu te nanamooatupu tamme-too tunemadabuepu. Pana umu Te Naa yadooawabe o'nosoo te tuukwe'e, ka saa'a soo Te Naa besa te matabuekwu. Meno'o yise oe manepetu. ");
INSERT INTO paoNT_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","Soo Te Naa te tuukwe'e mu besa'yoo mee te netammakwu, tamme ka Te Pabe'e-wi tunaka'oedyukuna. Oosoo no'oko nanakwa'nesoo te matugukwu, mu Jew numu yise ka mu gi Jew numu tuwazoo. ");
INSERT INTO paoNT_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","Tamme ka no'yoona tuma'emukwakupuna, gi ka Te Naa tamme oo netamma-kwa'nesoo manena. ");
INSERT INTO paoNT_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","Soo Te Naa ekow nasootuhipu te sootuhipu, tamme yise besa'yoo soo Te Pabe'e ka tamme-koobatoo nabatsase besa te mayugwekwu, o'no yise, “Mu besa'yoo,” mee te netammakwu. ");
INSERT INTO paoNT_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","26","Soo Te Naa tusoohanena te tuma'emukwana soomu'wase, soo Te Pabe'e yise tamme-koobatoo nabatsa. Esoo oo tzapoonne oosoo tookwa kaaheno'yoo. Ka o'nosoo soo suta'yoo gi numu-matoosoo kodyudu, oosoo ka besa'yoona oo soohanena, soo Te Pabe'e tamme-koobatoo nabatsakwu, oosoo yise no'oko mu tunaka'oedyukudu Te Pabe'e-wi, “Besa'yoo,” mee mu netammakwu. ");
INSERT INTO paoNT_vpl V