﻿USE sofia;
DROP TABLE IF EXISTS sofia.pan_vpl;
CREATE TABLE pan_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES pan_vpl WRITE;
INSERT INTO pan_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","ਆਦ ਵਿੱਚ ਪਰਮੇਸ਼ੁਰ ਨੇ ਅਕਾਸ਼ ਅਤੇ ਧਰਤੀ ਨੂੰ ਸਿਰਜਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","ਧਰਤੀ ਬੇਡੌਲ ਅਤੇ ਵਿਰਾਨ ਸੀ ਅਤੇ ਡੁੰਘਿਆਈ ਉੱਤੇ ਹਨ੍ਹੇਰਾ ਸੀ, ਪਰਮੇਸ਼ੁਰ ਦਾ ਆਤਮਾ ਪਾਣੀਆਂ ਦੇ ਉੱਤੇ ਮੰਡਲਾਉਂਦਾ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","ਪਰਮੇਸ਼ੁਰ ਨੇ ਆਖਿਆ, ਚਾਨਣ ਹੋਵੇ, ਤਦ ਚਾਨਣ ਹੋ ਗਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","ਪਰਮੇਸ਼ੁਰ ਨੇ ਚਾਨਣ ਨੂੰ ਵੇਖਿਆ ਕਿ ਚੰਗਾ ਹੈ, ਪਰਮੇਸ਼ੁਰ ਨੇ ਚਾਨਣ ਨੂੰ ਹਨ੍ਹੇਰੇ ਤੋਂ ਵੱਖਰਾ ਕੀਤਾ। ");
INSERT INTO pan_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","ਪਰਮੇਸ਼ੁਰ ਨੇ ਚਾਨਣ ਨੂੰ ਦਿਨ ਆਖਿਆ ਅਤੇ ਹਨ੍ਹੇਰੇ ਨੂੰ ਰਾਤ ਆਖਿਆ। ਇਸ ਤਰ੍ਹਾਂ ਸ਼ਾਮ ਤੇ ਸਵੇਰ ਹੋਈ, ਇਹ ਪਹਿਲਾ ਦਿਨ ਹੋਇਆ। ");
INSERT INTO pan_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","ਫੇਰ ਪਰਮੇਸ਼ੁਰ ਨੇ ਆਖਿਆ, ਪਾਣੀਆਂ ਦੇ ਵਿਚਕਾਰ ਅੰਬਰ ਹੋਵੇ ਅਤੇ ਉਹ ਪਾਣੀਆਂ ਨੂੰ ਪਾਣੀਆਂ ਤੋਂ ਵੱਖਰਾ ਕਰੇ। ");
INSERT INTO pan_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","ਸੋ ਪਰਮੇਸ਼ੁਰ ਨੇ ਅੰਬਰ ਨੂੰ ਬਣਾਇਆ ਅਤੇ ਅੰਬਰ ਦੇ ਹੇਠਲੇ ਪਾਣੀਆਂ ਨੂੰ ਅੰਬਰ ਦੇ ਉੱਪਰਲੇ ਪਾਣੀਆਂ ਤੋਂ ਵੱਖਰਾ ਕੀਤਾ ਅਤੇ ਅਜਿਹਾ ਹੀ ਹੋ ਗਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","ਤਦ ਪਰਮੇਸ਼ੁਰ ਨੇ ਅੰਬਰ ਨੂੰ ਅਕਾਸ਼ ਆਖਿਆ, ਇਸ ਤਰ੍ਹਾਂ ਸ਼ਾਮ ਤੇ ਸਵੇਰ ਹੋਈ ਅਤੇ ਇਹ ਦੂਜਾ ਦਿਨ ਹੋਇਆ। ");
INSERT INTO pan_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","ਫੇਰ ਪਰਮੇਸ਼ੁਰ ਨੇ ਆਖਿਆ ਕਿ ਅਕਾਸ਼ ਦੇ ਹੇਠਲੇ ਪਾਣੀ ਇੱਕ ਥਾਂ ਇਕੱਠੇ ਹੋ ਜਾਣ ਤਾਂ ਜੋ ਸੁੱਕੀ ਜ਼ਮੀਨ ਦਿਸੇ ਅਤੇ ਅਜਿਹਾ ਹੀ ਹੋ ਗਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","ਪਰਮੇਸ਼ੁਰ ਨੇ ਸੁੱਕੀ ਜ਼ਮੀਨ ਨੂੰ ਧਰਤੀ ਆਖਿਆ, ਪਾਣੀਆਂ ਦੇ ਇਕੱਠ ਨੂੰ ਸਮੁੰਦਰ ਆਖਿਆ ਅਤੇ ਪਰਮੇਸ਼ੁਰ ਨੇ ਵੇਖਿਆ ਕਿ ਇਹ ਚੰਗਾ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","ਫੇਰ ਪਰਮੇਸ਼ੁਰ ਨੇ ਆਖਿਆ ਕਿ ਧਰਤੀ ਘਾਹ, ਬੀਜ ਵਾਲਾ ਸਾਗ ਪੱਤ ਅਤੇ ਫਲਦਾਰ ਰੁੱਖ ਉਗਾਵੇ ਜਿਹੜੇ ਆਪੋ-ਆਪਣੀ ਕਿਸਮ ਦੇ ਅਨੁਸਾਰ ਬੀਜ ਵਾਲਾ ਫਲ ਧਰਤੀ ਉੱਤੇ ਪੈਦਾ ਕਰਨ ਅਤੇ ਅਜਿਹਾ ਹੀ ਹੋ ਗਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","ਸੋ ਧਰਤੀ ਨੇ ਘਾਹ ਤੇ ਬੀਜ ਵਾਲਾ ਸਾਗ ਪੱਤ ਉਹ ਦੀ ਕਿਸਮ ਦੇ ਅਨੁਸਾਰ ਤੇ ਫਲਦਾਰ ਰੁੱਖ ਜਿਨ੍ਹਾਂ ਵਿੱਚ ਆਪੋ-ਆਪਣੀ ਕਿਸਮ ਦੇ ਅਨੁਸਾਰ ਬੀਜ ਹੈ, ਉਗਾਇਆ ਅਤੇ ਪਰਮੇਸ਼ੁਰ ਨੇ ਵੇਖਿਆ ਕਿ ਇਹ ਚੰਗਾ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","ਇਸ ਤਰ੍ਹਾਂ ਸ਼ਾਮ ਤੇ ਸਵੇਰ ਹੋਈ, ਇਹ ਤੀਜਾ ਦਿਨ ਹੋਇਆ। ");
INSERT INTO pan_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","ਪਰਮੇਸ਼ੁਰ ਨੇ ਆਖਿਆ ਕਿ ਅਕਾਸ਼ ਦੇ ਅੰਬਰ ਵਿੱਚ ਤੇਜ਼ ਰੌਸ਼ਨੀਆਂ ਚਮਕਣ ਜਿਹੜੀਆਂ ਦਿਨ ਨੂੰ ਰਾਤ ਤੋਂ ਅਲੱਗ ਕਰਨ, ਇਹ ਸਮਿਆਂ, ਨਿਸ਼ਾਨੀਆਂ, ਰੁੱਤਾਂ, ਵਰਿਆਂ ਅਤੇ ਦਿਨਾਂ ਨੂੰ ਠਹਿਰਾਉਣ। ");
INSERT INTO pan_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","ਓਹ ਅਕਾਸ਼ ਦੇ ਅੰਬਰ ਵਿੱਚ ਤੇਜ਼ ਰੌਸ਼ਨੀਆਂ ਹੋਣ ਜੋ ਧਰਤੀ ਉੱਤੇ ਚਮਕਣ ਅਤੇ ਅਜਿਹਾ ਹੀ ਹੋ ਗਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","ਪਰਮੇਸ਼ੁਰ ਨੇ ਦੋ ਵੱਡੀਆਂ ਰੌਸ਼ਨੀਆਂ ਬਣਾਈਆਂ - ਵੱਡੀ ਰੋਸ਼ਨੀ ਜਿਹੜੀ ਦਿਨ ਉੱਤੇ ਰਾਜ ਕਰੇ ਅਤੇ ਛੋਟੀ ਰੋਸ਼ਨੀ ਜਿਹੜੀ ਰਾਤ ਉੱਤੇ ਰਾਜ ਕਰੇ, ਉਸ ਨੇ ਤਾਰੇ ਵੀ ਬਣਾਏ। ");
INSERT INTO pan_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","ਪਰਮੇਸ਼ੁਰ ਨੇ ਉਨ੍ਹਾਂ ਨੂੰ ਅਕਾਸ਼ ਦੇ ਅੰਬਰ ਵਿੱਚ ਰੱਖਿਆ ਜੋ ਧਰਤੀ ਉੱਤੇ ਚਾਨਣ ਕਰਨ ");
INSERT INTO pan_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","ਅਤੇ ਦਿਨ, ਰਾਤ ਉੱਤੇ ਰਾਜ ਕਰਨ ਅਤੇ ਚਾਨਣ ਨੂੰ ਹਨ੍ਹੇਰੇ ਤੋਂ ਅਲੱਗ ਕਰਨ। ਪਰਮੇਸ਼ੁਰ ਨੇ ਵੇਖਿਆ ਕਿ ਇਹ ਚੰਗਾ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","ਇਸ ਤਰ੍ਹਾਂ ਸ਼ਾਮ ਅਤੇ ਸਵੇਰ ਹੋਈ, ਇਹ ਚੌਥਾ ਦਿਨ ਹੋਇਆ। ");
INSERT INTO pan_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","ਫੇਰ ਪਰਮੇਸ਼ੁਰ ਨੇ ਆਖਿਆ ਕਿ ਪਾਣੀ ਜੀਉਂਦੇ ਪ੍ਰਾਣੀਆਂ ਨਾਲ ਭਰ ਜਾਣ ਅਤੇ ਪੰਛੀ ਧਰਤੀ ਤੋਂ ਉਤਾਹਾਂ ਅਕਾਸ਼ ਦੇ ਅੰਬਰ ਵਿੱਚ ਉੱਡਣ। ");
INSERT INTO pan_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","ਪਰਮੇਸ਼ੁਰ ਨੇ ਵੱਡੇ-ਵੱਡੇ ਜਲ ਜੰਤੂਆਂ ਨੂੰ ਅਤੇ ਸਾਰੇ ਚੱਲਣ ਵਾਲੇ ਜੀਉਂਦੇ ਪ੍ਰਾਣੀਆਂ ਨੂੰ ਉਤਪਤ ਕੀਤਾ, ਉਨ੍ਹਾਂ ਦੀ ਪ੍ਰਜਾਤੀ ਅਨੁਸਾਰ ਪਾਣੀ ਭਰ ਗਏ, ਨਾਲੇ ਸਾਰੇ ਪੰਛੀਆਂ ਨੂੰ ਵੀ ਉਨ੍ਹਾਂ ਦੀ ਪ੍ਰਜਾਤੀ ਅਨੁਸਾਰ ਉਤਪਤ ਕੀਤਾ, ਪਰਮੇਸ਼ੁਰ ਨੇ ਵੇਖਿਆ ਕਿ ਇਹ ਚੰਗਾ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","ਪਰਮੇਸ਼ੁਰ ਨੇ ਇਹ ਆਖ ਕੇ ਉਨ੍ਹਾਂ ਨੂੰ ਅਸੀਸ ਦਿੱਤੀ, ਫਲੋ ਅਤੇ ਵਧੋ ਤੇ ਸਮੁੰਦਰਾਂ ਦੇ ਪਾਣੀਆਂ ਨੂੰ ਭਰ ਦਿਓ ਅਤੇ ਪੰਛੀ ਧਰਤੀ ਉੱਤੇ ਵਧਣ। ");
INSERT INTO pan_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","ਇਸ ਤਰ੍ਹਾਂ ਸ਼ਾਮ ਅਤੇ ਸਵੇਰ ਹੋਈ, ਇਹ ਪੰਜਵਾਂ ਦਿਨ ਹੋਇਆ। ");
INSERT INTO pan_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","ਫੇਰ ਪਰਮੇਸ਼ੁਰ ਨੇ ਆਖਿਆ ਕਿ ਧਰਤੀ ਜੀਉਂਦੇ ਪ੍ਰਾਣੀਆਂ ਨੂੰ ਉਨ੍ਹਾਂ ਦੀ ਪ੍ਰਜਾਤੀ ਦੇ ਅਨੁਸਾਰ ਤੇ ਪਸ਼ੂਆਂ ਨੂੰ, ਘਿੱਸਰਨ ਵਾਲਿਆਂ ਨੂੰ, ਧਰਤੀ ਦੇ ਜਾਨਵਰਾਂ ਨੂੰ ਉਨ੍ਹਾਂ ਦੀ ਪ੍ਰਜਾਤੀ ਦੇ ਅਨੁਸਾਰ ਉਪਜਾਵੇ ਅਤੇ ਅਜਿਹਾ ਹੀ ਹੋ ਗਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","ਪਰਮੇਸ਼ੁਰ ਨੇ ਧਰਤੀ ਦੇ ਜਾਨਵਰਾਂ ਨੂੰ ਉਨ੍ਹਾਂ ਦੀ ਪ੍ਰਜਾਤੀ ਦੇ ਅਨੁਸਾਰ ਅਤੇ ਜਾਨਵਰਾਂ ਨੂੰ ਉਨ੍ਹਾਂ ਦੀ ਪ੍ਰਜਾਤੀ ਦੇ ਅਨੁਸਾਰ, ਜ਼ਮੀਨ ਦੇ ਸਾਰੇ ਘਿੱਸਰਨ ਵਾਲਿਆਂ ਨੂੰ ਉਨ੍ਹਾਂ ਦੀ ਪ੍ਰਜਾਤੀ ਦੇ ਅਨੁਸਾਰ ਬਣਾਇਆ ਅਤੇ ਪਰਮੇਸ਼ੁਰ ਨੇ ਵੇਖਿਆ ਕਿ ਇਹ ਚੰਗਾ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","ਪਰਮੇਸ਼ੁਰ ਨੇ ਆਖਿਆ ਕਿ ਅਸੀਂ ਮਨੁੱਖ ਨੂੰ ਆਪਣੇ ਸਰੂਪ ਵਿੱਚ ਅਤੇ ਆਪਣੇ ਵਰਗਾ ਬਣਾਈਏ ਅਤੇ ਓਹ ਸਮੁੰਦਰ ਦੀਆਂ ਮੱਛੀਆਂ ਉੱਤੇ, ਅਕਾਸ਼ ਦੇ ਪੰਛੀਆਂ, ਪਸ਼ੂਆਂ, ਸਗੋਂ ਸਾਰੀ ਧਰਤੀ ਉੱਤੇ ਅਤੇ ਧਰਤੀ ਉੱਤੇ ਸਾਰੇ ਘਿੱਸਰਨ ਵਾਲਿਆਂ ਜੀਵ-ਜੰਤੂਆਂ ਉੱਤੇ ਰਾਜ ਕਰਨ। ");
INSERT INTO pan_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","ਇਸ ਤਰ੍ਹਾਂ ਪਰਮੇਸ਼ੁਰ ਨੇ ਮਨੁੱਖ ਦੀ ਰਚਨਾ ਆਪਣੇ ਸਰੂਪ ਵਿੱਚ ਕੀਤੀ। ਪਰਮੇਸ਼ੁਰ ਦੇ ਸਰੂਪ ਵਿੱਚ ਉਸ ਨੂੰ ਰਚਿਆ। ਉਸ ਨੇ ਨਰ ਨਾਰੀ ਦੀ ਸ੍ਰਿਸ਼ਟੀ ਕੀਤੀ। ");
INSERT INTO pan_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","ਪਰਮੇਸ਼ੁਰ ਨੇ ਉਨ੍ਹਾਂ ਨੂੰ ਅਸੀਸ ਦਿੱਤੀ ਅਤੇ ਪਰਮੇਸ਼ੁਰ ਨੇ ਉਨ੍ਹਾਂ ਨੂੰ ਆਖਿਆ ਕਿ ਫਲੋ ਅਤੇ ਵਧੋ, ਧਰਤੀ ਨੂੰ ਭਰ ਦਿਓ ਅਤੇ ਉਹ ਨੂੰ ਆਪਣੇ ਵੱਸ ਵਿੱਚ ਕਰੋ ਅਤੇ ਸਮੁੰਦਰ ਦੀਆਂ ਮੱਛੀਆਂ, ਅਕਾਸ਼ ਦੇ ਪੰਛੀਆਂ ਅਤੇ ਧਰਤੀ ਉੱਤੇ ਘਿਸਰਨ ਵਾਲੇ ਸਾਰੇ ਜੀਵ-ਜੰਤੂਆਂ ਉੱਤੇ ਰਾਜ ਕਰੋ। ");
INSERT INTO pan_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","ਪਰਮੇਸ਼ੁਰ ਨੇ ਆਖਿਆ, ਵੇਖੋ ਮੈਂ ਤੁਹਾਨੂੰ ਹਰੇਕ ਬੀਜ ਵਾਲਾ ਸਾਗ ਪੱਤ ਜਿਹੜਾ ਸਾਰੀ ਧਰਤੀ ਦੇ ਉੱਤੇ ਹੈ, ਹਰੇਕ ਰੁੱਖ ਜਿਹ ਦੇ ਵਿੱਚ ਉਸ ਦਾ ਬੀਜ ਵਾਲਾ ਫਲ ਹੈ, ਦੇ ਦਿੱਤਾ ਹੈ। ਇਹ ਤੁਹਾਡੇ ਲਈ ਭੋਜਨ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","ਮੈਂ ਧਰਤੀ ਦੇ ਹਰੇਕ ਜਾਨਵਰ, ਅਕਾਸ਼ ਦੇ ਹਰੇਕ ਪੰਛੀ, ਧਰਤੀ ਉੱਤੇ ਹਰ ਘਿੱਸਰਨ ਵਾਲੇ ਨੂੰ ਜਿਹਨਾਂ ਦੇ ਵਿੱਚ ਜੀਵਨ ਦਾ ਸਾਹ ਹੈ, ਉਹਨਾਂ ਦੇ ਖਾਣ ਲਈ ਹਰ ਕਿਸਮ ਦਾ ਸਾਗ ਪੱਤ ਦੇ ਦਿੱਤਾ ਅਤੇ ਅਜਿਹਾ ਹੀ ਹੋ ਗਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","ਤਦ ਪਰਮੇਸ਼ੁਰ ਨੇ ਸਾਰੀ ਸਿਰਜਣਾ ਨੂੰ ਜਿਸ ਨੂੰ ਉਸ ਨੇ ਬਣਾਇਆ ਸੀ, ਵੇਖਿਆ ਅਤੇ ਵੇਖੋ ਉਹ ਬਹੁਤ ਹੀ ਚੰਗਾ ਸੀ। ਇਸ ਤਰ੍ਹਾਂ ਸ਼ਾਮ ਅਤੇ ਸਵੇਰ ਹੋਈ, ਇਹ ਛੇਵਾਂ ਦਿਨ ਹੋਇਆ। ");
INSERT INTO pan_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","ਇਸ ਤਰ੍ਹਾਂ ਅਕਾਸ਼ ਅਤੇ ਧਰਤੀ ਅਤੇ ਉਨ੍ਹਾਂ ਦੀ ਸਾਰੀ ਵੱਸੋਂ ਦੀ ਸਿਰਜਣਾ ਪੂਰੀ ਕੀਤੀ ਗਈ। ");
INSERT INTO pan_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","ਪਰਮੇਸ਼ੁਰ ਨੇ ਸੱਤਵੇਂ ਦਿਨ ਆਪਣੇ ਕਾਰਜ ਨੂੰ ਸੰਪੂਰਨ ਕੀਤਾ, ਅਤੇ ਉਸਨੇ ਸੱਤਵੇਂ ਦਿਨ ਆਪਣਿਆਂ ਸਾਰਿਆਂ ਕਾਰਜਾਂ ਤੋਂ ਅਰਾਮ ਕੀਤਾ। ");
INSERT INTO pan_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","ਪਰਮੇਸ਼ੁਰ ਨੇ ਸੱਤਵੇਂ ਦਿਨ ਨੂੰ ਅਸੀਸ ਦਿੱਤੀ ਅਤੇ ਉਸ ਦਿਨ ਨੂੰ ਪਵਿੱਤਰ ਠਹਿਰਾਇਆ ਕਿਉਂ ਜੋ ਉਸੇ ਦਿਨ ਆਪਣੇ ਕਾਰਜ ਤੋਂ ਜਿਹੜਾ ਉਸ ਨੇ ਰਚਿਆ ਸੀ, ਆਰਾਮ ਕੀਤਾ। ");
INSERT INTO pan_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","ਇਹ ਅਕਾਸ਼ ਅਤੇ ਧਰਤੀ ਦੀ ਸਿਰਜਣਾ ਦਾ ਵਰਣਨ ਹੈ ਜਦ ਓਹ ਉਤਪੰਨ ਹੋਏ ਅਰਥਾਤ ਜਿਸ ਦਿਨ ਯਹੋਵਾਹ ਪਰਮੇਸ਼ੁਰ ਨੇ ਅਕਾਸ਼ ਅਤੇ ਧਰਤੀ ਨੂੰ ਬਣਾਇਆ। ");
INSERT INTO pan_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","ਮੈਦਾਨ ਦਾ ਕੋਈ ਪੌਦਾ ਅਜੇ ਧਰਤੀ ਉੱਤੇ ਨਹੀਂ ਸੀ, ਨਾ ਹੀ ਖੇਤ ਦਾ ਕੋਈ ਸਾਗ ਪੱਤ ਅਜੇ ਉਪਜਿਆ ਸੀ ਕਿਉਂ ਜੋ ਯਹੋਵਾਹ ਪਰਮੇਸ਼ੁਰ ਨੇ ਧਰਤੀ ਉੱਤੇ ਮੀਂਹ ਨਹੀਂ ਵਰ੍ਹਾਇਆ ਸੀ ਅਤੇ ਨਾ ਹੀ ਜ਼ਮੀਨ ਨੂੰ ਵਾਹੁਣ ਲਈ ਕੋਈ ਮਨੁੱਖ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","ਪਰ ਧੁੰਦ ਧਰਤੀ ਤੋਂ ਉੱਠ ਕੇ ਸਾਰੀ ਜ਼ਮੀਨ ਨੂੰ ਸਿੰਜਦੀ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","ਯਹੋਵਾਹ ਪਰਮੇਸ਼ੁਰ ਨੇ ਮਨੁੱਖ ਨੂੰ ਜ਼ਮੀਨ ਦੀ ਮਿੱਟੀ ਤੋਂ ਰਚਿਆ ਅਤੇ ਉਸ ਦੀਆਂ ਨਾਸਾਂ ਵਿੱਚ ਜੀਵਨ ਦਾ ਸਾਹ ਫੂਕਿਆ, ਇਸ ਤਰ੍ਹਾਂ ਮਨੁੱਖ ਜੀਉਂਦਾ ਪ੍ਰਾਣੀ ਬਣ ਗਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","ਤਦ ਯਹੋਵਾਹ ਪਰਮੇਸ਼ੁਰ ਨੇ ਪੂਰਬ ਵੱਲ ਇੱਕ ਬਾਗ਼ ਅਦਨ ਵਿੱਚ ਲਾਇਆ ਅਤੇ ਉੱਥੇ ਉਸ ਨੇ ਉਸ ਮਨੁੱਖ ਨੂੰ, ਜਿਸ ਨੂੰ ਉਸ ਨੇ ਰਚਿਆ ਸੀ, ਰੱਖ ਦਿੱਤਾ। ");
INSERT INTO pan_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","ਯਹੋਵਾਹ ਪਰਮੇਸ਼ੁਰ ਨੇ ਜ਼ਮੀਨ ਦਾ ਹਰੇਕ ਰੁੱਖ ਜਿਹੜਾ ਵੇਖਣ ਵਿੱਚ ਮਨਭਾਉਣਾ ਸੀ ਅਤੇ ਜਿਸ ਦਾ ਫਲ ਖਾਣ ਵਿੱਚ ਚੰਗਾ ਸੀ, ਉਗਾਏ ਅਤੇ, ਬਾਗ਼ ਦੇ ਵਿਚਕਾਰ ਜੀਵਨ ਦਾ ਰੁੱਖ ਤੇ ਭਲੇ ਬੁਰੇ ਦੇ ਗਿਆਨ ਦਾ ਰੁੱਖ ਵੀ ਉਗਾਇਆ। ");
INSERT INTO pan_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","ਇੱਕ ਨਦੀ ਉਸ ਬਾਗ਼ ਨੂੰ ਸਿੰਜਣ ਲਈ ਅਦਨ ਤੋਂ ਨਿੱਕਲੀ ਅਤੇ ਉੱਥੋਂ ਚਾਰ ਹਿੱਸਿਆਂ ਵਿੱਚ ਵੰਡੀ ਗਈ। ");
INSERT INTO pan_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","ਇੱਕ ਦਾ ਨਾਮ ਪੀਸੋਨ ਹੈ, ਜਿਹੜੀ ਸਾਰੇ ਹਵੀਲਾਹ ਦੇਸ਼ ਨੂੰ ਘੇਰਦੀ ਹੈ ਜਿੱਥੇ ਸੋਨਾ ਹੈ ");
INSERT INTO pan_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","ਅਤੇ ਉਸ ਦੇਸ਼ ਦਾ ਸੋਨਾ ਚੰਗਾ ਹੈ, ਉੱਥੇ ਮੋਤੀ ਤੇ ਸੁਲੇਮਾਨੀ ਪੱਥਰ ਵੀ ਪਾਏ ਜਾਂਦੇ ਹਨ। ");
INSERT INTO pan_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","ਦੂਜੀ ਨਦੀ ਦਾ ਨਾਮ ਗੀਹੋਨ ਹੈ, ਜਿਹੜੀ ਸਾਰੇ ਕੂਸ਼ ਦੇਸ਼ ਨੂੰ ਘੇਰਦੀ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","ਤੀਜੀ ਨਦੀ ਦਾ ਨਾਮ ਹਿੱਦਕਲ ਹੈ, ਜਿਹੜੀ ਅੱਸ਼ੂਰ ਦੇ ਪੂਰਬ ਵੱਲ ਵਗਦੀ ਹੈ ਅਤੇ ਚੌਥੀ ਨਦੀ ਦਾ ਨਾਮ ਫ਼ਰਾਤ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","ਯਹੋਵਾਹ ਪਰਮੇਸ਼ੁਰ ਨੇ ਉਸ ਮਨੁੱਖ ਨੂੰ ਲੈ ਕੇ ਅਦਨ ਦੇ ਬਾਗ਼ ਵਿੱਚ ਰੱਖਿਆ ਤਾਂ ਜੋ ਉਹ ਉਸ ਦੀ ਵਾਹੀ ਤੇ ਰਾਖੀ ਕਰੇ। ");
INSERT INTO pan_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","ਤਦ ਯਹੋਵਾਹ ਪਰਮੇਸ਼ੁਰ ਨੇ ਮਨੁੱਖ ਨੂੰ ਆਗਿਆ ਦਿੱਤੀ ਕਿ ਤੂੰ ਬਾਗ਼ ਦੇ ਹਰੇਕ ਰੁੱਖ ਦਾ ਫਲ ਬੇਝਿਜਕ ਖਾ ਸਕਦਾ ਹੈ, ");
INSERT INTO pan_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","ਪਰ ਭਲੇ ਬੁਰੇ ਦੇ ਗਿਆਨ ਦੇ ਰੁੱਖ ਦਾ ਫਲ ਤੂੰ ਨਾ ਖਾਈਂ ਕਿਉਂ ਜੋ ਜਿਸ ਦਿਨ ਤੂੰ ਉਸ ਤੋਂ ਖਾਵੇਂਗਾ, ਤੂੰ ਜ਼ਰੂਰ ਮਰੇਂਗਾ। ");
INSERT INTO pan_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","ਫੇਰ ਯਹੋਵਾਹ ਪਰਮੇਸ਼ੁਰ ਨੇ ਆਖਿਆ ਇਹ ਚੰਗਾ ਨਹੀਂ ਕਿ ਮਨੁੱਖ ਇਕੱਲਾ ਰਹੇ ਇਸ ਲਈ ਮੈਂ ਉਸ ਦੇ ਲਈ ਉਸ ਦੇ ਵਰਗੀ ਇੱਕ ਸਹਾਇਕ ਬਣਾਵਾਂਗਾ। ");
INSERT INTO pan_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","ਯਹੋਵਾਹ ਪਰਮੇਸ਼ੁਰ ਨੇ ਮਿੱਟੀ ਤੋਂ ਜੰਗਲ ਦੇ ਹਰ ਇੱਕ ਜਾਨਵਰ ਨੂੰ ਅਤੇ ਅਕਾਸ਼ ਦੇ ਹਰ ਇੱਕ ਪੰਛੀ ਨੂੰ ਰਚਿਆ ਅਤੇ ਆਦਮੀ ਕੋਲ ਲੈ ਆਇਆ ਤਾਂ ਜੋ ਉਹ ਵੇਖੇ ਜੋ ਉਹ ਕਿਵੇਂ ਉਨ੍ਹਾਂ ਨੂੰ ਸੱਦੇਗਾ ਅਤੇ ਜੋ ਕੁਝ ਆਦਮੀ ਨੇ ਉਸ ਜੀਉਂਦੇ ਪ੍ਰਾਣੀ ਨੂੰ ਸੱਦਿਆ, ਉਹੀ ਉਹ ਦਾ ਨਾਮ ਹੋ ਗਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","ਇਸ ਤਰ੍ਹਾਂ ਆਦਮ ਨੇ ਸਾਰੇ ਪਸ਼ੂਆਂ, ਅਕਾਸ਼ ਦੇ ਪੰਛੀਆਂ, ਅਤੇ ਜੰਗਲ ਦੇ ਸਾਰੇ ਜਾਨਵਰਾਂ ਦਾ ਨਾਮ ਰੱਖਿਆ, ਪਰ ਮਨੁੱਖ ਲਈ ਅਜੇ ਕੋਈ ਸਹਾਇਕਣ ਉਹ ਦੇ ਵਰਗੀ ਨਾ ਮਿਲੀ। ");
INSERT INTO pan_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","ਤਦ ਯਹੋਵਾਹ ਪਰਮੇਸ਼ੁਰ ਨੇ ਮਨੁੱਖ ਨੂੰ ਗੂਹੜੀ ਨੀਂਦ ਵਿੱਚ ਪਾ ਦਿੱਤਾ, ਸੋ ਉਹ ਸੌਂ ਗਿਆ ਅਤੇ ਪਰਮੇਸ਼ੁਰ ਨੇ ਉਹ ਦੀਆਂ ਪਸਲੀਆਂ ਵਿੱਚੋਂ ਇੱਕ ਪਸਲੀ ਕੱਢ ਲਈ ਅਤੇ ਉਹ ਦੀ ਥਾਂ ਮਾਸ ਭਰ ਦਿੱਤਾ। ");
INSERT INTO pan_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","ਯਹੋਵਾਹ ਪਰਮੇਸ਼ੁਰ ਨੇ ਉਸ ਪਸਲੀ ਤੋਂ ਜਿਹੜੀ ਉਸ ਨੇ ਮਨੁੱਖ ਵਿੱਚੋਂ ਕੱਢੀ ਸੀ, ਇੱਕ ਨਾਰੀ ਬਣਾਈ ਅਤੇ ਉਹ ਨੂੰ ਮਨੁੱਖ ਕੋਲ ਲੈ ਆਇਆ। ");
INSERT INTO pan_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","ਤਦ ਮਨੁੱਖ ਨੇ ਆਖਿਆ ਕਿ ਇਹ ਹੁਣ ਮੇਰੀਆਂ ਹੱਡੀਆਂ ਵਿੱਚੋਂ ਹੱਡੀ ਹੈ, ਮੇਰੇ ਮਾਸ ਵਿੱਚੋਂ ਮਾਸ ਹੈ ਇਸ ਕਾਰਨ ਇਹ ਨਾਰੀ ਅਖਵਾਏਗੀ ਕਿਉਂ ਜੋ ਇਹ ਨਰ ਵਿੱਚੋਂ ਕੱਢੀ ਗਈ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","ਇਸ ਲਈ ਆਦਮੀ ਆਪਣੇ ਮਾਤਾ-ਪਿਤਾ ਨੂੰ ਛੱਡ ਕੇ ਆਪਣੀ ਪਤਨੀ ਨਾਲ ਮਿਲਿਆ ਰਹੇਗਾ ਅਤੇ ਉਹ ਇੱਕ ਸਰੀਰ ਹੋਣਗੇ। ");
INSERT INTO pan_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","ਆਦਮੀ ਅਤੇ ਉਹ ਦੀ ਪਤਨੀ ਦੋਵੇਂ ਨੰਗੇ ਸਨ, ਪਰ ਉਹ ਸੰਗਦੇ ਨਹੀਂ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","ਸੱਪ ਸਭ ਜੰਗਲੀ ਜਾਨਵਰਾਂ ਨਾਲੋਂ, ਜਿਨ੍ਹਾਂ ਨੂੰ ਯਹੋਵਾਹ ਪਰਮੇਸ਼ੁਰ ਨੇ ਬਣਾਇਆ ਸੀ, ਚਲਾਕ ਸੀ ਅਤੇ ਉਸ ਨੇ ਇਸਤਰੀ ਨੂੰ ਆਖਿਆ, ਭਲਾ, ਪਰਮੇਸ਼ੁਰ ਨੇ ਸੱਚ-ਮੁੱਚ ਆਖਿਆ ਹੈ ਕਿ ਬਾਗ਼ ਦੇ ਕਿਸੇ ਰੁੱਖ ਦਾ ਫਲ ਤੁਸੀਂ ਨਾ ਖਾਓ? ");
INSERT INTO pan_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","ਇਸਤਰੀ ਨੇ ਸੱਪ ਨੂੰ ਆਖਿਆ, ਬਾਗ਼ ਦੇ ਸਾਰੇ ਰੁੱਖਾਂ ਦੇ ਫਲ ਤਾਂ ਅਸੀਂ ਖਾ ਸਕਦੇ ਹਾਂ ");
INSERT INTO pan_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","ਪਰ ਜਿਹੜਾ ਰੁੱਖ ਬਾਗ਼ ਦੇ ਵਿਚਕਾਰ ਹੈ ਉਸ ਦੇ ਫਲ ਨੂੰ ਪਰਮੇਸ਼ੁਰ ਨੇ ਆਖਿਆ, ਤੁਸੀਂ ਨਾ ਖਾਓ ਨਾ ਉਹ ਨੂੰ ਹੱਥ ਲਾਓ, ਅਜਿਹਾ ਨਾ ਹੋਵੇ ਕਿ ਤੁਸੀਂ ਮਰ ਜਾਓ। ");
INSERT INTO pan_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","ਪਰ ਸੱਪ ਨੇ ਇਸਤਰੀ ਨੂੰ ਆਖਿਆ ਕਿ ਤੁਸੀਂ ਕਦੀ ਨਹੀਂ ਮਰੋਗੇ। ");
INSERT INTO pan_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","ਸਗੋਂ ਪਰਮੇਸ਼ੁਰ ਜਾਣਦਾ ਹੈ ਕਿ ਜਿਸ ਦਿਨ ਤੁਸੀਂ ਉਸ ਫਲ ਨੂੰ ਖਾਓਗੇ ਤੁਹਾਡੀਆਂ ਅੱਖਾਂ ਖੁੱਲ੍ਹ ਜਾਣਗੀਆਂ ਅਤੇ ਤੁਸੀਂ ਪਰਮੇਸ਼ੁਰ ਦੀ ਤਰ੍ਹਾਂ ਭਲੇ ਬੁਰੇ ਦੀ ਸਮਝ ਵਾਲੇ ਹੋ ਜਾਓਗੇ। ");
INSERT INTO pan_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","ਜਦ ਇਸਤਰੀ ਨੇ ਵੇਖਿਆ ਕਿ ਉਸ ਰੁੱਖ ਦਾ ਫਲ ਖਾਣ ਲਈ ਚੰਗਾ ਹੈ ਅਤੇ ਅੱਖੀਆਂ ਨੂੰ ਭਾਉਂਦਾ ਹੈ ਅਤੇ ਉਸ ਰੁੱਖ ਦਾ ਫਲ ਬੁੱਧ ਦੇਣ ਦੇ ਯੋਗ ਹੈ ਤਾਂ ਉਸ ਨੇ ਉਹ ਦੇ ਫਲ ਨੂੰ ਲਿਆ ਤੇ ਆਪ ਖਾਧਾ ਅਤੇ ਆਪਣੇ ਪਤੀ ਨੂੰ ਵੀ ਦਿੱਤਾ ਅਤੇ ਉਸ ਨੇ ਵੀ ਖਾਧਾ। ");
INSERT INTO pan_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","ਤਦ ਦੋਹਾਂ ਦੀਆਂ ਅੱਖਾਂ ਖੁੱਲ੍ਹ ਗਈਆਂ ਅਤੇ ਉਨ੍ਹਾਂ ਨੇ ਜਾਣ ਲਿਆ, ਜੋ ਅਸੀਂ ਨੰਗੇ ਹਾਂ ਇਸ ਲਈ ਉਨ੍ਹਾਂ ਨੇ ਹੰਜ਼ੀਰ ਦੇ ਪੱਤੇ ਸੀਉਂਕੇ ਆਪਣੇ ਲਈ ਬਸਤਰ ਬਣਾ ਲਏ। ");
INSERT INTO pan_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","ਉਨ੍ਹਾਂ ਨੇ ਯਹੋਵਾਹ ਪਰਮੇਸ਼ੁਰ ਦੀ ਅਵਾਜ਼ ਸੁਣੀ, ਜਦ ਉਹ ਬਾਗ਼ ਵਿੱਚ ਸ਼ਾਮ ਦੇ ਠੰਡੇ ਵੇਲੇ ਚਲਦਾ ਫਿਰਦਾ ਸੀ। ਉਸ ਆਦਮੀ ਅਤੇ ਉਹ ਦੀ ਪਤਨੀ ਨੇ ਆਪਣੇ ਨੂੰ ਬਾਗ਼ ਦੇ ਰੁੱਖਾਂ ਦੇ ਵਿਚਕਾਰ ਯਹੋਵਾਹ ਪਰਮੇਸ਼ੁਰ ਦੇ ਸਾਹਮਣਿਓਂ ਆਪਣੇ ਆਪ ਨੂੰ ਲੁਕਾ ਲਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","ਤਦ ਯਹੋਵਾਹ ਪਰਮੇਸ਼ੁਰ ਨੇ ਆਦਮ ਨੂੰ ਪੁਕਾਰ ਕੇ ਆਖਿਆ ਕਿ ਤੂੰ ਕਿੱਥੇ ਹੈਂ? ");
INSERT INTO pan_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","ਉਸ ਨੇ ਆਖਿਆ, ਮੈਂ ਬਾਗ਼ ਵਿੱਚ ਤੇਰੀ ਅਵਾਜ਼ ਸੁਣ ਕੇ ਡਰ ਗਿਆ ਕਿਉਂ ਜੋ ਮੈਂ ਨੰਗਾ ਸੀ ਇਸ ਲਈ ਮੈਂ ਆਪਣੇ ਆਪ ਨੂੰ ਲੁਕਾ ਲਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","ਉਸ ਨੇ ਪੁੱਛਿਆ, ਤੈਨੂੰ ਕਿਸ ਨੇ ਦੱਸਿਆ ਜੋ ਤੂੰ ਨੰਗਾ ਹੈਂ? ਜਿਸ ਰੁੱਖ ਤੋਂ ਮੈਂ ਤੈਨੂੰ ਹੁਕਮ ਦਿੱਤਾ ਸੀ ਕਿ ਉਸ ਦਾ ਫਲ ਨਾ ਖਾਵੀਂ ਕੀ ਤੂੰ ਉਸ ਦਾ ਫਲ ਖਾਧਾ ਹੈ? ");
INSERT INTO pan_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","ਫੇਰ ਆਦਮ ਨੇ ਜਵਾਬ ਦਿੱਤਾ ਕਿ ਜਿਹੜੀ ਇਸਤਰੀ ਤੂੰ ਮੈਨੂੰ ਦਿੱਤੀ, ਉਸ ਨੇ ਉਸ ਰੁੱਖ ਦਾ ਫਲ ਮੈਨੂੰ ਦਿੱਤਾ ਇਸ ਲਈ ਮੈਂ ਖਾ ਲਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","ਤਦ ਯਹੋਵਾਹ ਪਰਮੇਸ਼ੁਰ ਨੇ ਇਸਤਰੀ ਨੂੰ ਆਖਿਆ, ਤੂੰ ਇਹ ਕੀ ਕੀਤਾ? ਇਸਤਰੀ ਨੇ ਆਖਿਆ, ਸੱਪ ਨੇ ਮੈਨੂੰ ਭਰਮਾਇਆ ਤਦ ਮੈਂ ਉਸ ਫਲ ਨੂੰ ਖਾਧਾ। ");
INSERT INTO pan_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","ਫੇਰ ਯਹੋਵਾਹ ਪਰਮੇਸ਼ੁਰ ਨੇ ਸੱਪ ਨੂੰ ਆਖਿਆ, ਕਿਉਂ ਜੋ ਤੂੰ ਇਹ ਕੀਤਾ ਹੈ, ਇਸ ਕਾਰਨ ਤੂੰ ਸਾਰੇ ਜੰਗਲੀ ਜਾਨਵਰਾਂ ਨਾਲੋਂ ਸਰਾਪੀ ਹੈਂ। ਤੂੰ ਆਪਣੇ ਪੇਟ ਦੇ ਭਾਰ ਚੱਲੇਂਗਾ ਅਤੇ ਤੂੰ ਸਾਰੀ ਜ਼ਿੰਦਗੀ ਮਿੱਟੀ ਖਾਇਆ ਕਰੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","ਮੈਂ ਤੇਰੇ ਅਤੇ ਇਸਤਰੀ ਵਿੱਚ, ਤੇਰੀ ਸੰਤਾਨ ਤੇ ਇਸਤਰੀ ਦੀ ਸੰਤਾਨ ਵਿੱਚ ਵੈਰ ਪਾਵਾਂਗਾ। ਉਹ ਤੇਰੇ ਸਿਰ ਨੂੰ ਫੇਵੇਂਗਾ ਅਤੇ ਤੂੰ ਉਸ ਦੀ ਅੱਡੀ ਨੂੰ ਡੰਗ ਮਾਰੇਂਗਾ। ");
INSERT INTO pan_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","ਉਸ ਨੇ ਇਸਤਰੀ ਨੂੰ ਆਖਿਆ ਕਿ ਮੈਂ ਤੇਰੇ ਗਰਭ ਦੀ ਪੀੜ ਬਹੁਤ ਵਧਾਵਾਂਗਾ। ਪੀੜ ਨਾਲ ਤੂੰ ਬੱਚੇ ਜਣੇਂਗੀ ਅਤੇ ਤੇਰੇ ਪਤੀ ਵੱਲ ਤੇਰੀ ਚਾਹ ਹੋਵੇਗੀ ਅਤੇ ਉਹ ਤੇਰੇ ਉੱਤੇ ਹੁਕਮ ਚਲਾਵੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","ਫੇਰ ਉਸ ਨੇ ਆਦਮ ਨੂੰ ਆਖਿਆ ਕਿਉਂਕਿ ਤੂੰ ਆਪਣੀ ਪਤਨੀ ਦੀ ਗੱਲ ਸੁਣੀ ਅਤੇ ਉਸ ਰੁੱਖ ਦਾ ਫਲ ਖਾਧਾ ਜਿਸ ਦੇ ਵਿਖੇ ਮੈਂ ਤੈਨੂੰ ਹੁਕਮ ਦਿੱਤਾ ਸੀ ਕਿ ਉਸ ਤੋਂ ਨਾ ਖਾਵੀਂ ਇਸ ਲਈ ਜ਼ਮੀਨ ਤੇਰੇ ਕਾਰਨ ਸਰਾਪਤ ਹੋਈ। ਤੂੰ ਇਸ ਦੀ ਉਪਜ ਆਪਣੀ ਸਾਰੀ ਜ਼ਿੰਦਗੀ ਦੁੱਖ ਨਾਲ ਖਾਇਆ ਕਰੇਂਗਾ। ");
INSERT INTO pan_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","ਉਹ ਤੇਰੇ ਲਈ ਕੰਡੇ, ਕੰਡਿਆਲੇ ਉਪਜਾਵੇਗੀ ਅਤੇ ਤੂੰ ਪੈਲੀ ਦਾ ਸਾਗ ਪੱਤ ਖਾਵੇਂਗਾ। ");
INSERT INTO pan_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","ਤੂੰ ਮੱਥੇ ਦੇ ਪਸੀਨੇ ਨਾਲ ਰੋਟੀ ਖਾਇਆ ਕਰੇਂਗਾ ਜਦ ਤੱਕ ਤੂੰ ਮਿੱਟੀ ਵਿੱਚ ਫੇਰ ਨਾ ਮਿਲ ਜਾਵੇਂ ਕਿਉਂ ਜੋ ਤੂੰ ਉਸ ਵਿੱਚੋਂ ਹੀ ਕੱਢਿਆ ਗਿਆ ਸੀ। ਤੂੰ ਮਿੱਟੀ ਹੈਂ ਅਤੇ ਮਿੱਟੀ ਵਿੱਚ ਹੀ ਮੁੜ ਜਾਵੇਂਗਾ। ");
INSERT INTO pan_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","ਆਦਮ ਨੇ ਆਪਣੀ ਪਤਨੀ ਦਾ ਨਾਮ ਹੱਵਾਹ ਰੱਖਿਆ ਕਿਉਂ ਜੋ ਉਹ ਸਾਰੇ ਜੀਉਂਦਿਆਂ ਦੀ ਮਾਤਾ ਹੋਈ। ");
INSERT INTO pan_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","ਯਹੋਵਾਹ ਪਰਮੇਸ਼ੁਰ ਨੇ ਆਦਮ ਅਤੇ ਉਹ ਦੀ ਪਤਨੀ ਲਈ ਚਮੜੇ ਦੇ ਬਸਤਰ ਬਣਾ ਕੇ ਉਨ੍ਹਾਂ ਨੂੰ ਪਹਿਨਾਏ। ");
INSERT INTO pan_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","ਤਦ ਯਹੋਵਾਹ ਪਰਮੇਸ਼ੁਰ ਨੇ ਆਖਿਆ, ਵੇਖੋ ਮਨੁੱਖ ਭਲੇ ਬੁਰੇ ਦੀ ਸਮਝ ਵਿੱਚ ਸਾਡੇ ਵਿੱਚੋਂ ਇੱਕ ਵਰਗਾ ਹੋ ਗਿਆ ਹੈ ਅਤੇ ਹੁਣ ਅਜਿਹਾ ਨਾ ਹੋਵੇ ਕਿ ਉਹ ਆਪਣਾ ਹੱਥ ਵਧਾ ਕੇ ਜੀਵਨ ਦੇ ਰੁੱਖ ਦਾ ਫਲ ਵੀ ਖਾ ਲਵੇ ਅਤੇ ਸਦਾ ਜੀਉਂਦਾ ਰਹੇ। ");
INSERT INTO pan_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","ਇਸ ਲਈ ਯਹੋਵਾਹ ਪਰਮੇਸ਼ੁਰ ਨੇ ਉਹ ਨੂੰ ਅਦਨ ਦੇ ਬਾਗ਼ ਵਿੱਚੋਂ ਕੱਢ ਦਿੱਤਾ ਤਾਂ ਜੋ ਉਹ ਉਸ ਜ਼ਮੀਨ ਨੂੰ ਵਾਹੇ ਜਿਸ ਤੋਂ ਉਹ ਰਚਿਆ ਗਿਆ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","ਇਸ ਲਈ ਉਸ ਨੇ ਆਦਮ ਨੂੰ ਕੱਢ ਦਿੱਤਾ ਅਤੇ ਉਸ ਨੇ ਅਦਨ ਦੇ ਬਾਗ਼ ਦੇ ਪੂਰਬ ਵੱਲ ਦੂਤਾਂ ਨੂੰ ਅਤੇ ਚਾਰ ਚੁਫ਼ੇਰੇ ਘੁੰਮਣ ਵਾਲੀ ਅੱਗ ਦੀ ਤਲਵਾਰ ਨੂੰ ਰੱਖਿਆ ਤਾਂ ਜੋ ਓਹ ਜੀਵਨ ਦੇ ਰੁੱਖ ਦੇ ਰਾਹ ਦੀ ਰਾਖੀ ਕਰਨ। ");
INSERT INTO pan_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","ਆਦਮ ਨੇ ਆਪਣੀ ਪਤਨੀ ਹੱਵਾਹ ਨਾਲ ਸੰਗ ਕੀਤਾ ਅਤੇ ਉਹ ਗਰਭਵਤੀ ਹੋਈ ਅਤੇ ਕਾਇਨ ਨੂੰ ਜਨਮ ਦਿੱਤਾ ਤਦ ਉਹ ਨੇ ਆਖਿਆ, ਮੈਂ ਇੱਕ ਮਨੁੱਖ ਯਹੋਵਾਹ ਕੋਲੋਂ ਪ੍ਰਾਪਤ ਕੀਤਾ। ");
INSERT INTO pan_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","ਫੇਰ ਉਸ ਨੇ ਉਸ ਦੇ ਭਰਾ ਹਾਬਲ ਨੂੰ ਜਨਮ ਦਿੱਤਾ, ਹਾਬਲ ਇੱਜੜਾਂ ਦਾ ਆਜੜੀ ਸੀ ਅਤੇ ਕਾਇਨ ਖੇਤੀਬਾੜੀ ਕਰਦਾ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","ਕੁਝ ਦਿਨਾਂ ਬਾਅਦ ਅਜਿਹਾ ਹੋਇਆ ਕਿ ਕਾਇਨ ਜ਼ਮੀਨ ਦੇ ਫਲ ਤੋਂ ਯਹੋਵਾਹ ਨੂੰ ਭੇਟ ਚੜ੍ਹਾਉਣ ਲਈ ਕੁਝ ਲੈ ਆਇਆ। ");
INSERT INTO pan_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","ਹਾਬਲ ਵੀ ਇੱਜੜ ਦੇ ਪਹਿਲੌਠਿਆਂ ਨੂੰ ਅਤੇ ਉਨ੍ਹਾਂ ਦੀ ਚਰਬੀ ਵਿੱਚੋਂ ਕੁਝ ਲੈ ਆਇਆ, ਅਤੇ ਯਹੋਵਾਹ ਨੇ ਹਾਬਲ ਨੂੰ ਅਤੇ ਉਹ ਦੀ ਭੇਟ ਨੂੰ ਪਸੰਦ ਕੀਤਾ। ");
INSERT INTO pan_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","ਪਰ ਕਾਇਨ ਅਤੇ ਉਹ ਦੀ ਭੇਟ ਨੂੰ ਪਸੰਦ ਨਾ ਕੀਤਾ, ਇਸ ਲਈ ਕਾਇਨ ਬਹੁਤ ਕ੍ਰੋਧਵਾਨ ਹੋਇਆ ਅਤੇ ਉਹ ਦਾ ਚਿਹਰਾ ਉਦਾਸ ਹੋ ਗਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","ਤਦ ਯਹੋਵਾਹ ਨੇ ਕਾਇਨ ਨੂੰ ਆਖਿਆ, ਤੂੰ ਕਿਉਂ ਕ੍ਰੋਧਵਾਨ ਹੈਂ ਅਤੇ ਤੇਰੇ ਚਿਹਰੇ ਤੇ ਉਦਾਸੀ ਕਿਉਂ ਛਾਈ ਹੈ? ");
INSERT INTO pan_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","ਜੇ ਤੂੰ ਭਲਾ ਨਾ ਕਰੇਂ ਤਾਂ ਕੀ ਤੇਰੀ ਭੇਟ ਸਵੀਕਾਰ ਨਾ ਕੀਤੀ ਜਾਵੇਗੀ, ਪਰ ਜੇ ਤੂੰ ਭਲਾ ਨਾ ਕਰੇਂ ਤਾਂ ਪਾਪ ਦਰਵਾਜ਼ੇ ਉੱਤੇ ਘਾਤ ਲਾ ਕੇ ਬੈਠਦਾ ਹੈ ਅਤੇ ਉਹ ਤੈਨੂੰ ਲੋਚਦਾ ਹੈ ਪਰ ਤੂੰ ਉਹ ਦੇ ਉੱਤੇ ਪਰਬਲ ਹੋ। ");
INSERT INTO pan_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","ਫੇਰ ਕਾਇਨ ਨੇ ਆਪਣੇ ਭਰਾ ਹਾਬਲ ਨੂੰ ਕੁਝ ਕਿਹਾ ਅਤੇ ਜਦ ਉਹ ਖੇਤ ਵਿੱਚ ਸਨ, ਤਾਂ ਕਾਇਨ ਨੇ ਆਪਣੇ ਭਰਾ ਹਾਬਲ ਦੇ ਵਿਰੁੱਧ ਉੱਠ ਕੇ ਉਸ ਨੂੰ ਮਾਰ ਦਿੱਤਾ। ");
INSERT INTO pan_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","ਤਦ ਯਹੋਵਾਹ ਨੇ ਕਾਇਨ ਨੂੰ ਪੁੱਛਿਆ, ਤੇਰਾ ਭਰਾ ਹਾਬਲ ਕਿੱਥੇ ਹੈ? ਉਸ ਨੇ ਆਖਿਆ, ਮੈਂ ਨਹੀਂ ਜਾਣਦਾ। ਭਲਾ, ਮੈਂ ਆਪਣੇ ਭਰਾ ਦਾ ਰਾਖ਼ਾ ਹਾਂ? ");
INSERT INTO pan_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","ਫੇਰ ਉਸ ਨੇ ਆਖਿਆ, ਤੂੰ ਇਹ ਕੀ ਕੀਤਾ ਹੈ? ਤੇਰੇ ਭਰਾ ਦਾ ਲਹੂ ਜ਼ਮੀਨ ਤੋਂ ਮੇਰੇ ਅੱਗੇ ਦੁਹਾਈ ਦਿੰਦਾ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","ਇਸ ਲਈ ਹੁਣ ਤੂੰ ਜ਼ਮੀਨ ਤੋਂ, ਜਿਸ ਨੇ ਆਪਣਾ ਮੂੰਹ ਤੇਰੇ ਭਰਾ ਦਾ ਲਹੂ ਤੇਰੇ ਹੱਥੋਂ ਲੈਣ ਲਈ ਖੋਲ੍ਹਿਆ ਹੈ, ਸਰਾਪੀ ਹੋਇਆ ਹੈਂ। ");
INSERT INTO pan_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","ਜਦ ਤੂੰ ਜ਼ਮੀਨ ਦੀ ਵਾਹੀ ਕਰੇਂਗਾ ਤਾਂ ਉਹ ਤੇਰੇ ਲਈ ਆਪਣੀ ਪੂਰੀ ਫ਼ਸਲ ਨਹੀਂ ਦੇਵੇਗੀ। ਤੂੰ ਧਰਤੀ ਉੱਤੇ ਭਗੌੜਾ ਅਤੇ ਭਟਕਣ ਵਾਲਾ ਹੋਵੇਂਗਾ। ");
INSERT INTO pan_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","ਕਾਇਨ ਨੇ ਯਹੋਵਾਹ ਨੂੰ ਆਖਿਆ, ਮੇਰੀ ਸਜ਼ਾ ਸਹਿਣ ਤੋਂ ਬਾਹਰ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","ਵੇਖ ਤੂੰ ਅੱਜ ਦੇ ਦਿਨ ਮੈਨੂੰ ਇਸ ਜ਼ਮੀਨ ਦੇ ਉੱਤੋਂ ਦੁਰਕਾਰ ਦਿੱਤਾ ਅਤੇ ਮੈਂ ਤੇਰੇ ਅੱਗੋਂ ਲੁੱਕ ਜਾਂਵਾਂਗਾ, ਮੈਂ ਧਰਤੀ ਉੱਤੇ ਭਗੌੜਾ ਅਤੇ ਭਟਕਣ ਵਾਲਾ ਹੋਵਾਂਗਾ ਅਤੇ ਜੋ ਕੋਈ ਮੈਨੂੰ ਲੱਭੇਗਾ ਉਹ ਮੈਨੂੰ ਮਾਰ ਸੁੱਟੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","ਤਦ ਯਹੋਵਾਹ ਨੇ ਉਹ ਨੂੰ ਆਖਿਆ ਜੋ ਕੋਈ ਕਾਇਨ ਨੂੰ ਮਾਰੇ ਉਸ ਤੋਂ ਸੱਤ ਗੁਣਾ ਬਦਲਾ ਲਿਆ ਜਾਵੇਗਾ ਅਤੇ ਯਹੋਵਾਹ ਨੇ ਕਾਇਨ ਲਈ ਇੱਕ ਨਿਸ਼ਾਨ ਠਹਿਰਾਇਆ ਤਾਂ ਜੋ ਅਜਿਹਾ ਨਾ ਹੋਵੇ ਕਿ ਕੋਈ ਉਹ ਨੂੰ ਲੱਭ ਕੇ ਮਾਰ ਸੁੱਟੇ। ");
INSERT INTO pan_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","ਸੋ ਕਾਇਨ ਯਹੋਵਾਹ ਦੇ ਹਜ਼ੂਰੋਂ ਚੱਲਿਆ ਗਿਆ ਅਤੇ ਅਦਨ ਦੇ ਪੂਰਬ ਵੱਲ ਨੋਦ ਦੇਸ਼ ਵਿੱਚ ਜਾ ਕੇ ਵੱਸ ਗਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","ਕਾਇਨ ਨੇ ਆਪਣੀ ਪਤਨੀ ਨਾਲ ਸੰਗ ਕੀਤਾ, ਅਤੇ ਉਹ ਗਰਭਵਤੀ ਹੋਈ, ਉਸ ਨੇ ਹਨੋਕ ਨੂੰ ਜਨਮ ਦਿੱਤਾ ਅਤੇ ਉਸ ਨੇ ਇੱਕ ਨਗਰ ਬਣਾਇਆ, ਉਸ ਨੇ ਉਸ ਨਗਰ ਦਾ ਨਾਮ ਆਪਣੇ ਪੁੱਤਰ ਦੇ ਨਾਮ ਉੱਤੇ ਹਨੋਕ ਰੱਖਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","ਹਨੋਕ ਤੋਂ ਈਰਾਦ ਜੰਮਿਆ, ਈਰਾਦ ਤੋਂ ਮਹੂਯਾਏਲ ਜੰਮਿਆ, ਮਹੂਯਾਏਲ ਤੋਂ ਮਥੂਸ਼ਾਏਲ ਜੰਮਿਆ ਅਤੇ ਮਥੂਸ਼ਾਏਲ ਤੋਂ ਲਾਮਕ ਜੰਮਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","ਲਾਮਕ ਨੇ ਆਪਣੇ ਲਈ ਦੋ ਪਤਨੀਆਂ ਰੱਖੀਆਂ, ਇੱਕ ਦਾ ਨਾਮ ਆਦਾਹ ਸੀ ਅਤੇ ਦੂਸਰੀ ਦਾ ਨਾਮ ਜ਼ਿੱਲਾਹ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","ਆਦਾਹ ਨੇ ਯਾਬਲ ਨੂੰ ਜਨਮ ਦਿੱਤਾ। ਉਹ ਉਨ੍ਹਾਂ ਦਾ ਪਿਤਾ ਸੀ ਜਿਹੜੇ ਤੰਬੂਆਂ ਵਿੱਚ ਵੱਸਦੇ ਸਨ ਅਤੇ ਪਸ਼ੂ ਪਾਲਦੇ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","ਅਤੇ ਉਸ ਦੇ ਭਰਾ ਦਾ ਨਾਮ ਜ਼ੂਬਲ ਸੀ। ਉਹ ਉਹਨਾਂ ਸਾਰਿਆਂ ਦਾ ਪਿਤਾ ਸੀ ਜਿਹੜੇ ਬਰਬਤ ਅਤੇ ਬੀਨ ਵਜਾਉਂਦੇ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","ਜ਼ਿੱਲਾਹ ਨੇ ਵੀ ਤੂਬਲ ਕਾਇਨ ਨੂੰ ਜਨਮ ਦਿੱਤਾ। ਉਹ ਲੋਹੇ, ਪਿੱਤਲ ਦੇ ਹਰ ਇੱਕ ਵੱਢਣ ਵਾਲੇ ਸੰਦ ਨੂੰ ਤਿੱਖਾ ਕਰਨ ਵਾਲਾ ਸੀ ਅਤੇ ਤੂਬਲ ਕਾਇਨ ਦੀ ਭੈਣ ਨਾਮਾਹ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","ਲਾਮਕ ਨੇ ਆਪਣੀਆਂ ਪਤਨੀਆਂ ਨੂੰ ਆਖਿਆ - ਆਦਾਹ ਤੇ ਜ਼ਿੱਲਾਹ, ਮੇਰੀ ਗੱਲ ਨੂੰ ਸੁਣੋ, ਹੇ ਲਾਮਕ ਦੀ ਪਤਨੀਓ ਮੇਰੇ ਬਚਨ ਤੇ ਕੰਨ ਲਾਓ। ਮੈਂ ਤਾਂ ਇੱਕ ਮਨੁੱਖ ਨੂੰ, ਜਿਸ ਨੇ ਮੈਨੂੰ ਫੱਟੜ ਕੀਤਾ ਅਤੇ ਇੱਕ ਗੱਭਰੂ ਨੂੰ, ਜਿਸ ਨੇ ਮੈਨੂੰ ਸੱਟ ਮਾਰੀ ਮਾਰ ਸੁੱਟਿਆ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","ਜੇ ਕਾਇਨ ਦਾ ਬਦਲਾ ਸੱਤ ਗੁਣਾ ਹੈ ਤਾਂ ਲਾਮਕ ਦਾ ਸਤੱਤਰ ਗੁਣਾ ਲਿਆ ਜਾਵੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","ਆਦਮ ਨੇ ਫੇਰ ਆਪਣੀ ਪਤਨੀ ਨਾਲ ਸੰਗ ਕੀਤਾ ਅਤੇ ਉਸਨੇ ਪੁੱਤਰ ਨੂੰ ਜਨਮ ਦਿੱਤਾ ਅਤੇ ਉਸ ਨੇ ਇਹ ਆਖ ਕੇ ਉਹ ਦਾ ਨਾਮ ਸੇਥ ਰੱਖਿਆ ਕਿ ਪਰਮੇਸ਼ੁਰ ਨੇ ਮੈਨੂੰ ਹਾਬਲ ਦੀ ਥਾਂ ਇੱਕ ਹੋਰ ਪੁੱਤਰ ਦਿੱਤਾ ਜਿਸ ਨੂੰ ਕਾਇਨ ਨੇ ਮਾਰ ਸੁੱਟਿਆ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","ਅਤੇ ਸੇਥ ਤੋਂ ਵੀ ਇੱਕ ਪੁੱਤਰ ਜੰਮਿਆ ਅਤੇ ਉਸ ਨੇ ਉਹ ਦਾ ਨਾਮ ਅਨੋਸ਼ ਰੱਖਿਆ। ਉਸ ਵੇਲੇ ਤੋਂ ਲੋਕ ਯਹੋਵਾਹ ਦਾ ਨਾਮ ਲੈਣ ਲੱਗੇ। ");
INSERT INTO pan_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","ਇਹ ਆਦਮ ਦੀ ਵੰਸ਼ਾਵਲੀ ਦੀ ਪੋਥੀ ਹੈ। ਜਿਸ ਦਿਨ ਪਰਮੇਸ਼ੁਰ ਨੇ ਆਦਮ ਦੀ ਰਚਨਾ ਕੀਤੀ, ਉਸ ਨੇ ਪਰਮੇਸ਼ੁਰ ਵਰਗਾ ਉਸ ਨੂੰ ਬਣਾਇਆ। ");
INSERT INTO pan_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","ਨਰ ਨਾਰੀ ਕਰਕੇ ਉਨ੍ਹਾਂ ਦੀ ਰਚਨਾ ਕੀਤੀ ਤੇ ਉਨ੍ਹਾਂ ਨੂੰ ਅਸੀਸ ਦਿੱਤੀ ਅਤੇ ਜਿਸ ਦਿਨ ਉਨ੍ਹਾਂ ਨੂੰ ਉਤਪਤ ਕੀਤਾ ਉਨ੍ਹਾਂ ਦਾ ਨਾਮ ਆਦਮ ਰੱਖਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","ਆਦਮ ਇੱਕ ਸੌ ਤੀਹ ਸਾਲ ਦਾ ਹੋਇਆ ਤਾਂ ਉਸ ਤੋਂ ਇੱਕ ਪੁੱਤਰ ਉਸ ਵਰਗਾ ਤੇ ਉਸ ਦੇ ਸਰੂਪ ਵਿੱਚ ਪੈਦਾ ਹੋਇਆ ਅਤੇ ਉਸ ਨੇ ਉਹ ਦਾ ਨਾਮ ਸੇਥ ਰੱਖਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","ਸੇਥ ਦੇ ਜੰਮਣ ਦੇ ਬਾਅਦ ਆਦਮ ਅੱਠ ਸੌ ਸਾਲ ਤੱਕ ਜੀਉਂਦਾ ਰਿਹਾ, ਅਤੇ ਉਸ ਤੋਂ ਹੋਰ ਵੀ ਪੁੱਤਰ ਧੀਆਂ ਜੰਮੇ। ");
INSERT INTO pan_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","ਆਦਮ ਦੀ ਸਾਰੀ ਉਮਰ ਨੌ ਸੌ ਤੀਹ ਸਾਲਾਂ ਦੀ ਹੋਈ ਤਦ ਉਹ ਮਰ ਗਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","ਸੇਥ ਇੱਕ ਸੌ ਪੰਜ ਸਾਲਾਂ ਦਾ ਸੀ ਤਦ ਉਸ ਤੋਂ ਅਨੋਸ਼ ਜੰਮਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","ਅਤੇ ਅਨੋਸ਼ ਦੇ ਜੰਮਣ ਦੇ ਪਿੱਛੋਂ ਸੇਥ ਅੱਠ ਸੌ ਸੱਤ ਸਾਲਾਂ ਤੱਕ ਜੀਉਂਦਾ ਰਿਹਾ ਅਤੇ ਉਸ ਤੋਂ ਹੋਰ ਵੀ ਪੁੱਤਰ ਧੀਆਂ ਜੰਮੇ। ");
INSERT INTO pan_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","ਸੇਥ ਦੀ ਸਾਰੀ ਉਮਰ ਨੌ ਸੌ ਬਾਰਾਂ ਸਾਲਾਂ ਦੀ ਹੋਈ ਤਦ ਉਹ ਮਰ ਗਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","ਅਨੋਸ਼ ਨੱਬੇ ਸਾਲਾਂ ਦਾ ਸੀ ਤਾਂ ਉਸ ਤੋਂ ਕੇਨਾਨ ਜੰਮਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","ਅਤੇ ਕੇਨਾਨ ਦੇ ਜੰਮਣ ਦੇ ਪਿੱਛੋਂ ਅਨੋਸ਼ ਅੱਠ ਸੌ ਪੰਦਰਾਂ ਸਾਲਾਂ ਤੱਕ ਜੀਉਂਦਾ ਰਿਹਾ ਅਤੇ ਉਸ ਤੋਂ ਹੋਰ ਵੀ ਪੁੱਤਰ ਧੀਆਂ ਜੰਮੇ। ");
INSERT INTO pan_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","ਅਨੋਸ਼ ਦੀ ਸਾਰੀ ਉਮਰ ਨੌ ਸੌ ਪੰਜ ਸਾਲਾਂ ਦੀ ਹੋਈ ਤਦ ਉਹ ਮਰ ਗਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","ਕੇਨਾਨ ਸੱਤਰ ਸਾਲਾਂ ਦਾ ਸੀ ਤਦ ਉਸ ਤੋਂ ਮਹਲਲੇਲ ਜੰਮਿਆ ");
INSERT INTO pan_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","ਅਤੇ ਮਹਲਲੇਲ ਦੇ ਜੰਮਣ ਦੇ ਪਿੱਛੋਂ ਕੇਨਾਨ ਅੱਠ ਸੌ ਚਾਲ੍ਹੀ ਸਾਲਾਂ ਤੱਕ ਜੀਉਂਦਾ ਰਿਹਾ ਅਤੇ ਉਸ ਤੋਂ ਹੋਰ ਵੀ ਪੁੱਤਰ ਧੀਆਂ ਜੰਮੇ। ");
INSERT INTO pan_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","ਕੇਨਾਨ ਦੀ ਸਾਰੀ ਉਮਰ ਨੌ ਸੌ ਦਸਾਂ ਸਾਲਾਂ ਦੀ ਹੋਈ ਤਦ ਉਹ ਮਰ ਗਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","ਮਹਲਲੇਲ ਪੈਂਹਠ ਸਾਲਾਂ ਦਾ ਸੀ ਤਦ ਉਸ ਤੋਂ ਯਰਦ ਜੰਮਿਆ ");
INSERT INTO pan_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","ਅਤੇ ਯਰਦ ਦੇ ਜੰਮਣ ਦੇ ਪਿੱਛੋਂ ਮਹਲਲੇਲ ਅੱਠ ਸੌ ਤੀਹ ਸਾਲਾਂ ਤੱਕ ਜੀਉਂਦਾ ਰਿਹਾ ਅਤੇ ਉਸ ਤੋਂ ਹੋਰ ਵੀ ਪੁੱਤਰ ਧੀਆਂ ਜੰਮੇ। ");
INSERT INTO pan_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","ਮਹਲਲੇਲ ਦੀ ਸਾਰੀ ਉਮਰ ਅੱਠ ਸੌ ਪਚਾਨਵੇਂ ਸਾਲਾਂ ਦੀ ਹੋਈ, ਤਦ ਉਹ ਮਰ ਗਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","ਯਰਦ ਇੱਕ ਸੌ ਬਾਹਠ ਸਾਲਾਂ ਦਾ ਸੀ ਤਦ ਉਸ ਤੋਂ ਹਨੋਕ ਜੰਮਿਆ ");
INSERT INTO pan_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","ਅਤੇ ਹਨੋਕ ਦੇ ਜੰਮਣ ਦੇ ਪਿੱਛੋਂ ਯਰਦ ਅੱਠ ਸੌ ਸਾਲਾਂ ਤੱਕ ਜੀਉਂਦਾ ਰਿਹਾ ਅਤੇ ਉਸ ਤੋਂ ਹੋਰ ਵੀ ਪੁੱਤਰ ਧੀਆਂ ਜੰਮੇ। ");
INSERT INTO pan_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","ਯਰਦ ਦੀ ਸਾਰੀ ਉਮਰ ਨੌ ਸੌ ਬਾਹਠ ਸਾਲਾਂ ਦੀ ਹੋਈ, ਤਦ ਉਹ ਮਰ ਗਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","ਹਨੋਕ ਪੈਂਹਠ ਸਾਲਾਂ ਦਾ ਸੀ ਤਦ ਉਸ ਤੋਂ ਮਥੂਸਲਹ ਜੰਮਿਆ, ");
INSERT INTO pan_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","ਅਤੇ ਮਥੂਸਲਹ ਦੇ ਜੰਮਣ ਦੇ ਪਿੱਛੋਂ ਹਨੋਕ ਤਿੰਨ ਸੌ ਸਾਲਾਂ ਤੱਕ ਪਰਮੇਸ਼ੁਰ ਦੇ ਸੰਗ-ਸੰਗ ਚਲਦਾ ਰਿਹਾ ਅਤੇ ਉਸ ਤੋਂ ਹੋਰ ਵੀ ਪੁੱਤਰ ਅਤੇ ਧੀਆਂ ਜੰਮੇ। ");
INSERT INTO pan_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","ਹਨੋਕ ਦੀ ਸਾਰੀ ਉਮਰ ਤਿੰਨ ਸੌ ਪੈਂਹਠ ਸਾਲਾਂ ਦੀ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","ਹਨੋਕ ਪਰਮੇਸ਼ੁਰ ਦੇ ਸੰਗ-ਸੰਗ ਚਲਦਾ ਹੋਇਆ ਅਲੋਪ ਹੋ ਗਿਆ ਕਿਉਂ ਜੋ ਪਰਮੇਸ਼ੁਰ ਨੇ ਉਸ ਨੂੰ ਉਠਾ ਲਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","ਮਥੂਸਲਹ ਇੱਕ ਸੌ ਸਤਾਸੀ ਸਾਲਾਂ ਦਾ ਸੀ ਤਦ ਉਸ ਤੋਂ ਲਾਮਕ ਜੰਮਿਆ, ");
INSERT INTO pan_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","ਅਤੇ ਲਾਮਕ ਦੇ ਜੰਮਣ ਦੇ ਪਿੱਛੋਂ ਮਥੂਸਲਹ ਸੱਤ ਸੌ ਬਿਆਸੀ ਸਾਲਾਂ ਤੱਕ ਜੀਉਂਦਾ ਰਿਹਾ ਅਤੇ ਉਸ ਤੋਂ ਹੋਰ ਵੀ ਪੁੱਤਰ ਅਤੇ ਧੀਆਂ ਜੰਮੇ। ");
INSERT INTO pan_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","ਮਥੂਸਲਹ ਦੀ ਸਾਰੀ ਉਮਰ ਨੌ ਸੌ ਉਨਹੱਤਰ ਸਾਲਾਂ ਦੀ ਹੋਈ, ਤਦ ਉਹ ਮਰ ਗਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","ਲਾਮਕ ਇੱਕ ਸੌ ਬਿਆਸੀ ਸਾਲਾਂ ਦਾ ਸੀ ਤਦ ਉਸ ਤੋਂ ਇੱਕ ਪੁੱਤਰ ਜੰਮਿਆ ");
INSERT INTO pan_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","ਅਤੇ ਉਸ ਨੇ ਇਹ ਆਖ ਕੇ ਉਹ ਦਾ ਨਾਮ ਨੂਹ ਰੱਖਿਆ ਕਿ ਇਹ ਸਾਨੂੰ ਸਾਡੀ ਮਿਹਨਤ ਤੋਂ ਅਤੇ ਸਾਡੇ ਹੱਥਾਂ ਦੀ ਸਖ਼ਤ ਕਮਾਈ ਤੋਂ ਜਿਹੜੀ ਜ਼ਮੀਨ ਦੇ ਕਾਰਨ ਸਾਡੇ ਉੱਤੇ ਆਈ ਹੈ, ਜਿਸ ਉੱਤੇ ਯਹੋਵਾਹ ਦਾ ਸਰਾਪ ਪਿਆ ਹੋਇਆ ਹੈ, ਸ਼ਾਂਤੀ ਦੇਵੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","ਨੂਹ ਦੇ ਜੰਮਣ ਦੇ ਪਿੱਛੋਂ ਲਾਮਕ ਪੰਜ ਸੌ ਪਚਾਨਵੇਂ ਸਾਲਾਂ ਤੱਕ ਜੀਉਂਦਾ ਰਿਹਾ ਅਤੇ ਉਸ ਤੋਂ ਹੋਰ ਵੀ ਪੁੱਤਰ ਅਤੇ ਧੀਆਂ ਜੰਮੇ। ");
INSERT INTO pan_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","ਲਾਮਕ ਦੀ ਸਾਰੀ ਉਮਰ ਸੱਤ ਸੌ ਸਤੱਤਰ ਸਾਲਾਂ ਦੀ ਹੋਈ, ਤਦ ਉਹ ਮਰ ਗਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","ਨੂਹ ਪੰਜ ਸੌ ਸਾਲਾਂ ਦਾ ਸੀ, ਤਦ ਨੂਹ ਤੋਂ ਸ਼ੇਮ, ਹਾਮ ਤੇ ਯਾਫ਼ਥ ਜੰਮੇ। ");
INSERT INTO pan_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","ਫਿਰ ਜਦ ਮਨੁੱਖ ਧਰਤੀ ਉੱਤੇ ਵਧਣ ਲੱਗ ਪਏ ਅਤੇ ਉਨ੍ਹਾਂ ਤੋਂ ਧੀਆਂ ਜੰਮੀਆਂ। ");
INSERT INTO pan_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","ਤਦ ਪਰਮੇਸ਼ੁਰ ਦੇ ਪੁੱਤਰਾਂ ਨੇ ਮਨੁੱਖ ਦੀਆਂ ਧੀਆਂ ਨੂੰ ਵੇਖਿਆ ਕਿ ਉਹ ਸੋਹਣੀਆਂ ਹਨ, ਤਦ ਉਨ੍ਹਾਂ ਨੇ ਉਨ੍ਹਾਂ ਸਾਰੀਆਂ ਵਿੱਚੋਂ ਆਪਣੇ ਲਈ ਚੁਣ ਕੇ ਉਹਨਾਂ ਨਾਲ ਵਿਆਹ ਕਰ ਲਏ। ");
INSERT INTO pan_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","ਯਹੋਵਾਹ ਨੇ ਆਖਿਆ, ਮੇਰਾ ਆਤਮਾ ਮਨੁੱਖ ਦੇ ਵਿਰੁੱਧ ਸਦਾ ਤੱਕ ਵਾਦ-ਵਿਵਾਦ ਨਹੀਂ ਕਰਦਾ ਰਹੇਗਾ ਕਿਉਂਕਿ ਉਹ ਸਰੀਰ ਹੀ ਹੈ, ਉਸ ਦੀ ਉਮਰ ਇੱਕ ਸੌ ਵੀਹ ਸਾਲਾਂ ਦੀ ਹੋਵੇਗੀ। ");
INSERT INTO pan_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","ਉਨ੍ਹਾਂ ਦਿਨਾਂ ਵਿੱਚ ਧਰਤੀ ਉੱਤੇ ਦੈਂਤ ਵੱਸਦੇ ਸਨ ਅਤੇ ਇਸ ਤੋਂ ਬਾਅਦ ਜਦ ਪਰਮੇਸ਼ੁਰ ਦੇ ਪੁੱਤਰ ਆਦਮੀ ਦੀਆਂ ਧੀਆਂ ਕੋਲ ਆਏ ਅਤੇ ਉਨ੍ਹਾਂ ਨੇ ਉਨ੍ਹਾਂ ਲਈ ਜੋ ਪੁੱਤਰ ਜਣੇ ਉਹ ਸੂਰਬੀਰ ਸਨ ਜਿਹੜੇ ਸ਼ੁਰੂ ਤੋਂ ਪ੍ਰਸਿੱਧ ਹੋਏ। ");
INSERT INTO pan_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","ਫੇਰ ਯਹੋਵਾਹ ਨੇ ਵੇਖਿਆ ਕਿ ਆਦਮੀ ਦੀ ਬੁਰਿਆਈ ਧਰਤੀ ਉੱਤੇ ਵੱਧ ਗਈ ਹੈ ਅਤੇ ਉਨ੍ਹਾਂ ਦੇ ਮਨ ਵਿੱਚ ਪੈਦਾ ਹੋਣ ਵਾਲਾ ਹਰੇਕ ਵਿਚਾਰ ਬੁਰਿਆਈ ਨਾਲ ਭਰਿਆ ਹੁੰਦਾ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","ਯਹੋਵਾਹ ਧਰਤੀ ਉੱਤੇ ਆਦਮੀ ਦੀ ਸਿਰਜਣਾ ਕਰਕੇ ਪਛਤਾਇਆ ਅਤੇ ਉਹ ਮਨ ਵਿੱਚ ਦੁਖੀ ਹੋਇਆ। ");
INSERT INTO pan_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","ਤਦ ਯਹੋਵਾਹ ਨੇ ਆਖਿਆ, ਮੈਂ ਆਦਮੀ ਨੂੰ ਜਿਸ ਦੀ ਮੈਂ ਰਚਨਾ ਕੀਤੀ, ਹੈ, ਆਦਮੀ, ਡੰਗਰ, ਘਿੱਸਰਨ ਵਾਲੇ ਅਤੇ ਅਕਾਸ਼ ਦੇ ਪੰਛੀਆਂ ਨੂੰ ਵੀ ਧਰਤੀ ਦੇ ਉੱਤੋਂ ਮਿਟਾ ਦਿਆਂਗਾ, ਕਿਉਂ ਜੋ ਮੈਂ ਉਨ੍ਹਾਂ ਨੂੰ ਬਣਾ ਕੇ ਪਛਤਾਉਂਦਾ ਹਾਂ। ");
INSERT INTO pan_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","ਪਰ ਨੂਹ ਉੱਤੇ ਯਹੋਵਾਹ ਦੀ ਕਿਰਪਾ ਹੋਈ। ");
INSERT INTO pan_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","ਇਹ ਨੂਹ ਦੀ ਵੰਸ਼ਾਵਲੀ ਹੈ। ਨੂਹ ਇੱਕ ਧਰਮੀ ਮਨੁੱਖ ਸੀ, ਆਪਣੀ ਪੀੜ੍ਹੀ ਵਿੱਚ ਸੰਪੂਰਨ ਸੀ ਅਤੇ ਨੂਹ ਪਰਮੇਸ਼ੁਰ ਦੇ ਨਾਲ-ਨਾਲ ਚਲਦਾ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","ਨੂਹ ਦੇ ਤਿੰਨ ਪੁੱਤਰ ਸਨ ਅਰਥਾਤ ਸ਼ੇਮ, ਹਾਮ ਅਤੇ ਯਾਫ਼ਥ। ");
INSERT INTO pan_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","ਧਰਤੀ ਪਰਮੇਸ਼ੁਰ ਦੇ ਅੱਗੇ ਵਿਗੜੀ ਹੋਈ ਸੀ ਅਤੇ ਜ਼ੁਲਮ ਨਾਲ ਭਰੀ ਹੋਈ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","ਤਦ ਪਰਮੇਸ਼ੁਰ ਨੇ ਧਰਤੀ ਨੂੰ ਵੇਖਿਆ ਅਤੇ ਵੇਖੋ ਉਹ ਵਿਗੜੀ ਹੋਈ ਸੀ, ਕਿਉਂ ਜੋ ਸਾਰੇ ਮਨੁੱਖਾਂ ਨੇ ਆਪਣੇ ਚਾਲ-ਚਲਣ ਨੂੰ ਧਰਤੀ ਉੱਤੇ ਵਿਗਾੜ ਲਿਆ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","ਪਰਮੇਸ਼ੁਰ ਨੇ ਨੂਹ ਨੂੰ ਆਖਿਆ, ਮੈਂ ਸਾਰੇ ਪ੍ਰਾਣੀਆਂ ਨੂੰ ਨਾਸ ਕਰਨ ਦਾ ਵਿਚਾਰ ਕਰ ਲਿਆ ਹੈ ਕਿਉਂ ਜੋ ਧਰਤੀ ਉਨ੍ਹਾਂ ਦੇ ਕਾਰਨ ਬੁਰਿਆਈ ਨਾਲ ਭਰ ਗਈ ਹੈ। ਵੇਖ ਮੈਂ ਉਨ੍ਹਾਂ ਨੂੰ ਧਰਤੀ ਦੇ ਸਮੇਤ ਨਾਸ ਕਰ ਦਿਆਂਗਾ। ");
INSERT INTO pan_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","ਤੂੰ ਗੋਫ਼ਰ ਦੀ ਲੱਕੜੀ ਤੋਂ ਆਪਣੇ ਲਈ ਇੱਕ ਕਿਸ਼ਤੀ ਬਣਾ। ਤੂੰ ਉਸ ਕਿਸ਼ਤੀ ਵਿੱਚ ਕੋਠੜੀਆਂ ਬਣਾਈਂ ਅਤੇ ਤੂੰ ਉਸ ਨੂੰ ਅੰਦਰੋਂ ਬਾਹਰੋਂ ਰਾਲ ਨਾਲ ਲਿੱਪੀਂ। ");
INSERT INTO pan_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","ਉਹ ਨੂੰ ਇਸੇ ਤਰ੍ਹਾਂ ਬਣਾਈਂ, ਭਈ ਕਿਸ਼ਤੀ ਦੀ ਲੰਬਾਈ ਤਿੰਨ ਸੌ ਹੱਥ, ਉਹ ਦੀ ਚੌੜਾਈ ਪੰਜਾਹ ਹੱਥ ਅਤੇ ਉਹ ਦੀ ਉਚਾਈ ਤੀਹ ਹੱਥ ਹੋਵੇ। ");
INSERT INTO pan_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","ਤੂੰ ਕਿਸ਼ਤੀ ਵਿੱਚ ਇੱਕ ਖਿੜਕੀ ਬਣਾਈਂ ਅਤੇ ਉਸ ਦੇ ਇੱਕ ਹੱਥ ਉੱਪਰੋਂ ਉਸ ਦੀ ਛੱਤ ਬਣਾਈਂ ਅਤੇ ਕਿਸ਼ਤੀ ਦੇ ਇੱਕ ਪਾਸੇ ਇੱਕ ਦਰਵਾਜ਼ਾ ਬਣਾਈਂ ਅਤੇ ਉਸ ਦੀਆਂ ਤਿੰਨ ਮੰਜ਼ਲਾਂ ਬਣਾਈਂ। ");
INSERT INTO pan_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","ਵੇਖ ਮੈਂ, ਹਾਂ, ਮੈਂ ਹੀ ਪਾਣੀ ਦੀ ਪਰਲੋ ਧਰਤੀ ਉੱਤੇ ਲਿਆ ਰਿਹਾ ਹਾਂ ਤਾਂ ਜੋ ਸਾਰੇ ਸਰੀਰਾਂ ਨੂੰ ਜਿਨ੍ਹਾਂ ਦੇ ਵਿੱਚ ਜੀਵਨ ਦਾ ਸਾਹ ਹੈ, ਅਕਾਸ਼ ਦੇ ਹੇਠੋਂ ਨਾਸ ਕਰ ਦਿਆਂ। ਉਹ ਸਭ ਕੁਝ ਜਿਹੜਾ ਧਰਤੀ ਉੱਤੇ ਹੈ, ਪ੍ਰਾਣ ਛੱਡ ਦੇਵੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","ਪਰ ਮੈਂ ਆਪਣਾ ਨੇਮ ਤੇਰੇ ਨਾਲ ਬੰਨ੍ਹਾਂਗਾ। ਤੂੰ ਕਿਸ਼ਤੀ ਵਿੱਚ ਆਪਣੇ ਪੁੱਤਰਾਂ, ਆਪਣੀ ਪਤਨੀ ਅਤੇ ਆਪਣੀਆਂ ਨੂੰਹਾਂ ਨਾਲ ਜਾਵੀਂ। ");
INSERT INTO pan_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","ਤੂੰ ਸਾਰੇ ਜੀਉਂਦੇ ਪ੍ਰਾਣੀਆਂ ਵਿੱਚੋਂ ਇੱਕ-ਇੱਕ ਜੋੜਾ ਅਰਥਾਤ ਨਰ ਅਤੇ ਮਾਦਾ ਕਿਸ਼ਤੀ ਵਿੱਚ ਲੈ ਲਈਂ ਤਾਂ ਜੋ ਤੂੰ ਉਨ੍ਹਾਂ ਨੂੰ ਆਪਣੇ ਨਾਲ ਜੀਉਂਦਾ ਰੱਖ ਸਕੇਂ। ");
INSERT INTO pan_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","ਪੰਛੀਆਂ ਦੀ ਹਰੇਕ ਪ੍ਰਜਾਤੀ, ਡੰਗਰ ਦੀ ਹਰੇਕ ਪ੍ਰਜਾਤੀ, ਅਤੇ ਜ਼ਮੀਨ ਦੇ ਸਾਰੇ ਘਿੱਸਰਨ ਵਾਲਿਆਂ ਵਿੱਚੋਂ ਉਨ੍ਹਾਂ ਦੀ ਪ੍ਰਜਾਤੀ ਅਨੁਸਾਰ ਸਾਰਿਆਂ ਵਿੱਚੋਂ ਇੱਕ-ਇੱਕ ਜੋੜਾ ਤੇਰੇ ਨਾਲ ਆਉਣਗੇ ਤਾਂ ਜੋ ਉਹ ਤੇਰੇ ਨਾਲ ਜੀਉਂਦੇ ਰਹਿਣ। ");
INSERT INTO pan_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","ਤੂੰ ਆਪਣੇ ਲਈ ਹਰ ਪ੍ਰਕਾਰ ਦੇ ਭੋਜਨ ਪਦਾਰਥਾਂ ਵਿੱਚੋਂ ਕੁਝ ਲੈ ਲੈ ਅਤੇ ਉਸ ਨੂੰ ਆਪਣੇ ਕੋਲ ਇਕੱਠਾ ਕਰ। ਉਹ ਤੇਰੇ ਲਈ ਅਤੇ ਉਨ੍ਹਾਂ ਦੇ ਲਈ ਭੋਜਨ ਹੋਵੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","ਤਦ ਨੂਹ ਨੇ ਉਸੇ ਤਰ੍ਹਾਂ ਹੀ ਕੀਤਾ, ਜਿਵੇਂ ਪਰਮੇਸ਼ੁਰ ਨੇ ਉਸ ਨੂੰ ਹੁਕਮ ਦਿੱਤਾ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","ਫੇਰ ਯਹੋਵਾਹ ਨੇ ਨੂਹ ਨੂੰ ਆਖਿਆ, ਤੂੰ ਅਤੇ ਤੇਰਾ ਸਾਰਾ ਘਰਾਣਾ ਕਿਸ਼ਤੀ ਵਿੱਚ ਜਾਓ ਕਿਉਂ ਜੋ ਮੈਂ ਤੈਨੂੰ ਇਸ ਪੀੜ੍ਹੀ ਵਿੱਚ ਧਰਮੀ ਵੇਖਿਆ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","ਸਾਰੇ ਸ਼ੁੱਧ ਪਸ਼ੂਆਂ ਵਿੱਚੋਂ ਸੱਤ-ਸੱਤ ਨਰ ਅਤੇ ਮਾਦਾ ਆਪਣੇ ਨਾਲ ਲੈ ਲੈ ਅਤੇ ਅਸ਼ੁੱਧ ਪਸ਼ੂਆਂ ਵਿੱਚੋਂ ਦੋ-ਦੋ ਨਰ ਅਤੇ ਮਾਦਾ। ");
INSERT INTO pan_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","ਅਤੇ ਅਕਾਸ਼ ਦੇ ਪੰਛੀਆਂ ਵਿੱਚੋਂ ਸੱਤ-ਸੱਤ ਨਰ ਮਾਦਾ ਲੈ ਤਾਂ ਜੋ ਸਾਰੀ ਧਰਤੀ ਉੱਤੇ ਅੰਸ ਜੀਉਂਦੀ ਰਹੇ। ");
INSERT INTO pan_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","ਕਿਉਂਕਿ ਸੱਤ ਦਿਨ ਬਾਅਦ ਮੈਂ ਧਰਤੀ ਉੱਤੇ ਚਾਲ੍ਹੀ ਦਿਨ, ਚਾਲ੍ਹੀ ਰਾਤ ਮੀਂਹ ਵਰਾਉਣ ਵਾਲਾ ਹਾਂ ਅਤੇ ਮੈਂ ਸਾਰੇ ਪ੍ਰਾਣੀਆਂ ਨੂੰ ਜਿਹਨਾਂ ਦੀ ਮੈਂ ਸਿਰਜਣਾ ਕੀਤੀ ਧਰਤੀ ਦੇ ਉੱਤੋਂ ਮਿਟਾ ਦਿਆਂਗਾ। ");
INSERT INTO pan_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","ਤਦ ਜਿਵੇਂ ਯਹੋਵਾਹ ਨੇ ਆਗਿਆ ਦਿੱਤੀ ਨੂਹ ਨੇ ਸਭ ਕੁਝ ਉਸੇ ਤਰ੍ਹਾਂ ਹੀ ਕੀਤਾ। ");
INSERT INTO pan_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","ਨੂਹ ਦੀ ਉਮਰ ਛੇ ਸੌ ਸਾਲਾਂ ਦਾ ਸੀ ਜਦ ਪਰਲੋ ਧਰਤੀ ਉੱਤੇ ਆਈ। ");
INSERT INTO pan_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","ਅਤੇ ਨੂਹ, ਉਹ ਦੇ ਪੁੱਤਰ, ਉਹ ਦੀ ਪਤਨੀ ਅਤੇ ਉਹ ਦੀਆਂ ਨੂੰਹਾਂ ਜਲ ਪਰਲੋ ਦੇ ਕਾਰਨ ਉਹ ਦੇ ਨਾਲ ਕਿਸ਼ਤੀ ਵਿੱਚ ਗਏ। ");
INSERT INTO pan_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","ਸ਼ੁੱਧ ਪਸ਼ੂਆਂ ਵਿੱਚੋਂ ਅਤੇ ਅਸ਼ੁੱਧ ਪਸ਼ੂਆਂ ਵਿੱਚੋਂ, ਪੰਛੀਆਂ ਵਿੱਚੋਂ, ਸਭ ਜ਼ਮੀਨ ਉੱਤੇ ਘਿੱਸਰਨ ਵਾਲਿਆਂ ਵਿੱਚੋਂ ");
INSERT INTO pan_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","ਦੋ-ਦੋ ਅਰਥਾਤ ਨਰ ਮਾਦਾ ਕਿਸ਼ਤੀ ਵਿੱਚ ਨੂਹ ਕੋਲ ਗਏ ਜਿਵੇਂ ਪਰਮੇਸ਼ੁਰ ਨੇ ਨੂਹ ਨੂੰ ਆਗਿਆ ਦਿੱਤੀ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","ਤਦ ਅਜਿਹਾ ਹੋਇਆ ਕਿ ਸੱਤ ਦਿਨਾਂ ਦੇ ਬਾਅਦ ਪਰਲੋ ਦਾ ਪਾਣੀ ਧਰਤੀ ਉੱਤੇ ਆਇਆ। ");
INSERT INTO pan_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","ਨੂਹ ਦੇ ਜੀਵਨ ਦੇ ਛੇ ਸੌਵੇਂ ਸਾਲ ਦੇ ਦੂਜੇ ਮਹੀਨੇ ਦੇ ਸਤਾਰਵੇਂ ਦਿਨ, ਵੱਡੀ ਡੁੰਘਿਆਈ ਦੇ ਸਾਰੇ ਸੋਤੇ ਫੁੱਟ ਨਿੱਕਲੇ ਅਤੇ ਅਕਾਸ਼ ਦੀਆਂ ਖਿੜਕੀਆਂ ਖੁੱਲ੍ਹ ਗਈਆਂ ");
INSERT INTO pan_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","ਅਤੇ ਧਰਤੀ ਉੱਤੇ ਚਾਲ੍ਹੀ ਦਿਨ ਅਤੇ ਚਾਲ੍ਹੀ ਰਾਤ ਵਰਖਾ ਹੁੰਦੀ ਰਹੀ। ");
INSERT INTO pan_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","ਉਸੇ ਦਿਨ ਨੂਹ, ਸ਼ੇਮ, ਹਾਮ, ਯਾਫ਼ਥ ਨੂਹ ਦੇ ਪੁੱਤਰ, ਨੂਹ ਦੀ ਪਤਨੀ ਅਤੇ ਉਹ ਦੀਆਂ ਤਿੰਨੇ ਨੂੰਹਾਂ ਉਹ ਦੇ ਨਾਲ ਕਿਸ਼ਤੀ ਵਿੱਚ ਦਾਖ਼ਿਲ ਹੋਏ। ");
INSERT INTO pan_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","ਹਰੇਕ ਜੰਗਲੀ ਜਾਨਵਰ, ਹਰੇਕ ਧਰਤੀ ਉੱਤੇ ਘਿੱਸਰਨ ਵਾਲਾ, ਹਰੇਕ ਕਿਸਮ ਦੇ ਪੰਛੀ ਉਸ ਕਿਸ਼ਤੀ ਦੇ ਵਿੱਚ ਦਾਖਿਲ ਹੋਏ। ");
INSERT INTO pan_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","ਜਿਨ੍ਹਾਂ ਦੇ ਵਿੱਚ ਜੀਵਨ ਦਾ ਸਾਹ ਸੀ, ਸਾਰੇ ਪ੍ਰਾਣੀ ਉਹਨਾਂ ਦੀਆਂ ਪ੍ਰਜਾਤੀਆਂ ਵਿੱਚੋਂ ਜੋੜਾ-ਜੋੜਾ ਕਿਸ਼ਤੀ ਵਿੱਚ ਨੂਹ ਕੋਲ ਆਏ। ");
INSERT INTO pan_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","ਨਰ-ਮਾਦਾ ਸਾਰੇ ਪ੍ਰਾਣੀਆਂ ਵਿੱਚੋਂ ਆਏ, ਜਿਵੇਂ ਪਰਮੇਸ਼ੁਰ ਨੇ ਆਗਿਆ ਦਿੱਤੀ ਸੀ। ਤਦ ਯਹੋਵਾਹ ਨੇ ਕਿਸ਼ਤੀ ਦਾ ਦਰਵਾਜ਼ਾ ਬੰਦ ਕਰ ਦਿੱਤਾ। ");
INSERT INTO pan_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","ਪਰਲੋ ਚਾਲ੍ਹੀ ਦਿਨ ਤੱਕ ਧਰਤੀ ਉੱਤੇ ਰਹੀ ਅਤੇ ਪਾਣੀ ਵੱਧ ਗਿਆ, ਜਿਸ ਕਾਰਨ ਕਿਸ਼ਤੀ ਪਾਣੀ ਉੱਪਰ ਚੁੱਕੀ ਗਈ ਅਤੇ ਉਹ ਧਰਤੀ ਉੱਤੋਂ ਉਤਾਹਾਂ ਹੋ ਗਈ। ");
INSERT INTO pan_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","ਫੇਰ ਪਾਣੀ ਹੀ ਪਾਣੀ ਹੋ ਗਿਆ ਅਤੇ ਉਹ ਧਰਤੀ ਉੱਤੇ ਬਹੁਤ ਹੀ ਵੱਧ ਗਿਆ, ਅਤੇ ਕਿਸ਼ਤੀ ਪਾਣੀ ਦੇ ਉੱਤੇ ਤਰਦੀ ਰਹੀ। ");
INSERT INTO pan_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","ਅਤੇ ਧਰਤੀ ਦੇ ਉੱਤੇ ਪਾਣੀ ਹੀ ਪਾਣੀ ਹੋ ਗਿਆ ਅਤੇ ਸਾਰੇ ਉੱਚੇ-ਉੱਚੇ ਪਰਬਤ ਜੋ ਸਾਰੇ ਅਕਾਸ਼ ਦੇ ਹੇਠ ਸਨ, ਢੱਕੇ ਗਏ। ");
INSERT INTO pan_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","ਪਾਣੀ ਉਨ੍ਹਾਂ ਤੋਂ ਪੰਦਰਾਂ ਹੱਥ ਹੋਰ ਉੱਚਾ ਹੋ ਗਿਆ, ਅਤੇ ਪਰਬਤ ਵੀ ਡੁੱਬ ਗਏ। ");
INSERT INTO pan_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","ਸਾਰੇ ਪ੍ਰਾਣੀ ਜਿਹੜੇ ਧਰਤੀ ਉੱਤੇ ਚਲਦੇ ਸਨ, ਕੀ ਪੰਛੀ, ਕੀ ਡੰਗਰ, ਸਾਰੇ ਜੰਗਲੀ ਜਾਨਵਰ ਅਤੇ ਸਾਰੇ ਜੀਵ-ਜੰਤੂ ਜਿਨ੍ਹਾਂ ਨਾਲ ਧਰਤੀ ਭਰੀ ਹੋਈ ਸੀ ਮਰ ਗਏ ਅਤੇ ਸਾਰੇ ਮਨੁੱਖ ਵੀ। ");
INSERT INTO pan_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","ਜਿਨ੍ਹਾਂ ਵਿੱਚ ਜੀਵਨ ਦਾ ਸਾਹ ਸੀ ਜਿਹੜੇ ਧਰਤੀ ਉੱਤੇ ਸਨ, ਉਹ ਸਾਰੇ ਮਰ ਗਏ। ");
INSERT INTO pan_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","ਹਰ ਪ੍ਰਾਣੀ ਜਿਹੜਾ ਜ਼ਮੀਨ ਦੇ ਉੱਤੇ ਸੀ, ਕੀ ਆਦਮੀ, ਕੀ ਡੰਗਰ, ਕੀ ਘਿੱਸਰਨ ਵਾਲਾ ਅਤੇ ਕੀ ਅਕਾਸ਼ ਦਾ ਪੰਛੀ ਸਭ ਮਿਟ ਗਏ। ਉਹ ਧਰਤੀ ਤੋਂ ਮਿਟ ਗਏ, ਪਰ ਨੂਹ ਅਤੇ ਜਿੰਨ੍ਹੇ ਉਸ ਦੇ ਨਾਲ ਕਿਸ਼ਤੀ ਵਿੱਚ ਸਨ, ਉਹ ਬਚ ਗਏ। ");
INSERT INTO pan_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","ਡੇਢ ਸੌ ਦਿਨਾਂ ਤੱਕ ਧਰਤੀ ਉੱਤੇ ਪਾਣੀ ਹੀ ਪਾਣੀ ਰਿਹਾ। ");
INSERT INTO pan_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","ਫੇਰ ਪਰਮੇਸ਼ੁਰ ਨੇ ਨੂਹ ਨੂੰ, ਹਰ ਜੰਗਲੀ ਜਾਨਵਰ ਨੂੰ, ਹਰ ਡੰਗਰ ਨੂੰ ਅਤੇ ਜੋ ਵੀ ਉਸ ਦੇ ਨਾਲ ਕਿਸ਼ਤੀ ਵਿੱਚ ਸਨ, ਯਾਦ ਕੀਤਾ। ਅਤੇ ਪਰਮੇਸ਼ੁਰ ਨੇ ਧਰਤੀ ਉੱਤੇ ਹਵਾ ਵਗਾਈ ਅਤੇ ਜਿਸ ਕਾਰਨ ਪਾਣੀ ਘਟਣ ਲੱਗ ਪਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","ਡੁੰਘਿਆਈ ਦੇ ਸੋਤੇ ਅਤੇ ਅਕਾਸ਼ ਦੀਆਂ ਖਿੜਕੀਆਂ ਬੰਦ ਹੋ ਗਈਆਂ ਅਤੇ ਵਰਖਾ ਰੁੱਕ ਗਈ। ");
INSERT INTO pan_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","ਪਾਣੀ ਧਰਤੀ ਉੱਤੋਂ ਡੇਢ ਸੌ ਦਿਨਾਂ ਤੋਂ ਬਾਅਦ ਘਟਣ ਲੱਗ ਪਿਆ ");
INSERT INTO pan_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","ਕਿਸ਼ਤੀ ਸੱਤਵੇਂ ਮਹੀਨੇ ਦੇ ਸਤਾਰਵੇਂ ਦਿਨ ਅਰਾਰਾਤ ਪਰਬਤ ਉੱਤੇ ਟਿੱਕ ਗਈ। ");
INSERT INTO pan_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","ਅਤੇ ਪਾਣੀ ਦਸਵੇਂ ਮਹੀਨੇ ਤੱਕ ਘਟਦੇ ਗਏ। ਦਸਵੇਂ ਮਹੀਨੇ ਦੇ ਪਹਿਲੇ ਦਿਨ ਪਹਾੜਾਂ ਦੀਆਂ ਟੀਸੀਆਂ ਦਿੱਸ ਪਈਆਂ। ");
INSERT INTO pan_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","ਫਿਰ ਅਜਿਹਾ ਹੋਇਆ ਕਿ ਚਾਲ੍ਹੀਆਂ ਦਿਨਾਂ ਦੇ ਬਾਅਦ ਨੂਹ ਨੇ ਕਿਸ਼ਤੀ ਦੀ ਖਿੜਕੀ ਨੂੰ ਖੋਲ੍ਹ ਦਿੱਤਾ। ");
INSERT INTO pan_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","ਉਸ ਨੇ ਇੱਕ ਪਹਾੜੀ ਕਾਂ ਛੱਡਿਆ ਅਤੇ ਜਦ ਤੱਕ ਪਾਣੀ ਧਰਤੀ ਤੋਂ ਨਾ ਸੁੱਕ ਗਏ, ਉਹ ਆਉਂਦਾ ਜਾਂਦਾ ਰਿਹਾ। ");
INSERT INTO pan_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","ਫੇਰ ਉਸ ਨੇ ਘੁੱਗੀ ਵੀ ਆਪਣੇ ਵੱਲੋਂ ਛੱਡੀ ਤਾਂ ਜੋ ਉਹ ਵੇਖੇ ਕਿ ਪਾਣੀ ਜ਼ਮੀਨ ਦੇ ਉੱਤੋਂ ਘੱਟ ਗਿਆ ਹੈ ਕਿ ਨਹੀਂ। ");
INSERT INTO pan_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","ਪਰ ਉਸ ਘੁੱਗੀ ਨੂੰ ਆਪਣੇ ਪੈਰ ਦੇ ਪੰਜੇ ਲਈ ਟਿਕਾਣਾ ਨਾ ਮਿਲਿਆ ਸੋ ਉਹ ਕਿਸ਼ਤੀ ਵਿੱਚ ਉਹ ਦੇ ਕੋਲ ਮੁੜ ਆਈ, ਕਿਉਂ ਜੋ ਪਾਣੀ ਸਾਰੀ ਧਰਤੀ ਉੱਤੇ ਸੀ ਤਾਂ ਉਸ ਨੇ ਆਪਣਾ ਹੱਥ ਵਧਾ ਕੇ ਉਹ ਨੂੰ ਫੜ ਲਿਆ ਅਤੇ ਆਪਣੇ ਕੋਲ ਕਿਸ਼ਤੀ ਵਿੱਚ ਰੱਖ ਲਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","ਤਦ ਉਹ ਨੇ ਸੱਤ ਦਿਨ ਬਾਅਦ ਫੇਰ ਕਿਸ਼ਤੀ ਤੋਂ ਉਸ ਘੁੱਗੀ ਨੂੰ ਛੱਡਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","ਉਹ ਘੁੱਗੀ ਸ਼ਾਮ ਨੂੰ ਉਹ ਦੇ ਕੋਲ ਆਈ ਅਤੇ ਵੇਖੋ ਉਹ ਦੀ ਚੁੰਝ ਵਿੱਚ ਜ਼ੈਤੂਨ ਦਾ ਸੱਜਰਾ ਪੱਤਾ ਸੀ, ਇਸ ਤੋਂ ਨੂਹ ਨੇ ਜਾਣ ਲਿਆ ਕਿ ਪਾਣੀ ਧਰਤੀ ਉੱਤੋਂ ਘੱਟ ਗਿਆ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","ਤਦ ਉਹ ਨੇ ਹੋਰ ਸੱਤ ਦਿਨ ਬਾਅਦ ਘੁੱਗੀ ਨੂੰ ਫਿਰ ਛੱਡਿਆ ਅਤੇ ਉਹ ਮੁੜ ਉਹ ਦੇ ਕੋਲ ਨਾ ਆਈ। ");
INSERT INTO pan_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","ਨੂਹ ਦੀ ਉਮਰ ਦੇ ਛੇ ਸੌ ਇੱਕ ਸਾਲ ਦੇ ਪਹਿਲੇ ਮਹੀਨੇ ਦੇ ਪਹਿਲੇ ਦਿਨ ਪਾਣੀ ਧਰਤੀ ਉੱਤੋਂ ਸੁੱਕ ਗਿਆ ਅਤੇ ਨੂਹ ਨੇ ਕਿਸ਼ਤੀ ਦੀ ਛੱਤ ਖੋਲ੍ਹ ਕੇ ਨਿਗਾਹ ਮਾਰੀ ਅਤੇ ਵੇਖੋ ਜ਼ਮੀਨ ਦੀ ਪਰਤ ਸੁੱਕ ਗਈ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","ਦੂਜੇ ਮਹੀਨੇ ਦੇ ਸਤਾਈਵੇਂ ਦਿਨ ਧਰਤੀ ਪੂਰੀ ਤਰ੍ਹਾਂ ਸੁੱਕ ਗਈ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","ਤਦ ਪਰਮੇਸ਼ੁਰ ਨੂਹ ਨਾਲ ਬੋਲਿਆ ");
INSERT INTO pan_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","ਕਿ ਤੂੰ ਕਿਸ਼ਤੀ ਵਿੱਚੋਂ ਨਿੱਕਲ ਜਾ, ਤੇਰੀ ਪਤਨੀ, ਤੇਰੇ ਪੁੱਤਰ ਅਤੇ ਤੇਰੀਆਂ ਨੂੰਹਾਂ ਵੀ। ");
INSERT INTO pan_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","ਹਰ ਇੱਕ ਜਾਨਵਰ ਨੂੰ ਜਿਹੜਾ ਤੇਰੇ ਕੋਲ ਸਾਰੇ ਪ੍ਰਾਣੀਆਂ ਵਿੱਚੋਂ ਹੈ ਅਰਥਾਤ ਪੰਛੀ, ਡੰਗਰ, ਧਰਤੀ ਉੱਤੇ ਘਿੱਸਰਨ ਵਾਲੇ ਨੂੰ ਤੂੰ ਆਪਣੇ ਨਾਲ ਬਾਹਰ ਲੈ ਜਾ ਤਾਂ ਜੋ ਓਹ ਧਰਤੀ ਉੱਤੇ ਉਹ ਆਪਣੀ ਪ੍ਰਜਾਤੀ ਨੂੰ ਵਧਾਉਣ, ਫਲਣ ਅਤੇ ਧਰਤੀ ਉੱਤੇ ਵਧਣ। ");
INSERT INTO pan_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","ਤਦ ਨੂਹ, ਉਹ ਦੇ ਪੁੱਤਰ, ਉਹ ਦੀ ਪਤਨੀ ਅਤੇ ਉਹ ਦੀਆਂ ਨੂੰਹਾਂ ਉਹ ਦੇ ਨਾਲ ਬਾਹਰ ਨਿੱਕਲ ਗਏ। ");
INSERT INTO pan_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","ਹਰੇਕ ਜਾਨਵਰ, ਹਰੇਕ ਘਿੱਸਰਨ ਵਾਲਾ, ਹਰੇਕ ਪੰਛੀ, ਅਤੇ ਹਰੇਕ ਧਰਤੀ ਉੱਤੇ ਚੱਲਣ ਵਾਲਾ ਆਪੋ-ਆਪਣੀ ਪ੍ਰਜਾਤੀ ਦੇ ਅਨੁਸਾਰ ਕਿਸ਼ਤੀ ਵਿੱਚੋਂ ਬਾਹਰ ਨਿੱਕਲ ਆਏ। ");
INSERT INTO pan_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","ਤਦ ਨੂਹ ਨੇ ਯਹੋਵਾਹ ਲਈ ਇੱਕ ਜਗਵੇਦੀ ਬਣਾਈ ਅਤੇ ਸ਼ੁੱਧ ਪਸ਼ੂਆਂ, ਸ਼ੁੱਧ ਪੰਛੀਆਂ ਵਿੱਚੋਂ ਲੈ ਕੇ ਉਸ ਨੇ ਜਗਵੇਦੀ ਉੱਤੇ ਹੋਮ ਬਲੀਆਂ ਚੜ੍ਹਾਈਆਂ। ");
INSERT INTO pan_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","ਯਹੋਵਾਹ ਨੇ ਉਸ ਸੁਖਦਾਇਕ ਸੁਗੰਧੀ ਨੂੰ ਲਿਆ ਅਤੇ ਆਪਣੇ ਮਨ ਵਿੱਚ ਆਖਿਆ, ਮੈਂ ਫੇਰ ਕਦੀ ਧਰਤੀ ਨੂੰ ਮਨੁੱਖ ਦੇ ਕਾਰਨ ਸਰਾਪ ਨਹੀਂ ਦਿਆਂਗਾ ਭਾਵੇਂ ਮਨੁੱਖ ਦੇ ਮਨ ਦੀ ਭਾਵਨਾ ਮੁੱਢੋਂ ਹੀ ਬੁਰੀ ਹੈ ਅਤੇ ਮੈਂ ਫੇਰ ਕਦੀ ਸਾਰੇ ਪ੍ਰਾਣੀਆਂ ਨੂੰ ਨਾਸ ਨਾ ਕਰਾਂਗਾ ਜਿਵੇਂ ਮੈਂ ਹੁਣ ਕੀਤਾ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","ਜਦੋਂ ਤੱਕ ਧਰਤੀ ਹੈ, ਉਦੋਂ ਤੱਕ ਬੀਜਣ ਅਤੇ ਵੱਢਣ, ਠੰਡ ਅਤੇ ਧੁੱਪ, ਹਾੜ੍ਹੀ ਅਤੇ ਸਾਉਣੀ ਅਤੇ ਦਿਨ ਰਾਤ ਨਹੀਂ ਮੁੱਕਣਗੇ। ");
INSERT INTO pan_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","ਪਰਮੇਸ਼ੁਰ ਨੇ ਨੂਹ ਅਤੇ ਉਹ ਦੇ ਪੁੱਤਰਾਂ ਨੂੰ ਇਹ ਆਖ ਕੇ ਅਸੀਸ ਦਿੱਤੀ, ਫਲੋ ਅਤੇ ਵਧੋ ਅਤੇ ਧਰਤੀ ਨੂੰ ਭਰ ਦਿਉ ");
INSERT INTO pan_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","ਤੁਹਾਡਾ ਡਰ ਅਤੇ ਭੈਅ ਧਰਤੀ ਦੇ ਹਰੇਕ ਜਾਨਵਰ, ਅਕਾਸ਼ ਦੇ ਹਰੇਕ ਪੰਛੀ, ਹਰੇਕ ਪ੍ਰਾਣੀ ਉੱਤੇ ਜਿਹੜਾ ਜ਼ਮੀਨ ਉੱਤੇ ਘਿੱਸਰਦਾ ਹੈ ਅਤੇ ਸਮੁੰਦਰ ਦੀਆਂ ਸਾਰੀਆਂ ਮੱਛੀਆਂ ਉੱਤੇ ਹੋਵੇਗਾ, ਕਿਉਂ ਜੋ ਉਹ ਤੁਹਾਡੇ ਵੱਸ ਵਿੱਚ ਕੀਤੇ ਗਏ ਹਨ। ");
INSERT INTO pan_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","ਹਰੇਕ ਚੱਲਣ ਵਾਲਾ ਪ੍ਰਾਣੀ ਜਿਸ ਦੇ ਵਿੱਚ ਜੀਵਨ ਹੈ, ਤੁਹਾਡੇ ਭੋਜਨ ਲਈ ਹੈ। ਜਿਵੇਂ ਮੈਂ ਤੁਹਾਨੂੰ ਸਾਗ ਪੱਤ ਦਿੱਤਾ ਸੀ, ਉਸੇ ਤਰ੍ਹਾਂ ਹੁਣ ਸਭ ਕੁਝ ਦਿੰਦਾ ਹਾਂ। ");
INSERT INTO pan_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","ਪਰ ਮਾਸ ਨੂੰ ਪ੍ਰਾਣ ਸਮੇਤ ਅਰਥਾਤ ਲਹੂ ਸਮੇਤ ਤੁਸੀਂ ਨਾ ਖਾਇਓ। ");
INSERT INTO pan_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","ਮੈਂ ਜ਼ਰੂਰ ਹੀ ਤੁਹਾਡੇ ਲਹੂ ਅਰਥਾਤ ਪ੍ਰਾਣ ਦਾ ਬਦਲਾ ਲਵਾਂਗਾ, ਹਰ ਇੱਕ ਜੰਗਲੀ ਜਾਨਵਰ ਅਤੇ ਮਨੁੱਖ ਦੋਵਾਂ ਤੋਂ ਉਸ ਦਾ ਬਦਲਾ ਲਵਾਂਗਾ ਅਤੇ ਹਰੇਕ ਮਨੁੱਖ ਦੀ ਜਾਨ ਦਾ ਬਦਲਾ ਮੈਂ ਉਸ ਦੇ ਭਰਾ ਤੋਂ ਲਵਾਂਗਾ। ");
INSERT INTO pan_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","ਜੋ ਮਨੁੱਖ ਦਾ ਲਹੂ ਵਹਾਵੇਗਾ, ਉਸ ਦਾ ਲਹੂ ਮਨੁੱਖ ਦੇ ਹੱਥੋਂ ਵਹਾਇਆ ਜਾਵੇਗਾ ਕਿਉਂਕਿ ਪਰਮੇਸ਼ੁਰ ਨੇ ਮਨੁੱਖ ਨੂੰ ਆਪਣੇ ਹੀ ਸਰੂਪ ਵਿੱਚ ਰਚਿਆ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","ਤੁਸੀਂ ਫਲੋ ਅਤੇ ਵਧੋ ਅਤੇ ਧਰਤੀ ਉੱਤੇ ਆਪਣੀ ਸੰਤਾਨ ਨੂੰ ਪੈਦਾ ਕਰਕੇ ਉਸ ਨੂੰ ਭਰ ਦਿਉ। ");
INSERT INTO pan_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","ਪਰਮੇਸ਼ੁਰ ਨੂਹ ਅਤੇ ਉਸ ਦੇ ਪੁੱਤਰਾਂ ਨਾਲ ਬੋਲਿਆ, ");
INSERT INTO pan_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","ਮੈਂ, ਵੇਖੋ, ਮੈਂ ਹੀ ਆਪਣਾ ਨੇਮ ਤੁਹਾਡੇ ਨਾਲ ਅਤੇ ਤੁਹਾਡੇ ਬਾਅਦ ਤੁਹਾਡੀ ਅੰਸ ਨਾਲ ਬੰਨ੍ਹਾਂਗਾ, ");
INSERT INTO pan_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","ਅਤੇ ਹਰੇਕ ਜੀਉਂਦੇ ਪ੍ਰਾਣੀ ਨਾਲ ਜੋ ਤੁਹਾਡੇ ਸੰਗ ਹੈ, ਅਰਥਾਤ ਹਰੇਕ ਪੰਛੀ, ਪਸ਼ੂ, ਧਰਤੀ ਦੇ ਹਰੇਕ ਜਾਨਵਰ, ਸਗੋਂ ਹਰ ਇੱਕ ਦੇ ਨਾਲ ਜਿਹੜਾ ਕਿਸ਼ਤੀ ਤੋਂ ਨਿੱਕਲਿਆ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","ਮੈਂ ਆਪਣਾ ਨੇਮ ਤੁਹਾਡੇ ਨਾਲ ਬੰਨ੍ਹਦਾ ਹਾਂ ਕਿ ਸਾਰੇ ਪ੍ਰਾਣੀਆਂ ਦਾ ਨਾਸ ਫੇਰ ਕਦੇ ਜਲ ਪਰਲੋ ਨਾਲ ਨਹੀਂ ਕੀਤਾ ਜਾਵੇਗਾ ਅਤੇ ਧਰਤੀ ਦਾ ਨਾਸ ਕਰਨ ਲਈ ਫੇਰ ਕਦੇ ਜਲ ਪਰਲੋ ਨਾ ਆਵੇਗੀ। ");
INSERT INTO pan_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","ਤਦ ਪਰਮੇਸ਼ੁਰ ਨੇ ਆਖਿਆ, ਇਹ ਉਸ ਨੇਮ ਦਾ ਨਿਸ਼ਾਨ ਹੈ ਜਿਹੜਾ ਮੈਂ ਆਪਣੇ ਅਤੇ ਤੁਹਾਡੇ ਅਤੇ ਹਰੇਕ ਜੀਵ-ਜੰਤੂ ਨਾਲ ਜੋ ਤੁਹਾਡੇ ਸੰਗ ਹੈ, ਪੀੜ੍ਹੀਓਂ ਪੀੜ੍ਹੀ ਸਦਾ ਲਈ ਦਿੰਦਾ ਹਾਂ। ");
INSERT INTO pan_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","ਮੈਂ ਬੱਦਲਾਂ ਵਿੱਚ ਆਪਣੀ ਸਤਰੰਗੀ ਪੀਂਘ ਰੱਖੀ ਹੈ। ਇਹ ਮੇਰੇ ਅਤੇ ਧਰਤੀ ਦੇ ਵਿਚਕਾਰ ਨੇਮ ਦੀ ਨਿਸ਼ਾਨੀ ਹੋਵੇਗੀ। ");
INSERT INTO pan_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","ਜਦੋਂ ਮੈਂ ਧਰਤੀ ਉੱਤੇ ਬੱਦਲਾਂ ਨੂੰ ਲਿਆਵਾਂਗਾ ਤਦ ਇਹ ਸਤਰੰਗੀ ਪੀਂਘ ਬੱਦਲਾਂ ਵਿੱਚ ਵਿਖਾਈ ਦੇਵੇਗੀ। ");
INSERT INTO pan_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","ਅਤੇ ਮੈਂ ਆਪਣੇ ਨੇਮ ਨੂੰ ਜੋ ਮੇਰੇ ਅਤੇ ਤੁਹਾਡੇ ਵਿਚਕਾਰ ਅਤੇ ਸਾਰੇ ਜੀਉਂਦੇ ਪ੍ਰਾਣੀਆਂ ਦੇ ਨਾਲ ਹੈ, ਯਾਦ ਕਰਾਂਗਾ ਅਤੇ ਅਜਿਹੀ ਜਲ ਪਰਲੋ ਫੇਰ ਕਦੇ ਨਾ ਹੋਵੇਗੀ ਜਿਹੜੀ ਸਾਰੇ ਪ੍ਰਾਣੀਆਂ ਦਾ ਨਾਸ ਕਰੇ। ");
INSERT INTO pan_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","ਬੱਦਲ ਵਿੱਚ ਇਸ ਸਤਰੰਗੀ ਪੀਂਘ ਨੂੰ ਵੇਖ ਕੇ ਮੈਂ ਉਸ ਸਦੀਪਕ ਨੇਮ ਨੂੰ ਯਾਦ ਕਰਾਂਗਾ ਜਿਹੜਾ ਮੇਰੇ ਅਤੇ ਧਰਤੀ ਦੇ ਸਾਰੇ ਜੀਉਂਦੇ ਪ੍ਰਾਣੀਆਂ ਦੇ ਨਾਲ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","ਫਿਰ ਪਰਮੇਸ਼ੁਰ ਨੇ ਨੂਹ ਨੂੰ ਕਿਹਾ, ਇਹ ਉਸ ਨੇਮ ਦਾ ਨਿਸ਼ਾਨ ਹੈ ਜੋ ਮੈਂ ਆਪਣੇ ਅਤੇ ਧਰਤੀ ਦੇ ਸਾਰੇ ਪ੍ਰਾਣੀਆਂ ਦੇ ਵਿਚਕਾਰ ਠਹਿਰਾਇਆ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","ਨੂਹ ਦੇ ਪੁੱਤਰ ਜਿਹੜੇ ਕਿਸ਼ਤੀ ਵਿੱਚੋਂ ਨਿੱਕਲੇ ਉਹ ਸ਼ੇਮ, ਹਾਮ ਅਤੇ ਯਾਫ਼ਥ ਸਨ ਅਤੇ ਹਾਮ ਕਨਾਨ ਦਾ ਪਿਤਾ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","ਇਹ ਨੂਹ ਦੇ ਤਿੰਨ ਪੁੱਤਰ ਸਨ ਅਤੇ ਇਨ੍ਹਾਂ ਤੋਂ ਹੀ ਸਾਰੀ ਧਰਤੀ ਆਬਾਦ ਹੋਈ। ");
INSERT INTO pan_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","ਨੂਹ ਖੇਤੀ ਕਰਨ ਲੱਗਾ ਅਤੇ ਉਸ ਨੇ ਅੰਗੂਰ ਦਾ ਬਾਗ਼ ਲਾਇਆ। ");
INSERT INTO pan_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","ਉਸ ਨੇ ਮਧ ਪੀਤੀ ਅਤੇ ਮਤਵਾਲਾ ਹੋ ਗਿਆ, ਅਤੇ ਤੰਬੂ ਦੇ ਵਿੱਚ ਨੰਗਾ ਪੈ ਗਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","ਤਦ ਕਨਾਨ ਦੇ ਪਿਤਾ ਹਾਮ ਨੇ ਆਪਣੇ ਪਿਤਾ ਦਾ ਨੰਗੇਜ਼ ਵੇਖਿਆ ਅਤੇ ਉਸ ਨੇ ਆਪਣੇ ਦੋਹਾਂ ਭਰਾਵਾਂ ਨੂੰ ਜੋ ਬਾਹਰ ਸਨ, ਜਾ ਕੇ ਦੱਸਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","ਤਦ ਸ਼ੇਮ ਅਤੇ ਯਾਫ਼ਥ ਨੇ ਕੱਪੜਾ ਲੈ ਕੇ ਆਪਣੇ ਦੋਹਾਂ ਮੋਢਿਆਂ ਤੇ ਰੱਖਿਆ ਅਤੇ ਪੁੱਠੇ ਪੈਰੀਂ ਜਾ ਕੇ ਆਪਣੇ ਪਿਤਾ ਦਾ ਨੰਗੇਜ਼ ਢੱਕਿਆ। ਉਨ੍ਹਾਂ ਦੇ ਮੂੰਹ ਪਿਛਲੇ ਪਾਸੇ ਨੂੰ ਸਨ, ਇਸ ਲਈ ਉਨ੍ਹਾਂ ਨੇ ਆਪਣੇ ਪਿਤਾ ਦੇ ਨੰਗੇਜ਼ ਨੂੰ ਨਾ ਵੇਖਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","ਜਦ ਨੂਹ ਦਾ ਨਸ਼ਾ ਉਤਰ ਗਿਆ ਤਾਂ ਉਸ ਨੂੰ ਪਤਾ ਲੱਗਿਆ ਕਿ ਉਸ ਦੇ ਛੋਟੇ ਪੁੱਤਰ ਨੇ ਉਸ ਦੇ ਨਾਲ ਕੀ ਕੀਤਾ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","ਤਦ ਉਸ ਨੇ ਆਖਿਆ, ਕਨਾਨ ਸਰਾਪੀ ਹੈ। ਉਹ ਆਪਣੇ ਭਰਾਵਾਂ ਦੇ ਦਾਸਾਂ ਦਾ ਦਾਸ ਹੋਵੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","ਉਸ ਨੇ ਇਹ ਵੀ ਆਖਿਆ, ਸ਼ੇਮ ਦਾ ਪਰਮੇਸ਼ੁਰ ਯਹੋਵਾਹ ਧੰਨ ਹੋਵੇ ਅਤੇ ਕਨਾਨ ਸ਼ੇਮ ਦਾ ਦਾਸ ਹੋਵੇ। ");
INSERT INTO pan_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","ਪਰਮੇਸ਼ੁਰ ਯਾਫ਼ਥ ਦੀ ਪੀੜ੍ਹੀ ਨੂੰ ਵਧਾਵੇ, ਉਹ ਸ਼ੇਮ ਦੇ ਤੰਬੂਆਂ ਵਿੱਚ ਵੱਸੇ ਅਤੇ ਕਨਾਨ ਉਸ ਦਾ ਦਾਸ ਹੋਵੇ। ");
INSERT INTO pan_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","ਪਰਲੋ ਤੋਂ ਬਾਅਦ ਨੂਹ ਤਿੰਨ ਸੌ ਪੰਜਾਹ ਸਾਲਾਂ ਤੱਕ ਜੀਉਂਦਾ ਰਿਹਾ ");
INSERT INTO pan_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","ਅਤੇ ਨੂਹ ਦੀ ਸਾਰੀ ਉਮਰ ਨੌ ਸੌ ਪੰਜਾਹ ਸਾਲ ਹੋਈ, ਤਦ ਉਹ ਮਰ ਗਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","ਨੂਹ ਦੇ ਪੁੱਤਰ ਸ਼ੇਮ, ਹਾਮ ਅਤੇ ਯਾਫ਼ਥ ਸਨ। ਉਨ੍ਹਾਂ ਦੇ ਪੁੱਤਰ ਜੋ ਜਲ ਪਰਲੋ ਦੇ ਬਾਅਦ ਪੈਦਾ ਹੋਏ - ਉਨ੍ਹਾਂ ਦੀਆਂ ਵੰਸ਼ਾਵਲੀਆਂ ਇਹ ਹਨ। ");
INSERT INTO pan_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","ਯਾਫ਼ਥ ਦੇ ਪੁੱਤਰ: ਗੋਮਰ, ਮਾਗੋਗ, ਮਾਦਈ, ਯਾਵਾਨ, ਤੂਬਲ, ਮੇਸ਼ੇਕ ਅਤੇ ਤੀਰਾਸ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","ਗੋਮਰ ਦੇ ਪੁੱਤਰ: ਅਸ਼ਕਨਜ਼, ਰੀਫ਼ਥ ਅਤੇ ਤੋਗਰਮਾਹ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","ਯਾਵਾਨ ਦੇ ਪੁੱਤਰ ਅਲੀਸ਼ਾਹ, ਤਰਸ਼ੀਸ਼, ਕਿੱਤੀਮ ਅਤੇ ਦੋਦਾਨੀਮ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","ਇਨ੍ਹਾਂ ਦੇ ਘਰਾਣੇ ਪਰਾਈਆਂ ਕੌਮਾਂ ਦੇ ਟਾਪੂਆਂ ਦੇ ਦੇਸਾਂ ਵਿੱਚ ਅਜਿਹੇ ਵੰਡੇ ਗਏ ਕਿ ਉਹ ਵੱਖ-ਵੱਖ ਭਾਸ਼ਾਵਾਂ, ਟੱਬਰਾਂ ਅਤੇ ਕੌਮਾਂ ਦੇ ਅਨੁਸਾਰ ਅਲੱਗ ਹੋ ਗਏ। ");
INSERT INTO pan_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","ਹਾਮ ਦੇ ਪੁੱਤਰ: ਕੂਸ਼, ਮਿਸਰਾਇਮ, ਪੂਟ ਅਤੇ ਕਨਾਨ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","ਕੂਸ਼ ਦੇ ਪੁੱਤਰ ਸਬਾ, ਹਵੀਲਾਹ, ਸਬਤਾਹ, ਰਾਮਾਹ ਅਤੇ ਸਬਤਕਾ ਸਨ ਅਤੇ ਰਾਮਾਹ ਦੇ ਪੁੱਤਰ ਸ਼ਬਾ ਅਤੇ ਦਦਾਨ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","ਕੂਸ਼ ਤੋਂ ਨਿਮਰੋਦ ਜੰਮਿਆ। ਧਰਤੀ ਉੱਤੇ ਸਭ ਤੋਂ ਪਹਿਲਾ ਸੂਰਬੀਰ ਉਹ ਹੀ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","ਉਹ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਇੱਕ ਬਲਵੰਤ ਸ਼ਿਕਾਰੀ ਸੀ। ਇਸ ਲਈ ਕਿਹਾ ਜਾਂਦਾ ਹੈ, ਨਿਮਰੋਦ ਵਰਗਾ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਬਲਵੰਤ ਸ਼ਿਕਾਰੀ। ");
INSERT INTO pan_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","ਉਸ ਦੇ ਰਾਜ ਦਾ ਅਰੰਭ ਸ਼ਿਨਾਰ ਦੇ ਦੇਸ਼ ਵਿੱਚ ਬਾਬਲ, ਅਰਕ, ਅਕੱਦ, ਕਲਨੇਹ ਤੋਂ ਹੋਇਆ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","ਉਸ ਦੇਸ਼ ਤੋਂ ਨਿੱਕਲ ਕੇ ਉਹ ਅੱਸ਼ੂਰ ਨੂੰ ਗਿਆ ਅਤੇ ਨੀਨਵਾਹ, ਰਹੋਬੋਥ-ਈਰ ਅਤੇ ਕਾਲਹ, ");
INSERT INTO pan_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","ਅਤੇ ਨੀਨਵਾਹ ਅਤੇ ਕਾਲਹ ਦੇ ਵਿਚਕਾਰ ਰਸਨ ਨੂੰ ਜਿਹੜਾ ਵੱਡਾ ਸ਼ਹਿਰ ਹੈ, ਬਣਾਇਆ। ");
INSERT INTO pan_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","ਮਿਸਰਾਇਮ ਲੂਦੀ, ਅਨਾਮੀ, ਲਹਾਬੀ, ਨਫ਼ਤੂਹੀ ");
INSERT INTO pan_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","ਅਤੇ ਪਤਰੂਸੀ, ਕੁਸਲੂਹੀ ਅਤੇ ਕਫ਼ਤੋਰੀ ਦਾ ਪਿਤਾ ਹੋਇਆ। (ਕੁਸਲੂਹੀ ਤੋਂ ਫ਼ਲਿਸਤੀ ਲੋਕ ਨਿੱਕਲੇ) ");
INSERT INTO pan_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","ਕਨਾਨ ਦੇ ਵੰਸ਼ ਵਿੱਚ ਸੀਦੋਨ ਉਸ ਦਾ ਪਹਿਲੌਠਾ ਪੁੱਤਰ ਸੀ, ਤਦ ਹੇਤ, ");
INSERT INTO pan_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","ਯਬੂਸੀ, ਅਮੋਰੀ, ਗਿਰਗਾਸ਼ੀ, ");
INSERT INTO pan_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","ਹਿੱਵੀ, ਅਰਕੀ, ਸੀਨੀ, ");
INSERT INTO pan_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","ਅਰਵਾਦੀ, ਸਮਾਰੀ ਅਤੇ ਹਮਾਥੀ ਲੋਕ ਹੋਏ ਅਤੇ ਇਸ ਤੋਂ ਬਾਅਦ ਕਨਾਨੀਆਂ ਦੇ ਘਰਾਣੇ ਵੀ ਫੈਲ ਗਏ। ");
INSERT INTO pan_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","ਕਨਾਨੀਆਂ ਦੀ ਹੱਦ ਸੀਦੋਨ ਤੋਂ ਗਰਾਰ ਨੂੰ ਜਾਂਦੇ ਹੋਏ ਅੱਜ਼ਾਹ ਤੱਕ ਸੀ ਅਤੇ ਸਦੂਮ, ਅਮੂਰਾਹ, ਅਦਮਾਹ, ਸਬੋਈਮ ਨੂੰ ਜਾਂਦੇ ਹੋਏ ਲਾਸ਼ਾ ਤੱਕ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","ਹਾਮ ਦੇ ਘਰਾਣੇ ਵਿੱਚ ਇਹ ਹੀ ਹੋਏ, ਅਤੇ ਇਹ ਵੱਖ-ਵੱਖ ਟੱਬਰਾਂ, ਭਾਸ਼ਾਵਾਂ, ਦੇਸਾਂ ਅਤੇ ਕੌਮਾਂ ਦੇ ਅਨੁਸਾਰ ਅਲੱਗ ਹੋ ਗਏ। ");
INSERT INTO pan_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","ਸ਼ੇਮ, ਜੋ ਸਾਰੇ ਏਬਰ ਦੇ ਵੰਸ਼ ਦਾ ਪੁਰਖਾ ਸੀ ਅਤੇ ਜੋ ਯਾਫ਼ਥ ਦਾ ਵੱਡਾ ਭਰਾ ਸੀ, ਉਸ ਦੇ ਵੀ ਪੁੱਤਰ ਜੰਮੇ। ");
INSERT INTO pan_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","ਸ਼ੇਮ ਦੇ ਪੁੱਤਰ: ਏਲਾਮ, ਅੱਸ਼ੂਰ, ਅਰਪਕਸਦ, ਲੂਦ ਅਤੇ ਅਰਾਮ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","ਅਰਾਮ ਦੇ ਪੁੱਤਰ: ਊਸ, ਹੂਲ, ਗਥਰ ਅਤੇ ਮੇਸ਼ੇਕ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","ਅਰਪਕਸਦ ਤੋਂ ਸ਼ਾਲਹ, ਸ਼ਾਲਹ ਤੋਂ ਏਬਰ ਜੰਮੇ। ");
INSERT INTO pan_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","ਏਬਰ ਦੇ ਦੋ ਪੁੱਤਰ ਜੰਮੇ, ਇੱਕ ਦਾ ਨਾਮ ਪੇਲੇਗ ਸੀ, ਕਿਉਂਕਿ ਉਹ ਦੇ ਦਿਨਾਂ ਵਿੱਚ ਧਰਤੀ ਵੰਡੀ ਗਈ ਅਤੇ ਉਹ ਦੇ ਭਰਾ ਦਾ ਨਾਮ ਯਾਕਤਾਨ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","ਯਾਕਤਾਨ ਤੋਂ ਅਲਮੋਦਾਦ, ਸ਼ਾਲਫ, ਹਸਰਮਾਵਥ, ਯਾਰਹ, ");
INSERT INTO pan_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","ਹਦੋਰਾਮ, ਊਜ਼ਾਲ, ਦਿਕਲਾਹ, ");
INSERT INTO pan_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","ਓਬਾਲ, ਅਬੀਮਾਏਲ, ਸ਼ਬਾ, ");
INSERT INTO pan_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","ਓਫੀਰ, ਹਵੀਲਾਹ ਅਤੇ ਯੋਬਾਬ ਜੰਮੇ। ਇਹ ਸਾਰੇ ਯਾਕਤਾਨ ਦੇ ਪੁੱਤਰ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","ਉਨ੍ਹਾਂ ਦਾ ਵਾਸ ਮੇਸ਼ਾ ਤੋਂ ਜਾਂਦੇ ਹੋਏ ਸਫ਼ਾਰ ਤੱਕ ਹੈ, ਜੋ ਪੂਰਬ ਦਾ ਇੱਕ ਪਰਬਤ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","ਇਹ ਸ਼ੇਮ ਦੇ ਪੁੱਤਰ ਹਨ, ਅਤੇ ਉਹ ਵੱਖ-ਵੱਖ ਟੱਬਰਾਂ, ਭਾਸ਼ਾਵਾਂ, ਦੇਸਾਂ ਅਤੇ ਕੌਮਾਂ ਦੇ ਅਨੁਸਾਰ ਅਲੱਗ ਹੋ ਗਏ। ");
INSERT INTO pan_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","ਨੂਹ ਦੇ ਪੁੱਤਰਾਂ ਦੇ ਘਰਾਣੇ ਇਹ ਹੀ ਹਨ: ਉਨ੍ਹਾਂ ਦੀਆਂ ਕੌਮਾਂ ਦੇ ਅਨੁਸਾਰ ਉਨ੍ਹਾਂ ਦੀਆਂ ਵੰਸ਼ਾਵਲੀਆਂ ਇਹ ਹੀ ਹਨ। ਜਲ ਪਰਲੋ ਤੋਂ ਬਾਅਦ ਧਰਤੀ ਉੱਤੇ ਸਾਰੀਆਂ ਕੌਮਾਂ ਇਨ੍ਹਾਂ ਵਿੱਚੋਂ ਹੀ ਫੈਲ ਗਈਆਂ। ");
INSERT INTO pan_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","ਸਾਰੀ ਧਰਤੀ ਉੱਤੇ ਇੱਕੋ ਹੀ ਬੋਲੀ ਅਤੇ ਇੱਕੋ ਹੀ ਭਾਸ਼ਾ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","ਉਸ ਵੇਲੇ ਲੋਕਾਂ ਨੂੰ ਪੂਰਬ ਵੱਲ ਜਾਂਦੇ ਹੋਏ, ਇੱਕ ਮੈਦਾਨ ਸ਼ਿਨਾਰ ਦੇਸ਼ ਵਿੱਚ ਲੱਭਿਆ ਅਤੇ ਉੱਥੇ ਉਹ ਵੱਸ ਗਏ। ");
INSERT INTO pan_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","ਤਦ ਉਨ੍ਹਾਂ ਨੇ ਇੱਕ ਦੂਜੇ ਨੂੰ ਆਖਿਆ ਕਿ ਆਓ ਅਸੀਂ ਇੱਟਾਂ ਬਣਾਈਏ ਅਤੇ ਉਨ੍ਹਾਂ ਨੂੰ ਚੰਗੀ ਤਰ੍ਹਾਂ ਪਕਾਈਏ, ਉਨ੍ਹਾਂ ਕੋਲ ਪੱਥਰਾਂ ਦੀ ਥਾਂ ਇੱਟਾਂ ਅਤੇ ਚੂਨੇ ਦੀ ਥਾਂ ਗਾਰਾ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","ਫਿਰ ਉਨ੍ਹਾਂ ਨੇ ਆਖਿਆ ਕਿ ਆਉ ਅਸੀਂ ਆਪਣੇ ਲਈ ਇੱਕ ਸ਼ਹਿਰ ਅਤੇ ਇੱਕ ਬੁਰਜ ਬਣਾਈਏ ਜਿਸ ਦੀ ਚੋਟੀ ਅਕਾਸ਼ ਤੱਕ ਹੋਵੇ ਅਤੇ ਅਜਿਹਾ ਕਰਕੇ ਅਸੀਂ ਨਾਮ ਕਮਾਈਏ ਅਜਿਹਾ ਨਾ ਹੋਵੇ ਜੋ ਅਸੀਂ ਸਾਰੀ ਧਰਤੀ ਉੱਤੇ ਖਿੰਡ ਜਾਈਏ। ");
INSERT INTO pan_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","ਜਦ ਲੋਕ ਉਸ ਸ਼ਹਿਰ ਅਤੇ ਬੁਰਜ ਨੂੰ ਬਣਾ ਰਹੇ ਸਨ ਤਦ ਯਹੋਵਾਹ ਉਸ ਨੂੰ ਵੇਖਣ ਲਈ ਉਤਰਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","ਯਹੋਵਾਹ ਨੇ ਆਖਿਆ, ਵੇਖੋ, ਇਹ ਲੋਕ ਇੱਕ ਹਨ, ਇਹਨਾਂ ਸਾਰਿਆਂ ਦੀ ਬੋਲੀ ਵੀ ਇੱਕ ਹੈ ਅਤੇ ਇਹਨਾਂ ਨੇ ਇਸ ਕੰਮ ਨੂੰ ਅਰੰਭ ਕੀਤਾ ਹੈ, ਜੋ ਕੁਝ ਵੀ ਉਹ ਕਰਨ ਦਾ ਯਤਨ ਕਰਨਗੇ ਹੁਣ ਉਨ੍ਹਾਂ ਲਈ ਕੁਝ ਵੀ ਰੁਕਾਵਟ ਨਾ ਹੋਵੇਗੀ। ");
INSERT INTO pan_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","ਇਸ ਲਈ ਆਓ ਅਸੀਂ ਉਤਰੀਏ, ਉਨ੍ਹਾਂ ਦੀ ਭਾਸ਼ਾ ਨੂੰ ਉਲਟ-ਪੁਲਟ ਕਰ ਦੇਈਏ ਤਾਂ ਜੋ ਉਹ ਇੱਕ ਦੂਜੇ ਦੀ ਭਾਸ਼ਾ ਨਾ ਸਮਝ ਸਕਣ। ");
INSERT INTO pan_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","ਇਸ ਤਰ੍ਹਾਂ ਯਹੋਵਾਹ ਨੇ ਉਨ੍ਹਾਂ ਨੂੰ ਉੱਥੋਂ ਸਾਰੀ ਧਰਤੀ ਉੱਤੇ ਖਿੰਡਾ ਦਿੱਤਾ। ਇਸ ਲਈ ਉਹਨਾਂ ਨੇ ਉਸ ਸ਼ਹਿਰ ਦਾ ਨਿਰਮਾਣ ਕਰਨਾ ਬੰਦ ਕਰ ਦਿੱਤਾ। ");
INSERT INTO pan_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","ਇਸ ਕਾਰਨ ਉਨ੍ਹਾਂ ਨੇ ਉਸ ਨਗਰ ਦਾ ਨਾਮ ਬਾਬਲ ਰੱਖਿਆ ਕਿਉਂਕਿ ਉੱਥੇ ਯਹੋਵਾਹ ਨੇ ਸਾਰੀ ਧਰਤੀ ਦੀ ਭਾਸ਼ਾ ਉਲਟ-ਪੁਲਟ ਕਰ ਦਿੱਤੀ ਅਤੇ ਉੱਥੋਂ ਯਹੋਵਾਹ ਨੇ ਉਨ੍ਹਾਂ ਨੂੰ ਸਾਰੀ ਧਰਤੀ ਉੱਤੇ ਖਿੰਡਾ ਦਿੱਤਾ। ");
INSERT INTO pan_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","ਇਹ ਸ਼ੇਮ ਦੀ ਵੰਸ਼ਾਵਲੀ ਹੈ। ਸ਼ੇਮ ਸੌ ਸਾਲ ਦਾ ਸੀ ਅਤੇ ਜਲ ਪਰਲੋ ਤੋਂ ਦੋ ਸਾਲ ਬਾਅਦ ਉਸ ਤੋਂ ਅਰਪਕਸਦ ਜੰਮਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","ਅਰਪਕਸਦ ਦੇ ਜਨਮ ਤੋਂ ਬਾਅਦ, ਸ਼ੇਮ ਪੰਜ ਸੌ ਸਾਲਾਂ ਤੱਕ ਜੀਉਂਦਾ ਰਿਹਾ ਅਤੇ ਉਸ ਤੋਂ ਹੋਰ ਵੀ ਪੁੱਤਰ ਧੀਆਂ ਜੰਮੇ। ");
INSERT INTO pan_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","ਜਦ ਅਰਪਕਸਦ ਪੈਂਤੀਆਂ ਸਾਲਾਂ ਦਾ ਹੋਇਆ ਤਾਂ ਉਸ ਤੋਂ ਸ਼ਾਲਹ ਜੰਮਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","ਅਤੇ ਅਰਪਕਸਦ ਸ਼ਾਲਹ ਦੇ ਜਨਮ ਤੋਂ ਬਾਅਦ ਚਾਰ ਸੌ ਤਿੰਨ ਸਾਲ ਤੱਕ ਜੀਉਂਦਾ ਰਿਹਾ ਅਤੇ ਉਸ ਤੋਂ ਹੋਰ ਵੀ ਪੁੱਤਰ ਧੀਆਂ ਜੰਮੇ। ");
INSERT INTO pan_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","ਜਦ ਸ਼ਾਲਹ ਤੀਹ ਸਾਲ ਦਾ ਹੋਇਆ ਤਾਂ ਉਸ ਤੋਂ ਏਬਰ ਜੰਮਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","ਸ਼ਾਲਹ ਏਬਰ ਦੇ ਜਨਮ ਤੋਂ ਬਾਅਦ ਚਾਰ ਸੌ ਤਿੰਨ ਸਾਲ ਤੱਕ ਜੀਉਂਦਾ ਰਿਹਾ ਅਤੇ ਉਸ ਤੋਂ ਹੋਰ ਵੀ ਪੁੱਤਰ ਧੀਆਂ ਜੰਮੇ। ");
INSERT INTO pan_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","ਅਤੇ ਏਬਰ ਚੌਂਤੀ ਸਾਲ ਦਾ ਹੋਇਆ ਤਾਂ ਉਸ ਤੋਂ ਪੇਲੇਗ ਜੰਮਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","ਏਬਰ ਪੇਲੇਗ ਦੇ ਜਨਮ ਤੋਂ ਬਾਅਦ ਚਾਰ ਸੌ ਤੀਹ ਸਾਲ ਤੱਕ ਜੀਉਂਦਾ ਰਿਹਾ ਅਤੇ ਉਸ ਤੋਂ ਹੋਰ ਵੀ ਪੁੱਤਰ ਧੀਆਂ ਜੰਮੇ। ");
INSERT INTO pan_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","ਜਦ ਪੇਲੇਗ ਤੀਹ ਸਾਲ ਦਾ ਹੋਇਆ ਤਾਂ ਉਸ ਤੋਂ ਰਊ ਜੰਮਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","ਪੇਲੇਗ ਰਊ ਦੇ ਜਨਮ ਤੋਂ ਬਾਅਦ ਦੋ ਸੌ ਨੌ ਸਾਲ ਤੱਕ ਜੀਉਂਦਾ ਰਿਹਾ ਅਤੇ ਉਸ ਤੋਂ ਹੋਰ ਵੀ ਪੁੱਤਰ ਧੀਆਂ ਜੰਮੇ। ");
INSERT INTO pan_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","ਰਊ ਬੱਤੀ ਸਾਲ ਦਾ ਹੋਇਆ ਤਾਂ ਉਸ ਤੋਂ ਸਰੂਗ ਜੰਮਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","ਰਊ ਸਰੂਗ ਦੇ ਜਨਮ ਤੋਂ ਬਾਅਦ ਦੋ ਸੌ ਸੱਤ ਸਾਲ ਤੱਕ ਜੀਉਂਦਾ ਰਿਹਾ ਅਤੇ ਉਸ ਤੋਂ ਹੋਰ ਵੀ ਪੁੱਤਰ ਧੀਆਂ ਜੰਮੇ। ");
INSERT INTO pan_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","ਜਦ ਸਰੂਗ ਤੀਹ ਸਾਲ ਦਾ ਹੋਇਆ ਤਾਂ ਉਸ ਤੋਂ ਨਾਹੋਰ ਜੰਮਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","ਸਰੂਗ ਨਾਹੋਰ ਦੇ ਜਨਮ ਤੋਂ ਬਾਅਦ ਦੋ ਸੌ ਸਾਲ ਤੱਕ ਜੀਉਂਦਾ ਰਿਹਾ ਅਤੇ ਉਸ ਤੋਂ ਹੋਰ ਵੀ ਪੁੱਤਰ ਧੀਆਂ ਜੰਮੇ। ");
INSERT INTO pan_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","ਜਦ ਨਾਹੋਰ ਉਨੱਤੀ ਸਾਲ ਦਾ ਹੋਇਆ ਤਾਂ ਉਸ ਤੋਂ ਤਾਰਹ ਜੰਮਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","ਨਾਹੋਰ ਤਾਰਹ ਦੇ ਜਨਮ ਤੋਂ ਬਾਅਦ ਇੱਕ ਸੌ ਉੱਨੀ ਸਾਲ ਤੱਕ ਜੀਉਂਦਾ ਰਿਹਾ ਅਤੇ ਉਸ ਤੋਂ ਹੋਰ ਵੀ ਪੁੱਤਰ ਧੀਆਂ ਜੰਮੇ। ");
INSERT INTO pan_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","ਤਾਰਹ ਸੱਤਰ ਸਾਲ ਦਾ ਹੋਇਆ ਤਾਂ ਉਸ ਤੋਂ ਅਬਰਾਮ, ਨਾਹੋਰ ਅਤੇ ਹਾਰਾਨ ਜੰਮੇ। ");
INSERT INTO pan_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","ਇਹ ਤਾਰਹ ਦੀ ਵੰਸ਼ਾਵਲੀ ਹੈ। ਤਾਰਹ ਤੋਂ ਅਬਰਾਮ, ਨਾਹੋਰ ਅਤੇ ਹਾਰਾਨ ਜੰਮੇ ਅਤੇ ਹਾਰਾਨ ਤੋਂ ਲੂਤ ਜੰਮਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","ਹਾਰਾਨ ਆਪਣੀ ਜਨਮ ਭੂਮੀ ਅਰਥਾਤ ਕਸਦੀਆਂ ਦੇ ਊਰ ਨਗਰ ਵਿੱਚ ਮਰ ਗਿਆ ਜਦ ਕਿ ਉਸਦਾ ਪਿਤਾ ਤਾਰਹ ਅਜੇ ਜਿਉਂਦਾ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","ਅਬਰਾਮ ਅਤੇ ਨਾਹੋਰ ਦੋਵਾਂ ਨੇ ਵਿਆਹ ਕਰ ਲਿਆ। ਅਬਰਾਮ ਦੀ ਪਤਨੀ ਦਾ ਨਾਮ ਸਾਰਈ ਸੀ ਅਤੇ ਨਾਹੋਰ ਦੀ ਪਤਨੀ ਦਾ ਨਾਮ ਮਿਲਕਾਹ ਸੀ, ਜਿਹੜੀ ਹਾਰਾਨ ਦੀ ਧੀ ਸੀ ਜੋ ਮਿਲਕਾਹ ਅਤੇ ਯਿਸਕਾਹ ਦਾ ਪਿਤਾ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","ਪਰ ਸਾਰਈ ਬਾਂਝ ਸੀ, ਉਸ ਦੇ ਕੋਈ ਬੱਚਾ ਨਹੀਂ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","ਤਾਰਹ ਆਪਣੇ ਪੁੱਤਰ ਅਬਰਾਮ ਤੇ ਆਪਣੇ ਪੋਤੇ ਲੂਤ, ਜੋ ਹਾਰਾਨ ਦਾ ਪੁੱਤਰ ਸੀ, ਆਪਣੀ ਨੂੰਹ ਸਾਰਈ, ਜੋ ਅਬਰਾਮ ਦੀ ਪਤਨੀ ਸੀ, ਇਹਨਾਂ ਸਾਰਿਆਂ ਨੂੰ ਲੈ ਕੇ ਕਸਦੀਆਂ ਦੇ ਊਰ ਨਗਰ ਤੋਂ ਨਿੱਕਲ ਕੇ ਕਨਾਨ ਦੇਸ਼ ਨੂੰ ਜਾਣ ਲਈ ਨਿੱਕਲਿਆ; ਪਰ ਓਹ ਹਾਰਾਨ ਵਿੱਚ ਆ ਕੇ ਉੱਥੇ ਵੱਸ ਗਏ। ");
INSERT INTO pan_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","ਜਦ ਤਾਰਹ ਦੀ ਉਮਰ ਦੋ ਸੌ ਪੰਜ ਸਾਲ ਦੀ ਸੀ ਤਦ ਉਹ ਹਾਰਾਨ ਦੇਸ਼ ਵਿੱਚ ਮਰ ਗਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","ਤਦ ਯਹੋਵਾਹ ਨੇ ਅਬਰਾਮ ਨੂੰ ਆਖਿਆ, ਤੂੰ ਆਪਣੇ ਦੇਸ਼, ਆਪਣੇ ਸੰਬੰਧੀਆਂ, ਅਤੇ ਆਪਣੇ ਪਿਤਾ ਦੇ ਘਰ ਨੂੰ ਛੱਡ ਕੇ ਉਸ ਦੇਸ਼ ਨੂੰ ਚੱਲਿਆ ਜਾ ਜੋ ਮੈਂ ਤੈਨੂੰ ਵਿਖਾਵਾਂਗਾ। ");
INSERT INTO pan_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","ਮੈਂ ਤੈਨੂੰ ਇੱਕ ਵੱਡੀ ਕੌਮ ਬਣਾਵਾਂਗਾ ਅਤੇ ਮੈਂ ਤੈਨੂੰ ਅਸੀਸ ਦਿਆਂਗਾ ਅਤੇ ਮੈਂ ਤੇਰਾ ਨਾਮ ਵੱਡਾ ਕਰਾਂਗਾ ਅਤੇ ਤੂੰ ਬਰਕਤ ਦਾ ਕਾਰਨ ਹੋਵੇਂਗਾ। ");
INSERT INTO pan_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","ਜੋ ਤੈਨੂੰ ਅਸੀਸ ਦੇਣ, ਉਨ੍ਹਾਂ ਨੂੰ ਮੈਂ ਅਸੀਸ ਦਿਆਂਗਾ ਅਤੇ ਜੋ ਤੈਨੂੰ ਸਰਾਪ ਦੇਣ, ਉਨ੍ਹਾਂ ਨੂੰ ਮੈਂ ਸਰਾਪ ਦਿਆਂਗਾ ਅਤੇ ਤੇਰੇ ਕਾਰਨ ਧਰਤੀ ਦੀਆਂ ਸਾਰੀਆਂ ਕੌਮਾਂ ਬਰਕਤ ਪਾਉਣਗੀਆਂ। ");
INSERT INTO pan_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","ਸੋ ਯਹੋਵਾਹ ਦੇ ਬਚਨ ਅਨੁਸਾਰ ਅਬਰਾਮ ਚੱਲਿਆ ਅਤੇ ਲੂਤ ਵੀ ਉਹ ਦੇ ਨਾਲ ਚੱਲਿਆ। ਜਦੋਂ ਅਬਰਾਮ ਹਾਰਾਨ ਦੇਸ਼ ਤੋਂ ਨਿੱਕਲਿਆ, ਉਸ ਸਮੇਂ ਉਹ ਪੰਝੱਤਰ ਸਾਲ ਦਾ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","ਇਸ ਤਰ੍ਹਾਂ ਅਬਰਾਮ ਆਪਣੀ ਪਤਨੀ ਸਾਰਈ, ਆਪਣੇ ਭਤੀਜੇ ਲੂਤ ਅਤੇ ਉਸ ਸਾਰੇ ਧਨ ਨੂੰ ਜੋ ਉਨ੍ਹਾਂ ਨੇ ਇਕੱਠਾ ਕੀਤਾ ਸੀ ਅਤੇ ਉਨ੍ਹਾਂ ਜੀਵਾਂ ਨੂੰ ਜਿਨ੍ਹਾਂ ਨੂੰ ਉਨ੍ਹਾਂ ਨੇ ਹਾਰਾਨ ਵਿੱਚ ਪ੍ਰਾਪਤ ਕੀਤਾ ਸੀ, ਲੈ ਕੇ ਕਨਾਨ ਦੇਸ਼ ਨੂੰ ਜਾਣ ਲਈ ਨਿੱਕਲਿਆ ਅਤੇ ਉਹ ਕਨਾਨ ਦੇਸ਼ ਵਿੱਚ ਆ ਗਏ। ");
INSERT INTO pan_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","ਅਬਰਾਮ ਉਸ ਦੇਸ਼ ਵਿੱਚੋਂ ਲੰਘਦੇ ਹੋਏ ਸ਼ਕਮ ਨੂੰ ਜਿੱਥੇ ਮੋਰਹ ਦੇ ਬਲੂਤ ਹਨ, ਪਹੁੰਚ ਗਿਆ। ਉਸ ਸਮੇਂ ਉੱਥੇ ਕਨਾਨੀ ਲੋਕ ਰਹਿੰਦੇ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","ਤਦ ਯਹੋਵਾਹ ਨੇ ਅਬਰਾਮ ਨੂੰ ਦਰਸ਼ਣ ਦੇ ਕੇ ਆਖਿਆ, ਇਹ ਦੇਸ਼ ਮੈਂ ਤੇਰੀ ਅੰਸ ਨੂੰ ਦਿਆਂਗਾ। ਤਦ ਅਬਰਾਮ ਨੇ ਉੱਥੇ ਯਹੋਵਾਹ ਲਈ ਇੱਕ ਜਗਵੇਦੀ ਬਣਾਈ, ਜਿਸ ਨੇ ਉਹ ਨੂੰ ਦਰਸ਼ਣ ਦਿੱਤਾ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","ਤਦ ਉੱਥੋਂ ਉਹ ਇੱਕ ਪਰਬਤ ਨੂੰ ਆਇਆ ਜੋ ਬੈਤਏਲ ਤੋਂ ਪੂਰਬ ਵੱਲ ਹੈ, ਅਤੇ ਉੱਥੇ ਜਾ ਕੇ ਆਪਣਾ ਤੰਬੂ ਲਾਇਆ। ਜਿੱਥੋਂ ਪੱਛਮ ਵੱਲ ਬੈਤਏਲ ਅਤੇ ਪੂਰਬ ਵੱਲ ਅਈ ਹੈ, ਉੱਥੇ ਵੀ ਉਸ ਨੇ ਯਹੋਵਾਹ ਲਈ ਇੱਕ ਜਗਵੇਦੀ ਬਣਾਈ ਅਤੇ ਯਹੋਵਾਹ ਨੂੰ ਪੁਕਾਰਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","ਅਬਰਾਮ ਸਫ਼ਰ ਕਰਦਾ-ਕਰਦਾ ਦੱਖਣ ਵੱਲ ਤੁਰਦਾ ਗਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","ਫੇਰ ਉਸ ਦੇਸ਼ ਵਿੱਚ ਕਾਲ ਪੈ ਗਿਆ। ਇਸ ਲਈ ਅਬਰਾਮ ਪਰਦੇਸੀ ਹੋ ਕੇ ਮਿਸਰ ਵਿੱਚ ਰਹਿਣ ਲਈ ਗਿਆ, ਕਿਉਂਕਿ ਉਸ ਦੇਸ਼ ਵਿੱਚ ਭਿਅੰਕਰ ਕਾਲ ਪਿਆ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","ਜਦ ਉਹ ਮਿਸਰ ਵਿੱਚ ਪਹੁੰਚਣ ਵਾਲਾ ਸੀ ਤਾਂ ਉਸ ਨੇ ਆਪਣੀ ਪਤਨੀ ਸਾਰਈ ਨੂੰ ਆਖਿਆ, ਵੇਖ ਮੈਂ ਜਾਣਦਾ ਹਾਂ ਕਿ ਤੂੰ ਇੱਕ ਸੋਹਣੀ ਇਸਤਰੀ ਹੈਂ, ");
INSERT INTO pan_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","ਜਦ ਮਿਸਰੀ ਤੈਨੂੰ ਵੇਖਣਗੇ ਤਦ ਉਹ ਕਹਿਣਗੇ ਕਿ ਇਹ ਉਸ ਦੀ ਪਤਨੀ ਹੈ, ਇਸ ਕਾਰਨ ਉਹ ਮੈਨੂੰ ਮਾਰ ਸੁੱਟਣਗੇ ਪਰ ਤੈਨੂੰ ਜੀਉਂਦੀ ਰੱਖ ਲੈਣਗੇ। ");
INSERT INTO pan_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","ਇਸ ਲਈ ਤੂੰ ਆਖੀਂ ਕਿ ਮੈਂ ਉਸ ਦੀ ਭੈਣ ਹਾਂ, ਤਾਂ ਜੋ ਮੇਰਾ ਭਲਾ ਹੋਵੇ ਅਤੇ ਮੇਰੀ ਜਾਨ ਤੇਰੇ ਕਾਰਨ ਬਚ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","ਫਿਰ ਜਦ ਅਬਰਾਮ ਮਿਸਰ ਵਿੱਚ ਆਇਆ ਤਾਂ ਮਿਸਰੀਆਂ ਨੇ ਉਸ ਦੀ ਪਤਨੀ ਨੂੰ ਵੇਖਿਆ ਕਿ ਉਹ ਬਹੁਤ ਸੋਹਣੀ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","ਤਦ ਫ਼ਿਰਊਨ ਦੇ ਹਾਕਮਾਂ ਨੇ ਉਸ ਨੂੰ ਵੇਖ ਕੇ, ਫ਼ਿਰਊਨ ਦੇ ਅੱਗੇ ਉਸ ਦੀ ਵਡਿਆਈ ਕੀਤੀ, ਤਦ ਉਹ ਇਸਤਰੀ ਫ਼ਿਰਊਨ ਦੇ ਘਰ ਵਿੱਚ ਪਹੁੰਚਾਈ ਗਈ। ");
INSERT INTO pan_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","ਤਦ ਫ਼ਿਰਊਨ ਨੇ ਅਬਰਾਮ ਨਾਲ ਉਹ ਦੇ ਕਾਰਨ ਭਲਿਆਈ ਕੀਤੀ। ਇਸ ਲਈ ਉਸ ਦੇ ਕੋਲ ਇੱਜੜ, ਗਾਈਆਂ-ਬਲ਼ਦ, ਗਧੇ-ਗਧੀਆਂ, ਦਾਸ-ਦਾਸੀਆਂ ਅਤੇ ਊਠ ਹੋ ਗਏ। ");
INSERT INTO pan_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","ਪਰ ਯਹੋਵਾਹ ਨੇ ਫ਼ਿਰਊਨ ਅਤੇ ਉਹ ਦੇ ਘਰਾਣੇ ਉੱਤੇ ਅਬਰਾਮ ਦੀ ਪਤਨੀ ਸਾਰਈ ਦੇ ਕਾਰਨ ਵੱਡੀਆਂ ਬਵਾਂ ਪਾਈਆਂ। ");
INSERT INTO pan_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","ਤਦ ਫ਼ਿਰਊਨ ਨੇ ਅਬਰਾਮ ਨੂੰ ਬੁਲਾ ਕੇ ਆਖਿਆ, ਤੂੰ ਮੇਰੇ ਨਾਲ ਇਹ ਕੀ ਕੀਤਾ? ਤੂੰ ਮੈਨੂੰ ਕਿਉਂ ਨਹੀਂ ਦੱਸਿਆ ਕਿ ਇਹ ਤੇਰੀ ਪਤਨੀ ਹੈ?। ");
INSERT INTO pan_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","ਤੂੰ ਮੈਨੂੰ ਕਿਉਂ ਆਖਿਆ ਕਿ ਇਹ ਮੇਰੀ ਭੈਣ ਹੈ? ਤਦ ਹੀ ਮੈਂ ਉਸ ਨੂੰ ਆਪਣੀ ਪਤਨੀ ਬਣਾਉਣ ਲਈ ਲਿਆ। ਹੁਣ ਆਪਣੀ ਪਤਨੀ ਨੂੰ ਲੈ ਅਤੇ ਜਾ। ");
INSERT INTO pan_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","ਤਦ ਫ਼ਿਰਊਨ ਨੇ ਆਪਣੇ ਆਦਮੀਆਂ ਨੂੰ ਉਸ ਵਿਖੇ ਹੁਕਮ ਦਿੱਤਾ, ਤਦ ਉਨ੍ਹਾਂ ਨੇ ਅਬਰਾਮ ਅਤੇ ਉਸ ਦੀ ਪਤਨੀ ਨੂੰ ਅਤੇ ਜੋ ਕੁਝ ਉਸ ਦਾ ਸੀ, ਉਸ ਨੂੰ ਦੇ ਕੇ ਉੱਥੋਂ ਤੋਰ ਦਿੱਤਾ। ");
INSERT INTO pan_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","ਤਦ ਅਬਰਾਮ ਆਪਣੀ ਪਤਨੀ ਅਤੇ ਸਭ ਕੁਝ ਜੋ ਉਹ ਦੇ ਕੋਲ ਸੀ ਅਤੇ ਲੂਤ ਨੂੰ ਵੀ ਆਪਣੇ ਨਾਲ ਲੈ ਕੇ ਮਿਸਰ ਤੋਂ ਕਨਾਨ ਦੇ ਦੱਖਣ ਵੱਲ ਗਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","ਅਬਰਾਮ ਪਸ਼ੂਆਂ ਅਤੇ ਸੋਨੇ ਚਾਂਦੀ ਵਿੱਚ ਵੱਡਾ ਧਨਵਾਨ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","ਉਹ ਦੱਖਣ ਤੋਂ ਸਫ਼ਰ ਕਰਦਾ ਬੈਤਏਲ ਦੀ ਉਸ ਥਾਂ ਤੱਕ ਪਹੁੰਚਿਆ ਜਿੱਥੇ ਉਸ ਨੇ ਪਹਿਲਾਂ ਆਪਣਾ ਤੰਬੂ ਬੈਤਏਲ ਅਤੇ ਅਈ ਦੇ ਵਿਚਕਾਰ ਲਾਇਆ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","ਇਹ ਸਥਾਨ ਉਸ ਜਗਵੇਦੀ ਦਾ ਹੈ, ਜੋ ਉਸ ਨੇ ਪਹਿਲਾਂ ਬਣਾਈ ਸੀ ਅਤੇ ਉੱਥੇ ਅਬਰਾਮ ਨੇ ਯਹੋਵਾਹ ਨੂੰ ਪੁਕਾਰਿਆ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","ਲੂਤ ਦੇ ਕੋਲ ਵੀ ਜਿਹੜਾ ਅਬਰਾਮ ਨਾਲ ਚੱਲਦਾ ਸੀ, ਇੱਜੜ, ਗਾਈਆਂ-ਬਲ਼ਦ ਅਤੇ ਪਰਿਵਾਰ ਦੇ ਲੋਕ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","ਇਸ ਲਈ ਉਸ ਦੇਸ਼ ਵਿੱਚ ਉਨ੍ਹਾਂ ਦੋਵਾਂ ਦੇ ਇਕੱਠੇ ਰਹਿਣ ਲਈ ਸਥਾਨ ਨਹੀਂ ਸੀ ਕਿਉਂਕਿ ਉਨ੍ਹਾਂ ਕੋਲ ਇੰਨ੍ਹਾਂ ਮਾਲ-ਧਨ ਸੀ ਕਿ ਉਹ ਇਕੱਠੇ ਨਹੀਂ ਰਹਿ ਸਕਦੇ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","ਅਬਰਾਮ ਅਤੇ ਲੂਤ ਦੇ ਆਜੜੀਆਂ ਵਿਚਕਾਰ ਝਗੜਾ ਹੋ ਗਿਆ। ਉਸ ਸਮੇਂ ਕਨਾਨੀ ਅਤੇ ਫ਼ਰਿੱਜ਼ੀ ਲੋਕ ਉਸ ਦੇਸ਼ ਵਿੱਚ ਵੱਸਦੇ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","ਅਬਰਾਮ ਨੇ ਲੂਤ ਨੂੰ ਆਖਿਆ, ਮੇਰੇ ਅਤੇ ਤੇਰੇ ਵਿੱਚ, ਅਤੇ ਮੇਰੇ ਅਤੇ ਤੇਰੇ ਆਜੜੀਆਂ ਵਿੱਚ ਝਗੜਾ ਨਹੀਂ ਹੋਣਾ ਚਾਹੀਦਾ, ਕਿਉਂ ਜੋ ਅਸੀਂ ਭਰਾ ਹਾਂ। ਭਲਾ, ਸਾਰਾ ਦੇਸ਼ ਤੇਰੇ ਅੱਗੇ ਨਹੀਂ ਹੈ? ");
INSERT INTO pan_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","ਇਸ ਲਈ ਮੈਥੋਂ ਵੱਖਰਾ ਹੋ ਜਾ। ਜੇ ਤੂੰ ਖੱਬੇ ਪਾਸੇ ਜਾਵੇਂ, ਤਾਂ ਮੈਂ ਸੱਜੇ ਪਾਸੇ ਜਾਂਵਾਂਗਾ ਅਤੇ ਜੇ ਤੂੰ ਸੱਜੇ ਪਾਸੇ ਜਾਵੇਂ, ਤਾਂ ਮੈਂ ਖੱਬੇ ਪਾਸੇ ਜਾਂਵਾਂਗਾ। ");
INSERT INTO pan_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","ਤਦ ਲੂਤ ਨੇ ਆਪਣੀਆਂ ਅੱਖਾਂ ਚੁੱਕ ਕੇ ਯਰਦਨ ਨਦੀ ਦੇ ਸਾਰੇ ਮੈਦਾਨ ਨੂੰ ਵੇਖਿਆ ਕਿ ਉਹ ਸਾਰਾ ਸਿੰਜਿਆ ਹੋਇਆ ਸੀ। ਇਸ ਤੋਂ ਪਹਿਲਾਂ ਕਿ ਯਹੋਵਾਹ ਨੇ ਸਦੂਮ ਅਤੇ ਅਮੂਰਾਹ ਨੂੰ ਨਾਸ ਕੀਤਾ, ਤਦ ਤੱਕ ਉਹ ਯਹੋਵਾਹ ਦੇ ਬਾਗ਼ ਵਰਗਾ ਸੀ ਸਗੋਂ ਸੋਆਰ ਨੂੰ ਜਾਂਦੇ ਹੋਏ ਮਿਸਰ ਦੇਸ਼ ਵਰਗਾ ਉਪਜਾਊ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","ਇਸ ਲਈ ਲੂਤ ਨੇ ਆਪਣੇ ਲਈ ਯਰਦਨ ਦਾ ਸਾਰਾ ਮੈਦਾਨ ਚੁਣ ਲਿਆ ਅਤੇ ਪੂਰਬ ਵੱਲ ਚੱਲਿਆ ਗਿਆ ਅਤੇ ਉਹ ਇੱਕ ਦੂਜੇ ਤੋਂ ਅਲੱਗ ਹੋ ਗਏ। ");
INSERT INTO pan_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","ਅਬਰਾਮ ਕਨਾਨ ਦੇਸ਼ ਵਿੱਚ ਵੱਸਿਆ ਪਰ ਲੂਤ ਉਸ ਮੈਦਾਨ ਦੇ ਨਗਰਾਂ ਵਿੱਚ ਵੱਸਿਆ ਅਤੇ ਸਦੂਮ ਦੇ ਕੋਲ ਆਪਣਾ ਤੰਬੂ ਲਾਇਆ। ");
INSERT INTO pan_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","ਸਦੂਮ ਦੇ ਲੋਕ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਵੱਡੇ ਦੁਸ਼ਟ ਅਤੇ ਮਹਾਂ ਪਾਪੀ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","ਜਦ ਅਬਰਾਮ ਲੂਤ ਤੋਂ ਅਲੱਗ ਹੋ ਗਿਆ ਤਾਂ ਯਹੋਵਾਹ ਨੇ ਅਬਰਾਮ ਨੂੰ ਆਖਿਆ, ਆਪਣੀਆਂ ਅੱਖਾਂ ਚੁੱਕ ਕੇ ਇਸ ਸਥਾਨ ਤੋਂ ਜਿੱਥੇ ਤੂੰ ਹੁਣ ਹੈਂ, ਉੱਤਰ-ਦੱਖਣ ਅਤੇ ਪੂਰਬ-ਪੱਛਮ ਵੱਲ ਵੇਖ, ");
INSERT INTO pan_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","ਕਿਉਂਕਿ ਇਹ ਸਾਰੀ ਧਰਤੀ ਜੋ ਤੂੰ ਵੇਖਦਾ ਹੈਂ, ਮੈਂ ਤੈਨੂੰ ਅਤੇ ਤੇਰੀ ਅੰਸ ਨੂੰ ਸਦਾ ਲਈ ਦੇ ਦਿਆਂਗਾ। ");
INSERT INTO pan_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","ਮੈਂ ਤੇਰੀ ਅੰਸ ਧਰਤੀ ਦੀ ਧੂੜ ਵਰਗੀ ਅਜਿਹੀ ਵਧਾਵਾਂਗਾ ਕਿ ਜੇ ਕੋਈ ਮਨੁੱਖ ਧਰਤੀ ਦੀ ਧੂੜ ਨੂੰ ਗਿਣ ਸਕੇ, ਤਾਂ ਉਹ ਤੇਰੀ ਅੰਸ ਨੂੰ ਵੀ ਗਿਣ ਸਕੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","ਉੱਠ ਅਤੇ ਇਸ ਦੇਸ਼ ਦੀ ਲੰਬਾਈ ਚੌੜਾਈ ਵਿੱਚ ਤੁਰ ਫਿਰ ਕਿਉਂ ਜੋ ਮੈਂ ਇਹ ਤੈਨੂੰ ਦੇ ਦਿਆਂਗਾ। ");
INSERT INTO pan_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","ਇਸ ਤੋਂ ਬਾਅਦ ਅਬਰਾਮ ਨੇ ਆਪਣਾ ਤੰਬੂ ਪੁੱਟਿਆ ਅਤੇ ਮਮਰੇ ਦੇ ਬਲੂਤਾਂ ਕੋਲ, ਜਿਹੜੇ ਹਬਰੋਨ ਵਿੱਚ ਹਨ, ਜਾ ਵੱਸਿਆ ਅਤੇ ਉੱਥੇ ਉਸ ਨੇ ਯਹੋਵਾਹ ਲਈ ਇੱਕ ਜਗਵੇਦੀ ਬਣਾਈ। ");
INSERT INTO pan_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","ਸ਼ਿਨਾਰ ਦੇ ਰਾਜਾ ਅਮਰਾਫ਼ਲ, ਅੱਲਾਸਾਰ ਦੇ ਰਾਜਾ ਅਰਯੋਕ, ਏਲਾਮ ਦੇ ਰਾਜਾ ਕਦਾਰਲਾਓਮਰ ਅਤੇ ਗੋਈਮ ਦੇ ਰਾਜਾ ਤਿਦਾਲ ਦੇ ਦਿਨਾਂ ਵਿੱਚ ਅਜਿਹਾ ਹੋਇਆ ");
INSERT INTO pan_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","ਕਿ ਇਨ੍ਹਾਂ ਨੇ ਸਦੂਮ ਦੇ ਰਾਜਾ ਬਰਾ, ਅਮੂਰਾਹ ਦੇ ਰਾਜਾ ਬਿਰਸਾ, ਅਦਮਾਹ ਦੇ ਰਾਜਾ ਸਿਨਾਬ, ਸਬੋਈਮ ਦੇ ਰਾਜਾ ਸਮੇਬਰ ਅਤੇ ਬਲਾ ਅਰਥਾਤ ਸੋਆਰ ਦੇ ਰਾਜਾ ਨਾਲ ਯੁੱਧ ਕੀਤਾ। ");
INSERT INTO pan_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","ਇਹ ਸਾਰੇ ਸਿੱਦੀਮ ਦੀ ਘਾਟੀ ਵਿੱਚ ਜੋ ਖਾਰਾ ਸਮੁੰਦਰ ਹੈ, ਇਕੱਠੇ ਹੋਏ। ");
INSERT INTO pan_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","ਬਾਰਾਂ ਸਾਲ ਤੱਕ ਉਹ ਕਦਾਰਲਾਓਮਰ ਦੇ ਅਧੀਨ ਰਹੇ ਪਰ ਤੇਰ੍ਹਵੇਂ ਸਾਲ ਵਿੱਚ ਵਿਦਰੋਹੀ ਹੋ ਗਏ। ");
INSERT INTO pan_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","ਚੌਧਵੇਂ ਸਾਲ ਵਿੱਚ ਕਦਾਰਲਾਓਮਰ ਅਤੇ ਉਹ ਰਾਜੇ ਜੋ ਉਹ ਦੇ ਨਾਲ ਆਏ ਸਨ, ਅਤੇ ਉਨ੍ਹਾਂ ਨੇ ਰਫ਼ਾਈਆਂ ਨੂੰ, ਅਸਤਰੋਥ-ਕਰਨਇਮ ਵਿੱਚ ਅਤੇ ਜ਼ੂਜ਼ੀਆਂ ਨੂੰ ਹਾਮ ਵਿੱਚ, ਅਤੇ ਏਮੀਆਂ ਨੂੰ ਸਾਵੇਹ ਕਿਰਯਾਤਾਇਮ ਵਿੱਚ, ");
INSERT INTO pan_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","ਅਤੇ ਹੋਰੀਆਂ ਨੂੰ ਉਨ੍ਹਾਂ ਦੇ ਪਰਬਤ ਸੇਈਰ ਵਿੱਚ ਏਲ-ਪਾਰਾਨ ਤੱਕ, ਜੋ ਉਜਾੜ ਕੋਲ ਹੈ, ਮਾਰਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","ਉਹ ਉੱਥੋਂ ਮੁੜ ਕੇ ਏਨ ਮਿਸਪਾਟ ਅਰਥਾਤ ਕਾਦੇਸ਼ ਨੂੰ ਆਏ ਅਤੇ ਉਨ੍ਹਾਂ ਨੇ ਅਮਾਲੇਕੀਆਂ ਦੇ ਸਾਰੇ ਦੇਸ਼ ਨੂੰ, ਅਤੇ ਅਮੋਰੀਆਂ ਨੂੰ ਵੀ ਜੋ ਹਸਸੋਨ ਤਾਮਾਰ ਵਿੱਚ ਵੱਸਦੇ ਸਨ, ਮਾਰਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","ਤਦ ਸਦੂਮ, ਅਮੂਰਾਹ, ਅਦਮਾਹ, ਸਬੋਈਮ, ਬਲਾ ਅਰਥਾਤ ਸੋਆਰ ਦੇ ਰਾਜੇ ਨਿੱਕਲੇ ਅਤੇ ਉਨ੍ਹਾਂ ਨਾਲ ਸਿੱਦੀਮ ਦੀ ਘਾਟੀ ਵਿੱਚ ਲੜਨ ਲਈ ਕਤਾਰਾਂ ਬੰਨ੍ਹੀਆਂ। ");
INSERT INTO pan_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","ਅਰਥਾਤ ਏਲਾਮ ਦੇ ਰਾਜਾ ਕਦਾਰਲਾਓਮਰ, ਗੋਈਮ ਦੇ ਰਾਜਾ ਤਿਦਾਲ, ਸ਼ਿਨਾਰ ਦੇ ਰਾਜਾ ਅਮਰਾਫ਼ਲ, ਅੱਲਾਸਾਰ ਦੇ ਰਾਜਾ ਅਰਯੋਕ, ਇਹਨਾਂ ਚਾਰ ਰਾਜਿਆਂ ਦੇ ਵਿਰੁੱਧ ਉਹਨਾਂ ਪੰਜਾਂ ਨੇ ਕਤਾਰ ਬੰਨ੍ਹੀ। ");
INSERT INTO pan_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","ਸਿੱਦੀਮ ਦੀ ਘਾਟੀ ਵਿੱਚ ਜਿੱਥੇ ਚਿੱਕੜ ਦੇ ਟੋਏ ਹੀ ਟੋਏ ਸਨ, ਸਦੂਮ ਅਤੇ ਅਮੂਰਾਹ ਦੇ ਰਾਜੇ ਭੱਜੇ ਅਤੇ ਉਹਨਾਂ ਵਿੱਚ ਡਿੱਗ ਪਏ ਅਤੇ ਜਿਹੜੇ ਬਚ ਗਏ ਉਹ ਪਰਬਤ ਵੱਲ ਨੂੰ ਭੱਜੇ। ");
INSERT INTO pan_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","ਤਦ ਉਹ ਸਦੂਮ ਅਤੇ ਅਮੂਰਾਹ ਦਾ ਸਾਰਾ ਮਾਲ ਧਨ ਅਤੇ ਉਨ੍ਹਾਂ ਦੀਆਂ ਸਾਰੀਆਂ ਭੋਜਨ ਵਸਤਾਂ ਲੁੱਟ ਕੇ ਚਲੇ ਗਏ। ");
INSERT INTO pan_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","ਉਹ ਅਬਰਾਮ ਦੇ ਭਤੀਜੇ ਲੂਤ ਨੂੰ, ਜੋ ਸਦੂਮ ਵਿੱਚ ਵੱਸਦਾ ਸੀ ਅਤੇ ਉਸ ਦੇ ਮਾਲ ਧਨ ਨੂੰ ਵੀ ਲੁੱਟ ਕੇ ਨਾਲ ਲੈ ਗਏ। ");
INSERT INTO pan_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","ਤਦ ਕਿਸੇ ਭਗੌੜੇ ਨੇ ਆ ਕੇ ਅਬਰਾਮ ਇਬਰਾਨੀ ਨੂੰ ਖ਼ਬਰ ਦਿੱਤੀ, ਅਬਰਾਮ ਮਮਰੇ ਅਮੋਰੀ ਜੋ ਅਸ਼ਕੋਲ ਅਤੇ ਆਨੇਰ ਦੇ ਭਰਾ ਸੀ, ਉਸ ਦੇ ਬਲੂਤਾਂ ਕੋਲ ਰਹਿੰਦਾ ਸੀ ਅਤੇ ਉਨ੍ਹਾਂ ਨੇ ਅਬਰਾਮ ਨਾਲ ਨੇਮ ਬੰਨ੍ਹਿਆ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","ਜਦ ਅਬਰਾਮ ਨੇ ਸੁਣਿਆ ਕਿ ਉਹ ਦਾ ਭਤੀਜਾ ਬੰਦੀ ਬਣਾ ਲਿਆ ਗਿਆ ਹੈ, ਤਦ ਉਸ ਨੇ ਆਪਣੇ ਤਿੰਨ ਸੌ ਅਠਾਰਾਂ ਸਿਖਾਏ ਹੋਏ ਜੁਆਨਾਂ ਨੂੰ ਲਿਆ, ਜੋ ਉਸ ਦੇ ਘਰਾਣੇ ਵਿੱਚ ਜੰਮੇ ਸਨ ਅਤੇ ਦਾਨ ਤੱਕ ਉਨ੍ਹਾਂ ਦਾ ਪਿੱਛਾ ਕੀਤਾ। ");
INSERT INTO pan_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","ਉਸ ਨੇ ਆਪਣੇ ਜੁਆਨਾਂ ਦੇ ਜੱਥੇ ਬਣਾਏ ਅਤੇ ਰਾਤ ਨੂੰ ਉਨ੍ਹਾਂ ਉੱਤੇ ਹਮਲਾ ਕਰਕੇ ਉਹਨਾਂ ਨੂੰ ਮਾਰਿਆ, ਅਤੇ ਹੋਬਾਹ ਤੱਕ ਜਿਹੜਾ ਦੰਮਿਸ਼ਕ ਦੇ ਉੱਤਰ ਵੱਲ ਹੈ, ਉਨ੍ਹਾਂ ਦਾ ਪਿੱਛਾ ਕੀਤਾ। ");
INSERT INTO pan_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","ਉਹ ਸਾਰੇ ਮਾਲ ਧਨ ਨੂੰ, ਅਤੇ ਆਪਣੇ ਭਤੀਜੇ ਲੂਤ ਅਤੇ ਉਸ ਦੇ ਸਾਰੇ ਮਾਲ-ਧਨ ਨੂੰ ਅਤੇ ਇਸਤਰੀਆਂ ਅਤੇ ਸਾਰੇ ਬੰਦੀਆਂ ਨੂੰ ਵੀ ਮੋੜ ਲੈ ਆਇਆ। ");
INSERT INTO pan_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","ਜਦ ਉਹ ਕਦਾਰਲਾਓਮਰ ਅਤੇ ਉਹਨਾਂ ਰਾਜਿਆਂ ਨੂੰ ਜਿਹੜੇ ਉਸ ਦੇ ਨਾਲ ਸਨ ਜਿੱਤ ਕੇ ਮੁੜਿਆ, ਤਦ ਸਦੂਮ ਦਾ ਰਾਜਾ ਸ਼ਾਵੇਹ ਦੀ ਘਾਟੀ ਵਿੱਚ ਜੋ ਬਾਦਸ਼ਾਹੀ ਘਾਟੀ ਵੀ ਅਖਵਾਉਂਦੀ ਹੈ, ਉਸ ਨੂੰ ਮਿਲਣ ਲਈ ਨਿੱਕਲ ਆਇਆ। ");
INSERT INTO pan_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","ਤਦ ਸ਼ਾਲੇਮ ਦਾ ਰਾਜਾ ਮਲਕਿਸਿਦਕ ਰੋਟੀ ਅਤੇ ਮਧ ਲੈ ਆਇਆ, ਉਹ ਅੱਤ ਮਹਾਨ ਪਰਮੇਸ਼ੁਰ ਦਾ ਜਾਜਕ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","ਉਸ ਨੇ ਇਹ ਆਖ ਕੇ ਅਬਰਾਮ ਨੂੰ ਅਸੀਸ ਦਿੱਤੀ, ਅੱਤ ਮਹਾਨ ਪਰਮੇਸ਼ੁਰ ਦੀ ਵੱਲੋਂ ਜੋ ਅਕਾਸ਼ ਅਤੇ ਧਰਤੀ ਦਾ ਮਾਲਕ ਹੈ, ਅਬਰਾਮ ਮੁਬਾਰਕ ਹੋਵੇ। ");
INSERT INTO pan_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","ਅਤੇ ਮੁਬਾਰਕ ਹੈ ਅੱਤ ਮਹਾਨ ਪਰਮੇਸ਼ੁਰ, ਜਿਸ ਨੇ ਤੇਰੇ ਵੈਰੀਆਂ ਨੂੰ ਤੇਰੇ ਵੱਸ ਵਿੱਚ ਕਰ ਦਿੱਤਾ ਹੈ। ਤਦ ਅਬਰਾਮ ਨੇ ਉਸ ਨੂੰ ਸਾਰੀਆਂ ਵਸਤਾਂ ਦਾ ਦਸਵੰਧ ਦਿੱਤਾ। ");
INSERT INTO pan_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","ਤਦ ਸਦੂਮ ਦੇ ਰਾਜਾ ਨੇ ਅਬਰਾਮ ਨੂੰ ਆਖਿਆ, ਇਹ ਮਾਲ-ਡੰਗਰ ਤਾਂ ਮੈਨੂੰ ਦੇ, ਪਰ ਮਾਲ-ਧਨ ਆਪ ਰੱਖ ਲੈ। ");
INSERT INTO pan_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","ਪਰ ਅਬਰਾਮ ਨੇ ਸਦੂਮ ਦੇ ਰਾਜਾ ਨੂੰ ਆਖਿਆ, ਮੈਂ ਯਹੋਵਾਹ ਅੱਤ ਮਹਾਨ ਪਰਮੇਸ਼ੁਰ ਜੋ ਅਕਾਸ਼ ਅਤੇ ਧਰਤੀ ਦਾ ਮਾਲਕ ਹੈ, ਉਸ ਦੇ ਅੱਗੇ ਪ੍ਰਣ ਕੀਤਾ ਹੈ ");
INSERT INTO pan_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","ਕਿ ਮੈਂ ਧਾਗੇ ਤੋਂ ਲੈ ਕੇ ਜੁੱਤੀ ਦੇ ਸੱਲੂ ਤੱਕ, ਤੇਰੇ ਸਾਰੇ ਮਾਲ ਵਿੱਚੋਂ ਕੁਝ ਨਹੀਂ ਲਵਾਂਗਾ, ਅਜਿਹਾ ਨਾ ਹੋਵੇ ਕਿ ਤੂੰ ਆਖੇਂ ਕਿ ਮੈਂ ਹੀ ਅਬਰਾਮ ਨੂੰ ਧਨੀ ਬਣਾ ਦਿੱਤਾ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","ਪਰ ਜੋ ਇਨ੍ਹਾਂ ਗੱਭਰੂਆਂ ਨੇ ਖਾ ਲਿਆ ਹੈ, ਅਤੇ ਉਨ੍ਹਾਂ ਦਾ ਹਿੱਸਾ ਜਿਹੜੇ ਮਨੁੱਖ ਮੇਰੇ ਨਾਲ ਗਏ ਸਨ ਅਰਥਾਤ ਆਨੇਰ, ਅਸ਼ਕੋਲ ਅਤੇ ਮਮਰੇ, ਮੈਂ ਵਾਪਿਸ ਨਹੀਂ ਕਰਾਂਗਾ, ਉਹ ਆਪਣਾ-ਆਪਣਾ ਹਿੱਸਾ ਲੈ ਲੈਣ। ");
INSERT INTO pan_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","ਇਨ੍ਹਾਂ ਗੱਲਾਂ ਤੋਂ ਬਾਅਦ ਯਹੋਵਾਹ ਦਾ ਇਹ ਬਚਨ ਦਰਸ਼ਣ ਵਿੱਚ ਅਬਰਾਮ ਕੋਲ ਆਇਆ: ਨਾ ਡਰ ਅਬਰਾਮ, ਮੈਂ ਤੇਰੇ ਲਈ ਢਾਲ਼ ਹਾਂ ਅਤੇ ਤੇਰੇ ਲਈ ਵੱਡਾ ਫਲ ਹਾਂ। ");
INSERT INTO pan_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","ਅਬਰਾਮ ਨੇ ਆਖਿਆ, ਹੇ ਪ੍ਰਭੂ ਯਹੋਵਾਹ, ਤੂੰ ਮੈਨੂੰ ਕੀ ਦੇਵੇਂਗਾ? ਕਿਉਂ ਜੋ ਮੈਂ ਬੇ-ਔਲਾਦ ਜਾਂਦਾ ਹਾਂ ਅਤੇ ਮੇਰੇ ਘਰ ਦਾ ਵਾਰਿਸ ਇਹ ਦੰਮਿਸ਼ਕੀ ਅਲੀਅਜ਼ਰ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","ਅਬਰਾਮ ਨੇ ਆਖਿਆ ਵੇਖ ਤੂੰ ਮੈਨੂੰ ਕੋਈ ਅੰਸ ਨਹੀਂ ਦਿੱਤੀ ਅਤੇ ਵੇਖ ਮੇਰੇ ਘਰਾਣੇ ਵਿੱਚ ਜੰਮਿਆ ਮੇਰਾ ਵਾਰਿਸ ਹੋਵੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","ਤਦ ਯਹੋਵਾਹ ਦਾ ਬਚਨ ਉਹ ਦੇ ਕੋਲ ਆਇਆ, ਇਹ ਤੇਰਾ ਵਾਰਿਸ ਨਾ ਹੋਵੇਗਾ ਪਰ ਉਹ ਜੋ ਤੇਰੇ ਵਿੱਚੋਂ ਹੋਵੇਗਾ ਉਹ ਤੇਰਾ ਵਾਰਿਸ ਹੋਵੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","ਯਹੋਵਾਹ ਪਰਮੇਸ਼ੁਰ ਉਸ ਨੂੰ ਬਾਹਰ ਲੈ ਗਿਆ ਅਤੇ ਆਖਿਆ, ਅਕਾਸ਼ ਵੱਲ ਵੇਖ ਅਤੇ ਤਾਰਿਆਂ ਨੂੰ ਗਿਣ, ਕੀ ਤੂੰ ਉਹਨਾਂ ਨੂੰ ਗਿਣ ਸਕਦਾ ਹੈ? ਫੇਰ ਉਸ ਨੇ ਉਹ ਨੂੰ ਆਖਿਆ, ਤੇਰੀ ਅੰਸ ਐਨੀ ਹੀ ਹੋਵੇਗੀ। ");
INSERT INTO pan_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","ਉਸ ਨੇ ਯਹੋਵਾਹ ਉੱਤੇ ਵਿਸ਼ਵਾਸ ਕੀਤਾ, ਅਤੇ ਯਹੋਵਾਹ ਨੇ ਉਹ ਦੇ ਲਈ ਇਸ ਗੱਲ ਨੂੰ ਧਾਰਮਿਕਤਾ ਗਿਣਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","ਤਦ ਉਸ ਨੇ ਉਹ ਨੂੰ ਆਖਿਆ, ਮੈਂ ਉਹੀ ਯਹੋਵਾਹ ਹਾਂ ਜੋ ਤੈਨੂੰ ਕਸਦੀਆਂ ਦੇ ਊਰ ਨਗਰ ਵਿੱਚੋਂ ਬਾਹਰ ਕੱਢ ਲੈ ਆਇਆ ਹਾਂ, ਤਾਂ ਜੋ ਮੈਂ ਤੈਨੂੰ ਇਹ ਦੇਸ਼ ਤੇਰੀ ਵਿਰਾਸਤ ਹੋਣ ਲਈ ਦੇ ਦਿਆਂ। ");
INSERT INTO pan_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","ਉਸ ਨੇ ਆਖਿਆ, ਹੇ ਪ੍ਰਭੂ ਯਹੋਵਾਹ ਮੈਂ ਕਿਸ ਤਰ੍ਹਾਂ ਜਾਣਾ ਕਿ ਮੈਂ ਉਸ ਨੂੰ ਵਿਰਾਸਤ ਦੇ ਤੌਰ ਤੇ ਲਵਾਂਗਾ? ");
INSERT INTO pan_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","ਯਹੋਵਾਹ ਨੇ ਉਸ ਨੂੰ ਆਖਿਆ, ਮੇਰੇ ਲਈ ਇੱਕ ਤਿੰਨ ਸਾਲ ਦੀ ਵੱਛੀ, ਇੱਕ ਤਿੰਨ ਸਾਲ ਦੀ ਬੱਕਰੀ ਅਤੇ ਇੱਕ ਤਿੰਨ ਸਾਲ ਦਾ ਲੇਲਾ, ਇੱਕ ਘੁੱਗੀ ਅਤੇ ਇੱਕ ਕਬੂਤਰ ਦਾ ਬੱਚਾ ਲੈ। ");
INSERT INTO pan_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","ਉਹ ਯਹੋਵਾਹ ਦੇ ਲਈ ਇਹ ਸਭ ਕੁਝ ਲੈ ਆਇਆ ਅਤੇ ਉਨ੍ਹਾਂ ਦੇ ਦੋ-ਦੋ ਟੋਟੇ ਕੀਤੇ ਅਤੇ ਉਸ ਨੇ ਇੱਕ ਟੋਟੇ ਨੂੰ ਦੂਜੇ ਦੇ ਸਾਹਮਣੇ ਰੱਖਿਆ, ਪਰ ਪੰਛੀਆਂ ਦੇ ਟੋਟੇ ਨਾ ਕੀਤੇ। ");
INSERT INTO pan_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","ਜਦ ਸ਼ਿਕਾਰੀ ਪੰਛੀ ਉਨ੍ਹਾਂ ਲੋਥਾਂ ਉੱਤੇ ਉਤਰੇ, ਤਦ ਅਬਰਾਮ ਨੇ ਉਨ੍ਹਾਂ ਨੂੰ ਹਟਾਇਆ। ");
INSERT INTO pan_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","ਜਦ ਸੂਰਜ ਡੁੱਬਣ ਲੱਗਾ, ਤਦ ਅਬਰਾਮ ਨੂੰ ਗੂੜ੍ਹੀ ਨੀਂਦ ਆ ਪਈ ਅਤੇ ਵੇਖੋ, ਇੱਕ ਵੱਡਾ ਡਰਾਉਣਾ ਹਨ੍ਹੇਰਾ ਉਹ ਦੇ ਉੱਤੇ ਛਾ ਗਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","ਉਸ ਨੇ ਅਬਰਾਮ ਨੂੰ ਆਖਿਆ, ਤੂੰ ਸੱਚ ਜਾਣ, ਕਿ ਤੇਰਾ ਵੰਸ਼ ਇੱਕ ਪਰਾਏ ਦੇਸ਼ ਵਿੱਚ ਪਰਦੇਸੀ ਹੋ ਕੇ ਰਹੇਗਾ ਅਤੇ ਉਹ ਉਨ੍ਹਾਂ ਨੂੰ ਗ਼ੁਲਾਮ ਬਣਾ ਕੇ ਰੱਖਣਗੇ ਅਤੇ ਚਾਰ ਸੌ ਸਾਲ ਤੱਕ ਉਨ੍ਹਾਂ ਨੂੰ ਦੁੱਖ ਦੇਣਗੇ। ");
INSERT INTO pan_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","ਪਰ ਉਸ ਕੌਮ ਨੂੰ ਵੀ ਜਿਸ ਦੀ ਉਹ ਗ਼ੁਲਾਮੀ ਕਰਨਗੇ, ਮੈਂ ਸਜ਼ਾ ਦਿਆਂਗਾ, ਅਤੇ ਇਸ ਤੋਂ ਬਾਅਦ ਉਹ ਵੱਡੇ ਮਾਲ-ਧਨ ਨਾਲ ਉੱਥੋਂ ਨਿੱਕਲ ਆਉਣਗੇ। ");
INSERT INTO pan_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","ਪਰ ਤੂੰ ਆਪਣੇ ਪੁਰਖਿਆਂ ਕੋਲ ਸ਼ਾਂਤੀ ਨਾਲ ਜਾਵੇਂਗਾ। ");
INSERT INTO pan_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","ਤੂੰ ਚੰਗੀ ਬਜ਼ੁਰਗੀ ਵਿੱਚ ਦਫ਼ਨਾਇਆ ਜਾਵੇਂਗਾ ਅਤੇ ਚੌਥੀ ਪੀੜ੍ਹੀ ਵਿੱਚ ਓਹ ਵਾਪਿਸ ਮੁੜ ਆਉਣਗੇ ਕਿਉਂਕਿ ਜੋ ਅਮੋਰੀਆਂ ਦੀ ਬੁਰਿਆਈ ਅਜੇ ਪੂਰੀ ਨਹੀਂ ਹੋਈ। ");
INSERT INTO pan_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","ਅਜਿਹਾ ਹੋਇਆ ਕਿ ਜਦ ਸੂਰਜ ਡੁੱਬ ਗਿਆ ਅਤੇ ਹਨ੍ਹੇਰਾ ਹੋ ਗਿਆ ਤਾਂ ਵੇਖੋ ਇੱਕ ਧੂੰਏਂ ਵਾਲਾ ਤੰਦੂਰ ਅਤੇ ਬਲਦੀ ਮਸ਼ਾਲ ਇਨ੍ਹਾਂ ਟੋਟਿਆਂ ਵਿੱਚੋਂ ਦੀ ਲੰਘ ਗਈ। ");
INSERT INTO pan_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","ਉਸ ਦਿਨ ਯਹੋਵਾਹ ਨੇ ਇੱਕ ਨੇਮ ਅਬਰਾਮ ਨਾਲ ਬੰਨ੍ਹਿਆ, ਤੇਰੀ ਅੰਸ ਨੂੰ ਮੈਂ ਇਹ ਦੇਸ਼ ਦੇ ਦਿੱਤਾ ਹੈ ਅਰਥਾਤ ਮਿਸਰ ਦੇ ਦਰਿਆ ਤੋਂ ਲੈ ਕੇ ਵੱਡੇ ਦਰਿਆ ਫ਼ਰਾਤ ਤੱਕ ");
INSERT INTO pan_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","ਅਰਥਾਤ ਕੇਨੀ, ਕਨਿੱਜ਼ੀ ਅਤੇ ਕਦਮੋਨੀ, ");
INSERT INTO pan_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","ਹਿੱਤੀ, ਫ਼ਰਿੱਜ਼ੀ ਅਤੇ ਰਫ਼ਾਈਮ, ");
INSERT INTO pan_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","ਅਮੋਰੀ, ਕਨਾਨੀ, ਗਿਰਗਾਸ਼ੀ ਅਤੇ ਯਬੂਸੀ ਇਹ ਵੀ ਦੇ ਦਿੱਤੇ ਹਨ। ");
INSERT INTO pan_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","ਅਬਰਾਮ ਦੀ ਪਤਨੀ ਸਾਰਈ ਦੇ ਕੋਈ ਸੰਤਾਨ ਨਹੀਂ ਸੀ। ਉਹ ਦੇ ਕੋਲ ਇੱਕ ਮਿਸਰੀ ਦਾਸੀ ਸੀ, ਜਿਸ ਦਾ ਨਾਮ ਹਾਜ਼ਰਾ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","ਸਾਰਈ ਨੇ ਅਬਰਾਮ ਨੂੰ ਆਖਿਆ, ਵੇਖ, ਯਹੋਵਾਹ ਨੇ ਮੇਰੀ ਕੁੱਖ ਨੂੰ ਬੰਦ ਕਰ ਰੱਖਿਆ ਹੈ। ਕਿਰਪਾ ਕਰਕੇ ਮੇਰੀ ਦਾਸੀ ਕੋਲ ਜਾ, ਸ਼ਾਇਦ ਮੈਂ ਉਸ ਤੋਂ ਸੰਤਾਨ ਵਾਲੀ ਬਣ ਜਾਂਵਾਂ। ਅਬਰਾਮ ਨੇ ਸਾਰਈ ਦੀ ਗੱਲ ਮੰਨ ਲਈ। ");
INSERT INTO pan_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","ਜਦੋਂ ਅਬਰਾਮ ਨੂੰ ਕਨਾਨ ਦੇਸ਼ ਵਿੱਚ ਵੱਸਦਿਆਂ ਦੱਸ ਸਾਲ ਹੋ ਗਏ, ਤਦ ਅਬਰਾਮ ਦੀ ਪਤਨੀ ਸਾਰਈ ਨੇ ਆਪਣੀ ਮਿਸਰੀ ਦਾਸੀ ਹਾਜ਼ਰਾ ਨੂੰ ਲੈ ਕੇ ਆਪਣੇ ਪਤੀ ਅਬਰਾਮ ਨੂੰ ਦਿੱਤਾ, ਕਿ ਉਹ ਉਸ ਦੀ ਪਤਨੀ ਹੋਵੇ। ");
INSERT INTO pan_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","ਉਹ ਹਾਜ਼ਰਾ ਕੋਲ ਗਿਆ ਅਤੇ ਉਹ ਗਰਭਵਤੀ ਹੋਈ। ਜਦ ਉਸ ਨੇ ਜਾਣਿਆ ਕਿ ਉਹ ਗਰਭਵਤੀ ਹੈ, ਤਦ ਉਹ ਦੀ ਮਾਲਕਣ ਉਹ ਦੀਆਂ ਅੱਖਾਂ ਵਿੱਚ ਤੁੱਛ ਹੋ ਗਈ। ");
INSERT INTO pan_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","ਸਾਰਈ ਨੇ ਅਬਰਾਮ ਨੂੰ ਆਖਿਆ, ਜੋ ਮੇਰੇ ਨਾਲ ਹੋਇਆ ਉਸਦਾ ਕਾਰਨ ਤੂੰ ਹੈ। ਮੈਂ ਆਪਣੀ ਦਾਸੀ ਨੂੰ ਤੇਰੀ ਪਤਨੀ ਹੋਣ ਲਈ ਆਪ ਦਿੱਤਾ ਅਤੇ ਜਦ ਉਸ ਨੇ ਜਾਣਿਆ ਕਿ ਉਹ ਗਰਭਵਤੀ ਹੈ ਤਾਂ ਮੇਰੀ ਕਦਰ ਉਹ ਦੀਆਂ ਅੱਖਾਂ ਵਿੱਚ ਘੱਟ ਗਈ। ਇਸ ਲਈ ਯਹੋਵਾਹ ਮੇਰਾ ਅਤੇ ਤੇਰਾ ਨਿਆਂ ਕਰੇ। ");
INSERT INTO pan_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","ਅਬਰਾਮ ਨੇ ਸਾਰਈ ਨੂੰ ਆਖਿਆ, ਵੇਖ, ਤੇਰੀ ਦਾਸੀ ਤੇਰੇ ਵੱਸ ਵਿੱਚ ਹੈ, ਜੋ ਤੇਰੀ ਨਿਗਾਹ ਵਿੱਚ ਚੰਗਾ ਹੈ ਤੂੰ ਉਸ ਨਾਲ ਉਹੀ ਕਰ। ਉਪਰੰਤ ਸਾਰਈ ਨੇ ਉਸ ਨਾਲ ਸਖ਼ਤੀ ਕੀਤੀ ਅਤੇ ਉਹ ਉਸ ਦੇ ਕੋਲੋਂ ਭੱਜ ਗਈ। ");
INSERT INTO pan_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","ਪਰ ਯਹੋਵਾਹ ਦੇ ਦੂਤ ਨੇ ਉਹ ਨੂੰ ਸ਼ੂਰ ਵਾਲੇ ਰਾਹ ਤੇ ਪਾਣੀ ਦੇ ਚਸ਼ਮੇ ਕੋਲ ਉਜਾੜ ਵਿੱਚ ਲੱਭਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","ਉਸ ਨੇ ਆਖਿਆ, ਹੇ ਹਾਜ਼ਰਾ ਸਾਰਈ ਦੀ ਦਾਸੀ, ਤੂੰ ਕਿੱਥੋਂ ਆਈ ਹੈਂ? ਅਤੇ ਕਿੱਧਰ ਜਾਣਾ ਹੈ? ਤਦ ਉਸ ਨੇ ਆਖਿਆ ਮੈਂ ਆਪਣੀ ਮਾਲਕਣ ਸਾਰਈ ਕੋਲੋਂ ਭੱਜ ਆਈ ਹਾਂ। ");
INSERT INTO pan_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","ਫੇਰ ਯਹੋਵਾਹ ਦੇ ਦੂਤ ਨੇ ਉਹ ਨੂੰ ਆਖਿਆ, ਆਪਣੀ ਮਾਲਕਣ ਕੋਲ ਮੁੜ ਜਾ ਅਤੇ ਆਪਣੇ ਆਪ ਨੂੰ ਉਸ ਦੇ ਅਧੀਨ ਕਰ ਦੇ। ");
INSERT INTO pan_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","ਯਹੋਵਾਹ ਦੇ ਦੂਤ ਨੇ ਉਹ ਨੂੰ ਇਹ ਵੀ ਆਖਿਆ, ਮੈਂ ਤੇਰੀ ਅੰਸ ਨੂੰ ਐਨਾ ਵਧਾਵਾਂਗਾ ਕਿ ਉਹ ਵਾਧੇ ਦੇ ਕਾਰਨ ਗਿਣੀ ਨਾ ਜਾਵੇਗੀ। ");
INSERT INTO pan_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","ਅਤੇ ਯਹੋਵਾਹ ਦੇ ਦੂਤ ਨੇ ਉਹ ਨੂੰ ਆਖਿਆ, ਵੇਖ, ਤੂੰ ਗਰਭਵਤੀ ਹੈਂ ਅਤੇ ਪੁੱਤਰ ਜਣੇਂਗੀ। ਤੂੰ ਉਸ ਦਾ ਨਾਮ ਇਸਮਾਏਲ ਰੱਖੀਂ ਕਿਉਂ ਜੋ ਯਹੋਵਾਹ ਨੇ ਤੇਰੇ ਦੁੱਖ ਨੂੰ ਸੁਣਿਆ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","ਪਰ ਉਹ ਮਨੁੱਖਾਂ ਵਿੱਚ ਜੰਗਲੀ ਗਧੇ ਜਿਹਾ ਹੋਵੇਗਾ। ਉਹ ਦਾ ਹੱਥ ਹਰ ਇੱਕ ਦੇ ਵਿਰੁੱਧ ਅਤੇ ਹਰ ਇੱਕ ਦਾ ਹੱਥ ਉਸ ਦੇ ਵਿਰੁੱਧ ਹੋਵੇਗਾ ਅਤੇ ਉਹ ਆਪਣੇ ਸਾਰੇ ਭਰਾਵਾਂ ਦੇ ਸਾਹਮਣੇ ਵੱਸੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","ਤਦ ਉਸ ਨੇ ਯਹੋਵਾਹ ਦਾ ਨਾਮ ਜੋ ਉਹ ਦੇ ਨਾਲ ਗੱਲਾਂ ਕਰਦਾ ਸੀ, ਅਤਾਏਲਰੋਈ ਰੱਖਿਆ ਕਿ ਉਸ ਨੇ ਆਖਿਆ ਕੀ ਮੈਂ ਉਹ ਨੂੰ ਵੇਖਣ ਦੇ ਮਗਰੋਂ ਵੀ ਜਿਉਂਦੀ ਹਾਂ? ");
INSERT INTO pan_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","ਇਸ ਲਈ ਉਹ ਉਸ ਖੂਹ ਦਾ ਨਾਮ ਬਏਰ-ਲਹਈ-ਰੋਈ ਆਖਦੇ ਹਨ। ਵੇਖੋ ਓਹ ਕਾਦੇਸ਼ ਅਤੇ ਬਰਦ ਦੇ ਵਿਚਕਾਰ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","ਹਾਜ਼ਰਾ ਨੇ ਅਬਰਾਮ ਲਈ ਇੱਕ ਪੁੱਤਰ ਨੂੰ ਜਨਮ ਦਿੱਤਾ ਅਤੇ ਅਬਰਾਮ ਨੇ ਆਪਣੇ ਪੁੱਤਰ ਦਾ ਨਾਮ ਜਿਸ ਨੂੰ ਹਾਜ਼ਰਾ ਨੇ ਜਨਮ ਦਿੱਤਾ, ਇਸਮਾਏਲ ਰੱਖਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","ਜਦ ਹਾਜ਼ਰਾ ਨੇ ਇਸਮਾਏਲ ਨੂੰ ਜਨਮ ਦਿੱਤਾ ਉਸ ਵੇਲੇ ਅਬਰਾਮ ਦੀ ਉਮਰ ਛਿਆਸੀ ਸਾਲ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","ਜਦ ਅਬਰਾਮ ਨੜਿੰਨਵੇਂ ਸਾਲ ਦਾ ਹੋਇਆ ਤਦ ਯਹੋਵਾਹ ਨੇ ਅਬਰਾਮ ਨੂੰ ਦਰਸ਼ਣ ਦਿੱਤਾ ਅਤੇ ਉਸ ਨੂੰ ਆਖਿਆ, ਮੈਂ ਸਰਬ ਸ਼ਕਤੀਮਾਨ ਪਰਮੇਸ਼ੁਰ ਹਾਂ। ਤੂੰ ਮੇਰੇ ਸਨਮੁਖ ਚੱਲ ਅਤੇ ਸੰਪੂਰਨ ਹੋ। ");
INSERT INTO pan_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","ਮੈਂ ਆਪਣਾ ਨੇਮ ਆਪਣੇ ਅਤੇ ਤੇਰੇ ਵਿੱਚ ਬੰਨ੍ਹਾਂਗਾ ਅਤੇ ਮੈਂ ਤੈਨੂੰ ਹੱਦੋਂ ਬਾਹਲਾ ਵਧਾਵਾਂਗਾ। ");
INSERT INTO pan_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","ਤਦ ਅਬਰਾਮ ਆਪਣੇ ਮੂੰਹ ਦੇ ਭਾਰ ਡਿੱਗਿਆ ਅਤੇ ਪਰਮੇਸ਼ੁਰ ਨੇ ਉਹ ਦੇ ਨਾਲ ਇਹ ਗੱਲ ਕੀਤੀ ");
INSERT INTO pan_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","ਭਈ ਵੇਖ ਮੇਰਾ ਨੇਮ ਤੇਰੇ ਨਾਲ ਹੈ ਅਤੇ ਤੂੰ ਬਹੁਤੀਆਂ ਕੌਮਾਂ ਦਾ ਪਿਤਾ ਹੋਵੇਂਗਾ। ");
INSERT INTO pan_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","ਤੇਰਾ ਨਾਮ ਫੇਰ ਅਬਰਾਮ ਨਹੀਂ ਸੱਦਿਆ ਜਾਵੇਗਾ, ਪਰ ਤੇਰਾ ਨਾਮ ਅਬਰਾਹਾਮ ਹੋਵੇਗਾ ਕਿਉਂਕਿ ਮੈਂ ਤੈਨੂੰ ਬਹੁਤੀਆਂ ਕੌਮਾਂ ਦਾ ਪਿਤਾ ਠਹਿਰਾ ਦਿੱਤਾ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","ਮੈਂ ਤੈਨੂੰ ਹੱਦੋਂ ਬਾਹਲਾ ਫਲਵੰਤ ਬਣਾਵਾਂਗਾ, ਮੈਂ ਤੈਥੋਂ ਕੌਮਾਂ ਬਣਾਵਾਂਗਾ ਅਤੇ ਤੇਰੀ ਪੀੜ੍ਹੀ ਤੋਂ ਰਾਜੇ ਨਿੱਕਲਣਗੇ। ");
INSERT INTO pan_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","ਮੈਂ ਆਪਣਾ ਨੇਮ ਆਪਣੇ ਅਤੇ ਤੇਰੀ ਅੰਸ ਦੇ ਵਿੱਚ ਜੋ ਤੇਰੇ ਬਾਅਦ ਹੋਵੇਗੀ ਸਗੋਂ ਉਨ੍ਹਾਂ ਦੀਆਂ ਪੀੜ੍ਹੀਆਂ ਤੱਕ ਇੱਕ ਅਨੰਤ ਨੇਮ ਕਰਕੇ ਬੰਨ੍ਹਾਂਗਾ, ਮੈਂ ਤੇਰਾ ਅਤੇ ਤੇਰੇ ਬਾਅਦ ਤੇਰੀ ਅੰਸ ਦਾ ਪਰਮੇਸ਼ੁਰ ਹੋਵਾਂਗਾ। ");
INSERT INTO pan_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","ਮੈਂ ਤੈਨੂੰ ਅਤੇ ਤੇਰੇ ਬਾਅਦ ਤੇਰੇ ਵੰਸ਼ ਨੂੰ ਵੀ ਇਹ ਸਾਰਾ ਕਨਾਨ ਦੇਸ਼ ਜਿਸ ਵਿੱਚ ਤੂੰ ਪਰਦੇਸੀ ਹੋ ਕੇ ਰਹਿੰਦਾ ਹੈ, ਸਦਾ ਦੀ ਵਿਰਾਸਤ ਹੋਣ ਲਈ ਦੇ ਦਿਆਂਗਾ ਅਤੇ ਮੈਂ ਉਨ੍ਹਾਂ ਦਾ ਪਰਮੇਸ਼ੁਰ ਹੋਵਾਂਗਾ। ");
INSERT INTO pan_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","ਪਰਮੇਸ਼ੁਰ ਨੇ ਅਬਰਾਹਾਮ ਨੂੰ ਆਖਿਆ, ਤੂੰ ਮੇਰੇ ਨੇਮ ਦੀ ਪਾਲਣਾ ਕਰ, ਤੂੰ ਅਤੇ ਤੇਰੇ ਬਾਅਦ ਤੇਰੀ ਅੰਸ ਉਨ੍ਹਾਂ ਦੀਆਂ ਪੀੜ੍ਹੀਆਂ ਤੱਕ ਇਸ ਨੇਮ ਦੀ ਪਾਲਣਾ ਕਰਨ। ");
INSERT INTO pan_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","ਮੇਰਾ ਇਹ ਨੇਮ, ਜਿਸ ਦੀ ਪਾਲਣਾ ਤੈਨੂੰ ਅਤੇ ਤੇਰੇ ਬਾਅਦ ਅੰਸ ਨੂੰ ਕਰਨੀ ਹੈ, ਉਹ ਇਹ ਹੈ: ਤੁਹਾਡੇ ਵਿੱਚੋਂ ਹਰ ਇੱਕ ਪੁਰਖ ਦੀ ਸੁੰਨਤ ਕੀਤੀ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","ਤੁਸੀਂ ਆਪਣੇ ਬਦਨ ਦੀ ਖੱਲੜੀ ਦੀ ਸੁੰਨਤ ਕਰਾਓ ਅਤੇ ਇਹ ਮੇਰੇ ਅਤੇ ਤੁਹਾਡੇ ਵਿੱਚ ਉਸ ਨੇਮ ਦਾ ਨਿਸ਼ਾਨ ਹੋਵੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","ਤੁਹਾਡੇ ਵਿੱਚ ਹਰ ਇੱਕ ਅੱਠਾਂ ਦਿਨਾਂ ਦੇ ਨਰ ਦੀ ਸੁੰਨਤ ਪੀੜ੍ਹੀਓਂ ਪੀੜ੍ਹੀ ਕੀਤੀ ਜਾਵੇ, ਭਾਵੇਂ ਉਹ ਤੇਰੇ ਘਰਾਣੇ ਦਾ ਹੋਵੇ, ਭਾਵੇਂ ਉਹ ਕਿਸੇ ਪਰਦੇਸੀ ਤੋਂ ਜੋ ਤੇਰੀ ਅੰਸ ਦਾ ਨਹੀਂ ਹੈ ਚਾਂਦੀ ਨਾਲ ਮੁੱਲ ਲਿਆ ਹੋਵੇ। ");
INSERT INTO pan_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","ਜੋ ਤੇਰੇ ਘਰਾਣੇ ਵਿੱਚ ਪੈਦਾ ਹੋਵੇ ਅਤੇ ਚਾਂਦੀ ਨਾਲ ਮੁੱਲ ਲਏ ਹੋਣ, ਉਨ੍ਹਾਂ ਦੀ ਸੁੰਨਤ ਜ਼ਰੂਰ ਕੀਤੀ ਜਾਵੇ। ਇਸ ਤਰ੍ਹਾਂ ਮੇਰਾ ਨੇਮ ਜਿਸ ਦਾ ਨਿਸ਼ਾਨ ਤੁਹਾਡੇ ਸਰੀਰ ਵਿੱਚ ਹੋਵੇਗਾ ਉਹ ਇੱਕ ਅਨੰਤ ਨੇਮ ਹੋਵੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","ਪਰ ਜੋ ਪੁਰਖ ਬੇਸੁੰਨਤਾ ਰਹੇ ਅਤੇ ਜਿਸ ਦੀ ਖੱਲੜੀ ਦੀ ਸੁੰਨਤ ਨਾ ਕੀਤੀ ਗਈ ਹੋਵੇ, ਉਹ ਪ੍ਰਾਣੀ ਆਪਣੇ ਲੋਕਾਂ ਵਿੱਚੋਂ ਛੇਕਿਆ ਜਾਵੇਗਾ ਕਿਉਂ ਜੋ ਉਸ ਨੇ ਮੇਰੇ ਨੇਮ ਨੂੰ ਤੋੜਿਆ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","ਫੇਰ ਪਰਮੇਸ਼ੁਰ ਨੇ ਅਬਰਾਹਾਮ ਨੂੰ ਆਖਿਆ, ਸਾਰਈ ਜੋ ਤੇਰੀ ਪਤਨੀ ਹੈ, ਤੂੰ ਉਸ ਨੂੰ ਸਾਰਈ ਨਾ ਆਖੀਂ ਸਗੋਂ ਹੁਣ ਤੋਂ ਉਸ ਦਾ ਨਾਮ ਸਾਰਾਹ ਹੋਵੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","ਮੈਂ ਉਹ ਨੂੰ ਅਸੀਸ ਦਿਆਂਗਾ ਅਤੇ ਉਸ ਤੋਂ ਮੈਂ ਤੈਨੂੰ ਇੱਕ ਪੁੱਤਰ ਵੀ ਦਿਆਂਗਾ। ਮੈਂ ਉਹ ਨੂੰ ਅਜਿਹੀ ਅਸੀਸ ਦਿਆਂਗਾ ਕਿ ਉਹ ਕੌਮਾਂ ਦੀ ਮਾਤਾ ਹੋਵੇਗੀ, ਕੌਮਾਂ ਦੇ ਰਾਜੇ ਉਸ ਤੋਂ ਪੈਦਾ ਹੋਣਗੇ। ");
INSERT INTO pan_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","ਤਦ ਅਬਰਾਹਾਮ ਆਪਣੇ ਮੂੰਹ ਭਾਰ ਡਿੱਗ ਪਿਆ ਅਤੇ ਉਹ ਹੱਸਿਆ ਅਤੇ ਆਪਣੇ ਮਨ ਵਿੱਚ ਆਖਿਆ, ਭਲਾ, ਸੌ ਸਾਲ ਦੇ ਪੁਰਖ ਤੋਂ ਪੁੱਤਰ ਹੋਵੇਗਾ? ਅਤੇ ਕੀ ਸਾਰਾਹ ਜੋ ਨੱਬੇ ਸਾਲਾਂ ਦੀ ਹੈ, ਪੁੱਤਰ ਜਣੇਗੀ? ");
INSERT INTO pan_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","ਅਬਰਾਹਾਮ ਨੇ ਪਰਮੇਸ਼ੁਰ ਨੂੰ ਆਖਿਆ, ਇਸਮਾਏਲ ਹੀ ਤੇਰੇ ਨਜ਼ਰ ਵਿੱਚ ਬਣਿਆ ਰਹੇ, ਇਹ ਹੀ ਬਹੁਤ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","ਪਰ ਪਰਮੇਸ਼ੁਰ ਨੇ ਆਖਿਆ, ਤੇਰੀ ਪਤਨੀ ਸਾਰਾਹ ਜ਼ਰੂਰ ਤੇਰੇ ਲਈ ਇੱਕ ਪੁੱਤਰ ਜਣੇਗੀ, ਤੂੰ ਉਹ ਦਾ ਨਾਮ ਇਸਹਾਕ ਰੱਖੀਂ ਅਤੇ ਮੈਂ ਆਪਣਾ ਨੇਮ ਉਹ ਦੇ ਨਾਲ ਅਤੇ ਉਹ ਦੇ ਬਾਅਦ ਉਹ ਦੀ ਅੰਸ ਨਾਲ, ਇੱਕ ਅਨੰਤ ਨੇਮ ਕਰਕੇ ਕਾਇਮ ਕਰਾਂਗਾ। ");
INSERT INTO pan_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","ਇਸਮਾਏਲ ਦੇ ਲਈ ਵੀ ਮੈਂ ਤੇਰੀ ਸੁਣੀ ਹੈ। ਵੇਖ, ਮੈਂ ਉਹ ਨੂੰ ਅਸੀਸ ਦਿੱਤੀ ਹੈ ਅਤੇ ਮੈਂ ਉਹ ਨੂੰ ਫਲਵੰਤ ਬਣਾਵਾਂਗਾ ਅਤੇ ਹੱਦੋਂ ਬਾਹਲਾ ਵਧਾਵਾਂਗਾ। ਉਸ ਤੋਂ ਬਾਰਾਂ ਪ੍ਰਧਾਨ ਜੰਮਣਗੇ ਅਤੇ ਮੈਂ ਉਹ ਨੂੰ ਇੱਕ ਵੱਡੀ ਕੌਮ ਬਣਾਵਾਂਗਾ। ");
INSERT INTO pan_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","ਪਰ ਮੈਂ ਆਪਣਾ ਨੇਮ ਇਸਹਾਕ ਨਾਲ ਹੀ ਕਾਇਮ ਕਰਾਂਗਾ, ਜਿਸ ਨੂੰ ਸਾਰਾਹ ਆਉਣ ਵਾਲੇ ਸਾਲ ਵਿੱਚ ਇਸੇ ਸਮੇਂ ਤੇਰੇ ਲਈ ਜਣੇਗੀ। ");
INSERT INTO pan_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","ਜਦ ਪਰਮੇਸ਼ੁਰ ਅਬਰਾਹਾਮ ਨਾਲ ਗੱਲਾਂ ਕਰ ਹਟਿਆ, ਤਦ ਪਰਮੇਸ਼ੁਰ ਅਬਰਾਹਾਮ ਕੋਲੋਂ ਉਤਾਹਾਂ ਚਲਾ ਗਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","ਤਦ ਅਬਰਾਹਾਮ ਨੇ ਆਪਣੇ ਪੁੱਤਰ ਇਸਮਾਏਲ, ਆਪਣੇ ਘਰਾਣੇ ਵਿੱਚ ਜੰਮਿਆ ਹੋਇਆਂ ਨੂੰ, ਜਿੰਨ੍ਹੇ ਉਸ ਨੇ ਆਪਣੀ ਚਾਂਦੀ ਨਾਲ ਮੁੱਲ ਲਏ ਸਨ ਅਰਥਾਤ ਉਸ ਦੇ ਘਰ ਵਿੱਚ ਜਿੰਨ੍ਹੇ ਪੁਰਖ ਸਨ ਉਨ੍ਹਾਂ ਸਾਰਿਆਂ ਨੂੰ ਲੈ ਕੇ ਉਸੇ ਦਿਨ ਉਨ੍ਹਾਂ ਦੀ ਖੱਲੜੀ ਦੀ ਸੁੰਨਤ ਕਰਾਈ, ਜਿਵੇਂ ਪਰਮੇਸ਼ੁਰ ਨੇ ਉਸ ਦੇ ਨਾਲ ਗੱਲ ਕੀਤੀ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","ਜਦ ਅਬਰਾਹਾਮ ਦੀ ਖੱਲੜੀ ਦੀ ਸੁੰਨਤ ਕੀਤੀ ਗਈ ਤਦ ਅਬਰਾਹਾਮ ਨੜਿੰਨਵੇਂ ਸਾਲ ਦਾ ਸੀ, ");
INSERT INTO pan_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","ਅਤੇ ਇਸਮਾਏਲ ਤੇਰ੍ਹਾਂ ਸਾਲਾਂ ਦਾ ਸੀ, ਜਦ ਉਸ ਦੀ ਖੱਲੜੀ ਦੀ ਸੁੰਨਤ ਕੀਤੀ ਗਈ। ");
INSERT INTO pan_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","ਅਬਰਾਹਾਮ ਤੇ ਉਹ ਦੇ ਪੁੱਤਰ ਇਸਮਾਏਲ ਦੀ ਸੁੰਨਤ ਇੱਕੋ ਦਿਨ ਹੋਈ। ");
INSERT INTO pan_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","ਅਤੇ ਉਹ ਦੇ ਘਰ ਦੇ ਸਾਰੇ ਪੁਰਖਾਂ ਦੀ ਭਾਵੇਂ ਉਹ ਉਸ ਦੇ ਘਰਾਣੇ ਵਿੱਚ ਜੰਮੇ ਸਨ, ਭਾਵੇਂ ਪਰਦੇਸੀਆਂ ਤੋਂ ਚਾਂਦੀ ਦੇ ਕੇ ਮੁੱਲ ਲਏ ਹੋਏ ਸਨ, ਸਾਰਿਆਂ ਦੀ ਸੁੰਨਤ ਉਸ ਦੇ ਨਾਲ ਹੀ ਕੀਤੀ ਗਈ। ");
INSERT INTO pan_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","ਯਹੋਵਾਹ ਨੇ ਅਬਰਾਹਾਮ ਨੂੰ ਮਮਰੇ ਦੇ ਬਲੂਤਾਂ ਵਿੱਚ ਦਰਸ਼ਣ ਦਿੱਤਾ, ਜਦ ਉਹ ਆਪਣੇ ਤੰਬੂ ਦੇ ਦਰਵਾਜ਼ੇ ਵਿੱਚ ਦਿਨ ਦੀ ਧੁੱਪ ਵੇਲੇ ਬੈਠਾ ਹੋਇਆ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","ਉਸ ਨੇ ਆਪਣੀਆਂ ਅੱਖਾਂ ਚੁੱਕ ਕੇ ਵੇਖਿਆ, ਤਾਂ ਵੇਖੋ ਤਿੰਨ ਮਨੁੱਖ ਉਹ ਦੇ ਸਾਹਮਣੇ ਖੜ੍ਹੇ ਸਨ। ਉਨ੍ਹਾਂ ਨੂੰ ਵੇਖਦਿਆਂ ਹੀ, ਉਹ ਉਨ੍ਹਾਂ ਨੂੰ ਮਿਲਣ ਲਈ ਆਪਣੇ ਤੰਬੂ ਦੇ ਦਰਵਾਜ਼ੇ ਤੋਂ ਭੱਜਿਆ ਅਤੇ ਧਰਤੀ ਤੱਕ ਝੁੱਕ ਕੇ ਮੱਥਾ ਟੇਕਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","ਉਸ ਨੇ ਆਖਿਆ, ਹੇ ਪ੍ਰਭੂ! ਜੇ ਮੇਰੇ ਉੱਤੇ ਤੁਹਾਡੀ ਕਿਰਪਾ ਦੀ ਨਜ਼ਰ ਹੋਈ ਹੈ ਤਾਂ ਆਪਣੇ ਦਾਸ ਦੇ ਕੋਲੋਂ ਚਲੇ ਨਾ ਜਾਣਾ। ");
INSERT INTO pan_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","ਮੈਂ ਥੋੜ੍ਹਾ ਜਿਹਾ ਪਾਣੀ ਲਿਆਉਂਦਾ ਹਾਂ, ਤਾਂ ਜੋ ਤੁਸੀਂ ਆਪਣੇ ਪੈਰ ਧੋ ਕੇ ਰੁੱਖ ਹੇਠ ਆਰਾਮ ਕਰੋ। ");
INSERT INTO pan_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","ਮੈਂ ਥੋੜ੍ਹੀ ਜਿਹੀ ਰੋਟੀ ਵੀ ਲਿਆਉਂਦਾ ਹਾਂ, ਜੋ ਤੁਸੀਂ ਆਪਣੇ ਮਨਾਂ ਨੂੰ ਤ੍ਰਿਪਤ ਕਰੋ। ਫੇਰ ਤੁਸੀਂ ਅੱਗੇ ਲੰਘ ਜਾਇਓ, ਕਿਉਂਕਿ ਤੁਸੀਂ ਇਸੇ ਲਈ ਆਪਣੇ ਦਾਸ ਕੋਲ ਆਏ ਹੋ। ਤਦ ਉਨ੍ਹਾਂ ਨੇ ਆਖਿਆ, ਜਿਵੇਂ ਤੂੰ ਕਿਹਾ ਹੈ ਉਸੇ ਤਰ੍ਹਾਂ ਹੀ ਕਰ। ");
INSERT INTO pan_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","ਤਦ ਅਬਰਾਹਾਮ ਝੱਟ ਸਾਰਾਹ ਕੋਲ ਤੰਬੂ ਵਿੱਚ ਗਿਆ ਅਤੇ ਆਖਿਆ, ਜਲਦੀ ਕਰ ਅਤੇ ਤਿੰਨ ਮਾਪ ਮੈਦਾ ਗੁੰਨ੍ਹ ਕੇ ਰੋਟੀਆਂ ਪਕਾ ");
INSERT INTO pan_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","ਅਤੇ ਅਬਰਾਹਾਮ ਨੱਸ ਕੇ ਚੌਣੇ ਵਿੱਚ ਗਿਆ ਅਤੇ ਇੱਕ ਚੰਗਾ ਅਤੇ ਨਰਮ ਵੱਛਾ ਲੈ ਕੇ ਇੱਕ ਸੇਵਕ ਨੂੰ ਦਿੱਤਾ ਅਤੇ ਉਸ ਨੇ ਛੇਤੀ ਨਾਲ ਉਹ ਨੂੰ ਤਿਆਰ ਕੀਤਾ। ");
INSERT INTO pan_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","ਫੇਰ ਉਸ ਨੇ ਦਹੀਂ, ਦੁੱਧ ਅਤੇ ਉਹ ਵੱਛਾ ਜਿਸ ਨੂੰ ਉਸ ਨੇ ਤਿਆਰ ਕਰਵਾਇਆ ਸੀ, ਲੈ ਕੇ ਉਨ੍ਹਾਂ ਦੇ ਅੱਗੇ ਪਰੋਸ ਦਿੱਤਾ ਅਤੇ ਆਪ ਉਨ੍ਹਾਂ ਦੇ ਕੋਲ ਰੁੱਖ ਹੇਠ ਖੜ੍ਹਾ ਰਿਹਾ ਅਤੇ ਉਨ੍ਹਾਂ ਨੇ ਖਾਧਾ। ");
INSERT INTO pan_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","ਫੇਰ ਉਨ੍ਹਾਂ ਨੇ ਉਹ ਨੂੰ ਪੁੱਛਿਆ, ਤੇਰੀ ਪਤਨੀ ਸਾਰਾਹ ਕਿੱਥੇ ਹੈ? ਉਸ ਨੇ ਆਖਿਆ, ਉਹ ਤੰਬੂ ਵਿੱਚ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","ਉਹਨਾਂ ਵਿੱਚੋਂ ਇੱਕ ਨੇ ਆਖਿਆ, ਮੈਂ ਜ਼ਰੂਰ ਬਸੰਤ ਦੀ ਰੁੱਤੇ ਤੇਰੇ ਕੋਲ ਵਾਪਿਸ ਆਵਾਂਗਾ ਅਤੇ ਵੇਖ ਤੇਰੀ ਪਤਨੀ ਸਾਰਾਹ ਇੱਕ ਪੁੱਤਰ ਨੂੰ ਜਨਮ ਦੇਵੇਗੀ ਅਤੇ ਸਾਰਾਹ ਤੰਬੂ ਦੇ ਬੂਹੇ ਵਿੱਚ ਜਿਹੜਾ ਉਹ ਦੇ ਪਿੱਛੇ ਸੀ, ਸੁਣ ਰਹੀ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","ਅਬਰਾਹਾਮ ਅਤੇ ਸਾਰਾਹ ਬੁੱਢੇ ਅਤੇ ਵੱਡੀ ਉਮਰ ਦੇ ਸਨ ਅਤੇ ਸਾਰਾਹ ਦੀ ਮਾਹਵਾਰੀ ਵੀ ਬੰਦ ਹੋ ਗਈ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","ਤਦ ਸਾਰਾਹ ਆਪਣੇ ਮਨ ਵਿੱਚ ਹੱਸੀ ਤੇ ਆਖਿਆ ਕਿ ਜਦੋਂ ਮੈਂ ਬੁੱਢੀ ਹੋ ਗਈ ਹਾਂ ਅਤੇ ਮੇਰਾ ਸੁਆਮੀ ਵੀ ਬੁੱਢਾ ਹੈ, ਕੀ ਮੈਨੂੰ ਇਹ ਸੁੱਖ ਮਿਲੇਗਾ? ");
INSERT INTO pan_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","ਤਦ ਯਹੋਵਾਹ ਨੇ ਅਬਰਾਹਾਮ ਨੂੰ ਆਖਿਆ, ਸਾਰਾਹ ਕਿਉਂ ਇਹ ਆਖ ਕੇ ਹੱਸੀ ਕਿ ਜਦ ਮੈਂ ਬੁੱਢੀ ਹੋ ਗਈ ਹਾਂ ਤਾਂ, ਕੀ ਮੈਂ ਸੱਚ-ਮੁੱਚ ਪੁੱਤਰ ਨੂੰ ਜਨਮ ਦੇਵਾਂਗੀ? ਭਲਾ, ਯਹੋਵਾਹ ਲਈ ਕੋਈ ਗੱਲ ਔਖੀ ਹੈ? ");
INSERT INTO pan_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","ਨਿਯੁਕਤ ਸਮੇਂ ਸਿਰ ਮੈਂ ਤੇਰੇ ਕੋਲ ਵਾਪਿਸ ਆਵਾਂਗਾ ਅਤੇ ਸਾਰਾਹ ਪੁੱਤਰ ਨੂੰ ਜਨਮ ਦੇਵੇਗੀ। ");
INSERT INTO pan_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","ਪਰ ਸਾਰਾਹ ਇਹ ਆਖ ਕੇ ਮੁੱਕਰ ਗਈ, ਕਿ ਮੈਂ ਨਹੀਂ ਹੱਸੀ ਕਿਉਂ ਜੋ ਉਹ ਡਰ ਗਈ ਪਰੰਤੂ ਉਸ ਨੇ ਆਖਿਆ, ਨਹੀਂ ਤੂੰ ਜ਼ਰੂਰ ਹੱਸੀ ਹੈਂ। ");
INSERT INTO pan_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","ਤਦ ਉਨ੍ਹਾਂ ਮਨੁੱਖਾਂ ਨੇ ਉੱਥੋਂ ਉੱਠ ਕੇ ਸਦੂਮ ਵੱਲ ਵੇਖਿਆ ਅਤੇ ਅਬਰਾਹਾਮ ਉਨ੍ਹਾਂ ਨੂੰ ਰਾਹੇ ਪਾਉਣ ਲਈ ਨਾਲ ਤੁਰ ਪਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","ਤਦ ਯਹੋਵਾਹ ਨੇ ਆਖਿਆ, ਮੈਂ ਅਬਰਾਹਾਮ ਤੋਂ ਉਹ ਜੋ ਮੈਂ ਕਰਨ ਵਾਲਾ ਹਾਂ ਕਿਉਂ ਲੁਕਾਵਾਂ? ");
INSERT INTO pan_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","ਅਬਰਾਹਾਮ ਇੱਕ ਵੱਡੀ ਅਤੇ ਬਲਵੰਤ ਕੌਮ ਹੋਵੇਗਾ ਅਤੇ ਧਰਤੀ ਦੀਆਂ ਸਾਰੀਆਂ ਕੌਮਾਂ ਉਸ ਤੋਂ ਬਰਕਤ ਪਾਉਣਗੀਆਂ। ");
INSERT INTO pan_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","ਕਿਉਂਕਿ ਮੈਂ ਜਾਣ ਲਿਆ ਹੈ ਕਿ ਉਹ ਆਪਣੇ ਪੁੱਤਰਾਂ ਅਤੇ ਘਰਾਣੇ ਨੂੰ ਜੋ ਉਸ ਤੋਂ ਬਾਅਦ ਵਿੱਚ ਰਹਿ ਜਾਣਗੇ, ਆਗਿਆ ਦੇਵੇਗਾ ਕਿ ਉਹ ਯਹੋਵਾਹ ਦੇ ਰਾਹ ਦੀ ਪਾਲਨਾ ਕਰਨ ਅਤੇ ਧਰਮ ਅਤੇ ਨਿਆਂ ਕਰਦੇ ਰਹਿਣ, ਤਾਂ ਕਿ ਜੋ ਕੁਝ ਯਹੋਵਾਹ ਨੇ ਅਬਰਾਹਾਮ ਦੇ ਵਿਖੇ ਬੋਲਿਆ ਹੈ ਉਸ ਨੂੰ ਪੂਰਾ ਕਰੇ। ");
INSERT INTO pan_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","ਫਿਰ ਯਹੋਵਾਹ ਨੇ ਆਖਿਆ, ਸਦੂਮ ਅਤੇ ਅਮੂਰਾਹ ਸ਼ਹਿਰ ਦਾ ਰੌਲ਼ਾ ਬਹੁਤ ਵੱਧ ਗਿਆ ਹੈ ਅਤੇ ਉਨ੍ਹਾਂ ਦਾ ਪਾਪ ਵੀ ਬਹੁਤ ਭਾਰੀ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","ਇਸ ਲਈ ਮੈਂ ਉਤਰ ਕੇ ਵੇਖਾਂਗਾ ਕਿ ਉਨ੍ਹਾਂ ਨੇ ਉਸ ਰੌਲ਼ੇ ਅਨੁਸਾਰ ਜੋ ਮੇਰੇ ਕੋਲ ਆਇਆ ਹੈ, ਸਭ ਕੁਝ ਕੀਤਾ ਹੈ ਜਾਂ ਨਹੀਂ, ਜੇ ਉਹਨਾਂ ਨਹੀਂ ਕੀਤਾ ਹੈ ਤਾਂ ਮੈਂ ਜਾਣ ਜਾਂਵਾਂਗਾ। ");
INSERT INTO pan_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","ਤਦ ਓਹ ਮਨੁੱਖ ਉੱਥੋਂ ਮੁੜ ਕੇ ਸਦੂਮ ਵੱਲ ਤੁਰ ਪਏ, ਪਰ ਅਬਰਾਹਾਮ ਯਹੋਵਾਹ ਦੇ ਸਨਮੁਖ ਖੜ੍ਹਾ ਰਿਹਾ। ");
INSERT INTO pan_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","ਤਦ ਅਬਰਾਹਾਮ ਨੇ ਨੇੜੇ ਹੋ ਕੇ ਆਖਿਆ, ਕੀ ਤੂੰ ਸੱਚ-ਮੁੱਚ ਧਰਮੀ ਨੂੰ ਕੁਧਰਮੀ ਨਾਲ ਨਾਸ ਕਰੇਂਗਾ? ");
INSERT INTO pan_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","ਸ਼ਾਇਦ ਉਸ ਨਗਰ ਵਿੱਚ ਪੰਜਾਹ ਧਰਮੀ ਹੋਣ। ਕੀ ਤੂੰ ਜ਼ਰੂਰ ਉਸ ਥਾਂ ਨੂੰ ਮਿਟਾ ਦੇਵੇਂਗਾ ਅਤੇ ਉਨ੍ਹਾਂ ਪੰਜਾਹਾਂ ਧਰਮੀਆਂ ਦੇ ਕਾਰਨ ਜੋ ਉਸ ਵਿੱਚ ਹਨ, ਛੱਡ ਨਾ ਦੇਵੇਂਗਾ? ");
INSERT INTO pan_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","ਅਜਿਹਾ ਕਰਨਾ ਅਰਥਾਤ ਧਰਮੀ ਨੂੰ ਕੁਧਰਮੀ ਨਾਲ ਮਾਰਨਾ ਤੈਥੋਂ ਦੂਰ ਹੋਵੇ ਨਹੀਂ ਤਾਂ ਧਰਮੀ ਕੁਧਰਮੀ ਦੇ ਸਮਾਨ ਹੋ ਜਾਵੇਗਾ। ਅਜਿਹਾ ਕਰਨਾ ਤੇਰੇ ਤੋਂ ਦੂਰ ਹੋਵੇ। ");
INSERT INTO pan_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","ਕੀ ਸਾਰੀ ਧਰਤੀ ਦਾ ਨਿਆਈਂ ਨਿਆਂ ਨਾ ਕਰੇਗਾ? ਯਹੋਵਾਹ ਨੇ ਆਖਿਆ, ਜੇ ਸਦੂਮ ਵਿੱਚ ਪੰਜਾਹ ਧਰਮੀ ਮੈਨੂੰ ਲੱਭਣ, ਤਾਂ ਮੈਂ ਸਾਰੇ ਨਗਰ ਨੂੰ ਉਨ੍ਹਾਂ ਦੇ ਕਾਰਨ ਛੱਡ ਦਿਆਂਗਾ। ");
INSERT INTO pan_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","ਫੇਰ ਅਬਰਾਹਾਮ ਨੇ ਉੱਤਰ ਦੇ ਕੇ ਆਖਿਆ, ਵੇਖ, ਮੈਂ ਆਪਣੇ ਪ੍ਰਭੂ ਨਾਲ ਗੱਲ ਕਰਨ ਦੀ ਦਲੇਰੀ ਕੀਤੀ ਹੈ, ਭਾਵੇਂ ਮੈਂ ਧੂੜ ਅਤੇ ਮਿੱਟੀ ਹੀ ਹਾਂ। ");
INSERT INTO pan_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","ਸ਼ਾਇਦ ਪੰਜਾਹ ਧਰਮੀਆਂ ਵਿੱਚੋਂ ਪੰਜ ਘੱਟ ਹੋਣ। ਕੀ ਉਨ੍ਹਾਂ ਪੰਜਾਂ ਦੇ ਕਾਰਨ ਤੂੰ ਸਾਰਾ ਨਗਰ ਨਸ਼ਟ ਕਰੇਂਗਾ? ਉਸ ਨੇ ਆਖਿਆ, ਜੇ ਉੱਥੇ ਮੈਨੂੰ ਪੈਂਤਾਲੀ ਲੱਭਣ ਤਾਂ ਵੀ ਮੈਂ ਉਸ ਨੂੰ ਨਸ਼ਟ ਨਹੀਂ ਕਰਾਂਗਾ। ");
INSERT INTO pan_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","ਫੇਰ ਉਸ ਨੇ ਇੱਕ ਵਾਰੀ ਹੋਰ ਉਹ ਦੇ ਨਾਲ ਗੱਲ ਕਰਕੇ ਆਖਿਆ, ਸ਼ਾਇਦ ਉੱਥੇ ਚਾਲ੍ਹੀ ਲੱਭਣ। ਉਸ ਨੇ ਆਖਿਆ, ਮੈਂ ਉਨ੍ਹਾਂ ਚਾਲ੍ਹੀਆਂ ਦੇ ਕਾਰਨ ਇਹ ਨਹੀਂ ਕਰਾਂਗਾ। ");
INSERT INTO pan_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","ਤਦ ਉਸ ਨੇ ਆਖਿਆ, ਪ੍ਰਭੂ ਕ੍ਰੋਧਵਾਨ ਨਾ ਹੋਵੇ ਤਾਂ ਮੈਂ ਗੱਲ ਕਰਾਂ, ਸ਼ਾਇਦ ਉੱਥੇ ਤੀਹ ਲੱਭਣ। ਉਸ ਨੇ ਆਖਿਆ, ਜੇ ਉੱਥੇ ਤੀਹ ਮੈਨੂੰ ਲੱਭਣ ਤਾਂ ਵੀ ਮੈਂ ਇਹ ਨਹੀਂ ਕਰਾਂਗਾ। ");
INSERT INTO pan_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","ਫੇਰ ਉਸ ਨੇ ਆਖਿਆ, ਵੇਖ ਮੈਂ ਪ੍ਰਭੂ ਨਾਲ ਗੱਲ ਕਰਨ ਦੀ ਦਲੇਰੀ ਕੀਤੀ ਹੈ। ਸ਼ਾਇਦ ਉੱਥੇ ਵੀਹ ਲੱਭਣ। ਉਸ ਨੇ ਆਖਿਆ, ਮੈਂ ਉਨ੍ਹਾਂ ਵੀਹਾਂ ਦੇ ਕਾਰਨ ਵੀ ਨਸ਼ਟ ਨਹੀਂ ਕਰਾਂਗਾ। ");
INSERT INTO pan_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","ਫੇਰ ਉਸ ਨੇ ਆਖਿਆ, ਪ੍ਰਭੂ ਕ੍ਰੋਧਵਾਨ ਨਾ ਹੋਵੇ ਤਾਂ ਮੈਂ ਇੱਕੋ ਹੀ ਵਾਰ ਫੇਰ ਗੱਲ ਕਰਾਂਗਾ। ਸ਼ਾਇਦ ਉੱਥੇ ਦਸ ਲੱਭਣ ਤਦ ਉਸ ਨੇ ਆਖਿਆ, ਮੈਂ ਉਨ੍ਹਾਂ ਦਸਾਂ ਦੇ ਕਾਰਨ ਨਗਰ ਨੂੰ ਨਸ਼ਟ ਨਹੀਂ ਕਰਾਂਗਾ। ");
INSERT INTO pan_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","ਜਦ ਯਹੋਵਾਹ ਅਬਰਾਹਾਮ ਨਾਲ ਗੱਲਾਂ ਕਰ ਚੁੱਕਿਆ ਤਦ ਉਹ ਚੱਲਿਆ ਗਿਆ ਅਤੇ ਅਬਰਾਹਾਮ ਆਪਣੀ ਥਾਂ ਨੂੰ ਮੁੜ ਗਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","ਸ਼ਾਮ ਨੂੰ ਦੋ ਦੂਤ ਸਦੂਮ ਨੂੰ ਆਏ ਅਤੇ ਲੂਤ ਸਦੂਮ ਸ਼ਹਿਰ ਦੇ ਫਾਟਕ ਵਿੱਚ ਬੈਠਾ ਹੋਇਆ ਸੀ, ਲੂਤ ਉਨ੍ਹਾਂ ਨੂੰ ਵੇਖ ਕੇ ਮਿਲਣ ਲਈ ਉੱਠਿਆ ਅਤੇ ਉਹ ਨੇ ਆਪਣਾ ਮੂੰਹ ਧਰਤੀ ਤੱਕ ਝੁਕਾਇਆ। ");
INSERT INTO pan_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","ਉਸ ਨੇ ਆਖਿਆ, ਵੇਖੋ, ਮੇਰੇ ਪ੍ਰਭੂਓ ਤੁਸੀਂ ਆਪਣੇ ਦਾਸ ਦੇ ਘਰ ਵੱਲ ਮੁੜੋ ਅਤੇ ਰਾਤ ਠਹਿਰੋ ਅਤੇ ਆਪਣੇ ਪੈਰ ਧੋਵੋ, ਫੇਰ ਤੁਸੀਂ ਤੜਕੇ ਉੱਠ ਕੇ ਆਪਣੇ ਰਾਹ ਚਲੇ ਜਾਣਾ। ਪਰ ਉਨ੍ਹਾਂ ਨੇ ਆਖਿਆ, ਨਹੀਂ, ਅਸੀਂ ਚੌਂਕ ਵਿੱਚ ਰਾਤ ਕੱਟਾਂਗੇ। ");
INSERT INTO pan_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","ਜਦ ਉਸ ਨੇ ਉਨ੍ਹਾਂ ਦੇ ਅੱਗੇ ਬਹੁਤ ਮਿੰਨਤ ਕੀਤੀ ਤਾਂ ਓਹ ਉਸ ਦੇ ਨਾਲ ਉਸ ਦੇ ਘਰ ਗਏ ਅਤੇ ਉਸ ਨੇ ਉਨ੍ਹਾਂ ਦੀ ਮੇਜ਼ਬਾਨੀ ਕੀਤੀ ਅਤੇ ਪਤੀਰੀ ਰੋਟੀ ਪਕਾਈ ਅਤੇ ਉਨ੍ਹਾਂ ਨੇ ਖਾਧੀ। ");
INSERT INTO pan_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","ਪਰ ਉਨ੍ਹਾਂ ਦੇ ਲੰਮੇ ਪੈਣ ਤੋਂ ਪਹਿਲਾਂ, ਸਦੂਮ ਨਗਰ ਦੇ ਸਾਰੇ ਮਨੁੱਖਾਂ ਨੇ ਕੀ ਜਵਾਨ, ਕੀ ਬੁੱਢਾ ਚਾਰੇ ਪਾਸਿਓਂ ਉਸ ਘਰ ਨੂੰ ਘੇਰ ਲਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","ਅਤੇ ਉਨ੍ਹਾਂ ਨੇ ਲੂਤ ਨੂੰ ਅਵਾਜ਼ ਮਾਰ ਕੇ ਆਖਿਆ, ਓਹ ਮਨੁੱਖ ਕਿੱਥੇ ਹਨ ਜੋ ਅੱਜ ਰਾਤ ਤੇਰੇ ਕੋਲ ਆਏ ਹਨ? ਉਨ੍ਹਾਂ ਨੂੰ ਸਾਡੇ ਕੋਲ ਬਾਹਰ ਲਿਆ ਤਾਂ ਜੋ ਅਸੀਂ ਉਨ੍ਹਾਂ ਨਾਲ ਸੰਗ ਕਰੀਏ। ");
INSERT INTO pan_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","ਤਦ ਲੂਤ ਉਨ੍ਹਾਂ ਦੇ ਕੋਲ ਦਰਵਾਜ਼ੇ ਵਿੱਚੋਂ ਬਾਹਰ ਗਿਆ ਅਤੇ ਦਰਵਾਜ਼ਾ ਆਪਣੇ ਪਿੱਛੇ ਬੰਦ ਕਰ ਲਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","ਤਦ ਉਸ ਨੇ ਆਖਿਆ, ਮੇਰੇ ਭਰਾਵੋ, ਇਹ ਬੁਰਿਆਈ ਨਾ ਕਰੋ। ");
INSERT INTO pan_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","ਵੇਖੋ ਮੇਰੀਆਂ ਦੋ ਧੀਆਂ ਹਨ, ਜਿਨ੍ਹਾਂ ਨੇ ਕਿਸੇ ਮਨੁੱਖ ਨਾਲ ਸੰਗ ਨਹੀਂ ਕੀਤਾ l ਮੈਂ ਉਨ੍ਹਾਂ ਨੂੰ ਤੁਹਾਡੇ ਕੋਲ ਲੈ ਆਉਂਦਾ ਹਾਂ ਤਾਂ ਉਨ੍ਹਾਂ ਨਾਲ ਜਿਵੇਂ ਤੁਹਾਡੀ ਨਿਗਾਹ ਵਿੱਚ ਚੰਗਾ ਹੋਵੇ ਉਸੇ ਤਰ੍ਹਾਂ ਕਰੋ, ਪਰ ਇਨ੍ਹਾਂ ਮਨੁੱਖਾਂ ਨਾਲ ਅਜਿਹਾ ਕੁਝ ਨਾ ਕਰੋ ਕਿਉਂ ਜੋ ਓਹ ਮੇਰੀ ਛੱਤ ਹੇਠ ਆਏ ਹਨ। ");
INSERT INTO pan_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","ਪਰ ਉਨ੍ਹਾਂ ਨੇ ਆਖਿਆ, ਪਿੱਛੇ ਹੱਟ ਜਾ, ਉਨ੍ਹਾਂ ਨੇ ਇਹ ਵੀ ਆਖਿਆ ਇਹ ਪਰਦੇਸੀ ਹੋ ਕੇ ਵੱਸਣ ਲਈ ਆਇਆ ਸੀ, ਹੁਣ ਨਿਆਈਂ ਬਣ ਬੈਠਾ ਹੈ। ਅਸੀਂ ਤੇਰੇ ਨਾਲ ਉਨ੍ਹਾਂ ਨਾਲੋਂ ਵੱਧ ਬੁਰਿਆਈ ਕਰਾਂਗੇ। ਫੇਰ ਉਨ੍ਹਾਂ ਨੇ ਲੂਤ ਨੂੰ ਬਹੁਤ ਤੰਗ ਕੀਤਾ ਅਤੇ ਦਰਵਾਜ਼ੇ ਨੂੰ ਭੰਨਣ ਲਈ ਨੇੜੇ ਆਏ। ");
INSERT INTO pan_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","ਤਦ ਉਨ੍ਹਾਂ ਮਨੁੱਖਾਂ ਨੇ ਹੱਥ ਵਧਾ ਕੇ ਲੂਤ ਨੂੰ ਆਪਣੇ ਕੋਲ ਘਰ ਵਿੱਚ ਖਿੱਚ ਲਿਆ ਅਤੇ ਦਰਵਾਜ਼ੇ ਨੂੰ ਬੰਦ ਕਰ ਲਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","ਜਿਹੜੇ ਮਨੁੱਖ ਬੂਹੇ ਦੇ ਅੱਗੇ ਸਨ ਉਨ੍ਹਾਂ ਨੇ ਉਨ੍ਹਾਂ ਨੂੰ, ਕੀ ਛੋਟਾ ਕੀ ਵੱਡਾ ਅੰਨ੍ਹੇ ਕਰ ਦਿੱਤਾ ਇੱਥੋਂ ਤੱਕ ਕਿ ਓਹ ਦਰਵਾਜ਼ਾ ਲੱਭਦੇ-ਲੱਭਦੇ ਥੱਕ ਗਏ। ");
INSERT INTO pan_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","ਤਦ ਉਹਨਾਂ ਮਨੁੱਖਾਂ ਨੇ ਲੂਤ ਨੂੰ ਆਖਿਆ, ਇੱਥੇ ਤੇਰੇ ਕੋਲ ਹੋਰ ਕੌਣ ਹੈ? ਆਪਣੇ ਜਵਾਈਆਂ, ਪੁੱਤਰਾਂ, ਧੀਆਂ ਨੂੰ ਅਤੇ ਉਹ ਸਭ ਕੁਝ ਜੋ ਤੇਰਾ ਇਸ ਨਗਰ ਵਿੱਚ ਹੈ, ਲੈ ਕੇ ਬਾਹਰ ਨਿੱਕਲ ਜਾ। ");
INSERT INTO pan_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","ਕਿਉਂਕਿ ਅਸੀਂ ਇਸ ਸਥਾਨ ਨੂੰ ਨਸ਼ਟ ਕਰਨ ਵਾਲੇ ਹਾਂ ਕਿਉਂ ਜੋ ਉਹਨਾਂ ਦੀ ਬੁਰਿਆਈ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਬਹੁਤ ਵੱਧ ਗਈ ਹੈ ਅਤੇ ਯਹੋਵਾਹ ਨੇ ਸਾਨੂੰ ਇਹਨਾਂ ਦਾ ਨਾਸ ਕਰਨ ਲਈ ਭੇਜਿਆ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","ਉਪਰੰਤ ਲੂਤ ਨੇ ਬਾਹਰ ਜਾ ਕੇ ਆਪਣੇ ਜਵਾਈਆਂ ਨਾਲ ਜਿਨ੍ਹਾਂ ਨਾਲ ਉਸ ਦੀਆਂ ਧੀਆਂ ਦੀ ਮੰਗਣੀ ਹੋਈ ਸੀ ਗੱਲ ਕੀਤੀ ਅਤੇ ਆਖਿਆ, ਉੱਠੋ ਇਸ ਨਗਰ ਤੋਂ ਨਿੱਕਲ ਜਾਓ ਕਿਉਂਕਿ ਯਹੋਵਾਹ ਇਸ ਨਗਰ ਨੂੰ ਨਸ਼ਟ ਕਰਨ ਵਾਲਾ ਹੈ, ਪਰ ਉਹ ਆਪਣੇ ਜਵਾਈਆਂ ਦੀਆਂ ਨਜ਼ਰਾਂ ਵਿੱਚ ਮਖ਼ੌਲੀਆ ਜਿਹਾ ਜਾਪਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","ਜਦ ਸਵੇਰ ਹੋਈ ਤਾਂ ਉਹਨਾਂ ਦੂਤਾਂ ਨੇ ਲੂਤ ਨੂੰ ਛੇਤੀ ਕਰਾਈ ਅਤੇ ਕਿਹਾ, ਉੱਠ, ਆਪਣੀ ਪਤਨੀ ਅਤੇ ਦੋਹਾਂ ਧੀਆਂ ਨੂੰ ਜਿਹੜੀਆਂ ਇੱਥੇ ਹਨ ਲੈ ਜਾ, ਅਜਿਹਾ ਨਾ ਹੋਵੇ ਕਿ ਤੂੰ ਵੀ ਇਸ ਨਗਰ ਦੇ ਅਪਰਾਧ ਵਿੱਚ ਭਸਮ ਹੋ ਜਾਵੇਂ। ");
INSERT INTO pan_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","ਜਦ ਉਹ ਦੇਰੀ ਕਰ ਰਿਹਾ ਸੀ, ਤਾਂ ਉਨ੍ਹਾਂ ਮਨੁੱਖਾਂ ਨੇ ਯਹੋਵਾਹ ਦੀ ਕਿਰਪਾ ਦੇ ਕਾਰਨ ਜੋ ਉਸ ਦੇ ਉੱਤੇ ਸੀ, ਉਹ ਦੇ ਹੱਥ, ਅਤੇ ਉਹ ਦੀ ਪਤਨੀ ਦੇ ਹੱਥ, ਅਤੇ ਉਹ ਦੀਆਂ ਦੋਹਾਂ ਧੀਆਂ ਦੇ ਹੱਥਾਂ ਨੂੰ ਫੜ੍ਹ ਕੇ ਉਨ੍ਹਾਂ ਨੂੰ ਨਗਰ ਤੋਂ ਬਾਹਰ ਪਹੁੰਚਾ ਦਿੱਤਾ। ");
INSERT INTO pan_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","ਅਜਿਹਾ ਹੋਇਆ ਕਿ ਜਦ ਓਹ ਉਨ੍ਹਾਂ ਨੂੰ ਬਾਹਰ ਲੈ ਆਏ ਤਾਂ ਉਸ ਨੂੰ ਆਖਿਆ, ਆਪਣੀ ਜਾਨ ਬਚਾ ਕੇ ਭੱਜ ਜਾ, ਪਿੱਛੇ ਮੁੜ ਕੇ ਨਾ ਵੇਖੀਂ ਅਤੇ ਸਾਰੀ ਘਾਟੀ ਵਿੱਚ ਕਿਤੇ ਨਾ ਠਹਿਰੀਂ। ਪਰਬਤ ਨੂੰ ਭੱਜ ਜਾ, ਅਜਿਹਾ ਨਾ ਹੋਵੇ ਕਿ ਤੂੰ ਵੀ ਭਸਮ ਹੋ ਜਾਵੇਂ। ");
INSERT INTO pan_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","ਪਰ ਲੂਤ ਨੇ ਉਨ੍ਹਾਂ ਨੂੰ ਆਖਿਆ, ਹੇ ਮੇਰੇ ਪ੍ਰਭੂਓ, ਅਜਿਹਾ ਨਾ ਕਰਨਾ। ");
INSERT INTO pan_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","ਵੇਖੋ, ਤੁਹਾਡੇ ਦਾਸ ਉੱਤੇ ਤੁਹਾਡੀ ਕਿਰਪਾ ਦੀ ਨਜ਼ਰ ਹੋਈ ਹੈ, ਅਤੇ ਤੁਸੀਂ ਬਹੁਤ ਦਯਾ ਕੀਤੀ ਜੋ ਮੇਰੀ ਜਾਨ ਨੂੰ ਬਚਾਇਆ ਹੈ, ਪਰ ਮੈਂ ਪਰਬਤ ਤੱਕ ਨਹੀਂ ਭੱਜ ਸਕਦਾ, ਅਜਿਹਾ ਨਾ ਹੋਵੇ ਕਿ ਮੇਰੇ ਉੱਤੇ ਕੋਈ ਬਿਪਤਾ ਆ ਪਵੇ ਅਤੇ ਮੈਂ ਮਰ ਜਾਂਵਾਂ। ");
INSERT INTO pan_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","ਵੇਖੋ, ਉਹ ਨਗਰ ਭੱਜਣ ਲਈ ਨੇੜੇ ਹੈ ਅਤੇ ਉਹ ਛੋਟਾ ਵੀ ਹੈ। ਮੈਨੂੰ ਉੱਥੇ ਭੱਜ ਜਾਣ ਦਿਓ। ਕੀ ਉਹ ਨਗਰ ਛੋਟਾ ਨਹੀਂ ਹੈ? ਇਸ ਤਰ੍ਹਾਂ ਮੇਰੀ ਜਾਨ ਬਚ ਜਾਵੇਗੀ। ");
INSERT INTO pan_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","ਉਸ ਨੇ ਉਹ ਨੂੰ ਆਖਿਆ, ਵੇਖ, ਮੈਂ ਤੇਰੀ ਇਸ ਗੱਲ ਨੂੰ ਵੀ ਮੰਨ ਲਿਆ ਹੈ ਅਤੇ ਮੈਂ ਉਸ ਨਗਰ ਨੂੰ ਜਿਹ ਦੇ ਵਿਖੇ ਤੂੰ ਗੱਲ ਕੀਤੀ ਹੈ, ਨਾਸ ਨਾ ਕਰਾਂਗਾ। ");
INSERT INTO pan_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","ਛੇਤੀ ਕਰ, ਉੱਥੇ ਨੂੰ ਭੱਜ ਜਾ ਕਿਉਂਕਿ ਜਦ ਤੱਕ ਤੂੰ ਉੱਥੇ ਨਾ ਪਹੁੰਚੇ ਮੈਂ ਕੁਝ ਨਹੀਂ ਕਰ ਸਕਦਾ। ਇਸ ਕਾਰਨ ਉਸ ਨਗਰ ਦਾ ਨਾਮ ਸੋਆਰ ਰੱਖਿਆ ਗਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","ਸੂਰਜ ਅਜੇ ਚੜ੍ਹਿਆ ਹੀ ਸੀ, ਜਦ ਲੂਤ ਸੋਆਰ ਵਿੱਚ ਜਾ ਵੜਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","ਤਦ ਯਹੋਵਾਹ ਨੇ ਸਦੂਮ ਅਤੇ ਅਮੂਰਾਹ ਉੱਤੇ ਗੰਧਕ ਅਤੇ ਅੱਗ ਅਕਾਸ਼ ਤੋਂ ਬਰਸਾਈ ");
INSERT INTO pan_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","ਅਤੇ ਉਸ ਨੇ ਉਨ੍ਹਾਂ ਨਗਰਾਂ ਨੂੰ, ਅਤੇ ਸਾਰੀ ਘਾਟੀ ਨੂੰ, ਅਤੇ ਨਗਰ ਦੇ ਵਸਨੀਕਾਂ ਨੂੰ ਅਤੇ ਜ਼ਮੀਨ ਦੀ ਸਾਰੀ ਉਪਜ ਨੂੰ ਨਸ਼ਟ ਕਰ ਸੁੱਟਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","ਪਰ ਲੂਤ ਦੀ ਪਤਨੀ ਨੇ ਜੋ ਉਸ ਦੇ ਪਿੱਛੇ ਸੀ, ਉਸ ਨੇ ਪਿੱਛੇ ਮੁੜ ਕੇ ਵੇਖਿਆ ਤਾਂ ਉਹ ਲੂਣ ਦਾ ਥੰਮ੍ਹ ਬਣ ਗਈ। ");
INSERT INTO pan_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","ਅਬਰਾਹਾਮ ਸਵੇਰੇ ਹੀ ਉੱਠ ਕੇ ਉਸ ਸਥਾਨ ਨੂੰ ਗਿਆ, ਜਿੱਥੇ ਉਹ ਯਹੋਵਾਹ ਦੇ ਸਨਮੁਖ ਖੜ੍ਹਾ ਹੋਇਆ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","ਜਦ ਉਸ ਨੇ ਸਦੂਮ ਅਤੇ ਅਮੂਰਾਹ ਵੱਲ ਅਤੇ ਘਾਟੀ ਦੇ ਸਾਰੇ ਦੇਸ਼ ਵੱਲ ਵੇਖਿਆ ਤਾਂ ਵੇਖੋ, ਧਰਤੀ ਤੋਂ ਧੂੰਆਂ ਭੱਠੀ ਦੇ ਧੂੰਏਂ ਵਾਂਗੂੰ ਉੱਠ ਰਿਹਾ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","ਅਜਿਹਾ ਹੋਇਆ ਕਿ ਜਦ ਪਰਮੇਸ਼ੁਰ ਨੇ ਉਸ ਘਾਟੀ ਦੇ ਨਗਰਾਂ ਨੂੰ ਜਿਸ ਵਿੱਚ ਲੂਤ ਰਹਿੰਦਾ ਸੀ, ਨਸ਼ਟ ਕੀਤਾ ਤਦ ਪਰਮੇਸ਼ੁਰ ਨੇ ਅਬਰਾਹਾਮ ਨੂੰ ਯਾਦ ਕਰਕੇ ਲੂਤ ਨੂੰ ਉਸ ਬਰਬਾਦੀ ਤੋਂ ਬਚਾ ਲਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","ਫੇਰ ਲੂਤ ਨੇ ਸੋਆਰ ਨਗਰ ਨੂੰ ਛੱਡ ਦਿੱਤਾ ਅਤੇ ਉੱਪਰ ਜਾ ਕੇ ਆਪਣੀਆਂ ਦੋਹਾਂ ਧੀਆਂ ਸਮੇਤ ਪਰਬਤ ਉੱਤੇ ਵੱਸ ਗਿਆ ਕਿਉਂ ਜੋ ਉਹ ਸੋਆਰ ਵਿੱਚ ਵੱਸਣ ਤੋਂ ਡਰਦਾ ਸੀ, ਇਸ ਲਈ ਉਹ ਅਤੇ ਉਹ ਦੀਆਂ ਦੋਵੇਂ ਧੀਆਂ ਇੱਕ ਗੁਫ਼ਾ ਵਿੱਚ ਰਹਿਣ ਲੱਗ ਪਏ। ");
INSERT INTO pan_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","ਤਦ ਵੱਡੀ ਧੀ ਨੇ ਛੋਟੀ ਨੂੰ ਆਖਿਆ, ਸਾਡਾ ਪਿਤਾ ਬੁੱਢਾ ਹੈ ਅਤੇ ਧਰਤੀ ਉੱਤੇ ਕੋਈ ਮਨੁੱਖ ਨਹੀਂ ਹੈ, ਜੋ ਸੰਸਾਰ ਦੀ ਰੀਤ ਅਨੁਸਾਰ ਸਾਡੇ ਕੋਲ ਅੰਦਰ ਆਵੇ। ");
INSERT INTO pan_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","ਇਸ ਲਈ ਆ, ਅਸੀਂ ਆਪਣੇ ਪਿਤਾ ਨੂੰ ਮਧ ਪਿਲਾਈਏ ਅਤੇ ਉਸ ਦੇ ਸੰਗ ਲੇਟੀਏ, ਤਾਂ ਜੋ ਅਸੀਂ ਆਪਣੇ ਪਿਤਾ ਦੀ ਅੰਸ ਨੂੰ ਕਾਇਮ ਰੱਖ ਸਕੀਏ। ");
INSERT INTO pan_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","ਫਿਰ ਉਨ੍ਹਾਂ ਨੇ ਆਪਣੇ ਪਿਤਾ ਨੂੰ ਉਸੇ ਰਾਤ ਮਧ ਪਿਲਾਈ ਅਤੇ ਵੱਡੀ ਧੀ ਜਾ ਕੇ ਆਪਣੇ ਪਿਤਾ ਦੇ ਸੰਗ ਲੇਟੀ ਪਰ ਲੂਤ ਨੇ ਉਹ ਦਾ ਲੇਟਣਾ ਅਤੇ ਉੱਠਣਾ ਨਹੀਂ ਜਾਣਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","ਅਗਲੇ ਦਿਨ ਅਜਿਹਾ ਹੋਇਆ ਕਿ ਵੱਡੀ ਧੀ ਨੇ ਛੋਟੀ ਨੂੰ ਆਖਿਆ, ਵੇਖ, ਮੈਂ ਕੱਲ ਰਾਤ ਆਪਣੇ ਪਿਤਾ ਦੇ ਸੰਗ ਲੇਟੀ। ਅਸੀਂ ਅੱਜ ਰਾਤ ਵੀ ਉਹ ਨੂੰ ਮਧ ਪਿਲਾਈਏ ਅਤੇ ਤੂੰ ਜਾ ਕੇ ਉਹ ਦੇ ਸੰਗ ਲੇਟ ਅਤੇ ਤਾਂ ਜੋ ਅਸੀਂ ਆਪਣੇ ਪਿਤਾ ਦੀ ਅੰਸ ਨੂੰ ਕਾਇਮ ਰੱਖ ਸਕੀਏ। ");
INSERT INTO pan_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","ਸੋ ਉਨ੍ਹਾਂ ਨੇ ਉਸ ਰਾਤ ਵੀ ਆਪਣੇ ਪਿਤਾ ਨੂੰ ਮਧ ਪਿਲਾਈ ਅਤੇ ਛੋਟੀ ਧੀ ਜਾ ਕੇ ਆਪਣੇ ਪਿਤਾ ਦੇ ਸੰਗ ਲੇਟੀ ਪਰ ਉਸ ਨੇ ਉਹ ਦਾ ਲੇਟਣਾ ਅਤੇ ਉੱਠਣਾ ਨਹੀਂ ਜਾਣਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","ਇਸ ਤਰ੍ਹਾਂ ਲੂਤ ਦੀਆਂ ਦੋਵੇਂ ਧੀਆਂ ਆਪਣੇ ਪਿਤਾ ਤੋਂ ਗਰਭਵਤੀ ਹੋਈਆਂ, ");
INSERT INTO pan_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","ਅਤੇ ਵੱਡੀ ਧੀ ਨੇ ਇੱਕ ਪੁੱਤਰ ਜਣਿਆ ਅਤੇ ਉਸ ਦਾ ਨਾਮ ਮੋਆਬ ਰੱਖਿਆ। ਉਹ ਅੱਜ ਤੱਕ ਮੋਆਬੀਆਂ ਦਾ ਪਿਤਾ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","ਛੋਟੀ ਧੀ ਵੀ ਇੱਕ ਪੁੱਤਰ ਜਣੀ ਅਤੇ ਉਸ ਨੇ ਉਹ ਦਾ ਨਾਮ ਬਿਨ-ਅੰਮੀ ਰੱਖਿਆ। ਉਹ ਅੱਜ ਤੱਕ ਅੰਮੋਨੀਆਂ ਦਾ ਪਿਤਾ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","ਤਦ ਅਬਰਾਹਾਮ ਨੇ ਉੱਥੋਂ ਦੱਖਣ ਦੇਸ਼ ਵੱਲ ਕੂਚ ਕੀਤਾ ਅਤੇ ਕਾਦੇਸ਼ ਅਤੇ ਸ਼ੂਰ ਦੇ ਵਿਚਕਾਰ ਠਹਿਰਿਆ ਅਤੇ ਗਰਾਰ ਵਿੱਚ ਜਾ ਵੱਸਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","ਅਬਰਾਹਾਮ ਨੇ ਆਪਣੀ ਪਤਨੀ ਸਾਰਾਹ ਦੇ ਵਿਖੇ ਆਖਿਆ, ਇਹ ਮੇਰੀ ਭੈਣ ਹੈ, ਇਸ ਲਈ ਗਰਾਰ ਦੇ ਰਾਜਾ ਅਬੀਮਲਕ ਨੇ ਆਦਮੀ ਭੇਜ ਕੇ ਸਾਰਾਹ ਨੂੰ ਬੁਲਾ ਲਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","ਪਰਮੇਸ਼ੁਰ ਨੇ ਅਬੀਮਲਕ ਕੋਲ ਰਾਤ ਦੇ ਸੁਫ਼ਨੇ ਵਿੱਚ ਆ ਕੇ ਉਸ ਨੂੰ ਆਖਿਆ, ਵੇਖ, ਤੂੰ ਇਸ ਇਸਤਰੀ ਦੇ ਕਾਰਨ ਜਿਸ ਨੂੰ ਤੂੰ ਲਿਆ ਹੈ, ਮਰਨ ਵਾਲਾ ਹੈਂ, ਕਿਉਂ ਜੋ ਉਹ ਵਿਆਹੀ ਹੋਈ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","ਪਰ ਅਜੇ ਅਬੀਮਲਕ ਸਾਰਾਹ ਦੇ ਕੋਲ ਨਹੀਂ ਗਿਆ ਸੀ, ਇਸ ਲਈ ਉਸ ਨੇ ਆਖਿਆ, ਹੇ ਪ੍ਰਭੂ, ਕੀ ਤੂੰ ਇੱਕ ਧਰਮੀ ਕੌਮ ਨੂੰ ਵੀ ਮਾਰ ਸੁੱਟੇਂਗਾ? ");
INSERT INTO pan_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","ਕੀ ਉਸ ਨੇ ਆਪ ਹੀ ਮੈਨੂੰ ਨਹੀਂ ਆਖਿਆ, ਇਹ ਮੇਰੀ ਭੈਣ ਹੈ? ਅਤੇ ਕੀ ਉਸ ਇਸਤਰੀ ਨੇ ਵੀ ਆਪ ਹੀ ਨਹੀਂ ਆਖਿਆ, ਉਹ ਮੇਰਾ ਭਰਾ ਹੈ? ਮੈਂ ਤਾਂ ਆਪਣੇ ਦਿਲ ਦੀ ਖਰਿਆਈ ਅਤੇ ਆਪਣੇ ਹੱਥਾਂ ਦੀ ਸਚਿਆਈ ਨਾਲ ਇਹ ਕੰਮ ਕੀਤਾ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","ਪਰਮੇਸ਼ੁਰ ਨੇ ਸੁਫ਼ਨੇ ਵਿੱਚ ਉਹ ਨੂੰ ਆਖਿਆ, ਹਾਂ, ਮੈਂ ਜਾਣਦਾ ਹਾਂ ਕਿ ਤੂੰ ਆਪਣੇ ਦਿਲ ਦੀ ਖਰਿਆਈ ਨਾਲ ਇਹ ਕੰਮ ਕੀਤਾ ਹੈ ਇਸ ਕਾਰਨ ਮੈਂ ਵੀ ਤੈਨੂੰ ਆਪਣੇ ਵਿਰੁੱਧ ਪਾਪ ਕਰਨ ਤੋਂ ਰੋਕਿਆ ਹੈ ਅਤੇ ਮੈਂ ਤੈਨੂੰ ਉਸ ਨੂੰ ਹੱਥ ਲਾਉਣ ਨਹੀਂ ਦਿੱਤਾ। ");
INSERT INTO pan_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","ਹੁਣ ਤੂੰ ਉਸ ਮਨੁੱਖ ਨੂੰ ਉਹ ਦੀ ਪਤਨੀ ਮੋੜ ਦੇ ਕਿਉਂ ਜੋ ਉਹ ਨਬੀ ਹੈ, ਉਹ ਤੇਰੇ ਲਈ ਬੇਨਤੀ ਕਰੇਗਾ ਅਤੇ ਤੂੰ ਜੀਉਂਦਾ ਰਹੇਂਗਾ ਪਰ ਜੇ ਤੂੰ ਉਸ ਨੂੰ ਨਾ ਮੋੜੇਂ ਤਾਂ ਜਾਣ ਲੈ ਕਿ ਤੂੰ ਅਤੇ ਤੇਰੇ ਸਾਰੇ ਲੋਕ ਜ਼ਰੂਰ ਮਰਨਗੇ। ");
INSERT INTO pan_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","ਅਬੀਮਲਕ ਸਵੇਰੇ ਹੀ ਉੱਠਿਆ ਅਤੇ ਆਪਣੇ ਸਾਰੇ ਕਰਮਚਾਰੀਆਂ ਨੂੰ ਬੁਲਾ ਕੇ ਉਨ੍ਹਾਂ ਨੂੰ ਇਹ ਸਾਰੀਆਂ ਗੱਲਾਂ ਦੱਸੀਆਂ ਤਦ ਉਹ ਸਾਰੇ ਲੋਕ ਬਹੁਤ ਹੀ ਡਰ ਗਏ। ");
INSERT INTO pan_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","ਤਦ ਅਬੀਮਲਕ ਨੇ ਅਬਰਾਹਾਮ ਨੂੰ ਬੁਲਵਾ ਕੇ ਆਖਿਆ, ਤੂੰ ਸਾਡੇ ਨਾਲ ਇਹ ਕੀ ਕੀਤਾ ਹੈ? ਮੈਂ ਤੇਰਾ ਕੀ ਵਿਗਾੜਿਆ ਸੀ ਕਿ ਤੂੰ ਮੇਰੇ ਅਤੇ ਮੇਰੇ ਰਾਜ ਉੱਤੇ ਇਹ ਵੱਡਾ ਪਾਪ ਲੈ ਆਂਦਾ ਹੈਂ? ਤੂੰ ਮੇਰੇ ਨਾਲ ਉਹ ਕੰਮ ਕੀਤਾ ਹੈ, ਜੋ ਤੈਨੂੰ ਨਹੀਂ ਕਰਨਾ ਚਾਹੀਦਾ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","ਫਿਰ ਅਬੀਮਲਕ ਨੇ ਅਬਰਾਹਾਮ ਨੂੰ ਪੁੱਛਿਆ, ਤੂੰ ਕੀ ਸੋਚ ਕੇ ਇਹ ਕੰਮ ਕੀਤਾ? ");
INSERT INTO pan_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","ਅਬਰਾਹਾਮ ਨੇ ਆਖਿਆ, ਮੈਂ ਸੋਚਿਆ ਕਿ ਜ਼ਰੂਰ ਹੀ ਇਸ ਸਥਾਨ ਵਿੱਚ ਪਰਮੇਸ਼ੁਰ ਦਾ ਕੋਈ ਡਰ ਨਹੀਂ ਹੋਵੇਗਾ, ਇਸ ਲਈ ਇਹ ਲੋਕ ਮੇਰੀ ਪਤਨੀ ਦੇ ਕਾਰਨ ਮੈਨੂੰ ਮਾਰ ਸੁੱਟਣਗੇ। ");
INSERT INTO pan_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","ਪਰ ਉਹ ਸੱਚ-ਮੁੱਚ ਮੇਰੀ ਭੈਣ ਹੈ, ਕਿਉਂ ਜੋ ਉਹ ਮੇਰੇ ਪਿਤਾ ਦੀ ਧੀ ਹੈ ਪਰ ਮੇਰੀ ਮਾਤਾ ਦੀ ਧੀ ਨਹੀਂ ਹੈ, ਫੇਰ ਉਹ ਮੇਰੀ ਪਤਨੀ ਹੋ ਗਈ। ");
INSERT INTO pan_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","ਜਦ ਪਰਮੇਸ਼ੁਰ ਨੇ ਮੈਨੂੰ ਮੇਰੇ ਪਿਤਾ ਦਾ ਘਰ ਛੱਡਣ ਦਾ ਹੁਕਮ ਦਿੱਤਾ, ਤਦ ਮੈਂ ਉਸ ਨੂੰ ਕਿਹਾ, ਤੈਨੂੰ ਮੇਰੇ ਉੱਤੇ ਇਹ ਦਯਾ ਕਰਨੀ ਹੋਵੇਗੀ ਕਿ ਜਿੱਥੇ ਕਿਤੇ ਅਸੀਂ ਜਾਈਏ, ਉੱਥੇ ਤੂੰ ਮੇਰੇ ਵਿਖੇ ਆਖੀਂ ਕਿ ਇਹ ਮੇਰਾ ਭਰਾ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","ਤਦ ਅਬੀਮਲਕ ਨੇ ਇੱਜੜ, ਪਸ਼ੂ ਅਤੇ ਦਾਸ-ਦਾਸੀਆਂ ਲੈ ਕੇ ਅਬਰਾਹਾਮ ਨੂੰ ਦਿੱਤੇ ਅਤੇ ਉਸ ਦੀ ਪਤਨੀ ਸਾਰਾਹ ਨੂੰ ਵੀ ਮੋੜ ਦਿੱਤਾ। ");
INSERT INTO pan_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","ਅਬੀਮਲਕ ਨੇ ਆਖਿਆ, ਵੇਖ, ਮੇਰਾ ਦੇਸ਼ ਤੇਰੇ ਸਾਹਮਣੇ ਹੈ। ਜਿੱਥੇ ਤੈਨੂੰ ਚੰਗਾ ਲੱਗੇ, ਤੂੰ ਉੱਥੇ ਵੱਸ। ");
INSERT INTO pan_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","ਸਾਰਾਹ ਨੂੰ ਉਸ ਨੇ ਆਖਿਆ, ਵੇਖ, ਮੈਂ ਤੇਰੇ ਭਰਾ ਨੂੰ ਇੱਕ ਹਜ਼ਾਰ ਚਾਂਦੀ ਦੇ ਸਿੱਕੇ ਦਿੱਤੇ ਹਨ। ਵੇਖ, ਉਹ ਤੇਰੇ ਲਈ ਅਤੇ ਸਾਰਿਆਂ ਲਈ ਜੋ ਤੇਰੇ ਸੰਗ ਹਨ, ਅੱਖਾਂ ਦਾ ਪਰਦਾ ਹੋਣਗੇ ਅਤੇ ਸਾਰਿਆਂ ਦੇ ਸਾਹਮਣੇ ਤੂੰ ਸਹੀ ਸਾਬਤ ਹੋਵੇਂਗੀ। ");
INSERT INTO pan_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","ਤਦ ਅਬਰਾਹਾਮ ਨੇ ਪਰਮੇਸ਼ੁਰ ਦੇ ਅੱਗੇ ਪ੍ਰਾਰਥਨਾ ਕੀਤੀ, ਅਤੇ ਪਰਮੇਸ਼ੁਰ ਨੇ ਅਬੀਮਲਕ ਅਤੇ ਉਸ ਦੀ ਪਤਨੀ ਅਤੇ ਉਸ ਦੀਆਂ ਦਾਸੀਆਂ ਨੂੰ ਚੰਗਾ ਕਰ ਦਿੱਤਾ ਅਤੇ ਓਹ ਫੇਰ ਜਣਨ ਲੱਗ ਪਈਆਂ। ");
INSERT INTO pan_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","ਕਿਉਂਕਿ ਯਹੋਵਾਹ ਨੇ ਅਬਰਾਹਾਮ ਦੀ ਪਤਨੀ ਸਾਰਾਹ ਦੇ ਕਾਰਨ ਅਬੀਮਲਕ ਦੇ ਘਰਾਣੇ ਦੀ ਹਰੇਕ ਇਸਤਰੀ ਦੀ ਕੁੱਖ ਨੂੰ ਸਖ਼ਤੀ ਨਾਲ ਬੰਦ ਕਰ ਦਿੱਤਾ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","ਯਹੋਵਾਹ ਨੇ ਜਿਵੇਂ ਆਖਿਆ ਸੀ, ਉਸੇ ਤਰ੍ਹਾਂ ਸਾਰਾਹ ਉੱਤੇ ਨਜ਼ਰ ਕੀਤੀ ਅਤੇ ਉਸ ਲਈ ਆਪਣੇ ਬਚਨ ਦੇ ਅਨੁਸਾਰ ਕੀਤਾ। ");
INSERT INTO pan_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","ਸਾਰਾਹ ਗਰਭਵਤੀ ਹੋਈ ਅਤੇ ਉਸੇ ਨਿਯੁਕਤ ਸਮੇਂ ਤੇ ਜੋ ਪਰਮੇਸ਼ੁਰ ਨੇ ਠਹਿਰਾਇਆ ਸੀ, ਅਬਰਾਹਾਮ ਲਈ ਉਸ ਦੇ ਬੁਢੇਪੇ ਵਿੱਚ ਇੱਕ ਪੁੱਤਰ ਨੂੰ ਜਨਮ ਦਿੱਤਾ। ");
INSERT INTO pan_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","ਅਬਰਾਹਾਮ ਨੇ ਆਪਣੇ ਪੁੱਤਰ ਦਾ ਨਾਮ ਜਿਸ ਨੂੰ ਸਾਰਾਹ ਨੇ ਜਨਮ ਦਿੱਤਾ ਸੀ, ਇਸਹਾਕ ਰੱਖਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","ਅਤੇ ਜਦ ਅਬਰਾਹਾਮ ਦਾ ਪੁੱਤਰ ਇਸਹਾਕ ਅੱਠ ਦਿਨ ਦਾ ਹੋ ਗਿਆ, ਤਦ ਉਸਨੇ ਪਰਮੇਸ਼ੁਰ ਦੇ ਹੁਕਮ ਅਨੁਸਾਰ ਉਸ ਦੀ ਸੁੰਨਤ ਕਰਾਈ। ");
INSERT INTO pan_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","ਅਬਰਾਹਾਮ ਸੌ ਸਾਲ ਦਾ ਸੀ, ਜਦ ਉਸ ਦਾ ਪੁੱਤਰ ਇਸਹਾਕ ਜੰਮਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","ਅਤੇ ਸਾਰਾਹ ਨੇ ਆਖਿਆ, ਪਰਮੇਸ਼ੁਰ ਨੇ ਮੈਨੂੰ ਅਨੰਦ ਕੀਤਾ ਹੈ ਅਤੇ ਸਾਰੇ ਸੁਣਨ ਵਾਲੇ ਮੇਰੇ ਨਾਲ ਅਨੰਦ ਮਨਾਉਣਗੇ। ");
INSERT INTO pan_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","ਉਸ ਨੇ ਆਖਿਆ, ਕੀ ਕੋਈ ਅਬਰਾਹਾਮ ਨੂੰ ਆਖ ਸਕਦਾ ਸੀ ਕਿ ਸਾਰਾਹ ਪੁੱਤਰਾਂ ਨੂੰ ਦੁੱਧ ਚੁੰਘਾਏਗੀ? ਵੇਖੋ ਕਿਉਂਕਿ ਮੈਂ ਉਸ ਦੇ ਬੁਢੇਪੇ ਵਿੱਚ ਇੱਕ ਪੁੱਤਰ ਨੂੰ ਜਨਮ ਦਿੱਤਾ। ");
INSERT INTO pan_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","ਉਹ ਮੁੰਡਾ ਵੱਧਦਾ ਗਿਆ ਅਤੇ ਉਹ ਦਾ ਦੁੱਧ ਛੁਡਾਇਆ ਗਿਆ ਅਤੇ ਅਬਰਾਹਾਮ ਨੇ ਇਸਹਾਕ ਦੇ ਦੁੱਧ ਛੁਡਾਉਣ ਦੇ ਦਿਨ ਵੱਡੀ ਦਾਵਤ ਕੀਤੀ। ");
INSERT INTO pan_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","ਸਾਰਾਹ ਨੇ ਹਾਜ਼ਰਾ ਦੇ ਪੁੱਤਰ ਨੂੰ ਜਿਸ ਨੂੰ ਉਹ ਨੇ ਅਬਰਾਹਾਮ ਲਈ ਜਨਮ ਦਿੱਤਾ ਸੀ ਮਖ਼ੌਲ ਕਰਦੇ ਹੋਏ ਵੇਖਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","ਇਸ ਲਈ ਉਸ ਨੇ ਅਬਰਾਹਾਮ ਨੂੰ ਆਖਿਆ, ਇਸ ਦਾਸੀ ਅਤੇ ਇਹ ਦੇ ਪੁੱਤਰ ਨੂੰ ਕੱਢ ਦੇ, ਕਿਉਂ ਜੋ ਇਸ ਦਾਸੀ ਦਾ ਪੁੱਤਰ ਮੇਰੇ ਪੁੱਤਰ ਇਸਹਾਕ ਨੇ ਨਾਲ ਵਾਰਿਸ ਨਹੀਂ ਹੋਵੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","ਆਪਣੇ ਪੁੱਤਰ ਦੇ ਕਾਰਨ ਅਬਰਾਹਾਮ ਦੀ ਨਿਗਾਹ ਵਿੱਚ ਇਹ ਗੱਲ ਬਹੁਤ ਬੁਰੀ ਲੱਗੀ। ");
INSERT INTO pan_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","ਪਰ ਪਰਮੇਸ਼ੁਰ ਨੇ ਅਬਰਾਹਾਮ ਨੂੰ ਆਖਿਆ, ਇਹ ਗੱਲ ਇਸ ਮੁੰਡੇ ਅਤੇ ਤੇਰੀ ਦਾਸੀ ਦੇ ਵਿਖੇ ਤੇਰੀ ਨਜ਼ਰ ਵਿੱਚ ਬੁਰੀ ਨਾ ਲੱਗੇ। ਜੋ ਕੁਝ ਸਾਰਾਹ ਨੇ ਤੈਨੂੰ ਆਖਿਆ ਹੈ ਤੂੰ ਉਹ ਦੀ ਮੰਨ ਕਿਉਂ ਜੋ ਤੇਰੀ ਅੰਸ ਇਸਹਾਕ ਤੋਂ ਹੀ ਪੁਕਾਰੀ ਜਾਵੇਗੀ। ");
INSERT INTO pan_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","ਮੈਂ ਉਸ ਦਾਸੀ ਦੇ ਪੁੱਤਰ ਤੋਂ ਵੀ ਇੱਕ ਕੌਮ ਬਣਾਵਾਂਗਾ ਕਿਉਂਕਿ ਉਹ ਵੀ ਤੇਰੀ ਅੰਸ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","ਤਦ ਅਬਰਾਹਾਮ ਸਵੇਰੇ ਜਲਦੀ ਉੱਠਿਆ, ਰੋਟੀ ਅਤੇ ਪਾਣੀ ਦੀ ਇੱਕ ਮੇਸ਼ੇਕ ਲੈ ਕੇ ਹਾਜ਼ਰਾ ਦੇ ਮੋਢਿਆਂ ਉੱਤੇ ਰੱਖ ਦਿੱਤੀ ਅਤੇ ਮੁੰਡਾ ਵੀ ਦੇ ਦਿੱਤਾ ਤਦ ਉਹ ਚਲੀ ਗਈ ਅਤੇ ਬਏਰਸ਼ਬਾ ਦੀ ਉਜਾੜ ਵਿੱਚ ਭਟਕਦੀ ਰਹੀ। ");
INSERT INTO pan_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","ਜਦ ਮੇਸ਼ੇਕ ਵਿੱਚੋਂ ਪਾਣੀ ਮੁੱਕ ਗਿਆ ਤਾਂ ਉਸ ਨੇ ਮੁੰਡੇ ਨੂੰ ਇੱਕ ਝਾੜੀ ਦੇ ਹੇਠ ਸੁੱਟ ਦਿੱਤਾ। ");
INSERT INTO pan_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","ਆਪ ਸਾਹਮਣੇ ਇੱਕ ਤੀਰ ਦੀ ਮਾਰ ਦੀ ਦੂਰੀ ਉੱਤੇ ਜਾ ਬੈਠੀ, ਕਿਉਂ ਜੋ ਉਸ ਨੇ ਆਖਿਆ, ਮੈਂ ਬੱਚੇ ਦੀ ਮੌਤ ਨਾ ਵੇਖਾਂ, ਸੋ ਉਹ ਸਾਹਮਣੇ ਦੂਰ ਬੈਠ ਕੇ ਉੱਚੀ-ਉੱਚੀ ਰੋਣ ਲੱਗ ਪਈ। ");
INSERT INTO pan_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","ਤਦ ਪਰਮੇਸ਼ੁਰ ਨੇ ਉਸ ਮੁੰਡੇ ਦੇ ਰੋਣ ਦੀ ਅਵਾਜ਼ ਸੁਣ ਲਈ ਅਤੇ ਪਰਮੇਸ਼ੁਰ ਦੇ ਦੂਤ ਨੇ ਅਕਾਸ਼ ਤੋਂ ਹਾਜ਼ਰਾ ਨੂੰ ਪੁਕਾਰ ਕੇ ਆਖਿਆ, ਹਾਜ਼ਰਾ ਤੈਨੂੰ ਕੀ ਹੋਇਆ? ਨਾ ਡਰ, ਕਿਉਂਕਿ ਪਰਮੇਸ਼ੁਰ ਨੇ ਮੁੰਡੇ ਦੀ ਅਵਾਜ਼ ਜਿੱਥੇ ਉਹ ਪਿਆ ਹੈ ਉੱਥੋਂ ਸੁਣ ਲਈ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","ਉੱਠ ਅਤੇ ਮੁੰਡੇ ਨੂੰ ਚੁੱਕ ਲੈ ਅਤੇ ਆਪਣੇ ਹੱਥਾਂ ਵਿੱਚ ਸਾਂਭ ਕਿਉਂਕਿ ਮੈਂ ਇਸ ਨੂੰ ਵੀ ਇੱਕ ਵੱਡੀ ਕੌਮ ਬਣਾਵਾਂਗਾ। ");
INSERT INTO pan_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","ਤਦ ਪਰਮੇਸ਼ੁਰ ਨੇ ਉਸ ਦੀਆਂ ਅੱਖਾਂ ਖੋਲ੍ਹੀਆਂ ਅਤੇ ਉਸ ਨੇ ਪਾਣੀ ਦਾ ਇੱਕ ਖੂਹ ਵੇਖਿਆ ਅਤੇ ਉਹ ਜਾ ਕੇ ਮੇਸ਼ੇਕ ਨੂੰ ਪਾਣੀ ਨਾਲ ਭਰ ਲੈ ਆਈ ਅਤੇ ਮੁੰਡੇ ਨੂੰ ਪਿਲਾਇਆ। ");
INSERT INTO pan_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","ਪਰਮੇਸ਼ੁਰ ਉਸ ਮੁੰਡੇ ਦੇ ਅੰਗ-ਸੰਗ ਸੀ ਅਤੇ ਉਹ ਵੱਧਦਾ ਗਿਆ, ਉਜਾੜ ਵਿੱਚ ਰਿਹਾ ਅਤੇ ਵੱਡਾ ਹੋ ਕੇ ਤੀਰ-ਅੰਦਾਜ਼ ਬਣਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","ਉਹ ਪਾਰਾਨ ਦੀ ਉਜਾੜ ਵਿੱਚ ਰਹਿੰਦਾ ਸੀ ਅਤੇ ਉਸ ਦੀ ਮਾਤਾ ਮਿਸਰ ਦੇਸ਼ ਵਿੱਚੋਂ ਇੱਕ ਪਤਨੀ ਉਸ ਦੇ ਲਈ ਲੈ ਆਈ। ");
INSERT INTO pan_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","ਫੇਰ ਉਸ ਸਮੇਂ ਅਜਿਹਾ ਹੋਇਆ ਕਿ ਅਬੀਮਲਕ ਅਤੇ ਉਸ ਦੀ ਸੈਨਾਂ ਦੇ ਸਰਦਾਰ ਫ਼ੀਕੋਲ ਨੇ ਅਬਰਾਹਾਮ ਨੂੰ ਆਖਿਆ ਕਿ ਜੋ ਕੁਝ ਤੂੰ ਕਰਦਾ ਹੈਂ, ਉਸ ਵਿੱਚ ਪਰਮੇਸ਼ੁਰ ਤੇਰੇ ਸੰਗ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","ਹੁਣ ਤੂੰ ਮੇਰੇ ਨਾਲ ਪਰਮੇਸ਼ੁਰ ਦੀ ਸਹੁੰ ਖਾਹ ਕਿ ਤੂੰ ਮੇਰੇ ਨਾਲ, ਮੇਰੇ ਪੁੱਤਰਾਂ, ਅਤੇ ਮੇਰੇ ਪੋਤਿਆਂ ਨਾਲ ਧੋਖਾ ਨਾ ਕਰੇਂਗਾ। ਸਗੋਂ ਉਸ ਕਿਰਪਾ ਦੇ ਅਨੁਸਾਰ ਜੋ ਮੈਂ ਤੇਰੇ ਉੱਤੇ ਕੀਤੀ ਹੈ, ਤੂੰ ਵੀ ਮੇਰੇ ਉੱਤੇ ਕਰੇਂਗਾ, ਇਸ ਦੇਸ਼ ਉੱਤੇ ਜਿਸ ਵਿੱਚ ਤੂੰ ਪਰਦੇਸੀ ਹੋ ਕੇ ਰਿਹਾ ਹੈਂ। ");
INSERT INTO pan_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","ਅਬਰਾਹਾਮ ਨੇ ਆਖਿਆ, ਮੈਂ ਸਹੁੰ ਖਾਵਾਂਗਾ। ");
INSERT INTO pan_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","ਤਦ ਅਬਰਾਹਾਮ ਨੇ ਅਬੀਮਲਕ ਨੂੰ ਇੱਕ ਖੂਹ ਦਾ ਉਲਾਂਭਾ ਦਿੱਤਾ, ਜਿਹੜਾ ਉਸ ਦੇ ਨੌਕਰਾਂ ਨੇ ਜ਼ੋਰ ਨਾਲ ਖੋਹ ਲਿਆ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","ਤਦ ਅਬੀਮਲਕ ਨੇ ਆਖਿਆ, ਮੈਨੂੰ ਪਤਾ ਨਹੀਂ ਕਿ ਇਹ ਕੰਮ ਕਿਸ ਨੇ ਕੀਤਾ ਅਤੇ ਤੂੰ ਵੀ ਮੈਨੂੰ ਨਹੀਂ ਦੱਸਿਆ। ਮੈਂ ਅੱਜ ਤੋਂ ਪਹਿਲਾਂ ਇਸ ਦੇ ਬਾਰੇ ਸੁਣਿਆ ਵੀ ਨਹੀਂ। ");
INSERT INTO pan_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","ਤਦ ਅਬਰਾਹਾਮ ਨੇ ਭੇਡਾਂ ਗਾਈਆਂ ਅਤੇ ਬਲ਼ਦ ਲੈ ਕੇ ਅਬੀਮਲਕ ਨੂੰ ਦੇ ਦਿੱਤੇ ਅਤੇ ਦੋਵਾਂ ਨੇ ਆਪੋ ਵਿੱਚ ਨੇਮ ਬੰਨਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","ਅਬਰਾਹਾਮ ਨੇ ਭੇਡਾਂ ਦੀਆਂ ਸੱਤ ਲੇਲੀਆਂ ਲੈ ਕੇ ਵੱਖਰੀਆਂ ਕਰ ਲਈਆਂ ");
INSERT INTO pan_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","ਤਦ ਅਬੀਮਲਕ ਨੇ ਅਬਰਾਹਾਮ ਨੂੰ ਪੁੱਛਿਆ, ਇਨ੍ਹਾਂ ਸੱਤਾਂ ਵੱਖਰੀਆਂ ਕੀਤੀਆਂ ਹੋਈਆਂ ਲੇਲੀਆਂ ਦਾ ਕੀ ਮਤਲਬ ਹੈ? ");
INSERT INTO pan_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","ਉਸ ਨੇ ਆਖਿਆ, ਤੂੰ ਇਹ ਸੱਤ ਲੇਲੀਆਂ ਮੇਰੇ ਹੱਥੋਂ ਲੈ ਲੈ ਤਾਂ ਜੋ ਇਹ ਮੇਰੀਆਂ ਗਵਾਹ ਹੋਣ ਭਈ ਇਹ ਖੂਹ ਮੈਂ ਪੁੱਟਿਆ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","ਕਿਉਂ ਜੋ ਉੱਥੇ ਉਨ੍ਹਾਂ ਦੋਹਾਂ ਨੇ ਸਹੁੰ ਖਾਧੀ ਸੀ, ਇਸ ਲਈ ਉਸ ਥਾਂ ਦਾ ਨਾਮ ਬਏਰਸ਼ਬਾ ਪੈ ਗਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","ਜਦ ਉਨ੍ਹਾਂ ਨੇ ਬਏਰਸ਼ਬਾ ਵਿੱਚ ਨੇਮ ਬੰਨ੍ਹਿਆ ਅਤੇ ਅਬੀਮਲਕ ਅਤੇ ਉਸ ਦੀ ਸੈਨਾਂ ਦਾ ਸਰਦਾਰ ਫ਼ੀਕੋਲ ਉੱਠੇ ਅਤੇ ਫ਼ਲਿਸਤੀਆਂ ਦੇ ਦੇਸ਼ ਨੂੰ ਮੁੜ ਗਏ। ");
INSERT INTO pan_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","ਫਿਰ ਉਸ ਨੇ ਬਏਰਸ਼ਬਾ ਵਿੱਚ ਝਾਊ ਦਾ ਇੱਕ ਰੁੱਖ ਲਾਇਆ ਅਤੇ ਉੱਥੇ ਯਹੋਵਾਹ ਅੱਗੇ ਜੋ ਅਟੱਲ ਪਰਮੇਸ਼ੁਰ ਹੈ ਪ੍ਰਾਰਥਨਾ ਕੀਤੀ। ");
INSERT INTO pan_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","ਅਬਰਾਹਾਮ ਬਹੁਤਿਆਂ ਦਿਨਾਂ ਤੱਕ ਫ਼ਲਿਸਤੀਆਂ ਦੇ ਦੇਸ਼ ਵਿੱਚ ਪਰਦੇਸੀ ਹੋ ਕੇ ਰਿਹਾ। ");
INSERT INTO pan_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","ਇਨ੍ਹਾਂ ਗੱਲਾਂ ਦੇ ਬਾਅਦ ਅਜਿਹਾ ਹੋਇਆ ਕਿ ਪਰਮੇਸ਼ੁਰ ਨੇ ਅਬਰਾਹਾਮ ਨੂੰ ਪਰਤਾਇਆ ਅਤੇ ਉਸ ਨੇ ਆਖਿਆ, ਹੇ ਅਬਰਾਹਾਮ! ਅੱਗੋਂ ਉਸ ਨੇ ਆਖਿਆ, ਮੈਂ ਹਾਜ਼ਰ ਹਾਂ। ");
INSERT INTO pan_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","ਉਸ ਨੇ ਆਖਿਆ, ਹੁਣ ਤੂੰ ਆਪਣੇ ਪੁੱਤਰ ਨੂੰ, ਹਾਂ, ਆਪਣੇ ਇਕਲੌਤੇ ਨੂੰ ਜਿਸ ਨੂੰ ਤੂੰ ਪਿਆਰ ਕਰਦਾ ਹੈਂ ਅਰਥਾਤ ਇਸਹਾਕ ਨੂੰ ਲੈ ਕੇ ਮੋਰੀਆਹ ਦੇਸ਼ ਨੂੰ ਜਾ ਅਤੇ ਪਹਾੜਾਂ ਵਿੱਚੋਂ ਇੱਕ ਉੱਤੇ ਜਿਹੜਾ ਮੈਂ ਤੈਨੂੰ ਦੱਸਾਂਗਾ ਉਸ ਨੂੰ ਹੋਮ ਦੀ ਬਲੀ ਕਰਕੇ ਚੜ੍ਹਾ। ");
INSERT INTO pan_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","ਤਦ ਅਬਰਾਹਾਮ ਨੇ ਤੜਕੇ ਉੱਠ ਕੇ ਆਪਣੇ ਗਧੇ ਉੱਤੇ ਕਾਠੀ ਕੱਸੀ ਅਤੇ ਆਪਣੇ ਦੋ ਦਾਸਾਂ ਨੂੰ ਅਤੇ ਆਪਣੇ ਪੁੱਤਰ ਇਸਹਾਕ ਨੂੰ ਨਾਲ ਲਿਆ ਅਤੇ ਹੋਮ ਦੀ ਬਲੀ ਲਈ ਲੱਕੜੀਆਂ ਚੀਰੀਆਂ ਅਤੇ ਉੱਠ ਕੇ ਉਸ ਸਥਾਨ ਨੂੰ ਤੁਰ ਪਿਆ ਜਿਹੜੀ ਪਰਮੇਸ਼ੁਰ ਨੇ ਉਸ ਨੂੰ ਦੱਸੀ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","ਤੀਜੇ ਦਿਨ ਅਬਰਾਹਾਮ ਨੇ ਆਪਣੀਆਂ ਅੱਖਾਂ ਚੁੱਕ ਕੇ ਉਸ ਸਥਾਨ ਨੂੰ ਦੂਰੋਂ ਵੇਖਿਆ ");
INSERT INTO pan_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","ਤਦ ਅਬਰਾਹਾਮ ਨੇ ਆਪਣੇ ਦਾਸਾਂ ਨੂੰ ਆਖਿਆ, ਤੁਸੀਂ ਇੱਥੇ ਗਧੇ ਦੇ ਕੋਲ ਰੁਕੋ। ਮੈਂ ਅਤੇ ਇਹ ਮੁੰਡਾ ਥੋੜ੍ਹੀ ਦੂਰ ਅੱਗੇ ਜਾਂਵਾਂਗੇ ਅਤੇ ਉਪਾਸਨਾ ਕਰ ਕੇ ਤੁਹਾਡੇ ਕੋਲ ਮੁੜ ਆਵਾਂਗੇ। ");
INSERT INTO pan_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","ਤਦ ਅਬਰਾਹਾਮ ਨੇ ਹੋਮ ਬਲੀ ਦੀਆਂ ਲੱਕੜੀਆਂ ਲੈ ਕੇ ਆਪਣੇ ਪੁੱਤਰ ਇਸਹਾਕ ਨੂੰ ਚੁਕਾ ਦਿੱਤੀਆਂ ਅਤੇ ਆਪਣੇ ਹੱਥ ਵਿੱਚ ਅੱਗ ਅਤੇ ਛੁਰੀ ਫੜ ਲਈ ਅਤੇ ਦੋਵੇਂ ਇਕੱਠੇ ਤੁਰ ਪਏ। ");
INSERT INTO pan_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","ਇਸਹਾਕ ਨੇ ਆਪਣੇ ਪਿਤਾ ਅਬਰਾਹਾਮ ਨੂੰ ਆਖਿਆ, ਪਿਤਾ ਜੀ, ਉਸ ਨੇ ਆਖਿਆ, ਹੇ ਮੇਰੇ ਪੁੱਤਰ ਕੀ ਗੱਲ ਹੈ? ਉਸ ਨੇ ਆਖਿਆ, ਵੇਖ, ਅੱਗ ਅਤੇ ਲੱਕੜੀਆਂ ਤਾਂ ਹਨ ਪਰ ਹੋਮ ਬਲੀ ਲਈ ਲੇਲਾ ਕਿੱਥੇ ਹੈ? ");
INSERT INTO pan_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","ਅਬਰਾਹਾਮ ਨੇ ਆਖਿਆ, ਹੇ ਮੇਰੇ ਪੁੱਤਰ, ਪਰਮੇਸ਼ੁਰ ਹੋਮ ਬਲੀ ਲਈ ਲੇਲਾ ਆਪ ਹੀ ਦੇਵੇਗਾ ਤਾਂ ਓਹ ਦੋਵੇਂ ਇਕੱਠੇ ਤੁਰਦੇ ਗਏ। ");
INSERT INTO pan_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","ਓਹ ਉਸ ਸਥਾਨ ਉੱਤੇ ਜਾ ਪਹੁੰਚੇ ਜਿਹੜਾ ਪਰਮੇਸ਼ੁਰ ਨੇ ਉਹ ਨੂੰ ਦੱਸਿਆ ਸੀ। ਉੱਥੇ ਅਬਰਾਹਾਮ ਨੇ ਇੱਕ ਜਗਵੇਦੀ ਬਣਾਈ ਅਤੇ ਉਸ ਉੱਤੇ ਲੱਕੜੀਆਂ ਚਿਣ ਦਿੱਤੀਆਂ ਅਤੇ ਆਪਣੇ ਪੁੱਤਰ ਇਸਹਾਕ ਨੂੰ ਬੰਨ੍ਹ ਕੇ ਜਗਵੇਦੀ ਦੀਆਂ ਲੱਕੜੀਆਂ ਉੱਤੇ ਰੱਖ ਦਿੱਤਾ। ");
INSERT INTO pan_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","ਜਿਵੇਂ ਹੀ ਅਬਰਾਹਾਮ ਨੇ ਆਪਣਾ ਹੱਥ ਵਧਾ ਕੇ ਛੁਰੀ ਫੜੀ ਕਿ ਆਪਣੇ ਪੁੱਤਰ ਨੂੰ ਹੋਮ ਬਲੀ ਕਰਕੇ ਚੜ੍ਹਾਵੇ ");
INSERT INTO pan_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","ਤਦ ਯਹੋਵਾਹ ਦੇ ਦੂਤ ਨੇ ਅਕਾਸ਼ ਤੋਂ ਉਸ ਨੂੰ ਪੁਕਾਰਿਆ, “ਅਬਰਾਹਾਮ! ਅਬਰਾਹਾਮ!” ਉਸ ਨੇ ਉੱਤਰ ਦਿੱਤਾ, ਮੈਂ ਹਾਜ਼ਰ ਹਾਂ। ");
INSERT INTO pan_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","ਉਸ ਨੇ ਆਖਿਆ, ਤੂੰ ਇਸ ਮੁੰਡੇ ਨੂੰ ਹੱਥ ਨਾ ਲਾ ਅਤੇ ਨਾ ਹੀ ਉਸ ਨਾਲ ਕੁਝ ਕਰ। ਹੁਣ ਮੈਂ ਜਾਣ ਗਿਆ ਹਾਂ ਕਿ ਤੂੰ ਪਰਮੇਸ਼ੁਰ ਤੋਂ ਡਰਦਾ ਹੈਂ ਕਿਉਂ ਜੋ ਤੂੰ ਆਪਣੇ ਪੁੱਤਰ, ਹਾਂ, ਆਪਣੇ ਇਕਲੌਤੇ ਪੁੱਤਰ ਦਾ ਵੀ ਮੈਥੋਂ ਸਰਫ਼ਾ ਨਹੀਂ ਕੀਤਾ। ");
INSERT INTO pan_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","ਜਦ ਅਬਰਾਹਾਮ ਨੇ ਆਪਣੀਆਂ ਅੱਖਾਂ ਚੁੱਕ ਕੇ ਵੇਖਿਆ ਤਾਂ ਵੇਖੋ, ਉਹ ਦੇ ਪਿੱਛੇ ਇੱਕ ਲੇਲਾ ਸੀ, ਜਿਸ ਦੇ ਸਿੰਗ ਝਾੜੀ ਵਿੱਚ ਫਸੇ ਹੋਏ ਸਨ ਤਾਂ ਅਬਰਾਹਾਮ ਨੇ ਜਾ ਕੇ ਉਸ ਲੇਲੇ ਨੂੰ ਫੜ ਲਿਆ ਅਤੇ ਉਸ ਨੂੰ ਆਪਣੇ ਪੁੱਤਰ ਦੀ ਥਾਂ ਹੋਮ ਬਲੀ ਕਰਕੇ ਚੜ੍ਹਾਇਆ। ");
INSERT INTO pan_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","ਅਬਰਾਹਾਮ ਨੇ ਉਸ ਸਥਾਨ ਦਾ ਨਾਮ ਯਹੋਵਾਹ ਯਿਰਹ ਰੱਖਿਆ, ਅੱਜ ਤੱਕ ਵੀ ਇਹ ਕਿਹਾ ਜਾਂਦਾ ਹੈ “ਯਹੋਵਾਹ ਦੇ ਪਰਬਤ ਉੱਤੇ ਪ੍ਰਬੰਧ ਕੀਤਾ ਜਾਵੇਗਾ।” ");
INSERT INTO pan_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","ਫੇਰ ਯਹੋਵਾਹ ਦੇ ਦੂਤ ਨੇ ਦੂਜੀ ਵਾਰ ਅਕਾਸ਼ ਤੋਂ ਅਬਰਾਹਾਮ ਨੂੰ ਪੁਕਾਰ ਕੇ ਆਖਿਆ, ");
INSERT INTO pan_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","ਪ੍ਰਭੂ ਯਹੋਵਾਹ ਦਾ ਵਾਕ ਹੈ ਕਿ ਮੈਂ ਆਪ ਆਪਣੀ ਹੀ ਸਹੁੰ ਖਾਧੀ ਹੈ, ਕਿ ਤੂੰ ਜੋ ਇਹ ਕੰਮ ਕੀਤਾ ਅਤੇ ਆਪਣੇ ਪੁੱਤਰ ਸਗੋਂ ਆਪਣੇ ਇਕਲੌਤੇ ਪੁੱਤਰ ਦਾ ਵੀ ਸਰਫ਼ਾ ਨਹੀਂ ਕੀਤਾ, ");
INSERT INTO pan_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","ਇਸ ਲਈ ਮੈਂ ਤੈਨੂੰ ਬਰਕਤਾਂ ਤੇ ਬਰਕਤਾਂ ਦਿਆਂਗਾ ਅਤੇ ਮੈਂ ਤੇਰੀ ਅੰਸ ਨੂੰ ਅਕਾਸ਼ ਤੇ ਤਾਰਿਆਂ ਜਿੰਨ੍ਹੀਂ ਅਤੇ ਸਮੁੰਦਰ ਦੇ ਕੰਢੇ ਦੀ ਰੇਤ ਵਾਂਗੂੰ ਅੱਤ ਵਧਾਵਾਂਗਾ ਅਤੇ ਤੇਰੀ ਅੰਸ ਆਪਣੇ ਵੈਰੀਆਂ ਦੇ ਫਾਟਕ ਉੱਤੇ ਕਬਜ਼ਾ ਕਰੇਗੀ। ");
INSERT INTO pan_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","ਧਰਤੀ ਦੀਆਂ ਸਾਰੀਆਂ ਕੌਮਾਂ ਤੇਰੀ ਅੰਸ ਦੇ ਕਾਰਨ ਬਰਕਤ ਪਾਉਣਗੀਆਂ ਕਿਉਂ ਜੋ ਤੂੰ ਮੇਰੇ ਹੁਕਮ ਨੂੰ ਮੰਨਿਆ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","ਤਦ ਅਬਰਾਹਾਮ ਆਪਣੇ ਦਾਸਾਂ ਕੋਲ ਮੁੜ ਆਇਆ ਅਤੇ ਉਹ ਉੱਠ ਕੇ ਬਏਰਸ਼ਬਾ ਨੂੰ ਵਾਪਿਸ ਆਏ ਅਤੇ ਅਬਰਾਹਾਮ ਬਏਰਸ਼ਬਾ ਵਿੱਚ ਆ ਕੇ ਵੱਸਿਆ ਰਿਹਾ। ");
INSERT INTO pan_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","ਇਹਨਾਂ ਗੱਲਾਂ ਦੇ ਬਾਅਦ ਅਜਿਹਾ ਹੋਇਆ ਕਿ ਅਬਰਾਹਾਮ ਨੂੰ ਦੱਸਿਆ ਗਿਆ, ਵੇਖ, ਮਿਲਕਾਹ ਨੇ ਵੀ ਤੇਰੇ ਭਰਾ ਨਾਹੋਰ ਲਈ ਪੁੱਤਰਾਂ ਨੂੰ ਜਨਮ ਦਿੱਤਾ ਹੈ ");
INSERT INTO pan_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","ਮਿਲਕਾਹ ਦੇ ਪੁੱਤਰ ਇਹ ਸਨ, ਅਰਥਾਤ ਉਹ ਦਾ ਪਹਿਲੌਠਾ ਊਸ ਅਤੇ ਉਸ ਦਾ ਭਰਾ ਬੂਜ਼ ਅਤੇ ਕਮੂਏਲ ਜਿਹੜਾ ਅਰਾਮ ਦਾ ਪਿਤਾ ਸੀ ");
INSERT INTO pan_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","ਅਤੇ ਕਸਦ, ਹਜ਼ੋ, ਪਿਲਦਾਸ, ਯਿਦਲਾਫ ਅਤੇ ਬਥੂਏਲ ");
INSERT INTO pan_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","ਇਹਨਾਂ ਅੱਠ ਪੁੱਤਰਾਂ ਨੂੰ ਮਿਲਕਾਹ ਨੇ ਅਬਰਾਹਾਮ ਦੇ ਭਰਾ ਨਾਹੋਰ ਲਈ ਜਣਿਆ ਅਤੇ ਬਥੂਏਲ ਦੇ ਰਿਬਕਾਹ ਜੰਮੀ। ");
INSERT INTO pan_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","ਉਸ ਦੀ ਇੱਕ ਰਖ਼ੈਲ ਸੀ ਜਿਸ ਦਾ ਨਾਮ ਰੂਮਾਹ ਸੀ ਉਸ ਨੇ ਵੀ ਤਬਹ, ਗਹਮ, ਤਹਸ਼ ਅਤੇ ਮਾਕਾਹ ਨੂੰ ਜਨਮ ਦਿੱਤਾ। ");
INSERT INTO pan_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","ਸਾਰਾਹ ਦੀ ਉਮਰ ਇੱਕ ਸੌ ਸਤਾਈ ਸਾਲਾਂ ਦੀ ਹੋਈ, ");
INSERT INTO pan_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","ਜਦ ਸਾਰਾਹ ਦੀ ਐਨੀ ਉਮਰ ਹੋ ਗਈ ਤਾਂ ਉਹ ਕਿਰਯਥ-ਅਰਬਾ ਅਰਥਾਤ ਹਬਰੋਨ ਵਿੱਚ ਮਰ ਗਈ, ਜਿਹੜਾ ਕਨਾਨ ਦੇਸ਼ ਵਿੱਚ ਹੈ। ਇਸ ਲਈ ਅਬਰਾਹਾਮ ਸਾਰਾਹ ਲਈ ਰੋਣ-ਪਿੱਟਣ ਲਈ ਆਇਆ। ");
INSERT INTO pan_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","ਫੇਰ ਅਬਰਾਹਾਮ ਆਪਣੇ ਮੁਰਦੇ ਦੇ ਅੱਗਿਓਂ ਉੱਠ ਕੇ ਹੇਤ ਦੇ ਪੁੱਤਰਾਂ ਨੂੰ ਆਖਣ ਲੱਗਾ, ");
INSERT INTO pan_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","ਮੈਂ ਪਰਦੇਸੀ ਅਤੇ ਤੁਹਾਡੇ ਵਿੱਚ ਅਜਨਬੀ ਹਾਂ। ਤੁਸੀਂ ਆਪਣੇ ਵਿੱਚ ਇੱਕ ਕਬਰਿਸਤਾਨ ਮੇਰੀ ਵਿਰਾਸਤ ਕਰ ਦਿਓ ਤਾਂ ਜੋ ਮੈਂ ਆਪਣਾ ਮੁਰਦਾ ਦੱਬ ਦਿਆਂ। ");
INSERT INTO pan_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","ਹੇਤ ਦੇ ਪੁੱਤਰਾਂ ਨੇ ਅਬਰਾਹਾਮ ਨੂੰ ਉੱਤਰ ਦਿੱਤਾ, ");
INSERT INTO pan_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","ਪ੍ਰਭੂ ਜੀ, ਸਾਡੀ ਸੁਣੋ। ਸਾਡੇ ਵਿੱਚ ਤੁਸੀਂ ਪਰਮੇਸ਼ੁਰ ਦੇ ਸ਼ਹਿਜ਼ਾਦੇ ਹੋ। ਆਪਣੇ ਮੁਰਦੇ ਨੂੰ ਸਾਡੀਆਂ ਕਬਰਾਂ ਵਿੱਚੋਂ ਸਭ ਤੋਂ ਚੰਗੀ ਕਬਰ ਵਿੱਚ ਦੱਬ ਦਿਓ। ਤੁਹਾਡੇ ਮੁਰਦੇ ਨੂੰ ਦੱਬਣ ਲਈ ਸਾਡੇ ਵਿੱਚੋਂ ਕੋਈ ਵੀ ਆਪਣੀ ਕਬਰ ਲੈਣ ਤੋਂ ਤੁਹਾਨੂੰ ਨਹੀਂ ਰੋਕੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","ਤਦ ਅਬਰਾਹਾਮ ਉੱਠਿਆ ਅਤੇ ਉਸ ਦੇਸ਼ ਦੇ ਲੋਕਾਂ ਅਰਥਾਤ ਹੇਤ ਦੇ ਪੁੱਤਰਾਂ ਦੇ ਅੱਗੇ ਝੁੱਕਿਆ, ");
INSERT INTO pan_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","ਅਤੇ ਉਨ੍ਹਾਂ ਨੂੰ ਕਿਹਾ ਕਿ ਜੇ ਤੁਹਾਡੀ ਮਰਜ਼ੀ ਹੋਵੇ ਕਿ ਮੈਂ ਆਪਣੇ ਮੁਰਦੇ ਨੂੰ ਆਪਣੇ ਅੱਗੋਂ ਦੱਬ ਦੇਵਾਂ ਤਾਂ ਮੇਰੀ ਅਰਜ਼ ਸੁਣੋ ਅਤੇ ਸੋਹਰ ਦੇ ਪੁੱਤਰ ਅਫ਼ਰੋਨ ਦੇ ਅੱਗੇ ਮੇਰੇ ਲਈ ਬੇਨਤੀ ਕਰੋ ");
INSERT INTO pan_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","ਤਾਂ ਜੋ ਉਹ ਮੈਨੂੰ ਮਕਫ਼ੇਲਾਹ ਦੀ ਗੁਫ਼ਾ ਦੇਵੇ, ਜਿਹੜੀ ਉਸ ਦੇ ਖੇਤ ਦੇ ਬੰਨੇ ਨਾਲ ਹੈ। ਉਹ ਉਸ ਦਾ ਪੂਰਾ ਮੁੱਲ ਤੁਹਾਡੇ ਸਨਮੁਖ ਲੈ ਲਵੇ ਤਾਂ ਜੋ ਉਹ ਕਬਰਿਸਤਾਨ ਮੇਰੀ ਨਿੱਜ ਭੂਮੀ ਹੋਵੇ। ");
INSERT INTO pan_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","ਅਫ਼ਰੋਨ ਹੇਤ ਦੇ ਪੁੱਤਰਾਂ ਦੇ ਵਿਚਕਾਰ ਬੈਠਾ ਹੋਇਆ ਸੀ, ਇਸ ਲਈ ਜਿੰਨ੍ਹੇ ਹਿੱਤੀ ਉਸ ਨਗਰ ਦੇ ਫਾਟਕ ਤੋਂ ਲੰਘਦੇ ਸਨ ਉਹਨਾਂ ਸਾਰਿਆਂ ਦੇ ਅੱਗੇ ਅਬਰਾਹਾਮ ਨੂੰ ਉੱਤਰ ਦਿੱਤਾ, ");
INSERT INTO pan_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","ਨਹੀਂ, ਮੇਰੇ ਪ੍ਰਭੂ ਜੀ, ਮੇਰੀ ਸੁਣੋ। ਮੈਂ ਇਹ ਖੇਤ ਤੁਹਾਨੂੰ ਦਿੰਦਾ ਹਾਂ ਅਤੇ ਇਹ ਗੁਫ਼ਾ ਵੀ ਜਿਹੜੀ ਉਹ ਦੇ ਵਿੱਚ ਹੈ। ਮੈਂ ਆਪਣੀ ਕੌਮ ਦੇ ਪੁੱਤਰਾਂ ਦੇ ਸਾਹਮਣੇ ਤੁਹਾਨੂੰ ਦਿੰਦਾ ਹਾਂ। ਤੁਸੀਂ ਆਪਣੇ ਮੁਰਦੇ ਨੂੰ ਉੱਥੇ ਦੱਬ ਦਿਓ। ");
INSERT INTO pan_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","ਫੇਰ ਅਬਰਾਹਾਮ ਉਸ ਦੇਸ਼ ਦੇ ਲੋਕਾਂ ਦੇ ਸਨਮੁਖ ਝੁਕਿਆ ");
INSERT INTO pan_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","ਅਤੇ ਉਸ ਦੇਸ਼ ਦੇ ਲੋਕਾਂ ਦੇ ਸੁਣਦੇ ਹੋਏ ਅਫ਼ਰੋਨ ਨੂੰ ਆਖਿਆ, ਜੇਕਰ ਤੂੰ ਅਜਿਹਾ ਚਾਹੁੰਦਾ ਹੈ ਤਦ ਮੇਰੀ ਸੁਣ, ਮੈਂ ਉਸ ਖੇਤ ਦਾ ਮੁੱਲ ਦਿੰਦਾ ਹਾਂ। ਉਹ ਮੇਰੀ ਵੱਲੋਂ ਲੈ ਤਾਂ ਜੋ ਮੈਂ ਆਪਣੇ ਮੁਰਦੇ ਨੂੰ ਉੱਥੇ ਦੱਬਾਂ। ");
INSERT INTO pan_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","ਅਫ਼ਰੋਨ ਨੇ ਇਹ ਆਖ ਕੇ ਅਬਰਾਹਾਮ ਨੂੰ ਉੱਤਰ ਦਿੱਤਾ, ");
INSERT INTO pan_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","ਪ੍ਰਭੂ ਜੀ, ਮੇਰੀ ਸੁਣੋ ਇਸ ਜ਼ਮੀਨ ਦਾ ਮੁੱਲ, ਜੋ ਚਾਰ ਸੌ ਚਾਂਦੀ ਦੇ ਸਿੱਕੇ ਹੈ ਪਰ ਇਹ ਸਾਡੇ ਵਿੱਚਕਾਰ ਕੀ ਹੈ? ਆਪਣੇ ਮੁਰਦੇ ਨੂੰ ਦੱਬ ਦਿਓ। ");
INSERT INTO pan_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","ਅਬਰਾਹਾਮ ਨੇ ਅਫ਼ਰੋਨ ਦੀ ਗੱਲ ਮੰਨ ਲਈ ਅਤੇ ਅਬਰਾਹਾਮ ਨੇ ਚਾਂਦੀ ਦੇ ਚਾਰ ਸੌ ਸਿੱਕੇ ਜੋ ਵਪਾਰੀਆਂ ਵਿੱਚ ਚਲਦੇ ਸਨ, ਜਿਹੜਾ ਉਹ ਨੇ ਹਿੱਤੀਆਂ ਦੇ ਸੁਣਦੇ ਹੋਏ ਬੋਲਿਆ ਸੀ, ਅਫ਼ਰੋਨ ਲਈ ਤੋਲ ਦਿੱਤਾ। ");
INSERT INTO pan_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","ਇਸ ਤਰ੍ਹਾਂ ਮਕਫ਼ੇਲਾਹ ਵਾਲਾ ਅਫ਼ਰੋਨ ਦਾ ਖੇਤ, ਜਿਹੜਾ ਮਮਰੇ ਦੇ ਸਾਹਮਣੇ ਹੈ ਅਤੇ ਖੇਤ ਦੇ ਵਿੱਚ ਦੀ ਗੁਫ਼ਾ ਅਤੇ ਸਾਰੇ ਰੁੱਖ ਜਿਹੜੇ ਖੇਤ ਵਿੱਚ ਅਤੇ ਜੋ ਉਸ ਦੇ ਬੰਨਿਆਂ ਦੇ ਉੱਤੇ ਸਨ, ");
INSERT INTO pan_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","ਹਿੱਤੀਆਂ ਦੇ ਅਤੇ ਉਨ੍ਹਾਂ ਸਾਰਿਆਂ ਦੇ ਸਨਮੁਖ ਜਿਹੜੇ ਉਸ ਨਗਰ ਦੇ ਫਾਟਕ ਵਿੱਚੋਂ ਦੀ ਲੰਘਦੇ ਸਨ, ਇਹ ਅਬਰਾਹਾਮ ਦੀ ਨਿੱਜ ਭੂਮੀ ਹੋ ਗਈ। ");
INSERT INTO pan_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","ਇਸ ਦੇ ਮਗਰੋਂ ਅਬਰਾਹਾਮ ਨੇ ਆਪਣੀ ਪਤਨੀ ਸਾਰਾਹ ਨੂੰ ਮਕਫ਼ੇਲਾਹ ਦੇ ਖੇਤ ਦੀ ਗੁਫ਼ਾ ਵਿੱਚ ਜਿਹੜੀ ਮਮਰੇ ਦੇ ਸਾਹਮਣੇ ਹੈ ਅਰਥਾਤ ਕਨਾਨ ਦੇਸ਼ ਦੇ ਹਬਰੋਨ ਵਿੱਚ ਦੱਬ ਦਿੱਤਾ। ");
INSERT INTO pan_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","ਇਸ ਤਰ੍ਹਾਂ ਉਹ ਖੇਤ ਅਤੇ ਉਹ ਦੇ ਵਿਚਲੀ ਗੁਫ਼ਾ, ਹੇਤ ਦੇ ਪੁੱਤਰਾਂ ਤੋਂ ਕਬਰਿਸਤਾਨ ਲਈ ਅਬਰਾਹਾਮ ਦੀ ਨਿੱਜ ਭੂਮੀ ਹੋ ਗਈ। ");
INSERT INTO pan_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","ਹੁਣ ਅਬਰਾਹਾਮ ਬਹੁਤ ਬਜ਼ੁਰਗ ਅਤੇ ਵੱਡੀ ਉਮਰ ਦਾ ਹੋ ਗਿਆ ਸੀ ਅਤੇ ਯਹੋਵਾਹ ਨੇ ਸਾਰੀਆਂ ਗੱਲਾਂ ਵਿੱਚ ਅਬਰਾਹਾਮ ਨੂੰ ਬਰਕਤ ਦਿੱਤੀ। ");
INSERT INTO pan_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","ਅਬਰਾਹਾਮ ਨੇ ਆਪਣੇ ਘਰ ਦੇ ਪੁਰਾਣੇ ਨੌਕਰ ਨੂੰ, ਜਿਹੜਾ ਉਸ ਦੀਆਂ ਸਾਰੀਆਂ ਚੀਜ਼ਾਂ ਦਾ ਮੁਖ਼ਤਿਆਰ ਸੀ ਆਖਿਆ, ਆਪਣਾ ਹੱਥ ਮੇਰੇ ਪੱਟ ਦੇ ਹੇਠ ਰੱਖ; ");
INSERT INTO pan_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","ਮੈਂ ਤੈਨੂੰ ਯਹੋਵਾਹ ਅਕਾਸ਼ ਦੇ ਪਰਮੇਸ਼ੁਰ ਅਤੇ ਧਰਤੀ ਦੇ ਪਰਮੇਸ਼ੁਰ ਦੀ ਸਹੁੰ ਦੇਵਾਂ ਕਿ ਤੂੰ ਮੇਰੇ ਪੁੱਤਰ ਲਈ ਕਨਾਨੀਆਂ ਦੀਆਂ ਧੀਆਂ ਵਿੱਚੋਂ ਪਤਨੀ ਨਾ ਲਿਆਵੀਂ, ਜਿਨ੍ਹਾਂ ਵਿੱਚ ਮੈਂ ਵੱਸਦਾ ਹਾਂ। ");
INSERT INTO pan_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","ਪਰ ਤੂੰ ਮੇਰੇ ਆਪਣੇ ਦੇਸ਼ ਵਿੱਚ ਅਤੇ ਮੇਰੇ ਘਰਾਣੇ ਦੇ ਕੋਲ ਜਾਈਂ ਅਤੇ ਮੇਰੇ ਪੁੱਤਰ ਇਸਹਾਕ ਲਈ ਪਤਨੀ ਲੈ ਆਵੀਂ। ");
INSERT INTO pan_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","ਤਦ ਉਸ ਨੌਕਰ ਨੇ ਉਹ ਨੂੰ ਆਖਿਆ, ਸ਼ਾਇਦ ਉਹ ਇਸਤਰੀ ਮੇਰੇ ਨਾਲ ਇਸ ਦੇਸ਼ ਵਿੱਚ ਆਉਣਾ ਨਾ ਚਾਹੇ, ਤਾਂ ਕੀ ਮੈਂ ਤੇਰੇ ਪੁੱਤਰ ਨੂੰ ਉਸ ਦੇਸ਼ ਨੂੰ ਵਾਪਿਸ ਲੈ ਜਾਂਵਾਂ ਜਿੱਥੋਂ ਤੂੰ ਆਇਆ ਹੈਂ? ");
INSERT INTO pan_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","ਅਬਰਾਹਾਮ ਨੇ ਉਸ ਨੂੰ ਆਖਿਆ, ਖ਼ਬਰਦਾਰ, ਮੇਰੇ ਪੁੱਤਰ ਨੂੰ ਕਦੇ ਵੀ ਉਸ ਦੇਸ਼ ਵਿੱਚ ਨਾ ਲੈ ਜਾਵੀਂ। ");
INSERT INTO pan_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","ਸਵਰਗ ਦਾ ਪਰਮੇਸ਼ੁਰ ਯਹੋਵਾਹ ਜੋ ਮੈਨੂੰ ਮੇਰੇ ਪਿਤਾ ਦੇ ਘਰ ਤੋਂ ਅਤੇ ਮੇਰੀ ਜਨਮ ਭੂਮੀ ਤੋਂ ਕੱਢ ਲੈ ਆਇਆ, ਜੋ ਮੇਰੇ ਨਾਲ ਬੋਲਿਆ ਅਤੇ ਮੇਰੇ ਨਾਲ ਸਹੁੰ ਖਾ ਕੇ ਆਖਿਆ ਕਿ ਮੈਂ ਤੇਰੀ ਅੰਸ ਨੂੰ ਇਹ ਦੇਸ਼ ਦਿਆਂਗਾ। ਉਹ ਹੀ ਆਪਣਾ ਦੂਤ ਤੇਰੇ ਅੱਗੇ ਭੇਜੇਗਾ ਅਤੇ ਤੂੰ ਉੱਥੋਂ ਮੇਰੇ ਪੁੱਤਰ ਲਈ ਪਤਨੀ ਲੈ ਆਵੇਂਗਾ। ");
INSERT INTO pan_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","ਅਤੇ ਜੇ ਉਹ ਇਸਤਰੀ ਤੇਰੇ ਨਾਲ ਨਾ ਆਉਣਾ ਚਾਹੇ ਤਾਂ ਤੂੰ ਮੇਰੀ ਇਸ ਸਹੁੰ ਤੋਂ ਛੁੱਟ ਜਾਵੇਂਗਾ। ਪਰ ਮੇਰੇ ਪੁੱਤਰ ਨੂੰ ਉੱਥੇ ਕਦੀ ਨਾ ਲੈ ਜਾਵੀਂ। ");
INSERT INTO pan_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","ਤਦ ਉਸ ਨੌਕਰ ਨੇ ਆਪਣਾ ਹੱਥ ਆਪਣੇ ਸੁਆਮੀ ਅਬਰਾਹਾਮ ਦੇ ਪੱਟ ਹੇਠ ਰੱਖ ਕੇ ਉਹ ਦੇ ਨਾਲ ਇਸ ਗੱਲ ਦੀ ਸਹੁੰ ਖਾਧੀ। ");
INSERT INTO pan_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","ਉਪਰੰਤ ਉਹ ਨੌਕਰ ਆਪਣੇ ਸੁਆਮੀ ਦੇ ਊਠਾਂ ਵਿੱਚੋਂ ਦਸ ਊਠ ਲੈ ਕੇ ਤੁਰ ਪਿਆ, ਉਹ ਆਪਣੇ ਨਾਲ ਉੱਤਮ ਪਦਾਰਥਾਂ ਵਿੱਚੋਂ ਕੁਝ ਨਾਲ ਲੈ ਕੇ ਮਸੋਪੋਤਾਮੀਆ ਦੇ ਦੇਸ਼ ਵਿੱਚ ਨਾਹੋਰ ਦੇ ਨਗਰ ਨੂੰ ਗਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","ਉਸ ਨੌਕਰ ਨੇ ਆਪਣੇ ਊਠਾਂ ਨੂੰ ਨਗਰ ਤੋਂ ਬਾਹਰ ਖੂਹ ਦੇ ਕੋਲ ਬਿਠਾ ਦਿੱਤਾ, ਇਹ ਸ਼ਾਮ ਦਾ ਵੇਲਾ ਸੀ ਜਦੋਂ ਇਸਤਰੀਆਂ ਪਾਣੀ ਭਰਨ ਨੂੰ ਨਿੱਕਲਦੀਆਂ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","ਤਦ ਉਸ ਨੇ ਆਖਿਆ, ਹੇ ਯਹੋਵਾਹ ਮੇਰੇ ਸੁਆਮੀ ਅਬਰਾਹਾਮ ਦੇ ਪਰਮੇਸ਼ੁਰ, ਅੱਜ ਮੇਰਾ ਸਭ ਕਾਰਜ ਸਫ਼ਲ ਕਰ ਅਤੇ ਮੇਰੇ ਸੁਆਮੀ ਅਬਰਾਹਾਮ ਉੱਤੇ ਕਿਰਪਾ ਕਰ। ");
INSERT INTO pan_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","ਵੇਖ ਮੈਂ ਪਾਣੀ ਦੇ ਚਸ਼ਮੇ ਉੱਤੇ ਖੜ੍ਹਾ ਹਾਂ ਅਤੇ ਨਗਰ ਦੇ ਮਨੁੱਖਾਂ ਦੀਆਂ ਧੀਆਂ ਪਾਣੀ ਭਰਨ ਨੂੰ ਆਉਂਦੀਆਂ ਹਾਂ। ");
INSERT INTO pan_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","ਅਜਿਹਾ ਹੋਵੇ ਕਿ ਜਿਹੜੀ ਕੁੜੀ ਨੂੰ ਮੈਂ ਆਖਾਂ ਭਈ ਆਪਣਾ ਘੜਾ ਮੇਰੇ ਵੱਲ ਨੂੰ ਨੀਵਾਂ ਕਰੀਂ ਅਤੇ ਮੈਂ ਪੀਵਾਂਗਾ ਤਾਂ ਉਹ ਆਖੇ ਪੀਓ ਅਤੇ ਮੈਂ ਤੁਹਾਡੇ ਊਠਾਂ ਨੂੰ ਵੀ ਪਿਲਾਵਾਂਗੀ ਸੋ ਉਹੀ ਹੋਵੇ ਜਿਸ ਨੂੰ ਤੂੰ ਆਪਣੇ ਦਾਸ ਇਸਹਾਕ ਲਈ ਠਹਿਰਾਇਆ ਹੈ, ਮੈਂ ਇਸੇ ਗੱਲ ਤੋਂ ਜਾਣਾਂਗਾ ਕਿ ਤੂੰ ਮੇਰੇ ਸੁਆਮੀ ਉੱਤੇ ਕਿਰਪਾ ਕੀਤੀ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","ਤਦ ਐਉਂ ਹੋਇਆ ਜਦ ਉਹ ਇਹ ਗੱਲ ਕਰਦਾ ਹੀ ਸੀ ਤਾਂ ਵੇਖੋ, ਰਿਬਕਾਹ ਜੋ ਅਬਰਾਹਾਮ ਦੇ ਭਰਾ ਨਾਹੋਰ ਦੀ ਪਤਨੀ ਮਿਲਕਾਹ ਦੇ ਪੁੱਤਰ ਬਥੂਏਲ ਦੀ ਧੀ ਸੀ, ਆਪਣਾ ਘੜਾ ਮੋਢਿਆਂ ਤੇ ਚੁੱਕੀ ਹੋਈ ਆ ਨਿੱਕਲੀ। ");
INSERT INTO pan_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","ਅਤੇ ਉਹ ਕੁੜੀ ਵੇਖਣ ਵਿੱਚ ਬਹੁਤ ਸੋਹਣੀ ਅਤੇ ਕੁਆਰੀ ਸੀ ਅਤੇ ਕਿਸੇ ਮਨੁੱਖ ਨਾਲ ਸੰਗ ਨਹੀਂ ਕੀਤਾ ਸੀ, ਅਤੇ ਉਹ ਚਸ਼ਮੇ ਵਿੱਚ ਉਤਰੀ ਅਤੇ ਆਪਣਾ ਘੜਾ ਭਰ ਕੇ ਬਾਹਰ ਆਈ। ");
INSERT INTO pan_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","ਤਾਂ ਉਹ ਨੌਕਰ ਉਸ ਦੇ ਮਿਲਣ ਨੂੰ ਨੱਠ ਕੇ ਗਿਆ ਅਤੇ ਆਖਿਆ, ਆਪਣੇ ਘੜੇ ਵਿੱਚੋਂ ਮੈਨੂੰ ਥੋੜਾ ਪਾਣੀ ਪਿਲਾਈਂ। ");
INSERT INTO pan_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","ਤਾਂ ਉਸ ਆਖਿਆ, ਮੇਰੇ ਸੁਆਮੀ ਜੀ ਪੀਓ ਤਦ ਉਸ ਨੇ ਜਲਦੀ ਨਾਲ ਆਪਣਾ ਘੜਾ ਹੱਥਾਂ ਉੱਤੇ ਕਰਕੇ ਉਸ ਨੂੰ ਪਿਲਾਇਆ। ");
INSERT INTO pan_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","ਜਦ ਉਹ ਉਸ ਨੂੰ ਪਾਣੀ ਪਿਲਾ ਚੁੱਕੀ ਤਦ ਆਖਿਆ, ਮੈਂ ਤੁਹਾਡੇ ਊਠਾਂ ਲਈ ਵੀ ਪਾਣੀ ਭਰਾਂਗੀ ਜਦ ਤੱਕ ਓਹ ਪੀ ਨਾ ਲੈਣ। ");
INSERT INTO pan_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","ਤਦ ਉਸ ਨੇ ਜਲਦੀ ਨਾਲ ਆਪਣਾ ਘੜਾ ਹੌਦ ਵਿੱਚ ਡੋਲ੍ਹ ਦਿੱਤਾ ਅਤੇ ਫੇਰ ਖੂਹ ਵਿੱਚੋਂ ਭਰਨ ਨੂੰ ਨੱਠ ਕੇ ਗਈ ਅਤੇ ਉਹ ਦੇ ਸਾਰਿਆਂ ਊਠਾਂ ਲਈ ਪਾਣੀ ਭਰਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","ਉਹ ਮਨੁੱਖ ਧਿਆਨ ਨਾਲ ਚੁੱਪ ਕਰਕੇ ਉਹ ਨੂੰ ਵੇਖਦਾ ਰਿਹਾ ਇਸ ਗੱਲ ਦੇ ਜਾਣਨ ਨੂੰ ਕਿ ਯਹੋਵਾਹ ਨੇ ਉਸ ਦਾ ਸਫ਼ਰ ਸਫ਼ਲ ਕੀਤਾ ਹੈ ਕਿ ਨਹੀਂ। ");
INSERT INTO pan_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","ਜਦ ਊਠ ਪੀ ਚੁੱਕੇ ਤਦ ਉਸ ਮਨੁੱਖ ਨੇ ਅੱਧੇ ਤੋਲੇ ਸੋਨੇ ਦੀ ਇੱਕ ਨੱਥ ਅਤੇ ਦਸ ਤੋਲੇ ਸੋਨੇ ਦੇ ਦੋ ਕੜੇ ਉਹ ਦੇ ਹੱਥਾਂ ਵਿੱਚ ਪਹਿਨਾ ਦਿੱਤੇ ");
INSERT INTO pan_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","ਅਤੇ ਪੁੱਛਿਆ, ਮੈਨੂੰ ਦੱਸੀਂ ਤੂੰ ਕਿਹਦੀ ਧੀ ਹੈਂ ਅਤੇ ਕੀ ਤੇਰੇ ਪਿਤਾ ਦੇ ਘਰ ਵਿੱਚ ਸਾਡੇ ਲਈ ਅੱਜ ਰਾਤ ਰਹਿਣ ਦੀ ਥਾਂ ਹੈ? ");
INSERT INTO pan_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","ਉਸ ਉਹ ਨੂੰ ਆਖਿਆ, ਮੈਂ ਬਥੂਏਲ ਦੀ ਧੀ ਹਾਂ, ਜਿਸ ਨੂੰ ਮਿਲਕਾਹ ਨੇ ਨਾਹੋਰ ਤੋਂ ਜਨਮ ਦਿੱਤਾ। ");
INSERT INTO pan_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","ਫਿਰ ਉਸ ਨੇ ਉਹ ਨੂੰ ਆਖਿਆ, ਸਾਡੇ ਕੋਲ ਊਠਾਂ ਲਈ ਚਾਰਾ ਬਥੇਰਾ ਹੈ ਅਤੇ ਰਾਤ ਰਹਿਣ ਦੀ ਥਾਂ ਵੀ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","ਤਦ ਉਸ ਮਨੁੱਖ ਨੇ ਸਿਰ ਝੁਕਾਇਆ ਅਤੇ ਯਹੋਵਾਹ ਨੂੰ ਮੱਥਾ ਟੇਕਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","ਉਸ ਨੇ ਆਖਿਆ, ਯਹੋਵਾਹ ਮੇਰੇ ਸੁਆਮੀ ਅਬਰਾਹਾਮ ਦਾ ਪਰਮੇਸ਼ੁਰ ਮੁਬਾਰਕ ਹੋਵੇ, ਜਿਸ ਮੇਰੇ ਸੁਆਮੀ ਅਬਰਾਹਾਮ ਤੋਂ ਆਪਣੀ ਕਿਰਪਾ ਅਤੇ ਆਪਣੀ ਸਚਿਆਈ ਨੂੰ ਨਹੀਂ ਮੋੜਿਆ ਅਤੇ ਮੈਂ ਰਾਹ ਵਿੱਚ ਹੀ ਸੀ ਕਿ ਯਹੋਵਾਹ ਨੇ ਮੈਨੂੰ ਮੇਰੇ ਸੁਆਮੀ ਦੇ ਭਰਾਵਾਂ ਦੇ ਘਰ ਪਹੁੰਚਾਇਆ। ");
INSERT INTO pan_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","ਤਦ ਕੁੜੀ ਆਪਣੀ ਮਾਤਾ ਦੇ ਘਰ ਨੂੰ ਨੱਠ ਕੇ ਆਈ ਅਤੇ ਸਾਰੀਆਂ ਗੱਲਾਂ ਦੱਸੀਆਂ। ");
INSERT INTO pan_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","ਰਿਬਕਾਹ ਦਾ ਇੱਕ ਭਰਾ ਸੀ ਜਿਸ ਦਾ ਨਾਮ ਲਾਬਾਨ ਸੀ, ਲਾਬਾਨ ਬਾਹਰ ਨੂੰ ਉਸ ਮਨੁੱਖ ਦੇ ਕੋਲ ਚਸ਼ਮੇ ਉੱਤੇ ਦੌੜ ਕੇ ਗਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","ਜਦ ਉਸ ਨੇ ਨੱਥ ਅਤੇ ਆਪਣੀ ਭੈਣ ਦੇ ਹੱਥਾਂ ਵਿੱਚ ਕੜੇ ਦੇਖੇ ਅਤੇ ਜਦ ਆਪਣੀ ਭੈਣ ਰਿਬਕਾਹ ਤੋਂ ਗੱਲਾਂ ਸੁਣੀਆਂ ਜਿਹੜੀ ਕਹਿੰਦੀ ਸੀ ਕਿ ਉਸ ਮਨੁੱਖ ਨੇ ਮੇਰੇ ਨਾਲ ਇਹ-ਇਹ ਗੱਲਾਂ ਕੀਤੀਆਂ ਤਾਂ ਉਹ ਉਸ ਮਨੁੱਖ ਕੋਲ ਆਇਆ ਅਤੇ ਵੇਖੋ ਉਹ ਊਠਾਂ ਦੇ ਕੋਲ ਚਸ਼ਮੇ ਉੱਤੇ ਖੜ੍ਹਾ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","ਉਸ ਨੇ ਆਖਿਆ, ਹੇ ਯਹੋਵਾਹ ਦੇ ਮੁਬਾਰਕ ਆਓ। ਬਾਹਰ ਕਿਉਂ ਖੜ੍ਹੇ ਹੋ? ਮੈਂ ਘਰ ਨੂੰ ਤਿਆਰ ਕੀਤਾ ਹੈ ਅਤੇ ਊਠਾਂ ਲਈ ਵੀ ਥਾਂ ਹੈ ");
INSERT INTO pan_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","ਤਦ ਉਹ ਮਨੁੱਖ ਘਰ ਵਿੱਚ ਆਇਆ ਅਤੇ ਊਠਾਂ ਨੂੰ ਖੋਲ੍ਹਿਆ ਅਤੇ ਲਾਬਾਨ ਨੇ ਊਠਾਂ ਨੂੰ ਚਾਰਾ ਦਿੱਤਾ ਅਤੇ ਉਸ ਨੂੰ ਅਤੇ ਉਸ ਦੇ ਸਾਥੀਆਂ ਨੂੰ ਪੈਰ ਧੋਣ ਲਈ ਪਾਣੀ ਦਿੱਤਾ। ");
INSERT INTO pan_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","ਤਾਂ ਉਸ ਦੇ ਅੱਗੇ ਭੋਜਨ ਰੱਖਿਆ ਗਿਆ ਪਰ ਉਸ ਨੇ ਆਖਿਆ ਜਦ ਤੱਕ ਆਪਣੀ ਗੱਲ ਨਾ ਦੱਸਾਂ ਮੈਂ ਕੁਝ ਨਹੀਂ ਖਾਵਾਂਗਾ ਤਾਂ ਲਾਬਾਨ ਨੇ ਆਖਿਆ, ਦੱਸੋ ਜੀ। ");
INSERT INTO pan_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","ਫੇਰ ਉਸ ਨੇ ਆਖਿਆ, ਮੈਂ ਅਬਰਾਹਾਮ ਦਾ ਨੌਕਰ ਹਾਂ ");
INSERT INTO pan_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","ਅਤੇ ਯਹੋਵਾਹ ਨੇ ਮੇਰੇ ਸੁਆਮੀ ਨੂੰ ਵੱਡੀ ਬਰਕਤ ਦਿੱਤੀ ਹੈ ਅਤੇ ਉਸ ਨੂੰ ਵੱਡਾ ਆਦਮੀ ਬਣਾ ਦਿੱਤਾ ਹੈ ਅਤੇ ਉਸ ਨੇ ਉਹ ਨੂੰ ਭੇਡਾਂ, ਗਾਈਆਂ-ਬਲ਼ਦ, ਸੋਨਾ-ਚਾਂਦੀ, ਦਾਸ-ਦਾਸੀਆਂ, ਊਠ ਅਤੇ ਗਧੇ ਦਿੱਤੇ ਹਨ। ");
INSERT INTO pan_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","ਅਤੇ ਮੇਰੇ ਸੁਆਮੀ ਦੀ ਪਤਨੀ ਸਾਰਾਹ ਨੇ ਆਪਣੇ ਬੁਢਾਪੇ ਵਿੱਚ ਮੇਰੇ ਸੁਆਮੀ ਲਈ ਇੱਕ ਪੁੱਤਰ ਜਣਿਆ ਅਤੇ ਅਬਰਾਹਾਮ ਨੇ ਆਪਣਾ ਸਭ ਕੁਝ ਉਸ ਨੂੰ ਦੇ ਦਿੱਤਾ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","ਮੇਰੇ ਸੁਆਮੀ ਨੇ ਮੈਨੂੰ ਇਹ ਸਹੁੰ ਦਿੱਤੀ ਹੈ, ਤੂੰ ਮੇਰੇ ਪੁੱਤਰ ਲਈ ਇਨ੍ਹਾਂ ਕਨਾਨੀਆਂ ਦੀਆਂ ਧੀਆਂ ਵਿੱਚੋਂ ਜਿਨ੍ਹਾਂ ਦੇ ਦੇਸ਼ ਵਿੱਚ ਮੈਂ ਵੱਸਦਾ ਹਾਂ, ਪਤਨੀ ਨਾ ਲਿਆਵੀਂ। ");
INSERT INTO pan_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","ਸਗੋਂ ਮੇਰੇ ਪਿਤਾ ਦੇ ਘਰ ਅਤੇ ਮੇਰੇ ਘਰਾਣੇ ਵਿੱਚ ਜਾਵੀਂ ਅਤੇ ਮੇਰੇ ਪੁੱਤਰ ਲਈ ਪਤਨੀ ਲੈ ਆਵੀਂ। ");
INSERT INTO pan_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","ਤਦ ਮੈਂ ਆਪਣੇ ਸੁਆਮੀ ਨੂੰ ਆਖਿਆ ਕਿ ਸ਼ਾਇਦ ਉਹ ਇਸਤਰੀ ਮੇਰੇ ਨਾਲ ਨਾ ਆਉਣਾ ਚਾਹੇ। ");
INSERT INTO pan_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","ਤਦ ਉਸ ਨੇ ਮੈਨੂੰ ਆਖਿਆ, ਯਹੋਵਾਹ ਜਿਸ ਦੇ ਸਨਮੁਖ ਮੈਂ ਚਲਦਾ ਹਾਂ ਆਪਣਾ ਦੂਤ ਤੇਰੇ ਅੱਗੇ ਭੇਜੇਗਾ ਅਤੇ ਉਹ ਤੇਰੇ ਰਾਹ ਨੂੰ ਸਫ਼ਲ ਕਰੇਗਾ ਅਤੇ ਤੂੰ ਮੇਰੇ ਘਰਾਣੇ ਵਿੱਚੋਂ ਮੇਰੇ ਪਿਤਾ ਦੇ ਘਰੋਂ ਮੇਰੇ ਪੁੱਤਰ ਲਈ ਪਤਨੀ ਲੈ ਆਵੀਂ। ");
INSERT INTO pan_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","ਤਦ ਹੀ ਤੂੰ ਮੇਰੀ ਸਹੁੰ ਤੋਂ ਛੁੱਟੇਂਗਾ, ਜਦ ਤੂੰ ਮੇਰੇ ਘਰਾਣੇ ਵਿੱਚ ਜਾਵੇਂਗਾ ਅਤੇ ਜੇ ਓਹ ਤੈਨੂੰ ਕੋਈ ਇਸਤਰੀ ਨਾ ਦੇਣ ਤਾਂ ਤੂੰ ਮੇਰੀ ਸਹੁੰ ਤੋਂ ਛੁੱਟ ਜਾਵੇਂਗਾ। ");
INSERT INTO pan_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","ਮੈਂ ਅੱਜ ਦੇ ਦਿਨ ਚਸ਼ਮੇ ਉੱਤੇ ਆਇਆ ਅਤੇ ਆਖਿਆ, ਹੇ ਯਹੋਵਾਹ, ਮੇਰੇ ਸੁਆਮੀ ਅਬਰਾਹਾਮ ਦੇ ਪਰਮੇਸ਼ੁਰ, ਜੇ ਤੂੰ ਮੇਰੇ ਰਾਹ ਨੂੰ ਜਿਸ ਵਿੱਚ ਮੈਂ ਜਾਂਦਾ ਹਾਂ ਸਫ਼ਲ ਕਰੇਂ। ");
INSERT INTO pan_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","ਵੇਖ ਮੈਂ ਪਾਣੀ ਦੇ ਚਸ਼ਮੇ ਉੱਤੇ ਖੜ੍ਹਾ ਹਾਂ ਤਾਂ ਅਜਿਹਾ ਹੋਵੇ ਕਿ ਜਿਹੜੀ ਕੁੜੀ ਪਾਣੀ ਭਰਨ ਲਈ ਬਾਹਰ ਆਵੇ ਅਤੇ ਮੈਂ ਉਸ ਨੂੰ ਆਖਾਂ ਕਿ ਮੈਨੂੰ ਆਪਣੇ ਘੜੇ ਤੋਂ ਪਾਣੀ ਪਿਲਾ ਅਤੇ ਉਹ ਮੈਨੂੰ ਆਖੇ, ");
INSERT INTO pan_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","ਪੀ ਲਓ ਜੀ, ਅਤੇ ਮੈਂ ਤੁਹਾਡੇ ਊਠਾਂ ਲਈ ਵੀ ਭਰਾਂਗੀ, ਉਹ ਓਹੀ ਇਸਤਰੀ ਹੋਵੇ ਜਿਸ ਨੂੰ ਯਹੋਵਾਹ ਨੇ ਮੇਰੇ ਸੁਆਮੀ ਦੇ ਪੁੱਤਰ ਲਈ ਠਹਿਰਾਇਆ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","ਮੈਂ ਆਪਣੇ ਦਿਲ ਵਿੱਚ ਆਖਦਾ ਹੀ ਸੀ ਤਾਂ ਵੇਖੋ ਰਿਬਕਾਹ ਆਪਣਾ ਘੜਾ ਮੋਢੇ ਉੱਤੇ ਚੁੱਕ ਕੇ ਬਾਹਰ ਆਈ ਅਤੇ ਉਹ ਚਸ਼ਮੇ ਵਿੱਚ ਉਤਰੀ ਅਤੇ ਪਾਣੀ ਭਰਿਆ ਤਾਂ ਮੈਂ ਉਸ ਨੂੰ ਆਖਿਆ, ਮੈਨੂੰ ਪਾਣੀ ਪਿਲਾਈਂ। ");
INSERT INTO pan_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","ਤਦ ਉਸ ਨੇ ਛੇਤੀ ਨਾਲ ਆਪਣਾ ਘੜਾ ਮੋਢੇ ਤੋਂ ਲਾਹ ਕੇ ਆਖਿਆ, ਪੀਓ ਜੀ, ਮੈਂ ਤੁਹਾਡੇ ਊਠਾਂ ਨੂੰ ਵੀ ਪਿਲਾਵਾਂਗੀ। ਤਦ ਮੈਂ ਪੀਤਾ ਅਤੇ ਉਸ ਨੇ ਮੇਰੇ ਊਠਾਂ ਨੂੰ ਵੀ ਪਿਲਾਇਆ। ");
INSERT INTO pan_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","ਫੇਰ ਮੈਂ ਉਸ ਤੋਂ ਪੁੱਛਿਆ, ਤੂੰ ਕਿਹਦੀ ਧੀ ਹੈਂ? ਤਦ ਉਸ ਨੇ ਆਖਿਆ, ਮੈਂ ਬਥੂਏਲ ਦੀ ਧੀ ਹਾਂ, ਜਿਸ ਨੂੰ ਮਿਲਕਾਹ ਨੇ ਨਾਹੋਰ ਲਈ ਜਨਮ ਦਿੱਤਾ। ਤਦ ਮੈਂ ਉਸ ਦੀ ਨੱਕ ਵਿੱਚ ਨੱਥ ਅਤੇ ਹੱਥਾਂ ਵਿੱਚ ਕੜੇ ਪਾ ਦਿੱਤੇ। ");
INSERT INTO pan_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","ਫਿਰ ਮੈਂ ਆਪਣਾ ਸਿਰ ਝੁਕਾ ਕੇ ਯਹੋਵਾਹ ਅੱਗੇ ਮੱਥਾ ਟੇਕਿਆ ਅਤੇ ਮੈਂ ਯਹੋਵਾਹ ਆਪਣੇ ਸੁਆਮੀ ਅਬਰਾਹਾਮ ਦੇ ਪਰਮੇਸ਼ੁਰ ਨੂੰ ਧੰਨ ਆਖਿਆ ਜਿਸ ਨੇ ਮੈਨੂੰ ਸਹੀ ਰਸਤੇ ਤੇ ਪਾਇਆ ਤਾਂ ਜੋ ਮੈਂ ਆਪਣੇ ਸੁਆਮੀ ਦੇ ਭਰਾ ਦੀ ਧੀ ਉਸ ਦੇ ਪੁੱਤਰ ਵਾਸਤੇ ਲੈ ਜਾਂਵਾਂ। ");
INSERT INTO pan_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","ਹੁਣ ਜੇਕਰ ਤੁਸੀਂ ਮੇਰੇ ਸੁਆਮੀ ਦੇ ਨਾਲ ਕਿਰਪਾ ਅਤੇ ਸਚਿਆਈ ਦਾ ਵਿਵਹਾਰ ਕਰਨਾ ਹੈ ਤਾਂ ਮੈਨੂੰ ਦੱਸੋ ਅਤੇ ਜੇਕਰ ਨਹੀਂ ਤਾਂ ਵੀ ਮੈਨੂੰ ਦੱਸੋ, ਤਾਂ ਜੋ ਮੈਂ ਸੱਜੇ ਜਾਂ ਖੱਬੇ ਪਾਸੇ ਵੱਲ ਮੁੜਾਂ। ");
INSERT INTO pan_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","ਤਦ ਲਾਬਾਨ ਅਤੇ ਬਥੂਏਲ ਨੇ ਜਵਾਬ ਵਿੱਚ ਆਖਿਆ, ਇਹ ਗੱਲ ਯਹੋਵਾਹ ਵੱਲੋਂ ਆਈ ਹੈ। ਅਸੀਂ ਤੁਹਾਨੂੰ ਬੁਰਾ ਜਾਂ ਭਲਾ ਨਹੀਂ ਆਖ ਸਕਦੇ। ");
INSERT INTO pan_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","ਵੇਖੋ, ਰਿਬਕਾਹ ਤੁਹਾਡੇ ਸਾਹਮਣੇ ਹੈ। ਉਹ ਨੂੰ ਲੈ ਜਾਓ ਤਾਂ ਜੋ ਉਹ ਤੁਹਾਡੇ ਸੁਆਮੀ ਦੇ ਪੁੱਤਰ ਦੀ ਪਤਨੀ ਹੋਵੇ, ਜਿਵੇਂ ਯਹੋਵਾਹ ਦਾ ਬਚਨ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","ਜਦ ਅਬਰਾਹਾਮ ਦੇ ਨੌਕਰ ਨੇ ਉਨ੍ਹਾਂ ਦੀਆਂ ਗੱਲਾਂ ਸੁਣੀਆਂ ਤਦ ਉਸ ਨੇ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਧਰਤੀ ਉੱਤੇ ਮੱਥਾ ਟੇਕਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","ਫੇਰ ਉਸ ਨੌਕਰ ਨੇ ਚਾਂਦੀ ਅਤੇ ਸੋਨੇ ਦੇ ਗਹਿਣੇ ਅਤੇ ਬਸਤਰ ਕੱਢ ਕੇ ਰਿਬਕਾਹ ਨੂੰ ਦਿੱਤੇ ਅਤੇ ਉਸ ਨੇ ਉਸ ਦੇ ਭਰਾ ਅਤੇ ਮਾਤਾ ਨੂੰ ਵੀ ਕੀਮਤੀ ਚੀਜ਼ਾਂ ਦਿੱਤੀਆਂ। ");
INSERT INTO pan_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","ਤਦ ਉਸ ਨੇ ਅਤੇ ਉਸ ਦੇ ਸਾਥੀਆਂ ਨੇ ਖਾਧਾ ਪੀਤਾ ਅਤੇ ਰਾਤ ਉੱਥੇ ਹੀ ਕੱਟੀ। ਤੜਕੇ ਉੱਠ ਕੇ ਉਸ ਨੇ ਆਖਿਆ, ਮੈਨੂੰ ਮੇਰੇ ਸੁਆਮੀ ਦੇ ਕੋਲ ਜਾਣ ਲਈ ਵਿਦਿਆ ਕਰੋ। ");
INSERT INTO pan_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","ਰਿਬਕਾਹ ਦੇ ਭਰਾ ਅਤੇ ਉਸ ਦੀ ਮਾਤਾ ਨੇ ਆਖਿਆ, ਕੁੜੀ ਨੂੰ ਥੋੜ੍ਹੇ ਦਿਨ ਅਰਥਾਤ ਦਸ ਦਿਨ ਹੋਰ ਸਾਡੇ ਕੋਲ ਰਹਿਣ ਦਿਓ। ਉਸ ਦੇ ਬਾਅਦ ਉਹ ਚਲੀ ਜਾਵੇਗੀ। ");
INSERT INTO pan_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","ਪਰ ਉਸ ਨੇ ਉਨ੍ਹਾਂ ਨੂੰ ਆਖਿਆ, ਮੈਨੂੰ ਨਾ ਰੋਕੋ ਕਿਉਂ ਜੋ ਯਹੋਵਾਹ ਨੇ ਮੇਰੇ ਸਫ਼ਰ ਨੂੰ ਸਫ਼ਲ ਕੀਤਾ ਹੈ। ਹੁਣ ਮੈਨੂੰ ਵਿਦਿਆ ਕਰੋ ਤਾਂ ਜੋ ਮੈਂ ਆਪਣੇ ਸੁਆਮੀ ਕੋਲ ਜਾਂਵਾਂ। ");
INSERT INTO pan_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","ਉਨ੍ਹਾਂ ਨੇ ਆਖਿਆ, ਅਸੀਂ ਕੁੜੀ ਨੂੰ ਬੁਲਾਉਂਦੇ ਹਾਂ ਅਤੇ ਉਸ ਤੋਂ ਹੀ ਪੁੱਛਦੇ ਹਾਂ ਕਿ ਉਹ ਕੀ ਚਾਹੁੰਦੀ ਹੈ? ");
INSERT INTO pan_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","ਤਦ ਉਨ੍ਹਾਂ ਨੇ ਰਿਬਕਾਹ ਨੂੰ ਸੱਦਿਆ ਅਤੇ ਉਸ ਨੂੰ ਪੁੱਛਿਆ, ਕੀ ਤੂੰ ਇਸ ਮਨੁੱਖ ਦੇ ਨਾਲ ਜਾਵੇਂਗੀ? ਤਾਂ ਉਸ ਨੇ ਆਖਿਆ, ਹਾਂ, ਮੈਂ ਜਾਂਵਾਂਗੀ। ");
INSERT INTO pan_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","ਤਦ ਉਨ੍ਹਾਂ ਨੇ ਆਪਣੀ ਭੈਣ ਰਿਬਕਾਹ, ਉਸ ਦੀ ਦਾਈ, ਅਬਰਾਹਾਮ ਦੇ ਨੌਕਰ ਅਤੇ ਉਸ ਦੇ ਸਾਥੀਆਂ ਨੂੰ ਵਿਦਿਆ ਕਰ ਦਿੱਤਾ। ");
INSERT INTO pan_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","ਉਨ੍ਹਾਂ ਨੇ ਰਿਬਕਾਹ ਨੂੰ ਅਸੀਸ ਦਿੱਤੀ ਅਤੇ ਆਖਿਆ, ਹੇ ਸਾਡੀ ਭੈਣ, ਤੂੰ ਹਜ਼ਾਰਾਂ ਅਤੇ ਲੱਖਾਂ ਦੀ ਮਾਤਾ ਹੋਵੇਂ ਅਤੇ ਤੇਰੀ ਅੰਸ ਵੈਰੀਆਂ ਦੇ ਫਾਟਕ ਦੀ ਅਧਿਕਾਰੀ ਹੋਵੇ। ");
INSERT INTO pan_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","ਤਦ ਰਿਬਕਾਹ ਅਤੇ ਉਸ ਦੀਆਂ ਸਹੇਲੀਆਂ ਉੱਠੀਆਂ ਅਤੇ ਊਠਾਂ ਉੱਤੇ ਚੜ੍ਹ ਗਈਆਂ ਅਤੇ ਉਸ ਮਨੁੱਖ ਦੇ ਪਿੱਛੇ-ਪਿੱਛੇ ਤੁਰ ਪਈਆਂ। ਇਸ ਤਰ੍ਹਾਂ ਉਹ ਨੌਕਰ ਰਿਬਕਾਹ ਨੂੰ ਨਾਲ ਲੈ ਕੇ ਤੁਰ ਪਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","ਇਸਹਾਕ, ਜੋ ਦੱਖਣ ਦੇਸ਼ ਵਿੱਚ ਰਹਿੰਦਾ ਸੀ, ਬਏਰ-ਲਹਈ-ਰੋਈ ਦੇ ਰਸਤੇ ਤੋਂ ਆ ਰਿਹਾ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","ਇਸਹਾਕ ਸ਼ਾਮ ਦੇ ਵੇਲੇ ਖੇਤਾਂ ਵਿੱਚ ਧਿਆਨ ਕਰਨ ਲਈ ਬਾਹਰ ਗਿਆ ਸੀ, ਤਦ ਉਸ ਨੇ ਆਪਣੀਆਂ ਅੱਖਾਂ ਚੁੱਕ ਕੇ ਵੇਖਿਆ ਕਿ ਊਠ ਆ ਰਹੇ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","ਤਦ ਰਿਬਕਾਹ ਨੇ ਵੀ ਅੱਖਾਂ ਚੁੱਕ ਕੇ ਇਸਹਾਕ ਨੂੰ ਵੇਖਿਆ ਤਾਂ ਊਠ ਤੋਂ ਉਤਰ ਗਈ। ");
INSERT INTO pan_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","ਉਸ ਨੇ ਨੌਕਰ ਤੋਂ ਪੁੱਛਿਆ, ਉਹ ਮਨੁੱਖ ਜਿਹੜਾ ਖੇਤ ਦੇ ਵਿੱਚੋਂ ਸਾਨੂੰ ਮਿਲਣ ਲਈ ਆਉਂਦਾ ਹੈ, ਉਹ ਕੌਣ ਹੈ? ਨੌਕਰ ਨੇ ਆਖਿਆ, ਉਹ ਮੇਰਾ ਸੁਆਮੀ ਹੈ, ਤਦ ਰਿਬਕਾਹ ਨੇ ਘੁੰਡ ਕੱਢ ਕੇ ਆਪਣੇ ਆਪ ਨੂੰ ਢੱਕ ਲਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","ਫੇਰ ਨੌਕਰ ਨੇ ਸਾਰੀਆਂ ਗੱਲਾਂ ਜਿਹੜੀਆਂ ਉਸ ਨੇ ਕੀਤੀਆਂ ਸਨ, ਇਸਹਾਕ ਨੂੰ ਦੱਸੀਆਂ। ");
INSERT INTO pan_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","ਤਦ ਇਸਹਾਕ ਉਸ ਨੂੰ ਆਪਣੀ ਮਾਤਾ ਸਾਰਾਹ ਦੇ ਤੰਬੂ ਵਿੱਚ ਲੈ ਗਿਆ ਅਤੇ ਉਸ ਨੇ ਰਿਬਕਾਹ ਨੂੰ ਵਿਆਹ ਲਿਆ ਅਤੇ ਉਹ ਉਸ ਦੀ ਪਤਨੀ ਹੋਈ। ਉਸ ਨੇ ਉਹ ਨੂੰ ਪਿਆਰ ਕੀਤਾ ਤਾਂ ਇਸਹਾਕ ਨੂੰ ਆਪਣੀ ਮਾਤਾ ਦੀ ਮੌਤ ਤੋਂ ਬਾਅਦ ਸ਼ਾਂਤੀ ਮਿਲੀ। ");
INSERT INTO pan_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","ਅਬਰਾਹਾਮ ਨੇ ਇੱਕ ਹੋਰ ਪਤਨੀ ਵਿਆਹ ਲਈ, ਜਿਸ ਦਾ ਨਾਮ ਕਤੂਰਾਹ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","ਉਸ ਨੇ ਜਿਮਰਾਨ, ਯਾਕਸਾਨ, ਮਦਾਨ, ਮਿਦਯਾਨ, ਯਿਸ਼ਬਾਕ ਅਤੇ ਸ਼ੁਆਹ ਨੂੰ ਜਨਮ ਦਿੱਤਾ। ");
INSERT INTO pan_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","ਯਾਕਸਾਨ ਤੋਂ ਸ਼ਬਾ ਅਤੇ ਦਦਾਨ ਜੰਮੇ ਅਤੇ ਦਦਾਨ ਦੇ ਪੁੱਤਰ ਅੱਸੂਰਿਮ, ਲਟੂਸਿਮ ਅਤੇ ਲਉੱਮਿਮ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","ਮਿਦਯਾਨ ਦੇ ਪੁੱਤਰ ਏਫਾਹ, ਏਫਰ, ਹਨੋਕ, ਅਬੀਦਾ ਅਤੇ ਅਲਦਾਅ ਸਨ। ਇਹ ਸਭ ਕਤੂਰਾਹ ਦੇ ਪੁੱਤਰ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","ਅਬਰਾਹਾਮ ਨੇ ਸਭ ਕੁਝ ਜੋ ਉਸ ਦਾ ਸੀ, ਇਸਹਾਕ ਨੂੰ ਦੇ ਦਿੱਤਾ, ");
INSERT INTO pan_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","ਪਰ ਆਪਣੀਆਂ ਰਖ਼ੈਲਾਂ ਦੇ ਪੁੱਤਰਾਂ ਨੂੰ ਅਬਰਾਹਾਮ ਨੇ ਕੁਝ ਸੁਗ਼ਾਤਾਂ ਦੇ ਕੇ ਆਪਣੇ ਪੁੱਤਰ ਇਸਹਾਕ ਦੇ ਕੋਲੋਂ ਪੂਰਬ ਵੱਲ, ਪੂਰਬ ਦੇ ਦੇਸ਼ ਵਿੱਚ ਆਪਣੇ ਜੀਉਂਦੇ ਜੀ ਭੇਜ ਦਿੱਤਾ। ");
INSERT INTO pan_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","ਅਬਰਾਹਾਮ ਦੀ ਕੁੱਲ ਉਮਰ ਇੱਕ ਸੌ ਪੰਝੱਤਰ ਸਾਲ ਦੀ ਹੋਈ। ");
INSERT INTO pan_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","ਅਬਰਾਹਾਮ ਚੰਗੇ ਬਿਰਧਪੁਣੇ ਵਿੱਚ ਅਰਥਾਤ ਪੂਰੇ ਬੁਢਾਪੇ ਵਿੱਚ ਆਪਣੇ ਪ੍ਰਾਣ ਤਿਆਗ ਕੇ ਮਰ ਗਿਆ ਅਤੇ ਆਪਣੇ ਲੋਕਾਂ ਵਿੱਚ ਜਾ ਮਿਲਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","ਤਦ ਉਸ ਦੇ ਪੁੱਤਰਾਂ ਇਸਹਾਕ ਅਤੇ ਇਸਮਾਏਲ ਨੇ ਉਸ ਨੂੰ ਮਕਫ਼ੇਲਾਹ ਦੀ ਗੁਫ਼ਾ ਵਿੱਚ, ਜੋ ਹਿੱਤੀ ਸੋਹਰ ਦੇ ਪੁੱਤਰ ਅਫ਼ਰੋਨ ਦੀ ਪੈਲੀ ਵਿੱਚ ਹੈ, ਜਿਹੜਾ ਮਮਰੇ ਦੇ ਸਾਹਮਣੇ ਹੈ, ਦੱਬ ਦਿੱਤਾ। ");
INSERT INTO pan_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","ਅਰਥਾਤ ਉਸ ਜ਼ਮੀਨ ਵਿੱਚ ਜਿਹੜੀ ਅਬਰਾਹਾਮ ਨੇ ਹੇਤ ਦੇ ਪੁੱਤਰਾਂ ਤੋਂ ਮੁੱਲ ਲਈ ਸੀ, ਉੱਥੇ ਹੀ ਅਬਰਾਹਾਮ ਅਤੇ ਉਸ ਦੀ ਪਤਨੀ ਸਾਰਾਹ ਦੱਬੇ ਗਏ। ");
INSERT INTO pan_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","ਅਬਰਾਹਾਮ ਦੀ ਮੌਤ ਤੋਂ ਬਾਅਦ ਪਰਮੇਸ਼ੁਰ ਨੇ ਉਸ ਦੇ ਪੁੱਤਰ ਇਸਹਾਕ ਨੂੰ ਬਰਕਤ ਦਿੱਤੀ ਅਤੇ ਇਸਹਾਕ ਬਏਰ-ਲਹਈ-ਰੋਈ ਕੋਲ ਰਹਿੰਦਾ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","ਅਬਰਾਹਾਮ ਦੇ ਪੁੱਤਰ ਇਸਮਾਏਲ, ਜਿਸ ਨੂੰ ਸਾਰਾਹ ਦੀ ਦਾਸੀ ਮਿਸਰੀ ਹਾਜ਼ਰਾ ਨੇ ਅਬਰਾਹਾਮ ਲਈ ਜਣਿਆ, ਉਸ ਦੀ ਵੰਸ਼ਾਵਲੀ ਇਹ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","ਇਸਮਾਏਲ ਦੇ ਪੁੱਤਰਾਂ ਦੇ ਨਾਮ ਅਤੇ ਉਨ੍ਹਾਂ ਦੀ ਵੰਸ਼ਾਵਲੀ ਇਹ ਹੈ: ਇਸਮਾਏਲ ਦਾ ਪਹਿਲੌਠਾ ਪੁੱਤਰ ਨਬਾਯੋਤ, ਫਿਰ ਕੇਦਾਰ, ਅਦਬਏਲ ਅਤੇ ਮਿਬਸਾਮ, ");
INSERT INTO pan_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","ਮਿਸ਼ਮਾ, ਦੂਮਾਹ, ਮੱਸਾ, ");
INSERT INTO pan_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","ਹਦਦ, ਤੇਮਾ, ਯਤੂਰ, ਨਾਫ਼ੀਸ਼ ਅਤੇ ਕੇਦਮਾਹ। ");
INSERT INTO pan_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","ਇਹ ਇਸਮਾਏਲ ਦੇ ਪੁੱਤਰ ਸਨ, ਅਤੇ ਇਨ੍ਹਾਂ ਦੇ ਨਾਮਾਂ ਦੇ ਅਨੁਸਾਰ ਉਨ੍ਹਾਂ ਦੇ ਪਿੰਡਾਂ ਅਤੇ ਉਨ੍ਹਾਂ ਦੀਆਂ ਛਾਉਣੀਆਂ ਦੇ ਨਾਮ ਵੀ ਰੱਖੇ ਗਏ ਅਤੇ ਇਹ ਬਾਰਾਂ ਹੀ ਆਪਣੇ-ਆਪਣੇ ਗੋਤਾਂ ਦੇ ਪ੍ਰਧਾਨ ਹੋਏ। ");
INSERT INTO pan_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","ਇਸਮਾਏਲ ਦੀ ਕੁੱਲ ਉਮਰ ਇੱਕ ਸੌ ਸੈਂਤੀ ਸਾਲ ਹੋਈ ਤਦ ਉਹ ਪ੍ਰਾਣ ਤਿਆਗ ਕੇ ਮਰ ਗਿਆ ਅਤੇ ਆਪਣੇ ਲੋਕਾਂ ਵਿੱਚ ਜਾ ਮਿਲਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","ਉਸਦਾ ਵੰਸ਼ ਹਵੀਲਾਹ ਤੋਂ ਲੈ ਕੇ ਸ਼ੂਰ ਤੱਕ, ਜਿਹੜਾ ਅੱਸ਼ੂਰ ਵੱਲ ਜਾਂਦਿਆਂ ਮਿਸਰ ਦੇ ਸਾਹਮਣੇ ਹੈ, ਵੱਸ ਗਿਆ ਅਤੇ ਉਹ ਆਪਣੇ ਸਾਰੇ ਭਰਾਵਾਂ ਦੇ ਸਨਮੁਖ ਵੱਸ ਗਏ। ");
INSERT INTO pan_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","ਇਹ ਅਬਰਾਹਾਮ ਦੇ ਪੁੱਤਰ ਇਸਹਾਕ ਦੀ ਵੰਸ਼ਾਵਲੀ ਹੈ: ਅਬਰਾਹਾਮ ਤੋਂ ਇਸਹਾਕ ਜੰਮਿਆ, ");
INSERT INTO pan_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","ਅਤੇ ਇਸਹਾਕ ਚਾਲ੍ਹੀ ਸਾਲ ਦਾ ਹੋਇਆ ਜਦ ਉਹ ਰਿਬਕਾਹ ਨੂੰ ਆਪਣੀ ਪਤਨੀ ਬਣਾਉਣ ਲਈ ਲੈ ਆਇਆ, ਜਿਹੜੀ ਪਦਨ ਅਰਾਮ ਦੇ ਵਾਸੀ ਬਥੂਏਲ ਅਰਾਮੀ ਦੀ ਧੀ ਸੀ ਅਤੇ ਲਾਬਾਨ ਅਰਾਮੀ ਦੀ ਭੈਣ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","ਇਸਹਾਕ ਨੇ ਯਹੋਵਾਹ ਕੋਲੋਂ ਆਪਣੀ ਪਤਨੀ ਲਈ ਬੇਨਤੀ ਕੀਤੀ ਕਿਉਂ ਜੋ ਉਹ ਬਾਂਝ ਸੀ, ਤਦ ਯਹੋਵਾਹ ਨੇ ਉਸ ਦੀ ਬੇਨਤੀ ਸੁਣੀ ਅਤੇ ਰਿਬਕਾਹ ਉਸ ਦੀ ਪਤਨੀ ਗਰਭਵਤੀ ਹੋਈ। ");
INSERT INTO pan_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","ਬੱਚੇ ਉਸ ਦੀ ਕੁੱਖ ਵਿੱਚ ਇੱਕ ਦੂਜੇ ਨਾਲ ਘੁਲਦੇ ਸਨ, ਤਦ ਉਸ ਨੇ ਆਖਿਆ, ਜੇਕਰ ਮੇਰੀ ਹਾਲਤ ਇਸੇ ਤਰ੍ਹਾਂ ਹੀ ਰਹੀ ਤਾਂ ਮੈਂ ਕਿਵੇਂ ਜੀਉਂਦੀ ਰਹਾਂਗੀ? ਤਦ ਉਹ ਯਹੋਵਾਹ ਕੋਲੋਂ ਪੁੱਛਣ ਗਈ। ");
INSERT INTO pan_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","ਤਦ ਯਹੋਵਾਹ ਨੇ ਉਸ ਨੂੰ ਆਖਿਆ, ਤੇਰੀ ਕੁੱਖ ਵਿੱਚ ਦੋ ਕੌਮਾਂ ਹਨ ਅਤੇ ਤੇਰੀ ਕੁੱਖੋਂ ਹੀ ਓਹ ਦੋਵੇਂ ਜਾਤੀਆਂ ਵੱਖਰੀਆਂ ਹੋ ਜਾਣਗੀਆਂ ਅਤੇ ਇੱਕ ਜਾਤੀ ਦੂਜੀ ਜਾਤੀ ਨਾਲੋਂ ਬਲਵੰਤ ਹੋਵੇਗੀ ਅਤੇ ਵੱਡਾ ਛੋਟੇ ਦੀ ਸੇਵਾ ਕਰੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","ਜਦ ਉਸ ਦੇ ਜਣਨ ਦੇ ਦਿਨ ਪੂਰੇ ਹੋਏ ਤਾਂ ਵੇਖੋ ਉਸ ਦੀ ਕੁੱਖ ਵਿੱਚ ਜੁੜਵਾਂ ਬੱਚੇ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","ਪਹਿਲੌਠਾ ਸਾਰੇ ਦਾ ਸਾਰਾ ਲਾਲ ਜੱਤ ਵਾਲੇ ਬਸਤਰ ਵਰਗਾ ਬਾਹਰ ਨਿੱਕਲਿਆ, ਇਸ ਲਈ ਉਨ੍ਹਾਂ ਨੇ ਉਸ ਦਾ ਨਾਮ ਏਸਾਓ ਰੱਖਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","ਉਸ ਦੇ ਬਾਅਦ ਉਸ ਦਾ ਭਰਾ ਨਿੱਕਲਿਆ ਅਤੇ ਉਸ ਦੇ ਹੱਥ ਨੇ ਏਸਾਓ ਦੀ ਅੱਡੀ ਫੜੀ ਹੋਈ ਸੀ, ਤਾਂ ਉਸ ਦਾ ਨਾਮ ਯਾਕੂਬ ਰੱਖਿਆ ਗਿਆ। ਜਦ ਰਿਬਕਾਹ ਨੇ ਉਨ੍ਹਾਂ ਨੂੰ ਜਨਮ ਦਿੱਤਾ ਉਸ ਸਮੇਂ ਇਸਹਾਕ ਸੱਠ ਸਾਲ ਦਾ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","ਉਹ ਮੁੰਡੇ ਵੱਡੇ ਹੋਏ। ਏਸਾਓ ਨਿਪੁੰਨ ਸ਼ਿਕਾਰੀ ਬਣਿਆ ਅਤੇ ਮੈਦਾਨ ਵਿੱਚ ਰਹਿਣ ਵਾਲਾ ਸੀ ਅਤੇ ਯਾਕੂਬ ਭੋਲਾ-ਭਾਲਾ ਅਤੇ ਤੰਬੂਆਂ ਵਿੱਚ ਰਹਿਣ ਵਾਲਾ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","ਇਸਹਾਕ ਏਸਾਓ ਨੂੰ ਪਿਆਰ ਕਰਦਾ ਸੀ ਕਿਉਂ ਜੋ ਉਹ ਉਸ ਲਈ ਸ਼ਿਕਾਰ ਫੜ੍ਹ ਕੇ ਲਿਆਉਂਦਾ ਸੀ ਪਰ ਰਿਬਕਾਹ ਯਾਕੂਬ ਨੂੰ ਪਿਆਰ ਕਰਦੀ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","ਇੱਕ ਦਿਨ ਯਾਕੂਬ ਦਾਲ ਪਕਾ ਰਿਹਾ ਸੀ ਅਤੇ ਏਸਾਓ ਮੈਦਾਨ ਵਿੱਚੋਂ ਥੱਕਿਆ ਹੋਇਆ ਆਇਆ। ");
INSERT INTO pan_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","ਤਦ ਏਸਾਓ ਨੇ ਯਾਕੂਬ ਨੂੰ ਆਖਿਆ, ਇਸੇ ਲਾਲ ਦਾਲ ਵਿੱਚੋਂ ਮੈਨੂੰ ਵੀ ਖਾਣ ਨੂੰ ਦੇ, ਕਿਉਂ ਜੋ ਮੈਂ ਥੱਕਿਆ ਹੋਇਆ ਹਾਂ। ਇਸੇ ਕਾਰਨ ਉਸ ਦਾ ਨਾਮ ਅਦੋਮ ਪੈ ਗਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","ਯਾਕੂਬ ਨੇ ਆਖਿਆ, ਤੂੰ ਅੱਜ ਆਪਣਾ ਪਹਿਲੌਠਾ ਹੋਣ ਦੇ ਹੱਕ ਨੂੰ ਮੈਨੂੰ ਵੇਚ ਦੇ। ");
INSERT INTO pan_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","ਏਸਾਓ ਨੇ ਆਖਿਆ, ਵੇਖ, ਮੈਂ ਮਰ ਰਿਹਾ ਹਾਂ। ਇਹ ਪਹਿਲੌਠਾ ਹੋਣਾ ਮੇਰੇ ਕਿਸ ਕੰਮ ਦਾ ਹੈ? ");
INSERT INTO pan_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","ਯਾਕੂਬ ਨੇ ਆਖਿਆ, ਤੂੰ ਅੱਜ ਮੇਰੇ ਕੋਲ ਸਹੁੰ ਖਾਹ, ਤਾਂ ਉਸ ਨੇ ਸਹੁੰ ਖਾਧੀ ਅਤੇ ਆਪਣੇ ਪਹਿਲੌਠੇ ਹੋਣ ਦਾ ਹੱਕ ਯਾਕੂਬ ਕੋਲ ਵੇਚ ਦਿੱਤਾ। ");
INSERT INTO pan_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","ਤਦ ਯਾਕੂਬ ਨੇ ਏਸਾਓ ਨੂੰ ਰੋਟੀ ਅਤੇ ਦਾਲ ਦਿੱਤੀ ਅਤੇ ਉਸ ਨੇ ਖਾਧਾ ਪੀਤਾ ਅਤੇ ਉੱਠ ਕੇ ਆਪਣੇ ਰਾਹ ਚਲਾ ਗਿਆ। ਇਸ ਤਰ੍ਹਾਂ ਏਸਾਓ ਨੇ ਆਪਣੇ ਪਹਿਲੌਠੇ ਹੋਣ ਦੇ ਹੱਕ ਨੂੰ ਤੁੱਛ ਜਾਣਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","ਉਸ ਦੇਸ਼ ਵਿੱਚ ਕਾਲ ਪਿਆ ਅਤੇ ਇਹ ਪਹਿਲੇ ਕਾਲ ਤੋਂ ਵੱਖ ਸੀ, ਜਿਹੜਾ ਅਬਰਾਹਾਮ ਦੇ ਦਿਨਾਂ ਵਿੱਚ ਪਿਆ ਸੀ। ਇਸ ਕਾਰਨ ਇਸਹਾਕ ਗਰਾਰ ਨੂੰ, ਫ਼ਲਿਸਤੀਆਂ ਦੇ ਰਾਜਾ ਅਬੀਮਲਕ ਕੋਲ ਚਲਾ ਗਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","ਤਦ ਯਹੋਵਾਹ ਨੇ ਉਸ ਨੂੰ ਦਰਸ਼ਣ ਦੇ ਕੇ ਆਖਿਆ, ਮਿਸਰ ਨੂੰ ਨਾ ਜਾਈਂ ਪਰ ਉਸ ਦੇਸ਼ ਵਿੱਚ ਜਾਈਂ, ਜਿਹੜਾ ਮੈਂ ਤੈਨੂੰ ਦੱਸਾਂਗਾ। ");
INSERT INTO pan_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","ਤੂੰ ਉਸ ਦੇਸ਼ ਵਿੱਚ ਜਾ ਟਿੱਕੀਂ। ਮੈਂ ਤੇਰੇ ਅੰਗ-ਸੰਗ ਹੋਵਾਂਗਾ ਅਤੇ ਤੈਨੂੰ ਬਰਕਤ ਦਿਆਂਗਾ ਕਿਉਂ ਜੋ ਮੈਂ ਤੈਨੂੰ ਅਤੇ ਤੇਰੀ ਅੰਸ ਨੂੰ ਇਹ ਸਾਰੇ ਦੇਸ਼ ਦਿਆਂਗਾ। ਮੈਂ ਉਸ ਸਹੁੰ ਨੂੰ ਜਿਹੜੀ ਮੈਂ ਤੇਰੇ ਪਿਤਾ ਅਬਰਾਹਾਮ ਨਾਲ ਖਾਧੀ ਸੀ, ਪੂਰੀ ਕਰਾਂਗਾ। ");
INSERT INTO pan_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","ਮੈਂ ਤੇਰੀ ਅੰਸ ਨੂੰ ਅਕਾਸ਼ ਦੇ ਤਾਰਿਆਂ ਵਾਂਗੂੰ ਵਧਾਵਾਂਗਾ ਅਤੇ ਮੈਂ ਤੇਰੀ ਅੰਸ ਨੂੰ ਇਹ ਸਾਰੇ ਦੇਸ਼ ਦਿਆਂਗਾ ਅਤੇ ਤੇਰੀ ਅੰਸ ਤੋਂ ਧਰਤੀ ਦੀਆਂ ਸਾਰੀਆਂ ਕੌਮਾਂ ਬਰਕਤ ਪਾਉਣਗੀਆਂ। ");
INSERT INTO pan_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","ਕਿਉਂ ਜੋ ਅਬਰਾਹਾਮ ਨੇ ਮੇਰੀ ਅਵਾਜ਼ ਨੂੰ ਸੁਣਿਆ ਅਤੇ ਮੇਰੇ ਹੁਕਮਾਂ, ਮੇਰੀ ਬਿਧੀਆਂ ਅਤੇ ਮੇਰੀ ਬਿਵਸਥਾ ਦੀ ਪਾਲਨਾ ਕੀਤੀ। ");
INSERT INTO pan_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","ਇਸਹਾਕ ਗਰਾਰ ਵਿੱਚ ਵੱਸਿਆ ਰਿਹਾ ");
INSERT INTO pan_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","ਜਦ ਉਸ ਥਾਂ ਦੇ ਮਨੁੱਖਾਂ ਨੇ ਉਸ ਦੀ ਪਤਨੀ ਵਿਖੇ ਪੁੱਛਿਆ ਤਾਂ ਉਸ ਨੇ ਆਖਿਆ, ਉਹ ਮੇਰੀ ਭੈਣ ਹੈ, ਕਿਉਂ ਜੋ ਉਹ ਇਹ ਸੋਚ ਕੇ ਡਰਦਾ ਸੀ, ਜੇਕਰ ਮੈਂ ਦੱਸਾਂ ਕਿ ਉਹ ਮੇਰੀ ਪਤਨੀ ਹੈ ਤਾਂ ਅਜਿਹਾ ਨਾ ਹੋਵੇ ਕਿ ਉਸ ਥਾਂ ਦੇ ਮਨੁੱਖ ਰਿਬਕਾਹ ਦੇ ਕਾਰਨ ਮੈਨੂੰ ਮਾਰ ਸੁੱਟਣ, ਕਿਉਂ ਜੋ ਉਹ ਵੇਖਣ ਵਿੱਚ ਸੋਹਣੀ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","ਜਦ ਉਸ ਨੂੰ ਉੱਥੇ ਰਹਿੰਦੇ ਹੋਏ ਬਹੁਤ ਦਿਨ ਬੀਤ ਗਏ ਤਾਂ ਅਬੀਮਲਕ ਫ਼ਲਿਸਤੀਆਂ ਦੇ ਰਾਜਾ ਨੇ ਇੱਕ ਦਿਨ ਖਿੜਕੀ ਵਿੱਚੋਂ ਦੀ ਝਾਤੀ ਮਾਰ ਕੇ ਵੇਖਿਆ ਤਾਂ ਵੇਖੋ ਇਸਹਾਕ ਆਪਣੀ ਪਤਨੀ ਰਿਬਕਾਹ ਨਾਲ ਲਾਡ-ਪਿਆਰ ਕਰ ਰਿਹਾ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","ਤਦ ਅਬੀਮਲਕ ਨੇ ਇਸਹਾਕ ਨੂੰ ਬੁਲਾ ਕੇ ਆਖਿਆ, ਵੇਖ ਉਹ ਸੱਚ-ਮੁੱਚ ਤੇਰੀ ਪਤਨੀ ਹੈ ਅਤੇ ਤੂੰ ਕਿਉਂ ਆਖਿਆ, ਕਿ ਉਹ ਮੇਰੀ ਭੈਣ ਹੈ? ਇਸਹਾਕ ਨੇ ਉਸ ਨੂੰ ਆਖਿਆ, ਮੈਂ ਇਹ ਸੋਚਿਆ, ਕਿਤੇ ਮੈਂ ਉਹ ਦੇ ਕਾਰਨ ਮਰ ਨਾ ਜਾਂਵਾਂ। ");
INSERT INTO pan_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","ਅਬੀਮਲਕ ਨੇ ਆਖਿਆ, ਤੂੰ ਸਾਡੇ ਨਾਲ ਇਹ ਕੀ ਕੀਤਾ ਹੈ? ਇਸ ਤਰ੍ਹਾਂ ਤਾਂ ਲੋਕਾਂ ਵਿੱਚੋਂ ਕੋਈ ਤੇਰੀ ਪਤਨੀ ਦੇ ਸੰਗ ਲੇਟਦਾ ਤਾਂ ਤੂੰ ਸਾਨੂੰ ਵੀ ਪਾਪ ਦਾ ਭਾਗੀ ਬਣਾਉਂਦਾ। ");
INSERT INTO pan_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","ਤਦ ਅਬੀਮਲਕ ਨੇ ਸਾਰਿਆਂ ਲੋਕਾਂ ਨੂੰ ਇਹ ਹੁਕਮ ਦਿੱਤਾ ਕਿ ਜੋ ਕੋਈ ਇਸ ਮਨੁੱਖ ਅਤੇ ਇਸ ਦੀ ਪਤਨੀ ਨੂੰ ਹੱਥ ਲਾਵੇਗਾ, ਉਹ ਜ਼ਰੂਰ ਮਾਰਿਆ ਜਾਵੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","ਇਸਹਾਕ ਨੇ ਉਸ ਧਰਤੀ ਵਿੱਚ ਬੀਜ ਬੀਜਿਆ ਅਤੇ ਉਸੇ ਸਾਲ ਸੌ ਗੁਣਾ ਫਲ ਪ੍ਰਾਪਤ ਕੀਤਾ ਅਤੇ ਯਹੋਵਾਹ ਨੇ ਉਸ ਨੂੰ ਬਰਕਤ ਦਿੱਤੀ। ");
INSERT INTO pan_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","ਸੋ ਉਹ ਵੱਧ ਗਿਆ ਅਤੇ ਵੱਧਦਾ ਚਲਾ ਗਿਆ ਅਤੇ ਉਹ ਅੱਤ ਵੱਡਾ ਮਨੁੱਖ ਹੋ ਗਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","ਉਹ ਭੇਡਾਂ-ਬੱਕਰੀਆਂ, ਗਾਈਆਂ-ਬਲ਼ਦਾਂ ਅਤੇ ਬਹੁਤ ਸਾਰੇ ਸੇਵਕਾਂ ਦਾ ਮਾਲਕ ਹੋ ਗਿਆ ਅਤੇ ਫ਼ਲਿਸਤੀ ਉਸ ਤੋਂ ਸੜਨ ਲੱਗੇ। ");
INSERT INTO pan_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","ਇਸ ਲਈ ਸਾਰੇ ਖੂਹਾਂ ਨੂੰ ਜਿਹੜੇ ਉਸ ਦੇ ਪਿਤਾ ਅਬਰਾਹਾਮ ਦੇ ਸੇਵਕਾਂ ਨੇ ਉਸ ਦੇ ਜੀਉਂਦੇ ਜੀ ਪੁੱਟੇ ਸਨ, ਫ਼ਲਿਸਤੀਆਂ ਨੇ ਬੰਦ ਕਰ ਦਿੱਤੇ ਅਤੇ ਮਿੱਟੀ ਨਾਲ ਭਰ ਦਿੱਤੇ। ");
INSERT INTO pan_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","ਅਬੀਮਲਕ ਨੇ ਇਸਹਾਕ ਨੂੰ ਆਖਿਆ, ਸਾਡੇ ਕੋਲੋਂ ਚਲਾ ਜਾ, ਕਿਉਂ ਜੋ ਤੂੰ ਸਾਡੇ ਨਾਲੋਂ ਵੱਡਾ ਬਲਵੰਤ ਹੋ ਗਿਆ ਹੈਂ। ");
INSERT INTO pan_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","ਤਦ ਇਸਹਾਕ ਉੱਥੋਂ ਚਲਾ ਗਿਆ ਅਤੇ ਗਰਾਰ ਦੀ ਘਾਟੀ ਵਿੱਚ ਆਪਣਾ ਤੰਬੂ ਲਾਇਆ ਅਤੇ ਉੱਥੇ ਰਹਿਣ ਲੱਗਾ। ");
INSERT INTO pan_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","ਤਦ ਇਸਹਾਕ ਨੇ ਪਾਣੀ ਦੇ ਖੂਹਾਂ ਨੂੰ ਜਿਹੜੇ ਉਸ ਦੇ ਪਿਤਾ ਅਬਰਾਹਾਮ ਦੇ ਦਿਨਾਂ ਵਿੱਚ ਪੁੱਟੇ ਗਏ ਸਨ, ਅਤੇ ਜਿਹੜੇ ਫ਼ਲਿਸਤੀਆਂ ਨੇ ਅਬਰਾਹਾਮ ਦੀ ਮੌਤ ਦੇ ਪਿੱਛੋਂ ਬੰਦ ਕਰ ਦਿੱਤੇ ਸਨ, ਦੁਬਾਰਾ ਪੁੱਟਿਆ ਅਤੇ ਉਸ ਨੇ ਉਨ੍ਹਾਂ ਖੂਹਾਂ ਦੇ ਨਾਮ ਅਬਰਾਹਾਮ ਦੇ ਰੱਖੇ ਹੋਏ ਨਾਵਾਂ ਉੱਤੇ ਰੱਖੇ। ");
INSERT INTO pan_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","ਇਸਹਾਕ ਦੇ ਸੇਵਕਾਂ ਨੂੰ ਘਾਟੀ ਵਿੱਚ ਪੁੱਟਦੇ ਹੋਏ, ਸੁੰਬ ਫੁੱਟਦੇ ਪਾਣੀ ਦਾ ਇੱਕ ਖੂਹ ਲੱਭਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","ਤਦ ਗਰਾਰ ਦੇ ਆਜੜੀਆਂ ਨੇ ਇਸਹਾਕ ਦੇ ਆਜੜੀਆਂ ਨੂੰ ਕੌੜੇ ਬਚਨ ਬੋਲੇ ਅਤੇ ਕਿਹਾ, ਇਹ ਪਾਣੀ ਸਾਡਾ ਹੈ। ਉਸ ਨੇ ਉਸ ਖੂਹ ਦਾ ਨਾਮ ਏਸਕ ਰੱਖਿਆ ਕਿਉਂ ਜੋ ਓਹ ਉਸ ਦੇ ਨਾਲ ਝਗੜਦੇ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","ਤਦ ਉਨ੍ਹਾਂ ਨੇ ਇੱਕ ਹੋਰ ਖੂਹ ਪੁੱਟਿਆ ਅਤੇ ਉਸ ਦੇ ਵਿਖੇ ਵੀ ਕੌੜੇ ਬਚਨ ਬੋਲੇ ਤਦ ਉਹ ਨੇ ਉਸ ਖੂਹ ਦਾ ਨਾਮ ਸਿਟਨਾ ਰੱਖਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","ਤਦ ਉਹ ਉੱਥੋਂ ਅੱਗੇ ਤੁਰ ਪਿਆ ਅਤੇ ਇੱਕ ਹੋਰ ਖੂਹ ਪੁੱਟਿਆ ਅਤੇ ਉਸ ਵਿਖੇ ਉਨ੍ਹਾਂ ਨੇ ਕੌੜੇ ਬਚਨ ਨਹੀਂ ਬੋਲੇ, ਇਸ ਲਈ ਉਹ ਨੇ ਉਸ ਖੂਹ ਦਾ ਨਾਮ ਇਹ ਆਖ ਕੇ ਰਹੋਬੋਥ ਰੱਖਿਆ ਕਿ ਹੁਣ ਯਹੋਵਾਹ ਨੇ ਸਾਨੂੰ ਚੌੜਾ ਸਥਾਨ ਦਿੱਤਾ ਹੈ ਅਤੇ ਅਸੀਂ ਇਸ ਧਰਤੀ ਵਿੱਚ ਫਲਾਂਗੇ। ਉਹ ਉੱਥੋਂ ਉਤਾਹਾਂ ਬਏਰਸ਼ਬਾ ਨੂੰ ਗਿਆ, ");
INSERT INTO pan_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","ਉਸੇ ਰਾਤ ਯਹੋਵਾਹ ਨੇ ਉਹ ਨੂੰ ਦਰਸ਼ਣ ਦਿੱਤਾ ਅਤੇ ਆਖਿਆ, ਮੈਂ ਤੇਰੇ ਪਿਤਾ ਅਬਰਾਹਾਮ ਦਾ ਪਰਮੇਸ਼ੁਰ ਹਾਂ। ");
INSERT INTO pan_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","ਨਾ ਡਰ ਕਿਉਂ ਜੋ ਮੈਂ ਤੇਰੇ ਸੰਗ ਹਾਂ ਅਤੇ ਮੈਂ ਤੈਨੂੰ ਬਰਕਤ ਦਿਆਂਗਾ ਅਤੇ ਤੇਰੀ ਅੰਸ ਨੂੰ ਅਬਰਾਹਾਮ ਆਪਣੇ ਦਾਸ ਦੇ ਕਾਰਨ ਵਧਾਵਾਂਗਾ। ");
INSERT INTO pan_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","ਇਸ ਲਈ ਉਸ ਨੇ ਉੱਥੇ ਇੱਕ ਜਗਵੇਦੀ ਬਣਾਈ ਅਤੇ ਯਹੋਵਾਹ ਦਾ ਨਾਮ ਪੁਕਾਰਿਆ ਅਤੇ ਉੱਥੇ ਆਪਣਾ ਤੰਬੂ ਖੜ੍ਹਾ ਕੀਤਾ ਅਤੇ ਉੱਥੇ ਇਸਹਾਕ ਦੇ ਸੇਵਕਾਂ ਨੇ ਇੱਕ ਖੂਹ ਪੁੱਟਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","ਤਦ ਅਬੀਮਲਕ ਆਪਣੇ ਮਿੱਤਰ ਅਹੁੱਜ਼ਥ ਅਤੇ ਆਪਣੇ ਸੈਨਾਪਤੀ ਫ਼ੀਕੋਲ ਨੂੰ ਨਾਲ ਲੈ ਕੇ ਗਰਾਰ ਤੋਂ ਉਹ ਦੇ ਕੋਲ ਆਏ। ");
INSERT INTO pan_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","ਪਰ ਇਸਹਾਕ ਨੇ ਉਨ੍ਹਾਂ ਨੂੰ ਆਖਿਆ, ਤੁਸੀਂ ਕਿਉਂ ਮੇਰੇ ਕੋਲ ਆਏ ਹੋ, ਜਦ ਕਿ ਤੁਸੀਂ ਮੇਰੇ ਨਾਲ ਵੈਰ ਕਰਕੇ ਮੈਨੂੰ ਆਪਣੇ ਵਿੱਚੋਂ ਕੱਢ ਦਿੱਤਾ ਸੀ? ");
INSERT INTO pan_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","ਤਦ ਉਨ੍ਹਾਂ ਨੇ ਆਖਿਆ, ਹੁਣ ਅਸੀਂ ਸਾਫ਼-ਸਾਫ਼ ਵੇਖਿਆ ਹੈ ਕਿ ਯਹੋਵਾਹ ਤੁਹਾਡੇ ਸੰਗ ਹੈ ਇਸ ਲਈ ਅਸੀਂ ਸੋਚਿਆ ਕਿ ਸਾਡੇ ਦੋਹਾਂ ਦੇ ਵਿਚਕਾਰ ਅਰਥਾਤ ਸਾਡੇ ਅਤੇ ਤੁਹਾਡੇ ਵਿੱਚ ਇੱਕ ਸਮਝੌਤਾ ਹੋਵੇ ਅਤੇ ਅਸੀਂ ਇੱਕ ਨੇਮ ਤੁਹਾਡੇ ਨਾਲ ਬੰਨ੍ਹੀਏ। ");
INSERT INTO pan_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","ਜਿਵੇਂ ਅਸੀਂ ਤੁਹਾਨੂੰ ਹੱਥ ਨਹੀਂ ਲਾਇਆ ਅਤੇ ਤੁਹਾਡੇ ਨਾਲ ਭਲਿਆਈ ਹੀ ਕੀਤੀ ਅਤੇ ਤੁਹਾਨੂੰ ਸ਼ਾਂਤੀ ਨਾਲ ਤੋਰ ਦਿੱਤਾ, ਉਸੇ ਤਰ੍ਹਾਂ ਤੁਸੀਂ ਵੀ ਸਾਡੇ ਨਾਲ ਬੁਰਿਆਈ ਨਾ ਕਰਿਓ। ਹੁਣ ਤੁਸੀਂ ਯਹੋਵਾਹ ਵੱਲੋਂ ਮੁਬਾਰਕ ਹੋ। ");
INSERT INTO pan_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","ਤਦ ਉਸ ਨੇ ਉਹਨਾਂ ਦੀ ਦਾਵਤ ਕੀਤੀ ਅਤੇ ਉਨ੍ਹਾਂ ਨੇ ਖਾਧਾ ਪੀਤਾ। ");
INSERT INTO pan_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","ਸਵੇਰੇ ਉੱਠ ਕੇ ਹਰ ਇੱਕ ਨੇ ਆਪਣੇ ਭਰਾ ਨਾਲ ਸਹੁੰ ਖਾਧੀ ਅਤੇ ਇਸਹਾਕ ਨੇ ਉਨ੍ਹਾਂ ਨੂੰ ਤੋਰ ਦਿੱਤਾ ਅਤੇ ਓਹ ਸ਼ਾਂਤੀ ਨਾਲ ਉੱਥੋਂ ਚਲੇ ਗਏ। ");
INSERT INTO pan_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","ਉਸੇ ਦਿਨ ਇਹ ਹੋਇਆ ਕਿ ਇਸਹਾਕ ਦੇ ਸੇਵਕਾਂ ਨੇ ਆ ਕੇ ਉਸ ਖੂਹ ਦੇ ਵਿਖੇ ਜਿਹੜਾ ਉਨ੍ਹਾਂ ਪੁੱਟਿਆ ਸੀ, ਉਹ ਨੂੰ ਦੱਸਿਆ ਕਿ ਸਾਨੂੰ ਪਾਣੀ ਲੱਭਿਆ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","ਤਦ ਉਸ ਨੇ ਉਸ ਖੂਹ ਦਾ ਨਾਮ ਸ਼ਿਬਆਹ ਰੱਖਿਆ। ਇਸ ਕਾਰਨ ਉਸ ਨਗਰ ਦਾ ਨਾਮ ਅੱਜ ਤੱਕ ਬਏਰਸ਼ਬਾ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","ਜਦ ਏਸਾਓ ਚਾਲ੍ਹੀ ਸਾਲ ਦਾ ਸੀ ਤਾਂ ਉਹ ਬੇਰੀ ਹਿੱਤੀ ਦੀ ਧੀ ਯਹੂਦਿਥ ਅਤੇ ਏਲੋਨ ਹਿੱਤੀ ਦੀ ਧੀ ਬਾਸਮਥ ਨੂੰ ਵਿਆਹ ਲਿਆਇਆ। ");
INSERT INTO pan_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","ਅਤੇ ਇਹ ਗੱਲ ਇਸਹਾਕ ਅਤੇ ਰਿਬਕਾਹ ਦੇ ਮਨਾਂ ਲਈ ਕੁੜੱਤਣ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","ਜਦ ਇਸਹਾਕ ਵੱਡੀ ਉਮਰ ਦਾ ਹੋ ਗਿਆ, ਉਸ ਦੀਆਂ ਅੱਖਾਂ ਧੁੰਦਲਾ ਗਈਆਂ ਕਿ ਉਹ ਵੇਖ ਨਹੀਂ ਸਕਦਾ ਸੀ। ਤਦ ਉਸ ਨੇ ਆਪਣੇ ਵੱਡੇ ਪੁੱਤਰ ਏਸਾਓ ਨੂੰ ਸੱਦ ਕੇ ਆਖਿਆ, ਮੇਰੇ ਪੁੱਤਰ, ਉਸ ਨੇ ਆਖਿਆ, ਮੈਂ ਹਾਜ਼ਰ ਹਾਂ। ");
INSERT INTO pan_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","ਤਦ ਉਸ ਆਖਿਆ, ਵੇਖ ਮੈਂ ਬੁੱਢਾ ਹੋ ਗਿਆ ਹਾਂ ਅਤੇ ਮੈਂ ਆਪਣੀ ਮੌਤ ਦਾ ਦਿਨ ਨਹੀਂ ਜਾਣਦਾ। ");
INSERT INTO pan_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","ਸੋ ਤੂੰ ਹੁਣ ਆਪਣੇ ਸ਼ਸਤਰ ਅਰਥਾਤ ਧਣੁੱਖ ਅਤੇ ਤਰਕਸ਼ ਲੈ ਅਤੇ ਮੈਦਾਨ ਵਿੱਚ ਜਾ ਕੇ ਮੇਰੇ ਲਈ ਸ਼ਿਕਾਰ ਮਾਰ, ");
INSERT INTO pan_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","ਅਤੇ ਮੇਰੇ ਲਈ ਸੁਆਦਲਾ ਭੋਜਨ ਤਿਆਰ ਕਰ ਜਿਹੜਾ ਮੈਨੂੰ ਚੰਗਾ ਲੱਗਦਾ ਹੈ, ਅਤੇ ਮੇਰੇ ਅੱਗੇ ਪਰੋਸ ਤਾਂ ਜੋ ਮੈਂ ਖਾਵਾਂ ਅਤੇ ਮਰਨ ਤੋਂ ਪਹਿਲਾਂ ਤੈਨੂੰ ਬਰਕਤ ਦੇਵਾਂ। ");
INSERT INTO pan_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","ਜਦ ਇਸਹਾਕ ਆਪਣੇ ਪੁੱਤਰ ਏਸਾਓ ਨਾਲ ਗੱਲ ਕਰਦਾ ਸੀ ਤਦ ਰਿਬਕਾਹ ਸੁਣਦੀ ਸੀ। ਫੇਰ ਏਸਾਓ ਮੈਦਾਨ ਵੱਲ ਚਲਾ ਗਿਆ ਕਿ ਸ਼ਿਕਾਰ ਮਾਰ ਕੇ ਲੈ ਆਵੇ। ");
INSERT INTO pan_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","ਤਦ ਰਿਬਕਾਹ ਨੇ ਆਪਣੇ ਪੁੱਤਰ ਯਾਕੂਬ ਨੂੰ ਆਖਿਆ, ਵੇਖ ਮੈਂ ਤੇਰੇ ਪਿਤਾ ਨੂੰ ਤੇਰੇ ਭਰਾ ਏਸਾਓ ਨੂੰ ਇਹ ਆਖਦੇ ਸੁਣਿਆ ");
INSERT INTO pan_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","ਕਿ ਮੇਰੇ ਲਈ ਸ਼ਿਕਾਰ ਮਾਰ ਕੇ ਸੁਆਦਲਾ ਭੋਜਨ ਤਿਆਰ ਕਰ ਜੋ ਮੈਂ ਖਾਵਾਂ ਅਤੇ ਯਹੋਵਾਹ ਦੇ ਸਨਮੁਖ ਆਪਣੀ ਮੌਤ ਤੋਂ ਪਹਿਲਾਂ ਤੈਨੂੰ ਬਰਕਤ ਦੇਵਾਂ। ");
INSERT INTO pan_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","ਹੁਣ ਮੇਰੇ ਪੁੱਤਰ ਮੇਰੀ ਗੱਲ ਸੁਣ ਜਿਵੇਂ ਮੈਂ ਤੈਨੂੰ ਹੁਕਮ ਦਿੰਦੀ ਹਾਂ। ");
INSERT INTO pan_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","ਇੱਜੜ ਵਿੱਚ ਜਾ ਕੇ ਉੱਥੋਂ ਮੇਰੇ ਲਈ ਬੱਕਰੀ ਦੇ ਦੋ ਚੰਗੇ ਮੇਮਣੇ ਲਿਆ ਤਾਂ ਜੋ ਮੈਂ ਉਨ੍ਹਾਂ ਤੋਂ ਸੁਆਦਲਾ ਭੋਜਨ ਤੇਰੇ ਪਿਤਾ ਲਈ ਜਿਹੜਾ ਉਹ ਨੂੰ ਚੰਗਾ ਲੱਗਦਾ ਹੈ, ਤਿਆਰ ਕਰਾਂ। ");
INSERT INTO pan_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","ਅਤੇ ਆਪਣੇ ਪਿਤਾ ਕੋਲ ਲੈ ਜਾ ਤਾਂ ਜੋ ਉਹ ਖਾਵੇ ਅਤੇ ਆਪਣੀ ਮੌਤ ਤੋਂ ਪਹਿਲਾਂ ਤੈਨੂੰ ਬਰਕਤ ਦੇਵੇ। ");
INSERT INTO pan_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","ਪਰ ਯਾਕੂਬ ਨੇ ਆਪਣੀ ਮਾਤਾ ਰਿਬਕਾਹ ਨੂੰ ਆਖਿਆ, ਵੇਖ ਮੇਰਾ ਭਰਾ ਏਸਾਓ ਜੱਤਵਾਲਾ ਮਨੁੱਖ ਹੈ ਅਤੇ ਮੈਂ ਰੋਮ ਹੀਣ ਮਨੁੱਖ ਹਾਂ। ");
INSERT INTO pan_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","ਸ਼ਾਇਦ ਮੇਰਾ ਪਿਤਾ ਮੈਨੂੰ ਟੋਹੇ ਅਤੇ ਮੈਂ ਉਹ ਦੀਆਂ ਅੱਖਾਂ ਵਿੱਚ ਧੋਖੇਬਾਜ਼ ਹੋਵਾਂ ਤਾਂ ਮੈਂ ਆਪਣੇ ਉੱਤੇ ਬਰਕਤ ਨਹੀਂ ਪਰ ਸਰਾਪ ਲਵਾਂ ਤਦ ਉਸ ਦੀ ਮਾਤਾ ਨੇ ਉਸ ਨੂੰ ਆਖਿਆ, ਮੇਰੇ ਪੁੱਤਰ ਤੇਰਾ ਸਰਾਪ ਮੇਰੇ ਉੱਤੇ ਆਵੇ। ");
INSERT INTO pan_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","ਤੂੰ ਸਿਰਫ਼ ਮੇਰੀ ਗੱਲ ਸੁਣ ਅਤੇ ਜਾ ਕੇ ਮੇਰੇ ਲਈ ਉਨ੍ਹਾਂ ਨੂੰ ਲੈ ਆ। ");
INSERT INTO pan_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","ਤਦ ਉਸ ਨੇ ਜਾ ਕੇ ਉਨ੍ਹਾਂ ਨੂੰ ਫੜਿਆ, ਆਪਣੀ ਮਾਤਾ ਕੋਲ ਲੈ ਆਇਆ ਅਤੇ ਉਸ ਦੀ ਮਾਤਾ ਨੇ ਸੁਆਦਲਾ ਭੋਜਨ ਜਿਹੜਾ ਉਸ ਦੇ ਪਿਤਾ ਨੂੰ ਚੰਗਾ ਲੱਗਦਾ ਸੀ, ਤਿਆਰ ਕੀਤਾ। ");
INSERT INTO pan_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","ਤਦ ਰਿਬਕਾਹ ਨੇ ਆਪਣੇ ਵੱਡੇ ਪੁੱਤਰ ਏਸਾਓ ਦੇ ਬਸਤਰ ਜਿਹੜੇ ਘਰ ਵਿੱਚ ਉਸ ਦੇ ਕੋਲ ਸਨ, ਆਪਣੇ ਛੋਟੇ ਪੁੱਤਰ ਯਾਕੂਬ ਨੂੰ ਪਹਿਨਾਏ ");
INSERT INTO pan_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","ਅਤੇ ਮੇਮਣਿਆਂ ਦੀਆਂ ਖੱਲਾਂ ਉਸ ਦੇ ਹੱਥਾਂ ਅਤੇ ਉਸ ਦੀ ਰੋਮ ਹੀਣ ਗਰਦਨ ਉੱਤੇ ਲਪੇਟੀਆਂ। ");
INSERT INTO pan_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","ਉਸ ਨੇ ਉਹ ਸੁਆਦਲਾ ਭੋਜਨ ਅਤੇ ਰੋਟੀ ਜਿਸ ਨੂੰ ਉਸ ਨੇ ਤਿਆਰ ਕੀਤਾ ਸੀ, ਆਪਣੇ ਪੁੱਤਰ ਯਾਕੂਬ ਦੇ ਹੱਥ ਵਿੱਚ ਦਿੱਤਾ। ");
INSERT INTO pan_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","ਤਦ ਉਸ ਨੇ ਆਪਣੇ ਪਿਤਾ ਕੋਲ ਜਾ ਕੇ ਆਖਿਆ, ਪਿਤਾ ਜੀ ਤਦ ਉਸ ਆਖਿਆ, ਕੀ ਗੱਲ ਹੈ? ");
INSERT INTO pan_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","ਤੂੰ ਕੌਣ ਹੈਂ ਮੇਰੇ ਪੁੱਤਰ? ਯਾਕੂਬ ਨੇ ਆਪਣੇ ਪਿਤਾ ਨੂੰ ਆਖਿਆ, ਮੈਂ ਏਸਾਓ ਤੇਰਾ ਪਹਿਲੌਠਾ ਪੁੱਤਰ ਹਾਂ। ਮੈਂ ਜਿਵੇਂ ਤੁਸੀਂ ਮੈਨੂੰ ਆਖਿਆ ਸੀ ਉਸੇ ਤਰ੍ਹਾਂ ਕੀਤਾ। ਉੱਠੋ ਅਤੇ ਸ਼ਿਕਾਰ ਨੂੰ ਖਾਓ ਤਾਂ ਜੋ ਤੁਸੀਂ ਮੈਨੂੰ ਦਿਲ ਤੋਂ ਬਰਕਤ ਦੇਵੋ। ");
INSERT INTO pan_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","ਇਸਹਾਕ ਨੇ ਆਪਣੇ ਪੁੱਤਰ ਨੂੰ ਆਖਿਆ, ਤੈਨੂੰ ਐਨੀ ਜਲਦੀ ਇਹ ਕਿਵੇਂ ਮਿਲ ਗਿਆ,? ਤਦ ਉਸ ਨੇ ਆਖਿਆ, ਯਹੋਵਾਹ ਤੁਹਾਡੇ ਪਰਮੇਸ਼ੁਰ ਨੇ ਉਹ ਨੂੰ ਮੇਰੇ ਅੱਗੇ ਲਿਆ ਦਿੱਤਾ। ");
INSERT INTO pan_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","ਇਸਹਾਕ ਨੇ ਯਾਕੂਬ ਨੂੰ ਆਖਿਆ, ਹੇ ਮੇਰੇ ਪੁੱਤਰ ਮੇਰੇ ਨੇੜੇ ਆ ਤਾਂ ਜੋ ਮੈਂ ਤੈਨੂੰ ਵੇਖਾਂ ਭਈ ਤੂੰ ਮੇਰਾ ਉਹੀ ਪੁੱਤਰ ਏਸਾਓ ਹੈਂ ਕਿ ਨਹੀਂ। ");
INSERT INTO pan_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","ਤਦ ਯਾਕੂਬ ਆਪਣੇ ਪਿਤਾ ਇਸਹਾਕ ਕੋਲ ਗਿਆ ਅਤੇ ਉਸ ਉਹ ਨੂੰ ਹੱਥ ਲਗਾ ਕੇ ਆਖਿਆ, ਤੇਰੀ ਅਵਾਜ਼ ਤਾਂ ਯਾਕੂਬ ਦੀ ਹੈ ਪਰ ਹੱਥ ਏਸਾਓ ਦੇ ਹਨ। ");
INSERT INTO pan_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","ਉਸ ਨੇ ਉਹ ਨੂੰ ਨਾ ਪਛਾਣਿਆ ਕਿਉਂ ਜੋ ਉਹ ਦੇ ਹੱਥ ਉਹ ਦੇ ਭਰਾ ਏਸਾਓ ਦੇ ਹੱਥਾਂ ਵਰਗੇ ਜਤਾਉਲੇ ਸਨ, ਤਦ ਉਸ ਨੇ ਉਹ ਨੂੰ ਬਰਕਤ ਦਿੱਤੀ। ");
INSERT INTO pan_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","ਇਸਹਾਕ ਨੇ ਆਖਿਆ, ਕੀ ਤੂੰ ਸੱਚ-ਮੁੱਚ ਮੇਰਾ ਪੁੱਤਰ ਏਸਾਓ ਹੀ ਹੈਂ? ਤਦ ਉਸ ਆਖਿਆ, ਮੈਂ ਹਾਂ। ");
INSERT INTO pan_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","ਉਸ ਨੇ ਆਖਿਆ, ਉਹ ਨੂੰ ਮੇਰੇ ਨੇੜੇ ਲਿਆ ਭਈ ਮੈਂ ਆਪਣੇ ਪੁੱਤਰ ਦੇ ਸ਼ਿਕਾਰ ਵਿੱਚੋਂ ਖਾਵਾਂ ਤਾਂ ਜੋ ਮੇਰਾ ਦਿਲ ਤੈਨੂੰ ਬਰਕਤ ਦੇਵੇ ਤਾਂ ਉਹ ਉਸ ਦੇ ਕੋਲ ਲੈ ਗਿਆ ਅਤੇ ਉਸ ਨੇ ਭੋਜਨ ਖਾਧਾ ਅਤੇ ਉਸ ਦੇ ਲਈ ਮਧ ਲਿਆਇਆ ਅਤੇ ਇਸਹਾਕ ਨੇ ਪੀਤੀ। ");
INSERT INTO pan_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","ਉਸ ਦੇ ਪਿਤਾ ਇਸਹਾਕ ਨੇ ਉਸ ਨੂੰ ਆਖਿਆ, ਮੇਰੇ ਨੇੜੇ ਆ ਕੇ ਮੈਨੂੰ ਚੁੰਮ ਮੇਰੇ ਪੁੱਤਰ। ");
INSERT INTO pan_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","ਫੇਰ ਉਸ ਨੇ ਨੇੜੇ ਜਾ ਕੇ ਉਸ ਨੂੰ ਚੁੰਮਿਆ ਤਾਂ ਉਸ ਦੇ ਬਸਤਰ ਦੀ ਬਾਸ਼ਨਾ ਸੁੰਘੀ ਅਤੇ ਉਸ ਨੂੰ ਬਰਕਤ ਦਿੱਤੀ। ਫੇਰ ਆਖਿਆ - ਵੇਖ, ਮੇਰੇ ਪੁੱਤਰ ਦੀ ਬਾਸ਼ਨਾ ਉਸ ਖੇਤ ਦੀ ਬਾਸ਼ਨਾ ਵਰਗੀ ਹੈ, ਜਿਸ ਨੂੰ ਯਹੋਵਾਹ ਨੇ ਬਰਕਤ ਦਿੱਤੀ ਹੋਵੇ। ");
INSERT INTO pan_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","ਪਰਮੇਸ਼ੁਰ ਤੈਨੂੰ ਅਕਾਸ਼ ਦੀ ਤ੍ਰੇਲ ਤੋਂ ਤੇ ਧਰਤੀ ਦੀ ਚਿਕਨਾਈ ਤੋਂ, ਅਤੇ ਅਨਾਜ ਅਤੇ ਦਾਖ਼ਰਸ ਦੀ ਭਰਪੂਰੀ ਤੋਂ ਬਰਕਤ ਦੇਵੇ। ");
INSERT INTO pan_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","ਕੌਮਾਂ ਤੇਰੀ ਸੇਵਾ ਕਰਨ ਅਤੇ ਉੱਮਤਾਂ ਤੇਰੇ ਅੱਗੇ ਝੁੱਕਣ। ਤੂੰ ਆਪਣੇ ਭਰਾਵਾਂ ਦਾ ਸਰਦਾਰ ਹੋਵੇ ਅਤੇ ਤੇਰੀ ਮਾਤਾ ਦੇ ਪੁੱਤਰ ਤੇਰੇ ਅੱਗੇ ਝੁੱਕਣ। ਜਿਹੜਾ ਤੈਨੂੰ ਸਰਾਪ ਦੇਵੇ ਉਹ ਆਪ ਸਰਾਪਿਆ ਜਾਵੇ, ਅਤੇ ਜਿਹੜਾ ਤੈਨੂੰ ਬਰਕਤ ਦੇਵੇ ਉਹ ਮੁਬਾਰਕ ਹੋਵੇ। ");
INSERT INTO pan_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","ਤਦ ਅਜਿਹਾ ਹੋਇਆ ਕਿ ਜਦੋਂ ਇਸਹਾਕ ਯਾਕੂਬ ਨੂੰ ਬਰਕਤ ਦੇ ਹਟਿਆ ਅਤੇ ਯਾਕੂਬ ਆਪਣੇ ਪਿਤਾ ਇਸਹਾਕ ਕੋਲੋਂ ਬਾਹਰ ਨਿੱਕਲਿਆ ਹੀ ਸੀ ਕਿ ਉਸ ਦਾ ਭਰਾ ਏਸਾਓ ਸ਼ਿਕਾਰ ਕਰ ਕੇ ਆਇਆ। ");
INSERT INTO pan_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","ਉਸ ਨੇ ਵੀ ਸੁਆਦਲਾ ਭੋਜਨ ਤਿਆਰ ਕੀਤਾ ਅਤੇ ਆਪਣੇ ਪਿਤਾ ਕੋਲ ਲਿਆਇਆ ਅਤੇ ਆਪਣੇ ਪਿਤਾ ਨੂੰ ਆਖਿਆ ਮੇਰੇ ਪਿਤਾ ਜੀ ਉੱਠੋ ਅਤੇ ਆਪਣੇ ਪੁੱਤਰ ਦੇ ਸ਼ਿਕਾਰ ਨੂੰ ਖਾਵੋ ਅਤੇ ਤੁਸੀਂ ਮੈਨੂੰ ਦਿਲ ਤੋਂ ਬਰਕਤ ਦੇਵੋ। ");
INSERT INTO pan_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","ਤਦ ਉਸ ਦੇ ਪਿਤਾ ਇਸਹਾਕ ਨੇ ਉਹ ਨੂੰ ਆਖਿਆ, ਤੂੰ ਕੌਣ ਹੈਂ? ਉਸ ਆਖਿਆ, ਮੈਂ ਤੁਹਾਡਾ ਪਹਿਲੌਠਾ ਪੁੱਤਰ ਏਸਾਓ ਹਾਂ। ");
INSERT INTO pan_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","ਤਦ ਇਸਹਾਕ ਨੇ ਥਰ-ਥਰ ਕੰਬਦੇ ਹੋਏ ਆਖਿਆ, ਫੇਰ ਉਹ ਕੌਣ ਸੀ ਜਿਹੜਾ ਸ਼ਿਕਾਰ ਮਾਰ ਕੇ ਮੇਰੇ ਕੋਲ ਲਿਆਇਆ? ਮੈਂ ਤੇਰੇ ਆਉਣ ਤੋਂ ਪਹਿਲਾਂ ਉਸ ਦੇ ਭੋਜਨ ਵਿੱਚੋਂ ਖਾਧਾ ਅਤੇ ਮੈਂ ਉਸੇ ਨੂੰ ਬਰਕਤ ਦਿੱਤੀ ਸੋ ਉਹ ਜ਼ਰੂਰ ਮੁਬਾਰਕ ਹੋਵੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","ਜਦ ਏਸਾਓ ਨੇ ਆਪਣੇ ਪਿਤਾ ਦੀਆਂ ਗੱਲਾਂ ਸੁਣੀਆਂ ਤਾਂ ਕੁੜੱਤਣ ਨਾਲ ਭੁੱਬਾਂ ਮਾਰ ਕੇ ਆਪਣੇ ਪਿਤਾ ਨੂੰ ਆਖਿਆ, ਮੇਰੇ ਪਿਤਾ ਮੈਨੂੰ, ਹਾਂ, ਮੈਨੂੰ ਵੀ ਬਰਕਤ ਦਿਓ। ");
INSERT INTO pan_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","ਤਦ ਉਸ ਆਖਿਆ ਤੇਰਾ ਭਰਾ ਧੋਖੇ ਨਾਲ ਆ ਕੇ ਤੇਰੀ ਬਰਕਤ ਲੈ ਗਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","ਉਸ ਨੇ ਆਖਿਆ, ਕੀ ਉਸ ਦਾ ਨਾਮ ਠੀਕ ਯਾਕੂਬ ਨਹੀਂ ਰੱਖਿਆ ਗਿਆ ਕਿ ਉਸ ਨੇ ਹੁਣ ਦੂਜੀ ਵਾਰ ਮੇਰੇ ਨਾਲ ਧੋਖਾ ਕੀਤਾ ਹੈ? ਉਸ ਨੇ ਪਹਿਲੌਠੇ ਦਾ ਹੱਕ ਵੀ ਲੈ ਲਿਆ ਅਤੇ ਵੇਖੋ ਹੁਣ ਮੇਰੀ ਬਰਕਤ ਵੀ ਲੈ ਲਈ ਤਦ ਉਸ ਨੇ ਆਖਿਆ, ਕੀ ਤੁਸੀਂ ਮੇਰੇ ਲਈ ਕੋਈ ਬਰਕਤ ਨਹੀਂ ਰੱਖ ਛੱਡੀ? ");
INSERT INTO pan_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","ਤਦ ਇਸਹਾਕ ਨੇ ਏਸਾਓ ਨੂੰ ਇਹ ਉੱਤਰ ਦਿੱਤਾ, ਵੇਖ ਮੈਂ ਉਹ ਨੂੰ ਤੇਰਾ ਸੁਆਮੀ ਠਹਿਰਾਇਆ ਅਤੇ ਉਸ ਦੇ ਸਾਰੇ ਭਰਾਵਾਂ ਨੂੰ ਉਸ ਦੀ ਸੇਵਾ ਲਈ ਦਿੱਤਾ ਅਤੇ ਅਨਾਜ ਅਤੇ ਦਾਖ਼ਰਸ ਉਸ ਨੂੰ ਦਿੱਤੀ। ਹੁਣ ਮੇਰੇ ਪੁੱਤਰ ਮੈਂ ਤੇਰੇ ਲਈ ਕੀ ਕਰਾਂ? ");
INSERT INTO pan_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","ਤਦ ਏਸਾਓ ਨੇ ਆਪਣੇ ਪਿਤਾ ਨੂੰ ਆਖਿਆ, ਮੇਰੇ ਪਿਤਾ ਕੀ ਤੁਹਾਡੇ ਕੋਲ ਇੱਕੋ ਹੀ ਬਰਕਤ ਹੈ? ਹੇ ਮੇਰੇ ਪਿਤਾ ਮੈਨੂੰ ਵੀ ਬਰਕਤ ਦਿਓ ਤਾਂ ਏਸਾਓ ਨੇ ਉੱਚੀ-ਉੱਚੀ ਭੁੱਬਾਂ ਮਾਰੀਆਂ ਅਤੇ ਰੋਇਆ। ");
INSERT INTO pan_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","ਉਹ ਦੇ ਪਿਤਾ ਇਸਹਾਕ ਨੇ ਉਹ ਨੂੰ ਇਹ ਉੱਤਰ ਦਿੱਤਾ - ਵੇਖ, ਧਰਤੀ ਦੀ ਚਿਕਨਾਈ ਅਤੇ ਉੱਪਰੋਂ ਅਕਾਸ਼ ਦੀ ਤ੍ਰੇਲ ਤੋਂ ਤੇਰਾ ਰਹਿਣਾ ਹੋਵੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","ਤੂੰ ਆਪਣੀ ਤਲਵਾਰ ਨਾਲ ਜੀਵੇਂਗਾ ਅਤੇ ਤੂੰ ਆਪਣੇ ਭਰਾ ਦੀ ਸੇਵਾ ਕਰੇਂਗਾ ਅਤੇ ਜਦ ਤੂੰ ਅਵਾਰਾ ਫਿਰੇਂਗਾ ਤਾਂ ਤੂੰ ਉਹ ਦਾ ਜੂਲਾ ਆਪਣੀ ਧੌਣ ਉੱਤੋਂ ਭੰਨ ਸੁੱਟੇਂਗਾ। ");
INSERT INTO pan_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","ਏਸਾਓ ਨੇ ਯਾਕੂਬ ਨਾਲ ਉਸ ਬਰਕਤ ਦੇ ਕਾਰਨ ਜਿਹੜੀ ਉਸ ਦੇ ਪਿਤਾ ਨੇ ਉਸ ਨੂੰ ਦਿੱਤੀ ਵੈਰ ਰੱਖਿਆ, ਏਸਾਓ ਨੇ ਆਪਣੇ ਮਨ ਵਿੱਚ ਆਖਿਆ, ਮੇਰੇ ਪਿਤਾ ਦੇ ਸੋਗ ਦੇ ਦਿਨ ਨੇੜੇ ਹਨ ਫੇਰ ਮੈਂ ਆਪਣੇ ਭਰਾ ਯਾਕੂਬ ਨੂੰ ਮਾਰ ਸੁੱਟਾਂਗਾ। ");
INSERT INTO pan_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","ਜਦ ਰਿਬਕਾਹ ਨੂੰ ਉਸ ਦੇ ਵੱਡੇ ਪੁੱਤਰ ਏਸਾਓ ਦੀਆਂ ਗੱਲਾਂ ਦੱਸੀਆਂ ਗਈਆਂ ਤਦ ਉਸ ਆਪਣੇ ਨਿੱਕੇ ਪੁੱਤਰ ਯਾਕੂਬ ਨੂੰ ਬੁਲਾ ਭੇਜਿਆ ਅਤੇ ਕਿਹਾ ਵੇਖ, ਤੇਰਾ ਭਰਾ ਆਪਣੇ ਆਪ ਨੂੰ ਤੇਰੇ ਵਿਖੇ ਤਸੱਲੀ ਦਿੰਦਾ ਹੈ ਕਿ ਤੈਨੂੰ ਮਾਰ ਸੁੱਟੇ। ");
INSERT INTO pan_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","ਸੋ ਹੁਣ ਮੇਰੇ ਪੁੱਤਰ ਮੇਰੀ ਗੱਲ ਸੁਣ। ਉੱਠ ਅਤੇ ਮੇਰੇ ਭਰਾ ਲਾਬਾਨ ਕੋਲ ਹਾਰਾਨ ਨੂੰ ਭੱਜ ਜਾ। ");
INSERT INTO pan_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","ਅਤੇ ਥੋੜ੍ਹੇ ਦਿਨ ਉਸ ਦੇ ਕੋਲ ਰਹਿ ਜਦ ਤੱਕ ਤੇਰੇ ਭਰਾ ਦਾ ਕ੍ਰੋਧ ਨਾ ਉਤਰ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","ਜਦ ਤੱਕ ਤੇਰੇ ਭਰਾ ਦਾ ਕ੍ਰੋਧ ਤੈਥੋਂ ਨਾ ਹੱਟ ਜਾਵੇ ਅਤੇ ਜੋ ਕੁਝ ਤੂੰ ਉਸ ਨਾਲ ਕੀਤਾ ਹੈ ਨਾ ਭੁੱਲ ਜਾਵੇ ਤਦ ਤੱਕ ਮੈਂ ਤੈਨੂੰ ਉੱਥੋਂ ਨਹੀਂ ਸੱਦਾਂਗੀ। ਮੈਂ ਕਿਉਂ ਇੱਕ ਹੀ ਦਿਨ ਦੋਹਾਂ ਨੂੰ ਗਵਾ ਬੈਠਾਂ? ");
INSERT INTO pan_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","ਰਿਬਕਾਹ ਨੇ ਇਸਹਾਕ ਨੂੰ ਆਖਿਆ, ਮੈਂ ਹੇਤ ਦੀਆਂ ਧੀਆਂ ਵੱਲੋਂ ਜੀ ਵਿੱਚ ਅੱਕ ਗਈ ਹਾਂ। ਜੇਕਰ ਯਾਕੂਬ ਹੇਤ ਦੀਆਂ ਧੀਆਂ ਵਿੱਚੋਂ, ਜਿਵੇਂ ਇਸ ਦੇਸ਼ ਦੀਆਂ ਧੀਆਂ ਹਨ ਆਪਣੇ ਲਈ ਪਤਨੀ ਲੈ ਆਇਆ ਤਾਂ ਮੈਂ ਕਿਵੇਂ ਜੀਉਂਦੀ ਰਹਾਂਗੀ? ");
INSERT INTO pan_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","ਇਸਹਾਕ ਨੇ ਯਾਕੂਬ ਨੂੰ ਬੁਲਾਇਆ ਅਤੇ ਉਸ ਨੂੰ ਬਰਕਤ ਦਿੱਤੀ ਅਤੇ ਇਹ ਆਖ ਕੇ ਉਸ ਨੂੰ ਹੁਕਮ ਦਿੱਤਾ, ਤੂੰ ਕਨਾਨੀਆਂ ਦੀਆਂ ਧੀਆਂ ਵਿੱਚੋਂ ਕਿਸੇ ਨਾਲ ਵਿਆਹ ਨਾ ਕਰੀਂ। ");
INSERT INTO pan_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","ਉੱਠ, ਪਦਨ ਅਰਾਮ ਨੂੰ ਆਪਣੇ ਨਾਨੇ ਬਥੂਏਲ ਦੇ ਘਰ ਜਾ ਅਤੇ ਉੱਥੋਂ ਆਪਣੇ ਮਾਮੇ ਲਾਬਾਨ ਦੀਆਂ ਧੀਆਂ ਵਿੱਚੋਂ ਇੱਕ ਨਾਲ ਵਿਆਹ ਕਰ ਲਈਂ। ");
INSERT INTO pan_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","ਸਰਬ ਸ਼ਕਤੀਮਾਨ ਪਰਮੇਸ਼ੁਰ ਤੈਨੂੰ ਬਰਕਤ ਦੇਵੇ ਅਤੇ ਤੈਨੂੰ ਫਲਵੰਤ ਬਣਾਵੇ ਅਤੇ ਤੈਨੂੰ ਵਧਾਵੇ ਅਤੇ ਤੂੰ ਬਹੁਤ ਕੌਮਾਂ ਦਾ ਦਲ ਹੋਵੇਂ। ");
INSERT INTO pan_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","ਉਹ ਤੈਨੂੰ ਅਤੇ ਤੇਰੀ ਅੰਸ ਨੂੰ ਵੀ ਅਬਰਾਹਾਮ ਦੀ ਬਰਕਤ ਦੇਵੇ ਤਾਂ ਜੋ ਤੂੰ ਇਸ ਦੇਸ਼ ਨੂੰ ਜਿਸ ਵਿੱਚ ਤੂੰ ਪਰਦੇਸੀ ਹੋ ਕੇ ਰਹਿੰਦਾ ਹੈਂ, ਜਿਸ ਨੂੰ ਪਰਮੇਸ਼ੁਰ ਨੇ ਅਬਰਾਹਾਮ ਨੂੰ ਦਿੱਤਾ ਸੀ, ਆਪਣੀ ਵਿਰਾਸਤ ਬਣਾ ਲਵੇਂ। ");
INSERT INTO pan_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","ਇਸਹਾਕ ਨੇ ਯਾਕੂਬ ਨੂੰ ਤੋਰ ਦਿੱਤਾ ਅਤੇ ਉਹ ਪਦਨ ਅਰਾਮ ਵਿੱਚ ਲਾਬਾਨ ਦੇ ਕੋਲ ਗਿਆ ਜਿਹੜਾ ਅਰਾਮੀ ਬਥੂਏਲ ਦਾ ਪੁੱਤਰ ਅਤੇ ਯਾਕੂਬ ਅਤੇ ਏਸਾਓ ਦੀ ਮਾਤਾ ਰਿਬਕਾਹ ਦਾ ਭਰਾ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","ਜਦ ਏਸਾਓ ਨੇ ਵੇਖਿਆ ਕਿ ਇਸਹਾਕ ਨੇ ਯਾਕੂਬ ਨੂੰ ਬਰਕਤ ਦਿੱਤੀ ਅਤੇ ਉਸ ਨੂੰ ਪਦਨ ਅਰਾਮ ਵਿੱਚ ਭੇਜ ਦਿੱਤਾ ਹੈ ਜੋ ਉਹ ਉੱਥੋਂ ਆਪਣੇ ਲਈ ਪਤਨੀ ਲਵੇ ਅਤੇ ਉਸ ਨੇ ਉਹ ਨੂੰ ਬਰਕਤ ਦਿੰਦੇ ਹੋਏ ਇਹ ਹੁਕਮ ਦਿੱਤਾ ਕਿ ਤੂੰ ਕਨਾਨੀਆਂ ਦੀਆਂ ਧੀਆਂ ਵਿੱਚੋਂ ਕਿਸੇ ਨਾਲ ਵਿਆਹ ਨਾ ਕਰੀਂ, ");
INSERT INTO pan_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","ਅਤੇ ਯਾਕੂਬ ਆਪਣੇ ਮਾਤਾ-ਪਿਤਾ ਦੀ ਸੁਣ ਕੇ ਪਦਨ ਅਰਾਮ ਨੂੰ ਚਲਿਆ ਗਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","ਤਦ ਏਸਾਓ ਨੇ ਇਹ ਵੇਖਿਆ ਕਿ ਕਨਾਨ ਦੀਆਂ ਧੀਆਂ ਮੇਰੇ ਪਿਤਾ ਇਸਹਾਕ ਦੀਆਂ ਅੱਖਾਂ ਵਿੱਚ ਬੁਰੀਆਂ ਹਨ ");
INSERT INTO pan_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","ਤਦ ਏਸਾਓ ਇਸਮਾਏਲ ਕੋਲ ਗਿਆ ਅਤੇ ਅਬਰਾਹਾਮ ਦੇ ਪੁੱਤਰ ਇਸਮਾਏਲ ਦੀ ਧੀ ਅਤੇ ਨਬਾਯੋਤ ਦੀ ਭੈਣ ਮਹਲਥ ਨੂੰ ਆਪਣੇ ਲਈ ਲੈ ਕੇ ਆਪਣੀਆਂ ਦੂਜੀਆਂ ਪਤਨੀਆਂ ਦੇ ਨਾਲ ਰਲਾ ਲਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","ਯਾਕੂਬ ਬਏਰਸ਼ਬਾ ਤੋਂ ਚੱਲ ਕੇ ਹਾਰਾਨ ਨੂੰ ਗਿਆ, ");
INSERT INTO pan_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","ਅਤੇ ਇੱਕ ਥਾਂ ਤੇ ਪਹੁੰਚਿਆ ਅਤੇ ਉੱਥੇ ਰਾਤ ਕੱਟੀ ਕਿਉਂ ਜੋ ਸੂਰਜ ਡੁੱਬ ਗਿਆ ਸੀ ਅਤੇ ਇੱਕ ਪੱਥਰ ਉਸ ਥਾਂ ਤੋਂ ਲੈ ਕੇ ਆਪਣੇ ਸਿਰਹਾਣੇ ਰੱਖ ਲਿਆ ਅਤੇ ਉਸ ਥਾਂ ਲੇਟ ਗਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","ਤਦ ਉਸ ਨੇ ਇੱਕ ਸੁਫ਼ਨਾ ਵੇਖਿਆ ਅਤੇ ਵੇਖੋ, ਇੱਕ ਪੌੜੀ ਧਰਤੀ ਉੱਤੇ ਰੱਖੀ ਹੋਈ ਸੀ ਅਤੇ ਉਸ ਦੀ ਚੋਟੀ ਅਕਾਸ਼ ਤੱਕ ਸੀ, ਅਤੇ ਵੇਖੋ ਪਰਮੇਸ਼ੁਰ ਦੇ ਦੂਤ ਉਹ ਦੇ ਉੱਤੇ ਚੜ੍ਹਦੇ-ਉੱਤਰਦੇ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","ਵੇਖੋ, ਯਹੋਵਾਹ ਉਸ ਦੇ ਉੱਤੇ ਖੜ੍ਹਾ ਸੀ ਅਤੇ ਉਸ ਨੇ ਆਖਿਆ, ਮੈਂ ਯਹੋਵਾਹ, ਤੇਰੇ ਪਿਤਾ ਅਬਰਾਹਾਮ ਦਾ ਪਰਮੇਸ਼ੁਰ ਅਤੇ ਇਸਹਾਕ ਦਾ ਪਰਮੇਸ਼ੁਰ ਹਾਂ। ਜਿਸ ਧਰਤੀ ਉੱਤੇ ਤੂੰ ਪਿਆ ਹੈਂ, ਇਹ ਮੈਂ ਤੈਨੂੰ ਅਤੇ ਤੇਰੀ ਅੰਸ ਨੂੰ ਦਿਆਂਗਾ। ");
INSERT INTO pan_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","ਤੇਰੀ ਅੰਸ ਧਰਤੀ ਦੀ ਧੂੜ ਦੀ ਤਰ੍ਹਾਂ ਹੋਵੇਗੀ ਅਤੇ ਤੂੰ ਪੂਰਬ-ਪੱਛਮ ਅਤੇ ਉੱਤਰ-ਦੱਖਣ ਵੱਲ ਫੁੱਟ ਨਿੱਕਲੇਂਗਾ ਅਤੇ ਤੈਥੋਂ ਅਤੇ ਤੇਰੀ ਅੰਸ ਤੋਂ ਧਰਤੀ ਦੇ ਸਾਰੇ ਘਰਾਣੇ ਬਰਕਤ ਪਾਉਣਗੇ। ");
INSERT INTO pan_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","ਵੇਖ, ਮੈਂ ਤੇਰੇ ਅੰਗ-ਸੰਗ ਹਾਂ ਅਤੇ ਜਿੱਥੇ ਕਿਤੇ ਤੂੰ ਜਾਵੇਂਗਾ ਮੈਂ ਤੇਰੀ ਰਾਖੀ ਕਰਾਂਗਾ, ਅਤੇ ਤੈਨੂੰ ਫੇਰ ਇਸ ਦੇਸ਼ ਵਿੱਚ ਲੈ ਆਵਾਂਗਾ ਅਤੇ ਜਦੋਂ ਤੱਕ ਮੈਂ ਤੇਰੇ ਨਾਲ ਆਪਣਾ ਬਚਨ ਪੂਰਾ ਨਾ ਕਰਾਂ, ਤੈਨੂੰ ਨਹੀਂ ਛੱਡਾਂਗਾ। ");
INSERT INTO pan_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","ਫੇਰ ਯਾਕੂਬ ਆਪਣੀ ਨੀਂਦ ਤੋਂ ਜਾਗਿਆ ਅਤੇ ਆਖਿਆ, ਸੱਚ-ਮੁੱਚ ਯਹੋਵਾਹ ਇਸ ਸਥਾਨ ਵਿੱਚ ਹੈ, ਪਰ ਮੈਂ ਨਹੀਂ ਜਾਣਦਾ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","ਅਤੇ ਉਸ ਨੇ ਭੈਅ ਖਾ ਕੇ ਆਖਿਆ, ਇਹ ਸਥਾਨ ਕਿੰਨ੍ਹਾਂ ਭਿਆਨਕ ਹੈ। ਪਰਮੇਸ਼ੁਰ ਦੇ ਘਰ ਦੇ ਬਿਨ੍ਹਾਂ ਇਹ ਕੋਈ ਹੋਰ ਸਥਾਨ ਨਹੀਂ ਹੋ ਸਕਦਾ, ਸਗੋਂ ਇਹ ਤਾਂ ਸਵਰਗ ਦਾ ਫਾਟਕ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","ਯਾਕੂਬ ਸਵੇਰੇ ਉੱਠਿਆ ਅਤੇ ਉਸ ਪੱਥਰ ਨੂੰ ਲੈ ਕੇ ਜਿਹੜਾ ਉਸ ਨੇ ਸਿਰਹਾਣੇ ਲਈ ਰੱਖਿਆ ਸੀ, ਥੰਮ੍ਹ ਲਈ ਖੜ੍ਹਾ ਕੀਤਾ ਅਤੇ ਉਸ ਉੱਤੇ ਤੇਲ ਡੋਲ੍ਹਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","ਉਸ ਨੇ ਉਸ ਸਥਾਨ ਦਾ ਨਾਮ ਬੈਤਏਲ ਰੱਖਿਆ, ਪਰ ਪਹਿਲਾਂ ਉਸ ਨਗਰ ਦਾ ਨਾਮ ਲੂਜ਼ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","ਯਾਕੂਬ ਨੇ ਇਹ ਆਖ ਕੇ ਸੁੱਖਣਾ ਸੁੱਖੀ, ਜੇ ਯਹੋਵਾਹ ਪਰਮੇਸ਼ੁਰ ਮੇਰੇ ਅੰਗ-ਸੰਗ ਹੋਵੇ ਅਤੇ ਇਸ ਮਾਰਗ ਵਿੱਚ ਜਿਸ ਵਿੱਚ ਮੈਂ ਤੁਰਿਆ ਜਾਂਦਾ ਹਾਂ ਮੇਰੀ ਰਾਖੀ ਕਰੇ, ਅਤੇ ਮੈਨੂੰ ਖਾਣ ਨੂੰ ਰੋਟੀ ਅਤੇ ਪਾਉਣ ਨੂੰ ਬਸਤਰ ਦੇਵੇ ");
INSERT INTO pan_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","ਅਤੇ ਮੈਂ ਸ਼ਾਂਤੀ ਨਾਲ ਆਪਣੇ ਪਿਤਾ ਦੇ ਘਰ ਨੂੰ ਮੁੜਾਂ ਤਾਂ ਯਹੋਵਾਹ ਮੇਰਾ ਪਰਮੇਸ਼ੁਰ ਹੋਵੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","ਅਤੇ ਇਹ ਪੱਥਰ ਜਿਸ ਨੂੰ ਮੈਂ ਥੰਮ੍ਹ ਖੜ੍ਹਾ ਕੀਤਾ ਹੈ, ਪਰਮੇਸ਼ੁਰ ਦਾ ਘਰ ਹੋਵੇਗਾ ਅਤੇ ਸਾਰੀਆਂ ਚੀਜ਼ਾਂ ਜੋ ਤੂੰ ਮੈਨੂੰ ਦੇਵੇਂਗਾ, ਉਨ੍ਹਾਂ ਦਾ ਦਸਵੰਧ ਮੈਂ ਜ਼ਰੂਰ ਹੀ ਤੈਨੂੰ ਦਿਆਂਗਾ। ");
INSERT INTO pan_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","ਯਾਕੂਬ ਉੱਥੋਂ ਪੈਦਲ ਚੱਲ ਕੇ ਪੂਰਬੀਆਂ ਦੇ ਦੇਸ਼ ਵਿੱਚ ਆਇਆ ");
INSERT INTO pan_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","ਅਤੇ ਉਸ ਨੇ ਵੇਖਿਆ ਤਾਂ ਵੇਖੋ, ਮੈਦਾਨ ਵਿੱਚ ਇੱਕ ਖੂਹ ਸੀ ਅਤੇ ਉੱਥੇ ਭੇਡਾਂ ਦੇ ਤਿੰਨ ਇੱਜੜ ਉਸ ਖੂਹ ਦੇ ਕੋਲ ਬੈਠੇ ਹੋਏ ਸਨ, ਕਿਉਂ ਜੋ ਓਹ ਉਸ ਖੂਹ ਤੋਂ ਇੱਜੜਾਂ ਨੂੰ ਪਾਣੀ ਪਿਲਾਉਂਦੇ ਸਨ ਅਤੇ ਉਸ ਖੂਹ ਦੇ ਮੂੰਹ ਉੱਤੇ ਵੱਡਾ ਪੱਥਰ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","ਜਦ ਸਾਰੇ ਇੱਜੜ ਉੱਥੇ ਇਕੱਠੇ ਹੁੰਦੇ ਸਨ ਤਾਂ ਓਹ ਉਸ ਪੱਥਰ ਨੂੰ ਖੂਹ ਦੇ ਮੂੰਹੋਂ ਰੇੜ੍ਹਦੇ ਸਨ ਅਤੇ ਇੱਜੜਾਂ ਨੂੰ ਪਾਣੀ ਪਿਲਾਉਂਦੇ ਸਨ ਅਤੇ ਫੇਰ ਉਸ ਪੱਥਰ ਨੂੰ ਖੂਹ ਦੇ ਮੂੰਹ ਉੱਤੇ ਉਸ ਦੇ ਸਥਾਨ ਤੇ ਰੱਖ ਦਿੰਦੇ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","ਤਦ ਯਾਕੂਬ ਨੇ ਆਜੜੀਆਂ ਨੂੰ ਪੁੱਛਿਆ, ਮੇਰੇ ਭਰਾਵੋ, ਤੁਸੀਂ ਕਿੱਥੋਂ ਦੇ ਹੋ? ਉਨ੍ਹਾਂ ਨੇ ਆਖਿਆ, ਅਸੀਂ ਹਾਰਾਨ ਤੋਂ ਹਾਂ। ");
INSERT INTO pan_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","ਤਦ ਉਸ ਨੇ ਉਹਨਾਂ ਨੂੰ ਪੁੱਛਿਆ, ਕੀ ਤੁਸੀਂ ਨਾਹੋਰ ਦੇ ਪੁੱਤਰ ਲਾਬਾਨ ਨੂੰ ਜਾਣਦੇ ਹੋ? ਉਨ੍ਹਾਂ ਨੇ ਆਖਿਆ, ਹਾਂ, ਅਸੀਂ ਜਾਣਦੇ ਹਾਂ। ");
INSERT INTO pan_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","ਉਸ ਨੇ ਪੁੱਛਿਆ, ਕੀ ਉਹ ਚੰਗਾ ਭਲਾ ਹੈ? ਉਨ੍ਹਾਂ ਨੇ ਆਖਿਆ, ਹਾਂ, ਉਹ ਚੰਗਾ ਭਲਾ ਹੈ ਅਤੇ ਵੇਖ ਉਹ ਦੀ ਧੀ ਰਾਖ਼ੇਲ ਭੇਡਾਂ ਲੈ ਕੇ ਆਉਂਦੀ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","ਉਸ ਨੇ ਆਖਿਆ, ਵੇਖੋ, ਅਜੇ ਦਿਨ ਵੱਡਾ ਹੈ ਅਤੇ ਅਜੇ ਪਸ਼ੂਆਂ ਦੇ ਇਕੱਠੇ ਹੋਣ ਦਾ ਸਮਾਂ ਨਹੀਂ ਹੈ। ਇਸ ਲਈ ਤੁਸੀਂ ਭੇਡਾਂ ਨੂੰ ਪਾਣੀ ਪਿਲਾ ਕੇ ਚਾਰਨ ਲਈ ਲੈ ਜਾਓ। ");
INSERT INTO pan_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","ਪਰ ਉਨ੍ਹਾਂ ਨੇ ਆਖਿਆ, ਅਸੀਂ ਅਜਿਹਾ ਨਹੀਂ ਕਰ ਸਕਦੇ, ਜਦ ਤੱਕ ਸਾਰੇ ਇੱਜੜ ਇਕੱਠੇ ਨਾ ਹੋਣ ਅਤੇ ਓਹ ਉਸ ਪੱਥਰ ਨੂੰ ਖੂਹ ਦੇ ਮੂੰਹ ਉੱਤੋਂ ਨਾ ਰੇੜ੍ਹਨ ਤਦ ਤੱਕ ਅਸੀਂ ਭੇਡਾਂ ਨੂੰ ਪਾਣੀ ਨਹੀਂ ਪਿਲਾ ਸਕਦੇ। ");
INSERT INTO pan_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","ਉਹ ਉਨ੍ਹਾਂ ਨਾਲ ਗੱਲਾਂ ਕਰਦਾ ਹੀ ਸੀ ਕਿ ਰਾਖ਼ੇਲ ਆਪਣੇ ਪਿਤਾ ਦੀਆਂ ਭੇਡਾਂ ਨਾਲ ਆਈ, ਕਿਉਂ ਜੋ ਉਹ ਭੇਡ-ਬੱਕਰੀਆਂ ਚਾਰਦੀ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","ਜਦ ਯਾਕੂਬ ਨੇ ਆਪਣੇ ਮਾਮੇ ਲਾਬਾਨ ਦੀ ਧੀ ਰਾਖ਼ੇਲ ਨੂੰ ਅਤੇ ਉਸ ਦੇ ਇੱਜੜ ਨੂੰ ਵੇਖਿਆ ਤਾਂ ਯਾਕੂਬ ਨੇ ਨੇੜੇ ਜਾ ਕੇ ਉਸ ਪੱਥਰ ਨੂੰ ਖੂਹ ਦੇ ਮੂੰਹ ਤੋਂ ਰੇੜ੍ਹਿਆ ਅਤੇ ਆਪਣੇ ਮਾਮੇ ਲਾਬਾਨ ਦੇ ਇੱਜੜ ਨੂੰ ਪਾਣੀ ਪਿਲਾਇਆ। ");
INSERT INTO pan_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","ਯਾਕੂਬ ਨੇ ਰਾਖ਼ੇਲ ਨੂੰ ਚੁੰਮਿਆ ਅਤੇ ਉੱਚੀ-ਉੱਚੀ ਰੋਇਆ। ");
INSERT INTO pan_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","ਤਦ ਯਾਕੂਬ ਨੇ ਰਾਖ਼ੇਲ ਨੂੰ ਦੱਸਿਆ, ਮੈਂ ਤੇਰੇ ਪਿਤਾ ਦਾ ਰਿਸ਼ਤੇਦਾਰ ਅਤੇ ਮੈਂ ਰਿਬਕਾਹ ਦਾ ਪੁੱਤਰ ਹਾਂ। ਤਦ ਉਸ ਨੇ ਨੱਠ ਕੇ ਆਪਣੇ ਪਿਤਾ ਨੂੰ ਦੱਸਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","ਜਦ ਲਾਬਾਨ ਨੇ ਆਪਣੇ ਭਾਣਜੇ ਦੀ ਖ਼ਬਰ ਸੁਣੀ ਤਾਂ ਉਸ ਦੇ ਮਿਲਣ ਨੂੰ ਨੱਠਾ ਅਤੇ ਜੱਫ਼ੀ ਪਾ ਕੇ ਉਸ ਨੂੰ ਚੁੰਮਿਆ ਅਤੇ ਉਸ ਨੂੰ ਆਪਣੇ ਘਰ ਲੈ ਆਇਆ ਤਾਂ ਯਾਕੂਬ ਨੇ ਲਾਬਾਨ ਨੂੰ ਸਾਰੀਆਂ ਗੱਲਾਂ ਦੱਸੀਆਂ। ");
INSERT INTO pan_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","ਤਦ ਲਾਬਾਨ ਨੇ ਉਸ ਨੂੰ ਆਖਿਆ, ਤੂੰ ਸੱਚ-ਮੁੱਚ ਮੇਰੀ ਹੱਡੀ ਅਤੇ ਮੇਰਾ ਮਾਸ ਹੈਂ, ਤਾਂ ਉਹ ਮਹੀਨਾ ਉਸ ਦੇ ਘਰ ਰਿਹਾ। ");
INSERT INTO pan_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","ਫੇਰ ਲਾਬਾਨ ਨੇ ਯਾਕੂਬ ਨੂੰ ਆਖਿਆ, ਇਸ ਕਾਰਨ ਕਿ ਤੂੰ ਮੇਰਾ ਰਿਸ਼ਤੇਦਾਰ ਹੈਂ, ਕੀ ਮੇਰੀ ਸੇਵਾ ਮੁਫ਼ਤ ਹੀ ਕਰੇਂਗਾ? ਮੈਨੂੰ ਦੱਸ, ਤੂੰ ਕੀ ਮਜ਼ਦੂਰੀ ਲਵੇਂਗਾ? ਲਾਬਾਨ ਦੀਆਂ ਦੋ ਧੀਆਂ ਸਨ, ");
INSERT INTO pan_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","ਵੱਡੀ ਦਾ ਨਾਮ ਲੇਆਹ ਅਤੇ ਛੋਟੀ ਦਾ ਨਾਮ ਰਾਖ਼ੇਲ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","ਲੇਆਹ ਦੀਆਂ ਅੱਖਾਂ ਕੋਮਲ ਸਨ ਪਰ ਰਾਖ਼ੇਲ ਰੂਪਵੰਤ ਅਤੇ ਵੇਖਣ ਵਿੱਚ ਸੋਹਣੀ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","ਯਾਕੂਬ ਰਾਖ਼ੇਲ ਨੂੰ ਪਿਆਰ ਕਰਦਾ ਸੀ ਇਸ ਲਈ ਉਸ ਨੇ ਆਖਿਆ, ਮੈਂ ਤੇਰੀ ਛੋਟੀ ਧੀ ਰਾਖ਼ੇਲ ਲਈ ਸੱਤ ਸਾਲ ਤੱਕ ਤੇਰੀ ਸੇਵਾ ਕਰਾਂਗਾ। ");
INSERT INTO pan_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","ਲਾਬਾਨ ਨੇ ਆਖਿਆ, ਉਹ ਨੂੰ ਕਿਸੇ ਦੂਜੇ ਨੂੰ ਦੇਣ ਨਾਲੋਂ ਤੈਨੂੰ ਦੇਣਾ ਚੰਗਾ ਹੈ, ");
INSERT INTO pan_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","ਤੂੰ ਮੇਰੇ ਨਾਲ ਰਹਿ। ਯਾਕੂਬ ਨੇ ਰਾਖ਼ੇਲ ਲਈ ਸੱਤ ਸਾਲ ਸੇਵਾ ਕੀਤੀ ਅਤੇ ਪ੍ਰੇਮ ਦੇ ਕਾਰਨ ਉਹ ਉਸ ਲਈ ਥੋੜ੍ਹੇ ਦਿਨ ਦੇ ਬਰਾਬਰ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","ਤਦ ਯਾਕੂਬ ਨੇ ਲਾਬਾਨ ਨੂੰ ਆਖਿਆ, ਮੇਰੀ ਵਹੁਟੀ ਮੈਨੂੰ ਦੇ ਜੋ ਮੈਂ ਉਸ ਕੋਲ ਜਾਂਵਾਂ ਜੋ ਮੇਰਾ ਸਮਾਂ ਪੂਰਾ ਹੋ ਗਿਆ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","ਤਦ ਲਾਬਾਨ ਨੇ ਉਸ ਸਥਾਨ ਦੇ ਸਭ ਮਨੁੱਖਾਂ ਨੂੰ ਇਕੱਠੇ ਕਰ ਕੇ ਵੱਡੀ ਦਾਵਤ ਕੀਤੀ ");
INSERT INTO pan_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","ਅਤੇ ਸ਼ਾਮ ਦੇ ਵੇਲੇ ਉਹ ਆਪਣੀ ਧੀ ਲੇਆਹ ਨੂੰ ਲੈ ਕੇ ਯਾਕੂਬ ਦੇ ਕੋਲ ਆਇਆ ਅਤੇ ਉਹ ਉਸ ਦੇ ਕੋਲ ਗਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","ਲਾਬਾਨ ਨੇ ਉਹ ਨੂੰ ਆਪਣੀ ਦਾਸੀ ਜਿਲਫਾਹ ਦਿੱਤੀ ਤਾਂ ਜੋ ਉਸ ਦੀ ਧੀ ਲੇਆਹ ਲਈ ਦਾਸੀ ਹੋਵੇ। ");
INSERT INTO pan_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","ਜਦ ਸਵੇਰਾ ਹੋਇਆ ਤਾਂ ਵੇਖੋ ਉਹ ਲੇਆਹ ਸੀ, ਤਾਂ ਯਾਕੂਬ ਨੇ ਲਾਬਾਨ ਨੂੰ ਆਖਿਆ, ਤੂੰ ਮੇਰੇ ਨਾਲ ਇਹ ਕੀ ਕੀਤਾ? ਕੀ ਰਾਖ਼ੇਲ ਲਈ ਮੈਂ ਤੇਰੀ ਸੇਵਾ ਨਹੀਂ ਕੀਤੀ? ਫੇਰ ਤੂੰ ਮੇਰੇ ਨਾਲ ਧੋਖਾ ਕਿਉਂ ਕੀਤਾ? ");
INSERT INTO pan_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","ਲਾਬਾਨ ਨੇ ਆਖਿਆ, ਸਾਡੇ ਦੇਸ਼ ਵਿੱਚ ਅਜਿਹਾ ਨਹੀਂ ਹੁੰਦਾ ਕਿ ਛੋਟੀ ਨੂੰ ਵੱਡੀ ਤੋਂ ਪਹਿਲਾਂ ਵਿਆਹ ਦੇਈਏ। ");
INSERT INTO pan_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","ਇਹ ਦਾ ਹਫ਼ਤਾ ਪੂਰਾ ਕਰ, ਤਾਂ ਮੈਂ ਤੈਨੂੰ ਦੂਜੀ ਵੀ ਉਸ ਸੇਵਾ ਦੇ ਬਦਲੇ, ਜਿਹੜੀ ਤੂੰ ਮੇਰੇ ਲਈ ਹੋਰ ਸੱਤ ਸਾਲ ਤੱਕ ਕਰੇਂਗਾ ਦੇ ਦਿਆਂਗਾ। ");
INSERT INTO pan_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","ਯਾਕੂਬ ਨੇ ਅਜਿਹਾ ਹੀ ਕੀਤਾ ਅਤੇ ਲੇਆਹ ਦਾ ਹਫ਼ਤਾ ਪੂਰਾ ਕੀਤਾ ਤਦ ਉਸ ਉਹ ਨੂੰ ਆਪਣੀ ਧੀ ਰਾਖ਼ੇਲ ਵਿਆਹ ਦਿੱਤੀ। ");
INSERT INTO pan_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","ਤਦ ਲਾਬਾਨ ਨੇ ਆਪਣੀ ਦਾਸੀ ਬਿਲਹਾਹ, ਆਪਣੀ ਧੀ ਰਾਖ਼ੇਲ ਲਈ ਦਿੱਤੀ ਜੋ ਉਹ ਉਸ ਦੀ ਦਾਸੀ ਹੋਵੇ। ");
INSERT INTO pan_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","ਤਦ ਯਾਕੂਬ ਉਹ ਰਾਖ਼ੇਲ ਕੋਲ ਵੀ ਗਿਆ ਕਿਉਂ ਜੋ ਉਹ ਰਾਖ਼ੇਲ ਨੂੰ ਲੇਆਹ ਨਾਲੋਂ ਵੱਧ ਪ੍ਰੇਮ ਕਰਦਾ ਸੀ ਤੇ ਉਸ ਨੇ ਹੋਰ ਸੱਤ ਸਾਲ ਤੱਕ ਉਸ ਦੀ ਸੇਵਾ ਕੀਤੀ। ");
INSERT INTO pan_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","ਜਦ ਯਹੋਵਾਹ ਨੇ ਵੇਖਿਆ ਕਿ ਲੇਆਹ ਤੁੱਛ ਜਾਣੀ ਗਈ ਹੈ ਤਾਂ ਉਸ ਨੇ ਉਹ ਦੀ ਕੁੱਖ ਖੋਲ੍ਹੀ, ਪਰ ਰਾਖ਼ੇਲ ਬਾਂਝ ਰਹੀ। ");
INSERT INTO pan_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","ਤਦ ਲੇਆਹ ਗਰਭਵਤੀ ਹੋਈ ਅਤੇ ਪੁੱਤਰ ਨੂੰ ਜਨਮ ਦਿੱਤਾ ਅਤੇ ਉਸ ਨੇ ਇਹ ਆਖ ਕੇ ਉਹ ਦਾ ਨਾਮ ਰਊਬੇਨ ਰੱਖਿਆ, ਯਹੋਵਾਹ ਨੇ ਮੇਰਾ ਕਸ਼ਟ ਵੇਖਿਆ ਹੈ, ਹੁਣ ਮੇਰਾ ਪਤੀ ਮੇਰੇ ਨਾਲ ਪ੍ਰੇਮ ਕਰੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","ਉਹ ਫੇਰ ਗਰਭਵਤੀ ਹੋਈ ਅਤੇ ਪੁੱਤਰ ਨੂੰ ਜਨਮ ਦਿੱਤਾ ਅਤੇ ਆਖਿਆ, ਯਹੋਵਾਹ ਨੇ ਸੁਣਿਆ ਕਿ ਮੈਂ ਤੁੱਛ ਜਾਣੀ ਗਈ, ਇਸ ਕਾਰਨ ਉਸ ਨੇ ਮੈਨੂੰ ਇਹ ਪੁੱਤਰ ਦਿੱਤਾ ਅਤੇ ਉਸ ਦਾ ਨਾਮ ਸ਼ਿਮਓਨ ਰੱਖਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","ਉਹ ਫੇਰ ਗਰਭਵਤੀ ਹੋਈ ਅਤੇ ਇੱਕ ਪੁੱਤਰ ਨੂੰ ਜਨਮ ਦਿੱਤਾ ਅਤੇ ਆਖਿਆ, ਇਸ ਵਾਰੀ ਮੇਰਾ ਪਤੀ ਮੇਰੇ ਨਾਲ ਮਿਲੇਗਾ ਕਿਉਂ ਜੋ ਮੈਂ ਉਸ ਦੇ ਲਈ ਤਿੰਨ ਪੁੱਤਰ ਜਣੇ ਹਨ, ਇਸ ਕਾਰਨ ਉਸ ਨੇ ਉਹ ਦਾ ਨਾਮ ਲੇਵੀ ਰੱਖਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","ਉਹ ਫੇਰ ਗਰਭਵਤੀ ਹੋਈ ਅਤੇ ਇੱਕ ਹੋਰ ਪੁੱਤਰ ਨੂੰ ਜਨਮ ਦਿੱਤਾ ਅਤੇ ਆਖਿਆ, ਇਸ ਵਾਰੀ ਮੈਂ ਯਹੋਵਾਹ ਦਾ ਧੰਨਵਾਦ ਕਰਾਂਗੀ, ਇਸ ਕਾਰਨ ਉਸ ਨੇ ਉਹ ਦਾ ਨਾਮ ਯਹੂਦਾਹ ਰੱਖਿਆ ਤਦ ਉਹ ਜਣਨ ਤੋਂ ਰਹਿ ਗਈ। ");
INSERT INTO pan_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","ਜਦ ਰਾਖ਼ੇਲ ਨੇ ਵੇਖਿਆ ਕਿ ਮੈਂ ਯਾਕੂਬ ਲਈ ਸੰਤਾਨ ਨਹੀਂ ਜਣਦੀ ਤਾਂ ਰਾਖ਼ੇਲ ਆਪਣੀ ਭੈਣ ਤੋਂ ਈਰਖਾ ਕਰਨ ਲੱਗ ਪਈ ਅਤੇ ਯਾਕੂਬ ਨੂੰ ਆਖਿਆ, ਮੈਨੂੰ ਪੁੱਤਰ ਦੇ ਨਹੀਂ ਤਾਂ ਮੈਂ ਮਰ ਜਾਂਵਾਂਗੀ। ");
INSERT INTO pan_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","ਤਦ ਯਾਕੂਬ ਦਾ ਗੁੱਸਾ ਰਾਖ਼ੇਲ ਉੱਤੇ ਭੜਕਿਆ ਅਤੇ ਉਸ ਨੇ ਆਖਿਆ, ਕੀ ਮੈਂ ਪਰਮੇਸ਼ੁਰ ਦੀ ਥਾਂ ਹਾਂ, ਜਿਸ ਨੇ ਤੇਰੀ ਕੁੱਖ ਨੂੰ ਫਲਵੰਤ ਹੋਣ ਤੋਂ ਰੋਕਿਆ ਹੈ? ");
INSERT INTO pan_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","ਰਾਖ਼ੇਲ ਨੇ ਆਖਿਆ, ਵੇਖ, ਮੇਰੀ ਦਾਸੀ ਬਿਲਹਾਹ ਹੈ। ਉਸ ਦੇ ਕੋਲ ਜਾ ਅਤੇ ਉਹ ਮੇਰੇ ਗੋਡਿਆਂ ਉੱਤੇ ਜਣੇਗੀ ਤਾਂ ਜੋ ਮੈਂ ਵੀ ਉਸ ਤੋਂ ਸੰਤਾਨ ਵਾਲੀ ਬਣ ਜਾਂਵਾਂ। ");
INSERT INTO pan_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","ਫੇਰ ਉਸ ਨੇ ਆਪਣੀ ਦਾਸੀ ਬਿਲਹਾਹ ਉਸ ਨੂੰ ਦਿੱਤੀ ਜੋ ਉਸ ਦੀ ਪਤਨੀ ਹੋਵੇ। ਯਾਕੂਬ ਉਸ ਦੇ ਕੋਲ ਗਿਆ, ");
INSERT INTO pan_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","ਤਾਂ ਬਿਲਹਾਹ ਗਰਭਵਤੀ ਹੋਈ ਅਤੇ ਯਾਕੂਬ ਤੋਂ ਇੱਕ ਪੁੱਤਰ ਨੂੰ ਜਨਮ ਦਿੱਤਾ। ");
INSERT INTO pan_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","ਤਦ ਰਾਖ਼ੇਲ ਨੇ ਆਖਿਆ, ਪਰਮੇਸ਼ੁਰ ਨੇ ਮੇਰਾ ਨਿਆਂ ਕੀਤਾ ਅਤੇ ਮੇਰੀ ਅਵਾਜ਼ ਸੁਣ ਕੇ ਮੈਨੂੰ ਇੱਕ ਪੁੱਤਰ ਵੀ ਦਿੱਤਾ। ਇਸ ਕਾਰਨ ਉਸ ਦਾ ਨਾਮ ਦਾਨ ਰੱਖਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","ਰਾਖ਼ੇਲ ਦੀ ਦਾਸੀ ਬਿਲਹਾਹ ਫੇਰ ਗਰਭਵਤੀ ਹੋਈ ਅਤੇ ਯਾਕੂਬ ਤੋਂ ਦੂਜਾ ਪੁੱਤਰ ਜਣੀ। ");
INSERT INTO pan_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","ਰਾਖ਼ੇਲ ਨੇ ਆਖਿਆ, ਮੇਰੀ ਆਪਣੀ ਭੈਣ ਨਾਲ ਮੇਰਾ ਵੱਡਾ ਘੋਲ ਹੋਇਆ ਪਰ ਮੈਂ ਜਿੱਤ ਗਈ, ਇਸ ਲਈ ਉਸ ਦਾ ਨਾਮ ਨਫ਼ਤਾਲੀ ਰੱਖਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","ਜਦ ਲੇਆਹ ਨੇ ਵੇਖਿਆ ਕਿ ਮੈਂ ਜਣਨ ਤੋਂ ਰਹਿ ਗਈ ਹਾਂ ਤਾਂ ਉਸ ਨੇ ਆਪਣੀ ਦਾਸੀ ਜਿਲਫਾਹ ਨੂੰ ਲੈ ਕੇ ਯਾਕੂਬ ਨੂੰ ਉਸ ਦੀ ਪਤਨੀ ਹੋਣ ਲਈ ਦਿੱਤਾ। ");
INSERT INTO pan_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","ਲੇਆਹ ਦੀ ਦਾਸੀ ਜਿਲਫਾਹ ਨੇ ਵੀ ਯਾਕੂਬ ਤੋਂ ਇੱਕ ਪੁੱਤਰ ਨੂੰ ਜਨਮ ਦਿੱਤਾ ");
INSERT INTO pan_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","ਤਦ ਲੇਆਹ ਨੇ ਆਖਿਆ, ਮੇਰੇ ਭਾਗ ਜਾਗੇ ਹਨ, ਤਾਂ ਉਸ ਨੇ ਉਹ ਦਾ ਨਾਮ ਗਾਦ ਨੇ ਰੱਖਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","ਫੇਰ ਲੇਆਹ ਦੀ ਦਾਸੀ ਜਿਲਫਾਹ ਨੇ ਯਾਕੂਬ ਤੋਂ ਦੂਜਾ ਪੁੱਤਰ ਜਣਿਆ, ");
INSERT INTO pan_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","ਤਦ ਲੇਆਹ ਆਖਿਆ, ਮੈਂ ਧੰਨ ਹਾਂ, ਇਸ ਕਾਰਨ ਇਸਤਰੀਆਂ ਮੈਨੂੰ ਧੰਨ ਆਖਣਗੀਆਂ। ਇਸ ਲਈ ਉਸ ਦਾ ਨਾਮ ਆਸ਼ੇਰ ਰੱਖਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","ਰਊਬੇਨ ਨੇ ਕਣਕ ਦੀ ਵਾਢੀ ਦੇ ਦਿਨਾਂ ਵਿੱਚ ਬਾਹਰ ਨਿੱਕਲ ਕੇ ਦੂਦਾਂ ਫ਼ਲ ਪਾਈਆਂ ਅਤੇ ਉਨ੍ਹਾਂ ਨੂੰ ਆਪਣੀ ਮਾਤਾ ਲੇਆਹ ਕੋਲ ਲਿਆਇਆ ਤਾਂ ਰਾਖ਼ੇਲ ਨੇ ਲੇਆਹ ਨੂੰ ਆਖਿਆ, ਆਪਣੇ ਪੁੱਤਰ ਦੇ ਦੂਦਾਂ ਫਲ ਵਿੱਚੋਂ ਮੈਨੂੰ ਦੇ। ");
INSERT INTO pan_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","ਉਸ ਨੇ ਉਹ ਨੂੰ ਆਖਿਆ, ਕੀ ਇਹ ਛੋਟੀ ਗੱਲ ਹੈ ਕਿ ਤੂੰ ਮੇਰੇ ਪਤੀ ਨੂੰ ਲੈ ਲਿਆ ਹੈ ਅਤੇ ਹੁਣ ਤੂੰ ਮੇਰੇ ਪੁੱਤਰ ਦਾ ਦੂਦਾਂ ਫਲ ਵੀ ਲੈ ਲਵੇਂਗੀ? ਰਾਖ਼ੇਲ ਨੇ ਆਖਿਆ, ਇਸ ਲਈ ਤੇਰੇ ਪੁੱਤਰ ਦੇ ਦੂਦਾਂ ਫਲ ਦੇ ਬਦਲੇ, ਉਹ ਅੱਜ ਰਾਤ ਤੇਰੇ ਸੰਗ ਲੇਟੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","ਜਦ ਯਾਕੂਬ ਸ਼ਾਮ ਦੇ ਵੇਲੇ ਖੇਤ ਤੋਂ ਆਇਆ ਤਾਂ ਲੇਆਹ ਉਸ ਨੂੰ ਮਿਲਣ ਲਈ ਬਾਹਰ ਆਈ ਅਤੇ ਆਖਿਆ, ਤੂੰ ਮੇਰੇ ਕੋਲ ਆਵੀਂ ਕਿਉਂ ਜੋ ਮੈਂ ਤੈਨੂੰ ਆਪਣੇ ਪੁੱਤਰ ਦੀਆਂ ਦੂਦੀਆਂ ਨਾਲ ਭਾੜੇ ਉੱਤੇ ਲਿਆ ਹੈ। ਇਸ ਲਈ ਉਹ ਉਸ ਰਾਤ ਉਸ ਦੇ ਨਾਲ ਲੇਟਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","ਤਦ ਪਰਮੇਸ਼ੁਰ ਨੇ ਲੇਆਹ ਦੀ ਸੁਣੀ ਅਤੇ ਉਹ ਗਰਭਵਤੀ ਹੋਈ ਅਤੇ ਯਾਕੂਬ ਲਈ ਪੰਜਵਾਂ ਪੁੱਤਰ ਜਣੀ। ");
INSERT INTO pan_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","ਤਦ ਲੇਆਹ ਨੇ ਆਖਿਆ, ਪਰਮੇਸ਼ੁਰ ਨੇ ਮੇਰਾ ਭਾੜਾ ਦਿੱਤਾ ਹੈ ਕਿਉਂ ਜੋ ਮੈਂ ਆਪਣੀ ਦਾਸੀ ਆਪਣੇ ਪਤੀ ਨੂੰ ਦਿੱਤੀ ਅਤੇ ਉਸ ਨੇ ਉਹ ਦਾ ਨਾਮ ਯਿੱਸਾਕਾਰ ਰੱਖਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","ਲੇਆਹ ਫੇਰ ਗਰਭਵਤੀ ਹੋਈ ਅਤੇ ਯਾਕੂਬ ਲਈ ਛੇਵਾਂ ਪੁੱਤਰ ਜਣੀ। ");
INSERT INTO pan_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","ਲੇਆਹ ਨੇ ਆਖਿਆ, ਪਰਮੇਸ਼ੁਰ ਨੇ ਮੈਨੂੰ ਚੰਗਾ ਦਾਨ ਦਿੱਤਾ ਹੈ। ਹੁਣ ਮੇਰਾ ਪਤੀ ਮੇਰੇ ਸੰਗ ਰਹੇਗਾ ਕਿਉਂ ਜੋ ਮੈਂ ਉਹ ਦੇ ਲਈ ਛੇ ਪੁੱਤਰਾਂ ਨੂੰ ਜਨਮ ਦਿੱਤਾ ਹੈ ਤਾਂ ਉਸ ਨੇ ਉਹ ਦਾ ਨਾਮ ਜ਼ਬੂਲੁਨ ਰੱਖਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","ਫੇਰ ਉਸ ਨੇ ਇੱਕ ਧੀ ਨੂੰ ਜਨਮ ਦਿੱਤਾ ਅਤੇ ਉਹ ਦਾ ਨਾਮ ਦੀਨਾਹ ਰੱਖਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","ਤਦ ਪਰਮੇਸ਼ੁਰ ਨੇ ਰਾਖ਼ੇਲ ਨੂੰ ਯਾਦ ਕੀਤਾ ਅਤੇ ਉਹ ਦੀ ਸੁਣੀ ਅਤੇ ਉਹ ਦੀ ਕੁੱਖ ਨੂੰ ਖੋਲ੍ਹਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","ਉਹ ਗਰਭਵਤੀ ਹੋਈ ਅਤੇ ਇੱਕ ਪੁੱਤਰ ਨੂੰ ਜਨਮ ਦਿੱਤਾ ਅਤੇ ਆਖਿਆ, ਪਰਮੇਸ਼ੁਰ ਨੇ ਮੇਰੀ ਨਿੰਦਿਆ ਨੂੰ ਦੂਰ ਕੀਤਾ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","ਤਦ ਉਸ ਨੇ ਇਹ ਆਖ ਕੇ ਉਹ ਦਾ ਨਾਮ ਯੂਸੁਫ਼ ਰੱਖਿਆ ਕਿ ਯਹੋਵਾਹ ਮੈਨੂੰ ਇੱਕ ਹੋਰ ਪੁੱਤਰ ਦੇਵੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","ਜਦ ਯੂਸੁਫ਼ ਰਾਖ਼ੇਲ ਤੋਂ ਜੰਮਿਆ ਤਾਂ ਯਾਕੂਬ ਨੇ ਲਾਬਾਨ ਨੂੰ ਆਖਿਆ, ਮੈਨੂੰ ਵਿਦਿਆ ਕਰ ਤਾਂ ਜੋ ਮੈਂ ਆਪਣੇ ਸਥਾਨ ਅਤੇ ਆਪਣੇ ਦੇਸ਼ ਨੂੰ ਚਲਿਆ ਜਾਂਵਾਂ। ");
INSERT INTO pan_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","ਮੇਰੀਆਂ ਪਤਨੀਆਂ ਅਤੇ ਮੇਰੇ ਬੱਚੇ ਜਿਨ੍ਹਾਂ ਲਈ ਮੈਂ ਤੇਰੀ ਸੇਵਾ ਕੀਤੀ ਹੈ ਮੈਨੂੰ ਦੇ, ਤਾਂ ਮੈਂ ਚਲਿਆ ਜਾਂਵਾਂਗਾ ਕਿਉਂ ਜੋ ਤੂੰ ਮੇਰੀ ਸੇਵਾ ਨੂੰ ਜਾਣਦਾ ਹੈਂ, ਜੋ ਮੈਂ ਤੇਰੇ ਲਈ ਕੀਤੀ। ");
INSERT INTO pan_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","ਲਾਬਾਨ ਨੇ ਉਹ ਨੂੰ ਆਖਿਆ, ਜੇਕਰ ਮੇਰੇ ਉੱਤੇ ਤੇਰੀ ਕਿਰਪਾ ਦੀ ਨਜ਼ਰ ਹੋਵੇ ਤਾਂ ਇੱਥੇ ਹੀ ਰਹਿ ਜਾ, ਕਿਉਂ ਜੋ ਮੈਂ ਜਾਣ ਲਿਆ ਹੈ ਕਿ ਯਹੋਵਾਹ ਨੇ ਮੈਨੂੰ ਤੇਰੇ ਕਾਰਨ ਬਰਕਤ ਦਿੱਤੀ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","ਲਾਬਾਨ ਨੇ ਆਖਿਆ, ਆਪਣੀ ਮਜ਼ਦੂਰੀ ਮੇਰੇ ਨਾਲ ਠਹਿਰਾ ਲੈ ਅਤੇ ਮੈਂ ਤੈਨੂੰ ਦਿਆਂਗਾ। ");
INSERT INTO pan_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","ਯਾਕੂਬ ਨੇ ਉਸ ਨੂੰ ਆਖਿਆ, ਤੂੰ ਜਾਣਦਾ ਹੈਂ ਕਿ ਮੈਂ ਕਿਵੇਂ ਤੇਰੀ ਸੇਵਾ ਕੀਤੀ ਅਤੇ ਤੇਰੇ ਪਸ਼ੂ ਮੇਰੇ ਨਾਲ ਕਿਵੇਂ ਰਹੇ। ");
INSERT INTO pan_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","ਕਿਉਂ ਜੋ ਮੇਰੇ ਆਉਣ ਤੋਂ ਪਹਿਲਾਂ ਤੇਰੇ ਕੋਲ ਥੋੜ੍ਹਾ ਸੀ, ਪਰ ਹੁਣ ਬਹੁਤ ਵੱਧ ਗਿਆ ਹੈ। ਯਹੋਵਾਹ ਨੇ ਕਦਮ-ਕਦਮ ਤੇ ਤੈਨੂੰ ਬਰਕਤ ਦਿੱਤੀ ਹੈ। ਪਰ ਮੈਂ ਆਪਣੇ ਘਰ ਲਈ ਕੁਝ ਕਦੋਂ ਕਰਾਂਗਾ? ");
INSERT INTO pan_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","ਉਸ ਨੇ ਆਖਿਆ, ਮੈਂ ਤੈਨੂੰ ਕੀ ਦੇਵਾਂ? ਤਾਂ ਯਾਕੂਬ ਨੇ ਆਖਿਆ, ਮੈਨੂੰ ਕੁਝ ਨਾ ਦੇ। ਜੇਕਰ ਤੂੰ ਮੇਰੇ ਲਈ ਇਹ ਕਰੇਂ ਤਾਂ ਮੈਂ ਤੇਰੇ ਇੱਜੜਾਂ ਨੂੰ ਫੇਰ ਚਾਰਾਂਗਾ ਅਤੇ ਰਾਖੀ ਕਰਾਂਗਾ। ");
INSERT INTO pan_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","ਮੈਂ ਅੱਜ ਤੇਰੇ ਸਾਰੇ ਇੱਜੜ ਦੇ ਵਿੱਚੋਂ ਦੀ ਲੰਘ ਕੇ ਭੇਡਾਂ ਵਿੱਚੋਂ ਜਿੰਨ੍ਹੀਆਂ ਚਿਤਲੀਆਂ ਅਤੇ ਡੱਬੀਆਂ ਹੋਣ ਅਤੇ ਜੋ ਭੇਡਾਂ ਕਾਲੀਆਂ ਹੋਣ ਬੱਕਰੀਆਂ ਵਿੱਚੋਂ ਵੀ ਜਿੰਨ੍ਹੀਆਂ ਡੱਬੀਆਂ ਅਤੇ ਚਿਤਲੀਆਂ ਹੋਣ ਉਨ੍ਹਾਂ ਨੂੰ ਕੱਢਾਂਗਾ ਅਤੇ ਓਹ ਮੇਰੀ ਮਜ਼ਦੂਰੀ ਹੋਣਗੀਆਂ। ");
INSERT INTO pan_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","ਮੇਰਾ ਧਰਮ ਮੇਰੇ ਲਈ ਆਉਣ ਵਾਲੇ ਦਿਨ ਵਿੱਚ ਉੱਤਰ ਦੇਵੇਗਾ ਜਦ ਤੂੰ ਮੇਰੇ ਸਨਮੁਖ ਮੇਰੀ ਮਜ਼ਦੂਰੀ ਦੇਣ ਲਈ ਆਵੇਂਗਾ ਤਾਂ ਬੱਕਰੀਆਂ ਵਿੱਚੋਂ ਹਰ ਇੱਕ ਜਿਹੜੀ ਚਿਤਲੀ ਅਤੇ ਡੱਬੀ ਅਤੇ ਭੇਡਾਂ ਵਿੱਚ ਜਿਹੜੀ ਕਾਲੀ ਨਾ ਹੋਵੇ, ਜੇ ਉਹ ਮੇਰੇ ਕੋਲੋਂ ਨਿੱਕਲੇ ਤਾਂ ਚੋਰੀ ਦੀ ਹੋਵੇਗੀ। ");
INSERT INTO pan_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","ਤਦ ਲਾਬਾਨ ਨੇ ਆਖਿਆ, ਵੇਖ, ਤੇਰੀ ਗੱਲ ਦੇ ਅਨੁਸਾਰ ਹੋਵੇ। ");
INSERT INTO pan_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","ਉਸ ਨੇ ਉਸੇ ਦਿਨ ਸਾਰੇ ਧਾਰੀ ਵਾਲੇ ਅਤੇ ਡੱਬੇ ਬੱਕਰੇ ਅਤੇ ਸਾਰੀਆਂ ਚਿਤਲੀਆਂ ਅਤੇ ਡੱਬੀਆਂ ਬੱਕਰੀਆਂ ਅਰਥਾਤ ਜਿਸ ਕਿਸੇ ਵਿੱਚ ਸਫ਼ੇਦੀ ਸੀ ਅਤੇ ਭੇਡਾਂ ਵਿੱਚੋਂ ਜਿੰਨੀਆਂ ਕਾਲੀਆਂ ਸਨ, ਸਭ ਨੂੰ ਕੱਢਿਆ ਅਤੇ ਆਪਣੇ ਪੁੱਤਰਾਂ ਦੇ ਹੱਥਾਂ ਵਿੱਚ ਦਿੱਤਾ। ");
INSERT INTO pan_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","ਲਾਬਾਨ ਨੇ ਆਪਣੇ ਅਤੇ ਯਾਕੂਬ ਦੇ ਵਿੱਚ ਤਿੰਨ ਦਿਨਾਂ ਦੇ ਸਫ਼ਰ ਦਾ ਫ਼ਾਸਲਾ ਠਹਿਰਾਇਆ ਅਤੇ ਯਾਕੂਬ ਲਾਬਾਨ ਦੇ ਬਾਕੀ ਇੱਜੜਾਂ ਨੂੰ ਚਾਰਨ ਲੱਗ ਪਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","ਤਦ ਯਾਕੂਬ ਨੇ ਹਰੇ ਸਫ਼ੇਦੇ ਅਤੇ ਬਦਾਮ ਅਤੇ ਸਰੂ ਦੀਆਂ ਛਿਟੀਆਂ ਲੈ ਕੇ ਉਨ੍ਹਾਂ ਉੱਤੇ ਅਜਿਹੀਆਂ ਧਾਰੀਆਂ ਪਾਈਆਂ ਕਿ ਉਨ੍ਹਾਂ ਦੀ ਸਫ਼ੇਦੀ ਦਿੱਸਣ ਲੱਗ ਪਈ। ");
INSERT INTO pan_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","ਤਦ ਉਨ੍ਹਾਂ ਛਿਟੀਆਂ ਨੂੰ ਜਿਨ੍ਹਾਂ ਉੱਤੇ ਉਸ ਨੇ ਧਾਰੀਆਂ ਪਾਈਆਂ ਸਨ, ਹੌਦਾਂ ਅਤੇ ਨਾਲਿਆਂ ਵਿੱਚ ਜਿੱਥੇ ਇੱਜੜ ਪਾਣੀ ਪੀਣ ਆਉਂਦੇ ਸਨ, ਉਨ੍ਹਾਂ ਦੇ ਸਾਹਮਣੇ ਰੱਖ ਦਿੱਤਾ ਅਤੇ ਜਦ ਓਹ ਪਾਣੀ ਪੀਂਦੀਆਂ ਸਨ ਤਾਂ ਓਹ ਆਸੇ ਲੱਗਣ ਲੱਗ ਪਈਆਂ। ");
INSERT INTO pan_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","ਇਸ ਤਰ੍ਹਾਂ ਇੱਜੜ ਛਿਟੀਆਂ ਦੇ ਅੱਗੇ ਆਸੇ ਲੱਗਿਆ ਤਾਂ ਉਨ੍ਹਾਂ ਨੇ ਗਦਰੇ ਅਤੇ ਚਿਤਲੇ ਅਤੇ ਡੱਬੇ ਬੱਚੇ ਦਿੱਤੇ। ");
INSERT INTO pan_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","ਤਦ ਯਾਕੂਬ ਨੇ ਲੇਲੇ ਅੱਡ ਕੀਤੇ ਅਤੇ ਲਾਬਾਨ ਦੇ ਇੱਜੜ ਦੀਆਂ ਭੇਡ-ਬੱਕਰੀਆਂ ਦੇ ਮੂੰਹ ਸਭ ਗਦਰੀਆਂ ਅਤੇ ਸਭ ਕਾਲੀਆਂ ਭੇਡਾਂ ਵੱਲ ਫੇਰ ਦਿੱਤੇ ਅਤੇ ਉਸ ਨੇ ਆਪਣੇ ਇੱਜੜਾਂ ਨੂੰ ਲਾਬਾਨ ਦੇ ਇੱਜੜਾਂ ਤੋਂ ਵੱਖਰਿਆਂ ਕੀਤਾ ਅਤੇ ਨਾਲ ਰਲਣ ਨਾ ਦਿੱਤਾ। ");
INSERT INTO pan_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","ਅਤੇ ਜਦ ਤਕੜੀਆਂ ਭੇਡਾਂ ਦੇ ਆਸੇ ਲੱਗਣ ਦਾ ਸਮਾਂ ਆਇਆ ਤਾਂ ਯਾਕੂਬ ਨੇ ਉਹ ਛਿਟੀਆਂ ਉਨ੍ਹਾਂ ਦੀਆਂ ਅੱਖਾਂ ਦੇ ਅੱਗੇ ਰੱਖੀਆਂ, ਇਸ ਲਈ ਕਿ ਓਹ ਉਨ੍ਹਾਂ ਛਿਟੀਆਂ ਦੇ ਅੱਗੇ ਆਸੇ ਲੱਗਣ। ");
INSERT INTO pan_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","ਪਰ ਜਿਹੜਾ ਇੱਜੜ ਕਮਜ਼ੋਰ ਸੀ, ਤਦ ਉਹ ਛਿਟੀਆਂ ਨੂੰ ਉਨ੍ਹਾਂ ਦੇ ਅੱਗੇ ਨਹੀਂ ਰੱਖਦਾ ਸੀ। ਇਸ ਕਾਰਨ ਲਾਬਾਨ ਦੇ ਪੱਠੇ ਕਮਜ਼ੋਰ ਅਤੇ ਯਾਕੂਬ ਦੇ ਤਕੜੇ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","ਇਸ ਤਰ੍ਹਾਂ ਉਹ ਮਨੁੱਖ ਬਹੁਤ ਹੀ ਵੱਧ ਗਿਆ ਅਤੇ ਉਹ ਦੇ ਕੋਲ ਬਹੁਤ ਇੱਜੜ ਅਤੇ ਦਾਸ-ਦਾਸੀਆਂ, ਊਠ ਅਤੇ ਗਧੇ ਹੋ ਗਏ। ");
INSERT INTO pan_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","ਉਸ ਨੇ ਲਾਬਾਨ ਦੇ ਪੁੱਤਰਾਂ ਦੀਆਂ ਗੱਲਾਂ ਸੁਣੀਆਂ ਜੋ ਕਹਿੰਦੇ ਸਨ ਕਿ ਯਾਕੂਬ ਸਾਡੇ ਪਿਤਾ ਦਾ ਸਭ ਕੁਝ ਲੈ ਗਿਆ ਅਤੇ ਸਾਡੇ ਪਿਤਾ ਦੇ ਮਾਲ ਵਿੱਚੋਂ ਇਹ ਸਾਰਾ ਧਨ ਉਹ ਨੇ ਪਾਇਆ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","ਫਿਰ ਯਾਕੂਬ ਨੇ ਲਾਬਾਨ ਦੇ ਚਿਹਰੇ ਵੱਲ ਵੇਖਿਆ ਅਤੇ ਜਾਣ ਲਿਆ ਕਿ ਉਹ ਪਹਿਲਾਂ ਵਾਂਗੂੰ ਉਹ ਦੀ ਵੱਲ ਨਹੀਂ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","ਫੇਰ ਯਹੋਵਾਹ ਨੇ ਯਾਕੂਬ ਨੂੰ ਆਖਿਆ, ਤੂੰ ਆਪਣੇ ਪੁਰਖਿਆਂ ਦੇ ਦੇਸ਼ ਨੂੰ ਅਤੇ ਆਪਣੀ ਜਨਮ ਭੂਮੀ ਵੱਲ ਮੁੜ ਜਾ, ਮੈਂ ਤੇਰੇ ਅੰਗ-ਸੰਗ ਹੋਵਾਂਗਾ। ");
INSERT INTO pan_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","ਤਦ ਯਾਕੂਬ ਨੇ ਰਾਖ਼ੇਲ ਅਤੇ ਲੇਆਹ ਨੂੰ ਮੈਦਾਨ ਵਿੱਚ ਆਪਣੇ ਇੱਜੜ ਕੋਲ ਬੁਲਾਇਆ ");
INSERT INTO pan_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","ਅਤੇ ਉਨ੍ਹਾਂ ਨੂੰ ਆਖਿਆ, ਮੈਂ ਵੇਖਦਾ ਹਾਂ ਕਿ ਤੁਹਾਡੇ ਪਿਤਾ ਦਾ ਮੂੰਹ ਮੇਰੀ ਵੱਲ ਪਹਿਲਾ ਵਾਂਗੂੰ ਨਹੀਂ ਹੈ ਤਾਂ ਵੀ ਮੇਰੇ ਪਿਤਾ ਦਾ ਪਰਮੇਸ਼ੁਰ ਮੇਰੇ ਅੰਗ-ਸੰਗ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","ਤੁਸੀਂ ਜਾਣਦੀਆਂ ਹੋ ਕਿ ਮੈਂ ਆਪਣੇ ਸਾਰੇ ਬਲ ਨਾਲ ਤੁਹਾਡੇ ਪਿਤਾ ਦੀ ਸੇਵਾ ਕੀਤੀ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","ਪਰ ਤੁਹਾਡੇ ਪਿਤਾ ਨੇ ਮੇਰੇ ਨਾਲ ਧੋਖਾ ਕੀਤਾ ਅਤੇ ਮੇਰੀ ਮਜ਼ਦੂਰੀ ਦਸ ਵਾਰੀ ਬਦਲੀ ਪਰ ਪਰਮੇਸ਼ੁਰ ਨੇ ਉਸ ਤੋਂ ਮੈਨੂੰ ਘਾਟਾ ਪੈਣ ਨਾ ਦਿੱਤਾ। ");
INSERT INTO pan_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","ਜਦ ਉਸ ਨੇ ਆਖਿਆ ਕਿ ਚਿਤਲੀਆਂ ਤੇਰੀ ਮਜ਼ਦੂਰੀ ਹਨ ਤਾਂ ਸਾਰੇ ਇੱਜੜ ਨੇ ਗਦਰੇ ਹੀ ਬੱਚੇ ਦਿੱਤੇ। ");
INSERT INTO pan_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","ਇਸ ਤਰ੍ਹਾਂ ਪਰਮੇਸ਼ੁਰ ਨੇ ਤੁਹਾਡੇ ਪਿਤਾ ਦੇ ਡੰਗਰ ਖੋਹ ਕੇ ਮੈਨੂੰ ਦਿੱਤੇ। ");
INSERT INTO pan_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","ਅਤੇ ਜਿਸ ਵੇਲੇ ਇੱਜੜ ਬੇਗ ਵਿੱਚ ਆਉਂਦਾ ਸੀ ਤਾਂ ਮੈਂ ਸੁਫ਼ਨੇ ਵਿੱਚ ਆਪਣੀਆਂ ਅੱਖਾਂ ਚੁੱਕ ਕੇ ਵੇਖਿਆ ਅਤੇ ਵੇਖੋ ਜਿਹੜੇ ਬੱਕਰੇ ਇੱਜੜ ਉੱਪਰ ਟੱਪਦੇ ਸਨ ਓਹ ਗਦਰੇ ਅਤੇ ਚਿਤਲੇ ਅਤੇ ਚਿਤਕਬਰੇ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","ਪਰਮੇਸ਼ੁਰ ਦੇ ਦੂਤ ਨੇ ਮੈਨੂੰ ਸੁਫ਼ਨੇ ਵਿੱਚ ਆਖਿਆ, ਯਾਕੂਬ! ਮੈਂ ਆਖਿਆ, ਮੈਂ ਹਾਜ਼ਰ ਹਾਂ। ");
INSERT INTO pan_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","ਤਦ ਉਸ ਨੇ ਆਖਿਆ ਆਪਣੀਆਂ ਅੱਖਾਂ ਚੁੱਕ ਕੇ ਵੇਖ ਕਿ ਸਾਰੇ ਬੱਕਰੇ ਜਿਹੜੇ ਇੱਜੜ ਦੇ ਉੱਤੇ ਟੱਪਦੇ ਸਨ ਗਦਰੇ ਅਤੇ ਚਿਤਲੇ ਅਤੇ ਚਿਤਕਬਰੇ ਹਨ ਕਿਉਂ ਜੋ ਮੈਂ ਜੋ ਕੁਝ ਲਾਬਾਨ ਨੇ ਤੇਰੇ ਨਾਲ ਕੀਤਾ, ਉਹ ਸਭ ਮੈਂ ਵੇਖਿਆ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","ਮੈਂ ਬੈਤਏਲ ਦਾ ਪਰਮੇਸ਼ੁਰ ਹਾਂ ਜਿੱਥੇ ਤੂੰ ਥੰਮ੍ਹ ਉੱਤੇ ਤੇਲ ਡੋਲ੍ਹਿਆ ਸੀ ਅਤੇ ਮੇਰੇ ਅੱਗੇ ਸੁੱਖਣਾ ਸੁੱਖੀ। ਹੁਣ ਉੱਠ, ਅਤੇ ਇਸ ਦੇਸ਼ ਤੋਂ ਨਿੱਕਲ ਕੇ ਆਪਣੀ ਜਨਮ ਭੂਮੀ ਨੂੰ ਮੁੜ ਜਾ। ");
INSERT INTO pan_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","ਤਦ ਰਾਖ਼ੇਲ ਅਤੇ ਲੇਆਹ ਨੇ ਉੱਤਰ ਦੇ ਕੇ ਆਖਿਆ, ਕੀ ਅਜੇ ਤੱਕ ਸਾਡੇ ਪਿਤਾ ਦੇ ਘਰ ਵਿੱਚ ਸਾਡਾ ਕੋਈ ਹਿੱਸਾ ਜਾਂ ਅਧਿਕਾਰ ਹੈ? ");
INSERT INTO pan_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","ਕੀ ਅਸੀਂ ਉਹ ਦੇ ਅੱਗੇ ਪਰਾਈਆਂ ਨਹੀਂ ਰਹੀਆਂ ਕਿਉਂ ਜੋ ਉਸ ਨੇ ਸਾਨੂੰ ਵੇਚ ਦਿੱਤਾ ਅਤੇ ਸਾਡੀ ਚਾਂਦੀ ਵੀ ਖਾ ਗਿਆ ");
INSERT INTO pan_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","ਇਸ ਲਈ ਪਰਮੇਸ਼ੁਰ ਨੇ ਸਾਡੇ ਪਿਤਾ ਤੋਂ ਜੋ ਧਨ ਲੈ ਲਿਆ ਹੈ ਉਹ ਸਾਡਾ ਅਤੇ ਸਾਡੇ ਪੁੱਤਰਾਂ ਦਾ ਹੈ ਅਤੇ ਹੁਣ ਜੋ ਕੁਝ ਤੈਨੂੰ ਪਰਮੇਸ਼ੁਰ ਨੇ ਆਖਿਆ ਹੈ, ਉਹੀ ਕਰ। ");
INSERT INTO pan_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","ਤਦ ਯਾਕੂਬ ਨੇ ਉੱਠ ਕੇ ਆਪਣੇ ਪੁੱਤਰਾਂ ਅਤੇ ਇਸਤਰੀਆਂ ਨੂੰ ਊਠਾਂ ਉੱਤੇ ਚੜ੍ਹਾਇਆ ");
INSERT INTO pan_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","ਅਤੇ ਆਪਣੇ ਸਾਰੇ ਪਸ਼ੂਆਂ ਨੂੰ ਅਤੇ ਆਪਣੇ ਮਾਲ ਨੂੰ ਜੋ ਉਸ ਨੇ ਇਕੱਠਾ ਕੀਤਾ ਅਰਥਾਤ ਓਹ ਡੰਗਰ ਜੋ ਉਸ ਨੇ ਪਦਨ ਅਰਾਮ ਵਿੱਚ ਕਮਾ ਕੇ ਇਕੱਠੇ ਕੀਤੇ, ਲੈ ਗਿਆ ਤਾਂ ਜੋ ਕਨਾਨ ਦੇਸ਼ ਨੂੰ ਆਪਣੇ ਪਿਤਾ ਇਸਹਾਕ ਕੋਲ ਚਲਿਆ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","ਲਾਬਾਨ ਬਾਹਰ ਆਪਣੀਆਂ ਭੇਡਾਂ ਦੀ ਉੱਨ ਕਤਰਨ ਲਈ ਗਿਆ ਹੋਇਆ ਸੀ ਅਤੇ ਰਾਖ਼ੇਲ ਆਪਣੇ ਪਿਤਾ ਦੇ ਘਰੇਲੂ ਬੁੱਤਾਂ ਨੂੰ ਚੁਰਾ ਕੇ ਲੈ ਗਈ। ");
INSERT INTO pan_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","ਸੋ ਯਾਕੂਬ, ਲਾਬਾਨ ਅਰਾਮੀ ਤੋਂ ਚੋਰੀ ਚਲਾ ਗਿਆ ਅਰਥਾਤ ਉਸ ਨੂੰ ਨਾ ਦੱਸਿਆ ਕਿ ਮੈਂ ਭੱਜਿਆ ਜਾ ਰਿਹਾ ਹਾਂ। ");
INSERT INTO pan_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","ਉਹ ਆਪਣਾ ਸਭ ਕੁਝ ਨਾਲ ਲੈ ਕੇ ਭੱਜਿਆ ਅਤੇ ਉੱਠ ਕੇ ਦਰਿਆ ਪਾਰ ਲੰਘ ਗਿਆ ਅਤੇ ਆਪਣਾ ਮੂੰਹ ਗਿਲਆਦ ਦੇ ਪਰਬਤ ਵੱਲ ਕੀਤਾ। ");
INSERT INTO pan_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","ਤੀਜੇ ਦਿਨ ਲਾਬਾਨ ਨੂੰ ਖ਼ਬਰ ਮਿਲੀ ਕਿ ਯਾਕੂਬ ਭੱਜ ਗਿਆ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","ਇਸ ਲਈ ਉਸ ਨੇ ਆਪਣੇ ਭਰਾਵਾਂ ਨੂੰ ਨਾਲ ਲੈ ਕੇ ਸੱਤਾਂ ਦਿਨਾਂ ਤੱਕ ਉਸ ਦਾ ਪਿੱਛਾ ਕੀਤਾ ਅਤੇ ਉਸ ਨੂੰ ਗਿਲਆਦ ਦੇ ਪਰਬਤ ਉੱਤੇ ਜਾ ਲਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","ਪਰ ਪਰਮੇਸ਼ੁਰ ਨੇ ਲਾਬਾਨ ਅਰਾਮੀ ਦੇ ਕੋਲ ਰਾਤ ਦੇ ਸੁਫ਼ਨੇ ਵਿੱਚ ਜਾ ਕੇ ਆਖਿਆ, ਖ਼ਬਰਦਾਰ ਹੋ ਅਤੇ ਯਾਕੂਬ ਦੇ ਨਾਲ ਭਲਾ ਬੁਰਾ ਨਾ ਬੋਲ। ");
INSERT INTO pan_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","ਤਦ ਲਾਬਾਨ, ਯਾਕੂਬ ਨੂੰ ਜਾ ਮਿਲਿਆ ਅਤੇ ਯਾਕੂਬ ਨੇ ਆਪਣਾ ਤੰਬੂ ਪਰਬਤ ਉੱਤੇ ਖੜ੍ਹਾ ਕੀਤਾ ਸੀ, ਲਾਬਾਨ ਨੇ ਵੀ ਆਪਣੇ ਭਰਾਵਾਂ ਦੇ ਨਾਲ ਗਿਲਆਦ ਦੇ ਪਰਬਤ ਉੱਤੇ ਤੰਬੂ ਖੜ੍ਹਾ ਕੀਤਾ। ");
INSERT INTO pan_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","ਤਦ ਲਾਬਾਨ ਨੇ ਯਾਕੂਬ ਨੂੰ ਆਖਿਆ, ਤੂੰ ਇਹ ਕੀ ਕੀਤਾ ਜੋ ਤੂੰ ਮੇਰੇ ਕੋਲੋਂ ਚੋਰੀ ਭੱਜ ਆਇਆ ਹੈਂ ਅਤੇ ਤੂੰ ਮੇਰੀਆਂ ਧੀਆਂ ਨੂੰ ਤਲਵਾਰ ਦੇ ਜ਼ੋਰ ਨਾਲ ਬਣਾਏ ਕੈਦੀਆਂ ਵਾਂਗੂੰ ਹੱਕ ਲਿਆਇਆ ਹੈਂ? ");
INSERT INTO pan_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","ਤੂੰ ਕਿਉਂ ਲੁੱਕ ਕੇ ਭੱਜਿਆ ਅਤੇ ਮੈਨੂੰ ਠੱਗਿਆ ਅਤੇ ਮੈਨੂੰ ਖ਼ਬਰ ਕਿਉਂ ਨਾ ਦਿੱਤੀ ਤਾਂ ਜੋ ਮੈਂ ਤੈਨੂੰ ਖੁਸ਼ੀ ਅਤੇ ਰਾਗ-ਰੰਗ ਅਤੇ ਡੱਫਾਂ ਅਤੇ ਬਰਬਤਾਂ ਨਾਲ ਵਿਦਿਆ ਕਰਦਾ? ");
INSERT INTO pan_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","ਤੂੰ ਮੈਨੂੰ ਆਪਣੇ ਪੁੱਤਰ ਧੀਆਂ ਨੂੰ ਕਿਉਂ ਚੁੰਮਣ ਨਾ ਦਿੱਤਾ? ਹੁਣ ਤੂੰ ਮੂਰਖਪੁਣਾ ਕੀਤਾ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","ਹੁਣ ਮੇਰੇ ਹੱਥਾਂ ਵਿੱਚ ਸ਼ਕਤੀ ਹੈ ਕਿ ਤੇਰੇ ਨਾਲ ਬੁਰਿਆਈ ਕਰਾਂ ਪਰ ਤੁਹਾਡੇ ਪਿਤਾ ਦੇ ਪਰਮੇਸ਼ੁਰ ਨੇ ਕੱਲ ਰਾਤ ਮੈਨੂੰ ਆਖਿਆ ਕਿ ਖ਼ਬਰਦਾਰ ਹੋ ਅਤੇ ਯਾਕੂਬ ਨਾਲ ਭਲਾ ਜਾਂ ਬੁਰਾ ਨਾ ਬੋਲ। ");
INSERT INTO pan_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","ਹੁਣ ਤੂੰ ਚੱਲਿਆ ਤਾਂ ਹੈਂ ਹੀ ਕਿਉਂ ਜੋ ਤੂੰ ਆਪਣੇ ਪਿਤਾ ਦੇ ਘਰ ਨੂੰ ਲੋਚਦਾ ਹੈਂ ਪਰ ਤੂੰ ਮੇਰੇ ਦੇਵਤਿਆਂ ਨੂੰ ਕਿਉਂ ਚੁਰਾਇਆ? ");
INSERT INTO pan_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","ਯਾਕੂਬ ਨੇ ਲਾਬਾਨ ਨੂੰ ਉੱਤਰ ਦੇ ਕੇ ਆਖਿਆ, ਕਿਉਂ ਜੋ ਮੈਂ ਡਰ ਗਿਆ, ਮੈਂ ਸੋਚਿਆ ਕਿ ਤੂੰ ਮੈਥੋਂ ਆਪਣੀਆਂ ਧੀਆਂ ਨੂੰ ਜ਼ੋਰ ਨਾਲ ਖੋਹ ਕੇ ਲੈ ਜਾਵੇਂਗਾ। ");
INSERT INTO pan_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","ਜਿਹ ਦੇ ਕੋਲ ਤੂੰ ਆਪਣੇ ਦੇਵਤਿਆਂ ਨੂੰ ਪਾਵੇਂਗਾ ਉਹ ਜੀਉਂਦਾ ਨਾ ਰਹੇਗਾ। ਸਾਡੇ ਭਰਾਵਾਂ ਦੇ ਸਾਹਮਣੇ ਲੱਭ ਲੈ ਅਤੇ ਜੋ ਕੁਝ ਤੇਰਾ ਮੇਰੇ ਕੋਲੋਂ ਨਿੱਕਲੇ ਲੈ ਲੈ, ਪਰ ਯਾਕੂਬ ਨਹੀਂ ਜਾਣਦਾ ਸੀ ਕਿ ਰਾਖ਼ੇਲ ਨੇ ਉਨ੍ਹਾਂ ਨੂੰ ਚੁਰਾਇਆ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","ਲਾਬਾਨ, ਯਾਕੂਬ ਦੇ ਅਤੇ ਲੇਆਹ ਦੇ ਤੰਬੂ ਵਿੱਚ ਅਤੇ ਦੋਹਾਂ ਦਾਸੀਆਂ ਦੇ ਤੰਬੂ ਵਿੱਚ ਗਿਆ ਪਰ ਕੁਝ ਨਾ ਮਿਲਿਆ ਅਤੇ ਲੇਆਹ ਦੇ ਤੰਬੂ ਵਿੱਚੋਂ ਨਿੱਕਲ ਕੇ ਰਾਖ਼ੇਲ ਦੇ ਤੰਬੂ ਵਿੱਚ ਆਇਆ। ");
INSERT INTO pan_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","ਤਦ ਰਾਖ਼ੇਲ ਨੇ ਉਨ੍ਹਾਂ ਘਰੇਲੂ ਬੁੱਤਾਂ ਨੂੰ ਲੈ ਕੇ ਊਠ ਦੀ ਕਾਠੀ ਵਿੱਚ ਰੱਖਿਆ ਅਤੇ ਉਨ੍ਹਾਂ ਦੇ ਉੱਤੇ ਬੈਠ ਗਈ ਅਤੇ ਲਾਬਾਨ ਨੇ ਸਾਰੇ ਤੰਬੂ ਦੀ ਖੋਜ ਕੀਤੀ ਪਰ ਕੁਝ ਨਾ ਮਿਲਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","ਉਸ ਨੇ ਆਪਣੇ ਪਿਤਾ ਨੂੰ ਆਖਿਆ ਹੇ ਮੇਰੇ ਸੁਆਮੀ, ਤੁਹਾਡੀਆਂ ਅੱਖਾਂ ਵਿੱਚ ਇਹ ਗੱਲ ਨਰਾਜ਼ਗੀ ਦੀ ਨਾ ਹੋਵੇ ਕਿ ਮੈਂ ਤੁਹਾਡੇ ਸਾਹਮਣੇ ਨਾ ਉੱਠ ਸਕੀ, ਕਿਉਂ ਜੋ ਮੈਂ ਮਾਹਵਾਰੀ ਦੇ ਹਾਲ ਵਿੱਚ ਹਾਂ। ਇਸ ਲਈ ਉਸ ਨੇ ਲੱਭਿਆ ਪਰ ਉਸ ਨੂੰ ਬੁੱਤ ਨਾ ਲੱਭੇ। ");
INSERT INTO pan_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","ਇਹ ਗੱਲ ਤੋਂ ਗੁੱਸੇ ਹੋ ਕੇ ਯਾਕੂਬ, ਲਾਬਾਨ ਨਾਲ ਝਗੜਨ ਲੱਗਾ ਅਤੇ ਯਾਕੂਬ ਨੇ ਲਾਬਾਨ ਨੂੰ ਉੱਤਰ ਦੇ ਕੇ ਆਖਿਆ, ਮੇਰਾ ਕੀ ਕਸੂਰ ਅਤੇ ਮੇਰਾ ਕੀ ਪਾਪ ਹੈ ਜੋ ਤੂੰ ਐਨੇ ਕ੍ਰੋਧ ਵਿੱਚ ਹੋ ਕੇ ਮੇਰਾ ਪਿੱਛਾ ਕੀਤਾ? ");
INSERT INTO pan_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","ਤੂੰ ਜੋ ਮੇਰਾ ਸਾਰਾ ਕੁਝ ਟਟੋਲਿਆ ਤੇਰੇ ਘਰ ਦਾ ਤੈਨੂੰ ਕੀ ਮਿਲਿਆ? ਉਹ ਨੂੰ ਐਥੇ ਆਪਣੇ ਅਤੇ ਮੇਰੇ ਭਰਾਵਾਂ ਦੇ ਅੱਗੇ ਰੱਖ ਤਾਂ ਜੋ ਓਹ ਸਾਡਾ ਦੋਵਾਂ ਦਾ ਨਿਆਂ ਕਰਨ। ");
INSERT INTO pan_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","ਮੈਂ ਇਹਨਾਂ ਵੀਹ ਸਾਲ ਤੱਕ ਤੇਰੇ ਸੰਗ ਰਿਹਾ, ਤੇਰੀਆਂ ਭੇਡਾਂ ਅਤੇ ਬੱਕਰੀਆਂ ਦਾ ਗਰਭ ਨਾ ਡਿੱਗਿਆ ਅਤੇ ਤੇਰੇ ਇੱਜੜ ਦੇ ਮੇਂਢੇ ਮੈਂ ਨਹੀਂ ਖਾਧੇ ");
INSERT INTO pan_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","ਅਤੇ ਫੱਟੜਾਂ ਨੂੰ ਮੈਂ ਤੇਰੇ ਕੋਲ ਨਹੀਂ ਲਿਆਂਦਾ ਸਗੋਂ ਉਨ੍ਹਾਂ ਦਾ ਘਾਟਾ ਮੈਂ ਝੱਲਿਆ ਅਤੇ ਉਹ ਜਿਹੜਾ ਦਿਨ ਜਾਂ ਰਾਤ ਨੂੰ ਚੋਰੀ ਹੋ ਗਿਆ ਉਹ ਤੂੰ ਮੈਥੋਂ ਮੰਗਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","ਮੇਰਾ ਤਾਂ ਇਹ ਹਾਲ ਸੀ, ਕਿ ਦਿਨ ਵੇਲੇ ਧੁੱਪ ਅਤੇ ਰਾਤ ਵੇਲੇ ਠੰਡ ਨੇ ਮੈਨੂੰ ਖਾ ਲਿਆ ਅਤੇ ਨੀਂਦ ਮੇਰੀਆਂ ਅੱਖਾਂ ਤੋਂ ਉੱਡ ਗਈ। ");
INSERT INTO pan_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","ਇਨ੍ਹਾਂ ਵੀਹ ਸਾਲਾਂ ਤੱਕ ਮੈਂ ਤੇਰੇ ਘਰ ਵਿੱਚ ਰਿਹਾ, ਮੈਂ ਚੌਦਾਂ ਸਾਲ ਤੱਕ ਤੇਰੀਆਂ ਦੋਹਾਂ ਧੀਆਂ ਲਈ, ਛੇ ਸਾਲ ਤੇਰੀਆਂ ਭੇਡਾਂ ਲਈ ਤੇਰੀ ਸੇਵਾ ਕੀਤੀ ਅਤੇ ਤੂੰ ਦਸ ਵਾਰ ਮੇਰੀ ਮਜ਼ਦੂਰੀ ਨੂੰ ਬਦਲਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","ਜੇਕਰ ਮੇਰੇ ਪਿਤਾ ਦਾ ਪਰਮੇਸ਼ੁਰ, ਅਬਰਾਹਾਮ ਦਾ ਪਰਮੇਸ਼ੁਰ ਅਤੇ ਇਸਹਾਕ ਦਾ ਡਰ ਮੇਰੇ ਸੰਗ ਨਾ ਹੁੰਦਾ ਤਾਂ ਤੂੰ ਮੈਨੂੰ ਜ਼ਰੂਰ ਸੱਖਣੇ ਹੱਥ ਕੱਢ ਦਿੱਤਾ ਹੁੰਦਾ। ਪਰਮੇਸ਼ੁਰ ਨੇ ਮੇਰਾ ਕਸ਼ਟ ਅਤੇ ਮੇਰੇ ਹੱਥਾਂ ਦੀ ਮਿਹਨਤ ਵੇਖੀ ਅਤੇ ਕੱਲ ਰਾਤ ਤੈਨੂੰ ਝਿੜਕਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","ਲਾਬਾਨ ਨੇ ਯਾਕੂਬ ਨੂੰ ਉੱਤਰ ਦੇ ਕੇ ਆਖਿਆ, ਇਹ ਧੀਆਂ ਮੇਰੀਆਂ ਹੀ ਧੀਆਂ ਹਨ, ਇਹ ਪੁੱਤਰ ਮੇਰੇ ਹੀ ਪੁੱਤਰ ਹਨ, ਇਹ ਇੱਜੜ ਮੇਰੇ ਹੀ ਇੱਜੜ ਹਨ ਅਤੇ ਜੋ ਕੁਝ ਤੂੰ ਵੇਖਦਾ ਹੈਂ ਸਭ ਮੇਰਾ ਹੈ। ਹੁਣ ਮੈਂ ਅੱਜ ਦੇ ਦਿਨ ਆਪਣੀਆਂ ਇਹਨਾਂ ਧੀਆਂ ਅਤੇ ਇਹਨਾਂ ਤੋਂ ਜੰਮੇ ਹੋਏ ਪੁੱਤਰਾਂ ਨਾਲ ਕੀ ਕਰਾਂ? ");
INSERT INTO pan_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","ਸੋ ਹੁਣ ਤੂੰ ਆ ਜੋ ਮੈਂ ਅਤੇ ਤੂੰ ਆਪਣੇ ਵਿੱਚ ਇੱਕ ਨੇਮ ਬੰਨ੍ਹੀਏ ਤਾਂ ਉਹ ਮੇਰੇ ਅਤੇ ਤੇਰੇ ਵਿਚਕਾਰ ਗਵਾਹੀ ਹੋਵੇ। ");
INSERT INTO pan_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","ਤਦ ਯਾਕੂਬ ਨੇ ਇੱਕ ਪੱਥਰ ਲੈ ਕੇ ਥੰਮ੍ਹ ਖੜ੍ਹਾ ਕੀਤਾ ");
INSERT INTO pan_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","ਅਤੇ ਯਾਕੂਬ ਨੇ ਆਪਣੇ ਭਰਾਵਾਂ ਨੂੰ ਆਖਿਆ, ਪੱਥਰ ਇਕੱਠੇ ਕਰੋ ਉਪਰੰਤ ਉਨ੍ਹਾਂ ਨੇ ਪੱਥਰ ਇਕੱਠੇ ਕਰ ਕੇ ਇੱਕ ਢੇਰ ਲਾ ਦਿੱਤਾ ਅਤੇ ਉਨ੍ਹਾਂ ਨੇ ਉੱਥੇ ਉਸ ਢੇਰ ਕੋਲ ਭੋਜਨ ਖਾਧਾ। ");
INSERT INTO pan_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","ਤਦ ਲਾਬਾਨ ਨੇ ਉਸ ਨਗਰ ਦਾ ਨਾਮ ਯਗਰ ਸਾਹਦੂਥਾ ਰੱਖਿਆ ਪਰ ਯਾਕੂਬ ਨੇ ਉਸ ਦਾ ਨਾਮ ਗਲੇਦ ਰੱਖਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","ਲਾਬਾਨ ਨੇ ਆਖਿਆ ਕਿ ਅੱਜ ਇਹ ਢੇਰ ਮੇਰੇ ਅਤੇ ਤੇਰੇ ਵਿੱਚ ਗਵਾਹ ਹੋਵੇਗਾ, ਇਸ ਕਾਰਨ ਉਸ ਦਾ ਨਾਮ ਗਲੇਦ ਰੱਖਿਆ ਗਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","ਅਤੇ ਮਿਸਪਾਹ ਵੀ, ਉਸ ਨੇ ਆਖਿਆ ਕਿ ਯਹੋਵਾਹ ਮੇਰੀ ਅਤੇ ਤੇਰੀ, ਜਦ ਅਸੀਂ ਇੱਕ ਦੂਜੇ ਤੋਂ ਦੂਰ ਹੋਈਏ ਰਾਖੀ ਕਰੇ। ");
INSERT INTO pan_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","ਜੇ ਤੂੰ ਮੇਰੀਆਂ ਧੀਆਂ ਨੂੰ ਤੰਗ ਰੱਖੇਂ ਅਤੇ ਉਨ੍ਹਾਂ ਤੋਂ ਬਿਨ੍ਹਾਂ ਹੋਰ ਇਸਤਰੀਆਂ ਲੈ ਆਵੇਂ, ਭਾਵੇਂ ਸਾਡੇ ਨਾਲ ਕੋਈ ਮਨੁੱਖ ਨਹੀਂ, ਪਰ ਵੇਖ ਪਰਮੇਸ਼ੁਰ ਮੇਰੇ ਅਤੇ ਤੇਰੇ ਵਿੱਚ ਗਵਾਹ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","ਫਿਰ ਲਾਬਾਨ ਨੇ ਯਾਕੂਬ ਨੂੰ ਆਖਿਆ, ਵੇਖ ਇਹ ਢੇਰ ਅਤੇ ਵੇਖ ਇਹ ਥੰਮ੍ਹ ਜੋ ਮੈਂ ਆਪਣੇ ਅਤੇ ਤੇਰੇ ਵਿੱਚਕਾਰ ਖੜ੍ਹਾ ਕੀਤਾ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","ਇਹ ਢੇਰ ਅਤੇ ਇਹ ਥੰਮ੍ਹ ਦੋਵੇਂ ਗਵਾਹ ਹੋਣ ਕਿ ਬੁਰਿਆਈ ਲਈ ਮੈਂ ਇਸ ਢੇਰ ਤੋਂ ਤੇਰੇ ਵੱਲ ਨਾ ਲੰਘਾਂ ਅਤੇ ਤੂੰ ਵੀ ਇਸ ਢੇਰ ਅਤੇ ਇਸ ਥੰਮ੍ਹ ਤੋਂ ਮੇਰੇ ਵੱਲ ਨਾ ਲੰਘੇਂ। ");
INSERT INTO pan_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","ਅਬਰਾਹਾਮ ਦਾ ਪਰਮੇਸ਼ੁਰ ਅਤੇ ਨਾਹੋਰ ਦਾ ਪਰਮੇਸ਼ੁਰ ਅਤੇ ਉਨ੍ਹਾਂ ਦੇ ਪਿਤਾ ਦੇ ਦੇਵਤੇ ਸਾਡਾ ਨਿਆਂ ਕਰਨ ਤਾਂ ਯਾਕੂਬ ਆਪਣੇ ਪਿਤਾ ਇਸਹਾਕ ਦੇ ਡਰ ਦੀ ਸਹੁੰ ਖਾਧੀ। ");
INSERT INTO pan_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","ਯਾਕੂਬ ਨੇ ਉਸ ਪਰਬਤ ਉੱਤੇ ਭੇਟ ਚੜ੍ਹਾਈ ਅਤੇ ਆਪਣੇ ਭਰਾਵਾਂ ਨੂੰ ਰੋਟੀ ਖਾਣ ਨੂੰ ਬੁਲਾਇਆ ਤਾਂ ਉਨ੍ਹਾਂ ਰੋਟੀ ਖਾਧੀ ਅਤੇ ਪਰਬਤ ਉੱਤੇ ਰਾਤ ਕੱਟੀ। ");
INSERT INTO pan_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","ਲਾਬਾਨ ਨੇ ਸਵੇਰੇ ਉੱਠ ਕੇ, ਆਪਣੇ ਪੋਤਰਿਆਂ ਅਤੇ ਧੀਆਂ ਨੂੰ ਚੁੰਮਿਆ ਅਤੇ ਉਹਨਾਂ ਨੂੰ ਬਰਕਤ ਦਿੱਤੀ ਅਤੇ ਲਾਬਾਨ ਤੁਰ ਕੇ ਆਪਣੇ ਸਥਾਨ ਨੂੰ ਮੁੜ ਗਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","ਯਾਕੂਬ ਆਪਣੇ ਰਾਹ ਪੈ ਗਿਆ ਤਦ ਪਰਮੇਸ਼ੁਰ ਦੇ ਦੂਤ ਉਸ ਨੂੰ ਮਿਲੇ। ");
INSERT INTO pan_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","ਯਾਕੂਬ ਨੇ ਉਨ੍ਹਾਂ ਨੂੰ ਵੇਖ ਕੇ ਆਖਿਆ ਕਿ ਇਹ ਤਾਂ ਪਰਮੇਸ਼ੁਰ ਦਾ ਲਸ਼ਕਰ ਹੈ ਅਤੇ ਉਸ ਥਾਂ ਦਾ ਨਾਮ ਮਹਨਇਮ ਰੱਖਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","ਤਦ ਯਾਕੂਬ ਨੇ ਆਪਣੇ ਅੱਗੇ ਸੰਦੇਸ਼ਵਾਹਕਾਂ ਨੂੰ ਆਪਣੇ ਭਰਾ ਏਸਾਓ ਕੋਲ, ਸੇਈਰ ਦੇਸ਼ ਅਤੇ ਅਦੋਮ ਦੇ ਮੈਦਾਨ ਵਿੱਚ ਭੇਜਿਆ ");
INSERT INTO pan_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","ਅਤੇ ਉਨ੍ਹਾਂ ਨੂੰ ਹੁਕਮ ਦੇ ਕੇ ਆਖਿਆ ਕਿ ਤੁਸੀਂ ਮੇਰੇ ਸੁਆਮੀ ਏਸਾਓ ਨੂੰ ਇਸ ਤਰ੍ਹਾਂ ਆਖੋ, ਤੁਹਾਡਾ ਦਾਸ ਯਾਕੂਬ ਇਹ ਆਖਦਾ ਹੈ ਕਿ ਮੈਂ ਲਾਬਾਨ ਕੋਲ ਜਾ ਠਹਿਰਿਆ ਅਤੇ ਹੁਣ ਤੱਕ ਉੱਥੇ ਹੀ ਰਿਹਾ। ");
INSERT INTO pan_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","ਮੇਰੇ ਕੋਲ ਬਲ਼ਦ, ਗਧੇ, ਇੱਜੜ ਅਤੇ ਦਾਸ-ਦਾਸੀਆਂ ਹਨ ਅਤੇ ਮੈਂ ਆਪਣੇ ਸੁਆਮੀ ਨੂੰ ਇਹ ਦੱਸਣ ਲਈ ਇਨ੍ਹਾਂ ਨੂੰ ਭੇਜਿਆ ਹੈ ਕਿ ਤੁਹਾਡੀਆਂ ਅੱਖਾਂ ਵਿੱਚ ਮੇਰੇ ਲਈ ਦਯਾ ਹੋਵੇ। ");
INSERT INTO pan_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","ਯਾਕੂਬ ਦੇ ਸੰਦੇਸ਼ਵਾਹਕਾਂ ਨੇ ਮੁੜ ਆ ਕੇ ਯਾਕੂਬ ਨੂੰ ਦੱਸਿਆ ਕਿ ਅਸੀਂ ਤੇਰੇ ਭਰਾ ਏਸਾਓ ਕੋਲ ਗਏ ਸੀ। ਉਹ ਵੀ ਤੁਹਾਨੂੰ ਮਿਲਣ ਲਈ ਆਉਂਦਾ ਹੈ ਅਤੇ ਉਹ ਦੇ ਨਾਲ ਚਾਰ ਸੌ ਆਦਮੀ ਹਨ। ");
INSERT INTO pan_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","ਤਦ ਯਾਕੂਬ ਬਹੁਤ ਡਰ ਗਿਆ ਅਤੇ ਘਬਰਾਇਆ, ਉਪਰੰਤ ਉਸ ਨੇ ਆਪਣੇ ਨਾਲ ਦੇ ਲੋਕਾਂ, ਇੱਜੜਾਂ, ਬਲ਼ਦਾਂ ਅਤੇ ਊਠਾਂ ਨੂੰ ਲੈ ਕੇ ਉਨ੍ਹਾਂ ਦੀਆਂ ਦੋ ਟੋਲੀਆਂ ਬਣਾਈਆਂ ");
INSERT INTO pan_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","ਅਤੇ ਆਖਿਆ, ਜੇਕਰ ਏਸਾਓ ਇੱਕ ਟੋਲੀ ਉੱਤੇ ਹਮਲਾ ਕਰੇ ਅਤੇ ਉਸ ਨੂੰ ਮਾਰ ਸੁੱਟੇ ਤਦ ਦੂਜੀ ਟੋਲੀ ਜਿਹੜੀ ਬਾਕੀ ਰਹੇ ਬਚ ਜਾਵੇਗੀ। ");
INSERT INTO pan_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","ਫਿਰ ਯਾਕੂਬ ਨੇ ਆਖਿਆ, ਹੇ ਮੇਰੇ ਪਿਤਾ ਅਬਰਾਹਾਮ ਦੇ ਪਰਮੇਸ਼ੁਰ ਅਤੇ ਮੇਰੇ ਪਿਤਾ ਇਸਹਾਕ ਦੇ ਪਰਮੇਸ਼ੁਰ ਯਹੋਵਾਹ ਜਿਸ ਆਖਿਆ ਕਿ ਤੂੰ ਆਪਣੇ ਦੇਸ਼ ਅਤੇ ਆਪਣਿਆਂ ਸੰਬੰਧੀਆਂ ਕੋਲ ਮੁੜ ਜਾ ਅਤੇ ਮੈਂ ਤੇਰੇ ਸੰਗ ਭਲਿਆਈ ਕਰਾਂਗਾ: ");
INSERT INTO pan_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","ਮੈਂ ਤਾਂ ਉਨ੍ਹਾਂ ਸਾਰੀਆਂ ਦਿਆਲ਼ਗੀਆਂ ਅਤੇ ਉਸ ਸਾਰੀ ਸਚਿਆਈ ਤੋਂ ਜਿਹੜੀ ਤੂੰ ਆਪਣੇ ਦਾਸ ਨਾਲ ਕੀਤੀ ਬਹੁਤ ਹੀ ਛੋਟਾ ਹਾਂ। ਮੈਂ ਤਾਂ ਆਪਣੀ ਲਾਠੀ ਦੇ ਨਾਲ ਹੀ ਯਰਦਨ ਦੇ ਪਾਰ ਲੰਘਿਆ ਸੀ ਪਰ ਹੁਣ ਮੈਂ ਦੋ ਟੋਲੀਆਂ ਹੋ ਗਿਆ ਹਾਂ। ");
INSERT INTO pan_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","ਕਿਰਪਾ ਕਰਕੇ ਮੈਨੂੰ ਮੇਰੇ ਭਰਾ ਏਸਾਓ ਦੇ ਹੱਥੋਂ ਛੁਡਾ ਲਵੀਂ ਕਿਉਂ ਜੋ ਮੈਂ ਉਸ ਤੋਂ ਡਰਦਾ ਹਾਂ ਕਿਤੇ ਉਹ ਆ ਕੇ ਮੈਨੂੰ ਅਤੇ ਮਾਵਾਂ ਨੂੰ ਪੁੱਤਰਾਂ ਸਮੇਤ ਨਾ ਮਾਰ ਸੁੱਟੇ। ");
INSERT INTO pan_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","ਤੂੰ ਤਾਂ ਆਖਿਆ, ਕਿ ਮੈਂ ਤੇਰੇ ਨਾਲ ਭਲਿਆਈ ਹੀ ਭਲਿਆਈ ਕਰਾਂਗਾ ਅਤੇ ਤੇਰੀ ਅੰਸ ਨੂੰ ਸਮੁੰਦਰ ਦੀ ਰੇਤ ਵਾਂਗੂੰ ਵਧਾਵਾਂਗਾ, ਜਿਹੜੀ ਬਹੁਤਾਇਤ ਦੇ ਕਾਰਨ ਗਿਣੀ ਨਹੀਂ ਜਾਂਦੀ। ");
INSERT INTO pan_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","ਉਹ ਉਸ ਰਾਤ ਉੱਥੇ ਹੀ ਰਿਹਾ ਅਤੇ ਜੋ ਕੁਝ ਉਸ ਦੇ ਕੋਲ ਸੀ ਉਸ ਵਿੱਚੋਂ ਕੁਝ ਆਪਣੇ ਭਰਾ ਏਸਾਓ ਨੂੰ ਨਜ਼ਰਾਨਾ ਦੇਣ ਲਈ ਲਿਆ ");
INSERT INTO pan_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","ਅਰਥਾਤ ਦੋ ਸੌ ਬੱਕਰੀਆਂ, ਵੀਹ ਬੱਕਰੇ, ਦੋ ਸੌ ਭੇਡਾਂ, ਵੀਹ ਮੇਂਢੇ, ");
INSERT INTO pan_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","ਤੀਹ ਸੂਈਆਂ ਹੋਈਆਂ ਊਠਣੀਆਂ ਬੱਚਿਆਂ ਸਮੇਤ, ਚਾਲ੍ਹੀ ਗਊਆਂ, ਦਸ ਸਾਨ੍ਹ, ਵੀਹ ਗਧੀਆਂ ਅਤੇ ਉਹਨਾਂ ਦੇ ਦਸ ਬੱਚੇ। ");
INSERT INTO pan_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","ਉਸ ਨੇ ਉਨ੍ਹਾਂ ਦੇ ਝੁੰਡ ਵੱਖਰੇ-ਵੱਖਰੇ ਕਰ ਕੇ ਆਪਣੇ ਸੇਵਕਾਂ ਦੇ ਹੱਥ ਦੇ ਦਿੱਤੇ ਅਤੇ ਆਪਣੇ ਸੇਵਕਾਂ ਨੂੰ ਆਖਿਆ, ਤੁਸੀਂ ਮੇਰੇ ਅੱਗੇ-ਅੱਗੇ ਪਾਰ ਲੰਘ ਜਾਓ ਅਤੇ ਵੱਗਾਂ ਦੇ ਵਿਚਕਾਰ ਥੋੜ੍ਹਾ-ਥੋੜ੍ਹਾ ਫ਼ਾਸਲਾ ਰੱਖੋ। ");
INSERT INTO pan_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","ਸਭ ਤੋਂ ਅੱਗੇ ਜਾਣ ਵਾਲੇ ਝੁੰਡ ਦੇ ਰਖਵਾਲੇ ਨੂੰ ਉਸ ਨੇ ਇਹ ਹੁਕਮ ਦਿੱਤਾ, ਕਿ ਜਦ ਤੈਨੂੰ ਮੇਰਾ ਭਰਾ ਏਸਾਓ ਮਿਲੇ ਅਤੇ ਉਹ ਪੁੱਛੇ, ਤੂੰ ਕਿਸ ਦਾ ਦਾਸ ਹੈਂ, ਕਿੱਧਰ ਨੂੰ ਜਾਂਦਾ ਹੈਂ ਅਤੇ ਇਹ ਤੇਰੇ ਅੱਗੇ ਜਾਣ ਵਾਲੇ ਕਿਸ ਦੇ ਹਨ? ");
INSERT INTO pan_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","ਤਾਂ ਤੂੰ ਆਖੀਂ ਇਹ ਤੁਹਾਡੇ ਦਾਸ ਯਾਕੂਬ ਦੇ ਹਨ। ਇਹ ਇੱਕ ਨਜ਼ਰਾਨਾ ਹੈ ਜਿਹੜਾ ਮੇਰੇ ਸੁਆਮੀ ਨੇ ਏਸਾਓ ਲਈ ਭੇਜਿਆ ਹੈ ਅਤੇ ਵੇਖੋ, ਉਹ ਵੀ ਸਾਡੇ ਪਿੱਛੇ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","ਅਤੇ ਉਸ ਨੇ ਦੂਜੇ ਅਤੇ ਤੀਜੇ ਰਖਵਾਲਿਆਂ ਨੂੰ ਸਗੋਂ ਸਾਰਿਆਂ ਨੂੰ ਜਿਹੜੇ ਝੁੰਡ ਦੇ ਪਿੱਛੇ ਆਉਂਦੇ ਸਨ, ਹੁਕਮ ਦਿੱਤਾ ਕਿ ਜਦ ਤੁਸੀਂ ਏਸਾਓ ਨੂੰ ਮਿਲੋ ਤਾਂ ਤੁਸੀਂ ਇਸੇ ਤਰ੍ਹਾਂ ਹੀ ਆਖਣਾ। ");
INSERT INTO pan_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","ਅਤੇ ਇਹ ਵੀ ਆਖਣਾ, ਵੇਖੋ, ਤੁਹਾਡਾ ਦਾਸ ਯਾਕੂਬ ਸਾਡੇ ਪਿੱਛੇ-ਪਿੱਛੇ ਆ ਰਿਹਾ ਹੈ ਕਿਉਂ ਜੋ ਉਸ ਨੇ ਆਖਿਆ ਕਿ ਇਸ ਨਜ਼ਰਾਨੇ ਨਾਲ ਜਿਹੜਾ ਮੇਰੇ ਅੱਗੇ-ਅੱਗੇ ਜਾਂਦਾ ਹੈ ਮੈਂ ਉਸ ਦਾ ਗੁੱਸਾ ਠੰਡਾ ਕਰਾਂਗਾ ਅਤੇ ਇਸ ਤੋਂ ਬਾਅਦ ਹੀ ਉਹ ਦਾ ਮੂੰਹ ਵੇਖਾਂਗਾ, ਸ਼ਾਇਦ ਉਹ ਮੈਨੂੰ ਕਬੂਲ ਕਰੇ। ");
INSERT INTO pan_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","ਇਸ ਲਈ ਉਹ ਨਜ਼ਰਾਨਾ ਉਸ ਤੋਂ ਅੱਗੇ ਪਾਰ ਲੰਘ ਗਿਆ ਅਤੇ ਉਹ ਆਪ ਉਸ ਰਾਤ ਆਪਣੀ ਟੋਲੀ ਨਾਲ ਰਿਹਾ। ");
INSERT INTO pan_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","ਉਹ ਉਸੇ ਰਾਤ ਉੱਠਿਆ ਅਤੇ ਆਪਣੀਆਂ ਦੋਵੇਂ ਪਤਨੀਆਂ, ਦੋਵੇਂ ਦਾਸੀਆਂ ਅਤੇ ਗਿਆਰ੍ਹਾਂ ਪੁੱਤਰਾਂ ਨੂੰ ਲੈ ਕੇ ਯਬੋਕ ਨਦੀ ਤੋਂ ਪਾਰ ਲੰਘਾ ਦਿੱਤਾ। ");
INSERT INTO pan_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","ਉਸ ਨੇ ਉਨ੍ਹਾਂ ਨੂੰ ਅਤੇ ਜੋ ਉਸ ਦੇ ਕੋਲ ਸੀ, ਪਾਰ ਲੰਘਾ ਦਿੱਤਾ। ");
INSERT INTO pan_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","ਅਤੇ ਯਾਕੂਬ ਇਕੱਲਾ ਰਹਿ ਗਿਆ, ਉਸ ਦੇ ਨਾਲ ਇੱਕ ਮਨੁੱਖ ਦਿਨ ਚੜ੍ਹਨ ਤੱਕ ਘੁਲਦਾ ਰਿਹਾ। ");
INSERT INTO pan_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","ਜਦ ਉਸ ਨੇ ਵੇਖਿਆ ਕਿ ਮੈਂ ਯਾਕੂਬ ਤੋਂ ਜਿੱਤ ਨਹੀਂ ਸਕਦਾ ਤਾਂ ਉਸ ਨੇ ਯਾਕੂਬ ਦੇ ਪੱਟ ਦੇ ਜੋੜ ਨੂੰ ਹੱਥ ਲਾਇਆ ਅਤੇ ਯਾਕੂਬ ਦੇ ਪੱਟ ਦਾ ਜੋੜ ਉਸ ਦੇ ਨਾਲ ਘੁਲਣ ਦੇ ਕਾਰਨ ਨਿੱਕਲ ਗਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","ਤਦ ਉਸ ਮਨੁੱਖ ਨੇ ਆਖਿਆ, ਮੈਨੂੰ ਜਾਣ ਦੇ ਕਿਉਂ ਜੋ ਦਿਨ ਚੜ੍ਹ ਗਿਆ ਹੈ। ਯਾਕੂਬ ਨੇ ਆਖਿਆ, ਮੈਂ ਤੈਨੂੰ ਨਹੀਂ ਜਾਣ ਦਿਆਂਗਾ, ਜਦ ਤੱਕ ਤੂੰ ਮੈਨੂੰ ਬਰਕਤ ਨਾ ਦੇਵੇਂ। ");
INSERT INTO pan_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","ਤਾਂ ਉਸ ਨੇ ਪੁੱਛਿਆ, ਤੇਰਾ ਨਾਮ ਕੀ ਹੈ? ਉਸ ਨੇ ਆਖਿਆ, ਯਾਕੂਬ। ");
INSERT INTO pan_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","ਤਦ ਉਸ ਨੇ ਆਖਿਆ, ਤੇਰਾ ਨਾਮ ਹੁਣ ਤੋਂ ਯਾਕੂਬ ਨਹੀਂ ਸਗੋਂ ਇਸਰਾਏਲ ਹੋਵੇਗਾ ਕਿਉਂ ਜੋ ਤੂੰ ਪਰਮੇਸ਼ੁਰ ਅਤੇ ਮਨੁੱਖਾਂ ਨਾਲ ਯੁੱਧ ਕਰ ਕੇ ਜਿੱਤ ਗਿਆ ਹੈਂ। ");
INSERT INTO pan_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","ਤਾਂ ਯਾਕੂਬ ਨੇ ਆਖਿਆ, ਕਿਰਪਾ ਕਰਕੇ ਮੈਨੂੰ ਆਪਣਾ ਨਾਮ ਦੱਸੋ? ਉਸ ਨੇ ਆਖਿਆ, ਤੂੰ ਮੇਰਾ ਨਾਮ ਕਿਉਂ ਪੁੱਛਦਾ ਹੈਂ? ਤਦ ਉਸ ਨੇ ਉਹ ਨੂੰ ਉੱਥੇ ਬਰਕਤ ਦਿੱਤੀ। ");
INSERT INTO pan_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","ਯਾਕੂਬ ਨੇ ਇਹ ਆਖ ਕੇ ਉਸ ਸਥਾਨ ਦਾ ਨਾਮ ਪਨੀਏਲ ਰੱਖਿਆ ਕਿਉਂ ਜੋ ਉਸ ਨੇ ਪਰਮੇਸ਼ੁਰ ਨੂੰ ਆਹਮੋ-ਸਾਹਮਣੇ ਵੇਖਿਆ ਅਤੇ ਉਸ ਦੀ ਜਾਨ ਬਚ ਗਈ। ");
INSERT INTO pan_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","ਜਦ ਉਹ ਪਨੂਏਲ ਤੋਂ ਪਾਰ ਲੰਘ ਗਿਆ ਤਾਂ ਸੂਰਜ ਚੜ੍ਹ ਗਿਆ ਸੀ ਅਤੇ ਉਹ ਆਪਣੇ ਪੱਟ ਤੋਂ ਲੰਗੜਾ ਕੇ ਤੁਰਦਾ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","ਇਸ ਲਈ ਇਸਰਾਏਲੀ ਉਸ ਨਾੜੀ ਦੇ ਪੱਠੇ ਨੂੰ ਜਿਹੜਾ ਪੱਟ ਦੇ ਜੋੜ ਉੱਤੇ ਹੈ, ਅੱਜ ਤੱਕ ਨਹੀਂ ਖਾਂਦੇ ਕਿਉਂ ਜੋ ਉਸ ਮਨੁੱਖ ਨੇ ਯਾਕੂਬ ਦੀ ਨਾੜੀ ਦੇ ਪੱਠੇ ਨੂੰ ਪੱਟ ਦੇ ਜੋੜ ਕੋਲ ਹੱਥ ਲਾ ਦਿੱਤਾ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","ਯਾਕੂਬ ਨੇ ਆਪਣੀਆਂ ਅੱਖਾਂ ਚੁੱਕ ਕੇ ਵੇਖਿਆ ਕਿ ਏਸਾਓ ਆ ਰਿਹਾ ਸੀ ਅਤੇ ਉਸ ਦੇ ਨਾਲ ਚਾਰ ਸੌ ਆਦਮੀ ਹਨ, ਤਦ ਉਸ ਨੇ ਬੱਚਿਆਂ ਨੂੰ ਲੇਆਹ, ਰਾਖ਼ੇਲ ਅਤੇ ਦੋਵੇਂ ਦਾਸੀਆਂ ਵਿੱਚ ਵੰਡ ਦਿੱਤਾ ਅਤੇ ਉਸ ਨੇ ਦਾਸੀਆਂ ਨੂੰ ਅਤੇ ਉਹਨਾਂ ਦੇ ਬੱਚਿਆਂ ਨੂੰ ਸਾਰਿਆਂ ਤੋਂ ਅੱਗੇ ਰੱਖਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","ਲੇਆਹ ਅਤੇ ਉਸ ਦੇ ਬੱਚਿਆਂ ਨੂੰ ਉਨ੍ਹਾਂ ਦੇ ਪਿੱਛੇ ਅਤੇ ਰਾਖ਼ੇਲ ਅਤੇ ਯੂਸੁਫ਼ ਨੂੰ ਸਾਰਿਆਂ ਤੋਂ ਪਿੱਛੇ ਰੱਖਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","ਪਰ ਉਹ ਆਪ ਉਨ੍ਹਾਂ ਦੇ ਅੱਗੇ-ਅੱਗੇ ਪਾਰ ਲੰਘਿਆ ਅਤੇ ਸੱਤ ਵਾਰ ਧਰਤੀ ਉੱਤੇ ਆਪਣੇ ਆਪ ਨੂੰ ਝੁਕਾਇਆ ਜਦ ਤੱਕ ਉਸ ਏਸਾਓ ਕੋਲ ਨਾ ਪਹੁੰਚਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","ਤਦ ਏਸਾਓ ਉਸ ਦੇ ਮਿਲਣ ਨੂੰ ਨੱਠਾ ਅਤੇ ਉਸ ਨੂੰ ਜੱਫ਼ੀ ਪਾਈ ਅਤੇ ਉਸ ਦੇ ਗਲ਼ ਵਿੱਚ ਬਾਹਾਂ ਪਾ ਕੇ ਉਸ ਨੂੰ ਚੁੰਮਿਆ ਅਤੇ ਦੋਵੇਂ ਰੋਣ ਲੱਗੇ। ");
INSERT INTO pan_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","ਫੇਰ ਏਸਾਓ ਨੇ ਅੱਖਾਂ ਚੁੱਕ ਕੇ ਇਸਤਰੀਆਂ ਅਤੇ ਬੱਚਿਆਂ ਨੂੰ ਵੇਖਿਆ ਅਤੇ ਪੁੱਛਿਆ, ਤੇਰੇ ਨਾਲ ਇਹ ਕੌਣ ਹਨ? ਤਾਂ ਉਸ ਨੇ ਆਖਿਆ, ਇਹ ਓਹ ਬੱਚੇ ਹਨ, ਜਿਹੜੇ ਪਰਮੇਸ਼ੁਰ ਨੇ ਤੇਰੇ ਦਾਸ ਨੂੰ ਬਖ਼ਸ਼ੇ ਹਨ। ");
INSERT INTO pan_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","ਤਦ ਦਾਸੀਆਂ ਅਤੇ ਉਨ੍ਹਾਂ ਦੇ ਬੱਚਿਆਂ ਦੇ ਨੇੜੇ ਆ ਕੇ ਆਪਣੇ ਆਪ ਨੂੰ ਝੁਕਾਇਆ। ");
INSERT INTO pan_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","ਫੇਰ ਲੇਆਹ ਅਤੇ ਉਸ ਦੇ ਬੱਚਿਆਂ ਨੇ ਨੇੜੇ ਆ ਕੇ ਆਪਣੇ ਆਪ ਨੂੰ ਝੁਕਾਇਆ ਅਤੇ ਅਖ਼ੀਰ ਵਿੱਚ ਯੂਸੁਫ਼ ਅਤੇ ਰਾਖ਼ੇਲ ਨੇ ਨੇੜੇ ਆ ਕੇ ਆਪਣੇ ਆਪ ਨੂੰ ਝੁਕਾਇਆ। ");
INSERT INTO pan_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","ਤਦ ਏਸਾਓ ਨੇ ਪੁੱਛਿਆ, ਇਸ ਸਾਰੀ ਟੋਲੀ ਤੋਂ ਜਿਹੜੀ ਮੈਨੂੰ ਮਿਲੀ, ਤੇਰਾ ਕੀ ਉਦੇਸ਼ ਹੈ? ਉਸ ਨੇ ਆਖਿਆ, ਇਸ ਲਈ ਜੋ ਮੇਰੇ ਸੁਆਮੀ ਦੀ ਕਿਰਪਾ ਮੇਰੇ ਉੱਤੇ ਹੋਵੇ। ");
INSERT INTO pan_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","ਤਦ ਏਸਾਓ ਨੇ ਆਖਿਆ, ਹੇ ਮੇਰੇ ਭਰਾ, ਮੇਰੇ ਕੋਲ ਤਾਂ ਬਹੁਤ ਕੁਝ ਹੈ, ਅਤੇ ਜੋ ਤੇਰਾ ਹੈ ਉਹ ਤੂੰ ਆਪਣੇ ਕੋਲ ਹੀ ਰੱਖ। ");
INSERT INTO pan_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","ਯਾਕੂਬ ਨੇ ਆਖਿਆ, ਨਹੀਂ! ਜੇ ਤੇਰੀ ਕਿਰਪਾ ਦੀ ਨਜ਼ਰ ਮੇਰੇ ਉੱਤੇ ਹੈ ਤਾਂ ਮੇਰਾ ਨਜ਼ਰਾਨਾ ਮੇਰੇ ਹੱਥੋਂ ਕਬੂਲ ਕਰ, ਕਿਉਂ ਜੋ ਮੇਰੇ ਲਈ ਤੇਰੇ ਮੁੱਖ ਨੂੰ ਵੇਖਣਾ ਜਾਣੋ ਪਰਮੇਸ਼ੁਰ ਦੇ ਮੁੱਖ ਨੂੰ ਵੇਖਣ ਦੇ ਬਰਾਬਰ ਹੈ, ਅਤੇ ਤੂੰ ਮੈਥੋਂ ਪ੍ਰਸੰਨ ਹੋਇਆ ਹੈਂ। ");
INSERT INTO pan_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","ਮੇਰਾ ਨਜ਼ਰਾਨਾ ਜਿਹੜਾ ਮੈਂ ਤੇਰੇ ਕੋਲ ਭੇਜਿਆ ਹੈ, ਕਬੂਲ ਕਰ ਕਿਉਂ ਜੋ ਪਰਮੇਸ਼ੁਰ ਨੇ ਮੇਰੇ ਉੱਤੇ ਦਯਾ ਕੀਤੀ ਹੈ ਅਤੇ ਮੇਰੇ ਕੋਲ ਸਭ ਕੁਝ ਹੈ। ਜਦ ਉਸ ਨੇ ਉਹ ਦੀ ਬਹੁਤ ਮਿੰਨਤ ਕੀਤੀ ਤਾਂ ਉਸ ਨੇ ਕਬੂਲ ਕਰ ਲਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","ਫੇਰ ਏਸਾਓ ਨੇ ਆਖਿਆ, ਆ, ਅਸੀਂ ਆਪਣੇ ਰਾਹ ਨੂੰ ਚੱਲੀਏ ਅਤੇ ਮੈਂ ਤੇਰੇ ਅੱਗੇ-ਅੱਗੇ ਚੱਲਾਂਗਾ। ");
INSERT INTO pan_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","ਪਰ ਯਾਕੂਬ ਨੇ ਉਹ ਨੂੰ ਆਖਿਆ, ਮੇਰਾ ਸੁਆਮੀ ਜਾਣਦਾ ਹੈ ਕਿ ਮੇਰੇ ਨਾਲ ਸੋਹਲ ਬੱਚੇ ਹਨ ਅਤੇ ਮੇਰੇ ਕੋਲ ਭੇਡਾਂ-ਬੱਕਰੀਆਂ ਅਤੇ ਲਵੇਰੀਆਂ ਗਊਆਂ ਹਨ, ਜੇ ਓਹ ਇੱਕ ਦਿਨ ਤੋਂ ਵੱਧ ਹੱਕੇ ਗਏ ਤਾਂ ਸਾਰੇ ਇੱਜੜ ਮਰ ਜਾਣਗੇ। ");
INSERT INTO pan_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","ਮੇਰਾ ਸੁਆਮੀ ਆਪਣੇ ਦਾਸ ਤੋਂ ਅੱਗੇ ਪਾਰ ਲੰਘ ਜਾਵੇ ਅਤੇ ਮੈਂ ਹੌਲੀ-ਹੌਲੀ ਪਸ਼ੂਆਂ ਦੀ ਤੋਰ ਅਨੁਸਾਰ ਜਿਹੜੇ ਮੇਰੇ ਅੱਗੇ ਹਨ, ਅਤੇ ਬੱਚਿਆਂ ਦੀ ਤੋਰ ਅਨੁਸਾਰ ਆਵਾਂਗਾ, ਜਦ ਤੱਕ ਮੈਂ ਆਪਣੇ ਸੁਆਮੀ ਕੋਲ ਸੇਈਰ ਵਿੱਚ ਨਾ ਪਹੁੰਚਾਂ। ");
INSERT INTO pan_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","ਤਦ ਏਸਾਓ ਨੇ ਆਖਿਆ, ਮੈਂ ਆਪਣੇ ਨਾਲ ਦੇ ਲੋਕਾਂ ਵਿੱਚੋਂ ਕੁਝ ਨੂੰ ਤੇਰੇ ਕੋਲ ਛੱਡ ਦਿੰਦਾ ਹਾਂ। ਪਰ ਉਸ ਨੇ ਆਖਿਆ, ਇਸ ਦੀ ਕੀ ਲੋੜ ਹੈ? ਪਰ ਮੇਰੇ ਸੁਆਮੀ ਦੀ ਕਿਰਪਾ ਮੇਰੇ ਉੱਤੇ ਹੋਵੇ, ਇੰਨ੍ਹਾਂ ਹੀ ਮੇਰੇ ਲਈ ਬਹੁਤ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","ਤਦ ਉਸੇ ਦਿਨ ਏਸਾਓ ਨੇ ਫੇਰ ਸੇਈਰ ਦਾ ਰਾਹ ਫੜਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","ਯਾਕੂਬ ਸੁੱਕੋਥ ਦੇ ਰਾਹ ਪੈ ਗਿਆ, ਅਤੇ ਆਪਣੇ ਲਈ ਇੱਕ ਘਰ ਬਣਾਇਆ ਅਤੇ ਆਪਣੇ ਪਸ਼ੂਆਂ ਲਈ ਛੱਪਰ ਬਣਾਏ। ਇਸ ਲਈ ਉਸ ਸਥਾਨ ਦਾ ਨਾਮ ਸੁੱਕੋਥ ਪੈ ਗਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","ਯਾਕੂਬ ਸ਼ਾਂਤੀ ਨਾਲ ਪਦਨ ਅਰਾਮ ਵਿੱਚੋਂ ਨਿੱਕਲ ਕੇ ਕਨਾਨ ਦੇਸ਼ ਦੇ ਨਗਰ ਸ਼ਕਮ ਵਿੱਚ ਆਇਆ, ਅਤੇ ਨਗਰ ਦੇ ਅੱਗੇ ਆਪਣਾ ਡੇਰਾ ਲਾਇਆ ");
INSERT INTO pan_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","ਅਤੇ ਪੈਲੀ ਦਾ ਖੱਤਾ ਜਿੱਥੇ ਉਸ ਨੇ ਆਪਣਾ ਤੰਬੂ ਲਾਇਆ, ਉਹ ਉਸ ਨੇ ਸ਼ਕਮ ਦੇ ਪਿਤਾ ਹਮੋਰ ਦੇ ਪੁੱਤਰਾਂ ਦੇ ਹੱਥੋਂ ਚਾਂਦੀ ਦੇ ਸੌ ਸਿੱਕਿਆਂ ਨਾਲ ਮੁੱਲ ਲਿਆ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","ਉੱਥੇ ਉਸ ਨੇ ਇੱਕ ਜਗਵੇਦੀ ਬਣਾਈ ਅਤੇ ਉਸ ਦਾ ਨਾਮ ਨੂੰ ਏਲ-ਏਲੋਹੇ ਇਸਰਾਏਲ ਰੱਖਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","ਫਿਰ ਲੇਆਹ ਦੀ ਧੀ ਦੀਨਾਹ, ਜਿਹੜੀ ਯਾਕੂਬ ਤੋਂ ਪੈਦਾ ਹੋਈ ਸੀ, ਉਸ ਦੇਸ਼ ਦੀਆਂ ਧੀਆਂ ਨੂੰ ਮਿਲਣ ਲਈ ਬਾਹਰ ਗਈ। ");
INSERT INTO pan_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","ਤਦ ਹਮੋਰ ਹਿੱਵੀ ਦੇ ਪੁੱਤਰ ਸ਼ਕਮ, ਉਸ ਦੇਸ਼ ਦੇ ਸ਼ਹਿਜ਼ਾਦੇ ਨੇ ਉਹ ਨੂੰ ਵੇਖਿਆ ਅਤੇ ਉਹ ਨੂੰ ਲੈ ਕੇ ਉਹ ਦੇ ਨਾਲ ਕੁਕਰਮ ਕੀਤਾ ਅਤੇ ਉਸ ਨੂੰ ਭਰਿਸ਼ਟ ਕੀਤਾ। ");
INSERT INTO pan_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","ਤਦ ਉਸ ਦਾ ਦਿਲ ਯਾਕੂਬ ਦੀ ਧੀ ਦੀਨਾਹ ਨਾਲ ਲੱਗ ਗਿਆ ਅਤੇ ਉਹ ਨੇ ਉਸ ਕੁੜੀ ਨਾਲ ਪ੍ਰੇਮ ਕੀਤਾ ਅਤੇ ਉਸ ਕੁੜੀ ਨਾਲ ਮਿੱਠੇ ਬੋਲ ਬੋਲੇ। ");
INSERT INTO pan_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","ਸੋ ਸ਼ਕਮ ਨੇ ਆਪਣੇ ਪਿਤਾ ਹਮੋਰ ਨੂੰ ਆਖਿਆ, ਇਸ ਕੁੜੀ ਨੂੰ ਮੇਰੇ ਨਾਲ ਵਿਆਹੁਣ ਲਈ ਲੈ ਦੇ। ");
INSERT INTO pan_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","ਯਾਕੂਬ ਨੇ ਸੁਣਿਆ ਕਿ ਸ਼ਕਮ ਨੇ ਮੇਰੀ ਧੀ ਦੀਨਾਹ ਨੂੰ ਭਰਿਸ਼ਟ ਕੀਤਾ ਹੈ ਪਰ ਉਹ ਦੇ ਪੁੱਤਰ ਪਸ਼ੂਆਂ ਦੇ ਨਾਲ ਮੈਦਾਨ ਨੂੰ ਗਏ ਹੋਏ ਸਨ, ਇਸ ਲਈ ਯਾਕੂਬ ਉਹਨਾਂ ਦੇ ਆਉਣ ਤੱਕ ਚੁੱਪ ਰਿਹਾ। ");
INSERT INTO pan_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","ਫਿਰ ਹਮੋਰ ਸ਼ਕਮ ਦਾ ਪਿਤਾ ਯਾਕੂਬ ਦੇ ਨਾਲ ਗੱਲਾਂ ਕਰਨ ਲਈ ਉਹ ਦੇ ਕੋਲ ਬਾਹਰ ਗਿਆ ");
INSERT INTO pan_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","ਅਤੇ ਯਾਕੂਬ ਦੇ ਪੁੱਤਰ ਇਹ ਸੁਣਦਿਆਂ ਹੀ ਮੈਦਾਨ ਤੋਂ ਬਹੁਤ ਦੁਖੀ ਹੋ ਕੇ ਅਤੇ ਗੁੱਸੇ ਵਿੱਚ ਆਏ ਕਿਉਂ ਜੋ ਸ਼ਕਮ ਨੇ ਯਾਕੂਬ ਦੀ ਧੀ ਨਾਲ ਲੇਟ ਕੇ ਇਸਰਾਏਲ ਵਿੱਚ ਅਜਿਹੀ ਮੂਰਖਤਾਈ ਕੀਤੀ ਸੀ ਜੋ ਉਸ ਨੂੰ ਨਹੀਂ ਕਰਨੀ ਚਾਹੀਦੀ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","ਹਮੋਰ ਨੇ ਉਨ੍ਹਾਂ ਦੇ ਨਾਲ ਇਹ ਗੱਲ ਕੀਤੀ, ਮੇਰੇ ਪੁੱਤਰ ਸ਼ਕਮ ਦਾ ਦਿਲ ਤੁਹਾਡੀ ਧੀ ਨਾਲ ਲੱਗ ਗਿਆ ਹੈ, ਇਸ ਲਈ ਉਹ ਨੂੰ ਇਹ ਦੇ ਨਾਲ ਵਿਆਹ ਦਿਉ, ");
INSERT INTO pan_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","ਅਤੇ ਸਾਡੇ ਨਾਲ ਰਿਸ਼ਤੇਦਾਰੀ ਕਰੋ। ਸਾਨੂੰ ਆਪਣੀਆਂ ਧੀਆਂ ਦੇ ਦਿਉ ਅਤੇ ਆਪਣੇ ਲਈ ਸਾਡੀਆਂ ਧੀਆਂ ਲੈ ਲਉ, ");
INSERT INTO pan_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","ਅਤੇ ਸਾਡੇ ਨਾਲ ਵੱਸੋ ਅਤੇ ਇਹ ਦੇਸ਼ ਤੁਹਾਡੇ ਅੱਗੇ ਹੈ, ਇੱਥੇ ਵੱਸੋ ਅਤੇ ਵਣਜ-ਵਪਾਰ ਕਰੋ ਅਤੇ ਉਸ ਨੂੰ ਆਪਣੀ ਨਿੱਜ-ਸੰਪਤੀ ਬਣਾਓ। ");
INSERT INTO pan_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","ਸ਼ਕਮ ਨੇ ਵੀ ਦੀਨਾਹ ਦੇ ਪਿਤਾ ਅਤੇ ਉਹ ਦੇ ਭਰਾਵਾਂ ਨੂੰ ਆਖਿਆ, ਜੇ ਤੁਹਾਡੀ ਨਿਗਾਹ ਵਿੱਚ ਮੇਰੇ ਲਈ ਦਯਾ ਹੋਵੇ ਤਾਂ ਜੋ ਤੁਸੀਂ ਮੈਨੂੰ ਆਖੋ, ਸੋ ਮੈਂ ਦਿਆਂਗਾ। ");
INSERT INTO pan_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","ਜਿੰਨ੍ਹਾਂ ਵੀ ਦਾਜ ਅਤੇ ਦਾਨ ਤੁਸੀਂ ਮੇਰੇ ਉੱਤੇ ਲਾ ਦਿਓਗੇ, ਮੈਂ ਤੁਹਾਡੇ ਆਖੇ ਅਨੁਸਾਰ ਦਿਆਂਗਾ ਪਰ ਇਹ ਕੁੜੀ ਮੇਰੇ ਨਾਲ ਵਿਆਹ ਦਿਉ। ");
INSERT INTO pan_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","ਤਦ ਇਹ ਸੋਚ ਕੇ ਕਿ ਸ਼ਕਮ ਨੇ ਉਨ੍ਹਾਂ ਦੀ ਭੈਣ ਦੀਨਾਹ ਨੂੰ ਭਰਿਸ਼ਟ ਕੀਤਾ ਹੈ, ਯਾਕੂਬ ਦੇ ਪੁੱਤਰਾਂ ਨੇ ਸ਼ਕਮ ਅਤੇ ਉਹ ਦੇ ਪਿਤਾ ਹਮੋਰ ਨੂੰ ਧੋਖੇ ਨਾਲ ਉੱਤਰ ਦਿੱਤਾ। ");
INSERT INTO pan_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","ਉਨ੍ਹਾਂ ਨੂੰ ਆਖਿਆ, ਅਸੀਂ ਇਹ ਕੰਮ ਨਹੀਂ ਕਰ ਸਕਦੇ ਜੋ ਆਪਣੀ ਭੈਣ ਬੇਸੁੰਨਤੇ ਮਨੁੱਖ ਨੂੰ ਦੇਈਏ ਕਿਉਂ ਜੋ ਇਸ ਤੋਂ ਸਾਡੀ ਬਦਨਾਮੀ ਹੋਵੇਗੀ। ");
INSERT INTO pan_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","ਅਸੀਂ ਸਿਰਫ਼ ਤਾਂ ਹੀ ਤੁਹਾਡੀ ਗੱਲ ਮੰਨਾਂਗੇ, ਜੇ ਤੁਸੀਂ ਸਾਡੇ ਵਾਂਗੂੰ ਹੋ ਜਾਓ ਅਤੇ ਤੁਹਾਡੇ ਵਿੱਚ ਹਰ ਇੱਕ ਪੁਰਖ ਦੀ ਸੁੰਨਤ ਕਰਾਈ ਜਾਏ। ");
INSERT INTO pan_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","ਤਦ ਅਸੀਂ ਆਪਣੀਆਂ ਧੀਆਂ ਤੁਹਾਨੂੰ ਦਿਆਂਗੇ, ਅਤੇ ਤੁਹਾਡੀਆਂ ਧੀਆਂ ਆਪਣੇ ਲਈ ਲਵਾਂਗੇ, ਅਤੇ ਅਸੀਂ ਤੁਹਾਡੇ ਸੰਗ ਵੱਸਾਂਗੇ ਅਤੇ ਅਸੀਂ ਇੱਕ ਕੌਮ ਬਣ ਜਾਂਵਾਂਗੇ। ");
INSERT INTO pan_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","ਪਰ ਜੇ ਤੁਸੀਂ ਸੁੰਨਤ ਕਰਾਉਣ ਦੇ ਵਿਖੇ ਸਾਡੀ ਨਹੀਂ ਸੁਣੋਗੇ ਤਾਂ ਅਸੀਂ ਆਪਣੀ ਧੀ ਲੈ ਕੇ ਚਲੇ ਜਾਂਵਾਂਗੇ। ");
INSERT INTO pan_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","ਉਨ੍ਹਾਂ ਦੀਆਂ ਗੱਲਾਂ ਹਮੋਰ ਦੇ ਮਨ ਵਿੱਚ ਅਤੇ ਉਸ ਦੇ ਪੁੱਤਰ ਸ਼ਕਮ ਦੇ ਮਨ ਵਿੱਚ ਚੰਗੀਆਂ ਲੱਗੀਆਂ ");
INSERT INTO pan_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","ਅਤੇ ਉਸ ਜਵਾਨ ਨੇ ਇਹ ਗੱਲ ਕਰਨ ਵਿੱਚ ਇਸ ਲਈ ਦੇਰੀ ਨਾ ਕੀਤੀ, ਕਿਉਂ ਜੋ ਉਹ ਯਾਕੂਬ ਦੀ ਧੀ ਨੂੰ ਬਹੁਤ ਚਾਹੁੰਦਾ ਸੀ ਅਤੇ ਉਹ ਆਪਣੇ ਪਿਤਾ ਦੇ ਸਾਰੇ ਘਰ ਵਿੱਚ ਮਾਣ-ਸਨਮਾਨ ਵਾਲਾ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","ਤਦ ਹਮੋਰ ਅਤੇ ਉਹ ਦੇ ਪੁੱਤਰ ਸ਼ਕਮ ਨੇ ਨਗਰ ਦੇ ਫਾਟਕ ਕੋਲ ਜਾ ਕੇ ਮਨੁੱਖਾਂ ਨਾਲ ਇਹ ਗੱਲ ਕੀਤੀ, ");
INSERT INTO pan_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","ਇਹ ਮਨੁੱਖ ਸਾਡੇ ਨਾਲ ਮਿਲ-ਜੁਲ ਕੇ ਰਹਿਣਾ ਚਾਹੁੰਦੇ ਹਨ, ਇਸ ਲਈ ਓਹ ਇਸ ਦੇਸ਼ ਵਿੱਚ ਵੱਸਣ ਅਤੇ ਵਪਾਰ ਕਰਨ ਅਤੇ ਵੇਖੋ, ਇਹ ਦੇਸ਼ ਉਨ੍ਹਾਂ ਲਈ ਕਾਫੀ ਹੈ। ਉਨ੍ਹਾਂ ਦੀਆਂ ਧੀਆਂ ਅਸੀਂ ਆਪਣੇ ਲਈ ਅਤੇ ਆਪਣੇ ਪੁੱਤਰਾਂ ਲਈ ਵਿਆਹ ਲਵਾਂਗੇ ਅਤੇ ਆਪਣੀਆਂ ਧੀਆਂ ਉਨ੍ਹਾਂ ਨੂੰ ਦਿਆਂਗੇ। ");
INSERT INTO pan_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","ਪਰ ਇਹ ਮਨੁੱਖ ਸਿਰਫ਼ ਇਸ ਗੱਲ ਤੋਂ ਸਾਡੇ ਨਾਲ ਵੱਸਣ ਲਈ ਮੰਨਣਗੇ ਅਤੇ ਇੱਕ ਕੌਮ ਹੋਣਗੇ ਜੇਕਰ ਉਨ੍ਹਾਂ ਦੀ ਤਰ੍ਹਾਂ ਸਾਡੇ ਵੀ ਹਰ ਇੱਕ ਪੁਰਖ ਦੀ ਸੁੰਨਤ ਕਰਾਈ ਜਾਵੇ, ਜਿਵੇਂ ਉਨ੍ਹਾਂ ਦੀ ਸੁੰਨਤ ਕੀਤੀ ਗਈ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","ਭਲਾ, ਉਨ੍ਹਾਂ ਦੀਆਂ ਭੇਡਾਂ-ਬੱਕਰੀਆਂ, ਗਾਈਆਂ-ਬਲ਼ਦ, ਉਨ੍ਹਾਂ ਦਾ ਮਾਲ ਧਨ ਅਤੇ ਉਨ੍ਹਾਂ ਦੇ ਸਾਰੇ ਡੰਗਰ ਸਾਡੇ ਨਹੀਂ ਹੋ ਜਾਣਗੇ? ਅਸੀਂ ਸਿਰਫ਼ ਉਨ੍ਹਾਂ ਦੀ ਗੱਲ ਨੂੰ ਮੰਨੀਏ ਤਾਂ ਓਹ ਸਾਡੇ ਨਾਲ ਵੱਸਣਗੇ। ");
INSERT INTO pan_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","ਤਦ ਸਾਰਿਆਂ ਨੇ ਜਿਹੜੇ ਉਸ ਦੇ ਨਗਰ ਦੇ ਫਾਟਕ ਤੋਂ ਬਾਹਰ ਜਾਂਦੇ ਸਨ, ਹਮੋਰ ਅਤੇ ਉਹ ਦੇ ਪੁੱਤਰ ਸ਼ਕਮ ਦੀ ਗੱਲ ਸੁਣੀ ਅਤੇ ਉਨ੍ਹਾਂ ਸਾਰਿਆਂ ਵਿੱਚੋਂ ਜਿਹੜੇ ਉਸ ਦੇ ਨਗਰ ਦੇ ਫਾਟਕ ਤੋਂ ਬਾਹਰ ਜਾਂਦੇ ਸਨ ਹਰ ਇੱਕ ਪੁਰਖ ਦੀ ਸੁੰਨਤ ਕਰਾਈ ਗਈ। ");
INSERT INTO pan_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","ਤੀਜੇ ਦਿਨ ਅਜਿਹਾ ਹੋਇਆ ਕਿ ਜਦ ਓਹ ਦਰਦ ਵਿੱਚ ਸਨ ਤਾਂ ਯਾਕੂਬ ਦੇ ਦੋ ਪੁੱਤਰ ਸ਼ਿਮਓਨ ਅਤੇ ਲੇਵੀ, ਜੋ ਦੀਨਾਹ ਦੇ ਭਰਾ ਸਨ ਆਪਣੀਆਂ ਤਲਵਾਰਾਂ ਲੈ ਕੇ ਉਸ ਨਗਰ ਉੱਤੇ ਨਿਡਰ ਹੋ ਕੇ ਹਮਲਾ ਕੀਤਾ ਅਤੇ ਸਾਰੇ ਮਨੁੱਖਾਂ ਨੂੰ ਮਾਰ ਸੁੱਟਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","ਉਨ੍ਹਾਂ ਨੇ ਹਮੋਰ ਨੂੰ ਅਤੇ ਉਹ ਦੇ ਪੁੱਤਰ ਸ਼ਕਮ ਨੂੰ ਵੀ ਤਲਵਾਰ ਦੀ ਧਾਰ ਨਾਲ ਮਾਰ ਸੁੱਟਿਆ ਅਤੇ ਦੀਨਾਹ ਨੂੰ ਸ਼ਕਮ ਦੇ ਘਰੋਂ ਲੈ ਕੇ ਬਾਹਰ ਨਿੱਕਲ ਗਏ। ");
INSERT INTO pan_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","ਯਾਕੂਬ ਦੇ ਪੁੱਤਰਾਂ ਨੂੰ ਨਾਸ ਕਰਨ ਤੋਂ ਬਾਅਦ ਵੀ ਉਸ ਨਗਰ ਨੂੰ ਲੁੱਟ ਲਿਆ, ਕਿਉਂ ਜੋ ਉੱਥੇ ਹੀ ਉਨ੍ਹਾਂ ਦੀ ਭੈਣ ਨੂੰ ਭਰਿਸ਼ਟ ਕੀਤਾ ਗਿਆ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","ਉਨ੍ਹਾਂ ਨੇ ਭੇਡਾਂ-ਬੱਕਰੀਆਂ, ਗਾਈਆਂ-ਬਲ਼ਦਾਂ ਅਤੇ ਗਧਿਆਂ ਨੂੰ ਅਤੇ ਜੋ ਕੁਝ ਨਗਰ ਅਤੇ ਮੈਦਾਨ ਵਿੱਚ ਸੀ, ਸਭ ਕੁਝ ਲੈ ਲਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","ਉਹ ਉਨ੍ਹਾਂ ਦਾ ਸਾਰਾ ਧਨ ਅਤੇ ਉਨ੍ਹਾਂ ਦੇ ਸਾਰੇ ਬੱਚਿਆਂ ਅਤੇ ਇਸਤਰੀਆਂ ਨੂੰ ਫੜ੍ਹ ਕੇ ਲੈ ਗਏ ਅਤੇ ਜੋ ਕੁਝ ਘਰ ਵਿੱਚ ਸੀ, ਉਨ੍ਹਾਂ ਨੇ ਲੁੱਟ ਲਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","ਤਦ ਯਾਕੂਬ ਨੇ ਸ਼ਿਮਓਨ ਅਤੇ ਲੇਵੀ ਨੂੰ ਆਖਿਆ, ਤੁਸੀਂ ਮੈਨੂੰ ਸੰਕਟ ਵਿੱਚ ਪਾ ਦਿੱਤਾ ਅਤੇ ਇਸ ਦੇਸ਼ ਦੇ ਵਾਸੀਆਂ, ਕਨਾਨੀਆਂ ਅਤੇ ਫ਼ਰਿੱਜ਼ੀਆਂ ਦੇ ਸਾਹਮਣੇ ਮੇਰੀ ਬਦਨਾਮੀ ਕੀਤੀ ਹੈ, ਮੇਰੇ ਕੋਲ ਥੋੜ੍ਹੇ ਜਿਹੇ ਆਦਮੀ ਹਨ, ਇਸ ਲਈ ਹੁਣ ਓਹ ਮੇਰੇ ਵਿਰੁੱਧ ਇਕੱਠੇ ਹੋ ਕੇ ਮੈਨੂੰ ਮਾਰਨਗੇ ਅਤੇ ਮੇਰਾ ਅਤੇ ਮੇਰੇ ਘਰ ਦਾ ਵਿਨਾਸ਼ ਹੋ ਜਾਵੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","ਪਰ ਉਨ੍ਹਾਂ ਨੇ ਆਖਿਆ, ਭਲਾ, ਉਹ ਸਾਡੀ ਭੈਣ ਨਾਲ ਕੰਜਰੀ ਵਰਗਾ ਵਰਤਾਓ ਕਰਨ? ");
INSERT INTO pan_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","ਪਰਮੇਸ਼ੁਰ ਨੇ ਯਾਕੂਬ ਨੂੰ ਆਖਿਆ, ਉੱਠ ਅਤੇ ਬੈਤਏਲ ਨੂੰ ਜਾ ਅਤੇ ਉੱਥੇ ਹੀ ਵੱਸ ਅਤੇ ਉੱਥੇ ਪਰਮੇਸ਼ੁਰ ਲਈ ਇੱਕ ਜਗਵੇਦੀ ਬਣਾ, ਜਿਸ ਨੇ ਤੈਨੂੰ ਉਸ ਸਮੇਂ ਦਰਸ਼ਣ ਦਿੱਤਾ ਸੀ ਜਦ ਤੂੰ ਆਪਣੇ ਭਰਾ ਏਸਾਓ ਕੋਲੋਂ ਭੱਜਿਆ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","ਤਦ ਯਾਕੂਬ ਨੇ ਆਪਣੇ ਘਰਾਣੇ ਅਤੇ ਆਪਣੇ ਨਾਲ ਦੇ ਸਾਰੇ ਲੋਕਾਂ ਨੂੰ ਆਖਿਆ, ਤੁਸੀਂ ਪਰਾਏ ਦੇਵਤਿਆਂ ਨੂੰ ਜਿਹੜੇ ਤੁਹਾਡੇ ਵਿੱਚ ਹਨ, ਬਾਹਰ ਸੁੱਟ ਦਿਉ ਅਤੇ ਪਵਿੱਤਰ ਹੋਵੇ ਅਤੇ ਆਪਣੇ ਬਸਤਰ ਬਦਲ ਲਉ। ");
INSERT INTO pan_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","ਅਸੀਂ ਉੱਠ ਕੇ ਬੈਤਏਲ ਨੂੰ ਚੱਲੀਏ ਅਤੇ ਉੱਥੇ ਮੈਂ ਇੱਕ ਜਗਵੇਦੀ ਪਰਮੇਸ਼ੁਰ ਲਈ ਬਣਾਵਾਂਗਾ, ਜਿਸ ਨੇ ਮੇਰੀ ਬਿਪਤਾ ਦੇ ਦਿਨ ਮੈਨੂੰ ਉੱਤਰ ਦਿੱਤਾ ਅਤੇ ਜਿਸ ਰਸਤੇ ਤੇ ਮੈਂ ਚੱਲਦਾ ਸੀ, ਉਸ ਵਿੱਚ ਮੇਰੇ ਨਾਲ-ਨਾਲ ਰਿਹਾ। ");
INSERT INTO pan_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","ਤਦ ਉਨ੍ਹਾਂ ਨੇ ਸਾਰੇ ਪਰਾਏ ਦੇਵਤਿਆਂ ਨੂੰ ਜਿਹੜੇ ਉਨ੍ਹਾਂ ਦੇ ਹੱਥਾਂ ਵਿੱਚ ਸਨ ਅਤੇ ਕੰਨਾਂ ਦੇ ਕੁੰਡਲ ਯਾਕੂਬ ਨੂੰ ਦੇ ਦਿੱਤੇ, ਤਦ ਯਾਕੂਬ ਨੇ ਉਨ੍ਹਾਂ ਨੂੰ ਬਲੂਤ ਦੇ ਰੁੱਖ ਹੇਠ ਜਿਹੜਾ ਸ਼ਕਮ ਦੇ ਨੇੜੇ ਸੀ, ਦੱਬ ਦਿੱਤਾ। ");
INSERT INTO pan_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","ਤਦ ਓਹ ਉੱਥੋਂ ਤੁਰ ਪਏ ਅਤੇ ਉਨ੍ਹਾਂ ਦੇ ਚਾਰ-ਚੁਫ਼ੇਰੇ ਦੇ ਨਗਰਾਂ ਉੱਤੇ ਪਰਮੇਸ਼ੁਰ ਦਾ ਭੈਅ ਛਾ ਗਿਆ, ਇਸ ਲਈ ਉਨ੍ਹਾਂ ਨੇ ਯਾਕੂਬ ਦੇ ਪੁੱਤਰਾਂ ਦਾ ਪਿੱਛਾ ਨਾ ਕੀਤਾ। ");
INSERT INTO pan_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","ਯਾਕੂਬ ਅਤੇ ਉਸ ਦੇ ਨਾਲ ਦੇ ਸਾਰੇ ਲੋਕ ਲੂਜ਼ ਵਿੱਚ ਆਏ, ਜਿਹੜਾ ਕਨਾਨ ਦੇ ਦੇਸ਼ ਵਿੱਚ ਹੈ। ਇਹ ਹੀ ਬੈਤਏਲ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","ਉਸ ਨੇ ਉੱਥੇ ਇੱਕ ਜਗਵੇਦੀ ਬਣਾਈ ਅਤੇ ਉਸ ਸਥਾਨ ਦਾ ਨਾਮ ਏਲ ਬੈਤਏਲ ਰੱਖਿਆ ਕਿਉਂ ਜੋ ਉੱਥੇ ਹੀ ਪਰਮੇਸ਼ੁਰ ਨੇ ਉਸ ਨੂੰ ਦਰਸ਼ਣ ਦਿੱਤਾ ਸੀ, ਜਦ ਉਹ ਆਪਣੇ ਭਰਾ ਦੇ ਅੱਗੋਂ ਭੱਜਿਆ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","ਤਦ ਰਿਬਕਾਹ ਦੀ ਦਾਈ ਦਬੋਰਾਹ ਮਰ ਗਈ ਅਤੇ ਉਹ ਬੈਤਏਲ ਵਿੱਚ ਬਲੂਤ ਦੇ ਰੁੱਖ ਹੇਠਾਂ ਦਫ਼ਨਾਈ ਗਈ, ਤਾਂ ਉਸ ਦਾ ਨਾਮ ਅੱਲੋਨ-ਬਾਕੂਥ ਰੱਖਿਆ ਗਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","ਤਦ ਯਾਕੂਬ ਦੇ ਪਦਨ ਅਰਾਮ ਤੋਂ ਵਾਪਿਸ ਆਉਣ ਦੇ ਬਾਅਦ ਪਰਮੇਸ਼ੁਰ ਨੇ ਯਾਕੂਬ ਨੂੰ ਫੇਰ ਦਰਸ਼ਣ ਦਿੱਤਾ ਅਤੇ ਉਸ ਨੂੰ ਬਰਕਤ ਦਿੱਤੀ। ");
INSERT INTO pan_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","ਤਦ ਪਰਮੇਸ਼ੁਰ ਨੇ ਉਸ ਨੂੰ ਆਖਿਆ, ਤੇਰਾ ਨਾਮ ਯਾਕੂਬ ਹੈ, ਪਰ ਅੱਗੇ ਨੂੰ ਤੇਰਾ ਨਾਮ ਯਾਕੂਬ ਨਹੀਂ ਪੁਕਾਰਿਆ ਜਾਵੇਗਾ, ਸਗੋਂ ਤੇਰਾ ਨਾਮ ਇਸਰਾਏਲ ਹੋਵੇਗਾ। ਇਸ ਤਰ੍ਹਾਂ ਉਸ ਨੇ ਉਹ ਦਾ ਨਾਮ ਇਸਰਾਏਲ ਰੱਖਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","ਫਿਰ ਪਰਮੇਸ਼ੁਰ ਨੇ ਉਸ ਨੂੰ ਆਖਿਆ, ਮੈਂ ਸਰਬ ਸ਼ਕਤੀਮਾਨ ਪਰਮੇਸ਼ੁਰ ਹਾਂ। ਤੂੰ ਫਲ ਅਤੇ ਵੱਧ ਅਤੇ ਤੇਰੇ ਤੋਂ ਇੱਕ ਕੌਮ ਸਗੋਂ ਕੌਮਾਂ ਦੇ ਦਲ ਪੈਦਾ ਹੋਣਗੇ ਅਤੇ ਤੇਰੇ ਵੰਸ਼ ਤੋਂ ਰਾਜੇ ਨਿੱਕਲਣਗੇ। ");
INSERT INTO pan_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","ਅਤੇ ਉਹ ਦੇਸ਼ ਜਿਹੜਾ ਮੈਂ ਅਬਰਾਹਾਮ ਅਤੇ ਇਸਹਾਕ ਨੂੰ ਦਿੱਤਾ ਸੀ, ਮੈਂ ਤੈਨੂੰ ਦਿਆਂਗਾ ਅਤੇ ਤੇਰੇ ਪਿੱਛੋਂ ਤੇਰੇ ਵੰਸ਼ ਨੂੰ ਵੀ ਦਿਆਂਗਾ। ");
INSERT INTO pan_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","ਤਦ ਪਰਮੇਸ਼ੁਰ ਉਸ ਦੇ ਕੋਲੋਂ, ਉਸ ਸਥਾਨ ਤੋਂ ਜਿੱਥੇ ਉਹ ਉਸ ਦੇ ਨਾਲ ਗੱਲ ਕਰਦਾ ਸੀ, ਉਤਾਹਾਂ ਚਲਾ ਗਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","ਯਾਕੂਬ ਨੇ ਉਸ ਥਾਂ ਉੱਤੇ ਇੱਕ ਥੰਮ੍ਹ ਖੜ੍ਹਾ ਕੀਤਾ, ਜਿੱਥੇ ਪਰਮੇਸ਼ੁਰ ਨੇ ਉਹ ਦੇ ਨਾਲ ਗੱਲ ਕੀਤੀ, ਅਰਥਾਤ ਪੱਥਰ ਦਾ ਇੱਕ ਥੰਮ੍ਹ ਅਤੇ ਉਸ ਦੇ ਉੱਤੇ ਪੀਣ ਦੀ ਭੇਟ ਚੜ੍ਹਾਈ ਅਤੇ ਤੇਲ ਡੋਲ੍ਹਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","ਯਾਕੂਬ ਨੇ ਉਸ ਸਥਾਨ ਦਾ ਨਾਮ ਜਿੱਥੇ ਪਰਮੇਸ਼ੁਰ ਨੇ ਉਹ ਦੇ ਨਾਲ ਗੱਲ ਕੀਤੀ ਸੀ, ਬੈਤਏਲ ਰੱਖਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","ਫਿਰ ਉਹ ਬੈਤਏਲ ਤੋਂ ਤੁਰ ਪਏ, ਅਤੇ ਜਦ ਅਫਰਾਥ ਥੋੜ੍ਹੀ ਹੀ ਦੂਰ ਰਹਿੰਦਾ ਸੀ, ਤਾਂ ਰਾਖ਼ੇਲ ਨੂੰ ਜਣਨ ਦੀਆਂ ਪੀੜਾਂ ਹੋਣ ਲੱਗੀਆਂ ਅਤੇ ਉਸ ਨੂੰ ਜਣਨ ਦਾ ਸਖ਼ਤ ਕਸ਼ਟ ਹੋਇਆ। ");
INSERT INTO pan_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","ਜਦ ਉਹ ਜਣਨ ਦੇ ਕਸ਼ਟ ਵਿੱਚ ਸੀ ਤਾਂ ਦਾਈ ਨੇ ਉਸ ਨੂੰ ਆਖਿਆ, ਨਾ ਡਰ, ਕਿਉਂ ਜੋ ਹੁਣ ਵੀ ਤੇਰੇ ਇੱਕ ਪੁੱਤਰ ਹੀ ਜੰਮੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","ਤਦ ਅਜਿਹਾ ਹੋਇਆ ਕਿ ਜਦ ਉਸ ਦੇ ਪ੍ਰਾਣ ਨਿੱਕਲਣ ਨੂੰ ਸਨ ਅਤੇ ਉਹ ਮਰਨ ਵਾਲੀ ਸੀ, ਤਾਂ ਉਸ ਨੇ ਉਸ ਬੱਚੇ ਦਾ ਨਾਮ ਬਨ-ਓਨੀ ਰੱਖਿਆ, ਪਰ ਉਸ ਦੇ ਪਿਤਾ ਨੇ ਉਹ ਦਾ ਨਾਮ ਬਿਨਯਾਮੀਨ ਰੱਖਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","ਇਸ ਤਰ੍ਹਾਂ ਰਾਖ਼ੇਲ ਮਰ ਗਈ ਅਤੇ ਅਫਰਾਥ ਦੇ ਰਾਹ ਵਿੱਚ ਦਫ਼ਨਾਈ ਗਈ। ਇਹੋ ਹੀ ਬੈਤਲਹਮ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","ਯਾਕੂਬ ਨੇ ਉਸ ਦੀ ਕਬਰ ਉੱਤੇ ਇੱਕ ਥੰਮ੍ਹ ਖੜ੍ਹਾ ਕੀਤਾ ਅਤੇ ਰਾਖ਼ੇਲ ਦੀ ਕਬਰ ਦਾ ਥੰਮ੍ਹ ਅੱਜ ਤੱਕ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","ਫਿਰ ਇਸਰਾਏਲ ਤੁਰ ਪਿਆ ਅਤੇ ਆਪਣਾ ਤੰਬੂ ਏਦਰ ਦੇ ਬੁਰਜ ਦੇ ਪਰਲੇ ਪਾਸੇ ਖੜ੍ਹਾ ਕੀਤਾ। ");
INSERT INTO pan_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","ਜਦ ਇਸਰਾਏਲ ਉਸ ਦੇਸ਼ ਵਿੱਚ ਵੱਸਦਾ ਸੀ, ਤਾਂ ਰਊਬੇਨ ਜਾ ਕੇ ਆਪਣੇ ਪਿਤਾ ਦੀ ਰਖ਼ੈਲ ਬਿਲਹਾਹ ਦੇ ਨਾਲ ਲੇਟਿਆ ਅਤੇ ਇਸਰਾਏਲ ਨੂੰ ਇਸ ਦੀ ਖ਼ਬਰ ਹੋਈ। ");
INSERT INTO pan_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","ਯਾਕੂਬ ਦੇ ਬਾਰਾਂ ਪੁੱਤਰ ਸਨ। ਲੇਆਹ ਦੇ ਇਹ ਸਨ: ਯਾਕੂਬ ਦਾ ਪਹਿਲੌਠਾ ਰਊਬੇਨ, ਫਿਰ ਸ਼ਿਮਓਨ, ਲੇਵੀ, ਯਹੂਦਾਹ, ਯਿੱਸਾਕਾਰ ਅਤੇ ਜ਼ਬੂਲੁਨ। ");
INSERT INTO pan_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","ਰਾਖ਼ੇਲ ਦੇ ਪੁੱਤਰ ਯੂਸੁਫ਼ ਅਤੇ ਬਿਨਯਾਮੀਨ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","ਰਾਖ਼ੇਲ ਦੀ ਦਾਸੀ ਬਿਲਹਾਹ ਦੇ ਪੁੱਤਰ ਦਾਨ ਅਤੇ ਨਫ਼ਤਾਲੀ ਸਨ ");
INSERT INTO pan_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","ਅਤੇ ਲੇਆਹ ਦੀ ਦਾਸੀ ਜਿਲਫਾਹ ਦੇ ਪੁੱਤਰ ਗਾਦ ਅਤੇ ਆਸ਼ੇਰ ਸਨ। ਯਾਕੂਬ ਦੇ ਪੁੱਤਰ ਜਿਹੜੇ ਪਦਨ ਅਰਾਮ ਵਿੱਚ ਉਹ ਦੇ ਲਈ ਜੰਮੇ, ਇਹੋ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","ਯਾਕੂਬ ਆਪਣੇ ਪਿਤਾ ਇਸਹਾਕ ਕੋਲ ਮਮਰੇ ਵਿੱਚ ਜਿਹੜਾ ਕਿਰਯਥ-ਅਰਬਾ ਅਰਥਾਤ ਹਬਰੋਨ ਹੈ, ਆਇਆ ਜਿੱਥੇ ਅਬਰਾਹਾਮ ਅਤੇ ਇਸਹਾਕ ਪਰਦੇਸੀ ਹੋ ਕੇ ਰਹੇ ਸਨ ");
INSERT INTO pan_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","ਇਸਹਾਕ ਦੀ ਕੁੱਲ ਉਮਰ ਇੱਕ ਸੌ ਅੱਸੀ ਸਾਲ ਹੋਈ। ");
INSERT INTO pan_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","ਤਦ ਇਸਹਾਕ ਪ੍ਰਾਣ ਤਿਆਗ ਕੇ ਮਰ ਗਿਆ, ਉਹ ਚੰਗੇ ਬਿਰਧਪੁਣੇ ਵਿੱਚ ਅਰਥਾਤ ਪੂਰੇ ਬੁਢਾਪੇ ਵਿੱਚ ਆਪਣੇ ਲੋਕਾਂ ਵਿੱਚ ਜਾ ਮਿਲਿਆ ਅਤੇ ਉਸ ਦੇ ਪੁੱਤਰਾਂ ਏਸਾਓ ਅਤੇ ਯਾਕੂਬ ਨੇ ਉਸ ਨੂੰ ਦਫ਼ਨਾ ਦਿੱਤਾ। ");
INSERT INTO pan_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","ਏਸਾਓ ਅਰਥਾਤ ਅਦੋਮ ਦੀ ਵੰਸ਼ਾਵਲੀ ਇਹ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","ਏਸਾਓ ਕਨਾਨੀਆਂ ਦੀਆਂ ਧੀਆਂ ਵਿੱਚੋਂ ਹਿੱਤੀ ਏਲੋਨ ਦੀ ਧੀ ਆਦਾਹ ਨੂੰ ਵਿਆਹ ਲਿਆਇਆ ਅਤੇ ਆਹਾਲੀਬਾਮਾਹ ਨੂੰ, ਜਿਹੜੀ ਅਨਾਹ ਦੀ ਧੀ ਅਤੇ ਸਿਬਓਨ ਹਿੱਵੀ ਦੀ ਦੋਹਤੀ ਸੀ ");
INSERT INTO pan_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","ਅਤੇ ਬਾਸਮਥ ਨੂੰ ਜਿਹੜੀ ਇਸਮਾਏਲ ਦੀ ਧੀ ਸੀ ਅਤੇ ਨਬਾਯੋਤ ਦੀ ਭੈਣ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","ਆਦਾਹ ਨੇ ਏਸਾਓ ਲਈ ਅਲੀਫਾਜ਼ ਨੂੰ ਅਤੇ ਬਾਸਮਥ ਨੇ ਰਊਏਲ ਨੂੰ ਜਨਮ ਦਿੱਤਾ ");
INSERT INTO pan_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","ਅਤੇ ਆਹਾਲੀਬਾਮਾਹ ਨੇ ਯਊਸ਼ ਅਤੇ ਯਾਲਾਮ ਅਤੇ ਕੋਰਹ ਨੂੰ ਜਨਮ ਦਿੱਤਾ, ਇਹ ਏਸਾਓ ਦੇ ਪੁੱਤਰ ਸਨ, ਜਿਹੜੇ ਕਨਾਨ ਦੇਸ਼ ਵਿੱਚ ਪੈਦਾ ਹੋਏ। ");
INSERT INTO pan_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","ਤਦ ਏਸਾਓ ਨੇ ਆਪਣੀਆਂ ਪਤਨੀਆਂ, ਆਪਣੇ ਪੁੱਤਰ-ਧੀਆਂ ਅਤੇ ਆਪਣੇ ਘਰ ਦੇ ਸਾਰੇ ਪ੍ਰਾਣੀਆਂ ਨੂੰ, ਆਪਣੇ ਸਾਰੇ ਵੱਗਾਂ, ਸਾਰੇ ਪਸ਼ੂਆਂ ਅਤੇ ਸਾਰੀ ਪੂੰਜੀ ਨੂੰ ਜੋ ਉਸ ਕਨਾਨ ਦੇਸ਼ ਵਿੱਚ ਕਮਾਈ ਸੀ, ਲੈ ਕੇ ਆਪਣੇ ਭਰਾ ਯਾਕੂਬ ਦੇ ਕੋਲੋਂ ਕਿਸੇ ਹੋਰ ਦੇਸ਼ ਵੱਲ ਚਲਾ ਗਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","ਕਿਉਂ ਜੋ ਉਨ੍ਹਾਂ ਦਾ ਮਾਲ ਧਨ ਐਨਾ ਸੀ ਕਿ ਉਹ ਇਕੱਠੇ ਨਹੀਂ ਰਹਿ ਸਕਦੇ ਸਨ, ਪਰ ਉਹ ਸਥਾਨ ਜਿਸ ਵਿੱਚ ਉਹ ਮੁਸਾਫ਼ਰ ਸਨ ਉਨ੍ਹਾਂ ਦੇ ਪਸ਼ੂਆਂ ਦੀ ਬਹੁਤਾਇਤ ਦੇ ਕਾਰਨ, ਉਹ ਉੱਥੇ ਰਹਿ ਨਾ ਸਕੇ। ");
INSERT INTO pan_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","ਏਸਾਓ ਸੇਈਰ ਦੇ ਪਰਬਤ ਵਿੱਚ ਰਹਿਣ ਲੱਗਾ, ਇਹੋ ਹੀ ਅਦੋਮ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","ਇਹ ਏਸਾਓ ਦੀ ਵੰਸ਼ਾਵਲੀ ਹੈ, ਜਿਹੜਾ ਅਦੋਮੀਆਂ ਦਾ ਪਿਤਾ ਸੇਈਰ ਦੇ ਪਰਬਤ ਵਿੱਚ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","ਸੋ ਏਸਾਓ ਦੇ ਪੁੱਤਰਾਂ ਦੇ ਨਾਮ ਇਹ ਸਨ, ਅਲੀਫਾਜ਼ ਏਸਾਓ ਦੀ ਪਤਨੀ ਆਦਾਹ ਦਾ ਪੁੱਤਰ ਅਤੇ ਰਊਏਲ ਏਸਾਓ ਦੀ ਪਤਨੀ ਬਾਸਮਥ ਦਾ ਪੁੱਤਰ ");
INSERT INTO pan_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","ਅਤੇ ਅਲੀਫਾਜ਼ ਦੇ ਪੁੱਤਰ ਤੇਮਾਨ, ਓਮਾਰ, ਸਫੋ, ਗਾਤਾਮ ਅਤੇ ਕਨਜ਼ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","ਤਿਮਨਾ ਏਸਾਓ ਦੇ ਪੁੱਤਰ ਅਲੀਫਾਜ਼ ਦੀ ਰਖ਼ੈਲ ਸੀ, ਉਸ ਨੇ ਅਲੀਫਾਜ਼ ਲਈ ਅਮਾਲੇਕ ਨੂੰ ਜਨਮ ਦਿੱਤਾ, ਇਹ ਏਸਾਓ ਦੀ ਪਤਨੀ ਆਦਾਹ ਦੇ ਪੁੱਤਰ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","ਰਊਏਲ ਦੇ ਪੁੱਤਰ ਇਹ ਸਨ ਅਰਥਾਤ ਨਹਥ, ਜ਼ਰਹ, ਸ਼ੰਮਾਹ ਅਤੇ ਮਿੱਜ਼ਾਹ। ਇਹ ਏਸਾਓ ਦੀ ਪਤਨੀ ਬਾਸਮਥ ਦੇ ਪੁੱਤਰ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","ਆਹਾਲੀਬਾਮਾਹ ਦੇ ਪੁੱਤਰ ਇਹ ਸਨ, ਜਿਹੜੀ ਏਸਾਓ ਦੀ ਪਤਨੀ, ਅਨਾਹ ਦੀ ਧੀ ਅਤੇ ਸਿਬਓਨ ਦੀ ਦੋਹਤੀ ਸੀ। ਉਸ ਨੇ ਏਸਾਓ ਲਈ ਯਊਸ਼, ਯਾਲਾਮ ਅਤੇ ਕੋਰਹ ਨੂੰ ਜਨਮ ਦਿੱਤਾ। ");
INSERT INTO pan_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","ਇਹ ਏਸਾਓ ਦੇ ਪੁੱਤਰਾਂ ਵਿੱਚੋਂ ਮੁਖੀਏ ਸਨ: ਏਸਾਓ ਦੇ ਪਹਿਲੌਠੇ ਪੁੱਤਰ ਅਲੀਫਾਜ਼ ਦੇ ਵੰਸ਼ ਵਿੱਚੋਂ ਤੇਮਾਨ, ਓਮਾਰ, ਸਫੋ, ਕਨਜ਼, ");
INSERT INTO pan_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","ਕੋਰਹ, ਗਾਤਾਮ ਅਤੇ ਅਮਾਲੇਕ, ਇਹ ਸਾਰੇ ਮੁਖੀਏ ਅਲੀਫਾਜ਼ ਦੇ ਵੰਸ਼ ਤੋਂ ਅਦੋਮ ਦੇਸ਼ ਵਿੱਚ ਹੋਏ। ਇਹ ਆਦਾਹ ਦੇ ਪੁੱਤਰ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","ਏਸਾਓ ਦੇ ਪੁੱਤਰ ਰਊਏਲ ਦੇ ਵੰਸ਼ ਵਿੱਚੋਂ ਇਹ ਮੁਖੀਏ ਸਨ: ਨਹਥ, ਜ਼ਰਹ, ਸ਼ੰਮਾਹ ਅਤੇ ਮਿੱਜ਼ਾਹ, ਇਹ ਮੁਖੀਏ ਰਊਏਲ ਤੋਂ ਅਦੋਮ ਦੇ ਦੇਸ਼ ਵਿੱਚ ਹੋਏ ਅਤੇ ਇਹ ਏਸਾਓ ਦੀ ਪਤਨੀ ਬਾਸਮਥ ਦੇ ਪੁੱਤਰ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","ਏਸਾਓ ਦੀ ਪਤਨੀ ਆਹਾਲੀਬਾਮਾਹ ਦੇ ਪੁੱਤਰ ਇਹ ਸਨ: ਯਊਸ਼, ਯਾਲਾਮ ਅਤੇ ਕੋਰਹ, ਇਹ ਮੁਖੀਏ ਏਸਾਓ ਦੀ ਪਤਨੀ ਅਤੇ ਅਨਾਹ ਦੀ ਧੀ ਆਹਾਲੀਬਾਮਾਹ ਦੇ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","ਇਹ ਏਸਾਓ ਅਰਥਾਤ ਅਦੋਮ ਦੇ ਪੁੱਤਰ ਸਨ ਅਤੇ ਇਹ ਹੀ ਉਨ੍ਹਾਂ ਦੇ ਮੁਖੀਏ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","ਸੇਈਰ ਹੋਰੀ ਦੇ ਪੁੱਤਰ ਜਿਹੜੇ ਉਸ ਦੇਸ਼ ਵਿੱਚ ਵੱਸਦੇ ਸਨ, ਇਹ ਸਨ: ਲੋਤਾਨ, ਸ਼ੋਬਾਲ, ਸਿਬਓਨ, ਅਨਾਹ, ");
INSERT INTO pan_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","ਦੀਸ਼ੋਨ, ਏਸਰ ਅਤੇ ਦੀਸ਼ਾਨ। ਅਦੋਮ ਦੇਸ਼ ਵਿੱਚ ਸੇਈਰ ਦੇ ਹੋਰੀ ਜਾਤੀ ਵਿੱਚੋਂ ਇਹ ਹੀ ਮੁਖੀਏ ਹੋਏ। ");
INSERT INTO pan_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","ਲੋਤਾਨ ਦੇ ਪੁੱਤਰ ਹੋਰੀ ਅਤੇ ਹੋਮਾਮ ਸਨ ਅਤੇ ਤਿਮਨਾ ਲੋਤਾਨ ਦੀ ਭੈਣ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","ਸ਼ੋਬਾਲ ਦੇ ਪੁੱਤਰ ਇਹ ਸਨ: ਅਲਵਾਨ, ਮਾਨਹਥ, ਏਬਾਲ, ਸ਼ਫੋ ਅਤੇ ਓਨਾਮ। ");
INSERT INTO pan_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","ਸਿਬਓਨ ਦੇ ਪੁੱਤਰ ਇਹ ਸਨ: ਅੱਯਾਹ ਅਤੇ ਅਨਾਹ। ਇਹ ਉਹ ਅਨਾਹ ਹੈ, ਜਿਸ ਨੂੰ ਆਪਣੇ ਪਿਤਾ ਸਿਬਓਨ ਦੇ ਗਧੇ ਚਾਰਦਿਆਂ ਉਜਾੜ ਵਿੱਚ ਗਰਮ ਪਾਣੀ ਦੇ ਸੋਤੇ ਲੱਭੇ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","ਅਨਾਹ ਦਾ ਪੁੱਤਰ ਦੀਸ਼ੋਨ ਸੀ ਅਤੇ ਉਸ ਦੀ ਧੀ ਆਹਾਲੀਬਾਮਾਹ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","ਇਹ ਦੀਸ਼ੋਨ ਦੇ ਪੁੱਤਰ ਸਨ: ਹਮਦਾਨ, ਅਸ਼ਬਾਨ, ਯਿਥਰਾਨ ਅਤੇ ਕਰਾਨ। ");
INSERT INTO pan_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","ਏਸਰ ਦੇ ਪੁੱਤਰ ਇਹ ਸਨ: ਬਿਲਹਾਨ, ਜਾਵਾਨ ਅਤੇ ਅਕਾਨ। ");
INSERT INTO pan_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","ਦੀਸ਼ਾਨ ਦੇ ਪੁੱਤਰ ਊਸ ਅਤੇ ਅਰਾਨ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","ਹੋਰੀਆਂ ਦੇ ਮੁਖੀਏ ਇਹ ਸਨ: ਲੋਤਾਨ, ਸ਼ੋਬਾਲ, ਸਿਬਓਨ, ਅਨਾਹ, ");
INSERT INTO pan_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","ਦੀਸ਼ੋਨ, ਏਸਰ ਅਤੇ ਦੀਸ਼ਾਨ, ਇਹ ਹੋਰੀਆਂ ਦੇ ਮੁਖੀਏ ਸਨ ਜੋ ਸੇਈਰ ਦੇ ਦੇਸ਼ ਵਿੱਚ ਹੋਏ। ");
INSERT INTO pan_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","ਇਹ ਉਹ ਰਾਜੇ ਹਨ ਜਿਹੜੇ ਅਦੋਮ ਵਿੱਚ ਇਸਰਾਏਲੀਆਂ ਦੇ ਰਾਜਿਆਂ ਤੋਂ ਪਹਿਲਾਂ ਰਾਜ ਕਰਦੇ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","ਬਓਰ ਦਾ ਪੁੱਤਰ ਬਲਾ ਅਦੋਮ ਉੱਤੇ ਰਾਜ ਕਰਦਾ ਸੀ ਅਤੇ ਉਸ ਦੇ ਨਗਰ ਦਾ ਨਾਮ ਦਿਨਹਾਬਾਹ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","ਬਲਾ ਮਰ ਗਿਆ ਅਤੇ ਜ਼ਰਹ ਦਾ ਪੁੱਤਰ ਯੋਬਾਬ ਜਿਹੜਾ ਬਾਸਰਾਹ ਦਾ ਵਾਸੀ ਸੀ, ਉਹ ਦੇ ਥਾਂ ਰਾਜ ਕਰਨ ਲੱਗਾ। ");
INSERT INTO pan_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","ਯੋਬਾਬ ਮਰ ਗਿਆ ਤਾਂ ਤੇਮਾਨੀਆਂ ਦੇ ਦੇਸ਼ ਤੋਂ ਹੂਸ਼ਾਮ ਉਸ ਦੇ ਸਥਾਨ ਤੇ ਰਾਜ ਕਰਨ ਲੱਗਾ। ");
INSERT INTO pan_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","ਹੂਸ਼ਾਮ ਮਰ ਗਿਆ ਤਾਂ ਉਸ ਦੇ ਸਥਾਨ ਤੇ ਬਦਦ ਦਾ ਪੁੱਤਰ ਹਦਦ, ਜਿਸ ਨੇ ਮੋਆਬ ਦੇ ਮੈਦਾਨ ਵਿੱਚ ਮਿਦਯਾਨੀਆਂ ਨੂੰ ਮਾਰਿਆ ਸੀ, ਰਾਜ ਕਰਨ ਲੱਗਾ ਅਤੇ ਉਸ ਦੇ ਨਗਰ ਦਾ ਨਾਮ ਅਵੀਤ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","ਹਦਦ ਮਰ ਗਿਆ ਤਾਂ ਉਸ ਦੇ ਸਥਾਨ ਤੇ ਮਸਰੇਕਾਹ ਵਾਸੀ ਸਮਲਾਹ ਰਾਜ ਕਰਨ ਲੱਗਾ। ");
INSERT INTO pan_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","ਸਮਲਾਹ ਮਰ ਗਿਆ ਤਾਂ ਉਸ ਦੇ ਸਥਾਨ ਤੇ ਸ਼ਾਊਲ ਰਾਜ ਕਰਨ ਲੱਗਾ ਜਿਹੜਾ ਦਰਿਆ ਦੇ ਉੱਪਰ ਦੇ ਰਹੋਬੋਥ ਨਗਰ ਦਾ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","ਸ਼ਾਊਲ ਮਰ ਗਿਆ ਅਤੇ ਉਸ ਦੇ ਸਥਾਨ ਤੇ ਅਕਬੋਰ ਦਾ ਪੁੱਤਰ ਬਆਲਹਾਨਾਨ ਰਾਜ ਕਰਨ ਲੱਗਾ। ");
INSERT INTO pan_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","ਬਆਲਹਾਨਾਨ, ਅਕਬੋਰ ਦਾ ਪੁੱਤਰ ਮਰ ਗਿਆ ਅਤੇ ਉਸ ਦੇ ਸਥਾਨ ਤੇ ਹਦਦ ਰਾਜ ਕਰਨ ਲੱਗਾ ਅਤੇ ਉਸ ਦੇ ਸ਼ਹਿਰ ਦਾ ਨਾਮ ਪਾਊ ਸੀ ਅਤੇ ਉਸ ਦੀ ਪਤਨੀ ਦਾ ਨਾਮ ਮਹੇਤਾਬਏਲ ਸੀ, ਜਿਹੜੀ ਮਤਰੇਦ ਦੀ ਧੀ ਅਤੇ ਮੇਜ਼ਾਹਾਬ ਦੀ ਦੋਹਤੀ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","ਏਸਾਓ ਦੇ ਮੁਖੀਆਂ ਦੇ ਨਾਮ ਉਨ੍ਹਾਂ ਦੇ ਘਰਾਣਿਆਂ ਅਤੇ ਸਥਾਨਾਂ ਦੇ ਨਾਮਾਂ ਅਨੁਸਾਰ ਇਹ ਸਨ, ਤਿਮਨਾ, ਅਲਵਾਹ, ਯਥੇਥ, ");
INSERT INTO pan_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","ਆਹਾਲੀਬਾਮਾਹ, ਏਲਾਹ, ਪੀਨੋਨ, ");
INSERT INTO pan_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","ਕਨਜ਼, ਤੇਮਾਨ, ਮਿਬਸਾਰ ");
INSERT INTO pan_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","ਮਗਦੀਏਲ ਅਤੇ ਈਰਾਮ, ਇਹ ਅਦੋਮ ਦੇ ਮੁਖੀਏ ਸਨ ਜੋ ਆਪਣੇ ਕਬਜ਼ੇ ਦੇ ਦੇਸ਼ ਦੀਆਂ ਬਸਤੀਆਂ ਅਨੁਸਾਰ ਹੋਏ। ਏਸਾਓ ਅਦੋਮੀਆਂ ਦਾ ਪੁਰਖਾ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","ਯਾਕੂਬ ਆਪਣੇ ਪਿਤਾ ਦੀ ਮੁਸਾਫ਼ਰੀ ਦੇ ਦੇਸ਼ ਵਿੱਚ ਅਰਥਾਤ ਕਨਾਨ ਦੇ ਦੇਸ਼ ਵਿੱਚ ਵੱਸ ਗਿਆ। ਇਹ ਯਾਕੂਬ ਦੀ ਵੰਸ਼ਾਵਲੀ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","ਜਦ ਯੂਸੁਫ਼ ਸਤਾਰਾਂ ਸਾਲਾਂ ਦਾ ਸੀ, ਉਹ ਆਪਣੇ ਭਰਾਵਾਂ ਦੇ ਨਾਲ ਇੱਜੜ ਚਾਰਦਾ ਸੀ ਅਤੇ ਉਹ ਜਵਾਨ ਆਪਣੇ ਪਿਤਾ ਦੀਆਂ ਪਤਨੀਆਂ ਬਿਲਹਾਹ ਅਤੇ ਜਿਲਫਾਹ ਦੇ ਪੁੱਤਰਾਂ ਨਾਲ ਰਹਿੰਦਾ ਸੀ ਅਤੇ ਯੂਸੁਫ਼ ਉਨ੍ਹਾਂ ਦੀਆਂ ਬੁਰੀਆਂ ਗੱਲਾਂ ਆਪਣੇ ਪਿਤਾ ਨੂੰ ਆ ਕੇ ਦੱਸਦਾ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","ਇਸਰਾਏਲ ਯੂਸੁਫ਼ ਨੂੰ ਆਪਣੇ ਸਾਰੇ ਪੁੱਤਰਾਂ ਨਾਲੋਂ ਵੱਧ ਪਿਆਰ ਕਰਦਾ ਸੀ ਕਿਉਂ ਜੋ ਉਹ ਉਸ ਦੀ ਬਿਰਧ ਅਵਸਥਾ ਦਾ ਪੁੱਤਰ ਸੀ ਅਤੇ ਉਸ ਨੇ ਉਹ ਦੇ ਲਈ ਇੱਕ ਰੰਗ-ਬਿਰੰਗਾ ਚੋਲਾ ਬਣਾਇਆ। ");
INSERT INTO pan_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","ਜਦ ਉਸ ਦੇ ਭਰਾਵਾਂ ਨੇ ਵੇਖਿਆ ਕਿ ਉਨ੍ਹਾਂ ਦਾ ਪਿਤਾ ਉਹ ਨੂੰ ਉਹ ਦੇ ਸਾਰੇ ਭਰਾਵਾਂ ਨਾਲੋਂ ਵੱਧ ਪਿਆਰ ਕਰਦਾ ਹੈ ਤਾਂ ਉਹ ਉਸ ਦੇ ਨਾਲ ਵੈਰ ਰੱਖਣ ਲੱਗੇ ਅਤੇ ਉਹ ਦੇ ਨਾਲ ਸ਼ਾਂਤੀ ਨਾਲ ਗੱਲ ਨਹੀਂ ਕਰਦੇ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","ਫੇਰ ਯੂਸੁਫ਼ ਨੇ ਇਹ ਵੇਖਿਆ ਅਤੇ ਆਪਣੇ ਭਰਾਵਾਂ ਨੂੰ ਦੱਸਿਆ ਤਾਂ ਉਹ ਉਸ ਦੇ ਨਾਲ ਹੋਰ ਵੈਰ ਰੱਖਣ ਲੱਗੇ। ");
INSERT INTO pan_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","ਉਸ ਨੇ ਉਨ੍ਹਾਂ ਨੂੰ ਆਖਿਆ ਕਿ ਜਿਹੜਾ ਸੁਫ਼ਨਾ ਮੈਂ ਵੇਖਿਆ ਉਹ ਸੁਣੋ। ");
INSERT INTO pan_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","ਵੇਖੋ, ਅਸੀਂ ਖੇਤ ਦੇ ਵਿੱਚ ਪੂਲੇ ਬੰਨ੍ਹ ਰਹੇ ਸੀ ਅਤੇ ਵੇਖੋ, ਮੇਰਾ ਪੂਲਾ ਉੱਠ ਖੜ੍ਹਾ ਹੋਇਆ ਅਤੇ ਵੇਖੋ, ਤੁਹਾਡੇ ਪੂਲਿਆਂ ਨੇ ਉਸ ਦੇ ਆਲੇ-ਦੁਆਲੇ ਆ ਕੇ ਮੇਰੇ ਪੂਲੇ ਨੂੰ ਮੱਥਾ ਟੇਕਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","ਫਿਰ ਉਹ ਦੇ ਭਰਾਵਾਂ ਨੇ ਉਸ ਨੂੰ ਆਖਿਆ, ਕੀ ਤੂੰ ਸੱਚ-ਮੁੱਚ ਸਾਡੇ ਉੱਤੇ ਰਾਜ ਕਰੇਂਗਾ ਅਤੇ ਸਾਡੇ ਉੱਤੇ ਹਕੂਮਤ ਕਰੇਂਗਾ? ਤਦ ਉਹ ਉਸ ਦੇ ਨਾਲ ਉਹ ਦੇ ਸੁਫ਼ਨੇ ਅਤੇ ਉਹ ਦੀਆਂ ਗੱਲਾਂ ਦੇ ਕਾਰਨ ਹੋਰ ਵੀ ਵੈਰ ਰੱਖਣ ਲੱਗ ਪਏ। ");
INSERT INTO pan_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","ਫਿਰ ਉਸ ਨੇ ਇੱਕ ਹੋਰ ਸੁਫ਼ਨਾ ਵੇਖਿਆ ਅਤੇ ਆਪਣੇ ਭਰਾਵਾਂ ਨੂੰ ਦੱਸਿਆ ਅਤੇ ਆਖਿਆ, ਮੈਂ ਇੱਕ ਹੋਰ ਸੁਫ਼ਨਾ ਵੇਖਿਆ ਅਤੇ ਵੇਖੋ, ਸੂਰਜ, ਚੰਦ ਅਤੇ ਗਿਆਰ੍ਹਾਂ ਤਾਰਿਆਂ ਨੇ ਮੇਰੇ ਅੱਗੇ ਮੱਥਾ ਟੇਕਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","ਉਸ ਨੇ ਇਹ ਸੁਫ਼ਨਾ ਆਪਣੇ ਪਿਤਾ ਅਤੇ ਆਪਣੇ ਭਰਾਵਾਂ ਨੂੰ ਦੱਸਿਆ ਅਤੇ ਉਹ ਦੇ ਪਿਤਾ ਨੇ ਉਸ ਨੂੰ ਝਿੜਕਿਆ ਅਤੇ ਉਹ ਨੂੰ ਆਖਿਆ, ਇਹ ਕਿਹੋ ਜਿਹਾ ਸੁਫ਼ਨਾ ਹੈ, ਜਿਹੜਾ ਤੂੰ ਵੇਖਿਆ? ਕੀ ਸੱਚ-ਮੁੱਚ ਮੈਂ ਅਤੇ ਤੇਰੀ ਮਾਤਾ ਅਤੇ ਤੇਰੇ ਭਰਾ ਆ ਕੇ ਤੇਰੇ ਅੱਗੇ ਧਰਤੀ ਤੱਕ ਮੱਥਾ ਟੇਕਾਂਗੇ? ");
INSERT INTO pan_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","ਤਦ ਉਹ ਦੇ ਭਰਾਵਾਂ ਨੂੰ ਈਰਖਾ ਹੋਈ ਅਤੇ ਉਹ ਦੇ ਪਿਤਾ ਨੇ ਇਸ ਗੱਲ ਨੂੰ ਯਾਦ ਰੱਖਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","ਫੇਰ ਉਸ ਦੇ ਭਰਾ ਆਪਣੇ ਪਿਤਾ ਦੀਆਂ ਭੇਡਾਂ ਚਾਰਨ ਲਈ ਸ਼ਕਮ ਨੂੰ ਗਏ। ");
INSERT INTO pan_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","ਅਤੇ ਇਸਰਾਏਲ ਨੇ ਯੂਸੁਫ਼ ਨੂੰ ਆਖਿਆ, ਕੀ ਤੇਰੇ ਭਰਾ ਸ਼ਕਮ ਵਿੱਚ ਭੇਡਾਂ ਨਹੀਂ ਚਾਰਦੇ ਹਨ? ਜਾ, ਮੈਂ ਤੈਨੂੰ ਉਨ੍ਹਾਂ ਦੇ ਕੋਲ ਭੇਜਦਾ ਹਾਂ। ਤਦ ਉਸ ਨੇ ਆਖਿਆ, ਮੈਂ ਹਾਜ਼ਰ ਹਾਂ। ");
INSERT INTO pan_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","ਉਸ ਨੇ ਉਹ ਨੂੰ ਆਖਿਆ, ਜਾ ਆਪਣੇ ਭਰਾਵਾਂ ਅਤੇ ਇੱਜੜਾਂ ਦੀ ਸੁੱਖ-ਸਾਂਦ ਦਾ ਪਤਾ ਲੈ ਅਤੇ ਮੈਨੂੰ ਵਾਪਸ ਆ ਕੇ ਖ਼ਬਰ ਦੇ। ਸੋ ਉਸ ਨੇ ਉਹ ਨੂੰ ਹਬਰੋਨ ਦੀ ਘਾਟੀ ਤੋਂ ਭੇਜਿਆ ਅਤੇ ਉਹ ਸ਼ਕਮ ਨੂੰ ਆਇਆ। ");
INSERT INTO pan_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","ਅਤੇ ਕੋਈ ਮਨੁੱਖ ਉਸ ਨੂੰ ਮਿਲਿਆ ਅਤੇ ਵੇਖੋ, ਉਹ ਮੈਦਾਨ ਵਿੱਚ ਭਟਕਦਾ ਫਿਰਦਾ ਸੀ ਸੋ ਉਸ ਮਨੁੱਖ ਨੇ ਉਸ ਤੋਂ ਪੁੱਛਿਆ, ਤੂੰ ਕੀ ਲੱਭਦਾ ਹੈਂ? ");
INSERT INTO pan_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","ਤਦ ਉਸ ਨੇ ਆਖਿਆ, ਮੈਂ ਆਪਣੇ ਭਰਾਵਾਂ ਨੂੰ ਲੱਭਦਾ ਹਾਂ। ਕਿਰਪਾ ਮੈਨੂੰ ਦੱਸੋ ਕਿ ਉਹ ਆਪਣੀਆਂ ਭੇਡਾਂ ਕਿੱਥੇ ਚਾਰਦੇ ਹਨ? ");
INSERT INTO pan_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","ਫੇਰ ਉਸ ਮਨੁੱਖ ਨੇ ਆਖਿਆ, ਉਹ ਇੱਥੋਂ ਚਲੇ ਗਏ ਹਨ ਕਿਉਂ ਜੋ ਮੈਂ ਉਨ੍ਹਾਂ ਨੂੰ ਇਹ ਆਖਦੇ ਸੁਣਿਆ ਕਿ ਅਸੀਂ ਦੋਥਾਨ ਨੂੰ ਚੱਲੀਏ। ਸੋ ਯੂਸੁਫ਼ ਆਪਣੇ ਭਰਾਵਾਂ ਦੇ ਮਗਰ ਚੱਲ ਪਿਆ ਅਤੇ ਉਨ੍ਹਾਂ ਨੂੰ ਦੋਥਾਨ ਵਿੱਚ ਜਾ ਲੱਭਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","ਤਦ ਉਨ੍ਹਾਂ ਨੇ ਉਸ ਨੂੰ ਦੂਰੋਂ ਵੇਖਿਆ ਅਤੇ ਉਸ ਦੇ ਨੇੜੇ ਆਉਣ ਤੋਂ ਪਹਿਲਾਂ ਉਨ੍ਹਾਂ ਨੇ ਉਸ ਨੂੰ ਮਾਰ ਸੁੱਟਣ ਦੀ ਯੋਜਨਾ ਬਣਾਈ ");
INSERT INTO pan_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","ਅਤੇ ਇੱਕ ਦੂਜੇ ਨੂੰ ਆਖਿਆ, ਵੇਖੋ, ਉਹ ਸੁਫ਼ਨੇ ਵੇਖਣ ਵਾਲਾ ਆ ਰਿਹਾ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","ਹੁਣ ਆਓ ਅਸੀਂ ਇਸ ਨੂੰ ਮਾਰ ਸੁੱਟੀਏ ਅਤੇ ਕਿਸੇ ਟੋਏ ਵਿੱਚ ਸੁੱਟ ਦੇਈਏ ਅਤੇ ਆਖੀਏ ਕਿਸੇ ਬੁਰੇ ਜਾਨਵਰ ਨੇ ਉਸ ਨੂੰ ਪਾੜ ਸੁੱਟਿਆ ਹੈ ਤਾਂ ਅਸੀਂ ਵੇਖਾਂਗੇ ਕਿ ਉਸ ਦੇ ਸੁਫ਼ਨਿਆਂ ਦਾ ਕੀ ਬਣੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","ਪਰ ਰਊਬੇਨ ਨੇ ਸੁਣ ਕੇ ਉਸ ਨੂੰ ਉਨ੍ਹਾਂ ਦੇ ਹੱਥੋਂ ਬਚਾਇਆ ਅਤੇ ਆਖਿਆ, ਅਸੀਂ ਇਸ ਨੂੰ ਜਾਨੋਂ ਨਾ ਮਾਰੀਏ। ");
INSERT INTO pan_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","ਰਊਬੇਨ ਨੇ ਉਨ੍ਹਾਂ ਨੂੰ ਆਖਿਆ, ਖੂਨ ਨਾ ਕਰੋ, ਉਸ ਨੂੰ ਇਸ ਟੋਏ ਵਿੱਚ ਸੁੱਟ ਦਿਓ ਜਿਹੜਾ ਉਜਾੜ ਵਿੱਚ ਹੈ ਪਰ ਉਸ ਨੂੰ ਹੱਥ ਨਾ ਲਾਓ ਤਾਂ ਜੋ ਉਹ ਉਸ ਨੂੰ ਉਨ੍ਹਾਂ ਦੇ ਹੱਥੋਂ ਬਚਾ ਕੇ ਉਹ ਦੇ ਪਿਤਾ ਕੋਲ ਪਹੁੰਚਾ ਦੇਵੇ। ");
INSERT INTO pan_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","ਜਦ ਯੂਸੁਫ਼ ਆਪਣੇ ਭਰਾਵਾਂ ਦੇ ਕੋਲ ਆਇਆ ਤਾਂ ਉਨ੍ਹਾਂ ਨੇ ਯੂਸੁਫ਼ ਉੱਤੋਂ ਉਸ ਦਾ ਚੋਲਾ ਅਰਥਾਤ ਉਹ ਰੰਗ-ਬਿਰੰਗਾ ਚੋਲਾ ਜਿਹੜਾ ਉਸ ਨੇ ਪਾਇਆ ਹੋਇਆ ਸੀ, ਉਤਾਰ ਲਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","ਤਦ ਉਨ੍ਹਾਂ ਨੇ ਉਸ ਨੂੰ ਫੜ੍ਹ ਕੇ ਟੋਏ ਵਿੱਚ ਸੁੱਟ ਦਿੱਤਾ ਅਤੇ ਉਹ ਟੋਆ ਖਾਲੀ ਸੀ, ਉਸ ਵਿੱਚ ਪਾਣੀ ਨਹੀਂ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","ਜਦ ਉਹ ਰੋਟੀ ਖਾਣ ਬੈਠੇ ਤਾਂ ਉਨ੍ਹਾਂ ਨੇ ਆਪਣੀਆਂ ਅੱਖਾਂ ਚੁੱਕ ਕੇ ਵੇਖਿਆ ਕੇ ਇਸਮਾਏਲੀਆਂ ਦਾ ਇੱਕ ਕਾਫ਼ਿਲਾ ਗਿਲਆਦ ਤੋਂ ਆ ਰਿਹਾ ਸੀ ਅਤੇ ਉਨ੍ਹਾਂ ਦੇ ਊਠਾਂ ਉੱਤੇ ਗਰਮ ਮਸਾਲੇ, ਗੁੱਗਲ ਅਤੇ ਗੰਧਰਸ ਲੱਦੀ ਹੋਈ ਸੀ, ਜੋ ਉਹ ਮਿਸਰ ਨੂੰ ਲੈ ਜਾ ਰਹੇ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","ਤਦ ਯਹੂਦਾਹ ਨੇ ਆਪਣੇ ਭਰਾਵਾਂ ਨੂੰ ਆਖਿਆ, ਸਾਨੂੰ ਕੀ ਲਾਭ ਹੋਵੇਗਾ ਜੇਕਰ ਅਸੀਂ ਆਪਣੇ ਭਰਾ ਨੂੰ ਮਾਰ ਸੁੱਟੀਏ ਅਤੇ ਉਸ ਦੇ ਲਹੂ ਨੂੰ ਲੁਕਾਈਏ? ");
INSERT INTO pan_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","ਆਓ ਅਸੀਂ ਇਸਮਾਏਲੀਆਂ ਕੋਲ ਉਸ ਨੂੰ ਵੇਚ ਦੇਈਏ ਪਰ ਉਸ ਉੱਤੇ ਸਾਡਾ ਹੱਥ ਨਾ ਪਵੇ ਕਿਉਂ ਜੋ ਉਹ ਸਾਡਾ ਭਰਾ ਅਤੇ ਸਾਡਾ ਮਾਸ ਹੈ ਅਤੇ ਉਸ ਦੇ ਭਰਾਵਾਂ ਨੇ ਉਹ ਦੀ ਗੱਲ ਮੰਨ ਲਈ। ");
INSERT INTO pan_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","ਤਦ ਮਿਦਯਾਨੀ ਵਪਾਰੀ ਉਨ੍ਹਾਂ ਦੇ ਕੋਲੋਂ ਦੀ ਲੰਘੇ ਅਤੇ ਉਨ੍ਹਾਂ ਨੇ ਯੂਸੁਫ਼ ਨੂੰ ਟੋਏ ਵਿੱਚੋਂ ਖਿੱਚ ਕੇ ਕੱਢਿਆ ਅਤੇ ਉਨ੍ਹਾਂ ਨੇ ਯੂਸੁਫ਼ ਨੂੰ ਚਾਂਦੀ ਦੇ ਵੀਹ ਸਿੱਕਿਆਂ ਵਿੱਚ ਵੇਚ ਦਿੱਤਾ ਅਤੇ ਉਹ ਯੂਸੁਫ਼ ਨੂੰ ਮਿਸਰ ਵਿੱਚ ਲੈ ਗਏ। ");
INSERT INTO pan_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","ਜਦ ਰਊਬੇਨ ਟੋਏ ਵੱਲ ਮੁੜ ਕੇ ਆਇਆ ਤਾਂ ਵੇਖੋ ਯੂਸੁਫ਼ ਟੋਏ ਵਿੱਚ ਨਹੀਂ ਸੀ, ਤਦ ਉਸ ਨੇ ਆਪਣੇ ਕੱਪੜੇ ਪਾੜੇ ");
INSERT INTO pan_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","ਅਤੇ ਉਹ ਆਪਣੇ ਭਰਾਵਾਂ ਕੋਲ ਮੁੜ ਆਇਆ ਅਤੇ ਆਖਿਆ, ਉਹ ਮੁੰਡਾ ਉੱਥੇ ਨਹੀਂ ਹੈ, ");
INSERT INTO pan_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","ਹੁਣ ਮੈਂ ਕਿੱਥੇ ਜਾਂਵਾਂ? ਤਦ ਉਨ੍ਹਾਂ ਦੇ ਯੂਸੁਫ਼ ਦਾ ਚੋਲਾ ਲੈ ਕੇ ਇੱਕ ਬੱਕਰਾ ਮਾਰ ਕੇ ਉਸ ਚੋਲੇ ਨੂੰ ਲਹੂ ਵਿੱਚ ਡੋਬਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","ਫੇਰ ਉਸ ਰੰਗ-ਬਿਰੰਗੇ ਚੋਗੇ ਨੂੰ ਚੁੱਕ ਕੇ ਆਪਣੇ ਪਿਤਾ ਕੋਲ ਲੈ ਆਏ ਅਤੇ ਉਨ੍ਹਾਂ ਨੇ ਆਖਿਆ, ਸਾਨੂੰ ਇਹ ਲੱਭਿਆ ਹੈ। ਇਸ ਨੂੰ ਪਹਿਚਾਣ ਕੀ ਇਹ ਤੁਹਾਡੇ ਪੁੱਤਰ ਦਾ ਚੋਲਾ ਹੈ ਜਾਂ ਨਹੀਂ। ");
INSERT INTO pan_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","ਤਦ ਉਸ ਨੇ ਉਹ ਨੂੰ ਪਹਿਚਾਣ ਕੇ ਆਖਿਆ, ਇਹ ਮੇਰੇ ਪੁੱਤਰ ਦਾ ਚੋਲਾ ਹੈ। ਕਿਸੇ ਬੁਰੇ ਜਾਨਵਰ ਨੇ ਉਸ ਨੂੰ ਪਾੜ ਦਿੱਤਾ ਹੈ। ਹਾਂ, ਯੂਸੁਫ਼ ਜ਼ਰੂਰ ਹੀ ਘਾਤ ਕੀਤਾ ਗਿਆ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","ਯਾਕੂਬ ਨੇ ਆਪਣੇ ਬਸਤਰ ਪਾੜੇ ਅਤੇ ਤੱਪੜ ਆਪਣੀ ਕਮਰ ਉੱਤੇ ਲਪੇਟਿਆ ਅਤੇ ਬਹੁਤ ਦਿਨਾਂ ਤੱਕ ਆਪਣੇ ਪੁੱਤਰ ਦਾ ਸੋਗ ਕਰਦਾ ਰਿਹਾ। ");
INSERT INTO pan_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","ਉਹ ਦੇ ਸਾਰੇ ਪੁੱਤਰ-ਧੀਆਂ ਨੇ ਉਸ ਨੂੰ ਤਸੱਲੀ ਦਿੱਤੀ, ਪਰ ਉਸ ਦੀ ਹਾਲਤ ਉਹੀ ਰਹੀ, ਪਰ ਆਖਿਆ, ਮੈਂ ਪਤਾਲ ਵਿੱਚ ਆਪਣੇ ਪੁੱਤਰ ਕੋਲ ਰੋਂਦਾ-ਰੋਂਦਾ ਉੱਤਰਾਂਗਾ ਅਤੇ ਉਸ ਦਾ ਪਿਤਾ ਉਹ ਦੇ ਲਈ ਵਿਰਲਾਪ ਕਰਦਾ ਰਿਹਾ। ");
INSERT INTO pan_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","ਅਤੇ ਉਨ੍ਹਾਂ ਮਿਦਯਾਨੀਆਂ ਨੇ ਯੂਸੁਫ਼ ਨੂੰ ਮਿਸਰ ਵਿੱਚ ਪੋਟੀਫ਼ਰ ਕੋਲ ਵੇਚ ਦਿੱਤਾ, ਜਿਹੜਾ ਫ਼ਿਰਊਨ ਦਾ ਹਾਕਮ ਅਤੇ ਅੰਗ-ਰੱਖਿਅਕਾਂ ਦਾ ਪ੍ਰਧਾਨ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","ਉਸ ਵੇਲੇ ਅਜਿਹਾ ਹੋਇਆ ਯਹੂਦਾਹ ਆਪਣੇ ਭਰਾਵਾਂ ਕੋਲੋਂ ਚਲਾ ਗਿਆ ਅਤੇ ਹੀਰਾਹ ਨਾਮ ਦੇ ਇੱਕ ਅਦੂਲਾਮੀ ਮਨੁੱਖ ਦੇ ਘਰ ਵਿੱਚ ਠਹਿਰਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","ਯਹੂਦਾਹ ਨੇ ਉੱਥੇ ਇੱਕ ਕਨਾਨੀ ਮਨੁੱਖ ਸ਼ੂਆ ਨਾਮੀ ਦੀ ਧੀ ਨੂੰ ਵੇਖਿਆ ਅਤੇ ਉਸ ਨਾਲ ਵਿਆਹ ਕੀਤਾ ਅਤੇ ਉਸ ਦੇ ਕੋਲ ਗਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","ਉਹ ਗਰਭਵਤੀ ਹੋਈ ਅਤੇ ਉਸਨੇ ਇੱਕ ਪੁੱਤਰ ਨੂੰ ਜਨਮ ਦਿੱਤਾ ਅਤੇ ਯਹੂਦਾਹ ਨੇ ਉਸ ਦਾ ਨਾਮ ਏਰ ਰੱਖਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","ਉਹ ਫੇਰ ਗਰਭਵਤੀ ਹੋਈ ਅਤੇ ਇੱਕ ਹੋਰ ਪੁੱਤਰ ਨੂੰ ਜਨਮ ਦਿੱਤਾ ਅਤੇ ਉਸ ਦਾ ਨਾਮ ਓਨਾਨ ਰੱਖਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","ਉਹ ਫਿਰ ਗਰਭਵਤੀ ਹੋਈ ਅਤੇ ਪੁੱਤਰ ਨੂੰ ਜਨਮ ਦਿੱਤਾ ਅਤੇ ਉਸ ਦਾ ਨਾਮ ਸ਼ੇਲਾਹ ਰੱਖਿਆ ਅਤੇ ਜਦ ਉਸ ਨੇ ਉਹ ਨੂੰ ਜਨਮ ਦਿੱਤਾ ਤਾਂ ਯਹੂਦਾਹ ਕਜ਼ੀਬ ਵਿੱਚ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","ਯਹੂਦਾਹ ਨੇ ਆਪਣੇ ਪਹਿਲੌਠੇ ਪੁੱਤਰ ਏਰ ਲਈ ਇੱਕ ਪਤਨੀ ਲਿਆਂਦੀ, ਜਿਸ ਦਾ ਨਾਮ ਤਾਮਾਰ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","ਯਹੂਦਾਹ ਦਾ ਪਹਿਲੌਠਾ ਏਰ, ਯਹੋਵਾਹ ਦੀਆਂ ਅੱਖਾਂ ਵਿੱਚ ਦੁਸ਼ਟ ਸੀ ਇਸ ਲਈ ਯਹੋਵਾਹ ਨੇ ਉਸ ਨੂੰ ਮਾਰ ਸੁੱਟਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","ਯਹੂਦਾਹ ਨੇ ਓਨਾਨ ਨੂੰ ਆਖਿਆ, ਆਪਣੇ ਭਰਾ ਦੀ ਪਤਨੀ ਕੋਲ ਜਾ ਅਤੇ ਉਸ ਦਾ ਹੱਕ ਅਦਾ ਕਰ ਅਤੇ ਆਪਣੇ ਭਰਾ ਲਈ ਅੰਸ ਚਲਾ। ");
INSERT INTO pan_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","ਓਨਾਨ ਨੇ ਇਸ ਗੱਲ ਨੂੰ ਜਾਣਿਆ ਕਿ ਇਹ ਅੰਸ ਮੇਰੀ ਅੰਸ ਨਹੀਂ ਹੋਵੇਗੀ, ਇਸ ਲਈ ਐਉਂ ਹੋਇਆ ਕਿ ਜਦ ਉਹ ਆਪਣੇ ਭਰਾ ਦੀ ਪਤਨੀ ਕੋਲ ਗਿਆ ਤਾਂ ਆਪਣਾ ਵੀਰਜ ਧਰਤੀ ਉੱਤੇ ਬਰਬਾਦ ਕਰ ਦਿੱਤਾ ਕਿਤੇ ਅਜਿਹਾ ਨਾ ਹੋਵੇ ਉਸ ਦੇ ਭਰਾ ਲਈ ਅੰਸ ਹੋਵੇ। ");
INSERT INTO pan_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","ਜੋ ਉਸ ਨੇ ਕੀਤਾ ਸੀ, ਯਹੋਵਾਹ ਦੀਆਂ ਅੱਖਾਂ ਵਿੱਚ ਬੁਰਾ ਲੱਗਾ ਅਤੇ ਉਸ ਨੇ ਓਨਾਨ ਨੂੰ ਵੀ ਮਾਰ ਦਿੱਤਾ। ");
INSERT INTO pan_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","ਤਦ ਯਹੂਦਾਹ ਨੇ ਆਪਣੀ ਨੂੰਹ ਤਾਮਾਰ ਨੂੰ ਆਖਿਆ, ਆਪਣੇ ਪਿਤਾ ਦੇ ਘਰ ਵਿਧਵਾ ਬੈਠੀ ਰਹਿ, ਜਦ ਤੱਕ ਮੇਰਾ ਪੁੱਤਰ ਸ਼ੇਲਾਹ ਸਿਆਣਾ ਨਾ ਹੋ ਜਾਵੇ ਕਿਉਂ ਜੋ ਉਸ ਨੇ ਆਖਿਆ ਕਿਤੇ ਇਹ ਵੀ ਆਪਣੇ ਭਰਾਵਾਂ ਵਾਂਗੂੰ ਮਰ ਨਾ ਜਾਵੇ ਤਦ ਤਾਮਾਰ ਚਲੀ ਗਈ ਅਤੇ ਆਪਣੇ ਪਿਤਾ ਦੇ ਘਰ ਵਿੱਚ ਬੈਠੀ ਰਹੀ। ");
INSERT INTO pan_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","ਜਦ ਬਹੁਤ ਦਿਨ ਹੋਏ ਤਾਂ ਸ਼ੂਆ ਦੀ ਧੀ, ਯਹੂਦਾਹ ਦੀ ਪਤਨੀ ਮਰ ਗਈ ਜਦ ਯਹੂਦਾਹ ਸੋਗ ਦੇ ਦਿਨਾਂ ਤੋਂ ਬਾਅਦ, ਉਹ ਆਪਣੀਆਂ ਭੇਡਾਂ ਦੀ ਉੱਨ ਕਤਰਨ ਵਾਲਿਆਂ ਕੋਲ ਆਪਣੇ ਮਿੱਤਰ ਹੀਰਾਹ ਅਦੂਲਾਮੀ ਦੇ ਸੰਗ ਤਿਮਨਾਹ ਨੂੰ ਗਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","ਤਾਮਾਰ ਨੂੰ ਦੱਸਿਆ ਗਿਆ ਕਿ ਵੇਖ ਤੇਰਾ ਸੌਹਰਾ ਆਪਣੀਆਂ ਭੇਡਾਂ ਦੀ ਉੱਨ ਕਤਰਨ ਤਿਮਨਾਹ ਨੂੰ ਜਾਂਦਾ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","ਤਦ ਉਸ ਨੇ ਆਪਣੇ ਵਿਧਵਾ ਦੇ ਬਸਤਰ ਲਾਹ ਸੁੱਟੇ ਅਤੇ ਬੁਰਕਾ ਪਾ ਕੇ ਆਪ ਨੂੰ ਲਪੇਟ ਲਿਆ ਅਤੇ ਏਨਯਿਮ ਦੇ ਫਾਟਕ ਉੱਤੇ ਜਿਹੜਾ ਤਿਮਨਾਹ ਦੇ ਰਸਤੇ ਉੱਤੇ ਸੀ, ਜਾ ਬੈਠੀ ਕਿਉਂ ਜੋ ਉਸ ਨੇ ਵੇਖਿਆ ਕਿ ਸ਼ੇਲਾਹ ਵੱਡਾ ਹੋ ਗਿਆ ਹੈ, ਪਰ ਉਹ ਉਸ ਦੀ ਪਤਨੀ ਬਣਨ ਨੂੰ ਨਹੀਂ ਦਿੱਤੀ ਗਈ। ");
INSERT INTO pan_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","ਤਦ ਯਹੂਦਾਹ ਨੇ ਉਸ ਨੂੰ ਵੇਖਿਆ ਅਤੇ ਸਮਝਿਆ ਕਿ ਇਹ ਵੇਸ਼ਵਾ ਹੈ ਕਿਉਂ ਜੋ ਉਸ ਨੇ ਆਪਣਾ ਮੂੰਹ ਢੱਕਿਆ ਹੋਇਆ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","ਉਹ ਰਸਤੇ ਤੋਂ ਉਸ ਦੀ ਵੱਲ ਮੁੜ ਪਿਆ ਅਤੇ ਆਖਿਆ, ਆ ਅਤੇ ਮੈਨੂੰ ਆਪਣੇ ਕੋਲ ਆਉਣ ਦੇ ਕਿਉਂ ਜੋ ਉਸ ਨੂੰ ਪਤਾ ਨਹੀਂ ਸੀ ਕਿ ਇਹ ਮੇਰੀ ਨੂੰਹ ਹੈ ਤਦ ਉਸ ਨੇ ਆਖਿਆ, ਜੇ ਤੂੰ ਮੇਰੇ ਕੋਲ ਆਵੇਂ ਤਾਂ ਤੂੰ ਮੈਨੂੰ ਕੀ ਦੇਵੇਂਗਾ? ");
INSERT INTO pan_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","ਉਸ ਆਖਿਆ, ਮੈਂ ਇੱਜੜ ਵਿੱਚੋਂ ਬੱਕਰੀ ਦਾ ਇੱਕ ਲੇਲਾ ਤੇਰੇ ਕੋਲ ਭੇਜਾਂਗਾ ਪਰ ਉਸ ਆਖਿਆ ਕੀ ਤੂੰ ਕੋਈ ਚੀਜ਼ ਗਹਿਣੇ ਰੱਖ ਦੇਵੇਂਗਾ, ਜਦ ਤੱਕ ਉਹ ਨਾ ਘੱਲੇਂ? ");
INSERT INTO pan_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","ਫੇਰ ਉਸ ਨੇ ਆਖਿਆ, ਮੈਂ ਤੇਰੇ ਕੋਲ ਕੀ ਗਹਿਣੇ ਰੱਖਾਂ? ਉਸ ਆਖਿਆ, ਤੂੰ ਆਪਣੀ ਮੋਹਰ, ਆਪਣੀ ਰੱਸੀ ਅਤੇ ਆਪਣੀ ਲਾਠੀ ਜਿਹੜੀ ਤੇਰੇ ਹੱਥ ਵਿੱਚ ਹੈ ਦੇ। ਉਸ ਨੇ ਉਹ ਨੂੰ ਉਹ ਸਭ ਕੁਝ ਦੇ ਦਿੱਤਾ ਅਤੇ ਉਸ ਦੇ ਕੋਲ ਗਿਆ ਅਤੇ ਉਹ ਉਸ ਤੋਂ ਗਰਭਵਤੀ ਹੋ ਗਈ। ");
INSERT INTO pan_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","ਉਹ ਉੱਥੋਂ ਉੱਠ ਕੇ ਚੱਲੀ ਗਈ ਅਤੇ ਆਪਣੇ ਉੱਤੋਂ ਬੁਰਕਾ ਲਾਹ ਸੁੱਟਿਆ ਅਤੇ ਵਿਧਵਾ ਦੇ ਬਸਤਰ ਪਾ ਲਏ। ");
INSERT INTO pan_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","ਯਹੂਦਾਹ ਨੇ ਆਪਣੇ ਮਿੱਤਰ ਅਦੂਲਾਮੀ ਦੇ ਹੱਥ ਬੱਕਰੀ ਦਾ ਲੇਲਾ ਭੇਜਿਆ ਤਾਂ ਜੋ ਉਸ ਦੀਆਂ ਗਹਿਣੇ ਰੱਖੀਆਂ ਚੀਜ਼ਾਂ ਉਸ ਇਸਤਰੀ ਦੇ ਹੱਥੋਂ ਮੋੜ ਲਿਆਵੇ ਅਤੇ ਉਹ ਉਸ ਨੂੰ ਨਾ ਲੱਭੀ। ");
INSERT INTO pan_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","ਫੇਰ ਉਸ ਨੇ ਉਸ ਥਾਂ ਦੇ ਮਨੁੱਖਾਂ ਤੋਂ ਇਹ ਪੁੱਛਿਆ ਕਿ ਉਹ ਵੇਸ਼ਵਾ ਕਿੱਥੇ ਹੈ, ਜਿਹੜੀ ਏਨਯਿਮ ਦੇ ਰਸਤੇ ਉੱਤੇ ਬੈਠੀ ਸੀ? ਤਦ ਉਨ੍ਹਾਂ ਨੇ ਆਖਿਆ ਕਿ ਇੱਥੇ ਕੋਈ ਵੇਸ਼ਵਾ ਨਹੀਂ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","ਉਹ ਯਹੂਦਾਹ ਦੇ ਕੋਲ ਮੁੜ ਆਇਆ ਅਤੇ ਆਖਿਆ ਕਿ ਉਹ ਮੈਨੂੰ ਨਹੀਂ ਲੱਭੀ ਅਤੇ ਉੱਥੇ ਦੇ ਮਨੁੱਖਾਂ ਨੇ ਵੀ ਆਖਿਆ ਕਿ ਇੱਥੇ ਕੋਈ ਵੇਸ਼ਵਾ ਨਹੀਂ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","ਯਹੂਦਾਹ ਦੇ ਆਖਿਆ ਉਹ ਉਸ ਨੂੰ ਰੱਖੇ। ਅਸੀਂ ਖੱਜਲ ਤਾਂ ਨਾ ਹੋਈਏ। ਵੇਖ ਮੈਂ ਤਾਂ ਲੇਲਾ ਭੇਜਿਆ ਸੀ, ਪਰ ਉਹ ਤੈਨੂੰ ਨਹੀਂ ਲੱਭੀ। ");
INSERT INTO pan_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","ਤਦ ਅਜਿਹਾ ਹੋਇਆ ਕਿ ਜਦ ਲੱਗਭੱਗ ਤਿੰਨ ਮਹੀਨੇ ਹੋ ਗਏ ਤਾਂ ਯਹੂਦਾਹ ਨੂੰ ਦੱਸਿਆ ਗਿਆ ਕਿ ਤੇਰੀ ਨੂੰਹ ਤਾਮਾਰ ਨੇ ਵਿਭਚਾਰ ਕੀਤਾ ਅਤੇ ਵੇਖ ਉਹ ਗਰਭਵਤੀ ਵੀ ਹੈ ਤਾਂ ਯਹੂਦਾਹ ਨੇ ਆਖਿਆ ਉਹ ਨੂੰ ਬਾਹਰ ਕੱਢ ਲਿਆਓ ਤਾਂ ਜੋ ਉਹ ਸਾੜ ਦਿੱਤੀ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","ਜਦ ਉਹ ਬਾਹਰ ਕੱਢੀ ਗਈ ਤਾਂ ਉਸ ਨੇ ਆਪਣੇ ਸੌਹਰੇ ਨੂੰ ਇਹ ਸੁਨੇਹਾ ਭੇਜਿਆ ਕਿ ਜਿਸ ਮਨੁੱਖ ਦੀਆਂ ਇਹ ਚੀਜ਼ਾਂ ਹਨ, ਮੈਂ ਉਸ ਤੋਂ ਹੀ ਗਰਭਵਤੀ ਹਾਂ ਅਤੇ ਉਸ ਨੇ ਇਹ ਵੀ ਆਖਿਆ, ਪਹਿਚਾਣ ਤਾਂ ਕਿ ਇਹ ਮੋਹਰ ਅਤੇ ਰੱਸੀ ਅਤੇ ਲਾਠੀ ਕਿਹਦੀ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","ਯਹੂਦਾਹ ਨੇ ਪਹਿਚਾਣ ਕੇ ਆਖਿਆ, ਉਹ ਮੇਰੇ ਨਾਲੋਂ ਵੱਧ ਧਰਮੀ ਹੈ ਕਿਉਂ ਜੋ ਮੈਂ ਉਸ ਦਾ ਵਿਆਹ ਆਪਣੇ ਪੁੱਤਰ ਸ਼ੇਲਾਹ ਨਾਲ ਨਹੀਂ ਕੀਤਾ ਅਤੇ ਯਹੂਦਾਹ ਨੇ ਅੱਗੇ ਨੂੰ ਉਸ ਦੇ ਨਾਲ ਸੰਗ ਨਾ ਕੀਤਾ। ");
INSERT INTO pan_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","ਅਜਿਹਾ ਹੋਇਆ ਕਿ ਉਸ ਦੇ ਜਣਨ ਦੇ ਸਮੇਂ ਉਸ ਦੀ ਕੁੱਖ ਵਿੱਚ ਜੋੜੇ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","ਅਤੇ ਜਦ ਉਹ ਜਨਮ ਦੇਣ ਲੱਗੀ ਤਾਂ ਇੱਕ ਬੱਚੇ ਨੇ ਆਪਣਾ ਹੱਥ ਬਾਹਰ ਕੱਢਿਆ ਅਤੇ ਦਾਈ ਨੇ ਫੜ੍ਹ ਕੇ ਉਸ ਦੇ ਹੱਥ ਨੂੰ ਲਾਲ ਧਾਗਾ ਬੰਨ੍ਹ ਦਿੱਤਾ ਅਤੇ ਆਖਿਆ, ਇਹ ਪਹਿਲਾਂ ਨਿੱਕਲਿਆ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","ਫਿਰ ਹੋਇਆ ਕਿ ਜਦ ਉਸ ਨੇ ਆਪਣਾ ਹੱਥ ਖਿੱਚ ਲਿਆ ਤਾਂ ਵੇਖੋ ਉਸ ਦੇ ਭਰਾ ਨੇ ਜਨਮ ਲਿਆ ਅਤੇ ਦਾਈ ਨੇ ਆਖਿਆ, ਤੂੰ ਬਾਹਰ ਆਉਣ ਵਿੱਚ ਕਿਉਂ ਜ਼ੋਰ ਲਗਾਇਆ ਹੈਂ, ਇਹ ਜ਼ੋਰ ਤੇਰੇ ਉੱਤੇ ਆਵੇ ਇਸ ਲਈ ਉਸ ਨਾ ਨਾਮ ਪਰਸ ਰੱਖਿਆ ਗਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","ਉਸ ਤੋਂ ਬਾਅਦ ਉਸ ਦਾ ਭਰਾ ਜਿਸ ਦੇ ਹੱਥ ਲਾਲ ਧਾਗਾ ਬੰਨ੍ਹਿਆ ਗਿਆ ਸੀ, ਜਨਮ ਲਿਆ ਅਤੇ ਉਸ ਦਾ ਨਾਮ ਜ਼ਰਹ ਰੱਖਿਆ ਗਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","ਯੂਸੁਫ਼ ਮਿਸਰ ਵਿੱਚ ਲਿਆਂਦਾ ਗਿਆ ਅਤੇ ਪੋਟੀਫ਼ਰ ਮਿਸਰੀ ਨੇ ਜਿਹੜਾ ਫ਼ਿਰਊਨ ਦਾ ਹਾਕਮ ਅਤੇ ਅੰਗ-ਰੱਖਿਅਕਾਂ ਦਾ ਪ੍ਰਧਾਨ ਸੀ, ਉਸ ਨੂੰ ਇਸਮਾਏਲੀਆਂ ਦੇ ਹੱਥੋਂ ਮੁੱਲ ਲੈ ਲਿਆ, ਜਿਹੜੇ ਉਸ ਨੂੰ ਉੱਥੇ ਲਿਆਏ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","ਯਹੋਵਾਹ ਯੂਸੁਫ਼ ਦੇ ਅੰਗ-ਸੰਗ ਸੀ, ਇਸ ਲਈ ਉਹ ਵੱਡਭਾਗਾ ਮਨੁੱਖ ਹੋ ਗਿਆ ਅਤੇ ਉਹ ਆਪਣੇ ਮਿਸਰੀ ਸੁਆਮੀ ਦੇ ਘਰ ਰਹਿੰਦਾ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","ਤਦ ਉਸ ਦੇ ਸੁਆਮੀ ਨੇ ਵੇਖਿਆ ਕਿ ਯਹੋਵਾਹ ਉਸ ਦੇ ਅੰਗ-ਸੰਗ ਹੈ ਅਤੇ ਜੋ ਵੀ ਕੰਮ ਉਹ ਕਰਦਾ ਹੈ ਉਸ ਦੇ ਹੱਥੋਂ ਉਹ ਸਫ਼ਲ ਕਰਾਉਂਦਾ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","ਸੋ ਯੂਸੁਫ਼ ਉੱਤੇ ਉਹ ਦੀ ਦਯਾ ਦੀ ਨਿਗਾਹ ਹੋਈ। ਯੂਸੁਫ਼ ਨੇ ਉਹ ਦੀ ਸੇਵਾ ਕੀਤੀ ਅਤੇ ਉਸ ਨੇ ਉਹ ਨੂੰ ਆਪਣੇ ਘਰ ਦਾ ਮੁਖ਼ਤਿਆਰ ਬਣਾ ਦਿੱਤਾ ਅਤੇ ਜੋ ਕੁਝ ਉਹ ਦਾ ਸੀ ਉਸ ਦੇ ਹੱਥ ਵਿੱਚ ਦੇ ਦਿੱਤਾ। ");
INSERT INTO pan_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","ਅਜਿਹਾ ਹੋਇਆ ਕਿ ਜਿਸ ਵੇਲੇ ਤੋਂ ਉਸ ਨੇ ਉਹ ਨੂੰ ਆਪਣੇ ਘਰ ਦਾ ਅਤੇ ਆਪਣੀਆਂ ਸਭ ਚੀਜ਼ਾਂ ਦਾ ਮੁਖ਼ਤਿਆਰ ਬਣਾ ਦਿੱਤਾ, ਯਹੋਵਾਹ ਨੇ ਉਸ ਮਿਸਰੀ ਦੇ ਘਰ ਉੱਤੇ ਯੂਸੁਫ਼ ਦੇ ਕਾਰਨ ਬਹੁਤ ਬਰਕਤ ਦਿੱਤੀ ਅਤੇ ਯਹੋਵਾਹ ਦੀ ਬਰਕਤ ਉਸ ਦੀਆਂ ਸਭ ਚੀਜ਼ਾਂ ਉੱਤੇ ਹੋਈ, ਭਾਵੇਂ ਉਹ ਘਰ ਵਿੱਚ ਸਨ ਭਾਵੇਂ ਖੇਤ ਵਿੱਚ। ");
INSERT INTO pan_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","ਉਸ ਨੇ ਸਭ ਕੁਝ ਯੂਸੁਫ਼ ਦੇ ਹੱਥ ਵਿੱਚ ਸੌਂਪ ਦਿੱਤਾ ਅਤੇ ਉਸ ਨੇ ਆਪਣੀ ਖਾਣ ਦੀ ਰੋਟੀ ਤੋਂ ਛੁੱਟ ਹੋਰ ਕਿਸੇ ਚੀਜ਼ ਦੀ ਖ਼ਬਰ ਨਾ ਰੱਖੀ ਅਤੇ ਯੂਸੁਫ਼ ਰੂਪਵੰਤ ਅਤੇ ਸੋਹਣਾ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","ਇਹਨਾਂ ਗੱਲਾਂ ਦੇ ਪਿੱਛੋਂ ਅਜਿਹਾ ਹੋਇਆ ਕਿ ਉਸ ਦੇ ਸੁਆਮੀ ਦੀ ਪਤਨੀ ਆਪਣੀਆਂ ਅੱਖਾਂ ਯੂਸੁਫ਼ ਨਾਲ ਲਾਉਣ ਲੱਗ ਪਈ ਅਤੇ ਉਸ ਨੇ ਉਹ ਨੂੰ ਆਖਿਆ, ਤੂੰ ਮੇਰੇ ਨਾਲ ਲੇਟ। ");
INSERT INTO pan_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","ਪਰ ਉਸ ਨੇ ਨਾ ਮੰਨਿਆ ਅਤੇ ਆਪਣੇ ਸੁਆਮੀ ਦੀ ਪਤਨੀ ਨੂੰ ਆਖਿਆ, ਵੇਖੋ, ਮੇਰਾ ਸੁਆਮੀ ਨਹੀਂ ਜਾਣਦਾ ਕਿ ਘਰ ਵਿੱਚ ਮੇਰੇ ਕੋਲ ਕੀ ਕੁਝ ਹੈ ਅਤੇ ਉਸ ਨੇ ਆਪਣਾ ਸਭ ਕੁਝ ਮੇਰੇ ਹੱਥ ਵਿੱਚ ਦੇ ਦਿੱਤਾ ਹੈ ");
INSERT INTO pan_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","ਅਤੇ ਇਸ ਘਰ ਵਿੱਚ ਮੈਥੋਂ ਵੱਡਾ ਵੀ ਕੋਈ ਨਹੀਂ ਅਤੇ ਉਸ ਨੇ ਤੁਹਾਥੋਂ ਬਿਨ੍ਹਾਂ ਕੋਈ ਚੀਜ਼ ਮੇਰੇ ਕੋਲੋਂ ਰੋਕ ਕੇ ਵੀ ਨਹੀਂ ਰੱਖੀ, ਕਿਉਂ ਜੋ ਤੁਸੀਂ ਉਸ ਦੀ ਪਤਨੀ ਹੋ। ਮੈਂ ਐਡੀ ਵੱਡੀ ਬੁਰਿਆਈ ਅਤੇ ਪਾਪ ਪਰਮੇਸ਼ੁਰ ਦੇ ਵਿਰੁੱਧ ਕਿਵੇਂ ਕਰਾਂ? ");
INSERT INTO pan_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","ਤਦ ਅਜਿਹਾ ਹੋਇਆ ਕਿ ਉਹ ਹਰ ਰੋਜ਼ ਯੂਸੁਫ਼ ਨੂੰ ਆਖਦੀ ਰਹੀ ਪਰ ਉਸ ਨੇ ਉਹ ਦੀ ਗੱਲ ਨਾ ਮੰਨੀ ਕਿ ਉਹ ਉਸ ਦੇ ਨਾਲ ਲੇਟੇ ਜਾਂ ਉਸ ਦੇ ਕੋਲ ਰਹੇ। ");
INSERT INTO pan_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","ਇੱਕ ਦਿਨ ਅਜਿਹਾ ਹੋਇਆ ਕਿ ਉਹ ਘਰ ਵਿੱਚ ਆਪਣਾ ਕੰਮ ਕਰਨ ਲਈ ਗਿਆ ਅਤੇ ਘਰ ਦੇ ਮਨੁੱਖਾਂ ਵਿੱਚੋਂ ਕੋਈ ਵੀ ਘਰ ਵਿੱਚ ਨਹੀਂ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","ਤਦ ਉਸ ਨੇ ਉਸ ਦਾ ਕੱਪੜਾ ਫੜ੍ਹ ਕੇ ਆਖਿਆ, ਮੇਰੇ ਨਾਲ ਲੇਟ ਤਾਂ ਉਹ ਆਪਣਾ ਕੱਪੜਾ ਉਸ ਦੇ ਹੱਥ ਵਿੱਚ ਛੱਡ ਕੇ ਭੱਜਿਆ ਅਤੇ ਬਾਹਰ ਨਿੱਕਲ ਗਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","ਜਦ ਉਸ ਨੇ ਵੇਖਿਆ ਕਿ ਉਹ ਆਪਣਾ ਕੱਪੜਾ ਮੇਰੇ ਹੱਥ ਵਿੱਚ ਛੱਡ ਕੇ ਬਾਹਰ ਭੱਜ ਗਿਆ ਹੈ ");
INSERT INTO pan_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","ਤਾਂ ਉਸ ਨੇ ਆਪਣੇ ਘਰ ਦੇ ਮਨੁੱਖਾਂ ਨੂੰ ਬੁਲਾਇਆ ਅਤੇ ਉਨ੍ਹਾਂ ਨੂੰ ਆਖਿਆ, ਵੇਖੋ, ਉਹ ਇੱਕ ਇਬਰਾਨੀ ਨੂੰ ਸਾਡੇ ਕੋਲ ਲੈ ਆਇਆ ਹੈ ਜਿਹੜਾ ਸਾਡਾ ਨਿਰਾਦਰ ਕਰੇ। ਉਹ ਮੇਰੇ ਕੋਲ ਅੰਦਰ ਆਇਆ ਤਾਂ ਜੋ ਉਹ ਮੇਰੇ ਨਾਲ ਲੇਟੇ ਪਰ ਮੈਂ ਉੱਚੀ ਅਵਾਜ਼ ਨਾਲ ਬੋਲ ਪਈ। ");
INSERT INTO pan_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","ਜਦ ਉਸ ਨੇ ਸੁਣਿਆ ਕਿ ਮੈਂ ਉੱਚੀ ਅਵਾਜ਼ ਨਾਲ ਚਿੱਲਾਈ ਤਾਂ ਉਹ ਆਪਣਾ ਕੱਪੜਾ ਮੇਰੇ ਕੋਲ ਛੱਡ ਕੇ ਬਾਹਰ ਨੂੰ ਭੱਜ ਗਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","ਸੋ ਉਸ ਨੇ ਆਪਣੇ ਸੁਆਮੀ ਦੇ ਘਰ ਆਉਣ ਤੱਕ ਉਸ ਦਾ ਕੱਪੜਾ ਆਪਣੇ ਕੋਲ ਰੱਖ ਛੱਡਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","ਤਦ ਉਸ ਨੇ ਉਹ ਨੂੰ ਸਾਰੀਆਂ ਗੱਲਾਂ ਦੱਸੀਆਂ ਅਤੇ ਆਖਿਆ, ਜਿਹੜਾ ਇਬਰਾਨੀ ਗ਼ੁਲਾਮ ਤੂੰ ਸਾਡੇ ਕੋਲ ਲੈ ਆਇਆ ਹੈਂ ਉਹ ਮੇਰੇ ਕੋਲ ਅੰਦਰ ਆ ਵੜਿਆ ਅਤੇ ਮੇਰੇ ਨਾਲ ਬੁਰਾ ਵਿਵਹਾਰ ਕਰਨ ਲੱਗਾ। ");
INSERT INTO pan_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","ਪਰ ਜਦ ਮੈਂ ਉੱਚੀ ਅਵਾਜ਼ ਨਾਲ ਚਿੱਲਾਈ ਤਾਂ ਉਹ ਆਪਣਾ ਕੱਪੜਾ ਮੇਰੇ ਕੋਲ ਛੱਡ ਕੇ ਬਾਹਰ ਨੂੰ ਭੱਜ ਗਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","ਫੇਰ ਅਜਿਹਾ ਹੋਇਆ ਕਿ ਜਦ ਉਸ ਦੇ ਸੁਆਮੀ ਨੇ ਆਪਣੀ ਪਤਨੀ ਦੀਆਂ ਗੱਲਾਂ ਸੁਣੀਆਂ, ਜਿਹੜੀ ਇਹ ਬੋਲੀ ਕਿ ਤੇਰੇ ਗ਼ੁਲਾਮ ਨੇ ਮੇਰੇ ਨਾਲ ਅਜਿਹਾ ਕੀਤਾ ਹੈ ਤਾਂ ਉਸ ਦਾ ਕ੍ਰੋਧ ਭੜਕ ਉੱਠਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","ਤਦ ਯੂਸੁਫ਼ ਦੇ ਸੁਆਮੀ ਨੇ ਉਸ ਨੂੰ ਫੜ੍ਹ ਕੇ ਕੈਦ ਵਿੱਚ ਪਾ ਦਿੱਤਾ, ਜਿੱਥੇ ਸ਼ਾਹੀ ਕੈਦੀ ਸਨ ਅਤੇ ਉਹ ਉੱਥੇ ਕੈਦ ਵਿੱਚ ਰਿਹਾ। ");
INSERT INTO pan_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","ਪਰ ਯਹੋਵਾਹ ਯੂਸੁਫ਼ ਦੇ ਸੰਗ ਸੀ ਅਤੇ ਉਹ ਨੇ ਉਸ ਉੱਤੇ ਕਿਰਪਾ ਕੀਤੀ ਅਤੇ ਉਸ ਨੇ ਕੈਦਖ਼ਾਨੇ ਦੇ ਦਰੋਗ਼ੇ ਦੀਆਂ ਨਜ਼ਰਾਂ ਵਿੱਚ ਦਯਾ ਪਾਈ ");
INSERT INTO pan_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","ਅਤੇ ਦਰੋਗੇ ਨੇ ਸਾਰੇ ਕੈਦੀਆਂ ਨੂੰ ਜਿਹੜੇ ਉਸ ਕੈਦ ਵਿੱਚ ਸਨ, ਯੂਸੁਫ਼ ਦੇ ਹੱਥ ਵਿੱਚ ਦੇ ਦਿੱਤਾ ਅਤੇ ਜਿਹੜਾ ਕੰਮ ਉੱਥੇ ਕੀਤਾ ਜਾਂਦਾ ਸੀ, ਉਹੀ ਚਲਾਉਂਦਾ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","ਕੈਦਖ਼ਾਨੇ ਦਾ ਦਰੋਗਾ ਕਿਸੇ ਗੱਲ ਦੀ ਜਿਹੜੀ ਉਸ ਦੇ ਹੱਥ ਵਿੱਚ ਸੀ, ਖ਼ਬਰ ਨਹੀਂ ਲੈਂਦਾ ਸੀ, ਕਿਉਂ ਜੋ ਯਹੋਵਾਹ ਯੂਸੁਫ਼ ਦੇ ਸੰਗ ਸੀ ਅਤੇ ਜੋ ਕੁਝ ਉਹ ਕਰਦਾ ਸੀ ਯਹੋਵਾਹ ਉਸ ਨੂੰ ਸਫ਼ਲ ਬਣਾ ਦਿੰਦਾ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","ਇਹਨਾਂ ਗੱਲਾਂ ਦੇ ਬਾਅਦ ਅਜਿਹਾ ਹੋਇਆ ਕਿ ਮਿਸਰ ਦੇ ਰਾਜਾ ਦਾ ਸਾਕੀ ਅਤੇ ਰਸੋਈਆ ਆਪਣੇ ਸੁਆਮੀ ਅਰਥਾਤ ਮਿਸਰ ਦੇ ਰਾਜੇ ਦੇ ਵਿਰੁੱਧ ਕੁਝ ਅਪਰਾਧ ਕੀਤਾ। ");
INSERT INTO pan_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","ਤਦ ਫ਼ਿਰਊਨ ਆਪਣੇ ਦੋਹਾਂ ਪ੍ਰਧਾਨਾਂ ਦੇ ਉੱਤੇ ਅਰਥਾਤ ਸਾਕੀਆਂ ਦੇ ਮੁਖੀਏ ਅਤੇ ਰਸੋਈਆਂ ਦੇ ਮੁਖੀਏ ਉੱਤੇ ਗੁੱਸੇ ਹੋਇਆ ");
INSERT INTO pan_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","ਅਤੇ ਉਸ ਨੇ ਉਨ੍ਹਾਂ ਨੂੰ ਅੰਗ-ਰੱਖਿਅਕਾਂ ਦੇ ਪ੍ਰਧਾਨ ਦੇ ਘਰ ਵਿੱਚ ਅਰਥਾਤ ਉਸੇ ਕੈਦਖ਼ਾਨੇ ਵਿੱਚ ਜਿੱਥੇ ਯੂਸੁਫ਼ ਕੈਦ ਸੀ, ਬੰਦ ਕਰ ਦਿੱਤਾ। ");
INSERT INTO pan_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","ਅੰਗ-ਰੱਖਿਅਕਾਂ ਦੇ ਪ੍ਰਧਾਨ ਨੇ ਉਨ੍ਹਾਂ ਨੂੰ ਯੂਸੁਫ਼ ਦੇ ਹਵਾਲੇ ਕਰ ਦਿੱਤਾ ਅਤੇ ਉਸ ਨੇ ਉਨ੍ਹਾਂ ਦੀ ਸੇਵਾ ਕੀਤੀ ਜਦ ਤੱਕ ਉਹ ਕੈਦ ਵਿੱਚ ਰਹੇ। ");
INSERT INTO pan_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","ਮਿਸਰ ਦੇ ਰਾਜਾ ਦੇ ਸਾਕੀ ਅਤੇ ਰਸੋਈਏ ਨੇ ਜਿਹੜੇ ਕੈਦਖ਼ਾਨੇ ਵਿੱਚ ਬੰਦ ਸਨ, ਉਨ੍ਹਾਂ ਦੋਹਾਂ ਨੇ ਇੱਕੋ ਹੀ ਰਾਤ ਆਪਣੇ-ਆਪਣੇ ਫਲ ਅਨੁਸਾਰ ਸੁਫ਼ਨਾ ਵੇਖਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","ਜਦ ਯੂਸੁਫ਼ ਸਵੇਰੇ ਉਨ੍ਹਾਂ ਦੇ ਕੋਲ ਅੰਦਰ ਗਿਆ ਅਤੇ ਉਨ੍ਹਾਂ ਨੂੰ ਵੇਖਿਆ ਤਾਂ ਵੇਖੋ ਉਹ ਉਦਾਸ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","ਉਸ ਨੇ ਫ਼ਿਰਊਨ ਦੇ ਉਨ੍ਹਾਂ ਪ੍ਰਧਾਨਾਂ ਨੂੰ ਜਿਹੜੇ ਉਸ ਦੇ ਨਾਲ ਉਸ ਦੇ ਸੁਆਮੀ ਦੇ ਘਰ ਕੈਦ ਵਿੱਚ ਸਨ, ਪੁੱਛਿਆ, ਅੱਜ ਤੁਹਾਡੇ ਚਿਹਰੇ ਕਿਉਂ ਉਦਾਸ ਹਨ? ");
INSERT INTO pan_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","ਤਦ ਉਨ੍ਹਾਂ ਨੇ ਉਸ ਨੂੰ ਆਖਿਆ, ਅਸੀਂ ਇੱਕ ਸੁਫ਼ਨਾ ਵੇਖਿਆ ਹੈ, ਜਿਸ ਦਾ ਅਰਥ ਦੱਸਣ ਵਾਲਾ ਕੋਈ ਨਹੀਂ ਹੈ ਤਾਂ ਯੂਸੁਫ਼ ਨੇ ਉਨ੍ਹਾਂ ਨੂੰ ਆਖਿਆ, ਕੀ ਸੁਫ਼ਨਿਆਂ ਦਾ ਅਰਥ ਦੱਸਣਾ ਪਰਮੇਸ਼ੁਰ ਦਾ ਕੰਮ ਨਹੀਂ ਹੈ? ਤੁਸੀਂ ਆਪਣੇ-ਆਪਣੇ ਸੁਫ਼ਨੇ ਮੈਨੂੰ ਦੱਸੋ? ");
INSERT INTO pan_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","ਸਾਕੀਆਂ ਦੇ ਮੁਖੀਏ ਨੇ ਯੂਸੁਫ਼ ਨੂੰ ਆਪਣਾ ਸੁਫ਼ਨਾ ਦੱਸਿਆ ਅਤੇ ਆਖਿਆ, ਵੇਖੋ ਮੇਰੇ ਸੁਫ਼ਨੇ ਵਿੱਚ ਦਾਖ਼ ਦੀ ਇੱਕ ਵੇਲ ਮੇਰੇ ਸਨਮੁਖ ਸੀ, ");
INSERT INTO pan_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","ਅਤੇ ਉਸ ਵੇਲ ਵਿੱਚ ਤਿੰਨ ਟਹਿਣੀਆਂ ਸਨ ਅਤੇ ਜਾਣੋ ਉਹ ਨੂੰ ਕਲੀਆਂ ਨਿੱਕਲੀਆਂ ਅਤੇ ਫੁੱਲ ਲੱਗੇ ਅਤੇ ਉਸ ਦੇ ਗੁੱਛਿਆਂ ਵਿੱਚ ਦਾਖ਼ ਪੱਕ ਗਈ। ");
INSERT INTO pan_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","ਫ਼ਿਰਊਨ ਦਾ ਪਿਆਲਾ ਮੇਰੇ ਹੱਥ ਵਿੱਚ ਸੀ, ਅਤੇ ਮੈਂ ਦਾਖ਼ਾਂ ਨੂੰ ਲੈ ਕੇ ਫ਼ਿਰਊਨ ਦੇ ਪਿਆਲੇ ਵਿੱਚ ਨਿਚੋੜਿਆ ਅਤੇ ਉਹ ਪਿਆਲਾ ਮੈਂ ਫ਼ਿਰਊਨ ਦੀ ਹਥੇਲੀ ਉੱਤੇ ਰੱਖਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","ਤਦ ਯੂਸੁਫ਼ ਨੇ ਉਸ ਨੂੰ ਆਖਿਆ, ਇਸ ਦਾ ਅਰਥ ਇਹ ਹੈ ਕਿ ਉਹ ਤਿੰਨ ਟਹਿਣੀਆਂ ਤਿੰਨ ਦਿਨ ਹਨ। ");
INSERT INTO pan_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","ਇਨ੍ਹਾਂ ਤਿੰਨਾਂ ਦਿਨਾਂ ਵਿੱਚ ਫ਼ਿਰਊਨ ਤੇਰਾ ਸਿਰ ਉੱਚਾ ਕਰੇਗਾ ਅਤੇ ਤੈਨੂੰ ਤੇਰੇ ਅਹੁਦੇ ਉੱਤੇ ਫੇਰ ਖੜ੍ਹਾ ਕਰੇਗਾ ਅਤੇ ਤੂੰ ਪਹਿਲਾਂ ਦੀ ਤਰ੍ਹਾਂ ਜਦ ਤੂੰ ਉਹ ਦਾ ਸਾਕੀ ਸੀ, ਫਿਰ ਤੋਂ ਫ਼ਿਰਊਨ ਦੇ ਹੱਥ ਵਿੱਚ ਪਿਆਲਾ ਦੇਵੇਂਗਾ। ");
INSERT INTO pan_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","ਜਦ ਤੇਰਾ ਭਲਾ ਹੋਵੇ ਤਾਂ ਤੂੰ ਮੈਨੂੰ ਯਾਦ ਰੱਖੀਂ ਅਤੇ ਮੇਰੇ ਉੱਤੇ ਕਿਰਪਾ ਕਰਕੇ ਫ਼ਿਰਊਨ ਨੂੰ ਮੇਰੇ ਬਾਰੇ ਦੱਸੀਂ ਅਤੇ ਮੈਨੂੰ ਇਸ ਘਰ ਵਿੱਚੋਂ ਬਾਹਰ ਕਢਾਈਂ। ");
INSERT INTO pan_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","ਕਿਉਂ ਜੋ ਸੱਚ-ਮੁੱਚ ਮੈਂ ਇਬਰਾਨੀਆਂ ਦੇ ਦੇਸ਼ ਵਿੱਚੋਂ ਚੁਰਾਇਆ ਗਿਆ ਹਾਂ ਅਤੇ ਇੱਥੇ ਵੀ ਮੈਂ ਕੁਝ ਨਹੀਂ ਕੀਤਾ ਕਿ ਉਹ ਮੈਨੂੰ ਇਸ ਕੈਦ ਵਿੱਚ ਰੱਖਣ। ");
INSERT INTO pan_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","ਜਦ ਰਸੋਈਆਂ ਦੇ ਮੁਖੀਏ ਨੇ ਵੇਖਿਆ ਕਿ ਉਸ ਦੇ ਸੁਫ਼ਨੇ ਦਾ ਅਰਥ ਚੰਗਾ ਹੈ ਤਾਂ ਉਸ ਨੇ ਯੂਸੁਫ਼ ਨੂੰ ਆਖਿਆ, ਮੈਂ ਵੀ ਇੱਕ ਸੁਫ਼ਨਾ ਵੇਖਿਆ, ਅਤੇ ਵੇਖੋ ਮੇਰੇ ਸਿਰ ਉੱਤੇ ਚਿੱਟੀਆਂ ਰੋਟੀਆਂ ਦੀਆਂ ਤਿੰਨ ਟੋਕਰੀਆਂ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","ਅਤੇ ਸਭ ਤੋਂ ਉੱਪਰਲੀ ਟੋਕਰੀ ਵਿੱਚ ਫ਼ਿਰਊਨ ਲਈ ਭਿੰਨ-ਭਿੰਨ ਪ੍ਰਕਾਰ ਦਾ ਪਕਾਇਆ ਹੋਇਆ ਭੋਜਨ ਸੀ ਅਤੇ ਪੰਛੀ ਮੇਰੇ ਸਿਰ ਉੱਪਰਲੀ ਟੋਕਰੀ ਵਿੱਚੋਂ ਖਾਂਦੇ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","ਤਦ ਯੂਸੁਫ਼ ਨੇ ਉੱਤਰ ਦੇ ਕੇ ਆਖਿਆ, ਇਸ ਦਾ ਅਰਥ ਇਹ ਹੈ ਕਿ ਇਹ ਤਿੰਨ ਟੋਕਰੀਆਂ ਤਿੰਨ ਦਿਨ ਹਨ। ");
INSERT INTO pan_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","ਇਨ੍ਹਾਂ ਤਿੰਨਾਂ ਦਿਨਾਂ ਵਿੱਚ ਫ਼ਿਰਊਨ ਤੇਰਾ ਸਿਰ ਤੇਰੇ ਉੱਤੋਂ ਲਾਹ ਦੇਵੇਗਾ ਅਤੇ ਤੈਨੂੰ ਇੱਕ ਰੁੱਖ ਨਾਲ ਟੰਗ ਦੇਵੇਗਾ ਅਤੇ ਪੰਛੀ ਤੇਰਾ ਮਾਸ ਖਾਣਗੇ। ");
INSERT INTO pan_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","ਫਿਰ ਤੀਜੇ ਦਿਨ, ਫ਼ਿਰਊਨ ਦਾ ਜਨਮ ਦਿਨ ਸੀ ਅਤੇ ਉਸ ਨੇ ਆਪਣੇ ਸਾਰੇ ਕਰਮਚਾਰੀਆਂ ਲਈ ਦਾਵਤ ਕੀਤੀ ਅਤੇ ਆਪਣੇ ਕਰਮਚਾਰੀਆਂ ਵਿੱਚੋਂ ਸਾਕੀਆਂ ਦੇ ਮੁਖੀਏ ਅਤੇ ਰਸੋਈਆਂ ਦੇ ਮੁਖੀਏ ਦਾ ਸਿਰ ਉੱਚਾ ਕੀਤਾ। ");
INSERT INTO pan_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","ਪਰ ਉਸ ਨੇ ਸਾਕੀਆਂ ਦੇ ਮੁਖੀਏ ਨੂੰ ਤਾਂ ਉਹ ਦੇ ਅਹੁਦੇ ਉੱਤੇ ਫਿਰ ਨਿਯੁਕਤ ਕੀਤਾ ਤਾਂ ਜੋ ਉਹ ਫ਼ਿਰਊਨ ਦੀ ਹਥੇਲੀ ਉੱਤੇ ਪਿਆਲਾ ਰੱਖੇ ");
INSERT INTO pan_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","ਪਰ ਉਸ ਨੇ ਰਸੋਈਆਂ ਦੇ ਮੁਖੀਏ ਨੂੰ ਫਾਂਸੀ ਦੇ ਦਿੱਤੀ ਜਿਵੇਂ ਯੂਸੁਫ਼ ਨੇ ਉਨ੍ਹਾਂ ਦੇ ਸੁਫ਼ਨਿਆਂ ਦਾ ਅਰਥ ਦੱਸਿਆ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","ਪਰ ਸਾਕੀਆਂ ਦੇ ਮੁਖੀਏ ਨੇ ਯੂਸੁਫ਼ ਨੂੰ ਯਾਦ ਨਾ ਰੱਖਿਆ ਪਰ ਉਸ ਨੂੰ ਭੁੱਲ ਗਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","ਪੂਰੇ ਦੋ ਸਾਲਾਂ ਦੇ ਅੰਤ ਵਿੱਚ ਫ਼ਿਰਊਨ ਨੇ ਇੱਕ ਸੁਫ਼ਨਾ ਵੇਖਿਆ ਕਿ ਉਹ ਨੀਲ ਨਦੀ ਕੋਲ ਖੜ੍ਹਾ ਸੀ, ");
INSERT INTO pan_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","ਅਤੇ ਵੇਖੋ ਨਦੀ ਵਿੱਚੋਂ ਸੱਤ ਗਾਂਈਆਂ ਜਿਹੜੀਆਂ ਸੋਹਣੀਆਂ ਅਤੇ ਮੋਟੀਆਂ ਸਨ, ਨਿੱਕਲੀਆਂ ਅਤੇ ਨਦੀ ਦੇ ਕਿਨਾਰੇ ਚੁੱਗਣ ਲੱਗ ਪਈਆਂ। ");
INSERT INTO pan_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","ਅਤੇ ਵੇਖੋ, ਉਨ੍ਹਾਂ ਤੋਂ ਬਾਅਦ ਸੱਤ ਗਾਂਈਆਂ ਹੋਰ ਜਿਹੜੀਆਂ ਕਰੂਪ ਅਤੇ ਸਰੀਰ ਵਿੱਚ ਲਿੱਸੀਆਂ ਸਨ, ਨਦੀ ਵਿੱਚੋਂ ਨਿੱਕਲੀਆਂ ਅਤੇ ਨਦੀ ਦੇ ਕੰਢੇ ਉੱਤੇ ਦੂਸਰੀਆਂ ਗਾਈਆਂ ਕੋਲ ਖੜ੍ਹੀਆਂ ਹੋ ਗਈਆਂ। ");
INSERT INTO pan_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","ਤਦ ਕਰੂਪ ਅਤੇ ਲਿੱਸੀਆਂ ਗਾਈਆਂ ਨੇ ਉਨ੍ਹਾਂ ਸੱਤਾਂ ਸੋਹਣੀਆਂ ਅਤੇ ਮੋਟੀਆਂ ਗਾਂਈਆਂ ਨੂੰ ਨਿਗਲ ਲਿਆ, ਤਦ ਫ਼ਿਰਊਨ ਜਾਗ ਉੱਠਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","ਉਹ ਫੇਰ ਸੌਂ ਗਿਆ ਅਤੇ ਦੂਜੀ ਵਾਰ ਸੁਫ਼ਨਾ ਵੇਖਿਆ ਅਤੇ ਵੇਖੋ, ਮੋਟੇ ਅਤੇ ਚੰਗੇ ਸੱਤ ਸਿੱਟੇ ਇੱਕ ਨੜ ਵਿੱਚੋਂ ਨਿੱਕਲੇ ");
INSERT INTO pan_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","ਅਤੇ ਵੇਖੋ, ਉਸ ਦੇ ਬਾਅਦ ਪਤਲੇ ਅਤੇ ਪੂਰਬੀ ਹਵਾ ਨਾਲ ਝੁਲਸੇ ਹੋਏ ਸੱਤ ਸਿੱਟੇ ਫੁੱਟ ਪਏ। ");
INSERT INTO pan_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","ਉਹ ਪਤਲੇ ਸਿੱਟੇ ਉਨ੍ਹਾਂ ਸੱਤਾਂ ਮੋਟੇ ਅਤੇ ਭਰੇ ਹੋਏ ਸਿੱਟਿਆਂ ਨੂੰ ਨਿਗਲ ਗਏ ਤਾਂ ਫ਼ਿਰਊਨ ਜਾਗ ਉੱਠਿਆ ਅਤੇ ਜਾਣਿਆ ਕਿ ਇਹ ਸੁਫ਼ਨਾ ਹੀ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","ਅਤੇ ਸਵੇਰੇ ਹੀ ਉਸ ਦਾ ਮਨ ਬੇਚੈਨ ਹੋ ਗਿਆ ਤਾਂ ਉਸ ਨੇ ਮਿਸਰ ਦੇ ਸਾਰੇ ਜਾਦੂਗਰ ਅਤੇ ਸਾਰੇ ਜੋਤਸ਼ੀ ਸੱਦ ਲਏ, ਤਦ ਫ਼ਿਰਊਨ ਨੇ ਉਨ੍ਹਾਂ ਨੂੰ ਆਪਣੇ ਸੁਫ਼ਨੇ ਦੱਸੇ ਪਰ ਕੋਈ ਵੀ ਫ਼ਿਰਊਨ ਨੂੰ ਉਨ੍ਹਾਂ ਦਾ ਅਰਥ ਨਾ ਦੱਸ ਸਕਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","ਤਦ ਸਾਕੀਆਂ ਦੇ ਮੁਖੀਏ ਨੇ ਫ਼ਿਰਊਨ ਨਾਲ ਇਹ ਗੱਲ ਕੀਤੀ, ਅੱਜ ਮੈਂ ਆਪਣੀ ਗਲਤੀ ਨੂੰ ਯਾਦ ਕਰਦਾ ਹਾਂ। ");
INSERT INTO pan_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","ਜਦ ਫ਼ਿਰਊਨ ਆਪਣੇ ਦਾਸਾਂ ਉੱਤੇ ਗੁੱਸੇ ਹੋਇਆ ਤਾਂ ਮੈਨੂੰ ਅਤੇ ਰਸੋਈਆਂ ਦੇ ਮੁਖੀਏ ਨੂੰ ਅੰਗ-ਰੱਖਿਅਕਾਂ ਦੇ ਪ੍ਰਧਾਨ ਦੇ ਘਰ ਵਿੱਚ ਕੈਦ ਕੀਤਾ। ");
INSERT INTO pan_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","ਤਦ ਅਸੀਂ ਦੋਨਾਂ ਨੇ ਇੱਕੋ ਹੀ ਰਾਤ ਵਿੱਚ ਆਪੋ ਆਪਣੇ ਅਰਥ ਅਨੁਸਾਰ ਸੁਫ਼ਨਾ ਵੇਖਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","ਅੰਗ-ਰੱਖਿਅਕਾਂ ਦੇ ਪ੍ਰਧਾਨ ਦਾ ਗ਼ੁਲਾਮ ਇੱਕ ਇਬਰੀ ਜੁਆਨ, ਉੱਥੇ ਸਾਡੇ ਨਾਲ ਸੀ ਅਤੇ ਜਦ ਅਸੀਂ ਉਸ ਨੂੰ ਦੱਸਿਆ ਤਾਂ ਉਸ ਨੇ ਸਾਡੇ ਸੁਫ਼ਨਿਆਂ ਦਾ ਅਰਥ ਇੱਕ-ਇੱਕ ਦੇ ਸੁਫ਼ਨੇ ਦੇ ਅਰਥ ਅਨੁਸਾਰ ਦੱਸਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","ਅਤੇ ਜਿਵੇਂ ਉਸ ਨੇ ਸਾਨੂੰ ਉਸ ਦਾ ਅਰਥ ਦੱਸਿਆ ਸੀ, ਉਸੇ ਤਰ੍ਹਾਂ ਹੀ ਹੋਇਆ। ਮੈਨੂੰ ਤਾਂ ਮੇਰੇ ਅਹੁਦੇ ਉੱਤੇ ਬਹਾਲ ਕੀਤਾ ਗਿਆ ਪਰ ਉਸ ਨੂੰ ਫਾਂਸੀ ਦਿੱਤੀ। ");
INSERT INTO pan_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","ਤਦ ਫ਼ਿਰਊਨ ਨੇ ਯੂਸੁਫ਼ ਨੂੰ ਸੱਦ ਭੇਜਿਆ ਅਤੇ ਉਨ੍ਹਾਂ ਨੇ ਛੇਤੀ ਨਾਲ ਯੂਸੁਫ਼ ਨੂੰ ਕੈਦ ਵਿੱਚੋਂ ਕੱਢਿਆ। ਉਹ ਹਜਾਮਤ ਕਰ ਕੇ ਅਤੇ ਬਸਤਰ ਬਦਲ ਕੇ ਫ਼ਿਰਊਨ ਦੇ ਕੋਲ ਅੰਦਰ ਆਇਆ। ");
INSERT INTO pan_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","ਫ਼ਿਰਊਨ ਨੇ ਯੂਸੁਫ਼ ਨੂੰ ਆਖਿਆ, ਮੈਂ ਇੱਕ ਸੁਫ਼ਨਾ ਵੇਖਿਆ ਹੈ, ਅਤੇ ਉਸ ਦਾ ਅਰਥ ਦੱਸਣ ਵਾਲਾ ਕੋਈ ਨਹੀਂ। ਮੈਂ ਤੇਰੇ ਬਾਰੇ ਇਹ ਸੁਣਿਆ ਹੈ ਕਿ ਤੂੰ ਸੁਫ਼ਨਾ ਸੁਣ ਕੇ ਉਸ ਦਾ ਅਰਥ ਦੱਸ ਸਕਦਾ ਹੈਂ। ");
INSERT INTO pan_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","ਤਦ ਯੂਸੁਫ਼ ਨੇ ਫ਼ਿਰਊਨ ਨੂੰ ਉੱਤਰ ਦਿੱਤਾ, ਇਹ ਮੇਰੀ ਸ਼ਕਤੀ ਨਹੀਂ। ਪਰਮੇਸ਼ੁਰ ਹੀ ਫ਼ਿਰਊਨ ਨੂੰ ਸ਼ਾਂਤੀ ਦਾ ਉੱਤਰ ਦੇਵੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","ਫਿਰ ਫ਼ਿਰਊਨ ਨੇ ਯੂਸੁਫ਼ ਨੂੰ ਆਖਿਆ, ਵੇਖੋ, ਮੈਂ ਆਪਣੇ ਸੁਫ਼ਨੇ ਵਿੱਚ ਨੀਲ ਨਦੀ ਦੇ ਕੰਢੇ ਉੱਤੇ ਖੜ੍ਹਾ ਸੀ, ");
INSERT INTO pan_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","ਅਤੇ ਵੇਖੋ, ਦਰਿਆ ਵਿੱਚੋਂ ਸੱਤ ਗਾਂਈਆਂ ਜਿਹੜੀਆਂ ਮੋਟੀਆਂ ਅਤੇ ਸੋਹਣੀਆਂ ਸਨ, ਨਿੱਕਲੀਆਂ ਅਤੇ ਉਹ ਨਦੀ ਦੇ ਕਿਨਾਰੇ ਚੁੱਗਣ ਲੱਗ ਪਈਆਂ। ");
INSERT INTO pan_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","ਫਿਰ ਵੇਖੋ, ਉਨ੍ਹਾਂ ਦੇ ਬਾਅਦ ਹੋਰ ਸੱਤ ਗਾਂਈਆਂ ਨਿੱਕਲੀਆਂ ਜਿਹੜੀਆਂ ਬਹੁਤ ਕਰੂਪ ਅਤੇ ਲਿੱਸੀਆਂ ਸਨ। ਅਜਿਹੀਆਂ ਕਰੂਪ ਗਾਂਵਾਂ ਮੈਂ ਸਾਰੇ ਮਿਸਰ ਦੇਸ਼ ਵਿੱਚ ਕਦੇ ਨਹੀਂ ਵੇਖੀਆਂ। ");
INSERT INTO pan_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","ਤਦ ਉਹ ਲਿੱਸੀਆਂ ਅਤੇ ਕਰੂਪ ਗਾਂਈਆਂ ਪਹਿਲੀਆਂ ਸੱਤ ਤਕੜੀਆਂ ਗਾਂਈਆਂ ਨੂੰ ਖਾ ਗਈਆਂ। ");
INSERT INTO pan_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","ਉਨ੍ਹਾਂ ਨੇ ਉਨ੍ਹਾਂ ਨੂੰ ਖਾ ਲਿਆ ਪਰ ਵੇਖਣ ਵਿੱਚ ਮਲੂਮ ਨਾ ਹੋਇਆ ਕਿ ਉਨ੍ਹਾਂ ਨੇ ਉਨ੍ਹਾਂ ਨੂੰ ਖਾ ਲਿਆ ਹੈ ਕਿਉਂ ਜੋ ਉਹ ਵੇਖਣ ਵਿੱਚ ਪਹਿਲਾਂ ਦੀ ਤਰ੍ਹਾਂ ਹੀ ਸਨ। ਤਦ ਮੈਂ ਜਾਗ ਉੱਠਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","ਫੇਰ ਮੈਂ ਦੂਜਾ ਸੁਫ਼ਨਾ ਵੇਖਿਆ ਅਤੇ ਵੇਖੋ, ਇੱਕ ਨੜ ਵਿੱਚੋਂ ਭਰੇ ਹੋਏ ਅਤੇ ਚੰਗੇ ਸੱਤ ਸਿੱਟੇ ਨਿੱਕਲੇ, ");
INSERT INTO pan_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","ਅਤੇ ਵੇਖੋ ਉਨ੍ਹਾਂ ਦੇ ਬਾਅਦ ਸੱਤ ਸਿੱਟੇ ਕੁਮਲਾਏ ਹੋਏ, ਪਤਲੇ ਅਤੇ ਪੂਰਬੀ ਹਵਾ ਨਾਲ ਝੁਲਸੇ ਹੋਏ ਫੁੱਟ ਪਏ। ");
INSERT INTO pan_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","ਅਤੇ ਉਨ੍ਹਾਂ ਪਤਲਿਆਂ ਸਿੱਟਿਆਂ ਨੇ ਸੱਤ ਚੰਗੇ ਸਿੱਟਿਆਂ ਨੂੰ ਨਿਗਲ ਲਿਆ। ਮੈਂ ਇਹ ਸੁਫ਼ਨਾ ਜਾਦੂਗਰਾਂ ਨੂੰ ਦੱਸਿਆ ਪਰ ਕੋਈ ਮੈਨੂੰ ਇਸ ਦਾ ਅਰਥ ਨਾ ਦੱਸ ਸਕਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","ਯੂਸੁਫ਼ ਨੇ ਫ਼ਿਰਊਨ ਨੂੰ ਆਖਿਆ, ਫ਼ਿਰਊਨ ਦਾ ਸੁਫ਼ਨਾ ਇੱਕੋ ਹੀ ਹੈ। ਪਰਮੇਸ਼ੁਰ ਜੋ ਕੁਝ ਕਰਨ ਵਾਲਾ ਹੈ, ਉਸ ਨੇ ਫ਼ਿਰਊਨ ਦੇ ਉੱਤੇ ਪਰਗਟ ਕੀਤਾ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","ਇਹ ਸੱਤ ਚੰਗੀਆਂ ਗਾਂਈਆਂ ਸੱਤ ਸਾਲ ਹਨ ਅਤੇ ਇਹ ਸੱਤ ਸਿੱਟੇ ਵੀ ਸੱਤ ਸਾਲ ਹਨ। ਇਹ ਸੁਫ਼ਨਾ ਇੱਕੋ ਹੀ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","ਅਤੇ ਉਹ ਲਿੱਸੀਆਂ ਅਤੇ ਕਰੂਪ ਸੱਤ ਗਾਂਈਆਂ ਜਿਹੜੀਆਂ ਉਨ੍ਹਾਂ ਦੇ ਬਾਅਦ ਨਿੱਕਲੀਆਂ, ਅਤੇ ਉਹ ਸੱਤ ਸਿੱਟੇ ਜਿਹੜੇ ਪਤਲੇ ਅਤੇ ਪੂਰਬੀ ਹਵਾ ਨਾਲ ਝੁਲਸੇ ਹੋਏ ਸਨ, ਉਹ ਕਾਲ ਦੇ ਸੱਤ ਸਾਲ ਹੋਣਗੇ। ");
INSERT INTO pan_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","ਇਹ ਇਹੋ ਹੀ ਗੱਲ ਹੈ ਜਿਹੜੀ ਮੈਂ ਫ਼ਿਰਊਨ ਨਾਲ ਕੀਤੀ ਹੈ ਕਿ ਪਰਮੇਸ਼ੁਰ ਜੋ ਕੁਝ ਕਰਨ ਨੂੰ ਹੈ, ਉਹ ਉਸ ਨੇ ਫ਼ਿਰਊਨ ਦੇ ਉੱਤੇ ਪਰਗਟ ਕੀਤਾ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","ਵੇਖੋ, ਸਾਰੇ ਮਿਸਰ ਦੇਸ਼ ਵਿੱਚ ਸੱਤ ਸਾਲ ਭਰਪੂਰੀ ਦੇ ਆਉਣ ਵਾਲੇ ਹਨ। ");
INSERT INTO pan_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","ਪਰ ਉਨ੍ਹਾਂ ਦੇ ਬਾਅਦ ਸੱਤ ਸਾਲ ਕਾਲ ਦੇ ਹੋਣਗੇ ਅਤੇ ਮਿਸਰ ਦੇਸ਼ ਦੀ ਸਾਰੀ ਭਰਪੂਰੀ ਮੁੱਕ ਜਾਵੇਗੀ ਅਤੇ ਕਾਲ ਇਸ ਦੇਸ਼ ਨੂੰ ਮੁਕਾ ਦੇਵੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","ਉਸ ਕਾਲ ਦੇ ਕਾਰਨ ਦੇਸ਼ ਵਿੱਚ ਭਰਪੂਰੀ ਨੂੰ ਯਾਦ ਨਾ ਰੱਖਿਆ ਜਾਵੇਗਾ ਕਿਉਂ ਜੋ ਕਾਲ ਬਹੁਤ ਹੀ ਭਾਰਾ ਹੋਵੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","ਇਹ ਸੁਫ਼ਨਾ ਫ਼ਿਰਊਨ ਨੂੰ ਦੋ ਵਾਰ ਇਸ ਲਈ ਵਿਖਾਇਆ ਗਿਆ ਹੈ ਕਿਉਂ ਜੋ ਇਹ ਗੱਲ ਪਰਮੇਸ਼ੁਰ ਵੱਲੋਂ ਪੱਕੀ ਹੈ ਅਤੇ ਪਰਮੇਸ਼ੁਰ ਇਸ ਨੂੰ ਜਲਦ ਹੀ ਪੂਰਾ ਕਰੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","ਇਸ ਲਈ ਹੁਣ ਫ਼ਿਰਊਨ ਇੱਕ ਸਿਆਣੇ ਅਤੇ ਬੁੱਧਵਾਨ ਮਨੁੱਖ ਨੂੰ ਲੱਭੇ ਅਤੇ ਉਸ ਨੂੰ ਮਿਸਰ ਦੇਸ਼ ਉੱਤੇ ਠਹਿਰਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","ਫ਼ਿਰਊਨ ਅਜਿਹਾ ਕਰੇ ਕਿ ਇਸ ਦੇਸ਼ ਉੱਤੇ ਅਧਿਕਾਰੀਆਂ ਨੂੰ ਨਿਯੁਕਤ ਕਰੇ ਅਤੇ ਉਹ ਮਿਸਰ ਦੀ ਸੱਤ ਸਾਲ ਦੀ ਭਰਪੂਰੀ ਦਾ ਪੰਜਵਾਂ ਹਿੱਸਾ ਲਿਆ ਕਰੇ। ");
INSERT INTO pan_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","ਉਹ ਇਨ੍ਹਾਂ ਆਉਣ ਵਾਲਿਆਂ ਚੰਗਿਆਂ ਸਾਲਾਂ ਦਾ ਸਾਰਾ ਅੰਨ ਇਕੱਠਾ ਕਰਨ ਅਤੇ ਫ਼ਿਰਊਨ ਦੇ ਅਧੀਨ ਨਗਰਾਂ ਵਿੱਚ ਅੰਨ ਦੇ ਢੇਰ ਲਾਉਣ ਅਤੇ ਉਸ ਦੀ ਰਾਖੀ ਕਰਨ। ");
INSERT INTO pan_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","ਤਦ ਉਹੀ ਅੰਨ ਸੱਤਾਂ ਸਾਲਾਂ ਦੇ ਕਾਲ ਲਈ ਜਿਹੜਾ ਮਿਸਰ ਦੇਸ਼ ਵਿੱਚ ਪਵੇਗਾ ਭੰਡਾਰ ਹੋਵੇਗਾ, ਤਾਂ ਜੋ ਇਹ ਦੇਸ਼ ਕਾਲ ਦੇ ਕਾਰਨ ਨਾਸ ਨਾ ਹੋ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","ਇਹ ਗੱਲ ਫ਼ਿਰਊਨ ਅਤੇ ਉਸ ਦੇ ਸਾਰੇ ਕਰਮਚਾਰੀਆਂ ਦੀਆਂ ਨਜ਼ਰਾਂ ਵਿੱਚ ਚੰਗੀ ਲੱਗੀ। ");
INSERT INTO pan_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","ਇਸ ਲਈ ਫ਼ਿਰਊਨ ਨੇ ਆਪਣੇ ਕਰਮਚਾਰੀਆਂ ਨੂੰ ਆਖਿਆ, ਭਲਾ, ਸਾਨੂੰ ਇਸ ਵਰਗਾ ਕੋਈ ਹੋਰ ਮਨੁੱਖ ਲੱਭੇਗਾ ਜਿਸ ਵਿੱਚ ਪਰਮੇਸ਼ੁਰ ਦਾ ਆਤਮਾ ਹੈ? ");
INSERT INTO pan_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","ਫ਼ਿਰਊਨ ਨੇ ਯੂਸੁਫ਼ ਨੂੰ ਆਖਿਆ, ਕਿਉਂ ਜੋ ਇਹ ਸਭ ਕੁਝ ਪਰਮੇਸ਼ੁਰ ਨੇ ਤੇਰੇ ਉੱਤੇ ਪਰਗਟ ਕੀਤਾ, ਇਸ ਲਈ ਤੇਰੇ ਜਿਹਾ ਸਿਆਣਾ ਅਤੇ ਬੁੱਧਵਾਨ ਕੋਈ ਨਹੀਂ। ");
INSERT INTO pan_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","ਤੂੰ ਮੇਰੇ ਘਰ ਉੱਤੇ ਅਧਿਕਾਰੀ ਹੋਵੇਂਗਾ ਅਤੇ ਮੇਰੀ ਸਾਰੀ ਪਰਜਾ ਤੇਰੇ ਆਖੇ ਦੇ ਅਨੁਸਾਰ ਚੱਲੇਗੀ। ਸਿਰਫ਼ ਰਾਜ ਗੱਦੀ ਵਿੱਚ ਮੈਂ ਤੇਰੇ ਨਾਲੋਂ ਵੱਡਾ ਹੋਵਾਂਗਾ। ");
INSERT INTO pan_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","ਫ਼ਿਰਊਨ ਨੇ ਯੂਸੁਫ਼ ਨੂੰ ਆਖਿਆ, ਵੇਖ, ਮੈਂ ਤੈਨੂੰ ਸਾਰੇ ਮਿਸਰ ਦੇਸ਼ ਉੱਤੇ ਹਾਕਮ ਨਿਯੁਕਤ ਕੀਤਾ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","ਤਦ ਫ਼ਿਰਊਨ ਨੇ ਆਪਣੀ ਮੋਹਰ ਦੀ ਅੰਗੂਠੀ ਆਪਣੇ ਹੱਥੋਂ ਲਾਹ ਕੇ ਯੂਸੁਫ਼ ਦੇ ਹੱਥ ਵਿੱਚ ਪਾ ਦਿੱਤੀ ਅਤੇ ਉਸ ਨੂੰ ਮਹੀਨ ਬਸਤਰ ਪਵਾਏ ਅਤੇ ਸੋਨੇ ਦੀ ਮਾਲਾ ਉਸ ਦੇ ਗਲ਼ ਵਿੱਚ ਪਾ ਦਿੱਤੀ। ");
INSERT INTO pan_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","ਉਸ ਨੇ ਉਹ ਨੂੰ ਆਪਣੇ ਤੋਂ ਦੂਜੇ ਦਰਜੇ ਦੇ ਰਥ ਵਿੱਚ ਬਿਠਾਲਿਆ ਅਤੇ ਉਨ੍ਹਾਂ ਨੇ ਉਸ ਦੇ ਅੱਗੇ ਮਨਾਦੀ ਕਰਵਾਈ “ਗੋਡੇ ਨਿਵਾਓ ਅਤੇ ਮੱਥਾ ਟੇਕੋ,” ਇਸ ਤਰ੍ਹਾਂ ਉਸ ਨੇ ਯੂਸੁਫ਼ ਨੂੰ ਸਾਰੇ ਮਿਸਰ ਦੇਸ਼ ਉੱਤੇ ਪ੍ਰਧਾਨ ਨਿਯੁਕਤ ਕੀਤਾ। ");
INSERT INTO pan_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","ਫ਼ਿਰਊਨ ਨੇ ਯੂਸੁਫ਼ ਨੂੰ ਆਖਿਆ, ਮੈਂ ਫ਼ਿਰਊਨ ਹਾਂ, ਅਤੇ ਤੇਰੇ ਬਿਨ੍ਹਾਂ ਮਿਸਰ ਦੇ ਸਾਰੇ ਦੇਸ਼ ਵਿੱਚ ਕੋਈ ਮਨੁੱਖ ਆਪਣਾ ਹੱਥ-ਪੈਰ ਨਹੀਂ ਹਿਲਾਵੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","ਫ਼ਿਰਊਨ ਨੇ ਯੂਸੁਫ਼ ਦਾ ਨਾਮ ਸਾਫਨਥ ਪਾਨੇਆਹ ਰੱਖਿਆ ਅਤੇ ਉਸ ਨੂੰ ਊਨ ਦੇ ਜਾਜਕ ਪੋਟੀ-ਫ਼ਰਾ ਦੀ ਧੀ ਆਸਨਥ ਵਿਆਹ ਦਿੱਤੀ ਅਤੇ ਯੂਸੁਫ਼ ਮਿਸਰ ਦੇ ਸਾਰੇ ਦੇਸ਼ ਵਿੱਚ ਗਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","ਜਦ ਯੂਸੁਫ਼ ਮਿਸਰ ਦੇ ਰਾਜਾ ਫ਼ਿਰਊਨ ਦੇ ਸਨਮੁਖ ਖੜ੍ਹਾ ਹੋਇਆ ਤਾਂ ਉਹ ਤੀਹ ਸਾਲ ਦਾ ਸੀ ਅਤੇ ਯੂਸੁਫ਼ ਨੇ ਫ਼ਿਰਊਨ ਦੇ ਸਾਹਮਣਿਓਂ ਨਿੱਕਲ ਕੇ ਮਿਸਰ ਦੇ ਸਾਰੇ ਦੇਸ਼ ਵਿੱਚ ਦੌਰਾ ਕੀਤਾ। ");
INSERT INTO pan_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","ਭਰਪੂਰੀ ਦੇ ਸੱਤ ਸਾਲਾਂ ਵਿੱਚ ਧਰਤੀ ਉੱਤੇ ਭਰਪੂਰ ਫ਼ਸਲ ਹੋਈ। ");
INSERT INTO pan_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","ਤਦ ਉਸ ਨੇ ਉਨ੍ਹਾਂ ਸੱਤ ਸਾਲਾਂ ਵਿੱਚ ਜੋ ਮਿਸਰ ਦੇਸ਼ ਉੱਤੇ ਆਏ, ਸਾਰਾ ਅੰਨ ਇਕੱਠਾ ਕੀਤਾ ਅਤੇ ਨਗਰਾਂ ਵਿੱਚ ਰੱਖਿਆ ਅਤੇ ਹਰ ਇੱਕ ਨਗਰ ਦੇ ਨੇੜੇ-ਤੇੜੇ ਦੇ ਖੇਤਾਂ ਦਾ ਅੰਨ ਉਸੇ ਨਗਰ ਵਿੱਚ ਰੱਖਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","ਯੂਸੁਫ਼ ਨੇ ਢੇਰ ਸਾਰਾ ਅੰਨ ਸਮੁੰਦਰ ਦੀ ਰੇਤ ਵਾਂਗੂੰ ਜਮ੍ਹਾ ਕਰ ਲਿਆ ਅਤੇ ਉਹ ਇੰਨ੍ਹਾਂ ਜ਼ਿਆਦਾ ਸੀ ਕਿ ਉਨ੍ਹਾਂ ਨੇ ਉਸ ਦਾ ਲੇਖਾ ਕਰਨਾ ਛੱਡ ਦਿੱਤਾ ਕਿਉਂ ਜੋ ਉਹ ਲੇਖਿਓਂ ਬਾਹਰ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","ਯੂਸੁਫ਼ ਦੇ ਦੋ ਪੁੱਤਰ ਕਾਲ ਦੇ ਸਮੇਂ ਤੋਂ ਪਹਿਲਾਂ ਪੈਦਾ ਹੋਏ, ਜਿਨ੍ਹਾਂ ਨੂੰ ਊਨ ਸ਼ਹਿਰ ਦੇ ਜਾਜਕ ਪੋਟੀ-ਫ਼ਰਾ ਦੀ ਧੀ ਆਸਨਥ ਨੇ ਜਨਮ ਦਿੱਤਾ। ");
INSERT INTO pan_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","ਯੂਸੁਫ਼ ਨੇ ਪਹਿਲੌਠੇ ਦਾ ਨਾਮ ਮਨੱਸ਼ਹ ਰੱਖਿਆ ਕਿਉਂ ਜੋ ਉਸ ਨੇ ਆਖਿਆ ਕਿ ਪਰਮੇਸ਼ੁਰ ਨੇ ਮੈਨੂੰ ਮੇਰੇ ਸਾਰੇ ਕਸ਼ਟ ਅਤੇ ਮੇਰੇ ਪਿਤਾ ਦਾ ਸਾਰਾ ਘਰ ਭੁਲਾ ਦਿੱਤਾ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","ਦੂਜੇ ਦਾ ਨਾਮ ਇਹ ਆਖ ਕੇ ਇਫ਼ਰਾਈਮ ਰੱਖਿਆ ਕਿ ਪਰਮੇਸ਼ੁਰ ਨੇ ਮੈਨੂੰ ਮੇਰੇ ਦੁੱਖ ਦੇ ਦੇਸ਼ ਵਿੱਚ ਫਲਦਾਰ ਬਣਾਇਆ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","ਭਰਪੂਰੀ ਦੇ ਸੱਤ ਸਾਲ ਜਿਹੜੇ ਮਿਸਰ ਦੇਸ਼ ਉੱਤੇ ਆਏ ਸਨ, ਮੁੱਕ ਗਏ। ");
INSERT INTO pan_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","ਜਦ ਕਾਲ ਦੇ ਸੱਤ ਸਾਲ ਸ਼ੁਰੂ ਹੋਏ ਜਿਵੇਂ ਯੂਸੁਫ਼ ਨੇ ਆਖਿਆ ਸੀ, ਤਾਂ ਸਾਰੇ ਦੇਸਾਂ ਵਿੱਚ ਕਾਲ ਸੀ ਪਰ ਸਾਰੇ ਮਿਸਰ ਦੇਸ਼ ਵਿੱਚ ਰੋਟੀ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","ਜਦ ਮਿਸਰ ਦਾ ਸਾਰਾ ਦੇਸ਼ ਭੁੱਖਾ ਮਰਨ ਲੱਗਾ ਤਦ ਪਰਜਾ ਫ਼ਿਰਊਨ ਦੇ ਅੱਗੇ ਰੋਟੀ ਲਈ ਦੁਹਾਈ ਦੇਣ ਲੱਗੀ, ਅਤੇ ਫ਼ਿਰਊਨ ਨੇ ਸਾਰੇ ਮਿਸਰੀਆਂ ਨੂੰ ਆਖਿਆ, ਯੂਸੁਫ਼ ਕੋਲ ਜਾਓ ਅਤੇ ਜੋ ਕੁਝ ਉਹ ਆਖੇ ਸੋ ਕਰੋ। ");
INSERT INTO pan_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","ਸਾਰੀ ਧਰਤੀ ਉੱਤੇ ਕਾਲ ਸੀ ਤਾਂ ਯੂਸੁਫ਼ ਨੇ ਸਾਰੇ ਭੰਡਾਰ ਖੋਲ੍ਹ ਕੇ ਮਿਸਰੀਆਂ ਕੋਲ ਅੰਨ ਵੇਚਿਆ, ਕਿਉਂ ਜੋ ਮਿਸਰ ਦੇਸ਼ ਵਿੱਚ ਕਾਲ ਬਹੁਤ ਸਖ਼ਤ ਹੋ ਗਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","ਸਾਰੇ ਸੰਸਾਰ ਦੇ ਲੋਕ ਯੂਸੁਫ਼ ਦੇ ਕੋਲੋਂ ਅੰਨ ਖਰੀਦਣ ਲਈ ਮਿਸਰ ਵਿੱਚ ਆਉਣ ਲੱਗੇ ਕਿਉਂ ਜੋ ਸਾਰੀ ਧਰਤੀ ਉੱਤੇ ਕਾਲ ਬਹੁਤ ਸਖ਼ਤ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","ਜਦ ਯਾਕੂਬ ਨੇ ਸੁਣਿਆ ਕਿ ਮਿਸਰ ਵਿੱਚ ਅੰਨ ਹੈ ਤਾਂ ਯਾਕੂਬ ਨੇ ਆਪਣੇ ਪੁੱਤਰਾਂ ਨੂੰ ਆਖਿਆ, ਤੁਸੀਂ ਕਿਉਂ ਇੱਕ ਦੂਜੇ ਵੱਲ ਵੇਖਦੇ ਹੋ? ");
INSERT INTO pan_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","ਫਿਰ ਉਸ ਨੇ ਆਖਿਆ, ਵੇਖੋ ਮੈਂ ਸੁਣਿਆ ਹੈ ਕਿ ਮਿਸਰ ਵਿੱਚ ਅੰਨ ਹੈ। ਇਸ ਲਈ ਤੁਸੀਂ ਉੱਥੇ ਜਾਓ ਅਤੇ ਸਾਡੇ ਲਈ ਅੰਨ ਖਰੀਦ ਕੇ ਲੈ ਆਓ, ਤਾਂ ਜੋ ਅਸੀਂ ਜੀਉਂਦੇ ਰਹੀਏ ਅਤੇ ਮਰ ਨਾ ਜਾਈਏ। ");
INSERT INTO pan_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","ਸੋ ਯੂਸੁਫ਼ ਦੇ ਦਸੇ ਭਰਾ ਮਿਸਰ ਵਿੱਚ ਅੰਨ ਖਰੀਦਣ ਲਈ ਗਏ। ");
INSERT INTO pan_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","ਪਰ ਯੂਸੁਫ਼ ਦੇ ਭਰਾ ਬਿਨਯਾਮੀਨ ਨੂੰ ਯਾਕੂਬ ਨੇ ਉਸ ਦੇ ਭਰਾਵਾਂ ਦੇ ਨਾਲ ਨਾ ਭੇਜਿਆ ਕਿਉਂ ਜੋ ਉਸ ਨੇ ਆਖਿਆ ਕਿ ਕਿਤੇ ਉਸ ਦੇ ਉੱਤੇ ਕੋਈ ਬਿਪਤਾ ਨਾ ਆ ਪਵੇ। ");
INSERT INTO pan_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","ਇਸ ਤਰ੍ਹਾਂ ਜੋ ਲੋਕ ਅੰਨ ਖਰੀਦਣ ਲਈ ਆਏ ਸਨ, ਉਨ੍ਹਾਂ ਦੇ ਨਾਲ ਇਸਰਾਏਲ ਦੇ ਪੁੱਤਰ ਵੀ ਆਏ ਕਿਉਂਕਿ ਕਨਾਨ ਦੇਸ਼ ਵਿੱਚ ਭਾਰੀ ਕਾਲ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","ਯੂਸੁਫ਼ ਉਸ ਦੇਸ਼ ਉੱਤੇ ਹਾਕਮ ਸੀ ਅਤੇ ਉਸ ਦੇਸ਼ ਦੇ ਸਾਰੇ ਲੋਕਾਂ ਨੂੰ ਉਹੀ ਅੰਨ ਵੇਚਦਾ ਸੀ, ਇਸ ਲਈ ਜਦ ਯੂਸੁਫ਼ ਦੇ ਭਰਾ ਆਏ ਤਦ ਧਰਤੀ ਉੱਤੇ ਮੂੰਹ ਭਾਰ ਡਿੱਗ ਕੇ ਉਸ ਦੇ ਅੱਗੇ ਝੁਕੇ। ");
INSERT INTO pan_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","ਯੂਸੁਫ਼ ਨੇ ਆਪਣੇ ਭਰਾਵਾਂ ਨੂੰ ਵੇਖਿਆ ਅਤੇ ਉਨ੍ਹਾਂ ਨੂੰ ਪਹਿਚਾਣ ਲਿਆ ਪਰ ਉਸ ਨੇ ਆਪਣੇ ਆਪ ਨੂੰ ਉਨ੍ਹਾਂ ਦੇ ਅੱਗੇ ਅਜਨਬੀ ਬਣਾਇਆ ਅਤੇ ਉਨ੍ਹਾਂ ਨਾਲ ਸਖ਼ਤੀ ਨਾਲ ਬੋਲਿਆ ਅਤੇ ਉਨ੍ਹਾਂ ਨੂੰ ਪੁੱਛਿਆ, ਤੁਸੀਂ ਕਿੱਥੋਂ ਆਏ ਹੋ? ਤਾਂ ਉਨ੍ਹਾਂ ਨੇ ਆਖਿਆ, ਅਸੀਂ ਕਨਾਨ ਦੇਸ਼ ਤੋਂ ਅੰਨ ਮੁੱਲ ਲੈਣ ਲਈ ਆਏ ਹਾਂ। ");
INSERT INTO pan_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","ਯੂਸੁਫ਼ ਨੇ ਆਪਣੇ ਭਰਾਵਾਂ ਨੂੰ ਪਹਿਚਾਣ ਲਿਆ, ਪਰ ਉਨ੍ਹਾਂ ਨੇ ਉਸ ਨੂੰ ਨਾ ਪਛਾਣਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","ਤਦ ਯੂਸੁਫ਼ ਨੂੰ ਉਹ ਸੁਫ਼ਨੇ ਜਿਹੜੇ ਉਸ ਨੇ ਉਨ੍ਹਾਂ ਦੇ ਵਿਖੇ ਵੇਖੇ ਸਨ, ਯਾਦ ਆਏ ਅਤੇ ਉਸ ਨੇ ਉਨ੍ਹਾਂ ਨੂੰ ਆਖਿਆ, ਤੁਸੀਂ ਜਸੂਸ ਹੋ ਅਤੇ ਦੇਸ਼ ਦੀ ਦੁਰਦਸ਼ਾ ਵੇਖਣ ਲਈ ਆਏ ਹੋ। ");
INSERT INTO pan_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","ਉਨ੍ਹਾਂ ਨੇ ਉਸ ਨੂੰ ਆਖਿਆ, ਨਹੀਂ ਸੁਆਮੀ ਜੀ, ਤੁਹਾਡੇ ਦਾਸ ਅੰਨ ਮੁੱਲ ਲੈਣ ਆਏ ਹਾਂ। ");
INSERT INTO pan_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","ਅਸੀਂ ਸਾਰੇ ਇੱਕ ਮਨੁੱਖ ਦੇ ਪੁੱਤਰ ਹਾਂ ਅਤੇ ਅਸੀਂ ਇਮਾਨਦਾਰ ਹਾਂ। ਅਸੀਂ ਤੁਹਾਡੇ ਦਾਸ ਜਾਸੂਸ ਨਹੀਂ ਹਾਂ। ");
INSERT INTO pan_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","ਪਰ ਉਸ ਨੇ ਉਨ੍ਹਾਂ ਨੂੰ ਆਖਿਆ, ਨਹੀਂ, ਸਗੋਂ ਤੁਸੀਂ ਦੇਸ਼ ਦੀ ਦੁਰਦਸ਼ਾ ਵੇਖਣ ਆਏ ਹੋ। ");
INSERT INTO pan_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","ਉਨ੍ਹਾਂ ਨੇ ਆਖਿਆ, ਅਸੀਂ ਤੁਹਾਡੇ ਦਾਸ ਬਾਰਾਂ ਭਰਾ ਹਾਂ ਅਤੇ ਕਨਾਨ ਦੇਸ਼ ਦੇ ਇੱਕ ਹੀ ਮਨੁੱਖ ਦੇ ਪੁੱਤਰ ਹਾਂ ਅਤੇ ਵੇਖੋ, ਸਭ ਤੋਂ ਛੋਟਾ ਅੱਜ ਦੇ ਦਿਨ ਸਾਡੇ ਪਿਤਾ ਦੇ ਕੋਲ ਹੈ ਅਤੇ ਇੱਕ ਨਹੀਂ ਰਿਹਾ। ");
INSERT INTO pan_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","ਤਦ ਯੂਸੁਫ਼ ਨੇ ਉਨ੍ਹਾਂ ਨੂੰ ਆਖਿਆ, ਇਹ ਤਾਂ ਉਹੀ ਗੱਲ ਹੈ ਜਿਹੜੀ ਮੈਂ ਤੁਹਾਡੇ ਨਾਲ ਕੀਤੀ ਕਿ ਤੁਸੀਂ ਜਾਸੂਸ ਹੋ। ");
INSERT INTO pan_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","ਇਸੇ ਗੱਲ ਤੋਂ ਤੁਸੀਂ ਪਰਖੇ ਜਾਓਗੇ, ਫ਼ਿਰਊਨ ਦੀ ਜਾਨ ਦੀ ਸਹੁੰ ਜਦ ਤੱਕ ਤੁਹਾਡਾ ਛੋਟਾ ਭਰਾ ਇੱਥੇ ਨਹੀਂ ਆ ਜਾਂਦਾ ਤੁਸੀਂ ਐਥੋਂ ਨਹੀਂ ਜਾ ਸਕਦੇ। ");
INSERT INTO pan_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","ਤੁਸੀਂ ਆਪਣੇ ਵਿੱਚੋਂ ਇੱਕ ਨੂੰ ਭੇਜੋ ਕਿ ਉਹ ਤੁਹਾਡੇ ਭਰਾ ਨੂੰ ਲੈ ਆਵੇ ਪਰ ਤੁਸੀਂ ਇੱਥੇ ਕੈਦੀ ਹੋ ਕੇ ਰਹੋ ਤਾਂ ਜੋ ਤੁਹਾਡੀਆਂ ਗੱਲਾਂ ਪਰਖੀਆਂ ਜਾਣ ਕਿ ਤੁਹਾਡੇ ਵਿੱਚ ਸਚਿਆਈ ਹੈ ਪਰ ਜੇ ਨਹੀਂ ਤਾਂ ਫ਼ਿਰਊਨ ਦੀ ਜਾਨ ਦੀ ਸਹੁੰ ਤੁਸੀਂ ਜ਼ਰੂਰ ਜਸੂਸ ਹੋ। ");
INSERT INTO pan_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","ਉਸ ਨੇ ਉਨ੍ਹਾਂ ਨੂੰ ਤਿੰਨ ਦਿਨ ਤੱਕ ਇਕੱਠੇ ਕੈਦ ਵਿੱਚ ਬੰਦ ਰੱਖਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","ਤੀਜੇ ਦਿਨ ਯੂਸੁਫ਼ ਨੇ ਉਨ੍ਹਾਂ ਨੂੰ ਆਖਿਆ, ਅਜਿਹਾ ਕਰੋ ਤਾਂ ਜੀਉਂਦੇ ਰਹੋਗੇ, ਕਿਉਂ ਜੋ ਮੈਂ ਪਰਮੇਸ਼ੁਰ ਤੋਂ ਡਰਦਾ ਹਾਂ। ");
INSERT INTO pan_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","ਜੇ ਤੁਸੀਂ ਸੱਚੇ ਹੋ ਤਾਂ ਤੁਹਾਡੇ ਭਰਾਵਾਂ ਵਿੱਚੋਂ ਇੱਕ ਉਸੇ ਕੈਦਖ਼ਾਨੇ ਵਿੱਚ ਰੱਖਿਆ ਜਾਵੇ ਅਤੇ ਤੁਸੀਂ ਕਾਲ ਲਈ ਆਪਣੇ ਘਰ ਅੰਨ ਲੈ ਕੇ ਚਲੇ ਜਾਓ। ");
INSERT INTO pan_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","ਆਪਣੇ ਛੋਟੇ ਭਰਾ ਨੂੰ ਮੇਰੇ ਕੋਲ ਲੈ ਆਓ, ਤਾਂ ਜੋ ਤੁਹਾਡੀਆਂ ਗੱਲਾਂ ਪਰਖੀਆਂ ਜਾਣ ਅਤੇ ਤੁਸੀਂ ਨਾ ਮਰੋ ਤਾਂ ਉਨ੍ਹਾਂ ਨੇ ਉਸੇ ਤਰ੍ਹਾਂ ਹੀ ਕੀਤਾ। ");
INSERT INTO pan_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","ਉਨ੍ਹਾਂ ਭਰਾਵਾਂ ਨੇ ਇੱਕ ਦੂਜੇ ਨੂੰ ਆਖਿਆ, ਜ਼ਰੂਰ ਹੀ ਅਸੀਂ ਆਪਣੇ ਭਰਾ ਦੇ ਕਾਰਨ ਦੋਸ਼ੀ ਹਾਂ ਕਿਉਂਕਿ ਜਦ ਅਸੀਂ ਉਸ ਦੀ ਜਾਨ ਨੂੰ ਕਸ਼ਟ ਵਿੱਚ ਵੇਖਿਆ ਅਤੇ ਉਸ ਨੇ ਸਾਡੇ ਤਰਲੇ ਕੀਤੇ ਤਾਂ ਅਸੀਂ ਉਸ ਦੀ ਨਾ ਸੁਣੀ। ਇਸੇ ਕਰਕੇ ਇਹ ਬਿਪਤਾ ਸਾਡੇ ਉੱਤੇ ਆਈ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","ਤਦ ਰਊਬੇਨ ਨੇ ਉਨ੍ਹਾਂ ਨੂੰ ਉੱਤਰ ਦਿੱਤਾ, ਕੀ ਮੈਂ ਤੁਹਾਨੂੰ ਨਹੀਂ ਸੀ ਆਖਦਾ ਕਿ ਤੁਸੀਂ ਇਸ ਮੁੰਡੇ ਨਾਲ ਪਾਪ ਨਾ ਕਰੋ? ਪਰ ਤੁਸੀਂ ਮੇਰੀ ਨਾ ਸੁਣੀ ਅਤੇ ਵੇਖੋ, ਹੁਣ ਉਸ ਦੇ ਲਹੂ ਦੀ ਪੁੱਛ ਹੋਈ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","ਉਹ ਨਹੀਂ ਜਾਣਦੇ ਸਨ ਕਿ ਯੂਸੁਫ਼ ਉਨ੍ਹਾਂ ਦੀ ਭਾਸ਼ਾ ਸਮਝਦਾ ਹੈ ਕਿਉਂ ਜੋ ਉਨ੍ਹਾਂ ਦੇ ਵਿਚਕਾਰ ਇੱਕ ਤਰਜੁਮਾ ਕਰਨ ਵਾਲਾ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","ਤਦ ਉਹ ਉਨ੍ਹਾਂ ਤੋਂ ਇੱਕ ਪਾਸੇ ਹੋ ਕੇ ਰੋਇਆ ਅਤੇ ਫੇਰ ਉਨ੍ਹਾਂ ਕੋਲ ਮੁੜ ਕੇ ਉਨ੍ਹਾਂ ਨਾਲ ਗੱਲਾਂ ਕੀਤੀਆਂ ਅਤੇ ਉਨ੍ਹਾਂ ਵਿੱਚੋਂ ਸ਼ਿਮਓਨ ਨੂੰ ਲਿਆ ਅਤੇ ਉਨ੍ਹਾਂ ਦੀਆਂ ਅੱਖਾਂ ਦੇ ਸਾਹਮਣੇ ਉਸ ਨੂੰ ਬੰਦੀ ਬਣਾ ਲਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","ਫੇਰ ਯੂਸੁਫ਼ ਨੇ ਹੁਕਮ ਦਿੱਤਾ ਕਿ ਉਹ ਉਨ੍ਹਾਂ ਦੇ ਬੋਰਿਆਂ ਵਿੱਚ ਅੰਨ ਭਰ ਦੇਣ ਅਤੇ ਹਰ ਇੱਕ ਦੀ ਚਾਂਦੀ ਉਸ ਦੇ ਬੋਰੇ ਵਿੱਚ ਮੋੜ ਕੇ ਰੱਖ ਦੇਣ ਅਤੇ ਰਸਤੇ ਲਈ ਉਨ੍ਹਾਂ ਨੂੰ ਭੋਜਨ-ਸਮੱਗਰੀ ਦੇਣ ਤਾਂ ਉਨ੍ਹਾਂ ਨਾਲ ਅਜਿਹਾ ਹੀ ਕੀਤਾ ਗਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","ਉਨ੍ਹਾਂ ਨੇ ਆਪਣੇ ਗਧਿਆਂ ਉੱਤੇ ਆਪਣਾ ਅੰਨ ਲੱਦ ਲਿਆ ਅਤੇ ਉੱਥੋਂ ਤੁਰ ਪਏ। ");
INSERT INTO pan_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","ਜਦ ਇੱਕ ਨੇ ਪੜਾਉ ਉੱਤੇ ਆਪਣੇ ਗਧੇ ਨੂੰ ਚਾਰਾ ਦੇਣ ਲਈ ਆਪਣਾ ਬੋਰਾ ਖੋਲ੍ਹਿਆ ਤਾਂ ਉਸ ਨੇ ਆਪਣੀ ਚਾਂਦੀ ਵੇਖੀ ਅਤੇ ਵੇਖੋ ਉਹ ਉਸ ਦੇ ਬੋਰੇ ਦੇ ਮੂੰਹ ਉੱਤੇ ਰੱਖੀ ਹੋਈ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","ਉਸ ਨੇ ਆਪਣੇ ਭਰਾਵਾਂ ਨੂੰ ਆਖਿਆ, ਮੇਰੀ ਚਾਂਦੀ ਮੋੜ ਦਿੱਤੀ ਗਈ ਹੈ ਅਤੇ ਵੇਖੋ ਉਹ ਮੇਰੇ ਬੋਰੇ ਵਿੱਚ ਹੀ ਹੈ। ਤਦ ਉਨ੍ਹਾਂ ਦੇ ਦਿਲ ਬੈਠ ਗਏ ਅਤੇ ਕੰਬਦੇ ਹੋਏ ਇੱਕ ਦੂਜੇ ਨੂੰ ਆਖਣ ਲੱਗੇ, ਇਹ ਕੀ ਹੈ ਜੋ ਪਰਮੇਸ਼ੁਰ ਨੇ ਸਾਡੇ ਨਾਲ ਕੀਤਾ ਹੈ? ");
INSERT INTO pan_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","ਉਹ ਆਪਣੇ ਪਿਤਾ ਯਾਕੂਬ ਕੋਲ ਕਨਾਨ ਦੇਸ਼ ਵਿੱਚ ਆਏ ਅਤੇ ਸਭ ਕੁਝ ਜੋ ਉਨ੍ਹਾਂ ਉੱਤੇ ਬੀਤਿਆ ਸੀ, ਉਹ ਨੂੰ ਦੱਸਿਆ: ");
INSERT INTO pan_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","ਉਹ ਮਨੁੱਖ ਜਿਹੜਾ ਉਸ ਦੇਸ਼ ਦਾ ਹਾਕਮ ਹੈ, ਸਾਡੇ ਨਾਲ ਸਖਤੀ ਨਾਲ ਬੋਲਿਆ ਅਤੇ ਸਾਨੂੰ ਦੇਸ਼ ਦਾ ਜਸੂਸ ਠਹਿਰਾਇਆ। ");
INSERT INTO pan_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","ਅਸੀਂ ਉਸ ਨੂੰ ਆਖਿਆ, ਅਸੀਂ ਸੱਚੇ ਹਾਂ ਅਤੇ ਜਸੂਸ ਨਹੀਂ ਹਾਂ। ");
INSERT INTO pan_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","ਅਸੀਂ ਬਾਰਾਂ ਭਰਾ ਇੱਕ ਹੀ ਪਿਤਾ ਦੇ ਪੁੱਤਰ ਹਾਂ। ਇੱਕ ਨਹੀਂ ਰਿਹਾ ਅਤੇ ਛੋਟਾ ਅੱਜ ਦੇ ਦਿਨ ਆਪਣੇ ਪਿਤਾ ਦੇ ਕੋਲ ਕਨਾਨ ਦੇਸ਼ ਵਿੱਚ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","ਤਦ ਉਸ ਮਨੁੱਖ ਨੇ ਜਿਹੜਾ ਉਸ ਦੇਸ਼ ਦਾ ਹਾਕਮ ਹੈ ਆਖਿਆ, ਮੈਂ ਇਸ ਤੋਂ ਜਾਣਾਂਗਾ ਕਿ ਤੁਸੀਂ ਸੱਚੇ ਹੋ, ਜੇਕਰ ਆਪਣਾ ਇੱਕ ਭਰਾ ਮੇਰੇ ਕੋਲ ਛੱਡੋ ਅਤੇ ਆਪਣੇ ਘਰ ਵਾਸਤੇ ਕਾਲ ਲਈ ਅੰਨ ਲੈ ਕੇ ਚਲੇ ਜਾਓ ");
INSERT INTO pan_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","ਅਤੇ ਆਪਣਾ ਛੋਟਾ ਭਰਾ ਮੇਰੇ ਕੋਲ ਲੈ ਆਓ, ਤਦ ਮੈਂ ਜਾਣਾਂਗਾ ਕਿ ਤੁਸੀਂ ਖੋਜੀ ਨਹੀਂ ਹੋ, ਸਗੋਂ ਤੁਸੀਂ ਸੱਚੇ ਹੋ। ਫਿਰ ਮੈਂ ਤੁਹਾਡੇ ਭਰਾ ਨੂੰ ਤੁਹਾਨੂੰ ਦੇ ਦਿਆਂਗਾ ਅਤੇ ਤੁਸੀਂ ਇਸ ਦੇਸ਼ ਵਿੱਚ ਵਪਾਰ ਕਰ ਸਕਦੇ ਹੋ। ");
INSERT INTO pan_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","ਜਦ ਉਹ ਆਪਣੇ ਬੋਰੇ ਖਾਲੀ ਕਰ ਰਹੇ ਸਨ ਤਾਂ ਵੇਖੋ ਹਰ ਇੱਕ ਦੀ ਚਾਂਦੀ ਦੀ ਥੈਲੀ ਉਸ ਦੇ ਬੋਰੇ ਵਿੱਚ ਸੀ ਤਾਂ ਉਹ ਅਤੇ ਉਨ੍ਹਾਂ ਦਾ ਪਿਤਾ ਆਪਣੀਆਂ ਥੈਲੀਆਂ ਨੂੰ ਵੇਖ ਕੇ ਡਰ ਗਏ। ");
INSERT INTO pan_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","ਉਨ੍ਹਾਂ ਦੇ ਪਿਤਾ ਯਾਕੂਬ ਨੇ ਉਨ੍ਹਾਂ ਨੂੰ ਆਖਿਆ, ਤੁਸੀਂ ਮੈਨੂੰ ਮੇਰੀ ਸੰਤਾਨ ਤੋਂ ਵਾਂਝਿਆਂ ਕੀਤਾ ਹੈ। ਯੂਸੁਫ਼ ਨਹੀਂ ਰਿਹਾ ਅਤੇ ਸ਼ਿਮਓਨ ਵੀ ਨਹੀਂ ਆਇਆ, ਹੁਣ ਤੁਸੀਂ ਬਿਨਯਾਮੀਨ ਨੂੰ ਲੈ ਜਾਣਾ ਚਾਹੁੰਦੇ ਹੋ। ਇਹ ਸਾਰੀਆਂ ਗੱਲਾਂ ਮੇਰੇ ਵਿਰੁੱਧ ਹੋਈਆਂ ਹਨ। ");
INSERT INTO pan_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","ਤਦ ਰਊਬੇਨ ਨੇ ਆਪਣੇ ਪਿਤਾ ਨੂੰ ਇਹ ਆਖਿਆ, ਜੇ ਮੈਂ ਉਸ ਨੂੰ ਤੇਰੇ ਕੋਲ ਨਾ ਲਿਆਵਾਂ ਤਾਂ ਤੂੰ ਮੇਰੇ ਦੋਹਾਂ ਪੁੱਤਰਾਂ ਨੂੰ ਮਾਰ ਦੇਵੀਂ। ਤੂੰ ਉਹ ਨੂੰ ਮੇਰੇ ਨਾਲ ਭੇਜ ਦੇ ਅਤੇ ਮੈਂ ਉਸ ਨੂੰ ਤੇਰੇ ਕੋਲ ਮੋੜ ਲਿਆਵਾਂਗਾ। ");
INSERT INTO pan_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","ਪਰ ਉਸ ਨੇ ਆਖਿਆ, ਮੇਰਾ ਪੁੱਤਰ ਤੁਹਾਡੇ ਨਾਲ ਨਹੀਂ ਜਾਵੇਗਾ ਕਿਉਂ ਜੋ ਉਸ ਦਾ ਭਰਾ ਮਰ ਗਿਆ ਅਤੇ ਉਹ ਇਕੱਲਾ ਰਹਿ ਗਿਆ ਹੈ। ਜੇ ਰਸਤੇ ਵਿੱਚ ਜਿੱਥੋਂ ਤੁਸੀਂ ਜਾਂਦੇ ਹੋ ਕੋਈ ਬਿਪਤਾ ਉਸ ਦੇ ਉੱਤੇ ਆਣ ਪਵੇ, ਤਾਂ ਤੁਸੀਂ ਮੈਨੂੰ ਇਸ ਬੁਢਾਪੇ ਵਿੱਚ ਦੁੱਖ ਨਾਲ ਪਤਾਲ ਵਿੱਚ ਉਤਾਰੋਗੇ। ");
INSERT INTO pan_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","ਕਨਾਨ ਦੇਸ਼ ਉੱਤੇ ਕਾਲ ਬਹੁਤ ਹੀ ਭਿਅੰਕਰ ਹੋ ਗਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","ਜਦ ਉਹ ਅੰਨ ਜਿਹੜਾ ਉਹ ਮਿਸਰ ਤੋਂ ਲਿਆਏ ਸਨ, ਖ਼ਤਮ ਹੋ ਗਿਆ ਤਦ ਉਨ੍ਹਾਂ ਦੇ ਪਿਤਾ ਨੇ ਉਨ੍ਹਾਂ ਨੂੰ ਆਖਿਆ, ਮੁੜ ਕੇ ਸਾਡੇ ਲਈ ਕੁਝ ਅੰਨ ਮੁੱਲ ਲੈ ਆਓ। ");
INSERT INTO pan_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","ਤਦ ਯਹੂਦਾਹ ਨੇ ਉਹ ਨੂੰ ਆਖਿਆ ਕਿ ਉਸ ਮਨੁੱਖ ਨੇ ਸਾਨੂੰ ਚੇਤਾਵਨੀ ਦੇ ਕੇ ਆਖਿਆ ਸੀ, ਜੇ ਤੁਹਾਡਾ ਭਰਾ ਤੁਹਾਡੇ ਨਾਲ ਨਾ ਹੋਵੇ ਤੁਸੀਂ ਮੇਰਾ ਮੂੰਹ ਨਹੀਂ ਵੇਖੋਗੇ। ");
INSERT INTO pan_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","ਸੋ ਜੇ ਤੂੰ ਸਾਡੇ ਭਰਾ ਨੂੰ ਸਾਡੇ ਨਾਲ ਭੇਜਦਾ ਹੈਂ ਤਾਂ ਅਸੀਂ ਤੇਰੇ ਲਈ ਅੰਨ ਮੁੱਲ ਲੈ ਆਵਾਂਗੇ, ");
INSERT INTO pan_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","ਪਰ ਜੇ ਤੂੰ ਨਾ ਭੇਜੇਂਗਾ ਤਾਂ ਅਸੀਂ ਨਹੀਂ ਜਾਂਵਾਂਗੇ ਕਿਉਂ ਜੋ ਉਸ ਮਨੁੱਖ ਨੇ ਸਾਨੂੰ ਆਖਿਆ ਸੀ, ਜੇ ਤੁਹਾਡਾ ਭਰਾ ਤੁਹਾਡੇ ਨਾਲ ਨਾ ਹੋਵੇ ਤੁਸੀਂ ਮੇਰਾ ਮੂੰਹ ਨਹੀਂ ਵੇਖੋਗੇ। ");
INSERT INTO pan_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","ਫੇਰ ਇਸਰਾਏਲ ਨੇ ਆਖਿਆ, ਤੁਸੀਂ ਕਿਉਂ ਮੇਰੇ ਨਾਲ ਇਹ ਬੁਰਿਆਈ ਕੀਤੀ ਕਿ ਉਸ ਮਨੁੱਖ ਨੂੰ ਦੱਸਿਆ ਕਿ ਸਾਡਾ ਇੱਕ ਹੋਰ ਭਰਾ ਵੀ ਹੈ? ");
INSERT INTO pan_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","ਤਦ ਉਨ੍ਹਾਂ ਨੇ ਆਖਿਆ ਕਿ ਉਸ ਮਨੁੱਖ ਨੇ ਤੰਗ ਕਰ ਕੇ ਸਾਡੇ ਅਤੇ ਸਾਡੇ ਰਿਸ਼ਤੇਦਾਰਾਂ ਦੇ ਵਿਖੇ ਪੁੱਛਿਆ ਕਿ ਤੁਹਾਡਾ ਪਿਤਾ ਅਜੇ ਤੱਕ ਜੀਉਂਦਾ ਹੈ ਅਤੇ ਤੁਹਾਡਾ ਕੋਈ ਹੋਰ ਭਰਾ ਵੀ ਹੈ? ਤਦ ਅਸੀਂ ਇਨ੍ਹਾਂ ਗੱਲਾਂ ਦੇ ਅਨੁਸਾਰ ਉਹ ਨੂੰ ਦੱਸਿਆ। ਸਾਨੂੰ ਕੀ ਪਤਾ ਸੀ ਕਿ ਉਹ ਸਾਨੂੰ ਆਖੇਗਾ ਜੋ ਆਪਣੇ ਭਰਾ ਨੂੰ ਨਾਲ ਲਿਆਓ? ");
INSERT INTO pan_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","ਫੇਰ ਯਹੂਦਾਹ ਨੇ ਆਪਣੇ ਪਿਤਾ ਇਸਰਾਏਲ ਨੂੰ ਆਖਿਆ, ਮੁੰਡੇ ਨੂੰ ਮੇਰੇ ਨਾਲ ਭੇਜ ਦੇ ਤਾਂ ਜੋ ਅਸੀਂ ਜਾਈਏ, ਤੇ ਅਸੀਂ ਜੀਉਂਦੇ ਰਹੀਏ ਅਤੇ ਮਰ ਨਾ ਜਾਈਏ, ਅਸੀਂ ਵੀ ਅਤੇ ਤੂੰ ਵੀ ਅਤੇ ਸਾਡੇ ਬੱਚੇ ਵੀ। ");
INSERT INTO pan_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","ਮੈਂ ਉਸ ਲਈ ਜ਼ਿੰਮੇਵਾਰ ਹਾਂ। ਉਸ ਨੂੰ ਤੂੰ ਮੇਰੇ ਹੱਥੋਂ ਵਾਪਿਸ ਮੰਗੀ। ਜੇ ਮੈਂ ਉਸ ਨੂੰ ਤੇਰੇ ਕੋਲ ਨਾ ਲਿਆਵਾਂ ਅਤੇ ਤੇਰੇ ਸਨਮੁਖ ਨਾ ਬਿਠਾਵਾਂ ਤਦ ਮੈਂ ਸਦਾ ਲਈ ਤੇਰਾ ਦੋਸ਼ੀ ਠਹਿਰਾਂਗਾ। ");
INSERT INTO pan_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","ਜੇਕਰ ਅਸੀਂ ਐਨਾ ਸਮਾਂ ਨਾ ਲਾਉਂਦੇ ਤਾਂ ਹੁਣ ਤੱਕ ਦੂਜੀ ਵਾਰ ਵਾਪਿਸ ਆ ਜਾਂਦੇ। ");
INSERT INTO pan_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","ਤਦ ਉਨ੍ਹਾਂ ਦੇ ਪਿਤਾ ਇਸਰਾਏਲ ਨੇ ਉਨ੍ਹਾਂ ਨੂੰ ਆਖਿਆ, ਜੇ ਸੱਚ-ਮੁੱਚ ਅਜਿਹਾ ਹੀ ਹੈ ਤਾਂ ਹੁਣ ਇਸ ਤਰ੍ਹਾਂ ਕਰੋ ਕਿ ਇਸ ਦੇਸ਼ ਦੀ ਸਭ ਤੋਂ ਉੱਤਮ ਪੈਦਾਵਾਰ ਆਪਣਿਆਂ ਬੋਰਿਆਂ ਵਿੱਚ ਰੱਖ ਕੇ ਉਸ ਮਨੁੱਖ ਲਈ ਭੇਟ ਦੇ ਤੌਰ ਤੇ ਲੈ ਜਾਓ: ਅਰਥਾਤ ਥੋੜ੍ਹਾ ਗੁੱਗਲ, ਥੋੜ੍ਹਾ ਸ਼ਹਿਦ, ਗਰਮ ਮਸਾਲਾ, ਗੰਧਰਸ, ਪਿਸਤਾ ਅਤੇ ਬਦਾਮ। ");
INSERT INTO pan_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","ਦੁੱਗਣੀ ਚਾਂਦੀ ਆਪਣੇ ਹੱਥਾਂ ਵਿੱਚ ਲੈ ਜਾਓ ਅਤੇ ਉਹ ਚਾਂਦੀ ਜਿਹੜੀ ਤੁਹਾਡਿਆਂ ਬੋਰਿਆਂ ਦੇ ਮੂੰਹ ਉੱਤੇ ਰੱਖ ਕੇ ਵਾਪਿਸ ਕੀਤੀ ਗਈ, ਉਸ ਨੂੰ ਵੀ ਆਪਣੇ ਹੱਥਾਂ ਵਿੱਚ ਲੈ ਜਾਓ। ਸ਼ਾਇਦ ਇਹ ਭੁੱਲ ਹੋ ਗਈ ਹੋਵੇ। ");
INSERT INTO pan_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","ਆਪਣੇ ਭਰਾ ਨੂੰ ਵੀ ਨਾਲ ਲੈ ਕੇ ਉਸ ਮਨੁੱਖ ਕੋਲ ਫੇਰ ਜਾਓ। ");
INSERT INTO pan_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","ਸਰਬ ਸ਼ਕਤੀਮਾਨ ਪਰਮੇਸ਼ੁਰ ਤੁਹਾਨੂੰ ਉਸ ਮਨੁੱਖ ਵੱਲੋਂ ਕਿਰਪਾ ਬਖ਼ਸ਼ੇ, ਜਿਸ ਕਾਰਨ ਉਹ ਤੁਹਾਡੇ ਦੂਜੇ ਭਰਾ ਅਤੇ ਬਿਨਯਾਮੀਨ ਨੂੰ ਤੁਹਾਡੇ ਨਾਲ ਭੇਜ ਦੇਵੇ ਅਤੇ ਜੇ ਮੈਂ ਆਪਣੀ ਸੰਤਾਨ ਤੋਂ ਵਾਂਝਾ ਹੋਇਆ ਸੋ ਹੋਇਆ। ");
INSERT INTO pan_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","ਉਨ੍ਹਾਂ ਮਨੁੱਖਾਂ ਨੇ ਉਹ ਭੇਟ ਅਤੇ ਦੁੱਗਣੀ ਚਾਂਦੀ ਆਪਣਿਆਂ ਹੱਥਾਂ ਵਿੱਚ ਲੈ ਕੇ, ਬਿਨਯਾਮੀਨ ਨੂੰ ਵੀ ਆਪਣੇ ਨਾਲ ਲਿਆ ਅਤੇ ਉੱਠ ਕੇ ਮਿਸਰ ਨੂੰ ਚਲੇ ਗਏ ਅਤੇ ਯੂਸੁਫ਼ ਦੇ ਸਾਹਮਣੇ ਹਾਜ਼ਰ ਹੋਏ। ");
INSERT INTO pan_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","ਜਦੋਂ ਯੂਸੁਫ਼ ਨੇ ਉਨ੍ਹਾਂ ਦੇ ਨਾਲ ਬਿਨਯਾਮੀਨ ਨੂੰ ਵੇਖਿਆ ਤਾਂ ਉਸ ਨੇ ਘਰ ਦੇ ਅਧਿਕਾਰੀ ਨੂੰ ਆਖਿਆ ਕਿ ਇਨ੍ਹਾਂ ਮਨੁੱਖਾਂ ਨੂੰ ਘਰ ਲੈ ਜਾ ਅਤੇ ਪਸ਼ੂ ਮਾਰ ਕੇ ਭੋਜਨ ਤਿਆਰ ਕਰ ਕਿਉਂ ਜੋ ਇਹ ਮਨੁੱਖ ਦੁਪਹਿਰ ਨੂੰ ਮੇਰੇ ਨਾਲ ਭੋਜਨ ਖਾਣਗੇ। ");
INSERT INTO pan_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","ਤਦ ਉਹ ਮਨੁੱਖ ਯੂਸੁਫ਼ ਦੇ ਹੁਕਮ ਦੇ ਅਨੁਸਾਰ ਉਨ੍ਹਾਂ ਮਨੁੱਖਾਂ ਨੂੰ ਉਸ ਦੇ ਘਰ ਲੈ ਗਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","ਜਦ ਉਹ ਯੂਸੁਫ਼ ਦੇ ਘਰ ਪਹੁੰਚਾਏ ਗਏ ਤਦ ਉਹ ਆਪਸ ਵਿੱਚ ਡਰ ਕੇ ਆਖਣ ਲੱਗੇ, ਉਸ ਚਾਂਦੀ ਦੇ ਕਾਰਨ ਜਿਹੜੀ ਪਹਿਲੀ ਵਾਰ ਸਾਡਿਆਂ ਬੋਰਿਆਂ ਵਿੱਚ ਮੁੜੀ ਸੀ, ਅਸੀਂ ਇੱਥੇ ਲਿਆਂਦੇ ਗਏ ਹਾਂ ਤਾਂ ਜੋ ਉਹ ਸਾਡੇ ਉੱਤੇ ਵਾਰ ਕਰ ਕੇ ਸਾਨੂੰ ਆਪਣਾ ਗ਼ੁਲਾਮ ਬਣਾਵੇ ਅਤੇ ਸਾਡੇ ਗਧਿਆਂ ਨੂੰ ਵੀ ਖੋਹ ਲਵੇ। ");
INSERT INTO pan_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","ਤਦ ਉਹ ਯੂਸੁਫ਼ ਦੇ ਘਰ ਦੇ ਅਧਿਕਾਰੀ ਦੇ ਨੇੜੇ ਜਾ ਕੇ ਘਰ ਦੇ ਦਰਵਾਜ਼ੇ ਉੱਤੇ ਉਸ ਨੂੰ ਬੋਲੇ ");
INSERT INTO pan_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","ਅਤੇ ਉਨ੍ਹਾਂ ਨੇ ਆਖਿਆ ਸੁਆਮੀ ਜੀ, ਜਦੋਂ ਅਸੀਂ ਪਹਿਲੀ ਵਾਰ ਅੰਨ ਖਰੀਦਣ ਆਏ ਸੀ ");
INSERT INTO pan_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","ਤਦ ਅਸੀਂ ਸਰਾਂ ਵਿੱਚ ਪਹੁੰਚ ਕੇ ਆਪਣਿਆਂ ਬੋਰਿਆਂ ਨੂੰ ਖੋਲ੍ਹਿਆ ਅਤੇ ਵੇਖੋ ਹਰ ਇੱਕ ਦੀ ਚਾਂਦੀ ਉਸ ਦੀ ਬੋਰੀ ਦੇ ਮੂੰਹ ਉੱਤੇ ਪਈ ਹੋਈ ਸੀ। ਉਹ ਸਾਡੀ ਪੂਰੀ ਚਾਂਦੀ ਸੀ ਅਤੇ ਅਸੀਂ ਉਹ ਨੂੰ ਮੁੜ ਆਪਣੇ ਹੱਥਾਂ ਵਿੱਚ ਲੈ ਆਏ ਹਾਂ। ");
INSERT INTO pan_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","ਹੋਰ ਚਾਂਦੀ ਵੀ ਅੰਨ ਮੁੱਲ ਲੈਣ ਲਈ ਅਸੀਂ ਆਪਣੇ ਹੱਥਾਂ ਵਿੱਚ ਲਿਆਏ ਹਾਂ ਅਤੇ ਨਹੀਂ ਜਾਣਦੇ ਕਿ ਸਾਡੀ ਉਹ ਚਾਂਦੀ ਸਾਡੀਆਂ ਬੋਰੀਆਂ ਵਿੱਚ ਕਿਸ ਨੇ ਰੱਖ ਦਿੱਤੀ। ");
INSERT INTO pan_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","ਤਾਂ ਉਸ ਨੇ ਆਖਿਆ, ਤੁਹਾਡੀ ਸਲਾਮਤੀ ਹੋਵੇ। ਤੁਸੀਂ ਡਰੋ ਨਾ, ਤੁਹਾਡੇ ਪਰਮੇਸ਼ੁਰ ਅਤੇ ਤੁਹਾਡੇ ਪਿਤਾ ਦੇ ਪਰਮੇਸ਼ੁਰ ਨੇ ਤੁਹਾਡੀਆਂ ਬੋਰੀਆਂ ਵਿੱਚ ਤੁਹਾਨੂੰ ਪਦਾਰਥ ਦਿੱਤਾ। ਤੁਹਾਡੀ ਚਾਂਦੀ ਮੈਨੂੰ ਮਿਲ ਗਈ ਹੈ। ਫੇਰ ਉਹ ਸ਼ਿਮਓਨ ਨੂੰ ਬਾਹਰ ਉਨ੍ਹਾਂ ਦੇ ਕੋਲ ਲੈ ਆਇਆ। ");
INSERT INTO pan_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","ਤਦ ਉਹ ਪੁਰਖ ਉਨ੍ਹਾਂ ਮਨੁੱਖਾਂ ਨੂੰ ਯੂਸੁਫ਼ ਦੇ ਘਰ ਲੈ ਗਿਆ ਅਤੇ ਉਨ੍ਹਾਂ ਨੂੰ ਪਾਣੀ ਦਿੱਤਾ ਤਾਂ ਉਨ੍ਹਾਂ ਨੇ ਆਪਣੇ ਪੈਰ ਧੋਤੇ ਅਤੇ ਉਸ ਨੇ ਉਨ੍ਹਾਂ ਦੇ ਗਧਿਆਂ ਨੂੰ ਚਾਰਾ ਦਿੱਤਾ। ");
INSERT INTO pan_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","ਤਦ ਉਨ੍ਹਾਂ ਨੇ ਯੂਸੁਫ਼ ਦੇ ਆਉਣ ਦੀ ਦੁਪਹਿਰ ਤੱਕ ਉਡੀਕ ਵਿੱਚ ਸੁਗ਼ਾਤ ਤਿਆਰ ਕੀਤੀ ਕਿਉਂ ਜੋ ਉਨ੍ਹਾਂ ਸੁਣਿਆ ਜੋ ਅਸੀਂ ਐਥੇ ਹੀ ਰੋਟੀ ਖਾਵਾਂਗੇ। ");
INSERT INTO pan_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","ਜਦ ਯੂਸੁਫ਼ ਘਰ ਆਇਆ ਤਾਂ ਓਹ ਉਸ ਦੇ ਲਈ ਘਰ ਵਿੱਚ ਸੁਗ਼ਾਤ ਲੈ ਆਏ ਜਿਹੜੀ ਉਨ੍ਹਾਂ ਦੇ ਹੱਥਾਂ ਵਿੱਚ ਸੀ ਅਤੇ ਉਨ੍ਹਾਂ ਨੇ ਆਪਣੇ ਆਪ ਨੂੰ ਉਸ ਦੇ ਅੱਗੇ ਝੁਕਾਇਆ। ");
INSERT INTO pan_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","ਉਸ ਨੇ ਉਨ੍ਹਾਂ ਦੀ ਸੁੱਖ-ਸਾਂਦ ਪੁੱਛੀ ਅਤੇ ਆਖਿਆ, ਕੀ ਤੁਹਾਡਾ ਪਿਤਾ ਚੰਗਾ ਭਲਾ ਹੈ? ਉਹ ਬਜ਼ੁਰਗ ਜਿਸ ਦੇ ਵਿਖੇ ਤੁਸੀਂ ਆਖਿਆ ਸੀ ਜੀਉਂਦਾ ਹੈ? ");
INSERT INTO pan_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","ਉਨ੍ਹਾਂ ਆਖਿਆ, ਤੁਹਾਡਾ ਦਾਸ ਸਾਡਾ ਪਿਤਾ ਸਲਾਮਤ ਹੈ ਅਤੇ ਅੱਜ ਤੱਕ ਜੀਉਂਦਾ ਹੈ ਅਤੇ ਉਨ੍ਹਾਂ ਉਸ ਦੇ ਅੱਗੇ ਸਿਰ ਝੁਕਾ ਕੇ ਆਪ ਨੂੰ ਝੁਕਾਇਆ। ");
INSERT INTO pan_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","ਤਦ ਉਸ ਨੇ ਆਪਣੀਆਂ ਅੱਖਾਂ ਚੁੱਕ ਕੇ ਆਪਣੇ ਸੱਕੇ ਭਰਾ ਬਿਨਯਾਮੀਨ ਨੂੰ ਵੇਖਿਆ ਅਤੇ ਆਖਿਆ, ਜਿਸ ਛੋਟੇ ਭਰਾ ਦੇ ਵਿਖੇ ਤੁਸੀਂ ਮੈਨੂੰ ਆਖਿਆ ਸੀ, ਕੀ ਇਹੋ ਹੈ? ਅਤੇ ਉਸ ਨੇ ਆਖਿਆ, ਮੇਰੇ ਪੁੱਤਰ ਪਰਮੇਸ਼ੁਰ ਤੇਰੇ ਉੱਤੇ ਦਯਾ ਕਰੇ। ");
INSERT INTO pan_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","ਤਦ ਯੂਸੁਫ਼ ਨੇ ਛੇਤੀ ਕੀਤੀ ਕਿਉਂ ਜੋ ਉਸ ਦਾ ਮਨ ਆਪਣੇ ਭਰਾ ਲਈ ਭਰ ਆਇਆ, ਉਹ ਕਿਤੇ ਰੋਣਾ ਚਾਹੁੰਦਾ ਸੀ ਸੋ ਉਹ ਆਪਣੀ ਕੋਠੜੀ ਵਿੱਚ ਗਿਆ ਅਤੇ ਉੱਥੇ ਰੋਇਆ। ");
INSERT INTO pan_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","ਫੇਰ ਉਸ ਨੇ ਆਪਣਾ ਮੂੰਹ ਧੋਤਾ ਅਤੇ ਬਾਹਰ ਆਇਆ ਅਤੇ ਆਪਣੇ ਆਪ ਨੂੰ ਸੰਭਾਲ ਕੇ ਆਖਿਆ, ਰੋਟੀ ਪਰੋਸੋ। ");
INSERT INTO pan_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","ਤਾਂ ਉਨ੍ਹਾਂ ਨੇ ਯੂਸੁਫ਼ ਦੇ ਲਈ ਵੱਖਰੀ ਅਤੇ ਉਨ੍ਹਾਂ ਲਈ ਵੱਖਰੀ ਅਤੇ ਮਿਸਰੀਆਂ ਲਈ ਜਿਹੜੇ ਉਹ ਦੇ ਨਾਲ ਖਾਂਦੇ ਸਨ, ਇਸ ਲਈ ਵੱਖਰੀ ਰੋਟੀ ਰੱਖੀ ਕਿਉਂ ਜੋ ਮਿਸਰੀ ਇਬਰਾਨੀਆਂ ਦੇ ਨਾਲ ਰੋਟੀ ਨਹੀਂ ਖਾ ਸਕਦੇ ਸਨ ਕਿਉਂ ਜੋ ਇਹ ਮਿਸਰੀਆਂ ਲਈ ਤੁੱਛ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","ਓਹ ਉਸ ਦੇ ਅੱਗੇ ਬੈਠ ਗਏ, ਪਹਿਲੌਠਾ ਆਪਣੇ ਪਹਿਲੌਠੇਪਣ ਦੇ ਅਨੁਸਾਰ ਅਤੇ ਛੋਟਾ ਆਪਣੀ ਉਮਰ ਦੇ ਅਨੁਸਾਰ ਅਤੇ ਉਹ ਮਨੁੱਖ ਹੈਰਾਨੀ ਨਾਲ ਇੱਕ ਦੂਜੇ ਵੱਲ ਵੇਖਦੇ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","ਤਦ ਉਸ ਆਪਣੇ ਅੱਗਿਓਂ ਭੋਜਨ ਪਦਾਰਥ ਚੁਕਵਾ ਕੇ ਉਨ੍ਹਾਂ ਨੂੰ ਦਿੱਤੇ ਅਤੇ ਬਿਨਯਾਮੀਨ ਦਾ ਥਾਲ ਉਨ੍ਹਾਂ ਦੇ ਥਾਲਾਂ ਨਾਲੋਂ ਪੰਜ ਗੁਣਾ ਵੱਧ ਸੀ, ਸੋ ਉਨ੍ਹਾਂ ਉਹ ਦੇ ਨਾਲ ਖਾਧਾ ਪੀਤਾ ਅਤੇ ਅਨੰਦ ਮਨਾਇਆ। ");
INSERT INTO pan_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","ਤਦ ਉਸ ਨੇ ਆਪਣੇ ਘਰ ਦੇ ਮੁਖੀਏ ਨੂੰ ਹੁਕਮ ਦਿੱਤਾ ਕਿ ਇਨ੍ਹਾਂ ਮਨੁੱਖਾਂ ਦੇ ਬੋਰਿਆਂ ਵਿੱਚ ਜਿੰਨ੍ਹਾਂ ਉਹ ਲੈ ਸਕਣ ਅੰਨ ਭਰ ਦੇ ਅਤੇ ਹਰ ਇੱਕ ਦੀ ਚਾਂਦੀ ਉਸ ਦੇ ਬੋਰੇ ਦੇ ਮੂੰਹ ਵਿੱਚ ਰੱਖਦੇ ");
INSERT INTO pan_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","ਅਤੇ ਮੇਰਾ ਚਾਂਦੀ ਦਾ ਪਿਆਲਾ ਸਭ ਤੋਂ ਛੋਟੇ ਦੇ ਬੋਰੇ ਦੇ ਮੂੰਹ ਉੱਤੇ ਉਸ ਦੇ ਅੰਨ ਖਰੀਦਣ ਦੀ ਚਾਂਦੀ ਸਮੇਤ ਰੱਖਦੇ। ਸੋ ਉਸ ਨੇ ਯੂਸੁਫ਼ ਦੇ ਆਖੇ ਅਨੁਸਾਰ ਹੀ ਕੀਤਾ। ");
INSERT INTO pan_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","ਸਵੇਰ ਹੁੰਦਿਆਂ ਹੀ ਉਹ ਮਨੁੱਖ ਅਤੇ ਉਨ੍ਹਾਂ ਦੇ ਗਧੇ ਤੋਰ ਦਿੱਤੇ ਗਏ। ");
INSERT INTO pan_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","ਓਹ ਨਗਰ ਤੋਂ ਬਾਹਰ ਅਜੇ ਦੂਰ ਨਹੀਂ ਗਏ ਸਨ ਕਿ ਯੂਸੁਫ਼ ਨੇ ਆਪਣੇ ਘਰ ਦੇ ਮੁਖੀਏ ਨੂੰ ਹੁਕਮ ਦਿੱਤਾ, ਉੱਠ ਉਨ੍ਹਾਂ ਮਨੁੱਖਾਂ ਦਾ ਪਿੱਛਾ ਕਰ ਅਤੇ ਜਦ ਤੂੰ ਉਨ੍ਹਾਂ ਕੋਲ ਪਹੁੰਚ ਜਾਵੇਂ ਤਾਂ ਉਨ੍ਹਾਂ ਨੂੰ ਆਖੀਂ, ਤੁਸੀਂ ਭਲਿਆਈ ਦੇ ਬਦਲੇ ਬੁਰਿਆਈ ਕਿਉਂ ਕੀਤੀ? ");
INSERT INTO pan_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","ਕੀ ਇਹ ਉਹ ਪਿਆਲਾ ਨਹੀਂ ਜਿਸ ਵਿੱਚ ਮੇਰਾ ਸੁਆਮੀ ਪੀਂਦਾ ਹੈ ਅਤੇ ਜਿਸ ਦੇ ਨਾਲ ਉਹ ਆਤਮਿਕ ਗੱਲਾਂ ਵਿਚਾਰਦਾ ਹੈ? ਤੁਸੀਂ ਜੋ ਇਹ ਕੀਤਾ ਹੈ ਸੋ ਬੁਰਾ ਹੀ ਕੀਤਾ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","ਤਦ ਉਸ ਨੇ ਉਨ੍ਹਾਂ ਨੂੰ ਜਾ ਫੜ੍ਹਿਆ ਅਤੇ ਇਹੋ ਗੱਲਾਂ ਉਨ੍ਹਾਂ ਨੂੰ ਆਖੀਆਂ। ");
INSERT INTO pan_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","ਉਨ੍ਹਾਂ ਨੇ ਉਹ ਨੂੰ ਆਖਿਆ, ਸਾਡਾ ਸੁਆਮੀ ਅਜਿਹੀਆਂ ਗੱਲਾਂ ਕਿਉਂ ਬੋਲਦਾ ਹੈ? ਤੁਹਾਡੇ ਦਾਸਾਂ ਤੋਂ ਅਜਿਹਾ ਕੰਮ ਕਰਨਾ ਦੂਰ ਰਹੇ। ");
INSERT INTO pan_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","ਵੇਖੋ, ਜਦ ਉਹ ਚਾਂਦੀ ਜਿਹੜੀ ਸਾਨੂੰ ਸਾਡੇ ਬੋਰਿਆਂ ਦੇ ਮੂੰਹ ਵਿੱਚ ਲੱਭੀ ਸੀ, ਅਸੀਂ ਉਹ ਕਨਾਨ ਦੇਸ਼ ਤੋਂ ਮੋੜ ਕੇ ਤੁਹਾਡੇ ਕੋਲ ਲੈ ਆਏ ਹਾਂ, ਤਾਂ ਕਿਵੇਂ ਅਸੀਂ ਤੁਹਾਡੇ ਸੁਆਮੀ ਦੇ ਘਰ ਵਿੱਚੋਂ ਚਾਂਦੀ ਜਾਂ ਸੋਨਾ ਚੁਰਾ ਸਕਦੇ ਹਾਂ? ");
INSERT INTO pan_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","ਤੁਹਾਡੇ ਦਾਸਾਂ ਵਿੱਚੋਂ ਜਿਸ ਦੇ ਕੋਲੋਂ ਉਹ ਲੱਭੇ, ਉਹ ਮਾਰਿਆ ਜਾਵੇ ਅਤੇ ਅਸੀਂ ਵੀ ਆਪਣੇ ਸੁਆਮੀ ਦੇ ਗ਼ੁਲਾਮ ਹੋ ਜਾਂਵਾਂਗੇ। ");
INSERT INTO pan_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","ਤਦ ਉਸ ਨੇ ਆਖਿਆ, ਹੁਣ ਤੁਹਾਡੀਆਂ ਗੱਲਾਂ ਦੇ ਅਨੁਸਾਰ ਹੀ ਹੋਵੇਗਾ। ਜਿਸ ਦੇ ਕੋਲੋਂ ਉਹ ਲੱਭੇਗਾ, ਉਹ ਮੇਰਾ ਗ਼ੁਲਾਮ ਹੋਵੇਗਾ ਪਰ ਤੁਸੀਂ ਨਿਰਦੋਸ਼ ਠਹਿਰੋਗੇ। ");
INSERT INTO pan_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","ਉਨ੍ਹਾਂ ਨੇ ਛੇਤੀ ਨਾਲ ਆਪੋ ਆਪਣੇ ਬੋਰੇ ਜ਼ਮੀਨ ਉੱਤੇ ਲਾਹ ਕੇ ਖੋਲ੍ਹ ਦਿੱਤੇ ");
INSERT INTO pan_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","ਅਤੇ ਉਸ ਨੇ ਵੱਡੇ ਤੋਂ ਲੈ ਕੇ ਛੋਟੇ ਤੱਕ ਸਭ ਦੀ ਤਲਾਸ਼ੀ ਲਈ ਅਤੇ ਉਹ ਪਿਆਲਾ ਬਿਨਯਾਮੀਨ ਦੇ ਬੋਰੇ ਵਿੱਚ ਲੱਭਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","ਤਦ ਉਨ੍ਹਾਂ ਨੇ ਆਪਣੇ ਬਸਤਰ ਪਾੜੇ ਅਤੇ ਹਰ ਇੱਕ ਨੇ ਆਪਣਾ ਗਧਾ ਲੱਦਿਆ ਅਤੇ ਓਹ ਨਗਰ ਨੂੰ ਮੁੜ ਆਏ। ");
INSERT INTO pan_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","ਜਦ ਯਹੂਦਾਹ ਅਤੇ ਉਸ ਦੇ ਭਰਾ ਯੂਸੁਫ਼ ਦੇ ਘਰ ਆਏ ਅਤੇ ਉਹ ਅਜੇ ਤੱਕ ਉੱਥੇ ਹੀ ਸੀ ਤਾਂ ਓਹ ਉਸ ਦੇ ਅੱਗੇ ਧਰਤੀ ਉੱਤੇ ਡਿੱਗ ਪਏ। ");
INSERT INTO pan_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","ਫੇਰ ਯੂਸੁਫ਼ ਨੇ ਉਨ੍ਹਾਂ ਨੂੰ ਆਖਿਆ, ਇਹ ਕੀ ਕਰਤੂਤ ਹੈ ਜੋ ਤੁਸੀਂ ਕੀਤੀ? ਕੀ ਤੁਸੀਂ ਨਹੀਂ ਜਾਣਦੇ ਸੀ ਕਿ ਮੇਰੇ ਵਰਗਾ ਆਦਮੀ ਆਤਮਿਕ ਗੱਲਾਂ ਵਿਚਾਰ ਸਕਦਾ ਹੈ? ");
INSERT INTO pan_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","ਯਹੂਦਾਹ ਨੇ ਆਖਿਆ, ਅਸੀਂ ਆਪਣੇ ਸੁਆਮੀ ਨੂੰ ਕੀ ਆਖੀਏ ਅਤੇ ਕੀ ਬੋਲੀਏ ਅਤੇ ਅਸੀਂ ਆਪਣੇ ਆਪ ਨੂੰ ਕਿਸ ਤਰ੍ਹਾਂ ਨਿਰਦੋਸ਼ ਸਾਬਤ ਕਰੀਏ? ਪਰਮੇਸ਼ੁਰ ਨੇ ਤੁਹਾਡੇ ਦਾਸਾਂ ਦੀ ਬੁਰਿਆਈ ਲੱਭ ਲਈ ਹੈ। ਵੇਖੋ, ਅਸੀਂ ਆਪਣੇ ਸੁਆਮੀ ਦੇ ਗ਼ੁਲਾਮ ਹਾਂ, ਅਸੀਂ ਵੀ ਅਤੇ ਉਹ ਵੀ ਜਿਸ ਦੇ ਕੋਲੋਂ ਇਹ ਪਿਆਲਾ ਲੱਭਿਆ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","ਪਰ ਯੂਸੁਫ਼ ਨੇ ਆਖਿਆ, ਇਹ ਕੰਮ ਮੈਥੋਂ ਦੂਰ ਹੋਵੇ। ਉਹ ਮਨੁੱਖ ਜਿਸ ਦੇ ਕੋਲੋਂ ਪਿਆਲਾ ਲੱਭਿਆ ਹੈ ਉਹ ਹੀ ਮੇਰਾ ਗ਼ੁਲਾਮ ਹੋਵੇਗਾ ਪਰ ਤੁਸੀਂ ਸਲਾਮਤੀ ਨਾਲ ਆਪਣੇ ਪਿਤਾ ਦੇ ਕੋਲ ਵਾਪਿਸ ਚਲੇ ਜਾਓ। ");
INSERT INTO pan_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","ਫੇਰ ਯਹੂਦਾਹ ਨੇ ਉਸ ਦੇ ਨੇੜੇ ਜਾ ਕੇ ਆਖਿਆ, ਮੇਰੇ ਸੁਆਮੀ ਜੀ, ਮੇਰੀ ਬੇਨਤੀ ਹੈ ਕਿ ਤੁਹਾਡਾ ਦਾਸ ਆਪਣੇ ਸੁਆਮੀ ਦੇ ਕੰਨਾਂ ਵਿੱਚ ਗੱਲ ਕਰੇ ਅਤੇ ਤੁਹਾਡਾ ਕ੍ਰੋਧ ਤੁਹਾਡੇ ਦਾਸ ਦੇ ਵਿਰੁੱਧ ਨਾ ਭੜਕੇ, ਕਿਉਂ ਜੋ ਤੁਸੀਂ ਫ਼ਿਰਊਨ ਦੇ ਸਮਾਨ ਹੋ। ");
INSERT INTO pan_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","ਮੇਰੇ ਸੁਆਮੀ ਨੇ ਆਪਣੇ ਦਾਸਾਂ ਤੋਂ ਇਹ ਪੁੱਛਿਆ ਸੀ, ਕੀ ਤੁਹਾਡਾ ਪਿਤਾ ਜਾਂ ਭਰਾ ਹੈ? ");
INSERT INTO pan_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","ਅਤੇ ਅਸੀਂ ਆਪਣੇ ਸੁਆਮੀ ਨੂੰ ਆਖਿਆ ਸੀ ਕਿ ਸਾਡਾ ਬਜ਼ੁਰਗ ਪਿਤਾ ਹੈ, ਅਤੇ ਉਸ ਦੀ ਬਿਰਧ ਅਵਸਥਾ ਦਾ ਇੱਕ ਛੋਟਾ ਪੁੱਤਰ ਹੈ ਅਤੇ ਉਸ ਦਾ ਭਰਾ ਮਰ ਗਿਆ ਹੈ, ਅਤੇ ਉਹ ਆਪਣੀ ਮਾਤਾ ਦਾ ਇਕੱਲਾ ਹੀ ਹੈ ਅਤੇ ਉਸ ਦਾ ਪਿਤਾ ਉਸ ਨੂੰ ਪਿਆਰ ਕਰਦਾ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","ਤੁਸੀਂ ਆਪਣੇ ਦਾਸਾਂ ਨੂੰ ਆਖਿਆ ਕਿ ਉਸ ਨੂੰ ਮੇਰੇ ਕੋਲ ਲਿਆਓ ਤਾਂ ਜੋ ਮੈਂ ਉਸ ਮੁੰਡੇ ਨੂੰ ਆਪਣੀਆਂ ਅੱਖਾਂ ਨਾਲ ਵੇਖਾਂ। ");
INSERT INTO pan_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","ਤਾਂ ਅਸੀਂ ਆਪਣੇ ਸੁਆਮੀ ਨੂੰ ਆਖਿਆ ਕਿ ਮੁੰਡਾ ਆਪਣੇ ਪਿਤਾ ਨੂੰ ਛੱਡ ਨਹੀਂ ਸਕਦਾ। ਜੇਕਰ ਉਹ ਉਸ ਨੂੰ ਛੱਡੇ ਤਾਂ ਸਾਡਾ ਪਿਤਾ ਮਰ ਜਾਵੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","ਫੇਰ ਤੁਸੀਂ ਆਪਣੇ ਦਾਸਾਂ ਨੂੰ ਆਖਿਆ ਸੀ ਕਿ ਜਦ ਤੱਕ ਤੁਹਾਡਾ ਛੋਟਾ ਭਰਾ ਤੁਹਾਡੇ ਨਾਲ ਨਾ ਆਵੇ ਤੁਸੀਂ ਮੇਰਾ ਮੂੰਹ ਫੇਰ ਨਾ ਵੇਖੋਗੇ। ");
INSERT INTO pan_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","ਇਸ ਲਈ ਜਦ ਅਸੀਂ ਤੁਹਾਡੇ ਦਾਸ ਆਪਣੇ ਪਿਤਾ ਕੋਲ ਗਏ ਤਾਂ ਅਸੀਂ ਆਪਣੇ ਸੁਆਮੀ ਦੀਆਂ ਗੱਲਾਂ ਉਸ ਨੂੰ ਦੱਸੀਆਂ। ");
INSERT INTO pan_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","ਤਦ ਸਾਡੇ ਪਿਤਾ ਨੇ ਆਖਿਆ, ਮੁੜ ਕੇ ਜਾਓ ਅਤੇ ਥੋੜ੍ਹਾ ਅੰਨ ਸਾਡੇ ਲਈ ਮੁੱਲ ਲੈ ਆਓ। ");
INSERT INTO pan_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","ਪਰ ਅਸੀਂ ਆਖਿਆ, ਅਸੀਂ ਨਹੀਂ ਜਾ ਸਕਦੇ। ਜੇਕਰ ਸਾਡਾ ਛੋਟਾ ਭਰਾ ਸਾਡੇ ਨਾਲ ਹੋਵੇ ਤਾਂ ਹੀ ਅਸੀਂ ਜਾਂਵਾਂਗੇ ਕਿਉਂ ਜੋ ਜਦ ਤੱਕ ਸਾਡਾ ਛੋਟਾ ਭਰਾ ਸਾਡੇ ਨਾਲ ਨਾ ਜਾਵੇ ਅਸੀਂ ਉਸ ਮਨੁੱਖ ਦਾ ਮੂੰਹ ਨਾ ਵੇਖ ਸਕਾਂਗੇ। ");
INSERT INTO pan_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","ਤਦ ਤੁਹਾਡੇ ਦਾਸ ਸਾਡੇ ਪਿਤਾ ਨੇ ਸਾਨੂੰ ਆਖਿਆ, ਤੁਸੀਂ ਜਾਣਦੇ ਹੋ ਕਿ ਮੇਰੀ ਪਤਨੀ ਨੇ ਮੇਰੇ ਲਈ ਦੋ ਪੁੱਤਰਾਂ ਨੂੰ ਜਨਮ ਦਿੱਤਾ। ");
INSERT INTO pan_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","ਉਨ੍ਹਾਂ ਵਿੱਚੋਂ ਇੱਕ ਤਾਂ ਮੈਨੂੰ ਛੱਡ ਕੇ ਚਲਾ ਗਿਆ ਅਤੇ ਮੈਂ ਮੰਨ ਲਿਆ ਕਿ ਉਹ ਸੱਚ-ਮੁੱਚ ਪਾੜਿਆ ਗਿਆ ਹੈ ਅਤੇ ਮੈਂ ਉਸ ਨੂੰ ਹੁਣ ਤੱਕ ਨਹੀਂ ਵੇਖਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","ਪਰ ਜੇਕਰ ਤੁਸੀਂ ਇਸ ਨੂੰ ਵੀ ਮੇਰੇ ਅੱਗੋਂ ਲੈ ਜਾਓਗੇ ਅਤੇ ਕੋਈ ਬਿਪਤਾ ਉਸ ਉੱਤੇ ਆ ਪਈ ਤਾਂ ਤੁਸੀਂ ਮੈਨੂੰ ਇਸ ਬੁਢਾਪੇ ਵਿੱਚ ਦੁੱਖ ਨਾਲ ਪਤਾਲ ਵਿੱਚ ਉਤਾਰੋਗੇ। ");
INSERT INTO pan_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","ਹੁਣ ਜਦ ਮੈਂ ਤੁਹਾਡੇ ਦਾਸ ਆਪਣੇ ਪਿਤਾ ਦੇ ਕੋਲ ਜਾਂਵਾਂ ਅਤੇ ਇਹ ਮੁੰਡਾ ਨਾਲ ਨਾ ਹੋਵੇ ਤਾਂ ਕਿਉਂ ਜੋ ਉਹ ਦੇ ਪ੍ਰਾਣ ਇਸ ਮੁੰਡੇ ਦੇ ਪ੍ਰਾਣਾਂ ਨਾਲ ਬੱਧੇ ਹੋਏ ਹਨ ");
INSERT INTO pan_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","ਅਤੇ ਜਦ ਉਹ ਵੇਖੇਗਾ ਕਿ ਇਹ ਮੁੰਡਾ ਨਾਲ ਨਹੀਂ ਹੈ ਤਾਂ ਉਹ ਮਰ ਜਾਵੇਗਾ ਅਤੇ ਤੁਹਾਡੇ ਦਾਸ ਆਪਣੇ ਪਿਤਾ ਨੂੰ ਬੁਢਾਪੇ ਵਿੱਚ ਦੁੱਖ ਨਾਲ ਪਤਾਲ ਵਿੱਚ ਉਤਾਰਨਗੇ। ");
INSERT INTO pan_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","ਕਿਉਂ ਜੋ ਤੁਹਾਡਾ ਦਾਸ ਆਪਣੇ ਪਿਤਾ ਨੂੰ ਇਹ ਆਖ ਕੇ ਇਸ ਮੁੰਡੇ ਦਾ ਜ਼ਿੰਮੇਵਾਰ ਹੋਇਆ ਹੈ ਕਿ ਜੇਕਰ ਮੈਂ ਉਸ ਨੂੰ ਤੇਰੇ ਕੋਲ ਨਾ ਲਿਆਵਾਂ ਤਾਂ ਮੈਂ ਸਦਾ ਤੱਕ ਆਪਣੇ ਪਿਤਾ ਦਾ ਪਾਪੀ ਹੋਵਾਂਗਾ। ");
INSERT INTO pan_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","ਹੁਣ ਤੁਹਾਡਾ ਦਾਸ ਇਸ ਮੁੰਡੇ ਦੇ ਸਥਾਨ ਤੇ ਮੇਰੇ ਸੁਆਮੀ ਦਾ ਗ਼ੁਲਾਮ ਬਣ ਕੇ ਰਹੇਗਾ ਪਰ ਇਸ ਮੁੰਡੇ ਨੂੰ ਆਪਣੇ ਭਰਾਵਾਂ ਦੇ ਨਾਲ ਵਾਪਿਸ ਜਾਣ ਦਿੱਤਾ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","ਕਿਉਂਕਿ ਮੈਂ ਆਪਣੇ ਪਿਤਾ ਦੇ ਕੋਲ ਕਿਵੇਂ ਜਾਂਵਾਂ, ਜੇਕਰ ਇਹ ਮੁੰਡਾ ਮੇਰੇ ਨਾਲ ਨਾ ਹੋਵੇ? ਅਜਿਹਾ ਨਾ ਹੋਵੇ ਕਿ ਉਹ ਬੁਰਿਆਈ ਜਿਹੜੀ ਮੇਰੇ ਪਿਤਾ ਉੱਤੇ ਆਵੇਗੀ, ਮੈਨੂੰ ਵੇਖਣੀ ਪਵੇ। ");
INSERT INTO pan_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","ਯੂਸੁਫ਼ ਆਪਣੇ ਆਪ ਨੂੰ ਉਨ੍ਹਾਂ ਸਾਰਿਆਂ ਦੇ ਸਾਹਮਣੇ ਜਿਹੜੇ ਉਸ ਦੇ ਕੋਲ ਖੜ੍ਹੇ ਸਨ, ਰੋਕ ਨਾ ਸਕਿਆ, ਇਸ ਲਈ ਉਸ ਨੇ ਉੱਚੀ ਅਵਾਜ਼ ਨਾਲ ਆਖਿਆ, ਮੇਰੇ ਕੋਲੋਂ ਹਰ ਮਨੁੱਖ ਨੂੰ ਬਾਹਰ ਕੱਢ ਦਿਓ ਅਤੇ ਜਦ ਕੋਈ ਮਨੁੱਖ ਉਸ ਦੇ ਕੋਲ ਖੜ੍ਹਾ ਨਾ ਰਿਹਾ ਤਦ ਯੂਸੁਫ਼ ਨੇ ਆਪਣੇ ਆਪ ਨੂੰ ਆਪਣੇ ਭਰਾਵਾਂ ਉੱਤੇ ਪਰਗਟ ਕਰ ਦਿੱਤਾ ");
INSERT INTO pan_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","ਅਤੇ ਉੱਚੀ-ਉੱਚੀ ਰੋਇਆ ਤਾਂ ਮਿਸਰੀਆਂ ਨੇ ਸੁਣਿਆ ਅਤੇ ਫ਼ਿਰਊਨ ਦੇ ਘਰਾਣੇ ਨੂੰ ਵੀ ਇਸ ਗੱਲ ਦੀ ਖ਼ਬਰ ਹੋਈ। ");
INSERT INTO pan_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","ਯੂਸੁਫ਼ ਨੇ ਆਪਣੇ ਭਰਾਵਾਂ ਨੂੰ ਆਖਿਆ, ਮੈਂ ਯੂਸੁਫ਼ ਹਾਂ, ਕੀ ਮੇਰਾ ਪਿਤਾ ਅਜੇ ਜੀਉਂਦਾ ਹੈ? ਪਰ ਉਸ ਦੇ ਭਰਾ ਉਸ ਨੂੰ ਉੱਤਰ ਨਾ ਦੇ ਸਕੇ ਕਿਉਂ ਜੋ ਉਸ ਦੇ ਅੱਗੇ ਘਬਰਾ ਗਏ। ");
INSERT INTO pan_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","ਯੂਸੁਫ਼ ਨੇ ਆਪਣੇ ਭਰਾਵਾਂ ਨੂੰ ਆਖਿਆ, ਮੇਰੇ ਨੇੜੇ ਆਓ। ਤਦ ਓਹ ਉਸ ਦੇ ਨੇੜੇ ਆਏ ਅਤੇ ਉਸ ਨੇ ਆਖਿਆ, ਮੈਂ ਤੁਹਾਡਾ ਭਰਾ ਯੂਸੁਫ਼ ਹਾਂ ਜਿਸ ਨੂੰ ਤੁਸੀਂ ਮਿਸਰ ਆਉਣ ਵਾਲਿਆਂ ਦੇ ਹੱਥ ਵੇਚਿਆ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","ਹੁਣ ਤੁਸੀਂ ਨਾ ਪਛਤਾਓ ਅਤੇ ਨਾ ਹੀ ਘਬਰਾਓ ਕਿ ਤੁਸੀਂ ਮੈਨੂੰ ਇੱਧਰ ਵੇਚ ਦਿੱਤਾ ਸੀ ਕਿਉਂਕਿ ਪਰਮੇਸ਼ੁਰ ਨੇ ਤੁਹਾਡੀਆਂ ਜਾਨਾਂ ਬਚਾਉਣ ਲਈ ਮੈਨੂੰ ਤੁਹਾਡੇ ਅੱਗੇ ਭੇਜ ਦਿੱਤਾ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","ਇਹਨਾਂ ਦੋ ਸਾਲਾਂ ਤੋਂ ਇਸ ਦੇਸ਼ ਵਿੱਚ ਕਾਲ ਹੈ ਅਤੇ ਹੁਣ ਪੰਜ ਸਾਲ ਹੋਰ ਹਨ, ਜਿਨ੍ਹਾਂ ਵਿੱਚ ਨਾ ਵਾਹੀ ਤੇ ਨਾ ਵਾਢੀ ਹੋਵੇਗੀ। ");
INSERT INTO pan_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","ਇਸ ਲਈ ਪਰਮੇਸ਼ੁਰ ਨੇ ਮੈਨੂੰ ਤੁਹਾਡੇ ਅੱਗੇ ਭੇਜਿਆ ਤਾਂ ਜੋ ਤੁਸੀਂ ਧਰਤੀ ਉੱਤੇ ਜੀਉਂਦੇ ਰਹੋ ਅਤੇ ਤੁਹਾਨੂੰ ਬਚਾ ਕੇ ਤੁਹਾਡੇ ਵੰਸ਼ ਨੂੰ ਜੀਉਂਦਾ ਰੱਖੇ। ");
INSERT INTO pan_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","ਹੁਣ ਤੁਸੀਂ ਨਹੀਂ ਸਗੋਂ ਪਰਮੇਸ਼ੁਰ ਨੇ ਮੈਨੂੰ ਇੱਥੇ ਭੇਜਿਆ ਹੈ ਅਤੇ ਉਸ ਨੇ ਮੈਨੂੰ ਫ਼ਿਰਊਨ ਲਈ ਪਿਤਾ ਵਰਗਾ ਅਤੇ ਉਸ ਦੇ ਸਾਰੇ ਘਰ ਦਾ ਸੁਆਮੀ ਅਤੇ ਮਿਸਰ ਦੇ ਸਾਰੇ ਦੇਸ਼ ਦਾ ਹਾਕਮ ਠਹਿਰਾਇਆ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","ਜਲਦੀ ਕਰੋ ਅਤੇ ਮੇਰੇ ਪਿਤਾ ਦੇ ਕੋਲ ਜਾਓ ਅਤੇ ਉਸ ਨੂੰ ਆਖੋ, ਤੇਰਾ ਪੁੱਤਰ ਯੂਸੁਫ਼ ਇਹ ਆਖਦਾ ਹੈ ਕਿ ਪਰਮੇਸ਼ੁਰ ਨੇ ਮੈਨੂੰ ਸਾਰੇ ਮਿਸਰ ਦੇਸ਼ ਦਾ ਮਾਲਕ ਬਣਾ ਦਿੱਤਾ ਹੈ। ਇਸ ਲਈ ਮੇਰੇ ਕੋਲ ਆ ਜਾਓ ਅਤੇ ਦੇਰੀ ਨਾ ਕਰੋ। ");
INSERT INTO pan_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","ਤੁਸੀਂ ਗੋਸ਼ਨ ਦੇਸ਼ ਵਿੱਚ ਵੱਸੋਗੇ ਅਤੇ ਮੇਰੇ ਨਜ਼ਦੀਕ ਰਹੋਗੇ, ਤੁਸੀਂ ਅਤੇ ਤੁਹਾਡੇ ਬਾਲ ਬੱਚੇ ਅਤੇ ਤੁਹਾਡੇ ਬੱਚਿਆਂ ਦੇ ਬੱਚੇ ਅਤੇ ਤੁਹਾਡੇ ਇੱਜੜ ਅਤੇ ਚੌਣੇ ਅਤੇ ਸਭ ਕੁਝ ਜੋ ਤੁਹਾਡਾ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","ਉੱਥੇ ਮੈਂ ਤੁਹਾਡੀ ਪਾਲਣਾ ਕਰਾਂਗਾ ਕਿਉਂ ਜੋ ਅਜੇ ਕਾਲ ਦੇ ਪੰਜ ਸਾਲ ਹੋਰ ਹਨ, ਕਿਤੇ ਅਜਿਹਾ ਨਾ ਹੋਵੇ ਕਿ ਤੁਸੀਂ ਅਤੇ ਤੁਹਾਡਾ ਘਰਾਣਾ ਅਤੇ ਤੁਹਾਡੇ ਸਾਰੇ ਸੰਗੀ ਭੁੱਖ ਨਾਲ ਮਰ ਜਾਣ। ");
INSERT INTO pan_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","ਅਤੇ ਵੇਖੋ, ਤੁਹਾਡੀਆਂ ਅੱਖਾਂ ਅਤੇ ਮੇਰੇ ਭਰਾ ਬਿਨਯਾਮੀਨ ਦੀਆਂ ਅੱਖਾਂ ਵੇਖਦੀਆਂ ਹਨ ਕਿ ਇਹ ਮੈਂ ਹੀ ਹਾਂ ਜੋ ਤੁਹਾਡੇ ਨਾਲ ਬੋਲਦਾ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","ਤੁਸੀਂ ਮੇਰਾ ਸਾਰਾ ਪਰਤਾਪ ਜਿਹੜਾ ਮਿਸਰ ਵਿੱਚ ਹੈ, ਅਤੇ ਜੋ ਕੁਝ ਤੁਸੀਂ ਵੇਖਿਆ ਹੈ ਮੇਰੇ ਪਿਤਾ ਨੂੰ ਦੱਸਿਓ ਅਤੇ ਤੁਸੀਂ ਛੇਤੀ ਕਰੋ ਅਤੇ ਮੇਰੇ ਪਿਤਾ ਨੂੰ ਐਥੇ ਲੈ ਆਓ। ");
INSERT INTO pan_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","ਤਦ ਉਹ ਆਪਣੇ ਭਰਾ ਬਿਨਯਾਮੀਨ ਦੇ ਗਲ਼ ਲੱਗ ਕੇ ਰੋਇਆ ਅਤੇ ਬਿਨਯਾਮੀਨ ਉਸ ਦੇ ਗਲ਼ ਲੱਗ ਕੇ ਰੋਇਆ। ");
INSERT INTO pan_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","ਫਿਰ ਉਸ ਆਪਣੇ ਸਾਰਿਆਂ ਭਰਾਵਾਂ ਨੂੰ ਚੁੰਮਿਆ ਅਤੇ ਉਨ੍ਹਾਂ ਨਾਲ ਰੋਇਆ ਅਤੇ ਇਸ ਤੋਂ ਬਾਅਦ ਉਸ ਦੇ ਭਰਾਵਾਂ ਨੇ ਉਹ ਦੇ ਨਾਲ ਗੱਲਾਂ ਕੀਤੀਆਂ। ");
INSERT INTO pan_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","ਇਹ ਖ਼ਬਰ ਫ਼ਿਰਊਨ ਦੇ ਘਰ ਸੁਣੀ ਗਈ ਕਿ ਯੂਸੁਫ਼ ਦੇ ਭਰਾ ਆਏ ਹਨ ਅਤੇ ਇਹ ਖ਼ਬਰ ਫ਼ਿਰਊਨ ਨੂੰ ਅਤੇ ਉਸ ਦੇ ਕਰਮਚਾਰੀਆਂ ਨੂੰ ਚੰਗੀ ਲੱਗੀ। ");
INSERT INTO pan_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","ਇਸ ਲਈ ਫ਼ਿਰਊਨ ਨੇ ਯੂਸੁਫ਼ ਨੂੰ ਆਖਿਆ, ਆਪਣੇ ਭਰਾਵਾਂ ਨੂੰ ਆਖ ਕਿ ਇਹ ਕੰਮ ਕਰੋ: ਆਪਣੇ ਜਾਨਵਰ ਲੱਦੋ ਅਤੇ ਕਨਾਨ ਦੇ ਦੇਸ਼ ਨੂੰ ਜਾਓ, ");
INSERT INTO pan_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","ਅਤੇ ਆਪਣੇ ਪਿਤਾ ਅਤੇ ਆਪਣੇ ਘਰਾਣੇ ਨੂੰ ਲੈ ਕੇ ਮੇਰੇ ਕੋਲ ਆ ਜਾਓ ਅਤੇ ਮੈਂ ਤੁਹਾਨੂੰ ਮਿਸਰ ਦੇਸ਼ ਦੇ ਪਦਾਰਥ ਦੇਵਾਂਗਾ ਅਤੇ ਤੁਸੀਂ ਦੇਸ਼ ਦੀ ਚਿਕਨਾਈ ਖਾਓਗੇ। ");
INSERT INTO pan_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","ਹੁਣ ਤੈਨੂੰ ਇਹ ਆਗਿਆ ਹੈ: ਤੁਸੀਂ ਇਹ ਕਰੋ ਕਿ ਮਿਸਰ ਦੇਸ਼ ਤੋਂ ਗੱਡੇ ਲੈ ਜਾਓ ਅਤੇ ਆਪਣੇ ਬਾਲ ਬੱਚੇ ਅਤੇ ਆਪਣੀਆਂ ਪਤਨੀਆਂ ਅਤੇ ਆਪਣੇ ਪਿਤਾ ਨੂੰ ਲੈ ਆਓ। ");
INSERT INTO pan_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","ਤੁਸੀਂ ਆਪਣੇ ਸਮਾਨ ਦਾ ਮੋਹ ਨਾ ਕਰਨਾ ਕਿਉਂ ਜੋ ਸਾਰੇ ਮਿਸਰ ਦੇਸ਼ ਦੇ ਪਦਾਰਥ ਤੁਹਾਡੇ ਹੀ ਹਨ। ");
INSERT INTO pan_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","ਇਸਰਾਏਲ ਦੇ ਪੁੱਤਰਾਂ ਨੇ ਉਸੇ ਤਰ੍ਹਾਂ ਹੀ ਕੀਤਾ ਅਤੇ ਯੂਸੁਫ਼ ਨੇ ਫ਼ਿਰਊਨ ਦੇ ਹੁਕਮ ਦੇ ਅਨੁਸਾਰ ਉਨ੍ਹਾਂ ਨੂੰ ਗੱਡੇ ਦਿੱਤੇ ਅਤੇ ਉਨ੍ਹਾਂ ਨੂੰ ਰਸਤੇ ਲਈ ਭੋਜਨ ਸਮੱਗਰੀ ਦਿੱਤੀ। ");
INSERT INTO pan_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","ਉਸ ਨੇ ਉਨ੍ਹਾਂ ਸਾਰਿਆਂ ਨੂੰ ਇੱਕ-ਇੱਕ ਜੋੜਾ ਬਸਤਰ ਦਿੱਤਾ ਪਰ ਬਿਨਯਾਮੀਨ ਨੂੰ ਤਿੰਨ ਸੌ ਚਾਂਦੀ ਦੇ ਸਿੱਕੇ ਅਤੇ ਪੰਜ ਜੋੜੇ ਬਸਤਰ ਦਿੱਤੇ। ");
INSERT INTO pan_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","ਉਸ ਨੇ ਆਪਣੇ ਪਿਤਾ ਨੂੰ ਜੋ ਕੁਝ ਭੇਜਿਆ ਉਹ ਇਹ ਹੈ ਅਰਥਾਤ ਮਿਸਰ ਦੇ ਚੰਗੇ ਪਦਾਰਥਾਂ ਦੇ ਲੱਦੇ ਹੋਏ ਦਸ ਗਧੇ ਅਤੇ ਅੰਨ-ਦਾਣੇ ਅਤੇ ਆਪਣੇ ਪਿਤਾ ਦੇ ਰਸਤੇ ਲਈ ਹੋਰ ਭੋਜਨ-ਸਮੱਗਰੀ ਦੀਆਂ ਲੱਦੀਆਂ ਹੋਈਆਂ ਦਸ ਗਧੀਆਂ। ");
INSERT INTO pan_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","ਤਦ ਉਸ ਨੇ ਆਪਣੇ ਭਰਾਵਾਂ ਨੂੰ ਵਿਦਿਆ ਕੀਤਾ ਅਤੇ ਓਹ ਚਲੇ ਗਏ ਅਤੇ ਉਸ ਨੇ ਉਨ੍ਹਾਂ ਨੂੰ ਆਖਿਆ, ਕਿਤੇ ਰਸਤੇ ਵਿੱਚ ਝਗੜਾ ਨਾ ਕਰਿਓ। ");
INSERT INTO pan_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","ਸੋ ਓਹ ਮਿਸਰ ਤੋਂ ਵਾਪਿਸ ਆਏ ਅਤੇ ਕਨਾਨ ਦੇਸ਼ ਵਿੱਚ ਆਪਣੇ ਪਿਤਾ ਯਾਕੂਬ ਦੇ ਕੋਲ ਪਹੁੰਚੇ। ");
INSERT INTO pan_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","ਅਤੇ ਉਸ ਨੂੰ ਦੱਸਿਆ ਕਿ ਯੂਸੁਫ਼ ਅਜੇ ਜੀਉਂਦਾ ਹੈ ਅਤੇ ਉਹ ਮਿਸਰ ਦੇ ਸਾਰੇ ਦੇਸ਼ ਉੱਤੇ ਰਾਜ ਕਰਦਾ ਹੈ, ਤਾਂ ਯਾਕੂਬ ਦਾ ਦਿਲ ਬੈਠ ਗਿਆ ਕਿਉਂ ਜੋ ਉਸ ਨੇ ਉਨ੍ਹਾਂ ਦੀ ਗੱਲ ਦਾ ਭਰੋਸਾ ਨਾ ਕੀਤਾ। ");
INSERT INTO pan_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","ਫੇਰ ਉਨ੍ਹਾਂ ਨੇ ਯੂਸੁਫ਼ ਦੀਆਂ ਸਾਰੀਆਂ ਗੱਲਾਂ ਜਿਹੜੀਆਂ ਉਸ ਨੇ ਉਨ੍ਹਾਂ ਨੂੰ ਆਖੀਆਂ ਸਨ, ਉਸ ਨੂੰ ਦੱਸੀਆਂ। ਜਦ ਉਸ ਨੇ ਉਹ ਗੱਡੇ ਜਿਹੜੇ ਯੂਸੁਫ਼ ਨੇ ਉਹ ਦੇ ਲਿਆਉਣ ਲਈ ਭੇਜੇ ਸਨ ਵੇਖੇ ਤਾਂ ਉਨ੍ਹਾਂ ਦੇ ਪਿਤਾ ਯਾਕੂਬ ਦੀ ਜਾਨ ਵਿੱਚ ਜਾਨ ਆਈ। ");
INSERT INTO pan_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","ਤਦ ਇਸਰਾਏਲ ਨੇ ਆਖਿਆ, ਇਹੋ ਬਹੁਤ ਹੈ ਕਿ ਮੇਰਾ ਪੁੱਤਰ ਯੂਸੁਫ਼ ਅਜੇ ਜੀਉਂਦਾ ਹੈ। ਮੈਂ ਜਾਂਵਾਂਗਾ ਅਤੇ ਆਪਣੇ ਮਰਨ ਤੋਂ ਪਹਿਲਾਂ ਉਸ ਨੂੰ ਵੇਖਾਂਗਾ। ");
INSERT INTO pan_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","ਤਦ ਇਸਰਾਏਲ ਨੇ ਆਪਣਾ ਸਭ ਕੁਝ ਲੈ ਕੇ ਕੂਚ ਕੀਤਾ ਅਤੇ ਬਏਰਸ਼ਬਾ ਨੂੰ ਆਇਆ ਅਤੇ ਆਪਣੇ ਪਿਤਾ ਇਸਹਾਕ ਦੇ ਪਰਮੇਸ਼ੁਰ ਲਈ ਬਲੀਆਂ ਚੜ੍ਹਾਈਆਂ। ");
INSERT INTO pan_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","ਪਰਮੇਸ਼ੁਰ ਨੇ ਇਸਰਾਏਲ ਨੂੰ ਰਾਤ ਦੇ ਸਮੇਂ ਦਰਸ਼ਣ ਦੇ ਕੇ ਆਖਿਆ, ਯਾਕੂਬ! ਯਾਕੂਬ! ਉਸ ਨੇ ਆਖਿਆ, ਮੈਂ ਹਾਜ਼ਰ ਹਾਂ। ");
INSERT INTO pan_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","ਉਸ ਆਖਿਆ, ਮੈਂ ਪਰਮੇਸ਼ੁਰ, ਤੇਰੇ ਪਿਤਾ ਦਾ ਪਰਮੇਸ਼ੁਰ ਹਾਂ। ");
INSERT INTO pan_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","ਮਿਸਰ ਵੱਲ ਜਾਣ ਤੋਂ ਨਾ ਡਰ, ਕਿਉਂ ਜੋ ਮੈਂ ਉੱਥੇ ਤੈਨੂੰ ਇੱਕ ਵੱਡੀ ਕੌਮ ਬਣਾਵਾਂਗਾ ਅਤੇ ਮੈਂ ਤੇਰੇ ਅੰਗ-ਸੰਗ ਮਿਸਰ ਵਿੱਚ ਚੱਲਾਂਗਾ ਅਤੇ ਸੱਚ-ਮੁੱਚ ਮੈਂ ਤੈਨੂੰ ਉੱਥੋਂ ਫੇਰ ਲੈ ਆਵਾਂਗਾ ਅਤੇ ਯੂਸੁਫ਼ ਆਪਣੇ ਹੱਥਾਂ ਨਾਲ ਤੇਰੀਆਂ ਅੱਖਾਂ ਬੰਦ ਕਰੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","ਯਾਕੂਬ ਬਏਰਸ਼ਬਾ ਤੋਂ ਉੱਠਿਆ ਅਤੇ ਇਸਰਾਏਲ ਦੇ ਪੁੱਤਰ, ਆਪਣੇ ਪਿਤਾ ਯਾਕੂਬ ਨੂੰ ਅਤੇ ਆਪਣੇ ਛੋਟੇ ਬੱਚਿਆਂ ਅਤੇ ਆਪਣੀਆਂ ਪਤਨੀਆਂ ਨੂੰ ਗੱਡਿਆਂ ਉੱਤੇ ਲੈ ਚੱਲੇ, ਜਿਹੜੇ ਫ਼ਿਰਊਨ ਨੇ ਉਨ੍ਹਾਂ ਨੂੰ ਲਿਆਉਣ ਲਈ ਭੇਜੇ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","ਉਨ੍ਹਾਂ ਨੇ ਆਪਣੇ ਪਸ਼ੂ ਅਤੇ ਆਪਣਾ ਸਾਰਾ ਸਮਾਨ ਜਿਹੜਾ ਉਨ੍ਹਾਂ ਨੇ ਕਨਾਨ ਦੇਸ਼ ਵਿੱਚ ਕਮਾਇਆ ਸੀ, ਲੈ ਲਿਆ ਅਤੇ ਯਾਕੂਬ ਅਤੇ ਉਸ ਦਾ ਸਾਰਾ ਵੰਸ਼ ਉਸ ਦੇ ਨਾਲ ਮਿਸਰ ਵਿੱਚ ਆਇਆ ");
INSERT INTO pan_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","ਅਰਥਾਤ ਉਹ ਆਪਣੇ ਪੁੱਤਰ-ਧੀਆਂ, ਪੋਤੇ-ਪੋਤੀਆਂ ਅਤੇ ਆਪਣਾ ਸਾਰਾ ਵੰਸ਼ ਆਪਣੇ ਨਾਲ ਲੈ ਕੇ ਆਇਆ। ");
INSERT INTO pan_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","ਇਸਰਾਏਲ ਦੇ ਪੁੱਤਰਾਂ ਦੇ ਨਾਮ ਇਹ ਹਨ, ਜਿਹੜੇ ਮਿਸਰ ਵਿੱਚ ਆਏ: ਯਾਕੂਬ ਅਤੇ ਉਸ ਦਾ ਪਹਿਲੌਠਾ ਪੁੱਤਰ ਰਊਬੇਨ। ");
INSERT INTO pan_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","ਰਊਬੇਨ ਦੇ ਪੁੱਤਰ: ਹਨੋਕ, ਪੱਲੂ, ਹਸਰੋਨ ਅਤੇ ਕਰਮੀ। ");
INSERT INTO pan_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","ਸ਼ਿਮਓਨ ਦੇ ਪੁੱਤਰ: ਯਮੂਏਲ, ਯਾਮੀਨ, ਓਹਦ, ਯਾਕੀਨ, ਸੋਹਰ ਅਤੇ ਸਾਊਲ ਜੋ ਕਨਾਨੀ ਇਸਤਰੀ ਦਾ ਪੁੱਤਰ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","ਲੇਵੀ ਦੇ ਪੁੱਤਰ: ਗੇਰਸ਼ੋਨ, ਕਹਾਥ ਅਤੇ ਮਰਾਰੀ। ");
INSERT INTO pan_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","ਯਹੂਦਾਹ ਦੇ ਪੁੱਤਰ: ਏਰ, ਓਨਾਨ, ਸ਼ੇਲਾਹ, ਪਰਸ ਅਤੇ ਜ਼ਰਹ। ਪਰ ਏਰ ਅਤੇ ਓਨਾਨ ਕਨਾਨ ਦੇਸ਼ ਵਿੱਚ ਮਰ ਗਏ ਅਤੇ ਫਰਸ ਦੇ ਪੁੱਤਰ ਹਸਰੋਨ ਅਤੇ ਹਾਮੂਲ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","ਯਿੱਸਾਕਾਰ ਦੇ ਪੁੱਤਰ: ਤੋਲਾ, ਪੁੱਵਾਹ, ਯੋਬ ਅਤੇ ਸ਼ਿਮਰੋਨ। ");
INSERT INTO pan_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","ਜ਼ਬੂਲੁਨ ਦੇ ਪੁੱਤਰ: ਸਰਦ, ਏਲੋਨ ਅਤੇ ਯਹਲਏਲ। ");
INSERT INTO pan_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","ਲੇਆਹ ਦੇ ਪੁੱਤਰ ਇਹ ਸਨ, ਜਿਨ੍ਹਾਂ ਨੂੰ ਉਸ ਨੇ ਆਪਣੀ ਧੀ ਦੀਨਾਹ ਸਮੇਤ ਪਦਨ ਅਰਾਮ ਵਿੱਚ ਜਨਮ ਦਿੱਤਾ। ਉਹ ਸਾਰੇ ਪ੍ਰਾਣੀ ਅਰਥਾਤ ਉਸ ਦੇ ਪੁੱਤਰ ਅਤੇ ਉਸ ਦੀਆਂ ਧੀਆਂ ਤੇਂਤੀ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","ਗਾਦ ਦੇ ਪੁੱਤਰ: ਸਿਫਯੋਨ, ਹੱਗੀ, ਸੂਨੀ, ਅਸਬੋਨ, ਏਰੀ, ਅਰੋਦੀ ਅਤੇ ਅਰਏਲੀ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","ਆਸ਼ੇਰ ਦੇ ਪੁੱਤਰ: ਯਿਮਨਾਹ, ਯਿਸ਼ਵਾਹ, ਯਿਸ਼ਵੀ, ਬਰੀਆਹ ਅਤੇ ਸਰਹ ਉਨ੍ਹਾਂ ਦੀ ਭੈਣ। ਬਰੀਆਹ ਦੇ ਪੁੱਤਰ ਹੇਬਰ ਅਤੇ ਮਲਕੀਏਲ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","ਇਹ ਜਿਲਫਾਹ ਦੇ ਪੁੱਤਰ ਸਨ, ਜਿਸ ਨੂੰ ਲਾਬਾਨ ਨੇ ਆਪਣੀ ਧੀ ਲੇਆਹ ਨੂੰ ਦਿੱਤਾ ਸੀ, ਉਸ ਨੇ ਯਾਕੂਬ ਲਈ ਇਨ੍ਹਾਂ ਸੋਲ਼ਾਂ ਪ੍ਰਾਣੀਆਂ ਨੂੰ ਜਨਮ ਦਿੱਤਾ। ");
INSERT INTO pan_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","ਯਾਕੂਬ ਦੀ ਪਤਨੀ ਰਾਖ਼ੇਲ ਦੇ ਪੁੱਤਰ ਯੂਸੁਫ਼ ਅਤੇ ਬਿਨਯਾਮੀਨ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","ਯੂਸੁਫ਼ ਤੋਂ ਮਿਸਰ ਦੇਸ਼ ਵਿੱਚ ਊਨ ਦੇ ਜਾਜਕ ਪੋਟੀ-ਫ਼ਰਾ ਦੀ ਧੀ ਆਸਨਥ ਨੇ ਮਨੱਸ਼ਹ ਅਤੇ ਇਫ਼ਰਾਈਮ ਨੂੰ ਜਨਮ ਦਿੱਤਾ। ");
INSERT INTO pan_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","ਬਿਨਯਾਮੀਨ ਦੇ ਪੁੱਤਰ: ਬਲਾ, ਬਕਰ, ਅਸ਼ਬੇਲ, ਗੇਰਾ, ਨਅਮਾਨ, ਏਹੀ, ਰੋਸ਼, ਮੁੱਫੀਮ, ਹੁੱਪੀਮ ਅਤੇ ਅਰਦ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","ਇਹ ਰਾਖ਼ੇਲ ਦੇ ਪੁੱਤਰ ਸਨ, ਜਿਹਨਾਂ ਨੂੰ ਉਸ ਨੇ ਯਾਕੂਬ ਲਈ ਜੰਮਿਆ ਸੀ, ਉਹ ਸਾਰੇ ਚੌਦਾਂ ਪ੍ਰਾਣੀ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","ਦਾਨ ਦਾ ਪੁੱਤਰ ਹੁਸ਼ੀਮ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","ਨਫ਼ਤਾਲੀ ਦੇ ਪੁੱਤਰ: ਯਹਸਏਲ, ਗੂਨੀ, ਯੇਸਰ ਅਤੇ ਸ਼ਿੱਲੇਮ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","ਇਹ ਬਿਲਹਾਹ ਦੇ ਪੁੱਤਰ ਸਨ, ਜਿਸ ਨੂੰ ਲਾਬਾਨ ਨੇ ਆਪਣੀ ਧੀ ਰਾਖ਼ੇਲ ਨੂੰ ਦਿੱਤਾ ਸੀ ਅਤੇ ਉਸ ਨੇ ਯਾਕੂਬ ਦੇ ਲਈ ਇਨ੍ਹਾਂ ਸੱਤ ਪ੍ਰਾਣੀ ਨੂੰ ਜਨਮ ਦਿੱਤਾ। ");
INSERT INTO pan_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","ਯਾਕੂਬ ਦੇ ਨਿੱਜ ਵੰਸ਼ ਵਿੱਚੋਂ ਸਾਰੇ ਪ੍ਰਾਣੀ ਜਿਹੜੇ ਉਸ ਦੇ ਨਾਲ ਮਿਸਰ ਵਿੱਚ ਆਏ, ਉਸ ਦੀਆਂ ਨੂੰਹਾਂ ਤੋਂ ਬਿਨ੍ਹਾਂ ਛਿਆਹਠ ਪ੍ਰਾਣੀ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","ਯੂਸੁਫ਼ ਦੇ ਪੁੱਤਰ ਜਿਹੜੇ ਉਸ ਤੋਂ ਮਿਸਰ ਵਿੱਚ ਜੰਮੇ ਦੋ ਪ੍ਰਾਣੀ ਸਨ। ਇਸ ਤਰ੍ਹਾਂ ਉਹ ਸਾਰੇ ਜਿਹੜੇ ਯਾਕੂਬ ਦੇ ਘਰਾਣੇ ਤੋਂ ਮਿਸਰ ਵਿੱਚ ਆਏ ਸਨ, ਸੱਤਰ ਪ੍ਰਾਣੀ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","ਉਸ ਨੇ ਯਹੂਦਾਹ ਨੂੰ ਯੂਸੁਫ਼ ਦੇ ਕੋਲ ਆਪਣੇ ਅੱਗੇ-ਅੱਗੇ ਭੇਜਿਆ ਤਾਂ ਜੋ ਉਹ ਉਸ ਨੂੰ ਗੋਸ਼ਨ ਦਾ ਰਾਹ ਵਿਖਾਵੇ, ਅਤੇ ਓਹ ਗੋਸ਼ਨ ਦੇ ਦੇਸ਼ ਵਿੱਚ ਆਏ। ");
INSERT INTO pan_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","ਤਦ ਯੂਸੁਫ਼ ਨੇ ਆਪਣਾ ਰਥ ਜੋੜਿਆ ਅਤੇ ਆਪਣੇ ਪਿਤਾ ਇਸਰਾਏਲ ਨੂੰ ਮਿਲਣ ਲਈ ਗੋਸ਼ਨ ਨੂੰ ਗਿਆ ਅਤੇ ਉਸ ਦੇ ਅੱਗੇ ਹਾਜ਼ਰ ਹੋਇਆ ਅਤੇ ਉਸ ਦੇ ਗਲ਼ ਲੱਗਾ ਅਤੇ ਬਹੁਤ ਦੇਰ ਤੱਕ ਉਸ ਦੇ ਗਲ਼ ਨਾਲ ਲੱਗ ਕੇ ਰੋਇਆ। ");
INSERT INTO pan_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","ਫੇਰ ਇਸਰਾਏਲ ਨੇ ਯੂਸੁਫ਼ ਨੂੰ ਆਖਿਆ, ਹੁਣ ਮੈਨੂੰ ਮਰਨ ਦੇ ਕਿਉਂ ਜੋ ਮੈਂ ਤੇਰਾ ਮੂੰਹ ਵੇਖ ਲਿਆ ਹੈ ਕਿ ਤੂੰ ਅਜੇ ਜੀਉਂਦਾ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","ਤਦ ਯੂਸੁਫ਼ ਨੇ ਆਪਣੇ ਭਰਾਵਾਂ ਅਤੇ ਆਪਣੇ ਪਿਤਾ ਦੇ ਘਰਾਣੇ ਨੂੰ ਆਖਿਆ, ਮੈਂ ਫ਼ਿਰਊਨ ਕੋਲ ਖ਼ਬਰ ਦੇਣ ਜਾਂਦਾ ਹਾਂ ਅਤੇ ਉਸ ਨੂੰ ਆਖਾਂਗਾ ਕਿ ਮੇਰੇ ਭਰਾ ਅਤੇ ਮੇਰੇ ਪਿਤਾ ਦਾ ਘਰਾਣਾ, ਜਿਹੜਾ ਕਨਾਨ ਦੇਸ਼ ਵਿੱਚ ਸੀ, ਮੇਰੇ ਕੋਲ ਆ ਗਿਆ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","ਓਹ ਮਨੁੱਖ ਆਜੜੀ ਹਨ ਕਿਉਂ ਜੋ ਓਹ ਪਸ਼ੂਆਂ ਨੂੰ ਪਾਲਣ ਵਾਲੇ ਹਨ ਅਤੇ ਓਹ ਆਪਣੇ ਇੱਜੜ ਅਤੇ ਵੱਗ ਅਤੇ ਸਭ ਕੁਝ ਜੋ ਉਨ੍ਹਾਂ ਦਾ ਹੈ, ਨਾਲ ਲੈ ਕੇ ਆਏ ਹਨ। ");
INSERT INTO pan_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","ਜਦ ਫ਼ਿਰਊਨ ਤੁਹਾਨੂੰ ਬੁਲਾਏ ਅਤੇ ਪੁੱਛੇ ਕਿ ਤੁਸੀਂ ਕੀ ਕੰਮ ਕਰਦੇ ਹੋ? ");
INSERT INTO pan_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","ਤਦ ਤੁਸੀਂ ਇਹ ਆਖਣਾ, ਤੁਹਾਡੇ ਦਾਸ ਜਵਾਨੀ ਤੋਂ ਲੈ ਕੇ ਹੁਣ ਤੱਕ ਪਸ਼ੂ ਪਾਲਦੇ ਰਹੇ ਹਨ, ਅਸੀਂ ਵੀ ਅਤੇ ਸਾਡੇ ਪਿਓ ਦਾਦੇ ਵੀ ਤਦ ਤੁਸੀਂ ਗੋਸ਼ਨ ਦੇਸ਼ ਵਿੱਚ ਵੱਸ ਜਾਓਗੇ ਕਿਉਂ ਜੋ ਮਿਸਰੀ ਸਾਰੇ ਆਜੜੀਆਂ ਤੋਂ ਘਿਰਣਾ ਕਰਦੇ ਹਨ। ");
INSERT INTO pan_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","ਯੂਸੁਫ਼ ਗਿਆ ਅਤੇ ਫ਼ਿਰਊਨ ਨੂੰ ਦੱਸਿਆ, ਮੇਰਾ ਪਿਤਾ ਅਤੇ ਭਰਾ, ਉਨ੍ਹਾਂ ਦੇ ਇੱਜੜ ਅਤੇ ਚੌਣੇ ਅਤੇ ਸਭ ਕੁਝ ਜੋ ਉਨ੍ਹਾਂ ਦਾ ਹੈ, ਕਨਾਨ ਦੇਸ਼ ਤੋਂ ਆ ਗਏ ਹਨ ਅਤੇ ਵੇਖੋ, ਓਹ ਗੋਸ਼ਨ ਦੇਸ਼ ਵਿੱਚ ਹਨ। ");
INSERT INTO pan_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","ਤਦ ਉਸਨੇ ਆਪਣੇ ਭਰਾਵਾਂ ਵਿੱਚੋਂ ਪੰਜ ਮਨੁੱਖ ਲੈ ਕੇ ਫ਼ਿਰਊਨ ਦੇ ਸਨਮੁਖ ਖੜ੍ਹੇ ਕੀਤੇ। ");
INSERT INTO pan_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","ਫ਼ਿਰਊਨ ਨੇ ਉਹ ਦੇ ਭਰਾਵਾਂ ਨੂੰ ਆਖਿਆ, ਕੀ ਕੰਮ ਹੈ? ਉਨ੍ਹਾਂ ਨੇ ਫ਼ਿਰਊਨ ਨੂੰ ਆਖਿਆ, ਤੁਹਾਡੇ ਦਾਸ ਅਯਾਲੀ ਹਨ ਅਸੀਂ ਵੀ ਅਤੇ ਸਾਡੇ ਪਿਓ ਦਾਦੇ ਵੀ। ");
INSERT INTO pan_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","ਫੇਰ ਉਨ੍ਹਾਂ ਨੇ ਫ਼ਿਰਊਨ ਨੂੰ ਆਖਿਆ, ਅਸੀਂ ਇਸ ਦੇਸ਼ ਵਿੱਚ ਪਰਦੇਸੀ ਹੋ ਕੇ ਵੱਸਣ ਲਈ ਆਏ ਹਾਂ ਕਿਉਂ ਜੋ ਤੁਹਾਡੇ ਦਾਸਾਂ ਦੇ ਇੱਜੜਾਂ ਲਈ ਕੋਈ ਚਰਾਈ ਨਹੀਂ, ਕਿਉਂ ਜੋ ਕਨਾਨ ਦੇਸ਼ ਵਿੱਚ ਡਾਢਾ ਕਾਲ ਪਿਆ ਹੋਇਆ ਹੈ ਸੋ ਹੁਣ ਆਪਣੇ ਦਾਸਾਂ ਨੂੰ ਗੋਸ਼ਨ ਦੇਸ਼ ਵਿੱਚ ਰਹਿਣ ਦੀ ਆਗਿਆ ਦਿਓ। ");
INSERT INTO pan_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","ਤਦ ਫ਼ਿਰਊਨ ਨੇ ਯੂਸੁਫ਼ ਨੂੰ ਆਖਿਆ, ਤੇਰਾ ਪਿਤਾ ਅਤੇ ਤੇਰੇ ਭਰਾ ਤੇਰੇ ਕੋਲ ਆਏ ਹਨ। ");
INSERT INTO pan_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","ਮਿਸਰ ਦੇਸ਼ ਤੇਰੇ ਅੱਗੇ ਹੈ। ਆਪਣੇ ਪਿਤਾ ਅਤੇ ਆਪਣੇ ਭਰਾਵਾਂ ਨੂੰ ਸਭ ਤੋਂ ਚੰਗੀ ਧਰਤੀ ਵਿੱਚ ਵਸਾ ਅਰਥਾਤ ਗੋਸ਼ਨ ਦੇ ਦੇਸ਼ ਵਿੱਚ ਵੱਸਣ ਦੇ ਅਤੇ ਜੇਕਰ ਤੂੰ ਜਾਣਦਾ ਹੈਂ ਜੋ ਉਨ੍ਹਾਂ ਵਿੱਚ ਸਿਆਣੇ ਮਨੁੱਖ ਹਨ ਤਾਂ ਉਨ੍ਹਾਂ ਨੂੰ ਮੇਰੇ ਮਾਲ ਡੰਗਰ ਉੱਤੇ ਠਹਿਰਾ ਦੇ। ");
INSERT INTO pan_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","ਤਦ ਯੂਸੁਫ਼ ਨੇ ਆਪਣੇ ਪਿਤਾ ਯਾਕੂਬ ਨੂੰ ਲਿਆਂਦਾ ਅਤੇ ਫ਼ਿਰਊਨ ਦੇ ਸਨਮੁਖ ਖੜ੍ਹਾ ਕੀਤਾ ਅਤੇ ਯਾਕੂਬ ਨੇ ਫ਼ਿਰਊਨ ਨੂੰ ਬਰਕਤ ਦਿੱਤੀ। ");
INSERT INTO pan_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","ਫ਼ਿਰਊਨ ਨੇ ਯਾਕੂਬ ਨੂੰ ਆਖਿਆ, ਤੁਹਾਡੀ ਉਮਰ ਕਿੰਨ੍ਹੀ ਹੈ? ");
INSERT INTO pan_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","ਯਾਕੂਬ ਨੇ ਫ਼ਿਰਊਨ ਨੂੰ ਆਖਿਆ, ਮੇਰੇ ਮੁਸਾਫ਼ਰੀ ਦੇ ਦਿਨ ਇੱਕ ਸੌ ਤੀਹ ਸਾਲ ਹਨ। ਮੇਰੇ ਜੀਵਨ ਦੇ ਦਿਨ ਥੋੜ੍ਹੇ ਅਤੇ ਦੁੱਖ ਨਾਲ ਭਰੇ ਹੋਏ ਸਨ, ਅਤੇ ਮੇਰੇ ਪਿਓ ਦਾਦਿਆਂ ਦੇ ਮੁਸਾਫ਼ਰੀ ਦੇ ਜੀਵਨ ਦੇ ਸਾਲਾਂ ਦੇ ਬਰਾਬਰ ਨਹੀਂ ਹੋਏ ਹਨ। ");
INSERT INTO pan_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","ਫੇਰ ਯਾਕੂਬ ਫ਼ਿਰਊਨ ਨੂੰ ਬਰਕਤ ਦੇ ਕੇ ਫ਼ਿਰਊਨ ਦੇ ਹਜ਼ੂਰੋਂ ਨਿੱਕਲ ਆਇਆ। ");
INSERT INTO pan_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","ਯੂਸੁਫ਼ ਨੇ ਆਪਣੇ ਪਿਤਾ ਅਤੇ ਆਪਣੇ ਭਰਾਵਾਂ ਨੂੰ ਵਸਾਇਆ ਅਤੇ ਉਨ੍ਹਾਂ ਨੂੰ ਮਿਸਰ ਦੇਸ਼ ਦੀ ਸਭ ਤੋਂ ਚੰਗੀ ਧਰਤੀ ਅਰਥਾਤ ਰਾਮਸੇਸ ਦੀ ਧਰਤੀ ਵਿੱਚ, ਜਿਵੇਂ ਫ਼ਿਰਊਨ ਨੇ ਹੁਕਮ ਦਿੱਤਾ ਸੀ, ਵਿਰਾਸਤ ਵਿੱਚ ਦਿੱਤੀ। ");
INSERT INTO pan_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","ਅਤੇ ਯੂਸੁਫ਼ ਆਪਣੇ ਪਿਤਾ, ਅਤੇ ਆਪਣੇ ਭਰਾਵਾਂ, ਆਪਣੇ ਪਿਤਾ ਦੇ ਘਰਾਣੇ ਦੀ, ਉਨ੍ਹਾਂ ਦੇ ਬੱਚਿਆਂ ਦੀ ਲੋੜ ਅਨੁਸਾਰ ਭੋਜਨ ਮੁਹੱਈਆ ਕਰ ਕੇ ਪਾਲਣਾ ਕਰਦਾ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","ਸਾਰੀ ਧਰਤੀ ਉੱਤੇ ਭੋਜਨ ਨਹੀਂ ਸੀ ਕਿਉਂ ਜੋ ਕਾਲ ਭਾਰੀ ਸੀ ਅਤੇ ਮਿਸਰ ਦੇਸ਼ ਅਤੇ ਕਨਾਨ ਦੇਸ਼ ਕਾਲ ਦੇ ਕਾਰਨ ਨਾਸ ਹੋ ਗਏ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","ਯੂਸੁਫ਼ ਨੇ ਸਾਰੀ ਚਾਂਦੀ, ਜਿਹੜੀ ਮਿਸਰ ਦੇ ਦੇਸ਼ ਵਿੱਚੋਂ ਅਤੇ ਕਨਾਨ ਦੇ ਦੇਸ਼ ਵਿੱਚੋਂ ਅੰਨ ਮੁੱਲ ਲੈਣ ਦੇ ਬਦਲੇ ਮਿਲੀ, ਇਕੱਠੀ ਕਰ ਲਈ ਅਤੇ ਯੂਸੁਫ਼ ਨੇ ਉਹ ਚਾਂਦੀ ਫ਼ਿਰਊਨ ਦੇ ਘਰ ਲੈ ਆਂਦੀ। ");
INSERT INTO pan_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","ਜਦ ਮਿਸਰ ਦੇਸ਼ ਅਤੇ ਕਨਾਨ ਦੇਸ਼ ਦੀ ਚਾਂਦੀ ਖ਼ਰਚ ਹੋ ਗਈ ਤਦ ਸਾਰੇ ਮਿਸਰੀ ਇਹ ਆਖਣ ਲਈ ਯੂਸੁਫ਼ ਕੋਲ ਆਏ ਕਿ ਸਾਨੂੰ ਰੋਟੀ ਦਿਓ। ਅਸੀਂ ਤੁਹਾਡੇ ਅੱਗੇ ਕਿਉਂ ਮਰੀਏ ਕਿਉਂ ਜੋ ਚਾਂਦੀ ਮੁੱਕ ਗਈ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","ਤਦ ਯੂਸੁਫ਼ ਨੇ ਆਖਿਆ, ਆਪਣੇ ਮਾਲ ਡੰਗਰ ਦਿਓ ਅਤੇ ਜੇ ਚਾਂਦੀ ਮੁੱਕ ਗਈ ਹੈ ਤਾਂ ਮੈਂ ਤੁਹਾਨੂੰ ਪਸ਼ੂਆਂ ਦੇ ਬਦਲੇ ਅੰਨ੍ਹ ਦਿਆਂਗਾ। ");
INSERT INTO pan_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","ਤਦ ਓਹ ਆਪਣੇ ਮਾਲ ਡੰਗਰ ਯੂਸੁਫ਼ ਕੋਲ ਲਿਆਏ ਅਤੇ ਯੂਸੁਫ਼ ਨੇ ਉਨ੍ਹਾਂ ਦੇ ਘੋੜਿਆਂ, ਪਸ਼ੂਆਂ, ਇੱਜੜਾਂ ਅਤੇ ਗਧਿਆਂ ਦੇ ਬਦਲੇ ਉਨ੍ਹਾਂ ਨੂੰ ਅੰਨ ਦਿੱਤਾ ਅਤੇ ਉਸ ਸਾਰੇ ਸਾਲ ਉਸ ਨੇ ਉਨ੍ਹਾਂ ਨੂੰ ਮਾਲ ਡੰਗਰਾਂ ਦੇ ਬਦਲੇ ਰੋਟੀ ਖਵਾਈ। ");
INSERT INTO pan_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","ਜਦ ਉਹ ਸਾਲ ਬੀਤ ਗਿਆ ਤਾਂ ਦੂਜੇ ਸਾਲ ਓਹ ਉਹ ਦੇ ਕੋਲ ਫੇਰ ਆਏ ਅਤੇ ਉਸ ਨੂੰ ਆਖਿਆ, ਅਸੀਂ ਆਪਣੇ ਸੁਆਮੀ ਤੋਂ ਲੁਕਾ ਨਹੀਂ ਸਕਦੇ ਕਿ ਸਾਡੀ ਚਾਂਦੀ ਮੁੱਕ ਗਈ ਹੈ ਅਤੇ ਮਾਲ ਡੰਗਰ ਵੀ ਸਾਡੇ ਸੁਆਮੀ ਦੇ ਹੋ ਗਏ ਹਨ ਸੋ ਹੁਣ ਸਾਡੇ ਸੁਆਮੀ ਦੇ ਅੱਗੇ ਸਾਡੇ ਸਰੀਰਾਂ ਅਤੇ ਜ਼ਮੀਨ ਤੋਂ ਬਿਨ੍ਹਾਂ ਹੋਰ ਕੁਝ ਬਾਕੀ ਨਹੀਂ ਰਿਹਾ। ");
INSERT INTO pan_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","ਅਸੀਂ ਤੁਹਾਡੇ ਅੱਗੇ ਕਿਉਂ ਨਾਸ ਹੋਈਏ ਅਸੀਂ ਵੀ ਅਤੇ ਸਾਡੀ ਜ਼ਮੀਨ ਵੀ। ਸਾਨੂੰ ਅਤੇ ਸਾਡੀ ਜ਼ਮੀਨ ਨੂੰ ਰੋਟੀ ਦੇ ਬਦਲੇ ਮੁੱਲ ਲੈ ਲਓ। ਅਸੀਂ ਆਪਣੀ ਜ਼ਮੀਨ ਸਮੇਤ ਫ਼ਿਰਊਨ ਦੇ ਦਾਸ ਹੋਵਾਂਗੇ, ਪਰ ਸਾਨੂੰ ਬੀਜ ਦਿਓ ਜੋ ਅਸੀਂ ਜੀਵੀਏ ਅਤੇ ਮਰੀਏ ਨਾ ਅਤੇ ਜ਼ਮੀਨ ਉੱਜੜ ਨਾ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","ਤਦ ਯੂਸੁਫ਼ ਨੇ ਮਿਸਰ ਦੀ ਸਾਰੀ ਜ਼ਮੀਨ ਫ਼ਿਰਊਨ ਲਈ ਮੁੱਲ ਲੈ ਲਈ, ਕਿਉਂ ਜੋ ਮਿਸਰੀਆਂ ਵਿੱਚੋਂ ਸਭਨਾਂ ਨੇ ਆਪੋ ਆਪਣੇ ਖੇਤ ਉਸ ਕਾਲ ਦੇ ਕਾਰਨ ਇਸ ਕਰਕੇ ਵੇਚ ਦਿੱਤੇ, ਸੋ ਉਹ ਧਰਤੀ ਫ਼ਿਰਊਨ ਦੀ ਹੋ ਗਈ। ");
INSERT INTO pan_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","ਯੂਸੁਫ਼ ਨੇ ਉਨ੍ਹਾਂ ਲੋਕਾਂ ਨੂੰ ਮਿਸਰ ਦੀ ਇੱਕ ਹੱਦ ਤੋਂ ਦੂਜੀ ਹੱਦ ਤੱਕ, ਨਗਰਾਂ ਵਿੱਚ ਗ਼ੁਲਾਮ ਬਣਾਇਆ। ");
INSERT INTO pan_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","ਕੇਵਲ ਜਾਜਕਾਂ ਦੀ ਜ਼ਮੀਨ ਮੁੱਲ ਨਾ ਲਈ, ਕਿਉਂ ਜੋ ਜਾਜਕਾਂ ਨੂੰ ਫ਼ਿਰਊਨ ਵੱਲੋਂ ਸ਼ਾਹੀ ਭੋਜਨ ਦਾ ਪ੍ਰਬੰਧ ਸੀ ਅਤੇ ਉਨ੍ਹਾਂ ਨੇ ਸ਼ਾਹੀ ਭੋਜਨ ਵਿੱਚੋਂ ਜੋ ਫ਼ਿਰਊਨ ਨੇ ਉਨ੍ਹਾਂ ਨੂੰ ਦਿੱਤਾ ਸੀ, ਖਾਧਾ ਇਸ ਕਾਰਨ ਉਨ੍ਹਾਂ ਨੇ ਆਪਣੀ ਜ਼ਮੀਨ ਨਾ ਵੇਚੀ। ");
INSERT INTO pan_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","ਤਦ ਯੂਸੁਫ਼ ਨੇ ਲੋਕਾਂ ਨੂੰ ਆਖਿਆ, ਵੇਖੋ ਮੈਂ ਤੁਹਾਨੂੰ ਅਤੇ ਤੁਹਾਡੀ ਜ਼ਮੀਨ ਨੂੰ ਅੱਜ ਦੇ ਦਿਨ ਫ਼ਿਰਊਨ ਲਈ ਮੁੱਲ ਲੈ ਲਿਆ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","ਵੇਖੋ, ਬੀਜ ਤੁਹਾਡੇ ਲਈ ਹੈ। ਜ਼ਮੀਨ ਬੀਜੋ। ਅਤੇ ਫ਼ਸਲਾਂ ਉੱਤੇ ਪੰਜਵਾਂ ਹਿੱਸਾ ਤੁਹਾਨੂੰ ਫ਼ਿਰਊਨ ਨੂੰ ਦੇਣਾ ਪਵੇਗਾ ਅਤੇ ਬਾਕੀ ਚਾਰ ਹਿੱਸੇ ਤੁਹਾਡੇ ਹੋਣਗੇ ਖੇਤ ਦੇ ਬੀਜ ਲਈ ਅਤੇ ਤੁਹਾਡੇ, ਘਰਾਣੇ ਅਤੇ ਤੁਹਾਡੇ ਬੱਚਿਆਂ ਦੇ ਖਾਣ ਲਈ ਹੋਣਗੇ। ");
INSERT INTO pan_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","ਉਨ੍ਹਾਂ ਆਖਿਆ, ਤੁਸੀਂ ਸਾਡੀਆਂ ਜਾਨਾਂ ਬਚਾਈਆਂ ਹਨ। ਸਾਡੇ ਸੁਆਮੀ ਦੀ ਆਪਣੇ ਦਾਸਾਂ ਉੱਤੇ ਕਿਰਪਾ ਦੀ ਨਿਗਾਹ ਹੋਵੇ ਅਤੇ ਅਸੀਂ ਫ਼ਿਰਊਨ ਦੇ ਦਾਸ ਹੋਵਾਂਗੇ। ");
INSERT INTO pan_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","ਸੋ ਯੂਸੁਫ਼ ਨੇ ਮਿਸਰ ਦੀ ਜ਼ਮੀਨ ਲਈ ਉਹ ਕਨੂੰਨ ਜਿਹੜਾ ਅੱਜ ਦੇ ਦਿਨ ਤੱਕ ਹੈ, ਠਹਿਰਾਇਆ ਜੋ ਪੰਜਵਾਂ ਹਿੱਸਾ ਫ਼ਿਰਊਨ ਦਾ ਹੋਵੇ ਪਰ ਸਿਰਫ਼ ਜਾਜਕਾਂ ਦੀ ਜ਼ਮੀਨ ਉਨ੍ਹਾਂ ਦੀ ਹੀ ਰਹੀ। ਓਹ ਫ਼ਿਰਊਨ ਦੀ ਨਾ ਹੋਈ। ");
INSERT INTO pan_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","ਇਸਰਾਏਲੀ ਮਿਸਰ ਦੀ ਅਤੇ ਗੋਸ਼ਨ ਦੀ ਧਰਤੀ ਵਿੱਚ ਰਹੇ ਅਤੇ ਉਨ੍ਹਾਂ ਨੇ ਉੱਥੇ ਵਿਰਾਸਤ ਪ੍ਰਾਪਤ ਕੀਤੀ ਅਤੇ ਉੱਥੇ ਓਹ ਬਹੁਤ ਹੀ ਫਲੇ ਅਤੇ ਵਧੇ। ");
INSERT INTO pan_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","ਅਤੇ ਯਾਕੂਬ ਮਿਸਰ ਦੇਸ਼ ਵਿੱਚ ਸਤਾਰਾਂ ਸਾਲ ਜਿਉਂਦਾ ਰਿਹਾ, ਸੋ ਯਾਕੂਬ ਦੀ ਸਾਰੀ ਉਮਰ ਇੱਕ ਸੌ ਸੰਤਾਲੀ ਸਾਲ ਦੀ ਹੋਈ। ");
INSERT INTO pan_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","ਜਦ ਇਸਰਾਏਲ ਦੇ ਮਰਨ ਦੇ ਦਿਨ ਨੇੜੇ ਆਏ ਤਾਂ ਉਸ ਆਪਣੇ ਪੁੱਤਰ ਯੂਸੁਫ਼ ਨੂੰ ਬੁਲਾ ਕੇ ਆਖਿਆ, ਹੁਣ ਜੇ ਮੇਰੇ ਉੱਤੇ ਤੇਰੀ ਕਿਰਪਾ ਹੈ ਤਾਂ ਤੂੰ ਆਪਣਾ ਹੱਥ ਮੇਰੇ ਪੱਟ ਹੇਠ ਰੱਖ ਅਤੇ ਕਿਰਪਾ ਅਤੇ ਸਚਿਆਈ ਨਾਲ ਮੇਰੇ ਨਾਲ ਵਰਤਾਉ ਕਰੀਂ। ");
INSERT INTO pan_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","ਮੈਨੂੰ ਮਿਸਰ ਵਿੱਚ ਨਾ ਦੱਬੀਂ। ਪਰ ਜਦ ਮੈਂ ਆਪਣੇ ਪਿਓ ਦਾਦਿਆਂ ਨਾਲ ਮਿਲ ਜਾਂਵਾਂ ਤਾਂ ਤੂੰ ਮੈਨੂੰ ਮਿਸਰ ਤੋਂ ਬਾਹਰ ਲੈ ਜਾਵੀਂ ਅਤੇ ਉਨ੍ਹਾਂ ਦੇ ਕਬਰਿਸਤਾਨ ਵਿੱਚ ਮੈਨੂੰ ਦੱਬੀਂ ਤਾਂ ਯੂਸੁਫ਼ ਨੇ ਆਖਿਆ, ਮੈਂ ਤੇਰੇ ਆਖੇ ਦੇ ਅਨੁਸਾਰ ਹੀ ਕਰਾਂਗਾ। ");
INSERT INTO pan_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","ਅਤੇ ਉਸ ਆਖਿਆ, ਮੇਰੇ ਨਾਲ ਸਹੁੰ ਖਾ ਤਾਂ ਉਸ ਨੇ ਉਸ ਦੇ ਨਾਲ ਸਹੁੰ ਖਾਧੀ ਅਤੇ ਇਸਰਾਏਲ ਨੇ ਆਪਣੇ ਮੰਜੇ ਦੇ ਸਿਰਹਾਣੇ ਉੱਤੇ ਸਿਰ ਝੁਕਾ ਕੇ ਪ੍ਰਾਰਥਨਾ ਕੀਤੀ। ");
INSERT INTO pan_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","ਕੁਝ ਦਿਨਾਂ ਤੋਂ ਬਾਅਦ ਇਹ ਹੋਇਆ ਕਿ ਕਿਸੇ ਨੇ ਯੂਸੁਫ਼ ਨੂੰ ਆਖਿਆ, ਵੇਖੋ, ਤੁਹਾਡਾ ਪਿਤਾ ਬਿਮਾਰ ਹੈ। ਤਦ ਉਸ ਨੇ ਆਪਣੇ ਦੋਹਾਂ ਪੁੱਤਰਾਂ ਮਨੱਸ਼ਹ ਅਤੇ ਇਫ਼ਰਾਈਮ ਨੂੰ ਆਪਣੇ ਨਾਲ ਲਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","ਕਿਸੇ ਨੇ ਯਾਕੂਬ ਨੂੰ ਦੱਸਿਆ, ਵੇਖੋ ਤੁਹਾਡਾ ਪੁੱਤਰ ਯੂਸੁਫ਼ ਤੁਹਾਡੇ ਕੋਲ ਆਉਂਦਾ ਹੈ। ਤਦ ਇਸਰਾਏਲ ਆਪਣੇ ਆਪ ਨੂੰ ਤਕੜਾ ਕਰ ਕੇ ਆਪਣੇ ਮੰਜੇ ਉੱਤੇ ਬੈਠ ਗਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","ਯਾਕੂਬ ਨੇ ਯੂਸੁਫ਼ ਨੂੰ ਆਖਿਆ, ਸਰਬ ਸ਼ਕਤੀਮਾਨ ਪਰਮੇਸ਼ੁਰ ਨੇ ਮੈਨੂੰ ਕਨਾਨ ਦੇਸ਼ ਵਿੱਚ ਲੂਜ਼ ਕੋਲ ਦਰਸ਼ਣ ਦਿੱਤਾ ਅਤੇ ਮੈਨੂੰ ਬਰਕਤ ਦਿੱਤੀ ");
INSERT INTO pan_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","ਅਤੇ ਮੈਨੂੰ ਆਖਿਆ, ਵੇਖ, ਮੈਂ ਤੈਨੂੰ ਫਲਵੰਤ ਕਰਾਂਗਾ ਅਤੇ ਤੈਨੂੰ ਵਧਾਵਾਂਗਾ ਅਤੇ ਤੈਥੋਂ ਬਹੁਤ ਸਾਰੀਆਂ ਕੌਮਾਂ ਬਣਾਵਾਂਗਾ ਅਤੇ ਤੇਰੇ ਬਾਅਦ ਇਹ ਦੇਸ਼ ਸਦਾ ਲਈ ਤੇਰੇ ਵੰਸ਼ ਦੀ ਵਿਰਾਸਤ ਹੋਣ ਲਈ ਦੇ ਦਿਆਂਗਾ। ");
INSERT INTO pan_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","ਹੁਣ ਤੇਰੇ ਦੋਵੇਂ ਪੁੱਤਰ ਜਿਹੜੇ ਮਿਸਰ ਵਿੱਚ ਮੇਰੇ ਆਉਣ ਤੋਂ ਪਹਿਲਾਂ ਪੈਦਾ ਹੋਏ ਸਨ, ਉਹ ਮੇਰੇ ਹੀ ਹਨ। ਰਊਬੇਨ ਅਤੇ ਸ਼ਿਮਓਨ ਵਾਂਗੂੰ ਇਫ਼ਰਾਈਮ ਅਤੇ ਮਨੱਸ਼ਹ ਮੇਰੇ ਹੀ ਪੁੱਤਰ ਹਨ, ");
INSERT INTO pan_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","ਅਤੇ ਉਨ੍ਹਾਂ ਦੇ ਬਾਅਦ ਜਿਹੜੀ ਸੰਤਾਨ ਤੈਥੋਂ ਪੈਦਾ ਹੋਵੇਗੀ, ਉਹ ਤੇਰੀ ਹੋਵੇਗੀ। ਪਰ ਓਹ ਆਪਣੇ ਹਿੱਸੇ ਦੀ ਵੰਡ ਵਿੱਚ ਆਪਣੇ ਭਰਾਵਾਂ ਦੇ ਨਾਮ ਤੋਂ ਪੁਕਾਰੀ ਜਾਵੇਗੀ। ");
INSERT INTO pan_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","ਜਦ ਮੈਂ ਪਦਨ ਤੋਂ ਆ ਰਿਹਾ ਸੀ, ਤਦ ਰਸਤੇ ਵਿੱਚ ਜਦ ਅਫਰਾਥ ਥੋੜ੍ਹੀ ਹੀ ਦੂਰ ਰਹਿ ਗਿਆ ਸੀ ਤਾਂ ਕਨਾਨ ਦੇਸ਼ ਵਿੱਚ ਰਾਖ਼ੇਲ ਮੇਰੇ ਸਾਹਮਣੇ ਮਰ ਗਈ ਅਤੇ ਮੈਂ ਉਸ ਨੂੰ ਉੱਥੇ ਹੀ ਅਫਰਾਥ ਜੋ ਬੈਤਲਹਮ ਵੀ ਅਖਵਾਉਂਦਾ ਹੈ, ਦੇ ਰਸਤੇ ਵਿੱਚ ਦਫ਼ਨਾ ਦਿੱਤਾ। ");
INSERT INTO pan_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","ਇਹੋ ਹੀ ਬੈਤਲਹਮ ਹੈ। ਫੇਰ ਇਸਰਾਏਲ ਨੇ ਯੂਸੁਫ਼ ਦੇ ਪੁੱਤਰਾਂ ਨੂੰ ਵੇਖ ਕੇ ਆਖਿਆ, ਇਹ ਕੌਣ ਹਨ? ");
INSERT INTO pan_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","ਯੂਸੁਫ਼ ਨੇ ਆਪਣੇ ਪਿਤਾ ਨੂੰ ਆਖਿਆ, ਇਹ ਮੇਰੇ ਪੁੱਤਰ ਹਨ, ਜਿਹੜੇ ਪਰਮੇਸ਼ੁਰ ਨੇ ਮੈਨੂੰ ਇੱਥੇ ਦਿੱਤੇ ਹਨ। ਉਸ ਨੇ ਆਖਿਆ, ਉਨ੍ਹਾਂ ਨੂੰ ਮੇਰੇ ਕੋਲ ਲਿਆ ਤਾਂ ਜੋ ਮੈਂ ਉਨ੍ਹਾਂ ਨੂੰ ਬਰਕਤ ਦੇਵਾਂ। ");
INSERT INTO pan_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","ਪਰ ਬਜ਼ੁਰਗ ਹੋਣ ਦੇ ਕਾਰਨ ਇਸਰਾਏਲ ਦੀਆਂ ਅੱਖਾਂ ਧੁੰਦਲੀਆਂ ਹੋ ਗਈਆਂ ਸਨ, ਕਿ ਉਹ ਵੇਖ ਨਹੀਂ ਸਕਦਾ ਸੀ, ਤਦ ਯੂਸੁਫ਼ ਉਨ੍ਹਾਂ ਨੂੰ ਉਸ ਦੇ ਕੋਲ ਲਿਆਇਆ ਤਾਂ ਉਸ ਨੇ ਉਨ੍ਹਾਂ ਨੂੰ ਚੁੰਮਿਆ ਅਤੇ ਉਨ੍ਹਾਂ ਨੂੰ ਗਲ਼ ਲਾਇਆ ");
INSERT INTO pan_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","ਅਤੇ ਇਸਰਾਏਲ ਨੇ ਯੂਸੁਫ਼ ਨੂੰ ਆਖਿਆ, ਮੈਨੂੰ ਤਾਂ ਤੇਰਾ ਮੂੰਹ ਵੇਖਣ ਦੀ ਆਸ ਵੀ ਨਹੀਂ ਸੀ, ਪਰ ਵੇਖ ਤੇਰੀ ਅੰਸ ਵੀ ਪਰਮੇਸ਼ੁਰ ਨੇ ਮੈਨੂੰ ਵਿਖਾਲ ਦਿੱਤੀ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","ਤਦ ਯੂਸੁਫ਼ ਨੇ ਉਨ੍ਹਾਂ ਨੂੰ ਆਪਣੇ ਗੋਡਿਆਂ ਵਿੱਚੋਂ ਕੱਢਿਆ ਅਤੇ ਆਪਣਾ ਮੂੰਹ ਧਰਤੀ ਤੱਕ ਨਿਵਾਇਆ ");
INSERT INTO pan_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","ਅਤੇ ਯੂਸੁਫ਼ ਨੇ ਉਨ੍ਹਾਂ ਦੋਹਾਂ ਨੂੰ ਲਿਆ, ਇਫ਼ਰਾਈਮ ਨੂੰ ਆਪਣੇ ਸੱਜੇ ਹੱਥ ਨਾਲ ਇਸਰਾਏਲ ਦੇ ਖੱਬੇ ਪਾਸੇ, ਅਤੇ ਮਨੱਸ਼ਹ ਨੂੰ ਆਪਣੇ ਖੱਬੇ ਹੱਥ ਨਾਲ ਇਸਰਾਏਲ ਦੇ ਸੱਜੇ ਪਾਸੇ ਲਿਆਂਦਾ ਅਤੇ ਉਸ ਦੇ ਨੇੜੇ ਕੀਤਾ। ");
INSERT INTO pan_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","ਤਦ ਇਸਰਾਏਲ ਨੇ ਆਪਣਾ ਸੱਜਾ ਹੱਥ ਵਧਾ ਕੇ ਇਫ਼ਰਾਈਮ ਦੇ ਸਿਰ ਉੱਤੇ ਰੱਖਿਆ, ਜਿਹੜਾ ਛੋਟਾ ਪੁੱਤਰ ਸੀ ਅਤੇ ਆਪਣਾ ਖੱਬਾ ਹੱਥ ਮਨੱਸ਼ਹ ਦੇ ਸਿਰ ਉੱਤੇ ਰੱਖਿਆ। ਉਸ ਨੇ ਜਾਣ ਬੁੱਝ ਕੇ ਆਪਣੇ ਹੱਥ ਇਸ ਤਰ੍ਹਾਂ ਰੱਖੇ ਕਿਉਂ ਜੋ ਮਨੱਸ਼ਹ ਪਹਿਲੌਠਾ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","ਉਸ ਨੇ ਯੂਸੁਫ਼ ਨੂੰ ਬਰਕਤ ਦੇ ਕੇ ਆਖਿਆ, ਪਰਮੇਸ਼ੁਰ ਜਿਸ ਦੇ ਸਨਮੁਖ ਮੇਰਾ ਪਿਤਾ ਅਬਰਾਹਾਮ ਅਤੇ ਇਸਹਾਕ ਚੱਲਦੇ ਰਹੇ ਅਤੇ ਉਹ ਪਰਮੇਸ਼ੁਰ ਜਿਸ ਨੇ ਜੀਵਨ ਭਰ ਅੱਜ ਦੇ ਦਿਨ ਤੱਕ ਮੇਰੀ ਪਾਲਣਾ ਕੀਤੀ, ");
INSERT INTO pan_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","ਅਤੇ ਉਹੀ ਦੂਤ ਜਿਹੜਾ ਸਾਰੀ ਬੁਰਿਆਈ ਤੋਂ ਮੈਨੂੰ ਛੁਡਾਉਂਦਾ ਆਇਆ ਹੈ, ਉਹ ਹੀ ਇਨ੍ਹਾਂ ਮੁੰਡਿਆਂ ਨੂੰ ਬਰਕਤ ਦੇਵੇ ਅਤੇ ਉਨ੍ਹਾਂ ਨੂੰ ਮੇਰੇ ਨਾਮ ਅਤੇ ਮੇਰੇ ਪਿਤਾ ਅਬਰਾਹਾਮ ਅਤੇ ਇਸਹਾਕ ਦੇ ਨਾਮ ਤੋਂ ਬੁਲਾਇਆ ਜਾਵੇ ਅਤੇ ਇਹ ਧਰਤੀ ਉੱਤੇ ਇੱਕ ਵੱਡਾ ਦਲ ਬਣ ਜਾਣ। ");
INSERT INTO pan_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","ਜਦ ਯੂਸੁਫ਼ ਨੇ ਵੇਖਿਆ ਕਿ ਮੇਰੇ ਪਿਤਾ ਨੇ ਆਪਣਾ ਸੱਜਾ ਹੱਥ ਇਫ਼ਰਾਈਮ ਦੇ ਸਿਰ ਉੱਤੇ ਰੱਖਿਆ ਹੈ ਤਾਂ ਉਸ ਦੀ ਨਜ਼ਰ ਵਿੱਚ ਇਹ ਗੱਲ ਬੁਰੀ ਲੱਗੀ ਅਤੇ ਉਸ ਨੇ ਆਪਣੇ ਪਿਤਾ ਦਾ ਹੱਥ ਇਸ ਲਈ ਫੜ੍ਹ ਲਿਆ ਤਾਂ ਜੋ ਇਫ਼ਰਾਈਮ ਦੇ ਸਿਰ ਤੋਂ ਹਟਾ ਕੇ ਮਨੱਸ਼ਹ ਦੇ ਸਿਰ ਉੱਤੇ ਰੱਖੇ। ");
INSERT INTO pan_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","ਯੂਸੁਫ਼ ਨੇ ਆਪਣੇ ਪਿਤਾ ਨੂੰ ਆਖਿਆ, ਪਿਤਾ ਜੀ, ਅਜਿਹਾ ਨਾ ਹੋਵੇ, ਕਿਉਂ ਜੋ ਉਹ ਪਹਿਲੌਠਾ ਹੈ। ਆਪਣਾ ਸੱਜਾ ਹੱਥ ਉਸ ਦੇ ਸਿਰ ਉੱਤੇ ਰੱਖ। ");
INSERT INTO pan_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","ਪਰ ਉਸ ਦੇ ਪਿਤਾ ਨੇ ਇਨਕਾਰ ਕਰਕੇ ਆਖਿਆ, ਮੈਂ ਜਾਣਦਾ ਹਾਂ, ਮੇਰੇ ਪੁੱਤਰ ਮੈਂ ਜਾਣਦਾ ਹਾਂ। ਇਸ ਤੋਂ ਵੀ ਇੱਕ ਕੌਮ ਹੋਵੇਗੀ ਅਤੇ ਇਹ ਵੀ ਵੱਡਾ ਹੋਵੇਗਾ ਪਰ ਉਸ ਦਾ ਛੋਟਾ ਭਰਾ ਇਸ ਨਾਲੋਂ ਵੱਡਾ ਹੋਵੇਗਾ ਅਤੇ ਉਸ ਦੀ ਅੰਸ ਤੋਂ ਬਹੁਤ ਸਾਰੀਆਂ ਕੌਮਾਂ ਹੋਣਗੀਆਂ। ");
INSERT INTO pan_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","ਫਿਰ ਉਸ ਨੇ ਉਸੇ ਦਿਨ ਉਨ੍ਹਾਂ ਨੂੰ ਬਰਕਤ ਦੇ ਕੇ ਆਖਿਆ, ਇਸਰਾਏਲ ਤੇਰਾ ਨਾਮ ਲੈ ਕੇ ਅਤੇ ਇਹ ਆਖ ਕੇ ਬਰਕਤ ਦਿਆ ਕਰੇਗਾ ਕਿ ਪਰਮੇਸ਼ੁਰ ਤੈਨੂੰ ਇਫ਼ਰਾਈਮ ਅਤੇ ਮਨੱਸ਼ਹ ਵਰਗਾ ਬਣਾਵੇ। ਸੋ ਉਸ ਨੇ ਇਫ਼ਰਾਈਮ ਨੂੰ ਮਨੱਸ਼ਹ ਨਾਲੋਂ ਅੱਗੇ ਰੱਖਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","ਇਸਰਾਏਲ ਨੇ ਯੂਸੁਫ਼ ਨੂੰ ਆਖਿਆ, ਵੇਖ, ਮੈਂ ਮਰਨ ਵਾਲਾ ਹਾਂ ਪਰ ਪਰਮੇਸ਼ੁਰ ਤੁਹਾਡੇ ਸੰਗ ਹੋਵੇਗਾ ਅਤੇ ਤੁਹਾਨੂੰ ਤੁਹਾਡੇ ਪਿਓ ਦਾਦਿਆਂ ਦੇ ਦੇਸ਼ ਵਿੱਚ ਮੁੜ ਲੈ ਆਵੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","ਅਤੇ ਮੈਂ ਤੈਨੂੰ ਤੇਰੇ ਭਰਾਵਾਂ ਤੋਂ ਵੱਧ ਇੱਕ ਉਪਜਾਊ ਇਲਾਕਾ ਦਿੱਤਾ ਹੈ, ਜਿਹੜਾ ਮੈਂ ਯੁੱਧ ਵਿੱਚ ਆਪਣੀ ਤਲਵਾਰ ਅਤੇ ਧਣੁੱਖ ਨਾਲ ਅਮੋਰੀਆਂ ਦੇ ਹੱਥੋਂ ਲੈ ਲਿਆ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","ਯਾਕੂਬ ਨੇ ਆਪਣੇ ਪੁੱਤਰਾਂ ਨੂੰ ਸੱਦ ਕੇ ਆਖਿਆ, ਇਕੱਠੇ ਹੋ ਜਾਓ ਤਾਂ ਜੋ ਮੈਂ ਤੁਹਾਨੂੰ ਦੱਸਾਂ, ਜੋ ਤੁਹਾਡੇ ਉੱਤੇ ਆਉਣ ਵਾਲਿਆਂ ਦਿਨਾਂ ਵਿੱਚ ਬੀਤੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","ਯਾਕੂਬ ਦੇ ਪੁੱਤਰੋ ਇਕੱਠੇ ਹੋ ਜਾਓ, ਸੁਣੋ, ਅਤੇ ਆਪਣੇ ਪਿਤਾ ਇਸਰਾਏਲ ਦੀ ਸੁਣੋ। ");
INSERT INTO pan_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","ਰਊਬੇਨ ਤੂੰ ਮੇਰਾ ਪਹਿਲੌਠਾ ਪੁੱਤਰ ਹੈਂ, ਮੇਰਾ ਬਲ ਤੇ ਮੇਰੀ ਸ਼ਕਤੀ ਦਾ ਮੁੱਢ ਹੈਂ। ਤੂੰ ਇੱਜ਼ਤ ਵਿੱਚ ਉੱਤਮ ਤੇ ਜ਼ੋਰ ਵਿੱਚ ਵੀ ਉੱਤਮ ਹੈਂ। ");
INSERT INTO pan_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","ਤੂੰ ਪਾਣੀ ਵਾਂਗੂੰ ਉਬਲਣ ਵਾਲਾ ਹੈ, ਪਰ ਤੂੰ ਉੱਚੀ ਪਦਵੀ ਨਾ ਪਾਵੇਂਗਾ ਕਿਉਂ ਜੋ ਤੂੰ ਆਪਣੇ ਪਿਤਾ ਦੇ ਮੰਜੇ ਉੱਤੇ ਚੜ੍ਹ ਗਿਆ। ਤਦ ਤੂੰ ਉਹ ਨੂੰ ਭਰਿਸ਼ਟ ਕੀਤਾ। ਉਹ ਮੇਰੇ ਬਿਸਤਰੇ ਉੱਤੇ ਚੜ੍ਹ ਗਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","ਸ਼ਿਮਓਨ ਅਤੇ ਲੇਵੀ ਭਰਾ-ਭਰਾ ਹਨ, ਉਨ੍ਹਾਂ ਦੀਆਂ ਤਲਵਾਰਾਂ ਜ਼ੁਲਮ ਦੇ ਸ਼ਸਤਰ ਹਨ। ");
INSERT INTO pan_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","ਹੇ ਮੇਰੇ ਮਨ, ਉਨ੍ਹਾਂ ਦੀ ਸੰਗਤ ਵਿੱਚ ਨਾ ਜਾ। ਹੇ ਮੇਰੀ ਮਹਿਮਾ, ਉਨ੍ਹਾਂ ਦੀ ਸਭਾ ਵਿੱਚ ਨਾ ਰਲ, ਕਿਉਂ ਜੋ ਉਨ੍ਹਾਂ ਨੇ ਆਪਣੇ ਕ੍ਰੋਧ ਵਿੱਚ ਮਨੁੱਖਾਂ ਨੂੰ ਵੱਢ ਛੱਡਿਆ ਅਤੇ ਆਪਣੇ ਢੀਠਪੁਣੇ ਵਿੱਚ ਬਲ਼ਦਾਂ ਦੀਆਂ ਸੜਾਂ ਵੱਢ ਦਿੱਤੀਆਂ। ");
INSERT INTO pan_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","ਉਨ੍ਹਾਂ ਦਾ ਕ੍ਰੋਧ ਸਰਾਪਿਆ ਜਾਵੇ, ਕਿਉਂ ਜੋ ਉਹ ਭਿਅੰਕਰ ਸੀ; ਨਾਲੇ ਉਨ੍ਹਾਂ ਦਾ ਰੋਹ, ਕਿਉਂ ਜੋ ਉਹ ਕਠੋਰ ਸੀ। ਮੈਂ ਉਨ੍ਹਾਂ ਨੂੰ ਯਾਕੂਬ ਵਿੱਚ ਅਲੱਗ-ਅਲੱਗ ਕਰ ਛੱਡਾਂਗਾ ਅਤੇ ਉਨ੍ਹਾਂ ਨੂੰ ਇਸਰਾਏਲ ਵਿੱਚ ਖਿੰਡਾ ਦਿਆਂਗਾ। ");
INSERT INTO pan_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","ਹੇ ਯਹੂਦਾਹ ਤੇਰੇ ਭਰਾ ਤੇਰਾ ਧੰਨਵਾਦ ਕਰਨਗੇ, ਤੇਰਾ ਹੱਥ ਤੇਰੇ ਵੈਰੀਆਂ ਦੀ ਧੌਣ ਉੱਤੇ ਹੋਵੇਗਾ; ਤੇਰੇ ਪਿਤਾ ਦੇ ਪੁੱਤਰ ਤੇਰੇ ਅੱਗੇ ਨੀਵੇਂ ਹੋਣਗੇ। ");
INSERT INTO pan_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","ਯਹੂਦਾਹ ਸ਼ੇਰ ਦਾ ਬੱਚਾ ਹੈ। ਮੇਰੇ ਪੁੱਤਰ ਤੂੰ ਸ਼ਿਕਾਰ ਮਾਰ ਕੇ ਆਇਆ। ਉਹ ਸ਼ੇਰ ਦੀ ਤਰ੍ਹਾਂ ਸਗੋਂ ਸ਼ੇਰਨੀ ਦੀ ਤਰ੍ਹਾਂ ਦੱਬ ਕੇ ਬੈਠ ਗਿਆ। ਫਿਰ ਕੌਣ ਉਹ ਨੂੰ ਛੇੜੇਗਾ? ");
INSERT INTO pan_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","ਯਹੂਦਾਹ ਤੋਂ ਆੱਸਾ ਅਲੱਗ ਨਾ ਹੋਵੇਗਾ ਨਾ ਉਸ ਦੇ ਪੈਰਾਂ ਦੇ ਵਿੱਚੋਂ ਹਾਕਮ ਦਾ ਸੋਟਾ, ਜਦ ਤੱਕ ਸ਼ਾਂਤੀ ਦਾਤਾ ਨਾ ਆਵੇ ਅਤੇ ਲੋਕਾਂ ਦੀ ਆਗਿਆਕਾਰੀ ਉਸੇ ਵੱਲ ਹੋਵੇਗੀ। ");
INSERT INTO pan_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","ਉਹ ਆਪਣੇ ਗਧੇ ਨੂੰ ਦਾਖ਼ ਦੀ ਬੇਲ ਨਾਲ ਅਤੇ ਆਪਣੀ ਗਧੀ ਦੇ ਬੱਚੇ ਨੂੰ ਦਾਖ਼ ਦੇ ਉੱਤਮ ਬੂਟੇ ਨਾਲ ਬੰਨ੍ਹੇਗਾ। ਉਸ ਨੇ ਆਪਣੇ ਬਸਤਰ ਨੂੰ ਮਧ ਵਿੱਚ ਅਤੇ ਆਪਣਾ ਪਹਿਰਾਵਾ ਅੰਗੂਰਾਂ ਦੇ ਰਸ ਵਿੱਚ ਧੋਤਾ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","ਉਹ ਦੀਆਂ ਅੱਖਾਂ ਮਧ ਨਾਲ ਲਾਲ ਅਤੇ ਉਹ ਦੇ ਦੰਦ ਦੁੱਧ ਨਾਲੋਂ ਚਿੱਟੇ ਹਨ। ");
INSERT INTO pan_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","ਜ਼ਬੂਲੁਨ ਸਮੁੰਦਰਾਂ ਦੇ ਘਾਟ ਉੱਤੇ ਵੱਸੇਗਾ ਅਤੇ ਉਹ ਬੇੜਿਆਂ ਦੀ ਬੰਦਰਗਾਹ ਹੋਵੇਗਾ ਤੇ ਉਸ ਦੀ ਹੱਦ ਸੀਦੋਨ ਤੱਕ ਹੋਵੇਗੀ। ");
INSERT INTO pan_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","ਯਿੱਸਾਕਾਰ ਬਲਵੰਤ ਗਧਾ ਹੈ, ਜਿਹੜਾ ਵਾੜੇ ਦੇ ਪਸ਼ੂਆਂ ਵਿਚਕਾਰ ਸਹਿਮ ਕੇ ਬੈਠਦਾ ਹੈ, ");
INSERT INTO pan_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","ਅਤੇ ਉਸ ਨੇ ਇੱਕ ਅਰਾਮ ਦੀ ਥਾਂ ਵੇਖੀ ਕਿ ਉਹ ਚੰਗੀ ਹੈ ਅਤੇ ਉਹ ਦੇਸ਼ ਮਨ ਭਾਉਂਦਾ ਹੈ। ਤਦ ਉਸ ਨੇ ਆਪਣਾ ਮੋਢਾ ਭਾਰ ਚੁੱਕਣ ਨੂੰ ਨਿਵਾਇਆ ਅਤੇ ਉਹ ਇੱਕ ਬੇਗਾਰੀ ਕਰਨ ਵਾਲਾ ਬਣਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","ਦਾਨ ਇਸਰਾਏਲ ਦੇ ਗੋਤਾਂ ਵਿੱਚੋਂ ਇੱਕ ਹੋ ਕੇ, ਆਪਣੇ ਲੋਕਾਂ ਦਾ ਨਿਆਂ ਕਰੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","ਦਾਨ ਮਾਰਗ ਉੱਤੇ ਸੱਪ ਸਗੋਂ ਰਸਤੇ ਵਿੱਚ ਫਨੀਅਰ ਸੱਪ ਹੋਵੇਗਾ, ਜਿਹੜਾ ਘੋੜੇ ਨੂੰ ਡੰਗ ਮਾਰਦਾ ਹੈ ਜਿਸ ਕਾਰਨ ਉਸ ਦਾ ਸਵਾਰ ਪਿੱਛੇ ਡਿੱਗ ਪੈਂਦਾ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","ਹੇ ਯਹੋਵਾਹ, ਮੈਂ ਤੇਰੇ ਛੁਟਕਾਰੇ ਨੂੰ ਉਡੀਕਿਆ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","ਗਾਦ ਨੂੰ ਫ਼ੌਜਾਂ ਧੱਕਣਗੀਆਂ ਪਰ ਉਹ ਉਨ੍ਹਾਂ ਦੀ ਪਿੱਠ ਨੂੰ ਧੱਕੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","ਆਸ਼ੇਰ ਦੀ ਰੋਟੀ ਚਿਕਣੀ ਹੋਵੇਗੀ ਅਤੇ ਉਹ ਸੁਆਦਲੇ ਸ਼ਾਹੀ ਭੋਜਨ ਦੇਵੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","ਨਫ਼ਤਾਲੀ ਛੱਡੀ ਹੋਈ ਹਰਨੀ ਹੈ, ਉਹ ਸੁੰਦਰ ਗੱਲਾਂ ਬੋਲਦਾ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","ਯੂਸੁਫ਼ ਇੱਕ ਫਲਦਾਇਕ ਦਾਖ਼ਲਤਾ ਹੈ, ਸੋਤੇ ਕੋਲ ਲੱਗੀ ਇੱਕ ਫਲਦਾਇਕ ਦਾਖ਼ਲਤਾ, ਜਿਸ ਦੀਆਂ ਟਹਿਣੀਆਂ ਕੰਧ ਉੱਤੋਂ ਦੀ ਚੜ੍ਹ ਜਾਂਦੀਆਂ ਹਨ। ");
INSERT INTO pan_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","ਤੀਰ-ਅੰਦਾਜ਼ਾਂ ਨੇ ਉਹ ਨੂੰ ਸਤਾਇਆ ਅਤੇ ਤੀਰ ਚਲਾਏ ਤੇ ਉਹ ਦੇ ਨਾਲ ਵੈਰ ਰੱਖਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","ਪਰ ਉਹ ਦਾ ਧਣੁੱਖ ਤਕੜਾ ਰਿਹਾ ਅਤੇ ਯਾਕੂਬ ਦੇ ਸ਼ਕਤੀਮਾਨ ਪਰਮੇਸ਼ੁਰ ਦੇ ਹੱਥੋਂ ਉਸ ਦੀਆਂ ਬਾਹਾਂ ਤੇ ਹੱਥ ਬਲਵੰਤ ਹਨ (ਉੱਥੋਂ ਹੀ ਅਯਾਲੀ ਅਰਥਾਤ ਇਸਰਾਏਲ ਦਾ ਪੱਥਰ ਆਵੇਗਾ) ");
INSERT INTO pan_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","ਤੇਰੇ ਪਿਤਾ ਦੇ ਪਰਮੇਸ਼ੁਰ ਤੋਂ, ਜਿਹੜਾ ਤੇਰੀ ਸਹਾਇਤਾ ਕਰੇਗਾ ਅਤੇ ਸਰਬ ਸ਼ਕਤੀਮਾਨ ਤੋਂ, ਜਿਹੜਾ ਤੈਨੂੰ ਬਰਕਤਾਂ ਦੇਵੇਗਾ, ਉੱਪਰੋਂ ਅਕਾਸ਼ ਦੀਆਂ ਬਰਕਤਾਂ, ਹੇਠਾਂ ਪਈਆਂ ਹੋਈਆਂ ਡੁੰਘਿਆਈਆਂ ਦੀਆਂ ਬਰਕਤਾਂ, ਛਾਤੀਆਂ ਤੇ ਕੁੱਖ ਦੀਆਂ ਬਰਕਤਾਂ, ");
INSERT INTO pan_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","ਤੇਰੇ ਪਿਤਾ ਦੀਆਂ ਬਰਕਤਾਂ, ਮੇਰੇ ਪਿਓ ਦਾਦਿਆਂ ਦੀਆਂ ਬਰਕਤਾਂ ਤੋਂ, ਸਗੋਂ ਸਦੀਪਕ ਪਰਬਤਾਂ ਦੇ ਬੰਨ੍ਹਿਆਂ ਤੱਕ ਵੱਧ ਗਈਆਂ। ਉਹ ਯੂਸੁਫ਼ ਦੇ ਸਿਰ ਉੱਤੇ ਸਗੋਂ ਉਹ ਦੀ ਖੋਪੜੀ ਉੱਤੇ ਹੋਣਗੀਆਂ ਜਿਹੜਾ ਆਪਣੇ ਭਰਾਵਾਂ ਵਿੱਚੋਂ ਅਲੱਗ ਕੀਤਾ ਗਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","ਬਿਨਯਾਮੀਨ ਪਾੜਨ ਵਾਲਾ ਬਘਿਆੜ ਹੈ। ਸਵੇਰੇ ਉਹ ਸ਼ਿਕਾਰ ਖਾਵੇਗਾ ਅਤੇ ਸ਼ਾਮ ਨੂੰ ਲੁੱਟ ਵੰਡੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","ਇਹ ਸਭ ਇਸਰਾਏਲ ਦੇ ਬਾਰਾਂ ਗੋਤ ਹਨ, ਇਹ ਉਹ ਬਚਨ ਹਨ ਜੋ ਉਨ੍ਹਾਂ ਦਾ ਪਿਤਾ ਉਨ੍ਹਾਂ ਨੂੰ ਬੋਲਿਆ, ਜਦ ਉਨ੍ਹਾਂ ਵਿੱਚੋਂ ਹਰ ਇੱਕ ਨੂੰ ਬਰਕਤ ਦਿੱਤੀ ਹਰ ਇੱਕ ਨੂੰ ਉਸ ਦੀ ਬਰਕਤ ਅਨੁਸਾਰ ਉਸ ਨੇ ਉਨ੍ਹਾਂ ਨੂੰ ਬਰਕਤ ਦਿੱਤੀ। ");
INSERT INTO pan_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","ਫੇਰ ਉਸ ਨੇ ਉਨ੍ਹਾਂ ਨੂੰ ਆਗਿਆ ਦੇ ਕੇ ਆਖਿਆ, ਮੈਂ ਆਪਣੇ ਲੋਕਾਂ ਨੂੰ ਮਿਲਣ ਲਈ ਜਾਂਦਾ ਹਾਂ, ਮੈਨੂੰ ਮੇਰੇ ਪਿਓ ਦਾਦਿਆਂ ਨਾਲ ਉਸ ਗੁਫ਼ਾ ਵਿੱਚ ਜਿਹੜੀ ਅਫ਼ਰੋਨ ਹਿੱਤੀ ਦੀ ਪੈਲੀ ਵਿੱਚ ਹੈ, ਦੱਬਿਓ। ");
INSERT INTO pan_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","ਅਰਥਾਤ ਉਸ ਗੁਫ਼ਾ ਵਿੱਚ ਜਿਹੜੀ ਮਕਫ਼ੇਲਾਹ ਦੀ ਪੈਲੀ ਵਿੱਚ ਮਮਰੇ ਦੇ ਅੱਗੇ ਕਨਾਨ ਦੇਸ਼ ਵਿੱਚ ਹੈ, ਜਿਹੜੀ ਪੈਲੀ ਅਬਰਾਹਾਮ ਨੇ ਅਫ਼ਰੋਨ ਹਿੱਤੀ ਤੋਂ ਕਬਰਿਸਤਾਨ ਦੀ ਨਿੱਜ ਭੂਮੀ ਹੋਣ ਲਈ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","ਉੱਥੇ ਉਨ੍ਹਾਂ ਨੇ ਅਬਰਾਹਾਮ ਅਤੇ ਉਹ ਦੀ ਪਤਨੀ ਸਾਰਾਹ ਨੂੰ ਦੱਬਿਆ, ਉੱਥੇ ਉਨ੍ਹਾਂ ਨੇ ਇਸਹਾਕ ਅਤੇ ਉਹ ਦੀ ਪਤਨੀ ਰਿਬਕਾਹ ਨੂੰ ਦੱਬਿਆ ਅਤੇ ਉੱਥੇ ਮੈਂ ਲੇਆਹ ਨੂੰ ਦੱਬਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","ਮੈਂ ਉਸ ਪੈਲੀ ਅਤੇ ਉਸ ਗੁਫ਼ਾ ਨੂੰ ਜਿਹੜੀ ਉਸ ਦੇ ਵਿੱਚ ਹੈ, ਹੇਤ ਦੇ ਪੁੱਤਰਾਂ ਤੋਂ ਮੁੱਲ ਲਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","ਜਦ ਯਾਕੂਬ ਆਪਣੇ ਪੁੱਤਰਾਂ ਨੂੰ ਆਗਿਆ ਦੇ ਚੁੱਕਿਆ ਤਾਂ ਉਸ ਨੇ ਆਪਣੇ ਪੈਰ ਮੰਜੇ ਉੱਤੇ ਇਕੱਠੇ ਕਰ ਲਏ ਅਤੇ ਆਪਣੇ ਪ੍ਰਾਣ ਛੱਡ ਕੇ ਆਪਣੇ ਲੋਕਾਂ ਵਿੱਚ ਜਾ ਮਿਲਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","ਯੂਸੁਫ਼ ਆਪਣੇ ਪਿਤਾ ਦੇ ਮੂੰਹ ਉੱਤੇ ਡਿੱਗ ਕੇ ਰੋਇਆ ਅਤੇ ਉਸ ਨੂੰ ਚੁੰਮਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","ਫੇਰ ਯੂਸੁਫ਼ ਨੇ ਆਪਣੇ ਸੇਵਕਾਂ ਨੂੰ ਅਰਥਾਤ ਵੈਦਾਂ ਨੂੰ ਆਗਿਆ ਦਿੱਤੀ, ਕਿ ਉਹ ਉਸ ਦੇ ਪਿਤਾ ਵਿੱਚ ਸੁਗੰਧੀਆਂ ਭਰਨ ਇਸ ਲਈ ਉਨ੍ਹਾਂ ਵੈਦਾਂ ਨੇ ਇਸਰਾਏਲ ਵਿੱਚ ਸੁਗੰਧੀਆਂ ਭਰੀਆਂ। ");
INSERT INTO pan_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","ਅਤੇ ਜਦ ਉਸ ਦੇ ਚਾਲ੍ਹੀ ਦਿਨ ਪੂਰੇ ਹੋ ਗਏ, ਕਿਉਂ ਜੋ ਇਸੇ ਤਰ੍ਹਾਂ ਹੀ ਉਹ ਸੁਗੰਧੀਆਂ ਭਰਨ ਦੇ ਦਿਨ ਪੂਰੇ ਕਰਦੇ ਹੁੰਦੇ ਸਨ ਅਤੇ ਮਿਸਰੀ ਉਸ ਦੇ ਲਈ ਸੱਤਰ ਦਿਨ ਵਿਰਲਾਪ ਕਰਦੇ ਰਹੇ। ");
INSERT INTO pan_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","ਅਤੇ ਜਦ ਵਿਰਲਾਪ ਦੇ ਦਿਨ ਬੀਤ ਗਏ, ਤਦ ਯੂਸੁਫ਼ ਨੇ ਫ਼ਿਰਊਨ ਦੇ ਘਰਾਣੇ ਨੂੰ ਇਹ ਗੱਲ ਆਖੀ, ਕਿ ਜੇ ਮੇਰੇ ਉੱਤੇ ਤੁਹਾਡੀ ਕਿਰਪਾ ਦੀ ਨਿਗਾਹ ਹੈ ਤਾਂ ਮੇਰੀ ਇਹ ਗੱਲ ਫ਼ਿਰਊਨ ਨੂੰ ਬੋਲੋ, ");
INSERT INTO pan_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","ਮੇਰੇ ਪਿਤਾ ਨੇ ਮੈਥੋਂ ਇਹ ਸਹੁੰ ਲਈ ਸੀ ਕਿ ਵੇਖ ਮੈਂ ਮਰਨ ਵਾਲਾ ਹਾਂ, ਮੈਨੂੰ ਉਸ ਕਬਰ ਵਿੱਚ ਜਿਸ ਨੂੰ ਮੈਂ ਆਪਣੇ ਲਈ ਕਨਾਨ ਦੇਸ਼ ਵਿੱਚ ਪੁੱਟਿਆ ਸੀ ਦੱਬੀਂ, ਇਸ ਲਈ ਹੁਣ ਮੈਨੂੰ ਉੱਥੇ ਜਾ ਕੇ ਆਪਣੇ ਪਿਤਾ ਨੂੰ ਦਫ਼ਨਾਉਣ ਦੀ ਇਜਾਜ਼ਤ ਦੇਵੇ ਅਤੇ ਇਸ ਤੋਂ ਬਾਅਦ ਮੈਂ ਮੁੜ ਆਵਾਂਗਾ। ");
INSERT INTO pan_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","ਤਦ ਫ਼ਿਰਊਨ ਨੇ ਆਖਿਆ, ਜਾ ਅਤੇ ਆਪਣੇ ਪਿਤਾ ਦੀ ਸਹੁੰ ਦੇ ਅਨੁਸਾਰ ਉਸ ਨੂੰ ਦਫ਼ਨਾ ਦੇ। ");
INSERT INTO pan_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","ਇਸ ਲਈ ਯੂਸੁਫ਼ ਆਪਣੇ ਪਿਤਾ ਨੂੰ ਦਫ਼ਨਾਉਣ ਲਈ ਗਿਆ, ਅਤੇ ਉਸ ਦੇ ਨਾਲ ਫ਼ਿਰਊਨ ਦੇ ਸਾਰੇ ਸੇਵਕ, ਉਸ ਦੇ ਘਰਾਣੇ ਦੇ ਸਾਰੇ ਬਜ਼ੁਰਗ ਅਤੇ ਮਿਸਰ ਦੇਸ਼ ਦੇ ਸਾਰੇ ਬਜ਼ੁਰਗ ਗਏ। ");
INSERT INTO pan_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","ਅਤੇ ਯੂਸੁਫ਼ ਦਾ ਸਾਰਾ ਘਰਾਣਾ, ਉਸ ਦੇ ਭਰਾ ਅਤੇ ਉਸ ਦੇ ਪਿਤਾ ਦਾ ਘਰਾਣਾ ਵੀ ਗਏ, ਸਿਰਫ਼ ਉਨ੍ਹਾਂ ਦੇ ਬੱਚੇ, ਇੱਜੜ ਅਤੇ ਚੌਣੇ ਗੋਸ਼ਨ ਦੇਸ਼ ਵਿੱਚ ਰਹਿ ਗਏ। ");
INSERT INTO pan_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","ਉਸ ਦੇ ਨਾਲ ਰਥ ਵੀ ਅਤੇ ਸਵਾਰ ਵੀ ਗਏ ਇਸ ਤਰ੍ਹਾਂ ਵੱਡੀ ਭੀੜ ਹੋ ਗਈ। ");
INSERT INTO pan_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","ਫਿਰ ਉਹ ਆਤਾਦ ਦੇ ਪਿੜ ਤੱਕ ਆਏ ਜਿਹੜਾ ਯਰਦਨ ਪਾਰ ਹੈ, ਉੱਥੇ ਉਨ੍ਹਾਂ ਨੇ ਬਹੁਤ ਜਿਆਦਾ ਅਤੇ ਡਾਢਾ ਵਿਰਲਾਪ ਕੀਤਾ ਅਤੇ ਬਹੁਤ ਰੋਏ, ਉਸ ਨੇ ਆਪਣੇ ਪਿਤਾ ਲਈ ਸੱਤ ਦਿਨ ਤੱਕ ਅਫ਼ਸੋਸ ਕੀਤਾ। ");
INSERT INTO pan_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","ਉਸ ਦੇਸ਼ ਦੇ ਰਹਿਣ ਵਾਲੇ ਕਨਾਨੀਆਂ ਨੇ ਉਸ ਸੋਗ ਨੂੰ ਆਤਾਦ ਦੇ ਪਿੜ ਵਿੱਚ ਵੇਖਿਆ ਤਾਂ ਉਨ੍ਹਾਂ ਨੇ ਆਖਿਆ, ਮਿਸਰੀਆਂ ਦਾ ਇਹ ਭਾਰੀ ਸੋਗ ਹੈ ਇਸ ਕਾਰਨ ਉਸ ਦਾ ਨਾਮ ਆਬੇਲ ਮਿਸਰਾਈਮ ਰੱਖਿਆ ਗਿਆ, ਜਿਹੜਾ ਯਰਦਨ ਪਾਰ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","ਉਸ ਦੇ ਪੁੱਤਰਾਂ ਨੇ ਉਸੇ ਤਰ੍ਹਾਂ ਹੀ ਕੀਤਾ ਜਿਵੇਂ ਉਸ ਨੇ ਉਨ੍ਹਾਂ ਨੂੰ ਆਗਿਆ ਦਿੱਤੀ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","ਉਸ ਦੇ ਪੁੱਤਰ ਉਹ ਨੂੰ ਕਨਾਨ ਦੇਸ਼ ਵਿੱਚ ਲੈ ਗਏ ਅਤੇ ਉਹ ਨੂੰ ਮਕਫ਼ੇਲਾਹ ਦੀ ਪੈਲੀ ਦੀ ਗੁਫ਼ਾ ਵਿੱਚ ਦਫ਼ਨਾਇਆ, ਜਿਸ ਪੈਲੀ ਨੂੰ ਅਬਰਾਹਾਮ ਨੇ ਅਫ਼ਰੋਨ ਹਿੱਤੀ ਤੋਂ ਕਬਰ ਦੀ ਵਿਰਾਸਤ ਲਈ ਮਮਰੇ ਦੇ ਅੱਗੇ ਮੁੱਲ ਲਿਆ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","ਉਪਰੰਤ ਯੂਸੁਫ਼ ਆਪ ਅਤੇ ਉਸ ਦੇ ਭਰਾ ਅਤੇ ਸਭ ਜਿਹੜੇ ਉਸ ਦੇ ਨਾਲ ਉਸ ਦੇ ਪਿਤਾ ਨੂੰ ਦੱਬਣ ਲਈ ਗਏ ਸਨ ਉਸ ਦੇ ਪਿਤਾ ਨੂੰ ਦੱਬਣ ਦੇ ਮਗਰੋਂ ਮਿਸਰ ਨੂੰ ਮੁੜ ਆਏ। ");
INSERT INTO pan_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","ਜਦ ਯੂਸੁਫ਼ ਦੇ ਭਰਾਵਾਂ ਨੇ ਵੇਖਿਆ ਕਿ ਸਾਡਾ ਪਿਤਾ ਮਰ ਗਿਆ ਹੈ ਤਾਂ ਉਨ੍ਹਾਂ ਨੇ ਆਖਿਆ ਕਿ ਸ਼ਾਇਦ ਯੂਸੁਫ਼ ਸਾਡੇ ਨਾਲ ਵੈਰ ਕਰੇਗਾ ਅਤੇ ਉਹ ਸਾਥੋਂ ਸਾਡੀ ਬੁਰਿਆਈ ਦਾ ਬਦਲਾ ਜ਼ਰੂਰ ਲਵੇਗਾ, ਜਿਹੜੀ ਅਸੀਂ ਉਹ ਦੇ ਨਾਲ ਕੀਤੀ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","ਉਨ੍ਹਾਂ ਨੇ ਯੂਸੁਫ਼ ਨੂੰ ਇਹ ਸੁਨੇਹਾ ਭੇਜਿਆ, ਕਿ ਤੁਹਾਡੇ ਪਿਤਾ ਨੇ ਆਪਣੀ ਮੌਤ ਤੋਂ ਪਹਿਲਾਂ ਇਹ ਆਗਿਆ ਦਿੱਤੀ ਸੀ, ");
INSERT INTO pan_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","ਯੂਸੁਫ਼ ਨੂੰ ਇਹ ਆਖਣਾ ਕਿ ਕਿਰਪਾ ਕਰ ਕੇ ਆਪਣੇ ਭਰਾਵਾਂ ਦੇ ਅਪਰਾਧ ਅਤੇ ਉਨ੍ਹਾਂ ਦੇ ਪਾਪ ਮਾਫ਼ ਕਰ ਦੇ ਕਿਉਂ ਜੋ ਉਨ੍ਹਾਂ ਨੇ ਤੁਹਾਡੇ ਨਾਲ ਬੁਰਿਆਈ ਕੀਤੀ, ਇਸ ਲਈ ਹੁਣ ਤੁਸੀਂ ਆਪਣੇ ਪਿਤਾ ਦੇ ਪਰਮੇਸ਼ੁਰ ਦੇ ਦਾਸਾਂ ਦੇ ਅਪਰਾਧ ਮਾਫ਼ ਕਰ ਦਿਓ ਤਾਂ ਯੂਸੁਫ਼ ਉਨ੍ਹਾਂ ਦੀਆਂ ਗੱਲਾਂ ਉੱਤੇ ਰੋ ਪਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","ਤਦ ਉਸ ਦੇ ਭਰਾ ਵੀ ਉਸ ਦੇ ਅੱਗੇ ਜਾ ਕੇ ਡਿੱਗ ਪਏ ਅਤੇ ਉਨ੍ਹਾਂ ਆਖਿਆ, ਵੇਖੋ ਅਸੀਂ ਤੁਹਾਡੇ ਦਾਸ ਹਾਂ। ");
INSERT INTO pan_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","ਪਰ ਯੂਸੁਫ਼ ਨੇ ਉਨ੍ਹਾਂ ਨੂੰ ਆਖਿਆ, ਨਾ ਡਰੋ। ਭਲਾ, ਮੈਂ ਪਰਮੇਸ਼ੁਰ ਦੇ ਥਾਂ ਹਾਂ? ");
INSERT INTO pan_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","ਤੁਸੀਂ ਤਾਂ ਮੇਰੇ ਵਿਰੁੱਧ ਬੁਰਿਆਈ ਦਾ ਮਨ ਬਣਾਇਆ; ਪਰ ਪਰਮੇਸ਼ੁਰ ਨੇ ਉਸ ਨੂੰ ਭਲਿਆਈ ਦਾ ਵਿਚਾਰ ਬਣਾਇਆ ਤਾਂ ਜੋ ਬਹੁਤ ਸਾਰੇ ਲੋਕਾਂ ਨੂੰ ਜੀਉਂਦਾ ਰੱਖੇ, ਜਿਵੇਂ ਇਸ ਵੇਲੇ ਹੋਇਆ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","ਹੁਣ ਤੁਸੀਂ ਨਾ ਡਰੋ। ਮੈਂ ਤੁਹਾਡੀ ਅਤੇ ਤੁਹਾਡੇ ਬਾਲ ਬੱਚਿਆਂ ਦੀ ਪਾਲਣਾ ਕਰਾਂਗਾ। ਸੋ ਉਸ ਨੇ ਉਨ੍ਹਾਂ ਨੂੰ ਤਸੱਲੀ ਦਿੱਤੀ ਅਤੇ ਉਨ੍ਹਾਂ ਨੇ ਦਿਲਾਸਾ ਪਾਇਆ। ");
INSERT INTO pan_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","ਯੂਸੁਫ਼ ਆਪ ਅਤੇ ਉਸ ਦੇ ਪਿਤਾ ਦਾ ਘਰਾਣਾ ਮਿਸਰ ਦੇਸ਼ ਵਿੱਚ ਵੱਸਿਆ ਅਤੇ ਯੂਸੁਫ਼ ਇੱਕ ਸੌ ਦਸ ਸਾਲਾਂ ਤੱਕ ਜੀਉਂਦਾ ਰਿਹਾ। ");
INSERT INTO pan_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","ਯੂਸੁਫ਼ ਨੇ ਇਫ਼ਰਾਈਮ ਦੇ ਪੁੱਤਰਾਂ ਨੂੰ ਤੀਜੀ ਪੀੜ੍ਹੀ ਤੱਕ ਵੇਖਿਆ ਅਤੇ ਮਨੱਸ਼ਹ ਦੇ ਪੁੱਤਰ ਮਾਕੀਰ ਦੇ ਬੱਚਿਆਂ ਨੂੰ ਵੀ, ਯੂਸੁਫ਼ ਨੇ ਉਹਨਾਂ ਨੂੰ ਗੋਦ ਵਿੱਚ ਲਿਆ। ");
INSERT INTO pan_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","ਯੂਸੁਫ਼ ਨੇ ਆਪਣੇ ਭਰਾਵਾਂ ਨੂੰ ਆਖਿਆ, ਮੈਂ ਮਰਨ ਵਾਲਾ ਹਾਂ ਪਰ ਪਰਮੇਸ਼ੁਰ ਜ਼ਰੂਰ ਤੁਹਾਡਾ ਧਿਆਨ ਰੱਖੇਗਾ ਅਤੇ ਉਹ ਤੁਹਾਨੂੰ ਉਸ ਦੇਸ਼ ਵਿੱਚ ਲੈ ਜਾਵੇਗਾ, ਜਿਸ ਦੀ ਸਹੁੰ ਉਸ ਨੇ ਅਬਰਾਹਾਮ ਅਤੇ ਇਸਹਾਕ ਅਤੇ ਯਾਕੂਬ ਨਾਲ ਖਾਧੀ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","ਤਦ ਯੂਸੁਫ਼ ਨੇ ਇਸਰਾਏਲ ਦੇ ਪੁੱਤਰਾਂ ਤੋਂ ਇਹ ਸਹੁੰ ਲਈ ਕਿ ਪਰਮੇਸ਼ੁਰ ਜ਼ਰੂਰ ਤੁਹਾਡਾ ਧਿਆਨ ਰੱਖੇਗਾ ਅਤੇ ਤੁਸੀਂ ਮੇਰੀਆਂ ਹੱਡੀਆਂ ਉਸ ਦੇਸ਼ ਵਿੱਚ ਲੈ ਜਾਣਾ। ");
INSERT INTO pan_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","ਯੂਸੁਫ਼ ਇੱਕ ਸੌ ਦਸ ਸਾਲਾਂ ਦਾ ਹੋ ਕੇ ਮਰ ਗਿਆ ਅਤੇ ਉਨ੍ਹਾਂ ਨੇ ਉਸ ਵਿੱਚ ਸੁਗੰਧੀਆਂ ਭਰੀਆਂ ਅਤੇ ਉਹ ਮਿਸਰ ਵਿੱਚ ਇੱਕ ਤਾਬੂਤ ਵਿੱਚ ਰੱਖਿਆ ਗਿਆ।");
INSERT INTO pan_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","ਹੁਣ ਇਸਰਾਏਲ ਦੇ ਪੁੱਤਰਾਂ ਦੇ ਨਾਮ, ਜਿਹੜੇ ਮਿਸਰ ਵਿੱਚ ਇੱਕ-ਇੱਕ ਜਣਾ ਆਪੋ ਆਪਣੇ ਟੱਬਰ ਨਾਲ ਯਾਕੂਬ ਦੇ ਨਾਲ ਆਏ ਸੋ ਇਹ ਹਨ; ");
INSERT INTO pan_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","ਰਊਬੇਨ ਸ਼ਿਮਓਨ ਲੇਵੀ ਯਹੂਦਾਹ ");
INSERT INTO pan_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","ਯਿੱਸਾਕਾਰ ਜ਼ਬੂਲੁਨ ਬਿਨਯਾਮੀਨ ");
INSERT INTO pan_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","ਦਾਨ ਨਫ਼ਤਾਲੀ ਗਾਦ ਅਤੇ ਆਸ਼ੇਰ। ");
INSERT INTO pan_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","ਇਸ ਤਰ੍ਹਾਂ ਇਹ ਸਾਰੇ ਪ੍ਰਾਣੀ ਜਿਹੜੇ ਯਾਕੂਬ ਦੀ ਅੰਸ ਤੋਂ ਨਿੱਕਲੇ ਸੱਤਰ ਪ੍ਰਾਣੀ ਸਨ ਅਤੇ ਯੂਸੁਫ਼ ਮਿਸਰ ਵਿੱਚ ਹੀ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","ਯੂਸੁਫ਼, ਉਸ ਦੇ ਭਰਾ ਅਤੇ ਉਹ ਸਾਰੀ ਪੀੜ੍ਹੀ ਮਰ ਚੁੱਕੀ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","ਪਰ ਇਸਰਾਏਲੀ ਫਲੇ ਅਤੇ ਉਨ੍ਹਾਂ ਦੇ ਦਲਾਂ ਦੇ ਦਲ ਹੋ ਗਏ, ਵਧ ਕੇ ਬਹੁਤ ਬਲਵੰਤ ਹੋ ਗਏ ਕਿ ਧਰਤੀ ਉਨ੍ਹਾਂ ਨਾਲ ਭਰ ਗਈ। ");
INSERT INTO pan_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","ਤਦ ਮਿਸਰ ਵਿੱਚ ਨਵਾਂ ਰਾਜਾ ਉੱਠਿਆ ਜਿਹੜਾ ਯੂਸੁਫ਼ ਨੂੰ ਨਹੀਂ ਜਾਣਦਾ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","ਉਸ ਨੇ ਆਪਣੇ ਲੋਕਾਂ ਨੂੰ ਆਖਿਆ, ਵੇਖੋ ਇਸਰਾਏਲੀ ਲੋਕ ਸਾਡੇ ਨਾਲੋਂ ਵਧੀਕ ਅਤੇ ਬਲਵੰਤ ਹਨ। ");
INSERT INTO pan_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","ਆਓ ਅਸੀਂ ਉਨ੍ਹਾਂ ਨਾਲ ਸਮਝ ਨਾਲ ਵਰਤਾਓ ਕਰੀਏ, ਅਜਿਹਾ ਨਾ ਹੋਵੇ ਕਿ ਉਹ ਹੋਰ ਵਧ ਜਾਣ ਅਤੇ ਇਸ ਤਰ੍ਹਾਂ ਹੋਵੇ ਕਿ ਜਦ ਲੜਾਈ ਆ ਪਵੇ ਤਾਂ ਉਹ ਸਾਡੇ ਵੈਰੀਆਂ ਦੇ ਨਾਲ ਮਿਲ ਜਾਣ ਅਤੇ ਸਾਡੇ ਵਿਰੁੱਧ ਲੜਨ, ਫੇਰ ਇਸ ਦੇਸ਼ ਤੋਂ ਉਤਾਹਾਂ ਨੂੰ ਚਲੇ ਜਾਣ। ");
INSERT INTO pan_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","ਤਦ ਉਸ ਉਨ੍ਹਾਂ ਦੇ ਉੱਪਰ ਬੇਗ਼ਾਰੀਆਂ ਦੇ ਕੋਰੜੇ ਠਹਿਰਾਏ ਜਿਹੜੇ ਉਨ੍ਹਾਂ ਨੂੰ ਉਨ੍ਹਾਂ ਦੇ ਭਾਰਾਂ ਨਾਲ ਜਿੱਚ ਕਰਨ ਅਤੇ ਉਨ੍ਹਾਂ ਫ਼ਿਰਊਨ ਲਈ ਫਿਤੋਮ ਅਤੇ ਰਾਮਸੇਸ ਭੰਡਾਰ ਦੇ ਨਗਰ ਬਣਾਏ। ");
INSERT INTO pan_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","ਪਰ ਜਿੰਨਾਂ ਉਹ ਉਨ੍ਹਾਂ ਨੂੰ ਦੁੱਖ ਦਿੰਦੇ ਸਨ ਉਹ ਉੱਨਾ ਹੀ ਵਧਦੇ ਅਤੇ ਫੈਲਦੇ ਜਾਂਦੇ ਸਨ, ਇਸ ਤਰ੍ਹਾਂ ਉਹ ਇਸਰਾਏਲੀਆਂ ਤੋਂ ਅੱਕ ਗਏ। ");
INSERT INTO pan_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","ਉਪਰੰਤ ਮਿਸਰੀ ਇਸਰਾਏਲੀਆਂ ਤੋਂ ਸਖ਼ਤੀ ਨਾਲ ਟਹਿਲ ਕਰਾਉਣ ਲੱਗੇ। ");
INSERT INTO pan_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","ਅਤੇ ਉਨ੍ਹਾਂ ਨੇ ਔਖੀ ਟਹਿਲ ਨਾਲ ਅਰਥਾਤ ਗਾਰੇ, ਇੱਟਾਂ ਅਤੇ ਖੇਤਾਂ ਵਿੱਚ ਹਰ ਪਰਕਾਰ ਦੀ ਟਹਿਲ ਨਾਲ ਉਨ੍ਹਾਂ ਦਾ ਜੀਉਣ ਖੱਟਾ ਕਰ ਦਿੱਤਾ। ਜਿਹੜੀ ਟਹਿਲ ਉਨ੍ਹਾਂ ਤੋਂ ਕਰਾਉਂਦੇ ਸਨ ਉਹ ਸਖ਼ਤੀ ਨਾਲ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","ਤਦ ਮਿਸਰ ਦੇ ਰਾਜੇ ਨੇ ਇਬਰਾਨੀ ਦਾਈਆਂ ਨੂੰ ਜਿਨ੍ਹਾਂ ਵਿੱਚੋਂ ਇੱਕ ਦਾ ਨਾਮ ਸਿਫਰਾਹ ਅਤੇ ਦੂਜੀ ਦਾ ਨਾਮ ਫੂਆਹ ਸੀ ਆਖਿਆ ");
INSERT INTO pan_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","ਜਦ ਇਬਰਾਨਣਾਂ ਲਈ ਤੁਸੀਂ ਦਾਈ ਪੁਣਾ ਕਰਦੀਆਂ ਹੋ ਅਤੇ ਤੁਸੀਂ ਉਨ੍ਹਾਂ ਨੂੰ ਜਣਾਉਣ ਦੇ ਪੀੜ੍ਹੇ ਉੱਤੇ ਵੇਖਦੀਆਂ ਹੋ ਤਾਂ ਜੇਕਰ ਉਹ ਪੁੱਤਰ ਹੋਵੇ ਉਸ ਨੂੰ ਮਾਰ ਸੁੱਟੋ ਪਰ ਜੇਕਰ ਧੀ ਹੋਵੇ ਤਾਂ ਉਹ ਜਿਉਂਦੀ ਰਹੇ। ");
INSERT INTO pan_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","ਪਰ ਦਾਈਆਂ ਪਰਮੇਸ਼ੁਰ ਤੋਂ ਡਰਦੀਆਂ ਸਨ ਅਤੇ ਜਿਵੇਂ ਮਿਸਰ ਦੇ ਰਾਜੇ ਨੇ ਹੁਕਮ ਦਿੱਤਾ ਸੀ ਉਨ੍ਹਾਂ ਤਿਵੇਂ ਨਾ ਕੀਤਾ, ਉਹ ਮੁੰਡਿਆਂ ਨੂੰ ਜਿਉਂਦੇ ਰੱਖਦੀਆਂ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","ਤਦ ਮਿਸਰ ਦੇ ਰਾਜੇ ਨੇ ਦਾਈਆਂ ਨੂੰ ਸੱਦ ਕੇ ਆਖਿਆ, ਤੁਸੀਂ ਇਹ ਗੱਲ ਕਿਉਂ ਕੀਤੀ ਕਿ ਮੁੰਡਿਆਂ ਨੂੰ ਜਿਉਂਦੇ ਰਹਿਣ ਦਿੱਤਾ? ");
INSERT INTO pan_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","ਫਿਰ ਦਾਈਆਂ ਨੇ ਫ਼ਿਰਊਨ ਨੂੰ ਆਖਿਆ ਕਿ ਇਬਰਾਨੀ ਔਰਤਾਂ ਮਿਸਰੀ ਔਰਤਾਂ ਵਾਂਗੂੰ ਨਹੀਂ ਹਨ ਕਿਉਂ ਜੋ ਉਹ ਜਿੰਦ ਵਾਲੀਆਂ ਹਨ ਅਤੇ ਦਾਈਆਂ ਦੇ ਆਉਣ ਤੋਂ ਪਹਿਲਾਂ ਹੀ ਜਣ ਲੈਂਦੀਆਂ ਹਨ। ");
INSERT INTO pan_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","ਇਸ ਲਈ ਪਰਮੇਸ਼ੁਰ ਨੇ ਦਾਈਆਂ ਨਾਲ ਭਲਿਆਈ ਕੀਤੀ ਅਤੇ ਉਹ ਲੋਕ ਵਧ ਗਏ ਅਤੇ ਬਹੁਤ ਬਲਵੰਤ ਹੋ ਗਏ। ");
INSERT INTO pan_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","ਇਸ ਤਰ੍ਹਾਂ ਹੋਇਆ ਇਸ ਲਈ ਕਿ ਦਾਈਆਂ ਪਰਮੇਸ਼ੁਰ ਤੋਂ ਡਰੀਆਂ ਉਸ ਉਨ੍ਹਾਂ ਦੇ ਘਰ ਵਸਾਏ। ");
INSERT INTO pan_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","ਉਪਰੰਤ ਫ਼ਿਰਊਨ ਨੇ ਆਪਣੀ ਸਾਰੀ ਪਰਜਾ ਨੂੰ ਹੁਕਮ ਦਿੱਤਾ ਕਿ ਹਰ ਇੱਕ ਪੁੱਤਰ ਨੂੰ ਜਿਹੜਾ ਇਬਰੀਆਂ ਦੇ ਜੰਮਣ ਨੀਲ ਨਦੀ ਵਿੱਚ ਸੁੱਟ ਦਿਓ ਪਰ ਹਰ ਇੱਕ ਧੀ ਨੂੰ ਜਿਉਂਦੀ ਰੱਖ ਲਓ। ");
INSERT INTO pan_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","ਲੇਵੀ ਦੇ ਘਰਾਣੇ ਦੇ ਇੱਕ ਮਨੁੱਖ ਨੇ ਲੇਵੀ ਦੀ ਧੀ ਨਾਲ ਵਿਆਹ ਕਰ ਲਿਆ ");
INSERT INTO pan_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","ਉਹ ਔਰਤ ਗਰਭਵਤੀ ਹੋਈ ਅਤੇ ਉਸ ਨੇ ਇੱਕ ਪੁੱਤਰ ਨੂੰ ਜਨਮ ਦਿੱਤਾ। ਉਸ ਨੇ ਉਸ ਨੂੰ ਤਿੰਨ ਮਹੀਨੇ ਤੱਕ ਲੁਕਾ ਕੇ ਰੱਖਿਆ ਕਿਉਂਕਿ ਉਹ ਵੇਖਣ ਵਿੱਚ ਬਹੁਤ ਸੋਹਣਾ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","ਜਦ ਉਹ ਉਸ ਨੂੰ ਹੋਰ ਲੁਕਾ ਨਾ ਸਕੀ ਤਦ ਉਸ ਨੇ ਕਾਨਿਆਂ ਦੀ ਇੱਕ ਟੋਕਰੀ ਬਣਾ ਕੇ ਉਸ ਨੂੰ ਰਾਲ ਮਿੱਟੀ ਨਾਲ ਲਿੱਪਿਆ ਅਤੇ ਉਸ ਵਿੱਚ ਬੱਚੇ ਨੂੰ ਰੱਖ ਦਿੱਤਾ ਅਤੇ ਨੀਲ ਨਦੀ ਦੇ ਕੰਢੇ ਪਿਲਛੀ ਵਿੱਚ ਰੱਖ ਦਿੱਤਾ। ");
INSERT INTO pan_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","ਉਸ ਦੀ ਭੈਣ ਦੂਰ ਖੜ੍ਹੀ ਇਹ ਦੇਖ ਰਹੀ ਸੀ ਕਿ ਉਸ ਨਾਲ ਕੀ ਬੀਤ ਰਹੀ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","ਫ਼ਿਰਊਨ ਦੀ ਧੀ ਨਹਾਉਣ ਲਈ ਨੀਲ ਨਦੀ ਵਿੱਚ ਉੱਤਰੀ, ਜਦ ਉਸ ਦੀਆਂ ਸਹੇਲੀਆਂ ਦਰਿਆ ਦੇ ਕੰਢੇ-ਕੰਢੇ ਫਿਰਦੀਆਂ ਸਨ ਤਦ ਉਸ ਨੇ ਝਾੜੀਆਂ ਵਿੱਚ ਟੋਕਰੀ ਵੇਖੀ। ਉਸ ਨੇ ਆਪਣੀ ਦਾਸੀ ਨੂੰ ਉਹ ਟੋਕਰੀ ਲਿਆਉਣ ਲਈ ਭੇਜਿਆ। ");
INSERT INTO pan_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","ਜਦ ਉਸ ਨੇ ਉਸ ਨੂੰ ਖੋਲ੍ਹਿਆ ਤਦ ਉਸ ਨੇ ਬੱਚੇ ਨੂੰ ਵੇਖਿਆ ਅਤੇ ਉਹ ਮੁੰਡਾ ਰੋ ਰਿਹਾ ਸੀ। ਉਸ ਨੂੰ ਉਸ ਬੱਚੇ ਉੱਤੇ ਤਰਸ ਆਇਆ, ਉਸ ਨੇ ਆਖਿਆ ਕਿ ਇਹ ਇਬਰਾਨੀਆਂ ਦੇ ਬੱਚਿਆਂ ਵਿੱਚੋਂ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","ਤਦ ਉਸ ਦੀ ਭੈਣ ਨੇ ਫ਼ਿਰਊਨ ਦੀ ਧੀ ਨੂੰ ਆਖਿਆ, “ਮੈਂ ਜਾ ਕੇ ਇਬਰਾਨਣਾਂ ਵਿੱਚੋਂ ਕਿਸੇ ਦੁੱਧ ਚੁੰਘਾਉਣ ਵਾਲੀ ਔਰਤ ਨੂੰ ਤੁਹਾਡੇ ਕੋਲ ਲਿਆਵਾਂ ਤਾਂ ਜੋ ਉਹ ਤੁਹਾਡੇ ਲਈ ਇਸ ਬੱਚੇ ਨੂੰ ਦੁੱਧ ਚੁੰਘਾਇਆ ਕਰੇ?” ");
INSERT INTO pan_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","ਤਦ ਫ਼ਿਰਊਨ ਦੀ ਧੀ ਨੇ ਆਖਿਆ, “ਜਾ।” ਉਹ ਲੜਕੀ ਜਾ ਕੇ ਬੱਚੇ ਦੀ ਮਾਂ ਨੂੰ ਸੱਦ ਲਿਆਈ। ");
INSERT INTO pan_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","ਤਦ ਫ਼ਿਰਊਨ ਦੀ ਧੀ ਨੇ ਉਸ ਨੂੰ ਆਖਿਆ, ਇਸ ਬੱਚੇ ਨੂੰ ਲੈ ਅਤੇ ਮੇਰੇ ਲਈ ਦੁੱਧ ਪਿਲਾ, ਮੈਂ ਤੈਨੂੰ ਮਜ਼ਦੂਰੀ ਦੇਵਾਂਗੀ। ਤਦ ਉਸ ਔਰਤ ਨੇ ਬੱਚੇ ਨੂੰ ਲੈ ਕੇ ਦੁੱਧ ਪਿਲਾਇਆ। ");
INSERT INTO pan_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","ਜਦ ਬੱਚਾ ਵੱਡਾ ਹੋ ਗਿਆ ਤਦ ਉਹ ਉਸ ਨੂੰ ਫ਼ਿਰਊਨ ਦੀ ਧੀ ਕੋਲ ਲੈ ਆਈ। ਉਹ ਉਸ ਦਾ ਪੁੱਤਰ ਅਖਵਾਇਆ ਅਤੇ ਉਸ ਨੇ ਇਹ ਕਹਿ ਕੇ ਉਸ ਦਾ ਨਾਮ ਮੂਸਾ ਰੱਖਿਆ ਕਿ ਮੈਂ ਇਸ ਨੂੰ ਪਾਣੀ ਵਿੱਚੋਂ ਕੱਢਿਆ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","ਫਿਰ ਅਜਿਹਾ ਹੋਇਆ ਕਿ ਉਨ੍ਹਾਂ ਦਿਨਾਂ ਵਿੱਚ ਜਦ ਮੂਸਾ ਵੱਡਾ ਹੋਇਆ ਤਦ ਉਸ ਨੇ ਆਪਣੇ ਭਰਾਵਾਂ ਕੋਲ ਬਾਹਰ ਜਾ ਕੇ ਉਨ੍ਹਾਂ ਦੇ ਦੁੱਖਾਂ ਨੂੰ ਵੇਖਿਆ ਅਤੇ ਇੱਕ ਮਿਸਰੀ ਨੂੰ ਵੇਖਿਆ ਜੋ ਉਸ ਦੇ ਭਰਾਵਾਂ ਵਿੱਚੋਂ ਇੱਕ ਇਬਰਾਨੀ ਨੂੰ ਮਾਰ ਰਿਹਾ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","ਉਸ ਨੇ ਇੱਧਰ-ਉੱਧਰ ਵੇਖਿਆ ਅਤੇ ਜਦ ਵੇਖਿਆ ਕਿ ਕੋਈ ਨਹੀਂ ਹੈ ਤਦ ਉਸ ਨੇ ਉਸ ਮਿਸਰੀ ਨੂੰ ਮਾਰ ਦਿੱਤਾ ਅਤੇ ਉਸ ਨੂੰ ਰੇਤ ਵਿੱਚ ਲੁਕਾ ਦਿੱਤਾ। ");
INSERT INTO pan_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","ਜਦ ਮੂਸਾ ਦੂਜੇ ਦਿਨ ਬਾਹਰ ਗਿਆ ਤਾਂ ਵੇਖੋ, ਦੋ ਇਬਰਾਨੀ ਆਪਸ ਵਿੱਚ ਲੜ ਰਹੇ ਸਨ, ਉਸ ਨੇ ਦੋਸ਼ੀ ਨੂੰ ਆਖਿਆ, ਤੂੰ ਆਪਣੇ ਸਾਥੀ ਨੂੰ ਕਿਉਂ ਮਾਰਦਾ ਹੈਂ? ");
INSERT INTO pan_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","ਤਦ ਉਸ ਨੇ ਆਖਿਆ, ਤੈਨੂੰ ਕਿਸ ਨੇ ਸਾਡੇ ਉੱਤੇ ਸਰਦਾਰ ਅਤੇ ਨਿਆਈਂ ਬਣਾ ਦਿੱਤਾ? ਕੀ ਤੂੰ ਇਹ ਸੋਚਦਾ ਹੈਂ ਕਿ ਜਿਵੇਂ ਤੂੰ ਉਸ ਮਿਸਰੀ ਨੂੰ ਮਾਰ ਸੁੱਟਿਆ ਉਸੇ ਤਰ੍ਹਾਂ ਹੀ ਮੈਨੂੰ ਵੀ ਮਾਰ ਸੁੱਟੇਂਗਾ? ਤਦ ਮੂਸਾ ਡਰ ਗਿਆ ਅਤੇ ਉਸ ਨੇ ਆਖਿਆ, ਇਹ ਗੱਲ ਜ਼ਰੂਰ ਖੁੱਲ੍ਹ ਗਈ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","ਜਦ ਫ਼ਿਰਊਨ ਨੇ ਇਹ ਗੱਲ ਸੁਣੀ ਤਦ ਮੂਸਾ ਨੂੰ ਜਾਨ ਤੋਂ ਮਾਰਨ ਦੀ ਕੋਸ਼ਿਸ਼ ਕੀਤੀ ਪਰ ਮੂਸਾ ਫ਼ਿਰਊਨ ਦੇ ਅੱਗੋਂ ਭੱਜ ਕੇ ਮਿਦਯਾਨ ਦੇ ਦੇਸ ਵਿੱਚ ਰਹਿਣ ਲੱਗਾ ਅਤੇ ਇੱਕ ਖੂਹ ਦੇ ਕੋਲ ਬੈਠ ਗਿਆ। ");
INSERT INTO pan_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","ਮਿਦਯਾਨ ਦੇ ਜਾਜਕ ਦੀਆਂ ਸੱਤ ਧੀਆਂ ਸਨ। ਉਨ੍ਹਾਂ ਨੇ ਆ ਕੇ ਪਾਣੀ ਕੱਢਿਆ ਅਤੇ ਆਪਣੇ ਪਿਤਾ ਦੇ ਇੱਜੜ ਨੂੰ ਪਿਲਾਉਣ ਲਈ ਚੁਬੱਚਿਆਂ ਨੂੰ ਭਰ ਲਿਆ। ");
INSERT INTO pan_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","ਅਯਾਲੀਆਂ ਨੇ ਆਣ ਕੇ ਉਨ੍ਹਾਂ ਨੂੰ ਧੱਕੇ ਨਾਲ ਪਰ੍ਹੇ ਹਟਾ ਦਿੱਤਾ, ਪਰ ਮੂਸਾ ਨੇ ਉੱਠ ਕੇ ਉਨ੍ਹਾਂ ਨੂੰ ਬਚਾਇਆ ਅਤੇ ਉਨ੍ਹਾਂ ਦੇ ਇੱਜੜ ਨੂੰ ਪਾਣੀ ਪਿਲਾਇਆ। ");
INSERT INTO pan_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","ਜਦ ਉਹ ਆਪਣੇ ਪਿਤਾ ਰਊਏਲ ਕੋਲ ਆਈਆਂ ਤਦ ਉਸ ਨੇ ਪੁੱਛਿਆ, ਤੁਸੀਂ ਅੱਜ ਕਿਵੇਂ ਛੇਤੀ ਮੁੜ ਆਈਆਂ ਹੋ? ");
INSERT INTO pan_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","ਉਨ੍ਹਾਂ ਨੇ ਆਖਿਆ, ਇੱਕ ਮਿਸਰੀ ਨੇ ਸਾਨੂੰ ਅਯਾਲੀਆਂ ਦੇ ਹੱਥੋਂ ਛੁਡਾਇਆ ਅਤੇ ਸਾਡੇ ਲਈ ਪਾਣੀ ਕੱਢ-ਕੱਢ ਕੇ ਇੱਜੜ ਨੂੰ ਪਿਲਾਇਆ। ");
INSERT INTO pan_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","ਤਦ ਉਸ ਨੇ ਆਪਣੀਆਂ ਧੀਆਂ ਨੂੰ ਆਖਿਆ, ਉਹ ਮਨੁੱਖ ਕਿੱਥੇ ਹੈ? ਤੁਸੀਂ ਉਸ ਨੂੰ ਕਿਉਂ ਛੱਡ ਆਈਆਂ ਹੋ? ਉਸ ਨੂੰ ਬੁਲਾਓ ਤਾਂ ਜੋ ਉਹ ਰੋਟੀ ਖਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","ਤਦ ਮੂਸਾ ਉਸ ਮਨੁੱਖ ਕੋਲ ਰਹਿਣ ਲਈ ਮੰਨ ਗਿਆ ਅਤੇ ਉਸ ਨੇ ਆਪਣੀ ਧੀ ਸਿੱਪੋਰਾਹ ਮੂਸਾ ਨਾਲ ਵਿਆਹ ਦਿੱਤੀ ");
INSERT INTO pan_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","ਉਸ ਨੇ ਪੁੱਤਰ ਨੂੰ ਜਨਮ ਦਿੱਤਾ ਅਤੇ ਉਸ ਨੇ ਉਸ ਦਾ ਨਾਮ ਗੇਰਸ਼ੋਮ ਰੱਖਿਆ ਕਿਉਂ ਜੋ ਉਸ ਨੇ ਆਖਿਆ, “ਮੈਂ ਪਰਦੇਸ ਵਿੱਚ ਪਰਦੇਸੀ ਹੋਇਆ ਹਾਂ।” ");
INSERT INTO pan_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","ਅਜਿਹਾ ਹੋਇਆ ਕਿ ਬਹੁਤ ਦਿਨਾਂ ਬਾਅਦ ਮਿਸਰ ਦਾ ਰਾਜਾ ਮਰ ਗਿਆ, ਇਸਰਾਏਲੀਆਂ ਨੇ ਗ਼ੁਲਾਮੀ ਦੇ ਕਾਰਨ ਹਾਉਂਕੇ ਲਏ ਅਤੇ ਧਾਹਾਂ ਮਾਰ-ਮਾਰ ਕੇ ਰੋਏ ਅਤੇ ਇਨ੍ਹਾਂ ਦੀ ਦੁਹਾਈ ਜੋ ਗ਼ੁਲਾਮੀ ਦੇ ਕਾਰਨ ਸੀ, ਪਰਮੇਸ਼ੁਰ ਤੱਕ ਪਹੁੰਚੀ। ");
INSERT INTO pan_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","ਤਦ ਪਰਮੇਸ਼ੁਰ ਨੇ ਉਨ੍ਹਾਂ ਦੇ ਹਾਉਂਕਿਆਂ ਨੂੰ ਸੁਣਿਆ ਅਤੇ ਪਰਮੇਸ਼ੁਰ ਨੇ ਆਪਣੇ ਨੇਮ ਨੂੰ ਜਿਹੜਾ ਅਬਰਾਹਾਮ, ਇਸਹਾਕ ਅਤੇ ਯਾਕੂਬ ਦੇ ਨਾਲ ਸੀ, ਯਾਦ ਕੀਤਾ। ");
INSERT INTO pan_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","ਤਦ ਪਰਮੇਸ਼ੁਰ ਨੇ ਇਸਰਾਏਲੀਆਂ ਵੱਲ ਨਿਗਾਹ ਕੀਤੀ ਅਤੇ ਪਰਮੇਸ਼ੁਰ ਨੇ ਉਨ੍ਹਾਂ ਦੀ ਖ਼ਬਰ ਲਈ। ");
INSERT INTO pan_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","ਮੂਸਾ ਆਪਣੇ ਸੌਹਰੇ ਯਿਥਰੋ ਮਿਦਯਾਨੀ ਜਾਜਕ ਦੇ ਇੱਜੜ ਨੂੰ ਚਾਰਦਾ ਸੀ। ਉਸ ਨੇ ਇੱਜੜ ਨੂੰ ਉਜਾੜ ਦੇ ਪਿਛਲੀ ਵੱਲ ਹੱਕ ਦਿੱਤਾ ਅਤੇ ਉਹ ਪਰਮੇਸ਼ੁਰ ਦੇ ਪਰਬਤ ਹੋਰੇਬ ਦੇ ਕੋਲ ਆਇਆ। ");
INSERT INTO pan_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","ਤਦ ਯਹੋਵਾਹ ਦੇ ਇੱਕ ਦੂਤ ਨੇ ਇੱਕ ਝਾੜੀ ਵਿੱਚੋਂ ਅੱਗ ਦੀ ਲਾਟ ਵਿੱਚ ਉਸ ਨੂੰ ਦਰਸ਼ਣ ਦਿੱਤਾ। ਜਦ ਉਸ ਨੇ ਵੇਖਿਆ ਤਾਂ ਵੇਖੋ, ਉਹ ਝਾੜੀ ਅੱਗ ਵਿੱਚ ਬਲ ਰਹੀ ਸੀ ਪਰ ਝਾੜੀ ਭਸਮ ਨਹੀਂ ਹੁੰਦੀ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","ਤਦ ਮੂਸਾ ਨੇ ਆਖਿਆ, ਮੈਂ ਇੱਕ ਪਾਸੇ ਵੱਲੋਂ ਹੋ ਕੇ ਜਾਂਵਾਂਗਾ ਅਤੇ ਇਸ ਵੱਡੇ ਨਜ਼ਾਰੇ ਨੂੰ ਵੇਖਾਂਗਾ ਕਿ ਕਿਉਂ ਝਾੜੀ ਨਹੀਂ ਸੜਦੀ। ");
INSERT INTO pan_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","ਯਹੋਵਾਹ ਨੇ ਵੇਖਿਆ ਕਿ ਉਹ ਵੇਖਣ ਨੂੰ ਇੱਕ ਪਾਸੇ ਨੂੰ ਮੁੜਿਆ ਤਦ ਪਰਮੇਸ਼ੁਰ ਨੇ ਉਸ ਝਾੜੀ ਵਿੱਚੋਂ ਪੁਕਾਰ ਕੇ ਉਸ ਨੂੰ ਆਖਿਆ, “ਹੇ ਮੂਸਾ, ਹੇ ਮੂਸਾ!” ਤਦ ਉਸ ਨੇ ਆਖਿਆ, “ਮੈਂ ਹਾਜ਼ਰ ਹਾਂ।” ");
INSERT INTO pan_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","ਫਿਰ ਉਸ ਨੇ ਆਖਿਆ, ਇੱਧਰ ਨੇੜੇ ਨਾ ਆ। ਆਪਣਿਆਂ ਪੈਰਾਂ ਦੀ ਜੁੱਤੀ ਲਾਹ ਦੇ ਕਿਉਂ ਜੋ ਇਹ ਥਾਂ ਜਿੱਥੇ ਤੂੰ ਖੜ੍ਹਾ ਹੈਂ, ਪਵਿੱਤਰ ਭੂਮੀ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","ਉਸਨੇ ਇਹ ਵੀ ਆਖਿਆ, “ਮੈਂ ਤੇਰੇ ਪਿਤਾ ਦਾ ਪਰਮੇਸ਼ੁਰ, ਅਬਰਾਹਾਮ ਦਾ ਪਰਮੇਸ਼ੁਰ, ਇਸਹਾਕ ਦਾ ਪਰਮੇਸ਼ੁਰ ਅਤੇ ਯਾਕੂਬ ਦਾ ਪਰਮੇਸ਼ੁਰ ਹਾਂ।” ਮੂਸਾ ਨੇ ਆਪਣਾ ਮੂੰਹ ਢੱਕ ਲਿਆ ਕਿਉਂ ਜੋ ਉਹ ਪਰਮੇਸ਼ੁਰ ਵੱਲ ਦੇਖਣ ਤੋਂ ਡਰਦਾ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","ਯਹੋਵਾਹ ਨੇ ਆਖਿਆ ਕਿ ਮੈਂ ਆਪਣੀ ਪਰਜਾ ਦੀ ਮੁਸੀਬਤ ਨੂੰ ਜਿਹੜੀ ਮਿਸਰ ਵਿੱਚ ਹੈ, ਸੱਚ-ਮੁੱਚ ਵੇਖਿਆ ਹੈ ਅਤੇ ਉਨ੍ਹਾਂ ਦੀ ਦੁਹਾਈ ਜੋ ਉਨ੍ਹਾਂ ਤੋਂ ਬੇਗ਼ਾਰ ਕਰਾਉਣ ਵਾਲਿਆਂ ਦੇ ਕਾਰਨ ਹੈ, ਸੁਣੀ ਕਿਉਂ ਜੋ ਮੈਂ ਉਨ੍ਹਾਂ ਦੇ ਦੁੱਖਾਂ ਨੂੰ ਜਾਣਦਾ ਹਾਂ। ");
INSERT INTO pan_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","ਮੈਂ ਉਤਰਿਆ ਹਾਂ, ਤਾਂ ਜੋ ਉਨ੍ਹਾਂ ਨੂੰ ਮਿਸਰੀਆਂ ਦੇ ਹੱਥੋਂ ਛੁਡਾਵਾਂ ਅਤੇ ਉਸ ਧਰਤੀ ਵਿੱਚੋਂ ਕੱਢ ਕੇ ਚੰਗੀ ਅਤੇ ਉਪਜਾਊ ਧਰਤੀ ਵਿੱਚ ਜਿੱਥੇ ਦੁੱਧ ਅਤੇ ਸ਼ਹਿਦ ਵਗਦਾ ਹੈ ਅਰਥਾਤ ਕਨਾਨੀਆਂ, ਹਿੱਤੀਆਂ, ਅਮੋਰੀਆਂ, ਫ਼ਰਿੱਜ਼ੀਆਂ, ਹਿੱਵੀਆਂ ਅਤੇ ਯਬੂਸੀਆਂ ਦੀ ਥਾਂ ਵਿੱਚ ਉਤਾਹਾਂ ਲਿਆਵਾਂ। ");
INSERT INTO pan_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","ਸੋ ਹੁਣ ਵੇਖ, ਇਸਰਾਏਲੀਆਂ ਦੀ ਦੁਹਾਈ ਮੇਰੇ ਤੱਕ ਪਹੁੰਚੀ ਅਤੇ ਮੈਂ ਉਸ ਅਨ੍ਹੇਰ ਨੂੰ ਵੀ ਜੋ ਮਿਸਰੀ ਉਨ੍ਹਾਂ ਉੱਤੇ ਕਰਦੇ ਹਨ, ਵੇਖਿਆ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","ਹੁਣ ਤੂੰ ਆ। ਮੈਂ ਤੈਨੂੰ ਫ਼ਿਰਊਨ ਕੋਲ ਭੇਜਾਂਗਾ ਤਾਂ ਜੋ ਤੂੰ ਮੇਰੀ ਪਰਜਾ ਅਰਥਾਤ ਇਸਰਾਏਲੀਆਂ ਨੂੰ ਮਿਸਰ ਵਿੱਚੋਂ ਕੱਢ ਲਿਆਵੇਂ। ");
INSERT INTO pan_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","ਤਦ ਮੂਸਾ ਨੇ ਪਰਮੇਸ਼ੁਰ ਨੂੰ ਆਖਿਆ, “ਮੈਂ ਕੌਣ ਹਾਂ ਜੋ ਮੈਂ ਫ਼ਿਰਊਨ ਕੋਲ ਜਾਂਵਾਂ ਅਤੇ ਇਸਰਾਏਲੀਆਂ ਨੂੰ ਮਿਸਰ ਤੋਂ ਕੱਢ ਲਿਆਵਾਂ?” ");
INSERT INTO pan_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","ਉਸ ਨੇ ਆਖਿਆ, ਮੈਂ ਤੇਰੇ ਨਾਲ ਹੀ ਹੋਵਾਂਗਾ ਅਤੇ ਤੇਰੇ ਲਈ ਇਹ ਚਿੰਨ੍ਹ ਹੋਵੇਗਾ ਕਿ ਮੈਂ ਤੈਨੂੰ ਭੇਜਿਆ ਕਿ ਜਦ ਤੂੰ ਇਸ ਪਰਜਾ ਨੂੰ ਮਿਸਰ ਤੋਂ ਕੱਢ ਲਿਆਵੇਂਗਾ ਤਦ ਤੁਸੀਂ ਇਸ ਪਰਬਤ ਉੱਤੇ ਪਰਮੇਸ਼ੁਰ ਦੀ ਉਪਾਸਨਾ ਕਰੋਗੇ। ");
INSERT INTO pan_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","ਫਿਰ ਮੂਸਾ ਨੇ ਪਰਮੇਸ਼ੁਰ ਨੂੰ ਆਖਿਆ, ਵੇਖ, ਜਦ ਮੈਂ ਇਸਰਾਏਲੀਆਂ ਦੇ ਕੋਲ ਜਾਂਵਾਂ ਅਤੇ ਉਨ੍ਹਾਂ ਨੂੰ ਆਖਾਂ ਕਿ ਤੁਹਾਡੇ ਪੁਰਖਿਆਂ ਦੇ ਪਰਮੇਸ਼ੁਰ ਨੇ ਮੈਨੂੰ ਤੁਹਾਡੇ ਕੋਲ ਭੇਜਿਆ ਹੈ ਤਦ ਉਹ ਮੈਨੂੰ ਆਖਣਗੇ ਕਿ ਉਸ ਦਾ ਨਾਮ ਕੀ ਹੈ? ਤਾਂ ਮੈਂ ਉਨ੍ਹਾਂ ਨੂੰ ਕੀ ਦੱਸਾਂ? ");
INSERT INTO pan_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","ਪਰਮੇਸ਼ੁਰ ਨੇ ਮੂਸਾ ਨੂੰ ਆਖਿਆ, “ਮੈਂ ਹਾਂ ਜੋ ਮੈਂ ਹਾਂ” ਅਤੇ ਤੂੰ ਇਸਰਾਏਲੀਆਂ ਨੂੰ ਇਸ ਤਰ੍ਹਾਂ ਆਖੀਂ ਕਿ ਜਿਸ ਦਾ ਨਾਮ ਮੈਂ ਹਾਂ ਜੋ ਮੈਂ ਹਾਂ, ਉਸੇ ਨੇ ਮੈਨੂੰ ਤੁਹਾਡੇ ਕੋਲ ਭੇਜਿਆ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","ਪਰਮੇਸ਼ੁਰ ਨੇ ਮੂਸਾ ਨੂੰ ਹੋਰ ਇਹ ਆਖਿਆ, “ਤੂੰ ਇਸਰਾਏਲੀਆਂ ਨੂੰ ਅਜਿਹਾ ਆਖੀਂ ਕਿ ਯਹੋਵਾਹ ਤੁਹਾਡੇ ਪੁਰਖਿਆਂ ਦੇ ਪਰਮੇਸ਼ੁਰ, ਅਬਰਾਹਾਮ ਦੇ ਪਰਮੇਸ਼ੁਰ, ਇਸਹਾਕ ਦੇ ਪਰਮੇਸ਼ੁਰ ਅਤੇ ਯਾਕੂਬ ਦੇ ਪਰਮੇਸ਼ੁਰ ਨੇ ਮੈਨੂੰ ਤੁਹਾਡੇ ਕੋਲ ਭੇਜਿਆ ਹੈ। ਸਦੀਪਕਾਲ ਤੋਂ ਮੇਰਾ ਇਹੋ ਹੀ ਨਾਮ ਹੈ ਅਤੇ ਪੀੜ੍ਹੀਓਂ ਪੀੜ੍ਹੀ ਮੇਰੀ ਇਹੋ ਹੀ ਯਾਦਗਿਰੀ ਹੈ।” ");
INSERT INTO pan_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","ਜਾ, ਇਸਰਾਏਲ ਦੇ ਬਜ਼ੁਰਗਾਂ ਨੂੰ ਇਕੱਠੇ ਕਰ ਅਤੇ ਉਨ੍ਹਾਂ ਨੂੰ ਆਖ ਕਿ ਯਹੋਵਾਹ ਤੁਹਾਡੇ ਪੁਰਖਿਆਂ ਦੇ ਪਰਮੇਸ਼ੁਰ, ਅਬਰਾਹਾਮ, ਇਸਹਾਕ ਅਤੇ ਯਾਕੂਬ ਦੇ ਪਰਮੇਸ਼ੁਰ ਨੇ ਇਸ ਤਰ੍ਹਾਂ ਆਖ ਕੇ ਮੈਨੂੰ ਦਰਸ਼ਣ ਦਿੱਤਾ ਕਿ ਮੈਂ ਜ਼ਰੂਰ ਤੁਹਾਡੀ ਖ਼ਬਰ ਲਈ ਹੈ ਅਤੇ ਜੋ ਕੁਝ ਮਿਸਰ ਵਿੱਚ ਤੁਹਾਡੇ ਉੱਤੇ ਬੀਤਿਆ ਹੈ, ਉਹ ਸਭ ਵੇਖਿਆ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","ਮੈਂ ਆਖਿਆ ਹੈ ਕਿ ਮੈਂ ਤੁਹਾਨੂੰ ਮਿਸਰ ਦੇ ਦੁੱਖਾਂ ਤੋਂ ਕਨਾਨੀਆਂ, ਹਿੱਤੀਆਂ, ਅਮੋਰੀਆਂ, ਫ਼ਰਿੱਜ਼ੀਆਂ, ਹਿੱਵੀਆਂ ਅਤੇ ਯਬੂਸੀਆਂ ਦੇ ਦੇਸ ਵਿੱਚ ਅਰਥਾਤ ਅਜਿਹੇ ਦੇਸ ਵਿੱਚ ਜਿੱਥੇ ਦੁੱਧ ਅਤੇ ਸ਼ਹਿਦ ਵਗਦਾ ਹੈ, ਉਤਾਹਾਂ ਲਿਆਵਾਂਗਾ। ");
INSERT INTO pan_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","ਉਹ ਤੇਰੀ ਗੱਲ ਨੂੰ ਸੁਣਨਗੇ, ਤੂੰ ਅਤੇ ਇਸਰਾਏਲ ਦੇ ਬਜ਼ੁਰਗ ਮਿਸਰ ਦੇ ਰਾਜੇ ਦੇ ਕੋਲ ਜਾ ਕੇ ਉਸ ਨੂੰ ਆਖਿਓ ਕਿ ਯਹੋਵਾਹ ਇਬਰਾਨੀਆਂ ਦਾ ਪਰਮੇਸ਼ੁਰ ਸਾਨੂੰ ਮਿਲਿਆ ਹੈ। ਹੁਣ ਤੂੰ ਸਾਨੂੰ ਤਿੰਨ ਦਿਨਾਂ ਦੇ ਰਸਤੇ ਲਈ ਉਜਾੜ ਵਿੱਚ ਜਾਣ ਦੇ ਤਾਂ ਜੋ ਅਸੀਂ ਯਹੋਵਾਹ ਆਪਣੇ ਪਰਮੇਸ਼ੁਰ ਲਈ ਬਲੀਆਂ ਚੜ੍ਹਾਈਏ। ");
INSERT INTO pan_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","ਪਰ ਮੈਂ ਜਾਣਦਾ ਹਾਂ ਕਿ ਮਿਸਰ ਦਾ ਰਾਜਾ ਤੁਹਾਨੂੰ ਨਾ ਜਾਣ ਦੇਵੇਗਾ। ਹਾਂ, ਬਹੁਤ ਜਿਆਦਾ ਦਬਾਓ ਪਾਉਣ ਤੇ ਵੀ ਉਹ ਜਾਣ ਨਹੀਂ ਦੇਵੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","ਮੈਂ ਆਪਣਾ ਹੱਥ ਵਧਾਵਾਂਗਾ ਅਤੇ ਮਿਸਰ ਨੂੰ ਆਪਣਿਆਂ ਸਭ ਅਚਰਜ਼ ਕੰਮਾਂ ਨਾਲ ਜੋ ਮੈਂ ਉਸ ਵਿੱਚ ਵਿਖਾਵਾਂਗਾ, ਮਾਰਾਂਗਾ। ਉਸ ਦੇ ਪਿੱਛੋਂ ਉਹ ਤੁਹਾਨੂੰ ਜਾਣ ਦੇਵੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","ਮੈਂ ਇਸ ਪਰਜਾ ਲਈ ਮਿਸਰੀਆਂ ਦੀਆਂ ਅੱਖਾਂ ਵਿੱਚ ਦਯਾ ਪਾਵਾਂਗਾ ਅਤੇ ਅਜਿਹਾ ਹੋਵੇਗਾ ਕਿ ਜਦ ਤੁਸੀਂ ਜਾਓਗੇ ਤਾਂ ਖਾਲੀ ਹੱਥ ਨਾ ਜਾਓਗੇ। ");
INSERT INTO pan_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","ਸਗੋਂ ਇੱਕ-ਇੱਕ ਔਰਤ ਆਪਣੀ ਗੁਆਂਢਣ ਤੋਂ ਅਤੇ ਉਸ ਤੋਂ ਜੋ ਉਸ ਦੇ ਘਰ ਵਿੱਚ ਰਹਿੰਦੀ ਹੈ, ਚਾਂਦੀ ਦੇ ਗਹਿਣੇ, ਸੋਨੇ ਦੇ ਗਹਿਣੇ ਅਤੇ ਬਸਤਰ ਮੰਗੇਗੀ ਅਤੇ ਤੁਸੀਂ ਆਪਣੇ ਪੁੱਤਰਾਂ ਅਤੇ ਧੀਆਂ ਦੇ ਪਾਓਗੇ ਅਤੇ ਮਿਸਰੀਆਂ ਨੂੰ ਲੁੱਟ ਲਓਗੇ। ");
INSERT INTO pan_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","ਮੂਸਾ ਨੇ ਉੱਤਰ ਦਿੱਤਾ ਕਿ ਵੇਖ, ਉਹ ਮੇਰਾ ਵਿਸ਼ਵਾਸ ਨਾ ਕਰਨਗੇ, ਨਾ ਮੇਰੀ ਅਵਾਜ਼ ਸੁਣਨਗੇ ਸਗੋਂ ਉਹ ਆਖਣਗੇ, ਯਹੋਵਾਹ ਨੇ ਤੈਨੂੰ ਦਰਸ਼ਣ ਨਹੀਂ ਦਿੱਤਾ। ");
INSERT INTO pan_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","ਤਦ ਯਹੋਵਾਹ ਨੇ ਉਸ ਨੂੰ ਆਖਿਆ, “ਤੇਰੇ ਹੱਥ ਵਿੱਚ ਕੀ ਹੈ?” ਉਸ ਨੇ ਆਖਿਆ, “ਲਾਠੀ।” ਤਦ ਉਸ ਨੇ ਆਖਿਆ, “ਇਸ ਨੂੰ ਧਰਤੀ ਉੱਤੇ ਸੁੱਟ ਦੇ।” ");
INSERT INTO pan_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","ਤਦ ਉਸ ਨੇ ਉਸ ਨੂੰ ਧਰਤੀ ਉੱਤੇ ਸੁੱਟ ਦਿੱਤਾ। ਉਹ ਸੱਪ ਬਣ ਗਿਆ ਅਤੇ ਮੂਸਾ ਉਸ ਦੇ ਅੱਗੋਂ ਭੱਜਾ। ");
INSERT INTO pan_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਆਖਿਆ, “ਆਪਣਾ ਹੱਥ ਵਧਾ ਕੇ ਉਸ ਨੂੰ ਪੂਛ ਤੋਂ ਫੜ੍ਹ ਲੈ ਤਦ ਉਸ ਨੇ ਆਪਣਾ ਹੱਥ ਵਧਾ ਕੇ ਉਸ ਨੂੰ ਫੜ੍ਹ ਲਿਆ ਅਤੇ ਉਹ ਦੇ ਹੱਥ ਵਿੱਚ ਲਾਠੀ ਬਣ ਗਿਆ।” ");
INSERT INTO pan_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","ਇਸ ਲਈ ਜੋ ਉਹ ਵਿਸ਼ਵਾਸ ਕਰਨ ਕਿ ਯਹੋਵਾਹ ਉਨ੍ਹਾਂ ਦੇ ਪੁਰਖਿਆਂ ਦੇ ਪਰਮੇਸ਼ੁਰ, ਅਬਰਾਹਾਮ ਦੇ ਪਰਮੇਸ਼ੁਰ, ਇਸਹਾਕ ਦੇ ਪਰਮੇਸ਼ੁਰ ਅਤੇ ਯਾਕੂਬ ਦੇ ਪਰਮੇਸ਼ੁਰ ਨੇ ਤੈਨੂੰ ਦਰਸ਼ਣ ਦਿੱਤਾ। ");
INSERT INTO pan_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","ਯਹੋਵਾਹ ਨੇ ਉਸ ਨੂੰ ਹੋਰ ਇਹ ਆਖਿਆ, “ਹੁਣ ਤੂੰ ਆਪਣਾ ਹੱਥ ਆਪਣੀ ਛਾਤੀ ਉੱਤੇ ਰੱਖ”, ਤਾਂ ਉਸ ਨੇ ਆਪਣਾ ਹੱਥ ਆਪਣੀ ਛਾਤੀ ਉੱਤੇ ਰੱਖਿਆ। ਜਦ ਉਸ ਨੇ ਉਹ ਕੱਢਿਆ ਤਾਂ ਵੇਖੋ, ਉਹ ਦਾ ਹੱਥ ਕੋੜ੍ਹ ਨਾਲ ਬਰਫ਼ ਵਰਗਾ ਹੋ ਗਿਆ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","ਉਸ ਨੇ ਆਖਿਆ, ਤੂੰ ਫੇਰ ਆਪਣਾ ਹੱਥ ਆਪਣੀ ਛਾਤੀ ਉੱਤੇ ਰੱਖ। ਉਸ ਨੇ ਆਪਣਾ ਹੱਥ ਆਪਣੀ ਛਾਤੀ ਉੱਤੇ ਫੇਰ ਰੱਖਿਆ, ਜਦ ਬਾਹਰ ਕੱਢਿਆ ਤਾਂ ਵੇਖੋ, ਉਹ ਉਸ ਦੇ ਬਾਕੀ ਸਰੀਰ ਵਰਗਾ ਹੋ ਗਿਆ। ");
INSERT INTO pan_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","ਫੇਰ ਅਜਿਹਾ ਹੋਵੇਗਾ ਕਿ ਜੇ ਉਹ ਤੇਰਾ ਵਿਸ਼ਵਾਸ ਨਾ ਕਰਨ, ਨਾ ਹੀ ਪਹਿਲੇ ਨਿਸ਼ਾਨ ਦਾ ਅਰਥ ਮੰਨਣ ਤਾਂ ਉਹ ਦੂਜੇ ਨਿਸ਼ਾਨ ਦੇ ਅਰਥ ਉੱਤੇ ਵਿਸ਼ਵਾਸ ਕਰਨਗੇ। ");
INSERT INTO pan_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","ਜੇਕਰ ਉਹ ਇਨ੍ਹਾਂ ਦੋਹਾਂ ਨਿਸ਼ਾਨਾਂ ਉੱਤੇ ਵੀ ਵਿਸ਼ਵਾਸ ਨਾ ਕਰਨ, ਨਾ ਤੇਰੀ ਅਵਾਜ਼ ਨੂੰ ਸੁਣਨ ਤਾਂ ਤੂੰ ਦਰਿਆ ਦਾ ਪਾਣੀ ਲੈ ਕੇ ਸੁੱਕੀ ਭੂਮੀ ਉੱਤੇ ਡੋਲ੍ਹ ਦੇਵੀਂ। ਉਹ ਪਾਣੀ ਜਿਹੜਾ ਤੂੰ ਨਦੀ ਤੋਂ ਲਵੇਂਗਾ, ਉਹ ਉਸ ਭੂਮੀ ਉੱਤੇ ਲਹੂ ਬਣ ਜਾਵੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","ਤਦ ਮੂਸਾ ਨੇ ਯਹੋਵਾਹ ਨੂੰ ਆਖਿਆ, ਹੇ ਪ੍ਰਭੂ, ਮੈਂ ਚੰਗਾ ਬੋਲਣ ਵਾਲਾ ਮਨੁੱਖ ਨਹੀਂ ਹਾਂ, ਨਾ ਅੱਗੇ ਸੀ, ਨਾ ਜਦ ਤੋਂ ਤੂੰ ਆਪਣੇ ਦਾਸ ਨਾਲ ਬੋਲਿਆ ਕਿਉਂ ਜੋ ਮੈਂ ਬੋਲਣ ਵਿੱਚ ਢਿੱਲਾ ਹਾਂ ਅਤੇ ਮੇਰੀ ਜੀਭ ਮੋਟੀ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","ਤਦ ਯਹੋਵਾਹ ਨੇ ਉਸ ਨੂੰ ਆਖਿਆ, “ਆਦਮੀ ਦਾ ਮੂੰਹ ਕਿਸ ਨੇ ਬਣਾਇਆ ਅਤੇ ਕੌਣ ਗੂੰਗਾ, ਬੋਲ੍ਹਾ, ਸੁਜਾਖਾ ਜਾਂ ਅੰਨ੍ਹਾ ਬਣਾਉਂਦਾ ਹੈ? ਭਲਾ, ਮੈਂ ਯਹੋਵਾਹ ਹੀ ਨਹੀਂ? ");
INSERT INTO pan_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","ਸੋ ਹੁਣ ਤੂੰ ਜਾ। ਮੈਂ ਤੇਰੇ ਮੂੰਹ ਦੇ ਨਾਲ ਹੋਵਾਂਗਾ ਅਤੇ ਜੋ ਕੁਝ ਤੂੰ ਬੋਲਣਾ ਹੈ, ਮੈਂ ਤੈਨੂੰ ਸਿਖਾਵਾਂਗਾ।” ");
INSERT INTO pan_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","ਤਦ ਉਸ ਨੇ ਆਖਿਆ, “ਹੇ ਪ੍ਰਭੂ, ਕਿਰਪਾ ਕਰਕੇ ਕਿਸੇ ਹੋਰ ਨੂੰ ਜਿਸ ਨੂੰ ਤੂੰ ਚਾਹੁੰਦਾ ਹੈ, ਭੇਜ ਦੇ।” ");
INSERT INTO pan_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","ਫਿਰ ਯਹੋਵਾਹ ਦਾ ਕ੍ਰੋਧ ਮੂਸਾ ਉੱਤੇ ਭੜਕਿਆ ਅਤੇ ਉਸ ਨੇ ਆਖਿਆ, ਕੀ ਹਾਰੂਨ ਲੇਵੀ ਤੇਰਾ ਭਰਾ ਨਹੀਂ ਹੈ? ਮੈਂ ਜਾਣਦਾ ਹਾਂ ਕਿ ਉਹ ਚੰਗਾ ਬੋਲਣ ਵਾਲਾ ਹੈ ਅਤੇ ਵੇਖ ਉਹ ਤੇਰੇ ਮਿਲਣ ਨੂੰ ਆਉਂਦਾ ਹੈ ਅਤੇ ਤੈਨੂੰ ਵੇਖ ਕੇ ਆਪਣੇ ਮਨ ਵਿੱਚ ਅਨੰਦ ਹੋਵੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","ਤੂੰ ਉਸ ਦੇ ਨਾਲ ਬੋਲੇਂਗਾ ਅਤੇ ਉਸ ਦੇ ਮੂੰਹ ਵਿੱਚ ਗੱਲਾਂ ਪਾਵੇਂਗਾ ਅਤੇ ਮੈਂ ਤੇਰੇ ਮੂੰਹ ਨਾਲ ਅਤੇ ਉਹ ਦੇ ਮੂੰਹ ਨਾਲ ਹੋਵਾਂਗਾ ਅਤੇ ਜੋ ਤੁਸੀਂ ਕਰਨਾ ਹੈ, ਮੈਂ ਤੁਹਾਨੂੰ ਸਿਖਾਵਾਂਗਾ। ");
INSERT INTO pan_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","ਉਹ ਤੇਰੀ ਵੱਲੋਂ ਪਰਜਾ ਨਾਲ ਬੋਲੇਗਾ ਅਤੇ ਅਜਿਹਾ ਹੋਵੇਗਾ ਕਿ ਉਹ ਤੇਰੇ ਲਈ ਮੂੰਹ ਜਿਹਾ ਹੋਵੇਗਾ, ਤੂੰ ਉਸ ਲਈ ਪਰਮੇਸ਼ੁਰ ਜਿਹਾ ਹੋਵੇਂਗਾ। ");
INSERT INTO pan_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","ਤੂੰ ਇਹ ਲਾਠੀ ਆਪਣੇ ਹੱਥ ਵਿੱਚ ਲਵੀਂ ਜਿਸ ਦੇ ਨਾਲ ਤੂੰ ਉਨ੍ਹਾਂ ਨਿਸ਼ਾਨਾਂ ਨੂੰ ਵਿਖਾਵੇਂਗਾ। ");
INSERT INTO pan_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","ਮੂਸਾ ਆਪਣੇ ਸੌਹਰੇ ਯਿਥਰੋ ਕੋਲ ਵਾਪਸ ਗਿਆ ਤੇ ਉਸ ਨੂੰ ਆਖਿਆ, ਕਿਰਪਾ ਕਰ ਕੇ ਮੈਨੂੰ ਮਿਸਰ ਵਿੱਚ ਆਪਣੇ ਭਰਾਵਾਂ ਕੋਲ ਮੁੜ ਜਾਣ ਦਿਓ ਤਾਂ ਜੋ ਮੈਂ ਵੇਖਾਂ ਕਿ ਉਹ ਹੁਣ ਤੱਕ ਜਿਉਂਦੇ ਹਨ ਤਾਂ ਯਿਥਰੋ ਨੇ ਮੂਸਾ ਨੂੰ ਆਖਿਆ, ਖੁਸ਼ੀ-ਖੁਸ਼ੀ ਜਾ। ");
INSERT INTO pan_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","ਤਦ ਯਹੋਵਾਹ ਨੇ ਮਿਦਯਾਨ ਵਿੱਚ ਮੂਸਾ ਨੂੰ ਆਖਿਆ, ਜਾ ਅਤੇ ਮਿਸਰ ਨੂੰ ਮੁੜ ਕਿਉਂ ਜੋ ਤੇਰੀ ਜਾਨ ਦੇ ਚਾਹੁਣ ਵਾਲੇ ਮਰ ਗਏ ਹਨ। ");
INSERT INTO pan_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","ਮੂਸਾ ਨੇ ਆਪਣੀ ਪਤਨੀ ਅਤੇ ਆਪਣੇ ਪੁੱਤਰਾਂ ਨੂੰ ਲੈ ਕੇ ਗਧੇ ਉੱਤੇ ਸਵਾਰ ਕੀਤਾ ਅਤੇ ਉਹ ਮਿਸਰ ਦੇਸ ਨੂੰ ਮੁੜ ਪਿਆ, ਮੂਸਾ ਪਰਮੇਸ਼ੁਰ ਦੀ ਲਾਠੀ ਆਪਣੇ ਹੱਥ ਵਿੱਚ ਲੈ ਗਿਆ। ");
INSERT INTO pan_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਆਖਿਆ, “ਜਦ ਤੂੰ ਮਿਸਰ ਵਿੱਚ ਮੁੜ ਜਾਵੇਂ ਤਾਂ ਵੇਖ, ਤੂੰ ਸਾਰੇ ਅਚਰਜ਼ ਕੰਮ ਜਿਹੜੇ ਮੈਂ ਤੇਰੇ ਹੱਥ ਵਿੱਚ ਰੱਖੇ ਹਨ, ਫ਼ਿਰਊਨ ਦੇ ਸਾਹਮਣੇ ਕਰੀਂ ਪਰ ਮੈਂ ਉਸ ਦੇ ਮਨ ਨੂੰ ਸਖ਼ਤ ਹੋਣ ਦਿਆਂਗਾ ਅਤੇ ਉਹ ਪਰਜਾ ਨੂੰ ਜਾਣ ਨਾ ਦੇਵੇਗਾ।” ");
INSERT INTO pan_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","ਤਦ ਤੂੰ ਫ਼ਿਰਊਨ ਨੂੰ ਆਖੀਂ, “ਯਹੋਵਾਹ ਅਜਿਹਾ ਆਖਦਾ ਹੈ ਕਿ ਇਸਰਾਏਲ ਮੇਰਾ ਪਹਿਲੌਠਾ ਪੁੱਤਰ ਹੈ।” ");
INSERT INTO pan_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","ਮੈਂ ਤੈਨੂੰ ਆਖਿਆ ਹੈ ਕਿ ਮੇਰੇ ਪੁੱਤਰ ਨੂੰ ਜਾਣ ਦੇ ਤਾਂ ਜੋ ਉਹ ਮੇਰੀ ਬੰਦਗੀ ਕਰੇ ਅਤੇ ਤੂੰ ਉਸ ਦੇ ਜਾਣ ਦੇਣ ਤੋਂ ਇਨਕਾਰ ਕੀਤਾ ਹੈ। ਵੇਖ, ਮੈਂ ਤੇਰੇ ਪੁੱਤਰ ਸਗੋਂ ਤੇਰੇ ਪਹਿਲੌਠੇ ਪੁੱਤਰ ਨੂੰ ਜਾਨੋਂ ਮਾਰ ਦਿਆਂਗਾ। ");
INSERT INTO pan_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","ਰਸਤੇ ਵਿੱਚ ਜਿੱਥੇ ਉਹ ਠਹਿਰੇ ਉੱਥੇ ਅਜਿਹਾ ਹੋਇਆ ਕਿ ਯਹੋਵਾਹ ਉਸ ਨੂੰ ਮਿਲਿਆ ਅਤੇ ਉਸ ਨੂੰ ਮਾਰਨਾ ਚਾਹਿਆ। ");
INSERT INTO pan_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","ਤਦ ਸਿੱਪੋਰਾਹ ਨੇ ਇੱਕ ਚਕਮਕ ਦਾ ਪੱਥਰ ਲੈ ਕੇ ਆਪਣੇ ਪੁੱਤਰ ਦੀ ਖੱਲੜੀ ਕੱਟ ਸੁੱਟੀ ਅਤੇ ਉਸ ਨੂੰ ਉਸ ਦੇ ਪੈਰਾਂ ਵਿੱਚ ਸੁੱਟ ਕੇ ਆਖਿਆ, ਤੂੰ ਸੱਚ-ਮੁੱਚ ਮੇਰੇ ਲਈ ਇੱਕ ਖੂਨੀ ਪਤੀ ਹੈਂ। ");
INSERT INTO pan_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","ਸੋ ਯਹੋਵਾਹ ਨੇ ਉਸ ਨੂੰ ਛੱਡ ਦਿੱਤਾ। ਫਿਰ ਉਸ ਨੇ ਉਹ ਨੂੰ ਆਖਿਆ, ਸੁੰਨਤ ਦੇ ਕਾਰਨ ਤੂੰ ਖੂਨੀ ਪਤੀ ਹੋਇਆ ਹੈਂ। ");
INSERT INTO pan_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","ਫਿਰ ਯਹੋਵਾਹ ਨੇ ਹਾਰੂਨ ਨੂੰ ਆਖਿਆ, ਜਾ ਅਤੇ ਮੂਸਾ ਨੂੰ ਉਜਾੜ ਵਿੱਚ ਮਿਲ ਤਾਂ ਉਹ ਚਲਾ ਗਿਆ ਅਤੇ ਉਸ ਨੂੰ ਪਰਮੇਸ਼ੁਰ ਦੇ ਪਰਬਤ ਉੱਤੇ ਮਿਲਿਆ ਅਤੇ ਉਸ ਨੂੰ ਚੁੰਮਿਆ। ");
INSERT INTO pan_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","ਤਦ ਮੂਸਾ ਨੇ ਹਾਰੂਨ ਨੂੰ ਯਹੋਵਾਹ ਦੀਆਂ ਸਾਰੀਆਂ ਗੱਲਾਂ ਦੱਸੀਆਂ, ਜਿਨ੍ਹਾਂ ਲਈ ਉਸ ਨੂੰ ਭੇਜਿਆ ਸੀ ਅਤੇ ਉਹ ਸਾਰੇ ਨਿਸ਼ਾਨ ਜਿਨ੍ਹਾਂ ਦਾ ਉਸ ਨੂੰ ਹੁਕਮ ਦਿੱਤਾ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","ਫਿਰ ਮੂਸਾ ਅਤੇ ਹਾਰੂਨ ਚਲੇ ਗਏ ਅਤੇ ਇਸਰਾਏਲੀਆਂ ਦੇ ਸਾਰੇ ਬਜ਼ੁਰਗਾਂ ਨੂੰ ਇਕੱਠੇ ਕੀਤਾ ");
INSERT INTO pan_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","ਹਾਰੂਨ ਨੇ ਸਾਰੀਆਂ ਗੱਲਾਂ ਜਿਹੜੀਆਂ ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨਾਲ ਕੀਤੀਆਂ ਸਨ, ਦੱਸੀਆਂ ਅਤੇ ਪਰਜਾ ਦੇ ਸਾਹਮਣੇ ਉਹ ਨਿਸ਼ਾਨ ਵਿਖਾਏ। ");
INSERT INTO pan_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","ਤਦ ਪਰਜਾ ਨੇ ਵਿਸ਼ਵਾਸ ਕੀਤਾ ਅਤੇ ਜਦ ਉਨ੍ਹਾਂ ਨੇ ਸੁਣਿਆ ਕਿ ਯਹੋਵਾਹ ਨੇ ਇਸਰਾਏਲੀਆਂ ਦੀ ਖ਼ਬਰ ਲਈ ਹੈ ਅਤੇ ਉਨ੍ਹਾਂ ਦਾ ਦੁੱਖ ਵੇਖਿਆ ਹੈ ਤਦ ਆਪਣਾ ਸਿਰ ਝੁਕਾ ਕੇ ਮੱਥਾ ਟੇਕਿਆ। ");
INSERT INTO pan_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","ਇਸ ਦੇ ਬਾਅਦ ਮੂਸਾ ਅਤੇ ਹਾਰੂਨ ਨੇ ਜਾ ਕੇ ਫ਼ਿਰਊਨ ਨੂੰ ਆਖਿਆ, ਯਹੋਵਾਹ ਇਸਰਾਏਲ ਦਾ ਪਰਮੇਸ਼ੁਰ ਇਸ ਤਰ੍ਹਾਂ ਆਖਦਾ ਹੈ, ਮੇਰੀ ਪਰਜਾ ਨੂੰ ਜਾਣ ਦੇ ਤਾਂ ਜੋ ਉਹ ਉਜਾੜ ਵਿੱਚ ਮੇਰਾ ਪਰਬ ਮਨਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","ਪਰ ਫ਼ਿਰਊਨ ਨੇ ਆਖਿਆ, ਯਹੋਵਾਹ ਕੌਣ ਹੈ ਜੋ ਮੈਂ ਉਸ ਦੀ ਅਵਾਜ਼ ਸੁਣਾਂ ਕਿ ਇਸਰਾਏਲ ਨੂੰ ਜਾਣ ਦਿਆਂ? ਮੈਂ ਯਹੋਵਾਹ ਨੂੰ ਨਹੀਂ ਜਾਣਦਾ ਅਤੇ ਮੈਂ ਇਸਰਾਏਲ ਨੂੰ ਬਿਲਕੁਲ ਵੀ ਨਹੀਂ ਜਾਣ ਦੇਵਾਂਗਾ। ");
INSERT INTO pan_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","ਫਿਰ ਉਨ੍ਹਾਂ ਨੇ ਆਖਿਆ, ਇਬਰਾਨੀਆਂ ਦਾ ਪਰਮੇਸ਼ੁਰ ਸਾਨੂੰ ਮਿਲਿਆ। ਸਾਨੂੰ ਤਿੰਨ ਦਿਨਾਂ ਦੇ ਰਸਤੇ ਉਜਾੜ ਵਿੱਚ ਜਾਣ ਦੇ ਤਾਂ ਜੋ ਅਸੀਂ ਆਪਣੇ ਪਰਮੇਸ਼ੁਰ ਯਹੋਵਾਹ ਲਈ ਬਲੀਆਂ ਚੜ੍ਹਾਈਏ ਕਿਤੇ ਅਜਿਹਾ ਨਾ ਹੋਵੇ ਕਿ ਉਹ ਸਾਡੇ ਉੱਤੇ ਮਰੀ ਜਾਂ ਤਲਵਾਰ ਨਾਲ ਚੜ੍ਹਾਈ ਕਰੇ। ");
INSERT INTO pan_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","ਮਿਸਰ ਦੇ ਰਾਜੇ ਨੇ ਉਨ੍ਹਾਂ ਨੂੰ ਆਖਿਆ, ਹੇ ਮੂਸਾ ਅਤੇ ਹੇ ਹਾਰੂਨ, ਤੁਸੀਂ ਕਿਉਂ ਇਨ੍ਹਾਂ ਲੋਕਾਂ ਤੋਂ ਉਨ੍ਹਾਂ ਦੇ ਕੰਮ ਛੁਡਾਉਂਦੇ ਹੋ? ਤੁਸੀਂ ਜਾ ਕੇ ਆਪਣੇ-ਆਪਣੇ ਕੰਮ ਕਰੋ। ");
INSERT INTO pan_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","ਫ਼ਿਰਊਨ ਨੇ ਇਹ ਵੀ ਆਖਿਆ, ਵੇਖੋ ਹੁਣ ਉਸ ਧਰਤੀ ਦੇ ਲੋਕ ਬਹੁਤ ਹਨ ਪਰ ਤੁਸੀਂ ਉਨ੍ਹਾਂ ਨੂੰ ਉਨ੍ਹਾਂ ਦੀ ਬੇਗ਼ਾਰ ਤੋਂ ਅਰਾਮ ਕਰਾਉਂਦੇ ਹੋ। ");
INSERT INTO pan_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","ਉਸੇ ਦਿਨ ਫ਼ਿਰਊਨ ਨੇ ਲੋਕਾਂ ਤੋਂ ਬੇਗ਼ਾਰ ਕਰਾਉਣ ਵਾਲਿਆਂ ਅਤੇ ਉਨ੍ਹਾਂ ਦੇ ਗ਼ੁਲਾਮੀ ਕਰਾਉਣ ਵਾਲਿਆਂ ਨੂੰ ਇਹ ਹੁਕਮ ਦਿੱਤਾ ");
INSERT INTO pan_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","ਕਿ ਤੁਸੀਂ ਲੋਕਾਂ ਨੂੰ ਅੱਗੇ ਵਾਂਗੂੰ ਇੱਟਾਂ ਬਣਾਉਣ ਲਈ ਤੂੜੀ ਨਾ ਦਿਓ। ਉਹ ਆਪਣੇ ਲਈ ਆਪ ਜਾ ਕੇ ਤੂੜੀ ਇਕੱਠੀ ਕਰਨ ");
INSERT INTO pan_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","ਤੁਸੀਂ ਓਨ੍ਹੀਆਂ ਹੀ ਇੱਟਾਂ ਜਿੰਨੀਆਂ ਉਹ ਅੱਗੇ ਬਣਾਉਂਦੇ ਸਨ ਉਨ੍ਹਾਂ ਤੋਂ ਬਣਵਾਓ। ਤੁਸੀਂ ਉਨ੍ਹਾਂ ਵਿੱਚੋਂ ਕੁਝ ਨਾ ਘਟਾਓ ਕਿਉਂ ਜੋ ਉਹ ਵਿਹਲੇ ਰਹਿੰਦੇ ਹਨ ਇਸੇ ਲਈ ਉਹ ਇਹ ਦੁਹਾਈ ਦਿੰਦੇ ਹਨ ਕਿ ਅਸੀਂ ਜਾ ਕੇ ਆਪਣੇ ਪਰਮੇਸ਼ੁਰ ਲਈ ਬਲੀਆਂ ਚੜ੍ਹਾਈਏ। ");
INSERT INTO pan_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","ਉਹ ਸੇਵਾ ਉਨ੍ਹਾਂ ਮਨੁੱਖਾਂ ਉੱਤੇ ਹੋਰ ਭਾਰੀ ਕੀਤੀ ਜਾਵੇ ਤਾਂ ਜੋ ਉਹ ਕੰਮ ਵਿੱਚ ਲੱਗੇ ਰਹਿਣ ਅਤੇ ਝੂਠੀਆਂ ਗੱਲਾਂ ਉੱਤੇ ਧਿਆਨ ਨਾ ਦੇਣ। ");
INSERT INTO pan_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","ਤਦ ਲੋਕਾਂ ਤੋਂ ਬੇਗ਼ਾਰ ਕਰਾਉਣ ਵਾਲਿਆਂ ਅਤੇ ਉਨ੍ਹਾਂ ਤੋਂ ਗ਼ੁਲਾਮੀ ਕਰਾਉਣ ਵਾਲਿਆਂ ਨੇ ਬਾਹਰ ਜਾ ਕੇ ਲੋਕਾਂ ਨੂੰ ਆਖਿਆ ਕਿ ਫ਼ਿਰਊਨ ਇਸ ਤਰ੍ਹਾਂ ਆਖਦਾ ਹੈ ਕਿ ਮੈਂ ਤੁਹਾਨੂੰ ਤੂੜੀ ਨਹੀਂ ਦਿਆਂਗਾ। ");
INSERT INTO pan_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","ਤੁਸੀਂ ਜਾਓ ਅਤੇ ਆਪਣੇ ਲਈ ਤੂੜੀ ਜਿੱਥੋਂ ਤੁਹਾਨੂੰ ਲੱਭੇ ਆਪ ਲਿਆਓ। ਤੁਹਾਡੀ ਸੇਵਾ ਤੋਂ ਕੁਝ ਵੀ ਨਹੀਂ ਘਟੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","ਤਦ ਉਹ ਲੋਕ ਸਾਰੇ ਮਿਸਰ ਦੇਸ ਵਿੱਚ ਤੂੜੀ ਦੀ ਥਾਂ ਭੁੱਠਾ ਚੁਗਣ ਲਈ ਤਿੱਤਰ-ਬਿੱਤਰ ਹੋ ਗਏ। ");
INSERT INTO pan_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","ਬੇਗ਼ਾਰ ਕਰਾਉਣ ਵਾਲਿਆਂ ਨੇ ਜ਼ੋਰ ਕਰ ਕੇ ਆਖਿਆ, ਤੁਸੀਂ ਆਪਣਾ ਰੋਜ਼ ਦਾ ਕੰਮ ਰੋਜ਼ ਪੂਰਾ ਕਰੋ ਜਿਵੇਂ ਤੂੜੀ ਦੇ ਹੁੰਦਿਆਂ ਤੇ ਕਰਦੇ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","ਇਸਰਾਏਲੀਆਂ ਦੇ ਸਰਦਾਰਾਂ ਨੇ ਜਿਨ੍ਹਾਂ ਨੂੰ ਫ਼ਿਰਊਨ ਦੇ ਬੇਗ਼ਾਰ ਕਰਾਉਣ ਵਾਲਿਆਂ ਨੇ ਉਨ੍ਹਾਂ ਉੱਤੇ ਨਿਯੁਕਤ ਕੀਤਾ ਹੋਇਆ ਸੀ, ਮਾਰ ਖਾਧੀ। ਉਨ੍ਹਾਂ ਨੂੰ ਇਹ ਆਖਿਆ ਗਿਆ ਕਿ ਤੁਸੀਂ ਆਪਣਾ ਇੱਟਾਂ ਬਣਾਉਣ ਦਾ ਕੰਮ ਕੱਲ ਪਰਸੋਂ ਤੇ ਅੱਜ ਵੀ ਪੂਰਾ ਕਿਉਂ ਨਹੀਂ ਕੀਤਾ?। ");
INSERT INTO pan_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","ਤਦ ਇਸਰਾਏਲੀਆਂ ਦੇ ਸਰਦਾਰ ਅੰਦਰ ਆਏ ਅਤੇ ਫ਼ਿਰਊਨ ਕੋਲ ਦੁਹਾਈ ਦਿੱਤੀ ਕਿ ਤੁਸੀਂ ਆਪਣੇ ਦਾਸਾਂ ਨਾਲ ਅਜਿਹਾ ਕਿਉਂ ਕੀਤਾ? ");
INSERT INTO pan_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","ਤੁਹਾਡੇ ਦਾਸਾਂ ਨੂੰ ਤੂੜੀ ਨਹੀਂ ਦਿੱਤੀ ਜਾਂਦੀ ਅਤੇ ਸਾਨੂੰ ਆਖਦੇ ਹਨ, ਇੱਟਾਂ ਬਣਾਓ! ਵੇਖੋ, ਤੁਹਾਡੇ ਦਾਸਾਂ ਨੂੰ ਮਾਰ ਪੈਂਦੀ ਹੈ। ਦੋਸ਼ ਤੁਹਾਡੇ ਲੋਕਾਂ ਦਾ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","ਉਸ ਨੇ ਆਖਿਆ, ਤੁਸੀਂ ਆਲਸੀ ਹੋ, ਢਿੱਲੇ! ਇਸੇ ਕਰਕੇ ਤੁਸੀਂ ਆਖੀ ਜਾਂਦੇ ਹੋ, ਸਾਨੂੰ ਜਾਣ ਦੇ ਤਾਂ ਜੋ ਅਸੀਂ ਯਹੋਵਾਹ ਲਈ ਬਲੀਆਂ ਚੜ੍ਹਾਈਏ। ");
INSERT INTO pan_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","ਹੁਣ ਜਾਓ ਅਤੇ ਕੰਮ ਕਰੋ ਪਰ ਤੂੜੀ ਤੁਹਾਨੂੰ ਨਹੀਂ ਦਿੱਤੀ ਜਾਵੇਗੀ ਅਤੇ ਇੱਟਾਂ ਦਾ ਹਿਸਾਬ ਪੂਰਾ ਕਰਨਾ ਪਵੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","ਤਦ ਇਸਰਾਏਲੀਆਂ ਦੇ ਸਰਦਾਰਾਂ ਨੇ ਵੇਖ ਲਿਆ ਕਿ ਅਸੀਂ ਬੁਰੇ ਹਾਲ ਵਿੱਚ ਹਾਂ, ਜਦ ਆਖਿਆ ਜਾਂਦਾ ਹੈ, ਤੁਸੀਂ ਆਪਣੇ ਰੋਜ਼ ਦੇ ਇੱਟਾਂ ਦੇ ਕੰਮ ਵਿੱਚੋਂ ਕੁਝ ਨਾ ਘਟਾਓ। ");
INSERT INTO pan_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","ਜਦ ਉਹ ਫ਼ਿਰਊਨ ਕੋਲੋਂ ਬਾਹਰ ਨਿੱਕਲੇ ਤਦ ਮੂਸਾ ਅਤੇ ਹਾਰੂਨ ਨੂੰ ਜਿਹੜੇ ਉਨ੍ਹਾਂ ਦੇ ਮਿਲਣ ਨੂੰ ਰਾਹ ਵਿੱਚ ਖੜ੍ਹੇ ਸਨ, ਮਿਲੇ। ");
INSERT INTO pan_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","ਤਦ ਉਨ੍ਹਾਂ ਨੇ ਉਨ੍ਹਾਂ ਨੂੰ ਆਖਿਆ, ਯਹੋਵਾਹ ਤੁਹਾਨੂੰ ਵੇਖੇ ਤੇ ਨਿਆਂ ਕਰੇ ਕਿਉਂ ਜੋ ਤੁਸੀਂ ਸਾਡੀ ਬਾਸ਼ਨਾ ਫ਼ਿਰਊਨ ਦੇ ਅੱਗੇ ਅਤੇ ਉਸ ਦੇ ਸੇਵਕਾਂ ਦੇ ਅੱਗੇ ਗੰਦੀ ਬਣਾ ਦਿੱਤੀ ਹੈ ਅਤੇ ਸਾਨੂੰ ਜਾਨ ਤੋਂ ਮਾਰਨ ਲਈ ਉਨ੍ਹਾਂ ਦੇ ਹੱਥ ਵਿੱਚ ਤਲਵਾਰ ਦੇ ਦਿੱਤੀ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","ਫਿਰ ਮੂਸਾ ਯਹੋਵਾਹ ਵੱਲ ਮੁੜਿਆ ਅਤੇ ਆਖਿਆ, ਹੇ ਪ੍ਰਭੂ, ਤੂੰ ਕਿਉਂ ਇਸ ਪਰਜਾ ਉੱਤੇ ਬੁਰਿਆਈ ਆਉਣ ਦਿੱਤੀ ਅਤੇ ਤੂੰ ਮੈਨੂੰ ਕਿਉਂ ਭੇਜਿਆ? ");
INSERT INTO pan_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","ਕਿਉਂਕਿ ਜਿਸ ਵੇਲੇ ਤੋਂ ਮੈਂ ਤੇਰਾ ਨਾਮ ਲੈ ਕੇ ਫ਼ਿਰਊਨ ਨਾਲ ਗੱਲਾਂ ਕਰਨ ਲਈ ਆਇਆ ਤਦ ਤੋਂ ਹੀ ਉਸ ਨੇ ਇਸ ਪਰਜਾ ਨਾਲ ਬੁਰਿਆਈ ਕੀਤੀ ਅਤੇ ਤੂੰ ਵੀ ਆਪਣੀ ਪਰਜਾ ਨੂੰ ਛੁਟਕਾਰਾ ਨਾ ਦਿੱਤਾ। ");
INSERT INTO pan_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਆਖਿਆ, ਹੁਣ ਤੂੰ ਵੇਖੇਂਗਾ ਕਿ ਮੈਂ ਫ਼ਿਰਊਨ ਨਾਲ ਕੀ ਕਰਾਂਗਾ ਕਿਉਂ ਜੋ ਉਹ ਮੇਰੇ ਹੱਥ ਦੇ ਬਲ ਕਾਰਨ ਉਨ੍ਹਾਂ ਨੂੰ ਜਾਣ ਦੇਵੇਗਾ ਸਗੋਂ ਹੱਥ ਦੇ ਬਲ ਨਾਲ ਉਹ ਉਨ੍ਹਾਂ ਨੂੰ ਆਪਣੇ ਦੇਸ ਵਿੱਚੋਂ ਕੱਢ ਦੇਵੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","ਫਿਰ ਪਰਮੇਸ਼ੁਰ ਨੇ ਮੂਸਾ ਨਾਲ ਗੱਲ ਕੀਤੀ ਅਤੇ ਉਸ ਨੂੰ ਆਖਿਆ, ਮੈਂ ਯਹੋਵਾਹ ਹਾਂ ");
INSERT INTO pan_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","ਮੈਂ ਅਬਰਾਹਾਮ, ਇਸਹਾਕ ਅਤੇ ਯਾਕੂਬ ਨੂੰ ਸਰਬ ਸ਼ਕਤੀਮਾਨ ਪਰਮੇਸ਼ੁਰ ਦੇ ਨਾਮ ਉੱਤੇ ਦਰਸ਼ਣ ਦਿੱਤਾ ਪਰ ਮੈਂ ਆਪਣੇ ਯਹੋਵਾਹ ਨਾਮ ਨਾਲ ਉਨ੍ਹਾਂ ਉੱਤੇ ਪਰਗਟ ਨਹੀਂ ਹੋਇਆ। ");
INSERT INTO pan_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","ਮੈਂ ਉਨ੍ਹਾਂ ਨਾਲ ਆਪਣੇ ਨੇਮ ਵੀ ਕਾਇਮ ਕੀਤਾ ਤਾਂ ਜੋ ਮੈਂ ਉਹਨਾਂ ਨੂੰ ਕਨਾਨ ਦੇਸ ਦੇਵਾਂ ਅਰਥਾਤ ਉਹਨਾਂ ਦੀ ਮੁਸਾਫ਼ਰੀ ਦਾ ਦੇਸ ਜਿਸ ਵਿੱਚ ਉਹ ਪਰਦੇਸੀ ਰਹੇ। ");
INSERT INTO pan_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","ਮੈਂ ਇਸਰਾਏਲੀਆਂ ਦੇ ਹਾਉਂਕੇ ਵੀ ਸੁਣੇ ਜਿਨ੍ਹਾਂ ਨੂੰ ਮਿਸਰੀ ਗ਼ੁਲਾਮੀ ਵਿੱਚ ਰੱਖਦੇ ਹਨ ਅਤੇ ਮੈਂ ਆਪਣੇ ਨੇਮ ਨੂੰ ਚੇਤੇ ਕੀਤਾ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","ਇਸ ਲਈ ਇਸਰਾਏਲੀਆਂ ਨੂੰ ਆਖ, ਮੈਂ ਯਹੋਵਾਹ ਹਾਂ ਅਤੇ ਮੈਂ ਤੁਹਾਨੂੰ ਮਿਸਰੀਆਂ ਦੀ ਬੇਗ਼ਾਰ ਹੇਠੋਂ ਕੱਢ ਲਵਾਂਗਾ ਅਤੇ ਮੈਂ ਤੁਹਾਨੂੰ ਉਨ੍ਹਾਂ ਦੀ ਗ਼ੁਲਾਮੀ ਤੋਂ ਛੁਟਕਾਰਾ ਦਿਆਂਗਾ ਅਤੇ ਮੈਂ ਆਪਣੀ ਬਾਂਹ ਲੰਮੀ ਕਰ ਕੇ ਵੱਡੇ ਨਿਆਂਵਾਂ ਨਾਲ ਤੁਹਾਨੂੰ ਛੁਡਾਵਾਂਗਾ। ");
INSERT INTO pan_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","ਮੈਂ ਤੁਹਾਨੂੰ ਆਪਣੀ ਪਰਜਾ ਹੋਣ ਲਈ ਲਵਾਂਗਾ ਅਤੇ ਮੈਂ ਤੁਹਾਡਾ ਪਰਮੇਸ਼ੁਰ ਹੋਵਾਂਗਾ, ਤੁਸੀਂ ਜਾਣੋਗੇ ਕਿ ਮੈਂ ਯਹੋਵਾਹ ਤੁਹਾਡਾ ਪਰਮੇਸ਼ੁਰ ਹਾਂ, ਜਿਹੜਾ ਤੁਹਾਨੂੰ ਮਿਸਰੀਆਂ ਦੀ ਬੇਗ਼ਾਰ ਹੇਠੋਂ ਕੱਢ ਲਿਆਉਂਦਾ ਹਾਂ। ");
INSERT INTO pan_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","ਮੈਂ ਤੁਹਾਨੂੰ ਉਸ ਦੇਸ ਵਿੱਚ ਲਿਆਵਾਂਗਾ, ਜਿਸ ਦੇ ਦੇਣ ਦੀ ਮੈਂ ਅਬਰਾਹਾਮ, ਇਸਹਾਕ ਅਤੇ ਯਾਕੂਬ ਨਾਲ ਸਹੁੰ ਖਾਧੀ ਸੀ, ਮੈਂ ਤੁਹਾਨੂੰ ਉਹ ਮਿਲਖ਼ ਵਿੱਚ ਦਿਆਂਗਾ। ਮੈਂ ਯਹੋਵਾਹ ਹਾਂ। ");
INSERT INTO pan_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","ਉਪਰੰਤ ਮੂਸਾ ਨੇ ਇਸਰਾਏਲੀਆਂ ਨਾਲ ਉਸੇ ਤਰ੍ਹਾਂ ਹੀ ਗੱਲ ਕੀਤੀ ਪਰ ਉਨ੍ਹਾਂ ਨੇ ਆਤਮਾ ਦੇ ਦੁੱਖ ਅਤੇ ਗ਼ੁਲਾਮੀ ਦੀ ਸਖਤੀ ਦੇ ਕਾਰਨ ਮੂਸਾ ਦੀ ਨਾ ਸੁਣੀ। ");
INSERT INTO pan_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","ਤਦ ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨਾਲ ਗੱਲ ਕੀਤੀ ਕਿ ਜਾ ਅਤੇ ਮਿਸਰ ਦੇ ਰਾਜਾ ਫ਼ਿਰਊਨ ਨਾਲ ਗੱਲ ਕਰ ");
INSERT INTO pan_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","ਕਿ ਉਹ ਇਸਰਾਏਲੀਆਂ ਨੂੰ ਆਪਣੇ ਦੇਸ ਵਿੱਚੋਂ ਜਾਣ ਦੇਵੇ। ");
INSERT INTO pan_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","ਤਦ ਮੂਸਾ ਨੇ ਯਹੋਵਾਹ ਦੇ ਸਨਮੁਖ ਇਸ ਤਰ੍ਹਾਂ ਗੱਲ ਕੀਤੀ, ਵੇਖ, ਇਸਰਾਏਲੀਆਂ ਨੇ ਤਾਂ ਮੇਰੀ ਨਾ ਸੁਣੀ, ਤਦ ਫ਼ਿਰਊਨ ਕਿਵੇਂ ਮੇਰੀ ਸੁਣੇਗਾ, ਮੈਂ ਜਿਹੜਾ ਅਟਕ-ਅਟਕ ਕੇ ਬੋਲਣ ਵਾਲਾ ਹਾਂ? ");
INSERT INTO pan_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","ਫਿਰ ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਅਤੇ ਹਾਰੂਨ ਨਾਲ ਗੱਲ ਕੀਤੀ ਅਤੇ ਉਨ੍ਹਾਂ ਨੂੰ ਇਸਰਾਏਲੀਆਂ ਲਈ ਅਤੇ ਮਿਸਰ ਦੇ ਰਾਜਾ ਫ਼ਿਰਊਨ ਲਈ ਹੁਕਮ ਦਿੱਤਾ ਕਿ ਉਹ ਇਸਰਾਏਲੀਆਂ ਨੂੰ ਮਿਸਰ ਦੇਸ ਵਿੱਚੋਂ ਬਾਹਰ ਲੈ ਜਾਣ। ");
INSERT INTO pan_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","ਉਨ੍ਹਾਂ ਦੇ ਪੁਰਖਿਆਂ ਦੇ ਘਰਾਣਿਆਂ ਦੇ ਮੋਹਰੀ ਇਹ ਹਨ - ਰਊਬੇਨ ਇਸਰਾਏਲ ਦੇ ਪਹਿਲੌਠੇ ਦੇ ਪੁੱਤਰ ਹਨੋਕ ਅਤੇ ਪੱਲੂ, ਹਸਰੋਨ ਅਤੇ ਕਰਮੀ ਹਨ, ਇਹ ਰਊਬੇਨ ਦੀਆਂ ਕੁੱਲਾਂ ਹਨ। ");
INSERT INTO pan_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","ਸ਼ਿਮਓਨ ਦੇ ਪੁੱਤਰ ਯਮੂਏਲ ਯਾਮੀਨ ਓਹਦ ਯਾਕੀਨ ਸੋਹਰ ਅਤੇ ਸ਼ਾਊਲ ਕਨਾਨੀ ਔਰਤ ਦਾ ਪੁੱਤਰ, ਇਹ ਸ਼ਿਮਓਨ ਦੀਆਂ ਮੂੰਹੀਆਂ ਹਨ। ");
INSERT INTO pan_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","ਲੇਵੀ ਦੇ ਪੁੱਤਰਾਂ ਦੇ ਨਾਮ ਉਨ੍ਹਾਂ ਦੀ ਕੁਲਪੱਤ੍ਰੀ ਅਨੁਸਾਰ ਇਹ ਹਨ - ਗੇਰਸ਼ੋਨ, ਕਹਾਥ, ਮਰਾਰੀ ਅਤੇ ਲੇਵੀ ਦੇ ਜੀਵਨ ਦੇ ਸਾਲ, ਇੱਕ ਸੌ ਸੈਂਤੀ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","ਗੇਰਸ਼ੋਨ ਦੇ ਪੁੱਤਰ ਲਿਬਨੀ ਅਤੇ ਸ਼ਿਮਈ ਆਪਣੀਆਂ ਮੂੰਹੀਆਂ ਦੇ ਅਨੁਸਾਰ ਹਨ। ");
INSERT INTO pan_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","ਕਹਾਥ ਦੇ ਪੁੱਤਰ ਅਮਰਾਮ, ਯਿਸਹਾਰ, ਹਬਰੋਨ ਅਤੇ ਉੱਜ਼ੀਏਲ ਹਨ ਅਤੇ ਕਹਾਥ ਦੇ ਜੀਵਨ ਦੇ ਸਾਲ ਇੱਕ ਸੌ ਤੇਂਤੀ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","ਮਰਾਰੀ ਦੇ ਪੁੱਤਰ ਮਹਲੀ ਅਤੇ ਮੂਸ਼ੀ ਹਨ। ਲੇਵੀ ਦੀਆਂ ਮੂੰਹੀਆਂ ਉਨ੍ਹਾਂ ਦੀ ਕੁਲਪੱਤ੍ਰੀ ਅਨੁਸਾਰ ਇਹ ਹਨ। ");
INSERT INTO pan_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","ਅਮਰਾਮ ਨੇ ਆਪਣੀ ਫੁੱਫੀ ਯੋਕਬਦ ਨੂੰ ਵਿਆਹ ਲਿਆ ਅਤੇ ਉਹ ਉਸ ਦੇ ਲਈ ਹਾਰੂਨ ਅਤੇ ਮੂਸਾ ਨੂੰ ਜਨਮ ਦਿੱਤਾ ਅਤੇ ਅਮਰਾਮ ਦੇ ਜੀਵਨ ਦੇ ਸਾਲ ਇੱਕ ਸੌ ਸੈਂਤੀ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","ਯਿਸਹਾਰ ਦੇ ਪੁੱਤਰ ਕੋਰਹ ਅਤੇ ਨਫ਼ਗ ਅਤੇ ਜ਼ਿਕਰੀ ਹਨ। ");
INSERT INTO pan_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","ਉੱਜ਼ੀਏਲ ਦੇ ਪੁੱਤਰ ਮੀਸ਼ਾਏਲ ਅਤੇ ਅਲਸਾਫਾਨ ਅਤੇ ਸਿਤਰੀ ਹਨ। ");
INSERT INTO pan_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","ਹਾਰੂਨ ਨੇ ਨਹਸ਼ੋਨ ਦੀ ਭੈਣ ਅੰਮੀਨਾਦਾਬ ਦੀ ਧੀ, ਅਲੀਸਬਾ ਨੂੰ ਵਿਆਹ ਲਿਆ ਅਤੇ ਉਸ ਨੇ ਨਾਦਾਬ, ਅਬੀਹੂ, ਅਲਆਜ਼ਾਰ ਅਤੇ ਈਥਾਮਾਰ ਨੂੰ ਉਸ ਲਈ ਜਨਮ ਦਿੱਤਾ। ");
INSERT INTO pan_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","ਕੋਰਹ ਦੇ ਪੁੱਤਰ ਅੱਸੀਰ, ਅਲਕਾਨਾਹ ਅਤੇ ਅਬੀਆਸਾਫ਼ ਹਨ ਇਹ ਕੋਰਹ ਦੀਆਂ ਮੂੰਹੀਆਂ ਹਨ। ");
INSERT INTO pan_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","ਹਾਰੂਨ ਦੇ ਪੁੱਤਰ ਅਲਆਜ਼ਾਰ ਨੇ ਫੂਟੀਏਲ ਦੀਆਂ ਧੀਆਂ ਵਿੱਚੋਂ ਇੱਕ ਨੂੰ ਵਿਆਹ ਲਿਆ ਅਤੇ ਉਹ ਉਸ ਦੇ ਲਈ ਫ਼ੀਨਹਾਸ ਨੂੰ ਜਣੀ। ਇਹ ਲੇਵੀਆਂ ਦੇ ਪੁਰਖਿਆਂ ਦੇ ਮੋਹਰੀ ਆਪਣੀਆਂ ਮੂੰਹੀਆਂ ਦੇ ਅਨੁਸਾਰ ਹਨ। ");
INSERT INTO pan_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","ਹਾਰੂਨ ਅਤੇ ਮੂਸਾ ਉਹ ਹਨ, ਜਿਨ੍ਹਾਂ ਨੂੰ ਯਹੋਵਾਹ ਨੇ ਆਖਿਆ ਸੀ ਕਿ ਇਸਰਾਏਲੀਆਂ ਨੂੰ ਉਨ੍ਹਾਂ ਦੀਆਂ ਸੈਨਾਂ ਅਨੁਸਾਰ ਮਿਸਰ ਦੇਸ ਤੋਂ ਕੱਢ ਲਿਆਓ। ");
INSERT INTO pan_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","ਇਹ ਉਹ ਹਨ ਜਿਨ੍ਹਾਂ ਨੇ ਮਿਸਰ ਦੇ ਰਾਜਾ ਫ਼ਿਰਊਨ ਨਾਲ ਗੱਲਾਂ ਕੀਤੀਆਂ ਕਿ ਉਹ ਇਸਰਾਏਲੀਆਂ ਨੂੰ ਮਿਸਰ ਤੋਂ ਕੱਢ ਲੈਣ। ਇਹ ਉਹ ਮੂਸਾ ਅਤੇ ਹਾਰੂਨ ਹਨ। ");
INSERT INTO pan_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","ਤਦ ਅਜਿਹਾ ਹੋਇਆ ਕਿ ਜਿਸ ਦਿਨ ਯਹੋਵਾਹ ਨੇ ਮਿਸਰ ਦੇਸ ਵਿੱਚ ਮੂਸਾ ਨਾਲ ਗੱਲ ਕੀਤੀ ");
INSERT INTO pan_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","ਤਦ ਯਹੋਵਾਹ ਮੂਸਾ ਨੂੰ ਇਸ ਤਰ੍ਹਾਂ ਬੋਲਿਆ ਕਿ ਮੈਂ ਯਹੋਵਾਹ ਹਾਂ, ਮਿਸਰ ਦੇ ਰਾਜਾ ਫ਼ਿਰਊਨ ਨਾਲ ਉਹ ਸਾਰੀਆਂ ਗੱਲਾਂ ਕਰ, ਜਿਹੜੀਆਂ ਮੈਂ ਤੈਨੂੰ ਆਖੀਆਂ ਹਨ। ");
INSERT INTO pan_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","ਫਿਰ ਮੂਸਾ ਨੇ ਯਹੋਵਾਹ ਦੇ ਸਨਮੁਖ ਆਖਿਆ, ਵੇਖ, ਮੈਂ ਅਟਕ-ਅਟਕ ਕੇ ਬੋਲਣ ਵਾਲਾ ਹਾਂ। ਫ਼ਿਰਊਨ ਮੇਰੀ ਕਿਵੇਂ ਸੁਣੇਗਾ? ");
INSERT INTO pan_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਆਖਿਆ, ਵੇਖ, ਮੈਂ ਤੈਨੂੰ ਫ਼ਿਰਊਨ ਲਈ ਪਰਮੇਸ਼ੁਰ ਵਰਗਾ ਠਹਿਰਾਇਆ ਹੈ ਅਤੇ ਤੇਰਾ ਭਰਾ ਹਾਰੂਨ ਤੇਰੇ ਲਈ ਨਬੀ ਹੋਵੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","ਤੂੰ ਉਹ ਸਾਰੀਆਂ ਗੱਲਾਂ ਜਿਨ੍ਹਾਂ ਦਾ ਮੈਂ ਤੈਨੂੰ ਹੁਕਮ ਦਿੱਤਾ ਹੈ ਕਰੀਂ ਅਤੇ ਤੇਰਾ ਭਰਾ ਹਾਰੂਨ ਫ਼ਿਰਊਨ ਨਾਲ ਗੱਲਾਂ ਕਰੇਗਾ ਕਿ ਉਹ ਇਸਰਾਏਲੀਆਂ ਨੂੰ ਆਪਣੇ ਦੇਸ ਤੋਂ ਜਾਣ ਦੇਵੇ ");
INSERT INTO pan_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","ਮੈਂ ਫ਼ਿਰਊਨ ਦੇ ਮਨ ਨੂੰ ਕਠੋਰ ਹੋਣ ਦੇਵਾਂਗਾ, ਆਪਣੇ ਨਿਸ਼ਾਨਾਂ ਅਤੇ ਅਚਰਜ਼ ਕੰਮਾਂ ਨੂੰ ਮਿਸਰ ਦੇਸ ਵਿੱਚ ਵਧਾਵਾਂਗਾ। ");
INSERT INTO pan_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","ਪਰ ਫ਼ਿਰਊਨ ਤੁਹਾਡੀ ਨਹੀਂ ਸੁਣੇਗਾ ਅਤੇ ਮੈਂ ਆਪਣਾ ਹੱਥ ਮਿਸਰ ਉੱਤੇ ਪਾਵਾਂਗਾ ਅਤੇ ਆਪਣੀਆਂ ਸੈਨਾਂ ਅਰਥਾਤ ਆਪਣੀ ਪਰਜਾ ਇਸਰਾਏਲ ਨੂੰ ਵੱਡਿਆਂ ਨਿਆਂਵਾਂ ਨਾਲ ਮਿਸਰ ਦੇਸ ਤੋਂ ਬਾਹਰ ਲੈ ਆਵਾਂਗਾ। ");
INSERT INTO pan_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","ਤਦ ਮਿਸਰੀ ਜਾਣਨਗੇ ਕਿ ਮੈਂ ਯਹੋਵਾਹ ਹਾਂ, ਜਦ ਮੈਂ ਮਿਸਰ ਉੱਤੇ ਆਪਣਾ ਹੱਥ ਪਸਾਰਾਂਗਾ ਅਤੇ ਇਸਰਾਏਲੀਆਂ ਨੂੰ ਉਨ੍ਹਾਂ ਵਿੱਚੋਂ ਕੱਢ ਲਿਆਵਾਂਗਾ। ");
INSERT INTO pan_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","ਤਦ ਮੂਸਾ ਅਤੇ ਹਾਰੂਨ ਨੇ ਉਸੇ ਤਰ੍ਹਾਂ ਹੀ ਕੀਤਾ ਜਿਵੇਂ ਯਹੋਵਾਹ ਨੇ ਉਨ੍ਹਾਂ ਨੂੰ ਹੁਕਮ ਦਿੱਤਾ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","ਜਿਸ ਸਮੇਂ ਉਨ੍ਹਾਂ ਦੋਹਾਂ ਨੇ ਫ਼ਿਰਊਨ ਨਾਲ ਗੱਲ ਕੀਤੀ, ਮੂਸਾ ਅੱਸੀ ਸਾਲਾਂ ਦਾ ਅਤੇ ਹਾਰੂਨ ਤਰਿਆਸੀ ਸਾਲਾਂ ਦਾ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","ਤਦ ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਅਤੇ ਹਾਰੂਨ ਨੂੰ ਇਸ ਤਰ੍ਹਾਂ ਆਖਿਆ, ");
INSERT INTO pan_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","ਜਦ ਫ਼ਿਰਊਨ ਤੁਹਾਡੇ ਨਾਲ ਇਹ ਗੱਲ ਕਰੇ ਕਿ ਤੁਸੀਂ ਕੋਈ ਅਚਰਜ਼ ਕੰਮ ਵਿਖਾਓ ਤਦ ਤੂੰ ਹਾਰੂਨ ਨੂੰ ਆਖੀਂ ਕਿ ਤੂੰ ਆਪਣੀ ਲਾਠੀ ਲੈ ਕੇ ਫ਼ਿਰਊਨ ਅੱਗੇ ਸੁੱਟ ਦੇ ਤਾਂ ਜੋ ਉਹ ਇੱਕ ਸਰਾਲ ਹੋ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","ਮੂਸਾ ਅਤੇ ਹਾਰੂਨ ਫ਼ਿਰਊਨ ਕੋਲ ਗਏ ਅਤੇ ਉਸੇ ਤਰ੍ਹਾਂ ਕੀਤਾ ਜਿਵੇਂ ਯਹੋਵਾਹ ਨੇ ਉਨ੍ਹਾਂ ਨੂੰ ਹੁਕਮ ਦਿੱਤਾ ਸੀ। ਹਾਰੂਨ ਨੇ ਆਪਣੀ ਲਾਠੀ ਫ਼ਿਰਊਨ ਦੇ ਅੱਗੇ ਅਤੇ ਉਸ ਦੇ ਸੇਵਕਾਂ ਦੇ ਅੱਗੇ ਸੁੱਟੀ, ਤਦ ਉਹ ਸਰਾਲ ਬਣ ਗਈ। ");
INSERT INTO pan_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","ਫਿਰ ਫ਼ਿਰਊਨ ਨੇ ਵੀ ਸਿਆਣਿਆਂ ਅਤੇ ਮੰਤਰੀਆਂ ਨੂੰ ਸੱਦਿਆ ਤਦ ਮਿਸਰ ਦੇ ਜਾਦੂਗਰਾਂ ਨੇ ਵੀ ਆਪਣੇ ਜੰਤਰਾਂ-ਮੰਤਰਾਂ ਨਾਲ ਉਸੇ ਤਰ੍ਹਾਂ ਹੀ ਕੀਤਾ। ");
INSERT INTO pan_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","ਉਨ੍ਹਾਂ ਸਭਨਾਂ ਨੇ ਆਪਣੀਆਂ-ਆਪਣੀਆਂ ਲਾਠੀਆਂ ਸੁੱਟੀਆਂ ਅਤੇ ਉਹ ਸਰਾਲਾਂ ਹੋ ਗਈਆਂ ਪਰ ਹਾਰੂਨ ਦੀ ਲਾਠੀ ਉਨ੍ਹਾਂ ਦੀਆਂ ਲਾਠੀਆਂ ਨੂੰ ਨਿਗਲ ਗਈ। ");
INSERT INTO pan_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","ਫ਼ਿਰਊਨ ਦਾ ਮਨ ਕਠੋਰ ਹੋ ਗਿਆ ਅਤੇ ਉਸ ਨੇ ਉਨ੍ਹਾਂ ਦੀ ਨਾ ਸੁਣੀ ਜਿਵੇਂ ਯਹੋਵਾਹ ਨੇ ਗੱਲ ਕੀਤੀ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","ਫਿਰ ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਆਖਿਆ, ਫ਼ਿਰਊਨ ਦਾ ਮਨ ਸਖ਼ਤ ਹੋ ਗਿਆ ਹੈ, ਜੋ ਉਹ ਲੋਕਾਂ ਨੂੰ ਨਹੀਂ ਜਾਣ ਦਿੰਦਾ। ");
INSERT INTO pan_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","ਤੂੰ ਸਵੇਰੇ ਫ਼ਿਰਊਨ ਕੋਲ ਜਾ। ਵੇਖ, ਉਹ ਪਾਣੀ ਵੱਲ ਬਾਹਰ ਜਾਂਦਾ ਹੈ। ਤੂੰ ਨਦੀ ਦੇ ਕੰਢੇ ਉਸ ਦੇ ਮਿਲਣ ਲਈ ਖੜ੍ਹਾ ਹੋ ਜਾਵੀਂ ਅਤੇ ਉਹ ਲਾਠੀ ਜਿਹੜੀ ਸੱਪ ਬਣ ਗਈ ਸੀ, ਆਪਣੇ ਹੱਥ ਵਿੱਚ ਲਵੀਂ ");
INSERT INTO pan_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","ਤੂੰ ਉਹ ਨੂੰ ਆਖੀਂ, ਯਹੋਵਾਹ ਇਬਰਾਨੀਆਂ ਦੇ ਪਰਮੇਸ਼ੁਰ ਨੇ ਮੈਨੂੰ ਤੇਰੇ ਕੋਲ ਇਹ ਕਹਿ ਕੇ ਭੇਜਿਆ ਹੈ ਕਿ ਮੇਰੀ ਪਰਜਾ ਨੂੰ ਜਾਣ ਦੇ ਤਾਂ ਜੋ ਉਹ ਉਜਾੜ ਵਿੱਚ ਮੇਰੀ ਉਪਾਸਨਾ ਕਰੇ ਅਤੇ ਵੇਖ, ਹੁਣ ਤੱਕ ਤੂੰ ਮੇਰੀ ਨਹੀਂ ਸੁਣੀ। ");
INSERT INTO pan_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","ਯਹੋਵਾਹ ਇਸ ਤਰ੍ਹਾਂ ਆਖਦਾ ਹੈ ਕਿ ਤੂੰ ਇਸ ਤੋਂ ਜਾਣੇਂਗਾ ਕਿ ਮੈਂ ਯਹੋਵਾਹ ਹਾਂ, ਵੇਖ, ਮੈਂ ਇਹ ਲਾਠੀ ਜਿਹੜੀ ਮੇਰੇ ਹੱਥ ਵਿੱਚ ਹੈ, ਪਾਣੀਆਂ ਉੱਤੇ ਜਿਹੜੇ ਨਦੀ ਵਿੱਚ ਹਨ, ਮਾਰਾਂਗਾ ਅਤੇ ਉਹ ਲਹੂ ਹੋ ਜਾਣਗੇ। ");
INSERT INTO pan_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","ਮੱਛੀਆਂ ਜਿਹੜੀਆਂ ਨਦੀ ਵਿੱਚ ਹਨ, ਮਰ ਜਾਣਗੀਆਂ ਅਤੇ ਨਦੀ ਤੋਂ ਬਦਬੂ ਆਵੇਗੀ ਅਤੇ ਮਿਸਰੀ ਨਦੀ ਦੇ ਪਾਣੀ ਨੂੰ ਪੀਣ ਤੋਂ ਨਫ਼ਰਤ ਕਰਨਗੇ। ");
INSERT INTO pan_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","ਫਿਰ ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਆਖਿਆ, ਹਾਰੂਨ ਨੂੰ ਆਖ ਕਿ ਆਪਣੀ ਲਾਠੀ ਲਵੇ ਅਤੇ ਆਪਣੇ ਹੱਥ ਮਿਸਰ ਦੇ ਪਾਣੀਆਂ ਉੱਤੇ ਅਰਥਾਤ ਉਨ੍ਹਾਂ ਦੀਆਂ ਨਹਿਰਾਂ ਉੱਤੇ, ਉਨ੍ਹਾਂ ਦੇ ਦਰਿਆਵਾਂ ਉੱਤੇ, ਉਨ੍ਹਾਂ ਦੇ ਤਲਾਬਾਂ ਉੱਤੇ ਅਤੇ ਉਨ੍ਹਾਂ ਦੇ ਪਾਣੀਆਂ ਦੇ ਸਾਰੇ ਭੰਡਾਰਾਂ ਉੱਤੇ ਪਸਾਰੇ ਤਾਂ ਜੋ ਉਹ ਲਹੂ ਹੋ ਜਾਣ ਅਤੇ ਸਾਰੇ ਮਿਸਰ ਦੇਸ ਵਿੱਚ ਲੱਕੜੀ ਅਤੇ ਪੱਥਰ ਦੇ ਭਾਂਡਿਆਂ ਵਿੱਚ ਲਹੂ ਹੋ ਜਾਵੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","ਤਦ ਮੂਸਾ ਅਤੇ ਹਾਰੂਨ ਨੇ ਉਸੇ ਤਰ੍ਹਾਂ ਹੀ ਕੀਤਾ ਜਿਵੇਂ ਯਹੋਵਾਹ ਨੇ ਹੁਕਮ ਦਿੱਤਾ ਸੀ ਤਾਂ ਉਸ ਨੇ ਲਾਠੀ ਉਤਾਹਾਂ ਚੁੱਕ ਕੇ ਫ਼ਿਰਊਨ ਦੀਆਂ ਅੱਖਾਂ ਦੇ ਅੱਗੇ ਅਤੇ ਉਸ ਦੇ ਸੇਵਕਾਂ ਦੀਆਂ ਅੱਖਾਂ ਦੇ ਅੱਗੇ ਨਦੀ ਦੇ ਪਾਣੀਆਂ ਉੱਤੇ ਮਾਰੀ, ਤਾਂ ਸਾਰੇ ਪਾਣੀ ਜਿਹੜੇ ਨਦੀ ਵਿੱਚ ਸਨ ਲਹੂ ਬਣ ਗਏ। ");
INSERT INTO pan_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","ਮੱਛੀਆਂ ਜਿਹੜੀਆਂ ਨਦੀ ਵਿੱਚ ਸਨ, ਮਰ ਗਈਆਂ ਅਤੇ ਦਰਿਆ ਤੋਂ ਬਦਬੂ ਆਈ ਅਤੇ ਮਿਸਰੀ ਦਰਿਆ ਦਾ ਪਾਣੀ ਪੀ ਨਹੀਂ ਸਕਦੇ ਸਨ ਅਤੇ ਮਿਸਰ ਦੇ ਸਾਰੇ ਦੇਸ ਵਿੱਚ ਲਹੂ ਹੋ ਗਿਆ। ");
INSERT INTO pan_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","ਤਦ ਮਿਸਰ ਦੇ ਜਾਦੂਗਰਾਂ ਨੇ ਆਪਣੇ ਜੰਤਰਾਂ-ਮੰਤਰਾਂ ਨਾਲ ਉਸੇ ਤਰ੍ਹਾਂ ਹੀ ਕੀਤਾ ਪਰ ਫ਼ਿਰਊਨ ਦਾ ਮਨ ਕਠੋਰ ਹੋ ਗਿਆ ਜੋ ਉਸ ਨੇ ਉਨ੍ਹਾਂ ਦੀ ਨਾ ਸੁਣੀ, ਜਿਵੇਂ ਯਹੋਵਾਹ ਨੇ ਆਖਿਆ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","ਤਦ ਫ਼ਿਰਊਨ ਮੁੜ ਕੇ ਆਪਣੇ ਮਹਿਲ ਚਲਾ ਗਿਆ ਅਤੇ ਇਸ ਗੱਲ ਉੱਤੇ ਵੀ ਆਪਣਾ ਮਨ ਨਾ ਲਾਇਆ। ");
INSERT INTO pan_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","ਤਦ ਸਾਰੇ ਮਿਸਰੀ ਨਦੀ ਦੇ ਆਲੇ-ਦੁਆਲੇ ਪੀਣ ਦੇ ਪਾਣੀ ਲਈ ਪੁੱਟਣ ਲੱਗੇ ਕਿਉਂ ਜੋ ਉਹ ਨਦੀ ਦਾ ਪਾਣੀ ਨਾ ਪੀ ਸਕੇ ");
INSERT INTO pan_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","ਸੱਤ ਦਿਨ ਪੂਰੇ ਹੋਏ, ਉਸ ਦੇ ਬਾਅਦ ਯਹੋਵਾਹ ਨੇ ਨਦੀ ਨੂੰ ਮਾਰਿਆ। ");
INSERT INTO pan_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","ਫਿਰ ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਆਖਿਆ, ਫ਼ਿਰਊਨ ਕੋਲ ਜਾ ਕੇ ਉਸ ਨੂੰ ਆਖ ਕਿ ਯਹੋਵਾਹ ਇਸ ਤਰ੍ਹਾਂ ਆਖਦਾ ਹੈ, ਮੇਰੀ ਪਰਜਾ ਨੂੰ ਜਾਣ ਦੇ ਤਾਂ ਜੋ ਉਹ ਮੇਰੀ ਉਪਾਸਨਾ ਕਰੇ ");
INSERT INTO pan_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","ਜੇ ਤੂੰ ਉਨ੍ਹਾਂ ਦੇ ਭੇਜਣ ਤੋਂ ਮੁੱਕਰ ਜਾਵੇ ਤਾਂ ਵੇਖ, ਮੈਂ ਤੇਰੀਆਂ ਸਾਰੀਆਂ ਹੱਦਾਂ ਨੂੰ ਡੱਡੂਆਂ ਨਾਲ ਮਾਰਾਂਗਾ। ");
INSERT INTO pan_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","ਨਦੀ ਡੱਡੂਆਂ ਦੇ ਝੁੰਡਾਂ ਨਾਲ ਭਰ ਜਾਵੇਗੀ ਅਤੇ ਉਹ ਚੜ੍ਹਨਗੇ ਅਤੇ ਤੇਰੇ ਮਹਿਲ ਵਿੱਚ, ਤੇਰੇ ਸੌਣ ਦੇ ਬਿਸਤਰੇ ਵਿੱਚ, ਤੇਰੀ ਸੇਜ਼ ਉੱਤੇ, ਤੇਰੇ ਟਹਿਲੂਆਂ ਦੇ ਘਰਾਂ ਵਿੱਚ, ਤੇਰੀ ਪਰਜਾ ਵਿੱਚ, ਤੇਰੇ ਤੰਦੂਰਾਂ ਵਿੱਚ, ਅਤੇ ਤੇਰੇ ਗੁੰਨ੍ਹਣ ਦੀਆਂ ਪਰਾਤਾਂ ਵਿੱਚ ਆਉਣਗੇ। ");
INSERT INTO pan_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","ਡੱਡੂ ਤੇਰੇ ਉੱਤੇ, ਤੇਰੀ ਪਰਜਾ ਉੱਤੇ ਅਤੇ ਤੇਰੇ ਸਾਰੇ ਸੇਵਕਾਂ ਉੱਤੇ ਚੜ੍ਹਨਗੇ। ਫਿਰ ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਆਖਿਆ, ਹਾਰੂਨ ਨੂੰ ਆਖ ਕਿ ");
INSERT INTO pan_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","ਉਹ ਆਪਣਾ ਹੱਥ ਆਪਣੀ ਲਾਠੀ ਨਾਲ ਨਦੀਆਂ ਉੱਤੇ, ਦਰਿਆਵਾਂ ਉੱਤੇ ਅਤੇ ਤਲਾਬਾਂ ਉੱਤੇ ਪਸਾਰੇ ਅਤੇ ਡੱਡੂਆਂ ਨੂੰ ਮਿਸਰ ਦੇਸ ਉੱਤੇ ਚੜ੍ਹਾ ਦੇਵੇ। ");
INSERT INTO pan_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","ਤਦ ਹਾਰੂਨ ਨੇ ਆਪਣਾ ਹੱਥ ਮਿਸਰ ਦੇ ਪਾਣੀਆਂ ਉੱਤੇ ਪਸਾਰਿਆ ਤਦ ਡੱਡੂ ਚੜ੍ਹ ਆਏ ਅਤੇ ਮਿਸਰ ਦੇਸ ਨੂੰ ਭਰ ਦਿੱਤਾ। ");
INSERT INTO pan_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","ਤਦ ਜਾਦੂਗਰਾਂ ਨੇ ਆਪਣੇ ਜੰਤਰਾਂ-ਮੰਤਰਾਂ ਨਾਲ ਉਸੇ ਤਰ੍ਹਾਂ ਹੀ ਕੀਤਾ ਅਤੇ ਮਿਸਰ ਦੇਸ ਉੱਤੇ ਡੱਡੂ ਲੈ ਆਏ। ");
INSERT INTO pan_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","ਤਦ ਫ਼ਿਰਊਨ ਨੇ ਮੂਸਾ ਅਤੇ ਹਾਰੂਨ ਨੂੰ ਬੁਲਾ ਕੇ ਆਖਿਆ, ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਬੇਨਤੀ ਕਰੋ ਤਾਂ ਜੋ ਉਹ ਡੱਡੂਆਂ ਨੂੰ ਮੇਰੇ ਤੋਂ ਅਤੇ ਮੇਰੀ ਪਰਜਾ ਤੋਂ ਦੂਰ ਕਰ ਦੇਵੇ। ਮੈਂ ਜ਼ਰੂਰ ਲੋਕਾਂ ਨੂੰ ਜਾਣ ਦੇਵਾਂਗਾ ਤਾਂ ਜੋ ਉਹ ਯਹੋਵਾਹ ਲਈ ਬਲੀ ਚੜ੍ਹਾਉਣ। ");
INSERT INTO pan_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","ਤਦ ਮੂਸਾ ਨੇ ਫ਼ਿਰਊਨ ਨੂੰ ਆਖਿਆ, ਕਿਰਪਾ ਕਰ ਕੇ ਮੈਨੂੰ ਦੱਸੋ ਕਿ ਮੈਂ ਕਦ ਤੋਂ ਤੁਹਾਡੇ ਅਤੇ ਤੁਹਾਡੇ ਸੇਵਕਾਂ ਅਤੇ ਤੁਹਾਡੀ ਪਰਜਾ ਲਈ ਬੇਨਤੀ ਕਰਾਂ ਤਾਂ ਜੋ ਡੱਡੂ ਤੁਹਾਡੇ ਤੋਂ ਅਤੇ ਤੁਹਾਡੇ ਘਰਾਂ ਤੋਂ ਹਟਾਏ ਜਾਣ ਅਤੇ ਨੀਲ ਨਦੀ ਦੇ ਵਿੱਚ ਹੀ ਰਹਿਣ? ");
INSERT INTO pan_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","ਉਸ ਨੇ ਆਖਿਆ ਕੱਲ ਤੋਂ। ਤਦ ਉਸ ਨੇ ਆਖਿਆ, ਤੁਹਾਡੇ ਕਹਿਣ ਦੇ ਅਨੁਸਾਰ ਹੀ ਹੋਵੇਗਾ ਤਾਂ ਜੋ ਤੁਸੀਂ ਜਾਣੋ ਕਿ ਸਾਡੇ ਪਰਮੇਸ਼ੁਰ ਯਹੋਵਾਹ ਵਰਗਾ ਕੋਈ ਨਹੀਂ। ");
INSERT INTO pan_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","ਡੱਡੂ ਤੁਹਾਡੇ ਤੋਂ, ਤੁਹਾਡੇ ਘਰਾਂ ਤੋਂ, ਤੁਹਾਡੇ ਟਹਿਲੂਆਂ ਤੋਂ ਅਤੇ ਤੁਹਾਡੀ ਪਰਜਾ ਤੋਂ ਚੱਲਦੇ ਹੋਣਗੇ। ਉਹ ਸਿਰਫ਼ ਨਦੀ ਵਿੱਚ ਹੀ ਰਹਿਣਗੇ। ");
INSERT INTO pan_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","ਤਦ ਮੂਸਾ ਅਤੇ ਹਾਰੂਨ ਫ਼ਿਰਊਨ ਕੋਲੋਂ ਬਾਹਰ ਨੂੰ ਗਏ ਅਤੇ ਮੂਸਾ ਨੇ ਉਨ੍ਹਾਂ ਡੱਡੂਆਂ ਦੇ ਬਾਰੇ ਜਿਹੜੇ ਉਹ ਫ਼ਿਰਊਨ ਉੱਤੇ ਚੜ੍ਹਾ ਲਿਆਇਆ ਸੀ, ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਦੁਹਾਈ ਦਿੱਤੀ। ");
INSERT INTO pan_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","ਤਦ ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਦੇ ਕਹਿਣ ਦੇ ਅਨੁਸਾਰ ਕੀਤਾ ਅਤੇ ਡੱਡੂ ਘਰਾਂ, ਵੇਹੜਿਆਂ ਅਤੇ ਖੇਤਾਂ ਵਿੱਚੋਂ ਮੁੱਕ ਗਏ। ");
INSERT INTO pan_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","ਤਦ ਉਨ੍ਹਾਂ ਨੇ ਉਹ ਇਕੱਠੇ ਕਰ ਕੇ ਢੇਰਾਂ ਦੇ ਢੇਰ ਲਾ ਦਿੱਤੇ ਤੇ ਧਰਤੀ ਉੱਤੇ ਬਦਬੂ ਫੈਲ ਗਈ। ");
INSERT INTO pan_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","ਪਰ ਜਿਵੇਂ ਯਹੋਵਾਹ ਬੋਲਿਆ ਸੀ, ਜਦ ਫ਼ਿਰਊਨ ਨੇ ਵੇਖਿਆ ਕਿ ਅਰਾਮ ਹੋ ਗਿਆ ਹੈ ਤਦ ਆਪਣਾ ਮਨ ਪੱਥਰ ਕਰ ਲਿਆ ਅਤੇ ਉਨ੍ਹਾਂ ਦੀ ਨਾ ਸੁਣੀ। ");
INSERT INTO pan_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","ਤਦ ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਆਖਿਆ ਕਿ ਹਾਰੂਨ ਨੂੰ ਆਖ ਕਿ ਉਹ ਆਪਣੀ ਲਾਠੀ ਵਧਾ ਕੇ ਧਰਤੀ ਦੀ ਧੂੜ ਨੂੰ ਮਾਰੇ ਤਾਂ ਜੋ ਉਹ ਸਾਰੇ ਮਿਸਰ ਦੇਸ ਵਿੱਚ ਜੂੰਆਂ ਬਣ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","ਉਨ੍ਹਾਂ ਨੇ ਉਸੇ ਤਰ੍ਹਾਂ ਹੀ ਕੀਤਾ ਅਤੇ ਹਾਰੂਨ ਨੇ ਆਪਣੀ ਲਾਠੀ ਲੈ ਕੇ ਆਪਣਾ ਹੱਥ ਪਸਾਰਿਆ ਅਤੇ ਧਰਤੀ ਦੀ ਧੂੜ ਨੂੰ ਮਾਰਿਆ ਤਦ ਆਦਮੀ ਅਤੇ ਡੰਗਰ ਉੱਤੇ ਜੂੰਆਂ ਹੋ ਗਈਆਂ ਅਤੇ ਧਰਤੀ ਦੀ ਸਾਰੀ ਧੂੜ ਮਿਸਰ ਦੇ ਸਾਰੇ ਦੇਸ ਵਿੱਚ ਜੂੰਆਂ ਹੋ ਗਈ। ");
INSERT INTO pan_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","ਤਦ ਜਾਦੂਗਰਾਂ ਨੇ ਆਪਣੇ ਜੰਤਰਾਂ-ਮੰਤਰਾਂ ਨਾਲ ਜਤਨ ਕੀਤਾ ਕਿ ਉਹ ਜੂੰਆਂ ਲੈ ਆਉਣ ਪਰ ਉਹ ਲਿਆ ਨਾ ਸਕੇ ਅਤੇ ਆਦਮੀ ਅਤੇ ਡੰਗਰ ਉੱਤੇ ਜੂੰਆਂ ਹੀ ਜੂੰਆਂ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","ਤਦ ਜਾਦੂਗਰਾਂ ਨੇ ਫ਼ਿਰਊਨ ਨੂੰ ਆਖਿਆ ਕਿ ਇਹ ਤਾਂ ਪਰਮੇਸ਼ੁਰ ਦੀ ਉਂਗਲ ਹੈ ਪਰ ਜਿਵੇਂ ਯਹੋਵਾਹ ਬੋਲਿਆ ਸੀ, ਫ਼ਿਰਊਨ ਦਾ ਮਨ ਕਠੋਰ ਹੋ ਗਿਆ ਅਤੇ ਉਸ ਨੇ ਉਨ੍ਹਾਂ ਦੀ ਨਾ ਸੁਣੀ। ");
INSERT INTO pan_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","ਫਿਰ ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਆਖਿਆ, ਸਵੇਰ ਦੇ ਵੇਲੇ ਉੱਠ ਕੇ ਫ਼ਿਰਊਨ ਦੇ ਸਾਹਮਣੇ ਜਾ ਕੇ ਖੜਾ ਹੋ। ਵੇਖ ਉਹ ਪਾਣੀ ਵੱਲ ਬਾਹਰ ਜਾਂਦਾ ਹੈ ਅਤੇ ਤੂੰ ਉਸ ਨੂੰ ਆਖੀਂ, ਯਹੋਵਾਹ ਇਸ ਤਰ੍ਹਾਂ ਆਖਦਾ ਹੈ, ਮੇਰੀ ਪਰਜਾ ਨੂੰ ਜਾਣ ਦੇ ਤਾਂ ਜੋ ਉਹ ਮੇਰੀ ਉਪਾਸਨਾ ਕਰੇ ");
INSERT INTO pan_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","ਜੇ ਤੂੰ ਮੇਰੀ ਪਰਜਾ ਨੂੰ ਜਾਣ ਨਾ ਦੇਵੇਂਗਾ ਤਾਂ ਵੇਖ, ਮੈਂ ਤੇਰੇ ਅਤੇ ਤੇਰੇ ਸੇਵਕਾਂ ਅਤੇ ਤੇਰੀ ਪਰਜਾ ਉੱਤੇ ਤੇਰੇ ਘਰਾਂ ਵਿੱਚ ਮੱਖਾਂ ਦੇ ਝੁੰਡ ਭੇਜ ਰਿਹਾ ਹਾਂ ਅਤੇ ਮਿਸਰ ਦੇ ਘਰ ਮੱਖਾਂ ਦੇ ਝੁੰਡਾਂ ਨਾਲ ਭਰ ਜਾਣਗੇ ਅਤੇ ਉਹ ਭੂਮੀ ਵੀ ਜਿੱਥੇ ਉਹ ਹਨ। ");
INSERT INTO pan_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","ਤਦ ਮੈਂ ਉਸ ਦਿਨ ਗੋਸ਼ਨ ਦੀ ਧਰਤੀ ਨੂੰ ਜਿੱਥੇ ਮੇਰੀ ਪਰਜਾ ਵੱਸਦੀ ਹੈ, ਵੱਖ ਰੱਖਾਂਗਾ ਤਾਂ ਜੋ ਉੱਥੇ ਮੱਖਾਂ ਦੇ ਝੁੰਡ ਨਾ ਹੋਣ ਤਾਂ ਜੋ ਤੂੰ ਜਾਣੇ ਕਿ ਧਰਤੀ ਉੱਤੇ ਮੈਂ ਹੀ ਯਹੋਵਾਹ ਹਾਂ। ");
INSERT INTO pan_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","ਮੈਂ ਆਪਣੀ ਪਰਜਾ ਅਤੇ ਤੇਰੀ ਪਰਜਾ ਨੂੰ ਵੱਖਰਾ ਕਰਾਂਗਾ ਅਤੇ ਇਹ ਨਿਸ਼ਾਨ ਕੱਲ ਤੱਕ ਹੋਵੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","ਤਦ ਯਹੋਵਾਹ ਨੇ ਉਸੇ ਤਰ੍ਹਾਂ ਹੀ ਕੀਤਾ ਅਤੇ ਮੱਖਾਂ ਦੇ ਝੁੰਡਾਂ ਦੇ ਝੁੰਡ ਫ਼ਿਰਊਨ ਦੇ ਮਹਿਲ ਵਿੱਚ ਅਤੇ ਉਸ ਦੇ ਸੇਵਕਾਂ ਦੇ ਘਰਾਂ ਵਿੱਚ ਆਏ ਅਤੇ ਮਿਸਰ ਦੇ ਸਾਰੇ ਦੇਸ ਵਿੱਚ ਧਰਤੀ ਮੱਖਾਂ ਦੇ ਝੁੰਡਾਂ ਦੇ ਕਾਰਨ ਨਾਸ ਹੋ ਗਈ। ");
INSERT INTO pan_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","ਫ਼ਿਰਊਨ ਨੇ ਮੂਸਾ ਅਤੇ ਹਾਰੂਨ ਨੂੰ ਬੁਲਵਾਕੇ ਆਖਿਆ, ਤੁਸੀਂ ਜਾਓ ਅਤੇ ਆਪਣੇ ਪਰਮੇਸ਼ੁਰ ਲਈ ਇਸੇ ਦੇਸ ਵਿੱਚ ਬਲੀ ਚੜ੍ਹਾਓ। ");
INSERT INTO pan_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","ਤਦ ਮੂਸਾ ਨੇ ਆਖਿਆ, ਇਸ ਤਰ੍ਹਾਂ ਕਰਨਾ ਜੋਗ ਨਹੀਂ ਕਿਉਂ ਜੋ ਅਸੀਂ ਯਹੋਵਾਹ ਆਪਣੇ ਪਰਮੇਸ਼ੁਰ ਲਈ ਮਿਸਰੀਆਂ ਦੀਆਂ ਘਿਣਾਉਣੀਆਂ ਬਲੀਆਂ ਚੜ੍ਹਾਵਾਂਗੇ। ਵੇਖੋ, ਜੇ ਅਸੀਂ ਮਿਸਰੀਆਂ ਦੀਆਂ ਅੱਖਾਂ ਦੇ ਅੱਗੇ ਘਿਣਾਉਣੀਆਂ ਬਲੀਆਂ ਚੜ੍ਹਾਈਏ ਤਾਂ ਕੀ ਉਹ ਸਾਨੂੰ ਪਥਰਾਉ ਨਾ ਕਰਨਗੇ? ");
INSERT INTO pan_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","ਜਿਵੇਂ ਸਾਡਾ ਪਰਮੇਸ਼ੁਰ ਆਖੇਗਾ ਅਸੀਂ ਤਿੰਨ ਦਿਨਾਂ ਦਾ ਰਸਤੇ ਉਜਾੜ ਵਿੱਚ ਜਾਂਵਾਂਗੇ ਅਤੇ ਯਹੋਵਾਹ ਆਪਣੇ ਪਰਮੇਸ਼ੁਰ ਲਈ ਬਲੀਆਂ ਚੜ੍ਹਾਵਾਂਗੇ। ");
INSERT INTO pan_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","ਤਦ ਫ਼ਿਰਊਨ ਨੇ ਆਖਿਆ, ਮੈਂ ਤੁਹਾਨੂੰ ਜਾਣ ਦੇਵਾਂਗਾ ਤਾਂ ਜੋ ਤੁਸੀਂ ਯਹੋਵਾਹ ਆਪਣੇ ਪਰਮੇਸ਼ੁਰ ਲਈ ਉਜਾੜ ਵਿੱਚ ਬਲੀਆਂ ਚੜ੍ਹਾਓ ਪਰ ਬਹੁਤ ਦੂਰ ਨਾ ਜਾਇਓ ਅਤੇ ਤੁਸੀਂ ਮੇਰੇ ਲਈ ਸਿਫ਼ਾਰਸ਼ ਕਰਨਾ। ");
INSERT INTO pan_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","ਮੂਸਾ ਨੇ ਆਖਿਆ, ਵੇਖੋ, ਮੈਂ ਤੁਹਾਡੇ ਕੋਲੋਂ ਬਾਹਰ ਜਾਂਦਾ ਹਾਂ। ਮੈਂ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਸਿਫ਼ਾਰਸ਼ ਕਰਾਂਗਾ ਕਿ ਮੱਖਾਂ ਦੇ ਝੁੰਡ ਫ਼ਿਰਊਨ ਤੋਂ, ਉਸ ਦੇ ਸੇਵਕਾਂ ਤੋਂ ਅਤੇ ਉਸ ਦੀ ਪਰਜਾ ਤੋਂ ਕੱਲ ਹਟ ਜਾਣ ਪਰ ਫ਼ਿਰਊਨ ਫਿਰ ਧੋਖਾ ਨਾ ਕਰੇ ਕਿ ਉਹ ਪਰਜਾ ਨੂੰ ਯਹੋਵਾਹ ਲਈ ਬਲੀਆਂ ਚੜ੍ਹਾਉਣ ਨੂੰ ਨਾ ਜਾਣ ਦੇਵੇ। ");
INSERT INTO pan_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","ਤਦ ਮੂਸਾ ਫ਼ਿਰਊਨ ਕੋਲੋਂ ਬਾਹਰ ਗਿਆ ਅਤੇ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਸਿਫ਼ਾਰਸ਼ ਕੀਤੀ। ");
INSERT INTO pan_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਦੇ ਕਹਿਣ ਦੇ ਅਨੁਸਾਰ ਕੀਤਾ ਅਤੇ ਉਨ੍ਹਾਂ ਮੱਖਾਂ ਦੇ ਝੁੰਡਾਂ ਨੂੰ ਫ਼ਿਰਊਨ ਅਤੇ ਉਸ ਦੇ ਟਹਿਲੂਆਂ ਅਤੇ ਉਸ ਦੀ ਪਰਜਾ ਤੋਂ ਹਟਾ ਦਿੱਤਾ ਤਦ ਉੱਥੇ ਇੱਕ ਵੀ ਨਾ ਰਿਹਾ। ");
INSERT INTO pan_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","ਪਰ ਫ਼ਿਰਊਨ ਨੇ ਇਸ ਵਾਰ ਵੀ ਆਪਣਾ ਮਨ ਕਠੋਰ ਕਰ ਲਿਆ ਅਤੇ ਪਰਜਾ ਨੂੰ ਜਾਣ ਨਾ ਦਿੱਤਾ। ");
INSERT INTO pan_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਆਖਿਆ, ਫ਼ਿਰਊਨ ਕੋਲ ਜਾ ਅਤੇ ਉਸ ਨਾਲ ਗੱਲ ਕਰ ਕਿ ਯਹੋਵਾਹ ਇਬਰਾਨੀਆਂ ਦਾ ਪਰਮੇਸ਼ੁਰ ਇਸ ਤਰ੍ਹਾਂ ਆਖਦਾ ਕਿ ਮੇਰੀ ਪਰਜਾ ਨੂੰ ਜਾਣ ਦੇ ਤਾਂ ਜੋ ਉਹ ਮੇਰੀ ਉਪਾਸਨਾ ਕਰੇ। ");
INSERT INTO pan_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","ਜੇ ਤੂੰ ਉਨ੍ਹਾਂ ਦੇ ਭੇਜਣ ਤੋਂ ਮੁੱਕਰ ਜਾਵੇਂ ਅਤੇ ਅਜੇ ਵੀ ਰੋਕ ਛੱਡੇਂ ");
INSERT INTO pan_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","ਤਾਂ ਵੇਖ ਯਹੋਵਾਹ ਦਾ ਹੱਥ ਤੇਰੇ ਪਸ਼ੂਆਂ ਉੱਤੇ ਜਿਹੜੇ ਮੈਦਾਨ ਵਿੱਚ ਹਨ ਘੋੜਿਆਂ ਉੱਤੇ, ਗਧਿਆਂ ਉੱਤੇ, ਊਠਾਂ ਉੱਤੇ, ਚੌਣਿਆਂ ਉੱਤੇ ਅਤੇ ਇੱਜੜਾਂ ਉੱਤੇ ਪਵੇਗਾ ਅਤੇ ਮਰੀ ਬਹੁਤ ਵੱਡੀ ਹੋਵੇਗੀ। ");
INSERT INTO pan_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","ਯਹੋਵਾਹ ਇਸਰਾਏਲੀਆਂ ਦੇ ਪਸ਼ੂਆਂ ਨੂੰ ਅਤੇ ਮਿਸਰੀਆਂ ਦੇ ਪਸ਼ੂਆਂ ਨੂੰ ਵੱਖਰਾ ਕਰੇਗਾ ਅਤੇ ਉਨ੍ਹਾਂ ਸਾਰਿਆਂ ਵਿੱਚੋਂ ਜਿਹੜੇ ਇਸਰਾਏਲੀਆਂ ਦੇ ਹਨ ਕੋਈ ਨਾ ਮਰੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","ਯਹੋਵਾਹ ਨੇ ਇੱਕ ਸਮਾਂ ਠਹਿਰਾਇਆ ਹੈ ਕਿ ਕੱਲ ਯਹੋਵਾਹ ਇਹ ਕੰਮ ਇਸ ਦੇਸ ਵਿੱਚ ਕਰੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","ਤਾਂ ਯਹੋਵਾਹ ਨੇ ਉਹ ਕੰਮ ਅਗਲੇ ਦਿਨ ਕੀਤਾ ਅਤੇ ਮਿਸਰੀਆਂ ਦੇ ਸਾਰੇ ਪਸ਼ੂ ਮਰ ਗਏ ਪਰ ਇਸਰਾਏਲੀਆਂ ਦੇ ਪਸ਼ੂਆਂ ਵਿੱਚੋਂ ਇੱਕ ਵੀ ਨਾ ਮਰਿਆ। ");
INSERT INTO pan_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","ਫੇਰ ਫ਼ਿਰਊਨ ਨੇ ਕਿਸੇ ਨੂੰ ਭੇਜਿਆ ਤਾਂ ਵੇਖੋ ਇਸਰਾਏਲ ਦੇ ਪਸ਼ੂਆਂ ਵਿੱਚੋਂ ਇੱਕ ਵੀ ਨਹੀਂ ਮਰਿਆ ਸੀ ਪਰ ਫ਼ਿਰਊਨ ਦਾ ਮਨ ਪੱਥਰ ਹੋ ਗਿਆ ਸੋ ਉਸ ਨੇ ਲੋਕਾਂ ਨੂੰ ਜਾਣ ਨਾ ਦਿੱਤਾ। ");
INSERT INTO pan_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","ਤਾਂ ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਅਤੇ ਹਾਰੂਨ ਨੂੰ ਆਖਿਆ ਭੱਠੀ ਦੀ ਸੁਆਹ ਦੀਆਂ ਮੁੱਠਾਂ ਭਰੋ ਅਤੇ ਮੂਸਾ ਫ਼ਿਰਊਨ ਦੇ ਵੇਖਦਿਆਂ ਅਕਾਸ਼ ਵੱਲ ਉਡਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","ਤਾਂ ਮਿਸਰ ਦੇ ਸਾਰੇ ਦੇਸ ਉੱਤੇ ਉਹ ਘੱਟਾ ਹੋ ਕੇ ਆਦਮੀਆਂ ਅਤੇ ਡੰਗਰਾਂ ਉੱਤੇ ਸਾਰੇ ਮਿਸਰ ਦੇਸ ਵਿੱਚ ਅੰਗਿਆਰੇ ਅਤੇ ਛਾਲੇ ਬਣ ਜਾਣਗੇ। ");
INSERT INTO pan_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","ਸੋ ਉਹ ਭੱਠੀ ਦੀ ਸੁਆਹ ਲੈ ਕੇ ਫ਼ਿਰਊਨ ਦੇ ਅੱਗੇ ਖੜੇ ਹੋਏ। ਮੂਸਾ ਨੇ ਉਸ ਨੂੰ ਅਕਾਸ਼ ਵੱਲ ਉਡਾ ਦਿੱਤਾ ਤਾਂ ਆਦਮੀਆਂ ਅਤੇ ਡੰਗਰਾਂ ਉੱਤੇ ਅੰਗਿਆਰੇ ਅਤੇ ਛਾਲੇ ਪੈ ਗਏ। ");
INSERT INTO pan_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","ਤਾਂ ਜਾਦੂਗਰ ਅੰਗਿਆਰਿਆਂ ਦੇ ਕਾਰਨ ਮੂਸਾ ਦੇ ਅੱਗੇ ਖੜੇ ਨਾ ਹੋ ਸਕੇ ਕਿਉਂ ਜੋ ਜਾਦੂਗਰਾਂ ਅਤੇ ਸਾਰੇ ਮਿਸਰੀਆਂ ਦੇ ਅੰਗਿਆਰੇ ਨਿੱਕਲੇ ਹੋਏ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","ਅਤੇ ਜਿਵੇਂ ਯਹੋਵਾਹ ਮੂਸਾ ਨੂੰ ਬੋਲਿਆ ਸੀ ਯਹੋਵਾਹ ਨੇ ਫ਼ਿਰਊਨ ਦੇ ਮਨ ਨੂੰ ਕਠੋਰ ਹੋਣ ਦਿੱਤਾ ਅਤੇ ਉਸ ਨੇ ਉਨ੍ਹਾਂ ਦੀ ਨਾ ਸੁਣੀ। ");
INSERT INTO pan_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","ਉਪਰੰਤ ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਆਖਿਆ, ਸਵੇਰੇ ਉੱਠ ਕੇ ਫ਼ਿਰਊਨ ਦੇ ਅੱਗੇ ਜਾ ਕੇ ਖੜਾ ਹੋ ਅਤੇ ਉਸ ਨੂੰ ਆਖ, ਯਹੋਵਾਹ ਇਬਰਾਨੀਆਂ ਦਾ ਪਰਮੇਸ਼ੁਰ ਇਸ ਤਰ੍ਹਾਂ ਆਖਦਾ ਹੈ, ਮੇਰੀ ਪਰਜਾ ਨੂੰ ਜਾਣ ਦੇ ਤਾਂ ਜੋ ਉਹ ਮੇਰੀ ਉਪਾਸਨਾ ਕਰੇ ");
INSERT INTO pan_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","ਕਿਉਂਕਿ ਮੈਂ ਇਸ ਵਾਰ ਆਪਣੀਆਂ ਸਾਰੀਆਂ ਬਵਾਂ ਤੇਰੇ ਮਨ ਉੱਤੇ, ਤੇਰੇ ਟਹਿਲੂਆਂ ਉੱਤੇ ਅਤੇ ਤੇਰੀ ਪਰਜਾ ਉੱਤੇ ਭੇਜਣ ਵਾਲਾ ਹਾਂ ਤਾਂ ਜੋ ਤੂੰ ਜਾਣੇ ਕਿ ਸਾਰੀ ਧਰਤੀ ਉੱਤੇ ਮੇਰੇ ਜਿਹਾ ਕੋਈ ਨਹੀਂ। ");
INSERT INTO pan_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","ਹੁਣ ਤੱਕ ਮੈਂ ਆਪਣਾ ਹੱਥ ਵਧਾ ਕੇ ਤੈਨੂੰ ਅਤੇ ਤੇਰੀ ਰਈਅਤ ਨੂੰ ਮਰੀ ਨਾਲ ਮਾਰ ਦਿੱਤਾ ਹੁੰਦਾ ਅਤੇ ਤੂੰ ਧਰਤੀ ਉੱਤੋਂ ਮਿਟ ਗਿਆ ਹੁੰਦਾ ");
INSERT INTO pan_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","ਪਰ ਸੱਚ-ਮੁੱਚ ਮੈਂ ਤੈਨੂੰ ਇਸ ਕਰਕੇ ਖੜਾ ਕੀਤਾ ਅਤੇ ਇਸ ਕਰਕੇ ਤੈਨੂੰ ਆਪਣਾ ਬਲ ਵਿਖਾਇਆ ਤਾਂ ਜੋ ਮੇਰਾ ਨਾਮ ਸਾਰੀ ਧਰਤੀ ਵਿੱਚ ਪਰਗਟ ਹੋ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","ਹੁਣ ਤੱਕ ਤੂੰ ਮੇਰੀ ਪਰਜਾ ਵਿੱਚ ਆਪਣੇ ਆਪ ਨੂੰ ਉੱਚਾ ਕਰਦਾ ਰਿਹਾ ਹੈਂ ਕਿ ਤੂੰ ਉਨ੍ਹਾਂ ਨੂੰ ਜਾਣ ਨਹੀਂ ਦਿੱਤਾ। ");
INSERT INTO pan_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","ਵੇਖ ਮੈਂ ਭਲਕੇ ਇਸੇ ਵੇਲੇ ਬਹੁਤ ਭਾਰੀ ਗੜੇ ਵਰਸਾਵਾਂਗਾ ਜਿਵੇਂ ਮਿਸਰ ਦੇ ਮੁੱਢ ਤੋਂ ਲੈ ਕੇ ਹੁਣ ਤੱਕ ਨਹੀਂ ਪਏ। ");
INSERT INTO pan_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","ਸੋ ਹੁਣ ਤੂੰ ਭੇਜ ਕੇ ਆਪਣੇ ਪਸ਼ੂ ਅਤੇ ਜੋ ਕੁਝ ਤੇਰਾ ਜੂਹ ਵਿੱਚ ਹੈ ਭਜਾ ਲਿਆ। ਸਾਰੇ ਆਦਮੀਆਂ ਅਤੇ ਡੰਗਰਾਂ ਉੱਤੇ ਜਿਹੜੇ ਮੈਦਾਨ ਵਿੱਚ ਹੋਣ ਅਤੇ ਘਰ ਵਿੱਚ ਨਾ ਲਿਆਂਦੇ ਜਾਣ ਗੜੇ ਪੈਣਗੇ ਅਤੇ ਉਹ ਮਰ ਜਾਣਗੇ। ");
INSERT INTO pan_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","ਤਾਂ ਫ਼ਿਰਊਨ ਦੇ ਟਹਿਲੂਆਂ ਵਿੱਚੋਂ ਜਿਹੜਾ ਯਹੋਵਾਹ ਦੇ ਬਚਨ ਤੋਂ ਭੈਅ ਖਾਂਦਾ ਸੀ ਉਹ ਆਪਣੇ ਟਹਿਲੂਆਂ ਨੂੰ ਅਤੇ ਆਪਣੇ ਪਸ਼ੂਆਂ ਨੂੰ ਘਰੀਂ ਭਜਾ ਲਿਆਇਆ। ");
INSERT INTO pan_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","ਪਰ ਜਿਸ ਨੇ ਆਪਣਾ ਮਨ ਯਹੋਵਾਹ ਦੇ ਬਚਨ ਉੱਤੇ ਨਾ ਲਾਇਆ ਉਸ ਨੇ ਆਪਣੇ ਟਹਿਲੂਆਂ ਅਤੇ ਪਸ਼ੂਆਂ ਨੂੰ ਜੂਹ ਵਿੱਚ ਰਹਿਣ ਦਿੱਤਾ। ");
INSERT INTO pan_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","ਤਾਂ ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਆਖਿਆ, ਆਪਣਾ ਹੱਥ ਅਕਾਸ਼ ਵੱਲ ਵਧਾ ਤਾਂ ਜੋ ਸਾਰੇ ਮਿਸਰ ਦੇਸ ਵਿੱਚ ਆਦਮੀ ਉੱਤੇ, ਡੰਗਰ ਉੱਤੇ ਅਤੇ ਖੇਤ ਦੀ ਸਾਰੀ ਸਾਗ ਪੱਤ ਉੱਤੇ ਮਿਸਰ ਦੇਸ ਵਿੱਚ ਗੜੇ ਪੈਣ। ");
INSERT INTO pan_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","ਮੂਸਾ ਨੇ ਆਪਣਾ ਢਾਂਗਾ ਅਕਾਸ਼ ਵੱਲ ਲੰਮਾ ਕੀਤਾ ਤਾਂ ਯਹੋਵਾਹ ਨੇ ਗਰਜ ਅਤੇ ਗੜੇ ਭੇਜੇ ਅਤੇ ਅੱਗ ਧਰਤੀ ਵੱਲ ਚਲੀ ਆਉਂਦੀ ਸੀ ਅਤੇ ਯਹੋਵਾਹ ਨੇ ਮਿਸਰ ਦੇਸ ਉੱਤੇ ਗੜੇ ਵਰਸਾਏ। ");
INSERT INTO pan_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","ਸੋ ਗੜੇ ਸਨ ਤੇ ਗੜਿਆਂ ਵਿੱਚ ਅੱਗ ਰਲੀ ਹੋਈ ਸੀ ਇਹ ਐਨੀ ਡਾਢੀ ਸੀ ਕਿ ਮਿਸਰ ਦੇ ਸਾਰੇ ਦੇਸ ਵਿੱਚ ਉਹ ਦੇ ਕੌਮ ਬਣਨ ਤੋਂ ਲੈ ਕੇ ਹੋਈ ਹੀ ਨਹੀਂ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","ਅਤੇ ਗੜਿਆਂ ਨੇ ਸਾਰੇ ਮਿਸਰ ਦੇਸ ਵਿੱਚ ਸਭ ਕੁਝ ਜੋ ਜੂਹ ਵਿੱਚ ਸੀ ਕੀ ਆਦਮੀ ਕੀ ਡੰਗਰ ਮਾਰਿਆ ਨਾਲੇ ਗੜਿਆਂ ਨੇ ਖੇਤ ਦਾ ਸੱਭੋ ਸਾਗ ਪੱਤ ਮਾਰ ਦਿੱਤਾ ਅਤੇ ਖੇਤ ਦੇ ਸਾਰੇ ਬਿਰਛ ਭੰਨ ਸੁੱਟੇ। ");
INSERT INTO pan_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","ਕੇਵਲ ਗੋਸ਼ਨ ਦੀ ਧਰਤੀ ਵਿੱਚ ਜਿੱਥੇ ਇਸਰਾਏਲੀ ਸਨ ਕੋਈ ਗੜਾ ਨਹੀਂ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","ਤਾਂ ਫ਼ਿਰਊਨ ਨੇ ਮੂਸਾ ਅਤੇ ਹਾਰੂਨ ਨੂੰ ਸੱਦ ਭੇਜਿਆ ਅਤੇ ਉਨ੍ਹਾਂ ਨੂੰ ਆਖਿਆ ਕਿ ਮੈਂ ਇਸ ਵਾਰ ਪਾਪ ਕੀਤਾ। ਯਹੋਵਾਹ ਸੱਚ ਹੈ। ਮੈਂ ਅਤੇ ਮੇਰੀ ਪਰਜਾ ਦੁਸ਼ਟ ਹਾਂ। ");
INSERT INTO pan_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","ਤੁਸੀਂ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਸਿਫ਼ਾਰਸ਼ ਕਰੋ ਕਿਉਂ ਜੋ ਹੁਣ ਪਰਮੇਸ਼ੁਰ ਦੀ ਗਰਜ ਦੀ ਅਤੇ ਗੜਿਆਂ ਦੀ ਹੱਦ ਹੋ ਗਈ ਹੈ। ਮੈਂ ਤੁਹਾਨੂੰ ਜਾਣ ਦੇਵਾਂਗਾ ਹੁਣ ਤੁਸੀਂ ਹੋਰ ਨਹੀਂ ਠਹਿਰੋਗੇ। ");
INSERT INTO pan_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","ਤਾਂ ਮੂਸਾ ਨੇ ਉਸ ਨੂੰ ਆਖਿਆ, ਜਿਵੇਂ ਹੀ ਮੈਂ ਨਗਰ ਤੋਂ ਬਾਹਰ ਜਾਂਵਾਂਗਾ ਮੈਂ ਯਹੋਵਾਹ ਅੱਗੇ ਆਪਣੇ ਹੱਥ ਅੱਡਾਂਗਾ ਤਾਂ ਗਰਜ਼ਣਾ ਹਟ ਜਾਵੇਗਾ ਅਤੇ ਗੜੇ ਫੇਰ ਨਾ ਪੈਣਗੇ ਤਾਂ ਜੋ ਤੁਸੀਂ ਜਾਣੋ ਕਿ ਧਰਤੀ ਯਹੋਵਾਹ ਦੀ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","ਮੈਂ ਤੁਹਾਨੂੰ ਅਤੇ ਤੁਹਾਡੇ ਟਹਿਲੂਆਂ ਨੂੰ ਜਾਣਦਾ ਹਾਂ ਕਿ ਤੁਸੀਂ ਅਜੇ ਵੀ ਯਹੋਵਾਹ ਪਰਮੇਸ਼ੁਰ ਤੋਂ ਨਾ ਡਰੋਗੇ। ");
INSERT INTO pan_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","ਅਲਸੀ ਅਤੇ ਜੌਂ ਮਾਰੇ ਗਏ ਕਿਉਂਕਿ ਜਵਾਂ ਦੇ ਸਿੱਟੇ ਨਿੱਕਲੇ ਹੋਏ ਸਨ ਅਤੇ ਅਲਸੀ ਫੁੱਲੀ ਹੋਈ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","ਪਰ ਕਣਕ ਅਤੇ ਮਸਰ ਮਾਰੇ ਨਾ ਗਏ ਕਿਉਂਕਿ ਉਹ ਅਜੇ ਵਧੇ ਨਹੀਂ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","ਤਾਂ ਮੂਸਾ ਫ਼ਿਰਊਨ ਕੋਲੋਂ ਹੋ ਕੇ ਨਗਰ ਵਿੱਚੋਂ ਬਾਹਰ ਗਿਆ ਅਤੇ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਹੱਥ ਅੱਡੇ ਤਾਂ ਗਰਜ਼ਣਾ ਅਤੇ ਗੜੇ ਹਟ ਗਏ ਅਤੇ ਵਰਖਾ ਧਰਤੀ ਤੋਂ ਥੰਮ੍ਹ ਗਈ। ");
INSERT INTO pan_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","ਜਦ ਫ਼ਿਰਊਨ ਨੇ ਡਿੱਠਾ ਕਿ ਵਰਖਾ ਅਤੇ ਗੜੇ ਅਤੇ ਗਰਜ਼ਣਾ ਹਟ ਗਏ ਹਨ ਤਾਂ ਫੇਰ ਪਾਪ ਕੀਤਾ ਅਤੇ ਆਪਣਾ ਮਨ ਪੱਥਰ ਕਰ ਲਿਆ ਉਸ ਵੀ ਅਤੇ ਉਸ ਦੇ ਟਹਿਲੂਆਂ ਵੀ। ");
INSERT INTO pan_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","ਸੋ ਜਿਵੇਂ ਯਹੋਵਾਹ ਮੂਸਾ ਦੇ ਰਾਹੀਂ ਬੋਲਿਆ ਸੀ ਫ਼ਿਰਊਨ ਦਾ ਮਨ ਕਠੋਰ ਹੋ ਗਿਆ। ਉਸ ਨੇ ਇਸਰਾਏਲੀਆਂ ਨੂੰ ਜਾਣ ਨਾ ਦਿੱਤਾ। ");
INSERT INTO pan_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਆਖਿਆ, ਫ਼ਿਰਊਨ ਕੋਲ ਜਾ ਕਿਉਂ ਜੋ ਮੈਂ ਉਸ ਦੇ ਮਨ ਨੂੰ ਅਤੇ ਉਸ ਦੇ ਟਹਿਲੂਆਂ ਦੇ ਮਨਾਂ ਨੂੰ ਭਾਰੀ ਹੋਣ ਦਿੱਤਾ ਹੈ ਤਾਂ ਜੋ ਮੈਂ ਆਪਣੇ ਇਹ ਨਿਸ਼ਾਨ ਉਨ੍ਹਾਂ ਦੇ ਵਿੱਚ ਵਿਖਾਵਾਂ। ");
INSERT INTO pan_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","ਜੋ ਸਖ਼ਤੀ ਮੈਂ ਮਿਸਰ ਉੱਤੇ ਕੀਤੀ ਅਤੇ ਮੇਰੇ ਨਿਸ਼ਾਨ ਜਿਹੜੇ ਮੈਂ ਉਨ੍ਹਾਂ ਵਿੱਚ ਵਿਖਾਏ, ਤੂੰ ਆਪਣੇ ਪੁੱਤਰ ਅਤੇ ਆਪਣੇ ਪੋਤੇ ਦੇ ਕੰਨਾਂ ਵਿੱਚ ਪਾਇਆ ਕਰੇਂ, ਤਾਂ ਜੋ ਤੁਸੀਂ ਜਾਣੋ ਕਿ ਮੈਂ ਯਹੋਵਾਹ ਹਾਂ। ");
INSERT INTO pan_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","ਸੋ ਮੂਸਾ ਅਤੇ ਹਾਰੂਨ ਨੇ ਫ਼ਿਰਊਨ ਦੇ ਕੋਲ ਜਾ ਕੇ ਉਸ ਨੂੰ ਆਖਿਆ, ਯਹੋਵਾਹ ਇਬਰਾਨੀਆਂ ਦਾ ਪਰਮੇਸ਼ੁਰ ਇਸ ਤਰ੍ਹਾਂ ਆਖਦਾ ਹੈ ਕਿ ਕਦ ਤੱਕ ਤੂੰ ਮੇਰੇ ਅੱਗੇ ਆਪਣੇ ਆਪ ਨੂੰ ਨੀਵਾਂ ਕਰਨ ਤੋਂ ਇਨਕਾਰ ਕਰਦਾ ਰਹੇਂਗਾ? ਮੇਰੀ ਪਰਜਾ ਨੂੰ ਜਾਣ ਦੇ ਤਾਂ ਜੋ ਉਹ ਮੇਰੀ ਉਪਾਸਨਾ ਕਰੇ। ");
INSERT INTO pan_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","ਨਹੀਂ ਤਾਂ, ਜੇ ਤੂੰ ਮੇਰੀ ਪਰਜਾ ਨੂੰ ਭੇਜਣ ਤੋਂ ਮੁੱਕਰ ਜਾਵੇਂਗਾ ਤਾਂ ਵੇਖ ਮੈਂ ਭਲਕੇ ਤੇਰੀਆਂ ਹੱਦਾਂ ਵਿੱਚ ਟਿੱਡੀ ਦਲ ਲਿਆ ਰਿਹਾ ਹਾਂ। ");
INSERT INTO pan_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","ਉਹ ਧਰਤੀ ਦੀ ਪਰਤ ਨੂੰ ਇਸ ਤਰ੍ਹਾਂ ਢੱਕ ਦੇਵੇਗੀ ਕਿ ਧਰਤੀ ਨੂੰ ਕੋਈ ਵੇਖ ਨਾ ਸਕੇਗਾ ਅਤੇ ਉਹ ਉਸ ਬਕੀਏ ਨੂੰ ਜਿਹੜਾ ਤੁਹਾਡੇ ਲਈ ਗੜਿਆਂ ਤੋਂ ਬਚ ਰਿਹਾ ਹੈ ਖਾ ਜਾਵੇਗੀ ਅਤੇ ਉਹ ਸਾਰਿਆਂ ਬਿਰਛਾਂ ਨੂੰ ਜਿਹੜੇ ਤੁਹਾਡੇ ਲਈ ਮੈਦਾਨ ਵਿੱਚ ਉੱਗੇ ਹਨ ਖਾ ਜਾਵੇਗੀ। ");
INSERT INTO pan_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","ਅਤੇ ਤੇਰੇ ਘਰ ਤੇਰੇ ਸਾਰੇ ਟਹਿਲੂਆਂ ਦੇ ਘਰ ਅਤੇ ਸਾਰੇ ਮਿਸਰੀਆਂ ਦੇ ਘਰ ਭਰ ਦੇਵੇਗੀ ਇੱਥੋਂ ਤੱਕ ਕਿ ਨਾ ਤੇਰੇ ਪਿਤਾ ਨੇ ਨਾ ਤੇਰੇ ਦਾਦਿਆਂ ਨੇ ਜਿਸ ਦਿਨ ਤੋਂ ਉਹ ਜ਼ਮੀਨ ਉੱਤੇ ਹੋਏ ਅੱਜ ਦੇ ਦਿਨ ਤੱਕ ਵੇਖਿਆ। ਤਾਂ ਉਹ ਮੁੜ ਕੇ ਫ਼ਿਰਊਨ ਕੋਲੋਂ ਬਾਹਰ ਨਿੱਕਲ ਗਿਆ। ");
INSERT INTO pan_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","ਤਦ ਫ਼ਿਰਊਨ ਦੇ ਟਹਿਲੂਆਂ ਨੇ ਉਸ ਨੂੰ ਆਖਿਆ, ਇਹ ਮਨੁੱਖ ਕਦ ਤੱਕ ਸਾਡੇ ਲਈ ਇੱਕ ਫਾਹੀ ਹੋਵੇਗਾ? ਉਨ੍ਹਾਂ ਮਨੁੱਖਾਂ ਨੂੰ ਜਾਣ ਦਿਓ ਤਾਂ ਜੋ ਉਹ ਯਹੋਵਾਹ ਆਪਣੇ ਪਰਮੇਸ਼ੁਰ ਦੀ ਉਪਾਸਨਾ ਕਰਨ। ਅਜੇ ਤੱਕ ਤੁਸੀਂ ਜਾਣਿਆ ਨਹੀਂ ਕਿ ਮਿਸਰ ਬਰਬਾਦ ਹੋ ਗਿਆ ਹੈ? ");
INSERT INTO pan_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","ਤਾਂ ਮੂਸਾ ਅਤੇ ਹਾਰੂਨ ਫ਼ਿਰਊਨ ਕੋਲ ਮੁੜ ਲਿਆਂਦੇ ਗਏ। ਉਸ ਨੇ ਉਨ੍ਹਾਂ ਨੂੰ ਆਖਿਆ, ਜਾਓ ਅਤੇ ਯਹੋਵਾਹ ਆਪਣੇ ਪਰਮੇਸ਼ੁਰ ਦੀ ਉਪਾਸਨਾ ਕਰੋ ਪਰ ਜਾਣ ਵਾਲੇ ਕਿਹੜੇ ਹਨ? ");
INSERT INTO pan_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","ਮੂਸਾ ਆਖਿਆ, ਅਸੀਂ ਆਪਣੇ ਜਵਾਨਾਂ ਨਾਲ ਆਪਣੇ ਬਜ਼ੁਰਗਾਂ ਨਾਲ ਜਾਂਵਾਂਗੇ। ਅਸੀਂ ਆਪਣੇ ਪੁੱਤਰਾਂ ਨਾਲ ਆਪਣੀਆਂ ਧੀਆਂ ਨਾਲ ਆਪਣੇ ਇੱਜੜਾਂ ਨਾਲ ਆਪਣੇ ਵੱਗਾਂ ਨਾਲ ਜਾਂਵਾਂਗੇ ਕਿਉਂਕਿ ਸਾਡੇ ਲਈ ਯਹੋਵਾਹ ਦਾ ਪਰਬ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","ਤਾਂ ਉਸ ਨੇ ਉਨ੍ਹਾਂ ਨੂੰ ਆਖਿਆ, ਇਸ ਤਰ੍ਹਾਂ ਯਹੋਵਾਹ ਤੁਹਾਡੇ ਨਾਲ ਹੋਵੇ ਜਿਵੇਂ ਮੈਂ ਤੁਹਾਨੂੰ ਅਤੇ ਤੁਹਾਡੇ ਨਿਆਣਿਆਂ ਨੂੰ ਜਾਣ ਦਿੰਦਾ ਹਾਂ! ਵੇਖ ਲਓ ਬੁਰਿਆਈ ਤੁਹਾਡੇ ਅੱਗੇ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","ਇਸ ਤਰ੍ਹਾਂ ਨਹੀਂ ਪਰ ਤੁਸੀਂ ਮਨੁੱਖ ਜਾਓ ਅਤੇ ਯਹੋਵਾਹ ਦੀ ਉਪਾਸਨਾ ਕਰੋ ਕਿਉਂ ਜੋ ਇਹੋ ਹੀ ਤੁਸੀਂ ਚਾਹੁੰਦੇ ਹੋ। ਸੋ ਉਹ ਫ਼ਿਰਊਨ ਦੇ ਅੱਗੋਂ ਧੱਕੇ ਗਏ। ");
INSERT INTO pan_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","ਤਾਂ ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਆਖਿਆ, ਆਪਣਾ ਹੱਥ ਮਿਸਰ ਦੀ ਧਰਤੀ ਉੱਤੇ ਸਲਾ ਲਈ ਪਸਾਰ ਤਾਂ ਜੋ ਉਹ ਮਿਸਰ ਦੀ ਧਰਤੀ ਉੱਤੇ ਆਵੇ ਅਤੇ ਉਹ ਧਰਤੀ ਦਾ ਸਾਰਾ ਸਾਗ ਪੱਤ ਜਿਹੜਾ ਗੜਿਆਂ ਤੋਂ ਬਚ ਰਿਹਾ ਹੈ ਚੱਟ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","ਮੂਸਾ ਨੇ ਆਪਣਾ ਢਾਂਗਾ ਮਿਸਰ ਦੀ ਧਰਤੀ ਉੱਤੇ ਲੰਮਾ ਕੀਤਾ ਤਾਂ ਯਹੋਵਾਹ ਨੇ ਉਸ ਸਾਰੇ ਦਿਨ ਅਤੇ ਸਾਰੀ ਰਾਤ ਉਸ ਧਰਤੀ ਉੱਤੇ ਪੁਰੇ ਦੀ ਹਵਾ ਵਗਾਈ। ਜਦ ਸਵੇਰਾ ਹੋਇਆ ਤਾਂ ਪੁਰੇ ਦੀ ਹਵਾ ਟਿੱਡੀ ਦਲ ਲੈ ਆਈ। ");
INSERT INTO pan_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","ਅਤੇ ਟਿੱਡੀ ਦਲ ਸਾਰੇ ਮਿਸਰ ਦੇਸ ਉੱਤੇ ਚੜ੍ਹ ਆਇਆ ਅਤੇ ਮਿਸਰ ਦੀਆਂ ਸਾਰੀਆਂ ਹੱਦਾਂ ਵਿੱਚ ਉੱਤਰ ਪਿਆ ਅਤੇ ਐਨੀ ਭਾਰੀ ਸੀ ਕਿ ਇਸ ਤੋਂ ਅੱਗੇ ਕਦੀ ਅਜਿਹਾ ਟਿੱਡੀ ਦਲ ਨਹੀਂ ਆਇਆ ਸੀ ਅਤੇ ਨਾ ਇਸ ਦੇ ਪਿੱਛੋਂ ਫੇਰ ਕਦੀ ਆਵੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","ਸੋ ਉਸ ਸਾਰੀ ਧਰਤੀ ਦੀ ਪਰਤ ਢੱਕ ਲਈ ਕਿ ਧਰਤੀ ਉੱਤੇ ਹਨ੍ਹੇਰਾ ਹੋ ਗਿਆ। ਉਸ ਧਰਤੀ ਦਾ ਸਾਰਾ ਸਾਗ ਪੱਤ ਚੱਟ ਲਿਆ ਨਾਲੇ ਬਿਰਛਾਂ ਦਾ ਸਾਰਾ ਫਲ ਜਿਹੜਾ ਗੜਿਆਂ ਤੋਂ ਬਚ ਗਿਆ ਸੀ ਅਤੇ ਮਿਸਰ ਦੇ ਸਾਰੇ ਦੇਸ ਵਿੱਚ ਬਿਰਛਾਂ ਅਤੇ ਖੇਤ ਦੇ ਸਾਗ ਪੱਤ ਉੱਤੇ ਕੋਈ ਹਰਿਆਲੀ ਨਾ ਰਹੀ। ");
INSERT INTO pan_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","ਤਾਂ ਫ਼ਿਰਊਨ ਨੇ ਛੇਤੀ ਨਾਲ ਮੂਸਾ ਤੇ ਹਾਰੂਨ ਨੂੰ ਬੁਲਾ ਕੇ ਆਖਿਆ, ਮੈਂ ਯਹੋਵਾਹ ਤੁਹਾਡੇ ਪਰਮੇਸ਼ੁਰ ਦਾ ਅਤੇ ਤੁਹਾਡਾ ਪਾਪ ਕੀਤਾ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","ਹੁਣ ਤੂੰ ਮੇਰਾ ਪਾਪ ਨਿਰਾ ਐਤਕੀਂ ਦੀ ਵਾਰ ਮਾਫ਼ ਕਰ ਅਤੇ ਯਹੋਵਾਹ ਆਪਣੇ ਪਰਮੇਸ਼ੁਰ ਦੇ ਕੋਲ ਸਿਫ਼ਾਰਸ਼ ਕਰ ਕਿ ਉਹ ਕੇਵਲ ਇਸ ਮੌਤ ਨੂੰ ਮੇਰੇ ਕੋਲੋਂ ਹਟਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","ਤਾਂ ਉਹ ਫ਼ਿਰਊਨ ਦੇ ਕੋਲੋਂ ਨਿੱਕਲ ਗਿਆ ਅਤੇ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਸਿਫ਼ਾਰਸ਼ ਕੀਤੀ। ");
INSERT INTO pan_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","ਤਾਂ ਯਹੋਵਾਹ ਨੇ ਪੂਰਬ ਵੱਲੋਂ ਬਹੁਤ ਤੇਜ ਹਵਾ ਮੋੜੀ ਜਿਸ ਨੇ ਟਿੱਡੀ ਦਲ ਨੂੰ ਚੁੱਕ ਕੇ ਲਾਲ ਸਮੁੰਦਰ ਵਿੱਚ ਸੁੱਟ ਦਿੱਤਾ ਅਤੇ ਮਿਸਰ ਦੀਆਂ ਸਾਰੀਆਂ ਹੱਦਾਂ ਵਿੱਚ ਇੱਕ ਵੀ ਟਿੱਡੀ ਨਾ ਰਹੀ। ");
INSERT INTO pan_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","ਪਰ ਯਹੋਵਾਹ ਨੇ ਫ਼ਿਰਊਨ ਦਾ ਮਨ ਕਠੋਰ ਹੋਣ ਦਿੱਤਾ ਅਤੇ ਉਸ ਨੇ ਇਸਰਾਏਲੀਆਂ ਨੂੰ ਜਾਣ ਨਾ ਦਿੱਤਾ। ");
INSERT INTO pan_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","ਤਾਂ ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਆਖਿਆ, ਆਪਣਾ ਹੱਥ ਅਕਾਸ਼ ਵੱਲ ਪਸਾਰ ਤਾਂ ਜੋ ਮਿਸਰ ਦੇਸ ਵਿੱਚ ਹਨ੍ਹੇਰਾ ਹੋ ਜਾਵੇ, ਅਜਿਹਾ ਹਨ੍ਹੇਰਾ ਜਿਹੜਾ ਟੋਹਿਆ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","ਤਾਂ ਮੂਸਾ ਨੇ ਆਪਣਾ ਹੱਥ ਅਕਾਸ਼ ਵੱਲ ਪਸਾਰਿਆ ਅਤੇ ਮਿਸਰ ਦੇ ਸਾਰੇ ਦੇਸ ਵਿੱਚ ਤਿੰਨ ਦਿਨ ਹਨੇਰ ਘੁੱਪ ਰਿਹਾ। ");
INSERT INTO pan_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","ਕਿਸੇ ਨੇ ਇੱਕ ਦੂਜੇ ਨੂੰ ਨਾ ਵੇਖਿਆ ਅਤੇ ਨਾ ਕੋਈ ਤਿੰਨ ਦਿਨ ਤੱਕ ਆਪਣੇ ਥਾਂ ਤੋਂ ਉੱਠਿਆ ਪਰ ਸਾਰੇ ਇਸਰਾਏਲੀਆਂ ਦੇ ਟਿਕਾਣਿਆਂ ਵਿੱਚ ਚਾਨਣਾ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","ਤਦ ਫ਼ਿਰਊਨ ਨੇ ਮੂਸਾ ਨੂੰ ਸੱਦ ਕੇ ਆਖਿਆ, ਤੁਸੀਂ ਜਾਓ ਅਤੇ ਯਹੋਵਾਹ ਦੀ ਉਪਾਸਨਾ ਕਰੋ। ਕੇਵਲ ਤੁਹਾਡੇ ਇੱਜੜ ਅਤੇ ਤੁਹਾਡੇ ਵੱਗ ਰਹਿ ਜਾਣ ਅਤੇ ਤੁਹਾਡੇ ਨਿਆਣੇ ਵੀ ਨਾਲ ਜਾਣ। ");
INSERT INTO pan_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","ਤਦ ਮੂਸਾ ਨੇ ਆਖਿਆ, ਤੁਸੀਂ ਆਪ ਸਾਡੇ ਹੱਥ ਵਿੱਚ ਬਲੀਆਂ ਅਤੇ ਹੋਮ ਦੀਆਂ ਭੇਟਾਂ ਦਿਓ ਤਾਂ ਜੋ ਅਸੀਂ ਯਹੋਵਾਹ ਆਪਣੇ ਪਰਮੇਸ਼ੁਰ ਲਈ ਚੜ੍ਹਾਈਏ। ");
INSERT INTO pan_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","ਸਾਡੇ ਪਸ਼ੂ ਵੀ ਸਾਡੇ ਨਾਲ ਜਾਣਗੇ, ਇੱਕ ਖੁਰ ਵੀ ਪਿੱਛੇ ਨਾ ਰਹੇਗਾ ਕਿਉਂ ਜੋ ਉਨ੍ਹਾਂ ਦੇ ਵਿੱਚੋਂ ਹੀ ਯਹੋਵਾਹ ਆਪਣੇ ਪਰਮੇਸ਼ੁਰ ਦੀ ਉਪਾਸਨਾ ਲਈ ਲਵਾਂਗੇ ਅਤੇ ਜਦ ਤੱਕ ਉੱਥੇ ਨਾ ਜਾਈਏ ਅਸੀਂ ਨਹੀਂ ਜਾਣਦੇ ਕਾਹਦੇ ਨਾਲ ਯਹੋਵਾਹ ਦੀ ਉਪਾਸਨਾ ਕਰਨੀ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","ਪਰ ਯਹੋਵਾਹ ਨੇ ਫ਼ਿਰਊਨ ਦੇ ਮਨ ਨੂੰ ਕਠੋਰ ਹੋਣ ਦਿੱਤਾ। ਓਸ ਨੇ ਨਾ ਚਾਹਿਆ ਕਿ ਉਹ ਜਾਣ। ");
INSERT INTO pan_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","ਫ਼ਿਰਊਨ ਨੇ ਉਸ ਨੂੰ ਆਖਿਆ, ਮੇਰੇ ਕੋਲੋਂ ਨਿੱਕਲ ਜਾ ਅਤੇ ਧਿਆਨ ਰੱਖ ਤੂੰ ਫੇਰ ਕਦੀ ਮੇਰਾ ਮੂੰਹ ਨਾ ਵੇਖੀਂ ਕਿਉਂਕਿ ਜਿਸ ਦਿਨ ਤੂੰ ਮੇਰਾ ਮੂੰਹ ਵੇਖੇਂਗਾ ਤੂੰ ਮਰੇਂਗਾ। ");
INSERT INTO pan_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","ਤਦ ਮੂਸਾ ਨੇ ਆਖਿਆ, ਤੂੰ ਠੀਕ ਬੋਲਿਆ ਹੈਂ, ਮੈਂ ਫੇਰ ਕਦੀ ਤੇਰਾ ਮੂੰਹ ਨਾ ਵੇਖਾਂਗਾ। ");
INSERT INTO pan_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਆਖਿਆ, ਮੈਂ ਫ਼ਿਰਊਨ ਅਤੇ ਮਿਸਰੀਆਂ ਉੱਤੇ ਇੱਕ ਹੋਰ ਬਵਾ ਲਿਆਉਣ ਵਾਲਾ ਹਾਂ। ਉਸ ਦੇ ਪਿੱਛੋਂ ਉਹ ਤੁਹਾਨੂੰ ਇੱਥੋਂ ਜਾਣ ਦੇਵੇਗਾ ਅਤੇ ਜਦ ਉਹ ਤੁਹਾਨੂੰ ਜਾਣ ਦੇਵੇਗਾ ਤਾਂ ਉਹ ਇੱਥੋਂ ਧੱਕੇ ਮਾਰ-ਮਾਰ ਕੇ ਤੁਹਾਨੂੰ ਕੱਢ ਦੇਵੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","ਪਰਜਾ ਦੇ ਕੰਨਾਂ ਵਿੱਚ ਇਹ ਗੱਲਾਂ ਪਾ ਦੇ ਕਿ ਹਰ ਮਨੁੱਖ ਆਪਣੇ ਗੁਆਂਢੀ ਤੋਂ ਅਤੇ ਹਰ ਔਰਤ ਆਪਣੀ ਗੁਆਂਢਣ ਤੋਂ ਚਾਂਦੀ ਦੇ ਗਹਿਣੇ ਅਤੇ ਸੋਨੇ ਦੇ ਗਹਿਣੇ ਮੰਗ ਲਵੇ। ");
INSERT INTO pan_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","ਯਹੋਵਾਹ ਨੇ ਉਸ ਪਰਜਾ ਨੂੰ ਮਿਸਰੀਆਂ ਦੀ ਨਿਗਾਹ ਵਿੱਚ ਆਦਰ ਮਾਣ ਦਿੱਤਾ ਨਾਲੇ ਮੂਸਾ ਮਿਸਰ ਦੇਸ ਵਿੱਚ ਫ਼ਿਰਊਨ ਦੇ ਟਹਿਲੂਆਂ ਦੀ ਨਿਗਾਹ ਵਿੱਚ ਅਤੇ ਲੋਕਾਂ ਦੀ ਨਿਗਾਹ ਵਿੱਚ ਬਹੁਤ ਮਹਾਨ ਮਨੁੱਖ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","ਮੂਸਾ ਨੇ ਆਖਿਆ, ਯਹੋਵਾਹ ਇਸ ਤਰ੍ਹਾਂ ਆਖਦਾ ਹੈ ਕਿ ਮੈਂ ਅੱਧੀ ਕੁ ਰਾਤ ਨੂੰ ਮਿਸਰ ਦੇ ਵਿੱਚੋਂ ਦੀ ਲੰਘਣ ਵਾਲਾ ਹਾਂ ");
INSERT INTO pan_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","ਅਤੇ ਮਿਸਰ ਦੇਸ ਵਿੱਚ ਹਰ ਇੱਕ ਪਹਿਲੌਠਾ ਫ਼ਿਰਊਨ ਦੇ ਪਹਿਲੌਠੇ ਤੋਂ ਲੈ ਕੇ ਜਿਹੜਾ ਆਪਣੇ ਸਿੰਘਾਸਣ ਉੱਤੇ ਬੈਠਾ ਹੈ ਉਸ ਗੋਲੀ ਦੇ ਪਹਿਲੌਠੇ ਤੱਕ ਜਿਹੜੀ ਚੱਕੀ ਪਿੱਛੇ ਹੈ ਨਾਲੇ ਹਰ ਇੱਕ ਡੰਗਰ ਦਾ ਪਹਿਲੌਠਾ ਮਰ ਜਾਵੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","ਅਤੇ ਸਾਰੇ ਮਿਸਰ ਦੇਸ ਵਿੱਚ ਅਜਿਹਾ ਵੱਡਾ ਸਿਆਪਾ ਹੋਵੇਗਾ ਜੋ ਨਾ ਪਿੱਛੇ ਹੋਇਆ ਅਤੇ ਨਾ ਅੱਗੇ ਨੂੰ ਫੇਰ ਹੋਵੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","ਪਰ ਕਿਸੇ ਇਸਰਾਏਲੀ ਦੇ ਵਿਰੁੱਧ ਮਨੁੱਖ ਤੋਂ ਲੈ ਕੇ ਡੰਗਰ ਤੱਕ ਇੱਕ ਕੁੱਤਾ ਵੀ ਨਹੀਂ ਭੌਂਕੇਗਾ ਤਾਂ ਜੋ ਤੁਸੀਂ ਜਾਣੋ ਕਿ ਯਹੋਵਾਹ ਮਿਸਰੀਆਂ ਅਤੇ ਇਸਰਾਏਲੀਆਂ ਵਿੱਚ ਕਿਵੇਂ ਭਿੰਨ ਭੇਦ ਰੱਖਦਾ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","ਅਤੇ ਇਹ ਤੇਰੇ ਸਭ ਟਹਿਲੂਏ ਮੇਰੀ ਵੱਲ ਉੱਤਰਨਗੇ ਅਤੇ ਮੇਰੇ ਅੱਗੇ ਮੱਥੇ ਰਗੜਨਗੇ ਇਹ ਆਖ ਕੇ ਕਿ ਤੂੰ ਜਾ ਅਤੇ ਤੇਰੇ ਸਾਰੇ ਲੋਕ ਜਿਹੜੇ ਤੇਰੀ ਪੈਰਵੀ ਕਰਦੇ ਹਨ ਅਤੇ ਉਸ ਦੇ ਪਿੱਛੋਂ ਮੈਂ ਨਿੱਕਲ ਜਾਂਵਾਂਗਾ। ਫੇਰ ਉਹ ਫ਼ਿਰਊਨ ਦੇ ਕੋਲੋਂ ਕ੍ਰੋਧ ਦੀ ਅੱਗ ਵਿੱਚ ਨਿੱਕਲ ਗਿਆ। ");
INSERT INTO pan_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","ਤਦ ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਆਖਿਆ, ਫ਼ਿਰਊਨ ਤੁਹਾਡੀ ਨਾ ਸੁਣੇਗਾ ਤਾਂ ਜੋ ਮਿਸਰ ਦੇਸ ਵਿੱਚ ਮੇਰੇ ਅਚਰਜ਼ ਕੰਮ ਵਧ ਜਾਣ ");
INSERT INTO pan_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","ਤਾਂ ਮੂਸਾ ਅਤੇ ਹਾਰੂਨ ਨੇ ਇਹ ਸਾਰੇ ਅਚਰਜ਼ ਕੰਮ ਫ਼ਿਰਊਨ ਦੇ ਅੱਗੇ ਕੀਤੇ ਅਤੇ ਯਹੋਵਾਹ ਨੇ ਫ਼ਿਰਊਨ ਦਾ ਮਨ ਕਠੋਰ ਹੋਣ ਦਿੱਤਾ ਸੋ ਉਸ ਨੇ ਆਪਣੇ ਦੇਸੋਂ ਇਸਰਾਏਲੀਆਂ ਨੂੰ ਜਾਣ ਨਾ ਦਿੱਤਾ। ");
INSERT INTO pan_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","ਯਹੋਵਾਹ ਨੇ ਮਿਸਰ ਦੇਸ ਵਿੱਚ ਮੂਸਾ ਅਤੇ ਹਾਰੂਨ ਨੂੰ ਆਖਿਆ ਕਿ ");
INSERT INTO pan_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","ਇਹ ਮਹੀਨਾ ਤੁਹਾਡੇ ਮਹੀਨਿਆਂ ਦਾ ਅਰੰਭ ਹੋਵੇਗਾ ਅਤੇ ਇਹ ਤੁਹਾਡੇ ਸਾਲ ਦੇ ਮਹੀਨਿਆਂ ਵਿੱਚੋਂ ਪਹਿਲਾ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","ਇਸਰਾਏਲ ਦੀ ਸਾਰੀ ਮੰਡਲੀ ਨੂੰ ਇਹ ਬੋਲੋ ਕਿ ਇਸ ਮਹੀਨੇ ਦੀ ਦਸਵੀਂ ਨੂੰ ਇੱਕ-ਇੱਕ ਜਣਾ ਆਪੋ ਆਪਣੇ ਪੁਰਖਿਆਂ ਦੇ ਘਰਾਣੇ ਅਨੁਸਾਰ ਹਰ ਘਰ ਪਿੱਛੇ ਇੱਕ-ਇੱਕ ਲੇਲਾ ਲਵੇ। ");
INSERT INTO pan_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","ਜੇਕਰ ਕੋਈ ਟੱਬਰ ਇੱਕ ਲੇਲੇ ਲਈ ਛੋਟਾ ਹੋਵੇ ਤਾਂ ਉਹ ਅਤੇ ਉਸ ਦਾ ਗੁਆਂਢੀ ਜਿਹੜਾ ਉਸ ਦੇ ਘਰ ਕੋਲ ਰਹਿੰਦਾ ਹੈ ਪ੍ਰਾਣੀਆਂ ਦੇ ਲੇਖੇ ਦੇ ਅਨੁਸਾਰ ਲਵੇ ਅਤੇ ਤੁਸੀਂ ਇੱਕ ਮਨੁੱਖ ਦੇ ਖਾਣ ਦੇ ਅਨੁਸਾਰ ਲੇਲੇ ਦਾ ਲੇਖਾ ਠਹਿਰਾਇਓ। ");
INSERT INTO pan_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","ਤੁਹਾਡਾ ਲੇਲਾ ਬੱਜ ਤੋਂ ਰਹਿਤ ਅਤੇ ਇੱਕ ਸਾਲ ਦਾ ਨਰ ਹੋਵੇ। ਤੁਸੀਂ ਭੇਡਾਂ ਜਾਂ ਬੱਕਰੀਆਂ ਤੋਂ ਲਿਓ ");
INSERT INTO pan_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","ਅਤੇ ਤੁਸੀਂ ਉਸ ਨੂੰ ਇਸ ਮਹੀਨੇ ਦੀ ਚੌਧਵੀਂ ਤੱਕ ਰੱਖ ਛੱਡਣਾ ਅਤੇ ਇਸਰਾਏਲ ਦੀ ਮੰਡਲੀ ਦੀ ਸਾਰੀ ਸਭਾ ਸ਼ਾਮ ਨੂੰ ਉਸ ਨੂੰ ਕੱਟੇ ");
INSERT INTO pan_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","ਅਤੇ ਉਹ ਉਸ ਦੇ ਲਹੂ ਵਿੱਚੋਂ ਲੈ ਕੇ ਉਨ੍ਹਾਂ ਘਰਾਂ ਦੇ ਜਿੱਥੇ ਉਹ ਖਾਣਗੇ ਦੋਹੀਂ ਬਾਹੀਂ ਅਤੇ ਸੇਰੂ ਉੱਤੇ ਲਾਉਣ। ");
INSERT INTO pan_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","ਫੇਰ ਉਹ ਸ਼ਾਮ ਨੂੰ ਉਸੇ ਰਾਤ ਅੱਗ ਨਾਲ ਭੁੰਨ ਕੇ ਪਤੀਰੀ ਰੋਟੀ ਨਾਲ ਖਾਣ ਨਾਲੇ ਕੌੜੀ ਭਾਜੀ ਨਾਲ ਖਾਣ। ");
INSERT INTO pan_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","ਉਸ ਵਿੱਚੋਂ ਕੱਚਾ ਅਥਵਾ ਪਾਣੀ ਵਿੱਚ ਰਿੰਨ੍ਹਿਆ ਹੋਇਆ ਕਦੀ ਨਾ ਖਾਓ ਸਗੋਂ ਅੱਗ ਨਾਲ ਭੁੰਨਿਆ ਹੋਇਆ ਸਿਰ ਅਤੇ ਪੈਰਾਂ ਅਤੇ ਆਂਦਰਾਂ ਸਣੇ। ");
INSERT INTO pan_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","ਤੁਸੀਂ ਸਵੇਰ ਤੱਕ ਉਹ ਦੇ ਵਿੱਚੋਂ ਬਚਾ ਕੇ ਨਾ ਰੱਖਿਓ ਪਰ ਜੇ ਉਸ ਤੋਂ ਸਵੇਰ ਤੱਕ ਕੁਝ ਬਚ ਰਹੇ ਤਾਂ ਉਸ ਨੂੰ ਅੱਗ ਵਿੱਚ ਸਾੜ ਦਿਓ। ");
INSERT INTO pan_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","ਤੁਸੀਂ ਉਸ ਨੂੰ ਇਸ ਤਰ੍ਹਾਂ ਖਾਣਾ, ਆਪਣੇ ਲੱਕ ਬੰਨ੍ਹ ਕੇ ਅਤੇ ਆਪਣੀ ਜੁੱਤੀ ਪੈਰੀਂ ਪਾ ਕੇ ਅਤੇ ਆਪਣੀ ਲਾਠੀ ਆਪਣੇ ਹੱਥ ਵਿੱਚ ਲੈ ਕੇ ਉਹ ਨੂੰ ਛੇਤੀ-ਛੇਤੀ ਖਾਣਾ ਕਿਉਂਕਿ ਇਹ ਯਹੋਵਾਹ ਦਾ ਪਸਾਹ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","ਮੈਂ ਉਸ ਰਾਤ ਮਿਸਰ ਦੇਸ ਦੇ ਵਿੱਚ ਦੀ ਲੰਘਾਂਗਾ ਅਤੇ ਮਿਸਰ ਦੇਸ ਦੇ ਪਹਿਲੌਠੇ ਭਾਵੇਂ ਮਨੁੱਖ ਨੂੰ ਭਾਵੇਂ ਡੰਗਰ ਨੂੰ ਮਾਰ ਸੁੱਟਾਂਗਾ ਅਤੇ ਮਿਸਰ ਦੇ ਸਾਰੇ ਦੇਵਤਿਆਂ ਦਾ ਨਿਆਂ ਕਰਾਂਗਾ। ਮੈਂ ਯਹੋਵਾਹ ਹਾਂ। ");
INSERT INTO pan_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","ਅਤੇ ਉਹ ਲਹੂ ਤੁਹਾਡੇ ਲਈ ਘਰਾਂ ਉੱਤੇ ਜਿੱਥੇ ਤੁਸੀਂ ਹੋਵੋਗੇ ਨਿਸ਼ਾਨ ਹੋਵੇਗਾ ਅਤੇ ਜਦ ਮੈਂ ਲਹੂ ਨੂੰ ਵੇਖਾਂਗਾ ਮੈਂ ਤੁਹਾਡੇ ਉੱਤੋਂ ਦੀ ਲੰਘ ਜਾਂਵਾਂਗਾ ਅਤੇ ਤੁਹਾਡੇ ਉੱਤੇ ਕੋਈ ਬਵਾ ਜਦ ਮੈਂ ਮਿਸਰ ਦੇਸ ਨੂੰ ਮਾਰਾਂਗਾ ਨਾ ਪਵੇਗੀ ਜਿਹੜੀ ਤੁਹਾਡਾ ਨਾਸ ਕਰੇ। ");
INSERT INTO pan_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","ਅਤੇ ਇਹ ਦਿਨ ਤੁਹਾਡੇ ਲਈ ਇੱਕ ਯਾਦਗਾਰ ਹੋਵੇਗਾ ਅਤੇ ਤੁਸੀਂ ਇਹ ਦਿਨ ਯਹੋਵਾਹ ਲਈ ਪਰਬ ਕਰਕੇ ਮਨਾਇਓ ਅਤੇ ਆਪਣੀਆਂ ਪੀੜ੍ਹੀਆਂ ਵਿੱਚ ਇਸ ਨੂੰ ਸਦਾ ਦੀ ਬਿਧੀ ਦਾ ਪਰਬ ਮਨਾਇਓ। ");
INSERT INTO pan_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","ਤੁਸੀਂ ਸੱਤ ਦਿਨ ਤੱਕ ਪਤੀਰੀ ਰੋਟੀ ਖਾਓ। ਪਹਿਲੇ ਹੀ ਦਿਨ ਖ਼ਮੀਰ ਆਪਣਿਆਂ ਘਰਾਂ ਤੋਂ ਬਾਹਰ ਕੱਢ ਦੇਣਾ ਕਿਉਂਕਿ ਜਿਹੜਾ ਪਹਿਲੇ ਦਿਨ ਤੋਂ ਸੱਤਵੇਂ ਦਿਨ ਤੱਕ ਕਦੀ ਖ਼ਮੀਰੀ ਰੋਟੀ ਖਾਵੇਗਾ ਉਹ ਪ੍ਰਾਣੀ ਇਸਰਾਏਲ ਵਿੱਚੋਂ ਛੇਕਿਆ ਜਾਵੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","ਅਤੇ ਪਹਿਲੇ ਦਿਨ ਤੁਹਾਡੀ ਪਵਿੱਤਰ ਸਭਾ ਹੋਵੇਗੀ ਅਤੇ ਸੱਤਵੇਂ ਦਿਨ ਵੀ ਤੁਹਾਡੀ ਪਵਿੱਤਰ ਸਭਾ ਹੋਵੇਗੀ ਇਨ੍ਹਾਂ ਵਿੱਚ ਕੋਈ ਕੰਮ-ਧੰਦਾ ਨਾ ਕੀਤਾ ਜਾਵੇ ਨਿਰਾ ਉਹੋ ਜਿਹੜਾ ਹਰ ਇੱਕ ਪ੍ਰਾਣੀ ਦੇ ਖਾਣ ਲਈ ਹੋਵੇ, ਤੁਸੀਂ ਓਨਾ ਹੀ ਕਰਿਓ। ");
INSERT INTO pan_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","ਅਤੇ ਤੁਸੀਂ ਇਹ ਪਤੀਰੀ ਰੋਟੀ ਦਾ ਪਰਬ ਮਨਾਇਆ ਕਰੋ ਕਿਉਂਕਿ ਇਸੇ ਹੀ ਦਿਨ ਮੈਂ ਤੁਹਾਡੀਆਂ ਸੈਨਾਂ ਨੂੰ ਮਿਸਰ ਦੇਸ ਤੋਂ ਬਾਹਰ ਕੱਢ ਲਿਆਇਆ ਸੀ ਇਸ ਕਰਕੇ ਤੁਸੀਂ ਇਹ ਦਿਨ ਆਪਣੀਆਂ ਪੀੜ੍ਹੀਆਂ ਤੱਕ ਸਦਾ ਦੀ ਬਿਧੀ ਲਈ ਮਨਾਇਆ ਕਰੋ। ");
INSERT INTO pan_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","ਪਹਿਲੇ ਮਹੀਨੇ ਦੀ ਚੌਧਵੀਂ ਦੀ ਸ਼ਾਮ ਤੋਂ ਇੱਕੀ ਤਾਰੀਖ਼ ਦੀ ਸ਼ਾਮ ਤੱਕ ਤੁਸੀਂ ਪਤੀਰੀ ਰੋਟੀ ਖਾਓ। ");
INSERT INTO pan_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","ਸੱਤਾਂ ਦਿਨਾਂ ਤੱਕ ਤੁਹਾਡਿਆਂ ਘਰਾਂ ਵਿੱਚ ਖ਼ਮੀਰ ਨਾ ਲੱਭੇ ਕਿਉਂਕਿ ਜਿਹੜਾ ਖ਼ਮੀਰੀ ਚੀਜ਼ ਖਾਵੇਗਾ ਉਹ ਪ੍ਰਾਣੀ ਇਸਰਾਏਲ ਦੀ ਮੰਡਲੀ ਵਿੱਚੋਂ ਬਾਹਰ ਕੱਢਿਆ ਜਾਵੇਗਾ ਭਾਵੇਂ ਓਪਰਾ ਹੋਵੇ ਭਾਵੇਂ ਦੇਸ ਵਿੱਚ ਜੰਮਿਆ ਹੋਇਆ ਹੋਵੇ। ");
INSERT INTO pan_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","ਤੁਸੀਂ ਕੋਈ ਖ਼ਮੀਰੀ ਵਸਤ ਨਾ ਖਾਓ ਅਤੇ ਤੁਸੀਂ ਆਪਣਿਆਂ ਸਾਰਿਆਂ ਟਿਕਾਣਿਆਂ ਵਿੱਚ ਪਤੀਰੀ ਰੋਟੀ ਖਾਇਓ। ");
INSERT INTO pan_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","ਤਦ ਮੂਸਾ ਨੇ ਇਸਰਾਏਲ ਦੇ ਸਾਰੇ ਬਜ਼ੁਰਗਾਂ ਨੂੰ ਬੁਲਵਾ ਕੇ ਆਖਿਆ, ਆਪੋ ਆਪਣੇ ਟੱਬਰ ਅਨੁਸਾਰ ਲੇਲਿਆਂ ਨੂੰ ਕੱਢ ਲਵੋ ਅਤੇ ਪਸਾਹ ਲਈ ਵੱਢੋ। ");
INSERT INTO pan_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","ਤੁਸੀਂ ਇੱਕ ਜੂਫ਼ੇ ਦੀ ਗੁੱਛੀ ਲੈ ਕੇ ਉਸ ਨੂੰ ਲਹੂ ਵਿੱਚ ਜਿਹੜਾ ਭਾਂਡੇ ਵਿੱਚ ਹੈ ਡਬੋ ਕੇ, ਸੇਰੂ ਅਤੇ ਦਰਵਾਜ਼ੇ ਦੀਆਂ ਦੋਹਾਂ ਬਾਹੀਆਂ ਉੱਤੇ ਲਾਓ ਅਤੇ ਤੁਹਾਡੇ ਵਿੱਚੋਂ ਕੋਈ ਸਵੇਰ ਤੱਕ ਆਪਣੇ ਘਰ ਦੇ ਦਰਵਾਜ਼ੇ ਤੋਂ ਬਾਹਰ ਨਾ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","ਕਿਉਂਕਿ ਯਹੋਵਾਹ ਮਿਸਰੀਆਂ ਦੇ ਮਾਰਨ ਲਈ ਲੰਘੇਗਾ ਅਤੇ ਜਦ ਉਹ ਸੇਰੂ ਅਤੇ ਦੋਹਾਂ ਬਾਹੀਆਂ ਉੱਤੇ ਲਹੂ ਨੂੰ ਵੇਖੇਗਾ ਤਾਂ ਯਹੋਵਾਹ ਉਸ ਦਰਵਾਜ਼ੇ ਤੋਂ ਪਾਸਾ ਦੇ ਕੇ ਲੰਘ ਜਾਵੇਗਾ ਅਤੇ ਨਾਸ ਕਰਨ ਵਾਲੇ ਨੂੰ ਤੁਹਾਡੇ ਮਾਰਨ ਲਈ ਤੁਹਾਡਿਆਂ ਘਰਾਂ ਵਿੱਚ ਨਾ ਆਉਣ ਦੇਵੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","ਤੁਸੀਂ ਆਪਣੇ ਅਤੇ ਆਪਣੇ ਪੁੱਤਰਾਂ ਲਈ ਇਸ ਗੱਲ ਨੂੰ ਸਦਾ ਦੀ ਬਿਧੀ ਮਨਾਇਆ ਕਰੋ। ");
INSERT INTO pan_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","ਅਤੇ ਇਸ ਤਰ੍ਹਾਂ ਹੋਵੇ ਕਿ ਜਦ ਤੁਸੀਂ ਉਸ ਦੇਸ ਵਿੱਚ ਵੜੋ ਜਿਹੜਾ ਯਹੋਵਾਹ ਆਪਣੇ ਕੀਤੇ ਹੋਏ ਬਚਨ ਦੇ ਅਨੁਸਾਰ ਤੁਹਾਨੂੰ ਦੇਵੇਗਾ ਤਾਂ ਤੁਸੀਂ ਇਸ ਰੀਤੀ ਨੂੰ ਮਨਾਇਆ ਕਰਿਓ ");
INSERT INTO pan_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","ਅਤੇ ਅਜਿਹਾ ਹੋਵੇਗਾ ਕਿ ਜਾਂ ਤੁਹਾਡੇ ਪੁੱਤਰ ਤੁਹਾਨੂੰ ਪੁੱਛਣ ਕਿ ਤੁਹਾਡਾ ਇਸ ਰੀਤੀ ਤੋਂ ਕੀ ਮਤਲਬ ਹੈ? ");
INSERT INTO pan_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","ਤਾਂ ਤੁਸੀਂ ਆਖਿਓ ਕਿ ਇਹ ਯਹੋਵਾਹ ਦੀ ਪਸਾਹ ਦਾ ਬਲੀਦਾਨ ਹੈ ਜੋ ਮਿਸਰ ਵਿੱਚ ਇਸਰਾਏਲੀਆਂ ਦੇ ਘਰਾਂ ਦੇ ਉੱਤੋਂ ਦੀ ਲੰਘਿਆ ਜਦ ਉਸ ਨੇ ਮਿਸਰੀਆਂ ਨੂੰ ਮਾਰਿਆ ਪਰ ਸਾਡੇ ਘਰਾਂ ਨੂੰ ਬਚਾਇਆ। ਤਾਂ ਪਰਜਾ ਨੇ ਸੀਸ ਨਿਵਾ ਕੇ ਮੱਥਾ ਟੇਕਿਆ। ");
INSERT INTO pan_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","ਫੇਰ ਇਸਰਾਏਲੀਆਂ ਨੇ ਜਾ ਕੇ ਓਵੇਂ ਹੀ ਕੀਤਾ ਜਿਵੇਂ ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਅਤੇ ਹਾਰੂਨ ਨੂੰ ਹੁਕਮ ਦਿੱਤਾ ਸੀ ਤਿਵੇਂ ਹੀ ਕੀਤਾ। ");
INSERT INTO pan_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","ਤਾਂ ਅੱਧੀ ਰਾਤ ਨੂੰ ਇਸ ਤਰ੍ਹਾਂ ਹੋਇਆ ਕਿ ਯਹੋਵਾਹ ਨੇ ਮਿਸਰ ਦੇਸ ਦੇ ਹਰ ਇੱਕ ਪਹਿਲੌਠੇ ਨੂੰ ਫ਼ਿਰਊਨ ਦੇ ਪਹਿਲੌਠੇ ਤੋਂ ਲੈ ਕੇ ਜਿਹੜਾ ਉਹ ਦੇ ਸਿੰਘਾਸਣ ਉੱਤੇ ਬੈਠਣ ਵਾਲਾ ਸੀ ਉਸ ਬੰਦੀ ਦੇ ਪਹਿਲੌਠੇ ਤੱਕ ਜਿਹੜਾ ਭੋਰੇ ਵਿੱਚ ਸੀ ਨਾਲੇ ਡੰਗਰ ਦੇ ਹਰ ਇੱਕ ਪਹਿਲੌਠੇ ਨੂੰ ਮਾਰ ਸੁੱਟਿਆ। ");
INSERT INTO pan_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","ਤਾਂ ਫ਼ਿਰਊਨ ਉਸ ਰਾਤ ਨੂੰ ਉੱਠਿਆ ਨਾਲੇ ਉਸ ਦੇ ਸਾਰੇ ਟਹਿਲੂਏ ਅਤੇ ਸਾਰੇ ਮਿਸਰੀ ਅਤੇ ਮਿਸਰ ਵਿੱਚ ਵੱਡਾ ਸਿਆਪਾ ਹੋਇਆ ਕਿਉਂਕਿ ਕੋਈ ਘਰ ਨਹੀਂ ਸੀ ਜਿੱਥੇ ਕੋਈ ਮਰਿਆ ਨਾ ਹੋਵੇ। ");
INSERT INTO pan_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","ਤਾਂ ਉਸ ਨੇ ਮੂਸਾ ਅਤੇ ਹਾਰੂਨ ਨੂੰ ਰਾਤੀਂ ਬੁਲਵਾ ਕੇ ਆਖਿਆ, ਉੱਠੋ ਅਤੇ ਮੇਰੇ ਲੋਕਾਂ ਵਿੱਚੋਂ ਨਿੱਕਲ ਜਾਓ ਤੁਸੀਂ ਵੀ ਅਤੇ ਇਸਰਾਏਲੀ ਵੀ ਅਤੇ ਜਾ ਕੇ ਆਪਣੀ ਗੱਲ ਦੇ ਅਨੁਸਾਰ ਯਹੋਵਾਹ ਦੀ ਉਪਾਸਨਾ ਕਰੋ। ");
INSERT INTO pan_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","ਆਪਣੇ ਇੱਜੜ ਵੀ ਅਤੇ ਆਪਣੇ ਵੱਗ ਵੀ ਲੈ ਜਾਓ ਜਿਵੇਂ ਤੁਸੀਂ ਬੋਲੇ ਸੀ ਅਤੇ ਚਲੇ ਜਾਓ, ਨਾਲੇ ਮੈਨੂੰ ਵੀ ਅਸੀਸ ਦੇਣੀ। ");
INSERT INTO pan_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","ਅਤੇ ਉਨ੍ਹਾਂ ਲੋਕਾਂ ਉੱਤੇ ਮਿਸਰੀ ਕੱਸ ਪਾਉਣ ਲੱਗੇ ਕਿ ਉਹ ਉਨ੍ਹਾਂ ਨੂੰ ਉਸ ਦੇਸ ਵਿੱਚੋਂ ਛੇਤੀ ਕੱਢ ਲੈਣ ਕਿਉਂਕਿ ਉਨ੍ਹਾਂ ਨੇ ਆਖਿਆ, ਅਸੀਂ ਸਾਰੇ ਮਰ ਗਏ! ");
INSERT INTO pan_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","ਉਨ੍ਹਾਂ ਲੋਕਾਂ ਨੇ ਗੁੰਨ੍ਹਿਆ ਹੋਇਆ ਆਟਾ ਖ਼ਮੀਰ ਹੋਣ ਤੋਂ ਪਹਿਲਾਂ ਹੀ ਪਰਾਤੜਿਆਂ ਸਣੇ ਆਪਣਿਆਂ ਲੀੜਿਆਂ ਵਿੱਚ ਬੰਨ੍ਹ ਕੇ ਆਪਣੇ ਮੋਢਿਆਂ ਉੱਤੇ ਚੁੱਕ ਲਿਆ ");
INSERT INTO pan_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","ਅਤੇ ਇਸਰਾਏਲੀਆਂ ਨੇ ਮੂਸਾ ਦੇ ਬੋਲਣ ਦੇ ਅਨੁਸਾਰ ਕੀਤਾ ਅਤੇ ਮਿਸਰੀਆਂ ਤੋਂ ਚਾਂਦੀ ਦੇ ਗਹਿਣੇ ਅਤੇ ਸੋਨੇ ਦੇ ਗਹਿਣੇ ਅਤੇ ਲੀੜੇ ਉਨ੍ਹਾਂ ਨੇ ਮੰਗ ਲਏ। ");
INSERT INTO pan_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","ਯਹੋਵਾਹ ਨੇ ਉਨ੍ਹਾਂ ਲੋਕਾਂ ਨੂੰ ਮਿਸਰੀਆਂ ਦੀ ਨਿਗਾਹ ਵਿੱਚ ਆਦਰ ਮਾਣ ਦਿੱਤਾ ਸੋ ਉਨ੍ਹਾਂ ਨੇ ਜੋ ਮੰਗਿਆ ਉਨ੍ਹਾਂ ਨੇ ਦੇ ਦਿੱਤਾ। ਇਸ ਤਰ੍ਹਾਂ ਉਨ੍ਹਾਂ ਨੇ ਮਿਸਰੀਆਂ ਨੂੰ ਲੁੱਟ ਲਿਆ। ");
INSERT INTO pan_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","ਇਸਰਾਏਲੀਆਂ ਨੇ ਰਾਮਸੇਸ ਤੋਂ ਸੁੱਕੋਥ ਵੱਲ ਕੂਚ ਕੀਤਾ ਅਤੇ ਨਿਆਣਿਆਂ ਤੋਂ ਬਿਨਾਂ ਛੇ ਕੁ ਲੱਖ ਮਨੁੱਖ ਪਿਆਦੇ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","ਉਨ੍ਹਾਂ ਦੇ ਨਾਲ ਮਿਲੀ-ਜੁਲੀ ਭੀੜ ਵੀ ਗਈ ਨਾਲੇ ਇੱਜੜ ਅਤੇ ਚੌਣੇ ਅਰਥਾਤ ਢੇਰ ਸਾਰੇ ਪਸ਼ੂ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","ਅਤੇ ਉਨ੍ਹਾਂ ਨੇ ਗੁੰਨ੍ਹੇ ਹੋਏ ਆਟੇ ਦੀਆਂ ਜਿਹੜਾ ਮਿਸਰ ਤੋਂ ਲਿਆਏ ਸਨ ਪਤੀਰੀਆਂ ਰੋਟੀਆਂ ਪਕਾਈਆਂ ਕਿਉਂ ਜੋ ਉਹ ਇਸ ਲਈ ਖ਼ਮੀਰ ਨਹੀਂ ਹੋਇਆ ਸੀ ਕਿ ਉਹ ਮਿਸਰੋਂ ਧੱਕੇ ਗਏ ਸਨ ਅਤੇ ਉੱਥੇ ਠਹਿਰ ਨਾ ਸਕੇ ਨਾ ਆਪਣੇ ਲਈ ਰੋਟੀ ਬਣਾ ਸਕੇ। ");
INSERT INTO pan_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","ਇਸਰਾਏਲੀਆਂ ਦੇ ਮਿਸਰ ਵਿੱਚ ਵਸੇਬੇ ਦਾ ਸਮਾਂ ਚਾਰ ਸੌ ਤੀਹ ਸਾਲ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","ਚਾਰ ਸੌ ਤੀਹ ਸਾਲਾਂ ਦੇ ਅੰਤ ਵਿੱਚ ਇਸ ਤਰ੍ਹਾਂ ਹੋਇਆ ਕਿ ਉਸੇ ਦਿਨ ਯਹੋਵਾਹ ਦੀਆਂ ਸਾਰੀਆਂ ਸੈਨਾਂ ਮਿਸਰ ਦੇਸ ਤੋਂ ਨਿੱਕਲ ਗਈਆਂ। ");
INSERT INTO pan_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","ਉਨ੍ਹਾਂ ਨੂੰ ਮਿਸਰ ਦੇਸ ਤੋਂ ਕੱਢਣ ਦੇ ਕਾਰਨ ਇਹ ਇੱਕ ਰਾਤ ਹੈ ਜਿਹੜੀ ਯਹੋਵਾਹ ਲਈ ਮਨਾਉਣ ਵਾਲੀ ਹੈ। ਇਹੋ ਯਹੋਵਾਹ ਦੀ ਉਹ ਰਾਤ ਹੈ ਜਿਹੜੀ ਸਾਰੇ ਇਸਰਾਏਲੀਆਂ ਦੀਆਂ ਕੁੱਲ ਪੀੜ੍ਹੀਆਂ ਤੱਕ ਮਨਾਉਣ ਵਾਲੀ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਅਤੇ ਹਾਰੂਨ ਨੂੰ ਆਖਿਆ, ਇਹ ਪਸਾਹ ਦੀ ਬਿਧੀ ਹੈ। ਕੋਈ ਓਪਰਾ ਉਸ ਵਿੱਚੋਂ ਨਾ ਖਾਵੇ ");
INSERT INTO pan_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","ਪਰ ਮਨੁੱਖ ਦਾ ਹਰ ਟਹਿਲੂਆ ਚਾਂਦੀ ਨਾਲ ਮੁੱਲ ਲਿਆ ਹੋਇਆ ਜਦ ਉਸ ਦੀ ਸੁੰਨਤ ਕਰ ਦਿੱਤੀ ਹੋਵੇ ਤਦ ਉਹ ਉਸ ਵਿੱਚੋਂ ਖਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","ਪਰਦੇਸੀ ਅਤੇ ਮਜ਼ਦੂਰ ਉਸ ਵਿੱਚੋਂ ਨਾ ਖਾਣ। ");
INSERT INTO pan_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","ਇੱਕੋ ਹੀ ਘਰ ਵਿੱਚ ਉਹ ਖਾਧਾ ਜਾਵੇ। ਤੁਸੀਂ ਉਸ ਘਰ ਤੋਂ ਬਾਹਰ ਮਾਸ ਵਿੱਚੋਂ ਕੁਝ ਨਾ ਲੈ ਜਾਇਓ, ਨਾ ਉਸ ਦੀ ਕੋਈ ਹੱਡੀ ਤੋੜਿਓ। ");
INSERT INTO pan_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","ਇਸਰਾਏਲ ਦੀ ਸਾਰੀ ਮੰਡਲੀ ਉਸ ਨੂੰ ਮਨਾਇਆ ਕਰੇ। ");
INSERT INTO pan_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","ਜਦ ਤੁਹਾਡੇ ਨਾਲ ਕੋਈ ਓਪਰਾ ਟਿਕਿਆ ਹੋਇਆ ਹੋਵੇ ਅਤੇ ਉਹ ਯਹੋਵਾਹ ਲਈ ਪਸਾਹ ਕਰਨੀ ਚਾਹੇ ਤਦ ਉਸ ਦੇ ਹਰ ਇੱਕ ਨਰ ਦੀ ਸੁੰਨਤ ਕੀਤੀ ਜਾਵੇ ਫੇਰ ਉਹ ਨੇੜੇ ਆ ਕੇ ਉਹ ਨੂੰ ਮਨਾਵੇ ਅਤੇ ਇਸ ਤਰ੍ਹਾਂ ਉਹ ਦੇਸ ਦੇ ਜੰਮੇ ਹੋਏ ਵਾਂਗੂੰ ਹੋਵੇਗਾ ਪਰ ਅਸੁੰਨਤੀ ਨਰ ਉਸ ਵਿੱਚੋਂ ਨਾ ਖਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","ਦੇਸੀ ਅਤੇ ਪਰਦੇਸੀ ਲਈ ਜਿਹੜਾ ਤੁਹਾਡੇ ਵਿੱਚ ਵੱਸਦਾ ਹੈ ਇੱਕੋ ਹੀ ਬਿਵਸਥਾ ਹੋਵੇਗੀ। ");
INSERT INTO pan_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","ਤਾਂ ਸਾਰੇ ਇਸਰਾਏਲੀਆਂ ਨੇ ਓਵੇਂ ਹੀ ਕੀਤਾ ਜਿਵੇਂ ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਅਤੇ ਹਾਰੂਨ ਨੂੰ ਹੁਕਮ ਦਿੱਤਾ ਸੀ ਉਨ੍ਹਾਂ ਨੇ ਤਿਵੇਂ ਹੀ ਕੀਤਾ। ");
INSERT INTO pan_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","ਅਤੇ ਉਸੇ ਦਿਨ ਇਸ ਤਰ੍ਹਾਂ ਹੋਇਆ ਕਿ ਯਹੋਵਾਹ ਇਸਰਾਏਲੀਆਂ ਦੇ ਦਲਾਂ ਦੇ ਦਲ ਮਿਸਰ ਦੇਸ ਤੋਂ ਕੱਢ ਲਿਆਇਆ। ");
INSERT INTO pan_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","ਯਹੋਵਾਹ ਮੂਸਾ ਨਾਲ ਬੋਲਿਆ ਕਿ ");
INSERT INTO pan_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","ਸਾਰੇ ਪਹਿਲੌਠੇ ਜਿਹੜੇ ਇਸਰਾਏਲੀਆਂ ਵਿੱਚ ਕੁੱਖ ਨੂੰ ਖੋਲ੍ਹਦੇ ਹਨ ਮੇਰੇ ਲਈ ਪਵਿੱਤਰ ਹੋਣ ਭਾਵੇਂ ਆਦਮੀ ਦੇ ਭਾਵੇਂ ਡੰਗਰ ਦੇ ਉਹ ਮੇਰੇ ਹਨ। ");
INSERT INTO pan_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","ਤਾਂ ਮੂਸਾ ਨੇ ਪਰਜਾ ਨੂੰ ਆਖਿਆ, ਤੁਸੀਂ ਇਹ ਦਿਨ ਚੇਤੇ ਰੱਖੋ ਜਿਸ ਵਿੱਚ ਤੁਸੀਂ ਮਿਸਰ ਤੋਂ ਗ਼ੁਲਾਮੀ ਦੇ ਘਰ ਤੋਂ ਬਾਹਰ ਆਏ ਕਿਉਂਕਿ ਯਹੋਵਾਹ ਤੁਹਾਨੂੰ ਹੱਥ ਦੇ ਬਲ ਨਾਲ ਉੱਥੋਂ ਕੱਢ ਲਿਆਇਆ। ਖ਼ਮੀਰੀ ਰੋਟੀ ਨਾ ਖਾਧੀ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","ਤੁਸੀਂ ਅਬੀਬ ਦੇ ਮਹੀਨੇ ਅੱਜ ਦੇ ਦਿਨ ਬਾਹਰ ਨਿੱਕਲ ਆਏ ਹੋ। ");
INSERT INTO pan_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","ਅਤੇ ਇਸ ਤਰ੍ਹਾਂ ਹੋਵੇਗਾ ਕਿ ਜਦ ਯਹੋਵਾਹ ਤੁਹਾਨੂੰ ਕਨਾਨੀਆਂ ਹਿੱਤੀਆਂ ਅਮੋਰੀਆਂ ਹਿੱਵੀਆਂ ਅਤੇ ਯਬੂਸੀਆਂ ਦੇ ਦੇਸ ਵਿੱਚ ਜਿਹੜਾ ਤੁਹਾਡੇ ਪੁਰਖਿਆਂ ਨਾਲ ਸਹੁੰ ਖਾ ਕੇ ਤੁਹਾਨੂੰ ਦੇਣ ਲਈ ਆਖਿਆ ਸੀ ਅਤੇ ਜਿਹੜੇ ਵਿੱਚ ਦੁੱਧ ਅਤੇ ਸ਼ਹਿਦ ਵਗਦਾ ਹੈ ਲਿਆਵੇਗਾ ਤਾਂ ਤੁਸੀਂ ਇਸ ਮਹੀਨੇ ਵਿੱਚ ਇਹ ਉਪਾਸਨਾ ਕਰਿਓ। ");
INSERT INTO pan_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","ਸੱਤਾਂ ਦਿਨਾਂ ਤੱਕ ਪਤੀਰੀ ਰੋਟੀ ਖਾਣੀ ਅਤੇ ਸੱਤਵੇਂ ਦਿਨ ਯਹੋਵਾਹ ਦਾ ਪਰਬ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","ਪਤੀਰੀ ਰੋਟੀ ਸੱਤਾਂ ਦਿਨਾਂ ਤੱਕ ਖਾਧੀ ਜਾਵੇ ਅਤੇ ਕੋਈ ਖ਼ਮੀਰ ਤੁਹਾਡੇ ਕੋਲ ਨਾ ਵੇਖਿਆ ਜਾਵੇ ਨਾ ਖ਼ਮੀਰ ਤੁਹਾਡੀਆਂ ਸਾਰੀਆਂ ਹੱਦਾਂ ਵਿੱਚ ਵੇਖਿਆ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","ਤੁਸੀਂ ਉਸ ਦਿਨ ਆਪਣੇ ਪੁੱਤਰਾਂ ਨੂੰ ਇਹ ਦੱਸੋ ਕਿ ਕਾਰਨ ਇਹ ਹੈ ਕਿ ਯਹੋਵਾਹ ਨੇ ਸਾਨੂੰ ਮਿਸਰ ਤੋਂ ਕੱਢਿਆ। ");
INSERT INTO pan_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","ਇਹ ਤੁਹਾਡੇ ਹੱਥਾਂ ਉੱਤੇ ਨਿਸ਼ਾਨ ਅਤੇ ਤੁਹਾਡੇ ਨੇਤਰਾਂ ਦੇ ਵਿੱਚ ਯਾਦਗਿਰੀ ਲਈ ਹੋਵੇਗਾ ਤਾਂ ਜੋ ਯਹੋਵਾਹ ਦੀ ਬਿਵਸਥਾ ਤੁਹਾਡੇ ਮੂੰਹ ਵਿੱਚ ਰਹੇ ਕਿਉਂਕਿ ਯਹੋਵਾਹ ਨੇ ਤਕੜੇ ਹੱਥ ਨਾਲ ਤੁਹਾਨੂੰ ਮਿਸਰੋਂ ਕੱਢਿਆ। ");
INSERT INTO pan_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","ਤੁਸੀਂ ਇਸ ਬਿਧੀ ਨੂੰ ਠਹਿਰਾਏ ਹੋਏ ਸਮੇਂ ਉੱਤੇ ਸਾਲ ਦੇ ਸਾਲ ਮਨਾਇਆ ਕਰੋ। ");
INSERT INTO pan_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","ਤਾਂ ਇਸ ਤਰ੍ਹਾਂ ਹੋਵੇਗਾ ਕਿ ਜਦ ਯਹੋਵਾਹ ਤੁਹਾਨੂੰ ਕਨਾਨ ਦੇਸ ਵਿੱਚ ਲਿਆਵੇ ਜਿਵੇਂ ਉਸ ਨੇ ਤੁਹਾਡੇ ਨਾਲ ਅਤੇ ਤੁਹਾਡੇ ਪੁਰਖਿਆਂ ਨਾਲ ਸਹੁੰ ਖਾਧੀ ਹੈ ਅਤੇ ਉਹ ਤੁਹਾਨੂੰ ਇਹ ਦੇਵੇ। ");
INSERT INTO pan_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","ਤਾਂ ਹਰ ਇੱਕ ਕੁੱਖ ਦਾ ਖੋਲ੍ਹਣ ਵਾਲਾ ਯਹੋਵਾਹ ਲਈ ਵੱਖਰਾ ਰੱਖੋ ਨਾਲ ਡੰਗਰਾਂ ਵਿੱਚੋਂ ਹਰ ਪਹਿਲੌਠਾ ਬੱਚਾ ਜਿਹੜਾ ਤੁਹਾਡਾ ਹੋਵੇ। ਨਰ ਯਹੋਵਾਹ ਲਈ ਹੋਣਗੇ। ");
INSERT INTO pan_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","ਹਰ ਗਧੇ ਦੇ ਪਹਿਲੌਠੇ ਨੂੰ ਲੇਲੇ ਨਾਲ ਛੁਡਾ ਲਵੋ ਪਰ ਜੇਕਰ ਨਾ ਛੁਡਾਉਣਾ ਹੋਵੇ ਤਾਂ ਉਸ ਦੀ ਧੌਣ ਤੋੜ ਸੁੱਟੋ ਅਤੇ ਆਪਣੇ ਪੁੱਤਰਾਂ ਵਿੱਚੋਂ ਆਦਮੀ ਦੇ ਹਰ ਪਹਿਲੌਠੇ ਨੂੰ ਛੁਡਾ ਲਵੋ। ");
INSERT INTO pan_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","ਇਸ ਤਰ੍ਹਾਂ ਹੋਵੇਗਾ ਕਿ ਜਦ ਅੱਗੇ ਨੂੰ ਤੁਹਾਡੇ ਪੁੱਤਰ ਤੁਹਾਡੇ ਤੋਂ ਪੁੱਛਣ ਕਿ ਇਹ ਕੀ ਹੈ? ਤਾਂ ਤੁਸੀਂ ਉਨ੍ਹਾਂ ਨੂੰ ਆਖੋ ਕਿ ਯਹੋਵਾਹ ਨੇ ਸਾਨੂੰ ਮਿਸਰ ਤੋਂ ਗ਼ੁਲਾਮੀ ਦੇ ਘਰ ਤੋਂ ਹੱਥ ਦੇ ਬਲ ਨਾਲ ਕੱਢਿਆ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","ਫੇਰ ਇਸ ਤਰ੍ਹਾਂ ਹੋਇਆ ਕਿ ਜਾਂ ਫ਼ਿਰਊਨ ਨੇ ਸਾਡਾ ਬਾਹਰ ਜਾਣਾ ਔਖਾ ਕਰ ਦਿੱਤਾ ਤਾਂ ਯਹੋਵਾਹ ਨੇ ਮਿਸਰ ਦੇਸ ਦੇ ਸਾਰੇ ਪਹਿਲੌਠਿਆਂ ਨੂੰ ਮਾਰ ਸੁੱਟਿਆ ਆਦਮੀ ਦੇ ਪਹਿਲੌਠੇ ਤੋਂ ਲੈ ਕੇ ਡੰਗਰ ਦੇ ਪਹਿਲੌਠੇ ਤੱਕ। ਇਸ ਲਈ ਅਸੀਂ ਯਹੋਵਾਹ ਨੂੰ ਨਰਾਂ ਵਿੱਚੋਂ ਹਰ ਇੱਕ ਕੁੱਖ ਦਾ ਖੋਲ੍ਹਣ ਵਾਲਾ ਬਲੀ ਦਿੰਦੇ ਹਾਂ ਅਤੇ ਆਪਣੇ ਪੁੱਤਰਾਂ ਵਿੱਚੋਂ ਹਰ ਪਹਿਲੌਠੇ ਨੂੰ ਛੁਡਾ ਲੈਂਦੇ ਹਾਂ। ");
INSERT INTO pan_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","ਇਹ ਤੁਹਾਡੇ ਹੱਥਾਂ ਵਿੱਚ ਨਿਸ਼ਾਨ ਅਤੇ ਤੁਹਾਡਿਆਂ ਨੇਤਰਾਂ ਦੇ ਵਿਚਕਾਰ ਇੱਕ ਟਿੱਕੇ ਜਿਹਾ ਹੋਵੇਗਾ ਕਿਉਂਕਿ ਯਹੋਵਾਹ ਸਾਨੂੰ ਹੱਥ ਦੇ ਬਲ ਨਾਲ ਮਿਸਰ ਤੋਂ ਕੱਢ ਲਿਆਇਆ। ");
INSERT INTO pan_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","ਤਾਂ ਇਸ ਤਰ੍ਹਾਂ ਹੋਇਆ ਕਿ ਜਾਂ ਫ਼ਿਰਊਨ ਨੇ ਲੋਕਾਂ ਨੂੰ ਜਾਣ ਦਿੱਤਾ ਤਾਂ ਪਰਮੇਸ਼ੁਰ ਉਨ੍ਹਾਂ ਨੂੰ ਫ਼ਲਿਸਤੀਆਂ ਦੇ ਦੇਸ ਦੇ ਰਾਹ ਨਾ ਲੈ ਗਿਆ ਭਾਵੇਂ ਉਹ ਨੇੜੇ ਸੀ ਕਿਉਂ ਜੋ ਪਰਮੇਸ਼ੁਰ ਨੇ ਆਖਿਆ, ਸ਼ਾਇਦ ਲੋਕ ਜੰਗ ਨੂੰ ਵੇਖ ਕੇ ਪਛਤਾਉਣ ਅਤੇ ਮਿਸਰ ਨੂੰ ਮੁੜ ਜਾਣ। ");
INSERT INTO pan_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","ਸਗੋਂ ਪਰਮੇਸ਼ੁਰ ਨੇ ਉਨ੍ਹਾਂ ਲੋਕਾਂ ਨੂੰ ਭੁਆਂ ਕੇ ਲਾਲ ਸਮੁੰਦਰ ਦੀ ਉਜਾੜ ਦੀ ਰਾਹ ਪਾ ਦਿੱਤਾ ਅਤੇ ਇਸਰਾਏਲੀ ਸ਼ਸਤਰ ਬੰਨ੍ਹ ਕੇ ਮਿਸਰ ਦੇਸ ਤੋਂ ਚੱਲੇ ਆਏ। ");
INSERT INTO pan_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","ਮੂਸਾ ਨੇ ਯੂਸੁਫ਼ ਦੀਆਂ ਹੱਡੀਆਂ ਆਪਣੇ ਨਾਲ ਲੈ ਲਈਆਂ ਕਿਉਂ ਜੋ ਉਸ ਨੇ ਇਸਰਾਏਲੀਆਂ ਕੋਲੋਂ ਸਹੁੰ ਲੈ ਕੇ ਤਗੀਦ ਕੀਤੀ ਸੀ ਕਿ ਪਰਮੇਸ਼ੁਰ ਤੁਹਾਨੂੰ ਜ਼ਰੂਰ ਚੇਤੇ ਕਰੇਗਾ ਅਤੇ ਤੁਸੀਂ ਮੇਰੀਆਂ ਹੱਡੀਆਂ ਨੂੰ ਐਥੋਂ ਆਪਣੇ ਨਾਲ ਲੈ ਜਾਇਓ। ");
INSERT INTO pan_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","ਫੇਰ ਉਨ੍ਹਾਂ ਨੇ ਸੁੱਕੋਥ ਤੋਂ ਕੂਚ ਕਰ ਕੇ ਉਜਾੜ ਦੇ ਕੰਢੇ ਏਥਾਮ ਵਿੱਚ ਡੇਰਾ ਕੀਤਾ। ");
INSERT INTO pan_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","ਯਹੋਵਾਹ ਉਨ੍ਹਾਂ ਨੂੰ ਰਾਹ ਦੱਸਣ ਲਈ ਦਿਨ ਨੂੰ ਬੱਦਲ ਦੇ ਥੰਮ੍ਹ ਵਿੱਚ ਅਤੇ ਰਾਤੀਂ ਉਨ੍ਹਾਂ ਨੂੰ ਚਾਨਣਾ ਦੇਣ ਲਈ ਅੱਗ ਦੇ ਥੰਮ੍ਹ ਵਿੱਚ ਉਨ੍ਹਾਂ ਦੇ ਅੱਗੇ-ਅੱਗੇ ਤੁਰਦਾ ਸੀ ਤਾਂ ਜੋ ਦਿਨ ਅਤੇ ਰਾਤ ਨੂੰ ਚੱਲਦੇ ਜਾਣ। ");
INSERT INTO pan_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","ਬੱਦਲ ਦਾ ਥੰਮ੍ਹ ਦਿਨ ਨੂੰ ਅਤੇ ਅੱਗ ਦਾ ਥੰਮ੍ਹ ਰਾਤ ਨੂੰ ਉਨ੍ਹਾਂ ਲੋਕਾਂ ਦੇ ਅੱਗੋਂ ਕਦੀ ਨਾ ਹਟਿਆ। ");
INSERT INTO pan_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","ਯਹੋਵਾਹ ਮੂਸਾ ਨਾਲ ਬੋਲਿਆ, ");
INSERT INTO pan_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","ਇਸਰਾਏਲੀਆਂ ਨੂੰ ਆਖ ਕਿ ਉਹ ਮੁੜ ਜਾਣ ਅਤੇ ਪੀ-ਹਹੀਰੋਥ ਦੇ ਸਾਹਮਣੇ ਮਿਗਦੋਲ ਅਤੇ ਸਮੁੰਦਰ ਦੇ ਵਿਚਕਾਰ ਬਆਲ-ਸਫ਼ੋਨ ਦੇ ਸਾਹਮਣੇ ਡੇਰਾ ਲਾਉਣ। ਉਸ ਦੇ ਸਾਹਮਣੇ ਸਮੁੰਦਰ ਦੇ ਕੋਲ ਡੇਰਾ ਲਾਓ। ");
INSERT INTO pan_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","ਫ਼ਿਰਊਨ ਇਸਰਾਏਲੀਆਂ ਲਈ ਆਖੇਗਾ ਕਿ ਉਹ ਧਰਤੀ ਵਿੱਚ ਫਸ ਗਏ ਹਨ ਅਤੇ ਉਜਾੜ ਨੇ ਉਨ੍ਹਾਂ ਨੂੰ ਰੋਕ ਲਿਆ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","ਮੈਂ ਫ਼ਿਰਊਨ ਦੇ ਮਨ ਨੂੰ ਕਠੋਰ ਹੋਣ ਦੇਵਾਂਗਾ ਅਤੇ ਉਹ ਉਨ੍ਹਾਂ ਦਾ ਪਿੱਛਾ ਕਰੇਗਾ ਅਤੇ ਮੈਂ ਫ਼ਿਰਊਨ ਅਤੇ ਉਸ ਦੀ ਸਾਰੀ ਫੌਜ ਤੋਂ ਆਦਰ ਪਾਵਾਂਗਾ ਤਾਂ ਜੋ ਮਿਸਰੀ ਜਾਣਨ ਕਿ ਮੈਂ ਯਹੋਵਾਹ ਹਾਂ। ਫੇਰ ਉਨ੍ਹਾਂ ਨੇ ਉਸੇ ਤਰ੍ਹਾਂ ਹੀ ਕੀਤਾ। ");
INSERT INTO pan_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","ਤਾਂ ਮਿਸਰ ਦੇ ਰਾਜੇ ਨੂੰ ਦੱਸਿਆ ਗਿਆ ਕਿ ਉਹ ਲੋਕ ਨੱਠ ਗਏ ਹਨ। ਤਾਂ ਫ਼ਿਰਊਨ ਅਤੇ ਉਸ ਦੇ ਟਹਿਲੂਆਂ ਦੇ ਮਨ ਉਨ੍ਹਾਂ ਲੋਕਾਂ ਵੱਲੋਂ ਫਿਰ ਗਏ ਅਤੇ ਉਨ੍ਹਾਂ ਨੇ ਆਖਿਆ, ਇਹ ਕੀ ਹੈ ਜੋ ਆਪਾਂ ਕੀਤਾ ਕਿ ਆਪਾਂ ਇਸਰਾਏਲ ਨੂੰ ਆਪਣੀ ਟਹਿਲ ਤੋਂ ਜਾਣ ਦਿੱਤਾ? ");
INSERT INTO pan_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","ਤਾਂ ਉਸ ਨੇ ਆਪਣਾ ਰੱਥ ਜੁੜਾਇਆ ਅਤੇ ਆਪਣੀ ਪਰਜਾ ਨੂੰ ਨਾਲ ਲਿਆ ");
INSERT INTO pan_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","ਨਾਲੇ ਉਸ ਨੇ ਛੇ ਸੌ ਚੁਗਵੇਂ ਰੱਥ ਅਤੇ ਮਿਸਰ ਦੇ ਬਾਕੀ ਰੱਥ ਵੀ ਲਏ ਅਤੇ ਸਾਰਿਆਂ ਉੱਤੇ ਅਫ਼ਸਰ ਬਹਾਏ। ");
INSERT INTO pan_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","ਅਤੇ ਯਹੋਵਾਹ ਨੇ ਮਿਸਰ ਦੇ ਰਾਜੇ ਫ਼ਿਰਊਨ ਦਾ ਮਨ ਕਠੋਰ ਹੋਣ ਦਿੱਤਾ ਅਤੇ ਉਸ ਨੇ ਇਸਰਾਏਲੀਆਂ ਦਾ ਪਿੱਛਾ ਕੀਤਾ ਪਰ ਇਸਰਾਏਲੀ ਜ਼ਬਰਦਸਤੀ ਨਾਲ ਨਿੱਕਲਦੇ ਜਾਂਦੇ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","ਅਤੇ ਮਿਸਰੀਆਂ ਨੇ ਉਨ੍ਹਾਂ ਦਾ ਪਿੱਛਾ ਕੀਤਾ ਅਤੇ ਫ਼ਿਰਊਨ ਦੇ ਸਾਰੇ ਘੋੜੇ ਅਤੇ ਰੱਥ ਅਤੇ ਉਸ ਦੇ ਘੋੜ ਚੜ੍ਹੇ ਅਤੇ ਉਸ ਦੀ ਫੌਜ ਉਨ੍ਹਾਂ ਦੇ ਤੰਬੂ ਲਾਉਂਦਿਆਂ ਤੇ ਸਮੁੰਦਰ ਦੇ ਕੋਲ ਅਤੇ ਪੀ-ਹਹੀਰੋਥ ਦੇ ਕੋਲ ਬਆਲ-ਸਫ਼ੋਨ ਦੇ ਸਾਹਮਣੇ ਜਾ ਟੱਕਰੀ। ");
INSERT INTO pan_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","ਜਦ ਫ਼ਿਰਊਨ ਆਇਆ ਤਾਂ ਇਸਰਾਏਲੀਆਂ ਨੇ ਆਪਣੀਆਂ ਅੱਖਾਂ ਚੁੱਕੀਆਂ ਅਤੇ ਵੇਖੋ ਮਿਸਰੀ ਉਨ੍ਹਾਂ ਦੇ ਪਿੱਛੇ-ਪਿੱਛੇ ਆ ਰਹੇ ਸਨ ਤਾਂ ਉਹ ਬਹੁਤ ਹੀ ਡਰੇ ਅਤੇ ਇਸਰਾਏਲੀਆਂ ਨੇ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਤਰਲੇ ਕੀਤੇ। ");
INSERT INTO pan_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","ਉਪਰੰਤ ਉਨ੍ਹਾਂ ਨੇ ਮੂਸਾ ਨੂੰ ਆਖਿਆ, ਕੀ ਮਿਸਰ ਵਿੱਚ ਕਬਰਾਂ ਨਹੀਂ ਸਨ ਕਿ ਤੂੰ ਸਾਨੂੰ ਮਰਨ ਲਈ ਉਜਾੜ ਵਿੱਚ ਲਿਆਇਆ ਹੈਂ? ਇਹ ਤੂੰ ਸਾਡੇ ਨਾਲ ਕੀ ਕੀਤਾ ਜੋ ਸਾਨੂੰ ਮਿਸਰੋਂ ਕੱਢ ਲਿਆਇਆ ਹੈਂ? ");
INSERT INTO pan_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","ਇਹ ਉਹੋ ਹੀ ਗੱਲ ਤਾਂ ਨਹੀਂ ਜਿਹੜੀ ਅਸੀਂ ਤੈਨੂੰ ਮਿਸਰ ਵਿੱਚ ਆਖੀ ਸੀ ਕਿ ਸਾਨੂੰ ਰਹਿਣ ਦੇ ਕਿ ਅਸੀਂ ਮਿਸਰੀਆਂ ਦੀ ਟਹਿਲ ਕਰੀਏ ਕਿਉਂਕਿ ਸਾਨੂੰ ਮਿਸਰੀਆਂ ਦੀ ਟਹਿਲ ਕਰਨੀ ਉਜਾੜ ਵਿੱਚ ਮਰਨ ਨਾਲੋਂ ਚੰਗੀ ਸੀ? ");
INSERT INTO pan_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","ਮੂਸਾ ਨੇ ਪਰਜਾ ਨੂੰ ਆਖਿਆ, ਨਾ ਡਰੋ, ਖੜੇ ਰਹੋ ਅਤੇ ਯਹੋਵਾਹ ਦੇ ਬਚਾਉ ਨੂੰ ਵੇਖੋ ਜਿਹੜਾ ਅੱਜ ਦੇ ਦਿਨ ਤੁਹਾਡੇ ਲਈ ਕਰੇਗਾ ਕਿਉਂਕਿ ਜਿਹੜੇ ਮਿਸਰੀ ਤੁਸੀਂ ਅੱਜ ਵੇਖਦੇ ਹੋ ਫੇਰ ਸਦਾ ਤੱਕ ਕਦੀ ਨਾ ਵੇਖੋਗੇ। ");
INSERT INTO pan_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","ਯਹੋਵਾਹ ਤੁਹਾਡੇ ਲਈ ਜੰਗ ਕਰੇਗਾ ਪਰ ਤੁਸੀਂ ਚੁੱਪ ਹੀ ਰਹਿਣਾ। ");
INSERT INTO pan_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","ਤਾਂ ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਆਖਿਆ, ਤੂੰ ਕਿਉਂ ਮੇਰੇ ਤਰਲੇ ਕਰਦਾ ਹੈਂ? ਇਸਰਾਏਲੀਆਂ ਨਾਲ ਗੱਲ ਕਰ ਕਿ ਉਹ ਅੱਗੇ ਤੁਰਨ। ");
INSERT INTO pan_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","ਤੂੰ ਆਪਣਾ ਢਾਂਗਾ ਚੁੱਕ ਅਤੇ ਆਪਣਾ ਹੱਥ ਸਮੁੰਦਰ ਉੱਤੇ ਲੰਮਾ ਕਰ ਅਤੇ ਉਸ ਨੂੰ ਦੋ ਭਾਗ ਕਰ ਦੇ ਕਿ ਇਸਰਾਏਲੀ ਸਮੁੰਦਰ ਦੇ ਵਿੱਚ ਦੀ ਸੁੱਕੀ ਥਾਂ ਥਾਣੀ ਲੰਘ ਜਾਣ। ");
INSERT INTO pan_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","ਵੇਖ ਮੈਂ ਮਿਸਰੀਆਂ ਦੇ ਮਨ ਕਠੋਰ ਹੋਣ ਦੇਵਾਂਗਾ ਅਤੇ ਉਹ ਉਨ੍ਹਾਂ ਦੇ ਪਿੱਛੇ ਜਾਣਗੇ ਅਤੇ ਮੈਂ ਫ਼ਿਰਊਨ ਅਤੇ ਉਸ ਦੀ ਸਾਰੀ ਫੌਜ ਅਤੇ ਰੱਥਾਂ ਅਤੇ ਘੋੜ ਚੜ੍ਹਿਆਂ ਤੋਂ ਆਦਰ ਪਾਵਾਂਗਾ। ");
INSERT INTO pan_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","ਜਦ ਮੈਂ ਫ਼ਿਰਊਨ ਉਸ ਦੇ ਰਥਾਂ ਅਤੇ ਉਸ ਦੇ ਘੋੜ ਚੜ੍ਹਿਆਂ ਤੋਂ ਆਦਰ ਪਾਵਾਂਗਾ ਤਦ ਮਿਸਰੀ ਜਾਣਨਗੇ ਕਿ ਮੈਂ ਯਹੋਵਾਹ ਹਾਂ। ");
INSERT INTO pan_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","ਅਤੇ ਪਰਮੇਸ਼ੁਰ ਦਾ ਦੂਤ ਜਿਹੜਾ ਇਸਰਾਏਲ ਦੇ ਡੇਰੇ ਦੇ ਅੱਗੇ ਤੁਰਿਆ ਜਾਂਦਾ ਸੀ ਮੁੜਿਆ ਅਤੇ ਉਨ੍ਹਾਂ ਦੇ ਪਿੱਛੇ ਚਲਿਆ ਗਿਆ ਅਤੇ ਬੱਦਲ ਦਾ ਥੰਮ੍ਹ ਉਨ੍ਹਾਂ ਦੇ ਅੱਗੋਂ ਮੁੜ ਕੇ ਪਿੱਛੇ ਆ ਖੜਾ ਹੋਇਆ। ");
INSERT INTO pan_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","ਉਹ ਮਿਸਰੀਆਂ ਦੇ ਡੇਰੇ ਅਤੇ ਇਸਰਾਏਲ ਦੇ ਡੇਰੇ ਦੇ ਵਿੱਚ ਆ ਗਿਆ ਅਤੇ ਬੱਦਲ ਅਤੇ ਅਨ੍ਹੇਰ ਤਾਂ ਸੀ ਪਰ ਉਸ ਨੇ ਰਾਤ ਨੂੰ ਚਾਨਣਾ ਕਰ ਦਿੱਤਾ ਅਤੇ ਉਹ ਸਾਰੀ ਰਾਤ ਇੱਕ ਦੂਜੇ ਦੇ ਨੇੜੇ ਨਾ ਆਏ। ");
INSERT INTO pan_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","ਤਾਂ ਮੂਸਾ ਨੇ ਆਪਣਾ ਹੱਥ ਸਮੁੰਦਰ ਉੱਤੇ ਲੰਮਾ ਕੀਤਾ ਅਤੇ ਯਹੋਵਾਹ ਨੇ ਤੇਜ ਪੁਰੇ ਦੀ ਹਵਾ ਸਾਰੀ ਰਾਤ ਵਗਾ ਕੇ ਸਮੁੰਦਰ ਨੂੰ ਪਿੱਛੇ ਹਟਾ ਦਿੱਤਾ ਅਤੇ ਸਮੁੰਦਰ ਨੂੰ ਸੁਕਾ ਦਿੱਤਾ ਅਤੇ ਪਾਣੀ ਦੋ ਭਾਗ ਹੋ ਗਏ। ");
INSERT INTO pan_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","ਇਸਰਾਏਲੀ ਸਮੁੰਦਰ ਦੇ ਵਿੱਚ ਦੀ ਸੁੱਕੀ ਜ਼ਮੀਨ ਉੱਤੋਂ ਦੀ ਆਏ ਅਤੇ ਉਨ੍ਹਾਂ ਦੇ ਸੱਜੇ ਖੱਬੇ ਪਾਣੀ ਕੰਧ ਵਾਂਗੂੰ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","ਮਿਸਰੀਆਂ ਨੇ ਪਿੱਛਾ ਕੀਤਾ ਅਤੇ ਉਨ੍ਹਾਂ ਦਾ ਪਿੱਛਾ ਕਰਦੇ ਹੋਏ ਫ਼ਿਰਊਨ ਦੇ ਸਾਰੇ ਘੋੜੇ ਅਤੇ ਉਸ ਦੇ ਰੱਥ ਅਤੇ ਘੋੜ ਚੜ੍ਹੇ ਸਮੁੰਦਰ ਵਿੱਚ ਆ ਗਏ। ");
INSERT INTO pan_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","ਤਾਂ ਇਸ ਤਰ੍ਹਾਂ ਹੋਇਆ ਕਿ ਸਵੇਰ ਦੇ ਪਹਿਰ ਯਹੋਵਾਹ ਨੇ ਮਿਸਰੀਆਂ ਦੇ ਡੇਰੇ ਨੂੰ ਅੱਗ ਅਤੇ ਬੱਦਲ ਦੇ ਥੰਮ੍ਹ ਦੇ ਵਿੱਚੋਂ ਦੀ ਡਿੱਠਾ ਅਤੇ ਮਿਸਰੀਆਂ ਦੇ ਡੇਰੇ ਨੂੰ ਗੜਬੜਾਹਟ ਵਿੱਚ ਪਾ ਦਿੱਤਾ। ");
INSERT INTO pan_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","ਅਤੇ ਉਨ੍ਹਾਂ ਦੇ ਰੱਥ ਦੇ ਪਹੀਏ ਲਾਹ ਸੁੱਟੇ ਕਿਉਂ ਜੋ ਉਹ ਭਾਰੀ ਚੱਲਦੇ ਸਨ। ਸੋ ਮਿਸਰੀਆਂ ਨੇ ਆਖਿਆ, ਅਸੀਂ ਇਸਰਾਏਲ ਦੇ ਅੱਗੋਂ ਨੱਠ ਚੱਲੀਏ ਕਿਉਂਕਿ ਯਹੋਵਾਹ ਉਨ੍ਹਾਂ ਲਈ ਮਿਸਰੀਆਂ ਦੇ ਵਿਰੁੱਧ ਲੜਦਾ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","ਫੇਰ ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਆਖਿਆ, ਆਪਣੇ ਹੱਥ ਸਮੁੰਦਰ ਉੱਤੇ ਲੰਮਾ ਕਰ ਤਾਂ ਜੋ ਪਾਣੀ ਮਿਸਰੀਆਂ ਉੱਤੇ, ਉਨ੍ਹਾਂ ਦੇ ਰਥਾਂ ਉੱਤੇ ਅਤੇ ਉਨ੍ਹਾਂ ਦੇ ਘੋੜ ਚੜ੍ਹਿਆਂ ਉੱਤੇ ਮੁੜ ਆਉਣ। ");
INSERT INTO pan_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","ਮੂਸਾ ਨੇ ਆਪਣਾ ਹੱਥ ਸਮੁੰਦਰ ਉੱਤੇ ਲੰਮਾ ਕੀਤਾ ਅਤੇ ਪਹੁ ਫਟਣ ਵੇਲੇ ਸਮੁੰਦਰ ਆਪਣੇ ਪਹਿਲੇ ਬਲ ਨਾਲ ਮੁੜਿਆ ਅਤੇ ਮਿਸਰੀ ਉਸ ਦੀ ਵੱਲੋਂ ਨੱਠੇ ਪਰ ਯਹੋਵਾਹ ਨੇ ਮਿਸਰੀਆਂ ਨੂੰ ਸਮੁੰਦਰ ਦੇ ਵਿੱਚ ਛੰਡ ਸੁੱਟਿਆ। ");
INSERT INTO pan_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","ਉਪਰੰਤ ਪਾਣੀ ਮੁੜੇ ਅਤੇ ਉਨ੍ਹਾਂ ਨੇ ਰੱਥ ਅਤੇ ਘੋੜ ਚੜ੍ਹੇ ਅਤੇ ਫ਼ਿਰਊਨ ਦੀ ਸਾਰੀ ਫੌਜ ਜਿਹੜੀ ਉਨ੍ਹਾਂ ਦੇ ਮਗਰ ਸਮੁੰਦਰ ਵਿੱਚ ਆਈ ਸੀ ਢੱਕ ਲਈ ਅਤੇ ਉਨ੍ਹਾਂ ਵਿੱਚੋਂ ਇੱਕ ਵੀ ਨਾ ਬਚਿਆ। ");
INSERT INTO pan_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","ਪਰ ਇਸਰਾਏਲੀ ਖੁਸ਼ਕੀ ਉੱਤੋਂ ਸਮੁੰਦਰ ਦੇ ਵਿੱਚ ਦੀ ਚੱਲਦੇ ਗਏ ਅਤੇ ਪਾਣੀ ਉਨ੍ਹਾਂ ਦੇ ਸੱਜੇ ਖੱਬੇ ਕੰਧ ਵਾਂਗੂੰ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","ਸੋ ਉਸ ਦਿਨ ਯਹੋਵਾਹ ਨੇ ਇਸਰਾਏਲ ਨੂੰ ਮਿਸਰੀਆਂ ਦੇ ਹੱਥੋਂ ਇਸ ਤਰ੍ਹਾਂ ਬਚਾਇਆ ਅਤੇ ਇਸਰਾਏਲ ਨੇ ਮਿਸਰੀਆਂ ਦੇ ਮੁਰਦੇ ਸਮੁੰਦਰ ਦੇ ਕੰਢੇ ਉੱਤੇ ਵੇਖੇ। ");
INSERT INTO pan_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","ਇਸ ਤਰ੍ਹਾਂ ਇਸਰਾਏਲ ਨੇ ਉਹ ਵੱਡਾ ਕੰਮ ਵੇਖਿਆ ਜਿਹੜਾ ਯਹੋਵਾਹ ਨੇ ਮਿਸਰੀਆਂ ਦੇ ਵਿਰੁੱਧ ਕੀਤਾ ਸੀ ਤਾਂ ਲੋਕ ਯਹੋਵਾਹ ਕੋਲੋਂ ਡਰ ਗਏ ਅਤੇ ਉਨ੍ਹਾਂ ਨੇ ਯਹੋਵਾਹ ਉੱਤੇ ਅਤੇ ਉਸ ਦੇ ਦਾਸ ਮੂਸਾ ਉੱਤੇ ਪਰਤੀਤ ਕੀਤੀ। ");
INSERT INTO pan_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","ਤਦ ਮੂਸਾ ਅਤੇ ਇਸਰਾਏਲੀਆਂ ਨੇ ਯਹੋਵਾਹ ਲਈ ਇਹ ਗੀਤ ਗਾਉਂਦੇ ਹੋਇਆਂ ਆਖਿਆ - ਮੈਂ ਯਹੋਵਾਹ ਲਈ ਗਾਵਾਂਗਾ ਕਿਉਂਕਿ ਉਹ ਬਹੁਤ ਉੱਚਾ ਹੋਇਆ ਹੈ, ਉਸ ਨੇ ਘੋੜੇ ਅਤੇ ਉਸ ਦੇ ਸਵਾਰ ਨੂੰ ਸਮੁੰਦਰ ਵਿੱਚ ਸੁੱਟ ਦਿੱਤਾ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","ਯਹੋਵਾਹ ਮੇਰਾ ਬਲ ਅਤੇ ਮੇਰਾ ਭਜਨ ਹੈ, ਉਹ ਮੇਰਾ ਛੁਟਕਾਰਾ ਹੋਇਆ ਹੈ, ਉਹ ਮੇਰਾ ਪਰਮੇਸ਼ੁਰ ਹੈ ਤੇ ਮੈਂ ਉਸ ਦੀ ਸੋਭਾ ਕਰਾਂਗਾ, ਉਹ ਮੇਰੇ ਪਿਤਾ ਦਾ ਪਰਮੇਸ਼ੁਰ ਹੈ ਤੇ ਮੈਂ ਉਸ ਦੀ ਵਡਿਆਈ ਕਰਾਂਗਾ। ");
INSERT INTO pan_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","ਯਹੋਵਾਹ ਯੋਧਾ ਪੁਰਸ਼ ਹੈ, ਯਹੋਵਾਹ ਉਸ ਦਾ ਨਾਮ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","ਫ਼ਿਰਊਨ ਦੇ ਰੱਥ ਅਤੇ ਉਸ ਦੀ ਫੌਜ ਉਸ ਨੇ ਸਮੁੰਦਰ ਵਿੱਚ ਸੁੱਟ ਦਿੱਤੀ, ਉਸ ਦੇ ਉੱਤਮ ਅਫ਼ਸਰ ਲਾਲ ਸਮੁੰਦਰ ਵਿੱਚ ਗਰਕ ਹੋ ਗਏ। ");
INSERT INTO pan_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","ਡੁੰਘਿਆਈ ਨੇ ਉਨ੍ਹਾਂ ਨੂੰ ਢੱਕ ਲਿਆ, ਉਹ ਪੱਥਰ ਵਾਂਗੂੰ ਤਹਿ ਵਿੱਚ ਚਲੇ ਗਏ। ");
INSERT INTO pan_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","ਹੇ ਯਹੋਵਾਹ ਤੇਰਾ ਸੱਜਾ ਹੱਥ ਸ਼ਕਤੀ ਵਿੱਚ ਤੇਜਵਾਨ ਹੈ, ਹੇ ਯਹੋਵਾਹ ਤੇਰਾ ਸੱਜਾ ਹੱਥ ਵੈਰੀ ਨੂੰ ਚਕਨਾ-ਚੂਰ ਕਰ ਸੁੱਟਦਾ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","ਤੂੰ ਆਪਣੀ ਵੱਡੀ ਉੱਤਮਤਾਈ ਨਾਲ ਆਪਣੇ ਵਿਰੋਧੀਆਂ ਨੂੰ ਢਾਹ ਲੈਂਦਾ ਹੈਂ, ਤੂੰ ਆਪਣਾ ਕ੍ਰੋਧ ਭੇਜਦਾ ਹੈਂ ਜਿਹੜਾ ਉਨ੍ਹਾਂ ਨੂੰ ਭੱਠੇ ਵਾਂਗੂੰ ਭੱਖ ਲੈਂਦਾ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","ਤੇਰੀਆਂ ਨਾਸਾਂ ਦੀ ਸੂਕਰ ਨਾਲ ਪਾਣੀ ਜਮਾਂ ਹੋ ਗਏ, ਮੌਜਾਂ ਢੇਰ ਵਾਂਗੂੰ ਖੜੀਆਂ ਹੋ ਗਈਆਂ, ਡੁੰਘਿਆਈ ਸਮੁੰਦਰ ਦੇ ਵਿਚਕਾਰ ਜੰਮ ਗਈਆਂ। ");
INSERT INTO pan_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","ਵੈਰੀ ਨੇ ਆਖਿਆ, ਮੈਂ ਪਿੱਛਾ ਕਰਾਂਗਾ, ਮੈਂ ਜਾ ਲਵਾਂਗਾ, ਮੈਂ ਲੁੱਟ ਦਾ ਮਾਲ ਵੰਡਾਂਗਾ, ਮੈਂ ਉਨ੍ਹਾਂ ਨਾਲ ਮਨ ਆਈ ਕਰਾਂਗਾ, ਮੈਂ ਤਲਵਾਰ ਸੂਤਾਂਗਾ ਅਤੇ ਮੇਰਾ ਹੱਥ ਉਨ੍ਹਾਂ ਦਾ ਨਾਸ ਕਰੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","ਤੂੰ ਆਪਣੀ ਹਵਾ ਨਾਲ ਫੂਕ ਮਾਰੀ, ਸਮੁੰਦਰ ਨੇ ਉਨ੍ਹਾਂ ਨੂੰ ਢੱਕ ਲਿਆ, ਉਹ ਸਿੱਕੇ ਵਾਂਗੂੰ ਮਹਾਂ ਜਲ ਵਿੱਚ ਡੁੱਬ ਗਏ। ");
INSERT INTO pan_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","ਕੌਣ ਹੈ ਤੇਰੇ ਵਰਗਾ ਹੇ ਯਹੋਵਾਹ ਦੇਵਤਿਆਂ ਵਿੱਚ? ਕੌਣ ਹੈ ਤੇਰੇ ਵਰਗਾ ਪਵਿੱਤਰਤਾਈ ਵਿੱਚ ਪਰਤਾਪ ਵਾਲਾ, ਉਸਤਤ ਵਿੱਚ ਭੈਅ ਦਾਇਕ ਅਤੇ ਅਚਰਜ਼ ਕੰਮਾਂ ਵਾਲਾ? ");
INSERT INTO pan_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","ਤੂੰ ਆਪਣਾ ਸੱਜਾ ਹੱਥ ਪਸਾਰਿਆ, ਤਾਂ ਧਰਤੀ ਉਨ੍ਹਾਂ ਨੂੰ ਨਿਗਲ ਗਈ। ");
INSERT INTO pan_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","ਤੂੰ ਆਪਣੀ ਕਿਰਪਾ ਨਾਲ ਉਸ ਪਰਜਾ ਦੀ ਅਗਵਾਈ ਕੀਤੀ ਜਿਹ ਨੂੰ ਤੂੰ ਛੁਟਕਾਰਾ ਦਿੱਤਾ ਸੀ, ਤੂੰ ਆਪਣੇ ਬਲ ਨਾਲ ਉਸ ਨੂੰ ਆਪਣੇ ਪਵਿੱਤਰ ਨਿਵਾਸ ਦੇ ਰਾਹ ਪਾ ਦਿੱਤਾ। ");
INSERT INTO pan_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","ਲੋਕਾਂ ਨੇ ਸੁਣਿਆ, ਉਹ ਕੰਬਦੇ ਹਨ, ਫ਼ਲਿਸਤੀਨ ਦੇ ਵਾਸੀਆਂ ਨੂੰ ਚੁਬਕ ਪਈ। ");
INSERT INTO pan_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","ਤਦ ਅਦੋਮ ਦੇ ਸਰਦਾਰ ਘਬਰਾ ਗਏ, ਮੋਆਬ ਦੇ ਸੂਰਮਿਆਂ ਨੂੰ ਕੰਬਣੀ ਲੱਗੀ, ਕਨਾਨ ਦੇ ਸਾਰੇ ਵਾਸੀ ਢੱਲ਼ ਗਏ। ");
INSERT INTO pan_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","ਹੌਲ ਅਤੇ ਤਹਿਕਣਾ ਉਨ੍ਹਾਂ ਉੱਤੇ ਪੈਂਦਾ ਹੈ, ਉਹ ਤੇਰੀ ਬਾਂਹ ਦੇ ਵੱਡੇ ਹੋਣ ਦੇ ਕਾਰਨ ਪੱਥਰ ਵਾਂਗੂੰ ਚੁੱਪ ਰਹਿ ਜਾਂਦੇ ਹਨ। ਹੇ ਯਹੋਵਾਹ ਜਦ ਤੱਕ ਤੇਰੀ ਪਰਜਾ ਲੰਘ ਨਾ ਜਾਵੇ, ਜਦ ਤੱਕ ਉਹ ਪਰਜਾ ਜਿਹੜੀ ਤੂੰ ਵਿਹਾਝੀ ਹੈ ਪਾਰ ਨਾ ਲੰਘ ਜਾਵੇ, ");
INSERT INTO pan_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","ਤੂੰ ਉਨ੍ਹਾਂ ਨੂੰ ਅੰਦਰ ਲਿਆਵੇਂਗਾ ਅਤੇ ਆਪਣੀ ਮਿਲਖ਼ ਦੇ ਪਰਬਤ ਵਿੱਚ ਲਗਾਵੇਂਗਾ, ਹੇ ਯਹੋਵਾਹ ਉਸ ਸਥਾਨ ਵਿੱਚ ਜਿਹੜਾ ਤੂੰ ਆਪਣੇ ਰਹਿਣ ਲਈ ਬਣਾਇਆ ਹੈ, ਹੇ ਮੇਰੇ ਪ੍ਰਭੂ ਉਹ ਪਵਿੱਤਰ ਸਥਾਨ ਜਿਹੜਾ ਤੇਰੇ ਹੱਥਾਂ ਨੇ ਸਥਿਰ ਕੀਤਾ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","ਯਹੋਵਾਹ ਸਦਾ ਤੱਕ ਰਾਜ ਕਰਦਾ ਰਹੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","ਫ਼ਿਰਊਨ ਦੇ ਘੋੜੇ ਅਤੇ ਉਸ ਦੇ ਰੱਥ ਅਤੇ ਉਸ ਦੇ ਘੋੜ ਚੜ੍ਹੇ ਤਾਂ ਸਮੁੰਦਰ ਵਿੱਚ ਵੜੇ ਅਤੇ ਯਹੋਵਾਹ ਨੇ ਸਮੁੰਦਰ ਦੇ ਪਾਣੀ ਨੂੰ ਉਨ੍ਹਾਂ ਉੱਤੇ ਮੋੜ ਲਿਆਂਦਾ ਪਰ ਇਸਰਾਏਲੀ ਸਮੁੰਦਰ ਦੇ ਵਿਚਕਾਰੋਂ ਦੀ ਸੁੱਕੀ ਜ਼ਮੀਨ ਉੱਤੋਂ ਦੀ ਲੰਘ ਗਏ। ");
INSERT INTO pan_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","ਹਾਰੂਨ ਦੀ ਭੈਣ ਮਿਰਯਮ ਨਬੀਆ ਨੇ ਆਪਣੇ ਹੱਥ ਵਿੱਚ ਡੱਫ਼ ਲਈ ਅਤੇ ਸਾਰੀਆਂ ਇਸਤ੍ਰੀਆਂ ਡੱਫਾਂ ਵਜਾਉਂਦੀਆਂ ਅਤੇ ਨੱਚਦੀਆਂ ਉਸ ਦੇ ਪਿੱਛੇ ਨਿੱਕਲੀਆਂ। ");
INSERT INTO pan_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","ਮਿਰਯਮ ਨੇ ਉਨ੍ਹਾਂ ਨੂੰ ਉੱਤਰ ਦਿੱਤਾ - ਯਹੋਵਾਹ ਲਈ ਗਾਓ ਕਿਉਂ ਜੋ ਉਹ ਬਹੁਤ ਉੱਚਾ ਹੋਇਆ ਹੈ, ਘੋੜਾ ਅਤੇ ਉਸ ਦਾ ਸਵਾਰ ਉਸ ਨੇ ਸਮੁੰਦਰ ਵਿੱਚ ਸੁੱਟ ਦਿੱਤਾ। ");
INSERT INTO pan_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","ਮੂਸਾ ਨੇ ਇਸਰਾਏਲ ਨੂੰ ਲਾਲ ਸਮੁੰਦਰ ਤੋਂ ਤੋਰ ਦਿੱਤਾ। ਉਹ ਸ਼ੂਰ ਦੀ ਉਜਾੜ ਨੂੰ ਨਿੱਕਲੇ ਅਤੇ ਤਿੰਨ ਦਿਨ ਉਜਾੜ ਵਿੱਚ ਦੀ ਤੁਰੇ ਗਏ ਪਰ ਉਨ੍ਹਾਂ ਨੂੰ ਪਾਣੀ ਨਾ ਲੱਭਾ। ");
INSERT INTO pan_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","ਜਦ ਉਹ ਮਾਰਾਹ ਨੂੰ ਆਏ ਤਾਂ ਉਹ ਮਾਰਾਹ ਦਾ ਪਾਣੀ ਨਾ ਪੀ ਸਕੇ ਕਿਉਂ ਜੋ ਉਹ ਕੌੜਾ ਸੀ ਇਸ ਲਈ ਉਸ ਦਾ ਨਾਮ ਮਾਰਾਹ ਪੈ ਗਿਆ। ");
INSERT INTO pan_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","ਉਪਰੰਤ ਪਰਜਾ ਮੂਸਾ ਦੇ ਵਿਰੁੱਧ ਬੁੜ-ਬੁੜਾਉਣ ਲੱਗੀ ਕਿ ਅਸੀਂ ਕੀ ਪੀਈਏ? ");
INSERT INTO pan_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","ਤਾਂ ਉਸ ਨੇ ਯਹੋਵਾਹ ਅੱਗੇ ਦੁਹਾਈ ਦਿੱਤੀ ਤਾਂ ਯਹੋਵਾਹ ਨੇ ਉਸ ਨੂੰ ਇੱਕ ਬਿਰਛ ਵਿਖਾਲਿਆ। ਉਸ ਨੇ ਉਹ ਨੂੰ ਪਾਣੀ ਵਿੱਚ ਸੁੱਟਿਆ ਤਾਂ ਪਾਣੀ ਮਿੱਠਾ ਹੋ ਗਿਆ। ਉੱਥੇ ਉਸ ਨੇ ਉਨ੍ਹਾਂ ਲਈ ਇੱਕ ਬਿਧੀ ਅਤੇ ਕਨੂੰਨ ਠਹਿਰਾਇਆ ਅਤੇ ਉੱਥੇ ਉਸ ਨੇ ਉਨ੍ਹਾਂ ਨੂੰ ਪਰਖ ਲਿਆ ");
INSERT INTO pan_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","ਅਤੇ ਉਸ ਨੇ ਆਖਿਆ, ਜੇ ਤੁਸੀਂ ਰੀਝ ਨਾਲ ਯਹੋਵਾਹ ਆਪਣੇ ਪਰਮੇਸ਼ੁਰ ਦੀ ਅਵਾਜ਼ ਸੁਣੋਗੇ ਅਤੇ ਜਿਹੜਾ ਉਸ ਦੀਆਂ ਅੱਖਾਂ ਵਿੱਚ ਭਲਾ ਹੈ ਤੁਸੀਂ ਉਹ ਕਰੋਗੇ ਅਤੇ ਉਸ ਦੇ ਹੁਕਮਾਂ ਉੱਤੇ ਕੰਨ ਲਾਓਗੇ ਅਤੇ ਉਸ ਦੀਆਂ ਸਾਰੀਆਂ ਬਿਧੀਆਂ ਨੂੰ ਮੰਨੋਗੇ ਤਾਂ ਜਿਹੜੀਆਂ ਬਿਮਾਰੀਆਂ ਮੈਂ ਮਿਸਰੀਆਂ ਉੱਤੇ ਪਾਈਆਂ ਹਨ ਤੁਹਾਡੇ ਉੱਤੇ ਨਹੀਂ ਪਾਵਾਂਗਾ ਕਿਉਂ ਜੋ ਮੈਂ ਯਹੋਵਾਹ ਤੁਹਾਨੂੰ ਨਰੋਇਆ ਕਰਨ ਵਾਲਾ ਹਾਂ। ");
INSERT INTO pan_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","ਫਿਰ ਉਹ ਏਲਿਮ ਨੂੰ ਆਏ ਜਿੱਥੇ ਪਾਣੀ ਦੇ ਬਾਰਾਂ ਸੋਤੇ ਅਤੇ ਸੱਤਰ ਖਜ਼ੂਰ ਦੇ ਬਿਰਛ ਸਨ ਅਤੇ ਉਨ੍ਹਾਂ ਨੇ ਉੱਥੇ ਪਾਣੀ ਕੋਲ ਡੇਰੇ ਲਾਏ। ");
INSERT INTO pan_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","ਫੇਰ ਉਨ੍ਹਾਂ ਨੇ ਏਲਿਮ ਤੋਂ ਕੂਚ ਕੀਤਾ ਅਤੇ ਇਸਰਾਏਲੀਆਂ ਦੀ ਸਾਰੀ ਮੰਡਲੀ ਸੀਨ ਦੀ ਉਜਾੜ ਵਿੱਚ ਜਿਹੜੀ ਏਲਿਮ ਅਤੇ ਸੀਨਈ ਦੇ ਵਿਚਕਾਰ ਹੈ ਦੂਜੇ ਮਹੀਨੇ ਦੇ ਪੰਦਰਵੇਂ ਦਿਨ ਉਨ੍ਹਾਂ ਦੇ ਮਿਸਰ ਦੇਸ ਤੋਂ ਨਿੱਕਲਣ ਦੇ ਮਗਰੋਂ ਆਈ ");
INSERT INTO pan_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","ਅਤੇ ਇਸਰਾਏਲੀਆਂ ਦੀ ਸਾਰੀ ਮੰਡਲੀ ਮੂਸਾ ਅਤੇ ਹਾਰੂਨ ਨਾਲ ਉਜਾੜ ਵਿੱਚ ਕੁੜ੍ਹਨ ਲੱਗੀ। ");
INSERT INTO pan_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","ਅਤੇ ਇਸਰਾਏਲੀਆਂ ਨੇ ਉਨ੍ਹਾਂ ਨੂੰ ਆਖਿਆ, ਸਾਨੂੰ ਮਿਸਰ ਦੇਸ ਵਿੱਚ ਯਹੋਵਾਹ ਦੇ ਹੱਥੋਂ ਕਿਉਂ ਨਾ ਮਰ ਜਾਣ ਦਿੱਤਾ ਜਦ ਅਸੀਂ ਮਾਸ ਦੀਆਂ ਤੌੜੀਆਂ ਕੋਲ ਬੈਠਦੇ ਅਤੇ ਰੱਜ ਕੇ ਰੋਟੀ ਖਾਂਦੇ ਸੀ? ਪਰ ਤੁਸੀਂ ਸਾਨੂੰ ਇਸ ਉਜਾੜ ਵਿੱਚ ਕੱਢ ਲਿਆਏ ਹੋ ਤਾਂ ਜੋ ਤੁਸੀਂ ਇਸ ਸਾਰੀ ਸਭਾ ਨੂੰ ਭੁੱਖ ਨਾਲ ਮਾਰ ਸੁੱਟੋ। ");
INSERT INTO pan_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","ਫੇਰ ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਆਖਿਆ, ਵੇਖੋ ਮੈਂ ਤੁਹਾਡੇ ਲਈ ਅਕਾਸ਼ ਤੋਂ ਰੋਟੀ ਵਰ੍ਹਾਵਾਂਗਾ ਅਤੇ ਪਰਜਾ ਬਾਹਰ ਜਾ ਕੇ ਇੱਕ ਦਿਨ ਦਾ ਭੋਜਨ ਉਸੇ ਦਿਨ ਇਕੱਠਾ ਕਰੇ ਤਾਂ ਜੋ ਮੈਂ ਉਹ ਨੂੰ ਪਰਖਾਂ ਕਿ ਉਹ ਮੇਰੀ ਬਿਵਸਥਾ ਉੱਤੇ ਚੱਲਦੀ ਹੈ ਕਿ ਨਹੀਂ। ");
INSERT INTO pan_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","ਅਤੇ ਇਸ ਤਰ੍ਹਾਂ ਹੋਵੇਗਾ ਕਿ ਛੇਵੇਂ ਦਿਨ ਜੋ ਉਹ ਲਿਆਉਣਗੇ ਉਹ ਉਸ ਨੂੰ ਤਿਆਰ ਕਰਨ ਅਤੇ ਉਹ ਉਸ ਤੋਂ ਦੁੱਗਣਾ ਹੋਵੇਗਾ ਜਿਹੜਾ ਉਹ ਨਿੱਤ ਇਕੱਠਾ ਕਰਨਗੇ। ");
INSERT INTO pan_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","ਫੇਰ ਮੂਸਾ ਅਤੇ ਹਾਰੂਨ ਨੇ ਸਾਰੇ ਇਸਰਾਏਲੀਆਂ ਨੂੰ ਆਖਿਆ, ਤੁਸੀਂ ਸ਼ਾਮਾਂ ਨੂੰ ਜਾਣੋਗੇ ਕਿ ਯਹੋਵਾਹ ਹੀ ਤੁਹਾਨੂੰ ਮਿਸਰ ਦੇਸ ਤੋਂ ਬਾਹਰ ਲਿਆਇਆ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","ਤੁਸੀਂ ਸਵੇਰ ਨੂੰ ਯਹੋਵਾਹ ਦਾ ਪਰਤਾਪ ਵੇਖੋਗੇ ਕਿਉਂਕਿ ਜੋ ਕੁਝ ਤੁਸੀਂ ਯਹੋਵਾਹ ਉੱਤੇ ਕੁੜ੍ਹਦੇ ਹੋ ਉਹ ਸੁਣਦਾ ਹੈ ਅਤੇ ਅਸੀਂ ਕੀ ਹਾਂ ਜੋ ਤੁਸੀਂ ਸਾਡੇ ਉੱਤੇ ਕੁੜ੍ਹਦੇ ਹੋ? ");
INSERT INTO pan_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","ਮੂਸਾ ਨੇ ਆਖਿਆ, ਇਸ ਤਰ੍ਹਾਂ ਹੋਵੇਗਾ ਕਿ ਯਹੋਵਾਹ ਤੁਹਾਨੂੰ ਸ਼ਾਮਾਂ ਨੂੰ ਮਾਸ ਖਾਣ ਨੂੰ ਦੇਵੇਗਾ ਅਤੇ ਸਵੇਰ ਨੂੰ ਰੱਜਵੀਂ ਰੋਟੀ। ਯਹੋਵਾਹ ਤੁਹਾਡਾ ਕੁੜ੍ਹਨਾ ਸੁਣਦਾ ਹੈ ਜਿਹੜਾ ਤੁਸੀਂ ਉਸ ਉੱਤੇ ਕੁੜ੍ਹਦੇ ਹੋ ਪਰ ਅਸੀਂ ਕੀ ਹਾਂ? ਤੁਹਾਡਾ ਕੁੜ੍ਹਨਾ ਸਾਡੇ ਉੱਤੇ ਨਹੀਂ ਸਗੋਂ ਯਹੋਵਾਹ ਉੱਤੇ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","ਤਾਂ ਮੂਸਾ ਨੇ ਹਾਰੂਨ ਨੂੰ ਆਖਿਆ, ਇਸਰਾਏਲੀਆਂ ਦੀ ਸਾਰੀ ਮੰਡਲੀ ਨੂੰ ਆਖ ਕਿ ਯਹੋਵਾਹ ਦੇ ਨੇੜੇ ਆਓ ਕਿਉਂ ਜੋ ਉਸ ਨੇ ਤੁਹਾਡਾ ਕੁੜ੍ਹਨਾ ਸੁਣਿਆ। ");
INSERT INTO pan_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","ਤਾਂ ਇਸ ਤਰ੍ਹਾਂ ਹੋਇਆ ਕਿ ਜਦ ਹਾਰੂਨ ਇਸਰਾਏਲ ਦੀ ਸਾਰੀ ਮੰਡਲੀ ਨਾਲ ਬੋਲਦਾ ਸੀ ਤਾਂ ਉਨ੍ਹਾਂ ਉਜਾੜ ਵੱਲ ਮੁਹਾਣਾ ਮੋੜਿਆ ਅਤੇ ਵੇਖੋ ਯਹੋਵਾਹ ਦਾ ਪਰਤਾਪ ਬੱਦਲ ਵਿੱਚ ਦਿਖਾਈ ਦਿੱਤਾ। ");
INSERT INTO pan_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","ਯਹੋਵਾਹ ਮੂਸਾ ਨੂੰ ਇਹ ਬੋਲਿਆ, ");
INSERT INTO pan_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","ਮੈਂ ਇਸਰਾਏਲੀਆਂ ਦਾ ਕੁੜ੍ਹਨਾ ਸੁਣਿਆ। ਇਨ੍ਹਾਂ ਨੂੰ ਆਖ ਕਿ ਸ਼ਾਮਾਂ ਨੂੰ ਤੁਸੀਂ ਮਾਸ ਖਾਓਗੇ ਅਤੇ ਸਵੇਰ ਨੂੰ ਤੁਸੀਂ ਰੋਟੀ ਨਾਲ ਰੱਜ ਜਾਓਗੇ ਅਤੇ ਤੁਸੀਂ ਜਾਣੋਗੇ ਕਿ ਮੈਂ ਯਹੋਵਾਹ ਤੁਹਾਡਾ ਪਰਮੇਸ਼ੁਰ ਹਾਂ। ");
INSERT INTO pan_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","ਸ਼ਾਮਾਂ ਨੂੰ ਇਸ ਤਰ੍ਹਾਂ ਹੋਇਆ ਕਿ ਬਟੇਰੇ ਚੜ੍ਹ ਆਏ ਅਤੇ ਡੇਰੇ ਨੂੰ ਢੱਕ ਲਿਆ ਅਤੇ ਸਵੇਰ ਨੂੰ ਡੇਰੇ ਦੇ ਆਲੇ-ਦੁਆਲੇ ਤ੍ਰੇਲ ਪਈ। ");
INSERT INTO pan_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","ਜਦ ਤ੍ਰੇਲ ਉੱਡ ਗਈ ਤਾਂ ਵੇਖੋ ਉਜਾੜ ਦੀ ਪਰਤ ਉੱਤੇ ਨਿੱਕਾ-ਨਿੱਕਾ ਕੱਕਰ ਕੋਰੇ ਵਰਗਾ ਮਹੀਨ ਧਰਤੀ ਉੱਤੇ ਪਿਆ ਹੋਇਆ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","ਜਾਂ ਇਸਰਾਏਲੀਆਂ ਨੇ ਵੇਖਿਆ ਤਾਂ ਉਨ੍ਹਾਂ ਨੇ ਇੱਕ ਦੂਜੇ ਨੂੰ ਆਖਿਆ, ਇਹ ਕੀ ਹੈ? ਕਿਉਂ ਜੋ ਉਹ ਨਹੀਂ ਜਾਣਦੇ ਸਨ ਕਿ ਉਹ ਕੀ ਸੀ। ਉਪਰੰਤ ਮੂਸਾ ਨੇ ਉਨ੍ਹਾਂ ਨੂੰ ਆਖਿਆ, ਇਹ ਉਹ ਰੋਟੀ ਹੈ ਜਿਹੜੀ ਯਹੋਵਾਹ ਤੁਹਾਨੂੰ ਖਾਣ ਲਈ ਦਿੱਤੀ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","ਇਹ ਉਹ ਗੱਲ ਹੈ ਜਿਹ ਦਾ ਯਹੋਵਾਹ ਨੇ ਹੁਕਮ ਦਿੱਤਾ ਕਿ ਉਸ ਵਿੱਚੋਂ ਹਰ ਇੱਕ ਮਨੁੱਖ ਆਪਣੇ ਖਾਣ ਜੋਗਾ ਇਕੱਠਾ ਕਰੇ ਅਰਥਾਤ ਇੱਕ-ਇੱਕ ਓਮਰ ਆਪਣੇ ਪ੍ਰਾਣੀਆਂ ਦੀ ਗਿਣਤੀ ਦੇ ਅਨੁਸਾਰ ਤੁਸੀਂ ਲਵੋ। ਹਰ ਮਨੁੱਖ ਉਨ੍ਹਾਂ ਲਈ ਜਿਹੜੇ ਉਹ ਦੇ ਤੰਬੂ ਵਿੱਚ ਹਨ ਲਵੇ। ");
INSERT INTO pan_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","ਤਾਂ ਇਸਰਾਏਲੀਆਂ ਨੇ ਇਸੇ ਤਰ੍ਹਾਂ ਹੀ ਕੀਤਾ ਅਤੇ ਕਈਆਂ ਨੇ ਵੱਧ ਅਤੇ ਕਈਆਂ ਨੇ ਘੱਟ ਇਕੱਠਾ ਕੀਤਾ। ");
INSERT INTO pan_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","ਜਦ ਉਨ੍ਹਾਂ ਨੇ ਓਮਰ ਨਾਲ ਮਾਪਿਆ ਤਾਂ ਜਿਸ ਨੇ ਵੱਧ ਲਿਆ ਸੀ ਉਸ ਦਾ ਵੱਧ ਨਾ ਨਿੱਕਲਿਆ ਅਤੇ ਜਿਸ ਨੇ ਘੱਟ ਲਿਆ ਸੀ ਉਸ ਦਾ ਘੱਟ ਨਾ ਨਿੱਕਲਿਆ ਪਰ ਹਰ ਇੱਕ ਨੇ ਆਪਣੇ ਖਾਣ ਜੋਗਾ ਪਾਇਆ। ");
INSERT INTO pan_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","ਮੂਸਾ ਨੇ ਉਨ੍ਹਾਂ ਨੂੰ ਆਖਿਆ, ਸਵੇਰ ਤੱਕ ਕੋਈ ਰੱਖ ਨਾ ਛੱਡੇ ");
INSERT INTO pan_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","ਪਰ ਉਨ੍ਹਾਂ ਨੇ ਮੂਸਾ ਦੀ ਨਾ ਸੁਣੀ। ਕਈਆਂ ਨੇ ਉਸ ਵਿੱਚੋਂ ਸਵੇਰ ਤੱਕ ਰੱਖ ਛੱਡਿਆ ਸੋ ਉਸ ਵਿੱਚ ਕੀੜੇ ਪੈ ਗਏ ਅਤੇ ਸੜਿਆਂਧ ਆਉਣ ਲੱਗ ਪਈ। ਤਾਂ ਮੂਸਾ ਉਨ੍ਹਾਂ ਉੱਤੇ ਗਰੰਜ ਹੋਇਆ। ");
INSERT INTO pan_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","ਸੋ ਉਹ ਹਰ ਇੱਕ ਦੇ ਖਾਣ ਜੋਗਾ ਹਰ ਸਵੇਰ ਨੂੰ ਇਕੱਠਾ ਕਰ ਲੈਂਦੇ ਸਨ ਅਤੇ ਜਦ ਧੁੱਪ ਤਿੱਖੀ ਹੁੰਦੀ ਸੀ ਤਾਂ ਉਹ ਢੱਲ਼ ਜਾਂਦਾ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","ਅਤੇ ਇਸ ਤਰ੍ਹਾਂ ਹੋਇਆ ਕਿ ਛੇਵੇਂ ਦਿਨ ਉਨ੍ਹਾਂ ਨੇ ਦੁੱਗਣੀ ਖਾਧ ਇਕੱਠੀ ਕੀਤੀ ਅਰਥਾਤ ਹਰ ਇੱਕ ਲਈ ਦੋ ਓਮਰ ਅਤੇ ਮੰਡਲੀ ਦੇ ਸਾਰੇ ਸਰਦਾਰ ਆਏ ਅਤੇ ਮੂਸਾ ਨੂੰ ਦੱਸਿਆ। ");
INSERT INTO pan_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","ਉਸ ਨੇ ਉਨ੍ਹਾਂ ਨੂੰ ਆਖਿਆ, ਇਹ ਉਹੋ ਹੀ ਗੱਲ ਹੈ ਜਿਹੜੀ ਯਹੋਵਾਹ ਬੋਲਿਆ ਸੀ। ਭਲਕੇ ਯਹੋਵਾਹ ਦੇ ਪਵਿੱਤਰ ਸਬਤ ਦੀ ਮਨਾਉਤਾ ਹੈ ਸੋ ਜੋ ਪਕਾਉਣਾ ਹੈ ਪਕਾ ਲਓ ਅਤੇ ਜੋ ਉਬਾਲਣਾ ਹੈ ਉਬਾਲ ਲਓ ਅਤੇ ਬਾਕੀ ਬਚੇ ਆਪਣੇ ਕੋਲ ਸਵੇਰ ਤੱਕ ਰੱਖ ਛੱਡੋ। ");
INSERT INTO pan_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","ਸੋ ਉਨ੍ਹਾਂ ਨੇ ਉਸ ਨੂੰ ਆਪਣੇ ਸਵੇਰ ਤੱਕ ਰੱਖ ਛੱਡਿਆ ਜਿਵੇਂ ਮੂਸਾ ਨੇ ਹੁਕਮ ਦਿੱਤਾ ਸੀ ਅਤੇ ਉਸ ਵਿੱਚ ਨਾ ਸੜਿਆਂਧ ਸੀ ਅਤੇ ਨਾ ਹੀ ਕੀੜਾ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","ਮੂਸਾ ਨੇ ਆਖਿਆ, ਉਸ ਨੂੰ ਅੱਜ ਖਾਓ ਕਿਉਂ ਜੋ ਅੱਜ ਹੀ ਯਹੋਵਾਹ ਦਾ ਸਬਤ ਹੈ। ਅੱਜ ਉਹ ਤੁਹਾਨੂੰ ਰੜ ਵਿੱਚ ਨਹੀਂ ਲੱਭੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","ਛੇ ਦਿਨ ਤੁਸੀਂ ਇਕੱਠਾ ਕਰੋ ਪਰ ਸੱਤਵਾਂ ਦਿਨ ਸਬਤ ਹੈ। ਉਹ ਦੇ ਵਿੱਚ ਉਹ ਨਾ ਹੋਵੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","ਅਤੇ ਇਸ ਤਰ੍ਹਾਂ ਹੋਇਆ ਕਿ ਸੱਤਵੇਂ ਦਿਨ ਪਰਜਾ ਵਿੱਚੋਂ ਕਈ ਇੱਕ ਇਕੱਠਾ ਕਰਨ ਨੂੰ ਬਾਹਰ ਗਏ ਪਰ ਉਨ੍ਹਾਂ ਨੂੰ ਨਾ ਲੱਭਾ। ");
INSERT INTO pan_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਆਖਿਆ, ਤੁਸੀਂ ਕਦ ਤੱਕ ਮੇਰੇ ਹੁਕਮਾਂ ਅਤੇ ਮੇਰੀ ਬਿਵਸਥਾ ਦੇ ਮੰਨਣ ਤੋਂ ਇਨਕਾਰ ਕਰਦੇ ਰਹੋਗੇ? ");
INSERT INTO pan_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","ਵੇਖੋ ਯਹੋਵਾਹ ਨੇ ਤੁਹਾਨੂੰ ਸਬਤ ਦਿੱਤਾ ਹੈ, ਇਸੇ ਲਈ ਉਹ ਤੁਹਾਨੂੰ ਛੇਵੇਂ ਦਿਨ ਦੋ ਦਿਨਾਂ ਦੀ ਰੋਟੀ ਦਿੰਦਾ ਹੈ। ਤੁਸੀਂ ਹਰ ਇੱਕ ਆਪਣੀ ਥਾਂ ਵਿੱਚ ਰਹੋ। ਕੋਈ ਆਪਣੇ ਨਿਵਾਸ ਤੋਂ ਸਬਤ ਉੱਤੇ ਬਾਹਰ ਨਾ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","ਸੋ ਪਰਜਾ ਨੇ ਸੱਤਵੇਂ ਦਿਨ ਵਿਸ਼ਰਾਮ ਕੀਤਾ। ");
INSERT INTO pan_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","ਇਸਰਾਏਲ ਦੇ ਘਰਾਣੇ ਨੇ ਉਸ ਦਾ ਨਾਮ ਮੰਨ ਰੱਖਿਆ। ਉਹ ਧਨੀਏ ਵਰਗਾ ਬੱਗਾ ਅਤੇ ਉਸ ਦਾ ਸੁਆਦ ਸ਼ਹਿਦ ਵਿੱਚ ਪਕਾਏ ਹੋਏ ਪੂੜੇ ਵਰਗਾ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","ਮੂਸਾ ਨੇ ਆਖਿਆ, ਇਹ ਉਹ ਗੱਲ ਹੈ ਜਿਹ ਦਾ ਯਹੋਵਾਹ ਨੇ ਹੁਕਮ ਦਿੱਤਾ ਸੀ ਕਿ ਆਪਣੀ ਪੀੜ੍ਹੀਓਂ ਪੀੜ੍ਹੀ ਲਈ ਉਸ ਤੋਂ ਇੱਕ ਓਮਰ ਭਰ ਕੇ ਰੱਖ ਛੱਡੋ ਤਾਂ ਜੋ ਉਹ ਉਸ ਰੋਟੀ ਨੂੰ ਵੇਖਣ ਜਿਹੜੀ ਮੈਂ ਤੁਹਾਨੂੰ ਉਜਾੜ ਵਿੱਚ ਖਵਾਈ ਜਦ ਮੈਂ ਤੁਹਾਨੂੰ ਮਿਸਰ ਦੇਸੋਂ ਕੱਢ ਕੇ ਲੈ ਆਇਆ। ");
INSERT INTO pan_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","ਮੂਸਾ ਨੇ ਹਾਰੂਨ ਨੂੰ ਆਖਿਆ, ਇੱਕ ਕੁੱਜਾ ਲੈ ਕੇ ਉਸ ਵਿੱਚ ਇੱਕ ਪੂਰਾ ਓਮਰ ਮੰਨ ਪਾ ਦੇ ਅਤੇ ਉਹ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਰੱਖ ਛੱਡ ਤਾਂ ਜੋ ਤੁਹਾਡੀਆਂ ਪੀੜ੍ਹੀਆਂ ਤੱਕ ਸਾਂਭਿਆ ਰਹੇ। ");
INSERT INTO pan_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","ਜਿਵੇਂ ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਹੁਕਮ ਦਿੱਤਾ ਸੀ ਤਿਵੇਂ ਹੀ ਹਾਰੂਨ ਨੇ ਸਾਖੀ ਦੇ ਅੱਗੇ ਉਸ ਨੂੰ ਸੰਭਾਲ ਰੱਖਿਆ ");
INSERT INTO pan_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","ਅਤੇ ਇਸਰਾਏਲੀਆਂ ਨੇ ਚਾਲ੍ਹੀ ਸਾਲਾਂ ਤੱਕ ਉਸ ਮੰਨ ਨੂੰ ਖਾਧਾ ਜਦ ਤੱਕ ਉਹ ਆਪਣੇ ਵੱਸਣ ਦੀ ਧਰਤੀ ਵਿੱਚ ਨਾ ਆਏ। ਉਨ੍ਹਾਂ ਨੇ ਉਸ ਮੰਨ ਨੂੰ ਖਾਧਾ ਜਦ ਤੱਕ ਉਹ ਕਨਾਨ ਦੇਸ ਦੀਆਂ ਹੱਦਾਂ ਵਿੱਚ ਨਾ ਆਏ। ");
INSERT INTO pan_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","ਇੱਕ ਓਮਰ ਏਫ਼ਾਹ ਦਾ ਦੱਸਵਾਂ ਹਿੱਸਾ ਹੁੰਦਾ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","ਇਸਰਾਏਲੀਆਂ ਦੀ ਸਾਰੀ ਮੰਡਲੀ ਨੇ ਸੀਨ ਦੀ ਉਜਾੜ ਵਿੱਚੋਂ ਯਹੋਵਾਹ ਦੇ ਆਖਣ ਅਨੁਸਾਰ ਆਪਣੇ ਸਫ਼ਰਾਂ ਲਈ ਕੂਚ ਕੀਤਾ ਅਤੇ ਉਨ੍ਹਾਂ ਨੇ ਰਫ਼ੀਦੀਮ ਵਿੱਚ ਡੇਰੇ ਲਾਏ ਪਰ ਪਰਜਾ ਦੇ ਪੀਣ ਲਈ ਪਾਣੀ ਨਹੀਂ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","ਪਰਜਾ ਮੂਸਾ ਨਾਲ ਝਗੜਨ ਲੱਗੀ ਅਤੇ ਆਖਿਆ, ਸਾਨੂੰ ਪੀਣ ਨੂੰ ਪਾਣੀ ਦੇ। ਮੂਸਾ ਨੇ ਉਨ੍ਹਾਂ ਨੂੰ ਆਖਿਆ, ਤੁਸੀਂ ਮੇਰੇ ਨਾਲ ਕਿਉਂ ਝਗੜਦੇ ਹੋ ਅਤੇ ਯਹੋਵਾਹ ਨੂੰ ਕਿਉਂ ਪਰਤਾਉਂਦੇ ਹੋ? ");
INSERT INTO pan_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","ਉੱਥੇ ਪਰਜਾ ਪਾਣੀ ਦੀ ਤਿਹਾਈ ਸੀ ਅਤੇ ਮੂਸਾ ਨਾਲ ਇਹ ਆਖ ਕੇ ਕੁੜ੍ਹਦੀ ਸੀ ਕਿ ਇਹ ਕੀ ਹੈ ਜੋ ਤੂੰ ਸਾਨੂੰ ਮਿਸਰ ਤੋਂ ਲਿਆਇਆ ਹੈਂ ਕਿ ਸਾਨੂੰ ਅਤੇ ਸਾਡੇ ਪੁੱਤਰਾਂ ਅਤੇ ਸਾਡੇ ਵੱਗਾਂ ਨੂੰ ਐਥੇ ਤਿਹਾਇਆ ਮਾਰੇਂ? ");
INSERT INTO pan_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","ਤਾਂ ਮੂਸਾ ਨੇ ਯਹੋਵਾਹ ਨੂੰ ਉੱਚੀ ਦਿੱਤੀ ਪੁਕਾਰ ਕੇ ਆਖਿਆ, ਮੈਂ ਇਨ੍ਹਾਂ ਲੋਕਾਂ ਨਾਲ ਕੀ ਕਰਾਂ? ਇਹ ਤਾਂ ਮੈਨੂੰ ਥੋੜੇ ਚਿਰਾਂ ਤੱਕ ਵੱਟੇ ਮਾਰਨਗੇ। ");
INSERT INTO pan_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","ਫੇਰ ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਆਖਿਆ, ਪਰਜਾ ਦੇ ਅੱਗੋਂ ਦੀ ਲੰਘ ਅਤੇ ਆਪਣੇ ਨਾਲ ਇਸਰਾਏਲ ਦੇ ਬਜ਼ੁਰਗਾਂ ਵਿੱਚੋਂ ਲੈ ਤੇ ਆਪਣੇ ਢਾਂਗੇ ਨੂੰ ਜਿਹੜਾ ਤੂੰ ਨਦੀ ਉੱਤੇ ਮਾਰਿਆ ਸੀ ਆਪਣੇ ਹੱਥ ਵਿੱਚ ਲੈ ਅਤੇ ਚੱਲ ਦੇl ");
INSERT INTO pan_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","ਵੇਖ ਮੈਂ ਤੇਰੇ ਅੱਗੇ ਹੋਰੇਬ ਦੀ ਚੱਟਾਨ ਉੱਤੇ ਖੜਾ ਹੋਵਾਂਗਾ ਅਤੇ ਤੂੰ ਚੱਟਾਨ ਨੂੰ ਮਾਰੀਂ ਤਾਂ ਉਸ ਵਿੱਚੋਂ ਪਾਣੀ ਨਿੱਕਲੇਗਾ ਤਾਂ ਜੋ ਪਰਜਾ ਪੀਵੇ। ਤਾਂ ਮੂਸਾ ਨੇ ਇਸਰਾਏਲ ਦੇ ਬਜ਼ੁਰਗਾਂ ਦੇ ਸਨਮੁਖ ਉਸੇ ਤਰ੍ਹਾਂ ਹੀ ਕੀਤਾ। ");
INSERT INTO pan_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","ਅਤੇ ਉਸ ਨੇ ਉਸ ਥਾਂ ਦਾ ਨਾਮ ਮੱਸਾਹ ਅਤੇ ਮਰੀਬਾਹ ਇਸਰਾਏਲ ਦੇ ਝਗੜਨ ਦੇ ਕਾਰਨ ਅਤੇ ਯਹੋਵਾਹ ਦੇ ਪਰਤਾਵੇ ਦੇ ਕਾਰਨ ਇਹ ਆਖਦੇ ਹੋਏ ਰੱਖਿਆ ਕਿ ਯਹੋਵਾਹ ਸਾਡੇ ਵਿਚਕਾਰ ਹੈ ਕਿ ਨਹੀਂ? ");
INSERT INTO pan_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","ਫੇਰ ਅਮਾਲੇਕ ਆਏ ਅਤੇ ਰਫ਼ੀਦੀਮ ਵਿੱਚ ਇਸਰਾਏਲ ਨਾਲ ਲੜੇ। ");
INSERT INTO pan_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","ਤਾਂ ਮੂਸਾ ਨੇ ਯਹੋਸ਼ੁਆ ਨੂੰ ਆਖਿਆ, ਸਾਡੇ ਲਈ ਮਨੁੱਖਾਂ ਨੂੰ ਚੁਣ ਅਤੇ ਨਿੱਕਲ ਕੇ ਅਮਾਲੇਕ ਨਾਲ ਲੜ। ਕੱਲ ਮੈਂ ਪਰਮੇਸ਼ੁਰ ਦਾ ਢਾਂਗਾ ਲੈ ਕੇ ਟਿੱਲੇ ਦੀ ਟੀਸੀ ਉੱਤੇ ਖੜਾ ਰਹਾਂਗਾ। ");
INSERT INTO pan_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","ਸੋ ਯਹੋਸ਼ੁਆ ਨੇ ਤਿਵੇਂ ਹੀ ਕੀਤਾ ਜਿਵੇਂ ਉਸ ਨੂੰ ਮੂਸਾ ਨੇ ਆਖਿਆ ਸੀ। ਉਹ ਅਮਾਲੇਕ ਦੇ ਨਾਲ ਲੜਿਆ ਅਤੇ ਮੂਸਾ, ਹਾਰੂਨ ਅਤੇ ਹੂਰ ਟਿੱਲੇ ਦੀ ਟੀਸੀ ਉੱਤੇ ਚੜ੍ਹੇ। ");
INSERT INTO pan_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","ਤਾਂ ਇਸ ਤਰ੍ਹਾਂ ਹੋਇਆ ਕਿ ਜਦ ਮੂਸਾ ਆਪਣਾ ਹੱਥ ਚੁੱਕਦਾ ਸੀ ਤਾਂ ਇਸਰਾਏਲ ਜਿੱਤਦਾ ਸੀ ਅਤੇ ਜਦ ਆਪਣਾ ਹੱਥ ਨੀਵਾਂ ਕਰ ਲੈਂਦਾ ਸੀ ਤਾਂ ਅਮਾਲੇਕ ਜਿੱਤਦਾ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","ਪਰ ਮੂਸਾ ਦੇ ਹੱਥ ਭਾਰੀ ਹੋ ਗਏ ਤਾਂ ਉਨ੍ਹਾਂ ਨੇ ਪੱਥਰ ਲੈ ਕੇ ਉਸ ਦੇ ਹੇਠ ਰੱਖ ਦਿੱਤਾ ਅਤੇ ਉਹ ਉਸ ਉੱਤੇ ਬੈਠ ਗਿਆ ਅਤੇ ਹਾਰੂਨ ਅਤੇ ਹੂਰ ਨੇ ਇੱਕ ਨੇ ਇੱਕ ਪਾਸਿਓਂ ਅਤੇ ਦੂਜੇ ਨੇ ਦੂਜੇ ਪਾਸਿਓਂ ਉਸ ਦੇ ਹੱਥਾਂ ਨੂੰ ਸਾਂਭ ਛੱਡਿਆ ਤਾਂ ਉਸ ਦੇ ਹੱਥ ਸੂਰਜ ਦੇ ਆਥਣ ਤੱਕ ਤਕੜੇ ਰਹੇ ");
INSERT INTO pan_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","ਅਤੇ ਯਹੋਸ਼ੁਆ ਨੇ ਅਮਾਲੇਕ ਅਤੇ ਉਸ ਦੇ ਲੋਕਾਂ ਨੂੰ ਤਲਵਾਰ ਦੀ ਧਾਰ ਨਾਲ ਹਰਾ ਦਿੱਤਾ। ");
INSERT INTO pan_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਆਖਿਆ, ਇਸ ਨੂੰ ਚੇਤੇ ਰੱਖਣ ਲਈ ਪੁਸਤਕ ਵਿੱਚ ਲਿਖ ਲੈ ਅਤੇ ਯਹੋਸ਼ੁਆ ਦੇ ਕੰਨਾਂ ਵਿੱਚ ਸੁਣਾ ਕਿਉਂਕਿ ਮੈਂ ਅਮਾਲੇਕ ਦਾ ਚੇਤਾ ਅਕਾਸ਼ ਦੇ ਹੇਠੋਂ ਮਿਟਾ ਦੇਵਾਂਗਾ। ");
INSERT INTO pan_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","ਮੂਸਾ ਨੇ ਜਗਵੇਦੀ ਬਣਾਈ ਅਤੇ ਉਸ ਦਾ ਨਾਮ ਯਹੋਵਾਹ ਨਿੱਸੀ ਰੱਖਿਆ ");
INSERT INTO pan_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","ਅਤੇ ਉਸ ਆਖਿਆ ਕਿ ਯਹੋਵਾਹ ਦੇ ਸਿੰਘਾਸਣ ਉੱਤੇ ਸਹੁੰ ਇਹ ਹੈ ਕਿ ਅਮਾਲੇਕ ਦੇ ਨਾਲ ਯਹੋਵਾਹ ਦਾ ਯੁੱਧ ਪੀੜ੍ਹੀਓਂ ਪੀੜ੍ਹੀ ਤੱਕ ਹੁੰਦਾ ਰਹੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","ਜਦ ਮੂਸਾ ਦੇ ਸੌਹਰੇ ਯਿਥਰੋ ਨੇ ਜਿਹੜਾ ਮਿਦਯਾਨ ਦਾ ਜਾਜਕ ਸੀ ਸਭ ਕੁਝ ਜੋ ਪਰਮੇਸ਼ੁਰ ਨੇ ਮੂਸਾ ਅਤੇ ਆਪਣੀ ਪਰਜਾ ਇਸਰਾਏਲ ਲਈ ਕੀਤਾ ਸੁਣਿਆ ਅਰਥਾਤ ਜਿਵੇਂ ਯਹੋਵਾਹ ਇਸਰਾਏਲ ਨੂੰ ਮਿਸਰੋਂ ਬਾਹਰ ਲੈ ਆਇਆ। ");
INSERT INTO pan_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","ਤਦ ਮੂਸਾ ਦੇ ਸੌਹਰੇ ਯਿਥਰੋ ਨੇ ਮੂਸਾ ਦੀ ਪਤਨੀ ਸਿੱਪੋਰਾਹ ਨੂੰ ਉਸ ਦੇ ਛੱਡਣ ਦੇ ਪਿੱਛੋਂ ਲਿਆ ");
INSERT INTO pan_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","ਨਾਲੇ ਉਸ ਦੇ ਦੋਹਾਂ ਪੁੱਤਰਾਂ ਨੂੰ ਜਿਨ੍ਹਾਂ ਵਿੱਚੋਂ ਇੱਕ ਦਾ ਨਾਮ ਗੇਰਸ਼ੋਮ ਸੀ ਕਿਉਂ ਜੋ ਉਸ ਆਖਿਆ, ਮੈਂ ਪਰਦੇਸ ਵਿੱਚ ਓਪਰਾ ਰਿਹਾ। ");
INSERT INTO pan_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","ਅਤੇ ਦੂਜੇ ਦਾ ਨਾਮ ਅਲੀਅਜ਼ਰ ਸੀ ਕਿਉਂ ਜੋ ਉਸ ਆਖਿਆ, ਮੇਰੇ ਪਿਤਾ ਦਾ ਪਰਮੇਸ਼ੁਰ ਮੇਰਾ ਸਹਾਇਕ ਸੀ ਅਤੇ ਮੈਨੂੰ ਫ਼ਿਰਊਨ ਦੀ ਤਲਵਾਰ ਤੋਂ ਬਚਾਇਆ। ");
INSERT INTO pan_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","ਅਤੇ ਮੂਸਾ ਦਾ ਸੌਹਰਾ ਯਿਥਰੋ ਉਸ ਦੇ ਪੁੱਤਰਾਂ ਅਤੇ ਉਸ ਦੀ ਪਤਨੀ ਨੂੰ ਉਜਾੜ ਵਿੱਚ ਮੂਸਾ ਕੋਲ ਲਿਆਇਆ ਜਿੱਥੇ ਉਸ ਨੇ ਪਰਮੇਸ਼ੁਰ ਦੇ ਪਰਬਤ ਉੱਤੇ ਡੇਰਾ ਲਾਇਆ ਹੋਇਆ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","ਉਹ ਨੇ ਮੂਸਾ ਨੂੰ ਆਖਿਆ, ਮੈਂ ਤੇਰਾ ਸੌਹਰਾ ਯਿਥਰੋ ਅਤੇ ਤੇਰੀ ਪਤਨੀ ਉਹ ਦੇ ਦੋਹਾਂ ਪੁੱਤਰਾਂ ਨਾਲ ਤੇਰੇ ਕੋਲ ਆਏ ਹਾਂ। ");
INSERT INTO pan_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","ਤਦ ਮੂਸਾ ਆਪਣੇ ਸੌਹਰੇ ਨੂੰ ਮਿਲਣ ਲਈ ਬਾਹਰ ਆਇਆ ਅਤੇ ਉਸ ਦੇ ਅੱਗੇ ਨਿਵਿਆ ਅਤੇ ਉਸ ਨੂੰ ਚੁੰਮਿਆ ਅਤੇ ਇੱਕ ਦੂਜੇ ਦੀ ਸੁੱਖ-ਸਾਂਦ ਪੁੱਛੀ ਅਤੇ ਤੰਬੂ ਵਿੱਚ ਆਏ। ");
INSERT INTO pan_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","ਮੂਸਾ ਨੇ ਆਪਣੇ ਸੌਹਰੇ ਨੂੰ ਉਹ ਸਭ ਕੁਝ ਜਿਹੜਾ ਯਹੋਵਾਹ ਨੇ ਇਸਰਾਏਲ ਦੇ ਕਾਰਨ ਫ਼ਿਰਊਨ ਅਤੇ ਮਿਸਰੀਆਂ ਨਾਲ ਕੀਤਾ ਅਤੇ ਉਹ ਕਸ਼ਟ ਜਿਹੜਾ ਰਾਹ ਵਿੱਚ ਉਨ੍ਹਾਂ ਉੱਤੇ ਆਇਆ ਅਤੇ ਯਹੋਵਾਹ ਨੇ ਕਿਵੇਂ ਉਨ੍ਹਾਂ ਨੂੰ ਬਚਾਇਆ ਦੱਸਿਆ। ");
INSERT INTO pan_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","ਤਦ ਯਿਥਰੋ ਉਸ ਸਾਰੀ ਭਲਿਆਈ ਦੇ ਕਾਰਨ ਜਿਹੜੀ ਯਹੋਵਾਹ ਨੇ ਇਸਰਾਏਲ ਨਾਲ ਕੀਤੀ ਜਦ ਉਸ ਨੂੰ ਮਿਸਰੀਆਂ ਦੇ ਹੱਥੋਂ ਬਚਾ ਦਿੱਤਾ ਅਨੰਦ ਹੋਇਆ। ");
INSERT INTO pan_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","ਯਿਥਰੋ ਨੇ ਆਖਿਆ, ਯਹੋਵਾਹ ਮੁਬਾਰਕ ਹੈ ਜਿਸ ਤੁਹਾਨੂੰ ਮਿਸਰੀਆਂ ਦੇ ਹੱਥੋਂ ਅਤੇ ਫ਼ਿਰਊਨ ਦੇ ਹੱਥੋਂ ਬਚਾ ਦਿੱਤਾ ਅਤੇ ਜਿਸ ਲੋਕਾਂ ਨੂੰ ਮਿਸਰੀਆਂ ਦੇ ਹੱਥ ਹੇਠੋਂ ਬਚਾਇਆ। ");
INSERT INTO pan_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","ਹੁਣ ਮੈਂ ਜਾਣਿਆ ਕਿ ਯਹੋਵਾਹ ਸਾਰੇ ਦੇਵਤਿਆਂ ਨਾਲੋਂ ਵੱਡਾ ਹੈ ਹਾਂ, ਉਸ ਗੱਲ ਵਿੱਚ ਵੀ ਜਿਸ ਵਿੱਚ ਉਹ ਉਨ੍ਹਾਂ ਉੱਤੇ ਘਮੰਡ ਕਰਦੇ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","ਮੂਸਾ ਦਾ ਸੌਹਰਾ ਯਿਥਰੋ ਹੋਮ ਦੀ ਭੇਟ ਅਤੇ ਬਲੀਆਂ ਪਰਮੇਸ਼ੁਰ ਲਈ ਲਿਆਇਆ ਅਤੇ ਹਾਰੂਨ ਅਤੇ ਇਸਰਾਏਲ ਦੇ ਸਾਰੇ ਬਜ਼ੁਰਗ ਮੂਸਾ ਦੇ ਸੌਹਰੇ ਯਿਥਰੋ ਨਾਲ ਪਰਮੇਸ਼ੁਰ ਦੇ ਸਨਮੁਖ ਰੋਟੀ ਖਾਣ ਲਈ ਆਏ। ");
INSERT INTO pan_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","ਅਗਲੇ ਦਿਨ ਇਸ ਤਰ੍ਹਾਂ ਹੋਇਆ ਕਿ ਮੂਸਾ ਪਰਜਾ ਦਾ ਨਿਆਂ ਕਰਨ ਲਈ ਬੈਠਾ ਅਤੇ ਪਰਜਾ ਮੂਸਾ ਦੇ ਅੱਗੇ ਸਵੇਰ ਤੋਂ ਸ਼ਾਮ ਤੱਕ ਖੜੀ ਰਹੀ। ");
INSERT INTO pan_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","ਜਦ ਮੂਸਾ ਦੇ ਸੌਹਰੇ ਨੇ ਉਹ ਸਭ ਕੁਝ ਜੋ ਉਸ ਨੇ ਪਰਜਾ ਨਾਲ ਕੀਤਾ ਵੇਖਿਆ ਤਾਂ ਆਖਿਆ, ਇਹ ਕੀ ਗੱਲ ਹੈ ਜੋ ਤੂੰ ਪਰਜਾ ਨਾਲ ਕਰਦਾ ਹੈਂ? ਤੂੰ ਕਿਉਂ ਇਕੱਲਾ ਬੈਠਦਾ ਹੈਂ ਅਤੇ ਸਾਰੀ ਪਰਜਾ ਸਵੇਰ ਤੋਂ ਸ਼ਾਮ ਤੱਕ ਤੇਰੇ ਅੱਗੇ ਖੜੀ ਰਹਿੰਦੀ ਹੈ? ");
INSERT INTO pan_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","ਤਾਂ ਮੂਸਾ ਨੇ ਆਪਣੇ ਸੌਹਰੇ ਨੂੰ ਆਖਿਆ, ਇਸ ਕਰਕੇ ਕਿ ਪਰਜਾ ਮੇਰੇ ਕੋਲ ਪਰਮੇਸ਼ੁਰ ਦੀ ਭਾਲ ਲਈ ਆਉਂਦੀ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","ਜਦ ਉਨ੍ਹਾਂ ਵਿੱਚ ਕੋਈ ਗੱਲ ਹੁੰਦੀ ਹੈ ਤਾਂ ਉਹ ਮੇਰੇ ਕੋਲ ਆਉਂਦੇ ਹਨ ਮੈਂ ਉਸ ਮਨੁੱਖ ਅਤੇ ਉਸ ਦੇ ਗੁਆਂਢੀ ਵਿੱਚ ਨਿਆਂ ਕਰ ਦਿੰਦਾ ਹਾਂ ਅਤੇ ਮੈਂ ਉਨ੍ਹਾਂ ਨੂੰ ਪਰਮੇਸ਼ੁਰ ਦੀਆਂ ਬਿਧੀਆਂ ਅਤੇ ਬਿਵਸਥਾ ਦਸ ਦਿੰਦਾ ਹਾਂ। ");
INSERT INTO pan_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","ਤਾਂ ਮੂਸਾ ਦੇ ਸੌਹਰੇ ਨੇ ਉਹ ਨੂੰ ਆਖਿਆ, ਜੋ ਤੂੰ ਕਰਦਾ ਹੈਂ ਸੋ ਚੰਗੀ ਗੱਲ ਨਹੀਂ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","ਤੂੰ ਜ਼ਰੂਰ ਥੱਕ ਜਾਵੇਂਗਾ, ਤੂੰ ਵੀ ਅਤੇ ਤੇਰੇ ਨਾਲ ਇਹ ਲੋਕ ਵੀ ਕਿਉਂ ਜੋ ਇਹ ਕੰਮ ਤੇਰੇ ਲਈ ਬਹੁਤਾ ਭਾਰੀ ਹੈ। ਤੂੰ ਇਕੱਲਾ ਇਸ ਨੂੰ ਨਹੀਂ ਕਰ ਸਕਦਾ। ");
INSERT INTO pan_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","ਤੂੰ ਹੁਣ ਮੇਰੀ ਗੱਲ ਸੁਣ। ਮੈਂ ਤੈਨੂੰ ਮੱਤ ਦਿੰਦਾ ਹਾਂ ਅਤੇ ਪਰਮੇਸ਼ੁਰ ਤੇਰੇ ਨਾਲ ਹੋਵੇਗਾ। ਤੂੰ ਲੋਕਾਂ ਲਈ ਪਰਮੇਸ਼ੁਰ ਦੇ ਥਾਂ ਰਹੀਂ ਅਤੇ ਤੂੰ ਉਨ੍ਹਾਂ ਗੱਲਾਂ ਨੂੰ ਪਰਮੇਸ਼ੁਰ ਅੱਗੇ ਲਿਆਈਂ। ");
INSERT INTO pan_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","ਤੂੰ ਬਿਧੀਆਂ ਅਤੇ ਬਿਵਸਥਾਵਾਂ ਉਨ੍ਹਾਂ ਨੂੰ ਸਿਖਾ ਅਤੇ ਉਹ ਰਾਹ ਜਿਸ ਉੱਤੇ ਚੱਲਣਾ ਹੈ ਅਤੇ ਉਹ ਕੰਮ ਜਿਸ ਨੂੰ ਕਰਨਾ ਹੈ ਉਨ੍ਹਾਂ ਨੂੰ ਦਸ ਦੇ। ");
INSERT INTO pan_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","ਨਾਲੇ ਤੂੰ ਸਾਰਿਆਂ ਲੋਕਾਂ ਵਿੱਚੋਂ ਸਿਆਣੇ ਮਨੁੱਖਾਂ ਨੂੰ ਜਿਹੜੇ ਪਰਮੇਸ਼ੁਰ ਤੋਂ ਡਰਦੇ ਅਤੇ ਸੱਚੇ ਅਤੇ ਲੋਭ ਦੇ ਵੈਰੀ ਹੋਣ ਚੁਣ ਲੈ। ਉਨ੍ਹਾਂ ਨੂੰ ਲੋਕਾਂ ਉੱਤੇ ਹਜ਼ਾਰਾਂ ਦੇ ਸਰਦਾਰ ਸੈਂਕੜਿਆਂ ਦੇ ਸਰਦਾਰ, ਪੰਜਾਹ ਦੇ ਸਰਦਾਰ ਅਤੇ ਦਸਾਂ ਦੇ ਸਰਦਾਰ ਠਹਿਰਾ ਦੇਣਾ। ");
INSERT INTO pan_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","ਉਹ ਹਰ ਵੇਲੇ ਲੋਕਾਂ ਦਾ ਨਿਆਂ ਕਰਨ ਅਤੇ ਇਸ ਤਰ੍ਹਾਂ ਹੋਵੇ ਕਿ ਹਰ ਇੱਕ ਵੱਡੀ ਗੱਲ ਤੇਰੇ ਕੋਲ ਲਿਆਉਣ ਪਰ ਛੋਟੀਆਂ ਗੱਲਾਂ ਨੂੰ ਆਪ ਨਬੇੜਨ ਸੋ ਇਸ ਤਰ੍ਹਾਂ ਤੇਰੇ ਲਈ ਸੌਖਾ ਰਹੇਗਾ ਅਤੇ ਉਹ ਤੇਰੇ ਨਾਲ ਭਾਰ ਹਲਕਾ ਕਰਨ। ");
INSERT INTO pan_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","ਜੇ ਤੂੰ ਇਸ ਗੱਲ ਨੂੰ ਕਰੇਂਗਾ ਅਤੇ ਪਰਮੇਸ਼ੁਰ ਤੈਨੂੰ ਹੁਕਮ ਦੇਵੇ ਤਾਂ ਤੂੰ ਝੱਲ ਸਕੇਂਗਾ ਅਤੇ ਇਹ ਸਾਰੇ ਲੋਕ ਵੀ ਸੁੱਖ-ਸਾਂਦ ਨਾਲ ਆਪਣੇ ਸਥਾਨਾਂ ਨੂੰ ਜਾਣਗੇ। ");
INSERT INTO pan_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","ਸੋ ਮੂਸਾ ਨੇ ਆਪਣੇ ਸੌਹਰੇ ਦੀ ਗੱਲ ਨੂੰ ਸੁਣਿਆ ਅਤੇ ਜੋ ਉਸ ਆਖਿਆ ਸੀ ਸੋ ਹੀ ਕੀਤਾ। ");
INSERT INTO pan_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","ਤਦ ਮੂਸਾ ਨੇ ਸਿਆਣੇ ਮਨੁੱਖਾਂ ਨੂੰ ਇਸਰਾਏਲ ਵਿੱਚੋਂ ਚੁਣ ਕੇ ਉਹਨਾਂ ਨੂੰ ਪਰਜਾ ਉੱਤੇ ਪ੍ਰਧਾਨ ਠਹਿਰਾਇਆ ਹਜ਼ਾਰਾਂ ਦੇ ਪ੍ਰਧਾਨ, ਸੈਂਕੜਿਆਂ ਦੇ ਪ੍ਰਧਾਨ, ਪੰਜਾਹਾਂ ਦੇ ਪ੍ਰਧਾਨ ਅਤੇ ਦਸਾਂ ਦੇ ਪ੍ਰਧਾਨ। ");
INSERT INTO pan_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","ਉਹ ਹਰ ਵੇਲੇ ਪਰਜਾ ਦਾ ਨਿਆਂ ਕਰਦੇ ਸਨ ਅਤੇ ਔਖਾ ਕੰਮ ਮੂਸਾ ਕੋਲ ਲਿਆਉਂਦੇ ਸਨ ਪਰ ਸਾਰੇ ਛੋਟੇ ਕੰਮ ਆਪ ਨਬੇੜ ਲੈਂਦੇ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","ਮੂਸਾ ਨੇ ਆਪਣੇ ਸੌਹਰੇ ਨੂੰ ਵਿਦਿਆ ਕੀਤਾ ਤਾਂ ਉਹ ਆਪਣੇ ਦੇਸ ਦੇ ਰਾਹ ਪੈ ਗਿਆ। ");
INSERT INTO pan_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","ਤੀਜੇ ਮਹੀਨੇ ਦੇ ਉਸੇ ਦਿਨ ਵਿੱਚ ਜਦ ਇਸਰਾਏਲੀ ਮਿਸਰ ਦੇਸ ਤੋਂ ਨਿੱਕਲੇ ਉਹ ਸੀਨਈ ਦੀ ਉਜਾੜ ਵਿੱਚ ਆਏ। ");
INSERT INTO pan_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","ਅਤੇ ਰਫ਼ੀਦੀਮ ਤੋਂ ਕੂਚ ਕਰ ਕੇ ਸੀਨਈ ਦੀ ਉਜਾੜ ਵਿੱਚ ਪਹੁੰਚੇ ਅਤੇ ਉੱਥੇ ਉਜਾੜ ਵਿੱਚ ਡੇਰੇ ਲਾਏ ਅਤੇ ਇਸਰਾਏਲ ਨੇ ਪਰਬਤ ਦੇ ਅੱਗੇ ਡੇਰਾ ਕੀਤਾ। ");
INSERT INTO pan_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","ਤਾਂ ਮੂਸਾ ਪਰਮੇਸ਼ੁਰ ਕੋਲ ਚੜ੍ਹ ਗਿਆ ਅਤੇ ਯਹੋਵਾਹ ਨੇ ਪਰਬਤ ਤੋਂ ਉਸ ਨੂੰ ਪੁਕਾਰ ਕੇ ਆਖਿਆ ਤੂੰ ਯਾਕੂਬ ਦੇ ਘਰਾਣੇ ਨੂੰ ਇਸ ਤਰ੍ਹਾਂ ਆਖ ਅਤੇ ਇਸਰਾਏਲੀਆਂ ਨੂੰ ਦੱਸ ");
INSERT INTO pan_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","ਕਿ ਤੁਸੀਂ ਵੇਖਿਆ ਜੋ ਮੈਂ ਇਸਰਾਏਲੀਆਂ ਨਾਲ ਕੀਤਾ ਅਤੇ ਤੁਹਾਨੂੰ ਉਕਾਬ ਦੇ ਖੰਭਾ ਉੱਤੇ ਬੈਠਾ ਕੇ ਆਪਣੇ ਕੋਲ ਲੈ ਆਇਆ। ");
INSERT INTO pan_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","ਹੁਣ ਜੇ ਤੁਸੀਂ ਮੇਰੀ ਅਵਾਜ਼ ਦੇ ਸਰੋਤੇ ਹੋਵੋਗੇ ਅਤੇ ਮੇਰੇ ਨੇਮ ਦੀ ਮਨੌਤ ਕਰੋਗੇ ਤਾਂ ਤੁਸੀਂ ਸਾਰੀਆਂ ਕੌਮਾਂ ਵਿੱਚੋਂ ਮੇਰੀ ਨਿੱਜ-ਪਰਜਾ ਹੋਵੋਗੇ ਕਿਉਂ ਜੋ ਸਾਰੀ ਧਰਤੀ ਮੇਰੀ ਹੈ ");
INSERT INTO pan_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","ਅਤੇ ਤੁਸੀਂ ਮੇਰੇ ਲਈ ਜਾਜਕਾਂ ਦੀ ਸ਼ਾਹੀ ਮੰਡਲੀ ਅਤੇ ਪਵਿੱਤਰ ਕੌਮ ਹੋਵੋਗੇ। ਇਹ ਉਹ ਗੱਲਾਂ ਹਨ ਜਿਹੜੀਆਂ ਤੂੰ ਇਸਰਾਏਲੀਆਂ ਨੂੰ ਦੱਸੇਂਗਾ। ");
INSERT INTO pan_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","ਮੂਸਾ ਨੇ ਆ ਕੇ ਪਰਜਾ ਦੇ ਬਜ਼ੁਰਗਾਂ ਨੂੰ ਬੁਲਾਇਆ ਅਤੇ ਉਹ ਸਾਰੀਆਂ ਗੱਲਾਂ ਉਨ੍ਹਾਂ ਦੇ ਅੱਗੇ ਰੱਖੀਆਂ ਜਿਹੜੀਆਂ ਦਾ ਯਹੋਵਾਹ ਨੇ ਉਸ ਨੂੰ ਹੁਕਮ ਦਿੱਤਾ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","ਫਿਰ ਸਾਰੀ ਪਰਜਾ ਨੇ ਰਲ ਕੇ ਉੱਤਰ ਦਿੱਤਾ, ਸਭ ਕੁਝ ਜੋ ਯਹੋਵਾਹ ਬੋਲਿਆ ਹੈ ਅਸੀਂ ਕਰਾਂਗੇ। ਤਾਂ ਮੂਸਾ ਨੇ ਪਰਜਾ ਦੀਆਂ ਗੱਲਾਂ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਰੱਖੀਆਂ। ");
INSERT INTO pan_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","ਅਤੇ ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਆਖਿਆ, ਵੇਖ ਮੈਂ ਤੇਰੇ ਕੋਲ ਬੱਦਲ ਦੇ ਓਹਲੇ ਵਿੱਚ ਆਉਂਦਾ ਹਾਂ ਤਾਂ ਜੋ ਪਰਜਾ ਗੱਲਾਂ ਸੁਣੇ ਜਿਹੜੀਆਂ ਮੈਂ ਤੇਰੇ ਨਾਲ ਕਰਾਂ ਨਾਲੇ ਉਹ ਸਦਾ ਲਈ ਤੇਰੇ ਉੱਤੇ ਪਰਤੀਤ ਕਰੇ। ਤਾਂ ਮੂਸਾ ਨੇ ਪਰਜਾ ਦੀਆਂ ਗੱਲਾਂ ਯਹੋਵਾਹ ਨੂੰ ਦੱਸੀਆਂ। ");
INSERT INTO pan_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਆਖਿਆ, ਪਰਜਾ ਕੋਲ ਜਾ ਅਤੇ ਅੱਜ ਅਤੇ ਕੱਲ ਉਨ੍ਹਾਂ ਨੂੰ ਪਵਿੱਤਰ ਕਰ ਅਤੇ ਉਹ ਆਪਣੇ ਬਸਤਰ ਧੋਣ। ");
INSERT INTO pan_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","ਤੀਜੇ ਦਿਨ ਲਈ ਤਿਆਰ ਰਹਿਣ ਕਿਉਂਕਿ ਤੀਜੇ ਦਿਨ ਯਹੋਵਾਹ ਸਾਰੀ ਪਰਜਾ ਦੇ ਸਾਹਮਣੇ ਸੀਨਈ ਦੇ ਪਰਬਤ ਉੱਤੇ ਉੱਤਰੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","ਤੂੰ ਪਰਜਾ ਲਈ ਚੁਫ਼ੇਰੇ ਇਹ ਆਖ ਕੇ ਹੱਦਾਂ ਬਣਾਈ ਕਿ ਤੁਸੀਂ ਧਿਆਨ ਰੱਖੋ ਅਤੇ ਪਰਬਤ ਉੱਤੇ ਨਾ ਚੜ੍ਹਿਓ, ਨਾ ਉਸ ਦੀ ਹੱਦ ਨੂੰ ਛੂਹਿਓ ਅਤੇ ਹਰ ਇੱਕ ਜਿਹੜਾ ਪਰਬਤ ਨੂੰ ਛੂਹੇ ਉਹ ਜ਼ਰੂਰ ਮਾਰਿਆ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","ਕੋਈ ਹੱਥ ਉਸ ਨੂੰ ਨਾ ਛੂਹੇ ਪਰ ਉਹ ਵੱਟਿਆਂ ਨਾਲ ਮਾਰਿਆ ਜਾਵੇ ਜਾਂ ਤੀਰ ਨਾਲ ਵਿੰਨ੍ਹਿਆ ਜਾਵੇ ਭਾਵੇਂ ਪਸ਼ੂ ਹੋਵੇ ਭਾਵੇਂ ਮਨੁੱਖ ਹੋਵੇ, ਉਹ ਜਿਉਂਦਾ ਨਾ ਰਹੇ। ਜਦ ਤੁਰ੍ਹੀ ਦੀ ਅਵਾਜ਼ ਗੂੰਜੇ ਤਾਂ ਉਹ ਪਰਬਤ ਉੱਤੇ ਚੜ੍ਹਨ। ");
INSERT INTO pan_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","ਮੂਸਾ ਪਰਬਤ ਤੋਂ ਪਰਜਾ ਕੋਲ ਉੱਤਰਿਆ ਅਤੇ ਪਰਜਾ ਨੂੰ ਪਵਿੱਤਰ ਕੀਤਾ ਅਤੇ ਉਨ੍ਹਾਂ ਨੇ ਆਪਣੇ ਬਸਤਰ ਧੋਤੇ। ");
INSERT INTO pan_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","ਫਿਰ ਉਸ ਨੇ ਪਰਜਾ ਨੂੰ ਆਖਿਆ, ਤੀਜੇ ਦਿਨ ਲਈ ਤਿਆਰ ਰਹੋ ਅਤੇ ਔਰਤ ਦੇ ਨੇੜੇ ਨਾ ਜਾਓ। ");
INSERT INTO pan_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","ਇਸ ਤਰ੍ਹਾਂ ਹੋਇਆ ਕਿ ਜਦ ਤੀਜੇ ਦਿਨ ਸਵੇਰਾ ਹੋਇਆ ਤਾਂ ਗਰਜਾਂ ਹੋਈਆਂ, ਲਿਸ਼ਕਾਂ ਪਈਆਂ ਅਤੇ ਇੱਕ ਕਾਲਾ ਬੱਦਲ ਪਰਬਤ ਉੱਤੇ ਸੀ, ਤੁਰ੍ਹੀ ਦੀ ਅਵਾਜ਼ ਬਹੁਤ ਉੱਚੀ ਸੀ ਅਤੇ ਜਿੰਨੇ ਲੋਕ ਡੇਰੇ ਵਿੱਚ ਸਨ ਕੰਬ ਗਏ। ");
INSERT INTO pan_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","ਮੂਸਾ ਲੋਕਾਂ ਨੂੰ ਪਰਮੇਸ਼ੁਰ ਨਾਲ ਮਿਲਣ ਲਈ ਡੇਰੇ ਤੋਂ ਬਾਹਰ ਲੈ ਆਇਆ ਅਤੇ ਉਹ ਪਰਬਤ ਦੇ ਹੇਠਾਂ ਖੜੇ ਹੋ ਗਏ। ");
INSERT INTO pan_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","ਅਤੇ ਸਾਰੇ ਸੀਨਈ ਪਰਬਤ ਤੋਂ ਧੂੰਆਂ ਨਿੱਕਲਦਾ ਸੀ ਕਿਉਂ ਜੋ ਯਹੋਵਾਹ ਅੱਗ ਵਿੱਚ ਉਸ ਦੇ ਉੱਤੇ ਉੱਤਰਿਆ ਅਤੇ ਭੱਠੀ ਵਰਗਾ ਧੂੰਆਂ ਉਸ ਦੇ ਉੱਤੋਂ ਉੱਠ ਰਿਹਾ ਸੀ, ਸਾਰਾ ਪਰਬਤ ਬਹੁਤ ਕੰਬ ਰਿਹਾ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","ਜਦ ਤੁਰ੍ਹੀ ਦੀ ਅਵਾਜ਼ ਬਹੁਤ ਉੱਚੀ ਹੁੰਦੀ ਜਾਂਦੀ ਸੀ ਤਾਂ ਮੂਸਾ ਬੋਲਿਆ ਅਤੇ ਪਰਮੇਸ਼ੁਰ ਨੇ ਉਹ ਨੂੰ ਅਵਾਜ਼ ਨਾਲ ਉੱਤਰ ਦਿੱਤਾ। ");
INSERT INTO pan_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","ਯਹੋਵਾਹ ਸੀਨਈ ਪਰਬਤ ਉੱਤੇ ਉੱਤਰਿਆ ਅਰਥਾਤ ਪਰਬਤ ਦੀ ਟੀਸੀ ਉੱਤੇ ਅਤੇ ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਪਰਬਤ ਦੀ ਟੀਸੀ ਉੱਤੇ ਸੱਦਿਆ ਤਾਂ ਮੂਸਾ ਉਤਾਹਾਂ ਗਿਆ। ");
INSERT INTO pan_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਆਖਿਆ, ਹੇਠਾਂ ਜਾ ਅਤੇ ਪਰਜਾ ਨੂੰ ਚੇਤਾਵਨੀ ਦੇ ਕਰ ਮਤੇ ਉਹ ਵੇਖਣ ਨੂੰ ਯਹੋਵਾਹ ਕੋਲ ਅੱਗੇ ਆਉਣ ਅਤੇ ਉਨ੍ਹਾਂ ਵਿੱਚੋਂ ਬਹੁਤ ਡਿੱਗ ਪੈਣ। ");
INSERT INTO pan_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","ਅਤੇ ਜਾਜਕ ਵੀ ਜਿਹੜੇ ਯਹੋਵਾਹ ਦੇ ਨੇੜੇ ਆਉਂਦੇ ਹਨ ਆਪਣੇ ਆਪ ਨੂੰ ਪਵਿੱਤਰ ਕਰਨ ਕਿਤੇ ਯਹੋਵਾਹ ਉਨ੍ਹਾਂ ਉੱਤੇ ਵਰ੍ਹ ਪਵੇ। ");
INSERT INTO pan_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","ਮੂਸਾ ਨੇ ਯਹੋਵਾਹ ਨੂੰ ਆਖਿਆ ਕਿ ਲੋਕ ਸੀਨਈ ਪਰਬਤ ਉੱਤੇ ਨਹੀਂ ਚੜ੍ਹ ਸਕਦੇ ਕਿਉਂ ਜੋ ਤੂੰ ਸਾਨੂੰ ਤਗੀਦ ਨਾਲ ਆਖਿਆ ਸੀ ਕਿ ਪਰਬਤ ਦੀਆਂ ਹੱਦਾਂ ਬਣਾ ਰੱਖੋ ਅਤੇ ਉਹ ਨੂੰ ਪਵਿੱਤਰ ਕਰੋ। ");
INSERT INTO pan_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","ਤਾਂ ਯਹੋਵਾਹ ਨੇ ਉਸ ਨੂੰ ਆਖਿਆ, ਹੇਠਾਂ ਜਾ ਅਤੇ ਫੇਰ ਉਤਾਹਾਂ ਆ ਤੂੰ ਅਤੇ ਤੇਰੇ ਨਾਲ ਹਾਰੂਨ ਪਰ ਜਾਜਕ ਅਤੇ ਲੋਕ ਯਹੋਵਾਹ ਕੋਲ ਚੜ੍ਹਨ ਲਈ ਨਾ ਆਉਣ ਕਿਤੇ ਉਹ ਉਨ੍ਹਾਂ ਉੱਤੇ ਨਾ ਵਰ੍ਹ ਪਵੇ। ");
INSERT INTO pan_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","ਤਦ ਮੂਸਾ ਪਰਜਾ ਕੋਲ ਉਤਰਿਆ ਅਤੇ ਉਨ੍ਹਾਂ ਨੂੰ ਦੱਸਿਆ। ");
INSERT INTO pan_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","ਫਿਰ ਪਰਮੇਸ਼ੁਰ ਇਹ ਸਾਰੀਆਂ ਗੱਲਾਂ ਬੋਲਿਆ ਕਿ ");
INSERT INTO pan_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","ਮੈਂ ਯਹੋਵਾਹ ਤੇਰਾ ਪਰਮੇਸ਼ੁਰ ਹਾਂ ਜਿਹੜਾ ਤੈਨੂੰ ਮਿਸਰ ਦੇਸ਼ ਤੋਂ ਅਰਥਾਤ ਗ਼ੁਲਾਮੀ ਦੇ ਘਰ ਤੋਂ ਕੱਢ ਲਿਆਇਆ ਹਾਂ। ");
INSERT INTO pan_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","ਮੇਰੇ ਸਨਮੁਖ ਤੇਰੇ ਲਈ ਦੂਜੇ ਦੇਵਤੇ ਨਾ ਹੋਣ। ");
INSERT INTO pan_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","ਤੂੰ ਆਪਣੇ ਲਈ ਘੜ੍ਹੀ ਹੋਈ ਮੂਰਤ ਨਾ ਬਣਾਈਂ, ਨਾ ਕਿਸੇ ਚੀਜ਼ ਦੀ ਸੂਰਤ ਜਿਹੜੀ ਉੱਪਰ ਅਕਾਸ਼ ਵਿੱਚ ਅਤੇ ਜਿਹੜੀ ਹੇਠਾਂ ਧਰਤੀ ਉੱਤੇ ਅਤੇ ਜਿਹੜੀ ਧਰਤੀ ਦੇ ਹੇਠਲੇ ਪਾਣੀਆਂ ਵਿੱਚ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","ਨਾ ਤੂੰ ਉਹਨਾਂ ਦੇ ਅੱਗੇ ਮੱਥਾ ਟੇਕ, ਨਾ ਉਹਨਾਂ ਦੀ ਪੂਜਾ ਕਰ ਕਿਉਂ ਜੋ ਮੈਂ ਯਹੋਵਾਹ ਤੇਰਾ ਪਰਮੇਸ਼ੁਰ ਅਣਖ ਵਾਲਾ ਪਰਮੇਸ਼ੁਰ ਹਾਂ ਜਿਹੜਾ ਪੁਰਖਿਆਂ ਦੀ ਬੁਰਿਆਈ ਨੂੰ ਬੱਚਿਆਂ ਉੱਤੇ ਅਤੇ ਆਪਣੇ ਵੈਰੀਆਂ ਦੀ ਤੀਜੀ ਅਤੇ ਚੌਥੀ ਪੀੜ੍ਹੀ ਉੱਤੇ ਲਿਆਉਂਦਾ ਹਾਂ। ");
INSERT INTO pan_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","ਪਰ ਹਜ਼ਾਰਾਂ ਉੱਤੇ ਜਿਹੜੇ ਮੇਰੇ ਨਾਲ ਪ੍ਰੇਮ ਰੱਖਦੇ ਅਤੇ ਮੇਰੇ ਹੁਕਮਾਂ ਨੂੰ ਮੰਨਦੇ ਹਨ ਦਯਾ ਕਰਦਾ ਹਾਂ। ");
INSERT INTO pan_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","ਤੂੰ ਯਹੋਵਾਹ ਆਪਣੇ ਪਰਮੇਸ਼ੁਰ ਦਾ ਨਾਮ ਵਿਅਰਥ ਨਾ ਲੈ ਕਿਉਂਕਿ ਜੋ ਕੋਈ ਉਹ ਦਾ ਨਾਮ ਵਿਅਰਥ ਲੈਂਦਾ ਹੈ ਯਹੋਵਾਹ ਉਸ ਨੂੰ ਨਿਰਦੋਸ਼ ਨਾ ਠਹਿਰਾਵੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","ਤੂੰ ਸਬਤ ਦੇ ਦਿਨ ਨੂੰ ਪਵਿੱਤਰ ਜਾਣ ਕੇ ਯਾਦ ਰੱਖ। ");
INSERT INTO pan_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","ਛੇ ਦਿਨ ਤੂੰ ਮਿਹਨਤ ਕਰ ਅਤੇ ਆਪਣਾ ਸਾਰਾ ਕੰਮ-ਧੰਦਾ ਕਰ ");
INSERT INTO pan_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","ਪਰ ਸੱਤਵਾਂ ਦਿਨ ਯਹੋਵਾਹ ਤੇਰੇ ਪਰਮੇਸ਼ੁਰ ਲਈ ਸਬਤ ਹੈ। ਉਸ ਦਿਨ ਵਿੱਚ ਤੂੰ ਕੋਈ ਕੰਮ-ਧੰਦਾ ਨਾ ਕਰ, ਨਾ ਤੂੰ ਨਾ ਤੇਰਾ ਪੁੱਤਰ, ਨਾ ਤੇਰੀ ਧੀ, ਨਾ ਤੇਰਾ ਦਾਸ, ਨਾ ਤੇਰੀ ਦਾਸੀ, ਨਾ ਤੇਰਾ ਪਸ਼ੂ ਅਤੇ ਨਾ ਤੇਰਾ ਪਰਦੇਸੀ ਜਿਹੜਾ ਤੇਰੇ ਫਾਟਕਾਂ ਦੇ ਅੰਦਰ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","ਕਿਉਂ ਜੋ ਛੇਆਂ ਦਿਨਾਂ ਵਿੱਚ ਯਹੋਵਾਹ ਨੇ ਅਕਾਸ਼ ਅਤੇ ਧਰਤੀ ਨੂੰ, ਸਮੁੰਦਰ ਨੂੰ ਅਤੇ ਸਭ ਕੁਝ ਜੋ ਉਨ੍ਹਾਂ ਦੇ ਵਿੱਚ ਹੈ ਬਣਾਇਆ ਪਰ ਸੱਤਵੇਂ ਦਿਨ ਵਿਸ਼ਰਾਮ ਕੀਤਾ। ਇਸ ਲਈ ਯਹੋਵਾਹ ਨੇ ਸਬਤ ਦੇ ਦਿਨ ਨੂੰ ਬਰਕਤ ਦਿੱਤੀ ਅਤੇ ਉਸ ਨੂੰ ਪਵਿੱਤਰ ਠਹਿਰਾਇਆ। ");
INSERT INTO pan_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","ਤੂੰ ਆਪਣੇ ਪਿਤਾ ਅਤੇ ਆਪਣੀ ਮਾਤਾ ਦਾ ਆਦਰ ਕਰ ਤਾਂ ਜੋ ਉਸ ਦੇਸ਼ ਵਿੱਚ ਜਿਹੜਾ ਯਹੋਵਾਹ ਤੇਰਾ ਪਰਮੇਸ਼ੁਰ ਤੈਨੂੰ ਦਿੰਦਾ ਹੈ, ਤੇਰੀ ਉਮਰ ਲੰਮੀ ਹੋਵੇ। ");
INSERT INTO pan_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","ਤੂੰ ਖ਼ੂਨ ਨਾ ਕਰ। ");
INSERT INTO pan_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","ਤੂੰ ਵਿਭਚਾਰ ਨਾ ਕਰ। ");
INSERT INTO pan_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","ਤੂੰ ਚੋਰੀ ਨਾ ਕਰ। ");
INSERT INTO pan_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","ਤੂੰ ਆਪਣੇ ਗੁਆਂਢੀ ਦੇ ਵਿਰੁੱਧ ਝੂਠੀ ਗਵਾਹੀ ਨਾ ਦੇ। ");
INSERT INTO pan_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","ਤੂੰ ਆਪਣੇ ਗੁਆਂਢੀ ਦੇ ਘਰ ਦਾ ਲਾਲਚ ਨਾ ਕਰ। ਤੂੰ ਆਪਣੇ ਗੁਆਂਢੀ ਦੀ ਪਤਨੀ ਦੀ ਲਾਲਸਾ ਨਾ ਕਰ, ਨਾ ਉਹ ਦੇ ਦਾਸ ਦੀ, ਨਾ ਉਹ ਦੀ ਦਾਸੀ ਦੀ, ਨਾ ਉਹ ਦੇ ਬਲ਼ਦ ਦੀ, ਨਾ ਉਹ ਦੇ ਗਧੇ ਦੀ, ਨਾ ਕਿਸੇ ਚੀਜ਼ ਦੀ ਜਿਹੜੀ ਤੇਰੇ ਗੁਆਂਢੀ ਦੀ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","ਸਾਰੀ ਪਰਜਾ ਗੱਜਾਂ, ਲਸ਼ਕਾਂ ਅਤੇ ਤੁਰ੍ਹੀ ਦੀ ਅਵਾਜ਼ ਅਤੇ ਪਰਬਤ ਤੋਂ ਧੂੰਆਂ ਵੇਖ ਰਹੀ ਸੀ ਅਤੇ ਜਦ ਪਰਜਾ ਨੇ ਵੇਖਿਆ ਤਾਂ ਕੰਬ ਉੱਠੀ ਅਤੇ ਦੂਰ ਜਾ ਖੜੀ ਹੋਈ। ");
INSERT INTO pan_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","ਉਨ੍ਹਾਂ ਨੇ ਮੂਸਾ ਨੂੰ ਆਖਿਆ, ਤੂੰ ਸਾਡੇ ਨਾਲ ਗੱਲਾਂ ਕਰ ਤਾਂ ਅਸੀਂ ਸੁਣਾਂਗੇ। ਪਰ ਪਰਮੇਸ਼ੁਰ ਸਾਡੇ ਨਾਲ ਗੱਲਾਂ ਨਾ ਕਰੇ ਕਿ ਅਸੀਂ ਕਿਤੇ ਮਰ ਨਾ ਜਾਈਏ। ");
INSERT INTO pan_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","ਤਦ ਮੂਸਾ ਨੇ ਪਰਜਾ ਨੂੰ ਆਖਿਆ, ਨਾ ਡਰੋ ਕਿਉਂ ਜੋ ਪਰਮੇਸ਼ੁਰ ਇਸ ਲਈ ਆਇਆ ਹੈ ਕਿ ਤੁਹਾਨੂੰ ਪਰਤਾਵੇ ਅਤੇ ਉਸ ਦਾ ਭੈਅ ਤੁਹਾਡੇ ਅੱਗੇ ਰਹੇ ਤਾਂ ਜੋ ਤੁਸੀਂ ਪਾਪ ਨਾ ਕਰੋ। ");
INSERT INTO pan_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","ਤਾਂ ਪਰਜਾ ਦੂਰ ਖੜੀ ਰਹੀ ਪਰ ਮੂਸਾ ਉਸ ਘੁੱਪ ਹਨੇਰ ਦੇ ਕੋਲ ਢੁੱਕਾ ਜਿੱਥੇ ਪਰਮੇਸ਼ੁਰ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","ਫੇਰ ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਆਖਿਆ, ਇਸਰਾਏਲੀਆਂ ਨੂੰ ਇਸ ਤਰ੍ਹਾਂ ਫ਼ਰਮਾ, ਤੁਸੀਂ ਵੇਖਿਆ ਕਿ ਮੈਂ ਤੁਹਾਡੇ ਨਾਲ ਅਕਾਸ਼ ਤੋਂ ਬੋਲਿਆ ਹਾਂ। ");
INSERT INTO pan_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","ਤੁਸੀਂ ਮੇਰੇ ਸ਼ਰੀਕ ਨਾ ਬਣਾਓ, ਨਾ ਚਾਂਦੀ ਦੇ ਦੇਵਤੇ, ਨਾ ਸੋਨੇ ਦੇ ਦੇਵਤੇ ਆਪਣੇ ਲਈ ਬਣਾਓ। ");
INSERT INTO pan_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","ਤੁਸੀਂ ਮੇਰੇ ਲਈ ਮਿੱਟੀ ਦੀ ਇੱਕ ਜਗਵੇਦੀ ਬਣਾਓ ਅਤੇ ਉਸ ਉੱਤੇ ਆਪਣੀਆਂ ਹੋਮ ਦੀਆਂ ਬਲੀਆਂ ਅਤੇ ਆਪਣੀਆਂ ਸੁੱਖ-ਸਾਂਦ ਦੀਆਂ ਬਲੀਆਂ ਅਰਥਾਤ ਆਪਣੀਆਂ ਭੇਡਾਂ ਅਤੇ ਆਪਣੇ ਬਲ਼ਦ ਚੜ੍ਹਾਓ ਅਤੇ ਹਰ ਸਥਾਨ ਉੱਤੇ ਜਿੱਥੇ ਮੈਂ ਆਪਣਾ ਨਾਮ ਚੇਤੇ ਕਰਾਉਂਦਾ ਹਾਂ ਮੈਂ ਤੁਹਾਡੇ ਕੋਲ ਆਵਾਂਗਾ ਅਤੇ ਤੁਹਾਨੂੰ ਬਰਕਤ ਦੇਵਾਂਗਾ। ");
INSERT INTO pan_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","ਜੇ ਤੁਸੀਂ ਮੇਰੇ ਲਈ ਪੱਥਰਾਂ ਦੀ ਜਗਵੇਦੀ ਬਣਾਵੋ ਤਾਂ ਉਹ ਨੂੰ ਘੜਿਆਂ ਹੋਇਆਂ ਪੱਥਰਾਂ ਨਾਲ ਨਾ ਬਣਾਓ। ਜੇ ਤੁਸੀਂ ਆਪਣੀ ਤੇਸੀ ਉਨ੍ਹਾਂ ਉੱਤੇ ਚੁੱਕੀ ਤਾਂ ਤੁਸੀਂ ਉਸ ਨੂੰ ਭਰਿਸ਼ਟ ਕੀਤਾ। ");
INSERT INTO pan_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","ਤੁਸੀਂ ਮੇਰੀ ਜਗਵੇਦੀ ਉੱਤੇ ਪੌੜੀਆਂ ਨਾਲ ਨਾ ਚੜ੍ਹੋ ਕਿ ਕਿਤੇ ਤੁਹਾਡਾ ਨੰਗੇਜ਼ ਉਸ ਉੱਤੇ ਖੁੱਲ੍ਹ ਨਾ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","ਇਹ ਉਹ ਨਿਆਂ ਹਨ ਜਿਹੜੇ ਤੂੰ ਉਨ੍ਹਾਂ ਦੇ ਅੱਗੇ ਰੱਖੇਂਗਾ। ");
INSERT INTO pan_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","ਜਦ ਤੂੰ ਇਬਰਾਨੀ ਗ਼ੁਲਾਮ ਲਵੇਂ ਤਾਂ ਉਹ ਛੇ ਸਾਲ ਤੇਰੀ ਸੇਵਾ ਕਰੇ ਪਰ ਸੱਤਵੇਂ ਸਾਲ ਉਹ ਮੁਫ਼ਤ ਅਜ਼ਾਦ ਹੋ ਕੇ ਚੱਲਿਆ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","ਜੇ ਉਹ ਇਕੱਲਾ ਆਇਆ ਹੋਵੇ ਤਾਂ ਇਕੱਲਾ ਚੱਲਿਆ ਜਾਵੇ ਅਤੇ ਜੇ ਉਹ ਔਰਤ ਵਾਲਾ ਸੀ ਤਾਂ ਉਸ ਦੀ ਔਰਤ ਉਸ ਦੇ ਨਾਲ ਚੱਲੀ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","ਜੇ ਉਸ ਦੇ ਸੁਆਮੀ ਨੇ ਉਸ ਨੂੰ ਔਰਤ ਦਿੱਤੀ ਹੋਵੇ ਅਤੇ ਉਹ ਉਸ ਲਈ ਪੁੱਤਰ ਧੀਆਂ ਜਣੀ ਤਾਂ ਉਹ ਔਰਤ ਅਤੇ ਉਹ ਦੇ ਬੱਚੇ ਉਹ ਦੇ ਸੁਆਮੀ ਦੇ ਹੋਣਗੇ ਅਤੇ ਉਹ ਇਕੱਲਾ ਚੱਲਿਆ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","ਪਰ ਜੇ ਦਾਸ ਸਫ਼ਾਈ ਨਾਲ ਆਖੇ ਕਿ ਮੈਂ ਆਪਣੇ ਸੁਆਮੀ ਅਤੇ ਆਪਣੀ ਔਰਤ ਅਤੇ ਆਪਣੇ ਬੱਚਿਆਂ ਨਾਲ ਪ੍ਰੇਮ ਕਰਦਾ ਹਾਂ। ਮੈਂ ਅਜ਼ਾਦ ਹੋ ਕੇ ਚੱਲਿਆ ਨਹੀਂ ਜਾਂਵਾਂਗਾ ");
INSERT INTO pan_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","ਤਾਂ ਉਸ ਦਾ ਸੁਆਮੀ ਉਸ ਨੂੰ ਪਰਮੇਸ਼ੁਰ ਦੇ ਕੋਲ ਲਿਆਵੇ ਅਤੇ ਉਹ ਦਰਵਾਜ਼ੇ ਦੇ ਕੋਲ ਅਰਥਾਤ ਚੁਗਾਠ ਦੇ ਕੋਲ ਲਿਆ ਕੇ ਆਰ ਨਾਲ ਉਸ ਦੇ ਕੰਨ ਨੂੰ ਉਸ ਦਾ ਸੁਆਮੀ ਵਿੰਨ੍ਹੇ ਸੋ ਉਹ ਉਸ ਦੀ ਸਦਾ ਲਈ ਟਹਿਲ ਕਰੇ। ");
INSERT INTO pan_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","ਅਤੇ ਜਦ ਕੋਈ ਮਨੁੱਖ ਆਪਣੀ ਧੀ ਨੂੰ ਗੋਲੀ ਹੋਣ ਲਈ ਵੇਚੇ ਤਾਂ ਉਹ ਦਾਸੀਆਂ ਵਾਂਗੂੰ ਬਾਹਰ ਨਾ ਚੱਲੀ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","ਜੇ ਉਹ ਆਪਣੇ ਸੁਆਮੀ ਦੀਆਂ ਅੱਖਾਂ ਨੂੰ ਨਾ ਭਾਵੇ ਤਾਂ ਜੇ ਉਸ ਨੇ ਉਹ ਦੇ ਨਾਲ ਕੁੜਮਾਈ ਨਹੀਂ ਕੀਤੀ ਉਹ ਉਸ ਦਾ ਵੱਟਾ ਦੇਵੇ। ਗੈਰ ਕੌਮ ਵਿੱਚ ਉਹ ਉਸ ਨੂੰ ਵੇਚ ਨਹੀਂ ਸਕਦਾ ਕਿਉਂ ਜੋ ਉਸ ਨੇ ਉਹ ਦੇ ਨਾਲ ਛਲ ਕੀਤਾ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","ਜੇ ਉਹ ਉਸ ਦੀ ਆਪਣੇ ਪੁੱਤਰ ਨਾਲ ਕੁੜਮਾਈ ਕਰੇ ਤਾਂ ਉਹ ਧੀਆਂ ਦੇ ਦਸਤੂਰ ਦੇ ਅਨੁਸਾਰ ਉਹ ਦੇ ਲਈ ਕਰੇ। ");
INSERT INTO pan_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","ਜੇ ਉਹ ਦੂਜੀ ਔਰਤ ਆਪਣੇ ਲਈ ਲਵੇ ਤਾਂ ਉਸ ਦੇ ਖਾਣੇ ਕੱਪੜੇ ਅਤੇ ਵਿਆਹ ਵਾਲੇ ਹੱਕ ਨੂੰ ਨਾ ਘਟਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","ਜੇ ਉਹ ਉਸ ਦੇ ਲਈ ਇਹ ਤਿੰਨ ਗੱਲਾਂ ਨਾ ਕਰੇ ਤਾਂ ਉਹ ਮੁਫ਼ਤ ਬਿਨਾਂ ਚਾਂਦੀ ਦੇ ਚੱਲੀ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","ਜੇ ਕੋਈ ਮਨੁੱਖ ਨੂੰ ਅਜਿਹਾ ਮਾਰੇ ਕਿ ਉਹ ਮਰ ਜਾਵੇ ਤਾਂ ਉਹ ਜ਼ਰੂਰ ਮਾਰਿਆ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","ਪਰ ਜਿਹੜਾ ਛੈਹ ਕੇ ਨਾ ਬੈਠਾ ਹੋਵੇ ਅਤੇ ਪਰਮੇਸ਼ੁਰ ਨੇ ਉਸ ਨੂੰ ਉਹ ਦੇ ਹੱਥ ਵਿੱਚ ਆਉਣ ਦਿੱਤਾ ਹੋਵੇ ਤਾਂ ਮੈਂ ਤੇਰੇ ਲਈ ਇੱਕ ਸਥਾਨ ਠਹਿਰਾਵਾਂਗਾ ਜਿੱਥੇ ਨੂੰ ਉਹ ਨੱਠ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","ਜੇ ਕੋਈ ਮਨੁੱਖ ਆਪਣੇ ਗੁਆਂਢੀ ਉੱਤੇ ਧੱਕੋ-ਧੱਕੀ ਵਾਰ ਕਰੇ ਤਾਂ ਜੋ ਉਹ ਨੂੰ ਛਲ ਨਾਲ ਮਾਰ ਸੁੱਟੇ ਤਾਂ ਤੂੰ ਉਸ ਨੂੰ ਮੇਰੀ ਜਗਵੇਦੀ ਤੋਂ ਵੀ ਲੈ ਕੇ ਮਾਰ ਦੇ। ");
INSERT INTO pan_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","ਜੇ ਕੋਈ ਆਪਣੇ ਪਿਤਾ ਅਤੇ ਆਪਣੀ ਮਾਤਾ ਨੂੰ ਮਾਰੇ ਉਹ ਜ਼ਰੂਰ ਮਾਰਿਆ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","ਜਿਹੜਾ ਕਿਸੇ ਮਨੁੱਖ ਨੂੰ ਚੁਰਾ ਕੇ ਵੇਚੇ ਜਾਂ ਉਸ ਦੇ ਕਬਜ਼ੇ ਵਿੱਚੋਂ ਲੱਭ ਪਏ ਤਾਂ ਉਹ ਜ਼ਰੂਰ ਮਾਰਿਆ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","ਜਿਹੜਾ ਆਪਣੇ ਪਿਤਾ ਜਾਂ ਆਪਣੀ ਮਾਤਾ ਨੂੰ ਫਿਟਕਾਰੇ ਉਹ ਜ਼ਰੂਰ ਮਾਰਿਆ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","ਜਦ ਮਨੁੱਖ ਲੜ ਪੈਣ ਅਤੇ ਇੱਕ ਮਨੁੱਖ ਆਪਣੇ ਗੁਆਂਢੀ ਨੂੰ ਪੱਥਰ ਨਾਲ ਜਾਂ ਹੂਰੇ ਨਾਲ ਮਾਰੇ ਪਰ ਉਹ ਨਾ ਮਰੇ ਪਰੰਤੂ ਆਪਣੇ ਮੰਜੇ ਉੱਤੇ ਪੈ ਜਾਵੇ ");
INSERT INTO pan_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","ਤਾਂ ਜੇ ਕਦੀ ਉਹ ਉੱਠ ਕੇ ਆਪਣੀ ਲਾਠੀ ਨਾਲ ਬਾਹਰ ਫਿਰੇ ਤਾਂ ਉਸ ਦਾ ਮਾਰਨ ਵਾਲਾ ਬੇਦੋਸ਼ ਠਹਿਰੇ। ਨਿਰਾ ਉਸ ਦੇ ਵਿਹਲੇ ਸਮੇਂ ਦਾ ਘਾਟਾ ਭਰੇ ਅਤੇ ਉਸ ਨੂੰ ਪੂਰੀ ਤਰ੍ਹਾਂ ਨਾਲ ਚੰਗਾ ਕਰਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","ਜਿਹੜਾ ਮਨੁੱਖ ਆਪਣੇ ਦਾਸ ਨੂੰ ਜਾਂ ਆਪਣੀ ਗੋਲੀ ਨੂੰ ਡਾਂਗ ਨਾਲ ਅਜਿਹਾ ਮਾਰੇ ਕਿ ਉਹ ਉਸ ਦੇ ਹੱਥੋਂ ਮਰ ਜਾਵੇ ਤਾਂ ਉਸ ਤੋਂ ਵੱਟਾ ਲਿਆ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","ਪਰੰਤੂ ਜੇ ਉਹ ਇੱਕ ਦੋ ਦਿਨ ਜੀਉਂਦਾ ਰਹੇ ਤਾਂ ਉਸ ਤੋਂ ਬਦਲਾ ਨਾ ਲਿਆ ਜਾਵੇ ਕਿਉਂ ਜੋ ਉਹ ਉਸ ਦਾ ਮਾਲ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","ਜਦ ਕਦੀ ਮਨੁੱਖ ਆਪੋ ਵਿੱਚ ਹੱਥੋਂ ਪਾਈ ਹੋਣ ਅਤੇ ਕਿਸੇ ਗਰਭਵਤੀ ਔਰਤ ਨੂੰ ਧੱਕਾ ਮਾਰਨ ਕਿ ਉਸ ਦਾ ਗਰਭ ਡਿੱਗ ਪਏ ਪਰ ਕੋਈ ਹੋਰ ਕਸਰ ਨਾ ਪਏ ਤਾਂ ਉਹ ਜ਼ਰੂਰ ਦੰਡ ਭਰੇ ਜਿੰਨਾਂ ਉਸ ਔਰਤ ਦਾ ਪਤੀ ਉਸ ਉੱਤੇ ਠਹਿਰਾਵੇ ਪਰ ਉਹ ਨਿਆਂਈਆਂ ਦੇ ਆਖੇ ਦੇ ਅਨੁਸਾਰ ਦੇਵੇ। ");
INSERT INTO pan_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","ਪਰੰਤੂ ਜੇ ਕੋਈ ਕਸਰ ਹੋ ਜਾਵੇ ਤਾਂ ਜੀਵਨ ਦੇ ਵੱਟੇ ਜੀਵਨ, ");
INSERT INTO pan_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","ਅੱਖ ਦੇ ਵੱਟੇ ਅੱਖ, ਦੰਦ ਦੇ ਵੱਟੇ ਦੰਦ, ਹੱਥ ਦੇ ਵੱਟੇ ਹੱਥ, ਪੈਰ ਦੇ ਵੱਟੇ ਪੈਰ, ");
INSERT INTO pan_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","ਸਾੜਨ ਦੇ ਵੱਟੇ ਸਾੜਨ, ਫੱਟ ਦੇ ਵੱਟੇ ਫੱਟ, ਸੱਟ ਦੇ ਵੱਟੇ ਸੱਟ ਤੂੰ ਦੇ। ");
INSERT INTO pan_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","ਜਦ ਕੋਈ ਮਨੁੱਖ ਆਪਣੇ ਦਾਸ ਦੀ ਅੱਖ ਜਾਂ ਆਪਣੀ ਦਾਸੀ ਦੀ ਅੱਖ ਉੱਤੇ ਅਜਿਹਾ ਮਾਰੇ ਕਿ ਉਹ ਮਾਰੀ ਜਾਵੇ ਤਾਂ ਉਹ ਉਸ ਦੀ ਅੱਖ ਦੇ ਵੱਟੇ ਉਹ ਨੂੰ ਅਜ਼ਾਦ ਕਰ ਕੇ ਜਾਣ ਦੇਵੇ। ");
INSERT INTO pan_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","ਜੇ ਉਹ ਆਪਣੇ ਦਾਸ ਦੇ ਦੰਦ ਜਾਂ ਆਪਣੀ ਗੋਲੀ ਦੇ ਦੰਦ ਨੂੰ ਭੰਨ ਸੁੱਟੇ ਤਾਂ ਉਹ ਉਸ ਨੂੰ ਦੰਦ ਦੇ ਵੱਟੇ ਵਿੱਚ ਅਜ਼ਾਦ ਕਰ ਕੇ ਜਾਣ ਦੇਵੇ। ");
INSERT INTO pan_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","ਜਦ ਕੋਈ ਬਲ਼ਦ ਕਿਸੇ ਮਨੁੱਖ ਨੂੰ ਜਾਂ ਕਿਸੇ ਔਰਤ ਨੂੰ ਅਜਿਹਾ ਮਾਰੇ ਕਿ ਉਹ ਮਰ ਜਾਵੇ ਤਾਂ ਉਸ ਬਲ਼ਦ ਨੂੰ ਜ਼ਰੂਰ ਵੱਟੇ ਮਾਰੇ ਜਾਣ ਅਤੇ ਉਸ ਦਾ ਮਾਸ ਖਾਧਾ ਨਾ ਜਾਵੇ ਪਰ ਉਸ ਬਲ਼ਦ ਦਾ ਮਾਲਕ ਬੇਦੋਸ਼ਾ ਠਹਿਰੇ। ");
INSERT INTO pan_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","ਜੇ ਉਹ ਬਲ਼ਦ ਪਿੱਛੇ ਵੀ ਮਾਰ-ਕਾਟ ਹੁੰਦਾ ਸੀ ਪਰ ਉਸ ਨੇ ਉਹ ਨੂੰ ਨਾ ਸਾਂਭਿਆ ਅਤੇ ਉਸ ਨੇ ਕਿਸੇ ਮਨੁੱਖ ਜਾਂ ਔਰਤ ਨੂੰ ਮਾਰ ਦਿੱਤਾ ਹੋਵੇ ਤਾਂ ਉਸ ਬਲ਼ਦ ਨੂੰ ਵੱਟਿਆਂ ਨਾਲ ਮਾਰਿਆ ਜਾਵੇ ਅਤੇ ਉਸ ਦਾ ਮਾਲਕ ਵੀ ਮਾਰਿਆ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","ਜਦ ਨਿਸਤਾਰੇ ਦਾ ਮੁੱਲ ਉਸ ਉੱਤੇ ਠਹਿਰਾਇਆ ਜਾਵੇ ਤਾਂ ਆਪਣੀ ਜਿੰਦ ਛੁਡਾਉਣ ਲਈ ਜੋ ਕੁਝ ਉਸ ਉੱਤੇ ਠਹਿਰਾਇਆ ਜਾਵੇ ਉਹੀ ਦੇਵੇ। ");
INSERT INTO pan_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","ਜੇ ਉਸ ਨੇ ਪੁੱਤਰ ਨੂੰ ਸਿੰਙ ਮਾਰਿਆ ਹੋਵੇ ਜਾਂ ਧੀ ਨੂੰ ਸਿੰਙ ਮਾਰਿਆ ਹੋਵੇ ਤਾਂ ਉਸੇ ਨਿਆਂ ਦੇ ਅਨੁਸਾਰ ਉਸ ਨਾਲ ਕੀਤਾ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","ਜੇ ਉਹ ਬਲ਼ਦ ਦਾਸ ਨੂੰ ਜਾਂ ਗੋਲੀ ਨੂੰ ਸਿੰਙ ਮਾਰੇ ਤਾਂ ਤੀਹ ਰੁੱਪਈਏ ਚਾਂਦੀ ਦੇ ਉਸ ਦੇ ਸੁਆਮੀ ਨੂੰ ਦਿੱਤੇ ਜਾਣ ਅਤੇ ਬਲ਼ਦ ਵੱਟਿਆਂ ਨਾਲ ਮਾਰਿਆ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","ਜਦ ਕੋਈ ਮਨੁੱਖ ਟੋਆ ਖੋਲ੍ਹੇ ਜਾਂ ਟੋਆ ਪੁੱਟ ਕੇ ਉਸ ਨੂੰ ਨਾ ਢੱਕੇ ਅਤੇ ਉਸ ਵਿੱਚ ਬਲ਼ਦ ਜਾਂ ਗਧਾ ਡਿੱਗ ਪਵੇ ");
INSERT INTO pan_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","ਤਾਂ ਟੋਏ ਦਾ ਮਾਲਕ ਉਹ ਦਾ ਘਾਟਾ ਭਰੇ ਅਤੇ ਚਾਂਦੀ ਉਸ ਦੇ ਮਾਲਕ ਨੂੰ ਮੋੜ ਦੇਵੇ। ਫੇਰ ਲੋਥ ਉਸ ਦੀ ਹੋਵੇਗੀ। ");
INSERT INTO pan_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","ਜਦ ਕਦੀ ਕਿਸੇ ਦਾ ਬਲ਼ਦ ਉਸ ਦੇ ਗੁਆਂਢੀ ਦੇ ਬਲ਼ਦ ਨੂੰ ਮਾਰੇ ਅਤੇ ਉਹ ਮਰ ਜਾਵੇ ਤਾਂ ਜਿਉਂਦੇ ਬਲ਼ਦ ਨੂੰ ਵੇਚ ਦੇਣ ਅਤੇ ਉਸ ਦੀ ਚਾਂਦੀ ਨੂੰ ਵੰਡ ਲੈਣ ਅਤੇ ਲੋਥ ਵੀ ਵੰਡ ਲੈਣ। ");
INSERT INTO pan_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","ਅਥਵਾ ਜੇ ਇਹ ਜਾਣਿਆ ਗਿਆ ਕਿ ਉਹ ਪਿੱਛੇ ਵੀ ਮਾਰ-ਕਾਟ ਹੁੰਦਾ ਦੀ ਪਰ ਉਸ ਦੇ ਮਾਲਕ ਨੇ ਉਸ ਨੂੰ ਨਹੀਂ ਸਾਂਭਿਆ ਤਾਂ ਉਹ ਜ਼ਰੂਰ ਘਾਟਾ ਭਰੇ ਅਤੇ ਬਲ਼ਦ ਦੇ ਵੱਟੇ ਬਲ਼ਦ ਦੇਵੇ ਅਤੇ ਉਹ ਲੋਥ ਉਹ ਦੀ ਹੋਵੇਗੀ। ");
INSERT INTO pan_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","ਜੇ ਕੋਈ ਮਨੁੱਖ ਬਲ਼ਦ ਜਾਂ ਭੇਡ ਚੁਰਾਵੇ ਜਾਂ ਉਸ ਨੂੰ ਮਾਰ ਸੁੱਟੇ ਜਾਂ ਉਸ ਨੂੰ ਵੇਚ ਦੇਵੇ ਤਾਂ ਚੌਣੇ ਵਿੱਚੋਂ ਉਸ ਦੇ ਵੱਟੇ ਪੰਜ ਬਲ਼ਦ ਅਤੇ ਇੱਜੜ ਵਿੱਚੋਂ ਉਸ ਦੇ ਵੱਟੇ ਚਾਰ ਭੇਡਾਂ ਵੱਟਾ ਭਰੇ। ");
INSERT INTO pan_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","ਜੇ ਉਹ ਚੋਰ ਸੰਨ੍ਹ ਲਾਉਂਦਾ ਫੜਿਆ ਜਾਵੇ ਅਤੇ ਉਹ ਮਾਰ ਨਾਲ ਮਰ ਜਾਵੇ ਤਾਂ ਇਹ ਖੂਨ ਦਾ ਦੋਸ਼ ਨਹੀਂ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","ਪਰ ਜੇ ਉਸ ਉੱਤੇ ਸੂਰਜ ਚੜ੍ਹ ਜਾਵੇ ਤਾਂ ਉਹ ਦੇ ਲਈ ਖੂਨ ਦਾ ਦੋਸ਼ ਹੋਵੇਗਾ, ਉਹ ਵੱਟਾ ਭਰ ਦੇਵੇ। ਜੇ ਉਹ ਦੇ ਕੋਲ ਕੁਝ ਨਹੀਂ ਹੈਂ ਤਾਂ ਉਹ ਆਪਣੀ ਚੋਰੀ ਦੇ ਕਾਰਨ ਵੇਚਿਆ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","ਜੇ ਚੋਰੀ ਦਾ ਮਾਲ ਉਹ ਦੇ ਹੱਥੋਂ ਜਿਉਂਦਾ ਲੱਭ ਜਾਵੇ ਭਾਵੇਂ ਬਲ਼ਦ ਭਾਵੇਂ ਗਧਾ ਭਾਵੇਂ ਭੇਡ ਤਾਂ ਉਹ ਦੁੱਗਣਾ ਵੱਟਾ ਭਰੇ। ");
INSERT INTO pan_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","ਜਦ ਕੋਈ ਮਨੁੱਖ ਪੈਲੀ ਜਾਂ ਦਾਖ਼ ਦੇ ਬਾਗ਼ ਨੂੰ ਖਿਲਾ ਦੇਵੇ ਜਾਂ ਆਪਣੇ ਪਸ਼ੂ ਛੱਡੇ ਜੋ ਉਹ ਦੂਜੇ ਦੀ ਪੈਲੀ ਨੂੰ ਖਾ ਜਾਵੇ ਤਾਂ ਆਪਣੇ ਖੇਤ ਦੀ ਬਹੁਤ ਉੱਤਮ ਪੈਦਾਵਾਰ ਤੋਂ ਜਾਂ ਬਾਗ਼ ਦੀ ਬਹੁਤ ਉੱਤਮ ਦਾਖ਼ ਤੋਂ ਵੱਟਾ ਭਰੇ। ");
INSERT INTO pan_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","ਜੇ ਕਦੀ ਅੱਗ ਭੱਖ ਉੱਠੇ ਅਤੇ ਕੰਡੇ ਕਾਠ ਨੂੰ ਇਸ ਤਰ੍ਹਾਂ ਜਾ ਲੱਗੇ ਕਿ ਅੰਨ ਦਾ ਖਲਵਾੜਾ ਜਾਂ ਅੰਨ ਦੀ ਖੜੀ ਪੈਲੀ ਜਾਂ ਖੇਤ ਸੜ ਜਾਵੇ ਤਾਂ ਅੱਗ ਦੇ ਲਾਉਣ ਵਾਲਾ ਜ਼ਰੂਰ ਵੱਟਾ ਭਰੇ। ");
INSERT INTO pan_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","ਜਦ ਕੋਈ ਮਨੁੱਖ ਆਪਣੇ ਗੁਆਂਢੀ ਨੂੰ ਚਾਂਦੀ ਜਾਂ ਗਹਿਣਾ ਰੱਖਣ ਲਈ ਦੇਵੇ ਪਰ ਉਹ ਉਸ ਮਨੁੱਖ ਦੇ ਘਰੋਂ ਚੁਰਾਇਆ ਜਾਵੇ ਜੇ ਚੋਰ ਫੜਿਆ ਜਾਵੇ ਤਾਂ ਉਹ ਦੁੱਗਣਾ ਭਰੇ। ");
INSERT INTO pan_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","ਪਰ ਜੇ ਚੋਰ ਨਾ ਫੜਿਆ ਜਾਵੇ ਤਾਂ ਘਰ ਦਾ ਮਾਲਕ ਨਿਆਂਈਆਂ ਦੇ ਕੋਲ ਲਿਆਂਦਾ ਜਾਵੇ ਤਾਂ ਜੋ ਮਲੂਮ ਹੋਵੇ ਕਿ ਉਸ ਨੇ ਆਪਣਾ ਹੱਥ ਆਪਣੇ ਗੁਆਂਢੀ ਦੇ ਮਾਲ ਧਨ ਨੂੰ ਲਾਇਆ ਹੈ ਕਿ ਨਹੀਂ। ");
INSERT INTO pan_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","ਅਪਰਾਧ ਦੀ ਹਰ ਪਰਕਾਰ ਦੀ ਗੱਲ ਵਿੱਚ ਭਾਵੇਂ ਬਲ਼ਦ ਦੀ ਭਾਵੇਂ ਗਧੇ ਦੀ ਭਾਵੇਂ ਭੇਡ ਦੀ ਭਾਵੇਂ ਚਾਦਰ ਦੀ ਭਾਵੇਂ ਕਿਸੇ ਗਵਾਚੀ ਹੋਈ ਚੀਜ਼ ਦੀ ਜਿਸ ਵਿਖੇ ਕੋਈ ਆਖੇ ਕਿ ਇਹੋ ਹੀ ਹੈ ਤਾਂ ਉਨ੍ਹਾਂ ਦੋਹਾਂ ਦੀ ਗੱਲ ਨਿਆਂਈਆਂ ਕੋਲ ਆਵੇ ਅਤੇ ਜਿਹ ਨੂੰ ਨਿਆਈਂ ਦੋਸ਼ੀ ਠਹਿਰਾਉਣ ਉਹ ਆਪਣੇ ਗੁਆਂਢੀ ਨੂੰ ਦੁੱਗਣਾ ਭਰ ਦੇਵੇ। ");
INSERT INTO pan_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","ਜੇ ਕੋਈ ਮਨੁੱਖ ਆਪਣੇ ਗੁਆਂਢੀ ਨੂੰ ਗਧਾ ਜਾਂ ਬਲ਼ਦ ਜਾਂ ਭੇਡ ਜਾਂ ਕੋਈ ਪਸ਼ੂ ਸਾਂਭਣ ਲਈ ਦੇਵੇ ਅਤੇ ਉਹ ਮਰ ਜਾਵੇ ਜਾਂ ਸੱਟ ਖਾ ਜਾਵੇ ਜਾਂ ਕਿਸੇ ਦੇ ਵੇਖੇ ਬਿਨਾਂ ਕਿਤੇ ਹੱਕਿਆ ਜਾਵੇ ");
INSERT INTO pan_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","ਤਾਂ ਉਨ੍ਹਾਂ ਦੋਹਾਂ ਦੇ ਵਿੱਚ ਯਹੋਵਾਹ ਦੀ ਸਹੁੰ ਹੋਵੇਗੀ ਕਿ ਉਸ ਨੇ ਆਪਣੇ ਗੁਆਂਢੀ ਦੇ ਮਾਲ ਨੂੰ ਹੱਥ ਨਹੀਂ ਲਾਇਆ ਅਤੇ ਉਹ ਦਾ ਮਾਲਕ ਸੁਣ ਲਵੇ ਤਾਂ ਉਹ ਵੱਟਾ ਨਾ ਭਰੇ। ");
INSERT INTO pan_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","ਜੇ ਉਹ ਸੱਚ-ਮੁੱਚ ਉਸ ਤੋਂ ਚੁਰਾਇਆ ਜਾਵੇ ਤਾਂ ਉਹ ਉਸ ਦੇ ਮਾਲਕ ਨੂੰ ਵੱਟਾ ਭਰੇ। ");
INSERT INTO pan_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","ਜੇ ਉਹ ਸੱਚ-ਮੁੱਚ ਪਾੜਿਆ ਜਾਵੇ ਤਾਂ ਉਹ ਉਸ ਨੂੰ ਉਗਾਹੀ ਵਿੱਚ ਲਿਆਵੇ ਅਤੇ ਪਾੜੇ ਹੋਏ ਦਾ ਵੱਟਾ ਨਾ ਭਰੇ। ");
INSERT INTO pan_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","ਜਦ ਕੋਈ ਮਨੁੱਖ ਆਪਣੇ ਗੁਆਂਢੀ ਤੋਂ ਕੁਝ ਉਧਾਰ ਲਵੇ ਅਤੇ ਉਹ ਸੱਟ ਖਾ ਜਾਵੇ ਜਾਂ ਮਰ ਜਾਵੇ ਜਦ ਕਿ ਉਹ ਦਾ ਮਾਲਕ ਕੋਲ ਨਹੀਂ ਹੈ ਤਾਂ ਉਹ ਜ਼ਰੂਰ ਵੱਟਾ ਭਰੇ। ");
INSERT INTO pan_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","ਜੇ ਉਹ ਦਾ ਮਾਲਕ ਉਹ ਦੇ ਕੋਲ ਹੋਵੇ ਤਾਂ ਉਹ ਵੱਟਾ ਨਾ ਭਰੇ ਜੇ ਉਹ ਭਾੜੇ ਉੱਤੇ ਹੋਵੇ ਤਾਂ ਉਹ ਭਾੜੇ ਵਿੱਚ ਗਿਣਿਆ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","ਜਦ ਕੋਈ ਮਨੁੱਖ ਕਿਸੇ ਕੁਆਰੀ ਨੂੰ ਜਿਹ ਦੀ ਕੁੜਮਾਈ ਨਹੀਂ ਹੋਈ ਝਾਂਸਾ ਦੇਵੇ ਅਤੇ ਉਸ ਦੇ ਨਾਲ ਲੇਟੇ ਉਹ ਜ਼ਰੂਰ ਉਸ ਦਾ ਮੁੱਲ ਦੇ ਕੇ ਉਸ ਨੂੰ ਵਿਆਹ ਲਵੇ। ");
INSERT INTO pan_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","ਜੇ ਉਸ ਦਾ ਪਿਤਾ ਉਸ ਨੂੰ ਦੇਣ ਤੋਂ ਉੱਕਾ ਹੀ ਇਨਕਾਰੀ ਹੋਵੇ ਤਾਂ ਉਹ ਕੁਆਰੀਆਂ ਦੇ ਮੇਹਰ ਅਨੁਸਾਰ ਚਾਂਦੀ ਤੋਲ ਕੇ ਦੇਵੇ। ");
INSERT INTO pan_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","ਤੂੰ ਜਾਦੂਗਰਨੀ ਨੂੰ ਜਿਉਂਦੀ ਨਾ ਛੱਡ। ");
INSERT INTO pan_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","ਜੋ ਕੋਈ ਪਸ਼ੂ ਨਾਲ ਕੁਕਰਮ ਕਰੇ ਉਹ ਜ਼ਰੂਰ ਮਾਰਿਆ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","ਜਿਹੜਾ ਕੇਵਲ ਯਹੋਵਾਹ ਤੋਂ ਬਿਨਾਂ ਹੋਰ ਦੇਵਤਿਆਂ ਨੂੰ ਬਲੀਆਂ ਚੜ੍ਹਾਵੇ ਉਸ ਦਾ ਸੱਤਿਆਨਾਸ ਕੀਤਾ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","ਤੁਸੀਂ ਪਰਦੇਸੀ ਨੂੰ ਨਾ ਸਤਾਓ ਨਾ ਦੁੱਖ ਦਿਓ ਕਿਉਂ ਜੋ ਤੁਸੀਂ ਮਿਸਰ ਦੇਸ ਵਿੱਚ ਪਰਦੇਸੀ ਰਹੇ। ");
INSERT INTO pan_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","ਵਿਧਵਾ ਅਤੇ ਯਤੀਮ ਨੂੰ ਤੰਗ ਨਾ ਕਰੋ। ");
INSERT INTO pan_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","ਜੇ ਤੁਸੀਂ ਉਨ੍ਹਾਂ ਨੂੰ ਤੰਗ ਹੀ ਕਰੋਗੇ ਤਾਂ ਜਦ ਉਹ ਮੇਰੇ ਅੱਗੇ ਦੁਹਾਈ ਦੇਣਗੇ ਤਾਂ ਮੈਂ ਜ਼ਰੂਰ ਉਨ੍ਹਾਂ ਦੀ ਦੁਹਾਈ ਨੂੰ ਸੁਣਾਂਗਾ ");
INSERT INTO pan_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","ਅਤੇ ਮੇਰਾ ਕ੍ਰੋਧ ਭੜਕ ਉੱਠੇਗਾ ਅਤੇ ਮੈਂ ਤੁਹਾਨੂੰ ਤਲਵਾਰ ਨਾਲ ਵੱਢ ਸੁੱਟਾਂਗਾ ਅਤੇ ਤੁਹਾਡੀਆਂ ਔਰਤਾਂ ਵਿਧਵਾ ਅਤੇ ਤੁਹਾਡੇ ਪੁੱਤਰ ਯਤੀਮ ਹੋ ਜਾਣਗੇ। ");
INSERT INTO pan_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","ਜੇ ਤੂੰ ਮੇਰੀ ਪਰਜਾ ਵਿੱਚੋਂ ਆਪਣੇ ਨਾਲ ਦੇ ਕਿਸੇ ਕੰਗਾਲ ਨੂੰ ਚਾਂਦੀ ਉਧਾਰ ਦੇਵੇਂ ਤਾਂ ਤੂੰ ਉਹ ਦਾ ਬਿਆਜੜੀਆ ਨਾ ਬਣ, ਤੂੰ ਉਸ ਉੱਤੇ ਬਿਆਜ ਨਾ ਲਾਵੀਂ। ");
INSERT INTO pan_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","ਜੇ ਤੂੰ ਆਪਣੇ ਗੁਆਂਢੀ ਦੀ ਚਾਦਰ ਗਹਿਣੇ ਰੱਖੇਂ ਤਾਂ ਸੂਰਜ ਦੇ ਡੁੱਬਣ ਤੋਂ ਪਹਿਲਾਂ ਉਹ ਨੂੰ ਮੋੜ ਦੇ ");
INSERT INTO pan_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","ਕਿਉਂ ਜੋ ਉਹੀ ਉਸ ਦਾ ਓੜ੍ਹਨਾ ਹੈ। ਇਹ ਉਸ ਦੇ ਸਰੀਰ ਲਈ ਚਾਦਰ ਹੈ, ਉਹ ਕਾਹਦੇ ਵਿੱਚ ਲੰਮਾ ਪਵੇਗਾ? ਇਸ ਤਰ੍ਹਾਂ ਹੋਵੇਗਾ ਕਿ ਜਦ ਉਹ ਮੇਰੇ ਅੱਗੇ ਦੁਹਾਈ ਦੇਵੇਗਾ ਤਾਂ ਮੈਂ ਸੁਣਾਂਗਾ ਕਿਉਂ ਜੋ ਮੈਂ ਕਿਰਪਾਲੂ ਹਾਂ। ");
INSERT INTO pan_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","ਤੂੰ ਪਰਮੇਸ਼ੁਰ ਨੂੰ ਨਾ ਕੋਸ ਅਤੇ ਆਪਣੇ ਲੋਕਾਂ ਦੇ ਪ੍ਰਧਾਨ ਨੂੰ ਫਿਟਕਾਰ ਨਾ ਦੇ। ");
INSERT INTO pan_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","ਆਪਣੇ ਖਲਵਾੜੇ ਅਤੇ ਆਪਣੇ ਕੋਹਲੂ ਦੇ ਰਸ ਦੇ ਚੜ੍ਹਾਉਣ ਲਈ ਢਿੱਲ ਨਾ ਕਰ। ਤੂੰ ਆਪਣੇ ਪੁੱਤਰਾਂ ਵਿੱਚੋਂ ਪਹਿਲੌਠਾ ਮੈਨੂੰ ਦੇ। ");
INSERT INTO pan_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","ਇਸ ਤਰ੍ਹਾਂ ਤੂੰ ਆਪਣੇ ਬਲ਼ਦ ਅਤੇ ਆਪਣੀ ਭੇਡ ਨਾਲ ਕਰ ਕਿ ਸੱਤ ਦਿਨ ਉਹ ਆਪਣੀ ਮਾਂ ਨਾਲ ਰਹੇ ਪਰ ਅੱਠਵੇਂ ਦਿਨ ਉਹ ਤੂੰ ਮੈਨੂੰ ਦੇ। ");
INSERT INTO pan_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","ਤੁਸੀਂ ਮੇਰੇ ਲਈ ਪਵਿੱਤਰ ਮਨੁੱਖ ਹੋਵੋ ਇਸ ਲਈ ਦਰਿੰਦਿਆਂ ਤੋਂ ਪਾੜਿਆ ਹੋਇਆ ਮਾਸ ਨਾ ਖਾਓ। ਤੁਸੀਂ ਉਹ ਨੂੰ ਕੁੱਤਿਆਂ ਅੱਗੇ ਸੁੱਟ ਦਿਓ। ");
INSERT INTO pan_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","ਤੂੰ ਕੂੜ ਦੀ ਗੱਪਸ਼ੱਪ ਨਾ ਮਾਰ ਅਤੇ ਤੂੰ ਆਪਣਾ ਹੱਥ ਦੁਸ਼ਟਾਂ ਨਾਲ ਨਾ ਮਿਲਾ ਕਿ ਤੂੰ ਕੁਧਰਮ ਦਾ ਗਵਾਹ ਹੋਵੇਂ। ");
INSERT INTO pan_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","ਤੂੰ ਬੁਰਿਆਈ ਕਰਨ ਲਈ ਬਹੁਤਿਆਂ ਦੇ ਮਗਰ ਨਾ ਲੱਗ ਅਤੇ ਤੂੰ ਕਿਸੇ ਝਗੜੇ ਵਿੱਚ ਅਜਿਹਾ ਉੱਤਰ ਨਾ ਦੇ ਕਿ ਬਹੁਤਿਆਂ ਦੇ ਮਗਰ ਲੱਗ ਕੇ ਨਿਆਂ ਨੂੰ ਵਿਗਾੜ ਦੇਵੇਂ। ");
INSERT INTO pan_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","ਤੂੰ ਕਿਸੇ ਕੰਗਾਲ ਦਾ ਉਹ ਦੇ ਝਗੜੇ ਵਿੱਚ ਪੱਖ ਨਾ ਕਰ। ");
INSERT INTO pan_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","ਜਦ ਤੂੰ ਆਪਣੇ ਵੈਰੀ ਦੇ ਬਲ਼ਦ ਅਥਵਾ ਗਧੇ ਨੂੰ ਖੁੱਲ੍ਹਾ ਫਿਰਦਾ ਵੇਖੇਂ ਤਾਂ ਤੂੰ ਜ਼ਰੂਰ ਉਹ ਉਸ ਨੂੰ ਮੋੜ ਦੇ। ");
INSERT INTO pan_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","ਜਦ ਤੇਰੇ ਨਾਲ ਖੁਣਸ ਕਰਨ ਵਾਲੇ ਦਾ ਗਧਾ ਤੂੰ ਭਾਰ ਹੇਠ ਪਿਆ ਹੋਇਆ ਵੇਖੇਂ ਅਤੇ ਉਸ ਦੀ ਸਹਾਇਤਾ ਨਾ ਕਰਨੀ ਚਾਹੇਂ ਫਿਰ ਵੀ ਤੂੰ ਜ਼ਰੂਰ ਉਸ ਦੀ ਸਹਾਇਤਾ ਕਰ। ");
INSERT INTO pan_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","ਤੂੰ ਆਪਣੇ ਮੁਹਤਾਜ ਦੇ ਨਿਆਂ ਨੂੰ ਉਸ ਦੇ ਝਗੜੇ ਵਿੱਚ ਨਾ ਭੁਆਂ। ");
INSERT INTO pan_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","ਝੂਠੀ ਗੱਲ ਤੋਂ ਦੂਰ ਰਹਿ ਅਤੇ ਤੂੰ ਬੇਦੋਸ਼ੀ ਅਤੇ ਧਰਮੀ ਨੂੰ ਮਾਰ ਨਾ ਸੁੱਟ ਕਿਉਂ ਜੋ ਮੈਂ ਦੁਸ਼ਟ ਨੂੰ ਧਰਮੀ ਨਹੀਂ ਠਹਿਰਾਵਾਂਗਾ। ");
INSERT INTO pan_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","ਤੂੰ ਰਿਸ਼ਵਤ ਨਾ ਖਾਹ ਕਿਉਂ ਜੋ ਰਿਸ਼ਵਤ ਬੁੱਧਵਾਨ ਦੀਆਂ ਅੱਖਾਂ ਨੂੰ ਅੰਨ੍ਹਾ ਕਰ ਦਿੰਦੀ ਹੈ ਅਤੇ ਧਰਮੀਆਂ ਦੀਆਂ ਗੱਲਾਂ ਨੂੰ ਉਲਟ ਦਿੰਦੀ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","ਤੂੰ ਪਰਦੇਸੀ ਨੂੰ ਨਾ ਸਤਾ। ਤੁਸੀਂ ਪਰਦੇਸੀ ਦੇ ਮਨ ਨੂੰ ਜਾਣਦੇ ਹੋ ਕਿਉਂ ਜੋ ਤੁਸੀਂ ਮਿਸਰ ਦੇਸ ਵਿੱਚ ਪਰਦੇਸੀ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","ਛੇ ਸਾਲ ਤੂੰ ਆਪਣੀ ਧਰਤੀ ਬੀਜ ਅਤੇ ਉਸ ਦਾ ਹਾਸਲ ਇਕੱਠਾ ਕਰ। ");
INSERT INTO pan_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","ਪਰ ਸੱਤਵੇਂ ਸਾਲ ਤੂੰ ਉਹ ਨੂੰ ਛੱਡ ਦੇ ਕਿ ਵਿਹਲੀ ਰਹੇ ਤਾਂ ਜੋ ਤੇਰੇ ਲੋਕਾਂ ਦੇ ਮੁਹਤਾਜ ਖਾਣ ਅਤੇ ਜੋ ਕੁਝ ਉਹ ਛੱਡਣ ਉਹ ਰੜੇ ਦੇ ਦਰਿੰਦੇ ਖਾਣ। ਇਸ ਤਰ੍ਹਾਂ ਤੂੰ ਆਪਣੀ ਦਾਖ਼ ਅਤੇ ਜ਼ੈਤੂਨ ਦੀ ਵਾੜੀ ਨਾਲ ਵੀ ਕਰ। ");
INSERT INTO pan_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","ਛੇ ਦਿਨ ਤੂੰ ਆਪਣਾ ਕੰਮ ਕਰ ਪਰ ਸੱਤਵੇਂ ਦਿਨ ਤੂੰ ਵਿਸ਼ਰਾਮ ਕਰ ਤਾਂ ਜੋ ਤੇਰਾ ਬਲ਼ਦ ਅਤੇ ਤੇਰਾ ਗਧਾ ਸੁਸਤਾਉਣ ਅਤੇ ਤੇਰੀ ਗੋਲੀ ਦਾ ਪੁੱਤਰ ਅਤੇ ਪਰਦੇਸੀ ਟਹਿਕ ਜਾਣ। ");
INSERT INTO pan_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","ਜੋ ਕੁਝ ਮੈਂ ਤੁਹਾਨੂੰ ਆਖਿਆ ਉਸ ਵਿੱਚ ਸੁਚੇਤ ਰਹੋ ਅਤੇ ਹੋਰਨਾਂ ਦੇਵਤਿਆਂ ਦੇ ਨਾਮ ਵੀ ਨਾ ਲਓ ਅਤੇ ਉਹ ਤੁਹਾਡੇ ਮੂੰਹ ਤੋਂ ਸੁਣੇ ਵੀ ਨਾ ਜਾਣ। ");
INSERT INTO pan_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","ਤੂੰ ਸਾਲ ਵਿੱਚ ਤਿੰਨ ਵਾਰ ਮੇਰਾ ਪਰਬ ਮਨਾ। ");
INSERT INTO pan_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","ਪਤੀਰੀ ਰੋਟੀ ਦੇ ਪਰਬ ਨੂੰ ਤੂੰ ਮਨਾ। ਸੱਤ ਦਿਨ ਤੂੰ ਪਤੀਰੀ ਰੋਟੀ ਖਾ ਜਿਵੇਂ ਅਬੀਬ ਦੇ ਮਹੀਨੇ ਦੇ ਠਹਿਰਾਏ ਹੋਏ ਸਮੇਂ ਵਿੱਚ ਮੈਂ ਤੈਨੂੰ ਹੁਕਮ ਦਿੱਤਾ ਸੀ ਕਿਉਂ ਜੋ ਤੂੰ ਉਸ ਵਿੱਚ ਮਿਸਰ ਤੋਂ ਬਾਹਰ ਆਇਆ। ਖਾਲੀ ਹੱਥੀਂ ਉਹ ਮੇਰੇ ਸਾਹਮਣੇ ਵੇਖੇ ਨਾ ਜਾਣ। ");
INSERT INTO pan_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","ਵਾਢੀ ਦਾ ਪਰਬ ਅਰਥਾਤ ਤੇਰੇ ਕੰਮਾਂ ਦੇ ਪਹਿਲੇ ਫਲ ਜਿਹੜੇ ਤੂੰ ਪੈਲੀ ਵਿੱਚ ਬੀਜੇ ਅਤੇ ਇਕੱਠਾ ਕਰਨ ਦਾ ਪਰਬ ਸਾਲ ਦੇ ਛੇਕੜ ਵਿੱਚ ਜਦ ਤੂੰ ਆਪਣੀ ਕਮਾਈ ਨੂੰ ਪੈਲੀ ਤੋਂ ਇਕੱਠਾ ਕਰ ਲਿਆ ਹੋਵੇ। ");
INSERT INTO pan_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","ਸਾਲ ਵਿੱਚ ਤਿੰਨ ਵਾਰ ਤੁਹਾਡੇ ਸਾਰੇ ਪੁਰਖ ਪ੍ਰਭੂ ਯਹੋਵਾਹ ਅੱਗੇ ਹਾਜ਼ਰ ਹੋਣ। ");
INSERT INTO pan_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","ਤੂੰ ਮੇਰੇ ਬਲੀ ਪਸ਼ੂ ਦਾ ਲਹੂ ਖ਼ਮੀਰੀ ਰੋਟੀ ਨਾਲ ਨਾ ਚੜ੍ਹਾ। ਨਾ ਮੇਰੇ ਪਰਬ ਦੇ ਚੜ੍ਹਾਵੇ ਦੀ ਚਰਬੀ ਸਾਰੀ ਰਾਤ ਸਵੇਰ ਤੱਕ ਰਹੇ। ");
INSERT INTO pan_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","ਤੂੰ ਆਪਣੀ ਜ਼ਮੀਨ ਦੇ ਪਹਿਲੇ ਫਲਾਂ ਵਿੱਚੋਂ ਪਹਿਲਾ ਫਲ ਯਹੋਵਾਹ ਆਪਣੇ ਪਰਮੇਸ਼ੁਰ ਦੇ ਘਰ ਲਿਆਵੀਂ। ਤੂੰ ਪਠੋਰੇ ਨੂੰ ਉਸ ਦੀ ਮਾਂ ਦੇ ਦੁੱਧ ਵਿੱਚ ਨਾ ਉਬਾਲੀਂ। ");
INSERT INTO pan_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","ਵੇਖੋ ਮੈਂ ਇੱਕ ਦੂਤ ਤੁਹਾਡੇ ਅੱਗੇ ਭੇਜਦਾ ਹਾਂ ਕਿ ਉਹ ਤੁਹਾਡੇ ਰਾਹ ਵਿੱਚ ਤੁਹਾਡੀ ਰਾਖੀ ਕਰੇ ਅਤੇ ਤੁਹਾਨੂੰ ਉਸ ਸਥਾਨ ਨੂੰ ਜਿਹੜਾ ਮੈਂ ਤਿਆਰ ਕੀਤਾ ਹੈ ਲੈ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","ਉਸ ਦੇ ਅੱਗੇ ਚੌਕਸ ਰਹੋ ਅਤੇ ਉਸ ਦੀ ਅਵਾਜ਼ ਸੁਣੋ ਅਤੇ ਉਹ ਨੂੰ ਨਾ ਛੇੜੋ ਕਿਉਂ ਜੋ ਉਹ ਤੁਹਾਡੇ ਅਪਰਾਧ ਨੂੰ ਨਹੀਂ ਬਖ਼ਸ਼ੇਗਾ ਇਸ ਲਈ ਕਿ ਮੇਰਾ ਨਾਮ ਉਸ ਵਿੱਚ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","ਸਗੋਂ ਜੇ ਤੁਸੀਂ ਸੱਚ-ਮੁੱਚ ਉਸ ਦੀ ਅਵਾਜ਼ ਨੂੰ ਸੁਣੋ ਅਤੇ ਜੋ ਕੁਝ ਮੈਂ ਬੋਲਦਾ ਹਾਂ ਉਹ ਕਰੋ ਤਾਂ ਮੈਂ ਤੁਹਾਡੇ ਵੈਰੀਆਂ ਦਾ ਵੈਰੀ ਅਤੇ ਤੁਹਾਡੇ ਵਿਰੋਧੀਆਂ ਦਾ ਵਿਰੋਧੀ ਹੋਵਾਂਗਾ। ");
INSERT INTO pan_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","ਕਿਉਂ ਜੋ ਮੇਰਾ ਦੂਤ ਤੁਹਾਡੇ ਅੱਗੇ ਚੱਲੇਗਾ ਅਤੇ ਤੁਹਾਨੂੰ ਅਮੋਰੀਆਂ, ਹਿੱਤੀਆਂ, ਫ਼ਰਿੱਜ਼ੀਆਂ, ਕਨਾਨੀਆਂ, ਹਿੱਵੀਆਂ ਅਤੇ ਯਬੂਸੀਆਂ ਵਿੱਚ ਲਿਆਵੇਗਾ ਅਤੇ ਮੈਂ ਉਨ੍ਹਾਂ ਦਾ ਨਾਸ ਕਰਾਂਗਾ। ");
INSERT INTO pan_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","ਤੁਸੀਂ ਉਨ੍ਹਾਂ ਦੇ ਦੇਵਤਿਆਂ ਦੇ ਅੱਗੇ ਮੱਥਾ ਨਾ ਟੇਕੋ ਨਾ ਉਨ੍ਹਾਂ ਉਪਾਸਨਾ ਕਰੋ ਨਾ ਤੁਸੀਂ ਉਨ੍ਹਾਂ ਦੇ ਕੰਮਾਂ ਵਾਂਗੂੰ ਕੰਮ ਕਰੋ ਸਗੋਂ ਉਨ੍ਹਾਂ ਨੂੰ ਜ਼ਰੂਰ ਢਾਓ ਅਤੇ ਉਨ੍ਹਾਂ ਦੇ ਥੰਮਾਂ ਨੂੰ ਚਕਨਾ-ਚੂਰ ਕਰੋ। ");
INSERT INTO pan_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","ਤੁਸੀਂ ਯਹੋਵਾਹ ਆਪਣੇ ਪਰਮੇਸ਼ੁਰ ਦੀ ਉਪਾਸਨਾ ਕਰੋ ਅਤੇ ਉਹ ਤੁਹਾਡੀ ਰੋਟੀ ਅਤੇ ਤੁਹਾਡੇ ਪਾਣੀ ਨੂੰ ਬਰਕਤ ਦੇਵੇਗਾ ਅਤੇ ਮੈਂ ਤੁਹਾਡੇ ਵਿੱਚੋਂ ਬਿਮਾਰੀ ਕੱਢ ਦਿਆਂਗਾ। ");
INSERT INTO pan_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","ਤੁਹਾਡੀ ਧਰਤੀ ਵਿੱਚ ਕਿਸੇ ਦਾ ਗਰਭ ਨਾ ਡਿੱਗੇਗਾ ਨਾ ਕੋਈ ਬਾਂਝ ਰਹੇਗੀ। ਮੈਂ ਤੁਹਾਡੇ ਦਿਨਾਂ ਦਾ ਲੇਖਾ ਪੂਰਾ ਕਰਾਂਗਾ। ");
INSERT INTO pan_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","ਮੈਂ ਆਪਣਾ ਭੈਅ ਤੁਹਾਡੇ ਅੱਗੇ ਭੇਜਾਂਗਾ ਅਤੇ ਮੈਂ ਸਾਰੇ ਲੋਕਾਂ ਨੂੰ ਜਿਨ੍ਹਾਂ ਉੱਤੇ ਤੁਸੀਂ ਆਣ ਪਵੋਗੇ ਨਾਸ ਕਰ ਦੇਵਾਂਗਾ ਅਤੇ ਮੈਂ ਤੁਹਾਡੇ ਸਾਰੇ ਵੈਰੀਆਂ ਨੂੰ ਨੱਠੇ ਜਾਂਦੇ ਹੋਏ ਤੁਹਾਨੂੰ ਦੇਵਾਂਗਾ। ");
INSERT INTO pan_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","ਮੈਂ ਤੁਹਾਡੇ ਅੱਗੇ ਡੇਹਮੂ ਭੇਜਾਂਗਾ ਜਿਹੜਾ ਹਿੱਵੀ ਕਨਾਨੀ ਹਿੱਤੀ ਤੁਹਾਡੇ ਅੱਗੋਂ ਧੱਕ ਦੇਵੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","ਮੈਂ ਇੱਕੋ ਹੀ ਸਾਲ ਵਿੱਚ ਉਨ੍ਹਾਂ ਨੂੰ ਤੁਹਾਡੇ ਅੱਗੋਂ ਨਾ ਧੱਕਾਂਗਾ ਮਤੇ ਉਹ ਧਰਤੀ ਉੱਜੜ ਜਾਵੇ ਅਤੇ ਮੈਦਾਨ ਦੇ ਦਰਿੰਦੇ ਤੁਹਾਡੇ ਵਿਰੁੱਧ ਵਧ ਜਾਣ। ");
INSERT INTO pan_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","ਮੈਂ ਉਨ੍ਹਾਂ ਨੂੰ ਤੁਹਾਡੇ ਅੱਗੋਂ ਹੌਲੀ-ਹੌਲੀ ਧੱਕਾਂਗਾ ਜਦ ਤੱਕ ਤੁਸੀਂ ਨਾ ਫਲੋ ਅਤੇ ਧਰਤੀ ਨੂੰ ਆਪਣੇ ਵੱਸ ਵਿੱਚ ਨਾ ਕਰੋ। ");
INSERT INTO pan_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","ਸੋ ਮੈਂ ਤੁਹਾਡੀ ਹੱਦ ਲਾਲ ਸਮੁੰਦਰ ਤੋਂ ਫ਼ਲਿਸਤੀਆਂ ਦੇ ਸਮੁੰਦਰ ਤੱਕ ਅਤੇ ਉਜਾੜ ਤੋਂ ਦਰਿਆ (ਫ਼ਰਾਤ) ਤੱਕ ਠਹਿਰਾਵਾਂਗਾ ਕਿਉਂ ਜੋ ਮੈਂ ਤੁਹਾਡੇ ਹੱਥ ਵਿੱਚ ਉਸ ਧਰਤੀ ਦੇ ਵਸਨੀਕਾਂ ਨੂੰ ਦੇਵਾਂਗਾ ਅਤੇ ਤੁਸੀਂ ਉਨ੍ਹਾਂ ਨੂੰ ਆਪਣੇ ਅੱਗੋਂ ਧੱਕ ਦਿਓਗੇ। ");
INSERT INTO pan_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","ਤੁਸੀਂ ਉਨ੍ਹਾਂ ਨਾਲ ਅਥਵਾ ਉਨ੍ਹਾਂ ਦੇ ਦੇਵਤਿਆਂ ਨਾਲ ਨੇਮ ਨਾ ਬੰਨ੍ਹੋ। ");
INSERT INTO pan_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","ਉਹ ਤੁਹਾਡੀ ਧਰਤੀ ਵਿੱਚ ਨਾ ਰਹਿਣ ਅਜਿਹਾ ਨਾ ਹੋਵੇ ਕਿ ਉਹ ਤੁਹਾਡੇ ਤੋਂ ਮੇਰੇ ਵਿਰੁੱਧ ਪਾਪ ਕਰਾਉਣ ਕਿਉਂ ਜੇ ਤੁਸੀਂ ਉਨ੍ਹਾਂ ਦੇ ਦੇਵਤਿਆਂ ਦੀ ਉਪਾਸਨਾ ਕਰੋ ਤਾਂ ਉਹ ਜ਼ਰੂਰ ਤੁਹਾਡੇ ਲਈ ਫਾਹੀ ਹੋਵੇਗੀ। ");
INSERT INTO pan_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","ਉਸ ਨੇ ਮੂਸਾ ਨੂੰ ਆਖਿਆ, ਯਹੋਵਾਹ ਕੋਲ ਉਤਾਹਾਂ ਆ ਤੂੰ ਅਤੇ ਹਾਰੂਨ ਅਤੇ ਨਾਦਾਬ ਅਤੇ ਅਬੀਹੂ ਅਤੇ ਇਸਰਾਏਲ ਦੇ ਬਜ਼ੁਰਗਾਂ ਵਿੱਚੋਂ ਸੱਤਰ ਅਤੇ ਤੁਸੀਂ ਦੂਰੋਂ ਮੱਥਾ ਟੇਕੋ। ");
INSERT INTO pan_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","ਪਰ ਮੂਸਾ ਇਕੱਲਾ ਯਹੋਵਾਹ ਕੋਲ ਨੇੜੇ ਆਵੇ ਅਤੇ ਇਹ ਨੇੜੇ ਨਾ ਆਉਣ ਅਤੇ ਲੋਕ ਵੀ ਉਹ ਦੇ ਨਾਲ ਉਤਾਹਾਂ ਨਾ ਆਉਣ। ");
INSERT INTO pan_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","ਸੋ ਮੂਸਾ ਆਇਆ ਅਤੇ ਯਹੋਵਾਹ ਦੀਆਂ ਸਾਰੀਆਂ ਗੱਲਾਂ ਅਤੇ ਸਾਰੇ ਨਿਆਂ ਲੋਕਾਂ ਨੂੰ ਦੱਸੇ ਤਾਂ ਸਾਰੇ ਲੋਕਾਂ ਨੇ ਇੱਕ ਅਵਾਜ਼ ਨਾਲ ਬੋਲ ਕੇ ਉੱਤਰ ਦਿੱਤਾ, ਸਾਰੀਆਂ ਗੱਲਾਂ ਜਿਹੜੀਆਂ ਯਹੋਵਾਹ ਬੋਲਿਆ ਹੈ ਅਸੀਂ ਕਰਾਂਗੇ। ");
INSERT INTO pan_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","ਤਾਂ ਮੂਸਾ ਨੇ ਯਹੋਵਾਹ ਦੀਆਂ ਸਾਰੀਆਂ ਗੱਲਾਂ ਲਿਖੀਆਂ ਅਤੇ ਸਵੇਰ ਨੂੰ ਉੱਠ ਕੇ ਪਰਬਤ ਹੇਠ ਇੱਕ ਜਗਵੇਦੀ ਅਤੇ ਬਾਰਾਂ ਥੰਮ੍ਹ ਇਸਰਾਏਲ ਦੇ ਬਾਰਾਂ ਗੋਤਾਂ ਅਨੁਸਾਰ ਬਣਾਏ। ");
INSERT INTO pan_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","ਉਸ ਨੇ ਇਸਰਾਏਲ ਦੇ ਗੱਭਰੂਆਂ ਨੂੰ ਭੇਜਿਆ ਅਤੇ ਉਨ੍ਹਾਂ ਨੇ ਯਹੋਵਾਹ ਲਈ ਹੋਮ ਦੀਆਂ ਬਲੀਆਂ ਅਤੇ ਸੁੱਖ-ਸਾਂਦ ਦੀਆਂ ਬਲੀਆਂ ਬਲ਼ਦਾਂ ਤੋਂ ਚੜ੍ਹਾਈਆਂ। ");
INSERT INTO pan_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","ਫਿਰ ਮੂਸਾ ਨੇ ਅੱਧਾ ਲਹੂ ਲੈ ਕੇ ਭਾਂਡਿਆਂ ਵਿੱਚ ਰੱਖਿਆ ਅਤੇ ਬਾਕੀ ਦਾ ਅੱਧਾ ਲਹੂ ਜਗਵੇਦੀ ਦੇ ਉੱਤੇ ਛਿੜਕਿਆ ");
INSERT INTO pan_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","ਅਤੇ ਉਸ ਨੇ ਨੇਮ ਦੀ ਪੋਥੀ ਲੈ ਕੇ ਲੋਕਾਂ ਦੇ ਕੰਨਾਂ ਵਿੱਚ ਪੜ੍ਹ ਕੇ ਸੁਣਾਈ ਅਤੇ ਉਨ੍ਹਾਂ ਨੇ ਆਖਿਆ, ਅਸੀਂ ਸਭ ਕੁਝ ਜੋ ਯਹੋਵਾਹ ਬੋਲਿਆ ਹੈ ਕਰਾਂਗੇ ਅਤੇ ਮੰਨਾਂਗੇ। ");
INSERT INTO pan_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","ਉਪਰੰਤ ਮੂਸਾ ਨੇ ਲਹੂ ਲੈ ਕੇ ਲੋਕਾਂ ਉੱਤੇ ਛਿੜਕਿਆ ਅਤੇ ਆਖਿਆ, ਵੇਖੋ ਇਹ ਨੇਮ ਦਾ ਲਹੂ ਹੈ ਜੋ ਯਹੋਵਾਹ ਦੇ ਨੇਮ ਨੂੰ ਤਕੜਾ ਕਰਦਾ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","ਤਾਂ ਮੂਸਾ, ਹਾਰੂਨ, ਨਾਦਾਬ, ਅਬੀਹੂ ਅਤੇ ਇਸਰਾਏਲ ਦੇ ਸੱਤਰ ਬਜ਼ੁਰਗ ਉਤਾਹਾਂ ਗਏ। ");
INSERT INTO pan_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","ਫਿਰ ਉਨ੍ਹਾਂ ਨੇ ਇਸਰਾਏਲ ਦੇ ਪਰਮੇਸ਼ੁਰ ਨੂੰ ਡਿੱਠਾ ਅਤੇ ਉਸ ਦੇ ਪੈਰਾਂ ਹੇਠ ਨੀਲਮ ਦੇ ਪੱਥਰਾਂ ਦਾ ਫਰਸ਼ ਜਿਹਾ ਸੀ ਅਤੇ ਉਸ ਦੀ ਚਮਕ ਅਕਾਸ਼ ਹੀ ਵਰਗੀ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","ਉਸ ਨੇ ਆਪਣਾ ਹੱਥ ਇਸਰਾਏਲੀਆਂ ਦੇ ਭਲੇ ਪੁਰਸ਼ਾਂ ਉੱਤੇ ਨਾ ਪਾਇਆ ਸੋ ਉਨ੍ਹਾਂ ਨੇ ਪਰਮੇਸ਼ੁਰ ਦਾ ਦਰਸ਼ਣ ਕੀਤਾ ਅਤੇ ਉਨ੍ਹਾਂ ਨੇ ਖਾਧਾ ਪੀਤਾ। ");
INSERT INTO pan_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","ਫਿਰ ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਆਖਿਆ, ਮੇਰੇ ਕੋਲ ਪਰਬਤ ਉੱਤੇ ਆ ਅਤੇ ਉੱਥੇ ਰਹਿ ਤਾਂ ਜੋ ਮੈਂ ਤੈਨੂੰ ਪੱਥਰ ਦੀਆਂ ਫੱਟੀਆਂ ਅਤੇ ਬਿਵਸਥਾ ਅਤੇ ਹੁਕਮ ਜਿਹੜੇ ਮੈਂ ਉਨ੍ਹਾਂ ਦੀ ਸਿੱਖਿਆ ਲਈ ਲਿਖੇ ਹਨ ਦੇਵਾਂ। ");
INSERT INTO pan_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","ਸੋ ਮੂਸਾ ਅਤੇ ਉਸ ਦਾ ਸੇਵਕ ਯਹੋਸ਼ੁਆ ਉੱਠੇ ਅਤੇ ਮੂਸਾ ਪਰਮੇਸ਼ੁਰ ਦੇ ਪਰਬਤ ਉੱਤੇ ਗਿਆ। ");
INSERT INTO pan_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","ਅਤੇ ਉਸ ਨੇ ਬਜ਼ੁਰਗਾਂ ਨੂੰ ਆਖਿਆ, ਤੁਸੀਂ ਸਾਡੇ ਨਾਲ ਏਥੇ ਠਹਿਰੋ ਜਦ ਤੱਕ ਅਸੀਂ ਤੁਹਾਡੇ ਕੋਲ ਨਾ ਮੁੜ ਆਈਏ ਅਤੇ ਵੇਖੋ ਹਾਰੂਨ ਅਤੇ ਹੂਰ ਤੁਹਾਡੇ ਨਾਲ ਹਨ। ਜੇ ਕਿਸੇ ਦੀ ਕੋਈ ਗੱਲ ਹੋਵੇ ਤਾਂ ਉਨ੍ਹਾਂ ਦੇ ਕੋਲ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","ਸੋ ਮੂਸਾ ਪਰਬਤ ਉੱਤੇ ਚੜ੍ਹਿਆ ਅਤੇ ਬੱਦਲ ਪਰਬਤ ਉੱਤੇ ਛਾ ਗਿਆ। ");
INSERT INTO pan_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","ਅਤੇ ਯਹੋਵਾਹ ਦਾ ਪਰਤਾਪ ਸੀਨਈ ਪਰਬਤ ਉੱਤੇ ਠਹਿਰਿਆ ਅਤੇ ਬੱਦਲ ਉਸ ਉੱਤੇ ਛੇ ਦਿਨ ਛਾਇਆ ਰਿਹਾ ਤਾਂ ਸੱਤਵੇਂ ਦਿਨ ਉਸ ਨੇ ਬੱਦਲ ਦੇ ਵਿੱਚੋਂ ਮੂਸਾ ਨੂੰ ਸੱਦਿਆ। ");
INSERT INTO pan_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","ਯਹੋਵਾਹ ਦੇ ਤੇਜ ਦਾ ਦਰਸ਼ਣ ਭਸਮ ਕਰਨ ਵਾਲੀ ਅੱਗ ਵਾਂਗੂੰ ਪਰਬਤ ਦੀ ਟੀਸੀ ਉੱਤੇ ਇਸਰਾਏਲੀਆਂ ਦੀਆਂ ਅੱਖਾਂ ਵਿੱਚ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","ਅਤੇ ਮੂਸਾ ਬੱਦਲ ਦੇ ਵਿਚਕਾਰ ਚੱਲਿਆ ਗਿਆ ਅਤੇ ਪਰਬਤ ਉੱਤੇ ਚੜ੍ਹ ਗਿਆ ਤਾਂ ਮੂਸਾ ਪਰਬਤ ਉੱਤੇ ਚਾਲ੍ਹੀ ਦਿਨ ਅਤੇ ਚਾਲ੍ਹੀ ਰਾਤਾਂ ਰਿਹਾ। ");
INSERT INTO pan_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨਾਲ ਗੱਲ ਕੀਤੀ ਕਿ ");
INSERT INTO pan_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","ਇਸਰਾਏਲੀਆਂ ਨੂੰ ਆਖ ਕਿ ਉਹ ਮੇਰੇ ਲਈ ਭੇਟ ਲਿਆਉਣ। ਹਰ ਇੱਕ ਮਨੁੱਖ ਤੋਂ ਜਿਹ ਦਾ ਮਨ ਉਹ ਨੂੰ ਪਰੇਰੇ ਤੁਸੀਂ ਮੇਰੇ ਲਈ ਭੇਟ ਲਿਓ। ");
INSERT INTO pan_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","ਇਹ ਉਹ ਭੇਟ ਹੈ ਜਿਹੜੀ ਤੁਸੀਂ ਉਨ੍ਹਾਂ ਤੋਂ ਲਿਓ ਅਰਥਾਤ ਸੋਨਾ ਚਾਂਦੀ ਪਿੱਤਲ ");
INSERT INTO pan_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","ਨੀਲਾ, ਬੈਂਗਣੀ, ਕਿਰਮਚੀ ਰੰਗ ਅਤੇ ਮਹੀਨ ਕਤਾਨ ਅਤੇ ਪਸ਼ਮ ");
INSERT INTO pan_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","ਅਤੇ ਛੱਤ੍ਰਿਆਂ ਦੀਆਂ ਲਾਲ ਰੰਗੀਆਂ ਹੋਈਆਂ ਖੱਲਾਂ ਅਤੇ ਬੱਕਰਿਆਂ ਦੀਆਂ ਖੱਲਾਂ ਅਤੇ ਸ਼ਿੱਟੀਮ ਦੀ ਲੱਕੜੀ ");
INSERT INTO pan_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","ਅਤੇ ਦੀਵੇ ਦਾ ਤੇਲ ਅਤੇ ਮਸਹ ਕਰਨ ਦੇ ਤੇਲ ਦਾ ਅਤੇ ਸੁਗੰਧੀ ਦੀ ਧੂਪ ਦਾ ਮਸਾਲਾ ");
INSERT INTO pan_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","ਸੁਲੇਮਾਨੀ ਪੱਥਰ ਅਤੇ ਏਫ਼ੋਦ ਅਤੇ ਸੀਨੇ ਬੰਦ ਵਿੱਚ ਜੜਨ ਲਈ ਨਗ। ");
INSERT INTO pan_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","ਅਤੇ ਉਹ ਮੇਰੇ ਲਈ ਇੱਕ ਪਵਿੱਤਰ ਸਥਾਨ ਬਣਾਉਣ ਤਾਂ ਜੋ ਮੈਂ ਉਨ੍ਹਾਂ ਦੇ ਵਿਚਕਾਰ ਵੱਸਾਂ। ");
INSERT INTO pan_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","ਜਿਵੇਂ ਮੈਂ ਤੈਨੂੰ ਸਭ ਕੁਝ ਵਿਖਾਉਂਦਾ ਹਾਂ ਡੇਰੇ ਦੇ ਨਮੂਨੇ ਉੱਤੇ ਅਤੇ ਉਸ ਦੇ ਸਾਰੇ ਸਮਾਨ ਦੇ ਨਮੂਨੇ ਉੱਤੇ ਓਵੇਂ ਹੀ ਬਣਾਇਓ। ");
INSERT INTO pan_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","ਉਹ ਸ਼ਿੱਟੀਮ ਦੀ ਲੱਕੜੀ ਦਾ ਇੱਕ ਸੰਦੂਕ ਬਣਾਉਣ ਜਿਸ ਦੀ ਲੰਬਾਈ ਢਾਈ ਹੱਥ ਅਤੇ ਚੌੜਾਈ ਡੇਢ ਹੱਥ ਅਤੇ ਉਚਾਈ ਡੇਢ ਹੱਥ ਹੋਵੇ। ");
INSERT INTO pan_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","ਤੂੰ ਉਸ ਉੱਤੇ ਕੁੰਦਨ ਸੋਨਾ ਮੜ੍ਹੀਂ ਅਤੇ ਤੂੰ ਉਸ ਨੂੰ ਅੰਦਰੋਂ ਬਾਹਰੋਂ ਮੜ੍ਹੀਂ ਅਤੇ ਤੂੰ ਉਸ ਉੱਤੇ ਸੋਨੇ ਦੀ ਬਨੇਰੀ ਚੁਫ਼ੇਰੇ ਬਣਾਈਂ। ");
INSERT INTO pan_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","ਉਸ ਦੇ ਲਈ ਸੋਨੇ ਦੇ ਚਾਰ ਕੜੇ ਢਾਲ਼ ਕੇ ਉਹ ਦਿਆਂ ਚੌਹਾਂ ਪਾਵਿਆਂ ਵਿੱਚ ਲਾਈਂ ਅਰਥਾਤ ਦੋ ਕੜੇ ਇੱਕ ਪਾਸੇ ਦੋ ਕੜੇ ਦੂਜੇ ਪਾਸੇ। ");
INSERT INTO pan_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","ਨਾਲੇ ਤੂੰ ਸ਼ਿੱਟੀਮ ਦੀ ਲੱਕੜੀ ਦੀਆਂ ਚੋਬਾਂ ਬਣਾਈਂ ਅਤੇ ਉਨ੍ਹਾਂ ਉੱਤੇ ਸੋਨਾ ਮੜ੍ਹੀਂ। ");
INSERT INTO pan_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","ਤੂੰ ਉਨ੍ਹਾਂ ਚੋਬਾਂ ਨੂੰ ਸੰਦੂਕ ਦੇ ਪਾਸਿਆਂ ਦੇ ਕੜਿਆਂ ਵਿੱਚ ਪਾਵੀਂ ਤਾਂ ਜੋ ਉਨ੍ਹਾਂ ਨਾਲ ਸੰਦੂਕ ਚੁੱਕਿਆ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","ਚੋਬਾਂ ਸੰਦੂਕ ਦੇ ਕੜਿਆਂ ਵਿੱਚ ਰਹਿਣ ਅਤੇ ਉਹ ਉਨ੍ਹਾਂ ਵਿੱਚੋਂ ਕੱਢੀਆਂ ਨਾ ਜਾਣ। ");
INSERT INTO pan_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","ਤੂੰ ਉਸ ਸੰਦੂਕ ਵਿੱਚ ਉਹ ਸਾਖੀ ਰੱਖੀਂ ਜਿਹੜੀ ਮੈਂ ਤੈਨੂੰ ਦੇਵਾਂਗਾ। ");
INSERT INTO pan_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","ਤੂੰ ਪ੍ਰਾਸਚਿਤ ਦਾ ਸਰਪੋਸ਼ ਕੁੰਦਨ ਸੋਨੇ ਦਾ ਬਣਾਈਂ ਜਿਸ ਦੀ ਲੰਬਾਈ ਢਾਈ ਹੱਥ ਅਤੇ ਚੌੜਾਈ ਡੇਢ ਹੱਥ ਹੋਵੇ। ");
INSERT INTO pan_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","ਤੂੰ ਸੋਨੇ ਦੇ ਦੋ ਕਰੂਬੀ ਬਣਾਈਂ। ਤੂੰ ਉਨ੍ਹਾਂ ਨੂੰ ਘੜ੍ਹ ਕੇ ਪ੍ਰਾਸਚਿਤ ਦੇ ਸਰਪੋਸ਼ ਦੇ ਦੋਹਾਂ ਸਿਰਿਆਂ ਤੋਂ ਘੜ੍ਹ ਕੇ ਬਣਾਈਂ। ");
INSERT INTO pan_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","ਤੂੰ ਇੱਕ ਕਰੂਬੀ ਇੱਕ ਸਿਰੇ ਤੋਂ ਅਤੇ ਦੂਜਾ ਕਰੂਬੀ ਦੂਜੇ ਸਿਰੇ ਤੋਂ ਬਣਾਈਂ। ਪ੍ਰਾਸਚਿਤ ਦੇ ਸਰਪੋਸ਼ ਹੀ ਤੋਂ ਤੁਸੀਂ ਦੋਹਾਂ ਪਾਸਿਆਂ ਉੱਤੇ ਕਰੂਬੀਆਂ ਨੂੰ ਬਣਾਇਓ। ");
INSERT INTO pan_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","ਅਤੇ ਉਹ ਕਰੂਬੀ ਆਪਣੇ ਦੋਵੇਂ ਖੰਭ ਉਤਾਹਾਂ ਨੂੰ ਖਿਲਾਰੇ ਹੋਣ ਅਤੇ ਉਹ ਆਪਣੇ ਖੰਭਾਂ ਨਾਲ ਪ੍ਰਾਸਚਿਤ ਦੇ ਸਰਪੋਸ਼ ਨੂੰ ਢੱਕਦੇ ਹੋਣ ਅਤੇ ਉਨ੍ਹਾਂ ਦੇ ਮੂੰਹ ਆਹਮੋ-ਸਾਹਮਣੇ ਹੋਣ ਅਤੇ ਕਰੂਬੀਆਂ ਦੇ ਮੂੰਹ ਪ੍ਰਾਸਚਿਤ ਦੇ ਸਰਪੋਸ਼ ਵੱਲ ਹੋਣ। ");
INSERT INTO pan_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","ਅਤੇ ਤੂੰ ਪ੍ਰਾਸਚਿਤ ਨੂੰ ਉਤਾਂਹ ਸੰਦੂਕ ਦੇ ਉੱਤੇ ਰੱਖੀਂ ਅਤੇ ਤੂੰ ਉਸ ਸਾਖੀ ਨੂੰ ਜਿਹੜੀ ਮੈਂ ਤੈਨੂੰ ਦਿਆਂਗਾ ਸੰਦੂਕ ਵਿੱਚ ਰੱਖੀਂ। ");
INSERT INTO pan_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","ਤਦ ਮੈਂ ਤੈਨੂੰ ਉੱਥੇ ਮਿਲਾਂਗਾ ਅਤੇ ਤੇਰੇ ਨਾਲ ਪ੍ਰਾਸਚਿਤ ਦੇ ਸਰਪੋਸ਼ ਦੇ ਉੱਤੋਂ ਦੋਹਾਂ ਕਰੂਬੀਆਂ ਦੇ ਵਿੱਚੋਂ ਦੀ ਜਿਹੜੇ ਸਾਖੀ ਦੇ ਸੰਦੂਕ ਦੇ ਉੱਤੇ ਹਨ ਮੈਂ ਉਹ ਗੱਲਾਂ ਕਰਾਂਗਾ ਜਿਨ੍ਹਾਂ ਦਾ ਤੈਨੂੰ ਇਸਰਾਏਲੀਆਂ ਲਈ ਹੁਕਮ ਦਿਆਂਗਾ। ");
INSERT INTO pan_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","ਤੂੰ ਸ਼ਿੱਟੀਮ ਦੀ ਲੱਕੜੀ ਦਾ ਇੱਕ ਮੇਜ਼ ਬਣਾਈਂ। ਉਸ ਦੀ ਲੰਬਾਈ ਦੋ ਹੱਥ ਅਤੇ ਉਸ ਦੀ ਚੌੜਾਈ ਇੱਕ ਹੱਥ ਅਤੇ ਉਸ ਦੀ ਉਚਾਈ ਡੇਢ ਹੱਥ ਹੋਵੇ। ");
INSERT INTO pan_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","ਤੂੰ ਉਸ ਨੂੰ ਕੁੰਦਨ ਸੋਨੇ ਨਾਲ ਮੜ੍ਹੀਂ ਅਤੇ ਉਸ ਦੇ ਚੁਫ਼ੇਰੇ ਸੋਨੇ ਦੀ ਬਨੇਰੀ ਬਣਾਈਂ। ");
INSERT INTO pan_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","ਤੂੰ ਉਹ ਦੇ ਲਈ ਚੁਫ਼ੇਰੇ ਇੱਕ ਚੱਪਾ ਕਿਨਾਰੀ ਬਣਾਈਂ ਅਤੇ ਤੂੰ ਕਿਨਾਰੀ ਦੇ ਚੁਫ਼ੇਰੇ ਸੋਨੇ ਦੀ ਬਨੇਰੀ ਬਣਾਈਂ। ");
INSERT INTO pan_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","ਤੂੰ ਉਹ ਦੇ ਲਈ ਸੋਨੇ ਦੇ ਚਾਰ ਕੜੇ ਬਣਾਈਂ ਅਤੇ ਤੂੰ ਉਨ੍ਹਾਂ ਕੜਿਆਂ ਨੂੰ ਉਹ ਦੇ ਚੌਹਾਂ ਖੂੰਜਿਆਂ ਉੱਤੇ ਜਿਹੜੇ ਉਸ ਦੇ ਚੌਹਾਂ ਪਾਵਿਆਂ ਉੱਤੇ ਹਨ ਪਾਈਂ। ");
INSERT INTO pan_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","ਕਿਨਾਰੀ ਦੇ ਕੋਲ ਹੀ ਕੜੇ ਹੋਣ ਅਤੇ ਉਹ ਮੇਜ਼ ਚੁੱਕਣ ਨੂੰ ਚੋਬਾਂ ਦੇ ਲਈ ਥਾਂ ਹੋਣ। ");
INSERT INTO pan_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","ਤੂੰ ਉਹ ਚੋਬਾਂ ਸ਼ਿੱਟੀਮ ਦੀਆਂ ਲੱਕੜੀ ਦੀ ਬਣਾਈਂ। ਤੂੰ ਉਨ੍ਹਾਂ ਨੂੰ ਸੋਨੇ ਨਾਲ ਮੜ੍ਹੀਂ ਤਾਂ ਜੋ ਮੇਜ਼ ਉਨ੍ਹਾਂ ਨਾਲ ਚੁੱਕੀ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","ਨਾਲੇ ਤੂੰ ਉਸ ਦੀਆਂ ਥਾਲੀਆਂ, ਚਮਚੇ, ਉਸ ਦੇ ਗੜਵੇ ਅਤੇ ਡੋਲ੍ਹਣ ਦੇ ਕਟੋਰੇ ਬਣਾਈਂ ਉਹ ਕੁੰਦਨ ਸੋਨੇ ਦੇ ਬਣਾਈਂ। ");
INSERT INTO pan_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","ਤੂੰ ਮੇਜ਼ ਦੇ ਉੱਤੇ ਮੇਰੇ ਅੱਗੇ ਹਜ਼ੂਰੀ ਦੀ ਰੋਟੀ ਸਦਾ ਲਈ ਰੱਖਿਆ ਕਰੀਂ। ");
INSERT INTO pan_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","ਤੂੰ ਸ਼ਮਾਦਾਨ ਕੁੰਦਨ ਸੋਨੇ ਦਾ ਬਣਾਈਂ। ਉਹ ਸ਼ਮਾਦਾਨ ਘੜ੍ਹ ਕੇ ਬਣਾਇਆ ਜਾਵੇ। ਉਸ ਦਾ ਪਾਏਦਾਨ ਅਤੇ ਉਸ ਦਾ ਡੰਡਾ ਉਸ ਦੇ ਕਟੋਰੇ ਉਸ ਦੇ ਗੋਲੇ ਅਤੇ ਉਸ ਦੇ ਫੁੱਲ ਉਸ ਦੇ ਵਿੱਚੋਂ ਹੀ ਹੋਣ। ");
INSERT INTO pan_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","ਛੇ ਟਹਿਣੀਆਂ ਉਸ ਦੇ ਦੋਹਾਂ ਪਾਸਿਆਂ ਤੋਂ ਨਿੱਕਲਣ। ਸ਼ਮਾਦਾਨ ਦੇ ਇੱਕ ਪਾਸਿਓਂ ਤਿੰਨ ਟਹਿਣੀਆਂ ਅਤੇ ਸ਼ਮਾਦਾਨ ਦੇ ਦੂਜੇ ਪਾਸਿਓਂ ਤਿੰਨ ਟਹਿਣੀਆਂ। ");
INSERT INTO pan_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","ਇੱਕ ਟਹਿਣੀ ਉੱਤੇ ਤਿੰਨ ਕਟੋਰੇ ਬਦਾਮ ਦੇ ਫੁੱਲਾਂ ਵਰਗੇ ਅਤੇ ਇੱਕ ਗੋਲਾ ਅਤੇ ਇੱਕ ਫੁੱਲ ਅਤੇ ਦੂਜੀ ਟਹਿਣੀ ਉੱਤੇ ਤਿੰਨ ਕਟੋਰੇ ਬਦਾਮ ਦੇ ਫੁੱਲਾਂ ਵਰਗੇ ਅਤੇ ਇੱਕ ਗੋਲਾ ਅਤੇ ਇੱਕ ਫੁੱਲ ਅਤੇ ਇਸ ਤਰ੍ਹਾਂ ਹੀ ਛੇਆਂ ਟਹਿਣੀਆਂ ਲਈ ਜਿਹੜੀਆਂ ਸ਼ਮਾਦਾਨ ਤੋਂ ਨਿੱਕਲਦੀਆਂ ਹੋਣ। ");
INSERT INTO pan_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","ਅਤੇ ਸ਼ਮਾਦਾਨ ਵਿੱਚ ਚਾਰ ਕਟੋਰੇ ਬਦਾਮ ਦੇ ਫੁੱਲਾਂ ਵਰਗੇ ਅਤੇ ਉਹ ਦੇ ਗੋਲੇ ਅਤੇ ਉਹ ਦੇ ਫੁੱਲ ");
INSERT INTO pan_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","ਅਤੇ ਉਸੇ ਤੋਂ ਦੋਹਾਂ ਟਹਿਣੀਆਂ ਹੇਠ ਇੱਕ ਗੋਲਾ ਅਤੇ ਫੇਰ ਉਸੇ ਤੋਂ ਦੋਹਾਂ ਟਹਿਣੀਆਂ ਹੇਠ ਇੱਕ ਗੋਲਾ ਅਤੇ ਫੇਰ ਉਸੇ ਤੋਂ ਦੋਹਾਂ ਟਹਿਣੀਆਂ ਹੇਠ ਇੱਕ ਗੋਲਾ ਹੋਵੇ ਅਤੇ ਇਸ ਤਰ੍ਹਾਂ ਹੀ ਉਨ੍ਹਾਂ ਛੇਆਂ ਟਹਿਣੀਆਂ ਲਈ ਜਿਹੜੀਆਂ ਸ਼ਮਾਦਾਨ ਤੋਂ ਨਿੱਕਲਦੀਆਂ ਹਨ ਹੋਵੇ। ");
INSERT INTO pan_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","ਉਨ੍ਹਾਂ ਦੇ ਗੋਲੇ ਅਤੇ ਉਨ੍ਹਾਂ ਦੀਆਂ ਟਹਿਣੀਆਂ ਉਸੇ ਤੋਂ ਹੋਣ ਅਰਥਾਤ ਇਹ ਸਾਰਾ ਘੜਿਆ ਹੋਇਆ ਕੁੰਦਨ ਸੋਨੇ ਦੇ ਇੱਕ ਟੁੱਕੜੇ ਤੋਂ ਹੋਵੇ। ");
INSERT INTO pan_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","ਤੂੰ ਉਸ ਦੇ ਸੱਤ ਦੀਵੇ ਬਣਾਈਂ ਅਤੇ ਜਦ ਉਹ ਦੇ ਦੀਵੇ ਬਾਲੇ ਜਾਣ ਤਾਂ ਉਹ ਆਹਮੋ-ਸਾਹਮਣੇ ਚਾਨਣ ਦੇਣ। ");
INSERT INTO pan_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","ਉਸ ਦੇ ਗੁਲਤਰਾਸ਼ ਅਤੇ ਉਸ ਦੇ ਗੁਲਦਾਨ ਕੁੰਦਨ ਸੋਨੇ ਦੇ ਹੋਣ ");
INSERT INTO pan_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","ਅਤੇ ਕੁੰਦਨ ਸੋਨੇ ਦੇ ਇੱਕ ਮਣ ਦੇ ਲੱਗਭੱਗ ਤੋਂ ਇਹ ਅਤੇ ਇਹ ਸਾਰੇ ਭਾਂਡੇ ਬਣਾਏ ਜਾਣ। ");
INSERT INTO pan_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","ਸੋ ਵੇਖ ਤੂੰ ਉਨ੍ਹਾਂ ਨੂੰ ਉਸੇ ਨਮੂਨੇ ਦੇ ਬਣਾਈਂ ਜਿਹੜਾ ਤੈਨੂੰ ਪਰਬਤ ਉੱਤੇ ਵਿਖਾਇਆ ਗਿਆ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","ਤੂੰ ਡੇਰੇ ਲਈ ਦਸ ਪਰਦੇ ਉਣੀ ਹੋਈ ਕਤਾਨ ਦੇ ਨੀਲੇ ਬੈਂਗਣੀ ਅਤੇ ਕਿਰਮਚੀ ਰੰਗ ਦੇ ਬਣਾਈਂ, ਕਰੂਬੀਆਂ ਨਾਲ ਤੂੰ ਕਾਰੀਗਰੀ ਦਾ ਕੰਮ ਬਣਾਈਂ। ");
INSERT INTO pan_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","ਹਰ ਇੱਕ ਪਰਦੇ ਦੀ ਲੰਬਾਈ ਅਠਾਈ ਹੱਥ ਅਤੇ ਹਰ ਪਰਦੇ ਦੀ ਚੌੜਾਈ ਚਾਰ ਹੱਥ ਇੱਕੋ ਹੀ ਨਾਪ ਸਾਰਿਆਂ ਪਰਦਿਆਂ ਦਾ ਹੋਵੇ। ");
INSERT INTO pan_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","ਪੰਜ ਪਰਦੇ ਇੱਕ ਦੂਜੇ ਨਾਲ ਜੁੜੇ ਹੋਏ ਹੋਣ ਅਤੇ ਦੂਜੇ ਪੰਜ ਪਰਦੇ ਵੀ ਇੱਕ ਦੂਜੇ ਨਾਲ ਜੁੜੇ ਹੋਏ ਹੋਣ। ");
INSERT INTO pan_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","ਅਤੇ ਤੂੰ ਨੀਲੇ ਰੰਗ ਦੇ ਬੀੜੇ ਹਰ ਇੱਕ ਪਰਦੇ ਦੀ ਸੰਜਾਫ਼ ਵਿੱਚ ਜੋੜ ਦੇ ਸਿਰੇ ਵੱਲ ਬਣਾਈਂ ਅਤੇ ਇਸ ਤਰ੍ਹਾਂ ਤੂੰ ਪਰਦੇ ਦੀ ਸੰਜਾਫ਼ ਦੇ ਦੂਜੇ ਬਾਹਰਲੇ ਜੋੜ ਦੇ ਸਿਰੇ ਉੱਤੇ ਬਣਾਈਂ। ");
INSERT INTO pan_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","ਪੰਜਾਹ ਬੀੜੇ ਤੂੰ ਪਹਿਲੇ ਪਰਦੇ ਵਿੱਚ ਅਤੇ ਪੰਜਾਹ ਬੀੜੇ ਤੂੰ ਉਸ ਸਿਰੇ ਵੱਲ ਜਿਹੜਾ ਦੂਜੇ ਜੋੜ ਵਿੱਚ ਹੈ ਬਣਾਈਂ। ਉਹ ਬੀੜੇ ਇੱਕ ਦੂਜੇ ਦੇ ਆਹਮੋ-ਸਾਹਮਣੇ ਹੋਣ। ");
INSERT INTO pan_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","ਅਤੇ ਤੂੰ ਪੰਜਾਹ ਕੁੰਡੀਆਂ ਸੋਨੇ ਦੀਆਂ ਬਣਾਈਂ ਅਤੇ ਪਰਦਿਆਂ ਨੂੰ ਇੱਕ ਦੂਜੇ ਨਾਲ ਕੁੰਡੀਆਂ ਨਾਲ ਜੋੜੀਂ ਤਾਂ ਜੋ ਇਸ ਤਰ੍ਹਾਂ ਡੇਰਾ ਇੱਕੋ ਜਿਹਾ ਹੋ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","ਤੂੰ ਪਸ਼ਮ ਦੇ ਗਿਆਰ੍ਹਾਂ ਪਰਦੇ ਡੇਰੇ ਦੇ ਤੰਬੂ ਲਈ ਬਣਾਈਂ। ");
INSERT INTO pan_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","ਹਰ ਇੱਕ ਪਰਦੇ ਦੀ ਲੰਬਾਈ ਤੀਹ ਹੱਥ ਅਤੇ ਹਰ ਪਰਦੇ ਦੀ ਚੌੜਾਈ ਚਾਰ ਹੱਥ ਅਤੇ ਇਹ ਗਿਆਰ੍ਹਾਂ ਪਰਦੇ ਇੱਕੋ ਨਾਪ ਦੇ ਹੋਣ। ");
INSERT INTO pan_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","ਤੂੰ ਪੰਜ ਪਰਦੇ ਵੱਖਰੇ ਜੋੜੀਂ ਅਤੇ ਛੇ ਪਰਦੇ ਵੱਖਰੇ ਅਤੇ ਤੰਬੂ ਦੇ ਅਗਲੇ ਪਾਸੇ ਤੂੰ ਛੇਵਾਂ ਪੜਦਾ ਲਪੇਟੀਂ। ");
INSERT INTO pan_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","ਤੂੰ ਪੰਜਾਹ ਬੀੜੇ ਉਸ ਪਰਦੇ ਦੀ ਸੰਜਾਫ਼ ਵਿੱਚ ਜਿਹੜੀ ਜੋੜ ਦੇ ਸਿਰੇ ਉੱਤੇ ਹੈ ਅਤੇ ਪੰਜਾਹ ਬੀੜੇ ਦੂਜੇ ਜੋੜ ਦੇ ਪਰਦੇ ਦੀ ਸੰਜਾਫ਼ ਵਿੱਚ ਬਣਾਈਂ। ");
INSERT INTO pan_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","ਅਤੇ ਤੂੰ ਪੰਜਾਹ ਕੁੰਡੀਆਂ ਪਿੱਤਲ ਦੀਆਂ ਬਣਾਈਂ ਅਤੇ ਕੁੰਡੀਆਂ ਬੀੜਿਆਂ ਵਿੱਚ ਪਾ ਦੇਵੀਂ ਅਤੇ ਤੂੰ ਤੰਬੂ ਨੂੰ ਅਜਿਹਾ ਜੋੜੀਂ ਕਿ ਉਹ ਇੱਕ ਹੋ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","ਅਤੇ ਤੰਬੂ ਦਾ ਪੜਦਾ ਜਿਹੜਾ ਬਾਕੀ ਰਹੇ ਅਰਥਾਤ ਉਹ ਅੱਧਾ ਪੜਦਾ ਜਿਹੜਾ ਬਾਕੀ ਹੈ ਉਹ ਡੇਰੇ ਦੇ ਪਿੱਛਲੇ ਪਾਸੇ ਵੱਲ ਲਮਕਦਾ ਰਹੇ। ");
INSERT INTO pan_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","ਅਤੇ ਉਹ ਤੰਬੂ ਦੇ ਪਰਦੇ ਦੀ ਲੰਬਾਈ ਦਾ ਵਾਧਾ ਇਸ ਪਾਸੇ ਦਾ ਇੱਕ ਹੱਥ ਅਤੇ ਉਸ ਪਾਸੇ ਦਾ ਇੱਕ ਹੱਥ ਡੇਰੇ ਦੇ ਦੋਹਾਂ ਪਾਸਿਆਂ ਉੱਤੇ ਢੱਕਣ ਲਈ ਲਮਕਦੇ ਰਹਿਣਗੇ। ");
INSERT INTO pan_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","ਅਤੇ ਤੂੰ ਤੰਬੂ ਲਈ ਛੱਤ੍ਰਿਆਂ ਦੀਆਂ ਲਾਲ ਰੰਗੀਆਂ ਹੋਈਆਂ ਖੱਲਾਂ ਦਾ ਢੱਕਣ ਅਤੇ ਉੱਪਰਲੇ ਲਈ ਸਮੁੰਦਰੀ ਜੀਵ ਦੀਆਂ ਖੱਲਾਂ ਦਾ ਢੱਕਣ ਬਣਾਈਂ। ");
INSERT INTO pan_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","ਤੂੰ ਸ਼ਿੱਟੀਮ ਦੀ ਲੱਕੜੀ ਦੇ ਖੜਵੇਂ ਫੱਟੇ ਡੇਰੇ ਲਈ ਬਣਾਈਂ। ");
INSERT INTO pan_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","ਫੱਟੇ ਦੀ ਲੰਬਾਈ ਦਸ ਹੱਥ ਅਤੇ ਹਰ ਫੱਟੇ ਦੀ ਚੌੜਾਈ ਡੇਢ ਹੱਥ ਹੋਵੇ ");
INSERT INTO pan_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","ਅਤੇ ਹਰ ਫੱਟੇ ਵਿੱਚ ਦੋ ਚੂਲਾਂ ਇੱਕ ਦੂਜੇ ਨੂੰ ਜੋੜਨ ਲਈ ਹੋਣ ਇਸ ਤਰ੍ਹਾਂ ਤੂੰ ਡੇਰੇ ਦੇ ਸਾਰੇ ਫੱਟੇ ਬਣਾਈਂ। ");
INSERT INTO pan_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","ਸੋ ਤੂੰ ਡੇਰੇ ਦੇ ਦੱਖਣ ਵਾਲੇ ਪਾਸੇ ਲਈ ਵੀਹ ਫੱਟੇ ਬਣਾਈਂ ");
INSERT INTO pan_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","ਅਤੇ ਤੂੰ ਚਾਂਦੀ ਦੀਆਂ ਚਾਲ੍ਹੀ ਚੀਥੀਆਂ ਉਨ੍ਹਾਂ ਦੀਆਂ ਵੀਹਾਂ ਫੱਟਿਆਂ ਦੇ ਹੇਠ ਬਣਾਈਂ ਅਰਥਾਤ ਇੱਕ ਫੱਟੇ ਹੇਠ ਦੋ ਚੀਥੀਆਂ ਉਹ ਦੀਆਂ ਦੋਹਾਂ ਚੂਲਾਂ ਲਈ ਬਣਾਈਂ ਅਤੇ ਦੂਜੇ ਫੱਟੇ ਹੇਠ ਦੋ ਚੀਥੀਆਂ ਉਸ ਦੀਆਂ ਦੋਹਾਂ ਚੂਲਾਂ ਲਈ। ");
INSERT INTO pan_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","ਅਤੇ ਡੇਰੇ ਦੇ ਦੂਜੇ ਪਾਸੇ ਲਈ ਉੱਤਰ ਵੱਲ ਵੀਹ ਫੱਟੇ ");
INSERT INTO pan_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","ਅਤੇ ਉਨ੍ਹਾਂ ਦੀਆਂ ਚਾਂਦੀ ਦੀਆਂ ਚਾਲ੍ਹੀ ਚੀਥੀਆਂ ਅਰਥਾਤ ਹਰ ਇੱਕ ਫੱਟੇ ਹੇਠ ਦੋ ਚੀਥੀਆਂ ਅਤੇ ਦੂਜੇ ਫੱਟੇ ਹੇਠ ਦੋ ਚੀਥੀਆਂ। ");
INSERT INTO pan_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","ਪੱਛਮ ਵੱਲ ਡੇਰੇ ਦੇ ਸਿਰੇ ਤੇ ਛੇ ਫੱਟੇ ਬਣਾਈਂ। ");
INSERT INTO pan_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","ਤੂੰ ਦੋ ਫੱਟੇ ਡੇਰੇ ਦੇ ਪਿਛਵਾੜੇ ਦੇ ਖੂੰਜਿਆਂ ਲਈ ਬਣਾਈਂ ");
INSERT INTO pan_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","ਤਾਂ ਜੋ ਉਹ ਹੇਠਾਂ ਦੋਹਰੀਆਂ ਹੋਣ ਅਤੇ ਉਹ ਇਸ ਪਰਕਾਰ ਆਪਣਿਆਂ ਸਿਰਿਆਂ ਤੱਕ ਇੱਕ ਕੜੇ ਨਾਲ ਸਾਬਤ ਰਹਿਣ। ਇਸ ਤਰ੍ਹਾਂ ਉਨ੍ਹਾਂ ਦੋਹਾਂ ਲਈ ਹੋਵੇ ਅਤੇ ਦੋਹਾਂ ਖੂੰਜਿਆਂ ਲਈ ਉਹ ਹੋਣ ");
INSERT INTO pan_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","ਅਤੇ ਉਹ ਅੱਠ ਫੱਟੇ ਹੋਣ ਅਤੇ ਉਨ੍ਹਾਂ ਦੀਆਂ ਚਾਂਦੀ ਦੀਆਂ ਸੋਲਾਂ ਚੀਥੀਆਂ ਹੋਣ ਅਰਥਾਤ ਹਰ ਇੱਕ ਫੱਟੇ ਹੇਠ ਦੋ ਚੀਥੀਆਂ ਅਤੇ ਦੂਜੇ ਫੱਟੇ ਹੇਠ ਵੀ ਦੋ ਚੀਥੀਆਂ। ");
INSERT INTO pan_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","ਅਤੇ ਤੂੰ ਸ਼ਿੱਟੀਮ ਦੀ ਲੱਕੜੀ ਦੇ ਹੋੜੇ ਬਣਾਈਂ। ਡੇਰੇ ਦੇ ਇੱਕ ਪਾਸੇ ਦੇ ਫੱਟਿਆਂ ਲਈ ਪੰਜ ਹੋੜੇ। ");
INSERT INTO pan_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","ਅਤੇ ਡੇਰੇ ਦੇ ਦੂਜੇ ਪਾਸੇ ਦੇ ਫੱਟਿਆਂ ਲਈ ਪੰਜ ਹੋੜੇ ਅਤੇ ਡੇਰੇ ਦੇ ਪਿਛਵਾੜੇ ਦੇ ਲਹਿੰਦੇ ਪਾਸੇ ਦੇ ਫੱਟਿਆਂ ਲਈ ਪੰਜ ਹੋੜੇ ");
INSERT INTO pan_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","ਅਤੇ ਵਿਚਲਾ ਹੋੜਾ ਫੱਟਿਆਂ ਦੇ ਵਿਚਕਾਰੋਂ ਆਰ-ਪਾਰ ਜਾਵੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","ਅਤੇ ਤੂੰ ਫੱਟਿਆਂ ਨੂੰ ਸੋਨੇ ਨਾਲ ਮੜ੍ਹੀਂ ਅਤੇ ਹੋੜਿਆਂ ਦੇ ਥਾਵਾਂ ਲਈ ਸੋਨੇ ਦੇ ਕੜੇ ਬਣਾਈਂ ਅਤੇ ਹੋੜਿਆਂ ਨੂੰ ਸੋਨੇ ਨਾਲ ਮੜ੍ਹੀਂ। ");
INSERT INTO pan_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","ਤੂੰ ਡੇਰੇ ਨੂੰ ਉਸ ਨਮੂਨੇ ਉੱਤੇ ਖੜਾ ਕਰੀਂ ਜਿਹੜਾ ਤੈਨੂੰ ਪਰਬਤ ਉੱਤੇ ਵਿਖਾਇਆ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","ਤੂੰ ਨੀਲੇ, ਬੈਂਗਣੀ, ਕਿਰਮਚੀ ਅਤੇ ਮਹੀਨ ਉਣੇ ਹੋਏ ਕਤਾਨ ਦਾ ਇੱਕ ਪਰਦਾ ਬਣਾਈਂ। ਉਹ ਕਾਰੀਗਰੀ ਦਾ ਕੰਮ ਹੋਵੇ ਅਤੇ ਕਰੂਬੀਆਂ ਨਾਲ ਬਣਾਇਆ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","ਤੂੰ ਉਸ ਨੂੰ ਸ਼ਿੱਟੀਮ ਦੀ ਲੱਕੜੀ ਦੀਆਂ ਸੋਨੇ ਨਾਲ ਮੜ੍ਹੀਆਂ ਹੋਈਆਂ ਚਾਰ ਥੰਮ੍ਹੀਆਂ ਉੱਤੇ ਲਮਕਾਵੀਂ ਅਤੇ ਉਨ੍ਹਾਂ ਦੇ ਕੁੰਡੇ ਸੋਨੇ ਦੇ ਹੋਣ ਅਤੇ ਉਹ ਚਾਂਦੀ ਦੀਆਂ ਚਾਰ ਚੀਥੀਆਂ ਉੱਤੇ ਹੋਣ। ");
INSERT INTO pan_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","ਤੂੰ ਪਰਦੇ ਨੂੰ ਕੁੰਡੀਆਂ ਦੇ ਹੇਠ ਲਮਕਾਵੀਂ ਅਤੇ ਤੂੰ ਉੱਥੇ ਉਸ ਪਰਦੇ ਦੇ ਅੰਦਰ ਸਾਖੀ ਦੇ ਸੰਦੂਕ ਨੂੰ ਲਿਆਵੀਂ ਅਤੇ ਇਹ ਪਰਦਾ ਤੁਹਾਡੇ ਲਈ ਪਵਿੱਤਰ ਸਥਾਨ ਨੂੰ ਅੱਤ ਪਵਿੱਤਰ ਸਥਾਨ ਤੋਂ ਵੱਖਰਾ ਕਰੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","ਤੂੰ ਪ੍ਰਾਸਚਿਤ ਦਾ ਸਰਪੋਸ਼ ਸਾਖੀ ਦੇ ਸੰਦੂਕ ਉੱਤੇ ਅੱਤ ਪਵਿੱਤਰ ਸਥਾਨ ਵਿੱਚ ਰੱਖੀਂ। ");
INSERT INTO pan_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","ਤੂੰ ਮੇਜ਼ ਪਰਦੇ ਦੇ ਬਾਹਰ ਅਤੇ ਮੇਜ਼ ਦੇ ਸਾਹਮਣੇ ਸ਼ਮਾਦਾਨ ਡੇਰੇ ਦੇ ਦੱਖਣ ਦੇ ਪਾਸੇ ਵੱਲ ਰੱਖੀਂ ਅਤੇ ਮੇਜ਼ ਉੱਤਰ ਦੇ ਪਾਸੇ ਵੱਲ। ");
INSERT INTO pan_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","ਤੂੰ ਤੰਬੂ ਦੇ ਦਰਵਾਜ਼ੇ ਲਈ ਇੱਕ ਓਟ ਨੀਲੇ ਬੈਂਗਣੀ ਅਤੇ ਕਿਰਮਚੀ ਰੰਗ ਦੇ ਮਹੀਨ ਉਣੇ ਹੋਏ ਕਤਾਨ ਦੀ ਬਣਾਈਂ। ਇਹ ਕਸੀਦੇਕਾਰ ਦਾ ਕੰਮ ਹੋਵੇ। ");
INSERT INTO pan_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","ਤੂੰ ਪਰਦੇ ਲਈ ਪੰਜ ਥੰਮ੍ਹੀਆਂ ਸ਼ਿੱਟੀਮ ਦੀਆਂ ਬਣਾਈਂ ਅਤੇ ਉਨ੍ਹਾਂ ਨੂੰ ਸੋਨੇ ਨਾਲ ਮੜ੍ਹੀਂ ਅਤੇ ਉਨ੍ਹਾਂ ਦੇ ਕੁੰਡੇ ਸੋਨੇ ਦੇ ਹੋਣ ਅਤੇ ਤੂੰ ਉਨ੍ਹਾਂ ਲਈ ਪੰਜ ਚੀਥੀਆਂ ਪਿੱਤਲ ਦੀਆਂ ਢਾਲੀਂ। ");
INSERT INTO pan_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","ਤੂੰ ਸ਼ਿੱਟੀਮ ਦੀ ਲੱਕੜੀ ਦੀ ਇੱਕ ਜਗਵੇਦੀ ਬਣਾਈਂ, ਉਸ ਦੀ ਲੰਬਾਈ ਪੰਜ ਹੱਥ ਅਤੇ ਚੌੜਾਈ ਵੀ ਪੰਜ ਹੱਥ ਹੋਵੇ। ਉਹ ਜਗਵੇਦੀ ਚੌਰਸ ਹੋਵੇ ਅਤੇ ਉਸ ਦੀ ਉਚਾਈ ਤਿੰਨ ਹੱਥ ਹੋਵੇ। ");
INSERT INTO pan_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","ਤੂੰ ਉਹ ਦੇ ਸਿੰਗ ਉਹ ਦੇ ਚੌਹਾਂ ਖੂੰਜਿਆਂ ਉੱਤੇ ਬਣਾਈਂ। ਉਹ ਦੇ ਸਿੰਗ ਉਸੇ ਤੋਂ ਹੋਣ ਅਤੇ ਤੂੰ ਉਸ ਨੂੰ ਪਿੱਤਲ ਨਾਲ ਮੜ੍ਹੀਂ। ");
INSERT INTO pan_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","ਤੂੰ ਉਹ ਦੀ ਸੁਆਹ ਚੁੱਕਣ ਵਾਲੇ ਤਸਲੇ, ਉਹ ਦੇ ਕੜਛੇ ਅਤੇ ਉਹ ਦੇ ਬਾਟੇ ਅਤੇ ਉਹ ਦੀਆਂ ਤ੍ਰਿਸੂਲੀਆਂ ਅਤੇ ਉਹ ਦੀਆਂ ਅੰਗੀਠੀਆਂ ਬਣਾਈਂ। ");
INSERT INTO pan_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","ਉਸ ਦੇ ਸਾਰੇ ਭਾਂਡੇ ਤੂੰ ਪਿੱਤਲ ਦੇ ਬਣਾਈਂ। ਤੂੰ ਉਹ ਦੇ ਲਈ ਪਿੱਤਲ ਦੀ ਇੱਕ ਜਾਲੀਦਾਰ ਝੰਜਰੀ ਬਣਾਈਂ ਅਤੇ ਤੂੰ ਜਾਲੀ ਉੱਤੇ ਉਹ ਦੇ ਚੌਹਾਂ ਖੂੰਜਿਆਂ ਉੱਤੇ ਚਾਰ ਕੜੇ ਪਿੱਤਲ ਦੇ ਬਣਾਈਂ। ");
INSERT INTO pan_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","ਤੂੰ ਉਹ ਨੂੰ ਜਗਵੇਦੀ ਦੇ ਥੜੇ ਦੇ ਹੇਠ ਰੱਖੀਂ। ਇਸ ਤਰ੍ਹਾਂ ਉਹ ਜਾਲੀ ਜਗਵੇਦੀ ਦੇ ਵਿਚਕਾਰ ਹੋਵੇ। ");
INSERT INTO pan_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","ਤੂੰ ਜਗਵੇਦੀ ਲਈ ਚੋਬਾਂ ਬਣਾਈਂ ਅਰਥਾਤ ਸ਼ਿੱਟੀਮ ਦੀ ਲੱਕੜੀ ਦੀਆਂ ਚੋਬਾਂ ਅਤੇ ਤੂੰ ਉਨ੍ਹਾਂ ਨੂੰ ਪਿੱਤਲ ਨਾਲ ਮੜ੍ਹੀਂ। ");
INSERT INTO pan_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","ਤੂੰ ਉਹ ਦੀਆਂ ਚੋਬਾਂ ਨੂੰ ਕੜਿਆਂ ਵਿੱਚ ਪਾਵੀਂ ਅਤੇ ਉਹ ਚੋਬਾਂ ਜਗਵੇਦੀ ਦੇ ਚੁੱਕਣ ਲਈ ਦੋਹੀਂ ਪਾਸੀਂ ਹੋਣਗੀਆਂ। ");
INSERT INTO pan_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","ਤੂੰ ਉਹ ਨੂੰ ਫੱਟੀਆਂ ਨਾਲ ਖੋਖਲਾ ਬਣਾਈਂ। ਜਿਵੇਂ ਤੈਨੂੰ ਪਰਬਤ ਉੱਤੇ ਦਿਖਾਇਆ ਗਿਆ ਉਸੇ ਤਰ੍ਹਾਂ ਉਹ ਉਸ ਨੂੰ ਬਣਾਉਣ। ");
INSERT INTO pan_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","ਇਸ ਤਰ੍ਹਾਂ ਤੂੰ ਡੇਰੇ ਦਾ ਵਿਹੜਾ ਬਣਾਈਂ - ਦੱਖਣ ਵੱਲ ਦੇ ਪਾਸੇ ਲਈ ਮਹੀਨ ਉਣੀ ਹੋਈ ਕਤਾਨ ਦੀਆਂ ਕਨਾਤਾਂ ਹੋਣ ਅਤੇ ਇੱਕ ਪਾਸੇ ਦੀ ਲੰਬਾਈ ਸੌ ਹੱਥ ਹੋਵੇ। ");
INSERT INTO pan_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","ਅਤੇ ਉਨ੍ਹਾਂ ਦੀਆਂ ਥੰਮ੍ਹੀਆਂ ਵੀਹ ਅਤੇ ਉਨ੍ਹਾਂ ਦੀਆਂ ਵੀਹ ਚੀਥੀਆਂ ਪਿੱਤਲ ਦੀਆਂ ਹੋਣ ਅਤੇ ਥੰਮ੍ਹੀਆਂ ਦੇ ਕੁੰਡੇ ਅਤੇ ਉਨ੍ਹਾਂ ਦੇ ਕੜੇ ਚਾਂਦੀ ਦੇ ਹੋਣ। ");
INSERT INTO pan_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","ਇਸ ਤਰ੍ਹਾਂ ਉੱਤਰ ਦੇ ਪਾਸੇ ਵੱਲ ਸੌ ਹੱਥ ਲੰਮੀਆਂ ਕਨਾਤਾਂ ਹੋਣ ਅਤੇ ਉਨ੍ਹਾਂ ਦੀਆਂ ਥੰਮ੍ਹੀਆਂ ਵੀਹ ਅਤੇ ਉਨ੍ਹਾਂ ਦੀਆਂ ਵੀਹ ਚੀਥੀਆਂ ਪਿੱਤਲ ਦੀਆਂ ਹੋਣ ਅਤੇ ਥੰਮ੍ਹੀਆਂ ਦੇ ਕੁੰਡੇ ਅਤੇ ਉਨ੍ਹਾਂ ਦੇ ਕੜੇ ਚਾਂਦੀ ਦੇ ਹੋਣ। ");
INSERT INTO pan_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","ਵਿਹੜੇ ਦੀ ਚੌੜਾਈ ਲਈ ਲਹਿੰਦੇ ਪਾਸੇ ਵੱਲ ਪੰਜਾਹ ਹੱਥ ਦੀਆਂ ਕਨਾਤਾਂ ਅਤੇ ਉਨ੍ਹਾਂ ਦੀਆਂ ਥੰਮ੍ਹੀਆਂ ਦਸ ਅਤੇ ਚੀਥੀਆਂ ਦਸ ਹੋਣ। ");
INSERT INTO pan_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","ਅਤੇ ਵਿਹੜੇ ਦੀ ਚੌੜਾਈ ਚੜ੍ਹਦੇ ਪਾਸੇ ਵੱਲ ਪੰਜਾਹ ਹੱਥ ਹੋਵੇ ");
INSERT INTO pan_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","ਅਤੇ ਦਰਵਾਜ਼ੇ ਦੇ ਇੱਕ ਪਾਸੇ ਦੀਆਂ ਕਨਾਤਾਂ ਪੰਦਰਾਂ ਹੱਥ ਹੋਣ ਅਤੇ ਉਨ੍ਹਾਂ ਦੀਆਂ ਥੰਮ੍ਹੀਆਂ ਤਿੰਨ ਅਤੇ ਉਨ੍ਹਾਂ ਦੀਆਂ ਚੀਥੀਆਂ ਤਿੰਨ ਹੋਣ ");
INSERT INTO pan_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","ਅਤੇ ਦੂਜੇ ਪਾਸੇ ਦੀਆਂ ਕਨਾਤਾਂ ਪੰਦਰਾਂ ਹੱਥ ਹੋਣ। ਉਨ੍ਹਾਂ ਦੀਆਂ ਥੰਮ੍ਹੀਆਂ ਤਿੰਨ ਅਤੇ ਉਨ੍ਹਾਂ ਦੀਆਂ ਚੀਥੀਆਂ ਤਿੰਨ ਹੋਣ। ");
INSERT INTO pan_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","ਵਿਹੜੇ ਦੇ ਫਾਟਕ ਲਈ ਇੱਕ ਓਟ ਵੀਹ ਹੱਥ ਦੀ ਨੀਲੇ, ਬੈਂਗਣੀ ਅਤੇ ਕਿਰਮਚੀ ਮਹੀਨ ਉਣੇ ਹੋਏ ਕਤਾਨ ਦੀ ਬਣਾਈਂ ਅਤੇ ਇਹ ਕਸੀਦੇਕਾਰ ਦਾ ਕੰਮ ਹੋਵੇ। ਉਨ੍ਹਾਂ ਦੀਆਂ ਥੰਮ੍ਹੀਆਂ ਚਾਰ ਅਤੇ ਉਨ੍ਹਾਂ ਦੀਆਂ ਚੀਥੀਆਂ ਚਾਰ ਹੋਣ। ");
INSERT INTO pan_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","ਅਤੇ ਵਿਹੜੇ ਦੀਆਂ ਸਾਰੀਆਂ ਥੰਮ੍ਹੀਆਂ ਚੁਫ਼ੇਰੇ ਚਾਂਦੀ ਦੀਆਂ ਲਕੀਰਾਂ ਨਾਲ ਸਜਾਈਆਂ ਹੋਈਆਂ ਹੋਣ। ਉਨ੍ਹਾਂ ਦੇ ਕੁੰਡੇ ਚਾਂਦੀ ਦੇ ਅਤੇ ਉਨ੍ਹਾਂ ਦੀਆਂ ਥੰਮ੍ਹੀਆਂ ਪਿੱਤਲ ਦੀਆਂ ਹੋਣ। ");
INSERT INTO pan_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","ਵਿਹੜੇ ਦੀ ਲੰਬਾਈ ਸੌ ਹੱਥ ਅਤੇ ਚੌੜਾਈ ਸਭਨੀਂ ਥਾਈਂ ਪੰਜਾਹ ਹੱਥ ਅਤੇ ਉਸ ਦੀ ਉਚਾਈ ਪੰਜ ਹੱਥ ਮਹੀਨ ਉਣੀ ਹੋਈ ਕਤਾਨ ਦੀ ਹੋਵੇ ਅਤੇ ਉਨ੍ਹਾਂ ਦੀਆਂ ਚੀਥੀਆਂ ਪਿੱਤਲ ਦੀਆਂ ਹੋਣ। ");
INSERT INTO pan_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","ਡੇਰੇ ਦਾ ਸਾਰਾ ਸਮਾਨ ਜਿਹੜਾ ਉਸ ਦੀ ਸਾਰੀ ਉਪਾਸਨਾ ਲਈ ਹੋਵੇ ਅਤੇ ਉਹ ਦੀਆਂ ਸਾਰੀਆਂ ਕੀਲੀਆਂ ਅਤੇ ਵਿਹੜੇ ਦੀਆਂ ਸਾਰੀਆਂ ਕੀਲੀਆਂ ਪਿੱਤਲ ਦੀਆਂ ਹੋਣ। ");
INSERT INTO pan_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","ਤੂੰ ਇਸਰਾਏਲੀਆਂ ਨੂੰ ਹੁਕਮ ਦੇ ਕਿ ਉਹ ਤੇਰੇ ਕੋਲ ਨਪੀੜ ਕੇ ਕੱਢਿਆ ਹੋਇਆ ਜ਼ੈਤੂਨ ਦਾ ਸ਼ੁੱਧ ਤੇਲ ਚਾਨਣ ਲਈ ਲਿਆਉਣ ਤਾਂ ਜੋ ਸ਼ਮਾਦਾਨ ਸਦਾ ਜਗਦਾ ਰਹੇ। ");
INSERT INTO pan_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","ਅਤੇ ਮੰਡਲੀ ਦੇ ਤੰਬੂ ਵਿੱਚ ਉਸ ਪਰਦੇ ਦੇ ਬਾਹਰ ਜਿਹੜਾ ਸਾਖੀ ਦੇ ਅੱਗੇ ਹੈ ਹਾਰੂਨ ਅਤੇ ਉਸ ਦੇ ਪੁੱਤਰ ਉਹ ਨੂੰ ਸ਼ਾਮ ਤੋਂ ਸਵੇਰ ਤੱਕ ਯਹੋਵਾਹ ਅੱਗੇ ਸਜਾ ਕੇ ਰੱਖਣ। ਇਹ ਸਦਾ ਦੀ ਬਿਧੀ ਪੀੜ੍ਹੀਆਂ ਤੱਕ ਇਸਰਾਏਲੀਆਂ ਵੱਲੋਂ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","ਤੂੰ ਆਪਣੇ ਭਰਾ ਹਾਰੂਨ ਅਤੇ ਉਸ ਦੇ ਨਾਲ ਉਸ ਦੇ ਪੁੱਤਰਾਂ ਨੂੰ ਇਸਰਾਏਲੀਆਂ ਵਿੱਚੋਂ ਆਪਣੇ ਕੋਲ ਲਿਆਈਂ ਤਾਂ ਜੋ ਉਹ ਮੇਰੇ ਲਈ ਜਾਜਕਾਈ ਦਾ ਕੰਮ ਕਰਨ ਅਰਥਾਤ ਹਾਰੂਨ ਅਤੇ ਉਸ ਦੇ ਪੁੱਤਰ ਨਾਦਾਬ, ਅਬੀਹੂ, ਅਲਆਜ਼ਾਰ, ਈਥਾਮਾਰ। ");
INSERT INTO pan_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","ਤੂੰ ਆਪਣੇ ਭਰਾ ਹਾਰੂਨ ਲਈ ਪਵਿੱਤਰ ਬਸਤਰ ਪਰਤਾਪ ਅਤੇ ਸੁਹੱਪਣ ਲਈ ਬਣਾਈਂ। ");
INSERT INTO pan_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","ਤੂੰ ਸਾਰੇ ਬੁੱਧਵਾਨਾਂ ਨੂੰ ਜਿਨ੍ਹਾਂ ਵਿੱਚ ਮੈਂ ਬੁੱਧ ਦਾ ਆਤਮਾ ਭਰਿਆ ਹੈ ਆਖੀਂ ਕਿ ਉਹ ਹਾਰੂਨ ਦੇ ਬਸਤ੍ਰ ਉਹ ਦੀ ਪਵਿੱਤਰਤਾਈ ਲਈ ਬਣਾਉਣ ਤਾਂ ਜੋ ਉਹ ਜਾਜਕ ਦਾ ਕੰਮ ਮੇਰੇ ਲਈ ਕਰੇ। ");
INSERT INTO pan_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","ਜਿਹੜੇ ਬਸਤ੍ਰ ਉਹ ਬਣਾਉਣ ਸੋ ਇਹ ਹਨ - ਇੱਕ ਸੀਨੇ ਬੰਦ, ਇੱਕ ਏਫ਼ੋਦ, ਇੱਕ ਚੋਗਾ ਅਤੇ ਇੱਕ ਕੱਢਿਆ ਹੋਇਆ ਕੁੜਤਾ, ਇੱਕ ਅਮਾਮਾ ਅਤੇ ਇੱਕ ਪੇਟੀ ਸੋ ਇਹ ਪਵਿੱਤਰ ਬਸਤ੍ਰ ਤੇਰੇ ਭਰਾ ਹਾਰੂਨ ਅਤੇ ਉਹ ਦੇ ਪੁੱਤਰਾਂ ਲਈ ਬਣਾਉਣ ਤਾਂ ਜੋ ਉਹ ਮੇਰੇ ਲਈ ਜਾਜਕਾਂ ਦਾ ਕੰਮ ਕਰਨ। ");
INSERT INTO pan_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","ਅਤੇ ਉਹ ਸੋਨਾ, ਨੀਲਾ ਬੈਂਗਣੀ, ਅਤੇ ਕਿਰਮਚੀ ਮਹੀਨ ਕਤਾਨ ਲੈਣ। ");
INSERT INTO pan_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","ਉਹ ਏਫ਼ੋਦ ਨੂੰ ਸੋਨੇ, ਅਤੇ ਨੀਲੇ, ਬੈਂਗਣੀ, ਕਿਰਮਚੀ ਮਹੀਨ ਉਣੇ ਹੋਏ ਕਤਾਨ ਦਾ ਬਣਾਉਣ ਅਤੇ ਉਹ ਕਾਰੀਗਰੀ ਦਾ ਕੰਮ ਹੋਵੇ। ");
INSERT INTO pan_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","ਅਤੇ ਦੋਹਾਂ ਮੋਢਿਆਂ ਦੀਆਂ ਕਤਰਾਂ ਉਸ ਦੇ ਦੋਹਾਂ ਸਿਰਿਆਂ ਨੂੰ ਜੋੜ ਦੇਣ ਇਸ ਤਰ੍ਹਾਂ ਉਹ ਜੋੜਿਆ ਜਾਵੇ ");
INSERT INTO pan_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","ਅਤੇ ਕਾਰੀਗਰੀ ਨਾਲ ਕੱਢਿਆ ਹੋਇਆ ਪਟਕਾ ਜਿਹੜਾ ਉਹ ਦੇ ਉੱਤੇ ਹੈ ਜਿਹ ਦੇ ਨਾਲ ਉਹ ਕੱਸਿਆ ਜਾਵੇ ਉਸ ਦੇ ਕੰਮ ਅਨੁਸਾਰ ਉਸੇ ਤੋਂ ਹੋਵੇ ਅਰਥਾਤ ਸੋਨੇ ਅਤੇ ਨੀਲੇ ਬੈਂਗਣੀ ਕਿਰਮਚੀ ਮਹੀਨ ਉਣੇ ਹੋਏ ਕਤਾਨ ਦਾ ਹੋਵੇ। ");
INSERT INTO pan_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","ਤੂੰ ਦੋ ਸੁਲੇਮਾਨੀ ਪੱਥਰ ਲੈ ਕੇ ਉਨ੍ਹਾਂ ਦੇ ਉੱਤੇ ਇਸਰਾਏਲ ਦੇ ਪੁੱਤਰਾਂ ਦੇ ਨਾਮ ਉੱਕਰੀਂ। ");
INSERT INTO pan_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","ਉਨ੍ਹਾਂ ਦੇ ਛੇ ਨਾਮ ਇੱਕ ਪੱਥਰ ਉੱਤੇ ਅਤੇ ਬਾਕੀ ਛੇ ਦੂਜੇ ਪੱਥਰ ਉੱਤੇ ਉਨ੍ਹਾਂ ਦੇ ਜਨਮ ਅਨੁਸਾਰ। ");
INSERT INTO pan_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","ਪੱਥਰਾਂ ਦੀ ਚਿੱਤਰਕਾਰੀ ਦਾ ਕੰਮ ਨਾਲ ਛਾਪ ਦੀ ਉੱਕਰਾਈ ਵਾਂਗੂੰ ਤੂੰ ਉਨ੍ਹਾਂ ਦੋਹਾਂ ਪੱਥਰਾਂ ਨੂੰ ਇਸਰਾਏਲ ਦੇ ਪੁੱਤਰਾਂ ਦੇ ਨਾਮਾਂ ਅਨੁਸਾਰ ਉੱਕਰਾਈਂ ਅਤੇ ਤੂੰ ਉਨ੍ਹਾਂ ਨੂੰ ਸੋਨੇ ਦੇ ਖਾਨਿਆਂ ਵਿੱਚ ਜੜੀਂ। ");
INSERT INTO pan_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","ਤੂੰ ਏਫ਼ੋਦ ਦੇ ਮੋਢਿਆਂ ਦੀਆਂ ਕਤਰਾਂ ਉੱਤੇ ਇਹ ਦੋਵੇਂ ਪੱਥਰ ਰੱਖੀਂ। ਉਹ ਇਸਰਾਏਲ ਦੇ ਪੁੱਤਰਾਂ ਲਈ ਯਾਦਗਿਰੀ ਦੇ ਪੱਥਰ ਹੋਣ। ਇਸ ਤਰ੍ਹਾਂ ਹਾਰੂਨ ਉਨ੍ਹਾਂ ਦੇ ਨਾਮ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਆਪਣੇ ਦੋਹਾਂ ਮੋਢਿਆਂ ਉੱਤੇ ਯਾਦਗਿਰੀ ਲਈ ਲੈ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","ਤੂੰ ਸੋਨੇ ਦੇ ਖ਼ਾਨੇ ਬਣਾਈਂ ");
INSERT INTO pan_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","ਅਤੇ ਖ਼ਾਲਸ ਸੋਨੇ ਦੀਆਂ ਦੋ ਜੰਜ਼ੀਰੀਆਂ ਰੱਸਿਆਂ ਵਾਂਗੂੰ ਗੁੰਦੇ ਹੋਏ ਕੰਮ ਨਾਲ ਬਣਾਈਂ ਅਤੇ ਤੂੰ ਉਹ ਗੁੰਦੀਆਂ ਹੋਈਆਂ ਜੰਜ਼ੀਰੀਆਂ ਨੂੰ ਖ਼ਾਨਿਆਂ ਉੱਤੇ ਕੱਸੀਂ। ");
INSERT INTO pan_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","ਤੂੰ ਇੱਕ ਨਿਆਂ ਦਾ ਸੀਨਾ ਬੰਦ ਕਾਰੀਗਰੀ ਦੀ ਬਣਤ ਦਾ ਬਣਾਈਂ। ਏਫ਼ੋਦ ਦੇ ਕੰਮ ਵਾਂਗੂੰ ਉਹ ਨੂੰ ਬਣਾਈਂ ਅਰਥਾਤ ਸੋਨੇ ਅਤੇ ਨੀਲੇ, ਬੈਂਗਣੀ, ਕਿਰਮਚੀ ਮਹੀਨ ਉਣੇ ਹੋਏ ਕਤਾਨ ਦਾ ਉਹ ਨੂੰ ਬਣਾਈਂ। ");
INSERT INTO pan_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","ਉਹ ਚੌਰਸ ਅਤੇ ਦੋਹਰਾ ਹੋਵੇ। ਉਸ ਦੀ ਲੰਬਾਈ ਇੱਕ ਗਿੱਠ ਅਤੇ ਉਸ ਦੀ ਚੌੜਾਈ ਇੱਕ ਗਿੱਠ ਹੋਵੇ। ");
INSERT INTO pan_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","ਤੂੰ ਉਸ ਵਿੱਚ ਪੱਥਰਾਂ ਲਈ ਖ਼ਾਨੇ ਰੱਖੀਂ ਅਤੇ ਪੱਥਰਾਂ ਦੀਆਂ ਚਾਰ ਪਾਲਾਂ ਜੜੀਂ। ਇੱਕ ਪਾਲ ਵਿੱਚ ਲਾਲ ਅਕੀਕ, ਸੁਨਹਿਲਾ ਅਤੇ ਜ਼ਬਰਜਦ, ਅਰਥਾਤ ਇਹ ਪਹਿਲੀ ਪਾਲ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","ਦੂਜੀ ਪਾਲ ਵਿੱਚ ਪੰਨਾ, ਨੀਲਮ, ਦੁਧੀਯਾ ਬਿਲੌਰ ");
INSERT INTO pan_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","ਤੀਜੀ ਪਾਲ ਵਿੱਚ ਜ਼ਕਰਨ, ਹਰੀ ਅਕੀਕ, ਕਟੈਹਿਲਾ। ");
INSERT INTO pan_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","ਚੌਥੀ ਪਾਲ ਵਿੱਚ ਬੈਰੂਜ਼, ਸੁਲੇਮਾਨੀ ਅਤੇ ਯਸ਼ਬ। ਇਹ ਆਪੋ ਆਪਣੇ ਖ਼ਾਨਿਆਂ ਵਿੱਚ ਸੋਨੇ ਨਾਲ ਜੜੇ ਜਾਣ। ");
INSERT INTO pan_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","ਉਹ ਪੱਥਰ ਇਸਰਾਏਲ ਦੇ ਪੁੱਤਰਾਂ ਦੇ ਨਾਮਾਂ ਅਨੁਸਾਰ ਹੋਣਗੇ ਅਰਥਾਤ ਉਨ੍ਹਾਂ ਦੇ ਬਾਰਾਂ ਨਾਮਾਂ ਦੇ ਅਨੁਸਾਰ ਛਾਪ ਦੀ ਉੱਕਰਾਈ ਵਾਂਗੂੰ ਹਰ ਇੱਕ ਦੇ ਨਾਮ ਦੇ ਅਨੁਸਾਰ ਉਹ ਬਾਰਾਂ ਗੋਤਾਂ ਲਈ ਹੋਣਗੇ। ");
INSERT INTO pan_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","ਤੂੰ ਸੀਨੇ ਬੰਦ ਉੱਤੇ ਖ਼ਾਲਸ ਸੋਨੇ ਦੀ ਜੰਜ਼ੀਰੀ ਰੱਸਿਆਂ ਵਾਂਗੂੰ ਗੁੰਦੇ ਹੋਏ ਕੰਮ ਦੀ ਬਣਾਈਂ ");
INSERT INTO pan_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","ਅਤੇ ਤੂੰ ਸੀਨੇ ਬੰਦ ਉੱਤੇ ਸੋਨੇ ਦੇ ਦੋ ਕੜੇ ਬਣਾਈਂ ਅਤੇ ਤੂੰ ਦੋਨੋਂ ਕੜੇ ਸੀਨੇ ਬੰਦ ਦੇ ਦੋਹਾਂ ਸਿਰਿਆਂ ਵਿੱਚ ਪਾਵੀਂ। ");
INSERT INTO pan_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","ਤੂੰ ਉਨ੍ਹਾਂ ਦੋਹਾਂ ਗੁੰਦੀਆਂ ਹੋਈਆਂ ਸੋਨੇ ਦੀਆਂ ਜੰਜ਼ੀਰੀਆਂ ਨੂੰ ਸੀਨੇ ਬੰਦ ਦੇ ਸਿਰਿਆਂ ਉੱਤੇ ਉਨ੍ਹਾਂ ਦੋਹਾਂ ਕੜਿਆਂ ਵਿੱਚ ਪਾਵੀਂ। ");
INSERT INTO pan_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","ਅਤੇ ਦੂਜੇ ਦੋਵੇਂ ਸਿਰੇ ਗੁੰਦੀਆਂ ਹੋਈਆਂ ਜੰਜ਼ੀਰੀਆਂ ਦੇ ਉਨ੍ਹਾਂ ਦੋਹਾਂ ਖ਼ਾਨਿਆਂ ਵਿੱਚ ਕੱਸੀਂ ਅਤੇ ਤੂੰ ਉਨ੍ਹਾਂ ਨੂੰ ਏਫ਼ੋਦ ਦੇ ਮੋਢਿਆਂ ਦੀਆਂ ਕਤਰਾਂ ਉੱਤੇ ਅਗਲੇ ਪਾਸੇ ਰੱਖੀਂ। ");
INSERT INTO pan_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","ਤੂੰ ਸੋਨੇ ਦੇ ਦੋ ਕੜੇ ਬਣਾਈਂ ਅਤੇ ਉਨ੍ਹਾਂ ਨੂੰ ਸੀਨੇ ਬੰਦ ਦੇ ਦੋਹਾਂ ਸਿਰਿਆਂ ਵਿੱਚ ਪਾਵੀਂ ਜਿਹੜੇ ਏਫ਼ੋਦ ਦੀ ਕਿਨਾਰੀ ਦੇ ਅੰਦਰਲੇ ਪਾਸੇ ਹਨ। ");
INSERT INTO pan_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","ਤਾਂ ਤੂੰ ਸੋਨੇ ਦੇ ਦੋ ਹੋਰ ਕੜੇ ਬਣਾਈਂ ਅਤੇ ਤੂੰ ਉਨ੍ਹਾਂ ਨੂੰ ਏਫ਼ੋਦ ਦੇ ਦੋਹਾਂ ਮੋਢਿਆਂ ਦੀਆਂ ਕਤਰਾਂ ਉੱਤੇ ਅਗਲੇ ਪਾਸੇ ਹੇਠਲੀ ਵੱਲ ਸੀਣ ਦੇ ਨੇੜੇ ਏਫ਼ੋਦ ਦੇ ਕਾਰੀਗਰੀ ਨਾਲ ਕੱਢੇ ਹੋਏ ਪਟਕੇ ਦੇ ਉੱਤੇ ਰੱਖੀਂ ");
INSERT INTO pan_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","ਤਾਂ ਜੋ ਸੀਨੇ ਬੰਦ ਨੂੰ ਉਸ ਦੇ ਕੜਿਆਂ ਨਾਲ ਏਫ਼ੋਦ ਦੇ ਕੜਿਆਂ ਵਿੱਚ ਨੀਲੇ ਰੰਗ ਦੀ ਰੱਸੀ ਨਾਲ ਉਹ ਅਜਿਹਾ ਬੰਨ੍ਹਣ ਕਿ ਉਹ ਏਫ਼ੋਦ ਦੇ ਕਾਰੀਗਰੀ ਨਾਲ ਕੱਢੇ ਹੋਏ ਪਟਕੇ ਉੱਤੇ ਰਹੇ ਅਤੇ ਸੀਨਾ ਬੰਦ ਏਫ਼ੋਦ ਦੇ ਉੱਤੋਂ ਨਾ ਖੁਲ੍ਹੇ। ");
INSERT INTO pan_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","ਇਸ ਤਰ੍ਹਾਂ ਹਾਰੂਨ ਇਸਰਾਏਲ ਦੇ ਪੁੱਤਰਾਂ ਦੇ ਨਾਮ ਨਿਆਂ ਦੇ ਸੀਨੇ ਬੰਦ ਵਿੱਚ ਆਪਣੇ ਹਿਰਦੇ ਉੱਤੇ ਚੁੱਕੇ ਜਦ ਉਹ ਪਵਿੱਤਰ ਸਥਾਨ ਵਿੱਚ ਜਾਵੇ ਤਾਂ ਜੋ ਯਹੋਵਾਹ ਦੇ ਸਨਮੁਖ ਇਹ ਸਦਾ ਦੀ ਯਾਦਗਿਰੀ ਹੋਵੇ। ");
INSERT INTO pan_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","ਤੂੰ ਨਿਆਂ ਦੇ ਸੀਨੇ ਬੰਦ ਵਿੱਚ ਊਰੀਮ ਅਤੇ ਤੁੰਮੀਮ ਪਾਵੀਂ ਅਤੇ ਇਸ ਤਰ੍ਹਾਂ ਉਹ ਹਾਰੂਨ ਦੇ ਹਿਰਦੇ ਉੱਤੇ ਹੋਣ ਜਦ ਉਹ ਯਹੋਵਾਹ ਦੇ ਸਨਮੁਖ ਜਾਵੇ ਅਤੇ ਹਾਰੂਨ ਇਸਰਾਏਲ ਦੇ ਪੁੱਤਰਾਂ ਦਾ ਨਿਆਂ ਆਪਣੇ ਹਿਰਦੇ ਉੱਤੇ ਯਹੋਵਾਹ ਦੇ ਸਨਮੁਖ ਸਦਾ ਲਈ ਚੁੱਕੇ। ");
INSERT INTO pan_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","ਤੂੰ ਏਫ਼ੋਦ ਦੇ ਚੋਗੇ ਨੂੰ ਸਾਰਾ ਨੀਲੇ ਰੰਗ ਦਾ ਬਣਾਈਂ ");
INSERT INTO pan_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","ਅਤੇ ਉਹ ਦੇ ਵਿਚਕਾਰ ਉਸ ਦੇ ਸਿਰ ਲਈ ਛੇਕ ਹੋਵੇ ਅਤੇ ਛੇਕ ਦੇ ਚੁਫ਼ੇਰੇ ਇੱਕ ਉਣੀ ਹੋਈ ਕੋਰ ਹੋਵੇ ਸੰਜੋ ਦੇ ਛੇਕ ਵਰਗੀ ਤਾਂ ਜੋ ਉਹ ਨਾ ਪਾਟੇ। ");
INSERT INTO pan_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","ਤੂੰ ਉਸ ਦੇ ਪੱਲੇ ਦੇ ਘੇਰੇ ਉੱਤੇ ਨੀਲੇ, ਬੈਂਗਣੀ, ਅਤੇ ਕਿਰਮਚੀ ਕਤਾਨ ਦੇ ਅਨਾਰ ਬਣਾਈਂ ਅਤੇ ਉਨ੍ਹਾਂ ਦੇ ਵਿਚਕਾਰ ਅਤੇ ਆਲੇ-ਦੁਆਲੇ ਸੋਨੇ ਦੇ ਘੁੰਗਰੂ ਪਾਵੀਂ ");
INSERT INTO pan_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","ਅਰਥਾਤ ਸੋਨੇ ਦਾ ਘੁੰਗਰੂ ਅਤੇ ਇੱਕ ਅਨਾਰ ਅਤੇ ਸੋਨੇ ਦਾ ਘੁੰਗਰੂ ਅਤੇ ਇੱਕ ਅਨਾਰ ਚੋਗੇ ਦੇ ਪੱਲੇ ਦੇ ਘੇਰੇ ਉੱਤੇ ਹੋਣ। ");
INSERT INTO pan_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","ਉਹ ਹਾਰੂਨ ਉੱਤੇ ਉਪਾਸਨਾ ਲਈ ਹੋਵੇ ਅਤੇ ਉਨ੍ਹਾਂ ਦੀ ਅਵਾਜ਼ ਸੁਣਾਈ ਦੇਵੇ ਜਦ ਉਹ ਯਹੋਵਾਹ ਦੇ ਪਵਿੱਤਰ ਸਥਾਨ ਵਿੱਚ ਵੜੇ ਜਾਂ ਨਿੱਕਲੇ ਤਾਂ ਜੋ ਉਹ ਮਰ ਨਾ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","ਤੂੰ ਖ਼ਾਲਸ ਸੋਨੇ ਦਾ ਇੱਕ ਚਮਕੀਲਾ ਪੱਤਰ ਬਣਾਈਂ ਅਤੇ ਉਹ ਦੇ ਉੱਤੇ ਲਿਖਤ ਛਾਪ ਦੀ ਉੱਕਰਾਈ ਵਰਗਾ ਇਹ ਉੱਕਰੀਂ “ਯਹੋਵਾਹ ਲਈ ਪਵਿੱਤਰਤਾਈ” ");
INSERT INTO pan_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","ਤੂੰ ਉਹ ਦੇ ਵਿੱਚ ਨੀਲੀ ਡੋਰ ਪਾਵੀਂ ਅਤੇ ਉਹ ਅਮਾਮੇ ਉੱਤੇ ਹੋਵੇ ਅਰਥਾਤ ਅਮਾਮੇ ਦੇ ਅਗਲੇ ਪਾਸੇ ਉੱਤੇ। ");
INSERT INTO pan_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","ਇਸ ਤਰ੍ਹਾਂ ਉਹ ਹਾਰੂਨ ਦੇ ਮਸਤਕ ਉੱਤੇ ਹੋਵੇ ਤਾਂ ਜੋ ਹਾਰੂਨ ਪਵਿੱਤਰ ਵਸਤਾਂ ਦੇ ਦੋਸ਼ ਨੂੰ ਚੁੱਕੇ ਜਿਹੜੀਆਂ ਇਸਰਾਏਲ ਪਵਿੱਤਰ ਕਰਨ ਅਰਥਾਤ ਉਨ੍ਹਾਂ ਦੇ ਸਾਰੇ ਪਵਿੱਤਰ ਪੁੰਨ ਦਾਨ, ਅਤੇ ਉਹ ਉਸ ਦੇ ਮਸਤਕ ਉੱਤੇ ਸਦਾ ਲਈ ਹੋਵੇ ਤਾਂ ਜੋ ਯਹੋਵਾਹ ਦੇ ਸਨਮੁਖ ਉਨ੍ਹਾਂ ਦੀ ਮਨਜ਼ੂਰੀ ਹੋਵੇ। ");
INSERT INTO pan_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","ਤੂੰ ਮਹੀਨ ਕਤਾਨ ਦਾ ਕੁੜਤਾ ਕੱਢੀਂ ਅਤੇ ਤੂੰ ਮਹੀਨ ਕਤਾਨ ਦਾ ਅਮਾਮਾ ਬਣਾਈਂ ਅਤੇ ਇੱਕ ਪੇਟੀ ਕਸੀਦੇਕਾਰ ਦੇ ਕੰਮ ਦੀ ਬਣਾਈਂ। ");
INSERT INTO pan_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","ਤੂੰ ਹਾਰੂਨ ਦੇ ਪੁੱਤਰਾਂ ਲਈ ਕੁੜਤੇ ਬਣਾਈਂ ਅਤੇ ਤੂੰ ਉਨ੍ਹਾਂ ਦੇ ਲਈ ਪੇਟੀਆਂ ਬਣਾਈਂ ਨਾਲੇ ਤੂੰ ਉਨ੍ਹਾਂ ਲਈ ਪਰਤਾਪ ਅਤੇ ਸੁਹੱਪਣ ਦੇ ਸਾਫ਼ੇ ਬਣਾਈਂ ");
INSERT INTO pan_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","ਅਤੇ ਤੂੰ ਆਪਣੇ ਭਰਾ ਹਾਰੂਨ ਅਤੇ ਉਹ ਦੇ ਨਾਲ ਉਹ ਦੇ ਪੁੱਤਰਾਂ ਨੂੰ ਇਹ ਪਵਾਈਂ ਅਤੇ ਤੂੰ ਉਨ੍ਹਾਂ ਨੂੰ ਮਸਹ ਕਰੀਂ ਅਤੇ ਉਨ੍ਹਾਂ ਨੂੰ ਥਾਪੀਂ ਅਤੇ ਉਨ੍ਹਾਂ ਨੂੰ ਪਵਿੱਤਰ ਕਰੀਂ ਤਾਂ ਜੋ ਉਹ ਮੇਰੇ ਲਈ ਜਾਜਕਾਈ ਦਾ ਕੰਮ ਕਰਨ। ");
INSERT INTO pan_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","ਤੂੰ ਉਨ੍ਹਾਂ ਲਈ ਕਤਾਨ ਦੀ ਕੱਛ ਉਨ੍ਹਾਂ ਦੇ ਨੰਗੇਜ਼ ਦੇ ਕੱਜਣ ਲਈ ਬਣਾਈਂ। ਉਹ ਲੱਕ ਤੋਂ ਪੱਟਾਂ ਤੱਕ ਹੋਵੇ ");
INSERT INTO pan_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","ਅਤੇ ਉਹ ਹਾਰੂਨ ਅਤੇ ਉਹ ਦੇ ਪੁੱਤਰਾਂ ਉੱਤੇ ਹੋਵੇ ਜਦ ਉਹ ਮੰਡਲੀ ਦੇ ਤੰਬੂ ਵਿੱਚ ਵੜਨ ਜਾਂ ਜਗਵੇਦੀ ਕੋਲ ਜਾਣ ਕਿ ਉਹ ਪਵਿੱਤਰ ਸਥਾਨ ਵਿੱਚ ਉਪਾਸਨਾ ਕਰਨ ਅਜਿਹਾ ਨਾ ਹੋਵੇ ਕਿ ਉਹ ਅਪਰਾਧੀ ਹੋ ਕੇ ਮਰਨ। ਇਹ ਉਹ ਦੇ ਲਈ ਅਤੇ ਉਹ ਦੇ ਪਿੱਛੋਂ ਉਹ ਦੀ ਅੰਸ ਲਈ ਸਦਾ ਦੀ ਬਿਧੀ ਹੋਵੇ। ");
INSERT INTO pan_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","ਉਹ ਗੱਲ ਜਿਹੜੀ ਤੂੰ ਉਨ੍ਹਾਂ ਦੇ ਪਵਿੱਤਰ ਕਰਨ ਲਈ ਕਰੇਂ ਕਿ ਉਹ ਜਾਜਕਾਈ ਦੀ ਮੇਰੀ ਉਪਾਸਨਾ ਕਰਨ ਇਹ ਹੈ ਕਿ ਇੱਕ ਭੇਡੂ ਅਤੇ ਦੋ ਛੱਤਰੇ ਬੱਜ ਤੋਂ ਬਿਨ੍ਹਾਂ ਲਵੀਂ ");
INSERT INTO pan_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","ਅਤੇ ਪਤੀਰੀ ਰੋਟੀ ਅਤੇ ਤੇਲ ਵਿੱਚ ਮਥੇ ਹੋਏ ਪਤੀਰੇ ਪਰਾਉਂਠੇ ਅਤੇ ਤੇਲ ਨਾਲ ਚੋਪੜੇ ਹੋਏ ਪੂੜੇ ਕਣਕ ਦੇ ਮੈਦੇ ਤੋਂ ਬਣਾਈਂ ");
INSERT INTO pan_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","ਅਤੇ ਉਨ੍ਹਾਂ ਨੂੰ ਇੱਕ ਛਾਬੇ ਵਿੱਚ ਪਾਵੀਂ ਅਤੇ ਉਨ੍ਹਾਂ ਨੂੰ ਛਾਬੇ ਵਿੱਚ ਬਲ਼ਦ ਅਤੇ ਦੋਹਾਂ ਭੇਡੂਆਂ ਨਾਲ ਨੇੜੇ ਲਿਆਵੀਂ। ");
INSERT INTO pan_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","ਹਾਰੂਨ ਅਤੇ ਉਸ ਦੇ ਪੁੱਤਰਾਂ ਨੂੰ ਮੰਡਲੀ ਦੇ ਤੰਬੂ ਦੇ ਦਰਵਾਜ਼ੇ ਦੇ ਨੇੜੇ ਲਿਆਈਂ ਅਤੇ ਉਨ੍ਹਾਂ ਨੂੰ ਪਾਣੀ ਨਾਲ ਨਹਲਾਈਂ। ");
INSERT INTO pan_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","ਤੂੰ ਬਸਤਰ ਲੈ ਕੇ ਹਾਰੂਨ ਨੂੰ ਕੁੜਤਾ ਅਤੇ ਏਫ਼ੋਦ ਦਾ ਚੋਗਾ ਅਤੇ ਏਫ਼ੋਦ ਅਤੇ ਸੀਨਾ ਬੰਦ ਪਹਿਨਾਈਂ ਅਤੇ ਏਫ਼ੋਦ ਦੇ ਕਾਰੀਗਰੀ ਨਾਲ ਕੱਢੇ ਹੋਏ ਪਟਕੇ ਨਾਲ ਉਹ ਦਾ ਲੱਕ ਬੰਨ੍ਹੀਂ। ");
INSERT INTO pan_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","ਤੂੰ ਉਸ ਦੇ ਸਿਰ ਉੱਤੇ ਪਗੜੀ ਰੱਖੀਂ ਅਤੇ ਪਵਿੱਤਰ ਮੁਕਟ ਪਗੜੀ ਦੇ ਉੱਤੇ ਰੱਖੀਂ। ");
INSERT INTO pan_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","ਫੇਰ ਤੂੰ ਮਸਹ ਕਰਨ ਦਾ ਤੇਲ ਲੈ ਕੇ ਉਸ ਦੇ ਸਿਰ ਉੱਤੇ ਚੋਵੀਂ ਅਤੇ ਇਸ ਤਰ੍ਹਾਂ ਤੂੰ ਉਹ ਨੂੰ ਮਸਹ ਕਰੀਂ। ");
INSERT INTO pan_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","ਫਿਰ ਉਸ ਦੇ ਪੁੱਤਰਾਂ ਨੂੰ ਨੇੜੇ ਲਿਆਈਂ ਅਤੇ ਉਨ੍ਹਾਂ ਨੂੰ ਕੁੜਤੇ ਪਹਿਨਾਈਂ। ");
INSERT INTO pan_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","ਤੂੰ ਹਾਰੂਨ ਅਤੇ ਉਹ ਦੇ ਪੁੱਤਰਾਂ ਦੇ ਲੱਕ ਪੇਟੀਆਂ ਨਾਲ ਬੰਨ੍ਹੀਂ ਅਤੇ ਉਨ੍ਹਾਂ ਨੂੰ ਪੱਗੜੀਆਂ ਬੰਨ੍ਹੀਂ ਅਤੇ ਜਾਜਕਪੁਣਾ ਉਨ੍ਹਾਂ ਲਈ ਸਦਾ ਦੀ ਬਿਧੀ ਅਨੁਸਾਰ ਹੋਵੇਗਾ ਅਤੇ ਇਸ ਤਰ੍ਹਾਂ ਤੂੰ ਹਾਰੂਨ ਅਤੇ ਉਸ ਦੇ ਪੁੱਤਰਾਂ ਨੂੰ ਥਾਪੀਂ। ");
INSERT INTO pan_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","ਮੰਡਲੀ ਦੇ ਤੰਬੂ ਦੇ ਅੱਗੇ ਤੂੰ ਬਲ਼ਦ ਨੂੰ ਨੇੜੇ ਲਿਆਵੀਂ ਅਤੇ ਹਾਰੂਨ ਅਤੇ ਉਸ ਦੇ ਪੁੱਤਰ ਆਪਣੇ ਹੱਥ ਬਲ਼ਦ ਦੇ ਸਿਰ ਉੱਤੇ ਰੱਖਣ। ");
INSERT INTO pan_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","ਫਿਰ ਤੂੰ ਉਸ ਬਲ਼ਦ ਨੂੰ ਮੰਡਲੀ ਦੇ ਤੰਬੂ ਦੇ ਦਰਵਾਜ਼ੇ ਕੋਲ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਵੱਢ ਸੁੱਟੀਂ। ");
INSERT INTO pan_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","ਤੂੰ ਵਹਿੜੇ ਦਾ ਲਹੂ ਲੈ ਕੇ ਜਗਵੇਦੀ ਦੇ ਸਿੰਗਾਂ ਉੱਤੇ ਆਪਣੀ ਉਂਗਲ ਨਾਲ ਲਾਈਂ ਅਤੇ ਬਾਕੀ ਦਾ ਲਹੂ ਜਗਵੇਦੀ ਦੀ ਨੀਂਹ ਉੱਤੇ ਡੋਲ੍ਹ ਦੇਈਂ। ");
INSERT INTO pan_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","ਤੂੰ ਸਾਰੀ ਚਰਬੀ ਜਿਹੜੀ ਆਂਦਰਾਂ ਨੂੰ ਢੱਕਦੀ ਹੈ ਅਤੇ ਕਲੇਜੀ ਦੇ ਉੱਪਰਲੀ ਝਿੱਲੀ ਅਤੇ ਦੋਹਾਂ ਗੁਰਦਿਆਂ ਨੂੰ ਅਤੇ ਚਰਬੀ ਨੂੰ ਜਿਹੜੀ ਉਨ੍ਹਾਂ ਦੇ ਉੱਤੇ ਹੈ ਲੈ ਕੇ ਜਗਵੇਦੀ ਉੱਤੇ ਸਾੜ ਸੁੱਟੀਂ ");
INSERT INTO pan_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","ਪਰ ਬਲ਼ਦ ਦਾ ਮਾਸ ਅਤੇ ਉਸ ਦੀ ਖੱਲ ਅਤੇ ਗੋਹੇ ਨੂੰ ਡੇਰੇ ਤੋਂ ਬਾਹਰ ਅੱਗ ਨਾਲ ਸਾੜ ਦੇਈਂ। ਇਹ ਪਾਪ ਬਲੀ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","ਤੂੰ ਇੱਕ ਛੱਤਰਾ ਲਵੀਂ ਅਤੇ ਹਾਰੂਨ ਅਤੇ ਉਸ ਦੇ ਪੁੱਤਰ ਆਪਣੇ ਹੱਥ ਭੇਡੂ ਦੇ ਸਿਰ ਉੱਤੇ ਰੱਖਣ। ");
INSERT INTO pan_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","ਤੂੰ ਉਸ ਛੱਤਰੇ ਨੂੰ ਕੱਟ ਸੁੱਟੀਂ ਅਤੇ ਉਸ ਦਾ ਲਹੂ ਲੈ ਕੇ ਜਗਵੇਦੀ ਦੇ ਚੁਫ਼ੇਰੇ ਛਿੜਕ ਦੇਈਂ। ");
INSERT INTO pan_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","ਫੇਰ ਤੂੰ ਉਸ ਛੱਤਰੇ ਨੂੰ ਟੁੱਕੜੇ-ਟੁੱਕੜੇ ਕਰੀਂ ਅਤੇ ਉਸ ਦੀਆਂ ਆਂਦਰਾਂ ਅਤੇ ਉਸ ਦੀਆਂ ਲੱਤਾਂ ਧੋ ਕੇ ਉਨ੍ਹਾਂ ਨੂੰ ਉਸ ਦਿਆਂ ਟੋਟਿਆਂ ਅਤੇ ਸਿਰ ਉੱਤੇ ਰੱਖੀਂ। ");
INSERT INTO pan_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","ਸੋ ਤੂੰ ਸਾਰੇ ਛੱਤਰੇ ਨੂੰ ਜਗਵੇਦੀ ਉੱਤੇ ਸਾੜ ਸੁੱਟੀਂ। ਉਹ ਯਹੋਵਾਹ ਲਈ ਹੋਮ ਬਲੀ ਹੈ। ਇਹ ਇੱਕ ਸੁਗੰਧਤਾ ਹੈ। ਇਹ ਯਹੋਵਾਹ ਲਈ ਅੱਗ ਦੀ ਭੇਟ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","ਤੂੰ ਦੂਜਾ ਛੱਤਰਾ ਲਈਂ ਅਤੇ ਹਾਰੂਨ ਅਤੇ ਉਸ ਦੇ ਪੁੱਤਰ ਆਪਣੇ ਹੱਥ ਉਸ ਛੱਤਰੇ ਦੇ ਸਿਰ ਉੱਤੇ ਰੱਖਣ। ");
INSERT INTO pan_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","ਤੂੰ ਉਸ ਛੱਤਰੇ ਨੂੰ ਵੱਢ ਸੁੱਟੀਂ ਅਤੇ ਉਸ ਦੇ ਲਹੂ ਵਿੱਚੋਂ ਲੈ ਕੇ ਹਾਰੂਨ ਦੇ ਸੱਜੇ ਕੰਨ ਦੇ ਸਿਰੇ ਉੱਤੇ ਅਤੇ ਉਸ ਦੇ ਪੁੱਤਰਾਂ ਦੇ ਸੱਜੇ ਕੰਨਾਂ ਦੇ ਸਿਰਿਆਂ ਉੱਤੇ ਅਤੇ ਉਨ੍ਹਾਂ ਦੇ ਸੱਜੇ ਹੱਥਾਂ ਦੇ ਅੰਗੂਠਿਆਂ ਉੱਤੇ ਲਾਈਂ ਅਤੇ ਤੂੰ ਲਹੂ ਜਗਵੇਦੀ ਦੇ ਉੱਤੇ ਆਲੇ-ਦੁਆਲੇ ਛਿੜਕ ਦੇਈਂ। ");
INSERT INTO pan_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","ਜਿਹੜਾ ਲਹੂ ਜਗਵੇਦੀ ਉੱਤੇ ਹੈ ਤੂੰ ਉਸ ਵਿੱਚੋਂ ਅਤੇ ਮਸਹ ਕਰਨ ਦੇ ਤੇਲ ਵਿੱਚੋਂ ਲੈ ਕੇ ਹਾਰੂਨ ਅਤੇ ਉਸ ਦੇ ਬਸਤ੍ਰ ਉੱਤੇ ਅਤੇ ਉਸ ਦੇ ਪੁੱਤਰਾਂ ਉੱਤੇ ਅਤੇ ਉਸ ਦੇ ਨਾਲ ਉਸ ਦੇ ਪੁੱਤਰਾਂ ਦੇ ਬਸਤ੍ਰਾਂ ਉੱਤੇ ਛਿੜਕੀਂ ਅਤੇ ਇਸ ਤਰ੍ਹਾਂ ਉਹ ਅਤੇ ਉਸ ਦਾ ਬਸਤ੍ਰ ਅਤੇ ਉਸ ਦੇ ਪੁੱਤਰ ਅਤੇ ਉਸ ਦੇ ਨਾਲ ਉਸ ਦੇ ਪੁੱਤਰਾਂ ਦੇ ਬਸਤ੍ਰ ਪਵਿੱਤਰ ਕੀਤੇ ਜਾਣ। ");
INSERT INTO pan_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","ਤੂੰ ਛੱਤਰੇ ਦੀ ਚਰਬੀ ਅਤੇ ਉਸ ਦੀ ਪੂਛ ਅਤੇ ਚਰਬੀ ਜਿਹੜੀ ਆਂਦਰਾਂ ਨੂੰ ਢੱਕਦੀ ਹੈ ਅਤੇ ਕਲੇਜੀ ਦੀ ਉੱਪਰਲੀ ਝਿੱਲੀ ਅਤੇ ਦੋਵੇਂ ਗੁਰਦੇ ਨਾਲੇ ਉਹ ਚਰਬੀ ਜਿਹੜੀ ਉਨ੍ਹਾਂ ਦੇ ਉੱਤੇ ਹੈ ਅਤੇ ਸੱਜਾ ਪੱਟ ਲਈਂ ਕਿਉਂਕਿ ਉਹ ਛੱਤਰਾ ਥਾਪਨਾ ਦਾ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","ਤੂੰ ਇੱਕ ਰੋਟੀ ਇੱਕ ਪਰਾਉਂਠਾ ਇੱਕ ਪੂੜਾ ਉਸ ਦੀ ਪਤੀਰੀ ਰੋਟੀ ਦੀ ਟੋਕਰੀ ਵਿੱਚੋਂ ਜਿਹੜੀ ਯਹੋਵਾਹ ਦੇ ਸਨਮੁਖ ਹੈ ਲਈਂ। ");
INSERT INTO pan_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","ਤੂੰ ਸਭਨਾਂ ਨੂੰ ਹਾਰੂਨ ਦੇ ਹੱਥਾਂ ਉੱਤੇ ਅਤੇ ਉਸ ਦੇ ਪੁੱਤਰਾਂ ਦੇ ਹੱਥਾਂ ਉੱਤੇ ਰੱਖੀਂ ਅਤੇ ਤੂੰ ਉਨ੍ਹਾਂ ਨੂੰ ਹਿਲਾਉਣ ਦੀ ਭੇਟ ਕਰਕੇ ਯਹੋਵਾਹ ਲਈ ਹਿਲਾਵੀਂ। ");
INSERT INTO pan_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","ਫਿਰ ਤੂੰ ਉਨ੍ਹਾਂ ਨੂੰ ਉਨ੍ਹਾਂ ਦੇ ਹੱਥੋਂ ਲੈ ਕੇ ਜਗਵੇਦੀ ਉੱਤੇ ਹੋਮ ਦੀ ਬਲੀ ਉੱਤੇ ਸਾੜ ਦੇਈਂ। ਇਹ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਇੱਕ ਸੁਗੰਧਤਾ ਹੈ ਅਤੇ ਯਹੋਵਾਹ ਲਈ ਇੱਕ ਅੱਗ ਦੀ ਭੇਟ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","ਤੂੰ ਹਾਰੂਨ ਦੇ ਥਾਪਨਾ ਦੇ ਛੱਤਰੇ ਦੀ ਛਾਤੀ ਲੈ ਕੇ ਯਹੋਵਾਹ ਦੇ ਸਨਮੁਖ ਹਿਲਾਉਣ ਦੀ ਭੇਟ ਲਈ ਹਿਲਾਵੀਂ ਅਤੇ ਉਹ ਤੇਰਾ ਹਿੱਸਾ ਹੋਵੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","ਤੂੰ ਹਿਲਾਉਣ ਦੀ ਭੇਟ ਦਾ ਸੀਨਾ ਅਤੇ ਚੁੱਕਣ ਦੀ ਭੇਟ ਦਾ ਪੱਟ ਜਿਹੜਾ ਹਿਲਾਇਆ ਜਾਵੇ ਅਤੇ ਜਿਹੜਾ ਚੁੱਕਿਆ ਜਾਵੇ ਹਾਰੂਨ ਅਤੇ ਉਸ ਦੇ ਪੁੱਤਰਾਂ ਦੇ ਥਾਪਨਾ ਦੇ ਛੱਤਰੇ ਤੋਂ ਪਵਿੱਤਰ ਕਰੀਂ। ");
INSERT INTO pan_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","ਸੋ ਉਹ ਹਾਰੂਨ ਅਤੇ ਉਸ ਦੇ ਪੁੱਤਰਾਂ ਲਈ ਸਦਾ ਦਾ ਹੱਕ ਇਸਰਾਏਲੀਆਂ ਵੱਲੋਂ ਹੋਵੇ ਕਿਉਂ ਜੋ ਉਹ ਚੁੱਕਣ ਦੀ ਭੇਟ ਹੈ ਅਤੇ ਚੁੱਕਣ ਦੀ ਭੇਟ ਇਸਰਾਏਲੀਆਂ ਵੱਲੋਂ ਉਨ੍ਹਾਂ ਦੀਆਂ ਸੁੱਖ-ਸਾਂਦ ਦੀਆਂ ਭੇਟਾਂ ਤੋਂ ਹੋਵੇਗੀ ਸਗੋਂ ਯਹੋਵਾਹ ਲਈ ਉਨ੍ਹਾਂ ਦੀ ਚੁੱਕਣ ਦੀ ਭੇਟ ਰਹੇਗੀ। ");
INSERT INTO pan_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","ਪਵਿੱਤਰ ਬਸਤ੍ਰ ਜਿਹੜੇ ਹਾਰੂਨ ਦੇ ਹਨ ਉਸ ਦੇ ਮਗਰੋਂ ਉਸ ਦੇ ਪੁੱਤਰਾਂ ਦੇ ਹੋਣਗੇ। ਉਨ੍ਹਾਂ ਦੇ ਵਿੱਚ ਉਹ ਮਸਹ ਕੀਤੇ ਜਾਣ ਅਤੇ ਥਾਪੇ ਜਾਣ। ");
INSERT INTO pan_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","ਸੱਤ ਦਿਨ ਜਿਹੜਾ ਪੁੱਤਰ ਉਸ ਦੀ ਥਾਂ ਜਾਜਕ ਹੋਵੇ ਉਹ ਉਨ੍ਹਾਂ ਨੂੰ ਜਦ ਉਹ ਮੰਡਲੀ ਦੇ ਤੰਬੂ ਨੂੰ ਪਵਿੱਤਰ ਸਥਾਨ ਵਿੱਚ ਉਪਾਸਨਾ ਲਈ ਜਾਵੇ ਪਹਿਨੇ। ");
INSERT INTO pan_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","ਤੂੰ ਥਾਪਨਾ ਦੇ ਛੱਤਰੇ ਨੂੰ ਲੈ ਕੇ ਉਸ ਦਾ ਮਾਸ ਇੱਕ ਪਵਿੱਤਰ ਸਥਾਨ ਵਿੱਚ ਉਬਾਲੀਂ ");
INSERT INTO pan_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","ਅਤੇ ਹਾਰੂਨ ਅਤੇ ਉਸ ਦੇ ਪੁੱਤਰ ਛੱਤਰੇ ਦਾ ਮਾਸ ਅਤੇ ਰੋਟੀ ਜਿਹੜੀ ਉਸ ਛਾਬੇ ਵਿੱਚ ਹੈ ਮੰਡਲੀ ਦੇ ਤੰਬੂ ਦੇ ਦਰਵਾਜ਼ੇ ਕੋਲ ਖਾਣ ");
INSERT INTO pan_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","ਉਹ ਉਨ੍ਹਾਂ ਵਸਤਾਂ ਨੂੰ ਖਾਣ ਜਿਨ੍ਹਾਂ ਨਾਲ ਪ੍ਰਾਸਚਿਤ ਕੀਤਾ ਗਿਆ ਤਾਂ ਜੋ ਉਹ ਥਾਪੇ ਅਤੇ ਪਵਿੱਤਰ ਕੀਤੇ ਜਾਣ ਪਰ ਕੋਈ ਓਪਰਾ ਉਸ ਤੋਂ ਨਾ ਖਾਵੇ ਕਿਉਂ ਜੋ ਉਹ ਪਵਿੱਤਰ ਹਨ। ");
INSERT INTO pan_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","ਅਤੇ ਜੇ ਕਦੀ ਥਾਪਨਾ ਦੇ ਮਾਸ ਤੋਂ ਅਥਵਾ ਰੋਟੀ ਤੋਂ ਸਵੇਰ ਤੱਕ ਕੁਝ ਬਚ ਜਾਵੇ ਤਾਂ ਤੂੰ ਉਸ ਬਚਤ ਨੂੰ ਅੱਗ ਵਿੱਚ ਸਾੜ ਸੁੱਟੀਂ। ਉਹ ਖਾਧਾ ਨਾ ਜਾਵੇ ਕਿਉਂ ਜੋ ਉਹ ਪਵਿੱਤਰ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","ਸੋ ਤੂੰ ਹਾਰੂਨ ਅਤੇ ਉਸ ਦੇ ਪੁੱਤਰਾਂ ਲਈ ਉਸੇ ਤਰ੍ਹਾਂ ਹੀ ਕਰੀਂ ਜਿਵੇਂ ਮੈਂ ਤੈਨੂੰ ਹੁਕਮ ਦਿੱਤਾ ਹੈ। ਸੱਤ ਦਿਨ ਤੱਕ ਤੂੰ ਉਨ੍ਹਾਂ ਦੀ ਥਾਪਨਾ ਕਰੀਂ। ");
INSERT INTO pan_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","ਪਾਪ ਦੀ ਭੇਟ ਦਾ ਛੱਤਰਾ ਰੋਜ਼ ਪ੍ਰਾਸਚਿਤ ਲਈ ਤੂੰ ਚੜ੍ਹਾਈਂ ਅਤੇ ਤੂੰ ਜਗਵੇਦੀ ਨੂੰ ਸ਼ੁੱਧ ਕਰੀਂ। ਜਦ ਤੂੰ ਉਸ ਲਈ ਪ੍ਰਾਸਚਿਤ ਕਰੇਂ ਤੂੰ ਉਹ ਨੂੰ ਪਵਿੱਤਰ ਕਰਨ ਲਈ ਤੇਲ ਚੋਵੀਂ। ");
INSERT INTO pan_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","ਸੱਤ ਦਿਨ ਤੱਕ ਤੂੰ ਜਗਵੇਦੀ ਲਈ ਪ੍ਰਾਸਚਿਤ ਕਰ ਕੇ ਉਹ ਨੂੰ ਪਵਿੱਤਰ ਕਰੀਂ ਸੋ ਉਹ ਜਗਵੇਦੀ ਬਹੁਤ ਪਵਿੱਤਰ ਹੋਵੇਗੀ ਅਤੇ ਜਿਹੜਾ ਜਗਵੇਦੀ ਨੂੰ ਛੂਹੇ ਉਹ ਪਵਿੱਤਰ ਹੋਵੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","ਉਹ ਜਿਹੜਾ ਤੂੰ ਜਗਵੇਦੀ ਉੱਤੇ ਚੜ੍ਹਾਉਣਾ ਹੈ ਸੋ ਇਹ ਹੈ - ਇੱਕ-ਇੱਕ ਸਾਲ ਦੇ ਦੋ ਲੇਲੇ ਹਰ ਰੋਜ਼ ਸਦਾ ਲਈ। ");
INSERT INTO pan_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","ਇੱਕ ਲੇਲਾ ਤੂੰ ਸਵੇਰ ਨੂੰ ਚੜ੍ਹਾਵੀਂ ਅਤੇ ਦੂਜਾ ਲੇਲਾ ਤੂੰ ਸ਼ਾਮ ਨੂੰ ਚੜ੍ਹਾਵੀਂ। ");
INSERT INTO pan_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","ਅਤੇ ਇੱਕ ਲੇਲੇ ਨਾਲ ਏਫ਼ਾਹ ਦੀ ਦਸਵੰਧ ਮੈਦਾ ਖ਼ਾਲਸ ਤੇਲ ਦੇ ਹੀਨ ਦੀ ਚੌਥਾਈ ਪੀਣ ਦੀ ਭੇਟ ਲਈ ਚੜ੍ਹਾਵੀਂ ");
INSERT INTO pan_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","ਤਾਂ ਤੂੰ ਦੂਜਾ ਲੇਲਾ ਸ਼ਾਮਾਂ ਦੇ ਵੇਲੇ ਚੜ੍ਹਾਵੀਂ ਅਤੇ ਉਸ ਦੇ ਨਾਲ ਸਵੇਰ ਦੇ ਮੈਦੇ ਦੀ ਭੇਟ ਅਨੁਸਾਰ ਅਤੇ ਉਸ ਦੀ ਪੀਣ ਦੀ ਭੇਟ ਅਨੁਸਾਰ ਯਹੋਵਾਹ ਲਈ ਸੁਗੰਧਤਾ ਦੀ ਇੱਕ ਅੱਗ ਦੀ ਭੇਟ ਕਰਕੇ ਚੜ੍ਹਾਈਂ। ");
INSERT INTO pan_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","ਇਹ ਸਦਾ ਲਈ ਤੁਹਾਡੀਆਂ ਪੀੜ੍ਹੀਆਂ ਵਿੱਚ ਹੋਮ ਦੀ ਭੇਟ ਹੋਵੇ। ਮੰਡਲੀ ਦੇ ਤੰਬੂ ਦੇ ਦਰਵਾਜ਼ੇ ਕੋਲ ਯਹੋਵਾਹ ਦੇ ਸਨਮੁਖ ਜਿੱਥੇ ਮੈਂ ਤੇਰੇ ਨਾਲ ਗੱਲ ਕਰਨ ਲਈ ਮਿਲਾਂਗਾ ");
INSERT INTO pan_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","ਅਤੇ ਉੱਥੇ ਮੈਂ ਇਸਰਾਏਲੀਆਂ ਨਾਲ ਮਿਲਾਂਗਾ ਅਤੇ ਉਹ ਤੰਬੂ ਮੇਰੇ ਪਰਤਾਪ ਨਾਲ ਪਵਿੱਤਰ ਕੀਤਾ ਜਾਵੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","ਮੈਂ ਮੰਡਲੀ ਦੇ ਤੰਬੂ ਨੂੰ ਅਤੇ ਜਗਵੇਦੀ ਨੂੰ ਪਵਿੱਤਰ ਕਰਾਂਗਾ ਨਾਲੇ ਮੈਂ ਹਾਰੂਨ ਅਤੇ ਉਸ ਦੇ ਪੁੱਤਰਾਂ ਨੂੰ ਆਪਣੀ ਜਾਜਕਾਈ ਦੀ ਉਪਾਸਨਾ ਲਈ ਪਵਿੱਤਰ ਕਰਾਂਗਾ। ");
INSERT INTO pan_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","ਅਤੇ ਮੈਂ ਇਸਰਾਏਲ ਦੇ ਵਿਚਕਾਰ ਵੱਸਾਂਗਾ ਅਤੇ ਉਨ੍ਹਾਂ ਦਾ ਪਰਮੇਸ਼ੁਰ ਹੋਵਾਂਗਾ ");
INSERT INTO pan_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","ਤਾਂ ਉਹ ਜਾਣਨਗੇ ਕਿ ਮੈਂ ਯਹੋਵਾਹ ਉਨ੍ਹਾਂ ਦਾ ਪਰਮੇਸ਼ੁਰ ਹਾਂ ਜਿਸ ਉਨ੍ਹਾਂ ਨੂੰ ਮਿਸਰ ਦੇਸ ਤੋਂ ਕੱਢ ਲਿਆਂਦਾ ਤਾਂ ਜੋ ਮੈਂ ਉਨ੍ਹਾਂ ਦੇ ਵਿਚਕਾਰ ਵੱਸਾਂ। ਮੈਂ ਯਹੋਵਾਹ ਉਨ੍ਹਾਂ ਦਾ ਪਰਮੇਸ਼ੁਰ ਹਾਂ। ");
INSERT INTO pan_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","ਤੂੰ ਧੂਪ ਧੁਖਾਉਣ ਲਈ ਇੱਕ ਜਗਵੇਦੀ ਬਣਾਈਂ ਅਤੇ ਤੂੰ ਉਹ ਨੂੰ ਸ਼ਿੱਟੀਮ ਦੀ ਲੱਕੜੀ ਤੋਂ ਬਣਾਈਂ। ");
INSERT INTO pan_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","ਉਸ ਦੀ ਲੰਬਾਈ ਇੱਕ ਹੱਥ ਉਸ ਦੀ ਚੌੜਾਈ ਇੱਕ ਹੱਥ ਅਤੇ ਉਹ ਚੌਰਸ ਹੋਵੇ। ਉਸ ਦੀ ਉਚਾਈ ਦੋ ਹੱਥ ਅਤੇ ਉਸ ਦੇ ਸਿੰਙ ਉਸੇ ਤੋਂ ਹੋਣ। ");
INSERT INTO pan_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","ਤੂੰ ਉਹ ਨੂੰ ਖ਼ਾਲਸ ਸੋਨੇ ਨਾਲ ਮੜ੍ਹੀਂ ਅਰਥਾਤ ਉਹ ਦਾ ਉੱਪਰਲਾ ਪਾਸਾ ਅਤੇ ਉਹ ਦੇ ਚੁਫ਼ੇਰੇ ਦੇ ਪਾਸੇ ਅਤੇ ਉਹ ਦੇ ਸਿੰਙ, ਤੂੰ ਉਹ ਦੇ ਚੁਫ਼ੇਰੇ ਇੱਕ ਸੋਨੇ ਦੀ ਬਨੇਰੀ ਬਣਾਈਂ। ");
INSERT INTO pan_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","ਤੂੰ ਉਹ ਦੇ ਲਈ ਸੋਨੇ ਦੇ ਦੋ ਕੜੇ ਉਸ ਦੀ ਬਨੇਰੀ ਦੇ ਹੇਠ ਉਸ ਦੇ ਦੋਹਾਂ ਪੱਲਿਆਂ ਉੱਤੇ ਉਸ ਦੇ ਦੋਹੀਂ ਪਾਸੀਂ ਬਣਾਈਂ। ਉਹ ਉਸ ਦੇ ਚੁੱਕਣ ਲਈ ਚੋਬਾਂ ਦੇ ਥਾਂ ਹੋਣ। ");
INSERT INTO pan_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","ਤੂੰ ਚੋਬਾਂ ਸ਼ਿੱਟੀਮ ਦੀ ਲੱਕੜੀ ਦੀਆਂ ਬਣਾਈਂ ਅਤੇ ਉਨ੍ਹਾਂ ਨੂੰ ਸੋਨੇ ਨਾਲ ਮੜ੍ਹੀਂ। ");
INSERT INTO pan_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","ਤੂੰ ਉਹ ਨੂੰ ਪਰਦੇ ਦੇ ਅੱਗੇ ਜਿਹੜਾ ਸਾਖੀ ਦੇ ਸੰਦੂਕ ਦੇ ਕੋਲ ਹੈ ਪ੍ਰਾਸਚਿਤ ਦੇ ਸਰਪੋਸ਼ ਦੇ ਅੱਗੇ ਜਿਹੜਾ ਸਾਖੀ ਉੱਤੇ ਹੈ ਰੱਖੀਂ ਜਿੱਥੇ ਮੈਂ ਤੇਰੇ ਨਾਲ ਮਿਲਾਂਗਾ। ");
INSERT INTO pan_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","ਅਤੇ ਹਾਰੂਨ ਉਸ ਉੱਤੇ ਸੁਗੰਧੀ ਧੂਪ ਹਰ ਸਵੇਰੇ ਦੇ ਸਮੇਂ ਧੁਖਾਵੇ। ਜਦ ਉਹ ਦੀਵਿਆਂ ਨੂੰ ਸੁਆਰੇ ਤਦ ਉਹ ਇਹ ਧੁਖਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","ਜਦ ਹਾਰੂਨ ਦੀਵਿਆਂ ਨੂੰ ਸ਼ਾਮ ਦੇ ਵੇਲੇ ਜਗਾਵੇ ਤਦ ਉਹ ਤੁਹਾਡੀਆਂ ਪੀੜ੍ਹੀਆਂ ਤੱਕ ਸਦਾ ਲਈ ਯਹੋਵਾਹ ਦੇ ਸਨਮੁਖ ਧੂਪ ਧੁਖਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","ਤੁਸੀਂ ਉਸ ਉੱਤੇ ਨਾ ਓਪਰਾ ਧੂਪ ਨਾ ਹੋਮ ਦੀ ਬਲੀ ਨਾ ਮੈਦੇ ਦੀ ਭੇਟ ਚੜ੍ਹਾਇਓ ਅਤੇ ਨਾ ਉਸ ਉੱਤੇ ਪੀਣ ਦੀ ਭੇਟ ਡੋਲ੍ਹਿਓ ");
INSERT INTO pan_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","ਅਤੇ ਹਾਰੂਨ ਉਸ ਦੇ ਸਿੰਗਾਂ ਉੱਤੇ ਵਰ੍ਹੇ ਵਿੱਚ ਇੱਕ ਵਾਰੀ ਪ੍ਰਾਸਚਿਤ ਕਰੇ ਅਤੇ ਪ੍ਰਾਸਚਿਤ ਦੇ ਪਾਪ ਦੀ ਭੇਟ ਦੇ ਲਹੂ ਤੋਂ ਲੈ ਕੇ ਸਾਲ ਵਿੱਚ ਇੱਕ ਵਾਰ ਤੁਹਾਡੀਆਂ ਪੀੜ੍ਹੀਆਂ ਤੱਕ ਪ੍ਰਾਸਚਿਤ ਕਰੇ। ਇਹ ਯਹੋਵਾਹ ਲਈ ਬਹੁਤ ਪਵਿੱਤਰ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","ਯਹੋਵਾਹ ਮੂਸਾ ਨੂੰ ਬੋਲਿਆ ਕਿ ");
INSERT INTO pan_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","ਜਦ ਤੂੰ ਇਸਰਾਏਲੀਆਂ ਦੀ ਗਿਣਤੀ ਉਨ੍ਹਾਂ ਦੇ ਸ਼ੁਮਾਰ ਅਨੁਸਾਰ ਕਰੇਂ ਤਾਂ ਹਰ ਮਨੁੱਖ ਆਪਣੇ ਪ੍ਰਾਣਾਂ ਲਈ ਯਹੋਵਾਹ ਨੂੰ ਜਦ ਉਨ੍ਹਾਂ ਦੀ ਗਿਣਤੀ ਹੋਵੇ ਨਿਸਤਾਰੇ ਦਾ ਮੁੱਲ ਦੇਵੇ ਤਾਂ ਜੋ ਉਨ੍ਹਾਂ ਵਿੱਚ ਕੋਈ ਬਵਾ ਨਾ ਪਵੇ ਜਦ ਤੂੰ ਉਨ੍ਹਾਂ ਦੀ ਗਿਣਤੀ ਕਰੇਂ। ");
INSERT INTO pan_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","ਸਾਰੇ ਜਿਹੜੇ ਗਿਣਿਆ ਹੋਇਆਂ ਵਿੱਚ ਰਲਣ ਪਵਿੱਤਰ ਸਥਾਨ ਦੇ ਸ਼ਕਲ ਅਨੁਸਾਰ ਅੱਧਾ ਸ਼ਕਲ ਦੇਣ (ਸ਼ਕਲ ਵਿੱਚ ਵੀਹ ਜੀਰੇ ਹਨ) ਸੋ ਇਹ ਅੱਠ ਆਨੇ ਯਹੋਵਾਹ ਲਈ ਚੁੱਕਣ ਦੀ ਭੇਟ ਹੋਵੇਗੀ। ");
INSERT INTO pan_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","ਸਾਰੇ ਜਿਹੜੇ ਗਿਣਿਆ ਹੋਇਆਂ ਵਿੱਚ ਰਲਣ ਵੀਹ ਸਾਲ ਦੇ ਅਤੇ ਉੱਤੇ ਦੇ ਹੋਣ ਯਹੋਵਾਹ ਨੂੰ ਚੁੱਕਣ ਦੀ ਭੇਟ ਦੇਣ। ");
INSERT INTO pan_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","ਤਾਂ ਧਨੀ ਅੱਠ ਆਨੇ ਤੋਂ ਵੱਧ ਅਤੇ ਕੰਗਾਲ ਉਸ ਤੋਂ ਘੱਟ ਨਾ ਦੇਣ ਜਦ ਤੁਹਾਡੇ ਪ੍ਰਾਣਾਂ ਦੇ ਪ੍ਰਾਸਚਿਤ ਲਈ ਯਹੋਵਾਹ ਦੀ ਚੁੱਕਣ ਦੀ ਭੇਟ ਦੇਣ। ");
INSERT INTO pan_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","ਸੋ ਤੂੰ ਇਸਰਾਏਲੀਆਂ ਤੋਂ ਪ੍ਰਾਸਚਿਤ ਦੀ ਚਾਂਦੀ ਲੈ ਕੇ ਉਹ ਨੂੰ ਮੰਡਲੀ ਦੇ ਤੰਬੂ ਦੇ ਕੰਮ ਲਈ ਵਰਤੀਂ ਅਤੇ ਉਹ ਇਸਰਾਏਲੀਆਂ ਲਈ ਯਹੋਵਾਹ ਅੱਗੇ ਇੱਕ ਯਾਦਗਿਰੀ ਹੋਵੇ ਤਾਂ ਜੋ ਤੁਹਾਡਿਆਂ ਪ੍ਰਾਣਾਂ ਲਈ ਪ੍ਰਾਸਚਿਤ ਹੋਵੇ। ");
INSERT INTO pan_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਆਖਿਆ ਕਿ ");
INSERT INTO pan_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","ਤੂੰ ਧੋਣ ਲਈ ਪਿੱਤਲ ਦਾ ਇੱਕ ਹੌਦ ਅਤੇ ਉਹ ਦੇ ਲਈ ਪਿੱਤਲ ਦੀ ਇੱਕ ਚੌਂਕੀ ਬਣਾਈਂ ਅਤੇ ਮੰਡਲੀ ਦੇ ਤੰਬੂ ਅਤੇ ਜਗਵੇਦੀ ਦੇ ਵਿਚਕਾਰ ਉਹ ਨੂੰ ਰੱਖੀਂ ਅਤੇ ਉਸ ਵਿੱਚ ਪਾਣੀ ਭਰੀਂ। ");
INSERT INTO pan_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","ਉਸ ਵਿੱਚ ਹਾਰੂਨ ਅਤੇ ਉਸ ਦੇ ਪੁੱਤਰ ਆਪਣੇ ਹੱਥ-ਪੈਰ ਧੋਣ ");
INSERT INTO pan_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","ਜਦ ਉਹ ਮੰਡਲੀ ਦੇ ਤੰਬੂ ਵਿੱਚ ਅਥਵਾ ਜਦ ਉਹ ਜਗਵੇਦੀ ਦੇ ਨੇੜੇ ਉਪਾਸਨਾ ਲਈ ਆਉਣ ਕਿ ਯਹੋਵਾਹ ਲਈ ਅੱਗ ਦੀ ਭੇਟ ਧੁਖਾਉਣ ਤਾਂ ਪਾਣੀ ਨਾਲ ਧੋਣ ਕਿ ਉਹ ਨਾ ਮਰਨ। ");
INSERT INTO pan_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","ਉਹ ਆਪਣੇ ਹੱਥ-ਪੈਰ ਧੋਣ ਕਿ ਉਹ ਨਾ ਮਰਨ ਅਤੇ ਉਹ ਉਨ੍ਹਾਂ ਲਈ ਸਦਾ ਦੀ ਬਿਧੀ ਹੋਵੇ ਅਰਥਾਤ ਉਸ ਲਈ ਅਤੇ ਉਸ ਦੀ ਅੰਸ ਲਈ ਉਨ੍ਹਾਂ ਦੀ ਪੀੜ੍ਹੀਓਂ ਪੀੜ੍ਹੀ ਤੱਕ। ");
INSERT INTO pan_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","ਫੇਰ ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਆਖਿਆ ਕਿ ");
INSERT INTO pan_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","ਤੂੰ ਵਧੀਆ ਮਸਾਲਾ ਲਵੀਂ ਅਰਥਾਤ ਪਤਲਾ ਮੁਰ ਪੰਜ ਸੌ ਸ਼ਕਲ ਅਤੇ ਸੁਗੰਧ ਲਈ ਦਾਲਚੀਨੀ ਉਸ ਤੋਂ ਅੱਧੀ ਅਰਥਾਤ ਢਾਈ ਸੌ ਸ਼ਕਲ ਅਤੇ ਸੁਗੰਧ ਵਾਲੀ ਕੁਸ਼ਾ ਢਾਈ ਸੌ ਸ਼ਕਲ ");
INSERT INTO pan_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","ਅਤੇ ਤੱਜ ਪੰਜ ਸੌ ਸ਼ਕਲ ਪਵਿੱਤਰ ਸਥਾਨ ਦੇ ਸ਼ਕਲ ਅਨੁਸਾਰ ਅਤੇ ਜ਼ੈਤੂਨ ਦਾ ਤੇਲ ਇੱਕ ਹੀਨ ");
INSERT INTO pan_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","ਅਤੇ ਤੂੰ ਉਹ ਨੂੰ ਮਸਹ ਕਰਨ ਦਾ ਪਵਿੱਤਰ ਤੇਲ ਗਾਂਧੀ ਦੀ ਕਾਰੀਗਰੀ ਅਤੇ ਮਿਲੀਆਂ ਹੋਈਆਂ ਸੁਗੰਧਾਂ ਨਾਲ ਬਣਾਈਂ। ਉਹ ਇੱਕ ਮਲਣ ਦਾ ਪਵਿੱਤਰ ਤੇਲ ਹੋਵੇ। ");
INSERT INTO pan_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","ਤੂੰ ਉਸ ਨਾਲ ਮੰਡਲੀ ਦੇ ਤੰਬੂ ਨੂੰ ਅਤੇ ਸਾਖੀ ਦੇ ਸੰਦੂਕ ਨੂੰ ਮਲੀਂ। ");
INSERT INTO pan_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","ਨਾਲੇ ਮੇਜ਼ ਨੂੰ ਅਤੇ ਉਸ ਦੇ ਸਾਰੇ ਸਮਾਨ ਨੂੰ ਅਤੇ ਸ਼ਮਾਦਾਨ ਨੂੰ ਅਤੇ ਉਸ ਦੇ ਸਾਰੇ ਸਮਾਨ ਨੂੰ ਅਤੇ ਧੂਪ ਦੀ ਜਗਵੇਦੀ ਨੂੰ ");
INSERT INTO pan_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","ਅਤੇ ਹੋਮ ਦੀ ਜਗਵੇਦੀ ਨੂੰ ਅਤੇ ਉਸ ਦੇ ਸਾਰੇ ਸਮਾਨ ਨੂੰ ਅਤੇ ਹੌਦ ਅਤੇ ਉਸ ਦੀ ਚੌਂਕੀ ਨੂੰ। ");
INSERT INTO pan_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","ਤੂੰ ਉਨ੍ਹਾਂ ਨੂੰ ਪਵਿੱਤਰ ਕਰੀਂ ਕਿ ਉਹ ਬਹੁਤ ਪਵਿੱਤਰ ਹੋਣ ਅਤੇ ਜੋ ਕੁਝ ਉਨ੍ਹਾਂ ਨੂੰ ਲੱਗੇ ਪਵਿੱਤਰ ਹੋਵੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","ਤਾਂ ਤੂੰ ਹਾਰੂਨ ਅਤੇ ਉਸ ਦੇ ਪੁੱਤਰਾਂ ਨੂੰ ਮਸਹ ਕਰ ਕੇ ਪਵਿੱਤਰ ਕਰੀਂ ਤਾਂ ਜੋ ਉਹ ਮੇਰੀ ਜਾਜਕਾਈ ਦੀ ਉਪਾਸਨਾ ਕਰਨ। ");
INSERT INTO pan_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","ਅਤੇ ਤੂੰ ਇਸਰਾਏਲੀਆਂ ਨੂੰ ਆਖੀਂ ਕਿ ਇਹ ਮਲਣ ਦਾ ਪਵਿੱਤਰ ਤੇਲ ਮੇਰੇ ਲਈ ਤੁਹਾਡੀਆਂ ਪੀੜ੍ਹੀਆਂ ਤੱਕ ਹੋਵੇ। ");
INSERT INTO pan_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","ਇਹ ਆਦਮੀ ਦੇ ਪਿੰਡੇ ਉੱਤੇ ਨਹੀਂ ਲਾਈਦਾ ਅਤੇ ਉਸ ਦੀ ਸਮੱਗਰੀ ਤੋਂ ਹੋਰ ਕਿਸੇ ਪ੍ਰਕਾਰ ਦਾ ਤੇਲ ਤੁਸੀਂ ਨਾ ਬਣਾਇਓ। ਇਹ ਪਵਿੱਤਰ ਹੈ ਅਤੇ ਤੁਹਾਡੇ ਲਈ ਪਵਿੱਤਰ ਰਹੇ। ");
INSERT INTO pan_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","ਜਿਹੜਾ ਮਨੁੱਖ ਉਸ ਵਰਗੀ ਮਿਲਾਵਟ ਕਰੇ ਅਤੇ ਉਸ ਵਿੱਚੋਂ ਕਿਸੇ ਓਪਰੇ ਉੱਤੇ ਚੋਵੇ ਉਹ ਆਪਣੇ ਲੋਕਾਂ ਵਿੱਚੋਂ ਛੇਕਿਆ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਆਖਿਆ, ਤੂੰ ਆਪਣੇ ਲਈ ਮੁਰ ਵਾਲਾ ਮਸਾਲਾ ਲਈਂ ਅਰਥਾਤ ਮੁਰ ਮਸਤਕੀ ਅਤੇ ਲੌਨ ਅਤੇ ਖ਼ਾਲਸ ਲੁਬਾਨ - ਇਹ ਇੱਕੋ ਵਜ਼ਨ ਦੇ ਹੋਣ। ");
INSERT INTO pan_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","ਤੂੰ ਉਹ ਨੂੰ ਸੁਗੰਧ ਵਾਲੀ ਧੂਪ ਗਾਂਧੀ ਦੀ ਕਾਰੀਗਰੀ ਦੀ ਬਣਾਈਂ। ਸਲੂਣੀ ਨਿਰੋਲ ਅਤੇ ਪਵਿੱਤਰ ਹੋਵੇ। ");
INSERT INTO pan_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","ਤੂੰ ਉਸ ਵਿੱਚੋਂ ਕੁਝ ਬਹੁਤ ਮਹੀਨ ਪੀਹ ਕੇ ਉਹ ਨੂੰ ਸਾਖੀ ਦੇ ਸੰਦੂਕ ਅੱਗੇ ਮੰਡਲੀ ਦੇ ਤੰਬੂ ਵਿੱਚ ਰੱਖੀਂ ਜਿੱਥੇ ਮੈਂ ਤੈਨੂੰ ਮਿਲਾਂਗਾ। ਇਹ ਤੁਹਾਡੇ ਲਈ ਬਹੁਤ ਪਵਿੱਤਰ ਹੋਵੇ। ");
INSERT INTO pan_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","ਜਿਹੜੀ ਧੂਪ ਨੂੰ ਬਣਾਵੇਂਗਾ ਉਸ ਦੀ ਸਮੱਗਰੀ ਤੋਂ ਹੋਰ ਧੂਪ ਆਪਣੇ ਲਈ ਨਾ ਬਣਾਇਓ, ਉਹ ਤੇਰੀ ਵੱਲੋਂ ਯਹੋਵਾਹ ਲਈ ਪਵਿੱਤਰ ਹੋਵੇ। ");
INSERT INTO pan_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","ਜਿਹੜਾ ਮਨੁੱਖ ਉਸ ਵਾਂਗੂੰ ਸੁੰਘਣ ਲਈ ਬਣਾਵੇ ਉਹ ਆਪਣਿਆਂ ਲੋਕਾਂ ਵਿੱਚੋਂ ਨਾਸ ਕੀਤਾ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਆਖਿਆ ਕਿ ");
INSERT INTO pan_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","ਵੇਖ ਮੈਂ ਬਸਲਏਲ ਨੂੰ ਜਿਹੜਾ ਊਰੀ ਦਾ ਪੁੱਤਰ ਅਤੇ ਹੂਰ ਦਾ ਪੋਤਾ ਅਤੇ ਯਹੂਦਾਹ ਦੇ ਗੋਤ ਦਾ ਹੈ ਨਾਮ ਲੈ ਕੇ ਬੁਲਾਇਆ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","ਮੈਂ ਉਹ ਨੂੰ ਪਰਮੇਸ਼ੁਰ ਦੇ ਆਤਮਾ ਤੋਂ ਬੁੱਧ ਸਮਝ ਵਿੱਦਿਆ ਅਤੇ ਸਾਰੀ ਕਾਰੀਗਰੀ ਨਾਲ ਭਰਪੂਰ ਕੀਤਾ ਹੈ ");
INSERT INTO pan_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","ਕਿ ਉਹ ਚਤਰਾਈ ਦੇ ਕੰਮ ਦੀ ਵਿਚਾਰ ਕਰੇ ਅਤੇ ਸੋਨੇ ਚਾਂਦੀ ਅਤੇ ਪਿੱਤਲ ਦਾ ਕੰਮ ਕਰੇ ");
INSERT INTO pan_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","ਨਾਲੇ ਪੱਥਰਾਂ ਨੂੰ ਜੜਨ ਲਈ ਉੱਕਰੇ ਅਤੇ ਲੱਕੜੀ ਦੀ ਚਿੱਤਰਕਾਰੀ ਕਰੇ ਅਤੇ ਸਾਰੀ ਕਾਰੀਗਰੀ ਨਾਲ ਕੰਮ ਕਰੇ। ");
INSERT INTO pan_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","ਅਤੇ ਵੇਖ ਮੈਂ ਉਹ ਦੇ ਨਾਲ ਅਹੀਸਾਮਾਕ ਦੇ ਪੁੱਤਰ ਆਹਾਲੀਆਬ ਨੂੰ ਜਿਹੜਾ ਦਾਨ ਦੇ ਗੋਤ ਦਾ ਹੈ ਥਾਪਿਆ ਅਤੇ ਸਾਰੇ ਸਿਆਣਿਆਂ ਦੇ ਮਨਾਂ ਵਿੱਚ ਬੁੱਧ ਪਾ ਦਿੱਤੀ ਤਾਂ ਜੋ ਉਹ ਜੋ ਕੁਝ ਮੈਂ ਤੈਨੂੰ ਹੁਕਮ ਦਿੱਤਾ ਬਣਾਉਣ, ");
INSERT INTO pan_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","ਅਰਥਾਤ ਮੰਡਲੀ ਦਾ ਤੰਬੂ ਅਤੇ ਸਾਖੀ ਦਾ ਸੰਦੂਕ ਅਤੇ ਪ੍ਰਾਸਚਿਤ ਦਾ ਸਰਪੋਸ਼ ਜਿਹੜਾ ਉਹ ਦੇ ਉੱਤੇ ਹੈ ਅਤੇ ਤੰਬੂ ਦਾ ਸਾਰਾ ਸਮਾਨ ");
INSERT INTO pan_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","ਨਾਲੇ ਮੇਜ਼ ਅਤੇ ਉਸ ਦਾ ਸਮਾਨ ਅਤੇ ਖ਼ਾਲਸ ਸ਼ਮਾਦਾਨ ਅਤੇ ਉਸ ਦਾ ਸਾਰਾ ਸਮਾਨ ਅਤੇ ਧੂਪ ਦੀ ਜਗਵੇਦੀ ");
INSERT INTO pan_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","ਅਤੇ ਹੋਮ ਦੀ ਜਗਵੇਦੀ ਅਤੇ ਉਸ ਦਾ ਸਾਰਾ ਸਮਾਨ ਅਤੇ ਹੌਦ ਅਤੇ ਉਸ ਦੀ ਚੌਂਕੀ ");
INSERT INTO pan_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","ਅਤੇ ਮਹੀਨ ਉਣੇ ਹੋਏ ਬਸਤਰ ਅਤੇ ਹਾਰੂਨ ਜਾਜਕ ਦੇ ਪਵਿੱਤਰ ਬਸਤਰ ਅਤੇ ਉਸ ਦੇ ਪੁੱਤਰਾਂ ਦੇ ਬਸਤਰ ਜਦ ਉਹ ਜਾਜਕਾਈ ਦੀ ਉਪਾਸਨਾ ਕਰਨ ");
INSERT INTO pan_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","ਅਤੇ ਮਸਹ ਕਰਨ ਦਾ ਤੇਲ ਅਤੇ ਸੁਗੰਧ ਵਾਲੀ ਧੂਪ ਪਵਿੱਤਰ ਸਥਾਨ ਲਈ ਜੋ ਕੁਝ ਮੈਂ ਤੈਨੂੰ ਹੁਕਮ ਦਿੱਤਾ ਉਸ ਦੇ ਅਨੁਸਾਰ ਉਹ ਕਰਨ। ");
INSERT INTO pan_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","ਫਿਰ ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਆਖਿਆ ਕਿ ");
INSERT INTO pan_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","ਤੂੰ ਇਸਰਾਏਲੀਆਂ ਨੂੰ ਬੋਲ ਕਿ ਮੇਰੇ ਸਬਤਾਂ ਦੀ ਜ਼ਰੂਰ ਮਨੌਤ ਕਰਿਓ ਕਿਉਂ ਜੋ ਉਹ ਮੇਰੇ ਵਿੱਚ ਅਤੇ ਤੁਹਾਡੇ ਵਿੱਚ ਤੁਹਾਡੀਆਂ ਪੀੜ੍ਹੀਆਂ ਤੱਕ ਇੱਕ ਨਿਸ਼ਾਨ ਹੈ ਕਿ ਤੁਸੀਂ ਜਾਣੋ ਕਿ ਮੈਂ ਯਹੋਵਾਹ ਤੁਹਾਡਾ ਪਵਿੱਤਰ ਕਰਨ ਵਾਲਾ ਹਾਂ। ");
INSERT INTO pan_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","ਅਤੇ ਤੁਸੀਂ ਸਬਤ ਦੀ ਮਨੌਤ ਕਰਿਓ ਕਿਉਂ ਜੋ ਉਹ ਤੁਹਾਡੇ ਲਈ ਪਵਿੱਤਰ ਹੈ। ਜਿਹੜਾ ਉਹ ਨੂੰ ਭਰਿਸ਼ਟ ਕਰੇ ਉਹ ਜ਼ਰੂਰ ਮਾਰਿਆ ਜਾਵੇ ਕਿਉਂਕਿ ਜੇ ਕੋਈ ਉਸ ਵਿੱਚ ਕੰਮ ਕਰੇ ਉਹ ਪ੍ਰਾਣੀ ਆਪਣੇ ਲੋਕਾਂ ਵਿੱਚੋਂ ਛੇਕਿਆ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","ਛੇ ਦਿਨ ਕੰਮ ਕੀਤਾ ਜਾਵੇ ਪਰ ਸੱਤਵਾਂ ਦਿਨ ਵਿਸ਼ਰਾਮ ਦਾ ਸਬਤ ਯਹੋਵਾਹ ਲਈ ਪਵਿੱਤਰ ਹੈ। ਜੋ ਕੋਈ ਸਬਤ ਦੇ ਦਿਨ ਵਿੱਚ ਕੰਮ ਕਰੇ ਉਹ ਜ਼ਰੂਰ ਮਾਰਿਆ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","ਉਪਰੰਤ ਇਸਰਾਏਲੀ ਸਬਤ ਦੀ ਮਨੌਤ ਕਰਨ ਅਤੇ ਆਪਣੀਆਂ ਪੀੜ੍ਹੀਆਂ ਤੱਕ ਇੱਕ ਵਿਸ਼ਰਾਮ ਦਾ ਦਿਨ ਕਰ ਕੇ ਮੰਨਣ ਕਿਉਂ ਜੋ ਉਹ ਸਦਾ ਲਈ ਇੱਕ ਨੇਮ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","ਉਹ ਮੇਰੇ ਵਿੱਚ ਅਤੇ ਇਸਰਾਏਲੀਆਂ ਵਿੱਚ ਸਦਾ ਲਈ ਇੱਕ ਨਿਸ਼ਾਨ ਹੈ ਕਿਉਂਕਿ ਛੇ ਦਿਨਾਂ ਵਿੱਚ ਯਹੋਵਾਹ ਨੇ ਅਕਾਸ਼ ਅਤੇ ਧਰਤੀ ਨੂੰ ਬਣਾਇਆ ਅਤੇ ਸੱਤਵੇਂ ਦਿਨ ਵਿਸ਼ਰਾਮ ਕੀਤਾ ਅਤੇ ਸ਼ਾਂਤ ਪਾਈ। ");
INSERT INTO pan_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","ਫੇਰ ਉਸ ਨੇ ਮੂਸਾ ਨੂੰ ਜਦ ਉਸ ਨਾਲ ਗੱਲਾਂ ਕਰ ਚੁੱਕਿਆ ਸੀਨਈ ਪਰਬਤ ਉੱਤੇ ਸਾਖੀ ਦੀਆਂ ਦੋਵੇਂ ਫੱਟੀਆਂ ਅਰਥਾਤ ਪੱਥਰ ਦੀਆਂ ਫੱਟੀਆਂ ਪਰਮੇਸ਼ੁਰ ਦੀ ਉਂਗਲੀ ਨਾਲ ਲਿਖੀਆਂ ਹੋਈਆਂ ਦਿੱਤੀਆਂ। ");
INSERT INTO pan_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","ਜਦ ਲੋਕਾਂ ਨੇ ਵੇਖਿਆ ਕਿ ਮੂਸਾ ਨੇ ਪਰਬਤ ਤੋਂ ਉਤਰਨ ਵਿੱਚ ਚਿਰ ਲਾ ਦਿੱਤਾ ਹੈ ਤਾਂ ਲੋਕਾਂ ਨੇ ਹਾਰੂਨ ਕੋਲ ਇਕੱਠੇ ਹੋ ਕੇ ਉਹ ਨੂੰ ਆਖਿਆ, ਉੱਠ ਅਤੇ ਸਾਡੇ ਲਈ ਦੇਵਤੇ ਬਣਾ ਜਿਹੜੇ ਸਾਡੇ ਅੱਗੇ ਚੱਲਣ ਕਿਉਂ ਜੋ ਇਹ ਮਰਦ ਮੂਸਾ ਜਿਹੜਾ ਸਾਨੂੰ ਮਿਸਰ ਦੇਸ ਤੋਂ ਉਤਾਹਾਂ ਲੈ ਆਇਆ ਹੈ ਅਸੀਂ ਨਹੀਂ ਜਾਣਦੇ ਉਹ ਨੂੰ ਕੀ ਹੋ ਗਿਆ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","ਤਾਂ ਹਾਰੂਨ ਨੇ ਉਨ੍ਹਾਂ ਨੂੰ ਆਖਿਆ, ਆਪਣੀਆਂ ਔਰਤਾਂ ਅਤੇ ਆਪਣੇ ਪੁੱਤਰਾਂ ਅਤੇ ਆਪਣੀਆਂ ਧੀਆਂ ਦੇ ਕੰਨਾਂ ਦੇ ਸੋਨੇ ਦੇ ਬਾਲੇ ਤੋੜ ਤਾੜ ਕੇ ਮੇਰੇ ਕੋਲ ਲੈ ਆਓ। ");
INSERT INTO pan_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","ਸੋ ਸਾਰੇ ਲੋਕ ਸੋਨੇ ਦੇ ਬਾਲੇ ਜੋ ਉਨ੍ਹਾਂ ਦੇ ਕੰਨਾਂ ਵਿੱਚ ਸਨ ਤੋੜ ਤਾੜ ਕੇ ਹਾਰੂਨ ਦੇ ਕੋਲ ਲੈ ਆਏ ");
INSERT INTO pan_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","ਤਾਂ ਉਸ ਨੇ ਉਹ ਉਨ੍ਹਾਂ ਦੇ ਹੱਥੋਂ ਲੈ ਲਏ ਅਤੇ ਉਨ੍ਹਾਂ ਨੂੰ ਢਾਲ਼ ਕੇ ਇੱਕ ਉੱਕਰਨ ਵਾਲੇ ਸੰਦ ਨਾਲ ਘੜ੍ਹ ਕੇ ਉਹ ਦਾ ਇੱਕ ਵੱਛਾ ਬਣਾਇਆ ਤਾਂ ਉਨ੍ਹਾਂ ਨੇ ਆਖਿਆ, ਹੇ ਇਸਰਾਏਲ ਇਹ ਹੈ ਤੇਰਾ ਦੇਵਤਾ ਜਿਹੜਾ ਤੈਨੂੰ ਮਿਸਰ ਦੇਸ ਤੋਂ ਉਤਾਹਾਂ ਲੈ ਆਇਆ। ");
INSERT INTO pan_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","ਜਦ ਹਾਰੂਨ ਨੇ ਇਹ ਡਿੱਠਾ ਤਾਂ ਉਸ ਦੇ ਅੱਗੇ ਇੱਕ ਜਗਵੇਦੀ ਬਣਾਈ ਤਾਂ ਹਾਰੂਨ ਨੇ ਪੁਕਾਰ ਕੇ ਆਖਿਆ, ਕੱਲ ਯਹੋਵਾਹ ਦਾ ਪਰਬ ਹੈ ");
INSERT INTO pan_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","ਤਾਂ ਉਹ ਅਗਲੇ ਦਿਨ ਸਵੇਰ ਨੂੰ ਉੱਠੇ ਅਤੇ ਹੋਮ ਦੀਆਂ ਬਲੀਆਂ ਚੜ੍ਹਾਈਆਂ ਅਤੇ ਸੁੱਖ-ਸਾਂਦ ਦੀਆਂ ਭੇਟਾਂ ਲਿਆਏ ਤਾਂ ਲੋਕ ਖਾਣ-ਪੀਣ ਨੂੰ ਬੈਠੇ ਅਤੇ ਹੱਸਣ ਖੇਡਣ ਨੂੰ ਉੱਠੇ। ");
INSERT INTO pan_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","ਤਾਂ ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਆਖਿਆ, ਹੇਠਾਂ ਨੂੰ ਜਾ ਕਿਉਂਕਿ ਤੇਰੇ ਲੋਕ ਜਿਨ੍ਹਾਂ ਨੂੰ ਤੂੰ ਮਿਸਰ ਦੇਸ ਤੋਂ ਉਤਾਹਾਂ ਲਿਆਇਆ ਹੈਂ ਭਰਿਸ਼ਟ ਹੋ ਗਏ ਹਨ। ");
INSERT INTO pan_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","ਉਹ ਉਸ ਰਾਹ ਤੋਂ ਛੇਤੀ ਨਾਲ ਫਿਰ ਗਏ ਹਨ ਜਿਹ ਦਾ ਮੈਂ ਉਨ੍ਹਾਂ ਨੂੰ ਹੁਕਮ ਦਿੱਤਾ ਸੀ ਅਤੇ ਉਨ੍ਹਾਂ ਦੇ ਢਾਲ਼ ਕੇ ਆਪਣੇ ਲਈ ਇੱਕ ਵੱਛਾ ਬਣਾਇਆ ਅਤੇ ਉਹ ਦੇ ਅੱਗੇ ਮੱਥਾ ਟੇਕਿਆ ਅਤੇ ਉਹ ਦੇ ਅੱਗੇ ਭੇਟ ਚੜ੍ਹਾ ਦੇ ਉਨ੍ਹਾਂ ਆਖਿਆ, ਹੇ ਇਸਰਾਏਲ ਇਹ ਹੈ ਤੇਰਾ ਦੇਵਤਾ ਜਿਹੜਾ ਤੈਨੂੰ ਮਿਸਰ ਦੇਸ ਤੋਂ ਉਤਾਹਾਂ ਲੈ ਆਇਆ। ");
INSERT INTO pan_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","ਤਦ ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਆਖਿਆ, ਮੈਂ ਇਨ੍ਹਾਂ ਲੋਕਾਂ ਨੂੰ ਡਿੱਠਾ ਹੈ, ਵੇਖ ਇਹ ਲੋਕ ਹਠੀ ਹਨ। ");
INSERT INTO pan_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","ਹੁਣ ਤੂੰ ਮੈਨੂੰ ਇਕੱਲਾ ਹੋਣ ਦੇ ਤਾਂ ਜੋ ਮੇਰਾ ਕ੍ਰੋਧ ਉਨ੍ਹਾਂ ਦੇ ਵਿਰੁੱਧ ਭੜਕੇ ਅਤੇ ਮੈਂ ਉਨ੍ਹਾਂ ਨੂੰ ਭਸਮ ਕਰ ਸੁੱਟਾਂ ਅਤੇ ਮੈਂ ਤੇਰੇ ਕੋਲੋਂ ਇੱਕ ਵੱਡੀ ਕੌਮ ਬਣਾਵਾਂਗਾ। ");
INSERT INTO pan_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","ਤਾਂ ਮੂਸਾ ਨੇ ਯਹੋਵਾਹ ਆਪਣੇ ਪਰਮੇਸ਼ੁਰ ਦੇ ਅੱਗੇ ਤਰਲੇ ਪਾ ਕੇ ਆਖਿਆ, ਹੇ ਯਹੋਵਾਹ ਤੇਰਾ ਕ੍ਰੋਧ ਤੇਰੇ ਲੋਕਾਂ ਦੇ ਵਿਰੁੱਧ ਕਿਉਂ ਭੜਕਿਆ ਹੈ ਜਿਨ੍ਹਾਂ ਨੂੰ ਤੂੰ ਮਿਸਰ ਦੇਸ ਤੋਂ ਵੱਡੀ ਸ਼ਕਤੀ ਅਤੇ ਬਲਵੰਤ ਹੱਥ ਨਾਲ ਕੱਢ ਕੇ ਲੈ ਆਇਆ ਹੈਂ। ");
INSERT INTO pan_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","ਮਿਸਰੀ ਕਿਉਂ ਆਖਣ ਕਿ ਉਹ ਉਨ੍ਹਾਂ ਨੂੰ ਬੁਰਿਆਈ ਲਈ ਲੈ ਗਿਆ, ਤਾਂ ਜੋ ਉਨ੍ਹਾਂ ਨੂੰ ਪਹਾੜਾਂ ਵਿੱਚ ਮਾਰ ਸੁੱਟੇ ਅਤੇ ਉਨ੍ਹਾਂ ਨੂੰ ਧਰਤੀ ਉੱਤੋਂ ਮੁਕਾ ਦੇਵੇ? ਤੂੰ ਆਪਣੇ ਕ੍ਰੋਧ ਦੇ ਭੜਕਣ ਨੂੰ ਮੋੜ ਲੈ ਅਤੇ ਆਪਣੇ ਲੋਕਾਂ ਉੱਤੇ ਬੁਰਿਆਈ ਲਿਆਉਣ ਤੋਂ ਹਟ ਜਾ। ");
INSERT INTO pan_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","ਤੂੰ ਆਪਣੇ ਸੇਵਕ ਅਬਰਾਹਾਮ, ਇਸਹਾਕ ਅਤੇ ਇਸਰਾਏਲ ਨੂੰ ਚੇਤੇ ਕਰ ਜਿਨ੍ਹਾਂ ਨਾਲ ਤੂੰ ਆਪਣੀ ਹੀ ਸਹੁੰ ਖਾ ਕੇ ਆਖਿਆ ਸੀ ਕਿ ਮੈਂ ਤੁਹਾਡੀ ਸੰਤਾਨ ਅਕਾਸ਼ ਦੇ ਤਾਰਿਆਂ ਵਾਂਗੂੰ ਵਧਾਵਾਂਗਾ ਅਤੇ ਇਹ ਸਾਰਾ ਦੇਸ ਜਿਸ ਦੇ ਲਈ ਮੈਂ ਆਖਿਆ ਹੈ ਮੈਂ ਉਹ ਤੁਹਾਡੀ ਸੰਤਾਨ ਨੂੰ ਦੇਵਾਂਗਾ ਅਤੇ ਉਹ ਸਦਾ ਲਈ ਉਹ ਦੇ ਅਧਿਕਾਰੀ ਹੋਣਗੇ। ");
INSERT INTO pan_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","ਤਾਂ ਯਹੋਵਾਹ ਉਸ ਬੁਰਿਆਈ ਤੋਂ ਹਟ ਗਿਆ ਜਿਹੜੀ ਆਪਣੇ ਲੋਕਾਂ ਨਾਲ ਕਰਨ ਲਈ ਬੋਲਿਆ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","ਤਾਂ ਮੂਸਾ ਮੁੜ ਕੇ ਪਰਬਤ ਤੋਂ ਹੇਠਾਂ ਨੂੰ ਆਇਆ ਅਤੇ ਨੇਮ ਦੀਆਂ ਦੋ ਫੱਟੀਆਂ ਉਸ ਦੇ ਹੱਥ ਵਿੱਚ ਸਨ। ਉਹ ਫੱਟੀਆਂ ਦੋਹਾਂ ਪਾਸਿਆਂ ਤੋਂ ਲਿਖੀਆਂ ਹੋਈਆਂ ਸਨ ਇੱਕ ਪਾਸਿਓਂ ਅਤੇ ਦੂਜੇ ਪਾਸਿਓਂ ਵੀ ਲਿਖੀਆਂ ਹੋਈਆਂ ਸਨ ");
INSERT INTO pan_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","ਅਤੇ ਫੱਟੀਆਂ ਪਰਮੇਸ਼ੁਰ ਦਾ ਕੰਮ ਸੀ ਅਤੇ ਉਨ੍ਹਾਂ ਦੀ ਲਿਖਤ ਪਰਮੇਸ਼ੁਰ ਦੀ ਲਿਖਤ ਸੀ ਜਿਹੜੀ ਫੱਟੀਆਂ ਉੱਤੇ ਉੱਕਰੀ ਹੋਈ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","ਤਾਂ ਯਹੋਸ਼ੁਆ ਨੇ ਲੋਕਾਂ ਦੀ ਅਵਾਜ਼ ਸੁਣੀ ਜਿਹੜੇ ਡੰਡ ਪਾਉਂਦੇ ਸਨ ਤਾਂ ਉਸ ਨੇ ਮੂਸਾ ਨੂੰ ਆਖਿਆ, ਡੇਰੇ ਵਿੱਚ ਲੜਾਈ ਦੀ ਅਵਾਜ਼ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","ਤਾਂ ਉਸ ਆਖਿਆ, ਇਹ ਰੌਲ਼ਾ ਨਾ ਤਾਂ ਫਤਹ ਪਾਉਣ ਵਾਲਿਆਂ ਦਾ ਹੈ ਅਤੇ ਨਾ ਇਹ ਰੌਲ਼ਾ ਹਾਰਨ ਵਾਲਿਆਂ ਦਾ ਹੈ ਪਰ ਮੈਂ ਗਾਉਣ ਵਾਲਿਆਂ ਦੀ ਅਵਾਜ਼ ਸੁਣਦਾ ਹਾਂ। ");
INSERT INTO pan_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","ਤਾਂ ਇਸ ਤਰ੍ਹਾਂ ਹੋਇਆ ਜਦੋਂ ਉਹ ਡੇਰੇ ਦੇ ਨੇੜੇ ਆਇਆ ਤਾਂ ਉਸ ਨੇ ਵੱਛੇ ਅਤੇ ਨੱਚਣ ਨੂੰ ਵੇਖਿਆ ਤਾਂ ਮੂਸਾ ਦਾ ਕ੍ਰੋਧ ਬਹੁਤ ਭੜਕ ਉੱਠਿਆ ਅਤੇ ਉਸ ਨੇ ਫੱਟੀਆਂ ਆਪਣੇ ਹੱਥਾਂ ਤੋਂ ਸੁੱਟ ਦਿੱਤੀਆਂ ਪਰਬਤ ਦੇ ਹੇਠ ਉਹਨਾਂ ਨੂੰ ਭੰਨ ਸੁੱਟਿਆ ");
INSERT INTO pan_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","ਅਤੇ ਉਸ ਵੱਛੇ ਨੂੰ ਜਿਹੜਾ ਉਨ੍ਹਾਂ ਨੇ ਬਣਾਇਆ ਸੀ ਲੈ ਕੇ ਅੱਗ ਵਿੱਚ ਸਾੜ ਸੁੱਟਿਆ ਅਤੇ ਪੀਹ ਕੇ ਧੂੜ ਜਿਹਾ ਮਹੀਨ ਕਰ ਦਿੱਤਾ ਅਤੇ ਪਾਣੀ ਉੱਤੇ ਖਿਲਾਰ ਦਿੱਤਾ ਅਤੇ ਇਸਰਾਏਲੀਆਂ ਨੂੰ ਪਿਲਾ ਛੱਡਿਆ। ");
INSERT INTO pan_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","ਤਾਂ ਮੂਸਾ ਨੇ ਹਾਰੂਨ ਨੂੰ ਆਖਿਆ, ਤੈਨੂੰ ਇਨ੍ਹਾਂ ਲੋਕਾਂ ਨੇ ਕੀ ਕਰ ਦਿੱਤਾ ਜੋ ਤੂੰ ਉਨ੍ਹਾਂ ਉੱਤੇ ਵੱਡਾ ਪਾਪ ਲਿਆਇਆ? ");
INSERT INTO pan_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","ਅੱਗੋਂ ਹਾਰੂਨ ਨੇ ਆਖਿਆ, ਮੇਰੇ ਸੁਆਮੀ ਦਾ ਕ੍ਰੋਧ ਨਾ ਭੜਕੇ। ਤੂੰ ਲੋਕਾਂ ਨੂੰ ਜਾਣਦਾ ਹੈਂ ਕਿ ਉਹ ਬੁਰਿਆਈ ਉੱਤੇ ਤਿਆਰ ਹਨ ");
INSERT INTO pan_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","ਕਿਉਂ ਜੋ ਉਨ੍ਹਾਂ ਨੇ ਮੈਨੂੰ ਆਖਿਆ, ਸਾਡੇ ਲਈ ਦੇਵਤੇ ਬਣਾ ਜਿਹੜੇ ਸਾਡੇ ਅੱਗੇ ਚੱਲਣ ਕਿਉਂ ਜੋ ਇਹ ਮਰਦ ਮੂਸਾ ਜਿਹੜਾ ਸਾਨੂੰ ਮਿਸਰ ਦੇਸ ਤੋਂ ਉਤਾਹਾਂ ਲੈ ਆਇਆ ਅਸੀਂ ਨਹੀਂ ਜਾਣਦੇ ਕਿ ਉਹ ਨੂੰ ਕੀ ਹੋਇਆ। ");
INSERT INTO pan_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","ਤਾਂ ਮੈਂ ਉਨ੍ਹਾਂ ਨੂੰ ਆਖਿਆ, ਜਿਨ੍ਹਾਂ ਕੋਲ ਸੋਨਾ ਹੈ ਉਹ ਭੰਨਣ ਤੋੜਨ ਤਾਂ ਉਨ੍ਹਾਂ ਨੇ ਮੈਨੂੰ ਦਿੱਤਾ ਅਤੇ ਮੈਂ ਉਸ ਨੂੰ ਅੱਗ ਵਿੱਚ ਸੁੱਟ ਦਿੱਤਾ ਅਤੇ ਇਹ ਵੱਛਾ ਨਿੱਕਲ ਆਇਆ। ");
INSERT INTO pan_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","ਤਦ ਮੂਸਾ ਨੇ ਲੋਕਾਂ ਨੂੰ ਵੇਖਿਆ ਕਿ ਉਹ ਬੇ-ਲਗ਼ਾਮ ਹਨ ਕਿਉਂ ਜੋ ਹਾਰੂਨ ਨੇ ਉਨ੍ਹਾਂ ਦੇ ਵੈਰੀਆਂ ਦੇ ਸਾਹਮਣੇ ਉਨ੍ਹਾਂ ਦਾ ਮਖ਼ੌਲ ਉਡਾਉਣ ਲਈ ਉਨ੍ਹਾਂ ਨੂੰ ਬੇ-ਲਗ਼ਾਮ ਕੀਤਾ। ");
INSERT INTO pan_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","ਮੂਸਾ ਨੇ ਡੇਰੇ ਦੇ ਫਾਟਕ ਕੋਲ ਖੜੇ ਹੋ ਕੇ ਆਖਿਆ, ਜਿਹੜਾ ਯਹੋਵਾਹ ਦੇ ਪਾਸੇ ਵੱਲ ਹੈ ਉਹ ਮੇਰੇ ਕੋਲ ਆਵੇ ਤਾਂ ਸਾਰੇ ਲੇਵੀਆਂ ਨੇ ਆਪਣੇ ਆਪ ਨੂੰ ਉਸ ਦੇ ਕੋਲ ਇਕੱਠਾ ਕਰ ਲਿਆ। ");
INSERT INTO pan_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","ਉਸ ਨੇ ਉਨ੍ਹਾਂ ਨੂੰ ਆਖਿਆ, ਯਹੋਵਾਹ ਇਸਰਾਏਲ ਦਾ ਪਰਮੇਸ਼ੁਰ ਇਸ ਤਰ੍ਹਾਂ ਆਖਦਾ ਹੈ ਕਿ ਸਭ ਮਨੁੱਖ ਆਪਣੀਆਂ ਤਲਵਾਰਾਂ ਲੱਕ ਨਾਲ ਬੰਨ੍ਹ ਕੇ ਡੇਰੇ ਦੇ ਵਿੱਚ ਦੀ ਫਾਟਕ ਤੋਂ ਫਾਟਕ ਤੱਕ ਆਉਂਦੇ ਜਾਂਦੇ ਆਪਣੇ ਭਰਾ ਆਪਣੇ ਸਾਥੀ ਅਤੇ ਆਪਣੇ ਗੁਆਂਢੀ ਨੂੰ ਵੱਢ ਸੁੱਟਣ। ");
INSERT INTO pan_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","ਤਾਂ ਲੇਵੀਆਂ ਨੇ ਮੂਸਾ ਦੇ ਬੋਲ ਅਨੁਸਾਰ ਕੀਤਾ ਅਤੇ ਉਸ ਦਿਨ ਲੋਕਾਂ ਵਿੱਚੋਂ ਤਿੰਨ ਹਜ਼ਾਰ ਮਨੁੱਖ ਡਿੱਗੇ। ");
INSERT INTO pan_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","ਮੂਸਾ ਨੇ ਆਖਿਆ, ਅੱਜ ਤੁਸੀਂ ਆਪਣੇ ਆਪ ਨੂੰ ਯਹੋਵਾਹ ਲਈ ਅਰਪਣ ਕਰੋ। ਹਾਂ, ਹਰ ਇੱਕ ਮਨੁੱਖ ਆਪਣੇ ਪੁੱਤਰ ਅਤੇ ਆਪਣੇ ਭਰਾ ਦੇ ਵਿਰੁੱਧ ਹੋਵੇ ਤਾਂ ਜੋ ਉਹ ਅੱਜ ਤੁਹਾਨੂੰ ਬਰਕਤ ਦੇਵੇ। ");
INSERT INTO pan_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","ਅਗਲੇ ਦਿਨ ਇਸ ਤਰ੍ਹਾਂ ਹੋਇਆ ਕਿ ਮੂਸਾ ਨੇ ਲੋਕਾਂ ਨੂੰ ਆਖਿਆ, ਤੁਸੀਂ ਵੱਡਾ ਪਾਪ ਕੀਤਾ ਅਤੇ ਮੈਂ ਹੁਣ ਯਹੋਵਾਹ ਦੇ ਕੋਲ ਉਤਾਹਾਂ ਜਾਂਦਾ ਹਾਂ। ਸ਼ਾਇਦ ਮੈਂ ਤੁਹਾਡੇ ਪਾਪ ਦਾ ਪ੍ਰਾਸਚਿਤ ਕਰਾਂ। ");
INSERT INTO pan_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","ਸੋ ਮੂਸਾ ਯਹੋਵਾਹ ਦੇ ਕੋਲ ਮੁੜ ਗਿਆ ਅਤੇ ਆਖਿਆ, ਹਾਏ ਇਨ੍ਹਾਂ ਲੋਕਾਂ ਨੇ ਵੱਡਾ ਪਾਪ ਕੀਤਾ ਜੋ ਆਪਣੇ ਲਈ ਸੋਨੇ ਦੇ ਦੇਵਤੇ ਬਣਾਏ ");
INSERT INTO pan_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","ਹੁਣ ਤੂੰ ਉਨ੍ਹਾਂ ਦਾ ਪਾਪ ਮਾਫ਼ ਕਰੀਂ ਅਤੇ ਜੇ ਨਹੀਂ ਤਾਂ ਆਪਣੀ ਪੋਥੀ ਵਿੱਚੋਂ ਜਿਹੜੀ ਤੂੰ ਲਿਖੀ ਹੈ ਮੈਨੂੰ ਮਿਟਾ ਸੁੱਟੀਂ। ");
INSERT INTO pan_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","ਤਾਂ ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਆਖਿਆ, ਜਿਸ ਮੇਰਾ ਪਾਪ ਕੀਤਾ ਮੈਂ ਉਸ ਨੂੰ ਆਪਣੀ ਪੋਥੀ ਵਿੱਚੋਂ ਮਿਟਾ ਸੁੱਟਾਂਗਾ। ");
INSERT INTO pan_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","ਹੁਣ ਜਾ ਲੋਕਾਂ ਨੂੰ ਉੱਥੇ ਲੈ ਜਾ ਜਿਹ ਦੇ ਲਈ ਮੈਂ ਤੈਨੂੰ ਬੋਲਿਆ ਸੀ ਅਤੇ ਵੇਖ ਮੇਰਾ ਦੂਤ ਤੇਰੇ ਅੱਗੇ ਤੁਰੇਗਾ ਪਰ ਮੈਂ ਆਪਣੇ ਬਦਲੇ ਦੇ ਦਿਨ ਉਨ੍ਹਾਂ ਦੇ ਪਾਪ ਦਾ ਬਦਲਾ ਉਨ੍ਹਾਂ ਤੋਂ ਲਵਾਂਗਾ। ");
INSERT INTO pan_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","ਅਤੇ ਯਹੋਵਾਹ ਨੇ ਵੱਛਾ ਬਣਾਉਣ ਦੇ ਕਾਰਨ ਜਿਹ ਨੂੰ ਹਾਰੂਨ ਨੇ ਬਣਾਇਆ ਸੀ ਲੋਕਾਂ ਨੂੰ ਮਾਰਿਆ। ");
INSERT INTO pan_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","ਯਹੋਵਾਹ ਮੂਸਾ ਨੂੰ ਬੋਲਿਆ, ਇੱਥੋਂ ਤੁਰ ਕੇ ਤੂੰ ਅਤੇ ਇਹ ਲੋਕ ਜਿਨ੍ਹਾਂ ਨੂੰ ਤੂੰ ਮਿਸਰ ਦੇਸ ਤੋਂ ਕੱਢ ਲਿਆਇਆ ਉਸ ਦੇਸ ਨੂੰ ਉਤਾਹਾਂ ਜਾਣ ਜਿਹ ਦੇ ਲਈ ਮੈਂ ਅਬਰਾਹਾਮ, ਇਸਹਾਕ ਅਤੇ ਯਾਕੂਬ ਨਾਲ ਸਹੁੰ ਖਾਧੀ ਕਿ ਮੈਂ ਇਹ ਦੇਸ ਤੁਹਾਡੀ ਅੰਸ ਨੂੰ ਦੇਵਾਂਗਾ। ");
INSERT INTO pan_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","ਅਤੇ ਮੈਂ ਤੇਰੇ ਅੱਗੇ ਇੱਕ ਦੂਤ ਭੇਜਾਂਗਾ ਅਤੇ ਮੈਂ ਕਨਾਨੀ, ਅਮੋਰੀ, ਹਿੱਤੀ, ਫ਼ਰਿੱਜ਼ੀ, ਹਿੱਵੀ ਅਤੇ ਯਬੂਸੀਆਂ ਨੂੰ ਧੱਕ ਦੇਵਾਂਗਾ। ");
INSERT INTO pan_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","ਉਸ ਦੇਸ ਵਿੱਚ ਦੁੱਧ ਅਤੇ ਸ਼ਹਿਦ ਵਗਦਾ ਹੈ ਪਰ ਮੈਂ ਤੁਹਾਡੇ ਨਾਲ-ਨਾਲ ਉਤਾਹਾਂ ਨਾ ਜਾਂਵਾਂਗਾ ਕਿਉਂ ਜੋ ਤੁਸੀਂ ਹਾਠੇ ਲੋਕ ਹੀ ਮਤੇ ਮੈਂ ਤੁਹਾਨੂੰ ਰਾਹ ਵਿੱਚ ਭਸਮ ਕਰ ਦਿਆਂ। ");
INSERT INTO pan_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","ਜਦ ਲੋਕਾਂ ਨੇ ਇਹ ਬੁਰੀ ਗੱਲ ਸੁਣੀ ਤਾਂ ਉਨ੍ਹਾਂ ਨੇ ਵਿਰਲਾਪ ਕੀਤਾ ਅਤੇ ਕਿਸੇ ਮਨੁੱਖ ਨੇ ਆਪਣੇ ਗਹਿਣੇ ਨਾ ਪਾਏ। ");
INSERT INTO pan_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","ਤਾਂ ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਆਖਿਆ, ਤੂੰ ਇਸਰਾਏਲੀਆਂ ਨੂੰ ਆਖ ਕਿ ਤੁਸੀਂ ਢੀਠ ਲੋਕ ਹੋ। ਜੇ ਮੈਂ ਇੱਕ ਪਲ ਲਈ ਤੁਹਾਡੇ ਨਾਲ-ਨਾਲ ਉਤਾਹਾਂ ਜਾਂਵਾਂ ਤਾਂ ਮੈਂ ਤੁਹਾਨੂੰ ਭਸਮ ਕਰ ਦੇਵਾਂਗਾ ਪਰ ਹੁਣ ਆਪਣੇ ਗਹਿਣੇ ਆਪ ਤੋਂ ਲਾਹ ਸੁੱਟੋ ਤਾਂ ਜੋ ਮੈਂ ਜਾਣਾਂ ਕਿ ਤੁਹਾਡੇ ਨਾਲ ਕੀ ਕਰਾਂ। ");
INSERT INTO pan_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","ਇਸਰਾਏਲੀਆਂ ਨੇ ਹੋਰੇਬ ਦੇ ਪਰਬਤ ਦੇ ਪਰੇ ਆਪਣੇ ਗਹਿਣੇ ਲਾਹ ਸੁੱਟੇ। ");
INSERT INTO pan_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","ਮੂਸਾ ਇੱਕ ਤੰਬੂ ਲੈ ਕੇ ਡੇਰੇ ਤੋਂ ਬਾਹਰ ਅਤੇ ਦੂਰ ਲਾ ਲੈਂਦਾ ਸੀ ਅਤੇ ਉਸ ਨੂੰ ਮੰਡਲੀ ਦਾ ਤੰਬੂ ਆਖਿਆ ਤਾਂ ਇਸ ਤਰ੍ਹਾਂ ਹੋਇਆ ਕਿ ਜੋ ਕੋਈ ਯਹੋਵਾਹ ਨੂੰ ਭਾਲਦਾ ਸੀ ਸੋ ਮੰਡਲੀ ਦੇ ਤੰਬੂ ਨੂੰ ਡੇਰੇ ਤੋਂ ਬਾਹਰ ਜਾਂਦਾ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","ਅਤੇ ਇਸ ਤਰ੍ਹਾਂ ਸੀ ਕਿ ਜਦ ਮੂਸਾ ਉਸ ਤੰਬੂ ਵਿੱਚ ਜਾਂਦਾ ਸੀ ਤਾਂ ਸਾਰੇ ਲੋਕ ਉੱਠ ਕੇ ਆਪੋ ਆਪਣੇ ਤੰਬੂ ਦੇ ਦਰਵਾਜ਼ੇ ਕੋਲ ਖੜੇ ਹੋ ਜਾਂਦੇ ਸਨ ਅਤੇ ਮੂਸਾ ਨੂੰ ਵੇਖਦੇ ਰਹਿੰਦੇ ਸਨ ਜਿੰਨਾਂ ਚਿਰ ਉਹ ਤੰਬੂ ਦੇ ਵਿੱਚ ਅੰਦਰ ਨਾ ਵੜ ਜਾਂਦਾ। ");
INSERT INTO pan_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","ਅਤੇ ਇਸ ਤਰ੍ਹਾਂ ਸੀ ਕਿ ਜਾਂ ਮੂਸਾ ਤੰਬੂ ਦੇ ਵਿੱਚ ਵੜ ਜਾਂਦਾ ਸੀ ਤਾਂ ਬੱਦਲ ਦਾ ਥੰਮ੍ਹ ਉੱਤਰਦਾ ਸੀ ਅਤੇ ਤੰਬੂ ਦੇ ਦਰਵਾਜ਼ੇ ਉੱਤੇ ਖੜਾ ਹੋ ਜਾਂਦਾ ਸੀ ਤਾਂ ਯਹੋਵਾਹ ਮੂਸਾ ਨਾਲ ਗੱਲ ਕਰਦਾ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","ਜਦ ਸਾਰਿਆਂ ਲੋਕਾਂ ਨੇ ਬੱਦਲ ਦੇ ਥੰਮ੍ਹ ਨੂੰ ਤੰਬੂ ਦੇ ਦਰਵਾਜ਼ੇ ਉੱਤੇ ਖੜਾ ਵੇਖਿਆ ਤਾਂ ਸਾਰੇ ਲੋਕ ਉੱਠ ਖੜੇ ਹੋਏ ਅਤੇ ਆਪੋ ਆਪਣੇ ਤੰਬੂ ਦੇ ਦਰਵਾਜ਼ੇ ਵਿੱਚ ਮੱਥਾ ਟੇਕਿਆ। ");
INSERT INTO pan_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","ਤਾਂ ਯਹੋਵਾਹ ਮੂਸਾ ਨਾਲ ਆਹਮੋ-ਸਾਹਮਣੇ ਗੱਲਾਂ ਕਰਦਾ ਸੀ ਜਿਵੇਂ ਕੋਈ ਮਨੁੱਖ ਆਪਣੇ ਸੱਜਣ ਨਾਲ ਬੋਲਦਾ ਹੈ ਅਤੇ ਉਹ ਫੇਰ ਡੇਰੇ ਨੂੰ ਮੁੜ ਜਾਂਦਾ ਸੀ ਪਰ ਉਸ ਦਾ ਇੱਕ ਗੱਭਰੂ ਸੇਵਾਦਾਰ ਨੂਨ ਦਾ ਪੁੱਤਰ ਯਹੋਸ਼ੁਆ ਤੰਬੂ ਦੇ ਵਿੱਚੋਂ ਨਾ ਹਿੱਲਦਾ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","ਫਿਰ ਮੂਸਾ ਨੇ ਯਹੋਵਾਹ ਨੂੰ ਆਖਿਆ, ਵੇਖ ਤੂੰ ਮੈਨੂੰ ਆਖਦਾ ਹੈਂ ਕਿ ਇਨ੍ਹਾਂ ਲੋਕਾਂ ਨੂੰ ਉਤਾਹਾਂ ਲੈ ਜਾ ਪਰ ਤੂੰ ਮੈਨੂੰ ਨਹੀਂ ਦੱਸਿਆ ਕਿਹ ਨੂੰ ਤੂੰ ਮੇਰੇ ਨਾਲ ਭੇਜੇਂਗਾ ਤਾਂ ਵੀ ਤੂੰ ਆਖਿਆ ਹੈ, ਮੈਂ ਤੈਨੂੰ ਨਾਮ ਤੋਂ ਜਾਣਦਾ ਹਾਂ ਅਤੇ ਮੇਰੀ ਕਿਰਪਾ ਦੀ ਨਿਗਾਹ ਤੇਰੇ ਉੱਤੇ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","ਸੋ ਜੇ ਤੇਰੀ ਕਿਰਪਾ ਦੀ ਨਿਗਾਹ ਮੇਰੇ ਉੱਤੇ ਹੈਂ ਤਾਂ ਮੈਨੂੰ ਆਪਣਾ ਰਾਹ ਦੱਸ ਕਿ ਮੈਂ ਤੈਨੂੰ ਜਾਣਾਂ ਤਾਂ ਜੋ ਤੇਰੀ ਕਿਰਪਾ ਦੀ ਨਿਗਾਹ ਮੇਰੇ ਉੱਤੇ ਰਹੇ ਅਤੇ ਸਮਝ ਲੈ ਕਿ ਇਹ ਕੌਮ ਤੇਰੀ ਪਰਜਾ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","ਤਾਂ ਉਸ ਆਖਿਆ, ਮੇਰੀ ਹਜ਼ੂਰੀ ਤੇਰੇ ਨਾਲ ਜਾਵੇਗੀ ਅਤੇ ਮੈਂ ਤੈਨੂੰ ਵਿਸ਼ਰਾਮ ਦਿਆਂਗਾ। ");
INSERT INTO pan_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","ਫੇਰ ਉਸ ਆਖਿਆ, ਜੇ ਤੇਰੀ ਹਜ਼ੂਰੀ ਸਾਡੇ ਨਾਲ ਨਹੀਂ ਜਾਂਦੀ ਤਾਂ ਸਾਨੂੰ ਇੱਥੋਂ ਉਤਾਹਾਂ ਨਾ ਲੈ ਜਾਵੀਂ। ");
INSERT INTO pan_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","ਫੇਰ ਇਹ ਕਿਵੇਂ ਜਾਣਿਆ ਜਾਵੇਗਾ ਕਿ ਤੇਰੀ ਕਿਰਪਾ ਦੀ ਨਿਗਾਹ ਮੇਰੇ ਉੱਤੇ ਅਤੇ ਤੇਰੀ ਪਰਜਾ ਉੱਤੇ ਹੈ? ਕੀ ਇਹ ਇਸ ਤਰ੍ਹਾਂ ਨਹੀਂ ਕਿ ਤੂੰ ਸਾਡੇ ਨਾਲ ਜਾਂਦਾ ਹੈਂ ਸੋ ਅਸੀਂ ਅਰਥਾਤ ਮੈਂ ਅਤੇ ਤੇਰੀ ਇਹ ਪਰਜਾ ਸਾਰਿਆਂ ਲੋਕਾਂ ਵਿੱਚੋਂ ਜਿਹੜੇ ਜ਼ਮੀਨ ਉੱਤੇ ਹਨ ਅਨੋਖੇ ਰੱਖੇ ਹੋਏ ਹਾਂ? ");
INSERT INTO pan_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਆਖਿਆ, ਜਿਹੜੀ ਗੱਲ ਤੂੰ ਕੀਤੀ ਹੈ ਮੈਂ ਇਹ ਵੀ ਕਰਾਂਗਾ ਕਿਉਂ ਜੋ ਮੇਰੀ ਕਿਰਪਾ ਦੀ ਨਿਗਾਹ ਤੇਰੇ ਉੱਤੇ ਹੈ ਅਤੇ ਮੈਂ ਤੈਨੂੰ ਨਾਮ ਤੋਂ ਜਾਣਦਾ ਹਾਂ। ");
INSERT INTO pan_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","ਤਾਂ ਉਸ ਆਖਿਆ, ਮੈਨੂੰ ਆਪਣਾ ਤੇਜ ਵਿਖਾਈਂ। ");
INSERT INTO pan_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","ਉਸ ਆਖਿਆ, ਮੈਂ ਆਪਣੀ ਸਾਰੀ ਭਲਿਆਈ ਤੇਰੇ ਅੱਗੋਂ ਦੀ ਲੰਘਾਵਾਂਗਾ ਅਤੇ ਤੇਰੇ ਅੱਗੇ ਯਹੋਵਾਹ ਦੇ ਨਾਮ ਦਾ ਪਰਚਾਰ ਕਰਾਂਗਾ ਅਤੇ ਜਿਸ ਉੱਤੇ ਮੈਂ ਦਯਾ ਕਰਨਾ ਚਾਹਾਂ ਉਸ ਉੱਤੇ ਦਯਾ ਕਰਾਂਗਾ ਅਤੇ ਜਿਸ ਉੱਤੇ ਰਹਿਮ ਕਰਨਾ ਚਾਹਾਂ ਉਸ ਉੱਤੇ ਰਹਿਮ ਕਰਾਂਗਾ। ");
INSERT INTO pan_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","ਤਾਂ ਉਸ ਆਖਿਆ, ਤੂੰ ਮੇਰਾ ਮੂੰਹ ਨਹੀਂ ਵੇਖ ਸਕਦਾ ਕਿਉਂ ਜੋ ਕੋਈ ਆਦਮੀ ਮੈਨੂੰ ਵੇਖ ਕੇ ਜੀ ਨਹੀਂ ਸਕਦਾ। ");
INSERT INTO pan_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","ਤਾਂ ਯਹੋਵਾਹ ਨੇ ਆਖਿਆ, ਵੇਖ ਮੇਰੇ ਕੋਲ ਇੱਕ ਥਾਂ ਹੈ ਅਤੇ ਤੂੰ ਇੱਕ ਚੱਟਾਨ ਉੱਤੇ ਖੜਾ ਹੋ ਜਾਵੀਂ ");
INSERT INTO pan_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","ਅਤੇ ਇਸ ਤਰ੍ਹਾਂ ਹੋਵੇਗਾ ਕਿ ਜਦ ਮੇਰਾ ਤੇਜ ਲੰਘ ਜਾਵੇ ਤਾਂ ਮੈਂ ਤੈਨੂੰ ਪੱਥਰ ਦੀ ਇੱਕ ਖੰਧਰ ਵਿੱਚ ਪਾਵਾਂਗਾ ਅਤੇ ਲੰਘਣ ਦੇ ਵੇਲੇ ਮੈਂ ਤੈਨੂੰ ਆਪਣੇ ਹੱਥ ਨਾਲ ਢੱਕਾਂਗਾ ");
INSERT INTO pan_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","ਮੈਂ ਆਪਣਾ ਹੱਥ ਹਟਾਵਾਂਗਾ ਅਤੇ ਤੂੰ ਮੇਰੀ ਪਿੱਠ ਵੇਖੇਂਗਾ ਪਰ ਮੇਰਾ ਮੂੰਹ ਨਾ ਦਿੱਸੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਆਖਿਆ, ਤੂੰ ਪਹਿਲਾਂ ਦੀ ਤਰ੍ਹਾਂ ਪੱਥਰ ਦੀਆਂ ਦੋ ਫੱਟੀਆਂ ਘੜ੍ਹ ਅਤੇ ਮੈਂ ਉਨ੍ਹਾਂ ਫੱਟੀਆਂ ਉੱਤੇ ਉਹ ਗੱਲਾਂ ਲਿਖਾਂਗਾ ਜਿਹੜੀਆਂ ਪਹਿਲੀਆਂ ਫੱਟੀਆਂ ਉੱਤੇ ਸਨ ਜਿਨ੍ਹਾਂ ਨੂੰ ਤੂੰ ਭੰਨ ਸੁੱਟਿਆ। ");
INSERT INTO pan_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","ਸਵੇਰ ਤੋਂ ਤਿਆਰ ਹੋ ਅਤੇ ਸਵੇਰ ਨੂੰ ਸੀਨਈ ਪਰਬਤ ਉੱਤੇ ਚੜ੍ਹ ਅਤੇ ਉੱਥੇ ਪਰਬਤ ਦੀ ਟੀਸੀ ਉੱਤੇ ਮੇਰੇ ਲਈ ਖੜਾ ਰਹਿ। ");
INSERT INTO pan_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","ਤੇਰੇ ਨਾਲ ਕੋਈ ਮਨੁੱਖ ਨਾ ਚੜ੍ਹੇ ਅਤੇ ਸਾਰੇ ਪਰਬਤ ਵਿੱਚ ਕੋਈ ਵੀ ਮਨੁੱਖ ਨਾ ਦਿੱਸੇ ਅਤੇ ਨਾ ਹੀ ਉਸ ਪਰਬਤ ਦੇ ਅੱਗੇ ਇੱਜੜ ਚੁਗੇ ਅਤੇ ਨਾ ਹੀ ਚੌਣਾ। ");
INSERT INTO pan_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","ਉਪਰੰਤ ਉਸ ਨੇ ਪਹਿਲਾਂ ਵਾਂਗੂੰ ਪੱਥਰ ਦੀਆਂ ਦੋ ਫੱਟੀਆਂ ਘੜ੍ਹ ਕੇ ਬਣਾਈਆਂ ਅਤੇ ਮੂਸਾ ਸਵੇਰ ਨੂੰ ਉੱਠ ਕੇ ਸੀਨਈ ਪਰਬਤ ਉੱਤੇ ਚੜ੍ਹ ਗਿਆ ਜਿਵੇਂ ਯਹੋਵਾਹ ਨੇ ਉਸ ਨੂੰ ਹੁਕਮ ਦਿੱਤਾ ਸੀ ਅਤੇ ਆਪਣੇ ਹੱਥ ਵਿੱਚ ਪੱਥਰ ਦੀਆਂ ਦੋ ਫੱਟੀਆਂ ਲਈਆਂ। ");
INSERT INTO pan_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","ਯਹੋਵਾਹ ਬੱਦਲ ਵਿੱਚ ਉੱਤਰਿਆ ਅਤੇ ਉੱਥੇ ਉਸ ਦੇ ਨਾਲ ਖੜੇ ਹੋ ਕੇ ਯਹੋਵਾਹ ਦੇ ਨਾਮ ਦਾ ਪਰਚਾਰ ਕੀਤਾ ");
INSERT INTO pan_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","ਅਤੇ ਯਹੋਵਾਹ ਨੇ ਉਸ ਦੇ ਅੱਗੋਂ ਲੰਘ ਕੇ ਇਸ ਤਰ੍ਹਾਂ ਪਰਚਾਰ ਕੀਤਾ, ਯਹੋਵਾਹ, ਯਹੋਵਾਹ ਦਿਆਲੂ ਅਤੇ ਕਿਰਪਾਲੂ ਪਰਮੇਸ਼ੁਰ ਹੈ ਕ੍ਰੋਧ ਵਿੱਚ ਧੀਰਜੀ ਅਤੇ ਭਲਿਆਈ ਅਤੇ ਸਚਿਆਈ ਨਾਲ ਭਰਪੂਰ ਹੈ ");
INSERT INTO pan_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","ਅਤੇ ਹਜ਼ਾਰਾਂ ਲਈ ਭਲਿਆਈ ਰੱਖਣ ਵਾਲਾ ਹੈ ਅਤੇ ਕੁਧਰਮ ਅਪਰਾਧ ਅਤੇ ਪਾਪ ਦਾ ਬਖ਼ਸ਼ਣਹਾਰ ਅਤੇ ਕੁਧਰਮੀ ਨੂੰ ਇਸੇ ਤਰ੍ਹਾਂ ਨਹੀਂ ਛੱਡਦਾ ਪਰ ਪਿਤਾਵਾਂ ਦਾ ਕੁਧਰਮ ਉਨ੍ਹਾਂ ਦੇ ਪੁੱਤਰਾਂ ਉੱਤੇ ਅਤੇ ਪੁੱਤਰਾਂ ਦੇ ਪੁੱਤਰਾਂ ਉੱਤੇ ਤੀਜੀ ਚੌਥੀ ਪੀੜ੍ਹੀ ਤੱਕ ਬਦਲਾ ਲੈਣ ਹਾਰ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","ਤਾਂ ਮੂਸਾ ਨੇ ਛੇਤੀ ਕਰ ਕੇ ਆਪਣਾ ਸੀਸ ਧਰਤੀ ਉੱਤੇ ਨਿਵਾਇਆ ਅਤੇ ਮੱਥਾ ਟੇਕਿਆ ");
INSERT INTO pan_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","ਅਤੇ ਉਸ ਆਖਿਆ, ਹੇ ਪ੍ਰਭੂ, ਜੇ ਤੇਰੀ ਕਿਰਪਾ ਦੀ ਨਿਗਾਹ ਮੇਰੇ ਉੱਤੇ ਹੈ ਤਾਂ ਪ੍ਰਭੂ ਸਾਡੇ ਨਾਲ ਚੱਲੇ ਭਾਵੇਂ ਇਹ ਹਠੀਏ ਹੀ ਲੋਕ ਹਨ ਅਤੇ ਸਾਡਾ ਕੁਧਰਮ ਅਤੇ ਸਾਡਾ ਪਾਪ ਬਖ਼ਸ਼ੇ ਅਤੇ ਸਾਨੂੰ ਆਪਣਾ ਅਧਿਕਾਰੀ ਬਣਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","ਉਸ ਆਖਿਆ, ਵੇਖ ਮੈਂ ਇੱਕ ਨੇਮ ਬੰਨ੍ਹਦਾ ਹਾਂ। ਤੇਰੇ ਸਾਰੇ ਲੋਕਾਂ ਦੇ ਸਾਹਮਣੇ ਮੈਂ ਅਜਿਹੇ ਅਚਰਜ਼ ਕਰਾਂਗਾ ਜਿਹੜੇ ਨਾ ਸਾਰੀ ਧਰਤੀ ਉੱਤੇ ਨਾ ਕਿਸੇ ਕੌਮ ਵਿੱਚ ਕੀਤੇ ਗਏ ਹੋਣ ਅਤੇ ਸਾਰੇ ਲੋਕ ਜਿਨ੍ਹਾਂ ਦੇ ਵਿੱਚ ਤੂੰ ਹੈਂ ਯਹੋਵਾਹ ਦੇ ਕੰਮ ਨੂੰ ਵੇਖਣਗੇ ਕਿਉਂ ਜੋ ਉਹ ਇੱਕ ਡਰਾਉਣੀ ਗੱਲ ਹੈ ਜਿਹੜੀ ਮੈਂ ਤੇਰੇ ਨਾਲ ਕਰਦਾ ਹਾਂ। ");
INSERT INTO pan_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","ਜੋ ਮੈਂ ਤੈਨੂੰ ਅੱਜ ਦੇ ਦਿਨ ਹੁਕਮ ਦਿੰਦਾ ਹਾਂ ਉਸ ਨੂੰ ਮੰਨੋ ਅਤੇ ਵੇਖ ਮੈਂ ਤੇਰੇ ਅੱਗੇ ਅਮੋਰੀ, ਕਨਾਨੀ, ਹਿੱਤੀ, ਫ਼ਰਿੱਜ਼ੀ, ਹਿੱਵੀ ਅਤੇ ਯਬੂਸੀਆਂ ਨੂੰ ਧੱਕ ਰਿਹਾ ਹਾਂ। ");
INSERT INTO pan_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","ਸੁਚੇਤ ਰਹਿ ਮਤੇ ਤੂੰ ਉਸ ਦੇਸ਼ ਦੇ ਵਸਨੀਕਾਂ ਨਾਲ ਨੇਮ ਬੰਨ੍ਹੇਂ ਜਿੱਥੇ ਤੂੰ ਜਾਂਦਾ ਹੈ ਅਜਿਹਾ ਨਾ ਹੋਵੇ ਜੋ ਉਹ ਤੇਰੇ ਵਿਚਕਾਰ ਇੱਕ ਫਾਹੀ ਹੋਵੇ। ");
INSERT INTO pan_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","ਕਿਉਂ ਜੋ ਤੁਸੀਂ ਉਹਨਾਂ ਦੀਆਂ ਜਗਵੇਦੀਆਂ ਨੂੰ ਢਾਹ ਸੁੱਟਿਓ, ਉਹਨਾਂ ਦੇ ਥੰਮ੍ਹਾਂ ਨੂੰ ਚੂਰ-ਚੂਰ ਕਰ ਦਿਓ, ਉਹਨਾਂ ਦੀ ਅਸ਼ੇਰਾਹ ਦੇਵੀ ਦੇ ਟੁੰਡਾਂ ਨੂੰ ਵੱਢ ਸੁੱਟਿਓ। ");
INSERT INTO pan_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","ਤੂੰ ਹੋਰ ਕਿਸੇ ਦੇਵਤੇ ਅੱਗੇ ਮੱਥਾ ਨਾ ਟੇਕੀਂ। ਯਹੋਵਾਹ ਜਿਸ ਦਾ ਨਾਮ ਗ਼ੈਰਤ ਵਾਲਾ ਹੈ ਉਹ ਇੱਕ ਗ਼ੈਰਤੀ ਪਰਮੇਸ਼ੁਰ ਹੈ ");
INSERT INTO pan_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","ਕਿਤੇ ਤੂੰ ਉਸ ਦੇਸ਼ ਦੇ ਵਸਨੀਕਾਂ ਨਾਲ ਨੇਮ ਬੰਨ੍ਹੇਂ ਅਤੇ ਜਦ ਉਹ ਆਪਣੇ ਦੇਵਤਿਆਂ ਦੇ ਪਿੱਛੇ ਵਿਭਚਾਰ ਕਰਨ ਅਤੇ ਆਪਣੇ ਦੇਵਤਿਆਂ ਨੂੰ ਬਲੀਆਂ ਚੜ੍ਹਾਉਣ ਤਾਂ ਕੋਈ ਤੈਨੂੰ ਸੱਦੇ ਅਤੇ ਤੂੰ ਉਸ ਦੀ ਬਲੀ ਤੋਂ ਖਾਵੇਂ ");
INSERT INTO pan_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","ਅਤੇ ਤੂੰ ਉਨ੍ਹਾਂ ਦੀਆਂ ਧੀਆਂ ਆਪਣੇ ਪੁੱਤਰਾਂ ਲਈ ਲਵੇਂ ਅਤੇ ਉਨ੍ਹਾਂ ਦੀਆਂ ਧੀਆਂ ਆਪਣੇ ਦੇਵਤਿਆਂ ਦੇ ਪਿੱਛੇ ਵਿਭਚਾਰ ਕਰਨ ਅਤੇ ਤੇਰੇ ਪੁੱਤਰਾਂ ਤੋਂ ਵੀ ਆਪਣੇ ਦੇਵਤਿਆਂ ਦੇ ਮਗਰ ਵਿਭਚਾਰ ਕਰਾਉਣ। ");
INSERT INTO pan_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","ਤੂੰ ਆਪਣੇ ਲਈ ਢਾਲ਼ੇ ਹੋਏ ਦੇਵਤੇ ਨਾ ਬਣਾਈਂ। ");
INSERT INTO pan_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","ਪਤੀਰੀ ਰੋਟੀ ਦਾ ਪਰਬ ਮਨਾਈਂ। ਤੂੰ ਸੱਤ ਦਿਨ ਪਤੀਰੀ ਰੋਟੀ ਖਾਵੀਂ ਜਿਵੇਂ ਮੈਂ ਤੈਨੂੰ ਹੁਕਮ ਦਿੱਤਾ ਹੈ ਅਬੀਬ ਦੇ ਮਹੀਨੇ ਦੇ ਠਹਿਰਾਏ ਹੋਏ ਸਮੇਂ ਉੱਤੇ ਕਿਉਂ ਜੋ ਤੂੰ ਅਬੀਬ ਦੇ ਮਹੀਨੇ ਮਿਸਰ ਤੋਂ ਬਾਹਰ ਆਇਆ। ");
INSERT INTO pan_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","ਹਰ ਇੱਕ ਕੁੱਖ ਦਾ ਖੋਲ੍ਹਣ ਵਾਲਾ ਅਤੇ ਤੇਰੇ ਸਾਰੇ ਪਸ਼ੂਆਂ ਵਿੱਚੋਂ ਗਾਈਆਂ ਅਤੇ ਭੇਡਾਂ ਦੇ ਪਹਿਲੌਠੇ ਨਰ ਮੇਰੇ ਹਨ ");
INSERT INTO pan_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","ਪਰ ਗਧੀ ਦੇ ਪਹਿਲੌਠੇ ਤੂੰ ਇੱਕ ਲੇਲੇ ਦੇ ਵੱਟੇ ਛੁਡਾ ਲਵੀਂ ਅਤੇ ਜੇ ਤੂੰ ਉਸ ਨੂੰ ਨਾ ਛੁਡਾਵੇਂ ਤਾਂ ਤੂੰ ਉਸ ਦੀ ਧੌਣ ਭੰਨ ਸੁੱਟੀਂ। ਆਪਣੇ ਪੁੱਤਰਾਂ ਵਿੱਚੋਂ ਹਰ ਇੱਕ ਪਹਿਲੌਠੇ ਨੂੰ ਤੂੰ ਛੁਡਾਵੀਂ ਅਤੇ ਉਹ ਮੇਰੇ ਸਨਮੁਖ ਸੱਖਣੇ ਹੱਥ ਨਾ ਦਿੱਸਣ। ");
INSERT INTO pan_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","ਛੇ ਦਿਨ ਤੂੰ ਕੰਮ ਕਰੀਂ ਪਰ ਸੱਤਵੇਂ ਦਿਨ ਤੂੰ ਵਿਸ਼ਰਾਮ ਕਰੀਂ। ਵਾਹੁਣ ਦੇ ਵੇਲੇ ਅਤੇ ਵੱਢਣ ਦੇ ਵੇਲੇ ਤੂੰ ਵਿਸ਼ਰਾਮ ਕਰੀਂ। ");
INSERT INTO pan_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","ਅਤੇ ਤੂੰ ਹਫ਼ਤਿਆਂ ਦਾ ਪਰਬ ਅਤੇ ਕਣਕ ਦੀ ਫ਼ਸਲ ਦੇ ਪਹਿਲੇ ਫਲ ਅਤੇ ਸਾਲ ਦੇ ਅੰਤ ਵਿੱਚ ਫ਼ਸਲ ਦੇ ਸਾਂਭਣ ਦਾ ਪਰਬ ਮਨਾਈਂ। ");
INSERT INTO pan_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","ਸਾਲ ਵਿੱਚ ਤਿੰਨ ਵਾਰੀ ਤੇਰੇ ਸਾਰੇ ਪੁਰਖ ਪ੍ਰਭੂ ਯਹੋਵਾਹ ਇਸਰਾਏਲ ਦੇ ਪਰਮੇਸ਼ੁਰ ਦੇ ਸਾਹਮਣੇ ਹਾਜ਼ਰ ਹੋਣ। ");
INSERT INTO pan_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","ਕਿਉਂ ਜੋ ਮੈਂ ਤੇਰੇ ਅੱਗੋਂ ਕੌਮਾਂ ਨੂੰ ਕੱਢਾਂਗਾ ਅਤੇ ਤੇਰੀਆਂ ਹੱਦਾਂ ਨੂੰ ਵਧਾਵਾਂਗਾ ਅਤੇ ਕੋਈ ਮਨੁੱਖ ਤੇਰੀ ਧਰਤੀ ਦਾ ਲੋਭ ਨਾ ਕਰੇਗਾ ਜਦ ਤੂੰ ਸਾਲ ਵਿੱਚ ਤਿੰਨ ਵਾਰੀ ਆਪਣੇ ਯਹੋਵਾਹ ਪਰਮੇਸ਼ੁਰ ਦੇ ਸਨਮੁਖ ਹਾਜ਼ਰ ਹੋਵੇਂ। ");
INSERT INTO pan_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","ਤੂੰ ਮੇਰੀ ਬਲੀ ਦਾ ਲਹੂ ਖ਼ਮੀਰੀ ਰੋਟੀ ਨਾਲ ਨਾ ਚੜ੍ਹਾਵੀਂ ਅਤੇ ਨਾ ਪਸਾਹ ਦੇ ਪਰਬ ਦੀ ਬਲੀ ਤੋਂ ਸਵੇਰ ਤੱਕ ਰੱਖ ਛੱਡੀਂ। ");
INSERT INTO pan_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","ਤੂੰ ਆਪਣੀ ਜ਼ਮੀਨ ਦੇ ਪਹਿਲੇ ਫਲਾਂ ਵਿੱਚੋਂ ਪਹਿਲਾ ਫਲ ਯਹੋਵਾਹ ਆਪਣੇ ਪਰਮੇਸ਼ੁਰ ਦੇ ਘਰ ਲਿਆਵੀਂ। ਤੂੰ ਪਠੋਰੇ ਨੂੰ ਉਸ ਦੀ ਮਾਂ ਦੇ ਦੁੱਧ ਵਿੱਚ ਨਾ ਉਬਾਲੀਂ। ");
INSERT INTO pan_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਆਖਿਆ, ਤੂੰ ਇਨ੍ਹਾਂ ਗੱਲਾਂ ਨੂੰ ਲਿਖ ਕਿਉਂ ਜੋ ਇਨ੍ਹਾਂ ਗੱਲਾਂ ਦੇ ਅਨੁਸਾਰ ਮੈਂ ਤੇਰੇ ਅਤੇ ਇਸਰਾਏਲ ਦੇ ਨਾਲ ਨੇਮ ਕੀਤਾ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","ਉਹ ਚਾਲ੍ਹੀ ਦਿਨ ਅਤੇ ਚਾਲ੍ਹੀ ਰਾਤਾਂ ਯਹੋਵਾਹ ਨਾਲ ਉੱਥੇ ਹੀ ਰਿਹਾ। ਨਾ ਉਸ ਰੋਟੀ ਖਾਧੀ ਨਾ ਪਾਣੀ ਪੀਤਾ ਅਤੇ ਉਸ ਨੇ ਉਨ੍ਹਾਂ ਫੱਟੀਆਂ ਉੱਤੇ ਨੇਮ ਦੀਆਂ ਗੱਲਾਂ ਅਰਥਾਤ ਦਸ ਹੁਕਮ ਲਿਖੇ। ");
INSERT INTO pan_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","ਇਸ ਤਰ੍ਹਾਂ ਹੋਇਆ ਕਿ ਜਦ ਮੂਸਾ ਸੀਨਈ ਪਰਬਤ ਤੋਂ ਉੱਤਰਿਆ ਤਾਂ ਮੂਸਾ ਦੇ ਹੱਥ ਵਿੱਚ ਪਰਬਤ ਤੋਂ ਉਤਰਨ ਦੇ ਸਮੇਂ ਸਾਖੀ ਦੀਆਂ ਦੋ ਫੱਟੀਆਂ ਸਨ ਅਤੇ ਮੂਸਾ ਨੂੰ ਮਲੂਮ ਨਾ ਹੋਇਆ ਕਿ ਉਸ ਦਾ ਚਿਹਰਾ ਉਸ ਦੇ ਨਾਲ ਬੋਲਣ ਦੇ ਕਾਰਨ ਚਮਕਦਾ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","ਜਦ ਹਾਰੂਨ ਨੇ ਅਤੇ ਇਸਰਾਏਲੀਆਂ ਨੇ ਮੂਸਾ ਨੂੰ ਵੇਖਿਆ ਤਾਂ ਉਸ ਦਾ ਚਿਹਰਾ ਚਮਕਦਾ ਸੀ ਅਤੇ ਉਹ ਉਸ ਦੇ ਨੇੜੇ ਜਾਣ ਤੋਂ ਡਰੇ। ");
INSERT INTO pan_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","ਮੂਸਾ ਨੇ ਉਨ੍ਹਾਂ ਨੂੰ ਬੁਲਾਇਆ ਅਤੇ ਹਾਰੂਨ ਅਤੇ ਮੰਡਲੀ ਦੇ ਸਾਰੇ ਪ੍ਰਧਾਨ ਉਸ ਦੇ ਕੋਲ ਮੁੜ ਆਏ ਅਤੇ ਮੂਸਾ ਨੇ ਉਨ੍ਹਾਂ ਦੇ ਨਾਲ ਗੱਲਾਂ ਕੀਤੀਆਂ। ");
INSERT INTO pan_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","ਫੇਰ ਸਾਰੇ ਇਸਰਾਏਲੀ ਉਸ ਦੇ ਨੇੜੇ ਆਏ ਤਾਂ ਉਸ ਨੇ ਸਾਰੇ ਹੁਕਮ ਜਿਹੜੇ ਯਹੋਵਾਹ ਨੇ ਉਸ ਨੂੰ ਸੀਨਈ ਪਰਬਤ ਉੱਤੇ ਆਖੇ ਸਨ ਉਨ੍ਹਾਂ ਨੂੰ ਦਿੱਤੇ। ");
INSERT INTO pan_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","ਜਦ ਮੂਸਾ ਉਨ੍ਹਾਂ ਨਾਲ ਗੱਲਾਂ ਕਰ ਚੁੱਕਿਆ ਤਾਂ ਆਪਣੇ ਮੂੰਹ ਉੱਤੇ ਪਰਦਾ ਪਾ ਲਿਆ। ");
INSERT INTO pan_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","ਜਦ ਮੂਸਾ ਯਹੋਵਾਹ ਦੇ ਸਨਮੁਖ ਗੱਲਾਂ ਕਰਨ ਲਈ ਜਾਂਦਾ ਸੀ ਤਾਂ ਪਰਦਾ ਲਾਹ ਸੁੱਟਦਾ ਸੀ ਜਦ ਤੱਕ ਉਹ ਬਾਹਰ ਨਹੀਂ ਸੀ ਆਉਂਦਾ ਅਤੇ ਬਾਹਰ ਆ ਕੇ ਉਹ ਇਸਰਾਏਲੀਆਂ ਨੂੰ ਜੋ ਉਹ ਨੂੰ ਹੁਕਮ ਹੁੰਦਾ ਸੀ ਦੱਸਦਾ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","ਇਸਰਾਏਲੀ ਮੂਸਾ ਦੇ ਮੂੰਹ ਨੂੰ ਵੇਖਦੇ ਸਨ ਕਿ ਮੂਸਾ ਦਾ ਚਿਹਰਾ ਚਮਕਦਾ ਹੈ ਤਾਂ ਮੂਸਾ ਫੇਰ ਆਪਣੇ ਮੂੰਹ ਉੱਤੇ ਪਰਦਾ ਪਾ ਲੈਂਦਾ ਸੀ ਜਦ ਤੱਕ ਉਹ ਦੇ ਨਾਲ ਗੱਲਾਂ ਕਰਨ ਨੂੰ ਅੰਦਰ ਨਾ ਆਉਂਦਾ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","ਮੂਸਾ ਨੇ ਇਸਰਾਏਲੀਆਂ ਦੀ ਸਾਰੀ ਮੰਡਲੀ ਨੂੰ ਇਕੱਠਾ ਕਰ ਕੇ ਉਨ੍ਹਾਂ ਨੂੰ ਆਖਿਆ, ਇਹ ਗੱਲਾਂ ਹਨ ਜਿਨ੍ਹਾਂ ਦੇ ਕਰਨ ਦਾ ਯਹੋਵਾਹ ਨੇ ਤੁਹਾਨੂੰ ਹੁਕਮ ਦਿੱਤਾ ਹੈ ");
INSERT INTO pan_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","ਛੇ ਦਿਨ ਕੰਮ ਕੀਤਾ ਜਾਵੇ ਪਰ ਸੱਤਵਾਂ ਦਿਨ ਤੁਹਾਡਾ ਵਿਸ਼ਰਾਮ ਦਾ ਪਵਿੱਤਰ ਸਬਤ ਯਹੋਵਾਹ ਲਈ ਹੋਵੇ। ਜੋ ਕੋਈ ਉਸ ਵਿੱਚ ਕੰਮ ਕਰੇ ਉਹ ਮਾਰਿਆ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","ਤੁਸੀਂ ਆਪਣੇ ਘਰਾਂ ਵਿੱਚ ਸਬਤ ਦੇ ਦਿਨ ਅੱਗ ਨਾ ਬਾਲਣੀ। ");
INSERT INTO pan_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","ਮੂਸਾ ਨੇ ਇਸਰਾਏਲੀਆਂ ਦੀ ਸਾਰੀ ਮੰਡਲੀ ਨੂੰ ਆਖਿਆ ਕਿ ਜਿਹੜੀ ਗੱਲ ਦਾ ਯਹੋਵਾਹ ਨੇ ਹੁਕਮ ਦਿੱਤਾ ਹੈ ਉਹ ਇਹ ਹੈ ");
INSERT INTO pan_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","ਕਿ ਤੁਸੀਂ ਆਪਣਿਆਂ ਵਿੱਚੋਂ ਯਹੋਵਾਹ ਲਈ ਭੇਟ ਲਿਓ। ਜਿਹ ਦੇ ਮਨ ਦੀ ਭਾਉਣੀ ਹੋਵੇ ਉਹ ਯਹੋਵਾਹ ਲਈ ਭੇਟ ਲਿਆਵੇ - ਸੋਨਾ ਚਾਂਦੀ ਪਿੱਤਲ ");
INSERT INTO pan_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","ਅਤੇ ਨੀਲੇ ਬੈਂਗਣੀ ਕਿਰਮਚੀ ਮਹੀਨ ਕਤਾਨ ਅਤੇ ਪਸ਼ਮ ");
INSERT INTO pan_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","ਛੱਤ੍ਰਿਆਂ ਦੀਆਂ ਲਾਲ ਰੰਗੀਆਂ ਹੋਈਆਂ ਖੱਲਾਂ ਅਤੇ ਸਮੁੰਦਰੀ ਜੀਵ ਦੀਆਂ ਖੱਲਾਂ ਅਤੇ ਸ਼ਿੱਟੀਮ ਦੀ ਲੱਕੜੀ ");
INSERT INTO pan_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","ਅਤੇ ਦੀਵੇ ਦਾ ਤੇਲ ਅਤੇ ਮਸਹ ਕਰਨ ਦੇ ਤੇਲ ਦਾ ਅਤੇ ਸੁਗੰਧੀ ਧੂਪ ਦਾ ਮਸਾਲਾ ");
INSERT INTO pan_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","ਸੁਲੇਮਾਨੀ ਪੱਥਰ ਅਤੇ ਏਫ਼ੋਦ ਅਤੇ ਸੀਨੇ ਬੰਦ ਵਿੱਚ ਜੜਨ ਲਈ ਨਗ। ");
INSERT INTO pan_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","ਤੁਹਾਡੇ ਵਿੱਚੋਂ ਹਰ ਇੱਕ ਸਮਝਦਾਰ ਆਵੇ ਅਤੇ ਸਭ ਕੁਝ ਜਿਹ ਦਾ ਯਹੋਵਾਹ ਨੇ ਹੁਕਮ ਦਿੱਤਾ ਹੈ ਬਣਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","ਡੇਰਾ ਅਤੇ ਉਸ ਦਾ ਤੰਬੂ ਅਤੇ ਉਸ ਦਾ ਢੱਕਣ ਅਤੇ ਉਸ ਦੀਆਂ ਕੁੰਡੀਆਂ ਅਤੇ ਉਸ ਦੇ ਫੱਟੇ ਅਤੇ ਉਸ ਦੇ ਹੋੜੇ ਉਸ ਦੀਆਂ ਥੰਮ੍ਹੀਆਂ ਅਤੇ ਉਸ ਦੀਆਂ ਚੀਥੀਆਂ ");
INSERT INTO pan_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","ਸੰਦੂਕ ਅਤੇ ਉਸ ਦੀਆਂ ਚੋਬਾਂ, ਪ੍ਰਾਸਚਿਤ ਦਾ ਸਰਪੋਸ਼ ਅਤੇ ਓਟ ਦਾ ਪਰਦਾ ");
INSERT INTO pan_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","ਮੇਜ਼ ਅਤੇ ਉਸ ਦੀਆਂ ਚੋਬਾਂ ਅਤੇ ਉਸ ਦੇ ਸਾਰੇ ਭਾਂਡੇ ਅਤੇ ਹਜ਼ੂਰੀ ਦੀ ਰੋਟੀ ");
INSERT INTO pan_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","ਸ਼ਮਾਦਾਨ ਚਾਨਣ ਦੇਣ ਲਈ ਅਤੇ ਉਸ ਦਾ ਸਮਾਨ ਅਤੇ ਉਸ ਦੇ ਦੀਵੇ ਅਤੇ ਚਾਨਣ ਲਈ ਤੇਲ ");
INSERT INTO pan_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","ਧੂਪ ਦੀ ਜਗਵੇਦੀ ਅਤੇ ਉਸ ਦੀਆਂ ਚੋਬਾਂ ਅਤੇ ਮਸਹ ਕਰਨ ਦਾ ਤੇਲ ਸੁਗੰਧੀ ਧੂਪ ਅਤੇ ਡੇਰੇ ਦੇ ਦਰਵਾਜ਼ੇ ਕੋਲ ਦਰਵਾਜ਼ੇ ਦੀ ਓਟ ");
INSERT INTO pan_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","ਅਤੇ ਹੋਮ ਦੀ ਜਗਵੇਦੀ ਅਤੇ ਉਹ ਦੇ ਲਈ ਪਿੱਤਲ ਦੀ ਝੰਜਰੀ ਅਤੇ ਉਹ ਦੀਆਂ ਚੋਬਾਂ ਅਤੇ ਉਸ ਦਾ ਸਾਰਾ ਸਮਾਨ ਹੌਦ ਅਤੇ ਉਸ ਦੀ ਚੌਂਕੀ ");
INSERT INTO pan_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","ਵਿਹੜੇ ਦੀਆਂ ਕਨਾਤਾਂ ਅਤੇ ਉਸ ਦੀਆਂ ਥੰਮ੍ਹੀਆਂ ਅਤੇ ਉਸ ਦੀਆਂ ਚੀਥੀਆਂ ਅਤੇ ਵਿਹੜੇ ਦੇ ਫਾਟਕ ਦੀ ਓਟ ");
INSERT INTO pan_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","ਡੇਰੇ ਦੀਆਂ ਕੀਲੀਆਂ ਅਤੇ ਵਿਹੜੇ ਦੀਆਂ ਕੀਲੀਆਂ ਅਤੇ ਉਨ੍ਹਾਂ ਦੀਆਂ ਲਾਸਾਂ ");
INSERT INTO pan_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","ਅਤੇ ਪਵਿੱਤਰ ਸਥਾਨ ਵਿੱਚ ਉਪਾਸਨਾ ਲਈ ਮਹੀਨ ਉਣਿਆ ਹੋਇਆ ਬਸਤਰ ਅਰਥਾਤ ਹਾਰੂਨ ਜਾਜਕ ਦੇ ਪਵਿੱਤਰ ਬਸਤਰ ਅਤੇ ਉਸ ਦੇ ਪੁੱਤਰਾਂ ਦੇ ਬਸਤਰ ਕਿ ਉਹ ਜਾਜਕਾਈ ਦਾ ਕੰਮ ਕਰਨ। ");
INSERT INTO pan_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","ਇਸਰਾਏਲੀਆਂ ਦੀ ਸਾਰੀ ਮੰਡਲੀ ਮੂਸਾ ਦੇ ਅੱਗੋਂ ਬਾਹਰ ਗਈ ");
INSERT INTO pan_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","ਅਤੇ ਸਾਰੇ ਮਨੁੱਖ ਜਿਨ੍ਹਾਂ ਦੇ ਮਨਾਂ ਨੇ ਉਨ੍ਹਾਂ ਨੂੰ ਪਰੇਰਿਆ, ਆਏ ਅਤੇ ਜਿਨ੍ਹਾਂ ਦੇ ਆਤਮਾ ਨੇ ਉਸ ਦੀ ਭਾਉਣੀ ਕੀਤੀ ਉਹ ਯਹੋਵਾਹ ਲਈ ਭੇਟਾਂ ਮੰਡਲੀ ਦੇ ਤੰਬੂ ਦੇ ਬਣਾਉਣ ਲਈ ਅਤੇ ਉਸ ਦੀ ਸਾਰੀ ਉਪਾਸਨਾ ਲਈ ਅਤੇ ਪਵਿੱਤਰ ਬਸਤ੍ਰਾਂ ਲਈ ਲਿਆਏ। ");
INSERT INTO pan_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","ਮਨੁੱਖ ਅਤੇ ਉਨ੍ਹਾਂ ਦੇ ਨਾਲ ਔਰਤਾਂ ਆਈਆਂ ਅਤੇ ਮਨ ਦੀ ਭਾਉਣੀ ਨਾਲ ਜੁਗਨੀਆਂ, ਨਥਾਂ, ਛਾਪਾਂ ਅਤੇ ਹਾਰ ਸਾਰੇ ਸੋਨੇ ਦੇ ਗਹਿਣੇ ਲਿਆਏ ਅਤੇ ਸਾਰੇ ਮਨੁੱਖਾਂ ਨੇ ਯਹੋਵਾਹ ਲਈ ਸੋਨੇ ਦੀਆਂ ਭੇਟਾਂ ਦਿੱਤੀਆਂ ");
INSERT INTO pan_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","ਅਤੇ ਜਿਨ੍ਹਾਂ ਮਨੁੱਖਾਂ ਕੋਲੋਂ ਨੀਲਾ ਬੈਂਗਣੀ ਅਤੇ ਕਿਰਮਚੀ ਸੂਤ ਅਤੇ ਮਹੀਨ ਕਤਾਨ ਅਤੇ ਪਸ਼ਮ ਅਤੇ ਛੱਤ੍ਰਿਆਂ ਦੀਆਂ ਲਾਲ ਰੰਗੀਆਂ ਹੋਈਆਂ ਖੱਲਾਂ ਅਤੇ ਸਮੁੰਦਰੀ ਜੀਵ ਦੀਆਂ ਖੱਲਾਂ ਲੱਭੀਆਂ, ਉਹ ਲਿਆਏ। ");
INSERT INTO pan_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","ਜਿੰਨਿਆਂ ਨੇ ਚਾਂਦੀ ਅਤੇ ਪਿੱਤਲ ਦੀਆਂ ਭੇਟਾਂ ਚੜ੍ਹਾਉਣੀਆਂ ਚਾਹੀਆਂ ਉਹ ਯਹੋਵਾਹ ਲਈ ਭੇਟਾਂ ਲਿਆਏ ਅਤੇ ਜਿੰਨਿਆਂ ਦੇ ਕੋਲੋਂ ਸ਼ਿੱਟੀਮ ਦੀ ਲੱਕੜੀ ਉਪਾਸਨਾ ਦੇ ਕਿਸੇ ਕੰਮ ਲਈ ਲੱਭੀ ਉਹ ਲਿਆਏ। ");
INSERT INTO pan_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","ਅਤੇ ਸਾਰੀਆਂ ਸਿਆਣੀਆਂ ਇਸਤਰੀਆਂ ਨੇ ਆਪਣੀ ਹੱਥੀਂ ਕੱਤਿਆ ਅਤੇ ਜੋ ਕੱਤਿਆ ਉਹ ਲੈ ਆਈਆਂ, ਅਰਥਾਤ ਨੀਲਾ ਬੈਂਗਣੀ ਅਤੇ ਕਿਰਮਚੀ ਮਹੀਨ ਕਤਾਨ ");
INSERT INTO pan_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","ਅਤੇ ਸਾਰੀਆਂ ਇਸਤਰੀਆਂ ਜਿਨ੍ਹਾਂ ਦੇ ਮਨਾਂ ਨੇ ਉਨ੍ਹਾਂ ਨੂੰ ਬੁੱਧ ਨਾਲ ਪਰੇਰਿਆ ਪਸ਼ਮ ਕੱਤੀ ");
INSERT INTO pan_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","ਅਤੇ ਸਰਦਾਰ ਸੁਲੇਮਾਨੀ ਪੱਥਰ ਅਤੇ ਏਫ਼ੋਦ ਅਤੇ ਸੀਨੇ ਬੰਦ ਵਿੱਚ ਜੜਨ ਲਈ ਨਗ ਲਿਆਏ ");
INSERT INTO pan_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","ਅਤੇ ਮਸਾਲਾ ਅਤੇ ਚਾਨਣੇ ਲਈ ਤੇਲ ਅਤੇ ਮਸਹ ਕਰਨ ਲਈ ਤੇਲ ਅਤੇ ਸੁਗੰਧੀ ਧੂਪ ");
INSERT INTO pan_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","ਅਤੇ ਇਸਰਾਏਲੀਆਂ ਦੇ ਸਾਰੇ ਮਨੁੱਖ ਅਤੇ ਇਸਤਰੀਆਂ ਜਿਨ੍ਹਾਂ ਦੇ ਮਨਾਂ ਨੇ ਉਨ੍ਹਾਂ ਨੂੰ ਪਰੇਰਿਆ ਕਿ ਉਹ ਸਾਰੇ ਕੰਮ ਲਈ ਲਿਆਉਣ ਜਿਹ ਦਾ ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਦੀ ਰਾਹੀਂ ਬਣਾਉਣ ਦਾ ਹੁਕਮ ਦਿੱਤਾ ਸੀ ਉਹ ਯਹੋਵਾਹ ਲਈ ਖੁਸ਼ੀ ਦੀਆਂ ਭੇਟਾਂ ਲਿਆਏ। ");
INSERT INTO pan_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","ਮੂਸਾ ਨੇ ਇਸਰਾਏਲੀਆਂ ਨੂੰ ਆਖਿਆ, ਵੇਖੋ, ਯਹੂਦਾਹ ਦੇ ਗੋਤ ਦੇ ਬਸਲਏਲ ਨੂੰ ਜਿਹੜਾ ਹੂਰ ਦਾ ਪੋਤਾ ਅਤੇ ਊਰੀ ਦਾ ਪੁੱਤਰ ਹੈ, ਯਹੋਵਾਹ ਨੇ ਨਾਮ ਲੈ ਕੇ ਬੁਲਾਇਆ ਹੈ ");
INSERT INTO pan_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","ਅਤੇ ਉਸ ਨੇ ਉਹ ਨੂੰ ਪਰਮੇਸ਼ੁਰ ਦੇ ਆਤਮਾ ਤੋਂ ਬੁੱਧ, ਸਮਝ, ਵਿੱਦਿਆ ਅਤੇ ਸਾਰੀ ਕਾਰੀਗਰੀ ਨਾਲ ਭਰਪੂਰ ਕੀਤਾ ਹੈ ");
INSERT INTO pan_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","ਕਿ ਉਹ ਕਾਰੀਗਰੀ ਦਾ ਕੰਮ ਕੱਢੇ ਅਤੇ ਸੋਨੇ ਚਾਂਦੀ ਅਤੇ ਪਿੱਤਲ ਦਾ ਕੰਮ ਕਰੇ ");
INSERT INTO pan_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","ਅਤੇ ਪੱਥਰਾਂ ਨੂੰ ਜੜਨ ਲਈ ਉੱਕਰੇ ਅਤੇ ਲੱਕੜੀ ਦੀ ਚਿੱਤਰਕਾਰੀ ਕਰੇ ਅਰਥਾਤ ਸਭ ਪਰਕਾਰ ਦੀ ਕਾਰੀਗਰੀ ਨਾਲ ਕੰਮ ਕਰੇ ");
INSERT INTO pan_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","ਅਤੇ ਉਸ ਨੇ ਸਿਖਾਉਣ ਦੀ ਬੁੱਧ ਉਸ ਨੂੰ ਨਾਲੇ ਦਾਨ ਦੇ ਗੋਤ ਦੇ ਅਹੀਸਾਮਾਕ ਦੇ ਪੁੱਤਰ ਆਹਾਲੀਆਬ ਨੂੰ ਦਿੱਤੀ। ");
INSERT INTO pan_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","ਉਸ ਨੇ ਉਨ੍ਹਾਂ ਦੇ ਮਨਾਂ ਨੂੰ ਬੁੱਧ ਨਾਲ ਭਰਪੂਰ ਕੀਤਾ ਕਿ ਉਹ ਹਰ ਪਰਕਾਰ ਦਾ ਕਾਰੀਗਰੀ ਦਾ ਕੰਮ ਕਰਨ ਅਰਥਾਤ ਉੱਕਰਾਵੇ ਦਾ, ਚਤੇਰੇ ਦਾ ਅਤੇ ਕਸੀਦੇਕਾਰ ਦਾ ਅਤੇ ਨੀਲੇ ਬੈਂਗਣੀ ਕਿਰਮਚੀ ਮਹੀਨ ਕਤਾਨ ਦਾ ਅਤੇ ਜੁਲਾਹੇ ਦਾ ਅਤੇ ਸਾਰੀ ਕਾਰੀਗਰੀ ਦੇ ਕਰਨ ਵਾਲਿਆਂ ਦਾ ਅਤੇ ਚਤਰਾਈ ਦੇ ਕੰਮ ਦੇ ਕਰਿੰਦਿਆਂ ਦਾ ਕੰਮ। ");
INSERT INTO pan_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","ਬਸਲਏਲ ਆਹਾਲੀਆਬ ਅਤੇ ਸਾਰੇ ਬੁੱਧਵਾਨ ਮਨੁੱਖ ਕੰਮ ਕਰਨ। ਯਹੋਵਾਹ ਨੇ ਉਨ੍ਹਾਂ ਨੂੰ ਬੁੱਧ ਅਤੇ ਸਮਝ ਦਿੱਤੀ ਕਿ ਉਹ ਜਾਣਨ ਕਿ ਪਵਿੱਤਰ ਸਥਾਨ ਦੀ ਉਪਾਸਨਾ ਦਾ ਸਾਰਾ ਕੰਮ ਯਹੋਵਾਹ ਦੇ ਸਾਰੇ ਹੁਕਮਾਂ ਅਨੁਸਾਰ ਕਿਵੇਂ ਕਰਨਾ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","ਫੇਰ ਮੂਸਾ ਨੇ ਬਸਲਏਲ ਅਤੇ ਆਹਾਲੀਆਬ ਅਤੇ ਸਾਰੇ ਬੁੱਧਵਾਨ ਮਨੁੱਖਾਂ ਨੂੰ ਜਿਨ੍ਹਾਂ ਦੇ ਮਨਾਂ ਵਿੱਚ ਯਹੋਵਾਹ ਨੇ ਬੁੱਧ ਦਿੱਤੀ ਸੀ ਸੱਦਿਆ ਅਰਥਾਤ ਸਾਰੇ ਜਿਨ੍ਹਾਂ ਦੇ ਮਨਾਂ ਨੇ ਉਨ੍ਹਾਂ ਨੂੰ ਪਰੇਰਿਆ ਕਿ ਉਹ ਨੇੜੇ ਆ ਕੇ ਇਹ ਕੰਮ ਕਰਨ ");
INSERT INTO pan_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","ਉਨ੍ਹਾਂ ਨੇ ਮੂਸਾ ਦੇ ਅੱਗੋਂ ਸਾਰੀਆਂ ਭੇਟਾਂ ਨੂੰ ਜਿਨ੍ਹਾਂ ਨੂੰ ਇਸਰਾਏਲੀਆਂ ਨੇ ਪਵਿੱਤਰ ਸਥਾਨ ਦੀ ਉਪਾਸਨਾ ਦੇ ਕੰਮ ਨੂੰ ਪੂਰਾ ਕਰਨ ਲਈ ਲਿਆਂਦਾ ਸੀ ਲੈ ਲਿਆ ਪਰ ਉਹ ਉਸ ਦੇ ਕੋਲ ਹਰ ਸਵੇਰ ਨੂੰ ਖੁਸ਼ੀ ਦੀਆਂ ਭੇਟਾਂ ਵਾਫ਼ਰ ਲਿਆਉਂਦੇ ਰਹੇ। ");
INSERT INTO pan_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","ਤਾਂ ਸਾਰੇ ਬੁੱਧਵਾਨ ਜਿਹੜੇ ਪਵਿੱਤਰ ਸਥਾਨ ਦਾ ਸਾਰਾ ਕੰਮ ਕਰਦੇ ਸਨ ਆਪੋ ਆਪਣੇ ਕੰਮ ਤੋਂ ਜਿਹੜਾ ਉਹ ਕਰਦੇ ਸਨ ਆਏ ");
INSERT INTO pan_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","ਅਤੇ ਉਨ੍ਹਾਂ ਨੇ ਮੂਸਾ ਨੂੰ ਆਖਿਆ ਕਿ ਲੋਕ ਉਪਾਸਨਾ ਦੇ ਕੰਮ ਦੀ ਲੋੜ ਤੋਂ ਜਿਹ ਦਾ ਯਹੋਵਾਹ ਨੇ ਬਣਾਉਣ ਦਾ ਹੁਕਮ ਦਿੱਤਾ ਹੈ ਵਧੇਰੇ ਲਿਆਉਂਦੇ ਹਨ। ");
INSERT INTO pan_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","ਤਾਂ ਮੂਸਾ ਨੇ ਹੁਕਮ ਦਿੱਤਾ ਅਤੇ ਉਨ੍ਹਾਂ ਨੇ ਇਹ ਆਖ ਕੇ ਸਾਰੇ ਡੇਰੇ ਵਿੱਚ ਹੋਕਾ ਫਿਰਾਇਆ ਕਿ ਮਨੁੱਖ ਅਤੇ ਇਸਤਰੀਆਂ ਪਵਿੱਤਰ ਸਥਾਨ ਦੀ ਭੇਟਾਂ ਲਈ ਹੋਰ ਪ੍ਰਬੰਧ ਨਾ ਕਰਨ। ਸੋ ਲੋਕ ਲਿਆਉਣ ਤੋਂ ਹਟ ਗਏ ");
INSERT INTO pan_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","ਕਿਉਂ ਜੋ ਉਸ ਸਾਰੇ ਕੰਮ ਦੇ ਬਣਾਉਣ ਲਈ ਮਸਾਲਾ ਬਹੁਤ ਸੀ ਸਗੋਂ ਵਧੇਰੇ ਵੀ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","ਤਾਂ ਉਨ੍ਹਾਂ ਸਾਰਿਆਂ ਬੁੱਧਵਾਨਾਂ ਨੇ ਜਿਹੜੇ ਇਹ ਕੰਮ ਕਰਦੇ ਸਨ ਡੇਰੇ ਦੇ ਦਸ ਪਰਦੇ ਉਣੀ ਹੋਈ ਮਹੀਨ ਕਤਾਨ ਦੇ ਨੀਲੇ ਬੈਂਗਣੀ ਅਤੇ ਕਿਰਮਚੀ ਰੰਗ ਦੇ ਬਣਾਏ। ਉਸ ਨੇ ਉਨ੍ਹਾਂ ਨੂੰ ਕਰੂਬੀਆਂ ਨਾਲ ਕਾਰੀਗਰੀ ਦਾ ਕੰਮ ਬਣਾਇਆ। ");
INSERT INTO pan_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","ਹਰ ਇੱਕ ਪਰਦੇ ਦੀ ਲੰਬਾਈ ਅਠਾਈ ਹੱਥ ਅਤੇ ਹਰ ਪਰਦੇ ਦੀ ਚੌੜਾਈ ਚਾਰ ਹੱਥ ਸੀ ਅਤੇ ਇੱਕੋ ਹੀ ਨਾਪ ਸਾਰਿਆਂ ਪਰਦਿਆਂ ਦਾ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","ਉਸ ਨੇ ਪੰਜ ਪਰਦੇ ਇੱਕ ਦੂਜੇ ਨਾਲ ਜੋੜੇ ਅਤੇ ਦੂਜੇ ਪੰਜ ਪਰਦੇ ਵੀ ਇੱਕ ਦੂਜੇ ਨਾਲ ਜੋੜੇ ");
INSERT INTO pan_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","ਅਤੇ ਉਸ ਨੇ ਨੀਲੇ ਰੰਗ ਦੇ ਬੀੜੇ ਹਰ ਇੱਕ ਪਰਦੇ ਦੀ ਸੰਜਾਫ਼ ਵਿੱਚ ਜੋੜ ਕੇ ਸਿਰੇ ਵੱਲ ਬਣਾਏ ਅਤੇ ਇਸ ਤਰ੍ਹਾਂ ਹੀ ਉਸ ਪਰਦੇ ਦੀ ਸੰਜਾਫ਼ ਦੇ ਦੂਜੇ ਬਾਹਰਲੇ ਜੋੜ ਦੇ ਸਿਰੇ ਉੱਤੇ ਬਣਾਏ। ");
INSERT INTO pan_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","ਪੰਜਾਹ ਬੀੜੇ ਉਸ ਨੇ ਪਹਿਲੇ ਪਰਦੇ ਵਿੱਚ ਅਤੇ ਪੰਜਾਹ ਬੀੜੇ ਉਸ ਨੇ ਸਿਰੇ ਵੱਲ ਜਿਹੜਾ ਦੂਜੇ ਜੋੜ ਵਿੱਚ ਸੀ ਬਣਾਏ। ਉਹ ਬੀੜੇ ਇੱਕ ਦੂਜੇ ਦੇ ਆਹਮੋ-ਸਾਹਮਣੇ ਸਨ ");
INSERT INTO pan_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","ਅਤੇ ਉਸ ਨੇ ਪੰਜਾਹ ਕੁੰਡੀਆਂ ਸੋਨੇ ਦੀਆਂ ਬਣਾਈਆਂ ਅਤੇ ਪਰਦਿਆਂ ਨੂੰ ਇੱਕ ਦੂਜੇ ਨਾਲ ਕੁੰਡੀਆਂ ਨਾਲ ਜੋੜਿਆ। ਇਸ ਤਰ੍ਹਾਂ ਡੇਰਾ ਇੱਕੋ ਜਿਹਾ ਹੀ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","ਅਤੇ ਉਸ ਨੇ ਪਸ਼ਮ ਦੇ ਪਰਦੇ ਡੇਰੇ ਦੇ ਉੱਪਰਲੇ ਤੰਬੂ ਲਈ ਬਣਾਏ ਅਤੇ ਉਸ ਨੇ ਉਹ ਗਿਆਰ੍ਹਾਂ ਪਰਦੇ ਬਣਾਏ। ");
INSERT INTO pan_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","ਹਰ ਇੱਕ ਪਰਦੇ ਦੀ ਲੰਬਾਈ ਤੀਹ ਹੱਥ ਅਤੇ ਹਰ ਇੱਕ ਪਰਦੇ ਦੀ ਚੌੜਾਈ ਚਾਰ ਹੱਥ ਅਤੇ ਇਹ ਗਿਆਰ੍ਹਾਂ ਪਰਦੇ ਇੱਕੋ ਨਾਪ ਦੇ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","ਉਸ ਨੇ ਪੰਜ ਪਰਦੇ ਵੱਖਰੇ ਜੋੜੇ ਅਤੇ ਛੇ ਪਰਦੇ ਵੱਖਰੇ। ");
INSERT INTO pan_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","ਉਸ ਨੇ ਪੰਜਾਹ ਬੀੜੇ ਉਸ ਪਰਦੇ ਦੀ ਸੰਜਾਫ਼ ਵਿੱਚ ਜਿਹੜੀ ਜੋੜ ਦੇ ਸਿਰੇ ਉੱਤੇ ਸੀ ਅਤੇ ਪੰਜਾਹ ਬੀੜੇ ਦੂਜੇ ਜੋੜ ਦੇ ਪਰਦੇ ਦੀ ਸੰਜਾਫ਼ ਵਿੱਚ ਬਣਾਏ ");
INSERT INTO pan_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","ਅਤੇ ਉਸ ਨੇ ਪੰਜਾਹ ਕੁੰਡੀਆਂ ਪਿੱਤਲ ਦੀਆਂ ਤੰਬੂ ਦੇ ਜੋੜਨ ਲਈ ਬਣਾਈਆਂ ਤਾਂ ਜੋ ਉਹ ਇੱਕੋ ਹੀ ਹੋ ਜਾਵੇ ");
INSERT INTO pan_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","ਅਤੇ ਉਸ ਨੇ ਤੰਬੂ ਦਾ ਢੱਕਣ ਛੱਤ੍ਰਿਆਂ ਦੀਆਂ ਲਾਲ ਰੰਗੀਆਂ ਹੋਈਆਂ ਖੱਲਾਂ ਦਾ ਅਤੇ ਉੱਪਰਲਾ ਢੱਕਣ ਸਮੁੰਦਰੀ ਜੀਵ ਦੀਆਂ ਖੱਲਾਂ ਦਾ ਬਣਾਇਆ। ");
INSERT INTO pan_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","ਉਸ ਨੇ ਸ਼ਿੱਟੀਮ ਦੀ ਲੱਕੜੀ ਦੇ ਖੜਵੇਂ ਫੱਟੇ ਡੇਰੇ ਲਈ ਬਣਾਏ। ");
INSERT INTO pan_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","ਹਰ ਫੱਟੇ ਦੀ ਲੰਬਾਈ ਦਸ ਹੱਥ ਅਤੇ ਹਰ ਫੱਟੇ ਦੀ ਚੌੜਾਈ ਡੇਢ ਹੱਥ ਸੀ ");
INSERT INTO pan_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","ਅਤੇ ਹਰ ਫੱਟੇ ਵਿੱਚ ਦੋ ਚੂਲਾਂ ਇੱਕ ਦੂਜੇ ਨੂੰ ਜੋੜਨ ਲਈ ਸਨ। ਇਸ ਤਰ੍ਹਾਂ ਉਸ ਨੇ ਡੇਰੇ ਦੇ ਸਾਰੇ ਫੱਟੇ ਬਣਾਏ। ");
INSERT INTO pan_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","ਉਸ ਨੇ ਡੇਰੇ ਦੇ ਫੱਟੇ ਇਸ ਤਰ੍ਹਾਂ ਬਣਾਏ - ਵੀਹ ਫੱਟੇ ਦੱਖਣ ਵਾਲੇ ਪਾਸੇ ਲਈ ");
INSERT INTO pan_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","ਅਤੇ ਉਸ ਨੇ ਚਾਂਦੀ ਦੀਆਂ ਚਾਲ੍ਹੀ ਚੀਥੀਆਂ ਉਨ੍ਹਾਂ ਵੀਹਾਂ ਫੱਟਿਆਂ ਦੇ ਹੇਠ ਅਰਥਾਤ ਹਰ ਇੱਕ ਫੱਟੇ ਹੇਠ ਦੋ ਚੀਥੀਆਂ ਉਨ੍ਹਾਂ ਦੀਆਂ ਦੋਹਾਂ ਚੂਲਾਂ ਲਈ ਬਣਾਈਆਂ ਅਤੇ ਦੂਜੇ ਫੱਟੇ ਲਈ ਦੋ ਚੀਥੀਆਂ ਉਸ ਦੀਆਂ ਦੋਹਾਂ ਚੂਲਾਂ ਲਈ। ");
INSERT INTO pan_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","ਅਤੇ ਡੇਰੇ ਦੇ ਦੂਜੇ ਪਾਸੇ ਲਈ ਉੱਤਰ ਵੱਲ ਵੀਹ ਫੱਟੇ ਬਣਾਏ ");
INSERT INTO pan_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","ਅਤੇ ਉਨ੍ਹਾਂ ਦੀਆਂ ਚਾਂਦੀ ਦੀਆਂ ਚਾਲ੍ਹੀ ਚੀਥੀਆਂ ਅਰਥਾਤ ਹਰ ਇੱਕ ਫੱਟੇ ਹੇਠ ਦੋ ਚੀਥੀਆਂ ");
INSERT INTO pan_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","ਅਤੇ ਡੇਰੇ ਦੇ ਸਿਰੇ ਤੇ ਪੱਛਮ ਵਾਲੇ ਪਾਸੇ ਵੱਲ ਉਸ ਨੇ ਛੇ ਫੱਟੇ ਬਣਾਏ। ");
INSERT INTO pan_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","ਉਸ ਨੇ ਦੋ ਫੱਟੇ ਡੇਰੇ ਦੇ ਪਿਛਵਾੜੇ ਦੇ ਖੂੰਜਿਆਂ ਲਈ ਬਣਾਏ। ");
INSERT INTO pan_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","ਉਹ ਹੇਠੋਂ ਦੋਹਰੇ ਸਨ ਅਤੇ ਉਹ ਇਸ ਪਰਕਾਰ ਆਪਣਿਆਂ ਸਿਰਿਆਂ ਤੱਕ ਇੱਕ ਕੜੇ ਨਾਲ ਸਾਬਤ ਰਹਿੰਦੇ ਸਨ। ਇਸ ਤਰ੍ਹਾਂ ਉਸ ਨੇ ਉਨ੍ਹਾਂ ਦੋਹਾਂ ਨੂੰ ਦੋਹਾਂ ਖੂੰਜਿਆਂ ਵਿੱਚ ਬਣਾਇਆ ");
INSERT INTO pan_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","ਅਤੇ ਉਹ ਅੱਠ ਫੱਟੇ ਸਨ ਅਤੇ ਉਨ੍ਹਾਂ ਦੀਆਂ ਚਾਂਦੀ ਦੀਆਂ ਸੋਲਾਂ ਚੀਥੀਆਂ ਸਨ ਅਰਥਾਤ ਹਰ ਇੱਕ ਫੱਟੇ ਹੇਠ ਦੋ ਚੀਥੀਆਂ। ");
INSERT INTO pan_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","ਅਤੇ ਉਸ ਨੇ ਸ਼ਿੱਟੀਮ ਦੀ ਲੱਕੜੀ ਦੇ ਹੋੜੇ ਬਣਾਏ ਡੇਰੇ ਦੇ ਇੱਕ ਪਾਸੇ ਦੇ ਫੱਟਿਆਂ ਲਈ ਪੰਜ ਹੋੜੇ ਅਤੇ ਦੂਜੇ ਪਾਸੇ ਦੇ ਫੱਟਿਆਂ ਲਈ ਪੰਜ ਹੋੜੇ ");
INSERT INTO pan_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","ਅਤੇ ਡੇਰੇ ਦੇ ਪਿਛਵਾੜੇ ਲਹਿੰਦੇ ਪਾਸੇ ਦੇ ਫੱਟਿਆਂ ਲਈ ਪੰਜ ਹੋੜੇ ");
INSERT INTO pan_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","ਅਤੇ ਵਿਚਲਾ ਹੋੜਾ ਫੱਟਿਆਂ ਦੇ ਵਿਚਕਾਰੋਂ ਆਰ-ਪਾਰ ਲੰਘਾਇਆ ");
INSERT INTO pan_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","ਅਤੇ ਉਸ ਨੇ ਫੱਟਿਆਂ ਨੂੰ ਸੋਨੇ ਨਾਲ ਮੜ੍ਹਿਆ ਅਤੇ ਹੋੜਿਆਂ ਦੇ ਥਾਵਾਂ ਲਈ ਸੋਨੇ ਦੇ ਕੜੇ ਬਣਾਏ ਅਤੇ ਉਸ ਨੇ ਹੋੜਿਆਂ ਨੂੰ ਸੋਨੇ ਨਾਲ ਮੜ੍ਹਿਆ। ");
INSERT INTO pan_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","ਉਸ ਨੇ ਨੀਲੇ, ਬੈਂਗਣੀ, ਕਿਰਮਚੀ ਅਤੇ ਮਹੀਨ ਉਣੇ ਹੋਏ ਕਤਾਨ ਦਾ ਇੱਕ ਪਰਦਾ ਬਣਾਇਆ। ਉਸ ਨੇ ਉਹ ਨੂੰ ਕਰੂਬੀਆਂ ਨਾਲ ਕਾਰੀਗਰੀ ਦਾ ਕੰਮ ਬਣਾਇਆ। ");
INSERT INTO pan_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","ਉਸ ਨੇ ਸ਼ਿੱਟੀਮ ਦੀ ਲੱਕੜੀ ਦੀਆਂ ਚਾਰ ਥੰਮ੍ਹੀਆਂ ਬਣਾਈਆਂ ਅਤੇ ਉਨ੍ਹਾਂ ਨੂੰ ਸੋਨੇ ਨਾਲ ਮੜ੍ਹਿਆ ਅਤੇ ਉਨ੍ਹਾਂ ਦੇ ਕੁੰਡੇ ਸੋਨੇ ਦੇ ਸਨ ਅਤੇ ਉਸ ਨੇ ਚਾਂਦੀ ਦੀਆਂ ਚਾਰ ਚੀਥੀਆਂ ਉਨ੍ਹਾਂ ਲਈ ਢਾਲੀਆਂ। ");
INSERT INTO pan_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","ਅਤੇ ਉਸ ਨੇ ਤੰਬੂ ਦੇ ਦਰਵਾਜ਼ੇ ਲਈ ਇੱਕ ਓਟ ਨੀਲੇ ਬੈਂਗਣੀ ਅਤੇ ਕਿਰਮਚੀ ਰੰਗ ਦੇ ਮਹੀਨ ਉਣੇ ਹੋਏ ਕਤਾਨ ਦੀ ਬਣਾਈ। ਇਹ ਕਸੀਦੇਕਾਰ ਦਾ ਕੰਮ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","ਉਸ ਨੇ ਪੰਜ ਥੰਮ੍ਹੀਆਂ ਉਹ ਦੇ ਲਈ ਕੁੰਡਿਆਂ ਸਣੇ ਬਣਾਈਆਂ ਅਤੇ ਉਨ੍ਹਾਂ ਦੇ ਸਿਰਿਆਂ ਅਤੇ ਕੜਿਆਂ ਨੂੰ ਸੋਨੇ ਨਾਲ ਮੜ੍ਹਿਆ ਅਤੇ ਉਨ੍ਹਾਂ ਦੀਆਂ ਪੰਜ ਚੀਥੀਆਂ ਪਿੱਤਲ ਦੀਆਂ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","ਬਸਲਏਲ ਨੇ ਸ਼ਿੱਟੀਮ ਦੀ ਲੱਕੜੀ ਦਾ ਇੱਕ ਸੰਦੂਕ ਬਣਾਇਆ ਜਿਸ ਦੀ ਲੰਬਾਈ ਢਾਈ ਹੱਥ ਚੌੜਾਈ ਡੇਢ ਹੱਥ ਅਤੇ ਉਚਾਈ ਡੇਢ ਹੱਥ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","ਅਤੇ ਉਸ ਨੇ ਉਸ ਨੂੰ ਅੰਦਰੋਂ ਬਾਹਰੋਂ ਕੁੰਦਨ ਸੋਨੇ ਨਾਲ ਮੜ੍ਹਿਆ ਅਤੇ ਉਸ ਦੇ ਉੱਤੇ ਚੁਫ਼ੇਰੇ ਸੋਨੇ ਦੀ ਬਨੇਰੀ ਬਣਾਈ ");
INSERT INTO pan_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","ਅਤੇ ਉਸ ਦੇ ਲਈ ਸੋਨੇ ਦੇ ਚਾਰ ਕੜੇ ਢਾਲ਼ ਕੇ ਉਸ ਦੀਆਂ ਚੌਹਾਂ ਨੁੱਕਰਾਂ ਉੱਤੇ ਬਣਾਏ ਅਰਥਾਤ ਦੋ ਕੜੇ ਇੱਕ ਪਾਸੇ ਅਤੇ ਦੋ ਕੜੇ ਦੂਜੇ ਪਾਸੇ। ");
INSERT INTO pan_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","ਅਤੇ ਉਸ ਨੇ ਸ਼ਿੱਟੀਮ ਦੀ ਲੱਕੜੀ ਦੀਆਂ ਚੋਬਾਂ ਬਣਾਈਆਂ ਅਤੇ ਉਨ੍ਹਾਂ ਉੱਤੇ ਸੋਨਾ ਮੜ੍ਹਿਆ। ");
INSERT INTO pan_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","ਉਸ ਨੇ ਉਨ੍ਹਾਂ ਚੋਬਾਂ ਨੂੰ ਸੰਦੂਕ ਦੇ ਪਾਸਿਆਂ ਦੇ ਕੜਿਆਂ ਵਿੱਚ ਪਾਇਆ ਤਾਂ ਜੋ ਉਨ੍ਹਾਂ ਨਾਲ ਸੰਦੂਕ ਚੁੱਕਿਆ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","ਅਤੇ ਉਸ ਨੇ ਪ੍ਰਾਸਚਿਤ ਦਾ ਸਰਪੋਸ਼ ਕੁੰਦਨ ਸੋਨੇ ਦਾ ਬਣਾਇਆ ਜਿਸ ਦੀ ਲੰਬਾਈ ਢਾਈ ਹੱਥ ਅਤੇ ਚੌੜਾਈ ਡੇਢ ਹੱਥ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","ਅਤੇ ਉਸ ਨੇ ਸੋਨੇ ਦੇ ਦੋ ਕਰੂਬੀ ਬਣਾਏ। ਉਸ ਨੇ ਉਨ੍ਹਾਂ ਨੂੰ ਘੜ੍ਹ ਕੇ ਪ੍ਰਾਸਚਿਤ ਦੇ ਸਰਪੋਸ਼ ਦੇ ਦੋਹਾਂ ਸਿਰਿਆਂ ਤੇ ਬਣਾਇਆ। ");
INSERT INTO pan_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","ਇੱਕ ਕਰੂਬੀ ਇੱਕ ਸਿਰੇ ਤੇ ਅਤੇ ਦੂਜਾ ਕਰੂਬੀ ਦੂਜੇ ਸਿਰੇ ਤੇ। ਉਸ ਨੇ ਕਰੂਬੀ ਪ੍ਰਾਸਚਿਤ ਦੇ ਸਰਪੋਸ਼ ਦੇ ਦੋਹਾਂ ਪਾਸਿਆਂ ਉੱਤੇ ਉਸੇ ਤੋਂ ਬਣਾਏ ");
INSERT INTO pan_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","ਅਤੇ ਉਹ ਕਰੂਬੀ ਆਪਣੇ ਖੰਭ ਉਤਾਹਾਂ ਨੂੰ ਖਿਲਾਰੇ ਹੋਏ ਸਨ ਅਤੇ ਉਨ੍ਹਾਂ ਦੇ ਖੰਭ ਪ੍ਰਾਸਚਿਤ ਦੇ ਸਰਪੋਸ਼ ਨੂੰ ਢੱਕਦੇ ਸਨ ਅਤੇ ਉਨ੍ਹਾਂ ਦੇ ਮੂੰਹ ਆਹਮੋ-ਸਾਹਮਣੇ ਸਨ ਅਤੇ ਕਰੂਬੀਆਂ ਦੇ ਮੂੰਹ ਪ੍ਰਾਸਚਿਤ ਦੇ ਸਰਪੋਸ਼ ਵੱਲ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","ਉਸ ਨੇ ਸ਼ਿੱਟੀਮ ਦੀ ਲੱਕੜੀ ਦਾ ਇੱਕ ਮੇਜ਼ ਬਣਾਇਆ। ਉਸ ਦੀ ਲੰਬਾਈ ਦੋ ਹੱਥ ਅਤੇ ਉਸ ਦੀ ਚੌੜਾਈ ਇੱਕ ਹੱਥ ਅਤੇ ਉਸ ਦੀ ਉਚਾਈ ਡੇਢ ਹੱਥ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","ਅਤੇ ਉਸ ਨੂੰ ਕੁੰਦਨ ਸੋਨੇ ਨਾਲ ਮੜ੍ਹਿਆ ਅਤੇ ਉਸ ਦੇ ਚੁਫ਼ੇਰੇ ਸੋਨੇ ਦੀ ਬਨੇਰੀ ਬਣਾਈ। ");
INSERT INTO pan_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","ਉਸ ਨੇ ਉਹ ਦੇ ਲਈ ਇੱਕ ਚੱਪਾ ਭਰ ਕਿਨਾਰੀ ਚੁਫ਼ੇਰੇ ਬਣਾਈ ਅਤੇ ਉਸ ਨੇ ਸੋਨੇ ਦੀ ਬਨੇਰੀ ਕਿਨਾਰੀ ਦੇ ਚੁਫ਼ੇਰੇ ਬਣਾਈ। ");
INSERT INTO pan_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","ਉਸ ਨੇ ਉਹ ਦੇ ਲਈ ਸੋਨੇ ਦੇ ਚਾਰ ਕੜੇ ਢਾਲ਼ ਕੇ ਬਣਾਏ ਅਤੇ ਉਸ ਨੇ ਉਨ੍ਹਾਂ ਕੜਿਆਂ ਨੂੰ ਉਹ ਦੇ ਚੌਹਾਂ ਖੂੰਜਿਆਂ ਉੱਤੇ ਜਿਹੜੇ ਚੌਹਾਂ ਪਾਵਿਆਂ ਉੱਤੇ ਸਨ ਪਾ ਦਿੱਤਾ। ");
INSERT INTO pan_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","ਕਿਨਾਰੀ ਦੇ ਕੋਲ ਹੀ ਕੜੇ ਸਨ ਅਤੇ ਉਹ ਮੇਜ਼ ਦੇ ਚੁੱਕਣ ਨੂੰ ਚੋਬਾਂ ਪਾਉਣ ਲਈ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","ਅਤੇ ਉਸ ਨੇ ਚੋਬਾਂ ਸ਼ਿੱਟੀਮ ਦੀ ਲੱਕੜੀ ਤੋਂ ਬਣਾਈਆਂ ਅਤੇ ਉਸ ਨੇ ਉਨ੍ਹਾਂ ਨੂੰ ਸੋਨੇ ਨਾਲ ਮੜ੍ਹਿਆ ਤਾਂ ਜੋ ਮੇਜ਼ ਚੁੱਕੀ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","ਉਸ ਨੇ ਮੇਜ਼ ਦੇ ਉੱਪਰਲੇ ਭਾਂਡੇ ਕੁੰਦਨ ਸੋਨੇ ਦੇ ਬਣਾਏ ਅਰਥਾਤ ਉਸ ਦੀਆਂ ਥਾਲੀਆਂ, ਚਮਚੇ, ਗੜਵੇ ਅਤੇ ਡੋਲ੍ਹਣ ਦੇ ਕਟੋਰੇ। ");
INSERT INTO pan_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","ਉਸ ਨੇ ਸ਼ਮਾਦਾਨ ਕੁੰਦਨ ਸੋਨੇ ਦਾ ਬਣਾਇਆ ਅਤੇ ਉਹ ਸ਼ਮਾਦਾਨ ਘੜ੍ਹ ਕੇ ਬਣਾਇਆ। ਉਸ ਦਾ ਪਾਏਦਾਨ ਅਤੇ ਡੰਡਾ ਅਤੇ ਕਟੋਰੇ ਅਤੇ ਗੋਲੇ ਅਤੇ ਫੁੱਲ ਉਸ ਵਿੱਚੋਂ ਹੀ ਸਨ ");
INSERT INTO pan_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","ਅਤੇ ਛੇ ਟਹਿਣੀਆਂ ਉਸ ਦੇ ਦੋਹਾਂ ਪਾਸਿਆਂ ਤੋਂ ਨਿੱਕਲਦੀਆਂ ਸਨ। ਸ਼ਮਾਦਾਨ ਦੇ ਇੱਕ ਪਾਸਿਓਂ ਤਿੰਨ ਟਹਿਣੀਆਂ ਅਤੇ ਸ਼ਮਾਦਾਨ ਦੇ ਦੂਜੇ ਪਾਸਿਓਂ ਤਿੰਨ ਟਹਿਣੀਆਂ। ");
INSERT INTO pan_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","ਇੱਕ ਟਹਿਣੀ ਉੱਤੇ ਤਿੰਨ ਕਟੋਰੇ ਬਦਾਮ ਦੇ ਫੁੱਲਾਂ ਵਰਗੇ ਅਤੇ ਗੋਲੇ ਅਤੇ ਫੁੱਲ ਅਤੇ ਦੂਜੀ ਟਹਿਣੀ ਉੱਤੇ ਤਿੰਨ ਕਟੋਰੇ ਬਦਾਮ ਦੇ ਫੁੱਲਾਂ ਵਰਗੇ ਅਤੇ ਗੋਲੇ ਅਤੇ ਫੁੱਲ ਸਨ ਅਤੇ ਇਸ ਤਰ੍ਹਾਂ ਹੀ ਛੇਆਂ ਟਹਿਣੀਆਂ ਲਈ ਸੀ ਜਿਹੜੀਆਂ ਸ਼ਮਾਦਾਨ ਤੋਂ ਨਿੱਕਲਦੀਆਂ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","ਅਤੇ ਸ਼ਮਾਦਾਨ ਵਿੱਚ ਚਾਰ ਕਟੋਰੇ ਬਦਾਮ ਦੇ ਫੁੱਲਾਂ ਵਰਗੇ ਅਤੇ ਉਹ ਦੇ ਗੋਲੇ ਅਤੇ ਉਹ ਦੇ ਫੁੱਲ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","ਉਸ ਤੋਂ ਦੋਹਾਂ ਟਹਿਣੀਆਂ ਹੇਠ ਇੱਕ ਗੋਲਾ ਅਤੇ ਫੇਰ ਉਸ ਤੋਂ ਦੋਹਾਂ ਟਹਿਣੀਆਂ ਹੇਠ ਇੱਕ ਗੋਲਾ ਅਤੇ ਉਸ ਤੋਂ ਫੇਰ ਦੋਹਾਂ ਟਹਿਣੀਆਂ ਹੇਠ ਇੱਕ ਗੋਲਾ ਇਸ ਤਰ੍ਹਾਂ ਉਨ੍ਹਾਂ ਛੇਆਂ ਟਹਿਣੀਆਂ ਲਈ ਸੀ ਜਿਹੜੀਆਂ ਉਸ ਤੋਂ ਨਿੱਕਲਦੀਆਂ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","ਉਨ੍ਹਾਂ ਦੇ ਗੋਲੇ ਅਤੇ ਉਨ੍ਹਾਂ ਦੀਆਂ ਟਹਿਣੀਆਂ ਉਸੇ ਤੋਂ ਸਨ ਅਰਥਾਤ ਇਹ ਸਾਰਾ ਘੜਿਆ ਹੋਇਆ ਕੁੰਦਨ ਸੋਨੇ ਦੇ ਇੱਕ ਟੁੱਕੜੇ ਤੋਂ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","ਉਸ ਦੇ ਉਸ ਨੇ ਸੱਤ ਦੀਵੇ ਬਣਾਏ ਅਤੇ ਉਸ ਦੇ ਗੁਲਤਰਾਸ਼ ਅਤੇ ਉਸ ਦੇ ਗੁਲਦਾਨ ਕੁੰਦਨ ਸੋਨੇ ਦੇ ਸਨ ");
INSERT INTO pan_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","ਅਤੇ ਉਸ ਨੇ ਇੱਕ ਮਣ ਦੇ ਲੱਗਭੱਗ ਕੁੰਦਨ ਸੋਨੇ ਤੋਂ ਇਹ ਸਾਰੇ ਭਾਂਡੇ ਬਣਾਏ। ");
INSERT INTO pan_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","ਉਸ ਨੇ ਸ਼ਿੱਟੀਮ ਦੀ ਲੱਕੜੀ ਤੋਂ ਧੂਪ ਦੀ ਇੱਕ ਜਗਵੇਦੀ ਬਣਾਈ। ਉਸ ਦੀ ਲੰਬਾਈ ਇੱਕ ਹੱਥ ਅਤੇ ਉਸ ਦੀ ਚੌੜਾਈ ਇੱਕ ਹੱਥ ਅਤੇ ਉਹ ਚੌਰਸ ਸੀ ਅਤੇ ਦੋ ਹੱਥ ਉਸ ਦੀ ਉਚਾਈ ਸੀ ਅਤੇ ਉਸ ਦੇ ਸਿੰਙ ਉਸੇ ਤੋਂ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","ਉਸ ਨੇ ਉਹ ਨੂੰ ਖ਼ਾਲਸ ਸੋਨੇ ਨਾਲ ਮੜ੍ਹਿਆ ਅਰਥਾਤ ਉਹ ਦਾ ਉੱਪਰਲਾ ਪਾਸਾ ਅਤੇ ਉਹ ਦੇ ਚੁਫ਼ੇਰੇ ਦੇ ਪਾਸੇ ਅਤੇ ਉਸ ਦੇ ਸਿੰਙ। ਉਸ ਨੇ ਉਹ ਦੇ ਚੁਫ਼ੇਰੇ ਇੱਕ ਸੋਨੇ ਦੀ ਬਨੇਰੀ ਬਣਾਈ ");
INSERT INTO pan_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","ਅਤੇ ਉਸ ਲਈ ਸੋਨੇ ਦੇ ਦੋ ਕੜੇ ਉਸ ਦੀ ਬਨੇਰੀ ਦੇ ਹੇਠ ਉਸ ਦੇ ਦੋਹਾਂ ਪੱਲਿਆਂ ਉੱਤੇ ਅਤੇ ਉਸ ਦੀ ਦੋਹੀਂ ਪਾਸੀਂ ਬਣਾਏ। ਉਸ ਨੂੰ ਚੁੱਕਣ ਲਈ ਚੋਬਾਂ ਦੇ ਥਾਂ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","ਉਸ ਨੇ ਚੋਬਾਂ ਸ਼ਿੱਟੀਮ ਦੀ ਲੱਕੜੀ ਤੋਂ ਬਣਾਈਆਂ ਅਤੇ ਉਨ੍ਹਾਂ ਨੂੰ ਸੋਨੇ ਨਾਲ ਮੜ੍ਹਿਆ। ");
INSERT INTO pan_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","ਉਸ ਨੇ ਮਸਹ ਕਰਨ ਦਾ ਪਵਿੱਤਰ ਤੇਲ ਅਤੇ ਨਿਰੋਲ ਸੁਗੰਧੀ ਧੂਪ ਨੂੰ ਗਾਂਧੀ ਦੀ ਕਾਰੀਗਰੀ ਦੇ ਅਨੁਸਾਰ ਬਣਾਇਆ। ");
INSERT INTO pan_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","ਉਸ ਨੇ ਹੋਮ ਦੀ ਜਗਵੇਦੀ ਸ਼ਿੱਟੀਮ ਦੀ ਲੱਕੜੀ ਦੀ ਬਣਾਈ। ਉਸ ਦੀ ਲੰਬਾਈ ਪੰਜ ਹੱਥ ਉਸ ਦੀ ਚੌੜਾਈ ਪੰਜ ਹੱਥ ਅਤੇ ਉਹ ਚੌਰਸ ਸੀ ਅਤੇ ਉਸ ਦੀ ਉਚਾਈ ਤਿੰਨ ਹੱਥ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","ਉਸ ਨੇ ਉਸ ਦੇ ਸਿੰਗ ਉਸੇ ਤੋਂ ਉਸ ਦੇ ਚੌਹਾਂ ਖੂੰਜਿਆਂ ਉੱਤੇ ਬਣਾਏ ਅਤੇ ਉਸ ਨੂੰ ਪਿੱਤਲ ਨਾਲ ਮੜ੍ਹਿਆ। ");
INSERT INTO pan_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","ਜਗਵੇਦੀ ਦਾ ਸਾਰਾ ਸਮਾਨ ਉਸ ਨੇ ਬਣਾਇਆ ਅਰਥਾਤ ਤਸਲੇ, ਕੜਛੇ, ਬਾਟੇ, ਤ੍ਰਿਸੂਲੀਆਂ ਅਤੇ ਅੰਗੀਠੀਆਂ ਬਣਾਈਆਂ। ਉਸ ਦੇ ਸਾਰੇ ਭਾਂਡੇ ਪਿੱਤਲ ਦੇ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","ਉਸ ਨੇ ਜਗਵੇਦੀ ਲਈ ਪਿੱਤਲ ਦੀ ਇੱਕ ਜਾਲੀਦਾਰ ਝੰਜਰੀ ਬਣਾਈ। ");
INSERT INTO pan_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","ਉਹ ਉਸ ਦੇ ਥੜੇ ਦੇ ਹੇਠ ਅਤੇ ਉਸ ਦੇ ਵਿਚਕਾਰ ਸੀ ਅਤੇ ਉਸ ਨੇ ਚੌਹਾਂ ਖੂੰਜਿਆਂ ਲਈ ਚਾਰ ਕੜੇ ਪਿੱਤਲ ਦੀ ਝੰਜਰੀ ਲਈ ਬਣਾਏ ਜਿਹੜੇ ਚੋਬਾਂ ਦੇ ਥਾਵਾਂ ਲਈ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","ਉਸ ਨੇ ਸ਼ਿੱਟੀਮ ਦੀ ਲੱਕੜੀ ਦੀਆਂ ਚੋਬਾਂ ਬਣਾਈਆਂ ਅਤੇ ਉਨ੍ਹਾਂ ਨੂੰ ਪਿੱਤਲ ਨਾਲ ਮੜ੍ਹਿਆ। ");
INSERT INTO pan_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","ਉਸ ਨੇ ਉਹ ਦੀਆਂ ਚੋਬਾਂ ਨੂੰ ਜਗਵੇਦੀ ਦੇ ਪਾਸਿਆਂ ਦੇ ਕੜਿਆਂ ਵਿੱਚ ਪਾਇਆ ਜਿਨ੍ਹਾਂ ਨਾਲ ਉਹ ਚੁੱਕੀ ਜਾਵੇ। ਉਸ ਨੇ ਉਹ ਨੂੰ ਫੱਟੀਆਂ ਨਾਲ ਖੋਖਲਾ ਬਣਾਇਆ। ");
INSERT INTO pan_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","ਉਸ ਨੇ ਪਿੱਤਲ ਦਾ ਇੱਕ ਹੌਦ ਅਤੇ ਉਹ ਦੀ ਪਿੱਤਲ ਦੀ ਇੱਕ ਚੌਂਕੀ ਬਣਾਈ ਅਤੇ ਉਹ ਮੰਡਲੀ ਦੇ ਤੰਬੂ ਦੇ ਦਰਵਾਜ਼ੇ ਦੀਆਂ ਸੇਵਾਦਾਰਨੀਆਂ ਦਿਆਂ ਦਰਪਣਾਂ ਤੋਂ ਬਣਾਏ। ");
INSERT INTO pan_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","ਉਸ ਨੇ ਵਿਹੜਾ ਬਣਾਇਆ ਅਤੇ ਦੱਖਣ ਦੇ ਪਾਸੇ ਵੱਲ ਵਿਹੜੇ ਲਈ ਮਹੀਨ ਉਣੀ ਹੋਈ ਕਤਾਨ ਦੀਆਂ ਸੌ ਹੱਥ ਲੰਮੀਆਂ ਕਨਾਤਾਂ ਬਣਾਈਆਂ ");
INSERT INTO pan_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","ਅਤੇ ਉਨ੍ਹਾਂ ਦੀਆਂ ਥੰਮ੍ਹੀਆਂ ਵੀਹ ਅਤੇ ਉਨ੍ਹਾਂ ਦੀਆਂ ਵੀਹ ਚੀਥੀਆਂ ਪਿੱਤਲ ਦੀਆਂ ਸਨ ਅਤੇ ਥੰਮ੍ਹੀਆਂ ਦੇ ਕੁੰਡੇ ਅਤੇ ਉਨ੍ਹਾਂ ਦੇ ਕੜੇ ਚਾਂਦੀ ਦੇ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","ਅਤੇ ਉੱਤਰ ਦੇ ਪਾਸੇ ਵੱਲ ਸੌ ਹੱਥ। ਉਨ੍ਹਾਂ ਦੀਆਂ ਥੰਮ੍ਹੀਆਂ ਵੀਹ ਅਤੇ ਉਨ੍ਹਾਂ ਦੀਆਂ ਵੀਹ ਚੀਥੀਆਂ ਪਿੱਤਲ ਦੀਆਂ ਸਨ ਅਤੇ ਉਨ੍ਹਾਂ ਥੰਮ੍ਹੀਆਂ ਦੇ ਕੁੰਡੇ ਅਤੇ ਕੜੇ ਚਾਂਦੀ ਦੇ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","ਅਤੇ ਲਹਿੰਦੇ ਪਾਸੇ ਵੱਲ ਕਨਾਤਾਂ ਪੰਜਾਹ ਹੱਥ ਸਨ। ਉਨ੍ਹਾਂ ਦੀਆਂ ਥੰਮ੍ਹੀਆਂ ਦਸ ਉਨ੍ਹਾਂ ਦੀਆਂ ਚੀਥੀਆਂ ਦਸ ਸਨ ਅਤੇ ਥੰਮ੍ਹੀਆਂ ਦੇ ਕੁੰਡੇ ਅਤੇ ਕੜੇ ਚਾਂਦੀ ਦੇ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","ਅਤੇ ਸਾਹਮਣੇ ਚੜ੍ਹਦੇ ਪਾਸੇ ਵੱਲ ਪੰਜਾਹ ਹੱਥ ");
INSERT INTO pan_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","ਦਰਵਾਜ਼ੇ ਦੇ ਇੱਕ ਪਾਸੇ ਦੀਆਂ ਕਨਾਤਾਂ ਪੰਦਰਾਂ ਹੱਥ ਸਨ ਅਤੇ ਉਨ੍ਹਾਂ ਦੀਆਂ ਥੰਮ੍ਹੀਆਂ ਤਿੰਨ ਅਤੇ ਉਨ੍ਹਾਂ ਦੀਆਂ ਚੀਥੀਆਂ ਤਿੰਨ ਸਨ ");
INSERT INTO pan_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","ਅਤੇ ਇਸ ਤਰ੍ਹਾਂ ਦੂਜੇ ਪਾਸੇ ਲਈ ਸੀ ਅਰਥਾਤ ਵਿਹੜੇ ਦੇ ਫਾਟਕ ਦੇ ਦੋਵੇਂ ਪਾਸੇ ਪੰਦਰਾਂ-ਪੰਦਰਾਂ ਹੱਥ ਦੀਆਂ ਕਨਾਤਾਂ ਸਨ ਅਤੇ ਉਨ੍ਹਾਂ ਦੀਆਂ ਥੰਮ੍ਹੀਆਂ ਤਿੰਨ ਅਤੇ ਉਨ੍ਹਾਂ ਦੀਆਂ ਚੀਥੀਆਂ ਤਿੰਨ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","ਵਿਹੜੇ ਦੇ ਚੌਹਾਂ ਪਾਸਿਆਂ ਦੀਆਂ ਕਨਾਤਾਂ ਉਣੀ ਹੋਈ ਕਤਾਨ ਦੀਆਂ ਸਨ ");
INSERT INTO pan_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","ਅਤੇ ਥੰਮ੍ਹੀਆਂ ਦੀਆਂ ਚੀਥੀਆਂ ਪਿੱਤਲ ਦੀਆਂ ਸਨ ਅਤੇ ਥੰਮ੍ਹੀਆਂ ਦੇ ਕੁੰਡੇ ਅਤੇ ਕੜੇ ਚਾਂਦੀ ਦੇ ਸਨ ਅਤੇ ਉਨ੍ਹਾਂ ਦੇ ਸਿਰਿਆਂ ਦਾ ਮੜ੍ਹ ਚਾਂਦੀ ਦਾ ਸੀ ਅਤੇ ਵਿਹੜੇ ਦੀਆਂ ਸਾਰੀਆਂ ਥੰਮ੍ਹੀਆਂ ਚਾਂਦੀ ਨਾਲ ਮੜ੍ਹੀਆਂ ਹੋਈਆਂ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","ਵਿਹੜੇ ਦੇ ਫਾਟਕ ਲਈ ਇੱਕ ਓਟ ਨੀਲੇ ਬੈਂਗਣੀ ਅਤੇ ਕਿਰਮਚੀ ਮਹੀਨ ਉਣੇ ਹੋਏ ਕਤਾਨ ਦੀ ਸੀ ਅਤੇ ਉਹ ਕਸੀਦੇਕਾਰ ਦਾ ਕੰਮ ਸੀ। ਉਹ ਦੀ ਲੰਬਾਈ ਵੀਹ ਹੱਥ ਅਤੇ ਉਹ ਦੀ ਉਚਾਈ ਚੌੜਾਈ ਜਿੰਨੀ ਪੰਜ ਹੱਥ ਵਿਹੜੇ ਦੀਆਂ ਕਨਾਤਾਂ ਵਾਂਗੂੰ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","ਉਨ੍ਹਾਂ ਦੀਆਂ ਥੰਮ੍ਹੀਆਂ ਚਾਰ ਅਤੇ ਉਨ੍ਹਾਂ ਦੀਆਂ ਚੀਥੀਆਂ ਚਾਰ ਪਿੱਤਲ ਦੀਆਂ ਸਨ। ਉਨ੍ਹਾਂ ਦੇ ਕੁੰਡੇ ਚਾਂਦੀ ਦੇ ਅਤੇ ਉਨ੍ਹਾਂ ਦੇ ਸਿਰਿਆਂ ਦਾ ਮੜ੍ਹ ਅਤੇ ਉਨ੍ਹਾਂ ਦੇ ਕੜੇ ਚਾਂਦੀ ਦੇ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","ਡੇਰੇ ਅਤੇ ਵਿਹੜੇ ਦੇ ਆਲੇ-ਦੁਆਲੇ ਦੀਆਂ ਸਾਰੀਆਂ ਕੀਲੀਆਂ ਪਿੱਤਲ ਦੀਆਂ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","ਇਹ ਡੇਰੇ ਦਾ ਲੇਖਾ ਹੈ ਅਰਥਾਤ ਸਾਖੀ ਦੇ ਡੇਰੇ ਦਾ ਜਿਵੇਂ ਉਹ ਮੂਸਾ ਦੇ ਹੁਕਮ ਅਨੁਸਾਰ ਲੇਵੀਆਂ ਦੀ ਉਪਾਸਨਾ ਦੇ ਕੰਮ ਲਈ ਹਾਰੂਨ ਜਾਜਕ ਦੇ ਪੁੱਤਰ ਈਥਾਮਾਰ ਦੇ ਰਾਹੀਂ ਗਿਣਿਆ ਗਿਆ। ");
INSERT INTO pan_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","ਸੋ ਹੂਰ ਦੇ ਪੋਤੇ ਅਤੇ ਊਰੀ ਦੇ ਪੁੱਤਰ ਬਸਲਏਲ ਨੇ ਜਿਹੜਾ ਯਹੂਦਾਹ ਦੇ ਗੋਤ ਦਾ ਸੀ ਜੋ ਕੁਝ ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਹੁਕਮ ਦਿੱਤਾ ਸੀ ਬਣਾਇਆ। ");
INSERT INTO pan_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","ਉਹ ਦੇ ਨਾਲ ਆਹਾਲੀਆਬ ਅਹੀਸਾਮਾਕ ਦਾ ਪੁੱਤਰ ਸੀ ਜਿਹੜਾ ਦਾਨ ਦੇ ਗੋਤ ਦਾ ਸੀ। ਉਹ ਨਿਪੁੰਨ ਕਾਰੀਗਰ ਅਤੇ ਨੀਲੇ ਬੈਂਗਣੀ ਕਿਰਮਚੀ ਮਹੀਨ ਕਤਾਨ ਦਾ ਕਸੀਦੇਕਾਰ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","ਸਾਰਾ ਸੋਨਾ ਜਿਹੜਾ ਪਵਿੱਤਰ ਸਥਾਨ ਦੇ ਕੰਮ ਦੇ ਵਰਤਣ ਵਿੱਚ ਆਇਆ ਅਰਥਾਤ ਭੇਟ ਦਾ ਸੋਨਾ ਉੱਨਤੀ ਕਿੱਕਾਰ ਅਤੇ ਸੱਤ ਸੌ ਤੀਹ ਸ਼ਕਲ ਪਵਿੱਤਰ ਸਥਾਨ ਦੇ ਸ਼ਕਲ ਅਨੁਸਾਰ ਹੋਇਆ ");
INSERT INTO pan_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","ਅਤੇ ਮੰਡਲੀ ਦੇ ਲੋਕਾਂ ਦੀ ਚਾਂਦੀ ਜਿਨ੍ਹਾਂ ਦਾ ਲੇਖਾ ਹੋਇਆ ਇੱਕ ਸੌ ਕਿੱਕਾਰ ਅਤੇ ਇੱਕ ਹਜ਼ਾਰ ਸੱਤ ਸੌ ਪੰਝੱਤਰ ਸ਼ਕਲ ਪਵਿੱਤਰ ਸਥਾਨ ਦੇ ਸ਼ਕਲ ਅਨੁਸਾਰ ਸੀ ");
INSERT INTO pan_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","ਅਰਥਾਤ ਜੀਆਂ ਪ੍ਰਤੀ ਅੱਧਾ ਸ਼ਕਲ ਪਵਿੱਤਰ ਸਥਾਨ ਦੇ ਸ਼ਕਲ ਅਨੁਸਾਰ ਉਨ੍ਹਾਂ ਸਾਰਿਆਂ ਤੋਂ ਜਿਹੜੇ ਗਿਣਿਆ ਹੋਇਆਂ ਵਿੱਚ ਰਲਦੇ ਸਨ ਲਿਆ ਜਿਹੜੇ ਵੀਹ ਸਾਲਾਂ ਦੇ ਅਤੇ ਉੱਤੇ ਦੇ ਸਨ ਉਹ ਛੇ ਲੱਖ ਤਿੰਨ ਹਜ਼ਾਰ ਪੰਜ ਸੌ ਪੰਜਾਹ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","ਅਤੇ ਚਾਂਦੀ ਦੇ ਸੌ ਕਿੱਕਾਰ ਪਵਿੱਤਰ ਸਥਾਨ ਦੀਆਂ ਚੀਥੀਆਂ ਅਤੇ ਪਰਦੇ ਦੀਆਂ ਚੀਥੀਆਂ ਲਈ ਵਰਤੇ ਗਏ ਅਰਥਾਤ ਸੌ ਚੀਥੀਆਂ ਸੌ ਕਿੱਕਾਰ ਇੱਕ ਚੀਥੀ ਇੱਕ ਕਿੱਕਾਰ। ");
INSERT INTO pan_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","ਅਤੇ ਇੱਕ ਹਜ਼ਾਰ ਸੱਤ ਸੌ ਪੰਝੱਤਰ ਸ਼ਕਲ ਤੋਂ ਉਸ ਨੇ ਥੰਮ੍ਹੀਆਂ ਦੇ ਕੁੰਡੇ ਬਣਾਏ ਅਤੇ ਉਨ੍ਹਾਂ ਦੇ ਸਿਰਿਆਂ ਨੂੰ ਮੜ੍ਹਿਆ ਅਤੇ ਉਨ੍ਹਾਂ ਦੇ ਕੜੇ ਬਣਾਏ। ");
INSERT INTO pan_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","ਭੇਟ ਦਾ ਪਿੱਤਲ ਸੱਤਰ ਕਿੱਕਾਰ ਅਤੇ ਦੋ ਹਜ਼ਾਰ ਚਾਰ ਸੌ ਸ਼ਕਲ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","ਉਸ ਤੋਂ ਉਹ ਨੇ ਮੰਡਲੀ ਦੇ ਤੰਬੂ ਦੇ ਦਰਵਾਜ਼ੇ ਦੀਆਂ ਚੀਥੀਆਂ ਅਤੇ ਪਿੱਤਲ ਦੀ ਜਗਵੇਦੀ ਅਤੇ ਉਸ ਦੀ ਪਿੱਤਲ ਦੀ ਝੰਜਰੀ ਅਤੇ ਜਗਵੇਦੀ ਦੇ ਸਾਰੇ ਭਾਂਡੇ ਬਣਾਏ ਨਾਲੇ ਵਿਹੜੇ ਦੇ ਚੌਹਾਂ ਪਾਸਿਆਂ ਦੀਆਂ ਚੀਥੀਆਂ ਅਤੇ ਵਿਹੜੇ ਦੇ ਫਾਟਕ ਦੀਆਂ ਚੀਥੀਆਂ ਅਤੇ ਡੇਰੇ ਦੀਆਂ ਸਾਰੀਆਂ ਕੀਲੀਆਂ ਅਤੇ ਵਿਹੜੇ ਦੇ ਚੌਹਾਂ ਪਾਸਿਆਂ ਦੀਆਂ ਕੀਲੀਆਂ। ");
INSERT INTO pan_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","ਇਸ ਦੀ ਵਰਤੋਂ ਵਿਹੜੇ ਦੇ ਆਲੇ-ਦੁਆਲੇ ਦੇ ਪਰਦਿਆਂ ਅਤੇ ਪ੍ਰਵੇਸ਼-ਦੁਆਰ ਦੇ ਪਰਦਿਆਂ ਦੀਆਂ ਚੀਥੀਆਂ ਬਣਾਉਣ ਲਈ ਵੀ ਕੀਤੀ ਗਈ ਸੀ। ਅਤੇ ਪਿੱਤਲ ਦੀ ਵਰਤੋਂ ਪਵਿੱਤਰ ਤੰਬੂ ਲਈ ਅਤੇ ਵਿਹੜੇ ਦੇ ਆਲੇ-ਦੁਆਲੇ ਦੇ ਪਰਦਿਆਂ ਲਈ ਕੀਲੀਆਂ ਬਣਾਉਣ ਵਾਸਤੇ ਕੀਤੀ ਗਈ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","ਉਨ੍ਹਾਂ ਨੇ ਮਹੀਨ ਉਣਤੀ ਦਾ ਨੀਲਾ ਬੈਂਗਣੀ ਅਤੇ ਕਿਰਮਚੀ ਬਸਤਰ ਪਵਿੱਤਰ ਸਥਾਨ ਦੀ ਉਪਾਸਨਾ ਲਈ ਬਣਾਇਆ ਅਤੇ ਹਾਰੂਨ ਲਈ ਪਵਿੱਤਰ ਬਸਤਰ ਬਣਾਏ ਜਿਵੇਂ ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਹੁਕਮ ਦਿੱਤਾ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","ਅਤੇ ਉਸ ਨੇ ਏਫ਼ੋਦ ਨੂੰ ਸੋਨੇ, ਨੀਲੇ ਬੈਂਗਣੀ ਅਤੇ ਕਿਰਮਚੀ ਮਹੀਨ ਉਣੇ ਹੋਏ ਕਤਾਨ ਦਾ ਬਣਾਇਆ। ");
INSERT INTO pan_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","ਫੇਰ ਉਨ੍ਹਾਂ ਨੇ ਸੋਨੇ ਨੂੰ ਕੁੱਟ ਕੇ ਪਤਲੇ-ਪਤਲੇ ਪੱਤ੍ਰ ਬਣਾਏ ਅਤੇ ਉਨ੍ਹਾਂ ਤੋਂ ਬਰੀਕ ਤਾਰਾਂ ਬਣਾਈਆਂ ਅਤੇ ਉਸ ਨੂੰ ਨੀਲੇ, ਬੈਂਗਣੀ ਅਤੇ ਕਿਰਮਚੀ ਮਹੀਨ ਕਤਾਨ ਵਿੱਚ ਕਾਰੀਗਰੀ ਨਾਲ ਉਣਿਆ। ");
INSERT INTO pan_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","ਉਨ੍ਹਾਂ ਨੇ ਮੋਢਿਆਂ ਦੀਆਂ ਕਤਰਾਂ ਬਣਾ ਕੇ ਜੋੜੀਆਂ ਅਤੇ ਉਹ ਉਸ ਦੇ ਦੋਹਾਂ ਸਿਰਿਆਂ ਨਾਲ ਜੁੜ ਗਈਆਂ। ");
INSERT INTO pan_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","ਕਾਰੀਗਰੀ ਨਾਲ ਕੱਢਿਆ ਹੋਇਆ ਪਟਕਾ ਜਿਹੜਾ ਉਹ ਦੇ ਉੱਤੇ ਕੱਸਣ ਲਈ ਸੀ ਉਸ ਦੇ ਕੰਮ ਅਨੁਸਾਰ ਉਸੇ ਤੋਂ ਸੀ ਅਰਥਾਤ ਸੋਨੇ ਅਤੇ ਨੀਲੇ ਬੈਂਗਣੀ ਕਿਰਮਚੀ ਮਹੀਨ ਉਣੇ ਹੋਏ ਕਤਾਨ ਦਾ ਸੀ ਜਿਵੇਂ ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਹੁਕਮ ਦਿੱਤਾ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","ਉਨ੍ਹਾਂ ਨੇ ਸੁਲੇਮਾਨੀ ਪੱਥਰ ਸੋਨੇ ਦੇ ਖ਼ਾਨਿਆਂ ਵਿੱਚ ਪਾਉਣ ਲਈ ਛਾਪ ਦੀ ਉੱਕਰਾਈ ਵਾਂਗੂੰ ਇਸਰਾਏਲ ਦੇ ਪੁੱਤਰਾਂ ਦੇ ਨਾਮਾਂ ਅਨੁਸਾਰ ਉੱਕਰ ਕੇ ਬਣਾਏ। ");
INSERT INTO pan_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","ਉਸ ਨੇ ਉਨ੍ਹਾਂ ਨੂੰ ਏਫ਼ੋਦ ਦੇ ਮੋਢਿਆਂ ਦੀਆਂ ਕਤਰਾਂ ਉੱਤੇ ਰੱਖਿਆ ਤਾਂ ਜੋ ਇਸਰਾਏਲ ਦੇ ਪੁੱਤਰਾਂ ਦੀ ਯਾਦਗਿਰੀ ਦੇ ਪੱਥਰ ਹੋਣ ਜਿਵੇਂ ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਹੁਕਮ ਦਿੱਤਾ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","ਉਸ ਨੇ ਸੀਨਾ ਬੰਦ ਨੂੰ ਏਫ਼ੋਦ ਦੇ ਕੰਮ ਵਾਂਗੂੰ ਕਾਰੀਗਰੀ ਦੀ ਬਣਤ ਦਾ ਅਰਥਾਤ ਸੋਨੇ, ਨੀਲੇ, ਬੈਂਗਣੀ ਅਤੇ ਕਿਰਮਚੀ ਮਹੀਨ ਉਣੇ ਹੋਏ ਕਤਾਨ ਦਾ ਬਣਾਇਆ। ");
INSERT INTO pan_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","ਉਨ੍ਹਾਂ ਨੇ ਸੀਨੇ ਬੰਦ ਨੂੰ ਚੌਰਸ ਅਤੇ ਦੋਹਰਾ ਬਣਾਇਆ। ਉਸ ਦੀ ਲੰਬਾਈ ਇੱਕ ਗਿੱਠ ਅਤੇ ਉਸ ਦੀ ਚੌੜਾਈ ਇੱਕ ਗਿੱਠ ਅਤੇ ਉਹ ਦੋਹਰਾ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","ਉਨ੍ਹਾਂ ਨੇ ਉਸ ਵਿੱਚ ਪੱਥਰ ਦੀਆਂ ਚਾਰ ਪਾਲਾਂ ਬਣਾਈਆਂ। ਇੱਕ ਪਾਲ ਵਿੱਚ ਲਾਲ ਅਕੀਕ, ਸੁਨਹਿਲਾ, ਅਤੇ ਜ਼ਬਰਜਦ ਇਹ ਪਹਿਲੀ ਪਾਲ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","ਦੂਜੀ ਪਾਲ ਵਿੱਚ ਪੰਨਾ, ਨੀਲਮ, ਦੁਧੀਯਾ ਬਿਲੌਰ ");
INSERT INTO pan_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","ਤੀਜੀ ਪਾਲ ਵਿੱਚ ਜ਼ਕਰਨ, ਹਰੀ ਅਕੀਕ, ਕਟੈਹਿਲਾ ");
INSERT INTO pan_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","ਚੌਥੀ ਪਾਲ ਵਿੱਚ ਬੈਰੂਜ਼, ਸੁਲੇਮਾਨੀ ਅਤੇ ਯਸ਼ਬ, ਇਹ ਆਪੋ ਆਪਣੇ ਖ਼ਾਨਿਆਂ ਵਿੱਚ ਸੋਨੇ ਨਾਲ ਜੁੜੇ ਹੋਏ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","ਅਤੇ ਉਹ ਪੱਥਰ ਇਸਰਾਏਲ ਦੇ ਪੁੱਤਰਾਂ ਦੇ ਨਾਮਾਂ ਅਨੁਸਾਰ ਸਨ ਅਰਥਾਤ ਉਨ੍ਹਾਂ ਦੇ ਬਾਰਾਂ ਨਾਮਾਂ ਦੇ ਅਨੁਸਾਰ ਛਾਪ ਦੀ ਉੱਕਰਾਈ ਵਾਂਗੂੰ ਹਰ ਇੱਕ ਦੇ ਨਾਮ ਦੇ ਅਨੁਸਾਰ ਉਹ ਬਾਰਾਂ ਗੋਤਾਂ ਲਈ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","ਉਨ੍ਹਾਂ ਨੇ ਸੀਨੇ ਬੰਦ ਉੱਤੇ ਖ਼ਾਲਸ ਸੋਨੇ ਦੀ ਜੰਜ਼ੀਰੀ ਰੱਸਿਆਂ ਵਾਂਗੂੰ ਗੁੰਦੇ ਹੋਏ ਕੰਮ ਦੀ ਬਣਾਈ। ");
INSERT INTO pan_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","ਉਨ੍ਹਾਂ ਨੇ ਸੋਨੇ ਦੇ ਖ਼ਾਨੇ ਅਤੇ ਸੋਨੇ ਦੇ ਦੋ ਕੜੇ ਬਣਾਏ ਅਤੇ ਉਨ੍ਹਾਂ ਨੇ ਉਹ ਦੋਨੋਂ ਕੜੇ ਸੀਨੇ ਬੰਦ ਦੇ ਸਿਰਿਆਂ ਵਿੱਚ ਪਾਏ। ");
INSERT INTO pan_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","ਉਨ੍ਹਾਂ ਨੇ ਦੋ ਗੁੰਦੀਆਂ ਹੋਈਆਂ ਸੋਨੇ ਦੀਆਂ ਜੰਜ਼ੀਰੀਆਂ ਸੀਨੇ ਬੰਦ ਦੇ ਸਿਰਿਆਂ ਉੱਤੇ ਦੋਹਾਂ ਕੜਿਆਂ ਵਿੱਚ ਪਾਈਆਂ ");
INSERT INTO pan_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","ਅਤੇ ਦੂਜੇ ਦੋਵੇਂ ਸਿਰੇ ਗੁੰਦੀਆਂ ਹੋਈਆਂ ਜੰਜ਼ੀਰੀਆਂ ਦੇ ਦੋਹਾਂ ਖ਼ਾਨਿਆਂ ਉੱਤੇ ਰੱਖੇ ਅਤੇ ਉਨ੍ਹਾਂ ਨੂੰ ਏਫ਼ੋਦ ਦੇ ਮੋਢਿਆਂ ਦੀਆਂ ਕਤਰਾਂ ਉੱਤੇ ਅਗਲੇ ਪਾਸੇ ਰੱਖਿਆ। ");
INSERT INTO pan_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","ਉਨ੍ਹਾਂ ਨੇ ਸੋਨੇ ਦੇ ਦੋ ਕੜੇ ਬਣਾਏ ਅਤੇ ਉਨ੍ਹਾਂ ਨੂੰ ਸੀਨੇ ਬੰਦ ਦੇ ਦੋਹਾਂ ਸਿਰਿਆਂ ਵਿੱਚ ਪਾਇਆ ਜਿਹੜੇ ਏਫ਼ੋਦ ਦੀ ਕਿਨਾਰੀ ਦੇ ਅੰਦਰਲੇ ਪਾਸੇ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","ਉਨ੍ਹਾਂ ਨੇ ਸੋਨੇ ਦੇ ਦੋ ਹੋਰ ਕੜੇ ਬਣਾਏ ਅਤੇ ਉਨ੍ਹਾਂ ਨੂੰ ਏਫ਼ੋਦ ਦੀਆਂ ਦੋਹਾਂ ਕਤਰਾਂ ਉੱਤੇ ਅਗਲੇ ਪਾਸੇ ਹੇਠਲੀ ਵੱਲ ਸੀਣ ਦੇ ਨੇੜੇ ਏਫ਼ੋਦ ਦੇ ਕਾਰੀਗਰੀ ਨਾਲ ਕੱਢੇ ਹੋਏ ਪਟਕੇ ਦੇ ਉੱਤੇ ਰੱਖਿਆ। ");
INSERT INTO pan_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","ਤਾਂ ਉਨ੍ਹਾਂ ਨੇ ਸੀਨੇ ਬੰਦ ਉਸ ਦੇ ਕੜਿਆਂ ਨਾਲ ਏਫ਼ੋਦ ਦੇ ਕੜਿਆਂ ਵਿੱਚ ਨੀਲੇ ਰੰਗ ਦੀ ਰੱਸੀ ਨਾਲ ਅਜਿਹਾ ਬੰਨ੍ਹਿਆ ਕਿ ਉਹ ਏਫ਼ੋਦ ਦੇ ਕੱਢੇ ਹੋਏ ਪਟਕੇ ਦੇ ਉੱਤੇ ਰਹੇ ਅਤੇ ਸੀਨੇ ਬੰਦ ਏਫ਼ੋਦ ਦੇ ਉੱਤੇ ਨਾ ਖੁਲ੍ਹੇ ਜਿਵੇਂ ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਹੁਕਮ ਦਿੱਤਾ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","ਉਸ ਨੇ ਏਫ਼ੋਦ ਦਾ ਚੋਗਾ ਸਾਰਾ ਨੀਲੇ ਰੰਗ ਦਾ ਅਤੇ ਬੁਣਤ ਦਾ ਬਣਾਇਆ ");
INSERT INTO pan_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","ਅਤੇ ਚੋਗੇ ਦੇ ਵਿਚਕਾਰ ਸੰਜੋ ਦੇ ਛੇਕ ਵਰਗਾ ਛੇਕ ਰੱਖਿਆ ਅਤੇ ਛੇਕ ਦੇ ਚੁਫ਼ੇਰੇ ਇੱਕ ਬੰਨੀ ਬਣਾਈ ਤਾਂ ਜੋ ਉਹ ਨਾ ਪਾਟੇ। ");
INSERT INTO pan_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","ਉਨ੍ਹਾਂ ਨੇ ਉਸ ਦੇ ਪੱਲੇ ਦੇ ਹੇਠਲੇ ਘੇਰੇ ਉੱਤੇ ਨੀਲੇ ਬੈਂਗਣੀ ਅਤੇ ਕਿਰਮਚੀ ਕਤਾਨ ਦੇ ਅਨਾਰ ਬਣਾਏ। ");
INSERT INTO pan_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","ਅਨਾਰਾਂ ਦੇ ਵਿਚਕਾਰ ਅਤੇ ਆਲੇ-ਦੁਆਲੇ ਖ਼ਾਲਸ ਸੋਨੇ ਦੇ ਘੁੰਗਰੂ ਚੋਗੇ ਦੇ ਹੇਠਲੇ ਪੱਲੇ ਉੱਤੇ ਪਾਏ ");
INSERT INTO pan_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","ਅਰਥਾਤ ਸੋਨੇ ਦਾ ਇੱਕ ਘੁੰਗਰੂ ਅਤੇ ਇੱਕ ਅਨਾਰ ਫੇਰ ਇੱਕ ਘੁੰਗਰੂ ਅਤੇ ਇੱਕ ਅਨਾਰ ਚੋਗੇ ਦੇ ਹੇਠਲੇ ਪੱਲੇ ਦੇ ਘੇਰੇ ਉੱਤੇ ਸੀ ਅਤੇ ਇਹ ਉਪਾਸਨਾ ਲਈ ਸੀ ਜਿਵੇਂ ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਹੁਕਮ ਦਿੱਤਾ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","ਉਨ੍ਹਾਂ ਦੇ ਹਾਰੂਨ ਅਤੇ ਉਸ ਦੇ ਪੁੱਤਰਾਂ ਲਈ ਮਹੀਨ ਕਤਾਨ ਦੇ ਕੁੜਤੇ ਬੁਣਤ ਦੇ ਬਣਾਏ ");
INSERT INTO pan_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","ਅਤੇ ਮਹੀਨ ਕਤਾਨ ਦੀ ਪਗੜੀ, ਮਹੀਨ ਕਤਾਨ ਦਾ ਅਮਾਮਾ ਅਤੇ ਮਹੀਨ ਕਤਾਨ ਦੀਆਂ ਉਣੀਆਂ ਹੋਈਆਂ ਕੱਛਾਂ ਬਣਾਈਆਂ ");
INSERT INTO pan_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","ਅਤੇ ਮਹੀਨ ਕਤਾਨ ਦਾ ਉਣਿਆ ਹੋਇਆ ਨੀਲਾ ਬੈਂਗਣੀ ਅਤੇ ਕਿਰਮਚੀ ਪਟਕਾ ਕਸੀਦੇਕਾਰੀ ਦੇ ਕੰਮ ਦਾ ਬਣਾਇਆ ਜਿਵੇਂ ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਹੁਕਮ ਦਿੱਤਾ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","ਉਨ੍ਹਾਂ ਨੇ ਮੱਥੇ ਲਈ ਪਵਿੱਤਰ ਚਮਕੀਲਾ ਪੱਤਰ ਖ਼ਾਲਸ ਸੋਨੇ ਦਾ ਬਣਾਇਆ ਅਤੇ ਉਸ ਦੇ ਉੱਤੇ ਉਨ੍ਹਾਂ ਨੇ ਲਿਖਤ ਛਾਪ ਦੀ ਉੱਕਰਾਈ ਵਾਂਗੂੰ ਲਿਖੀ “ਯਹੋਵਾਹ ਲਈ ਪਵਿੱਤਰਤਾਈ” ");
INSERT INTO pan_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","ਉਨ੍ਹਾਂ ਨੇ ਉਸ ਵਿੱਚ ਨੀਲੀ ਡੋਰ ਪਾਈ ਤਾਂ ਜੋ ਉਹ ਅਮਾਮੇ ਦੇ ਉੱਤੇ ਬੰਨ੍ਹਿਆ ਜਾਵੇ ਜਿਵੇਂ ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਹੁਕਮ ਦਿੱਤਾ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","ਸੋ ਡੇਰੇ ਦੀ ਮੰਡਲੀ ਦੇ ਤੰਬੂ ਦਾ ਸਾਰਾ ਕੰਮ ਪੂਰਾ ਹੋਇਆ ਅਤੇ ਇਸ ਤਰ੍ਹਾਂ ਇਸਰਾਏਲੀਆਂ ਨੇ ਸਾਰਾ ਕੁਝ ਕੀਤਾ। ਜਿਵੇਂ ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਹੁਕਮ ਦਿੱਤਾ ਸੀ ਉਨ੍ਹਾਂ ਨੇ ਤਿਵੇਂ ਹੀ ਕੀਤਾ। ");
INSERT INTO pan_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","ਤਾਂ ਉਹ ਡੇਰਾ ਮੂਸਾ ਕੋਲ ਲਿਆਏ ਅਰਥਾਤ ਤੰਬੂ ਅਤੇ ਉਸ ਦਾ ਸਾਰਾ ਸਮਾਨ, ਉਸ ਦੀਆਂ ਕੁੰਡੀਆਂ, ਉਸ ਦੇ ਫੱਟੇ, ਉਸ ਦੇ ਹੋੜੇ, ਉਸ ਦੀਆਂ ਥੰਮ੍ਹੀਆਂ, ਅਤੇ ਉਸ ਦੀਆਂ ਚੀਥੀਆਂ ");
INSERT INTO pan_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","ਅਤੇ ਛੱਤ੍ਰਿਆਂ ਦੀਆਂ ਲਾਲ ਰੰਗੀਆਂ ਹੋਈਆਂ ਖੱਲਾਂ ਦਾ ਢੱਕਣ ਅਤੇ ਸਮੁੰਦਰੀ ਜੀਵ ਦੀਆਂ ਖੱਲਾਂ ਦਾ ਢੱਕਣ ਅਤੇ ਓਟ ਦਾ ਪਰਦਾ ");
INSERT INTO pan_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","ਸਾਖੀ ਦਾ ਸੰਦੂਕ ਚੋਬਾਂ ਸਣੇ ਅਤੇ ਪ੍ਰਾਸਚਿਤ ਦਾ ਸਰਪੋਸ਼ ");
INSERT INTO pan_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","ਮੇਜ਼ ਅਤੇ ਉਸ ਦੇ ਸਾਰੇ ਭਾਂਡੇ ਅਤੇ ਹਜ਼ੂਰੀ ਦੀ ਰੋਟੀ ");
INSERT INTO pan_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","ਖ਼ਾਲਸ ਸ਼ਮਾਦਾਨ ਉਸ ਦੇ ਦੀਵਿਆਂ ਸਣੇ ਜਿਨ੍ਹਾਂ ਦੀਵਿਆਂ ਨੂੰ ਸੁਆਰਨਾ ਸੀ ਅਤੇ ਉਸ ਦਾ ਸਾਰਾ ਸਮਾਨ ਅਤੇ ਚਾਨਣ ਲਈ ਤੇਲ ");
INSERT INTO pan_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","ਸੋਨੇ ਦੀ ਜਗਵੇਦੀ ਅਤੇ ਮਸਹ ਕਰਨ ਦਾ ਤੇਲ ਅਤੇ ਸੁਗੰਧੀ ਧੂਪ ਅਤੇ ਡੇਰੇ ਦੇ ਦਰਵਾਜ਼ੇ ਦੀ ਓਟ ");
INSERT INTO pan_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","ਪਿੱਤਲ ਦੀ ਜਗਵੇਦੀ ਅਤੇ ਉਸ ਦੀ ਪਿੱਤਲ ਦੀ ਝੰਜਰੀ ਉਸ ਦੀਆਂ ਚੋਬਾਂ ਸਣੇ ਅਤੇ ਉਸ ਦਾ ਸਾਰਾ ਸਮਾਨ, ਹੌਦ ਅਤੇ ਉਸ ਦੀ ਚੌਂਕੀ ");
INSERT INTO pan_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","ਵਿਹੜੇ ਦੀਆਂ ਕਨਾਤਾਂ ਉਸ ਦੀਆਂ ਥੰਮ੍ਹੀਆਂ ਅਤੇ ਉਸ ਦੀਆਂ ਚੀਥੀਆਂ ਅਤੇ ਵਿਹੜੇ ਦੇ ਫਾਟਕ ਦੀ ਓਟ ਅਤੇ ਉਸ ਦੀਆਂ ਲਾਸਾਂ ਅਤੇ ਉਸ ਦੀਆਂ ਕੀਲੀਆਂ ਅਤੇ ਡੇਰੇ ਦੀ ਮੰਡਲੀ ਦੇ ਤੰਬੂ ਦੀ ਉਪਾਸਨਾ ਦਾ ਸਾਰਾ ਸਮਾਨ ");
INSERT INTO pan_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","ਅਤੇ ਪਵਿੱਤਰ ਸਥਾਨ ਵਿੱਚ ਉਪਾਸਨਾ ਲਈ ਮਹੀਨ ਉਣਿਆ ਹੋਇਆ ਬਸਤਰ ਅਰਥਾਤ ਹਾਰੂਨ ਜਾਜਕ ਦੇ ਪਵਿੱਤਰ ਬਸਤਰ ਅਤੇ ਉਸ ਦੇ ਪੁੱਤਰਾਂ ਦੇ ਬਸਤਰ ਕਿ ਉਹ ਜਾਜਕਾਈ ਦਾ ਕੰਮ ਕਰਨ। ");
INSERT INTO pan_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","ਜਿਵੇਂ ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਹੁਕਮ ਦਿੱਤਾ ਸੀ ਤਿਵੇਂ ਹੀ ਇਸਰਾਏਲੀਆਂ ਨੇ ਸਾਰਾ ਕੰਮ ਕੀਤਾ। ");
INSERT INTO pan_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","ਮੂਸਾ ਨੇ ਇਸ ਸਾਰੇ ਕੰਮ ਨੂੰ ਡਿੱਠਾ ਅਤੇ ਵੇਖੋ ਉਨ੍ਹਾਂ ਨੇ ਉਹ ਨੂੰ ਪੂਰਾ ਕਰ ਦਿੱਤਾ ਸੀ। ਜਿਵੇਂ ਯਹੋਵਾਹ ਨੇ ਹੁਕਮ ਦਿੱਤਾ ਸੀ ਉਨ੍ਹਾਂ ਨੇ ਤਿਵੇਂ ਹੀ ਬਣਾਇਆ ਸੋ ਮੂਸਾ ਨੇ ਉਨ੍ਹਾਂ ਨੂੰ ਅਸੀਸ ਦਿੱਤੀ। ");
INSERT INTO pan_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","ਫੇਰ ਯਹੋਵਾਹ ਮੂਸਾ ਨੂੰ ਬੋਲਿਆ ਕਿ ");
INSERT INTO pan_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","ਪਹਿਲੇ ਮਹੀਨੇ ਦੇ ਪਹਿਲੇ ਦਿਨ ਤੂੰ ਡੇਰੇ ਦੀ ਮੰਡਲੀ ਦਾ ਤੰਬੂ ਖੜਾ ਕਰੀਂ। ");
INSERT INTO pan_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","ਤੂੰ ਉਸ ਵਿੱਚ ਸਾਖੀ ਦਾ ਸੰਦੂਕ ਰੱਖੀਂ ਅਤੇ ਸੰਦੂਕ ਨੂੰ ਪਰਦੇ ਨਾਲ ਵੱਖਰਾ ਕਰੀਂ। ");
INSERT INTO pan_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","ਤੂੰ ਮੇਜ਼ ਨੂੰ ਅੰਦਰ ਲਿਆਵੀਂ ਅਤੇ ਉਸ ਦੇ ਸਮਾਨ ਨੂੰ ਸੁਆਰ ਕੇ ਰੱਖੀਂ। ਤੂੰ ਸ਼ਮਾਦਾਨ ਨੂੰ ਅੰਦਰ ਲਿਆਵੀਂ ਅਤੇ ਉਸ ਦੇ ਦੀਵੇ ਜਗਾਵੀਂ ");
INSERT INTO pan_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","ਅਤੇ ਧੂਪ ਦੀ ਸੋਨੇ ਦੀ ਜਗਵੇਦੀ ਸਾਖੀ ਦੇ ਸੰਦੂਕ ਦੇ ਅੱਗੇ ਰੱਖੀਂ ਅਤੇ ਡੇਰੇ ਦੇ ਦਰਵਾਜ਼ੇ ਦੀ ਓਟ ਲਮਕਾਈਂ। ");
INSERT INTO pan_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","ਤੂੰ ਹੋਮ ਦੀ ਜਗਵੇਦੀ ਨੂੰ ਡੇਰੇ ਦੀ ਮੰਡਲੀ ਦੇ ਤੰਬੂ ਦੇ ਦਰਵਾਜ਼ੇ ਅੱਗੇ ਰੱਖੀਂ ");
INSERT INTO pan_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","ਅਤੇ ਤੂੰ ਹੌਦ ਨੂੰ ਮੰਡਲੀ ਦੇ ਤੰਬੂ ਅਤੇ ਜਗਵੇਦੀ ਦੇ ਵਿਚਕਾਰ ਰੱਖੀਂ ਅਤੇ ਉਸ ਵਿੱਚ ਪਾਣੀ ਪਾਈਂ। ");
INSERT INTO pan_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","ਫੇਰ ਤੂੰ ਵਿਹੜੇ ਨੂੰ ਚੁਫ਼ੇਰੇ ਖੜਾ ਕਰੀਂ ਅਤੇ ਵਿਹੜੇ ਦੇ ਫਾਟਕ ਦੀ ਓਟ ਲਮਕਾਈਂ। ");
INSERT INTO pan_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","ਤੂੰ ਮਲਣ ਦਾ ਤੇਲ ਲੈ ਕੇ ਡੇਰੇ ਨੂੰ ਅਤੇ ਜੋ ਕੁਝ ਉਸ ਵਿੱਚ ਹੈ ਉਸ ਨੂੰ ਮਲੀਂ ਇਸ ਲਈ ਤੂੰ ਉਹ ਨੂੰ ਅਤੇ ਉਸ ਦੇ ਸਾਰੇ ਸਮਾਨ ਨੂੰ ਪਵਿੱਤਰ ਕਰੀਂ ਤਾਂ ਉਹ ਪਵਿੱਤਰ ਹੋਵੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","ਤੂੰ ਹੋਮ ਦੀ ਜਗਵੇਦੀ ਅਤੇ ਉਸ ਦੇ ਸਾਰੇ ਸਮਾਨ ਨੂੰ ਤੇਲ ਮਲੀਂ। ਇਸ ਤਰ੍ਹਾਂ ਤੂੰ ਜਗਵੇਦੀ ਨੂੰ ਪਵਿੱਤਰ ਕਰੀਂ ਤਾਂ ਉਹ ਜਗਵੇਦੀ ਬਹੁਤ ਪਵਿੱਤਰ ਹੋਵੇਗੀ। ");
INSERT INTO pan_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","ਫੇਰ ਤੂੰ ਹੌਦ ਨੂੰ ਅਤੇ ਉਸ ਦੀ ਚੌਂਕੀ ਨੂੰ ਮਲੀਂ। ਤੂੰ ਉਹ ਨੂੰ ਪਵਿੱਤਰ ਕਰੀਂ। ");
INSERT INTO pan_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","ਤੂੰ ਹਾਰੂਨ ਅਤੇ ਉਸ ਦੇ ਪੁੱਤਰਾਂ ਨੂੰ ਮੰਡਲੀ ਦੇ ਤੰਬੂ ਦੇ ਦਰਵਾਜ਼ੇ ਕੋਲ ਲਿਆਈਂ ਅਤੇ ਉਨ੍ਹਾਂ ਨੂੰ ਪਾਣੀ ਨਾਲ ਨਹਲਾਈਂ। ");
INSERT INTO pan_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","ਤੂੰ ਹਾਰੂਨ ਨੂੰ ਪਵਿੱਤਰ ਬਸਤਰ ਪੁਆਈਂ ਅਤੇ ਤੂੰ ਉਹ ਨੂੰ ਮਸਹ ਕਰ ਕੇ ਪਵਿੱਤਰ ਕਰੀਂ ਤਾਂ ਜੋ ਉਹ ਮੇਰੀ ਜਾਜਕਾਈ ਦੀ ਸੇਵਾ ਕਰੇ। ");
INSERT INTO pan_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","ਤੂੰ ਉਸ ਦੇ ਪੁੱਤਰਾਂ ਨੂੰ ਨੇੜੇ ਲਿਆ ਕੇ ਕੁੜਤੇ ਪੁਆਈਂ ");
INSERT INTO pan_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","ਅਤੇ ਤੂੰ ਉਨ੍ਹਾਂ ਨੂੰ ਮਸਹ ਕਰੀਂ ਜਿਵੇਂ ਤੂੰ ਉਨ੍ਹਾਂ ਦੇ ਪਿਤਾ ਨੂੰ ਮਸਹ ਕੀਤਾ ਤਾਂ ਜੋ ਉਹ ਮੇਰੇ ਜਾਜਕ ਹੋਣ ਅਤੇ ਇਸ ਤਰ੍ਹਾਂ ਉਨ੍ਹਾਂ ਦਾ ਮਸਹ ਹੋਣਾ ਉਨ੍ਹਾਂ ਦੀਆਂ ਪੀੜ੍ਹੀਆਂ ਤੱਕ ਇੱਕ ਅਨੰਤ ਜਾਜਕਾਈ ਹੋਵੇਗੀ। ");
INSERT INTO pan_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","ਮੂਸਾ ਨੇ ਜਿਵੇਂ ਯਹੋਵਾਹ ਨੇ ਹੁਕਮ ਦਿੱਤਾ ਸੀ ਤਿਵੇਂ ਹੀ ਸਭ ਕੁਝ ਕੀਤਾ। ");
INSERT INTO pan_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","ਉਪਰੰਤ ਇਸ ਤਰ੍ਹਾਂ ਹੋਇਆ ਕਿ ਦੂਜੇ ਸਾਲ ਦੇ ਪਹਿਲੇ ਮਹੀਨੇ ਦੇ ਪਹਿਲੇ ਦਿਨ ਉਹ ਡੇਰਾ ਖੜਾ ਕੀਤਾ ਗਿਆ। ");
INSERT INTO pan_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","ਅਤੇ ਮੂਸਾ ਨੇ ਡੇਰੇ ਨੂੰ ਖੜਾ ਕੀਤਾ ਅਤੇ ਉਸ ਨੇ ਉਹ ਦੀਆਂ ਚੀਥੀਆਂ ਅਤੇ ਉਸ ਦੇ ਫੱਟੇ ਲਾਏ ਅਤੇ ਉਸ ਦੇ ਹੋੜੇ ਰੱਖੇ ਅਤੇ ਉਸ ਦੀਆਂ ਥੰਮ੍ਹੀਆਂ ਖੜੀਆਂ ਕੀਤੀਆਂ। ");
INSERT INTO pan_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","ਫੇਰ ਡੇਰੇ ਉੱਤੇ ਉਸ ਨੇ ਤੰਬੂ ਤਾਣਿਆ ਅਤੇ ਤੰਬੂ ਉੱਤੇ ਉਤਾਹਾਂ ਢੱਕਣਾ ਲਾਇਆ ਜਿਵੇਂ ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਹੁਕਮ ਦਿੱਤਾ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","ਫੇਰ ਉਸ ਸਾਖੀ ਨੂੰ ਲੈ ਕੇ ਸੰਦੂਕ ਵਿੱਚ ਪਾਇਆ ਅਤੇ ਚੋਬਾਂ ਸੰਦੂਕ ਉੱਤੇ ਰੱਖੀਆਂ ਅਤੇ ਪ੍ਰਾਸਚਿਤ ਦਾ ਸਰਪੋਸ਼ ਉਤਾਹਾਂ ਸੰਦੂਕ ਦੇ ਉੱਤੇ ਰੱਖਿਆ। ");
INSERT INTO pan_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","ਉਹ ਸੰਦੂਕ ਨੂੰ ਡੇਰੇ ਦੇ ਅੰਦਰ ਲਿਆਇਆ ਅਤੇ ਓਟ ਦਾ ਪੜਦਾ ਲਮਕਾਇਆ ਅਤੇ ਸਾਖੀ ਦੇ ਸੰਦੂਕ ਨੂੰ ਓਟ ਵਿੱਚ ਰੱਖਿਆ ਜਿਵੇਂ ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਹੁਕਮ ਦਿੱਤਾ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","ਫੇਰ ਉਸ ਨੇ ਮੇਜ਼ ਨੂੰ ਮੰਡਲੀ ਦੇ ਤੰਬੂ ਵਿੱਚ ਡੇਰੇ ਦੇ ਉੱਤਰ ਵੱਲ ਦੇ ਪਾਸੇ ਪਰਦੇ ਤੋਂ ਬਾਹਰ ਰੱਖਿਆ ");
INSERT INTO pan_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","ਅਤੇ ਉਸ ਨੇ ਉਸ ਉੱਤੇ ਯਹੋਵਾਹ ਅੱਗੇ ਰੋਟੀ ਸੁਆਰ ਕੇ ਰੱਖੀ ਜਿਵੇਂ ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਹੁਕਮ ਦਿੱਤਾ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","ਤਾਂ ਉਸ ਨੇ ਸ਼ਮਾਦਾਨ ਮੰਡਲੀ ਦੇ ਤੰਬੂ ਵਿੱਚ ਮੇਜ਼ ਦੇ ਸਾਹਮਣੇ ਡੇਰੇ ਦੇ ਦੱਖਣ ਵੱਲ ਦੇ ਪਾਸੇ ਰੱਖਿਆ ");
INSERT INTO pan_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","ਅਤੇ ਉਸ ਨੇ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਦੀਵੇ ਜਗਾਏ ਜਿਵੇਂ ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਹੁਕਮ ਦਿੱਤਾ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","ਫੇਰ ਉਸ ਨੇ ਸੋਨੇ ਦੀ ਜਗਵੇਦੀ ਨੂੰ ਮੰਡਲੀ ਦੇ ਤੰਬੂ ਵਿੱਚ ਪਰਦੇ ਦੇ ਸਾਹਮਣੇ ਰੱਖਿਆ ");
INSERT INTO pan_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","ਅਤੇ ਉਸ ਉੱਤੇ ਸੁਗੰਧੀ ਧੂਪ ਜਲਾਈ ਜਿਵੇਂ ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਹੁਕਮ ਦਿੱਤਾ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","ਫੇਰ ਉਸ ਨੇ ਡੇਰੇ ਦੇ ਦਰਵਾਜ਼ੇ ਦੀ ਓਟ ਲਮਕਾਈ। ");
INSERT INTO pan_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","ਤਾਂ ਉਸ ਨੇ ਹੋਮ ਦੀ ਜਗਵੇਦੀ ਨੂੰ ਡੇਰੇ ਦੀ ਮੰਡਲੀ ਦੇ ਤੰਬੂ ਦੇ ਦਰਵਾਜ਼ੇ ਉੱਤੇ ਰੱਖਿਆ ਅਤੇ ਉਸ ਉੱਤੇ ਹੋਮ ਦੀ ਭੇਟ ਅਤੇ ਮੈਦੇ ਦੀ ਭੇਟ ਚੜ੍ਹਾਈ ਜਿਵੇਂ ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਹੁਕਮ ਦਿੱਤਾ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","ਫੇਰ ਉਸ ਨੇ ਹੌਦ ਮੰਡਲੀ ਦੇ ਤੰਬੂ ਅਤੇ ਜਗਵੇਦੀ ਦੇ ਵਿਚਕਾਰ ਰੱਖਿਆ ਅਤੇ ਉਸ ਵਿੱਚ ਨਹਾਉਣ ਦਾ ਪਾਣੀ ਪਾਇਆ ");
INSERT INTO pan_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","ਅਤੇ ਮੂਸਾ ਤੇ ਹਾਰੂਨ ਅਤੇ ਉਸ ਦੇ ਪੁੱਤਰ ਉਸ ਵਿੱਚ ਹੱਥ-ਪੈਰ ਧੋਂਦੇ ਹੁੰਦੇ ਸਨ ");
INSERT INTO pan_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","ਅਰਥਾਤ ਜਦ ਉਹ ਸਾਖੀ ਦੇ ਤੰਬੂ ਵਿੱਚ ਜਾਂਦੇ ਅਤੇ ਜਦ ਉਹ ਜਗਵੇਦੀ ਦੇ ਨੇੜੇ ਆਉਂਦੇ ਸਨ ਤਾਂ ਉਹ ਅਸ਼ਨਾਨ ਕਰਦੇ ਹੁੰਦੇ ਸਨ ਜਿਵੇਂ ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਹੁਕਮ ਦਿੱਤਾ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","ਫੇਰ ਉਸ ਨੇ ਵਿਹੜਾ ਡੇਰੇ ਅਤੇ ਜਗਵੇਦੀ ਦੇ ਚੁਫ਼ੇਰੇ ਖੜਾ ਕੀਤਾ ਅਤੇ ਉਸ ਨੇ ਓਟ ਨੂੰ ਵਿਹੜੇ ਦੇ ਫਾਟਕ ਉੱਤੇ ਲਮਕਾਇਆ। ਇਸ ਤਰ੍ਹਾਂ ਮੂਸਾ ਨੇ ਉਸ ਕੰਮ ਨੂੰ ਸੰਪੂਰਨ ਕੀਤਾ। ");
INSERT INTO pan_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","ਤਦ ਬੱਦਲ ਮੰਡਲੀ ਦੇ ਤੰਬੂ ਉੱਤੇ ਛਾ ਗਿਆ ਅਤੇ ਯਹੋਵਾਹ ਦੇ ਪਰਤਾਪ ਨੇ ਡੇਰੇ ਨੂੰ ਭਰ ਦਿੱਤਾ। ");
INSERT INTO pan_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","ਫਿਰ ਮੂਸਾ ਮੰਡਲੀ ਦੇ ਤੰਬੂ ਵਿੱਚ ਵੜ ਨਾ ਸਕਿਆ ਕਿਉਂ ਜੋ ਬੱਦਲ ਉਸ ਉੱਤੇ ਛਾਇਆ ਹੋਇਆ ਸੀ ਅਤੇ ਯਹੋਵਾਹ ਦੇ ਪਰਤਾਪ ਨੇ ਡੇਰੇ ਨੂੰ ਭਰ ਦਿੱਤਾ। ");
INSERT INTO pan_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","ਜਦੋਂ ਵੀ ਬੱਦਲ ਡੇਰੇ ਦੇ ਉੱਤੋਂ ਚੁੱਕਿਆ ਜਾਂਦਾ ਸੀ ਤਦ ਇਸਰਾਏਲੀ ਆਪਣੇ ਸਾਰੇ ਸਫ਼ਰ ਵਿੱਚ ਅੱਗੇ ਕੂਚ ਕਰਦੇ ਸਨ ");
INSERT INTO pan_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","ਪਰ ਜਦ ਬੱਦਲ ਚੁੱਕਿਆ ਨਹੀਂ ਜਾਂਦਾ ਦਾ ਸੀ ਤਾਂ ਉਹ ਨਹੀਂ ਚੱਲਦੇ ਸਨ ਜਦ ਤੱਕ ਬੱਦਲ ਚੁੱਕਿਆ ਨਾ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","ਕਿਉਂਕਿ ਦਿਨ ਨੂੰ ਯਹੋਵਾਹ ਦਾ ਬੱਦਲ ਡੇਰੇ ਉੱਤੇ ਹੁੰਦਾ ਸੀ ਅਤੇ ਰਾਤ ਨੂੰ ਉਸ ਵਿੱਚ ਅੱਗ ਹੁੰਦੀ ਸੀ। ਇਸਰਾਏਲ ਦੇ ਸਾਰੇ ਘਰਾਣੇ ਦੀ ਨਿਗਾਹ ਵਿੱਚ ਉਨ੍ਹਾਂ ਦੇ ਸਾਰੇ ਸਫ਼ਰ ਵਿੱਚ ਇਸ ਤਰ੍ਹਾਂ ਹੀ ਹੁੰਦਾ ਰਿਹਾ।");
INSERT INTO pan_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਸੱਦਿਆ ਅਤੇ ਉਸ ਨੂੰ ਮੰਡਲੀ ਦੇ ਡੇਰੇ ਵਿੱਚੋਂ ਆਖਿਆ, ");
INSERT INTO pan_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","“ਇਸਰਾਏਲੀਆਂ ਨਾਲ ਗੱਲ ਕਰ ਅਤੇ ਉਨ੍ਹਾਂ ਨੂੰ ਆਖ ਕਿ ਜੇਕਰ ਤੁਹਾਡੇ ਵਿੱਚੋਂ ਕੋਈ ਮਨੁੱਖ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਭੇਟ ਲਿਆਵੇ ਤਾਂ ਤੁਸੀਂ ਪਸ਼ੂਆਂ ਵਿੱਚੋਂ ਅਰਥਾਤ ਵੱਗਾਂ ਅਤੇ ਇੱਜੜਾਂ ਵਿੱਚੋਂ ਆਪਣੀ ਭੇਟ ਲਿਆਉਣਾ।” ");
INSERT INTO pan_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","“ਜੇਕਰ ਉਸ ਦੀ ਭੇਟ ਇੱਜੜ ਵਿੱਚੋਂ ਇੱਕ ਹੋਮ ਬਲੀ ਹੋਵੇ ਤਾਂ ਉਹ ਇੱਕ ਦੋਸ਼ ਰਹਿਤ ਨਰ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਮੰਡਲੀ ਦੇ ਡੇਰੇ ਦੇ ਦਰਵਾਜ਼ੇ ਦੇ ਕੋਲ ਚੜ੍ਹਾਵੇ ਤਾਂ ਜੋ ਉਹ ਯਹੋਵਾਹ ਨੂੰ ਸਵੀਕਾਰ ਹੋਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","ਉਹ ਆਪਣਾ ਹੱਥ ਉਸ ਹੋਮ ਬਲੀ ਦੇ ਪਸ਼ੂ ਦੇ ਸਿਰ ਉੱਤੇ ਰੱਖੇ ਅਤੇ ਉਹ ਉਸ ਦਾ ਪ੍ਰਾਸਚਿਤ ਕਰਨ ਲਈ ਉਸ ਦੇ ਵੱਲੋਂ ਸਵੀਕਾਰ ਕੀਤਾ ਜਾਵੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","ਅਤੇ ਉਹ ਉਸ ਬਲ਼ਦ ਨੂੰ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਵੱਢੇ ਅਤੇ ਹਾਰੂਨ ਦੇ ਪੁੱਤਰ ਜੋ ਜਾਜਕ ਹਨ, ਉਸ ਦਾ ਲਹੂ ਲੈ ਕੇ ਉਸ ਜਗਵੇਦੀ ਦੇ ਚੁਫ਼ੇਰੇ ਛਿੜਕਣ ਜੋ ਮੰਡਲੀ ਦੇ ਡੇਰੇ ਦੇ ਦਰਵਾਜ਼ੇ ਕੋਲ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","ਉਹ ਉਸ ਹੋਮ ਬਲੀ ਦੇ ਪਸ਼ੂ ਦੀ ਖੱਲ ਉਧੇੜ ਲਵੇ ਅਤੇ ਉਸ ਨੂੰ ਟੁੱਕੜੇ-ਟੁੱਕੜੇ ਕਰੇ। ");
INSERT INTO pan_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","ਅਤੇ ਹਾਰੂਨ ਦੇ ਪੁੱਤਰ ਜੋ ਜਾਜਕ ਹਨ ਜਗਵੇਦੀ ਦੇ ਉੱਤੇ ਅੱਗ ਧਰਨ ਅਤੇ ਅੱਗ ਦੇ ਉੱਤੇ ਲੱਕੜਾਂ ਚਿਣਨ। ");
INSERT INTO pan_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","ਅਤੇ ਹਾਰੂਨ ਦੇ ਪੁੱਤਰ ਜੋ ਜਾਜਕ ਹਨ, ਉਹ ਸਿਰ ਅਤੇ ਚਰਬੀ ਸਮੇਤ ਪਸ਼ੂ ਦੇ ਟੁੱਕੜਿਆਂ ਨੂੰ ਲੱਕੜਾਂ ਦੇ ਉੱਤੇ ਜੋ ਉਸ ਜਗਵੇਦੀ ਦੀ ਅੱਗ ਉੱਤੇ ਹੈ, ਸੁਧਾਰ ਕੇ ਰੱਖਣ। ");
INSERT INTO pan_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","ਪਰ ਉਸ ਦੀਆਂ ਆਂਦਰਾਂ ਅਤੇ ਉਸ ਦੀਆਂ ਲੱਤਾਂ ਪਾਣੀ ਦੇ ਨਾਲ ਧੋ ਲੈਣ ਅਤੇ ਜਾਜਕ ਸਭ ਕੁਝ ਜਗਵੇਦੀ ਦੇ ਉੱਤੇ ਹੋਮ ਬਲੀ ਕਰਕੇ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਸੁਗੰਧਤਾ ਲਈ ਇੱਕ ਅੱਗ ਦੀ ਭੇਟ ਕਰਕੇ ਸਾੜੇ।” ");
INSERT INTO pan_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","“ਅਤੇ ਜੇਕਰ ਉਸ ਦੀ ਭੇਟ ਇੱਜੜਾਂ ਵਿੱਚੋਂ ਹੋਵੇ ਅਰਥਾਤ ਭੇਡਾਂ ਜਾਂ ਬੱਕਰਿਆਂ ਦੀ ਹੋਮ ਬਲੀ ਤਾਂ ਉਹ ਇੱਕ ਦੋਸ਼ ਰਹਿਤ ਨਰ ਲਿਆਵੇ, ");
INSERT INTO pan_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","ਅਤੇ ਉਹ ਉਸ ਨੂੰ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਜਗਵੇਦੀ ਦੀ ਉੱਤਰ ਦਿਸ਼ਾ ਵੱਲ ਵੱਢੇ ਅਤੇ ਹਾਰੂਨ ਦੇ ਪੁੱਤਰ ਜੋ ਜਾਜਕ ਹਨ, ਜਗਵੇਦੀ ਦੇ ਚੁਫ਼ੇਰੇ ਉਸ ਦਾ ਲਹੂ ਛਿੜਕਣ। ");
INSERT INTO pan_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","ਉਹ ਉਸ ਨੂੰ ਟੁੱਕੜੇ-ਟੁੱਕੜੇ ਕਰੇ ਅਤੇ ਉਸ ਦੇ ਸਿਰ ਅਤੇ ਚਰਬੀ ਨੂੰ ਵੱਖਰਾ ਕਰੇ ਅਤੇ ਜਾਜਕ ਇਨ੍ਹਾਂ ਨੂੰ ਉਸ ਲੱਕੜ ਉੱਤੇ ਸੁਧਾਰ ਕੇ ਰੱਖਣ ਜੋ ਜਗਵੇਦੀ ਦੀ ਅੱਗ ਉੱਤੇ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","ਪਰ ਉਸ ਦੀਆਂ ਆਂਦਰਾਂ ਅਤੇ ਲੱਤਾਂ ਪਾਣੀ ਨਾਲ ਧੋਵੇ ਅਤੇ ਜਾਜਕ ਇਹ ਸਭ ਕੁਝ ਲਿਆ ਕੇ ਜਗਵੇਦੀ ਦੇ ਉੱਤੇ ਸਾੜੇ। ਇਹ ਯਹੋਵਾਹ ਦੇ ਲਈ ਹੋਮ ਬਲੀ ਅਤੇ ਸੁਗੰਧਤਾ ਲਈ ਅੱਗ ਦੀ ਇੱਕ ਭੇਟ ਹੈ।” ");
INSERT INTO pan_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","“ਜੇਕਰ ਉਹ ਯਹੋਵਾਹ ਦੇ ਲਈ ਪੰਛੀਆਂ ਦੀ ਹੋਮ ਦੀ ਭੇਟ ਚੜ੍ਹਾਵੇ ਤਾਂ ਉਹ ਘੁੱਗੀਆਂ ਜਾਂ ਕਬੂਤਰਾਂ ਦੇ ਬੱਚਿਆਂ ਵਿੱਚੋਂ ਆਪਣੀ ਭੇਟ ਲਿਆਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","ਅਤੇ ਜਾਜਕ ਉਸ ਨੂੰ ਜਗਵੇਦੀ ਕੋਲ ਲਿਆਵੇ ਅਤੇ ਉਸ ਦੀ ਗਰਦਨ ਮਰੋੜ ਕੇ ਸਿਰ ਨੂੰ ਧੜ ਤੋਂ ਅਲੱਗ ਕਰੇ ਉਸ ਨੂੰ ਜਗਵੇਦੀ ਉੱਤੇ ਸਾੜੇ ਅਤੇ ਉਸਦਾ ਲਹੂ ਜਗਵੇਦੀ ਦੇ ਇੱਕ ਪਾਸੇ ਡੋਲ੍ਹ ਦੇਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","ਉਹ ਉਸ ਦੇ ਖੰਭਾਂ ਸਮੇਤ ਉਸ ਦੀ ਚੁੰਝ ਨੂੰ ਕੱਢ ਕੇ ਜਗਵੇਦੀ ਦੇ ਪੂਰਬ ਵੱਲ ਸੁਆਹ ਦੇ ਸਥਾਨ ਵਿੱਚ ਉਸ ਨੂੰ ਸੁੱਟ ਦੇਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","ਉਹ ਖੰਭਾਂ ਦੇ ਵਿੱਚੋਂ ਉਸ ਨੂੰ ਪਾੜੇ, ਪਰ ਉਸ ਨੂੰ ਵੱਖੋ-ਵੱਖ ਨਾ ਕਰੇ, ਫੇਰ ਜਾਜਕ ਉਹ ਨੂੰ ਉਸ ਲੱਕੜ ਦੀ ਅੱਗ ਉੱਤੇ ਰੱਖ ਕੇ ਸਾੜੇ ਜੋ ਜਗਵੇਦੀ ਦੇ ਉੱਤੇ ਹੈ। ਇਹ ਯਹੋਵਾਹ ਦੇ ਲਈ ਹੋਮ ਦੀ ਭੇਟ ਅਤੇ ਸੁਗੰਧਤਾ ਲਈ ਅੱਗ ਦੀ ਭੇਟ ਠਹਿਰੇ।” ");
INSERT INTO pan_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","ਜਦੋਂ ਕੋਈ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਮੈਦੇ ਦੀ ਭੇਟ ਚੜ੍ਹਾਵੇ ਤਾਂ ਉਸ ਦੀ ਭੇਟ ਸ਼ੁੱਧ ਆਟੇ ਦੀ ਹੋਵੇ ਅਤੇ ਉਹ ਉਸ ਦੇ ਉੱਤੇ ਤੇਲ ਪਾਵੇ ਅਤੇ ਉਸ ਦੇ ਉੱਤੇ ਲੁਬਾਨ ਰੱਖੇ। ");
INSERT INTO pan_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","ਉਹ ਉਸ ਨੂੰ ਹਾਰੂਨ ਦੇ ਪੁੱਤਰਾਂ ਦੇ ਕੋਲ ਜੋ ਜਾਜਕ ਹਨ ਲਿਆਵੇ ਅਤੇ ਉਹ ਮੈਦੇ, ਤੇਲ ਅਤੇ ਸਾਰੇ ਲੁਬਾਨ ਵਿੱਚੋਂ ਇੱਕ ਮੁੱਠ ਭਰ ਲਵੇ ਅਤੇ ਜਾਜਕ ਉਸ ਨੂੰ ਜਗਵੇਦੀ ਉੱਤੇ ਉਸ ਦੀ ਯਾਦਗਾਰੀ ਲਈ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਇੱਕ ਸੁਗੰਧਤਾ ਅਰਥਾਤ ਅੱਗ ਦੀ ਭੇਟ ਕਰਕੇ ਸਾੜੇ। ");
INSERT INTO pan_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","ਅਤੇ ਮੈਦੇ ਦੀ ਭੇਟ ਵਿੱਚੋਂ ਜੋ ਬਚ ਜਾਵੇ ਉਹ ਹਾਰੂਨ ਅਤੇ ਉਸ ਦੇ ਪੁੱਤਰਾਂ ਦਾ ਹੋਵੇ। ਇਹ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਅੱਗ ਦੀ ਭੇਟ ਵਿੱਚੋਂ ਅੱਤ ਪਵਿੱਤਰ ਹੈ।“ ");
INSERT INTO pan_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","“ਜੇਕਰ ਤੂੰ ਤੰਦੂਰ ਵਿੱਚ ਪਕਾਏ ਹੋਏ ਮੈਦੇ ਦੀ ਭੇਟ ਦਾ ਚੜ੍ਹਾਵਾ ਲਿਆਵੇਂ ਤਾਂ ਉਹ ਤੇਲ ਨਾਲ ਗੁੰਨੇ ਹੋਏ ਮੈਦੇ ਦੀ ਪਤੀਰੀ ਰੋਟੀ ਜਾਂ ਤੇਲ ਨਾਲ ਚੋਪੜੀਆਂ ਹੋਈਆਂ ਮੱਠੀਆਂ ਦਾ ਹੋਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","ਜੇਕਰ ਤੇਰਾ ਚੜ੍ਹਾਵਾ ਤਵੇ ਉੱਤੇ ਪਕਾਈ ਹੋਈ ਮੈਦੇ ਦੀ ਭੇਟ ਦਾ ਹੋਵੇ ਤਾਂ ਉਹ ਤੇਲ ਨਾਲ ਗੁੰਨੇ ਹੋਏ ਪਤੀਰੇ ਮੈਦੇ ਦਾ ਹੋਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","ਤੂੰ ਉਸ ਨੂੰ ਟੁੱਕੜੇ-ਟੁੱਕੜੇ ਕਰਕੇ ਉਸ ਦੇ ਉੱਤੇ ਤੇਲ ਪਾਵੀਂ। ਇਹ ਇੱਕ ਮੈਦੇ ਦੀ ਭੇਟ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","ਅਤੇ ਜੇਕਰ ਤੇਰਾ ਚੜ੍ਹਾਵਾ ਕੜਾਹੀ ਵਿੱਚ ਪਕਾਏ ਹੋਏ ਮੈਦੇ ਦੀ ਭੇਟ ਦਾ ਹੋਵੇ ਤਾਂ ਉਹ ਤੇਲ ਨਾਲ ਗੁੰਨੇ ਹੋਏ ਮੈਦੇ ਦਾ ਹੋਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","ਤੂੰ ਇੰਨ੍ਹਾਂ ਵਸਤੂਆਂ ਦੀ ਬਣੀ ਹੋਈ ਮੈਦੇ ਦੀ ਭੇਟ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਲਿਆਵੀਂ ਅਤੇ ਜਦੋਂ ਉਹ ਜਾਜਕ ਦੇ ਕੋਲ ਲਿਆਈ ਜਾਵੇ ਤਾਂ ਉਹ ਉਸ ਨੂੰ ਜਗਵੇਦੀ ਦੇ ਕੋਲ ਲਿਆਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","ਅਤੇ ਜਾਜਕ ਉਸ ਦੀ ਯਾਦਗੀਰੀ ਲਈ ਮੈਦੇ ਦੀ ਭੇਟ ਤੋਂ ਕੁਝ ਲੈ ਕੇ ਉਸ ਨੂੰ ਜਗਵੇਦੀ ਉੱਤੇ ਸਾੜੇ, ਇਹ ਯਹੋਵਾਹ ਦੇ ਲਈ ਇੱਕ ਸੁਗੰਧਤਾ ਅਰਥਾਤ ਅੱਗ ਦੀ ਭੇਟ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","ਅਤੇ ਜੋ ਕੁਝ ਉਸ ਮੈਦੇ ਦੀ ਭੇਟ ਤੋਂ ਬਚ ਜਾਵੇ ਉਹ ਹਾਰੂਨ ਅਤੇ ਉਸ ਦੇ ਪੁੱਤਰਾਂ ਦਾ ਹੋਵੇ, ਇਹ ਯਹੋਵਾਹ ਦੇ ਲਈ ਅੱਗ ਦੀਆਂ ਭੇਟਾਂ ਵਿੱਚੋਂ ਅੱਤ ਪਵਿੱਤਰ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","“ਕੋਈ ਵੀ ਮੈਦੇ ਦੀ ਭੇਟ ਜੋ ਤੁਸੀਂ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਚੜ੍ਹਾਓ ਉਸ ਵਿੱਚ ਕੁਝ ਖ਼ਮੀਰ ਨਾ ਹੋਵੇ, ਤੁਸੀਂ ਯਹੋਵਾਹ ਦੇ ਲਈ ਕਿਸੇ ਅੱਗ ਦੀ ਭੇਟ ਵਿੱਚ ਖ਼ਮੀਰ ਅਤੇ ਸ਼ਹਿਦ ਨਾ ਸਾੜਿਓ। ");
INSERT INTO pan_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","ਤੁਸੀਂ ਪਹਿਲੇ ਫ਼ਲਾਂ ਦੀ ਭੇਟ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਚੜ੍ਹਾਓ ਪਰ ਉਹ ਸੁਗੰਧਤਾ ਕਰਕੇ ਜਗਵੇਦੀ ਦੇ ਉੱਤੇ ਸਾੜੀ ਨਾ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","ਤੂੰ ਆਪਣੀ ਮੈਦੇ ਦੀ ਭੇਟ ਦੇ ਸਾਰੇ ਚੜ੍ਹਾਵਿਆਂ ਵਿੱਚ ਲੂਣ ਰਲਾਵੀਂ। ਤੂੰ ਆਪਣੀ ਮੈਦੇ ਦੀ ਭੇਟ ਵਿੱਚ ਆਪਣੇ ਪਰਮੇਸ਼ੁਰ ਦੇ ਨਾਲ ਬੰਨ੍ਹੇ ਹੋਵੇ ਨੇਮ ਦਾ ਲੂਣ ਨਾ ਘਟਾਵੀਂ ਅਤੇ ਆਪਣੀਆਂ ਸਾਰੀਆਂ ਭੇਟਾਂ ਨਾਲ ਲੂਣ ਚੜ੍ਹਾਵੀਂ। ");
INSERT INTO pan_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","“ਜੇਕਰ ਤੂੰ ਆਪਣੀ ਉਪਜ ਦੇ ਪਹਿਲੇ ਫ਼ਲਾਂ ਵਿੱਚੋਂ ਮੈਦੇ ਦੀ ਭੇਟ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਚੜ੍ਹਾਵੇਂ, ਤਾਂ ਤੂੰ ਮੈਦੇ ਦੀ ਭੇਟ ਵਿੱਚ ਆਪਣੇ ਪਹਿਲੇ ਫ਼ਲਾਂ ਦੇ ਦਾਣਿਆਂ ਦੇ ਹਰੇ ਸਿੱਟੇ ਅੱਗ ਨਾਲ ਭੁੰਨੇ ਹੋਏ ਅਰਥਾਤ ਮਸਲ ਦੇ ਕੱਢੇ ਹੋਏ ਦਾਣੇ ਚੜ੍ਹਾਵੀਂ। ");
INSERT INTO pan_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","ਤੂੰ ਉਸ ਤੇ ਤੇਲ ਪਾਵੀਂ ਅਤੇ ਉਸ ਉੱਤੇ ਲੁਬਾਨ ਰੱਖੀਂ, ਇਹ ਇੱਕ ਮੈਦੇ ਦੀ ਭੇਟ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","ਅਤੇ ਜਾਜਕ ਉਸ ਦੀ ਯਾਦਗਿਰੀ ਲਈ ਉਸ ਦੇ ਕੱਢੇ ਹੋਏ ਦਾਣਿਆਂ ਵਿੱਚੋਂ ਅਤੇ ਤੇਲ ਵਿੱਚੋਂ ਕੁਝ ਲੈ ਕੇ ਉਸ ਦੇ ਸਾਰੇ ਲੁਬਾਨ ਸਮੇਤ ਸਾੜੇ। ਇਹ ਯਹੋਵਾਹ ਦੇ ਲਈ ਅੱਗ ਦੀ ਭੇਟ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","“ਜੇਕਰ ਉਸ ਦਾ ਚੜ੍ਹਾਵਾ ਸੁੱਖ-ਸਾਂਦ ਦੀ ਬਲੀ ਦਾ ਹੋਵੇ ਅਤੇ ਜੇਕਰ ਉਹ ਉਸ ਨੂੰ ਵੱਗ ਵਿੱਚੋਂ ਚੜ੍ਹਾਵੇ, ਭਾਵੇਂ ਉਹ ਬਲ਼ਦ ਹੋਵੇ ਭਾਵੇਂ ਗਾਂ, ਉਹ ਦੋਸ਼ ਰਹਿਤ ਪਸ਼ੂ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਚੜ੍ਹਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","ਉਹ ਆਪਣਾ ਹੱਥ ਆਪਣੀ ਭੇਟ ਦੇ ਪਸ਼ੂ ਦੇ ਸਿਰ ਉੱਤੇ ਰੱਖੇ ਅਤੇ ਉਸ ਨੂੰ ਮੰਡਲੀ ਦੇ ਡੇਰੇ ਦੇ ਬੂਹੇ ਕੋਲ ਵੱਢੇ ਅਤੇ ਹਾਰੂਨ ਦੇ ਪੁੱਤਰ ਜੋ ਜਾਜਕ ਹਨ, ਉਸ ਦਾ ਲਹੂ ਜਗਵੇਦੀ ਦੇ ਚੁਫ਼ੇਰੇ ਛਿੜਕਣ। ");
INSERT INTO pan_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","ਉਹ ਸੁੱਖ-ਸਾਂਦ ਦੀ ਬਲੀ ਵਿੱਚੋਂ ਇੱਕ ਅੱਗ ਦੀ ਭੇਟ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਚੜ੍ਹਾਵੇ ਅਰਥਾਤ ਉਹ ਚਰਬੀ ਜਿਹੜੀ ਆਂਦਰਾਂ ਨੂੰ ਢੱਕਦੀ ਹੈ ਅਤੇ ਉਹ ਸਾਰੀ ਚਰਬੀ ਜੋ ਆਂਦਰਾਂ ਦੇ ਨਾਲ ਜੁੜੀ ਹੋਈ ਹੈ ");
INSERT INTO pan_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","ਅਤੇ ਦੋਵੇਂ ਗੁਰਦੇ, ਅਤੇ ਲੱਕ ਦੇ ਉੱਤੇ ਜਿਹੜੀ ਚਰਬੀ ਹੈ ਅਤੇ ਉਹ ਝਿੱਲੀ ਜੋ ਕਲੇਜੇ ਉੱਤੇ ਹੈ, ਉਸ ਨੂੰ ਗੁਰਦਿਆਂ ਸਮੇਤ ਵੱਖਰੀ ਕਰੇ। ");
INSERT INTO pan_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","ਅਤੇ ਹਾਰੂਨ ਦੇ ਪੁੱਤਰ ਉਸ ਨੂੰ ਹੋਮ ਬਲੀ ਕਰਕੇ ਲੱਕੜ ਦੀ ਅੱਗ ਵਿੱਚ ਸਾੜਨ ਜਿਹੜੀ ਜਗਵੇਦੀ ਦੇ ਉੱਤੇ ਹੈ। ਇਹ ਯਹੋਵਾਹ ਦੇ ਲਈ ਇੱਕ ਸੁਗੰਧਤਾ ਅਰਥਾਤ ਅੱਗ ਦੀ ਭੇਟ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","“ਜੇਕਰ ਯਹੋਵਾਹ ਦੇ ਲਈ ਉਸ ਦੀ ਸੁੱਖ-ਸਾਂਦ ਦੀ ਭੇਟ ਇੱਜੜ ਵਿੱਚੋਂ ਹੋਵੇ, ਭਾਵੇਂ ਨਰ ਹੋਵੇ ਭਾਵੇਂ ਮਾਦਾ, ਉਹ ਉਸ ਨੂੰ ਦੋਸ਼ ਰਹਿਤ ਚੜ੍ਹਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","ਜੇ ਉਹ ਆਪਣੀ ਭੇਟ ਵਿੱਚ ਲੇਲਾ ਚੜ੍ਹਾਵੇ ਤਾਂ ਉਹ ਉਸ ਨੂੰ ਯਹੋਵਾਹ ਦੇ ਲਈ ਚੜ੍ਹਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","ਉਹ ਆਪਣਾ ਹੱਥ ਆਪਣੀ ਭੇਟ ਦੇ ਪਸ਼ੂ ਦੇ ਸਿਰ ਉੱਤੇ ਰੱਖੇ ਅਤੇ ਉਸ ਨੂੰ ਮੰਡਲੀ ਦੇ ਡੇਰੇ ਦੇ ਅੱਗੇ ਵੱਢ ਦੇਵੇ, ਅਤੇ ਹਾਰੂਨ ਦੇ ਪੁੱਤਰ ਉਸ ਦਾ ਲਹੂ ਜਗਵੇਦੀ ਦੇ ਚੁਫ਼ੇਰੇ ਛਿੜਕਣ। ");
INSERT INTO pan_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","ਤਦ ਸੁੱਖ-ਸਾਂਦ ਦੀ ਬਲੀ ਵਿੱਚੋਂ ਉਹ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਇੱਕ ਅੱਗ ਦੀ ਭੇਟ ਚੜ੍ਹਾਵੇ ਅਰਥਾਤ ਉਸ ਦੀ ਚਰਬੀ ਨਾਲ ਭਰੀ ਪੂਛ ਰੀੜ ਦੇ ਕੋਲੋਂ ਵੱਢ ਕੇ ਵੱਖ ਕਰੇ ਅਤੇ ਉਹ ਚਰਬੀ ਜੋ ਆਂਦਰਾਂ ਨੂੰ ਢੱਕਦੀ ਹੈ ਅਤੇ ਸਾਰੀ ਚਰਬੀ ਜੋ ਆਂਦਰਾਂ ਦੇ ਨਾਲ ਜੁੜੀ ਹੋਈ ਹੈ, ");
INSERT INTO pan_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","ਅਤੇ ਦੋਵੇਂ ਗੁਰਦੇ ਅਤੇ ਲੱਕ ਦੇ ਉੱਤੇ ਜਿਹੜੀ ਚਰਬੀ ਹੈ ਅਤੇ ਉਹ ਝਿੱਲੀ ਜੋ ਕਲੇਜੇ ਉੱਤੇ ਹੈ, ਉਸ ਨੂੰ ਗੁਰਦਿਆਂ ਸਮੇਤ ਵੱਖਰੀ ਕਰੇ। ");
INSERT INTO pan_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","ਅਤੇ ਜਾਜਕ ਉਸ ਨੂੰ ਜਗਵੇਦੀ ਉੱਤੇ ਸਾੜੇ, ਇਹ ਅੱਗ ਦੀ ਭੇਟ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਭੋਜ ਦੇ ਸਮਾਨ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","“ਅਤੇ ਜੇਕਰ ਉਹ ਭੇਟ ਵਿੱਚ ਬੱਕਰਾ ਚੜ੍ਹਾਵੇ ਤਾਂ ਉਹ ਉਸ ਨੂੰ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਚੜ੍ਹਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","ਉਹ ਆਪਣਾ ਹੱਥ ਉਸ ਪਸ਼ੂ ਦੇ ਸਿਰ ਉੱਤੇ ਰੱਖੇ ਅਤੇ ਮੰਡਲੀ ਦੇ ਡੇਰੇ ਦੇ ਅੱਗੇ ਉਸ ਨੂੰ ਵੱਢ ਸੁੱਟੇ ਅਤੇ ਹਾਰੂਨ ਦੇ ਪੁੱਤਰ ਉਸ ਦਾ ਲਹੂ ਜਗਵੇਦੀ ਦੇ ਚੁਫ਼ੇਰੇ ਛਿੜਕਣ। ");
INSERT INTO pan_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","ਤਦ ਉਹ ਉਸ ਵਿੱਚੋਂ ਆਪਣੀ ਭੇਟ ਯਹੋਵਾਹ ਦੇ ਲਈ ਇੱਕ ਅੱਗ ਦੀ ਭੇਟ ਕਰਕੇ ਚੜ੍ਹਾਵੇ ਅਰਥਾਤ ਉਹ ਚਰਬੀ ਜੋ ਆਂਦਰਾਂ ਨੂੰ ਢੱਕਦੀ ਹੈ ਅਤੇ ਸਾਰੀ ਚਰਬੀ ਜੋ ਆਂਦਰਾਂ ਦੇ ਨਾਲ ਜੁੜੀ ਹੋਈ ਹੈ, ");
INSERT INTO pan_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","ਅਤੇ ਦੋਵੇਂ ਗੁਰਦੇ ਅਤੇ ਲੱਕ ਦੇ ਉੱਤੇ ਜਿਹੜੀ ਚਰਬੀ ਹੈ ਅਤੇ ਉਹ ਝਿੱਲੀ ਜੋ ਕਲੇਜੇ ਉੱਤੇ ਹੈ, ਉਸ ਨੂੰ ਗੁਰਦਿਆਂ ਸਮੇਤ ਵੱਖਰੀ ਕਰੇ। ");
INSERT INTO pan_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","ਜਾਜਕ ਉਨ੍ਹਾਂ ਨੂੰ ਜਗਵੇਦੀ ਦੇ ਉੱਤੇ ਸਾੜੇ। ਇਹ ਸੁਗੰਧਤਾ ਅਰਥਾਤ ਅੱਗ ਦੀ ਭੇਟ ਦਾ ਭੋਜਨ ਹੈ, ਸਾਰੀ ਚਰਬੀ ਯਹੋਵਾਹ ਲਈ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","“ਇਹ ਤੁਹਾਡੇ ਸਾਰੇ ਨਿਵਾਸ ਸਥਾਨਾਂ ਵਿੱਚ ਤੁਹਾਡੀਆਂ ਪੀੜ੍ਹੀਆਂ ਦੇ ਲਈ ਸਦਾ ਦੀ ਬਿਧੀ ਹੈ ਕਿ ਤੁਸੀਂ ਚਰਬੀ ਅਤੇ ਲਹੂ ਕਦੀ ਨਾ ਖਾਣਾ।” ");
INSERT INTO pan_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਆਖਿਆ, ");
INSERT INTO pan_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","ਇਸਰਾਏਲੀਆਂ ਨੂੰ ਆਖ ਕਿ ਜੇ ਕੋਈ ਮਨੁੱਖ ਅਣਜਾਣੇ ਵਿੱਚ ਕੋਈ ਅਜਿਹਾ ਕੰਮ ਕਰਕੇ ਪਾਪ ਕਰੇ, ਜਿਨ੍ਹਾਂ ਨੂੰ ਨਾ ਕਰਨ ਦਾ ਹੁਕਮ ਯਹੋਵਾਹ ਦਿੱਤਾ ਹੈ, ");
INSERT INTO pan_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","ਅਤੇ ਜੇਕਰ ਕਦੀ ਮਸਹ ਕੀਤਾ ਹੋਇਆ ਜਾਜਕ ਕੋਈ ਅਜਿਹਾ ਪਾਪ ਕਰੇ, ਜਿਸ ਦੇ ਕਾਰਨ ਪਰਜਾ ਦੋਸ਼ੀ ਠਹਿਰੇ ਤਾਂ ਉਹ ਆਪਣੇ ਉਸ ਪਾਪ ਦੇ ਲਈ ਇੱਕ ਦੋਸ਼ ਰਹਿਤ ਜੁਆਨ ਬਲ਼ਦ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਪਾਪ ਬਲੀ ਦੀ ਭੇਟ ਕਰਕੇ ਚੜ੍ਹਾਵੇ, ");
INSERT INTO pan_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","ਉਹ ਉਸ ਬਲ਼ਦ ਨੂੰ ਮੰਡਲੀ ਦੇ ਡੇਰੇ ਦੇ ਦਰਵਾਜ਼ੇ ਦੇ ਕੋਲ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਲਿਆਵੇ ਅਤੇ ਆਪਣਾ ਹੱਥ ਬਲ਼ਦ ਦੇ ਸਿਰ ਉੱਤੇ ਰੱਖੇ ਅਤੇ ਉਸ ਬਲ਼ਦ ਨੂੰ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਵੱਢ ਸੁੱਟੇ, ");
INSERT INTO pan_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","ਅਤੇ ਮਸਹ ਕੀਤਾ ਹੋਇਆ ਜਾਜਕ ਉਸ ਬਲ਼ਦ ਦੇ ਲਹੂ ਵਿੱਚੋਂ ਕੁਝ ਲੈ ਕੇ ਮੰਡਲੀ ਦੇ ਡੇਰੇ ਨੂੰ ਲਿਆਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","ਅਤੇ ਜਾਜਕ ਆਪਣੀ ਉਂਗਲੀ ਲਹੂ ਵਿੱਚ ਡੋਬ ਕੇ ਉਸ ਲਹੂ ਨੂੰ ਪਵਿੱਤਰ ਸਥਾਨ ਦੇ ਪਰਦੇ ਦੇ ਸਾਹਮਣੇ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਸੱਤ ਵਾਰੀ ਛਿੜਕੇ। ");
INSERT INTO pan_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","ਅਤੇ ਜਾਜਕ ਉਸ ਲਹੂ ਵਿੱਚੋਂ ਕੁਝ ਲੈ ਕੇ ਸੁਗੰਧੀ ਧੂਪ ਦੀ ਜਗਵੇਦੀ ਦੇ ਸਿੰਗਾਂ ਉੱਤੇ ਜੋ ਮੰਡਲੀ ਦੇ ਡੇਰੇ ਵਿੱਚ ਹੈ, ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਲਗਾਵੇ, ਫੇਰ ਬਲ਼ਦ ਦਾ ਸਾਰਾ ਲਹੂ ਹੋਮ ਦੀ ਜਗਵੇਦੀ ਦੇ ਹੇਠ ਡੋਲ੍ਹ ਦੇਵੇ, ਜੋ ਮੰਡਲੀ ਦੇ ਡੇਰੇ ਦੇ ਦਰਵਾਜ਼ੇ ਦੇ ਕੋਲ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","ਫੇਰ ਉਹ ਉਸ ਬਲ਼ਦ ਦੀ ਸਾਰੀ ਚਰਬੀ ਪਾਪ ਬਲੀ ਦੀ ਭੇਟ ਕਰਕੇ ਵੱਖਰੀ ਕਰੇ ਅਰਥਾਤ ਉਹ ਚਰਬੀ ਜਿਹੜੀ ਆਂਦਰਾਂ ਨੂੰ ਢੱਕਦੀ ਹੈ ਅਤੇ ਉਹ ਸਾਰੀ ਚਰਬੀ ਜੋ ਆਂਦਰਾਂ ਦੇ ਨਾਲ ਜੁੜੀ ਹੋਈ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","ਦੋਵੇਂ ਗੁਰਦੇ ਅਤੇ ਲੱਕ ਦੇ ਉੱਤੇ ਜਿਹੜੀ ਚਰਬੀ ਹੈ ਅਤੇ ਉਹ ਝਿੱਲੀ ਜੋ ਕਲੇਜੇ ਉੱਤੇ ਹੈ, ਉਸ ਨੂੰ ਗੁਰਦਿਆਂ ਸਮੇਤ ਵੱਖਰੀ ਕਰੇ, ");
INSERT INTO pan_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","ਜਿਸ ਤਰ੍ਹਾਂ ਸੁੱਖ-ਸਾਂਦ ਦੀਆਂ ਭੇਟਾਂ, ਬਲੀ ਦੇ ਬਲ਼ਦ ਤੋਂ ਵੱਖਰੀਆਂ ਕੀਤੀਆਂ ਜਾਂਦੀਆਂ ਹਨ। ਜਾਜਕ ਉਨ੍ਹਾਂ ਨੂੰ ਹੋਮ ਦੀ ਜਗਵੇਦੀ ਉੱਤੇ ਸਾੜੇ। ");
INSERT INTO pan_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","ਪਰ ਬਲ਼ਦ ਦੀ ਖੱਲ, ਉਸ ਦਾ ਸਾਰਾ ਮਾਸ, ਉਸ ਦਾ ਸਿਰ, ਲੱਤਾਂ ਅਤੇ ਆਂਦਰਾਂ ਸਮੇਤ ਉਸ ਦਾ ਗੋਹਾ, ");
INSERT INTO pan_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","ਅਰਥਾਤ ਸਾਰਾ ਬਲ਼ਦ, ਉਹ ਡੇਰਿਆਂ ਤੋਂ ਬਾਹਰ ਇੱਕ ਸਾਫ਼ ਸਥਾਨ ਵਿੱਚ ਜਿੱਥੇ ਸੁਆਹ ਪਾਈ ਜਾਂਦੀ ਹੈ, ਲੈ ਜਾਵੇ ਅਤੇ ਉਸ ਨੂੰ ਲੱਕੜਾਂ ਉੱਤੇ ਅੱਗ ਨਾਲ ਸਾੜ ਦੇਵੇ, ਉਹ ਉੱਥੇ ਹੀ ਸਾੜਿਆ ਜਾਵੇ ਜਿੱਥੇ ਸੁਆਹ ਪਾਈ ਜਾਂਦੀ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","ਜੇ ਕਦੀ ਇਸਰਾਏਲ ਦੀ ਸਾਰੀ ਮੰਡਲੀ ਅਣਜਾਣ ਹੋ ਕੇ ਪਾਪ ਕਰੇ ਅਤੇ ਇਹ ਗੱਲ ਸਭਾ ਤੋਂ ਲੁੱਕੀ ਹੋਵੇ ਅਤੇ ਉਨ੍ਹਾਂ ਨੇ ਯਹੋਵਾਹ ਦੇ ਹੁਕਮਾਂ ਦੇ ਵਿਰੁੱਧ ਉਹ ਕੀਤਾ ਹੋਵੇ ਜੋ ਕਰਨ ਦੇ ਯੋਗ ਨਹੀਂ ਸੀ ਅਤੇ ਦੋਸ਼ੀ ਠਹਿਰੇ ਹੋਣ, ");
INSERT INTO pan_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","ਤਾਂ ਜਦ ਉਨ੍ਹਾਂ ਦਾ ਕੀਤਾ ਹੋਇਆ ਪਾਪ ਪ੍ਰਗਟ ਹੋ ਜਾਵੇ, ਤਾਂ ਮੰਡਲੀ ਇੱਕ ਜੁਆਨ ਬਲ਼ਦ ਪਾਪ ਬਲੀ ਲਈ ਚੜ੍ਹਾਵੇ ਅਤੇ ਉਸ ਨੂੰ ਮੰਡਲੀ ਦੇ ਡੇਰੇ ਦੇ ਅੱਗੇ ਲਿਆਵੇ, ");
INSERT INTO pan_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","ਅਤੇ ਮੰਡਲੀ ਦੇ ਬਜ਼ੁਰਗ ਆਪਣੇ-ਆਪਣੇ ਹੱਥ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਬਲ਼ਦ ਦੇ ਸਿਰ ਉੱਤੇ ਰੱਖਣ ਅਤੇ ਉਹ ਬਲ਼ਦ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਵੱਢਿਆ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","ਅਤੇ ਮਸਹ ਕੀਤਾ ਹੋਇਆ ਜਾਜਕ ਉਸ ਬਲ਼ਦ ਦੇ ਲਹੂ ਵਿੱਚੋਂ ਕੁਝ ਲੈ ਕੇ ਮੰਡਲੀ ਦੇ ਡੇਰੇ ਨੂੰ ਲਿਆਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","ਅਤੇ ਜਾਜਕ ਆਪਣੀ ਉਂਗਲੀ ਲਹੂ ਵਿੱਚ ਡੋਬ ਕੇ ਪਵਿੱਤਰ ਸਥਾਨ ਦੇ ਪਰਦੇ ਦੇ ਸਾਹਮਣੇ, ਉਹ ਲਹੂ ਨੂੰ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਸੱਤ ਵਾਰੀ ਛਿੜਕੇ। ");
INSERT INTO pan_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","ਅਤੇ ਜਾਜਕ ਉਸ ਲਹੂ ਵਿੱਚੋਂ ਕੁਝ ਲੈ ਕੇ ਜਗਵੇਦੀ ਦੇ ਸਿੰਗਾਂ ਉੱਤੇ ਜੋ ਮੰਡਲੀ ਦੇ ਡੇਰੇ ਵਿੱਚ ਹੈ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਲਗਾਵੇ, ਫਿਰ ਬਲ਼ਦ ਦਾ ਸਾਰਾ ਲਹੂ ਹੋਮ ਦੀ ਜਗਵੇਦੀ ਦੇ ਹੇਠ ਡੋਲ੍ਹ ਦੇਵੇ, ਜੋ ਮੰਡਲੀ ਦੇ ਡੇਰੇ ਦੇ ਦਰਵਾਜ਼ੇ ਦੇ ਕੋਲ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","ਅਤੇ ਉਹ ਉਸ ਬਲ਼ਦ ਦੀ ਸਾਰੀ ਚਰਬੀ ਲੈ ਕੇ ਜਗਵੇਦੀ ਦੇ ਉੱਤੇ ਸਾੜੇ। ");
INSERT INTO pan_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","ਅਤੇ ਜਿਸ ਤਰ੍ਹਾਂ ਉਸ ਨੇ ਪਾਪ ਬਲੀ ਦੀ ਭੇਟ ਦੇ ਬਲ਼ਦ ਦੇ ਨਾਲ ਕੀਤਾ ਸੀ, ਉਸੇ ਤਰ੍ਹਾਂ ਹੀ ਉਹ ਇਸ ਬਲ਼ਦ ਨਾਲ ਕਰੇ ਅਤੇ ਜਾਜਕ ਇਸਰਾਏਲੀਆਂ ਦੇ ਲਈ ਪ੍ਰਾਸਚਿਤ ਕਰੇ ਅਤੇ ਉਨ੍ਹਾਂ ਦਾ ਪਾਪ ਮਾਫ਼ ਕੀਤਾ ਜਾਵੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","ਅਤੇ ਜਿਸ ਤਰ੍ਹਾਂ ਉਸ ਨੇ ਪਹਿਲੇ ਬਲ਼ਦ ਨੂੰ ਸਾੜਿਆ ਸੀ, ਉਸੇ ਤਰ੍ਹਾਂ ਹੀ ਇਸ ਬਲ਼ਦ ਨੂੰ ਵੀ ਡੇਰੇ ਤੋਂ ਬਾਹਰ ਲੈ ਜਾ ਕੇ ਸਾੜੇ। ਇਹ ਮੰਡਲੀ ਦੇ ਲਈ ਪਾਪ ਦੀ ਭੇਟ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","ਜਦੋਂ ਕੋਈ ਪ੍ਰਧਾਨ ਪਾਪ ਕਰੇ ਅਤੇ ਯਹੋਵਾਹ ਆਪਣੇ ਪਰਮੇਸ਼ੁਰ ਦੇ ਹੁਕਮਾਂ ਦੇ ਵਿਰੁੱਧ ਅਣਜਾਣੇ ਵਿੱਚ ਕੁਝ ਅਜਿਹਾ ਕਰੇ ਜੋ ਕਰਨ ਜੋਗ ਨਹੀਂ ਸੀ ਅਤੇ ਦੋਸ਼ੀ ਠਹਿਰੇ, ");
INSERT INTO pan_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","ਤਦ ਜੇਕਰ ਉਸ ਦਾ ਕੀਤਾ ਹੋਇਆ ਪਾਪ ਉਸ ਉੱਤੇ ਪ੍ਰਗਟ ਹੋ ਜਾਵੇ ਤਾਂ ਉਹ ਦੋਸ਼ ਰਹਿਤ ਇੱਕ ਬੱਕਰਾ ਆਪਣੀ ਭੇਟ ਵਿੱਚ ਲਿਆਵੇ, ");
INSERT INTO pan_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","ਅਤੇ ਉਹ ਆਪਣਾ ਹੱਥ ਬੱਕਰੇ ਦੇ ਸਿਰ ਉੱਤੇ ਰੱਖੇ ਅਤੇ ਉਸ ਨੂੰ ਉਸ ਸਥਾਨ ਵਿੱਚ ਜਿੱਥੇ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਹੋਮ ਬਲੀ ਨੂੰ ਵੱਢਦੇ ਹਨ, ਵੱਢ ਦੇਵੇ, ਇਹ ਇੱਕ ਪਾਪ ਦੀ ਭੇਟ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","ਅਤੇ ਜਾਜਕ ਉਸ ਪਾਪ ਬਲੀ ਦੀ ਭੇਟ ਦੇ ਲਹੂ ਤੋਂ ਕੁਝ ਲੈ ਕੇ ਆਪਣੀ ਉਂਗਲ ਨਾਲ ਹੋਮ ਦੀ ਜਗਵੇਦੀ ਦੇ ਸਿੰਗਾਂ ਉੱਤੇ ਲਗਾਵੇ ਅਤੇ ਉਸ ਦਾ ਲਹੂ ਹੋਮ ਦੀ ਜਗਵੇਦੀ ਦੇ ਹੇਠ ਡੋਲ੍ਹ ਦੇਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","ਅਤੇ ਉਹ ਉਸ ਦੀ ਸਾਰੀ ਚਰਬੀ ਸੁੱਖ-ਸਾਂਦ ਦੀ ਬਲੀ ਦੀ ਚਰਬੀ ਦੀ ਤਰ੍ਹਾਂ ਜਗਵੇਦੀ ਉੱਤੇ ਸਾੜੇ ਅਤੇ ਜਾਜਕ ਉਸ ਦੇ ਲਈ ਪ੍ਰਾਸਚਿਤ ਕਰੇ ਤਦ ਉਸ ਦਾ ਪਾਪ ਮਾਫ਼ ਕੀਤਾ ਜਾਵੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","ਜੇਕਰ ਆਮ ਲੋਕਾਂ ਵਿੱਚੋਂ ਕੋਈ ਯਹੋਵਾਹ ਦੇ ਹੁਕਮਾਂ ਦੇ ਵਿਰੁੱਧ ਅਣਜਾਣੇ ਵਿੱਚ ਕੋਈ ਅਜਿਹਾ ਕੰਮ ਕਰਕੇ ਪਾਪ ਕਰੇ ਜਿਸ ਨੂੰ ਨਾ ਕਰਨ ਦਾ ਹੁਕਮ ਯਹੋਵਾਹ ਨੇ ਦਿੱਤਾ ਸੀ ਅਤੇ ਦੋਸ਼ੀ ਠਹਿਰੇ, ");
INSERT INTO pan_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","ਫਿਰ ਜਦ ਉਸ ਦਾ ਪਾਪ ਉਸ ਉੱਤੇ ਪ੍ਰਗਟ ਹੋ ਜਾਵੇ ਤਾਂ ਉਹ ਉਸ ਪਾਪ ਦੇ ਕਾਰਨ ਦੋਸ਼ ਰਹਿਤ ਇੱਕ ਬੱਕਰੀ ਆਪਣੀ ਭੇਟ ਲਈ ਲਿਆਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","ਅਤੇ ਉਹ ਆਪਣਾ ਹੱਥ ਉਸ ਪਾਪ ਬਲੀ ਦੀ ਭੇਟ ਦੇ ਸਿਰ ਉੱਤੇ ਰੱਖੇ ਅਤੇ ਉਸ ਨੂੰ ਉਸ ਸਥਾਨ ਵਿੱਚ ਜਿੱਥੇ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਹੋਮ ਬਲੀ ਨੂੰ ਵੱਢਦੇ ਹਨ, ਵੱਢ ਦੇਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","ਅਤੇ ਜਾਜਕ ਉਸ ਦੇ ਲਹੂ ਤੋਂ ਕੁਝ ਲੈ ਕੇ ਆਪਣੀ ਉਂਗਲ ਨਾਲ ਹੋਮ ਦੀ ਜਗਵੇਦੀ ਦੇ ਸਿੰਗਾਂ ਉੱਤੇ ਲਗਾਵੇ ਅਤੇ ਉਸ ਦਾ ਲਹੂ ਹੋਮ ਦੀ ਜਗਵੇਦੀ ਦੇ ਹੇਠ ਡੋਲ੍ਹ ਦੇਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","ਫੇਰ ਜਿਸ ਤਰ੍ਹਾਂ ਸੁੱਖ-ਸਾਂਦ ਦੀਆਂ ਬਲੀਆਂ ਵਿੱਚੋਂ ਚਰਬੀ ਵੱਖਰੀ ਕੀਤੀ ਜਾਂਦੀ ਹੈ, ਉਸੇ ਤਰ੍ਹਾਂ ਉਹ ਉਸ ਦੀ ਸਾਰੀ ਚਰਬੀ ਵੱਖਰੀ ਕਰੇ ਅਤੇ ਜਾਜਕ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਉਸ ਨੂੰ ਸੁਗੰਧਤਾ ਕਰਕੇ ਜਗਵੇਦੀ ਉੱਤੇ ਸਾੜੇ ਅਤੇ ਜਾਜਕ ਉਸ ਦੇ ਲਈ ਪ੍ਰਾਸਚਿਤ ਕਰੇ ਤਦ ਉਸ ਦਾ ਪਾਪ ਮਾਫ਼ ਕੀਤਾ ਜਾਵੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","ਜੇਕਰ ਉਹ ਪਾਪ ਬਲੀ ਦੀ ਭੇਟ ਵਿੱਚ ਇੱਕ ਭੇਡ ਲਿਆਵੇ ਤਾਂ ਉਹ ਦੋਸ਼ ਰਹਿਤ ਇੱਕ ਲੇਲੀ ਲਿਆਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","ਅਤੇ ਉਹ ਆਪਣਾ ਹੱਥ ਉਸ ਪਾਪ ਬਲੀ ਦੀ ਭੇਟ ਦੇ ਸਿਰ ਉੱਤੇ ਰੱਖੇ ਅਤੇ ਉਸ ਸਥਾਨ ਵਿੱਚ ਜਿੱਥੇ ਹੋਮ ਬਲੀ ਨੂੰ ਵੱਢਦੇ ਹਨ, ਉਸ ਨੂੰ ਇੱਕ ਪਾਪ ਬਲੀ ਦੀ ਭੇਟ ਕਰਕੇ ਵੱਢ ਦੇਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","ਅਤੇ ਜਾਜਕ ਪਾਪ ਬਲੀ ਦੀ ਭੇਟ ਦੇ ਲਹੂ ਤੋਂ ਕੁਝ ਲੈ ਕੇ ਆਪਣੀ ਉਂਗਲ ਨਾਲ ਹੋਮ ਦੀ ਜਗਵੇਦੀ ਦੇ ਸਿੰਗਾਂ ਉੱਤੇ ਲਗਾਵੇ ਅਤੇ ਉਸ ਦਾ ਲਹੂ ਹੋਮ ਦੀ ਜਗਵੇਦੀ ਦੇ ਹੇਠ ਡੋਲ੍ਹ ਦੇਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","ਫੇਰ ਜਿਸ ਤਰ੍ਹਾਂ ਸੁੱਖ-ਸਾਂਦ ਦੀਆਂ ਬਲੀਆਂ ਵਿੱਚੋਂ ਚਰਬੀ ਵੱਖਰੀ ਕੀਤੀ ਜਾਂਦੀ ਹੈ, ਉਸੇ ਤਰ੍ਹਾਂ ਉਹ ਉਸ ਦੀ ਸਾਰੀ ਚਰਬੀ ਵੱਖਰੀ ਕਰੇ ਅਤੇ ਜਾਜਕ ਯਹੋਵਾਹ ਦੀਆਂ ਅੱਗ ਦੀਆਂ ਭੇਟਾਂ ਦੇ ਅਨੁਸਾਰ ਉਨ੍ਹਾਂ ਨੂੰ ਸਾੜੇ, ਅਤੇ ਜਾਜਕ ਉਸ ਦੇ ਪਾਪ ਲਈ ਪ੍ਰਾਸਚਿਤ ਕਰੇ ਤਦ ਉਸ ਦਾ ਪਾਪ ਮਾਫ਼ ਕੀਤਾ ਜਾਵੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","ਜੇਕਰ ਕੋਈ ਮਨੁੱਖ ਅਜਿਹਾ ਪਾਪ ਕਰੇ ਕਿ ਉਹ ਕਿਸੇ ਗੱਲ ਦਾ ਗਵਾਹ ਹੋਵੇ ਅਤੇ ਸਹੁੰ ਚੁੱਕਣ ਤੋਂ ਬਾਅਦ ਵੀ ਉਹ ਨਾ ਦੱਸੇ ਕਿ ਉਸ ਨੇ ਕੁਝ ਵੇਖਿਆ ਜਾਂ ਜਾਣਿਆ ਹੈ, ਤਾਂ ਉਹ ਦੋਸ਼ੀ ਠਹਿਰੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","ਜੇਕਰ ਕੋਈ ਮਨੁੱਖ ਅਣਜਾਣੇ ਵਿੱਚ ਕਿਸੇ ਅਪਵਿੱਤਰ ਵਸਤੂ ਨੂੰ ਛੂਹ ਲਵੇ, ਭਾਵੇਂ ਅਪਵਿੱਤਰ ਜਾਨਵਰ, ਜਾਂ ਅਪਵਿੱਤਰ ਪਸ਼ੂ, ਜਾਂ ਅਪਵਿੱਤਰ ਘਿਸਰਨ ਵਾਲੇ ਜੀਵ-ਜੰਤੂਆਂ ਵਿੱਚੋਂ ਕਿਸੇ ਦੀ ਲੋਥ ਹੋਵੇ, ਤਾਂ ਉਹ ਵੀ ਅਪਵਿੱਤਰ ਅਤੇ ਦੋਸ਼ੀ ਠਹਿਰੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","ਅਤੇ ਜੇਕਰ ਉਹ ਮਨੁੱਖ ਦੀ ਕਿਸੇ ਗੰਦਗੀ ਨੂੰ ਅਣਜਾਣੇ ਵਿੱਚ ਛੂਹ ਲਵੇ, ਭਾਵੇਂ ਕਿਸੇ ਵੀ ਤਰ੍ਹਾਂ ਦੀ ਗੰਦਗੀ ਹੋਵੇ, ਜਿਸ ਤੋਂ ਮਨੁੱਖ ਅਪਵਿੱਤਰ ਹੁੰਦਾ ਹੈ, ਤਾਂ ਜਿਸ ਵੇਲੇ ਉਸ ਨੂੰ ਇਸ ਬਾਰੇ ਖ਼ਬਰ ਹੋਵੇ, ਤਾਂ ਉਹ ਦੋਸ਼ੀ ਠਹਿਰੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","ਅਤੇ ਜੇਕਰ ਕੋਈ ਮਨੁੱਖ ਬਿਨ੍ਹਾਂ ਸੋਚੇ ਸਮਝੇ ਭਲਾ ਜਾਂ ਬੁਰਾ ਕਰਨ ਦੀ ਸਹੁੰ ਚੁੱਕੇ ਅਤੇ ਭਾਵੇਂ ਕਿਸੇ ਵੀ ਤਰ੍ਹਾਂ ਦੀ ਗੱਲ ਉਹ ਬਿਨ੍ਹਾਂ ਸੋਚੇ ਸਮਝੇ ਸਹੁੰ ਚੁੱਕ ਕੇ ਆਖੇ, ਤਾਂ ਜਿਸ ਵੇਲੇ ਉਸ ਨੂੰ ਖ਼ਬਰ ਹੋਵੇ ਤਦ ਉਹ ਇੰਨ੍ਹਾਂ ਗੱਲਾਂ ਵਿੱਚ ਦੋਸ਼ੀ ਠਹਿਰੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","ਅਤੇ ਅਜਿਹਾ ਹੋਵੇ ਕਿ ਜਦ ਉਹ ਇਨ੍ਹਾਂ ਗੱਲਾਂ ਵਿੱਚੋਂ ਕਿਸੇ ਵੀ ਗੱਲ ਦਾ ਦੋਸ਼ੀ ਠਹਿਰੇ ਤਾਂ ਜਿਸ ਗੱਲ ਵਿੱਚ ਉਸ ਨੇ ਪਾਪ ਕੀਤਾ ਹੋਵੇ, ਉਹ ਉਸ ਨੂੰ ਮੰਨ ਲਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","ਉਹ ਆਪਣੇ ਪਾਪ ਦੇ ਕਾਰਨ ਜੋ ਉਸ ਨੇ ਕੀਤਾ, ਭੇਡ ਜਾਂ ਬੱਕਰੀ ਪਾਪ ਬਲੀ ਦੀ ਭੇਟ ਲਈ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਲਿਆਵੇ, ਤਦ ਜਾਜਕ ਉਸ ਦੇ ਪਾਪ ਦੇ ਲਈ ਪ੍ਰਾਸਚਿਤ ਕਰੇ। ");
INSERT INTO pan_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","ਜੇਕਰ ਉਹ ਇੱਕ ਲੇਲਾ ਲਿਆਉਣ ਦੇ ਯੋਗ ਨਾ ਹੋਵੇ ਤਾਂ ਉਹ ਆਪਣੇ ਪਾਪ ਦੇ ਲਈ, ਦੋ ਘੁੱਗੀਆਂ ਜਾਂ ਕਬੂਤਰਾਂ ਦੇ ਦੋ ਬੱਚੇ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਦੋਸ਼ ਬਲੀ ਦੀ ਭੇਟ ਕਰਕੇ ਲਿਆਵੇ, ਇੱਕ ਪਾਪ ਬਲੀ ਦੀ ਭੇਟ ਲਈ ਅਤੇ ਦੂਜਾ ਹੋਮ ਬਲੀ ਦੀ ਭੇਟ ਦੇ ਲਈ, ");
INSERT INTO pan_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","ਅਤੇ ਉਨ੍ਹਾਂ ਨੂੰ ਜਾਜਕ ਕੋਲ ਲਿਆਵੇ ਅਤੇ ਜਾਜਕ ਪਾਪ ਬਲੀ ਦੀ ਭੇਟ ਨੂੰ ਪਹਿਲਾਂ ਚੜ੍ਹਾਵੇ ਅਤੇ ਉਸ ਦਾ ਸਿਰ ਮਰੋੜ ਦੇਵੇ ਪਰ ਉਸ ਨੂੰ ਚੀਰ ਕੇ ਵੱਖੋ-ਵੱਖ ਨਾ ਕਰੇ। ");
INSERT INTO pan_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","ਅਤੇ ਉਹ ਪਾਪ ਬਲੀ ਦੀ ਭੇਟ ਦੇ ਲਹੂ ਵਿੱਚੋਂ ਕੁਝ ਜਗਵੇਦੀ ਦੇ ਇੱਕ ਪਾਸੇ ਛਿੜਕੇ ਅਤੇ ਬਾਕੀ ਲਹੂ ਜਗਵੇਦੀ ਦੇ ਹੇਠ ਡੋਲ੍ਹਿਆ ਜਾਵੇ, ਇਹ ਪਾਪ ਬਲੀ ਦੀ ਭੇਟ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","ਅਤੇ ਦੂਜੇ ਪੰਛੀ ਨੂੰ ਹੋਮ ਬਲੀ ਕਰਕੇ ਬਿਧੀ ਦੇ ਅਨੁਸਾਰ ਚੜ੍ਹਾਵੇ ਅਤੇ ਜਾਜਕ ਉਸ ਦੇ ਪਾਪ ਦੇ ਲਈ ਉਸ ਦਾ ਪ੍ਰਾਸਚਿਤ ਕਰੇ ਤਦ ਉਸ ਨੂੰ ਮਾਫ਼ ਕੀਤਾ ਜਾਵੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","ਪਰ ਜੇਕਰ ਉਹ ਦੋ ਘੁੱਗੀਆਂ ਜਾਂ ਕਬੂਤਰਾਂ ਦੇ ਦੋ ਬੱਚੇ ਵੀ ਨਾ ਲਿਆ ਸਕੇ ਤਾਂ ਉਹ ਆਪਣੇ ਪਾਪ ਦੇ ਕਾਰਨ ਆਪਣੀ ਭੇਟ ਵਿੱਚ ਇੱਕ ਏਫ਼ਾਹ ਦਾ ਦਸਵਾਂ ਹਿੱਸਾ ਮੈਦਾ ਪਾਪ ਬਲੀ ਦੀ ਭੇਟ ਕਰਕੇ ਲਿਆਵੇ, ਉਹ ਉਸ ਦੇ ਉੱਤੇ ਤੇਲ ਨਾ ਪਾਵੇ, ਨਾ ਉਸ ਦੇ ਉੱਤੇ ਲੁਬਾਨ ਰੱਖੇ, ਕਿਉਂ ਜੋ ਉਹ ਪਾਪ ਦੀ ਭੇਟ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","ਤਦ ਉਹ ਉਸ ਨੂੰ ਜਾਜਕ ਦੇ ਕੋਲ ਲਿਆਵੇ ਅਤੇ ਜਾਜਕ ਉਸ ਵਿੱਚੋਂ ਇੱਕ ਮੁੱਠ ਭਰ ਕੇ ਯਾਦਗਿਰੀ ਦੇ ਲਈ ਉਸ ਨੂੰ ਜਗਵੇਦੀ ਉੱਤੇ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਅੱਗ ਦੀਆਂ ਭੇਟਾਂ ਦੇ ਉੱਤੇ ਸਾੜੇ। ਇਹ ਪਾਪ ਦੀ ਭੇਟ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","ਅਤੇ ਇਨ੍ਹਾਂ ਗੱਲਾਂ ਵਿੱਚੋਂ ਕਿਸੇ ਵੀ ਗੱਲ ਦੇ ਵਿਖੇ ਜਿਹੜਾ ਪਾਪ ਕਰੇ, ਜਾਜਕ ਉਸ ਦੇ ਲਈ ਪ੍ਰਾਸਚਿਤ ਕਰੇ ਤਦ ਉਸ ਦਾ ਪਾਪ ਮਾਫ਼ ਕੀਤਾ ਜਾਵੇਗਾ। ਪਾਪ ਬਲੀ ਦਾ ਬਚਿਆ ਹੋਇਆ ਹਿੱਸਾ ਮੈਦੇ ਦੀ ਭੇਟ ਦੀ ਤਰ੍ਹਾਂ ਜਾਜਕ ਦਾ ਹੋਵੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਆਖਿਆ, ");
INSERT INTO pan_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","ਜੇ ਕੋਈ ਮਨੁੱਖ ਯਹੋਵਾਹ ਦੀਆਂ ਪਵਿੱਤਰ ਵਸਤੂਆਂ ਦੇ ਵਿਖੇ ਅਣਜਾਣ ਹੋ ਕੇ ਪਾਪ ਕਰੇ ਅਤੇ ਦੋਸ਼ੀ ਠਹਿਰੇ ਤਾਂ ਉਹ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਇੱਜੜਾਂ ਵਿੱਚੋਂ ਇੱਕ ਦੋਸ਼ ਰਹਿਤ ਭੇਡੂ ਲਿਆਵੇ ਅਤੇ ਉਸ ਦਾ ਮੁੱਲ ਪਵਿੱਤਰ ਸਥਾਨ ਦੇ ਸ਼ਕੇਲ ਅਨੁਸਾਰ ਓਨ੍ਹੇ ਹੀ ਚਾਂਦੀ ਦੇ ਸ਼ਕੇਲ ਹੋਵੇ, ਜਿੰਨਾਂ ਜਾਜਕ ਠਹਿਰਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","ਅਤੇ ਜਿਸ ਪਵਿੱਤਰ ਵਸਤੂ ਦੇ ਵਿਖੇ ਉਸ ਨੇ ਪਾਪ ਕੀਤਾ ਹੋਵੇ, ਉਸ ਵਿੱਚ ਉਹ ਪੰਜਵਾਂ ਹਿੱਸਾ ਹੋਰ ਵਧਾ ਕੇ ਜਾਜਕ ਨੂੰ ਦੇਵੇ ਅਤੇ ਜਾਜਕ ਦੋਸ਼ ਬਲੀ ਦੀ ਭੇਟ ਦਾ ਭੇਡੂ ਚੜ੍ਹਾ ਕੇ ਉਸ ਦੇ ਲਈ ਪ੍ਰਾਸਚਿਤ ਕਰੇ ਅਤੇ ਉਸ ਦਾ ਪਾਪ ਮਾਫ਼ ਕੀਤਾ ਜਾਵੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","ਜੇਕਰ ਕੋਈ ਮਨੁੱਖ ਪਾਪ ਕਰੇ ਅਤੇ ਅਜਿਹਾ ਕੰਮ ਕਰੇ ਜਿਸ ਨੂੰ ਕਰਨ ਦਾ ਹੁਕਮ ਯਹੋਵਾਹ ਨੇ ਨਹੀਂ ਦਿੱਤਾ, ਤਾਂ ਭਾਵੇਂ ਉਸ ਨੂੰ ਇਸ ਬਾਰੇ ਖ਼ਬਰ ਨਾ ਹੋਵੇ ਤਾਂ ਵੀ ਉਹ ਦੋਸ਼ੀ ਹੈ ਅਤੇ ਉਸ ਨੂੰ ਆਪਣੇ ਪਾਪ ਦਾ ਭਾਰ ਚੁੱਕਣਾ ਪਵੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","ਇਸ ਲਈ ਉਹ ਇੱਕ ਦੋਸ਼ ਰਹਿਤ ਭੇਡੂ ਦੋਸ਼ ਬਲੀ ਕਰਕੇ ਜਾਜਕ ਦੇ ਕੋਲ ਲਿਆਵੇ, ਉਹ ਜਿੰਨਾਂ ਜਾਜਕ ਠਹਿਰਾਉਣ ਓਨ੍ਹੇ ਹੀ ਮੁੱਲ ਦਾ ਹੋਵੇ ਅਤੇ ਜਾਜਕ ਉਸ ਦੇ ਲਈ ਉਸ ਦੇ ਅਣਜਾਣਪੁਣੇ ਵਿੱਚ ਕੀਤੇ ਹੋਏ ਪਾਪ ਦਾ ਪ੍ਰਾਸਚਿਤ ਕਰੇ ਅਤੇ ਉਸ ਨੂੰ ਮਾਫ਼ ਕੀਤਾ ਜਾਵੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","ਇਹ ਦੋਸ਼ ਬਲੀ ਦੀ ਭੇਟ ਹੈ, ਕਿਉਂਕਿ ਉਸ ਨੇ ਜ਼ਰੂਰ ਹੀ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਪਾਪ ਕੀਤਾ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਆਖਿਆ, ");
INSERT INTO pan_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","ਜੇ ਕੋਈ ਮਨੁੱਖ ਯਹੋਵਾਹ ਦੇ ਵਿਰੁੱਧ ਪਾਪ ਕਰਕੇ ਦੋਸ਼ੀ ਠਹਿਰੇ ਅਤੇ ਆਪਣੇ ਗੁਆਂਢੀ ਨਾਲ ਗਿਰਵੀ ਰੱਖੀ ਹੋਈ ਵਸਤੂ, ਲੈਣ-ਦੇਣ ਅਤੇ ਠੱਗੀ ਦੇ ਮਾਮਲਿਆਂ ਵਿੱਚ ਉਸ ਨਾਲ ਧੋਖਾ ਕਰੇ ਜਾਂ ਉਸ ਨੂੰ ਲੁੱਟੇ, ");
INSERT INTO pan_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","ਜਾਂ ਕਿਸੇ ਗੁਆਚੀ ਹੋਈ ਵਸਤੂ ਨੂੰ ਲੱਭੇ ਅਤੇ ਉਸ ਦੇ ਵਿਖੇ ਝੂਠ ਬੋਲੇ ਅਤੇ ਝੂਠੀ ਸਹੁੰ ਚੁੱਕੇ, ਅਜਿਹਾ ਕੋਈ ਵੀ ਕੰਮ ਜਿਸ ਨੂੰ ਕਰਕੇ ਮਨੁੱਖ ਪਾਪੀ ਠਹਿਰਦਾ ਹੈ, ");
INSERT INTO pan_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","ਤਾਂ ਜਦ ਉਹ ਅਜਿਹਾ ਕੰਮ ਕਰਕੇ ਦੋਸ਼ੀ ਠਹਿਰੇ ਤਾਂ ਜਿਹੜੀ ਵਸਤੂ ਉਸ ਨੇ ਖੋਹ ਲਈ ਸੀ, ਜਾਂ ਉਸ ਨੂੰ ਛਲ ਨਾਲ ਮਿਲੀ, ਜਾਂ ਉਸ ਦੇ ਕੋਲ ਗਿਰਵੀ ਰੱਖੀ ਸੀ, ਜਾਂ ਗੁਆਚੀ ਹੋਈ ਵਸਤੂ ਉਸ ਨੂੰ ਲੱਭੀ ਹੋਵੇ, ");
INSERT INTO pan_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","ਜਾਂ ਕੋਈ ਵੀ ਵਸਤੂ ਹੋਵੇ ਜਿਸ ਦੇ ਵਿਖੇ ਉਸ ਨੇ ਝੂਠੀ ਸਹੁੰ ਚੁੱਕੀ ਹੋਵੇ, ਤਾਂ ਜਿਸ ਦਿਨ ਉਸ ਨੂੰ ਇਹ ਖ਼ਬਰ ਹੋਵੇ ਕਿ ਉਹ ਦੋਸ਼ੀ ਹੈ ਤਾਂ ਉਹ ਉਸ ਨੂੰ ਉਸੇ ਤਰ੍ਹਾਂ ਹੀ ਸਗੋਂ ਉਸ ਦੇ ਨਾਲ ਪੰਜਵਾਂ ਹਿੱਸਾ ਹੋਰ ਪਾ ਕੇ ਉਸ ਦੇ ਸੁਆਮੀ ਨੂੰ ਮੋੜ ਦੇਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","ਅਤੇ ਉਹ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਆਪਣੀ ਦੋਸ਼ ਬਲੀ ਦੀ ਭੇਟ ਲਈ ਇੱਜੜ ਵਿੱਚੋਂ ਦੋਸ਼ ਰਹਿਤ ਇੱਕ ਭੇਡੂ ਜਾਜਕ ਦੇ ਕੋਲ ਲਿਆਵੇ, ਉਸ ਦਾ ਮੁੱਲ ਓਨਾ ਹੀ ਹੋਵੇ ਜਿਨ੍ਹਾਂ ਜਾਜਕ ਠਹਿਰਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","ਅਤੇ ਜਾਜਕ ਉਸ ਦੇ ਲਈ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਪ੍ਰਾਸਚਿਤ ਕਰੇ ਅਤੇ ਜਿਸ ਕੰਮ ਵਿੱਚ ਉਸ ਨੇ ਪਾਪ ਕੀਤਾ ਹੋਵੇ, ਉਹ ਉਸ ਨੂੰ ਮਾਫ਼ ਕੀਤਾ ਜਾਵੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","ਫੇਰ ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਆਖਿਆ, ");
INSERT INTO pan_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","ਹਾਰੂਨ ਅਤੇ ਉਸ ਦੇ ਪੁੱਤਰਾਂ ਨੂੰ ਇਹ ਆਖ ਕੇ ਹੁਕਮ ਦੇ ਕਿ ਹੋਮ ਬਲੀ ਦੀ ਭੇਟ ਦੀ ਬਿਵਸਥਾ ਇਹ ਹੈ: ਹੋਮ ਬਲੀ ਸਾਰੀ ਰਾਤ ਤੋਂ ਸਵੇਰ ਤੱਕ ਜਗਵੇਦੀ ਦੇ ਉੱਤੇ ਪਈ ਰਹੇ ਅਤੇ ਜਗਵੇਦੀ ਦੀ ਅੱਗ ਉਸ ਦੇ ਵਿੱਚ ਬਲ਼ਦੀ ਰਹੇ। ");
INSERT INTO pan_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","ਅਤੇ ਜਾਜਕ ਆਪਣੇ ਕਤਾਨ ਦੇ ਬਸਤਰ ਅਤੇ ਆਪਣੇ ਸਰੀਰ ਉੱਤੇ ਅੰਗਰੱਖਾ ਪਹਿਨ ਲਵੇ ਅਤੇ ਹੋਮ ਬਲੀ ਦੀ ਸੁਆਹ ਜਿਹੜੀ ਅੱਗ ਨਾਲ ਭਸਮ ਕਰਨ ਤੋਂ ਬਾਅਦ ਜਗਵੇਦੀ ਉੱਤੇ ਬਚ ਜਾਵੇ, ਉਸ ਨੂੰ ਚੁੱਕ ਕੇ ਜਗਵੇਦੀ ਦੇ ਇੱਕ ਪਾਸੇ ਰੱਖ ਦੇਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","ਤਦ ਉਹ ਆਪਣੇ ਇਹ ਬਸਤਰ ਲਾਹ ਦੇਵੇ ਅਤੇ ਦੂਜੇ ਬਸਤਰ ਪਾ ਕੇ ਉਸ ਸੁਆਹ ਨੂੰ ਡੇਰਿਆਂ ਤੋਂ ਬਾਹਰ ਸਾਫ਼ ਸਥਾਨ ਵਿੱਚ ਲੈ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","ਜਗਵੇਦੀ ਦੇ ਉੱਤੇ ਅੱਗ ਸਦਾ ਬਲਦੀ ਰਹੇ, ਉਹ ਕਦੇ ਨਾ ਬੁਝਾਈ ਜਾਵੇ ਅਤੇ ਜਾਜਕ ਹਰ ਰੋਜ਼ ਸਵੇਰ ਦੇ ਵੇਲੇ ਉਸ ਦੇ ਉੱਤੇ ਲੱਕੜਾਂ ਬਾਲਣ ਅਤੇ ਹੋਮ ਦੀ ਭੇਟ ਸੁਧਾਰ ਕੇ ਰੱਖਣ ਅਤੇ ਉਸ ਦੇ ਉੱਤੇ ਸੁੱਖ-ਸਾਂਦ ਦੀਆਂ ਭੇਟਾਂ ਦੀ ਚਰਬੀ ਸਾੜਨ। ");
INSERT INTO pan_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","ਜਗਵੇਦੀ ਦੇ ਉੱਤੇ ਅੱਗ ਸਦਾ ਬਲਦੀ ਰਹੇ, ਉਹ ਕਦੇ ਵੀ ਨਾ ਬੁਝੇ। ");
INSERT INTO pan_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","ਮੈਦੇ ਦੀ ਭੇਟ ਦੀ ਬਿਵਸਥਾ ਇਹ ਹੈ: ਹਾਰੂਨ ਦੇ ਪੁੱਤਰ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਜਗਵੇਦੀ ਦੇ ਸਾਹਮਣੇ ਉਸ ਨੂੰ ਚੜ੍ਹਾਉਣ। ");
INSERT INTO pan_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","ਅਤੇ ਉਹ ਮੈਦੇ ਦੀ ਭੇਟ ਵਿੱਚੋਂ ਤੇਲ ਰਲੇ ਹੋਏ ਮੈਦੇ ਦੀ ਇੱਕ ਮੁੱਠ ਭਰੇ ਅਤੇ ਉਸ ਦਾ ਸਾਰਾ ਲੁਬਾਨ ਚੁੱਕ ਕੇ, ਮੈਦੇ ਦੀ ਭੇਟ ਵਿੱਚੋਂ ਯਾਦਗੀਰੀ ਲਈ ਯਹੋਵਾਹ ਦੇ ਲਈ ਸੁਗੰਧਤਾ ਕਰਕੇ ਜਗਵੇਦੀ ਦੇ ਉੱਤੇ ਸਾੜੇ। ");
INSERT INTO pan_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","ਅਤੇ ਜੋ ਕੁਝ ਬਚ ਜਾਵੇ ਉਸ ਨੂੰ ਹਾਰੂਨ ਅਤੇ ਉਸ ਦੇ ਪੁੱਤਰ ਖਾਣ, ਉਹ ਪਤੀਰੀ ਰੋਟੀ ਨਾਲ ਪਵਿੱਤਰ ਸਥਾਨ ਵਿੱਚ ਖਾਧੀ ਜਾਵੇ ਅਤੇ ਉਹ ਮੰਡਲੀ ਦੇ ਡੇਰੇ ਦੇ ਵਿਹੜੇ ਵਿੱਚ ਉਸ ਨੂੰ ਖਾਣ। ");
INSERT INTO pan_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","ਉਹ ਖ਼ਮੀਰ ਨਾਲ ਪਕਾਇਆ ਨਾ ਜਾਵੇ, ਕਿਉਂ ਜੋ ਮੈਂ ਉਸ ਨੂੰ ਆਪਣੀਆਂ ਅੱਗ ਦੀਆਂ ਭੇਟਾਂ ਵਿੱਚੋਂ, ਉਨ੍ਹਾਂ ਦਾ ਨਿੱਜ-ਭਾਗ ਠਹਿਰਾ ਕੇ ਦਿੱਤਾ ਹੈ, ਇਸ ਲਈ ਜਿਸ ਤਰ੍ਹਾਂ ਪਾਪ ਬਲੀ ਦੀ ਭੇਟ ਅਤੇ ਦੋਸ਼ ਬਲੀ ਦੀ ਭੇਟ ਅੱਤ ਪਵਿੱਤਰ ਹੈ, ਉਸੇ ਤਰ੍ਹਾਂ ਇਹ ਵੀ ਪਵਿੱਤਰ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","ਹਾਰੂਨ ਦੀ ਸੰਤਾਨ ਵਿੱਚੋਂ ਸਾਰੇ ਪੁਰਖ ਉਸ ਵਿੱਚੋਂ ਖਾ ਸਕਦੇ ਹਨ, ਇਹ ਯਹੋਵਾਹ ਦੀਆਂ ਅੱਗ ਦੀਆਂ ਭੇਟਾਂ ਵਿੱਚੋਂ ਤੁਹਾਡੀਆਂ ਪੀੜ੍ਹੀਆਂ ਲਈ ਇੱਕ ਸਦਾ ਦੀ ਬਿਧੀ ਹੈ। ਜਿਹੜਾ ਉਨ੍ਹਾਂ ਨੂੰ ਛੂਹੇ ਉਹ ਪਵਿੱਤਰ ਠਹਿਰੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਆਖਿਆ, ");
INSERT INTO pan_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","ਜਿਸ ਦਿਨ ਹਾਰੂਨ ਨੂੰ ਮਸਹ ਕੀਤਾ ਜਾਵੇ, ਉਸ ਦਿਨ ਉਹ ਆਪਣੇ ਪੁੱਤਰਾਂ ਦੇ ਨਾਲ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਭੇਟ ਚੜ੍ਹਾਵੇ ਅਰਥਾਤ ਏਫਾਹ ਦਾ ਦਸਵਾਂ ਹਿੱਸਾ, ਇੱਕ ਸਦਾ ਦੀ ਮੈਦੇ ਦੀ ਭੇਟ ਦੇ ਲਈ ਅੱਧਾ ਸਵੇਰ ਨੂੰ ਅਤੇ ਅੱਧਾ ਰਾਤ ਨੂੰ ਚੜ੍ਹਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","ਉਹ ਤਵੇ ਉੱਤੇ ਤੇਲ ਦੇ ਨਾਲ ਬਣਾਈ ਜਾਵੇ ਅਤੇ ਜਦੋਂ ਪੱਕ ਜਾਵੇ ਤਾਂ ਤੂੰ ਉਸ ਨੂੰ ਅੰਦਰ ਲੈ ਆਵੀਂ ਅਤੇ ਮੈਦੇ ਦੀ ਭੇਟ ਦੇ ਇਸ ਪਕਾਏ ਹੋਏ ਟੁੱਕੜੇ ਨੂੰ ਤੂੰ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਸੁਗੰਧਤਾ ਲਈ ਚੜ੍ਹਾਵੀਂ। ");
INSERT INTO pan_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","ਹਾਰੂਨ ਦੇ ਪੁੱਤਰਾਂ ਵਿੱਚੋਂ ਜਿਸ ਨੂੰ ਵੀ ਜਾਜਕ ਹੋਣ ਲਈ ਮਸਹ ਕੀਤਾ ਜਾਵੇ ਉਹ ਉਸ ਭੇਟ ਨੂੰ ਚੜ੍ਹਾਵੇ, ਇਹ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਇੱਕ ਸਦਾ ਦੀ ਬਿਧੀ ਹੈ। ਇਹ ਸਾਰੀ ਭੇਟ ਸਾੜੀ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","ਕਿਉਂ ਜੋ ਜਾਜਕ ਦੀਆਂ ਸਾਰੀਆਂ ਮੈਦੇ ਦੀਆਂ ਭੇਟਾਂ ਪੂਰੀਆਂ ਸਾੜੀਆਂ ਜਾਣ, ਉਹ ਖਾਧੀਆਂ ਨਾ ਜਾਣ। ");
INSERT INTO pan_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਆਖਿਆ, ");
INSERT INTO pan_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","ਹਾਰੂਨ ਅਤੇ ਉਸ ਦੇ ਪੁੱਤਰਾਂ ਨੂੰ ਆਖ ਕਿ ਪਾਪ ਦੀ ਭੇਟ ਦੀ ਬਿਧੀ ਇਹ ਹੈ: ਜਿੱਥੇ ਹੋਮ ਬਲੀ ਦੀ ਭੇਟ ਵੱਢੀ ਜਾਂਦੀ ਹੈ, ਉੱਥੇ ਹੀ ਪਾਪ ਬਲੀ ਦੀ ਭੇਟ ਵੀ ਯਹੋਵਾਹ ਦੇ ਲਈ ਵੱਢੀ ਜਾਵੇ, ਇਹ ਅੱਤ ਪਵਿੱਤਰ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","ਜਿਹੜਾ ਜਾਜਕ ਪਾਪ ਬਲੀ ਚੜ੍ਹਾਵੇ ਉਹ ਹੀ ਉਸ ਨੂੰ ਖਾਵੇ, ਉਹ ਮੰਡਲੀ ਦੇ ਡੇਰੇ ਦੇ ਵਿਹੜੇ ਵਿੱਚ ਪਵਿੱਤਰ ਸਥਾਨ ਵਿੱਚ ਖਾਧੀ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","ਜੋ ਕੁਝ ਉਸ ਦੇ ਮਾਸ ਨੂੰ ਛੂਹੇ ਉਹ ਪਵਿੱਤਰ ਠਹਿਰੇਗਾ ਅਤੇ ਜੇਕਰ ਉਸ ਦੇ ਲਹੂ ਦੀ ਛਿੱਟੇ ਕਿਸੇ ਬਸਤਰ ਉੱਤੇ ਪੈ ਜਾਣ ਤਾਂ ਤੂੰ ਉਸ ਬਸਤਰ ਨੂੰ ਕਿਸੇ ਪਵਿੱਤਰ ਸਥਾਨ ਵਿੱਚ ਧੋ ਦੇਵੀਂ। ");
INSERT INTO pan_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","ਅਤੇ ਉਹ ਮਿੱਟੀ ਦੀ ਹਾਂਡੀ ਜਿਸ ਦੇ ਵਿੱਚ ਉਹ ਪਕਾਇਆ ਜਾਵੇ, ਉਸ ਨੂੰ ਤੋੜ ਦਿੱਤਾ ਜਾਵੇ ਪਰ ਜੇਕਰ ਉਹ ਕਿਸੇ ਪਿੱਤਲ ਦੀ ਹਾਂਡੀ ਵਿੱਚ ਪਕਾਇਆ ਗਿਆ ਹੋਵੇ, ਤਾਂ ਉਸ ਨੂੰ ਮਾਂਜ ਕੇ ਪਾਣੀ ਨਾਲ ਧੋਇਆ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","ਜਾਜਕਾਂ ਵਿੱਚੋਂ ਸਾਰੇ ਪੁਰਖ ਉਸ ਨੂੰ ਖਾ ਸਕਦੇ ਹਨ, ਇਹ ਅੱਤ ਪਵਿੱਤਰ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","ਪਰ ਜਿਸ ਪਾਪ ਬਲੀ ਦੀ ਭੇਟ ਦੇ ਲਹੂ ਵਿੱਚੋਂ ਕੁਝ ਵੀ ਲਹੂ ਮੰਡਲੀ ਦੇ ਡੇਰੇ ਵਿੱਚ ਪਵਿੱਤਰ ਸਥਾਨ ਵਿੱਚ ਪ੍ਰਾਸਚਿਤ ਕਰਨ ਲਈ ਲਿਆਇਆ ਜਾਵੇ, ਉਸ ਦਾ ਮਾਸ ਕਦੀ ਵੀ ਨਾ ਖਾਧਾ ਜਾਵੇ, ਨਾ ਹੀ ਉਹ ਅੱਗ ਵਿੱਚ ਸਾੜਿਆ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","ਦੋਸ਼ ਬਲੀ ਦੀ ਭੇਟ ਦੀ ਬਿਧੀ ਇਹ ਹੈ: ਉਹ ਅੱਤ ਪਵਿੱਤਰ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","ਜਿੱਥੇ ਉਹ ਹੋਮ ਬਲੀ ਦੀ ਭੇਟ ਨੂੰ ਵੱਢਦੇ ਹਨ, ਉੱਥੇ ਹੀ ਉਹ ਦੋਸ਼ ਬਲੀ ਦੀ ਭੇਟ ਨੂੰ ਵੱਢਣ ਅਤੇ ਉਸ ਦੇ ਲਹੂ ਤੋਂ ਜਾਜਕ ਜਗਵੇਦੀ ਦੇ ਚੁਫ਼ੇਰੇ ਛਿੜਕਣ। ");
INSERT INTO pan_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","ਅਤੇ ਉਹ ਉਸ ਦੀ ਸਾਰੀ ਚਰਬੀ ਨੂੰ ਚੜ੍ਹਾਉਣ ਅਰਥਾਤ ਮੋਟੀ ਪੂਛ ਅਤੇ ਉਹ ਚਰਬੀ ਜਿਹੜੀ ਆਂਦਰਾਂ ਨੂੰ ਢੱਕਦੀ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","ਦੋਵੇਂ ਗੁਰਦੇ ਅਤੇ ਲੱਕ ਦੇ ਉੱਤੇ ਜਿਹੜੀ ਚਰਬੀ ਹੈ ਅਤੇ ਉਹ ਝਿੱਲੀ ਜੋ ਕਲੇਜੇ ਉੱਤੇ ਹੈ, ਉਸ ਨੂੰ ਗੁਰਦਿਆਂ ਸਮੇਤ ਵੱਖਰੀ ਕਰੇ। ");
INSERT INTO pan_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","ਅਤੇ ਜਾਜਕ ਅੱਗ ਦੀ ਭੇਟ ਕਰਕੇ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਜਗਵੇਦੀ ਦੇ ਉੱਤੇ ਉਨ੍ਹਾਂ ਨੂੰ ਸਾੜੇ। ਇਹ ਦੋਸ਼ ਦੀ ਭੇਟ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","ਜਾਜਕਾਂ ਵਿੱਚੋਂ ਸਾਰੇ ਪੁਰਖ ਉਸ ਵਿੱਚੋਂ ਖਾ ਸਕਦੇ ਹਨ, ਉਹ ਪਵਿੱਤਰ ਸਥਾਨ ਵਿੱਚ ਖਾਧੀ ਜਾਵੇ, ਉਹ ਅੱਤ ਪਵਿੱਤਰ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","ਜਿਵੇਂ ਪਾਪ ਬਲੀ ਦੀ ਭੇਟ ਹੈ, ਉਸੇ ਤਰ੍ਹਾਂ ਹੀ ਦੋਸ਼ ਬਲੀ ਦੀ ਭੇਟ ਹੈ, ਉਨ੍ਹਾਂ ਦੋਹਾਂ ਦੀ ਇੱਕੋ ਹੀ ਬਿਧੀ ਹੈ। ਜਿਹੜਾ ਜਾਜਕ ਉਨ੍ਹਾਂ ਭੇਟਾਂ ਨੂੰ ਚੜ੍ਹਾ ਕੇ ਉਸ ਦਾ ਪ੍ਰਾਸਚਿਤ ਕਰੇ, ਉਹ ਹੀ ਉਸ ਨੂੰ ਰੱਖੇ। ");
INSERT INTO pan_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","ਅਤੇ ਜਿਹੜਾ ਜਾਜਕ ਕਿਸੇ ਮਨੁੱਖ ਦੀ ਹੋਮ ਦੀ ਭੇਟ ਚੜ੍ਹਾਵੇ, ਉਸ ਹੋਮ ਬਲੀ ਭੇਟ ਦੀ ਖੱਲ ਨੂੰ ਉਹ ਜਾਜਕ ਹੀ ਲੈ ਲਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","ਅਤੇ ਸਾਰੀ ਮੈਦੇ ਦੀ ਭੇਟ ਜੋ ਤੰਦੂਰ ਵਿੱਚ, ਜਾਂ ਕੜਾਹੀ ਵਿੱਚ ਜਾਂ ਤਵੇ ਉੱਤੇ ਪਕਾਈ ਜਾਵੇ ਉਹ ਉਸੇ ਜਾਜਕ ਦੀ ਹੋਵੇਗੀ, ਜਿਹੜਾ ਉਸ ਨੂੰ ਚੜ੍ਹਾਵੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","ਅਤੇ ਸਾਰੀਆਂ ਮੈਦੇ ਦੀਆਂ ਭੇਟਾਂ, ਭਾਵੇਂ ਤੇਲ ਨਾਲ ਰਲੀਆਂ ਹੋਈਆਂ ਹੋਣ ਭਾਵੇਂ ਰੁੱਖੀਆਂ, ਉਹ ਹਾਰੂਨ ਦੇ ਸਾਰੇ ਪੁੱਤਰਾਂ ਨੂੰ ਇੱਕੋ ਬਰਾਬਰ ਵੰਡੀਆਂ ਜਾਣ। ");
INSERT INTO pan_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","ਜਿਹੜੀਆਂ ਸੁੱਖ-ਸਾਂਦ ਦੀਆਂ ਭੇਟਾਂ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਚੜ੍ਹਾਉਣੀਆਂ ਹਨ, ਉਨ੍ਹਾਂ ਦੀ ਬਿਵਸਥਾ ਇਹ ਹੈ: ");
INSERT INTO pan_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","ਜੇ ਉਹ ਉਸ ਨੂੰ ਧੰਨਵਾਦ ਦੇ ਲਈ ਚੜ੍ਹਾਵੇ ਤਾਂ ਉਹ ਆਪਣੀ ਧੰਨਵਾਦ ਦੀ ਭੇਟ ਵਿੱਚ, ਤੇਲ ਨਾਲ ਗੁੰਨ੍ਹੇ ਹੋਏ ਪਤੀਰੇ ਫੁਲਕੇ, ਤੇਲ ਨਾਲ ਚੋਪੜੀ ਹੋਈ ਪਤੀਰੀ ਮੱਠੀ ਅਤੇ ਮੈਦੇ ਦੀਆਂ ਤੇਲ ਨਾਲ ਤਲੀਆਂ ਹੋਈਆਂ ਪੂੜੀਆਂ ਚੜ੍ਹਾਵੇ, ");
INSERT INTO pan_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","ਅਤੇ ਉਹ ਆਪਣੀਆਂ ਸੁੱਖ-ਸਾਂਦ ਦੀਆਂ ਭੇਟਾਂ ਵਿੱਚ ਧੰਨਵਾਦ ਦੀ ਬਲੀ ਨਾਲ ਖ਼ਮੀਰੀ ਰੋਟੀ ਵੀ ਚੜ੍ਹਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","ਅਤੇ ਅਜਿਹੀ ਹਰੇਕ ਭੇਟ ਵਿੱਚੋਂ ਉਹ ਇੱਕ-ਇੱਕ ਰੋਟੀ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਚੁੱਕਣ ਦੀ ਭੇਟ ਕਰਕੇ ਚੜ੍ਹਾਵੇ ਅਤੇ ਉਹ ਉਸੇ ਜਾਜਕ ਦੀ ਹੋਵੇਗੀ, ਜਿਹੜਾ ਸੁੱਖ-ਸਾਂਦ ਦੀਆਂ ਭੇਟਾਂ ਦੇ ਲਹੂ ਨੂੰ ਛਿੜਕੇ। ");
INSERT INTO pan_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","ਅਤੇ ਉਸ ਧੰਨਵਾਦ ਵਾਲੀ ਸੁੱਖ-ਸਾਂਦ ਦੀਆਂ ਭੇਟਾਂ ਦੀ ਬਲੀ ਦਾ ਮਾਸ, ਉਸੇ ਦਿਨ ਹੀ ਖਾਧਾ ਜਾਵੇ, ਜਿਸ ਦਿਨ ਉਹ ਚੜ੍ਹਾਇਆ ਜਾਂਦਾ ਹੈ, ਉਸ ਵਿੱਚੋਂ ਸਵੇਰ ਤੱਕ ਕੁਝ ਵੀ ਬਾਕੀ ਨਾ ਰਹੇ। ");
INSERT INTO pan_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","ਪਰ ਜੇਕਰ ਉਸ ਦੀ ਬਲੀ ਵਿੱਚੋਂ ਕੁਝ ਚੜ੍ਹਾਵਾ ਭਾਵੇਂ ਉਹ ਸੁੱਖਣਾ ਦਾ, ਜਾਂ ਖੁਸ਼ੀ ਦੀ ਭੇਟ ਦਾ ਹੋਵੇ, ਤਾਂ ਉਹ ਉਸੇ ਦਿਨ ਖਾਧਾ ਜਾਵੇ, ਜਿਸ ਦਿਨ ਉਹ ਆਪਣੀ ਬਲੀ ਚੜ੍ਹਾਉਂਦਾ ਹੈ, ਅਤੇ ਜੋ ਬਾਕੀ ਬਚ ਜਾਵੇ ਉਹ ਦੂਜੇ ਦਿਨ ਵੀ ਖਾਧਾ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","ਪਰ ਉਸ ਬਲੀ ਦੇ ਮਾਸ ਵਿੱਚੋਂ ਜੋ ਕੁਝ ਤੀਜੇ ਦਿਨ ਤੱਕ ਬਚਿਆ ਰਹੇ, ਉਹ ਅੱਗ ਵਿੱਚ ਸਾੜਿਆ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","ਅਤੇ ਜੇਕਰ ਉਸ ਦੀਆਂ ਸੁੱਖ-ਸਾਂਦ ਦੀਆਂ ਭੇਟਾਂ ਦੀ ਬਲੀ ਦੇ ਮਾਸ ਵਿੱਚੋਂ ਤੀਜੇ ਦਿਨ ਤੱਕ ਕੁਝ ਖਾਧਾ ਜਾਵੇ ਤਾਂ ਉਹ ਸਵੀਕਾਰ ਨਾ ਕੀਤਾ ਜਾਵੇਗਾ ਅਤੇ ਨਾ ਚੜ੍ਹਾਉਣ ਵਾਲੇ ਦੇ ਲੇਖੇ ਵਿੱਚ ਗਿਣਿਆ ਜਾਵੇਗਾ। ਉਹ ਘਿਣਾਉਣਾ ਮੰਨਿਆ ਜਾਵੇਗਾ ਅਤੇ ਜਿਹੜਾ ਮਨੁੱਖ ਉਸ ਨੂੰ ਖਾਵੇਗਾ, ਉਹ ਆਪਣਾ ਦੋਸ਼ ਆਪ ਚੁੱਕੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","ਪਰ ਜਿਹੜਾ ਮਾਸ ਕਿਸੇ ਅਸ਼ੁੱਧ ਵਸਤੂ ਨਾਲ ਛੂਹੇ, ਉਹ ਖਾਧਾ ਨਾ ਜਾਵੇ, ਉਹ ਅੱਗ ਨਾਲ ਸਾੜਿਆ ਜਾਵੇ। ਸੁੱਖ-ਸਾਂਦ ਦੀਆਂ ਬਲੀਆਂ ਦੇ ਮਾਸ ਨੂੰ ਉਹ ਸਾਰੇ ਲੋਕ ਖਾਣ ਜੋ ਸ਼ੁੱਧ ਹੋਣ। ");
INSERT INTO pan_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","ਪਰ ਜੋ ਕੋਈ ਮਨੁੱਖ ਅਸ਼ੁੱਧ ਹੋਵੇ ਅਤੇ ਯਹੋਵਾਹ ਦੀਆਂ ਸੁੱਖ-ਸਾਂਦ ਦੀਆਂ ਭੇਟਾਂ ਦੇ ਮਾਸ ਵਿੱਚੋਂ ਕੁਝ ਖਾਵੇ ਤਾਂ ਉਹ ਮਨੁੱਖ ਆਪਣੇ ਲੋਕਾਂ ਵਿੱਚੋਂ ਛੇਕਿਆ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","ਅਤੇ ਜੇਕਰ ਕੋਈ ਕਿਸੇ ਅਪਵਿੱਤਰ ਵਸਤੂ ਨੂੰ ਛੂਹੇ ਅਤੇ ਯਹੋਵਾਹ ਦੀਆਂ ਸੁੱਖ-ਸਾਂਦ ਦੀਆਂ ਭੇਟਾਂ ਦੇ ਮਾਸ ਵਿੱਚੋਂ ਕੁਝ ਖਾਵੇ ਤਾਂ ਉਹ ਵੀ ਆਪਣੇ ਲੋਕਾਂ ਵਿੱਚੋਂ ਛੇਕਿਆ ਜਾਵੇ। ਭਾਵੇਂ ਉਹ ਮਨੁੱਖ ਦੀ ਕੋਈ ਅਸ਼ੁੱਧ ਵਸਤੂ, ਜਾਂ ਅਸ਼ੁੱਧ ਪਸ਼ੂ, ਜਾਂ ਕੋਈ ਵੀ ਅਸ਼ੁੱਧ ਜਾਂ ਘਿਣਾਉਣੀ ਵਸਤੂ ਹੋਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","ਫੇਰ ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਆਖਿਆ, ");
INSERT INTO pan_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","ਇਸਰਾਏਲੀਆਂ ਨੂੰ ਆਖ ਕਿ ਤੁਸੀਂ ਕਿਸੇ ਪ੍ਰਕਾਰ ਦੀ ਚਰਬੀ ਨਾ ਖਾਣਾ, ਭਾਵੇਂ ਬਲ਼ਦ ਦੀ, ਭਾਵੇਂ ਭੇਡ ਦੀ, ਭਾਵੇਂ ਬੱਕਰੇ ਦੀ ਹੋਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","ਅਤੇ ਜਿਹੜਾ ਪਸ਼ੂ ਆਪ ਮਰ ਜਾਵੇ ਜਾਂ ਕਿਸੇ ਦੂਜੇ ਪਸ਼ੂ ਦੁਆਰਾ ਪਾੜਿਆ ਜਾਵੇ, ਉਸ ਦੀ ਚਰਬੀ ਹੋਰ ਕਿਸੇ ਕੰਮ ਵਿੱਚ ਵਰਤੀ ਜਾਵੇ ਪਰ ਤੁਸੀਂ ਕਿਸੇ ਵੀ ਤਰ੍ਹਾਂ ਉਸ ਨੂੰ ਨਾ ਖਾਇਓ। ");
INSERT INTO pan_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","ਕੋਈ ਵੀ ਜਿਹੜਾ ਅਜਿਹੇ ਪਸ਼ੂ ਦੀ ਚਰਬੀ ਨੂੰ ਖਾਵੇ, ਜਿਸ ਨੂੰ ਮਨੁੱਖ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਅੱਗ ਦੀ ਭੇਟ ਕਰਕੇ ਚੜ੍ਹਾਉਂਦੇ ਹਨ ਤਾਂ ਉਸ ਨੂੰ ਖਾਣ ਵਾਲਾ ਮਨੁੱਖ ਆਪਣੇ ਲੋਕਾਂ ਵਿੱਚੋਂ ਛੇਕਿਆ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","ਅਤੇ ਤੁਸੀਂ ਆਪਣੇ ਸਾਰੇ ਨਿਵਾਸ ਸਥਾਨਾਂ ਵਿੱਚ ਕਿਸੇ ਪ੍ਰਕਾਰ ਦਾ ਲਹੂ ਭਾਵੇਂ ਪੰਛੀ ਦਾ, ਭਾਵੇਂ ਪਸ਼ੂ ਦਾ ਹੋਵੇ, ਨਾ ਖਾਣਾ। ");
INSERT INTO pan_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","ਜਿਹੜਾ ਮਨੁੱਖ ਕਿਸੇ ਪ੍ਰਕਾਰ ਦਾ ਮਾਸ ਲਹੂ ਸਮੇਤ ਖਾਵੇ, ਉਹ ਆਪਣੇ ਲੋਕਾਂ ਵਿੱਚੋਂ ਛੇਕਿਆ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","ਫੇਰ ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਆਖਿਆ, ");
INSERT INTO pan_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","ਇਸਰਾਏਲੀਆਂ ਨੂੰ ਇਹ ਆਖ ਕਿ ਜੋ ਕੋਈ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਆਪਣੀਆਂ ਸੁੱਖ-ਸਾਂਦ ਦੀਆਂ ਭੇਟਾਂ ਚੜ੍ਹਾਵੇ, ਉਹ ਆਪਣੀਆਂ ਉਸੇ ਸੁੱਖ-ਸਾਂਦ ਦੀਆਂ ਭੇਟਾਂ ਵਿੱਚੋਂ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਲਿਆਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","ਉਹ ਆਪਣੇ ਹੱਥ ਨਾਲ ਯਹੋਵਾਹ ਦੀਆਂ ਅੱਗ ਦੀਆਂ ਭੇਟਾਂ ਲਿਆਵੇ ਅਰਥਾਤ ਛਾਤੀ ਦੇ ਸਮੇਤ ਚਰਬੀ ਲਿਆਵੇ, ਤਾਂ ਜੋ ਛਾਤੀ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਹਿਲਾਉਣ ਦੀ ਭੇਟ ਕਰਕੇ ਹਿਲਾਈ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","ਅਤੇ ਜਾਜਕ ਚਰਬੀ ਨੂੰ ਜਗਵੇਦੀ ਉੱਤੇ ਸਾੜੇ ਪਰ ਛਾਤੀ ਹਾਰੂਨ ਅਤੇ ਉਸ ਦੇ ਪੁੱਤਰਾਂ ਨੂੰ ਮਿਲ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","ਅਤੇ ਤੁਸੀਂ ਆਪਣੀਆਂ ਸੁੱਖ-ਸਾਂਦ ਦੀਆਂ ਭੇਟਾਂ ਵਿੱਚੋਂ ਸੱਜੇ ਪੱਟ ਨੂੰ ਚੁੱਕਣ ਦੀ ਭੇਟ ਕਰਕੇ ਜਾਜਕ ਨੂੰ ਦੇਣਾ। ");
INSERT INTO pan_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","ਹਾਰੂਨ ਦੇ ਪੁੱਤਰਾਂ ਵਿੱਚੋਂ ਜਿਹੜਾ ਸੁੱਖ-ਸਾਂਦ ਦੀਆਂ ਭੇਟਾਂ ਦਾ ਲਹੂ ਅਤੇ ਚਰਬੀ ਚੜ੍ਹਾਵੇ, ਸੱਜਾ ਪੱਟ ਉਸੇ ਦਾ ਹਿੱਸਾ ਹੋਵੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","ਕਿਉਂ ਜੋ ਇਸਰਾਏਲੀਆਂ ਦੀਆਂ ਸੁੱਖ-ਸਾਂਦ ਦੀਆਂ ਬਲੀਆਂ ਦੀਆਂ ਭੇਟਾਂ ਵਿੱਚੋਂ ਹਿਲਾਉਣ ਦੀ ਭੇਟ ਦੀ ਛਾਤੀ ਅਤੇ ਚੁੱਕਣ ਦੀ ਭੇਟ ਵਿੱਚੋਂ ਪੱਟ ਨੂੰ ਲੈ ਕੇ ਮੈਂ ਹਾਰੂਨ ਜਾਜਕ ਅਤੇ ਉਸ ਦੇ ਪੁੱਤਰਾਂ ਨੂੰ ਦਿੱਤਾ ਹੈ ਤਾਂ ਜੋ ਇਹ ਇਸਰਾਏਲੀਆਂ ਵੱਲੋਂ ਉਨ੍ਹਾਂ ਦਾ ਸਦਾ ਲਈ ਹੱਕ ਬਣਿਆ ਰਹੇ। ");
INSERT INTO pan_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","ਜਿਸ ਦਿਨ ਹਾਰੂਨ ਅਤੇ ਉਸ ਦੇ ਪੁੱਤਰ ਯਹੋਵਾਹ ਦੇ ਸਨਮੁਖ ਜਾਜਕਾਈ ਲਈ ਨਿਯੁਕਤ ਕੀਤੇ ਗਏ, ਉਸੇ ਦਿਨ ਯਹੋਵਾਹ ਦੀਆਂ ਅੱਗ ਦੀਆਂ ਭੇਟਾਂ ਵਿੱਚੋਂ ਉਨ੍ਹਾਂ ਦਾ ਇਹੋ ਮਸਹ ਕਰਨ ਦਾ ਹੱਕ ਠਹਿਰਾਇਆ ਗਿਆ। ");
INSERT INTO pan_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","ਜਿਸ ਦਿਨ ਯਹੋਵਾਹ ਨੇ ਉਨ੍ਹਾਂ ਨੂੰ ਮਸਹ ਕੀਤਾ, ਉਸੇ ਦਿਨ ਉਸ ਨੇ ਹੁਕਮ ਦਿੱਤਾ ਕਿ ਉਨ੍ਹਾਂ ਨੂੰ ਇਸਰਾਏਲੀਆਂ ਵੱਲੋਂ ਇਹ ਹਿੱਸਾ ਰੋਜ਼ ਮਿਲਿਆ ਕਰੇ, ਪੀੜ੍ਹੀਓਂ ਪੀੜ੍ਹੀ ਉਨ੍ਹਾਂ ਦਾ ਇਹੋ ਹੱਕ ਠਹਿਰਾਇਆ ਗਿਆ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","ਹੋਮ ਬਲੀ ਦੀ ਭੇਟ, ਮੈਦੇ ਦੀ ਭੇਟ, ਪਾਪ ਬਲੀ, ਦੋਸ਼ ਬਲੀ ਦੀ ਭੇਟ, ਜਾਜਕਾਂ ਨੂੰ ਪਵਿੱਤਰ ਠਹਿਰਾਉਣ ਦੀ ਬਲੀ ਅਤੇ ਸੁੱਖ-ਸਾਂਦ ਦੀਆਂ ਭੇਟਾਂ ਦੀ ਇਹੋ ਬਿਵਸਥਾ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","ਜਦ ਯਹੋਵਾਹ ਨੇ ਸੀਨਈ ਪਰਬਤ ਦੇ ਉਜਾੜ ਵਿੱਚ ਮੂਸਾ ਨੂੰ ਹੁਕਮ ਦਿੱਤਾ ਕਿ ਇਸਰਾਏਲੀ ਯਹੋਵਾਹ ਲਈ ਕਿਹੜੀਆਂ-ਕਿਹੜੀਆਂ ਭੇਟਾਂ ਚੜ੍ਹਾਉਣ, ਤਦ ਉਸ ਨੇ ਉਨ੍ਹਾਂ ਨੂੰ ਇਹੋ ਬਿਵਸਥਾ ਦਿੱਤੀ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਇਹ ਆਖਿਆ, ");
INSERT INTO pan_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","ਤੂੰ ਹਾਰੂਨ ਅਤੇ ਉਸ ਦੇ ਪੁੱਤਰਾਂ ਨੂੰ ਅਤੇ ਉਨ੍ਹਾਂ ਦੇ ਬਸਤਰਾਂ, ਮਸਹ ਕਰਨ ਦੇ ਤੇਲ, ਪਾਪ ਬਲੀ ਦੀ ਭੇਟ ਦੇ ਬਲ਼ਦ, ਦੋ ਭੇਡੂਆਂ ਅਤੇ ਪਤੀਰੀ ਰੋਟੀ ਦੇ ਟੋਕਰੇ ਨੂੰ ਲੈ ਕੇ, ");
INSERT INTO pan_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","ਸਾਰੀ ਮੰਡਲੀ ਨੂੰ ਮੰਡਲੀ ਦੇ ਡੇਰੇ ਦੇ ਦਰਵਾਜ਼ੇ ਦੇ ਕੋਲ ਇਕੱਠਿਆਂ ਕਰੀਂ। ");
INSERT INTO pan_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","ਤਦ ਜਿਵੇਂ ਯਹੋਵਾਹ ਨੇ ਆਗਿਆ ਦਿੱਤੀ ਸੀ, ਮੂਸਾ ਨੇ ਉਸੇ ਤਰ੍ਹਾਂ ਹੀ ਕੀਤਾ ਅਤੇ ਸਾਰੀ ਮੰਡਲੀ, ਮੰਡਲੀ ਡੇਰੇ ਦੇ ਦਰਵਾਜ਼ੇ ਦੇ ਕੋਲ ਇਕੱਠੀ ਹੋ ਗਈ। ");
INSERT INTO pan_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","ਤਦ ਮੂਸਾ ਨੇ ਮੰਡਲੀ ਨੂੰ ਆਖਿਆ, ਜਿਹੜਾ ਕੰਮ ਕਰਨ ਦਾ ਹੁਕਮ ਯਹੋਵਾਹ ਨੇ ਦਿੱਤਾ ਹੈ, ਉਹ ਇਹ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","ਅਤੇ ਮੂਸਾ ਨੇ ਹਾਰੂਨ ਅਤੇ ਉਸ ਦੇ ਪੁੱਤਰਾਂ ਨੂੰ ਲਿਆ ਕੇ ਪਾਣੀ ਨਾਲ ਨ੍ਹਵਾਇਆ, ");
INSERT INTO pan_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","ਅਤੇ ਉਸ ਨੇ ਉਹ ਨੂੰ ਕੁੜਤਾ ਪਹਿਨਾਇਆ ਅਤੇ ਪਟਕੇ ਨਾਲ ਉਸ ਦਾ ਲੱਕ ਬੰਨ੍ਹਿਆ ਅਤੇ ਚੋਗਾ ਪਹਿਨਾਇਆ ਅਤੇ ਉਸ ਦੇ ਉੱਤੇ ਏਫ਼ੋਦ ਪਹਿਨਾਇਆ ਅਤੇ ਸੋਹਣੀ ਕਢਾਈ ਕੀਤੇ ਹੋਏ ਏਫ਼ੋਦ ਦੇ ਪਟਕੇ ਨਾਲ ਉਸ ਦਾ ਲੱਕ ਕੱਸ ਦਿੱਤਾ। ");
INSERT INTO pan_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","ਤਦ ਉਸ ਨੇ ਉਹ ਨੂੰ ਸੀਨਾਬੰਦ ਪਹਿਨਾਇਆ ਅਤੇ ਉਸ ਸੀਨਾਬੰਦ ਵਿੱਚ ਊਰੀਮ ਅਤੇ ਤੁੰਮੀਮ ਨੂੰ ਰੱਖਿਆ। ");
INSERT INTO pan_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","ਤਦ ਉਸ ਨੇ ਉਹ ਦੇ ਸਿਰ ਉੱਤੇ ਪਗੜੀ ਬੰਨ੍ਹ ਕੇ ਪਗੜੀ ਦੇ ਸਾਹਮਣੇ ਸੋਨੇ ਦੀ ਪੱਤਰੀ ਅਰਥਾਤ ਪਵਿੱਤਰ ਮੁਕਟ ਨੂੰ ਲਗਾਇਆ ਜਿਸ ਤਰ੍ਹਾਂ ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਹੁਕਮ ਦਿੱਤਾ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","ਫੇਰ ਮੂਸਾ ਨੇ ਮਸਹ ਕਰਨ ਦਾ ਤੇਲ ਲਿਆ ਅਤੇ ਡੇਰੇ ਨੂੰ ਅਤੇ ਜੋ ਕੁਝ ਉਸ ਦੇ ਵਿੱਚ ਸੀ, ਤੇਲ ਪਾ ਕੇ ਪਵਿੱਤਰ ਕੀਤਾ। ");
INSERT INTO pan_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","ਅਤੇ ਉਸ ਤੇਲ ਵਿੱਚੋਂ ਕੁਝ ਲੈ ਕੇ ਜਗਵੇਦੀ ਉੱਤੇ ਸੱਤ ਵਾਰੀ ਛਿੜਕਿਆ ਅਤੇ ਜਗਵੇਦੀ ਅਤੇ ਉਸ ਦੇ ਸਾਰੇ ਸਮਾਨ ਨੂੰ ਅਤੇ ਚੁਬੱਚੇ ਅਤੇ ਉਸ ਦੀ ਚੌਂਕੀ ਨੂੰ ਤੇਲ ਨਾਲ ਪਵਿੱਤਰ ਕੀਤਾ। ");
INSERT INTO pan_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","ਫੇਰ ਉਸ ਨੇ ਮਸਹ ਕਰਨ ਦਾ ਤੇਲ ਹਾਰੂਨ ਦੇ ਸਿਰ ਉੱਤੇ ਚੁਆ ਕੇ ਉਸ ਨੂੰ ਪਵਿੱਤਰ ਕਰਨ ਲਈ ਮਸਹ ਕੀਤਾ। ");
INSERT INTO pan_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","ਤਦ ਮੂਸਾ ਨੇ ਹਾਰੂਨ ਦੇ ਪੁੱਤਰਾਂ ਨੂੰ ਲਿਆ ਕੇ ਉਨ੍ਹਾਂ ਨੂੰ ਕੁੜਤੇ ਪਹਿਨਾਏ, ਉਨ੍ਹਾਂ ਦੇ ਲੱਕ ਪੇਟੀਆਂ ਨਾਲ ਬੰਨੇ ਅਤੇ ਉਨ੍ਹਾਂ ਨੂੰ ਪੱਗੜੀਆਂ ਬੰਨ੍ਹਾਈਆਂ, ਜਿਵੇਂ ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਹੁਕਮ ਦਿੱਤਾ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","ਤਦ ਉਹ ਪਾਪ ਬਲੀ ਦੀ ਭੇਟ ਲਈ ਬਲ਼ਦ ਲਿਆਇਆ ਅਤੇ ਹਾਰੂਨ ਅਤੇ ਉਸ ਦੇ ਪੁੱਤਰਾਂ ਆਪਣੇ-ਆਪਣੇ ਹੱਥ ਪਾਪ ਬਲੀ ਦੀ ਭੇਟ ਦੇ ਬਲ਼ਦ ਦੇ ਸਿਰ ਉੱਤੇ ਰੱਖੇ। ");
INSERT INTO pan_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","ਤਦ ਮੂਸਾ ਨੇ ਉਸ ਨੂੰ ਵੱਢਿਆ ਅਤੇ ਉਸ ਦਾ ਲਹੂ ਲੈ ਕੇ ਜਗਵੇਦੀ ਦੇ ਸਿੰਗਾਂ ਉੱਤੇ ਆਪਣੀ ਉਂਗਲ ਨਾਲ ਚੁਫ਼ੇਰੇ ਲਾਇਆ ਅਤੇ ਜਗਵੇਦੀ ਨੂੰ ਸ਼ੁੱਧ ਕੀਤਾ ਅਤੇ ਜਗਵੇਦੀ ਦੇ ਹੇਠ ਲਹੂ ਨੂੰ ਡੋਲ੍ਹਕੇ ਉਸ ਦੇ ਲਈ ਪ੍ਰਾਸਚਿਤ ਕੀਤਾ ਅਤੇ ਉਸ ਨੂੰ ਪਵਿੱਤਰ ਕੀਤਾ। ");
INSERT INTO pan_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","ਅਤੇ ਮੂਸਾ ਨੇ ਆਂਦਰਾਂ ਦੇ ਉੱਤੇ ਸਾਰੀ ਚਰਬੀ, ਕਲੇਜੀ ਦੇ ਉੱਪਰਲੀ ਝਿੱਲੀ ਅਤੇ ਚਰਬੀ ਸਮੇਤ ਦੋਵੇਂ ਗੁਰਦਿਆਂ ਨੂੰ ਲੈ ਕੇ ਉਨ੍ਹਾਂ ਨੂੰ ਜਗਵੇਦੀ ਉੱਤੇ ਸਾੜਿਆ। ");
INSERT INTO pan_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","ਪਰ ਬਲ਼ਦ, ਉਸ ਦੀ ਖੱਲ, ਉਸ ਦਾ ਮਾਸ ਅਤੇ ਉਸ ਦਾ ਗੋਹਾ ਉਸ ਨੇ ਡੇਰੇ ਤੋਂ ਬਾਹਰ ਅੱਗ ਨਾਲ ਸਾੜਿਆ, ਜਿਵੇਂ ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਹੁਕਮ ਦਿੱਤਾ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","ਫੇਰ ਉਹ ਹੋਮ ਬਲੀ ਦੀ ਭੇਟ ਦੇ ਛੱਤਰੇ ਨੂੰ ਲਿਆਇਆ ਅਤੇ ਹਾਰੂਨ ਅਤੇ ਉਸ ਦੇ ਪੁੱਤਰਾਂ ਨੇ ਆਪਣੇ-ਆਪਣੇ ਹੱਥ ਭੇਡੂ ਦੇ ਸਿਰ ਉੱਤੇ ਰੱਖੇ। ");
INSERT INTO pan_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","ਤਦ ਮੂਸਾ ਨੇ ਉਸ ਨੂੰ ਵੱਢਿਆ ਅਤੇ ਉਸ ਦੇ ਲਹੂ ਨੂੰ ਜਗਵੇਦੀ ਦੇ ਚੁਫ਼ੇਰੇ ਛਿੜਕਿਆ। ");
INSERT INTO pan_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","ਤਦ ਉਸ ਨੇ ਛੱਤਰੇ ਨੂੰ ਟੁੱਕੜੇ-ਟੁੱਕੜੇ ਕੀਤਾ ਅਤੇ ਮੂਸਾ ਨੇ ਸਿਰ ਅਤੇ ਚਰਬੀ ਸਮੇਤ ਟੁੱਕੜਿਆਂ ਨੂੰ ਸਾੜਿਆ। ");
INSERT INTO pan_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","ਅਤੇ ਉਸ ਨੇ ਆਂਦਰਾਂ ਅਤੇ ਲੱਤਾਂ ਨੂੰ ਪਾਣੀ ਨਾਲ ਧੋਤਾ ਅਤੇ ਮੂਸਾ ਨੇ ਸਾਰੇ ਛੱਤਰੇ ਨੂੰ ਜਗਵੇਦੀ ਉੱਤੇ ਸਾੜਿਆ। ਇਹ ਯਹੋਵਾਹ ਦੇ ਲਈ ਅੱਗ ਦੀ ਭੇਟ ਦੀ ਸੁਗੰਧਤਾ ਅਰਥਾਤ ਹੋਮ ਬਲੀ ਸੀ, ਜਿਵੇਂ ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਹੁਕਮ ਦਿੱਤਾ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","ਫੇਰ ਉਹ ਦੂਜੇ ਛੱਤਰੇ ਨੂੰ ਅਰਥਾਤ ਥਾਪਣ ਦੇ ਛੱਤਰੇ ਨੂੰ ਲੈ ਆਇਆ ਅਤੇ ਹਾਰੂਨ ਅਤੇ ਉਸ ਦੇ ਪੁੱਤਰਾਂ ਨੇ ਆਪਣੇ-ਆਪਣੇ ਹੱਥ ਉਸ ਦੇ ਸਿਰ ਉੱਤੇ ਰੱਖੇ। ");
INSERT INTO pan_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","ਫੇਰ ਮੂਸਾ ਨੇ ਉਸ ਨੂੰ ਵੱਢਿਆ ਅਤੇ ਉਸ ਦੇ ਲਹੂ ਤੋਂ ਕੁਝ ਲੈ ਕੇ ਹਾਰੂਨ ਦੇ ਸੱਜੇ ਕੰਨ ਦੇ ਸਿਰੇ ਉੱਤੇ ਅਤੇ ਉਸ ਦੇ ਸੱਜੇ ਹੱਥ ਅਤੇ ਸੱਜੇ ਪੈਰ ਦੇ ਅੰਗੂਠਿਆਂ ਉੱਤੇ ਲਗਾਇਆ। ");
INSERT INTO pan_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","ਤਦ ਉਹ ਹਾਰੂਨ ਦੇ ਪੁੱਤਰਾਂ ਨੂੰ ਕੋਲ ਲਿਆਇਆ ਅਤੇ ਮੂਸਾ ਨੇ ਲਹੂ ਵਿੱਚੋਂ ਉਨ੍ਹਾਂ ਦੇ ਸੱਜੇ ਕੰਨਾਂ ਦੇ ਸਿਰੇ ਉੱਤੇ ਅਤੇ ਉਨ੍ਹਾਂ ਦੇ ਸੱਜੇ ਹੱਥਾਂ ਅਤੇ ਸੱਜੇ ਪੈਰਾਂ ਦੇ ਅੰਗੂਠਿਆਂ ਉੱਤੇ ਲਗਾਇਆ ਅਤੇ ਮੂਸਾ ਨੇ ਲਹੂ ਨੂੰ ਜਗਵੇਦੀ ਦੇ ਚੁਫ਼ੇਰੇ ਛਿੜਕਿਆ। ");
INSERT INTO pan_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","ਫੇਰ ਉਸ ਨੇ ਚਰਬੀ, ਮੋਟੀ ਪੂਛ, ਸਾਰੀ ਚਰਬੀ ਜੋ ਆਂਦਰਾਂ ਦੇ ਉੱਤੇ ਸੀ, ਕਲੇਜੀ ਦੀ ਉੱਪਰਲੀ ਝਿੱਲੀ ਸਮੇਤ ਦੋਵੇਂ ਗੁਰਦੇ ਅਤੇ ਉਨ੍ਹਾਂ ਦੀ ਚਰਬੀ ਅਤੇ ਸੱਜਾ ਪੱਟ ਲਿਆ ");
INSERT INTO pan_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","ਅਤੇ ਪਤੀਰੀ ਰੋਟੀ ਦੀ ਟੋਕਰੀ ਵਿੱਚੋਂ ਜਿਹੜੀ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਸੀ, ਉਸ ਨੇ ਇੱਕ ਰੋਟੀ, ਤੇਲ ਰਲੀ ਹੋਈ ਮੈਦੇ ਦੀ ਇੱਕ ਰੋਟੀ ਅਤੇ ਇੱਕ ਮੱਠੀ ਲੈ ਕੇ ਉਨ੍ਹਾਂ ਨੂੰ ਚਰਬੀ ਉੱਤੇ ਅਤੇ ਸੱਜੇ ਪੱਟ ਉੱਤੇ ਰੱਖਿਆ। ");
INSERT INTO pan_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","ਅਤੇ ਇਹ ਸਾਰੀਆਂ ਵਸਤੂਆਂ ਹਾਰੂਨ ਅਤੇ ਉਸ ਦੇ ਪੁੱਤਰਾਂ ਦੇ ਹੱਥਾਂ ਉੱਤੇ ਰੱਖੀਆਂ ਅਤੇ ਹਿਲਾਉਣ ਦੀ ਭੇਟ ਕਰਕੇ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਉਨ੍ਹਾਂ ਨੂੰ ਹਿਲਾਇਆ। ");
INSERT INTO pan_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","ਤਦ ਮੂਸਾ ਨੇ ਉਨ੍ਹਾਂ ਵਸਤੂਆਂ ਨੂੰ ਉਨ੍ਹਾਂ ਦੇ ਹੱਥਾਂ ਤੋਂ ਲੈ ਕੇ ਜਗਵੇਦੀ ਉੱਤੇ ਹੋਮ ਦੀ ਭੇਟ ਦੇ ਉੱਤੇ ਸਾੜਿਆ। ਇਹ ਸੁਗੰਧਤਾ ਲਈ ਥਾਪਣ ਦੀਆਂ ਭੇਟਾਂ ਅਤੇ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਇੱਕ ਅੱਗ ਦੀ ਭੇਟ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","ਤਦ ਮੂਸਾ ਨੇ ਛਾਤੀ ਨੂੰ ਲੈ ਕੇ ਉਸ ਨੂੰ ਹਿਲਾਉਣ ਦੀ ਭੇਟ ਕਰਕੇ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਹਿਲਾਇਆ ਕਿਉਂ ਜੋ ਥਾਪਣ ਦੇ ਛੱਤਰੇ ਵਿੱਚੋਂ ਇਹ ਮੂਸਾ ਦਾ ਹਿੱਸਾ ਸੀ, ਜਿਵੇਂ ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਹੁਕਮ ਦਿੱਤਾ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","ਫੇਰ ਮੂਸਾ ਨੇ ਮਸਹ ਕਰਨ ਦੇ ਤੇਲ ਤੋਂ ਅਤੇ ਉਸ ਲਹੂ ਤੋਂ ਜਿਹੜਾ ਜਗਵੇਦੀ ਉੱਤੇ ਸੀ, ਕੁਝ ਲੈ ਕੇ ਹਾਰੂਨ ਅਤੇ ਉਸ ਦੇ ਪੁੱਤਰਾਂ ਦੇ ਬਸਤਰਾਂ ਉੱਤੇ ਛਿੜਕਿਆ ਅਤੇ ਹਾਰੂਨ ਅਤੇ ਉਨ੍ਹਾਂ ਦੇ ਬਸਤਰਾਂ ਨੂੰ ਪਵਿੱਤਰ ਕੀਤਾ। ");
INSERT INTO pan_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","ਮੂਸਾ ਨੇ ਹਾਰੂਨ ਅਤੇ ਉਸ ਦੇ ਪੁੱਤਰਾਂ ਨੂੰ ਆਖਿਆ, “ਮੰਡਲੀ ਦੇ ਡੇਰੇ ਦੇ ਦਰਵਾਜ਼ੇ ਕੋਲ ਮਾਸ ਨੂੰ ਪਕਾਓ ਅਤੇ ਉਸ ਰੋਟੀ ਨੂੰ ਜੋ ਥਾਪਣ ਦੀਆਂ ਭੇਟਾਂ ਦੀ ਟੋਕਰੀ ਵਿੱਚ ਹੈ, ਉੱਥੇ ਹੀ ਖਾਓ, ਜਿਵੇਂ ਮੈਂ ਤੁਹਾਨੂੰ ਹੁਕਮ ਦਿੱਤਾ ਹੈ ਕਿ ਹਾਰੂਨ ਅਤੇ ਉਸ ਦੇ ਪੁੱਤਰ ਉਸ ਨੂੰ ਖਾਣ। ");
INSERT INTO pan_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","ਅਤੇ ਜੋ ਕੁਝ ਉਸ ਮਾਸ ਅਤੇ ਰੋਟੀ ਵਿੱਚੋਂ ਬਚ ਜਾਵੇ, ਉਸ ਨੂੰ ਤੁਸੀਂ ਅੱਗ ਨਾਲ ਸਾੜ ਦੇਣਾ। ");
INSERT INTO pan_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","ਜਦ ਤੱਕ ਤੁਹਾਡੇ ਥਾਪਣ ਦੇ ਦਿਨ ਪੂਰੇ ਨਾ ਹੋ ਜਾਣ ਤਦ ਤੱਕ ਅਰਥਾਤ ਸੱਤ ਦਿਨ ਤੱਕ ਤੁਸੀਂ ਮੰਡਲੀ ਦੇ ਡੇਰੇ ਦੇ ਦਰਵਾਜ਼ੇ ਤੋਂ ਬਾਹਰ ਨਾ ਨਿੱਕਲਣਾ, ਕਿਉਂ ਜੋ ਸੱਤ ਦਿਨਾਂ ਵਿੱਚ ਉਹ ਤੁਹਾਨੂੰ ਥਾਪੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","ਜਿਸ ਤਰ੍ਹਾਂ ਅੱਜ ਦੇ ਦਿਨ ਕੀਤਾ ਗਿਆ ਹੈ ਉਸੇ ਤਰ੍ਹਾਂ ਹੀ ਕਰਨ ਦਾ ਹੁਕਮ ਯਹੋਵਾਹ ਨੇ ਦਿੱਤਾ ਹੈ, ਜਿਸ ਨਾਲ ਤੁਹਾਡੇ ਲਈ ਪ੍ਰਾਸਚਿਤ ਹੋਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","ਇਸ ਲਈ ਤੁਸੀਂ ਮੰਡਲੀ ਦੇ ਡੇਰੇ ਦੇ ਦਰਵਾਜ਼ੇ ਕੋਲ ਸੱਤ ਦਿਨ ਤੱਕ ਰਾਤ-ਦਿਨ ਠਹਿਰੇ ਰਹਿਣਾ ਅਤੇ ਯਹੋਵਾਹ ਦਾ ਹੁਕਮ ਮੰਨਣਾ ਤਾਂ ਜੋ ਤੁਸੀਂ ਨਾ ਮਰੋ, ਕਿਉਂ ਜੋ ਮੈਨੂੰ ਇਹੋ ਹੁਕਮ ਦਿੱਤਾ ਗਿਆ ਹੈ।” ");
INSERT INTO pan_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","ਤਦ ਹਾਰੂਨ ਅਤੇ ਉਸ ਦੇ ਪੁੱਤਰਾਂ ਨੇ ਉਨ੍ਹਾਂ ਸਾਰੀਆਂ ਗੱਲਾਂ ਦੇ ਅਨੁਸਾਰ ਕੀਤਾ, ਜਿਨ੍ਹਾਂ ਦਾ ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਦੀ ਰਾਹੀਂ ਹੁਕਮ ਦਿੱਤਾ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","ਅੱਠਵੇਂ ਦਿਨ ਮੂਸਾ ਨੇ ਹਾਰੂਨ, ਉਸ ਦੇ ਪੁੱਤਰਾਂ ਅਤੇ ਇਸਰਾਏਲ ਦੇ ਬਜ਼ੁਰਗਾਂ ਨੂੰ ਸੱਦਿਆ, ");
INSERT INTO pan_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","ਅਤੇ ਉਸ ਨੇ ਹਾਰੂਨ ਨੂੰ ਆਖਿਆ, “ਪਾਪ ਬਲੀ ਦੀ ਭੇਟ ਲਈ ਤੂੰ ਇੱਕ ਵੱਛਾ ਅਤੇ ਹੋਮ ਬਲੀ ਦੀ ਭੇਟ ਲਈ ਇੱਕ ਭੇਡੂ ਦੋਸ਼ ਰਹਿਤ ਲੈ ਕੇ ਉਨ੍ਹਾਂ ਨੂੰ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਚੜ੍ਹਾਵੀਂ। ");
INSERT INTO pan_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","ਅਤੇ ਤੂੰ ਇਸਰਾਏਲੀਆਂ ਨੂੰ ਇਹ ਆਖ ਕਿ ਤੁਸੀਂ ਪਾਪ ਬਲੀ ਦੀ ਭੇਟ ਲਈ ਇੱਕ ਬੱਕਰਾ ਅਤੇ ਹੋਮ ਬਲੀ ਲਈ ਇੱਕ ਵੱਛਾ ਅਤੇ ਇੱਕ ਲੇਲਾ ਲਓ, ਜੋ ਇੱਕ ਸਾਲ ਦੇ ਅਤੇ ਦੋਸ਼ ਰਹਿਤ ਹੋਣ। ");
INSERT INTO pan_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","ਸੁੱਖ-ਸਾਂਦ ਦੀਆਂ ਭੇਟਾਂ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਚੜ੍ਹਾਉਣ ਲਈ ਇੱਕ ਬਲ਼ਦ, ਇੱਕ ਭੇਡੂ ਅਤੇ ਤੇਲ ਨਾਲ ਰਲੀ ਹੋਈ ਮੈਦੇ ਦੀ ਇੱਕ ਭੇਟ ਲੈ ਲਓ, ਕਿਉਂ ਜੋ ਅੱਜ ਯਹੋਵਾਹ ਤੁਹਾਨੂੰ ਦਰਸ਼ਣ ਦੇਵੇਗਾ।” ");
INSERT INTO pan_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","ਤਦ ਜਿਨ੍ਹਾਂ ਵਸਤੂਆਂ ਦਾ ਮੂਸਾ ਨੇ ਹੁਕਮ ਦਿੱਤਾ ਸੀ, ਉਹ ਉਨ੍ਹਾਂ ਨੂੰ ਮੰਡਲੀ ਦੇ ਡੇਰੇ ਦੇ ਅੱਗੇ ਲੈ ਆਏ ਅਤੇ ਸਾਰੀ ਮੰਡਲੀ ਕੋਲ ਜਾ ਕੇ ਯਹੋਵਾਹ ਦੇ ਸਨਮੁਖ ਖੜ੍ਹੀ ਹੋਈ। ");
INSERT INTO pan_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","ਤਦ ਮੂਸਾ ਨੇ ਆਖਿਆ, “ਇਹ ਉਹ ਕੰਮ ਹੈ ਜਿਸ ਨੂੰ ਕਰਨ ਦਾ ਹੁਕਮ ਯਹੋਵਾਹ ਨੇ ਦਿੱਤਾ ਹੈ ਕਿ ਤੁਸੀਂ ਇਹ ਕਰੋ ਅਤੇ ਯਹੋਵਾਹ ਦੇ ਪ੍ਰਤਾਪ ਦਾ ਦਰਸ਼ਣ ਤੁਹਾਨੂੰ ਹੋਵੇਗਾ।” ");
INSERT INTO pan_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","ਅਤੇ ਮੂਸਾ ਨੇ ਹਾਰੂਨ ਨੂੰ ਆਖਿਆ, “ਯਹੋਵਾਹ ਦੇ ਹੁਕਮ ਅਨੁਸਾਰ ਜਗਵੇਦੀ ਦੇ ਕੋਲ ਜਾ ਕੇ ਆਪਣੀ ਪਾਪ ਬਲੀ ਦੀ ਭੇਟ ਅਤੇ ਹੋਮ ਬਲੀ ਦੀ ਭੇਟ ਚੜ੍ਹਾ ਅਤੇ ਆਪਣੇ ਲਈ ਅਤੇ ਸਾਰੇ ਲੋਕਾਂ ਦੇ ਲਈ ਪ੍ਰਾਸਚਿਤ ਕਰ ਅਤੇ ਲੋਕਾਂ ਦੀ ਭੇਟ ਚੜ੍ਹਾ ਕੇ ਉਨ੍ਹਾਂ ਦੇ ਲਈ ਪ੍ਰਾਸਚਿਤ ਕਰ।” ");
INSERT INTO pan_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","ਇਸ ਲਈ ਹਾਰੂਨ ਨੇ ਜਗਵੇਦੀ ਦੇ ਕੋਲ ਜਾ ਕੇ ਉਸ ਪਾਪ ਬਲੀ ਦੀ ਭੇਟ ਦੇ ਵੱਛੇ ਨੂੰ ਵੱਢਿਆ, ਜੋ ਉਸ ਦੇ ਆਪਣੇ ਲਈ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","ਅਤੇ ਹਾਰੂਨ ਦੇ ਪੁੱਤਰ ਲਹੂ ਨੂੰ ਉਸ ਦੇ ਕੋਲ ਲੈ ਆਏ ਅਤੇ ਉਸ ਨੇ ਆਪਣੀ ਉਂਗਲ ਲਹੂ ਵਿੱਚ ਡੋਬ ਕੇ ਉਸ ਨੂੰ ਜਗਵੇਦੀ ਦੇ ਸਿੰਗਾਂ ਉੱਤੇ ਲਗਾਇਆ ਅਤੇ ਬਾਕੀ ਲਹੂ ਜਗਵੇਦੀ ਦੇ ਹੇਠ ਡੋਲ੍ਹ ਦਿੱਤਾ। ");
INSERT INTO pan_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","ਪਰ ਪਾਪ ਬਲੀ ਦੀ ਭੇਟ ਦੀ ਚਰਬੀ, ਗੁਰਦੇ ਅਤੇ ਕਲੇਜੇ ਦੇ ਉੱਪਰਲੀ ਝਿੱਲੀ ਨੂੰ ਉਸ ਨੇ ਜਗਵੇਦੀ ਦੇ ਉੱਤੇ ਸਾੜਿਆ, ਜਿਵੇਂ ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਹੁਕਮ ਦਿੱਤਾ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","ਅਤੇ ਮਾਸ ਅਤੇ ਖੱਲ ਨੂੰ ਉਸ ਨੇ ਡੇਰੇ ਤੋਂ ਬਾਹਰ ਅੱਗ ਨਾਲ ਸਾੜਿਆ। ");
INSERT INTO pan_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","ਤਦ ਉਸ ਨੇ ਹੋਮ ਬਲੀ ਦੀ ਭੇਟ ਨੂੰ ਵੱਢਿਆ ਅਤੇ ਹਾਰੂਨ ਦੇ ਪੁੱਤਰ ਲਹੂ ਨੂੰ ਉਸ ਦੇ ਕੋਲ ਲਿਆਏ ਅਤੇ ਉਸ ਨੇ ਲਹੂ ਨੂੰ ਜਗਵੇਦੀ ਦੇ ਚੁਫ਼ੇਰੇ ਛਿੜਕਿਆ। ");
INSERT INTO pan_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","ਅਤੇ ਉਨ੍ਹਾਂ ਨੇ ਹੋਮ ਬਲੀ ਦੀ ਭੇਟ ਦੇ ਟੁੱਕੜੇ-ਟੁੱਕੜੇ ਕੀਤੇ ਅਤੇ ਸਿਰ ਸਮੇਤ ਲਿਆਏ, ਤਦ ਉਸ ਨੇ ਉਨ੍ਹਾਂ ਨੂੰ ਜਗਵੇਦੀ ਉੱਤੇ ਸਾੜਿਆ। ");
INSERT INTO pan_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","ਅਤੇ ਉਸ ਨੇ ਆਂਦਰਾਂ ਅਤੇ ਲੱਤਾਂ ਨੂੰ ਧੋ ਕੇ ਉਨ੍ਹਾਂ ਨੂੰ ਜਗਵੇਦੀ ਦੇ ਉੱਤੇ ਹੋਮ ਦੀ ਬਲੀ ਦੇ ਉੱਤੇ ਸਾੜਿਆ। ");
INSERT INTO pan_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","ਤਦ ਉਹ ਲੋਕਾਂ ਦੀ ਭੇਟ ਲਿਆਇਆ ਅਤੇ ਉਸ ਪਾਪ ਬਲੀ ਦੀ ਭੇਟ ਦੇ ਬੱਕਰੇ ਨੂੰ ਜੋ ਲੋਕਾਂ ਦੇ ਲਈ ਸੀ, ਲੈ ਕੇ ਉਸ ਨੂੰ ਵੱਢਿਆ ਅਤੇ ਪਹਿਲਾਂ ਦੀ ਤਰ੍ਹਾਂ ਉਸ ਨੂੰ ਵੀ ਪਾਪ ਬਲੀ ਕਰਕੇ ਚੜ੍ਹਾਇਆ। ");
INSERT INTO pan_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","ਅਤੇ ਉਸ ਨੇ ਹੋਮ ਬਲੀ ਦੀ ਭੇਟ ਲਿਆ ਕੇ, ਉਸ ਨੂੰ ਬਿਧੀ ਦੇ ਅਨੁਸਾਰ ਚੜ੍ਹਾਇਆ। ");
INSERT INTO pan_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","ਅਤੇ ਉਹ ਮੈਦੇ ਦੀ ਭੇਟ ਲਿਆਇਆ ਅਤੇ ਉਸ ਵਿੱਚੋਂ ਇੱਕ ਮੁੱਠ ਭਰ ਕੇ ਉਸ ਨੂੰ ਜਗਵੇਦੀ ਦੇ ਉੱਤੇ ਸਵੇਰ ਦੀ ਹੋਮ ਬਲੀ ਦੇ ਨਾਲ ਸਾੜਿਆ। ");
INSERT INTO pan_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","ਤਦ ਉਸ ਨੇ ਬਲ਼ਦ ਅਤੇ ਭੇਡੂ ਨੂੰ ਲਿਆ ਕੇ ਵੱਢਿਆ, ਜਿਹੜੇ ਲੋਕਾਂ ਦੀ ਸੁੱਖ-ਸਾਂਦ ਦੀਆਂ ਭੇਟਾਂ ਦੇ ਲਈ ਸਨ, ਅਤੇ ਹਾਰੂਨ ਦੇ ਪੁੱਤਰ ਉਸ ਦੇ ਕੋਲ ਲਹੂ ਲਿਆਏ, ਜਿਸ ਨੂੰ ਉਸ ਨੇ ਜਗਵੇਦੀ ਦੇ ਚੁਫ਼ੇਰੇ ਛਿੜਕਿਆ। ");
INSERT INTO pan_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","ਅਤੇ ਉਹ ਬਲ਼ਦ ਅਤੇ ਭੇਡੂ ਦੀ ਚਰਬੀ, ਮੋਟੀ ਪੂਛ ਅਤੇ ਉਹ ਚਰਬੀ ਜੋ ਆਂਦਰਾਂ ਨੂੰ ਢੱਕਦੀ ਹੈ ਅਤੇ ਗੁਰਦੇ ਅਤੇ ਕਲੇਜੇ ਦੇ ਉੱਪਰਲੀ ਝਿੱਲੀ ਉਸ ਦੇ ਕੋਲ ਲਿਆਏ ");
INSERT INTO pan_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","ਅਤੇ ਉਨ੍ਹਾਂ ਨੇ ਚਰਬੀ ਨੂੰ ਛਾਤੀਆਂ ਦੇ ਉੱਤੇ ਰੱਖਿਆ ਅਤੇ ਉਸ ਨੇ ਚਰਬੀ ਨੂੰ ਜਗਵੇਦੀ ਦੇ ਉੱਤੇ ਸਾੜਿਆ। ");
INSERT INTO pan_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","ਹਾਰੂਨ ਨੇ ਛਾਤੀਆਂ ਅਤੇ ਸੱਜੇ ਪੱਟ ਨੂੰ ਹਿਲਾਉਣ ਦੀ ਭੇਟ ਕਰਕੇ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਹਿਲਾਇਆ, ਜਿਵੇਂ ਮੂਸਾ ਨੇ ਹੁਕਮ ਦਿੱਤਾ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","ਤਦ ਹਾਰੂਨ ਨੇ ਲੋਕਾਂ ਵੱਲ ਆਪਣੇ ਹੱਥ ਵਧਾ ਕੇ ਉਨ੍ਹਾਂ ਨੂੰ ਅਸੀਸ ਦਿੱਤੀ ਅਤੇ ਪਾਪ ਬਲੀ ਦੀ ਭੇਟ, ਹੋਮ ਬਲੀ ਦੀ ਭੇਟ ਅਤੇ ਸੁੱਖ-ਸਾਂਦ ਦੀਆਂ ਭੇਟਾਂ ਨੂੰ ਚੜ੍ਹਾ ਕੇ ਹੇਠਾਂ ਆਇਆ। ");
INSERT INTO pan_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","ਤਦ ਮੂਸਾ ਅਤੇ ਹਾਰੂਨ ਮੰਡਲੀ ਦੇ ਡੇਰੇ ਵਿੱਚ ਗਏ ਅਤੇ ਨਿੱਕਲ ਕੇ ਲੋਕਾਂ ਨੂੰ ਅਸੀਸ ਦਿੱਤੀ ਅਤੇ ਯਹੋਵਾਹ ਦੇ ਪ੍ਰਤਾਪ ਦਾ ਦਰਸ਼ਣ ਸਾਰੇ ਲੋਕਾਂ ਨੂੰ ਹੋਇਆ। ");
INSERT INTO pan_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","ਅਤੇ ਯਹੋਵਾਹ ਦੇ ਅੱਗੋਂ ਇੱਕ ਅੱਗ ਨਿੱਕਲੀ ਉਸ ਹੋਮ ਦੀ ਭੇਟ ਅਤੇ ਚਰਬੀ ਨੂੰ ਜੋ ਜਗਵੇਦੀ ਉੱਤੇ ਸੀ, ਭਸਮ ਕਰ ਦਿੱਤਾ। ਜਦ ਸਾਰੇ ਲੋਕਾਂ ਨੇ ਇਹ ਵੇਖਿਆ ਤਾਂ ਉੱਚੀ ਆਵਾਜ਼ ਵਿੱਚ ਜੈਕਾਰਾ ਗਜਾਇਆ ਅਤੇ ਮੂੰਹ ਭਾਰ ਡਿੱਗ ਕੇ ਮੱਥਾ ਟੇਕਿਆ। ");
INSERT INTO pan_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","ਤਦ ਹਾਰੂਨ ਦੇ ਪੁੱਤਰਾਂ ਨਾਦਾਬ ਅਤੇ ਅਬੀਹੂ ਨੇ ਆਪੋ-ਆਪਣੀ ਧੂਪਦਾਨੀ ਲੈ ਕੇ ਉਸ ਦੇ ਵਿੱਚ ਅੱਗ ਭਰੀ ਅਤੇ ਉਸ ਵਿੱਚ ਧੂਪ ਪਾ ਕੇ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਓਪਰਾ ਧੂਪ ਧੁਖਾਇਆ, ਜਿਸ ਤੋਂ ਯਹੋਵਾਹ ਨੇ ਉਨ੍ਹਾਂ ਨੂੰ ਵਰਜਿਆ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","ਤਦ ਯਹੋਵਾਹ ਦੇ ਅੱਗੋਂ ਇੱਕ ਅੱਗ ਨਿੱਕਲੀ ਅਤੇ ਉਨ੍ਹਾਂ ਨੂੰ ਭਸਮ ਕਰ ਦਿੱਤਾ ਅਤੇ ਉਹ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਮਰ ਗਏ। ");
INSERT INTO pan_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","ਤਦ ਮੂਸਾ ਨੇ ਹਾਰੂਨ ਨੂੰ ਆਖਿਆ, “ਇਹ ਉਹ ਗੱਲ ਹੈ, ਜਿਹੜੀ ਯਹੋਵਾਹ ਨੇ ਆਖੀ ਸੀ ਕਿ ਜੋ ਮੇਰੇ ਨਜ਼ਦੀਕ ਆਵੇ ਮੈਂ ਆਪਣੇ ਆਪ ਨੂੰ ਉਨ੍ਹਾਂ ਦੇ ਸਾਹਮਣੇ ਪਵਿੱਤਰ ਵਿਖਾਵਾਂਗਾ ਅਤੇ ਸਾਰੇ ਲੋਕਾਂ ਦੇ ਸਾਹਮਣੇ ਮੇਰੀ ਵਡਿਆਈ ਹੋਵੇਗੀ।” ਅਤੇ ਹਾਰੂਨ ਚੁੱਪ ਰਿਹਾ। ");
INSERT INTO pan_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","ਤਦ ਮੂਸਾ ਨੇ ਹਾਰੂਨ ਦੇ ਚਾਚੇ ਉੱਜ਼ੀਏਲ ਦੇ ਪੁੱਤਰ ਮੀਸ਼ਾਏਲ ਅਤੇ ਅਲਸਾਫਾਨ ਨੂੰ ਸੱਦ ਕੇ ਉਨ੍ਹਾਂ ਨੂੰ ਆਖਿਆ, “ਨੇੜੇ ਆਓ ਅਤੇ ਆਪਣੇ ਭਰਾਵਾਂ ਨੂੰ ਪਵਿੱਤਰ ਸਥਾਨ ਦੇ ਅੱਗੋਂ ਚੁੱਕ ਕੇ ਡੇਰੇ ਤੋਂ ਬਾਹਰ ਲੈ ਜਾਓ।” ");
INSERT INTO pan_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","ਤਦ ਉਨ੍ਹਾਂ ਨੇ ਮੂਸਾ ਦੇ ਹੁਕਮ ਅਨੁਸਾਰ ਨੇੜੇ ਜਾ ਕੇ ਉਨ੍ਹਾਂ ਨੂੰ ਉਨ੍ਹਾਂ ਦੇ ਕੁੜਤਿਆਂ ਸਮੇਤ ਚੁੱਕਿਆ ਅਤੇ ਡੇਰੇ ਤੋਂ ਬਾਹਰ ਲੈ ਗਏ। ");
INSERT INTO pan_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","ਤਦ ਮੂਸਾ ਨੇ ਹਾਰੂਨ ਅਤੇ ਉਸ ਦੇ ਪੁੱਤਰ ਅਲਆਜ਼ਾਰ ਅਤੇ ਈਥਾਮਾਰ ਨੂੰ ਆਖਿਆ, “ਆਪਣੇ ਸਿਰਾਂ ਨੂੰ ਨੰਗੇ ਨਾ ਕਰੋ ਅਤੇ ਨਾ ਹੀ ਆਪਣੇ ਬਸਤਰਾਂ ਨੂੰ ਪਾੜੋ, ਅਜਿਹਾ ਨਾ ਹੋਵੇ ਕਿ ਤੁਸੀਂ ਵੀ ਮਰ ਜਾਓ ਅਤੇ ਸਾਰੀ ਮੰਡਲੀ ਉੱਤੇ ਉਸ ਦਾ ਕ੍ਰੋਧ ਭੜਕੇ ਪਰ ਤੇਰੇ ਭਰਾ ਅਰਥਾਤ ਇਸਰਾਏਲ ਦਾ ਸਾਰਾ ਘਰਾਣਾ ਉਸ ਅੱਗ ਦੇ ਕਾਰਨ ਸੋਗ ਕਰਨ, ਜਿਹੜੀ ਯਹੋਵਾਹ ਨੇ ਜਲਾਈ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","ਤੁਸੀਂ ਮੰਡਲੀ ਦੇ ਡੇਰੇ ਦੇ ਦਰਵਾਜ਼ੇ ਤੋਂ ਬਾਹਰ ਨਾ ਨਿੱਕਲਣਾ, ਅਜਿਹਾ ਨਾ ਹੋਵੇ ਕਿ ਤੁਸੀਂ ਮਰ ਜਾਓ ਕਿਉਂ ਜੋ ਯਹੋਵਾਹ ਦਾ ਮਸਹ ਕਰਨ ਦਾ ਤੇਲ ਤੁਹਾਡੇ ਉੱਤੇ ਹੈ।” ਤਦ ਉਨ੍ਹਾਂ ਨੇ ਮੂਸਾ ਦੇ ਬਚਨ ਦੇ ਅਨੁਸਾਰ ਕੀਤਾ। ");
INSERT INTO pan_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","ਫੇਰ ਯਹੋਵਾਹ ਨੇ ਹਾਰੂਨ ਨੂੰ ਆਖਿਆ, ");
INSERT INTO pan_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","“ਜਦ ਤੂੰ ਜਾਂ ਤੇਰੇ ਪੁੱਤਰ ਮੰਡਲੀ ਦੇ ਡੇਰੇ ਵਿੱਚ ਜਾਓ ਤਦ ਤੁਸੀਂ ਕੋਈ ਮਧ ਜਾਂ ਨਸ਼ਾ ਨਾ ਪੀਣਾ, ਤਾਂ ਜੋ ਤੁਸੀਂ ਮਰ ਨਾ ਜਾਓ। ਇਹ ਤੁਹਾਡੀਆਂ ਪੀੜ੍ਹੀਆਂ ਲਈ ਇੱਕ ਸਦਾ ਦੀ ਬਿਧੀ ਹੋਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","ਤਾਂ ਜੋ ਤੁਸੀਂ ਪਵਿੱਤਰ ਅਤੇ ਅਪਵਿੱਤਰ ਦੇ ਵਿੱਚ ਅਤੇ ਸ਼ੁੱਧ ਅਤੇ ਅਸ਼ੁੱਧ ਦੇ ਵਿੱਚ ਫ਼ਰਕ ਕਰ ਸਕੋ। ");
INSERT INTO pan_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","ਅਤੇ ਇਸਰਾਏਲੀਆਂ ਨੂੰ ਉਹ ਸਾਰੀਆਂ ਬਿਧੀਆਂ ਸਿਖਾਓ ਜੋ ਯਹੋਵਾਹ ਨੇ ਉਨ੍ਹਾਂ ਨੂੰ ਮੂਸਾ ਦੇ ਰਾਹੀਂ ਆਖੀਆਂ ਸਨ।” ");
INSERT INTO pan_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","ਤਦ ਮੂਸਾ ਨੇ ਹਾਰੂਨ ਅਤੇ ਉਸ ਦੇ ਬਚੇ ਹੋਏ ਦੋਵੇਂ ਪੁੱਤਰਾਂ ਅਲਆਜ਼ਾਰ ਅਤੇ ਈਥਾਮਾਰ ਨੂੰ ਆਖਿਆ, “ਯਹੋਵਾਹ ਦੀਆਂ ਅੱਗ ਦੀਆਂ ਭੇਟਾਂ ਵਿੱਚੋਂ ਜਿਹੜੀ ਮੈਦੇ ਦੀ ਭੇਟ ਬਚੀ ਹੈ, ਉਸ ਨੂੰ ਲੈ ਕੇ ਜਗਵੇਦੀ ਦੇ ਕੋਲ ਖ਼ਮੀਰ ਤੋਂ ਬਿਨ੍ਹਾਂ ਖਾਓ, ਕਿਉਂ ਜੋ ਉਹ ਅੱਤ ਪਵਿੱਤਰ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","ਅਤੇ ਤੁਸੀਂ ਉਸ ਨੂੰ ਪਵਿੱਤਰ ਸਥਾਨ ਵਿੱਚ ਖਾਣਾ ਕਿਉਂ ਜੋ ਯਹੋਵਾਹ ਦੀਆਂ ਅੱਗ ਦੀਆਂ ਬਲੀਆਂ ਵਿੱਚੋਂ ਇਹ ਤੇਰਾ ਅਤੇ ਤੇਰੇ ਪੁੱਤਰਾਂ ਦਾ ਅਧਿਕਾਰ ਹੈ, ਕਿਉਂ ਜੋ ਮੈਨੂੰ ਇਹੋ ਹੁਕਮ ਦਿੱਤਾ ਗਿਆ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","ਪਰ ਹਿਲਾਉਣ ਦੀ ਭੇਟ ਦੀ ਛਾਤੀ ਅਤੇ ਚੁੱਕਣ ਦੀ ਭੇਟ ਦੇ ਪੱਟ ਨੂੰ ਤੂੰ, ਤੇਰੇ ਪੁੱਤਰ ਅਤੇ ਤੇਰੀਆਂ ਧੀਆਂ ਕਿਸੇ ਸਾਫ਼-ਸੁਥਰੇ ਸਥਾਨ ਵਿੱਚ ਖਾਣ, ਕਿਉਂ ਜੋ ਉਹ ਇਸਰਾਏਲੀਆਂ ਦੁਆਰਾ ਦਿੱਤੀਆਂ ਹੋਈਆਂ ਸੁੱਖ-ਸਾਂਦ ਦੀਆਂ ਭੇਟਾਂ ਦੀਆਂ ਬਲੀਆਂ ਵਿੱਚੋਂ, ਤੇਰਾ ਅਤੇ ਤੇਰੇ ਪੁੱਤਰਾਂ ਦਾ ਅਧਿਕਾਰ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","ਉਹ ਚਰਬੀ ਦੀਆਂ ਅੱਗ ਦੀਆਂ ਭੇਟਾਂ ਸਮੇਤ, ਚੁੱਕਣ ਦੇ ਪੱਟ ਅਤੇ ਹਿਲਾਉਣ ਦੀ ਛਾਤੀ ਨੂੰ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਹਿਲਾਉਣ ਦੀ ਭੇਟ ਕਰਕੇ ਲਿਆਉਣ ਅਤੇ ਇਹ ਹਿੱਸਾ ਸਦਾ ਦੀ ਬਿਧੀ ਕਰਕੇ ਤੇਰਾ ਅਤੇ ਤੇਰੇ ਪੁੱਤਰਾਂ ਦਾ ਹੋਵੇਗਾ, ਜਿਵੇਂ ਯਹੋਵਾਹ ਨੇ ਹੁਕਮ ਦਿੱਤਾ ਹੈ।” ");
INSERT INTO pan_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","ਤਦ ਮੂਸਾ ਨੇ ਬੜੇ ਜਤਨ ਨਾਲ ਪਾਪ ਬਲੀ ਦੀ ਭੇਟ ਦੇ ਬੱਕਰੇ ਨੂੰ ਲੱਭਿਆ ਅਤੇ ਵੇਖੋ, ਉਹ ਸਾੜਿਆ ਗਿਆ ਸੀ। ਇਸ ਲਈ ਉਹ ਹਾਰੂਨ ਦੇ ਪੁੱਤਰ ਅਲਆਜ਼ਾਰ ਅਤੇ ਈਥਾਮਾਰ ਨਾਲ ਜਿਹੜੇ ਬਚ ਗਏ ਸਨ, ਇਹ ਆਖ ਕੇ ਕ੍ਰੋਧਿਤ ਹੋਇਆ, ");
INSERT INTO pan_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","“ਤੁਸੀਂ ਪਾਪ ਬਲੀ ਦੀ ਭੇਟ ਨੂੰ ਜੋ ਅੱਤ ਪਵਿੱਤਰ ਹੈ, ਅਤੇ ਜਿਸ ਨੂੰ ਯਹੋਵਾਹ ਨੇ ਤੁਹਾਨੂੰ ਇਸ ਲਈ ਦਿੱਤਾ ਹੈ ਕਿ ਤੁਸੀਂ ਮੰਡਲੀ ਦੇ ਪਾਪ ਚੁੱਕਣ ਲਈ ਉਨ੍ਹਾਂ ਦੇ ਲਈ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਪ੍ਰਾਸਚਿਤ ਕਰੋ, ਤੁਸੀਂ ਉਸ ਦਾ ਮਾਸ ਪਵਿੱਤਰ ਸਥਾਨ ਵਿੱਚ ਕਿਉਂ ਨਹੀਂ ਖਾਧਾ? ");
INSERT INTO pan_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","ਵੇਖੋ, ਉਸ ਦਾ ਲਹੂ ਪਵਿੱਤਰ ਸਥਾਨ ਦੇ ਅੰਦਰ ਲਿਆਂਦਾ ਹੀ ਨਹੀਂ ਗਿਆ, ਇਹ ਜ਼ਰੂਰੀ ਸੀ ਕਿ ਤੁਸੀਂ ਉਸ ਦੇ ਮਾਸ ਨੂੰ ਪਵਿੱਤਰ ਸਥਾਨ ਵਿੱਚ ਖਾਂਦੇ, ਜਿਵੇਂ ਮੈਂ ਹੁਕਮ ਦਿੱਤਾ ਸੀ।” ");
INSERT INTO pan_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","ਤਦ ਹਾਰੂਨ ਨੇ ਮੂਸਾ ਨੂੰ ਆਖਿਆ, “ਵੇਖੋ, ਅੱਜ ਦੇ ਦਿਨ ਉਨ੍ਹਾਂ ਨੇ ਆਪਣੀ ਪਾਪ ਬਲੀ ਦੀ ਭੇਟ ਅਤੇ ਹੋਮ ਬਲੀ ਦੀ ਭੇਟ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਚੜ੍ਹਾਈ ਹੈ, ਅਤੇ ਇਹੋ ਜਿਹੀਆਂ ਗੱਲਾਂ ਮੇਰੇ ਨਾਲ ਹੋਈਆਂ ਹਨ, ਇਸ ਲਈ ਜੇਕਰ ਮੈਂ ਅੱਜ ਦੇ ਦਿਨ ਪਾਪ ਬਲੀ ਦੀ ਭੇਟ ਤੋਂ ਖਾਂਦਾ ਤਾਂ ਭਲਾ, ਯਹੋਵਾਹ ਇਸ ਤੋਂ ਪ੍ਰਸੰਨ ਹੁੰਦਾ?” ");
INSERT INTO pan_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","ਜਦ ਮੂਸਾ ਨੇ ਇਹ ਸੁਣਿਆ ਤਾਂ ਉਹ ਰਾਜ਼ੀ ਹੋ ਗਿਆ। ");
INSERT INTO pan_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","ਤਦ ਯਹੋਵਾਹ ਮੂਸਾ ਅਤੇ ਹਾਰੂਨ ਨਾਲ ਇਹ ਆਖ ਕੇ ਬੋਲਿਆ, ");
INSERT INTO pan_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","ਇਸਰਾਏਲੀਆਂ ਨੂੰ ਆਖੋ ਸਾਰੇ ਪਸ਼ੂਆਂ ਵਿੱਚੋਂ ਜਿਹੜੇ ਧਰਤੀ ਉੱਤੇ ਹਨ, ਉਨ੍ਹਾਂ ਵਿੱਚੋਂ ਤੁਸੀਂ ਜਿਹੜੇ ਪਸ਼ੂਆਂ ਦਾ ਮਾਸ ਖਾ ਸਕਦੇ ਹੋ, ਉਹ ਇਹ ਹਨ: ");
INSERT INTO pan_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","ਪਸ਼ੂਆਂ ਵਿੱਚੋਂ ਜਿਨ੍ਹਾਂ ਦੇ ਖੁਰ ਚਿਰੇ ਹੋਏ ਅਤੇ ਪਾਟੇ ਹੋਏ ਹੋਣ ਅਤੇ ਜੁਗਾਲੀ ਕਰਦੇ ਹੋਣ, ਉਨ੍ਹਾਂ ਨੂੰ ਤੁਸੀਂ ਖਾ ਸਕਦੇ ਹੋ। ");
INSERT INTO pan_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","ਪਰ ਉਨ੍ਹਾਂ ਪਸ਼ੂਆਂ ਵਿੱਚੋਂ ਜਿਹੜੇ ਜੁਗਾਲੀ ਕਰਦੇ ਹਨ, ਜਾਂ ਜਿਨ੍ਹਾਂ ਦੇ ਖੁਰ ਪਾਟੇ ਹੋਏ ਹਨ, ਇਨ੍ਹਾਂ ਪਸ਼ੂਆਂ ਨੂੰ ਤੁਸੀਂ ਨਾ ਖਾਣਾ, ਜਿਵੇਂ ਊਠ ਕਿਉਂ ਜੋ ਉਹ ਜੁਗਾਲੀ ਤਾਂ ਕਰਦਾ ਹੈ ਪਰ ਉਸ ਦੇ ਖੁਰ ਪਾਟੇ ਹੋਏ ਨਹੀਂ ਹਨ, ਇਸ ਲਈ ਉਹ ਤੁਹਾਡੇ ਲਈ ਅਸ਼ੁੱਧ ਹੈ, ");
INSERT INTO pan_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","ਅਤੇ ਪਹਾੜੀ ਚੂਹਾ ਕਿਉਂ ਜੋ ਉਹ ਜੁਗਾਲੀ ਤਾਂ ਕਰਦਾ ਹੈ ਪਰ ਉਸ ਦੇ ਖੁਰ ਪਾਟੇ ਹੋਏ ਨਹੀਂ ਹਨ, ਇਸ ਲਈ ਉਹ ਤੁਹਾਡੇ ਲਈ ਅਸ਼ੁੱਧ ਹੈ, ");
INSERT INTO pan_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","ਅਤੇ ਖਰਗੋਸ਼ ਕਿਉਂ ਜੋ ਉਹ ਜੁਗਾਲੀ ਤਾਂ ਕਰਦਾ ਹੈ ਪਰ ਉਸ ਦੇ ਖੁਰ ਪਾਟੇ ਹੋਏ ਨਹੀਂ ਹਨ, ਇਸ ਲਈ ਉਹ ਤੁਹਾਡੇ ਲਈ ਅਸ਼ੁੱਧ ਹੈ, ");
INSERT INTO pan_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","ਅਤੇ ਸੂਰ ਭਾਵੇਂ ਉਸ ਦੇ ਖੁਰ ਚਿਰੇ ਹੋਏ ਅਤੇ ਪਾਟੇ ਹੋਏ ਤਾਂ ਹਨ, ਪਰ ਉਹ ਜੁਗਾਲੀ ਨਹੀਂ ਕਰਦਾ, ਇਸ ਲਈ ਉਹ ਤੁਹਾਡੇ ਲਈ ਅਸ਼ੁੱਧ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","ਇਨ੍ਹਾਂ ਦੇ ਮਾਸ ਨੂੰ ਤੁਸੀਂ ਨਾ ਖਾਣਾ ਅਤੇ ਨਾ ਹੀ ਉਨ੍ਹਾਂ ਦੀ ਲੋਥ ਨੂੰ ਛੂਹਣਾ, ਕਿਉਂ ਜੋ ਇਹ ਤੁਹਾਡੇ ਲਈ ਅਸ਼ੁੱਧ ਹਨ। ");
INSERT INTO pan_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","ਜਿੰਨ੍ਹੇ ਜਲ-ਜੰਤੂ ਹਨ, ਉਨ੍ਹਾਂ ਵਿੱਚੋਂ ਤੁਸੀਂ ਇਨ੍ਹਾਂ ਨੂੰ ਖਾ ਸਕਦੇ ਹੋ, ਅਰਥਾਤ ਸਮੁੰਦਰ ਅਤੇ ਨਦੀਆਂ ਵਿੱਚ ਰਹਿਣ ਵਾਲੇ ਜੀਵਾਂ ਵਿੱਚੋਂ ਜਿਨ੍ਹਾਂ ਦੇ ਖੰਭ ਅਤੇ ਚਾਨੇ ਹੋਣ। ");
INSERT INTO pan_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","ਅਤੇ ਪਾਣੀ ਵਿੱਚ ਰਹਿਣ ਵਾਲੇ ਜੀਵਾਂ ਵਿੱਚੋਂ ਜਿਹੜੇ ਸਮੁੰਦਰ ਅਤੇ ਨਦੀਆਂ ਵਿੱਚ ਚਲਦੇ ਹਨ, ਪਰ ਉਨ੍ਹਾਂ ਦੇ ਖੰਭ ਅਤੇ ਚਾਨੇ ਨਾ ਹੋਣ, ਉਹ ਸਾਰੇ ਤੁਹਾਡੇ ਲਈ ਘਿਣਾਉਣੇ ਹਨ। ");
INSERT INTO pan_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","ਇਨ੍ਹਾਂ ਸਾਰਿਆਂ ਨੂੰ ਤੁਸੀਂ ਘਿਣਾਉਣੇ ਸਮਝੋ, ਤੁਸੀਂ ਉਨ੍ਹਾਂ ਦਾ ਮਾਸ ਨਾ ਖਾਣਾ ਸਗੋਂ ਉਨ੍ਹਾਂ ਦੀ ਲੋਥ ਨੂੰ ਵੀ ਅਸ਼ੁੱਧ ਜਾਣੋ। ");
INSERT INTO pan_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","ਪਾਣੀਆਂ ਵਿੱਚ ਰਹਿਣ ਵਾਲੇ ਜਿਹੜੇ ਜੀਵਾਂ ਦੇ ਖੰਭ ਅਤੇ ਚਾਨੇ ਨਾ ਹੋਣ, ਉਹ ਸਾਰੇ ਤੁਹਾਡੇ ਲਈ ਅਸ਼ੁੱਧ ਹਨ। ");
INSERT INTO pan_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","ਪੰਛੀਆਂ ਵਿੱਚੋਂ ਜਿਹੜੇ ਤੁਹਾਡੇ ਲਈ ਅਸ਼ੁੱਧ ਹਨ, ਉਹ ਇਹ ਹਨ, ਇਹ ਨਾ ਖਾਧੇ ਜਾਣ ਕਿਉਂ ਜੋ ਇਹ ਘਿਣਾਉਣੇ ਹਨ ਅਰਥਾਤ ਉਕਾਬ, ਗਿੱਧ, ਮੱਛੀ ਮਾਰ, ");
INSERT INTO pan_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","ਇੱਲ, ਗਿਰਝ ਆਪਣੀ ਪ੍ਰਜਾਤੀ ਅਨੁਸਾਰ, ");
INSERT INTO pan_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","ਸਭ ਪ੍ਰਕਾਰ ਦੇ ਕਾਂ ਆਪਣੀ ਪ੍ਰਜਾਤੀ ਅਨੁਸਾਰ, ");
INSERT INTO pan_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","ਸ਼ੁਤਰਮੁਰਗ, ਬਿਲ ਬਤੌਰੀ, ਕੋਇਲ ਅਤੇ ਬਾਜ਼ ਆਪਣੀ ਪ੍ਰਜਾਤੀ ਅਨੁਸਾਰ, ");
INSERT INTO pan_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","ਚੁਗਲ, ਜਲਕਾਊਂ, ਵੱਡਾ ਉੱਲੂ, ");
INSERT INTO pan_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","ਰਾਜਹੰਸ, ਹਵਾਸਿਲ, ਆਰਗਲ, ");
INSERT INTO pan_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","ਲਮਢੀਂਗ ਅਤੇ ਬਗਲਾ ਆਪਣੀ ਪ੍ਰਜਾਤੀ ਅਨੁਸਾਰ, ਟਟੀਹਰੀ ਅਤੇ ਚਮਗਾਦੜ, ");
INSERT INTO pan_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","ਸਾਰੇ ਘਿਸਰਨ ਵਾਲੇ ਜੋ ਉੱਡਦੇ ਹਨ ਅਤੇ ਚਾਰ ਪੈਰਾਂ ਨਾਲ ਚਲਦੇ ਹਨ, ਉਹ ਸਭ ਤੁਹਾਡੇ ਲਈ ਘਿਣਾਉਣੇ ਹਨ। ");
INSERT INTO pan_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","ਪਰ ਸਾਰੇ ਘਿਸਰਨ ਵਾਲਿਆਂ ਵਿੱਚੋਂ ਜਿਹੜੇ ਉੱਡਦੇ ਹਨ ਅਤੇ ਚਾਰ ਪੈਰਾਂ ਨਾਲ ਚੱਲਦੇ ਹਨ, ਅਤੇ ਜਿਨ੍ਹਾਂ ਦੀਆਂ ਧਰਤੀ ਉੱਤੇ ਟੱਪਣ ਲਈ ਲੱਤਾਂ ਹਨ, ਇਹ ਤੁਸੀਂ ਖਾ ਸਕਦੇ ਹੋ। ");
INSERT INTO pan_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","ਉਹ ਇਹ ਹਨ ਅਰਥਾਤ ਮੱਕੜੀ ਆਪਣੀ ਪ੍ਰਜਾਤੀ ਅਨੁਸਾਰ, ਰੋਡਾ ਮੱਕੜੀ ਆਪਣੀ ਪ੍ਰਜਾਤੀ ਅਨੁਸਾਰ, ਗਭਰੇਲਾ ਅਤੇ ਟਿੱਡੀ ਆਪਣੀ ਪ੍ਰਜਾਤੀ ਅਨੁਸਾਰ। ");
INSERT INTO pan_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","ਪਰ ਹੋਰ ਸਾਰੇ ਘਿਸਰਨ ਅਤੇ ਉੱਡਣ ਵਾਲੇ ਕੀੜੇ ਜਿਨ੍ਹਾਂ ਦੇ ਚਾਰ ਪੈਰ ਹਨ, ਇਹ ਸਾਰੇ ਤੁਹਾਡੇ ਲਈ ਘਿਣਾਉਣੇ ਹਨ। ");
INSERT INTO pan_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","ਇਨ੍ਹਾਂ ਤੋਂ ਤੁਸੀਂ ਅਸ਼ੁੱਧ ਹੋਵੋਗੇ, ਜੋ ਕੋਈ ਇਨ੍ਹਾਂ ਦੀ ਲੋਥ ਨੂੰ ਛੂਹੇ ਉਹ ਸ਼ਾਮ ਤੱਕ ਅਸ਼ੁੱਧ ਰਹੇ। ");
INSERT INTO pan_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","ਅਤੇ ਜੋ ਕੋਈ ਇਨ੍ਹਾਂ ਦੀ ਲੋਥ ਵਿੱਚੋਂ ਕੁਝ ਵੀ ਚੁੱਕੇ ਤਾਂ ਉਹ ਆਪਣੇ ਕੱਪੜੇ ਧੋਵੇ ਅਤੇ ਸ਼ਾਮ ਤੱਕ ਅਸ਼ੁੱਧ ਰਹੇ। ");
INSERT INTO pan_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","ਸਾਰੇ ਪਸ਼ੂ ਜਿਨ੍ਹਾਂ ਦੇ ਖੁਰ ਪਾਟੇ ਹੋਏ ਹਨ, ਪਰ ਪੂਰੀ ਤਰ੍ਹਾਂ ਚਿਰੇ ਹੋਏ ਨਹੀਂ ਹਨ, ਅਤੇ ਜੁਗਾਲੀ ਨਹੀਂ ਕਰਦੇ, ਇਹ ਸਾਰੇ ਤੁਹਾਡੇ ਲਈ ਅਸ਼ੁੱਧ ਹਨ, ਜੋ ਕੋਈ ਉਨ੍ਹਾਂ ਨੂੰ ਛੂਹੇ ਉਹ ਅਸ਼ੁੱਧ ਠਹਿਰੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","ਅਤੇ ਚਾਰ ਪੈਰਾਂ ਨਾਲ ਚੱਲਣ ਵਾਲੇ ਸਭ ਪ੍ਰਕਾਰ ਦੇ ਪਸ਼ੂਆਂ ਵਿੱਚੋਂ ਜਿਹੜੇ ਪੰਜਿਆਂ ਭਾਰ ਤੁਰਦੇ ਹਨ, ਉਹ ਸਾਰੇ ਤੁਹਾਡੇ ਲਈ ਅਸ਼ੁੱਧ ਹਨ, ਜੋ ਕੋਈ ਉਨ੍ਹਾਂ ਦੀ ਲੋਥ ਨੂੰ ਛੂਹੇ ਉਹ ਸ਼ਾਮ ਤੱਕ ਅਸ਼ੁੱਧ ਰਹੇ। ");
INSERT INTO pan_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","ਅਤੇ ਜੋ ਕੋਈ ਇਨ੍ਹਾਂ ਦੀ ਲੋਥ ਨੂੰ ਚੁੱਕੇ ਤਾਂ ਉਹ ਆਪਣੇ ਕੱਪੜੇ ਧੋਵੇ ਅਤੇ ਸ਼ਾਮ ਤੱਕ ਅਸ਼ੁੱਧ ਰਹੇ ਕਿਉਂ ਜੋ ਇਹ ਤੁਹਾਡੇ ਲਈ ਅਸ਼ੁੱਧ ਹਨ। ");
INSERT INTO pan_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","ਅਤੇ ਧਰਤੀ ਉੱਤੇ ਘਿਸਰਨ ਵਾਲਿਆਂ ਵਿੱਚੋਂ, ਇਹ ਤੁਹਾਡੇ ਲਈ ਅਸ਼ੁੱਧ ਹਨ, ਅਰਥਾਤ ਛਛੂੰਦਰ, ਚੂਹਾ ਅਤੇ ਗੌਹ ਆਪਣੀ ਪ੍ਰਜਾਤੀ ਦੇ ਅਨੁਸਾਰ, ");
INSERT INTO pan_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","ਅਤੇ ਛਿਪਕਲੀ, ਕੋੜ੍ਹਕਿਰਲੀ, ਕਿਰਲੀ, ਅਜਾਤ ਅਤੇ ਗਿਰਗਿਟ, ");
INSERT INTO pan_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","ਸਾਰੇ ਘਿਸਰਨ ਵਾਲਿਆਂ ਵਿੱਚੋਂ ਇਹ ਤੁਹਾਡੇ ਲਈ ਅਸ਼ੁੱਧ ਹਨ, ਜਿਹੜਾ ਇਨ੍ਹਾਂ ਦੀ ਲੋਥ ਨੂੰ ਛੂਹੇ ਉਹ ਸ਼ਾਮ ਤੱਕ ਅਸ਼ੁੱਧ ਰਹੇ। ");
INSERT INTO pan_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","ਜੇਕਰ ਇਨ੍ਹਾਂ ਵਿੱਚੋਂ ਕੋਈ ਵੀ ਮਰ ਕੇ ਕਿਸੇ ਵਸਤੂ ਉੱਤੇ ਡਿੱਗ ਪਵੇ ਤਾਂ ਉਹ ਵਸਤੂ ਅਸ਼ੁੱਧ ਠਹਿਰੇਗੀ, ਭਾਵੇਂ ਲੱਕੜ ਦਾ ਭਾਂਡਾ, ਭਾਵੇਂ ਬਸਤਰ, ਭਾਵੇਂ ਚਮੜਾ, ਭਾਵੇਂ ਤੱਪੜ, ਭਾਵੇਂ ਕੋਈ ਵੀ ਭਾਂਡਾ ਜੋ ਵਰਤਣ ਵਿੱਚ ਆਇਆ ਹੋਵੇ, ਤਾਂ ਉਹ ਪਾਣੀ ਵਿੱਚ ਪਾਇਆ ਜਾਵੇ ਅਤੇ ਸ਼ਾਮ ਤੱਕ ਅਸ਼ੁੱਧ ਰਹੇ, ਇਸ ਤਰ੍ਹਾਂ ਨਾਲ ਉਹ ਸ਼ੁੱਧ ਹੋਵੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","ਅਤੇ ਜੇਕਰ ਮਿੱਟੀ ਦਾ ਭਾਂਡਾ ਹੋਵੇ, ਜਿਸ ਦੇ ਵਿੱਚ ਇਨ੍ਹਾਂ ਵਿੱਚੋਂ ਕੁਝ ਡਿੱਗ ਪਵੇ, ਤਾਂ ਜੋ ਕੁਝ ਉਸ ਭਾਂਡੇ ਦੇ ਵਿੱਚ ਹੈ ਉਹ ਅਸ਼ੁੱਧ ਹੋਵੇਗਾ ਅਤੇ ਉਹ ਭਾਂਡਾ ਤੋੜ ਦਿੱਤਾ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","ਸਾਰਾ ਭੋਜਨ ਜੋ ਖਾਧਾ ਜਾਂਦਾ ਹੈ, ਜੇਕਰ ਉਸ ਵਿੱਚ ਪਾਣੀ ਪੈ ਜਾਵੇ, ਤਾਂ ਉਹ ਅਸ਼ੁੱਧ ਹੋਵੇਗਾ, ਫੇਰ ਜੋ ਕੁਝ ਇਸ ਪ੍ਰਕਾਰ ਦੇ ਭਾਂਡੇ ਵਿੱਚ ਪੀਤਾ ਜਾਂਦਾ ਹੈ ਉਹ ਸਭ ਕੁਝ ਅਸ਼ੁੱਧ ਹੋਵੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","ਅਤੇ ਜੇਕਰ ਇਨ੍ਹਾਂ ਦੀ ਲੋਥ ਵਿੱਚੋਂ ਕੁਝ ਤੰਦੂਰ ਜਾਂ ਚੁੱਲ੍ਹੇ ਉੱਤੇ ਡਿੱਗ ਪਵੇ ਤਾਂ ਉਹ ਅਸ਼ੁੱਧ ਹੋਣਗੇ ਅਤੇ ਤੋੜ ਦਿੱਤੇ ਜਾਣ, ਕਿਉਂ ਜੋ ਉਹ ਅਸ਼ੁੱਧ ਹਨ, ਅਤੇ ਤੁਹਾਡੇ ਲਈ ਵੀ ਅਸ਼ੁੱਧ ਠਹਿਰਨਗੇ। ");
INSERT INTO pan_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","ਪਰ ਤਲਾਬ ਜਾਂ ਸੋਤਾ ਜਿਸ ਦੇ ਵਿੱਚ ਪਾਣੀ ਬਹੁਤ ਹੋਵੇ, ਉਹ ਸ਼ੁੱਧ ਹੀ ਠਹਿਰੇ ਪਰ ਜੋ ਕੁਝ ਉਨ੍ਹਾਂ ਦੀ ਲੋਥ ਨੂੰ ਛੂਹੇ ਉਹ ਅਸ਼ੁੱਧ ਠਹਿਰੇ। ");
INSERT INTO pan_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","ਜੇਕਰ ਉਨ੍ਹਾਂ ਦੀ ਲੋਥ ਵਿੱਚੋਂ ਕੁਝ ਕਿਸੇ ਬੀਜਣ ਵਾਲੇ ਬੀਜ ਉੱਤੇ ਡਿੱਗ ਜਾਵੇ, ਤਾਂ ਵੀ ਉਹ ਸ਼ੁੱਧ ਰਹੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","ਪਰ ਜੇਕਰ ਉਹ ਬੀਜ ਪਾਣੀ ਵਿੱਚ ਭਿੱਜ ਜਾਵੇ ਅਤੇ ਉਨ੍ਹਾਂ ਦੀ ਲੋਥ ਵਿੱਚੋਂ ਕੁਝ ਉਸ ਦੇ ਉੱਤੇ ਡਿੱਗ ਜਾਵੇ, ਤਾਂ ਉਹ ਤੁਹਾਡੇ ਲਈ ਅਸ਼ੁੱਧ ਹੋਵੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","ਫੇਰ ਜਿਹੜਾ ਪਸ਼ੂ ਤੁਹਾਡੇ ਖਾਣ ਜੋਗ ਹੈ, ਜੇਕਰ ਮਰ ਜਾਵੇ ਤਾਂ ਜੋ ਕੋਈ ਉਸ ਦੀ ਲੋਥ ਨੂੰ ਛੂਹੇ ਉਹ ਸ਼ਾਮ ਤੱਕ ਅਸ਼ੁੱਧ ਰਹੇ। ");
INSERT INTO pan_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","ਜੋ ਕੋਈ ਉਸ ਦੀ ਲੋਥ ਤੋਂ ਕੁਝ ਖਾਵੇ, ਤਾਂ ਆਪਣੇ ਬਸਤਰ ਧੋਵੇ ਅਤੇ ਸ਼ਾਮ ਤੱਕ ਅਸ਼ੁੱਧ ਰਹੇ ਅਤੇ ਜੋ ਕੋਈ ਉਸ ਦੀ ਲੋਥ ਨੂੰ ਚੁੱਕੇ, ਉਹ ਵੀ ਆਪਣੇ ਬਸਤਰ ਧੋਵੇ ਅਤੇ ਸ਼ਾਮ ਤੱਕ ਅਸ਼ੁੱਧ ਰਹੇ। ");
INSERT INTO pan_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","ਅਤੇ ਧਰਤੀ ਉੱਤੇ ਘਿਸਰਨ ਵਾਲੇ ਸਾਰੇ ਜੀਵ ਤੁਹਾਡੇ ਲਈ ਘਿਣਾਉਣੇ ਹਨ, ਇਹ ਨਾ ਖਾਧੇ ਜਾਣ। ");
INSERT INTO pan_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","ਧਰਤੀ ਉੱਤੇ ਘਿਸਰਨ ਵਾਲਿਆਂ ਵਿੱਚੋਂ ਜਿਹੜੇ ਢਿੱਡ ਭਾਰ ਘਿਸਰਦੇ ਜਾਂ ਚਾਰ ਪੈਰਾਂ ਨਾਲ ਤੁਰਦੇ ਹਨ, ਜਾਂ ਜਿਨ੍ਹਾਂ ਦੇ ਵੱਧ ਪੈਰ ਹੁੰਦੇ ਹਨ, ਉਨ੍ਹਾਂ ਨੂੰ ਤੁਸੀਂ ਨਾ ਖਾਣਾ ਕਿਉਂ ਜੋ ਉਹ ਘਿਣਾਉਣੇ ਹਨ। ");
INSERT INTO pan_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","ਕਿਸੇ ਵੀ ਤਰ੍ਹਾਂ ਦੇ ਘਿਸਰਨ ਵਾਲੇ ਜੀਵ ਤੋਂ ਤੁਸੀਂ ਆਪਣੇ ਆਪ ਨੂੰ ਘਿਣਾਉਣਾ ਨਾ ਬਣਾਉਣਾ, ਨਾ ਹੀ ਤੁਸੀਂ ਆਪਣੇ ਆਪ ਨੂੰ ਉਨ੍ਹਾਂ ਤੋਂ ਅਸ਼ੁੱਧ ਬਣਾਉਣਾ ਕਿ ਤੁਸੀਂ ਭਰਿਸ਼ਟ ਹੋ ਜਾਓ। ");
INSERT INTO pan_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","ਕਿਉਂ ਜੋ ਮੈਂ ਯਹੋਵਾਹ ਤੁਹਾਡਾ ਪਰਮੇਸ਼ੁਰ ਹਾਂ, ਇਸ ਲਈ ਤੁਸੀਂ ਆਪਣੇ ਆਪ ਨੂੰ ਸ਼ੁੱਧ ਰੱਖਣਾ ਅਤੇ ਪਵਿੱਤਰ ਬਣਨਾ, ਕਿਉਂ ਜੋ ਮੈਂ ਪਵਿੱਤਰ ਹਾਂ। ਇਸ ਲਈ ਤੁਸੀਂ ਆਪਣੇ ਆਪ ਨੂੰ ਧਰਤੀ ਉੱਤੇ ਘਿਸਰਨ ਵਾਲੇ ਕਿਸੇ ਪ੍ਰਕਾਰ ਦੇ ਜੀਵ ਤੋਂ ਭਰਿਸ਼ਟ ਨਾ ਕਰਨਾ। ");
INSERT INTO pan_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","ਕਿਉਂ ਜੋ ਮੈਂ ਉਹੋ ਯਹੋਵਾਹ ਹਾਂ ਜਿਹੜਾ ਤੁਹਾਨੂੰ ਮਿਸਰ ਦੇਸ ਵਿੱਚੋਂ ਇਸ ਲਈ ਕੱਢ ਲਿਆਇਆ ਹਾਂ, ਤਾਂ ਜੋ ਤੁਹਾਡਾ ਪਰਮੇਸ਼ੁਰ ਠਹਿਰਾਂ, ਇਸ ਲਈ ਤੁਸੀਂ ਪਵਿੱਤਰ ਬਣੋ ਕਿਉਂ ਜੋ ਮੈਂ ਪਵਿੱਤਰ ਹਾਂ। ");
INSERT INTO pan_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","ਪਸ਼ੂਆਂ, ਪੰਛੀਆਂ ਅਤੇ ਪਾਣੀ ਵਿੱਚ ਰਹਿਣ ਵਾਲੇ ਸਾਰੇ ਜੀਵਾਂ ਅਤੇ ਧਰਤੀ ਉੱਤੇ ਘਿਸਰਨ ਵਾਲੇ ਸਾਰੇ ਜੀਵਾਂ ਦੇ ਵਿਖੇ ਇਹੋ ਬਿਵਸਥਾ ਹੈ, ");
INSERT INTO pan_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","ਤਾਂ ਜੋ ਸ਼ੁੱਧ ਅਤੇ ਅਸ਼ੁੱਧ ਅਤੇ ਖਾਣ ਯੋਗ ਅਤੇ ਨਾ ਖਾਣ ਯੋਗ ਪਸ਼ੂ ਦੇ ਵਿਚਕਾਰ ਅੰਤਰ ਕੀਤਾ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","ਫੇਰ ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਆਖਿਆ, ");
INSERT INTO pan_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","ਇਸਰਾਏਲੀਆਂ ਨੂੰ ਆਖ ਜੇਕਰ ਕੋਈ ਇਸਤਰੀ ਗਰਭਵਤੀ ਹੋਵੇ ਅਤੇ ਮੁੰਡੇ ਨੂੰ ਜਨਮ ਦੇਵੇ ਤਾਂ ਉਹ ਸੱਤ ਦਿਨ ਤੱਕ ਅਸ਼ੁੱਧ ਰਹੇ, ਜਿਸ ਤਰ੍ਹਾਂ ਉਹ ਆਪਣੀ ਮਾਹਵਾਰੀ ਦੇ ਦਿਨਾਂ ਵਿੱਚ ਅਸ਼ੁੱਧ ਹੁੰਦੀ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","ਅੱਠਵੇਂ ਦਿਨ ਮੁੰਡੇ ਦੀ ਸੁੰਨਤ ਕੀਤੀ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","ਇਸ ਦੇ ਬਾਅਦ ਉਹ ਉਸ ਲਹੂ ਤੋਂ ਆਪਣੇ ਆਪ ਨੂੰ ਸ਼ੁੱਧ ਕਰਨ ਵਿੱਚ ਤੇਂਤੀ ਦਿਨ ਠਹਿਰੀ ਰਹੇ ਅਤੇ ਕਿਸੇ ਪਵਿੱਤਰ ਵਸਤੂ ਨੂੰ ਨਾ ਛੂਹੇ ਅਤੇ ਨਾ ਹੀ ਪਵਿੱਤਰ ਸਥਾਨ ਵਿੱਚ ਆਵੇ ਜਦ ਤੱਕ ਉਸ ਦੇ ਸ਼ੁੱਧ ਹੋਣ ਦੇ ਦਿਨ ਪੂਰੇ ਨਾ ਹੋ ਜਾਣ। ");
INSERT INTO pan_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","ਪਰ ਜੇਕਰ ਉਹ ਕੁੜੀ ਨੂੰ ਜਨਮ ਦੇਵੇ ਤਾਂ ਉਹ ਪੰਦਰਾਂ ਦਿਨ ਤੱਕ ਅਸ਼ੁੱਧ ਰਹੇ, ਜਿਵੇਂ ਉਹ ਆਪਣੀ ਮਾਹਵਾਰੀ ਦੇ ਦਿਨਾਂ ਵਿੱਚ ਅਸ਼ੁੱਧ ਹੁੰਦੀ ਹੈ ਅਤੇ ਛਿਆਹਠਵੇਂ ਦਿਨ ਤੱਕ ਉਸ ਲਹੂ ਤੋਂ ਆਪਣੇ ਆਪ ਨੂੰ ਸ਼ੁੱਧ ਕਰਨ ਲਈ ਠਹਿਰੀ ਰਹੇ। ");
INSERT INTO pan_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","ਜਦ ਉਸ ਦੇ ਸ਼ੁੱਧ ਹੋਣ ਦੇ ਦਿਨ ਪੂਰੇ ਹੋ ਜਾਣ ਤਾਂ ਭਾਵੇਂ ਉਸ ਨੇ ਪੁੱਤਰ ਨੂੰ ਜਨਮ ਦਿੱਤਾ ਹੋਵੇ ਭਾਵੇਂ ਧੀ ਨੂੰ, ਉਹ ਹੋਮ ਬਲੀ ਦੀ ਭੇਟ ਲਈ ਇੱਕ ਸਾਲ ਦਾ ਲੇਲਾ ਅਤੇ ਪਾਪ ਬਲੀ ਦੀ ਭੇਟ ਲਈ ਕਬੂਤਰ ਦਾ ਬੱਚਾ ਜਾਂ ਘੁੱਗੀ, ਮੰਡਲੀ ਦੇ ਡੇਰੇ ਦੇ ਦਰਵਾਜ਼ੇ ਅੱਗੇ ਜਾਜਕ ਦੇ ਕੋਲ ਲਿਆਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","ਤਦ ਜਾਜਕ ਉਸ ਨੂੰ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਚੜ੍ਹਾਵੇ ਅਤੇ ਉਸ ਦੇ ਲਈ ਪ੍ਰਾਸਚਿਤ ਕਰੇ ਅਤੇ ਤਾਂ ਉਹ ਆਪਣੇ ਲਹੂ ਵਗਣ ਤੋਂ ਸ਼ੁੱਧ ਹੋ ਜਾਵੇਗੀ। ਜੋ ਇਸਤਰੀ ਪੁੱਤਰ ਜਾਂ ਧੀ ਨੂੰ ਜਨਮ ਦੇਵੇ ਉਸ ਦੇ ਲਈ ਇਹੋ ਬਿਵਸਥਾ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","ਜੇਕਰ ਉਹ ਇੱਕ ਲੇਲਾ ਲਿਆਉਣ ਦੇ ਯੋਗ ਨਾ ਹੋਵੇ ਤਾਂ ਉਹ ਦੋ ਘੁੱਗੀਆਂ ਦਾ ਇੱਕ ਜੋੜਾ ਜਾਂ ਕਬੂਤਰਾਂ ਦੇ ਦੋ ਬੱਚੇ ਲਿਆਵੇ, ਇੱਕ ਤਾਂ ਹੋਮ ਬਲੀ ਦੇ ਭੇਟ ਲਈ ਅਤੇ ਦੂਜਾ ਪਾਪ ਬਲੀ ਦੀ ਭੇਟ ਲਈ ਦੇਵੇ ਅਤੇ ਜਾਜਕ ਉਸ ਦੇ ਲਈ ਪ੍ਰਾਸਚਿਤ ਕਰੇ ਅਤੇ ਉਹ ਸ਼ੁੱਧ ਹੋ ਜਾਵੇਗੀ। ");
INSERT INTO pan_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","ਫੇਰ ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਅਤੇ ਹਾਰੂਨ ਨੂੰ ਆਖਿਆ, ");
INSERT INTO pan_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","ਜੇ ਕਿਸੇ ਮਨੁੱਖ ਦੇ ਸਰੀਰ ਦੀ ਚਮੜੀ ਵਿੱਚ ਸੋਜ, ਜਾਂ ਪਪੜੀ, ਜਾਂ ਦਾਗ ਹੋਵੇ ਅਤੇ ਇਹ ਉਸ ਦੇ ਸਰੀਰ ਦੇ ਚਮੜੀ ਵਿੱਚ ਕੋੜ੍ਹ ਵਰਗਾ ਵਿਖਾਈ ਦੇਵੇ, ਤਾਂ ਉਹ ਹਾਰੂਨ ਜਾਜਕ ਦੇ ਕੋਲ ਜਾਂ ਉਸ ਦੇ ਪੁੱਤਰਾਂ ਵਿੱਚੋਂ ਜੋ ਜਾਜਕ ਹੋਵੇ, ਉਸ ਦੇ ਕੋਲ ਲਿਆਇਆ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","ਅਤੇ ਜਾਜਕ ਉਸ ਦੇ ਸਰੀਰ ਦੀ ਚਮੜੀ ਵਿੱਚ ਉਸ ਰੋਗ ਨੂੰ ਜਾਂਚੇ ਅਤੇ ਜੇਕਰ ਉਸ ਰੋਗ ਦੇ ਸਥਾਨ ਤੇ ਵਾਲ਼ ਚਿੱਟੇ ਹੋ ਗਏ ਹੋਣ ਅਤੇ ਰੋਗ ਉਸ ਦੀ ਚਮੜੀ ਨਾਲੋਂ ਡੂੰਘਾ ਦਿਸੇ ਤਾਂ ਉਹ ਜਾਣ ਲਵੇ ਕਿ ਇਹ ਕੋੜ੍ਹ ਦਾ ਰੋਗ ਹੈ ਤਾਂ ਜਾਜਕ ਉਸ ਨੂੰ ਵੇਖ ਕੇ ਅਸ਼ੁੱਧ ਆਖੇ। ");
INSERT INTO pan_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","ਪਰ ਜੇਕਰ ਉਹ ਦਾਗ ਉਸ ਦੀ ਚਮੜੀ ਵਿੱਚ ਚਿੱਟਾ ਹੋਵੇ ਅਤੇ ਵੇਖਣ ਵਿੱਚ ਚਮੜੀ ਨਾਲੋਂ ਡੂੰਘਾ ਨਾ ਦਿਸੇ ਅਤੇ ਉਸ ਦੇ ਵਾਲ਼ ਚਿੱਟੇ ਨਾ ਹੋਏ ਹੋਣ, ਤਾਂ ਜਾਜਕ ਉਸ ਮਨੁੱਖ ਨੂੰ ਸੱਤ ਦਿਨ ਤੱਕ ਅਲੱਗ ਰੱਖੇ। ");
INSERT INTO pan_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","ਅਤੇ ਸੱਤਵੇਂ ਦਿਨ ਜਾਜਕ ਉਸ ਨੂੰ ਜਾਂਚੇ ਅਤੇ ਵੇਖੋ, ਜੇਕਰ ਉਹ ਰੋਗ ਉਸੇ ਤਰ੍ਹਾਂ ਹੀ ਰਹੇ ਅਤੇ ਉਸ ਦੀ ਚਮੜੀ ਵਿੱਚ ਫੈਲਿਆ ਨਾ ਹੋਵੇ ਤਾਂ ਜਾਜਕ ਉਸ ਨੂੰ ਹੋਰ ਸੱਤ ਦਿਨ ਤੱਕ ਅਲੱਗ ਰੱਖੇ। ");
INSERT INTO pan_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","ਅਤੇ ਸੱਤਵੇਂ ਦਿਨ ਜਾਜਕ ਉਸ ਨੂੰ ਫੇਰ ਜਾਂਚੇ ਅਤੇ ਵੇਖੋ, ਜੇਕਰ ਉਹ ਰੋਗ ਫਿੱਕਾ ਪੈ ਗਿਆ ਹੋਵੇ ਅਤੇ ਉਸ ਦੀ ਚਮੜੀ ਵਿੱਚ ਨਾ ਫੈਲਿਆ ਹੋਵੇ ਤਾਂ ਜਾਜਕ ਉਸ ਨੂੰ ਸ਼ੁੱਧ ਠਹਿਰਾਏ, ਉਹ ਤਾਂ ਸਿਰਫ਼ ਪਪੜੀ ਹੀ ਹੈ, ਅਤੇ ਉਹ ਆਪਣੇ ਕੱਪੜੇ ਧੋ ਕੇ ਸ਼ੁੱਧ ਹੋ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","ਪਰ ਜੇਕਰ ਜਾਜਕ ਦੁਆਰਾ ਉਸ ਨੂੰ ਵੇਖ ਕੇ ਸ਼ੁੱਧ ਠਹਿਰਾਉਣ ਤੋਂ ਬਾਅਦ ਉਹ ਪਪੜੀ ਉਸ ਦੀ ਚਮੜੀ ਵਿੱਚ ਬਹੁਤ ਫੈਲ ਜਾਵੇ, ਤਾਂ ਉਹ ਫੇਰ ਜਾਜਕ ਨੂੰ ਵਿਖਾਇਆ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","ਤਦ ਜਾਜਕ ਉਸ ਨੂੰ ਫੇਰ ਜਾਂਚੇ ਅਤੇ ਵੇਖੋ, ਜੇਕਰ ਉਹ ਪਪੜੀ ਚਮੜੀ ਵਿੱਚ ਫੈਲਦੀ ਜਾਂਦੀ ਹੈ ਤਾਂ ਜਾਜਕ ਉਸ ਨੂੰ ਅਸ਼ੁੱਧ ਠਹਿਰਾਵੇ ਕਿਉਂ ਜੋ ਇਹ ਕੋੜ੍ਹ ਹੀ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","ਜੇਕਰ ਕਿਸੇ ਮਨੁੱਖ ਨੂੰ ਕੋੜ੍ਹ ਦਾ ਰੋਗ ਹੋਵੇ ਤਾਂ ਉਹ ਜਾਜਕ ਦੇ ਕੋਲ ਲਿਆਂਦਾ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","ਅਤੇ ਜਾਜਕ ਉਸ ਨੂੰ ਜਾਂਚੇ ਅਤੇ ਵੇਖੋ, ਜੇਕਰ ਉਹ ਸੋਜ ਚਮੜੀ ਵਿੱਚ ਚਿੱਟੀ ਹੋਵੇ ਅਤੇ ਉਸ ਦੇ ਕਾਰਨ ਵਾਲ਼ ਵੀ ਚਿੱਟੇ ਹੋ ਗਏ ਹੋਣ ਅਤੇ ਜੇਕਰ ਉਸ ਸੋਜ ਵਿੱਚ ਕੱਚਾ ਮਾਸ ਵੀ ਹੋਵੇ, ");
INSERT INTO pan_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","ਤਾਂ ਜਾਜਕ ਜਾਣੇ ਕਿ ਉਸ ਦੀ ਚਮੜੀ ਵਿੱਚ ਪੁਰਾਣਾ ਕੋੜ੍ਹ ਹੈ, ਇਸ ਲਈ ਜਾਜਕ ਉਸ ਨੂੰ ਅਸ਼ੁੱਧ ਠਹਿਰਾਏ ਪਰ ਉਸ ਨੂੰ ਅਲੱਗ ਨਾ ਰੱਖੇ ਕਿਉਂ ਜੋ ਉਹ ਪਹਿਲਾਂ ਤੋਂ ਹੀ ਅਸ਼ੁੱਧ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","ਅਤੇ ਜੇਕਰ ਉਹ ਕੋੜ੍ਹ ਕਿਸੇ ਦੀ ਚਮੜੀ ਵਿੱਚ ਫੈਲ ਜਾਵੇ ਕਿ ਜਾਜਕ ਜਾਂਚੇ ਅਤੇ ਵੇਖੇ ਕਿ ਰੋਗੀ ਦੇ ਸਿਰ ਤੋਂ ਲੈ ਕੇ ਪੈਰਾਂ ਤੱਕ ਕੋੜ੍ਹ ਨੇ ਢੱਕ ਲਿਆ ਹੈ, ");
INSERT INTO pan_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","ਤਾਂ ਜਾਜਕ ਧਿਆਨ ਕਰੇ ਅਤੇ ਵੇਖੋ, ਜੇਕਰ ਕੋੜ੍ਹ ਨੇ ਉਸ ਦੇ ਸਾਰੇ ਸਰੀਰ ਨੂੰ ਢੱਕ ਲਿਆ ਹੋਵੇ ਤਾਂ ਜਾਜਕ ਉਸ ਮਨੁੱਖ ਨੂੰ ਜਿਸ ਨੂੰ ਰੋਗ ਹੈ ਸ਼ੁੱਧ ਠਹਿਰਾਵੇ, ਕਿਉਂ ਜੋ ਉਹ ਤਾਂ ਸਾਰਾ ਚਿੱਟਾ ਹੋ ਗਿਆ ਹੈ, ਇਸ ਲਈ ਉਹ ਸ਼ੁੱਧ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","ਪਰ ਜੇਕਰ ਉਸ ਦੇ ਵਿੱਚ ਕੱਚਾ ਮਾਸ ਵਿਖਾਈ ਦੇਵੇ ਤਾਂ ਉਹ ਅਸ਼ੁੱਧ ਠਹਿਰੇ। ");
INSERT INTO pan_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","ਅਤੇ ਜਾਜਕ ਕੱਚੇ ਮਾਸ ਨੂੰ ਵੇਖ ਕੇ ਉਸ ਨੂੰ ਅਸ਼ੁੱਧ ਠਹਿਰਾਵੇ ਕਿਉਂ ਜੋ ਅਜਿਹਾ ਕੱਚਾ ਮਾਸ ਅਸ਼ੁੱਧ ਹੁੰਦਾ ਹੈ, ਉਹ ਕੋੜ੍ਹ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","ਪਰ ਜੇਕਰ ਉਹ ਕੱਚਾ ਮਾਸ ਚਿੱਟਾ ਹੋ ਜਾਵੇ ਤਾਂ ਉਹ ਮਨੁੱਖ ਜਾਜਕ ਦੇ ਕੋਲ ਫੇਰ ਆਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","ਅਤੇ ਜਾਜਕ ਉਸ ਨੂੰ ਜਾਂਚੇ ਅਤੇ ਵੇਖੋ, ਜੇਕਰ ਉਹ ਰੋਗ ਚਿੱਟਾ ਹੋ ਗਿਆ ਹੋਵੇ ਤਾਂ ਜਾਜਕ ਉਸ ਮਨੁੱਖ ਨੂੰ ਜਿਸ ਨੂੰ ਰੋਗ ਹੈ ਸ਼ੁੱਧ ਠਹਿਰਾਵੇ, ਉਹ ਸ਼ੁੱਧ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","ਫੇਰ ਜੇਕਰ ਕਿਸੇ ਦੀ ਚਮੜੀ ਵਿੱਚ ਫੋੜਾ ਹੋ ਕੇ ਚੰਗਾ ਹੋ ਗਿਆ ਹੋਵੇ, ");
INSERT INTO pan_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","ਅਤੇ ਫੋੜੇ ਦੇ ਥਾਂ ਤੇ ਕੋਈ ਚਿੱਟੀ ਸੋਜ, ਜਾਂ ਚਿੱਟਾ-ਲਾਲ ਦਾਗ ਵਿਖਾਈ ਦੇਵੇ ਤਾਂ ਉਹ ਜਾਜਕ ਨੂੰ ਵਿਖਾਇਆ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","ਜਾਜਕ ਉਸ ਦੀ ਜਾਂਚ ਕਰੇ ਅਤੇ ਵੇਖੋ, ਜੇਕਰ ਉਹ ਸੋਜ ਵੇਖਣ ਵਿੱਚ ਚਮੜੀ ਨਾਲੋਂ ਡੂੰਘੀ ਹੋਵੇ ਅਤੇ ਉਸ ਸਥਾਨ ਦੇ ਵਾਲ਼ ਵੀ ਚਿੱਟੇ ਹੋ ਗਏ ਹੋਣ ਤਾਂ ਜਾਜਕ ਉਸ ਨੂੰ ਅਸ਼ੁੱਧ ਠਹਿਰਾਏ, ਕਿਉਂ ਜੋ ਇਹ ਫੋੜੇ ਵਿੱਚੋਂ ਨਿੱਕਲਿਆ ਹੋਇਆ ਕੋੜ੍ਹ ਦਾ ਰੋਗ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","ਪਰ ਜੇਕਰ ਜਾਜਕ ਉਸ ਨੂੰ ਜਾਂਚੇ ਅਤੇ ਵੇਖੇ, ਉਸ ਦੇ ਵਿੱਚ ਕੋਈ ਚਿੱਟੇ ਵਾਲ਼ ਨਹੀਂ ਹਨ ਅਤੇ ਉਹ ਚਮੜੀ ਨਾਲੋਂ ਡੂੰਘਾ ਨਾ ਹੋਵੇ ਪਰ ਕੁਝ ਫਿੱਕਾ ਪੈ ਗਿਆ ਹੋਵੇ, ਤਦ ਜਾਜਕ ਉਸ ਨੂੰ ਸੱਤ ਦਿਨ ਤੱਕ ਅਲੱਗ ਰੱਖੇ। ");
INSERT INTO pan_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","ਪਰ ਜੇਕਰ ਉਹ ਰੋਗ ਚਮੜੀ ਵਿੱਚ ਬਹੁਤ ਫੈਲ ਜਾਵੇ ਤਾਂ ਜਾਜਕ ਉਸ ਨੂੰ ਅਸ਼ੁੱਧ ਠਹਿਰਾਵੇ, ਇਹ ਕੋੜ੍ਹ ਦਾ ਰੋਗ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","ਪਰ ਜੇਕਰ ਉਹ ਦਾਗ ਨਾ ਫੈਲੇ ਅਤੇ ਉੱਥੇ ਹੀ ਰਹੇ ਤਾਂ ਉਹ ਫੋੜੇ ਦਾ ਦਾਗ ਹੈ ਅਤੇ ਜਾਜਕ ਉਸ ਨੂੰ ਸ਼ੁੱਧ ਠਹਿਰਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","ਫੇਰ ਜੇਕਰ ਕਿਸੇ ਦੀ ਚਮੜੀ ਵਿੱਚ ਜਲਣ ਦਾ ਦਾਗ ਹੋਵੇ ਅਤੇ ਉਸ ਜਲੇ ਹੋਏ ਜ਼ਖ਼ਮ ਵਿੱਚ ਚਿੱਟਾ ਜਾਂ ਕੁਝ ਲਾਲ-ਚਿੱਟਾ ਦਾਗ ਹੋਵੇ, ");
INSERT INTO pan_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","ਤਾਂ ਜਾਜਕ ਉਸ ਨੂੰ ਜਾਂਚੇ ਅਤੇ ਵੇਖੋ, ਜੇਕਰ ਉਸ ਦਾਗ ਦੇ ਸਥਾਨ ਦੇ ਵਾਲ਼ ਚਿੱਟੇ ਹੋ ਗਏ ਹੋਣ ਅਤੇ ਉਹ ਵੇਖਣ ਵਿੱਚ ਚਮੜੀ ਨਾਲੋਂ ਡੂੰਘਾ ਦਿਸੇ ਤਾਂ ਉਹ ਜਲਣ ਦੇ ਦਾਗ ਵਿੱਚੋਂ ਨਿੱਕਲਿਆ ਹੋਇਆ ਕੋੜ੍ਹ ਹੈ, ਜਾਜਕ ਉਸ ਨੂੰ ਅਸ਼ੁੱਧ ਠਹਿਰਾਵੇ, ਇਹ ਕੋੜ੍ਹ ਦਾ ਰੋਗ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","ਪਰ ਜੇਕਰ ਜਾਜਕ ਉਸ ਨੂੰ ਜਾਂਚੇ ਅਤੇ ਵੇਖੇ, ਜੇਕਰ ਉਸ ਦਾਗ ਵਿੱਚ ਕੋਈ ਚਿੱਟੇ ਵਾਲ਼ ਨਾ ਹੋਣ ਅਤੇ ਨਾ ਉਹ ਹੋਰ ਚਮੜੀ ਨਾਲੋਂ ਡੂੰਘਾ ਹੋਵੇ, ਸਗੋਂ ਕੁਝ ਫਿੱਕਾ ਪੈ ਗਿਆ ਹੋਵੇ ਤਾਂ ਜਾਜਕ ਉਸ ਨੂੰ ਸੱਤ ਦਿਨ ਤੱਕ ਅਲੱਗ ਰੱਖੇ, ");
INSERT INTO pan_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","ਅਤੇ ਸੱਤਵੇਂ ਦਿਨ ਜਾਜਕ ਉਸ ਨੂੰ ਵੇਖੇ ਅਤੇ ਜੇਕਰ ਉਹ ਚਮੜੀ ਵਿੱਚ ਬਹੁਤ ਫੈਲ ਗਿਆ ਹੋਵੇ ਤਾਂ ਜਾਜਕ ਉਸ ਨੂੰ ਅਸ਼ੁੱਧ ਠਹਿਰਾਵੇ, ਇਹ ਕੋੜ੍ਹ ਦਾ ਰੋਗ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","ਪਰ ਜੇਕਰ ਉਹ ਦਾਗ ਚਮੜੀ ਵਿੱਚ ਨਾ ਫੈਲੇ ਅਤੇ ਉਸੇ ਥਾਂ ਤੇ ਰਹੇ ਅਤੇ ਕੁਝ ਫਿੱਕਾ ਪੈ ਗਿਆ ਹੋਵੇ ਤਾਂ ਸੋਜ ਜਲਣ ਦੇ ਕਾਰਨ ਹੈ ਅਤੇ ਜਾਜਕ ਉਸ ਨੂੰ ਸ਼ੁੱਧ ਠਹਿਰਾਵੇ ਕਿਉਂ ਜੋ ਇਹ ਦਾਗ ਜਲਣ ਦੇ ਕਾਰਨ ਹੋ ਗਿਆ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","ਜੇਕਰ ਕਿਸੇ ਪੁਰਖ ਜਾਂ ਇਸਤਰੀ ਨੂੰ ਸਿਰ ਉੱਤੇ ਜਾਂ ਪੁਰਖ ਦੀ ਦਾੜ੍ਹੀ ਉੱਤੇ ਦਾਗ ਹੋਵੇ, ");
INSERT INTO pan_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","ਤਾਂ ਜਾਜਕ ਉਸ ਰੋਗ ਨੂੰ ਜਾਂਚੇ ਅਤੇ ਵੇਖੋ, ਜੇਕਰ ਉਹ ਚਮੜੀ ਨਾਲੋਂ ਡੂੰਘਾ ਦਿਸੇ ਅਤੇ ਉਸ ਦੇ ਵਿੱਚ ਇੱਕ ਪਤਲਾ ਪੀਲਾ ਵਾਲ਼ ਹੋਵੇ ਤਾਂ ਜਾਜਕ ਉਸ ਨੂੰ ਅਸ਼ੁੱਧ ਠਹਿਰਾਵੇ, ਉਹ ਇੱਕ ਦਾਦ ਹੈ ਅਰਥਾਤ ਸਿਰ ਜਾਂ ਦਾੜ੍ਹੀ ਉੱਤੇ ਕੋੜ੍ਹ ਦਾ ਰੋਗ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","ਪਰ ਜੇਕਰ ਜਾਜਕ ਦਾਦ ਦੇ ਰੋਗ ਨੂੰ ਜਾਂਚੇ ਅਤੇ ਵੇਖੋ, ਉਹ ਵੇਖਣ ਵਿੱਚ ਚਮੜੀ ਨਾਲੋਂ ਡੂੰਘਾ ਨਾ ਹੋਵੇ ਅਤੇ ਉਸ ਦੇ ਵਿੱਚ ਕਾਲੇ ਵਾਲ਼ ਨਾ ਹੋਣ ਤਾਂ ਜਾਜਕ ਉਸ ਮਨੁੱਖ ਨੂੰ ਜਿਸ ਨੂੰ ਦਾਦ ਦਾ ਰੋਗ ਹੈ, ਸੱਤ ਦਿਨ ਤੱਕ ਅਲੱਗ ਰੱਖੇ। ");
INSERT INTO pan_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","ਅਤੇ ਸੱਤਵੇਂ ਦਿਨ ਜਾਜਕ ਉਸ ਨੂੰ ਜਾਂਚੇ ਅਤੇ ਵੇਖੋ, ਜੇ ਉਹ ਦਾਦ ਫੈਲਿਆ ਨਾ ਹੋਵੇ ਅਤੇ ਉਸ ਦੇ ਵਿੱਚ ਕੋਈ ਪੀਲਾ ਵਾਲ਼ ਨਾ ਹੋਵੇ ਅਤੇ ਵੇਖਣ ਵਿੱਚ ਉਹ ਦਾਦ ਚਮੜੀ ਨਾਲੋਂ ਡੂੰਘਾ ਨਾ ਹੋਵੇ, ");
INSERT INTO pan_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","ਤਾਂ ਉਹ ਮਨੁੱਖ ਮੁੰਨਿਆ ਜਾਵੇ ਪਰ ਉਹ ਸਥਾਨ ਨਾ ਮੁੰਨਿਆ ਜਾਵੇ ਜਿੱਥੇ ਦਾਦ ਹੋਵੇ ਅਤੇ ਜਾਜਕ ਉਸ ਮਨੁੱਖ ਨੂੰ ਜਿਸ ਨੂੰ ਦਾਦ ਹੈ, ਹੋਰ ਸੱਤ ਦਿਨ ਨਿਗਰਾਨੀ ਵਿੱਚ ਰੱਖੇ। ");
INSERT INTO pan_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","ਸੱਤਵੇਂ ਦਿਨ ਜਾਜਕ ਉਸ ਦਾਦ ਨੂੰ ਫੇਰ ਜਾਂਚੇ ਅਤੇ ਵੇਖੋ, ਜੇਕਰ ਉਹ ਦਾਦ ਚਮੜੀ ਵਿੱਚ ਫੈਲਿਆ ਨਾ ਹੋਵੇ ਅਤੇ ਚਮੜੀ ਨਾਲੋਂ ਡੂੰਘਾ ਨਾ ਦਿਸੇ ਤਾਂ ਜਾਜਕ ਉਸ ਮਨੁੱਖ ਨੂੰ ਸ਼ੁੱਧ ਠਹਿਰਾਵੇ ਅਤੇ ਉਹ ਆਪਣੇ ਕੱਪੜੇ ਧੋ ਕੇ ਸ਼ੁੱਧ ਹੋ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","ਪਰ ਜੇਕਰ ਉਹ ਦਾਦ ਉਸ ਦੇ ਸ਼ੁੱਧ ਹੋਣ ਤੋਂ ਬਾਅਦ ਉਸ ਦੀ ਚਮੜੀ ਵਿੱਚ ਬਹੁਤ ਫੈਲ ਜਾਵੇ, ");
INSERT INTO pan_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","ਤਾਂ ਜਾਜਕ ਉਸ ਨੂੰ ਜਾਂਚੇ ਅਤੇ ਵੇਖੋ, ਜੇਕਰ ਉਹ ਦਾਦ ਚਮੜੀ ਵਿੱਚ ਫੈਲਿਆ ਹੋਇਆ ਹੋਵੇ ਤਾਂ ਜਾਜਕ ਉਸ ਪੀਲੇ ਵਾਲ਼ ਨੂੰ ਵੀ ਨਾ ਲੱਭੇ, ਉਹ ਮਨੁੱਖ ਅਸ਼ੁੱਧ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","ਪਰ ਜੇਕਰ ਉਸ ਦੇ ਵੇਖਣ ਵਿੱਚ ਉਹ ਦਾਦ ਉੱਥੇ ਹੀ ਰਹੇ ਅਤੇ ਉਸ ਦੇ ਵਿੱਚ ਕਾਲੇ ਵਾਲ਼ ਆ ਗਏ ਹੋਣ ਤਾਂ ਉਹ ਦਾਦ ਚੰਗਾ ਹੋ ਗਿਆ। ਉਹ ਮਨੁੱਖ ਸ਼ੁੱਧ ਹੈ ਅਤੇ ਜਾਜਕ ਉਸ ਨੂੰ ਸ਼ੁੱਧ ਠਹਿਰਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","ਜੇਕਰ ਕਿਸੇ ਪੁਰਖ ਜਾਂ ਇਸਤਰੀ ਦੀ ਚਮੜੀ ਵਿੱਚ ਚਿੱਟੇ ਦਾਗ ਹੋਣ, ");
INSERT INTO pan_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","ਤਾਂ ਜਾਜਕ ਉਨ੍ਹਾਂ ਨੂੰ ਜਾਂਚੇ ਅਤੇ ਵੇਖੋ, ਜੇਕਰ ਉਨ੍ਹਾਂ ਦੀ ਚਮੜੀ ਵਿੱਚ ਉਹ ਦਾਗ ਘੱਟ ਚਿੱਟੇ ਹੋਣ ਤਾਂ ਉਹ ਚਮੜੀ ਵਿੱਚ ਹੋਇਆ ਇੱਕ ਸਧਾਰਨ ਦਾਗ ਹੀ ਹੈ, ਉਹ ਮਨੁੱਖ ਸ਼ੁੱਧ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","ਜਿਸ ਮਨੁੱਖ ਦੇ ਵਾਲ਼ ਸਿਰ ਤੋਂ ਝੜ ਗਏ ਹੋਣ, ਉਹ ਮਨੁੱਖ ਗੰਜਾ ਤਾਂ ਹੈ, ਪਰ ਸ਼ੁੱਧ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","ਅਤੇ ਜਿਸ ਦੇ ਸਿਰ ਦੇ ਅਗਲੇ ਹਿੱਸੇ ਦੇ ਵਾਲ਼ ਝੜ ਗਏ ਹੋਣ, ਤਾਂ ਉਹ ਮਨੁੱਖ ਮੱਥੇ ਤੋਂ ਗੰਜਾ ਤਾਂ ਹੈ, ਫੇਰ ਵੀ ਉਹ ਸ਼ੁੱਧ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","ਪਰ ਜੇਕਰ ਉਸ ਦੇ ਗੰਜੇ ਸਿਰ ਜਾਂ ਗੰਜੇ ਮੱਥੇ ਵਿੱਚ ਇੱਕ ਚਿੱਟਾ-ਲਾਲ ਜਿਹਾ ਫੋੜਾ ਹੋਵੇ ਤਾਂ ਉਹ ਉਸ ਦੇ ਗੰਜੇ ਸਿਰ ਜਾਂ ਉਸ ਦੇ ਗੰਜੇ ਮੱਥੇ ਵਿੱਚ ਨਿੱਕਲਿਆ ਹੋਇਆ ਕੋੜ੍ਹ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","ਜਾਜਕ ਉਸ ਨੂੰ ਜਾਂਚੇ ਅਤੇ ਵੇਖੋ, ਜੇਕਰ ਉਸ ਫੋੜੇ ਦੀ ਸੋਜ ਉਸ ਦੇ ਗੰਜੇ ਸਿਰ ਜਾਂ ਉਸ ਦੇ ਗੰਜੇ ਮੱਥੇ ਵਿੱਚ ਕੁਝ ਚਿੱਟੀ-ਲਾਲ ਜਿਹੀ ਹੋਵੇ, ਜਿਵੇਂ ਸਰੀਰ ਦੀ ਚਮੜੀ ਦੇ ਕੋੜ੍ਹ ਵਿੱਚ ਹੁੰਦਾ ਹੈ, ");
INSERT INTO pan_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","ਤਾਂ ਉਹ ਮਨੁੱਖ ਕੋੜ੍ਹੀ ਹੈ ਅਤੇ ਅਸ਼ੁੱਧ ਹੈ, ਜਾਜਕ ਉਸ ਨੂੰ ਜ਼ਰੂਰ ਹੀ ਅਸ਼ੁੱਧ ਠਹਿਰਾਵੇ, ਕਿਉਂ ਜੋ ਉਸ ਦਾ ਰੋਗ ਉਸ ਦੇ ਸਿਰ ਵਿੱਚ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","ਉਹ ਮਨੁੱਖ ਜਿਸ ਨੂੰ ਕੋੜ੍ਹ ਦਾ ਰੋਗ ਹੋਵੇ, ਉਸ ਦੇ ਕੱਪੜੇ ਪਾੜੇ ਜਾਣ, ਉਸ ਦਾ ਸਿਰ ਨੰਗਾ ਹੋਵੇ ਅਤੇ ਉਹ ਆਪਣੇ ਉੱਪਰਲੇ ਬੁੱਲ੍ਹ ਨੂੰ ਢੱਕ ਕੇ “ਅਸ਼ੁੱਧ! ਅਸ਼ੁੱਧ!” ਪੁਕਾਰਿਆ ਕਰੇ। ");
INSERT INTO pan_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","ਜਿੰਨੇ ਦਿਨ ਤੱਕ ਉਹ ਰੋਗ ਉਸ ਦੇ ਸਰੀਰ ਵਿੱਚ ਰਹੇ, ਓਨ੍ਹੇ ਦਿਨ ਤੱਕ ਉਹ ਭਰਿਸ਼ਟ ਰਹੇ, ਅਸ਼ੁੱਧ ਰਹੇ ਅਤੇ ਉਹ ਇਕੱਲਾ ਵੱਸੇ, ਉਸ ਦਾ ਨਿਵਾਸ ਸਥਾਨ ਡੇਰੇ ਤੋਂ ਬਾਹਰ ਹੋਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","ਫੇਰ ਜਿਸ ਬਸਤਰ ਵਿੱਚ ਕੋੜ੍ਹ ਦਾ ਰੋਗ ਹੋਵੇ, ਭਾਵੇਂ ਉੱਨ ਦਾ ਹੋਵੇ, ਭਾਵੇਂ ਕਤਾਨ ਦਾ, ");
INSERT INTO pan_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","ਭਾਵੇਂ ਤਾਣੀ ਵਿੱਚ, ਭਾਵੇਂ ਉੱਣਨੀ ਵਿੱਚ, ਭਾਵੇਂ ਕਤਾਨ ਦਾ, ਭਾਵੇਂ ਉੱਨ ਦਾ, ਭਾਵੇਂ ਚਮੜੇ ਵਿੱਚ, ਭਾਵੇਂ ਚਮੜੇ ਦੀ ਬਣੀ ਹੋਈ ਕਿਸੇ ਵਸਤੂ ਵਿੱਚ ਹੋਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","ਜੇਕਰ ਉਹ ਰੋਗ ਕਿਸੇ ਕੱਪੜੇ ਵਿੱਚ, ਭਾਵੇਂ ਚਮੜੇ ਵਿੱਚ, ਭਾਵੇਂ ਤਾਣੀ ਵਿੱਚ, ਭਾਵੇਂ ਉੱਣਨੀ ਵਿੱਚ, ਭਾਵੇਂ ਚਮੜੇ ਦੀ ਬਣੀ ਹੋਈ ਕਿਸੇ ਵਸਤੂ ਵਿੱਚ ਕੁਝ ਹਰਾ ਜਾਂ ਲਾਲ ਜਿਹਾ ਹੋਵੇ, ਤਾਂ ਉਹ ਕੋੜ੍ਹ ਦਾ ਰੋਗ ਹੈ ਅਤੇ ਜਾਜਕ ਨੂੰ ਵਿਖਾਇਆ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","ਜਾਜਕ ਉਸ ਰੋਗ ਨੂੰ ਜਾਂਚੇ ਅਤੇ ਰੋਗ ਵਾਲੀ ਵਸਤੂ ਨੂੰ ਸੱਤ ਦਿਨ ਤੱਕ ਅਲੱਗ ਰੱਖੇ। ");
INSERT INTO pan_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","ਸੱਤਵੇਂ ਦਿਨ ਉਹ ਉਸ ਰੋਗ ਨੂੰ ਜਾਂਚੇ ਅਤੇ ਜੇਕਰ ਉਹ ਰੋਗ ਉਸ ਕੱਪੜੇ ਦੇ ਭਾਵੇਂ ਤਾਣੀ ਵਿੱਚ, ਭਾਵੇਂ ਉੱਣਨੀ ਵਿੱਚ, ਭਾਵੇਂ ਚਮੜੇ ਵਿੱਚ, ਜਾਂ ਚਮੜੇ ਦੀ ਬਣੀ ਹੋਈ ਕਿਸੇ ਵਸਤੂ ਵਿੱਚ ਫੈਲਿਆ ਹੋਇਆ ਹੋਵੇ, ਤਾਂ ਉਹ ਰੋਗ ਇੱਕ ਫੈਲਣ ਵਾਲਾ ਕੋੜ੍ਹ ਹੈ, ਇਸ ਲਈ ਉਹ ਵਸਤੂ ਅਸ਼ੁੱਧ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","ਉਹ ਉਸ ਕੱਪੜੇ ਨੂੰ, ਭਾਵੇਂ ਤਾਣੀ, ਭਾਵੇਂ ਉੱਣਨੀ, ਭਾਵੇਂ ਉੱਨ ਦਾ ਜਾਂ ਕਤਾਨ ਦਾ, ਜਾਂ ਚਮੜੇ ਦੀ ਕੋਈ ਵਸਤੂ ਹੋਵੇ ਜਿਸ ਦੇ ਵਿੱਚ ਰੋਗ ਹੈ, ਸਾੜ ਦੇਵੇ ਕਿਉਂ ਜੋ ਉਹ ਫੈਲਣ ਵਾਲਾ ਕੋੜ੍ਹ ਹੈ, ਉਹ ਅੱਗ ਵਿੱਚ ਸਾੜਿਆ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","ਜੇਕਰ ਜਾਜਕ ਜਾਂਚੇ ਅਤੇ ਵੇਖੇ ਕਿ ਉਹ ਰੋਗ ਉਸ ਕੱਪੜੇ ਵਿੱਚ, ਨਾ ਤਾਣੀ, ਨਾ ਉੱਣਨੀ, ਨਾ ਚਮੜੇ ਦੀ ਕਿਸੇ ਵਸਤੂ ਵਿੱਚ ਫੈਲਿਆ ਨਹੀਂ ਹੈ, ");
INSERT INTO pan_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","ਤਾਂ ਜਾਜਕ ਆਗਿਆ ਦੇਵੇ ਕਿ ਉਸ ਵਸਤੂ ਨੂੰ ਜਿਸ ਦੇ ਵਿੱਚ ਰੋਗ ਹੈ, ਧੋਇਆ ਜਾਵੇ ਅਤੇ ਉਹ ਉਸ ਨੂੰ ਹੋਰ ਸੱਤ ਦਿਨ ਤੱਕ ਅਲੱਗ ਰੱਖੇ। ");
INSERT INTO pan_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","ਅਤੇ ਉਸ ਨੂੰ ਧੋਣ ਤੋਂ ਬਾਅਦ ਜਾਜਕ ਉਸ ਨੂੰ ਜਾਂਚੇ ਅਤੇ ਜੇਕਰ ਰੋਗ ਦਾ ਰੰਗ ਨਾ ਬਦਲਿਆ ਹੋਇਆ ਅਤੇ ਨਾ ਹੀ ਰੋਗ ਫੈਲਿਆ ਹੋਵੇ, ਤਾਂ ਉਹ ਅਸ਼ੁੱਧ ਹੈ। ਤੂੰ ਉਸ ਨੂੰ ਅੱਗ ਵਿੱਚ ਸਾੜੀਂ, ਕਿਉਂ ਜੋ ਭਾਵੇਂ ਉਹ ਰੋਗ ਅੰਦਰੂਨੀ ਭਾਵੇਂ ਬਾਹਰੀ ਹੋਵੇ ਤਾਂ ਵੀ ਉਹ ਫੈਲਣ ਵਾਲਾ ਰੋਗ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","ਪਰ ਜੇਕਰ ਜਾਜਕ ਵੇਖੇ ਅਤੇ ਵੇਖੋ, ਉਸ ਨੂੰ ਧੋਣ ਤੋਂ ਬਾਅਦ ਉਹ ਰੋਗ ਕੁਝ ਫਿੱਕਾ ਪੈ ਗਿਆ ਹੋਵੇ ਤਾਂ ਉਹ ਉਸ ਕੱਪੜੇ ਵਿੱਚੋਂ, ਭਾਵੇਂ ਤਾਣੀ ਭਾਵੇਂ ਉੱਣਨੀ ਵਿੱਚੋਂ, ਜਾਂ ਚਮੜੀ ਵਿੱਚੋਂ ਪਾੜ ਕੇ ਉਸ ਨੂੰ ਕੱਢੇ, ");
INSERT INTO pan_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","ਅਤੇ ਜੇਕਰ ਉਹ ਰੋਗ ਫੇਰ ਵੀ ਉਸ ਕੱਪੜੇ ਦੀ ਤਾਣੀ ਵਿੱਚ ਜਾਂ ਉੱਣਨੀ ਵਿੱਚ, ਜਾਂ ਚਮੜੇ ਦੀ ਉਸ ਵਸਤੂ ਵਿੱਚ ਵਿਖਾਈ ਦੇਵੇ ਤਾਂ ਉਹ ਵਧਣ ਵਾਲਾ ਰੋਗ ਹੈ, ਤੂੰ ਉਸ ਵਸਤੂ ਨੂੰ ਜਿਸ ਦੇ ਵਿੱਚ ਰੋਗ ਹੋਵੇ, ਅੱਗ ਵਿੱਚ ਸਾੜ ਦੇਵੀਂ। ");
INSERT INTO pan_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","ਜੇਕਰ ਉਹ ਕੱਪੜਾ ਜਿਸ ਦੀ ਤਾਣੀ ਜਾਂ ਉੱਣਨੀ ਵਿੱਚ ਕੋਈ ਰੋਗ ਹੋਵੇ ਜਾਂ ਚਮੜੇ ਦੀ ਕੋਈ ਵਸਤੂ ਹੋਵੇ, ਜਦ ਉਹ ਧੋਤੀ ਜਾਵੇ ਅਤੇ ਰੋਗ ਉਸ ਵਿੱਚੋਂ ਹੱਟ ਜਾਵੇ ਤਾਂ ਉਹ ਦੂਜੀ ਵਾਰ ਧੋਤੀ ਜਾਵੇ ਅਤੇ ਉਹ ਸ਼ੁੱਧ ਹੋ ਜਾਵੇਗੀ। ");
INSERT INTO pan_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","ਕਿਸੇ ਕੱਪੜੇ ਵਿੱਚ, ਭਾਵੇਂ ਉੱਨ ਦਾ, ਭਾਵੇਂ ਕਤਾਨ ਦਾ, ਭਾਵੇਂ ਤਾਣੀ ਵਿੱਚ, ਭਾਵੇਂ ਉੱਣਨੀ ਵਿੱਚ, ਭਾਵੇਂ ਚਮੜੇ ਦੀ ਕਿਸੇ ਵਸਤੂ ਵਿੱਚ ਕੋੜ੍ਹ ਦਾ ਰੋਗ ਹੋਵੇ, ਤਾਂ ਉਸ ਨੂੰ ਸ਼ੁੱਧ ਅਤੇ ਅਸ਼ੁੱਧ ਠਹਿਰਾਉਣ ਦੀ ਇਹੋ ਬਿਵਸਥਾ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","ਫੇਰ ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਆਖਿਆ, ");
INSERT INTO pan_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","ਕੋੜ੍ਹੀ ਦੇ ਸ਼ੁੱਧ ਹੋਣ ਦੇ ਦਿਨ ਦੀ ਬਿਵਸਥਾ ਇਹ ਹੈ: ਉਹ ਜਾਜਕ ਕੋਲ ਲਿਆਇਆ ਜਾਵੇ ");
INSERT INTO pan_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","ਅਤੇ ਜਾਜਕ ਡੇਰੇ ਤੋਂ ਬਾਹਰ ਨਿੱਕਲੇ ਅਤੇ ਉਸ ਕੋੜ੍ਹੀ ਨੂੰ ਵੇਖੇ ਅਤੇ ਜੇਕਰ ਉਸ ਦੇ ਕੋੜ੍ਹ ਦਾ ਰੋਗ ਚੰਗਾ ਹੋ ਗਿਆ ਹੋਵੇ, ");
INSERT INTO pan_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","ਤਦ ਜਾਜਕ ਉਸ ਨੂੰ ਜੋ ਚੰਗਾ ਹੋ ਗਿਆ ਹੈ ਆਗਿਆ ਦੇਵੇ ਕਿ ਉਹ ਦੋ ਜੀਉਂਦੇ ਅਤੇ ਸ਼ੁੱਧ ਪੰਛੀ, ਦਿਆਰ ਦੀ ਲੱਕੜ, ਕਿਰਮਚੀ ਕੱਪੜਾ ਅਤੇ ਜੂਫ਼ਾ ਲਿਆਵੇ, ");
INSERT INTO pan_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","ਅਤੇ ਜਾਜਕ ਇੱਕ ਪੰਛੀ ਨੂੰ ਵਗਦੇ ਪਾਣੀ ਦੇ ਉੱਤੇ ਕਿਸੇ ਮਿੱਟੀ ਦੇ ਭਾਂਡੇ ਵਿੱਚ ਵੱਢਣ ਦੀ ਆਗਿਆ ਦੇਵੇ, ");
INSERT INTO pan_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","ਅਤੇ ਉਹ ਜੀਉਂਦੇ ਪੰਛੀ, ਦਿਆਰ ਦੀ ਲੱਕੜ, ਕਿਰਮਚੀ ਕੱਪੜਾ ਅਤੇ ਜੂਫ਼ਾ ਇਨ੍ਹਾਂ ਸਾਰਿਆਂ ਨੂੰ ਲੈ ਕੇ ਇਕੱਠੇ ਉਸ ਪੰਛੀ ਦੇ ਲਹੂ ਵਿੱਚ ਡੋਬ ਦੇਵੇ, ਜੋ ਵੱਗਦੇ ਪਾਣੀ ਉੱਤੇ ਵੱਢਿਆ ਗਿਆ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","ਅਤੇ ਉਹ ਉਸ ਦੇ ਉੱਤੇ ਜੋ ਕੋੜ੍ਹ ਤੋਂ ਸ਼ੁੱਧ ਹੋਣ ਵਾਲਾ ਹੈ, ਸੱਤ ਵਾਰ ਛਿੜਕੇ ਅਤੇ ਉਸ ਨੂੰ ਸ਼ੁੱਧ ਠਹਿਰਾਵੇ ਅਤੇ ਜੀਉਂਦੇ ਪੰਛੀ ਨੂੰ ਖੁੱਲ੍ਹੇ ਮੈਦਾਨ ਵਿੱਚ ਉਡਾ ਦੇਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","ਅਤੇ ਸ਼ੁੱਧ ਹੋਣ ਵਾਲਾ ਆਪਣੇ ਕੱਪੜਿਆਂ ਨੂੰ ਧੋਵੇ ਅਤੇ ਆਪਣਾ ਸਿਰ ਮੁਨਾ ਦੇਵੇ ਅਤੇ ਪਾਣੀ ਨਾਲ ਨਹਾਵੇ ਤਦ ਉਹ ਸ਼ੁੱਧ ਹੋਵੇਗਾ, ਇਸ ਤੋਂ ਬਾਅਦ ਉਹ ਡੇਰੇ ਵਿੱਚ ਆਵੇ ਪਰ ਸੱਤ ਦਿਨ ਤੱਕ ਆਪਣੇ ਡੇਰੇ ਤੋਂ ਬਾਹਰ ਹੀ ਵਾਸ ਕਰੇ। ");
INSERT INTO pan_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","ਪਰ ਸੱਤਵੇਂ ਦਿਨ ਉਹ ਆਪਣੇ ਸਿਰ, ਆਪਣੀ ਦਾੜ੍ਹੀ ਅਤੇ ਆਪਣੇ ਭਰਵੱਟਿਆਂ ਦੇ ਵਾਲ਼ ਮੁਨਾ ਦੇਵੇ, ਸਗੋਂ ਆਪਣੇ ਸਾਰੇ ਵਾਲ਼ ਮੁਨਾ ਦੇਵੇ ਅਤੇ ਉਹ ਆਪਣੇ ਕੱਪੜੇ ਧੋਵੇ ਅਤੇ ਪਾਣੀ ਨਾਲ ਨਹਾਵੇ ਤਦ ਉਹ ਸ਼ੁੱਧ ਹੋ ਜਾਵੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","ਅੱਠਵੇਂ ਦਿਨ ਉਹ ਦੋਸ਼ ਰਹਿਤ ਦੋ ਲੇਲੇ ਅਤੇ ਇੱਕ ਸਾਲ ਦੀ ਦੋਸ਼ ਰਹਿਤ ਲੇਲੀ ਅਤੇ ਮੈਦੇ ਦੀ ਭੇਟ ਲਈ ਤੇਲ ਨਾਲ ਰਲਾਏ ਹੋਏ ਏਫ਼ਾਹ ਦਾ ਤਿੰਨ ਤਿਹਾਈ ਹਿੱਸਾ ਮੈਦਾ ਅਤੇ ਇੱਕ ਕੁੱਪੀ ਤੇਲ ਲਿਆਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","ਤਦ ਉਹ ਜਾਜਕ ਜੋ ਸ਼ੁੱਧ ਕਰਨ ਦੀ ਬਿਧੀ ਨੂੰ ਕਰਦਾ ਹੈ, ਉਸ ਸ਼ੁੱਧ ਹੋਣ ਵਾਲੇ ਮਨੁੱਖ ਨੂੰ ਇਨ੍ਹਾਂ ਵਸਤੂਆਂ ਸਮੇਤ ਮੰਡਲੀ ਦੇ ਡੇਰੇ ਦੇ ਦਰਵਾਜ਼ੇ ਦੇ ਕੋਲ ਯਹੋਵਾਹ ਦੇ ਸਾਹਮਣੇ ਖੜ੍ਹਾ ਕਰੇ। ");
INSERT INTO pan_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","ਤਦ ਜਾਜਕ ਇੱਕ ਲੇਲਾ ਲੈ ਕੇ ਦੋਸ਼ ਬਲੀ ਦੀ ਭੇਟ ਕਰਕੇ ਉਸ ਨੂੰ ਚੜ੍ਹਾਵੇ ਅਤੇ ਉਸ ਕੁੱਪੀ ਤੇਲ ਨੂੰ ਲੈ ਕੇ ਉਨ੍ਹਾਂ ਨੂੰ ਹਿਲਾਉਣ ਦੀ ਭੇਟ ਕਰਕੇ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਹਿਲਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","ਉਹ ਉਸ ਲੇਲੇ ਨੂੰ ਉਸੇ ਸਥਾਨ ਵਿੱਚ ਵੱਢੇ ਜਿੱਥੇ ਉਹ ਪਾਪ ਬਲੀ ਅਤੇ ਹੋਮ ਬਲੀ ਪਸ਼ੂਆਂ ਨੂੰ ਵੱਢਦੇ ਹਨ ਅਰਥਾਤ ਪਵਿੱਤਰ ਸਥਾਨ ਵਿੱਚ ਕਿਉਂਕਿ ਜਿਵੇਂ ਪਾਪ ਬਲੀ ਦੀ ਭੇਟ ਜਾਜਕ ਦੀ ਹੈ, ਉਸੇ ਤਰ੍ਹਾਂ ਹੀ ਦੋਸ਼ ਬਲੀ ਦੀ ਭੇਟ ਵੀ ਉਸੇ ਦੀ ਹੈ, ਉਹ ਅੱਤ ਪਵਿੱਤਰ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","ਜਾਜਕ ਦੋਸ਼ ਬਲੀ ਦੀ ਭੇਟ ਦੇ ਲਹੂ ਤੋਂ ਕੁਝ ਲਵੇ ਅਤੇ ਜੋ ਸ਼ੁੱਧ ਹੋਣ ਵਾਲਾ ਹੈ ਉਸ ਦੇ ਸੱਜੇ ਕੰਨ ਦੇ ਸਿਰੇ ਅਤੇ ਉਸ ਦੇ ਸੱਜੇ ਹੱਥ ਅਤੇ ਸੱਜੇ ਪੈਰ ਦੇ ਅੰਗੂਠਿਆਂ ਉੱਤੇ ਲਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","ਫੇਰ ਜਾਜਕ ਉਸ ਪਾਉ ਤੇਲ ਵਿੱਚੋਂ ਕੁਝ ਲੈ ਕੇ ਆਪਣੇ ਖੱਬੇ ਹੱਥ ਦੀ ਤਲੀ ਉੱਤੇ ਪਾਵੇ, ");
INSERT INTO pan_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","ਅਤੇ ਜਾਜਕ ਆਪਣੀ ਸੱਜੇ ਹੱਥ ਦੀ ਉਂਗਲ ਨੂੰ ਆਪਣੇ ਖੱਬੇ ਹੱਥ ਦੀ ਤਲੀ ਦੇ ਤੇਲ ਵਿੱਚ ਡੋਬ ਕੇ ਉਸ ਤੇਲ ਵਿੱਚੋਂ ਕੁਝ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਸੱਤ ਵਾਰੀ ਛਿੜਕੇ, ");
INSERT INTO pan_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","ਅਤੇ ਬਾਕੀ ਤੇਲ ਜੋ ਉਸ ਦੇ ਹੱਥ ਵਿੱਚ ਹੈ, ਜਾਜਕ ਉਸ ਵਿੱਚੋਂ ਕੁਝ ਲੈ ਕੇ ਸ਼ੁੱਧ ਹੋਣ ਵਾਲੇ ਦੇ ਸੱਜੇ ਕੰਨ ਦੇ ਸਿਰੇ ਉੱਤੇ ਅਤੇ ਉਸ ਦੇ ਸੱਜੇ ਹੱਥ ਅਤੇ ਸੱਜੇ ਪੈਰ ਦੇ ਅੰਗੂਠਿਆਂ ਉੱਤੇ ਦੋਸ਼ ਬਲੀ ਦੀ ਭੇਟ ਦੇ ਲਹੂ ਉੱਤੇ ਲਗਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","ਅਤੇ ਜੋ ਤੇਲ ਜਾਜਕ ਦੇ ਹੱਥ ਵਿੱਚ ਬਚ ਜਾਵੇ ਉਸ ਨੂੰ ਉਹ ਸ਼ੁੱਧ ਹੋਣ ਵਾਲੇ ਦੇ ਸਿਰ ਉੱਤੇ ਡੋਲ੍ਹ ਦੇਵੇ ਅਤੇ ਜਾਜਕ ਉਸ ਦੇ ਲਈ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਪ੍ਰਾਸਚਿਤ ਕਰੇ। ");
INSERT INTO pan_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","ਜਾਜਕ ਪਾਪ ਬਲੀ ਦੀ ਭੇਟ ਚੜ੍ਹਾਵੇ ਅਤੇ ਉਸ ਦੇ ਲਈ ਜੋ ਆਪਣੀ ਅਸ਼ੁੱਧਤਾ ਤੋਂ ਸ਼ੁੱਧ ਹੋਣ ਵਾਲਾ ਹੈ ਪ੍ਰਾਸਚਿਤ ਕਰੇ ਅਤੇ ਇਸ ਤੋਂ ਬਾਅਦ ਹੋਮ ਬਲੀ ਦੀ ਭੇਟ ਨੂੰ ਵੱਢ ਦੇਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","ਤਦ ਜਾਜਕ ਹੋਮ ਬਲੀ ਦੀ ਭੇਟ ਅਤੇ ਮੈਦੇ ਦੀ ਭੇਟ ਜਗਵੇਦੀ ਉੱਤੇ ਚੜ੍ਹਾਵੇ ਅਤੇ ਜਾਜਕ ਉਸ ਦੇ ਲਈ ਪ੍ਰਾਸਚਿਤ ਕਰੇ ਤਾਂ ਉਹ ਸ਼ੁੱਧ ਹੋ ਜਾਵੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","ਜੇਕਰ ਉਹ ਕੰਗਾਲ ਹੋਵੇ ਅਤੇ ਇਨ੍ਹਾਂ ਸਭਨਾਂ ਵਿੱਚੋਂ ਕੁਝ ਨਾ ਲਿਆ ਸਕੇ ਤਾਂ ਉਹ ਆਪਣੇ ਲਈ ਪ੍ਰਾਸਚਿਤ ਕਰਨ ਲਈ ਦੋਸ਼ ਬਲੀ ਦੇ ਲਈ ਇੱਕ ਲੇਲਾ ਹਿਲਾਉਣ ਦੀ ਭੇਟ ਕਰਕੇ, ਅਤੇ ਤੇਲ ਰਲਿਆ ਹੋਇਆ ਏਫ਼ਾਹ ਦਾ ਦਸਵਾਂ ਹਿੱਸਾ ਮੈਦਾ, ਮੈਦੇ ਦੀ ਭੇਟ ਲਈ ਅਤੇ ਇੱਕ ਪਾਉ ਤੇਲ ਲਿਆਵੇ, ");
INSERT INTO pan_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","ਅਤੇ ਘੁੱਗੀਆਂ ਜਾਂ ਕਬੂਤਰਾਂ ਦੇ ਦੋ ਬੱਚੇ ਲਿਆਵੇ ਜੋ ਉਹ ਲਿਆ ਸਕਦਾ ਹੈ, ਇਨ੍ਹਾਂ ਵਿੱਚੋਂ ਇੱਕ ਤਾਂ ਪਾਪ ਬਲੀ ਦੀ ਭੇਟ ਲਈ ਅਤੇ ਦੂਜਾ ਹੋਮ ਬਲੀ ਦੀ ਭੇਟ ਲਈ ਹੋਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","ਅੱਠਵੇਂ ਦਿਨ ਉਹ ਇਨ੍ਹਾਂ ਸਾਰਿਆਂ ਨੂੰ ਆਪਣੇ ਸ਼ੁੱਧ ਕਰਨ ਲਈ ਮੰਡਲੀ ਦੇ ਡੇਰੇ ਦੇ ਦਰਵਾਜ਼ੇ ਉੱਤੇ ਯਹੋਵਾਹ ਦੇ ਸਨਮੁਖ ਜਾਜਕ ਦੇ ਕੋਲ ਲਿਆਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","ਤਦ ਜਾਜਕ ਦੋਸ਼ ਬਲੀ ਦੀ ਭੇਟ ਦੇ ਲੇਲੇ ਨੂੰ ਅਤੇ ਪਾਉ ਤੇਲ ਨੂੰ ਲੈ ਕੇ ਹਿਲਾਉਣ ਦੀ ਭੇਟ ਕਰਕੇ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਹਿਲਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","ਫੇਰ ਉਹ ਦੋਸ਼ ਬਲੀ ਦੀ ਭੇਟ ਦੇ ਲੇਲੇ ਨੂੰ ਵੱਢ ਦੇਵੇ ਅਤੇ ਜਾਜਕ ਉਸ ਵਿੱਚੋਂ ਕੁਝ ਲੈ ਕੇ ਸ਼ੁੱਧ ਹੋਣ ਵਾਲੇ ਦੇ ਸੱਜੇ ਕੰਨ ਦੇ ਸਿਰੇ ਉੱਤੇ ਅਤੇ ਉਸ ਦੇ ਸੱਜੇ ਹੱਥ ਅਤੇ ਸੱਜੇ ਪੈਰ ਦੇ ਅੰਗੂਠਿਆਂ ਉੱਤੇ ਲਗਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","ਫੇਰ ਜਾਜਕ ਉਸ ਵਿੱਚੋਂ ਕੁਝ ਤੇਲ ਲੈ ਕੇ ਆਪਣੇ ਖੱਬੇ ਹੱਥ ਦੀ ਤਲੀ ਉੱਤੇ ਪਾਵੇ, ");
INSERT INTO pan_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","ਅਤੇ ਜਾਜਕ ਆਪਣੇ ਸੱਜੇ ਹੱਥ ਦੀ ਉਂਗਲ ਨਾਲ ਆਪਣੇ ਖੱਬੇ ਹੱਥ ਦੀ ਤਲੀ ਵਿੱਚੋਂ ਕੁਝ ਤੇਲ ਲੈ ਕੇ ਸੱਤ ਵਾਰੀ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਛਿੜਕੇ। ");
INSERT INTO pan_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","ਫੇਰ ਜਾਜਕ ਆਪਣੇ ਹੱਥ ਦੇ ਤੇਲ ਵਿੱਚੋਂ ਕੁਝ ਲੈ ਕੇ ਸ਼ੁੱਧ ਹੋਣ ਵਾਲੇ ਦੇ ਸੱਜੇ ਕੰਨ ਦੇ ਸਿਰੇ ਉੱਤੇ ਅਤੇ ਉਸ ਦੇ ਸੱਜੇ ਹੱਥ ਅਤੇ ਸੱਜੇ ਪੈਰ ਦੇ ਅੰਗੂਠਿਆਂ ਉੱਤੇ ਦੋਸ਼ ਬਲੀ ਦੀ ਭੇਟ ਦੇ ਲਹੂ ਦੇ ਉੱਤੇ ਲਗਾਵੇ, ");
INSERT INTO pan_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","ਅਤੇ ਬਾਕੀ ਤੇਲ ਜੋ ਜਾਜਕ ਦੇ ਹੱਥ ਵਿੱਚ ਰਹਿ ਜਾਵੇ ਉਸ ਨੂੰ ਉਹ ਸ਼ੁੱਧ ਹੋਣ ਵਾਲੇ ਦੇ ਲਈ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਪ੍ਰਾਸਚਿਤ ਕਰਨ ਲਈ ਉਸ ਦੇ ਸਿਰ ਉੱਤੇ ਪਾ ਦੇਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","ਤਦ ਉਹ ਉਨ੍ਹਾਂ ਘੁੱਗੀਆਂ ਜਾਂ ਕਬੂਤਰਾਂ ਦੇ ਬੱਚਿਆਂ ਵਿੱਚੋਂ ਜੋ ਉਹ ਲਿਆ ਸਕਿਆ, ਇੱਕ ਨੂੰ ਚੜ੍ਹਾਵੇ, ");
INSERT INTO pan_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","ਅਰਥਾਤ ਜੋ ਪੰਛੀ ਉਹ ਲਿਆ ਸਕਿਆ ਉਨ੍ਹਾਂ ਵਿੱਚੋਂ ਉਹ ਇੱਕ ਨੂੰ ਪਾਪ ਬਲੀ ਦੀ ਭੇਟ ਲਈ ਅਤੇ ਦੂਜੇ ਨੂੰ ਮੈਦੇ ਦੀ ਭੇਟ ਸਮੇਤ ਹੋਮ ਬਲੀ ਦੀ ਭੇਟ ਕਰਕੇ ਚੜ੍ਹਾਵੇ, ਇਸ ਤਰ੍ਹਾਂ ਜਾਜਕ ਸ਼ੁੱਧ ਹੋਣ ਵਾਲੇ ਦੇ ਲਈ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਪ੍ਰਾਸਚਿਤ ਕਰੇ। ");
INSERT INTO pan_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","ਜਿਸ ਨੂੰ ਕੋੜ੍ਹ ਦਾ ਰੋਗ ਹੋਇਆ ਹੋਵੇ ਅਤੇ ਉਹ ਇਸ ਯੋਗ ਨਾ ਹੋਵੇ ਕਿ ਉਹ ਸ਼ੁੱਧਤਾਈ ਦੀਆਂ ਵਸਤੂਆਂ ਨੂੰ ਲਿਆ ਸਕੇ, ਉਸ ਦੇ ਲਈ ਇਹੋ ਬਿਵਸਥਾ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","ਫੇਰ ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਅਤੇ ਹਾਰੂਨ ਨੂੰ ਆਖਿਆ, ");
INSERT INTO pan_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","ਜਦ ਤੁਸੀਂ ਕਨਾਨ ਦੇਸ ਵਿੱਚ ਪਹੁੰਚ ਜਾਓ ਜਿਹੜਾ ਮੈਂ ਤੁਹਾਨੂੰ ਵਿਰਾਸਤ ਵਿੱਚ ਦਿੰਦਾ ਹਾਂ, ਤਾਂ ਜੇਕਰ ਮੈਂ ਉਸ ਦੇਸ ਦੇ ਕਿਸੇ ਘਰ ਵਿੱਚ ਕੋੜ੍ਹ ਦਾ ਰੋਗ ਪਾ ਦੇਵਾਂ, ");
INSERT INTO pan_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","ਤਾਂ ਉਸ ਘਰ ਦਾ ਮਾਲਕ ਜਾਜਕ ਦੇ ਕੋਲ ਆ ਕੇ ਆਖੇ, ਮੈਨੂੰ ਅਜਿਹਾ ਪਰਤੀਤ ਹੁੰਦਾ ਹੈ ਕਿ ਘਰ ਵਿੱਚ ਕੋਈ ਰੋਗ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","ਤਦ ਜਾਜਕ ਉਸ ਘਰ ਨੂੰ ਜਾਂਚਣ ਲਈ ਜਾਣ ਤੋਂ ਪਹਿਲਾਂ ਹੁਕਮ ਦੇਵੇ ਕਿ ਉਸ ਘਰ ਨੂੰ ਖਾਲੀ ਕੀਤਾ ਜਾਵੇ, ਅਜਿਹਾ ਨਾ ਹੋਵੇ ਕਿ ਜੋ ਕੁਝ ਘਰ ਦੇ ਵਿੱਚ ਹੈ ਅਸ਼ੁੱਧ ਹੋ ਜਾਵੇ। ਇਸ ਤੋਂ ਬਾਅਦ ਜਾਜਕ ਘਰ ਨੂੰ ਜਾਂਚਣ ਲਈ ਅੰਦਰ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","ਤਦ ਉਹ ਉਸ ਰੋਗ ਨੂੰ ਜਾਂਚੇ ਅਤੇ ਵੇਖੋ, ਜੇਕਰ ਉਹ ਰੋਗ ਘਰ ਦੀਆਂ ਕੰਧਾਂ ਉੱਤੇ ਹਰੀਆਂ ਜਾਂ ਲਾਲ ਖੋਖਲੀਆਂ ਲਕੀਰਾਂ ਵਰਗੀਆਂ ਹੋਣ ਅਤੇ ਕੰਧ ਨਾਲੋਂ ਡੂੰਘੀਆਂ ਵਿਖਾਈ ਦੇਣ, ");
INSERT INTO pan_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","ਤਾਂ ਜਾਜਕ ਘਰ ਦੇ ਦਰਵਾਜ਼ੇ ਤੋਂ ਬਾਹਰ ਨਿੱਕਲ ਕੇ ਘਰ ਨੂੰ ਸੱਤ ਦਿਨ ਤੱਕ ਬੰਦ ਕਰ ਦੇਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","ਅਤੇ ਸੱਤਵੇਂ ਦਿਨ ਜਾਜਕ ਫੇਰ ਆਵੇ ਅਤੇ ਵੇਖੇ, ਜੇਕਰ ਉਹ ਰੋਗ ਘਰ ਦੀਆਂ ਕੰਧਾਂ ਉੱਤੇ ਫੈਲ ਗਿਆ ਹੋਵੇ, ");
INSERT INTO pan_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","ਤਾਂ ਜਾਜਕ ਹੁਕਮ ਦੇਵੇ ਕਿ ਉਹ ਉਨ੍ਹਾਂ ਪੱਥਰਾਂ ਨੂੰ ਜਿਨ੍ਹਾਂ ਦੇ ਵਿੱਚ ਰੋਗ ਹੈ, ਕੱਢ ਕੇ ਲੈ ਜਾਣ ਅਤੇ ਸ਼ਹਿਰ ਤੋਂ ਬਾਹਰ ਕਿਸੇ ਅਸ਼ੁੱਧ ਸਥਾਨ ਵਿੱਚ ਸੁੱਟ ਦੇਣ। ");
INSERT INTO pan_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","ਉਹ ਉਸ ਘਰ ਨੂੰ ਅੰਦਰੋਂ ਚੁਫ਼ੇਰਿਓਂ ਛਿਲਵਾ ਦੇਵੇ ਅਤੇ ਉਹ ਉਸ ਮਿੱਟੀ ਨੂੰ ਜੋ ਛਿੱਲੀ ਗਈ ਹੈ, ਸ਼ਹਿਰ ਤੋਂ ਬਾਹਰ ਕਿਸੇ ਅਸ਼ੁੱਧ ਸਥਾਨ ਵਿੱਚ ਸੁੱਟ ਦੇਣ। ");
INSERT INTO pan_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","ਉਹ ਦੂਜੇ ਪੱਥਰ ਲੈ ਕੇ ਉਨ੍ਹਾਂ ਨੂੰ ਪੁਰਾਣੇ ਪੱਥਰਾਂ ਦੇ ਸਥਾਨ ਉੱਤੇ ਲਗਾ ਦੇਣ ਅਤੇ ਜਾਜਕ ਹੋਰ ਚੂਨਾ ਲੈ ਕੇ ਘਰ ਨੂੰ ਲਿੱਪੇ। ");
INSERT INTO pan_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","ਪਰ ਜੇਕਰ ਪੱਥਰਾਂ ਨੂੰ ਕੱਢਣ ਅਤੇ ਘਰ ਨੂੰ ਛਿੱਲਣ ਅਤੇ ਲਿੱਪਣ ਤੋਂ ਬਾਅਦ ਉਹ ਰੋਗ ਘਰ ਵਿੱਚ ਫੇਰ ਫੁੱਟ ਨਿੱਕਲੇ, ");
INSERT INTO pan_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","ਤਾਂ ਜਾਜਕ ਆ ਕੇ ਵੇਖੇ ਅਤੇ ਵੇਖੋ, ਜੇਕਰ ਉਹ ਰੋਗ ਘਰ ਵਿੱਚ ਫੈਲ ਗਿਆ ਹੋਵੇ, ਤਾਂ ਉਹ ਘਰ ਵਿੱਚ ਫੈਲਣ ਵਾਲਾ ਕੋੜ੍ਹ ਹੈ ਅਤੇ ਉਹ ਅਸ਼ੁੱਧ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","ਉਹ ਉਸ ਘਰ ਨੂੰ ਢਾਹ ਦੇਵੇ ਅਤੇ ਉਸ ਦੇ ਪੱਥਰ, ਲੱਕੜੀਆਂ ਅਤੇ ਸਾਰੇ ਚੂਨੇ ਨੂੰ ਸ਼ਹਿਰ ਤੋਂ ਬਾਹਰ ਜਾ ਕੇ ਕਿਸੇ ਅਸ਼ੁੱਧ ਸਥਾਨ ਵਿੱਚ ਸੁੱਟਵਾ ਦੇਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","ਜਦ ਤੱਕ ਉਹ ਘਰ ਬੰਦ ਰਹੇ, ਤਦ ਤੱਕ ਜੋ ਕੋਈ ਉਸ ਘਰ ਵਿੱਚ ਵੜੇ, ਉਹ ਸ਼ਾਮ ਤੱਕ ਅਸ਼ੁੱਧ ਰਹੇ। ");
INSERT INTO pan_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","ਅਤੇ ਜਿਹੜਾ ਉਸ ਘਰ ਵਿੱਚ ਲੰਮਾ ਪਵੇ, ਉਹ ਆਪਣੇ ਕੱਪੜੇ ਧੋ ਲਵੇ ਅਤੇ ਜਿਹੜਾ ਉਸ ਘਰ ਵਿੱਚ ਖਾਣਾ ਖਾਵੇ ਉਹ ਵੀ ਆਪਣੇ ਕੱਪੜੇ ਧੋ ਲਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","ਜੇਕਰ ਜਾਜਕ ਉਸ ਘਰ ਵਿੱਚ ਆ ਕੇ ਉਸ ਨੂੰ ਜਾਂਚੇ ਅਤੇ ਵੇਖੋ, ਜੇਕਰ ਉਸ ਘਰ ਨੂੰ ਲਿੱਪਣ ਤੋਂ ਬਾਅਦ ਉਹ ਰੋਗ ਉਸ ਘਰ ਵਿੱਚ ਨਾ ਫੈਲਿਆ ਹੋਵੇ ਤਾਂ ਉਹ ਉਸ ਘਰ ਨੂੰ ਸ਼ੁੱਧ ਠਹਿਰਾਵੇ ਕਿਉਂ ਜੋ ਰੋਗ ਚੰਗਾ ਹੋ ਗਿਆ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","ਅਤੇ ਉਸ ਘਰ ਨੂੰ ਸ਼ੁੱਧ ਕਰਨ ਲਈ, ਉਹ ਦੋ ਪੰਛੀ, ਦਿਆਰ ਦੀ ਲੱਕੜ, ਕਿਰਮਚੀ ਕੱਪੜਾ ਅਤੇ ਜੂਫ਼ਾ ਲਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","ਉਹ ਪੰਛੀਆਂ ਵਿੱਚੋਂ ਕਿਸੇ ਇੱਕ ਨੂੰ ਵੱਗਦੇ ਪਾਣੀ ਉੱਤੇ ਮਿੱਟੀ ਦੇ ਭਾਂਡੇ ਵਿੱਚ ਵੱਢੇ। ");
INSERT INTO pan_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","ਤਦ ਉਹ ਦਿਆਰ ਦੀ ਲੱਕੜ, ਜੂਫ਼ਾ ਅਤੇ ਕਿਰਮਚੀ ਕੱਪੜੇ ਅਤੇ ਜੀਉਂਦੇ ਪੰਛੀ ਨੂੰ ਲੈ ਕੇ ਉਸ ਵੱਢੇ ਹੋਏ ਪੰਛੀ ਦੇ ਲਹੂ ਵਿੱਚ ਅਤੇ ਵਗਦੇ ਪਾਣੀ ਵਿੱਚ ਡੋਬੇ ਅਤੇ ਉਸ ਘਰ ਉੱਤੇ ਸੱਤ ਵਾਰੀ ਛਿੜਕੇ। ");
INSERT INTO pan_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","ਇਸ ਤਰ੍ਹਾਂ ਉਹ ਪੰਛੀ ਦੇ ਲਹੂ, ਵਗਦੇ ਪਾਣੀ, ਜੀਉਂਦੇ ਪੰਛੀ, ਦਿਆਰ ਦੀ ਲੱਕੜ, ਜੂਫ਼ੇ ਅਤੇ ਕਿਰਮਚੀ ਕੱਪੜੇ ਨਾਲ ਉਸ ਘਰ ਨੂੰ ਸ਼ੁੱਧ ਕਰੇ। ");
INSERT INTO pan_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","ਪਰ ਉਸ ਜੀਉਂਦੇ ਪੰਛੀ ਨੂੰ ਸ਼ਹਿਰ ਤੋਂ ਬਾਹਰ ਖੁੱਲ੍ਹੇ ਮੈਦਾਨ ਵਿੱਚ ਉਡਾ ਦੇਵੇ, ਇਸ ਤਰ੍ਹਾਂ ਉਹ ਉਸ ਘਰ ਦੇ ਲਈ ਪ੍ਰਾਸਚਿਤ ਕਰੇ ਤਦ ਉਹ ਸ਼ੁੱਧ ਹੋਵੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","ਹਰ ਪ੍ਰਕਾਰ ਦੇ ਕੋੜ੍ਹ ਦੇ ਰੋਗ ਅਤੇ ਦਾਦ ਲਈ ਇਹੋ ਬਿਵਸਥਾ ਹੈ, ");
INSERT INTO pan_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","ਕੱਪੜਿਆਂ ਦਾ ਅਤੇ ਘਰ ਦਾ ਕੋੜ੍ਹ, ");
INSERT INTO pan_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","ਅਤੇ ਸੋਜ, ਪੱਪੜੀ, ਅਤੇ ਦਾਗ ਦੇ ਲਈ ");
INSERT INTO pan_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","ਅਸ਼ੁੱਧ ਅਤੇ ਸ਼ੁੱਧ ਬਾਰੇ ਸਮਝਾਉਣ ਲਈ ਕੋੜ੍ਹ ਦੀ ਬਿਵਸਥਾ ਇਹ ਹੀ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਅਤੇ ਹਾਰੂਨ ਨੂੰ ਆਖਿਆ, ");
INSERT INTO pan_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","ਇਸਰਾਏਲੀਆਂ ਨਾਲ ਗੱਲ ਕਰੋ ਅਤੇ ਉਨ੍ਹਾਂ ਨੂੰ ਆਖੋ, ਜੇਕਰ ਕਿਸੇ ਮਨੁੱਖ ਦੇ ਸਰੀਰ ਵਿੱਚ ਪ੍ਰਮੇਹ ਦਾ ਰੋਗ ਹੋਵੇ ਤਾਂ ਉਹ ਉਸ ਰੋਗ ਦੇ ਕਾਰਨ ਅਸ਼ੁੱਧ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","ਭਾਵੇਂ ਪ੍ਰਮੇਹ ਉਸ ਦੇ ਸਰੀਰ ਤੋਂ ਵਗਦਾ ਰਹੇ ਭਾਵੇਂ ਵਗਣਾ ਬੰਦ ਵੀ ਹੋ ਜਾਵੇ ਤਾਂ ਵੀ ਉਹ ਅਸ਼ੁੱਧ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","ਉਹ ਸਾਰੇ ਵਿਛਾਉਣੇ ਜਿੰਨ੍ਹਾਂ ਦੇ ਉੱਤੇ ਪ੍ਰਮੇਹ ਵਾਲਾ ਲੇਟੇ, ਉਹ ਅਸ਼ੁੱਧ ਹੋਣ ਅਤੇ ਸਭ ਵਸਤੂਆਂ ਜਿਨ੍ਹਾਂ ਦੇ ਉੱਤੇ ਉਹ ਬੈਠੇ ਉਹ ਵੀ ਅਸ਼ੁੱਧ ਹੋਣ। ");
INSERT INTO pan_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","ਜਿਹੜਾ ਉਸ ਵਿਛਾਉਣੇ ਨੂੰ ਛੂਹੇ, ਉਹ ਆਪਣੇ ਕੱਪੜੇ ਧੋਵੇ, ਪਾਣੀ ਨਾਲ ਨਹਾਵੇ ਅਤੇ ਸ਼ਾਮ ਤੱਕ ਅਸ਼ੁੱਧ ਰਹੇ। ");
INSERT INTO pan_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","ਜਿਹੜਾ ਕਿਸੇ ਅਜਿਹੀ ਵਸਤੂ ਉੱਤੇ ਬੈਠੇ ਜਿਸ ਉੱਤੇ ਪ੍ਰਮੇਹ ਵਾਲਾ ਬੈਠਿਆ ਸੀ, ਤਾਂ ਉਹ ਆਪਣੇ ਕੱਪੜੇ ਧੋਵੇ, ਪਾਣੀ ਨਾਲ ਨਹਾਵੇ ਅਤੇ ਸ਼ਾਮ ਤੱਕ ਅਸ਼ੁੱਧ ਰਹੇ। ");
INSERT INTO pan_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","ਅਤੇ ਜਿਹੜਾ ਉਸ ਪ੍ਰਮੇਹ ਵਾਲੇ ਨੂੰ ਛੂਹੇ, ਉਹ ਆਪਣੇ ਕੱਪੜੇ ਧੋਵੇ, ਪਾਣੀ ਨਾਲ ਨਹਾਵੇ ਅਤੇ ਸ਼ਾਮ ਤੱਕ ਅਸ਼ੁੱਧ ਰਹੇ। ");
INSERT INTO pan_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","ਜੇਕਰ ਕਦੀ ਪ੍ਰਮੇਹ ਦਾ ਰੋਗੀ ਸ਼ੁੱਧ ਮਨੁੱਖ ਦੇ ਉੱਤੇ ਥੁੱਕੇ ਤਾਂ ਉਹ ਆਪਣੇ ਕੱਪੜੇ ਧੋਵੇ, ਪਾਣੀ ਨਾਲ ਨਹਾਵੇ ਅਤੇ ਸ਼ਾਮ ਤੱਕ ਅਸ਼ੁੱਧ ਰਹੇ। ");
INSERT INTO pan_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","ਜਿਹੜੀ ਕਾਠੀ ਉੱਤੇ ਪ੍ਰਮੇਹ ਵਾਲਾ ਬੈਠੇ, ਉਹ ਅਸ਼ੁੱਧ ਹੋਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","ਅਤੇ ਜਿਹੜਾ ਉਸ ਵਸਤੂ ਨੂੰ ਛੂਹੇ ਜਿਹੜੀ ਪ੍ਰਮੇਹ ਵਾਲੇ ਦੇ ਹੇਠ ਸੀ, ਉਹ ਸ਼ਾਮ ਤੱਕ ਅਸ਼ੁੱਧ ਰਹੇ ਅਤੇ ਜਿਹੜਾ ਅਜਿਹੀ ਵਸਤੂ ਨੂੰ ਚੁੱਕੇ ਤਾਂ ਉਹ ਆਪਣੇ ਕੱਪੜੇ ਧੋਵੇ, ਪਾਣੀ ਨਾਲ ਨਹਾਵੇ ਅਤੇ ਸ਼ਾਮ ਤੱਕ ਅਸ਼ੁੱਧ ਰਹੇ। ");
INSERT INTO pan_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","ਜਿਸ ਨੂੰ ਪ੍ਰਮੇਹ ਹੋਵੇ, ਉਸ ਜਿਸ ਕਿਸੇ ਨੂੰ ਬਿਨ੍ਹਾਂ ਹੱਥ ਧੋਏ ਛੂਹ ਲਵੇ ਤਾਂ ਉਹ ਮਨੁੱਖ ਆਪਣੇ ਕੱਪੜੇ ਧੋਵੇ, ਪਾਣੀ ਨਾਲ ਨਹਾਵੇ ਅਤੇ ਸ਼ਾਮ ਤੱਕ ਅਸ਼ੁੱਧ ਰਹੇ। ");
INSERT INTO pan_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","ਉਸ ਮਿੱਟੀ ਦੇ ਭਾਂਡੇ ਨੂੰ ਜਿਸ ਨੂੰ ਪ੍ਰਮੇਹ ਵਾਲਾ ਛੂਹੇ, ਤੋੜ ਦਿੱਤਾ ਜਾਵੇ ਅਤੇ ਸਾਰੇ ਲੱਕੜ ਦੇ ਭਾਂਡੇ ਪਾਣੀ ਨਾਲ ਧੋਤੇ ਜਾਣ। ");
INSERT INTO pan_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","ਜਦੋਂ ਪ੍ਰਮੇਹ ਵਾਲਾ ਮਨੁੱਖ ਪ੍ਰਮੇਹ ਤੋਂ ਸ਼ੁੱਧ ਹੋ ਜਾਵੇ ਤਾਂ ਉਹ ਆਪਣੇ ਸ਼ੁੱਧ ਹੋਣ ਲਈ ਸੱਤ ਦਿਨ ਗਿਣੇ ਅਤੇ ਉਸ ਤੋਂ ਬਾਅਦ ਆਪਣੇ ਕੱਪੜੇ ਧੋਵੇ ਅਤੇ ਵਗਦੇ ਪਾਣੀ ਵਿੱਚ ਨਹਾਵੇ ਤਾਂ ਉਹ ਸ਼ੁੱਧ ਹੋਵੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","ਅਤੇ ਅੱਠਵੇਂ ਦਿਨ ਉਹ ਦੋ ਘੁੱਗੀਆਂ ਜਾਂ ਕਬੂਤਰਾਂ ਦੇ ਦੋ ਬੱਚੇ ਲੈ ਕੇ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਮੰਡਲੀ ਦੇ ਡੇਰੇ ਦੇ ਦਰਵਾਜ਼ੇ ਦੇ ਕੋਲ ਆਵੇ ਅਤੇ ਜਾਜਕ ਨੂੰ ਦੇ ਦੇਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","ਤਦ ਜਾਜਕ ਉਨ੍ਹਾਂ ਵਿੱਚੋਂ ਇੱਕ ਨੂੰ ਪਾਪ ਬਲੀ ਦੀ ਭੇਟ ਕਰਕੇ ਅਤੇ ਦੂਜੇ ਨੂੰ ਹੋਮ ਬਲੀ ਦੀ ਭੇਟ ਕਰਕੇ ਚੜ੍ਹਾਵੇ ਅਤੇ ਜਾਜਕ ਉਸ ਦੇ ਪ੍ਰਮੇਹ ਦੇ ਲਈ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਪ੍ਰਾਸਚਿਤ ਕਰੇ। ");
INSERT INTO pan_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","ਜੇਕਰ ਕਿਸੇ ਮਨੁੱਖ ਦਾ ਵੀਰਜ ਨਿੱਕਲੇ ਤਾਂ ਉਹ ਆਪਣਾ ਸਾਰਾ ਸਰੀਰ ਪਾਣੀ ਨਾਲ ਧੋਵੇ ਅਤੇ ਸ਼ਾਮ ਤੱਕ ਅਸ਼ੁੱਧ ਰਹੇ। ");
INSERT INTO pan_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","ਅਤੇ ਜਿਸ ਕਿਸੇ ਬਸਤਰ ਜਾਂ ਚਮੜੇ ਉੱਤੇ ਉਹ ਵੀਰਜ ਪਵੇ, ਉਹ ਪਾਣੀ ਨਾਲ ਧੋਤੇ ਜਾਣ ਅਤੇ ਸ਼ਾਮ ਤੱਕ ਅਸ਼ੁੱਧ ਰਹਿਣ। ");
INSERT INTO pan_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","ਜੇਕਰ ਕੋਈ ਪੁਰਖ ਕਿਸੇ ਇਸਤਰੀ ਨਾਲ ਸੰਗ ਕਰੇ ਅਤੇ ਉਸ ਤੋਂ ਵੀਰਜ ਨਿੱਕਲੇ ਤਾਂ ਉਹ ਦੋਵੇਂ ਪਾਣੀ ਨਾਲ ਨਹਾਉਣ ਅਤੇ ਸ਼ਾਮ ਤੱਕ ਅਸ਼ੁੱਧ ਰਹਿਣ। ");
INSERT INTO pan_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","ਜੇਕਰ ਕਿਸੇ ਇਸਤਰੀ ਨੂੰ ਪ੍ਰਮੇਹ ਹੋਵੇ ਅਤੇ ਉਸ ਦੇ ਪ੍ਰਮੇਹ ਵਿੱਚ ਲਹੂ ਹੋਵੇ ਤਾਂ ਉਹ ਸੱਤ ਦਿਨ ਤੱਕ ਵੱਖਰੀ ਕੀਤੀ ਜਾਵੇ ਅਤੇ ਜਿਹੜਾ ਉਸ ਨੂੰ ਛੂਹੇ ਉਹ ਸ਼ਾਮ ਤੱਕ ਅਸ਼ੁੱਧ ਰਹੇ। ");
INSERT INTO pan_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","ਅਤੇ ਜਦ ਤੱਕ ਉਹ ਅਸ਼ੁੱਧ ਰਹੇ ਤਦ ਤੱਕ ਜਿਸ ਕਿਸੇ ਵਸਤੂ ਉੱਤੇ ਉਹ ਲੰਮੀ ਪਵੇ, ਅਤੇ ਜਿਸ ਕਿਸੇ ਵਸਤੂ ਉੱਤੇ ਉਹ ਬੈਠੇ ਉਹ ਸਭ ਅਸ਼ੁੱਧ ਹੋਣ। ");
INSERT INTO pan_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","ਅਤੇ ਜਿਹੜਾ ਉਸ ਦੇ ਵਿਛਾਉਣੇ ਨੂੰ ਛੂਹੇ ਉਹ ਆਪਣੇ ਕੱਪੜੇ ਧੋਵੇ, ਪਾਣੀ ਨਾਲ ਨਹਾਵੇ ਅਤੇ ਸ਼ਾਮ ਤੱਕ ਅਸ਼ੁੱਧ ਰਹੇ। ");
INSERT INTO pan_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","ਜੇਕਰ ਕੋਈ ਉਸ ਵਸਤੂ ਨੂੰ ਛੂਹੇ ਜਿਸ ਉੱਤੇ ਉਹ ਬੈਠਦੀ ਸੀ, ਉਹ ਆਪਣੇ ਕੱਪੜੇ ਧੋਵੇ, ਪਾਣੀ ਨਾਲ ਨਹਾਵੇ ਅਤੇ ਸ਼ਾਮ ਤੱਕ ਅਸ਼ੁੱਧ ਰਹੇ। ");
INSERT INTO pan_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","ਜੇਕਰ ਕੋਈ ਉਸ ਦੇ ਵਿਛਾਉਣੇ ਨੂੰ ਜਾਂ ਕਿਸੇ ਹੋਰ ਵਸਤੂ ਨੂੰ ਜਿਸ ਉੱਤੇ ਉਹ ਬੈਠੀ ਸੀ, ਛੂਹੇ, ਜਿਸ ਉੱਤੇ ਉਸ ਦਾ ਲਹੂ ਲੱਗਿਆ ਸੀ, ਤਾਂ ਉਹ ਸ਼ਾਮ ਤੱਕ ਅਸ਼ੁੱਧ ਰਹੇ। ");
INSERT INTO pan_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","ਜੇਕਰ ਕੋਈ ਮਨੁੱਖ ਉਸ ਦੇ ਨਾਲ ਸੰਗ ਕਰੇ ਅਤੇ ਉਸ ਨੂੰ ਉਸ ਦਾ ਲਹੂ ਲੱਗ ਜਾਵੇ ਤਾਂ ਉਹ ਮਨੁੱਖ ਸੱਤ ਦਿਨ ਤੱਕ ਅਸ਼ੁੱਧ ਰਹੇ ਅਤੇ ਜਿਸ ਕਿਸੇ ਵਿਛਾਉਣੇ ਉੱਤੇ ਉਹ ਲੰਮਾ ਪੈਂਦਾ ਹੈ, ਉਹ ਅਸ਼ੁੱਧ ਠਹਿਰੇ। ");
INSERT INTO pan_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","ਜੇਕਰ ਕਿਸੇ ਇਸਤਰੀ ਨੂੰ ਉਸ ਦੀ ਮਾਹਵਾਰੀ ਦੇ ਦਿਨਾਂ ਤੋਂ ਇਲਾਵਾ ਜਾਂ ਮਾਹਵਾਰੀ ਦੇ ਨਿਯੁਕਤ ਦਿਨਾਂ ਤੋਂ ਵੱਧ ਸਮੇਂ ਤੱਕ ਲਹੂ ਵੱਗਦਾ ਰਹੇ, ਤਾਂ ਜਦ ਤੱਕ ਉਹ ਅਜਿਹੀ ਹਾਲਤ ਵਿੱਚ ਰਹੇ ਤਦ ਤੱਕ ਉਹ ਅਸ਼ੁੱਧ ਰਹੇ। ");
INSERT INTO pan_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","ਉਹ ਸਾਰੇ ਵਿਛਾਉਣੇ ਜਿਨ੍ਹਾਂ ਦੇ ਉੱਤੇ ਉਹ ਆਪਣੇ ਪ੍ਰਮੇਹ ਦੇ ਸਾਰੇ ਦਿਨਾਂ ਵਿੱਚ ਲੰਮੀ ਪਵੇ, ਉਹ ਉਸ ਦੀ ਮਾਹਵਾਰੀ ਦੇ ਵਿਛਾਉਣੇ ਦੀ ਤਰ੍ਹਾਂ ਠਹਿਰਣ, ਅਤੇ ਜਿਸ ਕਿਸੇ ਵਸਤੂ ਉੱਤੇ ਉਹ ਬੈਠੇ, ਉਹ ਸਭ ਉਸ ਦੀ ਮਾਹਵਾਰੀ ਦੇ ਦਿਨਾਂ ਦੀ ਅਸ਼ੁੱਧਤਾਈ ਦੀ ਤਰ੍ਹਾਂ ਅਸ਼ੁੱਧ ਹੋਣ। ");
INSERT INTO pan_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","ਜਿਹੜਾ ਉਨ੍ਹਾਂ ਵਸਤੂਆਂ ਨੂੰ ਛੂਹੇ, ਉਹ ਅਸ਼ੁੱਧ ਠਹਿਰੇ, ਇਸ ਲਈ ਉਹ ਆਪਣੇ ਕੱਪੜੇ ਧੋਵੇ, ਪਾਣੀ ਨਾਲ ਨਹਾਵੇ ਅਤੇ ਸ਼ਾਮ ਤੱਕ ਅਸ਼ੁੱਧ ਰਹੇ। ");
INSERT INTO pan_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","ਪਰ ਜੇਕਰ ਉਹ ਆਪਣੇ ਪ੍ਰਮੇਹ ਤੋਂ ਸ਼ੁੱਧ ਹੋ ਜਾਵੇ, ਤਾਂ ਉਹ ਸੱਤ ਦਿਨ ਗਿਣੇ ਅਤੇ ਉਸ ਤੋਂ ਬਾਅਦ ਉਹ ਸ਼ੁੱਧ ਹੋ ਜਾਵੇਗੀ। ");
INSERT INTO pan_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","ਅੱਠਵੇਂ ਦਿਨ ਉਹ ਦੋ ਘੁੱਗੀਆਂ ਜਾਂ ਕਬੂਤਰਾਂ ਦੇ ਦੋ ਬੱਚੇ ਲੈ ਕੇ ਉਨ੍ਹਾਂ ਨੂੰ ਮੰਡਲੀ ਦੇ ਡੇਰੇ ਦੇ ਦਰਵਾਜ਼ੇ ਦੇ ਅੱਗੇ ਜਾਜਕ ਦੇ ਕੋਲ ਲਿਆਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","ਤਦ ਜਾਜਕ ਇੱਕ ਨੂੰ ਪਾਪ ਬਲੀ ਦੀ ਭੇਟ ਕਰਕੇ ਅਤੇ ਦੂਜੇ ਨੂੰ ਹੋਮ ਦੀ ਭੇਟ ਕਰਕੇ ਚੜ੍ਹਾਵੇ ਅਤੇ ਜਾਜਕ ਉਸ ਦੇ ਲਈ ਉਸ ਦੀ ਪ੍ਰਮੇਹ ਦੀ ਅਸ਼ੁੱਧਤਾਈ ਦੇ ਕਾਰਨ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਪ੍ਰਾਸਚਿਤ ਕਰੇ। ");
INSERT INTO pan_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","ਇਸ ਤਰ੍ਹਾਂ ਤੁਸੀਂ ਇਸਰਾਏਲੀਆਂ ਨੂੰ ਉਨ੍ਹਾਂ ਦੀ ਅਸ਼ੁੱਧਤਾਈ ਤੋਂ ਵੱਖਰਾ ਕਰਨਾ, ਅਜਿਹਾ ਨਾ ਹੋਵੇ ਕਿ ਉਹ ਆਪਣੀ ਅਸ਼ੁੱਧਤਾਈ ਦੇ ਕਾਰਨ ਮੇਰੇ ਉਸ ਡੇਰੇ ਨੂੰ ਭਰਿਸ਼ਟ ਕਰਨ ਜੋ ਉਨ੍ਹਾਂ ਦੇ ਵਿਚਕਾਰ ਹੈ ਅਤੇ ਇਸ ਕਾਰਨ ਮਰ ਨਾ ਜਾਣ। ");
INSERT INTO pan_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","ਜਿਸ ਨੂੰ ਪ੍ਰਮੇਹ ਹੋਵੇ ਅਤੇ ਜੋ ਪੁਰਖ ਵੀਰਜ ਨਿੱਕਲਣ ਦੇ ਕਾਰਨ ਅਸ਼ੁੱਧ ਹੋਵੇ, ");
INSERT INTO pan_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","ਅਤੇ ਜੋ ਇਸਤਰੀ ਮਾਹਵਾਰੀ ਵਿੱਚ ਹੋਵੇ, ਅਤੇ ਉਹ ਪੁਰਖ ਜਾਂ ਇਸਤਰੀ ਜਿਸ ਨੂੰ ਪ੍ਰਮੇਹ ਹੋਵੇ ਅਤੇ ਉਹ ਪੁਰਖ ਜੋ ਅਸ਼ੁੱਧ ਇਸਤਰੀ ਨਾਲ ਸੰਗ ਕਰੇ, ਉਨ੍ਹਾਂ ਸਾਰਿਆਂ ਦੇ ਲਈ ਇਹੋ ਹੀ ਬਿਵਸਥਾ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","ਜਿਸ ਵੇਲੇ ਹਾਰੂਨ ਦੇ ਦੋ ਪੁੱਤਰ ਯਹੋਵਾਹ ਦੇ ਸਨਮੁਖ ਅਪਵਿੱਤਰ ਭੇਟ ਚੜ੍ਹਾ ਕੇ ਮਰ ਗਏ, ");
INSERT INTO pan_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","ਤਦ ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਦੇ ਨਾਲ ਗੱਲ ਕਰਕੇ ਆਖਿਆ, “ਆਪਣੇ ਭਰਾ ਹਾਰੂਨ ਨੂੰ ਆਖ, ਉਹ ਪਵਿੱਤਰ ਸਥਾਨ ਵਿੱਚ ਪਰਦੇ ਦੇ ਅੰਦਰ ਪ੍ਰਾਸਚਿਤ ਦੇ ਸਰਪੋਸ਼ ਦੇ ਅੱਗੇ, ਜੋ ਸੰਦੂਕ ਦੇ ਉੱਤੇ ਹੈ, ਹਰ ਵਾਰੀ ਨਾ ਆਇਆ ਕਰੇ, ਤਾਂ ਜੋ ਉਹ ਮਰ ਨਾ ਜਾਵੇ, ਕਿਉਂ ਜੋ ਮੈਂ ਪ੍ਰਾਸਚਿਤ ਦੇ ਸਰਪੋਸ਼ ਦੇ ਉੱਤੇ ਬੱਦਲ ਵਿੱਚ ਪਰਗਟ ਹੋਵਾਂਗਾ। ");
INSERT INTO pan_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","ਜਦ ਹਾਰੂਨ ਪਵਿੱਤਰ ਸਥਾਨ ਵਿੱਚ ਆਵੇ ਤਦ ਉਹ ਇੱਕ ਜੁਆਨ ਬਲ਼ਦ ਪਾਪ ਬਲੀ ਦੀ ਭੇਟ ਲਈ ਅਤੇ ਇੱਕ ਭੇਡੂ ਹੋਮ ਬਲੀ ਦੀ ਭੇਟ ਲਈ ਲੈ ਕੇ ਆਇਆ ਕਰੇ। ");
INSERT INTO pan_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","ਉਹ ਕਤਾਨ ਦਾ ਪਵਿੱਤਰ ਕੁੜਤਾ, ਕਤਾਨ ਦਾ ਅੰਗਰੱਖਾ, ਕਤਾਨ ਦਾ ਕਮਰ ਕੱਸਾ ਅਤੇ ਕਤਾਨ ਦੀ ਪਗੜੀ ਪਹਿਨ ਕੇ ਆਇਆ ਕਰੇ। ਇਹ ਪਵਿੱਤਰ ਬਸਤਰ ਹਨ, ਇਸ ਲਈ ਉਹ ਪਾਣੀ ਨਾਲ ਨਹਾ ਕੇ ਇਨ੍ਹਾਂ ਨੂੰ ਪਹਿਨੇ। ");
INSERT INTO pan_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","ਉਹ ਇਸਰਾਏਲੀਆਂ ਦੀ ਮੰਡਲੀ ਤੋਂ ਪਾਪ ਬਲੀ ਦੀ ਭੇਟ ਲਈ ਬੱਕਰੀਆਂ ਦੇ ਦੋ ਮੇਮਣੇ ਅਤੇ ਹੋਮ ਬਲੀ ਭੇਟ ਲਈ ਇੱਕ ਭੇਡੂ ਲਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","ਅਤੇ ਹਾਰੂਨ ਉਸ ਪਾਪ ਬਲੀ ਦੀ ਭੇਟ ਦੇ ਬਲ਼ਦ ਨੂੰ, ਜੋ ਆਪ ਉਸ ਦੇ ਲਈ ਹੈ ਚੜ੍ਹਾਵੇ ਅਤੇ ਆਪਣੇ ਲਈ ਅਤੇ ਆਪਣੇ ਘਰਾਣੇ ਲਈ ਪ੍ਰਾਸਚਿਤ ਕਰੇ। ");
INSERT INTO pan_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","ਉਹ ਉਨ੍ਹਾਂ ਦੋਨਾਂ ਮੇਮਣਿਆਂ ਨੂੰ ਲੈ ਕੇ ਮੰਡਲੀ ਦੇ ਡੇਰੇ ਦੇ ਦਰਵਾਜ਼ੇ ਦੇ ਕੋਲ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਖੜ੍ਹਾ ਕਰੇ। ");
INSERT INTO pan_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","ਅਤੇ ਹਾਰੂਨ ਉਨ੍ਹਾਂ ਦੋਹਾਂ ਬੱਕਰਿਆਂ ਉੱਤੇ ਪਰਚੀਆਂ ਪਾਵੇ, ਇੱਕ ਪਰਚੀ ਯਹੋਵਾਹ ਦੇ ਲਈ ਅਤੇ ਦੂਜੀ ਅਜ਼ਾਜ਼ੇਲ ਦੇ ਲਈ। ");
INSERT INTO pan_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","ਜਿਸ ਬੱਕਰੇ ਉੱਤੇ ਯਹੋਵਾਹ ਲਈ ਪਰਚੀ ਨਿੱਕਲੇ, ਹਾਰੂਨ ਉਸ ਨੂੰ ਲੈ ਕੇ ਪਾਪ ਬਲੀ ਦੀ ਭੇਟ ਕਰਕੇ ਚੜ੍ਹਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","ਪਰ ਉਹ ਬੱਕਰਾ ਜਿਸ ਦੇ ਉੱਤੇ ਅਜ਼ਾਜ਼ੇਲ ਲਈ ਪਰਚੀ ਨਿੱਕਲੀ, ਉਹ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਜੀਉਂਦਾ ਖੜ੍ਹਾ ਕੀਤਾ ਜਾਵੇ ਕਿ ਉਸ ਦੇ ਨਾਲ ਪ੍ਰਾਸਚਿਤ ਕੀਤਾ ਜਾਵੇ ਅਤੇ ਉਸ ਨੂੰ ਛੋਟ ਕਰ ਕੇ ਉਜਾੜ ਵਿੱਚ ਛੱਡ ਦਿੱਤਾ ਜਾਵੇ।” ");
INSERT INTO pan_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","“ਹਾਰੂਨ ਉਸ ਪਾਪ ਬਲੀ ਦੀ ਭੇਟ ਦੇ ਬਲ਼ਦ ਨੂੰ ਜੋ ਉਸਨੇ ਆਪਣੇ ਲਈ ਲਿਆ ਹੈ, ਲਿਆਵੇ ਅਤੇ ਉਸ ਨੂੰ ਵੱਢ ਕੇ ਆਪਣੇ ਲਈ ਅਤੇ ਆਪਣੇ ਘਰਾਣੇ ਲਈ ਪ੍ਰਾਸਚਿਤ ਕਰੇ। ");
INSERT INTO pan_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","ਅਤੇ ਉਹ ਜਗਵੇਦੀ ਦੇ ਉੱਤੋਂ ਕੋਲਿਆਂ ਦੀ ਅੱਗ ਨਾਲ ਧੂਪਦਾਨੀ ਨੂੰ ਭਰੇ ਅਤੇ ਆਪਣੇ ਦੋਵੇਂ ਹੱਥਾਂ ਵਿੱਚ ਮਹੀਨ ਕੁੱਟੇ ਹੋਏ ਸੁਗੰਧ ਧੂਪ ਨੂੰ ਭਰ ਕੇ ਪਰਦੇ ਦੇ ਅੰਦਰ ਲੈ ਆਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","ਉਹ ਉਸ ਧੂਪ ਨੂੰ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਅੱਗ ਦੇ ਉੱਤੇ ਪਾਵੇ, ਤਾਂ ਜੋ ਧੂਪ ਦਾ ਧੂੰਆਂ ਪ੍ਰਾਸਚਿਤ ਦੇ ਸਰਪੋਸ਼ ਨੂੰ ਜੋ ਸਾਖੀ ਦੇ ਉੱਤੇ ਹੈ, ਢੱਕ ਲਵੇ, ਤਾਂ ਜੋ ਉਹ ਮਰ ਨਾ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","ਤਦ ਉਹ ਬਲ਼ਦ ਦੇ ਲਹੂ ਵਿੱਚੋਂ ਕੁਝ ਲੈ ਕੇ ਪੂਰਬ ਦੀ ਵੱਲ ਉਸ ਨੂੰ ਪ੍ਰਾਸਚਿਤ ਦੇ ਸਰਪੋਸ਼ ਉੱਤੇ ਆਪਣੀ ਉਂਗਲ ਨਾਲ ਛਿੜਕੇ ਅਤੇ ਫੇਰ ਉਸ ਲਹੂ ਵਿੱਚੋਂ ਕੁਝ ਆਪਣੀ ਉਂਗਲ ਨਾਲ ਪ੍ਰਾਸਚਿਤ ਦੇ ਸਰਪੋਸ਼ ਦੇ ਅੱਗੇ ਸੱਤ ਵਾਰੀ ਛਿੜਕੇ।” ");
INSERT INTO pan_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","“ਫੇਰ ਉਹ ਪਾਪ ਬਲੀ ਦੀ ਭੇਟ ਦੇ ਬੱਕਰੇ ਨੂੰ ਜੋ ਲੋਕਾਂ ਦੇ ਲਈ ਹੈ, ਵੱਢੇ ਅਤੇ ਉਸ ਦਾ ਲਹੂ ਪਰਦੇ ਦੇ ਅੰਦਰ ਲਿਆਵੇ ਅਤੇ ਜਿਵੇਂ ਉਸ ਨੇ ਬਲ਼ਦ ਦੇ ਲਹੂ ਨਾਲ ਕੀਤਾ ਸੀ, ਉਸੇ ਤਰ੍ਹਾਂ ਹੀ ਉਹ ਉਸ ਦੇ ਲਹੂ ਨਾਲ ਕਰੇ ਅਰਥਾਤ ਪ੍ਰਾਸਚਿਤ ਦੇ ਸਰਪੋਸ਼ ਦੇ ਉੱਤੇ ਅਤੇ ਉਸ ਦੇ ਸਾਹਮਣੇ ਉਸ ਨੂੰ ਛਿੜਕੇ।” ");
INSERT INTO pan_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","ਅਤੇ ਉਹ ਇਸਰਾਏਲੀਆਂ ਦੀ ਅਲੱਗ-ਅਲੱਗ ਅਸ਼ੁੱਧਤਾਈ, ਅਤੇ ਉਨ੍ਹਾਂ ਦੇ ਪਾਪਾਂ, ਅਤੇ ਉਨ੍ਹਾਂ ਦੇ ਸਾਰੇ ਅਪਰਾਧਾਂ ਦੇ ਕਾਰਨ, ਪਵਿੱਤਰ ਸਥਾਨ ਦੇ ਲਈ ਪ੍ਰਾਸਚਿਤ ਕਰੇ ਅਤੇ ਇਸੇ ਤਰ੍ਹਾਂ ਹੀ ਉਹ ਮੰਡਲੀ ਦੇ ਡੇਰੇ ਦੇ ਲਈ ਕਰੇ ਜਿਹੜਾ ਉਨ੍ਹਾਂ ਦੀ ਅਸ਼ੁੱਧਤਾਈ ਦੇ ਵਿਚਕਾਰ ਰਹਿੰਦਾ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","ਜਿਸ ਵੇਲੇ ਹਾਰੂਨ ਪਵਿੱਤਰ ਸਥਾਨ ਵਿੱਚ ਪ੍ਰਾਸਚਿਤ ਕਰਨ ਲਈ ਜਾਵੇ, ਤਾਂ ਜਦ ਤੱਕ ਉਹ ਆਪਣੇ ਲਈ, ਆਪਣੇ ਘਰਾਣੇ ਦੇ ਲਈ ਅਤੇ ਇਸਰਾਏਲ ਦੀ ਸਾਰੀ ਮੰਡਲੀ ਦੇ ਲਈ ਪ੍ਰਾਸਚਿਤ ਪੂਰਾ ਕਰਕੇ ਬਾਹਰ ਨਾ ਨਿੱਕਲੇ, ਤਦ ਤੱਕ ਮੰਡਲੀ ਦੇ ਡੇਰੇ ਵਿੱਚ ਹੋਰ ਕੋਈ ਮਨੁੱਖ ਨਾ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","ਫੇਰ ਉਹ ਨਿੱਕਲ ਕੇ ਉਸ ਜਗਵੇਦੀ ਦੇ ਕੋਲ ਜਾਵੇ ਜਿਹੜੀ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਹੈ, ਅਤੇ ਉਸ ਦੇ ਲਈ ਪ੍ਰਾਸਚਿਤ ਕਰੇ ਅਤੇ ਬਲ਼ਦ ਦੇ ਲਹੂ ਅਤੇ ਬੱਕਰੇ ਦੇ ਲਹੂ ਤੋਂ ਕੁਝ ਲੈ ਕੇ ਉਸ ਨੂੰ ਜਗਵੇਦੀ ਦੇ ਸਿੰਗਾਂ ਉੱਤੇ ਅਤੇ ਆਲੇ-ਦੁਆਲੇ ਛਿੜਕੇ। ");
INSERT INTO pan_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","ਅਤੇ ਉਹ ਉਸ ਲਹੂ ਤੋਂ ਆਪਣੀ ਉਂਗਲ ਨਾਲ ਕੁਝ ਲੈ ਕੇ ਸੱਤ ਵਾਰੀ ਉਸ ਦੇ ਉੱਤੇ ਛਿੜਕੇ ਅਤੇ ਇਸਰਾਏਲੀਆਂ ਦੀ ਅਲੱਗ-ਅਲੱਗ ਅਸ਼ੁੱਧਤਾਈਆਂ ਤੋਂ ਉਸ ਨੂੰ ਪਵਿੱਤਰ ਕਰੇ। ");
INSERT INTO pan_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","ਜਦ ਉਹ ਪਵਿੱਤਰ ਸਥਾਨ ਅਤੇ ਮੰਡਲੀ ਦੇ ਡੇਰੇ ਅਤੇ ਜਗਵੇਦੀ ਦਾ ਪ੍ਰਾਸਚਿਤ ਪੂਰਾ ਕਰ ਲਵੇ ਤਾਂ ਜੀਉਂਦੇ ਬੱਕਰੇ ਨੂੰ ਲਿਆਵੇ, ");
INSERT INTO pan_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","ਅਤੇ ਹਾਰੂਨ ਆਪਣੇ ਦੋਹਾਂ ਹੱਥਾਂ ਨੂੰ ਜੀਉਂਦੇ ਬੱਕਰੇ ਦੇ ਸਿਰ ਉੱਤੇ ਰੱਖੇ ਅਤੇ ਇਸਰਾਏਲੀਆਂ ਦੀਆਂ ਬਦੀਆਂ, ਉਨ੍ਹਾਂ ਦੇ ਸਾਰੇ ਪਾਪਾਂ, ਅਤੇ ਉਨ੍ਹਾਂ ਦੇ ਸਾਰੇ ਅਪਰਾਧਾਂ ਦਾ ਇਕਰਾਰ ਕਰੇ ਅਤੇ ਉਨ੍ਹਾਂ ਨੂੰ ਬੱਕਰੇ ਦੇ ਸਿਰ ਉੱਤੇ ਰੱਖ ਕੇ ਉਸ ਨੂੰ ਕਿਸੇ ਮਨੁੱਖ ਦੇ ਹੱਥ ਜਿਹੜਾ ਇਸ ਕੰਮ ਲਈ ਤਿਆਰ ਹੋਵੇ, ਉਜਾੜ ਵਿੱਚ ਭੇਜ ਦੇਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","ਉਹ ਬੱਕਰਾ ਉਨ੍ਹਾਂ ਦੀਆਂ ਸਾਰੀਆਂ ਬਦੀਆਂ ਨੂੰ ਆਪਣੇ ਸਿਰ ਤੇ ਚੁੱਕ ਕੇ ਕਿਸੇ ਉਜਾੜ ਸਥਾਨ ਨੂੰ ਚੱਲਿਆ ਜਾਵੇ ਅਤੇ ਉਹ ਮਨੁੱਖ ਉਸ ਬੱਕਰੇ ਨੂੰ ਉਜਾੜ ਵਿੱਚ ਛੱਡ ਦੇਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","ਤਦ ਹਾਰੂਨ ਮੰਡਲੀ ਦੇ ਡੇਰੇ ਵਿੱਚ ਆਵੇ ਅਤੇ ਜਿਹੜੇ ਕਤਾਨੀ ਬਸਤਰ ਉਸ ਨੇ ਪਵਿੱਤਰ ਸਥਾਨ ਵਿੱਚ ਜਾਣ ਦੇ ਵੇਲੇ ਪਹਿਨੇ ਸਨ, ਉਨ੍ਹਾਂ ਨੂੰ ਲਾਹ ਕੇ ਰੱਖ ਦੇਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","ਫੇਰ ਉਹ ਕਿਸੇ ਪਵਿੱਤਰ ਸਥਾਨ ਵਿੱਚ ਪਾਣੀ ਨਾਲ ਨਹਾਵੇ, ਆਪਣੇ ਸਧਾਰਨ ਬਸਤਰ ਪਾਵੇ ਅਤੇ ਬਾਹਰ ਨਿੱਕਲ ਕੇ ਆਪਣੀ ਹੋਮ ਬਲੀ ਦੀ ਭੇਟ ਅਤੇ ਲੋਕਾਂ ਦੀ ਹੋਮ ਬਲੀ ਦੀ ਭੇਟ ਚੜ੍ਹਾਵੇ ਅਤੇ ਆਪਣੇ ਲਈ ਅਤੇ ਲੋਕਾਂ ਦੇ ਲਈ ਪ੍ਰਾਸਚਿਤ ਕਰੇ। ");
INSERT INTO pan_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","ਅਤੇ ਪਾਪ ਬਲੀ ਦੀ ਭੇਟ ਦੀ ਚਰਬੀ ਨੂੰ ਉਹ ਜਗਵੇਦੀ ਉੱਤੇ ਸਾੜੇ। ");
INSERT INTO pan_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","ਅਤੇ ਜਿਹੜਾ ਮਨੁੱਖ ਉਸ ਬੱਕਰੇ ਨੂੰ ਅਜ਼ਾਜ਼ੇਲ ਲਈ ਛੱਡ ਕੇ ਆਇਆ, ਉਹ ਵੀ ਆਪਣੇ ਕੱਪੜੇ ਧੋਵੇ ਅਤੇ ਪਾਣੀ ਨਾਲ ਨਹਾਵੇ ਅਤੇ ਫੇਰ ਡੇਰੇ ਵਿੱਚ ਆਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","ਉਹ ਉਸ ਪਾਪ ਬਲੀ ਦੀ ਭੇਟ ਦੇ ਬਲ਼ਦ ਅਤੇ ਪਾਪ ਬਲੀ ਦੀ ਭੇਟ ਦੇ ਬੱਕਰੇ ਨੂੰ, ਜਿਨ੍ਹਾਂ ਦਾ ਲਹੂ ਪਵਿੱਤਰ ਸਥਾਨ ਵਿੱਚ ਪ੍ਰਾਸਚਿਤ ਕਰਨ ਲਈ ਲਿਆਂਦਾ ਗਿਆ ਸੀ, ਡੇਰੇ ਤੋਂ ਬਾਹਰ ਲੈ ਜਾਵੇ ਅਤੇ ਉਨ੍ਹਾਂ ਦੀਆਂ ਖੱਲਾਂ, ਮਾਸ ਅਤੇ ਗੋਹੇ ਨੂੰ ਅੱਗ ਵਿੱਚ ਸਾੜ ਦੇਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","ਜਿਹੜਾ ਉਨ੍ਹਾਂ ਨੂੰ ਸਾੜੇ, ਉਹ ਆਪਣੇ ਕੱਪੜੇ ਧੋਵੇ ਅਤੇ ਪਾਣੀ ਨਾਲ ਨਹਾਵੇ ਅਤੇ ਫੇਰ ਡੇਰੇ ਵਿੱਚ ਆਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","“ਇਹ ਤੁਹਾਡੇ ਲਈ ਇੱਕ ਸਦਾ ਦੀ ਬਿਧੀ ਠਹਿਰੇ, ਕਿ ਸੱਤਵੇਂ ਮਹੀਨੇ ਦੇ ਦਸਵੇਂ ਦਿਨ ਤੁਸੀਂ ਆਪਣੇ ਪ੍ਰਾਣਾਂ ਨੂੰ ਦੁੱਖ ਦੇਣਾ ਅਤੇ ਉਸ ਦਿਨ ਕੋਈ ਵੀ ਮਨੁੱਖ ਕੰਮ ਨਾ ਕਰੇ ਭਾਵੇਂ ਉਹ ਆਪਣੇ ਦੇਸ ਦਾ ਹੋਵੇ, ਭਾਵੇਂ ਪਰਦੇਸੀ ਜਿਹੜਾ ਤੁਹਾਡੇ ਵਿਚਕਾਰ ਰਹਿੰਦਾ ਹੈ, ");
INSERT INTO pan_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","ਕਿਉਂ ਜੋ ਉਸੇ ਦਿਨ ਜਾਜਕ ਤੁਹਾਨੂੰ ਸ਼ੁੱਧ ਕਰਨ ਲਈ ਤੁਹਾਡੇ ਲਈ ਪ੍ਰਾਸਚਿਤ ਕਰੇ ਤਾਂ ਜੋ ਤੁਸੀਂ ਆਪਣੇ ਸਾਰੇ ਪਾਪਾਂ ਤੋਂ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਸ਼ੁੱਧ ਹੋਵੋ। ");
INSERT INTO pan_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","ਇਹ ਤੁਹਾਡੇ ਲਈ ਇੱਕ ਮਹਾਂ-ਵਿਸ਼ਰਾਮ ਦਾ ਦਿਨ ਹੋਵੇ ਅਤੇ ਇੱਕ ਸਦਾ ਦੀ ਬਿਧੀ ਦੇ ਅਨੁਸਾਰ ਤੁਸੀਂ ਆਪਣੇ ਪ੍ਰਾਣਾਂ ਨੂੰ ਦੁੱਖ ਦੇਣਾ। ");
INSERT INTO pan_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","ਜਿਸ ਦਾ ਆਪਣੇ ਪਿਤਾ ਦੇ ਥਾਂ ਉੱਤੇ ਜਾਜਕ ਹੋਣ ਲਈ ਮਸਹ ਕੀਤਾ ਜਾਵੇ, ਉਹ ਜਾਜਕ ਪ੍ਰਾਸਚਿਤ ਕਰੇ ਅਤੇ ਕਤਾਨ ਦੇ ਪਵਿੱਤਰ ਬਸਤਰਾਂ ਨੂੰ ਪਹਿਨੇ। ");
INSERT INTO pan_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","ਉਹ ਪਵਿੱਤਰ ਸਥਾਨ ਦੇ ਲਈ, ਮੰਡਲੀ ਦੇ ਡੇਰੇ ਦੇ ਲਈ ਅਤੇ ਜਗਵੇਦੀ ਦੇ ਲਈ ਪ੍ਰਾਸਚਿਤ ਕਰੇ ਅਤੇ ਉਹ ਜਾਜਕਾਂ ਦੇ ਲਈ ਅਤੇ ਮੰਡਲੀ ਦੇ ਸਾਰੇ ਲੋਕਾਂ ਦੇ ਲਈ ਪ੍ਰਾਸਚਿਤ ਕਰੇ। ");
INSERT INTO pan_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","“ਇਹ ਤੁਹਾਡੇ ਲਈ ਇੱਕ ਸਦਾ ਦੀ ਬਿਧੀ ਠਹਿਰੇ ਕਿ ਤੁਸੀਂ ਇਸਰਾਏਲੀਆਂ ਦੇ ਸਾਰੇ ਪਾਪਾਂ ਦੇ ਲਈ ਸਾਲ ਵਿੱਚ ਇੱਕ ਵਾਰੀ ਪ੍ਰਾਸਚਿਤ ਕਰੋ।” ਹਾਰੂਨ ਨੇ ਉਸੇ ਤਰ੍ਹਾਂ ਹੀ ਕੀਤਾ ਜਿਵੇਂ ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਹੁਕਮ ਦਿੱਤਾ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","ਫੇਰ ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਆਖਿਆ, ");
INSERT INTO pan_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","ਹਾਰੂਨ ਅਤੇ ਉਸ ਦੇ ਪੁੱਤਰਾਂ ਨੂੰ ਅਤੇ ਇਸਰਾਏਲ ਦੀ ਸਾਰੀ ਮੰਡਲੀ ਨਾਲ ਗੱਲ ਕਰਕੇ ਉਨ੍ਹਾਂ ਨੂੰ ਆਖ, ਜਿਸ ਕੰਮ ਦਾ ਯਹੋਵਾਹ ਨੇ ਹੁਕਮ ਦਿੱਤਾ ਹੈ, ਉਹ ਇਹ ਹੈ: ");
INSERT INTO pan_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","ਜੇਕਰ ਇਸਰਾਏਲ ਦੇ ਘਰਾਣੇ ਤੋਂ ਕੋਈ ਵੀ ਮਨੁੱਖ ਜੋ ਬਲ਼ਦ, ਜਾਂ ਲੇਲਾ, ਜਾਂ ਬੱਕਰਾ ਡੇਰੇ ਵਿੱਚ ਜਾਂ ਡੇਰੇ ਤੋਂ ਬਾਹਰ ਵੱਢੇ, ");
INSERT INTO pan_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","ਅਤੇ ਉਸ ਨੂੰ ਮੰਡਲੀ ਦੇ ਡੇਰੇ ਦੇ ਦਰਵਾਜ਼ੇ ਦੇ ਕੋਲ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ, ਯਹੋਵਾਹ ਦੇ ਨਿਵਾਸ ਸਥਾਨ ਦੇ ਸਾਹਮਣੇ ਬਲੀ ਚੜ੍ਹਾਉਣ ਲਈ ਨਾ ਲਿਆਵੇ, ਤਾਂ ਉਹ ਮਨੁੱਖ ਖੂਨ ਦਾ ਦੋਸ਼ੀ ਠਹਿਰੇ। ਉਸ ਨੇ ਲਹੂ ਬਹਾਇਆ ਹੈ ਇਸ ਲਈ ਉਹ ਮਨੁੱਖ ਆਪਣੇ ਲੋਕਾਂ ਵਿੱਚੋਂ ਛੇਕਿਆ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","ਇਸ ਬਿਧੀ ਦਾ ਕਾਰਨ ਇਹ ਹੈ ਕਿ ਇਸਰਾਏਲੀ ਆਪਣੀਆਂ ਬਲੀਆਂ ਜਿਨ੍ਹਾਂ ਨੂੰ ਉਹ ਖੁੱਲ੍ਹੇ ਮੈਦਾਨ ਵਿੱਚ ਚੜ੍ਹਾਉਂਦੇ ਹਨ, ਉਨ੍ਹਾਂ ਨੂੰ ਮੰਡਲੀ ਦੇ ਡੇਰੇ ਦੇ ਦਰਵਾਜ਼ੇ ਕੋਲ ਜਾਜਕ ਦੇ ਕੋਲ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਸੁੱਖ-ਸਾਂਦ ਦੀਆਂ ਭੇਟਾਂ ਕਰਕੇ ਲਿਆਉਣ। ");
INSERT INTO pan_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","ਅਤੇ ਜਾਜਕ ਉਸ ਲਹੂ ਨੂੰ ਯਹੋਵਾਹ ਦੀ ਜਗਵੇਦੀ ਦੇ ਉੱਤੇ ਅਤੇ ਮੰਡਲੀ ਦੇ ਡੇਰੇ ਦੇ ਦਰਵਾਜ਼ੇ ਦੇ ਕੋਲ ਛਿੜਕੇ ਅਤੇ ਚਰਬੀ ਨੂੰ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਸੁਗੰਧਤਾ ਕਰ ਕੇ ਸਾੜੇ। ");
INSERT INTO pan_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","ਤਾਂ ਜੋ ਉਹ ਜਿਹੜੇ ਬੱਕਰਿਆਂ ਦੀ ਪੂਜਾ ਕਰਕੇ ਵਿਭਚਾਰ ਕਰਦੇ ਹਨ, ਫੇਰ ਕਦੀ ਆਪਣੀਆਂ ਬਲੀਆਂ ਉਨ੍ਹਾਂ ਦੇ ਅੱਗੇ ਨਾ ਚੜ੍ਹਾਉਣ। ਇਹ ਉਨ੍ਹਾਂ ਦੇ ਲਈ ਉਨ੍ਹਾਂ ਦੀ ਪੀੜ੍ਹੀਆਂ ਤੱਕ ਇੱਕ ਸਦਾ ਦੀ ਬਿਧੀ ਹੋਵੇਗੀ। ");
INSERT INTO pan_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","ਤੂੰ ਉਨ੍ਹਾਂ ਨੂੰ ਇਹ ਆਖ, ਭਾਵੇਂ ਇਸਰਾਏਲ ਦੇ ਘਰਾਣੇ ਦਾ ਕੋਈ ਮਨੁੱਖ ਹੋਵੇ, ਜਾਂ ਪਰਦੇਸੀਆਂ ਵਿੱਚੋਂ ਜੋ ਤੁਹਾਡੇ ਵਿਚਕਾਰ ਰਹਿੰਦੇ ਹਨ, ਜਿਹੜਾ ਹੋਮ ਬਲੀ ਦੀ ਭੇਟ ਜਾਂ ਸੁੱਖ-ਸਾਂਦ ਦੀ ਭੇਟ ਚੜ੍ਹਾਵੇ, ");
INSERT INTO pan_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","ਅਤੇ ਉਹ ਉਸ ਨੂੰ ਮੰਡਲੀ ਦੇ ਡੇਰੇ ਦੇ ਦਰਵਾਜ਼ੇ ਦੇ ਕੋਲ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਚੜ੍ਹਾਉਣ ਲਈ ਨਾ ਲਿਆਵੇ, ਉਹ ਮਨੁੱਖ ਆਪਣੇ ਲੋਕਾਂ ਵਿੱਚੋਂ ਛੇਕਿਆ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","ਕੋਈ ਵੀ ਮਨੁੱਖ ਭਾਵੇਂ ਇਸਰਾਏਲ ਦੇ ਘਰਾਣੇ ਦਾ ਹੋਵੇ, ਜਾਂ ਪਰਦੇਸੀਆਂ ਵਿੱਚੋਂ ਜੋ ਤੁਹਾਡੇ ਵਿਚਕਾਰ ਵੱਸਦੇ ਹਨ, ਜਿਹੜਾ ਕਿਸੇ ਪ੍ਰਕਾਰ ਦਾ ਲਹੂ ਖਾਵੇ ਤਾਂ ਮੈਂ ਉਸ ਲਹੂ ਖਾਣ ਵਾਲੇ ਮਨੁੱਖ ਦੇ ਵਿਰੁੱਧ ਹੋ ਕੇ ਉਸ ਨੂੰ ਉਸ ਦੇ ਲੋਕਾਂ ਵਿੱਚੋਂ ਨਾਸ ਕਰ ਦਿਆਂਗਾ। ");
INSERT INTO pan_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","ਕਿਉਂ ਜੋ ਸਰੀਰ ਦੀ ਜਾਨ ਉਸ ਦੇ ਲਹੂ ਵਿੱਚ ਹੈ ਅਤੇ ਮੈਂ ਉਸ ਨੂੰ ਜਗਵੇਦੀ ਦੇ ਉੱਤੇ ਤੁਹਾਡੇ ਪ੍ਰਾਣਾਂ ਦੇ ਪ੍ਰਾਸਚਿਤ ਕਰਨ ਲਈ ਦਿੱਤਾ ਹੈ, ਕਿਉਂਕਿ ਪ੍ਰਾਣਾਂ ਦੇ ਲਈ ਲਹੂ ਨਾਲ ਹੀ ਪ੍ਰਾਸਚਿਤ ਹੁੰਦਾ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","ਇਸ ਲਈ ਮੈਂ ਇਸਰਾਏਲੀਆਂ ਨੂੰ ਆਖਦਾ ਹਾਂ, ਕਿ ਤੁਹਾਡੇ ਵਿੱਚੋਂ ਕੋਈ ਮਨੁੱਖ ਲਹੂ ਨਾ ਖਾਵੇ, ਨਾ ਹੀ ਕੋਈ ਪਰਦੇਸੀ ਜੋ ਤੁਹਾਡੇ ਵਿਚਕਾਰ ਵੱਸਦਾ ਹੈ, ਲਹੂ ਖਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","ਕੋਈ ਵੀ ਮਨੁੱਖ ਭਾਵੇਂ ਇਸਰਾਏਲੀਆਂ ਵਿੱਚੋਂ ਜਾਂ ਉਨ੍ਹਾਂ ਪਰਦੇਸੀਆਂ ਵਿੱਚੋਂ ਜੋ ਤੁਹਾਡੇ ਵਿਚਕਾਰ ਵੱਸਦੇ ਹਨ, ਜਿਹੜਾ ਸ਼ਿਕਾਰ ਕਰਕੇ ਕਿਸੇ ਖਾਣ ਯੋਗ ਪਸ਼ੂ ਜਾਂ ਪੰਛੀ ਨੂੰ ਫੜ੍ਹੇ ਤਾਂ ਉਹ ਉਸ ਦੇ ਲਹੂ ਨੂੰ ਡੋਲ੍ਹ ਕੇ ਮਿੱਟੀ ਨਾਲ ਢੱਕ ਦੇਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","ਕਿਉਂ ਜੋ ਸਾਰੇ ਸਰੀਰਾਂ ਦਾ ਪ੍ਰਾਣ ਉਨ੍ਹਾਂ ਦੇ ਲਹੂ ਵਿੱਚ ਹੀ ਵੱਸਦਾ ਹੈ, ਇਸ ਲਈ ਮੈਂ ਇਸਰਾਏਲੀਆਂ ਨੂੰ ਆਖਦਾ ਹਾਂ, ਤੁਸੀਂ ਕਿਸੇ ਪ੍ਰਕਾਰ ਦਾ ਮਾਸ ਲਹੂ ਸਮੇਤ ਨਾ ਖਾਣਾ, ਕਿਉਂ ਜੋ ਸਾਰੇ ਸਰੀਰਾਂ ਦੀ ਜਾਨ ਉਨ੍ਹਾਂ ਦੇ ਲਹੂ ਵਿੱਚ ਹੀ ਹੈ। ਕੋਈ ਵੀ ਜਿਹੜਾ ਉਸ ਨੂੰ ਖਾਵੇ, ਉਹ ਛੇਕਿਆ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","ਅਤੇ ਕੋਈ ਵੀ ਮਨੁੱਖ ਜਿਹੜਾ ਆਪਣੇ ਦੇਸ ਦਾ ਹੋਵੇ ਜਾਂ ਪਰਦੇਸੀ, ਉਸ ਜੀਵ ਨੂੰ ਖਾਵੇ, ਜਿਹੜਾ ਆਪਣੇ ਆਪ ਮਰ ਗਿਆ ਹੋਵੇ, ਜਾਂ ਦੂਜੇ ਪਸ਼ੂਆਂ ਦੁਆਰਾ ਮਾਰਿਆ ਗਿਆ ਹੋਵੇ ਉਹ ਆਪਣੇ ਕੱਪੜੇ ਧੋਵੇ ਅਤੇ ਪਾਣੀ ਨਾਲ ਨਹਾਵੇ, ਉਹ ਸ਼ਾਮ ਤੱਕ ਅਸ਼ੁੱਧ ਰਹੇ। ਫੇਰ ਉਹ ਸ਼ੁੱਧ ਠਹਿਰੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","ਪਰ ਜੇਕਰ ਉਹ ਆਪਣੇ ਕੱਪੜੇ ਨਾ ਧੋਵੇ ਅਤੇ ਨਾ ਨਹਾਵੇ ਤਾਂ ਉਸ ਦਾ ਦੋਸ਼ ਉਸੇ ਦੇ ਜੁੰਮੇ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","ਫੇਰ ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਆਖਿਆ, ");
INSERT INTO pan_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","ਇਸਰਾਏਲੀਆਂ ਨਾਲ ਗੱਲ ਕਰ ਕੇ ਆਖ, ਮੈਂ ਯਹੋਵਾਹ ਤੁਹਾਡਾ ਪਰਮੇਸ਼ੁਰ ਹਾਂ। ");
INSERT INTO pan_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","ਤੁਸੀਂ ਮਿਸਰ ਦੇ ਦੇਸ ਦੇ ਕੰਮਾਂ ਦੇ ਅਨੁਸਾਰ ਨਾ ਕਰਨਾ, ਜਿਸ ਦੇ ਵਿੱਚ ਤੁਸੀਂ ਵੱਸਦੇ ਸੀ ਅਤੇ ਨਾ ਕਨਾਨ ਦੇ ਕੰਮਾਂ ਦੇ ਅਨੁਸਾਰ ਕਰਨਾ, ਜਿੱਥੇ ਮੈਂ ਤੁਹਾਨੂੰ ਲੈ ਕੇ ਜਾ ਰਿਹਾ ਹਾਂ, ਨਾ ਹੀ ਤੁਸੀਂ ਉਨ੍ਹਾਂ ਦੀਆਂ ਰੀਤਾਂ ਅਨੁਸਾਰ ਚੱਲਣਾ। ");
INSERT INTO pan_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","ਤੁਸੀਂ ਮੇਰੇ ਹੀ ਨਿਯਮਾਂ ਨੂੰ ਮੰਨਣਾ ਅਤੇ ਮੇਰੀਆਂ ਹੀ ਬਿਧੀਆਂ ਨੂੰ ਮੰਨ ਕੇ ਉਨ੍ਹਾਂ ਦੇ ਅਨੁਸਾਰ ਚੱਲਣਾ, ਮੈਂ ਯਹੋਵਾਹ ਤੁਹਾਡਾ ਪਰਮੇਸ਼ੁਰ ਹਾਂ। ");
INSERT INTO pan_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","ਇਸ ਲਈ ਤੁਸੀਂ ਮੇਰੀਆਂ ਬਿਧੀਆਂ ਅਤੇ ਨਿਯਮਾਂ ਦੀ ਪਾਲਣਾ ਕਰਨਾ। ਜਿਹੜਾ ਇਨ੍ਹਾਂ ਦੀ ਪਾਲਣਾ ਕਰੇਗਾ, ਉਹ ਇਨ੍ਹਾਂ ਦੇ ਕਾਰਨ ਜੀਉਂਦਾ ਰਹੇਗਾ। ਮੈਂ ਹੀ ਯਹੋਵਾਹ ਹਾਂ। ");
INSERT INTO pan_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","ਤੁਹਾਡੇ ਵਿੱਚੋਂ ਕੋਈ ਆਪਣੇ ਨਜ਼ਦੀਕੀ ਰਿਸ਼ਤੇਦਾਰ ਦਾ ਨੰਗੇਜ਼ ਉਘਾੜਨ ਲਈ ਉਨ੍ਹਾਂ ਦੇ ਕੋਲ ਨਾ ਜਾਵੇ। ਮੈਂ ਯਹੋਵਾਹ ਹਾਂ। ");
INSERT INTO pan_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","ਤੂੰ ਆਪਣੇ ਪਿਤਾ ਦਾ ਨੰਗੇਜ਼ ਅਤੇ ਆਪਣੀ ਮਾਂ ਦਾ ਨੰਗੇਜ਼ ਨਾ ਉਘਾੜੀਂ, ਉਹ ਤੇਰੀ ਮਾਂ ਹੈ, ਤੂੰ ਉਸ ਦਾ ਨੰਗੇਜ਼ ਨਾ ਉਘਾੜੀਂ। ");
INSERT INTO pan_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","ਤੂੰ ਆਪਣੀ ਸੌਤੇਲੀ ਮਾਂ ਦਾ ਨੰਗੇਜ਼ ਨਾ ਉਘਾੜੀਂ, ਇਹ ਤਾਂ ਤੇਰੇ ਪਿਤਾ ਦਾ ਹੀ ਨੰਗੇਜ਼ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","ਤੂੰ ਆਪਣੀ ਭੈਣ ਭਾਵੇਂ ਉਹ ਤੇਰੀ ਸੱਕੀ ਭੈਣ ਹੋਵੇ ਜਾਂ ਸੌਤੇਲੀ, ਭਾਵੇਂ ਘਰ ਵਿੱਚ ਜੰਮੀ ਹੋਏ ਭਾਵੇਂ ਬਾਹਰ, ਤੂੰ ਉਸ ਦਾ ਨੰਗੇਜ਼ ਨਾ ਉਘਾੜੀਂ। ");
INSERT INTO pan_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","ਤੂੰ ਆਪਣੀ ਪੋਤਰੀ ਜਾਂ ਆਪਣੀ ਦੋਤਰੀ ਦਾ ਨੰਗੇਜ਼ ਨਾ ਉਘਾੜੀਂ, ਕਿਉਂ ਜੋ ਉਨ੍ਹਾਂ ਦਾ ਨੰਗੇਜ਼ ਤਾਂ ਤੇਰਾ ਆਪਣਾ ਹੀ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","ਤੂੰ ਆਪਣੀ ਸੌਤੇਲੀ ਭੈਣ ਦਾ, ਜੋ ਤੇਰੇ ਪਿਤਾ ਤੋਂ ਜੰਮੀ ਹੈ, ਉਸ ਦਾ ਨੰਗੇਜ਼ ਨਾ ਉਘਾੜੀਂ, ਕਿਉਂ ਜੋ ਉਹ ਤੇਰੀ ਭੈਣ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","ਤੂੰ ਆਪਣੇ ਪਿਤਾ ਦੀ ਭੈਣ ਦਾ ਨੰਗੇਜ਼ ਨਾ ਉਘਾੜੀਂ, ਉਹ ਤੇਰੇ ਪਿਤਾ ਦੀ ਨਜ਼ਦੀਕੀ ਰਿਸ਼ਤੇਦਾਰ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","ਤੂੰ ਆਪਣੀ ਮਾਂ ਦੀ ਭੈਣ ਦਾ ਨੰਗੇਜ਼ ਨਾ ਉਘਾੜੀਂ, ਕਿਉਂ ਜੋ ਉਹ ਤੇਰੀ ਮਾਂ ਦੀ ਨਜ਼ਦੀਕੀ ਰਿਸ਼ਤੇਦਾਰ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","ਤੂੰ ਆਪਣੇ ਪਿਤਾ ਦੇ ਭਰਾ ਦਾ ਨੰਗੇਜ਼ ਨਾ ਉਘਾੜੀਂ, ਨਾ ਤੂੰ ਉਸ ਦੀ ਪਤਨੀ ਕੋਲ ਜਾਵੀਂ, ਉਹ ਤਾਂ ਤੇਰੀ ਚਾਚੀ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","ਤੂੰ ਆਪਣੀ ਨੂੰਹ ਦਾ ਨੰਗੇਜ਼ ਨਾ ਉਘਾੜੀਂ, ਉਹ ਤੇਰੇ ਪੁੱਤਰ ਦੀ ਪਤਨੀ ਹੈ, ਇਸ ਲਈ ਤੂੰ ਉਸ ਦਾ ਨੰਗੇਜ਼ ਨਾ ਉਘਾੜੀਂ। ");
INSERT INTO pan_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","ਤੂੰ ਆਪਣੇ ਭਰਾ ਦੀ ਪਤਨੀ ਦਾ ਨੰਗੇਜ਼ ਨਾ ਉਘਾੜੀਂ, ਉਹ ਤਾਂ ਤੇਰੇ ਭਰਾ ਦਾ ਨੰਗੇਜ਼ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","ਤੂੰ ਕਿਸੇ ਇਸਤਰੀ ਅਤੇ ਉਸ ਦੀ ਧੀ ਦਾ ਨੰਗੇਜ਼ ਨਾ ਉਘਾੜੀਂ, ਨਾ ਤੂੰ ਉਸ ਦੀ ਪੋਤਰੀ ਨੂੰ ਜਾਂ ਉਸ ਦੀ ਦੋਤਰੀ ਨੂੰ ਉਸ ਦਾ ਨੰਗੇਜ਼ ਉਘਾੜਨ ਲਈ ਲਿਆਵੀਂ, ਕਿਉਂ ਜੋ ਉਹ ਉਸ ਦੀ ਨਜ਼ਦੀਕੀ ਰਿਸ਼ਤੇਦਾਰ ਹੈ, ਅਜਿਹਾ ਕਰਨਾ ਦੁਸ਼ਟਤਾ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","ਤੂੰ ਆਪਣੀ ਪਤਨੀ ਨੂੰ ਦੁੱਖ ਦੇਣ ਲਈ, ਉਸ ਦੀ ਭੈਣ ਨੂੰ ਉਸ ਦਾ ਨੰਗੇਜ਼ ਉਘਾੜਨ ਲਈ ਨਾ ਵਿਆਹਵੀਂ ਜਦ ਕਿ ਤੇਰੀ ਪਹਿਲੀ ਪਤਨੀ ਅਜੇ ਜੀਉਂਦੀ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","ਜਦ ਤੱਕ ਕੋਈ ਇਸਤਰੀ ਆਪਣੀ ਮਾਹਵਾਰੀ ਕਾਰਨ ਅਸ਼ੁੱਧ ਹੈ, ਤਾਂ ਤੂੰ ਉਸ ਦਾ ਨੰਗੇਜ਼ ਉਘਾੜਨ ਲਈ ਉਸ ਦੇ ਕੋਲ ਨਾ ਜਾਵੀਂ। ");
INSERT INTO pan_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","ਤੂੰ ਆਪਣੇ ਗੁਆਂਢੀ ਦੀ ਪਤਨੀ ਨਾਲ ਸੰਗ ਕਰਕੇ ਆਪਣੇ ਆਪ ਨੂੰ ਭਰਿਸ਼ਟ ਨਾ ਕਰੀਂ। ");
INSERT INTO pan_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","ਅਤੇ ਤੂੰ ਆਪਣੇ ਪੁੱਤਰਾਂ ਵਿੱਚੋਂ ਕਿਸੇ ਨੂੰ ਮੋਲਕ ਦੇਵਤੇ ਦੇ ਅੱਗੇ ਅੱਗ ਦੇ ਵਿੱਚੋਂ ਨਾ ਲੰਘਾਵੀਂ, ਨਾ ਤੂੰ ਆਪਣੇ ਪਰਮੇਸ਼ੁਰ ਦੇ ਨਾਮ ਨੂੰ ਬਦਨਾਮ ਕਰੀਂ, ਮੈਂ ਯਹੋਵਾਹ ਹਾਂ। ");
INSERT INTO pan_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","ਜਿਸ ਤਰ੍ਹਾਂ ਤੂੰ ਇਸਤਰੀ ਨਾਲ ਸੰਗ ਕਰਦਾ ਹੈਂ, ਉਸੇ ਤਰ੍ਹਾਂ ਕਿਸੇ ਪੁਰਖ ਦੇ ਨਾਲ ਸੰਗ ਨਾ ਕਰੀਂ, ਇਹ ਘਿਣਾਉਣਾ ਕੰਮ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","ਤੂੰ ਕਿਸੇ ਪਸ਼ੂ ਦੇ ਨਾਲ ਸੰਗ ਕਰਕੇ ਆਪਣੇ ਆਪ ਨੂੰ ਭਰਿਸ਼ਟ ਨਾ ਕਰੀਂ ਅਤੇ ਨਾ ਕੋਈ ਇਸਤਰੀ ਕਿਸੇ ਪਸ਼ੂ ਦੇ ਅੱਗੇ ਜਾ ਕੇ ਖੜ੍ਹੀ ਹੋਵੇ ਤਾਂ ਜੋ ਉਸ ਤੋਂ ਸੰਗ ਕਰਵਾਏ, ਇਹ ਘਿਣਾਉਣਾ ਕੰਮ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","ਅਜਿਹਾ ਕੋਈ ਵੀ ਕੰਮ ਕਰਕੇ ਤੁਸੀਂ ਆਪਣੇ ਆਪ ਨੂੰ ਅਸ਼ੁੱਧ ਨਾ ਕਰਨਾ, ਕਿਉਂ ਜੋ ਉਹ ਸਾਰੀਆਂ ਕੌਮਾਂ ਜਿਨ੍ਹਾਂ ਨੂੰ ਮੈਂ ਤੁਹਾਡੇ ਅੱਗਿਓਂ ਕੱਢਣ ਵਾਲਾ ਹਾਂ, ਅਜਿਹੇ ਹੀ ਕੰਮ ਕਰਕੇ ਭਰਿਸ਼ਟ ਹੋ ਗਈਆਂ ਹਨ, ");
INSERT INTO pan_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","ਅਤੇ ਧਰਤੀ ਵੀ ਅਸ਼ੁੱਧ ਹੋ ਗਈ ਹੈ, ਇਸ ਲਈ ਮੈਂ ਉਨ੍ਹਾਂ ਨੂੰ ਉਨ੍ਹਾਂ ਦੀ ਬਦੀ ਦਾ ਬਦਲਾ ਦਿੰਦਾ ਹਾਂ ਅਤੇ ਉਹ ਧਰਤੀ ਵੀ ਆਪਣੇ ਵਾਸੀਆਂ ਨੂੰ ਉਗਲ ਦਿੰਦੀ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","ਇਸ ਲਈ ਤੁਸੀਂ ਮੇਰੀਆਂ ਬਿਧੀਆਂ ਅਤੇ ਨਿਯਮਾਂ ਦੀ ਸਦਾ ਪਾਲਣਾ ਕਰਨਾ ਅਤੇ ਭਾਵੇਂ ਆਪਣੇ ਦੇਸ ਦਾ ਭਾਵੇਂ ਪਰਦੇਸੀ ਜਿਹੜਾ ਤੁਹਾਡੇ ਵਿਚਕਾਰ ਵੱਸਦਾ ਹੈ, ਕੋਈ ਵੀ ਅਜਿਹੇ ਘਿਣਾਉਣੇ ਕੰਮ ਨਾ ਕਰੇ। ");
INSERT INTO pan_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","ਕਿਉਂ ਜੋ ਅਜਿਹੇ ਘਿਣਾਉਣੇ ਕੰਮ ਕਰਕੇ ਹੀ ਉਸ ਦੇਸ ਦੇ ਵਾਸੀਆਂ ਨੇ ਜੋ ਉੱਥੇ ਰਹਿੰਦੇ ਸਨ, ਉਸ ਧਰਤੀ ਨੂੰ ਅਸ਼ੁੱਧ ਕਰ ਦਿੱਤਾ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","ਅਜਿਹਾ ਨਾ ਹੋਵੇ ਕਿ ਜਿਵੇਂ ਉਸ ਧਰਤੀ ਨੇ ਉਨ੍ਹਾਂ ਕੌਮਾਂ ਨੂੰ ਉਗਲ ਦਿੱਤਾ, ਜਿਹੜੀਆਂ ਤੁਹਾਡੇ ਤੋਂ ਪਹਿਲਾਂ ਉੱਥੇ ਸਨ, ਉਸੇ ਤਰ੍ਹਾਂ ਹੀ ਉਹ ਤੁਹਾਨੂੰ ਵੀ ਉਗਲ ਦੇਵੇ, ਜਦ ਤੁਸੀਂ ਅਸ਼ੁੱਧਤਾਈ ਦੇ ਕੰਮ ਕਰੋ। ");
INSERT INTO pan_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","ਜਿਹੜੇ ਵੀ ਲੋਕ ਅਜਿਹੇ ਘਿਣਾਉਣੇ ਕੰਮ ਕਰਨ ਉਹ ਆਪਣੇ ਲੋਕਾਂ ਵਿੱਚੋਂ ਛੇਕੇ ਜਾਣ। ");
INSERT INTO pan_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","ਇਸ ਲਈ ਤੁਸੀਂ ਮੇਰੇ ਹੁਕਮਾਂ ਨੂੰ ਮੰਨਣਾ ਅਤੇ ਜੋ ਘਿਣਾਉਣੀਆਂ ਰੀਤਾਂ ਤੁਹਾਡੇ ਤੋਂ ਪਹਿਲਾਂ ਉੱਥੇ ਮੰਨੀਆਂ ਜਾਂਦੀਆਂ ਹਨ, ਉਨ੍ਹਾਂ ਦੇ ਅਨੁਸਾਰ ਨਾ ਚੱਲਣਾ ਅਤੇ ਨਾ ਉਨ੍ਹਾਂ ਦੇ ਕਾਰਨ ਆਪਣੇ ਆਪ ਨੂੰ ਅਸ਼ੁੱਧ ਕਰਨਾ। ਮੈਂ ਯਹੋਵਾਹ ਤੁਹਾਡਾ ਪਰਮੇਸ਼ੁਰ ਹਾਂ। ");
INSERT INTO pan_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","ਤਦ ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਆਖਿਆ, ");
INSERT INTO pan_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","ਇਸਰਾਏਲੀਆਂ ਦੀ ਸਾਰੀ ਮੰਡਲੀ ਨੂੰ ਆਖ, ਤੁਸੀਂ ਪਵਿੱਤਰ ਬਣੋ ਕਿਉਂ ਜੋ ਮੈਂ ਯਹੋਵਾਹ ਤੁਹਾਡਾ ਪਰਮੇਸ਼ੁਰ ਪਵਿੱਤਰ ਹਾਂ। ");
INSERT INTO pan_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","ਤੁਸੀਂ ਆਪਣੇ-ਆਪਣੇ ਮਾਤਾ ਅਤੇ ਪਿਤਾ ਦਾ ਆਦਰ ਕਰਨਾ। ਤੁਸੀਂ ਮੇਰੇ ਸਬਤਾਂ ਨੂੰ ਮੰਨਣਾ। ਮੈਂ ਯਹੋਵਾਹ ਤੁਹਾਡਾ ਪਰਮੇਸ਼ੁਰ ਹਾਂ। ");
INSERT INTO pan_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","ਤੁਸੀਂ ਮੂਰਤਾਂ ਵੱਲ ਨਾ ਮੁੜਨਾ ਅਤੇ ਨਾ ਹੀ ਆਪਣੇ ਲਈ ਮੂਰਤਾਂ ਢਾਲ਼ ਕੇ ਬਣਾਉਣਾ। ਮੈਂ ਯਹੋਵਾਹ ਤੁਹਾਡਾ ਪਰਮੇਸ਼ੁਰ ਹਾਂ। ");
INSERT INTO pan_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","ਜਦ ਤੁਸੀਂ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਸੁੱਖ-ਸਾਂਦ ਦੀਆਂ ਭੇਟਾਂ ਦੀ ਬਲੀ ਚੜ੍ਹਾਓ, ਤਾਂ ਤੁਸੀਂ ਅਜਿਹੀ ਭੇਟ ਚੜ੍ਹਾਉਣਾ ਜਿਸ ਨੂੰ ਮੈਂ ਸਵੀਕਾਰ ਕਰਾਂ। ");
INSERT INTO pan_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","ਜਿਸ ਦਿਨ ਤੁਸੀਂ ਬਲੀ ਚੜ੍ਹਾਓ, ਉਸ ਦਾ ਮਾਸ ਉਸੇ ਦਿਨ ਅਤੇ ਦੂਜੇ ਦਿਨ ਵੀ ਖਾਓ ਪਰ ਜੋ ਕੁਝ ਤੀਜੇ ਦਿਨ ਤੱਕ ਬਚਿਆ ਰਹੇ, ਉਹ ਅੱਗ ਵਿੱਚ ਸਾੜਿਆ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","ਜੇਕਰ ਉਸ ਵਿੱਚੋਂ ਕੁਝ ਤੀਜੇ ਦਿਨ ਵੀ ਖਾਧਾ ਜਾਵੇ ਤਾਂ ਉਹ ਘਿਣਾਉਣਾ ਹੈ ਅਤੇ ਸਵੀਕਾਰ ਨਹੀਂ ਕੀਤਾ ਜਾਵੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","ਇਸ ਲਈ ਜਿਹੜਾ ਉਸ ਨੂੰ ਖਾਵੇ, ਉਸ ਦਾ ਦੋਸ਼ ਉਸ ਦੇ ਜੁੰਮੇ ਹੋਵੇਗਾ, ਕਿਉਂ ਜੋ ਉਸ ਨੇ ਯਹੋਵਾਹ ਦੀ ਪਵਿੱਤਰ ਵਸਤੂ ਨੂੰ ਭਰਿਸ਼ਟ ਕੀਤਾ ਹੈ, ਅਤੇ ਉਹ ਮਨੁੱਖ ਆਪਣੇ ਲੋਕਾਂ ਵਿੱਚੋਂ ਛੇਕਿਆ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","ਫੇਰ ਜਦ ਤੁਸੀਂ ਆਪਣੇ ਦੇਸ ਦੇ ਖੇਤਾਂ ਦੀ ਵਾਢੀ ਕਰੋ ਤਾਂ ਆਪਣੇ ਖੇਤਾਂ ਦੀਆਂ ਨੁੱਕਰਾਂ ਤੱਕ ਪੂਰੀ ਫ਼ਸਲ ਨਾ ਵੱਢਣਾ ਅਤੇ ਵਾਢੀ ਕੀਤੇ ਹੋਏ ਖੇਤ ਵਿੱਚ ਡਿੱਗੇ ਹੋਏ ਸਿੱਟਿਆਂ ਨੂੰ ਨਾ ਚੁੱਗਣਾ। ");
INSERT INTO pan_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","ਅਤੇ ਤੂੰ ਆਪਣੇ ਦਾਖਾਂ ਦੇ ਬਾਗ਼ਾਂ ਦਾ ਹਰੇਕ ਦਾਣਾ ਨਾ ਤੋੜੀਂ, ਅਤੇ ਆਪਣੇ ਦਾਖਾਂ ਦੇ ਬਾਗ਼ਾਂ ਵਿੱਚ ਡਿੱਗੇ ਹੋਏ ਅੰਗੂਰਾਂ ਨੂੰ ਨਾ ਚੁੱਕੀਂ, ਤੂੰ ਉਨ੍ਹਾਂ ਨੂੰ ਕੰਗਾਲ ਅਤੇ ਪਰਦੇਸੀਆਂ ਲਈ ਛੱਡ ਦੇਵੀਂ। ਮੈਂ ਯਹੋਵਾਹ ਤੁਹਾਡਾ ਪਰਮੇਸ਼ੁਰ ਹਾਂ। ");
INSERT INTO pan_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","ਤੁਸੀਂ ਚੋਰੀ ਨਾ ਕਰਨਾ, ਨਾ ਛਲ ਕਰਨਾ ਅਤੇ ਨਾ ਆਪਸ ਵਿੱਚ ਝੂਠ ਬੋਲਣਾ। ");
INSERT INTO pan_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","ਤੁਸੀਂ ਮੇਰਾ ਨਾਮ ਲੈ ਕੇ ਝੂਠੀ ਸਹੁੰ ਨਾ ਚੁੱਕਣਾ ਅਤੇ ਨਾ ਆਪਣੇ ਪਰਮੇਸ਼ੁਰ ਦਾ ਨਾਮ ਬਦਨਾਮ ਕਰਨਾ। ਮੈਂ ਯਹੋਵਾਹ ਹਾਂ। ");
INSERT INTO pan_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","ਤੂੰ ਆਪਣੇ ਗੁਆਂਢੀ ਨਾਲ ਛੱਲ ਨਾ ਕਰੀਂ ਅਤੇ ਨਾ ਹੀ ਉਸ ਨੂੰ ਲੁੱਟੀਂ। ਮਜ਼ਦੂਰ ਦੀ ਮਜ਼ਦੂਰੀ ਤੇਰੇ ਕੋਲ ਸਾਰੀ ਰਾਤ ਸਵੇਰੇ ਤੱਕ ਨਾ ਰਹੇ। ");
INSERT INTO pan_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","ਤੂੰ ਬਹਿਰੇ ਨੂੰ ਗਾਲਾਂ ਨਾ ਕੱਢੀ ਅਤੇ ਨਾ ਅੰਨ੍ਹੇ ਨੂੰ ਠੋਕਰ ਖਿਲਾਵੀਂ ਪਰ ਆਪਣੇ ਪਰਮੇਸ਼ੁਰ ਤੋਂ ਡਰੀਂ। ਮੈਂ ਯਹੋਵਾਹ ਹਾਂ। ");
INSERT INTO pan_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","ਤੁਸੀਂ ਨਿਆਂ ਵਿੱਚ ਕੋਈ ਅਨਿਆਂ ਨਾ ਕਰਨਾ ਅਤੇ ਨਾ ਕੰਗਾਲ ਨਾਲ ਪੱਖਪਾਤ ਕਰੀਂ ਅਤੇ ਨਾ ਹੀ ਵੱਡੇ ਲੋਕਾਂ ਦਾ ਲਿਹਾਜ਼ ਕਰੀਂ, ਪਰ ਤੂੰ ਸਚਿਆਈ ਨਾਲ ਆਪਣੇ ਗੁਆਂਢੀ ਦਾ ਨਿਆਂ ਕਰੀਂ। ");
INSERT INTO pan_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","ਤੂੰ ਆਪਣੇ ਲੋਕਾਂ ਵਿੱਚ ਚੁਗਲਖ਼ੋਰੀ ਕਰਦਾ ਹੋਇਆ ਨਾ ਫਿਰੀਂ। ਤੂੰ ਆਪਣੇ ਗੁਆਂਢੀ ਦਾ ਖੂਨ ਵਹਾਉਣ ਦੀ ਯੋਜਨਾ ਨਾ ਬਣਾਵੀਂ। ਮੈਂ ਯਹੋਵਾਹ ਹਾਂ। ");
INSERT INTO pan_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","ਤੂੰ ਆਪਣੇ ਮਨ ਵਿੱਚ ਆਪਣੇ ਭਰਾ ਨਾਲ ਵੈਰ ਨਾ ਰੱਖੀਂ। ਤੂੰ ਜ਼ਰੂਰ ਹੀ ਆਪਣੇ ਗੁਆਂਢੀ ਦੀ ਤਾੜਨਾ ਕਰੀਂ, ਨਹੀਂ ਤਾਂ ਉਸ ਦਾ ਦੋਸ਼ ਤੇਰੇ ਜੁੰਮੇ ਹੋਵੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","ਤੂੰ ਬਦਲਾ ਨਾ ਲਵੀਂ, ਨਾ ਹੀ ਆਪਣੇ ਲੋਕਾਂ ਦੇ ਪਰਿਵਾਰਾਂ ਨਾਲ ਵੈਰ ਰੱਖੀਂ, ਪਰ ਤੂੰ ਆਪਣੇ ਗੁਆਂਢੀ ਨੂੰ ਆਪਣੇ ਜਿਹਾ ਪਿਆਰ ਕਰੀਂ। ਮੈਂ ਯਹੋਵਾਹ ਹਾਂ। ");
INSERT INTO pan_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","ਤੁਸੀਂ ਮੇਰੀਆਂ ਬਿਧੀਆਂ ਨੂੰ ਮੰਨਣਾ। ਤੂੰ ਆਪਣੇ ਪਸ਼ੂਆਂ ਨੂੰ ਕਿਸੇ ਵੱਖਰੀ ਪ੍ਰਜਾਤੀ ਦੇ ਪਸ਼ੂਆਂ ਨਾਲ ਨਾ ਮਿਲਾਵੀਂ। ਤੂੰ ਆਪਣੇ ਖੇਤ ਵਿੱਚ ਦੋ ਪ੍ਰਕਾਰ ਦਾ ਬੀਜ ਨਾ ਬੀਜੀਂ ਅਤੇ ਕਤਾਨ ਅਤੇ ਉੱਨ ਦਾ ਬਣਿਆ ਹੋਇਆ ਕੱਪੜਾ ਨਾ ਪਾਵੀਂ। ");
INSERT INTO pan_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","ਫੇਰ ਕੋਈ ਇਸਤਰੀ ਜੋ ਦਾਸੀ ਹੋਵੇ ਅਤੇ ਉਸ ਦੀ ਮੰਗਣੀ ਕਿਸੇ ਪੁਰਖ ਨਾਲ ਹੋ ਗਈ ਹੋਵੇ, ਪਰ ਉਹ ਨਾ ਤਾਂ ਛੱਡੀ ਗਈ ਅਤੇ ਨਾ ਹੀ ਅਜ਼ਾਦ ਕੀਤੀ ਗਈ ਹੋਵੇ, ਤਾਂ ਜੇਕਰ ਕੋਈ ਉਸ ਦੇ ਨਾਲ ਸੰਗ ਕਰੇ ਤਾਂ ਉਨ੍ਹਾਂ ਨੂੰ ਬੈਤਾਂ ਨਾਲ ਮਾਰਿਆ ਜਾਵੇ ਪਰ ਉਨ੍ਹਾਂ ਨੂੰ ਜਾਨ ਤੋਂ ਨਾ ਮਾਰਿਆ ਜਾਵੇ, ਕਿਉਂ ਜੋ ਉਹ ਅਜ਼ਾਦ ਨਹੀਂ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","ਉਹ ਪੁਰਖ ਮੰਡਲੀ ਦੇ ਡੇਰੇ ਦੇ ਦਰਵਾਜ਼ੇ ਦੇ ਕੋਲ ਇੱਕ ਭੇਡੂ ਦੋਸ਼ ਬਲੀ ਦੀ ਭੇਟ ਕਰਕੇ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਲੈ ਆਵੇ, ");
INSERT INTO pan_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","ਅਤੇ ਜਾਜਕ ਉਸ ਪਾਪ ਦੇ ਕਾਰਨ ਜੋ ਉਸ ਨੇ ਕੀਤਾ ਹੈ, ਦੋਸ਼ ਬਲੀ ਦੀ ਭੇਟ ਦੇ ਭੇਡੂ ਨੂੰ ਲੈ ਕੇ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਉਸ ਦੇ ਲਈ ਪ੍ਰਾਸਚਿਤ ਕਰੇ, ਤਦ ਉਹ ਪਾਪ ਜੋ ਉਸ ਨੇ ਕੀਤਾ ਹੈ, ਉਸ ਨੂੰ ਮਾਫ਼ ਕੀਤਾ ਜਾਵੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","ਜਦ ਤੁਸੀਂ ਉਸ ਦੇਸ ਵਿੱਚ ਪਹੁੰਚ ਜਾਓ ਅਤੇ ਭਾਂਤ-ਭਾਂਤ ਦੇ ਫਲਾਂ ਦੇ ਰੁੱਖ ਖਾਣ ਦੇ ਲਈ ਲਗਾਓ ਤਾਂ ਤਿੰਨ ਸਾਲ ਤੱਕ ਉਨ੍ਹਾਂ ਦੇ ਫਲਾਂ ਨੂੰ ਅਸੁੰਨਤੀ ਸਮਝਣਾ, ਉਹ ਖਾਧੇ ਨਾ ਜਾਣ। ");
INSERT INTO pan_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","ਪਰ ਚੌਥੇ ਸਾਲ ਵਿੱਚ ਉਨ੍ਹਾਂ ਦਾ ਸਾਰਾ ਫਲ ਯਹੋਵਾਹ ਦੀ ਉਸਤਤ ਕਰਨ ਲਈ ਪਵਿੱਤਰ ਠਹਿਰੇ। ");
INSERT INTO pan_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","ਪੰਜਵੇਂ ਸਾਲ ਵਿੱਚ ਤੁਸੀਂ ਉਨ੍ਹਾਂ ਦੇ ਫਲ ਖਾਣਾ ਤਾਂ ਜੋ ਤੁਹਾਨੂੰ ਉਨ੍ਹਾਂ ਤੋਂ ਬਹੁਤ ਫਲ ਮਿਲੇ। ਮੈਂ ਯਹੋਵਾਹ ਤੁਹਾਡਾ ਪਰਮੇਸ਼ੁਰ ਹਾਂ। ");
INSERT INTO pan_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","ਤੁਸੀਂ ਲਹੂ ਦੇ ਸਮੇਤ ਮਾਸ ਨੂੰ ਨਾ ਖਾਣਾ, ਨਾ ਤੁਸੀਂ ਜਾਦੂ-ਟੋਹਣੇ ਕਰਨਾ ਅਤੇ ਨਾ ਹੀ ਮਹੂਰਤ ਵੇਖਣਾ। ");
INSERT INTO pan_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","ਤੁਸੀਂ ਆਪਣੇ ਸਿਰ ਦੇ ਸਿਰਿਆਂ ਨੂੰ ਨਾ ਮੁਨਾਉਣਾ, ਨਾ ਹੀ ਆਪਣੀ ਦਾੜ੍ਹੀ ਦੇ ਸਿਰਿਆਂ ਨੂੰ ਵਿਗਾੜਨਾ। ");
INSERT INTO pan_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","ਤੁਸੀਂ ਮੁਰਦਿਆਂ ਦੇ ਕਾਰਨ ਆਪਣੇ ਸਰੀਰਾਂ ਨੂੰ ਨਾ ਚੀਰਨਾ, ਨਾ ਆਪਣੇ ਉੱਤੇ ਨਿਸ਼ਾਨੀਆਂ ਬਣਵਾਉਣਾ। ਮੈਂ ਯਹੋਵਾਹ ਹਾਂ। ");
INSERT INTO pan_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","ਤੂੰ ਆਪਣੀ ਧੀ ਨੂੰ ਵੇਸਵਾ ਬਣਾ ਕੇ ਉਸ ਨੂੰ ਭਰਿਸ਼ਟ ਨਾ ਕਰਨਾ, ਅਜਿਹਾ ਨਾ ਹੋਵੇ ਕਿ ਧਰਤੀ ਵੇਸਵਾਵ੍ਰਤੀ ਵਿੱਚ ਡਿੱਗੇ ਅਤੇ ਦੇਸ ਦੁਸ਼ਟਤਾ ਨਾਲ ਭਰ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","ਤੁਸੀਂ ਮੇਰੇ ਸਬਤਾਂ ਨੂੰ ਮੰਨਣਾ ਅਤੇ ਮੇਰੇ ਪਵਿੱਤਰ ਸਥਾਨ ਦਾ ਆਦਰ ਕਰਨਾ। ਮੈਂ ਯਹੋਵਾਹ ਹਾਂ। ");
INSERT INTO pan_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","ਤੁਸੀਂ ਝਾੜਾ-ਫੂਕੀ ਕਰਨ ਵਾਲਿਆਂ ਅਤੇ ਭੂਤ ਕੱਢਣ ਵਾਲਿਆਂ ਵੱਲ ਨਾ ਮੁੜਨਾ ਅਤੇ ਉਨ੍ਹਾਂ ਦੇ ਪਿੱਛੇ ਲੱਗ ਕੇ ਭਰਿਸ਼ਟ ਨਾ ਹੋ ਜਾਣਾ। ਮੈਂ ਯਹੋਵਾਹ ਤੁਹਾਡਾ ਪਰਮੇਸ਼ੁਰ ਹਾਂ। ");
INSERT INTO pan_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","ਤੁਸੀਂ ਧੌਲਿਆਂ ਵਾਲਿਆਂ ਦੇ ਅੱਗੇ ਉੱਠ ਕੇ ਖੜ੍ਹੇ ਹੋਣਾ ਅਤੇ ਬਜ਼ੁਰਗਾਂ ਦਾ ਆਦਰ ਕਰਨਾ ਅਤੇ ਆਪਣੇ ਪਰਮੇਸ਼ੁਰ ਤੋਂ ਡਰਨਾ। ਮੈਂ ਯਹੋਵਾਹ ਹਾਂ। ");
INSERT INTO pan_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","ਜੇਕਰ ਕੋਈ ਪਰਦੇਸੀ ਤੁਹਾਡੇ ਦੇਸ ਵਿੱਚ ਆ ਕੇ ਤੁਹਾਡੇ ਨਾਲ ਵੱਸੇ, ਤਾਂ ਤੁਸੀਂ ਉਸ ਨੂੰ ਦੁੱਖ ਨਾ ਦੇਣਾ। ");
INSERT INTO pan_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","ਅਤੇ ਜੋ ਪਰਦੇਸੀ ਤੁਹਾਡੇ ਵਿਚਕਾਰ ਵੱਸੇ, ਉਹ ਤੁਹਾਡੇ ਲਈ ਆਪਣੇ ਲੋਕਾਂ ਵਰਗਾ ਹੋਵੇ ਅਤੇ ਤੁਸੀਂ ਉਸ ਨੂੰ ਆਪਣੇ ਜਿਹਾ ਪਿਆਰ ਕਰਿਓ ਕਿਉਂ ਜੋ ਤੁਸੀਂ ਵੀ ਮਿਸਰ ਦੇਸ ਵਿੱਚ ਪਰਦੇਸੀ ਸੀ। ਮੈਂ ਯਹੋਵਾਹ ਤੁਹਾਡਾ ਪਰਮੇਸ਼ੁਰ ਹਾਂ। ");
INSERT INTO pan_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","ਤੁਸੀਂ ਨਿਆਂ ਕਰਨ ਵਿੱਚ, ਨਾਪਣ ਵਿੱਚ, ਤੋਲਣ ਵਿੱਚ ਜਾਂ ਮਿਣਨ ਵਿੱਚ ਧੋਖਾ ਨਾ ਕਰਨਾ। ");
INSERT INTO pan_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","ਸੱਚੀ ਤੱਕੜੀ, ਸੱਚੇ ਵੱਟੇ, ਸੱਚਾ ਟੋਪਾ ਅਤੇ ਸੱਚਾ ਕੁੱਪਾ ਤੁਹਾਡੇ ਕੋਲ ਹੋਵੇ। ਮੈਂ ਉਹ ਯਹੋਵਾਹ ਤੁਹਾਡਾ ਪਰਮੇਸ਼ੁਰ ਹਾਂ, ਜੋ ਤੁਹਾਨੂੰ ਮਿਸਰ ਦੇਸ ਵਿੱਚੋਂ ਕੱਢ ਲਿਆਇਆ ਹਾਂ। ");
INSERT INTO pan_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","ਇਸ ਲਈ ਤੁਸੀਂ ਮੇਰੀਆਂ ਸਾਰੀਆਂ ਬਿਧੀਆਂ ਅਤੇ ਸਾਰੇ ਨਿਯਮਾਂ ਨੂੰ ਮੰਨਣਾ ਅਤੇ ਪੂਰਾ ਕਰਨਾ। ਮੈਂ ਯਹੋਵਾਹ ਹਾਂ। ");
INSERT INTO pan_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","ਫੇਰ ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਆਖਿਆ, ");
INSERT INTO pan_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","ਤੂੰ ਇਸਰਾਏਲੀਆਂ ਨੂੰ ਇਹ ਵੀ ਆਖੀਂ, ਜਿਹੜਾ ਭਾਵੇਂ ਇਸਰਾਏਲੀਆਂ ਵਿੱਚੋਂ ਜਾਂ ਉਨ੍ਹਾਂ ਪਰਦੇਸੀਆਂ ਵਿੱਚੋਂ, ਜੋ ਇਸਰਾਏਲ ਵਿੱਚ ਵੱਸਦੇ ਹਨ, ਆਪਣੇ ਵੰਸ਼ ਵਿੱਚੋਂ ਕਿਸੇ ਨੂੰ ਮੋਲਕ ਦੇਵਤੇ ਨੂੰ ਦੇਵੇ, ਤਾਂ ਉਹ ਜ਼ਰੂਰ ਹੀ ਮਾਰਿਆ ਜਾਵੇ। ਦੇਸ ਦੇ ਲੋਕ ਉਸ ਨੂੰ ਪੱਥਰਾਂ ਨਾਲ ਮਾਰ ਸੁੱਟਣ। ");
INSERT INTO pan_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","ਮੈਂ ਉਸ ਮਨੁੱਖ ਦਾ ਵਿਰੋਧੀ ਬਣਾਂਗਾ ਅਤੇ ਉਸ ਨੂੰ ਉਸ ਦੇ ਲੋਕਾਂ ਵਿੱਚੋਂ ਨਾਸ ਕਰਾਂਗਾ ਕਿਉਂ ਜੋ ਉਸ ਨੇ ਮੇਰੇ ਪਵਿੱਤਰ ਸਥਾਨ ਨੂੰ ਅਸ਼ੁੱਧ ਕਰਨ ਅਤੇ ਮੇਰੇ ਪਵਿੱਤਰ ਨਾਮ ਨੂੰ ਬਦਨਾਮ ਕਰਨ ਲਈ ਆਪਣੇ ਵੰਸ਼ ਵਿੱਚੋਂ ਕਿਸੇ ਨੂੰ ਪਰਾਏ ਦੇਵਤੇ ਮੋਲਕ ਦੇ ਅੱਗੇ ਚੜ੍ਹਾਇਆ। ");
INSERT INTO pan_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","ਜੇਕਰ ਉਸ ਦੇਸ ਦੇ ਲੋਕ ਉਸ ਮਨੁੱਖ ਵੱਲੋਂ ਅਣਦੇਖੀ ਕਰਨ, ਜਿਸ ਨੇ ਆਪਣੇ ਵੰਸ਼ ਵਿੱਚੋਂ ਕਿਸੇ ਨੂੰ ਮੋਲਕ ਦੇਵਤੇ ਦੇ ਅੱਗੇ ਚੜ੍ਹਾਇਆ ਅਤੇ ਉਸ ਨੂੰ ਨਾ ਮਾਰਨ, ");
INSERT INTO pan_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","ਤਦ ਮੈਂ ਆਪ ਉਸ ਮਨੁੱਖ ਅਤੇ ਉਸ ਦੇ ਘਰਾਣੇ ਦਾ ਵਿਰੋਧੀ ਬਣਾਂਗਾ ਅਤੇ ਉਸ ਨੂੰ ਅਤੇ ਉਨ੍ਹਾਂ ਸਾਰਿਆਂ ਨੂੰ ਜਿਨ੍ਹਾਂ ਦੇ ਉਸ ਦੇ ਪਿੱਛੇ ਲੱਗ ਕੇ ਮੋਲਕ ਦੇ ਨਾਲ ਵਿਭਚਾਰ ਕੀਤਾ, ਉਨ੍ਹਾਂ ਦੇ ਲੋਕਾਂ ਵਿੱਚੋਂ ਨਾਸ ਕਰ ਦਿਆਂਗਾ। ");
INSERT INTO pan_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","ਅਤੇ ਜਿਹੜਾ ਝਾੜਾ-ਫੂਕੀ ਕਰਨ ਵਾਲਿਆਂ ਜਾਂ ਭੂਤ ਕੱਢਣ ਵਾਲਿਆਂ ਦੇ ਪਿੱਛੇ ਲੱਗ ਕੇ ਵਿਭਚਾਰ ਕਰੇ ਤਾਂ ਮੈਂ ਉਸ ਮਨੁੱਖ ਦਾ ਵਿਰੋਧੀ ਬਣ ਕੇ ਉਸ ਨੂੰ ਉਸ ਦੇ ਲੋਕਾਂ ਵਿੱਚੋਂ ਨਾਸ ਕਰ ਦਿਆਂਗਾ। ");
INSERT INTO pan_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","ਇਸ ਲਈ ਤੁਸੀਂ ਆਪਣੇ ਆਪ ਨੂੰ ਪਵਿੱਤਰ ਕਰੋ ਅਤੇ ਪਵਿੱਤਰ ਬਣੇ ਰਹੋ ਕਿਉਂ ਜੋ ਮੈਂ ਯਹੋਵਾਹ ਤੁਹਾਡਾ ਪਰਮੇਸ਼ੁਰ ਹਾਂ। ");
INSERT INTO pan_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","ਤੁਸੀਂ ਮੇਰੀਆਂ ਬਿਧੀਆਂ ਨੂੰ ਮੰਨਣਾ ਅਤੇ ਉਨ੍ਹਾਂ ਦੀ ਪਾਲਣਾ ਕਰਨਾ। ਮੈਂ ਉਹੋ ਯਹੋਵਾਹ ਹਾਂ ਜੋ ਤੁਹਾਨੂੰ ਪਵਿੱਤਰ ਕਰਦਾ ਹਾਂ। ");
INSERT INTO pan_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","ਜਿਹੜਾ ਆਪਣੇ ਪਿਤਾ ਜਾਂ ਆਪਣੀ ਮਾਂ ਨੂੰ ਫਿਟਕਾਰੇ ਉਹ ਜ਼ਰੂਰ ਹੀ ਮਾਰਿਆ ਜਾਵੇ। ਉਸ ਨੇ ਆਪਣੇ ਪਿਤਾ ਜਾਂ ਆਪਣੀ ਮਾਂ ਨੂੰ ਫਿਟਕਾਰਿਆ, ਇਸ ਲਈ ਉਸ ਦਾ ਖੂਨ ਉਸੇ ਦੇ ਜੁੰਮੇ ਹੋਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","ਜਿਹੜਾ ਕਿਸੇ ਹੋਰ ਮਨੁੱਖ ਦੀ ਪਤਨੀ ਨਾਲ ਵਿਭਚਾਰ ਕਰੇ, ਤਾਂ ਉਹ ਮਨੁੱਖ ਜਿਸ ਨੇ ਆਪਣੇ ਗੁਆਂਢੀ ਦੀ ਪਤਨੀ ਨਾਲ ਵਿਭਚਾਰ ਕੀਤਾ ਅਤੇ ਉਹ ਇਸਤਰੀ ਦੋਵੇਂ ਜ਼ਰੂਰ ਹੀ ਮਾਰੇ ਜਾਣ। ");
INSERT INTO pan_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","ਜਿਹੜਾ ਮਨੁੱਖ ਆਪਣੀ ਸੌਤੇਲੀ ਮਾਂ ਨਾਲ ਸੰਗ ਕਰੇ, ਤਾਂ ਇਸ ਲਈ ਕਿ ਉਸ ਨੇ ਆਪਣੇ ਪਿਤਾ ਦਾ ਨੰਗੇਜ਼ ਉਘਾੜਿਆ ਹੈ, ਉਹ ਦੋਵੇਂ ਜ਼ਰੂਰ ਮਾਰੇ ਜਾਣ ਅਤੇ ਉਨ੍ਹਾਂ ਦਾ ਖੂਨ ਉਨ੍ਹਾਂ ਦੇ ਹੀ ਜੁੰਮੇ ਹੋਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","ਜੇਕਰ ਕੋਈ ਮਨੁੱਖ ਆਪਣੀ ਨੂੰਹ ਨਾਲ ਸੰਗ ਕਰੇ, ਤਾਂ ਉਹ ਦੋਵੇਂ ਜ਼ਰੂਰ ਹੀ ਮਾਰੇ ਜਾਣ ਕਿਉਂ ਜੋ ਉਨ੍ਹਾਂ ਨੇ ਪੁੱਠਾ ਕੰਮ ਕੀਤਾ ਹੈ, ਉਨ੍ਹਾਂ ਦਾ ਖੂਨ ਉਨ੍ਹਾਂ ਦੇ ਹੀ ਜੁੰਮੇ ਹੋਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","ਜਿਸ ਤਰ੍ਹਾਂ ਕੋਈ ਪੁਰਖ ਕਿਸੇ ਇਸਤਰੀ ਨਾਲ ਸੰਗ ਕਰਦਾ ਹੈ, ਜੇਕਰ ਉਹ ਉਸੇ ਤਰ੍ਹਾਂ ਹੀ ਪੁਰਖ ਨਾਲ ਸੰਗ ਕਰੇ ਤਾਂ ਉਨ੍ਹਾਂ ਨੇ ਘਿਣਾਉਣਾ ਕੰਮ ਕੀਤਾ ਹੈ। ਉਹ ਜ਼ਰੂਰ ਹੀ ਮਾਰੇ ਜਾਣ ਅਤੇ ਉਨ੍ਹਾਂ ਦਾ ਖੂਨ ਉਨ੍ਹਾਂ ਦੇ ਹੀ ਜੁੰਮੇ ਹੋਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","ਜੇਕਰ ਕੋਈ ਮਨੁੱਖ ਕਿਸੇ ਇਸਤਰੀ ਅਤੇ ਉਸ ਦੀ ਮਾਂ ਦੋਹਾਂ ਨਾਲ ਵਿਆਹ ਕਰੇ ਤਾਂ ਇਹ ਦੁਸ਼ਟਤਾ ਹੈ, ਉਹ ਮਨੁੱਖ ਅਤੇ ਦੋਵੇਂ ਇਸਤਰੀਆਂ ਅੱਗ ਨਾਲ ਸਾੜੇ ਜਾਣ, ਤਾਂ ਜੋ ਤੁਹਾਡੇ ਵਿਚਕਾਰ ਕੋਈ ਦੁਸ਼ਟਤਾ ਨਾ ਰਹੇ। ");
INSERT INTO pan_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","ਜੇਕਰ ਕੋਈ ਮਨੁੱਖ ਕਿਸੇ ਪਸ਼ੂ ਨਾਲ ਸੰਗ ਕਰੇ ਤਾਂ ਉਹ ਜ਼ਰੂਰ ਮਾਰਿਆ ਜਾਵੇ ਅਤੇ ਤੁਸੀਂ ਪਸ਼ੂ ਨੂੰ ਵੀ ਵੱਢ ਸੁੱਟਣਾ। ");
INSERT INTO pan_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","ਜੇਕਰ ਕੋਈ ਇਸਤਰੀ ਕਿਸੇ ਪਸ਼ੂ ਦੇ ਅੱਗੇ ਆਵੇ ਅਤੇ ਉਸ ਤੋਂ ਸੰਗ ਕਰਵਾਏ ਤਾਂ ਤੂੰ ਉਸ ਇਸਤਰੀ ਨੂੰ ਅਤੇ ਉਸ ਪਸ਼ੂ ਨੂੰ ਵੱਢ ਸੁੱਟਣਾ। ਉਹ ਜ਼ਰੂਰ ਹੀ ਮਾਰੇ ਜਾਣ ਅਤੇ ਉਨ੍ਹਾਂ ਦਾ ਖੂਨ ਉਨ੍ਹਾਂ ਦੇ ਜੁੰਮੇ ਹੋਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","ਜੇਕਰ ਕੋਈ ਮਨੁੱਖ ਆਪਣੀ ਭੈਣ ਦਾ ਭਾਵੇਂ ਉਹ ਉਸ ਦੀ ਸੱਕੀ ਭੈਣ ਹੋਵੇ ਭਾਵੇਂ ਸੌਤੇਲੀ, ਉਸ ਦਾ ਨੰਗੇਜ਼ ਵੇਖੇ ਅਤੇ ਉਸ ਦੀ ਭੈਣ ਵੀ ਉਸਦਾ ਨੰਗੇਜ਼ ਵੇਖੇ ਤਾਂ ਇਹ ਸ਼ਰਮ ਦੀ ਗੱਲ ਹੈ। ਉਹ ਆਪਣੇ ਲੋਕਾਂ ਦੇ ਸਾਹਮਣੇ ਹੀ ਵੱਢੇ ਜਾਣ। ਉਸ ਨੇ ਆਪਣੀ ਭੈਣ ਦਾ ਨੰਗੇਜ਼ ਉਘਾੜਿਆ, ਇਸ ਲਈ ਉਸ ਦਾ ਦੋਸ਼ ਉਸ ਦੇ ਜੁੰਮੇ ਹੋਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","ਜੇਕਰ ਕੋਈ ਮਨੁੱਖ ਕਿਸੇ ਇਸਤਰੀ ਨਾਲ ਉਸ ਦੀ ਮਾਹਵਾਰੀ ਦੇ ਸਮੇਂ ਸੰਗ ਕਰੇ ਅਤੇ ਉਸ ਦਾ ਨੰਗੇਜ਼ ਉਘਾੜੇ ਤਾਂ ਇਸ ਲਈ ਕਿ ਉਸ ਨੇ ਉਹ ਦਾ ਸੁੰਬ ਖੋਲ੍ਹਿਆ ਅਤੇ ਉਹ ਨੇ ਵੀ ਆਪਣੇ ਲਹੂ ਦਾ ਸੁੰਬ ਖੁਲ੍ਹਵਾਇਆ, ਉਹ ਦੋਵੇਂ ਆਪਣੇ ਲੋਕਾਂ ਵਿੱਚੋਂ ਛੇਕੇ ਜਾਣ। ");
INSERT INTO pan_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","ਤੂੰ ਆਪਣੀ ਮਾਂ ਦੀ ਭੈਣ ਅਤੇ ਆਪਣੇ ਪਿਤਾ ਦੀ ਭੈਣ ਦਾ ਨੰਗੇਜ਼ ਨਾ ਉਘਾੜੀਂ, ਕਿਉਂ ਜੋ ਉਹ ਤੇਰੀਆਂ ਨਜ਼ਦੀਕੀ ਰਿਸ਼ਤੇਦਾਰ ਹਨ। ਉਨ੍ਹਾਂ ਦਾ ਦੋਸ਼ ਉਨ੍ਹਾਂ ਦੇ ਹੀ ਜੁੰਮੇ ਹੋਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","ਜੇਕਰ ਕੋਈ ਮਨੁੱਖ ਆਪਣੀ ਚਾਚੀ ਨਾਲ ਸੰਗ ਕਰੇ, ਤਾਂ ਉਸ ਨੇ ਆਪਣੇ ਚਾਚੇ ਦਾ ਨੰਗੇਜ਼ ਉਘਾੜਿਆ ਹੈ। ਉਨ੍ਹਾਂ ਦਾ ਦੋਸ਼ ਉਨ੍ਹਾਂ ਦੇ ਜੁੰਮੇ ਹੋਵੇ ਅਤੇ ਉਹ ਬੇ-ਔਲਾਦ ਮਰਨਗੇ। ");
INSERT INTO pan_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","ਜੇਕਰ ਕੋਈ ਮਨੁੱਖ ਆਪਣੇ ਭਰਾ ਦੀ ਪਤਨੀ ਨੂੰ ਲਵੇ, ਤਾਂ ਇਹ ਘਿਣਾਉਣੀ ਗੱਲ ਹੈ। ਉਸ ਨੇ ਆਪਣੇ ਭਰਾ ਦਾ ਨੰਗੇਜ਼ ਉਘਾੜਿਆ ਹੈ, ਇਸ ਲਈ ਉਹ ਬੇ-ਔਲਾਦ ਰਹਿਣਗੇ। ");
INSERT INTO pan_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","ਇਸ ਲਈ ਤੁਸੀਂ ਮੇਰੀਆਂ ਸਾਰੀਆਂ ਬਿਧੀਆਂ ਅਤੇ ਮੇਰੇ ਸਾਰੇ ਨਿਯਮਾਂ ਨੂੰ ਮੰਨ ਕੇ ਪਾਲਣਾ ਕਰਨਾ ਤਾਂ ਜੋ ਉਹ ਦੇਸ ਜਿਸ ਦੇ ਵਿੱਚ ਵੱਸਣ ਲਈ ਮੈਂ ਤੁਹਾਨੂੰ ਲੈ ਕੇ ਜਾ ਰਿਹਾ ਹਾਂ, ਤੁਹਾਨੂੰ ਉਗਲ ਨਾ ਦੇਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","ਅਤੇ ਜਿਨ੍ਹਾਂ ਕੌਮਾਂ ਨੂੰ ਮੈਂ ਤੁਹਾਡੇ ਅੱਗਿਓਂ ਕੱਢਦਾ ਹਾਂ, ਤੁਸੀਂ ਉਨ੍ਹਾਂ ਦੀਆਂ ਰੀਤਾਂ ਦੇ ਅਨੁਸਾਰ ਨਾ ਚੱਲਣਾ ਕਿਉਂ ਜੋ ਉਨ੍ਹਾਂ ਨੇ ਇਹ ਸਾਰੇ ਬੁਰੇ ਕੰਮ ਕੀਤੇ, ਇਸ ਲਈ ਮੈਂ ਉਨ੍ਹਾਂ ਤੋਂ ਘਿਣ ਕਰਦਾ ਹਾਂ। ");
INSERT INTO pan_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","ਪਰ ਮੈਂ ਤੁਹਾਨੂੰ ਆਖਦਾ ਹਾਂ, ਤੁਸੀਂ ਉਨ੍ਹਾਂ ਦੇ ਦੇਸ ਦੇ ਅਧਿਕਾਰੀ ਬਣੋਗੇ ਅਤੇ ਮੈਂ ਉਹ ਦੇਸ ਜਿੱਥੇ ਦੁੱਧ ਅਤੇ ਸ਼ਹਿਦ ਵਗਦਾ ਹੈ, ਤੁਹਾਨੂੰ ਦੇ ਦਿਆਂਗਾ, ਮੈਂ ਯਹੋਵਾਹ ਤੁਹਾਡਾ ਪਰਮੇਸ਼ੁਰ ਹਾਂ, ਜਿਸ ਨੇ ਤੁਹਾਨੂੰ ਹੋਰਨਾਂ ਲੋਕਾਂ ਤੋਂ ਵੱਖਰੇ ਕੀਤਾ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","ਇਸ ਲਈ ਤੁਸੀਂ ਸ਼ੁੱਧ ਅਤੇ ਅਸ਼ੁੱਧ ਪਸ਼ੂ ਦੇ ਵਿੱਚ ਅਤੇ ਅਸ਼ੁੱਧ ਅਤੇ ਸ਼ੁੱਧ ਪੰਛੀਆਂ ਦੇ ਵਿੱਚ ਭੇਦ ਰੱਖਣਾ ਅਤੇ ਕਿਸੇ ਪਸ਼ੂ ਜਾਂ ਪੰਛੀ ਜਾਂ ਕਿਸੇ ਪ੍ਰਕਾਰ ਦਾ ਜੀਵ ਜੋ ਧਰਤੀ ਉੱਤੇ ਘਿਸਰਦਾ ਹੈ, ਜਿਸ ਨੂੰ ਮੈਂ ਤੁਹਾਡੇ ਲਈ ਅਸ਼ੁੱਧ ਠਹਿਰਾ ਕੇ ਵੱਖਰਾ ਕੀਤਾ ਹੈ, ਉਸ ਦੇ ਕਾਰਨ ਆਪਣੇ ਆਪ ਨੂੰ ਭਰਿਸ਼ਟ ਨਾ ਕਰਨਾ। ");
INSERT INTO pan_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","ਤੁਸੀਂ ਮੇਰੇ ਅੱਗੇ ਪਵਿੱਤਰ ਹੋਵੋ, ਕਿਉਂ ਜੋ ਮੈਂ ਯਹੋਵਾਹ ਪਵਿੱਤਰ ਹਾਂ ਅਤੇ ਮੈਂ ਤੁਹਾਨੂੰ ਹੋਰਨਾਂ ਲੋਕਾਂ ਵਿੱਚੋਂ ਆਪਣਾ ਬਣਾਉਣ ਲਈ ਵੱਖਰਾ ਕੀਤਾ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","ਜੇਕਰ ਕੋਈ ਪੁਰਖ ਜਾਂ ਇਸਤਰੀ ਝਾੜਾ-ਫੂਕੀ ਕਰਨ ਵਾਲੇ ਜਾਂ ਭੂਤ ਕੱਢਣ ਵਾਲੇ ਹੋਣ, ਤਾਂ ਉਹ ਜ਼ਰੂਰ ਹੀ ਮਾਰੇ ਜਾਣ। ਉਨ੍ਹਾਂ ਨੂੰ ਪੱਥਰਾਂ ਨਾਲ ਮਾਰ ਸੁੱਟਣਾ ਅਤੇ ਉਨ੍ਹਾਂ ਦਾ ਖੂਨ ਉਨ੍ਹਾਂ ਦੇ ਜੁੰਮੇ ਹੋਵੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਆਖਿਆ, ਹਾਰੂਨ ਦੇ ਪੁੱਤਰਾਂ ਨਾਲ ਜੋ ਜਾਜਕ ਹਨ, ਗੱਲ ਕਰ ਕੇ ਆਖ, ਕੋਈ ਵੀ ਜਾਜਕ ਆਪਣੇ ਲੋਕਾਂ ਵਿੱਚੋਂ ਕਿਸੇ ਵੀ ਮਰੇ ਹੋਏ ਦੇ ਲਈ ਆਪਣੇ ਆਪ ਨੂੰ ਅਸ਼ੁੱਧ ਨਾ ਕਰੇ, ");
INSERT INTO pan_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","ਪਰ ਸਿਰਫ਼ ਆਪਣੇ ਨਜ਼ਦੀਕੀ ਰਿਸ਼ਤੇਦਾਰਾਂ ਅਰਥਾਤ ਆਪਣੀ ਮਾਂ, ਆਪਣੇ ਪਿਤਾ, ਆਪਣੇ ਪੁੱਤਰ, ਆਪਣੀ ਧੀ, ਆਪਣੇ ਭਰਾ, ");
INSERT INTO pan_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","ਅਤੇ ਆਪਣੀ ਕੁਆਰੀ ਭੈਣ ਦੇ ਲਈ, ਜੋ ਉਸ ਦੀ ਨਜ਼ਦੀਕੀ ਰਿਸ਼ਤੇਦਾਰ ਹੈ ਅਤੇ ਉਸਦਾ ਵਿਆਹ ਨਾ ਹੋਇਆ ਹੋਵੇ ਤਾਂ ਇਨ੍ਹਾਂ ਦੇ ਲਈ ਉਹ ਆਪਣੇ ਆਪ ਨੂੰ ਅਸ਼ੁੱਧ ਕਰ ਸਕਦਾ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","ਉਹ ਆਪਣੇ ਲੋਕਾਂ ਦੇ ਕਾਰਨ ਆਪਣੇ ਆਪ ਨੂੰ ਅਸ਼ੁੱਧ ਨਾ ਕਰੇ ਕਿ ਉਹ ਅਪਵਿੱਤਰ ਹੋ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","ਉਹ ਆਪਣੇ ਸਿਰ ਨਾ ਮੁਨਾਉਣ, ਨਾ ਆਪਣੀ ਦਾੜ੍ਹੀ ਦੇ ਸਿਰੇ ਮੁਨਾਉਣ ਅਤੇ ਨਾ ਹੀ ਆਪਣੇ ਸਰੀਰਾਂ ਨੂੰ ਚੀਰੇ ਲਗਵਾਉਣ। ");
INSERT INTO pan_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","ਉਹ ਆਪਣੇ ਪਰਮੇਸ਼ੁਰ ਅੱਗੇ ਪਵਿੱਤਰ ਹੋਣ ਅਤੇ ਆਪਣੇ ਪਰਮੇਸ਼ੁਰ ਦਾ ਨਾਮ ਬਦਨਾਮ ਨਾ ਕਰਨ ਕਿਉਂ ਜੋ ਉਹ ਯਹੋਵਾਹ ਦੀਆਂ ਅੱਗ ਦੀਆਂ ਭੇਟਾਂ ਅਤੇ ਆਪਣੇ ਪਰਮੇਸ਼ੁਰ ਦੀ ਰੋਟੀ ਚੜ੍ਹਾਉਂਦੇ ਹਨ, ਇਸ ਲਈ ਉਹ ਪਵਿੱਤਰ ਰਹਿਣ। ");
INSERT INTO pan_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","ਉਹ ਕਿਸੇ ਵੇਸਵਾ ਜਾਂ ਭਰਿਸ਼ਟ ਇਸਤਰੀ ਨਾਲ ਵਿਆਹ ਨਾ ਕਰਨ, ਨਾ ਹੀ ਉਹ ਆਪਣੇ ਪਤੀ ਵੱਲੋਂ ਤਿਆਗੀ ਹੋਈ ਕਿਸੇ ਇਸਤਰੀ ਨੂੰ ਵਿਆਹੁਣ, ਕਿਉਂ ਜੋ ਉਹ ਆਪਣੇ ਪਰਮੇਸ਼ੁਰ ਦੇ ਅੱਗੇ ਪਵਿੱਤਰ ਹਨ। ");
INSERT INTO pan_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","ਇਸ ਲਈ ਤੂੰ ਉਸ ਨੂੰ ਪਵਿੱਤਰ ਕਰੀਂ, ਕਿਉਂ ਜੋ ਉਹ ਤੇਰੇ ਪਰਮੇਸ਼ੁਰ ਦੀ ਰੋਟੀ ਚੜ੍ਹਾਉਂਦਾ ਹੈ। ਤੂੰ ਉਸ ਨੂੰ ਪਵਿੱਤਰ ਜਾਣੀ ਕਿਉਂ ਜੋ ਮੈਂ ਯਹੋਵਾਹ ਪਵਿੱਤਰ ਹਾਂ, ਜੋ ਤੁਹਾਨੂੰ ਪਵਿੱਤਰ ਕਰਦਾ ਹਾਂ। ");
INSERT INTO pan_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","ਜੇਕਰ ਕਿਸੇ ਜਾਜਕ ਦੀ ਧੀ ਵੇਸਵਾ ਬਣ ਕੇ ਆਪਣੇ ਆਪ ਨੂੰ ਭਰਿਸ਼ਟ ਕਰੇ ਤਾਂ ਉਹ ਆਪਣੇ ਪਿਤਾ ਨੂੰ ਬਦਨਾਮ ਕਰਦੀ ਹੈ, ਇਸ ਲਈ ਉਹ ਅੱਗ ਨਾਲ ਸਾੜੀ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","ਉਹ ਜੋ ਆਪਣੇ ਭਰਾਵਾਂ ਵਿੱਚ ਪ੍ਰਧਾਨ ਜਾਜਕ ਹੈ, ਜਿਸ ਦੇ ਸਿਰ ਉੱਤੇ ਮਸਹ ਕਰਨ ਦਾ ਤੇਲ ਪਾਇਆ ਗਿਆ ਹੈ ਅਤੇ ਜੋ ਪਵਿੱਤਰ ਬਸਤਰ ਪਾਉਣ ਲਈ ਥਾਪਿਆ ਹੈ, ਉਹ ਆਪਣਾ ਸਿਰ ਨੰਗਾ ਨਾ ਕਰੇ ਅਤੇ ਨਾ ਹੀ ਆਪਣੇ ਬਸਤਰ ਪਾੜੇ। ");
INSERT INTO pan_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","ਉਹ ਕਿਸੇ ਲਾਸ਼ ਦੇ ਕੋਲ ਨਾ ਜਾਵੇ ਅਤੇ ਨਾ ਹੀ ਆਪਣੇ ਪਿਤਾ ਜਾਂ ਆਪਣੀ ਮਾਤਾ ਦੇ ਕਾਰਨ ਆਪਣੇ ਆਪ ਨੂੰ ਅਸ਼ੁੱਧ ਕਰੇ। ");
INSERT INTO pan_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","ਉਹ ਪਵਿੱਤਰ ਸਥਾਨ ਤੋਂ ਬਾਹਰ ਨਾ ਨਿੱਕਲੇ ਅਤੇ ਨਾ ਆਪਣੇ ਪਰਮੇਸ਼ੁਰ ਦੇ ਪਵਿੱਤਰ ਸਥਾਨ ਨੂੰ ਭਰਿਸ਼ਟ ਕਰੇ, ਕਿਉਂ ਜੋ ਉਸ ਦੇ ਸਿਰ ਉੱਤੇ ਪਰਮੇਸ਼ੁਰ ਦੇ ਮਸਹ ਕੀਤੇ ਹੋਏ ਤੇਲ ਦਾ ਮੁਕਟ ਹੈ। ਮੈਂ ਯਹੋਵਾਹ ਹਾਂ। ");
INSERT INTO pan_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","ਉਹ ਕੁਆਰੀ ਇਸਤਰੀ ਨਾਲ ਹੀ ਵਿਆਹ ਕਰੇ। ");
INSERT INTO pan_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","ਉਹ ਕਿਸੇ ਵਿਧਵਾ, ਜਾਂ ਛੱਡੀ ਹੋਈ, ਜਾਂ ਭਰਿਸ਼ਟ ਜਾਂ ਵੇਸਵਾ ਇਸਤਰੀ ਨਾਲ ਵਿਆਹ ਨਾ ਕਰੇ, ਪਰ ਉਹ ਆਪਣੇ ਲੋਕਾਂ ਵਿੱਚੋਂ ਇੱਕ ਕੁਆਰੀ ਇਸਤਰੀ ਨਾਲ ਹੀ ਵਿਆਹ ਕਰੇ। ");
INSERT INTO pan_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","ਉਹ ਆਪਣੇ ਲੋਕਾਂ ਵਿੱਚ, ਆਪਣੇ ਵੰਸ਼ ਨੂੰ ਭਰਿਸ਼ਟ ਨਾ ਕਰੇ, ਕਿਉਂ ਜੋ ਮੈਂ ਯਹੋਵਾਹ ਉਸ ਨੂੰ ਪਵਿੱਤਰ ਠਹਿਰਾਉਂਦਾ ਹਾਂ। ");
INSERT INTO pan_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","ਫੇਰ ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਆਖਿਆ, ");
INSERT INTO pan_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","ਹਾਰੂਨ ਨੂੰ ਆਖ, ਤੇਰੀ ਵੰਸ਼ ਵਿੱਚ ਪੀੜ੍ਹੀਓਂ ਪੀੜ੍ਹੀ ਤੱਕ ਜਿਸ ਕਿਸੇ ਵਿੱਚ ਕੋਈ ਦੋਸ਼ ਹੋਵੇ, ਉਹ ਆਪਣੇ ਪਰਮੇਸ਼ੁਰ ਦੀ ਰੋਟੀ ਚੜ੍ਹਾਉਣ ਲਈ ਨਜ਼ਦੀਕ ਨਾ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","ਕੋਈ ਵੀ ਮਨੁੱਖ ਜਿਸ ਵਿੱਚ ਕੋਈ ਵੀ ਦੋਸ਼ ਹੋਵੇ, ਭਾਵੇਂ ਅੰਨ੍ਹਾ, ਭਾਵੇਂ ਲੰਗੜਾ, ਭਾਵੇਂ ਜਿਸ ਦਾ ਨੱਕ ਫੀਨਾ ਹੋਵੇ, ਜਾਂ ਜਿਸ ਦੀ ਲੱਤ ਲੰਮੀ ਹੋਵੇ, ");
INSERT INTO pan_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","ਜਾਂ ਉਸਦਾ ਪੈਰ ਜਾਂ ਹੱਥ ਟੁੱਟਿਆ ਹੋਇਆ ਹੋਵੇ, ");
INSERT INTO pan_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","ਜਾਂ ਕੁੱਬਾ, ਜਾਂ ਮਧਰਾ ਜਾਂ ਭੈਂਗਾ ਜਾਂ ਜਿਸ ਨੂੰ ਦਾਦ ਜਾਂ ਖੁਜਲੀ ਹੋਵੇ ਜਾਂ ਜਿਸ ਦੇ ਨਲ ਕੁਚਲੇ ਹੋਏ ਹੋਣ, ਉਹ ਨਜ਼ਦੀਕ ਨਾ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","ਹਾਰੂਨ ਜਾਜਕ ਦੇ ਵੰਸ਼ ਵਿੱਚੋਂ ਜਿਸ ਕਿਸੇ ਮਨੁੱਖ ਵਿੱਚ ਕੋਈ ਦੋਸ਼ ਹੋਵੇ, ਉਹ ਯਹੋਵਾਹ ਦੀਆਂ ਅੱਗ ਦੀਆਂ ਭੇਟਾਂ ਦੇ ਚੜ੍ਹਾਉਣ ਲਈ ਨਜ਼ਦੀਕ ਨਾ ਆਵੇ। ਕਿਉਂ ਜੋ ਉਸ ਵਿੱਚ ਦੋਸ਼ ਹੈ, ਇਸ ਲਈ ਉਹ ਆਪਣੇ ਪਰਮੇਸ਼ੁਰ ਦੀ ਰੋਟੀ ਚੜ੍ਹਾਉਣ ਲਈ ਨਜ਼ਦੀਕ ਨਾ ਆਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","ਉਹ ਆਪਣੇ ਪਰਮੇਸ਼ੁਰ ਦੀ ਅੱਤ ਪਵਿੱਤਰ ਅਤੇ ਪਵਿੱਤਰ ਰੋਟੀ ਵਿੱਚੋਂ ਖਾਵੇ, ");
INSERT INTO pan_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","ਪਰ ਉਹ ਪਰਦੇ ਦੇ ਅੰਦਰ ਨਾ ਜਾਵੇ ਅਤੇ ਨਾ ਹੀ ਜਗਵੇਦੀ ਦੇ ਨਜ਼ਦੀਕ ਜਾਵੇ ਕਿਉਂ ਜੋ ਉਸ ਵਿੱਚ ਦੋਸ਼ ਹੈ, ਅਜਿਹਾ ਨਾ ਹੋਵੇ ਕਿ ਉਹ ਮੇਰੇ ਪਵਿੱਤਰ ਸਥਾਨਾਂ ਨੂੰ ਭਰਿਸ਼ਟ ਕਰੇ, ਕਿਉਂ ਜੋ ਮੈਂ ਯਹੋਵਾਹ ਉਨ੍ਹਾਂ ਨੂੰ ਪਵਿੱਤਰ ਠਹਿਰਾਉਂਦਾ ਹਾਂ। ");
INSERT INTO pan_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","ਇਸ ਲਈ ਮੂਸਾ ਨੇ ਹਾਰੂਨ ਅਤੇ ਉਸ ਦੇ ਪੁੱਤਰਾਂ ਨੂੰ ਅਤੇ ਇਸਰਾਏਲ ਦੇ ਸਾਰੇ ਘਰਾਣਿਆਂ ਨੂੰ ਇਹ ਗੱਲਾਂ ਦੱਸੀਆਂ। ");
INSERT INTO pan_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਆਖਿਆ, ");
INSERT INTO pan_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","ਹਾਰੂਨ ਅਤੇ ਉਸ ਦੇ ਪੁੱਤਰਾਂ ਨੂੰ ਆਖ, ਉਹ ਇਸਰਾਏਲੀਆਂ ਦੀਆਂ ਪਵਿੱਤਰ ਕੀਤੀਆਂ ਹੋਈਆਂ ਵਸਤੂਆਂ ਤੋਂ, ਜਿਨ੍ਹਾਂ ਨੂੰ ਉਹ ਮੇਰੇ ਅੱਗੇ ਪਵਿੱਤਰ ਕਰਦੇ ਹਨ, ਅਲੱਗ ਰਹਿਣ ਅਤੇ ਮੇਰੇ ਪਵਿੱਤਰ ਨਾਮ ਦਾ ਨਿਰਾਦਰ ਨਾ ਕਰਨ। ਮੈਂ ਯਹੋਵਾਹ ਹਾਂ। ");
INSERT INTO pan_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","ਉਨ੍ਹਾਂ ਨੂੰ ਆਖ, ਤੁਹਾਡੀਆਂ ਪੀੜ੍ਹੀਆਂ ਵਿੱਚੋਂ, ਅਤੇ ਤੁਹਾਡੇ ਸਾਰੇ ਵੰਸ਼ ਵਿੱਚੋਂ ਜਿਹੜਾ ਆਪਣੀ ਅਸ਼ੁੱਧਤਾਈ ਵਿੱਚ ਉਨ੍ਹਾਂ ਪਵਿੱਤਰ ਕੀਤੀਆਂ ਹੋਇਆਂ ਵਸਤੂਆਂ ਕੋਲ ਜਾਵੇ, ਜਿਹੜੀਆਂ ਇਸਰਾਏਲੀ ਮੇਰੇ ਲਈ ਪਵਿੱਤਰ ਕਰਦੇ ਹਨ, ਉਹ ਮਨੁੱਖ ਮੇਰੇ ਅੱਗਿਓਂ ਛੇਕਿਆ ਜਾਵੇ। ਮੈਂ ਯਹੋਵਾਹ ਹਾਂ। ");
INSERT INTO pan_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","ਹਾਰੂਨ ਦੇ ਵੰਸ਼ ਵਿੱਚ ਜਿਸ ਕਿਸੇ ਨੂੰ ਕੋੜ੍ਹ ਹੋਵੇ ਜਾਂ ਪ੍ਰਮੇਹ ਹੋਵੇ, ਜਦ ਤੱਕ ਉਹ ਮਨੁੱਖ ਸ਼ੁੱਧ ਨਾ ਹੋਵੇ, ਤਦ ਤੱਕ ਪਵਿੱਤਰ ਵਸਤੂਆਂ ਨੂੰ ਨਾ ਖਾਵੇ। ਜਿਹੜਾ ਕਿਸੇ ਅਜਿਹੀ ਵਸਤੂ ਨੂੰ ਛੂਹੇ, ਜੋ ਮੁਰਦੇ ਦੇ ਕਾਰਨ ਅਸ਼ੁੱਧ ਹੈ ਜਾਂ ਕਿਸੇ ਮਨੁੱਖ ਨੂੰ ਛੂਹੇ ਜਿਸ ਦਾ ਵੀਰਜ ਨਿੱਕਲਿਆ ਹੋਵੇ, ");
INSERT INTO pan_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","ਜਾਂ ਜਿਹੜਾ ਕਿਸੇ ਘਿਸਰਨ ਵਾਲੇ ਜੀਵ ਨੂੰ ਛੂਹੇ, ਜਿਸ ਦੇ ਕਾਰਨ ਉਹ ਅਸ਼ੁੱਧ ਹੋ ਜਾਵੇ, ਜਾਂ ਕਿਸੇ ਅਜਿਹੇ ਮਨੁੱਖ ਨੂੰ ਛੂਹੇ ਜਿਸ ਵਿੱਚ ਕੋਈ ਅਸ਼ੁੱਧਤਾਈ ਹੋਵੇ, ਭਾਵੇਂ ਉਹ ਕਿਹੋ ਜਿਹੀ ਅਸ਼ੁੱਧਤਾਈ ਕਿਉਂ ਨਾ ਹੋਵੇ, ");
INSERT INTO pan_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","ਤਾਂ ਉਹ ਮਨੁੱਖ ਜਿਹੜਾ ਇਹੋ ਜਿਹੀ ਕਿਸੇ ਵਸਤੂ ਨੂੰ ਛੂਹੇ, ਉਹ ਸ਼ਾਮ ਤੱਕ ਅਸ਼ੁੱਧ ਰਹੇ ਅਤੇ ਜਦ ਤੱਕ ਪਾਣੀ ਨਾਲ ਨਾ ਨਹਾਵੇ, ਤਦ ਤੱਕ ਕਿਸੇ ਪਵਿੱਤਰ ਵਸਤੂ ਨੂੰ ਨਾ ਖਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","ਜਦ ਸੂਰਜ ਡੁੱਬ ਜਾਵੇ ਤਾਂ ਉਹ ਸ਼ੁੱਧ ਹੋਵੇ ਅਤੇ ਫੇਰ ਪਵਿੱਤਰ ਵਸਤੂਆਂ ਵਿੱਚੋਂ ਖਾ ਸਕਦਾ ਹੈ, ਕਿਉਂ ਜੋ ਇਹ ਹੀ ਉਸ ਦਾ ਭੋਜਨ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","ਜਿਹੜਾ ਜਾਨਵਰ ਆਪ ਮਰ ਜਾਵੇ, ਜਾਂ ਦੂਜੇ ਜਾਨਵਰਾਂ ਦੁਆਰਾ ਪਾੜਿਆ ਜਾਵੇ ਤਾਂ ਉਸ ਨੂੰ ਖਾ ਕੇ ਉਹ ਆਪਣੇ ਆਪ ਨੂੰ ਅਸ਼ੁੱਧ ਨਾ ਕਰੇ। ਮੈਂ ਯਹੋਵਾਹ ਹਾਂ। ");
INSERT INTO pan_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","ਇਸ ਲਈ ਜਾਜਕ ਮੇਰੇ ਹੁਕਮ ਨੂੰ ਮੰਨਣ, ਅਜਿਹਾ ਨਾ ਹੋਵੇ ਕਿ ਉਹ ਉਸ ਦਾ ਨਿਰਾਦਰ ਕਰਨ ਅਤੇ ਉਨ੍ਹਾਂ ਦਾ ਪਾਪ ਉਨ੍ਹਾਂ ਦੇ ਜੁੰਮੇ ਹੋਵੇ ਅਤੇ ਉਹ ਮਰ ਜਾਣ। ਮੈਂ ਯਹੋਵਾਹ ਉਨ੍ਹਾਂ ਨੂੰ ਪਵਿੱਤਰ ਕਰਨ ਵਾਲਾ ਹਾਂ। ");
INSERT INTO pan_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","ਕੋਈ ਵੀ ਗੈਰ-ਕੌਮੀ ਮਨੁੱਖ ਪਵਿੱਤਰ ਵਸਤੂਆਂ ਵਿੱਚੋਂ ਨਾ ਖਾਵੇ, ਭਾਵੇਂ ਉਹ ਪਰਦੇਸੀ ਹੋ ਕੇ ਜਾਜਕ ਦੇ ਕੋਲ ਰਹਿੰਦਾ ਹੋਵੇ, ਜਾਂ ਕੋਈ ਨੌਕਰ ਹੋਵੇ, ਉਹ ਪਵਿੱਤਰ ਵਸਤੂਆਂ ਵਿੱਚੋਂ ਨਾ ਖਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","ਪਰ ਜੇਕਰ ਜਾਜਕ ਕਿਸੇ ਮਨੁੱਖ ਨੂੰ ਆਪਣਾ ਪੈਸਾ ਦੇ ਕੇ ਮੁੱਲ ਲਵੇ, ਤਾਂ ਉਹ ਮਨੁੱਖ ਉਸ ਵਿੱਚੋਂ ਖਾ ਸਕਦਾ ਹੈ ਅਤੇ ਉਹ ਜੋ ਜਾਜਕ ਦੇ ਘਰ ਵਿੱਚ ਜੰਮਿਆ ਹੋਵੇ, ਉਹ ਵੀ ਉਸ ਭੋਜਨ ਵਿੱਚੋਂ ਖਾ ਸਕਦਾ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","ਜੇਕਰ ਜਾਜਕ ਦੀ ਧੀ ਕਿਸੇ ਪਰਾਏ ਮਨੁੱਖ ਨਾਲ ਵਿਆਹੀ ਜਾਵੇ, ਤਾਂ ਉਹ ਪਵਿੱਤਰ ਵਸਤੂਆਂ ਦੀ ਭੇਟ ਵਿੱਚੋਂ ਨਾ ਖਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","ਪਰ ਜੇਕਰ ਜਾਜਕ ਦੀ ਧੀ ਵਿਧਵਾ ਜਾਂ ਪਤੀ ਵੱਲੋਂ ਤਿਆਗੀ ਹੋਈ ਹੋਵੇ ਅਤੇ ਉਸ ਦੀ ਕੋਈ ਸੰਤਾਨ ਨਾ ਹੋਵੇ ਅਤੇ ਪਹਿਲਾਂ ਦੀ ਤਰ੍ਹਾਂ ਆਪਣੇ ਪਿਤਾ ਦੇ ਘਰ ਵਿੱਚ ਰਹਿੰਦੀ ਹੋਵੇ ਤਾਂ ਉਹ ਆਪਣੇ ਪਿਤਾ ਦੇ ਭੋਜਨ ਵਿੱਚੋਂ ਖਾਵੇ, ਪਰ ਕੋਈ ਪਰਾਇਆ ਉਸ ਵਿੱਚੋਂ ਨਾ ਖਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","ਜੇਕਰ ਕੋਈ ਮਨੁੱਖ ਅਣਜਾਣੇ ਵਿੱਚ ਪਵਿੱਤਰ ਵਸਤੂਆਂ ਵਿੱਚੋਂ ਖਾ ਲਵੇ ਤਾਂ ਉਹ ਉਸ ਦੇ ਨਾਲ ਪੰਜਵਾਂ ਹਿੱਸਾ ਹੋਰ ਮਿਲਾ ਕੇ ਜਾਜਕ ਨੂੰ ਪਵਿੱਤਰ ਵਸਤੂ ਦੇ ਦੇਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","ਅਤੇ ਉਹ ਇਸਰਾਏਲੀਆਂ ਦੀਆਂ ਪਵਿੱਤਰ ਕੀਤੀਆਂ ਹੋਈਆਂ ਵਸਤੂਆਂ ਦਾ ਜਿਨ੍ਹਾਂ ਨੂੰ ਉਹ ਭੇਟ ਕਰਕੇ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਚੜ੍ਹਾਉਂਦੇ ਹਨ, ਨਿਰਾਦਰ ਨਾ ਕਰਨ। ");
INSERT INTO pan_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","ਉਹ ਉਨ੍ਹਾਂ ਨੂੰ ਆਪਣੀਆਂ ਪਵਿੱਤਰ ਵਸਤੂਆਂ ਵਿੱਚੋਂ ਖੁਆ ਕੇ, ਉਨ੍ਹਾਂ ਉੱਤੇ ਬਦੀ ਦਾ ਦੋਸ਼ ਨਾ ਲਿਆਉਣ, ਕਿਉਂ ਜੋ ਮੈਂ ਯਹੋਵਾਹ ਉਨ੍ਹਾਂ ਬਲੀਦਾਨਾਂ ਨੂੰ ਪਵਿੱਤਰ ਕਰਨ ਵਾਲਾ ਹਾਂ। ");
INSERT INTO pan_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","ਫੇਰ ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਆਖਿਆ, ");
INSERT INTO pan_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","ਹਾਰੂਨ ਅਤੇ ਉਸ ਦੇ ਪੁੱਤਰਾਂ ਨੂੰ ਅਤੇ ਇਸਰਾਏਲ ਦੇ ਸਾਰੇ ਘਰਾਣਿਆਂ ਨੂੰ ਆਖ ਕਿ ਇਸਰਾਏਲੀਆਂ ਵਿੱਚੋਂ ਜਾਂ ਉਨ੍ਹਾਂ ਪਰਦੇਸੀਆਂ ਵਿੱਚੋਂ ਜੋ ਇਸਰਾਏਲ ਵਿੱਚ ਵੱਸਦੇ ਹਨ, ਜਿਹੜਾ ਆਪਣੀਆਂ ਸੁੱਖਣਾਂ ਜਾਂ ਖੁਸ਼ੀ ਦੀਆਂ ਭੇਟਾਂ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਹੋਮ ਬਲੀ ਦੀ ਭੇਟ ਕਰਕੇ ਚੜ੍ਹਾਵੇ, ");
INSERT INTO pan_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","ਤਾਂ ਤੁਸੀਂ ਆਪਣੇ ਸਵੀਕਾਰੇ ਜਾਣ ਲਈ ਬਲ਼ਦਾਂ, ਜਾਂ ਭੇਡਾਂ ਜਾਂ ਬੱਕਰੀਆਂ ਵਿੱਚੋਂ ਇੱਕ ਦੋਸ਼ ਰਹਿਤ ਨਰ ਚੜ੍ਹਾਓ। ");
INSERT INTO pan_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","ਪਰ ਜਿਸ ਵਿੱਚ ਕੋਈ ਦੋਸ਼ ਹੋਏ, ਉਸ ਨੂੰ ਤੁਸੀਂ ਨਾ ਚੜ੍ਹਾਉਣਾ, ਕਿਉਂ ਜੋ ਉਹ ਤੁਹਾਡੇ ਵੱਲੋਂ ਸਵੀਕਾਰ ਨਹੀਂ ਕੀਤਾ ਜਾਵੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","ਅਤੇ ਜਿਹੜਾ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਆਪਣੀ ਸੁੱਖਣਾ ਪੂਰੀ ਕਰਨ ਲਈ ਸੁੱਖ-ਸਾਂਦ ਦੀਆਂ ਭੇਟਾਂ ਦੀ ਬਲੀ ਚੜ੍ਹਾਵੇ, ਜਾਂ ਆਪਣੀ ਖੁਸ਼ੀ ਦੀ ਭੇਟ ਲਈ ਬਲ਼ਦਾਂ ਜਾਂ ਭੇਡਾਂ ਵਿੱਚੋਂ ਭੇਟ ਚੜ੍ਹਾਵੇ, ਤਾਂ ਸਵੀਕਾਰੇ ਜਾਣ ਲਈ ਜ਼ਰੂਰੀ ਹੈ ਕਿ ਉਹ ਪੂਰੀ ਹੋਵੇ ਅਤੇ ਉਸ ਦੇ ਵਿੱਚ ਕੋਈ ਦੋਸ਼ ਨਾ ਹੋਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","ਜਿਹੜਾ ਅੰਨ੍ਹਾ ਹੋਵੇ, ਜਾਂ ਜਿਸ ਦੇ ਅੰਗ ਟੁੱਟੇ ਹੋਣ ਜਾਂ ਟੁੰਡਾ ਹੋਵੇ ਜਾਂ ਜਿਸ ਨੂੰ ਮੁਹਕੇ ਹੋਣ, ਜਾਂ ਦਾਦ ਜਾਂ ਖੁਜਲੀ ਹੋਵੇ, ਇਨ੍ਹਾਂ ਨੂੰ ਤੁਸੀਂ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਨਾ ਚੜ੍ਹਾਉਣਾ, ਨਾ ਉਨ੍ਹਾਂ ਨੂੰ ਅੱਗ ਦੀ ਭੇਟ ਕਰਕੇ ਜਗਵੇਦੀ ਦੇ ਉੱਤੇ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਚੜ੍ਹਾਉਣਾ। ");
INSERT INTO pan_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","ਜਿਸ ਕਿਸੇ ਬਲ਼ਦ ਜਾਂ ਬੱਕਰੇ ਦਾ ਕੋਈ ਅੰਗ ਵੱਧ ਜਾਂ ਘੱਟ ਹੋਵੇ, ਉਸ ਨੂੰ ਤੁਸੀਂ ਆਪਣੀ ਖੁਸ਼ੀ ਦੀ ਭੇਟ ਕਰਕੇ ਚੜ੍ਹਾ ਸਕਦੇ ਹੋ, ਪਰ ਸੁੱਖਣਾ ਪੂਰੀ ਕਰਨ ਲਈ ਉਸ ਨੂੰ ਸਵੀਕਾਰ ਨਾ ਕੀਤਾ ਜਾਵੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","ਜਿਸ ਪਸ਼ੂ ਦੇ ਨਲ ਨੂੰ ਸੱਟ ਲੱਗੀ ਹੋਵੇ, ਜਾਂ ਦੱਬੇ ਹੋਏ, ਕੁਚਲੇ ਹੋਏ ਜਾਂ ਫਟੇ ਹੋਏ ਹੋਣ, ਉਸ ਨੂੰ ਤੁਸੀਂ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਨਾ ਚੜ੍ਹਾਉਣਾ, ਅਤੇ ਨਾ ਆਪਣੇ ਦੇਸ ਵਿੱਚ ਕੋਈ ਅਜਿਹੀ ਭੇਟ ਚੜ੍ਹਾਉਣਾ। ");
INSERT INTO pan_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","ਇਨ੍ਹਾਂ ਵਿੱਚੋਂ ਕਿਸੇ ਨੂੰ ਪਰਦੇਸੀ ਦੇ ਹੱਥ ਤੋਂ ਲੈ ਆਪਣੇ ਪਰਮੇਸ਼ੁਰ ਦਾ ਭੋਜਨ ਕਰਕੇ ਨਾ ਚੜ੍ਹਾਉਣਾ, ਕਿਉਂ ਜੋ ਉਨ੍ਹਾਂ ਦੀ ਬੁਰਿਆਈ ਉਨ੍ਹਾਂ ਦੇ ਵਿੱਚ ਹੈ ਅਤੇ ਦੋਸ਼ ਵੀ ਹਨ, ਇਸ ਲਈ ਉਹ ਤੁਹਾਡੇ ਹੱਥਾਂ ਤੋਂ ਸਵੀਕਾਰ ਨਹੀਂ ਕੀਤੇ ਜਾਣਗੇ। ");
INSERT INTO pan_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","ਫੇਰ ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਆਖਿਆ, ");
INSERT INTO pan_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","ਜਦ ਕੋਈ ਬਲ਼ਦ, ਜਾਂ ਭੇਡ ਜਾਂ ਬੱਕਰੀ ਦਾ ਬੱਚਾ ਜੰਮੇ ਤਾਂ ਉਹ ਸੱਤ ਦਿਨ ਤੱਕ ਆਪਣੀ ਮਾਂ ਦੇ ਕੋਲ ਰਹੇ ਅਤੇ ਅੱਠਵੇਂ ਦਿਨ ਤੋਂ ਲੈ ਕੇ ਉਹ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਅੱਗ ਦੀ ਭੇਟ ਦੇ ਲਈ ਸਵੀਕਾਰ ਯੋਗ ਹੋਵੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","ਭਾਵੇਂ ਗਾਂ ਹੋਵੇ, ਭਾਵੇਂ ਭੇਡ ਜਾਂ ਬੱਕਰੀ, ਤੂੰ ਉਸ ਨੂੰ ਅਤੇ ਉਸ ਦੇ ਬੱਚੇ ਨੂੰ ਇੱਕ ਦਿਨ ਵਿੱਚ ਨਾ ਵੱਢੀਂ। ");
INSERT INTO pan_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","ਅਤੇ ਜਦ ਤੁਸੀਂ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਧੰਨਵਾਦ ਦੀ ਬਲੀ ਚੜ੍ਹਾਓ, ਤਾਂ ਤੁਸੀਂ ਉਸ ਨੂੰ ਇਸੇ ਤਰ੍ਹਾਂ ਹੀ ਚੜ੍ਹਾਉਣਾ ਤਾਂ ਜੋ ਉਹ ਸਵੀਕਾਰ ਹੋਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","ਉਸ ਨੂੰ ਉਸੇ ਦਿਨ ਹੀ ਖਾਧਾ ਜਾਵੇ, ਤੁਸੀਂ ਉਸ ਵਿੱਚੋਂ ਸਵੇਰ ਤੱਕ ਕੁਝ ਨਾ ਛੱਡਣਾ। ਮੈਂ ਯਹੋਵਾਹ ਹਾਂ। ");
INSERT INTO pan_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","ਇਸ ਲਈ ਤੁਸੀਂ ਮੇਰੇ ਹੁਕਮਾਂ ਨੂੰ ਮੰਨ ਕੇ ਉਨ੍ਹਾਂ ਦੀ ਪਾਲਣਾ ਕਰਨਾ। ਮੈਂ ਯਹੋਵਾਹ ਹਾਂ। ");
INSERT INTO pan_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","ਤੁਸੀਂ ਮੇਰੇ ਪਵਿੱਤਰ ਨਾਮ ਨੂੰ ਭਰਿਸ਼ਟ ਨਾ ਕਰਨਾ, ਪਰ ਮੈਂ ਇਸਰਾਏਲੀਆਂ ਵਿੱਚ ਜ਼ਰੂਰ ਹੀ ਪਵਿੱਤਰ ਸਮਝਿਆ ਜਾਂਵਾਂ। ਮੈਂ ਉਹ ਯਹੋਵਾਹ ਹਾਂ, ਜੋ ਤੁਹਾਨੂੰ ਪਵਿੱਤਰ ਕਰਦਾ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","ਜੋ ਤੁਹਾਨੂੰ ਮਿਸਰ ਦੇਸ ਵਿੱਚੋਂ ਕੱਢ ਲਿਆਇਆ ਤਾਂ ਜੋ ਤੁਹਾਡਾ ਪਰਮੇਸ਼ੁਰ ਹੋਵਾਂ, ਮੈਂ ਯਹੋਵਾਹ ਹਾਂ। ");
INSERT INTO pan_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਆਖਿਆ, ");
INSERT INTO pan_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","“ਇਸਰਾਏਲੀਆਂ ਨੂੰ ਆਖ ਕਿ ਜਿਹੜੇ ਯਹੋਵਾਹ ਦੇ ਪਰਬ ਹਨ, ਜਿਨ੍ਹਾਂ ਦੀ ਤੁਸੀਂ ਪਵਿੱਤਰ ਸਭਾ ਲਈ ਨਿਯੁਕਤ ਸਮੇਂ ਤੇ ਘੋਸ਼ਣਾ ਕਰਨੀ ਹੈ ਉਹ ਇਹ ਹਨ, ");
INSERT INTO pan_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","ਛੇ ਦਿਨ ਕੰਮ ਕੀਤਾ ਜਾਵੇ ਪਰ ਸੱਤਵਾਂ ਦਿਨ ਮਹਾਂ-ਸਬਤ ਦਾ ਅਤੇ ਪਵਿੱਤਰ ਸਭਾ ਦਾ ਦਿਨ ਹੈ, ਤੁਸੀਂ ਉਸ ਦਿਨ ਕੋਈ ਕੰਮ ਨਾ ਕਰਨਾ। ਇਹ ਤੁਹਾਡੇ ਸਾਰੇ ਨਿਵਾਸ ਸਥਾਨਾਂ ਵਿੱਚ ਯਹੋਵਾਹ ਦਾ ਸਬਤ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","“ਯਹੋਵਾਹ ਦੇ ਪਰਬ ਜਿਨ੍ਹਾਂ ਦੇ ਨਿਯੁਕਤ ਕੀਤੇ ਹੋਏ ਸਮੇਂ ਤੇ ਤੁਸੀਂ ਪਵਿੱਤਰ ਸਭਾ ਕਰਨ ਲਈ ਘੋਸ਼ਣਾ ਕਰਨੀ ਹੈ, ਉਹ ਇਹ ਹਨ, ");
INSERT INTO pan_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","ਪਹਿਲੇ ਮਹੀਨੇ ਦੇ ਚੌਧਵੇਂ ਦਿਨ ਨੂੰ ਸ਼ਾਮ ਦੇ ਵੇਲੇ ਯਹੋਵਾਹ ਦੇ ਪਸਾਹ ਦਾ ਪਰਬ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","ਅਤੇ ਉਸੇ ਮਹੀਨੇ ਦੇ ਪੰਦਰਵੇਂ ਦਿਨ ਨੂੰ ਯਹੋਵਾਹ ਦੀ ਪਤੀਰੀ ਰੋਟੀ ਦਾ ਪਰਬ ਹੈ, ਉਸ ਵਿੱਚ ਸੱਤ ਦਿਨ ਤੱਕ ਤੁਸੀਂ ਪਤੀਰੀ ਰੋਟੀ ਖਾਣਾ। ");
INSERT INTO pan_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","ਪਹਿਲੇ ਦਿਨ ਤੁਸੀਂ ਪਵਿੱਤਰ ਸਭਾ ਕਰਨਾ, ਉਸ ਦੇ ਵਿੱਚ ਤੁਸੀਂ ਕੋਈ ਕੰਮ-ਧੰਦਾ ਨਾ ਕਰਨਾ। ");
INSERT INTO pan_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","ਸੱਤ ਦਿਨ ਤੱਕ ਤੁਸੀਂ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਅੱਗ ਦੀ ਭੇਟ ਚੜ੍ਹਾਉਣਾ ਅਤੇ ਸੱਤਵੇਂ ਦਿਨ ਪਵਿੱਤਰ ਸਭਾ ਹੋਵੇ, ਉਸ ਦੇ ਵਿੱਚ ਤੁਸੀਂ ਕੋਈ ਕੰਮ-ਧੰਦਾ ਨਾ ਕਰਨਾ।” ");
INSERT INTO pan_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","ਫੇਰ ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਆਖਿਆ, ");
INSERT INTO pan_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","“ਇਸਰਾਏਲੀਆਂ ਨਾਲ ਗੱਲ ਕਰ ਅਤੇ ਆਖ ਜਿਸ ਵੇਲੇ ਤੁਸੀਂ ਉਸ ਦੇਸ ਵਿੱਚ ਪਹੁੰਚ ਜਾਓ ਜਿਹੜਾ ਮੈਂ ਤੁਹਾਨੂੰ ਦਿੰਦਾ ਹਾਂ, ਅਤੇ ਉਸ ਦੀ ਫ਼ਸਲ ਵੱਢੋ ਤਾਂ ਤੁਸੀਂ ਆਪਣੀ ਉਪਜ ਦੇ ਪਹਿਲੇ ਫਲ ਵਿੱਚੋਂ ਇੱਕ ਪੂਲਾ ਜਾਜਕ ਦੇ ਸਾਹਮਣੇ ਲਿਆਉਣਾ। ");
INSERT INTO pan_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","ਅਤੇ ਉਹ ਉਸ ਪੂਲੇ ਨੂੰ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਹਿਲਾਵੇ ਤਾਂ ਜੋ ਉਹ ਤੁਹਾਡੇ ਵੱਲੋਂ ਸਵੀਕਾਰ ਕੀਤਾ ਜਾਵੇ, ਜਾਜਕ ਉਸ ਨੂੰ ਸਬਤ ਦੇ ਅਗਲੇ ਦਿਨ ਹਿਲਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","ਅਤੇ ਜਿਸ ਦਿਨ ਤੁਸੀਂ ਉਸ ਪੂਲੇ ਨੂੰ ਹਿਲਾਓ, ਉਸੇ ਦਿਨ ਤੁਸੀਂ ਇੱਕ ਸਾਲ ਦਾ ਦੋਸ਼ ਰਹਿਤ ਇੱਕ ਲੇਲਾ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਹੋਮ ਦੀ ਭੇਟ ਕਰਕੇ ਚੜ੍ਹਾਉਣਾ। ");
INSERT INTO pan_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","ਅਤੇ ਉਸ ਦੇ ਨਾਲ ਮੈਦੇ ਦੀ ਭੇਟ, ਏਫ਼ਾਹ ਦਾ ਦੋ ਦੱਸਵਾਂ ਹਿੱਸਾ ਤੇਲ ਨਾਲ ਰਲੇ ਹੋਏ ਮੈਦੇ ਦਾ ਹੋਵੇ, ਉਹ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਸੁਗੰਧਤਾ ਕਰਕੇ ਇੱਕ ਅੱਗ ਦੀ ਭੇਟ ਹੋਵੇ ਅਤੇ ਉਸ ਦੇ ਨਾਲ ਪੀਣ ਦੀ ਭੇਟ ਲਈ ਕੁੱਪੇ ਦੀ ਚੁਥਾਈ ਦਾਖਰਸ ਹੋਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","ਜਿਸ ਦਿਨ ਤੱਕ ਤੁਸੀਂ ਇਸ ਭੇਟ ਨੂੰ ਆਪਣੇ ਪਰਮੇਸ਼ੁਰ ਦੇ ਅੱਗੇ ਨਾ ਲਿਆਓ, ਉਸ ਦਿਨ ਤੱਕ ਤੁਸੀਂ ਪਹਿਲੇ ਫਲ ਵਿੱਚੋਂ ਨਾ ਰੋਟੀ, ਨਾ ਭੁੰਨੇ ਹੋਏ ਦਾਣੇ ਅਤੇ ਨਾ ਹੀ ਹਰੇ ਸਿੱਟੇ ਖਾਣਾ। ਇਹ ਤੁਹਾਡੀਆਂ ਪੀੜ੍ਹੀਆਂ ਤੱਕ ਤੁਹਾਡੇ ਸਾਰੇ ਨਿਵਾਸ ਸਥਾਨਾਂ ਵਿੱਚ ਇੱਕ ਸਦਾ ਦੀ ਬਿਧੀ ਹੋਵੇ।” ");
INSERT INTO pan_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","“ਫੇਰ ਉਸ ਸਬਤ ਦੇ ਅਗਲੇ ਦਿਨ ਤੋਂ ਜਦ ਤੁਸੀਂ ਹਿਲਾਉਣ ਦੀ ਭੇਟ ਦਾ ਪੂਲਾ ਲਿਆਏ, ਤੁਸੀਂ ਅਗਲੇ ਸੱਤ ਸਬਤ ਗਿਣ ਲੈਣਾ। ");
INSERT INTO pan_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","ਅਤੇ ਸੱਤਵੇਂ ਸਬਤ ਦੇ ਅਗਲੇ ਦਿਨ ਤੱਕ ਤੁਸੀਂ ਪੰਜਾਹ ਦਿਨ ਗਿਣ ਲੈਣਾ ਅਤੇ ਫੇਰ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਇੱਕ ਨਵੀਂ ਮੈਦੇ ਦੀ ਭੇਟ ਚੜ੍ਹਾਉਣਾ। ");
INSERT INTO pan_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","ਤੁਸੀਂ ਆਪਣੇ ਨਿਵਾਸ ਸਥਾਨਾਂ ਵਿੱਚੋਂ ਏਫ਼ਾਹ ਦੇ ਦੋ ਦਸਵੇਂ ਹਿੱਸੇ ਮੈਦੇ ਦੀਆਂ ਦੋ ਰੋਟੀਆਂ ਹਿਲਾਉਣ ਦੀ ਭੇਟ ਕਰਕੇ ਲਿਆਉਣਾ, ਉਹ ਖ਼ਮੀਰ ਨਾਲ ਗੁੰਨ੍ਹੇ ਹੋਏ ਮੈਦੇ ਦੀਆਂ ਹੋਣ, ਇਹ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਉਪਜ ਦਾ ਪਹਿਲਾ ਫਲ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","ਤੁਸੀਂ ਉਨ੍ਹਾਂ ਰੋਟੀਆਂ ਦੇ ਨਾਲ ਇੱਕ ਸਾਲ ਦੇ ਦੋਸ਼ ਰਹਿਤ ਸੱਤ ਲੇਲੇ, ਇੱਕ ਜੁਆਨ ਬਲ਼ਦ ਅਤੇ ਦੋ ਛੱਤਰੇ ਹੋਮ ਬਲੀ ਦੀ ਭੇਟ ਕਰਕੇ ਚੜ੍ਹਾਉਣਾ। ਉਹ ਉਨ੍ਹਾਂ ਦੀਆਂ ਮੈਦੇ ਦੀਆਂ ਭੇਟਾਂ, ਪੀਣ ਦੀਆਂ ਭੇਟਾਂ ਸਮੇਤ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਸੁਗੰਧਤਾ ਲਈ ਇੱਕ ਅੱਗ ਦੀ ਭੇਟ ਹੋਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","ਫੇਰ ਤੁਸੀਂ ਪਾਪ ਬਲੀ ਦੀ ਭੇਟ ਲਈ ਇੱਕ ਬੱਕਰਾ ਅਤੇ ਸੁੱਖ-ਸਾਂਦ ਦੀ ਭੇਟ ਲਈ ਇੱਕ ਸਾਲ ਦੇ ਦੋ ਲੇਲੇ ਬਲੀ ਕਰਕੇ ਚੜ੍ਹਾਉਣਾ। ");
INSERT INTO pan_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","ਤਦ ਜਾਜਕ ਉਨ੍ਹਾਂ ਲੇਲਿਆਂ ਨੂੰ ਪਹਿਲੇ ਫਲ ਦੀ ਰੋਟੀ ਸਮੇਤ ਹਿਲਾਉਣ ਦੀ ਭੇਟ ਕਰਕੇ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਹਿਲਾਵੇ ਅਤੇ ਉਹ ਜਾਜਕ ਦੇ ਲਈ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਪਵਿੱਤਰ ਹੋਣ। ");
INSERT INTO pan_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","ਉਸੇ ਦਿਨ ਤੁਸੀਂ ਆਪਣੇ ਲਈ ਇੱਕ ਪਵਿੱਤਰ ਸਭਾ ਦੀ ਘੋਸ਼ਣਾ ਕਰਨਾ। ਉਸ ਦਿਨ ਤੁਸੀਂ ਕੋਈ ਕੰਮ-ਧੰਦਾ ਨਾ ਕਰਨਾ। ਇਹ ਤੁਹਾਡੇ ਸਾਰੇ ਨਿਵਾਸ-ਸਥਾਨਾਂ ਵਿੱਚ ਤੁਹਾਡੀਆਂ ਪੀੜ੍ਹੀਆਂ ਤੱਕ ਇੱਕ ਸਦਾ ਦੀ ਬਿਧੀ ਠਹਿਰੇ। ");
INSERT INTO pan_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","“ਜਿਸ ਵੇਲੇ ਤੁਸੀਂ ਆਪਣੇ ਦੇਸ ਦੀ ਫ਼ਸਲ ਵੱਢੋ ਤਾਂ ਤੁਸੀਂ ਆਪਣੇ ਖੇਤ ਦੇ ਬੰਨ੍ਹਿਆਂ ਤੱਕ ਸਾਰੀ ਫਸਲ ਨਾ ਵੱਢਣਾ, ਨਾ ਹੀ ਤੁਸੀਂ ਖੇਤ ਵਿੱਚ ਡਿੱਗੇ ਹੋਏ ਸਿੱਟਿਆਂ ਨੂੰ ਚੁੱਗਣਾ। ਤੁਸੀਂ ਉਨ੍ਹਾਂ ਨੂੰ ਕੰਗਾਲ ਅਤੇ ਪਰਦੇਸੀਆਂ ਲਈ ਛੱਡ ਦੇਣਾ। ਮੈਂ ਯਹੋਵਾਹ ਤੁਹਾਡਾ ਪਰਮੇਸ਼ੁਰ ਹਾਂ।” ");
INSERT INTO pan_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","ਫੇਰ ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਆਖਿਆ, ");
INSERT INTO pan_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","“ਇਸਰਾਏਲ ਦੇ ਘਰਾਣਿਆਂ ਨੂੰ ਆਖ, ਸੱਤਵੇਂ ਮਹੀਨੇ ਦੇ ਪਹਿਲੇ ਦਿਨ ਤੁਹਾਡੇ ਲਈ ਮਹਾਂ-ਸਬਤ ਹੋਵੇ, ਉਸ ਦਿਨ ਤੁਸੀਂ ਯਾਦਗੀਰੀ ਲਈ ਤੁਰ੍ਹੀ ਵਜਾਉਣਾ ਅਤੇ ਪਵਿੱਤਰ ਸਭਾ ਕਰਨਾ। ");
INSERT INTO pan_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","ਉਸ ਦਿਨ ਤੁਸੀਂ ਕੋਈ ਕੰਮ-ਧੰਦਾ ਨਾ ਕਰਨਾ ਪਰ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਇੱਕ ਅੱਗ ਦੀ ਭੇਟ ਚੜ੍ਹਾਉਣਾ।” ");
INSERT INTO pan_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","ਫੇਰ ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਆਖਿਆ, ");
INSERT INTO pan_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","“ਇਸੇ ਸੱਤਵੇਂ ਮਹੀਨੇ ਦਾ ਦਸਵਾਂ ਦਿਨ ਇੱਕ ਪ੍ਰਾਸਚਿਤ ਦਾ ਦਿਨ ਹੋਵੇ। ਉਹ ਤੁਹਾਡੇ ਲਈ ਪਵਿੱਤਰ ਸਭਾ ਦਾ ਦਿਨ ਹੋਵੇ, ਉਸ ਦਿਨ ਤੁਸੀਂ ਆਪਣੀਆਂ ਜਾਨਾਂ ਨੂੰ ਦੁੱਖ ਦੇਣਾ ਅਤੇ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਇੱਕ ਅੱਗ ਦੀ ਭੇਟ ਚੜ੍ਹਾਉਣਾ। ");
INSERT INTO pan_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","ਉਸ ਦਿਨ ਤੁਸੀਂ ਕੋਈ ਕੰਮ-ਧੰਦਾ ਨਾ ਕਰਨਾ ਕਿਉਂ ਜੋ ਉਹ ਪ੍ਰਾਸਚਿਤ ਦਾ ਦਿਨ ਹੈ ਜਿਸ ਵਿੱਚ ਯਹੋਵਾਹ ਤੁਹਾਡੇ ਪਰਮੇਸ਼ੁਰ ਦੇ ਅੱਗੇ ਤੁਹਾਡੇ ਲਈ ਪ੍ਰਾਸਚਿਤ ਕੀਤਾ ਜਾਵੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","ਉਸ ਦਿਨ ਜਿਹੜਾ ਆਪਣੀ ਜਾਨ ਨੂੰ ਦੁੱਖ ਨਾ ਦੇਵੇ, ਉਹ ਆਪਣੇ ਲੋਕਾਂ ਵਿੱਚੋਂ ਛੇਕਿਆ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","ਜਿਹੜਾ ਵੀ ਉਸ ਦਿਨ ਵਿੱਚ ਕੋਈ ਕੰਮ ਕਰੇ ਤਾਂ ਉਸ ਮਨੁੱਖ ਨੂੰ ਮੈਂ ਉਸ ਦੇ ਲੋਕਾਂ ਵਿੱਚੋਂ ਨਾਸ ਕਰਾਂਗਾ। ");
INSERT INTO pan_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","ਤੁਸੀਂ ਕਿਸੇ ਪ੍ਰਕਾਰ ਦਾ ਕੰਮ-ਧੰਦਾ ਨਾ ਕਰਨਾ। ਇਹ ਤੁਹਾਡੇ ਸਾਰੇ ਨਿਵਾਸ ਸਥਾਨਾਂ ਵਿੱਚ ਤੁਹਾਡੀਆਂ ਪੀੜ੍ਹੀਆਂ ਤੱਕ ਇੱਕ ਸਦਾ ਦੀ ਬਿਧੀ ਠਹਿਰੇ। ");
INSERT INTO pan_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","ਇਹ ਤੁਹਾਡੇ ਲਈ ਇੱਕ ਮਹਾਂ-ਸਬਤ ਦਾ ਦਿਨ ਹੋਵੇ, ਉਸ ਦਿਨ ਤੁਸੀਂ ਆਪਣੀਆਂ ਜਾਨਾਂ ਨੂੰ ਦੁੱਖ ਦੇਣਾ। ਤੁਸੀਂ ਉਸ ਮਹੀਨੇ ਦੇ ਨੌਵੇਂ ਦਿਨ ਦੀ ਸ਼ਾਮ ਤੋਂ ਅਗਲੀ ਸ਼ਾਮ ਤੱਕ ਵਿਸ਼ਰਾਮ ਦਾ ਦਿਨ ਮੰਨਣਾ।” ");
INSERT INTO pan_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","ਤਦ ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਆਖਿਆ, ");
INSERT INTO pan_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","“ਇਸਰਾਏਲੀਆਂ ਨੂੰ ਆਖ ਕਿ ਇਸੇ ਸੱਤਵੇਂ ਮਹੀਨੇ ਦੇ ਪੰਦਰਵੇਂ ਦਿਨ ਨੂੰ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਸੱਤ ਦਿਨ ਤੱਕ ਡੇਰਿਆਂ ਦਾ ਪਰਬ ਹੋਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","ਪਹਿਲੇ ਦਿਨ ਪਵਿੱਤਰ ਸਭਾ ਹੋਵੇ, ਉਸ ਦਿਨ ਤੁਸੀਂ ਕੋਈ ਕੰਮ-ਧੰਦਾ ਨਾ ਕਰਨਾ। ");
INSERT INTO pan_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","ਸੱਤ ਦਿਨ ਤੱਕ ਤੁਸੀਂ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਇੱਕ ਅੱਗ ਦੀ ਭੇਟ ਚੜ੍ਹਾਉਣਾ, ਅੱਠਵੇਂ ਦਿਨ ਤੁਹਾਡੀ ਪਵਿੱਤਰ ਸਭਾ ਹੋਵੇ, ਅਤੇ ਤੁਸੀਂ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਇੱਕ ਅੱਗ ਦੀ ਭੇਟ ਚੜ੍ਹਾਉਣਾ। ਇਹ ਇੱਕ ਖ਼ਾਸ ਸਭਾ ਦਾ ਦਿਨ ਹੈ, ਉਸ ਦਿਨ ਤੁਸੀਂ ਕੋਈ ਕੰਮ-ਧੰਦਾ ਨਾ ਕਰਨਾ।” ");
INSERT INTO pan_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","“ਯਹੋਵਾਹ ਦੇ ਠਹਿਰਾਏ ਹੋਏ ਪਰਬ ਇਹ ਹੀ ਹਨ, ਜਿਨ੍ਹਾਂ ਵਿੱਚ ਤੁਸੀਂ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਅੱਗ ਦੀਆਂ ਭੇਟਾਂ ਚੜ੍ਹਾਉਣਾ ਅਰਥਾਤ ਹੋਮ ਬਲੀ ਦੀ ਭੇਟ, ਮੈਦੇ ਦੀ ਭੇਟ, ਸੁੱਖ-ਸਾਂਦ ਦੀ ਬਲੀ ਦੀ ਭੇਟ ਅਤੇ ਪੀਣ ਦੀਆਂ ਭੇਟਾਂ ਆਪਣੇ ਨਿਯੁਕਤ ਸਮੇਂ ਤੇ ਚੜ੍ਹਾਈਆਂ ਜਾਣ ਅਤੇ ਪਵਿੱਤਰ ਸਭਾ ਦੀ ਘੋਸ਼ਣਾ ਕੀਤੀ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","ਆਪਣੀਆਂ ਭੇਟਾਂ, ਸਾਰੀਆਂ ਸੁੱਖਣਾਂ ਅਤੇ ਆਪਣੀਆਂ ਖੁਸ਼ੀ ਦੀਆਂ ਭੇਟਾਂ ਜੋ ਤੁਸੀਂ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਚੜ੍ਹਾਉਂਦੇ ਹੋ, ਉਨ੍ਹਾਂ ਤੋਂ ਵੱਧ ਤੁਸੀਂ ਯਹੋਵਾਹ ਦੇ ਸਬਤ ਨੂੰ ਮੰਨਣਾ। ");
INSERT INTO pan_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","“ਸੱਤਵੇਂ ਮਹੀਨੇ ਦੇ ਪੰਦਰਵੇਂ ਦਿਨ ਨੂੰ ਜਦ ਤੁਸੀਂ ਦੇਸ ਦੀ ਫ਼ਸਲ ਇਕੱਠਾ ਕਰੋ ਤਾਂ ਤੁਸੀਂ ਸੱਤ ਦਿਨਾਂ ਤੱਕ ਯਹੋਵਾਹ ਦਾ ਇੱਕ ਪਰਬ ਮਨਾਉਣਾ। ਪਹਿਲਾ ਦਿਨ ਸਬਤ ਅਤੇ ਅੱਠਵਾਂ ਦਿਨ ਵੀ ਸਬਤ ਹੋਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","ਅਤੇ ਪਹਿਲੇ ਦਿਨ ਤੁਸੀਂ ਸੋਹਣੇ-ਸੋਹਣੇ ਰੁੱਖਾਂ ਦੇ ਫਲ, ਖਜ਼ੂਰ ਦੀਆਂ ਟਾਹਣੀਆਂ, ਸੰਘਣੇ ਰੁੱਖਾਂ ਦੀਆਂ ਟਾਹਣੀਆਂ ਅਤੇ ਨਦੀ ਦਾ ਬੇਦ-ਮਜਨੂੰ ਲੈਣਾ ਅਤੇ ਤੁਸੀਂ ਯਹੋਵਾਹ ਆਪਣੇ ਪਰਮੇਸ਼ੁਰ ਦੇ ਅੱਗੇ ਸੱਤ ਦਿਨ ਤੱਕ ਅਨੰਦ ਅਤੇ ਖੁਸ਼ੀ ਮਨਾਉਣਾ। ");
INSERT INTO pan_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","ਹਰ ਸਾਲ ਵਿੱਚ ਸੱਤ ਦਿਨ ਤੱਕ ਤੁਸੀਂ ਯਹੋਵਾਹ ਦਾ ਇਹ ਪਰਬ ਮਨਾਉਣਾ। ਇਹ ਤੁਹਾਡੀਆਂ ਪੀੜ੍ਹੀਆਂ ਵਿੱਚ ਇੱਕ ਸਦਾ ਦੀ ਬਿਧੀ ਠਹਿਰੇ, ਤੁਸੀਂ ਸੱਤਵੇਂ ਮਹੀਨੇ ਵਿੱਚ ਇਸ ਨੂੰ ਮਨਾਉਣਾ। ");
INSERT INTO pan_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","ਸੱਤ ਦਿਨ ਤੱਕ ਤੁਸੀਂ ਝੌਂਪੜੀਆਂ ਵਿੱਚ ਰਹਿਣਾ, ਸਾਰੇ ਜੋ ਇਸਰਾਏਲ ਵਿੱਚ ਜੰਮੇ ਹਨ, ਉਹ ਝੌਂਪੜੀਆਂ ਵਿੱਚ ਰਹਿਣ, ");
INSERT INTO pan_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","ਤਾਂ ਜੋ ਤੁਹਾਡੀਆਂ ਪੀੜ੍ਹੀਆਂ ਜਾਣਨ, ਕਿ ਜਦ ਮੈਂ ਇਸਰਾਏਲੀਆਂ ਨੂੰ ਮਿਸਰ ਦੇਸ ਵਿੱਚੋਂ ਕੱਢ ਕੇ ਲਿਆਇਆ ਤਾਂ ਮੈਂ ਉਨ੍ਹਾਂ ਨੂੰ ਝੌਂਪੜੀਆਂ ਵਿੱਚ ਵਸਾਇਆ। ਮੈਂ ਯਹੋਵਾਹ ਤੁਹਾਡਾ ਪਰਮੇਸ਼ੁਰ ਹਾਂ।” ");
INSERT INTO pan_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","ਤਦ ਮੂਸਾ ਨੇ ਇਸਰਾਏਲੀਆਂ ਨੂੰ ਯਹੋਵਾਹ ਦੇ ਨਿਯੁਕਤ ਪਰਬਾਂ ਬਾਰੇ ਦੱਸ ਦਿੱਤਾ। ");
INSERT INTO pan_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","ਫੇਰ ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਆਖਿਆ, ");
INSERT INTO pan_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","ਇਸਰਾਏਲੀਆਂ ਨੂੰ ਹੁਕਮ ਦੇ ਕਿ ਮੇਰੇ ਸਾਹਮਣੇ ਚਾਨਣ ਲਈ ਉਹ ਨਪੀੜ ਕੇ ਕੱਢਿਆ ਹੋਇਆ ਜ਼ੈਤੂਨ ਦਾ ਸ਼ੁੱਧ ਤੇਲ ਤੇਰੇ ਕੋਲ ਲੈ ਕੇ ਆਉਣ ਤਾਂ ਜੋ ਸ਼ਮਾਦਾਨ ਸਦਾ ਜਗਦਾ ਰਹੇ। ");
INSERT INTO pan_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","ਹਾਰੂਨ ਉਸ ਨੂੰ ਸ਼ਾਮ ਤੋਂ ਲੈ ਕੇ ਸਵੇਰ ਤੱਕ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਸਦਾ ਦੇ ਲਈ, ਸਾਖੀ ਦੇ ਪਰਦੇ ਤੋਂ ਬਾਹਰ, ਮੰਡਲੀ ਦੇ ਡੇਰੇ ਵਿੱਚ ਸਜਾ ਕੇ ਰੱਖੇ। ਇਹ ਤੁਹਾਡੀਆਂ ਪੀੜ੍ਹੀਆਂ ਵਿੱਚ ਇੱਕ ਸਦਾ ਦੀ ਬਿਧੀ ਠਹਿਰੇ। ");
INSERT INTO pan_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","ਉਹ ਖ਼ਾਲਸ ਸੋਨੇ ਸ਼ਮਾਦਾਨ ਦੇ ਉੱਤੇ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਸਦਾ ਦੇ ਲਈ ਦੀਵਿਆਂ ਨੂੰ ਸਜਾ ਕੇ ਰੱਖਿਆ ਕਰੇ। ");
INSERT INTO pan_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","ਤੂੰ ਮੈਦਾ ਲੈ ਕੇ ਉਸ ਦੀਆਂ ਬਾਰਾਂ ਰੋਟੀਆਂ ਪਕਾਵੀਂ, ਇੱਕ-ਇੱਕ ਰੋਟੀ ਵਿੱਚ ਏਫ਼ਾਹ ਦਾ ਦੋ ਦਹਾਈ ਹਿੱਸਾ ਹੋਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","ਤਦ ਤੂੰ ਇਨ੍ਹਾਂ ਨੂੰ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਪਵਿੱਤਰ ਮੇਜ਼ ਦੇ ਉੱਤੇ ਦੋ ਕਤਾਰਾਂ ਬਣਾ ਕੇ ਇੱਕ-ਇੱਕ ਕਤਾਰ ਵਿੱਚ ਛੇ-ਛੇ ਰੋਟੀਆਂ ਰੱਖੀਂ। ");
INSERT INTO pan_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","ਤੂੰ ਇੱਕ-ਇੱਕ ਕਤਾਰ ਦੇ ਉੱਤੇ ਖ਼ਾਲਸ ਲੁਬਾਨ ਰੱਖੀਂ ਤਾਂ ਜੋ ਉਹ ਰੋਟੀ ਦੇ ਉੱਤੇ ਯਾਦਗੀਰੀ ਲਈ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਇੱਕ ਅੱਗ ਦੀ ਭੇਟ ਹੋਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","ਹਰੇਕ ਸਬਤ ਦੇ ਦਿਨ ਉਹ ਇਸ ਨੂੰ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਸਜਾ ਕੇ ਰੱਖੇ, ਇਹ ਇਸਰਾਏਲੀਆਂ ਵੱਲੋਂ ਇੱਕ ਸਦਾ ਦਾ ਨੇਮ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","ਉਹ ਹਾਰੂਨ ਅਤੇ ਉਸ ਦੇ ਪੁੱਤਰਾਂ ਦੀ ਹੋਵੇਗੀ ਅਤੇ ਉਹ ਉਸ ਨੂੰ ਪਵਿੱਤਰ ਸਥਾਨ ਵਿੱਚ ਖਾਣ ਕਿਉਂ ਜੋ ਉਹ ਯਹੋਵਾਹ ਦੀਆਂ ਅੱਗ ਦੀਆਂ ਭੇਟਾਂ ਦੇ ਵਿੱਚੋਂ ਇੱਕ ਸਦਾ ਦੀ ਬਿਧੀ ਕਰਕੇ ਹਾਰੂਨ ਦੇ ਲਈ ਅੱਤ ਪਵਿੱਤਰ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","ਉਨ੍ਹਾਂ ਦਿਨਾਂ ਵਿੱਚ ਇੱਕ ਇਸਰਾਏਲੀ ਇਸਤਰੀ ਦਾ ਪੁੱਤਰ, ਜਿਸ ਦਾ ਪਿਤਾ ਮਿਸਰੀ ਸੀ, ਉਹ ਇਸਰਾਏਲੀਆਂ ਦੇ ਵਿੱਚ ਰਹਿਣ ਲੱਗਾ ਅਤੇ ਇਸ ਇਸਰਾਏਲੀ ਇਸਤਰੀ ਦਾ ਪੁੱਤਰ ਅਤੇ ਕੋਈ ਹੋਰ ਇਸਰਾਏਲੀ ਮਨੁੱਖ ਡੇਰੇ ਵਿੱਚ ਝਗੜਨ ਲੱਗੇ, ");
INSERT INTO pan_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","ਅਤੇ ਉਸ ਇਸਰਾਏਲੀ ਇਸਤਰੀ ਦਾ ਪੁੱਤਰ ਯਹੋਵਾਹ ਦੇ ਨਾਮ ਦਾ ਨਿਰਾਦਰ ਕਰਕੇ ਕੁਫ਼ਰ ਬਕਣ ਲੱਗਾ, ਤਾਂ ਲੋਕ ਉਸ ਨੂੰ ਮੂਸਾ ਦੇ ਕੋਲ ਲੈ ਆਏ। ਉਸ ਦੀ ਮਾਂ ਦਾ ਨਾਮ “ਸਲੂਮੀਥ” ਸੀ, ਜੋ ਦਾਨ ਦੀ ਗੋਤ ਵਿੱਚੋਂ ਦਿਬਰੀ ਦੀ ਧੀ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","ਉਨ੍ਹਾਂ ਨੇ ਉਸ ਨੂੰ ਬੰਨ੍ਹ ਕੇ ਰੱਖਿਆ, ਜਦ ਤੱਕ ਉਹ ਇਸ ਮਾਮਲੇ ਵਿੱਚ ਯਹੋਵਾਹ ਦੀ ਮਰਜ਼ੀ ਨੂੰ ਨਾ ਜਾਣ ਲੈਣ। ");
INSERT INTO pan_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","ਤਦ ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਆਖਿਆ, ");
INSERT INTO pan_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","“ਜਿਸ ਨੇ ਕੁਫ਼ਰ ਬਕਿਆ ਹੈ, ਉਸ ਨੂੰ ਤੁਸੀਂ ਡੇਰੇ ਤੋਂ ਬਾਹਰ ਲੈ ਆਓ ਅਤੇ ਜਿਨ੍ਹਾਂ ਨੇ ਉਸ ਨੂੰ ਸੁਣਿਆ ਹੈ, ਉਹ ਆਪਣੇ ਹੱਥ ਉਸ ਦੇ ਸਿਰ ਉੱਤੇ ਰੱਖਣ, ਤਦ ਸਾਰੀ ਮੰਡਲੀ ਉਸ ਨੂੰ ਪੱਥਰਾਂ ਨਾਲ ਮਾਰ ਸੁੱਟੇ। ");
INSERT INTO pan_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","ਅਤੇ ਤੂੰ ਇਸਰਾਏਲੀਆਂ ਨੂੰ ਆਖ ਕਿ ਜਿਹੜਾ ਆਪਣੇ ਪਰਮੇਸ਼ੁਰ ਦੇ ਵਿਰੁੱਧ ਦੁਰਬਚਨ ਬੋਲੇ, ਉਹ ਆਪਣੇ ਪਾਪ ਦਾ ਭਾਰ ਆਪ ਹੀ ਚੁੱਕੇ। ");
INSERT INTO pan_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","ਕੋਈ ਵੀ ਜਿਹੜਾ ਯਹੋਵਾਹ ਦੇ ਨਾਮ ਦੀ ਨਿੰਦਿਆ ਕਰੇ ਉਹ ਜ਼ਰੂਰ ਹੀ ਮਾਰਿਆ ਜਾਵੇ ਅਤੇ ਸਾਰੀ ਮੰਡਲੀ ਨਿਸੰਗ ਉਸ ਨੂੰ ਪੱਥਰਾਂ ਨਾਲ ਮਾਰ ਸੁੱਟੇ, ਭਾਵੇਂ ਉਹ ਪਰਦੇਸੀ ਹੋਵੇ ਭਾਵੇਂ ਇਸਰਾਏਲ ਵਿੱਚ ਜੰਮਿਆ ਹੋਵੇ। ਜਿਸ ਵੇਲੇ ਉਹ ਯਹੋਵਾਹ ਦੇ ਨਾਮ ਦੀ ਨਿੰਦਿਆ ਕਰੇ, ਉਹ ਮਾਰਿਆ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","“ਜਿਹੜਾ ਕਿਸੇ ਮਨੁੱਖ ਨੂੰ ਮਾਰ ਦੇਵੇ ਉਹ ਜ਼ਰੂਰ ਹੀ ਮਾਰਿਆ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","ਜਿਹੜਾ ਕਿਸੇ ਪਸ਼ੂ ਨੂੰ ਮਾਰ ਦੇਵੇ, ਤਾਂ ਉਹ ਪਸ਼ੂ ਦੇ ਬਦਲੇ ਪਸ਼ੂ ਦੇਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","ਜਿਹੜਾ ਮਨੁੱਖ ਆਪਣੇ ਗੁਆਂਢੀ ਨੂੰ ਸੱਟ ਮਾਰੇ, ਤਾਂ ਜਿਵੇਂ ਉਸ ਨੇ ਕੀਤਾ ਹੈ, ਉਸੇ ਤਰ੍ਹਾਂ ਹੀ ਉਸ ਦੇ ਨਾਲ ਕੀਤਾ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","ਸੱਟ ਦੇ ਬਦਲੇ ਸੱਟ, ਅੱਖ ਦੇ ਬਦਲੇ ਅੱਖ, ਦੰਦ ਦੇ ਬਦਲੇ ਦੰਦ, ਜਿਵੇਂ ਉਸ ਨੇ ਕਿਸੇ ਮਨੁੱਖ ਨੂੰ ਸੱਟ ਮਾਰੀ, ਉਸੇ ਤਰ੍ਹਾਂ ਹੀ ਉਸ ਦੇ ਨਾਲ ਕੀਤਾ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","ਜਿਹੜਾ ਕਿਸੇ ਪਸ਼ੂ ਨੂੰ ਮਾਰੇ ਉਹ ਉਸ ਦੇ ਬਦਲੇ ਪਸ਼ੂ ਦੇਵੇ, ਪਰ ਜਿਹੜਾ ਕਿਸੇ ਮਨੁੱਖ ਨੂੰ ਮਾਰ ਸੁੱਟੇ, ਉਹ ਮਾਰਿਆ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","ਤੁਸੀਂ ਹਰ ਇੱਕ ਨਾਲ ਇੱਕੋ ਤਰ੍ਹਾਂ ਦਾ ਨਿਆਂ ਕਰਨਾ ਭਾਵੇਂ ਉਹ ਪਰਦੇਸੀ ਹੋਵੇ, ਭਾਵੇਂ ਤੁਹਾਡੇ ਆਪਣੇ ਦੇਸ ਦਾ, ਕਿਉਂ ਜੋ ਮੈਂ ਯਹੋਵਾਹ ਤੁਹਾਡਾ ਪਰਮੇਸ਼ੁਰ ਹਾਂ।” ");
INSERT INTO pan_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","ਤਦ ਜਿਵੇਂ ਮੂਸਾ ਨੇ ਆਖਿਆ, ਉਹ ਉਸ ਮਨੁੱਖ ਨੂੰ ਜਿਸ ਨੇ ਕੁਫ਼ਰ ਬਕਿਆ ਸੀ, ਡੇਰੇ ਤੋਂ ਬਾਹਰ ਲਿਆਏ ਅਤੇ ਉਸ ਨੂੰ ਪੱਥਰਾਂ ਨਾਲ ਮਾਰ ਦਿੱਤਾ। ਇਸਰਾਏਲੀਆਂ ਨੇ ਉਸੇ ਤਰ੍ਹਾਂ ਹੀ ਕੀਤਾ ਜਿਵੇਂ ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਹੁਕਮ ਦਿੱਤਾ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","ਫੇਰ ਯਹੋਵਾਹ ਸੀਨਈ ਦੇ ਪਰਬਤ ਵਿੱਚ ਮੂਸਾ ਨੂੰ ਆਖਿਆ, ");
INSERT INTO pan_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","ਇਸਰਾਏਲੀਆਂ ਨਾਲ ਗੱਲ ਕਰ ਅਤੇ ਉਨ੍ਹਾਂ ਨੂੰ ਆਖ, ਜਦ ਤੁਸੀਂ ਉਸ ਦੇਸ ਵਿੱਚ ਪਹੁੰਚ ਜਾਓ, ਜੋ ਮੈਂ ਤੁਹਾਨੂੰ ਦਿੰਦਾ ਹਾਂ, ਤਦ ਉਸ ਦੇਸ ਨੂੰ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਸਬਤ ਦਾ ਵਿਸ਼ਰਾਮ ਦਿਆ ਕਰਨਾ। ");
INSERT INTO pan_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","ਛੇ ਸਾਲ ਤੱਕ ਤੂੰ ਆਪਣੇ ਖੇਤ ਬੀਜੀਂ ਅਤੇ ਛੇ ਸਾਲ ਤੂੰ ਆਪਣੀਆਂ ਦਾਖਾਂ ਦੀ ਬਾਗਬਾਨੀ ਕਰੀਂ ਅਤੇ ਉਨ੍ਹਾਂ ਦੇ ਫ਼ਲਾਂ ਨੂੰ ਇਕੱਠਾ ਕਰੀਂ। ");
INSERT INTO pan_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","ਪਰ ਸੱਤਵੇਂ ਸਾਲ ਵਿੱਚ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਧਰਤੀ ਨੂੰ ਸਬਤ ਦਾ ਵਿਸ਼ਰਾਮ ਮਿਲਿਆ ਕਰੇ। ਤੂੰ ਨਾ ਤਾਂ ਆਪਣੇ ਖੇਤ ਬੀਜੀਂ ਅਤੇ ਨਾ ਹੀ ਆਪਣੇ ਦਾਖਾਂ ਦੀ ਬਾਗਬਾਨੀ ਕਰੀਂ। ");
INSERT INTO pan_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","ਜੋ ਕੁਝ ਤੇਰੇ ਖੇਤ ਵਿੱਚ ਆਪੇ ਹੀ ਉੱਗ ਪਵੇ, ਉਸ ਨੂੰ ਤੂੰ ਨਾ ਵੱਢੀਂ, ਨਾ ਹੀ ਆਪਣੇ ਖਾਲੀ ਛੱਡੇ ਬਾਗ਼ਾਂ ਵਿੱਚੋਂ ਦਾਖ਼ਾਂ ਤੋੜੀ ਕਿਉਂ ਜੋ ਉਹ ਧਰਤੀ ਦੇ ਲਈ ਵਿਸ਼ਰਾਮ ਦਾ ਸਾਲ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","ਧਰਤੀ ਦੇ ਸਬਤ ਵਿੱਚ ਪੈਦਾ ਹੋਈ ਫ਼ਸਲ ਤੋਂ ਹੀ ਤੁਹਾਡੇ ਲਈ, ਤੁਹਾਡੇ ਦਾਸ-ਦਾਸੀਆਂ ਲਈ, ਤੁਹਾਡੇ ਮਜ਼ਦੂਰਾਂ ਦੇ ਲਈ ਅਤੇ ਪਰਦੇਸੀਆਂ ਲਈ ਜੋ ਤੁਹਾਡੇ ਨਾਲ ਵੱਸਦੇ ਹਨ, ਤੁਹਾਨੂੰ ਭੋਜਨ ਮਿਲੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","ਅਤੇ ਤੇਰੇ ਪਸ਼ੂਆਂ ਦੇ ਲਈ ਅਤੇ ਉਨ੍ਹਾਂ ਸਾਰੇ ਜਾਨਵਰਾਂ ਦੇ ਲਈ ਜੋ ਤੇਰੇ ਦੇਸ ਵਿੱਚ ਹਨ, ਉਨ੍ਹਾਂ ਦਾ ਭੋਜਨ ਵੀ ਧਰਤੀ ਦੀ ਉਪਜ ਤੋਂ ਹੀ ਮਿਲੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","ਤੂੰ ਸਾਲ ਦੇ ਸੱਤ ਸਬਤ ਗਿਣ ਲਵੀਂ ਅਰਥਾਤ ਸੱਤ ਗੁਣਾ ਸੱਤ ਸਾਲ ਅਤੇ ਇਨ੍ਹਾਂ ਸੱਤਾਂ ਸਬਤਾਂ ਦੇ ਸਾਲਾਂ ਦਾ ਸਮਾਂ ਉਣੰਜਾ ਸਾਲ ਹੋਵੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","ਤਦ ਤੂੰ ਸੱਤਵੇਂ ਮਹੀਨੇ ਦੇ ਦਸਵੇਂ ਦਿਨ ਨੂੰ ਅਰਥਾਤ ਪ੍ਰਾਸਚਿਤ ਦੇ ਦਿਨ ਅਨੰਦ ਦੀ ਤੁਰ੍ਹੀ ਆਪਣੇ ਸਾਰੇ ਦੇਸ ਵਿੱਚ ਉੱਚੀ ਅਵਾਜ਼ ਵਿੱਚ ਵਜਾਵੀਂ। ");
INSERT INTO pan_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","ਫੇਰ ਤੁਸੀਂ ਉਸ ਪੰਜਾਹਵੇਂ ਸਾਲ ਨੂੰ ਪਵਿੱਤਰ ਰੱਖਣਾ ਅਤੇ ਦੇਸ ਦੇ ਸਾਰੇ ਵਾਸੀਆਂ ਦੇ ਲਈ ਛੁਟਕਾਰੇ ਦੀ ਘੋਸ਼ਣਾ ਕਰਨਾ, ਇਹ ਤੁਹਾਡੇ ਲਈ ਅਨੰਦ ਦਾ ਸਾਲ ਹੋਵੇਗਾ, ਅਤੇ ਤੁਸੀਂ ਆਪਣੀ-ਆਪਣੀ ਨਿੱਜ-ਭੂਮੀ ਅਤੇ ਆਪਣੇ-ਆਪਣੇ ਘਰਾਣਿਆਂ ਵਿੱਚ ਮੁੜ ਜਾਣਾ। ");
INSERT INTO pan_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","ਉਹ ਪੰਜਾਹਵਾਂ ਸਾਲ ਤੁਹਾਡੇ ਲਈ ਅਨੰਦ ਦਾ ਸਾਲ ਹੋਵੇਗਾ, ਉਸ ਵਿੱਚ ਤੁਸੀਂ ਨਾ ਬੀਜਣਾ ਅਤੇ ਨਾ ਉਸ ਨੂੰ ਵੱਢਣਾ ਜਿਹੜਾ ਆਪਣੇ ਆਪ ਉੱਗ ਪਵੇ, ਅਤੇ ਨਾ ਹੀ ਤੁਸੀਂ ਆਪਣੇ ਖਾਲੀ ਛੱਡੇ ਹੋਏ ਬਾਗ਼ਾਂ ਦੀਆਂ ਦਾਖਾਂ ਤੋੜਨਾ। ");
INSERT INTO pan_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","ਕਿਉਂ ਜੋ ਉਹ ਅਨੰਦ ਦਾ ਸਾਲ ਹੈ, ਉਹ ਤੁਹਾਡੇ ਲਈ ਪਵਿੱਤਰ ਹੋਵੇ। ਜੋ ਕੁਝ ਖੇਤ ਵਿੱਚ ਆਪਣੇ ਆਪ ਉੱਗੇ ਤੁਸੀਂ ਉਸ ਵਿੱਚੋਂ ਹੀ ਖਾਣਾ। ");
INSERT INTO pan_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","ਇਸ ਅਨੰਦ ਦੇ ਸਾਲ ਵਿੱਚ ਤੁਸੀਂ ਸਾਰੇ ਆਪੋ-ਆਪਣੀ ਨਿੱਜ ਭੂਮੀ ਵਿੱਚ ਮੁੜ ਜਾਣਾ। ");
INSERT INTO pan_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","ਜੇਕਰ ਤੂੰ ਆਪਣੇ ਗੁਆਂਢੀ ਨੂੰ ਕੁਝ ਵੇਚੇ ਜਾਂ ਆਪਣੇ ਗੁਆਂਢੀ ਦੇ ਹੱਥੋਂ ਕੁਝ ਮੁੱਲ ਲਵੇ ਤਾਂ ਤੁਸੀਂ ਇੱਕ ਦੂਜੇ ਨਾਲ ਅਣਉਚਿਤ ਵਿਵਹਾਰ ਨਾ ਕਰਨਾ। ");
INSERT INTO pan_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","ਅਨੰਦ ਦੇ ਸਾਲ ਤੋਂ ਬਾਅਦ ਜਿੰਨ੍ਹੇ ਸਾਲ ਹੋਣ ਉਨ੍ਹਾਂ ਦੀ ਗਿਣਤੀ ਦੇ ਅਨੁਸਾਰ ਮੁੱਲ ਠਹਿਰਾ ਕੇ ਤੁਸੀਂ ਆਪਣੇ ਗੁਆਂਢੀ ਤੋਂ ਮੁੱਲ ਲੈਣਾ ਅਤੇ ਖਰੀਦਣ ਦੇ ਸਾਲਾਂ ਦੇ ਲੇਖੇ ਅਨੁਸਾਰ ਉਹ ਤੇਰੇ ਹੱਥ ਵੇਚੇ। ");
INSERT INTO pan_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","ਸਾਲਾਂ ਦੇ ਵਧਣ ਅਨੁਸਾਰ, ਤੂੰ ਉਸ ਦਾ ਮੁੱਲ ਵਧਾਵੀਂ ਅਤੇ ਸਾਲਾਂ ਦੇ ਘਟਣ ਦੇ ਅਨੁਸਾਰ, ਤੂੰ ਉਸ ਦਾ ਮੁੱਲ ਘਟਾਵੀਂ ਕਿਉਂ ਜੋ ਸਾਲ ਦੀ ਉਪਜ ਦੇ ਲੇਖੇ ਅਨੁਸਾਰ ਹੀ ਉਹ ਤੇਰੇ ਕੋਲ ਵੇਚੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","ਤੁਸੀਂ ਇੱਕ ਦੂਜੇ ਉੱਤੇ ਹਨੇਰ ਨਾ ਕਰਨਾ, ਪਰ ਤੂੰ ਆਪਣੇ ਪਰਮੇਸ਼ੁਰ ਤੋਂ ਡਰੀਂ ਕਿਉਂ ਜੋ ਮੈਂ ਯਹੋਵਾਹ ਤੁਹਾਡਾ ਪਰਮੇਸ਼ੁਰ ਹਾਂ। ");
INSERT INTO pan_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","ਇਸ ਲਈ ਤੁਸੀਂ ਮੇਰੀਆਂ ਬਿਧੀਆਂ ਨੂੰ ਪੂਰਾ ਕਰਨਾ, ਅਤੇ ਮੇਰੇ ਨਿਯਮਾਂ ਨੂੰ ਮੰਨ ਕੇ ਉਨ੍ਹਾਂ ਦੇ ਅਨੁਸਾਰ ਚੱਲਣਾ, ਕਿਉਂ ਜੋ ਅਜਿਹਾ ਕਰਨ ਨਾਲ ਤੁਸੀਂ ਦੇਸ ਵਿੱਚ ਸੁੱਖ-ਸਾਂਦ ਨਾਲ ਰਹੋਗੇ। ");
INSERT INTO pan_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","ਉਹ ਧਰਤੀ ਆਪਣਾ ਫਲ ਉਪਜਾਵੇਗੀ ਅਤੇ ਤੁਸੀਂ ਰੱਜ ਕੇ ਖਾਓਗੇ ਅਤੇ ਤੁਸੀਂ ਉਸ ਦੇਸ਼ ਵਿੱਚ ਸੁੱਖ-ਸਾਂਦ ਨਾਲ ਰਹੋਗੇ। ");
INSERT INTO pan_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","ਜੇਕਰ ਤੁਸੀਂ ਆਖੋ ਕਿ ਸੱਤਵੇਂ ਸਾਲ ਵਿੱਚ ਅਸੀਂ ਕੀ ਖਾਵਾਂਗੇ, ਵੇਖੋ, ਨਾ ਤਾਂ ਅਸੀਂ ਬੀਜਾਂਗੇ ਅਤੇ ਨਾ ਹੀ ਅਸੀਂ ਅੰਨ ਇਕੱਠਾ ਕਰਾਂਗੇ, ");
INSERT INTO pan_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","ਤਦ ਮੈਂ ਛੇਵੇਂ ਸਾਲ ਵਿੱਚ ਤੁਹਾਨੂੰ ਅਜਿਹੀ ਬਰਕਤ ਦਿਆਂਗਾ ਕਿ ਧਰਤੀ ਤਿੰਨ ਸਾਲਾਂ ਦੇ ਲਈ ਫਲ ਉਪਜਾਵੇਗੀ। ");
INSERT INTO pan_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","ਅਤੇ ਤੁਸੀਂ ਅੱਠਵੇਂ ਸਾਲ ਵਿੱਚ ਬੀਜੋਗੇ ਅਤੇ ਨੌਵੇਂ ਸਾਲ ਤੱਕ ਪਹਿਲੀ ਫ਼ਸਲ ਵਿੱਚੋਂ ਹੀ ਖਾਂਦੇ ਰਹੋਗੇ। ਜਦ ਤੱਕ ਨੌਵੇਂ ਸਾਲ ਦੀ ਉਪਜ ਨਾ ਮਿਲੇ ਤਦ ਤੱਕ ਤੁਸੀਂ ਪੁਰਾਣੀ ਉਪਜ ਵਿੱਚੋਂ ਹੀ ਖਾਂਦੇ ਰਹੋਗੇ। ");
INSERT INTO pan_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","ਧਰਤੀ ਸਦਾ ਦੇ ਲਈ ਵੇਚੀ ਨਾ ਜਾਏ ਕਿਉਂ ਜੋ ਧਰਤੀ ਮੇਰੀ ਹੈ ਅਤੇ ਉਸ ਵਿੱਚ ਤੁਸੀਂ ਪਰਦੇਸੀ ਅਤੇ ਪਰਾਹੁਣੇ ਹੋ ਕੇ ਰਹਿੰਦੇ ਹੋ। ");
INSERT INTO pan_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","ਪਰ ਤੁਸੀਂ ਆਪਣੇ ਵਿਰਾਸਤ ਦੇ ਸਾਰੇ ਦੇਸ਼ ਵਿੱਚ ਧਰਤੀ ਨੂੰ ਛੁਡਾਉਣ ਦੀ ਮਨਜ਼ੂਰੀ ਦੇਣਾ। ");
INSERT INTO pan_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","ਜੇ ਕਦੇ ਤੇਰਾ ਭਰਾ ਕੰਗਾਲ ਹੋ ਜਾਵੇ ਅਤੇ ਆਪਣੇ ਹਿੱਸੇ ਦੀ ਜ਼ਮੀਨ ਵਿੱਚੋਂ ਕੁਝ ਵੇਚ ਦੇਵੇ ਅਤੇ ਤਾਂ ਉਸ ਦੇ ਸਭ ਤੋਂ ਨਜ਼ਦੀਕੀ ਰਿਸ਼ਤੇਦਾਰਾਂ ਵਿੱਚੋਂ ਕੋਈ ਆ ਕੇ ਉਸ ਜ਼ਮੀਨ ਨੂੰ ਛੁਡਾ ਲਵੇ ਜੋ ਉਸ ਦੇ ਭਰਾ ਨੇ ਵੇਚੀ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","ਪਰ ਜੇਕਰ ਉਸ ਦੇ ਲਈ ਕੋਈ ਛੁਡਾਉਣ ਵਾਲਾ ਨਾ ਹੋਵੇ ਅਤੇ ਉਹ ਮਨੁੱਖ ਆਪ ਉਸ ਨੂੰ ਛੁਡਾਉਣ ਦੇ ਯੋਗ ਹੋ ਜਾਵੇ, ");
INSERT INTO pan_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","ਤਦ ਉਹ ਉਸ ਨੂੰ ਵੇਚਣ ਦੇ ਸਮੇਂ ਤੋਂ ਸਾਲਾਂ ਦੀ ਗਿਣਤੀ ਕਰਕੇ ਬਾਕੀ ਸਾਲਾਂ ਦੀ ਉਪਜ ਦਾ ਮੁੱਲ ਉਸ ਨੂੰ ਮੋੜ ਦੇਵੇ, ਜਿਸ ਨੂੰ ਉਸ ਨੇ ਉਹ ਜ਼ਮੀਨ ਵੇਚੀ ਸੀ ਅਤੇ ਫੇਰ ਉਹ ਆਪਣੇ ਹਿੱਸੇ ਦੀ ਜ਼ਮੀਨ ਦਾ ਅਧਿਕਾਰੀ ਹੋ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","ਪਰ ਜੇਕਰ ਉਹ ਉਸ ਨੂੰ ਛੁਡਾਉਣ ਦੇ ਯੋਗ ਨਾ ਹੋਵੇ ਤਾਂ ਉਸ ਦੀ ਵੇਚੀ ਹੋਈ ਜ਼ਮੀਨ ਅਨੰਦ ਦੇ ਸਾਲ ਤੱਕ ਮੁੱਲ ਲੈਣ ਵਾਲੇ ਦੇ ਹੱਥ ਵਿੱਚ ਰਹੇਗੀ ਅਤੇ ਅਨੰਦ ਦੇ ਸਾਲ ਵਿੱਚ ਉਹ ਛੁੱਟ ਜਾਵੇਗੀ ਅਤੇ ਉਸ ਦੇ ਹਿੱਸੇ ਦੀ ਜ਼ਮੀਨ ਉਸ ਨੂੰ ਮਿਲ ਜਾਵੇਗੀ। ");
INSERT INTO pan_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","ਜੇਕਰ ਕੋਈ ਮਨੁੱਖ ਸ਼ਹਿਰਪਨਾਹ ਵਾਲੇ ਸ਼ਹਿਰ ਵਿੱਚ ਘਰ ਵੇਚੇ ਤਾਂ ਉਸ ਨੂੰ ਵੇਚਣ ਤੋਂ ਬਾਅਦ ਉਹ ਇੱਕ ਸਾਲ ਵਿੱਚ ਉਸ ਨੂੰ ਛੁਡਾ ਸਕਦਾ ਹੈ ਅਰਥਾਤ ਪੂਰੇ ਸਾਲ ਉਸ ਮਨੁੱਖ ਕੋਲ ਉਸ ਨੂੰ ਛੁਡਾਉਣ ਦਾ ਅਧਿਕਾਰ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","ਪਰ ਜੇਕਰ ਉਹ ਇੱਕ ਸਾਲ ਵਿੱਚ ਛੁਡਾਇਆ ਨਾ ਜਾਵੇ, ਤਦ ਉਹ ਘਰ ਜੋ ਸ਼ਹਿਰਪਨਾਹ ਵਾਲੇ ਸ਼ਹਿਰ ਵਿੱਚ ਹੈ, ਮੁੱਲ ਲੈਣ ਵਾਲੇ ਦਾ ਹੋਵੇਗਾ ਅਤੇ ਉਸ ਦੀਆਂ ਪੀੜ੍ਹੀਆਂ ਤੱਕ ਉਸੇ ਦਾ ਰਹੇਗਾ ਅਤੇ ਅਨੰਦ ਦੇ ਸਾਲ ਵਿੱਚ ਵੀ ਨਾ ਛੁਡਾਇਆ ਜਾਵੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","ਪਰ ਉਨ੍ਹਾਂ ਪਿੰਡਾਂ ਦੇ ਘਰ, ਜਿਨ੍ਹਾਂ ਦੇ ਦੁਆਲੇ ਸ਼ਹਿਰਪਨਾਹ ਨਹੀਂ ਹੈ, ਉਹ ਦੇਸ਼ ਦੇ ਖੇਤਾਂ ਦੀ ਤਰ੍ਹਾਂ ਹੀ ਸਮਝੇ ਜਾਣਗੇ, ਉਹ ਛੁਡਾਏ ਜਾ ਸਕਦੇ ਹਨ, ਉਹ ਅਨੰਦ ਦੇ ਸਾਲ ਵਿੱਚ ਛੱਡੇ ਜਾਣ। ");
INSERT INTO pan_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","ਫੇਰ ਵੀ ਲੇਵੀਆਂ ਦੇ ਸ਼ਹਿਰਾਂ ਵਿੱਚ ਉਨ੍ਹਾਂ ਦੇ ਨਿੱਜ-ਭਾਗ ਵਾਲੇ ਸ਼ਹਿਰਾਂ ਦੇ ਘਰਾਂ ਨੂੰ, ਲੇਵੀ ਕਿਸੇ ਵੀ ਸਮੇਂ ਛੁਡਾ ਸਕਦੇ ਹਨ। ");
INSERT INTO pan_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","ਪਰ ਜੇਕਰ ਕੋਈ ਲੇਵੀ ਆਪਣਾ ਹਿੱਸਾ ਨਾ ਛੁਡਾਵੇ ਤਾਂ ਉਹ ਵੇਚਿਆ ਹੋਇਆ ਘਰ ਜੋ ਉਸ ਦੇ ਹਿੱਸੇ ਦੇ ਸ਼ਹਿਰ ਵਿੱਚ ਹੋਵੇ, ਅਨੰਦ ਦੇ ਸਾਲ ਵਿੱਚ ਛੁੱਟ ਜਾਵੇ ਕਿਉਂ ਜੋ ਇਸਰਾਏਲੀਆਂ ਦੇ ਵਿੱਚ ਲੇਵੀਆਂ ਦਾ ਹਿੱਸਾ ਉਨ੍ਹਾਂ ਦੇ ਸ਼ਹਿਰ ਵਿੱਚ ਉਹ ਘਰ ਹੀ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","ਪਰ ਉਨ੍ਹਾਂ ਦੇ ਸ਼ਹਿਰਾਂ ਦੇ ਦੁਆਲੇ ਦੀਆਂ ਚਾਰਗਾਹਾਂ ਵੇਚੀਆਂ ਨਾ ਜਾਣ ਕਿਉਂ ਜੋ ਉਹ ਸਦਾ ਲਈ ਉਨ੍ਹਾਂ ਦਾ ਹਿੱਸਾ ਹਨ। ");
INSERT INTO pan_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","ਜੇਕਰ ਤੇਰਾ ਭਰਾ ਕੰਗਾਲ ਹੋ ਜਾਵੇ ਅਤੇ ਉਸ ਦਾ ਹੱਥ ਤੰਗ ਹੋਵੇ ਤਾਂ ਤੂੰ ਉਸ ਨੂੰ ਸੰਭਾਲੀਂ, ਉਹ ਪਰਦੇਸੀ ਜਾਂ ਪ੍ਰਾਹੁਣੇ ਦੀ ਤਰ੍ਹਾਂ ਤੇਰੇ ਨਾਲ ਰਹੇ। ");
INSERT INTO pan_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","ਉਸ ਤੋਂ ਤੂੰ ਵਿਆਜ ਜਾਂ ਮੁਨਾਫ਼ਾ ਨਾ ਲਵੀਂ ਪਰ ਆਪਣੇ ਪਰਮੇਸ਼ੁਰ ਤੋਂ ਡਰੀਂ ਤਾਂ ਜੋ ਤੇਰਾ ਭਰਾ ਤੇਰੇ ਨਾਲ ਹੀ ਵੱਸਦਾ ਰਹੇ। ");
INSERT INTO pan_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","ਤੂੰ ਉਸ ਨੂੰ ਆਪਣਾ ਪੈਸਾ ਵਿਆਜ ਤੇ ਨਾ ਦੇਵੀਂ, ਨਾ ਹੀ ਮੁਨਾਫ਼ੇ ਲਈ ਉਸ ਨੂੰ ਭੋਜਨ ਖਿਲਾਵੀਂ। ");
INSERT INTO pan_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","ਮੈਂ ਯਹੋਵਾਹ ਤੇਰਾ ਪਰਮੇਸ਼ੁਰ ਹਾਂ, ਜੋ ਤੁਹਾਨੂੰ ਕਨਾਨ ਦੇਸ਼ ਦੇਣ ਲਈ ਅਤੇ ਤੁਹਾਡਾ ਪਰਮੇਸ਼ੁਰ ਬਣਨ ਲਈ ਤੁਹਾਨੂੰ ਮਿਸਰ ਦੇਸ਼ ਵਿੱਚੋਂ ਕੱਢ ਲਿਆਇਆ ਹਾਂ। ");
INSERT INTO pan_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","ਜੇਕਰ ਤੁਹਾਡੇ ਵਿੱਚ ਤੁਹਾਡਾ ਕੋਈ ਭਰਾ ਕੰਗਾਲ ਹੋ ਜਾਵੇ ਅਤੇ ਆਪਣੇ ਆਪ ਨੂੰ ਤੇਰੇ ਹੱਥ ਵੇਚ ਦੇਵੇ ਤਾਂ ਤੂੰ ਉਸ ਤੋਂ ਦਾਸ ਵਰਗੀ ਸੇਵਾ ਨਾ ਕਰਵਾਈਂ। ");
INSERT INTO pan_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","ਪਰ ਉਹ ਤੇਰੇ ਕੋਲ ਮਜ਼ਦੂਰ ਜਾਂ ਪ੍ਰਾਹੁਣੇ ਦੀ ਤਰ੍ਹਾਂ ਰਹੇ ਅਤੇ ਅਨੰਦ ਦੇ ਸਾਲ ਤੱਕ ਤੇਰੀ ਸੇਵਾ ਕਰੇ, ");
INSERT INTO pan_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","ਅਤੇ ਫੇਰ ਉਹ ਆਪਣੇ ਬਾਲ ਬੱਚਿਆਂ ਸਮੇਤ ਤੇਰੇ ਕੋਲੋਂ ਛੁੱਟ ਜਾਵੇ ਅਤੇ ਆਪਣੇ ਟੱਬਰ ਕੋਲ ਆਪਣੇ ਪੁਰਖਿਆਂ ਦੀ ਨਿੱਜ-ਭੂਮੀ ਨੂੰ ਮੁੜ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","ਕਿਉਂ ਜੋ ਉਹ ਮੇਰੇ ਹੀ ਦਾਸ ਹਨ, ਜਿਨ੍ਹਾਂ ਨੂੰ ਮੈਂ ਮਿਸਰ ਦੇਸ਼ ਵਿੱਚੋਂ ਕੱਢ ਲਿਆਇਆ ਹਾਂ, ਇਸ ਲਈ ਉਹ ਦਾਸਾਂ ਵਾਂਗੂੰ ਵੇਚੇ ਨਾ ਜਾਣ। ");
INSERT INTO pan_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","ਤੂੰ ਉਨ੍ਹਾਂ ਦੇ ਉੱਤੇ ਹਨੇਰ ਨਾ ਕਰੀਂ ਪਰ ਆਪਣੇ ਪਰਮੇਸ਼ੁਰ ਤੋਂ ਡਰੀਂ। ");
INSERT INTO pan_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","ਤੇਰੇ ਕੋਲ ਜੋ ਵੀ ਦਾਸ ਅਤੇ ਦਾਸੀਆਂ ਹੋਣ, ਉਹ ਉਨ੍ਹਾਂ ਲੋਕਾਂ ਵਿੱਚੋਂ ਹੋਣ ਜੋ ਤੁਹਾਡੇ ਆਲੇ-ਦੁਆਲੇ ਹਨ, ਉਨ੍ਹਾਂ ਤੋਂ ਹੀ ਤੁਸੀਂ ਦਾਸ ਅਤੇ ਦਾਸੀਆਂ ਨੂੰ ਮੁੱਲ ਲੈਣਾ। ");
INSERT INTO pan_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","ਉਨ੍ਹਾਂ ਓਪਰਿਆਂ ਦੀਆਂ ਸੰਤਾਨਾਂ ਵਿੱਚੋਂ ਜੋ ਤੁਹਾਡੇ ਵਿਚਕਾਰ ਵੱਸਦੇ ਹਨ ਅਤੇ ਉਨ੍ਹਾਂ ਦੇ ਟੱਬਰਾਂ ਵਿੱਚੋਂ ਜੋ ਤੁਹਾਡੇ ਨਾਲ ਹਨ ਅਤੇ ਤੁਹਾਡੇ ਦੇਸ਼ ਵਿੱਚ ਜੰਮੇ ਹੋਣ, ਉਨ੍ਹਾਂ ਵਿੱਚੋਂ ਤੁਸੀਂ ਦਾਸ-ਦਾਸੀਆਂ ਮੁੱਲ ਲਵੋ ਅਤੇ ਉਹ ਤੁਹਾਡੇ ਅਧਿਕਾਰ ਵਿੱਚ ਰਹਿਣ। ");
INSERT INTO pan_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","ਅਤੇ ਤੁਸੀਂ ਆਪਣੇ ਬਾਅਦ ਆਪਣੇ ਪੁੱਤਰਾਂ ਨੂੰ ਵੀ ਉਨ੍ਹਾਂ ਦਾ ਅਧਿਕਾਰੀ ਬਣਾ ਸਕੋਗੇ, ਉਹ ਉਨ੍ਹਾਂ ਦੀ ਜਾਇਦਾਦ ਹੋਣਗੇ, ਉਹ ਸਦਾ ਦੇ ਲਈ ਤੇਰੇ ਦਾਸ ਬਣਨ ਪਰ ਤੁਸੀਂ ਆਪਣੇ ਇਸਰਾਏਲੀਆਂ ਭਰਾਵਾਂ ਵਿੱਚ ਇੱਕ ਦੂਜੇ ਉੱਤੇ ਹਨੇਰ ਨਾ ਕਰਨਾ। ");
INSERT INTO pan_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","ਜੇਕਰ ਕੋਈ ਪਰਦੇਸੀ ਜਾਂ ਓਪਰਾ ਜੋ ਤੇਰੇ ਨਾਲ ਹੈ, ਧਨਵਾਨ ਹੋ ਜਾਵੇ ਅਤੇ ਉਸ ਦੇ ਕੋਲ ਰਹਿਣ ਵਾਲਾ ਤੇਰਾ ਭਰਾ ਕੰਗਾਲ ਹੋ ਕੇ ਆਪਣੇ ਆਪ ਨੂੰ ਉਸ ਪਰਦੇਸੀ ਜਾਂ ਓਪਰੇ ਜਾਂ ਉਸ ਦੇ ਟੱਬਰ ਦੇ ਹੱਥ ਵੇਚ ਦੇਵੇ, ");
INSERT INTO pan_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","ਤਾਂ ਉਸ ਦੇ ਵਿਕਣ ਤੋਂ ਬਾਅਦ ਉਹ ਫੇਰ ਛੁਡਾਇਆ ਜਾ ਸਕਦਾ ਹੈ, ਉਸ ਦੇ ਭਰਾਵਾਂ ਵਿੱਚੋਂ ਕੋਈ ਉਸ ਨੂੰ ਛੁਡਾ ਲਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","ਉਸ ਦਾ ਚਾਚਾ, ਜਾਂ ਉਸ ਦੇ ਚਾਚੇ ਦਾ ਪੁੱਤਰ, ਜਾਂ ਉਸ ਦੇ ਟੱਬਰ ਵਿੱਚੋਂ ਕੋਈ ਨਜ਼ਦੀਕੀ ਰਿਸ਼ਤੇਦਾਰ ਉਸ ਨੂੰ ਛੁਡਾ ਸਕਦਾ ਹੈ, ਜਾਂ ਜਦ ਉਹ ਆਪਣੇ ਆਪ ਨੂੰ ਛੁਡਾਉਣ ਦੇ ਯੋਗ ਹੋ ਜਾਵੇ ਤਾਂ ਆਪਣੇ ਆਪ ਨੂੰ ਛੁਡਾ ਲਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","ਉਹ ਆਪਣੇ ਮੁੱਲ ਲੈਣ ਵਾਲੇ ਦੇ ਨਾਲ, ਆਪਣੇ ਵੇਚੇ ਜਾਣ ਦੇ ਸਾਲ ਤੋਂ ਲੈ ਕੇ ਅਨੰਦ ਦੇ ਸਾਲ ਤੱਕ ਲੇਖਾ ਕਰੇ ਅਤੇ ਉਸ ਦੇ ਵਿਕਣ ਦਾ ਮੁੱਲ ਸਾਲਾਂ ਦੇ ਲੇਖੇ ਦੇ ਅਨੁਸਾਰ ਹੋਵੇ ਅਰਥਾਤ ਉਹ ਉਸ ਨੂੰ ਛੱਡਣ ਦਾ ਮੁੱਲ ਮਜ਼ਦੂਰ ਦੀ ਮਜ਼ਦੂਰੀ ਦੇ ਅਨੁਸਾਰ ਠਹਿਰਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","ਜੇਕਰ ਅਨੰਦ ਦੇ ਸਾਲ ਵਿੱਚ ਬਹੁਤ ਸਾਲ ਬਾਕੀ ਰਹਿੰਦੇ ਹੋਣ ਤਾਂ ਉਹ ਆਪਣੇ ਆਪ ਨੂੰ ਛੁਡਾਉਣ ਲਈ ਜਿਸ ਮੁੱਲ ਵਿੱਚ ਉਹ ਵੇਚਿਆ ਗਿਆ ਸੀ, ਸਾਲਾਂ ਦੇ ਅਨੁਸਾਰ ਉਸ ਨੂੰ ਮੋੜ ਦੇਵੇ, ");
INSERT INTO pan_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","ਅਤੇ ਜੇਕਰ ਅਨੰਦ ਦੇ ਸਾਲ ਵਿੱਚ ਥੋੜ੍ਹੇ ਸਾਲ ਹੀ ਰਹਿੰਦੇ ਹੋਣ ਤਾਂ ਉਹ ਆਪਣੇ ਮੁੱਲ ਲੈਣ ਵਾਲੇ ਦੇ ਨਾਲ ਲੇਖਾ ਕਰੇ ਅਤੇ ਆਪਣੇ ਆਪ ਨੂੰ ਛੁਡਾਉਣ ਦਾ ਮੁੱਲ ਉਨ੍ਹਾਂ ਸਾਲਾਂ ਦੇ ਅਨੁਸਾਰ ਉਸ ਨੂੰ ਮੋੜ ਦੇਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","ਉਹ ਆਪਣੇ ਸੁਆਮੀ ਦੇ ਨਾਲ ਉਸ ਮਜ਼ਦੂਰ ਦੀ ਤਰ੍ਹਾਂ ਰਹੇ, ਜਿਸ ਦੀ ਸਲਾਨਾ ਮਜ਼ਦੂਰੀ ਠਹਿਰਾਈ ਜਾਂਦੀ ਹੈ, ਅਤੇ ਉਸ ਦਾ ਸੁਆਮੀ ਤੇਰੇ ਵੇਖਦਿਆਂ ਉਸ ਦੇ ਉੱਤੇ ਹਨੇਰ ਨਾ ਕਰੇ। ");
INSERT INTO pan_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","ਪਰ ਜੇਕਰ ਉਹ ਇਨ੍ਹਾਂ ਸਾਰੇ ਤਰੀਕਿਆਂ ਦੇ ਨਾਲ ਛੁਡਾਇਆ ਨਾ ਜਾਵੇ ਤਾਂ ਉਹ ਅਨੰਦ ਦੇ ਸਾਲ ਵਿੱਚ ਆਪਣੇ ਬਾਲ ਬੱਚਿਆਂ ਸਮੇਤ ਛੁੱਟ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","ਕਿਉਂ ਜੋ ਇਸਰਾਏਲੀ ਮੇਰੇ ਦਾਸ ਹਨ। ਉਹ ਮੇਰੇ ਹੀ ਦਾਸ ਹਨ, ਜਿਨ੍ਹਾਂ ਨੂੰ ਮੈਂ ਮਿਸਰ ਦੇਸ਼ ਵਿੱਚੋਂ ਕੱਢ ਲਿਆਇਆ ਹਾਂ। ਮੈਂ ਯਹੋਵਾਹ ਤੁਹਾਡਾ ਪਰਮੇਸ਼ੁਰ ਹਾਂ। ");
INSERT INTO pan_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","ਤੁਸੀਂ ਆਪਣੇ ਲਈ ਕੋਈ ਮੂਰਤ ਨਾ ਬਣਾਉਣਾ, ਨਾ ਹੀ ਆਪਣੇ ਲਈ ਕੋਈ ਉੱਕਰੀ ਹੋਈ ਮੂਰਤ ਜਾਂ ਥੰਮ੍ਹ ਖੜ੍ਹਾ ਕਰਨਾ, ਅਤੇ ਨਾ ਹੀ ਮੱਥਾ ਟੇਕਣ ਲਈ ਆਪਣੇ ਦੇਸ਼ ਵਿੱਚ ਕੋਈ ਪੱਥਰ ਦੀ ਮੂਰਤ ਸਥਾਪਿਤ ਕਰਨਾ, ਕਿਉਂ ਜੋ ਮੈਂ ਯਹੋਵਾਹ ਤੁਹਾਡਾ ਪਰਮੇਸ਼ੁਰ ਹਾਂ। ");
INSERT INTO pan_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","ਤੁਸੀਂ ਮੇਰੇ ਸਬਤਾਂ ਨੂੰ ਮੰਨਣਾ ਅਤੇ ਮੇਰੇ ਪਵਿੱਤਰ ਸਥਾਨ ਦਾ ਆਦਰ ਕਰਨਾ। ਮੈਂ ਯਹੋਵਾਹ ਹਾਂ। ");
INSERT INTO pan_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","ਜੇਕਰ ਤੁਸੀਂ ਮੇਰੀਆਂ ਬਿਧੀਆਂ ਅਨੁਸਾਰ ਚੱਲੋ ਅਤੇ ਮੇਰੇ ਹੁਕਮਾਂ ਨੂੰ ਮੰਨ ਕੇ ਉਨ੍ਹਾਂ ਨੂੰ ਪੂਰਾ ਕਰੋ, ");
INSERT INTO pan_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","ਤਾਂ ਮੈਂ ਵੇਲੇ ਸਿਰ ਮੀਂਹ ਵਰ੍ਹਾਵਾਂਗਾ ਅਤੇ ਧਰਤੀ ਆਪਣੀ ਉਪਜ ਉਪਜਾਵੇਗੀ ਅਤੇ ਧਰਤੀ ਦੇ ਰੁੱਖ ਆਪਣੇ ਫਲ ਉਗਾਉਣਗੇ। ");
INSERT INTO pan_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","ਅਤੇ ਤੁਸੀਂ ਦਾਖਾਂ ਤੋੜਨ ਦੇ ਸਮੇਂ ਤੱਕ ਗਾਹੁੰਦੇ ਰਹੋਗੇ ਅਤੇ ਬੀਜਣ ਦੇ ਸਮੇਂ ਵੀ ਦਾਖਾਂ ਤੋੜੋਗੇ ਅਤੇ ਤੁਸੀਂ ਆਪਣੀ ਰੋਟੀ ਰੱਜ ਕੇ ਖਾਓਗੇ ਅਤੇ ਆਪਣੇ ਦੇਸ਼ ਵਿੱਚ ਸੁੱਖ ਨਾਲ ਰਹੋਗੇ। ");
INSERT INTO pan_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","ਮੈਂ ਉਸ ਦੇਸ਼ ਵਿੱਚ ਸੁੱਖ ਬਖ਼ਸ਼ਾਂਗਾ ਅਤੇ ਤੁਸੀਂ ਲੰਮੇ ਪਓਗੇ ਪਰ ਤੁਹਾਨੂੰ ਕੋਈ ਨਾ ਡਰਾਵੇਗਾ ਅਤੇ ਮੈਂ ਖ਼ਤਰਨਾਕ ਜਾਨਵਰਾਂ ਨੂੰ ਦੇਸ਼ ਵਿੱਚੋਂ ਕੱਢ ਦਿਆਂਗਾ ਅਤੇ ਤਲਵਾਰ ਤੁਹਾਡੇ ਦੇਸ਼ ਵਿੱਚ ਨਾ ਚੱਲੇਗੀ। ");
INSERT INTO pan_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","ਤੁਸੀਂ ਆਪਣੇ ਵੈਰੀਆਂ ਨੂੰ ਭਜਾਓਗੇ ਅਤੇ ਉਹ ਤੁਹਾਡੇ ਅੱਗੇ ਤਲਵਾਰ ਨਾਲ ਡਿੱਗਣਗੇ। ");
INSERT INTO pan_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","ਤੁਹਾਡੇ ਵਿੱਚੋਂ ਪੰਜ ਮਨੁੱਖ ਸੌ ਨੂੰ ਅਤੇ ਸੌ ਮਨੁੱਖ ਦਸ ਹਜ਼ਾਰ ਨੂੰ ਭਜਾਉਣਗੇ ਅਤੇ ਤੁਹਾਡੇ ਵੈਰੀ ਤੁਹਾਡੇ ਅੱਗੇ ਤਲਵਾਰ ਨਾਲ ਡਿੱਗਣਗੇ। ");
INSERT INTO pan_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","ਮੈਂ ਤੁਹਾਡੇ ਵੱਲ ਧਿਆਨ ਕਰਾਂਗਾ ਅਤੇ ਤੁਹਾਨੂੰ ਫਲਾਵਾਂਗਾ ਅਤੇ ਵਧਾਵਾਂਗਾ ਅਤੇ ਤੁਹਾਡੇ ਨਾਲ ਆਪਣਾ ਨੇਮ ਕਾਇਮ ਰੱਖਾਂਗਾ। ");
INSERT INTO pan_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","ਤੁਸੀਂ ਪੁਰਾਣੇ ਪਦਾਰਥਾਂ ਨੂੰ ਖਾਓਗੇ ਅਤੇ ਨਵੇਂ ਪਦਾਰਥ ਦੇ ਕਾਰਨ ਪੁਰਾਣੇ ਪਦਾਰਥਾਂ ਨੂੰ ਕੱਢ ਸੁੱਟੋਗੇ। ");
INSERT INTO pan_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","ਅਤੇ ਮੈਂ ਆਪਣਾ ਡੇਰਾ ਤੁਹਾਡੇ ਵਿਚਕਾਰ ਖੜ੍ਹਾ ਕਰਾਂਗਾ ਅਤੇ ਮੇਰਾ ਜੀਅ ਤੁਹਾਨੂੰ ਮਾੜੇ ਨਾ ਸਮਝੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","ਮੈਂ ਤੁਹਾਡੇ ਵਿਚਕਾਰ ਤੁਰਾਂਗਾ ਅਤੇ ਤੁਹਾਡਾ ਪਰਮੇਸ਼ੁਰ ਬਣਾਂਗਾ ਅਤੇ ਤੁਸੀਂ ਮੇਰੀ ਪਰਜਾ ਹੋਵੋਗੇ। ");
INSERT INTO pan_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","ਮੈਂ ਉਹ ਯਹੋਵਾਹ ਤੁਹਾਡਾ ਪਰਮੇਸ਼ੁਰ ਹਾਂ ਜੋ ਤੁਹਾਨੂੰ ਮਿਸਰ ਦੇਸ਼ ਵਿੱਚੋਂ ਕੱਢ ਲਿਆਇਆ, ਤਾਂ ਜੋ ਤੁਸੀਂ ਉਨ੍ਹਾਂ ਦੇ ਦਾਸ ਨਾ ਰਹੋ ਅਤੇ ਮੈਂ ਤੁਹਾਡੇ ਧੌਣ ਦੇ ਜੂਲੇ ਨੂੰ ਤੋੜ ਸੁੱਟਿਆ ਅਤੇ ਤੁਹਾਨੂੰ ਸਿੱਧੇ ਕਰਕੇ ਚਲਾਇਆ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","ਪਰ ਜੇਕਰ ਤੁਸੀਂ ਮੇਰੀ ਨਾ ਸੁਣੋਗੇ ਅਤੇ ਇਨ੍ਹਾਂ ਸਾਰਿਆਂ ਹੁਕਮਾਂ ਨੂੰ ਨਾ ਮੰਨੋਗੇ, ");
INSERT INTO pan_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","ਅਤੇ ਜੇਕਰ ਤੁਸੀਂ ਮੇਰੀਆਂ ਬਿਧੀਆਂ ਨੂੰ ਤਿਆਗ ਦਿਓ ਅਤੇ ਮੇਰੇ ਨਿਆਂ ਤੁਹਾਡੇ ਜੀਅ ਨੂੰ ਮਾੜੇ ਲੱਗਣ ਕਿ ਤੁਸੀਂ ਮੇਰੇ ਹੁਕਮਾਂ ਨੂੰ ਨਾ ਮੰਨੋ ਸਗੋਂ ਮੇਰੇ ਨੇਮ ਨੂੰ ਤੋੜ ਦਿਓ, ");
INSERT INTO pan_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","ਤਾਂ ਮੈਂ ਤੁਹਾਡੇ ਨਾਲ ਇਹ ਕਰਾਂਗਾ ਅਰਥਾਤ ਮੈਂ ਤੁਹਾਡੇ ਉੱਤੇ ਡਰ, ਲਾ-ਇਲਾਜ਼ ਰੋਗ ਅਤੇ ਤਾਪ ਪਾਵਾਂਗਾ ਜੋ ਤੁਹਾਡੀਆਂ ਅੱਖਾਂ ਦਾ ਨਾਸ ਕਰਨਗੇ ਅਤੇ ਤੁਹਾਡੇ ਮਨਾਂ ਨੂੰ ਉਦਾਸ ਕਰਨਗੇ ਅਤੇ ਤੁਸੀਂ ਵਿਅਰਥ ਹੀ ਆਪਣੇ ਬੀਜ ਬੀਜੋਗੇ ਕਿਉਂ ਜੋ ਤੁਹਾਡੇ ਵੈਰੀ ਉਸ ਨੂੰ ਖਾ ਜਾਣਗੇ। ");
INSERT INTO pan_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","ਮੈਂ ਵੀ ਤੁਹਾਡੇ ਵਿਰੁੱਧ ਹੋਵਾਂਗਾ ਅਤੇ ਤੁਸੀਂ ਆਪਣੇ ਵੈਰੀਆਂ ਦੇ ਅੱਗੇ ਵੱਢੇ ਜਾਓਗੇ ਅਤੇ ਜਿਹੜੇ ਤੁਹਾਡੇ ਨਾਲ ਵੈਰ ਕਰਦੇ ਹਨ, ਉਹ ਤੁਹਾਡੇ ਉੱਤੇ ਰਾਜ ਕਰਨਗੇ ਅਤੇ ਭਾਵੇਂ ਕੋਈ ਤੁਹਾਡਾ ਪਿੱਛਾ ਨਾ ਕਰੇ ਤਾਂ ਵੀ ਤੁਸੀਂ ਭੱਜੋਗੇ। ");
INSERT INTO pan_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","ਅਤੇ ਜੇਕਰ ਤੁਸੀਂ ਇਹ ਸਭ ਕਰਕੇ ਵੀ ਤੁਸੀਂ ਮੇਰੇ ਵੱਲ ਧਿਆਨ ਨਾ ਕਰੋ, ਤਾਂ ਮੈਂ ਤੁਹਾਡੇ ਪਾਪਾਂ ਦੇ ਕਾਰਨ ਤੁਹਾਨੂੰ ਸੱਤ ਗੁਣਾ ਹੋਰ ਸਜ਼ਾ ਦੇਵਾਂਗਾ। ");
INSERT INTO pan_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","ਅਤੇ ਮੈਂ ਤੁਹਾਡੀ ਜੋਰਾਵਰੀ ਦਾ ਹੰਕਾਰ ਤੋੜ ਦਿਆਂਗਾ ਅਤੇ ਤੁਹਾਡੇ ਲਈ ਅਕਾਸ਼ ਨੂੰ ਲੋਹੇ ਵਰਗਾ ਅਤੇ ਧਰਤੀ ਨੂੰ ਪਿੱਤਲ ਵਰਗੀ ਬਣਾਵਾਂਗਾ। ");
INSERT INTO pan_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","ਅਤੇ ਤੁਹਾਡਾ ਜ਼ੋਰ ਵਿਅਰਥ ਹੋ ਜਾਵੇਗਾ ਕਿਉਂ ਜੋ ਤੁਹਾਡੀ ਧਰਤੀ ਆਪਣੀ ਉਪਜ ਨਾ ਉਪਜਾਵੇਗੀ ਅਤੇ ਧਰਤੀ ਦੇ ਰੁੱਖ ਵੀ ਆਪਣੇ ਫਲ ਨਾ ਉਗਾਉਣਗੇ। ");
INSERT INTO pan_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","ਜੇਕਰ ਤੁਸੀਂ ਮੇਰੇ ਵਿਰੁੱਧ ਚਲਦੇ ਰਹੋ ਅਤੇ ਮੇਰੀ ਗੱਲ ਵੱਲ ਧਿਆਨ ਨਾ ਕਰੋ ਤਾਂ ਮੈਂ ਤੁਹਾਡੇ ਪਾਪਾਂ ਦੇ ਅਨੁਸਾਰ ਤੁਹਾਡੇ ਉੱਤੇ ਸੱਤ ਗੁਣਾ ਹੋਰ ਬਵਾ ਪਾਵਾਂਗਾ। ");
INSERT INTO pan_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","ਮੈਂ ਜੰਗਲੀ ਜਾਨਵਰਾਂ ਨੂੰ ਤੁਹਾਡੇ ਵਿਚਕਾਰ ਘੱਲਾਂਗਾ ਜੋ ਤੁਹਾਡੇ ਬੱਚਿਆਂ ਨੂੰ ਖੋਹ ਲੈਣਗੇ ਅਤੇ ਤੁਹਾਡੇ ਪਸ਼ੂਆਂ ਦਾ ਨਾਸ ਕਰਨਗੇ ਅਤੇ ਤੁਹਾਡੀ ਗਿਣਤੀ ਘਟਾ ਦੇਣਗੇ ਅਤੇ ਤੁਹਾਡੀਆਂ ਪੱਕੀਆਂ ਸੜਕਾਂ ਵਿਰਾਨ ਹੋ ਜਾਣਗੀਆਂ। ");
INSERT INTO pan_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","ਫੇਰ ਜੇਕਰ ਤੁਸੀਂ ਇਨ੍ਹਾਂ ਗੱਲਾਂ ਵਿੱਚ ਵੀ ਮੇਰੀ ਤਾੜਨਾ ਨਾਲ ਨਾ ਸੁਧਰੋ ਪਰ ਮੇਰੇ ਵਿਰੁੱਧ ਹੀ ਚਲਦੇ ਰਹੋ, ");
INSERT INTO pan_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","ਤਾਂ ਮੈਂ ਵੀ ਤੁਹਾਡੇ ਵਿਰੁੱਧ ਚੱਲਾਂਗਾ ਅਤੇ ਤੁਹਾਡੇ ਪਾਪਾਂ ਦੇ ਕਾਰਨ ਮੈਂ ਤੁਹਾਨੂੰ ਸੱਤ ਗੁਣਾ ਹੋਰ ਸਜ਼ਾ ਦੇਵਾਂਗਾ। ");
INSERT INTO pan_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","ਅਤੇ ਮੈਂ ਤੁਹਾਡੇ ਉੱਤੇ ਅਜਿਹੀ ਤਲਵਾਰ ਚਲਾਵਾਂਗਾ, ਜਿਹੜੀ ਮੇਰਾ ਨੇਮ ਤੋੜਨ ਦਾ ਬਦਲਾ ਲਵੇ ਅਤੇ ਜਿਸ ਵੇਲੇ ਤੁਸੀਂ ਆਪਣੇ ਸ਼ਹਿਰਾਂ ਵਿੱਚ ਇਕੱਠੇ ਹੋਵੋਗੇ ਤਾਂ ਮੈਂ ਤੁਹਾਡੇ ਵਿੱਚ ਬਵਾਂ ਘੱਲਾਂਗਾ ਅਤੇ ਤੁਸੀਂ ਆਪਣੇ ਵੈਰੀਆਂ ਦੇ ਹੱਥ ਵਿੱਚ ਸੌਂਪੇ ਜਾਓਗੇ। ");
INSERT INTO pan_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","ਜਿਸ ਵੇਲੇ ਮੈਂ ਤੁਹਾਡੀ ਰੋਟੀ ਦਾ ਜ਼ਰੀਆ ਢਾਹ ਸੁੱਟਾਂਗਾ ਤਾਂ ਦਸ ਇਸਤਰੀਆਂ ਤੁਹਾਡੀਆਂ ਰੋਟੀਆਂ ਇੱਕੋ ਤੰਦੂਰ ਵਿੱਚ ਪਕਾਉਣਗੀਆਂ ਅਤੇ ਤੁਹਾਨੂੰ ਤੁਹਾਡੀ ਆਪਣੀ ਰੋਟੀ ਤੋਲ ਕੇ ਦੇਣਗੀਆਂ, ਤਦ ਤੁਸੀਂ ਖਾਓਗੇ ਪਰ ਰੱਜੋਗੇ ਨਹੀਂ। ");
INSERT INTO pan_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","ਪਰ ਜੇਕਰ ਤੁਸੀਂ ਇਸ ਸਭ ਦੇ ਬਾਅਦ ਵੀ ਮੇਰੇ ਵੱਲ ਧਿਆਨ ਨਾ ਕਰੋ ਪਰ ਮੇਰੇ ਵਿਰੁੱਧ ਹੀ ਚੱਲੋ, ");
INSERT INTO pan_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","ਤਦ ਮੈਂ ਵੀ ਡਾਢੇ ਕ੍ਰੋਧ ਨਾਲ ਤੁਹਾਡੇ ਵਿਰੁੱਧ ਚੱਲਾਂਗਾ ਅਤੇ ਮੈਂ, ਹਾਂ, ਮੈਂ ਤੁਹਾਡੇ ਪਾਪਾਂ ਦੇ ਕਾਰਨ ਤੁਹਾਨੂੰ ਸੱਤ ਗੁਣਾ ਹੋਰ ਸਜ਼ਾ ਦਿਆਂਗਾ। ");
INSERT INTO pan_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","ਤੁਸੀਂ ਆਪਣੇ ਪੁੱਤਰਾਂ ਦਾ ਅਤੇ ਆਪਣੀਆਂ ਧੀਆਂ ਦਾ ਮਾਸ ਖਾਓਗੇ। ");
INSERT INTO pan_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","ਮੈਂ ਤੁਹਾਡੀਆਂ ਉੱਚੀਆਂ ਥਾਵਾਂ ਨੂੰ ਢਾਹ ਦਿਆਂਗਾ ਅਤੇ ਤੁਹਾਡੇ ਸੂਰਜ ਦੇ ਥੰਮ੍ਹਾਂ ਨੂੰ ਵੱਢਾਂਗਾ ਅਤੇ ਤੁਹਾਡੀਆਂ ਲਾਸ਼ਾਂ ਨੂੰ ਤੁਹਾਡੀਆਂ ਟੁੱਟੀਆਂ ਹੋਈਆਂ ਮੂਰਤਾਂ ਦੇ ਉੱਤੇ ਸੁੱਟਾਂਗਾ ਅਤੇ ਮੇਰਾ ਜੀਅ ਤੁਹਾਡੇ ਤੋਂ ਘਿਣ ਕਰੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","ਮੈਂ ਤੁਹਾਡੇ ਸ਼ਹਿਰਾਂ ਨੂੰ ਉਜਾੜ ਦਿਆਂਗਾ ਅਤੇ ਤੁਹਾਡੇ ਪਵਿੱਤਰ ਸਥਾਨਾਂ ਦਾ ਨਾਸ ਕਰਾਂਗਾ ਅਤੇ ਮੈਂ ਤੁਹਾਡੀਆਂ ਭੇਟਾਂ ਦੀ ਸੁਗੰਧਤਾ ਨੂੰ ਸਵੀਕਾਰ ਨਾ ਕਰਾਂਗਾ। ");
INSERT INTO pan_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","ਮੈਂ ਉਸ ਦੇਸ਼ ਦਾ ਨਾਸ ਕਰਵਾ ਦਿਆਂਗਾ ਅਤੇ ਤੁਹਾਡੇ ਵੈਰੀ ਜੋ ਉਸ ਦੇ ਵਿੱਚ ਰਹਿੰਦੇ ਹਨ, ਉਹ ਇਹ ਵੇਖ ਕੇ ਹੱਕੇ-ਬੱਕੇ ਰਹਿ ਜਾਣਗੇ। ");
INSERT INTO pan_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","ਮੈਂ ਤੁਹਾਨੂੰ ਕੌਮਾਂ ਵਿੱਚ ਖਿਲਾਰ ਦਿਆਂਗਾ ਅਤੇ ਮੈਂ ਤੁਹਾਡੇ ਪਿੱਛੇ-ਪਿੱਛੇ ਤਲਵਾਰ ਚਲਾਵਾਂਗਾ ਅਤੇ ਤੁਹਾਡਾ ਦੇਸ਼ ਵਿਰਾਨ ਹੋ ਜਾਵੇਗਾ ਅਤੇ ਤੁਹਾਡੇ ਸ਼ਹਿਰ ਉੱਜੜ ਜਾਣਗੇ। ");
INSERT INTO pan_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","ਫੇਰ ਜਦ ਤੱਕ ਉਹ ਦੇਸ਼ ਉਜਾੜ ਰਹੇਗਾ ਅਤੇ ਤੁਸੀਂ ਆਪਣੇ ਵੈਰੀਆਂ ਦੇ ਦੇਸ਼ ਵਿੱਚ ਰਹੋਗੇ, ਤਦ ਤੱਕ ਉਹ ਆਪਣੇ ਸਬਤ ਦਾ ਅਨੰਦ ਮਾਣੇਗਾ, ਹਾਂ, ਉਸ ਵੇਲੇ ਦੇਸ਼ ਵਿਸ਼ਰਾਮ ਕਰੇਗਾ ਅਤੇ ਆਪਣੇ ਸਬਤਾਂ ਦਾ ਅਨੰਦ ਮਾਣੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","ਜਦ ਤੱਕ ਉਹ ਵਿਰਾਨ ਰਹੇ, ਤਦ ਤੱਕ ਉਹ ਵਿਸ਼ਰਾਮ ਕਰੇਗਾ, ਕਿਉਂਕਿ ਜਦ ਤੁਸੀਂ ਉਸ ਦੇਸ਼ ਵਿੱਚ ਵੱਸਦੇ ਸੀ, ਤਦ ਤੁਹਾਡੇ ਸਬਤਾਂ ਵਿੱਚ ਉਸ ਨੂੰ ਵਿਸ਼ਰਾਮ ਨਹੀਂ ਮਿਲਿਆ। ");
INSERT INTO pan_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","ਤੁਹਾਡੇ ਵਿੱਚੋਂ ਜੋ ਜੀਉਂਦੇ ਅਤੇ ਆਪਣੇ ਵੈਰੀਆਂ ਦੇ ਦੇਸ਼ ਵਿੱਚ ਹੋਣ, ਮੈਂ ਉੱਥੇ ਉਨ੍ਹਾਂ ਦੇ ਮਨਾਂ ਨੂੰ ਢਿੱਲੇ ਕਰਾਂਗਾ ਅਤੇ ਉਹ ਪੱਤਿਆਂ ਦੀ ਖੜਕਾਰ ਸੁਣਦਿਆਂ ਹੀ ਭੱਜ ਜਾਣਗੇ। ਉਹ ਇਸ ਤਰ੍ਹਾਂ ਭੱਜਣਗੇ, ਜਿਵੇਂ ਕੋਈ ਤਲਵਾਰ ਤੋਂ ਭੱਜਦਾ ਹੈ ਅਤੇ ਭਾਵੇਂ ਕੋਈ ਪਿੱਛਾ ਨਾ ਕਰੇ ਤਾਂ ਵੀ ਉਹ ਡਿੱਗ ਪੈਣਗੇ। ");
INSERT INTO pan_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","ਭਾਵੇਂ ਕੋਈ ਪਿੱਛਾ ਨਾ ਕਰੇ, ਤਾਂ ਵੀ ਉਹ ਤਲਵਾਰ ਦੇ ਭੈਅ ਤੋਂ ਇੱਕ ਦੂਜੇ ਉੱਤੇ ਡਿੱਗਣਗੇ ਅਤੇ ਆਪਣੇ ਵੈਰੀਆਂ ਦੇ ਅੱਗੇ ਖੜ੍ਹੇ ਹੋਣ ਲਈ ਤੁਹਾਡੇ ਵਿੱਚ ਕੁਝ ਜ਼ੋਰ ਨਾ ਰਹੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","ਤੁਸੀਂ ਵੱਖ-ਵੱਖ ਕੌਮਾਂ ਦੇ ਵਿੱਚ ਮਰ ਜਾਓਗੇ ਅਤੇ ਤੁਹਾਡੇ ਵੈਰੀਆਂ ਦਾ ਦੇਸ਼ ਤੁਹਾਨੂੰ ਨਿਗਲ ਜਾਵੇਗਾ, ");
INSERT INTO pan_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","ਅਤੇ ਤੁਹਾਡੇ ਵਿੱਚੋਂ ਜੋ ਬਚ ਜਾਣਗੇ ਉਹ ਤੁਹਾਡੇ ਵੈਰੀਆਂ ਦੇ ਦੇਸਾਂ ਵਿੱਚ ਆਪਣੀਆਂ ਬਦੀਆਂ ਦੇ ਕਾਰਨ ਕਮਜ਼ੋਰ ਹੋ ਜਾਣਗੇ, ਅਤੇ ਆਪਣੇ ਪੁਰਖਿਆਂ ਦੀਆਂ ਬਦੀਆਂ ਦੇ ਕਾਰਨ ਉਨ੍ਹਾਂ ਦੀ ਤਰ੍ਹਾਂ ਹੀ ਕਮਜ਼ੋਰ ਹੋ ਜਾਣਗੇ। ");
INSERT INTO pan_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","ਪਰ ਜੇਕਰ ਉਹ ਆਪਣੀ ਅਤੇ ਪੁਰਖਿਆਂ ਦੀਆਂ ਬਦੀਆਂ ਨੂੰ ਮੰਨ ਲੈਣ ਅਤੇ ਉਸ ਬੇਈਮਾਨੀ ਨੂੰ ਜੋ ਉਨ੍ਹਾਂ ਨੇ ਮੇਰੇ ਨਾਲ ਕੀਤੀ ਅਤੇ ਇਹ ਵੀ ਮੰਨ ਲੈਣ ਕਿ ਉਹ ਮੇਰੇ ਵਿਰੁੱਧ ਚੱਲੇ ");
INSERT INTO pan_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","ਅਤੇ ਇਸ ਕਾਰਨ ਹੀ ਮੈਂ ਵੀ ਉਨ੍ਹਾਂ ਦੇ ਵਿਰੁੱਧ ਚੱਲਿਆ ਅਤੇ ਉਨ੍ਹਾਂ ਨੂੰ ਉਨ੍ਹਾਂ ਦੇ ਵੈਰੀਆਂ ਦੇ ਦੇਸ਼ ਵਿੱਚ ਲਿਆਇਆ, ਤਾਂ ਜੇਕਰ ਉਸ ਵੇਲੇ ਉਨ੍ਹਾਂ ਦੇ ਅਸੁੰਨਤੀ ਦਿਲ ਨੀਵੇਂ ਹੋ ਜਾਣ ਅਤੇ ਉਹ ਉਸ ਵੇਲੇ ਆਪਣੀ ਬਦੀ ਦੇ ਸਜ਼ਾ ਨੂੰ ਮੰਨ ਲੈਣ, ");
INSERT INTO pan_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","ਤਦ ਜਿਹੜਾ ਨੇਮ ਮੈਂ ਯਾਕੂਬ ਦੇ ਨਾਲ ਅਤੇ ਜਿਹੜਾ ਨੇਮ ਮੈਂ ਇਸਹਾਕ ਦੇ ਨਾਲ ਅਤੇ ਅਬਰਾਹਾਮ ਦੇ ਨਾਲ ਬੰਨ੍ਹਿਆ ਸੀ, ਉਸ ਨੂੰ ਯਾਦ ਕਰਾਂਗਾ ਅਤੇ ਉਸ ਦੇਸ਼ ਨੂੰ ਵੀ ਮੈਂ ਯਾਦ ਕਰਾਂਗਾ। ");
INSERT INTO pan_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","ਉਹ ਦੇਸ਼ ਵੀ ਉਨ੍ਹਾਂ ਕੋਲੋਂ ਛੱਡਿਆ ਜਾ ਕੇ ਵਿਰਾਨ ਰਹੇਗਾ ਅਤੇ ਉਨ੍ਹਾਂ ਤੋਂ ਵਿਰਾਨ ਹੋ ਕੇ ਵੀ ਆਪਣੇ ਸਬਤਾਂ ਦਾ ਅਨੰਦ ਮਾਣੇਗਾ, ਅਤੇ ਉਹ ਆਪਣੀਆਂ ਬਦੀਆਂ ਦੀ ਸਜ਼ਾ ਮੰਨ ਲੈਣਗੇ, ਕਿਉਂ ਜੋ ਉਨ੍ਹਾਂ ਨੇ ਮੇਰੇ ਨਿਯਮਾਂ ਨੂੰ ਤਿਆਗ ਦਿੱਤਾ ਅਤੇ ਮੇਰੀਆਂ ਬਿਧੀਆਂ ਉਨ੍ਹਾਂ ਦੇ ਜੀਆਂ ਨੂੰ ਮਾੜੀਆਂ ਲੱਗੀਆਂ। ");
INSERT INTO pan_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","ਇਸ ਸਭ ਤੋਂ ਬਾਅਦ ਵੀ ਜਦ ਉਹ ਆਪਣੇ ਵੈਰੀਆਂ ਦੇ ਦੇਸ਼ ਵਿੱਚ ਹੋਣ, ਤਾਂ ਵੀ ਮੈਂ ਉਨ੍ਹਾਂ ਨੂੰ ਨਾ ਤਿਆਗਾਂਗਾ ਅਤੇ ਨਾ ਉਨ੍ਹਾਂ ਤੋਂ ਅਜਿਹੀ ਨਫ਼ਰਤ ਕਰਾਂਗਾ ਕਿ ਉਨ੍ਹਾਂ ਦਾ ਪੂਰੀ ਤਰ੍ਹਾਂ ਨਾਸ ਕਰ ਦਿਆਂ ਅਤੇ ਆਪਣੇ ਉਸ ਨੇਮ ਨੂੰ ਤੋੜ ਦਿਆਂ ਜੋ ਮੈਂ ਉਨ੍ਹਾਂ ਨਾਲ ਬੰਨ੍ਹਿਆ ਸੀ, ਕਿਉਂ ਜੋ ਮੈਂ ਯਹੋਵਾਹ ਉਨ੍ਹਾਂ ਦਾ ਪਰਮੇਸ਼ੁਰ ਹਾਂ। ");
INSERT INTO pan_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","ਪਰ ਮੈਂ ਉਨ੍ਹਾਂ ਦੀ ਖਾਤਰ ਉਨ੍ਹਾਂ ਦੇ ਪੁਰਖਿਆਂ ਨਾਲ ਬੰਨ੍ਹੇ ਹੋਏ ਨੇਮ ਨੂੰ ਯਾਦ ਕਰਾਂਗਾ, ਜਿਨ੍ਹਾਂ ਨੂੰ ਮੈਂ ਕੌਮਾਂ ਦੇ ਵੇਖਦਿਆਂ ਮਿਸਰ ਦੇਸ਼ ਵਿੱਚੋਂ ਕੱਢ ਲਿਆਇਆ, ਤਾਂ ਜੋ ਉਨ੍ਹਾਂ ਦਾ ਪਰਮੇਸ਼ੁਰ ਹੋਵਾਂ। ਮੈਂ ਯਹੋਵਾਹ ਹਾਂ। ");
INSERT INTO pan_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","ਜੋ ਬਿਧੀਆਂ, ਨਿਯਮ ਅਤੇ ਬਿਵਸਥਾ ਯਹੋਵਾਹ ਨੇ ਆਪਣੇ ਅਤੇ ਇਸਰਾਏਲੀਆਂ ਦੇ ਵਿਚਕਾਰ ਸੀਨਈ ਪਰਬਤ ਉੱਤੇ ਮੂਸਾ ਦੇ ਦੁਆਰਾ ਠਹਿਰਾਈਆਂ ਸਨ, ਉਹ ਇਹ ਹੀ ਹਨ। ");
INSERT INTO pan_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","ਫੇਰ ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਇਹ ਆਖਿਆ, ");
INSERT INTO pan_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","ਇਸਰਾਏਲੀਆਂ ਨਾਲ ਗੱਲ ਕਰਕੇ ਉਨ੍ਹਾਂ ਨੂੰ ਆਖ ਕਿ ਜੇ ਕੋਈ ਸੁੱਖਣਾ ਸੁੱਖ ਕੇ ਕਿਸੇ ਮਨੁੱਖ ਨੂੰ ਯਹੋਵਾਹ ਦੇ ਲਈ ਅਰਪਣ ਕਰੇ ਤਾਂ ਤੇਰੇ ਠਹਿਰਾਏ ਹੋਏ ਮੁੱਲ ਦੇ ਅਨੁਸਾਰ ਉਹ ਯਹੋਵਾਹ ਦੇ ਹੋਣਗੇ, ");
INSERT INTO pan_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","ਜੇਕਰ ਉਹ ਪੁਰਖ ਵੀਹ ਸਾਲਾਂ ਤੋਂ ਸੱਠ ਸਾਲਾਂ ਦਾ ਹੋਵੇ ਤਾਂ ਉਸ ਦੇ ਲਈ ਤੇਰਾ ਮੁੱਲ ਪਵਿੱਤਰ ਸਥਾਨ ਦੇ ਸ਼ਕੇਲ ਅਨੁਸਾਰ ਪੰਜਾਹ ਸ਼ਕੇਲ ਚਾਂਦੀ ਦੇ ਸਿੱਕੇ ਹੋਵੇਗਾ, ");
INSERT INTO pan_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","ਅਤੇ ਜੇਕਰ ਇਸਤਰੀ ਹੋਵੇ ਤਾਂ ਤੇਰਾ ਮੁੱਲ ਤੀਹ ਸ਼ਕੇਲ ਹੋਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","ਜੇਕਰ ਉਸ ਦੀ ਉਮਰ ਪੰਜ ਸਾਲਾਂ ਤੋਂ ਲੈ ਕੇ ਵੀਹਾਂ ਸਾਲਾਂ ਤੱਕ ਹੋਵੇ ਤਾਂ ਤੇਰਾ ਮੁੱਲ ਮੁੰਡੇ ਦੇ ਲਈ ਵੀਹ ਸ਼ਕੇਲ ਅਤੇ ਕੁੜੀ ਲਈ ਦਸ ਸ਼ਕੇਲ ਹੋਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","ਜੇਕਰ ਉਸ ਦੀ ਉਮਰ ਇੱਕ ਮਹੀਨੇ ਤੋਂ ਲੈ ਕੇ ਪੰਜ ਸਾਲ ਤੱਕ ਹੋਵੇ ਤਾਂ ਤੇਰਾ ਮੁੱਲ ਮੁੰਡੇ ਦੇ ਲਈ ਪੰਜ ਸ਼ਕੇਲ ਚਾਂਦੀ ਅਤੇ ਕੁੜੀ ਦੇ ਲਈ ਤਿੰਨ ਸ਼ਕੇਲ ਚਾਂਦੀ ਹੋਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","ਅਤੇ ਜੇਕਰ ਉਸ ਦੀ ਉਮਰ ਸੱਠ ਸਾਲ ਜਾਂ ਉਸ ਤੋਂ ਉੱਪਰ ਹੋਵੇ, ਤਾਂ ਜੇਕਰ ਉਹ ਪੁਰਖ ਹੋਵੇ ਤਾਂ ਉਸ ਦੇ ਲਈ ਤੇਰਾ ਮੁੱਲ ਪੰਦਰਾਂ ਸ਼ਕੇਲ ਅਤੇ ਇਸਤਰੀ ਹੋਵੇ ਤਾਂ ਦਸ ਸ਼ਕੇਲ ਹੋਵੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","ਪਰ ਜੇਕਰ ਉਹ ਇੰਨ੍ਹਾਂ ਗਰੀਬ ਹੋਵੇ ਕਿ ਜਾਜਕ ਦਾ ਠਹਿਰਾਇਆ ਹੋਇਆ ਮੁੱਲ ਨਾ ਦੇ ਸਕੇ ਤਾਂ ਉਹ ਜਾਜਕ ਦੇ ਅੱਗੇ ਆਵੇ ਅਤੇ ਜਾਜਕ ਉਸ ਦਾ ਮੁੱਲ ਠਹਿਰਾਵੇ ਅਰਥਾਤ ਸੁੱਖਣਾ ਸੁੱਖਣ ਵਾਲੇ ਦੀ ਸਮਰੱਥਾ ਦੇ ਅਨੁਸਾਰ ਉਸ ਦਾ ਮੁੱਲ ਠਹਿਰਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","ਜੇਕਰ ਉਹ ਉਨ੍ਹਾਂ ਪਸ਼ੂਆਂ ਵਿੱਚੋਂ ਹੋਵੇ, ਜਿਨ੍ਹਾਂ ਨੂੰ ਲੋਕ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਚੜ੍ਹਾਉਂਦੇ ਹਨ, ਤਾਂ ਉਹ ਸਭ ਕੁਝ ਜੋ ਉਨ੍ਹਾਂ ਪਸ਼ੂਆਂ ਵਿੱਚੋਂ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਚੜ੍ਹਾਇਆ ਜਾਂਦਾ ਹੈ, ਪਵਿੱਤਰ ਹੋਵੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","ਉਹ ਉਸ ਪਸ਼ੂ ਨੂੰ ਨਾ ਬਦਲੇ, ਨਾ ਵਟਾਵੇ, ਨਾ ਤਾਂ ਚੰਗੇ ਦੇ ਬਦਲੇ ਮਾੜਾ ਅਤੇ ਨਾ ਮਾੜੇ ਦੇ ਬਦਲੇ ਚੰਗਾ ਦੇਵੇ ਪਰ ਜੇਕਰ ਉਹ ਕਿਸੇ ਪਸ਼ੂ ਦੇ ਬਦਲੇ ਕੋਈ ਹੋਰ ਪਸ਼ੂ ਦੇਵੇ ਤਾਂ ਉਹ ਅਤੇ ਉਸ ਦਾ ਵਟਾਂਦਰਾ ਦੋਵੇਂ ਪਵਿੱਤਰ ਠਹਿਰਨਗੇ। ");
INSERT INTO pan_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","ਅਤੇ ਜੇਕਰ ਉਹ ਅਸ਼ੁੱਧ ਪਸ਼ੂ ਹੋਵੇ, ਜਿਨ੍ਹਾਂ ਨੂੰ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਨਹੀਂ ਚੜ੍ਹਾਉਂਦੇ ਤਾਂ ਅਜਿਹੇ ਪਸ਼ੂਆਂ ਨੂੰ ਉਹ ਜਾਜਕ ਦੇ ਅੱਗੇ ਲਿਆਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","ਤਦ ਜਾਜਕ ਉਸ ਨੂੰ ਚੰਗਾ ਜਾਂ ਮਾੜਾ ਜਾਂਚ ਕੇ ਉਸ ਦਾ ਮੁੱਲ ਠਹਿਰਾਵੇ ਅਤੇ ਜਿਨ੍ਹਾਂ ਜਾਜਕ ਠਹਿਰਾਵੇ, ਉਸ ਦਾ ਮੁੱਲ ਉਨ੍ਹਾਂ ਹੀ ਹੋਵੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","ਪਰ ਜੇਕਰ ਅਰਪਣ ਕਰਨ ਵਾਲਾ ਉਸ ਨੂੰ ਛੁਡਾਉਣਾ ਚਾਹੇ ਤਾਂ ਉਹ ਜਾਜਕ ਦੇ ਠਹਿਰਾਏ ਹੋਏ ਮੁੱਲ ਵਿੱਚ ਪੰਜਵਾਂ ਹਿੱਸਾ ਹੋਰ ਪਾ ਕੇ ਦੇਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","ਜਦ ਕੋਈ ਮਨੁੱਖ ਆਪਣਾ ਘਰ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਪਵਿੱਤਰ ਬਣਾਉਣ ਲਈ ਅਰਪਣ ਕਰੇ ਤਾਂ ਜਾਜਕ ਉਸ ਨੂੰ ਚੰਗਾ ਜਾਂ ਮਾੜਾ ਜਾਂਚ ਕੇ ਉਸ ਦਾ ਮੁੱਲ ਠਹਿਰਾਵੇ ਅਤੇ ਜਿਨ੍ਹਾਂ ਮੁੱਲ ਜਾਜਕ ਠਹਿਰਾਵੇ, ਉਸ ਦਾ ਮੁੱਲ ਉਨ੍ਹਾਂ ਹੀ ਹੋਵੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","ਪਰ ਜੇਕਰ ਉਸ ਘਰ ਨੂੰ ਅਰਪਣ ਕਰਨ ਵਾਲਾ ਉਸ ਨੂੰ ਛੁਡਾਉਣਾ ਚਾਹੇ, ਤਾਂ ਉਹ ਜਾਜਕ ਦੇ ਠਹਿਰਾਏ ਹੋਏ ਮੁੱਲ ਵਿੱਚ ਪੰਜਵਾਂ ਹਿੱਸਾ ਹੋਰ ਪਾ ਕੇ ਦੇਵੇ ਅਤੇ ਉਹ ਘਰ ਉਸੇ ਦਾ ਹੋਵੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","ਜੇਕਰ ਕੋਈ ਮਨੁੱਖ ਆਪਣੀ ਨਿੱਜ-ਭੂਮੀ ਦਾ ਕੁਝ ਹਿੱਸਾ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਅਰਪਣ ਕਰੇ ਤਾਂ ਤੇਰਾ ਮੁੱਲ ਉਸ ਵਿੱਚ ਬੀਜੇ ਜਾਣ ਵਾਲੇ ਬੀਜ ਦੇ ਅਨੁਸਾਰ ਹੋਵੇ, ਇੱਕ ਟੋਪੇ ਜੌਂਵਾਂ ਦੇ ਬੀ ਦਾ ਮੁੱਲ ਪੰਜਾਹ ਸ਼ਕੇਲ ਚਾਂਦੀ ਹੋਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","ਜੇਕਰ ਉਹ ਆਪਣਾ ਖੇਤ ਅਨੰਦ ਦੇ ਸਾਲ ਵਿੱਚ ਅਰਪਣ ਕਰੇ ਦਾ ਉਸ ਦਾ ਮੁੱਲ ਤੇਰੇ ਠਹਿਰਾਉਣ ਦੇ ਅਨੁਸਾਰ ਹੋਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","ਪਰ ਜੇਕਰ ਉਹ ਆਪਣਾ ਖੇਤ ਅਨੰਦ ਦੇ ਸਾਲ ਤੋਂ ਬਾਅਦ ਅਰਪਣ ਕਰੇ ਤਾਂ ਜਾਜਕ ਰਹਿੰਦਿਆਂ ਸਾਲਾਂ ਦੇ ਲੇਖੇ ਦੇ ਅਨੁਸਾਰ ਅਰਥਾਤ ਅਨੰਦ ਦੇ ਸਾਲ ਤੱਕ ਪੈਸੇ ਦਾ ਲੇਖਾ ਕਰੇ ਅਤੇ ਉਹ ਤੇਰੇ ਮੁੱਲ ਤੋਂ ਘੱਟ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","ਪਰ ਜੇਕਰ ਉਸ ਖੇਤ ਨੂੰ ਅਰਪਣ ਵਾਲਾ ਉਸ ਨੂੰ ਛੁਡਾਉਣਾ ਚਾਹੇ ਤਾਂ ਉਹ ਜਾਜਕ ਦੇ ਠਹਿਰਾਏ ਹੋਏ ਮੁੱਲ ਵਿੱਚ ਪੰਜਵਾਂ ਹਿੱਸਾ ਹੋਰ ਪਾ ਕੇ ਦੇਵੇ ਤਦ ਉਹ ਖੇਤ ਉਸੇ ਦਾ ਠਹਿਰੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","ਪਰ ਜੇਕਰ ਉਹ ਉਸ ਖੇਤ ਨੂੰ ਛੁਡਾਉਣਾ ਨਾ ਚਾਹੇ ਜਾਂ ਉਸ ਨੇ ਉਹ ਖੇਤ ਕਿਸੇ ਹੋਰ ਮਨੁੱਖ ਨੂੰ ਵੇਚ ਦਿੱਤਾ ਹੋਵੇ ਤਾਂ ਉਹ ਖੇਤ ਫੇਰ ਕਦੇ ਨਾ ਛੁਡਾਇਆ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","ਪਰ ਜਦ ਉਹ ਖੇਤ ਅਨੰਦ ਦੇ ਸਾਲ ਵਿੱਚ ਛੁੱਟ ਜਾਵੇ ਤਾਂ ਉਹ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਸੁੱਖੇ ਹੋਏ ਖੇਤ ਦੀ ਤਰ੍ਹਾਂ ਪਵਿੱਤਰ ਹੋਵੇਗਾ। ਉਸ ਉੱਤੇ ਜਾਜਕ ਦਾ ਹੀ ਅਧਿਕਾਰ ਹੋਵੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","ਫੇਰ ਜੇਕਰ ਕੋਈ ਮਨੁੱਖ ਇੱਕ ਮੁੱਲ ਲਏ ਹੋਏ ਖੇਤ ਨੂੰ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਅਰਪਣ ਕਰੇ, ਜੋ ਉਸ ਦੀ ਆਪਣੀ ਨਿੱਜ-ਭੂਮੀ ਦੇ ਖੇਤਾਂ ਵਿੱਚੋਂ ਨਾ ਹੋਵੇ, ");
INSERT INTO pan_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","ਤਦ ਜਾਜਕ ਅਨੰਦ ਦੇ ਸਾਲ ਤੱਕ ਦਾ ਲੇਖਾ ਕਰਕੇ ਉਸ ਮਨੁੱਖ ਦੇ ਲਈ ਜੋ ਮੁੱਲ ਠਹਿਰਾਵੇ, ਉਹ ਉਸ ਮੁੱਲ ਨੂੰ ਪਵਿੱਤਰ ਜਾਣ ਕੇ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਉਸੇ ਦਿਨ ਹੀ ਦੇ ਦੇਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","ਅਨੰਦ ਦੇ ਸਾਲ ਵਿੱਚ ਉਹ ਖੇਤ ਉਸੇ ਦੇ ਅਧਿਕਾਰ ਵਿੱਚ ਆ ਜਾਵੇਗਾ, ਜਿਸ ਤੋਂ ਉਹ ਮੁੱਲ ਲਿਆ ਗਿਆ ਸੀ ਅਰਥਾਤ ਉਹ ਜਿਸ ਦੀ ਨਿੱਜ-ਭੂਮੀ ਸੀ, ਉਸ ਉੱਤੇ ਉਸੇ ਦਾ ਅਧਿਕਾਰ ਹੋਵੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","ਜਾਜਕ ਦੁਆਰਾ ਤੇਰੇ ਲਈ ਠਹਿਰਾਏ ਹੋਏ ਸਾਰੇ ਮੁੱਲ ਪਵਿੱਤਰ ਸਥਾਨ ਦੇ ਸ਼ਕੇਲ ਦੇ ਅਨੁਸਾਰ ਹੋਣ - ਸ਼ਕੇਲ ਵੀਹ ਗਿਰਾ ਦਾ ਹੋਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","ਤੇਰੇ ਸਾਰੇ ਪਸ਼ੂਆਂ ਦੇ ਪਹਿਲੌਠੇ ਯਹੋਵਾਹ ਦੇ ਹਨ, ਕੋਈ ਮਨੁੱਖ ਉਨ੍ਹਾਂ ਨੂੰ ਅਰਪਣ ਨਾ ਕਰੇ, ਭਾਵੇਂ ਬਲ਼ਦ ਹੋਵੇ, ਭਾਵੇਂ ਭੇਡ ਜਾਂ ਬੱਕਰੀ ਦਾ ਬੱਚਾ, ਉਹ ਯਹੋਵਾਹ ਦਾ ਹੀ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","ਪਰ ਜੇ ਉਹ ਕਿਸੇ ਅਸ਼ੁੱਧ ਪਸ਼ੂ ਦਾ ਪਹਿਲੌਠਾ ਹੋਵੇ ਤਾਂ ਉਸ ਨੂੰ ਅਰਪਣ ਕਰਨ ਵਾਲਾ ਉਸ ਨੂੰ ਜਾਜਕ ਦੇ ਠਹਿਰਾਏ ਹੋਏ ਮੁੱਲ ਦੇ ਅਨੁਸਾਰ ਉਸ ਵਿੱਚ ਪੰਜਵਾਂ ਹਿੱਸਾ ਹੋਰ ਪਾ ਕੇ ਉਸ ਨੂੰ ਛੁਡਾ ਸਕਦਾ ਹੈ, ਪਰ ਜੇਕਰ ਉਹ ਛੁਡਾਇਆ ਨਾ ਜਾਵੇ ਤਾਂ ਜਾਜਕ ਦੇ ਠਹਿਰਾਏ ਹੋਏ ਮੁੱਲ ਦੇ ਅਨੁਸਾਰ ਵੇਚਿਆ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","ਪਰ ਆਪਣੀਆਂ ਸਾਰੀਆਂ ਵਸਤੂਆਂ ਵਿੱਚੋਂ ਜੋ ਕੁਝ ਕੋਈ ਮਨੁੱਖ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਸੁੱਖੇ, ਭਾਵੇਂ ਮਨੁੱਖ ਹੋਵੇ, ਭਾਵੇਂ ਪਸ਼ੂ, ਭਾਵੇਂ ਉਸ ਦੀ ਆਪਣੀ ਨਿੱਜ-ਭੂਮੀ ਦਾ ਖੇਤ ਹੋਵੇ, ਅਜਿਹੀ ਅਰਪਣ ਕੀਤੀ ਹੋਈ ਕੋਈ ਵੀ ਵਸਤੂ ਨਾ ਤਾਂ ਵੇਚੀ ਜਾਵੇ ਅਤੇ ਨਾ ਛੁਡਾਈ ਜਾਵੇ। ਸਾਰੀਆਂ ਸੁੱਖੀਆਂ ਹੋਈਆਂ ਵਸਤੂਆਂ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਅੱਤ ਪਵਿੱਤਰ ਹਨ। ");
INSERT INTO pan_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","ਮਨੁੱਖਾਂ ਵਿੱਚੋਂ ਕੋਈ ਵੀ ਜੋ ਵੱਢੇ ਜਾਣ ਲਈ ਸੁੱਖੇ ਜਾਣ, ਉਹ ਕਦੀ ਛੁਡਾਏ ਨਾ ਜਾਣ, ਪਰ ਜ਼ਰੂਰ ਹੀ ਮਾਰ ਦਿੱਤੇ ਜਾਣ। ");
INSERT INTO pan_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","ਧਰਤੀ ਦੀ ਉਪਜ ਦਾ ਸਾਰਾ ਦਸਵੰਧ, ਭਾਵੇਂ ਧਰਤੀ ਦੇ ਬੀਜਾਂ ਦਾ, ਭਾਵੇਂ ਰੁੱਖਾਂ ਦੇ ਫ਼ਲਾਂ ਦਾ ਹੋਵੇ, ਉਹ ਯਹੋਵਾਹ ਦਾ ਹੈ, ਇਹ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਪਵਿੱਤਰ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","ਜੇਕਰ ਕੋਈ ਮਨੁੱਖ ਆਪਣੇ ਦਸਵੰਧਾਂ ਵਿੱਚੋਂ ਕੁਝ ਛੁਡਾ ਲਵੇ ਤਾਂ ਉਸ ਦੇ ਨਾਲ ਉਸ ਦਾ ਪੰਜਵਾਂ ਹਿੱਸਾ ਹੋਰ ਪਾ ਕੇ ਦੇ ਦੇਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","ਸਾਰੇ ਵੱਗ ਅਤੇ ਇੱਜੜ ਦੇ ਦਸਵੰਧ ਅਰਥਾਤ ਉਹ ਸਾਰੇ ਪਸ਼ੂ ਜੋ ਸੋਟੇ ਹੇਠੋਂ ਲੰਘਾਏ ਜਾਣ, ਉਨ੍ਹਾਂ ਦਾ ਦਸਵੰਧ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਪਵਿੱਤਰ ਹੋਵੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","ਉਹ ਉਸ ਨੂੰ ਨਾ ਛਾਂਟੇ, ਕਿ ਉਹ ਚੰਗਾ ਹੈ ਜਾਂ ਮਾੜਾ ਅਤੇ ਨਾ ਉਸ ਨੂੰ ਵਟਾਵੇ ਅਤੇ ਜੇਕਰ ਕੋਈ ਉਸ ਨੂੰ ਵਟਾਵੇ ਤਾਂ ਉਹ ਅਤੇ ਉਸ ਦਾ ਵਟਾਂਦਰਾ ਦੋਵੇਂ ਪਵਿੱਤਰ ਹੋਣਗੇ, ਉਹ ਛੁਡਾਇਆ ਨਾ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","ਜਿਹੜੇ ਹੁਕਮ ਯਹੋਵਾਹ ਨੇ ਇਸਰਾਏਲੀਆਂ ਦੇ ਲਈ ਸੀਨਈ ਪਰਬਤ ਉੱਤੇ ਮੂਸਾ ਨੂੰ ਦਿੱਤੇ, ਉਹ ਇਹ ਹੀ ਹਨ।");
INSERT INTO pan_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","ਇਸਰਾਏਲੀਆਂ ਦੇ ਮਿਸਰ ਦੇਸ ਤੋਂ ਨਿੱਕਲਣ ਦੇ ਬਾਅਦ, ਦੂਜੇ ਸਾਲ ਦੇ ਦੂਜੇ ਮਹੀਨੇ ਦੇ ਪਹਿਲੇ ਦਿਨ ਸੀਨਈ ਦੀ ਉਜਾੜ ਵਿੱਚ ਮਿਲਾਪ ਵਾਲੇ ਤੰਬੂ ਵਿੱਚ ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਕਿਹਾ ");
INSERT INTO pan_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","ਕਿ ਇਸਰਾਏਲੀਆਂ ਦੀ ਸਾਰੀ ਮੰਡਲੀ ਦੀ ਗਿਣਤੀ ਉਨ੍ਹਾਂ ਦੇ ਟੱਬਰਾਂ ਅਤੇ ਉਨ੍ਹਾਂ ਦੇ ਪੁਰਖਿਆਂ ਦੇ ਘਰਾਣਿਆਂ ਅਨੁਸਾਰ, ਇੱਕ-ਇੱਕ ਪੁਰਖ ਦੀ ਗਿਣਤੀ ਨਾਮ ਲੈ-ਲੈ ਕੇ ਕਰ। ");
INSERT INTO pan_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","ਜਿਹੜੇ ਵੀਹ ਸਾਲ ਜਾਂ ਇਸ ਤੋਂ ਵੱਧ ਉਮਰ ਦੇ ਹਨ ਅਤੇ ਇਸਰਾਏਲ ਲਈ ਯੁੱਧ ਕਰ ਸਕਦੇ ਹਨ, ਤੂੰ ਅਤੇ ਹਾਰੂਨ ਉਨ੍ਹਾਂ ਦੀ ਗਿਣਤੀ ਉਨ੍ਹਾਂ ਦੇ ਦਲਾਂ ਦੇ ਅਨੁਸਾਰ ਕਰੋ। ");
INSERT INTO pan_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","ਤੁਹਾਡੇ ਨਾਲ ਹਰੇਕ ਗੋਤ ਦਾ ਇੱਕ-ਇੱਕ ਮਨੁੱਖ ਹੋਵੇ ਜਿਹੜਾ ਆਪਣੇ ਪੁਰਖਿਆਂ ਦੇ ਪਰਿਵਾਰ ਵਿੱਚ ਮੁਖੀਆ ਹੋਵੇ। ");
INSERT INTO pan_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","ਉਨ੍ਹਾਂ ਮਨੁੱਖਾਂ ਦੇ ਨਾਮ ਜਿਹੜੇ ਤੁਹਾਡੇ ਨਾਲ ਖੜ੍ਹੇ ਹੋਣਗੇ ਇਹ ਹਨ, ਰਊਬੇਨ ਲਈ ਸ਼ਦੇਊਰ ਦਾ ਪੁੱਤਰ ਅਲੀਸੂਰ। ");
INSERT INTO pan_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","ਸ਼ਿਮਓਨ ਲਈ ਸੂਰੀਸ਼ਦਾਈ ਦਾ ਪੁੱਤਰ ਸ਼ਲੁਮੀਏਲ। ");
INSERT INTO pan_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","ਯਹੂਦਾਹ ਲਈ ਅੰਮੀਨਾਦਾਬ ਦਾ ਪੁੱਤਰ ਨਹਸ਼ੋਨ। ");
INSERT INTO pan_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","ਯਿੱਸਾਕਾਰ ਲਈ ਸੂਆਰ ਦਾ ਪੁੱਤਰ ਨਥਨਿਏਲ। ");
INSERT INTO pan_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","ਜ਼ਬੂਲੁਨ ਲਈ ਹੇਲੋਨ ਦਾ ਪੁੱਤਰ ਅਲੀਆਬ। ");
INSERT INTO pan_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","ਯੂਸੁਫ਼ ਦੇ ਪੁੱਤਰਾਂ ਵਿੱਚੋਂ ਇਫ਼ਰਾਈਮ ਲਈ ਅੰਮੀਹੂਦ ਦਾ ਪੁੱਤਰ ਅਲੀਸ਼ਾਮਾ। ਮਨੱਸ਼ਹ ਲਈ ਪਦਾਹਸੂਰ ਦਾ ਪੁੱਤਰ ਗਮਲੀਏਲ। ");
INSERT INTO pan_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","ਬਿਨਯਾਮੀਨ ਲਈ ਗਿਦਓਨੀ ਦਾ ਪੁੱਤਰ ਅਬੀਦਾਨ। ");
INSERT INTO pan_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","ਦਾਨ ਲਈ ਅੰਮੀਸ਼ੱਦਾਈ ਦਾ ਪੁੱਤਰ ਅਹੀਅਜ਼ਰ। ");
INSERT INTO pan_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","ਆਸ਼ੇਰ ਲਈ ਆਕਰਾਨ ਦਾ ਪੁੱਤਰ ਪਗੀਏਲ। ");
INSERT INTO pan_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","ਗਾਦ ਲਈ ਦਊਏਲ ਦਾ ਪੁੱਤਰ ਅਲਯਾਸਾਫ਼। ");
INSERT INTO pan_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","ਨਫ਼ਤਾਲੀ ਲਈ ਏਨਾਨ ਦਾ ਪੁੱਤਰ ਅਹੀਰਾ। ");
INSERT INTO pan_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","ਇਹ ਮੰਡਲੀ ਤੋਂ ਸੱਦੇ ਹੋਏ ਆਪਣੇ ਪੁਰਖਿਆਂ ਦੇ ਗੋਤਾਂ ਵਿੱਚ ਪ੍ਰਧਾਨ ਸਨ l ਇਹ ਇਸਰਾਏਲੀਆਂ ਵਿੱਚ ਕੁੱਲਾਂ ਦੇ ਪ੍ਰਧਾਨ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","ਮੂਸਾ ਅਤੇ ਹਾਰੂਨ ਨੇ ਇਨ੍ਹਾਂ ਮਨੁੱਖਾਂ ਨੂੰ ਨਾਲ ਲਿਆ ਜਿਨ੍ਹਾਂ ਦੇ ਨਾਮ ਦਾ ਉੱਤੇ ਜ਼ਿਕਰ ਕੀਤਾ ਗਿਆ ਹੈ, ");
INSERT INTO pan_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","ਪੁਰਖਿਆਂ ਨੇ ਦੂਜੇ ਮਹੀਨੇ ਦੇ ਪਹਿਲੇ ਦਿਨ ਸਾਰੀ ਮੰਡਲੀ ਨੂੰ ਇਕੱਠਾ ਕੀਤਾ ਅਤੇ ਆਪਣੇ ਕੁੱਲਾਂ ਅਤੇ ਆਪਣੇ ਪੁਰਖਿਆਂ ਦੇ ਘਰਾਣਿਆਂ ਅਨੁਸਾਰ, ਜਿਹੜੇ ਵੀਹ ਸਾਲ ਦੇ ਜਾਂ ਇਸ ਤੋਂ ਵੱਧ ਉਮਰ ਦੇ ਸਨ, ਉਨ੍ਹਾਂ ਦੇ ਨਾਮ ਦੀ ਗਿਣਤੀ ਕਰਵਾ ਕੇ ਆਪਣੀ ਵੰਸ਼ਾਵਲੀ ਲਿਖਵਾਈ। ");
INSERT INTO pan_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","ਜਿਵੇਂ ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਹੁਕਮ ਦਿੱਤਾ ਸੀ ਉਸੇ ਤਰ੍ਹਾਂ ਹੀ ਉਸਨੇ ਸੀਨਈ ਦੀ ਉਜਾੜ ਵਿੱਚ ਉਨ੍ਹਾਂ ਦੀ ਗਿਣਤੀ ਕੀਤੀ। ");
INSERT INTO pan_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","ਇਸਰਾਏਲ ਦੇ ਪਹਿਲੌਠੇ ਰਊਬੇਨ ਦੇ ਪੁੱਤਰਾਂ ਦੀ ਵੰਸ਼ਾਵਲੀ ਆਪਣੀਆਂ ਕੁਲਾਂ ਆਪਣੇ ਪੁਰਖਿਆਂ ਦੇ ਘਰਾਣਿਆਂ ਅਨੁਸਾਰ ਜਿੰਨੇ ਆਦਮੀ ਵੀਹ ਸਾਲ ਦੇ ਜਾਂ ਇਸ ਤੋਂ ਵੱਧ ਉਮਰ ਦੇ ਸਨ, ਸਾਰੇ ਜਿਹੜੇ ਯੁੱਧ ਕਰਨ ਦੇ ਯੋਗ ਸਨ ਉਹ ਸਾਰੇ ਆਪਣੇ ਨਾਮ ਤੋਂ ਗਿਣੇ ਗਏ। ");
INSERT INTO pan_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","ਰਊਬੇਨ ਦੇ ਗੋਤ ਦੇ ਗਿਣੇ ਹੋਏ ਪੁਰਖ ਛਿਆਲੀ ਹਜ਼ਾਰ ਪੰਜ ਸੌ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","ਸ਼ਿਮਓਨ ਦੇ ਪੁੱਤਰਾਂ ਦੀ ਵੰਸ਼ਾਵਲੀ ਆਪਣੀਆਂ ਕੁਲਾਂ ਅਤੇ ਆਪਣੇ ਪੁਰਖਿਆਂ ਦੇ ਘਰਾਣਿਆਂ ਅਨੁਸਾਰ ਜਿੰਨੇ ਪੁਰਖ ਵੀਹ ਸਾਲ ਜਾਂ ਇਸ ਤੋਂ ਵੱਧ ਉਮਰ ਦੇ ਸਨ, ਸਾਰੇ ਜਿਹੜੇ ਯੁੱਧ ਕਰਨ ਦੇ ਯੋਗ ਸਨ ਉਹ ਸਾਰੇ ਆਪਣੇ ਨਾਮ ਤੋਂ ਗਿਣੇ ਗਏ। ");
INSERT INTO pan_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","ਸ਼ਿਮਓਨ ਦੇ ਗੋਤ ਦੇ ਗਿਣੇ ਹੋਏ ਪੁਰਖ ਉਣਾਹਠ ਹਜ਼ਾਰ ਤਿੰਨ ਸੌ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","ਗਾਦ ਦੇ ਪੁੱਤਰਾਂ ਦੀ ਵੰਸ਼ਾਵਲੀ ਆਪਣੀਆਂ ਕੁਲਾਂ ਅਤੇ ਆਪਣੇ ਪੁਰਖਿਆਂ ਦੇ ਘਰਾਣਿਆਂ ਅਨੁਸਾਰ ਜਿੰਨੇ ਵੀਹ ਸਾਲ ਜਾਂ ਇਸ ਤੋਂ ਵੱਧ ਉਮਰ ਦੇ ਸਨ, ਸਾਰੇ ਜਿਹੜੇ ਯੁੱਧ ਕਰਨ ਦੇ ਯੋਗ ਸਨ ਉਹ ਸਾਰੇ ਆਪਣੇ ਨਾਮ ਤੋਂ ਗਿਣੇ ਗਏ। ");
INSERT INTO pan_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","ਗਾਦ ਦੇ ਗੋਤ ਦੇ ਗਿਣੇ ਹੋਏ ਪੁਰਖ ਪੰਤਾਲੀ ਹਜ਼ਾਰ ਛੇ ਸੌ ਪੰਜਾਹ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","ਯਹੂਦਾਹ ਦੇ ਪੁੱਤਰਾਂ ਦੀ ਵੰਸ਼ਾਵਲੀ ਆਪਣੀਆਂ ਕੁਲਾਂ ਅਤੇ ਆਪਣੇ ਪੁਰਖਿਆਂ ਦੇ ਘਰਾਣਿਆਂ ਅਨੁਸਾਰ ਜਿੰਨੇ ਵੀਹ ਸਾਲ ਜਾਂ ਉਸ ਤੋਂ ਵੱਧ ਉਮਰ ਦੇ ਸਨ ਜਿਹੜੇ ਯੁੱਧ ਕਰਨ ਦੇ ਯੋਗ ਸਨ ਉਹ ਸਭ ਆਪਣੇ ਨਾਮਾਂ ਤੋਂ ਗਿਣੇ ਗਏ। ");
INSERT INTO pan_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","ਅਤੇ ਯਹੂਦਾਹ ਦੇ ਗੋਤ ਦੇ ਗਿਣੇ ਹੋਏ ਪੁਰਖ ਚੁਹੱਤਰ ਹਜ਼ਾਰ ਛੇ ਸੌ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","ਯਿੱਸਾਕਾਰ ਦੇ ਪੁੱਤਰਾਂ ਦੀ ਵੰਸ਼ਾਵਲੀ ਆਪਣੀਆਂ ਕੁਲਾਂ ਅਤੇ ਆਪਣੇ ਪੁਰਖਿਆਂ ਦੇ ਘਰਾਣਿਆਂ ਅਨੁਸਾਰ ਵੀਹ ਸਾਲ ਜਾਂ ਇਸ ਤੋਂ ਵੱਧ ਉਮਰ ਦੇ ਸਨ, ਸਾਰੇ ਜਿਹੜੇ ਯੁੱਧ ਕਰਨ ਦੇ ਯੋਗ ਸਨ ਉਹ ਸਾਰੇ ਆਪਣੇ ਨਾਮ ਤੋਂ ਗਿਣੇ ਗਏ। ");
INSERT INTO pan_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","ਅਤੇ ਯਿੱਸਾਕਾਰ ਦੇ ਗੋਤ ਦੇ ਗਿਣੇ ਹੋਏ ਚੁਰੰਜਾ ਹਜ਼ਾਰ ਚਾਰ ਸੌ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","ਜ਼ਬੂਲੁਨ ਦੇ ਪੁੱਤਰਾਂ ਦੀ ਵੰਸ਼ਾਵਲੀ ਆਪਣੀਆਂ ਕੁਲਾਂ ਅਤੇ ਆਪਣੇ ਪੁਰਖਿਆਂ ਦੇ ਘਰਾਣਿਆਂ ਅਨੁਸਾਰ ਵੀਹ ਸਾਲ ਜਾਂ ਇਸ ਤੋਂ ਵੱਧ ਉਮਰ ਦੇ ਸਨ, ਸਾਰੇ ਜਿਹੜੇ ਯੁੱਧ ਕਰਨ ਦੇ ਯੋਗ ਸਨ ਉਹ ਸਾਰੇ ਆਪਣੇ ਨਾਮ ਤੋਂ ਗਿਣੇ ਗਏ। ");
INSERT INTO pan_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","ਅਤੇ ਜ਼ਬੂਲੁਨ ਦੇ ਗੋਤ ਦੇ ਗਿਣੇ ਹੋਏ ਸਤਵੰਜਾ ਹਜ਼ਾਰ ਚਾਰ ਸੌ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","ਯੂਸੁਫ਼ ਦੇ ਪੁੱਤਰ ਇਫ਼ਰਾਈਮ ਦੇ ਪੁੱਤਰਾਂ ਦੀ ਵੰਸ਼ਾਵਲੀ ਆਪਣੀਆਂ ਕੁਲਾਂ ਅਤੇ ਆਪਣੇ ਪੁਰਖਿਆਂ ਦੇ ਘਰਾਣਿਆਂ ਅਨੁਸਾਰ ਜਿਹੜੇ ਵੀਹ ਸਾਲ ਜਾਂ ਇਸ ਤੋਂ ਵੱਧ ਉਮਰ ਦੇ ਸਨ, ਸਾਰੇ ਜਿਹੜੇ ਯੁੱਧ ਕਰਨ ਦੇ ਯੋਗ ਸਨ ਉਹ ਸਾਰੇ ਆਪਣੇ ਨਾਮ ਤੋਂ ਗਿਣੇ ਗਏ। ");
INSERT INTO pan_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","ਅਤੇ ਇਫ਼ਰਾਈਮ ਦੇ ਗੋਤ ਦੇ ਗਿਣੇ ਹੋਏ ਚਾਲ੍ਹੀ ਹਜ਼ਾਰ ਪੰਜ ਸੌ ਪੁਰਖ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","ਮਨੱਸ਼ਹ ਦੇ ਪੁੱਤਰਾਂ ਦੀ ਵੰਸ਼ਾਵਲੀ ਆਪਣੀਆਂ ਕੁਲਾਂ ਅਤੇ ਆਪਣੇ ਪੁਰਖਿਆਂ ਦੇ ਘਰਾਣਿਆਂ ਅਨੁਸਾਰ ਜਿਹੜੇ ਵੀਹ ਸਾਲ ਜਾਂ ਇਸ ਤੋਂ ਵੱਧ ਉਮਰ ਦੇ ਸਨ, ਸਾਰੇ ਜਿਹੜੇ ਯੁੱਧ ਕਰਨ ਦੇ ਯੋਗ ਸਨ ਉਹ ਸਾਰੇ ਆਪਣੇ ਨਾਮ ਤੋਂ ਗਿਣੇ ਗਏ। ");
INSERT INTO pan_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","ਅਤੇ ਮਨੱਸ਼ਹ ਦੇ ਗੋਤ ਦੇ ਗਿਣੇ ਹੋਏ ਪੁਰਖ ਬੱਤੀ ਹਜ਼ਾਰ ਦੋ ਸੌ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","ਬਿਨਯਾਮੀਨ ਦੇ ਪੁੱਤਰਾਂ ਦੀ ਵੰਸ਼ਾਵਲੀ ਆਪਣੀਆਂ ਕੁਲਾਂ ਅਤੇ ਆਪਣੇ ਪੁਰਖਿਆਂ ਦੇ ਘਰਾਣਿਆਂ ਅਨੁਸਾਰ ਜਿਹੜੇ ਵੀਹ ਸਾਲ ਜਾਂ ਇਸ ਤੋਂ ਵੱਧ ਉਮਰ ਦੇ ਸਨ, ਸਾਰੇ ਜਿਹੜੇ ਯੁੱਧ ਕਰਨ ਦੇ ਯੋਗ ਸਨ ਉਹ ਸਾਰੇ ਆਪਣੇ ਨਾਮ ਤੋਂ ਗਿਣੇ ਗਏ। ");
INSERT INTO pan_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","ਅਤੇ ਬਿਨਯਾਮੀਨ ਦੇ ਗੋਤ ਦੇ ਗਿਣੇ ਹੋਏ ਪੁਰਖ ਪੈਂਤੀ ਹਜ਼ਾਰ ਚਾਰ ਸੌ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","ਦਾਨ ਦੇ ਪੁੱਤਰਾਂ ਦੀ ਵੰਸ਼ਾਵਲੀ ਆਪਣੀਆਂ ਕੁਲਾਂ ਅਤੇ ਆਪਣੇ ਪੁਰਖਿਆਂ ਦੇ ਘਰਾਣਿਆਂ ਅਨੁਸਾਰ ਜਿਹੜੇ ਵੀਹ ਸਾਲ ਜਾਂ ਇਸ ਤੋਂ ਵੱਧ ਉਮਰ ਦੇ ਸਨ, ਸਾਰੇ ਜਿਹੜੇ ਯੁੱਧ ਕਰਨ ਦੇ ਯੋਗ ਸਨ ਉਹ ਸਾਰੇ ਆਪਣੇ ਨਾਮ ਤੋਂ ਗਿਣੇ ਗਏ। ");
INSERT INTO pan_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","ਅਤੇ ਦਾਨ ਦੇ ਗੋਤ ਦੇ ਗਿਣੇ ਹੋਏ ਪੁਰਖ ਬਾਹਠ ਹਜ਼ਾਰ ਸੱਤ ਸੌ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","ਆਸ਼ੇਰ ਦੇ ਪੁੱਤਰਾਂ ਦੀ ਵੰਸ਼ਾਵਲੀ ਆਪਣੀਆਂ ਕੁਲਾਂ ਅਤੇ ਆਪਣੇ ਪੁਰਖਿਆਂ ਦੇ ਘਰਾਣਿਆਂ ਅਨੁਸਾਰ ਜਿਹੜੇ ਵੀਹ ਸਾਲ ਜਾਂ ਇਸ ਤੋਂ ਵੱਧ ਉਮਰ ਦੇ ਸਨ, ਸਾਰੇ ਜਿਹੜੇ ਯੁੱਧ ਕਰਨ ਦੇ ਯੋਗ ਸਨ ਉਹ ਸਾਰੇ ਆਪਣੇ ਨਾਮ ਤੋਂ ਗਿਣੇ ਗਏ। ");
INSERT INTO pan_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","ਅਤੇ ਆਸ਼ੇਰ ਦੇ ਗੋਤ ਦੇ ਗਿਣੇ ਹੋਏ ਪੁਰਖ ਇੱਕਤਾਲੀ ਹਜ਼ਾਰ ਪੰਜ ਸੌ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","ਨਫ਼ਤਾਲੀ ਦੇ ਪੁੱਤਰਾਂ ਦੀ ਵੰਸ਼ਾਵਲੀ ਆਪਣੀਆਂ ਕੁਲਾਂ ਅਤੇ ਆਪਣੇ ਪੁਰਖਿਆਂ ਦੇ ਘਰਾਣਿਆਂ ਅਨੁਸਾਰ ਜਿਹੜੇ ਵੀਹ ਸਾਲ ਜਾਂ ਇਸ ਤੋਂ ਵੱਧ ਉਮਰ ਦੇ ਸਨ, ਸਾਰੇ ਜਿਹੜੇ ਯੁੱਧ ਕਰਨ ਦੇ ਯੋਗ ਸਨ ਉਹ ਸਾਰੇ ਆਪਣੇ ਨਾਮ ਤੋਂ ਗਿਣੇ ਗਏ। ");
INSERT INTO pan_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","ਅਤੇ ਨਫ਼ਤਾਲੀ ਦੇ ਗੋਤ ਦੇ ਗਿਣੇ ਹੋਏ ਪੁਰਖ ਤਿਰਵੰਜਾ ਹਜ਼ਾਰ ਚਾਰ ਸੌ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","ਇਹ ਉਹ ਹਨ ਜਿਹੜੇ ਗਿਣੇ ਗਏ ਜਿਨ੍ਹਾਂ ਨੂੰ ਮੂਸਾ, ਹਾਰੂਨ ਅਤੇ ਇਸਰਾਏਲ ਦੇ ਬਾਰਾਂ ਪ੍ਰਧਾਨਾਂ ਨੇ ਗਿਣਿਆ ਉਹ ਆਪਣੇ-ਆਪਣੇ ਪੁਰਖਿਆਂ ਦੇ ਪਰਿਵਾਰ ਲਈ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","ਸੋ ਉਹ ਸਾਰੇ ਜਿਹੜੇ ਇਸਰਾਏਲੀਆਂ ਵਿੱਚੋਂ ਆਪਣੇ ਪੁਰਖਿਆਂ ਦੇ ਘਰਾਣਿਆਂ ਅਨੁਸਾਰ ਗਿਣੇ ਗਏ ਵੀਹ ਸਾਲਾਂ ਜਾਂ ਉਸ ਤੋਂ ਵੱਧ ਉਮਰ ਦੇ ਸਨ, ਸਾਰੇ ਜਿਹੜੇ ਇਸਰਾਏਲੀਆਂ ਵਿੱਚੋਂ ਯੁੱਧ ਕਰਨ ਦੇ ਯੋਗ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","ਸਾਰੇ ਜਿਹੜੇ ਗਿਣੇ ਗਏ ਛੇ ਲੱਖ ਤਿੰਨ ਹਜ਼ਾਰ ਪੰਜ ਸੋ ਪੰਜਾਹ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","ਪਰ ਲੇਵੀ ਆਪਣੇ ਪੁਰਖਿਆਂ ਦੇ ਗੋਤ ਅਨੁਸਾਰ ਉਨ੍ਹਾਂ ਵਿੱਚ ਨਾ ਗਿਣੇ ਗਏ। ");
INSERT INTO pan_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਆਖਿਆ ");
INSERT INTO pan_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","ਕਿ ਸਿਰਫ਼ ਲੇਵੀਆਂ ਦੇ ਗੋਤ ਨੂੰ ਤੂੰ ਨਾ ਗਿਣੀਂ ਅਤੇ ਉਨ੍ਹਾਂ ਦੀ ਗਿਣਤੀ ਇਸਰਾਏਲੀਆਂ ਵਿੱਚ ਨਾ ਕਰੀਂ। ");
INSERT INTO pan_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","ਪਰ ਤੂੰ ਲੇਵੀਆਂ ਨੂੰ ਸਾਖੀ ਦੇ ਡੇਰੇ ਉੱਤੇ, ਉਸ ਦੇ ਸਾਰੇ ਸਮਾਨ ਉੱਤੇ ਅਤੇ ਜੋ ਕੁਝ ਉਸ ਦਾ ਹੈ ਉਸ ਉੱਤੇ ਨਿਯੁਕਤ ਕਰੀਂ। ਉਹ ਡੇਰੇ ਨੂੰ ਅਤੇ ਉਸ ਦੇ ਸਾਰੇ ਸਮਾਨ ਨੂੰ ਚੁੱਕਣ ਅਤੇ ਉਹ ਉਸ ਦੀ ਸੇਵਾ ਕਰਨ ਅਤੇ ਡੇਰੇ ਦੇ ਆਲੇ-ਦੁਆਲੇ ਆਪਣੇ ਤੰਬੂ ਲਾਉਣ। ");
INSERT INTO pan_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","ਜਦ ਡੇਰੇ ਨੂੰ ਅੱਗੇ ਲੈ ਕੇ ਜਾਣਾ ਹੋਵੇ ਤਾਂ ਲੇਵੀ ਉਸ ਨੂੰ ਹੇਠਾਂ ਉਤਾਰਨ ਅਤੇ ਜਦ ਡੇਰੇ ਨੂੰ ਲਾਉਣਾ ਹੋਵੇ ਤਾਂ ਉਹ ਨੂੰ ਖੜ੍ਹਾ ਕਰਨ ਪਰ ਜੇ ਕੋਈ ਅਜਨਬੀ ਜਿਹੜਾ ਉਸ ਦੇ ਨੇੜੇ ਆਵੇ ਮਾਰ ਦਿੱਤਾ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","ਇਸਰਾਏਲੀ ਆਪਣੇ ਤੰਬੂ ਇਸ ਤਰ੍ਹਾਂ ਲਾਉਣ ਕਿ ਹਰ ਮਨੁੱਖ ਆਪਣੇ ਡੇਰੇ ਵਿੱਚ ਅਤੇ ਹਰ ਮਨੁੱਖ ਆਪਣੇ ਝੰਡੇ ਕੋਲ ਆਪਣੀਆਂ ਸੈਨਾਂ ਅਨੁਸਾਰ ਹੋਵੇ। ");
INSERT INTO pan_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","ਪਰ ਲੇਵੀ ਸਾਖੀ ਦੇ ਡੇਰੇ ਦੇ ਆਲੇ-ਦੁਆਲੇ ਆਪਣੇ ਤੰਬੂ ਲਾਉਣ ਤਾਂ ਜੋ ਇਸਰਾਏਲੀਆਂ ਦੀ ਮੰਡਲੀ ਉੱਤੇ ਯਹੋਵਾਹ ਦਾ ਕ੍ਰੋਧ ਨਾ ਭੜਕੇ ਅਤੇ ਲੇਵੀ ਸਾਖੀ ਦੇ ਡੇਰੇ ਦੀ ਰਾਖੀ ਕਰਨ। ");
INSERT INTO pan_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","ਇਸਰਾਏਲੀਆਂ ਨੇ ਇਸ ਤਰ੍ਹਾਂ ਹੀ ਕੀਤਾ। ਜਿਵੇਂ ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਹੁਕਮ ਦਿੱਤਾ ਸੀ ਇਸਰਾਏਲੀਆਂ ਨੇ ਉਸੇ ਤਰ੍ਹਾਂ ਹੀ ਕੀਤਾ। ");
INSERT INTO pan_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","ਫੇਰ ਯਹੋਵਾਹ ਮੂਸਾ ਅਤੇ ਹਾਰੂਨ ਨੂੰ ਬੋਲਿਆ ");
INSERT INTO pan_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","ਕਿ ਇਸਰਾਏਲੀਆਂ ਦਾ ਹਰ ਮਨੁੱਖ ਆਪਣੇ ਝੰਡੇ ਕੋਲ ਆਪਣੇ ਪੁਰਖਿਆਂ ਦੇ ਘਰਾਣਿਆਂ ਦੇ ਨਿਸ਼ਾਨਾਂ ਨਾਲ ਆਪਣਾ ਤੰਬੂ ਖੜ੍ਹਾ ਕਰੇ। ਮੰਡਲੀ ਦੇ ਤੰਬੂ ਦੇ ਸਾਹਮਣੇ ਅਤੇ ਆਲੇ-ਦੁਆਲੇ ਉਹ ਤੰਬੂ ਲਾਉਣ। ");
INSERT INTO pan_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","ਜਿਹੜੇ ਸੂਰਜ ਦੇ ਚੜ੍ਹਦੇ ਪਾਸੇ ਡੇਰਾ ਲਾਉਣ, ਜਿਹੜੇ ਯਹੂਦਾਹ ਦੇ ਡੇਰੇ ਦੇ ਹੋਣ ਉਹ ਆਪਣੀਆਂ ਸੈਨਾਂ ਅਨੁਸਾਰ ਯਹੂਦਾਹ ਦੇ ਝੰਡੇ ਦੇ ਹੋਣ ਅਤੇ ਯਹੂਦਾਹ ਦੇ ਲੋਕਾਂ ਦਾ ਪ੍ਰਧਾਨ ਅੰਮੀਨਾਦਾਬ ਦਾ ਪੁੱਤਰ ਨਹਸ਼ੋਨ ਹੋਵੇ। ");
INSERT INTO pan_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","ਉਸ ਦੀ ਸੈਨਾਂ ਦੇ ਗਿਣੇ ਹੋਏ ਲੋਕ ਚੁਹੱਤਰ ਹਜ਼ਾਰ ਛੇ ਸੌ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","ਜਿਹੜੇ ਉਸ ਦੇ ਕੋਲ ਡੇਰਾ ਲਾਉਣ ਉਹ ਯਿੱਸਾਕਾਰ ਦੇ ਗੋਤ ਦੇ ਹੋਣ ਅਤੇ ਯਿੱਸਾਕਾਰ ਦੇ ਲੋਕਾਂ ਦਾ ਪ੍ਰਧਾਨ ਸੂਆਰ ਦਾ ਪੁੱਤਰ ਨਥਨਿਏਲ ਹੋਵੇ। ");
INSERT INTO pan_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","ਉਸ ਦੀ ਸੈਨਾਂ ਦੇ ਗਿਣੇ ਹੋਏ ਲੋਕ ਚੁਰੰਜਾ ਹਜ਼ਾਰ ਚਾਰ ਸੌ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","ਜ਼ਬੂਲੁਨ ਦੇ ਗੋਤ ਯਿੱਸਾਕਾਰ ਦੇ ਕੋਲ ਰਹਿਣ, ਜ਼ਬੂਲੁਨ ਦੇ ਲੋਕਾਂ ਦਾ ਪ੍ਰਧਾਨ ਹੇਲੋਨ ਦਾ ਪੁੱਤਰ ਅਲੀਆਬ ਹੋਵੇ। ");
INSERT INTO pan_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","ਉਸ ਦੀ ਸੈਨਾਂ ਦੇ ਗਿਣੇ ਹੋਏ ਲੋਕ ਸਤਵੰਜਾ ਹਜ਼ਾਰ ਚਾਰ ਸੌ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","ਯਹੂਦਾਹ ਦੇ ਡੇਰੇ ਦੇ ਸਾਰੇ ਗਿਣੇ ਹੋਏ ਲੋਕ ਇੱਕ ਲੱਖ ਛਿਆਸੀ ਹਜ਼ਾਰ ਚਾਰ ਸੌ, ਉਨ੍ਹਾਂ ਦੀਆਂ ਸੈਨਾਂ ਅਨੁਸਾਰ ਸਨ। ਪਹਿਲਾਂ ਉਹ ਕੂਚ ਕਰਨ। ");
INSERT INTO pan_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","ਰਊਬੇਨ ਦੇ ਡੇਰੇ ਦਾ ਝੰਡਾ ਦੱਖਣ ਵੱਲ ਉਨ੍ਹਾਂ ਦੀਆਂ ਸੈਨਾਂ ਅਨੁਸਾਰ ਹੋਵੇ ਅਤੇ ਰਊਬੇਨ ਦੇ ਲੋਕਾਂ ਦਾ ਪ੍ਰਧਾਨ ਸ਼ਦੇਊਰ ਦਾ ਪੁੱਤਰ ਅਲੀਸੂਰ ਹੋਵੇ। ");
INSERT INTO pan_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","ਉਸ ਦੀ ਸੈਨਾਂ ਦੇ ਗਿਣੇ ਹੋਏ ਲੋਕ ਛਿਆਲੀ ਹਜ਼ਾਰ ਪੰਜ ਸੌ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","ਜਿਹੜੇ ਉਸ ਕੋਲ ਡੇਰਾ ਲਾਉਣ ਉਹ ਸ਼ਿਮਓਨ ਦੇ ਗੋਤ ਦੇ ਹੋਣ ਅਤੇ ਸ਼ਿਮਓਨ ਦੇ ਲੋਕਾਂ ਦਾ ਪ੍ਰਧਾਨ ਸੂਰੀਸ਼ਦਾਈ ਦਾ ਪੁੱਤਰ ਸ਼ਲੁਮੀਏਲ ਹੋਵੇ। ");
INSERT INTO pan_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","ਉਹ ਦੀ ਸੈਨਾਂ ਦੇ ਗਿਣੇ ਹੋਏ ਲੋਕ ਉਣਾਹਠ ਹਜ਼ਾਰ ਤਿੰਨ ਸੌ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","ਫੇਰ ਗਾਦ ਦਾ ਗੋਤ ਅਤੇ ਗਾਦ ਦੇ ਲੋਕਾਂ ਦਾ ਪ੍ਰਧਾਨ ਰਊਏਲ ਦਾ ਪੁੱਤਰ ਅਲਯਾਸਾਫ਼ ਹੋਵੇ। ");
INSERT INTO pan_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","ਅਤੇ ਉਸ ਦੀ ਸੈਨਾਂ ਦੇ ਗਿਣੇ ਹੋਏ ਲੋਕ ਪੰਤਾਲੀ ਹਜ਼ਾਰ ਛੇ ਸੌ ਪੰਜਾਹ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","ਰਊਬੇਨ ਦੇ ਡੇਰੇ ਦੇ ਸਾਰੇ ਗਿਣੇ ਹੋਏ ਲੋਕ ਇੱਕ ਲੱਖ ਇਕਵੰਜਾ ਹਜ਼ਾਰ ਚਾਰ ਸੌ ਪੰਜਾਹ, ਉਨ੍ਹਾਂ ਦੀਆਂ ਸੈਨਾਂ ਅਨੁਸਾਰ ਸਨ ਅਤੇ ਦੂਜੇ ਉਹ ਕੂਚ ਕਰਨ। ");
INSERT INTO pan_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","ਫੇਰ ਮਿਲਾਪ ਵਾਲੇ ਤੰਬੂ ਦਾ ਕੂਚ ਹੋਵੇ ਅਤੇ ਲੇਵੀਆਂ ਦਾ ਡੇਰਾ ਡੇਰਿਆਂ ਦੇ ਵਿਚਕਾਰ ਹੋਵੇ। ਜਿਵੇਂ ਉਨ੍ਹਾਂ ਨੇ ਡੇਰੇ ਲਾਏ ਉਸੇ ਤਰ੍ਹਾਂ ਉਹ ਕੂਚ ਕਰਨ। ਹਰ ਮਨੁੱਖ ਆਪਣੇ ਥਾਂ ਵਿੱਚ ਆਪਣੇ ਝੰਡਿਆਂ ਕੋਲ ਹੋਵੇ। ");
INSERT INTO pan_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","ਇਫ਼ਰਾਈਮ ਦੇ ਡੇਰੇ ਦਾ ਝੰਡਾ ਉਨ੍ਹਾਂ ਦੀਆਂ ਸੈਨਾਂ ਅਨੁਸਾਰ ਪੱਛਮ ਪਾਸੇ ਵੱਲ ਹੋਵੇ ਅਤੇ ਇਫ਼ਰਾਈਮ ਦੇ ਲੋਕਾਂ ਦਾ ਪ੍ਰਧਾਨ ਅੰਮੀਹੂਦ ਦਾ ਪੁੱਤਰ ਅਲੀਸ਼ਾਮਾ ਹੋਵੇ। ");
INSERT INTO pan_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","ਉਸ ਦੀ ਸੈਨਾਂ ਦੇ ਗਿਣੇ ਹੋਏ ਲੋਕ ਚਾਲ੍ਹੀ ਹਜ਼ਾਰ ਪੰਜ ਸੌ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","ਫੇਰ ਉਹ ਦੇ ਨੇੜ੍ਹੇ ਮਨੱਸ਼ਹ ਦਾ ਗੋਤ ਹੋਵੇ ਅਤੇ ਮਨੱਸ਼ਹ ਦੇ ਲੋਕਾਂ ਦਾ ਪ੍ਰਧਾਨ ਪਦਾਹਸੂਰ ਦਾ ਪੁੱਤਰ ਗਮਲੀਏਲ ਹੋਵੇ। ");
INSERT INTO pan_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","ਅਤੇ ਉਸ ਦੀ ਸੈਨਾਂ ਦੇ ਗਿਣੇ ਹੋਏ ਲੋਕ ਬੱਤੀ ਹਜ਼ਾਰ ਦੋ ਸੌ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","ਫੇਰ ਬਿਨਯਾਮੀਨ ਦਾ ਗੋਤ ਹੋਵੇ ਅਤੇ ਬਿਨਯਾਮੀਨ ਦੇ ਲੋਕਾਂ ਦਾ ਪ੍ਰਧਾਨ ਗਿਦਓਨੀ ਦਾ ਪੁੱਤਰ ਅਬੀਦਾਨ ਹੋਵੇ। ");
INSERT INTO pan_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","ਅਤੇ ਉਸ ਦੀ ਸੈਨਾਂ ਦੇ ਗਿਣੇ ਹੋਏ ਲੋਕ ਪੈਂਤੀ ਹਜ਼ਾਰ ਚਾਰ ਸੌ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","ਇਫ਼ਰਾਈਮ ਦੇ ਡੇਰੇ ਦੇ ਸਾਰੇ ਗਿਣੇ ਹੋਏ ਲੋਕ ਇੱਕ ਲੱਖ ਅੱਠ ਹਜ਼ਾਰ ਇੱਕ ਸੌ, ਉਨ੍ਹਾਂ ਦੀਆਂ ਸੈਨਾਂ ਦੇ ਅਨੁਸਾਰ ਸਨ। ਤੀਜੇ ਉਹ ਕੂਚ ਕਰਨ। ");
INSERT INTO pan_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","ਦਾਨ ਦੇ ਡੇਰੇ ਦਾ ਝੰਡਾ ਉੱਤਰ ਦੇ ਪਾਸੇ, ਉਨ੍ਹਾਂ ਦੀਆਂ ਸੈਨਾਂ ਅਨੁਸਾਰ ਹੋਵੇ ਅਤੇ ਦਾਨ ਦੇ ਲੋਕਾਂ ਦਾ ਪ੍ਰਧਾਨ ਅੰਮੀਸ਼ੱਦਾਈ ਦਾ ਪੁੱਤਰ ਅਹੀਅਜ਼ਰ ਹੋਵੇ। ");
INSERT INTO pan_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","ਉਸ ਦੀ ਸੈਨਾਂ ਦੇ ਗਿਣੇ ਹੋਏ ਲੋਕ ਬਾਹਠ ਹਜ਼ਾਰ ਸੱਤ ਸੌ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","ਜਿਹੜੇ ਉਹ ਦੇ ਕੋਲ ਡੇਰਾ ਲਾਉਣ ਉਹ ਆਸ਼ੇਰ ਦੇ ਗੋਤ ਦੇ ਹੋਣ ਅਤੇ ਆਸ਼ੇਰ ਦੇ ਲੋਕਾਂ ਦਾ ਪ੍ਰਧਾਨ ਆਕਰਾਨ ਦਾ ਪੁੱਤਰ ਪਗੀਏਲ ਹੋਵੇ। ");
INSERT INTO pan_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","ਅਤੇ ਉਸ ਦੀ ਸੈਨਾਂ ਦੇ ਗਿਣੇ ਹੋਏ ਲੋਕ ਇੱਕਤਾਲੀ ਹਜ਼ਾਰ ਪੰਜ ਸੌ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","ਫੇਰ ਨਫ਼ਤਾਲੀ ਦਾ ਗੋਤ ਅਤੇ ਨਫ਼ਤਾਲੀ ਦੇ ਲੋਕਾਂ ਦਾ ਪ੍ਰਧਾਨ ਏਨਾਨ ਦਾ ਪੁੱਤਰ ਅਹੀਰਾ ਹੋਵੇ। ");
INSERT INTO pan_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","ਉਹ ਦੀ ਸੈਨਾਂ ਦੇ ਗਿਣੇ ਹੋਏ ਲੋਕ ਤਿਰਵੰਜਾ ਹਜ਼ਾਰ ਚਾਰ ਸੌ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","ਦਾਨ ਦੇ ਡੇਰੇ ਦੇ ਸਾਰੇ ਗਿਣੇ ਹੋਏ ਲੋਕ ਇੱਕ ਲੱਖ ਸਤਵੰਜਾ ਹਜ਼ਾਰ ਛੇ ਸੌ ਸਨ। ਉਹ ਸਭ ਦੇ ਪਿੱਛੋਂ ਆਪਣੇ ਝੰਡਿਆਂ ਦੇ ਨਾਲ ਕੂਚ ਕਰਨ। ");
INSERT INTO pan_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","ਇਹ ਉਹ ਇਸਰਾਏਲੀ ਹਨ, ਜਿਹੜੇ ਆਪਣੇ ਪੁਰਖਿਆਂ ਦੇ ਘਰਾਣਿਆਂ ਦੇ ਅਨੁਸਾਰ ਗਿਣੇ ਗਏ, ਡੇਰਿਆਂ ਦੇ ਸਾਰੇ ਗਿਣੇ ਹੋਏ, ਉਨ੍ਹਾਂ ਦੀਆਂ ਸੈਨਾਂ ਅਨੁਸਾਰ ਛੇ ਲੱਖ ਤਿੰਨ ਹਜ਼ਾਰ ਪੰਜ ਸੌ ਪੰਜਾਹ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","ਪਰ ਲੇਵੀ ਇਸਰਾਏਲੀਆਂ ਵਿੱਚ ਗਿਣੇ ਨਾ ਗਏ ਜਿਵੇਂ ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਹੁਕਮ ਦਿੱਤਾ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","ਜਿਵੇਂ ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਹੁਕਮ ਦਿੱਤਾ ਸੀ, ਇਸਰਾਏਲੀ ਆਪਣੀਆਂ ਕੁਲਾਂ ਅਤੇ ਆਪਣੇ ਪੁਰਖਿਆਂ ਦੇ ਘਰਾਣਿਆਂ ਅਨੁਸਾਰ ਅਤੇ ਆਪਣੇ-ਆਪਣੇ ਝੰਡਿਆਂ ਦੇ ਕੋਲ ਡੇਰਿਆਂ ਨੂੰ ਖੜ੍ਹਾ ਕਰਦੇ ਅਤੇ ਕੂਚ ਕਰਦੇ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","ਇਹ ਹਾਰੂਨ ਅਤੇ ਮੂਸਾ ਦੀ ਵੰਸ਼ਾਵਲੀ ਹੈ, ਜਿਸ ਦਿਨ ਯਹੋਵਾਹ ਸੀਨਈ ਪਰਬਤ ਉੱਤੇ ਮੂਸਾ ਨਾਲ ਬੋਲਿਆ। ");
INSERT INTO pan_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","ਹਾਰੂਨ ਦੇ ਪੁੱਤਰਾਂ ਦੇ ਨਾਮ ਇਹ ਹਨ, ਪਹਿਲੌਠਾ ਨਾਦਾਬ, ਫ਼ੇਰ ਅਬੀਹੂ, ਅਲਆਜ਼ਾਰ ਅਤੇ ਈਥਾਮਾਰ। ");
INSERT INTO pan_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","ਇਹ ਹਾਰੂਨ ਦੇ ਪੁੱਤਰਾਂ ਦੇ ਨਾਮ ਹਨ, ਉਹ ਜਾਜਕ ਜਿਹੜੇ ਮਸਹ ਕੀਤੇ ਗਏ ਅਤੇ ਜਿਨ੍ਹਾਂ ਨੂੰ ਉਸ ਨੇ ਜਾਜਕਾਈ ਲਈ ਥਾਪਿਆ। ");
INSERT INTO pan_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","ਨਾਦਾਬ ਅਤੇ ਅਬੀਹੂ ਯਹੋਵਾਹ ਦੇ ਸਨਮੁਖ ਮਰ ਗਏ ਜਦ ਉਹ ਸੀਨਈ ਦੀ ਉਜਾੜ ਵਿੱਚ ਯਹੋਵਾਹ ਦੇ ਸਨਮੁਖ ਅਯੋਗ ਅੱਗ ਲਿਆਏ ਅਤੇ ਉਨ੍ਹਾਂ ਦੇ ਪੁੱਤਰ ਨਹੀਂ ਸਨ ਇਸ ਲਈ ਅਲਆਜ਼ਾਰ ਅਤੇ ਈਥਾਮਾਰ ਆਪਣੇ ਪਿਤਾ ਹਾਰੂਨ ਦੇ ਅੱਗੇ ਜਾਜਕਾਈ ਦਾ ਕੰਮ ਕਰਦੇ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਆਖਿਆ ");
INSERT INTO pan_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","ਕਿ ਲੇਵੀ ਦੇ ਗੋਤ ਨੂੰ ਨੇੜੇ ਲਿਆ ਅਤੇ ਉਨ੍ਹਾਂ ਨੂੰ ਹਾਰੂਨ ਜਾਜਕ ਦੇ ਅੱਗੇ ਖੜ੍ਹਾ ਕਰ ਤਾਂ ਜੋ ਉਹ ਉਸ ਦੀ ਸੇਵਾ ਕਰਨ। ");
INSERT INTO pan_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","ਅਤੇ ਉਹ ਉਸਦਾ ਫ਼ਰਜ਼ ਅਤੇ ਸਾਰੀ ਮੰਡਲੀ ਦਾ ਫ਼ਰਜ਼ ਮਿਲਾਪ ਵਾਲੇ ਤੰਬੂ ਦੇ ਅੱਗੇ ਪੂਰਾ ਕਰਨ, ਜੋ ਉਹ ਡੇਰੇ ਦੀ ਟਹਿਲ ਸੇਵਾ ਕਰਨ। ");
INSERT INTO pan_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","ਉਹ ਮਿਲਾਪ ਵਾਲੇ ਤੰਬੂ ਦੇ ਸਾਰੇ ਸਮਾਨ ਨਾਲੇ ਇਸਰਾਏਲੀਆਂ ਦਾ ਫ਼ਰਜ਼ ਪੂਰਾ ਕਰਨ ਅਤੇ ਰਖਵਾਲੀ ਕਰਨ, ਇਸ ਤਰ੍ਹਾਂ ਉਹ ਡੇਰੇ ਦੀ ਟਹਿਲ ਸੇਵਾ ਕਰਨ। ");
INSERT INTO pan_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","ਤੂੰ ਲੇਵੀਆਂ ਨੂੰ ਹਾਰੂਨ ਅਤੇ ਉਸ ਦੇ ਪੁੱਤਰਾਂ ਨੂੰ ਦੇਈਂ। ਇਹ ਇਸਰਾਏਲੀਆਂ ਦੀ ਵੱਲੋਂ ਹਾਰੂਨ ਨੂੰ ਪੂਰੀ ਰੀਤੀ ਨਾਲ ਸਮਰਪਣ ਹੋਣ। ");
INSERT INTO pan_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","ਤੂੰ ਹਾਰੂਨ ਅਤੇ ਉਸ ਦੇ ਪੁੱਤਰਾਂ ਨੂੰ ਜਾਜਕਾਈ ਲਈ ਠਹਿਰਾਈਂ ਤਾਂ ਜੋ ਉਹ ਆਪਣੀ ਜਾਜਕਾਈ ਨੂੰ ਸਾਂਭਣ ਅਤੇ ਜੇ ਕੋਈ ਅਜਨਬੀ ਨੇੜੇ ਆਵੇ ਉਹ ਮਾਰਿਆ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","ਫੇਰ ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਆਖਿਆ, ");
INSERT INTO pan_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","ਵੇਖ, ਮੈਂ ਲੇਵੀਆਂ ਨੂੰ ਇਸਰਾਏਲੀਆਂ ਵਿੱਚੋਂ ਸਾਰੇ ਪਹਿਲੌਠਿਆਂ ਦੇ ਥਾਂ ਜਿਹੜੇ ਇਸਰਾਏਲ ਵਿੱਚ ਹਨ, ਲੈ ਲਿਆ ਹੈ ਇਸ ਤਰ੍ਹਾਂ ਲੇਵੀ ਮੇਰੇ ਹੋਣਗੇ। ");
INSERT INTO pan_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","ਕਿਉਂ ਜੋ ਹਰ ਇੱਕ ਪਹਿਲੌਠਾ ਮੇਰਾ ਹੈ ਜਿਸ ਦਿਨ ਤੋਂ ਮੈਂ ਮਿਸਰ ਦੇਸ ਵਿੱਚ ਹਰ ਇੱਕ ਪਹਿਲੌਠਾ ਮਾਰਿਆ। ਮੈਂ ਆਪਣੇ ਲਈ ਹਰ ਇੱਕ ਪਹਿਲੌਠਾ ਇਸਰਾਏਲ ਵਿੱਚ ਆਦਮੀ ਤੋਂ ਲੈ ਕੇ ਡੰਗਰ ਤੱਕ ਪਵਿੱਤਰ ਕੀਤਾ, ਉਹ ਮੇਰੇ ਹੋਣਗੇ। ਮੈਂ ਯਹੋਵਾਹ ਹਾਂ। ");
INSERT INTO pan_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","ਫੇਰ ਯਹੋਵਾਹ ਮੂਸਾ ਨਾਲ ਸੀਨਈ ਦੀ ਉਜਾੜ ਵਿੱਚ ਬੋਲਿਆ, ");
INSERT INTO pan_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","ਲੇਵੀਆਂ ਵਿੱਚੋਂ ਜਿਹੜੇ ਇੱਕ ਮਹੀਨੇ ਜਾਂ ਇਸ ਤੋਂ ਵੱਧ ਉਮਰ ਦੇ ਹੋਣ ਉਹਨਾਂ ਨੂੰ ਉਨ੍ਹਾਂ ਦੇ ਪੁਰਖਿਆਂ ਦੇ ਘਰਾਣਿਆਂ ਅਤੇ ਉਨ੍ਹਾਂ ਦੇ ਟੱਬਰਾਂ ਅਨੁਸਾਰ ਗਿਣ। ");
INSERT INTO pan_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","ਤਦ ਮੂਸਾ ਨੇ ਜਿਵੇਂ ਉਹ ਨੂੰ ਹੁਕਮ ਮਿਲਿਆ ਉਨ੍ਹਾਂ ਨੂੰ ਯਹੋਵਾਹ ਦੇ ਕਹੇ ਅਨੁਸਾਰ ਗਿਣਿਆ। ");
INSERT INTO pan_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","ਇਹ ਲੇਵੀ ਦੇ ਪੁੱਤਰਾਂ ਦੇ ਨਾਮ ਸਨ, ਗੇਰਸ਼ੋਨ, ਕਹਾਥ ਅਤੇ ਮਰਾਰੀ। ");
INSERT INTO pan_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","ਇਹ ਗੇਰਸ਼ੋਨ ਦੇ ਪੁੱਤਰਾਂ ਦੇ ਨਾਮ ਹਨ, ਉਨ੍ਹਾਂ ਦੇ ਟੱਬਰਾਂ ਅਨੁਸਾਰ, ਲਿਬਨੀ ਅਤੇ ਸ਼ਿਮਈ। ");
INSERT INTO pan_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","ਕਹਾਥ ਦੇ ਪੁੱਤਰ, ਉਨ੍ਹਾਂ ਦੇ ਟੱਬਰਾਂ ਅਨੁਸਾਰ, ਅਮਰਾਮ, ਯਿਸਹਾਰ, ਹਬਰੋਨ ਅਤੇ ਉੱਜ਼ੀਏਲ। ");
INSERT INTO pan_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","ਮਰਾਰੀ ਦੇ ਪੁੱਤਰ ਉਨ੍ਹਾਂ ਦੇ ਟੱਬਰਾਂ ਅਨੁਸਾਰ, ਮਹਲੀ ਅਤੇ ਮੂਸ਼ੀ। ਇਹ ਲੇਵੀ ਦੇ ਪਰਿਵਾਰ ਉਨ੍ਹਾਂ ਦੇ ਪੁਰਖਿਆਂ ਦੇ ਘਰਾਣਿਆਂ ਅਨੁਸਾਰ ਹਨ। ");
INSERT INTO pan_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","ਲਿਬਨੀਆਂ ਦਾ ਪਰਿਵਾਰ ਅਤੇ ਸ਼ਿਮਈਆਂ ਦਾ ਪਰਿਵਾਰ, ਗੇਰਸ਼ੋਨ ਦੇ ਹਨ। ਇਹ ਗੇਰਸ਼ੋਨੀਆਂ ਦੇ ਪਰਿਵਾਰ ਹਨ। ");
INSERT INTO pan_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","ਅਤੇ ਪੁਰਖ ਜਿਹੜੇ ਗਿਣਤੀ ਵਿੱਚ ਆਏ ਇੱਕ ਮਹੀਨੇ ਤੋਂ ਉੱਪਰ ਦੇ ਸੱਤ ਹਜ਼ਾਰ ਪੰਜ ਸੌ ਗਿਣੇ ਗਏ। ");
INSERT INTO pan_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","ਗੇਰਸ਼ੋਨੀਆਂ ਦੇ ਪਰਿਵਾਰ ਡੇਰੇ ਦੇ ਮਗਰ ਪੱਛਮ ਵਾਲੇ ਪਾਸੇ ਡੇਰਾ ਲਾਉਣ। ");
INSERT INTO pan_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","ਅਤੇ ਗੇਰਸ਼ੋਨੀਆਂ ਦੇ ਪੁਰਖਿਆਂ ਦੇ ਪਰਿਵਾਰ ਦਾ ਪ੍ਰਧਾਨ ਲਾਏਲ ਦਾ ਪੁੱਤਰ ਅਲਯਾਸਾਫ਼ ਹੋਵੇ। ");
INSERT INTO pan_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","ਗੇਰਸ਼ੋਨੀਆਂ ਦੀ ਜ਼ਿੰਮੇਵਾਰੀ ਵਿੱਚ, ਮਿਲਾਪ ਵਾਲੇ ਤੰਬੂ ਵਿੱਚ ਡੇਰਾ ਅਤੇ ਤੰਬੂ, ਉਹ ਦਾ ਪਰਦਾ ਅਤੇ ਮੰਡਲੀ ਦੇ ਦਰਵਾਜ਼ੇ ਦਾ ਪਰਦਾ ਹੋਣ। ");
INSERT INTO pan_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","ਨਾਲ ਹੀ ਵਿਹੜੇ ਦੀ ਕਨਾਤ ਅਤੇ ਵਿਹੜੇ ਦੇ ਦਰਵਾਜ਼ੇ ਦਾ ਪਰਦਾ ਜਿਹੜਾ ਡੇਰੇ ਦੇ ਕੋਲ ਅਤੇ ਜਗਵੇਦੀ ਦੇ ਕੋਲ ਅਤੇ ਆਲੇ-ਦੁਆਲੇ ਅਤੇ ਉਹ ਦੀਆਂ ਡੋਰੀਆਂ ਜੋ ਉਸ ਦੇ ਕੰਮ ਆਉਂਦੀਆਂ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","ਕਹਾਥ ਵਿੱਚੋਂ ਅਮਰਾਮੀਆਂ ਦਾ ਪਰਿਵਾਰ ਅਤੇ ਯਿਸਹਾਰੀਆਂ ਦਾ ਪਰਿਵਾਰ ਅਤੇ ਹਬਰੋਨੀਆਂ ਦਾ ਪਰਿਵਾਰ ਅਤੇ ਉੱਜ਼ੀਏਲੀਆਂ ਦਾ ਪਰਿਵਾਰ ਸੀ। ਇਹ ਕਹਾਥ ਦੇ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","ਸਾਰੇ ਪੁਰਖਾਂ ਦੀ ਗਿਣਤੀ ਜਿਹੜੇ ਇੱਕ ਮਹੀਨੇ ਅਤੇ ਇਸ ਤੋਂ ਉੱਪਰ ਦੇ ਸਨ, ਅੱਠ ਹਜ਼ਾਰ ਛੇ ਸੌ ਸੀ ਜਿਹੜੇ ਪਵਿੱਤਰ ਸਥਾਨ ਦੇ ਜ਼ਿੰਮੇਵਾਰ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","ਕਹਾਥੀਆਂ ਦੇ ਪਰਿਵਾਰ ਡੇਰੇ ਦੇ ਦੱਖਣ ਵੱਲ ਆਪਣਾ ਡੇਰਾ ਲਾਉਣ। ");
INSERT INTO pan_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","ਕਹਾਥੀਆਂ ਦੇ ਟੱਬਰਾਂ ਅਨੁਸਾਰ ਪੁਰਖਿਆਂ ਦੇ ਪਰਿਵਾਰ ਦਾ ਪ੍ਰਧਾਨ ਉੱਜ਼ੀਏਲ ਦਾ ਪੁੱਤਰ ਅਲੀਸਾਫ਼ਾਨ ਹੋਵੇ। ");
INSERT INTO pan_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","ਅਤੇ ਜਿਹਨਾਂ ਵਸਤਾਂ ਦੀ ਜ਼ਿੰਮੇਵਾਰੀ ਉਨ੍ਹਾਂ ਨੂੰ ਦਿੱਤੀ ਗਈ ਅਰਥਾਤ ਸੰਦੂਕ, ਮੇਜ਼, ਸ਼ਮਾਦਾਨ, ਜਗਵੇਦੀਆਂ ਅਤੇ ਪਵਿੱਤਰ ਸਥਾਨ ਦਾ ਸਮਾਨ ਜਿਨ੍ਹਾਂ ਨਾਲ ਉਹ ਸੇਵਾ ਟਹਿਲ ਕਰਦੇ ਸਨ ਅਤੇ ਪਰਦਾ ਅਤੇ ਪਵਿੱਤਰ ਸਥਾਨ ਵਿੱਚ ਕੰਮ ਆਉਣ ਵਾਲਾ ਸਾਰਾ ਸਮਾਨ ਸ਼ਾਮਿਲ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","ਅਤੇ ਲੇਵੀਆਂ ਦੇ ਹਾਕਮਾਂ ਦਾ ਪ੍ਰਧਾਨ ਹਾਰੂਨ ਜਾਜਕ ਦਾ ਪੁੱਤਰ ਅਲਆਜ਼ਾਰ ਹੋਵੇ ਅਤੇ ਉਹ ਪਵਿੱਤਰ ਸਥਾਨ ਦੇ ਰਖਵਾਲਿਆਂ ਦਾ ਮੁਖੀਆ ਹੋਵੇ। ");
INSERT INTO pan_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","ਮਹਲੀਆਂ ਦਾ ਪਰਿਵਾਰ ਅਤੇ ਮੂਸ਼ੀਆਂ ਦਾ ਪਰਿਵਾਰ, ਮਰਾਰੀ ਦੇ ਵਿੱਚੋਂ ਸਨ। ਇਹ ਮਰਾਰੀ ਦੇ ਪਰਿਵਾਰ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","ਸਾਰੇ ਪੁਰਖਾਂ ਦੀ ਗਿਣਤੀ ਜੋ ਇੱਕ ਮਹੀਨੇ ਜਾਂ ਇੱਕ ਮਹੀਨੇ ਤੋਂ ਉੱਪਰ ਦੇ ਸੀ, ਛੇ ਹਜ਼ਾਰ ਦੋ ਸੌ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","ਮਰਾਰੀ ਦੇ ਟੱਬਰਾਂ ਅਨੁਸਾਰ ਉਨ੍ਹਾਂ ਦੇ ਪੁਰਖਿਆਂ ਦੇ ਪਰਿਵਾਰ ਦਾ ਪ੍ਰਧਾਨ ਅਬੀਹੈਲ ਦਾ ਪੁੱਤਰ ਸੂਰੀਏਲ ਹੋਵੇ। ਡੇਰੇ ਦੇ ਉੱਤਰ ਵੱਲ ਉਹ ਆਪਣਾ ਡੇਰਾ ਲਾਉਣ। ");
INSERT INTO pan_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","ਅਤੇ ਜੋ ਵਸਤਾਂ ਮਰਾਰੀਆਂ ਨੂੰ ਦੇਖਭਾਲ ਲਈ ਦਿੱਤੀਆਂ ਗਈਆਂ ਉਹਨਾਂ ਦੀ ਰਖਵਾਲੀ ਕਰਨ, ਡੇਰੇ ਦੀਆਂ ਫੱਟੀਆਂ, ਉਸ ਦੇ ਕੁੰਡੇ ਉਸ ਦੀਆਂ ਥੰਮ੍ਹੀਆਂ, ਉਸ ਦੇ ਕਬਜ਼ੇ ਅਤੇ ਉਸ ਦਾ ਸਾਰਾ ਸਮਾਨ ਅਤੇ ਉਸ ਦੀ ਸਾਰੀ ਸੇਵਾ ਹੋਣ। ");
INSERT INTO pan_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","ਨਾਲ ਹੀ ਵਿਹੜੇ ਦੇ ਆਲੇ-ਦੁਆਲੇ ਦੀਆਂ ਥੰਮ੍ਹੀਆਂ ਅਤੇ ਉਹਨਾਂ ਦੇ ਕਬਜ਼ੇ ਅਤੇ ਉਨ੍ਹਾਂ ਦੀਆਂ ਕੀਲੀਆਂ ਅਤੇ ਉਨ੍ਹਾਂ ਦੀਆਂ ਰੱਸੀਆਂ। ");
INSERT INTO pan_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","ਜਿਹੜੇ ਡੇਰੇ ਦੇ ਸਾਹਮਣੇ ਪੂਰਬ ਵੱਲ ਮਿਲਾਪ ਵਾਲੇ ਤੰਬੂ ਅੱਗੇ ਚੜ੍ਹਦੇ ਪਾਸੇ ਆਪਣੇ ਤੰਬੂ ਲਾਉਣ, ਉਹ ਮੂਸਾ, ਹਾਰੂਨ ਅਤੇ ਉਹ ਦੇ ਪੁੱਤਰ ਹੋਣ। ਉਹ ਪਵਿੱਤਰ ਸਥਾਨ ਦੀ ਉਸ ਜ਼ਿੰਮੇਵਾਰੀ ਦੀ ਸੰਭਾਲ ਕਰਨ ਵਾਲੇ ਹੋਣ ਜਿਹੜੀ ਇਸਰਾਏਲੀਆਂ ਲਈ ਜ਼ਿੰਮੇਵਾਰੀ ਹੈ। ਪਰ ਜੇ ਕੋਈ ਅਜਨਬੀ ਨੇੜੇ ਆਵੇ ਤਾਂ ਉਹ ਮਾਰਿਆ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","ਲੇਵੀਆਂ ਦੀ ਸਾਰੀ ਗਿਣਤੀ ਜਿਹੜੀ ਮੂਸਾ ਅਤੇ ਹਾਰੂਨ ਨੇ ਯਹੋਵਾਹ ਦੇ ਹੁਕਮ ਤੇ ਕੀਤੀ, ਉਨ੍ਹਾਂ ਦੇ ਟੱਬਰਾਂ ਅਨੁਸਾਰ ਅਰਥਾਤ ਸਾਰੇ ਪੁਰਖ ਜਿਹੜੇ ਇੱਕ ਮਹੀਨੇ ਜਾਂ ਇਸ ਤੋਂ ਉੱਪਰ ਦੇ ਸਨ ਬਾਈ ਹਜ਼ਾਰ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","ਫੇਰ ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਆਖਿਆ ਕਿ ਇਸਰਾਏਲੀਆਂ ਦੇ ਸਾਰੇ ਪਹਿਲੌਠੇ ਪੁਰਖ ਗਿਣ, ਜਿਹੜੇ ਇੱਕ ਮਹੀਨੇ ਜਾਂ ਇਸ ਤੋਂ ਉੱਪਰ ਦੇ ਹਨ ਅਤੇ ਉਨ੍ਹਾਂ ਦੇ ਨਾਮਾਂ ਦੀ ਗਿਣਤੀ ਕਰ। ");
INSERT INTO pan_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","ਤੂੰ ਮੇਰੇ ਲਈ ਸਾਰੇ ਇਸਰਾਏਲੀਆਂ ਦੇ ਸਾਰੇ ਪਹਿਲੌਠਿਆਂ ਦੇ ਥਾਂ ਲੇਵੀਆਂ ਨੂੰ, ਇਸਰਾਏਲੀਆਂ ਦੇ ਡੰਗਰਾਂ ਦੇ ਪਹਿਲੌਠਿਆਂ ਦੀ ਥਾਂ ਲੇਵੀਆਂ ਦੇ ਡੰਗਰਾਂ ਨੂੰ ਲੈ ਲਈਂ। ਮੈਂ ਯਹੋਵਾਹ ਹਾਂ। ");
INSERT INTO pan_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","ਜਿਵੇਂ ਯਹੋਵਾਹ ਨੇ ਉਹ ਨੂੰ ਹੁਕਮ ਦਿੱਤਾ ਸੀ ਮੂਸਾ ਨੇ ਇਸਰਾਏਲੀਆਂ ਦੇ ਸਾਰੇ ਪਹਿਲੌਠੇ ਗਿਣੇ। ");
INSERT INTO pan_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","ਅਤੇ ਸਾਰੇ ਪੁਰਖ ਪਹਿਲੌਠਿਆਂ ਦੇ ਨਾਮ ਦੀ ਗਿਣਤੀ ਜਿਹੜੇ ਇੱਕ ਮਹੀਨੇ ਜਾਂ ਇਸ ਤੋਂ ਉੱਪਰ ਦੇ ਸਨ, ਬਾਈ ਹਜ਼ਾਰ ਦੋ ਸੌ ਤਿਹੱਤਰ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਆਖਿਆ, ");
INSERT INTO pan_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","ਇਸ ਤਰ੍ਹਾਂ ਲੇਵੀਆਂ ਨੂੰ ਇਸਰਾਏਲੀਆਂ ਦੇ ਸਾਰੇ ਪਹਿਲੌਠਿਆਂ ਦੇ ਥਾਂ ਅਤੇ ਲੇਵੀਆਂ ਦੇ ਡੰਗਰਾਂ ਨੂੰ ਉਨ੍ਹਾਂ ਦੇ ਡੰਗਰਾਂ ਦੇ ਥਾਂ ਲੈ ਲਈਂ ਅਤੇ ਇਸ ਤਰ੍ਹਾਂ ਲੇਵੀ ਮੇਰੇ ਲਈ ਹੋਣਗੇ। ਮੈਂ ਯਹੋਵਾਹ ਹਾਂ। ");
INSERT INTO pan_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","ਅਤੇ ਉਨ੍ਹਾਂ ਦੋ ਸੌ ਤਿਹੱਤਰ ਇਸਰਾਏਲੀ ਪਹਿਲੌਠਿਆਂ ਦੇ ਛੁਟਕਾਰੇ ਲਈ ਜਿਹੜੇ ਲੇਵੀਆਂ ਤੋਂ ਵਧੀਕ ਹਨ, ");
INSERT INTO pan_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","ਤੂੰ ਪੰਜ-ਪੰਜ ਰੁਪਏ ਹਰੇਕ ਪੁਰਖ ਦੇ ਲਈ ਪਵਿੱਤਰ ਸਥਾਨ ਦੇ ਸ਼ਕੇਲ ਅਨੁਸਾਰ ਲਵੀਂ (ਅਰਥਾਤ ਇੱਕ ਸ਼ਕੇਲ ਵੀਹ ਗੇਰਾਹ ਦਾ ਹੋਵੇ) ");
INSERT INTO pan_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","ਤੂੰ ਉਹ ਚਾਂਦੀ ਹਾਰੂਨ ਅਤੇ ਉਹ ਦੇ ਪੁੱਤਰਾਂ ਨੂੰ ਦੇਈਂ। ਉਹ ਉਨ੍ਹਾਂ ਦੇ ਛੁਟਕਾਰੇ ਲਈ ਹੋਵੇ ਜਿਹੜੇ ਉਨ੍ਹਾਂ ਤੋਂ ਵਧੀਕ ਹਨ। ");
INSERT INTO pan_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","ਉਪਰੰਤ ਮੂਸਾ ਨੇ ਛੁਟਕਾਰੇ ਦੀ ਚਾਂਦੀ ਉਨ੍ਹਾਂ ਤੋਂ ਲਈ, ਜਿਹੜੇ ਲੇਵੀਆਂ ਦੇ ਛੁਡਾਏ ਹੋਇਆਂ ਤੋਂ ਵਧੀਕ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","ਇਸਰਾਏਲ ਦੇ ਪਹਿਲੌਠਿਆਂ ਤੋਂ ਉਸ ਨੇ ਇਹ ਚਾਂਦੀ ਲਈ, ਇੱਕ ਹਜ਼ਾਰ ਤਿੰਨ ਸੌ ਪੈਂਹਠ ਰੁਪਏ ਪਵਿੱਤਰ ਸਥਾਨ ਦੇ ਸ਼ਕੇਲ ਅਨੁਸਾਰ ਵਸੂਲ ਕੀਤੇ। ");
INSERT INTO pan_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","ਮੂਸਾ ਨੇ ਛੁਡਾਏ ਹੋਇਆਂ ਦੀ ਚਾਂਦੀ, ਹਾਰੂਨ ਅਤੇ ਉਸ ਦੇ ਪੁੱਤਰਾਂ ਨੂੰ ਯਹੋਵਾਹ ਦੇ ਆਖੇ ਅਨੁਸਾਰ ਦਿੱਤੀ ਜਿਵੇਂ ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਹੁਕਮ ਦਿੱਤਾ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","ਯਹੋਵਾਹ ਮੂਸਾ ਅਤੇ ਹਾਰੂਨ ਨੂੰ ਬੋਲਿਆ, ");
INSERT INTO pan_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","ਲੇਵੀਆਂ ਦੇ ਵਿੱਚੋਂ ਕਹਾਥੀਆਂ ਦੀ ਉਨ੍ਹਾਂ ਦੇ ਟੱਬਰਾਂ ਅਤੇ ਉਨ੍ਹਾਂ ਦੇ ਪੁਰਖਿਆਂ ਦੇ ਘਰਾਣਿਆਂ ਅਨੁਸਾਰ ਗਿਣਤੀ ਕਰੋ। ");
INSERT INTO pan_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","ਤੀਹ ਸਾਲ ਤੋਂ ਪੰਜਾਹ ਸਾਲ ਤੱਕ ਸਾਰੇ ਜਿਹੜੇ ਸੇਵਾ ਕਰਨ ਯੋਗ ਹੋਣ, ਉਹ ਮਿਲਾਪ ਵਾਲੇ ਤੰਬੂ ਦੀ ਟਹਿਲ ਸੇਵਾ ਕਰਨ। ");
INSERT INTO pan_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","ਕਹਾਥੀਆਂ ਦੀ ਸੇਵਾ ਮਿਲਾਪ ਵਾਲੇ ਤੰਬੂ ਵਿੱਚ ਅੱਤ ਪਵਿੱਤਰ ਚੀਜ਼ਾਂ ਵਿਖੇ ਇਹ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","ਹਾਰੂਨ ਅਤੇ ਉਸ ਦੇ ਪੁੱਤਰ ਕੂਚ ਦੇ ਵੇਲੇ ਅੰਦਰ ਜਾਣ ਅਤੇ ਪਵਿੱਤਰ ਸਥਾਨ ਅਤੇ ਅੱਤ ਪਵਿੱਤਰ ਸਥਾਨ ਦਾ ਪਰਦਾ ਲਾਹੁਣ ਅਤੇ ਉਸ ਵਿੱਚ ਸਾਖੀ ਦੇ ਸੰਦੂਕ ਨੂੰ ਲਪੇਟਣ। ");
INSERT INTO pan_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","ਨਾਲੇ ਸਮੁੰਦਰੀ ਜੀਵ ਦੀਆਂ ਖੱਲਾਂ ਦਾ ਪਰਦਾ ਉਸ ਉੱਤੇ ਰੱਖਣ ਅਤੇ ਉਸ ਉੱਤੇ ਨੀਲੇ ਰੰਗ ਦਾ ਕੱਪੜਾ ਵਿਛਾਉਣ ਅਤੇ ਉਸ ਦੇ ਡੰਡੇ ਪਾਉਣ। ");
INSERT INTO pan_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","ਫੇਰ ਹਜ਼ੂਰੀ ਦੀ ਰੋਟੀ ਦੀ ਮੇਜ਼ ਉੱਤੇ ਨੀਲਾ ਕੱਪੜਾ ਵਿਛਾਉਣ ਅਤੇ ਉਸ ਉੱਤੇ ਥਾਲੀਆਂ, ਕੌਲੀਆਂ, ਗੜ੍ਹਵੇ ਅਤੇ ਭੇਟਾਂ ਵਰਤਾਉਣ ਵਾਲੇ ਕੜਛੇ ਰੱਖਣ ਅਤੇ ਸਦਾ ਕਾਲ ਦੀ ਰੋਟੀ ਉਸ ਉੱਤੇ ਪਈ ਰਹੇ। ");
INSERT INTO pan_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","ਉਨ੍ਹਾਂ ਦੇ ਉੱਤੇ ਕਿਰਮਚੀ ਕੱਪੜੇ ਵਿਛਾਉਣ ਅਤੇ ਉਸ ਨੂੰ ਸਮੁੰਦਰੀ ਜੀਵ ਦੀਆਂ ਖੱਲਾਂ ਦੇ ਨਾਲ ਕੱਜਣ ਅਤੇ ਉਸ ਦੀਆਂ ਚੋਬਾਂ ਪਾਉਣ। ");
INSERT INTO pan_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","ਫੇਰ ਉਹ ਨੀਲਾ ਕੱਪੜਾ ਲੈ ਕੇ ਚਾਨਣ ਦੇਣ ਵਾਲਾ ਸ਼ਮਾਦਾਨ ਢੱਕਣ ਨਾਲੇ ਉਸ ਦੇ ਦੀਵੇ, ਉਸ ਦੇ ਗੁਲਤਰਾਸ਼, ਉਸ ਦੇ ਗੁਲਦਾਨ ਅਤੇ ਉਸ ਦੇ ਸਾਰੇ ਤੇਲ ਵਾਲੇ ਭਾਂਡੇ ਜਿਨ੍ਹਾਂ ਨਾਲ ਉਹ ਉਸ ਦੀ ਸੇਵਾ ਕਰਦੇ ਹਨ। ");
INSERT INTO pan_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","ਤਦ ਉਸ ਦੇ ਸਾਰੇ ਸਮਾਨ ਸਮੇਤ ਸਮੁੰਦਰੀ ਜੀਵ ਦੀਆਂ ਖੱਲਾਂ ਦੇ ਵਿੱਚ ਰੱਖਣ ਅਤੇ ਉਹ ਉਸ ਨੂੰ ਚੋਬਾਂ ਉੱਤੇ ਧਰਨ। ");
INSERT INTO pan_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","ਸੋਨੇ ਦੀ ਜਗਵੇਦੀ ਉੱਤੇ ਨੀਲਾ ਕੱਪੜਾ ਵਿਛਾਉਣ ਅਤੇ ਉਸ ਨੂੰ ਬੱਕਰਿਆਂ ਦੀਆਂ ਖੱਲਾਂ ਦੇ ਢੱਕਣ ਨਾਲ ਢੱਕ ਦੇਣ ਅਤੇ ਉਸ ਦੇ ਡੰਡੇ ਪਾਉਣ। ");
INSERT INTO pan_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","ਫੇਰ ਉਹ ਉਪਾਸਨਾ ਦੀ ਸੇਵਾ ਦੇ ਸਾਰੇ ਭਾਂਡੇ, ਜਿਨ੍ਹਾਂ ਨਾਲ ਉਹ ਪਵਿੱਤਰ ਸਥਾਨ ਵਿੱਚ ਉਪਾਸਨਾ ਕਰਦੇ ਹਨ ਲੈ ਕੇ ਨੀਲੇ ਕੱਪੜੇ ਵਿੱਚ ਪਾਉਣ ਅਤੇ ਉਨ੍ਹਾਂ ਨੂੰ ਸਮੁੰਦਰੀ ਜੀਵ ਦੀਆਂ ਖੱਲਾਂ ਦੇ ਵਿੱਚ ਕੱਜਣ ਅਤੇ ਉਨ੍ਹਾਂ ਨੂੰ ਡੰਡੇ ਉੱਤੇ ਰੱਖਣ। ");
INSERT INTO pan_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","ਤਦ ਉਹ ਜਗਵੇਦੀ ਦੀ ਸੁਆਹ ਕੱਢ ਕੇ ਉਸ ਉੱਤੇ ਬੈਂਗਣੀ ਕੱਪੜਾ ਵਿਛਾਉਣ। ");
INSERT INTO pan_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","ਅਤੇ ਉਸ ਉੱਤੇ ਸਾਰੇ ਭਾਂਡੇ ਰੱਖਣ ਜਿਨ੍ਹਾਂ ਨਾਲ ਉਹ ਉਸ ਉੱਤੇ ਉਪਾਸਨਾ ਕਰਦੇ ਹਨ ਅਰਥਾਤ ਅੰਗੀਠੀਆਂ, ਕਾਂਟੇ, ਕੜਛੇ, ਬਾਟੀਆਂ ਅਤੇ ਜਗਵੇਦੀ ਦਾ ਸਾਰਾ ਸਮਾਨ ਅਤੇ ਉਹ ਦੇ ਉੱਤੇ ਬੱਕਰਿਆਂ ਦੀਆਂ ਖੱਲਾਂ ਵਿਛਾਉਣ ਅਤੇ ਉਸ ਦੀਆਂ ਚੋਬਾਂ ਪਾਉਣ। ");
INSERT INTO pan_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","ਜਦ ਹਾਰੂਨ ਅਤੇ ਉਸ ਦੇ ਪੁੱਤਰ ਪਵਿੱਤਰ ਸਥਾਨ ਅਤੇ ਉਸ ਦੇ ਸਾਰੇ ਸਮਾਨ ਨੂੰ ਢੱਕਣ ਦਾ ਕੰਮ ਕਰ ਚੁੱਕਣ ਅਤੇ ਜਦ ਡੇਰੇ ਦਾ ਕੂਚ ਹੋਣ ਵਾਲਾ ਹੋਵੇ, ਉਦੋਂ ਹੀ ਕਹਾਥੀ ਆਣ ਕੇ ਉਹ ਨੂੰ ਚੁੱਕਣ ਪਰ ਉਹ ਕਿਸੇ ਪਵਿੱਤਰ ਵਸਤੂ ਨੂੰ ਨਾ ਛੂਹਣ ਅਜਿਹਾ ਨਾ ਹੋਵੇ ਕਿ ਉਹ ਮਰ ਜਾਣ! ਮੰਡਲੀ ਦੇ ਤੰਬੂ ਵਿੱਚੋਂ ਕਹਾਥੀਆਂ ਲਈ ਇਹ ਭਾਰ ਉਠਾਉਣ ਲਈ ਇਹ ਹੀ ਵਸਤਾਂ ਹਨ। ");
INSERT INTO pan_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","ਹਾਰੂਨ ਜਾਜਕ ਦੇ ਪੁੱਤਰ ਅਲਆਜ਼ਾਰ ਦੀ ਇਹ ਜ਼ਿੰਮੇਵਾਰੀ ਹੈ ਕਿ ਚਾਨਣ ਕਰਨ ਲਈ ਤੇਲ, ਸੁਗੰਧੀ ਧੂਪ, ਸਦਾ ਕਾਲ ਦੀ ਮੈਦੇ ਦੀ ਭੇਟ ਅਤੇ ਮਸਹ ਕਰਨ ਦਾ ਤੇਲ ਅਰਥਾਤ ਸਾਰੇ ਡੇਰੇ ਦੀ ਅਤੇ ਜੋ ਕੁਝ ਉਸ ਵਿੱਚ ਹੈ, ਅਤੇ ਪਵਿੱਤਰ ਸਥਾਨ ਅਤੇ ਉਸ ਦੇ ਸਮਾਨ ਦੀ ਦੇਖਭਾਲ ਕਰੇ। ");
INSERT INTO pan_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","ਫੇਰ ਯਹੋਵਾਹ ਮੂਸਾ ਅਤੇ ਹਾਰੂਨ ਨੂੰ ਬੋਲਿਆ, ");
INSERT INTO pan_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","ਤੁਸੀਂ ਕਹਾਥੀਆਂ ਦੇ ਟੱਬਰਾਂ ਦੇ ਗੋਤਾਂ ਨੂੰ ਲੇਵੀਆਂ ਦੇ ਵਿੱਚੋਂ ਨਾਸ ਨਾ ਹੋਣ ਦੇਣਾ। ");
INSERT INTO pan_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","ਪਰ ਤੁਸੀਂ ਉਨ੍ਹਾਂ ਲਈ ਇਹ ਕਰੋ ਜਦ ਉਹ ਅੱਤ ਪਵਿੱਤਰ ਚੀਜ਼ਾਂ ਕੋਲ ਜਾਣ ਤਦ ਉਹ ਨਾ ਮਰਨ ਪਰ ਜੀਉਂਦੇ ਰਹਿਣ। ਤਦ ਹਾਰੂਨ ਅਤੇ ਉਸ ਦੇ ਪੁੱਤਰ ਅੰਦਰ ਜਾ ਕੇ ਉਨ੍ਹਾਂ ਦੇ ਹਰ ਇੱਕ ਮਨੁੱਖ ਲਈ ਉਸ ਦੀ ਟਹਿਲ ਸੇਵਾ ਅਤੇ ਉਹਨਾਂ ਦਾ ਭਾਰ ਠਹਿਰਾਉਣ। ");
INSERT INTO pan_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","ਉਹ ਇੱਕ ਪਲ ਲਈ ਵੀ ਅੰਦਰ ਜਾ ਕੇ ਪਵਿੱਤਰ ਸਥਾਨ ਨੂੰ ਨਾ ਵੇਖਣ ਕਿਤੇ ਅਜਿਹਾ ਨਾ ਹੋਵੇ ਕਿ ਉਹ ਮਰ ਜਾਣ। ");
INSERT INTO pan_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਆਖਿਆ, ");
INSERT INTO pan_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","ਗੇਰਸ਼ੋਨੀਆਂ ਦੀ ਵੀ ਉਨ੍ਹਾਂ ਦੇ ਪੁਰਖਿਆਂ ਦੇ ਘਰਾਣਿਆਂ ਅਤੇ ਟੱਬਰਾਂ ਅਨੁਸਾਰ ਗਿਣਤੀ ਕਰ। ");
INSERT INTO pan_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","ਤੀਹ ਸਾਲ ਤੋਂ ਉੱਪਰ ਪੰਜਾਹ ਸਾਲ ਤੱਕ ਤੂੰ ਉਨ੍ਹਾਂ ਨੂੰ ਗਿਣ, ਉਹ ਸਾਰੇ ਜਿਹੜੇ ਟਹਿਲ ਸੇਵਾ ਕਰਨ ਯੋਗ ਹੋਣ ਤਾਂ ਜੋ ਉਹ ਮੰਡਲੀ ਦੇ ਤੰਬੂ ਦੀ ਟਹਿਲ ਸੇਵਾ ਕਰਨ। ");
INSERT INTO pan_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","ਗੇਰਸ਼ੋਨੀਆਂ ਦੇ ਟੱਬਰਾਂ ਦੀ ਟਹਿਲ ਸੇਵਾ ਅਰਥਾਤ ਭਾਰ ਚੁੱਕਣ ਦੀ ਟਹਿਲ ਸੇਵਾ ਇਹ ਹੈ, ");
INSERT INTO pan_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","ਉਹ ਡੇਰੇ ਦੇ ਪਰਦਿਆਂ ਨੂੰ ਚੁੱਕਣ ਨਾਲੇ ਮੰਡਲੀ ਦਾ ਤੰਬੂ, ਉਸ ਦੇ ਢੱਕਣ ਸਣੇ ਅਤੇ ਸਮੁੰਦਰੀ ਜੀਵ ਦੀਆਂ ਖੱਲਾਂ ਦਾ ਢੱਕਣ ਜਿਹੜਾ ਉਸ ਉੱਤੇ ਹੈ ਅਤੇ ਮੰਡਲੀ ਦੇ ਤੰਬੂ ਦੇ ਦਰਵਾਜ਼ੇ ਦਾ ਪਰਦਾ। ");
INSERT INTO pan_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","ਅਤੇ ਵਿਹੜੇ ਦੀਆਂ ਕਨਾਤਾਂ ਤੇ ਵਿਹੜੇ ਦੇ ਫਾਟਕ ਦੇ ਦਰਵਾਜ਼ੇ ਦਾ ਪਰਦਾ ਜਿਹੜੀ ਡੇਰੇ ਅਤੇ ਜਗਵੇਦੀ ਦੇ ਕੋਲ ਆਲੇ-ਦੁਆਲੇ ਹੈ ਅਤੇ ਉਨ੍ਹਾਂ ਦੀਆਂ ਡੋਰੀਆਂ ਅਤੇ ਉਨ੍ਹਾਂ ਦੀ ਸੇਵਾ ਦਾ ਸਾਰਾ ਸਮਾਨ ਅਤੇ ਸਭ ਕੁਝ ਜੋ ਉਨ੍ਹਾਂ ਲਈ ਕਰਨਾ ਹੋਵੇ ਸੋ ਉਹ ਇਹ ਟਹਿਲ ਸੇਵਾ ਕਰਨ। ");
INSERT INTO pan_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","ਇਸ ਤਰ੍ਹਾਂ ਹਾਰੂਨ ਅਤੇ ਉਸ ਦੇ ਪੁੱਤਰਾਂ ਦੇ ਹੁਕਮ ਨਾਲ ਗੇਰਸ਼ੋਨੀਆਂ ਦੀ ਸਾਰੀ ਟਹਿਲ ਸੇਵਾ ਹੋਵੇ ਅਰਥਾਤ ਉਨ੍ਹਾਂ ਦਾ ਸਾਰਾ ਭਾਰ ਅਤੇ ਟਹਿਲ ਸੇਵਾ। ਇਸ ਤਰ੍ਹਾਂ ਤੁਸੀਂ ਉਨ੍ਹਾਂ ਉੱਤੇ ਉਨ੍ਹਾਂ ਦੇ ਸਾਰੇ ਕੰਮਾਂ ਦੀ ਜ਼ਿੰਮੇਵਾਰੀ ਠਹਿਰਾਓ। ");
INSERT INTO pan_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","ਮੰਡਲੀ ਦੇ ਤੰਬੂ ਵਿੱਚ ਇਹ ਗੇਰਸ਼ੋਨੀਆਂ ਦੇ ਟੱਬਰਾਂ ਦੀ ਟਹਿਲ ਸੇਵਾ ਹੋਵੇਗੀ ਅਤੇ ਹਾਰੂਨ ਜਾਜਕ ਦੇ ਪੁੱਤਰ ਈਥਾਮਾਰ ਦੇ ਇਖ਼ਤਿਆਰ ਵਿੱਚ ਉਨ੍ਹਾਂ ਦੀ ਦੇਖਭਾਲ ਹੋਵੇਗੀ। ");
INSERT INTO pan_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","ਮਰਾਰੀਆਂ ਨੂੰ ਉਨ੍ਹਾਂ ਦੇ ਟੱਬਰਾਂ ਅਤੇ ਉਨ੍ਹਾਂ ਦੇ ਪੁਰਖਿਆਂ ਦੇ ਘਰਾਣਿਆਂ ਅਨੁਸਾਰ ਗਿਣਤੀ ਕਰਨਾ। ");
INSERT INTO pan_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","ਤੀਹ ਸਾਲ ਤੋਂ ਉੱਪਰ ਪੰਜਾਹ ਸਾਲ ਤੱਕ ਤੂੰ ਉਹਨਾਂ ਨੂੰ ਗਿਣ, ਉਹ ਸਾਰੇ ਜਿਹੜੇ ਟਹਿਲ ਸੇਵਾ ਕਰਨ ਯੋਗ ਹੋਣ ਤਾਂ ਜੋ ਉਹ ਮੰਡਲੀ ਦੇ ਤੰਬੂ ਦੀ ਟਹਿਲ ਸੇਵਾ ਕਰਨ। ");
INSERT INTO pan_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","ਭਾਰਾਂ ਲਈ ਮੰਡਲੀ ਦੇ ਤੰਬੂ ਵਿੱਚ ਉਨ੍ਹਾਂ ਦੀ ਸਾਰੀ ਜ਼ਿੰਮੇਵਾਰੀ ਇਹ ਹੈ, ਡੇਰੇ ਦੀਆਂ ਫੱਟੀਆਂ, ਉਸ ਦੇ ਹੋੜੇ, ਉਸ ਦੀਆਂ ਥੰਮ੍ਹੀਆਂ, ਉਸ ਦੀਆਂ ਚੀਥੀਆਂ। ");
INSERT INTO pan_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","ਨਾਲੇ ਵਿਹੜੇ ਦੇ ਆਲੇ-ਦੁਆਲੇ ਦੀਆਂ ਥੰਮ੍ਹੀਆਂ, ਉਨ੍ਹਾਂ ਦੀਆਂ ਚੀਥੀਆਂ, ਉਨ੍ਹਾਂ ਦੀਆਂ ਕੀਲੀਆਂ, ਉਨ੍ਹਾਂ ਦੀਆਂ ਡੋਰੀਆਂ, ਉਨ੍ਹਾਂ ਦਾ ਸਾਰਾ ਸਮਾਨ ਅਤੇ ਉਨ੍ਹਾਂ ਦੀ ਸਾਰੀ ਟਹਿਲ ਸੇਵਾ। ਤੁਸੀਂ ਨਾਮਾਂ ਅਨੁਸਾਰ ਸਮਾਨ ਚੁੱਕਣ ਲਈ ਉਹਨਾਂ ਦੀ ਜ਼ਿੰਮੇਵਾਰੀ ਠਹਿਰਾਓ। ");
INSERT INTO pan_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","ਇਹ ਮਰਾਰੀਆਂ ਦੇ ਟੱਬਰਾਂ ਦੀ ਟਹਿਲ ਸੇਵਾ ਮੰਡਲੀ ਦੇ ਤੰਬੂ ਵਿੱਚ ਉਨ੍ਹਾਂ ਦੀ ਸਾਰੀ ਟਹਿਲ ਸੇਵਾ ਅਨੁਸਾਰ ਹੋਵੇ ਅਤੇ ਹਾਰੂਨ ਜਾਜਕ ਦੇ ਪੁੱਤਰ ਈਥਾਮਾਰ ਦੇ ਹੱਥ ਵਿੱਚ ਹੋਵੇ। ");
INSERT INTO pan_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","ਫੇਰ ਮੂਸਾ ਅਤੇ ਹਾਰੂਨ ਅਤੇ ਮੰਡਲੀ ਦੇ ਪ੍ਰਧਾਨਾਂ ਨੇ ਕਹਾਥੀਆਂ ਨੇ ਉਨ੍ਹਾਂ ਦੇ ਟੱਬਰਾਂ ਅਤੇ ਉਨ੍ਹਾਂ ਦੇ ਪੁਰਖਿਆਂ ਦੇ ਘਰਾਣਿਆਂ ਅਨੁਸਾਰ ਗਿਣਿਆ। ");
INSERT INTO pan_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","ਤੀਹ ਸਾਲ ਤੋਂ ਉੱਪਰ ਪੰਜਾਹ ਸਾਲ ਤੱਕ ਸਾਰੇ ਜਿਹੜੇ ਸੇਵਾ ਕਰਨ ਯੋਗ ਹੋਣ ਉਹ ਮੰਡਲੀ ਦੇ ਤੰਬੂ ਦੀ ਟਹਿਲ ਸੇਵਾ ਕਰਨ। ");
INSERT INTO pan_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","ਇਹ ਉਹ ਹਨ ਜਿਹੜੇ ਆਪਣੇ ਘਰਾਣਿਆਂ ਅਨੁਸਾਰ ਗਿਣੇ ਗਏ, ਦੋ ਹਜ਼ਾਰ ਸੱਤ ਸੌ ਪੰਜਾਹ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","ਕਹਾਥੀਆਂ ਦੇ ਟੱਬਰਾਂ ਦੇ ਜਿਹੜੇ ਗਿਣੇ ਗਏ ਏਹੋ ਹੀ ਸਨ ਅਰਥਾਤ ਸਾਰੇ ਜਿਹੜੇ ਮੰਡਲੀ ਦੇ ਤੰਬੂ ਵਿੱਚ ਟਹਿਲ ਸੇਵਾ ਕਰਦੇ ਸਨ ਜਿਨ੍ਹਾਂ ਨੂੰ ਮੂਸਾ ਅਤੇ ਹਾਰੂਨ ਨੇ ਯਹੋਵਾਹ ਦੇ ਹੁਕਮ ਨਾਲ ਮੂਸਾ ਦੇ ਰਾਹੀਂ ਗਿਣਿਆ। ");
INSERT INTO pan_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","ਗੇਰਸ਼ੋਨੀ ਜਿਹੜੇ ਆਪਣੇ ਟੱਬਰਾਂ ਅਤੇ ਆਪਣੇ ਪੁਰਖਿਆਂ ਦੇ ਘਰਾਣਿਆਂ ਅਨੁਸਾਰ ਗਿਣੇ ਗਏ। ");
INSERT INTO pan_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","ਤੀਹ ਸਾਲ ਤੋਂ ਉੱਪਰ ਪੰਜਾਹ ਸਾਲ ਤੱਕ ਸਾਰੇ ਜਿਹੜੇ ਸੇਵਾ ਕਰਨ ਯੋਗ ਹੋਣ ਕਿ ਉਹ ਮੰਡਲੀ ਦੇ ਤੰਬੂ ਵਿੱਚ ਟਹਿਲ ਸੇਵਾ ਕਰਨ। ");
INSERT INTO pan_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","ਅਤੇ ਉਹ ਜਿਹੜੇ ਉਨ੍ਹਾਂ ਦੇ ਟੱਬਰਾਂ ਅਤੇ ਉਨ੍ਹਾਂ ਦੇ ਪੁਰਖਿਆਂ ਦੇ ਘਰਾਣਿਆਂ ਅਨੁਸਾਰ ਗਿਣੇ ਗਏ ਦੋ ਹਜ਼ਾਰ ਛੇ ਸੌ ਤੀਹ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","ਗੇਰਸ਼ੋਨੀਆਂ ਦੇ ਟੱਬਰਾਂ ਦੇ ਜਿਹੜੇ ਗਿਣੇ ਗਏ ਏਹੋ ਹੀ ਸਨ ਅਰਥਾਤ ਸਾਰੇ ਜਿਹੜੇ ਮੰਡਲੀ ਦੇ ਤੰਬੂ ਵਿੱਚ ਟਹਿਲ ਸੇਵਾ ਕਰਨ ਜਿਨ੍ਹਾਂ ਨੂੰ ਮੂਸਾ ਅਤੇ ਹਾਰੂਨ ਨੇ ਯਹੋਵਾਹ ਦੇ ਹੁਕਮ ਨਾਲ ਗਿਣਿਆ। ");
INSERT INTO pan_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","ਮਰਾਰੀਆਂ ਦੇ ਟੱਬਰਾਂ ਦੇ ਜਿਹੜੇ ਆਪਣੇ ਟੱਬਰਾਂ ਅਤੇ ਆਪਣੇ ਪੁਰਖਿਆਂ ਦੇ ਘਰਾਣਿਆਂ ਅਨੁਸਾਰ ਗਿਣੇ ਗਏ। ");
INSERT INTO pan_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","ਤੀਹ ਸਾਲ ਤੋਂ ਉੱਪਰ ਪੰਜਾਹ ਸਾਲ ਤੱਕ ਸਾਰੇ ਜਿਹੜੇ ਸੇਵਾ ਕਰਨ ਯੋਗ ਸਨ ਤਾਂ ਜੋ ਉਹ ਮੰਡਲੀ ਦੇ ਤੰਬੂ ਵਿੱਚ ਟਹਿਲ ਸੇਵਾ ਕਰਨ। ");
INSERT INTO pan_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","ਉਹ ਜਿਹੜੇ ਉਨ੍ਹਾਂ ਦੇ ਟੱਬਰਾਂ ਅਨੁਸਾਰ ਗਿਣੇ ਗਏ ਤਿੰਨ ਹਜ਼ਾਰ ਦੋ ਸੌ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","ਮਰਾਰੀਆਂ ਦੇ ਟੱਬਰਾਂ ਦੇ ਜਿਹੜੇ ਗਿਣੇ ਗਏ ਏਹੋ ਹੀ ਸਨ ਜਿਨ੍ਹਾਂ ਨੂੰ ਮੂਸਾ ਅਤੇ ਹਾਰੂਨ ਨੇ ਯਹੋਵਾਹ ਦੇ ਹੁਕਮ ਨਾਲ ਮੂਸਾ ਦੇ ਰਾਹੀਂ ਗਿਣਿਆ। ");
INSERT INTO pan_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","ਸਾਰੇ ਲੇਵੀ ਜਿਹੜੇ ਗਿਣੇ ਗਏ ਜਿਨ੍ਹਾਂ ਨੂੰ ਮੂਸਾ ਅਤੇ ਹਾਰੂਨ ਅਤੇ ਇਸਰਾਏਲ ਦੇ ਪ੍ਰਧਾਨਾਂ ਨੇ ਗਿਣਿਆ ਉਨ੍ਹਾਂ ਦੇ ਟੱਬਰਾਂ ਅਤੇ ਉਨ੍ਹਾਂ ਦੇ ਪੁਰਖਿਆਂ ਦੇ ਘਰਾਣਿਆਂ ਅਨੁਸਾਰ। ");
INSERT INTO pan_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","ਤੀਹ ਸਾਲ ਤੋਂ ਉੱਪਰ ਪੰਜਾਹ ਸਾਲ ਤੱਕ ਸਾਰੇ ਜਿਹੜੇ ਟਹਿਲ ਸੇਵਾ ਕਰਨ ਅਤੇ ਭਾਰ ਚੁੱਕਣ ਲਈ ਮੰਡਲੀ ਦੇ ਤੰਬੂ ਵਿੱਚ ਆਉਣ। ");
INSERT INTO pan_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","ਇਹ ਗਿਣੇ ਗਏ ਅਤੇ ਅੱਠ ਹਜ਼ਾਰ ਪੰਜ ਸੌ ਅੱਸੀ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","ਇਸ ਤਰ੍ਹਾਂ ਯਹੋਵਾਹ ਦੇ ਹੁਕਮ ਨਾਲ ਅਤੇ ਮੂਸਾ ਦੇ ਰਾਹੀਂ ਉਹ ਗਿਣੇ ਗਏ, ਹਰ ਮਨੁੱਖ ਉਸ ਦੀ ਟਹਿਲ ਸੇਵਾ ਅਤੇ ਭਾਰ ਅਨੁਸਾਰ। ਇਸ ਤਰ੍ਹਾਂ ਉਹ ਗਿਣੇ ਗਏ ਜਿਵੇਂ ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਹੁਕਮ ਦਿੱਤਾ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਆਖਿਆ, ");
INSERT INTO pan_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","ਇਸਰਾਏਲੀਆਂ ਨੂੰ ਹੁਕਮ ਦੇ ਕਿ ਉਹ ਡੇਰੇ ਵਿੱਚੋਂ ਸਾਰੇ ਕੋੜ੍ਹੀਆਂ ਨੂੰ ਅਤੇ ਸਾਰੇ ਧਾਂਤ ਵਗਣ ਵਾਲਿਆਂ ਨੂੰ ਅਤੇ ਸਾਰੇ ਜਿਹੜੇ ਲਾਸ਼ਾਂ ਤੋਂ ਅਸ਼ੁੱਧ ਹੋਣ, ");
INSERT INTO pan_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","ਭਾਵੇਂ ਪੁਰਖ ਭਾਵੇਂ ਇਸਤਰੀ ਤੁਸੀਂ ਉਨ੍ਹਾਂ ਨੂੰ ਲੈ ਜਾ ਕੇ ਡੇਰੇ ਤੋਂ ਬਾਹਰ ਕੱਢਿਓ ਤਾਂ ਜੋ ਉਹ ਉਨ੍ਹਾਂ ਦੇ ਡੇਰਿਆਂ ਨੂੰ, ਜਿਨ੍ਹਾਂ ਵਿੱਚ ਮੈਂ ਵੱਸਦਾ ਹਾਂ ਅਸ਼ੁੱਧ ਨਾ ਕਰਨ। ");
INSERT INTO pan_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","ਤਦ ਇਸਰਾਏਲੀਆਂ ਨੇ ਅਜਿਹਾ ਹੀ ਕੀਤਾ ਅਤੇ ਉਨ੍ਹਾਂ ਨੂੰ ਡੇਰੇ ਤੋਂ ਬਾਹਰ ਕੱਢ ਦਿੱਤਾ। ਜਿਵੇਂ ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਆਖਿਆ ਉਸੇ ਤਰ੍ਹਾਂ ਹੀ ਇਸਰਾਏਲੀਆਂ ਨੇ ਕੀਤਾ। ");
INSERT INTO pan_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਆਖਿਆ, ");
INSERT INTO pan_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","ਇਸਰਾਏਲੀਆਂ ਨੂੰ ਬੋਲ ਕਿ ਜਦ ਕੋਈ ਪੁਰਖ ਜਾਂ ਇਸਤਰੀ ਕੋਈ ਪਾਪ ਕਰੇ ਜਿਹੜਾ ਇਨਸਾਨ ਕਰਦਾ ਹੈ ਕਿ ਉਹ ਯਹੋਵਾਹ ਤੋਂ ਬੇਈਮਾਨ ਹੋ ਜਾਵੇ ਅਤੇ ਉਹ ਪ੍ਰਾਣੀ ਦੋਸ਼ੀ ਠਹਿਰੇ, ");
INSERT INTO pan_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","ਤਦ ਉਹ ਆਪਣੇ ਪਾਪ ਦਾ ਇਕਰਾਰ ਕਰੇ ਜਿਹੜਾ ਉਸ ਨੇ ਕੀਤਾ ਹੈ ਅਤੇ ਉਹ ਆਪਣੇ ਦੋਸ਼ ਦੀ ਪੂਰੀ ਕੀਮਤ ਭਰੇ ਅਤੇ ਉਹ ਉਸ ਦੇ ਨਾਲ ਪੰਜਵਾਂ ਹਿੱਸਾ ਵੱਧ ਪਾ ਕੇ ਉਹ ਨੂੰ ਦੇਵੇ ਜਿਸ ਦੇ ਵਿਰੁੱਧ ਉਹ ਦੋਸ਼ੀ ਹੋਇਆ। ");
INSERT INTO pan_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","ਜੇ ਉਸ ਮਨੁੱਖ ਦਾ ਕੋਈ ਨਜ਼ਦੀਕੀ ਰਿਸ਼ਤੇਦਾਰ ਨਾ ਹੋਵੇ ਜਿਸ ਨੂੰ ਉਸ ਦੇ ਦੋਸ਼ ਦਾ ਹਰਜ਼ਾਨਾ ਮੋੜਿਆ ਜਾਵੇ ਤਾਂ ਉਹ ਦੋਸ਼ ਦਾ ਹਰਜ਼ਾਨਾ ਜਿਹੜਾ ਯਹੋਵਾਹ ਦਾ ਹੈ, ਜਾਜਕ ਨੂੰ ਦਿੱਤਾ ਜਾਵੇ ਨਾਲੇ ਪ੍ਰਾਸਚਿਤ ਦਾ ਭੇਡੂ, ਜਿਸ ਦੇ ਨਾਲ ਉਸ ਦਾ ਪ੍ਰਾਸਚਿਤ ਕੀਤਾ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","ਇਸਰਾਏਲੀਆਂ ਦੀਆਂ ਪਵਿੱਤਰ ਚੀਜ਼ਾਂ ਵਿੱਚੋਂ ਜਿਹੜੀਆਂ ਉਹ ਜਾਜਕ ਕੋਲ ਲਿਆਉਣ ਚੁੱਕਣ ਦੀ ਭੇਟ ਉਸੇ ਦੀ ਹੋਵੇਗੀ। ");
INSERT INTO pan_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","ਹਰ ਮਨੁੱਖ ਦੀਆਂ ਪਵਿੱਤਰ ਚੀਜ਼ਾਂ ਉਸ ਦੀਆਂ ਹੋਣ। ਜੋ ਕੁਝ ਕੋਈ ਮਨੁੱਖ ਜਾਜਕ ਨੂੰ ਦੇਵੇ ਉਹ ਉਸਦਾ ਹੋਵੇ। ");
INSERT INTO pan_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਆਖਿਆ, ");
INSERT INTO pan_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","ਇਸਰਾਏਲੀਆਂ ਨਾਲ ਗੱਲ ਕਰ ਅਤੇ ਉਨ੍ਹਾਂ ਨੂੰ ਆਖ ਕਿ ਜਦ ਕਿਸੇ ਮਨੁੱਖ ਦੀ ਪਤਨੀ ਕੁਰਾਹੀ ਹੋ ਜਾਵੇ ਅਤੇ ਉਸ ਨਾਲ ਬੇਈਮਾਨੀ ਕਰੇ। ");
INSERT INTO pan_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","ਜੇ ਕੋਈ ਮਨੁੱਖ ਉਸ ਨਾਲ ਲੇਟੇ ਅਤੇ ਬਦਕਾਰੀ ਕਰੇ, ਭਾਵੇਂ ਇਹ ਗੱਲ ਉਸ ਦੇ ਪਤੀ ਦੀਆਂ ਅੱਖਾਂ ਤੋਂ ਲੁੱਕੀ ਰਹੇ ਅਤੇ ਉਹ ਇਸ ਬਾਰੇ ਨਾ ਜਾਣਦਾ ਹੋਵੇ, ਭਾਵੇਂ ਕੋਈ ਉਸ ਦੇ ਵਿਰੁੱਧ ਗਵਾਹ ਨਾ ਹੋਵੇ ਅਤੇ ਉਹ ਫੜੀ ਨਾ ਗਈ ਹੋਵੇ, ਤਾਂ ਵੀ ਉਹ ਭਰਿਸ਼ਟ ਹੋ ਚੁੱਕੀ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","ਪਰ ਉਸ ਦੇ ਪਤੀ ਦੇ ਮਨ ਵਿੱਚ ਜਲਣ ਪੈਦਾ ਹੋਵੇ ਅਤੇ ਉਹ ਆਪਣੀ ਪਤਨੀ ਨਾਲ ਜਲਣ ਕਰੇ ਕਿਉਂ ਜੋ ਉਹ ਭਰਿਸ਼ਟ ਹੋ ਗਈ, ਜਾਂ ਉਸ ਨਾਲ ਫਿਰ ਵੀ ਜਲਣ ਕਰੇ ਕਿ ਉਹ ਆਪਣੀ ਪਤਨੀ ਨਾਲ ਜਲਣ ਰੱਖੇ ਪਰ ਉਹ ਭਰਿਸ਼ਟ ਨਾ ਹੋਈ ਹੋਵੇ। ");
INSERT INTO pan_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","ਤਦ ਉਹ ਮਨੁੱਖ ਆਪਣੀ ਪਤਨੀ ਨੂੰ ਜਾਜਕ ਕੋਲ ਲਿਆਵੇ ਨਾਲੇ ਉਹ ਉਸ ਦੇ ਲਈ ਏਫ਼ਾਹ ਦਾ ਦਸਵਾਂ ਹਿੱਸਾ, ਜੌਂ ਦੇ ਮੈਦੇ ਦਾ ਚੜ੍ਹਾਵਾ ਲਿਆਵੇ ਪਰ ਉਹ ਉਸ ਦੇ ਉੱਤੇ ਤੇਲ ਨਾ ਡੋਲ੍ਹੇ ਨਾ ਉਸ ਉੱਤੇ ਲੁਬਾਨ ਪਾਵੇ ਕਿਉਂ ਜੋ ਉਹ ਜਲਣ ਦੀ ਭੇਟ ਹੈ, ਉਹ ਯਾਦਗਾਰੀ ਦੀ ਭੇਂਟ ਹੈ ਜਿਹੜੀ ਬੁਰਿਆਈ ਨੂੰ ਚੇਤੇ ਕਰਾਉਂਦੀ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","ਤਦ ਜਾਜਕ ਉਸ ਨੂੰ ਨੇੜੇ ਲਿਆ ਕੇ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਖੜ੍ਹੀ ਕਰੇ। ");
INSERT INTO pan_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","ਫੇਰ ਜਾਜਕ ਪਵਿੱਤਰ ਜਲ ਮਿੱਟੀ ਦੇ ਭਾਂਡੇ ਵਿੱਚ ਲਵੇ ਅਤੇ ਡੇਰੇ ਦੇ ਫ਼ਰਸ਼ ਦੀ ਧੂੜ ਲੈ ਕੇ ਉਸ ਜਲ ਵਿੱਚ ਪਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","ਫੇਰ ਜਾਜਕ ਉਸ ਇਸਤਰੀ ਨੂੰ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਖੜ੍ਹੀ ਕਰੇ ਅਤੇ ਉਸ ਦੇ ਸਿਰ ਦੇ ਵਾਲ਼ ਖੁੱਲ੍ਹੇ ਰਹਿਣ ਦੇਵੇ ਅਤੇ ਉਸ ਦੇ ਹੱਥਾਂ ਉੱਤੇ ਯਾਦਗਾਰੀ ਦੀ ਭੇਟ ਰੱਖੇ ਜਿਹੜੀ ਜਲਣ ਦੀ ਭੇਟ ਵੀ ਹੈ, ਅਤੇ ਜਾਜਕ ਦੇ ਹੱਥ ਵਿੱਚ ਕੁੱੜਤਣ ਦਾ ਜਲ ਹੋਵੇ ਜਿਹੜਾ ਸਰਾਪ ਲਿਆਉਂਦਾ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","ਤਦ ਜਾਜਕ ਉਸ ਨੂੰ ਸਹੁੰ ਦੇਵੇ ਅਤੇ ਇਸਤਰੀ ਨੂੰ ਆਖੇ, ਜੇਕਰ ਕੋਈ ਮਨੁੱਖ ਤੇਰੇ ਸੰਗ ਨਹੀਂ ਲੇਟਿਆ ਅਤੇ ਜੇ ਤੂੰ ਆਪਣੇ ਪਤੀ ਦੀ ਹੋਣ ਵਿੱਚ ਕੁਰਾਹੀ ਹੋ ਕੇ ਭਰਿਸ਼ਟ ਨਹੀਂ ਹੋਈ ਤਾਂ ਤੂੰ ਇਸ ਜਲ ਤੋਂ ਜਿਹੜਾ ਸਰਾਪ ਲਿਆਉਂਦਾ ਹੈ, ਬਚ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","ਪਰੰਤੂ ਜੇ ਤੂੰ ਆਪਣੇ ਪਤੀ ਦੀ ਹੋਣ ਵਿੱਚ ਕੁਰਾਹੀ ਹੋਈ ਅਤੇ ਜੇਕਰ ਆਪਣੇ ਪਤੀ ਤੋਂ ਬਿਨ੍ਹਾਂ ਕਿਸੇ ਹੋਰ ਮਨੁੱਖ ਦੇ ਸੰਗ ਲੇਟ ਕੇ ਭਰਿਸ਼ਟ ਹੋ ਗਈ ਹੈਂ। ");
INSERT INTO pan_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","ਤਦ ਜਾਜਕ ਉਸ ਔਰਤ ਨੂੰ ਸਰਾਪ ਦੀ ਸਹੁੰ ਦੇਵੇ ਅਤੇ ਜਾਜਕ ਉਸ ਔਰਤ ਨੂੰ ਆਖੇ ਕਿ ਯਹੋਵਾਹ ਤੈਨੂੰ ਸਰਾਪ ਅਤੇ ਸਹੁੰ ਲਈ ਤੇਰੇ ਲੋਕਾਂ ਵਿੱਚ ਠਹਿਰਾਵੇ ਅਤੇ ਯਹੋਵਾਹ ਤੇਰੇ ਪੱਟ ਨੂੰ ਸਾੜੇ ਅਤੇ ਤੇਰੇ ਢਿੱਡ ਨੂੰ ਸੁਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","ਇਸ ਤਰ੍ਹਾਂ ਇਹ ਜਲ ਜਿਹੜਾ ਸਰਾਪ ਲਿਆਉਂਦਾ ਹੈ ਤੇਰੇ ਸਰੀਰ ਵਿੱਚ ਜਾ ਕੇ ਤੇਰੇ ਢਿੱਡ ਨੂੰ ਸੁਜਾਵੇ ਅਤੇ ਤੇਰੇ ਪੱਟ ਨੂੰ ਸਾੜੇ ਤਾਂ ਇਸਤਰੀ ਆਖੇ, “ਆਮੀਨ, ਆਮੀਨ।” ");
INSERT INTO pan_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","ਤਦ ਜਾਜਕ ਉਸ ਸਰਾਪ ਨੂੰ ਪੋਥੀ ਵਿੱਚ ਲਿਖ ਲਵੇ ਅਤੇ ਉਸ ਨੂੰ ਕੁੜੱਤਣ ਵਾਲੇ ਜਲ ਵਿੱਚ ਮਿਟਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","ਅਤੇ ਉਹ ਕੁੜੱਤਣ ਵਾਲਾ ਜਲ ਜਿਹੜਾ ਸਰਾਪ ਦਾ ਕਾਰਨ ਹੈ, ਉਸ ਇਸਤਰੀ ਨੂੰ ਪਿਆਵੇ ਅਤੇ ਜਲ ਜਿਹੜਾ ਸਰਾਪ ਦਾ ਕਾਰਨ ਹੈ ਉਸ ਇਸਤਰੀ ਦੇ ਅੰਦਰ ਜਾ ਕੇ ਕੌੜਾ ਹੋ ਜਾਵੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","ਫੇਰ ਜਾਜਕ ਉਸ ਔਰਤ ਦੇ ਹੱਥੋਂ ਜਲਣ ਵਾਲੇ ਮੈਦੇ ਦੀ ਭੇਟ ਲੈ ਕੇ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਉਸ ਮੈਦੇ ਦੀ ਭੇਟ ਨੂੰ ਹਿਲਾਵੇ ਅਤੇ ਉਸ ਨੂੰ ਜਗਵੇਦੀ ਦੇ ਨੇੜੇ ਲਿਆਵੇ। ");
INSERT INTO pan_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","ਜਾਜਕ ਉਸ ਮੈਦੇ ਦੀ ਭੇਟ ਵਿੱਚੋਂ ਯਾਦਗਾਰੀ ਲਈ ਇੱਕ ਮੁੱਠ ਭਰ ਕੇ ਜਗਵੇਦੀ ਉੱਤੇ ਸਾੜੇ ਅਤੇ ਉਸ ਦੇ ਪਿੱਛੋਂ ਉਹ ਜਲ ਉਸ ਔਰਤ ਨੂੰ ਪਿਲਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","ਜਦ ਉਹ ਜਲ ਔਰਤ ਨੂੰ ਪਿਲਾ ਦੇਵੇ ਤਾਂ ਐਉਂ ਹੋਵੇਗਾ ਕਿ ਜੇਕਰ ਔਰਤ ਭਰਿਸ਼ਟੀ ਗਈ ਹੈ ਅਤੇ ਉਸ ਨੇ ਆਪਣੇ ਪਤੀ ਦੇ ਵਿਰੁੱਧ ਦੋਸ਼ ਕੀਤਾ ਹੈ ਤਾਂ ਉਹ ਜਲ ਜਿਹੜਾ ਸਰਾਪ ਦਾ ਕਾਰਨ ਹੈ ਉਸ ਦੇ ਅੰਦਰ ਜਾ ਕੇ ਕੌੜਾ ਹੋ ਜਾਵੇਗਾ ਅਤੇ ਉਸ ਦਾ ਸਰੀਰ ਸੁੱਜ ਜਾਵੇਗਾ ਅਤੇ ਉਸ ਦੀ ਜਾਂਘ ਸੜ ਜਾਵੇਗੀ ਅਤੇ ਉਹ ਆਪਣੇ ਲੋਕਾਂ ਵਿੱਚ ਸਰਾਪਣ ਹੋਵੇਗੀ। ");
INSERT INTO pan_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","ਪਰ ਜੇ ਔਰਤ ਭਰਿਸ਼ਟ ਨਹੀਂ ਹੋਈ ਹੋਵੇ ਸਗੋਂ ਸਾਫ਼ ਰਹੀ ਹੈ ਤਾਂ ਉਹ ਬਚੀ ਰਹੇਗੀ ਅਤੇ ਉਹ ਸੰਤਾਨ ਜਣੇਗੀ। ");
INSERT INTO pan_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","ਇਹ ਬਿਵਸਥਾ ਉਸ ਜਲਣ ਦੀ ਹੈ ਜਦ ਔਰਤ ਆਪਣੇ ਮਨੁੱਖ ਦੀ ਹੋਣ ਵਿੱਚ ਕੁਰਾਹੀ ਹੋ ਕੇ ਹੋਰ ਪਾਸੇ ਚਲੀ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","ਜਦ ਕਿਸੇ ਮਨੁੱਖ ਦਾ ਜਲਣ ਦਾ ਸੁਭਾਅ ਹੋ ਜਾਵੇ ਅਤੇ ਉਸ ਨੂੰ ਆਪਣੀ ਔਰਤ ਦੀ ਜਲਣ ਹੋਵੇ ਤਾਂ ਉਹ ਮਨੁੱਖ ਉਸ ਔਰਤ ਨੂੰ ਯਹੋਵਾਹ ਅੱਗੇ ਖੜ੍ਹੀ ਕਰੇ ਅਤੇ ਜਾਜਕ ਉਸ ਉੱਤੇ ਇਹ ਸਾਰੀ ਬਿਵਸਥਾ ਵਰਤੇ। ");
INSERT INTO pan_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","ਇਸ ਤਰ੍ਹਾਂ ਉਹ ਮਨੁੱਖ ਬਦੀ ਤੋਂ ਬਚਿਆ ਰਹੇ ਪਰ ਉਹ ਔਰਤ ਆਪਣੀ ਬਦੀ ਨੂੰ ਆਪ ਚੁੱਕੇਗੀ। ");
INSERT INTO pan_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਆਖਿਆ, ");
INSERT INTO pan_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","ਇਸਰਾਏਲੀਆਂ ਨਾਲ ਗੱਲ ਕਰ ਅਤੇ ਉਨ੍ਹਾਂ ਨੂੰ ਆਖ ਕਿ ਜਦ ਕੋਈ ਪੁਰਸ਼ ਜਾਂ ਇਸਤਰੀ ਨਜ਼ੀਰ ਦੀ ਖ਼ਾਸ ਸੁੱਖਣਾ ਸੁੱਖੇ ਅਰਥਾਤ ਯਹੋਵਾਹ ਲਈ ਆਪਣੇ ਆਪ ਨੂੰ ਅਰਪਣ ਕਰੇ। ");
INSERT INTO pan_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","ਤਾਂ ਦਾਖ਼ਰਸ ਅਤੇ ਸ਼ਰਾਬ ਤੋਂ ਆਪਣੇ ਆਪ ਨੂੰ ਅੱਡ ਰੱਖੇ। ਉਹ, ਨਾ ਤਾਂ ਦਾਖਰਸ ਦਾ ਸਿਰਕਾ, ਨਾ ਸ਼ਰਾਬ ਦਾ ਸਿਰਕਾ ਪੀਵੇ ਅਤੇ ਉਹ ਕੋਈ ਦਾਖਰਸ ਨਾ ਪੀਵੇ ਨਾ ਕੋਈ ਦਾਖ ਸੁੱਕੀ ਜਾਂ ਤਾਜ਼ਾ ਖਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","ਉਹ ਦੇ ਅਲੱਗ ਹੋਣ ਦੇ ਸਾਰੇ ਦਿਨ ਉਹ ਬੀਜ ਤੋਂ ਲੈ ਕੇ ਛਿਲਕੇ ਤੱਕ ਕੁਝ ਨਾ ਖਾਵੇ ਜਿਹੜਾ ਦਾਖ ਤੋਂ ਬਣਿਆ ਹੋਵੇ। ");
INSERT INTO pan_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","ਉਸ ਦੇ ਅੱਡ ਹੋਣ ਦੀ ਸੁੱਖਣਾ ਦੇ ਸਾਰੇ ਦਿਨ ਕੋਈ ਉਸਤਰਾ ਉਸ ਦੇ ਸਿਰ ਨੂੰ ਨਾ ਲੱਗੇ ਜਦ ਤੱਕ ਉਸ ਦੇ ਦਿਨ ਪੂਰੇ ਨਾ ਹੋਣ ਜਿਨ੍ਹਾਂ ਵਿੱਚ ਉਸ ਨੇ ਯਹੋਵਾਹ ਲਈ ਆਪਣੇ ਆਪ ਨੂੰ ਅੱਡ ਕੀਤਾ, ਉਹ ਪਵਿੱਤਰ ਰਹੇ ਅਤੇ ਆਪਣੇ ਸਿਰ ਦੇ ਵਾਲਾਂ ਦੀਆਂ ਲਟਾਂ ਵਧਣ ਦੇਵੇ। ");
INSERT INTO pan_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","ਯਹੋਵਾਹ ਲਈ ਅੱਡ ਹੋਣ ਦੇ ਸਾਰੇ ਦਿਨ ਤੱਕ ਉਹ ਕਿਸੇ ਵੀ ਲਾਸ਼ ਕੋਲ ਨਾ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","ਉਹ ਆਪਣੇ ਪਿਤਾ, ਮਾਤਾ, ਭਰਾ ਜਾਂ ਭੈਣ ਲਈ, ਜਦ ਉਹ ਮਰ ਜਾਣ ਅਸ਼ੁੱਧ ਨਾ ਹੋ ਜਾਵੇ ਕਿਉਂ ਜੋ ਉਸ ਦੇ ਪਰਮੇਸ਼ੁਰ ਲਈ ਅੱਡ ਹੋਣ ਦੀ ਜ਼ਿੰਮੇਵਾਰੀ ਉਸ ਦੇ ਸਿਰ ਉੱਤੇ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","ਉਸ ਦੇ ਅੱਡ ਹੋਣ ਦੇ ਸਾਰੇ ਦਿਨ ਯਹੋਵਾਹ ਲਈ ਪਵਿੱਤਰ ਹਨ। ");
INSERT INTO pan_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","ਜੇ ਕੋਈ ਉਸ ਦੇ ਕੋਲ ਅਚਾਨਕ ਮਰ ਜਾਵੇ ਅਤੇ ਉਸ ਦੇ ਅੱਡ ਹੋਣ ਦਾ ਸਮਾਂ ਅਸ਼ੁੱਧ ਹੋ ਜਾਵੇ ਤਾਂ ਉਹ ਆਪਣੇ ਸ਼ੁੱਧ ਹੋਣ ਦੇ ਦਿਨ ਆਪਣਾ ਸਿਰ ਮੁਨਾਵੇ, ਸੱਤਵੇਂ ਦਿਨ ਉਹ ਨੂੰ ਮੁਨਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","ਫੇਰ ਅੱਠਵੇਂ ਦਿਨ ਉਹ ਜਾਜਕ ਕੋਲ ਮੰਡਲੀ ਦੇ ਤੰਬੂ ਦੇ ਦਰਵਾਜ਼ੇ ਉੱਤੇ ਦੋ ਘੁੱਗੀਆਂ ਜਾਂ ਦੋ ਕਬੂਤਰ ਦੇ ਬੱਚੇ ਲਿਆਵੇ। ");
INSERT INTO pan_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","ਤਾਂ ਜਾਜਕ ਇੱਕ ਨੂੰ ਪਾਪ ਬਲੀ ਅਤੇ ਦੂਜੇ ਨੂੰ ਹੋਮ ਦੀ ਬਲੀ ਲਈ ਚੜ੍ਹਾਵੇ ਅਤੇ ਇਸ ਤਰ੍ਹਾਂ ਉਹ ਦੇ ਲਈ ਪ੍ਰਾਸਚਿਤ ਕਰੇ ਕਿਉਂ ਜੋ ਉਸ ਨੇ ਉਸ ਲਾਸ਼ ਦੇ ਕਾਰਨ ਪਾਪ ਕੀਤਾ ਤਾਂ ਉਹ ਆਪਣੇ ਸਿਰ ਨੂੰ ਉਸੇ ਦਿਨ ਪਵਿੱਤਰ ਕਰੇ। ");
INSERT INTO pan_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","ਉਹ ਆਪਣੇ ਅੱਡ ਹੋਣ ਦੇ ਦਿਨ ਯਹੋਵਾਹ ਲਈ ਅੱਡ ਰੱਖੇ ਅਤੇ ਉਹ ਇੱਕ ਸਾਲ ਦਾ ਭੇਡ ਦਾ ਬੱਚਾ ਦੋਸ਼ ਦੀ ਭੇਟ ਲਈ ਲਿਆਵੇ ਪਰ ਉਸ ਦੇ ਪਿਛਲੇ ਦਿਨ ਵਿਅਰਥ ਹੋ ਗਏ ਕਿਉਂ ਜੋ ਉਹ ਆਪਣੇ ਅੱਡ ਰਹਿਣ ਦੇ ਸਮੇਂ ਦੌਰਾਨ ਭਰਿਸ਼ਟ ਹੋ ਗਿਆ। ");
INSERT INTO pan_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","ਇਹ ਨਜ਼ੀਰ ਲਈ ਬਿਵਸਥਾ ਹੈ, ਜਿਸ ਦਿਨ ਉਸ ਦੇ ਅੱਡ ਹੋਣ ਦੇ ਦਿਨ ਪੂਰੇ ਹੋਣ ਤਾਂ ਉਹ ਮੰਡਲੀ ਦੇ ਤੰਬੂ ਦੇ ਦਰਵਾਜ਼ੇ ਕੋਲ ਲਿਆਂਦਾ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","ਉਹ ਯਹੋਵਾਹ ਕੋਲ ਆਪਣੀ ਬਲੀ ਲਿਆਵੇ, ਇੱਕ ਸਾਲ ਦਾ ਦੋਸ਼ ਰਹਿਤ ਭੇਡ ਦਾ ਬੱਚਾ ਹੋਮ ਦੀ ਬਲੀ ਲਈ ਅਤੇ ਇੱਕ ਸਾਲ ਦੀ ਦੋਸ਼ ਰਹਿਤ ਲੇਲੀ ਪਾਪ ਬਲੀ ਲਈ ਅਤੇ ਇੱਕ ਦੋਸ਼ ਰਹਿਤ ਭੇਡ ਦਾ ਬੱਚਾ ਸੁੱਖ-ਸਾਂਦ ਦੀ ਬਲੀ ਲਈ ਲਿਆਵੇ। ");
INSERT INTO pan_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","ਨਾਲੇ ਪਤੀਰੀਆਂ ਰੋਟੀਆਂ ਦੀ ਟੋਕਰੀ ਅਤੇ ਮੈਦੇ ਦੇ ਫੁਲਕੇ ਤੇਲ ਨਾਲ ਚੋਪੜੇ ਹੋਏ ਅਤੇ ਪਤੀਰੀਆਂ ਮੱਠੀਆਂ ਤੇਲ ਨਾਲ ਚੋਪੜੀਆਂ ਹੋਈਆਂ ਉਨ੍ਹਾਂ ਦੇ ਮੈਦੇ ਦੀ ਭੇਟ ਅਤੇ ਪੀਣ ਦੀਆਂ ਭੇਟਾਂ ਨਾਲ ਹੋਣ। ");
INSERT INTO pan_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","ਫੇਰ ਜਾਜਕ ਉਨ੍ਹਾਂ ਨੂੰ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਲਿਆਵੇ ਅਤੇ ਉਹ ਦੇ ਪਾਪ ਦੀਆਂ ਅਤੇ ਉਹ ਦੇ ਹੋਮ ਦੀਆਂ ਬਲੀਆਂ ਚੜ੍ਹਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","ਅਤੇ ਉਸ ਭੇਡ ਦੇ ਬੱਚੇ ਨੂੰ ਪਤੀਰੀਆਂ ਰੋਟੀਆਂ ਦੇ ਛਾਬੇ ਸਮੇਤ ਸੁੱਖ-ਸਾਂਦ ਦੀ ਬਲੀ ਲਈ ਯਹੋਵਾਹ ਨੂੰ ਚੜ੍ਹਾਵੇ ਅਤੇ ਜਾਜਕ ਉਸ ਦੇ ਮੈਦੇ ਦੀ ਭੇਟ ਅਤੇ ਪੀਣ ਦੀ ਭੇਟ ਚੜ੍ਹਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","ਤਾਂ ਨਜ਼ੀਰ ਮੰਡਲੀ ਦੇ ਤੰਬੂ ਦੇ ਦਰਵਾਜ਼ੇ ਕੋਲ ਆਪਣੇ ਅੱਡ ਹੋਣ ਦਾ ਸਿਰ ਮੁਨਾਵੇ ਅਤੇ ਆਪਣੇ ਅੱਡ ਹੋਣ ਦੇ ਸਿਰ ਦੇ ਵਾਲ਼ ਅੱਗ ਉੱਤੇ ਸੁੱਟੇ ਜਿਹੜੀ ਸੁੱਖ-ਸਾਂਦ ਦੀ ਬਲੀ ਹੇਠ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","ਫੇਰ ਜਾਜਕ ਉਸ ਭੇਡ ਦੇ ਬੱਚੇ ਦਾ ਉਬਾਲਿਆ ਹੋਇਆ ਮੋਢਾ ਅਤੇ ਛਾਬੇ ਵਿੱਚੋਂ ਇੱਕ ਪਤੀਰੀ ਰੋਟੀ ਅਤੇ ਇੱਕ ਪਤੀਰੀ ਮੱਠੀ ਲੈ ਕੇ ਨਜ਼ੀਰ ਦੇ ਹੱਥਾਂ ਉੱਤੇ ਉਸ ਦੇ ਅੱਡ ਹੋਣ ਦੇ ਸਿਰ ਮੁੰਨਣ ਪਿੱਛੋਂ ਰੱਖੇ। ");
INSERT INTO pan_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","ਫੇਰ ਜਾਜਕ ਉਨ੍ਹਾਂ ਨੂੰ ਹਿਲਾਉਣ ਦੀ ਭੇਟ ਲਈ ਯਹੋਵਾਹ ਅੱਗੇ ਹਿਲਾਵੇ। ਇਹ ਹਿਲਾਈ ਹੋਈ ਛਾਤੀ ਅਤੇ ਚੁੱਕਿਆ ਹੋਇਆ ਪੱਟ ਜਾਜਕ ਲਈ ਪਵਿੱਤਰ ਹੈ ਤਾਂ ਫੇਰ ਉਹ ਨਜ਼ੀਰ ਮਧ ਪੀ ਸਕੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","ਇਹ ਉਸ ਨਜ਼ੀਰ ਦੀ ਬਿਵਸਥਾ ਹੈ ਜਿਹੜਾ ਸੁੱਖਣਾ ਸੁੱਖੇ ਅਤੇ ਉਸ ਦੇ ਅੱਡ ਹੋਣ ਦੇ ਕਾਰਨ ਯਹੋਵਾਹ ਲਈ ਭੇਟ ਹੈ ਨਾਲੇ ਜੋ ਕੁਝ ਉਸ ਦੇ ਹੱਥ ਲੱਗੇ ਆਪਣੀ ਸੁੱਖਣਾ ਅਨੁਸਾਰ ਜਿਹੜੀ ਉਸ ਨੇ ਸੁੱਖੀ ਹੈ ਉਹ ਉਸੇ ਤਰ੍ਹਾਂ ਹੀ ਆਪਣੇ ਅੱਡ ਹੋਣ ਦੀ ਬਿਵਸਥਾ ਅਨੁਸਾਰ ਕਰੇ। ");
INSERT INTO pan_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","ਫੇਰ ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਆਖਿਆ, ");
INSERT INTO pan_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","ਹਾਰੂਨ ਅਤੇ ਉਸ ਦੇ ਪੁੱਤਰਾਂ ਨੂੰ ਬੋਲ ਕਿ ਤੁਸੀਂ ਇਸ ਤਰ੍ਹਾਂ ਇਸਰਾਏਲੀਆਂ ਨੂੰ ਅਸੀਸ ਦੇ ਕੇ ਆਖਿਓ, ");
INSERT INTO pan_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","“ਯਹੋਵਾਹ ਤੈਨੂੰ ਬਰਕਤ ਦੇਵੇ ਅਤੇ ਤੇਰੀ ਰਾਖੀ ਕਰੇ, ");
INSERT INTO pan_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","ਯਹੋਵਾਹ ਆਪਣੇ ਮੁਖ ਨੂੰ ਤੇਰੇ ਉੱਤੇ ਚਮਕਾਵੇ ਅਤੇ ਤੇਰੇ ਉੱਤੇ ਦਯਾ ਕਰੇ, ");
INSERT INTO pan_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","ਯਹੋਵਾਹ ਆਪਣਾ ਮੁਖ ਤੇਰੇ ਵੱਲ ਫੇਰੇ ਅਤੇ ਤੈਨੂੰ ਸ਼ਾਂਤੀ ਦੇਵੇ।” ");
INSERT INTO pan_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","ਇਸ ਤਰ੍ਹਾਂ ਉਹ ਮੇਰਾ ਨਾਮ ਇਸਰਾਏਲੀਆਂ ਉੱਤੇ ਰੱਖਣ ਅਤੇ ਮੈਂ ਉਨ੍ਹਾਂ ਨੂੰ ਬਰਕਤ ਦਿਆਂਗਾ। ");
INSERT INTO pan_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","ਜਿਸ ਦਿਨ ਮੂਸਾ ਡੇਰੇ ਨੂੰ ਖੜ੍ਹਾ ਕਰਨ, ਉਸ ਨੂੰ ਤੇਲ ਮਲਣ, ਉਸ ਨੂੰ ਉਸ ਦੇ ਸਾਰੇ ਸਮਾਨ ਸਮੇਤ ਪਵਿੱਤਰ ਕਰਨ ਦਾ ਅਤੇ ਜਗਵੇਦੀ ਨੂੰ ਸਾਰਿਆਂ ਭਾਂਡਿਆਂ ਸਮੇਤ ਤੇਲ ਮਲਣ ਅਤੇ ਪਵਿੱਤਰ ਕਰਨ ਦਾ ਕੰਮ ਪੂਰਾ ਕਰ ਚੁੱਕਿਆ। ");
INSERT INTO pan_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","ਤਦ ਇਸਰਾਏਲੀਆਂ ਦੇ ਪ੍ਰਧਾਨ ਜਿਹੜੇ ਪੁਰਖਿਆਂ ਦੇ ਘਰਾਣਿਆਂ ਦੇ ਮੁਖੀਏ ਸਨ ਅਤੇ ਗੋਤਾਂ ਦੇ ਪ੍ਰਧਾਨ ਅਤੇ ਗਿਣਿਆਂ ਹੋਇਆਂ ਦੇ ਉੱਤੇ ਸਨ ");
INSERT INTO pan_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","ਉਹ ਆਪਣੇ ਨਜ਼ਰਾਨੇ ਯਹੋਵਾਹ ਅੱਗੇ ਲਿਆਏ, ਉਹਨਾਂ ਦੇ ਨਾਲ ਛੇ ਛੱਤੇ ਹੋਏ ਗੱਡੇ ਅਤੇ ਬਾਰਾਂ ਬਲ਼ਦ ਅਰਥਾਤ ਇੱਕ ਗੱਡਾ ਦੋ ਹਾਕਮਾਂ ਵੱਲੋਂ ਅਤੇ ਇੱਕ-ਇੱਕ ਬਲ਼ਦ ਅਤੇ ਉਹ ਉਨ੍ਹਾਂ ਨੂੰ ਡੇਰੇ ਦੇ ਸਾਹਮਣੇ ਲਿਆਏ। ");
INSERT INTO pan_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","ਤਦ ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਆਖਿਆ, ");
INSERT INTO pan_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","ਉਨ੍ਹਾਂ ਤੋਂ ਉਹ ਵਸਤੂਆਂ ਲੈ ਲਵੋ ਤਾਂ ਜੋ ਉਹ ਮੰਡਲੀ ਦੇ ਤੰਬੂ ਦੀ ਟਹਿਲ ਸੇਵਾ ਕਰਨ ਲਈ ਹੋਣ ਅਤੇ ਤੂੰ ਉਹ ਲੇਵੀਆਂ ਨੂੰ ਹਰ ਇੱਕ ਦੀ ਟਹਿਲ ਸੇਵਾ ਅਨੁਸਾਰ ਵੰਡ ਦੇ। ");
INSERT INTO pan_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","ਤਦ ਮੂਸਾ ਨੇ ਗੱਡੇ ਅਤੇ ਬਲ਼ਦ ਲੈ ਕੇ ਲੇਵੀਆਂ ਨੂੰ ਦੇ ਦਿੱਤੇ। ");
INSERT INTO pan_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","ਗੇਰਸ਼ੋਨੀਆਂ ਨੂੰ ਦੋ ਗੱਡੇ ਅਤੇ ਚਾਰ ਬਲ਼ਦ ਉਨ੍ਹਾਂ ਦੀ ਟਹਿਲ ਸੇਵਾ ਅਨੁਸਾਰ ਦਿੱਤੇ। ");
INSERT INTO pan_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","ਮਰਾਰੀਆਂ ਨੂੰ ਉਨ੍ਹਾਂ ਦੀ ਟਹਿਲ ਸੇਵਾ ਅਨੁਸਾਰ ਚਾਰ ਗੱਡੇ ਅਤੇ ਅੱਠ ਬਲ਼ਦ ਦਿੱਤੇ ਜਿਹੜੇ ਹਾਰੂਨ ਜਾਜਕ ਦੇ ਪੁੱਤਰ ਈਥਾਮਾਰ ਦੇ ਹੱਥ ਵਿੱਚ ਦਿੱਤੇ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","ਪਰ ਕਹਾਥੀਆਂ ਨੂੰ ਕੁਝ ਨਾ ਦਿੱਤਾ ਤਾਂ ਜੋ ਪਵਿੱਤਰ ਸਥਾਨ ਦੇ ਭਾਰ ਦਾ ਕੰਮ ਜਿਹੜਾ ਉਨ੍ਹਾਂ ਦੀ ਟਹਿਲ ਸੇਵਾ ਦਾ ਸੀ ਉਹ ਆਪਣੇ ਮੋਢਿਆਂ ਉੱਤੇ ਚੁੱਕਿਆ ਕਰਨ। ");
INSERT INTO pan_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","ਫਿਰ ਜਦੋਂ ਜਗਵੇਦੀ ਦਾ ਸਮਰਪਣ ਹੋਇਆ, ਪ੍ਰਧਾਨ ਆਪਣੇ ਚੜ੍ਹਾਵੇ ਜਗਵੇਦੀ ਦੇ ਸਾਹਮਣੇ ਲਿਆਏ। ");
INSERT INTO pan_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","ਤਾਂ ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਆਖਿਆ, ਕਿ ਇਕੱਲਾ-ਇਕੱਲਾ ਪ੍ਰਧਾਨ ਆਪਣੀ ਵਾਰੀ ਦੇ ਦਿਨ ਜਗਵੇਦੀ ਦੇ ਅਭਿਸ਼ੇਕ ਲਈ ਆਪਣੇ ਚੜ੍ਹਾਵੇ ਲਿਆਵੇ। ");
INSERT INTO pan_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","ਪਹਿਲੇ ਦਿਨ ਅੰਮੀਨਾਦਾਬ ਦਾ ਪੁੱਤਰ ਨਹਸ਼ੋਨ ਜੋ ਯਹੂਦਾਹ ਦੇ ਗੋਤ ਦਾ ਸੀ ਆਪਣਾ ਚੜ੍ਹਾਵਾ ਲਿਆਇਆ। ");
INSERT INTO pan_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","ਉਸ ਦਾ ਚੜ੍ਹਾਵਾ ਚਾਂਦੀ ਦਾ ਇੱਕ ਥਾਲ ਸੀ, ਜਿਸ ਦਾ ਤੋਲ ਇੱਕ ਸੇਰ ਦਸ ਛਟਾਂਕ ਸੀ ਅਤੇ ਚਾਂਦੀ ਦਾ ਇੱਕ ਕਟੋਰਾ ਚੌਦਾਂ ਛਟਾਂਕ ਦਾ ਪਵਿੱਤਰ ਸਥਾਨ ਦੇ ਸ਼ਕੇਲ ਅਨੁਸਾਰ ਇਹ ਦੋਵੇਂ ਮੈਦੇ ਦੀ ਭੇਟ ਲਈ ਤੇਲ ਮਿਲੇ ਹੋਏ ਮੈਦੇ ਨਾਲ ਭਰੇ ਹੋਏ ਸਨ ");
INSERT INTO pan_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","ਇੱਕ ਕੌਲੀ ਸੋਨੇ ਦੀ ਦਸ ਤੋਲੇ ਦੀ ਧੂਪ ਨਾਲ ਭਰੀ ਹੋਈ। ");
INSERT INTO pan_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","ਇੱਕ ਮੇਂਢਾ, ਇੱਕ ਭੇਡੂ, ਇੱਕ ਸਾਲ ਦਾ ਇੱਕ ਭੇਡ ਦਾ ਬੱਚਾ ਹੋਮ ਦੀ ਬਲੀ ਲਈ, ");
INSERT INTO pan_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","ਇੱਕ ਬੱਕਰੇ ਦਾ ਬੱਚਾ ਪਾਪ ਬਲੀ ਲਈ। ");
INSERT INTO pan_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","ਅਤੇ ਸੁੱਖ-ਸਾਂਦ ਦੀ ਬਲੀ ਲਈ ਦੋ ਬਲ਼ਦ, ਪੰਜ ਭੇਡੂ, ਪੰਜ ਬੱਕਰੇ ਅਤੇ ਪੰਜ ਇੱਕ ਸਾਲ ਦੇ ਭੇਡ ਦੇ ਬੱਚੇ। ਇਹ ਅੰਮੀਨਾਦਾਬ ਦੇ ਪੁੱਤਰ ਨਹਸ਼ੋਨ ਦਾ ਚੜ੍ਹਾਵਾ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","ਦੂਜੇ ਦਿਨ ਸੂਆਰ ਦਾ ਪੁੱਤਰ ਨਥਨਿਏਲ ਯਿੱਸਾਕਾਰ ਦਾ ਪ੍ਰਧਾਨ ਆਪਣਾ ਚੜ੍ਹਾਵਾ ਲਿਆਇਆ। ");
INSERT INTO pan_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","ਉਹ ਦਾ ਚੜ੍ਹਾਵਾ ਚਾਂਦੀ ਦਾ ਇੱਕ ਥਾਲ ਸੀ ਜਿਸ ਦਾ ਤੋਲ ਇੱਕ ਸੇਰ ਦਸ ਛਟਾਂਕ ਸੀ ਅਤੇ ਚਾਂਦੀ ਦਾ ਇੱਕ ਕਟੋਰਾ ਚੌਦ੍ਹਾਂ ਛਟਾਂਕ ਦਾ ਪਵਿੱਤਰ ਸਥਾਨ ਦੇ ਸ਼ਕੇਲ ਅਨੁਸਾਰ। ਇਹ ਦੋਵੇ ਮੈਦੇ ਦੀ ਭੇਟ ਲਈ ਤੇਲ ਮਿਲੇ ਹੋਏ ਮੈਦੇ ਨਾਲ ਭਰੇ ਹੋਏ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","ਇੱਕ ਕੌਲੀ ਸੋਨੇ ਦੀ ਦਸ ਤੋਲੇ ਦੀ ਧੂਪ ਨਾਲ ਭਰੀ ਹੋਈ। ");
INSERT INTO pan_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","ਇੱਕ ਮੇਂਢਾ, ਇੱਕ ਭੇਡੂ, ਇੱਕ ਸਾਲ ਦਾ ਇੱਕ ਭੇਡ ਦਾ ਬੱਚਾ ਹੋਮ ਦੀ ਬਲੀ ਲਈ। ");
INSERT INTO pan_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","ਇੱਕ ਬੱਕਰੀ ਦਾ ਬੱਚਾ ਪਾਪ ਬਲੀ ਲਈ। ");
INSERT INTO pan_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","ਅਤੇ ਸੁੱਖ-ਸਾਂਦ ਦੀ ਬਲੀ ਲਈ ਦੋ ਬਲ਼ਦ, ਪੰਜ ਭੇਡੂ, ਪੰਜ ਬੱਕਰੇ, ਪੰਜ ਇੱਕ ਸਾਲ ਦੇ ਭੇਡ ਦੇ ਬੱਚੇ। ਇਹ ਸੂਆਰ ਦੇ ਪੁੱਤਰ ਨਥਨਿਏਲ ਦਾ ਚੜ੍ਹਾਵਾ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","ਤੀਜੇ ਦਿਨ ਜ਼ਬੂਲੁਨੀਆਂ ਦਾ ਪ੍ਰਧਾਨ ਹੇਲੋਨ ਦਾ ਪੁੱਤਰ ਅਲੀਆਬ ਆਪਣਾ ਚੜ੍ਹਾਵਾ ਲਿਆਇਆ। ");
INSERT INTO pan_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","ਉਹ ਦਾ ਚੜ੍ਹਾਵਾ ਚਾਂਦੀ ਦਾ ਇੱਕ ਥਾਲ ਸੀ ਜਿਸ ਦਾ ਤੋਲ ਇੱਕ ਸੇਰ ਦਸ ਛਟਾਂਕ ਸੀ ਅਤੇ ਚਾਂਦੀ ਦਾ ਇੱਕ ਕਟੋਰਾ ਚੌਦਾਂ ਛਟਾਂਕ ਦਾ ਪਵਿੱਤਰ ਸਥਾਨ ਦੇ ਸ਼ਕੇਲ ਅਨੁਸਾਰ। ਇਹ ਦੋਵੇਂ ਮੈਦੇ ਦੀ ਭੇਟ ਲਈ ਤੇਲ ਮਿਲੇ ਹੋਏ ਮੈਦੇ ਨਾਲ ਭਰੇ ਹੋਏ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","ਇੱਕ ਕੌਲੀ ਸੋਨੇ ਦੀ ਦਸ ਤੋਲੇ ਦੀ ਧੂਪ ਨਾਲ ਭਰੀ ਹੋਈ। ");
INSERT INTO pan_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","ਇੱਕ ਮੇਂਢਾ, ਇੱਕ ਭੇਡੂ, ਇੱਕ ਸਾਲ ਦਾ ਇੱਕ ਭੇਡ ਦਾ ਬੱਚਾ ਹੋਮ ਦੀ ਬਲੀ ਲਈ। ");
INSERT INTO pan_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","ਇੱਕ ਬੱਕਰੀ ਦਾ ਬੱਚਾ ਪਾਪ ਬਲੀ ਲਈ। ");
INSERT INTO pan_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","ਅਤੇ ਸੁੱਖ-ਸਾਂਦ ਦੀ ਬਲੀ ਲਈ ਦੋ ਬਲ਼ਦ, ਪੰਜ ਭੇਡੂ, ਪੰਜ ਬੱਕਰੇ, ਪੰਜ ਇੱਕ ਸਾਲ ਦੇ ਭੇਡ ਦੇ ਬੱਚੇ। ਇਹ ਹੇਲੋਨ ਦੇ ਪੁੱਤਰ ਅਲੀਆਬ ਦਾ ਚੜ੍ਹਾਵਾ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","ਚੌਥੇ ਦਿਨ ਰਊਬੇਨੀਆਂ ਦਾ ਪ੍ਰਧਾਨ ਸ਼ਦੇਊਰ ਦਾ ਪੁੱਤਰ ਅਲੀਸੂਰ ਆਪਣਾ ਚੜ੍ਹਾਵਾ ਲਿਆਇਆ। ");
INSERT INTO pan_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","ਉਹ ਦਾ ਚੜ੍ਹਾਵਾ ਚਾਂਦੀ ਦਾ ਇੱਕ ਥਾਲ ਸੀ ਜਿਸ ਦਾ ਤੋਲ ਇੱਕ ਸੇਰ ਦਸ ਛਟਾਂਕ ਸੀ ਅਤੇ ਚਾਂਦੀ ਦਾ ਇੱਕ ਕਟੋਰਾ ਚੌਦਾਂ ਛਟਾਂਕ ਦਾ ਪਵਿੱਤਰ ਸਥਾਨ ਦੇ ਸ਼ਕੇਲ ਅਨੁਸਾਰ। ਇਹ ਦੋਵੇਂ ਮੈਦੇ ਦੀ ਭੇਟ ਲਈ ਤੇਲ ਮਿਲੇ ਹੋਏ ਮੈਦੇ ਨਾਲ ਭਰੇ ਹੋਏ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","ਇੱਕ ਕੌਲੀ ਸੋਨੇ ਦੀ ਦਸ ਤੋਲੇ ਦੀ ਧੂਪ ਨਾਲ ਭਰੀ ਹੋਈ। ");
INSERT INTO pan_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","ਇੱਕ ਮੇਂਢਾ, ਇੱਕ ਭੇਡੂ, ਇੱਕ ਸਾਲ ਦਾ ਇੱਕ ਭੇਡ ਦਾ ਬੱਚਾ ਹੋਮ ਦੀ ਬਲੀ ਲਈ। ");
INSERT INTO pan_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","ਇੱਕ ਬੱਕਰੀ ਦਾ ਬੱਚਾ ਪਾਪ ਬਲੀ ਲਈ। ");
INSERT INTO pan_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","ਅਤੇ ਸੁੱਖ-ਸਾਂਦ ਦੀ ਬਲੀ ਲਈ ਦੋ ਬਲ਼ਦ, ਪੰਜ ਭੇਡੂ, ਪੰਜ ਬੱਕਰੇ, ਪੰਜ ਇੱਕ ਸਾਲ ਦੇ ਭੇਡ ਦੇ ਬੱਚੇ। ਇਹ ਸ਼ਦੇਊਰ ਦੇ ਪੁੱਤਰ ਅਲੀਸੂਰ ਦਾ ਚੜ੍ਹਾਵਾ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","ਪੰਜਵੇਂ ਦਿਨ ਸ਼ਿਮਓਨੀਆਂ ਦਾ ਪ੍ਰਧਾਨ ਸੂਰੀਸ਼ਦਾਈ ਦਾ ਪੁੱਤਰ ਸ਼ਲੁਮੀਏਲ ਆਪਣਾ ਚੜ੍ਹਾਵਾ ਲਿਆਇਆ। ");
INSERT INTO pan_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","ਉਹ ਦਾ ਚੜ੍ਹਾਵਾ ਚਾਂਦੀ ਦਾ ਇੱਕ ਥਾਲ ਸੀ ਜਿਸ ਦਾ ਤੋਲ ਇੱਕ ਸੇਰ ਦਸ ਛਟਾਂਕ ਸੀ ਅਤੇ ਚਾਂਦੀ ਦਾ ਇੱਕ ਕਟੋਰਾ ਚੌਦਾਂ ਛਟਾਂਕ ਦਾ ਪਵਿੱਤਰ ਸਥਾਨ ਦੇ ਸ਼ਕੇਲ ਅਨੁਸਾਰ। ਇਹ ਦੋਵੇਂ ਮੈਦੇ ਦੀ ਭੇਟ ਲਈ ਤੇਲ ਮਿਲੇ ਹੋਏ ਮੈਦੇ ਨਾਲ ਭਰੇ ਹੋਏ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","ਇੱਕ ਕੌਲੀ ਸੋਨੇ ਦੀ ਦਸ ਤੋਲੇ ਦੀ ਧੂਪ ਨਾਲ ਭਰੀ ਹੋਈ। ");
INSERT INTO pan_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","ਇੱਕ ਮੇਂਢਾ, ਇੱਕ ਭੇਡੂ, ਇੱਕ ਸਾਲ ਦਾ ਇੱਕ ਭੇਡ ਦਾ ਬੱਚਾ ਹੋਮ ਦੀ ਬਲੀ ਲਈ। ");
INSERT INTO pan_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","ਇੱਕ ਬੱਕਰੀ ਦਾ ਬੱਚਾ ਪਾਪ ਬਲੀ ਲਈ। ");
INSERT INTO pan_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","ਅਤੇ ਸੁੱਖ-ਸਾਂਦ ਦੀ ਬਲੀ ਲਈ ਦੋ ਬਲ਼ਦ, ਪੰਜ ਭੇਡੂ, ਪੰਜ ਬੱਕਰੇ, ਪੰਜ ਇੱਕ ਸਾਲ ਦੇ ਭੇਡ ਦੇ ਬੱਚੇ। ਇਹ ਸੂਰੀਸ਼ਦਾਈ ਦੇ ਪੁੱਤਰ ਸ਼ਲੁਮੀਏਲ ਦਾ ਚੜ੍ਹਾਵਾ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","ਛੇਵੇਂ ਦਿਨ ਗਾਦੀਆਂ ਦਾ ਪ੍ਰਧਾਨ ਦਊਏਲ ਦਾ ਪੁੱਤਰ, ਅਲਯਾਸਾਫ਼ ਆਪਣਾ ਚੜ੍ਹਾਵਾ ਲਿਆਇਆ। ");
INSERT INTO pan_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","ਉਹ ਦਾ ਚੜ੍ਹਾਵਾ ਚਾਂਦੀ ਦਾ ਇੱਕ ਥਾਲ ਸੀ ਜਿਸ ਦਾ ਤੋਲ ਇੱਕ ਸੇਰ ਦਸ ਛਟਾਂਕ ਸੀ ਅਤੇ ਚਾਂਦੀ ਦਾ ਇੱਕ ਕਟੋਰਾ ਚੌਦਾਂ ਛਟਾਂਕ ਦਾ ਪਵਿੱਤਰ ਸਥਾਨ ਦੇ ਸ਼ਕੇਲ ਅਨੁਸਾਰ। ਇਹ ਦੋਵੇਂ ਮੈਦੇ ਦੀ ਭੇਟ ਲਈ ਤੇਲ ਮਿਲੇ ਹੋਏ ਮੈਦੇ ਨਾਲ ਭਰੇ ਹੋਏ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","ਇੱਕ ਕੌਲੀ ਸੋਨੇ ਦੀ ਦਸ ਤੋਲੇ ਦੀ ਧੂਪ ਨਾਲ ਭਰੀ ਹੋਈ। ");
INSERT INTO pan_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","ਇੱਕ ਮੇਂਢਾ, ਇੱਕ ਭੇਡੂ, ਇੱਕ ਸਾਲ ਦਾ ਇੱਕ ਭੇਡ ਦਾ ਬੱਚਾ ਹੋਮ ਦੀ ਬਲੀ ਲਈ। ");
INSERT INTO pan_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","ਇੱਕ ਲੇਲਾ ਪਾਪ ਬਲੀ ਲਈ। ");
INSERT INTO pan_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","ਅਤੇ ਸੁੱਖ-ਸਾਂਦ ਦੀ ਬਲੀ ਲਈ ਦੋ ਬਲ਼ਦ, ਪੰਜ ਭੇਡੂ, ਪੰਜ ਬੱਕਰੇ, ਪੰਜ ਇੱਕ ਸਾਲ ਦੇ ਭੇਡ ਦੇ ਬੱਚੇ। ਇਹ ਦਊਏਲ ਦੇ ਪੁੱਤਰ ਅਲਯਾਸਾਫ਼ ਦਾ ਚੜ੍ਹਾਵਾ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","ਸੱਤਵੇਂ ਦਿਨ ਇਫ਼ਰਾਈਮ ਦਾ ਪ੍ਰਧਾਨ ਅੰਮੀਹੂਦ ਦਾ ਪੁੱਤਰ ਅਲੀਸ਼ਾਮਾ ਆਪਣਾ ਚੜ੍ਹਾਵਾ ਲਿਆਇਆ। ");
INSERT INTO pan_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","ਉਹ ਦਾ ਚੜ੍ਹਾਵਾ ਚਾਂਦੀ ਦਾ ਇੱਕ ਥਾਲ ਸੀ ਜਿਸ ਦਾ ਤੋਲ ਇੱਕ ਸੇਰ ਦਸ ਛਟਾਂਕ ਸੀ ਅਤੇ ਚਾਂਦੀ ਦਾ ਇੱਕ ਕਟੋਰਾ ਚੌਦਾਂ ਛਟਾਂਕ ਦਾ ਪਵਿੱਤਰ ਸਥਾਨ ਦੇ ਸ਼ਕੇਲ ਅਨੁਸਾਰ। ਇਹ ਦੋਵੇਂ ਮੈਦੇ ਦੀ ਭੇਟ ਲਈ ਤੇਲ ਮਿਲੇ ਹੋਏ ਮੈਦੇ ਨਾਲ ਭਰੇ ਹੋਏ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","ਇੱਕ ਕੌਲੀ ਸੋਨੇ ਦੀ ਦਸ ਤੋਲੇ ਦੀ ਧੂਪ ਨਾਲ ਭਰੀ ਹੋਈ। ");
INSERT INTO pan_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","ਇੱਕ ਮੇਂਢਾ, ਇੱਕ ਭੇਡੂ, ਇੱਕ ਸਾਲ ਦਾ ਇੱਕ ਭੇਡ ਦਾ ਬੱਚਾ ਹੋਮ ਦੀ ਬਲੀ ਲਈ। ");
INSERT INTO pan_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","ਇੱਕ ਪੱਠਾ ਪਾਪ ਬਲੀ ਲਈ। ");
INSERT INTO pan_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","ਅਤੇ ਸੁੱਖ-ਸਾਂਦ ਦੀ ਬਲੀ ਲਈ ਦੋ ਬਲ਼ਦ, ਪੰਜ ਭੇਡੂ, ਪੰਜ ਬੱਕਰੇ, ਪੰਜ ਇੱਕ ਸਾਲ ਦੇ ਭੇਡ ਦੇ ਬੱਚੇ। ਇਹ ਅੰਮੀਹੂਦ ਦੇ ਪੁੱਤਰ ਅਲੀਸ਼ਾਮਾ ਦਾ ਚੜ੍ਹਾਵਾ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","ਅੱਠਵੇਂ ਦਿਨ ਮਨੱਸ਼ੀਆਂ ਦਾ ਪ੍ਰਧਾਨ ਪਦਾਹਸੂਰ ਦਾ ਪੁੱਤਰ ਗਮਲੀਏਲ ਆਪਣਾ ਚੜ੍ਹਾਵਾ ਲਿਆਇਆ। ");
INSERT INTO pan_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","ਉਹ ਦਾ ਚੜ੍ਹਾਵਾ ਚਾਂਦੀ ਦਾ ਇੱਕ ਥਾਲ ਸੀ ਜਿਸ ਦਾ ਤੋਲ ਇੱਕ ਸੇਰ ਦਸ ਛਟਾਂਕ ਸੀ ਅਤੇ ਚਾਂਦੀ ਦਾ ਇੱਕ ਕਟੋਰਾ ਚੌਦਾਂ ਛਟਾਂਕ ਦਾ ਪਵਿੱਤਰ ਸਥਾਨ ਦੇ ਸ਼ਕੇਲ ਅਨੁਸਾਰ। ਇਹ ਦੋਵੇਂ ਮੈਦੇ ਦੀ ਭੇਟ ਲਈ ਤੇਲ ਮਿਲੇ ਹੋਏ ਮੈਦੇ ਨਾਲ ਭਰੇ ਹੋਏ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","ਇੱਕ ਕੌਲੀ ਸੋਨੇ ਦੀ ਦਸ ਤੋਲੇ ਦੀ ਧੂਪ ਨਾਲ ਭਰੀ ਹੋਈ। ");
INSERT INTO pan_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","ਇੱਕ ਮੇਂਢਾ, ਇੱਕ ਭੇਡੂ, ਇੱਕ ਸਾਲ ਦਾ ਇੱਕ ਭੇਡ ਦਾ ਬੱਚਾ ਹੋਮ ਦੀ ਬਲੀ ਲਈ। ");
INSERT INTO pan_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","ਇੱਕ ਪੱਠਾ ਪਾਪ ਬਲੀ ਲਈ। ");
INSERT INTO pan_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","ਅਤੇ ਸੁੱਖ-ਸਾਂਦ ਦੀ ਬਲੀ ਲਈ ਦੋ ਬਲ਼ਦ, ਪੰਜ ਭੇਡੂ, ਪੰਜ ਬੱਕਰੇ, ਪੰਜ ਇੱਕ ਸਾਲ ਦੇ ਭੇਡ ਦੇ ਬੱਚੇ। ਇਹ ਪਦਾਹਸੂਰ ਦੇ ਪੁੱਤਰ ਗਮਲੀਏਲ ਦਾ ਚੜ੍ਹਾਵਾ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","ਨੌਵੇਂ ਦਿਨ ਬਿਨਯਾਮੀਨੀਆਂ ਦਾ ਪ੍ਰਧਾਨ ਗਿਦਓਨੀ ਦਾ ਪੁੱਤਰ ਅਬੀਦਾਨ ਆਪਣਾ ਚੜ੍ਹਾਵਾ ਲਿਆਇਆ। ");
INSERT INTO pan_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","ਉਹ ਦਾ ਚੜ੍ਹਾਵਾ ਚਾਂਦੀ ਦਾ ਇੱਕ ਥਾਲ ਸੀ ਜਿਸ ਦਾ ਤੋਲ ਇੱਕ ਸੇਰ ਦਸ ਛਟਾਂਕ ਸੀ ਅਤੇ ਚਾਂਦੀ ਦਾ ਇੱਕ ਕਟੋਰਾ ਚੌਦਾਂ ਛਟਾਂਕ ਦਾ ਪਵਿੱਤਰ ਸਥਾਨ ਦੇ ਸ਼ਕੇਲ ਅਨੁਸਾਰ। ਇਹ ਦੋਵੇਂ ਮੈਦੇ ਦੀ ਭੇਟ ਲਈ ਤੇਲ ਮਿਲੇ ਹੋਏ ਮੈਦੇ ਨਾਲ ਭਰੇ ਹੋਏ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","ਇੱਕ ਕੌਲੀ ਸੋਨੇ ਦੀ ਦਸ ਤੋਲੇ ਦੀ ਧੂਪ ਨਾਲ ਭਰੀ ਹੋਈ। ");
INSERT INTO pan_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","ਇੱਕ ਮੇਂਢਾ, ਇੱਕ ਭੇਡੂ, ਇੱਕ ਸਾਲ ਦਾ ਇੱਕ ਭੇਡ ਦਾ ਬੱਚਾ ਹੋਮ ਦੀ ਬਲੀ ਲਈ। ");
INSERT INTO pan_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","ਇੱਕ ਪੱਠਾ ਪਾਪ ਬਲੀ ਲਈ। ");
INSERT INTO pan_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","ਅਤੇ ਸੁੱਖ-ਸਾਂਦ ਦੀ ਬਲੀ ਲਈ ਦੋ ਬਲ਼ਦ, ਪੰਜ ਭੇਡੂ, ਪੰਜ ਬੱਕਰੇ, ਪੰਜ ਇੱਕ ਸਾਲ ਦਾ ਭੇਡ ਦੇ ਬੱਚੇ। ਇਹ ਗਿਦਓਨੀ ਦੇ ਪੁੱਤਰ ਅਬੀਦਾਨ ਦਾ ਚੜ੍ਹਾਵਾ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","ਦਸਵੇਂ ਦਿਨ ਦਾਨੀਆਂ ਦਾ ਪ੍ਰਧਾਨ ਅੰਮੀਸ਼ੱਦਾਈ ਦਾ ਪੁੱਤਰ ਅਹੀਅਜ਼ਰ ਆਪਣਾ ਚੜ੍ਹਾਵਾ ਲਿਆਇਆ। ");
INSERT INTO pan_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","ਉਹ ਦਾ ਚੜ੍ਹਾਵਾ ਚਾਂਦੀ ਦਾ ਇੱਕ ਥਾਲ ਸੀ ਜਿਸ ਦਾ ਤੋਲ ਇੱਕ ਸੇਰ ਦਸ ਛਟਾਂਕ ਸੀ ਅਤੇ ਚਾਂਦੀ ਦਾ ਇੱਕ ਕਟੋਰਾ ਚੌਦਾਂ ਛਟਾਂਕ ਦਾ ਪਵਿੱਤਰ ਸਥਾਨ ਦੇ ਸ਼ਕੇਲ ਅਨੁਸਾਰ। ਇਹ ਦੋਵੇਂ ਮੈਦੇ ਦੀ ਭੇਟ ਲਈ ਤੇਲ ਮਿਲੇ ਹੋਏ ਮੈਦੇ ਨਾਲ ਭਰੇ ਹੋਏ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","ਇੱਕ ਕੌਲੀ ਸੋਨੇ ਦੀ ਦਸ ਤੋਲੇ ਦੀ ਧੂਪ ਨਾਲ ਭਰੀ ਹੋਈ। ");
INSERT INTO pan_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","ਇੱਕ ਮੇਂਢਾ, ਇੱਕ ਭੇਡੂ, ਇੱਕ ਸਾਲ ਦਾ ਭੇਡ ਦਾ ਬੱਚਾ ਹੋਮ ਦੀ ਬਲੀ ਲਈ। ");
INSERT INTO pan_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","ਇੱਕ ਪੱਠਾ ਪਾਪ ਬਲੀ ਲਈ। ");
INSERT INTO pan_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","ਅਤੇ ਸੁੱਖ-ਸਾਂਦ ਦੀ ਬਲੀ ਲਈ ਦੋ ਬਲ਼ਦ, ਪੰਜ ਭੇਡੂ, ਪੰਜ ਬੱਕਰੇ, ਪੰਜ ਇੱਕ ਸਾਲ ਦੇ ਭੇਡ ਦੇ ਬੱਚੇ। ਇਹ ਅੰਮੀਸ਼ੱਦਾਈ ਦੇ ਪੁੱਤਰ ਅਹੀਅਜ਼ਰ ਦਾ ਚੜ੍ਹਾਵਾ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","ਗਿਆਰਵੇਂ ਦਿਨ ਆਸ਼ੇਰੀਆਂ ਦਾ ਪ੍ਰਧਾਨ ਆਕਰਾਨ ਦਾ ਪੁੱਤਰ ਪਗੀਏਲ ਆਪਣਾ ਚੜ੍ਹਾਵਾ ਲਿਆਇਆ। ");
INSERT INTO pan_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","ਉਹ ਦਾ ਚੜ੍ਹਾਵਾ ਚਾਂਦੀ ਦਾ ਇੱਕ ਥਾਲ ਸੀ ਜਿਸ ਦਾ ਤੋਲ ਇੱਕ ਸੇਰ ਦਸ ਛਟਾਂਕ ਸੀ ਅਤੇ ਚਾਂਦੀ ਦਾ ਇੱਕ ਕਟੋਰਾ ਚੌਦਾਂ ਛਟਾਂਕ ਦਾ ਪਵਿੱਤਰ ਸਥਾਨ ਦੇ ਸ਼ਕੇਲ ਅਨੁਸਾਰ। ਇਹ ਦੋਵੇਂ ਮੈਦੇ ਦੀ ਭੇਟ ਲਈ ਤੇਲ ਮਿਲੇ ਹੋਏ ਮੈਦੇ ਨਾਲ ਭਰੇ ਹੋਏ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","ਇੱਕ ਕੌਲੀ ਸੋਨੇ ਦੀ ਦਸ ਤੋਲੇ ਦੀ ਧੂਪ ਨਾਲ ਭਰੀ ਹੋਈ। ");
INSERT INTO pan_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","ਇੱਕ ਮੇਂਢਾ, ਇੱਕ ਭੇਡੂ, ਇੱਕ ਸਾਲ ਦਾ ਭੇਡ ਦਾ ਬੱਚਾ ਹੋਮ ਦੀ ਬਲੀ ਲਈ। ");
INSERT INTO pan_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","ਇੱਕ ਪੱਠਾ ਪਾਪ ਬਲੀ ਲਈ। ");
INSERT INTO pan_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","ਅਤੇ ਸੁੱਖ-ਸਾਂਦ ਦੀ ਬਲੀ ਲਈ ਦੋ ਬਲ਼ਦ, ਪੰਜ ਭੇਡੂ, ਪੰਜ ਬੱਕਰੇ, ਪੰਜ ਇੱਕ ਸਾਲ ਦੇ ਭੇਡ ਦੇ ਬੱਚੇ। ਇਹ ਆਕਰਾਨ ਦੇ ਪੁੱਤਰ ਪਗੀਏਲ ਦਾ ਚੜ੍ਹਾਵਾ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","ਬਾਰ੍ਹਵੇਂ ਦਿਨ ਨਫ਼ਤਾਲੀਆਂ ਦਾ ਪ੍ਰਧਾਨ ਏਨਾਨ ਦਾ ਪੁੱਤਰ ਅਹੀਰਾ ਆਪਣਾ ਚੜ੍ਹਾਵਾ ਲਿਆਇਆ। ");
INSERT INTO pan_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","ਉਹ ਦਾ ਚੜ੍ਹਾਵਾ ਚਾਂਦੀ ਦਾ ਇੱਕ ਥਾਲ ਸੀ ਜਿਸ ਦਾ ਤੋਲ ਇੱਕ ਸੇਰ ਦਸ ਛਟਾਂਕ ਸੀ ਅਤੇ ਚਾਂਦੀ ਦਾ ਇੱਕ ਕਟੋਰਾ ਚੌਦਾਂ ਛਟਾਂਕ ਦਾ ਪਵਿੱਤਰ ਸਥਾਨ ਦੇ ਸ਼ਕੇਲ ਅਨੁਸਾਰ। ਇਹ ਦੋਵੇਂ ਮੈਦੇ ਦੀ ਭੇਟ ਲਈ ਤੇਲ ਮਿਲੇ ਹੋਏ ਮੈਦੇ ਨਾਲ ਭਰੇ ਹੋਏ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","ਇੱਕ ਕੌਲੀ ਸੋਨੇ ਦੀ ਦਸ ਤੋਲੇ ਦੀ ਧੂਪ ਨਾਲ ਭਰੀ ਹੋਈ। ");
INSERT INTO pan_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","ਇੱਕ ਮੇਂਢਾ, ਇੱਕ ਭੇਡੂ, ਇੱਕ ਸਾਲ ਦਾ ਭੇਡ ਦਾ ਬੱਚਾ ਹੋਮ ਦੀ ਬਲੀ ਲਈ। ");
INSERT INTO pan_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","ਬੱਕਰਾ ਪਾਪ ਬਲੀ ਲਈ। ");
INSERT INTO pan_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","ਅਤੇ ਸੁੱਖ-ਸਾਂਦ ਦੀ ਬਲੀ ਲਈ ਦੋ ਬਲ਼ਦ, ਪੰਜ ਭੇਡੂ, ਪੰਜ ਬੱਕਰੇ, ਪੰਜ ਇੱਕ ਸਾਲ ਦੇ ਭੇਡ ਦੇ ਬੱਚੇ। ਇਹ ਏਨਾਨ ਦੇ ਪੁੱਤਰ ਅਹੀਰਾ ਦਾ ਚੜ੍ਹਾਵਾ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","ਜਗਵੇਦੀ ਦੇ ਸਮਰਪਣ ਦੇ ਵੇਲੇ ਇਸਰਾਏਲ ਦੇ ਪ੍ਰਧਾਨਾਂ ਦੇ ਵੱਲੋਂ ਉਸ ਨੂੰ ਸਮਰਪਣ ਕੀਤੀਆਂ ਹੋਈਆਂ ਭੇਟਾਂ ਇਹ ਸਨ, ਅਰਥਾਤ ਚਾਂਦੀ ਦੇ ਬਾਰਾਂ ਥਾਲ, ਚਾਂਦੀ ਦੇ ਬਾਰਾਂ ਕਟੋਰੇ, ਸੋਨੇ ਦੀਆਂ ਬਾਰਾਂ ਕੌਲੀਆਂ। ");
INSERT INTO pan_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","ਚਾਂਦੀ ਦਾ ਹਰ ਥਾਲ ਇੱਕ ਸੇਰ ਦਸ ਛਟਾਂਕ ਅਤੇ ਚਾਂਦੀ ਦਾ ਹਰ ਕਟੋਰਾ ਚੌਦਾਂ ਛਟਾਂਕ, ਪਵਿੱਤਰ ਸਥਾਨ ਦੇ ਸ਼ਕੇਲ ਅਨੁਸਾਰ ਸਾਰੇ ਚਾਂਦੀ ਦੇ ਭਾਂਡੇ ਦੋ ਹਜ਼ਾਰ ਚਾਰ ਸੌ ਸ਼ਕੇਲ ਦੇ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","ਸੋਨੇ ਦੀਆਂ ਬਾਰਾਂ ਕੌਲੀਆਂ ਧੂਪ ਨਾਲ ਭਰੀਆਂ ਹੋਈਆਂ, ਹਰ ਕੌਲੀ ਦਸ ਤੋਲੇ ਦੀ ਪਵਿੱਤਰ ਸਥਾਨ ਦੇ ਸ਼ਕੇਲ ਅਨੁਸਾਰ ਸੌ ਕੌਲੀਆਂ ਦਾ ਸਾਰਾ ਸੋਨਾ ਡੇਢ ਸੇਰ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","ਹੋਮ ਦੀ ਬਲੀ ਦੇ ਸਾਰੇ ਪਸ਼ੂ ਬਾਰਾਂ ਵਹਿੜੇ, ਬਾਰਾਂ ਭੇਡੂ, ਬਾਰਾਂ ਭੇਡ ਦੇ ਬੱਚੇ, ਭੇਡਾਂ ਦੇ ਬੱਚੇ ਇੱਕ ਸਾਲ ਦੇ, ਉਨ੍ਹਾਂ ਦੀ ਮੈਦੇ ਦੀ ਭੇਟ ਸਮੇਤ ਬਾਰਾਂ ਪੱਠੇ ਪਾਪ ਬਲੀ ਲਈ। ");
INSERT INTO pan_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","ਅਤੇ ਸੁੱਖ-ਸਾਂਦ ਦੀ ਬਲੀ ਲਈ ਸਾਰੇ ਪਸ਼ੂ ਇਹ ਹਨ, ਚੌਵੀ ਬਲ਼ਦ, ਸੱਠ ਭੇਡੂ, ਸੱਠ ਬੱਕਰੇ, ਸੱਠ ਇੱਕ ਸਾਲ ਦੇ ਭੇਡਾਂ ਦੇ ਬੱਚੇ, ਇਹ ਜਗਵੇਦੀ ਦੇ ਸਮਰਪਣ ਲਈ ਤੇ ਉਸ ਦੇ ਸਮਰਪਣ ਦੀ ਭੇਂਟ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","ਜਦ ਮੂਸਾ ਮੰਡਲੀ ਦੇ ਤੰਬੂ ਵਿੱਚ ਯਹੋਵਾਹ ਦੇ ਨਾਲ ਗੱਲਾਂ ਕਰਨ ਲਈ ਗਿਆ, ਤਦ ਉਸ ਨੇ ਉਸ ਆਵਾਜ਼ ਨੂੰ ਪ੍ਰਾਸਚਿਤ ਦੇ ਸਰਪੋਸ਼ ਦੇ ਉੱਤੇ ਜਿਹੜਾ ਸਾਖੀ ਦੇ ਸੰਦੂਕ ਦੇ ਉੱਤੇ ਸੀ, ਦੋਹਾਂ ਕਰੂਬੀਆਂ ਦੇ ਵਿੱਚੋਂ ਦੀ ਬੋਲਦੇ ਸੁਣਿਆ ਅਤੇ ਯਹੋਵਾਹ ਉਸ ਦੇ ਨਾਲ ਬੋਲਿਆ। ");
INSERT INTO pan_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਆਖਿਆ, ");
INSERT INTO pan_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","ਹਾਰੂਨ ਨਾਲ ਗੱਲ ਕਰ ਅਤੇ ਉਹ ਨੂੰ ਆਖ ਕਿ ਜਦ ਤੂੰ ਦੀਵੇ ਬਾਲੇਂ ਤਾਂ ਉਹ ਸੱਤ ਦੀਵੇ ਸ਼ਮਾਦਾਨ ਦੇ ਸਾਹਮਣੇ ਚਾਨਣ ਦੇਣ। ");
INSERT INTO pan_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","ਤਾਂ ਹਾਰੂਨ ਨੇ ਉਸੇ ਤਰ੍ਹਾਂ ਹੀ ਕੀਤਾ। ਉਹ ਨੇ ਉਸ ਦੇ ਦੀਵੇ ਸ਼ਮਾਦਾਨ ਦੇ ਸਾਹਮਣੇ ਬਾਲੇ, ਜਿਵੇਂ ਯਹੋਵਾਹ ਨੂੰ ਮੂਸਾ ਨੂੰ ਹੁਕਮ ਦਿੱਤਾ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","ਸ਼ਮਾਦਾਨ ਦੀ ਬਣਾਵਟ ਇਸ ਤਰ੍ਹਾਂ ਸੀ, ਉਹ ਹੇਠਾਂ ਤੋਂ ਲੈ ਕੇ ਉੱਪਰ ਫੁੱਲਾਂ ਤੱਕ ਸੋਨੇ ਨਾਲ ਬਣਾਇਆ ਗਿਆ ਸੀ। ਉਹ ਉਸ ਨਮੂਨੇ ਉੱਤੇ ਸੀ ਜਿਹੜਾ ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਵਿਖਾਇਆ, ਉਸੇ ਤਰ੍ਹਾਂ ਉਸ ਨੇ ਸ਼ਮਾਦਾਨ ਨੂੰ ਬਣਾਇਆ। ");
INSERT INTO pan_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","ਫੇਰ ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਆਖਿਆ, ");
INSERT INTO pan_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","ਲੇਵੀਆਂ ਨੂੰ ਇਸਰਾਏਲੀਆਂ ਵਿੱਚੋਂ ਲੈ ਕੇ ਪਵਿੱਤਰ ਕਰ। ");
INSERT INTO pan_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","ਉਨ੍ਹਾਂ ਨੂੰ ਪਵਿੱਤਰ ਕਰਨ ਲਈ ਅਜਿਹਾ ਕਰੀਂ ਕਿ ਉਨ੍ਹਾਂ ਉੱਤੇ ਪਾਪ ਤੋਂ ਸ਼ੁੱਧ ਕਰਨ ਵਾਲਾ ਪਾਣੀ ਛਿੜਕ ਦੇ ਅਤੇ ਉਨ੍ਹਾਂ ਦੇ ਸਾਰੇ ਸਰੀਰ ਉੱਤੇ ਉਸਤਰਾ ਫਿਰਾ ਦੇ ਅਤੇ ਉਹ ਆਪਣੇ ਬਸਤਰ ਧੋਣ, ਇਸ ਤਰ੍ਹਾਂ ਉਹ ਸ਼ੁੱਧ ਹੋਣ। ");
INSERT INTO pan_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","ਫੇਰ ਉਹ ਇੱਕ ਮੇਂਢਾ ਲੈਣ ਨਾਲੇ ਉਸ ਦੀ ਮੈਦੇ ਦੀ ਭੇਟ, ਬਰੀਕ ਮੈਦਾ ਤੇਲ ਨਾਲ ਰਲਿਆ ਹੋਇਆ ਅਤੇ ਤੂੰ ਦੂਜਾ ਮੇਂਢਾ ਪਾਪ ਬਲੀ ਲਈ ਲਵੀਂ। ");
INSERT INTO pan_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","ਫੇਰ ਲੇਵੀਆਂ ਨੂੰ ਮੰਡਲੀ ਦੇ ਤੰਬੂ ਦੇ ਅੱਗੇ ਹਾਜ਼ਰ ਕਰੀਂ, ਅਤੇ ਇਸਰਾਏਲੀਆਂ ਦੀ ਸਾਰੀ ਮੰਡਲੀ ਨੂੰ ਇਕੱਠਾ ਕਰੀਂ। ");
INSERT INTO pan_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","ਤਦ ਤੂੰ ਲੇਵੀਆਂ ਨੂੰ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਹਾਜ਼ਰ ਕਰੀਂ ਅਤੇ ਇਸਰਾਏਲੀ ਲੇਵੀਆਂ ਉੱਤੇ ਆਪਣੇ ਹੱਥ ਧਰਨ। ");
INSERT INTO pan_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","ਅਤੇ ਹਾਰੂਨ ਉਨ੍ਹਾਂ ਲੇਵੀਆਂ ਨੂੰ ਯਹੋਵਾਹ ਅੱਗੇ ਇਸਰਾਏਲੀਆਂ ਵੱਲੋਂ ਹਿਲਾਉਣ ਦੀ ਭੇਟ ਕਰਕੇ ਚੜ੍ਹਾਵੇ ਤਾਂ ਜੋ ਉਹ ਯਹੋਵਾਹ ਦੀ ਸੇਵਾ ਦਾ ਕੰਮ ਕਰਨ। ");
INSERT INTO pan_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","ਫੇਰ ਲੇਵੀ ਆਪਣੇ ਹੱਥ ਵਹਿੜਿਆਂ ਦੇ ਸਿਰਾਂ ਉੱਤੇ ਧਰਨ ਅਤੇ ਤੂੰ ਇੱਕ ਨੂੰ ਪਾਪ ਬਲੀ ਲਈ ਅਤੇ ਦੂਜੇ ਨੂੰ ਹੋਮ ਦੀ ਭੇਟ ਲਈ ਚੜ੍ਹਾ ਤਾਂ ਜੋ ਉਹ ਲੇਵੀਆਂ ਦਾ ਪ੍ਰਾਸਚਿਤ ਹੋਵੇ। ");
INSERT INTO pan_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","ਤਦ ਲੇਵੀਆਂ ਨੂੰ ਹਾਰੂਨ ਅਤੇ ਉਸ ਦੇ ਪੁੱਤਰਾਂ ਦੇ ਅੱਗੇ ਖੜ੍ਹਾ ਕਰੀਂ ਅਤੇ ਤੂੰ ਉਨ੍ਹਾਂ ਨੂੰ ਹਿਲਾਉਣ ਦੀ ਭੇਟ ਲਈ ਯਹੋਵਾਹ ਅੱਗੇ ਚੜ੍ਹਾਈਂ। ");
INSERT INTO pan_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","ਇਸ ਤਰ੍ਹਾਂ ਤੂੰ ਲੇਵੀਆਂ ਨੂੰ ਇਸਰਾਏਲੀਆਂ ਵਿੱਚੋਂ ਵੱਖਰਾ ਕਰੀਂ, ਇਸ ਤਰ੍ਹਾਂ ਲੇਵੀ ਮੇਰੇ ਹੋਣਗੇ। ");
INSERT INTO pan_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","ਅਤੇ ਇਸ ਤੋਂ ਬਾਅਦ ਲੇਵੀ ਮੰਡਲੀ ਦੇ ਤੰਬੂ ਵਿੱਚ ਜਾ ਕੇ ਸੇਵਾ ਕਰਨ ਅਤੇ ਇਸ ਤਰ੍ਹਾਂ ਉਨ੍ਹਾਂ ਨੂੰ ਸ਼ੁੱਧ ਕਰੀਂ ਅਤੇ ਉਨ੍ਹਾਂ ਨੂੰ ਹਿਲਾਉਣ ਦੀ ਭੇਟ ਕਰਕੇ ਚੜ੍ਹਾਵੀਂ। ");
INSERT INTO pan_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","ਕਿਉਂਕਿ ਉਹ ਇਸਰਾਏਲੀਆਂ ਵਿੱਚੋਂ ਮੈਨੂੰ ਪੂਰੀ ਤਰ੍ਹਾਂ ਨਾਲ ਸਮਰਪਤ ਕੀਤੇ ਗਏ ਹਨ, ਮੈਂ ਉਹਨਾਂ ਨੂੰ ਸਾਰੇ ਇਸਰਾਏਲ ਵਿੱਚੋਂ ਸਾਰੇ ਪਹਿਲੌਠਿਆਂ ਦੇ ਬਦਲੇ ਆਪਣੇ ਲਈ ਲੈ ਲਿਆ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","ਕਿਉਂ ਜੋ ਇਸਰਾਏਲੀਆਂ ਦੇ ਸਾਰੇ ਪਹਿਲੌਠੇ ਮੇਰੇ ਹਨ, ਭਾਵੇਂ ਆਦਮੀ ਦਾ ਭਾਵੇਂ ਪਸ਼ੂ ਦਾ। ਜਿਸ ਦਿਨ ਤੋਂ ਮੈਂ ਮਿਸਰ ਦੇਸ ਦੇ ਸਾਰਿਆਂ ਪਹਿਲੌਠਿਆਂ ਨੂੰ ਮਾਰਿਆ, ਮੈਂ ਉਨ੍ਹਾਂ ਨੂੰ ਆਪਣੇ ਲਈ ਪਵਿੱਤਰ ਕੀਤਾ। ");
INSERT INTO pan_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","ਇਸ ਤਰ੍ਹਾਂ ਮੈਂ ਲੇਵੀਆਂ ਨੂੰ ਇਸਰਾਏਲੀਆਂ ਦੇ ਸਾਰੇ ਪਹਿਲੌਠਿਆਂ ਦੇ ਥਾਂ ਲੈ ਲਿਆ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","ਮੈਂ ਹਾਰੂਨ ਅਤੇ ਉਸ ਦੇ ਪੁੱਤਰਾਂ ਲਈ ਇਸਰਾਏਲੀਆਂ ਵਿੱਚੋਂ ਲੇਵੀ ਦਾਨ ਦਿੱਤੇ ਹਨ ਕਿ ਉਹ ਮੰਡਲੀ ਦੇ ਤੰਬੂ ਵਿੱਚ ਇਸਰਾਏਲੀਆਂ ਲਈ ਸੇਵਾ ਕਰਨ, ਇਸਰਾਏਲੀਆਂ ਲਈ ਪ੍ਰਾਸਚਿਤ ਕਰਨ ਤਾਂ ਜੋ ਜਦ ਇਸਰਾਏਲੀ ਪਵਿੱਤਰ ਸਥਾਨ ਦੇ ਨੇੜੇ ਆਉਣ ਤਾਂ ਕੋਈ ਬਵਾ ਉਹਨਾਂ ਉੱਤੇ ਨਾ ਪਵੇ। ");
INSERT INTO pan_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","ਮੂਸਾ, ਹਾਰੂਨ ਅਤੇ ਇਸਰਾਏਲ ਦੀ ਸਾਰੀ ਮੰਡਲੀ ਨੇ ਲੇਵੀਆਂ ਨਾਲ ਇਸੇ ਤਰ੍ਹਾਂ ਹੀ ਕੀਤਾ ਜਿਵੇਂ ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਹੁਕਮ ਦਿੱਤਾ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","ਤਦ ਲੇਵੀਆਂ ਨੇ ਆਪਣੇ ਆਪ ਨੂੰ ਪਵਿੱਤਰ ਕੀਤਾ ਅਤੇ ਆਪਣੇ ਬਸਤਰ ਧੋਤੇ। ਤਦ ਹਾਰੂਨ ਨੇ ਉਨ੍ਹਾਂ ਨੂੰ ਯਹੋਵਾਹ ਅੱਗੇ ਹਿਲਾਉਣ ਦੀ ਭੇਟ ਕਰਕੇ ਚੜ੍ਹਾਇਆ ਅਤੇ ਹਾਰੂਨ ਨੇ ਉਨ੍ਹਾਂ ਦੀ ਪਵਿੱਤਰਤਾਈ ਲਈ ਪ੍ਰਾਸਚਿਤ ਕੀਤਾ। ");
INSERT INTO pan_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","ਇਸ ਤੋਂ ਬਾਅਦ ਉਹ ਲੇਵੀ ਸੇਵਾ ਦੇ ਕੰਮ ਲਈ ਹਾਰੂਨ ਅਤੇ ਉਸ ਦੇ ਪੁੱਤਰਾਂ ਦੇ ਅੱਗੇ ਮੰਡਲੀ ਦੇ ਤੰਬੂ ਵਿੱਚ ਆਏ। ਜਿਵੇਂ ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਲੇਵੀਆਂ ਦੇ ਵਿਖੇ ਹੁਕਮ ਦਿੱਤਾ ਸੀ ਉਸੇ ਤਰ੍ਹਾਂ ਹੀ ਉਹਨਾਂ ਨੇ ਉਨ੍ਹਾਂ ਨਾਲ ਕੀਤਾ। ");
INSERT INTO pan_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਆਖਿਆ, ");
INSERT INTO pan_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","ਲੇਵੀਆਂ ਲਈ ਨਿਯਮ ਇਹ ਹੈ ਕਿ ਪੱਚੀ ਸਾਲ ਜਾਂ ਇਸ ਤੋਂ ਵੱਧ ਉਮਰ ਵਿੱਚ ਉਹ ਮੰਡਲੀ ਦੇ ਤੰਬੂ ਵਿੱਚ ਸੇਵਾ ਦੇ ਕੰਮ ਵਿੱਚ ਲੱਗੇ ਰਹਿਣ, ");
INSERT INTO pan_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","ਅਤੇ ਜਦ ਉਹ ਪੰਜਾਹ ਸਾਲ ਦੇ ਹੋ ਜਾਣ ਤਦ ਉਹ ਸੇਵਾ ਦੇ ਕੰਮ ਤੋਂ ਰਹਿਤ ਕੀਤੇ ਜਾਣ ਅਤੇ ਉਹ ਹੋਰ ਸੇਵਾ ਦਾ ਕੰਮ ਨਾ ਕਰਨ। ");
INSERT INTO pan_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","ਪਰ ਉਹ ਆਪਣੇ ਭਰਾਵਾਂ ਦੇ ਨਾਲ ਸੇਵਾ ਮੰਡਲੀ ਦੇ ਤੰਬੂ ਦੀ ਰਖਵਾਲੀ ਦਾ ਕੰਮ ਕਰਿਆ ਕਰਨ ਅਤੇ ਉਹ ਆਪ ਸੇਵਾ ਦਾ ਕੰਮ ਨਾ ਕਰਨ। ਲੇਵੀਆਂ ਨੂੰ ਜੋ-ਜੋ ਕੰਮ ਦਿੱਤੇ ਜਾਣ ਉਹਨਾਂ ਦੇ ਵਿਖੇ ਅਜਿਹਾ ਹੀ ਕਰੀਂ। ");
INSERT INTO pan_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","ਸੀਨਈ ਦੀ ਉਜਾੜ ਵਿੱਚ, ਦੂਜੇ ਸਾਲ ਦੇ ਪਹਿਲੇ ਮਹੀਨੇ ਇਸਰਾਏਲੀਆਂ ਦੇ ਮਿਸਰ ਦੇਸ ਵਿੱਚੋਂ ਨਿੱਕਲਣ ਤੋਂ ਬਾਅਦ ਯਹੋਵਾਹ ਮੂਸਾ ਨਾਲ ਬੋਲਿਆ, ");
INSERT INTO pan_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","ਇਸਰਾਏਲੀ ਪਸਾਹ ਦੇ ਪਰਬ ਨੂੰ ਠਹਿਰਾਏ ਹੋਏ ਸਮੇਂ ਉੱਤੇ ਮਨਾਇਆ ਕਰਨ। ");
INSERT INTO pan_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","ਇਸੇ ਮਹੀਨੇ ਦੀ ਚੌਧਵੀਂ ਤਾਰੀਖ਼ ਦੀ ਸ਼ਾਮ ਨੂੰ ਠਹਿਰਾਏ ਹੋਏ ਸਮੇਂ ਉੱਤੇ ਉਸ ਦੀਆਂ ਸਾਰੀਆਂ ਬਿਧੀਆਂ ਅਤੇ ਰੀਤਾਂ ਅਨੁਸਾਰ ਉਸ ਨੂੰ ਮਨਾਇਆ ਕਰੋ। ");
INSERT INTO pan_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","ਇਸ ਲਈ ਮੂਸਾ ਨੇ ਇਸਰਾਏਲੀਆਂ ਨੂੰ ਪਸਾਹ ਮਨਾਉਣ ਲਈ ਆਖਿਆ। ");
INSERT INTO pan_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","ਉਪਰੰਤ ਉਨ੍ਹਾਂ ਨੇ ਪਹਿਲੇ ਮਹੀਨੇ ਦੀ ਚੌਧਵੀਂ ਤਾਰੀਖ਼ ਦੀ ਸ਼ਾਮ ਨੂੰ ਸੀਨਈ ਦੀ ਉਜਾੜ ਵਿੱਚ ਪਸਾਹ ਨੂੰ ਮਨਾਇਆ, ਜਿਵੇਂ ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਹੁਕਮ ਦਿੱਤਾ ਸੀ ਉਸੇ ਤਰ੍ਹਾਂ ਹੀ ਇਸਰਾਏਲੀਆਂ ਨੇ ਕੀਤਾ। ");
INSERT INTO pan_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","ਕਈ ਮਨੁੱਖ, ਜਿਹੜੇ ਕਿਸੇ ਆਦਮੀ ਦੀ ਲਾਸ਼ ਦੇ ਕਾਰਨ ਅਸ਼ੁੱਧ ਹੋ ਗਏ ਸਨ, ਉਹ ਪਸਾਹ ਦਾ ਪਰਬ ਨਾ ਮਨਾ ਸਕੇ ਤਦ ਉਹ ਮੂਸਾ ਅਤੇ ਹਾਰੂਨ ਦੇ ਕੋਲ ਆਏ, ");
INSERT INTO pan_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","ਉਨ੍ਹਾਂ ਮਨੁੱਖਾਂ ਨੇ ਆਖਿਆ ਕਿ ਅਸੀਂ ਇੱਕ ਆਦਮੀ ਦੀ ਲਾਸ਼ ਦੇ ਕਾਰਨ ਅਸ਼ੁੱਧ ਹੋ ਗਏ ਹਾਂ, ਪਰ ਅਸੀਂ ਕਿਉਂ ਰੁਕੇ ਰਹੀਏ ਕਿ ਅਸੀਂ ਯਹੋਵਾਹ ਦਾ ਚੜ੍ਹਾਵਾ ਠਹਿਰਾਏ ਹੋਏ ਸਮੇਂ ਉੱਤੇ ਇਸਰਾਏਲੀਆਂ ਦੇ ਵਿੱਚ ਨਾ ਚੜ੍ਹਾਈਏ? ");
INSERT INTO pan_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","ਮੂਸਾ ਨੇ ਉਨ੍ਹਾਂ ਨੂੰ ਆਖਿਆ, ਰੁਕੋ, ਮੈਂ ਸੁਣ ਲਵਾਂ ਕਿ ਯਹੋਵਾਹ ਤੁਹਾਡੇ ਵਿਖੇ ਕੀ ਆਗਿਆ ਦਿੰਦਾ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","ਤਦ ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਆਖਿਆ, ");
INSERT INTO pan_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","ਇਸਰਾਏਲੀਆਂ ਨੂੰ ਆਖ ਕਿ ਜੇ ਕੋਈ ਮਨੁੱਖ ਕਿਸੇ ਦੀ ਲਾਸ਼ ਦੇ ਕਾਰਨ ਜਾਂ ਕਿਸੇ ਦੂਰ ਸਫ਼ਰ ਦੇ ਕਾਰਨ ਅਸ਼ੁੱਧ ਹੋ ਗਿਆ ਹੋਵੇ, ਭਾਵੇਂ ਤੁਹਾਡੇ ਵਿੱਚੋਂ, ਭਾਵੇਂ ਤੁਹਾਡੀ ਅੰਸ ਵਿੱਚੋਂ ਤਾਂ ਵੀ ਉਹ ਯਹੋਵਾਹ ਦੇ ਲਈ ਪਸਾਹ ਨੂੰ ਮਨਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","ਉਹ ਦੂਜੇ ਮਹੀਨੇ ਦੀ ਚੌਧਵੀਂ ਤਾਰੀਖ਼ ਦੀ ਸ਼ਾਮ ਨੂੰ ਉਹ ਨੂੰ ਮਨਾਉਣ, ਉਹ ਪਸਾਹ ਦੀ ਪਤੀਰੀ ਰੋਟੀ ਅਤੇ ਸਾਗ ਪੱਤ ਨਾਲ ਉਸ ਨੂੰ ਖਾਣ। ");
INSERT INTO pan_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","ਉਹ ਸਵੇਰ ਤੱਕ ਕੁਝ ਵੀ ਬਾਕੀ ਨਾ ਛੱਡਣ ਅਤੇ ਨਾ ਹੀ ਉਸ ਦੀ ਹੱਡੀ ਤੋੜਨ ਅਤੇ ਪਸਾਹ ਦੀ ਸਾਰੀ ਬਿਧੀ ਅਨੁਸਾਰ ਉਹ ਨੂੰ ਮਨਾਉਣ। ");
INSERT INTO pan_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","ਪਰੰਤੂ ਜਿਹੜਾ ਮਨੁੱਖ ਸ਼ੁੱਧ ਹੋਵੇ ਅਤੇ ਸਫ਼ਰ ਵਿੱਚ ਵੀ ਨਾ ਹੋਵੇ ਅਤੇ ਜੇਕਰ ਉਹ ਪਸਾਹ ਮਨਾਉਣ ਤੋਂ ਇਨਕਾਰ ਕਰੇ ਤਾਂ ਉਹ ਮਨੁੱਖ ਆਪਣਿਆਂ ਲੋਕਾਂ ਵਿੱਚੋਂ ਕੱਢਿਆ ਜਾਵੇ ਕਿਉਂ ਜੋ ਉਸ ਨੇ ਯਹੋਵਾਹ ਦਾ ਚੜ੍ਹਾਵਾ ਠਹਿਰਾਏ ਹੋਏ ਸਮੇਂ ਉੱਤੇ ਨਹੀਂ ਚੜ੍ਹਾਇਆ, ਉਹ ਮਨੁੱਖ ਆਪਣਾ ਪਾਪ ਆਪ ਚੁੱਕੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","ਜੇਕਰ ਤੁਹਾਡੇ ਵਿੱਚ ਕੋਈ ਪਰਦੇਸੀ ਰਹਿ ਰਿਹਾ ਹੋਵੇ ਅਤੇ ਉਹ ਯਹੋਵਾਹ ਲਈ ਪਸਾਹ ਮਨਾਉਣੀ ਚਾਹੇ ਤਾਂ ਉਹ ਪਸਾਹ ਦੀ ਬਿਧੀ ਅਤੇ ਉਹ ਦੀ ਰੀਤੀ ਅਨੁਸਾਰ ਮਨਾਵੇ। ਤੁਹਾਡੇ ਅਤੇ ਪਰਦੇਸੀ ਲਈ ਇੱਕੋ ਹੀ ਬਿਧੀ ਹੋਵੇ। ");
INSERT INTO pan_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","ਜਿਸ ਦਿਨ ਡੇਰਾ ਖੜ੍ਹਾ ਕੀਤਾ ਗਿਆ ਤਾਂ ਬੱਦਲ ਨੇ ਡੇਰੇ ਨੂੰ ਸਾਖੀ ਦੇ ਤੰਬੂ ਤੱਕ ਢੱਕ ਲਿਆ ਅਤੇ ਸ਼ਾਮ ਨੂੰ ਡੇਰੇ ਉੱਤੇ ਸਵੇਰ ਤੱਕ ਅੱਗ ਜਿਹੀ ਦਿੱਸਦੀ ਰਹੀ। ");
INSERT INTO pan_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","ਇਸ ਤਰ੍ਹਾਂ ਸਦਾ ਹੀ ਹੁੰਦਾ ਸੀ। ਬੱਦਲ ਉਹ ਨੂੰ ਢੱਕਦਾ ਹੁੰਦਾ ਸੀ ਅਤੇ ਰਾਤ ਨੂੰ ਅੱਗ ਦਿੱਸਦੀ ਹੁੰਦੀ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","ਜਦੋਂ ਵੀ ਬੱਦਲ ਤੰਬੂ ਦੇ ਉੱਤੋਂ ਚੁੱਕਿਆ ਜਾਂਦਾ ਸੀ ਤਾਂ ਉਸ ਦੇ ਪਿੱਛੇ ਇਸਰਾਏਲੀ ਕੂਚ ਕਰਦੇ ਸਨ ਅਤੇ ਜਿਸ ਥਾਂ ਬੱਦਲ ਠਹਿਰਦਾ ਸੀ ਉੱਥੇ ਇਸਰਾਏਲੀ ਡੇਰੇ ਲਾਉਂਦੇ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","ਯਹੋਵਾਹ ਦੇ ਹੁਕਮ ਉੱਤੇ ਇਸਰਾਏਲੀ ਕੂਚ ਕਰਦੇ ਸਨ ਅਤੇ ਯਹੋਵਾਹ ਦੇ ਹੁਕਮ ਨਾਲ ਡੇਰੇ ਲਾਉਂਦੇ ਸਨ। ਜਿਨ੍ਹਾਂ ਚਿਰ ਬੱਦਲ ਡੇਰੇ ਦੇ ਉੱਤੇ ਠਹਿਰਦਾ ਸੀ ਉਨ੍ਹੀਂ ਦੇਰ ਤੱਕ ਆਪਣੇ ਡੇਰੇ ਵਿੱਚ ਰਹਿੰਦੇ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","ਜਦ ਬੱਦਲ ਡੇਰੇ ਉੱਤੇ ਬਹੁਤੇ ਦਿਨਾਂ ਤੱਕ ਠਹਿਰਿਆ ਰਹਿੰਦਾ ਸੀ ਤਾਂ ਇਸਰਾਏਲੀ ਯਹੋਵਾਹ ਦੇ ਹੁਕਮ ਨੂੰ ਮੰਨਦੇ ਹੋਏ ਕੂਚ ਨਹੀਂ ਕਰਦੇ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","ਕਦੀ-ਕਦੀ ਬੱਦਲ ਥੋੜ੍ਹੇ ਦਿਨ ਡੇਰੇ ਦੇ ਉੱਤੇ ਰਹਿੰਦਾ ਸੀ ਤਦ ਯਹੋਵਾਹ ਦੇ ਹੁਕਮ ਅਨੁਸਾਰ ਉਹ ਡੇਰੇ ਵਿੱਚ ਹੀ ਰਹਿੰਦੇ ਸਨ ਅਤੇ ਫੇਰ ਯਹੋਵਾਹ ਦੇ ਹੁਕਮ ਅਨੁਸਾਰ ਕੂਚ ਕਰਦੇ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","ਅਤੇ ਕਦੀ-ਕਦੀ ਬੱਦਲ ਸ਼ਾਮ ਤੋਂ ਸਵੇਰ ਤੱਕ ਹੁੰਦਾ ਸੀ ਤਾਂ ਜਦ ਸਵੇਰ ਨੂੰ ਬੱਦਲ ਚੁੱਕਿਆ ਜਾਂਦਾ ਸੀ ਤਾਂ ਉਹ ਕੂਚ ਕਰਦੇ ਸਨ। ਭਾਵੇਂ ਦਿਨ ਨੂੰ ਭਾਵੇਂ ਰਾਤ ਨੂੰ ਜਦ ਬੱਦਲ ਚੁੱਕਿਆ ਜਾਂਦਾ ਸੀ ਤਦ ਉਹ ਕੂਚ ਕਰਦੇ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","ਭਾਵੇਂ ਦੋ ਦਿਨ, ਭਾਵੇਂ ਮਹੀਨਾ ਭਾਵੇਂ ਪੂਰਾ ਸਾਲ ਬੱਦਲ ਜਦ ਤੱਕ ਡੇਰੇ ਉੱਤੇ ਠਹਿਰਿਆ ਰਹਿੰਦਾ ਸੀ, ਉਦੋਂ ਤੱਕ ਇਸਰਾਏਲੀ ਆਪਣੇ ਡੇਰਿਆਂ ਵਿੱਚ ਰਹਿੰਦੇ ਹੁੰਦੇ ਸਨ ਅਤੇ ਕੂਚ ਨਹੀਂ ਕਰਦੇ ਸਨ ਪਰ ਜਦ ਬੱਦਲ ਚੁੱਕਿਆ ਜਾਂਦਾ ਸੀ, ਤਦ ਉਹ ਕੂਚ ਕਰਦੇ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","ਯਹੋਵਾਹ ਦੇ ਹੁਕਮ ਨਾਲ ਉਹ ਡੇਰੇ ਲਾਉਂਦੇ ਸਨ ਅਤੇ ਯਹੋਵਾਹ ਦੇ ਹੁਕਮ ਨਾਲ ਉਹ ਕੂਚ ਕਰਦੇ ਸਨ। ਉਹ ਯਹੋਵਾਹ ਦੀ ਆਗਿਆ ਨੂੰ ਮੰਨਦੇ ਸਨ ਜਿਵੇਂ ਯਹੋਵਾਹ ਮੂਸਾ ਦੇ ਰਾਹੀਂ ਹੁਕਮ ਦਿੰਦਾ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਆਖਿਆ, ");
INSERT INTO pan_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","ਆਪਣੇ ਲਈ ਚਾਂਦੀ ਦੀਆਂ ਦੋ ਤੁਰ੍ਹੀਆਂ ਬਣਾ। ਉਨ੍ਹਾਂ ਨੂੰ ਘੜ੍ਹ ਕੇ ਬਣਾ ਤਾਂ ਜੋ ਉਹ ਤੇਰੇ ਲਈ ਮੰਡਲੀ ਨੂੰ ਸੱਦਣ ਲਈ ਅਤੇ ਡੇਰਿਆਂ ਦੇ ਕੂਚ ਕਰਨ ਲਈ ਹੋਣ। ");
INSERT INTO pan_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","ਜਦ ਉਹ ਉਨ੍ਹਾਂ ਨੂੰ ਫੂਕਣ ਤਾਂ ਸਾਰੀ ਮੰਡਲੀ ਤੇਰੇ ਕੋਲ ਮੰਡਲੀ ਦੇ ਤੰਬੂ ਦੇ ਦਰਵਾਜ਼ੇ ਕੋਲ ਇਕੱਠੀ ਹੋ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","ਜੇਕਰ ਇੱਕੋ ਹੀ ਫੂਕਣ ਤਾਂ ਪ੍ਰਧਾਨ, ਜਿਹੜੇ ਇਸਰਾਏਲ ਵਿੱਚ ਹਜ਼ਾਰਾਂ ਦੇ ਮੁਖੀਏ ਹਨ, ਤੇਰੇ ਕੋਲ ਇਕੱਠੇ ਹੋ ਜਾਣ। ");
INSERT INTO pan_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","ਜਦ ਤੁਸੀਂ ਸਾਹ ਖਿੱਚ ਕੇ ਫੂਕ ਮਾਰੋ ਤਾਂ ਪੂਰਬ ਦਿਸ਼ਾ ਵੱਲ ਦੇ ਡੇਰੇ ਕੂਚ ਕਰਨ। ");
INSERT INTO pan_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","ਜਦ ਤੁਸੀਂ ਸਾਹ ਖਿੱਚ ਕੇ ਦੂਜੀ ਵਾਰ ਫੂਕ ਮਾਰੋ ਤਾਂ ਦੱਖਣ ਦਿਸ਼ਾ ਵੱਲ ਦੇ ਡੇਰੇ ਕੂਚ ਕਰਨ। ਇਸ ਤਰ੍ਹਾਂ ਦੇ ਕੂਚ ਕਰਨ ਲਈ ਉਹ ਸਾਹ ਖਿੱਚ ਕੇ ਫੂਕਣ। ");
INSERT INTO pan_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","ਜਦ ਸਭਾ ਇਕੱਠੀ ਕਰਨੀ ਹੋਵੇ ਤਾਂ ਤੁਸੀਂ ਤੁਰ੍ਹੀ ਫੂਕੋ ਪਰ ਸਾਹ ਖਿੱਚ ਕੇ ਨਾ ਫੂਕੋ। ");
INSERT INTO pan_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","ਅਤੇ ਹਾਰੂਨ ਦੇ ਪੁੱਤਰ ਜੋ ਜਾਜਕ ਹਨ ਉਹ ਤੁਰ੍ਹੀਆਂ ਫੂਕਣ ਅਤੇ ਉਹ ਤੁਹਾਡੇ ਲਈ ਸਦਾ ਤੱਕ ਤੁਹਾਡੀ ਪੀੜ੍ਹੀਓਂ ਪੀੜ੍ਹੀ ਲਈ ਇੱਕ ਬਿਧੀ ਹੋਵੇ। ");
INSERT INTO pan_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","ਜਦ ਤੁਸੀਂ ਆਪਣੇ ਦੇਸ ਵਿੱਚ ਆਪਣੇ ਵੈਰੀਆਂ ਦੇ ਵਿਰੁੱਧ, ਜਿਹੜੇ ਤੁਹਾਨੂੰ ਸਤਾਉਂਦੇ ਹਨ ਯੁੱਧ ਕਰਨ ਲਈ ਜਾਓ ਤਾਂ ਤੁਸੀਂ ਤੁਰ੍ਹੀਆਂ ਨੂੰ ਸਾਹ ਖਿੱਚ ਕੇ ਫੂਕੋ, ਫੇਰ ਤੁਸੀਂ ਯਹੋਵਾਹ ਆਪਣੇ ਪਰਮੇਸ਼ੁਰ ਅੱਗੇ ਯਾਦ ਕੀਤੇ ਜਾਓਗੇ ਅਤੇ ਤੁਸੀਂ ਆਪਣੇ ਵੈਰੀਆਂ ਤੋਂ ਬਚਾਏ ਜਾਓਗੇ। ");
INSERT INTO pan_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","ਆਪਣੇ ਅਨੰਦ ਦੇ ਦਿਨ, ਆਪਣੇ ਠਹਿਰਾਏ ਹੋਏ ਪਰਬਾਂ ਅਤੇ ਆਪਣੇ ਮਹੀਨਿਆਂ ਦੇ ਅਰੰਭ ਵਿੱਚ ਆਪਣੇ ਹੋਮ ਦੀਆਂ ਭੇਟਾਂ ਅਤੇ ਸੁੱਖ-ਸਾਂਦ ਦੀਆਂ ਬਲੀਆਂ ਉੱਤੇ ਤੁਰ੍ਹੀਆਂ ਨੂੰ ਫੂਕੋ ਅਤੇ ਉਹ ਤੁਹਾਡੇ ਲਈ ਤੁਹਾਡੇ ਪਰਮੇਸ਼ੁਰ ਅੱਗੇ ਇੱਕ ਯਾਦਗਾਰੀ ਠਹਿਰਨ। ਮੈਂ ਯਹੋਵਾਹ ਤੁਹਾਡਾ ਪਰਮੇਸ਼ੁਰ ਹਾਂ। ");
INSERT INTO pan_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","ਫੇਰ ਅਜਿਹਾ ਹੋਇਆ ਕਿ ਦੂਜੇ ਸਾਲ ਦੇ ਦੂਜੇ ਮਹੀਨੇ ਦੇ ਵੀਹਵੇਂ ਦਿਨ ਉਹ ਬੱਦਲ ਸਾਖੀ ਦੇ ਡੇਰੇ ਦੇ ਉੱਤੋਂ ਚੁੱਕਿਆ ਗਿਆ। ");
INSERT INTO pan_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","ਤਾਂ ਇਸਰਾਏਲੀਆਂ ਨੇ ਸੀਨਈ ਦੀ ਉਜਾੜ ਤੋਂ ਆਪਣੇ ਸਫ਼ਰ ਲਈ ਕੂਚ ਕੀਤਾ ਅਤੇ ਬੱਦਲ ਪਾਰਾਨ ਨਾਮਕ ਉਜਾੜ ਵਿੱਚ ਠਹਿਰ ਗਿਆ। ");
INSERT INTO pan_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","ਸੋ ਉਨ੍ਹਾਂ ਨੇ ਯਹੋਵਾਹ ਦੇ ਹੁਕਮ ਨਾਲ ਜਿਹੜਾ ਮੂਸਾ ਦੇ ਰਾਹੀਂ ਆਇਆ ਸੀ, ਪਹਿਲਾਂ ਕੂਚ ਕੀਤਾ। ");
INSERT INTO pan_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","ਅਤੇ ਸਭ ਤੋਂ ਪਹਿਲਾਂ ਯਹੂਦਾਹ ਦੇ ਡੇਰੇ ਦੇ ਝੰਡੇ ਦਾ ਕੂਚ ਹੋਇਆ, ਉਹ ਦਲ ਬਣਾ ਕੇ ਚੱਲੇ, ਅਤੇ ਉਸ ਦਾ ਸੈਨਾਪਤੀ ਅੰਮੀਨਾਦਾਬ ਦਾ ਪੁੱਤਰ ਨਹਸ਼ੋਨ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","ਯਿੱਸਾਕਾਰ ਦੇ ਗੋਤ ਦਾ ਸੈਨਾਪਤੀ ਸੂਆਰ ਦਾ ਪੁੱਤਰ ਨਥਨਿਏਲ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","ਅਤੇ ਜ਼ਬੂਲੁਨ ਦੇ ਗੋਤ ਦਾ ਸੈਨਾਪਤੀ ਹੇਲੋਨ ਦਾ ਪੁੱਤਰ ਅਲੀਆਬ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","ਫੇਰ ਡੇਰਾ ਉਤਾਰਿਆ ਗਿਆ ਅਤੇ ਗੇਰਸ਼ੋਨੀਆਂ ਅਤੇ ਮਰਾਰੀਆਂ ਨੇ ਜੋ ਡੇਰੇ ਨੂੰ ਚੁੱਕਦੇ ਸਨ, ਕੂਚ ਕੀਤਾ। ");
INSERT INTO pan_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","ਫੇਰ ਰਊਬੇਨ ਦੇ ਡੇਰੇ ਦੇ ਝੰਡੇ ਦਾ ਕੂਚ ਹੋਇਆ ਉਹ ਦਲ ਬਣਾ ਕੇ ਚੱਲੇ ਅਤੇ ਉਨ੍ਹਾਂ ਦਾ ਸੈਨਾਪਤੀ ਸ਼ਦੇਊਰ ਦਾ ਪੁੱਤਰ ਅਲੀਸੂਰ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","ਸ਼ਿਮਓਨ ਦੇ ਗੋਤ ਦਾ ਸੈਨਾਪਤੀ ਸੂਰੀਸ਼ਦਾਈ ਦਾ ਪੁੱਤਰ ਸ਼ਲੁਮੀਏਲ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","ਅਤੇ ਗਾਦ ਦੇ ਗੋਤ ਦਾ ਸੈਨਾਪਤੀ ਦਊਏਲ ਦਾ ਪੁੱਤਰ ਅਲਯਾਸਾਫ਼ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","ਫੇਰ ਕਹਾਥੀਆਂ ਨੇ ਡੇਰੇ ਨੂੰ ਚੁੱਕ ਕੇ ਕੂਚ ਕੀਤਾ ਅਤੇ ਦੂਜਿਆਂ ਨੇ ਉਨ੍ਹਾਂ ਦੇ ਆਉਣ ਤੱਕ ਡੇਰੇ ਨੂੰ ਖੜ੍ਹਾ ਕਰ ਲਿਆ। ");
INSERT INTO pan_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","ਫੇਰ ਇਫ਼ਰਾਈਮੀਆਂ ਦੇ ਡੇਰੇ ਦੇ ਝੰਡੇ ਦਾ ਕੂਚ ਹੋਇਆ, ਉਹ ਦਲ ਬਣਾ ਕੇ ਚੱਲੇ ਅਤੇ ਉਨ੍ਹਾਂ ਦਾ ਸੈਨਾਪਤੀ ਅੰਮੀਹੂਦ ਦਾ ਪੁੱਤਰ ਅਲੀਸ਼ਾਮਾ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","ਮਨੱਸ਼ਹ ਦੇ ਗੋਤ ਦਾ ਸੈਨਾਪਤੀ ਪਦਾਹਸੂਰ ਦਾ ਪੁੱਤਰ ਗਮਲੀਏਲ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","ਬਿਨਯਾਮੀਨ ਦੇ ਗੋਤ ਦਾ ਸੈਨਾਪਤੀ ਗਿਦਓਨੀ ਦਾ ਪੁੱਤਰ ਅਬੀਦਾਨ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","ਫੇਰ ਦਾਨ ਦੇ ਡੇਰੇ ਦੇ ਝੰਡੇ ਦਾ ਕੂਚ ਹੋਇਆ ਜਿਹੜਾ ਸਾਰੇ ਡੇਰਿਆਂ ਤੋਂ ਪਿੱਛੇ ਸੀ, ਉਹ ਦਲ ਬਣਾ ਕੇ ਚੱਲੇ ਅਤੇ ਉਨ੍ਹਾਂ ਦਾ ਸੈਨਾਪਤੀ ਅੰਮੀਸ਼ੱਦਾਈ ਦਾ ਪੁੱਤਰ ਅਹੀਅਜ਼ਰ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","ਅਤੇ ਆਸ਼ੇਰ ਦੇ ਗੋਤ ਦਾ ਸੈਨਾਪਤੀ ਆਕਰਾਨ ਦਾ ਪੁੱਤਰ ਪਗੀਏਲ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","ਅਤੇ ਨਫ਼ਤਾਲੀ ਦੇ ਗੋਤ ਦਾ ਸੈਨਾਪਤੀ ਏਨਾਨ ਦਾ ਪੁੱਤਰ ਅਹੀਰਾ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","ਇਹ ਇਸਰਾਏਲੀ ਇਸੇ ਤਰ੍ਹਾਂ ਹੀ ਆਪਣੇ-ਆਪਣੇ ਦਲਾਂ ਦੇ ਅਨੁਸਾਰ ਕੂਚ ਕਰਦੇ ਸਨ ਅਤੇ ਅੱਗੇ ਵਧਿਆ ਕਰਦੇ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","ਮੂਸਾ ਨੇ ਆਪਣੇ ਸਹੁਰੇ ਰਊਏਲ ਮਿਦਯਾਨੀ ਦੇ ਪੁੱਤਰ ਹੋਬਾਬ ਨੂੰ ਆਖਿਆ ਕਿ ਅਸੀਂ ਉਸ ਥਾਂ ਨੂੰ ਜਿਹੜਾ ਯਹੋਵਾਹ ਨੇ ਸਾਨੂੰ ਦੇਣ ਨੂੰ ਆਖਿਆ ਹੈ ਕੂਚ ਕਰ ਰਹੇ ਹਾਂ। ਤੂੰ ਸਾਡੇ ਨਾਲ ਚੱਲ ਅਤੇ ਅਸੀਂ ਤੇਰੇ ਨਾਲ ਭਲਿਆਈ ਕਰਾਂਗੇ ਕਿਉਂ ਜੋ ਯਹੋਵਾਹ ਨੇ ਇਸਰਾਏਲ ਲਈ ਭਲਿਆਈ ਕਰਨ ਦੀ ਗੱਲ ਕੀਤੀ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","ਉਸ ਨੇ ਆਖਿਆ, ਮੈਂ ਨਹੀਂ ਜਾਂਵਾਂਗਾ ਸਗੋਂ ਮੈਂ ਆਪਣੇ ਦੇਸ ਅਤੇ ਆਪਣੇ ਰਿਸ਼ਤੇਦਾਰਾਂ ਵਿੱਚ ਜਾਂਵਾਂਗਾ। ");
INSERT INTO pan_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","ਤਾਂ ਮੂਸਾ ਨੇ ਆਖਿਆ, ਸਾਨੂੰ ਨਾ ਛੱਡ ਕਿਉਂ ਜੋ ਤੂੰ ਜਾਣਦਾ ਹੈਂ ਕਿ ਅਸੀਂ ਉਜਾੜ ਵਿੱਚ ਕਿਵੇਂ ਡੇਰੇ ਲਾਈਏ ਅਤੇ ਤੂੰ ਸਾਡੇ ਲਈ ਅੱਖਾਂ ਦਾ ਕੰਮ ਦੇਵੇਂਗਾ। ");
INSERT INTO pan_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","ਅਤੇ ਅਜਿਹਾ ਹੋਵੇਗਾ ਕਿ ਜੇਕਰ ਤੂੰ ਸਾਡੇ ਨਾਲ ਚੱਲੇ ਤਾਂ ਜਿਹੜੀ ਭਲਿਆਈ ਯਹੋਵਾਹ ਸਾਡੇ ਨਾਲ ਕਰੇਗਾ ਉਹੀ ਭਲਿਆਈ ਅਸੀਂ ਵੀ ਤੇਰੇ ਨਾਲ ਕਰਾਂਗੇ। ");
INSERT INTO pan_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","ਫੇਰ ਇਸਰਾਏਲੀਆਂ ਨੇ ਯਹੋਵਾਹ ਦੇ ਪਰਬਤ ਤੋਂ ਤਿੰਨ ਦਿਨਾਂ ਦਾ ਸਫ਼ਰ ਕੀਤਾ ਅਤੇ ਉਨ੍ਹਾਂ ਲਈ ਵਿਸ਼ਰਾਮ ਦੀ ਥਾਂ ਲੱਭਣ ਲਈ ਯਹੋਵਾਹ ਦੇ ਨੇਮ ਦੇ ਸੰਦੂਕ ਨੇ ਵੀ ਉਨ੍ਹਾਂ ਦੇ ਅੱਗੇ-ਅੱਗੇ ਤਿੰਨ ਦਿਨਾਂ ਦਾ ਸਫ਼ਰ ਕੀਤਾ। ");
INSERT INTO pan_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","ਜਦ ਉਹ ਡੇਰੇ ਤੋਂ ਕੂਚ ਕਰਦੇ ਸਨ ਤਾਂ ਦਿਨ ਦੇ ਵੇਲੇ ਯਹੋਵਾਹ ਦਾ ਬੱਦਲ ਉਨ੍ਹਾਂ ਦੇ ਉੱਤੇ ਹੁੰਦਾ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","ਇਸ ਤਰ੍ਹਾਂ ਹੁੰਦਾ ਸੀ, ਕਿ ਜਦ ਸੰਦੂਕ ਦਾ ਕੂਚ ਹੁੰਦਾ ਸੀ ਤਾਂ ਮੂਸਾ ਆਖਦਾ ਸੀ “ਹੇ ਯਹੋਵਾਹ, ਉੱਠ ਅਤੇ ਤੇਰੇ ਵੈਰੀ ਖਿੱਲਰ ਜਾਣ ਅਤੇ ਤੇਰੇ ਤੋਂ ਘਿਣ ਕਰਨ ਵਾਲੇ ਤੇਰੇ ਅੱਗੋਂ ਭੱਜ ਜਾਣ।” ");
INSERT INTO pan_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","ਅਤੇ ਜਦ ਸੰਦੂਕ ਠਹਿਰਦਾ ਸੀ ਤਾਂ ਮੂਸਾ ਕਹਿੰਦਾ ਹੁੰਦਾ ਸੀ, “ਹੇ ਯਹੋਵਾਹ, ਇਸਰਾਏਲ ਦੇ ਲੱਖਾਂ ਹਜ਼ਾਰਾਂ ਵਿੱਚ ਮੁੜ ਆ।” ");
INSERT INTO pan_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","ਹੁਣ ਪਰਜਾ ਦੇ ਲੋਕ ਯਹੋਵਾਹ ਦੇ ਸੁਣਦੇ ਹੋਏ ਬੁੜ-ਬੁੜਾਉਣ ਲੱਗੇ। ਯਹੋਵਾਹ ਨੇ ਸੁਣਿਆ ਤਾਂ ਉਸ ਦਾ ਕ੍ਰੋਧ ਭੜਕ ਉੱਠਿਆ ਅਤੇ ਯਹੋਵਾਹ ਦੀ ਅੱਗ ਉਨ੍ਹਾਂ ਦੇ ਵਿਚਕਾਰ ਬਲ ਉੱਠੀ ਅਤੇ ਡੇਰੇ ਦੀਆਂ ਹੱਦਾਂ ਉੱਤੇ ਉਨ੍ਹਾਂ ਨੂੰ ਭਸਮ ਕਰਨ ਲੱਗੀ। ");
INSERT INTO pan_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","ਫੇਰ ਪਰਜਾ ਨੇ ਮੂਸਾ ਅੱਗੇ ਦੁਹਾਈ ਦਿੱਤੀ ਅਤੇ ਮੂਸਾ ਨੇ ਯਹੋਵਾਹ ਅੱਗੇ ਬੇਨਤੀ ਕੀਤੀ ਤਾਂ ਅੱਗ ਬੁਝ ਗਈ। ");
INSERT INTO pan_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","ਇਸ ਲਈ ਉਸ ਥਾਂ ਦਾ ਨਾਮ ਤਬਏਰਾਹ ਪੈ ਗਿਆ ਕਿਉਂ ਜੋ ਯਹੋਵਾਹ ਦੀ ਅੱਗ ਉਨ੍ਹਾਂ ਵਿੱਚ ਬਲ ਉੱਠੀ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","ਫੇਰ ਰਲੀ ਮਿਲੀ ਭੀੜ ਜਿਹੜੀ ਉਨ੍ਹਾਂ ਨਾਲ ਸੀ ਬਹੁਤ ਹਾਬੜ ਗਈ ਅਤੇ ਇਸਰਾਏਲੀ ਰੋਏ ਅਤੇ ਆਖਣ ਲੱਗੇ, ਕੌਣ ਸਾਨੂੰ ਮਾਸ ਕੌਣ ਖਾਣ ਲਈ ਦੇਵੇਗਾ? ");
INSERT INTO pan_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","ਅਸੀਂ ਉਨ੍ਹਾਂ ਮੱਛੀਆਂ ਨੂੰ ਚੇਤੇ ਕਰਦੇ ਹਾਂ ਜਿਹੜੀਆਂ ਅਸੀਂ ਮਿਸਰ ਵਿੱਚ ਮੁਫ਼ਤ ਖਾਂਦੇ ਸੀ ਅਤੇ ਖੀਰੇ, ਖ਼ਰਬੂਜੇ, ਹਰਾ ਪਿਆਜ਼, ਪਿਆਜ਼ ਅਤੇ ਲੱਸਣ। ");
INSERT INTO pan_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","ਪਰ ਹੁਣ ਸਾਡੀ ਭੁੱਖ ਮਰ ਗਈ ਹੈ। ਹੁਣ ਤਾਂ ਸਾਨੂੰ ਮੰਨੇ ਤੋਂ ਇਲਾਵਾ ਕੁਝ ਵੀ ਨਹੀਂ ਦਿਸਦਾ! ");
INSERT INTO pan_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","ਉਹ ਮੰਨਾ ਤਾਂ ਧਨੀਏ ਵਰਗਾ ਸੀ ਅਤੇ ਦੇਖਣ ਵਿੱਚ ਮੋਤੀ ਦੀ ਤਰ੍ਹਾਂ ਦਿਸਦਾ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","ਲੋਕ ਇੱਧਰ-ਉੱਧਰ ਜਾ ਕੇ ਉਸ ਨੂੰ ਇਕੱਠਾ ਕਰਕੇ ਉਸ ਨੂੰ ਚੱਕੀ ਵਿੱਚ ਪੀਂਹਦੇ, ਓਖਲੀ ਵਿੱਚ ਕੁੱਟਦੇ ਸਨ, ਫੇਰ ਉਸ ਨੂੰ ਤਵੀਆਂ ਉੱਤੇ ਤਲ ਕੇ ਉਸ ਦੇ ਫੁਲਕੇ ਬਣਾ ਲੈਂਦੇ ਸਨ ਅਤੇ ਉਹ ਦਾ ਸੁਆਦ ਤੇਲ ਵਿੱਚ ਤਲੀਆਂ ਹੋਈਆਂ ਪੂੜੀਆਂ ਵਰਗਾ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","ਜਦ ਰਾਤ ਨੂੰ ਡੇਰੇ ਉੱਤੇ ਤ੍ਰੇਲ ਪੈਂਦੀ ਸੀ ਤਦ ਮੰਨਾ ਵੀ ਉਸ ਨਾਲ ਉਤਰਦਾ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","ਮੂਸਾ ਨੇ ਪਰਜਾ ਵਿੱਚੋਂ ਹਰ ਮਨੁੱਖ ਨੂੰ ਆਪਣੇ ਪਰਿਵਾਰ ਨਾਲ ਆਪੋ ਆਪਣੇ ਤੰਬੂ ਦੇ ਦਰਵਾਜ਼ੇ ਵਿੱਚ ਰੋਂਦੇ ਸੁਣਿਆ ਤਾਂ ਯਹੋਵਾਹ ਦਾ ਕ੍ਰੋਧ ਬਹੁਤ ਭੜਕਿਆ ਅਤੇ ਮੂਸਾ ਇਸ ਗੱਲ ਤੋਂ ਪਰੇਸ਼ਾਨ ਹੋਇਆ। ");
INSERT INTO pan_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","ਤਦ ਮੂਸਾ ਨੇ ਯਹੋਵਾਹ ਨੂੰ ਪੁੱਛਿਆ, ਤੂੰ ਆਪਣੇ ਦਾਸ ਉੱਤੇ ਇਹ ਬਿਪਤਾ ਕਿਉਂ ਲਿਆਂਦੀ ਹੈ? ਤੇਰੀ ਕਿਰਪਾ ਦੀ ਨਿਗਾਹ ਮੇਰੇ ਉੱਤੇ ਕਿਉਂ ਨਹੀਂ ਰਹੀ? ਜੋ ਤੂੰ ਇਸ ਸਾਰੀ ਪਰਜਾ ਦਾ ਭਾਰ ਮੇਰੇ ਉੱਤੇ ਪਾਉਂਦਾ ਹੈ? ");
INSERT INTO pan_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","ਕੀ ਮੈਂ ਹੀ ਇਸ ਪਰਜਾ ਨੂੰ ਗਰਭ ਵਿੱਚ ਲਿਆ? ਕੀ ਮੈਂ ਹੀ ਉਨ੍ਹਾਂ ਨੂੰ ਜੰਮਿਆ ਜੋ ਤੂੰ ਮੈਨੂੰ ਆਖਦਾ ਹੈ ਕਿ ਉਨ੍ਹਾਂ ਨੂੰ ਆਪਣੀ ਛਾਤੀ ਉੱਤੇ ਚੁੱਕ ਕੇ ਲਈ ਫਿਰ, ਜਿਵੇਂ ਪਿਤਾ ਦੁੱਧ ਪੀਂਦੇ ਬੱਚੇ ਨੂੰ ਚੁੱਕੀ ਫਿਰਦਾ ਹੈ ਤੇ ਇਨ੍ਹਾਂ ਨੂੰ ਉਸ ਦੇਸ ਨੂੰ ਲੈ ਜਾਂਵਾਂ, ਜਿਸ ਦੇ ਦੇਣ ਦੀ ਸਹੁੰ ਤੂੰ ਉਨ੍ਹਾਂ ਦੇ ਪੁਰਖਿਆਂ ਨਾਲ ਖਾਧੀ ਹੈ? ");
INSERT INTO pan_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","ਮੈਂ ਐਨਾ ਮਾਸ ਕਿੱਥੋਂ ਲਿਆਵਾਂ ਕਿ ਮੈਂ ਇਸ ਸਾਰੀ ਪਰਜਾ ਨੂੰ ਖਾਣ ਲਈ ਦੇਵਾਂ? ਕਿਉਂ ਜੋ ਉਹ ਇਹ ਆਖ ਕੇ ਮੇਰੇ ਅੱਗੇ ਰੋਂਦੇ ਹਨ ਕਿ ਸਾਨੂੰ ਮਾਸ ਦੇ, ਤਾਂ ਜੋ ਅਸੀਂ ਖਾਈਏ। ");
INSERT INTO pan_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","ਮੈਂ ਇਕੱਲਾ ਇਸ ਸਾਰੀ ਪਰਜਾ ਨੂੰ ਨਹੀਂ ਸੰਭਾਲ ਸਕਦਾ, ਕਿਉਂ ਜੋ ਇਹ ਮੇਰੇ ਸਹਿਣ ਤੋਂ ਬਾਹਰ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","ਜੇਕਰ ਤੂੰ ਮੇਰੇ ਨਾਲ ਅਜਿਹਾ ਹੀ ਕਰਨਾ ਹੈ, ਜੇ ਤੇਰੀ ਕਿਰਪਾ ਦੀ ਨਿਗਾਹ ਮੇਰੇ ਉੱਤੇ ਹੈ, ਤਾਂ ਮੈਨੂੰ ਮਾਰ ਸੁੱਟ ਕਿ ਮੈਂ ਆਪਣੀ ਦੁਰਦਸ਼ਾ ਨਾ ਵੇਖਾਂ! ");
INSERT INTO pan_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਆਖਿਆ, ਮੇਰੇ ਲਈ ਇਸਰਾਏਲ ਦੇ ਬਜ਼ੁਰਗਾਂ ਵਿੱਚੋਂ ਸੱਤਰ ਇਹੋ ਜਿਹੇ ਮਨੁੱਖ ਇਕੱਠੇ ਕਰ, ਜਿਨ੍ਹਾਂ ਨੂੰ ਤੂੰ ਜਾਣਦਾ ਹੈਂ ਕਿ ਉਹ ਪਰਜਾ ਦੇ ਬਜ਼ੁਰਗ ਅਤੇ ਪ੍ਰਧਾਨ ਹਨ ਅਤੇ ਉਨ੍ਹਾਂ ਨੂੰ ਮੰਡਲੀ ਦੇ ਤੰਬੂ ਕੋਲ ਲਿਆ ਕਿ ਉਹ ਤੇਰੇ ਨਾਲ ਉੱਥੇ ਖੜ੍ਹੇ ਹੋ ਜਾਣ। ");
INSERT INTO pan_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","ਤਦ ਮੈਂ ਉਤਰ ਕੇ ਤੇਰੇ ਨਾਲ ਉੱਥੇ ਗੱਲਾਂ ਕਰਾਂਗਾ ਅਤੇ ਮੈਂ ਉਸ ਆਤਮਾ ਤੋਂ ਲੈ ਕੇ ਜਿਹੜਾ ਤੇਰੇ ਉੱਤੇ ਹੈ, ਉਨ੍ਹਾਂ ਉੱਤੇ ਪਾਵਾਂਗਾ ਅਤੇ ਉਹ ਤੇਰੇ ਨਾਲ ਪਰਜਾ ਦਾ ਭਾਰ ਚੁੱਕਣਗੇ ਤਾਂ ਜੋ ਤੈਨੂੰ ਇਕੱਲੇ ਨੂੰ ਚੁੱਕਣਾ ਨਾ ਪਵੇ। ");
INSERT INTO pan_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","ਅਤੇ ਪਰਜਾ ਨੂੰ ਆਖ ਕਿ ਕੱਲ ਲਈ ਆਪਣੇ ਆਪ ਨੂੰ ਪਵਿੱਤਰ ਕਰੋ, ਤਦ ਤੁਹਾਨੂੰ ਮਾਸ ਖਾਣ ਲਈ ਮਿਲੇਗਾ, ਕਿਉਂ ਜੋ ਤੁਸੀਂ ਯਹੋਵਾਹ ਦੇ ਸੁਣਨ ਵਿੱਚ ਇਹ ਆਖ ਕੇ ਰੋਂਦੇ ਸੀ ਕਿ ਕੌਣ ਸਾਨੂੰ ਮਾਸ ਖੁਆਵੇਗਾ? ਅਸੀਂ ਮਿਸਰ ਵਿੱਚ ਸੁਖਾਲੇ ਸੀ। ਇਸ ਲਈ ਯਹੋਵਾਹ ਤੁਹਾਨੂੰ ਮਾਸ ਦੇਵੇਗਾ ਅਤੇ ਤੁਸੀਂ ਖਾਓਗੇ। ");
INSERT INTO pan_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","ਫਿਰ ਇੱਕ ਦਿਨ, ਦੋ ਦਿਨ, ਪੰਜ ਦਿਨ, ਦਸ ਦਿਨ, ਜਾਂ ਵੀਹ ਦਿਨ ਤੱਕ ਨਹੀਂ, ");
INSERT INTO pan_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","ਪਰ ਸਾਰਾ ਮਹੀਨਾ ਖਾਂਦੇ ਰਹੋਗੇ, ਜਦ ਤੱਕ ਉਹ ਤੁਹਾਡੀਆਂ ਨਾਸਾਂ ਦੇ ਵਿੱਚੋਂ ਦੀ ਬਾਹਰ ਨਾ ਨਿੱਕਲੇ ਅਤੇ ਉਹ ਤੁਹਾਡੇ ਲਈ ਘਿਣਾਉਣਾ ਨਾ ਹੋ ਜਾਵੇ, ਕਿਉਂ ਜੋ ਤੁਸੀਂ ਯਹੋਵਾਹ ਨੂੰ ਜਿਹੜਾ ਤੁਹਾਡੇ ਵਿੱਚ ਹੈ, ਤੁੱਛ ਗਿਣਿਆ ਹੈ ਅਤੇ ਤੁਸੀਂ ਉਹ ਦੇ ਅੱਗੇ ਇਹ ਆਖ ਕੇ ਰੋਂਦੇ ਸੀ ਕਿ ਅਸੀਂ ਮਿਸਰ ਵਿੱਚੋਂ ਕਿਉਂ ਬਾਹਰ ਆਏ? ");
INSERT INTO pan_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","ਤਦ ਮੂਸਾ ਨੇ ਆਖਿਆ ਕਿ ਇਹ ਪਰਜਾ ਜਿਸ ਦੇ ਵਿੱਚ ਮੈਂ ਹਾਂ, ਛੇ ਲੱਖ ਪਿਆਦੇ ਹੀ ਹਨ ਅਤੇ ਤੂੰ ਮੈਨੂੰ ਆਖਦਾ ਹੈਂ ਕਿ ਮੈਂ ਉਨ੍ਹਾਂ ਨੂੰ ਮਾਸ ਦਿਆਂਗਾ ਅਤੇ ਉਹ ਪੂਰਾ ਮਹੀਨਾ ਖਾਣਗੇ! ");
INSERT INTO pan_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","ਕੀ ਉਹ ਇੱਜੜ ਅਤੇ ਵੱਗ ਉਨ੍ਹਾਂ ਲਈ ਮਾਰੇ ਜਾਣ ਜੋ ਉਨ੍ਹਾਂ ਨੂੰ ਮਾਸ ਮਿਲੇ? ਜਾਂ ਸਮੁੰਦਰ ਦੀਆਂ ਸਾਰੀਆਂ ਮੱਛੀਆਂ ਉਨ੍ਹਾਂ ਲਈ ਇਕੱਠੀਆਂ ਕੀਤੀਆਂ ਜਾਣ ਜੋ ਉਨ੍ਹਾਂ ਨੂੰ ਮਾਸ ਮਿਲੇ? ");
INSERT INTO pan_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਆਖਿਆ, ਕੀ ਯਹੋਵਾਹ ਦਾ ਹੱਥ ਛੋਟਾ ਹੋ ਗਿਆ ਹੈ? ਹੁਣ, ਤੂੰ ਵੇਖੇਂਗਾ ਕਿ ਮੇਰੀ ਗੱਲ ਤੇਰੇ ਲਈ ਪੂਰੀ ਹੈ ਜਾਂ ਨਹੀਂ! ");
INSERT INTO pan_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","ਫੇਰ ਮੂਸਾ ਨੇ ਬਾਹਰ ਜਾ ਕੇ ਯਹੋਵਾਹ ਦੀਆਂ ਗੱਲਾਂ ਪਰਜਾ ਨੂੰ ਸੁਣਾਈਆਂ ਅਤੇ ਉਸ ਨੇ ਸੱਤਰ ਮਨੁੱਖ, ਜਿਹੜੇ ਪਰਜਾ ਦੇ ਬਜ਼ੁਰਗ ਸਨ, ਇਕੱਠੇ ਕਰਕੇ ਉਹਨਾਂ ਨੂੰ ਤੰਬੂ ਦੇ ਆਲੇ-ਦੁਆਲੇ ਖੜ੍ਹਾ ਕੀਤਾ। ");
INSERT INTO pan_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","ਤਦ ਯਹੋਵਾਹ ਬੱਦਲ ਵਿੱਚ ਉਤਰਿਆ ਅਤੇ ਉਸ ਨੇ ਮੂਸਾ ਨਾਲ ਗੱਲ ਕੀਤੀ ਅਤੇ ਉਸ ਨੇ ਉਸ ਆਤਮਾ ਤੋਂ ਲੈ ਕੇ, ਜਿਹੜਾ ਉਹ ਦੇ ਉੱਤੇ ਸੀ, ਉਹਨਾਂ ਸੱਤਰ ਬਜ਼ੁਰਗ ਮਨੁੱਖਾਂ ਉੱਤੇ ਪਾ ਦਿੱਤਾ ਅਤੇ ਜਦ ਆਤਮਾ ਉਹਨਾਂ ਉੱਤੇ ਉਤਰਿਆ, ਤਦ ਉਹ ਭਵਿੱਖਬਾਣੀ ਕਰਨ ਲੱਗ ਪਏ ਪਰ ਇਸ ਤੋਂ ਬਾਅਦ ਉਹਨਾਂ ਨੇ ਦੁਬਾਰਾ ਭਵਿੱਖਬਾਣੀ ਨਾ ਕੀਤੀ। ");
INSERT INTO pan_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","ਪਰ ਡੇਰੇ ਵਿੱਚ ਦੋ ਮਨੁੱਖ ਰਹਿ ਗਏ, ਜਿਹਨਾਂ ਵਿੱਚੋਂ ਇੱਕ ਦਾ ਨਾਮ ਅਲਦਾਦ ਅਤੇ ਦੂਜੇ ਦਾ ਨਾਮ ਮੇਦਾਦ ਸੀ। ਆਤਮਾ ਉਨ੍ਹਾਂ ਉੱਤੇ ਵੀ ਉਤਰਿਆ ਅਤੇ ਇਹ ਵੀ ਉਹਨਾਂ ਵਿੱਚੋਂ ਸਨ ਜਿਹਨਾਂ ਦੇ ਨਾਮ ਲਿਖੇ ਗਏ ਸਨ, ਪਰ ਤੰਬੂ ਦੇ ਕੋਲ ਬਾਹਰ ਨਹੀਂ ਗਏ ਸਨ। ਉਹ ਡੇਰੇ ਵਿੱਚ ਹੀ ਭਵਿੱਖਬਾਣੀ ਕਰਨ ਲੱਗੇ। ");
INSERT INTO pan_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","ਤਾਂ ਇੱਕ ਜਵਾਨ ਨੇ ਭੱਜ ਕੇ ਮੂਸਾ ਨੂੰ ਦੱਸਿਆ ਅਤੇ ਆਖਿਆ ਕਿ ਅਲਦਾਦ ਅਤੇ ਮੇਦਾਦ ਡੇਰੇ ਵਿੱਚ ਭਵਿੱਖਬਾਣੀ ਕਰਦੇ ਹਨ! ");
INSERT INTO pan_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","ਤਦ ਨੂਨ ਦੇ ਪੁੱਤਰ ਯਹੋਸ਼ੁਆ ਨੇ ਜਿਹੜਾ ਮੂਸਾ ਦਾ ਸੇਵਕ ਅਤੇ ਉਸ ਦੇ ਚੁਣੇ ਹੋਇਆਂ ਵਿੱਚੋਂ ਸੀ, ਉਹ ਨੇ ਮੂਸਾ ਨੂੰ ਆਖਿਆ ਹੇ ਮੇਰੇ ਸੁਆਮੀ, ਉਨ੍ਹਾਂ ਨੂੰ ਮਨ੍ਹਾ ਕਰ ਦਿਓ! ");
INSERT INTO pan_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","ਮੂਸਾ ਨੇ ਆਖਿਆ, ਕੀ ਤੂੰ ਮੇਰੇ ਲਈ ਖਿਝਦਾ ਹੈਂ? ਕਾਸ਼ ਅਜਿਹਾ ਹੁੰਦਾ ਕਿ ਯਹੋਵਾਹ ਦੇ ਸਾਰੇ ਲੋਕ ਨਬੀ ਹੁੰਦੇ ਅਤੇ ਯਹੋਵਾਹ ਆਪਣਾ ਆਤਮਾ ਉਨ੍ਹਾਂ ਉੱਤੇ ਘੱਲਦਾ! ");
INSERT INTO pan_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","ਉਪਰੰਤ ਮੂਸਾ ਅਤੇ ਇਸਰਾਏਲ ਦੇ ਬਜ਼ੁਰਗ ਡੇਰੇ ਵੱਲ ਨੂੰ ਮੁੜੇ। ");
INSERT INTO pan_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","ਤਦ ਯਹੋਵਾਹ ਵੱਲੋਂ ਇੱਕ ਵੱਡੀ ਹਨੇਰੀ ਵਗੀ ਅਤੇ ਸਮੁੰਦਰੋਂ ਬਟੇਰੇ ਉਡਾ ਕੇ ਡੇਰੇ ਉੱਤੇ ਸੁੱਟ ਗਈ। ਉਹ ਇੱਕ ਦਿਨ ਦੇ ਪੈਂਡੇ ਤੱਕ ਇੱਧਰ ਅਤੇ ਇੱਕ ਦਿਨ ਦੇ ਪੈਂਡੇ ਤੱਕ ਉੱਧਰ ਡੇਰੇ ਦੇ ਆਲੇ-ਦੁਆਲੇ ਦੋ-ਦੋ ਹੱਥ ਤੇ ਜ਼ਮੀਨ ਦੀ ਪਰਤ ਉੱਤੇ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","ਤਦ ਪਰਜਾ ਨੇ ਉਸ ਸਾਰੇ ਦਿਨ ਅਤੇ ਸਾਰੀ ਰਾਤ ਅਤੇ ਸਾਰੇ ਦੂਜੇ ਦਿਨ ਉੱਠ ਕੇ ਉਨ੍ਹਾਂ ਬਟੇਰਿਆਂ ਨੂੰ ਇਕੱਠਾ ਕੀਤਾ ਅਤੇ ਜਿਸ ਘੱਟੋ-ਘੱਟ ਇਕੱਠੇ ਕੀਤੇ ਸਨ ਉਹ ਦੇ ਦਸ ਹੋਮਾਰ ਹੋਏ ਅਤੇ ਉਨ੍ਹਾਂ ਨੇ ਉਹਨਾਂ ਨੂੰ ਆਪਣੇ ਲਈ ਡੇਰੇ ਦੇ ਆਲੇ-ਦੁਆਲੇ ਖਿਲਾਰ ਦਿੱਤਾ। ");
INSERT INTO pan_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","ਜਦ ਉਹ ਮਾਸ ਅਜੇ ਉਨ੍ਹਾਂ ਦੇ ਦੰਦਾਂ ਵਿੱਚ ਹੀ ਸੀ ਅਤੇ ਉਹ ਨੂੰ ਚੱਬਿਆ ਵੀ ਨਹੀਂ ਸੀ ਤਦ ਯਹੋਵਾਹ ਦਾ ਕ੍ਰੋਧ ਪਰਜਾ ਉੱਤੇ ਭੜਕ ਉੱਠਿਆ ਅਤੇ ਯਹੋਵਾਹ ਨੇ ਪਰਜਾ ਨੂੰ ਅੱਤ ਵੱਡੀ ਬਵਾ ਨਾਲ ਮਾਰਿਆ। ");
INSERT INTO pan_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","ਉਪਰੰਤ ਉਨ੍ਹਾਂ ਨੇ ਉਸ ਥਾਂ ਦਾ ਨਾਮ ਕਿਬਰੋਥ-ਹੱਤਾਵਾਹ ਰੱਖਿਆ ਕਿਉਂ ਜੋ ਉੱਥੇ ਉਨ੍ਹਾਂ ਨੇ ਉਸ ਪਰਜਾ ਨੂੰ ਦੱਬਿਆ ਜਿਹਨਾਂ ਨੇ ਹੋਰ ਭੋਜਨ ਦੀ ਮੰਗ ਕੀਤੀ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","ਕਿਬਰੋਥ-ਹੱਤਾਵਾਹ ਤੋਂ ਇਸਰਾਏਲ ਨੇ ਹਸੇਰੋਥ ਨੂੰ ਕੂਚ ਕੀਤਾ ਅਤੇ ਹਸੇਰੋਥ ਵਿੱਚ ਠਹਿਰ ਗਏ। ");
INSERT INTO pan_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","ਮੂਸਾ ਨੇ ਇੱਕ ਕੂਸ਼ੀ ਇਸਤਰੀ ਨਾਲ ਵਿਆਹ ਕਰ ਲਿਆ ਸੀ। ਇਸ ਲਈ ਮਿਰਯਮ ਅਤੇ ਹਾਰੂਨ, ਉਸ ਕੂਸ਼ੀ ਇਸਤਰੀ ਨਾਲ ਵਿਆਹ ਕਰਵਾਉਣ ਦੇ ਕਾਰਨ ਮੂਸਾ ਦੀ ਬੁਰਾਈ ਕਰਨ ਲੱਗੇ, ");
INSERT INTO pan_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","ਉਨ੍ਹਾਂ ਨੇ ਆਖਿਆ ਕਿ ਭਲਾ, ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨਾਲ ਹੀ ਗੱਲਾਂ ਕੀਤੀਆਂ ਹਨ ਅਤੇ ਸਾਡੇ ਨਾਲ ਗੱਲਾਂ ਨਹੀਂ ਕੀਤੀਆਂ? ਯਹੋਵਾਹ ਨੇ ਉਹਨਾਂ ਦੀਆਂ ਇਹ ਗੱਲਾਂ ਨੂੰ ਸੁਣਿਆ, ");
INSERT INTO pan_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","ਹੁਣ ਮੂਸਾ ਸਾਰਿਆਂ ਆਦਮੀਆਂ ਨਾਲੋਂ ਜਿਹੜੇ ਧਰਤੀ ਉੱਤੇ ਵੱਸਦੇ ਸਨ, ਬਹੁਤ ਹੀ ਹਲੀਮ ਸੁਭਾਅ ਦਾ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","ਫੇਰ ਯਹੋਵਾਹ ਨੇ ਇਕਦਮ ਮੂਸਾ, ਹਾਰੂਨ ਅਤੇ ਮਿਰਯਮ ਨੂੰ ਆਖਿਆ, ਤੁਸੀਂ ਤਿੰਨੋਂ ਮੰਡਲੀ ਦੇ ਤੰਬੂ ਕੋਲ ਆ ਜਾਓ, ਤਦ ਉਹ ਤਿੰਨੇ ਬਾਹਰ ਗਏ। ");
INSERT INTO pan_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","ਤਦ ਯਹੋਵਾਹ ਬੱਦਲ ਦੇ ਥੰਮ੍ਹ ਵਿੱਚ ਉਤਰਿਆ ਅਤੇ ਤੰਬੂ ਦੇ ਦਰਵਾਜ਼ੇ ਉੱਤੇ ਖੜ੍ਹਾ ਹੋ ਗਿਆ ਅਤੇ ਹਾਰੂਨ ਅਤੇ ਮਿਰਯਮ ਨੂੰ ਸੱਦਿਆ ਤਾਂ ਉਹ ਦੋਵੇਂ ਬਾਹਰ ਆਏ। ");
INSERT INTO pan_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","ਉਸ ਨੇ ਆਖਿਆ, ਮੇਰੀਆਂ ਗੱਲਾਂ ਸੁਣੋ। ਜੇ ਤੁਹਾਡੇ ਵਿੱਚ ਕੋਈ ਨਬੀ ਹੋਵੇ ਤਾਂ ਮੈਂ ਯਹੋਵਾਹ ਆਪਣੇ ਆਪ ਨੂੰ ਦਰਸ਼ਣ ਵਿੱਚ ਉਸ ਉੱਤੇ ਪ੍ਰਗਟ ਕਰਾਂਗਾ ਜਾਂ ਸੁਫ਼ਨੇ ਵਿੱਚ ਮੈਂ ਉਸ ਨਾਲ ਬੋਲਾਂਗਾ। ");
INSERT INTO pan_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","ਪਰ ਮੇਰਾ ਦਾਸ ਮੂਸਾ ਇਹੋ ਜਿਹਾ ਨਹੀਂ। ਉਹ ਮੇਰੇ ਸਾਰੇ ਘਰ ਵਿੱਚ ਵਿਸ਼ਵਾਸਯੋਗ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","ਮੈਂ ਉਹ ਦੇ ਨਾਲ ਆਹਮੋ-ਸਾਹਮਣੇ ਖੁੱਲ੍ਹ ਕੇ ਗੱਲਾਂ ਕਰਾਂਗਾ, ਬੁਝਾਰਤਾਂ ਵਿੱਚ ਨਹੀਂ ਅਤੇ ਉਹ ਯਹੋਵਾਹ ਦਾ ਸਰੂਪ ਵੇਖੇਗਾ। ਫੇਰ ਤੁਸੀਂ ਮੇਰੇ ਦਾਸ ਮੂਸਾ ਦੇ ਵਿਰੁੱਧ ਬੋਲਣ ਤੋਂ ਕਿਉਂ ਨਾ ਡਰੇ? ");
INSERT INTO pan_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","ਤਦ ਯਹੋਵਾਹ ਦਾ ਕ੍ਰੋਧ ਉਨ੍ਹਾਂ ਉੱਤੇ ਭੜਕਿਆ ਅਤੇ ਉਹ ਚੱਲਿਆ ਗਿਆ। ");
INSERT INTO pan_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","ਜਦ ਬੱਦਲ ਤੰਬੂ ਦੇ ਉੱਤੋਂ ਉੱਠ ਗਿਆ ਤਾਂ ਵੇਖੋ ਮਿਰਯਮ ਕੋੜ੍ਹਨ ਅਤੇ ਬਰਫ਼ ਵਾਂਗੂੰ ਚਿੱਟੀ ਹੋ ਗਈ ਅਤੇ ਹਾਰੂਨ ਨੇ ਮਿਰਯਮ ਨੂੰ ਦੇਖਿਆ ਕਿ ਉਹ ਕੋੜ੍ਹਨ ਹੋ ਗਈ ਸੀ! ");
INSERT INTO pan_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","ਉਪਰੰਤ ਹਾਰੂਨ ਨੇ ਮੂਸਾ ਨੂੰ ਆਖਿਆ, ਹੇ ਮੇਰੇ ਸੁਆਮੀ ਜੀ, ਇਹ ਪਾਪ ਸਾਡੇ ਉੱਤੇ ਨਾ ਲਾਓ ਜੋ ਅਸੀਂ ਇਹ ਮੂਰਖਤਾਈ ਕੀਤੀ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","ਮਿਰਯਮ ਨੂੰ ਮਰੇ ਹੋਏ ਜਿਹਾ ਨਾ ਰਹਿਣ ਦੇ, ਜਿਸ ਦਾ ਸਰੀਰ ਜਮਾਂਦਰੂ ਹੀ ਅੱਧਾ ਗਲਿਆ ਹੋਇਆ ਹੋਵੇ। ");
INSERT INTO pan_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","ਤਦ ਮੂਸਾ ਨੇ ਯਹੋਵਾਹ ਅੱਗੇ ਦੁਹਾਈ ਦਿੱਤੀ ਕਿ ਹੇ ਪਰਮੇਸ਼ੁਰ, ਮੇਰੀ ਮਿੰਨਤ ਹੈ, ਉਹ ਨੂੰ ਚੰਗਾ ਕਰ। ");
INSERT INTO pan_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਆਖਿਆ, ਜੇ ਉਹ ਦੇ ਪਿਤਾ ਨੇ ਨਿਰਾ ਉਹ ਦੇ ਮੂੰਹ ਉੱਤੇ ਹੀ ਥੁੱਕਿਆ ਹੁੰਦਾ ਤਾਂ ਕੀ ਉਹ ਨੂੰ ਸੱਤਾਂ ਦਿਨਾਂ ਤੱਕ ਸ਼ਰਮ ਨਾ ਆਉਂਦੀ? ਇਸ ਲਈ ਉਹ ਸੱਤਾਂ ਦਿਨਾਂ ਤੱਕ ਡੇਰੇ ਤੋਂ ਬਾਹਰ ਰਹੇ ਅਤੇ ਉਹ ਮੁੜ੍ਹ ਅੰਦਰ ਨਾ ਆਵੇ। ");
INSERT INTO pan_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","ਇਸ ਲਈ ਮਿਰਯਮ ਸੱਤਾਂ ਦਿਨਾਂ ਤੱਕ ਡੇਰੇ ਤੋਂ ਬਾਹਰ ਰਹੀ, ਅਤੇ ਜਦ ਤੱਕ ਮਿਰਯਮ ਵਾਪਸ ਨਾ ਆਈ ਲੋਕਾਂ ਨੇ ਕੂਚ ਨਾ ਕੀਤਾ। ");
INSERT INTO pan_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","ਇਸ ਦੇ ਬਾਅਦ ਇਸਰਾਏਲ ਨੇ ਹਸੇਰੋਥ ਤੋਂ ਕੂਚ ਕੀਤਾ ਅਤੇ ਪਾਰਾਨ ਦੀ ਉਜਾੜ ਵਿੱਚ ਡੇਰੇ ਲਾਏ। ");
INSERT INTO pan_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਆਖਿਆ, ");
INSERT INTO pan_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","ਤੂੰ ਮਨੁੱਖਾਂ ਨੂੰ ਭੇਜ ਕਿ ਉਹ ਕਨਾਨ ਦੇਸ ਦਾ ਭੇਤ ਲੈਣ ਜਿਹੜਾ ਮੈਂ ਇਸਰਾਏਲੀਆਂ ਨੂੰ ਦਿੰਦਾ ਹਾਂ। ਉਨ੍ਹਾਂ ਦੇ ਪੁਰਖਿਆਂ ਦੀਆਂ ਗੋਤਾਂ ਤੋਂ ਇੱਕ-ਇੱਕ ਮਨੁੱਖ ਜਿਹੜਾ ਉਨ੍ਹਾਂ ਵਿੱਚ ਪ੍ਰਧਾਨ ਹੋਵੇ ਤੁਸੀਂ ਉਸ ਨੂੰ ਭੇਜੋ। ");
INSERT INTO pan_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","ਤਦ ਮੂਸਾ ਨੇ ਉਨ੍ਹਾਂ ਨੂੰ ਪਾਰਾਨ ਦੇ ਨਾਮ ਦੀ ਉਜਾੜ ਤੋਂ ਯਹੋਵਾਹ ਦੇ ਹੁਕਮ ਅਨੁਸਾਰ ਭੇਜਿਆ। ਇਹ ਸਾਰੇ ਮਨੁੱਖ ਇਸਰਾਏਲੀਆਂ ਦੇ ਮੁਖੀਏ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","ਅਤੇ ਉਹਨਾਂ ਦੇ ਨਾਮ ਇਹ ਸਨ - ਰਊਬੇਨ ਦੇ ਗੋਤ ਤੋਂ ਜ਼ੱਕੂਰ ਦਾ ਪੁੱਤਰ ਸ਼ੰਮੂਆ। ");
INSERT INTO pan_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","ਸ਼ਿਮਓਨ ਦੇ ਗੋਤ ਤੋਂ ਹੋਰੀ ਦਾ ਪੁੱਤਰ ਸ਼ਾਫਾਟ। ");
INSERT INTO pan_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","ਯਹੂਦਾਹ ਦੇ ਗੋਤ ਤੋਂ ਯਫ਼ੁੰਨਹ ਦਾ ਪੁੱਤਰ ਕਾਲੇਬ। ");
INSERT INTO pan_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","ਯਿੱਸਾਕਾਰ ਦੇ ਗੋਤ ਤੋਂ ਯੂਸੁਫ਼ ਦਾ ਪੁੱਤਰ ਯਿਗਾਲ। ");
INSERT INTO pan_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","ਇਫ਼ਰਾਈਮ ਦੇ ਗੋਤ ਤੋਂ ਨੂਨ ਦਾ ਪੁੱਤਰ ਹੋਸ਼ੇਆ। ");
INSERT INTO pan_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","ਬਿਨਯਾਮੀਨ ਦੇ ਗੋਤ ਤੋਂ ਰਾਫ਼ੂ ਦਾ ਪੁੱਤਰ ਪਲਟੀ। ");
INSERT INTO pan_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","ਜ਼ਬੂਲੁਨ ਦੇ ਗੋਤ ਤੋਂ ਸੋਦੀ ਦਾ ਪੁੱਤਰ ਗੱਦੀਏਲ। ");
INSERT INTO pan_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","ਯੂਸੁਫ਼ ਦੇ ਗੋਤ ਤੋਂ ਅਰਥਾਤ ਮਨੱਸ਼ਹ ਦੇ ਗੋਤ ਤੋਂ ਸੂਸੀ ਦਾ ਪੁੱਤਰ ਗੱਦੀ। ");
INSERT INTO pan_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","ਦਾਨ ਦੇ ਗੋਤ ਤੋਂ ਗਮੱਲੀ ਦਾ ਪੁੱਤਰ ਅੰਮੀਏਲ। ");
INSERT INTO pan_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","ਆਸ਼ੇਰ ਦੇ ਗੋਤ ਤੋਂ ਮੀਕਾਏਲ ਦਾ ਪੁੱਤਰ ਸਥੂਰ। ");
INSERT INTO pan_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","ਨਫ਼ਤਾਲੀ ਦੇ ਗੋਤ ਤੋਂ ਵਾਫ਼ਸੀ ਦਾ ਪੁੱਤਰ ਨਹਬੀ। ");
INSERT INTO pan_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","ਗਾਦ ਦੇ ਗੋਤ ਤੋਂ ਮਾਕੀ ਦਾ ਪੁੱਤਰ ਗਊਏਲ। ");
INSERT INTO pan_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","ਇਹ ਉਨ੍ਹਾਂ ਮਨੁੱਖਾਂ ਦੇ ਨਾਮ ਹਨ ਜਿਨ੍ਹਾਂ ਨੂੰ ਮੂਸਾ ਨੇ ਕਨਾਨ ਦੇਸ ਦਾ ਭੇਤ ਲੈਣ ਲਈ ਭੇਜਿਆ ਅਤੇ ਮੂਸਾ ਨੇ ਨੂਨ ਦੇ ਪੁੱਤਰ ਹੋਸ਼ੇਆ ਦਾ ਨਾਮ ਯਹੋਸ਼ੁਆ ਰੱਖਿਆ। ");
INSERT INTO pan_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","ਸੋ ਮੂਸਾ ਨੇ ਉਨ੍ਹਾਂ ਨੂੰ ਕਨਾਨ ਦੇਸ ਦਾ ਭੇਤ ਲੈਣ ਲਈ ਭੇਜਿਆ ਅਤੇ ਉਨ੍ਹਾਂ ਨੂੰ ਆਖਿਆ, ਇੱਧਰ ਦੱਖਣ ਵੱਲ ਉੱਪਰ ਨੂੰ ਜਾਓ ਅਤੇ ਪਰਬਤ ਉੱਤੇ ਚੜ੍ਹੋ। ");
INSERT INTO pan_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","ਅਤੇ ਉਸ ਦੇਸ ਨੂੰ ਵੇਖੋ, ਕਿ ਉਹ ਕਿਸ ਤਰ੍ਹਾਂ ਦਾ ਹੈ ਅਤੇ ਉਹ ਲੋਕ ਜਿਹੜੇ ਉਸ ਵਿੱਚ ਵੱਸਦੇ ਹਨ ਤਕੜੇ ਹਨ ਜਾਂ ਕਮਜ਼ੋਰ ਹਨ ਅਤੇ ਥੋੜ੍ਹੇ ਹਨ ਜਾਂ ਬਹੁਤ ਸਾਰੇ ਹਨ। ");
INSERT INTO pan_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","ਅਤੇ ਉਹ ਧਰਤੀ ਕਿਸ ਤਰ੍ਹਾਂ ਹੈ, ਜਿਹ ਦੇ ਵਿੱਚ ਉਹ ਵੱਸਦੇ ਹਨ, ਚੰਗੀ ਹੈ ਜਾਂ ਮਾੜੀ ਅਤੇ ਸ਼ਹਿਰ ਕਿਸ ਤਰ੍ਹਾਂ ਦੇ ਹਨ ਜਿਨ੍ਹਾਂ ਵਿੱਚ ਉਹ ਵੱਸਦੇ ਹਨ, ਤੰਬੂਆਂ ਵਾਲੇ ਹਨ ਜਾਂ ਗੜ੍ਹਾਂ ਵਾਲੇ ਹਨ। ");
INSERT INTO pan_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","ਅਤੇ ਧਰਤੀ ਕਿਹੋ ਜਿਹੀ ਹੈ, ਫ਼ਲਦਾਰ ਜਾਂ ਬੰਜਰ ਅਤੇ ਉਹ ਦੇ ਵਿੱਚ ਰੁੱਖ ਹਨ ਕਿ ਨਹੀਂ। ਤੁਸੀਂ ਤਕੜੇ ਹੋਵੋ ਅਤੇ ਉਸ ਧਰਤੀ ਦੇ ਫ਼ਲ ਤੋਂ ਕੁਝ ਲੈ ਕੇ ਆਇਓ ਕਿਉਂ ਜੋ ਉਹ ਮੌਸਮ ਪਹਿਲੀ ਪੱਕੀ ਦਾਖ਼ ਦਾ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","ਸੋ ਉਨ੍ਹਾਂ ਉੱਪਰ ਜਾ ਕੇ ਦੇਸ ਦੀ ਖ਼ੋਜ ਕੀਤੀ ਜੋ ਸੀਨ ਦੀ ਉਜਾੜ ਤੋਂ ਰਹੋਬ ਤੱਕ ਜਿਹੜਾ ਹਮਾਥ ਦੇ ਰਾਹ ਉੱਤੇ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","ਤਾਂ ਉਹ ਦੱਖਣ ਵੱਲ ਚੜ੍ਹੇ ਅਤੇ ਹਬਰੋਨ ਤੱਕ ਆਏ ਅਤੇ ਉੱਥੇ ਅਨਾਕ ਦੀ ਅੰਸ ਦੇ ਅਹੀਮਾਨ ਸ਼ੇਸ਼ਈ ਅਤੇ ਤਲਮਈ ਸਨ ਅਤੇ ਹਬਰੋਨ ਮਿਸਰ ਦੇ ਸੋਆਨ ਤੋਂ ਸੱਤ ਸਾਲ ਪਹਿਲਾਂ ਬਣਿਆ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","ਫੇਰ ਉਹ ਅਸ਼ਕੋਲ ਦੀ ਘਾਟੀ ਤੱਕ ਆਏ ਅਤੇ ਉੱਥੇ ਦਾਖ਼ ਦੇ ਗੁੱਛੇ ਦੀ ਟਹਿਣੀ ਤੋੜੀ ਅਤੇ ਉਹ ਨੂੰ ਇੱਕ ਲਾਠੀ ਉੱਤੇ ਦੋ ਮਨੁੱਖ ਚੁੱਕ ਕੇ ਲਿਆਏ ਨਾਲੇ ਅਨਾਰ ਅਤੇ ਹੰਜ਼ੀਰ ਨੂੰ ਵੀ ਲਿਆਏ। ");
INSERT INTO pan_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","ਅਤੇ ਉਸ ਗੁੱਛੇ ਦੇ ਕਾਰਨ ਜਿਹੜਾ ਇਸਰਾਏਲੀਆਂ ਨੇ ਉੱਥੋਂ ਤੋੜਿਆ ਸੀ ਉਸ ਥਾਂ ਦਾ ਨਾਮ ਅਸ਼ਕੋਲ ਦੀ ਘਾਟੀ ਪੈ ਗਿਆ। ");
INSERT INTO pan_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","ਉਹ ਉਸ ਦੇਸ ਦਾ ਭੇਤ ਜਾਣ ਕੇ ਚਾਲ੍ਹੀਆਂ ਦਿਨਾਂ ਪਿੱਛੋਂ ਮੁੜੇ। ");
INSERT INTO pan_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","ਉਹ ਤੁਰ ਕੇ ਮੂਸਾ ਹਾਰੂਨ ਅਤੇ ਇਸਰਾਏਲੀਆਂ ਦੀ ਸਾਰੀ ਮੰਡਲੀ ਕੋਲ ਪਾਰਾਨ ਦੀ ਉਜਾੜ ਵਿੱਚ ਕਾਦੇਸ਼ ਕੋਲ ਆਏ ਅਤੇ ਸਾਰੀ ਮੰਡਲੀ ਲਈ ਖ਼ਬਰ ਲਿਆਏ ਨਾਲੇ ਉਸ ਧਰਤੀ ਦਾ ਫ਼ਲ ਵਿਖਾਇਆ। ");
INSERT INTO pan_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","ਅਤੇ ਉਨ੍ਹਾਂ ਨੇ ਉਹ ਨੂੰ ਨਿਰਣਾ ਕਰ ਕੇ ਆਖਿਆ ਕਿ ਅਸੀਂ ਉਸ ਦੇਸ ਨੂੰ ਗਏ ਜਿੱਥੇ ਤੁਸੀਂ ਸਾਨੂੰ ਭੇਜਿਆ ਸੀ। ਉੱਥੇ ਸੱਚ-ਮੁੱਚ ਦੁੱਧ ਅਤੇ ਸ਼ਹਿਦ ਵਗਦਾ ਹੈ ਅਤੇ ਇਹ ਉਹ ਦਾ ਫਲ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","ਪਰੰਤੂ ਉਸ ਦੇਸ ਦੇ ਵਾਸੀ ਬਲਵਾਨ ਹਨ ਅਤੇ ਉਸ ਦੇ ਸ਼ਹਿਰ ਗੜ੍ਹਾਂ ਵਾਲੇ ਅਤੇ ਵੱਡੇ-ਵੱਡੇ ਹਨ ਅਤੇ ਅਸੀਂ ਉੱਥੇ ਅਨਾਕ ਦੇ ਵਾਸੀਆਂ ਨੂੰ ਵੀ ਵੇਖਿਆ। ");
INSERT INTO pan_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","ਉਸ ਦੇਸ ਦੇ ਦੱਖਣ ਵੱਲ ਅਮਾਲੇਕੀ ਵੱਸਦੇ ਹਨ ਅਤੇ ਹਿੱਤੀ, ਯਬੂਸੀ, ਅਤੇ ਅਮੋਰੀ ਪਰਬਤ ਉੱਤੇ ਵੱਸਦੇ ਹਨ ਅਤੇ ਕਨਾਨੀ ਸਮੁੰਦਰ ਕੋਲ ਯਰਦਨ ਦੇ ਆਲੇ-ਦੁਆਲੇ ਵੱਸਦੇ ਹਨ। ");
INSERT INTO pan_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","ਤਦ ਕਾਲੇਬ ਨੇ ਮੂਸਾ ਦੇ ਅੱਗੇ ਪਰਜਾ ਨੂੰ ਚੁੱਪ ਕਰਾਇਆ ਅਤੇ ਆਖਿਆ, ਜ਼ਰੂਰ ਅਸੀਂ ਉੱਪਰ ਜਾਈਏ ਅਤੇ ਉਸ ਦੇਸ ਉੱਤੇ ਕਬਜ਼ਾ ਕਰੀਏ ਕਿਉਂ ਜੋ ਅਸੀਂ ਉਹ ਦੇ ਉੱਤੇ ਕਬਜ਼ਾ ਕਰ ਸਕਦੇ ਹਾਂ। ਅਸੀਂ ਜ਼ਰੂਰ ਹੀ ਉਹ ਦੇ ਉੱਤੇ ਕਬਜ਼ਾ ਕਰ ਸਕਦੇ ਹਾਂ। ");
INSERT INTO pan_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","ਪਰ ਉਨ੍ਹਾਂ ਮਨੁੱਖਾਂ ਨੇ ਜਿਹੜੇ ਉਹ ਦੇ ਨਾਲ ਉੱਪਰ ਗਏ ਸਨ ਆਖਿਆ ਭਈ ਅਸੀਂ ਉਨ੍ਹਾਂ ਲੋਕਾਂ ਦੇ ਵਿਰੁੱਧ ਉੱਪਰ ਨਹੀਂ ਜਾ ਸਕਦੇ ਕਿਉਂ ਜੋ ਉਹ ਸਾਡੇ ਤੋਂ ਬਲਵਾਨ ਹਨ। ");
INSERT INTO pan_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","ਉਹ ਇਸਰਾਏਲੀਆਂ ਕੋਲ ਉਸ ਦੇਸ ਦੀ ਬੁਰੀ ਖ਼ਬਰ ਲਿਆਏ ਜਿਸ ਦਾ ਉਨ੍ਹਾਂ ਨੇ ਭੇਤ ਪਾਇਆ ਸੀ ਅਤੇ ਆਖਣ ਲੱਗੇ, ਕਿ ਜਿਸ ਦੇਸ ਦੇ ਵਿੱਚ ਦੀ ਅਸੀਂ ਲੰਘੇ, ਉਸ ਦਾ ਭੇਤ ਜਾਣੀਏ, ਉਹ ਅਜਿਹਾ ਦੇਸ ਹੈ ਜਿਹੜਾ ਆਪਣੇ ਵਾਸੀਆਂ ਨੂੰ ਖਾਂਦਾ ਹੈ ਨਾਲੇ ਸਾਰੇ ਲੋਕ ਜਿਨ੍ਹਾਂ ਨੂੰ ਅਸੀਂ ਉਸ ਵਿੱਚ ਵੇਖਿਆ ਉਹ ਵੱਡੇ-ਵੱਡੇ ਕੱਦਾਂ ਵਾਲੇ ਮਨੁੱਖ ਹਨ। ");
INSERT INTO pan_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","ਅਤੇ ਉੱਥੇ ਅਸੀਂ ਨਫ਼ੀਲੀਮ ਤੋਂ ਜਿਹੜੀ ਅਨਾਕ ਦੀ ਅੰਸ ਹੈ, ਉੱਥੇ ਦੈਂਤ ਵੇਖੇ ਅਤੇ ਅਸੀਂ ਆਪਣੀ ਨਜਰ ਵਿੱਚ ਉਹਨਾਂ ਦੇ ਅੱਗੇ ਟਿੱਡੀਆਂ ਵਰਗੇ ਹਾਂ ਅਤੇ ਅਸੀਂ ਕੁਝ ਵੀ ਨਹੀਂ ਹਾਂ। ");
INSERT INTO pan_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","ਸਾਰੀ ਮੰਡਲੀ ਨੇ ਆਪਣੀ ਅਵਾਜ਼ ਉੱਚੀ ਦਿੱਤੀ, ਰੌਲ਼ਾ ਪਾਇਆ ਅਤੇ ਪਰਜਾ ਉਸ ਰਾਤ ਰੋਂਦੀ ਰਹੀ। ");
INSERT INTO pan_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","ਅਤੇ ਸਾਰੇ ਇਸਰਾਏਲੀ ਮੂਸਾ ਦੇ ਵਿਰੁੱਧ ਅਤੇ ਹਾਰੂਨ ਦੇ ਵਿਰੁੱਧ ਬੁੜ-ਬੁੜਾਏ ਅਤੇ ਸਾਰੀ ਮੰਡਲੀ ਨੇ ਉਨ੍ਹਾਂ ਨੂੰ ਆਖਿਆ, ਚੰਗਾ ਹੀ ਹੁੰਦਾ ਜੇ ਅਸੀਂ ਮਿਸਰ ਦੇਸ ਵਿੱਚ ਮਰ ਜਾਂਦੇ ਨਾ ਕਿ ਇਸ ਉਜਾੜ ਵਿੱਚ ਮਰ ਮੁੱਕਦੇ। ");
INSERT INTO pan_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","ਯਹੋਵਾਹ ਸਾਨੂੰ ਕਿਉਂ ਇਸ ਦੇਸ ਵਿੱਚ ਲਿਆਇਆ ਕਿ ਅਸੀਂ ਤਲਵਾਰ ਨਾਲ ਡਿੱਗੀਏ ਅਤੇ ਸਾਡੀਆਂ ਪਤਨੀਆਂ ਅਤੇ ਸਾਡੇ ਨਿਆਣੇ ਲੁੱਟ ਦਾ ਮਾਲ ਹੋਣ? ਕੀ ਸਾਡੇ ਲਈ ਚੰਗਾ ਨਹੀਂ, ਜੋ ਅਸੀਂ ਮਿਸਰ ਨੂੰ ਮੁੜ ਜਾਈਏ? ");
INSERT INTO pan_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","ਤਦ ਉਹ ਇੱਕ ਦੂਜੇ ਨੂੰ ਆਖਣ ਲੱਗੇ ਕਿ ਅਸੀਂ ਇੱਕ ਆਗੂ ਠਹਿਰਾ ਕੇ ਮਿਸਰ ਨੂੰ ਮੁੜ ਚੱਲੀਏ। ");
INSERT INTO pan_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","ਤਦ ਮੂਸਾ ਅਤੇ ਹਾਰੂਨ ਆਪਣੇ ਮੂੰਹਾਂ ਦੇ ਭਾਰ ਇਸਰਾਏਲੀਆਂ ਦੀ ਮੰਡਲੀ ਦੀ ਸਭਾ ਅੱਗੇ ਡਿੱਗ ਪਏ। ");
INSERT INTO pan_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","ਫੇਰ ਤਾਂ ਨੂਨ ਦੇ ਪੁੱਤਰ ਯਹੋਸ਼ੁਆ ਅਤੇ ਯਫ਼ੁੰਨਹ ਦੇ ਪੁੱਤਰ ਕਾਲੇਬ ਨੇ ਜਿਹੜੇ ਧਰਤੀ ਦਾ ਭੇਤ ਲੈਣ ਵਾਲਿਆਂ ਵਿੱਚੋਂ ਸਨ ਆਪਣੇ ਕੱਪੜੇ ਪਾੜੇ। ");
INSERT INTO pan_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","ਅਤੇ ਉਨ੍ਹਾਂ ਨੇ ਇਸਰਾਏਲੀਆਂ ਦੀ ਸਾਰੀ ਮੰਡਲੀ ਨੂੰ ਆਖਿਆ ਕਿ ਉਹ ਧਰਤੀ ਜਿਸ ਦੇ ਵਿੱਚ ਦੀ ਅਸੀਂ ਭੇਤ ਲੈਣ ਲਈ ਗਏ, ਬਹੁਤ ਚੰਗੀ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","ਜੇ ਯਹੋਵਾਹ ਸਾਡੇ ਨਾਲ ਪ੍ਰਸੰਨ ਹੈ ਤਾਂ ਉਹ ਸਾਨੂੰ ਉਸ ਦੇਸ ਵਿੱਚ ਲੈ ਜਾਵੇਗਾ ਅਤੇ ਸਾਨੂੰ ਦੇ ਦੇਵੇਗਾ। ਉਹ ਇੱਕ ਧਰਤੀ ਹੈ ਜਿਸ ਦੇ ਵਿੱਚ ਦੁੱਧ ਅਤੇ ਸ਼ਹਿਦ ਵਗਦਾ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","ਤੁਸੀਂ ਸਿਰਫ਼ ਯਹੋਵਾਹ ਦੇ ਵਿਰੁੱਧ ਗਵਾਹੀ ਨਾ ਦੇਵੋ, ਨਾ ਹੀ ਤੁਸੀਂ ਉਸ ਦੇਸ ਦੇ ਲੋਕਾਂ ਤੋਂ ਡਰੋ ਕਿਉਂ ਜੋ ਉਹ ਤਾਂ ਸਾਡੇ ਲਈ ਮਾਮੂਲੀ ਹੀ ਹਨ। ਉਹਨਾਂ ਦੀ ਸੁਰੱਖਿਆ ਉਹਨਾਂ ਦੇ ਉੱਤੋਂ ਜਾਂਦੀ ਰਹੀ ਹੈ ਅਤੇ ਯਹੋਵਾਹ ਸਾਡੇ ਨਾਲ ਹੈ ਉਹਨਾਂ ਤੋਂ ਤੁਸੀਂ ਨਾ ਡਰੋ! ");
INSERT INTO pan_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","ਪਰ ਜਦ ਸਾਰੀ ਮੰਡਲੀ ਨੇ ਆਖਿਆ ਕਿ ਇਨ੍ਹਾਂ ਨੂੰ ਪੱਥਰਾਂ ਨਾਲ ਮਾਰੀਏ ਤਦ ਯਹੋਵਾਹ ਦੀ ਮਹਿਮਾ ਸਾਰੇ ਇਸਰਾਏਲੀਆਂ ਦੀ ਉੱਤੇ ਮੰਡਲੀ ਦੇ ਤੰਬੂ ਵਿੱਚ ਪਰਗਟ ਹੋਈ। ");
INSERT INTO pan_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","ਤਦ ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਆਖਿਆ ਕਿ ਇਹ ਪਰਜਾ ਕਦੋਂ ਤੱਕ ਮੇਰੀ ਨਿਰਾਦਰੀ ਕਰਦੀ ਰਹੇਗੀ? ਅਤੇ ਕਦੋਂ ਤੱਕ ਮੇਰੇ ਉੱਤੇ ਉਨ੍ਹਾਂ ਸਾਰਿਆਂ ਨਿਸ਼ਾਨਾਂ ਦੇ ਹੁੰਦਿਆਂ ਵੀ ਜਿਹੜੇ ਮੈਂ ਉਨ੍ਹਾਂ ਵਿੱਚ ਕੀਤੇ, ਵਿਸ਼ਵਾਸ ਨਾ ਕਰੇਗੀ? ");
INSERT INTO pan_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","ਮੈਂ ਉਨ੍ਹਾਂ ਨੂੰ ਮਰੀ ਨਾਲ ਮਾਰਾਂਗਾ, ਅਤੇ ਤੈਨੂੰ ਇੱਕ ਕੌਮ ਬਣਾਵਾਂਗਾ ਜੋ ਉਨ੍ਹਾਂ ਤੋਂ ਵੱਡੀ ਅਤੇ ਬਲਵੰਤ ਹੋਵੇਗੀ। ");
INSERT INTO pan_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","ਪਰ ਮੂਸਾ ਨੇ ਯਹੋਵਾਹ ਨੂੰ ਆਖਿਆ, ਫੇਰ ਮਿਸਰੀ ਇਹ ਸੁਣਨਗੇ ਕਿਉਂ ਜੋ ਤੂੰ ਇਸ ਪਰਜਾ ਨੂੰ ਆਪਣੇ ਬਲ ਨਾਲ ਉਨ੍ਹਾਂ ਦੇ ਵਿੱਚੋਂ ਕੱਢ ਲਿਆਇਆ ਹੈਂ। ");
INSERT INTO pan_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","ਅਤੇ ਉਹ ਇਸ ਦੇਸ ਦੇ ਵਸਨੀਕਾਂ ਨੂੰ ਦੱਸਣਗੇ। ਉਨ੍ਹਾਂ ਨੇ ਸੁਣਿਆ ਹੈ ਕਿ ਤੂੰ ਯਹੋਵਾਹ ਇਸ ਪਰਜਾ ਦੇ ਵਿੱਚ ਹੈਂ ਅਤੇ ਤੂੰ ਯਹੋਵਾਹ ਉਨ੍ਹਾਂ ਨੂੰ ਆਹਮੋ-ਸਾਹਮਣੇ ਵਿਖਾਈ ਦਿੰਦਾ ਹੈਂ ਅਤੇ ਤੇਰਾ ਬੱਦਲ ਉਨ੍ਹਾਂ ਦੇ ਉੱਤੇ ਖੜ੍ਹਾ ਰਹਿੰਦਾ ਹੈ ਅਤੇ ਤੂੰ ਉਨ੍ਹਾਂ ਦੇ ਅੱਗੇ-ਅੱਗੇ ਦਿਨ ਨੂੰ ਬੱਦਲ ਦੇ ਥੰਮ੍ਹ ਵਿੱਚ ਅਤੇ ਰਾਤ ਨੂੰ ਅੱਗ ਦੇ ਥੰਮ੍ਹ ਵਿੱਚ ਚੱਲਦਾ ਹੈਂ। ");
INSERT INTO pan_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","ਜੇ ਤੂੰ ਇਸ ਪਰਜਾ ਨੂੰ ਇੱਕ ਮਨੁੱਖ ਵਾਂਗੂੰ ਮਾਰ ਸੁੱਟੇਂ ਤਾਂ ਕੌਮਾਂ ਜਿਨ੍ਹਾਂ ਨੇ ਤੇਰੀ ਮਹਿਮਾ ਸੁਣੀ ਹੈ, ਆਖਣਗੀਆਂ, ");
INSERT INTO pan_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","ਇਸ ਲਈ ਕਿ ਯਹੋਵਾਹ ਇਸ ਪਰਜਾ ਨੂੰ ਉਸ ਦੇਸ ਵਿੱਚ ਪਹੁੰਚਾ ਨਾ ਸਕਿਆ ਜਿਸ ਦੇ ਦੇਣ ਦੀ ਸਹੁੰ ਖਾਧੀ ਸੀ ਤਾਂ ਹੀ ਤਾਂ ਉਸਨੇ ਉਨ੍ਹਾਂ ਨੂੰ ਉਜਾੜ ਵਿੱਚ ਬਰਬਾਦ ਕੀਤਾ। ");
INSERT INTO pan_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","ਹੁਣ ਪ੍ਰਭੂ ਦਾ ਇਕਬਾਲ ਵੱਡਾ ਹੋਵੇ ਜਿਵੇਂ ਤੂੰ ਬੋਲਿਆ ਹੈਂ। ");
INSERT INTO pan_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","ਕਿ ਯਹੋਵਾਹ ਕ੍ਰੋਧ ਵਿੱਚ ਧੀਰਜੀ ਅਤੇ ਭਲਿਆਈ ਨਾਲ ਭਰਪੂਰ ਹੈ ਅਤੇ ਕੁਧਰਮ ਅਤੇ ਅਪਰਾਧ ਦਾ ਬਖ਼ਸ਼ਣਹਾਰ ਹੈ ਪਰ ਕੁਧਰਮੀ ਨੂੰ ਇਸ ਤਰ੍ਹਾਂ ਹੀ ਨਹੀਂ ਛੱਡ ਦਿੰਦਾ। ਉਹ ਪਿਤਾ ਦੇ ਕੁਧਰਮ ਦਾ ਬਦਲਾ ਉਨ੍ਹਾਂ ਦੇ ਪੁੱਤਰਾਂ ਉੱਤੋਂ ਤੀਜੀ ਚੌਥੀ ਪੀੜ੍ਹੀ ਤੱਕ ਲੈਣ ਵਾਲਾ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","ਆਪਣੀ ਵੱਡੀ ਦਯਾ ਦੇ ਅਨੁਸਾਰ ਜਿਵੇਂ ਤੂੰ ਇਸ ਪਰਜਾ ਨੂੰ ਮਿਸਰ ਤੋਂ ਲੈ ਕੇ ਹੁਣ ਤੱਕ ਬਖਸ਼ਿਆ ਹੈ ਇਨ੍ਹਾਂ ਦਾ ਕੁਧਰਮ ਮਾਫ਼ ਕਰ ਦੇ। ");
INSERT INTO pan_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","ਤਾਂ ਯਹੋਵਾਹ ਨੇ ਆਖਿਆ, ਤੇਰੇ ਆਖਣ ਅਨੁਸਾਰ ਮੈਂ ਉਨ੍ਹਾਂ ਨੂੰ ਮਾਫ਼ ਕੀਤਾ। ");
INSERT INTO pan_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","ਪਰ ਮੇਰੀ ਜਿੰਦ ਦੀ ਸਹੁੰ ਯਹੋਵਾਹ ਦੀ ਮਹਿਮਾ ਨਾਲ ਸਾਰੀ ਪ੍ਰਿਥਵੀ ਭਰਪੂਰ ਹੋਵੇਗੀ। ");
INSERT INTO pan_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","ਫੇਰ ਵੀ ਉਹ ਸਾਰੇ ਮਨੁੱਖ ਜਿਨ੍ਹਾਂ ਨੇ ਮੇਰੀ ਮਹਿਮਾ ਨੂੰ ਅਤੇ ਮੇਰੇ ਨਿਸ਼ਾਨਾਂ ਨੂੰ ਜਿਹੜੇ ਮੈਂ ਮਿਸਰ ਵਿੱਚ ਅਤੇ ਉਜਾੜ ਵਿੱਚ ਕੀਤੇ ਮੈਨੂੰ ਹੁਣ ਤੱਕ ਦਸ ਵਾਰ ਪਰਤਾਇਆ ਅਤੇ ਮੇਰੀ ਅਵਾਜ਼ ਨਹੀਂ ਸੁਣੀ। ");
INSERT INTO pan_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","ਉਹ ਉਸ ਧਰਤੀ ਨੂੰ ਨਾ ਵੇਖਣਗੇ ਜਿਸ ਦੀ ਮੈਂ ਉਨ੍ਹਾਂ ਦੇ ਪੁਰਖਿਆਂ ਨਾਲ ਸਹੁੰ ਖਾਧੀ ਸੀ ਅਤੇ ਨਾ ਹੀ ਉਹ ਸਾਰੇ ਜਿਨ੍ਹਾਂ ਮੇਰੀ ਹਾਨੀ ਕੀਤੀ ਉਹ ਨੂੰ ਵੇਖਣਗੇ। ");
INSERT INTO pan_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","ਪਰ ਮੇਰਾ ਸੇਵਕ ਕਾਲੇਬ ਅਤੇ ਉਸ ਦਾ ਵੰਸ਼ ਇਸ ਉੱਤੇ ਕਬਜ਼ਾ ਕਰੇਗਾ ਇਸ ਲਈ ਕਿ ਉਹ ਦੇ ਵਿੱਚ ਹੋਰ ਸੁਭਾਅ ਹੈ ਅਤੇ ਉਹ ਪੂਰੀ ਤਰ੍ਹਾਂ ਮੇਰੇ ਪਿੱਛੇ ਚੱਲਿਆ ਹੈ, ਮੈਂ ਉਸ ਨੂੰ ਹੀ ਇਸ ਧਰਤੀ ਵਿੱਚ ਜਿਸ ਦੇ ਵਿੱਚ ਉਹ ਗਿਆ ਸੀ ਲੈ ਜਾਂਵਾਂਗਾ। ");
INSERT INTO pan_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","ਅਮਾਲੇਕੀ ਅਤੇ ਕਨਾਨੀ ਘਾਟੀ ਵਿੱਚ ਵੱਸਦੇ ਹਨ। ਕੱਲ ਨੂੰ ਮੁੜੋ ਅਤੇ ਲਾਲ ਸਮੁੰਦਰ ਦੇ ਰਾਹ ਦੁਆਰਾ ਉਜਾੜ ਨੂੰ ਕੂਚ ਕਰੋ। ");
INSERT INTO pan_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","ਫੇਰ ਯਹੋਵਾਹ ਮੂਸਾ ਅਤੇ ਹਾਰੂਨ ਨੂੰ ਬੋਲਿਆ, ");
INSERT INTO pan_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","ਕਦੋਂ ਤੱਕ ਮੈਂ ਇਸ ਦੁਸ਼ਟ ਮੰਡਲੀ ਨੂੰ ਝੱਲਾਂ ਜਿਹੜੀ ਮੇਰੇ ਵਿਰੁੱਧ ਬੁੜ-ਬੁੜਾਉਂਦੀ ਹੈ? ਇਸਰਾਏਲੀਆਂ ਦੀ ਇਸ ਬੁੜ ਬੁੜਾਹਟ ਨੂੰ ਜਿਹੜੀ ਉਹ ਮੇਰੇ ਵਿਰੁੱਧ ਬੁੜ-ਬੁੜ ਕਰਦੇ ਹਨ ਮੈਂ ਸੁਣਿਆ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","ਉਨ੍ਹਾਂ ਨੂੰ ਆਖੋ ਕਿ ਮੈਨੂੰ ਮੇਰੀ ਜਾਨ ਦੀ ਸਹੁੰ, ਯਹੋਵਾਹ ਦਾ ਵਾਕ ਹੈ, ਸੱਚ-ਮੁੱਚ ਜਿਵੇਂ ਤੁਸੀਂ ਮੇਰੇ ਸੁਣਨ ਵਿੱਚ ਆਖਿਆ ਸੀ ਉਸੇ ਤਰ੍ਹਾਂ ਹੀ ਮੈਂ ਤੁਹਾਡੇ ਨਾਲ ਕਰਾਂਗਾ। ");
INSERT INTO pan_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","ਇਸੇ ਉਜਾੜ ਵਿੱਚ ਤੁਹਾਡੀਆਂ ਲਾਸ਼ਾਂ ਡਿੱਗਣਗੀਆਂ ਅਤੇ ਤੁਹਾਡੇ ਸਾਰੇ ਗਿਣੇ ਹੋਏ ਤੁਹਾਡੇ ਕੁੱਲ ਲੇਖੇ ਅਨੁਸਾਰ ਵੀਹ ਸਾਲ ਦੇ ਅਤੇ ਉਸ ਦੇ ਉੱਪਰ ਦੇ ਜੋ ਮੇਰੇ ਵਿਰੁੱਧ ਬੁੜ-ਬੁੜਾਏ। ");
INSERT INTO pan_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","ਯਫ਼ੁੰਨਹ ਦੇ ਪੁੱਤਰ ਕਾਲੇਬ ਅਤੇ ਨੂਨ ਦੇ ਪੁੱਤਰ ਯਹੋਸ਼ੁਆ ਤੋਂ ਛੁੱਟ, ਤੁਹਾਡੇ ਵਿੱਚੋਂ ਕੋਈ ਉਸ ਦੇਸ ਨਾ ਵੜੋਂਗੇ ਜਿਸ ਦੀ ਮੈਂ ਸਹੁੰ ਖਾਧੀ ਸੀ, ਕਿ ਮੈਂ ਤੁਹਾਨੂੰ ਉਸ ਵਿੱਚ ਵਸਾਵਾਂਗਾ। ");
INSERT INTO pan_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","ਪਰ ਤੁਹਾਡੇ ਨਿਆਣੇ ਜਿਨ੍ਹਾਂ ਵਿਖੇ ਤੁਸੀਂ ਆਖਿਆ ਸੀ ਕਿ ਉਹ ਲੁੱਟ ਦਾ ਮਾਲ ਹੋਣਗੇ ਉਨ੍ਹਾਂ ਨੂੰ ਮੈਂ ਅੰਦਰ ਲਿਆਵਾਂਗਾ ਅਤੇ ਉਹ ਇਸ ਧਰਤੀ ਨੂੰ ਪਾਉਣਗੇ ਜਿਸ ਨੂੰ ਤੁਸੀਂ ਰੱਦਿਆ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","ਪਰ ਤੁਹਾਡੀਆਂ ਲਾਸ਼ਾਂ ਇਸ ਉਜਾੜ ਵਿੱਚ ਡਿੱਗ ਪੈਣਗੀਆਂ, ਇਹ ਤੁਹਾਡੇ ਲਈ ਹੈ! ");
INSERT INTO pan_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","ਤੁਹਾਡੇ ਪੁੱਤਰ ਉਜਾੜ ਵਿੱਚ ਚਾਲੀਆਂ ਸਾਲ ਤੱਕ ਅਯਾਲੀ ਹੋਣਗੇ ਅਤੇ ਤੁਹਾਡੇ ਕੁਕਰਮ ਦੀ ਸਜ਼ਾ ਚੁੱਕਣਗੇ ਜਦ ਤੱਕ ਤੁਹਾਡੀਆਂ ਲਾਸ਼ਾਂ ਉਜਾੜ ਵਿੱਚ ਗਲ਼ ਸੜ ਨਾ ਜਾਣ। ");
INSERT INTO pan_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","ਉਨ੍ਹਾਂ ਦਿਨਾਂ ਦੀ ਗਿਣਤੀ ਅਨੁਸਾਰ ਜਦ ਤੁਸੀਂ ਇਸ ਧਰਤੀ ਦਾ ਭੇਤ ਪਾਇਆ ਚਾਲ੍ਹੀ ਦਿਨ ਅਰਥਾਤ ਇੱਕ ਦਿਨ ਇੱਕ ਸਾਲ ਜਿਹਾ ਤੁਸੀਂ ਆਪਣੀ ਬੁਰਾਈ ਨੂੰ ਚਾਲ੍ਹੀ ਸਾਲ ਤੱਕ ਚੁੱਕੋਗੇ ਤਦ ਤੁਸੀਂ ਮੈਨੂੰ ਤਿਆਗਣ ਦਾ ਨਤੀਜਾ ਜਾਣੋਗੇ! ");
INSERT INTO pan_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","ਮੈਂ ਯਹੋਵਾਹ ਬੋਲ ਚੁੱਕਿਆ ਹਾਂ। ਮੈਂ ਜ਼ਰੂਰ ਇਹ ਸਭ ਕੁਝ ਇਸ ਦੁਸ਼ਟ ਮੰਡਲੀ ਨਾਲ ਕਰਾਂਗਾ ਜਿਹੜੀ ਮੇਰੇ ਵਿਰੁੱਧ ਇਕੱਠੀ ਹੋਈ ਹੈ। ਉਹ ਇਸ ਉਜਾੜ ਵਿੱਚ ਗਲ਼ ਸੜ ਜਾਣਗੇ ਅਤੇ ਇੱਥੇ ਹੀ ਉਹ ਮਰ ਜਾਣਗੇ। ");
INSERT INTO pan_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","ਫੇਰ ਉਹ ਮਨੁੱਖ ਜਿਨ੍ਹਾਂ ਨੂੰ ਮੂਸਾ ਨੇ ਧਰਤੀ ਦਾ ਭੇਤ ਜਾਣਨ ਲਈ ਭੇਜਿਆ ਸੀ ਅਤੇ ਜਿਹੜੇ ਮੁੜ ਕੇ ਉਸ ਧਰਤੀ ਦੀ ਅਜਿਹੀ ਬੁਰੀ ਖ਼ਬਰ ਲਿਆਏ ਕਿ ਸਾਰੀ ਮੰਡਲੀ ਉਸ ਦੇ ਵਿਰੁੱਧ ਬੁੜ-ਬੁੜਾਉਣ ਲੱਗ ਪਈ, ");
INSERT INTO pan_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","ਉਹ ਮਨੁੱਖ ਜਿਹੜੇ ਧਰਤੀ ਦੀ ਬੁਰੀ ਖ਼ਬਰ ਲਿਆਏ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਬਵਾ ਨਾਲ ਮਰ ਗਏ। ");
INSERT INTO pan_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","ਪਰ ਨੂਨ ਦਾ ਪੁੱਤਰ ਯਹੋਸ਼ੁਆ ਅਤੇ ਯਫ਼ੁੰਨਹ ਦਾ ਪੁੱਤਰ ਕਾਲੇਬ ਉਨ੍ਹਾਂ ਮਨੁੱਖਾਂ ਵਿੱਚੋਂ ਜਿਹੜੇ ਧਰਤੀ ਦਾ ਭੇਤ ਪਾਉਣ ਨੂੰ ਗਏ ਸਨ ਜੀਉਂਦੇ ਬਚੇ ਰਹੇ। ");
INSERT INTO pan_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","ਤਦ ਮੂਸਾ ਨੇ ਸਾਰੇ ਇਸਰਾਏਲੀਆਂ ਨੂੰ ਇਹ ਗੱਲਾਂ ਦੱਸੀਆਂ ਅਤੇ ਪਰਜਾ ਨੇ ਵੱਡਾ ਵਿਰਲਾਪ ਕੀਤਾ। ");
INSERT INTO pan_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","ਤਦ ਉਹ ਸਵੇਰੇ ਹੀ ਉੱਠ ਕੇ ਪਰਬਤ ਦੀ ਟੀਸੀ ਉੱਤੇ ਇਹ ਕਹਿ ਕੇ ਗਏ ਕਿ ਵੇਖੋ, ਅਸੀਂ ਹੀ ਉਸ ਥਾਂ ਨੂੰ ਉਤਾਹਾਂ ਜਾਂਵਾਂਗੇ ਜਿਸ ਦੇ ਲਈ ਯਹੋਵਾਹ ਨੇ ਫ਼ਰਮਾਇਆ ਹੈ ਕਿਉਂ ਜੋ ਅਸੀਂ ਪਾਪ ਕੀਤਾ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","ਪਰ ਮੂਸਾ ਨੇ ਆਖਿਆ, ਤੁਸੀਂ ਯਹੋਵਾਹ ਦੇ ਹੁਕਮ ਦਾ ਉਲੰਘਣ ਕਿਉਂ ਕਰਦੇ ਹੋ? ਕਿਉਂ ਜੋ ਇਹ ਸਫ਼ਲ ਨਹੀਂ ਹੋਵੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","ਤੁਸੀਂ ਉੱਪਰ ਨਾ ਜਾਓ ਕਿਉਂ ਜੋ ਯਹੋਵਾਹ ਤੁਹਾਡੇ ਵਿਚਕਾਰ ਨਹੀਂ ਹੈ ਕਿਤੇ ਅਜਿਹਾ ਨਾ ਹੋਵੇ ਕਿ ਤੁਸੀਂ ਆਪਣੇ ਵੈਰੀਆਂ ਦੇ ਅੱਗੇ ਮਾਰੇ ਜਾਓ। ");
INSERT INTO pan_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","ਅਮਾਲੇਕੀ ਅਤੇ ਕਨਾਨੀ ਉੱਥੇ ਤੁਹਾਡੇ ਸਾਹਮਣੇ ਹਨ ਅਤੇ ਤੁਸੀਂ ਤਲਵਾਰ ਨਾਲ ਡਿੱਗ ਪਓਗੇ। ਇਸ ਲਈ ਕਿ ਤੁਸੀਂ ਯਹੋਵਾਹ ਦੇ ਪਿੱਛੇ ਚੱਲਣ ਤੋਂ ਫਿਰ ਗਏ ਯਹੋਵਾਹ ਤੁਹਾਡੇ ਸੰਗ ਨਹੀਂ ਹੋਵੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","ਪਰੰਤੂ ਉਹ ਢਿਠਾਈ ਨਾਲ ਪਰਬਤ ਦੀ ਟੀਸੀ ਉੱਤੇ ਚੜ੍ਹ ਗਏ ਪਰ ਯਹੋਵਾਹ ਦੇ ਨੇਮ ਦਾ ਸੰਦੂਕ ਅਤੇ ਮੂਸਾ ਡੇਰੇ ਦੇ ਵਿੱਚੋਂ ਨਾ ਗਏ। ");
INSERT INTO pan_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","ਅਮਾਲੇਕੀ ਅਤੇ ਕਨਾਨੀ ਜਿਹੜੇ ਉਸ ਪਰਬਤ ਉੱਤੇ ਵੱਸਦੇ ਸਨ ਹੇਠਾਂ ਆਏ ਅਤੇ ਉਨ੍ਹਾਂ ਨੂੰ ਮਾਰਿਆ ਅਤੇ ਉਨ੍ਹਾਂ ਨੂੰ ਹਾਰਮਾਹ ਤੱਕ ਮਾਰਦੇ ਗਏ। ");
INSERT INTO pan_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਆਖਿਆ, ");
INSERT INTO pan_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","ਇਸਰਾਏਲੀਆਂ ਨਾਲ ਗੱਲ ਕਰ ਅਤੇ ਉਨ੍ਹਾਂ ਨੂੰ ਆਖ ਕਿ ਜਦ ਤੁਸੀਂ ਉਸ ਦੇਸ ਵਿੱਚ ਪਹੁੰਚ ਜਾਓ ਜੋ ਤੁਹਾਡੇ ਵੱਸਣ ਲਈ ਮੈਂ ਤੁਹਾਨੂੰ ਦਿੰਦਾ ਹਾਂ। ");
INSERT INTO pan_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","ਅਤੇ ਜਦ ਤੁਸੀਂ ਯਹੋਵਾਹ ਲਈ ਅੱਗ ਦੀ ਭੇਟ ਭਾਵੇਂ ਹੋਮ ਦੀ ਭਾਵੇਂ ਬਲੀ ਦੀ ਚੜ੍ਹਾਓ ਤਾਂ ਜੋ ਤੁਸੀਂ ਸੁੱਖਣਾ ਪੂਰੀ ਕਰੋ ਜਾਂ ਖੁਸ਼ੀ ਦੀ ਭੇਟ ਵਾਂਗੂੰ ਜਾਂ ਤੁਹਾਡੇ ਠਹਿਰਾਏ ਹੋਏ ਪਰਬਾਂ ਵਿੱਚ ਦੀ ਭੇਟ ਵਾਂਗੂੰ ਤਾਂ ਜੋ ਯਹੋਵਾਹ ਲਈ ਸੁਗੰਧਤਾ ਚੋਣੇ ਤੋਂ ਜਾਂ ਇੱਜੜ ਤੋਂ ਹੋਵੇ। ");
INSERT INTO pan_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","ਤਾਂ ਚੜ੍ਹਾਉਣ ਵਾਲਾ ਯਹੋਵਾਹ ਲਈ ਮੈਦੇ ਦੀ ਭੇਟ ਲਈ ਏਫਾਹ ਦਾ ਦਸਵਾਂ ਹਿੱਸਾ ਮੈਦੇ ਦਾ ਹੀਨ ਦਾ ਚੌਥਾ ਹਿੱਸਾ ਤੇਲ ਮਿਲਿਆ ਹੋਇਆ ਚੜ੍ਹਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","ਅਤੇ ਪੀਣ ਦੀ ਭੇਟ ਲਈ ਹੀਨ ਦੀ ਚੌਥਾਈ ਮਧ ਹਰ ਭੇਡ ਦੇ ਬੱਚੇ ਪਿੱਛੇ ਤੂੰ ਉਸ ਹੋਮ ਦੀ ਭੇਟ ਨਾਲ ਜਾਂ ਬਲੀ ਨਾਲ ਤਿਆਰ ਕਰ। ");
INSERT INTO pan_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","ਭੇਡੂ ਦੇ ਨਾਲ ਮੈਦੇ ਦੀ ਭੇਟ ਦੋ ਦਸਵੇਂ ਹਿੱਸੇ ਮੈਦੇ ਦੇ ਹੀਨ ਦੀ ਤਿਹਾਈ ਤੇਲ ਮਿਲਿਆ ਹੋਇਆ ਤਿਆਰ ਕਰ। ");
INSERT INTO pan_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","ਅਤੇ ਪੀਣ ਦੀ ਭੇਟ ਲਈ ਹੀਨ ਦੀ ਤਿਹਾਈ ਮਧ ਯਹੋਵਾਹ ਲਈ ਸੁਗੰਧਤਾ ਦੀ ਭੇਟ ਕਰਕੇ ਚੜ੍ਹਾ। ");
INSERT INTO pan_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","ਜਦ ਤੂੰ ਹੋਮ ਦੀ ਭੇਟ ਜਾਂ ਬਲੀ ਲਈ ਮੇਂਢਾ ਤਿਆਰ ਕਰੇਂ ਤਾਂ ਜੋ ਸੁੱਖਣਾ ਪੂਰੀ ਹੋਵੇ ਜਾਂ ਯਹੋਵਾਹ ਲਈ ਸੁੱਖ-ਸਾਂਦ ਦੀਆਂ ਭੇਟਾਂ ਹੋਣ। ");
INSERT INTO pan_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","ਤਾਂ ਉਹ ਉਸ ਵਹਿੜੇ ਦੇ ਨਾਲ ਮੈਦੇ ਦੀ ਭੇਟ ਤਿੰਨ ਦਸਵੇਂ ਹਿੱਸੇ ਮੈਦੇ ਦੇ ਅੱਧਾ ਹੀਨ ਤੇਲ ਮਿਲਿਆ ਹੋਇਆ ਚੜ੍ਹਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","ਅਤੇ ਤੂੰ ਪੀਣ ਦੀ ਭੇਟ ਲਈ ਅੱਧਾ ਹੀਨ ਮਧ ਚੜ੍ਹਾ। ਉਹ ਯਹੋਵਾਹ ਲਈ ਅੱਗ ਦੀ ਸੁਗੰਧਤਾ ਹੋਵੇ। ");
INSERT INTO pan_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","ਇਸ ਤਰ੍ਹਾਂ ਹਰੇਕ ਬਲ਼ਦ, ਹਰ ਭੇਡੂ, ਹਰ ਭੇਡ ਦਾ ਬੱਚਾ, ਅਤੇ ਹਰ ਮੇਮਣੇ ਲਈ ਕੀਤਾ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","ਉਨ੍ਹਾਂ ਦੀ ਗਿਣਤੀ ਅਨੁਸਾਰ ਜਿਹੜੇ ਤੁਸੀਂ ਤਿਆਰ ਕਰਦੇ ਹੋ, ਇਸੇ ਤਰ੍ਹਾਂ ਹੀ ਤੁਸੀਂ ਹਰ ਇੱਕ ਲਈ ਉਨ੍ਹਾਂ ਦੀ ਗਿਣਤੀ ਅਨੁਸਾਰ ਕਰੋ। ");
INSERT INTO pan_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","ਸਾਰੇ ਦੇਸੀ ਉਨ੍ਹਾਂ ਨਾਲ ਜਦ ਉਹ ਯਹੋਵਾਹ ਲਈ ਅੱਗ ਦੀ ਸੁਗੰਧਤਾ ਚੜ੍ਹਾਉਣ ਇਸੇ ਤਰ੍ਹਾਂ ਹੀ ਕਰਨ। ");
INSERT INTO pan_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","ਅਤੇ ਜੇ ਕੋਈ ਤੁਹਾਡੇ ਵਿੱਚ ਟਿਕਿਆ ਹੋਇਆ ਪਰਦੇਸੀ ਜਾਂ ਜੇ ਕੋਈ ਤੁਹਾਡੇ ਵਿੱਚ ਤੁਹਾਡੀਆਂ ਪੀੜ੍ਹੀਆਂ ਤੋਂ ਰਹਿੰਦਾ ਹੋਵੇ ਅਤੇ ਉਹ ਯਹੋਵਾਹ ਲਈ ਅੱਗ ਦੀ ਸੁਗੰਧਤਾ ਚੜ੍ਹਾਵੇ ਤਾਂ ਜਿਵੇਂ ਤੁਸੀਂ ਕਰਦੇ ਹੋ ਉਹ ਵੀ ਕਰੇ। ");
INSERT INTO pan_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","ਸਭਾ ਲਈ ਇੱਕੋ ਹੀ ਬਿਧੀ ਤੁਹਾਡੇ ਲਈ ਅਤੇ ਉਸ ਪਰਦੇਸੀ ਲਈ ਹੋਵੇ ਅਤੇ ਇਹ ਬਿਧੀ ਤੁਹਾਡੀ ਪੀੜ੍ਹੀਓਂ ਪੀੜ੍ਹੀ ਸਦਾ ਲਈ ਹੋਵੇ ਜਿਵੇਂ ਤੁਸੀਂ ਉਸੇ ਤਰ੍ਹਾਂ ਪਰਦੇਸੀ ਯਹੋਵਾਹ ਅੱਗੇ ਹੋ ");
INSERT INTO pan_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","ਇੱਕੋ ਬਿਵਸਥਾ ਅਤੇ ਇੱਕੋ ਹੀ ਕਨੂੰਨ ਤੁਹਾਡੇ ਲਈ ਅਤੇ ਉਸ ਪਰਦੇਸੀ ਲਈ ਹੈ ਜਿਹੜਾ ਤੁਹਾਡੇ ਵਿੱਚ ਰਹਿ ਰਿਹਾ ਹੋਇਆ ਹੋਵੇ। ");
INSERT INTO pan_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","ਯਹੋਵਾਹ ਮੂਸਾ ਨਾਲ ਬੋਲਿਆ, ");
INSERT INTO pan_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","ਤੂੰ ਇਸਰਾਏਲੀਆਂ ਨਾਲ ਗੱਲ ਕਰ ਅਤੇ ਉਨ੍ਹਾਂ ਨੂੰ ਆਖ ਕਿ ਜਦ ਤੁਸੀਂ ਉਸ ਧਰਤੀ ਵਿੱਚ ਵੜੋ ਜਿੱਥੇ ਮੈਂ ਤੁਹਾਨੂੰ ਲਈ ਜਾਂਦਾ ਹਾਂ ");
INSERT INTO pan_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","ਤਾਂ ਅਜਿਹਾ ਹੋਵੇਗਾ ਕਿ ਜਦ ਤੁਸੀਂ ਉਸ ਧਰਤੀ ਦੀ ਰੋਟੀ ਤੋਂ ਖਾਓ ਤਾਂ ਤੁਸੀਂ ਯਹੋਵਾਹ ਲਈ ਹਿਲਾਉਣ ਦੀ ਭੇਟ ਚੜ੍ਹਾਇਓ। ");
INSERT INTO pan_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","ਆਪਣੇ ਗੁੰਨੇ ਹੋਏ ਆਟੇ ਦੇ ਪਹਿਲੇ ਪੇੜੇ ਦਾ ਫੁਲਕਾ ਹਿਲਾਉਣ ਦੀ ਭੇਟ ਕਰਕੇ ਚੜ੍ਹਾਓ। ਜਿਵੇਂ ਪਿੜ ਦੀ ਹਿਲਾਉਣ ਦੀ ਭੇਟ ਹੈ ਉਸੇ ਤਰ੍ਹਾਂ ਇਹ ਨੂੰ ਹਿਲਾਓ। ");
INSERT INTO pan_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","ਆਪਣੇ ਗੁੰਨੇ ਹੋਏ ਆਟੇ ਦੇ ਪਹਿਲੇ ਦਾ ਪਹਿਲਾ ਪੇੜਾ ਯਹੋਵਾਹ ਲਈ ਆਪਣੀ ਪੀੜ੍ਹੀਓਂ ਪੀੜ੍ਹੀ ਹਿਲਾਉਣ ਦੀ ਭੇਟ ਕਰਕੇ ਦਿਆ ਕਰੋ। ");
INSERT INTO pan_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","ਜਦ ਤੁਸੀਂ ਭੁੱਲੋ ਅਤੇ ਇਹ ਸਾਰੇ ਹੁਕਮ ਪੂਰੇ ਨਾ ਕਰੋ ਜਿਹੜੇ ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਆਖਿਆ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","ਅਰਥਾਤ ਜੋ ਕੁਝ ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਦੇ ਰਾਹੀਂ ਤੁਹਾਨੂੰ ਹੁਕਮ ਦਿੱਤਾ ਸੀ ਜਿਸ ਦਿਨ ਤੋਂ ਯਹੋਵਾਹ ਨੇ ਹੁਕਮ ਦਿੱਤਾ ਉਸ ਤੋਂ ਅੱਗੇ ਤੁਹਾਡੀ ਪੀੜ੍ਹੀਓਂ ਪੀੜ੍ਹੀ। ");
INSERT INTO pan_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","ਤਾਂ ਇਹ ਜੇ ਉਹ ਭੁੱਲ ਕੇ ਮੰਡਲੀ ਦੀਆਂ ਅੱਖਾਂ ਤੋਂ ਦੂਰ ਕੀਤਾ ਗਿਆ ਹੋਵੇ ਤਾਂ ਸਾਰੀ ਮੰਡਲੀ ਇੱਕ ਮੇਂਢਾ ਹੋਮ ਦੀ ਬਲੀ ਲਈ ਚੜ੍ਹਾਵੇ ਜਿਹੜੀ ਯਹੋਵਾਹ ਲਈ ਸੁਗੰਧਤਾ ਹੋਵੇ ਉਸ ਦੀ ਮੈਦੇ ਦੀ ਭੇਟ ਅਤੇ ਪੀਣ ਦੀ ਭੇਟ ਸਮੇਤ ਕਨੂੰਨ ਦੇ ਅਨੁਸਾਰ ਨਾਲੇ ਪਾਪ ਬਲੀ ਲਈ ਇੱਕ ਬੱਕਰਾ। ");
INSERT INTO pan_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","ਫੇਰ ਜਾਜਕ ਇਸਰਾਏਲੀਆਂ ਦੀ ਸਾਰੀ ਮੰਡਲੀ ਲਈ ਪ੍ਰਾਸਚਿਤ ਕਰੇ ਤਾਂ ਉਹ ਮਾਫ਼ ਕੀਤੇ ਜਾਣਗੇ ਕਿਉਂ ਜੋ ਉਹ ਭੁੱਲ ਸੀ, ਉਹ ਆਪਣਾ ਅੱਗ ਦਾ ਚੜ੍ਹਾਵਾ ਅਤੇ ਪਾਪ ਬਲੀ ਆਪਣੀ ਭੁੱਲ ਲਈ ਯਹੋਵਾਹ ਅੱਗੇ ਲਿਆਵੇ। ");
INSERT INTO pan_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","ਤਾਂ ਇਸਰਾਏਲੀਆਂ ਦੀ ਸਾਰੀ ਮੰਡਲੀ ਮਾਫ਼ ਕੀਤੀ ਜਾਵੇਗੀ ਨਾਲੇ ਉਹ ਪਰਦੇਸੀ ਜਿਹੜਾ ਉਨ੍ਹਾਂ ਦੇ ਵਿੱਚ ਰਹਿ ਰਿਹਾ ਹੈ ਕਿਉਂ ਜੋ ਉਹ ਸਾਰੀ ਪਰਜਾ ਦੀ ਭੁੱਲ ਨਾਲ ਹੋਇਆ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","ਜੇ ਇੱਕੋ ਹੀ ਮਨੁੱਖ ਭੁੱਲ ਨਾਲ ਪਾਪ ਕਰੇ ਤਾਂ ਪਾਪ ਬਲੀ ਲਈ ਉਹ ਇੱਕ ਸਾਲ ਦੀ ਬੱਕਰੀ ਚੜ੍ਹਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","ਫੇਰ ਜਾਜਕ ਉਸ ਮਨੁੱਖ ਲਈ ਜਿਹੜਾ ਭੁੱਲ ਕੇ ਪਾਪ ਕਰੇ ਪ੍ਰਾਸਚਿਤ ਕਰੇ ਜਦ ਉਹ ਯਹੋਵਾਹ ਅੱਗੇ ਭੁੱਲ ਕੇ ਪਾਪ ਕਰੇ, ਉਹ ਦੇ ਲਈ ਪ੍ਰਾਸਚਿਤ ਹੋਵੇ ਤਾਂ ਉਹ ਮਾਫ਼ੀ ਪਾਵੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","ਇਸਰਾਏਲੀਆਂ ਦੇ ਦੇਸੀ ਅਤੇ ਪਰਦੇਸੀ ਲਈ ਜਿਹੜਾ ਤੁਹਾਡੇ ਵਿੱਚ ਰਹਿ ਰਿਹਾ ਹੈ ਤੁਹਾਡੇ ਲਈ ਇੱਕੋ ਹੀ ਬਿਵਸਥਾ ਹੋਵੇ ਜੇ ਕੋਈ ਭੁੱਲ ਕੇ ਪਾਪ ਕਰੇ। ");
INSERT INTO pan_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","ਜਿਹੜਾ ਮਨੁੱਖ ਜ਼ਬਰਦਸਤੀ ਕੁਝ ਕਰੇ, ਭਾਵੇਂ ਦੇਸੀ ਭਾਵੇਂ ਪਰਦੇਸੀ, ਉਹ ਯਹੋਵਾਹ ਦੇ ਵਿਰੁੱਧ ਕੁਫ਼ਰ ਬਕਦਾ ਹੈ। ਉਹ ਮਨੁੱਖ ਆਪਣਿਆਂ ਲੋਕਾਂ ਵਿੱਚੋਂ ਛੇਕਿਆ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","ਇਸ ਲਈ ਕਿ ਉਸ ਨੇ ਯਹੋਵਾਹ ਦੀ ਬਾਣੀ ਦਾ ਅਪਮਾਨ ਕੀਤਾ ਅਤੇ ਉਸ ਦਾ ਹੁਕਮ ਤੋੜਿਆ ਹੈ, ਉਹ ਮਨੁੱਖ ਜ਼ਰੂਰ ਹੀ ਛੇਕਿਆ ਜਾਵੇ। ਉਸ ਦੀ ਸਜ਼ਾ ਉਸ ਦੇ ਉੱਤੇ ਹੋਵੇਗੀ। ");
INSERT INTO pan_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","ਜਦ ਇਸਰਾਏਲੀ ਉਜਾੜ ਵਿੱਚ ਸਨ ਤਾਂ ਉਨ੍ਹਾਂ ਨੂੰ ਇੱਕ ਮਨੁੱਖ ਸਬਤ ਦੇ ਦਿਨ ਵਿੱਚ ਲੱਕੜੀਆਂ ਚੁਗਦਾ ਹੋਇਆ ਮਿਲਿਆ। ");
INSERT INTO pan_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","ਤਾਂ ਜਿਨ੍ਹਾਂ ਨੂੰ ਉਹ ਲੱਕੜੀਆਂ ਚੁਗਦਿਆਂ ਮਿਲਿਆ ਸੀ ਉਹ ਉਸ ਨੂੰ ਮੂਸਾ, ਹਾਰੂਨ ਅਤੇ ਸਾਰੀ ਮੰਡਲੀ ਦੇ ਕੋਲ ਲਿਆਏ। ");
INSERT INTO pan_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","ਤਾਂ ਉਨ੍ਹਾਂ ਨੇ ਉਸ ਨੂੰ ਬੰਦੀਖ਼ਾਨੇ ਦੇ ਵਿੱਚ ਰੱਖਿਆ ਕਿਉਂ ਜੋ ਅਜੇ ਤੱਕ ਇਹ ਨਹੀਂ ਪਤਾ ਸੀ ਅਜਿਹੇ ਮਨੁੱਖ ਨਾਲ ਕੀ ਕਰਨਾ ਚਾਹੀਦਾ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","ਤਾਂ ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਫ਼ਰਮਾਇਆ ਕਿ ਉਹ ਮਨੁੱਖ ਮਾਰਿਆ ਜਾਵੇ। ਸਾਰੀ ਮੰਡਲੀ ਉਹ ਨੂੰ ਪੱਥਰਾਂ ਨਾਲ ਡੇਰੇ ਤੋਂ ਬਾਹਰ ਮਾਰੇ। ");
INSERT INTO pan_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","ਸੋ ਸਾਰੀ ਮੰਡਲੀ ਉਹ ਨੂੰ ਡੇਰੇ ਤੋਂ ਬਾਹਰ ਲੈ ਗਈ ਅਤੇ ਉਹ ਨੂੰ ਪੱਥਰਾਂ ਨਾਲ ਮਾਰਿਆ ਤਾਂ ਉਹ ਮਰ ਗਿਆ ਜਿਵੇਂ ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਹੁਕਮ ਦਿੱਤਾ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਆਖਿਆ, ");
INSERT INTO pan_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","ਇਸਰਾਏਲੀਆਂ ਨਾਲ ਗੱਲ ਕਰ ਅਤੇ ਉਨ੍ਹਾਂ ਨੂੰ ਆਖ ਕਿ ਉਹ ਆਪਣੇ ਬਸਤਰ ਦੀ ਕਿਨਾਰੀ ਉੱਤੇ ਝਾਲਰ ਆਪਣੀਆਂ ਪੀੜ੍ਹੀਆਂ ਤੱਕ ਲਾਉਣ ਅਤੇ ਨੀਲਾ ਫੀਤਾ ਹਰ ਕਿਨਾਰੀ ਦੀ ਝਾਲਰ ਉੱਤੇ ਜੜਨ। ");
INSERT INTO pan_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","ਅਤੇ ਉਹ ਤੁਹਾਡੇ ਲਈ ਇੱਕ ਝਾਲਰ ਹੋਵੇ ਤਾਂ ਜੋ ਤੁਸੀਂ ਉਹ ਨੂੰ ਵੇਖ ਕੇ ਯਹੋਵਾਹ ਦੇ ਸਾਰੇ ਹੁਕਮ ਚੇਤੇ ਰੱਖੋ ਅਤੇ ਉਨ੍ਹਾਂ ਦੇ ਅਨੁਸਾਰ ਕੰਮ ਕਰੋ ਅਤੇ ਤੁਸੀਂ ਆਪਣੇ ਮਨਾਂ ਅਤੇ ਅੱਖਾਂ ਦੀ ਲੋਚਨਾ ਅਨੁਸਾਰ ਧੋਖਾ ਨਾ ਕਰੋ ਜਿਵੇਂ ਤੁਸੀਂ ਕਰਦੇ ਆਏ ਹੋ। ");
INSERT INTO pan_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","ਤਾਂ ਜੋ ਤੁਸੀਂ ਮੇਰੇ ਹੁਕਮ ਯਾਦ ਰੱਖੋ ਅਤੇ ਉਨ੍ਹਾਂ ਉੱਤੇ ਚੱਲੋ। ਇਸ ਤਰ੍ਹਾਂ ਤੁਸੀਂ ਆਪਣੇ ਪਰਮੇਸ਼ੁਰ ਲਈ ਪਵਿੱਤਰ ਹੋਵੋ। ");
INSERT INTO pan_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","ਮੈਂ ਯਹੋਵਾਹ ਤੁਹਾਡਾ ਪਰਮੇਸ਼ੁਰ ਹਾਂ ਜੋ ਤੁਹਾਨੂੰ ਮਿਸਰ ਦੇਸ ਤੋਂ ਲਿਆਇਆ ਹਾਂ ਤਾਂ ਜੋ ਮੈਂ ਤੁਹਾਡਾ ਪਰਮੇਸ਼ੁਰ ਹੋਵਾਂ। ਮੈਂ ਯਹੋਵਾਹ ਤੁਹਾਡਾ ਪਰਮੇਸ਼ੁਰ ਹਾਂ। ");
INSERT INTO pan_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","ਕਹਾਥ ਦੇ ਪੋਤੇ ਯਿਸਹਾਰ ਦੇ ਪੁੱਤਰ ਕੋਰਹ ਲੇਵੀ ਨੇ ਅਤੇ ਅਲੀਆਬ ਦੇ ਪੁੱਤਰਾਂ ਦਾਥਾਨ ਅਤੇ ਅਬੀਰਾਮ ਨੇ ਅਤੇ ਪਲਤ ਦੇ ਪੁੱਤਰ ਓਨ ਨੇ ਜਿਹੜੇ ਰਊਬੇਨੀ ਸਨ, ਮਨੁੱਖਾਂ ਨੂੰ ਨਾਲ ਲਿਆ। ");
INSERT INTO pan_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","ਉਹ ਅਤੇ ਇਸਰਾਏਲੀਆਂ ਵਿੱਚੋਂ ਢਾਈ ਸੌ ਮਨੁੱਖ ਜਿਹੜੇ ਮੰਡਲੀ ਦੇ ਪ੍ਰਧਾਨ ਅਤੇ ਮੰਡਲੀ ਦੇ ਚੁਣਵੇਂ ਅਤੇ ਨਾਮੀ ਸਨ, ਮੂਸਾ ਦੇ ਅੱਗੇ ਉੱਠੇ। ");
INSERT INTO pan_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","ਅਤੇ ਉਹ ਮੂਸਾ ਦੇ ਵਿਰੁੱਧ ਅਤੇ ਹਾਰੂਨ ਦੇ ਵਿਰੁੱਧ ਇਕੱਠੇ ਹੋਏ ਅਤੇ ਉਨ੍ਹਾਂ ਨੂੰ ਆਖਿਆ, ਹੁਣ ਤਾਂ ਬਸ ਕਰੋ ਕਿਉਂ ਜੋ ਸਾਰੀ ਮੰਡਲੀ ਦੇ ਲੋਕ ਪਵਿੱਤਰ ਹਨ ਅਤੇ ਯਹੋਵਾਹ ਉਨ੍ਹਾਂ ਦੇ ਵਿੱਚ ਹੈ। ਤੁਸੀਂ ਫਿਰ ਕਿਵੇਂ ਆਪਣੇ ਆਪ ਨੂੰ ਯਹੋਵਾਹ ਦੀ ਸਭਾ ਨਾਲੋਂ ਉੱਚਾ ਬਣਾਉਂਦੇ ਹੋ? ");
INSERT INTO pan_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","ਜਦ ਮੂਸਾ ਨੇ ਸੁਣਿਆ ਤਾਂ ਉਹ ਆਪਣੇ ਮੂੰਹ ਦੇ ਭਾਰ ਡਿੱਗਿਆ। ");
INSERT INTO pan_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","ਉਹ ਕੋਰਹ ਅਤੇ ਉਹ ਦੀ ਸਾਰੀ ਟੋਲੀ ਨੂੰ ਬੋਲਿਆ ਕਿ ਸਵੇਰ ਨੂੰ ਯਹੋਵਾਹ ਦੱਸੇਗਾ ਕਿ ਕੌਣ ਉਸ ਦਾ ਹੈ ਅਤੇ ਕੌਣ ਪਵਿੱਤਰ ਹੈ ਅਤੇ ਕਿਸਨੂੰ ਆਪਣੇ ਨੇੜੇ ਲਿਆਵੇਗਾ, ਜਿਸ ਨੂੰ ਉਹ ਚੁਣੇਗਾ ਉਹ ਨੂੰ ਨੇੜੇ ਲਿਆਵੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","ਇਹ ਕਰੋ ਕਿ ਕੋਰਹ ਅਤੇ ਉਸ ਦੀ ਸਾਰੀ ਟੋਲੀ ਆਪਣੇ ਲਈ ਧੂਪਦਾਨ ਲਓ। ");
INSERT INTO pan_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","ਅਤੇ ਕੱਲ ਨੂੰ ਉਨ੍ਹਾਂ ਵਿੱਚ ਅੱਗ ਪਾਓ ਅਤੇ ਉਨ੍ਹਾਂ ਦੇ ਵਿੱਚ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਧੂਪ ਪਾਓ ਤਾਂ ਅਜਿਹਾ ਹੋਵੇਗਾ ਕਿ ਉਹ ਮਨੁੱਖ ਜਿਸ ਨੂੰ ਯਹੋਵਾਹ ਚੁਣੇਗਾ ਉਹ ਪਵਿੱਤਰ ਹੋਵੇਗਾ। ਹੁਣ ਲੇਵੀਓ, ਤੁਸੀਂ ਵੀ ਬਸ ਕਰੋ! ");
INSERT INTO pan_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","ਤਾਂ ਮੂਸਾ ਨੇ ਕੋਰਹ ਨੂੰ ਆਖਿਆ, ਹੇ ਲੇਵੀਓ ਸੁਣੋ! ");
INSERT INTO pan_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","ਕਿ ਇਹ ਗੱਲ ਤੁਹਾਡੇ ਲਈ ਛੋਟੀ ਹੈ ਕਿ ਇਸਰਾਏਲ ਦੇ ਪਰਮੇਸ਼ੁਰ ਨੇ ਤੁਹਾਨੂੰ ਇਸਰਾਏਲੀਆਂ ਦੀ ਮੰਡਲੀ ਤੋਂ ਵੱਖਰਾ ਕੀਤਾ ਤਾਂ ਜੋ ਉਹ ਤੁਹਾਨੂੰ ਨੇੜੇ ਲਿਆਵੇ ਕਿ ਤੁਸੀਂ ਯਹੋਵਾਹ ਦੇ ਡੇਰੇ ਦੀ ਟਹਿਲ ਸੇਵਾ ਕਰੋ ਅਤੇ ਮੰਡਲੀ ਦੇ ਅੱਗੇ ਖਲੋ ਕੇ ਉਹਨਾਂ ਦੀ ਸੇਵਾ ਕਰੋ? ");
INSERT INTO pan_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","ਨਾਲੇ ਉਹ ਤੈਨੂੰ ਅਤੇ ਤੇਰੇ ਸਾਰੇ ਭਰਾਵਾਂ ਨੂੰ ਜਿਹੜੇ ਲੇਵੀ ਹਨ ਤੇਰੇ ਨੇੜੇ ਲਿਆਇਆ? ਹੁਣ ਕੀ ਤੁਸੀਂ ਜਾਜਕਾਈ ਨੂੰ ਵੀ ਦੰਦ ਮਾਰਦੇ ਹੋ? ");
INSERT INTO pan_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","ਇਸੇ ਲਈ ਤੂੰ ਅਤੇ ਤੇਰੀ ਸਾਰੀ ਟੋਲੀ ਯਹੋਵਾਹ ਦੇ ਵਿਰੁੱਧ ਇਕੱਠੀ ਹੋਈ ਅਤੇ ਹਾਰੂਨ, ਉਹ ਵਿਚਾਰਾ ਕੌਣ ਹੈ ਜੋ ਤੁਸੀਂ ਉਹ ਦੇ ਵਿਰੁੱਧ ਬੁੜ-ਬੁੜਾਉਂਦੇ ਹੋ? ");
INSERT INTO pan_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","ਤਾਂ ਮੂਸਾ ਨੇ ਅਲੀਆਬ ਦੇ ਪੁੱਤਰਾਂ ਦਾਥਾਨ ਅਤੇ ਅਬੀਰਾਮ ਨੂੰ ਸੱਦਾ ਭੇਜਿਆ ਪਰ ਉਨ੍ਹਾਂ ਨੇ ਆਖਿਆ, ਅਸੀਂ ਨਹੀਂ ਆਵਾਂਗੇ। ");
INSERT INTO pan_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","ਕੀ ਇਹ ਛੋਟੀ ਗੱਲ ਹੈ ਕਿ ਤੂੰ ਸਾਨੂੰ ਇੱਕ ਦੇਸ ਤੋਂ ਕੱਢ ਲਿਆਇਆ ਹੈਂ ਜਿੱਥੇ ਦੁੱਧ ਅਤੇ ਸ਼ਹਿਦ ਵਗਦਾ ਸੀ ਤਾਂ ਜੋ ਸਾਨੂੰ ਉਜਾੜ ਵਿੱਚ ਮਾਰੇਂ ਅਤੇ ਹੁਣ ਧੱਕੇ ਨਾਲ ਸਾਡੇ ਉੱਤੇ ਆਪਣੇ ਆਪ ਨੂੰ ਰਾਜਾ ਬਣਾਈ ਬੈਠਾ ਹੈ? ");
INSERT INTO pan_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","ਨਾਲੇ ਤੂੰ ਸਾਨੂੰ ਅਜਿਹੇ ਦੇਸ ਵਿੱਚ ਵੀ ਨਹੀਂ ਲਿਆਂਦਾ ਜਿੱਥੇ ਦੁੱਧ ਅਤੇ ਸ਼ਹਿਦ ਵਗਦਾ ਹੈ, ਨਾ ਸਾਨੂੰ ਖੇਤਾਂ ਅਤੇ ਬਾਗ਼ਾਂ ਦਾ ਅਧਿਕਾਰ ਦਿੱਤਾ ਹੈ। ਕੀ ਤੂੰ ਇਨ੍ਹਾਂ ਮਨੁੱਖਾਂ ਦੀਆਂ ਅੱਖਾਂ ਕੱਢ ਸੁੱਟੇਂਗਾ? ਅਸੀਂ ਤਾਂ ਅੱਗੇ ਨਹੀਂ ਜਾਣਾ! ");
INSERT INTO pan_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","ਤਦ ਮੂਸਾ ਡਾਢਾ ਕ੍ਰੋਧਵਾਨ ਹੋਇਆ ਅਤੇ ਉਸ ਨੇ ਯਹੋਵਾਹ ਨੂੰ ਆਖਿਆ, ਤੂੰ ਉਨ੍ਹਾਂ ਦੀ ਮੈਦੇ ਦੀ ਭੇਟ ਵੱਲ ਨਾ ਵੇਖ! ਮੈਂ ਤਾਂ ਉਨ੍ਹਾਂ ਦੀ ਇੱਕ ਗਧੀ ਵੀ ਨਹੀਂ ਲਈ, ਨਾ ਉਨ੍ਹਾਂ ਵਿੱਚੋਂ ਕਿਸੇ ਦਾ ਨੁਕਸਾਨ ਕੀਤਾ। ");
INSERT INTO pan_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","ਮੂਸਾ ਨੇ ਕੋਰਹ ਨੂੰ ਆਖਿਆ, ਤੂੰ ਅਤੇ ਤੇਰੀ ਸਾਰੀ ਟੋਲੀ ਕੱਲ ਨੂੰ ਯਹੋਵਾਹ ਅੱਗੇ ਹਾਜ਼ਰ ਹੋਵੇ, ਤੂੰ, ਉਹ ਅਤੇ ਹਾਰੂਨ। ");
INSERT INTO pan_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","ਤੁਹਾਡੇ ਵਿੱਚੋਂ ਹਰ ਮਨੁੱਖ ਆਪਣਾ ਧੂਪਦਾਨ ਲਵੇ ਅਤੇ ਤੁਸੀਂ ਉਨ੍ਹਾਂ ਵਿੱਚ ਧੂਪ ਪਾਓ ਅਤੇ ਹਰ ਮਨੁੱਖ ਆਪਣਾ ਧੂਪਦਾਨ ਅਰਥਾਤ ਢਾਈ ਸੋ ਧੂਪਦਾਨ, ਤੂੰ ਵੀ ਅਤੇ ਹਾਰੂਨ ਵੀ ਹਰ ਇੱਕ ਆਪੋ ਆਪਣਾ ਧੂਪਦਾਨ ਯਹੋਵਾਹ ਅੱਗੇ ਲਿਆਓ। ");
INSERT INTO pan_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","ਤਾਂ ਹਰ ਮਨੁੱਖ ਨੇ ਆਪਣਾ-ਆਪਣਾ ਧੂਪਦਾਨ ਲੈ ਕੇ ਉਸ ਉੱਤੇ ਅੱਗ ਪਾਈ ਅਤੇ ਉਨ੍ਹਾਂ ਉੱਤੇ ਧੂਪ ਵੀ ਪਾਈ ਅਤੇ ਮੂਸਾ ਅਤੇ ਹਾਰੂਨ ਦੇ ਨਾਲ ਮੰਡਲੀ ਦੇ ਤੰਬੂ ਦੇ ਦਰਵਾਜ਼ੇ ਕੋਲ ਖਲੋ ਗਏ। ");
INSERT INTO pan_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","ਤਾਂ ਕੋਰਹ ਨੇ ਸਾਰੀ ਟੋਲੀ ਨੂੰ ਉਨ੍ਹਾਂ ਦੇ ਵਿਰੁੱਧ ਮੰਡਲੀ ਦੇ ਤੰਬੂ ਦੇ ਦਰਵਾਜ਼ੇ ਉੱਤੇ ਇਕੱਠਾ ਕੀਤਾ ਤਦ ਯਹੋਵਾਹ ਦਾ ਪਰਤਾਪ ਸਾਰੀ ਮੰਡਲੀ ਉੱਤੇ ਪਰਗਟ ਹੋਇਆ। ");
INSERT INTO pan_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","ਤਾਂ ਯਹੋਵਾਹ ਮੂਸਾ ਨਾਲ ਅਤੇ ਹਾਰੂਨ ਨਾਲ ਬੋਲਿਆ, ");
INSERT INTO pan_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","ਇਸ ਮੰਡਲੀ ਦੇ ਵਿੱਚੋਂ ਤੁਸੀਂ ਆਪਣੇ ਆਪ ਨੂੰ ਇੱਕ ਪਾਸੇ ਕਰ ਲਓ ਕਿ ਮੈਂ ਉਨ੍ਹਾਂ ਨੂੰ ਇੱਕ ਅੱਖ ਦੇ ਫੇਰ ਵਿੱਚ ਭੱਖ ਲਵਾਂ। ");
INSERT INTO pan_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","ਤਾਂ ਉਹ ਮੂੰਹ ਦੇ ਭਾਰ ਡਿੱਗ ਪਏ ਅਤੇ ਆਖਿਆ, ਹੇ ਪਰਮੇਸ਼ੁਰ, ਤੂੰ ਜੋ ਸਾਰੇ ਸਰੀਰਾਂ ਦੀਆਂ ਆਤਮਾਵਾਂ ਦਾ ਪਰਮੇਸ਼ੁਰ ਹੈਂ, ਕੀ ਜੇ ਇੱਕ ਮਨੁੱਖ ਪਾਪ ਕਰੇ ਤਾਂ ਤੂੰ ਸਾਰੀ ਮੰਡਲੀ ਦੇ ਵਿਰੁੱਧ ਕ੍ਰੋਧਵਾਨ ਹੋਵੇਂਗਾ? ");
INSERT INTO pan_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","ਤਾਂ ਯਹੋਵਾਹ ਮੂਸਾ ਨਾਲ ਬੋਲਿਆ, ");
INSERT INTO pan_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","ਮੰਡਲੀ ਨੂੰ ਬੋਲ ਕਿ ਉਹ ਕੋਰਹ ਅਤੇ ਦਾਥਾਨ ਅਤੇ ਅਬੀਰਾਮ ਦੀ ਵੱਸੋਂ ਦੇ ਆਲੇ-ਦੁਆਲੇ ਤੋਂ ਉਤਾਹਾਂ ਚੱਲੇ ਜਾਣ। ");
INSERT INTO pan_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","ਸੋ ਮੂਸਾ ਉੱਠ ਕੇ ਦਾਥਾਨ ਅਤੇ ਅਬੀਰਾਮ ਦੇ ਕੋਲ ਗਿਆ ਅਤੇ ਇਸਰਾਏਲ ਦੇ ਬਜ਼ੁਰਗ ਵੀ ਉਸ ਦੇ ਪਿੱਛੇ-ਪਿੱਛੇ ਗਏ ");
INSERT INTO pan_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","ਉਹ ਮੰਡਲੀ ਨੂੰ ਬੋਲਿਆ ਕਿ ਇਨ੍ਹਾਂ ਦੁਸ਼ਟ ਮਨੁੱਖਾਂ ਦੇ ਤੰਬੂਆਂ ਤੋਂ ਇੱਕ ਪਾਸੇ ਹੋ ਕੇ ਦੂਰ ਹੋ ਜਾਓ ਅਤੇ ਉਨ੍ਹਾਂ ਦੀ ਕਿਸੇ ਵੀ ਵਸਤੂ ਨੂੰ ਨਾ ਛੂਹਣਾ, ਕਿਤੇ ਤੁਸੀਂ ਵੀ ਉਨ੍ਹਾਂ ਦੇ ਸਾਰੇ ਪਾਪਾਂ ਵਿੱਚ ਸਾਂਝੀ ਹੋਵੋ! ");
INSERT INTO pan_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","ਸੋ ਉਹ ਕੋਰਹ, ਦਾਥਾਨ ਅਤੇ ਅਬੀਰਾਮ ਦੀ ਵੱਸੋਂ ਦੇ ਆਲੇ-ਦੁਆਲੇ ਤੋਂ ਉਤਾਹਾਂ ਨੂੰ ਚੱਲੇ ਗਏ ਤਾਂ ਦਾਥਾਨ ਅਤੇ ਅਬੀਰਾਮ ਬਾਹਰ ਆਏ ਅਤੇ ਆਪਣੇ ਤੰਬੂਆਂ ਦੇ ਦਰਵਾਜਿਆਂ ਵਿੱਚ ਆਪਣੀਆਂ ਪਤਨੀਆਂ, ਪੁੱਤਰਾਂ ਅਤੇ ਬਾਲ-ਬੱਚਿਆਂ ਦੇ ਨਾਲ ਖੜ੍ਹੇ ਹੋ ਗਏ। ");
INSERT INTO pan_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","ਫੇਰ ਮੂਸਾ ਨੇ ਆਖਿਆ, ਤੁਸੀਂ ਇਸ ਤੋਂ ਜਾਣ ਲਵੋਗੇ ਕਿ ਯਹੋਵਾਹ ਨੇ ਮੈਨੂੰ ਭੇਜਿਆ ਹੈ, ਨਾ ਕਿ ਮੈਂ ਆਪਣੇ ਮਨ ਨਾਲ ਆਇਆ ਹਾਂ, ਜੋ ਮੈਂ ਇਨ੍ਹਾਂ ਸਾਰਿਆਂ ਕੰਮਾਂ ਨੂੰ ਕਰਾਂ। ");
INSERT INTO pan_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","ਜੇਕਰ ਉਹਨਾਂ ਮਨੁੱਖਾਂ ਦੀ ਮੌਤ ਸਭਨਾਂ ਮਨੁੱਖਾਂ ਦੇ ਵਾਂਗੂੰ ਹੋਵੇ ਅਤੇ ਉਹਨਾਂ ਦੀ ਸਜ਼ਾ ਸਭਨਾਂ ਮਨੁੱਖਾਂ ਦੇ ਵਾਲੀ ਹੋਵੇ, ਅਖ਼ੀਰ ਇਸ ਗੱਲ ਨੂੰ ਜਾਣੋ ਕਿ ਯਹੋਵਾਹ ਨੇ ਮੈਨੂੰ ਭੇਜਿਆ ਹੀ ਨਹੀਂ। ");
INSERT INTO pan_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","ਪਰ ਜੇ ਯਹੋਵਾਹ ਕੋਈ ਅਣੋਖਾ ਕੰਮ ਕਰੇ, ਅਤੇ ਭੂਮੀ ਆਪਣਾ ਮੂੰਹ ਖੋਲ੍ਹ ਕੇ ਉਹਨਾਂ ਨੂੰ ਅਤੇ ਉਹਨਾਂ ਦੀਆਂ ਸਭਨਾਂ ਵਸਤੂਆਂ ਨੂੰ ਨਿਗਲ ਲਵੇ ਅਤੇ ਉਹ ਜੀਉਂਦੇ ਜੀ ਪਤਾਲ ਵਿੱਚ ਉਤਰ ਜਾਣ ਤਾਂ ਤੁਸੀਂ ਜਾਣ ਲਓ ਕਿ ਇਨ੍ਹਾਂ ਮਨੁੱਖਾਂ ਨੇ ਯਹੋਵਾਹ ਦਾ ਨਿਰਾਦਰ ਕੀਤਾ ਹੈ! ");
INSERT INTO pan_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","ਤਦ ਅਜਿਹਾ ਹੋਇਆ ਕਿ ਜਦ ਉਹ ਇਹ ਸਾਰੀਆਂ ਗੱਲਾਂ ਬੋਲ ਚੁੱਕਿਆ ਤਾਂ ਭੂਮੀ ਜਿਹੜੀ ਉਨ੍ਹਾਂ ਦੇ ਹੇਠ ਸੀ, ਫੱਟ ਗਈ ");
INSERT INTO pan_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","ਅਤੇ ਧਰਤੀ ਨੇ ਆਪਣਾ ਮੂੰਹ ਖੋਲ੍ਹ ਕੇ ਉਨ੍ਹਾਂ ਨੂੰ, ਉਨ੍ਹਾਂ ਦੇ ਘਰਾਣਿਆਂ ਨੂੰ ਅਤੇ ਸਾਰੇ ਆਦਮੀਆਂ ਨੂੰ ਜਿਹੜੇ ਕੋਰਹ ਵੱਲ ਸਨ, ਉਨ੍ਹਾਂ ਦਾ ਸਭ ਕੁਝ ਨਿਗਲ ਲਿਆ। ");
INSERT INTO pan_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","ਇਸ ਤਰ੍ਹਾਂ ਉਹ ਅਤੇ ਉਨ੍ਹਾਂ ਦੇ ਨਾਲ ਦੇ ਜੀਉਂਦੇ ਜੀ ਪਤਾਲ ਵਿੱਚ ਉਤਰ ਗਏ ਅਤੇ ਧਰਤੀ ਨੇ ਉਨ੍ਹਾਂ ਨੂੰ ਢੱਕ ਲਿਆ ਅਤੇ ਉਹ ਸਭਾ ਵਿੱਚੋਂ ਨਾਸ ਹੋ ਗਏ। ");
INSERT INTO pan_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","ਤਦ ਸਾਰੇ ਇਸਰਾਏਲੀ ਜਿਹੜੇ ਉਨ੍ਹਾਂ ਦੇ ਆਲੇ-ਦੁਆਲੇ ਸਨ, ਉਨ੍ਹਾਂ ਦੀਆਂ ਚੀਕਾਂ ਸੁਣ ਕੇ ਇਹ ਕਹਿੰਦੇ ਹੋਏ ਦੌੜ ਗਏ ਕਿਤੇ ਅਜਿਹਾ ਨਾ ਹੋਵੇ ਕਿ ਧਰਤੀ ਸਾਨੂੰ ਵੀ ਨਿਗਲ ਲਵੇ! ");
INSERT INTO pan_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","ਤਦ ਯਹੋਵਾਹ ਵੱਲੋਂ ਅੱਗ ਨਿੱਕਲੀ ਅਤੇ ਉਹ ਉਨ੍ਹਾਂ ਧੂਪ ਧੁਖਾਉਣ ਵਾਲੇ ਢਾਈ ਸੌ ਮਨੁੱਖਾਂ ਨੂੰ ਭਸਮ ਕਰ ਗਈ। ");
INSERT INTO pan_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","ਫੇਰ ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਆਖਿਆ, ");
INSERT INTO pan_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","ਹਾਰੂਨ ਜਾਜਕ ਦੇ ਪੁੱਤਰ ਅਲਆਜ਼ਾਰ ਨੂੰ ਆਖ ਕਿ ਉਹਨਾਂ ਧੂਪਦਾਨਾਂ ਨੂੰ ਅੱਗ ਦੇ ਵਿੱਚੋਂ ਚੁੱਕ ਲੈ ਅਤੇ ਤੂੰ ਅੱਗ ਨੂੰ ਖਿਲਾਰ ਦੇ, ਕਿਉਂ ਜੋ ਉਹ ਪਵਿੱਤਰ ਹਨ। ");
INSERT INTO pan_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","ਜਿਹਨਾਂ ਨੇ ਪਾਪ ਕਰਕੇ ਆਪਣੀ ਜਾਨ ਦਾ ਨੁਕਸਾਨ ਕੀਤਾ ਹੈ ਉਹਨਾਂ ਦੇ ਧੂਪਦਾਨਾਂ ਨੂੰ ਕੁੱਟ ਕੇ ਜਗਵੇਦੀ ਦੇ ਢੱਕਣ ਲਈ ਪੱਤਰ ਬਣਾਇਆ ਜਾਵੇ, ਕਿਉਂ ਜੋ ਉਨ੍ਹਾਂ ਨੇ ਉਹਨਾਂ ਨੂੰ ਯਹੋਵਾਹ ਅੱਗੇ ਅਰਪਣ ਕੀਤਾ ਸੀ, ਇਸ ਲਈ ਉਹ ਪਵਿੱਤਰ ਹਨ ਅਤੇ ਉਹ ਇਸਰਾਏਲੀਆਂ ਦੇ ਲਈ ਇੱਕ ਨਿਸ਼ਾਨ ਹੋਵੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","ਇਸ ਲਈ ਅਲਆਜ਼ਾਰ ਜਾਜਕ ਨੇ ਉਹਨਾਂ ਪਿੱਤਲ ਦੇ ਧੂਪਦਾਨਾਂ ਨੂੰ ਲੈ ਕੇ, ਜਿਹੜੇ ਭਸਮ ਹੋਇਆਂ ਮਨੁੱਖਾਂ ਨੇ ਅਰਪਣ ਕੀਤੇ ਸਨ, ਉਹਨਾਂ ਨੂੰ ਜਗਵੇਦੀ ਦੇ ਢੱਕਣ ਲਈ ਕੁੱਟਿਆ। ");
INSERT INTO pan_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","ਇਹ ਇਸਰਾਏਲੀਆਂ ਲਈ ਇੱਕ ਯਾਦਗਾਰੀ ਹੋਵੇ ਅਤੇ ਜੇਕਰ ਕੋਈ ਮਨੁੱਖ ਜੋ ਹਾਰੂਨ ਦੀ ਅੰਸ ਦਾ ਨਾ ਹੋਵੇ, ਉਹ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਧੂਪ ਨਾ ਧੁਖਾਵੇ ਅਜਿਹਾ ਨਾ ਹੋਵੇ ਕਿ ਕੋਰਹ ਅਤੇ ਉਸ ਦੀ ਟੋਲੀ ਵਾਂਗੂੰ ਉਹ ਨਾਸ ਨਾ ਹੋ ਜਾਵੇ, ਜਿਵੇਂ ਯਹੋਵਾਹ ਨੇ ਉਸ ਨੂੰ ਮੂਸਾ ਦੇ ਰਾਹੀਂ ਆਖਿਆ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","ਦੂਸਰੇ ਦਿਨ ਇਸਰਾਏਲੀਆਂ ਦੀ ਸਾਰੀ ਮੰਡਲੀ ਇਹ ਆਖ ਕੇ ਮੂਸਾ ਅਤੇ ਹਾਰੂਨ ਦੇ ਵਿਰੁੱਧ ਬੁੜ-ਬੁੜਾਉਣ ਲੱਗੀ ਕਿ ਤੁਸੀਂ ਯਹੋਵਾਹ ਦੀ ਪਰਜਾ ਨੂੰ ਮਾਰ ਸੁੱਟਿਆ! ");
INSERT INTO pan_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","ਜਦ ਮੰਡਲੀ ਦੇ ਲੋਕ ਮੂਸਾ ਅਤੇ ਹਾਰੂਨ ਦੇ ਵਿਰੁੱਧ ਇਕੱਠੇ ਹੋਏ, ਤਦ ਉਨ੍ਹਾਂ ਨੇ ਮੰਡਲੀ ਦੇ ਤੰਬੂ ਵੱਲ ਵੇਖਿਆ ਅਤੇ ਵੇਖੋ, ਬੱਦਲ ਨੇ ਉਸ ਨੂੰ ਢੱਕ ਲਿਆ ਅਤੇ ਯਹੋਵਾਹ ਦਾ ਪਰਤਾਪ ਪ੍ਰਗਟ ਹੋਇਆ। ");
INSERT INTO pan_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","ਤਦ ਮੂਸਾ ਅਤੇ ਹਾਰੂਨ ਮੰਡਲੀ ਦੇ ਤੰਬੂ ਦੇ ਅੱਗੇ ਆਏ। ");
INSERT INTO pan_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","ਫੇਰ ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਆਖਿਆ, ");
INSERT INTO pan_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","ਤੁਸੀਂ ਇਸ ਮੰਡਲੀ ਵਿੱਚੋਂ ਨਿੱਕਲ ਜਾਓ ਤਾਂ ਜੋ ਮੈਂ ਇਨ੍ਹਾਂ ਨੂੰ ਥੋੜ੍ਹੇ ਸਮੇਂ ਵਿੱਚ ਹੀ ਨਾਸ ਕਰ ਦੇਵਾਂ! ਤਦ ਉਹ ਮੂੰਹ ਦੇ ਭਾਰ ਡਿੱਗੇ। ");
INSERT INTO pan_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","ਮੂਸਾ ਨੇ ਹਾਰੂਨ ਨੂੰ ਆਖਿਆ, ਆਪਣਾ ਧੂਪਦਾਨ ਲੈ ਕੇ ਉਸ ਉੱਤੇ ਜਗਵੇਦੀ ਦੀ ਅੱਗ ਪਾ ਅਤੇ ਧੂਪ ਪਾ ਕੇ ਛੇਤੀ ਮੰਡਲੀ ਦੇ ਕੋਲ ਲੈ ਜਾ ਅਤੇ ਉਨ੍ਹਾਂ ਲਈ ਪ੍ਰਾਸਚਿਤ ਕਰ, ਕਿਉਂ ਜੋ ਯਹੋਵਾਹ ਦਾ ਕ੍ਰੋਧ ਭੜਕਿਆ ਹੈ ਅਤੇ ਬਵਾ ਸ਼ੁਰੂ ਹੋ ਚੁੱਕੀ ਹੈ! ");
INSERT INTO pan_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","ਤਦ ਮੂਸਾ ਦੇ ਆਖਣ ਅਨੁਸਾਰ ਹਾਰੂਨ ਧੂਪਦਾਨ ਲੈ ਕੇ ਸਭਾ ਵਿੱਚ ਦੌੜ ਗਿਆ ਅਤੇ ਵੇਖੋ, ਪਰਜਾ ਵਿੱਚ ਬਵਾ ਫੈਲੀ ਹੋਈ ਸੀ ਅਤੇ ਉਸ ਨੇ ਧੂਪ ਪਾ ਕੇ ਪਰਜਾ ਲਈ ਪ੍ਰਾਸਚਿਤ ਕੀਤਾ। ");
INSERT INTO pan_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","ਉਹ ਮੁਰਦਿਆਂ ਅਤੇ ਜੀਉਂਦਿਆਂ ਦੇ ਵਿਚਕਾਰ ਖੜ੍ਹਾ ਸੀ, ਤਦ ਬਵਾ ਰੁਕ ਗਈ। ");
INSERT INTO pan_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","ਜਿਹੜੇ ਕੋਰਹ ਦੀ ਮੰਡਲੀ ਨਾਲ ਮਰੇ, ਉਹਨਾਂ ਤੋਂ ਇਲਾਵਾ ਬਵਾ ਨਾਲ ਮਰਨ ਵਾਲਿਆਂ ਦੀ ਗਿਣਤੀ ਚੌਦਾਂ ਹਜ਼ਾਰ ਸੱਤ ਸੌ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","ਫੇਰ ਹਾਰੂਨ ਮੂਸਾ ਦੇ ਕੋਲ ਮੰਡਲੀ ਦੇ ਤੰਬੂ ਦੇ ਦਰਵਾਜ਼ੇ ਕੋਲ ਮੁੜ ਆਇਆ, ਤਦ ਬਵਾ ਰੁਕ ਗਈ। ");
INSERT INTO pan_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਆਖਿਆ, ");
INSERT INTO pan_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","ਇਸਰਾਏਲੀਆਂ ਨੂੰ ਆਖ ਅਤੇ ਉਨ੍ਹਾਂ ਤੋਂ ਗੋਤਾਂ ਦੇ ਅਨੁਸਾਰ ਉਹਨਾਂ ਦੇ ਸਾਰਿਆਂ ਪ੍ਰਧਾਨਾਂ ਦੇ ਕੋਲੋਂ ਇੱਕ-ਇੱਕ ਢਾਂਗਾ ਲੈ ਅਤੇ ਉਹਨਾਂ ਉੱਤੇ ਉਹਨਾਂ ਦੇ ਬਾਰਾਂ ਪੁਰਖਿਆਂ ਦੇ ਨਾਮ ਲਿਖ। ");
INSERT INTO pan_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","ਤੂੰ ਹਾਰੂਨ ਦਾ ਨਾਮ ਲੇਵੀ ਦੇ ਢਾਂਗੇ ਉੱਤੇ ਲਿਖੀਂ ਕਿਉਂ ਜੋ ਇੱਕ-ਇੱਕ ਢਾਂਗਾ ਉਨ੍ਹਾਂ ਦੇ ਪੁਰਖਿਆਂ ਦੇ ਘਰਾਣਿਆਂ ਦੇ ਹਰ ਮੁਖੀਏ ਦੇ ਲਈ ਹੋਵੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","ਅਤੇ ਉਨ੍ਹਾਂ ਢਾਂਗਿਆਂ ਨੂੰ ਮੰਡਲੀ ਦੇ ਤੰਬੂ ਵਿੱਚ ਉਸ ਸਾਖੀ ਦੇ ਸੰਦੂਕ ਅੱਗੇ ਜਿੱਥੇ ਮੈਂ ਤੈਨੂੰ ਮਿਲਦਾ ਹਾਂ, ਰੱਖਦੇ। ");
INSERT INTO pan_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","ਜਿਸ ਮਨੁੱਖ ਨੂੰ ਮੈਂ ਚੁਣਾਂਗਾ, ਉਸ ਦੇ ਢਾਂਗੇ ਵਿੱਚੋਂ ਕੁੰਬਲਾਂ ਨਿੱਕਲ ਆਉਣਗੀਆਂ ਅਤੇ ਮੈਂ ਆਪਣੀ ਵੱਲੋਂ ਇਸਰਾਏਲੀਆਂ ਦੀ ਬੁੜ ਬੁੜਾਹਟ ਨੂੰ, ਜਿਹੜੀ ਉਹ ਤੁਹਾਡੇ ਵਿਰੁੱਧ ਬੁੜ-ਬੁੜਾਉਂਦੇ ਹਨ, ਦੂਰ ਕਰ ਦਿਆਂਗਾ। ");
INSERT INTO pan_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","ਮੂਸਾ ਨੇ ਇਸਰਾਏਲੀਆਂ ਨੂੰ ਇਹ ਗੱਲ ਆਖੀ ਅਤੇ ਉਨ੍ਹਾਂ ਦੇ ਸਾਰੇ ਪ੍ਰਧਾਨਾਂ ਨੇ ਆਪਣੇ ਲਈ, ਆਪਣੇ ਪੁਰਖਿਆਂ ਦੇ ਗੋਤਾਂ ਦੇ ਅਨੁਸਾਰ ਢਾਂਗੇ ਦਿੱਤੇ, ਇਸ ਤਰ੍ਹਾਂ ਬਾਰਾਂ ਢਾਂਗੇ ਹੋਏ ਅਤੇ ਉਨ੍ਹਾਂ ਬਾਰਾਂ ਢਾਂਗਿਆਂ ਵਿੱਚ ਹਾਰੂਨ ਦਾ ਢਾਂਗਾ ਵੀ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","ਮੂਸਾ ਨੇ ਉਨ੍ਹਾਂ ਢਾਂਗਿਆਂ ਨੂੰ ਸਾਖੀ ਦੇ ਤੰਬੂ ਵਿੱਚ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਰੱਖ ਦਿੱਤਾ। ");
INSERT INTO pan_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","ਦੂਜੇ ਦਿਨ ਮੂਸਾ ਸਾਖੀ ਦੇ ਤੰਬੂ ਵਿੱਚ ਗਿਆ, ਅਤੇ ਕੀ ਵੇਖਿਆ ਕਿ ਹਾਰੂਨ ਦਾ ਢਾਂਗਾ ਜੋ ਲੇਵੀ ਦੇ ਪਰਿਵਾਰ ਦਾ ਸੀ, ਉਸ ਵਿੱਚੋਂ ਕੁੰਬਲਾਂ ਫੁੱਟੀਆਂ ਹੋਈਆਂ ਸਨ ਅਰਥਾਤ ਉਸ ਉੱਤੇ ਫੁੱਲ ਅਤੇ ਪੱਕੇ ਬਦਾਮ ਵੀ ਲੱਗੇ ਹੋਏ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","ਤਦ ਮੂਸਾ ਉਹਨਾਂ ਸਾਰਿਆਂ ਢਾਂਗਿਆਂ ਨੂੰ ਯਹੋਵਾਹ ਦੇ ਅੱਗੋਂ ਲੈ ਕੇ ਇਸਰਾਏਲੀਆਂ ਕੋਲ ਬਾਹਰ ਲੈ ਆਇਆ ਅਤੇ ਉਨ੍ਹਾਂ ਨੇ ਆਪਣੇ-ਆਪਣੇ ਢਾਂਗੇ ਨੂੰ ਪਹਿਚਾਣ ਕੇ ਲੈ ਲਿਆ। ");
INSERT INTO pan_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਆਖਿਆ, ਹਾਰੂਨ ਦਾ ਢਾਂਗਾ ਵਿਦਰੋਹ ਕਰਨ ਵਾਲਿਆਂ ਲਈ ਨਿਸ਼ਾਨ ਹੋਣ ਲਈ ਮੋੜ ਕੇ, ਸਾਖੀ ਦੇ ਅੱਗੇ ਫਿਰ ਰੱਖਦੇ ਤਾਂ ਜੋ ਤੂੰ ਮੇਰੇ ਵਿਰੁੱਧ ਉਨ੍ਹਾਂ ਦੀ ਬੁੜ ਬੁੜਾਹਟ ਨੂੰ ਮਿਟਾ ਦੇਵੇ ਕਿਤੇ ਅਜਿਹਾ ਨਾ ਹੋਵੇ ਕਿ ਮਰ ਜਾਣ। ");
INSERT INTO pan_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","ਮੂਸਾ ਨੇ ਉਸੇ ਤਰ੍ਹਾਂ ਹੀ ਕੀਤਾ, ਜਿਵੇਂ ਯਹੋਵਾਹ ਨੇ ਉਹ ਨੂੰ ਹੁਕਮ ਦਿੱਤਾ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","ਉਪਰੰਤ ਇਸਰਾਏਲੀਆਂ ਨੇ ਮੂਸਾ ਨੂੰ ਆਖਿਆ ਕਿ ਵੇਖ, ਸਾਡੀ ਜਾਨ ਮੁੱਕ ਚੱਲੀ ਹੈਂ। ਅਸੀਂ ਨਾਸ ਹੋ ਗਏ ਹਾਂ! ਅਸੀਂ ਸਾਰੇ ਦੇ ਸਾਰੇ ਨਾਸ ਹੋ ਗਏ ਹਾਂ। ");
INSERT INTO pan_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","ਜੋ ਕੋਈ ਯਹੋਵਾਹ ਦੇ ਡੇਰੇ ਦੇ ਨੇੜੇ ਜਾਂਦਾ ਉਹ ਮਰ ਜਾਂਦਾ ਹੈ। ਕੀ ਅਸੀਂ ਵੀ ਸਾਰੇ ਮਰ ਜਾਂਵਾਂਗੇ? ");
INSERT INTO pan_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","ਫੇਰ ਯਹੋਵਾਹ ਨੇ ਹਾਰੂਨ ਨੂੰ ਆਖਿਆ, ਪਵਿੱਤਰ ਸਥਾਨ ਦੀ ਬੁਰਾਈ ਦਾ ਭਾਰ ਤੇਰੇ ਉੱਤੇ, ਤੇਰੇ ਪੁੱਤਰਾਂ ਉੱਤੇ ਅਤੇ ਤੇਰੇ ਪਿਤਾ ਦੇ ਪਰਿਵਾਰ ਉੱਤੇ ਹੋਵੇਗਾ ਅਤੇ ਤੇਰੀ ਜਾਜਕਾਈ ਦੀ ਬੁਰਾਈ ਦਾ ਭਾਰ ਵੀ ਤੇਰੇ ਨਾਲ, ਤੇਰੇ ਪੁੱਤਰਾਂ ਉੱਤੇ ਹੋਵੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","ਅਤੇ ਲੇਵੀ ਦਾ ਗੋਤ ਅਰਥਾਤ ਤੇਰੇ ਪੁਰਖਿਆਂ ਦੇ ਗੋਤ ਵਾਲੇ ਜਿਹੜੇ ਤੇਰੇ ਭਰਾ ਹਨ ਉਹਨਾਂ ਨੂੰ ਵੀ ਆਪਣੇ ਨਾਲ ਲਿਆਇਆ ਕਰ ਅਤੇ ਉਹ ਤੇਰੇ ਨਾਲ ਮਿਲ ਜਾਣ ਅਤੇ ਉਹ ਤੇਰੀ ਟਹਿਲ ਸੇਵਾ ਕਰਿਆ ਕਰਨ, ਪਰ ਸਾਖੀ ਦੇ ਤੰਬੂ ਦੇ ਸਾਹਮਣੇ ਤੂੰ ਅਤੇ ਤੇਰੇ ਪੁੱਤਰ ਹੀ ਆਉਣ। ");
INSERT INTO pan_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","ਤਾਂ ਜੋ ਉਹ ਤੇਰੀ ਅਤੇ ਸਾਰੇ ਤੰਬੂ ਦੀ ਜ਼ਿੰਮੇਵਾਰੀ ਨੂੰ ਸੰਭਾਲਣ ਪਰ ਪਵਿੱਤਰ ਸਥਾਨ ਦੇ ਭਾਂਡਿਆਂ ਕੋਲ ਅਤੇ ਜਗਵੇਦੀ ਕੋਲ ਉਹ ਨਾ ਆਉਣ ਤਾਂ ਜੋ ਉਹ ਅਤੇ ਤੁਸੀਂ ਮਰ ਨਾ ਜਾਓ। ");
INSERT INTO pan_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","ਪਰ ਉਹ ਤੇਰੇ ਨਾਲ ਮਿਲ ਜਾਣ ਅਤੇ ਉਹ ਮੰਡਲੀ ਦੇ ਤੰਬੂ ਦੀ ਜ਼ਿੰਮੇਵਾਰੀ ਨੂੰ ਸੰਭਾਲਣ। ਉਹ ਤੰਬੂ ਦੀ ਸਾਰੀ ਟਹਿਲ ਸੇਵਾ ਕਰਨ ਪਰ ਹੋਰ ਕੋਈ ਵੀ ਤੁਹਾਡੇ ਨੇੜੇ ਨਾ ਆਵੇ। ");
INSERT INTO pan_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","ਤੁਸੀਂ ਪਵਿੱਤਰ ਸਥਾਨ ਅਤੇ ਜਗਵੇਦੀ ਦੀ ਜ਼ਿੰਮੇਵਾਰੀ ਨੂੰ ਸੰਭਾਲੋ ਤਾਂ ਜੋ ਕ੍ਰੋਧ ਫੇਰ ਇਸਰਾਏਲੀਆਂ ਦੇ ਉੱਤੇ ਨਾ ਭੜਕੇ। ");
INSERT INTO pan_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","ਪਰ ਮੈਂ ਆਪ ਤੁਹਾਡੇ ਲੇਵੀ ਭਰਾਵਾਂ ਨੂੰ ਇਸਰਾਏਲੀਆਂ ਦੇ ਵਿੱਚੋਂ ਅਲੱਗ ਕਰ ਲਿਆ ਹੈ। ਅਤੇ ਉਹ ਮੰਡਲੀ ਦੇ ਤੰਬੂ ਦੀ ਟਹਿਲ ਸੇਵਾ ਕਰਨ ਲਈ ਤੁਹਾਨੂੰ ਅਤੇ ਯਹੋਵਾਹ ਨੂੰ ਸਮਰਪਤ ਕੀਤੇ ਗਏ ਹਨ। ");
INSERT INTO pan_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","ਪਰ ਤੂੰ ਅਤੇ ਤੇਰੇ ਪੁੱਤਰ ਆਪਣੀ ਜਾਜਕਾਈ ਨੂੰ ਜਗਵੇਦੀ ਦਾ ਅਤੇ ਪਰਦੇ ਦੇ ਅੰਦਰਲਾ ਸਭ ਕੁਝ ਸੰਭਾਲੋ, ਇਸ ਤਰ੍ਹਾਂ ਤੁਸੀਂ ਉਪਾਸਨਾ ਕਰੋ। ਮੈਂ ਤੁਹਾਨੂੰ ਜਾਜਕਾਈ ਦੀ ਸੇਵਾ ਦਾਨ ਦੇ ਰੂਪ ਵਿੱਚ ਦਿੱਤੀ ਹੈ, ਪਰ ਜੇ ਕੋਈ ਅਜਨਬੀ ਹੋਵੇ ਜੇ ਉਹ ਉਸ ਦੇ ਨੇੜ੍ਹੇ ਆਵੇ ਤਾਂ ਉਹ ਮਾਰਿਆ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","ਫੇਰ ਯਹੋਵਾਹ ਹਾਰੂਨ ਨੂੰ ਬੋਲਿਆ, ਵੇਖ, ਮੈਂ ਆਪ ਤੈਨੂੰ ਚੁੱਕਣ ਦੀਆਂ ਭੇਟਾਂ ਦੀ ਜ਼ਿੰਮੇਵਾਰੀ ਦਿੱਤੀ ਹੈ ਅਤੇ ਇਸਰਾਏਲੀਆਂ ਦੀਆਂ ਸਾਰੀਆਂ ਪਵਿੱਤਰ ਚੀਜ਼ਾਂ ਤੈਨੂੰ ਮਸਹ ਹੋਣ ਦੇ ਕਾਰਨ ਅਤੇ ਤੇਰੇ ਪੁੱਤਰਾਂ ਨੂੰ ਸਦਾ ਦੇ ਹੱਕ ਲਈ ਦਿੱਤੀਆਂ ਹਨ। ");
INSERT INTO pan_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","ਇਹ ਤੇਰੇ ਲਈ ਅੱਤ ਪਵਿੱਤਰ ਚੀਜ਼ਾਂ ਤੋਂ ਹੋਣਗੀਆਂ ਜਿਹੜੀਆਂ ਅੱਗ ਤੋਂ ਬਚੀਆਂ ਰਹਿਣ। ਇਸਰਾਏਲ ਦੇ ਸਾਰੇ ਚੜ੍ਹਾਵੇ ਅਰਥਾਤ ਉਨ੍ਹਾਂ ਦੀਆਂ ਮੈਦੇ ਦੀਆਂ ਭੇਟਾਂ, ਉਨ੍ਹਾਂ ਦੀਆਂ ਪਾਪ ਬਲੀ ਦੀਆਂ ਭੇਟਾਂ, ਅਤੇ ਉਨ੍ਹਾਂ ਦੇ ਅਪਰਾਧ ਦੀਆਂ ਭੇਟਾਂ ਜਿਹੜੀਆਂ ਉਹ ਮੈਨੂੰ ਚੜ੍ਹਾਉਂਦੇ ਹਨ, ਤੇਰੇ ਲਈ ਅਤੇ ਤੇਰੇ ਪੁੱਤਰਾਂ ਲਈ ਅੱਤ ਪਵਿੱਤਰ ਹੋਣਗੀਆਂ। ");
INSERT INTO pan_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","ਤੁਸੀਂ ਉਨ੍ਹਾਂ ਨੂੰ ਅੱਤ ਪਵਿੱਤਰ ਜਾਣਦੇ ਹੋਏ ਖਾਓ। ਹਰ ਇੱਕ ਪੁਰਖ ਉਨ੍ਹਾਂ ਨੂੰ ਖਾਵੇ। ਉਹ ਤੇਰੇ ਲਈ ਪਵਿੱਤਰ ਹੋਣਗੀਆਂ। ");
INSERT INTO pan_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","ਅਤੇ ਤੇਰੇ ਲਈ ਇਹ ਵੀ ਹੈ ਕਿ ਉਨ੍ਹਾਂ ਦੇ ਦਾਨ ਦੀ ਚੁੱਕਣ ਵਾਲੀ ਭੇਟ ਅਰਥਾਤ ਇਸਰਾਏਲੀਆਂ ਦੀਆਂ ਸਾਰੀਆਂ ਹਿਲਾਉਣ ਵਾਲੀਆਂ ਭੇਟਾਂ, ਮੈਂ ਤੈਨੂੰ ਅਤੇ ਤੇਰੇ ਸੰਗ ਤੇਰੇ ਪੁੱਤਰਾਂ ਅਤੇ ਤੇਰੀਆਂ ਧੀਆਂ ਨੂੰ ਸਦਾ ਦੇ ਹੱਕ ਲਈ ਦਿੱਤੀਆਂ ਹਨ। ਹਰ ਇੱਕ ਜਿਹੜਾ ਤੇਰੇ ਘਰ ਵਿੱਚ ਸ਼ੁੱਧ ਹੋਵੇ ਉਹ ਉਨ੍ਹਾਂ ਨੂੰ ਖਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","ਸਭ ਤੋਂ ਚੰਗਾ ਸਾਰਾ ਤੇਲ, ਸਭ ਤੋਂ ਚੰਗਾ ਸਾਰਾ ਦਾਖਰਸ, ਅੰਨ ਅਤੇ ਉਨ੍ਹਾਂ ਦੇ ਪਹਿਲੇ ਫਲ ਜਿਹੜੇ ਉਹ ਯਹੋਵਾਹ ਲਈ ਦਿੰਦੇ ਹਨ, ਸੋ ਮੈਂ ਤੁਹਾਨੂੰ ਦਿੰਦਾ ਹਾਂ। ");
INSERT INTO pan_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","ਉਨ੍ਹਾਂ ਦੀ ਧਰਤੀ ਦੇ ਪਹਿਲੇ ਫਲ ਜਿਹੜੇ ਉਹ ਯਹੋਵਾਹ ਲਈ ਲਿਆਉਂਦੇ ਹਨ, ਉਹ ਤੇਰੇ ਹੋਣਗੇ। ਹਰ ਇੱਕ ਜਿਹੜਾ ਤੇਰੇ ਘਰ ਵਿੱਚ ਹੈ ਅਤੇ ਸ਼ੁੱਧ ਹੋਵੇ, ਉਹ ਖਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","ਇਸਰਾਏਲੀਆਂ ਵਿੱਚ ਸਾਰੀਆਂ ਅਰਪਣ ਕੀਤੀਆਂ ਹੋਈਆਂ ਚੀਜ਼ਾਂ ਤੇਰੀਆਂ ਹੋਣਗੀਆਂ। ");
INSERT INTO pan_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","ਸਾਰੇ ਪਹਿਲੌਠੇ ਜਿਹੜੇ ਉਹ ਯਹੋਵਾਹ ਲਈ ਲਿਆਉਣ ਭਾਵੇਂ ਆਦਮੀ ਦਾ ਭਾਵੇਂ ਪਸ਼ੂ ਦਾ, ਉਹ ਵੀ ਤੇਰੇ ਲਈ ਹੋਣਗੇ ਤਾਂ ਵੀ ਆਦਮੀ ਦੇ ਪਹਿਲੌਠੇ ਦੇ ਨਿਸਤਾਰੇ ਦਾ ਮੁੱਲ ਜ਼ਰੂਰ ਦੇਣਾ ਨਾਲੇ ਅਸ਼ੁੱਧ ਪਸ਼ੂਆਂ ਦੇ ਪਹਿਲੌਠਿਆਂ ਦੇ ਨਿਸਤਾਰੇ ਦਾ ਮੁੱਲ ਦੇਣਾ। ");
INSERT INTO pan_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","ਜਿਨ੍ਹਾਂ ਦੇ ਨਿਸਤਾਰੇ ਦਾ ਮੁੱਲ ਤੂੰ ਦੇਣਾ ਹੋਵੇ ਅਰਥਾਤ ਇੱਕ ਮਹੀਨੇ ਤੋਂ ਉੱਪਰ ਵਾਲੇ ਦਾ ਤੂੰ ਨਿਸਤਾਰੇ ਦਾ ਮੁੱਲ ਦੇ ਅਰਥਾਤ ਆਪਣੇ ਠਹਿਰਾਏ ਹੋਏ ਲੇਖੇ ਅਨੁਸਾਰ ਚਾਂਦੀ ਦੇ ਪੰਜ ਰੁਪਏ ਪਵਿੱਤਰ ਸਥਾਨ ਦੇ ਸ਼ਕੇਲ ਅਨੁਸਾਰ ਜਿਹੜਾ ਵੀਹ ਗੀਰਹ ਦਾ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","ਪਰੰਤੂ ਗਊ ਦਾ ਪਹਿਲੌਠੇ, ਭੇਡ ਦੇ ਪਹਿਲੌਠੇ ਅਤੇ ਬੱਕਰੀ ਦੇ ਪਹਿਲੌਠੇ ਦਾ ਨਿਸਤਾਰੇ ਦਾ ਮੁੱਲ ਨਾ ਦੇਣਾ, ਉਹ ਪਵਿੱਤਰ ਹਨ। ਉਨ੍ਹਾਂ ਦਾ ਲਹੂ ਤੂੰ ਜਗਵੇਦੀ ਉੱਤੇ ਛਿੜਕੀਂ ਅਤੇ ਉਨ੍ਹਾਂ ਦੀ ਚਰਬੀ ਯਹੋਵਾਹ ਲਈ ਸੁਗੰਧਤਾ ਕਰਕੇ ਅੱਗ ਦੀ ਭੇਟ ਲਈ ਸਾੜ ਦੇਵੀਂ। ");
INSERT INTO pan_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","ਉਨ੍ਹਾਂ ਦਾ ਮਾਸ ਤੇਰਾ ਹੋਵੇਗਾ ਜਿਵੇਂ ਹਿਲਾਈ ਹੋਈ ਛਾਤੀ ਅਤੇ ਸੱਜਾ ਪੱਟ ਤੇਰੇ ਹਨ। ");
INSERT INTO pan_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","ਸਾਰੀਆਂ ਪਵਿੱਤਰ ਚੀਜ਼ਾਂ ਦੀਆਂ ਚੁੱਕਣ ਵਾਲੀਆਂ ਭੇਟਾਂ ਜਿਹੜੀਆਂ ਇਸਰਾਏਲੀ ਯਹੋਵਾਹ ਲਈ ਚੁੱਕਣ, ਮੈਂ ਤੈਨੂੰ ਅਤੇ ਤੇਰੇ ਪੁੱਤਰਾਂ ਅਤੇ ਤੇਰੀਆਂ ਧੀਆਂ ਨੂੰ ਤੇਰੇ ਨਾਲ ਸਦਾ ਦੇ ਹੱਕ ਲਈ ਦਿੱਤੀਆਂ ਹਨ। ਇਹ ਲੂਣ ਦਾ ਸਦਾ ਦਾ ਨੇਮ ਯਹੋਵਾਹ ਅੱਗੇ ਤੇਰੇ ਲਈ ਅਤੇ ਤੇਰੀ ਅੰਸ ਲਈ ਹੋਵੇ। ");
INSERT INTO pan_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","ਤਦ ਯਹੋਵਾਹ ਨੇ ਹਾਰੂਨ ਨੂੰ ਆਖਿਆ, ਇਸਰਾਏਲੀਆਂ ਦੀ ਧਰਤੀ ਵਿੱਚ ਕੋਈ ਹਿੱਸਾ ਨਾ ਲਵੀਂ, ਨਾ ਉਨ੍ਹਾਂ ਵਿੱਚ ਤੇਰਾ ਕੋਈ ਹਿੱਸਾ ਹੋਵੇਗਾ। ਤੇਰਾ ਹਿੱਸਾ ਅਤੇ ਤੇਰਾ ਵਿਰਸਾ ਇਸਰਾਏਲੀਆਂ ਵਿੱਚ ਮੈਂ ਹੀ ਹਾਂ। ");
INSERT INTO pan_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","ਅਤੇ ਵੇਖੋ, ਲੇਵੀਆਂ ਲਈ ਮੈਂ ਇਸਰਾਏਲੀਆਂ ਦੇ ਸਾਰਿਆਂ ਦਸਵੰਧਾਂ ਨੂੰ ਉਨ੍ਹਾਂ ਦੇ ਵਿਰਸੇ ਵਿੱਚ, ਉਸ ਟਹਿਲ ਸੇਵਾ ਦੇ ਬਦਲੇ ਜਿਹੜੀ ਉਹ ਮੰਡਲੀ ਦੇ ਤੰਬੂ ਵਿੱਚ ਕਰਦੇ ਹਨ, ਦੇ ਦਿੱਤਾ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","ਇਸ ਲਈ ਅੱਗੇ ਤੋਂ ਇਸਰਾਏਲੀ ਮੰਡਲੀ ਦੇ ਤੰਬੂ ਦੇ ਨੇੜੇ ਨਾ ਆਉਣ ਕਿਤੇ ਅਜਿਹਾ ਨਾ ਹੋਵੇ ਕਿ ਪਾਪ ਦਾ ਬੋਝ ਉਹਨਾਂ ਉੱਤੇ ਹੋਵੇ ਅਤੇ ਉਹ ਮਰ ਜਾਣ। ");
INSERT INTO pan_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","ਪਰ ਲੇਵੀ ਮੰਡਲੀ ਦੇ ਤੰਬੂ ਦੀ ਟਹਿਲ ਸੇਵਾ ਕਰਨ ਅਤੇ ਉਹ ਆਪਣੀ ਬਦੀ ਨੂੰ ਆਪ ਚੁੱਕਣ। ਇਹ ਬਿਧੀ ਤੁਹਾਡੀਆਂ ਪੀੜ੍ਹੀਆਂ ਲਈ ਸਦਾ ਦੀ ਹੋਵੇ, ਪਰ ਇਸਰਾਏਲੀਆਂ ਦੇ ਵਿੱਚ ਉਹ ਵਿਰਸਾ ਨਾ ਪਾਉਣਗੇ। ");
INSERT INTO pan_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","ਕਿਉਂ ਜੋ ਇਸਰਾਏਲੀਆਂ ਦੇ ਦਸਵੰਧ ਨੂੰ ਜਿਹੜਾ ਉਹ ਯਹੋਵਾਹ ਲਈ ਚੁੱਕਣ ਦੀ ਭੇਟ ਕਰਕੇ ਲਿਆਉਂਦੇ ਹਨ, ਮੈਂ ਲੇਵੀਆਂ ਨੂੰ ਵਿਰਸੇ ਵਿੱਚ ਦੇ ਦਿੱਤਾ ਹੈ। ਇਸ ਲਈ ਮੈਂ ਉਨ੍ਹਾਂ ਨੂੰ ਆਖਿਆ ਕਿ ਉਹ ਇਸਰਾਏਲੀਆਂ ਵਿੱਚ ਜਾਇਦਾਦ ਨਾ ਪਾਉਣਗੇ। ");
INSERT INTO pan_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਆਖਿਆ, ");
INSERT INTO pan_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","ਲੇਵੀਆਂ ਨੂੰ ਆਖ ਕਿ ਜਦ ਤੁਸੀਂ ਇਸਰਾਏਲੀਆਂ ਤੋਂ ਦਸਵੰਧ ਲੈਂਦੇ ਹੋ, ਜਿਹੜਾ ਮੈਂ ਤੁਹਾਨੂੰ ਉਨ੍ਹਾਂ ਵੱਲੋਂ ਤੁਹਾਡੇ ਵਿਰਸੇ ਵਿੱਚ ਦਿੱਤਾ ਹੈ ਤਾਂ ਤੁਸੀਂ ਯਹੋਵਾਹ ਲਈ ਉਸ ਤੋਂ ਚੁੱਕਣ ਦੀ ਭੇਟ ਚੜ੍ਹਾਓ, ਅਰਥਾਤ ਦਸਵੰਧ ਦਾ ਦਸਵੰਧ। ");
INSERT INTO pan_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","ਇਹ ਤੁਹਾਡੇ ਲੇਖੇ ਵਿੱਚ ਚੁੱਕਣ ਦੀ ਭੇਟ ਗਿਣੀ ਜਾਵੇ, ਜਿਵੇਂ ਇਹ ਪਿੜ ਦਾ ਅੰਨ ਅਤੇ ਕੋਹਲੂ ਦੇ ਦਾਖ਼ਰਸ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","ਇਸ ਤਰ੍ਹਾਂ ਤੁਸੀਂ ਵੀ ਯਹੋਵਾਹ ਲਈ ਚੁੱਕਣ ਦੀ ਭੇਟ ਆਪਣਿਆਂ ਸਾਰਿਆਂ ਦਸਵੰਧਾਂ ਤੋਂ ਜਿਹੜੇ ਤੁਸੀਂ ਇਸਰਾਏਲੀਆਂ ਤੋਂ ਲੈਂਦੇ ਹੋ ਚੜ੍ਹਾਓਗੇ ਅਤੇ ਤੁਸੀਂ ਉਨ੍ਹਾਂ ਤੋਂ ਯਹੋਵਾਹ ਦੀ ਚੁੱਕਣ ਦੀ ਭੇਟ ਹਾਰੂਨ ਜਾਜਕ ਨੂੰ ਦਿਓ। ");
INSERT INTO pan_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","ਆਪਣਿਆਂ ਸਾਰਿਆਂ ਦਾਨਾਂ ਤੋਂ ਤੁਸੀਂ ਯਹੋਵਾਹ ਲਈ ਚੁੱਕਣ ਦੀ ਭੇਟ, ਉਸ ਦੀ ਚਿਕਨਾਈ ਤੋਂ ਅਰਥਾਤ ਉਸ ਦੇ ਪਵਿੱਤਰ ਕੀਤੇ ਹੋਏ ਹਿੱਸੇ ਤੋਂ ਚੜ੍ਹਾਓ। ");
INSERT INTO pan_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","ਅਤੇ ਤੂੰ ਲੇਵੀਆਂ ਨੂੰ ਆਖ ਕਿ ਜਦ ਤੁਸੀਂ ਉਸ ਦੀ ਚਿਕਨਾਈ ਚੜ੍ਹਾਉਂਦੇ ਹੋ ਤਾਂ ਉਹ ਲੇਵੀਆਂ ਦੇ ਲੇਖੇ ਵਿੱਚ ਗਿਣੀ ਜਾਵੇ ਜਿਵੇਂ ਪਿੜ ਦੇ ਵਾਧੇ ਅਤੇ ਕੋਹਲੂ ਦੀ ਵਾਫ਼ਰੀ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","ਤਾਂ ਤੁਸੀਂ ਉਹ ਨੂੰ ਸਾਰਿਆਂ ਥਾਵਾਂ ਵਿੱਚ ਖਾਓ, ਤੁਸੀਂ ਅਤੇ ਤੁਹਾਡੇ ਪਰਿਵਾਰ ਕਿਉਂ ਜੋ ਉਹ ਤੁਹਾਡੇ ਲਈ ਮੰਡਲੀ ਦੇ ਤੰਬੂ ਦੀ ਟਹਿਲ ਸੇਵਾ ਦੇ ਬਦਲੇ ਤੁਹਾਡਾ ਇਨਾਮ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","ਅਤੇ ਤੁਸੀਂ ਉਸ ਦੇ ਕਰਨ ਪਾਪ ਨਾ ਕਰਿਓ ਜਦ ਤੁਸੀਂ ਉਸ ਦੀ ਚਿਕਨਾਈ ਵਿੱਚੋਂ ਚੁੱਕਿਆ, ਅਤੇ ਤੁਸੀਂ ਇਸਰਾਏਲੀਆਂ ਦੀਆਂ ਪਵਿੱਤਰ ਚੀਜ਼ਾਂ ਨੂੰ ਭਰਿਸ਼ਟ ਨਾ ਕਰੋ ਅਜਿਹਾ ਨਾ ਹੋਵੇ ਕਿ ਤੁਸੀਂ ਮਰ ਜਾਓ। ");
INSERT INTO pan_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","ਯਹੋਵਾਹ ਮੂਸਾ ਅਤੇ ਹਾਰੂਨ ਨੂੰ ਬੋਲਿਆ, ");
INSERT INTO pan_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","ਇਹ ਬਿਵਸਥਾ ਦੀ ਬਿਧੀ ਹੈ ਜਿਸ ਦਾ ਯਹੋਵਾਹ ਨੇ ਹੁਕਮ ਦਿੱਤਾ ਕਿ ਇਸਰਾਏਲੀਆਂ ਨੂੰ ਬੋਲ ਕਿ ਉਹ ਤੇਰੇ ਕੋਲ ਇੱਕ ਲਾਲ ਨਰੋਈ ਵੱਛੀ ਲਿਆਉਣ ਜਿਹੜੀ ਦੋਸ਼ ਰਹਿਤ ਹੋਵੇ ਅਤੇ ਜਿਸ ਦੇ ਉੱਤੇ ਜੂਲਾ ਨਾ ਰੱਖਿਆ ਗਿਆ ਹੋਵੇ। ");
INSERT INTO pan_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","ਤਦ ਤੁਸੀਂ ਉਹ ਨੂੰ ਅਲਆਜ਼ਾਰ ਜਾਜਕ ਨੂੰ ਦਿਓ ਅਤੇ ਉਹ ਉਸ ਨੂੰ ਡੇਰੇ ਤੋਂ ਬਾਹਰ ਲੈ ਜਾਵੇ ਅਤੇ ਉਹ ਦੇ ਸਾਹਮਣੇ ਕੋਈ ਉਸ ਨੂੰ ਕੱਟੇ। ");
INSERT INTO pan_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","ਫੇਰ ਅਲਆਜ਼ਾਰ ਜਾਜਕ ਆਪਣੀ ਉਂਗਲੀ ਨਾਲ ਉਸ ਦੇ ਲਹੂ ਵਿੱਚੋਂ ਲੈ ਕੇ ਮੰਡਲੀ ਦੇ ਤੰਬੂ ਦੇ ਅਗਲੇ ਪਾਸੇ ਵੱਲ ਸੱਤ ਵਾਰ ਉਸ ਲਹੂ ਨੂੰ ਛਿੜਕੇ। ");
INSERT INTO pan_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","ਤਾਂ ਕੋਈ ਉਸ ਗਾਂ ਨੂੰ ਚਮੜੇ, ਮਾਸ, ਲਹੂ ਅਤੇ ਗੋਹੇ ਸਮੇਤ ਉਹ ਦੀਆਂ ਅੱਖਾਂ ਦੇ ਸਾਹਮਣੇ ਸਾੜੇ। ");
INSERT INTO pan_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","ਫੇਰ ਜਾਜਕ ਦਿਆਰ ਦੀ ਲੱਕੜੀ ਅਤੇ ਜੂਫ਼ਾ ਅਤੇ ਲਾਲ ਰੰਗ ਦਾ ਕੱਪੜਾ ਲੈ ਕੇ ਅੱਗ ਵਿੱਚ ਸੁੱਟੇ ਜਿਸ ਵਿੱਚ ਉਸ ਵੱਛੀ ਨੂੰ ਸਾੜਿਆ ਗਿਆ ਹੋਵੇ। ");
INSERT INTO pan_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","ਫੇਰ ਜਾਜਕ ਆਪਣੇ ਕੱਪੜੇ ਧੋਵੇ ਅਤੇ ਇਸ਼ਨਾਨ ਕਰੇ। ਉਸ ਦੇ ਮਗਰੋਂ ਉਹ ਡੇਰੇ ਵਿੱਚ ਆਵੇ ਪਰ ਉਹ ਜਾਜਕ ਸ਼ਾਮ ਤੱਕ ਅਸ਼ੁੱਧ ਰਹੇ। ");
INSERT INTO pan_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","ਅਤੇ ਸਾੜਨ ਵਾਲਾ ਵੀ ਆਪਣੇ ਕੱਪੜੇ ਧੋਵੇ ਅਤੇ ਇਸ਼ਨਾਨ ਕਰੇ ਅਤੇ ਸ਼ਾਮ ਤੱਕ ਅਸ਼ੁੱਧ ਰਹੇ। ");
INSERT INTO pan_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","ਕੋਈ ਸ਼ੁੱਧ ਮਨੁੱਖ ਗਾਂ ਦੀ ਸੁਆਹ ਇਕੱਠੀ ਕਰੇ ਅਤੇ ਉਹ ਨੂੰ ਡੇਰੇ ਤੋਂ ਬਾਹਰ ਸ਼ੁੱਧ ਸਥਾਨ ਵਿੱਚ ਰੱਖੇ ਅਤੇ ਉਹ ਇਸਰਾਏਲੀਆਂ ਦੀ ਮੰਡਲੀ ਲਈ ਅਸ਼ੁੱਧਤਾਈ ਦੂਰ ਕਰਨ ਦਾ ਜਲ ਕਰਕੇ ਰੱਖੀ ਜਾਵੇ, ਉਹ ਪਾਪ ਦੀ ਭੇਟ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","ਅਤੇ ਜਿਹੜਾ ਗਾਂ ਦੀ ਸੁਆਹ ਇਕੱਠੀ ਕਰਦਾ ਹੈ ਉਹ ਆਪਣੇ ਕੱਪੜੇ ਧੋਵੇ ਅਤੇ ਉਹ ਸ਼ਾਮ ਤੱਕ ਅਸ਼ੁੱਧ ਰਹੇਗਾ। ਇਹ ਇਸਰਾਏਲੀਆਂ ਦੇ ਲਈ ਅਤੇ ਉਹਨਾਂ ਵਿੱਚ ਵੱਸਣ ਵਾਲੇ ਪਰਦੇਸੀਆਂ ਲਈ ਸਦਾ ਦੀ ਬਿਧੀ ਹੋਵੇ। ");
INSERT INTO pan_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","ਜੇ ਕੋਈ ਕਿਸੇ ਆਦਮੀ ਦੀ ਲਾਸ਼ ਨੂੰ ਛੂਹੇ ਉਹ ਸੱਤ ਦਿਨ ਅਸ਼ੁੱਧ ਰਹੇ। ");
INSERT INTO pan_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","ਉਹ ਤੀਜੇ ਦਿਨ ਆਪਣੇ ਆਪ ਨੂੰ ਉਹ ਦੇ ਨਾਲ ਸ਼ੁੱਧ ਕਰੇ ਤਾਂ ਸੱਤਵੇਂ ਦਿਨ ਉਹ ਸ਼ੁੱਧ ਹੋਵੇਗਾ ਪਰ ਜੇ ਉਹ ਤੀਜੇ ਦਿਨ ਆਪਣੇ ਆਪ ਨੂੰ ਸ਼ੁੱਧ ਨਾ ਕਰੇ ਤਾਂ ਸੱਤਵੇਂ ਦਿਨ ਵੀ ਉਹ ਸ਼ੁੱਧ ਨਹੀਂ ਹੋਵੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","ਜੋ ਕੋਈ ਕਿਸੇ ਆਦਮੀ ਦੀ ਲਾਸ਼ ਛੂਹੇ ਅਤੇ ਆਪਣੇ ਆਪ ਨੂੰ ਸ਼ੁੱਧ ਨਾ ਕਰੇ ਉਹ ਯਹੋਵਾਹ ਦੇ ਡੇਰੇ ਨੂੰ ਭਰਿਸ਼ਟ ਕਰਦਾ ਹੈ ਸੋ ਉਹ ਮਨੁੱਖ ਇਸਰਾਏਲ ਵਿੱਚੋਂ ਛੇਕਿਆ ਜਾਵੇ, ਇਸ ਲਈ ਕਿ ਅਸ਼ੁੱਧਤਾਈ ਦਾ ਜਲ ਉਹ ਦੇ ਉੱਤੇ ਨਹੀਂ ਛਿੜਕਿਆ ਗਿਆ, ਉਹ ਅਸ਼ੁੱਧ ਹੋਵੇਗਾ। ਉਹ ਅਜੇ ਅਸ਼ੁੱਧ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","ਜਦ ਕੋਈ ਮਨੁੱਖ ਤੰਬੂ ਵਿੱਚ ਮਰ ਜਾਵੇ ਤਾਂ ਉਸ ਲਈ ਇਹ ਬਿਵਸਥਾ ਹੈ। ਜੋ ਕੋਈ ਤੰਬੂ ਵਿੱਚ ਵੜੇ ਅਤੇ ਜੋ ਕੋਈ ਤੰਬੂ ਵਿੱਚ ਹੋਵੇ ਸੱਤ ਦਿਨ ਤੱਕ ਅਸ਼ੁੱਧ ਰਹੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","ਸਾਰੇ ਭਾਂਡੇ ਜਿਨ੍ਹਾਂ ਉੱਤੇ ਕੋਈ ਢੱਕਣ ਨਾ ਹੋਵੇ, ਉਹ ਅਸ਼ੁੱਧ ਹਨ। ");
INSERT INTO pan_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","ਜੋ ਕੋਈ ਮੈਦਾਨ ਵਿੱਚ ਤਲਵਾਰ ਨਾਲ ਵੱਢੇ ਹੋਏ ਨੂੰ ਜਾਂ ਕਿਸੇ ਲਾਸ਼ ਨੂੰ ਜਾਂ ਆਦਮੀ ਦੀ ਹੱਡੀ ਨੂੰ ਜਾਂ ਕਿਸੇ ਕਬਰ ਨੂੰ ਛੂਹੇ ਉਹ ਸੱਤ ਦਿਨ ਤੱਕ ਅਸ਼ੁੱਧ ਰਹੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","ਅਤੇ ਉਸ ਅਸ਼ੁੱਧ ਮਨੁੱਖ ਲਈ ਪਾਪ ਦੀ ਭੇਟ ਦੀ ਸੁਆਹ ਨੂੰ ਲੈ ਕੇ ਇੱਕ ਭਾਂਡੇ ਵਿੱਚ ਪਾ ਕੇ ਉਸ ਉੱਤੇ ਵਗਦਾ ਪਾਣੀ ਪਾਇਆ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","ਅਤੇ ਕੋਈ ਸ਼ੁੱਧ ਮਨੁੱਖ ਜੂਫ਼ਾ ਲੈ ਕੇ ਉਸ ਜਲ ਵਿੱਚ ਡਬੋਵੇ, ਫੇਰ ਉਸ ਤੰਬੂ ਉੱਤੇ, ਸਾਰਿਆਂ ਭਾਂਡਿਆਂ ਉੱਤੇ, ਉਨ੍ਹਾਂ ਪ੍ਰਾਣੀਆਂ ਜਿਹੜੇ ਉੱਥੇ ਸਨ, ਨਾਲੇ ਉਸ ਉੱਤੇ ਜਿਸ ਨੇ ਹੱਡੀ ਨੂੰ ਜਾਂ ਵੱਢੇ ਹੋਏ ਨੂੰ ਜਾਂ ਲਾਸ਼ ਨੂੰ ਜਾਂ ਕਬਰ ਨੂੰ ਛੂਹਿਆ ਹੋਵੇ, ਉਸ ਉੱਤੇ ਛਿੜਕੇ। ");
INSERT INTO pan_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","ਅਤੇ ਸ਼ੁੱਧ ਪੁਰਖ ਤੀਜੇ ਦਿਨ ਅਤੇ ਸੱਤਵੇਂ ਦਿਨ ਅਸ਼ੁੱਧ ਪੁਰਖ ਉੱਤੇ ਇਸ ਨੂੰ ਛਿੜਕੇ ਅਤੇ ਇਸ ਤਰ੍ਹਾਂ ਸੱਤਵੇਂ ਦਿਨ ਉਹ ਨੂੰ ਸ਼ੁੱਧ ਕਰੇ। ਉਹ ਆਪਣੇ ਕੱਪੜੇ ਧੋਵੇ ਅਤੇ ਅਸ਼ਨਾਨ ਕਰੇ ਤਾਂ ਉਹ ਸ਼ਾਮ ਨੂੰ ਸ਼ੁੱਧ ਹੋਵੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","ਪਰ ਜਿਹੜਾ ਮਨੁੱਖ ਅਸ਼ੁੱਧ ਰਹੇ ਅਤੇ ਆਪਣੇ ਆਪ ਨੂੰ ਸ਼ੁੱਧ ਨਾ ਕਰੇ, ਉਹ ਪ੍ਰਾਣੀ ਸਭਾ ਵਿੱਚੋਂ ਕੱਢਿਆ ਜਾਵੇ ਕਿਉਂ ਜੋ ਉਹ ਨੇ ਯਹੋਵਾਹ ਦੇ ਪਵਿੱਤਰ ਸਥਾਨ ਨੂੰ ਭਰਿਸ਼ਟ ਕੀਤਾ। ਅਸ਼ੁੱਧਤਾਈ ਦਾ ਜਲ ਉਹ ਦੇ ਉੱਤੇ ਨਹੀਂ ਛਿੜਕਿਆ ਗਿਆ ਸੋ ਉਹ ਅਸ਼ੁੱਧ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","ਅਤੇ ਉਨ੍ਹਾਂ ਲਈ ਇਹ ਸਦਾ ਦੀ ਬਿਧੀ ਹੋਵੇਗੀ ਅਤੇ ਅਸ਼ੁੱਧਤਾਈ ਦੇ ਜਲ ਦਾ ਛਿੜਕਣ ਵਾਲਾ ਆਪਣੇ ਕੱਪੜੇ ਧੋਵੇ ਅਤੇ ਅਸ਼ੁੱਧਤਾਈ ਦੇ ਜਲ ਨੂੰ ਛੂਹਣ ਵਾਲਾ ਸ਼ਾਮ ਤੱਕ ਅਸ਼ੁੱਧ ਰਹੇ। ");
INSERT INTO pan_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","ਅਤੇ ਜੋ ਕੁਝ ਉਹ ਅਸ਼ੁੱਧ ਮਨੁੱਖ ਛੂਹੇ ਉਹ ਵੀ ਅਸ਼ੁੱਧ ਹੋਵੇਗਾ ਅਤੇ ਜਿਹੜਾ ਮਨੁੱਖ ਉਸ ਚੀਜ਼ ਨੂੰ ਛੂਹੇ ਉਹ ਸ਼ਾਮ ਤੱਕ ਅਸ਼ੁੱਧ ਰਹੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","ਇਸਰਾਏਲੀਆਂ ਦੀ ਸਾਰੀ ਮੰਡਲੀ ਪਹਿਲੇ ਮਹੀਨੇ ਵਿੱਚ ਸੀਨ ਦੀ ਉਜਾੜ ਵਿੱਚ ਆਈ ਅਤੇ ਪਰਜਾ ਕਾਦੇਸ਼ ਵਿੱਚ ਰਹਿਣ ਲੱਗੀ ਅਤੇ ਉੱਥੇ ਮਿਰਯਮ ਮਰ ਗਈ ਅਤੇ ਉੱਥੇ ਦੱਬ ਦਿੱਤੀ ਗਈ। ");
INSERT INTO pan_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","ਉੱਥੇ ਮੰਡਲੀ ਲਈ ਪਾਣੀ ਨਹੀਂ ਸੀ ਇਸ ਕਾਰਨ ਉਹ ਮੂਸਾ ਅਤੇ ਹਾਰੂਨ ਦੇ ਵਿਰੁੱਧ ਇਕੱਠੀ ਹੋਈ। ");
INSERT INTO pan_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","ਅਤੇ ਪਰਜਾ ਮੂਸਾ ਨਾਲ ਝਗੜਨ ਲੱਗੀ ਅਤੇ ਉਨ੍ਹਾਂ ਨੇ ਆਖਿਆ, ਭਲਾ ਹੁੰਦਾ ਜੇ ਅਸੀਂ ਵੀ ਮਰ ਜਾਂਦੇ ਜਦੋਂ ਸਾਡੇ ਭਰਾ ਯਹੋਵਾਹ ਅੱਗੇ ਮਰ ਗਏ ਸਨ! ");
INSERT INTO pan_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","ਤੁਸੀਂ ਯਹੋਵਾਹ ਦੀ ਸਭਾ ਨੂੰ ਕਿਉਂ ਇਸ ਉਜਾੜ ਵਿੱਚ ਲੈ ਕੇ ਆਏ ਹੋ, ਕਿ ਅਸੀਂ ਅਤੇ ਸਾਡੇ ਪਸ਼ੂ ਇੱਥੇ ਮਰ ਜਾਈਏ? ");
INSERT INTO pan_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","ਤੁਸੀਂ ਕਿਉਂ ਸਾਨੂੰ ਮਿਸਰ ਤੋਂ ਕੱਢ ਕੇ ਲਿਆਏ? ਤੁਸੀਂ ਸਾਨੂੰ ਇਸ ਬੁਰੇ ਥਾਂ ਵਿੱਚ ਲਿਆਂਦਾ ਜਿੱਥੇ ਨਾ ਬੀਜ ਨਾ ਹੰਜ਼ੀਰ, ਨਾ ਦਾਖ ਦੀ ਵੇਲ, ਨਾ ਅਨਾਰ ਅਤੇ ਨਾ ਪੀਣ ਲਈ ਪਾਣੀ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","ਤਾਂ ਮੂਸਾ ਅਤੇ ਹਾਰੂਨ, ਸਭਾ ਦੇ ਅੱਗੋਂ, ਮੰਡਲੀ ਦੇ ਤੰਬੂ ਦੇ ਦਰਵਾਜ਼ੇ ਕੋਲ ਜਾ ਕੇ ਮੂੰਹ ਦੇ ਭਾਰ ਡਿੱਗੇ ਤਾਂ ਯਹੋਵਾਹ ਦਾ ਪਰਤਾਪ ਉਨ੍ਹਾਂ ਉੱਤੇ ਪਰਗਟ ਹੋਇਆ। ");
INSERT INTO pan_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਆਖਿਆ, ");
INSERT INTO pan_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","ਢਾਂਗਾ ਲੈ ਕੇ ਮੰਡਲੀ ਨੂੰ ਇਕੱਠਾ ਕਰ, ਤੂੰ ਅਤੇ ਤੇਰਾ ਭਰਾ ਹਾਰੂਨ, ਉਨ੍ਹਾਂ ਦੇ ਵੇਖਦਿਆਂ ਪੱਥਰੀਲੀ ਚੱਟਾਨ ਨੂੰ ਬੋਲੋ ਕਿ ਉਹ ਆਪਣਾ ਪਾਣੀ ਦੇਵੇ ਅਤੇ ਤੂੰ ਉਨ੍ਹਾਂ ਲਈ ਚੱਟਾਨ ਤੋਂ ਪਾਣੀ ਕੱਢੇਂਗਾ। ਇਸ ਤਰ੍ਹਾਂ ਤੂੰ ਇਸ ਮੰਡਲੀ ਨੂੰ ਅਤੇ ਉਨ੍ਹਾਂ ਦੇ ਪਸ਼ੂਆਂ ਨੂੰ ਪਾਣੀ ਪਿਲਾਵੇਂਗਾ। ");
INSERT INTO pan_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","ਉਪਰੰਤ ਮੂਸਾ ਨੇ ਯਹੋਵਾਹ ਦੇ ਅੱਗੋਂ ਢਾਂਗਾ ਲਿਆ ਜਿਵੇਂ ਯਹੋਵਾਹ ਨੇ ਹੁਕਮ ਦਿੱਤਾ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","ਮੂਸਾ ਅਤੇ ਹਾਰੂਨ ਨੇ ਸਭਾ ਨੂੰ ਉਸ ਚੱਟਾਨ ਦੇ ਅੱਗੇ ਇਕੱਠਾ ਕੀਤਾ ਅਤੇ ਉਸ ਨੇ ਉਨ੍ਹਾਂ ਨੂੰ ਆਖਿਆ, ਸੁਣੋ ਤੁਸੀਂ ਝਗੜਾ ਕਰਨ ਵਾਲਿਓ, ਕੀ ਅਸੀਂ ਤੁਹਾਡੇ ਲਈ ਇਸ ਚੱਟਾਨ ਤੋਂ ਪਾਣੀ ਕੱਢੀਏ? ");
INSERT INTO pan_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","ਫੇਰ ਮੂਸਾ ਨੇ ਆਪਣਾ ਹੱਥ ਚੁੱਕ ਕੇ ਉਸ ਚੱਟਾਨ ਨੂੰ ਆਪਣੇ ਢਾਂਗੇ ਨਾਲ ਦੋ ਵਾਰ ਮਾਰਿਆ ਤਾਂ ਬਹੁਤ ਪਾਣੀ ਨਿੱਕਲ ਆਇਆ ਤਾਂ ਮੰਡਲੀ ਦੇ ਲੋਕ ਅਤੇ ਉਨ੍ਹਾਂ ਦੇ ਪਸ਼ੂਆਂ ਨੇ ਪੀਤਾ। ");
INSERT INTO pan_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਅਤੇ ਹਾਰੂਨ ਨੂੰ ਆਖਿਆ, ਇਸ ਲਈ ਕਿ ਤੁਸੀਂ ਮੇਰਾ ਵਿਸ਼ਵਾਸ ਨਹੀਂ ਕੀਤਾ ਅਤੇ ਇਸਰਾਏਲੀਆਂ ਦੀਆਂ ਅੱਖਾਂ ਵਿੱਚ ਮੈਨੂੰ ਪਵਿੱਤਰ ਨਹੀਂ ਠਹਿਰਾਇਆ, ਹੁਣ ਤੁਸੀਂ ਇਸ ਸਭਾ ਨੂੰ ਉਸ ਧਰਤੀ ਵਿੱਚ ਜਿਹੜੀ ਮੈਂ ਉਨ੍ਹਾਂ ਨੂੰ ਦਿੱਤੀ, ਨਹੀਂ ਲੈ ਕੇ ਜਾ ਸਕੋਗੇ। ");
INSERT INTO pan_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","ਇਸ ਲਈ ਇਸ ਸਥਾਨ ਦਾ ਨਾਮ ਮਰੀਬਾਹ ਪਿਆ ਕਿਉਂ ਜੋ ਇਸਰਾਏਲੀਆਂ ਨੇ ਯਹੋਵਾਹ ਨਾਲ ਝਗੜਾ ਕੀਤਾ ਅਤੇ ਉਹ ਉਨ੍ਹਾਂ ਦੇ ਵਿੱਚ ਪਵਿੱਤਰ ਠਹਿਰਾਇਆ ਗਿਆ। ");
INSERT INTO pan_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","ਫੇਰ ਮੂਸਾ ਨੇ ਕਾਦੇਸ਼ ਤੋਂ ਅਦੋਮ ਦੇ ਰਾਜੇ ਕੋਲ ਸੰਦੇਸ਼ਵਾਹਕ ਭੇਜ ਕੇ ਆਖਿਆ, ਇਸਰਾਏਲ ਤੁਹਾਡਾ ਭਰਾ ਆਖਦਾ ਹੈ ਕਿ ਤੁਸੀਂ ਉਹ ਸਾਰਾ ਕਸ਼ਟ ਜਾਣਦੇ ਹੋ, ਜੋ ਸਾਡੇ ਉੱਤੇ ਆਇਆ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","ਕਿਵੇਂ ਸਾਡੇ ਪਿਉ-ਦਾਦੇ ਮਿਸਰ ਨੂੰ ਗਏ ਅਤੇ ਅਸੀਂ ਮਿਸਰ ਵਿੱਚ ਬਹੁਤ ਦਿਨਾਂ ਤੱਕ ਰਹੇ ਅਤੇ ਫੇਰ ਮਿਸਰੀਆਂ ਨੇ ਸਾਡੇ ਨਾਲ ਅਤੇ ਸਾਡੇ ਪੁਰਖਿਆਂ ਨਾਲ ਬੁਰਾ ਵਿਵਹਾਰ ਕੀਤਾ। ");
INSERT INTO pan_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","ਪਰ ਜਦੋਂ ਅਸੀਂ ਯਹੋਵਾਹ ਅੱਗੇ ਦੁਹਾਈ ਦਿੱਤੀ ਤਦ ਉਸ ਨੇ ਸਾਡੀ ਬੇਨਤੀ ਸੁਣੀ ਅਤੇ ਉਹ ਇੱਕ ਦੂਤ ਭੇਜ ਕੇ ਸਾਨੂੰ ਮਿਸਰ ਦੇਸ ਤੋਂ ਕੱਢ ਲਿਆਇਆ ਹੈ ਇਸ ਲਈ ਅਸੀਂ ਕਾਦੇਸ਼ ਸ਼ਹਿਰ ਵਿੱਚ ਹਾਂ, ਜਿਹੜਾ ਤੁਹਾਡੀ ਸਰਹੱਦ ਉੱਤੇ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","ਸਾਨੂੰ ਆਪਣੇ ਦੇਸ ਦੇ ਵਿੱਚ ਦੀ ਲੰਘਣ ਦਿਓ ਅਤੇ ਅਸੀਂ ਖੇਤਾਂ ਜਾਂ ਅੰਗੂਰੀ ਬਾਗ਼ਾਂ ਦੇ ਵਿੱਚ ਦੀ ਹੋ ਕੇ ਨਾ ਲੰਘਾਂਗੇ ਅਤੇ ਅਸੀਂ ਖੂਹ ਦਾ ਪਾਣੀ ਨਹੀਂ ਪੀਵਾਂਗੇ, ਅਸੀਂ ਰਾਜੇ ਦੀ ਬਣਾਈ ਹੋਈ ਸੜਕ ਤੋਂ ਹੀ ਲੰਘ ਜਾਂਵਾਂਗੇ, ਅਸੀਂ ਸੱਜੇ ਜਾਂ ਖੱਬੇ ਨਹੀਂ ਮੁੜਾਂਗੇ, ਜਦ ਤੱਕ ਅਸੀਂ ਤੁਹਾਡੀਆਂ ਹੱਦਾਂ ਤੋਂ ਪਾਰ ਨਾ ਲੰਘ ਜਾਈਏ। ");
INSERT INTO pan_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","ਪਰ ਅਦੋਮ ਦੇ ਰਾਜੇ ਨੇ ਉਸ ਨੂੰ ਉੱਤਰ ਦਿੱਤਾ, ਤੁਸੀਂ ਮੇਰੇ ਦੇਸ ਵਿੱਚੋਂ ਨਹੀਂ ਲੰਘੋਗੇ ਨਹੀਂ ਤਾਂ ਮੈਂ ਤੁਹਾਡਾ ਤਲਵਾਰ ਨਾਲ ਸਾਹਮਣਾ ਕਰਾਂਗਾ। ");
INSERT INTO pan_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","ਤਦ ਇਸਰਾਏਲੀਆਂ ਨੇ ਉਹਨਾਂ ਦੇ ਕੋਲ ਫੇਰ ਸੁਨੇਹਾ ਭੇਜਿਆ, ਅਸੀਂ ਰਸਤੇ ਤੋਂ ਹੁੰਦੇ ਹੋਏ ਜਾਂਵਾਂਗੇ, ਜੇਕਰ ਅਸੀਂ ਅਤੇ ਸਾਡੇ ਪਸ਼ੂਆਂ ਨੇ ਤੁਹਾਡਾ ਪਾਣੀ ਪੀਤਾ ਤਾਂ ਅਸੀਂ ਉਸ ਦਾ ਮੁੱਲ ਦੇ ਦੇਵਾਂਗੇ। ਕੁਝ ਹੋਰ ਨਹੀਂ ਸਿਰਫ਼ ਸਾਨੂੰ ਪੈਦਲ ਲੰਘ ਜਾਣ ਦੇ। ");
INSERT INTO pan_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","ਪਰ ਉਸ ਨੇ ਆਖਿਆ, ਤੁਸੀਂ ਲੰਘ ਨਹੀਂ ਸਕੋਗੇ। ਅਦੋਮ ਵੱਡੀ ਸੈਨਾਂ ਲੈ ਕੇ ਉਹਨਾਂ ਦਾ ਸਾਹਮਣਾ ਕਰਨ ਲਈ ਨਿੱਕਲਿਆ। ");
INSERT INTO pan_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","ਇਸ ਤਰ੍ਹਾਂ ਅਦੋਮ ਨੇ ਇਸਰਾਏਲ ਨੂੰ ਆਪਣੇ ਦੇਸ ਵਿੱਚੋਂ ਦੀ ਲੰਘਣ ਦੀ ਇਜਾਜ਼ਤ ਨਾ ਦਿੱਤੀ, ਇਸ ਲਈ ਇਸਰਾਏਲੀ ਉੱਥੋਂ ਮੁੜ੍ਹ ਗਏ। ");
INSERT INTO pan_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","ਤਦ ਇਸਰਾਏਲੀਆਂ ਦੀ ਸਾਰੀ ਮੰਡਲੀ ਕਾਦੇਸ਼ ਤੋਂ ਕੂਚ ਕਰਕੇ, ਹੋਰ ਨਾਮ ਦੇ ਪਰਬਤ ਨੂੰ ਆਈ। ");
INSERT INTO pan_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","ਤਦ ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਅਤੇ ਹਾਰੂਨ ਨੂੰ ਹੋਰ ਨਾਮ ਦੇ ਪਰਬਤ ਉੱਤੇ ਜਿਹੜਾ ਅਦੋਮ ਦੇਸ ਦੀ ਹੱਦ ਉੱਤੇ ਹੈ, ਆਖਿਆ, ");
INSERT INTO pan_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","ਹਾਰੂਨ ਆਪਣੇ ਲੋਕਾਂ ਵਿੱਚ ਜਾ ਮਿਲੇਗਾ ਅਤੇ ਉਹ ਉਸ ਧਰਤੀ ਵਿੱਚ ਦਾਖ਼ਿਲ ਨਾ ਹੋ ਸਕੇਗਾ, ਜਿਹੜੀ ਮੈਂ ਇਸਰਾਏਲੀਆਂ ਨੂੰ ਦਿੱਤੀ ਹੈ ਕਿਉਂਕਿ ਤੁਸੀਂ ਮਰੀਬਾਹ ਦੇ ਸੋਤੇ ਉੱਤੇ ਮੇਰੇ ਹੁਕਮਾਂ ਦੇ ਵਿਰੁੱਧ ਝਗੜਾ ਕੀਤਾ। ");
INSERT INTO pan_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","ਇਸ ਲਈ ਤੂੰ ਹਾਰੂਨ ਅਤੇ ਉਸ ਦੇ ਪੁੱਤਰ ਅਲਆਜ਼ਾਰ ਨੂੰ, ਹੋਰ ਨਾਮ ਦੇ ਪਰਬਤ ਉੱਤੇ ਲੈ ਚੱਲ। ");
INSERT INTO pan_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","ਹਾਰੂਨ ਦੇ ਬਸਤਰ ਉਸ ਉੱਤੋਂ ਉਤਾਰ ਕੇ ਉਸ ਦੇ ਪੁੱਤਰ ਅਲਆਜ਼ਾਰ ਨੂੰ ਪਹਿਨਾ, ਤਦ ਹਾਰੂਨ ਉੱਥੇ ਹੀ ਮਰ ਜਾਵੇਗਾ ਅਤੇ ਆਪਣੇ ਲੋਕਾਂ ਵਿੱਚ ਜਾ ਮਿਲੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","ਤਦ ਮੂਸਾ ਨੇ ਉਸੇ ਤਰ੍ਹਾਂ ਹੀ ਕੀਤਾ, ਜਿਵੇਂ ਯਹੋਵਾਹ ਨੇ ਹੁਕਮ ਦਿੱਤਾ ਸੀ ਅਤੇ ਉਹ ਸਾਰੀ ਮੰਡਲੀ ਦੇ ਵੇਖਦਿਆਂ ਹੀ ਹੋਰ ਨਾਮ ਦੇ ਪਰਬਤ ਉੱਤੇ ਚੜ੍ਹ ਗਏ। ");
INSERT INTO pan_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","ਤਦ ਮੂਸਾ ਨੇ ਹਾਰੂਨ ਦੇ ਬਸਤਰ ਉਤਾਰ ਕੇ, ਉਸ ਦੇ ਪੁੱਤਰ ਅਲਆਜ਼ਾਰ ਨੂੰ ਪਹਿਨਾਏ ਅਤੇ ਹਾਰੂਨ ਉਸ ਪਰਬਤ ਦੀ ਟੀਸੀ ਉੱਤੇ ਮਰ ਗਿਆ ਫੇਰ ਮੂਸਾ ਅਤੇ ਅਲਆਜ਼ਾਰ ਪਰਬਤ ਤੋਂ ਹੇਠਾਂ ਉਤਰ ਆਏ। ");
INSERT INTO pan_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","ਜਦ ਇਸਰਾਏਲ ਦੀ ਸਾਰੀ ਮੰਡਲੀ ਨੇ ਵੇਖਿਆ ਕਿ ਹਾਰੂਨ ਮਰ ਗਿਆ ਹੈ ਤਦ ਇਸਰਾਏਲ ਦੇ ਸਾਰੇ ਪਰਿਵਾਰ ਹਾਰੂਨ ਦੇ ਲਈ ਤੀਹ ਦਿਨ ਤੱਕ ਸੋਗ ਕਰਦੇ ਰਹੇ। ");
INSERT INTO pan_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","ਤਦ ਅਰਾਦ ਦਾ ਕਨਾਨੀ ਰਾਜਾ, ਜਿਹੜਾ ਦੱਖਣ ਦੇਸ ਵਿੱਚ ਰਹਿੰਦਾ ਸੀ, ਉਸ ਨੇ ਸੁਣਿਆ ਕਿ ਇਸਰਾਏਲੀ ਅਥਾਰੀਮ ਦੇ ਰਾਹ ਤੋਂ ਆ ਰਹੇ ਹਨ ਤਦ ਉਹ ਇਸਰਾਏਲ ਨਾਲ ਲੜਿਆ ਅਤੇ ਉਨ੍ਹਾਂ ਵਿੱਚੋਂ ਕਈਆਂ ਨੂੰ ਗੁਲਾਮ ਬਣਾ ਲਿਆ। ");
INSERT INTO pan_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","ਤਦ ਇਸਰਾਏਲੀਆਂ ਨੇ ਯਹੋਵਾਹ ਅੱਗੇ ਪ੍ਰਣ ਕਰਕੇ ਆਖਿਆ, ਜੇ ਤੂੰ ਇਨ੍ਹਾਂ ਲੋਕਾਂ ਨੂੰ ਸੱਚ-ਮੁੱਚ ਸਾਡੇ ਹੱਥ ਵਿੱਚ ਦੇ ਦੇਵੇਂ ਤਾਂ ਅਸੀਂ ਉਨ੍ਹਾਂ ਦੇ ਸ਼ਹਿਰਾਂ ਦਾ ਸੱਤਿਆਨਾਸ ਕਰ ਦਿਆਂਗੇ। ");
INSERT INTO pan_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","ਤਦ ਯਹੋਵਾਹ ਨੇ ਇਸਰਾਏਲ ਦੀ ਬੇਨਤੀ ਸੁਣੀ ਅਤੇ ਕਨਾਨੀਆਂ ਨੂੰ ਉਹਨਾਂ ਦੇ ਵੱਸ ਵਿੱਚ ਕਰ ਦਿੱਤਾ, ਤਦ ਉਨ੍ਹਾਂ ਨੇ ਉਹਨਾਂ ਦੇ ਸ਼ਹਿਰਾਂ ਦਾ ਸੱਤਿਆਨਾਸ ਕਰ ਦਿੱਤਾ ਅਤੇ ਉਸ ਥਾਂ ਦਾ ਨਾਮ ਹਾਰਮਾਹ ਪੈ ਗਿਆ। ");
INSERT INTO pan_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","ਤਦ ਉਨ੍ਹਾਂ ਨੇ ਹੋਰ ਨਾਮ ਦੇ ਪਰਬਤ ਤੋਂ, ਲਾਲ ਸਮੁੰਦਰ ਵੱਲ ਅਦੋਮ ਦੇਸ ਦੇ ਬਾਹਰੋਂ, ਕੂਚ ਕੀਤਾ ਪਰ ਲੰਬੇ ਸਫ਼ਰ ਦੇ ਕਾਰਨ ਪਰਜਾ ਰਾਹ ਵਿੱਚ ਪਰੇਸ਼ਾਨ ਹੋ ਗਈ। ");
INSERT INTO pan_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","ਇਸ ਕਾਰਨ ਪਰਜਾ ਯਹੋਵਾਹ ਅਤੇ ਮੂਸਾ ਦੇ ਵਿਰੁੱਧ ਬੋਲੀ ਕਿ ਤੁਸੀਂ ਸਾਨੂੰ ਮਿਸਰ ਵਿੱਚੋਂ ਜੰਗਲ ਵਿੱਚ ਕਿਉਂ ਲੈ ਆਏ, ਤਾਂ ਜੋ ਅਸੀਂ ਉਜਾੜ ਵਿੱਚ ਮਰ ਜਾਈਏ? ਇੱਥੇ ਨਾ ਤਾਂ ਰੋਟੀ ਹੈ, ਨਾ ਹੀ ਪਾਣੀ ਹੈ। ਸਾਡੀਆਂ ਜਾਨਾਂ ਇਸ ਨਿਕੰਮੀ ਰੋਟੀ ਤੋਂ ਅੱਕ ਗਈਆਂ ਹਨ! ");
INSERT INTO pan_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","ਤਦ ਯਹੋਵਾਹ ਨੇ ਪਰਜਾ ਵਿੱਚ ਤੇਜ ਜ਼ਹਿਰੀਲੇ ਸੱਪ ਭੇਜੇ ਅਤੇ ਉਨ੍ਹਾਂ ਨੇ ਲੋਕਾਂ ਨੂੰ ਡੱਸਿਆ, ਤਦ ਇਸਰਾਏਲੀਆਂ ਵਿੱਚੋਂ ਬਹੁਤ ਲੋਕ ਮਰ ਗਏ। ");
INSERT INTO pan_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","ਫੇਰ ਪਰਜਾ ਨੇ ਮੂਸਾ ਕੋਲ ਆਣ ਕੇ ਆਖਿਆ, ਅਸੀਂ ਪਾਪ ਕੀਤਾ ਜੋ ਅਸੀਂ ਤੇਰੇ ਅਤੇ ਯਹੋਵਾਹ ਦੇ ਵਿਰੁੱਧ ਬੋਲੇ। ਹੁਣ, ਯਹੋਵਾਹ ਅੱਗੇ ਬੇਨਤੀ ਕਰ ਕਿ ਉਹ ਸਾਡੇ ਕੋਲੋਂ ਇਹਨਾਂ ਸੱਪਾਂ ਨੂੰ ਮੋੜ ਲਵੇ। ਤਦ ਮੂਸਾ ਨੇ ਪਰਜਾ ਦੇ ਲਈ ਬੇਨਤੀ ਕੀਤੀ। ");
INSERT INTO pan_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਆਖਿਆ, ਇੱਕ ਜ਼ਹਿਰੀਲਾ ਸੱਪ ਬਣਾ ਕੇ ਉਸ ਨੂੰ ਇੱਕ ਡੰਡੇ ਉੱਤੇ ਰੱਖਦੇ, ਤਦ ਅਜਿਹਾ ਹੋਵੇਗਾ ਕਿ ਜੋ ਕੋਈ ਡੱਸਿਆ ਜਾਵੇ, ਉਸ ਸੱਪ ਨੂੰ ਵੇਖ ਲਵੇ ਤਾਂ ਉਹ ਆਪਣੀ ਜਾਨ ਨੂੰ ਬਚਾ ਲਵੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","ਉਪਰੰਤ ਮੂਸਾ ਨੇ ਇੱਕ ਪਿੱਤਲ ਦਾ ਸੱਪ ਬਣਾ ਕੇ, ਉਸ ਨੂੰ ਡੰਡੇ ਉੱਤੇ ਰੱਖਿਆ ਤਾਂ ਅਜਿਹਾ ਹੋਇਆ ਕਿ ਜਦ ਸੱਪ ਕਿਸੇ ਮਨੁੱਖ ਨੂੰ ਡੱਸਦਾ ਸੀ, ਤਾਂ ਉਹ ਪਿੱਤਲ ਦੇ ਸੱਪ ਵੱਲ ਨਜ਼ਰ ਕਰਦਾ ਸੀ ਅਤੇ ਆਪਣੀ ਜਾਨ ਨੂੰ ਬਚਾ ਲੈਂਦਾ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","ਫੇਰ ਇਸਰਾਏਲ ਨੇ ਕੂਚ ਕਰਕੇ, ਓਬੋਥ ਵਿੱਚ ਡੇਰੇ ਲਾਏ। ");
INSERT INTO pan_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","ਫੇਰ ਓਬੋਥ ਤੋਂ ਕੂਚ ਕਰਕੇ, ਈਯੇਅਬਾਰੀਮ ਦੀ ਉਸ ਉਜਾੜ ਵਿੱਚ, ਜਿਹੜੀ ਮੋਆਬ ਦੇ ਸਾਹਮਣੇ ਪੂਰਬ ਦਿਸ਼ਾ ਵੱਲ ਹੈ, ਡੇਰੇ ਲਾਏ। ");
INSERT INTO pan_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","ਉੱਥੋਂ ਕੂਚ ਕਰਕੇ ਜ਼ਰਦ ਦੀ ਵਾਦੀ ਵਿੱਚ ਡੇਰੇ ਲਾਏ। ");
INSERT INTO pan_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","ਫੇਰ ਉੱਥੋਂ ਕੂਚ ਕਰ ਕੇ ਉਨ੍ਹਾਂ ਨੇ ਆਪਣੇ ਡੇਰੇ ਅਰਨੋਨ ਨਦੀ ਦੇ ਦੂਜੇ ਪਾਸੇ ਲਾਏ, ਜਿਹੜੀ ਉਜਾੜ ਵਿੱਚ ਦੀ ਅਮੋਰੀਆਂ ਦੀ ਸਰਹੱਦ ਤੋਂ ਨਿੱਕਲਦੀ ਹੈ ਕਿਉਂ ਜੋ ਅਰਨੋਨ ਮੋਆਬ ਦੀ ਹੱਦ ਉੱਤੇ ਮੋਆਬ ਅਤੇ ਅਮੋਰੀਆਂ ਦੇ ਵਿਚਕਾਰ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","ਇਸ ਲਈ ਯਹੋਵਾਹ ਦੀ ਜੰਗ ਨਾਮ ਦੀ ਪੁਸਤਕ ਵਿੱਚ ਲਿਖਿਆ ਹੈ: ਵਾਹੇਬ ਜਿਹੜਾ ਸੂਫ਼ਾਹ ਵਿੱਚ ਹੈ, ਅਤੇ ਅਰਨੋਨ ਦੀਆਂ ਵਾਦੀਆਂ। ");
INSERT INTO pan_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","ਅਤੇ ਵਾਦੀਆਂ ਦੀ ਢਾਲ਼, ਜਿਹੜੀ ਆਰ ਦੀ ਵੱਸੋਂ ਤੱਕ ਫੈਲੀ ਹੋਈ ਹੈ ਅਤੇ ਮੋਆਬ ਦੀ ਸਰਹੱਦ ਨਾਲ ਲੱਗਦੀ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","ਉੱਥੋਂ ਉਹ ਬਏਰ ਨੂੰ ਗਏ ਜਿੱਥੇ ਉਹ ਖੂਹ ਹੈ ਜਿਸ ਦੇ ਵਿਖੇ ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਆਖਿਆ ਸੀ ਕਿ ਪਰਜਾ ਨੂੰ ਇਕੱਠਾ ਕਰ ਅਤੇ ਮੈਂ ਉਨ੍ਹਾਂ ਨੂੰ ਪਾਣੀ ਦਿਆਂਗਾ। ");
INSERT INTO pan_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","ਤਦ ਇਸਰਾਏਲ ਨੇ ਇਹ ਗੀਤ ਗਾਇਆ: ਹੇ ਖੂਹ, ਉਮੜ੍ਹ ਆ! ਉਸ ਲਈ ਗਾਓ। ");
INSERT INTO pan_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","ਉਹ ਖੂਹ ਜਿਸ ਨੂੰ ਹਾਕਮਾਂ ਨੇ ਪੁੱਟਿਆ, ਅਤੇ ਲੋਕਾਂ ਦੇ ਪਤਵੰਤਾਂ ਨੇ ਆੱਸੇ ਨਾਲ ਅਤੇ ਆਪਣੀਆਂ ਲਾਠੀਆਂ ਨਾਲ ਕੱਢਿਆ! ");
INSERT INTO pan_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","ਉਹ ਫੇਰ ਉਜਾੜ ਤੋਂ ਮੱਤਾਨਾਹ ਨੂੰ ਗਏ ਅਤੇ ਮੱਤਾਨਾਹ ਤੋਂ ਨਹਲੀਏਲ ਨੂੰ ਅਤੇ ਨਹਲੀਏਲ ਤੋਂ ਬਾਮੋਥ ਨੂੰ। ");
INSERT INTO pan_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","ਅਤੇ ਬਾਮੋਥ ਤੋਂ ਉਸ ਘਾਟੀ ਨੂੰ ਜਿਹੜੀ ਮੋਆਬ ਦੇ ਮੈਦਾਨ ਵਿੱਚ ਹੈ, ਫੇਰ ਪਿਸਗਾਹ ਦੀ ਟੀਸੀ ਨੂੰ ਜਿਹੜੀ ਉਜਾੜ ਵੱਲ ਨੂੰ ਝੁਕੀ ਹੋਈ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","ਤਦ ਇਸਰਾਏਲ ਨੇ ਅਮੋਰੀਆਂ ਦੇ ਰਾਜੇ ਸੀਹੋਨ ਕੋਲ ਸੰਦੇਸ਼ਵਾਹਕ ਭੇਜੇ, ");
INSERT INTO pan_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","ਤੁਸੀਂ ਸਾਨੂੰ ਆਪਣੇ ਦੇਸ਼ ਦੇ ਵਿੱਚੋਂ ਦੀ ਲੰਘ ਜਾਣ ਦਿਓ। ਅਸੀਂ ਖੇਤ, ਅੰਗੂਰਾਂ ਦੇ ਬਾਗ਼ਾਂ ਵਿੱਚ ਨਹੀਂ ਵੜਾਂਗੇ, ਨਾ ਅਸੀਂ ਖੂਹ ਦਾ ਪਾਣੀ ਪੀਵਾਂਗੇ। ਅਸੀਂ ਸ਼ਾਹੀ ਸੜਕ ਰਾਹੀਂ ਚੱਲਾਂਗੇ ਜਦ ਤੱਕ ਤੁਹਾਡੀਆਂ ਹੱਦਾਂ ਤੋਂ ਪਾਰ ਨਾ ਲੰਘ ਜਾਈਏ। ");
INSERT INTO pan_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","ਪਰ ਸੀਹੋਨ ਨੇ ਇਸਰਾਏਲ ਨੂੰ ਆਪਣੀਆਂ ਹੱਦਾਂ ਦੇ ਵਿੱਚ ਦੀ ਨਾ ਲੰਘਣ ਦਿੱਤਾ, ਪਰ ਸੀਹੋਨ ਨੇ ਆਪਣੇ ਸਾਰੇ ਲੋਕ ਇਕੱਠੇ ਕੀਤੇ ਅਤੇ ਇਸਰਾਏਲ ਦਾ ਸਾਹਮਣਾ ਕਰਨ ਲਈ ਉਜਾੜ ਵਿੱਚ ਯਹਸ ਨੂੰ ਗਿਆ ਅਤੇ ਇਸਰਾਏਲ ਨਾਲ ਲੜਿਆ। ");
INSERT INTO pan_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","ਤਦ ਇਸਰਾਏਲ ਨੇ ਉਹ ਨੂੰ ਤਲਵਾਰ ਦੀ ਧਾਰ ਨਾਲ ਮਾਰਿਆ ਅਤੇ ਅਰਨੋਨ ਤੋਂ ਯਬੋਕ ਨਦੀ ਤੱਕ ਅਰਥਾਤ ਅੰਮੋਨੀਆਂ ਤੱਕ ਉਹ ਦੀ ਧਰਤੀ ਉੱਤੇ ਕਬਜ਼ਾ ਕਰ ਲਿਆ ਕਿਉਂ ਜੋ ਅੰਮੋਨੀਆਂ ਦੀ ਹੱਦ ਪੱਕੀ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","ਅਤੇ ਇਸਰਾਏਲ ਨੇ ਇਹ ਸਾਰੇ ਸ਼ਹਿਰ ਲੈ ਲਏ ਅਤੇ ਇਸਰਾਏਲ ਹਸ਼ਬੋਨ ਵਿੱਚ ਅਮੋਰੀਆਂ ਦੇ ਸਾਰੇ ਸ਼ਹਿਰਾਂ ਅਤੇ ਉਸ ਦੇ ਸਾਰੇ ਪਿੰਡਾਂ ਵਿੱਚ ਵੱਸ ਗਿਆ। ");
INSERT INTO pan_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","ਕਿਉਂ ਜੋ ਹਸ਼ਬੋਨ ਅਮੋਰੀਆਂ ਦੇ ਰਾਜੇ ਸੀਹੋਨ ਦਾ ਸ਼ਹਿਰ ਸੀ, ਜਿਸ ਨੇ ਮੋਆਬ ਦੇ ਅਗਲੇ ਰਾਜੇ ਨਾਲ ਲੜ ਕੇ ਉਸ ਦੇ ਸਾਰੇ ਦੇਸ ਨੂੰ ਉਸ ਦੇ ਹੱਥੋਂ ਅਰਨੋਨ ਤੱਕ ਜਿੱਤ ਲਿਆ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","ਇਸ ਲਈ ਕਵੀ ਆਖਦੇ ਹਨ: ਹਸ਼ਬੋਨ ਵਿੱਚ ਆਓ, ਸੀਹੋਨ ਦਾ ਸ਼ਹਿਰ ਬਣਾਇਆ ਅਤੇ ਪੱਕਾ ਕੀਤਾ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","ਕਿਉਂ ਜੋ ਅੱਗ ਹਸ਼ਬੋਨ ਤੋਂ ਨਿੱਕਲੀ, ਅਤੇ ਸੀਹੋਨ ਦੇ ਨਗਰ ਤੋਂ ਇੱਕ ਲਾਟ, ਮੋਆਬ ਦੇ ਆਰ ਨਗਰ ਨੂੰ ਭਸਮ ਕੀਤਾ, ਨਾਲੇ ਅਰਨੋਨ ਦੇ ਉਚਿਆਈਆਂ ਵਿੱਚ ਵੱਸਣ ਵਾਲੇ ਮਾਲਕਾਂ ਨੂੰ ਵੀ ਤਬਾਹ ਕੀਤਾ। ");
INSERT INTO pan_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","ਹੇ ਮੋਆਬ, ਤੇਰੇ ਉੱਤੇ ਹਾਏ! ਹੇ ਕਮੋਸ਼ ਦੇ ਪੁਜਾਰੀਓ, ਤੁਸੀਂ ਬਰਬਾਦ ਹੋਏ! ਉਸ ਨੇ ਆਪਣੇ ਪੁੱਤਰਾਂ ਨੂੰ ਭਗੌੜਿਆਂ ਵਾਂਗੂੰ ਛੱਡਿਆ, ਅਤੇ ਆਪਣੀਆਂ ਧੀਆਂ ਨੂੰ ਅਮੋਰੀਆਂ ਦੇ ਰਾਜਾ ਸੀਹੋਨ ਦੀ ਦਾਸੀਆਂ ਬਣਾ ਦਿੱਤਾ! ");
INSERT INTO pan_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","ਅਸੀਂ ਉਨ੍ਹਾਂ ਉੱਤੇ ਜਿੱਤ ਪ੍ਰਾਪਤ ਕੀਤੀ, ਹਸ਼ਬੋਨ, ਦੀਬੋਨ ਸ਼ਹਿਰ ਤੱਕ ਬਰਬਾਦ ਹੋਇਆ, ਅਤੇ ਅਸੀਂ ਨੋਫ਼ਾਹ ਅਤੇ ਮੇਦਬਾ ਸ਼ਹਿਰ ਤੱਕ ਤਬਾਹ ਕੀਤਾ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","ਇਸ ਤਰ੍ਹਾਂ ਇਸਰਾਏਲ ਅਮੋਰੀਆਂ ਦੇ ਖੇਤਰ ਵਿੱਚ ਵੱਸਿਆ। ");
INSERT INTO pan_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","ਫੇਰ ਮੂਸਾ ਨੇ ਯਾਜ਼ੇਰ ਦਾ ਭੇਤ ਜਾਣਨ ਲਈ ਮਨੁੱਖ ਘੱਲੇ ਅਤੇ ਉਨ੍ਹਾਂ ਨੇ ਉਸ ਦੇ ਪਿੰਡਾਂ ਨੂੰ ਵੱਸ ਵਿੱਚ ਕਰ ਲਿਆ ਅਤੇ ਉੱਥੋਂ ਦੇ ਅਮੋਰੀਆਂ ਨੂੰ ਕੱਢ ਦਿੱਤਾ। ");
INSERT INTO pan_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","ਫੇਰ ਮੁੜ ਕੇ ਉਹ ਬਾਸ਼ਾਨ ਦੇ ਰਾਹ ਤੋਂ ਉਤਾਹਾਂ ਨੂੰ ਗਏ ਅਤੇ ਓਗ ਬਾਸ਼ਾਨ ਦਾ ਰਾਜਾ ਅਤੇ ਉਸ ਦੀ ਸਾਰੀ ਪਰਜਾ ਉਹਨਾਂ ਦਾ ਸਾਹਮਣਾ ਕਰਨ ਲਈ ਬਾਹਰ ਆਈ ਅਤੇ ਅਦਰਈ ਵਿੱਚ ਉਨ੍ਹਾਂ ਦੇ ਨਾਲ ਯੁੱਧ ਕੀਤਾ। ");
INSERT INTO pan_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","ਪਰ ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਆਖਿਆ, ਉਸ ਤੋਂ ਨਾ ਡਰ ਕਿਉਂ ਜੋ ਮੈਂ ਉਸ ਨੂੰ ਅਤੇ ਉਸ ਦੀ ਸਾਰੀ ਸੈਨਾਂ ਨੂੰ ਅਤੇ ਉਸ ਦੇ ਦੇਸ ਨੂੰ ਤੇਰੇ ਵੱਸ ਵਿੱਚ ਕਰ ਦਿੱਤਾ ਹੈ। ਤੂੰ ਉਸ ਦੇ ਨਾਲ ਉਸੇ ਤਰ੍ਹਾਂ ਕਰੇਂਗਾ ਜਿਵੇਂ ਤੂੰ ਅਮੋਰੀਆਂ ਦੇ ਰਾਜੇ ਸੀਹੋਨ ਨਾਲ ਕੀਤਾ ਜੋ ਹਸ਼ਬੋਨ ਵਿੱਚ ਵੱਸਦਾ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","ਉਨ੍ਹਾਂ ਨੇ ਉਸ ਨੂੰ ਅਤੇ ਉਸ ਦੇ ਪੁੱਤਰਾਂ ਨੂੰ ਅਤੇ ਉਸ ਦੀ ਸਾਰੀ ਸੈਨਾਂ ਨੂੰ ਅਜਿਹਾ ਮਾਰਿਆ ਕਿ ਉਨ੍ਹਾਂ ਦਾ ਕੱਖ ਵੀ ਨਾ ਰਿਹਾ ਅਤੇ ਉਨ੍ਹਾਂ ਨੇ ਉਸ ਦੀ ਧਰਤੀ ਉੱਤੇ ਵੀ ਕਬਜ਼ਾ ਕਰ ਲਿਆ। ");
INSERT INTO pan_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","ਤਦ ਇਸਰਾਏਲੀਆਂ ਨੇ ਕੂਚ ਕਰ ਕੇ ਮੋਆਬ ਦੇ ਮੈਦਾਨ ਵਿੱਚ, ਯਰਦਨ ਦੇ ਪਾਰ ਯਰੀਹੋ ਦੇ ਕੋਲ ਡੇਰੇ ਲਾਏ। ");
INSERT INTO pan_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","ਸਿੱਪੋਰ ਦੇ ਪੁੱਤਰ ਬਾਲਾਕ ਨੇ ਸਭ ਕੁਝ ਵੇਖਿਆ ਜੋ ਇਸਰਾਏਲੀਆਂ ਨੇ ਅਮੋਰੀਆਂ ਨਾਲ ਕੀਤਾ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","ਇਸ ਲਈ ਮੋਆਬ ਉਸ ਪਰਜਾ ਤੋਂ ਬਹੁਤ ਡਰਿਆ ਕਿਉਂ ਜੋ ਉਹ ਗਿਣਤੀ ਵਿੱਚ ਵੱਧ ਸਨ, ਸੋ ਮੋਆਬ ਇਸਰਾਏਲੀਆਂ ਦੇ ਕਾਰਨ ਬਹੁਤ ਘਬਰਾਇਆ। ");
INSERT INTO pan_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","ਤਦ ਮੋਆਬ ਨੇ ਮਿਦਯਾਨ ਦੇ ਬਜ਼ੁਰਗਾਂ ਨੂੰ ਆਖਿਆ ਕੀ ਹੁਣ ਇਹ ਦਲ ਸਾਡੇ ਆਲੇ-ਦੁਆਲੇ ਦਾ ਸਭ ਕੁਝ ਖ਼ਤਮ ਕਰ ਜਾਵੇਗਾ ਜਿਵੇਂ ਬਲ਼ਦ ਖੇਤ ਦਾ ਘਾਹ ਖ਼ਤਮ ਕਰ ਦਿੰਦਾ ਹੈ। ਸਿੱਪੋਰ ਦਾ ਪੁੱਤਰ ਬਾਲਾਕ ਉਸ ਸਮੇਂ ਮੋਆਬ ਦਾ ਰਾਜਾ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","ਫੇਰ ਉਸ ਨੇ ਪਥੋਰ ਨਗਰ ਨੂੰ, ਜਿਹੜਾ ਵੱਡੇ ਦਰਿਆ ਉੱਤੇ ਹੈ ਆਪਣੀ ਉੱਮਤ ਦੇ ਅੰਸ ਦੇ ਦੇਸ ਵਿੱਚ ਬਓਰ ਦੇ ਪੁੱਤਰ ਬਿਲਆਮ ਕੋਲ, ਸੰਦੇਸ਼ਵਾਹਕ ਘੱਲੇ ਕਿ ਉਹ ਉਸ ਨੂੰ ਇਹ ਆਖ ਕੇ ਸੱਦੇ ਕਿ ਵੇਖੋ, ਇੱਕ ਦਲ ਮਿਸਰ ਤੋਂ ਨਿੱਕਲਿਆ ਹੈ ਅਤੇ ਵੇਖੋ, ਉਹਨਾਂ ਨੇ ਧਰਤੀ ਨੂੰ ਆਪਣੀ ਵੱਸੋਂ ਨਾਲ ਭਰ ਲਿਆ ਹੈ ਅਤੇ ਉਹ ਹੁਣ ਮੇਰੇ ਸਾਹਮਣੇ ਆ ਵੱਸੇ ਹਨ। ");
INSERT INTO pan_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","ਹੁਣ ਤੂੰ ਆ ਕੇ ਇਸ ਦਲ ਨੂੰ ਮੇਰੇ ਲਈ ਸਰਾਪ ਦੇਵੀਂ ਕਿਉਂ ਜੋ ਉਹ ਮੇਰੇ ਨਾਲੋਂ ਅੱਤ ਬਲਵੰਤ ਹਨ। ਸ਼ਾਇਦ ਮੈਂ ਫਤਹ ਪਾਵਾਂ ਅਤੇ ਅਸੀਂ ਉਨ੍ਹਾਂ ਨੂੰ ਅਜਿਹਾ ਮਾਰੀਏ ਕਿ ਉਨ੍ਹਾਂ ਨੂੰ ਆਪਣੇ ਦੇਸ ਤੋਂ ਕੱਢ ਦੇਈਏ ਕਿਉਂ ਜੋ ਮੈਂ ਜਾਣਦਾ ਹਾਂ ਕਿ ਜਿਸ ਨੂੰ ਤੂੰ ਬਰਕਤ ਦੇਵੇਂ ਉਹ ਮੁਬਾਰਕ ਹੈ, ਅਤੇ ਜਿਸ ਨੂੰ ਤੂੰ ਸਰਾਪ ਦੇਵੇਂ ਉਹ ਸਰਾਪੀ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","ਤਦ ਮੋਆਬ ਦੇ ਅਤੇ ਮਿਦਯਾਨ ਦੇ ਬਜ਼ੁਰਗ ਚੱਲ ਪਏ ਅਤੇ ਉਨ੍ਹਾਂ ਦੇ ਹੱਥਾਂ ਵਿੱਚ ਅਗੰਮ ਨੂੰ ਜਾਣਨ ਲਈ ਇਨਾਮ ਸਨ ਅਤੇ ਉਹ ਬਿਲਆਮ ਕੋਲ ਆ ਕੇ ਉਸ ਨੂੰ ਬਾਲਾਕ ਦੀਆਂ ਗੱਲਾਂ ਬਾਰੇ ਦੱਸਿਆ। ");
INSERT INTO pan_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","ਉਸ ਨੇ ਉਨ੍ਹਾਂ ਨੂੰ ਆਖਿਆ, ਤੁਸੀਂ ਅੱਜ ਦੀ ਰਾਤ ਇੱਥੇ ਠਹਿਰੋ ਅਤੇ ਜਿਵੇਂ ਯਹੋਵਾਹ ਮੈਨੂੰ ਬੋਲੇ ਮੈਂ ਤੁਹਾਡੇ ਕੋਲ ਮੁੜ ਖ਼ਬਰ ਲਿਆਵਾਂਗਾ। ਉਪਰੰਤ ਮੋਆਬ ਦੇ ਪ੍ਰਧਾਨ ਬਿਲਆਮ ਨਾਲ ਠਹਿਰੇ। ");
INSERT INTO pan_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","ਪਰਮੇਸ਼ੁਰ ਨੇ ਬਿਲਆਮ ਨੂੰ ਪੁੱਛਿਆ ਕਿ ਇਹ ਮਨੁੱਖ ਤੇਰੇ ਨਾਲ ਕੌਣ ਹਨ? ");
INSERT INTO pan_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","ਬਿਲਆਮ ਨੇ ਪਰਮੇਸ਼ੁਰ ਨੂੰ ਆਖਿਆ, ਸਿੱਪੋਰ ਦੇ ਪੁੱਤਰ ਬਾਲਾਕ ਮੋਆਬ ਦੇ ਰਾਜੇ ਨੇ ਉਨ੍ਹਾਂ ਨੂੰ ਮੇਰੇ ਕੋਲ ਇਹ ਆਖ ਕੇ ਭੇਜਿਆ। ");
INSERT INTO pan_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","ਕਿ ਵੇਖੋ, ਇਹ ਦਲ ਜਿਹੜਾ ਮਿਸਰ ਤੋਂ ਆਇਆ ਹੈ ਉਸ ਨੇ ਧਰਤੀ ਨੂੰ ਆਪਣੀ ਵੱਸੋਂ ਨਾਲ ਭਰ ਦਿੱਤਾ ਹੈ। ਹੁਣ ਆ ਮੇਰੇ ਲਈ ਉਨ੍ਹਾਂ ਨੂੰ ਸਰਾਪ ਦੇ, ਸ਼ਾਇਦ ਅਜਿਹਾ ਹੋਵੇ ਜੋ ਮੈਂ ਉਨ੍ਹਾਂ ਨਾਲ ਲੜ ਸਕਾਂ ਅਤੇ ਉਹਨਾਂ ਨੂੰ ਕੱਢ ਦਿਆਂ। ");
INSERT INTO pan_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","ਪਰ ਪਰਮੇਸ਼ੁਰ ਨੇ ਬਿਲਆਮ ਨੂੰ ਆਖਿਆ, ਇਹਨਾਂ ਨਾਲ ਨਾ ਜਾਵੀਂ, ਨਾ ਇਸ ਪਰਜਾ ਨੂੰ ਸਰਾਪ ਦੇਈਂ ਕਿਉਂ ਜੋ ਉਹ ਅਸੀਸ ਦੇ ਅਧਿਕਾਰੀ ਹਨ। ");
INSERT INTO pan_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","ਬਿਲਆਮ ਨੇ ਸਵੇਰ ਨੂੰ ਉੱਠ ਕੇ ਬਾਲਾਕ ਦੇ ਹਾਕਮਾਂ ਨੂੰ ਆਖਿਆ, ਆਪਣੇ ਦੇਸ ਨੂੰ ਜਾਓ ਕਿਉਂ ਜੋ ਯਹੋਵਾਹ ਨੇ ਮੈਨੂੰ ਤੁਹਾਡੇ ਨਾਲ ਜਾਣ ਤੋਂ ਮਨ੍ਹਾ ਕੀਤਾ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","ਤਦ ਮੋਆਬ ਦੇ ਪ੍ਰਧਾਨ ਉੱਠ ਕੇ ਬਾਲਾਕ ਕੋਲ ਆਏ ਅਤੇ ਉਨ੍ਹਾਂ ਨੇ ਆਖਿਆ, ਬਿਲਆਮ ਨੇ ਸਾਡੇ ਨਾਲ ਆਉਣ ਤੋਂ ਇਨਕਾਰ ਕੀਤਾ। ");
INSERT INTO pan_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","ਤਦ ਬਾਲਾਕ ਨੇ ਇੱਕ ਵਾਰ ਹੋਰ ਪ੍ਰਧਾਨ ਘੱਲੇ ਜਿਹੜੇ ਇਹਨਾਂ ਤੋਂ ਜਿਆਦਾ ਅਤੇ ਪਤਵੰਤੇ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","ਉਹ ਬਿਲਆਮ ਕੋਲ ਆਏ ਅਤੇ ਉਹ ਨੂੰ ਆਖਿਆ, ਸਿੱਪੋਰ ਦਾ ਪੁੱਤਰ ਬਾਲਾਕ ਇਹ ਆਖਦਾ ਹੈ ਕਿ ਮੇਰੇ ਕੋਲ ਆਉਣ ਤੋਂ ਨਾ ਰੁਕੋ। ");
INSERT INTO pan_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","ਕਿਉਂ ਜੋ ਮੈਂ ਤੁਹਾਡਾ ਵੱਡਾ ਸਤਿਕਾਰ ਕਰਾਂਗਾ ਅਤੇ ਜੋ ਕੁਝ ਤੁਸੀਂ ਮੈਨੂੰ ਆਖੋ, ਮੈਂ ਕਰਾਂਗਾ ਪਰ ਜ਼ਰੂਰ ਆਓ, ਮੇਰੇ ਲਈ ਇਸ ਦਲ ਨੂੰ ਸਰਾਪ ਦਿਓ। ");
INSERT INTO pan_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","ਅੱਗੋਂ ਬਿਲਆਮ ਨੇ ਬਾਲਾਕ ਦੇ ਸੇਵਕਾਂ ਨੂੰ ਉੱਤਰ ਦੇ ਕੇ ਆਖਿਆ, ਜੇਕਰ ਬਾਲਾਕ ਮੈਨੂੰ ਆਪਣਾ ਸੋਨੇ ਤੇ ਚਾਂਦੀ ਨਾਲ ਭਰਿਆ ਘਰ ਵੀ ਦੇ ਦੇਵੇ ਤਾਂ ਵੀ ਮੈਂ ਯਹੋਵਾਹ ਆਪਣੇ ਪਰਮੇਸ਼ੁਰ ਦੇ ਹੁਕਮ ਦੀ ਉਲੰਘਣਾ ਨਹੀਂ ਕਰ ਸਕਦਾ ਕਿ ਉਸ ਨੂੰ ਘੱਟ ਜਾਂ ਵੱਧ ਜਾਣ ਕੇ ਮੰਨਾ। ");
INSERT INTO pan_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","ਹੁਣ, ਤੁਸੀਂ ਅੱਜ ਦੀ ਰਾਤ ਇੱਥੇ ਹੀ ਠਹਿਰਨਾ, ਤਾਂ ਜੋ ਮੈਂ ਜਾਣ ਲਵਾਂ ਕਿ ਯਹੋਵਾਹ ਕਿਹੜੀ ਗੱਲ ਮੇਰੇ ਨਾਲ ਬੋਲੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","ਪਰਮੇਸ਼ੁਰ ਬਿਲਆਮ ਕੋਲ ਰਾਤ ਨੂੰ ਆਇਆ ਅਤੇ ਉਸ ਨੂੰ ਆਖਿਆ, ਜਿਹੜੇ ਮਨੁੱਖ ਤੈਨੂੰ ਬੁਲਾਉਣ ਆਏ ਹਨ, ਉੱਠ ਕੇ ਇਹਨਾਂ ਨਾਲ ਚਲਾ ਜਾ, ਪਰ ਸਿਰਫ਼ ਉਹ ਗੱਲ ਜਿਹੜੀ ਮੈਂ ਤੈਨੂੰ ਆਖਾਂ, ਤੂੰ ਉਸੇ ਤਰ੍ਹਾਂ ਹੀ ਕਰੀਂ। ");
INSERT INTO pan_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","ਤਦ ਬਿਲਆਮ ਨੇ ਸਵੇਰ ਨੂੰ ਉੱਠ ਕੇ, ਆਪਣੀ ਗਧੀ ਉੱਤੇ ਕਾਠੀ ਬੰਨ੍ਹੀ ਅਤੇ ਮੋਆਬ ਦੇ ਹਾਕਮਾਂ ਨਾਲ ਤੁਰ ਪਿਆ। ");
INSERT INTO pan_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","ਅਤੇ ਉਸ ਦੇ ਜਾਣ ਦੇ ਕਾਰਨ ਪਰਮੇਸ਼ੁਰ ਦਾ ਕ੍ਰੋਧ ਭੜਕ ਉੱਠਿਆ ਅਤੇ ਯਹੋਵਾਹ ਦਾ ਦੂਤ ਉਸ ਦਾ ਵਿਰੋਧ ਕਰਨ ਲਈ ਉਸ ਦੇ ਰਸਤੇ ਵਿੱਚ ਖੜ੍ਹਾ ਹੋਇਆ। ਉਹ ਆਪਣੀ ਗਧੀ ਉੱਤੇ ਸਵਾਰ ਹੋਇਆ ਅਤੇ ਉਸ ਦੇ ਦੋ ਨੌਕਰ ਉਸ ਦੇ ਨਾਲ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","ਅਤੇ ਗਧੀ ਨੇ ਯਹੋਵਾਹ ਦੇ ਦੂਤ ਨੂੰ ਰਸਤੇ ਵਿੱਚ ਹੱਥ ਵਿੱਚ ਤਲਵਾਰ ਫੜ੍ਹੀ, ਖੜ੍ਹਾ ਵੇਖਿਆ। ਤਾਂ ਗਧੀ ਰਾਹ ਤੋਂ ਮੁੜ ਕੇ ਖੇਤ ਵਿੱਚ ਨੂੰ ਹੋ ਗਈ ਅਤੇ ਬਿਲਆਮ ਨੇ ਗਧੀ ਨੂੰ ਮਾਰਿਆ ਕਿਉਂ ਜੋ ਉਹ ਨੂੰ ਰਾਹ ਤੋਂ ਮੁੜ ਗਈ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","ਤਦ ਯਹੋਵਾਹ ਦਾ ਦੂਤ ਅੰਗੂਰ ਦੇ ਬਾਗ਼ ਵਿੱਚ ਉਸ ਭੀੜੇ ਰਾਹ ਵਿੱਚ ਖੜ੍ਹਾ ਸੀ ਜਿੱਥੇ ਦੋਵੇਂ ਪਾਸੇ ਕੰਧ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","ਜਦੋਂ ਗਧੀ ਨੇ ਯਹੋਵਾਹ ਦੇ ਦੂਤ ਨੂੰ ਦੇਖਿਆ ਤਾਂ ਉਹ ਕੰਧ ਨਾਲ ਜਾ ਲੱਗੀ ਅਤੇ ਬਿਲਆਮ ਦੇ ਪੈਰ ਨੂੰ ਕੰਧ ਨਾਲ ਦਬਾਇਆ, ਉਸ ਨੇ ਫੇਰ ਉਹ ਨੂੰ ਮਾਰਿਆ। ");
INSERT INTO pan_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","ਯਹੋਵਾਹ ਦਾ ਦੂਤ ਫੇਰ ਇੱਕ ਵਾਰ ਅੱਗੇ ਜਾ ਕੇ ਇੱਕ ਭੀੜੀ ਥਾਂ ਵਿੱਚ ਖੜ੍ਹਾ ਹੋ ਗਿਆ ਜਿਸ ਤੋਂ ਸੱਜੇ ਖੱਬੇ ਮੁੜਨ ਨੂੰ ਕੋਈ ਰਾਹ ਨਹੀਂ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","ਜਦ ਗਧੀ ਨੇ ਯਹੋਵਾਹ ਦੇ ਦੂਤ ਨੂੰ ਵੇਖਿਆ ਤਾਂ ਬਿਲਆਮ ਦੇ ਹੇਠ ਬੈਠ ਗਈ ਅਤੇ ਬਿਲਆਮ ਦਾ ਕ੍ਰੋਧ ਭੜਕ ਉੱਠਿਆ, ਫਿਰ ਓਸ ਆਪਣੀ ਲਾਠੀ ਨਾਲ ਗਧੀ ਨੂੰ ਮਾਰਿਆ। ");
INSERT INTO pan_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","ਤਦ ਯਹੋਵਾਹ ਨੇ ਗਧੀ ਦੇ ਮੂੰਹ ਨੂੰ ਖੋਲ੍ਹਿਆ ਅਤੇ ਉਸ ਨੇ ਬਿਲਆਮ ਨੂੰ ਆਖਿਆ, ਮੈਂ ਤੇਰੇ ਨਾਲ ਕੀ ਕੀਤਾ ਕਿ ਤੂੰ ਮੈਨੂੰ ਤਿੰਨ ਵਾਰੀ ਮਾਰਿਆ? ");
INSERT INTO pan_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","ਤਾਂ ਬਿਲਆਮ ਨੇ ਗਧੀ ਨੂੰ ਆਖਿਆ, ਇਸ ਲਈ ਕਿ ਤੂੰ ਮੇਰੀ ਗੱਲ ਨੂੰ ਨਹੀਂ ਮੰਨਿਆ। ਜੇ ਮੇਰੇ ਹੱਥ ਵਿੱਚ ਤਲਵਾਰ ਹੁੰਦੀ ਤਾਂ ਤੈਨੂੰ ਹੁਣੇ ਹੀ ਵੱਢ ਸੁੱਟਦਾ। ");
INSERT INTO pan_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","ਅੱਗੋਂ ਗਧੀ ਨੇ ਬਿਲਆਮ ਨੂੰ ਆਖਿਆ, ਕੀ ਮੈਂ ਤੇਰੀ ਗਧੀ ਨਹੀਂ ਜਿਸ ਦੇ ਉੱਤੇ ਤੂੰ ਸਾਰੀ ਉਮਰ ਅੱਜ ਤੱਕ ਸਵਾਰੀ ਕੀਤੀ ਹੈ? ਕੀ ਕਦੀ ਪਹਿਲਾਂ ਵੀ ਮੈਂ ਤੇਰੇ ਨਾਲ ਅਜਿਹਾ ਕੀਤਾ ਹੈ? ਉਸ ਆਖਿਆ, ਨਹੀਂ। ");
INSERT INTO pan_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","ਤਦ ਯਹੋਵਾਹ ਨੇ ਬਿਲਆਮ ਦੀਆਂ ਅੱਖਾਂ ਨੂੰ ਖੋਲ੍ਹੀਆਂ ਅਤੇ ਉਸ ਨੇ ਯਹੋਵਾਹ ਦੇ ਦੂਤ ਨੂੰ ਰਾਹ ਵਿੱਚ ਖੜ੍ਹੇ ਵੇਖਿਆ ਅਤੇ ਉਹ ਦੀ ਤਲਵਾਰ, ਉਹ ਦੇ ਹੱਥ ਵਿੱਚ ਸੀ ਤਾਂ ਉਹ ਆਪਣਾ ਸਿਰ ਨਿਵਾ ਕੇ ਉਸ ਦੇ ਅੱਗੇ ਝੁਕਿਆ। ");
INSERT INTO pan_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","ਯਹੋਵਾਹ ਦੇ ਦੂਤ ਨੇ ਉਸ ਨੂੰ ਆਖਿਆ, ਤੂੰ ਕਿਉਂ ਆਪਣੀ ਗਧੀ ਨੂੰ ਤਿੰਨ ਵਾਰੀ ਮਾਰਿਆ ਹੈ? ਵੇਖ, ਮੈਂ ਅੱਜ ਤੈਨੂੰ ਰੋਕਣ ਕਈ ਆਇਆ ਹਾਂ ਕਿਉਂ ਜੋ ਤੇਰਾ ਰਾਹ ਮੇਰੇ ਅੱਗੇ ਸਹੀ ਨਹੀਂ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","ਗਧੀ ਨੇ ਮੈਨੂੰ ਵੇਖਿਆ ਅਤੇ ਮੇਰੇ ਵੱਲੋਂ ਤਿੰਨ ਵਾਰੀ ਮੁੜੀ। ਜੇ ਉਹ ਮੇਰੀ ਵੱਲੋਂ ਨਾ ਮੁੜਦੀ ਤਾਂ ਹੁਣ ਮੈਂ ਤੈਨੂੰ ਵੀ ਵੱਢ ਸੁੱਟਦਾ ਪਰ ਉਹ ਨੂੰ ਜੀਉਂਦੀ ਰਹਿਣ ਦਿੰਦਾ। ");
INSERT INTO pan_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","ਤਾਂ ਬਿਲਆਮ ਨੇ ਯਹੋਵਾਹ ਦੇ ਦੂਤ ਨੂੰ ਆਖਿਆ ਕਿ ਮੈਂ ਪਾਪ ਕੀਤਾ ਕਿਉਂ ਜੋ ਮੈਂ ਨਹੀਂ ਜਾਣਦਾ ਸੀ ਕਿ ਤੂੰ ਰਾਹ ਵਿੱਚ ਮੇਰੇ ਵਿਰੁੱਧ ਖੜ੍ਹਾ ਹੈਂ ਅਤੇ ਹੁਣ ਜੇ ਮੈਂ ਤੇਰੀ ਨਿਗਾਹ ਵਿੱਚ ਬੁਰਿਆਈ ਕੀਤੀ ਤਾਂ ਮੈਂ ਮੁੜ ਜਾਂਵਾਂਗਾ। ");
INSERT INTO pan_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","ਫੇਰ ਯਹੋਵਾਹ ਦੇ ਦੂਤ ਨੇ ਬਿਲਆਮ ਨੂੰ ਆਖਿਆ ਕਿ ਇਨ੍ਹਾਂ ਮਨੁੱਖਾਂ ਨਾਲ ਜਾ ਪਰ ਜਿਹੜੀ ਗੱਲ ਮੈਂ ਤੇਰੇ ਨਾਲ ਬੋਲਾਂ ਉਹ ਹੀ ਗੱਲ ਤੂੰ ਬੋਲੀ ਤਦ ਬਿਲਆਮ ਬਾਲਾਕ ਦੇ ਹਾਕਮਾਂ ਨਾਲ ਚਲਿਆ ਗਿਆ। ");
INSERT INTO pan_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","ਜਦ ਬਾਲਾਕ ਨੇ ਸੁਣਿਆ ਕਿ ਬਿਲਆਮ ਆ ਗਿਆ ਹੈ ਤਾਂ ਉਸ ਦੇ ਮਿਲਣ ਲਈ ਮੋਆਬ ਦੇ ਸ਼ਹਿਰ ਨੂੰ ਬਾਹਰ ਗਿਆ ਜਿਹੜਾ ਅਰਨੋਨ ਦੀਆਂ ਹੱਦਾਂ ਉੱਤੇ ਹੀ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","ਤਾਂ ਬਾਲਾਕ ਨੇ ਬਿਲਆਮ ਨੂੰ ਆਖਿਆ, ਕੀ ਮੈਂ ਤੈਨੂੰ ਵੱਡੀ ਜ਼ਰੂਰਤ ਵਿੱਚ ਨਹੀਂ ਬੁਲਾਇਆ? ਤੂੰ ਕਿਉਂ ਮੇਰੇ ਕੋਲ ਨਹੀਂ ਆਇਆ? ਕੀ ਮੈਂ ਤੈਨੂੰ ਇੱਕ ਵੱਡਾ ਇਨਾਮ ਨਹੀਂ ਸੀ ਦੇ ਸਕਦਾ? ");
INSERT INTO pan_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","ਪਰ ਬਿਲਆਮ ਨੇ ਬਾਲਾਕ ਨੂੰ ਆਖਿਆ, ਵੇਖ, ਮੈਂ ਤੇਰੇ ਕੋਲ ਆ ਗਿਆ ਹਾਂ। ਕੀ ਮੈਂ ਆਪਣੀ ਸ਼ਕਤੀ ਨਾਲ ਕੋਈ ਵਾਕ ਬੋਲ ਸਕਦਾ ਹਾਂ? ਜਿਹੜਾ ਵਾਕ ਪਰਮੇਸ਼ੁਰ ਮੇਰੇ ਮੂੰਹ ਵਿੱਚ ਪਾਵੇ ਉਹੀ ਮੈਂ ਬੋਲਾਂਗਾ। ");
INSERT INTO pan_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","ਫੇਰ ਬਿਲਆਮ ਬਾਲਾਕ ਨਾਲ ਚੱਲਿਆ ਗਿਆ ਅਤੇ ਉਹ ਕਿਰਯਤ-ਹਸੋਥ ਵਿੱਚ ਆਏ। ");
INSERT INTO pan_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","ਬਾਲਾਕ ਨੇ ਵੱਗਾਂ ਅਤੇ ਇੱਜੜਾਂ ਦੀਆਂ ਬਲੀਆਂ ਚੜ੍ਹਾਈਆਂ ਅਤੇ ਉਹ ਨੇ ਬਿਲਆਮ ਅਤੇ ਉਨ੍ਹਾਂ ਹਾਕਮਾਂ ਲਈ ਜਿਹੜੇ ਉਸ ਦੇ ਨਾਲ ਸਨ ਕੁਝ ਭੇਜਿਆ। ");
INSERT INTO pan_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","ਤਦ ਸਵੇਰ ਨੂੰ ਅਜਿਹਾ ਹੋਇਆ ਕਿ ਬਾਲਾਕ ਬਿਲਆਮ ਨੂੰ ਲੈ ਕੇ ਬਆਲ ਦੀਆਂ ਉਚਿਆਈਆਂ ਉੱਤੇ ਉਸ ਨੂੰ ਲਿਆਇਆ ਜਿੱਥੋਂ ਉਸ ਨੇ ਪਰਜਾ ਦੀਆਂ ਸਰਹੱਦਾਂ ਨੂੰ ਵੇਖਿਆ। ");
INSERT INTO pan_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","ਫੇਰ ਬਿਲਆਮ ਨੇ ਬਾਲਾਕ ਨੂੰ ਆਖਿਆ, ਇੱਥੇ ਮੇਰੇ ਲਈ ਸੱਤ ਜਗਵੇਦੀਆਂ ਬਣਾ ਅਤੇ ਬਲ਼ਦ ਤੇ ਸੱਤ ਭੇਡੂ ਤਿਆਰ ਕਰ। ");
INSERT INTO pan_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","ਤਦ ਜਿਵੇਂ ਬਿਲਆਮ ਬੋਲਿਆ ਸੀ ਉਸੇ ਤਰ੍ਹਾਂ ਹੀ ਬਾਲਾਕ ਨੇ ਕੀਤਾ ਅਤੇ ਬਾਲਾਕ ਅਤੇ ਬਿਲਆਮ ਨੇ ਹਰ ਜਗਵੇਦੀ ਉੱਤੇ ਇੱਕ-ਇੱਕ ਬਲ਼ਦ ਅਤੇ ਇੱਕ-ਇੱਕ ਭੇਡੂ ਚੜ੍ਹਾਇਆ। ");
INSERT INTO pan_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","ਤਦ ਬਿਲਆਮ ਨੇ ਬਾਲਾਕ ਨੂੰ ਆਖਿਆ, ਆਪਣੇ ਚੜ੍ਹਾਵੇ ਕੋਲ ਖੜ੍ਹਾ ਹੋ ਜਾ ਅਤੇ ਮੈਂ ਜਾਂਵਾਂਗਾ, ਸ਼ਾਇਦ ਯਹੋਵਾਹ ਮੈਨੂੰ ਮਿਲਣ ਆਵੇ। ਜਿਹੜੀ ਗੱਲ ਉਹ ਮੈਨੂੰ ਵਿਖਾਵੇਗਾ ਉਹ ਮੈਂ ਤੈਨੂੰ ਦੱਸਾਂਗਾ। ਤਦ ਉਹ ਇੱਕ ਪਰਬਤ ਉੱਤੇ ਗਿਆ। ");
INSERT INTO pan_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","ਅਤੇ ਪਰਮੇਸ਼ੁਰ ਬਿਲਆਮ ਨੂੰ ਮਿਲਿਆ ਅਤੇ ਉਹ ਨੇ ਉਸ ਨੂੰ ਆਖਿਆ, ਮੈਂ ਉਨ੍ਹਾਂ ਸੱਤਾਂ ਜਗਵੇਦੀਆਂ ਨੂੰ ਸੁਆਰ ਕੇ ਰੱਖਿਆ ਹੈ ਅਤੇ ਹਰ ਜਗਵੇਦੀ ਉੱਤੇ ਇੱਕ ਬਲ਼ਦ ਅਤੇ ਇੱਕ-ਇੱਕ ਭੇਡੂ ਚੜ੍ਹਾਇਆ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","ਤਦ ਯਹੋਵਾਹ ਨੇ ਇੱਕ ਵਾਕ ਬਿਲਆਮ ਦੇ ਮੂੰਹ ਵਿੱਚ ਪਾਇਆ ਅਤੇ ਆਖਿਆ, ਬਾਲਾਕ ਦੇ ਕੋਲ ਜਾਂ ਕੇ ਇਸ ਤਰ੍ਹਾਂ ਬੋਲੀ। ");
INSERT INTO pan_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","ਉਹ ਉਸ ਦੇ ਕੋਲ ਆਇਆ ਅਤੇ ਵੇਖੋ, ਉਹ ਆਪਣੀ ਹੋਮ ਬਲੀ ਲਈ ਖੜ੍ਹਾ ਸੀ ਅਤੇ ਉਹ ਦੇ ਨਾਲ ਮੋਆਬ ਦੇ ਸਾਰੇ ਪ੍ਰਧਾਨ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","ਉਸ ਨੇ ਆਪਣਾ ਅਗੰਮ ਵਾਕ ਆਖਿਆ, ਅਰਾਮ ਤੋਂ ਬਾਲਾਕ ਮੈਨੂੰ ਲਿਆਇਆ, ਮੋਆਬ ਦਾ ਰਾਜਾ ਪੂਰਬ ਦੇ ਪਰਬਤ ਤੋਂ, ਆ, ਮੇਰੇ ਲਈ ਯਾਕੂਬ ਨੂੰ ਸਰਾਪ ਦੇ, ਅਤੇ ਆ, ਇਸਰਾਏਲ ਨੂੰ ਘਟਾ! ");
INSERT INTO pan_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","ਮੈਂ ਕਿਵੇਂ ਉਹ ਨੂੰ ਫਿਟਕਾਰਾਂ, ਜਿਸ ਨੂੰ ਪਰਮੇਸ਼ੁਰ ਨੇ ਨਹੀਂ ਫਿਟਕਾਰਿਆ? ਅਤੇ ਮੈਂ ਕਿਵੇਂ ਉਹ ਨੂੰ ਘਟਾਵਾਂ, ਜਿਸ ਨੂੰ ਯਹੋਵਾਹ ਨੇ ਨਹੀਂ ਘਟਾਇਆ? ");
INSERT INTO pan_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","ਚੱਟਾਨ ਦੀਆਂ ਟੀਸੀਆਂ ਤੋਂ ਮੈਂ ਉਹ ਨੂੰ ਵੇਖਦਾ ਹਾਂ, ਅਤੇ ਪਰਬਤਾਂ ਤੋਂ ਮੈਂ ਉਸ ਉੱਤੇ ਨਿਗਾਹ ਮਾਰਦਾ ਹਾਂ। ਇਹ ਪਰਜਾ ਇਕੱਲੀ ਵੱਸਦੀ ਹੈ, ਅਤੇ ਕੌਮਾਂ ਦੇ ਵਿੱਚ ਉਹ ਆਪਣੇ ਆਪ ਨੂੰ ਨਹੀਂ ਗਿਣਦੀ। ");
INSERT INTO pan_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","ਯਾਕੂਬ ਦੀ ਧੂੜ ਦੇ ਕਿਣਕਿਆਂ ਨੂੰ ਕਿਸ ਨੇ ਗਿਣਿਆ? ਜਾਂ ਕਿਸ ਨੇ ਇਸਰਾਏਲ ਦੀ ਚੌਥਾਈ ਦੀ ਗਿਣਤੀ ਕੀਤੀ? ਮੈਂ ਧਰਮੀਆਂ ਦੀ ਮੌਤ ਦੀ ਤਰ੍ਹਾਂ ਮਰਾਂ, ਅਤੇ ਮੇਰਾ ਅੰਤ ਉਸ ਵਰਗਾ ਹੋਵੇ! ");
INSERT INTO pan_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","ਤਾਂ ਬਾਲਾਕ ਨੇ ਬਿਲਆਮ ਨੂੰ ਆਖਿਆ, ਤੂੰ ਮੇਰੇ ਨਾਲ ਕੀ ਕੀਤਾ? ਮੈਂ ਤੈਨੂੰ ਆਪਣੇ ਵੈਰੀਆਂ ਨੂੰ ਸਰਾਪ ਦੇਣ ਲਈ ਲਿਆਂਦਾ ਅਤੇ ਵੇਖ, ਤੂੰ ਉਨ੍ਹਾਂ ਨੂੰ ਬਰਕਤ ਹੀ ਬਰਕਤ ਦੇ ਦਿੱਤੀ! ");
INSERT INTO pan_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","ਉਸ ਨੇ ਉੱਤਰ ਦਿੱਤਾ, ਕੀ ਮੈਂ ਉਸ ਵਾਕ ਨੂੰ ਨਾ ਮੰਨਾ ਜਿਹੜਾ ਯਹੋਵਾਹ ਨੇ ਮੇਰੇ ਮੂੰਹ ਵਿੱਚ ਪਾਇਆ? ");
INSERT INTO pan_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","ਤਾਂ ਬਾਲਾਕ ਨੇ ਉਸ ਨੂੰ ਆਖਿਆ, ਤੂੰ ਮੇਰੇ ਨਾਲ ਦੂਜੇ ਥਾਂ ਨੂੰ ਚੱਲ ਜਿੱਥੋਂ ਤੂੰ ਉਨ੍ਹਾਂ ਨੂੰ ਵੇਖੇਂ। ਤੂੰ ਉਨ੍ਹਾਂ ਦਾ ਬਾਹਰਲਾ ਹਿੱਸਾ ਹੀ ਵੇਖੇਂ ਪਰ ਉਨ੍ਹਾਂ ਨੂੰ ਸਾਰਾ ਨਾ ਵੇਖੇਂ ਅਤੇ ਉੱਥੋਂ ਉਨ੍ਹਾਂ ਨੂੰ ਮੇਰੇ ਲਈ ਸਰਾਪ ਦੇ। ");
INSERT INTO pan_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","ਫੇਰ ਉਹ ਉਸ ਨੂੰ ਸੋਫ਼ੀਮ ਦੇ ਮੈਦਾਨ ਵਿੱਚ ਜਿਹੜੀ ਪਿਸਗਾਹ ਦੀ ਟੀਸੀ ਉੱਤੇ ਹੈ ਲੈ ਗਿਆ ਅਤੇ ਉਹ ਨੇ ਸੱਤ ਜਗਵੇਦੀਆਂ ਬਣਾ ਕੇ ਹਰ ਜਗਵੇਦੀ ਉੱਤੇ ਇੱਕ ਬਲ਼ਦ ਅਤੇ ਇੱਕ ਭੇਡੂ ਚੜ੍ਹਾਇਆ। ");
INSERT INTO pan_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","ਤਾਂ ਉਸ ਨੇ ਬਾਲਾਕ ਨੂੰ ਆਖਿਆ, ਆਪਣੇ ਚੜ੍ਹਾਵੇ ਕੋਲ ਇੱਥੇ ਖੜ੍ਹਾ ਹੋ ਜਾ ਜਦ ਤੱਕ ਮੈਂ ਯਹੋਵਾਹ ਨੂੰ ਉੱਥੇ ਨਾ ਮਿਲਾਂ। ");
INSERT INTO pan_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","ਤਾਂ ਯਹੋਵਾਹ ਬਿਲਆਮ ਨੂੰ ਮਿਲਿਆ ਅਤੇ ਉਸ ਦੇ ਮੂੰਹ ਵਿੱਚ ਇੱਕ ਵਾਕ ਪਾਇਆ ਅਤੇ ਆਖਿਆ, ਬਾਲਾਕ ਨੂੰ ਜਾ ਕੇ ਇਸ ਤਰ੍ਹਾਂ ਆਖੀਂ ");
INSERT INTO pan_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","ਤਾਂ ਉਹ ਉਸ ਦੇ ਕੋਲ ਗਿਆ ਅਤੇ ਵੇਖੋ ਉਹ ਆਪਣੇ ਚੜ੍ਹਾਵੇ ਕੋਲ ਮੋਆਬ ਦੇ ਹਾਕਮਾਂ ਨਾਲ ਖੜ੍ਹਾ ਸੀ, ਤਾਂ ਬਾਲਾਕ ਨੇ ਉਸ ਨੂੰ ਆਖਿਆ, ਯਹੋਵਾਹ ਦਾ ਵਾਕ ਕੀ ਹੈ? ਉਸ ਨੇ ਆਪਣਾ ਅਗੰਮ ਵਾਕ ਬੋਲਿਆ, ");
INSERT INTO pan_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","ਹੇ ਬਾਲਾਕ, ਉੱਠ ਅਤੇ ਸੁਣ, ਹੇ ਸਿੱਪੋਰ ਦੇ ਪੁੱਤਰ, ਮੇਰੀਆਂ ਗੱਲਾਂ ਉੱਤੇ ਧਿਆਨ ਦੇ। ");
INSERT INTO pan_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","ਪਰਮੇਸ਼ੁਰ ਇਨਸਾਨ ਨਹੀਂ ਕਿ ਝੂਠ ਬੋਲੇ, ਨਾ ਆਦਮੀ ਦੁਆਰਾ ਜੰਮਿਆ ਹੈ ਕਿ ਉਹ ਪਛਤਾਵੇ। ਕੀ ਉਸ ਨੇ ਕੁਝ ਆਖਿਆ ਹੋਵੇ ਅਤੇ ਨਾ ਕਰੇ? ਜਾਂ ਉਹ ਬੋਲਿਆ ਹੋਵੇ ਅਤੇ ਉਹ ਪੂਰਾ ਨਾ ਹੋਇਆ ਹੋਵੇ? ");
INSERT INTO pan_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","ਵੇਖੋ, ਮੈਨੂੰ ਬਰਕਤ ਦੇਣ ਦੀ ਆਗਿਆ ਹੋਈ ਹੈ, ਉਸ ਨੇ ਬਰਕਤ ਦਿੱਤੀ, ਇਸ ਨੂੰ ਮੈਂ ਮੋੜ ਨਹੀਂ ਸਕਦਾ। ");
INSERT INTO pan_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","ਉਸ ਨੇ ਯਾਕੂਬ ਵਿੱਚ ਬੁਰਿਆਈ ਨਹੀਂ ਦੇਖੀ, ਨਾ ਇਸਰਾਏਲ ਵਿੱਚ ਚਲਾਕੀ ਵੇਖੀ। ਯਹੋਵਾਹ ਉਹ ਦਾ ਪਰਮੇਸ਼ੁਰ ਉਹ ਦੇ ਨਾਲ ਹੈ, ਅਤੇ ਰਾਜੇ ਦੀ ਲਲਕਾਰ ਉਹ ਦੇ ਵਿੱਚ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","ਪਰਮੇਸ਼ੁਰ ਉਹ ਨੂੰ ਮਿਸਰ ਤੋਂ ਲਿਆ ਰਿਹਾ ਹੈ, ਉਹਨਾਂ ਵਿੱਚ ਸਾਨ੍ਹ ਜਿਨ੍ਹਾਂ ਜ਼ੋਰ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","ਯਾਕੂਬ ਉੱਤੇ ਜਾਦੂ ਨਹੀਂ ਚੱਲਦਾ, ਨਾ ਇਸਰਾਏਲ ਉੱਤੇ ਟੂਣਾ। ਹੁਣ ਯਾਕੂਬ ਅਤੇ ਇਸਰਾਏਲ ਵਿਖੇ ਆਖਿਆ ਜਾਵੇਗਾ, ਪਰਮੇਸ਼ੁਰ ਨੇ ਕੀ ਕੀਤਾ! ");
INSERT INTO pan_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","ਇਹ ਪਰਜਾ ਸ਼ੇਰਨੀ ਵਾਂਗੂੰ ਉੱਠੇਗੀ, ਅਤੇ ਸ਼ੇਰ ਵਾਂਗੂੰ ਆਪਣੇ ਆਪ ਨੂੰ ਖੜ੍ਹਾ ਕਰੇਗੀ, ਉਹ ਨਹੀਂ ਲੇਟੇਗੀ ਜਦ ਤੱਕ ਸ਼ਿਕਾਰ ਨਾ ਖਾ ਲਵੇ, ਅਤੇ ਸ਼ਿਕਾਰ ਦਾ ਲਹੂ ਨਾ ਪੀ ਲਵੇ। ");
INSERT INTO pan_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","ਤਾਂ ਬਾਲਾਕ ਨੇ ਬਿਲਆਮ ਨੂੰ ਆਖਿਆ, ਨਾ ਉਹ ਨੂੰ ਸਰਾਪ ਦੇ ਅਤੇ ਨਾ ਉਹ ਨੂੰ ਬਰਕਤ ਹੀ ਦੇ! ");
INSERT INTO pan_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","ਪਰ ਬਿਲਆਮ ਨੇ ਬਾਲਾਕ ਨੂੰ ਉੱਤਰ ਦਿੱਤਾ, ਕੀ ਮੈਂ ਤੈਨੂੰ ਨਹੀਂ ਦੱਸਿਆ ਕਿ ਜੋ ਕੁਝ ਯਹੋਵਾਹ ਮੈਨੂੰ ਆਖਦਾ ਹੈ ਮੈਨੂੰ ਉਹੀ ਕਰਨਾ ਪੈਂਦਾ ਹੈ? ");
INSERT INTO pan_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","ਤਾਂ ਬਾਲਾਕ ਨੇ ਬਿਲਆਮ ਨੂੰ ਆਖਿਆ, ਚੱਲ, ਮੈਂ ਤੈਨੂੰ ਇੱਕ ਹੋਰ ਥਾਂ ਲੈ ਜਾਂਵਾਂ। ਸ਼ਾਇਦ ਪਰਮੇਸ਼ੁਰ ਦੀ ਨਿਗਾਹ ਵਿੱਚ ਚੰਗਾ ਲੱਗੇ ਕਿ ਤੂੰ ਉੱਥੋਂ ਮੇਰੇ ਲਈ ਉਹਨਾਂ ਨੂੰ ਸਰਾਪ ਦੇਵੇਂ। ");
INSERT INTO pan_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","ਤਾਂ ਬਾਲਾਕ ਬਿਲਆਮ ਨੂੰ ਪੇਓਰ ਦੀ ਟੀਸੀ ਉੱਤੇ ਲੈ ਗਿਆ ਜਿਹੜੀ ਹੇਠਾਂ ਦੇ ਵੱਲ ਝੁੱਕੀ ਹੋਈ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","ਫੇਰ ਬਿਲਆਮ ਨੇ ਬਾਲਾਕ ਨੂੰ ਆਖਿਆ, ਇੱਥੇ ਮੇਰੇ ਲਈ ਸੱਤ ਜਗਵੇਦੀਆਂ ਬਣਾ ਅਤੇ ਮੇਰੇ ਲਈ ਇੱਥੇ ਸੱਤ ਬਲ਼ਦ ਅਤੇ ਸੱਤ ਭੇਡੂ ਤਿਆਰ ਕਰ। ");
INSERT INTO pan_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","ਤਾਂ ਬਾਲਾਕ ਨੇ ਉਸੇ ਤਰ੍ਹਾਂ ਹੀ ਕੀਤਾ ਜਿਵੇਂ ਬਿਲਆਮ ਨੇ ਆਖਿਆ ਅਤੇ ਹਰ ਜਗਵੇਦੀ ਉੱਤੇ ਇੱਕ ਬਲ਼ਦ ਅਤੇ ਇੱਕ ਭੇਡੂ ਚੜ੍ਹਾਇਆ। ");
INSERT INTO pan_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","ਜਦ ਬਿਲਆਮ ਨੇ ਵੇਖਿਆ ਕਿ ਯਹੋਵਾਹ ਦੀ ਨਿਗਾਹ ਵਿੱਚ ਇਸਰਾਏਲ ਨੂੰ ਬਰਕਤ ਦੇਣਾ ਚੰਗਾ ਹੈ ਤਾਂ ਜਿਵੇਂ ਉਹ ਪਹਿਲਾਂ ਕਦੀਂ ਕਦਾਈਂ ਜਾਦੂਗਰਾਂ ਨਾਲ ਮਿਲਣ ਲਈ ਜਾਂਦਾ ਸੀ, ਨਾ ਗਿਆ ਪਰ ਉਸ ਉਜਾੜ ਦੀ ਵੱਲ ਚਲਿਆ ਗਿਆ। ");
INSERT INTO pan_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","ਤਦ ਬਿਲਆਮ ਨੇ ਆਪਣੀਆਂ ਅੱਖਾਂ ਚੁੱਕ ਕੇ ਇਸਰਾਏਲ ਨੂੰ ਆਪਣੇ ਗੋਤਾਂ ਅਨੁਸਾਰ ਵੱਸੇ ਹੋਏ ਵੇਖਿਆ, ਤਾਂ ਪਰਮੇਸ਼ੁਰ ਦਾ ਆਤਮਾ ਉਸ ਉੱਤੇ ਆਇਆ। ");
INSERT INTO pan_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","ਤਦ ਉਸ ਆਪਣਾ ਅਗੰਮ ਵਾਕ ਆਖਿਆ, ਬਓਰ ਦੇ ਪੁੱਤਰ ਬਿਲਆਮ ਦਾ ਵਾਕ, ਉਸ ਪੁਰਸ਼ ਦਾ ਵਾਕ ਜਿਸ ਦੀਆਂ ਅੱਖਾਂ ਖੁੱਲ੍ਹੀਆਂ ਹਨ। ");
INSERT INTO pan_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","ਉਸ ਦਾ ਵਾਕ ਜਿਹੜਾ ਪਰਮੇਸ਼ੁਰ ਦੀਆਂ ਬਾਣੀਆਂ ਸੁਣਦਾ ਹੈ, ਜਿਹੜਾ ਸਰਬ ਸ਼ਕਤੀਮਾਨ ਦਾ ਦਰਸ਼ਣ ਪਾਉਂਦਾ ਹੈ, ਜਿਹੜਾ ਖੁੱਲ੍ਹੀਆਂ ਅੱਖਾਂ ਨਾਲ ਡਿੱਗ ਪੈਂਦਾ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","ਹੇ ਯਾਕੂਬ, ਤੇਰੇ ਤੰਬੂ ਕਿੰਨੇ ਚੰਗੇ ਹਨ! ਹੇ ਇਸਰਾਏਲ, ਤੇਰੇ ਵਾਸ ਵੀ! ");
INSERT INTO pan_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","ਘਾਟੀ ਦੇ ਵਾਂਗੂੰ ਉਹ ਫੈਲੇ ਹੋਏ ਹਨ, ਨਹਿਰ ਦੇ ਉੱਤੇ ਦੇ ਬਾਗ਼ਾਂ ਵਾਂਗੂੰ ਹਨ, ਯਹੋਵਾਹ ਦੇ ਲਾਏ ਹੋਏ ਅਗਰ ਦੇ ਰੁੱਖਾਂ ਵਾਂਗੂੰ, ਅਤੇ ਪਾਣੀ ਦੇ ਕੰਡੇ ਦੇ ਦਿਆਰ ਵਾਂਗੂੰ, ");
INSERT INTO pan_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","ਉਸ ਦਾ ਪਾਣੀ ਉਮੜ੍ਹ ਕੇ ਵਗੇਗਾ, ਅਤੇ ਉਸ ਦਾ ਬੀਜ ਬਹੁਤ ਪਾਣੀਆਂ ਵਿੱਚ ਹੋਵੇਗਾ, ਅਤੇ ਉਸ ਦਾ ਰਾਜਾ ਅਗਾਗ ਤੋਂ ਉੱਚਾ ਹੋਵੇਗਾ, ਉਸ ਦਾ ਰਾਜ ਵਧਦਾ ਜਾਵੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","ਪਰਮੇਸ਼ੁਰ ਉਸ ਨੂੰ ਮਿਸਰ ਤੋਂ ਲਿਆ ਰਿਹਾ ਹੈ, ਜਿਹਨਾਂ ਦਾ ਜ਼ੋਰ ਸਾਨ੍ਹ ਹੈ, ਉਹ ਆਪਣੀਆਂ ਵੈਰੀ ਕੌਮਾਂ ਨੂੰ ਖਾ ਜਾਵੇਗਾ, ਉਨ੍ਹਾਂ ਦੀਆਂ ਹੱਡੀਆਂ ਨੂੰ ਚੂਰ-ਚੂਰ ਕਰੇਗਾ, ਅਤੇ ਉਹਨਾਂ ਨੂੰ ਆਪਣਿਆਂ ਤੀਰਾਂ ਨਾਲ ਵਿੰਨ੍ਹ ਦੇਵੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","ਉਹ ਚੁੱਪ ਬੈਠਾ ਹੈ, ਉਹ ਸ਼ੇਰ ਵਾਂਗੂੰ ਲੇਟਿਆ, ਅਤੇ ਸ਼ੇਰਨੀ ਵਾਂਗੂੰ, ਕੌਣ ਉਹ ਨੂੰ ਛੇੜੇਗਾ? ਮੁਬਾਰਕ ਉਹ ਜਿਹੜਾ ਤੈਨੂੰ ਬਰਕਤ ਦੇਵੇ, ਅਤੇ ਸਰਾਪੀ ਉਹ ਜਿਹੜਾ ਤੈਨੂੰ ਸਰਾਪ ਦੇਵੇ! ");
INSERT INTO pan_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","ਤਾਂ ਬਾਲਾਕ ਦਾ ਕ੍ਰੋਧ ਬਿਲਆਮ ਦੇ ਵਿਰੁੱਧ ਭੜਕਿਆ ਅਤੇ ਹੱਥ ਉੱਤੇ ਹੱਥ ਮਾਰ ਕੇ ਬਾਲਾਕ ਨੇ ਬਿਲਆਮ ਨੂੰ ਆਖਿਆ, ਮੈਂ ਤੈਨੂੰ ਆਪਣੇ ਵੈਰੀਆਂ ਨੂੰ ਸਰਾਪ ਦੇਣ ਲਈ ਸੱਦਿਆ ਅਤੇ ਵੇਖ, ਤੂੰ ਤਿੰਨ ਵਾਰ ਉਨ੍ਹਾਂ ਨੂੰ ਬਰਕਤਾਂ ਹੀ ਬਰਕਤਾਂ ਦਿੱਤੀਆਂ। ");
INSERT INTO pan_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","ਹੁਣ ਆਪਣੇ ਘਰ ਚਲਿਆ ਜਾ! ਮੈਂ ਤਾਂ ਆਖਿਆ ਸੀ ਕਿ ਮੈਂ ਤੈਨੂੰ ਵੱਡਾ ਇਨਾਮ ਦਿਆਂਗਾ ਪਰ ਵੇਖ, ਯਹੋਵਾਹ ਨੇ ਤੈਨੂੰ ਇਨਾਮ ਲੈਣ ਤੋਂ ਮਨ੍ਹਾਂ ਕੀਤਾ। ");
INSERT INTO pan_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","ਅੱਗੋਂ ਬਿਲਆਮ ਨੇ ਬਾਲਾਕ ਨੂੰ ਆਖਿਆ, ਭਲਾ, ਮੈਂ ਤੇਰੇ ਸੰਦੇਸ਼ਵਾਹਕਾਂ ਨੂੰ ਜਿਹੜੇ ਤੂੰ ਮੇਰੇ ਕੋਲ ਭੇਜੇ ਸਨ ਨਹੀਂ ਆਖਿਆ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","ਕਿ ਜੇ ਬਾਲਾਕ ਮੈਨੂੰ ਆਪਣੇ ਘਰ ਭਰ ਦੀ ਚਾਂਦੀ ਅਤੇ ਸੋਨਾ ਦੇਵੇ, ਮੈਂ ਯਹੋਵਾਹ ਦੇ ਹੁਕਮ ਦਾ ਉਲੰਘਣ ਨਹੀਂ ਕਰ ਸਕਦਾ ਕਿ ਆਪਣੇ ਹੀ ਮਨ ਤੋਂ ਭਲਾ ਜਾਂ ਬੁਰਾ ਕਰਾਂ? ਜਿਹੜਾ ਵਾਕ ਯਹੋਵਾਹ ਕਹੇ ਮੈਂ ਉਹੀ ਕਹਾਂਗਾ। ");
INSERT INTO pan_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","ਹੁਣ ਵੇਖ, ਮੈਂ ਆਪਣੇ ਲੋਕਾਂ ਕੋਲ ਜਾਂਦਾ ਹਾਂ। ਆ, ਮੈਂ ਤੈਨੂੰ ਦੱਸਾਂਗਾ ਕਿ ਇਹ ਲੋਕ ਤੇਰੇ ਲੋਕਾਂ ਨਾਲ ਆਖਰੀ ਦਿਨਾਂ ਵਿੱਚ ਕੀ ਕਰਨਗੇ। ");
INSERT INTO pan_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","ਫੇਰ ਉਸ ਆਪਣਾ ਅਗੰਮ ਵਾਕ ਆਖਿਆ, ਬਓਰ ਦੇ ਪੁੱਤਰ ਬਿਲਆਮ ਦਾ ਵਾਕ, ਉਸ ਪੁਰਸ਼ ਦਾ ਵਾਕ ਜਿਸ ਦੀਆਂ ਅੱਖਾਂ ਖੁੱਲ੍ਹੀਆਂ ਹਨ, ");
INSERT INTO pan_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","ਉਸ ਦਾ ਵਾਕ ਜਿਹੜਾ ਪਰਮੇਸ਼ੁਰ ਦੀਆਂ ਬਾਣੀਆਂ ਸੁਣਦਾ ਹੈ, ਅਤੇ ਜਿਹੜਾ ਅੱਤ ਮਹਾਨ ਦਾ ਗਿਆਨ ਜਾਣਦਾ ਹੈ, ਜਿਹੜਾ ਸਰਬ ਸ਼ਕਤੀਮਾਨ ਦਾ ਦਰਸ਼ਣ ਪਾਉਂਦਾ ਹੈ, ਜਿਹੜਾ ਖੁੱਲ੍ਹੀਆਂ ਅੱਖਾਂ ਨਾਲ ਡਿੱਗ ਪੈਂਦਾ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","ਮੈਂ ਉਹ ਨੂੰ ਵੇਖਦਾ ਹਾਂ ਪਰ ਹੁਣ ਨਹੀਂ, ਮੈਂ ਉਹ ਨੂੰ ਤੱਕਦਾ ਹਾਂ ਪਰ ਨੇੜਿਓਂ ਨਹੀਂ। ਯਾਕੂਬ ਤੋਂ ਇੱਕ ਤਾਰਾ ਚੜ੍ਹੇਗਾ ਅਤੇ ਇਸਰਾਏਲ ਤੋਂ ਇੱਕ ਰਾਜ ਉੱਠੇਗਾ। ਉਹ ਮੋਆਬ ਦੀਆਂ ਸਰਹੱਦਾਂ ਨੂੰ ਚੂਰ-ਚੂਰ ਕਰੇਗਾ, ਅਤੇ ਸਾਰੇ ਦੰਗਾ ਕਰਨ ਵਾਲੇ ਸ਼ੇਥ ਦੇ ਪੁੱਤਰਾਂ ਨੂੰ ਮਾਰ ਸੁੱਟੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","ਅਦੋਮ ਉਹ ਦੀ ਸੰਪਤੀ ਹੋਵੇਗਾ, ਅਤੇ ਸੇਈਰ ਵੀ ਉਹ ਦੀ ਸੰਪਤੀ ਹੋਵੇਗਾ, ਜਿਹੜੇ ਉਹ ਦੇ ਵੈਰੀ ਹਨ, ਅਤੇ ਇਸਰਾਏਲ ਸੂਰਬੀਰਤਾ ਦਿਖਾਉਂਦਾ ਜਾਵੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","ਯਾਕੂਬ ਤੋਂ ਉਹ ਰਾਜ ਕਰੇਗਾ, ਅਤੇ ਸ਼ਹਿਰ ਦੇ ਸਾਰੇ ਬਚਿਆਂ ਹੋਇਆਂ ਨੂੰ ਵੀ ਨਾਸ ਕਰੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","ਫੇਰ ਉਸ ਨੇ ਅਮਾਲੇਕ ਨੂੰ ਦੇਖਿਆ ਅਤੇ ਆਪਣਾ ਅਗੰਮ ਵਾਕ ਆਖਿਆ, ਅਮਾਲੇਕ ਕੌਮਾਂ ਵਿੱਚ ਪਹਿਲੀ ਸੀ, ਪਰ ਉਸ ਦਾ ਅੰਤ ਤਾਂ ਨਸ਼ਟ ਹੀ ਹੋਣਾ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","ਫਿਰ ਉਸ ਨੇ ਕੇਨੀਆਂ ਨੂੰ ਡਿੱਠਾ ਅਤੇ ਆਪਣਾ ਅਗੰਮ ਵਾਕ ਆਖਿਆ, ਤੇਰਾ ਵਸੇਰਾ ਸਥਿਰ ਤਾਂ ਹੈ, ਅਤੇ ਤੇਰਾ ਆਲ੍ਹਣਾ ਚੱਟਾਨ ਵਿੱਚ ਤਾਂ ਹੈ, ");
INSERT INTO pan_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","ਤਾਂ ਵੀ ਕਾਇਨ ਉਜਾੜ ਦਿੱਤਾ ਜਾਵੇਗਾ, ਜਦ ਤੱਕ ਅੱਸ਼ੂਰ ਤੈਨੂੰ ਬੰਨ੍ਹ ਕੇ ਨਾ ਲੈ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","ਉਸ ਨੇ ਫੇਰ ਆਪਣਾ ਅਗੰਮ ਵਾਕ ਆਖਿਆ, ਹਾਏ! ਪਰਮੇਸ਼ੁਰ ਦੀ ਕਿਰਪਾ ਤੋਂ ਬਿਨ੍ਹਾਂ ਕੌਣ ਜੀਉਂਦਾ ਰਹੇਗਾ? ");
INSERT INTO pan_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","ਕਿੱਤੀਮ ਦੇ ਕੰਢਿਆਂ ਤੋਂ ਬੇੜੇ ਆਉਣਗੇ, ਅਤੇ ਅੱਸ਼ੂਰ ਅਤੇ ਏਬਰ ਨੂੰ ਦੁੱਖ ਦੇਣਗੇ, ਪਰ ਉਹ ਵੀ ਨਸ਼ਟ ਹੋ ਜਾਵੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","ਤਾਂ ਬਿਲਆਮ ਉੱਠ ਕੇ ਚਲਾ ਗਿਆ ਅਤੇ ਆਪਣੇ ਸਥਾਨ ਨੂੰ ਮੁੜ ਆਇਆ ਅਤੇ ਬਾਲਾਕ ਵੀ ਆਪਣੇ ਰਾਹ ਪੈ ਗਿਆ। ");
INSERT INTO pan_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","ਜਦ ਇਸਰਾਏਲ ਸ਼ਿੱਟੀਮ ਵਿੱਚ ਵੱਸਦੇ ਸਨ, ਤਦ ਲੋਕ ਮੋਆਬ ਦੀਆਂ ਕੁੜੀਆਂ ਨਾਲ ਵਿਭਚਾਰ ਕਰਨ ਲੱਗ ਪਏ। ");
INSERT INTO pan_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","ਜਦ ਉਨ੍ਹਾਂ ਨੇ ਲੋਕਾਂ ਨੂੰ ਆਪਣੇ ਦੇਵਤਿਆਂ ਦੀਆਂ ਬਲੀਆਂ ਉੱਤੇ ਬੁਲਾਇਆ ਤਾਂ ਲੋਕਾਂ ਨੇ ਖਾਧਾ ਅਤੇ ਉਨ੍ਹਾਂ ਦੇ ਦੇਵਤਿਆਂ ਨੂੰ ਮੱਥਾ ਵੀ ਟੇਕਿਆ। ");
INSERT INTO pan_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","ਸੋ ਇਸਰਾਏਲ ਬਆਲ ਪਓਰ ਦੇਵਤੇ ਨਾਲ ਰਲ ਗਿਆ ਤਾਂ ਯਹੋਵਾਹ ਦਾ ਕ੍ਰੋਧ ਇਸਰਾਏਲ ਉੱਤੇ ਭੜਕਿਆ। ");
INSERT INTO pan_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","ਫੇਰ ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਆਖਿਆ, ਲੋਕਾਂ ਦੇ ਸਾਰੇ ਮੁਖੀਆਂ ਨੂੰ ਲੈ ਕੇ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਧੁੱਪ ਵਿੱਚ ਟੰਗ ਦੇ ਤਾਂ ਜੋ ਯਹੋਵਾਹ ਦਾ ਕ੍ਰੋਧ ਇਸਰਾਏਲ ਤੋਂ ਟਲ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","ਤਾਂ ਮੂਸਾ ਨੇ ਇਸਰਾਏਲ ਦੇ ਨਿਆਂਈਆਂ ਨੂੰ ਆਖਿਆ, ਹਰ ਇੱਕ ਆਪਣੇ ਮਨੁੱਖਾਂ ਨੂੰ ਜਿਹੜੇ ਬਆਲ ਪਓਰ ਨਾਲ ਰਲ ਗਏ ਹਨ ਵੱਢ ਸੁੱਟੇ! ");
INSERT INTO pan_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","ਤਾਂ ਵੇਖੋ, ਮੂਸਾ ਅਤੇ ਸਾਰੀ ਇਸਰਾਏਲੀ ਮੰਡਲੀ ਦੇ ਵੇਖਦਿਆਂ ਜਦੋਂ ਉਹ ਮੰਡਲੀ ਦੇ ਤੰਬੂ ਦੇ ਦਰਵਾਜ਼ੇ ਕੋਲ ਰੋ ਰਹੇ ਸਨ ਇੱਕ ਇਸਰਾਏਲੀ ਮਨੁੱਖ ਇੱਕ ਮਿਦਯਾਨੀ ਇਸਤਰੀ ਨੂੰ ਲੈ ਆਇਆ। ");
INSERT INTO pan_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","ਜਦ ਹਾਰੂਨ ਜਾਜਕ ਦੇ ਪੋਤੇ ਅਲਆਜ਼ਾਰ ਦੇ ਪੁੱਤਰ ਫ਼ੀਨਹਾਸ ਨੇ ਵੇਖਿਆ ਤਾਂ ਮੰਡਲੀ ਦੇ ਤੰਬੂ ਵਿੱਚੋਂ ਉੱਠ ਕੇ ਆਪਣੇ ਹੱਥ ਵਿੱਚ ਇੱਕ ਨੇਜ਼ਾ ਲਿਆ। ");
INSERT INTO pan_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","ਅਤੇ ਉਸ ਇਸਰਾਏਲੀ ਮਨੁੱਖ ਦੇ ਪਿੱਛੇ ਚਾਨਣੀ ਵਿੱਚ ਜਾ ਕੇ ਦੋਹਾਂ ਨੂੰ ਅਰਥਾਤ ਇਸਰਾਏਲੀ ਮਨੁੱਖ ਅਤੇ ਉਸ ਇਸਤਰੀ ਦੇ ਢਿੱਡ ਨੂੰ ਵਿੰਨ੍ਹ ਦਿੱਤਾ ਤਾਂ ਇਸਰਾਏਲੀਆਂ ਤੋਂ ਬਵਾ ਰੁਕ ਗਈ। ");
INSERT INTO pan_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","ਉਸ ਬਵਾ ਨਾਲ ਚੌਵੀ ਹਜ਼ਾਰ ਮਰ ਗਏ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","ਫੇਰ ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਆਖਿਆ, ");
INSERT INTO pan_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","ਹਾਰੂਨ ਜਾਜਕ ਦੇ ਪੋਤੇ ਅਲਆਜ਼ਾਰ ਦੇ ਪੁੱਤਰ ਫ਼ੀਨਹਾਸ ਨੇ ਮੇਰੇ ਕ੍ਰੋਧ ਨੂੰ ਇਸਰਾਏਲੀਆਂ ਤੋਂ ਟਾਲ ਦਿੱਤਾ ਹੈ। ਜਦ ਉਹ ਉਨ੍ਹਾਂ ਵਿੱਚ ਮੇਰੀ ਅਣਖ ਕਾਰਨ ਅਣਖੀ ਹੋਇਆ ਤਾਂ ਹੀ ਮੈਂ ਇਸਰਾਏਲੀਆਂ ਦਾ ਆਪਣੀ ਅਣਖ ਦੇ ਕਾਰਨ ਨਾਸ ਨਹੀਂ ਕੀਤਾ। ");
INSERT INTO pan_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","ਇਸ ਲਈ ਆਖ, ਕਿ ਵੇਖ, ਮੈਂ ਉਸ ਨੂੰ ਆਪਣੀ ਸ਼ਾਂਤੀ ਦਾ ਨੇਮ ਦਿੰਦਾ ਹਾਂ। ");
INSERT INTO pan_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","ਅਤੇ ਉਹ ਉਸ ਲਈ ਅਤੇ ਉਸ ਦੇ ਬਾਅਦ ਵਾਲੀ ਅੰਸ ਲਈ ਸਦਾ ਦੀ ਜਾਜਕਾਈ ਦਾ ਨੇਮ ਹੋਵੇਗਾ ਕਿਉਂ ਜੋ ਉਹ ਆਪਣੇ ਪਰਮੇਸ਼ੁਰ ਲਈ ਅਣਖੀ ਹੋਇਆ ਅਤੇ ਇਸਰਾਏਲੀਆਂ ਲਈ ਪ੍ਰਾਸਚਿਤ ਕੀਤਾ। ");
INSERT INTO pan_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","ਉਸ ਇਸਰਾਏਲੀ ਮਨੁੱਖ ਦਾ ਨਾਮ ਜ਼ਿਮਰੀ ਸੀ ਜੋ ਮਿਦਯਾਨੀ ਇਸਤਰੀ ਨਾਲ ਮਾਰਿਆ ਗਿਆ। ਉਹ ਸ਼ਿਮਓਨੀਆਂ ਵਿੱਚੋਂ ਆਪਣੇ ਪਿਤਾ ਦੇ ਪਰਿਵਾਰ ਦਾ ਪ੍ਰਧਾਨ ਸਾਲੂ ਦਾ ਪੁੱਤਰ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","ਅਤੇ ਉਸ ਮਿਦਯਾਨੀ ਇਸਤਰੀ ਦਾ ਨਾਮ ਜਿਹੜੀ ਮਾਰੀ ਗਈ ਸੂਰ ਦੀ ਧੀ ਕਾਜ਼ਬੀ ਸੀ, ਅਤੇ ਉਹ ਆਪਣੇ ਪਿਤਾ ਦੇ ਪਰਿਵਾਰ ਵਿੱਚ ਮਿਦਯਾਨ ਦੇ ਲੋਕਾਂ ਦਾ ਮੁਖੀਆ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","ਉਪਰੰਤ ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਆਖਿਆ, ");
INSERT INTO pan_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","ਮਿਦਯਾਨੀਆਂ ਨੂੰ ਸਤਾਓ ਅਤੇ ਉਨ੍ਹਾਂ ਨੂੰ ਜਾਨੋਂ ਮਾਰੋ। ");
INSERT INTO pan_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","ਕਿਉਂ ਜੋ ਉਹ ਤੁਹਾਨੂੰ ਆਪਣੇ ਛਲਾਂ ਨਾਲ ਸਤਾਉਂਦੇ ਹਨ, ਜਿਵੇਂ ਪਓਰ ਦੀ ਗੱਲ ਵਿੱਚ ਅਤੇ ਉਨ੍ਹਾਂ ਦੀ ਭੈਣ ਮਿਦਯਾਨ ਪ੍ਰਧਾਨ ਦੀ ਧੀ ਕਾਜ਼ਬੀ ਦੀ ਗੱਲ ਵਿੱਚ ਜਿਹੜੀ ਬਵਾ ਦੇ ਦਿਨ ਪਓਰ ਦੀ ਗੱਲ ਦੇ ਕਾਰਨ ਮਾਰੀ ਗਈ। ");
INSERT INTO pan_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","ਬਵਾ ਦੇ ਮਗਰੋਂ ਅਜਿਹਾ ਹੋਇਆ ਕਿ ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਅਤੇ ਹਾਰੂਨ ਜਾਜਕ ਦੇ ਪੁੱਤਰ ਅਲਆਜ਼ਾਰ ਨੂੰ ਆਖਿਆ, ");
INSERT INTO pan_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","ਇਸਰਾਏਲੀਆਂ ਦੀ ਸਾਰੀ ਮੰਡਲੀ ਦੀ ਗਿਣਤੀ ਕਰੋ, ਵੀਹ ਸਾਲ ਅਤੇ ਉੱਪਰ ਦੇ ਪੁਰਖਿਆਂ ਦੇ ਘਰਾਣਿਆਂ ਅਨੁਸਾਰ ਸਾਰੇ ਜਿਹੜੇ ਇਸਰਾਏਲ ਵਿੱਚ ਯੁੱਧ ਕਰਨ ਯੋਗ ਹਨ। ");
INSERT INTO pan_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","ਤਦ ਮੂਸਾ ਅਤੇ ਅਲਆਜ਼ਾਰ ਜਾਜਕ ਮੋਆਬ ਦੇ ਮੈਦਾਨ ਵਿੱਚ ਯਰਦਨ ਉੱਤੇ ਯਰੀਹੋ ਕੋਲ, ਉਨ੍ਹਾਂ ਨੂੰ ਬੋਲੇ, ");
INSERT INTO pan_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","ਵੀਹ ਸਾਲ ਅਤੇ ਉੱਪਰ ਦੇ ਮਨੁੱਖਾਂ ਦੀ ਗਿਣਤੀ ਕਰੋ ਜਿਵੇਂ ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਅਤੇ ਇਸਰਾਏਲੀਆਂ ਨੂੰ ਹੁਕਮ ਦਿੱਤਾ ਸੀ ਜਦ ਉਹ ਮਿਸਰ ਦੇਸ ਤੋਂ ਨਿੱਕਲ ਰਹੇ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","ਰਊਬੇਨ ਇਸਰਾਏਲ ਦਾ ਪਹਿਲੌਠਾ। ਰਊਬੇਨ ਦੇ ਪੁੱਤਰ, ਹਨੋਕ ਤੋਂ ਹਨੋਕੀਆਂ ਦਾ ਪਰਿਵਾਰ, ਪੱਲੂ ਤੋਂ ਪੱਲੂਆਂ ਦਾ ਪਰਿਵਾਰ, ਹਸਰੋਨ ਤੋਂ ਹਸਰੋਨੀਆਂ ਦਾ ਪਰਿਵਾਰ, ");
INSERT INTO pan_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","ਕਰਮੀ ਤੋਂ ਕਰਮੀਆਂ ਦਾ ਪਰਿਵਾਰ ");
INSERT INTO pan_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","ਇਹ ਰਊਬੇਨੀਆਂ ਦੇ ਪਰਿਵਾਰ ਹਨ ਅਤੇ ਜਿਹੜੇ ਉਨ੍ਹਾਂ ਵਿੱਚੋਂ ਗਿਣੇ ਗਏ ਉਹ ਤਿਰਤਾਲੀ ਹਜ਼ਾਰ ਸੱਤ ਸੌ ਤੀਹ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","ਅਤੇ ਪੱਲੂ ਦਾ ਪੁੱਤਰ ਅਲੀਆਬ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","ਅਤੇ ਅਲੀਆਬ ਦੇ ਪੁੱਤਰ ਨਮੂਏਲ, ਦਾਥਾਨ ਅਤੇ ਅਬੀਰਾਮ ਸਨ। ਇਹ ਉਹ ਦਾਥਾਨ ਅਤੇ ਅਬੀਰਾਮ ਸਨ ਜਿਹੜੇ ਮੰਡਲੀ ਦੀ ਚੋਣ ਦੇ ਸਨ ਅਤੇ ਮੂਸਾ ਦੇ ਵਿਰੁੱਧ ਅਤੇ ਹਾਰੂਨ ਦੇ ਵਿਰੁੱਧ ਕੋਰਹ ਦੀ ਟੋਲੀ ਨਾਲ ਝਗੜਾ ਕਰ ਰਹੇ ਸਨ ਜਦ ਉਹ ਯਹੋਵਾਹ ਦੇ ਵਿਰੁੱਧ ਝਗੜਦੇ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","ਉਸ ਵੇਲੇ ਧਰਤੀ ਨੇ ਆਪਣਾ ਮੂੰਹ ਖੋਲ੍ਹ ਕੇ ਉਨ੍ਹਾਂ ਨੂੰ ਕੋਰਹ ਨਾਲ ਨਿਗਲ ਲਿਆ ਜਦ ਉਹ ਟੋਲੀ ਮਰ ਗਈ ਅਤੇ ਜਦ ਅੱਗ ਨੇ ਢਾਈ ਸੌ ਮਨੁੱਖਾਂ ਨੂੰ ਭਸਮ ਕੀਤਾ, ਤਾਂ ਉਹ ਇੱਕ ਨਿਸ਼ਾਨ ਹੋ ਗਏ। ");
INSERT INTO pan_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","ਪਰ ਕੋਰਹ ਦੇ ਪੁੱਤਰ ਨਹੀਂ ਮਰੇ। ");
INSERT INTO pan_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","ਸ਼ਿਮਓਨ ਦੇ ਪੁੱਤਰ ਆਪਣਿਆਂ ਟੱਬਰਾਂ ਅਨੁਸਾਰ, ਨਮੂਏਲ ਤੋਂ ਨਮੂਏਲੀਆਂ ਦਾ ਪਰਿਵਾਰ, ਯਾਮੀਨ ਤੋਂ ਯਮੀਨੀਆਂ ਦਾ ਪਰਿਵਾਰ, ਯਾਕੀਨ ਤੋਂ ਯਾਕੀਨੀਆਂ ਦਾ ਟੱਬਰ, ");
INSERT INTO pan_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","ਜ਼ਰਹ ਤੋਂ ਜ਼ਰਹੀਆਂ ਦਾ ਟੱਬਰ, ਸ਼ਾਊਲ ਤੋਂ ਸ਼ਾਊਲੀਆਂ ਦਾ ਟੱਬਰ ");
INSERT INTO pan_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","ਇਹ ਸ਼ਿਮਓਨੀਆਂ ਦੇ ਟੱਬਰ ਹਨ ਅਤੇ ਉਹ ਬਾਈ ਹਜ਼ਾਰ ਦੋ ਸੌ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","ਗਾਦ ਦੇ ਪੁੱਤਰ ਆਪਣਿਆਂ ਟੱਬਰਾਂ ਅਨੁਸਾਰ, ਸਫ਼ੋਨ ਤੋਂ ਸਫ਼ੋਨੀਆਂ ਦਾ ਟੱਬਰ, ਹੱਗੀ ਤੋਂ ਹੱਗੀਆਂ ਦਾ ਟੱਬਰ, ਸੂਨੀ ਤੋਂ ਸੂਨੀਆਂ ਦਾ ਟੱਬਰ, ");
INSERT INTO pan_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","ਆਜ਼ਨੀ ਤੋਂ ਆਜ਼ਨੀਆਂ ਦਾ ਟੱਬਰ, ਏਰੀ ਤੋਂ ਏਰੀਆਂ ਦਾ ਟੱਬਰ, ");
INSERT INTO pan_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","ਅਰੋਦ ਤੋਂ ਅਰੋਦੀਆਂ ਦਾ ਟੱਬਰ, ਅਰਏਲੀ ਤੋਂ ਅਰਏਲੀਆਂ ਦਾ ਟੱਬਰ, ");
INSERT INTO pan_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","ਇਹ ਗਾਦੀਆਂ ਦੇ ਟੱਬਰ ਉਨ੍ਹਾਂ ਦੇ ਗਿਣੇ ਹੋਇਆਂ ਦੇ ਅਨੁਸਾਰ ਹਨ ਅਤੇ ਇਹ ਚਾਲ੍ਹੀ ਹਜ਼ਾਰ ਪੰਜ ਸੌ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","ਯਹੂਦਾਹ ਦੇ ਪੁੱਤਰ ਏਰ ਅਤੇ ਓਨਾਨ ਸਨ ਅਤੇ ਏਰ ਅਤੇ ਓਨਾਨ ਕਨਾਨ ਦੇਸ ਵਿੱਚ ਮਰ ਗਏ। ");
INSERT INTO pan_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","ਯਹੂਦਾਹ ਦੇ ਪੁੱਤਰ ਆਪਣਿਆਂ ਟੱਬਰਾਂ ਅਨੁਸਾਰ ਇਹ ਸਨ, ਸ਼ੇਲਾਹ ਤੋਂ ਸ਼ੇਲਾਹੀਆਂ ਦਾ ਟੱਬਰ, ਪਰਸ ਤੋਂ ਪਰਸੀਆਂ ਦਾ ਟੱਬਰ, ਜ਼ਰਹ ਤੋਂ ਜ਼ਰਹੀਆਂ ਦਾ ਟੱਬਰ, ");
INSERT INTO pan_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","ਪਰਸ ਦੇ ਪੁੱਤਰ ਇਹ ਸਨ, ਹਸਰੋਨ ਤੋਂ ਹਸਰੋਨੀਆਂ ਦਾ ਟੱਬਰ, ਹਾਮੂਲ ਤੋਂ ਹਮੂਲੀਆਂ ਦਾ ਟੱਬਰ, ");
INSERT INTO pan_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","ਇਹ ਯਹੂਦਾਹ ਦੇ ਟੱਬਰ ਉਨ੍ਹਾਂ ਦੇ ਗਿਣੇ ਹੋਇਆਂ ਦੇ ਅਨੁਸਾਰ ਹਨ ਅਤੇ ਉਹ ਛਿਹੱਤਰ ਹਜ਼ਾਰ ਪੰਜ ਸੌ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","ਯਿੱਸਾਕਾਰ ਦੇ ਪੁੱਤਰ ਆਪਣਿਆਂ ਟੱਬਰਾਂ ਅਨੁਸਾਰ, ਤੋਲਾ ਤੋਂ ਤੋਲੀਆਂ ਦਾ ਟੱਬਰ, ਪੁੱਵਾਹ ਤੋਂ ਪੂਨੀਆਂ ਦਾ ਟੱਬਰ ");
INSERT INTO pan_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","ਯਾਸ਼ੂਬ ਤੋਂ ਯਾਸ਼ੂਬੀਆਂ ਦਾ ਟੱਬਰ, ਸ਼ਿਮਰੋਨ ਤੋਂ ਸ਼ਿਮਰੋਨੀਆਂ ਦਾ ਟੱਬਰ ");
INSERT INTO pan_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","ਇਹ ਯਿੱਸਾਕਾਰ ਦੇ ਟੱਬਰ ਉਨ੍ਹਾਂ ਦੇ ਗਿਣੇ ਹੋਇਆਂ ਅਨੁਸਾਰ ਅਤੇ ਉਹ ਚੌਂਹਠ ਹਜ਼ਾਰ ਤਿੰਨ ਸੌ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","ਜ਼ਬੂਲੁਨ ਦੇ ਪੁੱਤਰ ਆਪਣਿਆਂ ਟੱਬਰਾਂ ਅਨੁਸਾਰ, ਸਰਦ ਤੋਂ ਸਰਦੀਆਂ ਦਾ ਟੱਬਰ, ਏਲੋਨ ਤੋਂ ਏਲੋਨੀਆਂ ਦਾ ਟੱਬਰ, ਯਹਲਏਲ ਤੋਂ ਯਹਲਏਲੀਆਂ ਦਾ ਟੱਬਰ ");
INSERT INTO pan_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","ਇਹ ਜ਼ਬੂਲੁਨੀਆਂ ਦੇ ਟੱਬਰ ਉਨ੍ਹਾਂ ਦੇ ਗਿਣੇ ਹੋਇਆਂ ਅਨੁਸਾਰ ਹਨ ਅਤੇ ਉਹ ਸੱਠ ਹਜ਼ਾਰ ਪੰਜ ਸੌ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","ਯੂਸੁਫ਼ ਦੇ ਪੁੱਤਰ ਆਪਣਿਆਂ ਟੱਬਰਾਂ ਅਨੁਸਾਰ, ਮਨੱਸ਼ਹ ਅਤੇ ਇਫ਼ਰਾਈਮ ");
INSERT INTO pan_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","ਮਨੱਸ਼ਹ ਦੇ ਪੁੱਤਰ, ਮਾਕੀਰ ਤੋਂ ਮਾਕੀਰੀਆਂ ਦਾ ਟੱਬਰ, ਅਤੇ ਮਾਕੀਰ ਤੋਂ ਗਿਲਆਦ ਜੰਮਿਆ, ਗਿਲਆਦੀਆਂ ਦਾ ਟੱਬਰ ");
INSERT INTO pan_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","ਇਹ ਗਿਲਆਦ ਦੇ ਪੁੱਤਰ, ਈਅਜ਼ਰ ਤੋਂ ਈਅਜ਼ਰੀਆਂ ਦਾ ਟੱਬਰ, ਹੇਲਕ ਤੋਂ ਹੇਲਕੀਆਂ ਦਾ ਟੱਬਰ ");
INSERT INTO pan_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","ਅਤੇ ਅਸਰੀਏਲ ਤੋਂ ਅਸਰੀਏਲੀਆਂ ਦਾ ਟੱਬਰ ਅਤੇ ਸ਼ਕਮ ਤੋਂ ਸ਼ਕਮੀਆਂ ਦਾ ਟੱਬਰ ");
INSERT INTO pan_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","ਅਤੇ ਸ਼ਮੀਦਾ ਤੋਂ ਸ਼ਮੀਦਾਈਆਂ ਦਾ ਟੱਬਰ ਅਤੇ ਹੇਫ਼ਰ ਤੋਂ ਹੇਫ਼ਰੀਆਂ ਦਾ ਟੱਬਰ ");
INSERT INTO pan_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","ਅਤੇ ਸਲਾਫ਼ਹਾਦ ਹੇਫ਼ਰ ਦੇ ਪੁੱਤਰ ਕੋਲ ਪੁੱਤਰ ਨਹੀਂ ਪਰ ਧੀਆਂ ਸਨ ਅਤੇ ਸਲਾਫ਼ਹਾਦ ਦੀਆਂ ਧੀਆਂ ਦੇ ਨਾਮ ਮਹਲਾਹ, ਨੋਆਹ, ਹਾਗਲਾਹ, ਮਿਲਕਾਹ ਅਤੇ ਤਿਰਸਾਹ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","ਇਹ ਮਨੱਸ਼ਹ ਦੇ ਟੱਬਰ ਹਨ ਅਤੇ ਉਨ੍ਹਾਂ ਦੇ ਗਿਣੇ ਹੋਏ ਬਵੰਜਾ ਹਜ਼ਾਰ ਸੱਤ ਸੌ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","ਇਫ਼ਰਾਈਮ ਦੇ ਪੁੱਤਰ ਆਪਣਿਆਂ ਟੱਬਰਾਂ ਅਨੁਸਾਰ ਇਹ ਸਨ, ਸ਼ੁਥਲਹ ਤੋਂ ਸ਼ੁਥਲਹੀਆਂ ਦਾ ਟੱਬਰ, ਬੇਕੇਰ ਤੋਂ ਬੇਕੇਰਿਆਂ ਦਾ ਟੱਬਰ, ਤਹਨ ਤੋਂ ਤਹਨੀਆਂ ਦਾ ਟੱਬਰ ");
INSERT INTO pan_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","ਅਤੇ ਇਹ ਸ਼ੁਥਲਹ ਦੇ ਪੁੱਤਰ ਸਨ, ਏਰਾਨ ਤੋਂ ਏਰਾਨੀਆਂ ਦਾ ਟੱਬਰ, ");
INSERT INTO pan_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","ਇਹ ਇਫ਼ਰਾਈਮ ਦੇ ਪੁੱਤਰਾਂ ਦੇ ਟੱਬਰ ਉਨ੍ਹਾਂ ਦੇ ਗਿਣੇ ਹੋਇਆਂ ਅਨੁਸਾਰ ਹਨ ਅਤੇ ਉਹ ਬੱਤੀ ਹਜ਼ਾਰ ਪੰਜ ਸੌ ਸਨ। ਇਹ ਯੂਸੁਫ਼ ਦੇ ਪੁੱਤਰ ਉਨ੍ਹਾਂ ਦੇ ਟੱਬਰਾਂ ਅਨੁਸਾਰ ਹਨ। ");
INSERT INTO pan_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","ਬਿਨਯਾਮੀਨ ਦੇ ਪੁੱਤਰ ਆਪਣਿਆਂ ਟੱਬਰਾਂ ਅਨੁਸਾਰ, ਬਲਾ ਤੋਂ ਬਲੀਆਂ ਦਾ ਟੱਬਰ ਅਸ਼ਬੇਲ ਤੋਂ ਅਸ਼ਬੇਲੀਆਂ ਦਾ ਟੱਬਰ, ਅਹੀਰਾਮ ਤੋਂ ਅਹੀਰਾਮੀਆਂ ਦਾ ਟੱਬਰ, ");
INSERT INTO pan_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","ਸ਼ਫ਼ੂਫ਼ਾਮ ਤੋਂ ਸ਼ਫੂਫ਼ਾਮੀਆਂ ਦਾ ਟੱਬਰ, ਹੂਫ਼ਾਮ ਤੋਂ ਹੂਫ਼ਾਮੀਆਂ ਟੱਬਰ ");
INSERT INTO pan_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","ਅਤੇ ਬਲਾ ਦੇ ਪੁੱਤਰ ਅਰਦ ਅਤੇ ਨਅਮਾਨ ਸਨ। ਅਰਦ ਤੋਂ ਅਰਦੀਆਂ ਦਾ ਟੱਬਰ, ਨਆਮਾਨ ਤੋਂ ਨਆਮਾਨੀਆਂ ਦਾ ਟੱਬਰ ");
INSERT INTO pan_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","ਇਹ ਬਿਨਯਾਮੀਨ ਦੇ ਪੁੱਤਰ ਉਨ੍ਹਾਂ ਦੇ ਟੱਬਰਾਂ ਅਨੁਸਾਰ ਹਨ ਅਤੇ ਉਨ੍ਹਾਂ ਦੇ ਗਿਣੇ ਹੋਏ ਪੰਤਾਲੀ ਹਜ਼ਾਰ ਛੇ ਸੌ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","ਦਾਨ ਦੇ ਪੁੱਤਰ ਆਪਣਿਆਂ ਟੱਬਰਾਂ ਅਨੁਸਾਰ, ਸ਼ੂਹਾਮ ਤੋਂ ਸ਼ੂਹਾਮੀਆਂ ਦਾ ਟੱਬਰ, ਇਹ ਦਾਨੀਆਂ ਦੇ ਟੱਬਰ ਉਨ੍ਹਾਂ ਦੇ ਟੱਬਰਾਂ ਅਨੁਸਾਰ ਹਨ। ");
INSERT INTO pan_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","ਸ਼ੂਹਾਮੀਆਂ ਦੇ ਸਾਰੇ ਟੱਬਰ ਦੇ ਗਿਣੇ ਹੋਇਆਂ ਅਨੁਸਾਰ ਚੌਂਹਠ ਹਜ਼ਾਰ ਚਾਰ ਸੌ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","ਆਸ਼ੇਰ ਦੇ ਪੁੱਤਰ ਆਪਣਿਆਂ ਟੱਬਰਾਂ ਅਨੁਸਾਰ, ਯਿਮਨਾਹ ਤੋਂ ਯਿਮਨਾਹੀਆਂ ਦਾ ਟੱਬਰ, ਯਿਸ਼ਵੀ ਤੋਂ ਯਿਸ਼ਵੀਆਂ ਦਾ ਟੱਬਰ, ਬਰੀਆਹ ਤੋਂ ਬਰੀਈਆਂ ਦਾ ਟੱਬਰ ");
INSERT INTO pan_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","ਬਰੀਆਹ ਦੇ ਪੁੱਤਰ ਤੋਂ, ਹੇਬਰ ਤੋਂ ਹੇਬਰੀਆਂ ਦਾ ਟੱਬਰ, ਮਲਕੀਏਲ ਤੋਂ ਮਲਕੀਏਲੀਆਂ ਦਾ ਟੱਬਰ ");
INSERT INTO pan_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","ਅਤੇ ਆਸ਼ੇਰ ਦੀ ਧੀ ਦਾ ਨਾਮ ਸਰਹ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","ਇਹ ਆਸ਼ੇਰੀਆਂ ਦੇ ਟੱਬਰ ਉਨ੍ਹਾਂ ਦੇ ਗਿਣੇ ਹੋਇਆਂ ਅਨੁਸਾਰ ਹਨ ਅਤੇ ਉਹ ਤਿਰਵੰਜਾ ਹਜ਼ਾਰ ਚਾਰ ਸੌ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","ਨਫ਼ਤਾਲੀ ਦੇ ਪੁੱਤਰ ਉਨ੍ਹਾਂ ਦੇ ਟੱਬਰਾਂ ਅਨੁਸਾਰ, ਯਹਸਏਲ ਤੋਂ ਯਹਸਏਲੀਆਂ ਦਾ ਟੱਬਰ, ਗੂਨੀ ਤੋਂ ਗੂਨੀਆਂ ਦਾ ਟੱਬਰ ");
INSERT INTO pan_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","ਯੇਸਰ ਤੋਂ ਯੇਸਰੀਆਂ ਦਾ ਟੱਬਰ, ਸ਼ਿੱਲੇਮ ਤੋਂ ਸ਼ਿੱਲੇਮੀਆਂ ਦਾ ਟੱਬਰ ");
INSERT INTO pan_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","ਇਹ ਨਫ਼ਤਾਲੀ ਦੇ ਟੱਬਰ ਉਨ੍ਹਾਂ ਦੇ ਟੱਬਰਾਂ ਅਨੁਸਾਰ ਹਨ ਅਤੇ ਉਨ੍ਹਾਂ ਦੇ ਗਿਣੇ ਹੋਏ ਪੈਂਤਾਲੀ ਹਜ਼ਾਰ ਚਾਰ ਸੌ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","ਇਹ ਇਸਰਾਏਲੀਆਂ ਦੇ ਗਿਣੇ ਹੋਏ ਛੇ ਲੱਖ ਇੱਕ ਹਜ਼ਾਰ ਸੱਤ ਸੌ ਤੀਹ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","ਤਦ ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਆਖਿਆ, ");
INSERT INTO pan_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","ਇਨ੍ਹਾਂ ਦੀ ਜ਼ਮੀਨ ਇਨ੍ਹਾਂ ਦੇ ਨਾਮਾਂ ਦੇ ਲੇਖੇ ਅਨੁਸਾਰ ਵੰਡੀ ਜਾਵੇ ");
INSERT INTO pan_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","ਬਹੁਤਿਆਂ ਲਈ ਤੂੰ ਵੱਡੀ ਜ਼ਮੀਨ ਦੇਈਂ। ਅਤੇ ਥੋੜ੍ਹਿਆਂ ਲਈ ਛੋਟੀ ਜ਼ਮੀਨ ਦੇਈਂ। ਹਰ ਇੱਕ ਨੂੰ ਆਪਣੀ ਗਿਣਤੀ ਅਨੁਸਾਰ ਜ਼ਮੀਨ ਦਿੱਤੀ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","ਤਾਂ ਵੀ ਚਿੱਠੀਆਂ ਪਾ ਕੇ ਧਰਤੀ ਵੰਡੀ। ਉਨ੍ਹਾਂ ਦੇ ਪੁਰਖਿਆਂ ਦਿਆਂ ਗੋਤਾਂ ਦੇ ਨਾਮਾਂ ਅਨੁਸਾਰ ਉਹ ਜ਼ਮੀਨ ਲੈਣ। ");
INSERT INTO pan_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","ਚਿੱਠੀ ਪਾਉਣ ਨਾਲ ਜ਼ਮੀਨ ਬਹੁਤਿਆਂ ਅਤੇ ਥੋੜ੍ਹਿਆਂ ਵਿੱਚ ਵੰਡੀ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","ਇਹ ਲੇਵੀ ਦੇ ਗਿਣੇ ਹੋਏ ਆਪਣਿਆਂ ਟੱਬਰਾਂ ਅਨੁਸਾਰ ਹਨ, ਗੇਰਸ਼ੋਨ ਤੋਂ ਗੇਰਸ਼ੋਨੀਆਂ ਦਾ ਟੱਬਰ, ਕਹਾਥ ਤੋਂ ਕਹਾਥੀਆਂ ਦਾ ਟੱਬਰ, ਮਰਾਰੀ ਤੋਂ ਮਰਾਰੀਆਂ ਦਾ ਟੱਬਰ ");
INSERT INTO pan_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","ਇਹ ਲੇਵੀ ਦੇ ਟੱਬਰ ਹਨ, ਲਿਬਨੀ ਦਾ ਟੱਬਰ, ਹਬਰੋਨੀ ਦਾ ਟੱਬਰ, ਮਹਲੀ ਦਾ ਟੱਬਰ, ਮੂਸ਼ੀ ਦਾ ਟੱਬਰ, ਕਾਰਹੀ ਦਾ ਟੱਬਰ ਅਤੇ ਕਹਾਥ ਤੋਂ ਅਮਰਾਮ ਜੰਮਿਆਂ ");
INSERT INTO pan_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","ਅਤੇ ਅਮਰਾਮ ਦੀ ਪਤਨੀ ਦਾ ਨਾਮ ਯੋਕਬਦ ਸੀ ਅਤੇ ਉਹ ਲੇਵੀ ਦੀ ਧੀ ਸੀ ਜਿਹੜੀ ਲੇਵੀ ਲਈ ਮਿਸਰ ਵਿੱਚ ਜੰਮੀ ਅਤੇ ਉਹ ਅਮਰਾਮ ਲਈ ਹਾਰੂਨ ਅਤੇ ਮੂਸਾ ਅਤੇ ਉਨ੍ਹਾਂ ਦੀ ਭੈਣ ਮਿਰਯਮ ਨੂੰ ਜਣੀ। ");
INSERT INTO pan_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","ਅਤੇ ਹਾਰੂਨ ਲਈ ਨਾਦਾਬ, ਅਬੀਹੂ, ਅਲਆਜ਼ਾਰ, ਈਥਾਮਾਰ ਜੰਮੇ। ");
INSERT INTO pan_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","ਅਤੇ ਨਾਦਾਬ ਅਤੇ ਅਬੀਹੂ ਮਰ ਗਏ ਜਦ ਉਹ ਓਪਰੀ ਅੱਗ ਯਹੋਵਾਹ ਦੇ ਸਨਮੁਖ ਲਿਆਏ। ");
INSERT INTO pan_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","ਅਤੇ ਉਨ੍ਹਾਂ ਦੇ ਗਿਣੇ ਹੋਏ ਅਰਥਾਤ ਸਾਰੇ ਆਦਮੀ ਇੱਕ ਮਹੀਨੇ ਦੇ ਅਤੇ ਉੱਪਰ ਦੇ ਤੇਈ ਹਜ਼ਾਰ ਸਨ। ਉਹ ਇਸਰਾਏਲੀਆਂ ਵਿੱਚ ਇਸ ਲਈ ਨਹੀਂ ਗਿਣੇ ਗਏ ਕਿ ਉਨ੍ਹਾਂ ਨੂੰ ਇਸਰਾਏਲੀਆਂ ਵਿੱਚ ਕੋਈ ਜ਼ਮੀਨ ਨਹੀਂ ਦਿੱਤੀ ਗਈ। ");
INSERT INTO pan_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","ਇਹ ਉਹ ਹਨ ਜਿਹੜੇ ਮੂਸਾ ਅਤੇ ਅਲਆਜ਼ਾਰ ਜਾਜਕ ਤੋਂ ਗਿਣੇ ਗਏ, ਜਿਨ੍ਹਾਂ ਨੇ ਇਸਰਾਏਲੀਆਂ ਨੂੰ ਮੋਆਬ ਦੇ ਮੈਦਾਨ ਵਿੱਚ ਯਰਦਨ ਉੱਤੇ ਯਰੀਹੋ ਕੋਲ ਗਿਣਿਆ। ");
INSERT INTO pan_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","ਪਰ ਇਨ੍ਹਾਂ ਵਿੱਚ, ਉਨ੍ਹਾਂ ਗਿਣਿਆਂ ਹੋਇਆਂ ਇਸਰਾਏਲੀਆਂ ਵਿੱਚੋਂ ਜਿਨ੍ਹਾਂ ਨੂੰ ਮੂਸਾ ਅਤੇ ਹਾਰੂਨ ਨੇ ਸੀਨਈ ਦੀ ਉਜਾੜ ਵਿੱਚ ਗਿਣਿਆ ਸੀ ਇੱਕ ਵੀ ਮਨੁੱਖ ਨਹੀਂ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","ਕਿਉਂ ਜੋ ਯਹੋਵਾਹ ਨੇ ਉਨ੍ਹਾਂ ਦੇ ਵਿਖੇ ਆਖਿਆ ਸੀ ਕਿ ਉਹ ਉਜਾੜ ਵਿੱਚ ਜ਼ਰੂਰ ਹੀ ਮਰ ਜਾਣਗੇ ਸੋ ਨੂਨ ਦੇ ਪੁੱਤਰ ਯਹੋਸ਼ੁਆ ਅਤੇ ਯਫ਼ੁੰਨਹ ਦੇ ਪੁੱਤਰ ਕਾਲੇਬ ਨੂੰ ਛੱਡ ਕੇ ਉਨ੍ਹਾਂ ਵਿੱਚੋਂ ਇੱਕ ਮਨੁੱਖ ਵੀ ਬਚਿਆ ਨਾ ਰਿਹਾ। ");
INSERT INTO pan_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","ਯੂਸੁਫ਼ ਦੇ ਪੁੱਤਰ ਮਨੱਸ਼ਹ ਦੇ ਟੱਬਰਾਂ ਵਿੱਚੋਂ ਸਲਾਫ਼ਹਾਦ ਜਿਹੜਾ ਹੇਫ਼ਰ ਦਾ ਪੁੱਤਰ ਗਿਲਆਦ ਦਾ ਪੋਤਾ ਮਾਕੀਰ ਦਾ ਪੜਪੋਤਾ ਅਤੇ ਮਨੱਸ਼ਹ ਦੀ ਅੰਸ ਤੋਂ ਸੀ ਉਸ ਦੀਆਂ ਧੀਆਂ ਆਈਆਂ ਜਿਨ੍ਹਾਂ ਦੇ ਨਾਮ ਮਹਲਾਹ, ਨੋਆਹ, ਹਾਗਲਾਹ, ਮਿਲਕਾਹ, ਅਤੇ ਤਿਰਸਾਹ ਸਨ ");
INSERT INTO pan_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","ਅਤੇ ਮੂਸਾ ਦੇ ਅੱਗੇ, ਅਲਆਜ਼ਾਰ ਜਾਜਕ, ਪ੍ਰਧਾਨਾਂ ਅਤੇ ਸਾਰੀ ਮੰਡਲੀ ਦੇ ਅੱਗੇ ਮੰਡਲੀ ਦੇ ਤੰਬੂ ਦੇ ਦਰਵਾਜ਼ੇ ਵਿੱਚ ਖੜ੍ਹੇ ਹੋ ਕੇ ਆਖਿਆ, ");
INSERT INTO pan_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","ਸਾਡਾ ਪਿਤਾ ਉਜਾੜ ਵਿੱਚ ਮਰ ਗਿਆ ਪਰ ਉਹ ਉਸ ਟੋਲੀ ਵਿੱਚ ਨਹੀਂ ਸੀ ਜਿਹੜੇ ਕੋਰਹ ਦੀ ਮੰਡਲੀ ਨਾਲ ਰਲ ਕੇ ਯਹੋਵਾਹ ਦੇ ਵਿਰੁੱਧ ਹੋ ਗਏ ਸਨ। ਉਹ ਤਾਂ ਆਪਣੇ ਹੀ ਪਾਪ ਨਾਲ ਮਰਿਆ ਅਤੇ ਉਸ ਦੇ ਪੁੱਤਰ ਨਹੀਂ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","ਸਾਡੇ ਪਿਤਾ ਦਾ ਨਾਮ ਉਸ ਦੇ ਟੱਬਰ ਵਿੱਚੋਂ ਪੁੱਤਰ ਨਾ ਹੋਣ ਦੇ ਕਾਰਨ ਕਿਉਂ ਮਿਟਾਇਆ ਜਾਵੇ? ਸਾਨੂੰ ਵੀ ਸਾਡੇ ਪਿਤਾ ਦੇ ਭਰਾਵਾਂ ਨਾਲ ਜ਼ਮੀਨ ਦਿਓ। ");
INSERT INTO pan_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","ਤਾਂ ਮੂਸਾ ਉਨ੍ਹਾਂ ਦੀ ਬੇਨਤੀ ਨੂੰ ਯਹੋਵਾਹ ਅੱਗੇ ਲੈ ਗਿਆ। ");
INSERT INTO pan_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","ਤਾਂ ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਆਖਿਆ, ");
INSERT INTO pan_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","ਸਲਾਫ਼ਹਾਦ ਦੀਆਂ ਧੀਆਂ ਠੀਕ ਬੋਲਦੀਆਂ ਹਨ, ਉਨ੍ਹਾਂ ਨੂੰ ਉਨ੍ਹਾਂ ਦੇ ਪਿਤਾ ਦੇ ਭਰਾਵਾਂ ਨਾਲ ਜ਼ਰੂਰ ਜਾਇਦਾਦ ਦੇ ਅਰਥਾਤ ਉਨ੍ਹਾਂ ਤੱਕ ਉਨ੍ਹਾਂ ਦੇ ਪਿਤਾ ਦੀ ਜ਼ਮੀਨ ਪਹੁੰਚਾ ਦੇ। ");
INSERT INTO pan_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","ਤੂੰ ਇਸਰਾਏਲੀਆਂ ਨੂੰ ਬੋਲ ਕਿ ਜੇ ਕੋਈ ਮਨੁੱਖ ਮਰ ਜਾਵੇ ਅਤੇ ਉਸ ਦਾ ਪੁੱਤਰ ਨਾ ਹੋਵੇ ਤਾਂ ਉਸ ਦੀ ਜ਼ਮੀਨ ਉਸ ਦੀ ਧੀ ਨੂੰ ਦੇਵੋ। ");
INSERT INTO pan_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","ਜੇ ਉਸ ਦੀ ਧੀ ਨਾ ਹੋਵੇ ਤਾਂ ਤੁਸੀਂ ਉਸ ਦੀ ਜ਼ਮੀਨ ਉਸ ਦੇ ਭਰਾਵਾਂ ਨੂੰ ਦਿਓ। ");
INSERT INTO pan_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","ਜੇ ਉਸ ਦਾ ਭਰਾ ਨਾ ਹੋਵੇ ਤਾਂ ਤੁਸੀਂ ਉਸ ਦੀ ਜ਼ਮੀਨ ਉਸ ਦੇ ਪਿਤਾ ਦੇ ਭਰਾਵਾਂ ਨੂੰ ਦਿਓ। ");
INSERT INTO pan_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","ਅਤੇ ਜੇ ਉਸ ਦੇ ਪਿਤਾ ਦੇ ਭਰਾ ਨਾ ਹੋਣ ਤਾਂ ਤੁਸੀਂ ਉਸ ਦੀ ਜ਼ਮੀਨ ਉਸ ਦੇ ਨਜ਼ਦੀਕੀ ਰਿਸ਼ਤੇਦਾਰ ਨੂੰ ਜਿਹੜੇ ਉਸ ਦੇ ਟੱਬਰ ਦੇ ਹੋਣ ਦਿਓ ਅਤੇ ਉਹ ਆਪਣੇ ਕਬਜ਼ੇ ਵਿੱਚ ਲੈਣ ਅਤੇ ਇਹ ਇਸਰਾਏਲੀਆਂ ਲਈ ਨਿਆਂ ਦੀ ਬਿਧੀ ਹੋਵੇ ਜਿਵੇਂ ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਹੁਕਮ ਦਿੱਤਾ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","ਤਾਂ ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਆਖਿਆ ਕਿ ਤੂੰ ਇਸ ਅਬਾਰੀਮ ਨਾਮੀ ਪਰਬਤ ਉੱਤੇ ਚੜ੍ਹ ਅਤੇ ਉਸ ਧਰਤੀ ਨੂੰ ਵੇਖ ਜਿਹੜੀ ਮੈਂ ਇਸਰਾਏਲੀਆਂ ਨੂੰ ਦਿੱਤੀ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","ਜਦ ਤੂੰ ਉਹ ਨੂੰ ਵੇਖ ਲਿਆ ਤਾਂ ਤੂੰ ਵੀ ਆਪਣੇ ਲੋਕਾਂ ਵਿੱਚ ਜਾ ਰਲੇਗਾ ਜਿਵੇਂ ਹਾਰੂਨ ਤੇਰਾ ਭਰਾ ਜਾ ਰਲਿਆ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","ਇਸ ਲਈ ਕਿ ਤੁਸੀਂ ਮੇਰੇ ਹੁਕਮ ਨੂੰ ਸੀਨਈ ਦੀ ਉਜਾੜ ਵਿੱਚ ਰੱਦਿਆ ਜਦ ਮੰਡਲੀ ਵਿਰੋਧੀ ਹੋ ਗਈ ਅਤੇ ਤੁਸੀਂ ਮੈਨੂੰ ਉਸ ਪਾਣੀ ਵਿਖੇ ਉਨ੍ਹਾਂ ਦੀਆਂ ਅੱਖਾਂ ਅੱਗੇ ਪਵਿੱਤਰ ਨਾ ਠਹਿਰਾਇਆ। ਉਹ ਮਰੀਬਾਹ ਦਾ ਪਾਣੀ ਸੀਨ ਦੀ ਉਜਾੜ ਵਿੱਚ ਕਾਦੇਸ਼ ਦੇ ਕੋਲ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","ਫਿਰ ਮੂਸਾ ਨੇ ਯਹੋਵਾਹ ਨਾਲ ਗੱਲ ਕੀਤੀ ");
INSERT INTO pan_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","ਕਿ ਯਹੋਵਾਹ ਜਿਹੜਾ ਸਾਰੇ ਸਰੀਰਾਂ ਦੀਆਂ ਆਤਮਾਵਾਂ ਦਾ ਪਰਮੇਸ਼ੁਰ ਹੈ ਕਿਸੇ ਮਨੁੱਖ ਨੂੰ ਮੰਡਲੀ ਉੱਤੇ ਠਹਿਰਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","ਜਿਹੜਾ ਉਨ੍ਹਾਂ ਦੇ ਅੱਗੇ ਬਾਹਰ ਜਾਵੇ ਅਤੇ ਜਿਹੜਾ ਉਨ੍ਹਾਂ ਦੇ ਅੱਗੇ ਅੰਦਰ ਆਵੇ ਅਤੇ ਜਿਹੜਾ ਉਨ੍ਹਾਂ ਨੂੰ ਬਾਹਰ ਲੈ ਜਾਵੇ ਅਤੇ ਅੰਦਰ ਲੈ ਆਵੇ ਤਾਂ ਜੋ ਯਹੋਵਾਹ ਦੀ ਮੰਡਲੀ ਉਸ ਇੱਜੜ ਵਾਂਗੂੰ ਨਾ ਹੋਵੇ ਜਿਨ੍ਹਾਂ ਦਾ ਕੋਈ ਚਰਵਾਹਾ ਨਹੀਂ। ");
INSERT INTO pan_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","ਅੱਗੋਂ ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਆਖਿਆ, ਨੂਨ ਦੇ ਪੁੱਤਰ ਯਹੋਸ਼ੁਆ ਨੂੰ ਆਪਣੇ ਲਈ ਲੈ। ਉਹ ਇੱਕ ਮਨੁੱਖ ਹੈ ਜਿਸ ਦੇ ਵਿੱਚ ਆਤਮਾ ਹੈ ਅਤੇ ਤੂੰ ਆਪਣਾ ਹੱਥ ਉਸ ਉੱਤੇ ਰੱਖ। ");
INSERT INTO pan_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","ਫੇਰ ਤੂੰ ਉਹ ਨੂੰ ਅਲਆਜ਼ਾਰ ਜਾਜਕ ਦੇ ਅੱਗੇ ਅਤੇ ਸਾਰੀ ਮੰਡਲੀ ਦੇ ਅੱਗੇ ਖੜ੍ਹਾ ਕਰ ਕੇ ਉਨ੍ਹਾਂ ਦੇ ਵੇਖਦਿਆਂ ਉਹ ਨੂੰ ਅਧਿਕਾਰ ਦੇ। ");
INSERT INTO pan_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","ਅਤੇ ਤੂੰ ਉਸ ਨੂੰ ਆਪਣੀ ਪਦਵੀ ਤੋਂ ਦੇ ਤਾਂ ਜੋ ਇਸਰਾਏਲ ਦੀ ਸਾਰੀ ਮੰਡਲੀ ਉਸ ਦੀ ਸੁਣੇ। ");
INSERT INTO pan_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","ਅਤੇ ਉਹ ਅਲਆਜ਼ਾਰ ਜਾਜਕ ਦੇ ਅੱਗੇ ਖੜ੍ਹਾ ਹੋਵੇ ਅਤੇ ਉਹ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਊਰੀਮ ਦਾ ਫ਼ੈਸਲਾ ਉਹ ਦੇ ਵਿਖੇ ਪੁੱਛੇ। ਉਸ ਦੇ ਹੁਕਮ ਉੱਤੇ ਉਹ ਸਾਰੇ ਇਸਰਾਏਲੀ ਅਰਥਾਤ ਸਾਰੀ ਮੰਡਲੀ ਬਾਹਰ ਜਾਵੇ ਅਤੇ ਉਸ ਦੇ ਹੁਕਮ ਉੱਤੇ ਅੰਦਰ ਆਵੇ। ");
INSERT INTO pan_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","ਸੋ ਮੂਸਾ ਨੇ ਇਸੇ ਤਰ੍ਹਾਂ ਹੀ ਕੀਤਾ ਜਿਵੇਂ ਯਹੋਵਾਹ ਨੇ ਉਹ ਨੂੰ ਹੁਕਮ ਦਿੱਤਾ ਸੀ ਅਤੇ ਯਹੋਸ਼ੁਆ ਨੂੰ ਲੈ ਕੇ ਅਲਆਜ਼ਾਰ ਜਾਜਕ ਦੇ ਅੱਗੇ ਅਤੇ ਸਾਰੀ ਮੰਡਲੀ ਦੇ ਅੱਗੇ ਖੜ੍ਹਾ ਕੀਤਾ। ");
INSERT INTO pan_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","ਫੇਰ ਉਹ ਨੇ ਆਪਣੇ ਹੱਥ ਉਸ ਉੱਤੇ ਰੱਖੇ ਅਤੇ ਉਸ ਨੂੰ ਇਖ਼ਤਿਆਰ ਦਿੱਤਾ ਜਿਵੇਂ ਯਹੋਵਾਹ ਮੂਸਾ ਦੇ ਰਾਹੀਂ ਬੋਲਿਆ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਆਖਿਆ, ");
INSERT INTO pan_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","ਤੂੰ ਇਸਰਾਏਲੀਆਂ ਨੂੰ ਹੁਕਮ ਦੇ ਕੇ, ਉਨ੍ਹਾਂ ਨੂੰ ਆਖ ਕਿ ਮੇਰਾ ਚੜ੍ਹਾਵਾ ਅਰਥਾਤ ਮੇਰਾ ਭੋਜਨ ਅੱਗ ਦੀ ਭੇਟ ਲਈ, ਜਿਹੜੀ ਮੇਰੇ ਲਈ ਸੁਗੰਧਤਾ ਹੋਵੇ ਯਾਦ ਰੱਖੋ ਤਾਂ ਜੋ ਠਹਿਰਾਏ ਹੋਏ ਸਮੇਂ ਉੱਤੇ ਤੁਸੀਂ ਮੇਰੇ ਲਈ ਚੜ੍ਹਾਇਆ ਕਰੋ। ");
INSERT INTO pan_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","ਅਤੇ ਤੂੰ ਉਨ੍ਹਾਂ ਨੂੰ ਆਖੀਂ, ਅੱਗ ਦੀ ਭੇਟ ਇਹ ਹੈ ਜਿਹੜੀ ਤੁਸੀਂ ਯਹੋਵਾਹ ਲਈ ਚੜ੍ਹਾਓ, ਇੱਕ-ਇੱਕ ਸਾਲ ਦੇ ਦੋ ਲੇਲੇ ਜਿਹੜੇ ਦੋਸ਼ ਰਹਿਤ ਹੋਣ, ਇਹ ਰੋਜ਼ ਦੀ ਹੋਮ ਬਲੀ ਲਈ ਹਨ। ");
INSERT INTO pan_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","ਇੱਕ ਲੇਲਾ ਤੂੰ ਸਵੇਰ ਨੂੰ ਚੜ੍ਹਾਵੀਂ ਅਤੇ ਦੂਜਾ ਲੇਲਾ ਤੂੰ ਸ਼ਾਮ ਨੂੰ ਚੜ੍ਹਾਵੀਂ। ");
INSERT INTO pan_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","ਏਫ਼ਾਹ ਦਾ ਦਸਵੰਧ ਮੈਦੇ ਦਾ, ਮੈਦੇ ਦੀ ਭੇਟ ਲਈ ਖ਼ਾਲਸ ਤੇਲ ਦੇ ਹੀਨ ਦੀ ਚੌਥਾਈ ਵਿੱਚ ਮਿਲਿਆ ਹੋਇਆ। ");
INSERT INTO pan_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","ਇਹ ਸਦੀਪਕਾਲ ਹੋਮ ਬਲੀ ਹੈ ਜਿਹੜੀ ਸੀਨਈ ਦੀ ਪਰਬਤ ਉੱਤੇ ਠਹਿਰਾਈ ਗਈ ਕਿ ਉਹ ਯਹੋਵਾਹ ਲਈ ਸੁਗੰਧਤਾ ਦੀ ਅੱਗ ਦੀ ਬਲੀ ਹੋਵੇ। ");
INSERT INTO pan_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","ਉਹ ਦੇ ਪੀਣ ਦੀ ਭੇਟ ਹੀਨ ਦੀ ਚੌਥਾਈ ਇੱਕ ਭੇਡ ਦੇ ਬੱਚੇ ਲਈ ਹੋਵੇ ਅਤੇ ਪਵਿੱਤਰ ਸਥਾਨ ਵਿੱਚ ਤੂੰ ਉਹ ਨੂੰ ਯਹੋਵਾਹ ਲਈ ਤੁੰਦ ਮਧ ਦੇ ਪੀਣ ਦੀ ਭੇਟ ਕਰਕੇ ਡੋਹਲ ਦੇਈਂ। ");
INSERT INTO pan_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","ਅਤੇ ਦੂਜਾ ਲੇਲਾ ਸ਼ਾਮਾਂ ਨੂੰ ਚੜ੍ਹਾਈਂ। ਸਵੇਰ ਦੇ ਮੈਦੇ ਦੀ ਭੇਟ ਵਾਂਗੂੰ ਅਤੇ ਉਸ ਦੇ ਪੀਣ ਦੀ ਭੇਟ ਵਾਂਗੂੰ ਯਹੋਵਾਹ ਲਈ ਸੁਗੰਧਤਾ ਦੀ ਅੱਗ ਦੀ ਭੇਟ ਕਰਕੇ ਚੜ੍ਹਾਈਂ। ");
INSERT INTO pan_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","ਅਤੇ ਸਬਤ ਦੇ ਦਿਨ ਤੂੰ ਦੋ ਇੱਕ-ਇੱਕ ਸਾਲ ਦੇ ਭੇਡ ਦੇ ਬੱਚੇ ਦੋਸ਼ ਰਹਿਤ, ਤੇਲ ਮਿਲੇ ਹੋਏ ਮੈਦੇ ਦੇ ਦੋ ਦਸਵੰਧ, ਮੈਦੇ ਦੀ ਬਲੀ ਲਈ ਨਾਲੇ ਉਸ ਦੇ ਪੀਣ ਦੀ ਭੇਟ ਚੜ੍ਹਾਓ। ");
INSERT INTO pan_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","ਇਹ ਹਰ ਸਬਤ ਦੀ ਹੋਮ ਦੀ ਬਲੀ ਹੋਵੇ, ਨਾਲੇ ਸਦੀਪਕਾਲ ਹੋਮ ਦੀ ਬਲੀ ਅਤੇ ਉਸ ਦੇ ਪੀਣ ਦੀ ਭੇਟ ਹੋਵੇ। ");
INSERT INTO pan_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","ਆਪਣੇ ਮਹੀਨਿਆਂ ਦੀ ਸ਼ੁਰੂਆਤ ਵਿੱਚ ਤੁਸੀਂ ਯਹੋਵਾਹ ਲਈ ਹੋਮ ਦੀ ਬਲੀ ਲਈ ਦੋ ਵਹਿੜੇ ਅਤੇ ਇੱਕ ਭੇਡੂ ਅਤੇ ਸੱਤ ਇੱਕ ਸਾਲ ਦੇ ਭੇਡ ਦੇ ਬੱਚੇ ਦੋਸ਼ ਰਹਿਤ ਚੜ੍ਹਾਇਆ ਕਰੋ। ");
INSERT INTO pan_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","ਅਤੇ ਹਰ ਇੱਕ ਵਹਿੜੇ ਦੇ ਮੈਦੇ ਦੀ ਭੇਟ ਲਈ ਤਿੰਨ ਦਸਵੰਧ ਤੇਲ ਮਿਲੇ ਹੋਏ ਮੈਦੇ ਦੇ ਹੋਣ ਅਤੇ ਹਰ ਭੇਡੂ ਦੇ ਮੈਦੇ ਦੀ ਭੇਟ ਲਈ ਦੋ ਦਸਵੰਧ ਤੇਲ ਮਿਲੇ ਹੋਏ ਮੈਦੇ ਦੇ ਹੋਣ। ");
INSERT INTO pan_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","ਹਰ ਭੇਡ ਦੇ ਬੱਚੇ ਦੇ ਮੈਦੇ ਦੀ ਭੇਟ ਲਈ ਇੱਕ ਦਸਵੰਧ ਮੈਦੇ ਦਾ ਤੇਲ ਮਿਲਿਆ ਹੋਇਆ ਹੋਵੇ। ਇਹ ਹੋਮ ਦੀ ਬਲੀ ਯਹੋਵਾਹ ਲਈ ਸੁਗੰਧਤਾ ਦੀ ਅੱਗ ਦੀ ਭੇਟ ਹੋਵੇਗੀ। ");
INSERT INTO pan_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","ਉਨ੍ਹਾਂ ਦੇ ਪੀਣ ਦੀਆਂ ਭੇਟਾਂ ਹਰ ਵਹਿੜੇ ਲਈ ਅੱਧਾ ਹੀਨ ਮਧ ਅਤੇ ਹਰ ਭੇਡੂ ਲਈ ਹੀਨ ਦੀ ਤਿਹਾਈ ਅਤੇ ਹਰ ਭੇਡ ਦੇ ਬੱਚੇ ਲਈ ਹੀਨ ਦੀ ਚੌਥਾਈ ਹੋਵੇ। ਇਹ ਸਾਰੇ ਸਾਲ ਦੇ ਹਰ ਮਹੀਨੇ ਦੀ ਹੋਮ ਦੀ ਬਲੀ ਹੋਵੇ। ");
INSERT INTO pan_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","ਅਤੇ ਯਹੋਵਾਹ ਲਈ ਪਾਪ ਬਲੀ ਇੱਕ ਬੱਕਰਾ ਹੋਵੇ। ਸਦੀਪਕਾਲ ਹੋਮ ਦੀ ਬਲੀ ਦੇ ਨਾਲ ਇਹ ਅਤੇ ਉਸ ਦੇ ਪੀਣ ਦੀ ਭੇਟ ਚੜ੍ਹਾਈ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","ਅਤੇ ਪਹਿਲੇ ਮਹੀਨੇ ਦੇ ਚੌਧਵੇਂ ਦਿਨ ਯਹੋਵਾਹ ਦਾ ਪਸਾਹ ਹੋਵੇ। ");
INSERT INTO pan_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","ਅਤੇ ਇਸੇ ਮਹੀਨੇ ਦੇ ਪੰਦਰਵੇਂ ਦਿਨ ਇੱਕ ਪਰਬ ਹੋਵੇ ਅਤੇ ਸੱਤ ਦਿਨ ਤੱਕ ਪਤੀਰੀ ਰੋਟੀ ਖਾਧੀ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","ਪਹਿਲੇ ਦਿਨ ਇੱਕ ਪਵਿੱਤਰ ਸਭਾ ਹੋਵੇ। ਜਿਸ ਵਿੱਚ ਤੁਸੀਂ ਕੋਈ ਕੰਮ-ਧੰਦਾ ਨਾ ਕਰਨਾ। ");
INSERT INTO pan_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","ਪਰ ਤੁਸੀਂ ਅੱਗ ਦੀ ਭੇਟ ਚੜ੍ਹਾਇਓ ਜਿਹੜੀ ਯਹੋਵਾਹ ਲਈ ਹੋਮ ਦੀ ਬਲੀ ਹੋਵੇ। ਦੋ ਵਹਿੜੇ, ਇੱਕ ਭੇਡੂ ਅਤੇ ਸੱਤ ਇੱਕ-ਇੱਕ ਸਾਲ ਦੇ ਭੇਡ ਦੇ ਬੱਚੇ ਇਹ ਦੋਸ਼ ਰਹਿਤ ਹੋਣ। ");
INSERT INTO pan_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","ਅਤੇ ਉਨ੍ਹਾਂ ਦੇ ਮੈਦੇ ਦੀ ਭੇਟ ਤੇਲ ਮਿਲੇ ਹੋਏ ਮੈਦੇ ਦੀ ਹੋਵੇ। ਹਰੇਕ ਵੱਛੇ ਲਈ ਤਿੰਨ ਦਸਵੰਧ, ਹਰੇਕ ਮੇਂਢੇ ਲਈ ਦੋ ਦਸਵੰਧ ਚੜ੍ਹਾਓ। ");
INSERT INTO pan_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","ਤੂੰ ਸੱਤਾਂ ਲੇਲਿਆਂ ਵਿੱਚੋਂ ਹਰ ਭੇਡ ਦੇ ਬੱਚੇ ਲਈ ਇੱਕ ਦਸਵੰਧ ਚੜ੍ਹਾ ");
INSERT INTO pan_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","ਅਤੇ ਇੱਕ ਬੱਕਰਾ ਤੁਹਾਡੇ ਪ੍ਰਾਸਚਿਤ ਲਈ ਪਾਪ ਬਲੀ ਹੋਵੇ। ");
INSERT INTO pan_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","ਅਤੇ ਸਵੇਰ ਦੀ ਹੋਮ ਦੀ ਬਲੀ ਤੋਂ ਬਿਨ੍ਹਾਂ ਜਿਹੜੀ ਸਦੀਪਕਾਲ ਹੋਮ ਬਲੀ ਹੈ ਤੁਸੀਂ ਇਨ੍ਹਾਂ ਨੂੰ ਚੜ੍ਹਾਇਓ। ");
INSERT INTO pan_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","ਇਸੇ ਤਰ੍ਹਾਂ ਤੁਸੀਂ ਸੱਤਾਂ ਦਿਨਾਂ ਤੱਕ ਯਹੋਵਾਹ ਲਈ ਪਰਸ਼ਾਦ ਚੜ੍ਹਾਇਓ ਜਿਹੜਾ ਸੁਗੰਧਤਾ ਦੀ ਅੱਗ ਦੀ ਭੇਟ ਹੋਵੇ ਅਤੇ ਇਹ ਹੋਮ ਬਲੀ ਅਤੇ ਪੀਣ ਦੀ ਭੇਟ ਦੇ ਬਿਨ੍ਹਾਂ ਚੜ੍ਹਾਇਆ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","ਸੱਤਵੇਂ ਦਿਨ ਤੁਹਾਡੀ ਪਵਿੱਤਰ ਸਭਾ ਹੋਵੇ। ਉਸ ਵਿੱਚ ਤੁਸੀਂ ਕੋਈ ਕੰਮ-ਧੰਦਾ ਨਾ ਕਰਨਾ। ");
INSERT INTO pan_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","ਪਹਿਲੇ ਫ਼ਲਾਂ ਦੇ ਦਿਨ ਜਦ ਤੁਸੀਂ ਆਪਣੇ ਅਠਵਾਰਿਆਂ ਦੇ ਪਰਬ ਵਿੱਚ ਯਹੋਵਾਹ ਲਈ ਨਵੀਂ ਮੈਦੇ ਦੀ ਭੇਟ ਚੜ੍ਹਾਓ ਤਾਂ ਤੁਹਾਡੀ ਇੱਕ ਪਵਿੱਤਰ ਸਭਾ ਹੋਵੇ। ਉਸ ਦਿਨ ਤੁਸੀਂ ਕੋਈ ਕੰਮ-ਧੰਦਾ ਨਾ ਕਰਨਾ। ");
INSERT INTO pan_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","ਤੁਸੀਂ ਯਹੋਵਾਹ ਲਈ ਸੁਗੰਧਤਾ ਦੀ ਹੋਮ ਬਲੀ ਚੜ੍ਹਾਇਓ ਅਰਥਾਤ ਦੋ ਜੁਆਨ ਬਲ਼ਦ, ਇੱਕ ਛੱਤਰਾ ਅਤੇ ਇੱਕ ਸਾਲ ਦੇ ਸੱਤ ਲੇਲੇ ");
INSERT INTO pan_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","ਨਾਲੇ ਉਨ੍ਹਾਂ ਦੀ ਤੇਲ ਮਿਲੇ ਹੋਏ ਮੈਦੇ ਦੀ ਭੇਟ। ਹਰ ਵਹਿੜੇ ਲਈ ਤਿੰਨ ਦਸਵੰਧ ਅਤੇ ਹਰ ਭੇਡੂ ਲਈ ਦੋ ਦਸਵੰਧ। ");
INSERT INTO pan_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","ਉਨ੍ਹਾਂ ਸੱਤਾਂ ਭੇਡ ਦੇ ਬੱਚਿਆਂ ਵਿੱਚੋਂ ਹਰ ਭੇਡ ਦੇ ਬੱਚੇ ਲਈ ਇੱਕ ਦਸਵੰਧ। ");
INSERT INTO pan_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","ਨਾਲੇ ਇੱਕ ਬੱਕਰਾ ਤੁਹਾਡੇ ਪ੍ਰਾਸਚਿਤ ਲਈ ਚੜ੍ਹਾਇਆ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","ਹੋਮ ਬਲੀ ਅਤੇ ਉਸ ਦੇ ਮੈਦੇ ਦੀ ਭੇਟ ਤੋਂ ਬਿਨ੍ਹਾਂ ਤੁਸੀਂ ਉਨ੍ਹਾਂ ਨੂੰ ਜਿਹੜੇ ਦੋਸ਼ ਰਹਿਤ ਹੋਣ ਅਤੇ ਉਨ੍ਹਾਂ ਦੇ ਪੀਣ ਦੀਆਂ ਭੇਟਾਂ ਚੜ੍ਹਾਇਆ ਕਰੋ। ");
INSERT INTO pan_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","ਸੱਤਵੇਂ ਮਹੀਨੇ ਦੇ ਪਹਿਲੇ ਦਿਨ ਤੁਹਾਡੀ ਪਵਿੱਤਰ ਸਭਾ ਹੋਵੇ। ਤੁਸੀਂ ਕੋਈ ਕੰਮ-ਧੰਦਾ ਨਾ ਕਰੋ ਪਰ ਉਹ ਤੁਹਾਡੇ ਲਈ ਤੁਰ੍ਹੀਆਂ ਵਜਾਉਣ ਦਾ ਦਿਨ ਹੋਵੇ। ");
INSERT INTO pan_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","ਅਤੇ ਤੁਸੀਂ ਯਹੋਵਾਹ ਲਈ ਸੁਗੰਧਤਾ ਦੀ ਹੋਮ ਬਲੀ ਚੜ੍ਹਾਓ ਅਰਥਾਤ ਇੱਕ ਮੇਂਢਾ, ਇੱਕ ਭੇਡੂ ਅਤੇ ਦੋਸ਼ ਰਹਿਤ ਸੱਤ ਇੱਕ-ਇੱਕ ਸਾਲ ਦੇ ਭੇਡ ਦੇ ਬੱਚੇ। ");
INSERT INTO pan_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","ਅਤੇ ਉਸ ਦੇ ਮੈਦੇ ਦੀ ਭੇਟ ਤੇਲ ਵਿੱਚ ਮਿਲਿਆ ਹੋਇਆ ਮੈਦਾ ਹੋਵੇ, ਵਹਿੜੇ ਲਈ ਤਿੰਨ ਦਸਵੰਧ, ਭੇਡੂ ਲਈ ਦੋ ਦਸਵੰਧ ");
INSERT INTO pan_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","ਅਤੇ ਸੱਤਾਂ ਭੇਡ ਦੇ ਬੱਚਿਆਂ ਵਿੱਚੋਂ ਹਰ ਭੇਡ ਦੇ ਬੱਚੇ ਲਈ ਇੱਕ ਦਸਵੰਧ ");
INSERT INTO pan_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","ਨਾਲੇ ਤੁਹਾਡੇ ਪ੍ਰਾਸਚਿਤ ਲਈ ਇੱਕ ਬੱਕਰਾ ਪਾਪ ਬਲੀ ਲਈ ਚੜ੍ਹਾਇਆ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","ਅਤੇ ਇਹ ਇਨ੍ਹਾਂ ਤੋਂ ਅਲੱਗ ਹੋਣ ਅਰਥਾਤ ਨਵੇਂ ਚੰਦਰਮਾ ਦੀ ਹੋਮ ਬਲੀ ਉਸ ਦੇ ਮੈਦੇ ਦੀ ਭੇਟ ਦੇ ਨਾਲ ਅਤੇ ਅਖੰਡ ਹੋਮ ਬਲੀ ਉਸ ਦੇ ਮੈਦੇ ਦੀ ਭੇਟ ਨਾਲ ਅਤੇ ਉਨ੍ਹਾਂ ਦੇ ਪੀਣ ਦੀਆਂ ਭੇਟਾਂ ਸਮੇਤ ਉਨ੍ਹਾਂ ਦੀ ਰੀਤ ਅਨੁਸਾਰ, ਇਹ ਯਹੋਵਾਹ ਲਈ ਸੁਗੰਧਤਾ ਦੀ ਅੱਗ ਦੀ ਭੇਟ ਹੋਵੇ। ");
INSERT INTO pan_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","ਇਸ ਸੱਤਵੇਂ ਮਹੀਨੇ ਦੇ ਦਸਵੇਂ ਦਿਨ ਤੁਹਾਡੀ ਪਵਿੱਤਰ ਸਭਾ ਹੋਵੇ ਜਿਸ ਦੇ ਵਿੱਚ ਤੁਸੀਂ ਆਪਣਿਆਂ ਜਾਨਾਂ ਨੂੰ ਦੀਨ ਕਰੋ, ਪਰ ਕੋਈ ਕੰਮ-ਧੰਦਾ ਨਾ ਕਰੋ। ");
INSERT INTO pan_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","ਤੁਸੀਂ ਯਹੋਵਾਹ ਲਈ ਸੁਗੰਧਤਾ ਦੀ ਹੋਮ ਬਲੀ ਚੜ੍ਹਾਓ ਅਰਥਾਤ ਇੱਕ ਮੇਂਢਾ, ਇੱਕ ਭੇਡੂ, ਸੱਤ ਇੱਕ ਸਾਲ ਦੇ ਭੇਡ ਦੇ ਬੱਚੇ। ਤੁਹਾਡੇ ਚੜ੍ਹਾਵੇ ਦੋਸ਼ ਰਹਿਤ ਹੋਣ ");
INSERT INTO pan_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","ਅਤੇ ਉਨ੍ਹਾਂ ਦੇ ਮੈਦੇ ਦੀ ਭੇਟ ਤੇਲ ਵਿੱਚ ਮਿਲਿਆ ਹੋਇਆ ਮੈਦਾ ਹੋਵੇ। ਵਹਿੜੇ ਲਈ ਤਿੰਨ ਦਸਵੰਧ, ਭੇਡੂ ਲਈ ਦੋ ਦਸਵੰਧ ");
INSERT INTO pan_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","ਅਤੇ ਉਨ੍ਹਾਂ ਸੱਤਾਂ ਭੇਡ ਦੇ ਬੱਚਿਆਂ ਵਿੱਚੋਂ ਹਰ ਇੱਕ ਭੇਡ ਦੇ ਬੱਚੇ ਲਈ ਇੱਕ ਦਸਵੰਧ ਹੋਵੇ। ");
INSERT INTO pan_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","ਅਤੇ ਪ੍ਰਾਸਚਿਤ ਲਈ ਪਾਪ ਬਲੀ ਅਤੇ ਹੋਮ ਦੀ ਬਲੀ ਅਤੇ ਉਸ ਦੇ ਮੈਦੇ ਦੀ ਅਤੇ ਉਨ੍ਹਾਂ ਦੇ ਪੀਣ ਦੀਆਂ ਭੇਟਾਂ ਤੋਂ ਅਲੱਗ ਇੱਕ ਬੱਕਰਾ ਪਾਪ ਬਲੀ ਲਈ ਚੜ੍ਹਾਇਆ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","ਸੱਤਵੇਂ ਮਹੀਨੇ ਦੇ ਪੰਦਰਵੇਂ ਦਿਨ ਤੁਹਾਡੀ ਪਵਿੱਤਰ ਸਭਾ ਹੋਵੇ ਜਿਸ ਦੇ ਵਿੱਚ ਤੁਸੀਂ ਕੋਈ ਕੰਮ-ਧੰਦਾ ਨਾ ਕਰੋ ਪਰ ਯਹੋਵਾਹ ਲਈ ਸੱਤਾਂ ਦਿਨਾਂ ਦਾ ਪਰਬ ਮਨਾਓ। ");
INSERT INTO pan_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","ਅਤੇ ਤੁਸੀਂ ਸੁਗੰਧਤਾ ਦੀ ਅੱਗ ਦੀ ਹੋਮ ਬਲੀ ਯਹੋਵਾਹ ਲਈ ਚੜ੍ਹਾਓ ਅਰਥਾਤ ਤੇਰ੍ਹਾਂ ਵਹਿੜੇ, ਦੋ ਭੇਡੂ, ਚੌਦਾਂ ਇੱਕ-ਇੱਕ ਸਾਲ ਦੇ ਭੇਡ ਦੇ ਬੱਚੇ ਜਿਹੜੇ ਦੋਸ਼ ਰਹਿਤ ਹੋਣ। ");
INSERT INTO pan_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","ਅਤੇ ਉਨ੍ਹਾਂ ਦੇ ਮੈਦੇ ਦੀ ਭੇਟ ਤੇਲ ਨਾਲ ਮਿਲੇ ਹੋਏ ਮੈਦੇ ਦੀ ਹੋਵੇ ਅਤੇ ਉਨ੍ਹਾਂ ਤੇਰ੍ਹਾਂ ਵਹਿੜਿਆਂ ਵਿੱਚੋਂ, ਹਰ ਵਹਿੜੇ ਲਈ ਤਿੰਨ ਦਸਵੰਧ ਅਤੇ ਉਨ੍ਹਾਂ ਦੋਹਾਂ ਭੇਡੂਆਂ ਵਿੱਚੋਂ ਹਰ ਭੇਡੂ ਲਈ ਦੋ ਦਸਵੰਧ ");
INSERT INTO pan_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","ਅਤੇ ਉਨ੍ਹਾਂ ਚੌਦਾਂ ਭੇਡ ਦੇ ਬੱਚਿਆਂ ਵਿੱਚੋਂ ਹਰ ਭੇਡ ਦੇ ਬੱਚੇ ਲਈ ਇੱਕ ਦਸਵੰਧ ");
INSERT INTO pan_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","ਅਤੇ ਹੋਮ ਬਲੀ ਅਤੇ ਉਸ ਦੇ ਮੈਦੇ ਅਤੇ ਪੀਣ ਦੀਆਂ ਭੇਟਾਂ ਤੋਂ ਛੁੱਟ ਇੱਕ ਬੱਕਰਾ ਪਾਪ ਬਲੀ ਲਈ ਚੜ੍ਹਾਇਆ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","ਦੂਜੇ ਦਿਨ ਬਾਰਾਂ ਵਹਿੜੇ, ਦੋ ਭੇਡੂ ਅਤੇ ਚੌਦਾਂ ਇੱਕ-ਇੱਕ ਸਾਲ ਦੇ ਭੇਡ ਦੇ ਬੱਚੇ ਦੋਸ਼ ਰਹਿਤ ਚੜ੍ਹਾਓ। ");
INSERT INTO pan_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","ਅਤੇ ਵਹਿੜਿਆਂ, ਭੇਡੂਆਂ ਅਤੇ ਲੇਲਿਆਂ ਦੇ ਲਈ ਉਨ੍ਹਾਂ ਦੀ ਗਿਣਤੀ ਅਤੇ ਰੀਤੀ ਅਨੁਸਾਰ ਹੋਣ। ");
INSERT INTO pan_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","ਅਤੇ ਹੋਮ ਬਲੀ ਅਤੇ ਉਸ ਦੇ ਮੈਦੇ ਅਤੇ ਉਨ੍ਹਾਂ ਦੇ ਪੀਣ ਦੀਆਂ ਭੇਟਾਂ ਤੋਂ ਅਲੱਗ ਇੱਕ ਬੱਕਰਾ ਪਾਪ ਬਲੀ ਲਈ ਚੜ੍ਹਾਇਆ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","ਤੀਜੇ ਦਿਨ ਗਿਆਰ੍ਹਾਂ ਵਹਿੜੇ, ਦੋ ਭੇਡੂ ਅਤੇ ਚੌਦਾਂ ਇੱਕ-ਇੱਕ ਸਾਲ ਦੇ ਭੇਡ ਦੇ ਬੱਚੇ ਦੋਸ਼ ਰਹਿਤ ਚੜ੍ਹਾਓ। ");
INSERT INTO pan_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","ਅਤੇ ਵਹਿੜਿਆਂ, ਭੇਡੂਆਂ ਅਤੇ ਭੇਡ ਦੇ ਬੱਚਿਆਂ ਲਈ ਉਨ੍ਹਾਂ ਦੇ ਮੈਦੇ ਦੀ ਅਤੇ ਪੀਣ ਦੀਆਂ ਭੇਟਾਂ ਉਨ੍ਹਾਂ ਦੀ ਗਿਣਤੀ ਅਤੇ ਰੀਤੀ ਅਨੁਸਾਰ ਹੋਣ। ");
INSERT INTO pan_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","ਅਤੇ ਹੋਮ ਬਲੀ ਅਤੇ ਉਸ ਦੇ ਮੈਦੇ ਅਤੇ ਪੀਣ ਦੀਆਂ ਭੇਟਾਂ ਤੋਂ ਅਲੱਗ ਇੱਕ ਬੱਕਰਾ ਪਾਪ ਬਲੀ ਦੀ ਭੇਟ ਲਈ ਚੜ੍ਹਾਇਆ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","ਚੌਥੇ ਦਿਨ ਦਸ ਵਹਿੜੇ, ਦੋ ਭੇਡੂ ਅਤੇ ਚੌਦਾਂ ਇੱਕ-ਇੱਕ ਸਾਲ ਦੇ ਭੇਡ ਦੇ ਬੱਚੇ ਦੋਸ਼ ਰਹਿਤ ਚੜ੍ਹਾਓ। ");
INSERT INTO pan_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","ਅਤੇ ਵਹਿੜਿਆਂ, ਭੇਡੂਆਂ ਅਤੇ ਭੇਡ ਦੇ ਬੱਚਿਆਂ ਲਈ ਉਨ੍ਹਾਂ ਦੇ ਮੈਦੇ ਦੀ ਅਤੇ ਪੀਣ ਦੀਆਂ ਭੇਟਾਂ ਉਨ੍ਹਾਂ ਦੀ ਗਿਣਤੀ ਅਤੇ ਰੀਤੀ ਅਨੁਸਾਰ ਹੋਣ। ");
INSERT INTO pan_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","ਅਤੇ ਹੋਮ ਬਲੀ ਅਤੇ ਉਸ ਦੇ ਮੈਦੇ ਅਤੇ ਪੀਣ ਦੀਆਂ ਭੇਟਾਂ ਤੋਂ ਅਲੱਗ ਇੱਕ ਬੱਕਰਾ ਪਾਪ ਬਲੀ ਲਈ ਚੜ੍ਹਾਇਆ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","ਪੰਜਵੇਂ ਦਿਨ ਨੌ ਵਹਿੜੇ, ਦੋ ਭੇਡੂ, ਚੌਦਾਂ ਇੱਕ-ਇੱਕ ਸਾਲ ਦੇ ਭੇਡ ਦੇ ਬੱਚੇ ਦੋਸ਼ ਰਹਿਤ ਚੜ੍ਹਾਓ। ");
INSERT INTO pan_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","ਅਤੇ ਵਹਿੜਿਆਂ, ਭੇਡੂਆਂ ਅਤੇ ਭੇਡ ਦੇ ਬੱਚਿਆਂ ਲਈ ਉਨ੍ਹਾਂ ਦੇ ਮੈਦੇ ਦੀ ਅਤੇ ਪੀਣ ਦੀਆਂ ਭੇਟਾਂ ਉਨ੍ਹਾਂ ਦੀ ਗਿਣਤੀ ਅਤੇ ਰੀਤੀ ਅਨੁਸਾਰ ਹੋਣ। ");
INSERT INTO pan_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","ਅਤੇ ਹੋਮ ਬਲੀ ਅਤੇ ਉਸ ਦੇ ਮੈਦੇ ਅਤੇ ਪੀਣ ਦੀਆਂ ਭੇਟਾਂ ਤੋਂ ਅਲੱਗ ਇੱਕ ਬੱਕਰਾ ਪਾਪ ਬਲੀ ਲਈ ਚੜ੍ਹਾਇਆ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","ਛੇਵੇਂ ਦਿਨ ਅੱਠ ਵਹਿੜੇ, ਦੋ ਭੇਡੂ, ਚੌਦਾਂ ਇੱਕ ਸਾਲ ਭੇਡ ਦੇ ਬੱਚੇ ਦੋਸ਼ ਰਹਿਤ ਚੜ੍ਹਾਓ। ");
INSERT INTO pan_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","ਵਹਿੜਿਆਂ, ਭੇਡੂਆਂ ਅਤੇ ਭੇਡ ਦੇ ਬੱਚਿਆਂ ਲਈ ਉਨ੍ਹਾਂ ਦੇ ਮੈਦੇ ਦੀ ਅਤੇ ਪੀਣ ਦੀਆਂ ਭੇਟਾਂ ਉਨ੍ਹਾਂ ਦੀ ਗਿਣਤੀ ਅਤੇ ਰੀਤੀ ਅਨੁਸਾਰ ਹੋਣ। ");
INSERT INTO pan_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","ਅਤੇ ਹੋਮ ਬਲੀ ਅਤੇ ਉਸ ਦੇ ਮੈਦੇ ਅਤੇ ਪੀਣ ਦੀਆਂ ਭੇਟਾਂ ਤੋਂ ਛੁੱਟ ਇੱਕ ਬੱਕਰਾ ਪਾਪ ਬਲੀ ਲਈ ਚੜ੍ਹਾਇਆ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","ਸੱਤਵੇਂ ਦਿਨ ਸੱਤ ਵਹਿੜੇ, ਦੋ ਭੇਡੂ, ਚੌਦਾਂ ਇੱਕ-ਇੱਕ ਸਾਲ ਦੇ ਭੇਡ ਦੇ ਬੱਚੇ ਦੋਸ਼ ਰਹਿਤ ਚੜ੍ਹਾਓ। ");
INSERT INTO pan_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","ਅਤੇ ਵਹਿੜਿਆਂ, ਭੇਡੂਆਂ ਅਤੇ ਭੇਡ ਦੇ ਬੱਚਿਆਂ ਲਈ ਉਨ੍ਹਾਂ ਦੇ ਮੈਦੇ ਦੀ ਅਤੇ ਪੀਣ ਦੀਆਂ ਭੇਟਾਂ ਉਨ੍ਹਾਂ ਦੀ ਗਿਣਤੀ ਅਤੇ ਰੀਤੀ ਅਨੁਸਾਰ ਹੋਣ। ");
INSERT INTO pan_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","ਅਤੇ ਹੋਮ ਬਲੀ ਅਤੇ ਉਸ ਦੇ ਮੈਦੇ ਦੀ ਅਤੇ ਪੀਣ ਦੀਆਂ ਭੇਟਾਂ ਤੋਂ ਛੁੱਟ ਇੱਕ ਬੱਕਰਾ ਪਾਪ ਬਲੀ ਲਈ ਚੜ੍ਹਾਇਆ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","ਅੱਠਵੇਂ ਦਿਨ ਤੁਹਾਡੀ ਮਹਾਂ ਸਭਾ ਹੋਵੇ ਜਿਸ ਦੇ ਵਿੱਚ ਤੁਸੀਂ ਕੋਈ ਕੰਮ-ਧੰਦਾ ਨਾ ਕਰਿਓ। ");
INSERT INTO pan_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","ਪਰ ਤੁਸੀਂ ਯਹੋਵਾਹ ਲਈ ਸੁਗੰਧਤਾ ਦੀ ਅੱਗ ਦੀ ਹੋਮ ਬਲੀ ਚੜ੍ਹਾਓ ਅਰਥਾਤ ਇੱਕ ਮੇਂਢਾ, ਇੱਕ ਭੇਡੂ ਅਤੇ ਸੱਤ ਇੱਕ-ਇੱਕ ਸਾਲ ਦੇ ਭੇਡ ਦੇ ਬੱਚੇ ਦੋਸ਼ ਰਹਿਤ। ");
INSERT INTO pan_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","ਵਹਿੜਿਆਂ, ਭੇਡੂਆਂ ਅਤੇ ਭੇਡ ਦੇ ਬੱਚਿਆਂ ਲਈ ਉਨ੍ਹਾਂ ਦੀ ਗਿਣਤੀ ਅਤੇ ਰੀਤੀ ਅਨੁਸਾਰ ਹੋਣ। ");
INSERT INTO pan_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","ਅਤੇ ਹੋਮ ਬਲੀ ਅਤੇ ਉਸ ਮੈਦੇ ਅਤੇ ਪੀਣ ਦੀਆਂ ਭੇਟਾਂ ਤੋਂ ਅਲੱਗ ਇੱਕ ਬੱਕਰਾ ਪਾਪ ਬਲੀ ਲਈ ਚੜ੍ਹਾਇਆ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","ਇਹ ਤੁਸੀਂ ਯਹੋਵਾਹ ਲਈ ਆਪਣੇ ਠਹਿਰਾਏ ਹੋਏ ਪਰਬਾਂ ਵਿੱਚ ਆਪਣੀਆਂ ਸੁੱਖਣਾਂ ਅਤੇ ਖੁਸ਼ੀ ਦੀਆਂ ਭੇਟਾਂ ਤੋਂ ਅਲੱਗ ਚੜ੍ਹਾਓ। ਇਹ ਤੁਹਾਡੇ ਹੋਮ ਦੀਆਂ ਬਲੀਆਂ ਅਤੇ ਤੁਹਾਡੇ ਮੈਦੇ ਦੀਆਂ ਭੇਟਾਂ ਅਤੇ ਤੁਹਾਡੇ ਸੁੱਖ-ਸਾਂਦ ਦੀਆਂ ਭੇਟਾਂ ਲਈ ਹੋਣ। ");
INSERT INTO pan_vpl VALUES ("NU29_40","005_29_40","NUM","29","40","40","ਜੋ ਕੁਝ ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਹੁਕਮ ਦਿੱਤਾ ਸੀ ਉਹੋ ਉਸ ਨੇ ਇਸਰਾਏਲੀਆਂ ਨੂੰ ਆਖਿਆ। ");
INSERT INTO pan_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","ਮੂਸਾ ਇਸਰਾਏਲੀਆਂ ਦੇ ਗੋਤਾਂ ਦੇ ਮੁਖੀਆਂ ਨੂੰ ਬੋਲਿਆ ਕਿ ਇਹ ਹੁਕਮ ਹੈ ਜਿਹੜਾ ਯਹੋਵਾਹ ਨੇ ਦਿੱਤਾ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","ਜਦ ਕੋਈ ਮਨੁੱਖ ਯਹੋਵਾਹ ਲਈ ਸੁੱਖਣਾ ਸੁੱਖੇ ਜਾਂ ਸਹੁੰ ਖਾਵੇ ਅਤੇ ਆਪਣੇ ਜੀਵਨ ਨੂੰ ਉਸ ਗੱਲ ਉੱਤੇ ਬੰਨ੍ਹ ਲਵੇ ਤਾਂ ਉਹ ਆਪਣਾ ਬਚਨ ਨਾ ਤੋੜੇ ਪਰ ਜੋ ਕੁਝ ਉਸ ਦੇ ਮੂੰਹ ਤੋਂ ਨਿੱਕਲਦਾ ਹੈ ਉਹ ਉਸ ਨੂੰ ਪੂਰਾ ਕਰੇ। ");
INSERT INTO pan_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","ਜੇ ਕੋਈ ਕੁੜੀ ਯਹੋਵਾਹ ਲਈ ਸੁੱਖਣਾ ਸੁੱਖੇ ਅਤੇ ਆਪਣੇ ਆਪ ਨੂੰ ਉਸ ਗੱਲ ਉੱਤੇ ਬੰਨ੍ਹੇ ਜਦ ਉਹ ਆਪਣੇ ਪਿਤਾ ਦੇ ਘਰ ਵਿੱਚ ਕੁਆਰੀ ਹੋਵੇ। ");
INSERT INTO pan_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","ਅਤੇ ਉਸ ਦਾ ਪਿਤਾ ਉਸ ਦੀ ਸੁੱਖਣਾ ਅਤੇ ਉਸ ਦੇ ਬੰਨ੍ਹਣ ਨੂੰ ਜਿਸ ਦੇ ਨਾਲ ਉਸ ਨੇ ਆਪਣੇ ਜੀਵਨ ਨੂੰ ਬੰਨ੍ਹਿਆ, ਸੁਣੇ ਅਤੇ ਉਸ ਦਾ ਪਿਤਾ ਚੁੱਪ ਕਰ ਰਹੇ ਤਾਂ ਉਸ ਦੀਆਂ ਸਾਰੀਆਂ ਸੁੱਖਣਾ ਪੱਕੀਆਂ ਰਹਿਣ ਅਤੇ ਸਾਰੇ ਬਚਨ ਜਿਸ ਦੇ ਨਾਲ ਆਪਣੇ ਜੀਵਨ ਨੂੰ ਬੰਨ੍ਹਿਆ ਪੱਕੇ ਰਹਿਣ। ");
INSERT INTO pan_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","ਪਰ ਜੇ ਉਸ ਦਾ ਪਿਤਾ ਸੁਣ ਕੇ ਉਸੇ ਦਿਨ ਉਸ ਨੂੰ ਝਿੜਕੇ ਤਾਂ ਉਸ ਦੀਆਂ ਸਾਰੀਆਂ ਸੁੱਖਣਾ ਅਤੇ ਉਸ ਦੀ ਕੁੜੀ ਜਿਨ੍ਹਾਂ ਨਾਲ ਉਸ ਨੇ ਆਪਣੇ ਜੀਵਨ ਨੂੰ ਬੰਨ੍ਹਿਆ ਪੱਕੇ ਨਾ ਰਹਿਣ ਅਤੇ ਯਹੋਵਾਹ ਉਸ ਨੂੰ ਮਾਫ਼ੀ ਦੇਵੇਗਾ ਕਿਉਂ ਜੋ ਉਸ ਦੇ ਪਿਤਾ ਨੇ ਉਸ ਨੂੰ ਝਿੜਕਿਆ। ");
INSERT INTO pan_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","ਅਤੇ ਜੇ ਉਹ ਮਨੁੱਖ ਨਾਲ ਵਿਆਹੀ ਹੋਈ ਹੋਵੇ ਅਤੇ ਉਸ ਦੀਆਂ ਸੁੱਖਣਾ ਉਸ ਉੱਤੇ ਹੋਣ ਜਾਂ ਉਸ ਨੇ ਆਪਣੇ ਮੂੰਹ ਤੋਂ ਬਿਨ੍ਹਾਂ ਸੋਚੇ ਸਮਝੇ ਅਜਿਹੀ ਗੱਲ ਆਖੀ ਹੋਵੇ ਜਿਸ ਤੋਂ ਉਸ ਦਾ ਜੀਵਨ ਬੰਨ੍ਹਿਆ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","ਅਤੇ ਉਸ ਦਾ ਪਤੀ ਸੁਣੇ ਪਰ ਜਿਸ ਦਿਨ ਉਹ ਸੁਣੇ ਚੁੱਪ ਰਹੇ ਤਾਂ ਉਸ ਦੀਆਂ ਸੁੱਖਣਾ ਪੱਕੀਆਂ ਰਹਿਣ ਅਤੇ ਉਸ ਸਹੁੰ ਜਿਨ੍ਹਾਂ ਦੇ ਨਾਲ ਉਸ ਆਪਣੇ ਜੀਵਨ ਨੂੰ ਬੰਨ੍ਹਿਆ ਪੱਕੇ ਰਹਿਣ। ");
INSERT INTO pan_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","ਪਰ ਜੇ ਸੁਣਨ ਵਾਲੇ ਦਿਨ ਉਸ ਦਾ ਪਤੀ ਉਸ ਨੂੰ ਝਿੜਕੇ ਤਾਂ ਉਸ ਦੀ ਸੁੱਖਣਾ ਜਿਹੜੀ ਉਸ ਦੇ ਉੱਤੇ ਹੈ ਅਤੇ ਉਸ ਦੇ ਮੂੰਹ ਤੋਂ ਬਿਨ੍ਹਾਂ ਸੋਚੇ ਸਮਝੇ ਨਿੱਕਲੀ ਹੋਈ ਸੀ ਜਿਸ ਦੇ ਨਾਲ ਉਸ ਨੇ ਆਪਣੇ ਜੀਵਨ ਨੂੰ ਬੰਨ੍ਹਿਆ, ਟੁੱਟ ਜਾਵੇ ਅਤੇ ਯਹੋਵਾਹ ਉਸ ਨੂੰ ਮਾਫ਼ੀ ਦੇਵੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","ਪਰ ਵਿਧਵਾ ਜਾਂ ਤਿਆਗੀ ਹੋਈ ਦੀ ਸੁੱਖਣਾ ਜਿਸ ਨਾਲ ਉਸ ਆਪਣੇ ਜੀਵਨ ਨੂੰ ਬੰਨ੍ਹਿਆ ਹੈ ਉਸ ਉੱਤੇ ਪੱਕੀ ਰਹੇ ");
INSERT INTO pan_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","ਜੇ ਉਸ ਨੇ ਆਪਣੇ ਪਤੀ ਦੇ ਘਰ ਵਿੱਚ ਸੁੱਖਣਾ ਸੁੱਖੀ ਜਾਂ ਸਹੁੰ ਨਾਲ ਆਪਣੇ ਜੀਵਨ ਉੱਤੇ ਕੋਈ ਬੰਨ੍ਹਣ ਬੰਨ੍ਹਿਆ। ");
INSERT INTO pan_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","ਅਤੇ ਉਸ ਦੇ ਮਨੁੱਖ ਨੇ ਸੁਣਿਆ ਅਤੇ ਚੁੱਪ ਰਹਿ ਕੇ ਉਸ ਨੂੰ ਨਾ ਝਿੜਕਿਆ ਤਾਂ ਉਸ ਦੀਆਂ ਸਾਰੀਆਂ ਸੁੱਖਣਾ ਪੱਕੀਆਂ ਰਹਿਣ ਅਤੇ ਹਰ ਬੰਨ੍ਹਣ ਜਿਸ ਦੇ ਨਾਲ ਉਸ ਆਪਣੇ ਜੀਵਨ ਨੂੰ ਬੰਨ੍ਹਿਆ ਪੱਕਾ ਰਹੇ। ");
INSERT INTO pan_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","ਪਰ ਜੇ ਉਸ ਦੇ ਪਤੀ ਨੇ ਸੁਣਦੇ ਹੀ ਉਨ੍ਹਾਂ ਨੂੰ ਤੋੜ ਦਿੱਤਾ ਹੋਵੇ ਤਦ ਜੋ ਕੁਝ ਉਸ ਦੇ ਮੂੰਹ ਤੋਂ ਉਸ ਦੀਆਂ ਸੁੱਖਣਾ ਦੇ ਵਿਖੇ ਜਾਂ ਜੀਵਨ ਦੇ ਬੰਨ੍ਹਣ ਦੇ ਵਿਖੇ ਨਿੱਕਲਿਆ ਹੋਵੇ ਉਹ ਪੱਕਾ ਨਾ ਰਹੇ ਕਿਉਂ ਜੋ ਉਸ ਦੇ ਪਤੀ ਨੇ ਉਨ੍ਹਾਂ ਨੂੰ ਤੋੜ ਦਿੱਤਾ ਅਤੇ ਯਹੋਵਾਹ ਉਸ ਨੂੰ ਮਾਫ਼ੀ ਦੇਵੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","ਹਰ ਸੁੱਖਣਾ ਅਤੇ ਹਰ ਸਹੁੰ ਜਿਸ ਦੇ ਨਾਲ ਉਸ ਨੇ ਆਪਣੇ ਜੀਵਨ ਨੂੰ ਦੁੱਖ ਦੇਣ ਲਈ ਬੰਨ੍ਹਿਆ ਹੋਵੇ ਉਸ ਦਾ ਪਤੀ ਉਸ ਨੂੰ ਪੱਕਾ ਰੱਖੇ ਜਾਂ ਉਸ ਦਾ ਪਤੀ ਉਸ ਨੂੰ ਤੋੜ ਦੇਵੇ। ");
INSERT INTO pan_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","ਪਰ ਜੇ ਉਸ ਦਾ ਪਤੀ ਨਿੱਤ ਚੁੱਪ ਰਹੇ ਤਾਂ ਉਹ ਉਸ ਦੀਆਂ ਸਾਰੀਆਂ ਸੁੱਖਣਾ ਪੱਕੀਆਂ ਠਹਿਰਾਉਂਦਾ ਹੈ ਜਾਂ ਉਸ ਦੇ ਸਾਰੇ ਸਹੁੰ ਜਿਹੜੇ ਉਸ ਉੱਤੇ ਹੋਣ ਪੱਕੇ ਠਹਿਰਾਉਂਦਾ ਹੈ ਕਿਉਂ ਜੋ ਜਿਸ ਦਿਨ ਉਹ ਨੇ ਸੁਣਿਆ ਸੀ, ਉਹ ਚੁੱਪ ਰਿਹਾ। ");
INSERT INTO pan_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","ਪਰ ਜੇ ਉਹ ਨੇ ਉਨ੍ਹਾਂ ਦੇ ਸੁਣਨ ਦੇ ਮਗਰੋਂ ਉਨ੍ਹਾਂ ਨੂੰ ਤੋੜ ਦਿੱਤਾ ਹੋਵੇ ਤਾਂ ਉਹ ਉਸ ਦੀ ਬੁਰਿਆਈ ਦੀ ਸਜ਼ਾ ਚੁੱਕੇ। ");
INSERT INTO pan_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","ਇਹ ਉਹ ਬਿਧੀਆਂ ਹਨ ਜਿਨ੍ਹਾਂ ਦਾ ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਹੁਕਮ ਦਿੱਤਾ ਸੀ ਪਤੀ ਅਤੇ ਪਤਨੀ ਵਿਖੇ, ਪਿਤਾ ਅਤੇ ਧੀ ਵਿਖੇ, ਜਦ ਜੁਆਨੀ ਦੇ ਸਮੇਂ ਆਪਣੇ ਪਿਤਾ ਦੇ ਘਰ ਵਿੱਚ ਹੋਵੇ। ");
INSERT INTO pan_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਬੋਲਿਆ ਕਿ ");
INSERT INTO pan_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","ਇਸਰਾਏਲੀਆਂ ਦਾ ਮਿਦਯਾਨੀਆਂ ਤੋਂ ਬਦਲਾ ਲੈ, ਫਿਰ ਤੂੰ ਆਪਣੇ ਲੋਕਾਂ ਵਿੱਚ ਜਾ ਮਿਲੇਂਗਾ। ");
INSERT INTO pan_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","ਤਦ ਮੂਸਾ ਨੇ ਪਰਜਾ ਨੂੰ ਆਖਿਆ ਕਿ ਆਪਣੇ ਵਿੱਚੋਂ ਮਨੁੱਖਾਂ ਨੂੰ ਸ਼ਸਤਰ ਧਾਰੀ ਬਣਾਓ ਤਾਂ ਜੋ ਉਹ ਮਿਦਯਾਨ ਦੇ ਵਿਰੁੱਧ ਲੜਨ ਅਤੇ ਯਹੋਵਾਹ ਦਾ ਬਦਲਾ ਮਿਦਯਾਨੀਆਂ ਤੋਂ ਲੈਣ। ");
INSERT INTO pan_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","ਇਸਰਾਏਲੀਆਂ ਦਿਆਂ ਸਾਰਿਆਂ ਗੋਤਾਂ ਵਿੱਚੋਂ ਤੁਸੀਂ ਇੱਕ-ਇੱਕ ਹਜ਼ਾਰ ਆਦਮੀ ਯੁੱਧ ਕਰਨ ਲਈ ਭੇਜੋ। ");
INSERT INTO pan_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","ਤਦ ਇਸਰਾਏਲ ਦੇ ਹਜ਼ਾਰਾਂ ਵਿੱਚੋਂ ਹਰ ਗੋਤ ਤੋਂ ਇੱਕ ਹਜ਼ਾਰ ਆਦਮੀ ਚੁਣੇ ਗਏ ਅਰਥਾਤ ਯੁੱਧ ਲਈ ਬਾਰਾਂ ਹਜ਼ਾਰ ਸ਼ਸਤਰ ਧਾਰੀ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","ਉਪਰੰਤ ਮੂਸਾ ਨੇ ਗੋਤਾਂ ਦੇ ਅਨੁਸਾਰ ਇੱਕ-ਇੱਕ ਹਜ਼ਾਰ ਆਦਮੀਆਂ ਨੂੰ ਅਤੇ ਅਲਆਜ਼ਾਰ ਜਾਜਕ ਦੇ ਪੁੱਤਰ ਫ਼ੀਨਹਾਸ ਨੂੰ ਯੁੱਧ ਕਰਨ ਲਈ ਭੇਜਿਆ ਅਤੇ ਪਵਿੱਤਰ ਸਥਾਨ ਦੇ ਭਾਂਡੇ ਅਤੇ ਚੌਕਸ ਕਰਨ ਵਾਲੀਆਂ ਤੁਰ੍ਹੀਆਂ ਉਸ ਦੇ ਹੱਥ ਵਿੱਚ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","ਸੋ ਉਹ ਮਿਦਯਾਨੀਆਂ ਨਾਲ ਲੜੇ ਜਿਵੇਂ ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਹੁਕਮ ਦਿੱਤਾ ਸੀ ਅਤੇ ਉਨ੍ਹਾਂ ਨੇ ਸਾਰੇ ਆਦਮੀਆਂ ਨੂੰ ਮਾਰ ਦਿੱਤਾ। ");
INSERT INTO pan_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","ਅਤੇ ਉਨ੍ਹਾਂ ਨੇ ਮਿਦਯਾਨ ਦੇ ਰਾਜਿਆਂ ਨੂੰ ਉਹਨਾਂ ਮਾਰਿਆ ਹੋਇਆਂ ਦੇ ਨਾਲ ਹੀ ਮਾਰ ਦਿੱਤਾ ਅਰਥਾਤ ਅੱਵੀ, ਰਕਮ, ਸੂਰ, ਹੂਰ ਅਤੇ ਰਬਾ ਇਨ੍ਹਾਂ ਮਿਦਯਾਨ ਦੇ ਪੰਜਾਂ ਰਾਜਿਆਂ ਨੂੰ ਅਤੇ ਬਓਰ ਦੇ ਪੁੱਤਰ ਬਿਲਆਮ ਨੂੰ ਤਲਵਾਰ ਨਾਲ ਮਾਰ ਦਿੱਤਾ। ");
INSERT INTO pan_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","ਅਤੇ ਇਸਰਾਏਲੀਆਂ ਨੇ ਮਿਦਯਾਨ ਦੀਆਂ ਔਰਤਾਂ ਨੂੰ ਅਤੇ ਉਨ੍ਹਾਂ ਦੇ ਬੱਚਿਆਂ ਨੂੰ ਗੁਲਾਮ ਬਣਾ ਲਿਆ ਅਤੇ ਉਨ੍ਹਾਂ ਦੇ ਸਾਰੇ ਡੰਗਰ, ਸਾਰੇ ਝੁੰਡ ਅਤੇ ਉਨ੍ਹਾਂ ਦਾ ਸਾਰਾ ਕੁਝ ਲੁੱਟ ਲਿਆ। ");
INSERT INTO pan_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","ਅਤੇ ਉਨ੍ਹਾਂ ਦੇ ਸਾਰੇ ਸ਼ਹਿਰਾਂ ਨੂੰ ਅਤੇ ਸਾਰੀਆਂ ਛਾਉਣੀਆਂ ਨੂੰ, ਜਿਨ੍ਹਾਂ ਵਿੱਚ ਉਹ ਵੱਸਦੇ ਸਨ, ਅੱਗ ਨਾਲ ਫੂਕ ਦਿੱਤਾ। ");
INSERT INTO pan_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","ਅਤੇ ਉਨ੍ਹਾਂ ਨੇ ਲੁੱਟ ਦਾ ਸਾਰਾ ਮਾਲ ਅਤੇ ਸਾਰੇ ਗੁਲਾਮ ਕੀ ਮਨੁੱਖ, ਕੀ ਡੰਗਰ ਸਭ ਕੁਝ ਲੈ ਲਏ। ");
INSERT INTO pan_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","ਅਤੇ ਉਹ ਮੂਸਾ, ਅਲਆਜ਼ਾਰ ਜਾਜਕ, ਇਸਰਾਏਲੀਆਂ ਦੀ ਮੰਡਲੀ ਕੋਲ ਗੁਲਾਮਾਂ ਨੂੰ, ਮਾਲ ਡੰਗਰ ਨੂੰ ਅਤੇ ਲੁੱਟ ਨੂੰ ਡੇਰੇ ਵਿੱਚ ਮੋਆਬ ਦੇ ਮੈਦਾਨ ਵਿੱਚ ਜਿਹੜਾ ਯਰਦਨ ਉੱਤੇ ਯਰੀਹੋ ਕੋਲ ਹੈ, ਲੈ ਆਏ। ");
INSERT INTO pan_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","ਤਦ ਮੂਸਾ, ਅਲਆਜ਼ਾਰ ਜਾਜਕ ਅਤੇ ਮੰਡਲੀ ਦੇ ਸਾਰੇ ਪ੍ਰਧਾਨ ਡੇਰੇ ਤੋਂ ਬਾਹਰ ਉਹਨਾਂ ਨੂੰ ਮਿਲਣ ਲਈ ਗਏ। ");
INSERT INTO pan_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","ਪਰ ਮੂਸਾ ਦਲ ਦੇ ਸੈਨਾਪਤੀਆਂ ਨਾਲ ਅਰਥਾਤ ਹਜ਼ਾਰਾਂ ਦੇ ਹਾਕਮਾਂ ਨਾਲ ਅਤੇ ਸੈਂਕੜਿਆਂ ਦੇ ਹਾਕਮਾਂ ਨਾਲ ਜਿਹੜੇ ਯੁੱਧ ਕਰਕੇ ਮੁੜ੍ਹ ਆਏ, ਕ੍ਰੋਧਵਾਨ ਹੋਇਆ। ");
INSERT INTO pan_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","ਅਤੇ ਮੂਸਾ ਨੇ ਉਨ੍ਹਾਂ ਨੂੰ ਆਖਿਆ, ਕੀ ਤੁਸੀਂ ਸਾਰੀਆਂ ਇਸਤਰੀਆਂ ਨੂੰ ਜੀਉਂਦਾ ਛੱਡ ਦਿੱਤਾ ਹੈ? ");
INSERT INTO pan_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","ਵੇਖੋ, ਇਹ ਉਹ ਹਨ ਜਿਨ੍ਹਾਂ ਨੇ ਇਸਰਾਏਲੀਆਂ ਨੂੰ ਬਿਲਆਮ ਦੀ ਸਹਿਮਤੀ ਨਾਲ, ਪਓਰ ਦੀ ਗੱਲ ਵਿੱਚ ਯਹੋਵਾਹ ਦੇ ਵਿਰੁੱਧ ਅਪਰਾਧੀ ਬਣਾਇਆ ਤਦ ਬਵਾ ਯਹੋਵਾਹ ਦੀ ਮੰਡਲੀ ਵਿੱਚ ਫੈਲੀ। ");
INSERT INTO pan_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","ਇਸ ਲਈ ਹੁਣ ਬੱਚਿਆਂ ਵਿੱਚੋਂ ਹਰੇਕ ਨਰ ਬੱਚੇ ਨੂੰ ਮਾਰ ਦਿਓ ਅਤੇ ਜਿਹਨਾਂ ਔਰਤਾਂ ਨੇ ਮਨੁੱਖ ਨਾਲ ਸੰਗ ਕੀਤਾ ਹੋਵੇ ਉਹਨਾਂ ਨੂੰ ਵੀ ਮਾਰ ਦਿਓ। ");
INSERT INTO pan_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","ਪਰ ਜਿਹਨਾਂ ਕੁਆਰੀਆਂ ਨੇ ਕਿਸੇ ਮਨੁੱਖ ਨਾਲ ਸੰਗ ਨਹੀਂ ਕੀਤਾ, ਉਹਨਾਂ ਨੂੰ ਤੁਸੀਂ ਆਪਣੇ ਲਈ ਜੀਉਂਦਾ ਰੱਖੋ। ");
INSERT INTO pan_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","ਪਰ ਤੁਸੀਂ ਡੇਰੇ ਤੋਂ ਸੱਤ ਦਿਨ ਬਾਹਰ ਰਹੋ, ਉਹ ਸਾਰੇ ਜਿਨ੍ਹਾਂ ਨੇ ਕਿਸੇ ਪ੍ਰਾਣੀ ਨੂੰ ਮਾਰਿਆ ਹੋਵੇ ਅਤੇ ਜਿਨ੍ਹਾਂ ਨੇ ਕਿਸੇ ਮਰੇ ਹੋਏ ਨੂੰ ਛੂਹਿਆ ਹੋਵੇ, ਉਹ ਸਾਰੇ ਆਪਣੇ ਆਪ ਨੂੰ ਆਪਣੇ ਗੁਲਾਮਾਂ ਸਮੇਤ ਤੀਜੇ ਦਿਨ ਅਤੇ ਸੱਤਵੇਂ ਦਿਨ ਪਵਿੱਤਰ ਕਰਨ। ");
INSERT INTO pan_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","ਤੁਸੀਂ ਚਮੜੇ ਅਤੇ ਬੱਕਰੀ ਦੇ ਵਾਲਾਂ ਦੇ ਸਾਰੇ ਬਸਤਰ ਅਤੇ ਸਾਰੇ ਲੱਕੜੀ ਦੇ ਭਾਂਡਿਆਂ ਨੂੰ ਪਵਿੱਤਰ ਕਰੋ। ");
INSERT INTO pan_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","ਤਦ ਅਲਆਜ਼ਾਰ ਜਾਜਕ ਨੇ ਉਨ੍ਹਾਂ ਸੂਰਮਿਆਂ ਨੂੰ ਆਖਿਆ, ਜਿਹੜੇ ਯੁੱਧ ਵਿੱਚ ਗਏ ਸਨ ਕਿ ਇਹ ਬਿਵਸਥਾ ਦੀ ਬਿਧੀ ਹੈ ਜਿਸ ਦਾ ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਹੁਕਮ ਦਿੱਤਾ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","22","ਸੋਨਾ, ਚਾਂਦੀ, ਪਿੱਤਲ, ਲੋਹਾ, ਜਿਸਤ ਅਤੇ ਸਿੱਕਾ। ");
INSERT INTO pan_vpl VALUES ("NU31_23","005_31_23","NUM","31","23","23","ਅਰਥਾਤ ਹਰ ਇੱਕ ਚੀਜ਼, ਜਿਹੜੀ ਅੱਗ ਵਿੱਚ ਪੈ ਸਕੇ ਉਸ ਨੂੰ ਤੁਸੀਂ ਅੱਗ ਦੇ ਵਿੱਚ ਦੀ ਲੰਘਾਓ, ਤਾਂ ਉਹ ਸ਼ੁੱਧ ਹੋਵੇਗੀ ਪਰ ਫਿਰ ਵੀ ਉਹ ਅਸ਼ੁੱਧਤਾਈ ਨੂੰ ਦੂਰ ਕਰਨ ਵਾਲੇ ਜਲ ਨਾਲ ਪਵਿੱਤਰ ਕੀਤੀ ਜਾਵੇ ਅਤੇ ਜੋ ਕੁਝ ਅੱਗ ਵਿੱਚ ਨਾ ਪੈ ਸਕੇ ਤੁਸੀਂ ਉਸ ਨੂੰ ਪਾਣੀ ਦੇ ਵਿੱਚ ਦੀ ਲੰਘਾਓ। ");
INSERT INTO pan_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","ਸੱਤਵੇਂ ਦਿਨ ਤੁਸੀਂ ਆਪਣੇ ਕੱਪੜੇ ਧੋਵੋ ਤਾਂ ਤੁਸੀਂ ਸ਼ੁੱਧ ਹੋਵੋਗੇ, ਇਸ ਦੇ ਬਾਅਦ ਤੁਸੀਂ ਡੇਰੇ ਵਿੱਚ ਆਓ। ");
INSERT INTO pan_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","ਫੇਰ ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਆਖਿਆ, ");
INSERT INTO pan_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","ਅਲਆਜ਼ਾਰ ਜਾਜਕ ਅਤੇ ਮੰਡਲੀ ਦੇ ਪੁਰਖਿਆਂ ਦੇ ਘਰਾਣਿਆਂ ਦੇ ਮੁਖੀਆਂ ਨੂੰ ਤੂੰ ਆਪਣੇ ਨਾਲ ਲੈ ਕੇ, ਲੁੱਟ ਦੇ ਮਾਲ ਦਾ ਆਦਮੀਆਂ ਅਤੇ ਡੰਗਰਾਂ ਸਮੇਤ, ਲੇਖਾ ਕਰ। ");
INSERT INTO pan_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","ਤੂੰ ਲੁੱਟ ਨੂੰ ਦੋ ਹਿੱਸਿਆਂ ਵਿੱਚ ਅਰਥਾਤ ਸੂਰਮਿਆਂ ਦੇ ਹਿੱਸੇ ਵਿੱਚ ਜਿਹੜੇ ਲੜਾਈ ਵਿੱਚ ਗਏ ਅਤੇ ਮੰਡਲੀ ਦੇ ਹਿੱਸੇ ਵਿੱਚ ਵੰਡ। ");
INSERT INTO pan_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","ਅਤੇ ਤੂੰ ਉਨ੍ਹਾਂ ਸੂਰਮਿਆਂ ਤੋਂ ਜਿਹੜੇ ਲੜਾਈ ਵਿੱਚ ਗਏ, ਯਹੋਵਾਹ ਲਈ ਲਗਾਨ ਲਈਂ ਅਰਥਾਤ ਪੰਜ ਸੌ ਵਿੱਚੋਂ ਇੱਕ ਜਾਨ ਭਾਵੇਂ ਉਹ ਆਦਮੀਆਂ ਦੀ, ਭਾਵੇਂ ਵੱਗ ਦੀ, ਭਾਵੇਂ ਗਧਿਆਂ ਦੀ, ਭਾਵੇਂ ਇੱਜੜਾਂ ਦੀ ਹੋਵੇ। ");
INSERT INTO pan_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","ਉਨ੍ਹਾਂ ਦੀ ਅੱਧ ਵਿੱਚੋਂ ਲੈ ਕੇ ਅਲਆਜ਼ਾਰ ਜਾਜਕ ਨੂੰ ਯਹੋਵਾਹ ਦੀ ਚੁੱਕਣ ਦੀ ਭੇਟ ਕਰਕੇ ਦੇਵੀਂ। ");
INSERT INTO pan_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","ਅਤੇ ਇਸਰਾਏਲੀਆਂ ਦੇ ਅੱਧ ਦੇ ਪੰਜਾਹਾਂ ਵਿੱਚੋਂ ਇੱਕ ਲੈ, ਭਾਵੇਂ ਆਦਮੀਆਂ ਦਾ, ਭਾਵੇਂ ਵੱਗ ਦਾ, ਭਾਵੇਂ ਗਧਿਆਂ ਦਾ, ਭਾਵੇਂ ਇੱਜੜ ਦਾ ਅਰਥਾਤ ਸਾਰੇ ਪਸ਼ੂਆਂ ਦਾ ਅਤੇ ਉਨ੍ਹਾਂ ਨੂੰ ਲੇਵੀਆਂ ਨੂੰ ਦੇਵੀਂ, ਜਿਹੜੇ ਯਹੋਵਾਹ ਦੇ ਡੇਰੇ ਦੀ ਸੰਭਾਲ ਕਰਦੇ ਹਨ। ");
INSERT INTO pan_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","ਜਿਹੜਾ ਹੁਕਮ ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਦਿੱਤਾ ਸੀ, ਅਲਆਜ਼ਾਰ ਜਾਜਕ ਅਤੇ ਮੂਸਾ ਨੇ ਉਸੇ ਦੇ ਅਨੁਸਾਰ ਹੀ ਕੀਤਾ। ");
INSERT INTO pan_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","32","ਮਾਲ ਡੰਗਰ ਤੋਂ ਬਿਨ੍ਹਾਂ ਜੋ ਸੂਰਮਿਆਂ ਨੇ ਲੁੱਟਿਆ, ਉਸ ਵਿੱਚ ਛੇ ਲੱਖ ਪੰਝੱਤਰ ਹਜ਼ਾਰ ਭੇਡਾਂ, ");
INSERT INTO pan_vpl VALUES ("NU31_33","005_31_33","NUM","31","33","33","ਬਹੱਤਰ ਹਜ਼ਾਰ ਬਲ਼ਦ, ");
INSERT INTO pan_vpl VALUES ("NU31_34","005_31_34","NUM","31","34","34","ਇੱਕਾਹਠ ਹਜ਼ਾਰ ਗਧੇ, ");
INSERT INTO pan_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","ਲੋਕਾਂ ਵਿੱਚੋਂ ਉਹ ਕੁਆਰੀਆਂ ਜਿਨ੍ਹਾਂ ਨੇ ਮਨੁੱਖ ਨਾਲ ਸੰਗ ਨਹੀਂ ਕੀਤਾ ਸੀ, ਉਹ ਬੱਤੀ ਹਜ਼ਾਰ ਸਨ, ");
INSERT INTO pan_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","ਜਿਹੜੇ ਯੁੱਧ ਕਰਨ ਗਏ ਉਹਨਾਂ ਦਾ ਭਾਗ ਤਿੰਨ ਲੱਖ ਸੈਂਤੀ ਹਜ਼ਾਰ ਪੰਜ ਸੌ ਭੇਡਾਂ ਸਨ, ");
INSERT INTO pan_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","ਅਤੇ ਯਹੋਵਾਹ ਦਾ ਲਗਾਨ ਇਹ ਸੀ, ਜਿਹਨਾਂ ਵਿੱਚੋਂ ਛੇ ਸੌ ਪੰਝੱਤਰ ਭੇਡਾਂ ਅਤੇ ਬੱਕਰੀਆਂ, ");
INSERT INTO pan_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","ਅਤੇ ਬਲ਼ਦ ਛੱਤੀ ਹਜ਼ਾਰ ਸਨ ਜਿਨ੍ਹਾਂ ਵਿੱਚੋਂ ਯਹੋਵਾਹ ਦਾ ਲਗਾਨ ਬਹੱਤਰ ਸਨ ");
INSERT INTO pan_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","ਗਧੇ ਤੀਹ ਹਜ਼ਾਰ ਪੰਜ ਸੌ ਸਨ, ਜਿਨ੍ਹਾਂ ਵਿੱਚੋਂ ਯਹੋਵਾਹ ਦਾ ਲਗਾਨ ਇੱਕਾਹਠ ਸਨ ");
INSERT INTO pan_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","ਅਤੇ ਇਨਸਾਨ ਸੌਲਾਂ ਹਜ਼ਾਰ ਸਨ ਜਿਨ੍ਹਾਂ ਵਿੱਚੋਂ ਯਹੋਵਾਹ ਦਾ ਲਗਾਨ ਬੱਤੀ ਪ੍ਰਾਣੀ ਸਨ ");
INSERT INTO pan_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","ਤਾਂ ਮੂਸਾ ਨੇ ਉਸ ਲਗਾਨ ਨੂੰ ਯਹੋਵਾਹ ਦੀ ਚੁੱਕਣ ਦੀ ਭੇਟ ਕਰਕੇ, ਅਲਆਜ਼ਾਰ ਜਾਜਕ ਨੂੰ ਦਿੱਤਾ ਜਿਵੇਂ ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਹੁਕਮ ਦਿੱਤਾ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","42","ਅਤੇ ਇਸਰਾਏਲੀਆਂ ਦੇ ਅੱਧ ਤੋਂ ਜਿਹੜਾ ਮੂਸਾ ਨੇ ਯੁੱਧ ਕਰਨ ਵਾਲਿਆਂ ਤੋਂ ਵੰਡਿਆ ");
INSERT INTO pan_vpl VALUES ("NU31_43","005_31_43","NUM","31","43","43","ਅਤੇ ਮੰਡਲੀ ਦਾ ਹਿੱਸਾ ਇਹ ਸੀ, ਭੇਡਾਂ ਤਿੰਨ ਲੱਖ ਸੈਂਤੀ ਹਜ਼ਾਰ ਪੰਜ ਸੌ, ");
INSERT INTO pan_vpl VALUES ("NU31_44","005_31_44","NUM","31","44","44","ਗਾਂ-ਬਲ਼ਦ ਛੱਤੀ ਹਜ਼ਾਰ, ");
INSERT INTO pan_vpl VALUES ("NU31_45","005_31_45","NUM","31","45","45","ਗਧੇ ਤੀਹ ਹਜ਼ਾਰ ਪੰਜ ਸੌ, ");
INSERT INTO pan_vpl VALUES ("NU31_46","005_31_46","NUM","31","46","46","ਇਨਸਾਨ ਸੌਲਾਂ ਹਜ਼ਾਰ ");
INSERT INTO pan_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","ਇਸ ਅੱਧੇ ਹਿੱਸੇ ਵਿੱਚੋਂ ਜਿਸ ਨੂੰ ਮੂਸਾ ਨੇ ਯੁੱਧ ਕਰਨ ਵਾਲਿਆਂ ਪੁਰਖਾਂ ਤੋਂ ਵੱਖਰਾ ਕੀਤਾ ਸੀ, ਯਹੋਵਾਹ ਦੇ ਹੁਕਮਾਂ ਅਨੁਸਾਰ ਮੂਸਾ ਨੇ ਭਾਵੇਂ ਮਨੁੱਖਾਂ ਵਿੱਚੋਂ ਭਾਵੇਂ ਪਸ਼ੂਆਂ ਵਿੱਚੋਂ, ਪੰਜਾਹ ਵਿੱਚੋਂ ਇੱਕ ਨੂੰ ਲੈ ਕੇ ਉਹ ਲੇਵੀਆਂ ਨੂੰ ਦਿੱਤੇ ਜਿਹੜੇ ਯਹੋਵਾਹ ਦੇ ਡੇਰੇ ਦੀ ਸੰਭਾਲ ਕਰਦੇ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","ਤਾਂ ਸੈਨਾਪਤੀ ਜਿਹੜੇ ਹਜ਼ਾਰਾਂ ਉੱਤੇ ਸਨ ਅਰਥਾਤ ਹਜ਼ਾਰਾਂ ਦੇ ਪ੍ਰਧਾਨ ਅਤੇ ਸੈਂਕੜਿਆਂ ਦੇ ਪ੍ਰਧਾਨ ਮੂਸਾ ਕੋਲ ਆਏ ");
INSERT INTO pan_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","ਅਤੇ ਉਨ੍ਹਾਂ ਨੇ ਮੂਸਾ ਨੂੰ ਆਖਿਆ, ਤੁਹਾਡੇ ਦਾਸਾਂ ਨੇ ਯੁੱਧ ਕਰਨ ਵਾਲਿਆਂ ਦੀ ਗਿਣਤੀ ਕੀਤੀ ਅਤੇ ਉਹਨਾਂ ਵਿੱਚੋਂ ਇੱਕ ਮਨੁੱਖ ਵੀ ਨਹੀਂ ਘਟਿਆ। ");
INSERT INTO pan_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","ਅਸੀਂ ਯਹੋਵਾਹ ਦਾ ਚੜ੍ਹਾਵਾ ਲਿਆਏ ਹਾਂ, ਜੋ ਕੁਝ ਹਰ ਇੱਕ ਦੇ ਹੱਥ ਲੱਗਾ ਅਰਥਾਤ ਸੋਨੇ ਦੇ ਗਹਿਣੇ, ਪਜੇਬਾਂ, ਕੜੇ, ਛਾਪਾਂ, ਬਾਲ਼ੀਆਂ ਬਾਜ਼ੂਬੰਦ, ਤਾਂ ਜੋ ਅਸੀਂ ਆਪਣੇ ਪ੍ਰਾਣਾਂ ਲਈ ਯਹੋਵਾਹ ਅੱਗੇ ਪ੍ਰਾਸਚਿਤ ਕਰੀਏ। ");
INSERT INTO pan_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","ਤਦ ਮੂਸਾ ਅਤੇ ਅਲਆਜ਼ਾਰ ਜਾਜਕ ਨੇ ਉਨ੍ਹਾਂ ਤੋਂ ਇਹ ਸਾਰੇ ਘੜਤ ਦੇ ਸੋਨੇ ਦੇ ਗਹਿਣੇ ਲਏ ");
INSERT INTO pan_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","ਅਤੇ ਚੁੱਕਣ ਦੀ ਭੇਟ ਦਾ ਸਾਰਾ ਸੋਨਾ, ਜਿਹੜਾ ਉਨ੍ਹਾਂ ਨੇ ਯਹੋਵਾਹ ਲਈ ਚੜ੍ਹਾਇਆ ਸਵਾ ਕੁ ਪੰਜ ਮਣ ਪੱਕਾ ਸੀ, ਜਿਹੜਾ ਹਜ਼ਾਰਾਂ ਦੇ ਹਾਕਮਾਂ ਅਤੇ ਸੈਂਕੜਿਆਂ ਦੇ ਹਾਕਮਾਂ ਤੋਂ ਆਇਆ। ");
INSERT INTO pan_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","ਯੁੱਧ ਕਰਨ ਵਾਲਿਆਂ ਵਿੱਚੋਂ ਹਰ ਇੱਕ ਨੇ ਆਪਣੇ ਲਈ ਲੁੱਟਿਆ ਸੀ ");
INSERT INTO pan_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","ਤਾਂ ਮੂਸਾ ਅਤੇ ਅਲਆਜ਼ਾਰ ਜਾਜਕ, ਉਹ ਸੋਨਾ ਹਜ਼ਾਰਾਂ ਅਤੇ ਸੈਂਕੜਿਆਂ ਦੇ ਹਾਕਮਾਂ ਤੋਂ ਲੈ ਕੇ ਮੰਡਲੀ ਦੇ ਤੰਬੂ ਵਿੱਚ ਲਿਆਏ ਤਾਂ ਜੋ ਉਹ ਇਸਰਾਏਲੀਆਂ ਲਈ ਯਹੋਵਾਹ ਅੱਗੇ ਇੱਕ ਯਾਦਗਾਰੀ ਹੋਵੇ। ");
INSERT INTO pan_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","ਰਊਬੇਨੀਆਂ ਅਤੇ ਗਾਦੀਆਂ ਕੋਲ ਮਾਲ ਡੰਗਰ ਕਾਫ਼ੀ ਸਨ ਅਤੇ ਜਦ ਉਨ੍ਹਾਂ ਨੇ ਯਾਜ਼ੇਰ ਅਤੇ ਗਿਲਆਦ ਦੇ ਦੇਸ ਨੂੰ ਵੇਖਿਆ ਤਾਂ ਵੇਖੋ, ਉਹ ਸਥਾਨ ਪਸ਼ੂਆਂ ਲਈ ਚੰਗਾ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","ਉਪਰੰਤ ਗਾਦੀਆਂ ਅਤੇ ਰਊਬੇਨੀਆਂ ਨੇ ਮੂਸਾ ਅਤੇ ਅਲਆਜ਼ਾਰ ਜਾਜਕ ਅਤੇ ਮੰਡਲੀ ਦੇ ਪ੍ਰਧਾਨਾਂ ਕੋਲ ਜਾ ਕੇ ਆਖਿਆ, ");
INSERT INTO pan_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","3","ਅਟਾਰੋਥ, ਦੀਬੋਨ, ਯਾਜ਼ੇਰ, ਨਿਮਰਾਹ, ਹਸ਼ਬੋਨ, ਅਲਾਲੇਹ, ਸਬਾਮ, ਨਬੋ ਅਤੇ ਬਓਨ, ");
INSERT INTO pan_vpl VALUES ("NU32_4","005_32_4","NUM","32","4","4","ਅਰਥਾਤ ਜਿਸ ਧਰਤੀ ਉੱਤੇ ਯਹੋਵਾਹ ਨੇ ਇਸਰਾਏਲ ਦੀ ਮੰਡਲੀ ਨੂੰ ਜਿੱਤ ਦਿੱਤੀ ਹੈ ਇਹ ਧਰਤੀ ਪਸ਼ੂਆਂ ਲਈ ਉੱਤਮ ਹੈ ਅਤੇ ਤੁਹਾਡੇ ਦਾਸਾਂ ਕੋਲ ਮਾਲ ਡੰਗਰ ਬਹੁਤ ਹਨ। ");
INSERT INTO pan_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","ਨਾਲੇ ਉਨ੍ਹਾਂ ਨੇ ਆਖਿਆ, ਜੇ ਤੁਹਾਡੀ ਕਿਰਪਾ ਦੀ ਨਿਗਾਹ ਸਾਡੇ ਉੱਤੇ ਹੋਵੇ ਤਾਂ ਇਹ ਧਰਤੀ ਤੁਹਾਡੇ ਦਾਸਾਂ ਨੂੰ ਨਿੱਜ ਭਾਗ ਹੋਣ ਲਈ ਦਿੱਤੀ ਜਾਵੇ। ਸਾਨੂੰ ਯਰਦਨੋਂ ਪਾਰ ਨਾ ਲੰਘਾਇਓ। ");
INSERT INTO pan_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","ਤਾਂ ਮੂਸਾ ਨੇ ਗਾਦੀਆਂ ਅਤੇ ਰਊਬੇਨੀਆਂ ਨੂੰ ਆਖਿਆ, ਕੀ, ਤੁਹਾਡੇ ਭਰਾ ਤਾਂ ਲੜਾਈ ਵਿੱਚ ਜਾਣ ਅਤੇ ਤੁਸੀਂ ਇੱਥੇ ਬੈਠੇ ਰਹੋ? ");
INSERT INTO pan_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","ਤੁਸੀਂ ਇਸਰਾਏਲੀਆਂ ਨੂੰ ਉਸ ਦੇਸ ਦੇ ਵਿਖੇ ਕਿਉਂ ਨਿਰਾਸ਼ ਕਰਦੇ ਹੋ? ਜਿਹੜਾ ਯਹੋਵਾਹ ਨੇ ਉਹਨਾਂ ਨੂੰ ਦਿੱਤਾ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","ਜਦ ਮੈਂ ਤੁਹਾਡੇ ਪਿਉ ਨੂੰ ਕਾਦੇਸ਼-ਬਰਨੇਆ ਤੋਂ ਕਨਾਨ ਦੇਸ ਨੂੰ ਵੇਖਣ ਲਈ ਭੇਜਿਆ ਤਾਂ ਤੁਹਾਡੇ ਪਿਉ ਨੇ ਵੀ ਇਸੇ ਤਰ੍ਹਾਂ ਹੀ ਕੀਤਾ। ");
INSERT INTO pan_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","ਜਦ ਉਨ੍ਹਾਂ ਨੇ ਅਸ਼ਕੋਲ ਦੀ ਘਾਟੀ ਤੱਕ ਪਹੁੰਚ ਕੇ ਉਸ ਦੇਸ ਨੂੰ ਵੇਖਿਆ ਤਾਂ ਇਸਰਾਏਲੀਆਂ ਨੂੰ ਉਸ ਦੇਸ ਦੇ ਵਿਖੇ ਨਿਰਾਸ਼ ਕੀਤਾ, ਜਿਹੜਾ ਯਹੋਵਾਹ ਨੇ ਉਨ੍ਹਾਂ ਨੂੰ ਦਿੱਤਾ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","ਤਾਂ ਉਸ ਦਿਨ ਯਹੋਵਾਹ ਦਾ ਕ੍ਰੋਧ ਭੜਕ ਉੱਠਿਆ ਅਤੇ ਉਸ ਨੇ ਸਹੁੰ ਖਾ ਕੇ ਆਖਿਆ। ");
INSERT INTO pan_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","11","ਕਿ ਇਹ ਮਨੁੱਖ ਜਿਹੜੇ ਮਿਸਰ ਵਿੱਚੋਂ ਨਿੱਕਲ ਕੇ ਆਏ ਹਨ ਉਹਨਾਂ ਦੇ ਵਿੱਚੋਂ ਜਿਹੜੇ ਵੀਹ ਸਾਲ ਦੇ ਅਤੇ ਉਸ ਤੋਂ ਉੱਪਰ ਦੇ ਹਨ ਉਸ ਦੇਸ ਨੂੰ ਨਹੀਂ ਵੇਖਣਗੇ ਜਿਸ ਦੀ ਮੈਂ ਅਬਰਾਹਾਮ, ਇਸਹਾਕ ਅਤੇ ਯਾਕੂਬ ਨਾਲ ਸਹੁੰ ਖਾਧੀ ਸੀ ਕਿਉਂਕਿ ਉਹ ਮੇਰੇ ਪਿੱਛੇ-ਪਿੱਛੇ ਨਹੀਂ ਚੱਲੇ। ");
INSERT INTO pan_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","ਯਫ਼ੁੰਨਹ ਕਨਿੱਜ਼ੀ ਦੇ ਪੁੱਤਰ ਕਾਲੇਬ ਅਤੇ ਨੂਨ ਦੇ ਪੁੱਤਰ ਯਹੋਸ਼ੁਆ ਉਸ ਦੇਸ ਨੂੰ ਵੇਖਣਗੇ ਕਿਉਂ ਜੋ ਉਹ ਯਹੋਵਾਹ ਦੇ ਪਿੱਛੇ ਪੂਰੀ ਤਰ੍ਹਾਂ ਚੱਲੇ। ");
INSERT INTO pan_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","ਤਾਂ ਯਹੋਵਾਹ ਦਾ ਕ੍ਰੋਧ ਇਸਰਾਏਲ ਉੱਤੇ ਭੜਕ ਉੱਠਿਆ ਅਤੇ ਜਦੋਂ ਤੱਕ ਸਾਰੀ ਪੀੜ੍ਹੀ ਦਾ ਨਾਸ ਨਾ ਹੋ ਗਿਆ ਜਿਹਨਾਂ ਨੇ ਯਹੋਵਾਹ ਦੇ ਵਿਰੁੱਧ ਬੁਰਾਈ ਕੀਤੀ ਸੀ, ਉਸੇ ਸਮੇਂ ਤੱਕ ਅਰਥਾਤ ਚਾਲ੍ਹੀ ਸਾਲ ਤੱਕ ਉਜਾੜ ਵਿੱਚ ਫਿਰਾਉਂਦਾ ਰਿਹਾ। ");
INSERT INTO pan_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","ਹੁਣ ਵੇਖੋ, ਤੁਸੀਂ ਉਹਨਾਂ ਵੱਡਿਆ ਦੇ ਥਾਂ ਉੱਠੇ ਹੋ। ਹਾਂ, ਤੁਸੀਂ ਉਹਨਾਂ ਪਾਪੀ ਮਨੁੱਖਾਂ ਦੇ ਦੁਆਰਾ ਜੰਮੇ ਹੋ। ਤੁਸੀਂ ਯਹੋਵਾਹ ਦੇ ਕ੍ਰੋਧ ਨੂੰ ਇਸਰਾਏਲ ਉੱਤੇ ਬਹੁਤ ਵਧਾਓਗੇ। ");
INSERT INTO pan_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","ਜੇ ਤੁਸੀਂ ਉਸ ਦੇ ਪਿੱਛੇ ਚੱਲਣ ਤੋਂ ਹੱਟ ਜਾਓ ਤਾਂ ਉਹ ਫਿਰ ਇਨ੍ਹਾਂ ਨੂੰ ਉਜਾੜ ਵਿੱਚ ਛੱਡ ਦੇਵੇਗਾ ਇਸ ਤਰ੍ਹਾਂ ਤੁਸੀਂ ਇਸ ਸਾਰੀ ਪਰਜਾ ਦਾ ਨਾਸ ਕਰਵਾ ਦਿਓਗੇ। ");
INSERT INTO pan_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","ਤਾਂ ਉਨ੍ਹਾਂ ਨੇ ਮੂਸਾ ਦੇ ਕੋਲ ਆ ਕੇ ਆਖਿਆ, ਅਸੀਂ ਇੱਥੇ ਹੀ ਆਪਣੇ ਪਸ਼ੂਆਂ ਲਈ ਵਾੜੇ ਅਤੇ ਆਪਣੇ ਬੱਚਿਆਂ ਲਈ ਸ਼ਹਿਰ ਬਣਾਵਾਂਗੇ। ");
INSERT INTO pan_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","ਪਰ ਅਸੀਂ ਸ਼ਸਤਰ ਲੈ ਕੇ ਇਸਰਾਏਲੀਆਂ ਦੇ ਅੱਗੇ ਹੋਵਾਂਗੇ ਜਦ ਤੱਕ ਅਸੀਂ ਉਨ੍ਹਾਂ ਨੂੰ ਉਨ੍ਹਾਂ ਦੇ ਟਿਕਾਣਿਆਂ ਉੱਤੇ ਨਾ ਪਹੁੰਚਾ ਦੇਈਏ ਅਤੇ ਸਾਡੇ ਬਾਲ ਬੱਚੇ ਇਸ ਦੇਸ ਦੇ ਨਿਵਾਸੀਆਂ ਨਾਲ ਗੜ੍ਹ ਵਾਲੇ ਸ਼ਹਿਰਾਂ ਵਿੱਚ ਰਹਿਣਗੇ। ");
INSERT INTO pan_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","ਅਤੇ ਅਸੀਂ ਆਪਣਿਆਂ ਘਰਾਂ ਨੂੰ ਨਹੀਂ ਮੁੜਾਂਗੇ ਜਦੋਂ ਤੱਕ ਇਸਰਾਏਲੀਆਂ ਦਾ ਇੱਕ-ਇੱਕ ਮਨੁੱਖ ਆਪਣੀ ਜ਼ਮੀਨ ਦਾ ਮਾਲਕ ਨਾ ਹੋ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","ਕਿਉਂ ਜੋ ਅਸੀਂ ਉਨ੍ਹਾਂ ਨਾਲ ਯਰਦਨ ਪਾਰ ਅਤੇ ਉਸ ਤੋਂ ਅੱਗੇ ਜ਼ਮੀਨ ਨਹੀਂ ਲਵਾਂਗੇ ਕਿਉਂ ਜੋ ਸਾਡੀ ਜ਼ਮੀਨ ਸਾਨੂੰ ਯਰਦਨ ਦੇ ਇਸ ਪਾਸੇ ਪੂਰਬ ਵੱਲ ਮਿਲ ਗਈ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","ਤਾਂ ਮੂਸਾ ਨੇ ਉਨ੍ਹਾਂ ਨੂੰ ਆਖਿਆ, ਜੇ ਤੁਸੀਂ ਇਹ ਕੰਮ ਕਰੋ, ਜੇ ਤੁਸੀਂ ਸ਼ਸਤਰ ਲਵੋ ਅਤੇ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਲੜਾਈ ਲਈ ਜਾਓ। ");
INSERT INTO pan_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","ਅਤੇ ਤੁਹਾਡੇ ਵਿੱਚੋਂ ਹਰ ਇੱਕ ਸ਼ਸਤਰ ਧਾਰੀ ਹੋ ਕੇ ਯਰਦਨ ਤੋਂ ਪਾਰ ਲੰਘ ਜਾਵੇ ਜਦ ਤੱਕ ਯਹੋਵਾਹ ਆਪਣੇ ਵੈਰੀਆਂ ਨੂੰ ਆਪਣੇ ਅੱਗੋਂ ਨਾ ਕੱਢ ਦੇਵੇ। ");
INSERT INTO pan_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","ਅਤੇ ਦੇਸ ਯਹੋਵਾਹ ਦੇ ਵੱਸ ਵਿੱਚ ਨਾ ਹੋ ਜਾਵੇ ਤਾਂ ਇਸ ਤੋਂ ਬਾਅਦ ਤੁਸੀਂ ਮੁੜ ਸਕਦੇ ਹੋ, ਤੁਸੀਂ ਯਹੋਵਾਹ ਵੱਲੋਂ ਅਤੇ ਇਸਰਾਏਲੀਆਂ ਵੱਲੋਂ ਨਿਰਦੋਸ਼ ਠਹਿਰੋਗੇ ਅਤੇ ਇਹ ਦੇਸ ਯਹੋਵਾਹ ਅੱਗੇ ਤੁਹਾਡੀ ਆਪਣੀ ਜ਼ਮੀਨ ਹੋਵੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","ਪਰ ਜੇ ਤੁਸੀਂ ਇਹ ਨਾ ਕਰੋ ਤਾਂ ਵੇਖੋ, ਤੁਸੀਂ ਯਹੋਵਾਹ ਦੇ ਵਿਰੁੱਧ ਪਾਪ ਕਰੋਗੇ ਅਤੇ ਜਾਣੋ ਕਿ ਤੁਹਾਡਾ ਪਾਪ ਤੁਹਾਡੇ ਉੱਤੇ ਆ ਪਵੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","ਤੁਸੀਂ ਆਪਣੇ ਬਾਲ ਬੱਚਿਆਂ ਲਈ ਸ਼ਹਿਰ ਅਤੇ ਆਪਣੇ ਇੱਜੜਾਂ ਲਈ ਵਾੜੇ ਬਣਾਓ, ਜਿਵੇਂ ਤੁਹਾਡੇ ਮੂੰਹੋਂ ਨਿੱਕਲਿਆ ਹੈ ਉਸੇ ਤਰ੍ਹਾਂ ਕਰੋ। ");
INSERT INTO pan_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","ਗਾਦੀਆਂ ਅਤੇ ਰਊਬੇਨੀਆਂ ਨੇ ਮੂਸਾ ਨੂੰ ਆਖਿਆ, ਆਪਣੇ ਸੁਆਮੀ ਦੀ ਆਗਿਆ ਅਨੁਸਾਰ ਤੇਰੇ ਦਾਸ ਕਰਨਗੇ। ");
INSERT INTO pan_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","ਸਾਡੇ ਬਾਲ ਬੱਚੇ, ਸਾਡੀਆਂ ਔਰਤਾਂ, ਸਾਡੇ ਝੁੰਡ ਅਤੇ ਸਾਡੇ ਸਾਰੇ ਜਾਨਵਰ ਗਿਲਆਦ ਦੇ ਸ਼ਹਿਰਾਂ ਵਿੱਚ ਰਹਿਣਗੇ। ");
INSERT INTO pan_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","ਪਰ ਆਪਣੇ ਸੁਆਮੀ ਦੇ ਕਹੇ ਅਨੁਸਾਰ ਤੇਰੇ ਦਾਸ ਸਾਰੇ ਦੇ ਸਾਰੇ ਯੁੱਧ ਕਰਨ ਲਈ ਸ਼ਸਤਰ ਧਾਰੀ ਹੋ ਕੇ ਯਹੋਵਾਹ ਅੱਗੇ-ਅੱਗੇ ਲੜਨ ਲਈ ਪਾਰ ਲੰਘਣਗੇ। ");
INSERT INTO pan_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","ਤਾਂ ਮੂਸਾ ਨੇ ਉਨ੍ਹਾਂ ਦੇ ਵਿਖੇ ਅਲਆਜ਼ਾਰ ਜਾਜਕ ਨੂੰ ਅਤੇ ਨੂਨ ਦੇ ਪੁੱਤਰ ਯਹੋਸ਼ੁਆ ਨੂੰ ਅਤੇ ਇਸਰਾਏਲ ਦਿਆਂ ਗੋਤਾਂ ਦੇ ਪੁਰਖਿਆਂ ਦੇ ਘਰਾਣਿਆਂ ਦੇ ਮੁਖੀਆਂ ਨੂੰ ਹੁਕਮ ਦਿੱਤਾ। ");
INSERT INTO pan_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","ਜੇ ਗਾਦੀ ਅਤੇ ਰਊਬੇਨੀ ਤੁਹਾਡੇ ਨਾਲ ਯਰਦਨ ਤੋਂ ਪਾਰ ਲੰਘਣ, ਅਤੇ ਉਹ ਜਿਹੜੇ ਸ਼ਸਤਰ ਧਾਰੀ ਹਨ ਯਹੋਵਾਹ ਲਈ ਲੜਨ ਅਤੇ ਧਰਤੀ ਤੁਹਾਡੇ ਵੱਸ ਹੋ ਜਾਵੇ ਤਾਂ ਤੁਸੀਂ ਉਨ੍ਹਾਂ ਨੂੰ ਗਿਲਆਦ ਦੇਸ ਉਹਨਾਂ ਦੀ ਸੰਪਤੀ ਹੋਣ ਲਈ ਦੇ ਦੇਇਓ। ");
INSERT INTO pan_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","ਪਰ ਜੇ ਉਹ ਤੁਹਾਡੇ ਨਾਲ ਸ਼ਸਤਰ ਧਾਰੀ ਹੋ ਕੇ ਪਾਰ ਨਾ ਜਾਣ ਤਾਂ ਉਹ ਤੁਹਾਡੇ ਵਿੱਚ ਕਨਾਨ ਦੇਸ ਵਿੱਚ ਜ਼ਮੀਨ ਲੈਣ। ");
INSERT INTO pan_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","ਤਾਂ ਗਾਦੀਆਂ ਅਤੇ ਰਊਬੇਨੀਆਂ ਨੇ ਉੱਤਰ ਦਿੱਤਾ, ਜਿਵੇਂ ਯਹੋਵਾਹ ਤੇਰੇ ਦਾਸਾਂ ਨੂੰ ਬੋਲਿਆ ਹੈ ਉਸੇ ਤਰ੍ਹਾਂ ਅਸੀਂ ਕਰਾਂਗੇ। ");
INSERT INTO pan_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","ਅਸੀਂ ਸ਼ਸਤਰ ਧਾਰੀ ਹੋ ਕੇ ਯਹੋਵਾਹ ਅੱਗੇ ਕਨਾਨ ਦੇਸ ਵਿੱਚ ਜਾਂਵਾਂਗੇ ਪਰ ਸਾਡੀ ਜ਼ਮੀਨ ਯਰਦਨ ਦੇ ਇਸ ਪਾਰ ਹੀ ਰਹੇ। ");
INSERT INTO pan_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","ਤਾਂ ਮੂਸਾ ਨੇ ਗਾਦੀਆਂ ਅਤੇ ਰਊਬੇਨੀਆਂ ਨੂੰ ਅਤੇ ਯੂਸੁਫ਼ ਦੇ ਪੁੱਤਰ ਮਨੱਸ਼ਹ ਦੇ ਅੱਧੇ ਗੋਤ ਨੂੰ ਅਮੋਰੀਆਂ ਦੇ ਰਾਜੇ ਸੀਹੋਨ ਦੇ ਰਾਜ ਨੂੰ ਅਤੇ ਬਾਸ਼ਾਨ ਦੇ ਰਾਜੇ ਓਗ ਦੇ ਰਾਜ ਨੂੰ ਦੇ ਦਿੱਤਾ ਅਤੇ ਉਸ ਦੇ ਆਲੇ-ਦੁਆਲੇ ਦੇ ਦੇਸਾਂ ਦੇ ਸ਼ਹਿਰ ਵੀ ਉਹਨਾਂ ਨੂੰ ਦਿੱਤੇ। ");
INSERT INTO pan_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","34","ਤਾਂ ਗਾਦੀਆਂ ਨੇ ਦੀਬੋਨ ਅਤੇ ਅਟਾਰੋਥ ਅਤੇ ਅਰੋਏਰ। ");
INSERT INTO pan_vpl VALUES ("NU32_35","005_32_35","NUM","32","35","35","ਅਤੇ ਅਟਰੋਥ-ਸ਼ੋਫਾਨ ਅਤੇ ਯਾਜ਼ੇਰ ਅਤੇ ਯਾਗਬਹਾਹ। ");
INSERT INTO pan_vpl VALUES ("NU32_36","005_32_36","NUM","32","36","36","ਅਤੇ ਬੈਤ ਨਿਮਰਾਹ ਅਤੇ ਬੈਤ ਹਾਰਾਨ ਇਹ ਗੜ੍ਹਾਂ ਵਾਲੇ ਸ਼ਹਿਰ ਅਤੇ ਭੇਡਾਂ ਦੇ ਵਾੜੇ ਬਣਾਏ। ");
INSERT INTO pan_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","37","ਪਰ ਰਊਬੇਨੀਆਂ ਨੇ ਇਹ ਬਣਾਏ, ਹਸ਼ਬੋਨ ਅਤੇ ਅਲਾਲੇਹ ਅਤੇ ਕਿਰਯਾਤਾਇਮ। ");
INSERT INTO pan_vpl VALUES ("NU32_38","005_32_38","NUM","32","38","38","ਅਤੇ ਨਬੋ ਬਆਲ-ਮਓਨ ਜਿਨ੍ਹਾਂ ਦੇ ਨਾਮ ਬਦਲੇ ਗਏ ਅਤੇ ਸਿਬਮਾਹ ਨੂੰ ਬਣਾਇਆ ਅਤੇ ਜਿਹੜੇ ਸ਼ਹਿਰ ਉਨ੍ਹਾਂ ਨੇ ਬਣਾਏ ਉਨ੍ਹਾਂ ਦੇ ਹੋਰ ਨਾਮ ਰੱਖੇ। ");
INSERT INTO pan_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","ਮਨੱਸ਼ਹ ਦੇ ਪੁੱਤਰ ਮਾਕੀਰ ਦੇ ਵੰਸ਼ ਨੇ ਜਾ ਕੇ ਗਿਲਆਦ ਨੂੰ ਲੈ ਲਿਆ ਅਤੇ ਅਮੋਰੀਆਂ ਨੂੰ ਜਿਹੜੇ ਉਹ ਦੇ ਵਿੱਚ ਸਨ ਕੱਢ ਦਿੱਤਾ। ");
INSERT INTO pan_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40","ਤਾਂ ਮੂਸਾ ਨੇ ਗਿਲਆਦ ਮਨੱਸ਼ਹ ਦੀ ਅੰਸ ਦੇ ਮਾਕੀਰ ਨੂੰ ਦਿੱਤਾ ਅਤੇ ਉਹ ਉਸ ਵਿੱਚ ਵੱਸਿਆ। ");
INSERT INTO pan_vpl VALUES ("NU32_41","005_32_41","NUM","32","41","41","ਅਤੇ ਮਨੱਸ਼ਹ ਦੇ ਵੰਸ਼ ਦੇ ਯਾਈਰ ਨੇ ਜਾ ਕੇ ਉਨ੍ਹਾਂ ਦੀਆਂ ਬਸਤੀਆਂ ਨੂੰ ਲੈ ਲਿਆ ਅਤੇ ਉਨ੍ਹਾਂ ਦੇ ਨਾਮ ਹੱਵੋਥ, ਯਾਈਰ ਰੱਖੇ। ");
INSERT INTO pan_vpl VALUES ("NU32_42","005_32_42","NUM","32","42","42","ਅਤੇ ਨੋਬਹ ਨੇ ਜਾ ਕੇ ਕਨਾਥ ਅਤੇ ਉਸ ਦੇ ਪਿੰਡਾਂ ਨੂੰ ਲਿਆ ਅਤੇ ਉਨ੍ਹਾਂ ਦਾ ਨਾਮ ਆਪਣੇ ਨਾਮ ਤੇ ਆਪਣਾ ਨਾਮ ਨੋਬਹ ਰੱਖਿਆ। ");
INSERT INTO pan_vpl VALUES ("NU33_1","005_33_1","NUM","33","1","1","ਇਹ ਇਸਰਾਏਲੀਆਂ ਦੇ ਸਫ਼ਰ ਹਨ ਜਦ ਉਹ ਮਿਸਰ ਦੇਸ ਤੋਂ ਆਪਣੀਆਂ ਸੈਨਾਂ ਅਨੁਸਾਰ ਮੂਸਾ ਅਤੇ ਹਾਰੂਨ ਦੀ ਅਗਵਾਈ ਨਾਲ ਨਿੱਕਲੇ। ");
INSERT INTO pan_vpl VALUES ("NU33_2","005_33_2","NUM","33","2","2","ਅਤੇ ਮੂਸਾ ਨੇ ਉਨ੍ਹਾਂ ਦੇ ਸਫ਼ਰਾਂ ਨੂੰ ਉਨ੍ਹਾਂ ਦੀਆਂ ਮੰਜ਼ਲਾਂ ਅਨੁਸਾਰ ਯਹੋਵਾਹ ਦੇ ਹੁਕਮ ਨਾਲ ਲਿਖਿਆ ਸੋ ਉਨ੍ਹਾਂ ਦੇ ਸਫ਼ਰ ਦੀਆਂ ਮੰਜ਼ਲਾਂ ਇਹ ਹਨ ");
INSERT INTO pan_vpl VALUES ("NU33_3","005_33_3","NUM","33","3","3","ਉਨ੍ਹਾਂ ਨੇ ਰਾਮਸੇਸ ਤੋਂ ਪਹਿਲੇ ਮਹੀਨੇ ਦੇ ਪੰਦਰਵੇਂ ਦਿਨ ਕੂਚ ਕੀਤਾ। ਪਸਾਹ ਦੇ ਇੱਕ ਦਿਨ ਪਿੱਛੋਂ ਇਸਰਾਏਲੀ ਜ਼ਬਰਦਸਤੀ ਨਾਲ ਸਾਰੇ ਮਿਸਰੀਆਂ ਦੇ ਵੇਖਦਿਆਂ ਤੇ ਨਿੱਕਲ ਗਏ। ");
INSERT INTO pan_vpl VALUES ("NU33_4","005_33_4","NUM","33","4","4","ਜਦੋਂ ਮਿਸਰੀ ਸਾਰੇ ਪਹਿਲੌਠਿਆਂ ਨੂੰ ਜਿਨ੍ਹਾਂ ਨੂੰ ਯਹੋਵਾਹ ਨੇ ਮਾਰਿਆ ਸੀ ਦੱਬ ਰਹੇ ਸਨ ਅਤੇ ਯਹੋਵਾਹ ਨੇ ਉਨ੍ਹਾਂ ਦੇ ਦੇਵਤਿਆਂ ਨੂੰ ਸਜ਼ਾ ਵੀ ਦਿੱਤੀ। ");
INSERT INTO pan_vpl VALUES ("NU33_5","005_33_5","NUM","33","5","5","ਤਾਂ ਇਸਰਾਏਲੀਆਂ ਨੇ ਰਾਮਸੇਸ ਤੋਂ ਕੂਚ ਕਰਕੇ ਸੁੱਕੋਥ ਵਿੱਚ ਆਪਣੇ ਡੇਰੇ ਲਾਏ। ");
INSERT INTO pan_vpl VALUES ("NU33_6","005_33_6","NUM","33","6","6","ਫੇਰ ਉਨ੍ਹਾਂ ਨੇ ਸੁੱਕੋਥ ਤੋਂ ਕੂਚ ਕਰਕੇ ਏਥਾਮ ਵਿੱਚ ਡੇਰੇ ਲਾਏ ਜਿਹੜਾ ਉਜਾੜ ਦੀ ਹੱਦ ਉੱਤੇ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("NU33_7","005_33_7","NUM","33","7","7","ਫੇਰ ਏਥਾਮ ਤੋਂ ਕੂਚ ਕਰਕੇ ਉਹ ਪੀ-ਹਹੀਰੋਥ ਨੂੰ ਮੁੜੇ ਜਿਹੜਾ ਬਆਲ-ਸਫ਼ੋਨ ਦੇ ਅੱਗੇ ਹੈ ਅਤੇ ਮਿਗਦੋਲ ਦੇ ਅੱਗੇ ਉਨ੍ਹਾਂ ਨੇ ਡੇਰੇ ਲਾਏ। ");
INSERT INTO pan_vpl VALUES ("NU33_8","005_33_8","NUM","33","8","8","ਤਦ ਪੀ-ਹਹੀਰੋਥ ਦੇ ਅੱਗੋਂ ਕੂਚ ਕਰ ਕੇ ਉਹ ਸਮੁੰਦਰ ਦੇ ਵਿੱਚੋਂ ਦੀ ਲੰਘ ਕੇ ਉਜਾੜ ਵਿੱਚ ਆਏ ਅਤੇ ਉਨ੍ਹਾਂ ਨੇ ਏਥਾਮ ਦੀ ਉਜਾੜ ਵਿੱਚ ਤਿੰਨ ਦਿਨ ਦਾ ਸਫ਼ਰ ਕਰ ਕੇ ਮਾਰਾਹ ਵਿੱਚ ਡੇਰੇ ਲਾਏ। ");
INSERT INTO pan_vpl VALUES ("NU33_9","005_33_9","NUM","33","9","9","ਅਤੇ ਮਾਰਾਹ ਤੋਂ ਕੂਚ ਕਰਕੇ ਉਹ ਏਲਿਮ ਨੂੰ ਆਏ ਜਿੱਥੇ ਪਾਣੀ ਦੇ ਬਾਰਾਂ ਸੋਤੇ ਅਤੇ ਸੱਤਰ ਖਜ਼ੂਰ ਦੇ ਰੁੱਖ ਸਨ, ਉਹਨਾਂ ਨੇ ਉੱਥੇ ਡੇਰੇ ਲਾਏ। ");
INSERT INTO pan_vpl VALUES ("NU33_10","005_33_10","NUM","33","10","10","ਫੇਰ ਉਨ੍ਹਾਂ ਨੇ ਏਲਿਮ ਤੋਂ ਕੂਚ ਕਰ ਕੇ ਲਾਲ ਸਮੁੰਦਰ ਕੋਲ ਡੇਰੇ ਲਾਏ। ");
INSERT INTO pan_vpl VALUES ("NU33_11","005_33_11","NUM","33","11","11","ਅਤੇ ਲਾਲ ਸਮੁੰਦਰ ਤੋਂ ਕੂਚ ਕਰਕੇ ਸੀਨ ਦੀ ਉਜਾੜ ਵਿੱਚ ਡੇਰੇ ਲਾਏ। ");
INSERT INTO pan_vpl VALUES ("NU33_12","005_33_12","NUM","33","12","12","ਤਾਂ ਸੀਨ ਦੀ ਉਜਾੜ ਤੋਂ ਕੂਚ ਕਰ ਕੇ ਦਾਫ਼ਕਾਹ ਵਿੱਚ ਡੇਰੇ ਲਾਏ। ");
INSERT INTO pan_vpl VALUES ("NU33_13","005_33_13","NUM","33","13","13","ਅਤੇ ਦਾਫ਼ਕਾਹ ਤੋਂ ਕੂਚ ਕਰ ਕੇ ਆਲੂਸ਼ ਵਿੱਚ ਡੇਰੇ ਲਾਏ। ");
INSERT INTO pan_vpl VALUES ("NU33_14","005_33_14","NUM","33","14","14","ਤਾਂ ਆਲੂਸ਼ ਤੋਂ ਕੂਚ ਕਰ ਕੇ ਰਫ਼ੀਦੀਮ ਵਿੱਚ ਡੇਰੇ ਲਾਏ ਪਰ ਉੱਥੋਂ ਲੋਕਾਂ ਦੇ ਪੀਣ ਲਈ ਪਾਣੀ ਨਹੀਂ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("NU33_15","005_33_15","NUM","33","15","15","ਫੇਰ ਰਫ਼ੀਦੀਮ ਤੋਂ ਕੂਚ ਕਰ ਕੇ ਸੀਨਈ ਦੀ ਉਜਾੜ ਵਿੱਚ ਡੇਰੇ ਲਾਏ। ");
INSERT INTO pan_vpl VALUES ("NU33_16","005_33_16","NUM","33","16","16","ਅਤੇ ਸੀਨਈ ਦੀ ਉਜਾੜ ਤੋਂ ਕੂਚ ਕਰ ਕੇ ਕਿਬਰੋਥ-ਹੱਤਾਵਾਹ ਵਿੱਚ ਡੇਰੇ ਲਾਏ ");
INSERT INTO pan_vpl VALUES ("NU33_17","005_33_17","NUM","33","17","17","ਤਾਂ ਕਿਬਰੋਥ-ਹੱਤਾਵਾਹ ਤੋਂ ਕੂਚ ਕਰ ਕੇ ਹਸੇਰੋਥ ਵਿੱਚ ਡੇਰੇ ਲਾਏ ");
INSERT INTO pan_vpl VALUES ("NU33_18","005_33_18","NUM","33","18","18","ਤਾਂ ਹਸੇਰੋਥ ਤੋਂ ਕੂਚ ਕਰ ਕੇ ਰਿਥਮਾਹ ਵਿੱਚ ਡੇਰੇ ਲਾਏ। ");
INSERT INTO pan_vpl VALUES ("NU33_19","005_33_19","NUM","33","19","19","ਅਤੇ ਰਿਥਮਾਹ ਤੋਂ ਕੂਚ ਕਰ ਕੇ ਰਿੰਮੋਨ-ਪਾਰਸ ਵਿੱਚ ਡੇਰੇ ਲਾਏ। ");
INSERT INTO pan_vpl VALUES ("NU33_20","005_33_20","NUM","33","20","20","ਅਤੇ ਰਿੰਮੋਨ-ਪਾਰਸ ਤੋਂ ਕੂਚ ਕਰ ਕੇ ਲਿਬਨਾਹ ਵਿੱਚ ਡੇਰੇ ਲਾਏ ");
INSERT INTO pan_vpl VALUES ("NU33_21","005_33_21","NUM","33","21","21","ਤਾਂ ਲਿਬਨਾਹ ਤੋਂ ਕੂਚ ਕਰ ਕੇ ਰਿੱਸਾਹ ਵਿੱਚ ਡੇਰੇ ਲਾਏ ");
INSERT INTO pan_vpl VALUES ("NU33_22","005_33_22","NUM","33","22","22","ਤਾਂ ਰਿੱਸਾਹ ਤੋਂ ਕੂਚ ਕਰ ਕੇ ਕਹੇਲਾਥਾਹ ਵਿੱਚ ਡੇਰੇ ਲਾਏ। ");
INSERT INTO pan_vpl VALUES ("NU33_23","005_33_23","NUM","33","23","23","ਅਤੇ ਕਹੇਲਾਥਾਹ ਤੋਂ ਕੂਚ ਕਰ ਕੇ ਸ਼ਾਫ਼ਰ ਪਰਬਤ ਵਿੱਚ ਡੇਰੇ ਲਾਏ ");
INSERT INTO pan_vpl VALUES ("NU33_24","005_33_24","NUM","33","24","24","ਤਾਂ ਸ਼ਾਫ਼ਰ ਪਰਬਤ ਤੋਂ ਕੂਚ ਕਰ ਕੇ ਹਰਾਦਾਹ ਵਿੱਚ ਡੇਰੇ ਲਾਏ ");
INSERT INTO pan_vpl VALUES ("NU33_25","005_33_25","NUM","33","25","25","ਤਾਂ ਹਰਾਦਾਹ ਤੋਂ ਕੂਚ ਕਰ ਕੇ ਮਕਹੇਲੋਥ ਵਿੱਚ ਡੇਰੇ ਲਾਏ। ");
INSERT INTO pan_vpl VALUES ("NU33_26","005_33_26","NUM","33","26","26","ਫੇਰ ਮਕਹੇਲੋਥ ਤੋਂ ਕੂਚ ਕਰ ਕੇ ਤਹਥ ਵਿੱਚ ਡੇਰੇ ਲਾਏ ");
INSERT INTO pan_vpl VALUES ("NU33_27","005_33_27","NUM","33","27","27","ਅਤੇ ਤਹਥ ਤੋਂ ਕੂਚ ਕਰ ਕੇ ਤਾਰਹ ਵਿੱਚ ਡੇਰੇ ਲਾਏ। ");
INSERT INTO pan_vpl VALUES ("NU33_28","005_33_28","NUM","33","28","28","ਅਤੇ ਤਾਰਹ ਤੋਂ ਕੂਚ ਕਰ ਕੇ ਮਿਥਕਾਹ ਵਿੱਚ ਡੇਰੇ ਲਾਏ ");
INSERT INTO pan_vpl VALUES ("NU33_29","005_33_29","NUM","33","29","29","ਤਾਂ ਮਿਥਕਾਹ ਤੋਂ ਕੂਚ ਕਰ ਕੇ ਹਸ਼ਮੋਨਾਹ ਵਿੱਚ ਡੇਰੇ ਲਾਏ ");
INSERT INTO pan_vpl VALUES ("NU33_30","005_33_30","NUM","33","30","30","ਤਾਂ ਹਸ਼ਮੋਨਾਹ ਤੋਂ ਕੂਚ ਕਰ ਕੇ ਮੋਸੇਰੋਥ ਵਿੱਚ ਡੇਰੇ ਲਾਏ ");
INSERT INTO pan_vpl VALUES ("NU33_31","005_33_31","NUM","33","31","31","ਅਤੇ ਮੋਸੇਰੋਥ ਤੋਂ ਕੂਚ ਕਰ ਕੇ ਬਨੇ-ਯਆਕਾਨ ਵਿੱਚ ਡੇਰੇ ਲਾਏ ");
INSERT INTO pan_vpl VALUES ("NU33_32","005_33_32","NUM","33","32","32","ਤਾਂ ਬਨੇ-ਯਆਕਾਨ ਤੋਂ ਕੂਚ ਕਰ ਕੇ ਹੋਰ-ਹਗਿਦਗਾਦ ਵਿੱਚ ਡੇਰੇ ਲਾਏ। ");
INSERT INTO pan_vpl VALUES ("NU33_33","005_33_33","NUM","33","33","33","ਫੇਰ ਹੋਰ-ਹਗਿਦਗਾਦ ਤੋਂ ਕੂਚ ਕਰ ਕੇ ਯਾਟਬਾਥਾਹ ਵਿੱਚ ਡੇਰੇ ਲਾਏ ");
INSERT INTO pan_vpl VALUES ("NU33_34","005_33_34","NUM","33","34","34","ਅਤੇ ਯਾਟਬਾਥਾਹ ਤੋਂ ਕੂਚ ਕਰ ਕੇ ਅਬਰੋਨਾਹ ਵਿੱਚ ਡੇਰੇ ਲਾਏ ");
INSERT INTO pan_vpl VALUES ("NU33_35","005_33_35","NUM","33","35","35","ਤਾਂ ਅਬਰੋਨਾਹ ਤੋਂ ਕੂਚ ਕਰ ਕੇ ਅਸਯੋਨ-ਗਬਰ ਵਿੱਚ ਡੇਰੇ ਲਾਏ ");
INSERT INTO pan_vpl VALUES ("NU33_36","005_33_36","NUM","33","36","36","ਤਾਂ ਅਸਯੋਨ-ਗਬਰ ਤੋਂ ਕੂਚ ਕਰ ਕੇ ਸੀਨ ਦੀ ਉਜਾੜ ਵਿੱਚ ਜਿਹੜੀ ਕਾਦੇਸ਼ ਹੈ ਡੇਰੇ ਲਾਏ ");
INSERT INTO pan_vpl VALUES ("NU33_37","005_33_37","NUM","33","37","37","ਅਤੇ ਕਾਦੇਸ਼ ਤੋਂ ਕੂਚ ਕਰ ਕੇ ਹੋਰ ਨਾਮੇ ਪਰਬਤ ਵਿੱਚ ਅਦੋਮ ਦੇਸ ਦੀ ਹੱਦ ਉੱਤੇ ਡੇਰੇ ਲਾਏ ");
INSERT INTO pan_vpl VALUES ("NU33_38","005_33_38","NUM","33","38","38","ਅਤੇ ਹਾਰੂਨ ਜਾਜਕ ਹੋਰ ਪਰਬਤ ਉੱਤੇ ਯਹੋਵਾਹ ਦੇ ਹੁਕਮ ਨਾਲ ਚੜ੍ਹਿਆ ਅਤੇ ਉੱਥੇ ਉਹ ਮਰ ਗਿਆ। ਇਸਰਾਏਲੀਆਂ ਦੇ ਮਿਸਰ ਦੇਸ ਤੋਂ ਨਿੱਕਲਣ ਦੇ ਚਾਲੀਵੇਂ ਵਰ੍ਹੇ ਦੇ ਪੰਜਵੇਂ ਮਹੀਨੇ ਦੇ ਪਹਿਲੇ ਦਿਨ ਉਹ ਮਰ ਗਿਆ ");
INSERT INTO pan_vpl VALUES ("NU33_39","005_33_39","NUM","33","39","39","ਅਤੇ ਹਾਰੂਨ ਇੱਕ ਸੌ ਤੇਈ ਸਾਲ ਦਾ ਸੀ ਜਦ ਉਹ ਹੋਰ ਪਰਬਤ ਉੱਤੇ ਮਰ ਗਿਆ। ");
INSERT INTO pan_vpl VALUES ("NU33_40","005_33_40","NUM","33","40","40","ਕਨਾਨੀਆਂ ਦੇ ਰਾਜਾ ਅਰਾਦ ਨੇ ਜੋ ਕਨਾਨ ਦੇਸ ਦੇ ਦੱਖਣ ਵੱਲ ਰਹਿੰਦਾ ਸੀ ਇਸਰਾਏਲੀਆਂ ਦੇ ਆਉਣ ਦੀ ਖ਼ਬਰ ਸੁਣੀ। ");
INSERT INTO pan_vpl VALUES ("NU33_41","005_33_41","NUM","33","41","41","ਅਤੇ ਉਨ੍ਹਾਂ ਨੇ ਹੋਰ ਪਰਬਤ ਤੋਂ ਕੂਚ ਕਰ ਕੇ ਸਲਮੋਨਾਹ ਵਿੱਚ ਡੇਰੇ ਲਾਏ। ");
INSERT INTO pan_vpl VALUES ("NU33_42","005_33_42","NUM","33","42","42","ਤਾਂ ਸਲਮੋਨਾਹ ਤੋਂ ਕੂਚ ਕਰ ਕੇ ਫ਼ੂਨੋਨ ਵਿੱਚ ਡੇਰੇ ਲਾਏ। ");
INSERT INTO pan_vpl VALUES ("NU33_43","005_33_43","NUM","33","43","43","ਤਾਂ ਫ਼ੂਨੋਨ ਤੋਂ ਕੂਚ ਕਰ ਕੇ ਓਬੋਥ ਵਿੱਚ ਡੇਰੇ ਲਾਏ। ");
INSERT INTO pan_vpl VALUES ("NU33_44","005_33_44","NUM","33","44","44","ਅਤੇ ਓਬੋਥ ਤੋਂ ਕੂਚ ਕਰ ਕੇ ਈਯੇਅਬਾਰੀਮ ਵਿੱਚ ਮੋਆਬ ਦੀ ਸਰਹੱਦ ਉੱਤੇ ਡੇਰੇ ਲਾਏ। ");
INSERT INTO pan_vpl VALUES ("NU33_45","005_33_45","NUM","33","45","45","ਤਾਂ ਈਯੇ ਤੋਂ ਕੂਚ ਕਰ ਕੇ ਦੀਬੋਨ ਗਾਦ ਵਿੱਚ ਡੇਰੇ ਲਾਏ। ");
INSERT INTO pan_vpl VALUES ("NU33_46","005_33_46","NUM","33","46","46","ਅਤੇ ਦੀਬੋਨ ਗਾਦ ਤੋਂ ਕੂਚ ਕਰ ਕੇ ਅਲਮੋਨ-ਦਿਬਲਾਤੈਮਾਹ ਵਿੱਚ ਡੇਰੇ ਲਾਏ। ");
INSERT INTO pan_vpl VALUES ("NU33_47","005_33_47","NUM","33","47","47","ਅਤੇ ਅਲਮੋਨ-ਦਿਬਲਾਤੈਮਾਹ ਤੋਂ ਕੂਚ ਕਰ ਕੇ ਅਬਾਰੀਮ ਦੇ ਪਹਾੜਾਂ ਵਿੱਚ ਨਬੋ ਦੇ ਅੱਗੇ ਡੇਰੇ ਲਾਏ। ");
INSERT INTO pan_vpl VALUES ("NU33_48","005_33_48","NUM","33","48","48","ਅਬਾਰੀਮ ਦੇ ਪਹਾੜਾਂ ਤੋਂ ਕੂਚ ਕਰ ਕੇ ਮੋਆਬ ਦੇ ਮੈਦਾਨ ਵਿੱਚ ਯਰਦਨ ਉੱਤੇ ਯਰੀਹੋ ਕੋਲ ਡੇਰੇ ਲਾਏ। ");
INSERT INTO pan_vpl VALUES ("NU33_49","005_33_49","NUM","33","49","49","ਅਤੇ ਉਨ੍ਹਾਂ ਨੇ ਯਰਦਨ ਉੱਤੇ ਬੈਤ ਯਸ਼ਿਮੋਥ ਤੋਂ ਆਬੇਲ-ਸ਼ਿੱਟੀਮ ਤੱਕ ਮੋਆਬ ਦੇ ਮੈਦਾਨ ਵਿੱਚ ਡੇਰੇ ਲਾਏ। ");
INSERT INTO pan_vpl VALUES ("NU33_50","005_33_50","NUM","33","50","50","ਮੋਆਬ ਦੇ ਮੈਦਾਨ ਵਿੱਚ ਯਰਦਨ ਉੱਤੇ ਯਰੀਹੋ ਕੋਲ ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਆਖਿਆ, ");
INSERT INTO pan_vpl VALUES ("NU33_51","005_33_51","NUM","33","51","51","ਇਸਰਾਏਲੀਆਂ ਨਾਲ ਗੱਲ ਕਰ ਅਤੇ ਉਨ੍ਹਾਂ ਨੂੰ ਆਖ ਕਿ ਜਦ ਤੁਸੀਂ ਯਰਦਨ ਦੇ ਪਾਰ ਕਨਾਨ ਦੇਸ ਵਿੱਚ ਪਹੁੰਚੋ ");
INSERT INTO pan_vpl VALUES ("NU33_52","005_33_52","NUM","33","52","52","ਤਾਂ ਤੁਸੀਂ ਉਸ ਦੇਸ ਦੇ ਸਾਰੇ ਵਸਨੀਕਾਂ ਨੂੰ ਆਪਣੇ ਅੱਗਿਓਂ ਕੱਢ ਦਿਓ, ਨਾਲੇ ਉਨ੍ਹਾਂ ਦੇ ਸਾਰੇ ਘੜ੍ਹੇ ਹੋਏ ਪੱਥਰਾਂ, ਢਾਲ਼ੇ ਹੋਏ ਬੁੱਤਾਂ ਨੂੰ ਅਤੇ ਉਨ੍ਹਾਂ ਦੇ ਪੂਜਾ ਦੇ ਉੱਚੇ ਸਥਾਨਾਂ ਨੂੰ ਢਾਹ ਸੁੱਟੋ। ");
INSERT INTO pan_vpl VALUES ("NU33_53","005_33_53","NUM","33","53","53","ਅਤੇ ਤੁਸੀਂ ਉਸ ਦੇਸ ਉੱਤੇ ਕਬਜ਼ਾ ਕਰ ਕੇ ਉਸ ਵਿੱਚ ਵੱਸੋ ਕਿਉਂ ਜੋ ਮੈਂ ਉਹ ਦੇਸ ਤੁਹਾਨੂੰ ਦਿੱਤਾ ਹੈ ਕਿ ਤੁਸੀਂ ਉਸ ਉੱਤੇ ਕਬਜ਼ਾ ਕਰੋ। ");
INSERT INTO pan_vpl VALUES ("NU33_54","005_33_54","NUM","33","54","54","ਤੁਸੀਂ ਪਰਚੀਆਂ ਪਾ ਕੇ ਉਸ ਦੇਸ ਨੂੰ ਆਪਣੇ ਟੱਬਰਾਂ ਅਨੁਸਾਰ ਵੰਡ ਲਓ। ਬਹੁਤਿਆਂ ਨੂੰ ਤੁਸੀਂ ਜ਼ਿਆਦਾ ਜ਼ਮੀਨ ਦਿਓ ਅਤੇ ਥੋੜ੍ਹਿਆਂ ਨੂੰ ਘੱਟ ਜ਼ਮੀਨ ਦਿਓ। ਜਿੱਥੇ ਕਿਸੇ ਦੀ ਪਰਚੀ ਨਿੱਕਲੇ ਉੱਥੇ ਉਸ ਦੀ ਜ਼ਮੀਨ ਹੋਵੇ। ਆਪਣੇ ਪੁਰਖਿਆਂ ਦਿਆਂ ਗੋਤਾਂ ਅਨੁਸਾਰ ਤੁਸੀਂ ਆਪਣੀ ਜ਼ਮੀਨ ਵੰਡ ਲਿਓ। ");
INSERT INTO pan_vpl VALUES ("NU33_55","005_33_55","NUM","33","55","55","ਪਰ ਜੇ ਤੁਸੀਂ ਉਸ ਦੇਸ ਦੇ ਵਸਨੀਕਾਂ ਨੂੰ ਆਪਣੇ ਅੱਗੋਂ ਨਾ ਕੱਢੋ ਤਾਂ ਅਜਿਹਾ ਹੋਵੇਗਾ ਕਿ ਉਹ ਜਿਨ੍ਹਾਂ ਨੂੰ ਤੁਸੀਂ ਰਹਿਣ ਦਿਓਗੇ ਤੁਹਾਡੀਆਂ ਅੱਖਾਂ ਵਿੱਚ ਰੜਕਣਗੇ ਅਤੇ ਤੁਹਾਡੀਆਂ ਪਸਲੀਆਂ ਵਿੱਚ ਕੰਡੇ ਹੋਣਗੇ ਅਤੇ ਉਹ ਤੁਹਾਨੂੰ ਉਸ ਦੇਸ ਵਿੱਚ ਜਿੱਥੇ ਤੁਸੀਂ ਵੱਸਦੇ ਹੋ ਦੁੱਖ ਦੇਣਗੇ। ");
INSERT INTO pan_vpl VALUES ("NU33_56","005_33_56","NUM","33","56","56","ਤਾਂ ਅਜਿਹਾ ਹੋਵੇਗਾ ਕਿ ਜਿਵੇਂ ਮੈਂ ਉਨ੍ਹਾਂ ਨਾਲ ਕਰਨ ਦਾ ਮਨ ਬਣਾਇਆ ਹੈ ਉਹ ਹੀ ਤੁਹਾਡੇ ਨਾਲ ਕਰਾਂਗਾ! ");
INSERT INTO pan_vpl VALUES ("NU34_1","005_34_1","NUM","34","1","1","ਤਦ ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਆਖਿਆ, ");
INSERT INTO pan_vpl VALUES ("NU34_2","005_34_2","NUM","34","2","2","ਇਸਰਾਏਲੀਆਂ ਨੂੰ ਹੁਕਮ ਦੇ ਕੇ ਆਖ ਕਿ ਜਦ ਤੁਸੀਂ ਕਨਾਨ ਦੇਸ ਵਿੱਚ ਪ੍ਰਵੇਸ਼ ਕਰੋ (ਉਹ ਦੇਸ ਜਿਹੜਾ ਤੁਹਾਡੀ ਵਿਰਾਸਤ ਹੋਣ ਲਈ ਮਿਲੇਗਾ ਅਰਥਾਤ ਕਨਾਨ ਦੇਸ ਉਹ ਦੀਆਂ ਹੱਦਾਂ ਤੱਕ) ");
INSERT INTO pan_vpl VALUES ("NU34_3","005_34_3","NUM","34","3","3","ਤਾਂ ਤੁਹਾਡਾ ਦੱਖਣ ਦਾ ਪਾਸਾ ਸੀਨ ਦੀ ਉਜਾੜ ਤੋਂ ਅਦੋਮ ਦੇ ਨੇੜੇ ਹੋਵੇ ਅਤੇ ਤੁਹਾਡੇ ਦੱਖਣ ਦੀ ਹੱਦ ਖਾਰੇ ਸਮੁੰਦਰ ਦੇ ਸਿਰੇ ਤੋਂ ਪੂਰਬ ਵੱਲ ਹੋਵੇ। ");
INSERT INTO pan_vpl VALUES ("NU34_4","005_34_4","NUM","34","4","4","ਤੁਹਾਡੀ ਹੱਦ ਦੱਖਣ ਵਿੱਚ ਅਕਰਾਬੀਮ ਦੀ ਚੜ੍ਹਾਈ ਵੱਲ ਮੁੜੇ, ਫਿਰ ਸੀਨ ਵੱਲ ਹੁੰਦੀ ਹੋਈ ਉਹ ਦਾ ਫੈਲਾਓ ਦੱਖਣ ਤੋਂ ਕਾਦੇਸ਼-ਬਰਨੇਆ ਤੱਕ ਹੋਵੇ ਅਤੇ ਹਸਰ-ਅੱਦਾਰ ਤੱਕ ਜਾ ਕੇ ਅਸਮੋਨ ਨੂੰ ਪਹੁੰਚੇ। ");
INSERT INTO pan_vpl VALUES ("NU34_5","005_34_5","NUM","34","5","5","ਤਾਂ ਉਹ ਹੱਦ ਅਸਮੋਨ ਤੋਂ ਮਿਸਰ ਦੀ ਨਦੀ ਤੱਕ ਘੁੰਮੇ ਅਤੇ ਉਹ ਦਾ ਫੈਲਾਓ ਸਮੁੰਦਰ ਤੱਕ ਹੋਵੇ। ");
INSERT INTO pan_vpl VALUES ("NU34_6","005_34_6","NUM","34","6","6","ਅਤੇ ਤੁਹਾਡੀ ਪੱਛਮ ਵਾਲੇ ਪਾਸੇ ਦੀ ਹੱਦ ਮਹਾਂ ਸਮੁੰਦਰ ਹੋਵੇ। ਇਹ ਤੁਹਾਡੇ ਪੱਛਮ ਵਾਲੇ ਪਾਸੇ ਦੀ ਹੱਦ ਹੋਵੇ। ");
INSERT INTO pan_vpl VALUES ("NU34_7","005_34_7","NUM","34","7","7","ਮਹਾਂ ਸਮੁੰਦਰ ਤੋਂ ਤੁਸੀਂ ਹੋਰ ਨਾਮ ਦੇ ਪਰਬਤ ਤੱਕ ਨਿਸ਼ਾਨ ਲਾਓ ਜੋ ਇਹ ਤੁਹਾਡੀ ਉੱਤਰ ਵੱਲ ਦੀ ਹੱਦ ਹੋਵੇ। ");
INSERT INTO pan_vpl VALUES ("NU34_8","005_34_8","NUM","34","8","8","ਹੋਰ ਪਰਬਤ ਤੋਂ ਤੁਸੀਂ ਨਿਸ਼ਾਨ ਹਮਾਥ ਦੇ ਰਾਹ ਤੱਕ ਲਗਾਉ ਤਾਂ ਇਹ ਹੱਦ ਸਦਾਦ ਤੱਕ ਪਹੁੰਚੇ। ");
INSERT INTO pan_vpl VALUES ("NU34_9","005_34_9","NUM","34","9","9","ਫੇਰ ਹੱਦ ਜ਼ਿਫਰੋਨ ਤੱਕ ਜਾਵੇ ਅਤੇ ਉਹ ਦਾ ਫੈਲਾਓ ਹਸਰ-ਏਨਾਨ ਤੱਕ ਹੋਵੇ। ਇਹ ਤੁਹਾਡੀ ਉੱਤਰ ਦੀ ਹੱਦ ਹੋਵੇ। ");
INSERT INTO pan_vpl VALUES ("NU34_10","005_34_10","NUM","34","10","10","ਤੁਸੀਂ ਆਪਣੀ ਪੂਰਬੀ ਹੱਦ ਲਈ ਹਸਰ-ਏਨਾਨ ਤੋਂ ਸ਼ਫਾਮ ਤੱਕ ਨਿਸ਼ਾਨ ਲਾਓ। ");
INSERT INTO pan_vpl VALUES ("NU34_11","005_34_11","NUM","34","11","11","ਅਤੇ ਸ਼ਫਾਮ ਤੋਂ ਰਿਬਲਾਹ ਤੱਕ ਆਯਿਨ ਦੇ ਪੂਰਬ ਵੱਲੋਂ ਹੇਠਾਂ ਨੂੰ ਜਾਵੇ। ਅਤੇ ਪੂਰਬ ਵੱਲ ਕਿੰਨਰਥ ਦੀ ਝੀਲ ਦੇ ਕੰਢੇ ਤੱਕ ਪਹੁੰਚ ਕੇ ਤੁਹਾਡੀ ਹੱਦ ਪੱਛਮ ਨੂੰ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("NU34_12","005_34_12","NUM","34","12","12","ਅਤੇ ਹੱਦ ਯਰਦਨ ਤੱਕ ਹੇਠਾਂ ਜਾਵੇ ਅਤੇ ਉਹ ਦਾ ਫੈਲਾਓ ਖਾਰੇ ਸਮੁੰਦਰ ਤੱਕ ਹੋਵੇ। ਇਹ ਤੁਹਾਡੀ ਧਰਤੀ ਦੇ ਆਲੇ-ਦੁਆਲੇ ਦੀਆਂ ਹੱਦਾਂ ਹੋਣ। ");
INSERT INTO pan_vpl VALUES ("NU34_13","005_34_13","NUM","34","13","13","ਫੇਰ ਮੂਸਾ ਨੇ ਇਸਰਾਏਲੀਆਂ ਨੂੰ ਹੁਕਮ ਦੇ ਕੇ ਆਖਿਆ, ਇਹ ਉਹ ਦੇਸ ਹੈ ਜਿਸ ਦਾ ਅਧਿਕਾਰ ਤੁਸੀਂ ਪਰਚੀਆਂ ਪਾ ਕੇ ਲਵੋਗੇ ਜਿਵੇਂ ਤੁਹਾਨੂੰ ਯਹੋਵਾਹ ਨੇ ਹੁਕਮ ਦਿੱਤਾ ਕਿ ਉਹ ਉਨ੍ਹਾਂ ਨੌਂ ਗੋਤਾਂ ਨੂੰ ਅਤੇ ਉਸ ਅੱਧੇ ਗੋਤ ਨੂੰ ਦਿੱਤੀ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("NU34_14","005_34_14","NUM","34","14","14","ਕਿਉਂ ਜੋ ਰਊਬੇਨੀਆਂ ਦੇ ਗੋਤ ਨੇ ਆਪਣਿਆਂ ਪੁਰਖਿਆਂ ਦੇ ਘਰਾਣਿਆਂ ਅਨੁਸਾਰ ਅਤੇ ਗਾਦੀਆਂ ਨੇ ਆਪਣਿਆਂ ਪੁਰਖਿਆਂ ਦੇ ਘਰਾਣਿਆਂ ਅਨੁਸਾਰ ਅਤੇ ਮਨੱਸ਼ਹ ਦੇ ਅੱਧੇ ਗੋਤ ਨੇ ਆਪਣੀ ਜ਼ਮੀਨ ਨੂੰ ਪਾ ਲਿਆ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("NU34_15","005_34_15","NUM","34","15","15","ਇਨ੍ਹਾਂ ਦੋਹਾਂ ਗੋਤਾਂ ਨੇ ਅਤੇ ਅੱਧੇ ਗੋਤ ਨੇ ਆਪਣੀ ਜ਼ਮੀਨ ਨੂੰ ਯਰਦਨ ਪਾਰ ਯਰੀਹੋ ਕੋਲ, ਪੂਰਬ ਦਿਸ਼ਾ ਵੱਲ ਪਾ ਲਿਆ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("NU34_16","005_34_16","NUM","34","16","16","ਫੇਰ ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਆਖਿਆ, ");
INSERT INTO pan_vpl VALUES ("NU34_17","005_34_17","NUM","34","17","17","ਇਹ ਉਨ੍ਹਾਂ ਮਨੁੱਖਾਂ ਦੇ ਨਾਮ ਹਨ ਜੋ ਤੁਹਾਡੇ ਲਈ ਦੇਸ ਦੀ ਜ਼ਮੀਨ ਵੰਡਣ। ਅਲਆਜ਼ਾਰ ਜਾਜਕ ਅਤੇ ਨੂਨ ਦਾ ਪੁੱਤਰ ਯਹੋਸ਼ੁਆ। ");
INSERT INTO pan_vpl VALUES ("NU34_18","005_34_18","NUM","34","18","18","ਨਾਲੇ ਤੁਸੀਂ ਹਰ ਗੋਤ ਤੋਂ ਇੱਕ-ਇੱਕ ਪ੍ਰਧਾਨ ਦੇਸ ਦੀ ਜ਼ਮੀਨ ਵੰਡਣ ਲਈ ਲਿਓ। ");
INSERT INTO pan_vpl VALUES ("NU34_19","005_34_19","NUM","34","19","19","ਅਤੇ ਇਹ ਉਨ੍ਹਾਂ ਮਨੁੱਖਾਂ ਦੇ ਨਾਮ ਹੋਣ, ਯਹੂਦਾਹ ਦੇ ਗੋਤ ਲਈ ਯਫ਼ੁੰਨਹ ਦਾ ਪੁੱਤਰ ਕਾਲੇਬ ");
INSERT INTO pan_vpl VALUES ("NU34_20","005_34_20","NUM","34","20","20","ਸ਼ਿਮਓਨੀਆਂ ਦੇ ਗੋਤ ਲਈ ਅੰਮੀਹੂਦ ਦਾ ਪੁੱਤਰ ਸ਼ਮੂਏਲ ");
INSERT INTO pan_vpl VALUES ("NU34_21","005_34_21","NUM","34","21","21","ਬਿਨਯਾਮੀਨ ਦੇ ਗੋਤ ਲਈ ਕਿਸਲੋਨ ਦਾ ਪੁੱਤਰ ਅਲੀਦਾਦ ");
INSERT INTO pan_vpl VALUES ("NU34_22","005_34_22","NUM","34","22","22","ਦਾਨੀਆਂ ਦੇ ਗੋਤ ਲਈ ਇੱਕ ਪ੍ਰਧਾਨ ਯਾਗਲੀ ਦਾ ਪੁੱਤਰ ਬੁੱਕੀ ");
INSERT INTO pan_vpl VALUES ("NU34_23","005_34_23","NUM","34","23","23","ਯੂਸੁਫ਼ ਦੇ ਪੁੱਤਰਾਂ ਵਿੱਚੋਂ ਮਨੱਸ਼ੀਆਂ ਦੇ ਗੋਤ ਲਈ ਇੱਕ ਪ੍ਰਧਾਨ ਏਫ਼ੋਦ ਦਾ ਪੁੱਤਰ ਹੰਨੀਏਲ ");
INSERT INTO pan_vpl VALUES ("NU34_24","005_34_24","NUM","34","24","24","ਅਤੇ ਇਫ਼ਰਾਈਮੀਆਂ ਦੇ ਗੋਤ ਲਈ ਇੱਕ ਪ੍ਰਧਾਨ ਸ਼ਿਫ਼ਟਾਨ ਦਾ ਪੁੱਤਰ ਕਮੂਏਲ ");
INSERT INTO pan_vpl VALUES ("NU34_25","005_34_25","NUM","34","25","25","ਅਤੇ ਜ਼ਬੂਲੁਨੀਆਂ ਦੇ ਗੋਤ ਲਈ ਇੱਕ ਪ੍ਰਧਾਨ ਪਰਨਾਕ ਦਾ ਪੁੱਤਰ ਅਲੀਸਾਫ਼ਾਨ ");
INSERT INTO pan_vpl VALUES ("NU34_26","005_34_26","NUM","34","26","26","ਅਤੇ ਯਿੱਸਾਕਾਰੀਆਂ ਦੇ ਗੋਤ ਲਈ ਇੱਕ ਪ੍ਰਧਾਨ ਅੱਜ਼ਾਨ ਦਾ ਪੁੱਤਰ ਪਲਟੀਏਲ ");
INSERT INTO pan_vpl VALUES ("NU34_27","005_34_27","NUM","34","27","27","ਅਤੇ ਆਸ਼ੇਰੀਆਂ ਦੇ ਗੋਤ ਲਈ ਇੱਕ ਪ੍ਰਧਾਨ ਸ਼ਲੋਮੀ ਦਾ ਪੁੱਤਰ ਅਹੀਹੂਦ ");
INSERT INTO pan_vpl VALUES ("NU34_28","005_34_28","NUM","34","28","28","ਅਤੇ ਨਫ਼ਤਾਲੀਆਂ ਦੇ ਗੋਤ ਲਈ ਇੱਕ ਪ੍ਰਧਾਨ ਅੰਮੀਹੂਦ ਦਾ ਪੁੱਤਰ ਪਦਹੇਲ ");
INSERT INTO pan_vpl VALUES ("NU34_29","005_34_29","NUM","34","29","29","ਇਹ ਉਹ ਹਨ ਜਿਨ੍ਹਾਂ ਨੂੰ ਯਹੋਵਾਹ ਨੇ ਹੁਕਮ ਦਿੱਤਾ ਸੀ ਕਿ ਉਹ ਇਸਰਾਏਲੀਆਂ ਲਈ ਕਨਾਨ ਦੇਸ ਦੀ ਜ਼ਮੀਨ ਵੰਡਣ। ");
INSERT INTO pan_vpl VALUES ("NU35_1","005_35_1","NUM","35","1","1","ਫੇਰ ਯਹੋਵਾਹ ਮੋਆਬ ਦੇ ਮੈਦਾਨ ਵਿੱਚ ਯਰਦਨ ਉੱਤੇ ਯਰੀਹੋ ਕੋਲ ਮੂਸਾ ਨੂੰ ਬੋਲਿਆ, ");
INSERT INTO pan_vpl VALUES ("NU35_2","005_35_2","NUM","35","2","2","ਇਸਰਾਏਲੀਆਂ ਨੂੰ ਹੁਕਮ ਦੇ, ਕਿ ਉਹ ਲੇਵੀਆਂ ਨੂੰ ਆਪਣੇ ਕਬਜ਼ੇ ਦੀ ਜ਼ਮੀਨ ਵਿੱਚੋਂ ਰਹਿਣ ਲਈ ਨਗਰ ਦੇਣ ਅਤੇ ਨਗਰਾਂ ਦੇ ਦੁਆਲੇ ਦੀ ਸ਼ਾਮਲਾਟ ਲੇਵੀਆਂ ਨੂੰ ਦੇਣ। ");
INSERT INTO pan_vpl VALUES ("NU35_3","005_35_3","NUM","35","3","3","ਨਗਰ ਉਨ੍ਹਾਂ ਦੇ ਰਹਿਣ ਲਈ ਅਤੇ ਸ਼ਾਮਲਾਟ ਉਨ੍ਹਾਂ ਦੇ ਪਸ਼ੂਆਂ ਲਈ, ਉਨ੍ਹਾਂ ਦੇ ਸਭ ਕੁਝ ਲਈ ਅਤੇ ਉਨ੍ਹਾਂ ਦੇ ਜਾਨਵਰਾਂ ਲਈ ਹੋਵੇ। ");
INSERT INTO pan_vpl VALUES ("NU35_4","005_35_4","NUM","35","4","4","ਅਤੇ ਨਗਰਾਂ ਦੀ ਸ਼ਾਮਲਾਟ ਜਿਹੜੀ ਤੁਸੀਂ ਲੇਵੀਆਂ ਨੂੰ ਦਿਓ ਨਗਰ ਦੀਆਂ ਕੰਧਾਂ ਤੋਂ ਲੈ ਕੇ ਬਾਹਰ ਵੱਲ ਆਲੇ-ਦੁਆਲੇ ਇੱਕ-ਇੱਕ ਹਜ਼ਾਰ ਹੱਥ ਹੋਵੇ। ");
INSERT INTO pan_vpl VALUES ("NU35_5","005_35_5","NUM","35","5","5","ਤੁਸੀਂ ਨਗਰ ਤੋਂ ਬਾਹਰ ਪੂਰਬ ਦੇ ਪਾਸੇ ਵੱਲ ਦੋ ਹਜ਼ਾਰ ਹੱਥ ਮਿਣੋ, ਦੱਖਣ ਦੇ ਪਾਸੇ ਵੱਲ ਦੋ ਹਜ਼ਾਰ, ਲਹਿੰਦੇ ਪਾਸੇ ਦੋ ਹਜ਼ਾਰ ਅਤੇ ਉੱਤਰ ਦੇ ਪਾਸੇ ਵੱਲ ਦੋ ਹਜ਼ਾਰ ਹੱਥ ਅਤੇ ਨਗਰ ਵਿਚਕਾਰ ਹੋਵੇ। ਇਹ ਉਨ੍ਹਾਂ ਦੇ ਨਗਰਾਂ ਦੀਆਂ ਸ਼ਾਮਲਾਟਾਂ ਹੋਣ। ");
INSERT INTO pan_vpl VALUES ("NU35_6","005_35_6","NUM","35","6","6","ਜਿਹੜੇ ਨਗਰ ਤੁਸੀਂ ਲੇਵੀਆਂ ਨੂੰ ਦਿਓਗੇ ਉਹ ਛੇ ਨਗਰ ਪਨਾਹ ਦੇ ਨਗਰ ਹੋਣ ਜਿਨ੍ਹਾਂ ਨੂੰ ਤੁਸੀਂ ਖੂਨੀ ਦੇ ਭੱਜ ਜਾਣ ਲਈ ਠਹਿਰਾਓ ਅਤੇ ਉਨ੍ਹਾਂ ਤੋਂ ਬਿਨ੍ਹਾਂ ਤੁਸੀਂ ਬਿਆਲੀ ਨਗਰ ਹੋਰ ਦਿਓ। ");
INSERT INTO pan_vpl VALUES ("NU35_7","005_35_7","NUM","35","7","7","ਸੋ ਸਾਰੇ ਨਗਰ ਜਿਹੜੇ ਤੁਸੀਂ ਲੇਵੀਆਂ ਨੂੰ ਦਿਓ ਅਠਤਾਲੀ ਨਗਰ ਸ਼ਾਮਲਾਟ ਨਾਲ ਹੋਣ। ");
INSERT INTO pan_vpl VALUES ("NU35_8","005_35_8","NUM","35","8","8","ਅਤੇ ਉਹ ਨਗਰ ਜਿਹੜੇ ਤੁਸੀਂ ਇਸਰਾਏਲੀਆਂ ਦੀ ਜ਼ਮੀਨ ਤੋਂ ਦੇਣੇ ਉਹ ਬਹੁਤਿਆਂ ਵਿੱਚੋਂ ਬਹੁਤੇ ਅਤੇ ਥੋੜ੍ਹਿਆਂ ਵਿੱਚੋਂ ਥੋੜ੍ਹੇ ਦਿਓ। ਹਰ ਇੱਕ ਆਪਣੀ ਜ਼ਮੀਨ ਅਨੁਸਾਰ ਜਿਹੜੀ ਉਹ ਨੂੰ ਮਿਲੀ ਹੈ ਆਪਣੇ ਨਗਰਾਂ ਵਿੱਚੋਂ ਲੇਵੀਆਂ ਨੂੰ ਦੇਵੇ। ");
INSERT INTO pan_vpl VALUES ("NU35_9","005_35_9","NUM","35","9","9","ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਨੂੰ ਆਖਿਆ, ");
INSERT INTO pan_vpl VALUES ("NU35_10","005_35_10","NUM","35","10","10","ਇਸਰਾਏਲੀਆਂ ਨਾਲ ਗੱਲ ਕਰ ਅਤੇ ਉਨ੍ਹਾਂ ਨੂੰ ਆਖ, ਜਦ ਤੁਸੀਂ ਕਨਾਨ ਦੇਸ ਨੂੰ ਯਰਦਨ ਪਾਰ ਲੰਘੋ ");
INSERT INTO pan_vpl VALUES ("NU35_11","005_35_11","NUM","35","11","11","ਤਾਂ ਤੁਸੀਂ ਆਪਣੇ ਲਈ ਨਗਰ ਠਹਿਰਾਓ ਜਿਹੜੇ ਤੁਹਾਡੇ ਲਈ ਪਨਾਹ ਦੇ ਨਗਰ ਹੋਣ ਜਿੱਥੇ ਖੂਨੀ ਭੱਜ ਜਾਵੇ ਜਿਸ ਕਿਸੇ ਨੂੰ ਭੁੱਲ ਨਾਲ ਮਾਰਿਆ ਹੋਵੇ। ");
INSERT INTO pan_vpl VALUES ("NU35_12","005_35_12","NUM","35","12","12","ਅਤੇ ਇਹ ਨਗਰ ਤੁਹਾਡੇ ਲਈ ਬਦਲਾ ਲੈਣ ਵਾਲੇ ਤੋਂ ਪਨਾਹ ਲਈ ਹੋਣ ਤਾਂ ਜੋ ਖੂਨੀ ਮਰ ਨਾ ਜਾਵੇ ਜਿੰਨਾਂ ਚਿਰ ਉਹ ਮੰਡਲੀ ਦੇ ਅੱਗੇ ਨਿਆਂ ਲਈ ਖੜ੍ਹਾ ਨਾ ਕੀਤਾ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("NU35_13","005_35_13","NUM","35","13","13","ਅਤੇ ਜਿਹੜੇ ਨਗਰ ਤੁਸੀਂ ਦਿਓ ਉਹ ਤੁਹਾਡੇ ਲਈ ਛੇ ਨਗਰ ਪਨਾਹ ਦੇ ਨਗਰ ਹੋਣ। ");
INSERT INTO pan_vpl VALUES ("NU35_14","005_35_14","NUM","35","14","14","ਤਿੰਨ ਨਗਰ ਯਰਦਨ ਤੋਂ ਪਾਰ ਅਤੇ ਤਿੰਨ ਨਗਰ ਕਨਾਨ ਦੇਸ ਵਿੱਚ ਠਹਿਰਾਓ ਅਤੇ ਉਹ ਪਨਾਹ ਦੇ ਨਗਰ ਹੋਣ। ");
INSERT INTO pan_vpl VALUES ("NU35_15","005_35_15","NUM","35","15","15","ਇਸਰਾਏਲੀਆਂ ਲਈ, ਪਰਦੇਸੀਆਂ ਲਈ ਅਤੇ ਉਸ ਲਈ ਜਿਹੜਾ ਉਨ੍ਹਾਂ ਵਿੱਚ ਵੱਸਦਾ ਹੋਵੇ ਇਹ ਛੇ ਨਗਰ ਪਨਾਹ ਲਈ ਹੋਣ ਤਾਂ ਜੋ ਜੇ ਕੋਈ ਕਿਸੇ ਨੂੰ ਭੁੱਲ ਨਾਲ ਮਾਰ ਦੇਵੇ ਉਹ ਉੱਥੇ ਭੱਜ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("NU35_16","005_35_16","NUM","35","16","16","ਪਰ ਜੇ ਉਸ ਨੇ ਕਿਸੇ ਨੂੰ ਲੋਹੇ ਦੇ ਕਿਸੇ ਹਥਿਆਰ ਨਾਲ ਮਾਰਿਆ ਹੋਵੇ ਕਿ ਉਹ ਮਰ ਗਿਆ ਹੋਵੇ ਤਾਂ ਉਹ ਖੂਨੀ ਹੈ ਅਤੇ ਉਹ ਖੂਨੀ ਜ਼ਰੂਰ ਮਾਰਿਆ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("NU35_17","005_35_17","NUM","35","17","17","ਜਿਸ ਨੇ ਹੱਥ ਵਿੱਚ ਪੱਥਰ ਲੈ ਕੇ ਜਿਸ ਤੋਂ ਕੋਈ ਮਰ ਸਕੇ ਕਿਸੇ ਨੂੰ ਮਾਰਿਆ ਹੋਵੇ ਅਤੇ ਉਹ ਮਰ ਗਿਆ ਹੋਵੇ ਤਾਂ ਉਹ ਖੂਨੀ ਹੈ। ਉਹ ਖੂਨੀ ਜ਼ਰੂਰ ਮਾਰਿਆ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("NU35_18","005_35_18","NUM","35","18","18","ਜਾਂ ਜੇ ਉਸ ਨੇ ਲੱਕੜੀ ਦੇ ਹਥਿਆਰ ਨੂੰ ਹੱਥ ਵਿੱਚ ਲੈ ਕੇ ਜਿਸ ਤੋਂ ਕੋਈ ਮਰ ਸਕੇ ਉਹ ਨੂੰ ਮਾਰਿਆ ਹੋਵੇ ਅਤੇ ਉਹ ਮਰ ਗਿਆ ਹੋਵੇ ਤਾਂ ਉਹ ਖੂਨੀ ਹੈ। ਉਹ ਖੂਨੀ ਜ਼ਰੂਰ ਮਾਰਿਆ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("NU35_19","005_35_19","NUM","35","19","19","ਖੂਨ ਦਾ ਬਦਲਾ ਲੈਣ ਵਾਲਾ ਆਪ ਉਸ ਖੂਨੀ ਨੂੰ ਮਾਰੇ ਜਦ ਉਹ ਉਸ ਨੂੰ ਲੱਭੇ ਤਾਂ ਉਹ ਉਸ ਨੂੰ ਮਾਰ ਸੁੱਟੇ। ");
INSERT INTO pan_vpl VALUES ("NU35_20","005_35_20","NUM","35","20","20","ਜੇ ਕੋਈ ਕਿਸੇ ਨੂੰ ਵੈਰ ਨਾਲ ਧੱਕਾ ਮਾਰੇ ਜਾਂ ਘਾਤ ਲਾ ਕੇ ਉਸ ਉੱਤੇ ਕੁਝ ਸੁੱਟਿਆ ਹੋਵੇ ਕਿ ਉਹ ਮਰ ਗਿਆ ਹੋਵੇ ");
INSERT INTO pan_vpl VALUES ("NU35_21","005_35_21","NUM","35","21","21","ਜਾਂ ਦੁਸ਼ਮਣੀ ਨਾਲ ਆਪਣੇ ਹੱਥੀਂ ਮਾਰੇ ਕਿ ਉਹ ਮਰ ਜਾਵੇ ਤਾਂ ਮਾਰਨ ਵਾਲਾ ਜ਼ਰੂਰ ਮਾਰਿਆ ਜਾਵੇ, ਉਹ ਖੂਨੀ ਹੈ। ਬਦਲਾ ਲੈਣ ਵਾਲਾ ਜਦ ਕਦੀ ਉਹ ਲੱਭੇ ਉਸ ਖੂਨੀ ਨੂੰ ਮਾਰ ਸੁੱਟੇ। ");
INSERT INTO pan_vpl VALUES ("NU35_22","005_35_22","NUM","35","22","22","ਪਰ ਜੇ ਉਸ ਨੇ ਉਹ ਨੂੰ ਅਚਾਨਕ ਦੁਸ਼ਮਣੀ ਤੋਂ ਬਿਨ੍ਹਾਂ ਧੱਕਾ ਮਾਰਿਆ ਹੋਵੇ ਜਾਂ ਉਹ ਦੇ ਉੱਤੇ ਘਾਤ ਲਾਉਣ ਤੋਂ ਬਿਨ੍ਹਾਂ ਕੁਝ ਸੁੱਟਿਆ ਹੋਵੇ। ");
INSERT INTO pan_vpl VALUES ("NU35_23","005_35_23","NUM","35","23","23","ਜਾਂ ਕਿਸੇ ਪੱਥਰ ਨਾਲ ਜਿਸ ਦੇ ਨਾਲ ਕੋਈ ਮਰ ਸਕੇ ਵੇਖੇ ਬਿਨ੍ਹਾਂ ਉਹ ਦੇ ਉੱਤੇ ਸੁੱਟਿਆ ਹੋਵੇ ਅਤੇ ਉਹ ਮਰ ਜਾਵੇ ਅਤੇ ਉਹ ਉਸ ਦਾ ਵੈਰੀ ਨਹੀਂ ਸੀ ਨਾ ਉਹ ਉਸ ਦਾ ਨੁਕਸਾਨ ਚਾਹੁੰਦਾ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("NU35_24","005_35_24","NUM","35","24","24","ਤਾਂ ਮੰਡਲੀ ਨੂੰ ਮਾਰਨ ਵਾਲਾ ਅਤੇ ਖੂਨ ਦਾ ਬਦਲਾ ਲੈਣ ਵਾਲਾ ਇਨ੍ਹਾਂ ਨਿਯਮਾਂ ਦੇ ਅਨੁਸਾਰ ਫ਼ੈਸਲਾ ਕਰੇ। ");
INSERT INTO pan_vpl VALUES ("NU35_25","005_35_25","NUM","35","25","25","ਅਤੇ ਮੰਡਲੀ ਉਸ ਖੂਨੀ ਨੂੰ ਬਦਲਾ ਲੈਣ ਵਾਲੇ ਦੇ ਹੱਥੋਂ ਛੁਡਾ ਕੇ, ਉਸ ਨੂੰ ਉਸ ਦੇ ਪਨਾਹ ਦੇ ਨਗਰ ਵਿੱਚ ਮੋੜ ਦੇਵੇ ਜਿੱਥੇ ਨੂੰ ਉਹ ਭੱਜ ਗਿਆ ਸੀ ਅਤੇ ਉਸ ਵਿੱਚ ਪ੍ਰਧਾਨ ਜਾਜਕ ਦੀ ਮੌਤ ਤੱਕ ਜਿਹੜਾ ਪਵਿੱਤਰ ਤੇਲ ਨਾਲ ਮਸਹ ਹੋਇਆ ਹੈ, ਵੱਸੇ। ");
INSERT INTO pan_vpl VALUES ("NU35_26","005_35_26","NUM","35","26","26","ਅਤੇ ਜੇ ਕਦੀ ਉਹ ਖੂਨੀ ਪਨਾਹ ਦੇ ਨਗਰ ਦੀ ਹੱਦ ਤੋਂ ਬਾਹਰ ਜਿੱਥੇ ਨੂੰ ਉਹ ਨੱਠਾ ਸੀ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("NU35_27","005_35_27","NUM","35","27","27","ਅਤੇ ਖੂਨ ਦਾ ਬਦਲਾ ਲੈਣ ਵਾਲਾ ਉਸ ਨੂੰ ਪਨਾਹ ਦੇ ਨਗਰ ਦੀ ਹੱਦੋਂ ਬਾਹਰ ਮਿਲੇ ਅਤੇ ਖੂਨ ਦਾ ਬਦਲਾ ਲੈਣ ਉਸ ਖੂਨੀ ਨੂੰ ਮਾਰ ਦੇਵੇ ਤਾਂ ਉਹ ਖੂਨ ਦਾ ਦੋਸ਼ੀ ਨਾ ਹੋਵੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("NU35_28","005_35_28","NUM","35","28","28","ਕਿਉਂ ਜੋ ਉਸ ਨੂੰ ਚਾਹੀਦਾ ਸੀ ਕਿ ਪ੍ਰਧਾਨ ਜਾਜਕ ਦੀ ਮੌਤ ਤੱਕ ਆਪਣੇ ਪਨਾਹ ਦੇ ਨਗਰ ਵਿੱਚ ਰਹਿੰਦਾ, ਪਰ ਪ੍ਰਧਾਨ ਜਾਜਕ ਦੀ ਮੌਤ ਪਿੱਛੋਂ ਉਹ ਖੂਨੀ ਆਪਣੀ ਜ਼ਮੀਨ ਦੀ ਧਰਤੀ ਵਿੱਚ ਮੁੜ ਜਾਵੇ ");
INSERT INTO pan_vpl VALUES ("NU35_29","005_35_29","NUM","35","29","29","ਅਤੇ ਇਹ ਤੁਹਾਡੇ ਲਈ ਨਿਆਂ ਦੀ ਬਿਧੀ ਪੀੜ੍ਹੀਓਂ ਪੀੜ੍ਹੀ ਤੁਹਾਡੀਆਂ ਸਾਰੀਆਂ ਰਹਿਣ ਦੀਆਂ ਥਾਵਾਂ ਵਿੱਚ ਹੋਵੇ। ");
INSERT INTO pan_vpl VALUES ("NU35_30","005_35_30","NUM","35","30","30","ਜੇ ਕੋਈ ਕਿਸੇ ਮਨੁੱਖ ਨੂੰ ਮਾਰੇ, ਉਹ ਗਵਾਹਾਂ ਦੀ ਗਵਾਹੀ ਨਾਲ ਮਾਰਿਆ ਜਾਵੇ, ਪਰ ਇੱਕੋ ਹੀ ਗਵਾਹ ਦੀ ਗਵਾਹੀ ਤੋਂ ਕੋਈ ਨਾ ਮਾਰਿਆ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("NU35_31","005_35_31","NUM","35","31","31","ਤੁਸੀਂ ਕਿਸੇ ਖੂਨੀ ਦੀ ਜਾਨ ਦਾ ਜੁਰਮਾਨਾ ਨਾ ਲਓ, ਜੋ ਮੌਤ ਦਾ ਦੋਸ਼ੀ ਹੋਵੇ। ਉਹ ਜ਼ਰੂਰ ਮਾਰਿਆ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("NU35_32","005_35_32","NUM","35","32","32","ਜਿਹੜਾ ਆਪਣੇ ਪਨਾਹ ਨਗਰ ਨੂੰ ਭੱਜ ਗਿਆ ਹੋਵੇ ਅਤੇ ਮੁੜ ਕੇ ਆਪਣੇ ਦੇਸ ਵਿੱਚ ਜਾਜਕ ਦੀ ਮੌਤ ਤੋਂ ਪਹਿਲਾਂ ਆ ਵੱਸੇ ਉਸ ਤੋਂ ਤੁਸੀਂ ਕੋਈ ਜੁਰਮਾਨਾ ਉਸ ਦੇ ਬਦਲੇ ਨਾ ਲਓ। ");
INSERT INTO pan_vpl VALUES ("NU35_33","005_35_33","NUM","35","33","33","ਤੁਸੀਂ ਉਸ ਜਗ੍ਹਾ ਨੂੰ ਭਰਿਸ਼ਟ ਨਾ ਕਰੋ ਜਿਸ ਦੇ ਵਿੱਚ ਤੁਸੀਂ ਵੱਸਦੇ ਹੋ, ਕਿਉਂ ਜੋ ਜ਼ਮੀਨ ਖੂਨ ਦੇ ਨਾਲ ਭਰਿਸ਼ਟ ਹੋ ਜਾਂਦੀ ਹੈ ਅਤੇ ਜਿਸ ਨਗਰ ਵਿੱਚ ਖੂਨ ਵਹਾਇਆ ਜਾਵੇ ਤਾਂ ਉਸ ਖੂਨ ਵਹਾਉਣ ਵਾਲੇ ਦੇ ਖੂਨ ਨਾਲ ਹੀ ਉਸ ਜ਼ਮੀਨ ਦਾ ਪ੍ਰਾਸਚਿਤ ਹੋ ਸਕਦਾ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("NU35_34","005_35_34","NUM","35","34","34","ਜਿਸ ਦੇਸ ਵਿੱਚ ਤੁਸੀਂ ਵਾਸ ਕਰੋਗੇ ਮੈਂ ਤੁਹਾਡੇ ਵਿਚਕਾਰ ਵੱਸਾਂਗਾ, ਉਸ ਨਗਰ ਨੂੰ ਤੁਸੀਂ ਭਰਿਸ਼ਟ ਨਾ ਕਰਨਾ, ਕਿਉਂ ਜੋ ਮੈਂ ਯਹੋਵਾਹ ਇਸਰਾਏਲੀਆਂ ਵਿੱਚ ਵੱਸਦਾ ਹਾਂ। ");
INSERT INTO pan_vpl VALUES ("NU36_1","005_36_1","NUM","36","1","1","ਪੁਰਖਿਆਂ ਦੇ ਘਰਾਣਿਆਂ ਦੇ ਮੁਖੀਆਂ ਨੇ, ਜਿਹੜੇ ਯੂਸੁਫ਼ ਦੇ ਪੁੱਤਰਾਂ ਦੇ ਟੱਬਰ ਵਿੱਚ ਮਨੱਸ਼ੀ ਮਾਕੀਰ ਦੇ ਪੁੱਤਰ, ਗਿਲਆਦ ਦੇ ਪੁੱਤਰਾਂ ਦੇ ਟੱਬਰ ਤੋਂ ਸਨ, ਨੇੜੇ ਆ ਕੇ ਮੂਸਾ ਅਤੇ ਉਨ੍ਹਾਂ ਪ੍ਰਧਾਨ ਦੇ ਅੱਗੇ ਜਿਹੜੇ ਇਸਰਾਏਲੀਆਂ ਦੇ ਪੁਰਖਿਆਂ ਦੇ ਘਰਾਣਿਆਂ ਦੇ ਮੁਖੀਏ ਸਨ, ਗੱਲ ਕੀਤੀ। ");
INSERT INTO pan_vpl VALUES ("NU36_2","005_36_2","NUM","36","2","2","ਅਤੇ ਉਨ੍ਹਾਂ ਨੂੰ ਆਖਿਆ ਕਿ ਯਹੋਵਾਹ ਨੇ ਸਾਡੇ ਸੁਆਮੀ ਨੂੰ ਹੁਕਮ ਦਿੱਤਾ ਸੀ ਕਿ ਜ਼ਮੀਨ ਦੀ ਧਰਤੀ ਚਿੱਠੀ ਪਾ ਕੇ ਇਸਰਾਏਲੀਆਂ ਨੂੰ ਦਿੱਤੀ ਜਾਵੇ, ਨਾਲੇ ਸਾਡੇ ਸੁਆਮੀ ਨੂੰ ਯਹੋਵਾਹ ਵੱਲੋਂ ਹੁਕਮ ਮਿਲਿਆ ਸੀ ਕਿ ਸਾਡੇ ਭਰਾ ਸਲਾਫ਼ਹਾਦ ਦੀ ਜ਼ਮੀਨ ਉਸ ਦੀਆਂ ਧੀਆਂ ਨੂੰ ਦਿੱਤੀ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("NU36_3","005_36_3","NUM","36","3","3","ਜੇ ਉਹ ਇਸਰਾਏਲੀਆਂ ਦੇ ਕਿਸੇ ਹੋਰ ਗੋਤ ਦੇ ਮਨੁੱਖਾਂ ਨਾਲ ਵਿਆਹੀਆਂ ਜਾਣ ਤਾਂ ਉਨ੍ਹਾਂ ਦਾ ਹਿੱਸਾ ਸਾਡੇ ਪੁਰਖਿਆਂ ਦੀ ਜ਼ਮੀਨ ਤੋਂ ਖ਼ਤਮ ਹੋ ਜਾਵੇਗਾ ਅਤੇ ਉਹ ਉਸ ਗੋਤ ਨੂੰ ਦਿੱਤਾ ਜਾਵੇਗਾ ਜਿਹ ਦੀਆਂ ਉਹ ਹੋ ਜਾਣਗੀਆਂ ਅਤੇ ਸਾਡਾ ਹਿੱਸਾ ਘੱਟ ਜਾਵੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("NU36_4","005_36_4","NUM","36","4","4","ਜਦ ਇਸਰਾਏਲੀਆਂ ਦੇ ਅਨੰਦ ਦਾ ਸਾਲ ਆਵੇਗਾ ਤਾਂ ਉਨ੍ਹਾਂ ਦੀ ਜ਼ਮੀਨ, ਉਸ ਗੋਤ ਦੀ ਜ਼ਮੀਨ ਨਾਲ ਰਲ ਜਾਵੇਗੀ ਜਿਸ ਵਿੱਚ ਉਹ ਵਿਆਹੀਆਂ ਜਾਣਗੀਆਂ। ਐਉਂ ਉਨ੍ਹਾਂ ਦਾ ਹਿੱਸਾ ਸਾਡੇ ਪੁਰਖਿਆਂ ਦੇ ਗੋਤ ਦੀ ਜ਼ਮੀਨ ਤੋਂ ਨਿੱਕਲ ਜਾਵੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("NU36_5","005_36_5","NUM","36","5","5","ਤਦ ਮੂਸਾ ਨੇ ਇਸਰਾਏਲੀਆਂ ਨੂੰ ਯਹੋਵਾਹ ਦੇ ਹੁਕਮ ਨਾਲ ਆਖਿਆ ਕਿ ਯੂਸੁਫ਼ ਦੇ ਪੁੱਤਰਾਂ ਦਾ ਗੋਤ ਠੀਕ ਆਖਦਾ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("NU36_6","005_36_6","NUM","36","6","6","ਇਹ ਉਹ ਗੱਲ ਹੈ ਜਿਹ ਦਾ ਯਹੋਵਾਹ ਨੇ ਸਲਾਫ਼ਹਾਦ ਦੀਆਂ ਧੀਆਂ ਦੇ ਵਿਖੇ ਹੁਕਮ ਦਿੱਤਾ ਸੀ, ਜਿਹੜਾ ਉਨ੍ਹਾਂ ਦੀਆਂ ਅੱਖਾਂ ਵਿੱਚ ਚੰਗਾ ਦਿੱਸੇ ਉਹ ਉਸ ਦੇ ਨਾਲ ਵਿਆਹ ਕਰ ਲੈਣ, ਪਰ ਕੇਵਲ ਆਪਣੇ ਪੁਰਖਿਆਂ ਦੇ ਗੋਤ ਦੇ ਟੱਬਰਾਂ ਵਿੱਚ ਵਿਆਹ ਕਰਾਉਣ। ");
INSERT INTO pan_vpl VALUES ("NU36_7","005_36_7","NUM","36","7","7","ਅਜਿਹਾ ਹੋਵੇ ਜੋ ਇਸਰਾਏਲੀਆਂ ਦੀ ਜ਼ਮੀਨ, ਇੱਕ ਗੋਤ ਤੋਂ ਦੂਜੇ ਗੋਤ ਵਿੱਚ ਨਾ ਚਲੀ ਜਾਵੇ ਤਾਂ ਜੋ ਹਰ ਇਸਰਾਏਲੀ ਆਪਣੇ ਪੁਰਖਿਆਂ ਦੇ ਗੋਤ ਦੀ ਜ਼ਮੀਨ ਵਿੱਚ ਬਣਿਆ ਰਹੇ। ");
INSERT INTO pan_vpl VALUES ("NU36_8","005_36_8","NUM","36","8","8","ਅਤੇ ਹਰ ਇੱਕ ਧੀ ਜਿਹੜੀ ਇਸਰਾਏਲੀਆਂ ਦੇ ਕਿਸੇ ਗੋਤ ਵਿੱਚ ਜ਼ਮੀਨ ਲਵੇ, ਆਪਣੇ ਪੁਰਖਿਆਂ ਦੇ ਗੋਤ ਦੇ ਟੱਬਰਾਂ ਵਿੱਚ ਵਿਆਹੀ ਜਾਵੇ ਤਾਂ ਜੋ ਹਰ ਇਸਰਾਏਲੀ ਆਪਣੇ ਪੁਰਖਿਆਂ ਦੀ ਜ਼ਮੀਨ ਦੀ ਵਿਰਾਸਤ ਨੂੰ ਲਵੇ। ");
INSERT INTO pan_vpl VALUES ("NU36_9","005_36_9","NUM","36","9","9","ਇਸ ਤਰ੍ਹਾਂ ਕੋਈ ਜ਼ਮੀਨ, ਇੱਕ ਗੋਤ ਤੋਂ ਦੂਜੇ ਗੋਤ ਵਿੱਚ ਨਾ ਜਾਵੇਗੀ ਕਿਉਂ ਜੋ ਇਸਰਾਏਲੀਆਂ ਦੇ ਸਾਰੇ ਗੋਤ ਆਪਣੀਆਂ-ਆਪਣੀਆਂ ਜ਼ਮੀਨਾਂ ਵਿੱਚ ਬਣੇ ਰਹਿਣ। ");
INSERT INTO pan_vpl VALUES ("NU36_10","005_36_10","NUM","36","10","10","ਜਿਵੇਂ ਮੂਸਾ ਨੇ ਹੁਕਮ ਦਿੱਤਾ ਸੀ ਓਵੇਂ ਹੀ ਸਲਾਫ਼ਹਾਦ ਦੀਆਂ ਧੀਆਂ ਨੇ ਕੀਤਾ। ");
INSERT INTO pan_vpl VALUES ("NU36_11","005_36_11","NUM","36","11","11","ਅਤੇ ਮਹਲਾਹ, ਤਿਰਸਾਹ, ਹਾਗਲਾਹ, ਮਿਲਕਾਹ, ਅਤੇ ਨੋਆਹ, ਸਲਾਫ਼ਹਾਦ ਦੀਆਂ ਧੀਆਂ ਆਪਣੇ ਚਾਚੇ ਤਾਏ ਦੇ ਪੁੱਤਰਾਂ ਨਾਲ ਵਿਆਹੀਆਂ ਗਈਆਂ। ");
INSERT INTO pan_vpl VALUES ("NU36_12","005_36_12","NUM","36","12","12","ਉਹ ਯੂਸੁਫ਼ ਦੇ ਪੁੱਤਰ ਮਨੱਸ਼ਹ ਦੇ ਪੁੱਤਰਾਂ ਦੇ ਟੱਬਰਾਂ ਵਿੱਚ ਵਿਆਹੀਆਂ ਗਈਆਂ। ਇਸ ਤਰ੍ਹਾਂ ਉਨ੍ਹਾਂ ਦੀ ਜ਼ਮੀਨ ਉਨ੍ਹਾਂ ਦੇ ਪੁਰਖਿਆਂ ਦੇ ਗੋਤ ਵਿੱਚ ਬਣੀ ਰਹੀ। ");
INSERT INTO pan_vpl VALUES ("NU36_13","005_36_13","NUM","36","13","13","ਇਹ ਉਹ ਹੁਕਮ ਅਤੇ ਫ਼ੈਸਲੇ ਹਨ, ਜਿਨ੍ਹਾਂ ਦਾ ਯਹੋਵਾਹ ਨੇ ਮੂਸਾ ਦੇ ਰਾਹੀਂ ਇਸਰਾਏਲੀਆਂ ਨੂੰ ਮੋਆਬ ਦੇ ਮੈਦਾਨ ਵਿੱਚ ਯਰਦਨ ਨਦੀ ਦੇ ਉੱਤੇ ਯਰੀਹੋ ਦੇ ਕੋਲ ਹੁਕਮ ਦਿੱਤਾ ਸੀ।");
INSERT INTO pan_vpl VALUES ("DT1_1","006_1_1","DEU","1","1","1","ਇਹ ਉਹ ਬਚਨ ਹਨ ਜਿਹੜੇ ਮੂਸਾ ਨੇ ਸਾਰੇ ਇਸਰਾਏਲ ਨੂੰ ਯਰਦਨ ਦੇ ਪਾਰ ਉਜਾੜ ਵਿੱਚ ਆਖੇ, ਜੋ ਸੂਫ ਦੇ ਸਾਹਮਣੇ ਦੇ ਅਰਾਬਾਹ ਵਿੱਚ ਪਾਰਾਨ, ਤੋਫਲ, ਲਾਬਾਨ, ਹਸੇਰੋਥ ਅਤੇ ਦੀਜ਼ਾਹਾਬ ਦੇ ਵਿਚਕਾਰ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("DT1_2","006_1_2","DEU","1","2","2","ਹੋਰੇਬ ਤੋਂ ਕਾਦੇਸ਼-ਬਰਨੇਆ ਤੱਕ ਸੇਈਰ ਪਰਬਤ ਦਾ ਗਿਆਰ੍ਹਾਂ ਦਿਨ ਦਾ ਸਫ਼ਰ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("DT1_3","006_1_3","DEU","1","3","3","ਅਜਿਹਾ ਹੋਇਆ ਕਿ ਚਾਲੀਵੇਂ ਸਾਲ ਦੇ ਗਿਆਰਵੇਂ ਮਹੀਨੇ ਦੀ ਪਹਿਲੀ ਤਾਰੀਖ਼ ਨੂੰ ਮੂਸਾ ਨੇ ਇਸਰਾਏਲੀਆਂ ਨਾਲ ਉਹ ਸਾਰੀਆਂ ਗੱਲਾਂ ਕੀਤੀਆਂ, ਜਿਨ੍ਹਾਂ ਦਾ ਯਹੋਵਾਹ ਨੇ ਉਸ ਨੂੰ ਉਨ੍ਹਾਂ ਦੇ ਲਈ ਹੁਕਮ ਦਿੱਤਾ ਸੀ, ");
INSERT INTO pan_vpl VALUES ("DT1_4","006_1_4","DEU","1","4","4","ਅਰਥਾਤ ਜਦ ਮੂਸਾ ਨੇ ਅਮੋਰੀਆਂ ਦੇ ਰਾਜਾ ਸੀਹੋਨ ਨੂੰ ਜਿਹੜਾ ਹਸ਼ਬੋਨ ਦਾ ਵਾਸੀ ਸੀ ਅਤੇ ਬਾਸ਼ਾਨ ਦੇ ਰਾਜਾ ਓਗ ਨੂੰ ਜਿਹੜਾ ਅਸ਼ਤਾਰੋਥ ਦਾ ਵਾਸੀ ਸੀ, ਅਦਰਈ ਵਿੱਚ ਮਾਰ ਦਿੱਤਾ, ");
INSERT INTO pan_vpl VALUES ("DT1_5","006_1_5","DEU","1","5","5","ਤਦ ਯਰਦਨ ਦੇ ਪਾਰ ਮੋਆਬ ਦੇ ਦੇਸ਼ ਵਿੱਚ ਮੂਸਾ ਬਿਵਸਥਾ ਦੀ ਵਿਆਖਿਆ ਇਸ ਤਰ੍ਹਾਂ ਕਰਨ ਲੱਗਾ, ");
INSERT INTO pan_vpl VALUES ("DT1_6","006_1_6","DEU","1","6","6","“ਸਾਡੇ ਪਰਮੇਸ਼ੁਰ ਯਹੋਵਾਹ ਨੇ ਹੋਰੇਬ ਵਿੱਚ ਸਾਨੂੰ ਕਿਹਾ ਸੀ, ਤੁਹਾਨੂੰ ਇਸ ਪਰਬਤ ਵਿੱਚ ਰਹਿੰਦੇ ਹੋਏ ਬਹੁਤ ਦਿਨ ਹੋ ਗਏ ਹਨ, ");
INSERT INTO pan_vpl VALUES ("DT1_7","006_1_7","DEU","1","7","7","ਇਸ ਲਈ ਹੁਣ ਤੁਸੀਂ ਇੱਥੋਂ ਕੂਚ ਕਰੋ ਅਤੇ ਅਮੋਰੀਆਂ ਦੇ ਪਹਾੜੀ ਦੇਸ਼ ਨੂੰ ਅਤੇ ਅਰਾਬਾਹ ਦੇ ਨੇੜੇ-ਤੇੜੇ ਦੇ ਸਥਾਨਾਂ ਵਿੱਚ, ਪਹਾੜੀ ਦੇਸ਼ ਵਿੱਚ, ਮੈਦਾਨ ਵਿੱਚ, ਦੱਖਣ ਵੱਲ ਅਤੇ ਸਮੁੰਦਰ ਦੇ ਕੰਢਿਆਂ ਉੱਤੇ, ਲਬਾਨੋਨ ਪਰਬਤ ਵਿੱਚ ਅਤੇ ਵੱਡੇ ਦਰਿਆ ਫ਼ਰਾਤ ਤੱਕ ਰਹਿਣ ਵਾਲੇ ਕਨਾਨੀਆਂ ਦੇ ਦੇਸ਼ ਵਿੱਚ ਚਲੇ ਜਾਓ। ");
INSERT INTO pan_vpl VALUES ("DT1_8","006_1_8","DEU","1","8","8","ਵੇਖੋ, ਮੈਂ ਇਸ ਦੇਸ਼ ਨੂੰ ਤੁਹਾਡੇ ਸਾਹਮਣੇ ਰੱਖ ਦਿੱਤਾ ਹੈ, ਜਿਸ ਦੇਸ਼ ਦੀ ਯਹੋਵਾਹ ਨੇ ਤੁਹਾਡੇ ਪੁਰਖਿਆਂ ਦੇ ਨਾਲ ਅਰਥਾਤ ਅਬਰਾਹਾਮ, ਇਸਹਾਕ ਅਤੇ ਯਾਕੂਬ ਨਾਲ ਸਹੁੰ ਖਾਧੀ ਸੀ ਕਿ ਮੈਂ ਇਸ ਦੇਸ਼ ਨੂੰ ਤੁਹਾਨੂੰ ਅਤੇ ਤੁਹਾਡੇ ਬਾਅਦ ਤੁਹਾਡੇ ਵੰਸ਼ ਨੂੰ ਦਿਆਂਗਾ, ਇਸ ਲਈ ਜਾਓ ਅਤੇ ਇਸ ਦੇਸ਼ ਨੂੰ ਆਪਣੇ ਅਧੀਨ ਕਰ ਲਓ।” ");
INSERT INTO pan_vpl VALUES ("DT1_9","006_1_9","DEU","1","9","9","ਫਿਰ ਉਸੇ ਸਮੇਂ ਮੈਂ ਤੁਹਾਨੂੰ ਕਿਹਾ, “ਮੈਂ ਇਕੱਲਾ ਤੁਹਾਡਾ ਭਾਰ ਨਹੀਂ ਚੁੱਕ ਸਕਦਾ, ");
INSERT INTO pan_vpl VALUES ("DT1_10","006_1_10","DEU","1","10","10","ਕਿਉਂ ਜੋ ਤੁਹਾਡੇ ਪਰਮੇਸ਼ੁਰ ਯਹੋਵਾਹ ਨੇ ਤੁਹਾਨੂੰ ਇਸ ਹੱਦ ਤੱਕ ਵਧਾਇਆ ਹੈ ਕਿ ਵੇਖੋ, ਅੱਜ ਤੁਸੀਂ ਅਕਾਸ਼ ਦੇ ਤਾਰਿਆਂ ਵਾਂਗੂੰ ਹੋ ਗਏ ਹੋ। ");
INSERT INTO pan_vpl VALUES ("DT1_11","006_1_11","DEU","1","11","11","ਯਹੋਵਾਹ ਤੁਹਾਡੇ ਪੁਰਖਿਆਂ ਦਾ ਪਰਮੇਸ਼ੁਰ ਤੁਹਾਨੂੰ ਹਜ਼ਾਰ ਗੁਣਾ ਵਧਾਵੇ ਅਤੇ ਤੁਹਾਨੂੰ ਬਰਕਤ ਦੇਵੇ, ਜਿਵੇਂ ਉਸ ਨੇ ਤੁਹਾਡੇ ਨਾਲ ਵਾਇਦਾ ਕੀਤਾ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("DT1_12","006_1_12","DEU","1","12","12","ਮੈਂ ਇਕੱਲਾ ਕਿਵੇਂ ਤੁਹਾਡੀਆਂ ਮੁਸੀਬਤਾਂ, ਤੁਹਾਡਾ ਭਾਰ ਅਤੇ ਤੁਹਾਡਾ ਕੁੜਕੁੜਾਉਣਾ ਸਹਿਣ ਕਰਾਂ? ");
INSERT INTO pan_vpl VALUES ("DT1_13","006_1_13","DEU","1","13","13","ਤੁਸੀਂ ਆਪਣੇ ਵਿੱਚੋਂ ਬੁੱਧਵਾਨ, ਸਿਆਣੇ ਅਤੇ ਗਿਆਨ ਰੱਖਣ ਵਾਲੇ ਮਨੁੱਖ ਗੋਤਾਂ ਅਨੁਸਾਰ ਚੁਣ ਲਓ ਤਾਂ ਜੋ ਮੈਂ ਉਹਨਾਂ ਨੂੰ ਤੁਹਾਡੇ ਉੱਤੇ ਪ੍ਰਧਾਨ ਠਹਿਰਾਵਾਂ।” ");
INSERT INTO pan_vpl VALUES ("DT1_14","006_1_14","DEU","1","14","14","ਤਦ ਤੁਸੀਂ ਮੈਨੂੰ ਉੱਤਰ ਦੇ ਕੇ ਆਖਿਆ, “ਇਹ ਚੰਗੀ ਗੱਲ ਹੈ, ਜਿਹੜੀ ਤੂੰ ਸਾਨੂੰ ਕਰਨ ਲਈ ਆਖੀ ਹੈ।” ");
INSERT INTO pan_vpl VALUES ("DT1_15","006_1_15","DEU","1","15","15","ਇਸ ਲਈ ਮੈਂ ਤੁਹਾਡੇ ਗੋਤਾਂ ਦੇ ਪ੍ਰਧਾਨਾਂ ਨੂੰ ਲਿਆ ਜਿਹੜੇ ਬੁੱਧਵਾਨ ਅਤੇ ਗਿਆਨੀ ਮਨੁੱਖ ਸਨ ਅਤੇ ਤੁਹਾਡੇ ਉੱਤੇ ਪ੍ਰਧਾਨ ਠਹਿਰਾਇਆ ਅਰਥਾਤ ਹਜ਼ਾਰਾਂ ਦੇ ਪ੍ਰਧਾਨ, ਸੈਂਕੜਿਆਂ ਦੇ ਪ੍ਰਧਾਨ, ਪੰਜਾਹਾਂ ਦੇ ਪ੍ਰਧਾਨ ਅਤੇ ਦਸਾਂ ਦੇ ਪ੍ਰਧਾਨ, ਨਾਲ ਹੀ ਤੁਹਾਡੇ ਗੋਤਾਂ ਦੇ ਆਗੂਆਂ ਨੂੰ ਵੀ ਲਿਆ। ");
INSERT INTO pan_vpl VALUES ("DT1_16","006_1_16","DEU","1","16","16","ਉਸੇ ਵੇਲੇ ਮੈਂ ਤੁਹਾਡੇ ਨਿਆਂਈਆਂ ਨੂੰ ਹੁਕਮ ਦੇ ਕੇ ਆਖਿਆ, “ਆਪਣੇ ਭਰਾਵਾਂ ਦੇ ਵਿਚਕਾਰਲੇ ਝਗੜੇ ਸੁਣੋ ਅਤੇ ਮਨੁੱਖ ਅਤੇ ਉਸ ਦੇ ਭਰਾ ਦਾ ਅਤੇ ਉਸ ਪਰਦੇਸੀ ਦਾ ਜਿਹੜਾ ਤੁਹਾਡੇ ਵਿੱਚ ਰਹਿੰਦਾ ਹੈ, ਧਰਮ ਨਾਲ ਨਿਆਂ ਕਰੋ। ");
INSERT INTO pan_vpl VALUES ("DT1_17","006_1_17","DEU","1","17","17","ਨਿਆਂ ਕਰਨ ਦੇ ਵੇਲੇ ਕਿਸੇ ਦਾ ਪੱਖਪਾਤ ਨਾ ਕਰਿਓ। ਤੁਸੀਂ ਵੱਡੇ-ਛੋਟੇ ਦੀ ਗੱਲ ਨੂੰ ਇੱਕੋ ਜਿਹੀ ਸੁਣਿਓ ਅਤੇ ਤੁਸੀਂ ਮਨੁੱਖ ਦੇ ਮੂੰਹ ਨੂੰ ਵੇਖ ਕੇ ਨਾ ਡਰਿਓ, ਕਿਉਂ ਜੋ ਨਿਆਂ ਪਰਮੇਸ਼ੁਰ ਦਾ ਹੈ ਅਤੇ ਜਿਹੜੀ ਗੱਲ ਤੁਹਾਡੇ ਲਈ ਬਹੁਤ ਔਖੀ ਹੋਵੇ, ਉਹ ਤੁਸੀਂ ਮੇਰੇ ਕੋਲ ਲਿਆਓ ਅਤੇ ਮੈਂ ਉਸ ਨੂੰ ਸੁਣਾਂਗਾ।” ");
INSERT INTO pan_vpl VALUES ("DT1_18","006_1_18","DEU","1","18","18","ਮੈਂ ਉਸ ਵੇਲੇ ਤੁਹਾਨੂੰ ਉਨ੍ਹਾਂ ਸਾਰੀਆਂ ਗੱਲਾਂ ਦਾ ਹੁਕਮ ਦਿੱਤਾ, ਜਿਹੜੀਆਂ ਤੁਹਾਡੇ ਕਰਨ ਦੀਆਂ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("DT1_19","006_1_19","DEU","1","19","19","ਫੇਰ ਅਸੀਂ ਹੋਰੇਬ ਤੋਂ ਕੂਚ ਕਰ ਕੇ ਉਸ ਵੱਡੀ ਅਤੇ ਭਿਆਨਕ ਉਜਾੜ ਵਿੱਚੋਂ ਦੀ ਗਏ ਜਿਹੜੀ ਤੁਸੀਂ ਅਮੋਰੀਆਂ ਦੇ ਪਹਾੜੀ ਦੇਸ਼ ਦੇ ਕੋਲ ਵੇਖੀ ਸੀ, ਜਿਵੇਂ ਯਹੋਵਾਹ ਸਾਡੇ ਪਰਮੇਸ਼ੁਰ ਨੇ ਸਾਨੂੰ ਹੁਕਮ ਦਿੱਤਾ ਸੀ ਅਤੇ ਅਸੀਂ ਕਾਦੇਸ਼-ਬਰਨੇਆ ਵਿੱਚ ਆਏ। ");
INSERT INTO pan_vpl VALUES ("DT1_20","006_1_20","DEU","1","20","20","ਫੇਰ ਮੈਂ ਤੁਹਾਨੂੰ ਆਖਿਆ, “ਤੁਸੀਂ ਅਮੋਰੀਆਂ ਦੇ ਪਹਾੜੀ ਦੇਸ਼ ਕੋਲ ਪਹੁੰਚ ਗਏ ਹੋ, ਜਿਹੜਾ ਯਹੋਵਾਹ ਸਾਡਾ ਪਰਮੇਸ਼ੁਰ ਸਾਨੂੰ ਦਿੰਦਾ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("DT1_21","006_1_21","DEU","1","21","21","ਵੇਖੋ, ਯਹੋਵਾਹ ਤੁਹਾਡੇ ਪਰਮੇਸ਼ੁਰ ਨੇ ਤੁਹਾਡੇ ਅੱਗੇ ਇਹ ਦੇਸ਼ ਰੱਖਿਆ ਹੈ। ਅੱਗੇ ਵਧ ਕੇ ਹਮਲਾ ਕਰੋ ਅਤੇ ਇਸ ਨੂੰ ਅਧਿਕਾਰ ਵਿੱਚ ਲੈ ਲਓ, ਜਿਵੇਂ ਯਹੋਵਾਹ ਤੁਹਾਡੇ ਪੁਰਖਿਆਂ ਦੇ ਪਰਮੇਸ਼ੁਰ ਨੇ ਤੁਹਾਨੂੰ ਆਖਿਆ ਹੈ! ਨਾ ਡਰੋ ਅਤੇ ਨਾ ਘਬਰਾਓ!” ");
INSERT INTO pan_vpl VALUES ("DT1_22","006_1_22","DEU","1","22","22","ਫਿਰ ਤੁਸੀਂ ਸਾਰੇ ਮੇਰੇ ਕੋਲ ਆ ਕੇ ਆਖਣ ਲੱਗੇ, “ਅਸੀਂ ਆਪਣੇ ਅੱਗੇ ਮਨੁੱਖਾਂ ਨੂੰ ਭੇਜਾਂਗੇ ਤਾਂ ਜੋ ਉਹ ਸਾਡੇ ਲਈ ਉਸ ਦੇਸ਼ ਦਾ ਭੇਤ ਲੈਣ ਅਤੇ ਵਾਪਸ ਆ ਕੇ ਸਾਨੂੰ ਉਸ ਰਾਹ ਦਾ ਪਤਾ ਦੇਣ ਜਿਸ ਦੇ ਵਿੱਚੋਂ ਹੋ ਕੇ ਅਸੀਂ ਅੱਗੇ ਜਾਣਾ ਹੈ ਅਤੇ ਸਾਨੂੰ ਕਿਹੜੇ ਸ਼ਹਿਰਾਂ ਵਿੱਚ ਪਹੁੰਚਣਾ ਹੈ।” ");
INSERT INTO pan_vpl VALUES ("DT1_23","006_1_23","DEU","1","23","23","ਇਹ ਗੱਲ ਮੈਨੂੰ ਚੰਗੀ ਲੱਗੀ, ਇਸ ਲਈ ਮੈਂ ਤੁਹਾਡੇ ਵਿੱਚੋਂ ਬਾਰਾਂ ਮਨੁੱਖ ਅਰਥਾਤ ਹਰੇਕ ਗੋਤ ਤੋਂ ਇੱਕ-ਇੱਕ ਮਨੁੱਖ ਚੁਣ ਲਿਆ। ");
INSERT INTO pan_vpl VALUES ("DT1_24","006_1_24","DEU","1","24","24","ਉਹ ਮੁੜ ਕੇ ਉਸ ਪਹਾੜੀ ਦੇਸ਼ ਨੂੰ ਗਏ ਅਤੇ ਅਸ਼ਕੋਲ ਦੀ ਵਾਦੀ ਵਿੱਚ ਪਹੁੰਚ ਕੇ ਉਸ ਦੇਸ਼ ਦਾ ਭੇਤ ਲਿਆ। ");
INSERT INTO pan_vpl VALUES ("DT1_25","006_1_25","DEU","1","25","25","ਉਨ੍ਹਾਂ ਨੇ ਉਸ ਦੇਸ਼ ਦੇ ਫਲਾਂ ਵਿੱਚੋਂ ਕੁਝ ਆਪਣੇ ਹੱਥਾਂ ਵਿੱਚ ਲਿਆ ਅਤੇ ਉਸ ਨੂੰ ਸਾਡੇ ਕੋਲ ਲਿਆਏ ਅਤੇ ਸਾਨੂੰ ਖ਼ਬਰ ਦਿੰਦੇ ਹੋਏ ਆਖਿਆ, “ਉਹ ਦੇਸ਼ ਚੰਗਾ ਹੈ, ਜਿਹੜਾ ਯਹੋਵਾਹ ਸਾਡਾ ਪਰਮੇਸ਼ੁਰ ਸਾਨੂੰ ਦਿੰਦਾ ਹੈ।” ");
INSERT INTO pan_vpl VALUES ("DT1_26","006_1_26","DEU","1","26","26","ਪਰ ਤੁਸੀਂ ਉੱਥੇ ਜਾਣਾ ਨਹੀਂ ਚਾਹੁੰਦੇ ਸੀ, ਸਗੋਂ ਤੁਸੀਂ ਯਹੋਵਾਹ ਆਪਣੇ ਪਰਮੇਸ਼ੁਰ ਦੇ ਹੁਕਮ ਦੇ ਵਿਰੁੱਧ ਹੋ ਗਏ ");
INSERT INTO pan_vpl VALUES ("DT1_27","006_1_27","DEU","1","27","27","ਜਦ ਕਿ ਤੁਸੀਂ ਆਪਣੇ ਤੰਬੂਆਂ ਵਿੱਚ ਬੁੜਬੁੜ ਕਰਨ ਲੱਗ ਪਏ ਅਤੇ ਆਖਿਆ, “ਯਹੋਵਾਹ ਸਾਡੇ ਨਾਲ ਵੈਰ ਰੱਖਦਾ ਹੈ, ਇਸ ਲਈ ਸਾਨੂੰ ਮਿਸਰ ਦੇਸ਼ ਤੋਂ ਕੱਢ ਕੇ ਲੈ ਆਇਆ ਤਾਂ ਜੋ ਸਾਨੂੰ ਅਮੋਰੀਆਂ ਦੇ ਹੱਥਾਂ ਵਿੱਚ ਦੇ ਦੇਵੇ, ਜੋ ਸਾਡਾ ਨਾਸ ਕਰ ਦੇਣ। ");
INSERT INTO pan_vpl VALUES ("DT1_28","006_1_28","DEU","1","28","28","ਅਸੀਂ ਕਿੱਧਰ ਜਾਈਏ? ਸਾਡੇ ਭਰਾਵਾਂ ਨੇ ਇਹ ਆਖ ਕੇ ਸਾਡਾ ਹੌਂਸਲਾ ਤੋੜ ਦਿੱਤਾ ਹੈ ਕਿ ਉਹ ਲੋਕ ਸਾਡੇ ਤੋਂ ਵੱਡੇ ਅਤੇ ਉੱਚੇ-ਲੰਮੇ ਹਨ! ਉਹਨਾਂ ਦੇ ਸ਼ਹਿਰ ਵੱਡੇ ਅਤੇ ਅਕਾਸ਼ ਤੱਕ ਉੱਚੇ ਗੜ੍ਹਾਂ ਵਾਲੇ ਹਨ ਅਤੇ ਅਸੀਂ ਉੱਥੇ ਅਨਾਕੀਆਂ ਨੂੰ ਵੀ ਵੇਖਿਆ ਹੈ!” ");
INSERT INTO pan_vpl VALUES ("DT1_29","006_1_29","DEU","1","29","29","ਤਦ ਮੈਂ ਤੁਹਾਨੂੰ ਆਖਿਆ, “ਤੁਸੀਂ ਉਨ੍ਹਾਂ ਤੋਂ ਨਾ ਘਬਰਾਓ ਅਤੇ ਨਾ ਹੀ ਡਰੋ। ");
INSERT INTO pan_vpl VALUES ("DT1_30","006_1_30","DEU","1","30","30","ਯਹੋਵਾਹ ਤੁਹਾਡਾ ਪਰਮੇਸ਼ੁਰ ਤੁਹਾਡੇ ਅੱਗੇ-ਅੱਗੇ ਜਾਂਦਾ ਹੈ। ਉਹ ਤੁਹਾਡੇ ਲਈ ਲੜੇਗਾ, ਜਿਵੇਂ ਉਸ ਨੇ ਤੁਹਾਡੀਆਂ ਅੱਖਾਂ ਦੇ ਸਾਹਮਣੇ ਮਿਸਰ ਵਿੱਚ ਕੀਤਾ ");
INSERT INTO pan_vpl VALUES ("DT1_31","006_1_31","DEU","1","31","31","ਅਤੇ ਉਜਾੜ ਵਿੱਚ ਵੀ, ਜਿੱਥੇ ਤੁਸੀਂ ਵੇਖਿਆ ਕਿ ਜਿਵੇਂ ਮਨੁੱਖ ਆਪਣੇ ਪੁੱਤਰ ਨੂੰ ਚੁੱਕਦਾ ਹੈ, ਉਸੇ ਤਰ੍ਹਾਂ ਹੀ ਯਹੋਵਾਹ ਤੁਹਾਡੇ ਪਰਮੇਸ਼ੁਰ ਨੇ ਤੁਹਾਨੂੰ ਤੁਹਾਡੇ ਸਾਰੇ ਰਾਹਾਂ ਵਿੱਚ ਜਿੱਥੇ ਤੁਸੀਂ ਜਾਂਦੇ ਸੀ ਚੁੱਕ ਕੇ ਰੱਖਿਆ, ਜਦ ਤੱਕ ਤੁਸੀਂ ਇਸ ਸਥਾਨ ਤੱਕ ਨਹੀਂ ਪਹੁੰਚੇ।” ");
INSERT INTO pan_vpl VALUES ("DT1_32","006_1_32","DEU","1","32","32","ਪਰ ਇਸ ਗੱਲ ਵਿੱਚ ਤੁਸੀਂ ਯਹੋਵਾਹ ਆਪਣੇ ਪਰਮੇਸ਼ੁਰ ਉੱਤੇ ਵਿਸ਼ਵਾਸ ਨਾ ਕੀਤਾ, ");
INSERT INTO pan_vpl VALUES ("DT1_33","006_1_33","DEU","1","33","33","ਜੋ ਰਾਹ ਵਿੱਚ ਤੁਹਾਡੇ ਅੱਗੇ-ਅੱਗੇ ਚੱਲਦਾ ਸੀ ਤਾਂ ਜੋ ਉਹ ਤੁਹਾਡੇ ਲਈ ਡੇਰੇ ਲਾਉਣ ਦਾ ਸਥਾਨ ਲੱਭੇ, ਰਾਤ ਨੂੰ ਅੱਗ ਵਿੱਚ ਅਤੇ ਦਿਨ ਨੂੰ ਬੱਦਲ ਵਿੱਚ ਹੋ ਕੇ ਉਹ ਤੁਹਾਨੂੰ ਉਹ ਰਾਹ ਵਿਖਾਉਂਦਾ ਸੀ, ਜਿਸ ਵਿੱਚ ਤੁਸੀਂ ਜਾਣਾ ਹੁੰਦਾ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("DT1_34","006_1_34","DEU","1","34","34","ਯਹੋਵਾਹ ਨੇ ਤੁਹਾਡੀਆਂ ਗੱਲਾਂ ਦਾ ਰੌਲ਼ਾ ਸੁਣਿਆ, ਤਦ ਉਸ ਦਾ ਕ੍ਰੋਧ ਭੜਕਿਆ ਅਤੇ ਉਸ ਨੇ ਇਹ ਆਖ ਕੇ ਸਹੁੰ ਖਾਧੀ, ");
INSERT INTO pan_vpl VALUES ("DT1_35","006_1_35","DEU","1","35","35","“ਇਸ ਬੁਰੀ ਪੀੜ੍ਹੀ ਵਿੱਚੋਂ ਇੱਕ ਵੀ ਮਨੁੱਖ ਉਸ ਚੰਗੇ ਦੇਸ਼ ਨੂੰ ਨਾ ਵੇਖੇਗਾ, ਜਿਸ ਨੂੰ ਦੇਣ ਦੀ ਸਹੁੰ ਮੈਂ ਤੁਹਾਡੇ ਪੁਰਖਿਆਂ ਨਾਲ ਖਾਧੀ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("DT1_36","006_1_36","DEU","1","36","36","ਸਿਰਫ਼ ਯਫ਼ੁੰਨਹ ਦਾ ਪੁੱਤਰ ਕਾਲੇਬ ਉਸ ਦੇਸ਼ ਨੂੰ ਵੇਖੇਗਾ ਅਤੇ ਮੈਂ ਉਹ ਦੇਸ਼ ਜਿੱਥੇ ਉਸ ਨੇ ਪੈਰ ਰੱਖੇ ਹਨ, ਉਸ ਨੂੰ ਅਤੇ ਉਸ ਦੇ ਪੁੱਤਰਾਂ ਨੂੰ ਦਿਆਂਗਾ ਕਿਉਂ ਜੋ ਉਹ ਯਹੋਵਾਹ ਦੇ ਪਿੱਛੇ ਪੂਰੀ ਰੀਤੀ ਨਾਲ ਤੁਰਿਆ ਹੈ।” ");
INSERT INTO pan_vpl VALUES ("DT1_37","006_1_37","DEU","1","37","37","ਤੁਹਾਡੇ ਕਾਰਨ ਯਹੋਵਾਹ ਮੇਰੇ ਨਾਲ ਵੀ ਇਹ ਆਖ ਕੇ ਗੁੱਸੇ ਹੋਇਆ, “ਤੂੰ ਵੀ ਉੱਥੇ ਨਹੀਂ ਜਾਵੇਂਗਾ। ");
INSERT INTO pan_vpl VALUES ("DT1_38","006_1_38","DEU","1","38","38","ਨੂਨ ਦਾ ਪੁੱਤਰ ਯਹੋਸ਼ੁਆ ਜਿਹੜਾ ਤੇਰੇ ਅੱਗੇ ਖੜ੍ਹਾ ਰਹਿੰਦਾ ਹੈ, ਉਹ ਉੱਥੇ ਜਾਵੇਗਾ। ਉਹ ਨੂੰ ਹੌਂਸਲਾ ਦੇ ਕਿਉਂ ਜੋ ਉਹ ਇਸਰਾਏਲ ਨੂੰ ਉਸ ਦੀ ਵਿਰਾਸਤ ਦੁਆਵੇਗਾ।” ");
INSERT INTO pan_vpl VALUES ("DT1_39","006_1_39","DEU","1","39","39","ਫਿਰ ਤੁਹਾਡੇ ਬੱਚੇ ਜਿਨ੍ਹਾਂ ਦੇ ਵਿਖੇ ਤੁਸੀਂ ਆਖਦੇ ਸੀ ਕਿ ਉਹ ਲੁੱਟ ਵਿੱਚ ਚਲੇ ਜਾਣਗੇ ਅਤੇ ਤੁਹਾਡੇ ਪੁੱਤਰ ਜੋ ਹੁਣੇ ਭਲੇ ਬੁਰੇ ਦੀ ਸਿਆਣ ਨਹੀਂ ਰੱਖਦੇ, ਉਹ ਉੱਥੇ ਪ੍ਰਵੇਸ਼ ਕਰਨਗੇ ਅਤੇ ਮੈਂ ਉਹ ਦੇਸ਼ ਉਹਨਾਂ ਨੂੰ ਦਿਆਂਗਾ ਅਤੇ ਉਹ ਉਸ ਨੂੰ ਅਧਿਕਾਰ ਵਿੱਚ ਲੈ ਲੈਣਗੇ। ");
INSERT INTO pan_vpl VALUES ("DT1_40","006_1_40","DEU","1","40","40","ਪਰ ਤੁਸੀਂ ਘੁੰਮ ਕੇ ਕੂਚ ਕਰੋ ਅਤੇ ਲਾਲ ਸਮੁੰਦਰ ਦੇ ਰਾਹ ਤੋਂ ਉਜਾੜ ਵੱਲ ਜਾਓ। ");
INSERT INTO pan_vpl VALUES ("DT1_41","006_1_41","DEU","1","41","41","ਤਦ ਤੁਸੀਂ ਮੈਨੂੰ ਉੱਤਰ ਦੇ ਕੇ ਆਖਿਆ, “ਅਸੀਂ ਯਹੋਵਾਹ ਦੇ ਵਿਰੁੱਧ ਪਾਪ ਕੀਤਾ ਹੈ। ਹੁਣ ਅਸੀਂ ਉੱਪਰ ਜਾ ਕੇ ਲੜਾਂਗੇ, ਜਿਵੇਂ ਯਹੋਵਾਹ ਸਾਡੇ ਪਰਮੇਸ਼ੁਰ ਨੇ ਸਾਨੂੰ ਹੁਕਮ ਦਿੱਤਾ ਹੈ।” ਫਿਰ ਤੁਹਾਡੇ ਵਿੱਚੋਂ ਹਰੇਕ ਨੇ ਆਪਣੇ ਯੁੱਧ ਦੇ ਸ਼ਸਤਰ ਬੰਨ੍ਹੇ ਅਤੇ ਪਹਾੜੀ ਦੇਸ਼ ਉੱਤੇ ਹਮਲਾ ਕਰਨ ਨੂੰ ਇੱਕ ਛੋਟੀ ਜਿਹੀ ਗੱਲ ਜਾਣਿਆ। ");
INSERT INTO pan_vpl VALUES ("DT1_42","006_1_42","DEU","1","42","42","ਪਰ ਯਹੋਵਾਹ ਨੇ ਮੈਨੂੰ ਆਖਿਆ, “ਉਨ੍ਹਾਂ ਨੂੰ ਆਖ ਕਿ ਉੱਪਰ ਨਾ ਜਾਓ ਅਤੇ ਨਾ ਲੜੋ ਕਿਉਂ ਜੋ ਮੈਂ ਤੁਹਾਡੇ ਨਾਲ ਨਹੀਂ ਹਾਂ, ਅਜਿਹਾ ਨਾ ਹੋਵੇ ਕਿ ਤੁਸੀਂ ਆਪਣੇ ਵੈਰੀਆਂ ਦੇ ਅੱਗੇ ਮਾਰੇ ਜਾਓ।” ");
INSERT INTO pan_vpl VALUES ("DT1_43","006_1_43","DEU","1","43","43","ਮੈਂ ਤੁਹਾਨੂੰ ਇਹ ਗੱਲ ਆਖ ਦਿੱਤੀ, ਪਰ ਤੁਸੀਂ ਨਾ ਸੁਣਿਆ ਸਗੋਂ ਤੁਸੀਂ ਯਹੋਵਾਹ ਦੇ ਹੁਕਮ ਦੇ ਵਿਰੁੱਧ ਹੋ ਗਏ ਅਤੇ ਢਿਠਾਈ ਨਾਲ ਪਹਾੜੀ ਦੇਸ਼ ਵਿੱਚ ਚੜ੍ਹ ਗਏ। ");
INSERT INTO pan_vpl VALUES ("DT1_44","006_1_44","DEU","1","44","44","ਤਦ ਅਮੋਰੀਆਂ ਨੇ ਜਿਹੜੇ ਉਸ ਪਹਾੜੀ ਦੇਸ਼ ਵਿੱਚ ਵੱਸਦੇ ਸਨ, ਨਿੱਕਲ ਕੇ ਤੁਹਾਡਾ ਸਾਹਮਣਾ ਕੀਤਾ ਅਤੇ ਤੁਹਾਨੂੰ ਭਜਾਇਆ, ਜਿਵੇਂ ਸ਼ਹਿਦ ਦੀਆਂ ਮੱਖੀਆਂ ਕਰਦੀਆਂ ਹਨ ਅਤੇ ਤੁਹਾਨੂੰ ਸੇਈਰ ਵਿੱਚ ਹਾਰਮਾਹ ਤੱਕ ਮਾਰਦੇ ਗਏ। ");
INSERT INTO pan_vpl VALUES ("DT1_45","006_1_45","DEU","1","45","45","ਫੇਰ ਤੁਸੀਂ ਵਾਪਸ ਆ ਕੇ ਯਹੋਵਾਹ ਅੱਗੇ ਰੋਏ, ਪਰ ਯਹੋਵਾਹ ਨੇ ਤੁਹਾਡੀ ਅਵਾਜ਼ ਨਾ ਸੁਣੀ ਅਤੇ ਨਾ ਹੀ ਆਪਣਾ ਕੰਨ ਤੁਹਾਡੇ ਵੱਲ ਲਾਇਆ। ");
INSERT INTO pan_vpl VALUES ("DT1_46","006_1_46","DEU","1","46","46","ਇਸ ਲਈ ਤੁਸੀਂ ਕਾਦੇਸ਼ ਵਿੱਚ ਬਹੁਤ ਦਿਨਾਂ ਤੱਕ ਟਿਕੇ ਰਹੇ, ਸਗੋਂ ਬਹੁਤ ਹੀ ਲੰਮੇ ਸਮੇਂ ਤੱਕ ਟਿਕੇ ਰਹੇ। ");
INSERT INTO pan_vpl VALUES ("DT2_1","006_2_1","DEU","2","1","1","ਮੂਸਾ ਨੇ ਇਸਰਾਏਲੀਆਂ ਨੂੰ ਆਖਿਆ, ਫੇਰ ਅਸੀਂ ਮੁੜ ਕੇ ਲਾਲ ਸਮੁੰਦਰ ਦੇ ਰਾਹ ਤੋਂ ਉਜਾੜ ਵੱਲ ਕੂਚ ਕੀਤਾ, ਜਿਵੇਂ ਯਹੋਵਾਹ ਨੇ ਮੇਰੇ ਨਾਲ ਗੱਲ ਕੀਤੀ ਸੀ ਅਤੇ ਅਸੀਂ ਬਹੁਤ ਦਿਨਾਂ ਤੱਕ ਸੇਈਰ ਪਰਬਤ ਦੇ ਆਲੇ-ਦੁਆਲੇ ਘੇਰਾ ਪਾ ਕੇ ਰੱਖਿਆ। ");
INSERT INTO pan_vpl VALUES ("DT2_2","006_2_2","DEU","2","2","2","ਫਿਰ ਯਹੋਵਾਹ ਨੇ ਮੈਨੂੰ ਆਖਿਆ, ");
INSERT INTO pan_vpl VALUES ("DT2_3","006_2_3","DEU","2","3","3","“ਤੁਸੀਂ ਬਹੁਤ ਸਮੇਂ ਤੱਕ ਇਸ ਪਰਬਤ ਦੇ ਆਲੇ-ਦੁਆਲੇ ਘੇਰਾ ਪਾ ਕੇ ਰੱਖਿਆ ਹੈ, ਹੁਣ ਤੁਸੀਂ ਆਪਣਾ ਸਫ਼ਰ ਉੱਤਰ ਵੱਲ ਕਰੋ। ");
INSERT INTO pan_vpl VALUES ("DT2_4","006_2_4","DEU","2","4","4","ਪਰਜਾ ਨੂੰ ਹੁਕਮ ਦੇ ਕਿ ਤੁਸੀਂ ਆਪਣੇ ਭਰਾ ਏਸਾਵੀਆਂ ਦੀਆਂ ਹੱਦਾਂ ਵਿੱਚੋਂ ਦੀ ਲੰਘਣਾ ਹੈ, ਜਿਹੜੇ ਸੇਈਰ ਵਿੱਚ ਵੱਸਦੇ ਹਨ। ਉਹ ਤੁਹਾਡੇ ਤੋਂ ਡਰਨਗੇ ਪਰ ਤੁਸੀਂ ਬਹੁਤ ਚੌਕਸ ਰਹਿਓ। ");
INSERT INTO pan_vpl VALUES ("DT2_5","006_2_5","DEU","2","5","5","ਉਨ੍ਹਾਂ ਨੂੰ ਨਾ ਛੇੜਿਓ ਕਿਉਂ ਜੋ ਮੈਂ ਤੁਹਾਨੂੰ ਉਨ੍ਹਾਂ ਦੇ ਦੇਸ਼ ਵਿੱਚੋਂ ਪੈਰ ਧਰਨ ਦੀ ਥਾਂ ਵੀ ਨਹੀਂ ਦਿਆਂਗਾ ਕਿਉਂ ਜੋ ਮੈਂ ਸੇਈਰ ਪਰਬਤ ਨੂੰ ਏਸਾਓ ਦੀ ਵਿਰਾਸਤ ਹੋਣ ਲਈ ਦੇ ਦਿੱਤਾ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("DT2_6","006_2_6","DEU","2","6","6","ਤੁਸੀਂ ਉਨ੍ਹਾਂ ਨੂੰ ਚਾਂਦੀ ਦੇ ਕੇ ਅੰਨ ਮੁੱਲ ਲਿਓ ਤਾਂ ਜੋ ਤੁਸੀਂ ਖਾਓ ਅਤੇ ਤੁਸੀਂ ਉਨ੍ਹਾਂ ਤੋਂ ਪਾਣੀ ਵੀ ਚਾਂਦੀ ਦੇ ਕੇ ਮੁੱਲ ਲਿਓ ਤਾਂ ਜੋ ਤੁਸੀਂ ਪੀਓ।” ");
INSERT INTO pan_vpl VALUES ("DT2_7","006_2_7","DEU","2","7","7","ਕਿਉਂ ਜੋ ਯਹੋਵਾਹ ਤੁਹਾਡੇ ਪਰਮੇਸ਼ੁਰ ਨੇ ਤੁਹਾਡੇ ਹੱਥਾਂ ਦੇ ਸਾਰੇ ਕੰਮਾਂ ਉੱਤੇ ਬਰਕਤ ਦਿੱਤੀ ਹੈ ਅਤੇ ਇਸ ਵੱਡੀ ਉਜਾੜ ਵਿੱਚ ਉਹ ਤੁਹਾਡਾ ਤੁਰਨਾ-ਫਿਰਨਾ ਜਾਣਦਾ ਹੈ। ਇਨ੍ਹਾਂ ਚਾਲ੍ਹੀ ਸਾਲਾਂ ਤੱਕ ਯਹੋਵਾਹ ਤੁਹਾਡਾ ਪਰਮੇਸ਼ੁਰ ਤੁਹਾਡੇ ਅੰਗ-ਸੰਗ ਰਿਹਾ ਹੈ ਅਤੇ ਤੁਹਾਨੂੰ ਕਿਸੇ ਚੀਜ਼ ਦੀ ਘਾਟ ਨਹੀਂ ਹੋਣ ਦਿੱਤੀ। ");
INSERT INTO pan_vpl VALUES ("DT2_8","006_2_8","DEU","2","8","8","ਤਦ ਅਸੀਂ ਆਪਣੇ ਏਸਾਵੀਆਂ ਭਰਾਵਾਂ ਦੇ ਕੋਲੋਂ ਦੀ ਜਿਹੜੇ ਸੇਈਰ ਵਿੱਚ ਵੱਸਦੇ ਸਨ, ਅਰਾਬਾਹ ਦੇ ਰਾਹ ਤੋਂ ਹੁੰਦੇ ਹੋਏ ਏਲਥ ਅਤੇ ਅਸਯੋਨ-ਗਬਰ ਤੋਂ ਲੰਘੇ। ਫੇਰ ਅਸੀਂ ਮੁੜ ਕੇ ਮੋਆਬ ਦੀ ਉਜਾੜ ਵਿੱਚੋਂ ਹੋ ਕੇ ਗਏ। ");
INSERT INTO pan_vpl VALUES ("DT2_9","006_2_9","DEU","2","9","9","ਯਹੋਵਾਹ ਨੇ ਮੈਨੂੰ ਆਖਿਆ, “ਮੋਆਬ ਨੂੰ ਨਾ ਸਤਾਇਓ, ਨਾ ਉਹਨਾਂ ਨਾਲ ਲੜਾਈ-ਝਗੜਾ ਕਰਿਓ ਕਿਉਂ ਜੋ ਮੈਂ ਤੈਨੂੰ ਉਸ ਦਾ ਦੇਸ਼ ਵਿਰਾਸਤ ਵਿੱਚ ਨਹੀਂ ਦਿਆਂਗਾ। ਮੈਂ ਆਰ ਨਗਰ ਲੂਤ ਦੇ ਵੰਸ਼ ਨੂੰ ਵਿਰਾਸਤ ਵਿੱਚ ਦੇ ਦਿੱਤਾ ਹੈ।” ");
INSERT INTO pan_vpl VALUES ("DT2_10","006_2_10","DEU","2","10","10","ਪਹਿਲੇ ਸਮਿਆਂ ਵਿੱਚ ਉੱਥੇ ਏਮੀ ਵੱਸਦੇ ਸਨ, ਇਹ ਲੋਕ ਅਨਾਕੀਆਂ ਵਰਗੇ ਵੱਡੇ-ਵੱਡੇ ਅਤੇ ਉੱਚੇ-ਲੰਮੇ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("DT2_11","006_2_11","DEU","2","11","11","ਅਨਾਕੀਆਂ ਦੀ ਤਰ੍ਹਾਂ ਇਹ ਲੋਕ ਵੀ ਰਫ਼ਾਈਮ ਗਿਣੇ ਜਾਂਦੇ ਸਨ, ਪਰ ਮੋਆਬੀ ਉਨ੍ਹਾਂ ਨੂੰ ਏਮੀ ਆਖਦੇ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("DT2_12","006_2_12","DEU","2","12","12","ਹੋਰੀ ਵੀ ਪਹਿਲੇ ਸਮਿਆਂ ਵਿੱਚ ਸੇਈਰ ਵਿੱਚ ਵੱਸਦੇ ਸਨ, ਪਰ ਏਸਾਵੀਆਂ ਨੇ ਉਨ੍ਹਾਂ ਨੂੰ ਕੱਢ ਦਿੱਤਾ ਅਤੇ ਆਪਣੇ ਅੱਗਿਓਂ ਉਨ੍ਹਾਂ ਦਾ ਨਾਸ ਕਰਕੇ ਆਪ ਉਨ੍ਹਾਂ ਦੇ ਸਥਾਨ ਤੇ ਵੱਸ ਗਏ, ਜਿਵੇਂ ਇਸਰਾਏਲ ਨੇ ਆਪਣੀ ਵਿਰਾਸਤ ਦੇ ਦੇਸ਼ ਵਿੱਚ ਕੀਤਾ, ਜਿਹੜਾ ਯਹੋਵਾਹ ਨੇ ਉਨ੍ਹਾਂ ਨੂੰ ਦਿੱਤਾ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("DT2_13","006_2_13","DEU","2","13","13","“ਹੁਣ ਤੁਸੀਂ ਉੱਠੋ, ਅਤੇ ਜ਼ਰਦ ਦੇ ਨਾਲੇ ਦੇ ਉੱਤੋਂ ਦੀ ਪਾਰ ਲੰਘ ਜਾਓ!” ਤਦ ਅਸੀਂ ਜ਼ਾਰਦ ਦੇ ਨਾਲੇ ਦੇ ਉੱਤੋਂ ਦੀ ਪਾਰ ਲੰਘ ਗਏ। ");
INSERT INTO pan_vpl VALUES ("DT2_14","006_2_14","DEU","2","14","14","ਕਾਦੇਸ਼-ਬਰਨੇਆ ਤੋਂ ਤੁਰ ਕੇ ਜ਼ਰਦ ਦੇ ਨਾਲੇ ਦੇ ਉੱਤੋਂ ਦੀ ਪਾਰ ਲੰਘਣ ਤੱਕ ਸਾਨੂੰ ਅਠੱਤੀ ਸਾਲ ਲੱਗੇ, ਜਦ ਤੱਕ ਉਸ ਪੀੜ੍ਹੀ ਦੇ ਸਾਰੇ ਸੂਰਮੇ ਛਾਉਣੀ ਵਿੱਚੋਂ ਮਰ ਮਿਟ ਨਾ ਗਏ, ਜਿਵੇਂ ਯਹੋਵਾਹ ਨੇ ਉਨ੍ਹਾਂ ਨਾਲ ਸਹੁੰ ਖਾਧੀ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("DT2_15","006_2_15","DEU","2","15","15","ਇਸ ਲਈ ਜਦ ਤੱਕ ਸਾਰੇ ਦੇ ਸਾਰੇ ਮਿਟ ਨਾ ਗਏ, ਤਦ ਤੱਕ ਯਹੋਵਾਹ ਦਾ ਹੱਥ ਉਨ੍ਹਾਂ ਦੇ ਵਿਰੁੱਧ ਸੀ ਕਿ ਛਾਉਣੀ ਦੇ ਵਿੱਚੋਂ ਉਨ੍ਹਾਂ ਨੂੰ ਮਿਟਾ ਦੇਵੇ। ");
INSERT INTO pan_vpl VALUES ("DT2_16","006_2_16","DEU","2","16","16","ਇਸ ਤਰ੍ਹਾਂ, ਜਦ ਸਾਰੇ ਸੂਰਮੇ ਉਨ੍ਹਾਂ ਲੋਕਾਂ ਵਿੱਚੋਂ ਮਰ ਮਿਟ ਗਏ। ");
INSERT INTO pan_vpl VALUES ("DT2_17","006_2_17","DEU","2","17","17","ਤਦ ਯਹੋਵਾਹ ਇਹ ਆਖ ਕੇ ਮੇਰੇ ਨਾਲ ਬੋਲਿਆ, ");
INSERT INTO pan_vpl VALUES ("DT2_18","006_2_18","DEU","2","18","18","“ਅੱਜ ਤੂੰ ਮੋਆਬ ਦੀ ਹੱਦ ਆਰ ਨਗਰ ਵਿੱਚੋਂ ਪਾਰ ਲੰਘਣਾ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("DT2_19","006_2_19","DEU","2","19","19","ਜਦ ਤੂੰ ਅੰਮੋਨੀਆਂ ਦੇ ਨੇੜੇ ਆਵੇਂ ਤਾਂ ਤੂੰ ਉਹਨਾਂ ਨੂੰ ਨਾ ਸਤਾਈਂ ਅਤੇ ਨਾ ਹੀ ਲੜਾਈ-ਝਗੜਾ ਕਰੀਂ ਕਿਉਂ ਜੋ ਮੈਂ ਤੈਨੂੰ ਅੰਮੋਨੀਆਂ ਦੇ ਦੇਸ਼ ਵਿੱਚੋਂ ਕੁਝ ਵੀ ਤੇਰੀ ਵਿਰਾਸਤ ਹੋਣ ਲਈ ਨਹੀਂ ਦਿਆਂਗਾ, ਕਿਉਂ ਜੋ ਮੈਂ ਉਹ ਲੂਤ ਦੇ ਵੰਸ਼ ਦੀ ਵਿਰਾਸਤ ਹੋਣ ਲਈ ਦਿੱਤਾ ਹੈ।” ");
INSERT INTO pan_vpl VALUES ("DT2_20","006_2_20","DEU","2","20","20","(ਉਹ ਵੀ ਰਫ਼ਾਈਆਂ ਦੀ ਧਰਤੀ ਗਿਣੀ ਗਈ। ਰਫ਼ਾਈ ਪਹਿਲੇ ਸਮਿਆਂ ਵਿੱਚ ਉੱਥੇ ਵੱਸਦੇ ਸਨ, ਪਰ ਅੰਮੋਨੀ ਉਨ੍ਹਾਂ ਨੂੰ ਜ਼ਮ ਜ਼ੁੰਮੀ ਆਖਦੇ ਸਨ) ");
INSERT INTO pan_vpl VALUES ("DT2_21","006_2_21","DEU","2","21","21","ਇਹ ਲੋਕ ਵੀ ਅਨਾਕੀਆਂ ਦੀ ਤਰ੍ਹਾਂ ਗਿਣਤੀ ਵਿੱਚ ਬਹੁਤ ਸਾਰੇ ਅਤੇ ਵੱਡੇ ਅਤੇ ਉੱਚੇ-ਲੰਮੇ ਸਨ, ਪਰ ਯਹੋਵਾਹ ਨੇ ਉਹਨਾਂ ਨੂੰ ਅੰਮੋਨੀਆਂ ਦੇ ਅੱਗਿਓਂ ਨਾਸ ਕਰ ਕੇ ਕੱਢ ਦਿੱਤਾ ਅਤੇ ਉਹ ਆਪ ਉਹਨਾਂ ਦੇ ਸਥਾਨ ਤੇ ਵੱਸ ਗਏ, ");
INSERT INTO pan_vpl VALUES ("DT2_22","006_2_22","DEU","2","22","22","ਜਿਵੇਂ ਉਹ ਨੇ ਏਸਾਵੀਆਂ ਲਈ ਕੀਤਾ ਸੀ ਜਿਹੜੇ ਸੇਈਰ ਵਿੱਚ ਵੱਸਦੇ ਸਨ, ਜਦ ਉਹ ਨੇ ਉਹਨਾਂ ਦੇ ਅੱਗਿਓਂ ਹੋਰੀਆਂ ਦਾ ਨਾਸ ਕਰ ਦਿੱਤਾ ਅਤੇ ਉਨ੍ਹਾਂ ਨੇ ਉਹਨਾਂ ਨੂੰ ਕੱਢ ਦਿੱਤਾ ਅਤੇ ਅੱਜ ਦੇ ਦਿਨ ਤੱਕ ਉਹ ਆਪ ਉਹਨਾਂ ਦੇ ਸਥਾਨ ਤੇ ਵੱਸਦੇ ਹਨ। ");
INSERT INTO pan_vpl VALUES ("DT2_23","006_2_23","DEU","2","23","23","ਫੇਰ ਅੱਵੀ, ਜਿਹੜੇ ਅੱਜ਼ਾਹ ਤੱਕ ਪਿੰਡਾਂ ਵਿੱਚ ਵੱਸੇ ਹੋਏ ਸਨ, ਉਨ੍ਹਾਂ ਨੂੰ ਕਫ਼ਤੋਰੀਆਂ ਨੇ ਜਿਹੜੇ ਕਫ਼ਤੋਰ ਤੋਂ ਨਿੱਕਲੇ ਸਨ, ਨਾਸ ਕਰ ਦਿੱਤਾ ਅਤੇ ਆਪ ਉਹਨਾਂ ਦੇ ਸਥਾਨ ਤੇ ਵੱਸ ਗਏ। ");
INSERT INTO pan_vpl VALUES ("DT2_24","006_2_24","DEU","2","24","24","ਹੁਣ ਤੁਸੀਂ ਉੱਠੋ ਅਤੇ ਕੂਚ ਕਰ ਕੇ ਅਰਨੋਨ ਦੇ ਨਾਲੇ ਤੋਂ ਪਾਰ ਲੰਘੋ। ਵੇਖੋ ਮੈਂ ਤੁਹਾਡੇ ਹੱਥ ਵਿੱਚ ਹਸ਼ਬੋਨ ਦੇ ਰਾਜੇ ਸੀਹੋਨ ਅਮੋਰੀ ਨੂੰ ਉਸ ਦੇ ਦੇਸ਼ ਦੇ ਸਮੇਤ ਦੇ ਦਿੱਤਾ ਹੈ। ਉਸ ਦੇ ਦੇਸ਼ ਨੂੰ ਆਪਣੇ ਅਧਿਕਾਰ ਵਿੱਚ ਲੈਣਾ ਸ਼ੁਰੂ ਕਰੋ ਅਤੇ ਉਸ ਨਾਲ ਯੁੱਧ ਛੇੜ ਦਿਓ। ");
INSERT INTO pan_vpl VALUES ("DT2_25","006_2_25","DEU","2","25","25","ਅੱਜ ਦੇ ਦਿਨ ਮੈਂ ਤੇਰਾ ਭੈਅ ਅਤੇ ਤੇਰਾ ਡਰ ਅਕਾਸ਼ ਦੇ ਹੇਠਾਂ ਰਹਿਣ ਵਾਲੇ ਸਾਰੇ ਲੋਕਾਂ ਉੱਤੇ ਪਾਉਣਾ ਸ਼ੁਰੂ ਕਰਦਾ ਹਾਂ। ਉਹ ਤੇਰੀ ਖ਼ਬਰ ਸੁਣ ਕੇ ਕੰਬਣਗੇ ਅਤੇ ਤੇਰੇ ਕਾਰਨ ਤੜਫ਼ ਉੱਠਣਗੇ। ");
INSERT INTO pan_vpl VALUES ("DT2_26","006_2_26","DEU","2","26","26","ਤਦ ਮੈਂ ਕਦੇਮੋਥ ਦੀ ਉਜਾੜ ਤੋਂ ਸੰਦੇਸ਼ਵਾਹਕਾਂ ਨੂੰ ਹਸ਼ਬੋਨ ਦੇ ਰਾਜੇ ਸੀਹੋਨ ਕੋਲ ਸ਼ਾਂਤੀ ਦੀਆਂ ਇਹ ਗੱਲਾਂ ਆਖਣ ਲਈ ਭੇਜਿਆ, ");
INSERT INTO pan_vpl VALUES ("DT2_27","006_2_27","DEU","2","27","27","“ਮੈਨੂੰ ਆਪਣੇ ਦੇਸ਼ ਦੇ ਵਿੱਚੋਂ ਦੀ ਲੰਘਣ ਦੇ, ਮੈਂ ਸਿਰਫ਼ ਸੜਕ ਤੋਂ ਹੋ ਕੇ ਜਾਂਵਾਂਗਾ। ਮੈਂ ਨਾ ਤਾਂ ਸੱਜੇ ਮੁੜਾਂਗਾ ਨਾ ਹੀ ਖੱਬੇ। ");
INSERT INTO pan_vpl VALUES ("DT2_28","006_2_28","DEU","2","28","28","ਤੂੰ ਮੇਰੇ ਤੋਂ ਚਾਂਦੀ ਲੈ ਕੇ ਮੈਨੂੰ ਅੰਨ ਵੇਚੀਂ ਤਾਂ ਜੋ ਮੈਂ ਖਾਵਾਂ ਅਤੇ ਪਾਣੀ ਵੀ ਚਾਂਦੀ ਲੈ ਕੇ ਮੈਨੂੰ ਦੇਵੀਂ ਤਾਂ ਜੋ ਮੈਂ ਪੀਵਾਂ। ਸਿਰਫ਼ ਮੈਨੂੰ ਪੈਦਲ ਪਾਰ ਲੰਘਣ ਦੇ, ");
INSERT INTO pan_vpl VALUES ("DT2_29","006_2_29","DEU","2","29","29","ਜਿਵੇਂ ਸੇਈਰ ਦੇ ਵਾਸੀ ਏਸਾਵੀਆਂ ਨੇ ਅਤੇ ਆਰ ਦੇ ਵਾਸੀ ਮੋਆਬੀਆਂ ਨੇ ਮੇਰੇ ਨਾਲ ਕੀਤਾ, ਤੂੰ ਵੀ ਉਸੇ ਤਰ੍ਹਾਂ ਹੀ ਕਰ ਜਦ ਤੱਕ ਮੈਂ ਯਰਦਨ ਦੇ ਪਾਰ ਉਸ ਦੇਸ਼ ਵਿੱਚ ਨਾ ਪਹੁੰਚ ਜਾਂਵਾਂ, ਜਿਹੜਾ ਯਹੋਵਾਹ ਸਾਡਾ ਪਰਮੇਸ਼ੁਰ ਸਾਨੂੰ ਦਿੰਦਾ ਹੈ।” ");
INSERT INTO pan_vpl VALUES ("DT2_30","006_2_30","DEU","2","30","30","ਪਰ ਹਸ਼ਬੋਨ ਦੇ ਰਾਜੇ ਸੀਹੋਨ ਨੇ ਸਾਨੂੰ ਆਪਣੇ ਦੇਸ਼ ਵਿੱਚੋਂ ਹੋ ਕੇ ਪਾਰ ਲੰਘਣ ਨਾ ਦਿੱਤਾ ਕਿਉਂ ਜੋ ਤੁਹਾਡੇ ਪਰਮੇਸ਼ੁਰ ਯਹੋਵਾਹ ਨੇ ਉਸ ਦੇ ਆਤਮਾ ਨੂੰ ਕਠੋਰ ਅਤੇ ਉਸ ਦੇ ਮਨ ਨੂੰ ਸਖ਼ਤ ਹੋਣ ਦਿੱਤਾ ਤਾਂ ਜੋ ਉਹ ਉਸ ਨੂੰ ਤੇਰੇ ਹੱਥ ਵਿੱਚ ਦੇ ਦੇਵੇ, ਜਿਵੇਂ ਅੱਜ ਦੇ ਦਿਨ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("DT2_31","006_2_31","DEU","2","31","31","ਯਹੋਵਾਹ ਨੇ ਮੈਨੂੰ ਆਖਿਆ, “ਵੇਖ, ਮੈਂ ਸੀਹੋਨ ਅਤੇ ਉਸ ਦੇ ਦੇਸ਼ ਨੂੰ ਤੇਰੇ ਹੱਥ ਵਿੱਚ ਦੇਣ ਲੱਗਾ ਹਾਂ। ਉਸ ਦੇ ਦੇਸ਼ ਨੂੰ ਆਪਣੇ ਅਧਿਕਾਰ ਵਿੱਚ ਲੈਣਾ ਸ਼ੁਰੂ ਕਰ ਤਾਂ ਜੋ ਤੂੰ ਉਸ ਨੂੰ ਆਪਣੀ ਵਿਰਾਸਤ ਬਣਾ ਲਵੇਂ।” ");
INSERT INTO pan_vpl VALUES ("DT2_32","006_2_32","DEU","2","32","32","ਤਦ ਸੀਹੋਨ ਅਤੇ ਉਸ ਦੇ ਸਾਰੇ ਲੋਕਾਂ ਨੇ ਨਿੱਕਲ ਕੇ ਯਹਸ ਵੱਲ ਸਾਡਾ ਸਾਹਮਣਾ ਕੀਤਾ। ");
INSERT INTO pan_vpl VALUES ("DT2_33","006_2_33","DEU","2","33","33","ਯਹੋਵਾਹ ਸਾਡੇ ਪਰਮੇਸ਼ੁਰ ਨੇ ਉਸ ਨੂੰ ਸਾਡੇ ਅੱਗੇ ਹਰਾ ਦਿੱਤਾ ਅਤੇ ਅਸੀਂ ਉਸ ਨੂੰ, ਉਸ ਦੇ ਪੁੱਤਰਾਂ ਨੂੰ ਅਤੇ ਉਸ ਦੇ ਸਾਰੇ ਲੋਕਾਂ ਨੂੰ ਮਾਰ ਸੁੱਟਿਆ। ");
INSERT INTO pan_vpl VALUES ("DT2_34","006_2_34","DEU","2","34","34","ਅਸੀਂ ਉਸ ਵੇਲੇ ਉਸ ਦੇ ਸਾਰੇ ਸ਼ਹਿਰ ਲੈ ਲਏ ਅਤੇ ਉਸ ਦੇ ਹਰੇਕ ਵੱਸੇ ਹੋਏ ਸ਼ਹਿਰ ਦਾ ਇਸਤਰੀਆਂ ਅਤੇ ਬੱਚਿਆਂ ਸਮੇਤ ਨਾਸ ਕਰ ਦਿੱਤਾ, ਇੱਥੋਂ ਤੱਕ ਕਿ ਅਸੀਂ ਇੱਕ ਵੀ ਨਾ ਛੱਡਿਆ। ");
INSERT INTO pan_vpl VALUES ("DT2_35","006_2_35","DEU","2","35","35","ਅਸੀਂ ਸਿਰਫ਼ ਪਸ਼ੂਆਂ ਨੂੰ ਆਪਣੀ ਲੁੱਟ ਵਿੱਚ ਲਿਆ ਅਤੇ ਉਨ੍ਹਾਂ ਸ਼ਹਿਰਾਂ ਦੀ ਲੁੱਟ ਦਾ ਮਾਲ ਲਿਆ, ਜਿਨ੍ਹਾਂ ਨੂੰ ਅਸੀਂ ਜਿੱਤ ਲਿਆ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("DT2_36","006_2_36","DEU","2","36","36","ਅਰੋਏਰ ਤੋਂ ਜਿਹੜਾ ਅਰਨੋਨ ਦੇ ਨਾਲੇ ਦੀ ਹੱਦ ਉੱਤੇ ਹੈ ਅਤੇ ਉਸ ਸ਼ਹਿਰ ਤੋਂ ਜਿਹੜਾ ਨਾਲੇ ਦੇ ਕੋਲ ਹੈ, ਗਿਲਆਦ ਤੱਕ ਕੋਈ ਨਗਰ ਅਜਿਹਾ ਨਹੀਂ ਸੀ, ਜਿਹੜਾ ਸਾਡੇ ਸਾਹਮਣੇ ਠਹਿਰ ਸਕਦਾ ਸੀ। ਯਹੋਵਾਹ ਸਾਡੇ ਪਰਮੇਸ਼ੁਰ ਨੇ ਸਭ ਕੁਝ ਸਾਡੇ ਅਧੀਨ ਕਰ ਦਿੱਤਾ। ");
INSERT INTO pan_vpl VALUES ("DT2_37","006_2_37","DEU","2","37","37","ਤੁਸੀਂ ਸਿਰਫ਼ ਅੰਮੋਨੀਆਂ ਦੇ ਦੇਸ਼ ਦੇ ਨੇੜੇ ਨਾ ਗਏ ਅਰਥਾਤ ਯਬੋਕ ਨਦੀ ਦਾ ਸਾਰਾ ਪਾਸਾ ਅਤੇ ਪਹਾੜੀ ਸ਼ਹਿਰ ਅਤੇ ਜਿੱਥੇ ਜਾਣ ਤੋਂ ਯਹੋਵਾਹ ਸਾਡੇ ਪਰਮੇਸ਼ੁਰ ਨੇ ਸਾਨੂੰ ਮਨ੍ਹਾ ਕੀਤਾ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("DT3_1","006_3_1","DEU","3","1","1","ਫੇਰ ਅਸੀਂ ਮੁੜ ਕੇ ਬਾਸ਼ਾਨ ਦੇ ਰਾਹ ਤੋਂ ਉੱਪਰ ਚੱਲੇ ਅਤੇ ਬਾਸ਼ਾਨ ਦਾ ਰਾਜਾ ਓਗ ਆਪਣੇ ਸਾਰੇ ਲੋਕਾਂ ਦੇ ਨਾਲ ਸਾਡਾ ਸਾਹਮਣਾ ਕਰਨ ਨੂੰ ਨਿੱਕਲਿਆ ਤਾਂ ਜੋ ਅਦਰਈ ਵਿੱਚ ਸਾਡੇ ਨਾਲ ਯੁੱਧ ਕਰੇ। ");
INSERT INTO pan_vpl VALUES ("DT3_2","006_3_2","DEU","3","2","2","ਯਹੋਵਾਹ ਨੇ ਮੈਨੂੰ ਆਖਿਆ, “ਉਸ ਤੋਂ ਨਾ ਡਰ ਕਿਉਂ ਜੋ ਮੈਂ ਉਸ ਨੂੰ, ਉਸ ਦੇ ਸਾਰੇ ਲੋਕਾਂ ਨੂੰ ਅਤੇ ਉਸ ਦੇ ਦੇਸ਼ ਨੂੰ ਤੇਰੇ ਹੱਥ ਵਿੱਚ ਦੇ ਦਿੱਤਾ ਹੈ। ਤੂੰ ਉਸ ਦੇ ਨਾਲ ਉਸੇ ਤਰ੍ਹਾਂ ਹੀ ਕਰੀਂ ਜਿਵੇਂ ਤੂੰ ਅਮੋਰੀਆਂ ਦੇ ਰਾਜੇ ਸੀਹੋਨ ਨਾਲ ਕੀਤਾ, ਜੋ ਹਸ਼ਬੋਨ ਵਿੱਚ ਵੱਸਦਾ ਸੀ।” ");
INSERT INTO pan_vpl VALUES ("DT3_3","006_3_3","DEU","3","3","3","ਇਸ ਤਰ੍ਹਾਂ ਯਹੋਵਾਹ ਸਾਡੇ ਪਰਮੇਸ਼ੁਰ ਨੇ ਬਾਸ਼ਾਨ ਦੇ ਰਾਜੇ ਓਗ ਨੂੰ ਅਤੇ ਉਸ ਦੇ ਸਾਰੇ ਲੋਕਾਂ ਨੂੰ ਸਾਡੇ ਹੱਥ ਵਿੱਚ ਦੇ ਦਿੱਤਾ ਅਤੇ ਅਸੀਂ ਉਸ ਨੂੰ ਅਜਿਹਾ ਮਾਰਿਆ ਕਿ ਉਸ ਦਾ ਕੱਖ ਵੀ ਨਾ ਰਿਹਾ। ");
INSERT INTO pan_vpl VALUES ("DT3_4","006_3_4","DEU","3","4","4","ਉਸੇ ਸਮੇਂ ਅਸੀਂ ਉਸ ਦੇ ਸਾਰੇ ਸ਼ਹਿਰ ਲੈ ਲਏ ਅਤੇ ਅਜਿਹਾ ਇੱਕ ਨਗਰ ਵੀ ਨਹੀਂ ਸੀ ਜਿਹੜਾ ਅਸੀਂ ਉਨ੍ਹਾਂ ਤੋਂ ਨਾ ਲਿਆ ਹੋਵੇ, ਅਰਥਾਤ ਅਰਗੋਬ ਦੇ ਸਾਰੇ ਇਲਾਕੇ ਦੇ ਸੱਠ ਸ਼ਹਿਰ ਜਿਹੜੇ ਬਾਸ਼ਾਨ ਵਿੱਚ ਓਗ ਦੇ ਰਾਜ ਦੇ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("DT3_5","006_3_5","DEU","3","5","5","ਇਹ ਸਾਰੇ ਸ਼ਹਿਰ ਗੜ੍ਹਾਂ ਵਾਲੇ ਸਨ। ਉਹਨਾਂ ਦੀਆਂ ਸ਼ਹਿਰਪਨਾਹਾਂ ਉੱਚੀਆਂ ਅਤੇ ਉਹਨਾਂ ਦੇ ਫਾਟਕ ਅਰਲਾਂ ਵਾਲੇ ਸਨ। ਇਹਨਾਂ ਤੋਂ ਬਿਨ੍ਹਾਂ ਹੋਰ ਵੀ ਬਹੁਤ ਸਾਰੇ ਪਿੰਡ ਸਨ, ਜਿਨ੍ਹਾਂ ਦੀ ਸ਼ਹਿਰ ਪਨਾਹ ਨਹੀਂ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("DT3_6","006_3_6","DEU","3","6","6","ਅਸੀਂ ਉਹਨਾਂ ਦਾ ਨਾਸ ਕਰ ਦਿੱਤਾ, ਜਿਵੇਂ ਅਸੀਂ ਹਸ਼ਬੋਨ ਦੇ ਰਾਜੇ ਸੀਹੋਨ ਨਾਲ ਕੀਤਾ ਸੀ। ਅਸੀਂ ਸਾਰੇ ਵੱਸੇ ਹੋਏ ਸ਼ਹਿਰਾਂ ਦਾ ਇਸਤਰੀਆਂ ਅਤੇ ਬੱਚਿਆਂ ਸਮੇਤ ਨਾਸ ਕਰ ਦਿੱਤਾ। ");
INSERT INTO pan_vpl VALUES ("DT3_7","006_3_7","DEU","3","7","7","ਪਰ ਸਾਰੇ ਪਸ਼ੂ ਅਤੇ ਸ਼ਹਿਰਾਂ ਦੀ ਲੁੱਟ ਦਾ ਮਾਲ ਅਸੀਂ ਆਪਣੇ ਲਈ ਲੁੱਟ ਲਿਆ ");
INSERT INTO pan_vpl VALUES ("DT3_8","006_3_8","DEU","3","8","8","ਅਤੇ ਉਸ ਸਮੇਂ ਅਸੀਂ ਯਰਦਨ ਤੋਂ ਪਾਰ ਦੇ ਅਮੋਰੀਆਂ ਦੇ ਦੋਹਾਂ ਰਾਜਿਆਂ ਦੇ ਹੱਥੋਂ ਉਸ ਦੇਸ਼ ਨੂੰ ਅਰਨੋਨ ਦੇ ਨਾਲੇ ਤੋਂ ਲੈ ਕੇ ਹਰਮੋਨ ਦੇ ਪਰਬਤ ਤੱਕ ਲੈ ਲਿਆ ");
INSERT INTO pan_vpl VALUES ("DT3_9","006_3_9","DEU","3","9","9","(ਸੀਦੋਨੀ ਹਰਮੋਨ ਨੂੰ ਸਿਰਯੋਨ ਪਰ ਅਮੋਰੀ ਉਸ ਨੂੰ ਸਨੀਰ ਆਖਦੇ ਹਨ) ");
INSERT INTO pan_vpl VALUES ("DT3_10","006_3_10","DEU","3","10","10","ਉਸ ਮੈਦਾਨੀ ਇਲਾਕੇ ਦੇ ਸਾਰੇ ਸ਼ਹਿਰ, ਸਾਰਾ ਗਿਲਆਦ, ਸਾਰਾ ਬਾਸ਼ਾਨ, ਸਲਕਾਹ ਅਤੇ ਅਦਰਈ ਤੱਕ ਦੇ ਸਾਰੇ ਸ਼ਹਿਰ ਜਿਹੜੇ ਬਾਸ਼ਾਨ ਵਿੱਚ ਓਗ ਦੇ ਰਾਜ ਦੇ ਸਨ, ਅਸੀਂ ਲੈ ਲਏ ");
INSERT INTO pan_vpl VALUES ("DT3_11","006_3_11","DEU","3","11","11","ਸਿਰਫ਼ ਬਾਸ਼ਾਨ ਦਾ ਰਾਜਾ ਓਗ ਹੀ ਰਫ਼ਾਈਆਂ ਦੇ ਬਚੇ ਹੋਇਆਂ ਵਿੱਚੋਂ ਰਹਿ ਗਿਆ ਸੀ। ਵੇਖੋ, ਉਸ ਦਾ ਪਲੰਘ ਜੋ ਲੋਹੇ ਦਾ ਸੀ, ਕੀ ਉਹ ਅੰਮੋਨੀਆਂ ਦੇ ਰੱਬਾਹ ਵਿੱਚ ਨਹੀਂ ਹੈ? ਮਨੁੱਖ ਦੇ ਹੱਥ ਅਨੁਸਾਰ ਉਸ ਦੀ ਲੰਬਾਈ ਨੌਂ ਹੱਥ ਅਤੇ ਚੌੜਾਈ ਚਾਰ ਹੱਥ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("DT3_12","006_3_12","DEU","3","12","12","ਜਿਹੜੇ ਦੇਸ਼ ਅਸੀਂ ਉਸ ਸਮੇਂ ਆਪਣੇ ਅਧਿਕਾਰ ਵਿੱਚ ਲੈ ਲਏ ਉਹ ਇਹ ਹਨ, ਅਰਥਾਤ ਅਰੋਏਰ ਸ਼ਹਿਰ ਤੋਂ ਲੈ ਕੇ ਜਿਹੜਾ ਅਰਨੋਨ ਦੇ ਨਾਲੇ ਉੱਤੇ ਹੈ ਅਤੇ ਸ਼ਹਿਰਾਂ ਦੇ ਨਾਲ ਗਿਲਆਦ ਦੇ ਪਹਾੜੀ ਦੇਸ਼ ਦਾ ਅੱਧਾ ਹਿੱਸਾ, ਜਿਹੜਾ ਮੈਂ ਰਊਬੇਨੀਆਂ ਅਤੇ ਗਾਦੀਆਂ ਨੂੰ ਦੇ ਦਿੱਤਾ ");
INSERT INTO pan_vpl VALUES ("DT3_13","006_3_13","DEU","3","13","13","ਅਤੇ ਗਿਲਆਦ ਦਾ ਬਚਿਆ ਹੋਇਆ ਹਿੱਸਾ ਅਤੇ ਸਾਰਾ ਬਾਸ਼ਾਨ ਜਿਹੜਾ ਓਗ ਦੇ ਰਾਜ ਦਾ ਸੀ, ਮੈਂ ਮਨੱਸ਼ਹ ਦੇ ਅੱਧੇ ਗੋਤ ਨੂੰ ਦੇ ਦਿੱਤਾ ਅਰਥਾਤ ਸਾਰੇ ਬਾਸ਼ਾਨ ਸਮੇਤ ਅਰਗੋਬ ਦਾ ਸਾਰਾ ਇਲਾਕਾ। (ਬਾਸ਼ਾਨ ਤਾਂ ਰਫ਼ਾਈਆਂ ਦਾ ਦੇਸ਼ ਅਖਵਾਉਂਦਾ ਹੈ) ");
INSERT INTO pan_vpl VALUES ("DT3_14","006_3_14","DEU","3","14","14","ਮਨੱਸ਼ੀ ਯਾਈਰ ਨੇ ਅਰਗੋਬ ਦਾ ਸਾਰਾ ਇਲਾਕਾ ਗਸ਼ੂਰੀਆਂ ਅਤੇ ਮਆਕਾਥੀਆਂ ਦੀਆਂ ਹੱਦਾਂ ਤੱਕ ਲੈ ਲਿਆ ਅਤੇ ਉਨ੍ਹਾਂ ਦਾ ਨਾਮ ਅਰਥਾਤ ਬਾਸ਼ਾਨ ਦੇ ਨਗਰਾਂ ਦਾ ਨਾਮ ਆਪਣੇ ਨਾਮ ਉੱਤੇ ਹੱਵੋਥ-ਯਾਈਰ ਰੱਖਿਆ, ਜਿਹੜਾ ਅੱਜ ਦੇ ਦਿਨ ਤੱਕ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("DT3_15","006_3_15","DEU","3","15","15","ਗਿਲਆਦ ਮੈਂ ਮਾਕੀਰ ਨੂੰ ਦੇ ਦਿੱਤਾ ");
INSERT INTO pan_vpl VALUES ("DT3_16","006_3_16","DEU","3","16","16","ਅਤੇ ਰਊਬੇਨੀਆਂ ਅਤੇ ਗਾਦੀਆਂ ਨੂੰ ਮੈਂ ਗਿਲਆਦ ਤੋਂ ਲੈ ਕੇ ਅਰਨੋਨ ਦੇ ਨਾਲੇ ਤੱਕ ਦਾ ਦੇਸ਼ ਦੇ ਦਿੱਤਾ, ਅਰਥਾਤ ਨਾਲੇ ਦੇ ਵਿਚਕਾਰ ਤੋਂ ਉਸ ਦੇ ਕੰਢਿਆਂ ਤੱਕ ਅਤੇ ਯਬੋਕ ਦੀ ਨਦੀ ਤੱਕ ਜਿਹੜੀ ਅੰਮੋਨੀਆਂ ਦੀ ਹੱਦ ਹੈ ");
INSERT INTO pan_vpl VALUES ("DT3_17","006_3_17","DEU","3","17","17","ਅਤੇ ਕਿੰਨਰਥ ਤੋਂ ਲੈ ਕੇ ਪਿਸਗਾਹ ਦੀ ਢਾਲ਼ ਦੇ ਅਰਾਬਾਹ ਸਮੁੰਦਰ ਤੱਕ, ਜੋ ਖਾਰਾ ਸਮੁੰਦਰ ਵੀ ਅਖਵਾਉਂਦਾ ਹੈ, ਅਰਾਬਾਹ ਅਤੇ ਯਰਦਨ ਦੇ ਪੂਰਬ ਵੱਲ ਦਾ ਸਾਰਾ ਦੇਸ਼ ਵੀ ਮੈਂ ਉਨ੍ਹਾਂ ਨੂੰ ਦੇ ਦਿੱਤਾ। ");
INSERT INTO pan_vpl VALUES ("DT3_18","006_3_18","DEU","3","18","18","ਉਸ ਵੇਲੇ ਮੈਂ ਤੁਹਾਨੂੰ ਹੁਕਮ ਦਿੱਤਾ ਅਤੇ ਆਖਿਆ, “ਯਹੋਵਾਹ ਤੁਹਾਡੇ ਪਰਮੇਸ਼ੁਰ ਨੇ ਇਹ ਦੇਸ਼ ਤੁਹਾਡੀ ਵਿਰਾਸਤ ਕਰਕੇ ਦੇ ਦਿੱਤਾ ਹੈ। ਸਾਰੇ ਸੂਰਬੀਰ ਹਥਿਆਰ ਬੰਨ ਕੇ ਆਪਣੇ ਇਸਰਾਏਲੀ ਭਰਾਵਾਂ ਦੇ ਅੱਗੇ-ਅੱਗੇ ਪਾਰ ਲੰਘੋ ");
INSERT INTO pan_vpl VALUES ("DT3_19","006_3_19","DEU","3","19","19","ਪਰ ਤੁਹਾਡੀਆਂ ਇਸਤਰੀਆਂ, ਬੱਚੇ ਅਤੇ ਤੁਹਾਡੇ ਵੱਗ, ਕਿਉਂ ਜੋ ਮੈਂ ਜਾਣਦਾ ਹਾਂ ਕਿ ਤੁਹਾਡੇ ਵੱਗ ਵੱਡੇ-ਵੱਡੇ ਹਨ, ਉਹ ਸਾਰੇ ਤੁਹਾਡੇ ਸ਼ਹਿਰਾਂ ਵਿੱਚ ਰਹਿ ਜਾਣ, ਜਿਹੜੇ ਮੈਂ ਤੁਹਾਨੂੰ ਦਿੱਤੇ ਹਨ। ");
INSERT INTO pan_vpl VALUES ("DT3_20","006_3_20","DEU","3","20","20","ਜਦ ਤੱਕ ਯਹੋਵਾਹ ਤੁਹਾਡੇ ਭਰਾਵਾਂ ਨੂੰ ਅਰਾਮ ਨਾ ਦੇਵੇ, ਜਿਵੇਂ ਉਸਨੇ ਤੁਹਾਨੂੰ ਦਿੱਤਾ ਹੈ ਅਤੇ ਉਹ ਵੀ ਉਸ ਧਰਤੀ ਨੂੰ ਅਧਿਕਾਰ ਵਿੱਚ ਨਾ ਕਰ ਲੈਣ, ਜਿਹੜੀ ਯਹੋਵਾਹ ਤੁਹਾਡਾ ਪਰਮੇਸ਼ੁਰ ਉਨ੍ਹਾਂ ਨੂੰ ਯਰਦਨ ਦੇ ਪਾਰ ਦਿੰਦਾ ਹੈ, ਫੇਰ ਤੁਸੀਂ ਵੀ ਆਪਣੇ-ਆਪਣੇ ਅਧਿਕਾਰ ਦੀ ਭੂਮੀ ਨੂੰ ਮੁੜ ਜਾਇਓ, ਜਿਹੜੀ ਮੈਂ ਤੁਹਾਨੂੰ ਦਿੱਤੀ ਹੈ।” ");
INSERT INTO pan_vpl VALUES ("DT3_21","006_3_21","DEU","3","21","21","ਉਸੇ ਵੇਲੇ ਮੈਂ ਯਹੋਸ਼ੁਆ ਨੂੰ ਹੁਕਮ ਦਿੱਤਾ ਅਤੇ ਆਖਿਆ, “ਤੇਰੀਆਂ ਅੱਖਾਂ ਨੇ ਉਹ ਸਭ ਕੁਝ ਵੇਖਿਆ ਹੈ ਜੋ ਯਹੋਵਾਹ ਤੇਰੇ ਪਰਮੇਸ਼ੁਰ ਨੇ ਇਹਨਾਂ ਦੋਹਾਂ ਰਾਜਿਆਂ ਨਾਲ ਕੀਤਾ ਹੈ, ਅਜਿਹਾ ਹੀ ਯਹੋਵਾਹ ਸਾਰੇ ਰਾਜਾਂ ਨਾਲ ਕਰੇਗਾ, ਜਿੱਥੋਂ ਹੋ ਕੇ ਤੂੰ ਪਾਰ ਲੰਘੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("DT3_22","006_3_22","DEU","3","22","22","ਤੁਸੀਂ ਉਹਨਾਂ ਕੋਲੋਂ ਨਾ ਡਰੋ ਕਿਉਂ ਜੋ ਯਹੋਵਾਹ ਤੁਹਾਡਾ ਪਰਮੇਸ਼ੁਰ ਆਪ ਹੀ ਤੁਹਾਡੇ ਲਈ ਲੜਦਾ ਹੈ।” ");
INSERT INTO pan_vpl VALUES ("DT3_23","006_3_23","DEU","3","23","23","ਉਸ ਵੇਲੇ ਮੈਂ ਯਹੋਵਾਹ ਦੇ ਅੱਗੇ ਤਰਲੇ ਕਰ ਕੇ ਬੇਨਤੀ ਕੀਤੀ, ");
INSERT INTO pan_vpl VALUES ("DT3_24","006_3_24","DEU","3","24","24","“ਹੇ ਪ੍ਰਭੂ ਯਹੋਵਾਹ, ਤੂੰ ਆਪਣੇ ਦਾਸ ਉੱਤੇ ਆਪਣੀ ਵਡਿਆਈ ਅਤੇ ਆਪਣੀ ਸ਼ਕਤੀ ਦਾ ਹੱਥ ਪਰਗਟ ਕਰਨ ਲੱਗਾ ਹੈਂ, ਕਿਉਂ ਜੋ ਅਕਾਸ਼ ਵਿੱਚ ਅਤੇ ਧਰਤੀ ਉੱਤੇ ਕਿਹੜਾ ਦੇਵਤਾ ਹੈ, ਜਿਹੜਾ ਤੇਰੇ ਜਿਹੇ ਕਾਰਜ ਅਤੇ ਤੇਰੇ ਜਿਹੇ ਵੱਡੀ ਸ਼ਕਤੀ ਵਾਲੇ ਕੰਮ ਕਰ ਸਕੇ? ");
INSERT INTO pan_vpl VALUES ("DT3_25","006_3_25","DEU","3","25","25","ਕਿਰਪਾ ਕਰਕੇ ਮੈਨੂੰ ਪਾਰ ਲੰਘਣ ਦੇ ਤਾਂ ਜੋ ਮੈਂ ਉਸ ਚੰਗੀ ਧਰਤੀ ਨੂੰ ਜਿਹੜੀ ਯਰਦਨ ਪਾਰ ਹੈ ਅਤੇ ਉਸ ਚੰਗੇ ਪਹਾੜੀ ਦੇਸ਼ ਨੂੰ ਅਤੇ ਲਬਾਨੋਨ ਨੂੰ ਵੇਖ ਸਕਾਂ।” ");
INSERT INTO pan_vpl VALUES ("DT3_26","006_3_26","DEU","3","26","26","ਪਰ ਯਹੋਵਾਹ ਤੁਹਾਡੇ ਕਾਰਨ ਮੇਰੇ ਨਾਲ ਗੁੱਸੇ ਸੀ ਅਤੇ ਮੇਰੀ ਨਾ ਸੁਣੀ। ਯਹੋਵਾਹ ਨੇ ਮੈਨੂੰ ਆਖਿਆ, “ਬਸ ਕਰ! ਫੇਰ ਕਦੀ ਮੇਰੇ ਨਾਲ ਇਹ ਗੱਲ ਨਾ ਛੇੜੀਂ! ");
INSERT INTO pan_vpl VALUES ("DT3_27","006_3_27","DEU","3","27","27","ਪਿਸਗਾਹ ਦੀ ਟੀਸੀ ਉੱਤੇ ਚੜ੍ਹ ਅਤੇ ਆਪਣੀਆਂ ਅੱਖਾਂ ਪੂਰਬ, ਪੱਛਮ, ਉੱਤਰ ਅਤੇ ਦੱਖਣ ਵੱਲ ਚੁੱਕ ਅਤੇ ਆਪਣੀਆਂ ਅੱਖਾਂ ਨਾਲ ਉਹ ਦੇਸ਼ ਵੇਖ ਲੈ ਕਿਉਂ ਜੋ ਤੂੰ ਇਸ ਯਰਦਨ ਦੇ ਪਾਰ ਨਾ ਲੰਘੇਂਗਾ। ");
INSERT INTO pan_vpl VALUES ("DT3_28","006_3_28","DEU","3","28","28","ਪਰ ਯਹੋਸ਼ੁਆ ਨੂੰ ਹੁਕਮ ਦੇ, ਉਸ ਦਾ ਹੌਂਸਲਾ ਵਧਾ ਅਤੇ ਉਸ ਨੂੰ ਤਕੜਾ ਕਰ ਕਿਉਂ ਜੋ ਉਹ ਇਸ ਪਰਜਾ ਦੇ ਅੱਗੇ-ਅੱਗੇ ਪਾਰ ਲੰਘੇਗਾ ਅਤੇ ਉਹ ਉਨ੍ਹਾਂ ਨੂੰ ਉਹ ਦੇਸ਼ ਜਿਹੜਾ ਤੂੰ ਵੇਖੇਂਗਾ, ਉਨ੍ਹਾਂ ਦੀ ਵਿਰਾਸਤ ਹੋਣ ਲਈ ਦੁਆਵੇਗਾ।” ");
INSERT INTO pan_vpl VALUES ("DT3_29","006_3_29","DEU","3","29","29","ਤਦ ਅਸੀਂ ਬੈਤ ਪਓਰ ਦੇ ਸਾਹਮਣੇ ਦੀ ਘਾਟੀ ਵਿੱਚ ਠਹਿਰ ਗਏ। ");
INSERT INTO pan_vpl VALUES ("DT4_1","006_4_1","DEU","4","1","1","ਹੇ ਇਸਰਾਏਲ, ਹੁਣ ਉਨ੍ਹਾਂ ਬਿਧੀਆਂ ਅਤੇ ਕਨੂੰਨਾਂ ਨੂੰ ਸੁਣੋ ਜਿਹੜੇ ਮੈਂ ਤੁਹਾਨੂੰ ਸਿਖਾਉਂਦਾ ਹਾਂ ਕਿ ਤੁਸੀਂ ਉਨ੍ਹਾਂ ਨੂੰ ਪੂਰਾ ਕਰੋ, ਤਾਂ ਜੋ ਤੁਸੀਂ ਜੀਉਂਦੇ ਰਹੋ ਅਤੇ ਜਾ ਕੇ ਉਸ ਦੇਸ਼ ਨੂੰ ਅਧਿਕਾਰ ਵਿੱਚ ਲੈ ਲਓ ਜਿਹੜਾ ਯਹੋਵਾਹ ਤੁਹਾਡੇ ਪੁਰਖਿਆਂ ਦਾ ਪਰਮੇਸ਼ੁਰ ਤੁਹਾਨੂੰ ਦਿੰਦਾ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("DT4_2","006_4_2","DEU","4","2","2","ਜਿਹੜੇ ਹੁਕਮ ਮੈਂ ਤੁਹਾਨੂੰ ਦਿੰਦਾ ਹਾਂ, ਉਨ੍ਹਾਂ ਵਿੱਚ ਨਾ ਤਾਂ ਕੁਝ ਵਧਾਓ ਅਤੇ ਨਾ ਉਨ੍ਹਾਂ ਵਿੱਚੋਂ ਕੁਝ ਘਟਾਓ ਤਾਂ ਜੋ ਤੁਸੀਂ ਯਹੋਵਾਹ ਆਪਣੇ ਪਰਮੇਸ਼ੁਰ ਦੇ ਹੁਕਮਾਂ ਦੀ ਪਾਲਨਾ ਕਰੋ, ਜਿਹੜੇ ਮੈਂ ਤੁਹਾਨੂੰ ਦਿੰਦਾ ਹਾਂ। ");
INSERT INTO pan_vpl VALUES ("DT4_3","006_4_3","DEU","4","3","3","ਜੋ ਕੁਝ ਯਹੋਵਾਹ ਨੇ ਬਆਲ ਪਓਰ ਦੇ ਕਾਰਨ ਕੀਤਾ ਉਹ ਸਭ ਤੁਹਾਡੀਆਂ ਅੱਖਾਂ ਨੇ ਵੇਖਿਆ ਹੈ, ਕਿਉਂ ਜੋ ਜਿਹੜੇ ਮਨੁੱਖ ਬਆਲ-ਪਓਰ ਪਰਾਏ ਦੇਵਤੇ ਦੇ ਪਿੱਛੇ ਹੋ ਗਏ ਸਨ, ਉਨ੍ਹਾਂ ਸਾਰਿਆਂ ਨੂੰ ਯਹੋਵਾਹ ਤੁਹਾਡੇ ਪਰਮੇਸ਼ੁਰ ਨੇ ਤੁਹਾਡੇ ਵਿੱਚੋਂ ਨਾਸ ਕਰ ਦਿੱਤਾ ਹੈ, ");
INSERT INTO pan_vpl VALUES ("DT4_4","006_4_4","DEU","4","4","4","ਪਰ ਤੁਸੀਂ ਜਿਹੜੇ ਯਹੋਵਾਹ ਆਪਣੇ ਪਰਮੇਸ਼ੁਰ ਦੇ ਨਾਲ ਬਣੇ ਰਹੇ, ਅੱਜ ਤੱਕ ਸਾਰੇ ਜੀਉਂਦੇ ਹੋ। ");
INSERT INTO pan_vpl VALUES ("DT4_5","006_4_5","DEU","4","5","5","ਵੇਖੋ, ਜਿਵੇਂ ਯਹੋਵਾਹ ਮੇਰੇ ਪਰਮੇਸ਼ੁਰ ਨੇ ਮੈਨੂੰ ਹੁਕਮ ਦਿੱਤਾ ਸੀ, ਮੈਂ ਤੁਹਾਨੂੰ ਬਿਧੀਆਂ ਅਤੇ ਕਨੂੰਨ ਸਿਖਾਏ ਹਨ ਤਾਂ ਜੋ ਤੁਸੀਂ ਉਸ ਦੇਸ਼ ਵਿੱਚ ਜਿਸ ਨੂੰ ਅਧਿਕਾਰ ਵਿੱਚ ਲੈਣ ਲਈ ਤੁਸੀਂ ਜਾਂਦੇ ਹੋ, ਉਨ੍ਹਾਂ ਦੇ ਅਨੁਸਾਰ ਕਰੋ। ");
INSERT INTO pan_vpl VALUES ("DT4_6","006_4_6","DEU","4","6","6","ਤੁਸੀਂ ਉਹਨਾਂ ਨੂੰ ਮੰਨੋ ਅਤੇ ਪੂਰੇ ਕਰੋ ਕਿਉਂ ਜੋ ਉਹਨਾਂ ਲੋਕਾਂ ਦੀ ਨਜ਼ਰ ਵਿੱਚ ਤੁਹਾਡੀ ਬੁੱਧੀ ਅਤੇ ਸਮਝ ਇਸੇ ਗੱਲ ਤੋਂ ਪ੍ਰਗਟ ਹੋਵੇਗੀ ਅਰਥਾਤ ਜਿਹੜੇ ਇਨ੍ਹਾਂ ਸਾਰੀਆਂ ਬਿਧੀਆਂ ਨੂੰ ਸੁਣ ਕੇ ਆਖਣਗੇ ਕਿ ਬੇਸ਼ਕ ਇਹ ਵੱਡੀ ਕੌਮ ਬੁੱਧਵਾਨ ਅਤੇ ਸਮਝਦਾਰ ਲੋਕਾਂ ਦੀ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("DT4_7","006_4_7","DEU","4","7","7","ਕਿਉਂ ਜੋ ਕਿਹੜੀ ਅਜਿਹੀ ਵੱਡੀ ਕੌਮ ਹੈ, ਜਿਸ ਦਾ ਪਰਮੇਸ਼ੁਰ ਉਸ ਦੇ ਐਨੇ ਨਜ਼ਦੀਕ ਹੈ, ਜਿਨ੍ਹਾਂ ਕਿ ਯਹੋਵਾਹ ਸਾਡਾ ਪਰਮੇਸ਼ੁਰ ਸਾਡੇ ਨਜ਼ਦੀਕ ਹੈ, ਜਦ ਕਦੀ ਅਸੀਂ ਉਸ ਦੇ ਅੱਗੇ ਬੇਨਤੀ ਕਰਦੇ ਹਾਂ? ");
INSERT INTO pan_vpl VALUES ("DT4_8","006_4_8","DEU","4","8","8","ਅਤੇ ਕਿਹੜੀ ਅਜਿਹੀ ਵੱਡੀ ਕੌਮ ਹੈ ਜਿਸ ਦੇ ਕੋਲ ਅਜਿਹੀ ਧਾਰਮਿਕ ਬਿਧੀਆਂ ਅਤੇ ਕਨੂੰਨ ਹਨ, ਜਿੰਨ੍ਹੀ ਕਿ ਇਹ ਸਾਰੀ ਬਿਵਸਥਾ ਜਿਹੜੀ ਮੈਂ ਅੱਜ ਤੁਹਾਡੇ ਅੱਗੇ ਰੱਖਦਾ ਹਾਂ? ");
INSERT INTO pan_vpl VALUES ("DT4_9","006_4_9","DEU","4","9","9","ਇਸ ਲਈ ਚੌਕਸ ਰਹੋ ਅਤੇ ਆਪਣੇ ਮਨ ਦੀ ਬਹੁਤ ਰਾਖੀ ਕਰੋ, ਕਿਤੇ ਅਜਿਹਾ ਨਾ ਹੋਵੇ ਕਿ ਤੁਸੀਂ ਉਨ੍ਹਾਂ ਗੱਲਾਂ ਨੂੰ ਭੁੱਲ ਜਾਓ ਜਿਹੜੀਆਂ ਤੁਸੀਂ ਆਪਣੀਆਂ ਅੱਖਾਂ ਨਾਲ ਵੇਖੀਆਂ ਹਨ ਅਤੇ ਉਹ ਜੀਵਨ ਭਰ ਲਈ ਤੁਹਾਡੇ ਦਿਲ ਵਿੱਚੋਂ ਨਿੱਕਲ ਜਾਣ, ਪਰ ਤੁਸੀਂ ਉਨ੍ਹਾਂ ਨੂੰ ਆਪਣੇ ਪੁੱਤਰਾਂ ਅਤੇ ਪੋਤਿਆਂ ਨੂੰ ਸਿਖਾਇਓ। ");
INSERT INTO pan_vpl VALUES ("DT4_10","006_4_10","DEU","4","10","10","ਜਿਸ ਦਿਨ ਤੁਸੀਂ ਯਹੋਵਾਹ ਆਪਣੇ ਪਰਮੇਸ਼ੁਰ ਦੇ ਅੱਗੇ ਹੋਰੇਬ ਵਿੱਚ ਖੜ੍ਹੇ ਹੋਏ ਸੀ, ਜਦ ਯਹੋਵਾਹ ਨੇ ਮੈਨੂੰ ਆਖਿਆ, “ਲੋਕਾਂ ਨੂੰ ਮੇਰੇ ਲਈ ਇਕੱਠੇ ਕਰ ਅਤੇ ਮੈਂ ਲੋਕਾਂ ਨੂੰ ਆਪਣੀਆਂ ਗੱਲਾਂ ਸੁਣਾਵਾਂਗਾ ਕਿ ਉਹ ਜਦ ਤੱਕ ਧਰਤੀ ਉੱਤੇ ਜੀਉਂਦੇ ਰਹਿਣ ਮੇਰੇ ਤੋਂ ਡਰਨਾ ਸਿੱਖਣ ਅਤੇ ਆਪਣੇ ਬੱਚਿਆਂ ਨੂੰ ਵੀ ਸਿਖਾਉਣ।” ");
INSERT INTO pan_vpl VALUES ("DT4_11","006_4_11","DEU","4","11","11","ਤਦ ਤੁਸੀਂ ਨੇੜੇ ਆ ਕੇ ਉਸ ਪਰਬਤ ਦੇ ਹੇਠ ਖੜ੍ਹੇ ਹੋ ਗਏ ਅਤੇ ਉਹ ਪਰਬਤ ਅੱਗ ਨਾਲ ਬਲਦਾ ਸੀ ਅਤੇ ਉਸ ਦੀ ਲੌ ਅਕਾਸ਼ ਤੱਕ ਪਹੁੰਚਦੀ ਸੀ ਅਤੇ ਉਸ ਦੇ ਚੁਫ਼ੇਰੇ ਹਨ੍ਹੇਰਾ, ਬੱਦਲ ਅਤੇ ਕਾਲੀਆਂ ਘਟਾਂ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("DT4_12","006_4_12","DEU","4","12","12","ਯਹੋਵਾਹ ਅੱਗ ਦੇ ਵਿੱਚੋਂ ਦੀ ਤੁਹਾਡੇ ਨਾਲ ਬੋਲਿਆ, ਤੁਸੀਂ ਉਸ ਦੇ ਸ਼ਬਦ ਤਾਂ ਸੁਣੇ ਪਰ ਤੁਸੀਂ ਕੋਈ ਸਰੂਪ ਨਾ ਵੇਖਿਆ, ਤੁਸੀਂ ਸਿਰਫ਼ ਅਵਾਜ਼ ਹੀ ਸੁਣੀ। ");
INSERT INTO pan_vpl VALUES ("DT4_13","006_4_13","DEU","4","13","13","ਉਸ ਨੇ ਆਪਣਾ ਨੇਮ ਤੁਹਾਡੇ ਉੱਤੇ ਪਰਗਟ ਕੀਤਾ, ਜਿਸ ਨੂੰ ਪੂਰਾ ਕਰਨ ਦਾ ਹੁਕਮ ਉਸ ਨੇ ਤੁਹਾਨੂੰ ਦਿੱਤਾ ਅਰਥਾਤ ਦਸ ਹੁਕਮ ਅਤੇ ਉਨ੍ਹਾਂ ਨੂੰ ਪੱਥਰ ਦੀਆਂ ਦੋ ਫੱਟੀਆਂ ਉੱਤੇ ਲਿਖ ਦਿੱਤਾ। ");
INSERT INTO pan_vpl VALUES ("DT4_14","006_4_14","DEU","4","14","14","ਉਸੇ ਵੇਲੇ ਯਹੋਵਾਹ ਨੇ ਮੈਨੂੰ ਹੁਕਮ ਦਿੱਤਾ ਕਿ ਮੈਂ ਤੁਹਾਨੂੰ ਬਿਧੀਆਂ ਅਤੇ ਕਨੂੰਨ ਸਿਖਾਵਾਂ ਤਾਂ ਜੋ ਤੁਸੀਂ ਉਨ੍ਹਾਂ ਨੂੰ ਉਸ ਦੇਸ਼ ਵਿੱਚ ਪੂਰਾ ਕਰੋ, ਜਿਸ ਨੂੰ ਅਧਿਕਾਰ ਵਿੱਚ ਲੈਣ ਲਈ ਤੁਸੀਂ ਪਾਰ ਜਾਂਦੇ ਹੋ। ");
INSERT INTO pan_vpl VALUES ("DT4_15","006_4_15","DEU","4","15","15","ਤੁਸੀਂ ਆਪਣੇ ਮਨਾਂ ਦੀ ਬਹੁਤ ਰਾਖੀ ਕਰੋ ਕਿਉਂਕਿ ਜਦ ਯਹੋਵਾਹ ਹੋਰੇਬ ਪਰਬਤ ਉੱਤੇ ਅੱਗ ਦੇ ਵਿੱਚੋਂ ਦੀ ਤੁਹਾਡੇ ਨਾਲ ਬੋਲਿਆ, ਤਾਂ ਤੁਸੀਂ ਕੋਈ ਸਰੂਪ ਨਾ ਵੇਖਿਆ ");
INSERT INTO pan_vpl VALUES ("DT4_16","006_4_16","DEU","4","16","16","ਅਜਿਹਾ ਨਾ ਹੋਵੇ ਕਿ ਤੁਸੀਂ ਵਿਗੜ ਕੇ ਆਪਣੇ ਲਈ ਕਿਸੇ ਬੁੱਤ ਦੀ ਘੜ੍ਹੀ ਹੋਈ ਮੂਰਤ ਬਣਾ ਲਓ ਅਰਥਾਤ ਕਿਸੇ ਨਰ-ਨਾਰੀ ਦੀ ਸ਼ਕਲ ਵਿੱਚ, ");
INSERT INTO pan_vpl VALUES ("DT4_17","006_4_17","DEU","4","17","17","ਜਾਂ ਕਿਸੇ ਜਾਨਵਰ ਦੀ ਸ਼ਕਲ ਜਿਹੜਾ ਧਰਤੀ ਉੱਤੇ ਹੈ ਜਾਂ ਅਕਾਸ਼ ਵਿੱਚ ਉੱਡਣ ਵਾਲੇ ਕਿਸੇ ਪੰਛੀ ਦੀ ਸ਼ਕਲ, ");
INSERT INTO pan_vpl VALUES ("DT4_18","006_4_18","DEU","4","18","18","ਜਾਂ ਕਿਸੇ ਜ਼ਮੀਨ ਉੱਤੇ ਘਿੱਸਰਨ ਵਾਲੇ ਕਿਸੇ ਜੰਤੂ ਦੀ ਸ਼ਕਲ ਜਾਂ ਧਰਤੀ ਦੇ ਹੇਠਲੇ ਪਾਣੀਆਂ ਵਿੱਚ ਰਹਿਣ ਵਾਲੀ ਕਿਸੇ ਮੱਛੀ ਦੀ ਸ਼ਕਲ ਵਿੱਚ, ");
INSERT INTO pan_vpl VALUES ("DT4_19","006_4_19","DEU","4","19","19","ਜਾਂ ਫਿਰ ਜਦ ਤੁਸੀਂ ਆਪਣੀਆਂ ਅੱਖਾਂ ਅਕਾਸ਼ ਵੱਲ ਚੁੱਕੋ ਅਤੇ ਜਦ ਤੁਸੀਂ ਸੂਰਜ, ਚੰਦ ਅਤੇ ਤਾਰਿਆਂ ਨੂੰ ਅਰਥਾਤ ਅਕਾਸ਼ ਦੀ ਸਾਰੀ ਸੈਨਾਂ ਨੂੰ ਵੇਖੋ ਤਾਂ ਭਟਕ ਕੇ ਉਹਨਾਂ ਦੇ ਅੱਗੇ ਮੱਥਾ ਟੇਕੋ ਅਤੇ ਉਨ੍ਹਾਂ ਦੀ ਸੇਵਾ ਕਰਨ ਲੱਗੋ, ਜਿਨ੍ਹਾਂ ਨੂੰ ਯਹੋਵਾਹ ਤੁਹਾਡੇ ਪਰਮੇਸ਼ੁਰ ਨੇ ਅਕਾਸ਼ ਦੇ ਹੇਠ ਦੇ ਸਾਰੇ ਲੋਕਾਂ ਲਈ ਰੱਖਿਆ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("DT4_20","006_4_20","DEU","4","20","20","ਪਰ ਯਹੋਵਾਹ ਨੇ ਤੁਹਾਨੂੰ ਲੋਹੇ ਦੀ ਭੱਠੀ ਵਰਗੇ ਮਿਸਰ ਤੋਂ ਕੱਢਿਆ ਤਾਂ ਜੋ ਤੁਸੀਂ ਉਹ ਦੀ ਨਿੱਜ-ਪਰਜਾ ਹੋਵੋ, ਜਿਵੇਂ ਤੁਸੀਂ ਅੱਜ ਦੇ ਦਿਨ ਹੋ। ");
INSERT INTO pan_vpl VALUES ("DT4_21","006_4_21","DEU","4","21","21","ਤੁਹਾਡੇ ਕਾਰਨ ਯਹੋਵਾਹ ਮੇਰੇ ਨਾਲ ਗੁੱਸੇ ਹੋਇਆ ਅਤੇ ਉਸ ਨੇ ਸਹੁੰ ਖਾਧੀ ਕਿ ਤੂੰ ਯਰਦਨ ਦੇ ਪਾਰ ਨਹੀਂ ਜਾਵੇਂਗਾ ਅਤੇ ਨਾ ਹੀ ਤੂੰ ਉਸ ਚੰਗੇ ਦੇਸ਼ ਵਿੱਚ ਪ੍ਰਵੇਸ਼ ਕਰੇਂਗਾ ਜਿਹੜਾ ਯਹੋਵਾਹ ਤੁਹਾਡਾ ਪਰਮੇਸ਼ੁਰ ਤੁਹਾਨੂੰ ਵਿਰਾਸਤ ਵਿੱਚ ਦਿੰਦਾ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("DT4_22","006_4_22","DEU","4","22","22","ਮੈਂ ਤਾਂ ਇਸੇ ਦੇਸ਼ ਵਿੱਚ ਮਰਨਾ ਹੈ। ਮੈਂ ਯਰਦਨ ਦੇ ਪਾਰ ਨਹੀਂ ਜਾ ਸਕਦਾ, ਪਰ ਤੁਸੀਂ ਜਾਓਗੇ ਅਤੇ ਤੁਸੀਂ ਉਸ ਚੰਗੇ ਦੇਸ਼ ਉੱਤੇ ਅਧਿਕਾਰ ਕਰੋਗੇ। ");
INSERT INTO pan_vpl VALUES ("DT4_23","006_4_23","DEU","4","23","23","ਚੌਕਸ ਰਹੋ, ਕਿਤੇ ਅਜਿਹਾ ਨਾ ਹੋਵੇ ਕਿ ਤੁਸੀਂ ਯਹੋਵਾਹ ਆਪਣੇ ਪਰਮੇਸ਼ੁਰ ਦੇ ਨੇਮ ਨੂੰ ਜਿਹੜਾ ਉਸ ਨੇ ਤੁਹਾਡੇ ਨਾਲ ਬੰਨ੍ਹਿਆ ਹੈ, ਭੁੱਲ ਜਾਓ ਅਤੇ ਆਪਣੇ ਲਈ ਕਿਸੇ ਚੀਜ਼ ਦੀ ਘੜ੍ਹੀ ਹੋਈ ਮੂਰਤ ਬਣਾਓ, ਜਿਸ ਤੋਂ ਯਹੋਵਾਹ ਤੁਹਾਡੇ ਪਰਮੇਸ਼ੁਰ ਨੇ ਤੁਹਾਨੂੰ ਮਨ੍ਹਾ ਕੀਤਾ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("DT4_24","006_4_24","DEU","4","24","24","ਕਿਉਂ ਜੋ ਯਹੋਵਾਹ ਤੁਹਾਡਾ ਪਰਮੇਸ਼ੁਰ ਭਸਮ ਕਰਨ ਵਾਲੀ ਅੱਗ ਹੈ। ਉਹ ਇੱਕ ਅਣਖ ਵਾਲਾ ਪਰਮੇਸ਼ੁਰ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("DT4_25","006_4_25","DEU","4","25","25","ਜਦ ਉਸ ਦੇਸ਼ ਵਿੱਚ ਰਹਿੰਦੇ ਹੋਏ ਤੁਹਾਨੂੰ ਬਹੁਤ ਦਿਨ ਹੋ ਜਾਣ ਅਤੇ ਤੁਹਾਡੇ ਪੁੱਤਰ ਤੇ ਪੋਤਰੇ ਪੈਦਾ ਹੋਣ ਅਤੇ ਤੁਸੀਂ ਵਿਗੜ ਕੇ ਆਪਣੇ ਲਈ ਕਿਸੇ ਚੀਜ਼ ਦੀ ਘੜ੍ਹੀ ਹੋਈ ਮੂਰਤ ਬਣਾਓ ਅਤੇ ਯਹੋਵਾਹ ਆਪਣੇ ਪਰਮੇਸ਼ੁਰ ਦੀ ਨਿਗਾਹ ਵਿੱਚ ਬੁਰਿਆਈ ਕਰੋ ਕਿ ਉਹ ਕ੍ਰੋਧਵਾਨ ਹੋਵੇ, ");
INSERT INTO pan_vpl VALUES ("DT4_26","006_4_26","DEU","4","26","26","ਤਾਂ ਮੈਂ ਅੱਜ ਤੁਹਾਡੇ ਵਿਰੁੱਧ ਅਕਾਸ਼ ਅਤੇ ਧਰਤੀ ਦੀ ਗਵਾਹੀ ਲੈਂਦਾ ਹਾਂ ਕਿ ਉਸ ਦੇਸ਼ ਵਿੱਚੋਂ ਛੇਤੀ ਨਾਲ ਤੁਹਾਡਾ ਪੂਰੀ ਤਰ੍ਹਾਂ ਨਾਸ ਹੋ ਜਾਵੇਗਾ, ਜਿਸ ਉੱਤੇ ਅਧਿਕਾਰ ਕਰਨ ਲਈ ਤੁਸੀਂ ਯਰਦਨ ਤੋਂ ਪਾਰ ਜਾਂਦੇ ਹੋ। ਤੁਹਾਨੂੰ ਉੱਥੇ ਬਹੁਤ ਦਿਨਾਂ ਤੱਕ ਰਹਿਣ ਦਾ ਮੌਕਾ ਨਹੀਂ ਮਿਲੇਗਾ, ਤੁਹਾਡਾ ਪੂਰੀ ਤਰ੍ਹਾਂ ਹੀ ਨਾਸ ਹੋ ਜਾਵੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("DT4_27","006_4_27","DEU","4","27","27","ਯਹੋਵਾਹ ਤੁਹਾਨੂੰ ਦੇਸ਼-ਦੇਸ਼ ਦੇ ਲੋਕਾਂ ਵਿੱਚ ਖਿਲਾਰ ਦੇਵੇਗਾ ਅਤੇ ਜਿਨ੍ਹਾਂ ਲੋਕਾਂ ਦੇ ਵਿੱਚ ਯਹੋਵਾਹ ਤੁਹਾਨੂੰ ਧੱਕ ਦੇਵੇਗਾ, ਉੱਥੇ ਤੁਸੀਂ ਥੋੜ੍ਹੇ ਜਿਹੇ ਰਹਿ ਜਾਓਗੇ। ");
INSERT INTO pan_vpl VALUES ("DT4_28","006_4_28","DEU","4","28","28","ਤੁਸੀਂ ਉੱਥੇ ਆਦਮੀ ਦੇ ਹੱਥਾਂ ਦੇ ਬਣਾਏ ਹੋਏ ਲੱਕੜ ਅਤੇ ਪੱਥਰ ਦੇ ਦੇਵਤਿਆਂ ਦੀ ਪੂਜਾ ਕਰੋਗੇ ਜਿਹੜੇ ਨਾ ਵੇਖਦੇ, ਨਾ ਸੁਣਦੇ, ਨਾ ਖਾਂਦੇ ਅਤੇ ਨਾ ਸੁੰਘਦੇ ਹਨ। ");
INSERT INTO pan_vpl VALUES ("DT4_29","006_4_29","DEU","4","29","29","ਫੇਰ ਤੁਸੀਂ ਉੱਥੇ ਯਹੋਵਾਹ ਆਪਣੇ ਪਰਮੇਸ਼ੁਰ ਦੀ ਭਾਲ ਕਰੋਗੇ ਅਤੇ ਤੁਸੀਂ ਉਹ ਨੂੰ ਪਾਓਗੇ ਜਦ ਤੁਸੀਂ ਆਪਣੇ ਸਾਰੇ ਦਿਲ ਨਾਲ ਅਤੇ ਆਪਣੇ ਸਾਰੇ ਮਨ ਨਾਲ ਉਸ ਦੀ ਖੋਜ ਕਰੋਗੇ। ");
INSERT INTO pan_vpl VALUES ("DT4_30","006_4_30","DEU","4","30","30","ਜਦ ਤੁਸੀਂ ਸੰਕਟ ਵਿੱਚ ਪਓ ਅਤੇ ਇਹ ਸਾਰੀਆਂ ਬਿਪਤਾਵਾਂ ਤੁਹਾਡੇ ਉੱਤੇ ਆ ਪੈਣ ਤਾਂ ਆਖਰੀ ਦਿਨਾਂ ਵਿੱਚ ਤੁਸੀਂ ਯਹੋਵਾਹ ਆਪਣੇ ਪਰਮੇਸ਼ੁਰ ਵੱਲ ਮੁੜੋਗੇ ਅਤੇ ਉਹ ਦੀ ਅਵਾਜ਼ ਸੁਣੋਗੇ, ");
INSERT INTO pan_vpl VALUES ("DT4_31","006_4_31","DEU","4","31","31","ਕਿਉਂ ਜੋ ਯਹੋਵਾਹ ਤੁਹਾਡਾ ਪਰਮੇਸ਼ੁਰ ਇੱਕ ਦਿਆਲੂ ਪਰਮੇਸ਼ੁਰ ਹੈ, ਉਹ ਨਾ ਤਾਂ ਤੁਹਾਨੂੰ ਤਿਆਗੇਗਾ, ਨਾ ਤੁਹਾਡਾ ਨਾਸ ਕਰੇਗਾ ਅਤੇ ਨਾ ਹੀ ਉਸ ਨੇਮ ਨੂੰ ਭੁੱਲੇਗਾ ਜਿਸ ਦੇ ਵਿਖੇ ਉਸ ਨੇ ਤੁਹਾਡੇ ਪੁਰਖਿਆਂ ਦੇ ਨਾਲ ਸਹੁੰ ਖਾਧੀ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("DT4_32","006_4_32","DEU","4","32","32","ਜਦੋਂ ਤੋਂ ਪਰਮੇਸ਼ੁਰ ਨੇ ਆਦਮੀ ਨੂੰ ਧਰਤੀ ਉੱਤੇ ਉਤਪਤ ਕੀਤਾ, ਉਸ ਸਮੇਂ ਤੋਂ ਲੈ ਕੇ ਆਪਣੇ ਪੈਦਾ ਹੋਣ ਦੇ ਦਿਨ ਤੱਕ ਦੀਆਂ ਗੱਲਾਂ ਪੁੱਛੋ ਅਤੇ ਅਕਾਸ਼ ਦੇ ਇੱਕ ਸਿਰੇ ਤੋਂ ਦੂਜੇ ਸਿਰੇ ਤੱਕ ਦੀਆਂ ਗੱਲਾਂ ਪੁੱਛੋ, ਕੀ ਕਦੀ ਅਜਿਹੀ ਵੱਡੀ ਗੱਲ ਕਦੀ ਹੋਈ ਜਾਂ ਕਦੀ ਸੁਣੀ ਗਈ ਹੈ? ");
INSERT INTO pan_vpl VALUES ("DT4_33","006_4_33","DEU","4","33","33","ਕੀ ਕਦੀ ਕਿਸੇ ਪਰਜਾ ਨੇ ਪਰਮੇਸ਼ੁਰ ਦੀ ਅਵਾਜ਼ ਅੱਗ ਦੇ ਵਿੱਚੋਂ ਦੀ ਬੋਲਦੀ ਹੋਈ ਸੁਣੀ ਅਤੇ ਜੀਉਂਦੀ ਰਹੀ, ਜਿਵੇਂ ਤੁਸੀਂ ਸੁਣੀ ਹੈ? ");
INSERT INTO pan_vpl VALUES ("DT4_34","006_4_34","DEU","4","34","34","ਕੀ ਪਰਮੇਸ਼ੁਰ ਨੇ ਕਦੀ ਜਤਨ ਕੀਤਾ ਕਿ ਜਾ ਕੇ ਆਪਣੇ ਲਈ ਇੱਕ ਕੌਮ ਨੂੰ ਦੂਜੀ ਕੌਮ ਦੇ ਵਿੱਚੋਂ ਪਰਤਾਵਿਆਂ, ਨਿਸ਼ਾਨਾਂ, ਅਚਰਜ਼ ਕੰਮਾਂ, ਯੁੱਧ, ਸ਼ਕਤੀਸ਼ਾਲੀ ਹੱਥ, ਪਸਾਰੀ ਹੋਈ ਬਾਂਹ ਅਤੇ ਵੱਡੇ-ਵੱਡੇ ਡਰਾਵਿਆਂ ਨਾਲ ਕੱਢ ਲਿਆਵੇ, ਜਿਵੇਂ ਯਹੋਵਾਹ ਤੁਹਾਡੇ ਪਰਮੇਸ਼ੁਰ ਨੇ ਮਿਸਰ ਵਿੱਚ ਤੁਹਾਡੇ ਵੇਖਦਿਆਂ ਤੁਹਾਡੇ ਲਈ ਕੀਤਾ? ");
INSERT INTO pan_vpl VALUES ("DT4_35","006_4_35","DEU","4","35","35","ਇਹ ਸਭ ਤੁਹਾਨੂੰ ਵਿਖਾਇਆ ਗਿਆ ਤਾਂ ਜੋ ਤੁਸੀਂ ਜਾਣੋ ਕਿ ਯਹੋਵਾਹ ਹੀ ਪਰਮੇਸ਼ੁਰ ਹੈ ਅਤੇ ਉਸ ਤੋਂ ਬਿਨ੍ਹਾਂ ਹੋਰ ਕੋਈ ਨਹੀਂ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("DT4_36","006_4_36","DEU","4","36","36","ਅਕਾਸ਼ ਤੋਂ ਉਸ ਨੇ ਤੁਹਾਨੂੰ ਆਪਣੀ ਅਵਾਜ਼ ਸੁਣਾਈ ਤਾਂ ਜੋ ਉਹ ਤੁਹਾਨੂੰ ਸਿੱਖਿਆ ਦੇਵੇ ਅਤੇ ਧਰਤੀ ਉੱਤੇ ਉਸਨੇ ਆਪਣੀ ਵੱਡੀ ਅੱਗ ਤੁਹਾਡੇ ਉੱਤੇ ਪਰਗਟ ਕੀਤੀ ਅਤੇ ਤੁਸੀਂ ਉਸ ਦੇ ਸ਼ਬਦ ਅੱਗ ਦੇ ਵਿੱਚੋਂ ਦੀ ਸੁਣੇ। ");
INSERT INTO pan_vpl VALUES ("DT4_37","006_4_37","DEU","4","37","37","ਕਿਉਂਕਿ ਉਸ ਨੇ ਤੁਹਾਡੇ ਪੁਰਖਿਆਂ ਨਾਲ ਪ੍ਰੇਮ ਰੱਖਿਆ ਇਸ ਕਾਰਨ ਉਸ ਨੇ ਉਨ੍ਹਾਂ ਦੇ ਬਾਅਦ ਉਨ੍ਹਾਂ ਦੇ ਵੰਸ਼ ਨੂੰ ਚੁਣਿਆ ਅਤੇ ਤੁਹਾਨੂੰ ਆਪਣੀ ਹਜ਼ੂਰੀ ਨਾਲ ਅਤੇ ਆਪਣੀ ਵੱਡੀ ਸ਼ਕਤੀ ਨਾਲ ਮਿਸਰ ਤੋਂ ਕੱਢ ਲਿਆਇਆ, ");
INSERT INTO pan_vpl VALUES ("DT4_38","006_4_38","DEU","4","38","38","ਉਹ ਤੁਹਾਡੇ ਨਾਲੋਂ ਵੱਡੀਆਂ ਅਤੇ ਬਲਵੰਤ ਕੌਮਾਂ ਨੂੰ ਤੁਹਾਡੇ ਅੱਗਿਓਂ ਕੱਢ ਦੇਵੇ ਅਤੇ ਤੁਹਾਨੂੰ ਉਨ੍ਹਾਂ ਦੇ ਦੇਸ਼ ਵਿੱਚ ਲਿਆਵੇ ਅਤੇ ਉਨ੍ਹਾਂ ਦੇ ਦੇਸ਼ ਨੂੰ ਤੇਰੀ ਵਿਰਾਸਤ ਬਣਾ ਦੇਵੇ, ਜਿਵੇਂ ਅੱਜ ਦੇ ਦਿਨ ਉਹ ਕਰਦਾ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("DT4_39","006_4_39","DEU","4","39","39","ਇਸ ਲਈ ਅੱਜ ਜਾਣ ਲਓ ਅਤੇ ਆਪਣੇ ਦਿਲਾਂ ਵਿੱਚ ਰੱਖੋ ਕਿ ਉੱਤੇ ਅਕਾਸ਼ ਵਿੱਚ ਅਤੇ ਹੇਠਾਂ ਧਰਤੀ ਉੱਤੇ ਯਹੋਵਾਹ ਹੀ ਪਰਮੇਸ਼ੁਰ ਹੈ, ਹੋਰ ਕੋਈ ਹੈ ਹੀ ਨਹੀਂ। ");
INSERT INTO pan_vpl VALUES ("DT4_40","006_4_40","DEU","4","40","40","ਤੁਸੀਂ ਉਸ ਦੀਆਂ ਬਿਧੀਆਂ ਅਤੇ ਹੁਕਮਾਂ ਦੀ ਪਾਲਨਾ ਕਰੋ ਜਿਹੜੇ ਮੈਂ ਅੱਜ ਤੁਹਾਨੂੰ ਦਿੰਦਾ ਹਾਂ, ਤਾਂ ਜੋ ਤੁਹਾਡਾ ਅਤੇ ਤੁਹਾਡੇ ਬਾਅਦ ਤੁਹਾਡੇ ਬੱਚਿਆਂ ਦਾ ਭਲਾ ਹੋਵੇ ਅਤੇ ਉਸ ਦੇਸ਼ ਵਿੱਚ ਜਿਹੜਾ ਯਹੋਵਾਹ ਪਰਮੇਸ਼ੁਰ ਤੁਹਾਨੂੰ ਸਦਾ ਲਈ ਦਿੰਦਾ ਹੈ, ਉਸ ਵਿੱਚ ਤੁਹਾਡੀ ਉਮਰ ਲੰਮੀ ਹੋਵੇ। ");
INSERT INTO pan_vpl VALUES ("DT4_41","006_4_41","DEU","4","41","41","ਤਦ ਮੂਸਾ ਨੇ ਯਰਦਨ ਦੇ ਪਾਰ ਪੂਰਬ ਵੱਲ ਤਿੰਨ ਸ਼ਹਿਰ ਵੱਖਰੇ ਕੀਤੇ, ");
INSERT INTO pan_vpl VALUES ("DT4_42","006_4_42","DEU","4","42","42","ਕਿ ਜੇਕਰ ਕੋਈ ਭੁੱਲ-ਭੁਲੇਖੇ ਆਪਣੇ ਗੁਆਂਢੀ ਨੂੰ ਮਾਰ ਦੇਵੇ ਜਿਸ ਨਾਲ ਉਸ ਦਾ ਪਹਿਲਾਂ ਤੋਂ ਕੋਈ ਵੈਰ ਨਹੀਂ ਸੀ, ਤਾਂ ਉਹ ਉਨ੍ਹਾਂ ਸ਼ਹਿਰਾਂ ਵਿੱਚੋਂ ਕਿਸੇ ਇੱਕ ਵਿੱਚ ਭੱਜ ਜਾਵੇ ਅਤੇ ਉੱਥੇ ਭੱਜ ਕੇ ਜੀਉਂਦਾ ਰਹੇ: ");
INSERT INTO pan_vpl VALUES ("DT4_43","006_4_43","DEU","4","43","43","ਅਰਥਾਤ ਰਊਬੇਨੀਆਂ ਦਾ ਬਸਰ ਸ਼ਹਿਰ ਜੋ ਉਜਾੜ ਵਿੱਚ ਉੱਚੇ ਮੈਦਾਨ ਦੇ ਦੇਸ਼ ਵਿੱਚ ਹੈ ਅਤੇ ਗਾਦੀਆਂ ਲਈ ਗਿਲਆਦ ਵਿੱਚ ਰਾਮੋਥ ਅਤੇ ਮਨੱਸ਼ੀਆਂ ਲਈ ਬਾਸ਼ਾਨ ਵਿੱਚ ਗੋਲਾਨ। ");
INSERT INTO pan_vpl VALUES ("DT4_44","006_4_44","DEU","4","44","44","ਇਹ ਉਹ ਬਿਵਸਥਾ ਹੈ ਜਿਹੜੀ ਮੂਸਾ ਨੇ ਇਸਰਾਏਲੀਆਂ ਦੇ ਅੱਗੇ ਰੱਖੀ ");
INSERT INTO pan_vpl VALUES ("DT4_45","006_4_45","DEU","4","45","45","ਅਤੇ ਇਹ ਉਹ ਸਾਖੀਆਂ, ਬਿਧੀਆਂ ਅਤੇ ਕਨੂੰਨ ਹਨ, ਜਿਹੜੇ ਮੂਸਾ ਨੇ ਇਸਰਾਏਲੀਆਂ ਨੂੰ ਉਸ ਸਮੇਂ ਦੱਸੇ ਜਦ ਉਹ ਮਿਸਰ ਤੋਂ ਨਿੱਕਲੇ, ");
INSERT INTO pan_vpl VALUES ("DT4_46","006_4_46","DEU","4","46","46","ਅਰਥਾਤ ਯਰਦਨ ਪਾਰ ਬੈਤ ਪਓਰ ਦੇ ਸਾਹਮਣੇ ਦੀ ਘਾਟੀ ਵਿੱਚ ਜੋ ਅਮੋਰੀਆਂ ਦੇ ਰਾਜੇ ਸੀਹੋਨ ਦੇ ਦੇਸ਼ ਵਿੱਚ ਸੀ। ਉਹ ਹਸ਼ਬੋਨ ਵਿੱਚ ਵੱਸਦਾ ਸੀ, ਜਿਸ ਨੂੰ ਮੂਸਾ ਅਤੇ ਇਸਰਾਏਲੀਆਂ ਨੇ ਮਾਰਿਆ, ਜਦ ਉਹ ਮਿਸਰ ਤੋਂ ਨਿੱਕਲੇ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("DT4_47","006_4_47","DEU","4","47","47","ਉਨ੍ਹਾਂ ਨੇ ਉਸ ਦੇ ਦੇਸ਼ ਉੱਤੇ ਅਤੇ ਬਾਸ਼ਾਨ ਦੇ ਰਾਜੇ ਓਗ ਦੇ ਦੇਸ਼ ਉੱਤੇ ਵੀ ਕਬਜ਼ਾ ਕਰ ਲਿਆ। ਇਹ ਦੋਵੇਂ ਅਮੋਰੀਆਂ ਦੇ ਰਾਜੇ ਸਨ ਅਤੇ ਉਹ ਯਰਦਨ ਦੇ ਪਾਰ ਪੂਰਬ ਵੱਲ ਵੱਸਦੇ ਸਨ। ");
INSERT INTO pan_vpl VALUES ("DT4_48","006_4_48","DEU","4","48","48","ਉਨ੍ਹਾਂ ਨੇ ਅਰੋਏਰ ਤੋਂ ਲੈ ਕੇ ਜਿਹੜਾ ਅਰਨੋਨ ਦੇ ਨਾਲੇ ਦੇ ਬੰਨ੍ਹੇ ਉੱਤੇ ਹੈ ਅਤੇ ਸੀਹੋਨ ਪਰਬਤ ਤੱਕ ਜਿਹੜਾ ਹਰਮੋਨ ਵੀ ਅਖਵਾਉਂਦਾ ਹੈ ");
INSERT INTO pan_vpl VALUES ("DT4_49","006_4_49","DEU","4","49","49","ਅਤੇ ਸਾਰੇ ਅਰਾਬਾਹ ਉੱਤੇ ਯਰਦਨ ਤੋਂ ਪਾਰ ਪੂਰਬ ਵੱਲ ਅਰਥਾਤ ਅਰਾਬਾਹ ਦੇ ਸਮੁੰਦਰ ਤੱਕ ਜਿਹੜਾ ਪਿਸਗਾਹ ਦੀ ਢਾਲ਼ ਹੇਠ ਹੈ, ਕਬਜ਼ਾ ਕਰ ਲਿਆ। ");
INSERT INTO pan_vpl VALUES ("DT5_1","006_5_1","DEU","5","1","1","ਮੂਸਾ ਨੇ ਸਾਰੇ ਇਸਰਾਏਲ, ਨੂੰ ਬੁਲਾ ਕੇ ਆਖਿਆ, “ਹੇ ਇਸਰਾਏਲ, ਇਹਨਾਂ ਬਿਧੀਆਂ ਅਤੇ ਕਨੂੰਨਾਂ ਨੂੰ ਸੁਣੋ, ਜਿਹੜੇ ਮੈਂ ਅੱਜ, ਤੁਹਾਡੇ ਕੰਨਾਂ ਵਿੱਚ ਪਾਉਂਦਾ ਹਾਂ। ਇਹਨਾਂ ਨੂੰ ਸਿੱਖੋ ਅਤੇ ਇਹਨਾਂ ਨੂੰ ਪੂਰਾ ਕਰਨ ਲਈ ਮੰਨੋ। ");
INSERT INTO pan_vpl VALUES ("DT5_2","006_5_2","DEU","5","2","2","ਯਹੋਵਾਹ ਸਾਡੇ ਪਰਮੇਸ਼ੁਰ ਨੇ ਹੋਰੇਬ ਵਿੱਚ ਸਾਡੇ ਨਾਲ ਨੇਮ ਬੰਨ੍ਹਿਆ, ");
INSERT INTO pan_vpl VALUES ("DT5_3","006_5_3","DEU","5","3","3","ਯਹੋਵਾਹ ਨੇ ਇਹ ਨੇਮ ਸਾਡੇ ਪੁਰਖਿਆਂ ਨਾਲ ਨਹੀਂ, ਪਰ ਸਾਡੇ ਨਾਲ ਬੰਨ੍ਹਿਆ, ਸਾਡੇ ਸਾਰਿਆਂ ਨਾਲ ਜਿਹੜੇ ਅੱਜ ਦੇ ਦਿਨ ਸਾਰੇ ਇੱਥੇ ਜੀਉਂਦੇ ਹਾਂ। ");
INSERT INTO pan_vpl VALUES ("DT5_4","006_5_4","DEU","5","4","4","ਯਹੋਵਾਹ ਅੱਗ ਦੇ ਵਿੱਚੋਂ ਦੀ ਪਰਬਤ ਉੱਤੋਂ ਤੁਹਾਡੇ ਨਾਲ ਆਹਮੋ-ਸਾਹਮਣੇ ਹੋ ਕੇ ਬੋਲਿਆ, ");
INSERT INTO pan_vpl VALUES ("DT5_5","006_5_5","DEU","5","5","5","(ਉਸ ਸਮੇਂ ਮੈਂ ਯਹੋਵਾਹ ਦੇ ਅਤੇ ਤੁਹਾਡੇ ਵਿਚਕਾਰ ਖੜ੍ਹਾ ਹੋਇਆ ਤਾਂ ਜੋ ਤੁਹਾਨੂੰ ਯਹੋਵਾਹ ਦਾ ਬਚਨ ਦੱਸਾਂ, ਕਿਉਂ ਜੋ ਤੁਸੀਂ ਅੱਗ ਤੋਂ ਡਰਦੇ ਸੀ ਅਤੇ ਪਰਬਤ ਉੱਤੇ ਨਾ ਚੜ੍ਹੇ)। ");
INSERT INTO pan_vpl VALUES ("DT5_6","006_5_6","DEU","5","6","6","ਉਸ ਨੇ ਆਖਿਆ ਮੈਂ ਯਹੋਵਾਹ ਤੇਰਾ ਪਰਮੇਸ਼ੁਰ ਹਾਂ, ਜਿਹੜਾ ਤੈਨੂੰ ਮਿਸਰ ਦੇਸ਼ ਤੋਂ, ਅਰਥਾਤ ਗ਼ੁਲਾਮੀ ਦੇ ਘਰ ਤੋਂ ਕੱਢ ਲਿਆਇਆ ਹਾਂ। ");
INSERT INTO pan_vpl VALUES ("DT5_7","006_5_7","DEU","5","7","7","ਮੇਰੇ ਸਨਮੁਖ ਤੇਰੇ ਲਈ ਦੂਜੇ ਦੇਵਤੇ ਨਾ ਹੋਣ। ");
INSERT INTO pan_vpl VALUES ("DT5_8","006_5_8","DEU","5","8","8","ਤੂੰ ਆਪਣੇ ਲਈ ਘੜ੍ਹੀ ਹੋਈ ਮੂਰਤ ਨਾ ਬਣਾਈਂ, ਨਾ ਕਿਸੇ ਚੀਜ਼ ਦੀ ਸੂਰਤ ਜਿਹੜੀ ਉੱਪਰ ਅਕਾਸ਼ ਵਿੱਚ, ਹੇਠਾਂ ਧਰਤੀ ਉੱਤੇ, ਅਤੇ ਜਿਹੜੀ ਧਰਤੀ ਦੇ ਹੇਠਲੇ ਪਾਣੀਆਂ ਵਿੱਚ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("DT5_9","006_5_9","DEU","5","9","9","ਨਾ ਤੂੰ ਉਹਨਾਂ ਦੇ ਅੱਗੇ ਮੱਥਾ ਟੇਕ, ਨਾ ਉਹਨਾਂ ਦੀ ਪੂਜਾ ਕਰ ਕਿਉਂ ਜੋ ਮੈਂ ਯਹੋਵਾਹ ਤੇਰਾ ਪਰਮੇਸ਼ੁਰ ਅਣਖ ਵਾਲਾ ਪਰਮੇਸ਼ੁਰ ਹਾਂ, ਜਿਹੜਾ ਪੁਰਖਿਆਂ, ਦੀ ਬੁਰਿਆਈ ਨੂੰ ਬੱਚਿਆਂ ਉੱਤੇ, ਅਤੇ ਆਪਣੇ ਵੈਰੀਆਂ ਦੀ ਤੀਜੀ ਅਤੇ ਚੌਥੀ ਪੀੜ੍ਹੀ ਉੱਤੇ ਲਿਆਉਂਦਾ ਹਾਂ, ");
INSERT INTO pan_vpl VALUES ("DT5_10","006_5_10","DEU","5","10","10","ਪਰ ਜਿਹੜੇ ਮੇਰੇ ਨਾਲ ਪ੍ਰੇਮ ਰੱਖਦੇ ਹਨ ਅਤੇ ਮੇਰੇ ਹੁਕਮਾਂ ਨੂੰ ਮੰਨਦੇ ਹਨ, ਉਨ੍ਹਾਂ ਦੇ ਹਜ਼ਾਰਾਂ ਉੱਤੇ ਦਯਾ ਕਰਦਾ ਹਾਂ। ");
INSERT INTO pan_vpl VALUES ("DT5_11","006_5_11","DEU","5","11","11","ਤੂੰ ਯਹੋਵਾਹ ਆਪਣੇ ਪਰਮੇਸ਼ੁਰ ਦਾ ਨਾਮ ਵਿਅਰਥ ਨਾ ਲੈ ਕਿਉਂਕਿ ਜੋ ਕੋਈ ਉਹ ਦਾ ਨਾਮ ਵਿਅਰਥ ਲੈਂਦਾ ਹੈ, ਯਹੋਵਾਹ ਉਸ ਨੂੰ ਨਿਰਦੋਸ਼ ਨਾ ਠਹਿਰਾਵੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("DT5_12","006_5_12","DEU","5","12","12","ਤੂੰ ਸਬਤ ਦੇ ਦਿਨ ਨੂੰ ਪਵਿੱਤਰ ਜਾਣ ਕੇ ਯਾਦ ਰੱਖ, ਜਿਵੇਂ ਯਹੋਵਾਹ ਤੇਰੇ ਪਰਮੇਸ਼ੁਰ ਨੇ ਤੈਨੂੰ ਹੁਕਮ ਦਿੱਤਾ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("DT5_13","006_5_13","DEU","5","13","13","ਛੇ ਦਿਨ ਤੂੰ ਮਿਹਨਤ ਕਰ ਅਤੇ ਆਪਣਾ ਸਾਰਾ ਕੰਮ-ਧੰਦਾ ਕਰ, ");
INSERT INTO pan_vpl VALUES ("DT5_14","006_5_14","DEU","5","14","14","ਪਰ ਸੱਤਵਾਂ ਦਿਨ ਯਹੋਵਾਹ ਤੇਰੇ ਪਰਮੇਸ਼ੁਰ ਲਈ ਸਬਤ ਹੈ। ਉਸ ਦਿਨ ਵਿੱਚ ਤੂੰ ਕੋਈ ਕੰਮ-ਧੰਦਾ ਨਾ ਕਰ, ਨਾ ਤੂੰ, ਨਾ ਤੇਰਾ ਪੁੱਤਰ, ਨਾ ਤੇਰੀ ਧੀ, ਨਾ ਤੇਰਾ ਦਾਸ, ਨਾ ਤੇਰੀ ਦਾਸੀ, ਨਾ ਤੇਰਾ ਬਲ਼ਦ, ਨਾ ਤੇਰਾ ਗਧਾ, ਨਾ ਤੇਰਾ ਕੋਈ ਪਸ਼ੂ, ਨਾ ਕੋਈ ਪਰਦੇਸੀ ਜਿਹੜਾ ਤੇਰੇ ਫਾਟਕਾਂ ਦੇ ਅੰਦਰ ਹੈ, ਜਿਸ ਨਾਲ ਤੇਰਾ ਦਾਸ ਅਤੇ ਤੇਰੀ ਦਾਸੀ ਵੀ ਤੇਰੇ ਵਾਂਗੂੰ ਅਰਾਮ ਕਰਨ। ");
INSERT INTO pan_vpl VALUES ("DT5_15","006_5_15","DEU","5","15","15","ਯਾਦ ਰੱਖ ਕਿ ਤੂੰ ਵੀ ਮਿਸਰ ਦੇਸ਼ ਵਿੱਚ ਗੁਲਾਮ ਸੀ ਅਤੇ ਯਹੋਵਾਹ ਤੇਰੇ ਪਰਮੇਸ਼ੁਰ ਨੇ ਬਲਵੰਤ ਹੱਥ ਅਤੇ ਪਸਾਰੀ ਹੋਈ ਬਾਂਹ ਨਾਲ ਤੈਨੂੰ ਕੱਢ ਲਿਆ, ਇਸ ਲਈ ਯਹੋਵਾਹ ਤੇਰਾ ਪਰਮੇਸ਼ੁਰ ਤੈਨੂੰ ਸਬਤ ਦੇ ਮੰਨਣ ਦਾ ਹੁਕਮ ਦਿੰਦਾ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("DT5_16","006_5_16","DEU","5","16","16","ਤੂੰ ਆਪਣੇ ਪਿਤਾ ਅਤੇ ਆਪਣੀ ਮਾਤਾ ਦਾ ਆਦਰ ਕਰ, ਜਿਵੇਂ ਯਹੋਵਾਹ ਤੇਰੇ ਪਰਮੇਸ਼ੁਰ ਨੇ ਤੈਨੂੰ ਹੁਕਮ ਦਿੱਤਾ ਸੀ, ਤਾਂ ਜੋ ਤੇਰੀ ਉਮਰ ਲੰਮੀ ਹੋਵੇ ਅਤੇ ਉਸ ਦੇਸ਼ ਵਿੱਚ ਜਿਹੜਾ ਯਹੋਵਾਹ ਤੇਰਾ ਪਰਮੇਸ਼ੁਰ ਤੈਨੂੰ ਦਿੰਦਾ ਹੈ, ਤੇਰਾ ਭਲਾ ਹੋਵੇ। ");
INSERT INTO pan_vpl VALUES ("DT5_17","006_5_17","DEU","5","17","17","ਤੂੰ ਖ਼ੂਨ ਨਾ ਕਰ। ");
INSERT INTO pan_vpl VALUES ("DT5_18","006_5_18","DEU","5","18","18","ਤੂੰ ਵਿਭਚਾਰ ਨਾ ਕਰ। ");
INSERT INTO pan_vpl VALUES ("DT5_19","006_5_19","DEU","5","19","19","ਤੂੰ ਚੋਰੀ ਨਾ ਕਰ। ");
INSERT INTO pan_vpl VALUES ("DT5_20","006_5_20","DEU","5","20","20","ਤੂੰ ਆਪਣੇ ਗੁਆਂਢੀ ਦੇ ਵਿਰੁੱਧ ਝੂਠੀ ਗਵਾਹੀ ਨਾ ਦੇ। ");
INSERT INTO pan_vpl VALUES ("DT5_21","006_5_21","DEU","5","21","21","ਤੂੰ ਆਪਣੇ ਗੁਆਂਢੀ ਦੀ ਪਤਨੀ ਦੀ ਲਾਲਸਾ ਨਾ ਕਰ, ਤੂੰ ਆਪਣੇ ਗੁਆਂਢੀ ਦੇ ਘਰ ਦਾ ਲਾਲਚ ਨਾ ਕਰ, ਨਾ ਉਹ ਦੇ ਖੇਤ ਦਾ, ਨਾ ਉਹ ਦੇ ਦਾਸ ਦਾ, ਨਾ ਉਹ ਦੀ ਦਾਸੀ ਦਾ, ਨਾ ਉਹ ਦੇ ਬਲ਼ਦ ਦਾ, ਨਾ ਉਹ ਦੇ ਗਧੇ ਦਾ, ਅਤੇ ਨਾ ਹੀ ਆਪਣੇ ਗੁਆਂਢੀ ਦੀ ਕਿਸੇ ਚੀਜ਼ ਦਾ ਲਾਲਚ ਕਰ। ");
INSERT INTO pan_vpl VALUES ("DT5_22","006_5_22","DEU","5","22","22","ਇਹੋ ਸਾਰੇ ਬਚਨ ਯਹੋਵਾਹ ਨੇ ਉਸ ਪਰਬਤ ਉੱਤੇ ਅੱਗ, ਬੱਦਲ ਅਤੇ ਕਾਲੀਆਂ ਘਟਾਂ ਦੇ ਵਿੱਚੋਂ ਦੀ ਹੋ ਕੇ ਤੁਹਾਡੀ ਸਾਰੀ ਸਭਾ ਨੂੰ ਵੱਡੀ ਅਵਾਜ਼ ਨਾਲ ਆਖੇ ਸਨ ਅਤੇ ਹੋਰ ਕੁਝ ਨਾ ਆਖਿਆ ਪਰ ਉਸ ਨੇ ਉਨ੍ਹਾਂ ਨੂੰ ਪੱਥਰ ਦੀਆਂ ਦੋ ਫੱਟੀਆਂ ਉੱਤੇ ਲਿਖ ਕੇ ਮੈਨੂੰ ਦੇ ਦਿੱਤਾ। ");
INSERT INTO pan_vpl VALUES ("DT5_23","006_5_23","DEU","5","23","23","ਤਦ ਅਜਿਹਾ ਹੋਇਆ ਕਿ ਜਦ ਤੁਸੀਂ ਉਸ ਅਵਾਜ਼ ਨੂੰ ਉਸ ਹਨੇਰੇ ਵਿੱਚੋਂ ਸੁਣਿਆ, ਜਦ ਪਰਬਤ ਅੱਗ ਨਾਲ ਬਲ ਰਿਹਾ ਸੀ, ਤਾਂ ਤੁਸੀਂ ਅਤੇ ਤੁਹਾਡੇ ਗੋਤਾਂ ਦੇ ਸਾਰੇ ਮੁਖੀਏ ਅਤੇ ਤੁਹਾਡੇ ਬਜ਼ੁਰਗ ਮੇਰੇ ਕੋਲ ਆਏ ");
INSERT INTO pan_vpl VALUES ("DT5_24","006_5_24","DEU","5","24","24","ਅਤੇ ਤੁਸੀਂ ਆਖਿਆ, ਵੇਖੋ ਯਹੋਵਾਹ ਸਾਡੇ ਪਰਮੇਸ਼ੁਰ ਨੇ ਆਪਣੀ ਮਹਿਮਾ ਅਤੇ ਵਡਿਆਈ ਸਾਡੇ ਉੱਤੇ ਪਰਗਟ ਕੀਤੀ ਹੈ ਅਤੇ ਅਸੀਂ ਉਸ ਦੀ ਅਵਾਜ਼ ਨੂੰ ਅੱਗ ਦੇ ਵਿੱਚੋਂ ਦੀ ਸੁਣਿਆ ਹੈ। ਅੱਜ ਦੇ ਦਿਨ ਅਸੀਂ ਵੇਖਿਆ ਹੈ ਕਿ ਪਰਮੇਸ਼ੁਰ ਮਨੁੱਖ ਨਾਲ ਗੱਲਾਂ ਕਰਦਾ ਹੈ ਅਤੇ ਮਨੁੱਖ ਜੀਉਂਦਾ ਰਹਿੰਦਾ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("DT5_25","006_5_25","DEU","5","25","25","ਇਸ ਲਈ ਹੁਣ ਅਸੀਂ ਕਿਉਂ ਮਰੀਏ? ਕਿਉਂ ਜੋ ਇਹ ਵੱਡੀ ਅੱਗ ਸਾਨੂੰ ਭਸਮ ਕਰ ਦੇਵੇਗੀ, ਜੇਕਰ ਅਸੀਂ ਫੇਰ ਯਹੋਵਾਹ ਆਪਣੇ ਪਰਮੇਸ਼ੁਰ ਦੀ ਅਵਾਜ਼ ਸੁਣੀਏ ਤਾਂ ਅਸੀਂ ਮਰ ਜਾਂਵਾਂਗੇ। ");
INSERT INTO pan_vpl VALUES ("DT5_26","006_5_26","DEU","5","26","26","ਕਿਉਂ ਜੋ ਸਾਰੇ ਪ੍ਰਾਣੀਆਂ ਵਿੱਚੋਂ ਕਿਹੜਾ ਹੈ, ਜਿਸ ਨੇ ਜੀਉਂਦੇ ਪਰਮੇਸ਼ੁਰ ਦੀ ਅਵਾਜ਼ ਅੱਗ ਦੇ ਵਿੱਚੋਂ ਦੀ ਬੋਲਦੇ ਹੋਏ ਸੁਣੀ ਹੋਵੇ, ਜਿਵੇਂ ਅਸੀਂ ਸੁਣੀ ਹੈ ਅਤੇ ਜੀਉਂਦਾ ਰਿਹਾ ਹੋਵੇ? ");
INSERT INTO pan_vpl VALUES ("DT5_27","006_5_27","DEU","5","27","27","ਤੂੰ ਨਜ਼ਦੀਕ ਜਾ ਅਤੇ ਜੋ ਕੁਝ ਯਹੋਵਾਹ ਸਾਡਾ ਪਰਮੇਸ਼ੁਰ ਆਖੇ ਸੁਣ ਅਤੇ ਫਿਰ ਜੋ ਕੁਝ ਯਹੋਵਾਹ ਸਾਡਾ ਪਰਮੇਸ਼ੁਰ ਤੈਨੂੰ ਆਖੇ ਉਹ ਸਾਨੂੰ ਦੱਸ ਅਤੇ ਅਸੀਂ ਸੁਣਾਂਗੇ ਅਤੇ ਮੰਨਾਂਗੇ। ");
INSERT INTO pan_vpl VALUES ("DT5_28","006_5_28","DEU","5","28","28","ਜਦ ਤੁਸੀਂ ਮੈਨੂੰ ਇਹ ਗੱਲਾਂ ਆਖਦੇ ਸੀ ਤਾਂ ਯਹੋਵਾਹ ਨੇ ਤੁਹਾਡੀਆਂ ਗੱਲਾਂ ਸੁਣੀਆਂ, ਤਦ ਯਹੋਵਾਹ ਨੇ ਮੈਨੂੰ ਆਖਿਆ, ਮੈਂ ਇਸ ਪਰਜਾ ਦੀਆਂ ਗੱਲਾਂ ਸੁਣੀਆਂ ਹਨ, ਜਿਹੜੀਆਂ ਉਹ ਤੈਨੂੰ ਆਖਦੇ ਹਨ। ਜੋ ਕੁਝ ਉਨ੍ਹਾਂ ਨੇ ਬੋਲਿਆ ਹੈ, ਉਹ ਠੀਕ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("DT5_29","006_5_29","DEU","5","29","29","ਭਲਾ ਹੁੰਦਾ ਜੇ ਉਨ੍ਹਾਂ ਵਿੱਚ ਅਜਿਹਾ ਹੀ ਮਨ ਹਮੇਸ਼ਾ ਹੁੰਦਾ ਕਿ ਉਹ ਮੈਥੋਂ ਡਰਦੇ ਅਤੇ ਸਦਾ ਮੇਰੇ ਹੁਕਮਾਂ ਨੂੰ ਮੰਨਦੇ, ਤਾਂ ਜੋ ਉਨ੍ਹਾਂ ਦਾ ਅਤੇ ਉਨ੍ਹਾਂ ਦੇ ਬੱਚਿਆਂ ਦਾ ਸਦਾ ਤੱਕ ਭਲਾ ਹੁੰਦਾ! ");
INSERT INTO pan_vpl VALUES ("DT5_30","006_5_30","DEU","5","30","30","ਤੂੰ ਜਾ ਕੇ ਉਨ੍ਹਾਂ ਨੂੰ ਆਖ, “ਆਪਣੇ-ਆਪਣੇ ਤੰਬੂਆਂ ਨੂੰ ਮੁੜ ਜਾਓ।” ");
INSERT INTO pan_vpl VALUES ("DT5_31","006_5_31","DEU","5","31","31","ਪਰ ਤੂੰ ਇੱਥੇ ਮੇਰੇ ਕੋਲ ਖੜ੍ਹਾ ਹੋ ਜਾ ਅਤੇ ਮੈਂ ਤੈਨੂੰ ਉਹ ਸਾਰਾ ਹੁਕਮਨਾਮਾ, ਬਿਧੀਆਂ ਅਤੇ ਕਨੂੰਨ ਦੱਸਾਂਗਾ, ਜਿਹੜੇ ਤੂੰ ਉਨ੍ਹਾਂ ਨੂੰ ਸਿਖਾਉਣੇ ਹਨ, ਤਾਂ ਜੋ ਉਹ ਉਨ੍ਹਾਂ ਨੂੰ ਉਸ ਦੇਸ਼ ਵਿੱਚ ਪੂਰਾ ਕਰਨ ਜਿਹੜਾ ਮੈਂ ਉਨ੍ਹਾਂ ਨੂੰ ਅਧਿਕਾਰ ਕਰਨ ਲਈ ਦਿੰਦਾ ਹਾਂ। ");
INSERT INTO pan_vpl VALUES ("DT5_32","006_5_32","DEU","5","32","32","ਤੁਸੀਂ ਉਨ੍ਹਾਂ ਹੁਕਮਾਂ ਦੀ ਪਾਲਨਾ ਕਰਿਓ ਜਿਹੜੇ ਯਹੋਵਾਹ ਤੁਹਾਡੇ ਪਰਮੇਸ਼ੁਰ ਨੇ ਤੁਹਾਨੂੰ ਦਿੱਤੇ ਹਨ। ਤੁਸੀਂ ਨਾ ਤਾਂ ਸੱਜੇ ਮੁੜਿਓ ਨਾ ਹੀ ਖੱਬੇ। ");
INSERT INTO pan_vpl VALUES ("DT5_33","006_5_33","DEU","5","33","33","ਜਿਸ ਰਾਹ ਉੱਤੇ ਚੱਲਣ ਦਾ ਯਹੋਵਾਹ ਤੁਹਾਡੇ ਪਰਮੇਸ਼ੁਰ ਨੇ ਤੁਹਾਨੂੰ ਹੁਕਮ ਦਿੱਤਾ ਹੈ, ਉਸ ਸਾਰੇ ਰਾਹ ਚੱਲਦੇ ਰਹੋ ਤਾਂ ਜੋ ਤੁਸੀਂ ਜੀਉਂਦੇ ਰਹੋ ਅਤੇ ਤੁਹਾਡਾ ਭਲਾ ਹੋਵੇ ਅਤੇ ਉਸ ਦੇਸ਼ ਵਿੱਚ ਜਿਸ ਨੂੰ ਅਧਿਕਾਰ ਵਿੱਚ ਲੈਣ ਲਈ ਤੁਸੀਂ ਜਾਂਦੇ ਹੋ, ਤੁਸੀਂ ਬਹੁਤ ਦਿਨਾਂ ਤੱਕ ਜੀਉਂਦੇ ਰਹੋ। ");
INSERT INTO pan_vpl VALUES ("DT6_1","006_6_1","DEU","6","1","1","ਇਹ ਉਹ ਹੁਕਮਨਾਮੇ, ਬਿਧੀਆਂ ਅਤੇ ਕਨੂੰਨ ਹਨ, ਜਿਨ੍ਹਾਂ ਨੂੰ ਤੁਹਾਨੂੰ ਸਿਖਾਉਣ ਦਾ ਹੁਕਮ ਯਹੋਵਾਹ ਤੁਹਾਡੇ ਪਰਮੇਸ਼ੁਰ ਨੇ ਦਿੱਤਾ ਹੈ, ਤਾਂ ਜੋ ਤੁਸੀਂ ਇਨ੍ਹਾਂ ਨੂੰ ਉਸ ਧਰਤੀ ਵਿੱਚ ਪੂਰਾ ਕਰੋ, ਜਿਸ ਉੱਤੇ ਅਧਿਕਾਰ ਕਰਨ ਲਈ ਤੁਸੀਂ ਪਾਰ ਜਾਂਦੇ ਹੋ, ");
INSERT INTO pan_vpl VALUES ("DT6_2","006_6_2","DEU","6","2","2","ਤਾਂ ਜੋ ਤੁਸੀਂ ਯਹੋਵਾਹ ਆਪਣੇ ਪਰਮੇਸ਼ੁਰ ਤੋਂ ਡਰੋ ਅਤੇ ਉਸ ਦੀਆਂ ਸਾਰੀਆਂ ਬਿਧੀਆਂ ਅਤੇ ਹੁਕਮਾਂ ਨੂੰ ਜਿਨ੍ਹਾਂ ਦਾ ਮੈਂ ਤੁਹਾਨੂੰ ਹੁਕਮ ਦਿੰਦਾ ਹਾਂ ਤੁਸੀਂ, ਤੁਹਾਡੇ ਪੁੱਤਰ ਅਤੇ ਤੁਹਾਡੇ ਪੋਤਰੇ ਜੀਵਨ ਭਰ ਮੰਨਣ, ਤਾਂ ਜੋ ਤੁਹਾਡੇ ਦਿਨ ਲੰਮੇ ਹੋਣ। ");
INSERT INTO pan_vpl VALUES ("DT6_3","006_6_3","DEU","6","3","3","ਹੇ ਇਸਰਾਏਲ, ਸੁਣੋ ਅਤੇ ਇਸੇ ਤਰ੍ਹਾਂ ਹੀ ਕਰਨ ਦਾ ਜਤਨ ਕਰੋ ਤਾਂ ਜੋ ਤੁਹਾਡਾ ਭਲਾ ਹੋਵੇ ਅਤੇ ਜਿਵੇਂ ਯਹੋਵਾਹ ਤੁਹਾਡੇ ਪੁਰਖਿਆਂ ਦੇ ਪਰਮੇਸ਼ੁਰ ਨੇ ਤੁਹਾਨੂੰ ਬਚਨ ਦਿੱਤਾ ਹੈ, ਤੁਸੀਂ ਉਸ ਦੇਸ਼ ਵਿੱਚ ਜਿੱਥੇ ਦੁੱਧ ਅਤੇ ਸ਼ਹਿਦ ਵਗਦਾ ਹੈ ਬਹੁਤ ਹੀ ਵੱਧ ਜਾਓ। ");
INSERT INTO pan_vpl VALUES ("DT6_4","006_6_4","DEU","6","4","4","ਹੇ ਇਸਰਾਏਲ, ਸੁਣ! ਯਹੋਵਾਹ ਸਾਡਾ ਪਰਮੇਸ਼ੁਰ ਇੱਕੋ ਹੀ ਯਹੋਵਾਹ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("DT6_5","006_6_5","DEU","6","5","5","ਤੁਸੀਂ ਯਹੋਵਾਹ ਆਪਣੇ ਪਰਮੇਸ਼ੁਰ ਨੂੰ ਆਪਣੇ ਸਾਰੇ ਦਿਲ, ਆਪਣੀ ਸਾਰੀ ਜਾਨ ਅਤੇ ਆਪਣੀ ਸਾਰੀ ਸ਼ਕਤੀ ਨਾਲ ਪਿਆਰ ਕਰੋ ");
INSERT INTO pan_vpl VALUES ("DT6_6","006_6_6","DEU","6","6","6","ਅਤੇ ਇਹ ਗੱਲਾਂ, ਜਿਨ੍ਹਾਂ ਦਾ ਹੁਕਮ ਮੈਂ ਅੱਜ ਤੁਹਾਨੂੰ ਦਿੰਦਾ ਹਾਂ, ਤੁਹਾਡੇ ਦਿਲ ਵਿੱਚ ਬਣੀਆਂ ਰਹਿਣ। ");
INSERT INTO pan_vpl VALUES ("DT6_7","006_6_7","DEU","6","7","7","ਤੁਸੀਂ ਇਹਨਾਂ ਨੂੰ ਆਪਣੇ ਬੱਚਿਆਂ ਨੂੰ ਸਿਖਾਇਓ। ਤੁਸੀਂ ਆਪਣੇ ਘਰ ਵਿੱਚ ਬੈਠਦਿਆਂ, ਰਾਹ ਵਿੱਚ ਤੁਰਦਿਆਂ, ਲੇਟਦਿਆਂ ਅਤੇ ਉੱਠਦਿਆਂ ਇਹਨਾਂ ਗੱਲਾਂ ਦੀ ਚਰਚਾ ਕਰਦੇ ਰਹਿਣਾ। ");
INSERT INTO pan_vpl VALUES ("DT6_8","006_6_8","DEU","6","8","8","ਤੁਸੀਂ ਉਹਨਾਂ ਨੂੰ ਨਿਸ਼ਾਨੀਆਂ ਲਈ ਆਪਣੇ ਹੱਥ ਉੱਤੇ ਬੰਨ੍ਹਣਾ ਅਤੇ ਉਹ ਤੁਹਾਡੀਆਂ ਅੱਖਾਂ ਦੇ ਵਿਚਕਾਰ ਟਿੱਕੇ ਵਾਂਗੂੰ ਹੋਣ। ");
INSERT INTO pan_vpl VALUES ("DT6_9","006_6_9","DEU","6","9","9","ਤੁਸੀਂ ਉਹਨਾਂ ਨੂੰ ਆਪਣੇ ਘਰਾਂ ਦੀਆਂ ਚੁਗਾਠਾਂ ਉੱਤੇ ਅਤੇ ਆਪਣੇ ਫਾਟਕਾਂ ਉੱਤੇ ਲਿਖਿਓ। ");
INSERT INTO pan_vpl VALUES ("DT6_10","006_6_10","DEU","6","10","10","ਜਦ ਯਹੋਵਾਹ ਤੁਹਾਡਾ ਪਰਮੇਸ਼ੁਰ ਤੁਹਾਨੂੰ ਉਸ ਦੇਸ਼ ਵਿੱਚ ਪਹੁੰਚਾਵੇ, ਜਿਸ ਨੂੰ ਤੁਹਾਨੂੰ ਦੇਣ ਦੀ ਉਸਨੇ ਤੁਹਾਡੇ ਪੁਰਖਿਆਂ ਨਾਲ ਅਰਥਾਤ ਅਬਰਾਹਾਮ, ਇਸਹਾਕ ਅਤੇ ਯਾਕੂਬ ਨਾਲ ਸਹੁੰ ਖਾਧੀ ਸੀ ਅਤੇ ਜਦ ਉਹ ਤੈਨੂੰ ਵੱਡੇ ਅਤੇ ਚੰਗੇ ਸ਼ਹਿਰ ਜਿਹੜੇ ਤੁਸੀਂ ਨਹੀਂ ਬਣਾਏ ");
INSERT INTO pan_vpl VALUES ("DT6_11","006_6_11","DEU","6","11","11","ਅਤੇ ਚੰਗੀਆਂ ਚੀਜ਼ਾਂ ਨਾਲ ਭਰੇ ਹੋਏ ਘਰ, ਜਿਹੜੇ ਤੁਸੀਂ ਨਹੀਂ ਭਰੇ ਅਤੇ ਪੁੱਟੇ ਹੋਏ ਹੌਦ ਜਿਹੜੇ ਤੁਸੀਂ ਨਹੀਂ ਪੁੱਟੇ, ਅੰਗੂਰੀ ਬਾਗ਼ ਅਤੇ ਜ਼ੈਤੂਨ ਦੇ ਰੁੱਖ ਜਿਹੜੇ ਤੁਸੀਂ ਨਹੀਂ ਲਾਏ ਦੇਵੇਗਾ, ਜਿਨ੍ਹਾਂ ਤੋਂ ਤੁਸੀਂ ਖਾਓਗੇ ਅਤੇ ਰੱਜ ਜਾਓਗੇ, ");
INSERT INTO pan_vpl VALUES ("DT6_12","006_6_12","DEU","6","12","12","ਤਦ ਤੁਸੀਂ ਚੌਕਸ ਰਹਿਓ, ਕਿਤੇ ਅਜਿਹਾ ਨਾ ਹੋਵੇ ਕਿ ਤੁਸੀਂ ਯਹੋਵਾਹ ਨੂੰ ਭੁੱਲ ਜਾਓ, ਜਿਹੜਾ ਤੁਹਾਨੂੰ ਮਿਸਰ ਦੇਸ਼ ਤੋਂ ਅਰਥਾਤ ਗੁਲਾਮੀ ਦੇ ਘਰ ਤੋਂ ਕੱਢ ਲਿਆਇਆ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("DT6_13","006_6_13","DEU","6","13","13","ਯਹੋਵਾਹ ਆਪਣੇ ਪਰਮੇਸ਼ੁਰ ਤੋਂ ਡਰੋ, ਉਸੇ ਦੀ ਸੇਵਾ ਕਰੋ ਅਤੇ ਉਸ ਦੇ ਨਾਮ ਦੀ ਸਹੁੰ ਖਾਓ। ");
INSERT INTO pan_vpl VALUES ("DT6_14","006_6_14","DEU","6","14","14","ਤੁਸੀਂ ਦੂਜੇ ਦੇਵਤਿਆਂ ਦੇ ਪਿੱਛੇ ਨਾ ਜਾਇਓ ਅਰਥਾਤ ਉਨ੍ਹਾਂ ਲੋਕਾਂ ਦੇ ਦੇਵਤਿਆਂ ਦੇ ਪਿੱਛੇ ਜਿਹੜੇ ਤੁਹਾਡੇ ਆਲੇ-ਦੁਆਲੇ ਹਨ, ");
INSERT INTO pan_vpl VALUES ("DT6_15","006_6_15","DEU","6","15","15","ਕਿਉਂ ਜੋ ਯਹੋਵਾਹ ਤੁਹਾਡਾ ਪਰਮੇਸ਼ੁਰ, ਜੋ ਤੁਹਾਡੇ ਵਿਚਕਾਰ ਹੈ, ਇੱਕ ਅਣਖ ਵਾਲਾ ਪਰਮੇਸ਼ੁਰ ਹੈ, ਅਜਿਹਾ ਨਾ ਹੋਵੇ ਕਿ ਯਹੋਵਾਹ ਤੁਹਾਡੇ ਪਰਮੇਸ਼ੁਰ ਦਾ ਕ੍ਰੋਧ ਤੁਹਾਡੇ ਉੱਤੇ ਭੜਕੇ ਅਤੇ ਉਹ ਤੁਹਾਨੂੰ ਧਰਤੀ ਉੱਤੋਂ ਮਿਟਾ ਦੇਵੇ। ");
INSERT INTO pan_vpl VALUES ("DT6_16","006_6_16","DEU","6","16","16","ਤੁਸੀਂ ਯਹੋਵਾਹ ਆਪਣੇ ਪਰਮੇਸ਼ੁਰ ਦੀ ਪ੍ਰੀਖਿਆ ਨਾ ਲੈਣਾ, ਜਿਵੇਂ ਤੁਸੀਂ ਮੱਸਾਹ ਵਿੱਚ ਕੀਤਾ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("DT6_17","006_6_17","DEU","6","17","17","ਤੁਸੀਂ ਜ਼ਰੂਰ ਹੀ ਯਹੋਵਾਹ ਆਪਣੇ ਪਰਮੇਸ਼ੁਰ ਦੇ ਹੁਕਮਾਂ, ਉਸ ਦੀਆਂ ਸਾਖੀਆਂ ਅਤੇ ਉਸ ਦੀਆਂ ਬਿਧੀਆਂ ਦੀ ਪਾਲਨਾ ਕਰਿਓ, ਜਿਨ੍ਹਾਂ ਦਾ ਉਸ ਨੇ ਤੁਹਾਨੂੰ ਹੁਕਮ ਦਿੱਤਾ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("DT6_18","006_6_18","DEU","6","18","18","ਜੋ ਕੁਝ ਯਹੋਵਾਹ ਦੀ ਨਿਗਾਹ ਵਿੱਚ ਠੀਕ ਅਤੇ ਚੰਗਾ ਹੈ, ਤੁਸੀਂ ਉਹ ਹੀ ਕਰਿਓ ਤਾਂ ਜੋ ਤੁਹਾਡਾ ਭਲਾ ਹੋਵੇ ਅਤੇ ਤੁਸੀਂ ਉਸ ਚੰਗੇ ਦੇਸ਼ ਵਿੱਚ ਜਾ ਕੇ ਉਸ ਉੱਤੇ ਅਧਿਕਾਰ ਕਰੋ, ਜਿਸ ਦੀ ਸਹੁੰ ਯਹੋਵਾਹ ਨੇ ਤੁਹਾਡੇ ਪੁਰਖਿਆਂ ਨਾਲ ਖਾਧੀ ਸੀ ");
INSERT INTO pan_vpl VALUES ("DT6_19","006_6_19","DEU","6","19","19","ਅਤੇ ਉਹ ਤੁਹਾਡੇ ਸਾਰੇ ਵੈਰੀਆਂ ਨੂੰ ਤੁਹਾਡੇ ਅੱਗਿਓਂ ਕੱਢ ਦੇਵੇਗਾ, ਜਿਵੇਂ ਯਹੋਵਾਹ ਨੇ ਬਚਨ ਕੀਤਾ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("DT6_20","006_6_20","DEU","6","20","20","ਜਦ ਅੱਗੇ ਨੂੰ ਤੁਹਾਡੇ ਪੁੱਤਰ ਤੁਹਾਨੂੰ ਪੁੱਛਣ ਕਿ ਉਹਨਾਂ ਸਾਖੀਆਂ, ਬਿਧੀਆਂ ਅਤੇ ਕਨੂੰਨਾਂ ਦਾ ਕੀ ਉਦੇਸ਼ ਹੈ ਜਿਨ੍ਹਾਂ ਦਾ ਸਾਡੇ ਪਰਮੇਸ਼ੁਰ ਯਹੋਵਾਹ ਨੇ ਤੁਹਾਨੂੰ ਹੁਕਮ ਦਿੱਤਾ ਸੀ? ");
INSERT INTO pan_vpl VALUES ("DT6_21","006_6_21","DEU","6","21","21","ਤਦ ਤੁਸੀਂ ਆਪਣੇ ਪੁੱਤਰਾਂ ਨੂੰ ਦੱਸਿਓ, ਅਸੀਂ ਮਿਸਰ ਵਿੱਚ ਫ਼ਿਰਊਨ ਦੇ ਗੁਲਾਮ ਸੀ ਅਤੇ ਯਹੋਵਾਹ ਸਾਨੂੰ ਮਿਸਰ ਤੋਂ ਬਲਵੰਤ ਹੱਥ ਨਾਲ ਕੱਢ ਲਿਆਇਆ। ");
INSERT INTO pan_vpl VALUES ("DT6_22","006_6_22","DEU","6","22","22","ਯਹੋਵਾਹ ਨੇ ਮਿਸਰ ਵਿੱਚ ਫ਼ਿਰਊਨ ਅਤੇ ਉਸ ਦੇ ਸਾਰੇ ਘਰਾਣੇ ਨਾਲ ਸਾਡੇ ਵੇਖਦਿਆਂ, ਵੱਡੇ ਅਤੇ ਦੁੱਖਦਾਇਕ ਨਿਸ਼ਾਨ ਅਤੇ ਅਚੰਭੇ ਵਿਖਾਲੇ ");
INSERT INTO pan_vpl VALUES ("DT6_23","006_6_23","DEU","6","23","23","ਅਤੇ ਸਾਨੂੰ ਉੱਥੋਂ ਕੱਢ ਲਿਆਇਆ ਤਾਂ ਜੋ ਉਹ ਸਾਨੂੰ ਇਸ ਦੇਸ਼ ਦੇ ਅੰਦਰ ਲਿਆਵੇ ਅਤੇ ਇਹ ਧਰਤੀ ਸਾਨੂੰ ਦੇਵੇ, ਜਿਸ ਦੀ ਸਹੁੰ ਉਸ ਨੇ ਸਾਡੇ ਪੁਰਖਿਆਂ ਨਾਲ ਖਾਧੀ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("DT6_24","006_6_24","DEU","6","24","24","ਯਹੋਵਾਹ ਨੇ ਇਨ੍ਹਾਂ ਸਾਰੀਆਂ ਬਿਧੀਆਂ ਨੂੰ ਪੂਰਾ ਕਰਨ ਦਾ ਸਾਨੂੰ ਹੁਕਮ ਦਿੱਤਾ ਸੀ ਕਿ ਅਸੀਂ ਯਹੋਵਾਹ ਆਪਣੇ ਪਰਮੇਸ਼ੁਰ ਤੋਂ ਜੀਵਨ ਭਰ ਡਰੀਏ, ਤਾਂ ਜੋ ਸਾਡਾ ਭਲਾ ਹੋਵੇ ਅਤੇ ਉਹ ਸਾਨੂੰ ਜੀਉਂਦਾ ਰੱਖੇ, ਜਿਵੇਂ ਅੱਜ ਦੇ ਦਿਨ ਤੱਕ ਰੱਖਿਆ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("DT6_25","006_6_25","DEU","6","25","25","ਜੇਕਰ ਅਸੀਂ ਇਹਨਾਂ ਸਾਰਿਆਂ ਹੁਕਮਾਂ ਨੂੰ ਜਿਨ੍ਹਾਂ ਦਾ ਉਸ ਨੇ ਹੁਕਮ ਦਿੱਤਾ ਸੀ, ਯਹੋਵਾਹ ਆਪਣੇ ਪਰਮੇਸ਼ੁਰ ਦੇ ਅੱਗੇ ਚੰਗੀ ਤਰ੍ਹਾਂ ਮੰਨੀਏ ਤਾਂ ਇਹ ਸਾਡੇ ਲਈ ਧਰਮ ਠਹਿਰੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("DT7_1","006_7_1","DEU","7","1","1","ਜਦ ਯਹੋਵਾਹ ਤੁਹਾਡਾ ਪਰਮੇਸ਼ੁਰ ਤੁਹਾਨੂੰ ਉਸ ਦੇਸ਼ ਵਿੱਚ ਲੈ ਜਾਵੇ, ਜਿਸ ਉੱਤੇ ਅਧਿਕਾਰ ਕਰਨ ਲਈ ਤੁਸੀਂ ਜਾਂਦੇ ਹੋ ਅਤੇ ਤੁਹਾਡੇ ਅੱਗਿਓਂ ਬਹੁਤ ਸਾਰੀਆਂ ਕੌਮਾਂ ਨੂੰ ਪੁੱਟ ਸੁੱਟੇ ਅਰਥਾਤ ਅਮੋਰੀ, ਕਨਾਨੀ, ਹਿੱਤੀ, ਫ਼ਰਿੱਜ਼ੀ, ਹਿੱਵੀ, ਯਬੂਸੀ ਅਤੇ ਗਿਰਗਾਸ਼ੀ ਨਾਂ ਦੀਆਂ ਸੱਤ ਕੌਮਾਂ ਨੂੰ ਜਿਹੜੀਆਂ ਤੁਹਾਡੇ ਨਾਲੋਂ ਵੱਧ ਅਤੇ ਬਲਵੰਤ ਹਨ ");
INSERT INTO pan_vpl VALUES ("DT7_2","006_7_2","DEU","7","2","2","ਅਤੇ ਜਦ ਯਹੋਵਾਹ ਤੁਹਾਡਾ ਪਰਮੇਸ਼ੁਰ ਉਹਨਾਂ ਨੂੰ ਤੁਹਾਡੇ ਅੱਗਿਓਂ ਹਰਾ ਦੇਵੇ ਤਾਂ ਤੁਸੀਂ ਉਹਨਾਂ ਨੂੰ ਮਾਰ ਸੁੱਟਿਓ। ਤੁਸੀਂ ਉਹਨਾਂ ਦਾ ਪੂਰੀ ਤਰ੍ਹਾਂ ਨਾਸ ਕਰ ਦਿਓ, ਤੁਸੀਂ ਨਾ ਉਹਨਾਂ ਨਾਲ ਨੇਮ ਬੰਨ੍ਹਿਓ ਅਤੇ ਨਾ ਹੀ ਉਹਨਾਂ ਉੱਤੇ ਤਰਸ ਖਾਇਓ, ");
INSERT INTO pan_vpl VALUES ("DT7_3","006_7_3","DEU","7","3","3","ਨਾ ਉਹਨਾਂ ਨਾਲ ਵਿਆਹ ਕਰਿਓ ਅਤੇ ਨਾ ਕੋਈ ਉਹਨਾਂ ਦੇ ਪੁੱਤਰ ਨੂੰ ਆਪਣੀ ਧੀ ਦੇਵੇ, ਨਾ ਕੋਈ ਆਪਣੇ ਪੁੱਤਰ ਲਈ ਉਹਨਾਂ ਦੀ ਧੀ ਲਵੇ, ");
INSERT INTO pan_vpl VALUES ("DT7_4","006_7_4","DEU","7","4","4","ਕਿਉਂ ਜੋ ਉਹ ਤੁਹਾਡੇ ਪੁੱਤਰਾਂ ਨੂੰ ਮੇਰੇ ਪਿੱਛੇ ਚੱਲਣ ਤੋਂ ਹਟਾ ਦੇਣਗੀਆਂ, ਤਾਂ ਜੋ ਉਹ ਦੂਜੇ ਦੇਵਤਿਆਂ ਦੀ ਪੂਜਾ ਕਰਨ, ਇਸ ਕਾਰਨ ਯਹੋਵਾਹ ਦਾ ਕ੍ਰੋਧ ਤੁਹਾਡੇ ਉੱਤੇ ਭੜਕੇਗਾ ਅਤੇ ਉਹ ਝੱਟ ਪੱਟ ਤੁਹਾਡਾ ਨਾਸ ਕਰ ਦੇਵੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("DT7_5","006_7_5","DEU","7","5","5","ਪਰ ਤੁਸੀਂ ਉਹਨਾਂ ਨਾਲ ਅਜਿਹਾ ਵਰਤਾਉ ਕਰਿਓ: ਤੁਸੀਂ ਉਹਨਾਂ ਦੀਆਂ ਜਗਵੇਦੀਆਂ ਨੂੰ ਢਾਹ ਸੁੱਟਿਓ, ਉਹਨਾਂ ਦੇ ਥੰਮ੍ਹਾਂ ਨੂੰ ਚੂਰ-ਚੂਰ ਕਰ ਦਿਓ, ਉਹਨਾਂ ਦੀ ਅਸ਼ੇਰਾਹ ਦੇਵੀ ਦੇ ਟੁੰਡਾਂ ਨੂੰ ਵੱਢ ਸੁੱਟਿਓ ਅਤੇ ਉਹਨਾਂ ਦੀਆਂ ਉੱਕਰੀਆਂ ਹੋਈਆਂ ਮੂਰਤਾਂ ਨੂੰ ਅੱਗ ਵਿੱਚ ਸਾੜ ਦਿਓ। ");
INSERT INTO pan_vpl VALUES ("DT7_6","006_7_6","DEU","7","6","6","ਕਿਉਂ ਜੋ ਤੁਸੀਂ ਯਹੋਵਾਹ ਆਪਣੇ ਪਰਮੇਸ਼ੁਰ ਲਈ ਇੱਕ ਪਵਿੱਤਰ ਪਰਜਾ ਹੋ ਅਤੇ ਯਹੋਵਾਹ ਤੁਹਾਡੇ ਪਰਮੇਸ਼ੁਰ ਨੇ ਤੁਹਾਨੂੰ ਚੁਣ ਲਿਆ ਹੈ ਕਿ ਤੁਸੀਂ ਧਰਤੀ ਦੇ ਸਾਰੇ ਲੋਕਾਂ ਵਿੱਚੋਂ ਉਸ ਦੀ ਨਿੱਜ-ਪਰਜਾ ਹੋਵੋ। ");
INSERT INTO pan_vpl VALUES ("DT7_7","006_7_7","DEU","7","7","7","ਯਹੋਵਾਹ ਨੇ ਤੁਹਾਡੇ ਨਾਲ ਪ੍ਰੇਮ ਕਰਕੇ ਤੁਹਾਨੂੰ ਇਸ ਕਾਰਨ ਨਹੀਂ ਚੁਣਿਆ ਕਿ ਤੁਸੀਂ ਗਿਣਤੀ ਵਿੱਚ ਸਾਰੇ ਲੋਕਾਂ ਨਾਲੋਂ ਜ਼ਿਆਦਾ ਸੀ, ਤੁਸੀਂ ਤਾਂ ਸਾਰੇ ਲੋਕਾਂ ਵਿੱਚੋਂ ਥੋੜ੍ਹੇ ਜਿਹੇ ਸੀ, ");
INSERT INTO pan_vpl VALUES ("DT7_8","006_7_8","DEU","7","8","8","ਪਰ ਇਸ ਲਈ ਕਿ ਯਹੋਵਾਹ ਨੇ ਤੁਹਾਡੇ ਨਾਲ ਪ੍ਰੇਮ ਕੀਤਾ ਅਤੇ ਉਸ ਨੇ ਉਸ ਸਹੁੰ ਦੀ ਪਾਲਨਾ ਕੀਤੀ, ਜਿਹੜੀ ਉਸ ਨੇ ਤੁਹਾਡੇ ਪੁਰਖਿਆਂ ਨਾਲ ਖਾਧੀ ਸੀ, ਇਸ ਕਾਰਨ ਯਹੋਵਾਹ ਤੁਹਾਨੂੰ ਬਲਵੰਤ ਹੱਥ ਨਾਲ ਕੱਢ ਕੇ ਬਾਹਰ ਲੈ ਆਇਆ ਅਤੇ ਤੁਹਾਨੂੰ ਗੁਲਾਮੀ ਦੇ ਘਰ ਤੋਂ ਅਰਥਾਤ ਮਿਸਰ ਦੇ ਰਾਜੇ ਫ਼ਿਰਊਨ ਦੇ ਹੱਥੋਂ ਛੁਟਕਾਰਾ ਦਿੱਤਾ। ");
INSERT INTO pan_vpl VALUES ("DT7_9","006_7_9","DEU","7","9","9","ਜਾਣ ਲਓ ਕਿ ਯਹੋਵਾਹ ਤੁਹਾਡਾ ਪਰਮੇਸ਼ੁਰ ਹੀ ਪਰਮੇਸ਼ੁਰ ਹੈ, ਉਹ ਆਪਣੇ ਬਚਨ ਦਾ ਪੱਕਾ ਪਰਮੇਸ਼ੁਰ ਹੈ ਅਤੇ ਨੇਮ ਦੀ ਪਾਲਨਾ ਕਰਨ ਵਾਲਾ ਹੈ ਅਤੇ ਹਜ਼ਾਰਾਂ ਪੀੜ੍ਹੀਆਂ ਤੱਕ ਉਨ੍ਹਾਂ ਉੱਤੇ ਦਯਾ ਕਰਦਾ ਹੈ, ਜਿਹੜੇ ਉਸ ਦੇ ਨਾਲ ਪ੍ਰੇਮ ਕਰਦੇ ਅਤੇ ਉਸ ਦੇ ਹੁਕਮਾਂ ਨੂੰ ਮੰਨਦੇ ਹਨ। ");
INSERT INTO pan_vpl VALUES ("DT7_10","006_7_10","DEU","7","10","10","ਉਹ ਆਪਣੇ ਵੈਰੀਆਂ ਦੇ ਵੇਖਦਿਆਂ ਹੀ ਉਹਨਾਂ ਦਾ ਨਾਸ ਕਰ ਕੇ ਬਦਲਾ ਦਿੰਦਾ ਹੈ ਅਤੇ ਉਹ ਆਪਣੇ ਵੈਰੀਆਂ ਵਿਖੇ ਢਿੱਲ ਨਾ ਲਾਵੇਗਾ ਪਰ ਉਨ੍ਹਾਂ ਦੇ ਵੇਖਦਿਆਂ-ਵੇਖਦਿਆਂ ਹੀ ਉਹਨਾਂ ਨੂੰ ਬਦਲਾ ਦੇਵੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("DT7_11","006_7_11","DEU","7","11","11","ਇਸ ਲਈ ਤੁਸੀਂ ਉਸ ਹੁਕਮਨਾਮੇ, ਬਿਧੀਆਂ, ਅਤੇ ਕਨੂੰਨਾਂ ਦੀ ਜਿਹੜੇ ਮੈਂ ਅੱਜ ਤੁਹਾਨੂੰ ਦੱਸਦਾ ਹਾਂ, ਪੂਰੇ ਕਰ ਕੇ ਪਾਲਨਾ ਕਰੋ। ");
INSERT INTO pan_vpl VALUES ("DT7_12","006_7_12","DEU","7","12","12","ਅਜਿਹਾ ਹੋਵੇਗਾ ਕਿ ਇਸ ਕਾਰਨ ਕਿ ਤੁਸੀਂ ਇਹਨਾਂ ਕਨੂੰਨਾਂ ਨੂੰ ਸੁਣਦੇ ਅਤੇ ਪੂਰਾ ਕਰ ਕੇ ਉਹਨਾਂ ਦੀ ਪਾਲਣਾ ਕਰਦੇ ਹੋ, ਤਾਂ ਯਹੋਵਾਹ ਤੁਹਾਡਾ ਪਰਮੇਸ਼ੁਰ ਉਸ ਨੇਮ ਨੂੰ ਅਤੇ ਉਸ ਦਯਾ ਨੂੰ ਜਿਹੜੀ ਉਸ ਨੇ ਤੁਹਾਡੇ ਪੁਰਖਿਆਂ ਨਾਲ ਸਹੁੰ ਖਾ ਕੇ ਕੀਤੀ ਸੀ, ਕਾਇਮ ਰੱਖੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("DT7_13","006_7_13","DEU","7","13","13","ਉਹ ਤੁਹਾਡੇ ਨਾਲ ਪ੍ਰੇਮ ਕਰੇਗਾ, ਤੁਹਾਨੂੰ ਬਰਕਤ ਦੇਵੇਗਾ ਅਤੇ ਤੁਹਾਡਾ ਵਾਧਾ ਕਰੇਗਾ। ਉਹ ਤੁਹਾਡੀ ਕੁੱਖ ਦੇ ਫਲ, ਤੁਹਾਡੀ ਜ਼ਮੀਨ ਦੇ ਫਲ, ਤੁਹਾਡੇ ਅੰਨ, ਤੁਹਾਡੀ ਨਵੀਂ ਮਧ, ਤੁਹਾਡੇ ਤੇਲ ਨੂੰ, ਚੌਣਿਆਂ ਦੇ ਬੱਚਿਆਂ ਨੂੰ ਅਤੇ ਇੱਜੜ ਦੇ ਲੇਲਿਆਂ ਨੂੰ ਉਸ ਜ਼ਮੀਨ ਉੱਤੇ ਜਿਸ ਨੂੰ ਦੇਣ ਦੀ ਸਹੁੰ ਉਸ ਨੇ ਤੁਹਾਡੇ ਪੁਰਖਿਆਂ ਨਾਲ ਖਾਧੀ ਸੀ, ਬਰਕਤ ਦੇਵੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("DT7_14","006_7_14","DEU","7","14","14","ਤੁਸੀਂ ਸਾਰਿਆਂ ਲੋਕਾਂ ਵਿੱਚੋਂ ਮੁਬਾਰਕ ਹੋਵੋਗੇ। ਤੁਹਾਡੇ ਵਿੱਚੋਂ ਨਾ ਕੋਈ ਪੁਰਖ ਅਤੇ ਨਾ ਕੋਈ ਇਸਤਰੀ ਬੇ-ਔਲਾਦ ਰਹੇਗੀ ਅਤੇ ਨਾ ਹੀ ਤੁਹਾਡੇ ਡੰਗਰਾਂ ਵਿੱਚੋਂ ਕੋਈ। ");
INSERT INTO pan_vpl VALUES ("DT7_15","006_7_15","DEU","7","15","15","ਯਹੋਵਾਹ ਤੁਹਾਡੀਆਂ ਸਾਰੀਆਂ ਬਿਮਾਰੀਆਂ ਤੁਹਾਡੇ ਤੋਂ ਦੂਰ ਕਰ ਦੇਵੇਗਾ ਅਤੇ ਮਿਸਰ ਦੇ ਸਾਰੇ ਬੁਰੇ ਰੋਗ ਜਿਨ੍ਹਾਂ ਨੂੰ ਤੁਸੀਂ ਜਾਣਦੇ ਹੋ, ਤੁਹਾਨੂੰ ਨਾ ਲਾਵੇਗਾ ਪਰ ਉਹ ਉਨ੍ਹਾਂ ਨੂੰ ਉਹਨਾਂ ਦੇ ਉੱਤੇ ਪਾਵੇਗਾ ਜਿਹੜੇ ਤੁਹਾਡੇ ਤੋਂ ਵੈਰ ਰੱਖਦੇ ਹਨ। ");
INSERT INTO pan_vpl VALUES ("DT7_16","006_7_16","DEU","7","16","16","ਤੁਸੀਂ ਉਹਨਾਂ ਸਾਰਿਆਂ ਲੋਕਾਂ ਨੂੰ ਨਾਸ ਕਰ ਸੁੱਟੋਗੇ, ਜਿਨ੍ਹਾਂ ਨੂੰ ਯਹੋਵਾਹ ਤੁਹਾਡਾ ਪਰਮੇਸ਼ੁਰ ਤੁਹਾਨੂੰ ਦਿੰਦਾ ਹੈ। ਤੁਹਾਡੀਆਂ ਅੱਖਾਂ ਉਹਨਾਂ ਉੱਤੇ ਤਰਸ ਨਾ ਖਾਣ, ਨਾ ਹੀ ਤੁਸੀਂ ਉਹਨਾਂ ਦੇ ਦੇਵਤਿਆਂ ਦੀ ਪੂਜਾ ਕਰਿਓ ਕਿਉਂ ਜੋ ਉਹ ਤੁਹਾਡੇ ਲਈ ਇੱਕ ਫਾਹੀ ਹੋਣਗੇ। ");
INSERT INTO pan_vpl VALUES ("DT7_17","006_7_17","DEU","7","17","17","ਜੇ ਤੁਸੀਂ ਆਪਣੇ ਦਿਲਾਂ ਵਿੱਚ ਆਖੋ, “ਇਹ ਕੌਮਾਂ ਸਾਡੇ ਨਾਲੋਂ ਬਹੁਤੀਆਂ ਹਨ, ਅਸੀਂ ਉਹਨਾਂ ਉੱਤੇ ਕਿਵੇਂ ਕਾਬੂ ਕਰ ਸਕਦੇ ਹਾਂ?” ");
INSERT INTO pan_vpl VALUES ("DT7_18","006_7_18","DEU","7","18","18","ਤੁਸੀਂ ਉਹਨਾਂ ਤੋਂ ਨਾ ਡਰਿਓ। ਤੁਸੀਂ ਉਹ ਸਭ ਕੁਝ ਚੰਗੀ ਤਰ੍ਹਾਂ ਯਾਦ ਰੱਖਿਓ ਜੋ ਕੁਝ ਯਹੋਵਾਹ ਤੁਹਾਡੇ ਪਰਮੇਸ਼ੁਰ ਨੇ ਫ਼ਿਰਊਨ ਨਾਲ ਅਤੇ ਸਾਰੇ ਮਿਸਰੀਆਂ ਨਾਲ ਕੀਤਾ ਸੀ। ");
INSERT INTO pan_vpl VALUES ("DT7_19","006_7_19","DEU","7","19","19","ਉਹ ਵੱਡੇ ਪਰਤਾਵੇ ਜਿਨ੍ਹਾਂ ਨੂੰ ਤੁਹਾਡੀਆਂ ਅੱਖਾਂ ਨੇ ਵੇਖਿਆ ਅਤੇ ਉਹ ਨਿਸ਼ਾਨ, ਅਚਰਜ਼ ਕੰਮ, ਬਲਵੰਤ ਹੱਥ ਅਤੇ ਪਸਾਰੀ ਹੋਈ ਬਾਂਹ ਜਿਸ ਦੇ ਨਾਲ ਯਹੋਵਾਹ ਤੁਹਾਡਾ ਪਰਮੇਸ਼ੁਰ ਤੁਹਾਨੂੰ ਕੱਢ ਲਿਆਇਆ, ਯਹੋਵਾਹ ਤੁਹਾਡਾ ਪਰਮੇਸ਼ੁਰ ਸਾਰਿਆਂ ਲੋਕਾਂ ਨਾਲ ਜਿਨ੍ਹਾਂ ਤੋਂ ਤੁਸੀਂ ਡਰਦੇ ਹੋ, ਇਸੇ ਤਰ੍ਹਾਂ ਹੀ ਕਰੇਗਾ। ");
INSERT INTO pan_vpl VALUES ("DT7_20","006_7_20","DEU","7","20","20","ਸਗੋਂ ਯਹੋਵਾਹ ਤੁਹਾਡਾ ਪਰਮੇਸ਼ੁਰ ਉਹਨਾਂ ਵਿੱਚ ਡੇਹਮੂ ਭੇਜੇਗਾ, ਜਦ ਤੱਕ ਕਿ ਉਹ ਜਿਹੜੇ ਬਚ ਜਾਣ ਅਤੇ ਉਹ ਜਿਹੜੇ ਆਪਣੇ ਆਪ ਨੂੰ ਲੁਕਾਉਣਗੇ, ਤੁਹਾਡੇ ਸਾਹਮਣਿਓਂ ਨਾਸ ਨਾ ਹੋ ਜਾਣ। ");
INSERT INTO pan_vpl VALUES ("DT7_21","006_7_21","DEU","7","21","21","ਤੁਸੀਂ ਉਹਨਾਂ ਤੋਂ ਭੈਅ ਨਾ ਖਾਇਓ ਕਿਉਂ ਜੋ ਯਹੋਵਾਹ ਤੁਹਾਡਾ ਪਰਮੇਸ਼ੁਰ ਤੁਹਾਡੇ ਵਿਚਕਾਰ ਹੈ। ਉਹ ਇੱਕ ਵੱਡਾ ਅਤੇ ਭੈਅ ਦਾਇਕ ਪਰਮੇਸ਼ੁਰ ਹੈ। ");
INSERT INTO pan_vpl VALUES ("DT7_22","006_7_22","DEU","7","22","22","ਯਹੋਵਾਹ ਤੁਹਾਡਾ ਪਰਮੇਸ਼ੁਰ ਇਨ੍ਹਾਂ ਕੌਮਾਂ ਨੂੰ ਤੁਹਾਡੇ ਅੱਗਿਓਂ ਹੌਲੀ-ਹੌਲੀ ਕੱਢੇਗਾ। ਤੁਸੀਂ ਉਨ੍ਹਾਂ ਨੂੰ ਇੱਕ ਦਮ ਨਾਸ ਨਾ ਕਰਿਓ, ਕਿਤੇ ਅਜਿਹਾ ਨਾ ਹੋਵੇ ਕਿ ਜੰਗਲੀ ਜਾਨਵਰ ਤੁਹਾਡੇ ਨਾਲੋਂ ਵੱਧ ਹੋ ਜਾਣ। ");
INSERT INTO pan_vpl VALUES ("DT7_23","006_7_23","DEU","7","23","23","ਪਰ ਯਹੋਵਾਹ ਤੁਹਾਡਾ ਪਰਮੇਸ਼ੁਰ ਉਹਨਾਂ ਨੂੰ ਤੁਹਾਡੇ ਅੱਗੇ ਹਰਾ ਦੇਵੇਗਾ ਅਤੇ ਵੱਡੀ ਘਬਰਾਹਟ ਨਾਲ ਉਹਨਾਂ ਨੂੰ ਘਬਰਾ ਦੇਵੇਗਾ, ਜਦ ਤੱਕ ਕਿ ਉਹਨਾਂ ਦਾ ਨਾਸ ਨਾ ਹੋ ਜਾਵੇ। ");
INSERT INTO pan_vpl VALUES ("DT7_24","006_7_24","DEU","7","24","24","ਉਹ ਉਹਨਾਂ ਦੇ ਰਾਜਿਆਂ ਨੂੰ ਤੁਹਾਡੇ ਹੱਥ ਵਿੱਚ ਦੇ ਦੇਵੇਗਾ ਅਤੇ ਤੁਸੀਂ ਉਹਨਾਂ ਦਾ ਨਾਂ ਅਕਾਸ਼ ਦੇ ਹੇਠੋਂ ਮਿਟਾ ਦੇਣਾ ਅਤੇ ਕੋਈ ਮਨੁੱਖ ਤੁਹਾਡੇ ਸਾਹਮਣੇ ਠਹਿਰ ਨਾ ਸਕੇਗਾ ਐਥੋਂ ਤੱਕ ਕਿ ਤੁਸੀਂ ਉਹਨਾਂ ਦਾ ਨਾਸ ਕਰ ਸੁੱਟੋਗੇ। ");
INSERT INTO pan_vpl VALUES ("DT7_25","006_7_25","DEU","7","25","25","ਤੁਸੀਂ ਉਹਨਾਂ ਦੇ ਦੇਵਤਿਆਂ ਦੀਆਂ ਉੱਕਰੀਆਂ ਹੋਈਆਂ ਮੂਰਤਾਂ ਨੂੰ ਅੱਗ ਵਿੱਚ ਸਾੜ ਸੁੱਟਿਓ ਅਤੇ ਤੁਸੀਂ ਉਸ ਚਾਂਦੀ ਅਤੇ ਸੋਨੇ ਦਾ ਲੋਭ ਨਾ ਕਰਿਓ ਜਿਹੜਾ ਉਹਨਾਂ ਦੇ ਉੱਤੇ ਹੈ, ਅਤੇ ਨਾ ਹੀ ਉਸ ਨੂੰ ਆਪਣੇ ਲਈ ਲਿਓ, ਕਿਤੇ ਤੁਸੀਂ ਉਹਨਾਂ ਦੇ ਫੰਦੇ ਵਿੱਚ ਫਸ ਜਾਓ, ਕਿਉਂ ਜੋ ਇਹ