﻿USE sofia;
DROP TABLE IF EXISTS sofia.pahNT_vpl;
CREATE TABLE pahNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES pahNT_vpl WRITE;
INSERT INTO pahNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Agwa ko Jesus Cristo'ga ramonhava'ea mombe'ua. Ymyahũ Tupana'ga e'i Jesus Cristo'ga pe: “Eko ti g̃anduvihavuhuhetero Cristoramo,” ei ga hako. Cristo xa'e nhande Jesus'ga pe a'ero. A'ereki ga nhanderuvihavuhuhete'ga. Jesus'ga ko Daviva'ea rakykwepoharamo Abraãova'ea rakykwepoharamo no. ");
INSERT INTO pahNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ymyahũ Abraãova'ea Isaqueva'ea po'ria hako. Isaqueva'ea Jacóva'ea po'ria. Jacóva'ea Judáva'ea po'ria Judáva'ea irũva'ea po'ria no. ");
INSERT INTO pahNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judáva'ea Peresva'ea po'ria Zerava'ea po'ria no. Tamarva'ea Peresva'ea yembora Zerava'ea yembora no. Peresva'ea Esromva'ea po'ria. Esromva'ea Arãova'ea po'ria. ");
INSERT INTO pahNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Arãova'ea Aminadabeva'ea po'ria. Aminadabeva'ea Nasomva'ea po'ria. Nasomva'ea Salmomva'ea po'ria. ");
INSERT INTO pahNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmomva'ea Boazva'ea po'ria. Raabeva'ea Boazva'ea yembora. Boazva'ea Obedeva'ea po'ria. Ruteva'ea Obedeva'ea yembora. Obedeva'ea Jesséva'ea po'ria. ");
INSERT INTO pahNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jesséva'ea Daviva'ea po'ria. Daviva'ea israelitasva'ea ruvihavuhuva'ea. Daviva'ea Salomãova'ea po'ria. Uriasva'ea rembirekokwerava'ea Salomãova'ea yembora. A'ereki Daviva'ea hembireko ahe pavẽi. ");
INSERT INTO pahNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomãova'ea Roboãova'ea po'ria. Roboãova'ea Abiasva'ea po'ria. Abiasva'ea Asava'ea po'ria. ");
INSERT INTO pahNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asava'ea Josafáva'ea po'ria. Josafáva'ea Jorãova'ea po'ria. Jorãova'ea Uziasva'ea ramonhava'ea. ");
INSERT INTO pahNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uziasva'ea Jotãova'ea po'ria. Jotãova'ea Acazva'ea po'ria. Acazva'ea Ezequiasva'ea po'ria. ");
INSERT INTO pahNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezequiasva'ea Manassésva'ea po'ria. Manassésva'ea Amomva'ea po'ria. Amomva'ea Josiasva'ea po'ria. ");
INSERT INTO pahNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josiasva'ea Jeconiasva'ea po'ria Jeconiasva'ea irũva'ea po'ria no. A'ea rupi Babilôniapeva'ea ruri otavuka Josiasva'ea re'yjava'ea pe ahe rerogwovo ogwyri pe he'yjuhuva'ea rerogwovo ahe mombytavo pevo. ");
INSERT INTO pahNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Babilôniapeva'ea ahe rerohorẽ Babilônia pe Jeconiasva'ea Salatielva'ea po'ria. Salatielva'ea Zorobabelva'ea po'ria. ");
INSERT INTO pahNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zorobabelva'ea Abiúdeva'ea po'ria. Abiúdeva'ea Eliaquimva'ea po'ria. Eliaquimva'ea Azorva'ea po'ria. ");
INSERT INTO pahNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azorva'ea Sadoqueva'ea po'ria. Sadoqueva'ea Aquimva'ea po'ria. Aquimva'ea Eliúdeva'ea po'ria. ");
INSERT INTO pahNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliúdeva'ea Eleazarva'ea po'ria. Eleazarva'ea Matãva'ea po'ria. Matãva'ea Jacóva'ea po'ria. ");
INSERT INTO pahNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jacóva'ea Joséva'ea po'ria. Joséva'ea Mariava'ea rembirekokwerava'ea. Mariava'ea ombo'a Jesus'ga. Ga ko Cristoramo Tupana'ga remimbuhurukaramo. Nahã ko Jesus Cristo'ga ramonha mombe'ua. ");
INSERT INTO pahNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Imbokwara'ara'ara'javame catorze ko Abraãova'ea rakykwepoharava'ea ojopy'rupy'ruavo. Aerẽ Daviva'ea ari. Daviva'ea arirẽ imbokwara'ara'ara'javame catorze ko Daviva'ea rakykwepoharava'ea ojopy'rupy'ruavo no. Aerẽ Josiasva'ea ari. Babilôniapeva'ea Josiasva'ea re'yjava'ea rerohoi Babilônia pe. Ahe rerohorẽ imbokwara'ara'ara'javame catorze ko aherakykwepoharava'ea ojopy'rupy'ruavo no. Aerẽ Cristo'ga ari. ");
INSERT INTO pahNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Jesus Cristo'ga aragwera ko nahã. Jesus'ga yembora rera ko Maria. Mariava'ea po'ria ahe'yembora pavẽi omondo Mariava'ea Joséva'ea pe tahembireko ti hẽa ga pavẽi javo. Joséva'ea rembirekoa renonde Tupana'ga ra'uvapyryva Mariava'ea momburu'ai. ");
INSERT INTO pahNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Hembireko g̃werĩ Joséva'ea Mariava'ea pavẽi. Emo ikwahavame ahepuru'a Joséva'ea ojapyaka marã ti nehẽ javo. A'ero okokatuavo g̃waramo ahe ei oyvyteri pe: “Apohi po ti ji hẽa hugwi a'ero nehẽ. Ndapotari reki ji hẽambotegwetea,” ei ahe. “Nurã po ti ji pohinhimimi hẽa hugwi hẽa mombe'ue'yma g̃a pe,” ei ahe oyvyteri pe. ");
INSERT INTO pahNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","A'ea rehe ahe japyakai. Kiro ahe kiri. A'ea rupi Tupana'gapyrive'ga yvagipeve'ga jipiukari Joséva'ea pe. Joséva'ea gwepia katu Tupana'gapyrive'ga okiri pe a'ero. —Terekyhyji ti enhimbirekohava hugwi Daviva'ea rakykwepoharamo, ei ga Joséva'ea pe. A'ereki pyry nde hẽa rerekoi. A'ereki Tupana'ga ra'uvapyryva hẽa momburu'a, ei ga. ");
INSERT INTO pahNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Aerẽ po ti hẽa gwa'yra'ga mbo'ari nehẽ, ei ga. A'ero ti eno hẽara'yra'ga rehe Jesus. Ereki ga ko ahembopiro'yhara'ga. Na tuhẽ, ei ga. Ombopiro'y po ti ga ojiheve'g̃a g̃andekote'varuhua hugwi nehẽ, ei ga. Hahye'yma pe po ti ga g̃a nderohoi a'ero nehẽ, ei Tupana'gapyrive'ga Joséva'ea pe. A'ea erame ga hoi Joséva'ea hugwi. Aerẽ Joséva'ea ma'ẽi. ");
INSERT INTO pahNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Ipuru'a Mariava'ea g̃wembirekoe'ymame. Nahã hekoi Tupana'ga nhi'ĩpo'ruavo ymyahũva'ea po'ruavo. A'ereki ymyahũ Tupana'ga nhi'ig̃a mombe'uharava'ea a'ea mombe'u Tupana'ga nhi'ig̃a mombe'gwovo. Ymyahũ ahe ei hako: ");
INSERT INTO pahNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“‘Pehendu katu ti!’ ei Tupana'ga. ‘Ipuru'a po ti hẽa akwaimbae'g̃a nderekoe'ỹvehẽa nehẽ. Aerẽ po ti hẽa gwa'yra'ga mbo'ari nehẽ. Ono po ti g̃a ga rehe Emanuel gareraramo,’ ei Tupana'ga,” ei ahe hako. Garera ko Emanuel. A'ea ko: Tupana'ga oko nhande pyri. ");
INSERT INTO pahNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Aerẽ Joséva'ea ma'ẽi. Oko ahe Tupana'gapyrive'ga nhi'ig̃a rehe toko ti hẽa nhirembirekoro a'ero nehẽ javo. A'ero ahe Mariava'ea reruri g̃wonga pe toroju ti hẽa pavẽi javo. ");
INSERT INTO pahNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Ahe gweru tehe ahe ojipyri. A'ereki ahe ndogwerekoi ve Mariava'ea ahera'yra'ga mbo'arame ahera'yrypy'ga. Ga rehe ahe inog̃i Jesus gareraramo. ");
INSERT INTO pahNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Cidade de Belém me Jesus'ga ari. Jesus'ga re'yja'g̃a gwyri pe Judéia pe Belém u. Jesus'ga arame Herodesva'ea oko g̃anduvihavuhuro judeus'g̃a gwyri pe Jesus'ga re'yja'g̃a gwyri pe. Jesus'ga arame jaytata'ia kwahapyra'g̃a nduri irupeuhua hugwi ogwyra hugwi kwara ipora hugwi. Uhu g̃a cidade de Jerusalém me ovahema. ");
INSERT INTO pahNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Kiro g̃a ei pevove'g̃a pe: —Kiroki ga oko judeus'g̃a nduvihavuhuheteag̃wamamo – mome ga? O'a ga ag̃wamo. A'ereki ore orohepia jaytata'ia ipyahuva'ea kwara ipora koty. A'ea ko ga'ara kwahavuka ore ve ojipiukaro g̃waramo jaytata'ia. Hepiaga g̃waramo ore ruri timbohete ti ga javo, ei g̃a. ");
INSERT INTO pahNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","G̃a'ea kwahavame ahepy'a ndukatui okoteheavo Herodesva'ea py'a judeus'g̃a nduvihavuhuva'ea py'a. Ndukatui cidadepeve'g̃a py'a no Jerusalémmeve'g̃a py'a. ");
INSERT INTO pahNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","A'ero ahe ikwava'ẽhara'g̃a nduvihava'g̃a mbojatykaukari g̃a mbuhuruka ojipyri judeus'g̃a mbo'ehara'g̃a ndeheve – kiroki g̃a ombo'e Moisésva'ea remimbo'eagwera rehe. G̃a ndurame Herodesva'ea pyri ahe ei g̃a pe: —Kiroki ga pe Tupana'ga e'i ga ti toko g̃anduvihavuhuhetero javo – mome po ti ga ari nehẽ Cristo'ga Tupana'ga remimbuhurukara'ga? ei Herodesva'ea. ");
INSERT INTO pahNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","A'ero g̃a ei ahe ve: —Belém me – kiroki cidade u oregwyri pe Judéia pe – pevo po ti ga ari nehẽ, ei g̃a. Nahã ymyahũ Tupana'ga nhi'ig̃a mombe'uharava'ea ikwatijari hako. A'ereki Tupana'ga okwatijaruka ahe ve onhi'ig̃a, ei g̃a. Tupana'ga e'i: ");
INSERT INTO pahNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“Belémmeva'ero pecidade ndokoi huvihavarũiva'ea. Huviha hete ko pecidade upa pende'yja'g̃a gwyri pe Judáva'ea rakykwepohara'g̃a gwyri pe Judéia pe. A'ereki pecidadepeve'ga oko nhiremimo'ẽhara'g̃a nduvihavag̃wamamo israelitas'g̃a nduvihavag̃wamamo. Gwereko katu po ti ga pende'yja'g̃a nhaporemo okovo g̃anduvihavuhuhetero nehẽ.” —A'ea ymyahũ Tupana'ga ei ikwatijaruka onhi'ig̃a mombe'uharava'ea pe hako, ei g̃a Herodesva'ea pe. ");
INSERT INTO pahNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","G̃a horame Herodesva'ea jaytata'ia kwahapyra'g̃a mbuhunhimimukari ojipyri a'ero. Ahe ei g̃a pe: —Gara rupi jaytata'ia jipiukari pe me iporame raikwehe? Takwaha katu ti ji, ei ahe g̃a pe. A'ero g̃a imombe'ukatui ahe ve. ");
INSERT INTO pahNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Ikwahapavame ahe g̃a mondoukari cidade de Belém me. Ahe e'i g̃a pe: —Peho ti Belémmeve'g̃a pyri tayri'ga rekakatuavo. Ga repiagame ti pejora'ja ji pyri ga mombe'ukatupava ji ve a'ero, ei ahe g̃a pe. Jihi ti taho ga mboheteavo a'ero nehẽ no, ei ahe g̃a pe o'mbero. ");
INSERT INTO pahNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Ahe rendupavirẽ jaytata'ia kwahapyra'g̃a hoi a'ero ogwovo Belém me. G̃a horame jaytata'ia – kiroki jaytata'ia ojipiuka g̃a pe kwara ipora koty – kotihĩ akoja jipiukara'javi g̃a pe ogwovo g̃a nenonde ogwovo Jesus'ga rehei katu opytavo garuhava arimo. ");
INSERT INTO pahNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Horyory hete g̃a jaytata'ia repiagame ogwovo ovahema tayri'ga ruhai pe. ");
INSERT INTO pahNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Onga pype g̃a tayri'ga repiagi ga'yembora reheve Mariava'ea reheve. Nurã g̃a nenypy'andurugi garovai pyteri pe nde ko orehoheva'ero javo. A'ero g̃a imondohetei mbatera ga pe g̃wovapytymba'voga hyrua ipe'avo jugwi. Ouro g̃a imondoi ga pe. Incenso perfume apopyra g̃a imondoi ga pe no. Iru'ĩa perfume apopyra g̃a imondoi ga pe mirra. ");
INSERT INTO pahNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Aerẽ ypytunimo okirame g̃a Tupana'ga rendukatui. Kiro ga g̃a momoranduvi. —Tapemombe'ui ti tayri'ga Herodes'ga pe. A'ereki ga ojuka pota tayri'ga. Tapejivyra'javi ti Herodes'ga pyri, ei Tupana'ga g̃a pe. Nurã oma'ẽrame g̃a hoi pehea rupi irũa rupi ogwovo ogwyri pe timombe'uyme ti tayri'ga Herodes'ga pe javo. ");
INSERT INTO pahNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Jaytata'ia kwahapyra'g̃a horẽ Tupana'gapyrive'ga yvagipeve'ga jipiukari Joséva'ea pe ahekiri pe. Ahe ve ga ei: —Haite! Evy epo'ama! ei ga Joséva'ea pe. Eho ti g̃a nderogwovo tayri'ga gayhẽa reheve. Eroho nhimi ti g̃a nderogwovo Egitopeve'g̃a gwyri pe, ei ga. Pevo ti pepyta. Aerẽ jate po ti ji imondoukari nhinhi'ig̃agwera pe me nehẽ pejora'ja ti Belém me javo. Po ti ji namondoi nhinhi'ig̃agwera pe me nehẽ, tapejora'javi ti avo Belém me. A'ereki avo Herodes'ga tayri'ga rekaruka kiro. A'ereki ga ojuka pota tayri'ga, ei Tupana'gapyrive'ga Joséva'ea pe. ");
INSERT INTO pahNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Oma'ẽ Joséva'ea ovya a'ero. A'ea rupi ypytunimo ahe tayri'ga rerohoi ga'yembora reheve g̃a nderogworogwovo Egitopeve'g̃a gwyri pe. ");
INSERT INTO pahNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Pevo ahe g̃a nderovahemi. Aerẽ g̃a nduvame Egito pe Herodesva'ea manoi. Nahã g̃a hoi opytavo Egitopeve'g̃a gwyri pe. Tupana'ga erame jate g̃a ndura'javi Egito hugwi. Nahã Tupana'ga g̃a mbuhurukara'javi Egito hugwi. Nahã hekoi Tupana'ga nhi'ĩpo'ruavo ymyahũva'ea po'ruavo. A'ereki ymyahũ Tupana'ga nhi'ig̃a mombe'uharava'ea a'ea mombe'u Tupana'ga nhi'ig̃a mombe'gwovo aerẽ po ti nahã javo. Ymyahũ ahe ei hako: “‘Egitopeve'g̃a gwyra hugwi ji jira'yra'ga mbuhurukari,’ ei Tupana'ga,” ei ahe hako. ");
INSERT INTO pahNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Omanoa renonde Herodesva'ea nhimonha'ngaranuhũi jaytata'ia kwahapyra'g̃a ndehe. A'ereki ahe okwaha ji moandyandyi g̃a ojivyra'jave'yma ji pyri javo. Dois anos g̃werĩ tayri'ga rehe kiro. A'ea Herodesva'ea okwaha. A'ereki nanongara jaytata'ia kwahapyra'g̃a omombe'u ahe ve ahe g̃a monhi'ig̃ame ojive. Nurã ahe osoldados'g̃a mondoukari cidade de Belém me Belém rembeyvyri hĩ pe no. Pevo ahe osoldados'g̃a mondoukari tojuka pa ti g̃a tapihama'g̃a javo – kiroki tayri'g̃a o'a jaytata'ia kwahapyra'g̃a hepiagirẽ jaytata'ia. Ahenhi'ig̃a rupi soldados'g̃a hoi a'ero tapihama'g̃a ndepiaga. Ojuka pa g̃a tapihama'g̃a – kiroki g̃a gwereko dois anos ojihe, kiroki g̃a ndogwerekoi ve dois anos ojihe no. ");
INSERT INTO pahNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Nahã hekoi Tupana'ga nhi'ĩpo'ruavo ymyahũva'ea po'ruavo. A'ereki ymyahũ Tupana'ga nhi'ig̃a mombe'uharava'ea Jeremiasva'ea a'ea mombe'u Tupana'ga nhi'ig̃a mombe'gwovo aerẽ po ti nahã javo. Ahe e'i hako: ");
INSERT INTO pahNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“‘Cidade de Ramá pe g̃a henduvi hẽa jehe'oheterame ovy'are'yma. Hahyahi hẽajehe'oa. Raquelhẽa reki ojehe'o gwa'yrava'ea rehe. Tegwete hẽa ma'ngoma'ngohava. A'ereki hẽara'yrava'ea omanomba,’ ei Tupana'ga,” ei Jeremiasva'ea hako. ");
INSERT INTO pahNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Aerẽ Tupana'ga José'g̃a mbuhurukara'javi Egitopeve'g̃a gwyra hugwi. A'ereki pevo g̃a u Herodesva'ea manorame. Herodesva'ea manorẽ yvagipeve'ga jipiukari Joséva'ea pe Tupana'gapyrive'ga. Joséva'ea pe ga ei ahekiri pe: ");
INSERT INTO pahNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","—Ahe omanomba kiro – kiroki ahe ojuka pota tayri'ga. Evy epo'ama! Eroho ti g̃a kiro a'ero tayri'ga gayhẽa reheve. Erojivyra'ja ti g̃a eje'yja'g̃a gwyri pe Israel pe, ei Tupana'gapyrive'ga Joséva'ea pe. ");
INSERT INTO pahNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Oma'eamo ahe vyri a'ero tayri'ga rerogwovo ga'yembora reheve g̃a nderojivya pevo jitehe ogwyri pe Israel pe g̃a nderovahema. ");
INSERT INTO pahNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","A'ea rupi Arquelau'ga oko Judéiapeve'g̃a nduvihavamo Israel pe opo'ria py'rovo Herodesva'ea py'rovo. A'ea kwahavame Joséva'ea kyhyji Arquelau'ga hugwi. Ndojupotari ahe Judéiapeve'g̃a gwyri pe a'ero. Ypytunimo okirame Joséva'ea Tupana'ga rendukatui. Kiro ga Joséva'ea momoranduvi. —Terehoi ti Judéiapeve'g̃a gwyri pe, ei Tupana'ga ahe ve. Nurã Joséva'ea ndohoi pevo. Galiléiapeve'g̃a gwyri pe ahe hoi Israel pe. ");
INSERT INTO pahNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Pevo ahe ruvi cidade de Nazaré pe tayri'ga pavẽi ga'yembora pavẽi no. Nahã hekoi Tupana'ga nhi'ĩpo'ruavo ymyahũva'ea po'ruavo. A'ereki ymyahũ Tupana'ga nhi'ig̃a mombe'uharava'ea a'ea mombe'umbe'u Tupana'ga nhi'ig̃a mombe'gwovo. Jesus'ga mombe'gwovo ahe ei hako: “‘E'i po ti g̃a ga pe nehẽ Nazarépeve'ga,’ ei Tupana'ga,” ei ahe hako. G̃a u pevo a'ero. ");
INSERT INTO pahNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Aerẽ João Batistava'ea rekoi ongae'ỹi me judeus'g̃a mobatizavo. Tupana'ga nhi'ig̃a mombe'uheteavo João Batistava'ea rekoi Judéiapeve'g̃a gwyri pe ongae'ỹi me. ");
INSERT INTO pahNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Hahyahi ahenhi'ig̃a ahe erame: —Pepohi tuhẽ ti pejikote'varuhua hugwi, ei ahe. Perojijyjijyi ti pejeaporog̃ita pejikokatuavo Tupana'ga nhi'ig̃a rendukatuavo. A'ereki Tupana'ga oko g̃werĩ nhanderuvihavuhuhetero nhande repiakatuavo yvya koty nhande mongovo onhi'ig̃a rupi, ei ahe g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Ymyahũ Tupana'ga nhi'ig̃a mombe'uharava'ea Isaíasva'ea omombe'u jipe João Batistava'ea. Ahe e'i João Batistava'ea mombe'unhog̃wenondeavo hako: “Hahyahi po ti ganhi'ig̃a ga erame g̃a mbo'eavo ongae'ỹi me nehẽ,” ei Isaíasva'ea. “E'i po ti ga nehẽ: ‘Pemboavujikwe ti pehea huvihava'ga pe tuhu ti ga nhande pyri javo. Pembohupi katu ti pehea ga pe,’ e po ti ga nehẽ,” ei Isaíasva'ea hako. Tupana'ga ra'yra'ga renondeva'ea e'i nhandepojykaharete'ga rurag̃wama pe. Tonhimboavujikwe ti g̃a garura renonde javo. A'ea pe ahe ei togwerojijyi ti g̃a gweaporog̃ita a'ea renonde javo. ");
INSERT INTO pahNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Omongi João Batistava'ea yuranuhũa'javuhuva'ea rava apopyra camelo rava apopyra. Aheku'ayvira ko ipira. O'u ahe tukura hehira reheve. ");
INSERT INTO pahNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","He'yjuhuve'g̃a nug̃anduri onhimongyavo João Batistava'ea pyri ovahema. Uhu g̃a cidade de Jerusalém hugwi. Uhuuhu g̃a Judéiapeve'g̃a gwyra hugwi nhaporemo no rio Jordão rembeyvyra hugwi no. ");
INSERT INTO pahNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ahe renduvame g̃a nhimombe'ukatui Tupana'ga pe jite'varuhu ji javo opohia jugwi. A'ero jate João Batistava'ea g̃a mobatizai rio Jordão pype. ");
INSERT INTO pahNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Uhu he'yive'g̃a ahe pyri no fariseus'g̃a saduceus'g̃a pavẽi tianemobatiza ti ga javo. G̃andura repiagame João Batistava'ea ei g̃a pe: —Tiruahũ pendeaporog̃ita! Pe'euhu pe pejohupe pejikokatupotare'yma g̃waramo. Pe'e pe: “Haite! Xaho João Batista'ga pyri tianemobatiza ti ga. Nurã po ti Tupana'ga nonhimonha'ngaa'javi nhande rehe nehẽ. Ndahahyi po ti nhande ve a'ero nehẽ.” Nahã pe pe'e, ei João Batistava'ea. Maraname pe euhui nanongarava'ea naerũ? Pe tuhẽ penhimbo'e nanongara rehe, ei João Batistava'ea g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","—Jihi, ei João Batistava'ea, kiro po ti ji ei pe me: Po pe ndapepotari hahyva'ea Tupana'ga nhimonha'ngarame pe ndehe, a'ero ti peko katu, ei ahe. Tapembopogwea'javi ti pejite'varuhua pejikovo. Pe pohirame jugwi po ti Tupana'ga ei pe me nehẽ: “Ndovy'ari g̃a okote'varuhua rehe kiro opohia jugwi herojijyita ojeaporog̃ita. Nanhimonha'ngaa'javi ji g̃a ndehe a'ero.” Nahã po ti Tupana'ga ei pe me a'ero nehẽ, ei João Batistava'ea g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","—Tape'ei ti pejiyvyteri pe: “Abraãova'ea nhaneramonhamo oko. Tupana'ga oarõ hete Abraãova'ea. Nurã po ti Tupana'ga nonhimonha'ngai nhande rehe nehẽ.” A'ea ti tape'ei. A'ereki Tupana'ga ndokoi reki Abraãova'ea rymymino'g̃a ndehe g̃a ndekote'varuhurame. Po Tupana'ga ojipe'g̃a pota, a'ero Tupana'ga oapo kwaha ag̃a ita Abraãova'ea rymyminoro g̃a mongovo, ei João Batistava'ea g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Kiro João Batistava'ea imombe'ui ojo'java'ea g̃a pe. G̃a mbo'eavo ga ei: —Akwaimbae'ga ombogwa g̃werĩ jykwa'ria pyvõ tambo'aruka javo. Po i'yva ndogwerekoi yva'ikatua, a'ero po ti ga imbo'ari imondovo tata pype nehẽ. Na jitehe Tupana'ga pe nderekog̃werĩ pe momboa tata pype hahyva'ea ruvihava pype pe pohire'yma g̃waramo pejikote'varuhua hugwi pejikokatue'yma, ei João Batistava'ea g̃a pe imombe'gwovo. ");
INSERT INTO pahNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","—Uhu po ti ga nehẽ – kiroki ga ji hohe hete huvihavuhuhetero g̃waramo, ei João Batistava'ea. Ji ki a'e te okoteheva'ea. Jihi opomobatiza yhya pyvõ jate. Nahã ji ikwahavukari g̃a pe pepohira pejikote'varuhua hugwi pendeaporog̃ita rerojijyja reheve pendekokatua reheve. Gaha po ti pe pojykauka Tupana'ga ra'uvapyryva pe aerẽve'ga nehẽ. Nahã po ti ga pendekote'varuhua mombigukari pe mombyryvuka nehẽ, ei João Batistava'ea ga mombe'gwovo g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Kiro João Batistava'ea imombe'ui ojo'java'ea g̃a pe. G̃a mbo'eavo ga ei: —Trigo jara'ga gwereko japira mbovevehava opo pe tamboveve ti ji japira trigo hugwi javo, ei João Batistava'ea imombe'gwovo. Omono'ono'õ po ti ga oapoa trigo inhag̃a hyrua pype nehẽ. Japira po ti ga imbokai tata pyvõ nehẽ. Ndogwevi po ti tata upa nehẽ, ei João Batistava'ea. —Na jitehe po ti jihoheheteve'ga huvihavuhuhete'ga imboja'oja'ogukari pyryve'g̃a okote'varuhuve'g̃a hugwi okovo pyryve'g̃a pojykaharete'ga nehẽ, ei João Batistava'ea g̃a pe. “Tuhu ti pyryve'g̃a ji pyri yvagi pe upa avuirama nehẽ,” e po ti jihoheheteve'ga nehẽ, ei João Batistava'ea. “Toho ti okote'varuhuve'g̃a ji hugwi ogwovo tata pype hahyva'ea ruvihava pype opytavo pevo avuirama nehẽ ojivyre'yma,” e po ti jihoheheteve'ga nehẽ, ei João Batistava'ea Cristo'ga mombe'gwovo g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Aerẽ Jesus'ga ruri Galiléiapeve'g̃a gwyra hugwi ua rio Jordão pe. Uhu ga ovahema João Batistava'ea pyri tanhimobatiza ti ga javo. ");
INSERT INTO pahNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","A'ero João Batistava'ea ei Jesus'ga pe: —Toromobatizayme po ti ji nehẽ. Ndehe ko oreruvihavuhuhetero. Nde po ti ji mobatiza hamo a'ero nehẽ, ei João Batistava'ea Jesus'ga pe novĩa. Ako tehe ji nde pyri, ei ahe Jesus'ga pe. Maraname nde ruri ji pyri enhimobatizauka ji ve a'ero? ei ahe Jesus'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","A'ero Jesus'ga ei reki João Batistava'ea pe: —Ji mobatiza tuhẽ ti kiro, ei Jesus'ga. A'ereki pyry nde ji mobatizai. Nahã po ti nhande rekokatui nhandekovo Tupana'ga remimbotarimova'ea rupi nhaporemo nehẽ, ei Jesus'ga João Batistava'ea pe. —Kwa, ei ahe Jesus'ga mobatizavo. ");
INSERT INTO pahNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Ahe omobatizarẽ Jesus'ga hemi yhya hugwi. Kotihĩ Tupana'ga ipe'ai yvaga ga pe. Kiro Jesus'ga hepiagi Tupana'ga ra'uva ijyvame ojihe. Inambua ja Tupana'ga ra'uva hekoi yvaga hugwi ijyvame ga rehe. ");
INSERT INTO pahNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Nanime yvaga hugwi Tupana'ga nhi'ig̃i Jesus'ga mombe'gwovo. —Agwa'ga ko jira'yra'ga nhiremia'nguhete'ga, ei Tupana'ga. Anhimohẽ hete ko ji ga rehe, ei ga. ");
INSERT INTO pahNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Aerẽ Tupana'ga ra'uva Jesus'ga rerohoi ongae'ỹi me Diabo'ga ti toko ga pyri javo. “A'ereki Diabo'ga ga mongo te'varuhu pota,” ei Tupana'ga ra'uva. A'ero ga rerohoi ga rerovahema pevo. ");
INSERT INTO pahNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","He'yiva'ea quarenta ko Jesus'ga kiri pevo. A'ea rupi ga ndo'ui arimo ypytunimo no tanhi'ĩ ti ji Tupana'ga pe javo. Quarenta Jesus'ga kirirẽ pevo ojuka ga ty'ara a'ero. ");
INSERT INTO pahNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","A'ero Diabo'ga ruri Jesus'ga pyri tamongo te'varuhu ji ga javo. Uhurame ga ei Jesus'ga pe: —Ere'e jipe ndehe: “Jihi ko Tupana'ga ra'yramo.” A'ea nde ei, ei Diabo'ga. Gara'yramo ti ere kia pe ita pe a'ero: “Penhimbote ti a'ero pãoramo nhirembi'uramo.” A'ea ti ere jupe, ei Diabo'ga Jesus'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","A'ero Jesus'ga ei ga pe: —Nda'ei po ti ji jupe nehẽ, ei ga. Ymyahũ Tupana'ga okwatijaruka ahe ve inog̃uka hako. Aherembikwatijara e'i: “Mbatera ua pyvõ jate rũi nhande rekoi. Tupana'ga nhi'imbava rendukatua pyvõ nhande rekoi,” e'i aherembikwatijara, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Aerẽ Diabo'ga Jesus'ga rerohoi cidadepyryva pe Jerusalém me a'ero. Yvate pe ga ga rerojiupiri gare'yja'g̃a jatykahavuhua rehe templo rehe ga mo'ama japyra rehe. ");
INSERT INTO pahNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Ga rerovahemame pevo ga ei Jesus'ga pe: —Ere'e jipe ndehe: “Jihi ko Tupana'ga ra'yramo.” A'ea nde ei, ei Diabo'ga. Gara'yramo ti epo japyra hugwi ehia a'ero. Tupana'gapyrive'g̃a yvagipeve'g̃a po ti nanembohirukarahyi yvyvo nehẽ. A'ero po ti ndahahyi nde ve nde porame japyra hugwi nehẽ. A'ereki ymyahũ a'ea Tupana'ga okwatijaruka ahe ve inog̃uka hako, ei Diabo'ga Jesus'ga pe. Aherembikwatijara e'i: “Tupana'ga po ti ojipyrive'g̃a mondoukari nde pyri nehẽ. ‘Pea'ngu ti ga,’ e po ti ga ojipyrive'g̃a pe yvagipeve'g̃a pe nehẽ. ‘Pepyhy katu ti ga rerogwovo tahahyyme'i'i ti ga pe javo,’ e po ti Tupana'ga ojipyrive'g̃a pe nehẽ,” e'i aherembikwatijara, ei Diabo'ga Jesus'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","A'ero Jesus'ga ei ga pe: —Ymyahũ Tupana'ga okwatijaruka ahe ve inog̃uka hako. Aherembikwatijara e'i: “Tupana'ga ko ndepojykaharete'ga. Gareaporog̃ita rehe jate ti eko. A'ero po ti ga nde pokogi nehẽ. Ejeaporog̃itatehea rehe rũi ti eko ji poko ti kiro javo tehe Tupana'ga pe,” e'i aherembikwatijara, ei Jesus'ga Diabo'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Aerẽ Diabo'ga ga rerohoa'javi. Yvate hete pe ga ga rerohoi ga rerojiupia yvytyruhua rehe. Pea hugwi Diabo'ga hepiukapavi yvyakotyve'g̃a nduvihava'g̃a gwyra Jesus'ga pe. G̃agwyrakatukatua ga hepiukari no. ");
INSERT INTO pahNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Kiro ga ei Jesus'ga pe: —A'ea nhaporemo po ti ji imondoi nde ve nehẽ. Po nde renypy'andurugi jirovai pyteri pe ji mboheteavo nde ko Tupanamo javo, a'ero po ti ji imondopavi nde ve nehẽ, ei Diabo'ga Jesus'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","—Satanás, ei Jesus'ga Diabo'ga pe. Nde Tupana rũi. Ejipe'a ji hugwi! Norombohetei po ti ji ndehe nehẽ. A'ereki ymyahũ Tupana'ga okwatijaruka ahe ve inog̃uka hako. Aherembikwatijara e'i: “Embohete ti Tupana'ga. Gaha ndepojykaharete'ga. Gaha jate ti embohete ekovo ganhi'ig̃a rupi jate,” e'i aherembikwatijara, ei Jesus'ga Diabo'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","A'ero Diabo'ga hoi ogwovo Jesus'ga hugwi. Nanime Tupana'gapyrive'g̃a yvagipeve'g̃a jipiukari Jesus'ga pe ga pokoga mbatera imondovo ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Aerẽ ojipe'g̃a imombe'ui Jesus'ga pe. —G̃a João Batista'ga mongi cadeia pype ga Tupana'ga nhi'ig̃a mombe'uro g̃waramo, ei g̃a. A'ea renduvame Jesus'ga hoi ojivya Galiléiapeve'g̃a gwyri pe. ");
INSERT INTO pahNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Pevo ga jijyi cidade de Nazaré hugwi ogwovo ojipe pe cidade de Cafarnaum me Galiléiapeve'g̃a gwyri pe. Cafarnaum tuvi ypiahua pyri lago da Galiléia pyri. Pevo ko judeus'g̃a nduvi Zebulomva'ea re'yja'g̃a Naftaliva'ea re'yja'g̃a pavẽi. ");
INSERT INTO pahNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Pevo Jesus'ga hoi Cafarnaum me. Nahã hekoi Tupana'ga nhi'ĩpo'ruavo ymyahũva'ea po'ruavo. A'ereki ymyahũ Tupana'ga nhi'ig̃a mombe'uharava'ea Isaíasva'ea a'ea mombe'u Tupana'ga nhi'ig̃a mombe'gwovo. Ymyahũ ahe ei hako: ");
INSERT INTO pahNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“‘Pegwyri pe herekoi pehea – kiroki pehea oho ypiahu pe,’ ei Tupana'ga Zebulomva'ea re'yja'g̃a pe Naftaliva'ea re'yja'g̃a pe no. ‘Pegwyra rekoi rio Jordão aherovai. G̃a ei pegwyra pe Galiléia judeus'g̃arũive'g̃a gwyra gentios'g̃a gwyra. A'ea g̃a ei pegwyra pe,’ ei Tupana'ga,” ei ahe. ");
INSERT INTO pahNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","“‘Ypytuna ja pe me pe ji kwahave'yma g̃waramo. Kiro po ti kojahua ja pe me pe ji kwahava g̃waramo nehẽ. Peko pe omanove'g̃a ja ji ve ji kwahave'ymame. Kiro po ti ji jikwahavukari pe me imbokojahuavo peakag̃i pe nehẽ,’ ei Tupana'ga,” ei Isaíasva'ea imombe'gwovo hako. ");
INSERT INTO pahNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Omombe'u jipe ahe Jesus'ga hoa Cafarnaum me. Uvame cidade pe Cafarnaum me kiro Jesus'ga g̃a mbo'embo'ei. Tupana'ga nhi'ig̃a mombe'gwovo ga ei g̃a pe: —Pepohi ti pejikote'varuhua hugwi, ei ga. Perojijyjijyi ti pejeaporog̃ita pejikokatuavo pejikovo Tupana'ga nhi'ig̃a rupi. A'ereki Tupana'ga pe ndepia katu g̃werĩ penduvihavuhuhetero yvya koty pe mongovo onhi'ig̃a rupi, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Aerẽ Jesus'ga hoi ypiahu pe Galiléia pe ogwovo yembeyvyra rupi. Ohorame Jesus'ga mokonha'g̃a ndepiagi Simão'ga André'ga reheve. G̃a ko onhoirũ'g̃a. Simão'ga pe g̃a e'i no Pedro. Pirareheva'ero g̃waramo Simão'g̃a imombori ipypira pira mboahava tipyhy pira javo. ");
INSERT INTO pahNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Ovahemame g̃a pyri Jesus'ga ei g̃a pe: —He pejijo ti ji rupi nhiremimbo'eharamo. A'ero po ti pe ji mombe'ui ojipe'g̃a pe nehẽ no. Pira pe peru oji'i. Kiro po ti pe ojipe'g̃a mbuhurukari ji pyri nehẽ toko ti g̃a Jesus'ga nhi'ig̃a rupi javo, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","—Kwa, ei g̃a. Nambegwei g̃a hoi imboahava reja ogwovo ga rupi okovo garemimbo'eharamo. ");
INSERT INTO pahNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Hehemo'i Jesus'ga hoi ogwovo yembeyvyra rupi ojipe'g̃a ndepiaga Tiagova'ea João'ga reheve. G̃a memei ko onhoirũ'g̃a. G̃anduva'ga ko Zebedeu'ga. Ga pavẽi g̃a apygi yharuhua pype japokatua'java oapoa imboahava. Ovahemame g̃a pyri Jesus'ga nhi'ig̃i Tiagova'ea pe João'ga pe no toko ti g̃a nhiremimbo'eharamo javo. ");
INSERT INTO pahNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Nambegwei g̃a hoi yharuhua reja gwuva'ga reja no ogwovo Jesus'ga rupi okovo garemimbo'eharamo. ");
INSERT INTO pahNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Ojipejipea pe Jesus'ga hogahoi Galiléiapeve'g̃a gwyra rupi hete ogwovo. G̃ajatykahai pe ga hogahoi g̃a mbo'eavo Tupana'ga nhi'ig̃a rehe. Pyryva'ea ga imombe'ui g̃a pe Tupana'ga pe poko katu pota penduvihavuhuhetero javo. —Perojijyjijyjuka ti pejeaporog̃ita Tupana'ga pe pejikoga ga rehe. A'ero po ti ga pe pokokatui nehẽ imomboa pendekote'varuhua pe hugwi okovo penduvihavuhuhetero nehẽ, ei Jesus'ga g̃a pe. Karugwaraparavuhua Jesus'ga imombipavi g̃a hugwi no. Ipopoakare'ỹve'g̃a ga g̃a mbopopoakari no. Nahã ga rekoi g̃apyteri pe. ");
INSERT INTO pahNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","A'ero he'yjuhuve'g̃a imombe'umbe'ui nahanahã Jesus'ga g̃a pohanog̃i javo. A'ero Síriapeve'g̃a nhaporemo ikwahavi no itetirũave'g̃a nderupava Jesus'ga pyri. He'yjuhu karugwara g̃a pe. Hahy paravuhu g̃a pe no. Anhag̃a omongo aha ojipe'g̃a ojeaporog̃ita rupi jate ojipe'ae'yma g̃a hugwi onhimongyavo Diabo'gapyriva'ea. Ojipe'g̃a akag̃i pe mbipeuhu g̃a mboheagwyryva. Ojipe'g̃a nopo'ami. Nomyi tuhẽ g̃a upa. G̃a nhaporemo g̃a g̃a nderuri Jesus'ga pyri topohano ti ga g̃a javo. Jesus'ga omombi pa g̃a hugwi a'ero g̃a mongokatua'java. ");
INSERT INTO pahNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","He'yjuhuve'g̃a hog̃ahoi Jesus'ga rupi onhimongyavo. Uhu g̃a ga pyri Galiléiapeve'g̃a gwyra hugwi Dez Cidades hugwi no Jerusalém hugwi no Judéiapeve'g̃a gwyra hugwi no rio Jordão aherovaja hugwi no. Nahã g̃a nduri ogwoogwovo ga rupi onhimongyavo. ");
INSERT INTO pahNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Onhimongyve'g̃a ndepiagame Jesus'ga jiupiri yvytyra rehe. Pevo ga apygame garemimbo'ehara'g̃a nduri ga pyri tihendu ganhi'ig̃a javo. ");
INSERT INTO pahNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Ombo'embo'e ga g̃a kiro. ");
INSERT INTO pahNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","A'ero ga ehetei g̃a pe: —Pyry hete g̃a pe – kiroki g̃a e'i ikwahava oyvytera: “Tupana'ga ji pokogame jate po ti ji rekokatui nehẽ.” G̃a erame na ojikoheteavo Tupana'ga rehe pyry hete g̃a pe. A'ereki g̃anduvihavuhuhetero Tupana'ga gwepia katu g̃a imombyryva g̃a pe, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Pyry hete g̃a pe – kiroki g̃a okoveveuhu ojehe'gwovo. A'ereki g̃a ko Tupana'ga remimbohoryva'javag̃wama, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Pyry hete g̃a pe – kiroki g̃a oko nhyrõ onhimbohetee'yma. A'ereki yvya koty Tupana'ga remimondoag̃wama g̃a pe ga ero g̃waramo, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Pyry hete g̃a pe – kiroki g̃a oko katu pota hete okoheteavo Tupana'ga remimbotarimova'ea rupi. A'ereki g̃a ko Tupana'ga remimombyryvag̃wama, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Pyry hete g̃a pe – kiroki g̃a ojipe'g̃a porogwety. A'ereki g̃a tuhẽ ko Tupana'ga rembiporogwetygag̃wama, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Pyry hete g̃a pe – kiroki g̃a gweaporog̃ita katu Tupana'ga reaporog̃ita rehe jate xako javo. A'ereki g̃a Tupana'ga repiagag̃wama, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Pyry hete g̃a pe – kiroki g̃a onhoarõuka hete ojipe'g̃a pe. A'ereki a'ea Tupana'ga eag̃wama g̃a pe. “G̃a ko jira'yra'g̃a,” e po ti Tupana'ga g̃a pe nehẽ, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Pyry hete g̃a pe – kiroki g̃a pe ojipe'g̃a okote'varuhu. G̃a ndekoro g̃waramo Tupana'ga nhi'ig̃a rupi ojipe'g̃a te'varuhuro g̃a pe. Pyry hete g̃a pe – kiroki g̃a pe g̃a ite'varuhu. A'ereki g̃anduvihavuhuhetero Tupana'ga gwepia katu g̃a imombyryva g̃a pe, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","—Pyry hete pe me g̃a ete'varuhurame pe me. G̃a imondorame hahyva'ea pe me pyry hete pe me. Ite'varuhuparavuhuva'ea pe nhaporemo ti g̃a ei pe me o'mbero nehẽ pe ndekoro g̃waramo jireheva'ero. G̃a erame na pyry hete pe me, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","—Pejoryjory hete ti g̃a jigwarairame pe ndehe nahã. A'ereki Tupana'ga gwereko katu pe me yvagi pe ikwepykavuhua pyryheteva'ea. Aerẽ po ti ga imondoi pe me nehẽ. A'ereki pe peko ymyahũva'ea ja Tupana'ga nhi'ig̃a mombe'uharava'ea ja hahyrame pe me. A'ereki ymyahũ ag̃wamove'g̃a namonhava'ea ojigwarai Tupana'ga nhi'ig̃a mombe'uharava'ea rehe no, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","—Jukyra omongo katu mbatera imonemukare'yma jupe. Pyry mbatera a'ero, ei Jesus'ga. Peko pe jukyra ja yvyakotyve'g̃a pe g̃a mongokatuavo. A'ereki pe peko katu pendoryndoryvamo g̃apyteri pe Tupana'ga pyryva repiuka g̃a pe Tupana'ga nhi'ig̃a mombe'gwovo g̃a pe nahã po ahe toko hamo javo. Penhi'ig̃a rendukaturame po ti g̃a ndekokatui nehẽ no, ei Jesus'ga g̃a pe. —Po jukyra ndapyryva'javi, marã po ti ahe imombyryva'javi jukyra a'ero nehẽ? Ahe nombyryva'javi tuhẽ jukyra, ei Jesus'ga. A'ero ahe ndopo'rua'javi jukyra. Omombo ahe a'ero. Hehe ahe pyrug̃i a'ero ohoohorame, ei Jesus'ga. Po na jitehe pe ndapepyryva'javi, maranuhũ pe ojipe'g̃a mongokatui naerũ? Maranuhũ po ti ji nhimoirũukara'javi pe me nehẽ pehepiuka ti Tupana'ga pyryva g̃a pe javo pe me naerũ? ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","—Peko pe kojahuva'ea'javuhuva'ea yvyakotyve'g̃a pe Tupana'ga repiuka g̃a pe, ei Jesus'ga. Cidade ituvame yvytyruhua rehe nhande nhaporemo hepiagi. A'ereki pevo jukwaha upa, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Imondygame lamparina ahe ndohovapygi lamparina hyrua pyvõ. Pyte'mbia rehe ahe omondo lamparina. Ombokojahu lamparina ongapypeve'g̃a pe nhaporemo a'ero tohepia ti g̃a javo, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","—Na jitehe ti pembokojahuuka yvyakotyve'g̃a akag̃i pe. Marã po pe imbokojahuukari g̃a pe? Kiro ji imombe'ui pe me. Peko katu ti Tupana'ga ja pejuvete'ga ja pejikoga ga rehe g̃a pokoga. Pendekokatua repiagame po ti g̃a ikwahavi Tupana'ga pyryva ga mboheteavo yvagipeve'ga mboheteavo nehẽ Tupana'ga omombyry g̃a javo. Nahã pe Tupana'ga repiukari g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","—Tape'ei ti pejiyvyteri pe: “Jesus'ga uhu yvya koty javo nhande ve. ‘Tapekoa'javi ti Moisésva'ea remimbo'eagwera rupi,’ e po ti ga nhande ve nehẽ. ‘Tapekoa'javi ti Tupana'ga nhi'ig̃a mombe'uharava'ea nhi'ig̃agwera rupi no,’ e po ti ga nehẽ.” A'ea ti tape'ei pejiyvyteri pe, ei Jesus'ga g̃a pe. A'ereki nanongara pe rũi javo ji ruri ikwehe, ei ga. —Ajo ji pe mbo'ekatuavo ahe'eagwera po'rua rehe, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Imombe'ukatuavo ji ei: Moisésva'ea remimbo'eagwera ti ndopavi'i'i nehẽ. Yvaga pave'ymame po ti Moisésva'ea remimbo'eagwera ndopavi'i'i nehẽ. Yvya pave'ymame po ti Moisésva'ea remimbo'eagwera ndopavi'i'i nehẽ. Xunhi'i'ĩva'ea vehevi po ti ndopavi aheremimbo'eagwera hugwi nehẽ. Aheremimbo'eagwera apiavo ihoi nehẽ. A'ea renonde po ti aheremimbo'eagwera ndopavi nehẽ, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","—Ojipe'ga po ndokopavi Moisésva'ea remimbo'eagwera rupi. A'ereki ga e'i: “Jara rupi aheremimbo'eagwera rupi ji rekoi. A'ereki a'ea pyry aheremimbo'eagwera. Jara rupi aheremimbo'eagwera rupi ji ndakoi. A'ereki akoja hohe jara koji'i pyry aheremimbo'eagwera,” e po ga. Nahã po ga ojipe'g̃a mbo'ei g̃a pe hendukatuuka onhi'ig̃a. Nanongara'ga pe po ti Tupana'ga ei nehẽ: “Ndahuvihavi'i'i ko ga.” Nahã po ti Tupana'ga ei okovo g̃anduvihavuhuhetero g̃a ndepiakatuavo nehẽ, ei Jesus'ga. —Ojipe'ga po oko Moisésva'ea remimbo'eagwera rupi nhaporemo ojipe'g̃a mbo'ekatuavo hehe g̃a pe hendukatuuka aheremimbo'eagwera nhaporemo. Nanongara'ga pe po ti Tupana'ga ei nehẽ: “Ga ko huvihava.” A'ea po ti Tupana'ga ei okovo g̃anduvihavuhuhetero g̃a ndepiakatuavo nehẽ, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","—A'e ji pe me a'ero: Koji'i ti peko katu hete pembo'ehara'g̃a hohe fariseus'g̃a hohe no. Po g̃a hohe rũi pe ndekokatui, a'ero po ti Tupana'ga penduvihavuhuhete'ga rũi nehẽ. A'ero po ti ga napenderohoi yvagi pe nehẽ, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","—Pekwaha pe nhaneramonhava'ea mog̃itagwera, ei Jesus'ga. A'ea e'i: “Tapejukai ti ojipe'g̃a,” e'i nhaneramonhava'ea mog̃itagwera. “Po pe g̃a jukai, a'ero po ti ojipe'g̃a pe nderohoi juiz'ga rovai pyteri pe te'i ti ga pe me nehẽ: ‘Pehe ti pemano ahe ja kiro pendekote'varuhuro g̃waramo’.” A'ea nhaneramonhava'ea mog̃itagwera i'ei, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","—Jihi reki a'e pe me: Po pe nhimonha'ngatehei pejikotyve'ga rehe, a'ero po ti ojipe'g̃a pe nderohoi juiz'ga rovai pyteri pe te'i ti ga pe me nehẽ: “Pehe ti pemano kiro pendekote'varuhuro g̃waramo.” Na tuhẽ po ti nehẽ, ei Jesus'ga. Pe'e tehe po pe pejikotyve'ga pe: “Ikwahave'ỹheteva'ea!” Po nanongara pe ei ga pe ga mbotegweteavo penhimonha'ngavo ga rehe, a'ero po ti ojipe'g̃a pe nderohoi judeus'g̃a mog̃itahara'g̃a ndovai pyteri pe nehẽ te'i ti g̃a pe me: “Pehe ti pemano kiro pendekote'varuhuro g̃waramo.” Na tuhẽ po ti nehẽ, ei Jesus'ga. Pe'e tehe po pe pejikotyve'ga pe: “Ndereakwahavihu nde ekovo!” Po nanongara pe ei ga pe ga mbotegweteavo penhimonha'ngavo ga rehe, a'ero po ti Tupana'ga pe mondoukari tata pype hahyva'ea ruvihava pype nehẽ, ei Jesus'ga. Na tuhẽ po ti nehẽ, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","—A'ero ji ei nde ve: Ereru tehe po nde Tupana'ga pe tamondouka ti ji ikwava'ẽhava rehe javo. Herurame po nde erekwahava'ja, jikotyve'ga onhimonha'nga ji rehe javo. Ikwahava'javame ti teremondoi ve Tupana'ga pe a'ero. ");
INSERT INTO pahNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Eheja ti ikwava'ẽhava pyri. Eho na'ẽ ti ejikotyve'ga pyri gapy'a nog̃atuavo ejihe ga mbohoryva'java. A'erorame jate ti ejora'ja ikwava'ẽhava pyri hehe imondoteheavo Tupana'ga pe, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","—Po nde rekote'varuhuro ojipe'ga pe, a'ero po ti ga ei nde ve nehẽ: “Xaho tuhẽ ji rupi juiz'ga pyri,” e po ti ga nehẽ. “Ga pe po ti ji ndete'varuhua mombe'ui nehẽ te'i ti ga nhandereaporog̃ita pe javo,” e po ti ga nde ve nehẽ. Ga nde rerohorame juiz'ga pyri kotihĩ ti ere ga pe ga ma'ngoma'ngoga ga rupi egwovo. Ere ti ga pe: “Nhande tuhẽ ti xanhimbovyvy na'ẽ.” A'ea ti ere ga pe. Po ti nde nerema'ngoma'ngogi ga pehea rupi nehẽ, a'ero po ti ga nde rerohoahyi juiz'ga pyri. A'ero po ti juiz'ga nde mondoukari guarda'ga pe nehẽ. Guarda'ga po ti nde mongi cadeia pype nehẽ. ");
INSERT INTO pahNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Imombe'ukatuavo ji ei nde ve: A'ea pype po ti nde pytai nehẽ. Nde imondokatupave'ymame ikwepykava, a'ero po ti guarda'ga nanerenohema'javi nehẽ, ei Jesus'ga imombe'gwovo g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","—Pekwaha pe nhaneramonhava'ea mog̃itagwera, ei Jesus'ga. “Taperekoi ti penhimbireko'g̃arũive'g̃a.” A'ea nhaneramonhava'ea mog̃itagwera i'ei, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","—Jihi reki a'e pe me: Kiroki ga hẽa repiaguhu hẽa rerekopotaheteavo – gareaporog̃ita ite'varuhu. A'ereki hẽa garembirekohẽa rũi. Ga hẽa rerekorame Tupana'ga ei a'ea ko ite'varuhu javo. Na jitehe Tupana'ga ei ite'varuhu javo ga hẽa potaruhurame. ");
INSERT INTO pahNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","—Po ejeakwara pyvõ ejohukoty rũi nde rekote'varuhui, a'ero ti ehekyi ejeakwara imomboa nahã imombiga ejekote'varuhua! ei Jesus'ga. Tiruahũ ti nde ve ndereakwara mombora nehẽ. Po imombore'yma nde neremombigi ejekote'varuhua, a'ero po ti koji'i tiruahũ nde ve nehẽ Tupana'ga nde momborame hahyva'ea ruvihava pype nde rekote'varuhuro g̃waramo. A'ero ji ei nde ve: Koji'i pyry nde imomborame ejeakwara ejekote'varuhua mombiga, ei Jesus'ga g̃ambote'varuhua mombora pe javo. Nderekote'varuhua pigame po ti Tupana'ga nanemombora'javi hahyva'ea ruvihava pype nehẽ, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","—Po epoa pyvõ ejohukoty rũi nde rekote'varuhui, a'ero ti ehaygwe'ro epoa ejihugwi imomboa nahã imombiga ejekote'varuhua! ei Jesus'ga. Tiruahũ ti nde ve ndepoa mombora nehẽ. Po imombore'yma nde neremombigi ejekote'varuhua, a'ero po ti koji'i tiruahũ nde ve nehẽ Tupana'ga nde momborame hahyva'ea ruvihava pype nde rekote'varuhuro g̃waramo. A'ero ji ei nde ve: Koji'i pyry nde imomborame epoa ejekote'varuhua mombiga, ei Jesus'ga g̃ambote'varuhua mombora pe javo. Nderekote'varuhua pigame po ti Tupana'ga nanemombora'javi hahyva'ea ruvihava pype nehẽ, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","—Nhaneramonhava'ea mog̃itagwera e'i: “Kiroki ga opohi g̃wembirekohẽa hugwi – a'ea ti ga tokwatija na'ẽ imondovo hẽa pe aerẽ hẽa mondovo ojihugwi nehẽ.” A'ea ahemog̃itagwera i'ei, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","—Jihi reki a'e pe me: Opohi po ga g̃wembirekohẽa hugwi ojipe'ga hẽa rerekoro g̃waramo, ei Jesus'ga. Po ojipe'ga ndogwerohoi hẽa hẽarembireko'ga hugwi. Naname hẽarembireko'ga opohirame hẽa hugwi opohi tehe hẽa hugwi. Gapohitehea ndapyryvi Tupana'ga pe, ei Jesus'ga. —Ga pohiteherame hẽa hugwi po ti hẽa ojipe'ga rerekopotari a'ero nehẽ, ei ga. Ga rerekorame hẽa ajuajuri a'ero. A'ereki hẽa hembireko jitehe jypyve'ga pavẽi, ei ga. Hẽarembirekoypy'ga reki ite'va hete a'ero, ei Jesus'ga. A'ereki ga hẽa mboajuajuruka opohitehero g̃waramo hẽa hugwi, ei ga. Tupana'ga ndopotari nanongara. —Kiroki ga kirẽ gwereko hẽa – gaha ite'varuhu. A'ereki ga gwereko garembirekohẽa. Tupana'ga ndopotari nanongara no, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","—Pekwaha tuhẽ pe nhaneramonhava'ea mog̃itagwera, ei Jesus'ga. Ymyahũ nhaneramonhava'ea mog̃itagwera i'ei: “Pe'e po pe Tupana'ga renoina: ‘Nahanahã po ti ji rekoi nehẽ. A'itituhẽva'ea pe kiro ji ei. Tupana'ga ji'ea renduvame ga ei ji ve a'itituhẽva'ea pe ga ei javo.’ Po a'ea pe ei, a'ero na tuhẽ ti peko Tupana'ga pe ndepiagame,” e'i nhaneramonhava'ea mog̃itagwera, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","—Jihi reki a'e pe me: Tapehenoi ti Tupana'ga pe'erame nahã po ti ji rekoi nehẽ javo, ei ga. —Na jitehe ti tapehenoi Tupana'ga apoa pe'erame a'ero po ti g̃a nhinhi'ig̃a reroviari nehẽ javo, ei ga. Tapehenoi ti yvaga a'ero. A'ereki a'ea ko Tupana'ga apykava nhanderuvete'ga apykava. Pe yvaga henonhame pe Tupana'ga renoi a'ero, ei ga. Nurã ti tapehenoi yvaga pe'erame nahanahã po ti ji rekoi nehẽ javo. ");
INSERT INTO pahNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","—Tapehenoi ti yvya no. A'ereki yvya ko Tupana'ga pya nongava. Nurã ti tapehenoi yvya pe'erame nahanahã po ti ji rekoi nehẽ javo. —Tapehenoi ti cidade de Jerusalém. A'ereki Jerusalém ko Tupana'ga cidade nhanderuvihavuhuhete'ga cidade. Nurã ti tapehenoi Jerusalém pe'erame nahanahã po ti ji rekoi nehẽ javo. ");
INSERT INTO pahNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","—Tapehenoi ti penhiakag̃a. A'ereki tegwete pe me peji'ava mbotehava imotig̃a! Tegwete pe me peji'ava mbotehava imohuna no! Tupana'ga jate oapo pe'ava imotig̃a imohuna no, ei Jesus'ga. Nurã ti tapehenoi penhiakag̃a pe'erame nahanahã po ti ji rekoi nehẽ javo. ");
INSERT INTO pahNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","—Po ti na pendekopotarame pe'ji ti: “Nahã po ti ji rekoi nehẽ.” A'ea jate ti pe'ji Tupana'ga renonhe'yma ga'apoa renonhe'yma no. Po ti na rũi pendekopotarame pe'ji ti: “Ndakoi po ti ji na nehẽ.” A'ea jate ti pe'ji Tupana'ga renonhe'yma ga'apoa renonhe'yma no. A'ereki ite'varuhuve'ga Diabo'ga pe mbo'e Tupana'ga renonha rehe mbatera renonha rehe no, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","—Pekwaha pe nhaneramonhava'ea mog̃itagwera, ei Jesus'ga. A'ea e'i: “Po ojipe'ga hekyi ndereakwara, a'ero ti ehekyi gareakwara ejipyga. Po ojipe'ga nde kwari imbo'gwya neranha, a'ero ti embo'gwy garanha ejipyga.” A'ea nhaneramonhava'ea mog̃itagwera i'ei, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","—Jihi reki a'e nde ve: Terejipygi ti ojipe'ga rehe ga rekote'varuhurame nde ve, ei Jesus'ga. Po ga kwari nderetyvapea rehe, a'ero ti ejirova ga pe tokwa ti ga ojipea rehe no javo, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","—Po ojipe'ga nde rerohoi juiz'ga pyri hekyjukapota ndecamisa nde hugwi ga ite'varuhu ji ve javo juiz'ga pe, a'ero ti a'ea ehekyi ejihugwi imondovo ga pe. Ehekyi ti ojipea imondovo ga pe no epaletó, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","—Po ojipe'ga ei nde ve: “Eroho ti jiapoa ji ve pevo um quilômetro.” Ga erame na nde ve um quilômetro rehemo'i ti eroho ga'apoa a'ero dois quilômetros. Nahã ti tandepyry ga pe, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Po ojipe'ga ei nde ve embuhu ti ji ve javo, a'ero ti emondo ga pe. Po ojipe'ga ei nde ve embuhu'rã ti ji ve javo, a'ero ti emondo'ã ga pe, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","—Pekwaha tuhẽ pe nhaneramonhava'ea mog̃itagwera, ei Jesus'ga. A'ea e'i: “Pearõ hete ti penhiarõheteve'g̃a. Tapearõi ti penhiarõe'ỹve'g̃a.” A'ea nhaneramonhava'ea mog̃itagwera i'ei, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","—Jihi reki a'e pe me: Pearõ hete ti penhiarõe'ỹve'g̃a, ei Jesus'ga. Po g̃a ndekote'varuhui pe me, a'ero ti penhi'ĩ Tupana'ga pe emombyry ti g̃a pe javo, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Nahã ti peko katu Tupana'ga ra'yramo yvagipeve'ga ra'yramo tiandepyry ti nhandejuvete'ga ja javo. A'ereki ga pyry hete okote'varuhuve'g̃a pe pyryve'g̃a pe no, ei Jesus'ga. Pyry hete ga g̃a pe oapoa japoi kwara japoi imomboruka g̃a pe. Ga pyry g̃a pe imongyrukari amana g̃a pe. Nahã ga g̃a nderekokatui okokatuve'g̃a okote'varuhuve'g̃a ndeheve, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","—Po penhiarõheteve'g̃a jate pe pearõ hete, a'ero Tupana'ga ei pe me: “Pe okote'varuhuve'g̃a ja reki penhiarõheteve'g̃a aromo penhiarõe'ỹve'g̃a arõe'yma.” Nahã ga ei pe me. A'ereki okote'varuhuve'g̃a – kiroki g̃a omono'ono'og̃uhũ itambere'ia governo pe – g̃a na jitehe oarõ oarõheteve'g̃a jate, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","—Po pe nhi'ig̃atui pejikotyve'g̃a pe jate pendoryndoryvamo g̃a ndehe, a'ero ojipe'g̃a hohe rũi pe ndekokatui reki. A'ereki Tupana'ga kwahave'ỹve'g̃a onhi'ig̃atu ojikotyve'g̃a pe jate gworygworyvamo g̃a ndehe no, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","—Pearõ hete ti g̃a nhaporemo penhiarõheteve'g̃a penhiarõe'ỹve'g̃a ndeheve. Nahã po ti pe ndekopyryvamo pejuvete'ga javijitehe yvagipeve'ga javijitehe nehẽ, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","—Tape'ei ti pejiyvyteri pe: “Nahanahã po ti ji rekokatui jirekokatua repiuka ojipe'g̃a pe. A'ero po ti g̃a ji mbohetei nehẽ.” A'ea ti tape'ei. Po pe ndekokatui tanhimbohete ti g̃a javo. Po pe ndekokatui a'ea rehe jate, a'ero po ti penduvete'ga yvagipeve'ga nomondoi pendekokatua kwepykava pe me nehẽ, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","—Nurã imondoteherame imbatere'ỹve'g̃a pe ti terekoi okokatu'ãve'g̃a ja. A'ereki ojatykahava pype g̃a omondo tehe imbatere'ỹve'g̃a pe cidade rapea rupi no. A'ereki pevo he'yjuhuve'g̃a ohooho jipi g̃a ndepiaga g̃a imondorame. A'ero g̃a ndepiagame g̃a g̃a mbohetei. G̃anemimbohetea jate ikwepykava okokatu'ãve'g̃a pe, a'e ji imombe'ukatuavo pe me, ei Jesus'ga. Tupana'ga po ti nombohetei okokatu'ãve'g̃a imondoe'yma g̃a pe g̃anemimondotehea kwepykava a'ero nehẽ, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","—Imondoteherame imbatere'ỹve'g̃a pe ti teremboukwahavi ojipe'g̃a pe a'ero. ");
INSERT INTO pahNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Tokwahavyme ti g̃a. Nderuvete'ga reki gwepia pa neremimondonhimima. Ga tuhẽ po ti omondo neremimondotehea kwepykava nde ve nehẽ, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","—Tapekoi ti okokatu'ãve'g̃a ja penhi'ig̃ame Tupana'ga pe. A'ereki ikatu hete g̃a pe g̃a amame ojatykahava pype cidade rapea peahai pe no onhi'ig̃a Tupana'ga pe. A'ereki g̃a nhi'ig̃ame Tupana'ga pe he'yjuhuve'g̃a gwepia g̃a mboheteavo oko katu g̃a javo, ei Jesus'ga. G̃anemimbohetea jate oko ikwepykava okokatu'ãve'g̃a pe, a'e ji imombe'ukatuavo pe me, ei Jesus'ga. Tupana'ga po ti nombohetei okokatu'ãve'g̃a imondoe'yma g̃a pe g̃anhi'ig̃a kwepykava a'ero nehẽ, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","—Ndehe reki, enhi'ig̃ame Tupana'ga pe, nde tehe ti eho enhonga pe hyrua pype hovapytyma. Pevo ti enhi'ĩ nhimi ejuvete'ga pe Tupana'ga pe. Ga gwepia pa reki. A'ero po ti ga ikwahavi nenhi'inhimima ojive nehẽ. A'ero po ti ga imondoi nenhi'ig̃a kwepykava nde ve nehẽ, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","—Penhi'ig̃ame Tupana'ga pe ti tapenhi'inhi'ĩtehei, ei Jesus'ga. Tupana'ga kwahave'ỹve'g̃a ja rũi ti penhi'ĩ ga pe. A'ereki onhi'ig̃ame Tupana'garũiva'ea pe g̃wemimbohetehara pe g̃a onhi'imbukuhu jupe. “A'ero po ti turi pyryva'ea nhande ve nehẽ,” ei g̃a novĩa ikwahave'yma, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Tapekoi ti g̃a ja a'ero. A'ereki penduvete'ga okwaha pendekoa g̃wig̃wia ti g̃a togwereko javo. Peporanduva renonde ga hugwi ga okwahavipe pe mbatere'ymame, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","—Marã po ti pe nhi'ig̃i Tupana'ga pe a'ero? Kiro ti ji imombe'ui pe me. Penhi'ig̃ame nhanderuvete'ga pe Tupana'ga pe nahã ti pe'ji ga pe: “Apĩ, yvagipeva'ero nde ereko katu hete. Tanerenoig̃atu ti g̃a nhaporemo a'ero nde mboheteavo ga ko Tupanete'ga javo nde ve. ");
INSERT INTO pahNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Herejo ti yvyakotyve'g̃a nduvihavuhuhetero ekovo. Nde nhi'ĩpo'ru g̃a yvagi pe okovo neremimbotarimova'ea rupi. Na jitehe kiro ti g̃a tanenhi'ĩpo'ru avo no yvya koty okovo neremimbotarimova'ea rupi. ");
INSERT INTO pahNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Embuhuruka ti ore ve mbatera jipi toro'u ti a'ero. ");
INSERT INTO pahNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Ore ndorokwahava'javi ojipe'g̃a ndekote'varuhua orojihe henonhe'yma. Na jitehe ti orerekote'varuhua emombo ore hugwi ikwahava'jave'yma henonhe'yma. ");
INSERT INTO pahNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Satanás'ga ore mongo te'varuhu pota. Toremongote'varuhuukari ti ga pe. Ore poko ti toronhi'ĩpo'ruyme ti Satanás'ga orokoe'yma garemimbotarimova'ea rupi. A'ereki ndehe ko yvyakotyve'g̃a nduvihavuhuhetero ereko. Ndehe ndepopoaka.” Nahã ti pe'ji penhi'ig̃ame Tupana'ga pe, ei Jesus'ga g̃a mbo'eavo. ");
INSERT INTO pahNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","—Nahã ji pe mbo'ei tapekwahava'javi ti ojipe'g̃a ndekote'varuhua pejihe javo. Pe ikwahava'jave'ymame g̃andekote'varuhua pejihe henonha'jave'ymame po ti penduvete'ga omombo pendekote'varuhua pe hugwi ikwahava'jave'yma henonhe'yma nehẽ. ");
INSERT INTO pahNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Po pe ikwahava'javi g̃andekote'varuhua pejihe henonha'java, a'ero po ti penduvete'ga nomombori pendekote'varuhua pe hugwi ikwahava'java nehẽ, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","—Pe'e po pe: “Ti'uyme ti kiro timbohete ti Tupana'ga javo.” A'ea po pe ei i'ue'yma. Nahã i'ue'ymame ti tapekoi okokatu'ãve'g̃a ja. A'ereki i'ue'ymame g̃a okoveveuhu'ã gwova rerekokatue'yma hahy nhande ve javo. Nahã g̃a ndekoi i'ue'ymame tokwaha ti ojipe'g̃a nhande i'ue'ymame javo. A'ereki g̃a e'i oyvyteri pe: “Ikwahavame po ti g̃a nhande mbohetei g̃a oko katu Tupana'ga mboheteavo i'ue'yma javo.” G̃anemimbohetea jate ikwepykava okokatu'ãve'g̃a pe, a'e ji imombe'ukatuavo pe me, ei Jesus'ga. Tupana'ga po ti nombohetei okokatu'ãve'g̃a imondoe'yma g̃a pe i'ue'yma kwepykava a'ero nehẽ, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","—Ndehe, tambohete ti Tupana'ga javo ndere'ui po nde. Po a'ea rehe nde ndere'ui, a'ero ti emongy nhandya e'ava rehe. Ejovahei ti no. ");
INSERT INTO pahNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","A'ero po ti ndiukwahavi ojipe'g̃a pe nde i'ue'ymame. Nderuvete'ga reki gwepia pa. A'ero po ti ga ikwahavi nde i'ue'ymame nehẽ. A'ero po ti ga imondoi i'ue'yma kwepykava nde ve nehẽ, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","—Tapemono'ono'og̃uhũi ti pejive he'yjuhuva'ea ikatuva'ea avo yvya koty. A'ereki avo aryry'ia ombote'va aheapoa. Jypopo aheapoa avo no. Iporomive'g̃a uhuraha aheronga pe imima aheapoa avo no, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Pejiko ti Tupana'ga rehe pejikokatuavo pejikovo garemimbotarimova'ea rupi jate. Nahã po ti pe pemono'ono'og̃atu pejive ikatuheteva'ea yvagi pe nehẽ. Aryry'ia nombote'varuhui aheapoa yvagi pe. Nomombupugi aheapoa pevo no. Iporomive'g̃a ndohoi yvagi pe imima aheapoa, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Nurã ji ei pe me: Pejiko hete ti Tupana'ga rehe pejikokatuavo pejikovo garemimbotarimova'ea rupi jate. Po avo yvya koty peapoa uvame, a'ero yvyakotyva'ea rehe pe pemondo pejeaporog̃ita imohina jipi. Po yvagi pe peapoa uvame, a'ero yvagipeva'ea rehe pe pemondo pejeaporog̃ita imohina jipi, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","—Ndereakwara ko lamparina ja nde ve, ei Jesus'ga. Ndereakwakaturame po ti nde hepiakatui egwovo kojahua rupi ikwahava nehẽ. Na jitehe ndereaporog̃itakaturame ekovo pota Tupana'ga remimbotarimova'ea rupi po ti nde rekokatukwahavi nehẽ, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","—Ndereakwate'varuhurame po ti nde nderehepiagi egwovo ypytuna rupi ikwahave'yma nehẽ. Na jitehe ndereaporog̃itate'varuhurame ekopotare'yma Tupana'ga remimbotarimova'ea rupi po ti nde nderekokatukwahavi nehẽ, ei Jesus'ga. Ejeaporog̃ita katu ti a'ero. Po nde nandeaporog̃itakatui, a'ero po ti nde nderekokatukwahavi'i'i ekote'varuhuavo nehẽ! ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","—Tiruahũ ahe poravykyrame mokonha'g̃a pe opojykahara'g̃a pe. Po ahe oporavyky mokonha'g̃a pe, a'ero po ahe ojipe'ga arõhetei ojipe'ga arõe'yma. Ovy'a hete po ahe onhimiarõve'ga rehe ojipe'ga koty ojirovage'yma. —Na jitehe ahe nonhi'ĩpo'rukatui Tupana'ga ovy'aheterame itambere'ia rehe. Tupana'ga potaheterame ahe ndovy'ahetei itambere'ia rehe. Itambere'ia potaheterame ahe ndojirovagi Tupana'ga koty, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","—Nurã ji ei pe me: Tape'ag̃ataruhui ti mbatera rehe. Tape'ei ti: “Maramarã po ti ji rekoi nehẽ? Gara po ti ji a'u nehẽ? Ahã po ti ji ve nehẽ. Gara po ti ji amongi nehẽ? Aerẽ po ti jipira itoropavi nehẽ.” Tape'ei ti nahã penhi'ag̃ataruhue'yma. —Tapekouhui ti penhimbi'ua rehe, ei Jesus'ga. Tupana'ga pe apo. A'ero po ti ga imondoukari pe me mbatera nehẽ to'u ti g̃a javo. A'ereki Tupana'ga pe koji'i pyry pendekoa. Tapekouhui ti pejipira rehe. Oapo ga penda'oa. A'ero po ti ga imondoukari pepira pe me nehẽ. A'ereki Tupana'ga pe koji'i pyry penda'oa, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","—Pehepia ti gwyra'ia ikwahava. Notymi ojive gwyra'ia. Ndohetygi g̃wemityma i'gwovo a'ero. Nomono'og̃i mbatera opoitava ryrua pype aerẽ po ti ti'u javo. O'u reki gwyra'ia. A'ereki penduvete'ga yvagipeve'ga ouka jupe. Pe me ga ei: “Koji'i ji rekohetei pe ndehe,” ei Tupana'ga pe me. Nurã po ti ga imondoi pe me nehẽ no, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","—Pe'ag̃ataruhu po pe javo: “Koji'i po ji nhimomboakari hamo. Um meio metro po ti ji nhimomboakara'javi nehẽ.” Nahã po pe ei. Pe'ag̃ataruhu po pe a'ea rehe javo novĩa. Napenhimomboakara'javi tuhẽ po ti pe nehẽ, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","—Tape'ag̃ataruhui ti pejipira rehe no gara po ti amongi nehẽ javo. Pehepia ti yvoty'ria nhuhũ me. Henhui onhimomboaka onhimongyavo yvoty'ria. Ndoporavykyi ipyhyga i'gwovo. Ndoapoi opi'ria. ");
INSERT INTO pahNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","A'e ji pe me: Ymya aheruvihavuhuva'ea Salomãova'ea omongi tapy'ynhapipyryva jipi. Ikatu hete tuhẽ ahepipyryva onhimongyavo. Ahepipyryva hohe reki yvoty'ria ikatuhetero. ");
INSERT INTO pahNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Tupana'ga ombokatu ipira nhungwavuhua pira okovo hehe. Nhungwavuhua horyory nhuhũ me kiro. Ko'emame ahe omombo nhungwavuhua tata pype tamohendy ti tata javo. Nombokwara'ari nhungwava. —Koji'i Tupana'ga pe arõi imondoukari tapy'ynhapira pe me pemongi ti javo. Xunhi pe pejiko ga rehe! ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","—Tape'ag̃ataruhui ti. Tape'ei ti: “Gara po ti ti'u nehẽ? Gara po ti timongi nehẽ?” A'ea rũi ti pe'ji. ");
INSERT INTO pahNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","A'ereki a'ea rehe nhaporemo judeus'g̃arũive'g̃a gentios'g̃a nhag̃ataruhu jipi – kiroki g̃a ndojikogi Tupana'ga rehe. Tape'ag̃ataruhui ti hehe a'ero. A'ereki penduvete'ga yvagipeve'ga okwaha pe mbatere'ymame togwereko ti g̃a g̃wig̃wia nhaporemo javo, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","—Tupana'ga ko penduvihavuhuhetea. Pejirokwa ti pejikovo ganhi'ig̃a rupi gaha ko jiruvihavuhuhetea tuhẽ javo, ei Jesus'ga. Kiroki a'ea rehe Tupana'ga omondo gweaporog̃ita imohina – a'ea rehe jitehe ti pemondo pejeaporog̃ita imohina no. Pe ndekorame na po ti Tupana'ga imbuhupavi mbatera pe me nehẽ togwereko paravuhu ti g̃a javo, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Nurã ti tape'ag̃ataruhui ko'emameva'ea rehe. Tape'ei ti: “Marã po ti ji ve ko'emame?” Tape'ei ti na. Ko'emame po ti Tupana'ga pe pokogi nehẽ no. Nane'ymi hekoi tiruahũva'ea ag̃wamo ko'emame jipi. Kirog̃we tape'ag̃ataruhui ti ko'emameva'ea rehe, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","—Tape'epe'ei ti ojipe'g̃a pe: “Nahanahã g̃a okote'varuhu.” Tape'euhui ti a'ea. A'ero po ti Tupana'ga nde'i a'ea pe me nehẽ, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Pe epe'erame ojipe'g̃a pe na jitehe po ti Tupana'ga eahyi pe me nehẽ. Pe imondorame hahyva'ea ojipe'g̃a pe na jitehe po ti Tupana'ga imondoi hahyva'ea pe me nehẽ, ei Jesus'ga. Pe ekaturame g̃a pe na jitehe po ti Tupana'ga e'i katu pe me nehẽ, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","—Ereko te'varuhu nde ejikotyve'ga pe. A'ero nde ei ga pe: “Hay'iuhua oko ndereakwari pe,” ere nde. Maranameuhũ nde euhui a'ea ga pe ndokokatui ga javo? Jihi a'e reki nde ve: Okyta reki oko ndereakwari pe! ei Jesus'ga. Nahã ji ei nde ve nde koji'i ereko te'varuhu ga hohe javo. Nde nderekwahavi reki ejekote'varuhua naerũ? ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","—Maranameuhũ nde euhui ejikotyve'ga pe naerũ? Tere'ei ti ga pe a'ero: “Na ji hekyi hay'iuhua ndereakwara hugwi.” Tere'ei ti nahã okyta rekorame ejeakwari pe naerũ. ");
INSERT INTO pahNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","A'ereki nde nderehepiakatui ve hekyita gareakwara hugwi okyta pytarame ejeakwari pe. Okokatu'ãva'ea ko nde! A'ereki okyta rerekoe'ỹva'ea ja nde ere'e: “Ji ndarekoi jireakwari pe,” ere nde. Ehekyi na'ẽ ti okyta ejeakwara hugwi. A'ero po ti nde hepiakatui hekyita hay'iuhua gareakwara hugwi nehẽ, ei Jesus'ga ga pe. A'ea Jesus'ga ei epohi na'ẽ ti ete'varuhua hugwi kirẽ ga pokoga javo. ");
INSERT INTO pahNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","—Kiroki Tupana'ga apoa pyryva'ea – a'ea ti tapemondoi nhag̃watig̃a pe, ei Jesus'ga. Tapemondoi ti mbo'yra pérolas apopyra pyryva'ea porcos pe, ei Jesus'ga. A'ereki porcos ndokwahavi pyryva'ea nhag̃watig̃a pavẽi. Po ti pe imondoi jupe, a'ero po ti ipyrũpyrug̃i hehe, ei Jesus'ga. Ivaga pendovai po ti pe hu'ui nehẽ no. A'ea Jesus'ga ei g̃a pe tapemondoi Tupana'ga nhi'ig̃a imombe'gwove'ỹ Tupana'ga arõe'ỹve'g̃a pe javo. A'ereki g̃a ndokwahavi pyryva'ea. ");
INSERT INTO pahNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","—Penhi'ig̃ame Tupana'ga pe ti peporandurandu ga pe pejikovo. A'ero po ti Tupana'ga imondoukari pe me nehẽ. Pehekaeka ti tihepia ti javo. A'ero po ti pe hepiagi nehẽ. Pekwapekwa ti porta rehe pejikovo taho ti ji jurukwara rupi javo. A'ero po ti pe hoi hupi nehẽ, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","A'ereki kiroki g̃a onhi'ĩ Tupana'ga pe ore poko javo – g̃a pe nhaporemo Tupana'ga omondouka okovo imombyryva iporanduve'g̃a pe hekahara'g̃a pe okwaokwave'g̃a pe, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","—Po penda'yra'ga ei pe me embuhu ji ve pão javo, a'ero ita rũi po pe imondoi ga pe pejikovo garuvamo. ");
INSERT INTO pahNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Po penda'yra'ga ei pe me embuhu ji ve pira javo, a'ero mboja rũi po pe imondoi ga pe, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Ite'varuhue'ỹva'ea ja po pe pekwaha imondovo peja'yra'g̃a pe. Peko te'varuhu pe reki. Po pe g̃anduvamo pekwaha imondovo peja'yra'g̃a pe, a'ero koji'i penduvete'ga yvagipeve'ga pyryheteve'ga ikwahahetei pyryheteva'ea imondovouka pe me pe poranduvame ga pe, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","—Pe'e po pe pejiyvyteri pe: “Po ojipe'g̃a oko katu nhande ve nhande pokoga hamo.” Po nahã pe ipotari, a'ero na jitehe ti peko katu g̃a pe g̃a pokoga jipi no. A'ereki a'ea rehe jitehe Moisésva'ea ombo'e Tupana'ga nhi'ig̃a mombe'uharava'ea pavẽi, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","—Ndipypiriva'ea ko porta Tupana'ga ronga apoa, ei Jesus'ga. Peho ti ndipypiriva'ea rupi a'ero. A'ereki ipypiva'ea ko hahyva'ea ruvihava apoa porta. Pehea hahyva'ea ruvihava viaramo a'ea ipypiva'ea no. He'yjuhuve'g̃a oho ipypiva'ea rupi, ei Jesus'ga. Nahã Jesus'ga ei. A'ereki he'yjuhuve'g̃a ndopohipotari okote'varuhua hugwi okovo g̃wemimbotarimova'ea rupi. A'ero po ti g̃a hoi hahyva'ea ruvihava pype nehẽ. ");
INSERT INTO pahNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","—Tupana'ga ronga apoa porta ko ndipypiriva'ea, ei Jesus'ga. Pehea garonga viaramo a'ea ndipypiriva'ea no. Ohorame a'ea rupi po ti g̃a ndekoi ga pyri avuirama nehẽ, ei ga. Ndahe'yive'g̃a hepiagi ndipypiriva'ea ogwovo hupi, ei Jesus'ga. Nahã Jesus'ga ei. A'ereki ndahe'yive'g̃a opohi pota okote'varuhua hugwi okovo Tupana'ga remimbotarimova'ea rupi. Opohirame po ti g̃a hoi ga pyri upa avuirama nehẽ. ");
INSERT INTO pahNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","—Penhimboko'i ti Tupana'ga nhi'ig̃aatyviva'ea mombe'uhara'g̃a hugwi. Uhurame pe pyri g̃a oko nhyrõ okokatuve'g̃a ja ovelha ja novĩa. G̃a ndokonhyrõi reki pe moandyandyita ja'gwara'java'ea ja lobo ja. Na tuhẽ g̃a ndekoi pe mbote'varuhupota, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","G̃andekoa repirepiagame po ti pe nhimombaragwahavi g̃a ndehe nahanahã g̃a ndekote'varuhui nhande moandyandyita javo, ei Jesus'ga. —Yva'ia repiagame ahe okwaha i'yva. A'iti tuhẽ! Ahe ndoykyi figo g̃wakag̃wa'yva hugwi. A'ereki g̃wakag̃wa'yva figo'yva rũi figueira rũi, ei Jesus'ga. Na jitehe ahe ndoykyi uva ka'api'iuhua hugwi. A'ereki ka'api'iuhua uva'yva rũi videira rũi, ei Jesus'ga. Yva'ia repiagame ahe ikwahavi i'yva a'ero. —Na jitehe g̃andekoa repiagame ahe ikwahavi. G̃andekokatua repiagame ahe ikwahavi g̃andeaporog̃itapyryva. G̃andekote'varuhua repiagame ahe ikwahavi g̃andeaporog̃itate'varuhua, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","—Na jitehe i'yvakatuapora ko yva'ikatua. I'yvate'varuhuapora ko yva'ite'varuhua, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Tegwete yva'ikatua i'yvate'varuhua rehe. Tegwete yva'ite'varuhua i'yvakatua rehe, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Po i'yva ndogwerekoi yva'ikatua, a'ero ahe imbo'ari imondovo tata pype, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Ahe okwaha i'yva. A'ereki ahe gwepia herekorame yva'ia ojihe. —Na jitehe ahe Tupana'ga nhi'ig̃aatyviva'ea mombe'uhara'g̃a kwahavi. A'ereki ahe gwepia g̃andekoa nahanahã g̃a ndekote'varuhui javo, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","—Kiroki g̃a e'i tehe ji ve: “Ndehe ko orepojykaharetero. Ndehe ore orombohete” – g̃ahã po ti ndohoi yvagi pe ojikoge'yma ji rehe imomborukare'yma okote'varuhua nehẽ, ei Jesus'ga. Jiruva'ga yvagipeve'ga po ti g̃anduvihavuhuhete'ga rũi ojikoty'are'yma g̃a pavẽi nehẽ, ei Jesus'ga. Kiroki g̃a oko gareaporog̃ita rupi – g̃ahã po ti oho pevo ojikoga ji rehe imomboruka okote'varuhua nehẽ. G̃anduvihavuhuhetero po ti ga oko a'ero ojikoty'a g̃a pavẽi nehẽ, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","—Aerẽ mbapava koty po ti Tupana'ga okokatuve'g̃a mbuhurukari ojipyri g̃a mongovo avuirama nehẽ, ei Jesus'ga. Okote'varuhuve'g̃a po ti ga g̃a mondoukari hahyva'ea ruvihava pype g̃a mombyta avuirama nehẽ, ei Jesus'ga. Ga g̃a mondoukarame hahyva'ea ruvihava pype po ti g̃a eg̃a'ei nde ko orepojykaharetero javo ji ve onhimongyavo nehẽ: “Oromombe'u ore Tupana'ga nhi'ig̃a g̃a mbo'eavo hehe nahanahã Jesus'ga ei javo,” e po ti g̃a ji ve nehẽ. “Kiroki g̃a pe Diabo'gapyriva'ea oko te'varuhu anhag̃a – g̃a hugwi orombojipe'a ore anhag̃a Jesus Cristo'ga pe mbojipe'a javo jupe. Oroapo ore ahemonhimomby'aheteva'ea he'yjuhuva'ea Jesus'ga oapouka ore ve javo,” e po ti g̃a ji ve nehẽ, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","A'ero po ti ji ehetei imombe'ukatuavo g̃a pe nehẽ: Peko pe ambotehero ji hugwi pejikoangave'yma jireheva'ero. Pejipe'a ti ji hugwi pejigwovo. A'ereki nane'ymi pe pekote'varuhu. A'ea po ti ji ei g̃a pe nehẽ, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","—Kiroki g̃a nhinhi'ig̃a rendu katu okovo nhinhi'ig̃a rupi – kiroki a'ea ji amombe'u ko – g̃a pe ji ei ikwahapyra'g̃a. A'ereki g̃a ko onga apohara'ga ja – kiroki ga oapo g̃wonga hyvykoita imohina itauhua rehe, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Aerẽ amana ikyreteuhui. Hehanhuhũ yhya a'ero ua garonga pyri yvya atyma. Yvytua turuhui no. Ipopoaka yvytua garonga rehe novĩa. Ndo'ari reki garonga. A'ereki imondovo itauhua rehe ga oapo imohina, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","—Jara'g̃a – kiroki g̃a nanhirendukatui okoe'yma nhinhi'ig̃a rupi – g̃a pe ji ei ikwahave'ỹve'g̃a. A'ereki g̃a ko onga apohara'ga ja – kiroki ga oapo g̃wonga imondoteheavo y'ytig̃a rehe jate imohina, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Aerẽ amana ikyreteuhui. Hehanhuhũ yhya a'ero ua garonga pyri yvya atyma. Yvytua turuhui no. Ipopoaka yvytua garonga rehe imbovavavavaga imbo'a. O'arahy upa garonga, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Jesus'ga a'ea mombe'upavirẽ pevove'g̃a nhimomby'ai garemimbo'ea rehe. ");
INSERT INTO pahNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","A'ereki ga tuhẽ okwaha hete g̃a mbo'eavo huvihava'ga ja. G̃ambo'ehara'g̃a ja rũi – kiroki g̃a ombo'e Moisésva'ea remimbo'eagwera rehe – g̃a ja rũi ga g̃a mbo'ei a'ero. ");
INSERT INTO pahNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Jesus'ga jyvirẽ yvytyruhua hugwi ogwovo he'yjuhuve'g̃a hoi ga reviri ogwovo ga rupi. ");
INSERT INTO pahNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ijaijauhuve'ga ruri Jesus'ga pyri g̃wenypy'anduruga jihoheva'ero ji poko javo. Jesus'ga renoina nde ko jipojykaharetero javo ga ei: —Nde eremoka'ẽ kwaha jijagwa ji hugwi. Po nde imoka'ẽpotari jijagwa, a'ero po ti nde imoka'ẽi nehẽ, ei ga Jesus'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","A'ero Jesus'ga jipoapyhoi opokoga ga rehe. E'i ga ga pe: —Apota ji. Eka'ẽ ga hugwi! ei Jesus'ga. Kotihĩ ika'ẽi ga hugwi a'ero. ");
INSERT INTO pahNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Jesus'ga e'i ga pe: —Teremombe'ui tuhẽ ti ojipe'g̃a pe, ei ga. Eho ti ejipiuka ikwava'ẽhara'ga pe oka'ẽ jijagwa javo. Emondo tehe ti mbatepyryva ga pe tokwava'ẽ ti ga Tupana'ga pe okovo Moisésva'ea remimbo'eagwera rupi. Nde imondorame ga pe po ti pevove'g̃a nde repiagi nehẽ. A'ero po ti g̃a ikwahavi nehẽ gajagwa oka'ẽ javo, ei Jesus'ga ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Jesus'ga vahemirẽ Cafarnaum me romano'ga soldados'g̃a nduvihava'ga ruri Jesus'ga pyri. Ovahẽ ga Jesus'ga pyri topoko ti Jesus'ga jipyrive'ga javo. ");
INSERT INTO pahNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Jesus'ga renoina jipojykaharetero ko nde javo ga ei Jesus'ga pe: —Jipyrive'ga itetirũa hete onhinog̃a nhironga pe. Nomynha'javi ga. Hahy hete ga pe no, ei ga Jesus'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","A'ero Jesus'ga ei: —Aho po ti ji ga pyri imombiga ga hugwi a'ero kiro, ei ga. ");
INSERT INTO pahNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","A'ero soldados'g̃a nduvihava'ga ei Jesus'ga pe: —Jipojykaharetero nde ji hohe ereko huvihavamo, ei ga. A'ero ji nda'ea'uvi eho ti nhironga pe ga repiaga jave'yma nde ve. Terehoa'javi ti ga repiaga. Irupeuhu ti emondo epopoakara nhironga pe imombiguka karugwara jijipyrive'ga hugwi. A'ero po ti ga nhimohig̃atui nehẽ. ");
INSERT INTO pahNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","—Akwaha ji ndepopoakara mondoa irupeuhu, ei ga Jesus'ga pe. A'ereki na jitehe ji amondo soldados'g̃a jipi. Jiruvihava'ga ji mondoi no nahanahã eapo javo. A'ero ji rekoi ganhi'ig̃a rupi. Jihi soldados'g̃a nduvihavamo ako no. Ojipe'ga pe ji ei: Eho nahanahã japovo pevo ji ve. A'ero ga hoi okovo nhinhi'ig̃a rupi. Ojipe'ga pe ji ei: Ejo nahanahã japovo avo. A'ero ga ruri okovo nhinhi'ig̃a rupi. Jijipyrive'ga pe ji ei: Nahã eapo. A'ero ga japoi, ei soldados'g̃a nduvihava'ga Jesus'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Ga renduvame Jesus'ga nhimomby'ai. Kiroki g̃a oho Jesus'ga rupi – g̃a pe Jesus'ga ei: —Soldados'g̃a nduvihava'ga ojiko hete tuhẽ ji rehe! Jire'yja'g̃a hohe israelitas'g̃a hohe ga ojiko ji rehe! a'e ji pe me imombe'ukatuavo, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","A'e ji pe me: He'yjuhuve'g̃a po ti uhu kwara ipora hugwi kwara ihoa hugwi no ua Tupana'ga ronga pype yvagi pe nehẽ – perope Tupana'ga oko nhanderuvihavuhuhetero. Nahã po ti g̃a nduri oapyga Abraãova'ea pyri Isaqueva'ea pyri no Jacóva'ea pyri no oina nehẽ ti'u ti Tupana'ga ronga pype javo, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ojipe'g̃a po ti uhu garonga pype hamo novĩa israelitas'g̃a. Nduri po ti g̃a ipype nehẽ ojikoge'yma g̃waramo Tupana'ga rehe. Tupana'ga nomongiukari g̃a g̃wonga pype nehẽ g̃a momboa ypytunahiva pype nehẽ. Pevo po ti g̃a jehe'oi ojihe onhimonha'ngavo hahyrame ojive nehẽ, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Soldados'g̃a nduvihava'ga pe Jesus'ga ei: —Ejivyra'ja ti enhonga pe a'ero. Ererovia hete nde jipopoakara. A'ero ndepyrive'ga nhimohig̃atui kiro, ei Jesus'ga ga pe. A'ea Jesus'ga erame gapyrive'ga nhimohig̃atui a'ero. ");
INSERT INTO pahNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Aerẽ Jesus'ga hoi Simão Pedro'ga ronga pe. Ovahemame ga Pedro'ga rembirekohẽa yhẽa repiagi. Onhino hẽa otetiruano. A'ereki o'a hete hẽa rehe. ");
INSERT INTO pahNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","A'ero ga pokogi hẽapoa rehe. Hẽa hugwi ipigi a'ero. A'ero hẽa vyri reki ogwovo herua mbatera ga pe to'u ga javo. ");
INSERT INTO pahNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Aerẽ kwara ihoi. A'ea rupi g̃a g̃a nderuri Jesus'ga ti tombojipe'a anhag̃a g̃a hugwi javo. A'ero Jesus'ga nhi'ig̃i Diabo'gapyriva'ea pe anhag̃a pe imbojipe'avo g̃a hugwi. Karugwara ga imombimombipavi itetirũave'g̃a hugwi no. ");
INSERT INTO pahNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Opohano ga g̃a. Nahã hekoi Tupana'ga nhi'ĩpo'ruavo ymyahũva'ea po'ruavo. A'ereki a'ea mombe'gwovo ymyahũ Tupana'ga nhi'ig̃a mombe'uharava'ea Isaíasva'ea omombe'u Tupana'ga nhi'ig̃a. Ymyahũ ahe ei hako: “Ga tuhẽ omombi nhanetiruahũa nhande hugwi,” ei ahe hako. ");
INSERT INTO pahNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","He'yjuhuve'g̃a ndepiagame ojipyri Jesus'ga ei g̃wemimbo'ehara'g̃a pe: —He xaho ypiahua aherovai, ei ga. —Kwa, ei g̃a. ");
INSERT INTO pahNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","G̃a horame ypiahu pe judeus'g̃a mbo'ehara'ga ruri Jesus'ga pyri. Ombo'embo'e ga Moisésva'ea remimbo'eagwera rehe jipi. Ovahemame Jesus'ga pyri ga ei Jesus'ga pe: —Ji po ti neremimbo'eharamo nehẽ. Ndehoa nanani po ti ji hoi nde rupi nehẽ, ei ga. ");
INSERT INTO pahNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","A'ero Jesus'ga ei ga pe: —Ereho pota tuhẽ nde ji rupi? ei Jesus'ga. Ja'gwara'java'ea raposas gwyvykoi okwara yvy pe okia ipype. Gwyra'ia ikiri hakã rehe, ei Jesus'ga. Jihi reki, yvyakotyva'ero yvagipeva'ero no, ji ndarekoi jikihava, ei Jesus'ga ga pe. Ehorame ji rupi ji javijitehe po ti nde ndererekoi nehẽ no, ei Jesus'ga ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Jesus'ga remimbo'eharamo ojipe'ga ei Jesus'ga pe: —Orepojykaharetero ko nde, ei ga Jesus'ga pe. Aerẽ po ti ji hoi nde rupi nanani nehẽ. Na ji hoi na'ẽ jipo'ria tyma, ei ga. ");
INSERT INTO pahNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","A'ero Jesus'ga ei reki ga pe: —Terehoi ti pevo. Ji rupi ti ejo. Omanove'g̃a'jave'g̃a – kiroki g̃a noarõi Tupana'ga nhi'ig̃a – g̃a tuhẽ ti totỹ gwe'yja'g̃a, ei Jesus'ga ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Jesus'ga avame yharuhua pype garemimbo'ehara'g̃a hoi ga pohe. ");
INSERT INTO pahNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","G̃a herohorame yvyturanuhũa ruri ojyva ypiahua rehe imohehanhuhũheteavo typepemuhũa. A'ero hehanhuhũ yhya ogwovo yvate okwava yharuhua pyvõ o'ava ipype. Jesus'ga reki oki upa yharuhua pype. ");
INSERT INTO pahNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Kiro garemimbo'ehara'g̃a hoi Jesus'ga pyri ga mongirahiva javo ga pe: —Nhande poko ti! Kiro nhande hoi ypy pe nhandepapava nehẽ! ei g̃a g̃wembipojykaharete'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Oma'eamo ga ei g̃a pe: —Maranameuhũ pe pekyhyjiuhu? Ndapejikogi pe ji rehe naerũ? ei ga g̃a pe. Ovya ga nhi'ig̃i yvyturanuhũa pe typepemuhũa pe no topi ti javo. A'ero yvytua ipigi. Notymynha'javi yhya no. ");
INSERT INTO pahNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","A'ero g̃a nhimomby'ai reki javo. —Marã te ga rekoi naerũ? Yvytua vehevi re po g̃wendu katu ganhi'ig̃a ypiahua pavẽi, ei g̃a. ");
INSERT INTO pahNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Ypiahua aherovai Jesus'ga herohoi g̃wemimbo'ehara'g̃a pavẽi. Gwerovahẽ Jesus'g̃a a'ero ogwovo Gadarapeve'g̃a gwyri pe. Jesus'ga repenhana cidadepeve'g̃a mokonha'g̃a nduri. He'yjuhu anhag̃a Diabo'gapyriva'ea onhimongyavo mokonha'g̃a pojykavo. A'ero mokonha'g̃a iporayvaranuhũi. Ojipe'g̃a ndokwavi pevo g̃a pyvõ okyhyjiavo a'ero. Itaruvihavuhua kwaruhua pytera hugwi aheryvya hugwi g̃a nduri Jesus'ga repenhana kiro. ");
INSERT INTO pahNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Nanime anhag̃a hapukai javo. —Jesus! e'i anhag̃a. Terejori ore avykyavo Tupana'ga ra'yramo, e'i Jesus'ga pe. Nde erejo hahyva'ea imbuhupota ore ve a mbapava koty hahyva'ea mbuhuhava renonde? e'i ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Paivo a'ea hugwi porcos tuvi i'gwovo onhimongyavo. He'yjuhu hete porcos. ");
INSERT INTO pahNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Jesus'ga pe anhag̃a ei: —Po nde ore mbojipe'ai mokonha'g̃a hugwi, a'ero ore mondouka porcos pojykauka ore ve, e'ie'i anhag̃a. ");
INSERT INTO pahNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","—Peho ti a'ero, ei Jesus'ga jupe. Anhag̃a ojipe'a mokonha'g̃a hugwi a'ero ogwovo Jesus'ga nhi'ĩpo'ruavo porcos pojykavo herogwovo. Nanime porcos nhaporemo inhahetei ojyva yvyty'ramuhũa hugwi ogwovo ypiahua pype otypyvygamo omanomo. ");
INSERT INTO pahNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Porcos repiakatuhara'g̃a nhani ogwovo jugwi ogwovo g̃wonga pe nanani cidade pe. Pevo g̃a imombe'upavi nahanahã hekoi anhag̃a rembipojykaagwera'g̃a pe javo. ");
INSERT INTO pahNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Nanime cidadepeve'g̃a ndupavi Jesus'ga repiaga. Ga repiagame g̃a ei ga pe: —Heregwovo oregwyra hugwi! ");
INSERT INTO pahNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","A'ero Jesus'ga hoi ypiahu pe o'ava yharuhua pype tajivyra'ja javo. Ga jivyra'javi a'ero Gadarapeve'g̃a hugwi ua aherovai ovahema ocidade de Cafarnaum me. ");
INSERT INTO pahNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Nanime pevove'g̃a ga reruri itetirũave'ga nomyive'ga gakupeupava pype. G̃a ndepiagame Jesus'ga ei oyvyteri pe: “Ojiko hete g̃a ji rehe ga rerua ji pyri tomopo'ã ti ga ga javo,” ei Jesus'ga oyvyteri pe. —Pi'a, ei Jesus'ga nomyive'ga pe. Ejory ti. A'ereki kiro nderekote'varuhua mombora nde hugwi. A'ea Jesus'ga ei jihi amombo nderekote'varuhua javo. ");
INSERT INTO pahNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Nanime g̃ambo'ehara'g̃a noarõi Jesus'ga ea. “Jesus'ga onhimongouhu Tupana'ga'java'ero,” ei g̃a oyvyteri pe. “A'ereki Jesus'ga e'i nomyive'ga pe: ‘Amombo ji nderekote'varuhua.’ Tupana'ga jate e'i a'ea,” ei g̃a. “Po Jesus'ga nde'i hamo,” ei g̃ambo'ehara'g̃a. ");
INSERT INTO pahNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Jesus'ga ikwahahetei reki g̃a nhi'ig̃ame oyvyteri pe. A'ero ga ei g̃a pe: —Pe'e pe: “Maranameuhũ Jesus'ga euhui a'ea? A'ereki ga Tupana'ga rũi.” Nahã pe pe'e pejiyvyteri pe ite'varuhu Jesus'ga javo. Maranameuhũ pe japyakauhui ji rehe javo ji ve? ");
INSERT INTO pahNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","A'e ji nomyive'ga pe ko: Amombo ji nderekote'varuhua nde hugwi. Emo pe ndapehepiagi aherekote'varuhua mombora. A'ero pe ndaperoviari jipopoakara, ei Jesus'ga g̃a pe. Po ji ei ga pe nehẽ: Epo'ã egwovo, a'ero po ti pe hepiagi gahoa nehẽ. A'ero po ti pe heroviari jipopoakara nehẽ. ");
INSERT INTO pahNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Nurã po ti ji ga mopo'ami kiro tapekwaha ti javo, ei Jesus'ga yvyakotyva'ero yvagipeva'ero no. A'ero po ti pe ei nehẽ: “Tupana'ga ombuhuruka tuhẽ Jesus'ga avo yvya koty ga mongovouka yvyakotyve'g̃a ndekote'varuhua momboharamo,” ei Jesus'ga g̃a pe. Nurã Jesus'ga ei nomyive'ga pe ga monhimohig̃atuavo: —Epo'ã ti ejikupeupava rerogwovo enhonga pe, ei Jesus'ga ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","A'ero nomyive'ga po'ami herogwovo g̃wonga pe. ");
INSERT INTO pahNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","A'ea repiagame g̃a nhimomby'ai Tupana'ga mboheteavo onhimongyavo. —A'ereki Tupana'ga yvyakotyve'g̃a mbopopoaka japouka g̃a pe nanongara ahemonhimomby'ava'ea, ei g̃a. ");
INSERT INTO pahNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Aerẽ ohorame cidade hugwi ogwovo Jesus'ga Mateus'ga repiagi. Pevo Mateus'ga õi itambere'ia ryrua pype ipyhyga itambere'ia judeus'g̃a hugwi imono'og̃a governo pe. Ga repiaga Jesus'ga ei ga pe: —Herejo ti ji rupi ekovo nhiremimbo'eharamo. A'ero Mateus'ga po'ami ogwovo Jesus'ga rupi okovo garemimbo'eharamo. ");
INSERT INTO pahNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Aerẽ Jesus'ga hoi onga pe i'gwovo g̃wemimbo'ehara'g̃a pavẽi. Ga i'urame itambere'ia mono'og̃uhũhara'g̃a nduri i'gwovo ga pyri ojipe'g̃a pavẽi. Judeus'g̃a e'i g̃a pe jipi: “G̃a ko okote'varuhuva'ero hendukatue'yma Moisésva'ea remimbo'eagwera,” ei g̃a. Nanongara'g̃a uhu Jesus'ga pyri i'gwovo. ");
INSERT INTO pahNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","G̃a ndepiagame fariseus'g̃a ndopotari. A'ero g̃a ei Jesus'ga remimbo'ehara'g̃a pe: —Maranameuhũ pembo'ehara'ga i'uuhui nanongara'g̃a pyri itambere'ia mono'õhara'g̃a pyri okote'varuhuve'g̃a pyri no? ei g̃a. ");
INSERT INTO pahNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Henduvame Jesus'ga ei: —Kiroki g̃a e'i ojive: “Nanhitetirũi ji” – g̃ahã ahepohanohara'ga ndopokogi g̃a pohanog̃e'yma. Kiroki g̃a e'i ojive: “Nhitetirũa ji” – g̃ahã ahepohanohara'ga g̃a pokogi g̃a pohanog̃a. Na jitehe ji okote'varuhuve'g̃a pokogi jijihe'a g̃a ndehe topohi ti g̃a okote'varuhua hugwi javo, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Ymyahũ Tupana'ga ei hako: “Peru pe mbatepyryva tokwava'ẽ ti ikwava'ẽhara'g̃a Tupana'ga pe javo. A'ea ji ei pe me novĩa. Emo koji'i ji apota penemimombyryva ojipe'g̃a pe,” ei Tupana'ga hako, ei Jesus'ga. —Peho ti penhimbo'eavo a'ea rehe Tupana'ga ea rehe ikwahakatuavo, ei Jesus'ga g̃a pe. Ajo ji yvya koty tapoko ti ji okote'varuhuve'g̃a javo – kiroki g̃a e'i: “Ako te'varuhu ji. Marã po ti ji ve a'ero nehẽ?” Ta'e ti ji g̃a pe toko katu ti g̃a javo. Ojipe'g̃a pyri rũi ji ajo javo – kiroki g̃a e'i ojive: “Jipyry hete ji.” G̃a pyri rũi ji jori javo g̃a pe, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Aerẽ João Batistava'ea remimbo'ehara'g̃a nduri Jesus'ga pyri. Ovahemame g̃a ei ga pe: —Nane'ymi fariseus'g̃a ja ore ndoro'ui xanhi'ĩ ti Tupana'ga pe javo. Neremimbo'ehara'g̃a ki a'e te nane'ymi o'u reki. Maraname ore ja rũi g̃a ndekoi? ei g̃a Jesus'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","A'ero Jesus'ga ei ikwahavuka g̃a pe: —Kiro ji hẽarembirekoruama'ga mombe'ui pe me, ei Jesus'ga. Uhu hẽarembirekohava apiavo. A'ero g̃a i'ui gworygworyvamo ga rehe okovo ga pyri toryva rupi – kiroki g̃a ojikoty'a ga pavẽi. Po ahe nde'i te g̃a pe a'ero: “Pejehe'o ti.” Ahe erame a'ea po g̃a ndokoi ahenhi'ig̃a rupi, ei Jesus'ga. Aerẽ po ti tiruahũve'g̃a hẽarembireko'ga rerohoi nehẽ. Kiroki g̃a ojikoty'a ga pavẽi – g̃a hugwi po ti g̃a ga rerohoi nehẽ. A'ero po ti g̃a ndo'ua'javi ojehe'gwovo nehẽ. A'ea Jesus'ga ei ikwahavuka g̃a pe onhimombe'gwovo g̃wemimbo'ehara'g̃a mombe'gwovo no. ");
INSERT INTO pahNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","—Po ahe oapokatua'ja pota tapy'ynhapirymyana tararaga, a'ero itararaga rehe ahe nomondoi tapy'ynhapirapyahua ndotyryrygiva'ea imboja hehe, ei Jesus'ga. Po ahe ipyahuva'ea imbojari ymyahũva'ea rehe, a'ero ipyahuva'ea jikyi ymyahũva'ea hugwi koji'i imbotararaga ymyahũva'ea. Igwaigwavete imohehãi ikwara ymyahũva'ea pype a'ero, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Na jitehe vinho aporame ahe ndoheka'vogi vinhopyahua hyruymyana pype mbiara pirymyana pype, ei Jesus'ga. Po ahe heka'vogi vinhopyahua ipirymyana pype, a'ero ipirymyana ipugi. A'ero vinho tururui jugwi. Nahã ahe jigwarai ipirymyana rehe no, ei Jesus'ga. Ipipyahua pype tuhẽ ahe toheka'vo vinhopyahua. Nahã ahe gwereko katu vinho ipira reheve. A'ea Jesus'ga omombe'u nhiremimbo'ea ipyahuva'ea ndojihe'ari g̃anamonhava'ea remimbo'eagwera rehe javo. ");
INSERT INTO pahNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Jesus'ga a'ea mombe'urame g̃a pe nanime huvihava'ga ruri Jesus'ga pyri g̃wenypy'anduruga jihoheva'ero ji poko javo. —Jira'yrahẽa omano ko, ei ga Jesus'ga pe. Herejo epokoga hẽa rehe. A'ero po ti hẽa kwerava'javi nehẽ, ei ga Jesus'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","—Kwa, ei Jesus'ga. Kiro Jesus'ga po'ami ogwovo ga rupi. Jesus'ga remimbo'ehara'g̃a hoi ga rupi no. ");
INSERT INTO pahNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Nanime hẽa ruri ga reviri no itetirũavehẽa gwypovehẽa. He'yi doze anos hẽatetirũa imbokwara'ari hẽa rehe opige'yma hẽa hugwi. A'ero hẽa ruri Jesus'ga reviri opokoga gatapy'ynhapira rembeyvyra rehe. ");
INSERT INTO pahNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","A'ereki hẽa e'i oyvyteri pe: “Po ti ji pokogi jitehe gatapy'ynhapira rehe, a'ero po ti nhitetirũa ipigi ji hugwi nehẽ,” ei hẽa. ");
INSERT INTO pahNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","A'ero Jesus'ga pyryrymi reki. Hẽa repiagame ga ei hẽa pe: —Kui'i, ei ga hẽa pe. Ejory ti! Erejiko nde ji rehe. Nurã netetirũa pigi nde hugwi, ei ga. A'ea rupi hẽa nhimohig̃atui. ");
INSERT INTO pahNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Kiro huvihava'ga ronga pe Jesus'ga hoi ogwovo tahepia ti gara'yrahẽa javo. Ovahemame ga imonhi'ĩhara'g̃a ndepiagi – kiroki g̃a omonhi'ĩ jiru'a ahe manorame. He'yive'g̃a ga g̃a ndepiagi no. Hahyahi g̃ajehe'ohetea. ");
INSERT INTO pahNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","G̃a pe nhaporemo Jesus'ga ei: —He pejigwovo! A'ereki tayrihẽa nomanoi. Oki hẽa upa, ei ga. A'ero g̃a ga jai ga rerekovo ga rerekomemuamo ki a'e te ahe omano hete javo. ");
INSERT INTO pahNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","G̃a mbojipe'avo ga g̃a mondoi. Okirame onga pype ga kujahẽa popyhygi. A'ero hẽa kweravi opo'ama. ");
INSERT INTO pahNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ombojoapiapi g̃a hẽa mombe'gwombe'gwovo Jesus'ga reheve ojipe'g̃a pe. G̃agwyripeve'g̃a nhaporemo ikwahavi a'ero hẽambogwerava. ");
INSERT INTO pahNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Jesus'ga horame onga hugwi ogwovo heakwagweve'g̃a hoi ga reviri mokonha'g̃a. Hahyahi g̃anhi'ig̃a g̃a erame ohapukaita: —Daviva'ea rymyminouhũro ko nde! ei g̃a. Nahã g̃a ei Jesus'ga pe. A'ereki g̃a e'i oyvyteri pe: “Jesus'ga pe Tupana'ga e'i eko ti g̃anduvihavuhuhetero javo.” —Ore poko ti! ei g̃a Jesus'ga pe. A'ea g̃a ei tianemboheakwa katu ti ga opopoakara pyvõ javo. ");
INSERT INTO pahNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Ga kirame onga pe g̃a nduri ovahema ga pyri. G̃a pe Jesus'ga ei: —Marã? Perovia pe nhiremimboheakwakatuag̃wama? ei Jesus'ga. A'ero g̃a ei ga pe: —Orepojykaharetero ko nde, ei g̃a. Orogwerovia ore. ");
INSERT INTO pahNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","A'ero ga pokogi g̃andeakwara rehe javo. —Pejiko pe ji rehe. Nurã pe ndeakwakaturo, ei ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","G̃andeakwara ma'eg̃atui a'ero. A'ero Jesus'ga ei g̃a pe: —Ji rendu katu ti. Tapemombe'ui ti nhiremimboheakwakatua. Ndapotahetei ji a'ea mombe'ua, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ombojoapiapi g̃a reki imombe'gwombe'gwovo ogwyripeve'g̃a pe nhaporemo nahã Jesus'ga ore mboheakwa katu javo. ");
INSERT INTO pahNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","G̃a horame onga hugwi ojipe'g̃a onhi'ig̃e'ỹve'ga reruri Jesus'ga pyri. Tegwete ganhi'ĩhava anhag̃a ga pojykaro g̃waramo Diabo'gapyriva'ea. ");
INSERT INTO pahNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Jesus'ga anhag̃a mbojipe'ai ga hugwi. Nurã onhi'ig̃e'ỹve'ga nhi'ig̃i. A'ero pevove'g̃a nhimomby'ai onhimongyavo. —Ndihepiangavi koi nhande g̃wihã jipi nhandegwyri pe Israel pe, ei g̃a. ");
INSERT INTO pahNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Fariseus'g̃a e'i reki: —Anhag̃a ruvihavuhu'ga Diabo'ga Jesus'ga pojyka ga mbopopoaka. Nurã Jesus'ga anhag̃a mbojipe'ai g̃a hugwi g̃a mondovouka, ei g̃a o'mbero. ");
INSERT INTO pahNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Aerẽ Jesus'ga imbojoapiapi cidades repiaga cidades'ia repiaga no. G̃a mbo'eavo Tupana'ga nhi'ig̃a rehe ga hogahoi g̃ajatykahai pe. Pyryva'ea ga imombe'ui Tupana'ga pe poko katu pota okovo pota penduvihavuhuhetero javo. —Perojijyjijyjuka ti pejeaporog̃ita Tupana'ga pe pejikoga ga rehe. A'ero po ti ga pe pokokatui nehẽ imomboa pendekote'varuhua pe hugwi okovo penduvihavuhuhetero nehẽ, ei Jesus'ga g̃a pe. Karugwara Jesus'ga imombipavi itetirũave'g̃a hugwi. Ipopoakare'ỹve'g̃a ga g̃a mbopopoakapavi no. Nahã ga rekorekoi g̃apyteri pe. ");
INSERT INTO pahNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Ojatykave'g̃a ndepiagame Jesus'ga g̃a porogwetygi. A'ereki g̃a he'ouhũ onhimongyavo tiruahũro g̃waramo ojive. Ndipokohavi g̃a no. Nahanahã g̃a ndekoi ovelhas ja – kiroki ovelhas ndogwerekoi gwepiakatuhara'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","A'ero Jesus'ga ei g̃wemimbo'ehara'g̃a pe: —G̃a ko koapora ja g̃anemimondorog̃werĩva'ea ja. He'yi hete koapora gworygworyvamo. Imondorove'g̃a ndohygi reki hehe. A'ereki g̃a ndahe'yi. A'ero ahe ei koapora jara'ga pe: “Koji'i jitehe ti embuhurukara'ja g̃a pyri imondorove'g̃a imondoroguka ko pe.” A'ea ahe ei koapora jara'ga pe, ei Jesus'ga. —Na jitehe avove'g̃a koapora ja. A'ereki g̃a he'yjuhu ranuhũ. Ndahe'yi reki imondorove'g̃a'jave'g̃a – kiroki g̃a oporavyky imombe'gwovo Tupana'ga nhi'ig̃a g̃a pe tojiko ti g̃a Tupana'ga rehe javo, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Pe'ji ti Tupana'ga pe a'ero. Gaha ko koapora jara'ga ja. Pe'ji ti ga pe: “Koji'i jitehe ti embuhurukara'ja g̃a pyri ejiheve'g̃a. Tomombe'u ti g̃a nenhi'ig̃a he'yjuhuve'g̃a pe tojiko ti g̃a Tupana'ga rehe javo. A'ero po ti g̃a ndekoi upa avuirama nde pyri nehẽ.” A'ea ti pe'ji Tupana'ga pe, ei Jesus'ga g̃wemimbo'ehara'g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","G̃wemimbo'ehara'g̃a dozeve'g̃a mbuhurukarame ojipyri, kiro Jesus'ga g̃a mbopopoakari tombojipe'a ti g̃a anhag̃a ojipe'g̃a hugwi javo. Kiro ga g̃a mbopopoakari tokwaha pa ti g̃a karugwara imombiga itetirũave'g̃a hugwi javo. Kiro ga g̃a mbopopoakari tokwaha pa ti g̃a ipopoakare'ỹve'g̃a mbopopoaka javo. ");
INSERT INTO pahNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Dozeve'g̃a ko Jesus'ga remimbo'ehara'g̃a gamoirũhara'g̃a. G̃a ko nahã: Mokonha'g̃a ko Simão'ga André'ga pavẽi onhoirũ'g̃a. Pedro irũa Simão'ga rera. Ga ko Jesus'ga moirũhara'ga ypy. Mokonha'g̃a ko Tiagova'ea João'ga pavẽi onhoirũ'g̃a. G̃a ko Zebedeu'ga ra'yra'g̃a. ");
INSERT INTO pahNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Mokonha'g̃a ko Filipe'ga Bartolomeu'ga pavẽi. Mokonha'g̃a ko Tomé'ga Mateus'ga pavẽi. Mateus'ga ko itambere'ia mono'õharagwera'ga governo pe. Mokonha'g̃a ko Tiago'ga Tadeu'ga pavẽi. Tiago'ga ko Alfeu'ga ra'yra'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Mokonha'g̃a ko Simão'ga Judas Iscariotesva'ea pavẽi. Simão'ga ko zelotes'g̃a nde'yja'ga – kiroki g̃a ndokoi governo rehe romanos'g̃a ndehe. Judas Iscariotesva'ea aerẽ Jesus'ga mondouka okote'varuhuve'g̃a pe ga pyhyguka g̃a pe. Nahã ko dozeve'g̃a nhaporemo Jesus'ga remimbo'ehara'g̃a gamoirũhara'g̃a. ");
INSERT INTO pahNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","G̃ahã dozeve'g̃a Jesus'ga g̃a mondoukari tomombe'u ti g̃a Tupana'ga nhi'ig̃a javo. G̃a mondoukarame ga ei g̃a pe: —Tapehoi ti nhandere'yja'g̃arũive'g̃a cidades pe judeus'g̃arũive'g̃a cidades pe, ei Jesus'ga. Tapehoi ti pevo. Tapehoi ti samaritanos'g̃a cidades pe no, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","—Nhandere'yja'g̃a pyri jate israelitas'g̃a pyri jate ti peho. G̃a ko ovelhas ja. Ovelhas oka'nhy jipi herekoe'ymame gwepiakatuharamo. Akoja ja ko nhandere'yja'g̃a ika'nhyva'ea ja, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Pehorame g̃a pyri ti pemombe'u katu g̃a pe. Pe'ji ti g̃a pe: “Tupana'ga oko g̃werĩ nhanderuvihavuhuhetero nhande repiakatuavo yvya koty nhande mongovo onhi'ig̃a rupi.” A'ea ti pe'ji g̃a pe, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Pemombi ti karugwara itetirũave'g̃a hugwi. Pemoka'ẽ ti g̃ajagwa ijaijauhuve'g̃a hugwi. Pembogwera ti omanove'g̃a g̃amanoa hugwi. Pembojipe'a ti Diabo'gapyriva'ea anhag̃a ojipe'g̃a hugwi. Nahanahã ti pepokopoko nhandere'yja'g̃a. —Ji pe mbopopoaka topoko ti g̃a g̃a javo, ei Jesus'ga. Ji nda'ei pe me: Opombopopoaka ji ko. Nurã ti pembuhu ji ve itambere'ia mbatera reheve. A'ea rũi ji a'e pe me, ei Jesus'ga g̃wemimbo'ehara'g̃a pe. A'ero g̃a pokogame ti tape'ei g̃a pe: “Pembuhu ore ve itambere'ia mbatera reheve.” A'ea rũi ti pe'ji, ei Jesus'ga g̃wemimbo'ehara'g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","—Taperohoi ti itambere'ia pehorame, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Taperohoi ti sacola pehorame. Taperohoi ti irũa tapy'ynhapira camisa'java'ea. Taperohoi ti irũa sapatos. Taperohoi ti yvyra pejikohavamo. A'ea nhaporemo ti taperohoi. Pevove'g̃a po pe poraka pe pokoga hamo, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","—Pevahemame g̃acidades pe g̃acidades'i pe no pe'ji ti cidadespeve'g̃a pe: “Ma'g̃a pyry avova'ero? Ga pyri ore pytapotari.” A'ea ti pe'ji. Pyryve'ga repiagame ti peju ga pyri jate pejijyje'yma garonga hugwi. Aerẽ po ti pe hoi ojipe pe cidade pe nehẽ. A'ero jate ti pejijyi garonga hugwi pejigwovo a'ero nehẽ, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Pepytarame g̃anonga pype ti pe'ji ongapypeve'g̃a pe pendoryvamo g̃a ndehe. Pe'ji ti g̃a pe: “Tu katu ti pepy'a!” A'ea ti pe'ji g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Po g̃a pyryvamo, a'ero po ti g̃apy'a rukatui tuhẽ nehẽ. —Po g̃a ndapyryvi, a'ero ti pe'ji g̃a pe: “A'e tehe ji pe me pepy'a ti tu katu javo.” A'ea ti pe'ji g̃a pe tukatuyme ti g̃apy'a javo, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Po ongapypeve'g̃a ndohoryvi pe ndehe tapepytai ore pyri javo, a'ero ti tapepytai g̃anonga pype. Po g̃a nohendupotari pe imombe'urame Tupana'ga nhi'ig̃a g̃a pe, a'ero ti tapepytai g̃anonga pype, ei Jesus'ga. —Na jitehe ti tapepytai cidade pe g̃a ndoryve'ymame pe ndehe hendupotare'yma Tupana'ga nhi'ig̃a, ei Jesus'ga. Pehorame g̃a hugwi pemonduru ti otimbuguhua pejipya hugwi oropohi ore pe hugwi javo, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Imombe'ukatuavo ji ei pe me: Aerẽ mbapava koty po ti g̃a hepiagi hahyva'ea ojihe Tupana'ga omanove'g̃a mono'ombavame g̃a ndeheve nehẽ. G̃a mono'ombavame po ti ga ei g̃a pe nhaporemo nehẽ peko te'varuhu pe javo. A'ereki g̃a nohendukatupotari ganhi'ig̃a. Koji'i po ti hahy g̃a pe Sodomapeve'g̃a hohe Gomorrapeve'g̃a hohe no, ei Jesus'ga g̃wemimbo'ehara'g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","—Ji rendu ti, ei Jesus'ga g̃wemimbo'ehara'g̃a pe. Kiro po ti ji pe mondoi okote'varuhuve'g̃a pyteri pe. Peko po ti pe ovelhas ja ipopoakare'ỹva'ea ja pejigwovo g̃apyteri pe nehẽ. Onharõ ja'gwara'java'ea lobos ovelhas pyhyga otiruahũro jupe. Na jitehe po ti okote'varuhuve'g̃a tiruahũro pe me nehẽ, ei Jesus'ga g̃a pe. Nurã po ti mboja ja penhimboko'i hete ikwahaheteavo penhimombaragwahava g̃a ndehe nhaneirũa rũi ko g̃a javo. Inambua nomondoi hahyva'ea nhande ve. Inambua ja ti tapemondoi hahyva'ea ojipe'g̃a pe. Peko katu katu ti ojipe'g̃a pe, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","—Penhimboko'i ti okote'varuhuve'g̃a hugwi pejikovo. A'ero po ti g̃a pe pyhygi pe nderohoahyavo imohig̃atuhara'g̃a ndovai pyteri pe ojatykahai pe nehẽ. Pevo po ti g̃a pe nupanupãi yvyra pyvõ, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Governador'g̃a ndovai pyteri pe po ti g̃a pe nderohoukari gwuvihavuhu'g̃a ndovai pyteri pe no. G̃andovai pyteri pe po ti g̃a pe nderohoukari nehẽ timboja tehe ti g̃a ndehe javo. Nahã po ti g̃a ndekote'varuhui pe me nehẽ pendekoro g̃waramo jireheva'ero, ei Jesus'ga. A'ea rupi po ti pe ji mombe'ukatui g̃a pe judeus'g̃arũive'g̃a pe nhaporemo tojiko ti g̃a Jesus'ga rehe javo, ei Jesus'ga g̃wemimbo'ehara'g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","—G̃a pe nderohoukarame g̃andovai pyteri pe ti tape'ei na'ẽ pejiyvyteri pe: “Maramarã po ti nhande nhi'ig̃i g̃a pe nehẽ? Gara po ti nhande ei g̃a pe nehẽ?” A'ea ti tape'ei pejivy'are'yma, ei Jesus'ga g̃a pe. G̃a pe nderohoukarame g̃andovai pyteri pe po ti Tupana'ga penduvete'ga okwahaheteuka pe me nehẽ nahanahã ti pe'ji g̃a pe javo. ");
INSERT INTO pahNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Hehe po ti gara'uva pe monhi'ig̃uka pe mbo'eavo nehẽ. Nurã po ti penhi'ig̃a rũi pe imombe'ui g̃a pe nehẽ, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Aerẽ po ti peirũ'g̃a pe nderohoahyukari gwuvihava'g̃a pe nehẽ tojuka ti g̃a g̃a javo. Penduva'g̃a no, g̃a po ti pe nderohoahyukari gwuvihava'g̃a pe nehẽ no tojuka ti g̃a g̃a javo. Penda'yra'g̃a vehevi po ti napearõa'javi pe nderohoahyuka gwuvihava'g̃a pe nehẽ no tojuka ti g̃a g̃a javo, ei Jesus'ga g̃wemimbo'ehara'g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","G̃a nhaporemo po ti oko pa pe ndehe pe arõe'ỹheteavo pejikoga g̃waramo ji rehe. Po ti pe nhimboitai avuirama pepohire'yma ji hugwi, a'ero po ti ji pe nderohoi yvagi pe pe mongovo avuirama jijipyri nehẽ, ei Jesus'ga g̃wemimbo'ehara'g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","—G̃a ndekote'varuhurame pe me ti penhiminhimi g̃a hugwi. Pejijyjijyi ti pejigwovo ojipejipe pe cidades pe. A'ero he'yjuhuva'e pe cidades pe po ti pe hoi ji mombe'gwovo g̃a pe nehẽ, ei Jesus'ga. Pehoa renonde cidades pe nhaporemo Israelpeve'g̃a gwyri pe po ti ji ajora'ja yvya koty yvyakotyva'ero yvagipeva'ero nehẽ, a'e ji pe me imombe'ukatuavo, ei Jesus'ga g̃wemimbo'ehara'g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","—A'e ji kiro pe me: G̃ambo'ehara'ga koji'i garemimbo'ehara'g̃a hohe, ei ga. Na jitehe g̃apojykahara'ga koji'i gapyrive'g̃a hohe, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Po g̃a jigwarai g̃ambo'ehara'ga rehe, a'ero po na jitehe g̃a jigwarai garemimbo'ehara'g̃a ndehe no. A'ero po a'ea pyry garemimbo'ehara'g̃a pe hamo, ei Jesus'ga. G̃a erame Belzebu onga jara'ga pe g̃a ete'varuhui ga pe ojigwaraita ga rehe. A'ereki Belzebu irũa Diabo'ga rera. Po g̃a ei Belzebu onga jara'ga pe, a'ero koji'i po ti g̃a ete'varuhui garongapypeve'g̃a pe gapyrive'g̃a pe ojigwaraita g̃a ndehe nehẽ, ei Jesus'ga g̃wemimbo'ehara'g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","—Tapekyhyji ti g̃a hugwi, ei Jesus'ga. A'ereki ji a'e pe me: Tupana'ga po ti imboukwahavi onhimiva'ea hepiuka ikwahavuka henduvukapava nehẽ, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","—Kiroki a'ea ji amombe'u ypytunimo pe me – a'ea ti pemombe'u arimo ojipe'g̃a pe nehẽ, ei Jesus'ga. A'ea ji ei javo: Kiroki a'ea ji amombe'u nhimi pe me – a'ea jitehe ti pemombe'u g̃andovaki tohendu pa ti g̃a javo, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","—Tapekyhyji ti pejukapotave'g̃a hugwi. Pe jukarẽ tegwete pemondohavag̃wama hahyva'ea ruvihava pype, ei Jesus'ga. Tupana'ga hugwi ti pekyhyji. Gaha ipopoaka hete ahe jukavo ahe momboa tata pype hahyva'ea ruvihava pype ipotarame, ei Jesus'ga g̃wemimbo'ehara'g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","—Maramomi itambere'ia gwyra'ia rehe? Ndahe'yi po hehe. Dois rehe gwyra'ia rehe po ojipeji'i jate itambere'ia. Tupana'ga gwepia katu gwyra'ia penduvete'ga. Ga ipotare'ymame gwyra'ia ndohiri'i'i. Ga ipotarame jate gwyra'ia ihiri yvyvo omanomo, ei Jesus'ga g̃wemimbo'ehara'g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","—Koji'i hete reki Tupana'ga pe ndepiakatui. A'ereki ga okwaha jitehe reki pe'ava nhaporemo he'yjuhuva'ea. Okwaha pa ga pe'ava nhaporemo he'yje'ỹva'ea. Nahã ga pe kwahahetei pe ndepiakatuavo. ");
INSERT INTO pahNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Tapekyhyji ti a'ero. A'ereki Tupana'ga e'i pe me: “Ahepia katu ji gwyra'ia he'yjuhuva'ea. Koji'i ji rekoi pe ndehe pe ndepiakatuavo,” ei Tupana'ga, ei Jesus'ga g̃wemimbo'ehara'g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","—E'i po ahe ji mombe'gwovo a'ero, ei Jesus'ga. “Ajiko ji Jesus Cristo'ga rehe. Ga oko jipojykaharetero.” A'ea po ahe ei ojipe'g̃a pe hamo. Po nahã ahe ji mombe'ui, a'ero po ti ji ahe mombe'ui jiruva'ga pe yvagipeve'ga pe nehẽ g̃a ko jireheva'ero javo ga pe nehẽ, ei Jesus'ga g̃wemimbo'ehara'g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","—E'i po ojipe'g̃a ji mombe'gwovo: “Ndajikogi ji Jesus Cristo'ga rehe. Ga ndokoi jipojykaharetero.” A'ea po g̃a ei ojipe'g̃a pe. Po nahã g̃a ji mombe'ui, a'ero po ti ji g̃a mombe'ui jiruva'ga pe yvagipeve'ga pe nehẽ g̃a ndokoi jireheva'ero javo ga pe nehẽ, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","—Marãi pe ji mombe'gwovo? ei Jesus'ga g̃wemimbo'ehara'g̃a pe. “Jesus'ga rura g̃waramo po ti yvyakotyve'g̃a py'a rukatui nehẽ.” Nahã po pe ei pejiyvyteri pe naerũ? Tape'ei ti a'ea. Jirura g̃waramo po ti g̃apy'a ndukatui nehẽ. Ojogwayva po ti g̃a ji rehe nehẽ, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Ojipe'g̃a po ti ji arõhetei nehẽ. Ojipe'g̃a po ti nanhiarõi nehẽ. Nurã po ti g̃a jogwayvari ji rehe nehẽ. “Akwaimbae'g̃a po ti gwayva uva'g̃a nehẽ. Kunhangwera'g̃a po ti gwayva oy'g̃a nehẽ. Kunhangwera'g̃a po ti gwayva g̃wembireko'g̃a y'g̃a nehẽ. ");
INSERT INTO pahNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ongapypeve'g̃a po ti nonhoarõhetei nehẽ,” ei Jesus'ga g̃wemimbo'ehara'g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","—Kiroki g̃a oarõ hete uva'g̃a nhiarõa hohe – g̃ahã ti tokoyme nhiremimbo'eharamo. A'ereki nanongara'g̃a ndapyryvi. Kiroki g̃a oarõ hete oy'g̃a nhiarõa hohe – g̃ahã ti tokoyme nhiremimbo'eharamo no, ei Jesus'ga. A'ereki nanongara'g̃a ndapyryvi. Kiroki g̃a oarõ hete gwa'ykwaimbe'g̃a nhiarõa hohe – g̃ahã ti tokoyme nhiremimbo'eharamo, ei Jesus'ga. A'ereki nanongara'g̃a ndapyryvi. Kiroki g̃a oarõ hete gwa'ykunha'g̃a nhiarõa hohe – g̃ahã ti tokoyme nhiremimbo'eharamo no. A'ereki nanongara'g̃a ndapyryvi. A'ea Jesus'ga ei g̃wemimbo'ehara'g̃a pe koji'i ti g̃a tanhiarõ hete javo. ");
INSERT INTO pahNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","—Kiroki g̃a oko pota nhiremimbo'eharamo – po ti ojipe'g̃a imbohahyukari g̃a pe g̃a jukavo vehevi nehẽ peko pe Jesus'ga reheva'ero javo g̃a pe, toko jitehe ti g̃a nhiremimbotarimova'ea rehe opohire'yma ji hugwi. Okoe'ymame nhiremimbotarimova'ea rehe, g̃a ti tokoyme nhiremimbo'eharamo nehẽ. A'ereki nanongara'g̃a ndapyryvi, ei Jesus'ga g̃wemimbo'ehara'g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","—Kiroki g̃a ndokopotari nhiremimbo'eharamo tajijukayme ti g̃a javo – g̃a po ti omano ogwovo hahyva'ea ruvihava pype nehẽ, ei Jesus'ga. —Kiroki g̃a ojipe'g̃a g̃a jukai g̃a jikoga g̃waramo ji rehe – omanorẽ po ti g̃a oho upa avuirama Tupana'ga pyri nehẽ, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","—Kiroki g̃a horyory pe ndehe g̃a ko Jesus'gareheva'ero javo – g̃a ndoryndoryvamo ji rehe reki, ei Jesus'ga. Kiroki g̃a horyory ji rehe nde ko Tupana'ga repykaramo javo – g̃a ndoryndoryvamo nhimbuhurukara'ga rehe reki, ei Jesus'ga g̃wemimbo'ehara'g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","—Po Tupana'ga nhi'ig̃a mombe'uhara'ga ruri g̃a pyri. Po g̃a ndoryndoryvamo ga rehe ga ko omombe'u Tupana'ga nhi'ig̃a javo, a'ero po ti g̃a pe Tupana'ga imondoi ikwepykava nehẽ. Nanongara jitehe po ti Tupana'ga imondoi ikwepykavamo g̃a pe nehẽ – kiroki ikwepykava Tupana'ga omondo onhi'ig̃a mombe'uhara'ga pe no, ei Jesus'ga. Kiroki g̃a horyory pyryve'ga rehe ga ko oko Tupana'ga nhi'ig̃a rupi javo – g̃a pe po ti Tupana'ga imondoi ikwepykava nehẽ. Nanongara jitehe po ti Tupana'ga imondoi ikwepykavamo g̃a pe nehẽ – kiroki ikwepykava Tupana'ga omondo pyryve'ga pe no, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","—Imombe'ukatuavo ji ei pe me: Po g̃a omondo yhya vehevi iroyxag̃ahiva'ea ipyahuve'ga pe nhiremimbo'ehara'ga pe to'u ti ga javo. Po g̃a imondoi ga pe ga ko oko Jesus'ga remimbo'eharamo javo – g̃a pe po ti Tupana'ga ikwepykava imondoi a a'ero nehẽ, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Aerẽ g̃wemimbo'ehara'g̃a mbo'epavirẽ dozeve'g̃a mbo'epavirẽ Jesus'ga hoi. Imbojoapiapiavo ga hoi cidades pe pevove'g̃a mbo'embo'eavo Tupana'ga nhi'ig̃a rehe imombe'ukatuavo g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","3","A'ea rupi João Batistava'ea rekoi cadeia pype a'itituhẽva'ea mombe'ua rehe. Okwaha ahe Cristo'ga rembiapoa garemimonhimomby'ava'ea. A'ea kwahavame João Batistava'ea ei g̃wemimbo'ehara'g̃a pe mokonha'g̃a pe: —Peho ti Jesus'ga pyri. Pe'ji ti ga pe: “Ymyahũ Tupana'ga nhi'ig̃a mombe'uharava'ea e'i: ‘Aerẽ po ti Tupana'ga remimbuhurukara'ga ruri nhande pyri nehẽ.’ Nahã ahe ei. Ma'g̃a po ymyahũ ahe omombe'u? Mara'ngu po ndehe? Mara'ngu po ojipe'ga? Nahã ore ei aheremimombe'uhara'ga rura pota ga mbuhua.” A'ea mombe'gwovo katu ti pe'ji Jesus'ga pe: “Marãi nde a'ero?” ei João Batistava'ea mokonha'g̃a pe g̃wemimbo'ehara'g̃a pe. —Kwa, ei g̃a. A'ero g̃a hoi ogwovo Jesus'ga pyri ovahema. João Batistava'ea nhi'ig̃agwera g̃a imombe'ui Jesus'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Henduvirẽ Jesus'ga ei mokonha'g̃a pe João Batistava'ea remimbo'ehara'g̃a pe: —Pejivyra'ja ti pejigwovo João Batista'ga pyri. Pemombe'u ti ga pe penhimbiepiaga penhimienduva. Pe'ji ti ga pe imombe'gwovo: ");
INSERT INTO pahNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","“Oma'eg̃atu kiro heakwagweve'g̃a okovo. Opo'ag̃atu kiro ipyka'naka'nauhũve'g̃a ogwovo katu. Oka'ẽ g̃ajagwa ijaijauhuve'g̃a hugwi. G̃wendu katu kiro japyakware'ỹve'g̃a okovo. Okwera kiro omanove'g̃a okovo. Imbatere'ỹve'g̃a g̃wendu kiro pyryva'ea Jesus Cristo'ga mombe'ua.” A'ea nhaporemo ti pemombe'u João Batista'ga pe, ei Jesus'ga. A'ea Jesus'ga ei ikwahavuka ga pe Jesus'ga ko Tupana'ga remimbuhurukara'ga javo aheremimombe'uhara'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","“Pyry hete ga pe – kiroki ga ndojikopigi ji rehe.” Nahã ti pe'ji João Batista'ga pe, ei Jesus'ga mokonha'g̃a pe João Batistava'ea remimbo'ehara'g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","A'ero g̃a hoi javo katu João Batistava'ea pe. G̃a horame Jesus'ga ei pevove'g̃a pe he'yjuhuve'g̃a pe João Batistava'ea mombe'gwovo. G̃a pe ga ei: —Ymya'ĩ pe peho ongae'ỹi me. Pevo pe pehepia João Batista'ga. Marãi pe pejiyvyteri pe pea rupi pejigwovo garepiaga renonde? Pe'e po pe: “Xaho hepiaga nhungwava – kiroki okooko'iuhu yvytua remimbotarimova'ea rehe onhimbovavaguka yvytua pe.” Pe ndape'ei tuhẽ reki a'ea. A'ereki João Batista'ga ko nhungwava ja rũi. Ga ndokondoko'iuhui ojipe'g̃a remimbotarimova'ea rehe. Ga ko onhimboita Tupana'ga rehe, ei Jesus'ga pevove'g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","—Marãi pe a'ero pejiyvyteri pe garepiaga renonde? Pe'e po pe: “Xaho ga repiaga – kiroki ga omongi tapy'ynhapipyryva. Gweroho pa po itambere'ia gapira.” A'ea pe ndape'ei oji'i, ei Jesus'ga. A'ereki João Batista'ga ndokohetei mbatera rehe. Ji rendu ti! João Batista'ga nomongi tapy'ynhapipyryva. Kiroki g̃a omongi pyryheteva'ea – g̃ahã u huvihavuhu'g̃a nonga pype. ");
INSERT INTO pahNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","—Marãi pe a'ero pejiyvyteri pe? Pe'e po pe: “Xaho Tupana'ga nhi'ig̃a mombe'uhara'ga repiaga.” A'ea pe ekatui, ei Jesus'ga. Kiro ji ei pe me: João Batista'ga ko Tupana'ga nhi'ig̃a mombe'uhara'ga tuhẽ. Tupana'ga nhi'ig̃a mombe'uhara'ga jate rũi ko ga, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","—Ymyahũ Tupana'ga okwatijaruka ahe ve João Batista'ga mombe'gwovo hako ga po ti nhinhi'ig̃a mombe'ui nehẽ javo, ei Jesus'ga. Aherembikwatijara e'i: “Nahã Tupana'ga ei Cristo'ga pe: ‘Ji rendu ti! Nde renonde ti ji ga mondoi imombe'uuka nhinhi'ig̃a nehẽ. Tomboavujikwe ti ga nderura renonde,’ ei Tupana'ga,” e'i aherembikwatijara, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","—Imombe'ukatuavo ji ei pe me: João Batista'ga ko koji'i huvihava ymyahũva'ea hohe pa, ei Jesus'ga. Ag̃wamo turi Tupana'ga rembiepiakatuhava apiavo. Ag̃wamo po ti Tupana'ga he'yjuhuve'g̃a nduvihavuhuhete'ga nehẽ, ei Jesus'ga. A'ero ji ei: Ymyahũva'ea hohe pa João Batista'ga koji'i huvihava. Ag̃wamove'g̃a ki a'e te Tupana'ga rembiepiakatuhara'g̃a ko koji'i huvihava João Batista'ga hohe. Kiroki g̃apyteripeve'g̃a huvihava rũi – g̃a vehevi koji'i huvihava João Batista'ga hohe, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","—João Batista'ga g̃a mbo'eypyagwera jate pyryva'ea rehe, garenduve'g̃a ojirokwa heroviapotaheteavo ganhi'ig̃a. A'ero g̃a ei: “Kwa. Kiro ti Tupana'ga toko oreruvihavuhuhetero ore repiakatuavo.” A'ea g̃a ei ipotaheteavo ojikoga Tupana'ga rehe. Ag̃wamo na jitehe g̃a ei a'ea jitehe ipotaheteavo, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","—Nahã g̃a ndekoi ikwahava. A'ereki ymyahũva'ea omombe'u nanongara no. “Aerẽ po ti Tupana'ga oko g̃anduvihavuhuhetero g̃a ndepiakatuavo nehẽ.” Nahã Tupana'ga nhi'ig̃a mombe'uharava'ea epaepavi Moisésva'ea pavẽi, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ahe e'i: “Tupana'ga po ti oko g̃anduvihavuhuhetero nehẽ. Elias'ga po ti uhu na'ẽ nehẽ,” ei ahe, ei Jesus'ga. Omombe'u ahe João Batista'ga Eliasva'ea mombe'urame. Ag̃wamo João Batista'ga ruri oji'i ahe nhi'ĩpo'ruavo a'ero. Marã? Perovia pota pe a'ea a'ero naerũ? ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Peapyakwa pe. Pehendu katu ti ji'ea a'ero! ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","—G̃a pe Jesus'ga ei: Marã po ti ji ei pe me ag̃wamova'ea pe a'ero nehẽ? Gara ja pe ndekoi a'ero? Kiro ji pe mombe'ui pe me. Tayri'g̃a ja ko pe ndekoi. Oapy tayri'g̃a ima'ẽhai pe feira pe. A'ero g̃a hapukai ojipe'g̃a pe tayri'g̃a pe – kiroki g̃a ojikoty'a g̃a pavẽi. Onhi'ig̃a mondovo g̃a pe g̃a ei: ");
INSERT INTO pahNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“Oropy ore jiru'a pe me xajory ti nhanerembirekoa rehe javo. Pe ki a'e te ndapeyrerupypotari henduvame. Xajehe'o ti nhanenhikamombava rehe, oro'e ore pe me. A'ero ore jehe'oi. Pe ki a'e te ndapejehe'oi ore pyri. A'ereki pe ndapepotariuhu.” Nahã tayri'g̃a ei, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","—Tayri'g̃a ja pe ndekoi. A'ereki pe pe'epe'e João Batista'ga pe jipi. A'ereki ga rurame pe pyri ga ndo'uahivuhui mbatera vinho reheve tambohete ji Tupana'ga javo, ei Jesus'ga. A'ero pe epe'ei ga mombe'gwovo: “Anhag̃a opyhy ga.” Nahã pe João Batista'ga mombe'ute'varuhui ga arõe'yma, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","—Tayri'g̃a ja pe ndekoi. A'ereki pe pe'epe'e ji ve no, ei Jesus'ga g̃a pe. Yvyakotyva'ero yvagipeva'ero ji ajo pe pyri mbatera i'gwovo vinho i'gwovo no. A'ero pe epe'ei ji mombe'gwovo: “Ehepia Jesus'ga! O'uheteuhu ga. Ga ko heagwyryve'ga vinho gwovo,” pe'e pe ji ve, ei Jesus'ga. “Ite'varuhuve'g̃a – kiroki g̃a omono'og̃uhũ itambere'ia governo pe – g̃a pavẽi Jesus'ga ojikoty'a ojipe'g̃a pavẽi okote'varuhuve'g̃a pavẽi,” pe'e pe. Nahã pe euhui ji mombe'gwovo ji arõe'yma, ei Jesus'ga. —Ojipe'g̃a ndekokatua repiaga g̃waramo nhande ei: Tupana'ga reki okwahavuka g̃a pe g̃a mongokatuavo, ei Jesus'ga. Ojipe'g̃a ndekote'varuhua repiaga g̃waramo nhande ei: Tupana'ga rũi omongo g̃a ite'varuhua rehe, ei Jesus'ga pevove'g̃a mbo'eavo he'yjuhuve'g̃a mbo'eavo. ");
INSERT INTO pahNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Kiro Jesus'ga nhi'ig̃ahyi cidadepeve'g̃a pe. A'ereki g̃acidades pe ga japorame ahemonhimomby'aheteva'ea g̃a ndopohiri ote'varuhua hugwi. Ndogwerojijyi g̃a ojeaporog̃ita ojikoge'yma ga rehe. Nurã ga ei g̃a pe: ");
INSERT INTO pahNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","—Tiruahũ ti pe me Corazimmeva'ea pe nehẽ! ei Jesus'ga. Tiruahũ ti pe me Betsaidapeva'ea pe nehẽ! ei ga. A'ereki pe ndapepohiri pejikote'varuhua hugwi. Pehepia ko pe Tupana'ga popoakara novĩa ji japorame ahemonhimomby'aheteva'ea. Hepiagame po pe pepohi pejite'varuhua hugwi hamo. A'ea Jesus'ga ei cidadepeve'g̃a pe Corazimmeve'g̃a pe Betsaidapeve'g̃a pe no. —Ymyahũ Tiropeva'ea Sidommeva'ea pavẽi ndohepiagi Tupana'ga popoakara ahemonhimomby'ava'ea repiage'yma, ei Jesus'ga. Po ymyahũ ji japoi ahemonhimomby'ava'ea ahepyteri pe, po kotihĩ ahe pohiri okote'varuhua hugwi po raka'e hamo. Omongi po ahe opite'varuhua imondovo tanimbuga oakag̃a rehe po raka'e hamo ndorovy'ari ore orerekote'varuhua rehe javo, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","—Ymyahũ Tiropeva'ea ndohepiagi reki Tupana'ga popoakara ahemonhimomby'ava'ea repiage'yma Sidommeva'ea pavẽi, ei Jesus'ga. Ndopohiri ahe a'ero okote'varuhua hugwi. Nurã po ti ahe hepiagi hahyva'ea ojihe nehẽ Tupana'ga omanove'g̃a mono'ombavame ahe reheve nehẽ. G̃a mono'ombavame po ti ga ei ahe ve nhaporemo nehẽ peko te'varuhu pe javo, ei Jesus'ga cidadepeva'ea mombe'gwovo. —Pe me, Corazimmeva'ea pe Betsaidapeva'ea pe no, pe me ji ei: A'ea rupi koji'i po ti hahy pe me nehẽ. Igwyre'i po ti hahy Tiropeva'ea pe Sidommeva'ea pe nehẽ no, ei Jesus'ga. A'ereki Tupana'ga popoakara repiakaturame pe ndapepohiri reki pejikote'varuhua hugwi, ei Jesus'ga Corazimmeve'g̃a pe Betsaidapeve'g̃a pe no. ");
INSERT INTO pahNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Cidadepeve'g̃a pe Cafarnaummeve'g̃a pe Jesus'ga ei: —Pehe marãi pe pejive naerũ? Pe'e pe: “Nhande huvihava jara'g̃a hohe pa.” Nahã ko pe ei pejohupe penhimboheteavouhu pejikovo. Pe peho hete tata pype hahyva'ea ruvihava pype nehẽ, ei Jesus'ga. A'ereki pe ndapepohiri reki pejikote'varuhua hugwi. Pehepia pe Tupana'ga popoakara ji japorame ahemonhimomby'aheteva'ea. Hepiagame po pe pepohi pejite'varuhua hugwi hamo. Po ymyahũ ji japoi ahemonhimomby'ava'ea Sodomapeva'ea pyteri pe, a'ero po uveji cidade Sodoma hamo ikaje'yma hamo, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","—Ymyahũ Sodomapeva'ea ndohepiagi reki Tupana'ga popoakara ahemonhimomby'ava'ea. Ndopohiri ahe a'ero okote'varuhua hugwi. Nurã po ti ahe hepiagi hahyva'ea ojihe nehẽ Tupana'ga omanove'g̃a mono'ombavame ahe reheve nehẽ. G̃a mono'ombavame po ti ga ei ahe ve nhaporemo nehẽ peko te'varuhu pe javo, ei Jesus'ga Sodomapeva'ea mombe'gwovo. Pe me, Cafarnaummeva'ea pe, pe me koji'i po ti hahy Sodomapeva'ea pe hohe a'ea rupi nehẽ, ei Jesus'ga Cafarnaummeve'g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Onhi'ig̃ahypavame g̃a pe nhaporemo Jesus'ga ei Tupana'ga pe: —Apĩ, ei ga Tupana'ga pe. Ndepyry hete nde ekovo yvagipeve'g̃a nduvihavuhuhetero yvyakotyve'g̃a nduvihavuhuhetero no. A'ereki nde nderekwahavukari a'itituhẽva'ea ikwahapyra'g̃a pe heaporog̃itave'g̃a pe no. Onhimbo'ee'ỹve'g̃a pe tayri'g̃a'jave'g̃a pe nde erekwahavuka a'itituhẽva'ea. ");
INSERT INTO pahNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Na tuhẽ, Apĩ. A'ereki nahã nde erepota, ei Jesus'ga Tupana'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Kiro Jesus'ga ei: —Jiruva'ga ombuhu pa ji ve ji mbopopoaka. A'ero ji popoakaramo ojipe'g̃a hohe pa. Gaha jate ji kwaha hete. Ojipe'g̃a ndajikwahakatui. Jihi jate ji akwaha hete jiruva'ga. Okwaha g̃a ga ji ga mboukwahapotarame jate g̃a pe, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","—Pepoka pa po pe. Pekwerai po pe no. A'ereki pe pe'ag̃ata hete tiruahũ ji ve javo. Po nahã pe ndekoi, a'ero ti pejo ji pyri. Jihi ti topopoko inog̃atuavo pepy'a nehẽ. ");
INSERT INTO pahNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Peko ti nhiremimbo'ea rehe. Nahã po ti ji pe mbo'ei nehẽ. A'ereki ji ako nhyrõ nhinhimbohetee'yma jireaporog̃itapyryvamo jitekovo. Ji ve penhimbo'eukarame nhiremimbo'ea rehe po ti pe ikwahavi pejipy'a nog̃atua nehẽ. ");
INSERT INTO pahNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Ndapekwerai po ti pe pendekorame nhiremimbo'ea rehe nonhimimiva'ea rehe penhimbo'euka hehe pejikovo nehẽ. A'ero po ti pe ndaperekouhui pejivy'are'yma nehẽ ji nhi'ĩpo'ruavo nehẽ. ");
INSERT INTO pahNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Aerẽ judeus'g̃a poravykye'yma rupi sábado rupi Jesus'g̃a hoi kohoa rupi okovo. Garemimbo'ehara'g̃a hoi ga rupi. Trigo kopeva'ea pevo inhimongyi. Ojuka ty'ara garemimbo'ehara'g̃a. Nurã ohorame g̃a ika'mbika'mbigi trigo i'gwovo. ");
INSERT INTO pahNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Hepiagame fariseus'g̃a ei Jesus'ga pe: —Ymyahũ Moisésva'ea e'i ikwatija hako: “Tapeporavykyi ti sábado rupi.” Nahã ahe ei hako. Ehepia ti neremimbo'ehara'g̃a! G̃a nohendukatui reki. A'ereki g̃a oporavyky ika'mbika'mbiga trigo sábado rupi, ei fariseus'g̃a Jesus'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","A'ero Jesus'ga ei fariseus'g̃a pe: —Napehendukatui pe Tupana'ga nhi'ig̃a. Garembikwatijarukara omombe'u Daviva'ea. A'ea onhi'ĩ pe me novĩa. Ymyahũ ty'ara ojuka Daviva'ea onhipavẽiva'ea no hako. ");
INSERT INTO pahNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","A'ea rupi ahe hoi Tupana'ga ronga pype tenda pype. Ipype ikwava'ẽhara'g̃a omondo pão Tupana'ga rovai pyteri pe jipi. G̃a ikwava'eg̃irẽ Tupana'ga pe ga gwerohouka g̃a pe g̃ahã jate ti to'u jirovai pyteripeva'eagwera javo. Ojipe'g̃a po ndo'ui hamo. Daviva'ea reki i'ui onhipavẽiva'ea pavẽi hako, ei Jesus'ga fariseus'g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","—Tupana'ga rembikwatijarukara onhi'ĩ pe me novĩa, ei Jesus'ga fariseus'g̃a pe. Ymyahũ Tupana'ga e'i Moisésva'ea pe ikwatijaruka ahe ve hako. Ahe ve ga ei: “Nhimbohetehava pype ti ikwava'ẽhara'g̃a toporavyky ikwava'eg̃a ji ve jukapyra. Oporavykye'yma rupi sábado rupi ti g̃a tokwava'ẽ ipype. Nahã ti g̃a toko katu. Nahã pyry ji ve.” Ymyahũ Tupana'ga ei a'ea Moisésva'ea pe ikwatijaruka ahe ve hako, ei Jesus'ga fariseus'g̃a pe. Tupana'ga ei g̃a pe: “Pyry.” Ndojari g̃a ndehe a'ero g̃aporavykya sábado rupi, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","8","—Jihi reki kiro a'e pe me: Tupana'ga ei ji ve kaitu pyry, ji erame: Nahanahã ti yvyakotyve'g̃a toko sábado rupi. Nurã yvyakotyva'ero yvagipeva'ero ji ei pe me: Tape'epe'ei ti nhiremimbo'ehara'g̃a pe g̃a ika'mbigame trigo sábado rupi a'ero, ei Jesus'ga fariseus'g̃a pe. Ymyahũ Tupana'ga ei hako: “Peru pe mbatepyryva tokwava'ẽ ti ikwava'ẽhara'g̃a Tupana'ga pe javo. A'ea ji ei pe me novĩa. Emo koji'i ji apota penemimombyryva ojipe'g̃a pe,” ei Tupana'ga hako, ei Jesus'ga. Tupana'ga nhi'ig̃a pe ndapekwahakatui, ei Jesus'ga g̃a pe. Po pe ikwahakatui, a'ero po pe napembojari ite'varuhuva'ea okokatuve'g̃a ndehe hamo, ei Jesus'ga fariseus'g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Aerẽ Jesus'ga hoi ogwovo gwe'yja'g̃a jatykai pe ovahema. ");
INSERT INTO pahNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ipype iponhimamave'ga rekoi. Ojipe'g̃a ndeaporog̃itate'varuhuro okovo timbotegwete ti Jesus'ga javo. A'ero g̃a ei ojohupe: —Mara'ngu po ti Jesus'ga oporavykyavo gapoa mbokatua'java nhandeporavykye'yma rupi sábado rupi? Ga gapoa mbokatua'javame po ti nhande Jesus'ga mbotegwetei nehẽ, ei g̃a ojohupe. Nurã g̃a ei Jesus'ga pe: —Marãi Moisésva'ea rembikwatijara nhandeporavykye'yma mombe'gwovo sábado mombe'gwovo? Marãi ikwatijara? Pyry nhande nimombigi g̃atetirũa nhandeporavykye'yma rupi sábado rupi? Marãi? ei g̃a Jesus'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Imombe'gwovo Jesus'ga ei g̃a pe: —Erereko po nde ovelha ojipejiva'ea. Po nerenymbava ovelha ihiri ikwaruhua pype nhandeporavykye'yma rupi sábado rupi, a'ero po nde ipyhygi ovelha henohema jugwi. Nahã nde ovelha rerekokatui. A'ereki pyry ovelha nde ve, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Koji'i avove'g̃a pyryvamo Tupana'ga pe yvyakotyve'g̃a. Nurã ji ei: Pyry nhande g̃a pokogame sábado rupi, ei Jesus'ga. Aherembikwatijara e'i no pyry javo. ");
INSERT INTO pahNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","A'ea erame Jesus'ga ei akoja'ga pe iponhimamave'ga pe: —Ejipoapyho! A'ero ga jipoapyhoi. Ikatua'ja gapoa a'ero ojipea ja gapoa ja. ");
INSERT INTO pahNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","A'ero fariseus'g̃a hoi Jesus'ga hugwi onhimono'og̃a. Ojohupe g̃a ei onhimonha'ngavo: —Maranuhũ po ti nhande Jesus'ga jukaukari nehẽ naerũ? ei g̃a ojohupe. ");
INSERT INTO pahNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","G̃a'ea kwahavame Jesus'ga hoi pea hugwi ogwovo. He'yjuhuve'g̃a nhimono'og̃i ogwovo ga rupi. A'ero ga imombipavi g̃atetirũa g̃a hugwi. ");
INSERT INTO pahNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Kiro ga ehetei g̃a pe: —Tapemombe'ui ti ojipe'g̃a pe Jesus'ga imombigi oretetirũa javo. ");
INSERT INTO pahNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","A'ea Jesus'ga ei g̃a pe. Nahã hekoi Tupana'ga nhi'ĩpo'ruavo ymyahũva'ea po'ruavo. A'ereki ymyahũ Tupana'ga nhi'ig̃a mombe'uharava'ea Isaíasva'ea a'ea mombe'u Tupana'ga nhi'ig̃a mombe'gwovo. Ahe e'i hako: ");
INSERT INTO pahNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“‘Pehepia ti nhipavẽive'ga – kiroki ga pe ji a'e eko ti g̃anduvihavuhuhetero javo,’ ei Tupana'ga,” ei ahe. “‘Ga ko nhiremia'nguhete'ga. Anhimohẽ hete ji ga rehe,’ ei Tupana'ga. ‘Amondouka po ti ji jira'uva ga pyri ga pojykakatuuka jupe nehẽ. A'ero po ti ga nhiremimbotarimova'ea mombe'ui judeus'g̃arũive'g̃a pe nahanahã pyry Tupana'ga pe javo,’ ei Tupana'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","‘Nhipavẽive'ga po ti ndogwayvari g̃a nehẽ. Ndohapukai po ti ga g̃a pe nehẽ. Ndahyahivi po ti ganhi'ig̃a g̃a pe cidade rapea rupi nehẽ,’ ei Tupana'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","‘Ga po ti oko nhyrõ he'ouhũve'g̃a pokoga nehẽ. Pyry po ti ga ndipopoakarive'g̃a pe nehẽ. Nahã po ti ga rekoi hendukatuuka g̃a pe nhinhi'ig̃a g̃a mongovouka nhinhi'ig̃a rupi,’ ei Tupana'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","‘Ga rehe po ti judeus'g̃arũive'g̃a jikogi nehẽ,’ ei Tupana'ga,” ei Isaíasva'ea hako. ");
INSERT INTO pahNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Aerẽ ojipe'g̃a heakwagweve'ga reruri Jesus'ga pyri tombojipe'a ti Jesus'ga anhag̃a ga hugwi javo. Ndohepiagi heakwagweve'ga. Ga nonhi'ig̃i no. A'ereki anhag̃a ndohepiukari ga pe. Nomonhi'ig̃ukari ga pe no. G̃a ga reruri Jesus'ga pyri. Igwete Jesus'ga anhag̃a mbojipe'ai ga monhimohig̃atuavo. A'ero ga nhi'ig̃a'javi. Gwepiaga'ja ga no. ");
INSERT INTO pahNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","A'ero pevove'g̃a nhimomby'ahetei onhimongyavo. A'ero g̃a eg̃a'ei: —Mara'ngu po Jesus'ga Daviva'ea rymyminoa? A'ea g̃a ei. A'ereki g̃a e'i oyvyteri pe: “Ga pe Tupana'ga e'i eko ti g̃anduvihavuhuhetero javo.” A'ea g̃a ei nurã Jesus'ga popoakaro javo. ");
INSERT INTO pahNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Henduvame fariseus'g̃a ei: —Aherymyminoa rũi po ga. Belzebu'ga anhag̃a ruvihavuhu'ga Jesus'ga pokogame jate ga popoakaro. Nurã Jesus'ga anhag̃a mbojipe'ai g̃a hugwi imondovouka, ei g̃a o'mbero. Belzebu, ei g̃a Diabo'ga pe. Irũa garera Satanás. ");
INSERT INTO pahNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Jesus'ga okwaha fariseus'g̃a ndeaporog̃itate'varuhua. A'ero ga ei g̃a pe: —Po g̃agwyripeve'g̃a otavuka ojohupe, a'ero po ti g̃a nhomoka'nhymbavi nehẽ. Po cidadepeve'g̃a otavuka ojohupe, a'ero po ti g̃a nhomoka'nhymbavi nehẽ no. Po ongapypeve'g̃a otavuka ojohupe, a'ero po ti g̃a nhomoka'nhymbavi nehẽ no, ei Jesus'ga fariseus'g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Po Satanás'gapyriva'ea nhombojipe'ai nahã otavuka ojohupe, a'ero po ti inhomoka'nhymbavi jovai nehẽ no. Marã po ti Satanás'ga huvihava a'ero ojipyriva'ea ahana'javame nehẽ? ei Jesus'ga fariseus'g̃a pe. A'ea Jesus'ga ei. A'ereki fariseus'g̃a e'i o'mbero: —Belzebu'ga Jesus'ga pokogi ojipyriva'ea mbojipe'auka ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","A'ero Jesus'ga ei fariseus'g̃a pe: —Ma'g̃a ombojipe'auka Satanás'gapyriva'ea pendeheve'g̃a pe naerũ? ei Jesus'ga. Ndape'ji reki pe g̃a pe: “Belzebu'ga ombojipe'auka g̃a pe.” A'ea rũi pe ei, ei Jesus'ga. Po ga rũi g̃a poko ojipyriva'ea mbojipe'auka g̃a pe, a'ero ga rũi ji poko no, ei Jesus'ga. Tape'ei ti ji ve a'ero: “Belzebu'ga Jesus'ga poko.” Po pe'ji a'ea ji ve, a'ero po ti pendeheve'g̃a ete'varuhui pe me nehẽ no pe'mbe pe javo pe me nehẽ, ei Jesus'ga fariseus'g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","—Tupana'ga ra'uva reki ombojipe'auka Satanás'gapyriva'ea ji ve, ei Jesus'ga. Pekwaha pe a'ero Tupana'ga ko nhanderuvihavuhuhetero kiro javo, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","—Po ojipe'ga kipotari ipopoakave'ga ronga pype gambatera rerogwovo ga hugwi, a'ero ga ipopoakave'ga pokwapokwari na'ẽ, ei Jesus'ga. Aerẽ ga ipyhygi gambatera herogwovo a'ero. Nahã ga koji'i ipopoaka hete reki ipopoakave'ga hohe. A'ea Jesus'ga imombe'ui nahã Tupana'ga ipopoaka Satanás'ga hohe javo. ");
INSERT INTO pahNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","—Kiroki ga ndajirepygi – gaha ji movahĩ, ei Jesus'ga. Kiroki ga nomono'og̃i ji pavẽi – gaha ombokwaki'o. A'ea Jesus'ga ei ga nombojikogukari g̃a ji rehe javo. ");
INSERT INTO pahNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","—Pe'e pe: “Belzebu'ga opoko Jesus'ga.” Nahã pe erame ji ve pe Tupana'ga ra'uva mbotegwetei. A'ereki Tupana'ga ra'uva tuhẽ ji poko, ei Jesus'ga. Tupana'ga ti omombo pa g̃a hugwi g̃andekote'varuhua g̃a'ete'varuhuagwera ojive nehẽ, ei Jesus'ga. Po Tupana'ga ra'uva pe g̃a ete'varuhui Tupana'ga ra'uva mbotegweteavo nahã okote'varuhuavo, a'ero po ti Tupana'ga nomombori g̃andekote'varuhua g̃a hugwi nehẽ, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Po g̃a ete'varuhui ji ve vehevi okote'varuhuavo, a'ero po ti Tupana'ga imombori g̃andekote'varuhua g̃a hugwi nehẽ, ei Jesus'ga yvyakotyva'ero yvagipeva'ero no. Po g̃a ete'varuhui Tupana'ga ra'uva pe reki okote'varuhuavo, a'ero po ti Tupana'ga nomomborag̃wami g̃andekote'varuhua nehẽ. Nomombori po ti ga kiro. Aerẽ po ti ga nomombori nehẽ no, ei Jesus'ga fariseus'g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","—Pejapyaka ti nhinhi'ig̃a rehe, ei Jesus'ga fariseus'g̃a pe. Po i'yva ikatu, a'ero yva'ia ikatu. Po i'yva ite'varuhu, a'ero yva'ia ite'varuhu. Ahe okwaha i'yva. A'ereki ahe gwepia herekorame yva'ia ojihe, ei Jesus'ga fariseus'g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Peko te'varuhu pe! ei Jesus'ga g̃a pe. Nurã pe ete'varuhui ojipe'g̃a pe. A'ereki pejiyvyteri pe pe peko te'varuhu hete, ei Jesus'ga fariseus'g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Pyryve'ga, nane'ymi ga reaporog̃itaro pyryva'ea rehe. Nurã ga ekatui jipi, ei Jesus'ga. Ite'varuhuve'ga, nane'ymi ga reaporog̃itaro ite'varuhuva'ea rehe. Nurã ga ete'varuhui, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","—Imombe'ukatuavo ji ei pe me: Aerẽ mbapava koty po ti hahy hete g̃a pe Tupana'ga erame g̃a pe nhaporemo g̃andeaporog̃ita rehe nehẽ. G̃a pe po ti ga ei: “Penhi'ĩteheuhu pe nahanahã javo. Maraname pe nhi'inhi'ĩtehei?” Nahã po ti ga ei g̃a pe nehẽ. ");
INSERT INTO pahNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","A'ereki ga g̃wendu pa nenhi'ĩtehea nenhi'ĩpyryva reheve. A'ero nde nhi'ĩpyryvame po ti ga ei nde ve nehẽ: “Pyry nenhi'ig̃a. Ereko katu nde a'ero,” e po ti ga nehẽ. Nde nhi'ĩteheuhurame ga henduvi no. A'ero po ti ga ei nde ve nehẽ: “Ndapyryvi nenhi'ig̃a. Ereko te'varuhu nde a'ero,” e po ti ga nde ve nehẽ. A'ero po ti ga imondoi hahyva'ea nde ve nehẽ nde ete'varuhuro g̃waramo, ei Jesus'ga imombe'gwovo fariseus'g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","A'ero judeus'g̃a mbo'ehara'g̃a ei Jesus'ga pe fariseus'g̃a pavẽi: —Ahembo'eharamo eapo ti ahemonhimomby'ava'ea torohepia ti, ei g̃a. ");
INSERT INTO pahNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","A'ero Jesus'ga ei g̃a pe: —Peko te'varuhu pe ag̃wamova'ero! ei Jesus'ga. Ndapekoi pe Tupana'ga nhi'ig̃a rehe pejikoge'yma ga rehe. A'ero pe ei: “Jesus'ga japorame jate nhande ve ahemonhimomby'ava'ea, a'ero po ti nhande ei ikwahava nehẽ: Tupana'ga ga poko. A'ea po ti nhande xa'e hepiagame nehẽ.” A'ea pe ei, ei Jesus'ga. —Ndoapoukari po ti Tupana'ga ojipea ahemonhimomby'ava'ea pe me nehẽ. Ojikwe ga oapo ahemonhimomby'ava'ea Jonasva'ea mohemukarame hako. A'ea jate po ti ga ikwahavukara'javi pe me nehẽ, ei Jesus'ga. Ymyahũ Jonasva'ea ko Tupana'ga nhi'ig̃a mombe'uharava'ea hako. ");
INSERT INTO pahNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Mokõi okira rupi Jonasva'ea rekoi piraruvihavuhua revegi pe. Kirẽ pira ahe mbojivyra'javi gwevega hugwi. Aerẽ ahe hoi Tupana'ga nhi'ig̃a mombe'gwombe'gwovo Nínivepeva'ea pe a'ero hako, ei Jesus'ga. —Jonasva'ea javijitehe mokõi jikira rupi po ti ji rekoi yvya pype hete nehẽ. Kirẽ po ti ji hemi jugwi nehẽ yvyakotyva'ero yvagipeva'ero no, ei Jesus'ga. A'ero po ti pe ikwahavi Tupana'ga opoko Jesus'ga javo, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","—Aerẽ mbapava koty po ti Tupana'ga omanove'g̃a mono'ono'ombavi ag̃wamove'g̃a ndeheve nehẽ, ei Jesus'ga. G̃a mono'ombavame po ti ga ei g̃a pe nhaporemo nehẽ peko te'varuhu pe javo. A'ea rupi po ti Nínivepeva'ea kweravi nehẽ no. Ojipiukarame po ti ahe imboukwahavukari ag̃wamove'g̃a ndekote'varuhua nehẽ. A'ereki a'ea renonde ymyahũ Nínivepeva'ea g̃wendu katu Tupana'ga nhi'ig̃a hako. Opohi ahe okote'varuhua hugwi ymyahũ hendukatuavo Tupana'ga nhi'ig̃a Jonasva'ea imombe'uro g̃waramo hako, ei Jesus'ga g̃a pe imombe'gwovo. —Ji rendu ti! ei Jesus'ga g̃a pe. Jihi kaitu amombe'u katu Tupana'ga nhi'ig̃a Jonasva'ea hohe, ei Jesus'ga. Ag̃wamove'g̃a nohendupotari nhinhi'ig̃a opohire'yma okote'varuhua hugwi. Nurã po ti Nínivepeva'ea imboukwahavukari ag̃wamove'g̃a ndekote'varuhua nehẽ, ei Jesus'ga fariseus'g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","—Mbapava koty po ti Tupana'ga omanove'g̃a mono'ono'ombavi ag̃wamove'g̃a ndeheve, ei Jesus'ga. G̃a mono'ombavame po ti ga ei g̃a pe nhaporemo nehẽ peko te'varuhu pe javo. A'ea rupi po ti tyapyrakotyva'ea ruvihavuhuva'ea kweravi nehẽ no kunhangwerava'ea. Ojipiukarame po ti ahe imboukwahavukari ag̃wamove'g̃a ndekote'varuhua nehẽ. A'ereki a'ea renonde ymyahũ tyapyrakotyva'ea ruvihavuhuva'ea uhu Salomãova'ea pyri hako tahendu ti ganhi'ig̃a javo. “A'ereki ga okwaha hete,” ei ahe ua. Paivouhu hete ahegwyra. Paivouhua hugwi ahe ruri hako tahendu ti ga javo, ei Jesus'ga imombe'gwovo fariseus'g̃a pe. —Ji rendu ti! ei Jesus'ga g̃a pe. Jihi kaitu akwaha hete Salomãova'ea hohe, ei Jesus'ga. Ag̃wamova'ero napehendupotari nhinhi'ig̃a ikwahapotare'yma a'itituhẽva'ea. Nurã po ti ahe imboukwahavukari pendekote'varuhua nehẽ, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","—Kiro po ti ji imombe'ui Diabo'gapyriva'ea rembipyhyga'ga anhag̃a rembipyhyga'ga pe me, ei Jesus'ga. Na ja ag̃wamove'g̃a ndekoi ite'varuhuve'g̃a – kiroki g̃a opohi okote'varuhua hugwi novĩa ojikoge'yma ji rehe, ei Jesus'ga. Anhag̃a ite'varuhu hete akwaimbae'ga pyhyga otiruahũro ga pe. Aerẽ anhag̃a jipe'ai ga hugwi ogwovo yhye'ỹi me okwaokwava. “Mome po ti ji ruvi nehẽ?” e'i oyvyteri pe heka. Ndohepiagi reki. ");
INSERT INTO pahNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Nurã i'ei: “Ajivy po ti ji nhironga pe ipojykaa'java akwaimbae'ga pojykaa'java,” e'i anhag̃a. Akwaimbae'ga pe anhag̃a e'i nhironga. —A'ero ituri ojivya akwaimbae'ga pyri. Ovahemame ga pyri anhag̃a i'ei: “Ndogwerekoi ve ongapypeve'g̃a ipype imboavujikweripyra pype,” e'i akwaimbae'ga mombe'gwovo. ");
INSERT INTO pahNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","“Taru ti jara ji pyri a'ero,” e'i. —A'ero ihoi anhag̃a rerua seteva'ea rerua. Akoja hohe seteva'ea tiruahũ hete, ei Jesus'ga. Ovahemame akwaimbae'ga pyri ga pojykai otiruahũro ga pe. A'ero kiro koji'i tiruahũ hete akwaimbae'ga pe. Ymya tiruahũ ga pe ojipejiva'ea ga pojykarame. Aerẽ koji'i tiruahũ hete ga pe seteva'ea ga pojykarame, ei Jesus'ga. —Na jitehe tiruahũ ag̃wamo ite'varuhuve'g̃a pe. Aerẽ koji'i po ti tiruahũ hete g̃a pe nehẽ. A'ereki opohi'rãrame okote'varuhua hugwi novĩa g̃a nde'i ji ve: “Herejo ejikoty'a ji pavẽi.” A'ea g̃a nde'i ji ve. Aerẽ koji'i g̃a ndekote'varuhui a'ero, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jesus'ga imombe'urame pevove'g̃a pe nanime Jesus'ga yembora ruri gairũ'g̃a pavẽi o'ama okari pe. Onhi'ĩ pota g̃a ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Pevove'g̃a pyteripeve'ga e'i Jesus'ga pe: —Neyhẽa uhu nde repiaga neirũ'g̃a pavẽi. Pevo g̃a ami okari pe. ");
INSERT INTO pahNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","A'ero Jesus'ga ei ga pe: —Ji erame nhiyhẽa, marãve'g̃a pe ji ei? ei ga. Ji erame nhiirũ'g̃a, marãve'g̃a pe ji ei? Kiro ji imombe'ukatui nde ve, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","A'ero Jesus'ga pova'eg̃i g̃wemimbo'ehara'g̃a pe. G̃wemimbo'ehara'g̃a mombe'gwovo ga ei: —Pehepia! G̃a pe ji ei nhiy'g̃a. G̃a pe ji ei nhiirũ'g̃a, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Kiroki g̃a jiruva'ga nhi'ĩpo'ru yvagipeve'ga nhi'ĩpo'ru – g̃a pe ji ei nhiirũ'g̃a. A'e ji g̃a pe no nhirendyra'g̃a. Nhiy'g̃a a'e ji g̃a pe no, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Onhi'imbavame Jesus'ga hoi onga hugwi ogwovo ypiahu pe. Pevo ga apygi oina. ");
INSERT INTO pahNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","He'yjuhuve'g̃a nduri onhimbotymbotyva ga pyri tihendu katu ti ga javo. Nurã ga hoi o'ava yharuhua pype oina. A'ero g̃a ami yembeyvyri pe. ");
INSERT INTO pahNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Ojo'java'ea pyvõ ga g̃a mbo'embo'ei imombe'gwovo g̃a pe he'yjuhuva'ea. Ga e'i: —Ji rendu ti! ei Jesus'ga. Ha'ynha mohãihara'ga hoi ko pe ityma, ei ga. ");
INSERT INTO pahNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Pevo ga imohãi ha'ynha. Nahã ga itymi ha'ynha. Ga imohãirame ha'ynha jara indurugi pehea rembeyvyra rupi. Ua gwyra'ia i'ui imokona, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","—Ga imohãirame ha'ynha jara indurugi yja rehe ita arimo. A'ereki ita onhimongyheteuhu pevo. Xunhi yja a'ero ha'ynha pe. Kotihĩ henhunhamo novĩa. A'ereki nianami yja ita rehe. ");
INSERT INTO pahNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Kwarahyahiva imbokai garemityma a'ero. He'ouhũ omanomo. A'ereki ndokihetei hapoa yvya pype, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","—Ga imohãirame ha'ynha jara indurugi nhungwava ra'ynha pyteri pe hatĩava'ea ra'ynha pyteri pe. Aerẽ ga'apoa ha'ynha renhunhamo nhungwava ra'ynha pavẽi. A'ero nhungwava nhambyguhui garemityma, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","—Ga imohãirame ha'ynha jara indurugi yjakatua pype. A'ero henhunhamo o'ao'aheteramo. He'yjuhu ahara a'ero. Jara pype ahara pype turi cem ha'ynha. Jara pype ahara pype turi sessenta ha'ynha. Jara pype ahara pype turi trinta ha'ynha. Nahã Jesus'ga ei imombe'gwovo ha'ynha mohãihara'ga mombe'gwovo. ");
INSERT INTO pahNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","—Peapyakwa pe. Pehendu katu ti ji'ea a'ero! ei Jesus'ga pevove'g̃a pe imombe'gwovo ojo'java'ea. ");
INSERT INTO pahNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Jesus'ga remimbo'ehara'g̃a nduri ga pyri javo ga pe. —Maraname nde imombe'ui ojo'java'ea g̃a pe g̃a mbo'erame? ei g̃a Jesus'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","A'ero Jesus'ga ei g̃a pe: —Pe me Tupana'ga ei tokwaha ti g̃a onhimiva'ea nhirembiepiakatuhava javo, ei Jesus'ga. Marã hekoi kiro Tupana'ga yvyakotyve'g̃a ndepiakaturame okovo g̃anduvihavuhuhetero? A'earupiva'ea kiro ga ikwahakwahavukari pe me. Ojipe'g̃a pe po ti ga ndokwahavukari tuhẽ a'ea nehẽ, ei Jesus'ga g̃wemimbo'ehara'g̃a pe. Nurã ji imombe'ui ojo'java'ea g̃a pe g̃a mbo'erame, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","—Kiroki ga okwaha – ga pe po ti Tupana'ga ikwahavukari koji'iva'ea nehẽ. A'ero po ti ga ikwahahetei nehẽ, ei Jesus'ga. Kiroki ga ndokwahavi – po ga ikwahavi xunhiva'ea, a'ea vehevi po ti Tupana'ga imoka'nhymbavukari ga pe nehẽ, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","—Nurã ji imombe'ui ojo'java'ea g̃a pe. A'ereki “hepiagame g̃a gwepia tehe reki. A'ereki g̃a nombaragwahapotari hehe. Henduvame g̃a g̃wendu tehe reki. A'ereki g̃a ndokwahapotari”, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","—Nahã g̃a ndekoi hepiage'yma henduve'yma no, ei Jesus'ga. Nahã hekoi Tupana'ga nhi'ĩpo'ruavo ymyahũva'ea po'ruavo. A'ereki ymyahũ Tupana'ga nhi'ig̃a mombe'uharava'ea Isaíasva'ea a'ea mombe'u Tupana'ga nhi'ig̃a mombe'gwovo. Ahe e'i hako: “‘Henduvame g̃a ndokwahavag̃wami reki. Hepiagame g̃a nombaragwahavag̃wami reki hehe,’ ei Tupana'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","‘Nahã g̃a. A'ereki g̃a noangarihu tiandeapyakwapupugyme ti javo. Ndiapyhai g̃a okovo tikwahavyme ti Tupana'ga nhi'ig̃a javo. Ndojapyakai g̃a xambaragwahavyme ti a'itituhẽva'ea rehe javo. Nahã g̃a ndekoi tirojijyjyme ti nhandereaporog̃ita javo. Tomomboryme ti Tupana'ga nhanderekote'varuhua nhande hugwi nehẽ, ei g̃a,’ ei Tupana'ga.” Ymyahũ Isaíasva'ea ei a'ea mombe'gwovo hako, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","—Pe me ki a'e te pyry hete. A'ereki pe pejirokwa ikwahava aherembikwahavipyre'yma Tupana'ga rembiapoa repiaga ganhi'ig̃a rendukatuavo, ei Jesus'ga g̃wemimbo'ehara'g̃a pe. Pyry hete pe me, a'e ji. ");
INSERT INTO pahNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","A'ereki ymyahũ ko ahe gwepia pota hete penembiepiaga Tupana'ga nhi'ig̃a mombe'uharava'ea ganhi'ig̃areheva'ea pavẽi. He'yiva'ea gwepia pota. Ahe ndohepiagi reki. G̃wendu pota hete ahe penemienduva no. Ahe nohenduvi reki, ei Jesus'ga g̃wemimbo'ehara'g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","—Pehendu ti a'ero ikwahava ojo'java'ea, ei Jesus'ga g̃wemimbo'ehara'g̃a pe. Kiro po ti ji imombe'ukatui pe me nehẽ ikwahavuka ha'ynha mohãihara'ga mombe'ua nehẽ, ei Jesus'ga g̃wemimbo'ehara'g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","—Kiro Tupana'ga rekoi yvyakotyve'g̃a nduvihavuhuhetero g̃a ndepiakatuavo, ei Jesus'ga. Kiroki g̃a g̃wendu a'ea mombe'ua novĩa ikwahave'yma – g̃a pyri ahemoandyandyihara'ga Diabo'ga ruri a'ero ipe'avo imombe'ua g̃apy'a hugwi imoka'nhymbavuka g̃a pe, ei Jesus'ga. G̃a pe ji ei a'ero ji imombe'urame ha'ynha indurugagwera pehea rembeyvyra rupi. ");
INSERT INTO pahNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","—Amombe'u jipe ko ji ha'ynha indurugagwera – kiroki onduru ita rehe, ei Jesus'ga. Kotihĩ henhui ha'ynha novĩa. A'ereki kwarahya rerekovo g̃waramo nonhimomiranami a'ero omanomo, ei ga. A'ereki ndokihetei hapoa yvya pype. —A'ea ja g̃a ndekoi – kiroki g̃a g̃wendu nhanderuvihavuhuhete'ga mombe'ua. Kotihĩ g̃a ndoryndoryvamo hehe novĩa. ");
INSERT INTO pahNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Aerẽ ojipe'g̃a omondo hahyva'ea g̃a pe ndoropotari pe henduvame gamombe'ua javo. Hahyro g̃waramo g̃a pe g̃a nonhimomiranami a'ero kotihĩ opohia nhanderuvihavuhuhete'ga mombe'ua hugwi. A'ereki ndokihetei gamombe'ua g̃ayvyteri pe. ");
INSERT INTO pahNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","—Amombe'u jipe ko ji ha'ynha indurugagwera – kiroki onduru nhungwava ra'ynha pyteri pe hatĩava'ea ra'ynha pyteri pe. Aerẽ igwaigwavete hatĩava'ea nhambyguhui garemityma jukavo, ei Jesus'ga. —A'ea ja ojipe'g̃a ndekoi nhungwava pyteripeva'ea ja. G̃a g̃wendu ojipe'g̃a erame g̃a pe: “Tupana'ga nhande poko katu kiro nhanderuvihavuhuhete'ga.” A'ea g̃a g̃wendu katu. Aerẽ g̃a ag̃ataruhuramo ojihe javo: “Maramarã po ti nhande rekoi nehẽ naerũ?” ei g̃a oyvyteri pe. A'ea nonog̃atuukari g̃apy'a. G̃a ipotapavuhui itambere'ia a'ero, ei Jesus'ga. “Koji'i nhande tipotaruhu itambere'ia a'ero ti pyryvamo nhande ve javo,” e'iuhu g̃a, ei Jesus'ga. A'ero igwaigwavete g̃a ndojapyakaa'javi nhanderuvihavuhuhete'ga mombe'ua rehe. A'ereki g̃a'ag̃atarahivuhua nohenduva'javukari a'ea g̃a pe. A'ero g̃a ndokoa'javi reki gamombe'ua rupi okokatue'yma ojipe'g̃a pe oporavykye'yma ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","—Amombe'u jipe ko ji ha'ynha indurugagwera – kiroki onduru yjakatua pype, ei Jesus'ga. A'ea ja ojipe'g̃a ndekoi yjakatuapypeva'ea ja. G̃wendu katu g̃a nhanderuvihavuhuhete'ga mombe'ua ikwahava. Japyakwapupu g̃a henduvame. Oko katu g̃a okovo gamombe'ua rupi a'ero. Nahã g̃a ha'ynha mohãihara'ga remitymipyrava'ea ja. Ojipea pype garemitymipyra pype turi cem ha'ynha ahara pype. Ojipea pype turi sessenta ha'ynha ahara pype. Ojipea pype turi trinta ha'ynha ahara pype. Na jitehe ko g̃a – kiroki g̃a japyakwapupu. Ombojoavyavy g̃aporavykya Tupana'ga pe okokatuavo ojipe'g̃a pe. Jara'g̃a he'yjuhu g̃aporavykya. Jara'g̃a koji'i g̃aporavykya. Nahanahã g̃a ndekoi. A'ea Jesus'ga ei imombe'gwovo pa ojo'java'ea ikwahavuka g̃wemimbo'ehara'g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Ojipea pyvõ ojo'java'ea pyvõ Jesus'ga g̃a mbo'ei. A'ero ga ei: —Marã hekoi kiro yvyakotyve'g̃a pe g̃a erame Tupana'ga nhanderuvihavuhuhetero oko javo? A'ea rehe po ti ji pe mbo'ei ikwahavuka pe me imombe'gwovo a'ea'java'ea, ei ga. Akwaimbae'ga imohãi ha'ynhapyryva trigo ra'ynha ko pe ityma. ");
INSERT INTO pahNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Aerẽ ypytunimo g̃a kipavame ga'arõe'ỹve'ga ruri imohaina nhungwava ra'ynha trigo'java'ea ra'ynha ko pe trigo pyteri pe. Kirẽ ga hoi a'ero ojipiukare'yma ogwovo. ");
INSERT INTO pahNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","—Aerẽ jate trigo henhunhamo nhungwava pavẽi. I'ai herekovo ahara. I'arame jate kohoa jara'gapyrive'g̃a mbaragwahavi nhungwava rehe trigo pyteri pe a'ea ko trigo rũi reki javo. ");
INSERT INTO pahNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","A'ero g̃a hoi kohoa jara'ga pyri javo ga pe: “Orepojykaharamo eretỹ nde trigo ra'ynhapyryva ko pe. Maraname gwereko nhungwava trigo pyteri pe? Ma'g̃a omohãi naerũ nhungwava ra'ynha trigo'java'ea ra'ynha a'ero trigo pyteri pe raikwehe?” ei g̃a ijara'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","—A'ero ga ei g̃a pe: “Ma'g̃a po? Ojipe'ga nanhiarõi a'ero imohaina nhungwava ra'ynha ipype raikwehe,” ei ga. —A'ero g̃a ei: “Marã a'ero? Toroho ti nhungwava mondoroga? Marã?” ei g̃a. ");
INSERT INTO pahNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","—“Tapemondorogi na'ẽ,” ei ga. “Nhungwava mondorogame mara'ngu po ti pe imondoroga trigo jajuve'ỹva'ea nhungwava reheve nehẽ? ");
INSERT INTO pahNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Na inhimomboakari ojogweheve,” ei ga, ei Jesus'ga imombe'gwovo. “Aerẽ trigo jajuvame po ti ji ei trigo mono'õhara'g̃a pe nehẽ: Nhungwava na'ẽ ti pemondoro trigo'java'ea jugwi imono'og̃a nehẽ. Peapytĩ ti jajurupya pe herogwovo imbokaita. Nahã po ti ji ei g̃a pe nehẽ,” ei ga, ei Jesus'ga imombe'gwovo. “A'ea py'rovo gwe ti pemono'õ trigo herua imondovo hyrua pype jiapoa pype. Nahã po ti ji ei g̃a pe nehẽ,” ei kohoa jara'ga. Nahã Jesus'ga ei imombe'gwovo ojo'java'ea. ");
INSERT INTO pahNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Ojipea pyvõ ojo'java'ea pyvõ Jesus'ga g̃a mbo'ei. A'ero ga ei: —Marã hekoi kiro yvyakotyve'g̃a pe g̃a erame Tupana'ga nhanderuvihavuhuhetero oko javo? A'ea rehe po ti ji pe mbo'ei ikwahavuka pe me imombe'gwovo a'ea'java'ea, ei ga. Akwaimbae'ga gwereko mostarda ra'ynha. A'ea ga itymi ko pe, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Mostarda ra'ynha ko jara gwyre'i pa xunhi hete. Henhunhame mostarda roryroryvamo. Aerẽ yvovouhuro. A'ero koji'i hehanhuhũ oji'java'ea hohe yvovouhuro. A'ero gwyra'ia ruri onhimongyavo upa hakã rehe japovo gwaityga, ei Jesus'ga he'yje'ỹve'g̃a po ti he'yjuhu nehẽ javo. ");
INSERT INTO pahNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Ojipea pyvõ ojo'java'ea pyvõ Jesus'ga g̃a mbo'ei. A'ero ga ei: —Marã hekoi kiro yvyakotyve'g̃a pe g̃a erame Tupana'ga nhanderuvihavuhuhetero oko javo? A'ea rehe po ti ji pe mbo'ei ikwahavuka pe me imombe'gwovo a'ea'java'ea, ei ga. Kunhahẽa opyhy he'yiva'ea vinte e cinco quilos de farinha de trigo, ei ga. Trigo pype hẽa imbojihe'ari imbovuhava ta'apo ti ji pão javo. A'ero hẽa igwaragwarai humbirimbiriga trigo ru'uma. Igwaigwavete imbovuhava onhinhamba trigo ru'uma pype imbovuvupava, ei Jesus'ga igwaigwavete po ti g̃a herojijyi ojeaporog̃ita nehẽ javo. ");
INSERT INTO pahNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","A'ea pa Jesus'ga imombe'ui ojo'java'ea pevove'g̃a pe he'yjuhuve'g̃a pe. A'ea jate ga imombe'ui g̃a pe g̃a mbo'eavo. ");
INSERT INTO pahNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Nahã hekoi Tupana'ga nhi'ĩpo'ruavo ymyahũva'ea po'ruavo. A'ereki ymyahũ Tupana'ga nhi'ig̃a mombe'uharava'ea a'ea mombe'u. A'ea rupi ahe ei Tupana'ga nhi'ig̃a mombe'gwovo hako: “Amombe'u po ti ji g̃a pe ojo'java'ea nehẽ. Kiroki onhimi yvya apoypyagwera jate – kiro po ti ji a'ea kwahavukari imombe'gwovo g̃a pe nehẽ,” ei ahe hako. ");
INSERT INTO pahNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Pevove'g̃a mondoukarame ojihugwi Jesus'ga hoi onga pype. A'ero garemimbo'ehara'g̃a nduri ga pyri javo ga pe: —Ore mbo'e ti ojo'java'ea rehe ikwahavuka ore ve nhungwava mombe'ua trigo'java'ea mombe'ua, ei g̃a Jesus'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","A'ero Jesus'ga ei g̃a pe: —Kwa. Kiro po ti ji imombe'ukatui pe me nehẽ. Jijive yvyakotyva'ero yvagipeva'ero ji ei ji ga mombe'urame ha'ynhapyryva mohãihara'ga, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Kohoa a'e ko ji yvyakotya pe, ei Jesus'ga imombe'gwovo g̃a pe. Ha'ynhapyryva a'e ko ji jireheve'g̃a pe. G̃a e'i Tupana'ga pe: “Ndehe ko oreruvihavuhuhetero.” Nhungwava trigo'java'ea a'e ko ji ite'varuhuve'gareheve'g̃a pe Diabo'gareheve'g̃a pe. G̃a e'i Diabo'ga pe: “Ndehe ko oreruvihavamo.” ");
INSERT INTO pahNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Ha'ynhapyryva mohãihara'ga arõe'ỹve'ga – kiroki ga otỹ nhungwava gakohoa pype – ga'arõe'ỹve'ga a'e ko ji Diabo'ga pe nhiarõe'ỹve'ga pe, ei Jesus'ga. Koapora mondorohava a'e ko ji mbapavakotya pe. Koapora mondorohara'g̃a a'e ko ji Tupana'gapyrive'g̃a pe yvagipeve'g̃a pe, ei Jesus'ga imombe'gwovo. ");
INSERT INTO pahNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","—Koapora mondorohara'g̃a imondorogi nhungwava trigo'java'ea imbokaita, a'e ko ji ko, ei Jesus'ga. Na jitehe mbapava koty po ti ji ite'varuhuve'g̃a mondoukari hahyva'ea ruvihava pype nehẽ, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Yvyakotyva'ero yvagipeva'ero po ti ji jipyrive'g̃a mondoi yvya koty nehẽ yvagipeve'g̃a. A'ero jireheve'g̃a ndeja po ti g̃a ite'varuhuve'g̃a nderohopavi nehẽ – kiroki ite'varuhuve'g̃a ombo'e ite'varuhuva'ea rehe, ei Jesus'ga. Okote'varuhuve'g̃a nhaporemo po ti jipyrive'g̃a g̃a nderohoi jireheve'g̃a pytera hugwi nehẽ no, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","A'ero po ti jipyrive'g̃a okote'varuhuve'g̃a mombori hahyva'ea ruvihava pype. Tataheteuhua koi hahyva'ea ruvihava. Pevo po ti g̃a jehe'oi ojihe onhimonha'ngavo hahyrame ojive nehẽ, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","—A'ero po ti Tupana'ga nhi'ig̃areheve'g̃a popoakara jukwahahetero nehẽ. Ikatu katu po ti g̃a gworygworyvamo nehẽ – perope g̃anduvete'ga ojikoty'a g̃a pavẽi Tupana'ga, ei Jesus'ga. Peapyakwa pe. Pehendu katu ti ji'ea a'ero! ei Jesus'ga imombe'gwovo katu g̃wemimbo'ehara'g̃a pe ojo'java'ea. ");
INSERT INTO pahNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","—Marã hekoi kiro yvyakotyve'g̃a pe g̃a erame Tupana'ga nhanderuvihavuhuhetero oko javo? A'ea rehe po ti ji pe mbo'ei ikwahavuka pe me imombe'gwovo a'ea'java'ea nehẽ, ei ga. Akwaimbae'ga hepiagi pyryheteva'ea ko pe. A'ereki a'ea ojipe'ga omi jipe yvykwara pype tohepiagyme ti g̃a javo. Garemimimipyra repiagame akwaimbae'ga heja pevo imima'java. Horyory ga hehe. Nurã ga imondopavi ombatera ojihugwi tombuhu ti g̃a ji ve itambere'ia mbatera pe javo. A'ero ga itambere'ia rerohoi imondopava kohoa jara'ga pe ipyhyga kohoa ga hugwi. “Nahã ji ipojykai nhirembiepiagipyra,” ei ga oyvyteri pe, ei Jesus'ga. Nahã hekoi yvyakotyve'g̃a pe g̃a erame Tupana'ga nhanderuvihavuhuhetero oko javo. A'ea Jesus'ga ei imombe'gwovo g̃wemimbo'ehara'g̃a pe ojo'java'ea ikwahavuka g̃a pe na jitehe pyryheteva'ea tuhẽ ko aherekoa Tupana'gareheva'ero javo. ");
INSERT INTO pahNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","—Marã hekoi kiro yvyakotyve'g̃a pe g̃a erame Tupana'ga nhanderuvihavuhuhetero oko javo? A'ea rehe po ti ji pe mbo'ei ikwahavuka pe me imombe'gwovo a'ea'java'ea nehẽ, ei Jesus'ga. Ima'ẽhara'ga hogahoi ojipe'g̃ape'g̃a pyri ipyhypota ita'ia'java'ea pyryheteva'ea pérolas ijara'g̃a hugwi. ");
INSERT INTO pahNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","A'ero ga hepiagi ita'ia'java'ea pyryheteva'ea ijara'ga pyri. He'yi itambere'ia hehe. A'ero ga hoi imondopava ombatera ojihugwi tombuhu ti g̃a ji ve itambere'ia mbatera pe javo. A'ero ga itambere'ia rerohoi imondovo ijara'ga pe imbuhuruka ojive ita'ia'java'ea pyryheteva'ea pérolapyryhetea ipojykavo, ei Jesus'ga na jitehe pyryheteva'ea tuhẽ ko aherekoa Tupana'gareheva'ero javo. ");
INSERT INTO pahNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","—Marã po ti hekoi nehẽ yvyakotyve'g̃a pe g̃a erame Tupana'ga nhanderuvihavuhuhetero oko javo? A'ea rehe po ti ji pe mbo'ei ikwahavuka pe me imombe'gwovo a'ea'java'ea nehẽ, ei Jesus'ga. Pira mboahava pirareheve'g̃a imombori ypiahu pe imbo'aparavuhupava pira, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Imboahava tynahẽ hete. A'ero yembeyvyri pe g̃a heruri inog̃a. Oapy g̃a imo'emo'eamo. Pirapyryva g̃a imondoi hyrua pype imohina. Pirate'varuhua g̃a imombori, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","—Aerẽ na jitehe po ti Tupana'ga yvyakotyve'g̃a nderekoukari mbapava koty nehẽ. Mbapava koty po ti gapyrive'g̃a nduri ite'varuhuve'g̃a nderogwovo Tupana'ga nhi'ig̃areheve'g̃a pytera hugwi nehẽ, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Hahyva'ea ruvihava pype po ti g̃a ite'varuhuve'g̃a mombori nehẽ. Tataheteuhua koi hahyva'ea ruvihava. Pevo po ti g̃a jehe'oi ojihe onhimonha'ngavo hahyrame ojive nehẽ, ei Jesus'ga. A'ea Jesus'ga omombe'u ojo'java'ea. ");
INSERT INTO pahNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","—Marã? Pekwaha pe penhimombaragwahava nhiremimbo'eagwera rehe nhaporemo ji pe mbo'erame ojo'java'ea pyvõ? Marã? ei Jesus'ga g̃wemimbo'ehara'g̃a pe. —Orokwaha pa ore akoja neremimbo'eagwera, ei g̃a. ");
INSERT INTO pahNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","A'ero Jesus'ga ei g̃a pe: —Judeus'g̃a mbo'ehara'g̃a ikwahaparavuhui ji ombo'erame, ei Jesus'ga. A'ereki g̃a okwahavypy ymyahũva'ea aheremimbo'eagwera. Aerẽ ji g̃a mbo'ei ipyahuva'ea rehe javo g̃a pe: Nahanahã hekoi yvyakotyve'g̃a pe g̃a erame Tupana'ga nhanderuvihavuhuhetero oko javo. A'ero g̃a ikwahavi a'ea no. G̃a ko onga jara'ga ja a'ero, ei Jesus'ga. A'ereki onga jara'ga g̃weno'ẽ ymyahũva'ea ipyahuva'ea reheve ombaterahetea hugwi ombatera rerekokatuhava hugwi, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","G̃a mbo'epavame ojo'java'ea pyvõ Jesus'ga hoi pea hugwi ogwovo. ");
INSERT INTO pahNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Ogwyri pe ga ruri ocidade de Nazaré pe ovahema. Pevo ga g̃a mbo'ekatukatui g̃ajatykahava pype. A'ero g̃a nhimomby'ai ga rehe. A'ero g̃a ei ojohupe: —Ma'g̃a po ga mbo'ehetei ikwahavukaheteavo ga pe? Ma'g̃a po ga mbopopoaka japovouka ga pe ahemonhimomby'ava'ea? ei g̃a. ");
INSERT INTO pahNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Ga onga apohara'ga ra'yra'ga rũi naerũ? ei g̃a. Gayhẽa, hẽa ko Mariahẽa. Gairũ'g̃a ko Tiago'ga, José'ga, Simão'ga, Judas'ga. Tikwaha pa nhande g̃a. ");
INSERT INTO pahNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Garendyra'g̃a u pa nhande pyri. Ymyava'ea atyvi ga ag̃wamo. Maraname ga ikwahapavi naerũ? ei g̃a. ");
INSERT INTO pahNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Igwaigwavete g̃a ndokoi ga rehe ga arõe'yma a'ero. A'ero Jesus'ga ei g̃a pe: —Ojipe'g̃a gwyripeve'g̃a omondo gweaporog̃ita imohina Tupana'ga nhi'ig̃a mombe'uhara'g̃a ndehe. G̃agwyripeve'g̃a jate nomondoi imohina g̃a ndehe g̃anongapypeve'g̃a pavẽi, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ndahe'yi reki Jesus'ga rembiapoa a'ero ahemonhimomby'ava'ea pevo g̃a pe. A'ereki g̃a ndojikogi ga rehe. ");
INSERT INTO pahNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Aerẽ Herodes'ga hendupavi g̃a Jesus'ga mombe'urame. G̃a omombe'u Jesus'ga remimonhimomby'ava'ea mombe'urame no. Herodes'ga ko omondomondo Galiléiapeve'g̃a g̃wemimbotarimova'ea rupi g̃agwyri pe. ");
INSERT INTO pahNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Jesus'ga mombe'ua renduvame Herodes'ga etehei ojipyrive'g̃a pe: —Jesus'ga ko João Batista'ga. Ovy João Batista'ga gwyvya hugwi okwerava, ei ga. Nurã ga japoi ahemonhimomby'ava'ea, e'i tehe Herodes'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Nahã Herodes'ga ei. A'ereki João Batistava'ea manoa renonde Herodes'ga João Batistava'ea pyhyguka ahe kwaruka itanhuramuhũa pyvõ ahe mongiuka cadeia pype. Herodiashẽa rehe Herodes'ga opyhyguka João Batistava'ea raikwehe. Herodiashẽa ko Herodes'ga irũ'ga rembirekoro na'ẽ oko, Filipe'ga rembirekoro. Kirẽ Herodes'ga hẽa rereko raikwehe. ");
INSERT INTO pahNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Nurã João Batistava'ea e'ie'i Herodes'ga pe: —Maranameuhũ nde hẽa rerekoi? Po ahe ndogwerekoi te hẽa! ei João Batistava'ea Herodes'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Ndopotari Herodes'ga ahe'ea ojive. Nurã ga ahe mongiuka cadeia pype ahe jukapota. Ndojukaukari reki ga ahe. A'ereki ga okyhyji judeus'g̃a hugwi. A'ereki g̃a e'i: —João Batista'ga ko Tupana'ga nhi'ig̃a mombe'uhara'ga, ei g̃a onhimongyavo. ");
INSERT INTO pahNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Aerẽ o'aragwera rupi Herodes'ga oapo toryva. A'ero Herodiashẽa ra'yrahẽa tehe ojiroky g̃andovai pyteri pe – kiroki g̃a uhu toryva repiaga. Ikatu Herodes'ga pe hẽajirokya. ");
INSERT INTO pahNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","A'ero ga e'i hẽa pe: —Gara nde erepota imondoa ejive? ei ga. Amondo tuhẽ po ti ji nde ve nehẽ. Tupana'ga ji'ea renduvame ji ei poro nde ve. A'ea Herodes'ga e'i Herodiashẽa ra'yrahẽa pe. ");
INSERT INTO pahNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","A'ero hẽayhẽa e'i hẽa pe: —Ere ti Herodes'ga pe: “Embuhu ti ji ve kiro João Batista'ga akag̃a nhaembeva pype.” Nahã ti ere ga pe, ei hẽa gwa'yrahẽa pe hẽa mbo'eavo. —Kwa, ei hẽa oyhẽa pe. Nurã kiro hẽa e'i Herodes'ga pe: —Embuhu ti ji ve kiro João Batista'ga akag̃a nhaembeva pype, ei hẽa. ");
INSERT INTO pahNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","A'ea renduvame Herodes'ga ndovy'ari. Toryvarupive'g̃a g̃wendu ga'eagwera hẽa pe ga erame: “Gara nde erepota imondoa ejive? Amondo tuhẽ po ti ji nehẽ. Tupana'ga ji'ea renduvame ji ei poro nde ve.” Nurã ga e'i kiro ojipyrive'g̃a pe: —Peko ti hẽanhi'ig̃a rupi a'ero. ");
INSERT INTO pahNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Peho ti cadeia pype ga jukavo ga'akag̃a momboa herua hẽa pe, ei ga. ");
INSERT INTO pahNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","A'ero g̃a oho João Batistava'ea jukavo aheakag̃a rerua nhaembeva pype imondovo hẽa pe. Hẽa gweroho oyhẽa pe a'ero herovahema. ");
INSERT INTO pahNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","João Batistava'eareheve'g̃a uhu a'ero ahera'oa rerogwovo ityma. Aerẽ g̃a oho Jesus'ga pyri imombe'gwovo ahemanoa ga pe. Nahã ko João Batistava'ea manoa raikwehe. Herodes'ga nomoka'nhymi kiro João Batistava'ea akag̃a imomborukaragwera. Nurã henduvame Jesus'ga remimonhimomby'ava'ea Herodes'ga ei: —Jesus'ga ko João Batista'ga. Ovy João Batista'ga gwyvya hugwi okwerava, ei Herodes'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Herodes'ga nhi'ig̃a kwahavame Jesus'ga hoi yhara pype ypiahua aherovai ogwovo ongae'ỹi me tajipe'a ti ji avove'g̃a hugwi javo. Gahoa kwahavame he'yive'g̃a hoi opyvo cidades hugwi ogwovo ypiahua rembeyvyra rupi. Nahã g̃a vahemypyi aherovai Jesus'ga rovatiamo tihendu ti ga javo. ");
INSERT INTO pahNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Jesus'ga g̃a ndepiagi pevo ohemame yhara hugwi a'ero. Oporogwety ga g̃a. Omombi ga karugwara g̃apyteripeve'g̃a hugwi itetirũave'g̃a hugwi. ");
INSERT INTO pahNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ka'arugame dozeve'g̃a Jesus'ga remimbo'ehara'g̃a nduri ga pyri. Ga pe g̃a ei a'ero: —Ka'aru hete kiro. Agwa'g̃a ndo'ui ve reki. Nurã ti emondouka g̃a avo hugwi, ei g̃a. Ahã onga avo. Toho ti g̃a cidades'i pe ira'agweva'e pe ipyhyga mbatera. Pevo po ti g̃a hoi i'gwovo nehẽ. A'ea Jesus'ga remimbo'ehara'g̃a ei Jesus'ga pe g̃a mondouka pota ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","—Tohoyme po ti g̃a hamo, ei Jesus'ga g̃a pe. Pehe ti pemondo mbatera g̃a pe to'u ti g̃a javo, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","A'ero g̃a ei ga pe: —Ndorogwerekoi te! ei g̃a. Cinco pães orogwereko dois pira reheve. Ndohygi'i'i po ti g̃a ndehe nehẽ, ei g̃a. ");
INSERT INTO pahNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","—Peru ti ji ve a'ero, ei Jesus'ga g̃a pe. —Kwa, ei g̃a herua. ");
INSERT INTO pahNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Pevove'g̃a pe Jesus'ga ei: —Peapy ti yvyvo nhungwava rehe, ei ga g̃a pe. Oapy g̃a a'ero. ");
INSERT INTO pahNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Kiro ga ipyhygi mbatera – kiroki cinco pães dois pira reheve. Ojovavu ga yvaga repiaga. —Ndepyry hete nde imbuhua ore ve, ei Jesus'ga Tupana'ga pe. Kiro Jesus'ga haygwe'rogwe'rogi pães imondomondovo g̃wemimbo'ehara'g̃a pe pira reheve. Kiro g̃a imondomondoi g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Kiro g̃a nhaporemo i'ui onhimoytaromouka. G̃a i'urẽ Jesus'ga remimbo'ehara'g̃a imono'og̃i hembyruera imondovo yrua pype. He'yjuhuva'ea hembyruera opyta reki garembihaygwe'rogagwera. A'ereki g̃a ndo'upavi. He'yjuhuva'ea dozeva'ea yrua tynahẽ. Kiroki g̃a o'u pevo Jesus'ga pyri – g̃a ko he'yjuhu hete ranuhũ. Cinco milve'g̃a o'u akwaimba'ero. Kunhangwera'g̃a tayri'g̃a pavẽi i'ui no. Nahã Jesus'ga japoi ahemonhimomby'ava'ea he'yje'ỹva'ea imbovua imondovo g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","G̃a imono'ombavirẽ hembyruera Jesus'ga ei g̃wemimbo'ehara'g̃a pe g̃a mondovouka: —Pe'a ti yharuhua pype, ei ga. Peho ti ji renonde ypiahua aherovai, ei ga g̃a pe. Apyta na'ẽ po ti ji avo agwa'g̃a mondovo nehẽ, ei Jesus'ga. —Kwa, ei g̃a. A'ero g̃a avi herogwovo. ");
INSERT INTO pahNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Jesus'ga pytai a'ero pevove'g̃a mondovo g̃anonga pe. G̃a horame ga tehe oho yvytyruhua rupi opytavo pevo tanhi'ĩ ti Tupana'ga pe javo. Pevo ga pytai onhi'ig̃a Tupana'ga pe imongaruheteavo. ");
INSERT INTO pahNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","A'ea rupi garemimbo'ehara'g̃a ndekoi ypiahua pyteri pe. Ombohembohe hete yharuhua yvytua rerekovo. Yvytua ipopoaka yhara mondoukare'yma aherovai. ");
INSERT INTO pahNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Ko'eg̃werĩrame Jesus'ga hoi yhya arimo ogwovo g̃a pyri. ");
INSERT INTO pahNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Garemimbo'ehara'g̃a garura repiagame g̃apy'a omyi. —Anhag̃a po uhu yhya arimo! ei g̃a. Hahẽahẽ g̃a okyhyjiavo. ");
INSERT INTO pahNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Kotihĩ Jesus'ga ei a'ero: —Penog̃atu ti pejipy'a. Tapekyhyjia'javi ti. A'ereki ji tuhẽ ako, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","A'ero Pedro'ga ei Jesus'ga pe: —Po nde Jesus Cristoramo hamo, yhya arimo po ti nde ji mbuhuri ejipyri nehẽ hamo, ei ga. ");
INSERT INTO pahNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","—Ejo ti, ei Jesus'ga ga pe a'ero. A'ero Pedro'ga hemi yhara hugwi ogwovo yhya arimo ogwovo Jesus'ga pyri. ");
INSERT INTO pahNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Aerẽ ga kyhyji reki. A'ereki ipopoaka yvytua. A'ero ypy pe ohog̃werĩrame ga hapukai Jesus'ga pe: —Ji pyhy! ei ga Jesus'ga pe opojykaharete'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Kotihĩ Jesus'ga opoa mondoi ga pe ga pyhyga. —Nderejikogi nde ji rehe, ei Jesus'ga ga pe. Garamo nde ndajireroviarihu Jesus'ga po nanhimondokatui yhya arimo javo? ei Jesus'ga Pedro'ga pe. Nurã nde hoi gwerevi ypy pe, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Jesus'ga avame yhara pype Pedro'ga pavẽi ndura'javi yvytua. ");
INSERT INTO pahNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Jara'g̃a yhara pypeve'g̃a nduri Jesus'ga pyri ga mboheteavo. —Tupana'ga ra'yra tuhẽ ko nde, ei g̃a ga pe g̃wenypy'amo ga pyri. ");
INSERT INTO pahNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ogwovo Jesus'ga herohoi ypiahua aherovai a'ero herovahema Genesarépeve'g̃a gwyri pe. ");
INSERT INTO pahNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ikwahavame Jesus'g̃a ndura pevove'g̃a omondomondo onhi'ig̃a ojohupe ga mombe'gwovo ogwyripeve'g̃a pe nhaporemo. Nahã g̃a g̃a momorandupavi. Henduvame g̃a itetirũave'g̃a mbojatykapavi g̃a nderua Jesus'ga pyri g̃a nderovahema. ");
INSERT INTO pahNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","—Na ti itetirũave'g̃a pokogi ndepira rembeyvyra rehe nehẽ, ei g̃a. Po ti g̃a pokogi hehe vehevi, a'ero po ti g̃atetirũa ipigi g̃a hugwi nehẽ, ei g̃a Jesus'ga pe. Kiroki g̃a opoko gapira rehe – g̃a hugwi g̃atetirũa pigi a'ero. ");
INSERT INTO pahNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Aerẽ g̃a nduri Jesus'ga pyri Jerusalém hugwi fariseus'g̃a judeus'g̃a mbo'ehara'g̃a pavẽi. Ovahemame g̃a ei Jesus'ga pe: ");
INSERT INTO pahNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","—Maranameuhũ neremimbo'ehara'g̃a nohendukatui nhaneramonhava'ea remimbo'eagwera naerũ? Nhaneramonhava'ea e'i: “Nahanahã nhande xajipogwei katu. Nhandejipogweikaturo g̃waramo nhande nhimombyryvi Tupana'ga pe.” Nahã nhaneramonhava'ea ei nhande mbo'embo'eavo. Na rũi neremimbo'ehara'g̃a jipogwei i'ua renonde nahã ojikwakuve'yma, ei g̃a Jesus'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","—Pehe no, ei Jesus'ga g̃a pe. Maranameuhũ pe napehendukatui Tupana'ga nhi'ig̃a? ei Jesus'ga. Tupana'ga erame nahanahã ti peko javo pe ndapekoi ganhi'ig̃a rupi. Penhimimbo'ea rupi jate reki pe ndekoi pejikovo Tupana'ga nhi'ig̃aatyviva'ea rupi, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Ymyahũ Tupana'ga ei: “Pemondo ti pejeaporog̃ita imohina pejuva'g̃a ndehe penhy'g̃a ndehe no,” ei Tupana'ga hako, ei Jesus'ga. “Kiroki ga e'i te'varuhu uva'ga pe oyhẽa pe no – tojukauka ti g̃a ga a'ero,” ei Tupana'ga hako, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","—Pe ki a'e te Tupana'ga nhi'ig̃aatyviva'ea rehe pe g̃a mbo'ei, ei Jesus'ga. Po g̃a ei uva'g̃a pe oy'g̃a pe no: “Apoko pota ji imondovo mbatera pe me novĩa. Emo ji amondo akoja Tupana'ga pe,” ei g̃a g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Pe'e pe g̃a pe a'ero: “Nanongara pyry!” Nahã pe g̃a mbo'ei pejikoe'yma Tupana'ga nhi'ig̃a rehe, ei Jesus'ga g̃a pe. A'ereki g̃a erame a'ea g̃a nomondoi ojeaporog̃ita imohina uva'g̃a ndehe oy'g̃a ndehe no. Ndopokogi g̃a uva'g̃a oy'g̃a ndeheve a'ero imondoe'yma g̃a pe. Nahã g̃a ndekote'varuhui, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","—Pehe ko pekokatu'ãva'ero, a'e ji pe me a'ero, ei Jesus'ga g̃a pe. Ymyahũ Isaíasva'ea pe mombe'u katu jipe Tupana'ga nhi'ig̃a mombe'urame hako. A'ereki ahe e'i: ");
INSERT INTO pahNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","“‘Avove'g̃a onhi'ig̃atu tehe ji ve torombohete Tupana'ga javo,’ ei Tupana'ga. ‘Emo g̃a nanhiarõi imondoe'yma gweaporog̃ita imohina ji rehe. ");
INSERT INTO pahNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Ji mbohete tehe g̃a. A'ereki nhinhi'ig̃a rehe rũi g̃a ombo'e. Yvyakotyve'g̃a nemimbo'ea rehe g̃a g̃a mbo'ei a'ea ko Tupana'ga nhi'ig̃a javo tehe jupe,’ ei Tupana'ga,” ei ahe hako, ei Jesus'ga fariseus'g̃a pe judeus'g̃a mbo'ehara'g̃a pe no. ");
INSERT INTO pahNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Jesus'ga g̃a mbuhuri ojipyri pevove'g̃a he'yjuhuve'g̃a. A'ero ga ei g̃a pe: —Pehendu ti ikwahava, ei ga. ");
INSERT INTO pahNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Kiroki oki nhandejurua pype – a'ea nianembote'varuhui. Kiroki ohẽ nhandejurua hugwi – a'ea nhande mbote'varuhu, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","A'ero Jesus'ga remimbo'ehara'g̃a nduri ga pyri javo ga pe: —A'ea nde erame fariseus'g̃a nhimonha'ngai nenhi'ig̃a arõe'yma. Erekwaha nde? ei g̃a Jesus'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","A'ero Jesus'ga ei g̃a pe: —Jiruva'ga yvagipeve'ga po ti o'o pa g̃wemitymipyrarũiva'ea nehẽ, ei Jesus'ga. Tupana'ga nhi'ig̃aatyviva'ea pe g̃anemimbo'ea pe Jesus'ga ei: Tupana'ga remitymipyrarũiva'ea. Tupana'ga po ti omombi pa g̃anemimbo'ea nehẽ. ");
INSERT INTO pahNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","—Na g̃a ndekojate a'ero fariseus'g̃a, ei Jesus'ga. G̃a ko heakwagweve'g̃a ja – kiroki g̃a gweroho pota oji'jave'g̃a, ei Jesus'ga. Po heakwagweve'ga gweroho ojipe'ga – kiroki ga ga ja ndohepiagi, a'ero po ti g̃a memei ohi ikwara pype nehẽ. A'ereki g̃a memei ndohepiagi, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","A'ero Pedro'ga ei Jesus'ga pe: —Ore mbo'e katu ti ojo'java'ea rehe. A'ereki ndorokwahavi a'ea. Maraname nde ei akoja ore ve? “Kiroki oki nhandejurua pype – a'ea nianembote'varuhui. Kiroki ohẽ nhandejurua hugwi – a'ea nhande mbote'varuhu,” ere nde. A'ea rehe ti ore mbo'e katu a'ero, ei Pedro'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","A'ero Jesus'ga ei Pedro'ga pe: —Maranuhũ pehe ndapekwahavi no? ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Kiroki oki nhandejurua pype – a'ea oho nhanderevega pype ohema nhande atarame. —Maranuhũ pe ndapekwahavi naerũ? ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Kiroki ohẽ nhandejurua hugwi – a'ea ohẽ nhandeyvytera hugwi nhande mbote'varuhuavo, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Po pejiyvyteri pe pe ndeaporog̃itate'varuhuro, a'ero pejiyvyteri pe pe ei na'ẽ penhimonha'ngavo tijuka ti ga javo ga pe. A'ero po pe ga jukai. Pe ei na'ẽ pejiyvyteri pe tiroho ti garembirekohẽa ga hugwi javo hẽa pe. A'ero po pe hẽa rerohoi pejive. Pejiyvyteri pe pe ei na'ẽ tireko te'varuhu ti g̃a javo g̃a pe. A'ero po pe g̃a nderekote'varuhui, ei Jesus'ga. Pe'e pe: Timi ti. Pe'e pe: Xa'mbe ti g̃a pe. Pe'e pe: Timbotegwete ti g̃a. A'ea nhaporemo pe ei pejiyvyteri pe. Nahã pe ndekote'varuhui a'ero, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Pendeaporog̃itate'varuhua nhaporemo pe mbote'varuhu, ei Jesus'ga. —Tupana'ga nhi'ig̃aatyviva'ea fariseus'g̃a omombe'u ahembo'ehara'g̃a pavẽi g̃a erame: “Nahanahã po ti nhande xajipogwei xanhimombyry ti Tupana'ga pe javo.” G̃ahã e'i a'ea. Jihi ki a'e te a'e pe me: Po nhande ndiajipogwei i'gwovo, a'ero nhande nianhimbote'varuhui, ei Jesus'ga. A'ereki nhandejipogweja nomombyryvi nhandereaporog̃ita, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Aerẽ Jesus'g̃a hoi pea hugwi ogwovo. Cidades koty Tiro koty Sidom koty g̃a hoi ogwovo yhya rembeyvyra rupi. ");
INSERT INTO pahNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Pea hugwi hẽa ruri Jesus'ga rovatiamo – kiroki cananéiahẽa judeurũivehẽa. —Jipojykaharetero ko nde Daviva'ea rymyminoro no! ei hẽa Jesus'ga pe. A'ea hẽa ei ga pe. A'ereki hẽa e'i oyvyteri pe: “Ga pe Tupana'ga e'i eko ti g̃anduvihavuhuhetero javo.” —Ji porogwety! ei hẽa Jesus'ga pe. Anhag̃a opojyka jira'yrahẽa okote'vate'varuhuavo hẽa pe, ei hẽa. ");
INSERT INTO pahNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Jesus'ga nonhi'ig̃i reki hẽa pe. A'ero garemimbo'ehara'g̃a nduri ga pyri javo ga pe: —Emondo ti hẽa nhande hugwi. A'ereki hẽa uhuruhu nhande reviri ohapukaita okovo ji poko javo, ei g̃a Jesus'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","A'ero Jesus'ga ei: —Tupana'ga ji mbuhuruka jigwyripeve'g̃a pyri israelitas'g̃a pyri. “G̃a pyri jate ti eho g̃a pokoga,” ei Tupana'ga ji ve, ei Jesus'ga. “G̃a ko ovelhas ja. Ovelhas oka'nhy jipi herekoe'ymame gwepiakatuharamo. Akoja ja ko g̃a ika'nhyva'ea ja,” ei Tupana'ga, ei Jesus'ga. Judeus'g̃arũive'g̃a pyri rũi Tupana'ga ji mbuhurukari, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","G̃wendu po hẽa Jesus'ga nhi'ig̃a ua Jesus'ga pyri g̃wenypy'amo garovai pyteri pe nde ko jihoheva'ero javo. —Ji poko ti! ei hẽa Jesus'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","A'ero ga ei hẽa pe: —Ndapyryvi ji ipyhygi tayri'g̃a mbatera imomboa nhag̃watig̃a pe to'u ti javo. Nahã Jesus'ga ei ndapyryvi ji judeus'g̃arũive'g̃a pokogi javo. ");
INSERT INTO pahNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","—A'iti a, ei hẽa. Emo nhag̃watig̃a vehevi reki o'u hembyrue'ria – kiroki ohi ijara'g̃a i'urame, ei hẽa. Nahã hẽa ei aerẽ po ti nde judeus'g̃arũive'g̃a pokogi no javo. ");
INSERT INTO pahNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","A'ero Jesus'ga ei hẽa pe: —Kui'i, ei ga hẽa pe. Erejiko hete nde ji rehe ji poko po ti ga nehẽ javo, ei Jesus'ga. Oropoko ti jihi kiro, ei ga hẽa pe. Nanime Jesus'ga anhag̃a mbojipe'ai hẽara'yrahẽa hugwi nahã hẽa pokoga. ");
INSERT INTO pahNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Aerẽ Jesus'ga hoi pea hugwi ogwoogwovo ypiahua rembeyvyri Galiléia rembeyvyri okovo. Yvytyruhua arimo ga hoi oapyga oina. ");
INSERT INTO pahNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ga pyri he'yjuhuve'g̃a ndug̃anduri itetirũave'g̃a nderunderua. Gweru g̃a ipyka'naka'nave'g̃a heakwagweve'g̃a ndeheve onhi'ig̃e'ỹve'g̃a ndeheve ika'naka'nave'g̃a ndeheve ojipe'g̃a ndeheve he'yive'g̃a. G̃ahã g̃a g̃a nderuri g̃a mondovo g̃a nog̃a Jesus'ga pyri topohano ti ga g̃a javo. A'ero Jesus'ga imombigi g̃atetirũa g̃a hugwi. ");
INSERT INTO pahNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","A'ero g̃a nhimomby'ai hepiaga g̃atetirũa mombiga. A'ereki onhi'ig̃e'ỹve'g̃a onhi'ĩ reki. Gwepia g̃a Jesus'ga ika'naka'nave'g̃a nda'oa imombyryvame. Ipyka'naka'nave'g̃a ami ogwovo reki. Heakwagweve'g̃a gwepia reki. A'ero pevove'g̃a Tupana'ga mbohetei onhimongyavo okwaha hete Tupana'ga Israelva'ea rakykwepohara'g̃a nduvihavuhuhete'ga javo. ");
INSERT INTO pahNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Aerẽ Jesus'ga ei g̃wemimbo'ehara'g̃a pe: —Pejo ti ji pyri. G̃a ndurame ga pyri ga ei g̃a pe: —Iporia'i g̃a ji ve avove'g̃a he'yjuhuve'g̃a. A'ereki g̃a ndogwerekoa'javi mbatera dois okira g̃waramo ji pyri, ei Jesus'ga. Namondoukapotari ji g̃a g̃anonga pe g̃a i'ue'ymame. A'ero po ti g̃a pytupavamo pehea rupi g̃we'ouhũro nehẽ, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Jesus'ga remimbo'ehara'g̃a ei ga pe: —Ma hugwi po ti nhande ipyhygi he'yjuhuva'ea mbatera g̃a pe avo ongae'ỹi me tokogahi ti g̃a javo? ei g̃a. ");
INSERT INTO pahNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","A'ero Jesus'ga ei g̃a pe: —Maramomi pe herekoi pães? —Sete, ei g̃a ga pe. Mokoi'ĩ pira'ia orogwereko no, ei g̃a. ");
INSERT INTO pahNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Pevove'g̃a pe Jesus'ga ei: —Peapy ti yvyvo, ei ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Kiro ga ipyhygi mbatera – kiroki sete pães pira'ia reheve. A'ea rehe ga nhi'ig̃i Tupana'ga pe ndepyry hete nde imbuhuruka javo. A'ero ga haygwe'rogwe'rogi pães pira'ia reheve imondomondovo g̃wemimbo'ehara'g̃a pe. Kiro g̃a imondomondoi pevove'g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","A'ero g̃a nhaporemo i'ui onhimoytaromo. G̃a i'urẽ Jesus'ga remimbo'ehara'g̃a imono'og̃i hembyruera imondovo yrua pype. He'yjuhuva'ea hembyruera opyta reki garembihaygwe'rogagwera. A'ereki g̃a ndo'upavi. He'yjuhuva'ea seteva'ea yrua tynahẽ. ");
INSERT INTO pahNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Kiroki g̃a o'u pevo Jesus'ga pyri – g̃a ko he'yjuhu hete ranuhũ. Quatro milve'g̃a ko o'u akwaimba'ero. Kunhangwera'g̃a tayri'g̃a pavẽi i'ui no. Nahã Jesus'ga japoi ahemonhimomby'ava'ea he'yje'ỹva'ea imbovua imondovo g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","A'ero Jesus'ga pevove'g̃a mondoukari g̃anonga pe. G̃a horame ga avi yharuhua pype herogwovo aherovai herovahema ypiahua rembe'yi pe cidade de Magadã me. ");
INSERT INTO pahNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Aerẽ fariseus'g̃a nduri Jesus'ga pyri saduceus'g̃a pavẽi ovahema. —Tihepia ti gapopoakara, ei g̃a ojohupe. Mara'ngu po Tupana'ga okovo ga pyri ga mbopopoaka? Tupana'ga ga mbopopoakare'ymame po ti nhande ga mbotegwetei, ei g̃a ojohupe. Nurã g̃a ei Jesus'ga pe: —Eapo ti ahemonhimomby'ava'ea. Torohepia ti, ei g̃a ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","A'ero Jesus'ga ei reki g̃a pe: —Ka'aru ig̃wag̃ahivame yvaga pe ei: “Ko'emame po ti kwara ima'eg̃atui nehẽ.” Nahã pe ei, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","—Ypyhajive ig̃wag̃ahivame yvaga hovapitymbyguhurame pe ei: “Amana po ti ikyri nehẽ.” Nahã pe ei, ei Jesus'ga. —Pehepia pe yvaga ikwahava aerẽva'ea ima'eg̃atua. Hepiaga'javame pe pekwaha aerẽva'ea ikyra. A'ea pe pekwaha katu, ei Jesus'ga g̃a pe. Emo imbaragwahave'ỹve'g̃a ja po pe reki. Pehepia tehe pe ojipeva'ea ag̃wamova'ea – kiroki a'ea okwahavuka aerẽva'ea. Emo pe napembaragwahavi reki aerẽva'ea rehe, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","—Ag̃wamova'ero peko te'varuhu pa pe, ei Jesus'ga g̃a pe. Ndapekoi pe Tupana'ga nhi'ig̃a rehe pejikoge'yma ga rehe. Pe'e pe: “Jesus'ga japorame jate nhande ve ahemonhimomby'ava'ea, a'ero po ti nhande ei ikwahava nehẽ: Tupana'ga ga poko. A'ea po ti nhande xa'e hepiagame nehẽ.” A'ea pe ei, ei Jesus'ga. Ndoapoukari po ti Tupana'ga ojipea ahemonhimomby'ava'ea pe me nehẽ. Ojikwe ymyahũ ga oapo ahemonhimomby'ava'ea Jonasva'ea mohemame onhi'ig̃a mombe'uharava'ea mohemame. A'ea jate po ti ga ikwahavukara'javi pe me nehẽ ji Jesus'ga poko javo. A'ea erame Jesus'ga hoi g̃a hugwi ogwovo. ");
INSERT INTO pahNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Ogwovo g̃a hugwi Jesus'ga herohoi herogwovo ypiahua aherovai g̃wemimbo'ehara'g̃a pavẽi. Omoka'nhy g̃a pão herohoe'yma ojupi. ");
INSERT INTO pahNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","A'ero Jesus'ga ei g̃a pe: —Penhimboko'i ti pão mbovuhava rehe fariseus'g̃a apoa rehe saduceus'g̃a apoa rehe no, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Garemimbo'ehara'g̃a nhomonhi'ig̃i a'ero. —Jesus'ga ei na. A'ereki nhande ndiheruri pão nhande rupi, ei g̃a ojohupe. ");
INSERT INTO pahNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","G̃anhi'ig̃a kwahavame Jesus'ga ei g̃a pe: —Maraname pe nhomonhi'ig̃uhũi nhande ndiheruri pão javo? Ndapejikogi'i'i pe ji rehe ndirekoi pão javo, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Napenhimombaragwahakatui pe ji'ea rehe? Ndapekwahava'javi pe cinco pães – akoja ji ahaygwe'rogwe'ro imondomondouka cinco milve'g̃a pe? Ndapekwahava'javi pe hembyruera? Maramomi yrua pype pe imono'ono'og̃i hembyruera? ");
INSERT INTO pahNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Ndapekwahava'javi pe sete pães? Akoja ji ahaygwe'rogwe'ro imondomondouka quatro milve'g̃a pe. Ndapekwahava'javi hembyruera? Maramomi yrua pype pe imono'ono'og̃i hembyruera? ");
INSERT INTO pahNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Maraname pe napenhimombaragwahavihu ji erame pe me kiro? Pão pe rũi ji ei pe me. A'e ji pe me: Penhimboko'i ti fariseus'g̃a apoa rehe saduceus'g̃a apoa rehe no. A'ereki g̃a'apoa ko pão mbovuhava ja, ei Jesus'ga g̃wemimbo'ehara'g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","A'ero Jesus'ga remimbo'ehara'g̃a nhimombaragwahavi ga'ea rehe. —Pão mbovuhava pe rũi Jesus'ga ei, ei g̃a a'ero. Fariseus'g̃a nemimbo'ea pe Jesus'ga ei. Saduceus'g̃a nemimbo'ea pe Jesus'ga ei no penhimboko'i ti g̃anemimbo'ea rehe javo, ei g̃a. ");
INSERT INTO pahNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Aerẽ Jesus'g̃a hoi cidade koty Cesaréia de Filipe koty. Ovahemame pevove'g̃a gwyri pe Jesus'ga ei g̃wemimbo'ehara'g̃a pe: —Marãi g̃a ji ve jipi? ei Jesus'ga g̃a pe okovo yvyakotyva'ero yvagipeva'ero no. ");
INSERT INTO pahNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","A'ero garemimbo'ehara'g̃a ei Jesus'ga pe: —Ojipe'g̃a ei nde ve: “Ga ko João Batista'ga,” ei g̃a nde ve, ei g̃a Jesus'ga pe. Ojipe'g̃a ei nde ve: “Ga ko Elias'ga.” Ojipe'g̃a ei nde ve: “Ga ko Jeremias'ga. Po Jeremiasva'ea rũi ga rekoi, a'ero ga oko ojipe'ga Tupana'ga nhi'ig̃a mombe'uharava'ea pyteripeve'ga.” Nahã g̃a ei nde ve, ei Jesus'ga remimbo'ehara'g̃a Jesus'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","A'ero Jesus'ga ei g̃a pe: —Pehe, marãi pe ji ve jipi? ");
INSERT INTO pahNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","A'ero Simão Pedro'ga ei ga pe: —Nde ko Cristoramo Tupana'ga remimbuhurukaramo ereko. Nde ko Tupana'ga ra'yramo avuiramave'ga ra'yramo ereko, ei Pedro'ga Jesus'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","A'ero Jesus'ga ei: —Simão, João'ga ra'yra, ei Jesus'ga Simão Pedro'ga pe. Pyry hete nde ve nde a'ea kwahavame Jesus'ga ko Cristoramo Tupana'ga ra'yramo javo. A'ereki yvyakotyve'g̃a rũi okwahavuka nde ve. Jiruva'ga reki yvagipeve'ga ikwahavukari nde ve ga ko Cristo'ga jira'yra'ga javo, ei Jesus'ga Pedro'ga pe. A'itituhẽva'ea pe nde ei. ");
INSERT INTO pahNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","—Jihi a'e nde ve a'itituhẽva'ea pe kiro no. Nderera ko Pedro. Ita xa'e nhande jupe. Ita ndojijyi upa. Na jitehe po ti jireheve'g̃a nhaporemo ndogwerojijyi ojeaporog̃ita ojikopige'yma ji rehe nehẽ. A'ereki ji ambojiko hete g̃a ji rehe topohiryme ti g̃a ji hugwi javo nehẽ. Omanorame vehevi po ti g̃a kweravi mbapava koty okovo avuirama Tupana'ga pyri nehẽ, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","—Na tuhẽ. Tupana'ga rekorame yvyakotyve'g̃a nduvihavuhuhetero avo yvya koty g̃a mongovo onhi'ig̃a rupi, a'ero po ti ji nde mbopopoakari nehẽ, ei Jesus'ga Pedro'ga pe. A'ero po ti nde ei jireheve'g̃a pe nehẽ: “Nahanahã ti tapekoi.” Po a'ea nenhi'ig̃a, a'ea ko Tupana'ga nhi'ig̃a no, ei Jesus'ga Pedro'ga pe. Ojipea po ti nde ei nehẽ: “Nahanahã ti peko.” Po a'ea nenhi'ig̃a, a'ea ko Tupana'ga nhi'ig̃a no. ");
INSERT INTO pahNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","A'ea mombe'urẽ Pedro'ga pe Jesus'ga ei g̃wemimbo'ehara'g̃a pe: —Tapemombe'ui ti g̃a pe Jesus'ga ko Cristoramo Tupana'ga remimbuhurukaramo javo, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Kiro Jesus'ga nhimombe'ua'jaa'javi g̃wemimbo'ehara'g̃a pe nahanahã po ti ji ve nehẽ javo. —Taho ti ji cidade de Jerusalém me, ei Jesus'ga g̃a pe. He'yiva'ea po ti g̃a imondomondoi hahyva'ea ji ve nehẽ xava'eve'g̃a ikwava'ẽhara'g̃a nduvihava'g̃a pavẽi judeus'g̃a mbo'ehara'g̃a pavẽi no. A'ero po ti g̃a ji jukaukari nehẽ. Mokõi ji kirirẽ po ti nhimbogwerahava nehẽ, ei Jesus'ga g̃a pe. Nahanahã Jesus'ga imombe'ui aerẽva'ea onhimombe'gwovo g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","A'ero Pedro'ga ga rerohoi irupe'i onhi'ig̃ahyavo Jesus'ga pe. —Na rũi po ti nde ve hahyhetea nehẽ! ei Pedro'ga ga pe. Tupana'ga ti tomombi g̃a tandejukaukaryme g̃a pe javo, ei ga Jesus'ga pe opojykaharete'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Opyryrỹ Jesus'ga javo Pedro'ga pe: —Ejipe'a ti ji hugwi! A'ereki Satanás'ga nde monhi'ĩ. Nurã nde ei nanongara, ei Jesus'ga Pedro'ga pe. Eremombi pota nde jirekoa Tupana'ga nhi'ig̃a rupi. Tupana'ga reaporog̃ita atyvi ndereaporog̃ita. A'ereki Tupana'ga opota reki nhimanoa. Yvyakotyve'g̃a ndeaporog̃ita rehe nde ereko, ei Jesus'ga Pedro'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Kiro Jesus'ga ei g̃wemimbo'ehara'g̃a pe: —Kiroki g̃a oko pota nhiremimbo'eharamo – tokoyme ti g̃a g̃wemimbotarimova'ea rupi okovo nhiremimbotarimova'ea rupi, ei Jesus'ga g̃a pe. Po ti ojipe'g̃a imbohahyukari g̃a pe g̃a jukavo vehevi nehẽ peko pe Jesus'ga reheva'ero javo g̃a pe, toko jitehe ti g̃a nhiremimbotarimova'ea rupi opohire'yma ji hugwi. ");
INSERT INTO pahNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","—Kiroki g̃a ndokopotari nhiremimbo'eharamo tajijukayme ti g̃a javo – g̃a po ti omano ogwovo hahyva'ea ruvihava pype nehẽ, ei Jesus'ga. —Kiroki g̃a ojipe'g̃a g̃a jukai g̃a jikoga g̃waramo ji rehe – omanorẽ po ti g̃a oho upa avuirama Tupana'ga pyri nehẽ, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","—Ojipe'g̃a – kiroki g̃a e'i: “Ndakoi ti ji Jesus'ga remimbo'eharamo tamono'ono'õ ti ji mbatera jijive javo” – po g̃a imono'ono'ombavi mbatera ojive avo yvya koty, a'ero g̃a imono'ono'õtehei ojive novĩa ogwovo hahyva'ea ruvihava pype, ei Jesus'ga. A'ereki ahã g̃a pe g̃ahohava Tupana'ga pyri. A'ereki ahe nomondoi mbatera ohohava kwepykavamo ohorame Tupana'ga pyri, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","—Aerẽ po ti ji rura'javi avo yvyakotyve'g̃a pyri Tupana'gapyrive'g̃a pavẽi yvagipeve'g̃a pavẽi nehẽ. Jiruva'ga rendy'jandy'java pyteri pe po ti ji rekoi jijoa nehẽ yvyakotyva'ero yvagipeva'ero no. A'ero po ti ji ikwepygi yvyakotyve'g̃a pe nehẽ. Po g̃a ndekokatui nhinhi'ig̃a rendukatukatuavo, a'ero po ti ji rekokatui g̃a pe nehẽ, ei Jesus'ga. Po g̃a ndekote'varuhui nhinhi'ig̃a renduve'yma, a'ero po ti ji imondoi hahyva'ea g̃a pe nehẽ, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Kiroki g̃a o'ã Jesus'ga pyri – g̃a pe Jesus'ga ei: —Imombe'ukatuavo ji ei pe me: Omanoe'ymame ti agwa'g̃a pyteripeve'g̃a ji repiagi ji rurame kokoty penduvihavuhuhetero jitekovo nehẽ. A'ea Jesus'ga ei okovo yvyakotyva'ero yvagipeva'ero no. ");
INSERT INTO pahNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Aerẽ seis okirirẽ Jesus'ga g̃a nderohoi ojupi Pedro'ga Tiagova'ea reheve João'ga reheve no. João'ga ko Tiagova'ea irũ'ga. Jesus'ga g̃a nderohoi g̃a nderojiupia yvytyruhua arimo yvateuhuva'ea arimo. G̃a tehe oko pevo a'ero Jesus'ga pavẽi. ");
INSERT INTO pahNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Pevo Jesus'ga ra'oa jirojijyi g̃apyteri pe. Garova hendy'jandy'jahetero kwara ja. Ga'apoa tapy'ynhapira tig̃ahivuhuro g̃wendy'jandy'javamo kwara ja. ");
INSERT INTO pahNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Nanime ahe jipiukari g̃a pe onhi'ig̃a Jesus'ga pe Moisésva'ea Eliasva'ea pavẽi – kiroki ahe ymyahũ hete omano. ");
INSERT INTO pahNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","A'ero Pedro'ga ei Jesus'ga pe ga renoina nde ko orepojykaharetero javo. —Pyry nhanderekoa avo, ei ga Jesus'ga pe. Nde ipotarame po ti ji japoi tapyimbovyra pe me: ojipeji nde ve, ojipeji Moisés'ga pe, ojipeji Elias'ga pe, ei Pedro'ga Jesus'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Ga nhi'ig̃ame yvag̃atig̃a ijyvi g̃a arimo g̃a mongovo o'ag̃i pe. Hendy'jandy'ja yvag̃atig̃a. Nanime yvag̃atig̃a hugwi Tupana'ga nhi'ig̃i Jesus'ga mombe'gwovo: —Agwa'ga ko jira'yra'ga nhiremia'nguhete'ga. Anhimohẽ hete ko ji ga rehe. Pehendu katu ti ganhi'ig̃a, ei Tupana'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Tupana'ga nhi'ig̃a renduvame Jesus'ga remimbo'ehara'g̃a ari ojovapyvo okyhyjiheteavo. ");
INSERT INTO pahNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","A'ero Jesus'ga ruri g̃a pyri opokoga g̃a ndehe. —Pepo'ã ti, ei ga g̃a pe. Tapekyhyji ti, ei ga. ");
INSERT INTO pahNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ojovavurame Jesus'ga jate g̃a ga repiagi. A'ereki ahe oho jipe. ");
INSERT INTO pahNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Jesus'ga jyvi yvytyruhua hugwi g̃wemimbo'ehara'g̃a pavẽi ogwovo. Ojyvame ga ei g̃a pe: —Pehepia pe jira'oa jirojijyirame. A'ea tapemombe'ui na'ẽ. Aerẽ ji kweravame gwe nhimanoa hugwi ti pemombe'u. A'ea Jesus'ga ei g̃a pe okovo yvyakotyva'ero yvagipeva'ero no. ");
INSERT INTO pahNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","A'ero garemimbo'ehara'g̃a ei ga pe: —Nderura renonde ti Elias'ga tuhu nehẽ, ei g̃a Jesus'ga pe. A'ea ahembo'ehara'g̃a ei. Maraname g̃a ei na? ei Jesus'ga remimbo'ehara'g̃a Jesus'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","A'ero Jesus'ga ei g̃a pe: —Omombe'u katu g̃a, ei Jesus'ga. Eliasva'ea uhu na'ẽ g̃andeaporog̃ita rerojijyipava, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Jihi ki a'e te a'e pe me: Eliasva'ea uhu jipe ikwehe. Nonhimombaragwahavi g̃a ahe rehe ahe kwahave'yma, ei Jesus'ga. Okovo g̃wemimbotarimova'ea rupi g̃a ndekote'varuhuro ahe ve reki. Na jitehe po ti g̃a imondoi hahyva'ea ji ve nehẽ no, ei Jesus'ga yvyakotyva'ero yvagipeva'ero no. ");
INSERT INTO pahNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","A'ero Jesus'ga remimbo'ehara'g̃a ikwahavi. “João Batistava'ea pe Jesus'ga ei Eliasva'ea mombe'urame nhande ve,” ei g̃a oyvyteri pe. ");
INSERT INTO pahNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Aerẽ Jesus'g̃a ndurame he'yive'g̃a pyri a'ero akwaimbae'ga ruri g̃wenypy'anduruga Jesus'ga rovai pyteri pe jijoheva'ero ore poko ti javo. ");
INSERT INTO pahNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","—Eporogwety jira'yra'ga, ei ga Jesus'ga pe. Heagwyry hete ga karugwate'varuhua ga rerekoro g̃waramo. Tiruahũ ga pe. O'ao'a ga tata pype jipi yhya pype jipi no, ei ga Jesus'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Aru ji ga neremimbo'ehara'g̃a pyri tomombi ti g̃a karugwara ga hugwi javo novĩa, ei ga. G̃a nomombigi reki ga hugwi. A'ereki g̃a ndipopoakari jupe, ei ga Jesus'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","A'ero Jesus'ga ei g̃a pe nhaporemo: —Ndapejikogiuhu pe ji rehe pejikote'varuhuavo. Pe ji mombitu pejijupa. Manameuhũ po ti pe jikogi ji rehe nehẽ naerũ? ei Jesus'ga g̃a pe. Peru ti tayri'ga avo ji pyri, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","G̃a tayri'ga rerurame Jesus'ga e'iahy Diabo'gapyriva'ea pe anhag̃a pe imbojipe'avo tayri'ga hugwi. Oho hete anhag̃a tayri'ga hugwi a'ero. A'ea rupi jitehe tayri'ga nhimohig̃atui a'ero. ");
INSERT INTO pahNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Aerẽ Jesus'ga tehe ga rekorame garemimbo'ehara'g̃a nduri ga pyri. A'ero g̃a ei ga pe: —Maraname anhag̃a ndojipe'ai tayri'ga hugwi ore erame jupe ko? ");
INSERT INTO pahNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","A'ero Jesus'ga ei g̃a pe: —Napembojipe'ai pe ga hugwi. A'ereki xunhi hete tuhẽ pe pejiko Tupana'ga rehe, ei Jesus'ga. Imombe'ukatuavo ji ei pe me: Po pe jikogi gwere jitehe Tupana'ga rehe, a'ero po pe ei agwava'ea pe yvytyruhua pe eho agwa hugwi egwovo pevo javo, a'ero ihoi. Po pe jikogi gwere jitehe Tupana'ga rehe tegwete onhimiva'ea pe me, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Nanongarava'ea anhag̃a po ti pe imbojipe'ai nehẽ penhi'inhi'ig̃ame jate Tupana'ga pe pe i'ue'ymame jate tanhi'inhi'ĩ ti Tupana'ga pe javo no, ei Jesus'ga g̃wemimbo'ehara'g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","G̃a nduvame Galiléiapeve'g̃a gwyri pe Jesus'ga ei g̃wemimbo'ehara'g̃a pe: —Uhu g̃werĩ nhimondohava apiavo g̃apo pe. Ji pyhy po ti g̃a nehẽ, ei Jesus'ga yvyakotyva'ero yvagipeva'ero no. ");
INSERT INTO pahNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","A'ero po ti g̃a ji jukai nehẽ. Mokõi ji kirirẽ po ti nhimbogwerahava nhimanoa hugwi nehẽ, ei Jesus'ga. Henduvame garemimbo'ehara'g̃a ndovy'arihu a'ea rehe. ");
INSERT INTO pahNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Aerẽ Jesus'ga ruri cidade de Cafarnaum me g̃wemimbo'ehara'g̃a pavẽi. G̃a vahemame g̃a nduri Pedro'ga pyri – kiroki g̃a opyhy itambere'ia judeus'g̃a hugwi imono'ono'og̃a tiapokatua'ja ti nhandejatykahavuhua javo. A'ero g̃a ei Pedro'ga pe: —Marã? Nembo'ehara'ga po nombuhuri jipi itambere'ia toapokatua'ja ti g̃a ojatykahavuhua javo? ei g̃a Pedro'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","—Omondo ga jipi, ei Pedro'ga g̃a pe. Aerẽ Pedro'ga hoi ogwovo onga pype. Ga vahemame pevo Jesus'ga pyri Jesus'ga eypyi ga pe: —Simão, ei Jesus'ga ga pe. Marãi nde? Avo yvya koty ma'g̃a hugwi g̃anduvihavuhu'g̃a ipyhygukari itambere'ia imono'ono'og̃a ojive? Mara'ngu po nde javo: “Ogwyripeve'g̃a hugwi po g̃a ipyhygi”? Mara'ngu po nde javo: “Hajiheve'g̃a hugwi po g̃a ipyhygi”? Marãi nde naerũ? ei Jesus'ga Simão Pedro'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","A'ero Pedro'ga ei Jesus'ga pe: —Hajiheve'g̃a hugwi g̃a ipyhygi, ei ga. Henduvame Jesus'ga ei: —A'ero ti g̃agwyripeve'g̃a tomondoyme, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Nhande ko Tupana'ga gwyripeva'ea. Nurã po ti nhande nimondoi g̃a pe hamo nehẽ, ei Jesus'ga. Tihayvaryme ti g̃a hehe javo timondo ti nhande g̃a pe nehẽ. Eho ti ypiahu pe pira mbo'a a'ero. Kiroki o'u ypy – epyhy ti imbojurujaita. Jurua pype po ti nde hepiagi itambere'ia nehẽ. Ehekyi ti itambere'ia jurua hugwi itambere'ia rerua imondovo g̃a pe – kiroki g̃a omono'ono'õ itambere'ia tiapokatua'ja ti nhandejatykahavuhua javo. Ere ti g̃a pe: “Koro ko Jesus'ga remimondoa nhiremimondoa no.” A'ea ti ere g̃a pe imondovo g̃a pe, ei Jesus'ga Pedro'ga pe. A'ero Pedro'ga hoi pira mbo'a hepiaga itambere'ia jurua pype herua imondovo itambere'ia g̃a pe a'ero. ");
INSERT INTO pahNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Aere'ĩ Jesus'ga remimbo'ehara'g̃a nduri Jesus'ga pyri. Kiro g̃a ei ga pe: —Tupana'ga oko yvyakotyve'g̃a nduvihavuhuhetero kiro. Manamo nhandejoheva'ero huvihavamo ga pyri? ei g̃a. ");
INSERT INTO pahNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Kiro Jesus'ga tayri'ga mbuhurukari ojipyri a'ero epo'ã ti g̃apyteri pe javo. ");
INSERT INTO pahNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","A'ero ga ei g̃wemimbo'ehara'g̃a pe: —Imombe'ukatuavo ji ei pe me: Perojijyi ti pejeaporog̃ita penhimbohetee'yma tayri'g̃a ja, ei Jesus'ga. Po pe ndaperojijyi pejeaporog̃ita nehẽ, a'ero po ti Tupana'ga ndokoi penduvihavuhuhetero nehẽ. ");
INSERT INTO pahNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Kiroki g̃a tayri'ga ja nonhimbohetei – g̃ahã ko koji'i huvihava ojipe'g̃a hohe Tupana'ga pyri huvihavuhuhete'ga pyri, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","—Kiroki g̃a jireheva'ero g̃waramo gwereko katu tayri'ga'jave'ga ga oko Jesus'gareheva'ero javo – jihi tuhẽ reki g̃a ji rerekokatui, ei Jesus'ga g̃wemimbo'ehara'g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","—Tiruahũ hete po ti g̃a pe nehẽ – kiroki g̃a ombote'va tayri'ga'jave'ga jireheve'ga ga mbopogweavo ite'varuhuva'ea rehe, ei Jesus'ga. Omano jipe po g̃a hamo tombote'varyme ti g̃a jireheve'ga, ei Jesus'ga. Po ahe nhapytĩ g̃ajura rehe itaruvihavuhua ipohyiva'ea yngu'a'javuhuva'ea g̃a momboa ypiahua ruvihava pype g̃a mbotypyvyga, a'ea ko tiruahũhetero g̃a pe. Koji'i tiruahũ hete g̃a pe g̃a jireheve'ga mbote'varuhurame huvihava'garũive'ga, ei Jesus'ga g̃wemimbo'ehara'g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","—Tiruahũ hete yvyakotyve'g̃a pe. A'ereki jara'g̃a ombote'varuhu ojipe'g̃a jipi. Na tuhẽ po ti jipi nehẽ, ei Jesus'ga. G̃a pe po ti tiruahũ hete nehẽ no – kiroki g̃a g̃a mbote'varuhu, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","—Nurã ji ei nde ve: Po epoa pyvõ ojipejiva'ea pyvõ nde rekote'varuhui, a'ero ti ehaygwe'ro epoa ejihugwi imomboa nahã imombiga ejekote'varuhua! Na jitehe nde ejekote'varuhurame epya pyvõ ojipejiva'ea pyvõ ehaygwe'ro ti epya nahã imombiga ejekote'varuhua, ei Jesus'ga. Tiruahũ po ti nde ve ndepoa mombora nehẽ ojipejijatero g̃waramo ndepoa avuirama, ei Jesus'ga. Tiruahũ po ti nde ve ndepya mombora nehẽ no nde po'ame'yma g̃waramo avuirama, ei Jesus'ga. —Emo po imombore'yma nde neremombigi ejekote'varuhua, a'ero koji'i po ti tiruahũ nde ve nehẽ Tupana'ga nde momborame hahyva'ea ruvihava pype nde rekote'varuhuro g̃waramo. Pevo po ti nde ruvi avuirama herekoteheavo epoa mokõiva'ea epya mokõiva'ea no novĩa nehẽ, ei Jesus'ga. —A'ero ji ei nde ve: Koji'i pyry nde imomborame epoa epya reheve ejekote'varuhua mombiga egwovo yvagi pe Tupana'ga pyri, ei Jesus'ga g̃wemimbo'ehara'g̃a pe, g̃ambote'varuhua mombora pe javo. ");
INSERT INTO pahNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","—Po ejeakwara pyvõ ojipejiva'ea pyvõ nde rekote'varuhui, a'ero ti ehekyi ejeakwara imomboa nahã imombiga ejekote'varuhua! ei Jesus'ga. Tiruahũ nde ve ndereakwara mombora nehẽ ojipeji jatero g̃waramo ndereakwara avuirama. —Emo po imombore'yma nde neremombigi ejekote'varuhua, a'ero po ti koji'i tiruahũ nde ve nehẽ Tupana'ga nde momborame hahyva'ea ruvihava pype nde te'varuhuro g̃waramo. Pevo po ti nde ruvi avuirama herekoteheavo ejeakwara mokõiva'ea novĩa nehẽ, ei Jesus'ga. —A'ero ji ei pe me: Koji'i pyry nde imomborame ejeakwara ejekote'varuhua mombiga egwovo yvagi pe Tupana'ga pyri, ei Jesus'ga g̃wemimbo'ehara'g̃a pe. G̃ambote'varuhua mombora pe Jesus'ga ei imombe'urame g̃andeakwara mombora. ");
INSERT INTO pahNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","—Pearõ hete ti tayri'g̃a'jave'g̃a. Tape'eag̃wami ti: “G̃a koty po ti ji ndajirovagi nehẽ.” Na rũi ti peko, ei Jesus'ga. A'e ji pe me: G̃anderekokatuhara'g̃a ko Tupana'gapyrive'g̃a yvagipeve'g̃a. G̃ahã omombe'u pa Tupana'ga pe nahanahã g̃a oko te'varuhu tayri'g̃a'jave'g̃a pe javo. Nane'ymi tayri'g̃a'jave'g̃a nderekokatuhara'g̃a ndekoi yvagi pe jiruva'ga pyri yvagipeve'ga pyri javo ga pe. A'ero Tupana'ga tayri'g̃a'jave'g̃a pokogukari g̃a a'nguavo, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Pearõ ti tayri'g̃a'jave'g̃a. A'ereki ji ajo yvya koty tamombo ti ji yvyakotyve'g̃a ndekote'varuhua g̃a hugwi g̃a mbojikoguka ji rehe javo. Kiroki g̃a ndogwerekoi gwepiakatuhara'g̃a oka'nhyve'g̃a ja – g̃andekote'varuhua ti ji tamombo, a'e ji jijoa jitekovo yvyakotyva'ero yvagipeva'ero no, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","—Po akwaimbae'ga gwereko g̃wenymbava cem ovelhas. Po ojipeji oka'nhy ga hugwi, ndohoi re po ga heka naerũ? Gweja po ga he'yiva'ea noventa e nove ovelhas ogwovo yvytyruhua rupi hekaheteavo ojipe'ia. ");
INSERT INTO pahNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Po ga hepiagi ovelha, a'ero po ga roryroryvamo hehe. Hory po ga jara rehe noventa e nove ovelhas rehe ika'nhyme'ỹva'ea rehe novĩa. Koji'i po ga roryroryvamo akoja rehe ojipejiva'ea rehe, ei Jesus'ga. Ndopotari po ga ojipejiva'ea vehevi ika'nhymame, a'e ji imombe'ukatuavo pe me, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","—Na jitehe yvagipeve'ga penduvete'ga roryroryhetero tayri'g̃a'jave'g̃a ndehe. Ndopotari ga g̃a ndekote'varuhurame. A'ereki okote'varuhurame g̃a oko oka'nhyve'g̃a ja ga pe, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","—Po ndekotyve'ga ite'varuhu nde ve – kiroki ga ojiko ji rehe nde ja – po ga ite'varuhu nde ve, a'ero ti eho ga pyri. Ojipe'g̃a ndovakie'ỹ ti eho ga pyri, ei Jesus'ga. Ere ti ga pe: “Nahanahã nderekote'varuhua ji ve.” A'ea ti ere ga pe, ei Jesus'ga. Po ga nenhi'ig̃a rendu katu opohia okote'varuhua hugwi nehẽ, a'ero po ti nde jikoty'ara'javi ga pavẽi nehẽ, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","—Po ga nohendukatui nenhi'ig̃a nehẽ, a'ero ti eroho ojipe'ga ejupi ga rerovahema ga pyri. Doisve'g̃a vehevi pyry nde g̃a nderohoi ga pyri g̃a nderovahema nehẽ, ei Jesus'ga. Erea'ja ti ga pe ejupive'g̃a henduvame: “Nahanahã nderekote'varuhua ji ve.” A'ea ti erea'ja ga pe, ei Jesus'ga. G̃a ti tohendu pa nenhi'ig̃a doisve'g̃a. Pyry ojipe'ga henduvi no nde erame ga pe. A'ero po ti g̃a ikwahavi nehẽ nahanahã akoja'ga rekote'varuhui ga pe javo, ei Jesus'ga. A'ero po ti g̃a ei ga pe nehẽ: “Nahanahã nderekote'varuhua ga pe.” ");
INSERT INTO pahNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","—Po ga nohendukatui ve g̃anhi'ig̃a vehevi no, a'ero ti emombe'u g̃a pe nhaporemo – kiroki g̃a ojiko ji rehe ojatykavo jipi tihendu katu ti Tupana'ga nhi'ig̃a javo. A'ero po ti g̃a ei ga pe nehẽ: “Nahanahã nderekote'varuhua ga pe.” —Po ga nohendukatui g̃anhi'ig̃a no, a'ero ti ere ga pe: “Itambere'ia mono'õhara'ga ja ko ga ji ve.” A'ea ti ere ga pe. A'ea Jesus'ga e'i. A'ereki judeus'g̃a ndojihe'ari itambere'ia mono'õhara'g̃a ndehe g̃a ite'varuhu javo – kiroki g̃a omono'õ itambere'ia governo pe. ");
INSERT INTO pahNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","—Imombe'ukatuavo ji ei pe me: Aerẽ po ti pe ei nehẽ: “Nahanahã ti tapekoi.” Po a'ea nenhi'ig̃a, a'ea ko Tupana'ga nhi'ig̃a no, ei Jesus'ga g̃wemimbo'ehara'g̃a pe. —Aerẽ po ti pe ei nehẽ: “Nahanahã ti peko.” Po a'ea nenhi'ig̃a, a'ea ko Tupana'ga nhi'ig̃a no, ei ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","—Ojipea ji imombe'ukatui pe me, ei Jesus'ga. Po yvya koty doisve'g̃a pepyteripeve'g̃a ei: “Nahanahã ti xa'e Jesus'ga ruva'ga pe yvagipeve'ga pe nahanahã ore ipotari javo.” Ojo'ja pe erame nahã ga pe po ti ga penhi'ig̃a rendukatui, ei Jesus'ga g̃wemimbo'ehara'g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","A'ereki ji ako jireheve'g̃a pyteri pe g̃a pokoga nhinhi'ig̃a Tupana'ga pe g̃a pavẽi – kiroki doisve'g̃a onhi'ĩ Tupana'ga pe nhinhi'ig̃a rupi g̃a ndekopotaro g̃waramo. Po ojipe'g̃a ei a'ea jitehe no, a'ero po ti ji rekoi g̃apyteri pe nhinhi'ig̃a Tupana'ga pe g̃a pavẽi no, ei Jesus'ga g̃wemimbo'ehara'g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","A'ero Pedro'ga ruri Jesus'ga pyri hete ga renoina nde ko jipojykaharetero javo ga pe. Ga e'i: —Nhiirũ'ga rekote'varuhurame ji ve, maramomi po ti ji ndahaykai ga garekote'varuhua renonhe'yma a'ero hamo? Seterame ti ji tahaykayme ga? Maramomi? ei Pedro'ga Jesus'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","—Seterame jate rũi, a'e ji, ei Jesus'ga. Koji'iheterame ti terehaykai ga garekote'varuhua renonhe'yma. Quatrocentos e noventarame ti terehaykai ga, ei Jesus'ga Pedro'ga pe terehaykaag̃wami tuhẽ ti ga a'ero javo. ");
INSERT INTO pahNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","A'ereki nahã Tupana'ga opota. —Marã hekoi kiro yvyakotyve'g̃a pe g̃a erame Tupana'ga nhanderuvihavuhuhetero oko javo? A'ea rehe po ti ji pe mbo'ei ikwahavuka pe me imombe'gwovo a'ea'java'ea pe me kiro, ei Jesus'ga. G̃anduvihavuhu'ga ei: “Maramomi itambere'ia ji imbuhu'rag̃i jipyrive'g̃a pe ikwehe? Tamonhi'ĩ ti ji ikwatijara ikwahava,” ei ga, ei Jesus'ga imombe'gwovo. ");
INSERT INTO pahNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","—Ga ikwatijara monhi'ig̃ame gapyrive'g̃a gweru ojipe'ga rerovahema ga pyri. Ga ko gapyrive'ga jitehe. Gaha g̃a gweru oreruvihavuhu'ga ombuhu'rã ga pe ikwehe javo. He'yjuhuheteva'ea reki itambere'ia milhões ga ombuhu'rã ojipyrive'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Opo'ru pa gapyrive'ga itambere'ia. Nurã tegwete imondoa'java gwuvihavuhu'ga pe. —A'ero garuvihavuhu'ga ei g̃a pe: “Peroho ti ga mondovo ojipe'ga pe itambere'ia kwepyga ga rehe itambere'ia rerua ji ve. Garembirekohẽa ti peroho gara'yra'g̃a ndeheve g̃a mondovo ojipe'g̃a pe itambere'ia kwepyga g̃a ndehe itambere'ia rerua ji ve. Peroho ti gambatera imondopava ojipe'ga pe itambere'ia kwepyga itambere'ia rerua ji ve. A'ereki ga gweroho hete itambere'ia ji hugwi imbuhura'jave'yma ji ve,” ei ga, ei Jesus'ga imombe'gwovo. ");
INSERT INTO pahNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","—A'ero gapyrive'ga ei gwerohopotarame: “Jiruvihavuhuro terenhimbaekwahivi ji rehe. A'ero po ti ji imondopava'javi itambere'ia nde ve nehẽ.” Nahã ga etehei gwuvihavuhu'ga pe g̃wenypy'anduruga ga pyri ndehe ko ji hohe javo, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","—A'ero garuvihavuhu'ga ei ga pe: “Kiro ji nahenonha'javi embuhu itambere'ia jave'yma,” ei ga ojipyrive'ga pe ga porogwetyga, ei Jesus'ga. —Ojipe'g̃a pe ojipyrive'g̃a pe ga ei: “Taperohoa'javi ti ga,” ei ga g̃a pe, ei Jesus'ga imombe'gwovo. ");
INSERT INTO pahNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","—Ndogwerohoa'javi g̃a ga a'ero. Kiro ga hoi g̃a hugwi ogwovo ojipe'ga repiaga gwuvihavuhu'gapyrive'ga repiaga – kiroki ga gweroho'ã ndahe'yiva'ea dez itambere'ia ga hugwi tuhẽ imondoa'jave'yma ga pe. Opyhygahy ga ga juvyga. Kiro ga ei ga pe: “Embuhura'ja ji ve itambere'ia – kiroki nde ereroho'ã ji hugwi ikwehe,” ei ga ga pe, ei Jesus'ga imombe'gwovo. ");
INSERT INTO pahNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","—Ga g̃wenypy'anduru gapya pyri a'ero nde ji hohe javo. Kiro ga ehetei ga pe: “Terenhimbaekwahivi ji rehe. A'ero po ti ji imondopava'javi itambere'ia nde ve nehẽ,” ei ga ga pe, ei Jesus'ga imombe'gwovo. ");
INSERT INTO pahNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","—“Embuhu tuhẽ kiro ji ve,” ei ga ga pe, ei Jesus'ga. —A'ero ga ga rerohoi ga mondovo cadeia pype, ei Jesus'ga. “Cadeia pype po ti nde pytai nehẽ,” ei ga. “Nde imondopava'javame jate itambere'ia ji ve po ti nde hemi jugwi a'ero nehẽ,” ei ga ga pe, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","—G̃anduvihavuhu'gapyrive'g̃a hepiagi ga okote'varuhurame ga pe. Ndovy'ari g̃a ga repiaga. A'ero g̃a hoi gwuvihavuhu'ga pyri imombe'upava, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","A'ero g̃anduvihavuhu'ga ga mbuhurukari ojipyri – kiroki ga omongi ojipe'ga cadeia pype ji ndaporogwetygi ga javo. A'ero ga ruri gwuvihavuhu'ga pyri ovahema. —Kiro garuvihavuhu'ga ei ga pe a'ero: “Ereko te'varuhu nde,” ei ga ojipyrive'ga pe. “Nde ere'e ji ve oji'i terenhimbaekwahivi ji rehe javo. Nurã ji ei nde ve: Nahenonha'javi nde ve embuhu ji ve itambere'ia jave'yma. ");
INSERT INTO pahNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Na jitehe po nde nerehenonha'javi ga pe hamo,” ei ga ga pe, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","—Onhimonha'ngavo ojipyrive'ga rehe ga ga mondoi g̃a pe – kiroki g̃a omondo hahyva'ea okote'varuhuve'g̃a pe jipi, ei Jesus'ga. “Tomondo ti g̃a hahyva'ea nde ve nehẽ,” ei ga ojipyrive'ga pe, ei Jesus'ga. “Nde imbuhupava'javame jate itambere'ia ji ve po ti g̃a nomondoa'javi hahyva'ea nde ve nehẽ,” ei ga ga pe, ei Jesus'ga imombe'gwovo. ");
INSERT INTO pahNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","—Na jitehe po ti jiruva'ga yvagipeve'ga pe nderekopavi nehẽ pe henonha'javame peirũ'g̃a ndekote'varuhua pejive jireheve'g̃a ndekote'varuhua pejive. Pe'ji hete ti pejiyvyteri pe: “Nahenonha'javi ti g̃andekote'varuhua,” ei Jesus'ga g̃wemimbo'ehara'g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Aerẽ a'ea mombe'upavame Jesus'ga hoi Galiléiapeve'g̃a gwyra hugwi ua Judéiapeve'g̃a gwyri pe. Pevo ga vahemi rio Jordão aherovaja hugwi. ");
INSERT INTO pahNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","He'yjuhuve'g̃a nduri ga reviri ovahema ga pyri. Pevo ga imombigi karugwara itetirũave'g̃a hugwi a'ero. ");
INSERT INTO pahNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Kiro fariseus'g̃a nduri ga pyri no. —Tihepia ti gareaporog̃ita, ei g̃a ojohupe. Mara'ngu po ga nhande nhi'ĩpondekwakatuavo imombe'gwovo nehẽ? Tihepia ti ganhimbotegwetea a'ero, ei g̃a ojohupe. Nurã g̃a ei Jesus'ga pe: —Marãi naerũ? ei g̃a. Moisésva'ea remimbo'eagwera rupi g̃a ndekoi opohirame g̃wembireko'g̃a hugwi kunhangwera'g̃a hugwi jipi naerũ? ei fariseus'g̃a Jesus'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","A'ero Jesus'ga ei: —Pekwaha pe Tupana'ga rembikwatijarukara Moisésva'ea pe. A'ea e'i: “Jypya Tupana'ga oapo akwaimbae'ga kunhahẽa reheve,” e'i. ");
INSERT INTO pahNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","“Nurã akwaimbae'g̃a ja'ogi uva'g̃a hugwi oy'g̃a hugwi no g̃wembirekokaturo. G̃a ojogwerekoro g̃waramo ojipejiva'ea'java'ea akwaimbae'ga kunhahẽa pavẽi,” e'i Tupana'ga ikwatijaruka hako, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","A'ero mokonha ja rũi akwaimbae'ga garembirekohẽa pavẽi. Ojipejiva'ea ja g̃a ndekoi g̃wembirekorame. A'ero ti g̃a topohiryme ojohugwi. A'ereki Tupana'ga g̃a mohembirekoi, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","A'ero fariseus'g̃a ei Jesus'ga pe: —Moisésva'ea remimbo'eagwera e'i hako: “Opohipotarame ti akwaimbae'g̃a tokwatija kunhangwera'g̃a pe apohi ji kiro nde hugwi javo. Ikwatijarame jate po ti g̃a g̃wembireko'g̃a mondoi ojihugwi,” ei Moisésva'ea hako, ei g̃a. —Tupana'ga ipotare'ymame g̃apohira, maraname Moisésva'ea ei a'ea nhande mbo'eavo hehe? ei fariseus'g̃a Jesus'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","A'ero Jesus'ga ei g̃a pe: —Napeangarihu pe penhimbireko'g̃a nderekokatue'yma. Nurã a'ea Moisésva'ea ei, ei Jesus'ga. Jypya ko Tupana'ga nomboja'ogukari g̃a, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","—Jihi a'e pe me: Kiroki ga opohi g̃wembirekohẽa hugwi ojipe'ga hẽa rerohoro g̃waramo ojihugwi hẽa rerekovo – a'ero po ti ga topohi hẽa hugwi opohipotarame. Po ojipe'ga ndogwerohoi hẽa hẽarembireko'ga hugwi hẽa rerekoe'yma, a'ero ti hẽarembireko'ga topohiryme tuhẽ hẽa hugwi. Po ga opohi tehe hẽa hugwi ojipe'ga hẽa rerohoe'ymame, a'ero po ti ga ajuajuri ojipehẽa rerekoro g̃waramo nehẽ. Nahã po ti ga rekote'varuhui nehẽ oajuajuro g̃waramo. Kiroki ga hẽa rereko hẽarembireko'ga pohirirẽ hẽa hugwi – gaha hẽa mboajuaju hẽa rerekoro g̃waramo nahã okote'varuhuavo nehẽ, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","A'ero Jesus'ga remimbo'ehara'g̃a ei ga pe: —Po nahã tegwete akwaimbae'g̃a pohihava g̃wembireko'g̃a hugwi, a'ero koji'i pyry g̃a nahembirekoi tuhẽ! ei g̃a Jesus'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","A'ero Jesus'ga ei g̃a pe: —Penhi'ig̃a pyry g̃a pe jate – kiroki g̃a Tupana'ga g̃a poko nahã ti peko javo. Ojipe'g̃a ndokoi penhi'ig̃a rehe, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Jara'g̃a nahembirekoi. A'ereki tegwete g̃a hẽaavykya ojihute'varuhuro g̃waramo. Jara'g̃a nahembirekoi. A'ereki ojipe'g̃a g̃a hapĩambo tahembirekoag̃wamyme ti g̃a javo. Jara'g̃a nahembirekoi. A'ereki g̃a e'i: “Ahoaho po ti ji Tupana'ga nhi'ig̃a mombe'gwovo nehẽ kiro Tupana'ga rekoi nhanderuvihavuhuhetero javo g̃a pe.” A'ea g̃a ei nanhirembirekoi po ti ji a'ero javo, ei Jesus'ga. Kiroki ga nahembirekopotari tamombe'u ti Tupana'ga nhi'ig̃a javo – Tupana'ga ga poko ga mohembirekoukare'yma. Kiroki ga ombaragwaha hehe – gaha ti te'i a'ea ko pyry javo, ei Jesus'ga g̃wemimbo'ehara'g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Aerẽ ojipe'g̃a tayri'g̃a nderuri Jesus'ga pyri. —Topoko ti Jesus'ga g̃a'akag̃a rehe onhi'ig̃a Tupana'ga pe tomombyry ti ga g̃a pe javo, ei g̃a. Tayri'g̃a nderura repiagame Jesus'ga remimbo'ehara'g̃a ei g̃a pe: —Taperuri tayri'g̃a Jesus'ga pyri, ei g̃a. ");
INSERT INTO pahNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","—Tuhu tuhẽ ti tayri'g̃a ji pyri, ei Jesus'ga. Tapemombigi ti g̃andura. A'ereki nanongara'g̃a'jave'g̃a pe Tupana'ga pyry hete okovo g̃anduvihavuhuhetero g̃a jikogame ojihe, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Opoko Jesus'ga tayri'g̃a akag̃a rehe a'ero onhi'ig̃a Tupana'ga pe emombyry ti g̃a pe javo. Onhi'imbavame ga hoi pea hugwi ogwovo. ");
INSERT INTO pahNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Nanime ipyahuve'ga ruri Jesus'ga pyri. Ga e'i: —Marãva'ea rupi pyryva'ea rupi po ti ji rekoi nehẽ jirekoag̃wamamo avuirama Tupana'ga pyri nehẽ? ei ga Jesus'ga pe nde ko orembo'eharamo javo ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","A'ero Jesus'ga ei ga pe: —Maraname nde ei pyryva'ea rehe? Tupana'ga nhi'ig̃a jate ko pyry, ei Jesus'ga. Po nde rekopotari Tupana'ga pyri avuirama, a'ero ti eko pa Tupana'ga remimbotarimova'ea rupi – kiroki Tupana'ga e'i Moisésva'ea pe ikwatijaruka, ei Jesus'ga ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","—Marãva'ea Tupana'ga remimbotarimova'ea? ei ga Jesus'ga pe. A'ero Jesus'ga ei ga pe: —Nahã ko garemimbotarimova'ea: “Terejukai ti ojipe'g̃a. Tererekoi ti ojipe'g̃a nembireko'g̃a. Teremimi ti ojipe'g̃a hugwi,” ei ahe. “Tane'mbei ti ojipe'g̃a mombe'gwovo tehe. ");
INSERT INTO pahNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Emondo ti ejeaporog̃ita imohina ejuva'ga rehe eyhẽa rehe no. Erenhiarõ hete nde. Na jitehe ti earõ hete ejikotyve'g̃a,” ei Tupana'ga, ei Jesus'ga ipyahuve'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","A'ero ipyahuve'ga ei Jesus'ga pe: —Jivoja'irame ji hendukatupavi Moisésva'ea remimbo'eagwera. Kiro ji heronhimomboakari ahendu katu ve ji, ei ga. Marã koji'i po ti jipyryhetea nehẽ? ei ga. ");
INSERT INTO pahNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","A'ero Jesus'ga ei ga pe: —Po nde ereko katu pa pota, a'ero ti eho embatera imondopava itambere'ia pyhyga. A'ero ti emondo eitambere'ia imbatere'ỹve'g̃a pe, ei Jesus'ga. A'ero po ti Tupana'ga imombyryvi nde ve yvagi pe nehẽ, ei Jesus'ga. Nurã ji ei nde ve: Emondo pa ti eitambere'ia kiro. Imondopavirẽ ti ejo ji rupi ekovo nhiremimbo'eharamo ejikoga ji rehe jate, ei Jesus'ga ipyahuve'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Jesus'ga renduvame ga ndovy'ari ogwovo Jesus'ga hugwi. A'ereki ga nomondopapotari ombatehetero g̃waramo. ");
INSERT INTO pahNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","A'ero Jesus'ga ei g̃wemimbo'ehara'g̃a pe: —Imombe'ukatuavo ji ei pe me: Hahy imbateve'g̃a pe g̃a erame Tupana'ga pe eko ti oreruvihavuhuhetero javo. Po g̃a nde'ipotari te a'ea. Ndokopotari g̃a garemimbo'ea rupi okoheteavo ombatera rehe, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","A'ea'ja ji pe me: Tegwete yuranuhũa'javuhuva'ea hohava camelo hohava agulha kwa'ria rupi. Tegwete hete imbateheteve'g̃a hohava Tupana'ga nhi'ig̃a rupi okoheterame ombatera rehe. Nurã po ti g̃a ndojikogi te ga rehe ga mongoe'yma gwuvihavuhuhetero, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Ganhi'ig̃a renduvame Jesus'ga remimbo'ehara'g̃a nhimomby'ahetei hehe. A'ero g̃a ei: —Ma'g̃a po ti oho Tupana'ga pyri yvagi pe nehẽ naerũ? ");
INSERT INTO pahNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","G̃a ndepiagateteavo Jesus'ga ei: —Na tuhẽ yvyakotyve'g̃a nonhimondoi yvagi pe. A'ereki tegwete g̃a pe. Tupana'ga jate g̃a mbojiko ojihe g̃a mbuhuruka ojipyri. A'ereki nonhimimi ga pe. Ikarakatu pa hete ga, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","A'ero Pedro'ga ei Jesus'ga pe: —Ji rendu ti, ei ga. Ore oropohi pa orombatera hugwi orojikovo neremimbo'eharamo. Gara po ti Tupana'ga imbuhuri ore ve a'ero nehẽ? ei ga Jesus'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","A'ero Jesus'ga ei g̃wemimbo'ehara'g̃a pe: —Imombe'ukatuavo ji ei pe me: Aerẽ po ti Tupana'ga japoi yvyapyahua nehẽ. A'ea rupi jitekovo yvyakotyva'ero yvagipeva'ero po ti ji rekoi yvyakotyve'g̃a nduvihavuhuhetero jiapyga oina jiapykakatuhetea rehe ta'e ti ji g̃a pe g̃andekoa rehe javo, ei Jesus'ga. Peko pe jireheva'ero, ei Jesus'ga. A'ero ji rekorame g̃anduvihavuhuhetero po ti pe ndekoi peje'yja'g̃a nduvihavuhuro Israelva'ea rakykwepohara'g̃a nduvihavuhuro nehẽ. Doze ko g̃a oko huvihavamo ojiheve'g̃a pavẽi pende'yja'g̃a israelitas'g̃a, ei Jesus'ga. Pehe ti peapy oina dozeva'ea rehe pejiapykakatua rehe nehẽ xa'e ti g̃a pe g̃andeaporog̃ita rehe javo, ei Jesus'ga g̃wemimbo'ehara'g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","—Pejikogame ji rehe pe pepohi penhimbatera hugwi pende'yja'g̃a hugwi no xaho ti Jesus'ga rupi gareheva'ero javo, ei Jesus'ga. Kiro ji ei pe me pe'jave'g̃a pe no a'ero: Pyry hete po ti g̃a pe g̃a nag̃anani nehẽ – kiroki g̃a opohi g̃wonga hugwi ogwyra hugwi, ei Jesus'ga. Po g̃a pohirame a'ea hugwi, a'ero po ti Tupana'ga imombyryhetei g̃a pe nehẽ. Koji'i vehevi po ti Tupana'ga imombyryvi g̃a pe nehẽ, ei Jesus'ga. Po g̃a pohirame oirũ'g̃a hugwi okuvyra'g̃a hugwi g̃wendyra'g̃a hugwi uva'g̃a hugwi oy'g̃a hugwi g̃wembireko'g̃a hugwi, gwa'yra'g̃a hugwi, a'ero po ti Tupana'ga imombyryhetei g̃a pe nehẽ, ei Jesus'ga. Tupana'ga po ti g̃a mongoi ojipyri g̃a mombytavo avuirama nehẽ, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","—Kiroki g̃a huvihava ag̃wamo – he'yive'g̃a po ti ndokoa'javi huvihavamo onhimongyavo nehẽ. Kiroki g̃a huvihava rũi ag̃wamo – g̃ahã po ti huvihava nehẽ, ei Jesus'ga g̃wemimbo'ehara'g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Ojo'java'ea pyvõ Jesus'ga g̃a mbo'e. A'ero ga ei: —Marã hekoi kiro yvyakotyve'g̃a pe g̃a erame Tupana'ga nhanderuvihavuhuhetero oko javo? A'ea rehe po ti ji pe mbo'ei ikwahavuka pe me imombe'gwovo a'ea'java'ea, ei Jesus'ga g̃a pe. Ypyhajive akwaimbae'ga hoi taru ti ji oporavykyve'g̃a jijive javo. “Toporavyky ti g̃a itambere'ia rehe ko pe nhiremitymipyra pype uva tymipyra pype,” ei akwaimbae'ga, ei Jesus'ga imombe'gwovo. ");
INSERT INTO pahNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","A'ero ga hoi ovahema g̃a pyri. “Peporavyky ti ji ve nhiremitymipyra pype videira repiakatuavo. Amondo katu po ti ji itambere'ia um dia rupiara ikwepykava pe me a'ero nehẽ,” ei ga g̃a pe. —“Pyry,” ei g̃a. —A'ero g̃a hoi ko pe oporavykyavo ga pe, ei Jesus'ga imombe'gwovo. ");
INSERT INTO pahNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","—Aerẽ nove horas rupi ga hoa'javi ogwovo ima'ẽhai pe feira pe, ei Jesus'ga. Pevo ga ojipe'g̃a ndepiagi. Ndoporavykyi g̃a o'ama. ");
INSERT INTO pahNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Nurã ga ei g̃a pe: “Pe na jitehe ti peho uva tymipyra pype pejiporavykyavo ji ve no. Amondo katu po ti ji pe me itambere'ia peporavykya kwepykava nehẽ,” ei ga g̃a pe, ei Jesus'ga. —“Pyry,” ei g̃a. —Ko pe g̃a hoi oporavykyavo ga pe, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","—Aerẽ ahaji katu ga hoa'javi ojipe'g̃a mondouka g̃a mboporavykyavo ojive, ei Jesus'ga. Aerẽ ka'aru gwere rupi ga hoa'javi ojipe'g̃a mondouka g̃a mboporavykyavo ojive, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ka'aruva'ea rupi ga hoa'javi ojipe'g̃a ndepiaga, ei Jesus'ga. Ndoporavykyi g̃a o'ama. A'ero ga ei g̃a pe: “Gara rehe pe ãtehei agwa ara rupi ve pejiporavykye'yma?” ei ga g̃a pe, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","—A'ero g̃a ei ga pe: “Ndoroporavykyi ore g̃a pe. A'ereki g̃a nde'i ve ore ve,” ei g̃a ga pe, ei Jesus'ga. —Nurã ga ei g̃a pe: “Pe na jitehe ti peho uva tymipyra pype pejiporavykyavo ji ve no. Amondo katu po ti ji pe me itambere'ia peporavykya kwepykava nehẽ,” ei ga g̃a pe, ei Jesus'ga. —A'ero g̃a hoi oporavykyavo. ");
INSERT INTO pahNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","—Kwara ihorẽ kohoa jara'ga ei ojipyrive'ga pe – kiroki ga omboporavykyuka ko pe oporavykyve'g̃a – ga pe ga ei: “Embuhuruka ti oporavykyve'g̃a ejipyri. Emondo ti ikwepykava g̃a pe mbapavava'earupive'g̃a pe – kiroki g̃a ka'aru oporavykyahi'vi tehe – g̃a pe ti emondo ypy. Aerẽ ka'arugwererupive'g̃a pe ti emondo. Aerẽ ahajikaturupive'g̃a pe ti emondo. Aerẽ nove horasrupive'g̃a pe ti emondo. Mbapavamo ti emondo jypyve'g̃a pe – kiroki g̃a oho ypy ypyhajive oporavykyypyavo ji ve,” ei ga ojipyrive'ga pe, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","—A'ero ga g̃a mbuhurukari ojipyri. G̃a ndurame – kiroki g̃a oporavyky ka'aruva'ea rupi – g̃a pe g̃a nag̃anani ga imondoi itambere'ia um dia rupiara ikwepykava, ei Jesus'ga. Na jitehe um dia rupiara ikwepykava ojo'jajo'ja ga imondoi ka'arugwererupive'g̃a pe ahajikaturupive'g̃a pe no nove horasrupive'g̃a pe no. G̃a pe g̃a nag̃anani ga imondoi g̃a ndurame ojipyri, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","—Mbapavamo jypyve'g̃a nduri no. Oyvyteri pe g̃a ei: “Um dia rupiara ikwepykava ga imondoi g̃a pe – kiroki g̃a oporavykyahi'vi ga pe. Nurã po ti ga imbuhuri koji'iva'ea nhande ve kiro nehẽ. A'ereki ypyhaji hete nhande poravykyhetei ka'aru nhandepohia jugwi,” ei g̃a oyvyteri pe, ei Jesus'ga. —Ojo'jaime reki ga imondoi um dia rupiara ikwepykava jypyve'g̃a pe g̃a nag̃anani, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Ipyhygame itambere'ia ga hugwi g̃a ijara'ga rayvari okoe'yma hehe, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Ga pe g̃a ei: “Mbapavava'earupive'g̃a – kiroki g̃a uhu ka'aruva'ea rupi – g̃ahã oporavyky uma hora rupi jate. Ojo'jaime nde eremondo g̃a pe ore ve no. Ypyhaji hete ore poravykyi ka'aru hete oropohia jugwi kwarahyahiva po'ruavo,” ei g̃a ijara'ga pe, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","—Oporavykyve'g̃a pyteripeve'ga pe ijara'ga ei reki: —“Kwãi,” ei ga. “Ndakote'varuhui ji nde ve. Ypyhajive ji a'e nde ve: Eporavyky ti ji ve, a'ero po ti ji imondokatui um dia rupiara ikwepykava nde ve nehẽ. A'ero nde ei: ‘Pyry.’ A'ea nde ei ji ve ypyhajive,” ei ga oporavykyve'ga pe, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","“Eroho ti itambere'ia um dia rupiara ikwepykava herogwovo tuhẽ,” ei ijara'ga ga pe. —Ojirova ijara'ga mbapavava'earupive'g̃a pyteripeve'ga repiaga. “Ga pe mbapavava'earupive'ga pe – kiroki ga uhu ka'aruva'ea rupi oporavykavo – ga pe ojo'jaime ji imondopotari um dia rupiara ikwepykava,” ei ga jypyve'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","“Pyry ji imondoi ga pe nhiremimbotarimova'ea rupi. A'ereki jiapoa tuhẽ ko ji amondo ga pe. Erenhimyrõ nde ga rehe a enhimonha'ngavo ji rehe. A'ereki ji jipyry ga rerekokatuavo,” ei ga ga pe, ei Jesus'ga imombe'gwovo. ");
INSERT INTO pahNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","—A'ea ji amombe'u ikwahavuka ojo'java'ea pe me, ei Jesus'ga. Kiroki g̃a huvihava rũi ag̃wamo – g̃ahã po ti huvihava nehẽ, ei Jesus'ga. Kiroki g̃a huvihava ag̃wamo – g̃ahã po ti ndokoa'javi huvihavamo nehẽ, ei Jesus'ga. Nombojoavyavyi ti Tupana'ga g̃a nderekokatuavo a'ero, ei Jesus'ga. A'ereki Tupana'ga e'i he'yjuhuve'g̃a pe: “Herejo. Ejiko ti ji rehe ekovo jireheva'ero. Tako ti ji nderuvihavuhuhetero,” ei ga, ei Jesus'ga imombe'gwovo. Ndahe'yive'g̃a reki ojiko Tupana'ga rehe okovo gareheva'ero, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Jesus'ga hoi ogwovo cidade de Jerusalém me. Gweroho ga dozeve'g̃a g̃wemimbo'ehara'g̃a ojupi. Irupe'i ga g̃a nderohoi ojipe'g̃a hugwi onhi'ig̃a g̃a pe g̃a horame pea rupi. ");
INSERT INTO pahNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","Kiro ga ei g̃a pe a'ero: —Ji rendu ti, ei Jesus'ga g̃a pe. Kiro nhande hoi cidade de Jerusalém me. Aerẽ po ti jipyhygukahava g̃a pe ikwava'ẽhara'g̃a nduvihava'g̃a pe ahembo'ehara'g̃a pe nehẽ no, ei Jesus'ga yvyakotyva'ero yvagipeva'ero no. A'ero po ti g̃a ei nehẽ tomano ti Jesus'ga javo, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","A'ero po ti g̃a ji mondoukari judeus'g̃arũive'g̃a pe nehẽ tojigwarai ti g̃a ga rehe javo, ei Jesus'ga. A'ero po ti judeus'g̃arũive'g̃a ji rerekomemui okote'varuhuavo ji ve nehẽ. Ipira apopyra pyvõ po ti g̃a ji nupanupãi ji mondohondohoga nehẽ, ei Jesus'ga. Kirẽ po ti g̃a ji mbovyri yva rehe nahã ji jukavo nehẽ. Ko'emameva'ea py'rovo mokõi jikira py'rovo po ti ji kweravi nehẽ, ei Jesus'ga g̃wemimbo'ehara'g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Kiro Zebedeu'ga rembirekohẽa ruri Jesus'ga pyri. Gweru hẽa gwa'yra'g̃a mokonha'g̃a akoja'g̃a – kiroki g̃a Jesus'ga remimbo'ehara'g̃a dozeve'g̃a nde'yja'g̃a. G̃a nderovahemame hẽa renypy'andurugi Jesus'ga pyri ga mboheteavo. —Tandepyry ti ji ve, ei hẽa Jesus'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","A'ero ga ei hẽa pe: —Gara nde erepota? A'ero hẽa ei ga pe: —Ekorame yvyakotyve'g̃a nduvihavuhuhetero ti ere agwa'g̃a pe jira'yra'g̃a pe toko memei ti g̃a huvihavamo nde pavẽi. Nahã ti ere g̃a pe g̃a mboapyga nde pyri aheapykakatuva'ea rehe ojipe'ga kikoty ejohukoty ojipe'ga kokoty ejohukoty rũi nde pyri nehẽ, ei hẽa Jesus'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Hẽara'yra'g̃a pe Jesus'ga ei reki: —Ndapekwahavi pe pe'erame toroapy ti Jesus'ga pyri orokovo huvihavamo javo, ei Jesus'ga g̃a pe. Aerẽ po ti hahy hete ji ve nehẽ. Po pe ji moirũi, a'ero hahy hete pe me nehẽ no. Marã a'ero? Peko pe nanongara rehe naerũ? ei Jesus'ga mokonha'g̃a pe hẽara'yra'g̃a pe. Igwete hẽara'yra'g̃a ei Jesus'ga pe: —Toronhimboita ti ore jupe, ei g̃a. ");
INSERT INTO pahNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","A'ero ga ei g̃a pe: —Penhimboita tuhẽ po ti pe hahyheterame pe me nehẽ pejikoga g̃waramo ji rehe. Ji rũi reki a'e g̃a pe g̃a tombojogwovai ji rehe yvyakotyve'g̃a nduvihavamo javo. Jiruva'ga jate omboavujikweripe g̃a pe avo po ti g̃a apygi nehẽ javo, ei Jesus'ga hẽara'yra'g̃a pe mokonha'g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Aerẽ jara'g̃a dezve'g̃a ikwahavi hẽa'ea Jesus'ga pe. —“Toko ti jira'yra'g̃a huvihavamo ga pyri,” ei hẽa, ei g̃a. A'ero g̃a ndopotari a'ea onhimonha'ngavo hẽara'yra'g̃a ndehe. ");
INSERT INTO pahNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","A'ero Jesus'ga g̃a mbuhurukapavi ojipyri dezve'g̃a mokonha'g̃a ndeheve. A'ero ga ei g̃a pe: —Judeus'g̃arũive'g̃a nduvihava'g̃a ipopoaka ogwyripeve'g̃a mboporavykyheteavo ojive g̃a mondomondovo g̃wemimbotarimova'ea rupi, ei Jesus'ga g̃wemimbo'ehara'g̃a pe dozeve'g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","G̃a ja rũi ti pejogwereko pejikovo g̃waramo jireheva'ero. Po pe peko pota jireheve'g̃a nduvihavamo penhiirũ'g̃a nduvihavamo, a'ero ti peko katu g̃a pe g̃a pokoga, ei Jesus'ga g̃wemimbo'ehara'g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Po pe peko pota g̃a hohe pa okovo g̃anduvihavuhuro, a'ero koji'i ti peko katu g̃a pe g̃a pokoheteavo. ");
INSERT INTO pahNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Ji ja ti pepoko g̃a pejikorame g̃anduvihavamo, ei Jesus'ga g̃a pe. Yvyakotyva'ero yvagipeva'ero jirurame yvya koty nda'ei ji g̃a pe: Ji poko ti. A'ea rũi ji ei. A'ereki tapoko ti g̃a javo ji ajo. Tamano ti ji he'yjuhuve'g̃a ndepyga g̃a mbopiro'yavo g̃andekote'varuhua hugwi. A'ero po ti g̃a ndohoi hahyva'ea ruvihava pype nehẽ, a'e ji jijoa, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Jesus'ga hoi cidade hugwi Jericó hugwi ogwovo g̃wemimbo'ehara'g̃a pavẽi. G̃a horame he'yjuhuve'g̃a hoi g̃a ndupi. ");
INSERT INTO pahNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Nanime pea rembeyvyri pe mokonha'g̃a apygi heakwagweve'g̃a. G̃a ikwahavi Jesus'ga kiro okwa javo. A'ero g̃a hapukai torerendu ti Jesus'ga javo. —Orepojykaharetero ko nde Daviva'ea rymyminoro no! ei g̃a Jesus'ga pe. Nahã g̃a ei Jesus'ga pe. A'ereki g̃a e'i oyvyteri pe: “Ga pe Tupana'ga e'i eko ti g̃anduvihavuhuhetero javo.” —Ore poko ti! ei g̃a Jesus'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","A'ero he'yjuhuve'g̃a ei g̃a pe: —Tapehapukai ti, ei g̃a g̃a pe tonhi'imbi g̃a javo. Koji'i heakwagweve'g̃a hapukaja'javi reki. —Orepojykaharetero Daviva'ea rymyminoro ore poko ti! ei g̃a ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","A'ero Jesus'ga pytai g̃a nderuruka ojipyri. Kiro ga ei g̃a pe: —Pejo ti avo. Marã po ti ji pe nderekoi nehẽ? Gara pe pepota? ei ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","A'ero g̃a ei ua Jesus'ga pyri: —Orepojykaharetero ore mboheakwa katu, ei g̃a ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","A'ero Jesus'ga g̃a porogwetygi. Opoko ga g̃andeakwara rehe. Nanime pyry g̃andeakwara. Kiro g̃a hoi Jesus'ga rupi a'ero. ");
INSERT INTO pahNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Ohorame cidade de Jerusalém me Jesus'ga ovahẽ cidade'ia kotyi ve Betfagé kotyi ve g̃wemimbo'ehara'g̃a pavẽi. Ohĩ Betfagé yvytyra rembeyvyri pe monte das Oliveiras rembeyvyri pe. Kiro Jesus'ga ei mokonha'g̃a pe g̃wemimbo'ehara'g̃a pe g̃a mondouka. ");
INSERT INTO pahNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","—Peho ti cidade'i pe pendovai pyteripeva'ea pe, ei ga g̃a pe. Pevahemame kotihĩ po ti pe hepiagi yuhua'javuhuva'ea jumenta nehẽ. Ojugwa g̃a imo'ama yva rehe. Jumenta ra'yra oko ipyri no. Pekwahara memei ti herua ji ve. ");
INSERT INTO pahNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Po ti g̃a ei pe me nehẽ: “Maraname pe ikwaharavi?” Po ti g̃a ei na, a'ero ti pe'ji g̃a pe: “Gaha – kiroki ga pe nhande ei: Nhandepojykaharete'ga – gaha e'i: ‘Tareko'ã ti ji taho ti ji i'arimo javo’.” A'ea ti pe'ji g̃a pe. Kotihĩ po ti g̃a imbuhurukari nhande ve a'ero nehẽ, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","A'ero g̃a ndekoi Jesus'ga nhi'ig̃a rupi ga nhi'ĩpo'rupava. Nahã hekoi Tupana'ga nhi'ĩpo'ruavo ymyahũva'ea po'ruavo. A'ereki ymyahũ Tupana'ga nhi'ig̃a mombe'uharava'ea a'ea mombe'u Tupana'ga nhi'ig̃a mombe'gwovo. Ymyahũ ahe ei hako: ");
INSERT INTO pahNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Ere ti cidadepeve'g̃a pe Siãopeve'g̃a pe: ‘Pehepia ti! Penduvihavuhuhete'ga uhu pe pyri. Ga ko oko nhyrõ. Ga po ti oho yuhua'javuhuva'ea arimo jumenta ra'yra arimo ua nehẽ’,” ei ahe Tupana'ga nhi'ig̃a mombe'gwovo hako. ");
INSERT INTO pahNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Jesus'ga remimbo'ehara'g̃a hoi Jesus'ga nhi'ig̃a po'ruavo ipyhyga jumenta jumenta ra'yra reheve. ");
INSERT INTO pahNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Gweru g̃a jumenta jumenta ra'yra reheve Jesus'ga pyri herovahema. Oapoa tapy'ynhapira i'arimova'ea g̃a heropori inog̃a ikupepytera rehe eho i'arimo javo Jesus'ga pe. A'ero ga hoi i'arimo. ");
INSERT INTO pahNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ga rerohorame pea rupi he'yjuhuheteve'g̃a heroporopori oapoa opira i'arimova'ea pea rupi timbojigwa ti pehea ga pe javo. Jara'g̃a okytikyti hakã yva hugwi heroporopoa pea rupi imbokatuavo. Nahã g̃a Jesus'ga mbojiroviari ga rerua nhanderuvihavuhuhete'ga u kiro javo. ");
INSERT INTO pahNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Jara'g̃a oho ga renonde. Jara'g̃a oho ga reviri. Nahã he'yjuhuheteve'g̃a hoi ga rupi. Hahyahi hete g̃anhi'ig̃a g̃a erame: —“Timbohete ti Daviva'ea rymymino'ga!” ei g̃a ga ko nhanderuvihavuhuhete'ga javo. “Ga pe ti nhandepojykaharete'ga tomombyry. A'ereki nhandepojykaharete'ga ga mbuhuruka avo,” ei g̃a. “Timbohete ti Tupana'ga yvagipeheteve'ga!” Nahã g̃a ei Jesus'ga ko Tupana'ga remimbuhurukara'ga javo. ");
INSERT INTO pahNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Jesus'ga rerovahemame cidade de Jerusalém me ipypeve'g̃a py'a myi. —Mome ahe ga? ei g̃a Jesus'ga repiagame. ");
INSERT INTO pahNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","A'ero he'yjuhuve'g̃a ei g̃a pe: —Ga ko Jesus'ga Tupana'ga nhi'ig̃a mombe'uhara'ga. Gagwyra ko Galiléia. Pevo ga ruvi cidade de Nazaré pe, ei g̃a g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Kiro Jesus'ga hoi oje'yja'g̃a jatykahavuhu pe Tupana'ga mbohetehai pe ovahema. Pevo okara hugwi mytu'ẽva'ea hugwi ga g̃a mo'embavi ima'ẽhara'g̃a ipyhyhara'g̃a ndeheve – kiroki g̃a oma'ẽ mbatera ipyhyga no – perope Tupana'ga mbohetehava pyri. Pevo ga imbojirevi g̃a'apoa mesas – kiroki g̃a hajiheve'g̃a itambere'ia pyhy judeus'g̃a itambere'ia mondovo nahã ikwepyga. G̃a'apykava no – kiroki g̃a omondo inambua itambere'ia rehe – g̃a'apykava ga imbojirevi. ");
INSERT INTO pahNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","G̃a pe ga ei: —Ymyahũ Tupana'ga ei ikwatijaruka hako: “Tonhi'ĩ ti g̃a ji ve nhironga pype yvya koty ji mboheteavo,” ei Tupana'ga hako, ei Jesus'ga g̃a pe. —Pe ki a'e te pe'ji pejohupe: “Timoandyandyjuhu ti g̃a ikwepykwepyga mbatera pyvõ Tupana'ga ronga pype,” pe'ji, ei Jesus'ga. Nahã pe Tupana'ga ronga mongoukari iporomive'g̃a nduhavamo, ei Jesus'ga ikwepykara'g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Heakwagweve'g̃a nduri oje'yja'g̃a jatykahavuhua pype ipyka'naka'nauhũve'g̃a pavẽi. Jesus'ga pyri g̃a nduri ovahema a'ero. A'ero ga imombyryvi g̃a pe g̃a mboheakwakatuavo ipyka'nave'g̃a mopo'ag̃atua'java. ");
INSERT INTO pahNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ikwava'ẽhara'g̃a nduvihava'g̃a judeus'g̃a mbo'ehara'g̃a pavẽi gwepia ahemonhimomby'ava'ea Jesus'ga imombyryvame g̃a pe. G̃wendu g̃a tayri'g̃a Jesus'ga mboheterame ojatykahavuhua pype javo: —Timbohete ti Daviva'ea rymymino'ga! Nahã tayri'g̃a ei. A'ereki g̃a e'i oyvyteri pe: “Ga pe Tupana'ga e'i eko ti g̃anduvihavuhuhetero javo.” A'ero ikwava'ẽhara'g̃a nduvihava'g̃a nhimboahivi Jesus'ga pe judeus'g̃a mbo'ehara'g̃a pavẽi. ");
INSERT INTO pahNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","A'ero g̃a ei Jesus'ga pe: —Erehendu nde tayri'g̃a ea? Jesus'ga ei g̃a pe: —Ahendu ji. Napemonhi'ig̃i pe Tupana'ga rembikwatijarukara naerũ? E'i: “Tupanetero nde tayri'g̃a mbo'ekatui ipita'ngive'g̃a ndeheve. ‘Ji mbohete ti,’ ere nde g̃a mbo'eavo. A'ero g̃a nde mbohetekatukatui.” Nahã ikwatijaripyra i'ei Tupana'ga mombe'gwovo, ei Jesus'ga ikwava'ẽhara'g̃a nduvihava'g̃a pe judeus'g̃a mbo'ehara'g̃a pe no. ");
INSERT INTO pahNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","O'erame a'ea Jesus'ga hoi g̃a hugwi a'ero ogwovo cidade de Jerusalém hugwi. Oho ga cidade'i pe Betânia pe. Pevo ga kiri ypytunimo. ");
INSERT INTO pahNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Ko'emame ypyhajive Jesus'ga hoa'javame cidade de Jerusalém me ty'ara ga jukai. ");
INSERT INTO pahNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Pea rupi ga hepiagi figo'yva figueira ogwovo ipyri ta'u ti yva'ia javo. Ndi'ai reki ka'atehea herekovo. A'ero ga ei jupe: —Tande'aa'javi ti! ei ga jupe. Nimbegwei he'ouhũro omanomo figo'yva a'ero. ");
INSERT INTO pahNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","He'õa repiagame Jesus'ga remimbo'ehara'g̃a nhimomby'ai. A'ero g̃a ei: —Kotihĩ figo'yva he'ouhũro omanomo! ei g̃a. ");
INSERT INTO pahNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","A'ero Jesus'ga ei g̃a pe: —Imombe'ukatuavo ji ei pe me: Po pe jikohetei Tupana'ga rehe, a'ero ji ja po ti pe imohe'õi i'yva. Koji'i po ti pe popoakaramo nehẽ no. Po ti pe ei avova'ea pe yvytyra pe nehẽ: “Ejipe'a ti enhimomboa ypiahua pype.” Po ti pe ei na nehẽ, a'ero po ti yvytyra ihoi ypiahua pype nehẽ, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Po pe jikogi Tupana'ga rehe, a'ero po ti Tupana'ga penhi'ig̃a rendukatui pe erame ga pe nahanahã ore oropota javo, ei Jesus'ga g̃wemimbo'ehara'g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Kiro Jesus'ga hoi cidade de Jerusalém me ovahema ogwovo ja oje'yja'g̃a jatykahavuhua pype templo pype. Ga g̃a mbo'erame Tupana'ga nhi'ig̃a rehe ikwava'ẽhara'g̃a nduvihava'g̃a nduri ga pyri xava'eve'g̃a pavẽi. A'ero g̃a ei Jesus'ga pe: —Ma'g̃a nde mbuhurukaruhu avo nahanahã ti eko javo? Ma'g̃a e'i a'ea nde ve? ei g̃a Jesus'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","A'ero Jesus'ga ei g̃a pe: —Ji nhi'ĩpondekwa na'ẽ ti. Pe ji nhi'ĩpondekwakaturame a'ero po ti ji na jitehe ga mombe'ui pe me no – kiroki ga ji mbuhu avo ji rerekovo, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Pemombe'u ti ji ve a'ero. Ma'g̃a ombuhuruka João Batistava'ea tomobatiza ti ga g̃a javo? “Tupana'ga yvagipeve'ga ombuhuruka ahe,” pe'ji po pe. “Yvyakotyve'ga ombuhuruka ahe,” pe'ji po pe. Marã pendeaporog̃ita a'ero naerũ? ei Jesus'ga g̃a pe. A'ero g̃a eg̃a'ei ojohupe: —Po ti nhande ei nehẽ: Tupana'ga ombuhuruka ahe, a'ero po ti Jesus'ga ei nhande ve nehẽ: “Maraname pe ndaperoviari João Batistava'ea nhi'ig̃agwera naerũ?” Nahã po ti Jesus'ga ei nhande ve nehẽ. ");
INSERT INTO pahNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Po ti nhande ei: Yvyakotyve'ga ombuhuruka João Batistava'ea, a'ero po ti nhandegwyripeve'g̃a henduvi nhanenhi'ig̃a okote'varuhuavo nhande ve nehẽ, ei g̃a xakyhyji nhande g̃a hugwi javo. A'ereki nhandegwyripeve'g̃a epavi: “João Batistava'ea ko Tupana'ga nhi'ig̃a mombe'uharamo. Tupana'ga ahe mbuhuruka nhande pyri. A'iti a,” ei nhandegwyripeve'g̃a, ei g̃a ojohupe. ");
INSERT INTO pahNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Nurã g̃a ei Jesus'ga pe: —Ma'g̃a po ombuhuruka João Batistava'ea tomobatiza ti ga g̃a javo? Ndorokwahavi, ei g̃a javo tehe ga pe. A'ero Jesus'ga ei g̃a pe: —Ji po ti na jitehe namombe'ui ga pe me a'ero nehẽ no – kiroki ga ji mbuhu avo ji rerekovo, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","—Marã pendeaporog̃ita? ei Jesus'ga g̃a pe. Kiro po ti ji imombe'ui pe me, a'ero ti ji nhi'ĩpondekwa nehẽ, ei Jesus'ga. A'ero Jesus'ga imombe'ui ojo'java'ea. —Mokõi ko akwaimbae'ga ra'yra'g̃a, ei Jesus'ga imombe'gwovo. Gwa'yra'ga pe ga ei: “Pi'a, eho ti kiro eporavykyavo ko pe nhiremitymipyra pype uva tymipyra pype,” ei ga gwa'yra'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","—Emo gara'yra'ga e'i: “Ndahoi tuhẽ po ti ji nehẽ,” ei ga uva'ga pe. Aerẽ ga japyakakatui. A'ero ga herojijyi ojeaporog̃ita ogwovo oporavykyavo uva'ga pe, ei Jesus'ga imombe'gwovo. ");
INSERT INTO pahNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","—Aerẽ garuva'ga hoi ojipe'ga pyri gwa'yra'ga pyri, ei Jesus'ga. Na jitehe ga ei ga pe eho ti kiro eporavykyavo ko pe javo. —“Ji po ti aho tuhẽ nehẽ, apĩ,” ei gara'yra'ga ga pe. Ndohoa'javi reki ga oporavykye'yma, ei Jesus'ga imombe'gwovo. ");
INSERT INTO pahNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","—Manamo gara'yra'g̃a oko ganhi'ig̃a rupi? ei Jesus'ga ikwava'ẽhara'g̃a nduvihava'g̃a pe xava'eve'g̃a pe no. A'ero g̃a ei Jesus'ga pe: —Akoja ga – kiroki ga oho ko pe oporavykyavo gara'yra'ga, ei g̃a. A'ero Jesus'ga ei g̃a pe: —Imombe'ukatuavo ji ei pe me: Kiroki g̃a omono'og̃uhũ itambere'ia governo pe – g̃ahã akwaimbae'g̃a upahara'g̃a pavẽi ojiko Tupana'ga rehe kiro eko ti oreruvihavuhuhetero javo ga pe. Ojikogypy g̃a pe nenonde a'ero, ei Jesus'ga ikwava'ẽhara'g̃a nduvihava'g̃a pe xava'eve'g̃a pe no. ");
INSERT INTO pahNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","—Ymya'ĩ João Batistava'ea ruri pe pyri ikwahavuka pe me nahanahã Tupana'ga opota javo ikwehe. Ndaperoviari pe ga pejikokatue'yma, ei Jesus'ga. Itambere'ia mono'õhara'g̃a akwaimbae'g̃a upahara'g̃a pavẽi ga reroviari reki ojeaporog̃ita rerojijyita. G̃andeaporog̃ita rerojijyja pe hepiagi. Hepiagirẽ vehevi pe ndaperojijyi ve pejeaporog̃ita ga reroviare'yma, ei Jesus'ga g̃a pe. Nurã ji ei: Okogypy g̃a Tupana'ga rehe pe nenonde, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","—Ojipea rehe kiro po ti ji pe mbo'ei ojo'java'ea pyvõ. Pehendu ti, ei Jesus'ga ikwava'ẽhara'g̃a nduvihava'g̃a pe xava'eve'g̃a pe no. Kohoa jara'ga itymi yhypoa'javuhuva'ea uva'yva ko pe, ei Jesus'ga imombe'gwovo. Aerẽ ga g̃wemityma rokairug̃i, ei Jesus'ga. Aerẽ ga japoi uva mu'umu'ũhava tyhya rupiaramo. Aerẽ ga japoi tapyjo'ara ko pe. “A'ea hugwi po ti g̃a hepiakatui nhiremitymipyra videira ji ve nehẽ,” ei ga. —A'ero ga ei g̃a pe: “Pehepia katu ti nhiremitymipyra jikoa. A'ero jykyhava rupi he'yjuhu po ti yva'ia peapoaramo ikwepykavamo a'ero nehẽ. He'yjuhu po ti yva'ia jiapoaramo a'ero nehẽ no,” ei kohoa jara'ga g̃a pe, ei Jesus'ga. —“Pyry,” ei g̃a opytavo ko pe hepiakatuavo ga pe, ei Jesus'ga. —Paivohu kohoa jara'ga hoi a'ero mbaigwehu po ti jijivyra'java nehẽ javo, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Aerẽ kiro jykyhava reki, ei Jesus'ga. A'ero kohoa jara'ga ei ojipyrive'g̃a pe: “Peho ti g̃a pyri nhiremitymipyra repiakatuhara'g̃a pyri. Toyky ti g̃a yva'ia imbuhuruka jiapoa ji ve,” ei ga. —“Kwa,” ei g̃a. Ogwovo g̃a vahemi g̃a pyri imombe'gwovo ganhi'ig̃a g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Emo g̃a nomondopotari yva'ia g̃a pe okote'varuhuavo g̃a pe, ei Jesus'ga. Jara'ga g̃a ga nupanupã. Jara'ga g̃a ga juka. Jara'ga rehe g̃a omombomombo ita, ei Jesus'ga. Nahã garemitymipyra repiakatuhara'g̃a jigwarai gapyrive'g̃a ndehe, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","—A'ero kohoa jara'ga ojipe'g̃a mondoi ojipyrive'g̃a. G̃a ko he'yi ohoypyve'g̃a hohe. A'ero ga g̃a mondoi togweru ti g̃a yva'ia g̃a hugwi javo novĩa. G̃a vahemame pevo garemitymipyra repiakatuhara'g̃a ndekote'varuhui g̃a pe no. ");
INSERT INTO pahNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","—A'ero kohoa jara'ga gwa'yra'ga mondoi gaha ti togweru yva'ia g̃a hugwi javo novĩa. “Ga pe po ti g̃a ndekokatui nehẽ,” ei ga, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Kiro gara'yra'ga vahemi yva'ia tymipyra repiakatuhara'g̃a pyri. Ga repiagame g̃a ei ojohupe: “Avova'ea ko gayvyag̃wama. He tijuka ti ga. A'ero po ti nhande tireko pa yvya nehẽ,” ei g̃a. ");
INSERT INTO pahNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","A'ero g̃a gara'yra'ga pyhygi ga momboa kohoa hugwi ga jukavo, ei Jesus'ga imombe'gwovo. ");
INSERT INTO pahNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","—A'ero kohoa jara'ga vahemame marã po ti ga g̃a nderekoi nehẽ? ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","A'ero g̃a ei ga pe: —Omoka'nhymba ranuhũ po ti ga g̃a gwa'yra'ga repyga nehẽ, ei g̃a. Ojipe'g̃a pe po ti ga ei nehẽ: “Pehepia katu ti nhiremitymipyra jikoa,” e po ti ga nehẽ. A'ero po ti g̃a imondokatui yva'ia ga pe jykya nanani nehẽ, ei g̃a Jesus'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","—Na tuhẽ po ti nehẽ, ei Jesus'ga. Napemonhi'ig̃i pe Tupana'ga rembikwatijarukara naerũ? A'ea e'i: “Onga apohara'g̃a japorame onga ita apopyra hepiagi ojipeji ita. A'ea g̃a imombori ipo'rue'yma tiruahũ javo jupe. Aerẽ akoja jitehe hekoi huvihavamo jara hohe opyryhetero onga pyhykatuavo. Nhandepojykaharete'ga reki omongo huvihavamo. Hepiagame nhande nhimomby'ai nanongara ko pyry hete javo.” A'ea ikwatijaripyra i'ei, ei Jesus'ga oarõe'yma mombe'gwovo g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","—Nurã ji ei pe me: Tupana'ga ndokoa'javi penduvihavuhuhetero judeus'g̃a nduvihavuhuhetero pe ndepiakatua'jave'yma nehẽ, ei Jesus'ga. Oko po ti ga ojipe'g̃a nduvihavuhuhetero – kiroki g̃a ga nhi'ĩpo'ru ojikoga ga rehe, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","—Kiroki g̃a o'a akoja rehe ita rehe – g̃ahã po ti onhika'mbika'mbi nehẽ, ei Jesus'ga. Po ti akoja ita ihiri g̃a ndehe nehẽ, a'ero po ti ita g̃a ka'mbika'mbigi g̃a mongu'iuhuavo nehẽ. A'ea Jesus'ga ei ikwahavuka oarõe'ỹve'g̃a moka'nhymbava. ");
INSERT INTO pahNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Ikwava'ẽhara'g̃a nduvihava'g̃a henduvi fariseus'g̃a pavẽi Jesus'ga imombe'urame ojo'java'ea. A'ero g̃a ikwahavi Jesus'ga nhande mombe'ui reki javo. Jesus'ga arõe'yma a'ero g̃a ei: —Jesus'ga nhande mombe'u o'ete'varuhuavo nhande ve imombe'umbe'urame ojo'java'ea peko akoja'g̃a ja javo nhande ve, ei g̃a Jesus'ga mbotegwetepota. ");
INSERT INTO pahNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Nurã g̃a Jesus'ga pyhypotarahivi novĩa. Emo g̃a okyhyji pevove'g̃a hugwi. A'ereki pevove'g̃a oarõ hete Jesus'ga onhimongyavo ga ko Tupana'ga nhi'ig̃a mombe'uhara'ga javo. ");
INSERT INTO pahNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jesus'ga g̃a mbo'ea'javi he'yiva'ea pyvõ ojo'java'ea pyvõ javo g̃a pe: ");
INSERT INTO pahNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","—Marã hekoi kiro Tupana'ga rekorame yvyakotyve'g̃a nduvihavuhuhetero g̃a nderekovo? A'ea rehe po ti ji pe mbo'ei ikwahavuka pe me imombe'gwovo a'ea'java'ea, ei ga. G̃anduvihavuhu'ga japoi toryva tahembireko ti jira'yra'ga javo, ei Jesus'ga imombe'gwovo. ");
INSERT INTO pahNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ojipyrive'g̃a pe g̃anduvihavuhu'ga ei: “Peho ti javo g̃a pe – kiroki g̃a ji g̃a momoranduvipe – tuhu ti g̃a kiro toryvi pe javo.” —“Kwa,” ei g̃a ogwovo. G̃a vahemame g̃a pyri imombe'gwovo g̃a ndohopotari reki toryvi pe, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","—A'ero ikwahavame g̃anduvihavuhu'ga ojipe'g̃a mbuhurukari ojipyri ojipyrive'g̃a jitehe. “Peho ti javo g̃a pe – kiroki g̃a ji g̃a momoranduvipe. Tuhu ti g̃a kiro toryvi pe. G̃a pe ti pe'ji: ‘Pehendu ti! ei ga pe me. Amboavujikweruka ji toryva. Ajuka ji yuranuhũa'javuhuva'ea bois bezerros reheve – kiroki a'ea ji amboky'rauhu. Amboavujikwepavuka ji mbatera, ei ga pe me. Kirog̃we tuhẽ ti pejo toryvi pe hepiaga jira'yra'ga hembirekorame, ei ga pe me.’ Nahã ti pe'ji g̃a pe,” ei ga ojipyrive'g̃a pe g̃a mondovo, ei Jesus'ga. —“Kwa,” ei g̃a ogwovo. ");
INSERT INTO pahNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","G̃a pyri g̃a vahemi imombe'gwovo g̃a pe a'ero. Ndojapyakai g̃a g̃anhi'ig̃a rehe ohoe'yma toryvi pe, ei Jesus'ga. Oporavykya rehe reki g̃a hoi. Ojipe'ga oho ko pe. Ojipe'ga oho ima'eamo mbatera, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Ojipe'g̃a, ojigwaraita gwuvihavuhu'gapyrive'g̃a ndehe, g̃a g̃a pyhygi g̃a jukavo, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","—Ikwahavame g̃anduvihavuhu'ga nhimonha'ngai. A'ero ga osoldados'g̃a mondoi g̃a pyri g̃a moka'nhymbavuka imbokajuka g̃acidade, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","—Ojipe'g̃a pe ojipyrive'g̃a pe g̃anduvihavuhu'ga ei: “Amboavujikwe pa ji toryva novĩa. Kiroki g̃a pe ji a'e tuhu ti g̃a javo – g̃ahã oko te'varuhu reki upotare'yma,” ei ga, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","“Peho ti pepukuhua rupi nanani a'ero,” ei ga. “Pe'ji ti pevove'g̃a pe: ‘Pejo ti toryvi pe. Nhanderuvihavuhu'ga oapo toryva tahembireko jira'yra'ga javo.’ Nahã ti pe'ji g̃a pe nhaporemo g̃a ndepiagame,” ei ga, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","—“Kwa,” ei g̃a. Pepukuhua rupi g̃a hoi a'ero g̃a ndepiaga g̃a mono'ono'ombava, ei Jesus'ga. Ite'varuhuve'g̃a g̃a omono'õ pyryve'g̃a ndeheve g̃a nderovahema toryvi pe. Nahã he'yjuhuve'g̃a nduri hepiaga toryva. Ohygahi g̃a toryva rehe gara'yra'ga hembirekorame, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","—Toryva repiave'g̃a pyri g̃anduvihavuhu'ga hogahoi g̃wonga pe g̃a ndepindepiaga onhi'ig̃a g̃a pe, ei Jesus'ga. G̃a ndepindepiagame ga ojipe'ga repiagi. Gapira ko tapy'ynhapipyryva rũi – kiroki toryva repiagame g̃a ndopo'rui, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Nurã g̃anduvihavuhu'ga ei ga pe: “Kwãi,” ei ga ga pe. “Tapy'ynhapipyryva rũi ko nde eremongi. Marã nde ruri avo ekiavo toryva repiaga naerũ?” ei ga ga pe, ei Jesus'ga. —Nonhi'ig̃i reki ga. ");
INSERT INTO pahNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","A'ero g̃anduvihavuhu'ga ei ojipyrive'g̃a pe: “Pekwa ti gapya gapoa reheve! Peroho ti ga agwa hugwi ga momboa ypytunahiva pype. Pevo po ti ga jehe'oi ojihe onhimonha'ngavo hahyrame ojive nehẽ,” ei ga, ei Jesus'ga imombe'gwovo. ");
INSERT INTO pahNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","—A'ea ji amombe'u ikwahavuka pe me, ei Jesus'ga. Nahã Tupana'ga g̃a nderekoukari okorame yvyakotyve'g̃a nduvihavuhuhetero, ei Jesus'ga imombe'gwovo. A'ereki he'yjuhuve'g̃a pe Tupana'ga ei: “Herejo. Ejiko ti ji rehe ekovo jireheva'ero. Tako ti ji nderuvihavuhuhetero,” ei Tupana'ga, ei Jesus'ga. Ndahe'yive'g̃a reki ojiko Tupana'ga rehe okovo gareheva'ero, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Fariseus'g̃a ndopotari Jesus'ga imombe'urame nahã hekoi kiro Tupana'ga rekorame g̃anduvihavuhuhetero javo. A'ero g̃a hoi Jesus'ga hugwi. Ojohupe g̃a nhi'inhi'ig̃i. —Tihepia ti Jesus'ga reaporog̃ita. Mara'ngu po ti ga onhimbotegweteavouka nhande ve ga nhi'ig̃ame nehẽ? ei g̃a ojohupe. ");
INSERT INTO pahNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","A'ero g̃a g̃wemimbo'ehara'g̃a mondoi Jesus'ga pyri Herodes'gareheve'g̃a ndeheve nahanahã ti pe'ji Jesus'ga pe javo. —Kwa, ei g̃a. Nahã po ti ore ga moandyandyi nehẽ. Kiro g̃a hoi a'ero Jesus'ga pyri. Ovahemame g̃a nhi'ig̃atui Jesus'ga pe timoandyandyi ti ga javo. —Orembo'eharamo nde eremombe'ukatu mbatera, ei g̃a ga pe. A'itituhẽva'ea rehe nde ore mbo'e. Tupana'ga remimbotarimova'ea rehe nde erembo'e katu, ei g̃a Jesus'ga pe. A'ea rehe jate nde rekoi ekyhyjie'yma ojipe'g̃a hugwi ekoe'yma huvihava'g̃a ndehe jate. Nderekoi nde embohetetehea rehe no, ei g̃a ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Nurã ore ei nde ve torembo'e ti javo. Marã ndereaporog̃ita? César'gareheve'g̃a e'i: “Pemondomondo ti itambere'ia César'ga pe nhanderuvihavuhu'ga pe ga imono'og̃ukarame,” ei g̃a. Mara'ngu po nde javo: “Timondo ti”? Mara'ngu po nde javo: “Timondoyme ti”? ei g̃a Jesus'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ojohupe g̃a ei: —“Tapemondoi ti César'ga pe,” e po ti ga nhande ve nehẽ hamo, ei g̃a ojohupe. A'ero po ti nhande ga'eagwera mombe'ui César'ga pe nehẽ. A'ero po ti César'ga onhimonha'nga ga rehe nehẽ, ei g̃a ojohupe. Jesus'ga ombaragwaha omoandyandyipotara rehe. Nurã ga ei g̃a pe: —Ahemoandyiva'ero maranameuhũ pe ipotari nhimbote'vara nhirembi'ea rupi? ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Pehepiuka ti ji ve itambere'ia – akoja pe g̃a ei: “A'ea ti pemondomondo nhanderuvihavuhu'ga pe.” A'ea pehepiuka ji ve, ei Jesus'ga g̃a pe. A'ea g̃a heruri ga pe a'ero. ");
INSERT INTO pahNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Kiro Jesus'ga ei g̃a pe: —Ma'g̃a ra'angava hehe? Ma'g̃a ndera g̃a okwatija inog̃a hehe? ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","A'ero g̃a ei: —César'ga ra'angava. Garera tuhẽ g̃a okwatija inog̃a hehe, ei g̃a. A'ero Jesus'ga ei g̃a pe: —Pemondoa'ja ti César'ga rembiapoa ga pe a'ero. Tupana'ga rembiapoa ki a'e te pemondoa'ja Tupana'ga pe, ei ga g̃a pe. Yvyakotyve'g̃a pe Jesus'ga ei Tupana'ga rembiapoa tonhimondo ti g̃a onhikwava'eg̃a ga pe javo. ");
INSERT INTO pahNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Henduvame g̃a nhimomby'ai tegwete gamoandyihava javo. A'ero g̃a hoi ga hugwi ogwovo. ");
INSERT INTO pahNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","A'ea rupi jitehe saduceus'g̃a nduri Jesus'ga pyri. Saduceus'g̃a ndogweroviari omanove'g̃a mbogwerahava. Kiro g̃a nduri Jesus'ga pyri ovahema. A'ereki g̃a e'i ojohupe: —Mara'ngu po ti Jesus'ga onhimbotegweteavouka nhande ve ga nhi'ig̃ame nehẽ? ei g̃a ojohupe. ");
INSERT INTO pahNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","A'ero, orembo'eharamo javo, g̃a ei Jesus'ga pe: —Ymyahũ Moisésva'ea okwatija hako tokwaha ti g̃a javo. Aherembikwatijara e'i: “Po akwaimbae'ga manoi ta'yre'ymame g̃wembirekohẽa pe, a'ero ti gairũ'ga tahembireko hẽa pavẽi. Ta'y ti ga hẽa pe nhiirũva'ea togwereko gwakykwepohara'g̃a javo.” A'ea Moisésva'ea ikwatijari hako, ei g̃a Jesus'ga pe. Kiro g̃a imombe'ui omanove'g̃a Jesus'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","—Ymya seteva'ea ruvi avo onhoirũva'ea kako, ei g̃a Jesus'ga pe. Ojihuvypyva'ea rembirekoro kako. Ndata'yri ahe kunhangwerava'ea pe. Aerẽ akwaimba'eva'ea manoi, ei g̃a. A'ero aheakoindava rembirekoro aherembirekokwerava'ea pavẽi oirũva'ea py'rovo Moisésva'ea nhi'ĩpo'ruavo. ");
INSERT INTO pahNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Na jitehe aheakoindava pe a'ero. Omano ahe ta'yre'yma aherembirekokwerava'ea pe, ei g̃a. Na jitehe jarava'ea onhoirũva'ea nhaporemo ahe rembirekoro aherembirekokwerava'ea pavẽi. Ndata'ypavi reki seteva'ea aherembirekokwerava'ea pe. Omanomba ahe kako. Nahã ahe rekoi ojopy'ropy'rovo. ");
INSERT INTO pahNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Aerẽ mbapavamo aherembirekokwerava'ea manoi kako kunhangwerava'ea, ei g̃a Jesus'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","—Marã po ti a'ero nehẽ? ei g̃a Jesus'ga pe. Omanove'g̃a mbogweravame po ti Tupana'ga seteva'ea mbogweravi kunhangwerava'ea reheve nehẽ. Ma'g̃a nembirekoro po kunhangwerava'ea rekoi nehẽ ahe kwerava'javame nehẽ? A'ereki seteva'ea onhoirũva'ea hembireko kunhangwerava'ea pavẽi, ei g̃a. Emombe'u ti ore ve. Marã po ti a'ero nehẽ? ei g̃a Jesus'ga pe. A'ea g̃a imombe'utehei heroviare'yma g̃waramo omanove'g̃a mbogwerahava. ");
INSERT INTO pahNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Kiro Jesus'ga ei g̃a pe: —Pendeaporog̃ita ko Tupana'ga reaporog̃ita atyvi pe Tupana'ga nhi'ig̃a reroviare'ymame nahembogweravi po ti ga nehẽ javo. A'ereki pe ndapekwahakatui Tupana'ga rembikwatijarukara, ei Jesus'ga. Ndapekwahavi Tupana'ga popoakara no, ei ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Nahã ji ei pe me, ei Jesus'ga. Tupana'ga g̃a mbogweravame g̃amanoa hugwi po ti akwaimbae'g̃a nahembirekoa'javi nehẽ. Ojipe'g̃a po ti nomohembirekoa'javi kunhangwera'g̃a nehẽ no. Yvagi pe Tupana'gapyrive'g̃a oko g̃wembirekoe'ymamo. Tupana'gapyrive'g̃a ja yvagipeve'g̃a ja po ti g̃a nahembirekoi nehẽ no, ei Jesus'ga saduceus'g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","—Pemonhi'ĩ pe Tupana'ga rembikwatijarukara novĩa – kiroki omombe'u ahembogwerahava. Abraãova'ea manorẽ Tupana'ga ei ikwatijaruka hako: ");
INSERT INTO pahNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Jihi ko Tupanamo. Abraão'ga ji mbohete. Isaque'ga ji mbohete. Jacó'ga ji mbohete,” ei ga hako. —Ikwatijarukara rupi Tupana'ga ei pe me, ei Jesus'ga saduceus'g̃a pe. O'erame nahã Tupana'ga ikwahavukari pe me g̃a okoji javo. A'ereki Tupana'ga nde'i: “Abraãova'ea ji mbohete.” A'ereki Tupana'ga pe g̃a okoji, ei Jesus'ga saduceus'g̃a pe. A'ea Jesus'ga ei g̃a okwerava'ja omanorẽ javo. ");
INSERT INTO pahNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Jesus'ga nhi'ig̃a renduvame he'yive'g̃a nhimomby'ai garemimbo'ea rehe onhimongyavo. ");
INSERT INTO pahNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","35","Fariseus'g̃a ikwahavi Jesus'ga ea saduceus'g̃a pe. —Jesus'ga omombi saduceus'g̃a nhi'ig̃a g̃a omoandyandyipotarame, ei g̃a ojohupe. Kiro g̃apyteripeve'ga judeus'g̃a mbo'ehara'ga ei: —Mara'ngu po ti ga onhimbotegweteavouka nhande ve ga nhi'ig̃ame a'ero nehẽ? ei ga a'ea pota. Nurã g̃a nhimbojatykatykai ogwovo ovahema Jesus'ga pyri. A'ero ga ei Jesus'ga pe: ");
INSERT INTO pahNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","—Orembo'eharamo emombe'u ti ore ve, ei ga Jesus'ga pe. Manamo Moisésva'ea remimbo'eagwera huvihavamo joheva'ero? ei ga Jesus'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","A'ero Jesus'ga ei ga pe: —Moisésva'ea remimbo'eagwera e'i: “Pearõ hete tuhẽ ti pepojykaharete'ga Tupana'ga. Pearõ hete tuhẽ ti ga pejipy'a pe. Pearõ hete tuhẽ ti ga imondovo pejeaporog̃ita imohina ga rehe. Pearõ hete tuhẽ ti ga tako ti ji garemimbotarimova'ea rupi jate javo,” e'i, ei Jesus'ga ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","A'ea ko joheva'ea huvihava Moisésva'ea remimbo'eagwera, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","—Hehohyva'ea ko a'ea'java'ea Moisésva'ea remimbo'eagwera. A'ea e'i: “Penhiarõ hete pe. Na jitehe ti pearõ hete pejikotyve'g̃a”, ei Jesus'ga judeus'g̃a mbo'ehara'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","A'ea memei huvihava. A'ero hehe nhanderekorame nhande rekoi Moisésva'ea remimbo'eagwera rehe nhaporemo nhandekovo Tupana'ga nhi'ig̃a mombe'uharava'ea remimbo'eagwera rehe nhaporemo no, ei Jesus'ga ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Fariseus'g̃a nhimbojatykarame Jesus'ga pyri Jesus'ga ei g̃a pe: ");
INSERT INTO pahNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","—Marã pendeaporog̃ita Tupana'ga remimbuhurukara'ga rehe Cristo'ga rehe? Ma'g̃a rymyminoa po ti ga uhurame nehẽ? ei Jesus'ga g̃a pe. A'ero fariseus'g̃a ei: —Ga po ti Daviva'ea rymyminoa nehẽ, ei g̃a Jesus'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Kiro Jesus'ga ei g̃a pe: —Na tuhẽ. Cristo'ga ko Daviva'ea rymymino'ga. Emo Tupana'ga ra'uva ombo'e Daviva'ea Cristo'ga ko ndepojykaharetero oko javo ga pe. Maraname Daviva'ea e'i Cristo'ga pe ga ko jipojykaharetero oko javo Cristo'ga rekorame Daviva'ea rymyminoro? Ymyahũ Daviva'ea okwatija a'ea mombe'gwovo inog̃a. Ikwatijarame ahe ei hako: ");
INSERT INTO pahNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","“Tupana'ga e'i jipojykaharete'ga pe: ‘Eapy na'ẽ ti ji pyri jijohukoty rũi ekovo huvihavamo epytavo. Tamongo ti ji nearõe'ỹve'g̃a neremimbotarimova'ea rehe nehẽ,’ ei Tupana'ga,” ei Daviva'ea ikwatija hako, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","—A'ea Daviva'ea ei imombe'gwovo Cristo'ga ko jipojykaharetero oko javo. Ga ko Daviva'ea rymymino'ga jate rũi naerũ, ei Jesus'ga onhimombe'gwovo g̃a pe g̃a mbojapyakavo. G̃a mbojapyakavo Jesus'ga ei a'ea onhimombe'gwovo ikwahavipeavo Cristo'ga ko Daviva'ea rymymino'ga jate rũi javo. ");
INSERT INTO pahNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","G̃a pe tegwete Jesus'ga nhi'ĩpondekwava. A'ero kiro g̃a nde'ia'javag̃wami Jesus'ga pe: “Maramarã?” A'ereki g̃a ga pojihu. ");
INSERT INTO pahNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","A'ero Jesus'ga ei he'yive'g̃a pe g̃wemimbo'ehara'g̃a pe no. ");
INSERT INTO pahNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Ga e'i g̃a pe: —Judeus'g̃a mbo'ehara'g̃a fariseus'g̃a pavẽi ombo'e Moisésva'ea remimbo'eagwera rehe Moisésva'ea py'rovo g̃a nhande mbo'erame. ");
INSERT INTO pahNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Nurã g̃a pe mbo'erame nahanahã ti peko javo, a'ero ti peko pa g̃anhi'ig̃a rupi, ei Jesus'ga. Emo g̃andekote'varuhua rupi ti tapekoi. A'ereki g̃a e'i pe me novĩa: “Pehendu katu ti Moisésva'ea remimbo'eagwera.” G̃a ki a'e te nohendukatui a'ea, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","G̃a e'i: “Nahanahã ti peko pejikorame Moisésva'ea nhi'ig̃agwera rupi,” e'ie'i g̃a nhande ve, ei Jesus'ga. Emo g̃a ndokopavi Moisésva'ea nhi'ig̃agwera rupi, ei Jesus'ga. Oko pa po g̃a hupi hamo. Onhi'ig̃a rupi g̃a ndokopavi no. G̃a ko g̃a ja – kiroki g̃a omondo ipohyjuhuva'ea ojipe'g̃a arimo g̃a pokoge'yma, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","—Okokaturame g̃a ei oyvyteri pe: “Pyry ojipe'g̃a nhande rekokatua repiagi. A'ero po ti g̃a nhande mbohetei g̃a oko hete Tupana'ga nhi'ig̃a rupi javo.” Nahã g̃a ete'varuhui oyvyteri pe imondoe'yma ojeaporog̃ita Tupana'ga rehe jate, ei Jesus'ga. —Ombohetea potaruhuro g̃waramo hehãi'iuhũva'ea g̃a japoi Tupana'ga rembikwatijara ryruhu'ia inog̃a ojihe ejetovapya rehe. Ono g̃a irũa hyruhu'ia ojyva rehe no, ei Jesus'ga. Judeus'g̃a omongi hyruhu'ia okovo Tupana'ga nhi'ig̃a rupi jipi. Na tuhẽ. Emo judeus'g̃a mbo'ehara'g̃a apoa fariseus'g̃a apoa pavẽi koji'i hehãi ojipe'g̃a apoa hohe hyruhu'ia tianembohete ti g̃a javo. —Franjas ipukupukuhu'iva'ea g̃a japoi omboja opira rembeyvyra rupi imondovo, ei Jesus'ga. Jatu'riva'ea franjas judeus'g̃a omboja hupi okoheterame Tupana'ga rehe. Na tuhẽ. Emo judeus'g̃a mbo'ehara'g̃a apoa fariseus'g̃a apoa pavẽi koji'i ipukuhu ojipe'g̃a apoa hohe. Nahã g̃a japoi ojikwahavuka ojipe'g̃a pe tianembohete ti g̃a javo, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","—O'u pota g̃a toryva jara'g̃a pyri toryva repiagame. Na jitehe g̃a apypotaruhui nhanderuvihava'g̃a apykava rehe nhandejatykahava pype, ei Jesus'ga. A'ereki g̃a e'i te'varuhu oyvyteri pe: “Nhande mboheteavo ti g̃a tianderepia pa. A'ereki nhande g̃anduvihavuhuhetero xako,” ei g̃a oyvyteri pe, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","—Ikatuuhu g̃a pe ojipe'g̃a mbaragwahavame g̃a ndehe ima'ẽhai pe feira pe onhi'ig̃atuavo g̃a pe pe ko orembo'eharamo javo g̃a pe, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","G̃wemimbo'ehara'g̃a pe Jesus'ga ei: —Pe ki a'e te g̃a ja rũi peko, ei Jesus'ga. A'ereki jihi jate ako pembo'eharamo Cristoramo, ei Jesus'ga. Pe reki penhoirũ. A'ereki pe pejiko Tupana'ga rehe. A'ero ojo'javuhu pe hoi. Nurã ti tape'ei pejohupe pe ko orembo'eharamo javo. A'ea ti tape'ei pejohupe penhimbohetee'yma, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","—Tape'ei ti avove'ga pe yvyakotyve'ga pe – kiroki ga oko peirũ'ga ojikoga g̃waramo Tupana'ga rehe – ga pe ti tape'ei apĩ javo. A'ea ti tape'ei ga pe. A'ereki ojipeji ko ga penduvetero Tupana'ga yvagipeve'ga, ei Jesus'ga g̃wemimbo'ehara'g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","—Te'iyme ti g̃a pe me pe ko oreruvihavamo javo. A'ea ti g̃a te'iyme pe me pe mbohetee'yma, ei Jesus'ga. A'ereki jihi jate ako penduvihavuhuhetero Cristoramo, ei Jesus'ga g̃wemimbo'ehara'g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Po ti pe ndekopotari jireheve'g̃a nduvihavamo penhiirũ'g̃a nduvihavamo, a'ero ti peko katu g̃a pe g̃a pokoga, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","—Po pe ei: “Jihi ko huvihavamo ojipe'g̃a hohe pa.” Po pe ei a'ea penhimboheteavo pejikovo aha huvihavamo, a'ero po ti Tupana'ga ei pe me nehẽ: “Ndapekoi pe huvihavamo. Tapenhimbohetei ti!” A'ea po ti Tupana'ga ei pe me nehẽ, ei Jesus'ga. Po pe napenhimbohetei pejikokatuavo ojipe'g̃a pe, a'ero po ti Tupana'ga ei pe me nehẽ: “Peko ti huvihavamo.” A'ea po ti ga ei pe me nehẽ, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","—Ahemoandyandyiva'ero pe peko! ei Jesus'ga judeus'g̃a mbo'ehara'g̃a pe fariseus'g̃a pe no. Tiruahũ ti pe me! A'ereki pe napembo'ekatui Tupana'ga nhi'ig̃a rehe herojijyita. Nurã hajihea rehe pe g̃a mbo'ei g̃a moandyandyita, ei Jesus'ga g̃a pe. Pereko pe Tupana'ga nhi'ig̃a aherembikwatijara novĩa timonhi'ĩ javo. A'ereki pe ndapekoi Tupana'ga nhi'ig̃a rupi pejikoge'yma ga rehe. G̃a ndekopotarame ganhi'ig̃a rupi pe napemombe'ukatui g̃a pe, ei Jesus'ga. Nahã pe napemongoi g̃a ganhi'ig̃a rupi g̃a mbojikoge'yma ga rehe. A'ero pe ja g̃a nde'i Tupana'ga pe nde oreruvihavuhuhetero ereko jave'yma, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","—Ahemoandyandyiva'ero pe peko! ei Jesus'ga judeus'g̃a mbo'ehara'g̃a pe fariseus'g̃a pe no. Tiruahũ ti pe me! A'ereki pe pepojykaahy mbatera aherembirekokwera'g̃a hugwi, ei Jesus'ga. Penhi'imbukuhu tehe pe Tupana'ga pe. Pe'e pe pejiyvyteri pe: “Nhande renduvame po ti ojipe'g̃a ei nhande ve oarõ hete g̃a Tupana'ga javo.” Nurã jate pe nhi'inhi'ig̃i Tupana'ga pe ga arõe'yma, ei Jesus'ga. Kaitu po ti hahy hete pe me a'ero nehẽ, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","—Ahemoandyandyiva'ero pe peko! ei Jesus'ga judeus'g̃a mbo'ehara'g̃a pe fariseus'g̃a pe no. Tiruahũ ti pe me! A'ereki pe pejiheve'g̃a mbote'va hete. A'ero g̃a ko koji'i oko te'varuhu pe hohe duas vezes pe hohe. Pe po ti peho hahyva'ea ruvihava pype nehẽ pendekote'varuhuro g̃waramo. G̃a kaitu po ti oho hahyva'ea ruvihava pype nehẽ okote'varuhuhetero g̃waramo, ei Jesus'ga. “Pyry,” pe'e pe g̃a ndekorame pe ja. A'ereki pe peporavyky hete ojipeji'ga mbote'varuhuavo. Pehopeho pe ga rehe ya rupi pea rupi no tiroviaruka ti pevove'ga pe nhanenhi'ig̃a javo. Nahã pe ga mbote'varuhui. Nurã po ti tiruahũ pe me nehẽ, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","—Heakwagweve'g̃a'java'ero pe peko! A'ereki pe ndapekwahavi, ei Jesus'ga judeus'g̃a mbo'ehara'g̃a pe fariseus'g̃a pe no. Pe peroho ojipe'g̃a penhinhi'ig̃a rupi no. Tiruahũ ti pe me! Nahã ji ei pe me. A'ereki Tupana'ga nhi'ig̃aatyviva'ea rehe pe ojipe'g̃a mbo'ei. —Nahã pendeaporog̃ita te'varuhuro. Po ojipe'ga ehetei: “Nahanahã po ti ji rekoi nehẽ. Tupana'ga ronga renoina nhandejatykahavuhua renoina ji ei a'iti hete nhinhi'ig̃a javo,” ei ga, ei Jesus'ga. A'ero pe ei: “O'erame Tupana'ga ronga renoina po ga etehei a'ero. Ga okopotare'ymame onhi'ig̃a rupi, na ga ndokoi hupi a'ero,” pe'ji tehe pe, ei Jesus'ga. Tupana'ga nhi'ig̃aatyviva'ea rehe pe g̃a mbo'ei, ei Jesus'ga. —Po ojipe'ga ehetei: “Nahanahã po ti ji rekoi nehẽ. Ouro renoina nhandejatykahavuhuapypeva'ea renoina ji ei a'iti hete nhinhi'ig̃a javo,” ei ga, ei Jesus'ga. A'ero pe ei: “O'erame ouro renoina, a'ero ti ga toko tuhẽ onhi'ig̃a rupi,” pe'e pe, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","—Ikwahave'ỹva'ero pe peko! ei Jesus'ga judeus'g̃a mbo'ehara'g̃a pe fariseus'g̃a pe no. Ndapekwahavi'i'i! Tupana'ga ronga nhandejatykahavuhua koji'i pyry hete Tupana'ga pe. G̃a ouro po'rurame jate Tupana'ga ronga pype nhandejatykahavuhua pype Tupana'ga omombyry ouro, ei Jesus'ga. —Tupana'ga nhi'ig̃aatyviva'ea rehe pe g̃a mbo'ei, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Po g̃a ehetei ojipe'ga pe: “Nahanahã po ti ji rekoi nehẽ. Ikwava'ẽhava renoina ji ei a'iti hete nhinhi'ig̃a javo,” e po g̃a, ei Jesus'ga. A'ero pe ei: “O'erame ikwava'ẽhava renoina po g̃a etehei a'ero. G̃a okopotare'ymame onhi'ig̃a rupi, na ga ndokoi hupi a'ero,” pe'ji tehe pe, ei Jesus'ga. Tupana'ga nhi'ig̃aatyviva'ea rehe pe ei g̃a mbo'eavo, ei Jesus'ga. —Po g̃a ehetei ojipe'ga pe: “Nahanahã po ti ji rekoi nehẽ. Kiroki a'ea ji amondo ikwava'ẽhava rehe – a'ea renoina ji ei a'iti hete nhinhi'ig̃a javo,” e po g̃a, ei Jesus'ga. A'ero pe ei: “O'erame ikwava'ẽhavareheva'ea renoina, a'ero ti g̃a toko tuhẽ onhi'ig̃a rupi,” pe'e pe, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","—Ikwahave'ỹva'ero pe peko! ei Jesus'ga judeus'g̃a mbo'ehara'g̃a pe fariseus'g̃a pe no. Ndapekwahavi'i'i! Ikwava'ẽhava koji'i pyry hete Tupana'ga pe. G̃a nhaneremimondoa nog̃ame jate ikwava'ẽhava rehe Tupana'ga omombyry nhaneremimondoa, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","—Po g̃a ehetei: “Nahanahã po ti ji rekoi nehẽ. Ikwava'ẽhava renoina ji ei a'iti hete nhinhi'ig̃a javo.” Po g̃a ei nahã, a'ero g̃a ehetei ikwava'ẽhava pe a'eareheva'ea pe nhaporemo no, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","—Po g̃a ehetei: “Nahanahã po ti ji rekoi nehẽ. Tupana'ga ronga renoina nhandejatykahavuhua renoina ji ei a'iti hete nhinhi'ig̃a javo.” Po g̃a ei nahã, a'ero g̃a ehetei garonga pe ipypeve'ga pe no Tupana'ga pe, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","—Po g̃a ehetei: “Nahanahã ti ji rekoi. Yvaga renoina ji ei a'iti hete nhinhi'ig̃a javo.” Po g̃a ei nahã, a'ero g̃a ehetei Tupana'ga apykava pe. A'ereki yvagi pe Tupana'ga oko nhanderuvihavuhuhetero oapyga. A'ero o'erame yvaga pe g̃a ei Tupana'ga pe tuhẽ a'ero, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","—Ahemoandyandyiva'ero pe peko! ei Jesus'ga judeus'g̃a mbo'ehara'g̃a pe fariseus'g̃a pe no. Tiruahũ ti pe me! A'ereki pe ndapekokatui pejikokatue'yma ojipe'g̃a pe. Tiruahũ ti pe me! A'ereki pe peko tehe Moisésva'ea remimbo'eagwera rupi, ei Jesus'ga. —Petỹ pe imboheva'ea: hortelã erva-doce reheve cominho reheve. Pe herekorame dez itymipyra pe pemondo ojipeji Tupana'ga pe pejikovo Moisésva'ea remimbo'eagwera rupi. A'ea pyry Tupana'ga pe novĩa, ei Jesus'ga. Emo pe ndapekokatupavi Moisésva'ea remimbo'eagwera rupi. A'ereki pe ndapekokatui pejikokatue'yma ojipe'g̃a pe, ei Jesus'ga. —Peko katu po pe hamo pejikokatuavo ojipe'g̃a pe hamo, ei Jesus'ga. Penemimondoa ojive Tupana'ga ipotari. Emo ga pe koji'i huvihava pendekokatua. Pe ndapeporogwetygi ojipe'g̃a. Peporogwety po pe g̃a hamo, ei Jesus'ga. Penemimondoa Tupana'ga pe pyry ga pe. Emo ga pe koji'i huvihava g̃aporogwetyga, ei Jesus'ga. —Napembojikogukari ojipe'g̃a pejihe penhi'mberame g̃a pe. Pembojikoguka po pe g̃a pejihe hamo penhi'mbee'yma hamo, ei Jesus'ga g̃a pe. Penemimondoa pyry Tupana'ga pe. Emo ga pe koji'i huvihava g̃ambojikogukara pejihe. Peko ti gareaporog̃ita rehe. Tapemondopigi ti ga pe no, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","—Heakwagweve'g̃a'java'ero pe peko! A'ereki pe ndapekwahavi, ei Jesus'ga judeus'g̃a mbo'ehara'g̃a pe fariseus'g̃a pe no. Pe peroho ojipe'g̃a penhinhi'ig̃a rupi. Pembogwambogwa pe mberu'i'ia ta'uyme ti ji ite'varuhuva'ea javo. Emo pe pe'u reki ite'varuhuheteva'ea hehanhuhũva'ea yuranuhũa'javuhuva'ea jaime camelo jaime. Nahã ji ei pe me. A'ereki pe peko hete a'ea rehe – kiroki huvihava gwere Tupana'ga pe. Kiroki huvihava hete Tupana'ga pe – a'ea rehe pe ndapekoi, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","—Ahemoandyandyiva'ero pe peko! ei Jesus'ga judeus'g̃a mbo'ehara'g̃a pe fariseus'g̃a pe no. Tiruahũ ti pe me! A'ereki pe'ara tehe oko Tupana'ga nhi'ig̃a rupi pe jikoe'ymame ganhi'ig̃a rupi pejiyvyteri pe, ei Jesus'ga. A'ea pe ji ei ji erame pe me: Copo ara prato ara reheve pepyhei hete pe. G̃waimbya pe ndapepyhei reki. Nahã ji ei. Peyvytera ite'varuhu pa. A'ereki pe pepotaruhu pa ipyhygahyavo mbatera pejive pejikote'varuhuavo, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","—Heakwagweve'ga'java'ero nde ereko, fariseu! ei Jesus'ga g̃apyteripeve'ga pe. Epohi ti ejekote'varuhua hugwi ejeaporog̃itakaturo. A'ero po ti nde rekokatui ejikokatuavo ojipe'g̃a pe nehẽ, ei Jesus'ga. A'ea pe ji ei ji erame nde ve: Epyhei copo pype prato pype reheve. A'ero copo ara ikatu no prato ara reheve, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","—Ahemoandyandyiva'ero pe peko! ei Jesus'ga judeus'g̃a mbo'ehara'g̃a pe fariseus'g̃a pe no. Tiruahũ ti pe me! A'ereki pe aheryvya ja, ei Jesus'ga. Ikatu tehe tapyja ita apopyra novĩa – kiroki oko aheryvya rehe. A'ereki g̃a omotig̃uhũ imbokatuavo tapyja. Ipype reki ite'varuhu herekovo inema ahekag̃a reheve, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","—Na jitehe pe ndekoi. Ojipe'g̃a ei pe mombe'gwovo novĩa: “Ehepia g̃a! Pyry hete g̃a okovo Tupana'ga nhi'ig̃a rupi.” Ikwahave'yma g̃a ei nahã pe mombe'gwovo, ei Jesus'ga. A'ereki pe ojipe'g̃a moandyandyi. A'ereki peyvyteri pe reki pendeaporog̃ita ite'varuhu, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","—Ahemoandyandyiva'ero pe peko! ei Jesus'ga judeus'g̃a mbo'ehara'g̃a pe fariseus'g̃a pe no. Tiruahũ ti pe me! A'ereki ymyahũ penamonhava'ea ojukajuka Tupana'ga nhi'ig̃a mombe'uharava'ea pyryva'ea. Pe reki japokatui tapyja aheryvya rehe. A'ea pe imbokatui, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Pe pe'e: “Po ymyahũ nhande rekoi nhaneramonhava'ea pyri, a'ero po nhande ndiahoi ahe rupi Tupana'ga nhi'ig̃a mombe'uharava'ea jukavo hamo.” ");
INSERT INTO pahNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","—A'ea pe erame pe pejikwahavuka ojipe'g̃a pe ore ko aherakykwepoharamo javo – kiroki ahe ojukajuka Tupana'ga nhi'ig̃a mombe'uharava'ea, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Ndojukapavi ahe ganhi'ig̃a mombe'uhara'g̃a. Pejuka pota po ti pe hembyruera'g̃a naerũ? ei Jesus'ga. G̃a jukarame po ti pe ndekote'varuhuhetei penhamonhava'ea ja imbuhuruka hahyhetea pejihe nehẽ, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Ite'varuhuva'ero pe peko! ei Jesus'ga g̃a pe. Ite'varuhuva'ea ra'yro pe peko! ei ga g̃a pe. Tegwete peka'nhyhava hahyva'ea hugwi. Tupana'ga po ti pe mondo tuhẽ hahyva'ea ruvihava pype nehẽ, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","—Pejuka pota pe g̃a. A'ero kiro ji amondouka g̃a pe pyri nehẽ nhinhi'ig̃a mombe'uhara'g̃a Tupana'ga remimbotarimova'ea kwahapyra'g̃a ndeheve jireheve'g̃a mbo'ehara'g̃a ndeheve nehẽ no, ei Jesus'ga. Ojipe'g̃a po ti pe g̃a jukai nehẽ. Ojipe'g̃a po ti pe g̃a mondoi yva rehe g̃a mbovya hehe nehẽ, ei Jesus'ga. Ojipe'g̃a po ti pe g̃a nupanupãi ipira apopyra pyvõ g̃a mondohondohoga pejatykahavuhua pype nehẽ, ei Jesus'ga. Peko te'varuhu po ti pe g̃a pe pejigwojigwovo g̃a ndeviri nahã g̃a monhamonhana ojipejipe pe cidades pe nehẽ, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","—G̃a nhaporemo po ti ji g̃a mondoukari pe pyri nehẽ Tupana'ga ti tomondo hahyva'ea pe me nehẽ pe g̃a jukarame nehẽ javo, ei Jesus'ga. A'ero po ti ga imondoi hahyva'ea pe me okokatuva'ea repypava nehẽ. —Ymyahũ ahe ojiko Tupana'ga rehe okokatuavo. Nurã ymyahũ penamonhava'ea ojuka ahe, ei Jesus'ga. Penamonhava'ea ojuka ypy Abelva'ea. Abelva'ea ko okokatuva'ea. Aerẽ penamonhava'ea he'yiva'ea jukai. Mbapavamo ahe ojuka Zacariasva'ea Baraquiasva'ea ra'yrava'ea. Omano Zacariasva'ea nhandejatykahavuhua pyri templo pyri okara mbyteri pe ikwava'ẽhava pyri, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Imombe'ukatuavo ji ei pe me: Tupana'ga po ti imondoi hahyva'ea pe me nehẽ. A'ereki penamonhava'ea ojukajuka ahe, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Kiro Jesus'ga ei: —Jerusalémmeva'ero pe pejuka Tupana'ga nhi'ig̃a mombe'uharava'ea jipi, ei Jesus'ga cidadepeve'g̃a pe Jerusalémmeve'g̃a pe. Tupana'ga ahe mondoukarame pe pyri pe peapiapi ahe jipi ahe jukavo, ei Jesus'ga. Inamutig̃a omono'ono'õ gway'ria opepoa gwyri pe. Na jitehe ji pe mono'ombotara'jara'javi ji pyri inamutig̃a ja pe nderekokatupota novĩa. Emo pe ndapepotaruhui reki, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","—Pehendu ti a'ero! ei Jesus'ga. Kiro po ti Tupana'ga pohiri pe hugwi nehẽ. Ga ndohepiakatua'javi pejatykahavuhua a'ero nehẽ. Pe tehe po ti peko a'ero nehẽ. ");
INSERT INTO pahNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Pe ndajirepiaga'javi nehẽ, a'e katu ji pe me, ei Jesus'ga. Aerẽ jate po ti ji rura'javi nehẽ. A'ea rupi po ti pe ei nehẽ: “Tupana'ga ti tomombyry Jesus'ga pe. Gaha ko Tupana'ga ga mbuhuruka,” pe'e po ti pe nehẽ, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Kiro Jesus'ga hemi gwe'yja'g̃a jatykahavuhua hugwi ogwovo. Garemimbo'ehara'g̃a nduri ga pyri. —Ehepia nhandere'yja'g̃a jatykahavuhua ongare'yjuhua ita apopyra, ei g̃a ga pe a'ero. Nahã g̃a ei ga pe hepiuka ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","A'ero Jesus'ga ei g̃a pe: —Pehepia pe nhandejatykahavuhua nhaporemo avo, ei ga g̃a pe. Imombe'ukatuavo ji ei pe me: Aerẽ po ti ndojikojikoga'javi ojogwehe itauhua nehẽ. Omonduru pa po ti g̃a inog̃a nehẽ, ei Jesus'ga g̃wemimbo'ehara'g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Aerẽ Jesus'ga hoi ogwovo yvytyruhu pe oliveiras ndyvuhu pe monte das Oliveiras pe. Pevo ga apygame garemimbo'ehara'g̃a nduri ga pyri ojipe'g̃a ndovakie'ỹ. Kiro g̃a ei ga pe: —Emombe'u ti ore ve. Maname po ti g̃a imondurugi nhandejatykahavuhua nehẽ? Marãva'ea po ti Tupana'ga hepiukari na'ẽ ahemonhimomby'ava'ea nehẽ ikwahavuka nhande ve nehẽ? A'ero po ti nhande ikwahavi nehẽ Jesus'ga uhura'ja g̃werĩ javo. Gara na'ẽ po ti Tupana'ga gwepiuka ikwahavuka nhande ve nehẽ? A'ero po ti nhande ikwahavi nehẽ kiro mbapava koty javo, ei g̃a Jesus'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","A'ero Jesus'ga ei g̃a pe: —Penhimboko'i ti! Tapenhimoandyandyjukari ti g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Aerẽ po ti he'yjuhuve'g̃a uhu ji ra'ãra'ãteheavo javo nehẽ: “Jihi ko Cristoramo Tupana'ga remimbuhurukaramo.” A'ea po ti g̃a ei o'mbero nehẽ, ei Jesus'ga. He'yjuhuve'g̃a po ti heroviari g̃a'mbea nehẽ, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","—Aerẽ po ti ojipe'g̃a tavukari ojipe'g̃a pe nehẽ. A'ero po ti g̃a ei pe me: “Ira'agwe g̃a tavukari. Paivouhu g̃a ndekoi otavuka no,” e'i po ti g̃a pe me nehẽ. G̃a a'ea imombe'urame pe me ti tapemomynhukari g̃a pe pejipy'a penhimongyhyjiukare'yma nehẽ. Otavuka tuhẽ po ti g̃a nehẽ. A'ea rupi rũi po ti mbapavakotyva'ea nehẽ, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","—G̃agwyripeve'g̃a po ti oko na'ẽ ojipe'g̃a gwyripeve'g̃a ndehe otavuka nehẽ. Ojipe'g̃a nduvihavuhu'g̃a po ti omondo ojigwyripeve'g̃a otavuka ojipe'g̃a nduvihavuhu'g̃a gwyripeve'g̃a pe nehẽ, ei Jesus'ga. Ahã po ti g̃a pe mbatera avo nehẽ. Pevo po ti ty'ara g̃a jukai nehẽ no, ei Jesus'ga. Omyomyi po ti yvya avo nehẽ. Pevo po ti yvya imyimyi nehẽ no, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Nahã ypy po ti nehẽ. Aerẽ po ti koji'i tiruahũ nehẽ, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","—A'ea renonde po ti g̃a pe pyhygi pe nderohoahyavo huvihava'g̃a pyri nehẽ tomondo ti g̃a hahyva'ea g̃a pe javo. A'ero po ti g̃a imondoi hahyva'ea pe me pe jukavo nehẽ. Nahã po ti yvyakotyve'g̃a ndekopavi pe ndehe pe arõe'ỹheteavo nehẽ pejikoga g̃waramo ji rehe, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","—A'ero po ti he'yjuhuve'g̃a jireheve'g̃a pohiri ji hugwi okote'varuhuavo hendukatue'yma nhinhi'ig̃a nehẽ hahyro g̃waramo ojive, ei Jesus'ga. Onhokwava'eg̃uka po ti g̃a nhiarõe'ỹve'g̃a pe nehẽ tomondo ti g̃a hahyva'ea g̃a pe javo, ei Jesus'ga. Nonhoarõi hete po ti g̃a okovo opohirame nhinhi'ig̃a hugwi nehẽ, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Tupana'ga nhi'ig̃aatyviva'ea mombe'uhara'g̃a nduri he'yjuhuve'g̃a nehẽ. Ganhi'ig̃a rũi po ti g̃a imombe'ui he'yjuhuve'g̃a moandyandyita, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Jypya jireheve'g̃a onhoarõ hete. Aerẽ po ti igwaigwavete g̃ambyteripeve'g̃a nonhoarõi onhimongyavo nehẽ. A'ereki igwaigwavete yvyakotyve'g̃a okote'varuhu, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","—Kiroki ga onhimboita avuirama opohire'yma ji hugwi – gaha po ti ji ga reroho yvagi pe ga mongovo avuirama jijipyri nehẽ, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","A'ea pyryva'ea po ti nhinhi'ig̃areheve'g̃a imombe'umbe'ui yvyakotyve'g̃a pe nhaporemo mbapava renonde. G̃a po ti e'i g̃a pe nehẽ: “Perojijyjijyjuka ti pejeaporog̃ita Tupana'ga pe pejikoga ga rehe. A'ero po ti ga pe pokokatui nehẽ imomboa pendekote'varuhua pe hugwi okovo penduvihavuhuhetero nehẽ.” A'ea po ti g̃a imombe'ui g̃a pe nhaporemo tokwaha pa ti g̃a javo. Yvyakotyve'g̃a gwyripeve'g̃a nhaporemo henduvame g̃anhi'ig̃a po ti ji rura'javi nehẽ mbapava koty nehẽ, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","—Aerẽ po ti pe hepiagi ite'varuhuheteheteva'ea jipiukarame o'ama Tupana'ga apoa pype ipojykahava pype. Ymyahũ ite'varuhuheteheteva'ea ahe imombe'ui ikwatija Danielva'ea Tupana'ga nhi'ig̃a mombe'uharava'ea hako, ei Jesus'ga. (Kiroki ga omonhi'ĩ ag̃a ikwatijara – tokwaha ti ga.) ");
INSERT INTO pahNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","—Pe hepiagame ite'varuhuheteheteva'ea jipiukari. A'ea rupi ti Judéiapeve'g̃a toka'nhy onhana yvytyruhu pe onhimima nehẽ xamanoyme ti javo, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Kiroki g̃a oko ongapereuhuva'ea arimo – g̃ahã ti kotihĩ toka'nhy onhana. Tokiyme ti g̃a g̃wonga pype ombatera renoheme'yma jugwi, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Kiroki g̃a oko ko pe – g̃ahã ti kotihĩ toka'nhy onhana. Tokiyme ti g̃a g̃wonga pe opira renoheme'yma, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Iporia'i po ti ipuru'ave'g̃a a'ea rupi oka'nhypotarame nehẽ. Iporia'i po ti g̃a nehẽ no – kiroki g̃a omoka'mbuka'mbu gwa'yra'g̃a g̃a nenonhapotarame, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","—Pe'ji ti Tupana'ga pe: “Ite'varuhuheteheteva'ea jipiukarame po ti ore noroka'nhypotari yapouhua rupi. A'ereki a'ea rupi hahy ore ve ore horame. Nurã ti terembuhurukari ite'varuhuheteheteva'ea yapouhua rupi.” A'ea ti pe'ji Tupana'ga pe, ei Jesus'ga. Pe'ji ti ga pe: “Noroka'nhypotari ore sábado rupi oreporavykye'yma rupi. A'ereki Moisésva'ea e'i irupe rũi ahe toho nhandeporavykye'yma rupi javo. A'ea rupi rũi ti toroka'nhy. Nurã ti terembuhurukari ite'varuhuheteheteva'ea sábado rupi.” A'ea ti pe'ji Tupana'ga pe, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","—A'ea ji ei pe momoranduva penhimboko'i ti aerẽva'ea hugwi tiruahũheteva'ea hugwi javo. Ite'varuhuheteheteva'ea jipiukarame po ti tiruahũ hete tuhẽ pe me nehẽ. Tupana'ga rembiapoypyagwera jate ndogwerekoi a'ea'java'ea. Aerẽ po ti ndogwerekoa'javi a'ea'java'ea nehẽ no, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","—Aerẽ po ti Tupana'ga omombi tiruahũheteva'ea nehẽ. A'ereki ga e'i jipe: “Momi po ti g̃akira hehe nehẽ. A'ero kirupi!” ei ga. Po ti mbegwe ga imombigi tiruahũheteva'ea nehẽ, a'ero po ti yvyakotyve'g̃a manombavi nehẽ. “Tahahya'javyme ti nhiremimo'ẽhara'g̃a pe,” ei ga. Nurãro g̃waramo po ti ga imombigi nehẽ, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","—Aerẽ po ti ojipe'g̃a ei pe me nehẽ: “Pehepia! Avo ko Cristo'ga Tupana'ga remimbuhurukara'ga.” Po ti g̃a ei a'ea, a'ero ti taperoviari g̃a'mbea, ei Jesus'ga. Po ti g̃a ei pe me nehẽ: “Pehepia! Pevo ko Cristo'ga Tupana'ga remimbuhurukara'ga.” Po ti g̃a ei a'ea, a'ero ti taperoviari g̃a'mbea, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","—Aerẽ po ti ojipe'g̃a ei nehẽ: “Jihi ko Cristoramo Tupana'ga remimbuhurukaramo,” e po ti g̃a o'mbero nehẽ, ei Jesus'ga. Ojipe'g̃a ei nehẽ: “Jihi ko Tupana'ga nhi'ig̃a mombe'uharamo,” e po ti g̃a o'mbero nehẽ, ei Jesus'ga. A'ea rupi po ti g̃a ei nehẽ: “Tiapoapo tuhẽ ti ahemonhimomby'aheteva'ea g̃a pe hepiuka g̃a moandyandyita, Tupana'ga remimo'ẽhara'g̃a vehevi po.” A'ea po ti g̃a ei japovo nehẽ, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Pehendu ti! ei Jesus'ga. Opomomorandu ji ko nahã po ti tiruahũva'ea nehẽ javo, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","—Nurã ti tapehenduvi g̃anhi'ig̃a. Po ti g̃a ei pe me nehẽ: “Pehepia! Cristo'ga oko ongae'ỹi me.” G̃a erame na, a'ero ti tapehoi ongae'ỹi me hepiaga. A'ereki g̃a i'mbe. Ji rũi po ti nehẽ, ei Jesus'ga. Po ti g̃a ei pe me nehẽ: “Pehepia! Cristo'ga oko oki pe g̃andovakie'ỹ.” G̃a erame na, a'ero ti taperoviari g̃anhi'ig̃a, ei Jesus'ga. A'ereki g̃a i'mbe. ");
INSERT INTO pahNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","—Ji rura'javame tupã veraverava ja po ti ji rekoi nehẽ. Tupã veraveravame kwara ipora koty ombokojahu pa yvaga kwara ihoa koty vehevi, ei Jesus'ga. A'ero ahe gwepia pa kojahua. Na jitehe po ti g̃a ji repiapavi jirura'javame yvaga hugwi nehẽ yvyakotyva'ero yvagipeva'ero no. ");
INSERT INTO pahNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","—Jukwaha po ti nehẽ, ei Jesus'ga. Ahe manorame ti huruvua onhimongy ahera'oa pyri nehẽ ti'u javo. A'ea Jesus'ga ei na jitehe po ti jukwaha jirura'javame nehẽ javo. ");
INSERT INTO pahNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","—G̃a tiruahumbavirẽ pe me “po ti kwara igwevi nehẽ”, ei Jesus'ga. “Jahya po ti nombokojahua'javi nehẽ no. Jaytata'ia po ti indurundurugi yvaga hugwi nehẽ. Yvagipeva'ea po ti ig̃wyg̃wymi ipopoakava'ea nehẽ”, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","A'ero po ti Tupana'ga hepiukari yvagipeva'ea nehẽ tokwaha ti yvyakotyve'g̃a Jesus'ga rurag̃wama javo, ei Jesus'ga. A'ero po ti yvyakotyve'g̃a gwyripeve'g̃a jehe'oi ovy'are'yma nehẽ. A'ero po ti g̃a ji repiagi ji rura'javame yvag̃atig̃a pyteri pe yvyakotyva'ero yvagipeva'ero nehẽ, ei Jesus'ga. Jipopoakara po ti g̃a gwepia nehẽ no. Nhirendy'jandy'java po ti g̃a hepiagi nehẽ no jikatuhetea, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","—Nanime trombeta ipyhava nehẽ, ei Jesus'ga. Hahyahi ipyambua nehẽ. Trombeta renduvame po ti jipyrive'g̃a hog̃ahoi yvyakotyve'g̃a gwyri pe nhaporemo okovo nhinhi'ig̃a rupi nehẽ. Pevopevo po ti g̃a nhiremimo'ẽhara'g̃a monhimono'ono'og̃i g̃a nderua ji pyri nehẽ, ei Jesus'ga. Nahã po ti g̃a g̃a nderuri kwara ipora hugwi kwara ihoa hugwi no tyapyra hugwi no nhimbya hugwi nehẽ no, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","—Kiro po ti ji pe mbo'ei ojo'java'ea pyvõ, ei Jesus'ga. Hepiagame figo'yva pe pekwaha. A'ereki henhunhame huangyra pe ei: “Kwaria g̃werĩ kiro,” pe'e pe. ");
INSERT INTO pahNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Na jitehe hepiapavame tiruahũva'ea pejive po ti pe ikwahavi nehẽ kiro mbapava koty javo, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Imombe'ukatuavo ji ei pe me: Ag̃wamove'g̃a ndekojirame po ti akoja ihopavi japiavo nehẽ, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Opa po ti yvaga yvya pavẽi nehẽ. Nhinhi'ig̃a po ti ndopavag̃wami opopoakapige'yma okovo a'itituhẽva'ero avuirama nehẽ, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","—“Maname po ti nde rura'javi nehẽ?” pe'e pe ji ve, ei Jesus'ga. A'ea yvyakotyve'g̃a ndokwahavi, ei Jesus'ga. Tupana'gapyrive'g̃a yvagipeve'g̃a ndokwahavi no. Ji vehevi Tupana'ga ra'yramo ndakwahavi no, ei Jesus'ga. Jiruva'ga jate okwaha jirura'jahava nehẽ, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","—Noéva'ea nhinhag̃a renondehava yhara ruvihavuhua pype ojo'ja jirura'java renondehava pavẽi, ei Jesus'ga yvyakotyva'ero yvagipeva'ero no. ");
INSERT INTO pahNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Ymyahũ Noéva'ea nhinhag̃a renonde yhararuvihavuhua pype ahegwyripeva'ea i'ui'ui jipi gworygworyvamo hako. Ahegwyripeva'ea rembirekoro akwaimba'eva'ea jipi no. Ojipeva'ea kunhava'ea mohembirekoi no. Nahã ahegwyripeva'ea rekoi okovo Noéva'ea avame yharuhua pype hako. ");
INSERT INTO pahNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","A'ea rupi ahegwyripeva'ea ndokwahavi yhyarehanhuhũa rurag̃wama – kiroki ahegwyripeva'ea ndo'avi yharuhua pype. Ahegwyripeva'ea mbotypyvypava yhya nhatymbavi hako. Na jitehe po ti yvyakotyve'g̃a ndokwahavi jirurag̃wama nehẽ, ei Jesus'ga yvyakotyva'ero yvagipeva'ero no. ");
INSERT INTO pahNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","—A'ero po ti akwaimbae'g̃a mokonha'g̃a oko ko pe nehẽ. Kiro po ti ojipe'ga rerohohava nehẽ. Kiro po ti ojipe'ga rejahava nehẽ, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","—Kunha'g̃a mokonha'g̃a po ti ombo'i imbo'ihava pyvõ. Kiro po ti ojipehẽa rerohohava nehẽ. Kiro po ti ojipehẽa rejahava nehẽ, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","—Penhimboko'i ti jipi ite'varuhuva'ea hugwi pejikokatuavo ji mboha'uva. A'ereki pe ndapekwahavi maranime po ti nhandepojykaharete'ga rura'javi nehẽ javo ji ve, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Onga jara'ga ndokwahavi iporomive'ga rura g̃wonga pe, ei Jesus'ga. Po ga okwaha, gwepia katu po ga g̃wonga a'ea rupi hamo iporomive'ga mongiukare'yma hamo, ei Jesus'ga. A'ea pe pekwaha, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","—Nurã ji ei pe me: Penhimboko'i ti a'ero penhimboavujikwea jirura'java pota ji mbuhua, ei Jesus'ga. Pe ji mboha'uve'ymame kiro po ti ji ruri yvyakotyva'ero yvagipeva'ero no, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","—Kiroki ga ombojikoguka opojykahara'ga ojihe gweaporog̃itakaturo – marã ga rekokatui? ei Jesus'ga g̃a pe. Kiro po ti ji garekokatua mombe'ukatui pe me ojo'java'ea mombe'gwovo. Gwepia katu ga opojykahara'ga mbatera, ei Jesus'ga. Ga pe gapojykahara'ga ei a'ero ohorame: “Nde po ti jipyrive'g̃a ndepiakatuharamo. Ema'ẽ ti nhimbatera g̃a pe g̃andetakwera ja jipi to'u ti g̃a javo.” Nahã ga ei ojipyrive'ga pe ogwovo. ");
INSERT INTO pahNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","—A'ero gapyrive'ga jara'g̃a ndepiakatui imondovo g̃a pe g̃a nderekovo g̃andepiakatuharamo ga horame. Aerẽ gapojykahara'ga jivyri g̃a ndepiaga. Ga e'i: “G̃a ndepia katu reki ga imondovo g̃a pe,” ei ga. —Pyry hete g̃andepiakatuhara'ga pe a'ero, ei Jesus'ga imombe'gwovo. ");
INSERT INTO pahNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Imombe'ukatuavo ji ei pe me: Aerẽ po ti gapojykahara'ga ei ga pe nehẽ: “Ehepia katu pa ti a'ero nhironga jigwyra reheve nhimbatera reheve no.” Nahã po ti ga ei nehẽ toko ti ga herekohavamo ji ve javo, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","—Po g̃andepiakatuhara'ga rekote'varuhui, a'ero po ga ei oyvyteri pe opojykahara'ga rure'ymame: “Mbaigwe po ti jipojykahara'ga jivyri nehẽ,” e po ga. ");
INSERT INTO pahNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","A'ero po ga ndohepiakatui opojykahara'gapyrive'g̃a, ei Jesus'ga. Onupã po ga g̃a g̃a poravykyrame. O'u hete po ga gambatera gweagwyryvamo no heagwyryve'g̃a pavẽi, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Oyvyteri pe ga ei upa nduri po ti jipojykahara'ga kiro nehẽ javo. —A'ea rupi po ti gapojykahara'ga ruri ovahema nehẽ, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Gapojykahara'ga ga rovaja'rogukari nehẽ. A'ereki ga ndokoi opojykahara'ga nhi'ig̃a rupi. Nahã po ti gapojykahara'ga ga mongoukari ahemoandyandyiva'ea pyri nehẽ, ei Jesus'ga. Hahyva'ea ruvihava pype po ti ga jehe'oi ojihe a'ero onhimonha'ngavo hahyrame ojive nehẽ, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","—Ji rura'jahava koty marã po ti hekoi nehẽ yvyakotyve'g̃a pe g̃a erame Tupana'ga nhanderuvihavuhuhetero oko javo? ei Jesus'ga g̃a pe. A'ea rehe po ti ji pe mbo'ei ikwahavuka pe me imombe'gwovo a'ea'java'ea, ei Jesus'ga. Kunhangwera'g̃a ivojave'g̃a ipyhygi lamparinas dezve'g̃a, ei Jesus'ga. A'ea g̃a herohoi ga rovatiamo – kiroki ga hembireko a'ea rupi. ");
INSERT INTO pahNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","—Jara'g̃a cincove'g̃a okwaha hete gweaporog̃itakaturo kunhangwera'g̃a. Jara'g̃a cincove'g̃a ndokwahahetei gweaporog̃itate'varuhuavo kunhangwera'g̃a, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Ikwahave'ỹve'g̃a ndogwerohoi querosene'java'ea herohorame lamparinas. ");
INSERT INTO pahNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Ikwahave'g̃a ki a'e te gweroho querosene'java'ea nhumbi'a pype herohorame lamparinas. ");
INSERT INTO pahNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Mbaigwe ga ruri – kiroki ga hembireko. A'ero kunhangwera'g̃a kiri gwopehyiro, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","—Ypyhaji katu g̃a henduvi g̃anhi'g̃a. “Poro ga ruri. Peho ti ga rovatiamo,” ei g̃a. ");
INSERT INTO pahNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","—A'ea henduvame kunhangwera'g̃a vyri ikytiavo imondyhava pavio japokatuavo tombokojahu katu ti javo, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","A'ero ikwahave'ỹve'g̃a ei ikwahave'g̃a pe: “Pembuhu ore ve querosene'java'ea. A'ereki ogwe oreapoa lamparinas,” ei g̃a. ");
INSERT INTO pahNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","A'ero ikwahave'g̃a ei: “Noromondoi po ti ore nehẽ. A'ereki oreapoa querosene'java'ea ndohygi nhandeapoa rehe nhaporemo lamparinas rehe nhaporemo. Peho ti ima'ẽhara'g̃a pyri ipyhyga pejive,” ei g̃a ikwahave'ỹve'g̃a pe, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","—A'ero ikwahave'ỹve'g̃a hoi toropyhy ti javo. G̃andakykweri ga ruri reki – kiroki ga hembireko. Onhimboavujikweve'g̃a hoi ga rupi toryvi pe okiavo onga pype. G̃wovapytỹ ga a'ero, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","—Aerẽ ikwahave'ỹve'g̃a nduri javo: “Ehovapytymba'vo ti ore ve. Toroki,” ei g̃a. ");
INSERT INTO pahNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","—A'ero ga ei g̃a pe: “Nahovapytymba'vogi po ti ji pe me nehẽ. Imombe'ukatuavo ji ei pe me: Peko pe ambotehero ji hugwi pejikoangave'yma jireheva'ero,” ei ga g̃a pe, ei Jesus'ga imombe'gwovo. ");
INSERT INTO pahNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","—Nahã po ti hekoi nehẽ. Nurã nane'ymi ti pepota jirura'java penhimomiranama ji mbuhua, ei Jesus'ga. A'ereki pe ndapekwahavi maranime po ti nhandepojykaharete'ga rura'javi nehẽ javo, ei Jesus'ga yvyakotyva'ero yvagipeva'ero no. ");
INSERT INTO pahNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","—Jirura'jahava koty marã po ti hekoi yvyakotyve'g̃a pe g̃a erame Tupana'ga nhanderuvihavuhuhetero oko javo? A'ea rehe po ti ji pe mbo'ei ikwahavuka pe me imombe'gwovo a'ea'java'ea, ei Jesus'ga. Akwaimbae'ga hoi paivouhu ojipe'g̃a gwyri pe. Ohoa renonde ga ojipyrive'g̃a mbuhurukari ojipyri. Ga omondomondo g̃a pe ombatera oitambere'ia no tombohe'yjuhu ti g̃a ji ve javo, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","—A'ero cinco itambere'ia hehanhuhũva'ea ga imondoi ojipe'ga pe g̃a hohe ga ombohe'yi kwaha javo. Dois itambere'ia hehanhuhũva'ea ga imondoi ojipe'ga pe ga gwyre'i ga ombohe'yi kwaha javo. Ojipeji itambere'ia hehanhuhũva'ea ga imondoi ojipe'ga pe g̃a gwyre'i ga ombohe'yi kwaha javo. A'ero ga ei: “Pepyhypyhy ti mbatera nhiitambere'ia pyvõ. Aerẽ ti pema'ema'ẽ mbatera itambere'ia ipyhyga koji'iva'ea,” ei ga g̃a pe. “Nahanahã ti peporavyky nhiitambere'ia pyvõ koji'iva'ea imono'ono'og̃a aerẽ imbuhua ji ve,” ei ga g̃a pe, ei Jesus'ga. —Kiro ga hoi g̃a hugwi a'ero ogwovo paivouhu hete ojipe'g̃a gwyri pe, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","—A'ero gapyrive'ga – kiroki ga opyhy cinco itambere'ia ga hugwi – gaha nambegwei'i'i ogwovo ipyhypyhyga mbatera ipyvõ. Aerẽ ga ima'ema'ẽi mbatera ipyhypyhyga koji'iva'ea itambere'ia. Ima'ema'embavirẽ ga gwereko dez itambere'ia hehanhuhũva'ea gwuvihava'ga pe, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","—Na jitehe ojipe'ga – kiroki ga opyhy dois itambere'ia gwuvihava'ga hugwi. Ga oho ipyhypyhyga mbatera ipyvõ. Aerẽ ga ima'ema'ẽi mbatera ipyhypyhyga koji'iva'ea itambere'ia. Ima'ema'embavirẽ ga gwereko quatro itambere'ia hehanhuhũva'ea gwuvihava'ga pe, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","—Ojipe'ga ki a'e te – kiroki ga opyhy ojipeji itambere'ia gwuvihava'ga apoa – gaha gwyvykoi itambere'ia inog̃a yvykwara pype imima tareko katu ti javo, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","—Aerẽ mbaigwehu g̃anduvihava'ga rura'java paivohua hugwi ua, ei Jesus'ga. Ovahemame ogwyri pe kiro ga ojipyrive'g̃a mbuhurukari ojipyri – kiroki g̃a pe ga omondo oitambere'ia tombohe'yjuhu ti g̃a ji ve javo. Ga g̃a mbuhuruka ojipyri. A'ereki ga e'i oyvyteri pe: “Maramomi kiro nhiitambere'ia g̃a imbohe'yjuhurame? Koji'i po g̃a ipyhygi ji ve jirakykweri,” ei ga oyvyteri pe, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","—A'ero ga ruri ga pyri – kiroki ga opyhy cinco itambere'ia gwuvihava'ga hugwi, ei Jesus'ga. Ga gweru gwuvihava'ga pe dez itambere'ia. “Jiruvihavamo erembuhu nde ji ve cinco itambere'ia ikwehe'i. Ehepia! Ikwepygame ji ipyhygi dez,” ei ga ga pe, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","—A'ero garuvihava'ga ei ga pe: “Ereporavyky katu nde! Ndepyry nde eporavykykatuavo ji ve. Mbohapyrete'i nde erembohe'yjuhu ji ve. Nurã po ti ji imondoi he'yiheteva'ea nde ve nehẽ embohe'yjuhu ti ji ve javo. Ejo ti ejoryjoryvamo ji pavẽi,” ei ga ga pe, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","—Aerẽ ojipe'ga ruri – kiroki ga opyhy dois itambere'ia gwuvihava'ga hugwi, ei Jesus'ga. “Jiruvihavamo erembuhu nde ji ve dois itambere'ia ikwehe'i. Ehepia! Ikwepygame ji ipyhygi quatro,” ei ga ga pe, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","—A'ero garuvihava'ga ei ga pe: “Ereporavyky katu nde! Ndepyry nde eporavykykatuavo ji ve. Mbohapyrete'i nde erembohe'yjuhu ji ve. Nurã po ti ji imondoi he'yiheteva'ea nde ve nehẽ embohe'yjuhu ti ji ve javo. Ejo ti ejoryjoryvamo ji pavẽi,” ei ga ga pe, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","—A'ero ojipe'ga ruri – kiroki ga opyhy ojipeji itambere'ia gwuvihava'ga hugwi, ei Jesus'ga. “Jiruvihavamo ko nde,” ei ga. “Akwaha ji ndereaporog̃itate'varuhua. Nde ndereporavykyi. Emo nde erepyhy ojipe'g̃a hugwi ejive. Nde neretymi. Emo nde eremondoro ojipe'g̃a nemitymipyra ejive,” ei ga ga pe, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","“Akyhyji ji nde hugwi. A'ero ji hoi imima neitambere'ia yvy pe – akoja nde erembuhu ji ve ikwehe'i. Ehepia neitambere'ia – akoja jitehe!” ei ga ga pe, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","—A'ero garuvihava'ga ei ga pe: “Ereko te'varuhu nde evevugwero. Nde tuhẽ ere'ere'e ji ve: ‘Erepyhy nde ejive eporavykye'yma. Nde neretymi. Emo nde eremondoro ojipe'g̃a nemitymipyra ejive.’ Nahã nde ei ji ve. Nde ji kwahavipe ji imondorame nhiitambere'ia nde ve embohe'yi ti javo, ei ga. ");
INSERT INTO pahNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Nurã po nde eremondo nhiitambere'ia ikwepykara'g̃a pe banco pype hamo. A'ero imbuhu'rag̃irẽ ojipe'g̃a pe po g̃a ombuhu koji'iva'ea nde ve hamo, ei ga ga pe. Nahã po nde herekoi nhiitambere'ia jirakykweri hamo. A'ero ji rura'javame po ji ipyhyga'javi nde hugwi nhiitambere'ia irũa reheve hamo,” ei ga ojipyrive'ga pe, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","—Ojipe'g̃a pe ga ei: “Pepyhy ti nhiitambere'ia ga hugwi imondovo akoja'ga pe – kiroki ga ombohe'yi nhiitambere'ia nahã herekovo dez itambere'ia,” ei garuvihava'ga, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","—A'ero ji ei pe me, ei Jesus'ga. Kiroki ga gwereko a'ea pyvõ oporavyky pota ji ve – ga pe po ti ji koji'iva'ea imondoi toporavyky ti ga a'ea pyvõ javo. Gwereko ranuhũ po ti ga nehẽ, ei Jesus'ga. Kiroki ga ndogwerekoi gwerevi oporavykypotare'yma – aru po ti ji ga hugwi a'ero toporavykya'javyme ti ga ji ve javo, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","—Nurã g̃anduvihava'ga ei javo ojipyrive'g̃a pe: “Akoja'ga – kiroki ga nombohe'yi nhiitambere'ia – gaha ti toporavykya'javyme ji ve ipotare'yma g̃waramo. Pemombo ti ga ypytunahiva pype. Pevo po ti ga jehe'oi ojihe onhimonha'ngavo hahyrame ojive a'ero nehẽ,” ei ga, ei Jesus'ga ojo'java'ea imombe'gwovo. ");
INSERT INTO pahNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","—Aerẽ yvyakotyva'ero yvagipeva'ero po ti ji rura'javi yvyakotyve'g̃a nduvihavuhuhetero nehẽ, ei Jesus'ga. Nhirendy'javuhua pyteri pe jikatukatuva'ea pyteri pe po ti ji rura'javi nehẽ, ei Jesus'ga. Pyryve'g̃a pavẽi nhaporemo po ti ji rura'javi nehẽ Tupana'gapyrive'g̃a pavẽi yvagipeve'g̃a pavẽi. —A'ea rupi po ti ji reni jiapykakatua rehe javo yvyakotyve'g̃a pe nehẽ, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Amono'ono'og̃uka po ti ji yvyakotyve'g̃a gwyripeve'g̃a jirovai pyteri pe nehẽ. Ovelhas repiakatuhara'ga ope'a ovelhas cabritos hugwi jipi. Na jitehe po ti ji yvyakotyve'g̃a pe'ai nehẽ, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Tupana'ga nhi'ig̃arupive'g̃a pe po ti ji ei nehẽ: Pejo ti ji pyri kokoty jijohukoty rũi, a'e po ti ji g̃a pe nehẽ, ei Jesus'ga. Ojipe'g̃a pe po ti ji ei nehẽ: Peho ti kikoty jijohukoty, a'e po ti ji nehẽ, ei Jesus'ga. Nahã po ti ji Tupana'ga nhi'ig̃arupive'g̃a pe'ai ojipe'g̃a hugwi avo yvya koty nehẽ, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","—Tupana'ga nhi'ig̃arupive'g̃a pe po ti ji ei g̃anduvihavuhuhetero nehẽ jijohukotyrũive'g̃a pe nehẽ: Tupana'ga jiruva'ga omombyry pe me. Nurã ti pejo pejikovo g̃anduvihavamo Tupana'ga pyri ga rekorame g̃anduvihavuhuhetero, ei Jesus'ga. Ymyahũ yvya aporame Tupana'ga omboavujikwe pe me toko ti g̃a g̃anduvihavamo javo. —Nahã ji ei pe me. ");
INSERT INTO pahNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","A'ereki ty'ara ji jukarame pe pembuhu mbatera ji ve, a'e po ti ji Tupana'ga nhi'ig̃arupive'g̃a pe nehẽ, ei Jesus'ga. Ji ygweirame pe pembuhu yhya ji ve, a'e po ti ji g̃a pe nehẽ, ei Jesus'ga. Ji hajiheva'ea pe me. Emo pe pe'e ji ve: “Eapy ti ore pyri i'gwovo. Eki ti oreronga pype.” A'ea pe pe'e ji rerekokatuavo, a'e po ti ji g̃a pe nehẽ, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ji pire'ymame pe pemondo jipira ji ve, a'e po ti ji g̃a pe nehẽ. Ji tetirũarame pe pejo ji pyri ji pokoga. Ji imombe'urame Tupana'ga nhi'ig̃a g̃a ji mongi cadeia pype. Pevo pe nduri ji pyri ji pokoga, a'e po ti ji Tupana'ga nhi'ig̃arupive'g̃a pe nehẽ, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","—A'ero po ti ganhi'ig̃arupive'g̃a ei ji ve nehẽ opojykaharetea pe nehẽ: “Maranime ore nde repiagi ty'ara nde jukarame?” e po ti g̃a nehẽ. “Ndorohepiagi tuhẽ reki ore! Nurã ore noromondoi mbatera nde ve,” e po ti g̃a ji ve nehẽ, ei Jesus'ga. “Maranime ore nde repiagi nde ygweirame? Ndorohepiagi tuhẽ reki ore! Nurã ore noromondoi yhya nde ve,” e po ti g̃a ji ve nehẽ, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","“Maranime ore nde repiagi nde rekorame hajiheva'ero ore ve? Ndorohepiagi tuhẽ reki ore! Nurã ore ndoro'ei nde ve a'ero: Ejo ti i'gwovo ore pyri ekiavo oreronga pype. Na rũi ore ei nde ve,” e po ti g̃a nehẽ. “Maranime ore nde repiagi nde pire'ymame? Ndorohepiagi tuhẽ reki ore! Nurã ore noromondoi ndepira nde ve,” e po ti g̃a ji ve nehẽ, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","“Maranime ore nde repiagi nde tetirũarame? Ndorohepiagi tuhẽ reki ore nde tetirũarame. Nurã ore ndoropokogi nde,” e po ti g̃a nehẽ. “Maranime ore nde repiagi nde rekorame cadeia pype? Ndorohepiagi ore nde rename cadeia pype. Nurã ore ndoropokogi nde,” e po ti g̃a ji ve nehẽ, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","—A'ero po ti ji ei g̃a pe jirekorame g̃anduvihavuhuhetero nehẽ: Imombe'ukatuavo ji ei pe me: Pe nhiirũ'ga pokokaturame jihi tuhẽ pe ji poko katu a'ero. Po okoteheva'ero ga rekoi novĩa nhiirũ'ga jireheve'ga. Pe ga pokokaturame jihi tuhẽ pe ji poko katu a'ero, a'e po ti ji Tupana'ga nhi'ig̃arupive'g̃a pe nehẽ, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","—Ojipe'g̃a pe jijohukotyve'g̃a pe po ti ji ei nehẽ: Pejipe'a ti pejigwovo ji hugwi. Pendekote'varuhua ko pehoag̃wama tata pype. Nurã ti peho hahyva'ea ruvihava pype tata pype – kia Tupana'ga oapo toho ti Diabo'ga gapyriva'ea pavẽi ipype nehẽ javo, a'e po ti ji nehẽ, ei Jesus'ga. Pevo tata pype po ti hahy avuirama pe me nehẽ, a'e po ti ji jijohukotyve'g̃a pe nehẽ, ei Jesus'ga. —Nahã ji ei pe me. ");
INSERT INTO pahNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","A'ereki ty'ara ji jukarame pe napembuhuri mbatera ji ve, a'e po ti ji g̃a pe nehẽ, ei Jesus'ga. Ji ygweirame pe napembuhuri yhya ji ve, a'e po ti ji g̃a pe nehẽ, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ji hajiheva'ea pe me. Ndape'ei pe ji ve: “Eapy ti ore pyri i'gwovo. Eki ti oreronga pype.” A'ea rũi pe'e pe ji rerekokatue'yma, a'e po ti ji g̃a pe nehẽ, ei Jesus'ga. Ji pire'ymame pe napemondoi jipira ji ve, a'e po ti ji g̃a pe nehẽ. Ji tetirũarame pe ndapejori ji pyri ji pokoge'yma. Pe ndajipokogi ji rekorame cadeia pype, a'e po ti ji g̃a pe nehẽ, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","—A'ero po ti g̃a ei ji ve nehẽ opojykaharetea pe nehẽ: “Maranime ore nde repiagi ty'ara nde jukarame?” e po ti g̃a nehẽ. “Ndorohepiagi tuhẽ reki ore. Maranime ore nde repiagi nde ygweirame? Maranime ore nde repiagi nde rekorame hajiheva'ero ore ve? Ndorohepiagi tuhẽ reki ore,” e po ti g̃a ji ve nehẽ, ei Jesus'ga. “Maranime ore nde repiagi nde pire'ymame? Maranime ore nde repiagi nde tetirũarame?” e po ti g̃a ji ve nehẽ, ei Jesus'ga. “Maranime ore nde repiagi nde rekorame cadeia pype? Nahanahã nde rekorame ore ndorohepiagi tuhẽ reki. Nurã ore ndoropokogi nde,” e po ti g̃a ji ve nehẽ, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","—A'ero po ti ji ei g̃a pe nehẽ: Imombe'ukatuavo ji ei pe me: Pe nhiirũ'ga pokokatue'ymame jihi tuhẽ pe ndajipokokatui a'ero. Po okoteheva'ero ga rekoi novĩa nhiirũ'ga jireheve'ga. Pe ga pokokatue'ymame jihi tuhẽ pe ndajipokokatui a'ero, a'e po ti ji g̃a pe nehẽ, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","—G̃a po ti oho hahyva'ea ruvihava pype tata pype upa avuirama nehẽ, ei Jesus'ga. Tupana'ga nhi'ig̃arupive'g̃a po ti oho yvagi pe okovo avuirama Tupana'ga pyri upa nehẽ, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","A'ea mombe'upavirẽ Jesus'ga ei g̃wemimbo'ehara'g̃a pe: ");
INSERT INTO pahNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","—Mokõi po ti pe kiri nehẽ. A'ero po ti nhandere'yja'g̃a japoi toryva i'gwovo nehẽ – kiroki toryva pe nhande ei: Páscoa, ei Jesus'ga g̃a pe. A'ea rupi po ti nhikwava'ẽhava g̃a pe nehẽ. Ji pyhy ti g̃a ji mbovya yva rehe ji jukavo nehẽ, ei Jesus'ga yvyakotyva'ero yvagipeva'ero no. ");
INSERT INTO pahNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","A'ea rupi ikwava'ẽhara'g̃a nduvihava'g̃a ojatyka judeus'g̃a mbo'ehara'g̃a pavẽi xava'eve'g̃a pavẽi no. Ojatyka g̃a Caifás'ga rongauhua pype. Caifás'ga ko ikwava'ẽhara'g̃a nduvihavuhu'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Kiro g̃a eg̃a'ei ojohupe: —Marã po ti nhande Jesus'ga pyhynhimimukari ga jukauka nehẽ? ei g̃a. ");
INSERT INTO pahNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Toryva rupi rũi ti nhande ga pyhygukari nehẽ he'yjuhuve'g̃a ti tojogwayvayvaryme ga rehe onhimongyavo nehẽ, ei g̃a ojohupe. Nahã g̃a ei. A'ereki Páscoa rupi judeus'g̃a ojatyka gwe'yjuhuro tikwahava'ja ti nhaneramonhava'ea reruragwera Egito hugwi javo. ");
INSERT INTO pahNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Aerẽ Jesus'ga rekoi Simão'ga ronga pype cidade'i pe Betânia pe. Simão'ga ko ijaijauhugwera'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Garonga pe Jesus'ga i'urame kunhangwerahẽa heruri perfume nhandya hyrua pype. He'yi hete itambere'ia perfume rehe. Hyrua ko alabastrova'ea ita apopyra. Jesus'ga pyri hẽa heruri herovahema. Hẽa heka'vogi perfume Jesus'ga akag̃a rehe. A'ereki hẽa ga arõ hete. ");
INSERT INTO pahNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Hepiagame Jesus'ga remimbo'ehara'g̃a onhimonha'nga. —Maranameuhũ hẽa jigwarai perfume rehe heka'voteheavo ga'akag̃a rehe? ei g̃a. ");
INSERT INTO pahNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Omondo po hẽa ima'ẽhara'g̃a pe ramo ipyhyga itambere'ia he'yiva'ea imondovo imbatere'ỹve'g̃a pe ramo. A'ereki he'yi itambere'ia hehe, ei Jesus'ga remimbo'ehara'g̃a. ");
INSERT INTO pahNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Jesus'ga okwaha g̃a'ea. A'ero ga ei g̃a pe: —Maraname pe hẽa mbote'varuhu pota? Pepi ti. A'ereki hẽa oko katu katu ji ve heka'voga nhiakag̃a rehe, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Nane'ymi imbatere'ỹve'g̃a oko pe pyri. A'ero ipotarame nane'ymi pe imondoi g̃a pe. Ji po ti a'ea nakombegwei pe pyri nehẽ, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Heka'vogame perfume jira'oa rehe hẽa ji mboavujikweri nhitymag̃wama pe, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Imombe'ukatuavo ji ei pe me: Aerẽ po ti ojipe'g̃a imombe'ui pyryva'ea ji mombe'gwovo yvyakotyve'g̃a pe nhaporemo, ei Jesus'ga. A'ea rupi po ti g̃a hẽa mombe'ui nehẽ no tokwaha pa ti g̃a hẽaremimbuhuragwera, ei Jesus'ga g̃wemimbo'ehara'g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Kiro Judasva'ea hoi ogwovo ikwava'ẽhara'g̃a nduvihava'g̃a pyri. Judas Iscariotes ei g̃a ahe ve. Ahe ko Jesus'ga remimbo'eharava'ea dozeve'g̃a pyteripeva'ea. Kiro Judasva'ea hoi ovahema ikwava'ẽhara'g̃a nduvihava'g̃a pyri. ");
INSERT INTO pahNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","G̃a pe ahe ei: —Maramomi po ti pe imbuhuri ji ve itambere'ia nehẽ? A'ero po ti ji ga pyhyguka pe me nehẽ, ei ga g̃a pe. A'ero g̃a ei ahe ve: —Toromondo ti momi trinta nde ve itambere'ia prata apopyra, ei g̃a. —Kwa, ei ahe. Apyhyguka po ti ji Jesus'ga pe me nehẽ, ei ahe. A'ero g̃a imo'emo'ẽi itambere'ia imondovo ahe ve. ");
INSERT INTO pahNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Herogwovo ahe ea'jaa'javi oyvyteri pe gweaporog̃itaro: “Marã po ti ji Jesus'ga rerekoukari ga pyhygauka g̃a pe nehẽ?” ei ahe oyvyteri pe. ");
INSERT INTO pahNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Aerẽ kiro toryva Páscoa. A'ea rupi nanani judeus'g̃a i'ui pão ndovuriva'ea. Nurã Jesus'ga remimbo'ehara'g̃a nduri Jesus'ga pyri javo ga pe: —Mome po ti ore hoi mbatera mboavujikwea nde ve Páscoa rupi nehẽ tere'u ti javo? ei g̃a. ");
INSERT INTO pahNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","A'ero Jesus'ga ei g̃a pe: —Peho ti cidade pe pejigwovo akoja'ga pyri. Pe'ji ti ga pe: “Nhanembo'ehara'ga ei nde ve: ‘Kiro po ti nhimanohava nehẽ. A'u po ti ji mbatera Páscoa rupi neronga pype nhiremimbo'ehara'g̃a pavẽi nehẽ.’ Nahã nhanembo'ehara'ga ei nde ve.” A'ea ti pe'ji akoja'ga pe, ei Jesus'ga g̃wemimbo'ehara'g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","—Kwa, ei g̃a. Ogwovo g̃a hoi japovo mbatera imboavujikwea Páscoa rupi okovo Jesus'ga nhi'ig̃a rupi. ");
INSERT INTO pahNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Aerẽ Jesus'ga ruri ovahema. Kwara horẽ Jesus'ga apygi mesa pyri g̃wemimbo'ehara'g̃a pavẽi dozeve'g̃a pavẽi. ");
INSERT INTO pahNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","G̃a i'urame Jesus'ga ei g̃a pe: —Imombe'ukatuavo ji ei pe me: Pepyteripeve'ga po ti ji pyhyguka jijukahara'g̃a pe nehẽ, ei ga. ");
INSERT INTO pahNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ndovy'arihu g̃a a'ero. G̃a nag̃anani g̃a ei ga pe: —Ji rũi re po? ei g̃a Jesus'ga pe ga renoina jipojykaharetero javo ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","A'ero ga ei g̃a pe: —Kiroki ga omonde pão tyhya pype i'gwovo ji pavẽi – gaha po ti ji pyhyguka jijukahara'g̃a pe nehẽ, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Amano tuhẽ po ti ji nehẽ. Nahã Tupana'ga rembikwatijarukara ei ji mombe'gwovo, ei Jesus'ga. Ga pe – kiroki ga ji pyhyguka ji mondovouka jijukahara'g̃a pe – ga pe po ti tiruahũ hete nehẽ. Po gayhẽa nombo'ari ga hamo, a'ero po koji'i pyry ga pe hamo, ei Jesus'ga yvyakotyva'ero yvagipeva'ero no. ");
INSERT INTO pahNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Judasva'ea ko aerẽ Jesus'ga pyhyguka gajukahara'g̃a pe. Kiro ahe ei: —Ji rũi re po? ei ahe Jesus'ga pe ombo'ehara'ga pe. A'ero Jesus'ga ei ahe ve: —Ndehe ko ere poha, ei ga Judasva'ea pe. ");
INSERT INTO pahNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","G̃a i'urame Jesus'ga ipyhygi pão. Kiro ga nhi'ig̃i Tupana'ga pe hehe ndepyry hete nde imbuhua ore ve javo. Onhi'ig̃irẽ ga haygwe'rogwe'rogi pão imondomondovo g̃wemimbo'ehara'g̃a pe. —Pepyhy ti i'gwovo pão. A'ea ko jira'oa, ei Jesus'ga g̃a pe. A'ea ga ei g̃a pe aere'ĩ po ti hajiheve'g̃a jigwarai jira'oa rehe ji jukavo nehẽ javo. Ga hugwi g̃a ipyhygi pão i'gwovo. ");
INSERT INTO pahNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","G̃a i'urame ga ipyhygi copo. Oko vinho ipype. Hehe ga nhi'ig̃i Tupana'ga pe ndepyry hete nde imbuhua ore ve javo. A'ero ga imondoi vinho g̃a pe. —Pe napenani ti pe'u, ei ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","A'ereki a'ea ko jirekoa, ei Jesus'ga. Aheka'voguka po ti ji jirekoa g̃a pe jijijukauka nehẽ. Nahã po ti ji manoi yvyakotyve'g̃a ndepyga. A'ereki Tupana'ga e'i ipyahuva'ea mombe'gwovo: “Garekoa reka'vogame po ti ji imombori g̃andekote'varuhua g̃a hugwi,” ei ga. Nurã jirekoa reka'voga g̃waramo a'iti hete tuhẽ po ti Tupana'ga imombori he'yjuhuheteve'g̃a ndekote'varuhua g̃a hugwi nehẽ g̃wembi'ea rupi nehẽ, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","—A'e ji pe me: Kiro po ti ji nda'apoa'javukari nanongara toryva vinho gwovo pe nderekovo nehẽ, ei Jesus'ga. Aerẽ po ti nhanderuvihavuhuhetero Tupana'ga japoukari ji ve toryva g̃wonga pe yvagi pe nehẽ. A'ea rupi po ti ji japoi toryva a'ero hajiheva'ea ipyahuva'ea nehẽ jiroryvamo pe pavẽi nehẽ, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Onhimby'yirame g̃a hoi onga hugwi ogwovo oliveiras ndyvi pe monte das Oliveiras pe. ");
INSERT INTO pahNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","A'ero Jesus'ga ei g̃a pe: —Pe nhaporemo po ti pe pohiri ji hugwi penhana kiro ypytunimo g̃a ji pyhyga g̃waramo. A'ereki nahã Tupana'ga imombe'ui ikwatijarukarame hako. Garembikwatijarukara e'i: “‘Ajukauka po ti ji ovelhas repiakatuhara'ga nehẽ,’ ei Tupana'ga. ‘Onhig̃waheg̃wahẽ ovelhas hepiakatuhara'ga renymbava nehẽ,’ ei Tupana'ga,” e'i ikwatijaripyra, ei Jesus'ga. Ji ve Tupana'ga ei ovelhas repiakatuhara'ga. Pe me ga ei ovelhas, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","—Tupana'ga ji mbogwerava'javame ji na'ẽ po ti aho Galiléiapeve'g̃a gwyri pe pe nenonde nehẽ, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","A'ero Pedro'ga ei Jesus'ga pe: —Jara'g̃a po ti opohipavipe nde hugwi nehẽ. Jihi po ti ndapohirag̃wami nde hugwi nehẽ, ei ga. ");
INSERT INTO pahNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","A'ero Jesus'ga ei Pedro'ga pe: —Imombe'ukatuavo ji ei nde ve: Kiro ypytunimo po ti nde ei ji ve nehẽ: “Ji ndakwahavi Jesus'ga.” Três po ti nde ea'jaa'javi a'ea ji ve inamutig̃a nhi'ig̃a renonde nehẽ, ei Jesus'ga ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","—Nda'ei tuhẽ po ti ji nanongara nehẽ, ei Pedro'ga Jesus'ga pe. Po ti g̃a ji juka vehevi nde reheve, a'ero po ti ji nda'ei nanongara nehẽ, ei Pedro'ga Jesus'ga pe. A'ea jitehe Jesus'ga remimbo'ehara'g̃a epavi Jesus'ga pe no. ");
INSERT INTO pahNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","A'ero Jesus'ga g̃a nderovahemi Getsêmani pe. —Peapy ti avo, ei Jesus'ga g̃wemimbo'ehara'g̃a pe. Hehemo'i po ti ji hoi nhinhi'ig̃a Tupana'ga pe, ei ga. ");
INSERT INTO pahNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Hehemo'i ga hoi a'ero Pedro'ga rerogwovo ojupi mokonha'g̃a ndeheve Zebedeu'ga ra'yra'g̃a ndeheve. Ndovy'ahetei Jesus'ga opy'a mbojuavo. ");
INSERT INTO pahNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","A'ero ga ei g̃a pe: —Jivy'are'yma ji juka pota. Pepyta ti avo. Tapekiri ti ji reheve ji moiruamo, ei ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Hehemo'i ga hoi g̃a hugwi onhinog̃a ojovapyvo onhi'ĩheteavo Tupana'ga pe ji ndavy'ahetei javo. —Apĩ, ei ga gwuva'ga pe Tupana'ga pe. Nde ipotarame terembuhurukari ti hahyva'ea ji ve ji jukaukare'yma g̃a pe. Emo nhiremimbotarimova'ea rupi rũi ji tako, a'e reki nde ve. Po nde erepota nhimanoa tamano ti ji a'ero, ei Jesus'ga Tupana'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Kirẽ ga ruri g̃wemimbo'ehara'g̃a pyri trêsve'g̃a pyri g̃a ndepiaga. Oki g̃a upa. A'ero ga ei Pedro'ga pe: —Napenhimomiranami'i'i pe pejopehyja pe naerũ? Ndapekiri po pe hamo ji moirũharamo, ei Jesus'ga ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Penhi'ĩ ti Tupana'ga pe. Pe'ji ti ga pe: “Ore poko ti torokote'varuhupotaryme ti.” Nahã ti pe'ji Tupana'ga pe, ei Jesus'ga. A'ereki pe peko pota Tupana'ga nhi'ig̃a rupi novĩa. Emo pe napenhimomiranami pejikote'varuhua pe Tupana'ga pe pokoge'ymame, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Aerẽ ga hoa'javi hehemo'i onhi'ig̃a'java Tupana'ga pe. —Apĩ, ei ga gwuva'ga pe Tupana'ga pe. Po ti nde ipotari nhimanoa, a'ero po ti ji manoi nde nhi'ĩpo'ruavo nehẽ, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Kirẽ ga ruri g̃wemimbo'ehara'g̃a pyri trêsve'g̃a pyri g̃a ndepiaga. Okira'ja g̃a upa. A'ereki g̃a hopehyi hete. ");
INSERT INTO pahNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Aerẽ ga hoa'javi hehemo'i g̃a hugwi onhi'ig̃a'java Tupana'ga pe. —Apĩ, ei ga. Po ti nde ipotari nhimanoa, a'ero po ti ji manoi nde nhi'ĩpo'ruavo nehẽ, e'ia'ja ga Tupana'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Kirẽ ga ruri g̃wemimbo'ehara'g̃a pyri. Ga e'i g̃a pe: —Peki jitehe pe kiro pejipytu'uro naerũ? ei ga g̃a pe. Ji rendu ti! Kiro ihoi japiavo nhikwava'eg̃a okote'varuhuve'g̃a po pe! ei Jesus'ga yvyakotyva'ero yvagipeva'ero no. ");
INSERT INTO pahNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Pevy ti pepo'ama, ei ga. Pehepia! Kiro ga ruri – kiroki ga ji pyhyguka jijukahara'g̃a pe. He xaho tuhẽ ga rovatiamo a'ero, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Jesus'ga nhi'ig̃ame g̃a pe nanime Judasva'ea ruri ovahema Jesus'ga pyri dozeve'g̃a pyteripeva'ea Jesus'ga remimbo'eharava'ea. Judasva'ea rupi he'yive'g̃a nduri herua itakyhea'javuhuva'ea mbuahava reheve herovahema. Ikwava'ẽhara'g̃a nduvihava'g̃a xava'eve'g̃a pavẽi omondouka g̃a topyhy ti g̃a Jesus'ga javo. ");
INSERT INTO pahNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Kiro Judasva'ea Jesus'ga kwahavukari g̃a pe Jesus'ga pyhyguka g̃a pe. A'ereki ahe e'i jipe g̃a pe: —Jivahemame Jesus'ga pyri po ti ji ga beijai nehẽ. A'ero po ti pe ga kwahavi nehẽ gaha ko Jesus'ga javo. Pepyhygahy ti ga a'ero, e'i jipe Judasva'ea g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","A'ero kiro Jesus'ga pyri katu Judasva'ea vahemi. —Kiro ji ruri nde pyri, ei ahe Jesus'ga pe ombo'ehara'ga pe javo tehe ga pe. A'ero ahe Jesus'ga beijai. ");
INSERT INTO pahNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","—Kwãi, ei Jesus'ga ahe ve. Eho ti ejeaporog̃ita rupi, ei Jesus'ga Judasva'ea pe. A'ero ikwava'ẽhara'g̃a nduvihava'g̃andeheve'g̃a nduri Jesus'ga pyhyga. ");
INSERT INTO pahNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Nanime Jesus'gapavẽive'g̃a pyteripeve'ga ipyhygi oitakyhea'javuhuva'ea. A'ea ga imondoi ikwava'ẽhara'g̃a nduvihavuhu'gapyrive'ga apiavo ga nambi'oga. ");
INSERT INTO pahNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","A'ero Jesus'ga ei onhipavẽive'ga pe: —Emondoa'ja ti eapoa eku'ayviri, ei Jesus'ga. Kiroki g̃a otavuka ojipe'g̃a pe g̃a jukavo – g̃a pe po ti ojipe'g̃a otavuka g̃a jukavo, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Po ti ji ei jiruva'ga pe nehẽ ji poko javo, a'ero kotihĩ po ti ga ojipyrive'g̃a mondoukari ji pyri he'yjuhuheteve'g̃a yvagipeve'g̃a doze exércitos nehẽ koji'ive'g̃a vehevi nehẽ topoko ti g̃a Jesus'ga javo, ei Jesus'ga ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Po ti ji ei ga pe embuhu ti g̃a javo, a'ero po ti ndohoi Tupana'ga rembikwatijarukara apiavo kiro. A'ereki ymyahũ Tupana'ga e'i: “Tomano ti ga.” Ymyahũ Tupana'ga ei a'ea ji mombe'gwovo ikwatija hako, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","A'ea mombe'urẽ Jesus'ga ei ikwava'ẽhara'g̃a nduvihava'g̃andeheve'g̃a pe: —Amovahĩ po ji governo naerũ? Nurã pe heruri itakyhea'javuhuva'ea mbuahava reheve ji pyhyga naerũ? Nane'ymi ji rekoi pe pavẽi pe mbo'eavo nhandejatykahavuhua pype ikwehe'i. A'ea rupi pe ndajipyhygi, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Kirog̃we jate pe nduri tipyhy ti Jesus'ga javo. Nahã hekoi Tupana'ga nhi'ĩpo'ruavo ymyahũva'ea po'ruavo – kiroki Tupana'ga nhi'ig̃a mombe'uharava'ea rembikwatijara, ei Jesus'ga. Nanime Jesus'ga remimbo'ehara'g̃a pohipavi Jesus'ga hugwi onhana. ");
INSERT INTO pahNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Kiro Jesus'ga pyhyhara'g̃a ga rerohoi Caifás'ga rongauhu pe ikwava'ẽhara'g̃a nduvihavuhu'ga rongauhu pe. Pevo judeus'g̃a mbo'ehara'g̃a ojatyka xava'eve'g̃a pavẽi. ");
INSERT INTO pahNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pedro'ga hoi Jesus'ga reviri onhimboyha'iavo ga hugwi tajipyhygyme ti g̃a javo. Ovahẽ ga Caifás'ga rongauhua pyri okari pe. Pevo ga apygi guardas'g̃a pavẽi marã po ti g̃a Jesus'ga rerekoi nehẽ javo. ");
INSERT INTO pahNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Judeus'g̃a mog̃itaharamo ikwava'ẽhara'g̃a nduvihava'g̃a xava'eve'g̃a pavẽi jara'g̃a pavẽi no – g̃a nhaporemo ojuka pota Jesus'ga. G̃a nhaporemo gweka i'mbeve'g̃a ti'mbe ti g̃a Jesus'ga oko te'varuhu javo. G̃a'mbea rendu pota g̃a. A'ereki g̃a gwepiuka pota Jesus'ga rekote'varuhua tijuka ti ga a'ero javo. ");
INSERT INTO pahNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","He'yive'g̃a nduri g̃a pyri o'mbero novĩa. Emo g̃anhi'ig̃a ndojo'jajo'javi reki. Nurã tegwete Jesus'ga jukahava nanongara rehe. Aerẽ mbapavamo mokonha'g̃a nduri. O'mbero g̃a ei Jesus'ga nhi'ig̃a mombe'gwovo. ");
INSERT INTO pahNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","—Agwa'ga, ei g̃a Jesus'ga mombe'gwovo. Gaha e'i: “Jipopoaka ji. Nurã nonhimimiva'ea ji ve. Ipotarame po ti ji imoka'nhymbavi Tupana'ga ruhava nehẽ aerẽ japokatua'java mokõi rupi jikira rupi nehẽ.” A'ea Jesus'ga ei, e'i tehe mokonha'g̃a. ");
INSERT INTO pahNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","A'ero Caifás'ga ei Jesus'ga pe opo'ama: —Nde nerenhi'ig̃i a? Marãi nde a'ero? A'iti nde ere poha? ei ga Jesus'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Nonhi'ig̃i Jesus'ga onhi'ĩpotare'yma g̃waramo. Caifás'ga ei a'ero: —Enhimombe'u katu ti ji ve kiro Tupana'ga nenhi'ig̃a renduvame avuiramave'ga. Ma gara ndehe? Nde ko Cristo Tupana'ga remimbuhurukara? Nde ko Tupana'ga ra'yra naerũ? ei Caifás'ga Jesus'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","A'ero Jesus'ga ei ga pe: —Ndehe ko ere poha. A'e ji pe me: Aere'ĩ po ti pe ji repiagi ji apygame ipopoakaheteve'ga pyri Tupana'ga pyri gajohukoty rũi jitekovo huvihavamo nehẽ. Pe po ti ji repiagi ji rura'javame yvag̃atig̃a pyteri pe ua yvya koty nehẽ no yvyakotyva'ero yvagipeva'ero no, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","A'ero Caifás'ga opira mbotararagi anhimboahi ji javo. E'i ga: —Jesus'ga onhimongouhu Tupana'ga'java'ero. Kirupi ojipe'g̃a nemimbojara Jesus'ga rehe a'ero! A'ereki Jesus'ga tuhẽ okote'varuhua repiuka nhande ve. Pehendu pe ga ko, ei Caifás'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Marã pendeaporog̃ita? Marãi pe ga pe? ei ga g̃a pe. A'ero g̃a ei: —Oko te'varuhu tuhẽ ga. Tomano ti ga, ei g̃a. ");
INSERT INTO pahNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","A'ero g̃a nyvuni Jesus'ga rova rehe ga nupanupamo. Ojipe'g̃a ga petegi opovo. ");
INSERT INTO pahNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","—Tupana'ga okwahapavuka nde ve nde ko Cristo g̃waramo, e'i tehe g̃a Jesus'ga pe. Emombe'u katu ti ore ve a'ero. Ma'g̃a okwa nde rehe? ei g̃a Jesus'ga pe. Nahã g̃a ga rerekomemui okote'varuhuavo ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","A'ea rupi Pedro'ga apygi okari pe Caifás'ga ronga pyri. Caifás'gapyrivehẽa ruri Pedro'ga pyri. —Ndehe ko Jesus'ga pavẽiva'ea Galiléiapeve'ga pavẽiva'ea, ei hẽa Pedro'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Pedro'ga nanhimombe'ui reki. G̃andovaki nhaporemo ga ei: —Gara pe nde ei? A'ereki ji ndakwahavi, ei ga ogwovo. ");
INSERT INTO pahNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ga horame porta rupi – kiroki a'ea oho pehea pe – ojipehẽa Caifás'gapyrivehẽa Pedro'ga repiagi. Pevove'g̃a pe hẽa ei: —Agwa'ga ko Jesus'ga pavẽive'ga no Nazarépeve'ga pavẽive'ga, ei hẽa. ");
INSERT INTO pahNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","A'ero Pedro'ga ei hẽa pe: —Ji ndakwahavi akoja'ga, ei ga o'mbero. A'ea ji amombe'u katu nde ve Tupana'ga nhinhi'ig̃a renduvame, ei Pedro'ga o'mbero. ");
INSERT INTO pahNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Aere'ĩ pevove'g̃a nduri Pedro'ga pyri – kiroki g̃a o'ã pevo – javo ga pe: —Nde tuhẽ ko Jesus'ga pavẽiva'ea. A'iti a. A'ereki nenhi'ig̃a ko Galiléiapeve'g̃a nhi'ig̃a ja. Nurã ore nde kwahavi, ei g̃a Pedro'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","A'ero Pedro'ga ei: —Ji ndakwahavi tuhẽ akoja'ga, ei Pedro'ga o'mbero. A'ea ji amombe'u katu pe me Tupana'ga nhinhi'ig̃a renduvame. Po ji mbero a'ea rehe, a'ero po ti Tupana'ga tomondo hahyva'ea ji ve, ei Pedro'ga g̃a pe. Nanime inamutig̃a nhi'ig̃i. ");
INSERT INTO pahNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","A'ero Pedro'ga ikwahava'javi Jesus'ga eagwera ojive. A'ereki Jesus'ga e'i jipe ga pe: “Inamutig̃a nhi'ig̃a renonde po ti três nde ea'jaa'javi ji ve ji ndakwahavi Jesus'ga javo,” e'i jipe Jesus'ga ga pe. Jesus'ga eagwera kwahava'javame Pedro'ga hoi ogwovo. Ga ojehe'o ranuhũ. ");
INSERT INTO pahNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Ko'emame ikwava'ẽhara'g̃a nduvihava'g̃a nhomonhi'inhi'ig̃i xava'eve'g̃a pavẽi. —Marã po ti nhande ei Jesus'ga jukauka nehẽ? ei g̃a. Nahanahã po ti nhande ei imboja ga rehe nehẽ. A'ero po ti g̃a ga jukai nehẽ, ei g̃a ojohupe. ");
INSERT INTO pahNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","A'ero g̃a ga pokwarukari ga rerohouka ga mo'amuka governador'ga rovai pyteri pe Pilatos'ga rovai pyteri pe. ");
INSERT INTO pahNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Judasva'ea g̃wendu g̃a erame tomano ti Jesus'ga javo. Ahe ko opyhyguka Jesus'ga g̃a pe. Henduvame g̃anhi'ig̃a ahe ei oyvyteri pe: “Mbaria po ji ga pyhygukaruhui!” ei ahe. A'ea rehe ojapyakavo ahe rekoveveuhui a'ero herohoa'java trinta itambere'ia prata apopyra ikwava'ẽhara'g̃a nduvihava'g̃a pe xava'eve'g̃a pe no. ");
INSERT INTO pahNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","G̃a pe ahe ei: —Ako te'varuhu ji Jesus'ga pyhyguka pe me oji'i. A'ereki ga oko katu. Omano po ti ga jite'varuhua rehe nehẽ, ei ahe. Kiro g̃a ei: —Ndorokoi ore hehe. Ndehe ti eko hehe! ei g̃a Judasva'ea pe. ");
INSERT INTO pahNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","A'ero Judasva'ea imombori itambere'ia prata apopyra yvyvo g̃ajatykahavuhua pype ogwovo ojijugwa onhimbohaekovo ojurimo ojijukavo. ");
INSERT INTO pahNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ikwava'ẽhara'g̃a nduvihava'g̃a opyhy itambere'ia. A'ero g̃a ei ojohupe: —Marã po ti nhande herekoi naerũ? Timondo nhande a'ea Judas'ga pe ikwehe'i topyhyguka ti ga Jesus'ga nhande ve javo. A'ereki nhande tijuka Jesus'ga, xa'e nhande ikwehe'i. Nurã ti kiro timbojihe'aryme ti a'ea ojipea pyvõ itambere'ia pyvõ nhandere'yja'g̃a remimbuhutehea pyvõ – kia g̃a ombuhumbuhu Tupana'ga pe toapo katu ti g̃a Tupana'ga ronga nhandejatykahavuhua javo. A'ereki nanongara imbojihe'ara Moisésva'ea ndopotari ymyahũ ikwatijarame, ei g̃a ojohupe. ");
INSERT INTO pahNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","A'ero g̃a nhomonhi'inhi'ig̃i kohoa tipyhy a'ea pyvõ javo. A'ea g̃a imondoi a'ero ipyhyga kohoa hyrua apohara'ga hugwi – kiroki ga oapo tujuga hyruro. Opyhy g̃a kohoa g̃andyvyag̃wama rupiara torotỹ ti judeus'g̃arũive'g̃a pevo nehẽ javo. ");
INSERT INTO pahNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Nurã akoja pe kohoa pe judeus'g̃a ei jipi Aherekoa gwyra. ");
INSERT INTO pahNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Nahã g̃a ipyhygi kohoa. Nahã hekoi Tupana'ga nhi'ĩpo'ruavo ymyahũva'ea po'ruavo. A'ereki ymyahũ Tupana'ga nhi'ig̃a mombe'uharava'ea Jeremiasva'ea a'ea mombe'u Tupana'ga nhi'ig̃a mombe'gwovo. Ymyahũ ahe ei hako: “G̃a ipyhygi trinta itambere'ia prata apopyra. ‘Momi ga rehe itambere'ia,’ ei Israelva'ea rakykwepohara'g̃a. ");
INSERT INTO pahNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","A'ea g̃a ipyhygi imondovo ipyhyga kohoa hyrua apohara'ga hugwi – kiroki ga oapo tujuga hyruro. Nahã Tupana'ga ei ji ve nahanahã ti eko javo,” ei Jeremiasva'ea hako. ");
INSERT INTO pahNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Kiro g̃a Jesus'ga mo'amukari governador'ga rovai pyteri pe Pilatos'ga rovai pyteri pe. A'ero Pilatos'ga ei Jesus'ga pe: —Marãi nde? Ndehe ko judeus'g̃a nduvihavuhuhetero? ei ga. A'ero Jesus'ga ei ga pe: —Ndehe ko ere poha, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Ikwava'ẽhara'g̃a nduvihava'g̃a omboja Jesus'ga rehe xava'eve'g̃a pavẽi. G̃a eg̃a'erame na Jesus'ga pe ga nonhi'ig̃i g̃a pe onhi'ĩpotare'yma g̃waramo g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","A'ero Pilatos'ga ei Jesus'ga pe: —Marãi nde? Nerehenduvi nde g̃a eg̃a'erame nde ve naerũ? Nerenhi'ig̃i po ti nde imombe'ukatuavo ji ve nehẽ? Marãi nde? ei ga. ");
INSERT INTO pahNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Jesus'ga nde'i'i'i onhi'ĩpotare'yma g̃a'eagwera rehe ojive. A'ero Pilatos'ga nhimomby'ahetei ga rehe. ");
INSERT INTO pahNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Toryva rupi nanani Páscoa rupi nanani Pilatos'ga ombopiro'y cadeiapypeve'ga mohemuka – kiroki ga pe judeus'g̃a e'i. ");
INSERT INTO pahNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Cadeia pype Barrabás'ga rekoi kiro. Judeus'g̃a nhaporemo ga kwaha hete. ");
INSERT INTO pahNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Kiro he'yjuhuheteve'g̃a nduri Pilatos'ga pyri onhimongyavo. G̃a jatykarame Pilatos'ga ei g̃a pe: —Ma'g̃a po ti ji amohemuka pe me toryva rupi? Mara'ngu po Barrabás'ga pe pe javo? Ojipe'ga Jesus'ga – kiroki ga pe g̃a ei: Cristo Tupana'ga remimbuhurukara – mara'ngu po ga pe pe javo? ");
INSERT INTO pahNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","A'ea ga ei g̃a pe. A'ereki ga okwaha g̃apy'a. Ga ei oyvyteri pe: “Ikwava'ẽhara'g̃a nduvihava'g̃a xava'eve'g̃a pavẽi onhimyrõ Jesus'ga rehe. Nurã g̃a ga rerurukari ji pyri te'i ti ga ga pe javo,” ei ga oyvyteri pe. ");
INSERT INTO pahNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Juizes'g̃a apykava rehe Pilatos'ga apygame ta'e ti kiro gareaporog̃ita pe javo, kiro garembirekohẽa imondoi onhi'ig̃a ga pe javo: —Akoja'ga oko katu Jesus'ga. Terekote'varuhui ti ga pe a'ero. A'ereki ji aayvahi te'varuhu ga rehe ypytunimo. Omyi jipy'a kiro. A'ea hẽa ei imondovo onhi'ig̃a Pilatos'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ikwava'ẽhara'g̃a nduvihava'g̃a xava'eve'g̃a pavẽi ombo'e he'yive'g̃a ite'varuhua rehe. E'i g̃a: —Pe'ji ti Pilatos'ga pe tomohemuka ti ga Barrabás'ga, ei g̃a g̃a pe. Pe'ji ti ga pe tojukauka ti ga Jesus'ga. A'ea g̃a ei g̃a pe te'i ti g̃a embovyruka ti Jesus'ga yva rehe javo. Nahã g̃a nhimbopogweukari pevove'g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Kiro Pilatos'ga ei pevove'g̃a pe: —Marãve'ga po ti ji amohemuka pe me? ei ga g̃a pe. A'ero g̃a ei ga pe: —Barrabás'ga ti tohẽ. ");
INSERT INTO pahNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilatos'ga ei: —Oro ga – kiroki ga pe g̃a ei: Cristo Tupana'ga remimbuhurukara – marã po ti ji ga rerekoi naerũ Jesus'ga? G̃a nhaporemo g̃a ei: —Embovyruka ga! A'ea g̃a ei tomano ti Jesus'ga yva rehe javo. ");
INSERT INTO pahNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","A'ero Pilatos'ga ei: —Maranameuhũ naerũ? Gara garekote'varuhua naerũ? ei ga g̃a pe. Emo koji'i g̃a hapukapukajahivi. —Embovyruka ga! ei g̃a ohapukaita. ");
INSERT INTO pahNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","G̃apopoakara repiagame Pilatos'ga nde'ia'javi g̃a pe. A'ereki ga e'i oyvyteri pe: “Nambegwei po ti g̃a tavukari ga rehe nehẽ.” A'ero ga herurukari yhya ojipogweita ipyvõ g̃a hepiagame. Ojipogwei ga ndojari tuhẽ po ti ji rehe Jesus'ga manoa javo. —Oko katu ga, ei Pilatos'ga g̃a pe. Ji rũi ti ajukauka ga, ei ga ojipogweita. Po pe gamanoa pota, pehe ti pereko ga a'ero, ei Pilatos'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","A'ero g̃a epavi: —Toja ti ore rehe gamanoa a'ero nehẽ nhanderakykwepohara'g̃a ndehe nehẽ no, ei g̃a. ");
INSERT INTO pahNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","A'ero Pilatos'ga Barrabás'ga mohemukari cadeia hugwi okovo g̃anhi'ig̃a rupi. Onupanupãuka ga Jesus'ga ipira apopyra pyvõ ga mondohondohoguka. A'ero ga Jesus'ga mondoukari soldados'g̃a pe tombovyruka ti g̃a ga jukavo javo. ");
INSERT INTO pahNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","A'ero Pilatos'gapavẽive'g̃a soldados'g̃a Jesus'ga rerohoi garonga pype governador'ga ronga ruvihava pype. Soldados'g̃a nhaporemo g̃a jatykai Jesus'ga pyri. ");
INSERT INTO pahNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Gapira g̃a hekyi imongiuka ga pe tapy'ynhapig̃wag̃ahiva ipukuhuva'ea aheruvihava'ga pira'java'ea. ");
INSERT INTO pahNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","G̃a opyhy yhypoa hatiuhũva'ea. A'ea g̃a ipovãpovani japovo onhatimag̃atuva'ea akanitara inog̃a Jesus'ga akag̃a rehe ag̃a ko huvihava'g̃a akanitara javo tehe jupe. Yvyra g̃a imondoi gapo pe gajohukoty rũi ga ko huvihava javo. G̃wenypy'amo garovai pyteri pe g̃a e'i tehe Jesus'ga pe ga rerekomemuamo ga jaita. G̃a e'i: —Judeus'g̃a nduvihavuhuhetero ko nde! Ejoryjory ti! ei g̃a ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ga rehe g̃a nyvuni. Ipyhyga yvyra ga hugwi g̃a ga'akag̃a nupãi. ");
INSERT INTO pahNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Ga rerekomemuarẽ g̃a hekyi tapy'ynhapig̃wag̃ahiva ga hugwi imongiukara'java gapira tuhẽ ga pe. Kiro g̃a ga rerohoi timbovyruka ti ga yva rehe javo. ");
INSERT INTO pahNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Jesus'ga rerohorame g̃a Simão'ga rovatĩ cidadepeve'ga Cirenepeve'ga. A'ero g̃a herohoukarahai ga pe yva Jesus'ga jukahava rupiara. ");
INSERT INTO pahNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","A'ero g̃a Jesus'ga rerohoi yvytyri pe Gólgota pe ga rerogwovo i'arimo. Xa'e nhande Gólgota pe Aheapindava. ");
INSERT INTO pahNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Kiro g̃a imondoi ikotimbyra Jesus'ga pe. Ikotimbyra ko vinho tyarovahiva'ea pavẽi. Otyku ga hepiaga. A'ero ga ndo'ui. ");
INSERT INTO pahNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Kiro g̃a ga kutugi yva rehe ga mbovya hehe. Kirẽ g̃a Jesus'ga pira ma'ema'ẽi ojive. Ojohupe g̃a ei: “Manamo nhande tipojyka Jesus'ga pira?” Tikwaha javo g̃a imombomombori ita'javuhuva'ea dados'java'ea. Nahã g̃a ima'ema'ẽi gapira ojive. Nahã hekoi Tupana'ga nhi'ĩpo'ruavo ymyahũva'ea po'ruavo. A'ereki ymyahũ Tupana'ga nhi'ig̃a mombe'uharava'ea a'ea mombe'u. Imombe'gwovo ahe e'i hako: “Oma'ẽ g̃a jipira ojohupe. Ojipea rehe i'arimova'ea rehe g̃a imombori ita'java'ea a'ea ko jiapoa javo jipira pe,” ei ahe hako. ");
INSERT INTO pahNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Pevo Jesus'ga pyri soldados'g̃a apygi ga repiaga tohekyjyme ti g̃a ga yva hugwi javo. ");
INSERT INTO pahNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Yva rehe g̃a imondoi ikwatijaripyra Jesus'ga akag̃a arimo. Ikwatijaripyra ko imbojahava Jesus'ga rehe nurã ore ga jukai javo. E'i: —Agwa'ga ko Jesus'ga judeus'g̃a nduvihavuhuhete'ga. A'ea i'ei. ");
INSERT INTO pahNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","G̃a mokonhava'ea mbovyri yva rehe pevo no. G̃a ojipeva'ea mbovyri Jesus'ga pyri gajohukoty rũi. G̃a ojipeva'ea mbovyri Jesus'ga pyri gajohukoty. Ahe memei ko governo movahĩva'ea. ");
INSERT INTO pahNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Kiroki g̃a okwa Jesus'ga pyvõ – g̃a Jesus'ga rerekomemui. Ombovava g̃a oakag̃a nahã ga mbotegweteavo. Ga pe g̃a ei: ");
INSERT INTO pahNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","—Ere'e nde: “Tamonduru ti Tupana'ga ruhava aerẽ japokatua'java mokõi rupi jikira rupi nehẽ.” A'ea nde ei. Po nde rekoi Tupana'ga ra'yramo, a'ero ti ejy yva hugwi tajijukayme ti g̃a javo, ei g̃a Jesus'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Na jitehe ikwava'ẽhara'g̃a nduvihava'g̃a judeus'g̃a mbo'ehara'g̃a pavẽi xava'eve'g̃a pavẽi no. Ga rerekomemuamo g̃a ei: ");
INSERT INTO pahNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","—Jesus'ga opoko ojipe'g̃a tomanoyme ti g̃a javo, ei g̃a. Tegwete gajipokohava tomanoyme ti ga. Po ga rekoi nhanderuvihavuhuhetero tuhẽ israelitas'g̃a nduvihavuhuhetero tuhẽ, a'ero po ti ga tojy yva hugwi. A'ero po ti nhande ga reroviari nehẽ, ei g̃a Jesus'ga rerekomemuamo. ");
INSERT INTO pahNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ojiko ga Tupana'ga rehe ji ko Tupana'ga ra'yramo javo, ei g̃a. Mara'ngu po ti Tupana'ga ga pokopota tomanoyme ti ga javo? ei g̃a Jesus'ga rerekomemuamo. ");
INSERT INTO pahNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","A'ea jitehe ahe ei no governo movahĩva'ea g̃anemimbovyva'ea Jesus'ga mbotegweteavo. ");
INSERT INTO pahNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Ahaji katu kwara igwehetei reki ipyryrymame. Ypytunahimba hete yvya koty nhaporemo. Ka'aru g̃werĩ às três horas kwara imbokojahua'javi. ");
INSERT INTO pahNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Nanime Jesus'ga onhi'ig̃a mondoahyahivi Tupana'ga pe. —Eli, Eli, lemá sabactani? ei ga Tupana'ga pe. A'ea ko: “Tupana, Tupana, ajiko hete ji nde rehe. Maraname nde pohiri ji hugwi?” ");
INSERT INTO pahNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Jararamo pevove'g̃a ga renduvi novĩa. A'ero g̃a ei: —Agwa'ga onhi'ig̃a mondo Eliasva'ea pe tuhu ti ga ji pokoga javo, ei g̃a. ");
INSERT INTO pahNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Nanime g̃apyteripeve'ga nhani ipyhyga jyruhuva'ea imondeva vinho pype tajahiva'ea pype imoakymbava. Yvyra rehe ga ipimombygi jyruhuva'ea imondovo Jesus'ga pe topyte ti ga javo. ");
INSERT INTO pahNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Jara'g̃a ki a'e te e'i: —Teremondoi na'ẽ. Tihepia ti Eliasva'ea Jesus'ga mbojyvi nehẽ, ei g̃a. ");
INSERT INTO pahNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Ohapukajahiva'javame Jesus'ga pytupavamo omanomo. ");
INSERT INTO pahNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Nanime g̃ajatykahavuhua pype tapy'ynhapira hovapiahava itararagi mbytera rupi yvatea hugwi ua yvyvo. Yvya ig̃wyg̃wymi. Ita i'gwy'gwyri. ");
INSERT INTO pahNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Ahemanoa ryvya jipe'ai. G̃ahã – kiroki g̃a ojiko Tupana'ga rehe aerẽ omanomo – g̃a okwerava'ja omanoa hugwi. ");
INSERT INTO pahNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Oho g̃a gwyvya hugwi. Aerẽ Jesus'ga kwerava'javirẽ omanoa hugwi g̃a oho Jerusalém me ojipiuka he'yjuhuve'g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Soldados'g̃a nduvihava'ga gapavẽive'g̃a pavẽi – kiroki g̃a gwepia katu Jesus'ga tohekyjyme ti g̃a Jesus'ga yva hugwi javo – g̃ahã gwepia yvya g̃wyg̃wyma Jesus'ga manoa reheve. Hepiapavame g̃a kyhyjihetei. A'ero g̃a ei: —Agwava'ea ko Tupana'ga ra'yrava'ea tuhẽ! ei g̃a. ");
INSERT INTO pahNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Kunhangwera'g̃a o'ã irupe Jesus'ga hugwi okovo hepiaga he'yive'g̃a – kiroki g̃a ojikoty'a Jesus'ga pavẽi. Oho g̃a Jesus'ga rupi Galiléiapeve'g̃a gwyra hugwi ga pokoga jipi. ");
INSERT INTO pahNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Ojipehẽa ko Maria Madalenahẽa. Ojipehẽa ko Mariahẽa – kiroki hẽa Tiago'ga yhẽa José'ga yhẽa reheve jitehe. Ojipehẽa ko Zebedeu'ga rembirekohẽa. Ojipe'g̃a ami pevo no kunhangwera'g̃a. ");
INSERT INTO pahNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Kwara hog̃werĩrame imbateve'ga hoi. Ga ko José'ga cidadepeve'ga Arimatéiapeve'ga. Ga oko Jesus'ga remimbo'eharamo no. ");
INSERT INTO pahNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Kiro ga hoi Pilatos'ga ronga pe ovahema javo ga pe: —Taroho ti Jesusva'ea ra'oa, ei ga Pilatos'ga pe. —Kwa, ei Pilatos'ga. Osoldados'g̃a pe ga ei a'ero: —Togweroho ti José'ga Jesusva'ea ra'oa, ei ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","A'ero José'g̃a hoi ua Jesus'ga pyri. Yva hugwi Jesus'ga ra'oa mbojyvame José'g̃a gara'oa uvani tapy'ynhapirapyryva pyvõ linho apopyra pyvõ ndiky'aiva'ea pyvõ. ");
INSERT INTO pahNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","A'ero g̃a gara'oa rerohoi inog̃a itaruvihavuhua kwaruhua pype ipyahuva'ea pype. José'ga ombogwambogwajukaripe itaruvihavuhua japovouka ikwaruhua imohinuka. “Aerẽ ji manorame po ti g̃a jira'oa mondoi inog̃a ipype,” ei ga japoukarame. Jesus'ga ra'oa nog̃ame ipype José'g̃a itauhua moanhani imohina ikwaruhua hovapytyma. A'ero g̃a hoi jugwi ogwovo. ");
INSERT INTO pahNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Maria Madalenahẽa oapy pevo Jesus'ga ryvya rovai pyteri pe Mariahẽa pavẽi. ");
INSERT INTO pahNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","A'ea ko sexta-feira mbatera mboavujikwehava. Ko'emame ikwava'ẽhara'g̃a nduvihava'g̃a nduri Pilatos'ga pyri fariseus'g̃a pavẽi. ");
INSERT INTO pahNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Kiro g̃a ei Pilatos'ga pe gwuvihava'ga pe. —Orokwahava'ja ore akojava'ea nhi'ig̃a imoandyandyiharava'ea nhi'ig̃a, ei g̃a Jesus'ga mombe'gwovo tehe. Ahe e'i omanoe'ymame: “Mokõi jikirirẽ po ti ji kwerava'javi nhimanoa hugwi nehẽ.” A'ea ahe ei. ");
INSERT INTO pahNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Nurã ti ere esoldados'g̃a pe: “Pehepia katu ti aheryvya kiro pekira rupi no.” A'ea ti ere g̃a pe tuhuryme ti aheremimbo'ehara'g̃a ypytunimo ahera'oa mima aheryvya hugwi nehẽ. Po ti g̃a ahera'oa mimi, a'ero po ti g̃a ei gwe'yja'g̃a pe nehẽ: “Okwerava'ja Jesus'ga omanoa hugwi.” A'ea po ti g̃a ei o'mbero nehẽ, ei g̃a Pilatos'ga pe. Po ti g̃a ei a'ea ahera'oa mimirẽ, a'ero po ti g̃a koji'i ojipe'g̃a moandyandyi nehẽ. A'ereki g̃a g̃a moandyandyi jipe ikwehe o'erame: “Jesus'ga pe Tupana'ga e'i eko ti g̃anduvihavuhuhetero javo,” ei ikwava'ẽhara'g̃a nduvihava'g̃a Pilatos'ga pe fariseus'g̃a pavẽi. ");
INSERT INTO pahNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","A'ero Pilatos'ga ei g̃a pe: —Peroho ti soldados'g̃a a'ero. Pekwaha ti hepiakatuuka g̃a pe aheryvya, ei Pilatos'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","A'ero g̃a hoi imondovo inimboa tujuga apopyra pyvõ ikwaruhua rembeyvyra rehe inog̃a imbogwava itauhua rehe hovapytymbava rehe inog̃a hehe no jukwaha a'ero g̃a a'ea avykyrame javo. G̃a soldados'g̃a mo'ami ipyri no tohepia katu ti g̃a aheryvya javo. ");
INSERT INTO pahNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Judeus'g̃a poravykye'yma py'rovo sábado py'rovo iko'ẽ g̃werĩ domingo. A'ea rupi Maria Madalenahẽa ruri Mariahẽa pavẽi tihepia ti Jesusva'ea ryvya javo. ");
INSERT INTO pahNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Kotihĩ yvya ig̃wyg̃wyhetei. A'ereki Tupana'gapyrive'ga ojy yvaga hugwi ovahema yvya koty Jesus'ga ryvya pyri. Itauhua ga imoanhani ikwaruhua hugwi oapyga hehe. ");
INSERT INTO pahNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ga hendy'jandy'ja hete overava ja. Ga'apoa tapy'ynhapira itig̃uhũ hete tuhẽ! ");
INSERT INTO pahNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Soldados'g̃a hyhyihetei okyhyjiavo g̃waramo ga hugwi. Omanove'g̃a ja g̃a ndekoi a'ero omynha'jave'yma omanoteheavo. ");
INSERT INTO pahNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Tupana'gapyrive'ga ei kunhangwera'g̃a pe: —Pehe ti tapekyhyji. Peheka pe Jesus'ga g̃anemimbovyve'ga, ei ga. ");
INSERT INTO pahNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Nduvi Jesus'ga avo onongavagwera pype okwerava g̃waramo! Ymya ga ei pe me: “Nhimanorẽ po ti ji kwerava'javi nehẽ,” ei ga. Na tuhẽ. Ovy ga okwerava'java. Pejo ti hepiaga ganongavagwera pepojykaharete'ga nongavagwera, ei Tupana'gapyrive'ga kunhangwera'g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","A'ero kotihĩ ti peho imombe'gwovo garemimbo'ehara'g̃a pe. Pe'ji ti g̃a pe: “Okwerava'ja Jesus'ga omanoa hugwi. Pehendu ti! Oho na'ẽ ti ga Galiléiapeve'g̃a gwyri pe pe nenonde nehẽ. Pevo po ti pe ga repiagi nehẽ.” A'ea ti pe'ji g̃a pe, ei Tupana'gapyrive'ga. A'ea ko ji amombe'u pe me, ei ga kunhangwera'g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Kotihĩ g̃a hoi a'ero Jesus'ga ryvyagwera hugwi ogwovo. Okyhyji g̃a novĩa. A'ereki g̃a hory hete Jesus'ga kwerava kwahava. A'ero g̃a nhani ogwovo timombe'u ti Jesus'ga kwerava garemimbo'ehara'g̃a pe javo. ");
INSERT INTO pahNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Nanime Jesus'ga jipiukari g̃a pe g̃a novatiamo. —Pejoryjory ti! ei ga g̃a pe. Jesus'ga pyri g̃a nduri gapya pyhyga onhinog̃a nahã ga mboheteavo. ");
INSERT INTO pahNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","A'ero Jesus'ga ei g̃a pe: —Tapekyhyji ti. Peho ti imombe'gwovo nhiirũ'g̃a pe nhiremimbo'ehara'g̃a pe. Pe'ji ti g̃a pe toho ti g̃a Galiléiapeve'g̃a gwyri pe ji repiaga pevo nehẽ, ei Jesus'ga kunhangwera'g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Kunhangwera'g̃a horame soldados'g̃a – kiroki g̃a gwepia katu Jesus'ga ryvya – jararamo g̃a oho cidade pe. Ikwava'ẽhara'g̃a nduvihava'g̃a pyri g̃a hoi imombe'upava Jesus'ga ryvya pe'ahava. ");
INSERT INTO pahNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","A'ero ikwava'ẽhara'g̃a nduvihava'g̃a jatykai xava'eve'g̃a pavẽi onhi'inhi'ig̃a ojohupe. —Marã pendeaporog̃ita? ei g̃a ojohupe. —Nahã po ti nhande g̃a nderekoi a'ero nehẽ, ei g̃a. A'ero g̃a imondoi itambere'ia he'yjuhuva'ea soldados'g̃a pe pe'mbe ti ojipe'g̃a pe javo. ");
INSERT INTO pahNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Soldados'g̃a pe g̃a ei: —Oromondo ore itambere'ia pe me ko. Nurã ti pe'ji imombe'gwovo ojipe'g̃a pe pe'mbero. Pe'ji ti: “Ndorohepiakatui reki ore Jesusva'ea ryvya ypytunimo orokia. A'ero Jesusva'ea remimbo'ehara'g̃a nduri ahera'oa mima.” A'ea ti pe'ji pe'mbero. ");
INSERT INTO pahNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Po ti Pilatos'ga henduvi ikwahava pekira nehẽ, a'ero po ti ore ga ma'ngoma'ngogi tonhimonha'ngayme ti ga peporavykykatue'yma rehe nehẽ, ei g̃a soldados'g̃a pe g̃a mbo'eavo mbehea rehe. ");
INSERT INTO pahNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","A'ero soldados'g̃a ipyhygi itambere'ia okovo ikwava'ẽhara'g̃a nhi'ig̃a rupi xava'eve'g̃a nhi'ig̃a rupi no mbehea mombe'gwovo. A'ero g̃a'mbea judeus'g̃a heroviari imombe'gwombe'gwovo ojohupe jipi. —Jesusva'ea remimbo'ehara'g̃a omi ahera'oa aheryvya hugwi soldados'g̃a kirame ypytunimo, ei g̃a. ");
INSERT INTO pahNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Aerẽ Jesus'ga remimbo'ehara'g̃a onzeve'g̃a hoi Galiléiapeve'g̃a gwyri pe. Pevo g̃a hoi yvytyri pe. A'ereki Jesus'ga omombe'u jipe g̃a pe pevo ti peho javo. A'ero g̃a hoi ovahema. ");
INSERT INTO pahNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Ga repiagame pevo g̃a ga mbohetei. Ojipe'g̃a ndogweroviari. “Mara'ngu po Jesus'ga tuhẽ?” ei g̃a oyvyteri pe. ");
INSERT INTO pahNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","A'ero Jesus'ga ruri g̃a pyri katu javo g̃a pe: —Tupana'ga e'i ji ve: “Eko ti yvyakotyve'g̃a nduvihavuhuhetero yvagipeve'g̃a nduvihavuhuhetero no. Ndepopoaka hete nde g̃a hohe pa,” ei Tupana'ga ji ve, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","—Nurã ji ei pe me: Peho ti yvyakotyve'g̃a gwyripeve'g̃a pyri nhaporemo g̃a mbo'eavo toko ti g̃a Jesus'ga remimbo'eharamo javo, ei Jesus'ga. Pemobatiza ti g̃a. G̃a mobatizarame ti pe'ji g̃a pe: “Kiro pe penhimboukwaha Tupana'gareheva'ero penduvete'gareheva'ero. Kiro pe penhimboukwaha Tupana'ga ra'yra'gareheva'ero Jesus'gareheva'ero. Kiro pe penhimboukwaha Tupana'ga ra'uvapyryvareheva'ero.” A'ea ti pe'ji g̃a pe g̃a mobatizarame, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Pembo'e ti g̃a nhiremimbo'ea rehe nhaporemo tohendu katu ti g̃a javo – akoja rehe ji pe mbo'ei. Pehendu katu ti! ei ga. Nane'ymi po ti ji rekoi pe pyri mbapava rurame nehẽ no, ei Jesus'ga g̃a pe.");
INSERT INTO pahNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Nahanypy koi Jesus Cristo'ga mombe'upyryva Tupana'ga ra'yra'ga mombe'upyryva. Gaha ko Tupana'ga ombuhuruka yvya koty nhande pyri ikwehe. Igwete Tupana'ga ga mongoi nhanderekote'varuhua momboharamo ikwehe. ");
INSERT INTO pahNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Jesus'ga rura renonde João Batistava'ea rekoi ikwehe. A'ea mombe'unhog̃wenondeavo Isaíasva'ea ikwatijari inog̃a ymyahũ hako. Ahe omombe'u Tupana'ga nhi'ig̃a hako. Nahã Tupana'ga ei gwa'yra'ga pe: “Nde renonde ti ji ojipe'ga mondoi imombe'uuka ga pe nhinhi'ig̃a nehẽ tomboavujikwe pa ti ga nde ve nehẽ,” ei Tupana'ga gwa'yra'ga pe hako. A'ea Isaíasva'ea okwatija imombe'gwovo Tupana'ga nhi'ig̃a hako. ");
INSERT INTO pahNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Igwete Isaíasva'ea ikwatijara'javi inog̃a hako. Ahe omombe'ua'ja Tupana'ga ra'yra'ga renondeva'ea. “Hahyahi po ti ganhi'ig̃a ga erame g̃a mbo'eavo ongae'ỹi me nehẽ,” ei Isaíasva'ea ikwatija. “E'i po ti ga: ‘Pemboavujikwe ti pehea huvihava'ga pe tuhu ti ga nhande pyri javo. Pembohupi katu ti pehea ga pe,’ e po ti ga nehẽ,” ei ahe hako. Tupana'ga ra'yra'ga renondeva'ea e'i nhandepojykaharete'ga rurag̃wama pe tonhimboavujikwe ti g̃a garura renonde javo. A'ea pe ahe ei togwerojijyi ti g̃a gweaporog̃ita a'ea renonde javo. ");
INSERT INTO pahNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","6","Na tuhẽ reki. Jesus'ga rura renonde João Batistava'ea rekoi ikwehe. Igwete ahe ei javo g̃a pe ongae'ỹi me. Yuranuhũa'javuhuva'ea rava camelo rava ahe oapo opiramo. Ipira ahe oapo oku'ayviramo. O'u ahe tukura hehira reheve. Igwete ahe ei g̃a pe: —Perojijyjijyi ti pejeaporog̃ita pejipohia pejikote'varuhua hugwi Tupana'ga remiarõe'yma hugwi, ei ahe. Peko ti Tupana'ga remimbotarimova'ea rehe. A'ero po ti ji pe mobatizai nehẽ, ei ahe. Igwete po ti Tupana'ga imombohetei pendekote'varuhua pe hugwi nehẽ, ei João Batistava'ea. Igwete g̃a hopavi ojigwyra hugwi Judéia hugwi ahenhi'ig̃a renduva. Cidade de Jerusalém hugwi g̃a hopavi ahe pyri. Igwete g̃a imohemi okote'varuhua Tupana'ga pe ojipe'g̃a ndovaki toropohi ti jugwi javo. A'ero João Batistava'ea g̃a mobatizai rio Jordão pype. ");
INSERT INTO pahNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Igwete ahe ei g̃a pe jipi: —Jihoheheteve'ga po ti uhu huvihavuhuhetero. Ji ki a'e te ako tehe reki, ei ahe. ");
INSERT INTO pahNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ji opomobatiza yhya pyvõ kiro. Ga ki a'e te pe pojykauka Tupana'ga ra'uva pe, ei João Batistava'ea g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","A'ea rupi Jesus'ga ruri Galiléiapeve'g̃a gwyra hugwi cidade de Nazaré hugwi. Igwete João Batistava'ea ga mobatizai rio Jordão pype. ");
INSERT INTO pahNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Ohemame yhya hugwi Jesus'ga hepiagi yvaga jipe'a. Igwete ga hepiagi Tupana'ga ra'uva ijyva yvaga hugwi. A'ereki inambua ja ojy Jesus'ga rehe o'a. ");
INSERT INTO pahNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Igwete Tupana'ga onhi'ig̃a mbuhuri yvaga hugwi. —Nde ko jira'yra nhiremia'nguhetea, ei Tupana'ga ga pe. Anhimohẽ hete ji nde rehe, ei ga Jesus'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Igwete Tupana'ga ra'uva Jesus'ga rerohoi ongae'ỹi me. ");
INSERT INTO pahNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Quarenta ga kiri pevo. A'ea rupi Satanás'ga – ga ko anhag̃a ruvihavuhu'ga Tupana'ga arõe'ỹve'ga – a'ea rupi ga rekoi Jesus'ga pavẽi ga mongote'varuhupota novĩa. Mbatera onharõva'ea pevo u. Igwete yvagipeve'g̃a Tupana'gapyrive'g̃a Jesus'ga pokopokogi imondovo mbatera ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","G̃a João Batistava'ea mongirẽ cadeia pype Jesus'ga hoi Galiléiapeve'g̃a gwyri pe. Igwete ga imombe'ui g̃a pe pyryva'ea Tupana'ga remimombe'ua. ");
INSERT INTO pahNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Igwete Jesus'ga ei g̃a pe: —Kirog̃we Tupana'ga ei pe me toko ti g̃a jireheva'ero javo, ei Jesus'ga. Pepohi ti pejikote'varuhua hugwi imombiga, ei ga g̃a pe. Perovia ti pyryva'ea Tupana'ga mombe'ua pejikovo garemimbotarimova'ea rehe. A'ero po ti ga rekoi penduvihavuhuhetero pe mongovo onhi'ig̃a rupi nehẽ, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Aerẽ Jesus'ga hoi ypiahua rembeyvyri Galiléiapeve'g̃a gwyri pe. Igwete ga Simão'ga repiagi gareki'yra'ga no André'ga. Pira mboahava g̃a omombo ypiahua pype. A'ereki g̃a pira mboaharamo. ");
INSERT INTO pahNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Igwete Jesus'ga ei g̃a pe: —Pejijo ji rupi nhiremimbo'eharamo, ei ga g̃a pe. A'ero po ti pe ji mombe'ui ojipe'g̃a pe nehẽ no, ei Jesus'ga. Pira pe peru kirog̃we jipi. Ji pe mbo'erame po ti pe ojipe'g̃a nderuri ji pyri nehẽ toko ti g̃a Jesus'ga nhi'ig̃a rupi javo nehẽ, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Nambegwei Simão'g̃a hejari pira mboahava a'ero Jesus'ga rupi ogwovo garemimbo'eharamo okovo. ");
INSERT INTO pahNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Hehemo Jesus'ga hoi g̃a ndepiaga Zebedeu'ga ra'yra'g̃a Tiagova'ea João'ga no. Ombojoapyapy ko g̃a pira mboahava oyhara pype. ");
INSERT INTO pahNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","G̃a ndepiagame Jesus'ga onhi'ig̃a mondoi g̃a pe. —Pejijo ji rupi nhiremimbo'eharamo, ei ga g̃a pe. Igwete g̃a uva'ga rejari yhara pype oporavykyhara'g̃a ndeheve Jesus'ga rupi ogwovo gareheva'ero. ");
INSERT INTO pahNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Igwete Jesus'g̃a hoi cidade de Cafarnaum me. Judeus'g̃a poravykye'yma rupi sábado rupi Jesus'ga hoi judeus'g̃a mbo'eavo Tupana'ga nhi'ig̃a rehe g̃ajatykahava pype. ");
INSERT INTO pahNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Igwete g̃a nhimomby'ai ombo'ea repiaga upa. A'ereki judeus'g̃a mbo'ehara'g̃a atyvi ga g̃a mbo'ei. Ga hete okwaha Tupana'ga nhi'ig̃a oakag̃i pe. ");
INSERT INTO pahNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Nanime ga ruri g̃ajatykahava pype – kiroki ga anhag̃a opojyka ga. A'ea rembipojykaro g̃waramo ga onhi'ig̃a mondo Jesus'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","—Jesus, maranuhũrame nde ore avykyuhui? ei ga. Ore mombapava nde ruri naerũ? ei ga. Orokwaha hete ndehe. Nde ko pyryheteva'ero ereko Tupana'ga remimbuhurukaramo, ei ga Jesus'ga pe Nazarépeve'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","A'ero Jesus'ga nhi'ig̃ahyi jupe terenhi'ig̃i javo. —Ejipe'a ga hugwi, ei Jesus'ga jupe. ");
INSERT INTO pahNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","A'ero anhag̃a ga mog̃wyg̃wymahyi ohapukaita ojipe'avo ga hugwi. Anhag̃a jipe'arame ga hugwi ga pyryhetero a'ero. ");
INSERT INTO pahNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Igwete pevove'g̃a nhimomby'apavi Jesus'ga rehe upa. Igwete g̃a ei ojohupe: —Marag̃atu? ei g̃a. Hajiheva'ea rehe ga nhande mbo'ei, ei g̃a. Okwaha hete ga okovo. Ga erame anhag̃a vehevi g̃wendu katu ga, ei g̃a ojohupe. ");
INSERT INTO pahNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Kotihĩ g̃a Jesus'ga mombe'umbe'ui g̃a pe nhaporemo ojigwyri pe Galiléia pe. ");
INSERT INTO pahNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Igwete Jesus'g̃a hoi g̃ajatykahava hugwi. Tiagova'ea oho g̃a ndupi no João'ga pavẽi. Igwete g̃a jogwerohoi ojogwerovahema Simão'ga ronga pe. Pevo Simão'ga ruvi André'ga pavẽi. ");
INSERT INTO pahNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Kotihĩ g̃a hẽa mombe'ui Jesus'ga pe Simão'ga rembirekohẽa yhẽa. Onhino hẽa upa. A'ereki o'a hete hẽa rehe. Igwete g̃a hẽa mombe'ui Jesus'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Igwete ga hoi hẽa popyhyga hẽa mbovya hẽa mopo'ama. Omombi pa ga karugwara hẽa hugwi. A'ero hẽa hoi herua mbatera g̃a pe to'u g̃a javo. ");
INSERT INTO pahNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","33","Kwara hoa rupi cidadepeve'g̃a jogwerupavi onga pe Jesus'ga pyri. Gwerugweru g̃a ga pyri anhag̃a rembipojykahara'g̃a Diabo'gapyriva'ea rembipojykahara'g̃a. Itetirũave'g̃a g̃a gwerugweru pa g̃a nog̃a Jesus'ga pyri no. ");
INSERT INTO pahNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Igwete Jesus'ga imombigi g̃atetirũa joparaparava g̃a hugwi. He'yjuhuva'ea anhag̃a ga imbojipe'ai g̃a hugwi. Igwete ga nomonhi'ig̃ukari anhag̃a onhimombe'uukare'yma jupe. A'ereki a'ea okwaha ga Tupana'ga remimbuhurukara'ga javo ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Ko'eg̃atue'yma rupi Jesus'ga vyri ogwovo. Ga tehe oho cidade hugwi. Pevo ga nhi'inhi'ig̃i Tupana'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Aerẽ Simão'ga hoi Jesus'ga reka onhipavẽive'g̃a pavẽi. ");
INSERT INTO pahNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Ga repiagame g̃a ei ga pe: —Cidadepeve'g̃a nhaporemo nde reka okovo novĩa, ei g̃a. ");
INSERT INTO pahNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Igwete Jesus'ga ei g̃a pe: —Akwaha hete ji novĩa, ei ga. Emo ojipe'ipe'i pe ira'agweva'e pe po ti nhande xaho hamo. Tamombe'u ti Tupana'ga nhi'ig̃a pevove'g̃a pe no, ei ga. A'ereki a'ea rehe ji ajo yvya koty, ei ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","A'ero ga imbojoapiapi ogwovo cidades pe Galiléiapeve'g̃a gwyra rupi imombe'gwovo g̃ajatykahava pype. Igwete ga anhag̃a mbojipe'ape'ai g̃a hugwi imondovouka. ");
INSERT INTO pahNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Aerẽ ga ruri Jesus'ga pyri ijaijauhuve'ga. Igwete ga renypy'andurugi Jesus'ga pyri jihoheva'ero ji poko javo ga pe. —Jesus, ei ga. Nde eremoka'ẽ kwaha jijagwa ji hugwi. Po nde imoka'ẽpotari, a'ero po ti nde imoka'ẽi nehẽ, ei ga Jesus'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Iporia'i hete ga Jesus'ga pe. Nurã Jesus'ga jipoapyhoi opokoga ga rehe. —Apota ji, ei ga ga pe. Eka'ẽ ga hugwi! ei ga a'ero jupe. ");
INSERT INTO pahNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Kotihĩ gajagwa ika'embavi ga hugwi. ");
INSERT INTO pahNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Igwete Jesus'ga eahyi ga pe: —Ehendu tuhẽ ti nhinhi'ig̃a, ei ga. Teremombe'uuhui ti g̃a pe ndejagwa moka'ẽagwera. Heregwovo kiro ejipiuka mbatera kwava'ẽhara'ga pe, ei Jesus'ga ga pe. Moisésva'ea e'i po rimba'e: “Ika'ẽrame pe hugwi ti pemondo mbatepyryva ikwava'ẽhara'ga pe tokwava'ẽ ti ga Tupana'ga pe a'ero nehẽ,” ei ahe, ei Jesus'ga ga pe. Enhi'ĩpo'ru ti ahe a'ero. Emondo ti mbatera ikwava'ẽhara'ga pe tokwaha pa ti g̃a ndejagwa moka'ẽagwera, ei ga. Heregwovo kiro a'ero, ei Jesus'ga ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ohorame ga imombe'umbe'ui reki ojipe'g̃a pe Jesus'ga omoka'ẽ jijagwa ji hugwi javo. Nurã Jesus'ga ndohoa'javi cidades pe g̃andovaki. Ongae'ỹi me ga hoi okovo a'ero tonhimono'ono'og̃yme g̃a ji rehe javo. Emo g̃a ohooho reki pevo ga pyri ocidades hugwi nhaporemo. ");
INSERT INTO pahNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Aerẽ Jesus'ga jivyra'javi cidade de Cafarnaum me. —Jesus'ga ko pevo u onga pe, ei g̃a ga mombe'gwovo. ");
INSERT INTO pahNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Igwete g̃a jatykai onhimongyavo ga pyri. Tegwete reki g̃andupava onga pype. Tegwete g̃anduva jurukwara pyri no. A'ereki g̃a he'yjuhu hete ua ga pyri. Igwete Jesus'ga imombe'umbe'ui Tupana'ga nhi'ig̃a g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Igwete g̃a nomyive'ga reruri ga pyri novĩa. Quatro ko g̃a ojopokopokoga ga rehe ga rerua. ");
INSERT INTO pahNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Tegwete reki garerohohava Jesus'ga ypyvo he'yjuhuve'g̃a mbytera rupi. Nurã g̃a ga reruri ga rerojiupia onga arimo iperehuva'ea arimo ipe'ape'avo tujuga apopyra Jesus'ga rehei katu. Ikwara rupi g̃a ga mbojyvi ga mbuhua Jesus'ga pyri a'ero gakupeupava reheve. ");
INSERT INTO pahNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Hepiagame g̃ajikoga ojihe Jesus'ga ei nomyive'ga pe: —Amombo ji nderekote'varuhua nde hugwi. ");
INSERT INTO pahNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","G̃wino g̃a neni upa judeus'g̃a mbo'ehara'g̃a – kiroki g̃a ombo'embo'e g̃a Moisésva'ea remimbo'eagwera rehe. Jesus'ga nhi'ig̃a renduvame g̃a ei oyvyteri pe: ");
INSERT INTO pahNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Maranuhũrame ga euhui poa?” ei g̃a. “Onhimongouhu ga Tupana'ga'java'ero. A'ereki Tupana'ga jate omombo aherekote'varuhua,” ei g̃a oyvyteri pe. ");
INSERT INTO pahNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Kotihĩ Jesus'ga ikwahavi oyvyteri pe g̃andeaporog̃ita. Igwete ga ei g̃a pe: —Maranuhũrame pe ndeaporog̃itate'varuhuro pejijupa? ei ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","A'e ko ji ga pe ko: “Amombo ji nderekote'varuhua nde hugwi.” Emo pe ndapehepiagi aherekote'varuhua mombora. A'ero pe ndaperoviari jipopoakara, ei ga g̃a pe. Po ji ei ga pe: “Epo'ã, epyhy ejikupeupava herogwovo”, a'ero po ti pe ga repiagi herohorame nehẽ. A'ero po ti pe jipopoakara heroviari nehẽ, ei ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Tupana'ga ji mbuhuruka yvya koty, ei Jesus'ga. Gaha omomboruka ji ve aherekote'varuhua ahe hugwi, ei ga g̃a pe. Amopo'ã ti ji nomyive'ga kiro a'ero nehẽ tapekwaha ti jipopoakara nehẽ. A'ero po ti pe ei nehẽ: “Tupana'ga ombuhuruka tuhẽ Jesus'ga avo yvya koty,” ei ga. Nurã ji ei kiro ga pe, ei ga. ");
INSERT INTO pahNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","—Nde ve ji ei, ei Jesus'ga nomyive'ga pe. Epo'ã. Epyhy ekupeupava herogwovo enhonga pe, ei Jesus'ga ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","G̃andovaki ga po'ag̃atui a'ero ipyhyga okupeupava herokwava. Ga repiagame g̃a nhimomby'apavi. Igwete g̃a ei: —Pyry hete ko Tupana'ga. Pyry hete ko ga. Ymyagwera jate ko nhande ndihepiagangavi nanongara, ei g̃a ojohupe. ");
INSERT INTO pahNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Aerẽ Jesus'ga hoa'javi ypiahua rembeyvyri. A'ero he'yjuhuve'g̃a jatykai ogwovo ga pyri. Igwete ga g̃a mbo'ei Tupana'ga nhi'ig̃a rehe. ");
INSERT INTO pahNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Hehemo ga hoi. Igwete ga Levi'ga repiagi. Ga ko Alfeu'ga ra'yra'ga. Itambere'ia ryrua pype Levi'ga reni. A'ereki ga omono'õ itambere'ia ipyhyga pevove'g̃a hugwi tamondo ti governo pe javo. Igwete Jesus'ga ga repiagi javo ga pe. —Herejo ji rupi nhiremimbo'eharamo, ei ga Levi'ga pe. Igwete ga po'ami ogwovo Jesus'ga rupi garemimbo'eharamo. ");
INSERT INTO pahNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Aerẽ Jesus'ga g̃wemimbo'ehara'g̃a nderohoi Levi'ga ronga pe. Igwete g̃a i'ui he'yjuhuve'g̃a pavẽi. A'ereki he'yjuhu g̃a okovo Jesus'ga pyri jipi itambere'ia mono'õhara'g̃a. G̃ahã oko ga pyri no – kiroki g̃a pe ojipe'g̃a e'i ite'varuhu g̃a javo. A'ereki g̃a nohendukatupavi Moisésva'ea remimbo'eagwera jipi. ");
INSERT INTO pahNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Igwete Jesus'g̃a i'ui g̃a pavẽi. A'ero judeus'g̃a mbo'ehara'g̃a nduri no. G̃a ko fariseus'g̃a. G̃a e'i tihendu katu pa Moisésva'ea remimbo'eagwera javo novĩa. A'ero g̃a nduri Jesus'g̃a ndepiaga g̃a i'urame jara'g̃a pavẽi. Nurã g̃a ei Jesus'ga remimbo'ehara'g̃a pe: —Maranuhũrame Jesus'ga jihe'aruhui itambere'ia mono'õhara'g̃a ndehe okote'varuhuve'g̃a ndehe no i'gwovo g̃a pavẽi, ei g̃a Jesus'ga remimbo'ehara'g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Henduvame g̃anhi'ig̃a ojihe Jesus'ga ei javo g̃a pe: —Tamombe'u katu ti pe me a'ero jijihe'ara nanongara'g̃a ndehe, ei ga. Ji ko ahepohanohara'ga ja, ei ga. Kiroki g̃a e'i ojive: “Nanhitetirũi ji” – g̃ahã ahepohanohara'ga ndopokogi g̃a pohanog̃e'yma. Kiroki g̃a e'i ojive: “Nhitetirũa ji” – g̃ahã ahepohanohara'ga g̃a pokogi g̃a pohanog̃a. Na jitehe ji okote'varuhuve'g̃a pokogi jijihe'a g̃a ndehe topohi ti g̃a okote'varuhua hugwi javo, ei Jesus'ga g̃a pe. A'ereki a'ea rehe ji ajo yvya koty tapoko ti g̃a javo – kiroki g̃a e'i ojive: “Ako te'varuhu ji. Marã po ti ji ve a'ero nehẽ?” ei ga. Ojipe'g̃a pyri rũi ji ajo javo – kiroki g̃a e'i ojive: “Jipyry hete ji,” ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Aerẽ ojipe'g̃a nduri Jesus'ga pyri xa'e ti ga pe javo. A'ereki João Batistava'ea remimbo'ehara'g̃a, amoamome g̃a ei ojohupe: “Ti'uyme ti mbatera xanhi'inhi'ĩ Tupana'ga pe javo,” ei g̃a. Fariseus'g̃a na jitehe amoamome g̃a ei xanhi'ĩ Tupana'ga pe i'ue'yma javo. Igwete ojipe'g̃a nduri Jesus'ga pyri javo ga pe. —Ndo'ui ko João Batista'ga remimbo'ehara'g̃a xanhi'ĩ Tupana'ga pe javo, ei g̃a. Fariseus'g̃a nemimbo'ehara'g̃a na jitehe ndo'ui mbatera onhi'ig̃a ga pe. Neremimbo'ehara'g̃a ki a'e te o'uo'u mbatera jipi, ei g̃a. Maraname nanuhũ g̃a ndekoi a'ero naerũ jara'g̃a atyvi? ei g̃a Jesus'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Igwete Jesus'ga ei g̃a pe: —Nhiremimbo'ehara'g̃a ko g̃a javijitehe – kiroki g̃a oko hẽarembirekoruama'ga pavẽi, ei ga. Gapavẽive'g̃a ko o'u tuhẽ mbatera gworygworyvamo ga pavẽi okovo g̃waramo, ei ga g̃a pe. Nhiremimbo'ehara'g̃a na jitehe a'ero. ");
INSERT INTO pahNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","G̃a ko o'u ji pavẽi okovo g̃waramo, ei Jesus'ga g̃a pe. Aerẽ po ti okote'varuhuve'g̃a ji rerohoi g̃a hugwi nehẽ. A'ea rupi po ti g̃a ndo'ui mbatera nehẽ no ovy'are'yma g̃waramo, ei ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Igwete Jesus'ga ei no: —Tamombe'u ti pe me ojipea ojo'java'ea no. Po ahe oapokatua'ja pota tapy'ynhapirymyana, nomondoi po ahe tapy'ynhapirapyahua ndotyryrygiva'ea itararagagwera rehe imboja, ei ga. Kia pyvõ imbojarame po jikyi ymyahũva'ea hugwi ityryrygame. A'ero po ijovaja'rokatui, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","—Irũa tamombe'u pe me no, ei Jesus'ga. Vinho aporame ahe nonhag̃i hyruymyana pype mbiara pirymyana pype tireko katu javo. A'ereki vinhopyahua ombotyjutyjui ovuvua, ei ga. Inhag̃ame mbiara pirymyana pype vinhopyahua vuvuvuvuri a'ero imombuga ipira otururupava jugwi. Onhimomby hete a'ero. Ombote'varuhu mbiara pira no, ei ga g̃a pe. Ipipyahua pype reki ahe onha vinhopyahua a'ero, ei ga g̃a pe. G̃wemimbo'ea pe Jesus'ga ei a'ea. A'ereki garemimombe'ua ndojihe'ari g̃anamonhava'ea remimombe'uagwera rehe. ");
INSERT INTO pahNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Aerẽ judeus'g̃a poravykye'yma rupi sábado rupi Jesus'g̃a hoi pea rupi ogwovo. Igwete g̃a hoi kopytera rupi ogwovo. Ohorame garemimbo'ehara'g̃a ika'mbika'mbigi trigo i'gwovo. ");
INSERT INTO pahNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","A'ero fariseus'g̃a ei Jesus'ga pe: —Ehepia g̃a, ei g̃a. Moisésva'ea e'i ikwatija nhande ve hako: “Sábado rupi nhande ndiaporavykyi hamo,” ei ahe, ei g̃a. Maranuhũrame g̃a trigo ika'mbika'mbigi sábado rupi naerũ Moisésva'ea remimbo'eagwera rendukatue'yma naerũ? ei g̃a Jesus'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","26","Igwete Jesus'ga ei g̃a pe: —Tupana'ga rembikwatijarukara onhi'ĩ pe me novĩa Daviva'ea mombe'gwovo, ei ga. Ymyahũ ko Daviva'ea hoi Tupana'ga ronga pype tenda pype hako. A'ea pype ikwava'ẽhara'g̃a ono pão imondovo Tupana'ga pe jipi, ei ga. Ikwava'ẽhara'g̃a jate po o'u a'ea hamo. “Ojipe'g̃a po to'uyme hamo,” e'i ikwatijara novĩa Tupana'ga nhi'ig̃a mombe'gwovo, ei Jesus'ga. Igwete Daviva'ea hoi Tupana'ga ronga pype. Ahe ndogwerekoi mbatera ojive. Ahepavẽiva'ea ndogwerekoi no. Nurã ty'ara ahe jukai, ei ga g̃a pe. A'ero Abiatarva'ea ikwava'ẽhara'g̃a nduvihavuhuag̃wamava'ea ahe imondoi akoja Daviva'ea pe to'u ti ga javo. Igwete Daviva'ea i'ui hako imondovo onhipavẽiva'ea pe hako, ei Jesus'ga g̃a pe. Tupana'ga nde'i reki Daviva'ea pe hako: “Pe napehendukatui nhinhi'ig̃a i'gwovo.” Ga nde'iahyi ahe ve, ei Jesus'ga. Oro pe, ei ga, maranuhũrame pe euhui nhiremimbo'ehara'g̃a pe naerũ? ei ga fariseus'g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Igwete Jesus'ga ei g̃a pe no: —Tupana'ga nde'i hako: “Kiro po ti ji yvyakotyve'g̃a apoi tokwaku ti g̃a sábado javo.” A'ea ga nde'i, ei Jesus'ga. Nahã ga ei reki hako: “Kiro po ti ji sábado apoi g̃a pe tipokapa pi ti g̃a javo,” ei ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Tupana'ga ji mbuhuruka yvya koty, ei ga. Nurã jihi a'e nahanahã ti g̃a toko javo. Sábado pe vehevi ji ei no nahã ti g̃a toko a'ea rupi javo, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Aerẽ Jesus'ga hoa'javi g̃ajatykahava pype. Pevo ga rekoi iponhimamave'ga. ");
INSERT INTO pahNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Igwete fariseus'g̃a Jesus'ga repiahetei timbotegwete ga javo. —Kiro sábado, ei g̃a ojohupe. Mara'ngu po ti ga gapoa mbokatua'java nehẽ kiro nhandeporavykye'yma rupi? ei g̃a. Gapoa mbokatua'javame po ti nhande ei ga pe: “Nerehendukatui nde Moisésva'ea remimbo'eagwera,” xa'e ti ga pe, ei g̃a ojohupe. ");
INSERT INTO pahNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Igwete Jesus'ga ei iponhimamave'ga pe: —Epo'ã ejoa g̃apytera rupi. ");
INSERT INTO pahNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Jara'g̃a pe Jesus'ga ei: —Pe'ji ti ji ve. Marã po nhande rekoi nhandeporavykye'yma rupi hamo? Gara Moisésva'ea ei nhandeporavykye'yma mombe'gwovo sábado mombe'gwovo po rimba'e naerũ? ei ga. E'i po ahe naerũ: “Timbote'varuhu ti ojipe'g̃a pe sábado rupi hamo”? A'ea po ahe ei naerũ? Pe'ji katu ti ji ve a'ero, ei Jesus'ga g̃a pe. “Timombyry ti g̃a pe a'ea rupi hamo.” A'ea ahe ei po rimba'e? ei ga. Gara Moisésva'ea ei sábado mombe'gwovo naerũ? “Tijuka ti g̃a a'ea rupi hamo.” A'ea po ahe ei naerũ? Pe'ji katu ti ji ve a'ero, ei ga g̃a pe. “Timomanoukaryme ti g̃a a'ea rupi hamo,” e po ahe? ei Jesus'ga g̃a pe. Igwete g̃a nonhi'ig̃a'javi ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","A'ero Jesus'ga g̃a ndepiapavi onhimonha'ngavo. Okoveveuhu ga g̃a ndehe. A'ereki g̃a noangarihu ojipe'g̃a porogwetyge'yma. Igwete ga ei iponhimamave'ga pe: —Epyho epoa. A'ero ga jipoapyhokatui. A'ereki gapoa ikatua'ja ga Jesus'ga nhi'ĩpo'rurame. ");
INSERT INTO pahNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Igwete g̃a ẽi fariseus'g̃a. Kotihĩ g̃a Herodes'gareheve'g̃a monhi'inhi'ig̃i a'ero. Igwete g̃a ei: —Maranuhũ po ti nhande Jesus'ga jukaukaruhui nehẽ? ei g̃a ojohupe. ");
INSERT INTO pahNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Igwete Jesus'ga g̃wemimbo'ehara'g̃a nderohoi ypiahua rembe'yi pe. He'yjuhu hete g̃a ua ga pyri ojigwyra hugwi. Galiléia hugwi g̃a ndupavi Judéia hugwi no Iduméia hugwi no. ");
INSERT INTO pahNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Cidade de Jerusalém hugwi g̃a nduri no. Rio Jordão kikoty aherovaja hugwi g̃a nduri Jesus'ga pyri no. Cidadepyrive'g̃a uhu pa no Tiropyrive'g̃a Sidompyrive'g̃a. A'ereki g̃a g̃wendu g̃a imombe'urame Jesus'ga rembiapoa ahemonhimomby'ava'ea. A'ero g̃a ndupavi ga pyri onhimongyavo. ");
INSERT INTO pahNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","10","Igwete ga imombimombigi karugwara he'yjuhuve'g̃a hugwi. Nurã itetirũave'g̃a Jesus'ga mbotymbotyvahivi tomombi ti ga ji hugwi javo. Nurã Jesus'ga ei g̃wemimbo'ehara'g̃a pe: —Peru ti yhara ji ve. Ta'a ti ipype g̃a hugwi tanhimbotymbotyvahyyme ti g̃a onhimongyavo, ei ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Igwete g̃a nduri jipi – kiroki g̃a anhag̃a opojyka g̃a. Jesus'ga repiagame g̃a nenypy'andurugi ga pyri o'eahyavo nde ko Tupana'ga ra'yramo javo. ");
INSERT INTO pahNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","A'ero ga nhi'ig̃ahyi g̃a pe tanhimombe'uyme ti g̃a javo. ");
INSERT INTO pahNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Aerẽ Jesus'ga jiupiri yvytyruhua rupi ogwovo. Igwete ga g̃a mbuhurukari ojipyri g̃wemimbotarimo. ");
INSERT INTO pahNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Doze ko g̃a, ga g̃a mo'emo'ẽi ojiheva'ero. (Nhimoirũhara ei ga g̃a pe.) A'ero ga ei g̃a pe: —Topomondo ti imombe'gwovouka nhinhi'ig̃a ojipe'g̃a pe nehẽ. ");
INSERT INTO pahNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Tambojipe'auka ti ji pe me anhag̃a Diabo'gapyriva'ea g̃a hugwi nehẽ, ei ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","19","Dozeve'g̃a ko: Simão'ga, Tiagova'ea, aheirũ'ga João'ga, André'ga, Filipe'ga, Bartolomeu'ga, Mateus'ga, Tomé'ga, Tiago'ga – kiroki ga Alfeu'ga ra'yra'ga – Tadeu'ga, Simão Zelote'ga, Judas Iscariotes'ga – ga ko aerẽ omondouka Jesus'ga ga'arõe'ỹve'g̃a po pe ga pyhygauka. G̃ahã Jesus'ga omo'emo'ẽ g̃wemimbo'eharamo dozeve'g̃a. Ojipea Jesus'ga ono Simão'ga rehe. Pedro Jesus'ga ono ga rehe. Tiagova'ea ko Zebedeu'ga ra'yrava'ea João'ga pavẽi. Ojipea Jesus'ga ono g̃a ndehe g̃anderaramo Boanerges. Boanerges pe nhande ei: G̃a ko tupanarag̃a ja. ");
INSERT INTO pahNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Igwete Jesus'ga g̃wemimbo'ehara'g̃a nderohoi onga pe. Kiro he'yjuhuve'g̃a jatykai g̃a pyri a'ero. Ndo'uukari g̃a mbatera Jesus'g̃a pe u'ua g̃a pyri. ");
INSERT INTO pahNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ikwahavame Jesus'ga re'yja'g̃a hoi ga pyri. Igwete g̃a ei: —Tipyhy ti Jesus'ga rerogwovo g̃a hugwi. A'ereki ga'akag̃a mbipehu kiro ovuhu, e'i tehe g̃a Jesus'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Igwete judeus'g̃a mbo'ehara'g̃a ei – kiroki g̃a u Jerusalém hugwi – igwete g̃a ei ojohupe: —Belzebu'ga opojyka Jesus'ga ojive, e'i tehe g̃a. Nurã Jesus'ga ombojipe'auka anhag̃a g̃a hugwi, ei g̃a. A'ereki Belzebu'ga anhag̃a ruvihavuhuro. A'ero ga anhag̃a mbojipe'aukari Jesus'ga pe, e'i tehe g̃a ojohupe. Satanás'ga pe g̃a ei Belzebu'ga. Diabo'ga ei g̃a ga pe no. ");
INSERT INTO pahNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","A'ero Jesus'ga g̃a mbuhurukari ojipyri judeus'g̃a mbo'ehara'g̃a. Igwete ga imombe'umbe'ui ojo'java'ea g̃a pe. —Mbipehu reki pendeaporog̃ita, ei ga g̃a pe. Satanás'ga ndajipojykai tuhẽ jihi. Satanás'ga g̃a pojykarame ojive nombojipe'aukari g̃a pe ojipyriva'ea. A'ereki ga nombojogwayvayvari reki ojiheve'g̃a, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Tamombe'u ti ojo'java'ea pe me a'ero, ei ga. Po g̃agwyripeve'g̃a ojogwayvayva hete, a'ero po g̃a nhombojipe'apavi ojohugwi. ");
INSERT INTO pahNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Po ongapypeve'g̃a ojogwayvayva, a'ero po g̃a nhombojipe'apavi ojohugwi no. ");
INSERT INTO pahNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Po Satanás'ga ojipyriva'ea mbojogwayvayva hamo, a'ero po gapyriva'ea nhombojipe'apavi ojohugwi, ei ga. A'ero po Satanás'ga ndogwerekoa'javi ojiheve'g̃a. Ndokoa'javi po ga huvihavamo a'ero, ei Jesus'ga g̃a pe. Na rũi reki Satanás'ga rekoi, a'e ji, ei ga. Ga nombojogwayvayvari ojipyriva'ea. Ga rũi reki ombojipe'auka ji ve anhag̃a ojipe'g̃a hugwi a'ero, ei ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Igwete Jesus'ga ei no: —Ojipe'g̃a ndoki ipopoakave'ga ronga pype gambatera rerogwovo ga hugwi. Gahoheve'ga jate oki ipype opopoakahetero g̃waramo. Igwete ga ga kwana'ẽi gambatera ipe'avo herogwovo ga hugwi, ei ga g̃a pe. Nahã Jesus'ga ei g̃a pe jihi ko Satanás'ga hohe gapyriva'ea mbojipe'avo javo. ");
INSERT INTO pahNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","30","Igwete ga ei g̃a pe: —“Anhag̃a opojyka ga ojive,” pe'euhu tehe pe ji ve, ei ga javo g̃a pe. Nurã ti ji ei pe me imombe'ukatuavo: Tupana'ga po ti omombo pa ahe hugwi aherekote'varuhuparavuhua. Ombotegwetea vehevi po ti Tupana'ga omombo pa ahe hugwi, ei ga. Emo gwa'uva mbotegwetea po ti Tupana'ga nomombori tuhẽ ahe hugwi. A'ea ndojihyva'javi ahe hugwi avuirama, ei ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","32","Kiro g̃a vahemi a'ero Jesus'ga yhẽa gareki'yra'g̃a pavẽi. Okari pe g̃a pytai o'ama. A'ereki he'yjuhuve'g̃a u ga pyri oapyapyga. Igwete Jesus'ga re'yja'g̃a imondoi onhi'ig̃a ga pe tuhu ti ga ore pyri javo. A'ero g̃a imombe'ui ga pe: —Jesus, okari pe g̃a ndekoi neyhẽa neirũ'g̃a pavẽi. “Tuhu ga ore pyri,” ei g̃a nde ve, ei g̃a ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Igwete Jesus'ga ei g̃a pe: —Marãve'g̃a pe ji ei naerũ nhiy'g̃a nhiirũ'g̃a? ");
INSERT INTO pahNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Gweroapyve'g̃a ndepiagame ga ei g̃a pe a'ero: —Agwa reki g̃a nhiy'g̃a nhiirũ'g̃a, ei ga. ");
INSERT INTO pahNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Kiroki g̃a oko Tupana'ga remimbotarimova'ea rehe – g̃a pe ji ei nhiirũ'g̃a nhirendyra'g̃a. Nhiy'g̃a a'e ji g̃a pe, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Aerẽ Jesus'ga g̃a mbo'ea'javi ypiahua rembe'yi pe. He'yjuhu g̃a ojatykavo ga pyri yembe'yi pe onhimongyavo. Nurã ga avi yhara pype oina imoanha'ndiavouka tohendu pa ti g̃a nhinhi'ig̃a javo. ");
INSERT INTO pahNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Igwete ga g̃a mbo'ea'javi imombe'gwombe'gwovo ojo'java'ea g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","—Pehendu ti, ei ga. Imohãihara'ga gweroho ha'ynha ko pe imohaina ityma, ei ga. ");
INSERT INTO pahNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Imohãirame mokonhete indurugi pea rembeyvyra rupi. Igwete gwyra'ia ruri imokokona jupava, ei ga imombe'gwovo g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","—Jara onduru yja rehe, ei ga. Xunhi reki yja ita arimo. Kotihĩ henhunhamo a'ero novĩa. A'ereki nianami yja. ");
INSERT INTO pahNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Emo kwarahyahivame ombokai imonhymbava hohova. Garemity'mbia ipavi a'ero onhimomiranama'jave'yma. A'ereki hapoa ndokihetei yvya pype, ei ga imombe'gwovo. ");
INSERT INTO pahNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","—Jara onduru nhungwava ra'ynha pyteri pe hatĩava'ea ra'ynha pyteri pe. Igwete ga'apoa ha'ynha henhunhamo nhungwava ra'ynha pavẽi. Igwete nhungwava nhambyguhui garemityma herekovo imonhimomboakare'yma. Igwete ndi'ai upa, ei ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","—Jara reki onduru yvykatua rehe. A'ea henhunhamo onhimomboaka gworyvamo. O'arame he'ye'yi ha'ynha trinta ahara pype. Jara pype koji'i tehe ha'ynha sessenta. Jara pype ha'ynha he'yjuhuro cem ipype, ei Jesus'ga imombe'gwovo g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Peapyakwa pe. Pehendu katu ti ji'ea a'ero, ei ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Garenduhara'g̃a horame ga hugwi gapavẽive'g̃a nhi'ig̃i ga pe dozeve'g̃a pavẽi. Igwete g̃a ei ga pe: —Gara pe nde ei poro morog̃ita mombe'gwovo ore ve? ei g̃a. A'ereki ore ndorokwahavi a'ea, ei g̃a ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Igwete Jesus'ga ei g̃a pe: —Amombe'u katu ji kiro pe me. A'ereki Tupana'ga opota penembikwahava, ei Jesus'ga g̃a pe. Okwahavuka ga pe me onhimiva'ea nahã po ti ji rekoi ojiheve'g̃a nduvihavamo nehẽ javo, ei ga g̃a pe. Pe me jate ga okwahavuka nanongara. G̃a ki a'e te – kiroki g̃a ndokoi gareheva'ero – g̃a pe ji amombe'u ojo'java'ea ikwahavukare'yma g̃a pe, ei ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Ojo'java'ea ji amombe'u g̃a pe a'ero “tonhimombaragwahavyme ti g̃a hepiepiagame. Tokwahavyme ti g̃a henduenduvame. A'ereki g̃a ndogwerojijyipotari gweaporog̃ita. Nomomborukapotari g̃a Tupana'ga pe okote'varuhua”, ei ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Igwete Jesus'ga ei g̃a pe no: —Ndapekwahavi pe ji imombe'urame pe me garemitymagwera? Marã po ti pe ikwahapavi ojo'java'ea naerũ? ei ga. ");
INSERT INTO pahNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Tamombe'u katu ti kiro itymagwera pe me a'ero, ei Jesus'ga g̃a pe. —Kiroki ga omombe'u Tupana'ga – ga ko ha'ynha mohãihara'ga ja, ei ga. ");
INSERT INTO pahNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Mokonhete'i ha'ynha onduru pehea rembeyvyri. Igwete gwyra'ia imokokombavi ha'ynha imohãirame, ei ga. Na jitehe ojipe'g̃a henduvame Tupana'ga mombe'ua Satanás'ga imoka'nhymbavi a'ea g̃a hugwi, ei ga imombe'gwovo g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","—Jara ha'ynha onduru yja rehe ita arimo. Nurã g̃wenhunhame kotihĩ nonhimomiranami, ei ga. Na jitehe ojipe'g̃a henduvi Tupana'ga mombe'ua kotihĩ gworygworyvamo hehe novĩa. ");
INSERT INTO pahNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","G̃wendu katu na'ẽ g̃a gamombe'ua novĩa. Aerẽ ojipe'g̃a imbohahyukari g̃a pe g̃a ndekoro g̃waramo Tupana'ga mombe'ua rupi, ei ga. Hahyrame g̃a pe g̃a nonhimomiranama'javi a'ero kotihĩ opohia Tupana'ga mombe'ua hugwi. A'ereki gamombe'ua ndokikatui g̃ayvyteri pe, ei Jesus'ga imombe'gwovo g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","—Jara onduru nhungwava ra'ynha pyteri pe hatĩava'ea ra'ynha pyteri pe – a'ea oambyguhu garemityma imonhimomboakare'yma, ei ga. Na jitehe ojipe'g̃a henduna'ẽi Tupana'ga mombe'ua novĩa. ");
INSERT INTO pahNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Aerẽ g̃apy'a rekotehei. A'ereki g̃a nhag̃ataruhu ojihe marã po ti ji ve nehẽ javo, ei ga. Igwete g̃a nhimoandyandyi itambere'ia potaruhuavo a'ea po ti ji mbohoryhetei nehẽ javo tehe. Igwete g̃a ipotaparavuhui mbatera, ei ga. Hatĩava'ea oamby imohãihara'ga remityma. A'ero ndi'ai, ei ga. Na jitehe g̃anemimbotaruhua nohenduva'javukari g̃a pe Tupana'ga mombe'ua. A'ero g̃a ndokoi gamombe'ua rupi okokatue'yma ojipe'g̃a pe japoe'yma pyryva'ea, ei ga imombe'gwovo g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","—Jara onduru yvykatua rehe g̃wenhukaturo gworygworyvamo, ei ga. Na jitehe jara'g̃a henduvi Tupana'ga mombe'ua herovia tuhẽ okokatuavo, ei ga. Jara'g̃a oapo hete pyryva'ea a'ero. Jara'g̃a koji'i g̃a oapo pyryva'ea. Jara'g̃a koji'iete'i g̃a oapoapo pyryheteva'ea jipi okokatuavo, ei Jesus'ga imombe'gwovo g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Igwete Jesus'ga ei g̃a pe no: —Herurame lamparina oki pe po ahe ndohovapygi hyrua pyvõ. Ahe nomondoi onhinongava gwyri pe cama gwyri pe. Ahe gweru imondovo pyte'mbia rehe imohina tamomytu'emba nhande ve javo, ei ga. ");
INSERT INTO pahNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Na jitehe Tupana'ga g̃wenotĩ na'ẽ g̃wemimbo'eagwera tamomytu'emba ti g̃a'akag̃i pe aerẽ nehẽ javo, ei ga. ");
INSERT INTO pahNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Peapyakwa pe. Pehendu katu ti ji'ea a'ero, ei ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Igwete Jesus'ga ei g̃a pe no: —Henduvame nhinhi'ig̃a pehendu katu ti a'ero, ei ga. Po ti xunhi pe henduvi nhinhi'ig̃a, a'ero po ti xunhi pe ikwahavi nehẽ. Po ti pe hendukatui nehẽ, a'ero po ti pe ikwahahetei nehẽ. Koji'i po ti Tupana'ga pe mbo'ea'javi a'ero nehẽ no, ei ga. ");
INSERT INTO pahNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Po ti pe ikwahavi nhinhi'ig̃a rendukatuavo nehẽ, a'ero po ti pe ikwahahetei nehẽ, ei ga. Po ti xunhi pe ikwahavi nhinhi'ig̃a hendupotare'yma, a'ea vehevi po ti Tupana'ga imoka'nhymbavukari pe me nehẽ, ei Jesus'ga imombe'gwovo g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Igwete Jesus'ga ei no: —Ojipea tamombe'u pe me ojo'java'ea tapekwaha hete ti Tupana'gareheve'g̃a jikoheteag̃wama ga rehe. A'ereki Tupana'ga hete g̃a mbojikojikogukari ojihe jipi g̃anduvihavamo. Na ja a'ero, ei ga. Ha'ynha mohãihara'ga omohãi ha'ynha yvyvo. ");
INSERT INTO pahNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","He'yi ga kiri henhunhame ogwovo hepiaga. Igwete garemityma nhimomboakari. “Marã po nhiremityma renhunhamo onhimomboaka a'ero?” ei ga jupe ikwahave'yma, ei ga. ");
INSERT INTO pahNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","A'ereki a'ea tehe henhui ohema yvya hugwi. Aerẽ nhimomboakari oharamo. Aerẽ itinig̃i, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","A'ero ga g̃a mondoukari imondohondohogauka haimbeva'ea pyvõ foice pyvõ. A'ereki oho japiavo imondohokava, ei Jesus'ga g̃a pe imombe'gwovo. ");
INSERT INTO pahNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Igwete Jesus'ga ei g̃a pe no: —Marãva'ea ti ji imombe'ui kiro pe me ojo'java'ea tapekwaha ti Tupana'gareheve'g̃a nde'yjuhuag̃wama? ei ga. A'ereki jypy g̃a ndahe'yi. Aerẽ reki g̃a nde'yjuhuro – kiroki g̃a e'i: “Tupana'ga ko nhanderuvihavamo”, ei Jesus'ga g̃a pe. Na ja a'ero, ei ga. ");
INSERT INTO pahNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Otỹ ga mostarda ra'ynha, ei ga. Xunhiete'i ko nanongara ra'ynha jara gwyre'i pa. ");
INSERT INTO pahNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Itymirẽ reki onhimomboaka hete huvihavuhuro oji'java'ea hohe pa, ei ga. Huvihavuhu hakã oja'oja'oga. Nurã gwyra'ia turi japovo gwaityga hakã rehe upa i'ag̃i pe, ei Jesus'ga imombe'gwovo g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Nanongara ga imombe'umbe'ui he'yjuhuve'g̃a pe ojo'java'ea mombe'gwovo. G̃a ikwahavame koji'i ga imombe'ui g̃a pe a'ero. ");
INSERT INTO pahNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ojo'java'ea jate ga omombe'umbe'u he'yjuhuve'g̃a pe g̃a mbo'erame Tupana'ga nhi'ig̃a rehe. Emo g̃andovakie'ỹ ga imombe'ukatupavi g̃wemimbo'ehara'g̃a pe tokwaha tuhẽ g̃a javo. ");
INSERT INTO pahNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Ka'arugame Jesus'ga ei g̃wemimbo'ehara'g̃a pe: —Xaho ti aherovai. ");
INSERT INTO pahNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Igwete g̃a hoi he'yjuhuve'g̃a hugwi. Jesus'ga oapy oina yhara pype. Igwete g̃a ga rerohoi ypiahua aherovai. Ojipe'g̃a oho oyhara pype g̃a ndupi no. ");
INSERT INTO pahNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","G̃a horame turi yvyruhua. Yvyturanuhũa ombo'ambo'a typepemuhũa yhara pype. Kiro tynahẽ g̃werĩ yhara a'ero. ");
INSERT INTO pahNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Jesus'ga oki reki yhara revira rehe oakag̃a nog̃a aheakag̃a jikokava rehe. Igwete g̃a ga moma'ẽi javo ga pe. —Jesus, kiro nhande hoi ypy pe, ei g̃a. Nane'ag̃ataruhui nde nhandepapava rehe naerũ? ei g̃a ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Igwete ga ma'ẽi onhi'ig̃ahyavo yvytua pe. Igwete ga ei ypiahua pe: —Epi! ei ga. Tanetymyi ti. A'ero ipigi yvytua. Notymynha'javi. ");
INSERT INTO pahNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Igwete Jesus'ga ei g̃wemimbo'ehara'g̃a pe: —Maraname pe kyhyjiuhui? ei ga. Ndapejikogi ve tuhẽ pe ji rehe naerũ? ei ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Igwete g̃a nhimomby'ahetei a'ero javo ojohupe: —Marã te ga rekoi naerũ? Yvytua vehevi re po g̃wendu katu ganhi'ig̃a ypiahua pavẽi, ei g̃a javo ojohupe. ");
INSERT INTO pahNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Igwete Jesus'g̃a vahemi ypiahua aherovai Gerasapeve'g̃a gwyri pe. ");
INSERT INTO pahNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Jesus'g̃a ẽrame ga ruri – kiroki ga anhag̃a opojyka ga ojive. ");
INSERT INTO pahNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","4","Itaruvihavuhua kwaruhua pyteri pe ga u jipi aheryvya pyteri pe. Okwaokwa g̃a ga itanhuramuhũa pyvõ novĩa. Igwete ga imondohondohogi opoa hugwi opya hugwi ikaikavo. Nurã g̃a ndokwara'javi ga a'ero itanhuramuhũa pyvõ. Ndipopoakari g̃a ga monhyromo. ");
INSERT INTO pahNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Arimo ypytunimo na jitehe ga rahẽrahemamo jipi aheryvy pe yvytyruhua rehe. Ojikytikyti ga ita pyvõ herokwarokwavame ojihe. A'ereki anhag̃a opojyka ga ojive. ");
INSERT INTO pahNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Jesus'ga repiagame irupe kiro ga ruri onhana itaruvihavuhua kwaruhua pytera hugwi ga rovatiamo. Igwete ga renypy'andurugi Jesus'ga pyri nderuvihavuhu nde javo. ");
INSERT INTO pahNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Igwete Jesus'ga ei anhag̃a pe: —Ejipe'a ga hugwi. Igwete ga hapukajahivi. —Tajiavykyi ti, Jesus, ei ga. Nde ko Tupana'ga ra'yramo huvihavuhu'g̃ahoheve'ga ra'yramo. Ere ti Tupana'ga renoina tahahyyme ti ji ve, ei ga ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","—Gara nderera? ei Jesus'ga ga pe. —He'yjuhu, ei ga. Poro ko jirera, ei ga. A'ereki he'yjuhuva'ea anhag̃a opojyka ga. ");
INSERT INTO pahNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Igwete i'ehetei Jesus'ga pe: —Toremondoukari ti irupe avo hugwi, e'i ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Pevo tuvi ojipe'g̃a nenymbava porcos i'gwovo yvytyruhua pyri. He'yjuhu hete onhimongyavo. ");
INSERT INTO pahNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Igwete anhag̃a ei Jesus'ga pe: —Ore mondouka ti porcos pyri toropojyka ti a'ea orojive, e'i anhag̃a ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","—Hepejigwovo a'ero, ei Jesus'ga jupe. Igwete anhag̃a jipe'ai g̃wembipojykahara'ga hugwi ogwoogwovo porcos ipojykavo. He'yjuhu ranuhũ porcos dois mil. Igwete anhag̃a opojykarame porcos inhainhani ogwovo ojyva yvyty'ramuhũa rupi opoa ypiahua pype otypyvypyvyga. ");
INSERT INTO pahNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Igwete porcos repiakatuhara'g̃a nhani ogwovo timombe'u javo. Igwete g̃a imombe'umbe'ui porcos typyvygagwera cidadepeve'g̃a pe cidadekotyive'g̃a pe no. A'ero g̃a ndug̃anduri torohepia katu javo. ");
INSERT INTO pahNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Urame Jesus'ga pyri g̃a akoja'ga repiagi anhag̃a rembipojykaagwera'ga. Ipikatu ga kiro oina. Gweaporog̃ita katu reki ga a'ero no. Ga repiagame g̃a kyhyji Jesus'ga popoakara hugwi. ");
INSERT INTO pahNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Kiroki g̃a gwepia tuhẽ anhag̃a mondoagwera – kiro g̃a ei imombe'gwovo g̃a pe: —Jesus'ga ombojipe'a ga hugwi anhag̃a mondovouka porcos pyri a'ea pojykauka, ei g̃a. Igwete porcos inhainhambavi ogwovo y pe otypyvypyvyga, ei g̃a imombe'gwovo g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Igwete g̃a epavi Jesus'ga pe: —Heregwovo oregwyra hugwi! ei g̃a javo ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Jesus'ga avame yhara pype kiro anhag̃a rembipojykaagwera'ga ehetei ga pe: —Kiro ji hoi nde rupi nde rerekovo. ");
INSERT INTO pahNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","—Ndorogwerohoi ji ji rupi, ei Jesus'ga ga pe. Heregwovo enhonga pe. Ere ti eje'yja'g̃a pe: “Tupana'ga pyry hete ji ve,” ere ti g̃a pe. “Nahanahã ga imombyryvi ji ve ji porogwetyga,” ere ti imombe'gwovo g̃a pe, ei Jesus'ga ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Igwete ga hoi Dez Cidades pe imombe'gwombe'gwovo g̃a pe. —Jesus'ga pyry hete ji ve, ei ga g̃a pe. Ombojipe'a ga anhag̃a mondovouka ji hugwi. Nahã ga imombyryvi ji ve, ei ga g̃a pe. Igwete g̃a nhimomby'apavi ganhi'ig̃a renduva. ");
INSERT INTO pahNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Igwete Jesus'g̃a hero'yahava'javi yhara herojivya. Ypiahua rembe'yi pe ga rekoi. Igwete he'yjuhuve'g̃a jatykai ga pyri. ");
INSERT INTO pahNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Igwete ga ruri Jairo'ga. Ga ko huvihavamo oko judeus'g̃a jatykahava pype. Jesus'ga repiagame ga ruri g̃wenypy'anduruga ga pyri jihoheva'ero ji poko javo ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","—Omano g̃werĩ jira'yrahẽa, ei ga Jesus'ga pe. Herejo ji rupi epokoga hẽa rehe tomanoyme ti hẽa, ei Jairo'ga ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Igwete Jesus'ga hoi ga rupi. He'yjuhuve'g̃a oho Jesus'ga rupi no ga mbotymbotyvahiva. ");
INSERT INTO pahNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ga horame kiro ojipehẽa hoi Jesus'ga reviri opokoga gapira rehe topi ti nhitetirũa ji hugwi javo. A'ereki hẽa gwyporo. He'yjuhu doze kwara hẽatetirũa rehe. ");
INSERT INTO pahNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","He'yjuhu hẽapohanohara'g̃a novĩa. Igwete hẽa pohanog̃ame hahyhetero hẽa pe. Omondo pa hẽa oitambere'ia g̃a pe novĩa. Emo ndopigi hẽa hugwi. Igwaigwavete hẽa tetirũahetero. ");
INSERT INTO pahNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Igwete g̃a Jesus'ga mombe'urame hẽa ei oyvyteri pe: “Po ti ji pokogi gapira rehe vehevi nehẽ, a'ero po ti ipigi ji hugwi nehẽ,” ei hẽa oyvyteri pe javo. Kiro hẽa hoi Jesus'ga reviri a'ero he'yjuhuve'g̃a pytera rupi opokoga Jesus'ga pira rehe. ");
INSERT INTO pahNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Kotihĩ hẽa ndagwypora'javi. A'ea hẽa ikwahavi oyvyteri pe. ");
INSERT INTO pahNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Igwete Jesus'ga pyryrymi he'yjuhuve'g̃a koty javo g̃a pe. A'ereki ga okwahavipe opopoakara hoa g̃a ndehe. —Ma'g̃a opoko jipira rehe ra'e? ei ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Igwete garemimbo'ehara'g̃a ei ga pe: —Avi nde erehepia pa g̃a enhimbotymbotyvahiva, ei g̃a. Maraname nde euhui naerũ: “Ma'g̃a opoko ji rehe ra'e?” ei g̃a ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Emo Jesus'ga oharekoreko g̃a ndehe tahepia tuhẽ javo. ");
INSERT INTO pahNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Hẽa okwaha Jesus'ga rembiapoa ojive. A'ero hẽa ruri okyhyjiavo ohyhyipava. Ojovapyvo hẽa rekoi Jesus'ga pyri onhimombe'upava ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Igwete ga ei hẽa pe: —Kui'i, nde erejiko ji rehe. Nurã ipigi nde hugwi, ei ga. Enog̃atu ti epy'a egwovo, ei ga. Momina tuhẽ nde hugwi netetirũa, ei ga hẽa pe. ");
INSERT INTO pahNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Jesus'ga nhi'ig̃ame kiro g̃a nduri Jairo'ga rongapypeve'g̃a. Igwete g̃a ei Jairo'ga pe: —Omano jipe ndera'yrava'ea, ei g̃a imombe'gwovo ga pe. Tererura'javi ahembo'ehara'ga a'ero, ei g̃a Jairo'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Jesus'ga ombogwavete reki g̃anhi'ig̃a. Igwete ga ei Jairo'ga pe: —Teremomyi ti epy'a. Ejiko hete ji rehe, ei Jesus'ga ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Igwete Jesus'ga g̃a nderohoi ojupi Pedro'ga João'ga no Tiagova'ea no – kiroki ahe João'ga reki'yramo. Jara'g̃a ga nomondoukari ojupi. ");
INSERT INTO pahNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Igwete ga Pedro'g̃a nderohoi g̃a nderovahema Jairo'ga ronga pe. A'ero Jesus'ga henduvi g̃ajehe'oranuhũa. A'ereki hahyahi g̃ajehe'oa hẽamanoa rehe. ");
INSERT INTO pahNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Igwete ga hoi onga pe javo g̃a pe. —Maranuhũrame pe nanuhũ pejehe'gwoe'gwovo pejijupa? ei Jesus'ga g̃a pe. Tayrihẽa nomanoi. Hẽa oki reki upa, ei ga g̃a pe. A'ereki ga okwaha hẽambogweravag̃wama. ");
INSERT INTO pahNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Igwete g̃a ga jai omano tuhẽ ahe javo. A'ero ga g̃a mo'emo'embavi onga hugwi. Igwete ga g̃a nderohoi okipe tayrihẽa ruva'ga hẽayhẽa no. Pedro'g̃a ga gweroho hẽanongava pype no. ");
INSERT INTO pahNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Igwete ga hẽa popyhygi javo hẽa pe. —Talitá cumi! ei ga. (A'ea ko: “Kui'i, epo'ã!”) ");
INSERT INTO pahNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Kotihĩ hẽa po'ami a'ero okovo. Doze kwara hẽa rehe. Igwete g̃a nhimomby'ahetei hẽa repiaga. ");
INSERT INTO pahNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Igwete Jesus'ga ehetei g̃a pe: —Tapemombe'ui ti nhiremimbogweravahẽa, ei ga. Pemondo ti kiro mbatera hẽa pe to'u hẽa, ei ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Aerẽ Jesus'ga hoi pea hugwi g̃wemimbo'ehara'g̃a pavẽi. Igwete g̃a hoi cidade de Nazaré pe – perope Jesus'ga onhimomboaka. ");
INSERT INTO pahNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Judeus'g̃a poravykye'yma rupi sábado rupi ga hoi g̃ajatykahava pype pevove'g̃a mbo'eavo Tupana'ga nhi'ig̃a rehe. Igwete g̃a nhimomby'ai ganhi'ig̃a renduva onhimongyavo. A'ero g̃a ei ojohupe: —Marã akoja'ga ikwahavuhui nanongara naerũ? ei g̃a. Ma'g̃a ombo'e ga? A'ereki ahemonhimomby'ava'ea ga oapoapouhu, ei g̃a ojohupe. ");
INSERT INTO pahNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Ga ko onga apohara'ga rũi naerũ Mariahẽa ra'yra'ga? ei g̃a. Tikwaha tuhẽ nhande gareki'yra'g̃a Tiago'ga José'ga no Judas'ga Simão'ga. Garendyra'g̃a ko oko avo nhande pyri no, ei g̃a ojohupe. Igwete g̃a nhimonha'ngai okoe'yma ga rehe tihenduva'javyme ga javo. ");
INSERT INTO pahNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Igwete Jesus'ga ei g̃a pe: —Ojipe'g̃a gwyripeve'g̃a omondo gweaporog̃ita imohina Tupana'ga nhi'ig̃a mombe'uhara'ga rehe, ei ga. Gagwyripeve'g̃a jate nomondoi imohina ga rehe. Gare'yja'g̃a nomondoi imohina ga rehe no. Garongapypeve'g̃a nomondoi imohina ga rehe no, ei ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Igwete Jesus'ga ndoapoi gwerevi ahemonhimomby'ava'ea pevo. A'ereki g̃a ndojikogi ga rehe. Mokonheteve'g̃a ndehe jate ga pokogi imombiga g̃atetirũa g̃a hugwi. ");
INSERT INTO pahNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Igwete ga nhimomby'ai g̃a jikoge'yma g̃waramo ojihe. Igwete Jesus'g̃a imbojoapiapi ogwovo cidades pe pevove'g̃a mbo'eavo. ");
INSERT INTO pahNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Igwete ga g̃wemimbo'ehara'g̃a mbuhurukari ojipyri dozeve'g̃a. Igwete ga ei g̃a pe: —Topomondomondo ti kiro ojipe'g̃a cidades pe, ei ga. Mokomokõi ti pejogweroho imombe'gwovo Tupana'ga nhi'ig̃a g̃a pe. Ape'akwahavuka ti ji pe me anhag̃a g̃a hugwi nehẽ, ei ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Pepojate ti toho kiro pea rupi. Taperohoi ti pão itambere'ia reheve, ei ga. Taperohoi ti sacola no. Pejijihokava jate ti peroho, ei ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Pemongi ti sandálias. Taperohoi ti ojipea tapy'ynhapira, ei ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Igwete ga ei no: —Pe vahemame cidade pe po ti ojipe'ga ei pe me nehẽ: “Hepejijo pejipytavo nhironga pe,” e po ti ga pe me nehẽ. Pejogweroho ti ga pyri pejijupa a'ero, ei Jesus'ga g̃a pe. Tapejijyjijyi ti ojipe'g̃a nonga pe, ei ga. Ga pyri jate ti peju. Aerẽ ti pea hugwi pe hoi cidade hugwi a'ero pejogwerogwovo nehẽ, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Po ti pevove'g̃a napembuhurukari ojipyri hendupotare'yma penhi'ig̃a a'ero po ti pe hojipei pea hugwi nehẽ, ei ga. Pehorame ti pemonduru otimbuguhua pejipya hugwi toropohi ti pe hugwi javo g̃a pe. Pe'ji ti g̃a pe: “Peko te'varuhu pe hendupotare'yma Tupana'ga nhi'ig̃a,” pe'ji ti g̃a pe, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Nahã Jesus'ga dozeve'g̃a mondomondoukari ojipe'g̃a pyri. Igwete g̃a hoi imombe'gwovo Tupana'ga nhi'ig̃a g̃a pe. Igwete g̃a ei g̃a pe: —Perojijyi ti pejeaporog̃ita pejipohia pejikote'varuhua hugwi, ei g̃a g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Igwete dozeve'g̃a imbojipe'ape'ai anhag̃a Diabo'gapyriva'ea ojipe'g̃a hugwi. Igwete g̃a imongyi ikava he'yjuhuve'g̃a akag̃a rehe imombiga g̃atetirũa g̃a hugwi. ");
INSERT INTO pahNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Igwete pevove'g̃a Jesus'ga mombe'umbe'ui. A'ero ga henduvi g̃anhi'ig̃a Herodes'ga g̃anduvihavuhu'ga. Ojipe'g̃a e'i tehe Jesus'ga mombe'gwovo: —Ga ko João Batista'ga reki, e'i tehe ga. Okwera po ga kiro oyvya hugwi. Nurã po ga japohetei ahemonhimomby'ava'ea naerũ, e'i tehe g̃a. ");
INSERT INTO pahNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ojipe'g̃a e'i tehe: —Jesus'ga po Elias'ga ura'java. Ojipe'g̃a: —Ga po Tupana'ga nhi'ig̃a mombe'uharamo oko ahe ja – kiroki ahe omombe'u Tupana'ga nhi'ig̃a ojopy'rovo hako, e'i tehe g̃a. ");
INSERT INTO pahNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Igwete Herodes'ga henduvi g̃anhi'ig̃a Jesus'ga rehe. Igwete ga etehei: —Ga ko João Batista'ga tuhẽ. Akamomboruka ji ga ikwehe novĩa. Kiro ga kwerava'javi reki, e'i tehe ga. ");
INSERT INTO pahNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","19","Nahã Herodes'ga ahe akamomborukari raikwehe. Herodiashẽa rehe ga ahe pyhygukari ahe mongiuka cadeia pype. Hehã ko Filipe'ga rembirekohẽa na'ẽ Herodes'ga reki'yra'ga rembirekohẽa. Aerẽ Herodes'ga hẽa rerekoi reki. Igwete João Batistava'ea ei Herodes'ga pe jipi: “Maranuhũrame nde eirũ'ga rembirekohẽa rerekoi? Na rũi ko ahe rekoi,” ei ahe ga pe jipi. Nurã Herodiashẽa rehe Herodes'ga ahe pyhygukari ahe apytĩuka ahe mongiuka cadeia pype. A'ereki hẽa onhimboahi ahe ve tajukauka ti ga javo novĩa. ");
INSERT INTO pahNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Emo Herodes'ga ahe a'ngui na'ẽ. Ga ndojukaukapotari ahe. A'ereki ga okyhyji ikwahava Joãova'ea rekokatua. Okwaha ga Joãova'ea pyryhetea ahe rekoro g̃waramo Tupana'ga rehe. Nurã Herodes'ga ahe a'ngui. Joãova'ea nhi'inhi'ig̃ame ga pe oko tehe gapy'a novĩa. Emo ga g̃wendu pota Joãova'ea nhi'ig̃a novĩa. ");
INSERT INTO pahNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Aerẽ o'aragwera rehe Herodes'ga japoi toryva omoirũhara'g̃a pe soldados'g̃a nduvihavuhu'g̃a pe no imbateheteve'g̃a pe no – kiroki g̃a u gagwyri pe Galiléia pe. A'ea rupi Herodiashẽa jirokwari João Batistava'ea rehe ahe jukauka. ");
INSERT INTO pahNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Hẽara'yrahẽa tehe oho Herodes'g̃a pyri ojirokyavo g̃apyteri pe. Igwete g̃a nhimohẽhetei kujahẽa rehe Herodes'ga gapavẽive'g̃a pavẽi. A'ero ga ei hẽa pe: —Gara nde erepota imondoa ejive? Tamondo ti nde ve, ei ga hẽa pe. ");
INSERT INTO pahNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Tupana'ga henduvame nhirembi'ea ji ei nde ve: Tamondo pa tuhẽ ti nde ve neremimbotarimova'ea javoji. Nhimbatera ti tamondojija'ro vehevi nde ve javoji, ei ga hẽa pe. ");
INSERT INTO pahNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","A'ero hẽa hoi imombe'gwovo oyhẽa pe. —Gara re po ji aru ga hugwi nehẽ? ei hẽa hẽa pe. —João Batista'ga akag̃a pe ere, ei hẽayhẽa hẽa pe. ");
INSERT INTO pahNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Kotihĩ hẽa jivyri nhandaipe ogwovo javo Herodes'ga pe. —Apota ji João Batista'ga akag̃a, ei hẽa, kirog̃we nhaembeva pype, ei hẽa ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Henduvame hẽanhi'ig̃a Herodes'ga rekoveveuhuhetei a'ero. A'ereki ga ndojukaukapotari Joãova'ea novĩa. Emo ga e'i jipe reki Tupana'ga g̃wendu nhirembi'ea javo. Gapavẽive'g̃a g̃wendu ganhi'ig̃a no ga erame hẽa pe tamondo tuhẽ ti nde ve javo. Nurã ga nde'ia'uva'javi kiro hẽa pe: “Namondoa'javi ji nde ve.” ");
INSERT INTO pahNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Nurã ga soldado'ga mondoukari cadeia pype togweru ti ga João'ga akag̃a javo. ");
INSERT INTO pahNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Igwete soldado'ga hoi ahe akamomboa cadeia pype aheakag̃a rerua nhaembeva pype. Igwete ga imondoi kujahẽa po pe hẽa herohoi oyhẽa pe heroviaruka hẽa pe Joãova'ea jukaagwera. ");
INSERT INTO pahNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Nahã Herodes'ga ahe akamomborukari raikwehe. Ikwahavame Joãova'ea remimbo'ehara'g̃a hoi ahera'oa pyhyga herogwovo inog̃a ityma raikwehe. ");
INSERT INTO pahNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Aerẽ dozeve'g̃a jivyri Jesus'ga pyri a'ero – g̃ahã Jesus'ga omondomondouka Tupana'ga nhi'ig̃a mombe'uuka. Ojivyrame g̃a imombe'upavi Jesus'ga pe g̃wemimbo'eagwera. G̃atetirũa mombigagwera g̃a omombe'u ga pe no. —Orombojipe'a ore anhag̃a g̃a hugwi, ei g̃a imombe'gwovo ga pe no. ");
INSERT INTO pahNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","A'ea rupi he'yjuhuve'g̃a nhopondekwandekwavi ua Jesus'ga pyri onhimongyavo. Igwete g̃a ndo'uukari Jesus'g̃a pe. Nurã Jesus'ga ei dozeve'g̃a pe: —Nhande tehe ti xaho ongae'ỹi me tapepytu'uahi'vi ti javoji, ei ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Jesus'g̃a tehe g̃a avi yhara pype a'ero ogwovo ongae'ỹi me. ");
INSERT INTO pahNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Emo pevove'g̃a gwepia g̃ahoa. Igwete g̃a ei ojohupe onhimongyavo: —Kiro g̃a hoi Jesus'g̃a. Pea rupi ti xaho g̃a ndeviri a'ero, ei g̃a ojohupe. Igwete g̃a hoi nhandaipe ypiahua rembeyvyra rupi ogwovo cidades hugwi nhaporemo. Igwete g̃a na'ẽ g̃a vahemi pevo Jesus'g̃a nenonde. ");
INSERT INTO pahNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Ohemame Jesus'ga he'yjuhuve'g̃a ndepiagi. Igwete g̃a poria'iro ga pe onhimongyavo. A'ereki ga pe ko g̃a ovelhas ja ovelhas gwepiakatuhara'ga rerekoe'ymame. Na jitehe ndipokokavi g̃a. Igwete Jesus'ga g̃a mbo'embo'ei. ");
INSERT INTO pahNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Kwara hog̃werĩa rupi garemimbo'ehara'g̃a nduri ga pyri javo. —Kiro ihohetei kwara. Ndogwerekoi onga avo g̃a pe, ei g̃a. ");
INSERT INTO pahNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Ere ti g̃a pe a'ero toho ti g̃a kopeve'g̃a pyri cidades'i pe ira'agweva'e pe. Pevo po ti g̃a ipyhygi mbatera ojive i'uhavamo, ei g̃a Jesus'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Igwete ga ei g̃a pe: —Pehe ti pemondo mbatera g̃a pe to'u ti g̃a javoji. —Maranuhũ naerũ? ei g̃a. He'yjuhuva'ea duzentos itambere'ia po ti ore herohoi imondovo pão rehe g̃a pe naerũ? ei g̃a ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Igwete Jesus'ga ei g̃a pe: —Maramomi pe herekoi pães? Peho hepiaga. Igwete g̃a hoi hepiaga, g̃a nduri imombe'gwovo ga pe. —Cinco, ei g̃a. Dois g̃a gwereko pira no, ei g̃a ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Igwete Jesus'ga he'yjuhuve'g̃a mbojatykapavi g̃a mboapyga g̃a nog̃a nhungwa'via rehe. ");
INSERT INTO pahNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ojopyri g̃a apyapygi upa a'ero. Pea hovai g̃a cem. G̃a hovai cinquenta. Hovaive'g̃a cem no. Nahã g̃a apyapygi ojogwerojuva. ");
INSERT INTO pahNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Igwete Jesus'ga ipyhygi pães pira reheve. Igwete ga jovavuri onhi'ig̃a Tupana'ga pe. —Ndepyry hete nde imbuhua mbatera ore ve, ei ga Tupana'ga pe. Igwete Jesus'ga haygwe'rogwe'rogi pães imondovo g̃wemimbo'ehara'g̃a pe pema'ema'ẽ g̃a pe javo. Na jitehe ga ima'ema'ẽukari pira imondovouka g̃a pe nhaporemo. ");
INSERT INTO pahNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Igwete g̃a nhaporemo i'ui'ui onhimoytaromouka jupe. A'ereki Jesus'ga ombohe'yjuhu hete mbatera g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","44","He'yjuhu hete ko g̃a cinco mil akwaimba'ero. Kunhangwera'g̃a na jitehe he'yjuhu tayri'g̃a pavẽi. Igwete Jesus'ga remimbo'ehara'g̃a imono'ono'og̃i pães rembyruera pira'ia rembyruera reheve imondovo inog̃a yrua pype. Dozeva'ea g̃a imotynahenahembavi yrua. ");
INSERT INTO pahNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","46","Igwete Jesus'ga ei g̃wemimbo'ehara'g̃a pe: —He peji'ava yharuhua pype, ei ga. Pero'yaha ti aherovai ji renonde herogwovo cidade de Betsaida pe, ei ga g̃a pe. He'yjuhuve'g̃a pe ga ei: —Kiro ji hoi na'ẽ nhinhi'ig̃a Tupana'ga pe, ei ga. He pejigwovo a'ero pejivya penhonga pe kiro, ei ga g̃a pe. Igwete ga hoi yvytyruhua rupi. ");
INSERT INTO pahNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Ypytunimo ga tehe ga rekoi yvytyruhua arimo. Garemimbo'ehara'g̃a ki a'e te oko yhara pype ypyteri pe. ");
INSERT INTO pahNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Igwete ga hepiagi g̃a ipyvupyvurahyrame. A'ereki yvyturanuhũa g̃wovatĩvatĩ g̃a. Ko'eg̃atue'yma rupi ga hoi g̃a pyri a'ero opyrug̃a yhya rehe ogwovo. Okwa g̃werĩ ga g̃andova yvyri novĩa. ");
INSERT INTO pahNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Emo hepiagame gapyrug̃a yhya japea rehe g̃a nahenahemamo upa. —Anhag̃a po, e ko g̃a novĩa. ");
INSERT INTO pahNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","A'ereki g̃a nhaporemo gwepia ga. G̃apy'a juahi a'ero. Emo kotihĩ ga nhi'ig̃i g̃a pe. —Penog̃atu ti pejipy'a, ei ga. Jihi ko koro ako. Tapekyhyjia'javi ti, ei ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Igwete ga avi yhara pype g̃a pohe. Kiro ipigi yvyturanuhũa. Igwete g̃a nhimomby'ahetei a'ero. ");
INSERT INTO pahNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","A'ereki g̃a ndaheaporog̃itakatui pães mbohe'yjuhuagwera rehe. Noangari g̃a ikwahave'yma Jesus'ga popoakara. ");
INSERT INTO pahNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Igwete Jesus'g̃a hero'yahavi herovahema Genesarépeve'g̃a gwyri pe nhapytiamo. ");
INSERT INTO pahNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","G̃a ẽrame yhara hugwi pevove'g̃a nhimombaragwahavipei Jesus'ga rehe. ");
INSERT INTO pahNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Igwete g̃a hog̃ahoi ogwyra rupi itetirũave'g̃a nderunderua g̃akupeupava rehe g̃a nog̃a Jesus'ga pyri. Henduvame Jesus'ga hoa jipi, pevo g̃a g̃a nderuri ga pyri. ");
INSERT INTO pahNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Igwete ga imbojoapiapi ogwovo cidades pe. Nhu me ga hogahoi no. Perope ga oho – pevo nhaporemo g̃a itetirũave'g̃a nderuri g̃a nog̃a mytu'ẽ me – perope g̃a ojatyka jipi. Igwete g̃a eg̃a'ei Jesus'ga pe: —Na g̃a pokogi ndepira rembe'yva rehe vehevi. G̃a pokogame hehe a'ero ipipavi g̃atetirũa g̃a hugwi. ");
INSERT INTO pahNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Igwete fariseus'g̃a jatykai ua Jesus'ga pyri judeus'g̃a mbo'ehara'g̃a pavẽi. Uhu g̃a ga pyri Jerusalém hugwi. ");
INSERT INTO pahNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Igwete g̃a hepiagi Jesus'ga remimbo'ehara'g̃a jikwakuve'yma. —Ndokoi g̃a nhaneramonhava'ea remimbo'eagwera rupi, ei g̃a. A'ereki g̃a ndojikwakuvi ojipogweja rehe mbatera ua renonde, ei g̃a ojohupe. ");
INSERT INTO pahNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","A'ereki judeus'g̃a namonhava'ea koi na ojikwaku ymya vehevi. I'ua renonde ahe jipogwepogwei jipi. A'ereki ahe e'i tehe: “Nhandejipogwepogweje'ymame po ti nhande nianhimombyryvi Tupana'ga pe,” e'i tehe ahe. Nurã ko judeus'g̃a – kiroki g̃a fariseusramo – g̃a ko koji'i e'i: “Xajikwaku hete nhandekovo nhaneramonhava'ea remimbo'eagwera rehe,” e ko g̃a. Nurã g̃a ojipogweje'ymame ndo'ui mbatera jipi. ");
INSERT INTO pahNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Herurame mbatera ima'ẽhava hugwi na jitehe g̃a ndo'ui ojipogweje'ymame. I'uhava g̃a ipyhepyhei imboapykava. Nahã g̃a jikwakukwakuvi jipi g̃wamonhava'ea remimbo'eagwera rehe okovo xanhimombyry ti Tupana'ga pe javo novĩa. ");
INSERT INTO pahNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Igwete fariseus'g̃a jatykai Jesus'ga pyri judeus'g̃a mbo'ehara'g̃a pavẽi. A'ero g̃a hepiagi Jesus'ga remimbo'ehara'g̃a jikwakuve'yma. Igwete g̃a ei Jesus'ga pe: —Neremimbo'ehara'g̃a ndojipogwejuhu i'ua renonde, ei g̃a. Maraname g̃a ndokoi nhaneramonhava'ea remimbo'eagwera rupi ojikwakuve'yma? ei g̃a. ");
INSERT INTO pahNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","8","Nahã Jesus'ga ei javo g̃a pe a'ero: —Pehe ko pekokatu'ãva'ero peko! ei ga. Penhi'ĩpo'ru hete pe Isaíasva'ea kiro. Ymya Isaíasva'ea okwatija Tupana'ga nhi'ig̃a ahe mombe'gwovo hako, ei Jesus'ga. Nahã Tupana'ga ei hako: “Avove'g̃a onhi'ig̃atu tehe torombohete Tupana'ga javo,” ei ga. “Emo g̃a nanhiarõi imondoe'yma gweaporog̃ita imohina ji rehe,” ei Tupana'ga hako, ei ga. “Ji mbohete tehe g̃a. A'ereki nhinhi'ig̃a rehe rũi g̃a ombo'e,” ei ga. “Yvyakotyve'g̃a nemimbo'etehea rehe g̃a g̃a mbo'ei a'ea ko Tupana'ga nhi'ig̃a javo tehe jupe,” ei Tupana'ga hako. Nahã Isaíasva'ea ikwatijari ahe mombe'gwovo hako, ei Jesus'ga g̃a pe. Igwete ga ei g̃a pe a'ero: —Ahemombe'ua ko pemombe'uag̃wama reki. A'ereki ahe javijitehe ko pe peko pekokatu'ag̃uhũva'ero. Pemoandyandyi pe ojipe'g̃a jipi orombohete Tupana'ga javo tehe, ei Jesus'ga g̃a pe. Pepohi reki pe Tupana'ga nhi'ig̃a hugwi. Emo yvyakotyve'g̃a nemimbo'eagwera pe pehendu katu, ei ga. ");
INSERT INTO pahNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","—Pyry hete reki pe me pe imbogwavame Tupana'ga nhi'ig̃a xako ti nhaneremimbo'eagwera rehe javo, ei ga onhi'ig̃ahyavo g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Moisésva'ea okwatija Tupana'ga nhi'ig̃a imombe'ukatuavo hako, ei ga g̃a pe. Igwete ahe ei: “Pemondo ti pejeaporog̃ita imohina pejuva'ga rehe penhyhẽa rehe no,” ei ahe. Igwete ahe ei no ikwatijarame Tupana'ga nhi'ig̃a: “Kiroki ga e'i te'varuhu uva'ga pe oyhẽa pe no – tojukauka ti g̃a ga a'ero,” ei Moisésva'ea hako, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Pe ki a'e te ahe atyvi g̃a mbo'ei, ei Jesus'ga. Pepyteripeve'ga po e'i uva'ga pe oyhẽa pe no: “Opopoko pota ji imondovo mbatera pe me novĩa. Emo ji amondo reki akoja Tupana'ga pe,” e po ga, ei ga. ");
INSERT INTO pahNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Ga erame a'ea g̃a pe pe'ji tehe reki pe: “Pyry ga nomondoi mbatera uva'g̃a pe a'ero,” pe'ji tehe pe, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Nahã ko pe g̃a mbo'ei hendukatuuka g̃a pe penamonhava'ea remimbo'eagwera hendukatuukare'yma g̃a pe Tupana'ga nhi'ig̃agwera, ei ga. Nahanahã pe ndekouhui jipi, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","A'ero Jesus'ga he'yjuhuve'g̃a mbuhurukara'javi ojipyri imombe'gwovo ojo'java'ea g̃a pe. —Pe me nhaporemo ji ei: Pehendu ti ikwahava, ei ga. ");
INSERT INTO pahNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Mytu'emahugwiva'ea – kiroki mbatera ahe o'u jipi – a'ea okirame ahe pype nahembote'varuhui. Aheyvyterahugwiva'ea ki a'e te ahe mbote'varuhu, ei ga. ");
INSERT INTO pahNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Peapyakwa pe. Pehendu katu ti ji'ea a'ero, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Igwete Jesus'ga hoi onga pe g̃a hugwi. Igwete garemimbo'ehara'g̃a hoi javo ga pe. —Gara pe nde ei ojo'java'ea mombe'gwovo? ei g̃a ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","19","Igwete ga ei g̃a pe: —Jara'g̃a ja pe ndapekwahavi naerũ? ei ga. A'ereki mytu'emahugwiva'ea aherembi'ua nahembote'varuhui tuhẽ. A'ereki a'ea nombote'varuhui ahereaporog̃ita. Ndapekwahavi pe a'ea naerũ? ei ga g̃a pe. Aherembi'ua oho aherevegi pe. Kirẽ ko ahe imbo'apavi ojihugwi, ei ga. Aherembi'ua nahembote'varuhui tuhẽ a'ero, ei Jesus'ga g̃a pe. O'erame a'ea ga ei pe'u pa ti mbatera a'ero javo. ");
INSERT INTO pahNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Igwete Jesus'ga ei g̃a pe no: —Peyvyterahugwiva'ea reki ko pe mbote'varuhu. ");
INSERT INTO pahNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","A'ereki peyvyteri pe pendeaporog̃ita te'varuhu, ei ga. Pejeaporog̃itate'varuhurame ko pe ojipe'g̃a nderekoreko'ihu. Pemi pe ojipe'g̃a mbatera. Peporojuka pe, ei ga. Ojipe'g̃a nembireko'g̃a pavẽi pe peko. ");
INSERT INTO pahNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Pepotaruhu pe ojipe'g̃a mbatera. Peko te'varuhu pe, ei ga g̃a pe. Pemoandyandyi pe ojipe'g̃a. Peakwahavihu pe. Penhimyrõ pe ojipe'g̃a ndehe, ei ga. Pembotegwete pe ojipe'g̃a. Penhimbohete pe. Pearuivehũ pe, ei ga. ");
INSERT INTO pahNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Nanongara nhaporemo pendekote'varuhuva'ea ko peyvyterahugwiva'ea. A'ea reki pe mbote'varuhu, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Igwete pea hugwi Jesus'ga hoi cidade de Tiro koty. Igwete ga ki onga pe tokwahavyme ti g̃a jiruva avo javo novĩa. Emo g̃a okwaha reki. ");
INSERT INTO pahNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Igwete hẽa ruripei Jesus'ga pyri. A'ereki pevove'g̃a omombe'u ga hẽa pe. Hẽara'yrahẽa anhag̃a opojyka ojive. Nurã hẽa ruri g̃wenypy'anduruga Jesus'ga pyri jihoheva'ero ji poko javo. Hẽa ko judeu rũi reki. A'ereki hẽa siro-feníciapeve'g̃a gwyripevehẽa. Nanongara'g̃a – g̃a ko judeus'g̃a rũi – judeus'g̃a e'i nhag̃watig̃a g̃a pe okoe'yma g̃a ndehe. Igwete hẽa ruri javo Jesus'ga pe: —Embojipe'a ti anhag̃a jira'yrahẽa hugwi, ei hẽa ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Igwete Jesus'ga ei hẽa pe: —Ndapyryvi ji nde pokoga. A'ereki nde judeu rũi, ei ga. Ndapyryvi ahe ipyhygi tayri'g̃a nembi'ua imomboa nhag̃watig̃a pe, ei ga. Tayri'g̃a ypy o'u, ei ga hẽa pe. ");
INSERT INTO pahNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","—Na tuhẽ, ei hẽa. Emo nhag̃watig̃a vehevi turi mesa gwyri i'gwovo hembyrue'ria tayri'g̃a nembi'ua ndurugagwera, ei hẽa. Nurã nhag̃watig̃a javijitehe ji ruri nde pyri ji poko javo. ");
INSERT INTO pahNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","—Ji nhi'ĩkwepy katu nde, ei Jesus'ga hẽa pe. Nurã heregwovo enhonga pe kiro a'ero, ei ga. A'ereki anhag̃a ojipe'a reki ndera'yrahẽa hugwi, ei ga hẽa pe. ");
INSERT INTO pahNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Igwete hẽa jivyri onga pe tayrihẽa repiaga. Anhag̃a ojipe'a tuhẽ hẽa hugwi. A'ero hẽa nhinog̃atui upa opiro'yro jugwi. ");
INSERT INTO pahNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Igwete Jesus'g̃a jivyri cidade de Tiro hugwi ogwovo. Igwete g̃a hoi okwava cidade de Sidom rupi Dez Cidades mbytembytera rupi no. Igwete g̃a hoi ypiahua pyri Galiléiapeve'g̃a gwyri pe. ");
INSERT INTO pahNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Igwete pevove'g̃a ga reruri Jesus'ga pyri ndiapyakwarive'ga. Nhi'indy'ndyguhu ga. Igwete g̃a ei Jesus'ga pe: —Epoko ga rehe hendukatuuka ga pe ga monhi'ig̃atuavo. ");
INSERT INTO pahNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","A'ero Jesus'ga ga rerohoi he'yjuhuve'g̃a hugwi opũa mondovo gapyakwari pe. Igwete ga nyvuni opokoga gakũa rehe. ");
INSERT INTO pahNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Gwovavuramo Jesus'ga pytuhemamo. Igwete ga ei ga pe: —Efatá! ei ga. (A'ea ko: “Pepe'a, gapyakwara!”) ");
INSERT INTO pahNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","A'ero gapyakwara jipe'ai. Gakũa pyryva'javamo no. Igwete ga nhi'ig̃atui reki a'ero. ");
INSERT INTO pahNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Igwete Jesus'ga ei g̃a pe: —Tapemombe'ui ti a'ea ojipe'g̃a pe, ei ga g̃a pe novĩa. Emo g̃a omombe'u reki. Igwaigwavete ga ei g̃a pe tapemombe'ui ti javo novĩa. Emo igwaigwavete g̃a oho imombe'gwombe'gwovo reki. ");
INSERT INTO pahNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Igwete g̃a nhimomby'ahetei. —Okwaha pa hete ga g̃a nderekokatuavo, ei g̃a. Ndiapyakwarive'g̃a pe ga g̃wendukatuuka reki. Onhi'ig̃e'ỹve'g̃a ga g̃a monhi'ig̃atu no. ");
INSERT INTO pahNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Aerẽ he'yjuhuve'g̃a jatykaa'javi Jesus'ga pyri. Mominame g̃a hugwi mbatera i'uhavamo Jesus'ga g̃wemimbo'ehara'g̃a mbuhurukari ojipyri. Igwete ga ei g̃a pe: ");
INSERT INTO pahNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","—Iporia'i g̃a ji ve onhimongyavo, ei ga. A'ereki mokõi g̃a kiri ji pyri. Kiro momina mbatera g̃a hugwi a'ero, ei ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Po ti ji g̃a mondoukari g̃anonga pe g̃a mbatera ue'ymame, a'ero po ti g̃a pytupavahivuhuro ogwovo pea rupi nehẽ. A'ereki jara'g̃a nonga paivohu, ei ga g̃wemimbo'ehara'g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Igwete g̃a ei ga pe: —Maranuhũ po ti nhande ipyhygi pães g̃a pe avo ongae'ỹi me nehẽ? ei g̃a. ");
INSERT INTO pahNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Igwete ga ei g̃a pe: —Maramomi pe herekoi pães? ei ga g̃a pe. —Sete ore herekoi, ei g̃a. ");
INSERT INTO pahNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Igwete Jesus'ga g̃a mboapypavi g̃a nog̃a yvyvo. Igwete ga ipyhygi pães seteva'ea. Igwete ga nhi'ig̃i Tupana'ga pe ndepyry hete nde imbuhua ore ve javo ga pe. Igwete Jesus'ga haygwe'rogwe'rogi imondomondovo g̃wemimbo'ehara'g̃a pe. —Pema'ema'ẽ kiro he'yjuhuve'g̃a pe to'u g̃a, ei ga g̃a pe. A'ero g̃a ima'ema'ẽi g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Mokoi'ĩ te g̃a herekoi pira'ia no. Igwete Jesus'ga nhi'ig̃i Tupana'ga pe ndepyry hete nde pira mbuhua ore ve javo. Igwete ga ei g̃wemimbo'ehara'g̃a pe: —Pema'ema'ẽ pira'ia g̃a pe no. ");
INSERT INTO pahNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","9","G̃a ima'ẽrame g̃a nhaporemo i'ui a'ero onhimoytaromouka jupe. A'ereki Jesus'ga ombohe'yjuhu mbatera g̃a pe nhaporemo. He'yjuhu ko g̃a – kiroki g̃a o'u – quatro milve'g̃a. Aerẽ garemimbo'ehara'g̃a imono'ono'og̃i haygweygwera rembyruera imondovo inog̃a yrua pype. Seteva'ea g̃a imotynahenahembavi a'ero. Aerẽ Jesus'ga g̃a mondoukari g̃anonga pe. ");
INSERT INTO pahNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Igwete ga g̃wemimbo'ehara'g̃a ndero'avi yhara pype g̃a nderogwovo Dalmanutapeve'g̃a gwyri pe g̃a nderovahema. ");
INSERT INTO pahNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Igwete fariseus'g̃a nduri onhi'ig̃ayva Jesus'ga pe. —Timbopoyjayjaryme ti nhande ga ga ikwahave'ymame, ei g̃a ojohupe. Igwete g̃a ei Jesus'ga pe: —Eapo ti ore ve ahemonhimomby'ava'ea Tupana'ga popoakara repiuka ore ve, ei g̃a ga pe. A'ero po ti ore nde reroviari nehẽ Tupana'ga ga mbuhuruka tuhẽ javo nehẽ, e'i tehe g̃a ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Igwete Jesus'ga pytuhemamo upa okoveveuhuro. —Maranuhũrame ag̃wamove'g̃a hepiapotaruhui ahemonhimomby'ava'ea? ei ga. Tamombe'u katu ji pe me: Ndahepiukari tuhẽ po ti ji nhimbuhurukara kwahavuka ag̃wamove'g̃a pe! ei ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","A'ero Jesus'ga hoi fariseus'g̃a hugwi. Igwete ga g̃wemimbo'ehara'g̃a ndero'avi yhara pype g̃a nderogwovo xaho aherovai javo. ");
INSERT INTO pahNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Garemimbo'ehara'g̃a ndogwerohoi pão imoka'nhyma. Ojipeji jate g̃a gwereko yhara pype. ");
INSERT INTO pahNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Igwete yhara pype Jesus'ga imomoranduvi g̃a pe. —Penhimboko'i ti pão mbovuhava rehe fariseus'g̃a apoa rehe Herodes'g̃a apoa rehe no, ei ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","A'ero g̃a nhi'ig̃i ojohupe. —Maraname ga ei pão mbovuhava pe? ei g̃a. Ndirekoi nhande pão nhandejupi. Nurã po ga ei poro, e'i tehe g̃a ojohupe. Ndokwahavi g̃a Jesus'ga rembi'ea. A'ereki g̃wemimbo'eaatyviva'ea pe ga ei fariseus'g̃a nemimbo'ea pe. Herodes'g̃a nemimbo'ea pe ga ei no a'ea ikwahy hete imbovuhava javijitehe javo. ");
INSERT INTO pahNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Jesus'ga okwaha g̃anhi'ig̃a ojohupe. A'ero ga ei g̃a pe: —Maranuhũrame pe nhi'ig̃i pão rerekoe'yma rehe? ei ga. Ndapekwahavi ve pe jipopoakara naerũ? Napeangari pe? ei ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Pendeakwa pe novĩa. Ndapehepiagi pe ikwahava naerũ? ei ga. Peapyakwa pe novĩa. Napehendukatui pe naerũ? Pemoka'nhy pe a'ero nhirembiapoagwera pães mbohe'yjuhuagwera? ei ga. ");
INSERT INTO pahNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Cincova'ea ji ahaygwe'rogwe'ro pães ima'eamouka cinco milve'g̃a pe ikwehe, ei ga. Aerẽ pe imono'ono'og̃i haygwera yrua imotynahema. Maramomi pe imotynahemi yrua naerũ? ei ga g̃a pe. —Dozeva'ea ore imotynahenahemi ikwehe, ei g̃a ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Igwete ga ei: —Aerẽ seteva'ea ji haygwe'rogwe'rogi pães ima'eamouka quatro milve'g̃a pe oji'i, ei ga. Maramomi pe imotynahenahemi yrua haygwera imondovo ipype? ei ga g̃a pe. —Seteva'ea ore imotynahemi oji'i, ei g̃a ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Igwete ga ei g̃a pe: —Pe ndapekwahavi ve naerũ? ei ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Igwete Jesus'g̃a heruri herovahema cidade de Betsaida pe. Igwete pevove'g̃a hehae'ỹve'ga reruri ga pyri. —Epoko ti ga rehe ga mbohehakatuavo, ei g̃a ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Igwete Jesus'ga hoi ga popyhyga ga rerogwovo cidade hugwi. A'ero Jesus'ga nyvuni gareakwari pe ga pokogi hehe. Igwete ga ei: —Erehepia nde mo? ei ga ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Igwete ga ma'ẽi. —Ahepia ji g̃a novĩa, ei ga. Yva ja ko g̃a. Emo g̃a ohooho ogwovo, ei ga Jesus'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","A'ero Jesus'ga pokoga'javi gareakwara rehe. Igwete ga hepiahetei gwehakaturamo. ");
INSERT INTO pahNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","A'ero Jesus'ga ei ga pe: —Eho enhonga pe kiro. Terehoi ti imombe'gwovo enhimbohehaagwera cidadepeve'g̃a pe, ei ga. ");
INSERT INTO pahNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Igwete Jesus'ga hoi g̃wemimbo'ehara'g̃a pavẽi imbojoapiapiavo ogwovo cidades pe – kiroki cidades ira'agwe cidade de Cesaréia de Filipe hugwi. Pea rupi g̃a horame ga ei g̃a pe: —Marãi g̃a ji ve jipi? ei ga. ");
INSERT INTO pahNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","—“Ga ko João Batista'ga,” ei g̃a nde ve, ei g̃a. Jara'g̃a e'i: “Ga ko Elias'ga.” Jara'g̃a e'i nde ve: “Ga ko Tupana'ga nhi'ig̃a mombe'uharava'ea ahepyteripeve'ga – kiroki ahe Tupana'ga nhi'ig̃a omombe'u ojopy'rovo hako. Okwera ga kiro omanoa hugwi,” ei g̃a nde ve, ei g̃a Jesus'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","—Oro pe, ei ga g̃a pe, marãi pe ji ve a'ero? Igwete Pedro'ga ei ga pe: —Nde ko Cristoramo ereko Tupana'ga remimbuhurukaramo, ei ga. ");
INSERT INTO pahNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Igwete Jesus'ga ei g̃a pe: —Teremombe'ui ti a'ea ojipe'g̃a pe, ei ga. ");
INSERT INTO pahNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Igwete Jesus'ga g̃a mbo'embo'ei. —Tupana'ga ji mbuhuruka avo teremano ti javo ji ve, ei ga. Ndokoi po ti g̃a ji rehe nehẽ xava'eve'g̃a ahembo'ehara'g̃a pavẽi. Mbatera kwava'ẽhara'g̃a nduvihava'g̃a po ti ndokoi ji rehe nehẽ no, ei ga g̃a pe. He'yjuhuva'ea po ti g̃a imbuhurukari hahyva'ea ji ve nehẽ. Igwete po ti g̃a ji jukaukari nehẽ. Mokõi pe kirirẽ po ti ji kwerava'javi nehẽ, ei ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Jesus'ga omombe'u katu g̃a pe okoag̃wama. Igwete Pedro'ga ga rerohoi'i onhi'ig̃ahyavo ga pe. —Na rũi po ti nde reaporog̃itaro hamo, ei ga Jesus'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Emo Jesus'ga opyryrỹ g̃wemimbo'ehara'g̃a ndepiaga onhi'ig̃ahyavo Pedro'ga pe. —Ejipe'a ti ji hugwi, ei ga. A'ereki Satanás'ga nde monhi'ĩ poro. Tupana'ga opota reki nhimanoa, ei ga. Nde nderekoi Tupana'ga reaporog̃ita rehe. Yvyakotyve'g̃a ndeaporog̃ita rehe nde ereko, ei ga Pedro'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Igwete Jesus'ga g̃a mbuhurukari ojipyri g̃wemimbo'ehara'g̃a he'yjuhuve'g̃a pavẽi. Igwete ga ei g̃a pe: —Pe ndekopotarame nhiremimbo'eharamo pepohi ti penhimimbotarimova'ea hugwi tako ti Jesus'ga remimbotarimova'ea rupi javo, ei ga. Po ti g̃a imbohahyukari pe me pe jukavo vehevi nehẽ jireheva'ero pejikovo g̃waramo nehẽ, peko jitehe ti nhiremimbotarimova'ea rupi pejipohire'yma ji hugwi. Peko tuhẽ ti nhinhi'ig̃a rupi, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Igwete ga ei no: —Po ti g̃a pe jukai jireheva'ero g̃waramo, a'ero po ti pe ndekoi Tupana'ga pyri avuirama nehẽ. Po ti g̃a pe jukai ji mombe'uro g̃waramo, a'ero po ti pe ndekoi Tupana'ga pyri pejikovo nehẽ, ei ga g̃a pe. Po ti pe ei: “Ndakoi po ti ji Jesus'ga remimbo'eharamo tajijukayme ti g̃a”, a'ero po ti pe manoi pejigwovo hahyva'ea ruvihava pype nehẽ, ei ga. ");
INSERT INTO pahNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","—Po pe ei: “Ndakoi po ti ji Jesus'ga remimbo'eharamo tapyhy pa ti mbatera jijive”, a'ero po ti pe herekotehei penhimbaterahetea aerẽ pejigwovo reki hahyva'ea ruvihava pype, ei ga. ");
INSERT INTO pahNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","A'ereki ahe nomondoi mbatera ohohava ikwepykavamo ohorame Tupana'ga pyri, ei ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Igwete Jesus'ga ei g̃a pe no: —Ag̃wamove'g̃a opohi Tupana'ga hugwi okote'varuhuavo, ei ga. Po g̃apyteripeve'g̃a ei: “Ji Jesus'ga remimbo'eharamo rũi ako heroviare'yma ganhi'ig̃a.” Po g̃a ei poro, a'ero jirura'javame po ti ji ei g̃a pe nehẽ: “G̃a ko nhiremimbo'eharamo rũi oko”, ei ga. Ajivyra'ja po ti ji Tupana'gapyrive'g̃a pavẽi Tupana'ga popoakara rerekovo nehẽ, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","—Amombe'u katu ji pe me, ei Jesus'ga g̃a pe. Omanoe'ymame po ti agwa'g̃a pyteripeve'g̃a hepiagi Tupana'ga popoakara nehẽ ji rekorame g̃anduvihavuhuhetero nehẽ, ei Jesus'ga imombe'gwovo g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Seis okirirẽ Jesus'ga trêsve'g̃a nderohoi ojupi. Pedro'ga ga gweroho Tiagova'ea João'ga no. G̃a tehe ga gweroho yvytyruhua rupi yvateuhuva'ea rupi g̃a nderojiupia. Igwete Jesus'ga ra'oa jirojijyi g̃andovaki. ");
INSERT INTO pahNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Gapira hendy'jandy'ja, tig̃ahivuhu hete. Nanongara tegwete nhande ve ipotukarame tapy'ynhapira imotig̃ahivuhuavo. ");
INSERT INTO pahNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Igwete ahe jipiukari g̃a pe Eliasva'ea Moisésva'ea pavẽi – kiroki ahe ymyahũ hete omano. Onhi'inhi'ĩ ahe Jesus'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","6","Igwete Pedro'ga ei oyvyteri pe: “Marã po ti ji ei a'ero?” ei ga. A'ereki g̃apy'a juahi g̃a nhimomby'arame ahe repiaga. Igwete Pedro'ga ei: —Jesus, pyry nhande rekoi avo, ei ga. Na ore japoi na'ẽ tapyimbovyra pe me a'ero trêsva'ea. Ojipeji po ti ore japoi nde ve, ojipea po ti ore japoi Moisés'ga pe, ojipea po ti Elias'ga pe nehẽ nohõ, ei ga Jesus'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Nanime ijyvi yvag̃atig̃a g̃a arimo g̃a mongovo o'ag̃i pe. Igwete Tupana'ga nhi'ig̃i yvag̃atig̃a hugwi. —Gaha ko jira'yra'ga nhiremia'nguhete'ga, ei ga Jesus'ga mombe'gwovo. Pehendu katu ti ganhi'ig̃a, ei Tupana'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Nanime Jesus'ga remimbo'ehara'g̃a harekoi novĩa. Emo g̃a ndohepiaga'javi ahe. Jesus'ga tehe g̃a gwepia ojipyri. ");
INSERT INTO pahNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Igwete g̃a jyvi yvytyruhua hugwi ojivya. Igwete Jesus'ga ei trêsve'g̃a pe: —Tapemombe'ui na'ẽ ti g̃a pe penhimbiepiaga, ei ga. Ji kweravirẽ gwe nhimanoa hugwi, a'ea rupi ti pemombe'u a'ero, ei ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ojapyaka g̃a ganhi'ig̃a rehe. Igwete g̃a ei ojohupe: —Gara pe ga ei: “Akwera po ti ji nhimanoa hugwi”? ei g̃a ojohupe. ");
INSERT INTO pahNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Aerẽ g̃a ei Jesus'ga pe: —Marã a'ero? ei g̃a. Orembo'ehara'g̃a e'i: “Elias'ga na'ẽ uhu, aerẽ Cristo'ga ruri a'ero,” ei g̃a, ei g̃a. Maraname g̃a ei a'ea? ei g̃a Jesus'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Igwete ga ei g̃a pe: —A'iti tuhẽ Eliasva'ea uhu na'ẽ g̃andeaporog̃ita rerojijyipava, ei Jesus'ga g̃a pe. Pejapyaka ti kiro nhimombe'uagwera rehe no, ei ga. A'ereki ymyahũ Tupana'ga okwatijaruka ahe ve ji mombe'gwovouka hako no. Nahã ahe ei: “He'yiva'ea po ti g̃a imondoi hahyva'ea ga pe okote'varuhuavo nehẽ ndorokoi ore nde rehe javo nehẽ.” Poha ahe ei ji mombe'gwovo hako, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Kiro ji ekatui pe me a'ero, ei Jesus'ga. Eliasva'ea uhu reki ikwehe. A'ero g̃a ndekote'varuhui ahe ve g̃wemimbotarimova'ea rehe okovo g̃waramo, ei ga. Na tuhẽ Tupana'ga rembikwatijarukara ahe mombe'u nhog̃wenonde hako, ei Jesus'ga ahe ko João Batistava'ea javo g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Igwete Jesus'ga jivyra'javi trêsve'g̃a pavẽi g̃wemimbo'ehara'g̃a pavẽi. Igwete g̃a nduri jara'g̃a pyri noveve'g̃a pyri. Urame g̃a he'yjuhuve'g̃a ndepiagi noveve'g̃a pyri Jesus'ga remimbo'ehara'g̃a pyri. A'ereki judeus'g̃a mbo'ehara'g̃a g̃a nhi'ig̃ayva. ");
INSERT INTO pahNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Nanime he'yjuhuve'g̃a Jesus'ga repiagi onhimomby'avo ga mboha'uve'yma. —Kiro ga ruri Jesus'ga, ei g̃a ojohupe. Igwete g̃a nhani ogwovo ga pyri. ");
INSERT INTO pahNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Igwete Jesus'ga ei g̃a pe: —Manongara rehe pe nhonhi'ig̃ayvayvaruhui? ");
INSERT INTO pahNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Igwete g̃apyteripeve'ga ei ga pe: —Jesus, ei ga. Aru ji jira'yra'ga nde pyri ko novĩa. A'ereki anhag̃a opojyka ga jipi, ei ga. Nomonhi'ig̃ukari jira'yra'ga a'ero, ei ga ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Ga pojykarame ga mbo'ambo'ari ga nog̃a. Hendyjuiporuhu ga. Haingyryngyryi ga no. A'ero ga yvyrakwenamo, ei ga. Igwete ji ei neremimbo'ehara'g̃a pe: “Pembojipe'a anhag̃a ga hugwi,” a'e ji g̃a pe novĩa. Tegwete reki g̃a pe ipe'ahava ga hugwi, ei ga Jesus'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Igwete Jesus'ga ei g̃a pe: —Pe ndapejikoguhui ji rehe jipi, ei ga. Manamehũ po ti pe jikogi ji rehe nehẽ naerũ? A'ereki ji jikwerajahivuhu pe ndehe, ei Jesus'ga g̃a pe. Peru ga ji pyri a'ero, ei ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Igwete g̃a tayri'ga reruri Jesus'ga pyri. Anhag̃a Jesus'ga repiagame tayri'ga moheõ'ari. Igwete ga ari yvyvo ojovajirejireva. Hendyjuipo hete ga. ");
INSERT INTO pahNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Igwete Jesus'ga ei garuva'ga pe: —Maramomi kwara ga pojyka rehe? —Gavoja'iagwera jate ga pojykai, ei ga. ");
INSERT INTO pahNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Igwete ga mombomombori tata pyteri pe jipi. Ypy pe ga mombomombori no tajuka ga javo novĩa, ei ga. Po nde ikwahavi ore pokoga, ore porogwety ti a'ero, ei ga Jesus'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","—“Po nde ikwahavi,” ere nde ji ve naerũ? ei Jesus'ga ga pe. Tupana'ga okwaha pa g̃a pokoga jipi – kiroki g̃a ojiko ga rehe, ei ga. ");
INSERT INTO pahNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Igwete garuva'ga ei: —Ajiko ji ga rehe novĩa. Ji poko ti a'ero ji mbojikoheteavo Tupana'ga rehe nehẽ, ei ga. ");
INSERT INTO pahNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Igwete he'yjuhuve'g̃a nhani ojatykavo ga pyri. G̃andura repiagame Jesus'ga nhi'ig̃ahyi anhag̃a pe – kiroki nomonhi'ig̃a'javi tayri'ga mboapyagweva no. Igwete ga ei jupe: —Jihi a'e nde ve: Ejipe'a ga hugwi. Terepojykaa'javi ti ga, ei Jesus'ga jupe. ");
INSERT INTO pahNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Igwete anhag̃a hapukai tayri'ga momanoahiva ojipe'avo ga hugwi. Omanova'ea ja ga rekoi upa. Nurã he'yive'g̃a etehei ga pe: —Omano ga upa. ");
INSERT INTO pahNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","A'ero Jesus'ga ga popyhygi ga mbovya. Igwete ga po'ami okovo. A'ereki ga pyry hete kiro. ");
INSERT INTO pahNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Aerẽ Jesus'ga hoi onga pype. Igwete garemimbo'ehara'g̃a hoi javo ga pe ojipe'g̃a ndovakie'ỹ. —Marã ore norombojipe'akwahavi anhag̃a ga hugwi? ei g̃a Jesus'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","—Penhi'ig̃ame jate Tupana'ga pe po ti pe imbojipe'aukari nanongara, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Aerẽ Jesus'g̃a hoi pea hugwi ogwoogwovo Galiléiapeve'g̃a gwyra rupi. Jesus'ga ndopotari ohoa kwahava. ");
INSERT INTO pahNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","A'ereki ga g̃wemimbo'ehara'g̃a mbo'e pota omanoag̃wama rehe. —Ji mondouka po ti g̃a nhiarõe'ỹve'g̃a po pe nehẽ ji jukavouka nehẽ, ei ga. Mokõi ti pe kiri ji jukarẽ nehẽ. Kirẽ ti ji kwerava'javi nehẽ, ei ga g̃a pe novĩa. ");
INSERT INTO pahNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Emo g̃a ndokwahavi garembi'ea ma gara pe ga ei javo ojohupe. Ga pe g̃a nde'ia'uvi reki. ");
INSERT INTO pahNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","34","Pea rupi Jesus'g̃a hoi ogwovo. Oro Jesus'ga remimbo'ehara'g̃a, onhi'ig̃ayva g̃a ojohupe. —Manamo nhandejoheva'ero? Ji ko koji'i pe hohe, ei g̃a ojohupe. Igwete g̃a nduri ovahema cidade de Cafarnaum me. Ohorame onga pe Jesus'ga ei g̃a pe: —Manongara rehe pe nhonhi'ig̃ayvayvari nhande rurame pea rupi? ei ga. Igwete g̃a nonhi'ig̃i opoyjayjare'ymamo. A'ereki g̃a onhonhi'ig̃ayva onhimboheteavo pea rupi ogwovo ji ko pe hohe javo ojohupe. ");
INSERT INTO pahNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","A'ero Jesus'ga apygi g̃a mbuhurukapava ojipyri. Igwete ga ei g̃a pe: —Pejikopotarame g̃ahoheva'ero penhimongo na'ẽ ti okoteheva'ero ojipe'g̃a pokopokoga jipi, ei ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","A'ero ga tayri'ga mbuhurukari ga rerua g̃apyteri pe ga anhuvana. Igwete ga ei g̃wemimbo'ehara'g̃a pe: ");
INSERT INTO pahNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","—Pehepia tayri'ga, ei ga. Kiroki g̃a oko nanongara'g̃a ndehe g̃a ko Jesus'gareheva'ero javo – g̃a oko ji rehe no, ei ga. Kiroki g̃a oko ji rehe nde ko Tupana'ga repykaramo javo – ji rehe jate rũi g̃a oko. G̃a oko nhimbuhurukara'ga rehe no, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Igwete João'ga ei Jesus'ga pe: —Orohepia ore hajiheve'ga oji'i, ei ga. Ombojipe'a ga anhag̃a ojipe'g̃a hugwi. Ombojipe'a ga ndepopoakara pyvõ nde renoina, ei ga Jesus'ga pe. Nurã ore ei ga pe: “Terembojipe'ai anhag̃a g̃a hugwi Jesus'ga renoina,” oro'e ore ga pe. A'ereki ga nhandereheva'ea rũi, ei João'ga ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Igwete Jesus'ga ei g̃a pe: —Tape'ei poa ga pe, ei ga. Japovame ahemonhimomby'ava'ea jipopoakara pyvõ po ti g̃a nanhimbotegwetei kotihĩ nehẽ, ei ga. ");
INSERT INTO pahNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Kiroki g̃a nianemovahĩ – g̃ahã nhande repy a'ero, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Amombe'u katu ji pe me, ei ga. Kiroki g̃a pe poko g̃a ko Cristo'gareheve'g̃a javo – g̃a pe po ti Tupana'ga ikwepygi imondokatuavo nehẽ. Yhya vehevi g̃a imbuhurame pe me pey'gwavamo, a'ero po ti ga ikwepykatui tuhẽ g̃a pe nehẽ, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Igwete Jesus'ga ei no: —Tapembo'e ti ji ojipe'ga rehe kiro. Po g̃a nhapytĩ itaruvihavuhua gajura rehe ga momboa ypy pe, a'ero po tiruahũ ga pe, ei ga. Koji'i hete po ti tiruahũ ga pe ga jireheve'g̃a mbote'varuhurame tayri'g̃a huvihava'g̃arũive'g̃a, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Igwete ga ei no: —Po pe ndekote'varuhui pejipoa pyvõ, marã re po ti pe napemondohoguhui pejipoa imomboa a'ero torokote'varuhua'javyme ti javo? ei ga g̃a pe. Tiruahũ po pe me pe ojipeji herekorame pejipoa novĩa, ei ga. Po ti pe mokõi pejipoa rerohoi hahyva'ea ruvihava pype pejikote'varuhua pige'yma g̃waramo nehẽ, a'ero po ti koji'iete'i tiruahũ pe me nehẽ. A'ereki pevova'ea tata ndogweva'javi nehẽ, ei ga. Koji'i pyry po ti pe herohoi pejipoe'yma vehevi yvagi pe Tupana'ga pyri nehẽ, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","—Po pe hoi pejikote'varuhuavo pejikovo, marã re po ti pe napemondohoguhui pejipya imomboa a'ero torokote'varuhua'javyme ti javo? ei ga g̃a pe. Tiruahũ po pe me pe herekorame ojipeji pejipya novĩa, ei ga. Po ti pe mokõi pejipya rerohoi hahyva'ea ruvihava pype pejikote'varuhua pige'yma g̃waramo nehẽ, a'ero po ti koji'iete'i tiruahũ pe me nehẽ, ei ga. Koji'i pyry po ti pe herohoi yvagi pe pejipye'yma vehevi nehẽ, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","—Po pe pejeakwara pyvõ hepiagi ite'varuhuva'ea – kiroki onhimbohepia'ngi pe me, marã re po ti pe ndapehekyjuhui pejeakwara torokote'varuhua'javyme ti javo? ei ga g̃a pe. Tiruahũ po pe me pe ojipeji herekorame pejeakwara novĩa, ei ga. Po ti pe mokõi pejeakwara rerohoi hahyva'ea ruvihava pype nehẽ pejikote'varuhua pige'yma g̃waramo nehẽ, a'ero po ti koji'iete'i tiruahũ pe me nehẽ, ei ga. Koji'i pyry po ti pe herohoi ojipeji vehevi nhanderuvihava'ga pyri Tupana'ga pyri nehẽ, ei ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","A'ereki “hahyva'ea ruvihava pype ndopiga'javi ahe hugwi hahyhetea. Ndogweva'javi tata”, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","—Nhande nhikwava'eg̃ame Tupana'ga pe po ti tata'java'ea hahyva'ea nhande rerekoi nehẽ, ei ga. Peko tuhẽ ti ji pavẽi jireheva'ero. Tapepohiri ti ji hugwi, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","—Pyry ko jukyra, ei ga. A'ereki a'ea oko mbatera pavẽi heheva'ero. Pyryve'ymame ndikwahya'javi. Nurã ji ei pe me: Peko pyry ti ji pavẽi jireheva'ero. Pejikoty'a tuhẽ ti ji pavẽi. Pejogwereko katu ti no, ei Jesus'ga g̃a pe ogwovo pea hugwi. ");
INSERT INTO pahNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Aerẽ Jesus'g̃a hoi Judéiapeve'g̃a gwyra rupi. Igwete g̃a herohoi rio Jordão aherovai herogwovo. A'ero pevove'g̃a jatykaa'javi Jesus'ga pyri onhimongyavo. Igwete ga g̃a mbo'ei. A'ereki na tuhẽ ga g̃a mbo'embo'ei jipi g̃a nderekovo. ");
INSERT INTO pahNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Igwete fariseus'g̃a nduri. “Tihendu ganhi'ig̃a nhande ve. A'ero po ti nhande ga mbotegwetei nehẽ,” ei g̃a ojohupe. Igwete g̃a ei Jesus'ga pe: —Marã naerũ? ei g̃a. Moisésva'ea remimbo'eagwera rupi g̃a ndekoi opohirame g̃wembireko'g̃a hugwi kunhangwera'g̃a hugwi naerũ? ei g̃a ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Igwete Jesus'ga ei: —Marã Moisésva'ea ikwatijari pe me g̃wemimbo'eagwera nog̃a hako naerũ? ei ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Igwete g̃a ei: —Moisésva'ea e'i: “Tokwatija na'ẽ ti g̃a inog̃a kunhangwera'g̃a pe apohi ji kiro nde hugwi javo,” ei ahe. “A'ero po ti g̃a pohiri g̃wembireko'g̃a hugwi,” ei ahe ikwatija hako, ei g̃a Jesus'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","—Napeangarihu pe pejikoe'yma Tupana'ga remimbotarimova'ea rupi, ei Jesus'ga g̃a pe. Nurã Moisésva'ea okwatija a'ea pe me g̃wemimbo'eagwera nog̃a, ei ga. ");
INSERT INTO pahNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Jypya ko na rũi reki hako. Jypya yvyakotyve'g̃a aporame “Tupana'ga g̃a apoi akwaimbae'ga kunhahẽa reheve”, ei Jesus'ga. Nahã e'i Tupana'ga rembikwatijarukara, ei ga. ");
INSERT INTO pahNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","“Nurã ko akwaimbae'g̃a ja'ogi uva'g̃a hugwi oy'g̃a hugwi g̃wembirekokaturo. ");
INSERT INTO pahNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Igwete g̃a ojogwerekoro g̃waramo ojipejiva'ea ja akwaimbae'ga garembirekohẽa pavẽi,” ei ikwatijara, ei ga. A'ero g̃a mokonha ja rũi. Ojipejiva'ea ja reki g̃a ndekoi, ei ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Tupana'ga ko g̃a mbojogwerekouka. Nurã po g̃a ndopohiri ojohugwi hamo, ei ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Aerẽ onga pe Jesus'ga remimbo'ehara'g̃a ea'javi ga pe: —Marãi re ko nde imombe'gwovo g̃a pe ko? ");
INSERT INTO pahNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Igwete ga ei g̃a pe: —Kiroki ga opohi g̃wembirekohẽa hugwi ojipehẽa rerekovo – oajuajuro g̃waramo ga rekote'varuhui g̃wembirekoypyvehẽa pe, ei ga. ");
INSERT INTO pahNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Na jitehe hẽa opohirame g̃wembireko'ga hugwi ojipe'ga rerekovo hẽa rekote'varuhui g̃wembirekoypyve'ga pe a'ero. A'ereki hẽa ajuajuri, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Igwete pevove'g̃a tayri'g̃a nderunderuri Jesus'ga pyri topoko ti ga g̃a ndehe javo. —Ere ti Tupana'ga pe tomombyry ga g̃a pe javo, ei g̃a ga pe. Emo Jesus'ga remimbo'ehara'g̃a e'i g̃a pe: —Taperuruhui g̃a ga pyri, ei g̃a. ");
INSERT INTO pahNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Hepiagame Jesus'ga nhimonha'ngahetei o'ama. Igwete ga ei g̃wemimbo'ehara'g̃a pe: —“Taperuruhui g̃a,” tape'euhui g̃a pe, ei ga. Tuhu tuhẽ ti ji pyri tayri'g̃a. A'ereki nanongara'g̃a'jave'g̃a pe Tupana'ga pyry hete okovo g̃a jikogame ojihe, ei ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Tamombe'u katu ti pe me: Tayri'g̃a ojiko uva'g̃a ndehe okovo g̃anemimbotarimova'ea rehe, ei ga. Kiroki g̃a oko tayri'g̃a ja rũi – g̃a ndojikogi Tupana'ga rehe okoe'yma garemimbotarimova'ea rehe. G̃a po ti nomongoi Tupana'ga gwuvihavuhuhetero nehẽ, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Igwete ga tayri'g̃a anhuvani opokoga g̃a ndehe. Igwete ga ei Tupana'ga pe: —Emombyry g̃a pe, ei Jesus'ga javo ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Jesus'g̃a horame pea rupi kiro ojipe'ga ruri onhana. Igwete ga renypy'andurugi Jesus'ga pyri ta'e ti g̃ambo'ehara'ga pe javo. —Jesus, ei ga. Marãva'ea rupi pyryva'ea rupi po ti ji rekoi nehẽ jirekoag̃wamamo Tupana'ga pyri avuirama nehẽ? ei ga ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Igwete Jesus'ga ei ga pe: —Maraname nde ei pyryva'ea rehe? Tupana'ga nhi'ig̃a jate ko pyry, ei ga ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Nde erekwaha Tupana'ga remimbo'eagwera Moisésva'ea pe hako, ei Jesus'ga. A'ereki Tupana'ga e'i: “Terejukai ojipe'g̃a. Tererekoi ojipe'g̃a nembireko'g̃a. Teremimi ojipe'g̃a mbatera. Tane'mbei ojipe'g̃a mombe'gwovo. Teremoandyandyi ojipe'g̃a g̃ambatera rerogwovo. Emondo ejeaporog̃ita imohina ejuva'ga rehe eyhẽa rehe no,” ei Tupana'ga, ei ga ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Igwete ga ei Jesus'ga pe: —Jivoja'irame vehevi ji hendukatupavi garemimbo'eagwera jipi, ei ga. ");
INSERT INTO pahNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Ga repiagame Jesus'ga ga arõhetei. Igwete ga ei ga pe: —Nahã na'ẽ po ti nde rekoi a'ero hamo. Eho na'ẽ ti embatera imondopava itambere'ia rehe imondovo itambere'ia imbatere'ỹve'g̃a pe nehẽ, ei ga. A'ero po ti Tupana'ga imombyryvi nde ve yvagi pe nehẽ, ei ga ga pe. Imondopavirẽ embatera ti ejo ji pyri ekovo nhiremimbo'eharamo. Ji rehe jate ejiko, ei Jesus'ga ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Jesus'ga nhi'ig̃a renduvame ga ndovy'ari ogwovo. A'ereki he'yjuhu gambatera. ");
INSERT INTO pahNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Igwete Jesus'ga jirovagi javo g̃wemimbo'ehara'g̃a pe. —Kiroki g̃a imbate hete – hahy g̃a pe g̃a erame Tupana'ga pe eko ti oreruvihavuhuhetero javo. A'ereki g̃a okoheterame ombatera rehe ndokoi garembi'ea rupi, ei ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Henduvame ganhi'ig̃a garemimbo'ehara'g̃a nhimomby'ai a'ero. Igwete Jesus'ga ea'javi g̃a pe: —Hahy imbateheteve'g̃a pe g̃a erame Tupana'ga pe eko ti oreruvihavuhuhetero javo, ei ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Tegwete yuranuhũa'javuhuva'ea camelo ikihava agulha kwa'ria rupi. Tegwete hete reki imbateheteve'g̃a hohava Tupana'ga rembi'ea rupi okoheterame ombatera rehe, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Kiro g̃a nhimomby'ahetei a'ero. Igwete g̃a ei ojohupe: —Ma'g̃a po ti oho Tupana'ga pyri yvagi pe nehẽ naerũ? ");
INSERT INTO pahNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Igwete Jesus'ga g̃a ndepiagi javo g̃a pe. —Tegwete tuhẽ g̃anhimondohava ga pyri, ei ga. Tupana'ga jate g̃a mondoukari ojipyri. A'ereki Tupana'ga ikarakatu pa hete, ei ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Igwete Pedro'ga ei ga pe: —Jesus, ei ga. Oropohi katu ore orombatera hugwi orogwovo nde rupi neremimbo'eharamo, ei ga. ");
INSERT INTO pahNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Igwete Jesus'ga ei g̃a pe: —Tamombe'u katu ti ji pe me: Okopotarame jireheva'ero g̃a pohiri tuhẽ tamombe'u ti Jesus'ga ojipe'g̃a pe javo, ei ga g̃a pe. Jara'g̃a opohi g̃wonga hugwi, ei ga. Jara'g̃a opohi oirũ'g̃a hugwi. Jara'g̃a opohi okuvyra'g̃a hugwi. Jara'g̃a opohi g̃wendyra'g̃a hugwi, ei ga. Jara'g̃a opohi oy'g̃a hugwi uva'g̃a hugwi no tamombe'u Jesus'ga ojipe'g̃a pe javo, ei ga. Jara'g̃a opohi gwa'yra'g̃a hugwi. Jara'g̃a opohi ogwyra hugwi tamombe'u Jesus'ga g̃a pe javo, ei ga. ");
INSERT INTO pahNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","Kiroki g̃a jireheva'ero opohi ombatera hugwi, gwe'yja'g̃a hugwi – gwereko po ti g̃a he'yjuhuheteva'ea ag̃wamo nehẽ g̃wonga oirũ'g̃a no okuvyra'g̃a g̃wendyra'g̃a no oy'g̃a no gwa'yra'g̃a no ogwyra nehẽ no, ei ga g̃a pe. Aerẽ po ti g̃a hohetei Tupana'ga pyri nehẽ no. Nane'ymi po ti g̃a ndekoi ga pyri a'ero nehẽ, ei ga. Emo nhiarõe'ỹve'g̃a po ti imbohahyukari na'ẽ g̃a pe ag̃wamo nehẽ, ei ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Kiroki g̃a huvihava ag̃wamo – he'yive'g̃a po ti ndokoa'javi huvihavamo onhimongyavo aerẽ nehẽ. Kiroki g̃a huvihava rũi ag̃wamo – g̃ahã po ti huvihavamo oko nehẽ, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Igwete Jesus'g̃a hoi pea rupi ogwovo Jerusalém me. Ga na'ẽ oho dozeve'g̃a nenonde. Igwete g̃a nhimomby'ai ga rehe ogwovo. Ojipe'g̃a oho g̃andeviri okyhyjiavo ogwovo. Igwete Jesus'ga dozeve'g̃a nderohoi'i g̃a hugwi aerẽva'ea mombe'gwovo g̃a pe. Igwete ga ei g̃a pe: ");
INSERT INTO pahNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","—Pehendu ti nhinhi'ig̃a, ei ga. Kiro po ti nhande hoi Jerusalém me nehẽ, ei ga. Igwete po ti g̃a ji mondoukari ahembo'ehara'g̃a po pe nehẽ ikwava'ẽhara'g̃a nduvihava'g̃a po pe nehẽ no, ei ga g̃a pe. “Eremano po ti nde hamo,” e po ti g̃a ji ve nehẽ, ei ga. Nurã po ti g̃a ji mondoukari judeus'g̃arũive'g̃a pe a'ero nehẽ, ei ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","G̃ahã po ti ji rerekomemuahũ nehẽ, ei ga. Onyvũ po ti g̃a ji rehe ji nupanupamo ipira apopyra pyvõ nehẽ. Igwete po ti g̃a ji jukai nehẽ, ei ga. Emo mokõi pe kirirẽ po ti ji kwerava'javi nhimanoa hugwi nehẽ, ei Jesus'ga onhimombe'gwovo g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Aerẽ Zebedeu'ga ra'yra'g̃a nduri Jesus'ga pyri Tiagova'ea João'ga pavẽi. Igwete g̃a ei ga pe: —Jesus, oropota ore nderekoag̃wama oreremimbotarimova'ea rehe, ei g̃a ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","—Gara pe pepota naerũ? ei ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","—Toromoirũ ti nde yvyakotyve'g̃a nduvihavamo nde rekorame g̃a mondomondovo nehẽ. Toroapy ti ore nde pyri nde mbojogwovaita a'ea rupi nehẽ, ei g̃a Jesus'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","39","Igwete Jesus'ga ei g̃a pe: —Ndapekwahavi pe nanongara pe'erame, ei ga g̃a pe. Aerẽ po ti hahy hete ji ve nehẽ. Po pe ji moirũi, a'ero hahy hete pe me nehẽ no, ei ga. Marã a'ero? Peko pe nanongara rehe naerũ? ei ga g̃a pe. —Toronhimboita ti ore jupe, ei g̃a. —Aerẽ po ti g̃a ji jukai nehẽ no. A'ero po ti g̃a pe jukapotari nehẽ no. Marã a'ero? ei ga g̃a pe. —Na g̃a ore jukai nehẽ no, ei g̃a. —Ombuhu tuhẽ po ti g̃a hahyva'ea ji ve ji jukavo nehẽ. Na tuhẽ po ti g̃a pe nderekoi nehẽ no, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Emo ji rũi po ti amboapyguka g̃a jijipyri nehẽ tombojogwovai g̃a ji rehe javo, ei ga. A'ereki ymya Tupana'ga omboavujikwe g̃andekohavag̃wama ji pyri. G̃ahã po ti ji moirũ g̃a mondomondovo a'ero nehẽ, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Jara'g̃a dezve'g̃a henduvame João'g̃a nhi'ig̃a Jesus'ga pe g̃a nhimonha'ngai g̃a ndehe. ");
INSERT INTO pahNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Igwete Jesus'ga g̃a mbuhurukapavi ojipyri g̃wemimbo'ehara'g̃a. Igwete ga ei g̃a pe: —Pejapyaka ti nhinhi'ig̃a rehe, ei ga. Pekwaha pe hajiheve'g̃a ndeaporog̃ita – kiroki g̃a e'i ore ko g̃anduvihava javo. G̃a omboporavykyuhu ogwyripeve'g̃a jipi g̃a mbovavaguhuavo g̃a nderekovo, ei ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Pe po na rũi pejogwereko hamo jireheva'ero g̃waramo, ei ga g̃a pe. Po ti pe ndekopotari jara'g̃a nduvihavamo, a'ero po ti pe g̃a pokogi hamo. ");
INSERT INTO pahNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Po ti pe ndekopotari g̃ahohepava'ero, koji'i po ti pe g̃a pokopahetei hamo, ei ga. ");
INSERT INTO pahNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","A'ereki ji vehevi ajo tapoko pa ti g̃a javo. Ji ndajori ji pokopoko javo g̃a pe, ei ga. Tamano javo ji ruri g̃a ndepyga yvya koty. Nahã po ti ji he'yjuhuve'g̃a mbopiro'yi g̃a ndekote'varuhua hugwi nehẽ, ei ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Aerẽ Jesus'ga g̃wemimbo'ehara'g̃a nderohoi g̃a nderovahema cidade de Jericó pe g̃a nderokwava hupi. He'yjuhu g̃a ogwovo g̃a ndupi no. G̃a horame jugwi Bartimeu'ga onhi'ig̃a mbuhuri Jesus'ga pe. A'ereki Bartimeu'ga heakwagweva'ero oko Timeu'ga ra'yra'ga. A'ero ga apygi pea rovai itambere'ia rehe oporanduranduva upa. ");
INSERT INTO pahNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Igwete pevove'g̃a ei: —Kiro ki ga u Jesus'ga Nazarépeve'ga. Henduvame Bartimeu'ga onhi'ig̃a mbuhuri Jesus'ga pe a'ero. —Jesus, nde ko Daviva'ea rymyminoa Tupana'ga remimbuhurukara, ei ga ga pe. Ji porogwety ti, ei ga. ");
INSERT INTO pahNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Igwete g̃a nhi'ig̃ahyi ga pe onhimongyavo epi te javo. Igwaigwavete reki ga onhi'ig̃a mbuhuri ga pe. —Nde ko Daviva'ea rymyminoa Tupana'ga remimbuhurukara. Ji porogwety ti, ei ga ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Igwete Jesus'ga pytai. —Pe'e ga pe tuhu ga ji pyri a'ero, ei ga g̃a pe. Igwete g̃a ei heakwagweve'ga pe: —Enog̃atu ti epy'a, ei g̃a ga pe. Epo'ã ejoa ga pyri. “Tuhu ga ji pyri,” ei ga nde ve, ei g̃a ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Igwete ga po'ami hekyita opira i'arimova'ea nhandaipe ua Jesus'ga pyri. ");
INSERT INTO pahNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Igwete Jesus'ga ei ga pe: —Gara nde erepota? —Jesus, tajireha katu ti, ei ga ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","—Heregwovo a'ero, ei Jesus'ga ga pe. Nde erejiko ji rehe. Nurã nde reharo kiro, ei ga. Igwete ga reakwakaturo a'ero. Jesus'ga rupi ga hoi a'ero pea rupi ogwovo. ");
INSERT INTO pahNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Ohorame Jerusalém me yvytyruhu pe na'ẽ Jesus'g̃a vahemi oliveiras ndyvuhu pe monte das Oliveiras pe. Ira'agwe cidades ojopyjopyri tuvi Betfagé Betânia pavẽi. Igwete Jesus'ga ei mokonha'g̃a pe g̃wemimbo'ehara'g̃a pe: ");
INSERT INTO pahNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","—Hepejigwovo cidade pe penhinondeva'e pe, ei ga. Pevahemame ti pe hepiagi jumentinho i'ama nehẽ, ei ga g̃a pe. Ojugwa g̃a imo'ama yva rehe. Ndohoi ve g̃a i'arimo, ei ga. Pekwahara ti herua, ei ga. ");
INSERT INTO pahNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Po ti g̃a ei pe me: “Maraname pe ikwaharavi a'ea?”, pe'ji ti g̃a pe: “Nhandepojykaharete'ga ti togwereko'ã na'ẽ. Kotihĩ po ti ga imbuhura'javi avo nehẽ,” pe'ji ti g̃a pe, ei ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Igwete g̃a hoi hepiaga jumentinho. A'ereki pevove'g̃a ojugwa imo'ama pea rupi onga jurukwara pyri. Kiro g̃a ikwaharavi a'ero. ");
INSERT INTO pahNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Pevove'g̃a g̃a ndepiagame e'i g̃a pe: —Maranuhũrame pe ikwaharavuhui ta'yra? ");
INSERT INTO pahNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Igwete g̃a imombe'ui g̃a pe Jesus'ga rembi'ea. —Peroho ti ga pe a'ero, ei g̃a g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Igwete g̃a heruri jumentinho Jesus'ga pe. Igwete g̃a inog̃i oapoa tapy'ynhapira ikupepytera rehe. A'ero Jesus'ga hoi i'arimo. ");
INSERT INTO pahNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Igwete he'yive'g̃a heroporopori opira i'arimova'ea pea rupi inog̃a timbojigwa pehea ga pe javo. Ojipe'g̃a omondohondoho pindova rohova nhu me herua. Igwete g̃a imondomondoi pea rupi imbokatuavo ga pe. Nahã g̃a Jesus'ga mbojiroviari ga rerua nhanderuvihavuhuhete'ga kiro u javo. ");
INSERT INTO pahNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Kiro garenondeve'g̃a hapukai garevirive'g̃a pavẽi. “Timbohete Tupana'ga!” ei g̃a. “Nhandepojykaharete'ga ti tomombyry ga pe – kiroki ga nhandepojykaharete'ga ombuhuruka nhande pyri ga mongovouka nhanderuvihavuhuhetero,” ei g̃a. ");
INSERT INTO pahNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","“Tupana'ga tomombyry nhaneramonhava'ea'jave'ga pe Daviva'ea'jave'ga pe kiro ga rurame nhanderuvihavuhuhetero,” ei g̃a. “Timbohete Tupana'ga yvagipeheteve'ga a'ero!” ei g̃a. ");
INSERT INTO pahNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Igwete Jesus'g̃a vahemi Jerusalém me ogwovo g̃ajatykahavuhua rokari pe o'ama. Oharekorẽ mbatera rehe nhaporemo Jesus'ga dozeve'g̃a nderohoi Betânia pe g̃a nderokia. A'ereki oho kwara. ");
INSERT INTO pahNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ko'emame Jesus'g̃a jivyri Betânia hugwi. Igwete ga jukai ty'ara. ");
INSERT INTO pahNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Irupe ga hepiagi figo'yva figueira ka'a rerekojiperame. Igwete ga hoi tahepia yva'ia javo novĩa. Ovahemame ga ka'atehea hepiagi. A'ereki a'ea rupi ndi'ai ve tuhẽ jipi yva'ia. ");
INSERT INTO pahNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Igwete ga ei yva pe: —Ndehe po ti nande'aa'javi nehẽ g̃anembi'uhavamo nehẽ, ei ga jupe. Garemimbo'ehara'g̃a g̃wendu ganhi'ig̃a a'ero. ");
INSERT INTO pahNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Aerẽ Jesus'g̃a vahemi ua Jerusalém me. Igwete g̃a nduri g̃ajatykahavuhua rokari pe. Pevove'g̃a oma'ema'ẽ mbatepyryva ojipe'g̃a pe jipi inambu'ia no. A'ereki a'ea g̃a omondo ikwava'ẽhara'ga pe tomondo ti ga Tupana'ga pe javo. Itambere'ia rehe g̃a oma'ema'ẽ g̃a pe g̃a moandyandyjuhuavo jipi. Mesas pyri ojipe'g̃a neni hajiheve'g̃a itambere'ia pyhypyhyga judeus'g̃a itambere'ia kwepykwepyga imondovo g̃a pe. Igwete Jesus'g̃a nduri okari pe g̃a ndepiaga. Kiro ga nhimonha'ngai g̃a ndehe a'ero g̃a mo'emo'embava pea hugwi. Igwete ga imbojirejirevi itambere'ia kwepykara'g̃a mesas. Ga imbojirejirevi g̃a'apykava g̃a hugwi no – kiroki g̃a oma'ema'ẽ inambu'ia oina. ");
INSERT INTO pahNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Igwete ga ndogwerokwarokwarukari mbatera g̃ajatykahavuhua rokara pytera rupi. ");
INSERT INTO pahNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","A'ero ga ei g̃a pe g̃a mbo'eavo. —Tupana'ga okwatijaruka onhi'ig̃a hako, ei ga. Nahã Tupana'ga ei a'ero hako: “Yvyakotyve'g̃a nhaporemo ti tonhi'ĩ ji ve nhironga pype,” ei Tupana'ga hako, ei ga. Pe ki a'e te pe'e pejohupe: “Timoandyandyjuhu ti g̃a ikwepykwepygame Tupana'ga ronga pype,” pe'e pe, ei Jesus'ga. Nahã pe Tupana'ga ronga mongoukari iporomive'g̃a nduhavamo, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Aerẽ ikwava'ẽhara'g̃a nduvihava'g̃a ikwahavi Jesus'ga nhi'ig̃a g̃a pe judeus'g̃a mbo'ehara'g̃a pavẽi. Igwete g̃a ei: —Marã re po ti nhande ga rerekoi ga jukavo nehẽ? ei g̃a ojohupe. Tijukaukaryme ti ga he'yjuhuve'g̃a ndovaki, ei g̃a. A'ereki g̃a onhimomby'a pa garemimbo'ea repiaga, ei g̃a ojohupe. Nurã g̃a kyhyji ga pyhyge'yma. ");
INSERT INTO pahNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ka'aru hete Jesus'g̃a hoa'javi cidade de Jerusalém hugwi ogwovo Betânia pe okia. ");
INSERT INTO pahNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Ko'emame ojivyrame Jesus'g̃a kwavi pea rupi. Igwete g̃a hepiagi akoja figo'yva. Inhymba reki. Hapoa vehevi inhymba. ");
INSERT INTO pahNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","A'ero Pedro'ga ikwahava'javi Jesus'ga nhi'ig̃a jupe. Igwete ga ei ga pe: —Jesus, ehepia! ei ga. Erenhi'ig̃ahy nde figo'yva pe kirame oji'i. Kiro inhymbavamo a'ero, ei ga ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Igwete Jesus'ga ei g̃a pe: —Pejiko ti Tupana'ga rehe, a'e ji pe me, ei ga. ");
INSERT INTO pahNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Tamombe'u katu ti pe me: G̃a jikogame Tupana'ga rehe oporanduva ga pe Tupana'ga po ti g̃wendu katu nhinhi'ig̃a javo, na ja po ti hekoi g̃a pe a'ero nehẽ, ei ga. Po ti g̃a ei Tupana'ga pe tojipe'a ti yvytyruhua onhimomboa ypiahua pype javo, a'ero po ti Tupana'ga imbojipe'ai g̃a pe, ei ga. Po ti g̃a ndogweroviarihihũ mara'ngu po ti ojipe'avo javo, a'ero po ti Tupana'ga nombojipe'aukari g̃a pe nehẽ, ei ga. ");
INSERT INTO pahNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","A'ero ji ei pe me: Peporanduvame Tupana'ga pe penhimimbotarimova'ea rehe, perovia ti garemimbuhurag̃wama pe me. A'ero po ti ga imbuhuri pe me nehẽ, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Po ojipe'ga oko te'varuhu pe me. A'ero po pepy'a heahemuhũro ga rehe. Penhi'ig̃ame Tupana'ga pe penhi'ama tapekwahava'javi ti akoja'ga rekote'varuhua, ei ga. Pe ikwahava'jave'ymame garekote'varuhua henonhe'yma po ti nhanderuvete'ga yvagipeve'ga ndokwahava'javi pendekote'varuhua imomboa pe hugwi nehẽ, ei ga.  ");
INSERT INTO pahNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Pe ikwahava'javame akoja'ga rekote'varuhua po ti nhanderuvete'ga nomombori pendekote'varuhua nehẽ no. ");
INSERT INTO pahNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Igwete Jesus'g̃a hoa'javi Jerusalém me. G̃ajatykahavuhua rokara rupi Jesus'ga hoi okovo. A'ero ikwava'ẽhara'g̃a nduvihava'g̃a nduri ga pyri judeus'g̃a mbo'ehara'g̃a pavẽi xava'eve'g̃a pavẽi. ");
INSERT INTO pahNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Igwete g̃a euhui ga pe: —Ma'g̃a nde mbuhurukaruhu raji'i? Ma'g̃a e'i nde ve: “Emo'emo'ẽ ti g̃a mondovo jugwi?” ei g̃a Jesus'ga pe. Here javo ore ve, ei g̃a. ");
INSERT INTO pahNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Igwete Jesus'ga ei g̃a pe: —Pe na'ẽ ti pe'ji ji ve, ei ga. Pe ji nhi'ĩpondekwakaturame po ti ji nhimbuhurukara'ga mombe'ukatui pe me nehẽ no, ei ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Pe'ji ti ji ve a'ero: Ma'g̃a João Batistava'ea mbuhuruka g̃a mobatizavouka raikwehe? ei ga. Tupana'ga yvagipeve'ga ombuhuruka ahe? Ma'g̃a e'i ahe ve teremobatiza g̃a javo? Yvyakotyve'ga ombuhuruka ahe naerũ? ei ga. Pe'ji ti javo ji ve! ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Igwete g̃a nhombo'embo'ei upa. —Marãi po ti nhande a'ero nehẽ? ei g̃a. Po ti nhande ei ga pe: “Tupana'ga po ombuhuruka João Batistava'ea g̃a mobatizauka raikwehe”, a'ero po ti Jesus'ga ei nhande ve nehẽ: “Maraname pe ndaperoviarihu ahenhi'ig̃agwera naerũ?” e po ti ga nhande ve nehẽ, ei g̃a ojohupe. ");
INSERT INTO pahNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Po ti nhande ei ga pe: “Yvyakotyve'ga po ahe mbuhuruka raikwehe”, a'ero po ti avove'g̃a nhimboahivuhupavi nhande ve nehẽ, ei g̃a ojohupe. Okyhyji g̃a he'yjuhuve'g̃a hugwi. A'ereki g̃a e'i pa João Batistava'ea pe: “Tupana'ga tuhẽ ahe mbuhuruka onhi'ig̃a mombe'uharamo raikwehe,” ei g̃a. ");
INSERT INTO pahNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Nurã g̃a ei reki Jesus'ga pe: —Ma'g̃a po ombuhuruka ahe raikwehe? Ndorokwahavi ore, ei g̃a ga pe. —Napemombe'ujuhu pe ji ve João Batistava'ea mbuhurukara'ga, ei Jesus'ga g̃a pe. Nurã po ti ji na jitehe namombe'ui ga pe me nehẽ no – kiroki ga e'i ji ve: “Emo'emo'ẽ g̃a onga hugwi,” ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Igwete Jesus'ga imombe'ui g̃a pe ojo'java'ea. Igwete ga ei imombe'gwovo: —Kohoa jara'ga otỹotỹ ko pe yhypoa'javuhuva'ea uva'yva videira. “Aerẽ ti ta'u yva'ia ryhya,” ei ga, ei Jesus'ga g̃a pe. Igwete ga hokairug̃i g̃wemityma. Aerẽ ga japoi uva mu'umu'ũhava tyhya rupiaramo. Tapyjo'ara ga japoi ita pyvõ imondovo imohina ko pe hepiakatuhavamo. Igwete ga ei ojipe'g̃a pe: “Kiro po ti ji hoi paivohu mbaigwe jitua nehẽ,” ei ga. “Pehepia katu ti nhiremityma ji ve,” ei ga g̃a pe. “A'ero po ti pe imboja'ogi yva'ia pejive nehẽ. Jara ti pemombyta ji ve nehẽ,” ei ga g̃a pe, ei ga. “Kwa,” ei g̃a. Igwete ijara'ga hoi g̃a ndeja, ei Jesus'ga imombe'gwovo g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Aerẽ yva'ia jykyhava rupi ga ojipyrive'ga mondoukari hepiakatuhara'g̃a pyri togweru ti ga yva'ia ji ve javo novĩa. ");
INSERT INTO pahNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Emo hepiakatuhara'g̃a ga pyhy ga nupanupamo ga momboa. Gapojate ojivy a'ero, ei ga. ");
INSERT INTO pahNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Aerẽ ijara'ga ojipe'ga mondoi yva'ia reruruka novĩa. Igwete g̃a ga akanupanupãi ojigwaraita ga rehe, ei ga. ");
INSERT INTO pahNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Aerẽ ga ojipe'ga mondoukari g̃a pyri. Igwete g̃a ga jukai, ei ga. Koji'ive'g̃a ga g̃a mondomondoi g̃a pyri. Igwete jara'g̃a g̃a g̃a nupanupãi. Jara'g̃a g̃a g̃a jukahetei, ei Jesus'ga imombe'gwovo g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","—Mbapavamo ijara'ga gwa'yra'ga mondoi g̃a pyri. A'ereki ga jate oko ga pyri gara'yra'ga garemia'nguhete'ga. “Omondo po ti g̃a imohina jira'yra'ga rehe,” ei ga oyvyteri pe novĩa, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","—Igwete ijara'ga gwa'yra'ga mondoi g̃a pyri mbapavamo. Ga repiagame hepiakatuhara'g̃a ei ojohupe: “Kiro ga ruri ijara'ga ra'yra'ga,” ei g̃a. “Avova'ea po ti gagwyrag̃wama nehẽ,” ei g̃a. “Tijuka ti ga a'ero. Aerẽ po ti nhande ipojykai yvya nhandejive nehẽ,” ei g̃a ojohupe, ei ga. ");
INSERT INTO pahNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Igwete g̃a ga pyhygi ga jukavo ga momboa garuva'ga remityma hugwi. A'ea Jesus'ga e'i g̃a pe ojo'java'ea mombe'gwovo. ");
INSERT INTO pahNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Igwete Jesus'ga ei no: —Marã po ti ijara'ga rekoi a'ero nehẽ? ei ga. Uhu po ti ga g̃a jukavo nehẽ gwa'yrava'ea repyga nehẽ, ei ga. Igwete ojipe'g̃a po ti ga g̃a mongoi g̃wemityma repiakatuharamo nehẽ, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Nonhi'ig̃i pe me Tupana'ga rembikwatijarukara naerũ? ei ga. Nahã i'ei a'ero: “Onga apohara'g̃a japorame onga ita apopyra hepiagi ojipeji ita. A'ea g̃a imombori ipo'rue'yma tiruahũ javo jupe,” e'i. “Aerẽ akoja jitehe hekoi huvihavamo jara hohe opyryhetero onga pyhykatuavo,” e'i, ei ga. ");
INSERT INTO pahNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","“Nhandepojykaharete'ga reki omongo huvihavamo. Hepiagame nhande nhimomby'ai nanongara ko pyry hete javo,” e'i ikwatijara, ei Jesus'ga imombe'gwovo g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","A'ea Jesus'ga omombe'u judeus'g̃a nduvihava'g̃a pe ojo'java'ea. Igwete g̃a ga pyhypotari novĩa. A'ereki g̃a okwaha reki onhimombe'ua. A'ereki g̃a yva'ia repiakatuhara'g̃a ja. Onga apohara'g̃a ja ko g̃a no. A'ereki g̃a Jesus'ga mombo pota. Kiro g̃a Jesus'ga pyhypotari a'ero novĩa. Emo g̃a okyhyji he'yjuhuve'g̃a hugwi – kiroki g̃a e'i: “Jesus'ga ko Tupana'ga nhi'ig̃a mombe'uharamo oko.” Nurã judeus'g̃a nduvihava'g̃a ga rejari ogwovo. ");
INSERT INTO pahNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Aerẽ judeus'g̃a nduvihava'g̃a fariseus'g̃a mondoukari Jesus'ga pyri. Herodes'gareheve'g̃a g̃a g̃a mondoi ga pyri no. “Pemonhi'ĩ te'varuhu ti Jesus'ga tombotegwete ti ga nhanderuvihavuhu'ga,” ei g̃a g̃a pe g̃a mondorame. ");
INSERT INTO pahNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Igwete g̃a nduri javo Jesus'ga pe. —Orokwaha ore neremimbo'ekatua. A'ereki a'itituhẽva'ea rupi katu nde eremombe'u, ei g̃a ga pe. Nde eremohemba g̃a pe nhaporemo. A'ereki nde nderepojihuvi g̃a javo g̃a pe. Nde nderekoi huvihava'g̃a ndehe jate. A'ereki ahe ojo'jajo'ja nde ve, ei g̃a. Erembo'e katu nde Tupana'ga remimbotarimova'ea rehe. Marã ndereaporog̃ita a'ero? ei g̃a ga pe. César'gareheve'g̃a e'i: “Pemondomondo ti itambere'ia César'ga pe nhanderuvihavuhu'ga pe ga imono'og̃ukarame,” ei g̃a, ei g̃a. Marã naerũ? Timondo po nhande ga pe hamo g̃a poranduvame nhande ve? Mara'ngu po nde javo timondoyme po ga pe hamo? ei g̃a Jesus'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Jesus'ga okwahavipe reki g̃andeaporog̃itate'varuhua. —Maranuhũrame pe nhinhi'ig̃a mbote'varuhupotari? ei ga g̃a pe. Peru itambere'ia moeda, ei ga. ");
INSERT INTO pahNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Igwete g̃a heruri a'ero. —Pemombe'u kiro ji ve a'ero, ei ga g̃a pe. Ma'g̃a ra'angava agwa? Ma'g̃a ndera g̃a okwatija inog̃a hehe? ei ga. A'ero g̃a ei ga pe: —César'ga ra'angava, ei g̃a. Garera g̃a okwatija inog̃a hehe no, ei g̃a ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Igwete Jesus'ga ei g̃a pe: —Pemondoa'ja ti César'ga rembiapoa ga pe a'ero. Tupana'ga rembiapoa ki a'e te pemondoa'ja Tupana'ga pe, ei ga g̃a pe. Yvyakotyve'g̃a pe Jesus'ga ei Tupana'ga rembiapoa tonhimondo ti g̃a onhikwava'eg̃a ga pe javo. Igwete g̃a nhimomby'ai ga rehe onhi'ig̃atu reki ga javo. ");
INSERT INTO pahNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Aerẽ saduceus'g̃a nduri Jesus'ga pyri. Saduceus'g̃a ndogweroviari omanove'g̃a mbogwerahava novĩa. Igwete g̃a nduri Jesus'ga pyri a'ero tihepia ti ganhi'ig̃atua nhande ve javo. Igwete g̃a ei ga pe: ");
INSERT INTO pahNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","—Jesus, Moisésva'ea okwatija inog̃a nhande ve hako. Nahã ahe ei hako: “Po ga manoi gwa'yre'ymame g̃wembirekohẽa mombytavo gairũ'ga po hẽa rerekoi a'ero hamo,” ei ahe. “Gaha po ta'y hẽa pe nhiirũva'ea togwereko gwakykwepohara'g̃a javo,” ei Moisésva'ea hako, ei g̃a Jesus'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Oro marã a'ero? ei g̃a. Sete ahe onhoirũramo, ei g̃a. Igwete ojihuvypyva'ea rembirekoro. Igwete omanorame ahe ndata'yri, ei g̃a. ");
INSERT INTO pahNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Igwete aheakoindava rembirekoro aherembirekokwerava'ea pavẽi oirũva'ea py'rovo. Igwete ahe manoi gwa'yre'ymame. Igwete ahe mbyteramo ahe javijitehe kunhangwerava'ea rerekoi, ndata'yri ve omanomo. ");
INSERT INTO pahNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Jarava'ea na jitehe no, ei g̃a ga pe. Seteva'ea gwereko pa ahe ojopy'ropy'rovo novĩa omanombava gwa'yre'ymamo. Aerẽ kunhangwerava'ea manoi no, ei g̃a. ");
INSERT INTO pahNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Marã a'ero? ei g̃a Jesus'ga pe. Ma'g̃a nembirekoa po ti kunhangwerava'ea rekoi nehẽ ahe kwerava'javame nehẽ? A'ereki seteva'ea gwereko pa kunhangwerava'ea, ei g̃a ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Igwete Jesus'ga ei g̃a pe: —Tupana'ga nhi'ig̃a atyvihu ko penhi'ig̃a, ei ga saduceus'g̃a pe. A'ereki pe ndapekwahavihu Tupana'ga rembikwatijarukara. Ndapekwahavi pe Tupana'ga popoakara no, ei ga. ");
INSERT INTO pahNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Okwerava'japavame po ti g̃a nahembirekoa'javi nehẽ. Tupana'gapyrive'g̃a ja yvagipeve'g̃a ja g̃a ndekoi g̃wembirekoe'ymamo nehẽ, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","G̃akwerava pe pe ei, ei ga. Napenhi'ig̃i pe Moisésva'ea rembikwatijara pe naerũ? A'ereki Tupana'ga i'yva hugwi ikaja pytera hugwi onhi'ig̃a mondo Moisésva'ea pe hako, ei ga. A'ero Moisésva'ea ikwatijari Tupana'ga nhi'ig̃a ojive inog̃a. Tupana'ga e'i ahe ve: “Jihi ko Tupanamo ako. Abraão'ga ji mbohete. Isaque'ga ji mbohete. Jacó'ga ji mbohete,” ei Tupana'ga ahe ve, ei Jesus'ga imombe'gwovo g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Abraãova'ea manorẽ reki Tupana'ga ei Moisésva'ea pe: “Abraão'g̃a ji mbohete,” ei ga. Ga nde'i: “Ahe ji mbohete.” A'ereki g̃a okoji Tupana'ga pe, ei Jesus'ga. Tupana'ga nhi'ig̃a atyvi ko penhi'ig̃a a'ero pe erame omanove'g̃a ndokwerava'javi nehẽ, ei Jesus'ga saduceus'g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Igwete judeus'g̃a mbo'ehara'ga ruri. G̃wendu ga g̃a Jesus'ga monhi'inhi'ig̃ame. “Jesus'ga onhi'ĩkwepy katu reki g̃a,” ei ga oyvyteri pe. Igwete ga ruri javo Jesus'ga pe: —Jesus, ei ga, manamo Tupana'ga remimbo'eagwera huvihavuhu joheva'ero? ");
INSERT INTO pahNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","30","Igwete Jesus'ga ei ga pe: —Moisésva'ea omombe'u ikwatija hako, ei ga. Jara hoheva'ea ko nahã: “Israelitas, pehendu katu ti! Nhandepojykaharete'ga ko Tupana'ga. Gaha jate ko nhandepojykaharetero,” ei ahe, ei ga. “Pearõ hete tuhẽ ti pejipojykaharete'ga Tupana'ga. Pearõ hete tuhẽ ti ga pejipy'a pe. Pearõ hete tuhẽ ti ga imondovo pejeaporog̃ita imohina ga rehe. Pearõ hete tuhẽ ti ga tako ti ji garemimbotarimova'ea rupi javo. Pearõ hete tuhẽ ti pejirokwa pejikovo ga nhi'ĩpo'ruavo,” ei Moisésva'ea, ei Jesus'ga ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Moisésva'ea omombe'u hehohyva'ea no, ei ga. “Penhiarõ pe. Na jitehe ti pearõ hete pejikotyve'g̃a no,” ei ahe, ei ga. A'ea memei Tupana'ga remimbo'eagwera jara hoheva'ero, ei Jesus'ga ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Igwete judeus'g̃a mbo'ehara'ga ei ga pe: —Na tuhẽ. A'itituhẽva'ea nde ei ji ve, ei ga. A'ereki gaha jate oko Tupanamo tuhẽ. Ahã ojipe'g̃a Tupanamo, ei ga Jesus'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Nhande mbatera kwava'eg̃ame ga pe pyry ga pe novĩa, ei ga. Emo pyryheteva'ea ga pe ko na: Tiarõ hete tuhẽ nhande Tupana'ga nhandepy'a pe hamo, ei ga ga pe. Tiarõ hete tuhẽ nhande ga nhandekovo garemimbotarimova'ea rupi hamo, ei ga. Tiarõ hete nhande ojipe'g̃a nhanenhiarõhetea javijitehe hamo. A'ereki nhaneremiarõa koji'iete'i pyry Tupana'ga pe nhanerembikwava'eg̃a hohe, ei ga Jesus'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Jesus'ga g̃wendu onhi'ig̃atua upa. Igwete ga ei ga pe: —Erenhimongo g̃werĩ nde Tupana'ga remimbotarimova'ea rupi kiro, ei Jesus'ga ga pe. Kirẽ ojipe'g̃a ndopojihuva'javi javo Jesus'ga pe a'ero. ");
INSERT INTO pahNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Igwete Jesus'ga g̃ajatykahavuhupeve'g̃a mbo'embo'ei okari pe g̃a mbojapyakavo. Igwete ga ei: —Pe'ji ji ve a'ero. Marã ahembo'ehara'g̃a ei Cristo'ga pe Tupana'ga remimbuhurukara'ga pe ga ko Daviva'ea rymyminoro javo? ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","A'ereki Daviva'ea tuhẽ omombe'u nhog̃wenonde hako. Nahã ahe ei hako: “Tupana'ga e'i jipojykaharete'ga pe: ‘Eapy ji pyri ekovo huvihavamo,’ ei ga,” ei ahe. “‘Tamongo ti nearõe'ỹve'g̃a neremimbotarimova'ea rehe.’ A'ea Tupana'ga ei jipojykaharete'ga pe,” ei Daviva'ea ikwatija hako, ei Jesus'ga. A'ereki Tupana'ga ra'uva Daviva'ea mbo'euka a'ea rehe ikwatijaruka hako, ei ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Daviva'ea e'i Cristo'ga pe jipojykaharete'ga a'ero, ei ga. Ga ko Daviva'ea rymymino'ga jate rũi naerũ, ei Jesus'ga onhimombe'gwovo g̃a pe g̃a mbojapyakavo. Oarõ hete g̃a ganhi'ig̃a a'ero onhimongyheteavo. ");
INSERT INTO pahNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Igwete Jesus'ga ei g̃a mbo'eavo: —Ahembo'ehara'g̃a ja rũi ti peko, ei ga. A'ereki g̃a onhimbohete hete. Oko hete g̃a opipukuhua rehe tajirepia g̃a javo, ei ga. Opota hete g̃a ojipe'g̃a nhi'ig̃aturame ojive ima'ẽhai pe pe ko orembo'ehara javo g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","G̃ajatykahava pype g̃a apypotari huvihava'g̃a apykava rehe. Toryva jara'g̃a pyri g̃a o'u pota toryvi pe oina, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Opojyka g̃a aherembirekokwera'g̃a mbatera. Igwete g̃a nhi'imbukuhui Tupana'ga pe novĩa ojipe'g̃a ti te'i pyry ore ve javo. Hahyva'ea po ti kaitu Tupana'ga imondoi g̃a pe a'ero nehẽ, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Igwete Jesus'ga apygi upa g̃ajatykahavuhua pype itambere'ia ryru'ia pyri. He'yjuhuve'g̃a ga gwepia g̃a inog̃ame itambere'ia Tupana'ga pe hyru'ia pype. Imbateheteve'g̃a he'yi inog̃i ipype novĩa. ");
INSERT INTO pahNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Nanime imbatere'ỹvehẽa ruri aherembirekokwerahẽa. Igwete mokoi'ĩ hẽa inog̃i itambere'ia moedas ipype. ");
INSERT INTO pahNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Igwete Jesus'ga ei g̃wemimbo'ehara'g̃a pe: —Hepejijo aherembirekokwerahẽa repiaga imbatere'ỹvehẽa, ei ga g̃a pe. Tamombe'u katu ti pe me: Hẽaremimondoa koji'i pyry Tupana'ga pe ojipe'g̃a nemimondoa hohe. ");
INSERT INTO pahNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","A'ereki he'yiva'ea g̃a omombyta ojive itambere'ia imondorame, ei ga. Hẽa ki a'e te mokoi'ĩ jate gwereko itambere'ia novĩa. Emo hẽa omondo pa ipype, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Jesus'ga horame g̃ajatykahavuhua hugwi garemimbo'ehara'ga ei ga pe: —Jesus, ehepia! Ikatu hete nhandejatykahavuhua, ei ga. Itaruvihavuhua pyvõ g̃a japojapoi po raka'e, ei ga Jesus'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Igwete Jesus'ga ei ga pe: —Erehepia nde nhandejatykahavuhua novĩa? ei ga. Aerẽ po ti ndojikojikoga'javi ojogwehe itaruvihavuhua nehẽ. Omonduru pa po ti g̃a ojohugwiugwi inog̃a nehẽ, ei Jesus'ga ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Aerẽ Jesus'g̃a hoi yvytyruhu pe – perope oliveiras ndyvuhu pe monte das Oliveiras pe. Pevo ga apygi oina g̃ajatykahavuhua rovai pyteri pe. Igwete g̃a nduvi ga pyri Pedro'ga Tiagova'ea no João'ga André'ga. Jara'g̃a ndovakie'ỹ g̃a ei Jesus'ga pe: ");
INSERT INTO pahNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","—Emombe'u ti ore ve, ei g̃a. Maname po ti g̃a nhandejatykahavuhua mondurundurupavi inog̃a nehẽ? Marãva'ea po ti Tupana'ga hepiukari na'ẽ ahemonhimomby'ava'ea nehẽ ira'agwe hekopavame nehẽ? ei g̃a ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Igwete Jesus'ga ei g̃a pe: —Penhimboko'i ti pejikovo penhimoandyandyja hugwi. ");
INSERT INTO pahNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Aerẽ po ti g̃a ndug̃anduri onhimongyavo javo tehe nehẽ. Nhira'ãra'ãteheavo po ti g̃a ei: “Jihi ko Cristoramo ako Tupana'ga remimbuhurukaramo,” e'i tehe po ti g̃a nehẽ, ei ga. A'ea rehe po ti g̃a he'yjuhuve'g̃a moandyandyi nehẽ, ei ga. ");
INSERT INTO pahNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Nahã po ti nehẽ no. Aerẽ po ti g̃a imombe'ui nehẽ: “Ira'agwe g̃a otavuka g̃a pe kiro. Paivohu ojipe'g̃a tavukari g̃a pe no,” e'i po ti g̃a pe me nehẽ, ei ga. Tapembojui ti pejipy'a a'ea rehe, ei Jesus'ga g̃a pe. Na tuhẽ ti hekoi nehẽ. Emo po ti a'ea rupi mbapavakotyva'ea rũi nehẽ, ei ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Ojipe'g̃a gwyripeve'g̃a po ti otavukavuka ojipe'g̃a gwyripeve'g̃a pe nehẽ, ei ga. Omyomyi po ti yvya avo nehẽ. Pevo po ti yvya imyimyi nehẽ no. Momina po ti mbatera i'uhavamo nehẽ, ei ga. Nahã po ti hahy rambugwe yvyakotyve'g̃a pe nehẽ, ei ga. Kunhangwera'g̃a gwa'yra'g̃a mbo'ag̃werĩrame hahy rambugwe g̃a pe. Na jitehe po ti hahy rambugwe yvyakotyve'g̃a pe nehẽ mbapava koty nehẽ no, ei Jesus'ga imombe'gwovo g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","—Penhimboko'i ti, ei ga g̃a pe. Pe jireheva'ea g̃waramo po ti nhiarõe'ỹve'g̃a pe pyhygi pe nderogwovo imohig̃atuhara'g̃a pyri nehẽ. Ojatykahava pype po ti g̃a pe nupanupãi nehẽ, ei ga. G̃a po ti pe nderohoi gwuvihavuhu'g̃a pyri governadores'g̃a pyri nehẽ no g̃a ko Jesus'gareheva'ero javo nehẽ. Pevo po ti pe ami a'ero penhimombe'ukatuavo g̃a pe nehẽ, ei ga. ");
INSERT INTO pahNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Jireheve'g̃a po ti imombe'umbe'ui na'ẽ pyryva'ea ojipe'g̃a gwyripeve'g̃a pe nhaporemo ji mombe'gwovo g̃a pe nehẽ. Aerẽ po ti ihoi mbapavakotyva'ea apiavo nehẽ, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","G̃a po ti pe pyhy pe nderogwovo imohig̃atuhara'g̃a pyri nehẽ. Pe nderohorame tapemomyi ti pejipy'a penhi'ig̃ag̃wama rehe nehẽ marãi po ti ji g̃a pe javo nehẽ, ei ga g̃a pe. Ihorame penhi'ig̃a apiavo po ti Tupana'ga ra'uva ikwahavukari pe me pe mbo'eavo nehẽ, ei ga. A'ero po ti pehe jate rũi pe nhi'ig̃i nehẽ. Tupana'ga ra'uva pe monhi'ĩ nehẽ, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","—Gwe'yja'g̃a vehevi po ti g̃a g̃a mondoukari g̃apo pe nehẽ tojuka ti g̃a g̃a javo nehẽ. Jara'g̃a po ti oirũ'g̃a mondoukari g̃apo pe nehẽ, ei ga. Jara'g̃a po ti gwa'yra'g̃a mondoukari tojuka g̃a javo. Jara'g̃a po ti g̃a nhimonha'ngai uva'g̃a ndehe g̃a jukavouka nehẽ, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Okouhu pa po ti g̃a pe ndehe nehẽ pe jireheva'ero g̃waramo nehẽ. Po ti pe nhimboitai avuirama pejipohire'yma ji hugwi nehẽ, a'ero po ti Tupana'ga pe mongoi ojipyri nehẽ, ei Jesus'ga imombe'gwovo g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Igwete Jesus'ga ei g̃wemimbo'ehara'g̃a pe no: —Aerẽ po ti pe hepiagi ite'varuhuheteheteva'ea i'ama nehẽ – pevo po no'amuhũi ramo, ei ga. Tupana'ga noaronhuhũ a'ea opohia judeus'g̃a jatykahavuhua hugwi a'ea rehe nehẽ, ei ga. (Kiroki ga onhi'ĩ kiro ikwatijara pe – tokwaha ti ga a'ea.) Aerẽ po ti pe a'ea repiagi pevo nehẽ, ei Jesus'ga g̃a pe. Pe hepiagame Judéiapeve'g̃a ti toka'nhyka'nhy onhana yvytyruhu pe xamanoyme ti javo nehẽ, ei ga. ");
INSERT INTO pahNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Kiroki g̃a oko ongapereuhuva'ea arimo a'ea rupi – tojyvipe ti g̃a ogwovo okie'yma onga pype ombatera rerogwovo nehẽ. Toka'nhymipe ti g̃a onhana, ei ga. ");
INSERT INTO pahNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Kiroki g̃a oporavyky ko pe a'ea rupi – tojivyryme ti g̃a onga pe tapy'ynhapira rerogwovo nehẽ, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","—Iporia'i po ti ipuru'ave'g̃a a'ea rupi oka'nhypotarame nehẽ. Iporia'i po ti omoka'mbuve'g̃a no gwa'yra'g̃a nenonhambotarame nehẽ, ei ga. ");
INSERT INTO pahNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Pe'ji ti Tupana'ga pe a'ero turyme ti akoja hahyva'ea yapohua rupi. A'ereki ahe nonhani gwerevi oka'nhyma a'ea rupi, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Ite'varuhuheteheteva'ea urame po ti hahy hete g̃a pe nehẽ. Nanongara ndogwerekoa'javi Tupana'ga rembiapoagwera jate hako. Aerẽ po ti ndogwerekoa'javi nanongara nehẽ no, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Hahyheteva'ea po ti tiruahũ ranuhũ g̃a pe nehẽ, ei ga. Hahyheteva'eag̃wama rehe ojapyakarame Tupana'ga ei hako: “Po ti okombegwe hahyheteva'ea g̃a pe nehẽ, a'ero po ti g̃a papavi nehẽ,” ei ga hako, ei Jesus'ga g̃a pe. Tupana'ga nhag̃ataruhu a'ero g̃a ndehe okovo – kiroki g̃a ga omo'emo'ẽ ojive. Nurã ga ei: “Namombegweukari ti ji hahyva'ea g̃a pe a'ero nehẽ,” ei Tupana'ga hako, ei ga imombe'gwovo g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Igwete Jesus'ga ei g̃a pe no: —Po ti ojipe'g̃a etehei pe me nehẽ: “Pehepia. Agwa ko Cristo'ga Tupana'ga remimbuhurukara'ga.” Taperoviari ti g̃a a'ero nehẽ, ei ga g̃a pe. Po ti ojipe'g̃a etehei pe me nehẽ: “Pehepia. Cristo'ga ko pevo u.” Taperoviari ti g̃a na jitehe no, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Aerẽ po ti ojipe'g̃a ndug̃anduri nehẽ jihi ko ako Cristoramo Tupana'ga remimbuhurukaramo javo tehe nehẽ. Ojipe'g̃a po ti g̃a ndug̃anduri nehẽ no jihi Tupana'ga nhi'ig̃a mombe'uharamo javo tehe nehẽ, ei ga. Ahemonhimomby'ava'ea po ti g̃a japojapoi hepiuka nehẽ timoandyandyi ti g̃a javo nehẽ. Tupana'ga remimo'ẽhara'g̃a vehevi po ti g̃a g̃a moandyandyipotari nehẽ novĩa, ei ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Penhimboko'i ti a'ero pejikovo. A'ereki ji amombe'u jipe pe me pe momoranduva tapemoandyandyjukaryme ti g̃a javo, ei Jesus'ga imombe'gwovo g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Igwete Jesus'ga ei g̃wemimbo'ehara'g̃a pe no: —Hahypavirẽ “po ti igwevi kwara nehẽ. Jahya po ti nombokojahua'javi nehẽ no”, ei ga. ");
INSERT INTO pahNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","“Jaytata'ia po ti indurundurugi yvaga hugwi nehẽ. Yvagipeva'ea po ti ig̃wyg̃wymi nehẽ ipopoakava'ea”, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","A'ero po ti yvyakotyve'g̃a jirura'java repiagi nehẽ. Yvag̃atig̃a pype po ti ji ruri nehẽ jipopoakahetea pyvõ. Nhirendy'ja hete po ti ji jitua nehẽ, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","A'ero po ti ji ei jipyrive'g̃a pe yvagipeve'g̃a pe nehẽ: “Peho ti kiro nhiremimo'ẽhara'g̃a nderua nehẽ,” a'e po ti ji javo g̃a pe nehẽ, ei ga. A'ero po ti g̃a hoi g̃a mono'og̃a g̃a nderupava g̃agwyg̃agwyra hugwi nhaporemo nehẽ. Gweru po ti g̃a g̃a kwara pora hugwi kwara hoa hugwi no tyapyra hugwi nhimbya hugwi no, ei Jesus'ga imombe'gwovo g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Igwete Jesus'ga ei g̃wemimbo'ehara'g̃a pe no: —“Maname po ti ihoi japiavo nehẽ?” pe'ji ko pe ji ve ko. Penhimbo'e ti a'itituhẽva'ea rehe figo'yva repiaga a'ero, ei ga g̃a pe. Pe hepiagame figo'yva huangy'ria, a'ero pe ei jipi: “Kwaria g̃werĩ kiro.” ");
INSERT INTO pahNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Na jitehe hepiagame hahyheteva'ea po ti pe ei nehẽ: “Kiro mbapava koty,” ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Amombe'u katu ji pe me, ei ga. Ag̃wamove'g̃a ndekojirame po ti akoja ihopavi japiavo nehẽ, ei ga. ");
INSERT INTO pahNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Aerẽ po ti ahana'ja kwara. Yvya po ti ahana'ja nehẽ no. Nhirembi'ea ki a'e te okoe'ymi a'itituhẽva'ero opopoakaramo avuirama nehẽ, ei Jesus'ga imombe'gwovo g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Igwete Jesus'ga ei g̃a pe: —Ahe ndokwahavi kwara jirura'javame nehẽ marananime po ti nehẽ javo, ei ga. Tupana'gapyrive'g̃a yvagipeve'g̃a ndokwahavi. Ji vehevi Tupana'ga ra'yramo ndakwahavi no, ei ga. Jiruva'ga jate okwaha jirura'jahava, ei ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Penhimboko'i ti. Pejirokwa ti nhinhi'ig̃a rendukatua rehe ji mboha'uva. A'ereki pe ndapekwahavi jirura'jahava, ei ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","36","Igwete ga ei g̃a pe no: —Tamombe'u ti pe me jirura'java javijiteheva'ea a'ero, ei ga. A'ereki ji ko onga jara'ga ja – kiroki ga oho ojipe'g̃a gwyri pe. Ohorame ga ei ojipyrive'g̃a pe: “Pereko katu ti nhimbatera ji ve jirakykweri,” ei ga g̃a pe, ei ga. G̃a mbojogwetavamo ga g̃a mboporavykyi a'ero g̃a mbojogwerekovo. Ojipe'ga pe ga ei: “Mytu'ẽ me e'ã hepiakatuavo nhironga,” ei ga, ei ga. G̃a ndokwahavi reki ijara'ga rurag̃wama, ei Jesus'ga g̃a pe. Po ti hepiakatuhara'ga ndohepiakatui garonga okia ga rura'javame nehẽ, a'ero po ti ijara'ga hepiagi ga kirame nehẽ, ei Jesus'ga imombe'gwovo g̃a pe. —Na jitehe ji ei pe me a'ero: Pejirokwa ti nhinhi'ig̃a rendukatua rehe, ei Jesus'ga g̃a pe. A'ereki pe ndapekwahavi jirura'jahava nehẽ. Mara'ngu po ti ypytunimo jitua nehẽ ypyhaji katu nehẽ? ei ga. Mara'ngu po ti ko'eg̃atue'yma rupi jitua nehẽ? ei ga g̃a pe. Pe nhimboha'uve'ymame po ti ji rura'javi nehẽ, ei ga. Po ti pe ndapejirokwari nhinhi'ig̃a rendukatua rehe ji rura'javame nehẽ, a'ero po ti ji hepiagi pejirokware'yma nehẽ! ei ga. ");
INSERT INTO pahNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Pejirokwa ti hehe a'ero, a'e ji pe me, ei ga. Poro jitehe ji ei jireheve'g̃a pe nhaporemo no. Pejirokwa tuhẽ ti hehe, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Aerẽ judeus'g̃a japog̃werĩrame toryva ikwava'ẽhara'g̃a nduvihava'g̃a nhomonhi'ig̃i ojogwerekovo judeus'g̃a mbo'ehara'g̃a pavẽi. Yapoa rupie'ymi judeus'g̃a mokõi japoi toryva. A'ea rupi memei g̃a japyakai g̃wamonhava'ea ruragwera rehe Egitopeve'g̃a gwyra hugwi. Ojipejiva'ea pe g̃a ei Páscoa. Ojipea rupi toryva rupi ko g̃a i'ui pão ndovuriva'ea jipi. Kiro judeus'g̃a toryva japog̃werĩrame ikwava'ẽhara'g̃a nduvihava'g̃a nhomonhi'ig̃i judeus'g̃a mbo'ehara'g̃a pavẽi ojogwerekovo. —Marã re po ti nhande Jesus'ga pyhynhimimukari ga jukavouka nehẽ? ei g̃a ojohupe. Mokõi nhande kirame po ti nhande japoukari toryva nehẽ, ei g̃a. ");
INSERT INTO pahNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","A'ea rupi rũi po ti nhande ga pyhygukari he'yjuhuve'g̃a ti tojogwayvayvaryme ga rehe, ei g̃a ojohupe. ");
INSERT INTO pahNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Igwete Jesus'ga rekoi cidade de Betânia pe. Igwete ga i'ui mbatera ijaijauhugwera'ga ronga pe Simão'ga ronga pe. Nanime hẽa heruri perfume nhandya hyru'ia pype. He'yjuhu hẽa omondo itambere'ia nhandya rehe imombaravipyre'ỹva'ea rehe. Igwete hẽa heruri ika'mbiga hovapytymbava heka'voga Jesus'ga akag̃a rehe. ");
INSERT INTO pahNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","A'ero jara'g̃a nhimonha'ngai hẽa rehe. —Maranuhũrame hẽa jigwaraiteheuhui nhandya rehe? ei g̃a ojohupe. ");
INSERT INTO pahNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","He'yjuhuva'ea itambere'ia trezentos po g̃a ikwepygi hẽa pe nhandya rehe ramo. A'ero po hẽa imondoi itambere'ia imbatere'ỹve'g̃a pe ramo, ei g̃a. Emo hẽa gweka'vopavipe reki Jesus'ga akag̃a rehe, ei g̃a ojohupe. Igwete g̃a nhimboahivi onhi'ig̃ahyavo hẽa pe. ");
INSERT INTO pahNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Emo Jesus'ga e'i g̃a pe: —Na hẽa rekoi jate. Maranuhũrame pe hẽa mbote'varuhu pota? ei ga g̃a pe. A'ereki hẽa oko katu katu imbuhua ji ve, ei ga. ");
INSERT INTO pahNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Nane'ymi po g̃a ndekoi pe pavẽi imbatere'ỹve'g̃a jipi. Pe g̃a pokopotarame po pe g̃a pokogi jipi. Ji po ti a'ea nakombegwei pe pyri nehẽ, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Nanongara jate hẽa gwereko, nanongara hẽa ombuhu ji ve. Ji manoa renonde hẽa imongyi nhandya jira'oa rehe nhitỹhava rupiaramo, ei ga. ");
INSERT INTO pahNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Tamombe'u katu ti pe me: Yvyakotyve'g̃a pe nhaporemo ti g̃a imombe'ui pyryva'ea ji mombe'gwovo nehẽ. A'ea rupi ti g̃a hẽa mombe'ui nehẽ no tokwaha pa ti g̃a hẽaremimbuhuragwera, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Aerẽ Judas Iscariotesva'ea – ahe ko dozeve'g̃a pyteripeva'ea Jesus'ga remimbo'eharava'ea novĩa – kiro ahe hoi ikwava'ẽhara'g̃a nduvihava'g̃a pyri. Igwete ahe ei g̃a pe: —Tapyhyguka ti Jesus'ga pe me, ei Judas Iscariotesva'ea g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Igwete g̃a ndoryndoryvamo ahe renduvame. —Toromondo ti itambere'ia nde ve gapyhygukara ikwepykavamo a'ero, ei g̃a ahe ve. Aerẽ ahe jirokwapotari hehe a'ero, marã po ti ji ga pyhygukari g̃a pe javo. ");
INSERT INTO pahNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Kiro Jesus'ga remimbo'ehara'g̃a nduri Jesus'ga pyri. A'ereki judeus'g̃a oapouka kiro toryva – kiroki a'ea rupi g̃a o'u pão ndovuriva'ea. A'ea rupi jitehe judeus'g̃a ojuka cordeiros Páscoa rupiaramo ti'u javo. Cordeiros jukahava rupi garemimbo'ehara'g̃a nduri Jesus'ga pyri. Igwete g̃a ei ga pe: —Mome po ti ore hoi Páscoa rupiara imboavujikwea nde i'ui nehẽ? ei g̃a ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Igwete ga ei mokonha'g̃a pe: —Hepejigwovo cidade pe. A'ero po ti pevove'ga pe novatĩ yhya rerua hyrua pype nehẽ, ei ga. Peho ti ga reviri. ");
INSERT INTO pahNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Ga horame onga pype ti pe'ji onga jara'ga pe, ei ga. Pe'ji ti ga pe: “Nhanembo'ehara'ga e'i nde ve: ‘Mome i'ukava ruvi? Ta'u ti mbatera pevo nhiremimbo'ehara'g̃a pavẽi,’ ei ga nde ve.” Peho ti javo ga pe a'ero, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","A'ero ti ga hepiukari pe me i'ukavuhua onga jo'aripeva'ea. Pevo gwereko jipe mesa aheapykava. Pevo ti pemboavujikwe mbatera nhande ve a'ero nehẽ, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Nahã ga mokonha'g̃a mondoukari cidade pe. Igwete g̃a hepiapavi garemimombe'ua. Igwete g̃a imboavujikweri mbatera inog̃a Páscoa rupiara. ");
INSERT INTO pahNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Ypytunimo Jesus'ga dozeve'g̃a nderohoi pevo g̃a nderokiavo. ");
INSERT INTO pahNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Igwete g̃a i'ui ojopyri upa. Igwete Jesus'ga ei g̃a pe: —Amombe'u katu ji kiro pe me: Pepyteripeve'ga po ti ji pyhyguka ji mondovouka g̃apo pe nehẽ, ei ga. O'u ga kiro ji pavẽi, ei ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","A'ero g̃a ndovy'ari okovo. Onhinanhinani g̃a ei ga pe: —Ji rũi re po? ei g̃a ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","—Ga ko opymi pão tyhya pype ji pavẽi i'gwovo pepyteripeve'ga, ei Jesus'ga dozeve'g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Kiro po ti ji manoi nehẽ. A'ereki kiro oho japiavo nhimombe'upyra – kiroki a'ea ahe okwatija ji mombe'gwovo hako, ei ga. Emo tiruahũ hete ti ga pe – kiroki ga ji mondouka g̃apo pe. Po ga ndojihuvi hamo, a'ero po koji'i pyry ga pe hamo. Tupana'ga po ti ombohahy hete ga pe nehẽ, ei ga. ");
INSERT INTO pahNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","G̃a i'urame Jesus'ga ipyhygi pão. Igwete ga nhi'ig̃i Tupana'ga pe ndepyry hete nde imbuhua ore ve javo. A'ero ga haygwe'rogi ima'ema'eamo g̃wemimbo'ehara'g̃a pe. Igwete ga ei g̃a pe: —Pepyhy i'gwovo. A'ea ko jira'oa, a'e ji jupe, ei ga. ");
INSERT INTO pahNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Aerẽ ga ipyhygi copo – kiroki gwereko vinho. Igwete ga nhi'ig̃i Tupana'ga pe ndepyry hete nde imbuhua javo. A'ero ga imondoi g̃a pe. Igwete g̃a nhaporemo i'ui jugwi a'ero upa. ");
INSERT INTO pahNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Igwete Jesus'ga ei g̃a pe: —A'ea ko jirekoa, a'e ji jupe, ei ga. Aheka'voguka po ti ji jirekoa g̃a pe jijijukauka nehẽ, ei ga. Nahã po ti ji manoi yvyakotyve'g̃a ndepyga. A'ereki Tupana'ga e'i ipyahuva'ea mombe'gwovo: “Garekoa reka'vogame po ti ji imombori g̃andekote'varuhua g̃a hugwi,” ei ga. Nurã jirekoa reka'voga g̃waramo a'iti hete tuhẽ po ti Tupana'ga imombori he'yjuhuve'g̃a ndekote'varuhua g̃a hugwi nehẽ g̃wembi'ea rupi nehẽ, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Amombe'u katu ji pe me: Kiro ti ji nda'apoa'javukari nanongara toryva vinho gwovo pe nderekovo nehẽ. Aerẽ po ti nhanderuvihavuhuhetero Tupana'ga japoukari ji ve toryva g̃wonga pe yvagi pe nehẽ. A'ea rupi po ti ji japoi toryva nhande ve a'ero nehẽ hajiheva'ea ipyahuva'ea, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Igwete g̃a nhimby'yi Tupana'ga mboheteavo aerẽ ogwovo monte das Oliveiras pe. ");
INSERT INTO pahNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Igwete Jesus'ga ei g̃a pe: —Pepohi pa ti pe ji hugwi nehẽ, ei ga. A'ereki Tupana'ga rembikwatijarukara omombe'u nhog̃wenonde a'ea, ei ga. Ikwatijara omombe'u Tupana'ga nhi'ig̃a hako. “Tupana'ga e'i: ‘Tajukauka ti ovelhas repiakatuhara'ga nehẽ,’ ei ga. ‘Ga jukarame po ti ovelhas nhig̃waheg̃wahemi nehẽ,’ ei Tupana'ga hako,” ei ga. Igwete Jesus'ga ei no: —Pe po ti na jitehe a'ero nehẽ no. G̃a ji jukarame po ti pe nhig̃wahembavi nehẽ no, ei ga. ");
INSERT INTO pahNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Emo nhimbogweravirẽ nhimanoa hugwi po ti ji hoi Galiléiapeve'g̃a gwyri pe jitekovo pe nenonde nehẽ, ei ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Igwete Pedro'ga ei ga pe: —Jara'g̃a po ti opohipavipe nde hugwi. Jihi po ti ndapohirag̃wami nde hugwi, ei ga Jesus'ga pe novĩa. ");
INSERT INTO pahNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Igwete Jesus'ga ei ga pe: —A'itituhẽva'ea ti ji ei nde ve: Kirog̃we ypytunimo inamutig̃a nhi'ig̃a renonde po ti nde ei ji ve nehẽ: “Ji ndakwahavi Jesus'ga.” Três po ti nde ea'jaa'javi ji ve nehẽ. Kirẽ po ti mokõi inhi'ig̃a'javi inamutig̃a nehẽ, ei Jesus'ga ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Igwete Pedro'ga nhi'ig̃ahyi ga pe: —Po ti g̃a ji jukai nde reheve, a'ero po ti ji nda'ei tuhẽ te a'ea nde ve nehẽ, ei ga. A'ea jitehe jara'g̃a ei Jesus'ga pe no. ");
INSERT INTO pahNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Igwete Jesus'g̃a hoi Getsêmani pe. Igwete ga ei g̃wemimbo'ehara'g̃a pe: —Avo pejuvete pejiapyapyga, ei ga. Taho na'ẽ ti nhinhi'ig̃a Tupana'ga pe, ei ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Igwete ga g̃a nderohoi Pedro'ga Tiagova'ea. João'ga ga gweroho no. Kiro omboju hete Jesus'ga opy'a. Ndovy'arihu hete ga. ");
INSERT INTO pahNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Igwete ga ei g̃a pe: —Jivy'are'yma ji juka g̃werĩ, ei ga. Avo ti pepyta pejikire'yma, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Hehemo'i ga hoi a'ero. Igwete ga nhinog̃i ojovapyvo onhi'ig̃a Tupana'ga pe. —Nde ipotarame terembuhurukari hahyva'ea ji apiavouka, ei Jesus'ga ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Apĩ, ei ga, nde erekwaha imongopava neremimbotarimova'ea rehe. Nurã ji ei nde ve: Terembuhurukari hahyva'ea ji ve a'ero, ei ga. Emo nhiremimbotarimova'ea rupi rũi ti eko. Enhimimbotarimova'ea rupi ti eko, ei Jesus'ga ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Kirẽ ga jivyra'javi ua trêsve'g̃a ndepiaga. Oki pa reki g̃a upa. Igwete ga ei Pedro'ga pe: —Simão Pedro, ei ga. Ereki nde ejupa? Nerenhimomiranami'i'ĩ nde ejopehyja pe naerũ? ei ga ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Tapekiri ti, a'e ko ji pe me ko, ei ga. Penhi'ĩ ti Tupana'ga pe. Pe'ji ti ga pe: “Ore poko ti torokote'varuhupotaryme ti ore,” pe'ji ti Tupana'ga pe, ei ga. Peko pota pe Tupana'ga nhi'ig̃a rupi novĩa. Emo Tupana'ga pe pokoge'ymame pe napenhimomiranami pete'varuhuro g̃waramo, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Igwete Jesus'ga hoa'javi onhi'ig̃a Tupana'ga pe. —Nde ipotarame terembuhurukari hahyva'ea ji ve, e'ia'ja ga Tupana'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Aerẽ ga rura'javi trêsve'g̃a pyri. Okipava'ja g̃a upa. A'ereki ura'ja g̃a pe g̃a ndopehyihetea. Nonhi'ig̃a'uvi g̃a ga pe a'ero. ");
INSERT INTO pahNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Igwete ga hoa'javi onhi'ig̃a Tupana'ga pe. Aerẽ ga jivyra'javi trêsve'g̃a pyri. —Pekirijiuhu pe pejijupa? ei Jesus'ga g̃a pe. Kirupi pekiratete, ei ga. Kiro ihoi japiavo ji pyhygukahava. Kiro po ti g̃a ji kwava'eg̃i okote'varuhuve'g̃a po pe nehẽ, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Pevy kirog̃we. Pehepia. Kiro ki ga u jipyhygukahara'ga. Xaho ga rovatiamo a'ero, ei ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Jesus'ga nhi'ig̃ame g̃wemimbo'ehara'g̃a pe kiro Judasva'ea ruri pea rupi – kiroki ahe dozeve'g̃a pyteripeva'ea garemimbo'eharava'ea novĩa. He'yjuhuve'g̃a ahe gweru ojupi. A'ereki xava'eve'g̃a ikwava'ẽhara'g̃a nduvihava'g̃a no judeus'g̃a mbo'ehara'g̃a no – judeus'g̃a mog̃itahara'g̃a nhaporemo ombuhuruka he'yjuhuve'g̃a Judasva'ea rupi topyhy ti g̃a Jesus'ga javo. G̃a gweru itakyhea'javuhuva'ea mbuahava reheve a'ero. ");
INSERT INTO pahNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Judasva'ea e'i jipe g̃a pe: —Tabeija na'ẽ ti Jesus'ga repiuka pe me. A'ero ti pepyhygahy ga rerogwovo, ei ahe g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Kiro Judasva'ea ruri a'ero ogwovo Jesus'ga rehei katu. —Kiro ji ruri nde pyri, ei ahe Jesus'ga pe ombo'ehara'ga pe. Igwete ahe Jesus'ga beijai. ");
INSERT INTO pahNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Kiro g̃a Jesus'ga pyhygi a'ero. ");
INSERT INTO pahNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Pevo Jesus'gareheve'ga rekoi o'ama Jesus'g̃a pavẽi. Igwete ga ipyhygi oitakyhea'javuhuva'ea takyti g̃a javo novĩa. A'ea ga imondoi ikwava'ẽhara'g̃a nduvihavuhu'gapyrive'ga rehe ga nambi'oga novĩa. ");
INSERT INTO pahNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Igwete Jesus'ga ei pevove'g̃a pe: —Amovahĩ po ji governo naerũ? ei ga. Nurã pe heruruhui itakyhea'javuhuva'ea mbuahava reheve ji pyhyga naerũ? ei ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Nane'ymi ji rekoi pe pavẽi nhandejatykahavuhua rokari pe g̃a mbo'eavo jipi, ei ga. A'ea rupi pe ndajipyhyguhui oji'i. Emo pe ji pyhyguka kiro aherembikwatijaragwera rupi ahenhi'ĩpo'ruavo, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Igwete Jesus'ga remimbo'ehara'g̃a pohipavi ga hugwi onhana oka'nhyma. A'ero Jesus'ga pyhyhara'g̃a ga rerohoi ga rerekovo. ");
INSERT INTO pahNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Igwete ipyahuve'ga ruri Jesus'ga reviri. Ojipeji opira ga omongi herua i'arimova'ea jate. Igwete Jesus'ga pyhyhara'g̃a ga pyhypotari novĩa. Emo gapiratehea g̃a opyhy. ");
INSERT INTO pahNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Igwete ga hemi jugwi taka'nhy ti g̃a hugwi javo. Igwete ga henonhani opire'yma rerogwovo a'ero. ");
INSERT INTO pahNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","56","Igwete g̃a Jesus'ga rerohoi ikwava'ẽhara'g̃a nduvihavuhu'ga ronga pe Caifás'ga ronga pe. Oro Pedro'ga, irupe ga ruri Jesus'ga reviri okari pe ovahema. Pevo ga apygi guardas'g̃a pavẽi ojipe'eavo tata ypyvo. Igwete g̃a Jesus'ga rerohoi onga pe. A'ero judeus'g̃a mog̃itahara'g̃a jatykatykapavi ikwava'ẽhara'g̃a nduvihava'g̃a jara'g̃a pavẽi. G̃ahã tuhẽ ojatyka jipi henduva judeus'g̃a nhi'ig̃a g̃a imbojarame mbatera ojipe'g̃a ndehe. Igwete judeus'g̃a mog̃itahara'g̃a nhaporemo ojipe'g̃a ndekari kiro tombojamboja ti g̃a ite'varuhuva'ea Jesus'ga rehe javo. A'ereki g̃a ojukauka pota ga. He'yi reki g̃a novĩa – kiroki g̃a u o'mbeo'mbero nahã Jesus'ga rekote'varuhui javo tehe. Emo ndojo'jajo'javi reki g̃anhi'ig̃a. Nurã g̃amog̃itahara'g̃a nde'i: “A'iti gamombe'ua. Nurã tijuka ga,” nde'i g̃a. ");
INSERT INTO pahNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","58","Aerẽ ojipe'g̃a po'ami o'mbero g̃a pe. Igwete g̃a etehei: —Orohendu ore Jesus'ga nhi'ig̃a ikwehe, ei g̃a. “Tamondurunduru ti ag̃a Tupana'ga ruhava,” e ko ga ikwehe, e'i tehe g̃a. “Akwaimbae'g̃a oapo agwa,” ei ga. “Emo mokõi ti ji herokiri japopava irũa nehẽ – kiroki yvyakotyve'g̃a ndoapokwahavi,” ei ga, ei g̃a imombe'uteheavo g̃a pe novĩa. ");
INSERT INTO pahNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Emo g̃anhi'ig̃a vehevi ndojo'javi. ");
INSERT INTO pahNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Igwete Caifás'ga po'ami ua g̃andovai pyteri pe. Igwete ga ei Jesus'ga pe: —Marãi nde a'ero ejihe g̃a imbojambojarame naerũ? ei ga. Nerenhimombe'uuhui nde ekovo naerũ? ei ga Jesus'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Jesus'ga nonhi'ig̃i reki upa onhi'ĩpotare'yma g̃waramo. Igwete ga ea'javi Jesus'ga pe: —Ndehe re koi Cristoramo ereko naerũ Tupana'ga remimbuhurukaramo? Nde ereko nhaneremimbohetehara'ga ra'yramo Tupana'ga ra'yramo? ei ga. Enhimombe'u katu ti ore ve a'ero, ei ga ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","—A'ea ko ji. Tupana'ga ji mbuhuruka avo yvya koty, ei Jesus'ga ga pe. Igwete po ti pe ji repiagi nehẽ ji apygame ipopoakaheteve'ga pyri Tupana'ga pyri jitekovo huvihavamo nehẽ, ei ga. Pehepia po ti pe ji rura'javame yvag̃atig̃a pype ua yvya koty nehẽ no, ei Jesus'ga ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Igwete Caifás'ga nhimboahihetei Jesus'ga nhi'ig̃a henduvame. Nurã ga imbotararagi opira onhimongouhu ga Tupana'ga'java'ero javo. Igwete ga ei jara'g̃a pe: —Kirupi tuhẽ ojipe'g̃a nemimombe'ua nhande ve. A'ereki ga tuhẽ e'iuhu ojive, ei ga. ");
INSERT INTO pahNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Pehendu ko pe ganhi'ig̃a ko. Onhimongouhu ga Tupana'ga'java'ero, ei ga. Marã po ti nhande ga rerekoi naerũ? Marãi pe ga pe? ei ga jara'g̃a pe. Igwete g̃a epavi ga pe: —Oko te'varuhu tuhẽ ga. Tomano po ga hamo! ei g̃a. ");
INSERT INTO pahNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Kiro g̃a nyvuni ga rehe. Igwete g̃a hovapiari gareakwara tapy'ynhapira pyvõ. Igwete g̃a kwag̃akwari ga rehe. —Ma'g̃a okwa nde rehe? Ekwaha ti, ei g̃a ga pe ga rerekomemuamo. Igwete guardas'g̃a ga rovapetepetegi no. ");
INSERT INTO pahNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","A'ea ja okari pe Pedro'ga apygi guardas'g̃a pavẽi ojipe'eavo. Igwete Caifás'gapyrivehẽa ruri. ");
INSERT INTO pahNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Pedro'ga repiagame hẽa ga repiahetei. —Nde ko Nazarépeve'gapavẽiva'ea Jesus'gapavẽiva'ea, ei hẽa ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","—A'ea rũi ji! ei Pedro'ga o'mbero. Gara pe nde ei? ei ga hẽa pe. A'ero ga hoi ahehohava rupi. Nanime inamutig̃a nhi'ig̃i. ");
INSERT INTO pahNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Igwete hẽa ga repiagi pevo. Hẽa ea'javi pevove'g̃a pe: —Agwa'ga ko Jesus'gapavẽive'ga. ");
INSERT INTO pahNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Igwete Pedro'ga ea'javi o'mbero: —A'ea rũi ko ji! Aere'ĩ pevove'g̃a ea'javi Pedro'ga pe: —A'iti nde gapavẽiva'ea. A'ereki nde Galiléiapeva'ea no, ei g̃a ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Igwete Pedro'ga nhi'ig̃ahyi g̃a pe: —A'itituhẽva'ea ji a'e pe me. Ji ndakwahavi tuhẽ akoja'ga, ei ga g̃a pe. Ji mberame pe me po ti Tupana'ga imbohahyi ji ve hamo, ei Pedro'ga g̃a pe novĩa. ");
INSERT INTO pahNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Nanime inamutig̃a nhi'ig̃a'javi. A'ero Pedro'ga ikwahava'javi Jesus'ga nhi'ig̃agwera ojive. A'ereki opyhyga renonde Jesus'ga omombe'u jipe ga pe javo. “Inamutig̃a nhi'ig̃a'java rupi po ti três nde ea'jaa'javi ji ve: ‘Ji ndakwahavi Jesus'ga’,” e'i jipe Jesus'ga Pedro'ga mbeag̃wama mombe'gwovo ga pe. Kiro Pedro'ga ikwahava'javi ganhi'ig̃agwera. Omboju Pedro'ga py'a. A'ero ga jehe'ohetei o'ama. ");
INSERT INTO pahNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Ypyhajive judeus'g̃a mog̃itahara'g̃a jatykatykaa'javi ikwava'ẽhara'g̃a nduvihava'g̃a xava'eve'g̃a pavẽi judeus'g̃a mbo'ehara'g̃a pavẽi. Igwete g̃a nhaporemo g̃a jatykai nahanahã ti tireko Jesus'ga a'ero javo. Igwete g̃a Jesus'ga kwarukari ga rerogwovouka governador'ga pyri Pilatos'ga pyri. ");
INSERT INTO pahNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Igwete Pilatos'ga ei Jesus'ga pe: —Nde ko judeus'g̃a nduvihavuhuhetero ereko naerũ? Igwete Jesus'ga ei: —Ndehe ko ere poha. ");
INSERT INTO pahNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Igwete ikwava'ẽhara'g̃a nduvihava'g̃a imbojambojatehei Jesus'ga rehe. Emo Jesus'ga nonhi'ĩkwepygi g̃a onhi'ĩpotare'yma g̃waramo g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Igwete Pilatos'ga ea'javi ga pe: —Nerenhi'ig̃ihũ nde g̃a pe naerũ? ei ga. Erehendu nde g̃anemimbojaruhua ejihe, ei ga Jesus'ga pe novĩa. ");
INSERT INTO pahNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Emo Jesus'ga nonhi'ĩkwepygi ga no. Nurã Pilatos'ga nhimomby'ai ga rehe. ");
INSERT INTO pahNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","11","Kiro he'yjuhuve'g̃a nduri javo Pilatos'ga pe. —Páscoa japoa nanani nde cadeiapypeve'ga mbopiro'yi ga mohema cadeia hugwi oreremimbotarimo. Emohemuka ga kiro a'ero, ei g̃a Pilatos'ga pe. Igwete Pilatos'ga ei g̃a pe: —Tamohemuka ti ga a'ero – kiroki ga pe g̃a ei judeus'g̃a nduvihavuhuhete'ga, ei ga. Ga mohema pe pepota a'ero? ei ga g̃a pe. A'ea Pilatos'ga ei he'yjuhuve'g̃a pe. A'ereki ga e'i oyvyteri pe: “Ikwava'ẽhara'g̃a nduvihava'g̃a onhimyrõ reki Jesus'ga rehe,” ei ga. “Nurã g̃a ga pyhygukari ga reruruka ji pyri,” ei Pilatos'ga. Nurã ga ei he'yjuhuve'g̃a pe: “Gamohema pe pepota?” Emo ikwava'ẽhara'g̃a nduvihava'g̃a omomymomyi he'yjuhuve'g̃a Barrabás'ga pe pe'ji javo. A'ea ja Barrabás'ga oko cadeia pype ojipe'g̃a pavẽi. A'ereki g̃a otavuka gwuvihava'ga pe. Igwete Barrabás'ga gwuvihava'gareheva'ea jukai. Emo ikwava'ẽhara'g̃a nduvihava'g̃a omomyi he'yjuhuve'g̃a Barrabás'ga pe pe'ji javo Pilatos'ga pe. Nurã g̃a eg̃a'ei ga pe: —Barrabás'ga koi emohemuka ore ve, ei g̃a ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Igwete Pilatos'ga ea'javi g̃a pe: —Oro ga – kiroki ga pe pe ei oreruvihavuhuhete'ga – marã po ti ji ga rerekoi nehẽ naerũ? ");
INSERT INTO pahNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","—Ekutuguka ga yva rehe ga mbovyruka tomano ga, ei g̃a onhi'ig̃a mbuhua ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","—Maranuhũrame ti ji ga kutugukari naerũ? Marã tuhẽ garekote'varuhua naerũ? ei Pilatos'ga g̃a pe. Igwaigwavete reki g̃a onhi'ig̃a mbuhuri ga pe a'ero. —Embovyruka tuhẽ ga. ");
INSERT INTO pahNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Nurã Pilatos'ga Barrabás'ga mohemukari tonhimohẽ ti g̃a ji rehe javo. Igwete ga Jesus'ga nupanupãukari ipira apopyra pyvõ ga mondovo soldados'g̃a po pe tokutu g̃a ga yva rehe a'ero javo. ");
INSERT INTO pahNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Igwete soldados'g̃a Jesus'ga rerohoi okihavuhua pype governador'ga rongaruvihava pype. Igwete g̃a jara'g̃a mbuhurukapavi tirekomemua ga javo. ");
INSERT INTO pahNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","A'ero g̃a imongiukari ga pe tapy'ynhapig̃wag̃ahiva'ea nanongara huvihava'g̃a omongi javo ga pe. Igwete g̃a ipovãpovani yhypoa hatiuhũva'ea onhatimag̃atuva'ea apovo inog̃a Jesus'ga akag̃a rehe ag̃a huvihava'g̃a akanitara javo tehe jupe. ");
INSERT INTO pahNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Igwete g̃a eg̃a'ei ga pe: —Ejoryjory ti judeus'g̃a nduvihavuhuhetero, ei g̃a ga pe ga rerekomemuamo. ");
INSERT INTO pahNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ojopy'rupy'ru g̃a ga akanupanupamo yvyra pyvõ. Onyvunyvũ g̃a ga rehe. Igwete g̃a nenypy'andurundurugi ga pyri timbohete ga javo tehe. ");
INSERT INTO pahNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Nahã g̃a ga rerekomemui. Aerẽ g̃a hekyi ig̃wag̃ahiva'ea ga hugwi gapiretea mongirukara'java ga pe. Igwete g̃a ga rerohoi tikutu ga yva rehe kiro javo. ");
INSERT INTO pahNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Kiro g̃a Jesus'ga rerohoi cidade hugwi. Nanime Simão'ga ruri cidade pe. Ga ko cidade de Cirenepeva'ero. Alexandre'ga ko gara'yra'ga Rufo'ga pavẽi. Kiro Simão'ga ruri nhuhũa hugwi. A'ero soldados'g̃a herohoukarahai Simão'ga pe yva Jesus'ga jukahava rupiara. ");
INSERT INTO pahNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Igwete g̃a Jesus'ga rerohoi ga rerogwovo yvytyruhua arimo Gólgota arimo. Gólgota pe nhande ei Aheapindava. ");
INSERT INTO pahNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Igwete g̃a imondoi ga pe vinho mohag̃a pavẽi mirra pavẽi tahahyyme ti ga pe javo novĩa. Emo ga ndo'ui. ");
INSERT INTO pahNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Igwete g̃a ga nog̃i yva rehe ga kutukutuga hehe. A'ero g̃a ga mbovyri ga mo'ama. Kiro soldados'g̃a ipyhygi Jesus'ga pira tima'ẽ ti javo. A'ero g̃a imombori ita'java'ea dados'java'ea ji koha javo jupe. Nahã g̃a ima'ẽi tapy'ynhapira ojohupeupe. ");
INSERT INTO pahNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Nove horas rupi g̃a ga kutugi yva rehe. ");
INSERT INTO pahNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Igwete g̃a ikwatijari g̃anemimbojaragwera Jesus'ga rehe. “Agwa'ga ko judeus'g̃a nduvihavuhuhete'ga,” e'i ikwatijara. Nahã g̃a ikwatijari imbojaragwera yva raygwera rehe ikutuga ga arimo yva rehe inog̃a. ");
INSERT INTO pahNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Igwete soldados'g̃a mokonhava'ea jukai ojipea rehe yva rehe ahe monguva no. A'ereki ahe ko governo movahiuhũva'ea. Igwete g̃a ahe mbojogwovai Jesus'ga rehe ahe mo'ama.  ");
INSERT INTO pahNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Na tuhẽ Tupana'ga rembikwatijarukara ga mombe'unhog̃wenondei hako. A'ereki omombe'u g̃anhi'ig̃a ga pe. “Oko te'varuhu ko ga,” ei g̃a ga pe, e'i ikwatijara hako. Na tuhẽ reki g̃a ei Jesus'ga pe a'ero. ");
INSERT INTO pahNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Igwete g̃a – kiroki g̃a okwa ga pyvõ – g̃a nhakambovavagi ga rerekomemuamo ga mbotegweteavo ga rerekovo. Igwete g̃a ei ga pe: —Eh! Ere tuhẽ nde raikwehe: “Tamondurunduru ti nhandejatykahavuhua mokõi herokia japopava irũa,” ere nde raikwehe novĩa, ei g̃a. ");
INSERT INTO pahNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Epopoakaro g̃waramo ejy ti yva hugwi a'ero teremanoyme ti, ei g̃a Jesus'ga pe ga rerekomemuamo. ");
INSERT INTO pahNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Na jitehe ikwava'ẽhara'g̃a nduvihava'g̃a ga rerekomemui onhi'ig̃a ojohupe judeus'g̃a mbo'ehara'g̃a pavẽi. Igwete g̃a ei: —Ojipe'g̃a ga nomomanoukari. Emo re ki ga omano kiro a'ero! ei g̃a ojohupe. ");
INSERT INTO pahNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","E'i tehe ga ojive: “Tupana'ga ji mbuhuruka yvya koty. Ji ko g̃anduvihavuhuhetero israelitas'g̃a nduvihavuhuhetero ako,” e'i tehe ga ojive, ei g̃a. Na ga jyvi kiro yva hugwi a'ero, ei g̃a. Ga jyvame po ti nhande ga repiagi ga rerovia nehẽ! ei g̃a ojohupe. Igwete ahe Jesus'ga mbotegwetei no – kiroki ahe o'ã yva rehe omanomo Jesus'ga pyri. ");
INSERT INTO pahNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Ahaji katu igwehetei kwara ipyryrymame. Ypytunahimba hete g̃agwyri pe nhaporemo imonga'aruga. Três horas rupi kwara imbokojahua'javi. ");
INSERT INTO pahNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Três horas rupi jitehe Jesus'ga onhi'ig̃a mondoahyahivi Tupana'ga pe. —Eloí, Eloí, lemá sabactani? ei ga. A'ea ko: “Tupana, Tupana, ajiko hete ji nde rehe. Maraname nde pohiri ji hugwi?” A'ea Jesus'ga ei ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Jararamo pevove'g̃a g̃wendu ganhi'ig̃ahyahiva novĩa. Emo g̃a e'i tehe: —Pehendu. E'i po ga Eliasva'ea pe tuhu ti ga ji pyri ji pokoga javo, e'i tehe g̃a ojohupe. ");
INSERT INTO pahNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Igwete ojipe'ga nhani ipyhyga jyruhu'iva'ea imondeva vinho pype tajahiva'ea pype herua. Igwete ga ipimombygi yvyra rehe imbovya imondovo Jesus'ga juru pe topyte ga javo. Igwete ga ei jara'g̃a pe: —Tihepia na'ẽ ti Eliasva'ea rura ga mbojyva naerũ, ei ga. ");
INSERT INTO pahNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Igwete Jesus'ga hapukajahivi omanomo. ");
INSERT INTO pahNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Nanime g̃ajatykahavuhua pype tapy'ynhapira hovapiakava itararagi mbytera rupi yvatea hugwi ojyva ua yvyvo. ");
INSERT INTO pahNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Jesus'ga rovai pyteri pe soldados'g̃a nduvihava'ga ami. Igwete ga hepiagi gamanoa. —Tupana'ga ra'yra tuhẽ po ahe, ei ga javo. ");
INSERT INTO pahNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","41","Irupe kunhangwera'g̃a hepiagi gamanoa no – kiroki g̃a ohooho Jesus'ga rupi. Galiléiapeve'g̃a gwyra rupi ga horame g̃a hoi ga rupi imondomondovo mbatera ga pe jipi. G̃a ko Maria Madalenahẽa Saloméhẽa no Mariahẽa no. Hẽara'yra'g̃a ko José'ga Tiago'ga no ipyahuve'ga. Ojipe'g̃a pevo u gamanoa repiaga onhimongyavo no kunhangwera'g̃a – kiroki g̃a uhu Jerusalém me Jesus'ga rupi. ");
INSERT INTO pahNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Kiro ka'aru hete. A'ero judeus'g̃a imboavujikweri mbatera. A'ereki g̃a e'i: “Ko'emame ko sábado. A'ea rupi po ti nhande ndiaporavykyi mbatera apovo,” ei g̃a. ");
INSERT INTO pahNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Igwete José'ga cidade de Arimatéiapeve'ga ndopojihuvi ogwovo Pilatos'ga pyri oporanduva Jesus'ga ra'oa rehe. José'ga ko judeus'g̃a mog̃itahara'g̃a pyteripeve'ga. Ojipe'g̃a e'i ga pe pyry hete ga javo. Ymya ga Cristo'ga rura pota toko ti ga nhanderuvihavuhuhetero javo. Igwete ga ndopojihuvi oporanduva Jesus'ga ra'oa rehe. —Taroho ti Jesusva'ea ra'oa yva hugwi? ei ga Pilatos'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Igwete Pilatos'ga ei oyvyteri pe: “A'iti re po ahe manojipei?” Igwete ga ga mbuhurukari ojipyri soldados'g̃a nduvihava'ga javo ga pe. —Omano Jesusva'ea a'ero? ");
INSERT INTO pahNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","—Omano tuhẽ ko ahe, ei ga imombe'gwovo ga pe. Henduvame ganhi'ig̃a Pilatos'ga ei José'ga pe: —Eroho ti ahera'oa a'ero. ");
INSERT INTO pahNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Igwete José'ga hoi ipyhyga tapy'ynhapipyryva herogwovo Jesus'ga ra'oa pyri. A'ero José'g̃a gara'oa mbojyvi yva hugwi imamana tapy'ynhapira pyvõ. Igwete g̃a gara'oa rerohoi herokia itaruvihavuhua kwaruhua pype imbogwaipyra pype inog̃a heja. Igwete g̃a hovapytymi ikwaruhua itauhua moanhana imohina jurukwari pe. ");
INSERT INTO pahNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Maria Madalena'g̃a gwepia gara'oa nongava. Mariahẽa gwepia no – kiroki hẽa Tiago'g̃a yhẽa. ");
INSERT INTO pahNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Ihopavame kwara sábado rupi g̃aporavykye'yma rupi, a'ero kunhangwera'g̃a hoi ipyhyga nhandya'java'ea perfume timongy ti ahera'oa rehe javo. Maria Madalenahẽa hoi Saloméhẽa no Mariahẽa no – kiroki hẽa Tiago'g̃a yhẽa. ");
INSERT INTO pahNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Ko'emame domingo rupi g̃a herohoi a'ero itaruvihavuhua kwaruhu pe gara'oa nongai pe. Ypyhajive g̃a herohoi kwara po'ria rupi. ");
INSERT INTO pahNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Herohorame g̃a ei ojohupe: —Ma'g̃a po ti ope'a itauhua nhande ve nehẽ imoanhana jurukwara imongovo nehẽ? ei g̃a. A'ereki ipohyi hete nhande ve, ei g̃a ojohupe novĩa. ");
INSERT INTO pahNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Hepiakaturame g̃a nhimombaragwahavi reki imoanhanipyra rehe itauhua rehe. —Ope'a jipe g̃a jugwi ra'e, ja'gwy, ei g̃a. ");
INSERT INTO pahNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Igwete g̃a ki ikwaruhua pype. A'ero g̃a ipyahuve'ga repiagi. Kokoty ga reni ipype. Ipukuhu gapira. Tig̃ahivuhu hete. Onhimomby'a hete g̃a ga repiagame okyhyjiavo. ");
INSERT INTO pahNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Igwete ga ei g̃a pe: —Tapenhimomby'aa'javi, ei ga. Peheka pe Jesus'ga Nazarépeve'ga – gaha g̃a ojuka yva rehe oji'i novĩa, ei ga g̃a pe. Ga okwerava'ja. Avo rũi ga rekoi kiro. Pehepia ganongavagwera, ei ga kunhangwera'g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Hepejigwovo kiro gakwerava mombe'gwovo garemimbo'ehara'g̃a pe Pedro'g̃a pe, ei ga g̃a pe. Pe'ji ti g̃a pe: “Oho ti Jesus'ga Galiléia pe g̃a nenonde. Pevo ti g̃a ga repiagi nehẽ. E'i jipe ga a'ea g̃a pe ikwehe!” A'ea ti pe'ji Jesus'ga remimbo'ehara'g̃a pe, ei ga kunhangwera'g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","A'ero g̃a ẽi ikwaruhua hugwi onhana ohyhyipava. A'ereki g̃a omboju opy'a. Nomombe'ui ve g̃a Jesus'ga kwerava ojipe'g̃a pe okyhyjihetero g̃waramo.  ");
INSERT INTO pahNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Domingo rupi ko'eg̃atue'yma rupi Jesus'ga kwerava'javi omanoa hugwi. Okweravirẽ ga jipiukari Maria Madalenahẽa pe ypy – hehã hugwi Jesus'ga ombojipe'ape'a anhag̃a seteva'ea. Igwete Jesus'ga jipiukari hẽa pe. ");
INSERT INTO pahNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","11","A'ero hẽa hoi Jesus'gapavẽive'g̃a pyri tamombe'u g̃a pe javo. Ojehe'o hete g̃a upa okoveveuhuro omano Jesusva'ea javo tehe. Igwete hẽa ei g̃a pe: —Okwerava'ja ga kiro, ei hẽa. Ahepia ji ga ko, ei hẽa g̃a pe novĩa. Emo g̃a ndogweroviarihu reki hẽanhi'ig̃a. ");
INSERT INTO pahNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Aerẽ mokonha'g̃a horame nhu me Jesus'ga jipiukari g̃a pe ojirojijyita. ");
INSERT INTO pahNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Igwete g̃a jivyri a'ero imombe'gwovo Jesus'ga remimbo'ehara'g̃a pe. —Jesus'ga okwerava'ja kiro, ei g̃a. Orohepia ore ga ko, ei g̃a g̃a pe novĩa. Emo g̃a ndogweroviari jitehe g̃a. ");
INSERT INTO pahNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Aerẽ mbatera ua rupi Jesus'ga jipiukari onzeve'g̃a pe no g̃wemimbo'ehara'g̃a pe. Igwete ga nhi'ig̃ahyi g̃a pe. —Napeangarihu pe heroviare'yma, ei ga. A'ereki pe ndaperoviarihu g̃a – kiroki g̃a ji repia ji kweravirẽ, ei ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Igwete ga ei g̃a pe no: —Peho ti ojipe'g̃a gwyri pe nhaporemo, ei ga. Pemombe'u hete ti pyryva'ea ji mombe'gwovo yvyakotyve'g̃a pe nhaporemo, ei ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Po ti g̃a jikogi ji rehe onhimobatizavouka nehẽ, a'ero po ti g̃a hoi Tupana'ga pyri okovo avuirama nehẽ, ei ga. Po ti g̃a ndojikogi ji rehe, a'ero po ti Tupana'ga ei peko te'varuhu pe javo g̃a pe nehẽ. A'ero po ti g̃a hoi hahyva'ea ruvihava pype avuirama nehẽ, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Kiroki g̃a ojiko ji rehe – g̃a pe po ti Tupana'ga japoukari ahemonhimomby'ava'ea nehẽ. Ombojipe'a po ti g̃a anhag̃a Diabo'gapyriva'ea ojipe'g̃a hugwi jipopoakarimo nehẽ. Tupana'ga po ti omongo g̃anhi'ig̃a hajiheva'ero nehẽ aherembikwahavipyre'ymamo nehẽ, ei ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Po ti g̃a ipyhygi mboja nehẽ, a'ea po ti nombote'varuhui g̃a momanoukare'yma nehẽ. Po ti g̃a i'ui ahejukava'ea nehẽ, ndikwahyi po ti g̃a pe nehẽ, ei ga. Po ti g̃a pokogi itetirũave'g̃a ndehe nehẽ, a'ero po ti g̃a nhimohig̃atui nehẽ, ei Jesus'ga imombe'gwovo g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Igwete Jesus'ga g̃apojykaharete'ga nhi'imbavi g̃wemimbo'ehara'g̃a pe. A'ero Tupana'ga ga rupirukari yvagi pe ga mbuhuruka. Pevo ga apygi oina Tupana'ga pyri ga moiruamo. ");
INSERT INTO pahNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Aerẽ Jesus'ga remimbo'ehara'g̃a hoi Jesus'ga mombe'gwovo ojipe'g̃ape'g̃a gwyri pe. Igwete Jesus'ga g̃apojykaharete'ga g̃a pokopokogi japovouka ahemonhimomby'ava'ea g̃a pe. Nahã ga heroviarukari g̃anemimombe'ua ojipe'g̃a pe a'itituhẽva'ea javo jupe.");
INSERT INTO pahNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Kiro ji ikwatijari nde ve, Teófilo, terekwaha hete ti huvihavamo javo. Ojikwe he'yive'g̃a okwatija imombe'gwovo orerembikwahava nahanahã Cristo'ga oko ojiheve'g̃a pyteri pe g̃a mbojikoguka ojihe javo. ");
INSERT INTO pahNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Okwatija g̃a Jesus'garupive'g̃a nemimombe'ua – kiroki a'ea g̃a omombe'u ore ve Jesus'gareheva'ea pe. G̃a omombe'u Jesus Cristo'ga rura avo yvya koty garuva ahe pyri no. G̃a omombe'u Jesus'ga remimbo'ea ojive no. G̃anemimombe'ua he'yive'g̃a okwatija a'ero. ");
INSERT INTO pahNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Jihi no, ji ikwahapavi, Teófilo. A'ereki ymyahũ ji anhimbo'e Jesus'ga rura rehe gareaporog̃ita rehe no garemimbo'ea rehe no. Ajapyaka ji hendukatuavo Jesus'garupive'g̃a ga mombe'urame. Pyry ji ve no ji ikwatijari Jesus'ga rehe terekwaha ti javo. Kiro po ti ji ikwatijapavi Jesus'ga mombe'ukatuavo nehẽ. ");
INSERT INTO pahNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Nahã po ti ji nde mbo'epavi Jesus'ga rehe nehẽ. Ymya nde henduvi Jesus'ga mombe'ua. Kiro po ti ji ikwahaheteukari nde ve ikwatijarame imombe'upava nde ve nehẽ. ");
INSERT INTO pahNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Ymyahũ Herodesva'ea rekoi israelitas'g̃a nduvihavuhuro g̃agwyri pe Judéia pe. A'ea rupi Zacariasva'ea rekoi ikwava'ẽharamo Tupana'ga pe. A'ereki aheremboypya Abiasva'ea. A'ero ahe poravykyi Abiasva'ea rakykwepohara'g̃a pavẽi gwe'yja'g̃a jatykahavuhua pype templo pype. Zacariasva'ea rembirekova'ea ko ikwava'ẽharava'ea rakykwepoharamo oko no. Aherera Isabel. ");
INSERT INTO pahNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ahe memei Tupana'ga reroviahetei ga nhi'ĩpo'rupava Zacariasva'ea Isabelva'ea pavẽi. Ahe oko katu jipi. —Pepyry pe, ei Tupana'ga ahe ve a'ero. ");
INSERT INTO pahNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ahe ndata'yri. Ahe jogwerekoypyrame Isabelva'ea ndata'yri. Aerẽ ahe memei ixava'e, a'ero kaitu ahe ndata'yri. ");
INSERT INTO pahNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Kiro Zacariasva'ea poravykyi gwe'yja'g̃a jatykahavuhua pype templo pype Abiasva'ea rakykwepohara'g̃a pavẽi jara'g̃a py'ruavo ikwava'ẽharamo. ");
INSERT INTO pahNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Ojopy'rupy'ru g̃a imbokaita incenso perfume apopyra Tupana'ga pe jipi ojatykahavuhua pype. A'ero kiro Zacariasva'ea herohoi perfume apopyra imbokaita Tupana'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Ahe imbokairame he'yjuhuve'g̃a nduvi onhimongyavo okari pe ojatykahavuhua pyri templo pyri onhi'ig̃a Tupana'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Kotihĩ Tupana'gapyrive'ga yvagipeve'ga jipiukari ua o'ama Zacariasva'ea pyri. Perfume apopyra kaihava pyri ojohukoty rũi ga ruri Zacariasva'ea imbokairame perfume apopyra hehe. ");
INSERT INTO pahNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Zacariasva'ea py'a oko tehe ga repiagame. Okyhyji hete ahe ga hugwi. Oyvyteri pe ahe ei: “Marã po ti ji rekoi nehẽ naerũ?” ei ahe. ");
INSERT INTO pahNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","A'ero Tupana'gapyrive'ga ei: —Terekyhyji, ei ga Zacariasva'ea pe. A'ereki Tupana'ga g̃wendu katu nde nhi'ig̃ame ga pe. Nurã po ti nde ra'yramo enhimbirekohẽa pe Isabelhẽa pe nehẽ, ei ga Zacariasva'ea pe. João ti pemondo inog̃a gareraramo peja'yra'ga reraramo, ei ga. ");
INSERT INTO pahNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ga arame po ti nde vy'ari ejoryjoryvamo nehẽ. He'yjuhuve'g̃a po ti ovy'a gworygworyvamo nehẽ no. ");
INSERT INTO pahNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","—Aerẽ po ti Tupana'ga ei ga pe nehẽ: “Huvihava ko ga.” Nahã po ti Tupana'ga ei ndera'yra'ga pe nehẽ, ei Tupana'gapyrive'ga yvagipeve'ga. Nurã po ti pe ndoryndoryvamo nehẽ. Ndo'ui po ti ga vinho nehẽ. Ojipe'ia no ahemboheagwyryva'ea po ti ga ndo'ui nehẽ. Tupana'ga ra'uva po ti ndojipe'ai ga hugwi ga pojykavo nehẽ ga arypyrame nehẽ ga nhimomboakarame nehẽ no. ");
INSERT INTO pahNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","—Gaha po ti e'i israelitas'g̃a pe nehẽ: “Penhi'ĩpo'rua'ja ti Tupana'ga,” e po ti ga nehẽ. A'ero po ti he'yive'g̃a Tupana'ga nhi'ĩpo'rui ojikoga ga rehe nehẽ ndehe ko orepojykaharetea javo ga pe, ei Tupana'gapyrive'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","—Ndera'yra'ga po ti oho nhandepojykaharete'ga renonde nehẽ, ei ga Zacariasva'ea pe. Ymyahũ Tupana'ga ra'uva opojyka Eliasva'ea ahe moiruamo ga mbopopoaka, ei Tupana'gapyrive'ga. Na jitehe po ti Tupana'ga ra'uva ndera'yra'ga pojykai ga moiruamo ga mbopopoaka nehẽ. A'ero po ti ndera'yra'ga akwaimbae'g̃a mbo'embo'ei nehẽ. “Pearõ ti peja'yra'g̃a.” A'ea po ti ga ei g̃a arõukara'java g̃a pe nehẽ, ei ga. Kiroki g̃a ndokoi Tupana'ga nhi'ig̃a rupi – g̃ahã po ti ga ombojapyaka katu nehẽ. Pyryve'g̃a ja po ti g̃a oko a'ero gweaporog̃itakaturo nehẽ. Nahã po ti ndera'yra'ga g̃a mboavujikweri Tupana'ga pe nehẽ toko ti g̃a Tupana'gareheva'ero javo. O'arame nahã po ti ga rekoi nehẽ, ei Tupana'gapyrive'ga Zacariasva'ea pe. ");
INSERT INTO pahNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","—Marã po ti ji heroviari tayri'ga rehe nehẽ? ei Zacariasva'ea. A'ereki ji jixava'e nhirembirekohẽa pavẽi, ei ahe. ");
INSERT INTO pahNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","A'ero Tupana'gapyrive'ga ei ahe ve: —Jirera ko Gabriel. Jihi Tupana'gapyriva'ea jitekovo ga pyri jipi, ei ga Zacariasva'ea pe. Gaha Tupana'ga ji mbuhurukari nde pyri emombe'u ti Zacarias'ga pe javo. A'ero ji ruri imombe'ukatuavo nde ve pyryva'ea. ");
INSERT INTO pahNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Nahã po ti ndera'yra'ga, a'e ko ji nde ve ko, ei ga Zacariasva'ea pe. Aerẽ Tupana'ga erame po ti ji'eagwera apiavo ihoi nehẽ, ei Tupana'gapyrive'ga yvagipeve'ga. Nde ndereroviari reki ji'ea, ei ga. Nurã po ti nde nerenhi'ig̃a'javi nehẽ, ei ga. Ji rendu ti! Ndera'yra'ga arirẽ jate po ti nde nhi'ig̃a'javi nehẽ, ei ga Zacariasva'ea pe. ");
INSERT INTO pahNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Ojatykahavuhua pyri templo pyri Zacariasva'ea re'yja'g̃a nduvi okari pe Zacarias'ga ti tohẽ jugwi kiro javo. Oyvyteri pe g̃a ei: “Maraname ga nohemuhũi naerũ ore ve?” ei g̃a onhimomby'avo. ");
INSERT INTO pahNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Aerẽ ahe hemame g̃ajatykahavuhua hugwi ua g̃a pyri tegwete ganhi'ĩhava g̃a pe. A'ero g̃a ei: —Marag̃atu ga nonhi'ig̃a'javi? ei g̃a. Po Tupana'ga gwepiuka mbatera ga pe, ei g̃a. A'ereki opoa pyvõ ahe nhi'inhi'ĩpotari g̃a pe. Nohema'javi ve reki ahenhi'ig̃a ahe hugwi. A'ero g̃a hoi ogwovo. ");
INSERT INTO pahNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Aerẽ Zacariasva'ea poravykya'javi ojatykahavuhua pype templo pype. Mbohapyra te ahe kiri oporavykyavo. Oporavykypavirẽ ahe jivyri ogwovo g̃wonga pe. ");
INSERT INTO pahNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Aerẽ Zacariasva'ea rembirekova'ea Isabelva'ea puru'aro. Isabelva'ea ndohoi g̃wonga hugwi. Cinco ahe jahya mondoi ohoe'ymame g̃wonga hugwi. Ahe e'i: ");
INSERT INTO pahNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","—Ji poko Tupana'ga. A'ereki ga ombuhu jira'yra'ga ji ve nhirembireko'ga pe no, ei ahe. Ymya g̃a ji jai nandera'yri javo. Kiro po ti g̃a nde'ia'javi ji ve nehẽ, ei ahe. ");
INSERT INTO pahNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Opuru'arame seis Isabelva'ea jahya mondoi. A'ea rupi Tupana'ga ojipyrive'ga mondoukari Gabriel'ga cidade de Nazaré pe – perope Galiléiapeve'g̃a gwyri pe. ");
INSERT INTO pahNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Pevo Tupana'gapyrive'ga yvagipeve'ga hoi ojyva imombe'gwovo Tupana'ga nhi'ig̃a Mariava'ea pe. Akwaimbae'ga ndogwerekoi ve ahe. —Hehã ti tahembireko tuhẽ Daviva'ea rymymino'ga pavẽi nehẽ José'ga pavẽi nehẽ, ei ahepo'ria. Mariava'ea nahembirekoi ve Joséva'ea pavẽi Tupana'gapyrive'ga rurame Mariava'ea pyri. ");
INSERT INTO pahNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Kiro Tupana'gapyrive'ga ruri Mariava'ea pyri javo ahe ve: —Ejoryjory ti, ei ga. A'ereki Tupana'ga omombyry nde ve okovo nde pyri. Koji'i Tupana'ga imombyryvi nde ve kunhangwera'g̃a pe hohe, ei ga Mariava'ea pe. ");
INSERT INTO pahNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Omyi Mariava'ea py'a Tupana'gapyrive'ga imombe'urame ahe ve. Oyvyteri pe ahe ei: “Marag̃atu ga ei ji ve ra'e?” A'ea ahe ei ojapyakavo hehe ikwahave'yma. ");
INSERT INTO pahNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","A'ero Tupana'gapyrive'ga ei: —Maria, ei ga ahe ve. Terekyhyji! A'ereki Tupana'ga imombyryvi nde ve. ");
INSERT INTO pahNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Ji rendu ti! Ndepuru'a po ti nde nehẽ, ei ga. A'ero po ti nde eja'yra'ga mbo'ari nehẽ, ei ga Mariava'ea pe. Jesus emondo ti inog̃a gareraramo. ");
INSERT INTO pahNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Huvihavuhu hete po ti ga nehẽ, ei ga. Nhandepojykaharete'ga Tupana'ga koji'i ipopoaka hete g̃a hohe pa. Jesus'ga pe po ti ga ei nehẽ jira'yra'ga. Tupana'ga tuhẽ po ti ga mongoi nehẽ eko ti huvihavuhuhetero javo. Nahã po ti ga huvihavuhuhetero g̃wamonhava'ea py'rovo Daviva'ea py'rovo nehẽ, ei Tupana'gapyrive'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Nane'ymi jipi po ti ga rekoi Jacóva'ea rakykwepohara'g̃a nduvihavuhuhetero gwe'yja'g̃a nduvihavuhuhetero nehẽ. Avuirama po ti ga rekoi huvihavamo nehẽ, ei Tupana'gapyrive'ga Mariava'ea pe. ");
INSERT INTO pahNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Kiro Mariava'ea ei: —Akwaimbae'g̃a ndajirerekoi ve, ei ahe Tupana'gapyrive'ga pe. Ma po ti ji puru'aro nehẽ naerũ? ei ahe ga pe. ");
INSERT INTO pahNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","A'ero Tupana'gapyrive'ga ei ahe ve: —Pyry hete Tupana'ga ra'uva. Tupana'ga ipopoaka hete ojipe'g̃a hohe pa. Aerẽ po ti gara'uva jyvi ua nde pyri nehẽ. Opopoakara pyvõ po ti Tupana'ga tayri'ga mondoi nde pype a'ero nehẽ. Nahã po ti ga ndera'yra'ga apoi nde ve nehẽ, ei ga Mariava'ea pe. Nurã ombo'arame po ti ndera'yra'ga pyryhetero nehẽ. “Tupana'ga ra'yra'ga,” e po ti g̃a ga pe nehẽ, ei ga ahe ve. ");
INSERT INTO pahNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","—Ji rendu ti! ei ga ahe ve. Erekwaha nde eje'yjahẽa Isabelhẽa. Hẽa ipuru'a no. Ig̃waivĩ hẽa kiro a. Ymya g̃a ei: “Ndata'yri tuhẽ hẽa.” Nahã g̃a ei. Emo seis hẽa omondo jahya opuru'arame. Kiro po ti hẽa gwa'yra'ga mbo'ari nehẽ. ");
INSERT INTO pahNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","A'ereki Tupana'ga pe ahã onhimiva'ea, ei ga imombe'gwovo. ");
INSERT INTO pahNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","A'ero Mariava'ea ei Tupana'gapyrive'ga pe: —Ji ko Tupana'gareheva'ea. Na ti ji puru'aro a'ero nehẽ ganhi'ig̃a rupi nehẽ – kiroki a'ea nde eremombe'u ji ve, ei ahe ga pe. A'ero Tupana'gapyrive'ga hoi ahe hugwi. ");
INSERT INTO pahNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Aerẽ Mariava'ea herekokatui ombate'ria. Kotihĩ ahe herohoi yvytyruhua rupi Judéiapeve'g̃a gwyri pe yvytyruhupeve'g̃a gwyri pe ogwovo pevove'g̃a cidade pe. ");
INSERT INTO pahNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Pevo Zacariasva'ea ronga pe ahe hoi ogwovo Isabelva'ea pyri. —Kirog̃we ji ruri, ei ahe Isabelva'ea pe. ");
INSERT INTO pahNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","A'ero Isabelva'ea ra'yrava'ea Isabelva'ea avykyi aheyvyteri pe ahe Mariava'ea nhi'ig̃a renduvame. Kiro Tupana'ga ra'uvapyryva ruri Isabelva'ea pyri ahe pojykavo. ");
INSERT INTO pahNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Nurã Isabelva'ea nhi'ig̃a hahyahi hẽa erame: —Koji'i Tupana'ga imombyryvi nde ve kunhangwera'g̃a pe hohe, ei Isabelva'ea Mariava'ea pe. Aerẽ po ti Tupana'ga imombyryvi ndera'yra'ga pe nehẽ no. ");
INSERT INTO pahNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Nde ko jipojykaharete'ga yhẽa reki. Kiro po ti nde ga mbo'a nehẽ. A'ero nde huvihava. Jihi okoteheva'ea ko ji. Emo nde erejo jitehe ji repiaga! ei ahe Mariava'ea pe onhimomby'avo. ");
INSERT INTO pahNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Nenhi'ig̃a ji henduvame kotihĩ jira'yra'ga roryroryvamo ji avykyavo jiyvyteri pe ko, ei ahe Mariava'ea pe. ");
INSERT INTO pahNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Pyry hete nde ve. A'ereki nde Tupana'ga nhi'ig̃a rerovia na tuhẽ po ti a'ero nehẽ javo, ei Isabelva'ea Mariava'ea pe. Tupana'ga po ti nopiriani tuhẽ onhi'ig̃a nde ve nehẽ, ei Isabelva'ea. ");
INSERT INTO pahNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","A'ero Mariava'ea ei: —Ambohete tuhẽ ji Tupana'ga jipojykaharete'ga jipy'a pe. Huvihavuhu ko nde epyryvamo, a'e ji ga pe. ");
INSERT INTO pahNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Tupana'ga ji mbohoryory ojihe, ei ahe. Jiyvyteri pe ji jiroryrory. A'ereki ga nhimbopiro'yharamo oko. ");
INSERT INTO pahNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Ji ko gareheva'ero, ei ahe. Ji rendu ti! Kiro ji ndakotehea'javi reki. A'ereki ga ji repia katu ji moka'nhyme'yma. Nurã kiro po ti yvyakotyve'g̃a epavi nehẽ pyry hete hẽa pe javo ji ve, ei Mariava'ea. ");
INSERT INTO pahNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","A'ereki Tupana'ga ipopoakaheteve'ga ji poko hete. Anhimomby'a ji ga rehe. Pyry hete tuhẽ ga. ");
INSERT INTO pahNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Nane'ymi ga g̃a arõhetei g̃a pokoga – kiroki g̃a ganhi'ig̃a rupi oko ga mbohetepota. Oporogwety ga g̃anda'yra'g̃a g̃anymymino'g̃a no – kiroki g̃a ganhi'ig̃a rupi oko ga mbohetepota. Oporogwety ga g̃anamonha'g̃a no – kiroki g̃a ganhi'ig̃a rupi oko ga mbohetepota, ei Mariava'ea. ");
INSERT INTO pahNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ga okwahavuka opopoakara. Ombokwaki'o ga onhimboheteve'g̃a. ");
INSERT INTO pahNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ga omombo huvihava'g̃a tapekoa'javi ti huvihava kiro javo g̃a pe. Okoteheve'g̃a ga omongouka reki eko ti huvihavamo kiro javo g̃a pe, ei Mariava'ea. ");
INSERT INTO pahNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ga omondo pyryva'ea imbatere'ỹve'g̃a pe. Imbateve'g̃a ga omondouka reki ojihugwi. G̃apojate oho a'ero. ");
INSERT INTO pahNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Tupana'ga nomoka'nhymi onhi'ig̃agwera ojiheva'ea pe israelitasva'ea pe. Oko ga g̃wembi'ea rupi ahe pokoga, ei Mariava'ea. ");
INSERT INTO pahNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Ymyahũ ga nhi'ig̃atui nhaneramonhava'ea pe Abraãova'ea pe. Aerẽ ga nhi'ig̃atui aherakykwepoharava'ea pe israelitasva'ea pe. “Nane'ymi ji pe pokogi jipi,” ei Tupana'ga ahe ve. “Penymymino'g̃a po ti ji g̃a pokogi nehẽ no,” ei ga. Na tuhẽ reki. Nomoka'nhymi ga ahe pokoga. Ga po ti nhande pokogi nehẽ no, ei Mariava'ea. Nhanenymymino'g̃a po ti ga g̃a pokogi nehẽ no. G̃anymymino'g̃a po ti ga g̃a pokogi nehẽ no, ei Mariava'ea. ");
INSERT INTO pahNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Kirẽ Mariava'ea três jahya mondoi gwerevi opytavo Isabelva'ea pyri. Aerẽ ahe jivyri ogwovo g̃wonga pe. ");
INSERT INTO pahNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Kiro Isabelva'ea ra'yrava'ea ahava. A'ero ahe gwa'yrava'ea mbo'ari. ");
INSERT INTO pahNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Aherongapypeve'g̃a okwaha ahere'yja'g̃a pavẽi Tupana'ga pyryhetea ahe ve ga ahera'yrava'ea mbo'arukaro g̃waramo ahe ve. A'ero g̃a ndoryndoryvamo Isabelva'ea pavẽi. ");
INSERT INTO pahNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Sete tay'riva'ea kiri o'arirẽ. Ko'emame aherakwanhapi'ria kytihava. A'ero g̃ande'yja'g̃a nduri hepiaga. Tay'riva'ea rehe g̃a inombotari ahereraramo ahepo'ria rera Zacarias po ti garera nehẽ javo. ");
INSERT INTO pahNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","A'ero ahe'yembora ei: —Ahã te! Poi rũi po ti garera nehẽ. Garera po ti João nehẽ, ei Isabelva'ea. ");
INSERT INTO pahNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","A'ero g̃a ei ahe ve: —Maraname nde ei nahã? Ndogwerekoi ndere'yja'g̃a a'ea gwera, ei g̃a. ");
INSERT INTO pahNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Opoa pyvõ g̃a ei tay'riva'ea po'ria pe marãva'ea nde erepota garera naerũ javo. ");
INSERT INTO pahNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","A'ero Zacariasva'ea poeruri peru ti ji ve ikwatijahava javo. A'ereki ahe nonhi'ig̃i. G̃a imondorame ikwatijahava ahe ve, ahe ikwatijari inog̃a: “Garera ko João.” G̃a nhimomby'apavi aherera repiaga. ");
INSERT INTO pahNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Kiro kotihĩ Zacariasva'ea nhi'ig̃a'javi a'ero. —Pyry hete Tupana'ga, ei ahe ga mboheteavo. ");
INSERT INTO pahNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Zacariasva'ea nhi'ig̃ame ahekotyve'g̃a kyhyjipavi. Hehe g̃a nhomonhi'inhi'ig̃i imombe'gwombe'gwovo pa yvytyvytyruhupeve'g̃a pe nhaporemo Judéiapeve'g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Kiroki g̃a g̃wendu Zacariasva'ea mombe'ua tay'riva'ea mombe'ua no – g̃a nhaporemo ojapyaka hehe. A'ero g̃a ei: —Tayri'ga po ti oko huvihavuhuro a'ero nehẽ! ei g̃a. A'ereki Tupana'ga popoakahetea oko tay'riva'ea rupi. ");
INSERT INTO pahNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Tay'riva'ea po'ria Zacariasva'ea, ahe kiro Tupana'ga ra'uva ahe pojykai. A'ero ahe imombe'ui Tupana'ga rembikwahavukara javo: ");
INSERT INTO pahNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","—Timbohete ti nhandepojykaharete'ga israelitas'g̃a pojykaharete'ga Tupana'ga! A'ereki ga uhu nhande pokoguka ojiheva'ea pokoguka nhande mbopiro'yavouka, ei Zacariasva'ea. ");
INSERT INTO pahNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Ga ombuhuruka ipopoakaheteve'ga toko ti ga g̃ambopiro'yharamo javo. Garamonhava'ea ko Daviva'ea Tupana'gareheva'ea, ei Zacariasva'ea. ");
INSERT INTO pahNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Ymyahũ hete Tupana'ga omombe'u jipe ipopoakaheteve'ga rura pyryva'ea pe onhi'ig̃a mombe'uharava'ea pe. A'ero Tupana'ga nhi'ig̃a mombe'uharava'ea garura mombe'ui nhaneramonhava'ea pe. ");
INSERT INTO pahNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Ahe e'i: “Tianembopiro'y ti ipopoakaheteve'ga nhanearõe'ỹve'g̃a hugwi nehẽ.” A'ea Tupana'ga nhi'ig̃a mombe'uharava'ea ei nhaneramonhava'ea pe Tupana'ga remimbotarimova'ea mombe'gwovo, ei Zacariasva'ea. ");
INSERT INTO pahNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","A'ereki ymyahũ Tupana'ga e'i hete nhaneramonhava'ea pe: “Amombyry po ti ji pe me imoka'nhyme'yma nhinhi'ig̃a Abraãova'ea pe nehẽ,” ei Tupana'ga, ei Zacariasva'ea. ");
INSERT INTO pahNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Ymyahũ Tupana'ga onhi'ĩ nhaneramonhava'ea pe Abraãova'ea pe, ei Zacariasva'ea. ");
INSERT INTO pahNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Abraãova'ea pe ga ei: “Ambopiro'y po ti ji nderakykwepohara'g̃a g̃a'arõe'ỹve'g̃a hugwi nehẽ. A'ero ti g̃a toko nhinhi'ig̃a rupi ji mboheteavo okyhyjie'yma nehẽ,” ei Tupana'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","“Nane'ymi ti nderakykwepohara'g̃a toko pyry okovo jireheva'ero ji mboheteavo okokatuavo jipi nehẽ,” ei Tupana'ga nhaneramonhava'ea pe, ei Zacariasva'ea imombe'gwovo g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","—Tapihã, ei Zacariasva'ea gwa'yrava'ea pe. Nde ypy ti ereho Tupana'ga renonde nehẽ imboavujikwea ga pe garura renonde nehẽ. Nurã po ti ga ei nde ve nehẽ ereko ti nde nhinhi'ig̃a mombe'uharamo nehẽ javo. Gaha oko ojipe'g̃a hohe pa Tupana'ga, ei Zacariasva'ea gwa'yrava'ea pe. ");
INSERT INTO pahNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Nde po ti eremombe'u pyryva'ea Tupana'ga nhi'ig̃a gareheve'g̃a pe g̃a mog̃itavo nehẽ. A'ero po ti nde ei g̃a pe nehẽ: “Uhu po ti ipopoakaheteve'ga nhande mbopiro'yavo nhanderekote'varuhua hugwi nehẽ. A'ereki ga a'ea omombo nhande hugwi ikwahava'jave'yma.” A'ea po ti nde ei g̃a pe nehẽ, ei Zacariasva'ea gwa'yrava'ea pe. ");
INSERT INTO pahNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Nahã po ti nehẽ. A'ereki Tupana'ga omombyry nhande ve nhande repiakatuavo. Opyryvamo g̃waramo po ti ga ipopoakaheteve'ga mbuhurukari nhande pyri yvaga hugwi nehẽ. ");
INSERT INTO pahNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Urame po ti ipopoakaheteve'ga ei ikwahavuka nhande ve nehẽ. “Pejiko ti ji rehe imomboruka pejikote'varuhua ji ve. A'ero po ti ji pe nderohoukari yvagi pe pe mombytavo avuirama Tupana'ga pyri nehẽ. A'ero po ti pe ndapehoi hahyva'ea ruvihava pype nehẽ.” A'ea po ti ga ei ikwahavuka nhande ve nehẽ. A'ereki nhande ndikwahavi nhandekote'varuhuavo nhandekyhyjiavo hahyva'ea ruvihava hugwi okovo g̃a ja – kiroki g̃a oho ypytuna rupi. “Mome po pehea?” ei g̃a ikwahave'yma. Ipopoakaheteve'ga po ti ikwahavukari nhande ve imbokojahuavo nhaneakag̃i pe inog̃atuavo nhandepy'a ji rupi po ti pe hoi yvagi pe nehẽ javo, ei Zacariasva'ea gwa'yrava'ea pe. ");
INSERT INTO pahNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Aerẽ tay'riva'ea nhimomboakari oky'rahu'iro Zacariasva'ea ra'yrava'ea. Pyry hete tuhẽ tay'riva'ea reaporog̃ita okovo. Aerẽ oyvuakarame ahe ruvi ongae'ỹi me upa. Aerẽ ahe oje'yja'g̃a mog̃itai israelitas'g̃a mog̃itai Tupana'ga nhi'ig̃a rehe. ");
INSERT INTO pahNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","João Batistava'ea arirẽ César Augustova'ea oko huvihavuhuro tuhẽ romanova'ea. A'ero ahe ei ogwyripeve'g̃a pe nhaporemo g̃a mondovouka ikwatijaruka g̃andera. ");
INSERT INTO pahNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","A'ea rupi g̃a hoypyi ikwatija. A'ea rupi Cirênio'ga oko governador'ga Síriapeve'g̃a gwyri pe. ");
INSERT INTO pahNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","G̃a nhaporemo g̃a hog̃ahoi g̃wamonhava'ea cidade pe g̃wamonhava'ea aragweri pe imondovo gwera. ");
INSERT INTO pahNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Nurã Joséva'ea hoi cidade de Nazaré hugwi. Ogwyra hugwi ahe hoi Galiléia hugwi ogwovo. Judéiapeve'g̃a gwyri pe ahe hoi cidade de Belém me – perope ymyahũ Daviva'ea o'a Joséva'ea ramonhava'ea. ");
INSERT INTO pahNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Nurã pevo Belém me Joséva'ea hoi imondovo gwera Mariava'ea pavẽi. Mariava'ea aherembirekoruama, ymya ahe ipuru'a okovo. ");
INSERT INTO pahNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Kiro ahera'yra'ga ahava reki ahe vahemame pevo. ");
INSERT INTO pahNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","A'ero ahe gwa'yra'ga mbo'ari upa. Gaha ahera'yrypya. Ahe ga mamag̃atui tapy'ynhapira pyvõ ipukuhuva'ea pyvõ ga mondovo ga nog̃a yuranuhũa poitava pype – perope g̃a omondo mbatera yuranuhũa pe. A'ereki ahã ahe ve ahekihava pevo g̃anonga pype. Nurã yuranuhũa rokaja pype Mariava'ea ombo'a gwa'yra'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Belém kotyi ve g̃a nduvi nhuhũ me ovelhas repiakatuhara'g̃a. Gwepia katu g̃a ovelhas he'yjuhuva'ea ypytunimo okovo. ");
INSERT INTO pahNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Kotihĩ hete nhandepojykaharete'gapyrive'ga Tupana'gapyrive'ga jipiukari g̃a pe yvaga hugwi. Nhandepojykaharete'ga rendy'jandy'java imbokojahupavi g̃a pe. Ohyhyi g̃a okyhyjiavo. ");
INSERT INTO pahNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","A'ero Tupana'gapyrive'ga yvagipeve'ga ei g̃a pe: —Tapekyhyji te, ei ga g̃a pe. Ji rendu ti! Ajo ji tamombe'u Tupana'ga nhi'ig̃a pe me pyryva'ea pe me, ei ga. Henduvame horyory pa hete po ti g̃a nehẽ pegwyripeve'g̃a israelitas'g̃a. ");
INSERT INTO pahNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Kiro ji imombe'ui pe me pyryva'ea. Ga o'a ko nhandepojykaharete'ga Cristo'ga. Ga ko pembopiro'yharamo oko, ei ga. Daviva'ea cidade pe ga ari ko. ");
INSERT INTO pahNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Kiro ji ga mombe'ukatui pe me. Nurã po ti pe mbaragwahavi ga rehe nehẽ ga rekarame nehẽ. Yuranuhũa poitava pype po ti pe ga repiagi nehẽ. Tapy'ynhapira pyvõ hẽa ga mamani ga nog̃a ipype, ei Tupana'gapyrive'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Kotihĩ he'yjuhuve'g̃a yvagipeve'g̃a jipiukari yvaga hugwi Tupana'gapyrive'ga pyri. G̃a ko Tupana'gapyrive'g̃a soldados'g̃a'jave'g̃a. Tupana'ga mboheteavo g̃a ei: ");
INSERT INTO pahNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","—Kiro yvagi pe hete yvagipeve'g̃a ombohete Tupana'ga tayri'ga rehe, ei g̃a. Yvaga gwyra yvya koty kiro u katu pa yvyakotyve'g̃a py'a no tayri'ga rehe. A'ereki Tupana'ga hory g̃a ndehe, ei Tupana'gapyrive'g̃a. ");
INSERT INTO pahNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Onhi'imbavirẽ Tupana'gapyrive'g̃a jivypavi ogwovo ojiupia yvagi pe. G̃a horame ovelhas repiakatuhara'g̃a ei ojohupe: —Tupana'ga ombuhuruka g̃a nhande pyri ikwahavuka nhande ve ipita'ngive'ga ara. He xaho pevo cidade de Belém me ga repiaga a'ero nehẽ, ei g̃a. ");
INSERT INTO pahNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","A'ero g̃a ovelhas rejari nhuhũ me onhana pea rupi ua Belém me. Pevo g̃a ga rekari ga repiaga a'ero Mariava'ea reheve Joséva'ea reheve. Ipita'ngive'ga g̃a ga repiagi yuranuhũa poitava pype. ");
INSERT INTO pahNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ga repiagame ovelhas repiakatuhara'g̃a imombe'umbe'upavi Tupana'gapyrive'ga nhi'ig̃a. —“Belém me pepojykaharete'ga Cristo'ga ari pembopiro'yharamo,” ei ga tayri'ga mombe'gwovo, ei ovelhas repiakatuhara'g̃a. ");
INSERT INTO pahNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Onhimomby'a pa g̃a – kiroki g̃a g̃wendu g̃anhi'ig̃a. ");
INSERT INTO pahNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Mariava'ea reki ahe japyakapavi hehe oyvyteri pe. Nomoka'nhymbavi ahe. ");
INSERT INTO pahNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Aerẽ ovelhas repiakatuhara'g̃a jivyri ogwovo g̃wenymbava pyri Tupana'ga mboheteavo. —Pyry hete Tupana'ga, ei g̃a. Gaha ahe mbojiko ojihe. A'ereki ga okwahavuka tayri'ga ara nhande ve. A'ero nhande tayri'ga repiagi reki. Tupana'gapyrive'ga omombe'u katu nhande ve, ei g̃a Tupana'ga mboheteavo. ");
INSERT INTO pahNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Aerẽ sete tayri'ga kiri o'arirẽ. Kiro Mariava'ea garakwanhapi'ria kytiukari Joséva'ea pavẽi. Jesus ahe inog̃i gareraramo ga rehe. A'ereki Tupana'gapyrive'ga yvagipeve'ga e'i jipe: “Eno ti gareraramo ga rehe Jesus.” A'ea ga e'i Mariava'ea pe ahe ra'yre'ymame. ");
INSERT INTO pahNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","24","He'yiva'ea quarenta okirirẽ Mariava'ea gwa'yra'ga rerohoi cidade de Jerusalém me Joséva'ea pavẽi tihepiuka ti ga Tupana'ga pe javo. A'ereki ymyahũ Tupana'ga e'i Moisésva'ea pe ikwatijaruka ahe ve nahã kunhangwera'g̃a ti toko gwa'yrypyve'g̃a arirẽ nehẽ javo. “He'yiva'ea quarenta okira rupi ti hẽa tojikwaku gwa'yra'ga arirẽ,” ei Tupana'ga ikwatijaruka. “Quarenta okirirẽ mokõi ti hẽa togweru ji pyri pykahu'ia ikwava'eg̃a ji ve. Herekoe'ymame pykahu'ia mokõi ti hẽa togweru pykahua'java'ea ra'yra ji ve nehẽ. A'ea rupi po ti ji g̃a mombyryvi a'ero nehẽ,” ei Tupana'ga Moisésva'ea pe ikwatijaruka. E'i ga no: “Akwaimba'eva'ea ojihuvypyva'ea jiapoa tuhẽ g̃anenymbava. Akwaimbae'g̃a ojihuvypyve'g̃a jiapoa tuhẽ no g̃anda'yrypyve'g̃a. Nurã ti g̃a tombuhu ojihuvypyve'g̃a ojihuvypyva'ea reheve ji ve nehẽ,” ei Tupana'ga Moisésva'ea pe ikwatijaruka. Nurã Moisésva'ea rembikwatijara rendukatuavo g̃waramo Mariava'ea gwa'yra'ga rerohoi cidade de Jerusalém me ojikwakupavame. Ogwyripeve'g̃a jatykahavuhua pype templo pype ahe gwa'yra'ga rerohoi pykahu'ia reheve. Ovahemame ahe mokõi imondoi pykahu'ia ikwava'ẽhara'ga pe. —Ekwava'ẽ ti Tupana'ga pe, ei Mariava'ea Joséva'ea pavẽi ga pe. Xako ti Tupana'ga rembikwatijarukara rupi, ei ahe. —Kwa, ei ga ahe ve ikwava'eg̃a. ");
INSERT INTO pahNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Nanime Tupana'ga ra'uva Simeãova'ea reruri ahegwyripeve'g̃a jatykahavuhua pype templo pype. Oko katu Simeãova'ea Tupana'ga rendukatuavo. Jerusalém me ahe ruvi. Ymya Simeãova'ea e'i: “Ymya ji ei garura pota: Aerẽ po ti ga ruri nehẽ – kiroki ga onog̃atu nhandepy'a nehẽ israelitas'g̃a py'a nehẽ, a'e ji,” ei ahe. A'ereki ymya Tupana'ga ra'uva opojyka Simeãova'ea. ");
INSERT INTO pahNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","A'ero i'ei ahe ve: “Nde manoe'ymame po ti Tupana'ga Cristo'ga repiukari nde ve nehẽ. Gaha Tupana'ga ombuhu toko ti ga nderuvihavuhuhetero javo,” e'i Tupana'ga ra'uva ymya ahe ve. ");
INSERT INTO pahNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Kiro Tupana'ga ra'uva Simeãova'ea reruri ahe rerovahema ahegwyripeve'g̃a jatykahavuhua pype templo pype a'ero. A'ea rupi Mariava'ea tayri'ga reruri ga rerovahema pevo Joséva'ea pavẽi tihepiuka ti ga Tupana'ga pe nhandekovo Moisésva'ea remimbo'eagwera rupi javo. ");
INSERT INTO pahNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Kiro Simeãova'ea Jesus'ga pyhynhyrõi opoti'a rehe ga mondovo ga nog̃a. Tupana'ga pe ahe ei ga mboheteavo: ");
INSERT INTO pahNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","—Jipojykaharetero ndepyry hete nde. Eremombe'u katu ko nde ji ve, ei ahe. Na ti ji manoi kiro a'ero. A'ereki jipy'a u katu kiro, ei ahe. A'ereki nde ere'e ji ve ejiheva'ea pe: “Nde manoe'ymame po ti ji ga repiuka nde ve nehẽ.” Nahã nde ei. ");
INSERT INTO pahNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Kiro ji ga repiagi tuhẽ. Ga po ti ore mbopiro'yi okovo nenhi'ig̃a rupi. ");
INSERT INTO pahNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Gaha nde eremongo eko ti g̃ambopiro'yharamo javo ga pe, ei Simeãova'ea. Yvyakotyve'g̃a po ti gwepia pa ga nehẽ ga ko nhanembopiro'yharamo oko javo. ");
INSERT INTO pahNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Ji rupi ahe oho Tupana'ga pyri javo, gaha po ti oko hyapehava ja hepiuka ndeviara judeus'g̃arũive'g̃a pe gentios'g̃a pe nehẽ, ei ahe. Ore ko ndereheva'ero israelitasva'ero. Ore mboheteuka po ti ga nehẽ, ei Simeãova'ea Tupana'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Onhimomby'a Jesus'ga yembora Joséva'ea pavẽi Jesus'ga mombe'ua renduvame. ");
INSERT INTO pahNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","—Tupana, ei Simeãova'ea Tupana'ga pe. Emombyry ti José'ga pe Mariahẽa pe no tayri'ga pe no, ei ahe. Mariava'ea pe Simeãova'ea ei: —Ji rendu ti! ei ahe Jesus'ga yembora pe. Agwa'ga ko ji amombe'u kiro nde ve ndera'yra'ga. Ymyahũ Tupana'ga ei ga mombe'gwovo: “Nahã po ti ga pe nehẽ. Ga rehe po ti jara'g̃a nduri ji pyri he'yive'g̃a israelitas'g̃a nehẽ xako ti gareheva'ero javo. Nduri po ti jara'g̃a ji pyri ga rehe jave'yma he'yive'g̃a israelitas'g̃a nehẽ. G̃a po ti ndokopotari gareheva'ero nehẽ,” ei Tupana'ga. “Tohepiuka ti ga jireaporog̃ita g̃a pe nhaporemo nehẽ. A'ero po ti he'yive'g̃a nhi'ĩte'varuhui ga pe okote'varuhuro ga pe nehẽ. ");
INSERT INTO pahNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Nahã po ti ndera'yra'ga pe nehẽ tomboukwaha ti ga he'yive'g̃a ndeaporog̃ita nehẽ,” ei Tupana'ga, ei Simeãova'ea Mariava'ea pe. Ndehe, ei ahe Mariava'ea pe, hahy hete po ti nde ve nehẽ no, ei Simeãova'ea ahe ve. ");
INSERT INTO pahNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","38","Simeãova'ea nhi'imbavame nanime Anava'ea ruri ahe pyri. Tupana'ga nhi'ig̃a mombe'uharava'ea Anava'ea. Fanuelva'ea ahepo'ria. Nurã ahe Aserva'ea rakykwepoharamo. Sete ahe ombokwara'a g̃wembirekova'ea rerekorame. Aerẽ ahe omano Anava'ea hugwi. Nahembirekoa'javi Anava'ea a'ero. Aerẽ kiro he'yi ahe imbokwara'ara'ari oitenta e quatro anos ahe imbokwara'ari. Ig̃waivĩ hete ahe. Nane'ymi ahe hoi oje'yja'g̃a jatykahavuhua pype templo pype. Ipype ahe ndo'ui onhi'ig̃a Tupana'ga pe ypytunimo arimo no tambohete ji ga javo. Kiro ahe ruri Mariava'ea pyri Joséva'ea pyri no ahe Jesus'ga rerekorame ipype. —Ndepyry hete nde, ei Anava'ea Tupana'ga pe. A'ereki nde erembuhu tayri'ga Cristo'ga, ei ahe Tupana'ga pe. A'ero ahe hoi tayri'ga mombe'gwombe'gwovo Jerusalémmeve'g̃a pe – kiroki g̃a ombopiro'yhara'ga rura pota tuhu ti ga javo. —Uhu nhanembopiro'yhara'ga, ei Anava'ea g̃a pe nhaporemo imombe'gwovo. ");
INSERT INTO pahNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Mariava'ea onhi'ĩpo'ru pa Tupana'ga nhandepojykaharete'ga Joséva'ea pavẽi – kiroki Tupana'ga nhi'ig̃a Moisésva'ea okwatija. Aerẽ ahe jivyri ogwovo ogwyri pe Galiléia pe. Ocidade pe ahe hoi Nazaré pe. ");
INSERT INTO pahNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Pevo tayri'ga nhimomboakari Jesus'ga. Oata'i ga. Pyry hete tuhẽ gareaporog̃ita. Okwaha pa ga. Tupana'ga imombyryvi ga pe. ");
INSERT INTO pahNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Ano nanani Jesus'ga yembora oho Jerusalém me gapo'ria pavẽi. “Ti'u toryvi pe Páscoa pe pevo ojipe'g̃a pavẽi,” ei ahe. “Timoka'nhymyme ti Tupana'ga pyryvagwera nhande ve. A'ereki ymyahũ Tupana'ga ombogwavuka nhaneramonhava'ea pyvõ ahera'yrypyva'ea jukaukare'yma,” ei ahe. ");
INSERT INTO pahNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Nurã ahe hoi ano nanani Jerusalém me i'gwovo toryvi pe. Kiro ahe hoa'javi Páscoa repiaga Jesus'ga vojarame. Doze anos Jesus'ga imbokwara'ari kiro. Jesus'ga rerogwovo ojupi ahe hoi ovahema i'gwovo toryvi pe. ");
INSERT INTO pahNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Aerẽ Páscoa mominirẽ ahe jivyri pehea rupi ua g̃wonga pe. Opyta Jesus'ga Jerusalém me. Ahe ndokwahavi reki ga pytarame. ");
INSERT INTO pahNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","“Po ga ruri nhandere'yja'g̃a ndupi,” ei ahe ua. “Po nhanerembikwahave'g̃a ndupi ga ruri,” ei ahe. A'ereki he'yive'g̃a ojivy Jerusalém hugwi pea rupi ua g̃wonga pe. Ndokiri ve ahe mbytera rupi ve. Ka'arugame ahe ei: “Mome po ga rekoi naerũ?” Oje'yja'g̃a ma'õ me ahe ga rekarekari novĩa onhimbikwahave'g̃a ma'õ me no. ");
INSERT INTO pahNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Ga repiage'ymame ahe jivyri Jerusalém me a'ero ga reka. ");
INSERT INTO pahNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Dois okirirẽ ahe ga repiagi ogwyripeve'g̃a jatykahavuhua pype. Ahegwyripeve'g̃a mbo'ehara'g̃a ma'õ me ga apygi g̃a nendukatuavo. Tupana'ga nhi'ig̃a rehe g̃a ombo'e. —Marã po? Emombe'u katu ti ore ve, ei g̃ambo'ehara'g̃a Jesus'ga pe. A'ero Jesus'ga imombe'ukatui g̃a pe. Kirẽ ga ei g̃a pe: —Marã po? Pemombe'u katu ti ji ve kiro, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Onhimomby'a pa reki garenduve'g̃a ga okwaha hete Tupana'ga nhi'ig̃a javo. ");
INSERT INTO pahNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Ga repiagame ga'yembora nhimomby'ahetei Joséva'ea pavẽi. —Pi'a, ei Jesus'ga yembora Jesus'ga pe. Maranameuhũ nde orepy'a momynhuhũi? Ndavy'ari ji nderuva'ga pavẽi nde rekarame! Momeuhũ ga? oro'e ore nde ve. ");
INSERT INTO pahNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","A'ero Jesus'ga ei ahe ve: —Maraname pe ji rekari? Po ji rekoi avo jiruva'ga ronga pe hamo nhandejatykahavuhu pe. Avo Tupana'ga nhi'ig̃a rupi ji rekoi. Ndapekwahavi naerũ? ei ga ahe ve. ");
INSERT INTO pahNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ndokwahavi tuhẽ reki ahe gwa'yra'ga ea Mariava'ea Joséva'ea pavẽi. A'ero ahe ei oyvyteri pe: “Marãi ganhi'ig̃a ga erame po ji rekoi jiruva'ga ronga pe hamo? Maraname ga ei a'ea?” ei ahe oyvyteri pe. ");
INSERT INTO pahNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Kiro ga jivyri o'yembora rupi Joséva'ea rupi ua cidade de Nazaré pe. Opyta ga upa aheronga pe okovo ahenhi'ig̃a rupi jipi. Ga'yembora ojapyaka oyvyteri pe ga'ea rehe. Nomoka'nhymi ahe. ");
INSERT INTO pahNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Aerẽ Jesus'ga imbokwara'ara'ari. Igwaigwavete Jesus'ga reaporog̃itakaturo. Okwaha pa ga okovo. Jyvuaka ga kiro onhimomboakaruhuavo. Tupana'ga oarõ hete ga. Yvyakotyve'g̃a ga arõ hete no. ");
INSERT INTO pahNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","2","Aerẽ João Batistava'ea pe Zacariasva'ea ra'yrava'ea pe Tupana'ga imbuhurukari onhi'ig̃a imombe'gwovouka ahe ve. —Emombe'u ti nhinhi'ig̃a g̃a pe, ei Tupana'ga João Batistava'ea pe. Tupana'ga nhi'ig̃a renduvame João Batistava'ea ruvi ongae'ỹi me upa. Tupana'ga imbuhurukarame onhi'ig̃a João Batistava'ea pe Tibério César'ga he'yjuhuve'g̃a nduvihavuhuro tuhẽ oko. Kiro César'ga he'yi quinze anos g̃werĩ imbokwara'ari g̃anduvihavuhuro. Pôncio Pilatos'ga ko governador'ga Judéiapeve'g̃a gwyri pe. Herodes'ga omondomondo Galiléiapeve'g̃a g̃wemimbotarimova'ea rupi g̃agwyri pe. Herodes'ga irũ'ga Filipe'ga. Filipe'ga omondomondo Ituréiapeve'g̃a g̃wemimbotarimova'ea rupi g̃agwyri pe. Omondomondo ga Traconitespeve'g̃a g̃agwyri pe no. Lisânias'ga ko omondomondo Abilenepeve'g̃a g̃wemimbotarimova'ea rupi g̃agwyri pe. Tibério César'ga gwereko pa g̃a g̃anduvihavuhuro okovo. A'ea rupi ikwava'ẽhara'g̃a nduvihavuhu'g̃a ko Anás'ga Caifás'ga pavẽi. A'ea rupi kiro João Batistava'ea pe Tupana'ga imbuhurukari onhi'ig̃a imombe'gwovouka emombe'u ti nhinhi'ig̃a g̃a pe javo. ");
INSERT INTO pahNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Nurã João Batistava'ea hoi g̃agwyri pe nhaporemo rio Jordão rembeyvyra rupi imombe'gwovo hete Tupana'ga nhi'ig̃a g̃a mbo'eavo. —Pepohi tuhẽ ti pejikote'varuhua hugwi, ei ahe. Perojijyjijyi ti pejeaporog̃ita pejikokatuavo Tupana'ga nhi'ig̃a rendukatuavo. A'ero po ti ji pe mobatizai yhya pype rio pype nehẽ, ei ahe. A'ero po ti Tupana'ga imombohetei pendekote'varuhua pe hugwi nehẽ imoka'nhyma nehẽ, ei João Batistava'ea g̃a pe g̃a mog̃itavo. ");
INSERT INTO pahNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Ymyahũ Isaíasva'ea ko Tupana'ga nhi'ig̃a mombe'uharava'ea. Isaíasva'ea João Batistava'ea mombe'u nhog̃wenonde. Isaíasva'ea e'i ikwatija hako: “Hahyahi po ti ganhi'ig̃a ga erame g̃a mbo'eavo ongae'ỹi me nehẽ,” ei Isaíasva'ea. “E'i po ti ga nehẽ: ‘Pemboavujikwe ti pehea huvihava'ga pe tuhu ti ga nhande pyri javo. Pembohupi katu ti pehea ga pe,’ e po ti ga nehẽ,” ei ahe javo g̃andeaporog̃ita rerojijyja pe nhandepojykaharete'ga rura renonde. ");
INSERT INTO pahNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","“‘Omoypehỹ ti Tupana'ga nhyvyapỹapynuhũa g̃waimbya nehẽ,’ e po ti ga nehẽ. ‘Ombo'gwy'gwyruhu po ti ga jyvy'gwavy'gwajuhua yvytyra reheve imbojo'jakatuavo nehẽ. Omohig̃atu po ti ga pehea nhikotĩkoti'ĩuhua nehẽ imondovo nehẽ. Onog̃atu po ti ga nhyvyapỹapy'ndiuhua pea rupi nehẽ. ");
INSERT INTO pahNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Tupana'ga po ti gwepiuka yvyakotyve'g̃a mbopiro'yhara'ga nehẽ,’ e po ti ga nehẽ.” A'ea Isaíasva'ea ei ymyahũ ikwatija hako João Batistava'ea nhi'ig̃a mombe'unhog̃wenondeavo hako. ");
INSERT INTO pahNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Kiro João Batistava'ea ruvi ongae'ỹi me ogwovo rio Jordão rembeyvyri. A'ero he'yjuhuve'g̃a nduri onhimono'ono'og̃uhũavo João Batistava'ea pyri tianemobatiza ti javo ahe ve. A'ero João Batistava'ea ei g̃a pe: —Tiruahũ pendeaporog̃ita! Pe'euhu pe pejohupe pejikokatupotare'yma g̃waramo. Pe'e pe: “Haite! Xaho João Batista'ga pyri tianemobatiza ti ga. Nurã po ti Tupana'ga nonhimonha'ngaa'javi nhande rehe nehẽ. Ndahahyi po ti nhande ve a'ero nehẽ.” Nahã pe pe'e, ei João Batistava'ea. Maraname pe euhui nanongarava'ea naerũ? Pe tuhẽ penhimbo'e nava'ea rehe, ei João Batistava'ea g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","—Ji a'e pe me: Po pe ndapepotari hahyva'ea Tupana'ga nhimonha'ngarame pe ndehe, a'ero ti peko katu, ei João Batistava'ea. Tapembopogwea'javi ti pejite'varuhua pejikovo. Pe pohirame jugwi po ti Tupana'ga ei pe me nehẽ: “Ndovy'ari g̃a okote'varuhua rehe kiro opohia jugwi herojijyita ojeaporog̃ita. Nanhimonha'ngaa'javi ji g̃a ndehe a'ero.” Nahã po ti Tupana'ga ei pe me a'ero nehẽ, ei João Batistava'ea g̃a pe. —Tape'ei ti pejiyvyteri pe: “Abraãova'ea nhaneramonhamo oko. Tupana'ga oarõ hete Abraãova'ea. Nurã po ti Tupana'ga nonhimonha'ngai nhande rehe nehẽ.” A'ea ti tape'ei. A'ereki Tupana'ga ndokoi reki Abraãova'ea rymymino'g̃a ndehe g̃a ndekote'varuhurame. Po Tupana'ga ojipe'g̃a pota, a'ero Tupana'ga oapo kwaha ag̃a ita Abraãova'ea rymyminoro g̃a mongovo, ei João Batistava'ea g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Kiro João Batistava'ea imombe'ui ojo'java'ea g̃a pe. G̃a mbo'eavo ga ei: —Akwaimbae'ga ombogwa g̃werĩ jykwa'ria pyvõ tambo'aruka javo. Po i'yva ndogwerekoi yva'ikatua, a'ero po ti ga imbo'ari imondovo tata pype nehẽ. Na jitehe Tupana'ga pe nderekog̃werĩ pe momboa tata pype hahyva'ea ruvihava pype pe pohire'yma g̃waramo pejikote'varuhua hugwi pejikokatue'yma, ei João Batistava'ea g̃a pe imombe'gwovo. ");
INSERT INTO pahNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","João Batistava'ea renduvame g̃a ei ahe ve onhimongyavo: —Marã po ti ore rekokatui a'ero nehẽ? ");
INSERT INTO pahNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","A'ero ahe ei g̃a pe: —Kiroki ga gwereko mokõi tapy'ynhapira – gaha ti tomondo ojipeji herekoe'ỹve'ga pe. Kiroki ga gwereko mbatera – gaha ti tomondo herekoe'ỹve'ga pe to'u ti ga javo. Nahã ji ei pe me pemondo ti javo, ei ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Kiro itambere'ia mono'ono'õhara'g̃a nduri João Batistava'ea pyri. Omono'og̃uhũ g̃a itambere'ia governo pe. G̃a uhu tianemobatiza ti João Batista'ga javo. —Nhanembo'eharamo emombe'u ore ve, ei g̃a ga pe. Marã po ti ore rekokatui a'ero nehẽ? ei g̃a. ");
INSERT INTO pahNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","A'ero ahe ei g̃a pe: —Penhi'ĩpo'ru ti penduvihava'g̃a. G̃anhi'ig̃a rupi te ti pemono'ono'og̃atu itambere'ia ahe hugwi, ei ahe. Tape'ei ti ahe ve: “Koji'i ti embuhu ji ve.” A'ea ti tape'ei, ei João Batistava'ea g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Kiro soldados'g̃a nduri João Batistava'ea pyri no. Ahe ve g̃a ei: —Oro ore, marã po ti ore rekokatui nehẽ? ei g̃a. A'ero ahe ei g̃a pe: —Tapepojykai ti ojipe'g̃a itambere'ia g̃a hugwi. Tapenupanupãi ti g̃a g̃aitambere'ia rerohoahae'yma nehẽ. Tape'ei ti ojipe'g̃a pe: “Pembuhu ti ore ve itambere'ia. Po pe napembuhuri ore ve, a'ero po ti ore imbojari pe ndehe nehẽ.” Tape'mbei ti javo nanongara pe g̃a mongyhyjiavo imbuhuruka pejive. Pejoryjory ti peitambere'ia rehe – kiroki a'ea penduvihava'g̃a imondoi pe me peporavykya repyra, ei ahe g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","João Batistava'ea renduvame g̃a epavi oyvyteri pe: “Mara'ngu po João Batista'ga Tupana'ga remimbuhurukara'ga Cristo'ga? Ga tuhẽ po,” ei g̃a oyvyteri pe ipota garura. ");
INSERT INTO pahNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","A'ero João Batista'ga ei g̃a pe: —Uhu po ti ga nehẽ – kiroki ga ji hohe hete huvihavuhuhetero g̃waramo, ei João Batistava'ea. Ji ki a'e te ako tehe. Jihi opomobatiza yhya pyvõ jate. Nahã ji ikwahavukari g̃a pe pepohira pejikote'varuhua hugwi pendeaporog̃ita rerojijyja reheve pendekokatua reheve. Gaha po ti pe pojykauka Tupana'ga ra'uvapyryva pe aerẽve'ga nehẽ. Nahã po ti ga pendekote'varuhua mombigukari pe mombyryvuka nehẽ, ei João Batistava'ea ga mombe'gwovo g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Kiro João Batistava'ea imombe'ui ojo'java'ea g̃a pe. G̃a mbo'eavo ga ei: —Trigo jara'ga gwereko japira mbovevehava opo pe tamboveve ti ji japira trigo hugwi javo, ei João Batistava'ea imombe'gwovo. Omono'ono'õ po ti ga oapoa trigo inhag̃a hyrua pype nehẽ. Japira po ti ga imbokai tata pyvõ nehẽ. Ndogwevi po ti tata upa nehẽ, ei João Batistava'ea. —Na jitehe po ti jihoheheteve'ga huvihavuhuhete'ga imboja'oja'ogukari pyryve'g̃a okote'varuhuve'g̃a hugwi okovo pyryve'g̃a pojykaharetero nehẽ, ei João Batistava'ea g̃a pe. “Tuhu ti pyryve'g̃a ji pyri yvagi pe upa avuirama nehẽ,” e po ti jihoheheteve'ga nehẽ. “Toho ti okote'varuhuve'g̃a ji hugwi ogwovo tata pype hahyva'ea ruvihava pype opytavo pevo avuirama nehẽ ojivyre'yma,” e po ti jihoheheteve'ga nehẽ, ei João Batistava'ea Cristo'ga mombe'gwovo g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Ojipea rehe he'yiva'ea rehe João Batistava'ea g̃a mbo'embo'ei. Nahã ahe imombe'ukatui pyryva'ea Jesus'ga mombe'ua g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ojikwe João Batistava'ea onhi'ig̃ahy Herodes'ga pe. Herodes'ga omondomondo Galiléiapeve'g̃a g̃wemimbotarimova'ea rupi g̃agwyri pe. Herodiashẽa rehe Herodes'ga irũ'ga rembirekohẽa rehe João Batistava'ea onhi'ig̃ahy ga pe. Herodes'ga tiruahũ ranuhũ. Nurã João Batistava'ea ei ga pe: —Nane'ymi nde ereko te'varuhu. Kiro nde neirũ'ga rembirekohẽa rerekoi no. G̃wia ahe ndoapoi te ite'varuhuva'ea, ei João Batistava'ea ga pe. ");
INSERT INTO pahNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Koji'i Herodes'ga tiruahũ a'ero. A'ereki kiro ga João Batistava'ea momboruka cadeia pype. ");
INSERT INTO pahNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Cadeia pype Herodes'ga João Batistava'ea momborukare'ymame ahe he'yive'g̃a mobatizapavi. Ahe Jesus'ga mobatizai no. A'ea rupi Jesus'ga nhi'ig̃ame Tupana'ga pe Tupana'ga ipe'ai yvaga. ");
INSERT INTO pahNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Tupana'ga ra'uva jyvi yvaga hugwi Jesus'ga rehe. Inamburo gara'uva nhimbotei ua Jesus'ga rehe. Yvaga hugwi Tupana'ga nhi'ig̃i javo: —Ndehe ko jira'yra nhiremia'nguhetea, ei Tupana'ga Jesus'ga pe. Anhimohẽ hete ko ji nde rehe, ei ga. ");
INSERT INTO pahNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","He'yiva'ea trinta anos Jesus'ga imbokwara'ara'ari yvyakotyve'g̃a mbo'eypyrame Tupana'ga nhi'ig̃a rehe. Javo tehe g̃a ei ga pe: —Po Jesus'ga José'ga ra'yra'ga, ei g̃a. Joséva'ea Eliva'ea ra'yrava'ea. ");
INSERT INTO pahNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Eliva'ea Matateva'ea ra'yrava'ea. Matateva'ea Leviva'ea ra'yrava'ea. Leviva'ea Malquiva'ea ra'yrava'ea. Malquiva'ea Janaiva'ea ra'yrava'ea. Janaiva'ea Joséva'ea ra'yrava'ea. ");
INSERT INTO pahNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Joséva'ea Matatiasva'ea ra'yrava'ea. Matatiasva'ea Amósva'ea ra'yrava'ea. Amósva'ea Naumva'ea ra'yrava'ea. Naumva'ea Esliva'ea ra'yrava'ea. Esliva'ea Nagaiva'ea ra'yrava'ea. ");
INSERT INTO pahNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagaiva'ea Maateva'ea ra'yrava'ea. Maateva'ea Matatiasva'ea ra'yrava'ea. Matatiasva'ea Semeiva'ea ra'yrava'ea. Semeiva'ea Joséva'ea ra'yrava'ea. Joséva'ea Jodava'ea ra'yrava'ea. ");
INSERT INTO pahNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Jodava'ea Joanãva'ea ra'yrava'ea. Joanãva'ea Resava'ea ra'yrava'ea. Resava'ea Zorobabelva'ea ra'yrava'ea. Zorobabelva'ea Salatielva'ea ra'yrava'ea. Salatielva'ea Neriva'ea ra'yrava'ea. ");
INSERT INTO pahNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neriva'ea Melquiva'ea ra'yrava'ea. Melquiva'ea Adiva'ea ra'yrava'ea. Adiva'ea Cosãva'ea ra'yrava'ea. Cosãva'ea Elmadãova'ea ra'yrava'ea. Elmadãova'ea Erva'ea ra'yrava'ea. ");
INSERT INTO pahNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Erva'ea Josuéva'ea ra'yrava'ea. Josuéva'ea Eliézerva'ea ra'yrava'ea. Eliézerva'ea Jorimva'ea ra'yrava'ea. Jorimva'ea Matateva'ea ra'yrava'ea. Matateva'ea Leviva'ea ra'yrava'ea. ");
INSERT INTO pahNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Leviva'ea Simeãova'ea ra'yrava'ea. Simeãova'ea Judáva'ea ra'yrava'ea. Judáva'ea Joséva'ea ra'yrava'ea. Joséva'ea Jonãva'ea ra'yrava'ea. Jonãva'ea Eliaquimva'ea ra'yrava'ea. ");
INSERT INTO pahNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliaquimva'ea Meleáva'ea ra'yrava'ea. Meleáva'ea Menava'ea ra'yrava'ea. Menava'ea Matatava'ea ra'yrava'ea. Matatava'ea Natãva'ea ra'yrava'ea. Natãva'ea Daviva'ea ra'yrava'ea. ");
INSERT INTO pahNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Daviva'ea Jesséva'ea ra'yrava'ea. Jesséva'ea Obedeva'ea ra'yrava'ea. Obedeva'ea Boazva'ea ra'yrava'ea. Boazva'ea Salava'ea ra'yrava'ea. Salava'ea Nassomva'ea ra'yrava'ea. ");
INSERT INTO pahNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nassomva'ea Aminadabeva'ea ra'yrava'ea. Aminadabeva'ea Admimva'ea ra'yrava'ea. Admimva'ea Arniva'ea ra'yrava'ea. Arniva'ea Esromva'ea ra'yrava'ea. Esromva'ea Peresva'ea ra'yrava'ea. Peresva'ea Judáva'ea ra'yrava'ea. ");
INSERT INTO pahNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Judáva'ea Jacóva'ea ra'yrava'ea. Jacóva'ea Isaqueva'ea ra'yrava'ea. Isaqueva'ea Abraãova'ea ra'yrava'ea. Abraãova'ea Terava'ea ra'yrava'ea. Terava'ea Nacorva'ea ra'yrava'ea. ");
INSERT INTO pahNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nacorva'ea Seruqueva'ea ra'yrava'ea. Seruqueva'ea Ragaúva'ea ra'yrava'ea. Ragaúva'ea Falequeva'ea ra'yrava'ea. Falequeva'ea Éberva'ea ra'yrava'ea. Éberva'ea Salava'ea ra'yrava'ea. ");
INSERT INTO pahNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Salava'ea Cainãva'ea ra'yrava'ea. Cainãva'ea Arfaxadeva'ea ra'yrava'ea. Arfaxadeva'ea Semva'ea ra'yrava'ea. Semva'ea Noéva'ea ra'yrava'ea. Noéva'ea Lamequeva'ea ra'yrava'ea. ");
INSERT INTO pahNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamequeva'ea Metusalémva'ea ra'yrava'ea. Metusalémva'ea Enoqueva'ea ra'yrava'ea. Enoqueva'ea Jareteva'ea ra'yrava'ea. Jareteva'ea Maleleelva'ea ra'yrava'ea. Maleleelva'ea Cainãva'ea ra'yrava'ea. ");
INSERT INTO pahNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Cainãva'ea Enosva'ea ra'yrava'ea. Enosva'ea Seteva'ea ra'yrava'ea. Seteva'ea Adãova'ea ra'yrava'ea. Adãova'ea Tupana'ga ra'yrava'ea. Nahã ko Jesus'ga ramonhava'ea. ");
INSERT INTO pahNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Aerẽ João Batistava'ea omobatizarame Jesus'ga hoi rio de Jordão hugwi ojivya. Tupana'ga ra'uva ga pojykahetei ga rerogworogwovo ongae'ỹi me. ");
INSERT INTO pahNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Okote'varuhuva'ea ruvihavuhu'ga ko Diabo'ga. Satanás garera no. He'yiva'ea quarenta ga kiri ogwoogwovo Jesus'ga rupi Jesus'ga mongote'varuhupota novĩa. A'ea rupi Jesus'ga ndo'ui. Quarenta Jesus'ga kirirẽ pevo ty'ara ga jukai. ");
INSERT INTO pahNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","A'ero Diabo'ga ei Jesus'ga pe: —Ere jipe ndehe: “Jihi ko Tupana'ga ra'yramo.” A'ea nde ei, ei Diabo'ga. Gara'yramo ti ere kia pe ita pe a'ero: “Enhimbote ti pãoramo nhirembi'uramo.” A'ea ti ere jupe, ei Diabo'ga Jesus'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","A'ero Jesus'ga ei ga pe: —Nda'ei po ti ji jupe nehẽ, ei ga. Ymyahũ Tupana'ga okwatijaruka ahe ve inog̃uka hako. Aherembikwatijara e'i: “Mbatera ua pyvõ jate rũi nhande rekoi. Tupana'ga nhi'imbava rendukatua pyvõ nhande rekoi,” e'i aherembikwatijara, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Aerẽ Diabo'ga ga rerohoi ga rerojiupia yvytyruhua rehe. Pea hugwi kotihĩ Diabo'ga hepiukapavi yvyakotyve'g̃a nduvihavuhu'g̃a gwyra Jesus'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Kiro ga ei Jesus'ga pe: —Kia jiapoa tuhẽ g̃agwyra. Nurã ji imondopotarame ahe ve amondo po ti ji nehẽ, ei ga. Nde ve tuhẽ po ti ji imondopavi nehẽ. A'ero po ti nde g̃anduvihavuhuro nehẽ, ei Diabo'ga. A'ero po ti nde roryroryvamo herekopava nehẽ. ");
INSERT INTO pahNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Po nde ji mbohetei nde ko Tupanamo javo, a'ero po ti ji imondopavi nde ve nehẽ, ei Diabo'ga Jesus'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","—Satanás, ei Jesus'ga Diabo'ga pe. Ymyahũ Tupana'ga okwatijaruka ahe ve inog̃uka hako. Aherembikwatijara e'i: “Embohete ti Tupana'ga. Gaha ndepojykaharete'ga. Gaha jate ti embohete ejikovo ganhi'ig̃a rupi jate,” e'i aherembikwatijara, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Aerẽ Diabo'ga Jesus'ga rerohoi cidade de Jerusalém me a'ero. Yvate ga ga rerojiupiri gare'yja'g̃a jatykahavuhua rehe templo rehe ga mo'ama japyra rehe. Ga rerovahemame pevo ga ei Jesus'ga pe: —Ere jipe nde: “Jihi ko Tupana'ga ra'yramo.” A'ea nde ei, ei Diabo'ga. Gara'yramo ti epo avo hugwi japyra hugwi ehia a'ero. Tupana'gapyrive'g̃a yvagipeve'g̃a po ti nanembohirukarahyi yvyvo nehẽ. A'ero po ti ndahahyi nde ve nde porame japyra hugwi nehẽ. ");
INSERT INTO pahNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","A'ereki ymyahũ a'ea Tupana'ga okwatijaruka ahe ve inog̃uka hako, ei Diabo'ga Jesus'ga pe. Aherembikwatijara e'i: “Tupana'ga po ti ojipyrive'g̃a mondoukari nde pyri nehẽ yvagipeve'g̃a. ‘Pea'ngu ti ga repiakatuavo,’ e po ti ga ojipyrive'g̃a pe nehẽ. ");
INSERT INTO pahNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","‘Pepyhy katu ti ga rerogwovo tahahyyme'i'i ti ga pe javo,’ e po ti Tupana'ga ojipyrive'g̃a pe nehẽ,” e'i aherembikwatijara, ei Diabo'ga Jesus'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","A'ero Jesus'ga ei ga pe: —Ymyahũ Tupana'ga okwatijaruka ahe ve inog̃uka hako. Aherembikwatijara e'i: “Tupana'ga ko ndepojykaharete'ga. Gareaporog̃ita rehe jate ti eko. A'ero po ti ga nde pokogi nehẽ. Ejeaporog̃itatehea rehe rũi ti eko ji poko ti kiro javo tehe Tupana'ga pe,” e'i aherembikwatijara, ei Jesus'ga Diabo'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Diabo'ga Jesus'ga mongote'varuhupotara'jara'ja novĩa. Aerẽ Diabo'ga hoi ga hugwi ogwovo. —Aerẽ po ti ji ga mongote'varuhui nehẽ, ei ga novĩa. ");
INSERT INTO pahNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Tupana'ga ra'uva popoakara Jesus'ga pojyka. Nahã Jesus'ga hoi ongae'yma hugwi ojivya Galiléiapeve'g̃a gwyri pe ovahema g̃a pyri. Pevove'g̃a ga mombe'umbe'upavi ogwyripeve'g̃a pe nhaporemo. ");
INSERT INTO pahNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Tupana'ga nhi'ig̃a rehe ga g̃a mbo'embo'ei g̃ajatykahava pype. Ombohete pa g̃a ga a'ero. ");
INSERT INTO pahNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Kiro ga ruri ua cidade de Nazaré pe. Pevo ganhimomboakahava ymya. Nane'ymi ga oho g̃ajatykahai pe judeus'g̃a poravykye'yma rupi sábado rupi jipi. Kiro ga hoi jupe a'ero sábado rupi. Tanhi'ĩ Tupana'ga rembikwatijarukara pe javo ga ami. ");
INSERT INTO pahNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","A'ero g̃ajatykahava repiakatuhara'ga imondoi Jesus'ga pe Isaíasva'ea rembikwatijara. Ymyahũ Isaíasva'ea ko Tupana'ga nhi'ig̃a mombe'uharava'ea. Kiro Jesus'ga ipyhygi aherembikwatijara ga hugwi ipe'avo. Tohendu ti g̃a javo ga nhi'ig̃i jupe – perope e'i: ");
INSERT INTO pahNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Tupana'ga ra'uva ji pojyka. A'ereki Tupana'ga a'ea mongo ji pyri ikwehe'i. A'ero ga ei ji ve: ‘Emombe'u ti pyryva'ea iporia'ive'g̃a pe. Kiroki g̃a ndovy'ari – g̃a pe ti ere: Kiro ji pe mbovy'ari pe nderekokatuavo. A'ea ti ere g̃a pe. Eho ti imombe'gwombe'gwovo aherembipyhyhara'g̃a pe,’ ei ga ji ve. ‘Ere ti g̃a pe: Pepiro'y pe pepyhyhara'g̃a hugwi. A'ea ti ere g̃a pe. Heakwagweve'g̃a pe ti ere: Kiro ji pe mboheakwakatui. A'ea ti ere g̃a pe. Kiroki g̃a hahyva'ea kwaha – g̃a pe ti ere: Kiro ji pe mbopiro'yi hahyva'ea hugwi. A'ea ti ere g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Eho ti imombe'gwombe'gwovo yvyakotyve'g̃a pe. Ere ti g̃a pe: Kiro po ti Tupana'ga pepojykaharete'ga imombyryvi pe me nehẽ. A'ea ti ere g̃a pe,’ ei ga ji ve.” A'ea Jesus'ga ei onhi'ig̃a Isaíasva'ea rembikwatijara pe tohendu ti g̃a javo. ");
INSERT INTO pahNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Onhi'imbavame jupe Jesus'ga imbotyva'javi Isaíasva'ea rembikwatijara imondoa'java g̃ajatykahava repiakatuhara'ga pe. A'ero Jesus'ga apygi tambo'e ti g̃a javo. Nurã g̃ajatykahavapypeve'g̃a nhaporemo ga repiahetei. ");
INSERT INTO pahNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","—Kirog̃we pe henduvi Tupana'ga nhi'ig̃a Isaíasva'ea pe ymyahũva'ea pe ji nhi'ig̃ame jupe, ei Jesus'ga g̃a pe. Kirog̃we pe henduvame, Isaíasva'ea rembikwatijara po'rua japiavo ihoi, ei Jesus'ga g̃a pe imombe'gwombe'gwovo g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Jesus'ga renduvame g̃a ei: —Maraname Jesus'ga omombe'u kwaha naerũ? ei g̃a onhimomby'avo. A'ereki ga José'ga ra'yra'ga jate reki, ei g̃a. ");
INSERT INTO pahNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","A'ero Jesus'ga ei g̃a pe: —Aerẽ po ti pe ji mog̃itai ikwahapyra'g̃a eagwera rehe nehẽ. A'ero po ti pe ei tuhẽ ji ve nehẽ: “Ahepohanoharamo enhipohanog̃atu ti enhimbogwerava.” Nahã po ti pe ji mog̃itai ikwahapyra'g̃a na'ana'ag̃a pe'erame ji ve nehẽ, ei ga. Pe'e tuhẽ po ti pe ji ve nehẽ: “Ojipe'g̃a nde mombe'u ore ve. ‘Cidade de Cafarnaum me Jesus'ga japoi ahemonhimomby'ava'ea he'yive'g̃a pohanog̃a,’ ei g̃a ore ve. Kiro na jitehe ti eapo ahemonhimomby'ava'ea orepyteri pe nhandegwyri pe.” Nahã po ti pe ei ji ve nehẽ, ei Jesus'ga g̃a pe ikwahavipeavo g̃andeaporog̃ita. ");
INSERT INTO pahNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","—Imombe'ukatuavo ji ei pe me: Tupana'ga nhi'ig̃a mombe'uhara'g̃a gwyripeve'g̃a nohendukatui g̃andeaporog̃ita g̃a arõe'yma, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Pehepia ti Eliasva'ea. Kiro ji imombe'ui a'itituhẽva'ea pe me, ei Jesus'ga. Ymyahũ Tupana'ga nhi'ig̃a mombe'uharava'ea Eliasva'ea oko israelitasva'ea gwyri pe upa, ei ga. Três anos e meio rupi ndokyra'javi israelitas'g̃a gwyri pe. Nurã ahã mbatera ahe ve. Ty'ara ahe jukai, ei Jesus'ga imombe'gwovo g̃a pe. A'ea rupi he'yjuhu kunhangwerava'ea israelitasva'ea aherembirekokwerava'ea. ");
INSERT INTO pahNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Tupana'ga nomondoukari reki Eliasva'ea israelitasva'ea pyri epoko ti g̃a javo. Sidompeva'ea pyri jate aherembirekokwerava'ea pyri ga ahe mondoukari epoko ti hẽa javo. Perope cidade de Sarepta pe ahe ruvi Sidompeva'ea gwyri pe, ei Jesus'ga imombe'gwovo g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","—Eliseuva'ea oko no Tupana'ga nhi'ig̃a mombe'uharava'ea, ei Jesus'ga imombe'gwovo. Ymyahũ ahe oko israelitasva'ea gwyri pe upa. A'ea rupi he'yjuhu ijaijauhuva'ea pevo. Eliseuva'ea nomonhimohig̃atui reki israelitasva'ea ijaijauhuva'ea. Síriapeva'ea tehe Naamãva'ea tehe ahe ahe monhimohig̃atui, ei Jesus'ga imombe'gwovo g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Jesus'ga renduvame g̃a nhimboahipavi g̃ajatykahavapypeve'g̃a. ");
INSERT INTO pahNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","A'ero g̃a po'ami ga pyhyga ga rerogwovo mytu'ẽ me cidade hugwi. Cidade oko yvytyra rehe gwerevi. Yvytyra rehe g̃a ga rerohoi timombo ti ga jugwi javo novĩa. ");
INSERT INTO pahNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","G̃apytera rupi reki ga hoi ogwovo g̃a hugwi. ");
INSERT INTO pahNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","A'ero Jesus'ga hoi cidade de Cafarnaum me. Cafarnaum oko Galiléiapeve'g̃a gwyri pe. Pevo ga g̃a mbo'ei sábado rupi g̃ajatykahava pype. ");
INSERT INTO pahNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ga g̃a mbo'ekatui huvihava'ga ja. Nurã g̃a nhimomby'ai. ");
INSERT INTO pahNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Pevo g̃ajatykahava pype ojipe'ga rekoi anhag̃a rembipojykahara'ga Diabo'gapyriva'ea rembipojykahara'ga. Hahyahi gahapukaja ga erame: ");
INSERT INTO pahNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","—Ah! Jesus, Nazarépeva'ero, maranameuhũ nde ore avykyi? e'i anhag̃a Jesus'ga pe. Ore mombapava nde ruri naerũ? e'i Jesus'ga pe. Orokwaha ji. Ndehe ko pyryheteva'ero Tupana'ga remimbuhurukaramo, e'i anhag̃a Jesus'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","A'ero Jesus'ga ei anhag̃a pe: —Terenhi'ig̃a'javi! Ejipe'a ti ga hugwi! Jesus'g̃a mbyteri pe anhag̃a akoja'ga mombori yvyvo. Ga momborame ijipe'ai ga hugwi imondoe'yma hahyva'ea ga pe. ");
INSERT INTO pahNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Onhimomby'a pa g̃a hepiaga. A'ero g̃a ei ojohupe: —Maraname Jesus'ga popoakaruhuro javo? A'ereki ga omondouka huvihavuhu'ga ja, ei g̃a. E'i ga anhag̃a pe pejipe'a ti javo. A'ero ijipe'ai tuhẽ reki g̃a hugwi, ei g̃a onhimomby'avo. ");
INSERT INTO pahNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ojipe'g̃ape'g̃a pe g̃a Jesus'ga mombe'ui ga kwahavukapava ojigwyri pe. ");
INSERT INTO pahNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","G̃ajatykahava hugwi Jesus'ga hemi ogwovo Simão'ga ronga pe ovahema. Pevo Simão'ga rembirekohẽa yhẽa itetirũa. O'a hete hẽa rehe. A'ero g̃a hẽa mombe'ui Jesus'ga pe epohano ti hẽa javo. ");
INSERT INTO pahNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","A'ero ga hoi hẽa pyri o'ama. —Epi hete, ei ga karugwara pe. A'ero ipigi hẽa hugwi. Kotihĩ hẽa vyri reki ogwovo herua mbatera g̃a pe to'u g̃a javo. ");
INSERT INTO pahNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Aerẽ kwara ihoi. A'ea rupi g̃a g̃a nderupavi itetirũave'g̃a ombyteripeve'g̃a Jesus'ga pyri topohano ti ga g̃a javo. Ojoparapara g̃atetirũa. Itetirũave'g̃a ndehe nanani Jesus'ga pokopokogi g̃a ndehe nhaporemo imombimombipava karugwara g̃a hugwi. ");
INSERT INTO pahNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Jesus'ga anhag̃a mbojipe'ai jara'g̃a hugwi. Ohapukapukai anhag̃a ojipe'avo g̃a hugwi onhimongyavo. Hahyahi inhi'ig̃a i'erame Jesus'ga pe: —Ndehe ko Cristo Tupana'ga ra'yra, e'i Jesus'ga pe. A'ero Jesus'ga ei jupe: —Tapenhi'ig̃a'javi! ei ga imombiga inhi'ig̃a. A'ereki anhag̃a ga kwaha ga ko Cristoramo Tupana'ga remimbuhurukaramo javo. ");
INSERT INTO pahNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Aerẽ ypyhaji ve ga hoi cidade hugwi ogwovo ongae'ỹi me. Pevove'g̃a gweka ga repiaga onhimongyavo. Terehoi ti ore hugwi javo g̃a hoi opytavo ga pyri. ");
INSERT INTO pahNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","A'ero Jesus'ga ei g̃a pe: —Tamombe'u tuhẽ ti ji pyryva'ea ojipe'g̃a pe no cidadespeve'g̃a pe. A'ereki Tupana'ga e'i ji ve: “Eho ti ji mombe'gwovo g̃a pe nhaporemo. Tako ti ji g̃anduvihavuhuhetero,” ei Tupana'ga ji ve, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","A'ero Jesus'ga hogahoi judeus'g̃a gwyri pe Judéia pe. Pevo ga g̃a mbo'epavi Tupana'ga nhi'ig̃a rehe g̃ajatykahava pype. ");
INSERT INTO pahNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Aerẽ Jesus'ga hoi o'ama okovo ypiahua rembeyvyri pe Genesaré rembeyvyri pe. Ga pyri he'yjuhuve'g̃a nduvi. Onhombotymbotyvahi g̃a upa ga mbotyva no tihendu katu ti Tupana'ga nhi'ig̃a javo. ");
INSERT INTO pahNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","O'amame pevo mokõi Jesus'ga hepiagi yharuhua ypiahua rembeyvyri pe. Ahã g̃a ipype. A'ereki g̃a oheohei pira mboahava upa. ");
INSERT INTO pahNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Simão Pedro'ga yharuhua pype Jesus'ga avi javo ga pe: —Emoanha'ndi eyharuhua yembe'yva hugwi, ei ga Simão Pedro'ga pe. A'ero g̃a herojipe'ai yembe'yva hugwi. Yharuhua pype Jesus'ga reni yembeyvyripeve'g̃a mbo'eavo. ");
INSERT INTO pahNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Aerẽ g̃a mbo'epigame ga ei Simão'g̃a pe: —He xaho herogwovo ypyteri pe. Pemombo ti ipypira imboahava, ei ga Simão'g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","A'ero Simão'ga ei: —Oroho jipe ore ypytunimo pira rehe ko. Oromog̃o'ẽ ore. Norombo'ari reki ore! Emo kiro nde ei ore ve pembo'a ti pira javo. Nurã po ti ji hoa'javi kiro imomboa nenhi'ig̃a rupi nehẽ, ei ga Jesus'ga pe ombo'ehara'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","A'ero g̃a hoi ypyteri pe imomboa ipypira imboahava. Imotynyhemi reki pira mboahavuhua. Otarararara gwere pira pohyja rerekovo. ");
INSERT INTO pahNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Nurã g̃a jipoerueruri onhimoirũhara'g̃a pe jara pype yharuhua pype togweru ti g̃a ore pokoga javo. A'ero g̃a heruri oyharuhua ovahema g̃a pokoga. Oyharuhua memei g̃a imotynyhenyhemi pira pyvõ. A'ero g̃a nderohoi gwerevi ypy pe! ");
INSERT INTO pahNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Hepiagame Simão Pedro'ga renypy'andurugi Jesus'ga pyri. —Jipojykaharetero ejipe'a ti ji hugwi. A'ereki nde ndepyry hete ekovo Tupana'ga nhi'ig̃a rupi. Jihi reki ndajipoyjayjari jirekote'varuhuavo g̃waramo. A'ereki ji ndakopavi Tupana'ga nhi'ig̃a rupi. ");
INSERT INTO pahNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Nahã Pedro'ga ei. A'ereki ga onhimomby'a pira mbo'aruhua rehe. Onhimomby'a pa gapavẽive'g̃a hehe no. ");
INSERT INTO pahNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Simão Pedro'ga moirũhara'g̃a Zebedeu'ga ra'yra'g̃a onhimomby'a no Tiagova'ea João'ga pavẽi. A'ero Jesus'ga ei Simão'ga pe: —Terekyhyji, ei Jesus'ga. Pira nde ereru oji'i. Kiro nane'ymi po ti nde ji mombe'ui ojipe'g̃a pe nehẽ g̃a mbuhuruka ji pyri nehẽ toko ti g̃a Jesus'ga nhi'ig̃a rupi javo, ei Jesus'ga Pedro'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","A'ero g̃a heruri yharuhua memei inog̃a imboja yembe'yi pe. Ombatera g̃a hejapavi. Jesus'ga remimbo'eharamo g̃a ndekoi kiro ogwovo ga rupi jipi. ");
INSERT INTO pahNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Aerẽ Jesus'ga ruvi cidade pe pevo. Kiro ijaijauhuve'ga ruri. Ohy ga rehe gajagajauhua gara'oa rehe. Jesus'ga repiagame ga hoi onhinog̃a ojovapyvo yvyvo Jesus'ga pyri jihoheva'ero ji poko javo. Ga e'i: —Nde eremoka'ẽ kwaha jijagwa ji hugwi jipojykaharetero. Po nde imoka'ẽpotari jijagwa, a'ero po ti nde imoka'ẽi nehẽ, ehetei ga Jesus'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","A'ero Jesus'ga jipoapyhoi opokoga ga rehe javo ga pe: —Apota ji. Eka'ẽ ga hugwi! ei Jesus'ga. Kotihĩ ika'ẽi ga hugwi a'ero. ");
INSERT INTO pahNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Jesus'ga e'i ga pe: —Teremombe'ui tuhẽ ti ojipe'g̃a pe, ei ga. Eho ti ejipiuka ikwava'ẽhara'ga pe oka'ẽ jijagwa javo. Emondo tehe ti mbatepyryva ga pe tokwava'ẽ ti ga Tupana'ga pe okovo Moisésva'ea remimbo'eagwera rupi – kiroki a'ea omombe'u ika'ẽagwera. Nde imondorame ga pe po ti pevove'g̃a nde repiagi nehẽ. A'ero po ti g̃a ikwahavi nehẽ gajagwa oka'ẽ javo. Nahã Jesus'ga ei po g̃a nanhimombe'umbe'ui ojipe'g̃a pe hamo javo novĩa. ");
INSERT INTO pahNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Emo g̃a omombe'umbe'u ojipe'g̃a pe. Kotihĩ a'ero he'yjuhuve'g̃a ikwahavi. Koji'i reki g̃a uhu Jesus'ga rendupota onhipohanoanog̃uka ga pe. ");
INSERT INTO pahNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Aerẽ Jesus'ga hoi g̃a hugwi ogwovo ongae'ỹi me. Pevo ga nhi'ig̃i Tupana'ga pe okovo. ");
INSERT INTO pahNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Aerẽ Jesus'ga g̃a mbo'ea'javame fariseus'g̃a apygi ga pyri upa judeus'g̃a mbo'ehara'g̃a pavẽi. G̃ambo'ehara'g̃a ombo'e jipi Moisésva'ea rembikwatijara rehe. Uhu g̃a Galiléiapeve'g̃a cidade hugwi nanani Judéiapeve'g̃a cidade hugwi nanani no. Uhu g̃a cidade hugwi Jerusalém hugwi no. Opopoakara pyvõ Tupana'ga imombigukari Jesus'ga pe karugwara itetirũave'g̃a hugwi. ");
INSERT INTO pahNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Nanime jara'g̃a ga reruri itetirũave'ga nomyive'ga gakupeupava pype. Gweroho pota g̃a ga onga pype Jesus'ga pyri novĩa. ");
INSERT INTO pahNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","G̃a ndogwerohoi ga ipype reki Jesus'ga pyri. A'ereki he'yjuhuve'g̃a onhombotymbotyvahi onga pype. Nurã g̃a ga rerojiupiri g̃ajiupihava rupi onga arimo iperehuva'ea arimo. G̃a ipe'ape'ai tujuga apopyra onga arimova'ea japovo ikwara. Ikwara rupi g̃a ga mbojyvi Jesus'ga pyri gakupeupava pype he'yjuhuve'g̃a mbyteri pe. ");
INSERT INTO pahNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","G̃a ndepiagame Jesus'ga ei oyvyteri pe: “Ojiko hete g̃a ji rehe ga rerua ji pyri tomopo'ã ti ga ga javo,” ei Jesus'ga oyvyteri pe. —Kwãi, ei Jesus'ga nomyive'ga pe. Kiro nderekote'varuhua mombora nde hugwi. A'ea Jesus'ga ei jihi amombo nderekote'varuhua javo. ");
INSERT INTO pahNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Kiro judeus'g̃a mbo'ehara'g̃a noarõi Jesus'ga ea fariseus'g̃a pavẽi. —Maranuhũ po Jesus'ga naerũ? ei g̃a ojohupe. Onhimongouhu ga Tupana'ga'java'ero! ei g̃a. A'ereki Jesus'ga e'i nomyive'ga pe: “Amombo ji nderekote'varuhua.” Tupana'ga jate e'i a'ea, ei g̃a. A'ea po Jesus'ga nde'i hamo, ei g̃a. ");
INSERT INTO pahNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Jesus'ga ikwahahetei g̃a nhi'ig̃ame ojohupe. A'ero ga ei g̃a pe: —Maraname pe japyakauhui javo? “Maranameuhũ Jesus'ga euhui a'ea? A'ereki ga Tupana'ga rũi.” Nahã pe pe'e. ");
INSERT INTO pahNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","A'e ji nomyive'ga pe ko: Amombo ji nderekote'varuhua nde hugwi, ei Jesus'ga g̃a pe. Emo pe ndapehepiagi aherekote'varuhua mombora. A'ero pe ndaperoviari jipopoakara, ei ga g̃a pe. Po ji ei ga pe nehẽ: Epo'ã egwovo, a'ero po ti pe hepiagi gahoa nehẽ. A'ero po ti pe heroviari jipopoakara nehẽ. ");
INSERT INTO pahNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","—Nurã po ti ji ga mopo'ami kiro tapekwaha ti javo, ei Jesus'ga yvyakotyva'ero yvagipeva'ero no. A'ero po ti pe ei nehẽ: “Tupana'ga ombuhuruka tuhẽ Jesus'ga avo yvya koty ga mongovouka yvyakotyve'g̃a ndekote'varuhua momboharamo,” ei Jesus'ga g̃a pe. Nurã Jesus'ga ei nomyive'ga pe: —Kiro ji ei nde ve: Epo'ã ti ejikupeupava rerogwovo enhonga pe, ei Jesus'ga ga monhimohig̃atuavo. ");
INSERT INTO pahNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Nanime nomyive'ga po'ami pevove'g̃a gwepiagame onhimongyavo. Ga ipyhygi ojikupeupava herogwovo g̃wonga pe Tupana'ga mboheteavo. ");
INSERT INTO pahNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Onhimomby'a pa g̃a okyhyjiheteavo. A'ero g̃a Tupana'ga mbohetei. —Korogwe nhande hepiagi ahemonhimomby'ava'ea, ei g̃a ojohupe. ");
INSERT INTO pahNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Aerẽ Jesus'ga hoi cidade hugwi. Ogwovo Jesus'ga gwepia itambere'ia mono'õhara'ga Levi'ga. Itambere'ia ryrua pype Levi'ga õi ipyhyga itambere'ia judeus'g̃a hugwi imono'og̃a governo pe. Ga pe Jesus'ga ei: —Herejo ti ji rupi ekovo nhiremimbo'eharamo. ");
INSERT INTO pahNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","A'ero Levi'ga oapoa rejapavi opo'ama ogwovo Jesus'ga rupi okovo garemimbo'eharamo. Nomono'og̃a'javi ga itambere'ia governo pe. ");
INSERT INTO pahNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Jesus'ga pe ga japoi toryva g̃wonga pype. Hehanhuhũva'ea ga oapo. He'yjuhuve'g̃a nduri itambere'ia mono'õhara'g̃a ojipe'g̃a pavẽi. A'ero g̃a apygi i'gwovo Jesus'ga pyri Levi'ga pyri no. Judeus'g̃a e'i g̃a pe jipi g̃a ko okote'varuhuva'ero hendukatue'yma Moisésva'ea remimbo'eagwera javo. G̃ahã uhu Jesus'ga pyri i'gwovo. ");
INSERT INTO pahNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","A'ero fariseus'g̃a ndopotari judeus'g̃a mbo'ehara'g̃a pavẽi. G̃ambo'ehara'g̃a ko fariseus'g̃a no. Fariseus'g̃a ei Jesus'ga remimbo'ehara'g̃a pe: —Maranameuhũ pe i'uuhui nanongara'g̃a pyri itambere'ia mono'õhara'g̃a pyri okote'varuhuve'g̃a pyri no? ei g̃a. ");
INSERT INTO pahNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","A'ero Jesus'ga ei g̃a pe: —Kiroki g̃a e'i ojive: “Nanhitetirũi ji” – g̃ahã ahepohanohara'ga ndopokogi g̃a pohanog̃e'yma. Kiroki g̃a e'i ojive: “Nhitetirũa ji” – g̃ahã ahepohanohara'ga g̃a pokogi g̃a pohanog̃a. Na jitehe ji okote'varuhuve'g̃a pokogi jijihe'a g̃a ndehe topohi ti g̃a okote'varuhua hugwi javo, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","—A'ereki a'ea rehe ji ajo yvya koty tapoko ti ji g̃a javo – kiroki g̃a e'i ojive: “Ako te'varuhu ji. Marã po ti ji ve a'ero nehẽ?” Ta'e ti ji g̃a pe: Perojijyi ti pejeaporog̃ita a'ero. Pepohi ti pejikote'varuhua hugwi pejikoga Tupana'ga rehe. Nahã ti ji ta'e okote'varuhuve'g̃a pe. Ojipe'g̃a pyri rũi ji ajo javo – kiroki g̃a e'i ojive: “Jipyry hete ji.” ");
INSERT INTO pahNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","G̃a e'i ga pe: —Nane'ymi João Batista'ga remimbo'ehara'g̃a ndo'ui xanhi'ĩ ti Tupana'ga pe javo. Na jitehe fariseus'g̃a nemimbo'ehara'g̃a ndo'ui xanhi'ĩ ti Tupana'ga pe javo. Neremimbo'ehara'g̃a ki a'e te nane'ymi o'u reki. Maraname ore ja rũi g̃a ndekoi? ei g̃a Jesus'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","A'ero Jesus'ga ei a'ea kwahavuka g̃a pe: —Kiro ji hẽarembirekoruama'ga mombe'ui pe me, ei Jesus'ga. Uhu hẽarembirekohava apiavo. A'ero g̃a i'ui gworygworyvamo ga rehe okovo ga pyri toryva rupi – kiroki g̃a ojikoty'a ga pavẽi. Po ahe nde'i te g̃a pe a'ero: “Tape'ui ti.” Ahe erame a'ea po g̃a ndokoi ahenhi'ig̃a rupi, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Aerẽ po ti tiruahũve'g̃a hẽarembirekoruama'ga rerohoi nehẽ. Kiroki g̃a ojikoty'a ga pavẽi – g̃a hugwi po ti g̃a ga rerohoi nehẽ. A'ero po ti g̃a ndo'ua'javi nehẽ. A'ea Jesus'ga ei ikwahavuka g̃a pe onhimombe'gwovo g̃wemimbo'ehara'g̃a mombe'gwovo no. ");
INSERT INTO pahNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Kiro Jesus'ga imombe'ui ojo'java'ea g̃a pe. G̃a mbo'eavo ga ei: —Po ahe oapokatua'ja pota tapy'ynhapirymyana, a'ero ahe ndohaygwe'rogi tapy'ynhapirapyahua imondovo tapy'ynhapirymyana itararaga rehe imboja hehe, ei Jesus'ga. Ahe haygwe'rogame ipyahuva'ea tamboja ymyahũva'ea rehe javo, a'ero ahe imbotegwetei ipyahuva'ea. Ipyahuva'ea ndojihe'akatujuhu ymyahũva'ea rehe no, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","—Vinho aporame ahe ndoheka'vogi vinhopyahua hyruymyana pype mbiara pirymyana pype, ei Jesus'ga. Po ahe heka'vogi vinhopyahua ipirymyana pype, a'ero vinho imombugi ipirymyana otururupava jugwi. Nahã vinho imbotegwetei mbiara pira. ");
INSERT INTO pahNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Ipipyahua pype tuhẽ ahe toheka'vo vinhopyahua, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Kiroki ga o'uo'u vinhoymyana – ga ndougwei vinhopyahua. A'ereki ga e'i: “Pyry hete nhymyana,” ei ga, ei Jesus'ga. A'ea ojo'java'ea Jesus'ga omombe'u ahe ndopotari morog̃itapyahua morog̃itaymyana ipotarame javo. ");
INSERT INTO pahNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Judeus'g̃a poravykye'yma rupi sábado rupi Jesus'ga hoi kohoa rupi garemimbo'ehara'g̃a pavẽi. Trigo kopeva'ea pevo onhimongy. Ohorame garemimbo'ehara'g̃a ika'mbika'mbigi trigo jykyavo ikytykytygi jape'ia opovo i'gwovo. ");
INSERT INTO pahNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","A'ero fariseus'g̃a ei g̃a pe: —Ymyahũ Moisésva'ea e'i ikwatija hako: “Tapeporavykyi ti sábado rupi.” Nahã ahe ei hako. Pe napehendukatui reki. A'ereki pe peporavyky ika'mbika'mbiga trigo sábado rupi, ei fariseus'g̃a g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","A'ero Jesus'ga ei fariseus'g̃a pe: —Napehendukatui pe Tupana'ga nhi'ig̃a. Garembikwatijarukara omombe'u Daviva'ea. A'ea onhi'ĩ pe me novĩa. Ymyahũ ty'ara ojuka Daviva'ea onhipavẽiva'ea pavẽi hako. ");
INSERT INTO pahNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","A'ea rupi ahe hoi Tupana'ga ronga pype tenda pype. Ipype ikwava'ẽhara'g̃a omondo pão Tupana'ga rovai pyteri pe jipi. G̃a ikwava'eg̃irẽ Tupana'ga pe ga gwerohouka g̃a pe g̃ahã jate ti to'u jirovai pyteripeva'eagwera javo. Ojipe'g̃a po ndo'ui hamo novĩa. Emo Daviva'ea hoi Tupana'ga ronga pype ipyhyga pão i'gwovo. Onhipavẽiva'ea pe ahe imondoi to'u ti g̃a no javo hako, ei Jesus'ga imombe'gwovo fariseus'g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","—Yvyakotyva'ero yvagipeva'ero jihi ta'e: Nahanahã ti ahe toko sábado rupi. Nurã ji ei pe me: Tape'epe'ei ti nhiremimbo'ehara'g̃a pe a'ero g̃a ika'mbigame trigo sábado rupi, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Irũa rupi judeus'g̃a poravykye'yma rupi Jesus'ga hoi g̃ajatykahava pype. Okiavo ga g̃a mbo'ei Tupana'ga nhi'ig̃a rehe. Ipype iponhimamave'ga rekoi. Ojohukoty rũi ga iponhimama. ");
INSERT INTO pahNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Pevo g̃a ndekoi no judeus'g̃a mbo'ehara'g̃a fariseus'g̃a pavẽi. Jesus'ga repiaheteavo g̃a ei oyvyteri pe: “Mara'ngu po ti Jesus'ga oporavykyavo gapoa mbokatua'java nhandeporavykye'yma rupi sábado rupi? Ga gapoa mbokatua'javame po ti nhande Jesus'ga mbotegweteuhui nehẽ,” ei g̃a ovyteri pe gweaporog̃itate'varuhuavo. ");
INSERT INTO pahNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","G̃ayvytera rehe Jesus'ga ombaragwaha javo oyvyteri pe: “Omboja pota g̃a ite'varuhuva'ea ji rehe,” ei ga. Iponhimamave'ga pe Jesus'ga ei: —Epo'ã ejoa avo orepyteri pe e'ama. A'ero ga ruri o'ama g̃apyteri pe. ");
INSERT INTO pahNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","A'ero Jesus'ga ei fariseus'g̃a pe judeus'g̃a mbo'ehara'g̃a pe no: —Ojipeji jate po ti ji ei pe me kiro. Pemombe'u ti ji ve. Marã nhande xako nhandeporavykye'yma rupi hamo? Marãi Moisésva'ea rembikwatijara nhandeporavykye'yma mombe'gwovo sábado mombe'gwovo? Pyry nhande imombyryvi ahe ve sábado rupi? Marãi? Pyry nhande nimombyryvi ahe ve sábado rupi? Marãi ikwatijara? Pyry nhande imbote'varuhui ahe ve sábado rupi? Marãi? Pyry nhande nimbote'varuhui ahe ve sábado rupi? Marãi ikwatijara? Pyry nhande nimomanoukari ahe sábado rupi? Marãi? Pyry nhande ahe moka'nhymbavi sábado rupi? Marãi ikwatijara? ei Jesus'ga. A'ea Jesus'ga ei g̃a pe tojapyaka katu ti g̃a javo. ");
INSERT INTO pahNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","A'ero Jesus'ga g̃a ndepiahetei. Iponhimamave'ga pe ga ei: —Ejipoapyho! A'ero ga jipoapyhokatui. A'ereki gapoa ikatua'ja ga Jesus'ga nhi'ĩpo'rurame. ");
INSERT INTO pahNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","A'ero g̃a nhimboahivi onhimonha'ngavo hepiagame. Ojohupe g̃a ei: —Maranuhũ po ti nhande Jesus'ga rerekouhui nehẽ naerũ? ei g̃a. ");
INSERT INTO pahNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Aerẽ Jesus'ga hoi ojiupia yvytyvytyruhua rupi tanhi'ĩ ti Tupana'ga pe javo. Oho ga opytavo pevo. Ypytunimo ga nhi'inhi'ig̃i Tupana'ga pe imog̃o'eamo. ");
INSERT INTO pahNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Iko'emame ga g̃a mbuhurukari ojipyri g̃wemimbo'ehara'g̃a. G̃wemimbo'ehara'g̃a hugwi Jesus'ga dozeve'g̃a mo'emo'ẽi toko ti g̃a nhimoirũharamo javo. G̃a ko nahã: ");
INSERT INTO pahNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Mokonha'g̃a ko Simão'ga André'ga pavẽi onhoirũ'g̃a. Pedro irũa Simão'ga rera. A'ereki ga rehe Jesus'ga ono Pedro. Mokonha'g̃a ko Tiagova'ea João'ga pavẽi. Mokonha'g̃a ko Filipe'ga Bartolomeu'ga pavẽi. ");
INSERT INTO pahNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mokonha'g̃a ko Mateus'ga Tomé'ga pavẽi. Mokonha'g̃a ko Tiago'ga Simão'ga pavẽi. Tiago'ga ko Alfeu'ga ra'yra'ga. Simão'ga ko zelotes'g̃a nde'yja'ga – kiroki g̃a ndokoi governo rehe romanos'g̃a ndehe. ");
INSERT INTO pahNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Mokonha'g̃a ko Judas'ga Judas Iscariotesva'ea pavẽi. Judas'ga ko Tiago'ga irũ'ga. Judas Iscariotesva'ea aerẽ Jesus'ga mondouka okote'varuhuve'g̃a pe ga pyhyguka g̃a pe. Nahã dozeve'g̃a nhaporemo Jesus'ga moirũhara'g̃a. ");
INSERT INTO pahNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Aerẽ Jesus'ga jivyri ojyva yvytyruhua hugwi omoirũhara'g̃a ndupi. Uhu g̃a nhuhũ me – perope ga opyta o'ama. He'yjuhu garemimbo'ehara'g̃a onhimono'og̃a perope ga pyri. Ojipe'g̃a ndupavi ogwyra hugwi Judéia hugwi Jesus'ga pyri. Cidadespeve'g̃a nduri Jerusalém hugwi Tiro hugwi no Sidom hugwi no. Oko cidades Tiro Sidom pavẽi ypiahua ruvihava rembeyvyri pe. He'yjuhu hete ko g̃a ua Jesus'ga pyri tihendu ti ga javo. Itetirũave'g̃a nduri no emombi karugwara ore hugwi javo ga pe. ");
INSERT INTO pahNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Kiroki g̃a anhag̃a oavykyuhu – g̃a hugwi Jesus'ga anhag̃a mbojipe'ai. Tiruahũ anhag̃a Diabo'gapyriva'ea. ");
INSERT INTO pahNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Opoko pota pa pevove'g̃a Jesus'ga rehe onhimongyavo. A'ereki Tupana'ga omondo opopoakara Jesus'ga hugwi imombipavuka Jesus'ga pe karugwara g̃a hugwi. ");
INSERT INTO pahNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Kiro Jesus'ga hepiagi g̃wemimbo'ehara'g̃a g̃a nhimongyrame pevo. G̃a pe ga ei: —Pyry hete pe me peporia'iva'ea pe! A'ereki penduvihavuhuhetero Tupana'ga pe ndepia katu imombyryva pe me, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Pyry hete pe me okoteheva'ea pe! A'ereki a'ea Tupana'ga remimondoag̃wama pe me. Pyry hete pe me pejehe'ova'ea pe! A'ereki a'ea penembipukaag̃wama. ");
INSERT INTO pahNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Pyry hete pe me ojipe'g̃a pe arõe'ymame pe ndekoro g̃waramo jireheva'ero, ei Jesus'ga g̃a pe yvyakotyva'ero yvagipeva'ero no. G̃a euhurame pe me pe mondovo ojihugwi pe ndekoro g̃waramo jireheva'ero, pyry hete pe me. G̃a pe mbotegweterame petiruahũ pe javo o'mbero pe ndekoro g̃waramo jireheva'ero, pyry hete pe me, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","—Pejoryjory ti g̃a ndekote'varuhurame pe me nahã. Pepopepo tuhẽ ti pendoryndoryva g̃waramo. A'ereki Tupana'ga gwereko katu pe me yvagi pe ikwepykavuhua pyryheteva'ea. Aerẽ po ti ga imondoi pe me nehẽ, ei Jesus'ga g̃a pe. A'ereki pe peko ymyahũva'ea ja Tupana'ga nhi'ig̃a mombe'uharava'ea ja hahyrame pe me. A'ereki ymyahũ ag̃wamove'g̃a namonhava'ea gwereko te'varuhu Tupana'ga nhi'ig̃a mombe'uharava'ea no, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","—Tiruahũ hete pe me pembateva'ea pe! ei Jesus'ga. A'ereki avo jate yvya koty jate pe pendoryndory. Aerẽ po ti pe ndapehoryvi nehẽ, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Tiruahũ hete pe me herekopava'ea pe! Aerẽ po ti ahana'ja pe me nehẽ. Tiruahũ hete pe me pepukava'ea pe! Aerẽ po ti pe jehe'oi pejikoveveuhuheteavo nehẽ, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Tiruahũ hete pe me ojipe'g̃a ekatupavame pe me pe mboheteavo! Ymyahũ na jitehe g̃anamonhava'ea e'i katu pa Tupana'ga nhi'ig̃aatyviva'ea mombe'uharava'ea pe ahe mboheteavo, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","—Kiro nhirenduva'ea pe ji ei, ei Jesus'ga. Pearõ hete ti penhiarõe'ỹve'g̃a. Peko katu ti g̃a pe g̃a pe arõe'ymame. ");
INSERT INTO pahNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Po g̃a ei pe me: “Tuhu ti hahyva'ea pe me.” G̃a euhurame na pe me pe'ji ti g̃a pe: “Tupana'ga ti tomombyry pe me.” Nahã ti pe'ji g̃a pe. Po g̃a jigwarai pe ndehe, a'ero ti penhi'ĩ Tupana'ga pe emombyry ti g̃a pe javo, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","—Po ojipe'ga kwari nderetyvapea rehe, a'ero ti ejirova ga pe tokwa ti ga ojipea rehe no javo jiretyvapea rehe javo. Po ojipe'ga hekyi ndepaletó nde hugwi, a'ero na ga hekyi ojipea ndecamisa nde hugwi no, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Po ojipe'ga ei nde ve embuhu ji ve javo, a'ero ti emondo ga pe. Po ojipe'ga ipyhygahyi ndeapoa nde hugwi, a'ero ti terei ga pe embuhura'ja ti jiapoa ji ve javo. ");
INSERT INTO pahNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","—Pe'e po pe pejiyvyteri pe: “Po ojipe'g̃a oko katu nhande ve hamo.” Po nahã pe ei, a'ero na jitehe tuhẽ ti peko katu g̃a pe, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","—Po pe pearõ hete penhiarõheteve'g̃a jate, a'ero Tupana'ga ei pe me: “Pe okote'varuhuve'g̃a ja reki.” Nahã ga ei pe me. A'ereki okote'varuhuve'g̃a oarõ oarõheteve'g̃a jate, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","—Po pe peko katu pejerekokatuve'g̃a pe jate, a'ero Tupana'ga ei pe me: “Pe okote'varuhuve'g̃a ja.” Nahã ga ei pe me. A'ereki okote'varuhuve'g̃a oko katu ojerekokatuve'g̃a pe jate, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","—Po pe ei pejiyvyteri pe imondorame ojipe'g̃a pe: “Aerẽ po ti g̃a imbuhuri nhande ve nehẽ no.” Po pe ei na, a'ero Tupana'ga ei pe me: “Pe okote'varuhuve'g̃a ja.” Nahã ga ei pe me. A'ereki okote'varuhuve'g̃a omondo ojipe'g̃a pe okote'varuhuve'g̃a pe tombuhu ti g̃a nhande ve nehẽ no javo, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","—Pearõ hete ti penhiarõe'ỹve'g̃a pejikokatuavo g̃a pe. Pemondo'ã ti g̃a pe g̃a erame pe me. Imondorame g̃a pe, tape'ei ti pejiyvyteri pe: “Aerẽ po ti g̃a imbuhuri nhande ve nehẽ no.” Pe ee'ymame g̃a arõheteavo po ti Tupana'ga imbuhuhetei pe me nehẽ. Tupana'ga ra'yramo po ti pe ndekoi nehẽ no g̃ahoheve'ga ra'yramo nehẽ. Nde'i he'yjuhuve'g̃a Tupana'ga pe: “Ndepyry nde ore rerekokatuavo.” A'ea g̃a nde'i Tupana'ga pe. Tupana'ga opoko reki g̃a okote'varuhuve'g̃a ndeheve. ");
INSERT INTO pahNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Tupana'ga penduvete'ga oporogwety g̃a. A'ero ga g̃a pokogi. Na jitehe ti peporogwety g̃a. Pepoko ti g̃a a'ero, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","—Tape'epe'ei ti ojipe'g̃a pe: “Nahanahã g̃a okote'varuhu.” Tape'euhui ti a'ea. A'ero po ti Tupana'ga nde'i a'ea pe me nehẽ no. Tape'ei ti ojipe'g̃a pe: “Oko te'varuhu tuhẽ g̃a. Oja g̃a ndehe.” Tape'ei ti a'ea. A'ero po ti Tupana'ga nde'i a'ea pe me nehẽ no. Tapehenonha'javi g̃andekote'varuhua. A'ero po ti Tupana'ga ndokwahava'javi pendekote'varuhua nehẽ no, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","—Pemondo ti ojipe'g̃a pe. Aerẽ po ti Tupana'ga imbuhukatui pe me nehẽ. Hupi hete po ti ga ombuhuruka saca pype imbohygahivuka imbovavaguka saca tamotynahẽ tuhẽ javo imoakag̃a nehẽ. Nahã po ti ga imbuhukatui pe me nehẽ. Pemondo ti g̃a pe a'ero. Xunhiva'ea pe imondorame g̃a pe xunhiva'ea po ti Tupana'ga imbuhuri pe me nehẽ no. He'yjuhuva'ea pe imondorame g̃a pe he'yjuhuva'ea po ti Tupana'ga imbuhuri pe me nehẽ no, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Kiro Jesus'ga g̃a mbo'ei ojo'java'ea pyvõ. A'ea pyvõ ga ei: —Po heakwagweve'ga gweroho ojipe'ga – kiroki ga ga ja ndohepiagi, a'ero po ti g̃a memei ohi ikwara pype nehẽ. A'ereki g̃a memei ndohepiagi, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","—G̃ambo'ehara'ga koji'i garemimbo'ehara'g̃a hohe. Ga g̃a mbo'epavame g̃a ga javijitehe, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","G̃a mbo'eavo Jesus'ga ei: —Ererekouhu nde ejikotyve'ga. A'ero nde ei ga pe: “Hay'iuhua oko ndereakwari pe,” ere nde. Maranameuhũ nde euhui a'ea ga pe ndokokatui ga javo? Jihi a'e reki nde ve: Okyta reki oko ndereakwari pe, ei Jesus'ga. Nahã ji ei nde ve nde koji'i ereko te'varuhu ga hohe javo. Nde nderekwahavi reki ejekote'varuhua naerũ? ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Maranameuhũ nde euhui ejikotyve'ga pe naerũ? Tere'ei ti ga pe a'ero: “Na ji hekyi hay'iuhua ndereakwara hugwi.” Tere'ei ti nahã okyta repiage'ymame ejeakwara pype naerũ. A'ereki nde nderehepiakatui ve hekyita gareakwara hugwi okyta pytarame ejeakwari pe. Okokatu'ãva'ero ko nde! A'ereki okyta rerekoe'ỹve'ga ja nde ere'e: “Ji ndarekoi jireakwari pe,” ere nde. Ehekyi na'ẽ ti okyta ejeakwara hugwi. A'ero po ti nde hepiakatui hekyita hay'iuhua gareakwara hugwi nehẽ, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","—I'yvakatuapora ko yva'ikatua. I'yvate'varuhuapora ko yva'ite'varuhua. ");
INSERT INTO pahNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Ahe okwaha i'yva. A'ereki ahe gwepia herekorame yva'ia ojihe, ei Jesus'ga. A'ereki ahe ndoykyi figo g̃wakag̃wa'yva hugwi. A'ereki g̃wakag̃wa'yva figo'yva rũi figueira rũi. Na jitehe ahe ndoykyi uva ka'api'iuhua hugwi. A'ereki ka'api'iuhua uva'yva rũi videira rũi, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","—Nane'ymi pyryve'ga reaporog̃itaro pyryva'ea rehe. Nurã ga ekatui jipi, ei Jesus'ga. A'ereki oyvyteri pe ga pyry hete, ei Jesus'ga g̃a pe. Nane'ymi ite'varuhuve'ga reaporog̃itaro ite'varuhuva'ea rehe. Nurã ga ete'varuhui, ei Jesus'ga. A'ereki oyvyteri pe ga ite'varuhu hete, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Kiro Jesus'ga ei: —Pe'e pe ji ve: “Ga ko nhandepojykaharetero.” Nahã pe ji renoi novĩa. Emo pe ndapekoi nhinhi'ig̃a rupi, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","—Kiroki ga uhu ji pyri ji rendukatuavo okovo nhinhi'ig̃a rupi – gaha ji ga mombe'ui pe me kiro, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Gaha onga apohara'ga ja – kiroki ga oapo onga hyvykoita yvy pe. Ipukuhu ga imondoi hyvykoita yvy pe itauhua apiavo. Itauhua rehe ga imondoi okyta ikwara pype. Nahã ga japoi onga imohina, ei Jesus'ga. Aerẽ hehanhuhũ yhya ua onhimombomomboa onga rehe novĩa. Yhya nomog̃atãi onga. A'ereki imondovo itauhua rehe ga oapo imohina, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","—Jara'ga ji rendu novĩa. A'ereki ga ndokoi nhinhi'ig̃a rupi. Gaha onga apohara'ga ja – kiroki ga oapo onga hyvykoje'yma imbovyre'yma okyta ikwara pype, ei Jesus'ga. Yvya rehe jate ga japoi onga imohina. Aerẽ hehanhuhũ yhya ua onhimombomomboa onga rehe imog̃atag̃atamo. Kotihĩ onga o'arahy upa opepẽpepenuhũavo, ei Jesus'ga g̃a mbo'eavo. ");
INSERT INTO pahNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Imombe'upavirẽ g̃a pe Jesus'ga hoi g̃a hugwi ogwovo cidade de Cafarnaum me. ");
INSERT INTO pahNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Pevo soldados'g̃a nduvihava'ga ruvi judeu'garũive'ga romano'ga. Gapyrive'ga itetirũa. Omano g̃werĩ ga. Soldados'g̃a nduvihava'ga ga arõhetei. ");
INSERT INTO pahNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Nurã Jesus'ga rura kwahavame Cafarnaum me ga ei xava'eve'g̃a pe: —Peho ti Jesus'ga pyri. Pe'ji ti ga pe tuhu ti ga jipyrive'ga pyri karugwara mombiga ga hugwi, ei ga xava'eve'g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","A'ero xava'eve'g̃a hoi Jesus'ga pyri ovahema javo ga pe: —“Tuhu ti ga,” ei soldados'g̃a nduvihava'ga nde ve. “Tuhu ti ga jipyrive'ga pyri karugwara mombiga ga hugwi,” ei ga nde ve, ei xava'eve'g̃a Jesus'ga pe. Eho tuhẽ ti a'ero, e'i hete xava'eve'g̃a Jesus'ga pe. Emombo ti karugwara gapyrive'ga hugwi. A'ereki ga pyry hete soldados'g̃a nduvihava'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Pyry hete ga nhandere'yja'g̃a pe g̃a arõheteavo g̃a nderekokatuavo. Ga oapouka onga nhandejatykahava, ei xava'eve'g̃a Jesus'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","A'ero Jesus'ga hoi g̃a ndupi tahepia ti ga javo. Ovahẽ g̃werĩ ga soldados'g̃a nduvihava'ga ronga pe. Kiro soldados'g̃a nduvihava'ga ei g̃a pe – kiroki g̃a ojikoty'a ga pavẽi – g̃a pe ga ei g̃a mondouka Jesus'ga rovatiamouka. —Peho ti Jesus'ga rovatiamo, ei ga g̃a pe. Pe'ji ti ga pe: “Omondo soldados'g̃a nduvihava'ga onhi'ig̃agwera nde ve. Ga e'i: ‘Jipojykaharetero nde ereko huvihavamo ji hohe. Nurã po ti nde nderejori ji pyri nehẽ hamo. ");
INSERT INTO pahNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Ji tuhẽ ndahoa'uvi nde pyri nde huvihavuhuro g̃waramo ji hohe. Irupeuhu ti embuhu epopoakara nhironga pe imombiguka karugwara jijipyrive'ga hugwi. A'ero po ti ga nhimohig̃atui nehẽ. ");
INSERT INTO pahNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Akwaha ji ndepopoakara mondoa irupeuhu. A'ereki na jitehe ji amondo soldados'g̃a jipi. Jiruvihava'ga ji mondoi no nahanahã eapo javo. A'ero ji rekoi ganhi'ig̃a rupi. Jihi soldados'g̃a nduvihavamo ako no. Ojipe'ga pe ji ei: Eho nahanahã japovo pevo ji ve. A'ero ga hoi okovo nhinhi'ig̃a rupi. Ojipe'ga pe ji ei: Ejo nahanahã japovo avo ji ve. A'ero ga ruri okovo nhinhi'ig̃a rupi. Jijipyrive'ga pe ji ei: Nahã eapo. A'ero ga japoi,’ ei ga.” A'ea ti pe'ji Jesus'ga pe, ei soldados'g̃a nduvihava'ga g̃a pe imondovouka onhi'ig̃agwera. ");
INSERT INTO pahNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","A'ero g̃a hoi okovo ganhi'ig̃a rupi Jesus'ga rovatiamo. G̃a omombe'u pa ganhi'ig̃agwera Jesus'ga pe. Ganhi'ig̃agwera renduvame Jesus'ga nhimomby'ai. Opyryrỹ Jesus'ga. Pevove'g̃a pe – kiroki g̃a oho ga rupi onhimongyavo – g̃a pe Jesus'ga ei: —Soldados'g̃a nduvihava'ga ojiko hete tuhẽ ji rehe! Jire'yja'g̃a hohe israelitas'g̃a hohe ga ojiko ji rehe! a'e ji pe me, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Kiroki g̃a ojikoty'a soldados'g̃a nduvihava'ga pavẽi – g̃ahã jivyra'javi soldados'g̃a nduvihava'ga ronga pe. Ovahemame g̃a gapyrive'ga repiagi. Onhimohig̃atua'ja ga! ");
INSERT INTO pahNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Aerẽ Jesus'ga hoi cidade de Naim me. Garemimbo'ehara'g̃a hoi ga rupi. Ojipe'g̃a hoi ga rupi no he'yjuhuve'g̃a. ");
INSERT INTO pahNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Ovahẽ g̃werĩ ga cidade apoa pe portão pe. Nanime ojipe'g̃a ivojave'ga ra'oa rerohoi pea rupi cidade hugwi Jesus'ga rovatiamo. Gweroho g̃a ivojave'ga ra'oa gakupeupava pype titỹ ti javo. Oho hẽa g̃a ndupi ivojave'ga yhẽa. Ga tehe ko hẽara'yramo. A'ero kiro hẽa tehe hẽa rekoi aherembirekokwerahẽa. He'yjuhuve'g̃a oho hẽa rupi cidade hugwi. ");
INSERT INTO pahNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Hepiagame Jesus'ga nhandepojykaharete'ga hẽa porogwetygi. A'ero ga ei hẽa pe: —Terejehe'oa'javi. ");
INSERT INTO pahNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Hẽara'yra'ga pyri ga hoi opokoga gakupeupava rehe. Nurã gara'oa rerohohara'g̃a heropytai o'ama. —Tapihã, ei ga ivojave'ga pe. A'e ji nde ve: Evy! ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","A'ero ga vyri onhi'ig̃a oina okwerava'java. Jesus'ga okwerava'jave'ga mondo gayhẽa pe. ");
INSERT INTO pahNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Okyhyji hete pa pevove'g̃a onhimomby'avo ga repiagame. A'ero g̃a Tupana'ga mbohetei. A'ereki g̃a e'i ojohupe Jesus'ga mombe'gwovo: —Tupana'ga nhi'ig̃a mombe'uharuhu'ga ruri kiro ojipiuka nhande pyteri pe upa, ei g̃a. Nahã Tupana'ga nhande pokogi, ei g̃a. ");
INSERT INTO pahNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","A'ero g̃a Jesus'ga mombe'umbe'ukatui jara'g̃a pe garembiapoa reheve Jesus'ga ga mbogwerava'javi javo. Nahã Judéiapeve'g̃a hendupavi Jesus'ga mombe'ua Judéia rembeyvyripeve'g̃a pavẽi. ");
INSERT INTO pahNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Aerẽ João Batistava'ea remimbo'ehara'g̃a Jesus'ga mombe'upavi João Batistava'ea pe. Jesus'ga rembiapoa garemimonhimomby'ava'ea g̃a imombe'ui ahe ve no. ");
INSERT INTO pahNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","A'ero João Batistava'ea mokonha'g̃a mbuhurukari ojipyri g̃wemimbo'ehara'g̃a. G̃a pe ahe ei: —Peho ti Jesus'ga pyri. Pe'ji ti ga pe: “Ymyahũ Tupana'ga nhi'ig̃a mombe'uharava'ea imombe'ui aerẽ po ti Tupana'ga remimbuhurukara'ga ruri nhande pyri nehẽ javo. Ma'g̃a po ahe omombe'u ymyahũ? Mara'ngu po ndehe? Mara'ngu po ojipe'ga? Nahã ore ei aheremimombe'uhara'ga rurapota.” A'ea mombe'gwovo katu ti pe'ji Jesus'ga pe: “Marãi nde a'ero?” ei João Batistava'ea mokonha'g̃a pe g̃wemimbo'ehara'g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","—Kwa, ei g̃a. A'ero g̃a hoi ogwovo Jesus'ga pyri ovahema. —João Batista'ga ore mondoukari nde pyri, ei g̃a Jesus'ga pe. Ga e'i ore ve: “Pe'ji ti Jesus'ga pe: ‘Ymya Tupana'ga nhi'ig̃a mombe'uharava'ea imombe'ui aerẽ po ti Tupana'ga remimbuhurukara'ga ruri nhande pyri nehẽ javo. Ma'g̃a po ahe omombe'u ymyahũ? Mara'ngu po ndehe? Mara'ngu po ojipe'ga? Nahã ore ei aheremimombe'uhara'ga rurapota.’ Nahã ti pe'ji Jesus'ga pe,” ei João'ga ore ve ore mondouka nde pyri, ei mokonha'g̃a Jesus'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Emo Jesus'ga nomondoi ve onhi'ig̃a João Batistava'ea pe. Oapo na'ẽ ga ahemonhimomby'ava'ea. Oapo ga ikwahavuka João Batistava'ea remimbo'ehara'g̃a pe a'ea ti pemombe'u João'ga pe javo. Kiro Jesus'ga imombigi karugwara he'yjuhuve'g̃a hugwi. Ojipe'g̃a pe hahy hete. G̃a hugwi ga imombipavi karugwaretea. Anhag̃a ga g̃a mbojipe'ai ojipe'g̃a hugwi no. Heakwagweve'g̃a ga g̃a moma'eg̃atuhetei he'yive'g̃a. ");
INSERT INTO pahNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Kiro Jesus'ga ei mokonha'g̃a pe João Batistava'ea remimbo'ehara'g̃a pe: —Pejivyra'ja ti pejigwovo João Batista'ga pyri. Pemombe'u ti ga pe penhimbiepiaga penhimienduva. Pe'ji ti ga pe imombe'gwovo: “Oma'eg̃atu kiro heakwagweve'g̃a okovo. Opo'ag̃atu kiro ipyka'naka'nauhũve'g̃a ogwovo katu. Oka'ẽ g̃ajagwa ijaijauhuve'g̃a hugwi. G̃wendu katu kiro japyakware'ỹve'g̃a okovo. Okwera tuhẽ omanove'g̃a kiro okovo. Imbatere'ỹve'g̃a g̃wendu kiro pyryva'ea Jesus Cristo'ga mombe'ua.” A'ea nhaporemo ti pemombe'u João Batista'ga pe. A'ea Jesus'ga ei ikwahavuka ga pe Jesus'ga ko Tupana'ga remimbuhurukara'ga javo – kiroki ga Tupana'ga nhi'ig̃a mombe'uharava'ea omombe'u ymyahũ. ");
INSERT INTO pahNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","—“Pyry hete ga pe – kiroki ga ndojikopigi ji rehe.” A'ea ti pe'ji João Batista'ga pe, ei Jesus'ga mokonha'g̃a pe João Batistava'ea remimbo'ehara'g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","A'ero g̃a hoi javo katu João Batistava'ea pe. G̃a horẽ Jesus'ga ei pevove'g̃a pe he'yjuhuve'g̃a pe João Batistava'ea mombe'gwovo. Ga e'i: —Ymya'ĩ pe peho ongae'ỹi me. Pevo pe pehepia João Batista'ga. Marãi pe pejiyvyteri pe pea rupi pejigwovo garepiaga renonde? Pe'e po pe: “Xaho hepiaga nhungwava – kiroki okooko'iuhu yvytua remimbotarimova'ea rehe onhimbovavaguka yvytua pe.” Pe ndape'ji tuhẽ reki a'ea. A'ereki João Batista'ga ko nhungwava ja rũi. Ga ndokondoko'iuhui ojipe'g̃a remimbotarimova'ea rehe. Ga ko onhimboita Tupana'ga rehe, ei Jesus'ga pevove'g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","—Marãi pe a'ero pejiyvyteri pe garepiaga renonde? Pe'e po pe: “Xaho ga repiaga – kiroki ga omongi tapy'ynhapipyryva. Gweroho pa po itambere'ia gapira.” A'ea pe ndape'ei oji'i, ei Jesus'ga. A'ereki João Batista'ga ndokohetei mbatera rehe. Ji rendu ti! João Batista'ga nomongi tapy'ynhapipyryva. Kiroki g̃a omongi ikatuheteva'ea – g̃ahã u huvihavuhu'g̃a nonga pype. He'yjuhu g̃ambatekatua no. ");
INSERT INTO pahNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","—Marãi pe a'ero pejiyvyteri pe? Pe'e po pe: “Xaho Tupana'ga nhi'ig̃a mombe'uhara'ga repiaga.” A'ea pe ekatui, ei Jesus'ga. Kiro ji ei pe me: João Batista'ga ko Tupana'ga nhi'ig̃a mombe'uhara'ga tuhẽ. Tupana'ga nhi'ig̃a mombe'uharuhu'ga jate rũi ko ga, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","—Ymyahũ Tupana'ga okwatijaruka ahe ve João Batista'ga mombe'gwovo hako ga po ti nhinhi'ig̃a mombe'ui nehẽ javo, ei Jesus'ga. Aherembikwatijara e'i: “Nahã Tupana'ga ei Cristo'ga pe: ‘Nde renonde po ti ji ga mondoi imombe'uuka nhinhi'ig̃a nehẽ. Tomboavujikwe ti ga nderura renonde,’ ei Tupana'ga,” e'i aherembikwatijara, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","—Ag̃wamo Tupana'ga rembiepiakatuhava. Ag̃wamo po ti Tupana'ga he'yjuhuve'g̃a nduvihavuhuhete'ga nehẽ, ei Jesus'ga. A'e ji pe me: João Batista'ga ko koji'i huvihava ymyahũva'ea hohe pa. Emo ag̃wamove'g̃a reki Tupana'ga rembiepiakatuhara'g̃a ko koji'i huvihava João Batista'ga hohe. Kiroki g̃apyteripeve'g̃a huvihava rũi – g̃a vehevi koji'i huvihava João Batista'ga hohe, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Jesus'ga nhi'ig̃a rendupavame g̃a ei Tupana'ga pe itambere'ia mono'õhara'g̃a pavẽi: —Ndehe ko erekwaha hete epyryvamo João Batista'ga mbuhua ore pyri te'i ti ga g̃a pe javo. A'ea g̃a ei. A'ereki g̃a onhimobatizauka João Batistava'ea pe opohia okote'varuhua hugwi ahe erame. ");
INSERT INTO pahNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Fariseus'g̃a ki a'e te judeus'g̃a mbo'ehara'g̃a pavẽi nohendukatui João Batistava'ea nhi'ig̃a ikwahapotare'yma Tupana'ga remimbotarimova'ea ojive. A'ereki g̃a nonhimobatizaukari ahe ve opohire'yma okote'varuhua hugwi. ");
INSERT INTO pahNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","—Marã po ti ji ei pe me ag̃wamova'ea pe a'ero nehẽ? ei Jesus'ga. Gara ja pe ndekoi a'ero? ei ga. ");
INSERT INTO pahNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Kiro ji pe mombe'ui pe me. Tayri'g̃a ja ko pe ndekoi. Oapy tayri'g̃a ima'ẽhai pe feira pe. A'ero g̃a hapukai ojohupe. Onhi'ig̃a mondovo g̃a ei: “Oropy ore jiru'a pe me xajory ti nhanerembirekoa rehe javo. Pe ki a'e te ndapeyrerupypotari henduvame. Xajehe'o ti nhanenhikamombava rehe, oro'e ore pe me. A'ero ore jehe'oi. Pe ki a'e te ndapejehe'oi ore pyri. A'ereki pe ndapepotariuhu.” Nahã tayri'g̃a ei ojohupe, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","—Tayri'g̃a ja pe ndekoi. A'ereki pe pe'epe'e João Batista'ga pe jipi. A'ereki ga rurame pe pyri ga ndo'uahivuhui mbatera vinho reheve tambohete ti ji Tupana'ga javo, ei Jesus'ga. A'ero pe epe'ei ga mombe'gwovo: “Anhag̃a opyhy ga.” Nahã pe João Batista'ga mombe'ute'varuhui ga arõe'yma, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","—Tayri'g̃a ja pe ndekoi. A'ereki pe pe'epe'e ji ve no, ei Jesus'ga g̃a pe. Yvyakotyva'ero yvagipeva'ero ji ajo pe pyri mbatera i'gwovo vinho i'gwovo no. A'ero pe epe'ei ji mombe'gwovo: “Ehepia Jesus'ga! O'uheteuhu ga. Ga ko heagwyryve'ga vinho i'gwovo,” pe'e pe ji ve, ei Jesus'ga. “Kiroki g̃a omono'õ itambere'ia governo pe ite'varuhuve'g̃a – g̃a pavẽi Jesus'ga ojikoty'a ojipe'g̃a pavẽi no okote'varuhuve'g̃a pavẽi,” pe'e pe. Nahã pe euhui ji mombe'gwovo ji arõe'yma, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","—Ojipe'g̃a ndekokatua repiaga g̃waramo nhande ei: Tupana'ga reki okwahavuka g̃a pe g̃a mongokatuavo, ei Jesus'ga. Ojipe'g̃a ndekote'varuhua repiaga g̃waramo nhande ei: Tupana'ga rũi omongo g̃a ite'varuhua rehe, ei Jesus'ga g̃a mbo'eavo. ");
INSERT INTO pahNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Aerẽ Simão'ga fariseu'ga ei Jesus'ga pe: —Ejo ti nhironga pype i'gwovo ji pyri. —Kwa, ei Jesus'ga. A'ero Jesus'ga hoi ga rupi garonga pype oapyga mesa pyri ga pavẽi. ");
INSERT INTO pahNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Nanime cidadepevehẽa – kiroki hẽa oko te'varuhu – hẽa ikwahavi Jesus'ga hoa fariseu'ga ronga pype. Ga i'urame hẽa heruri perfume nhandya hyrua pype. Hyrua ko alabastrova'ea ita apopyra. ");
INSERT INTO pahNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Gapya koty hẽa ami ga reviri ojehe'gwovo okote'varuhua rehe. Hẽareahya imoakymi gapya. A'ero hẽa gapya monduvynduvyri o'ava pyvõ gapya beijavo. A'ero perfume hẽa imongyi gapya rehe. A'ereki hẽa ga arõ hete. ");
INSERT INTO pahNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Hẽa repiagame fariseu'ga – kiroki ga e'i Jesus'ga pe ejo ti i'gwovo ji pyri javo – kiro ga ei oyvyteri pe: “Hehã okote'varuhuvehẽa. Mara'ngu po Jesus'ga Tupana'ga nhi'ig̃a mombe'uhara naerũ? Po Jesus'ga Tupana'ga nhi'ig̃a mombe'uhara tuhẽ, a'ero po ga ombaragwaha hẽa rehe hamo. Po ga ei hẽa pe hamo: ‘Tanhimbote'varyme ti epokoga ji rehe,’ e po ga okote'varuhuvehẽa pe hamo. Jesus'ga nombaragwahavi reki hẽa rehe,” ei fariseu'ga oyvyteri pe. ");
INSERT INTO pahNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","A'ero Jesus'ga ei fariseu'ga pe: —Simão, ei Jesus'ga. Tamombe'u ti nde ve. —Orembo'eharamo emombe'u ti ji ve a'ero, ei Simão'ga Jesus'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Ga mbo'eavo Jesus'ga imombe'ui ga pe. Ga e'i: —Itambere'ia mondo'ãhara'ga pe mokonha'g̃a ei momi ti embuhu'rã itambere'ia ore ve javo. A'ero ga imondo'ag̃i g̃a pe tombuhura'ja ti g̃a koa irũ reheve ji ve nehẽ javo. He'yiva'ea quinhentos itambere'ia ga imondo'ag̃i ojipe'ga pe. Ndahe'yiva'ea cinquenta itambere'ia ga imondo'ag̃i ojipe'ga pe. G̃a memei gweroho ga hugwi a'ero. ");
INSERT INTO pahNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Aerẽ g̃a ipo'rupavi herekoe'yma. Nurã g̃a ndogwerekoi ikwepykavamo. A'ereki ahã g̃a pe. Itambere'ia mondo'ãhara'ga oporogwety reki g̃a. Nurã ga ihypavi reki g̃aconta hugwi tapembuhura'javi ti itambere'ia ji ve a'ero javo, ei Jesus'ga imombe'gwovo. —Manamo g̃a ga arõhetei? Manamo g̃a ga aroi'ĩ? ei Jesus'ga Simão'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","A'ero Simão'ga ei ga pe: —Po ga – kiroki ga gweroho koji'iva'ea ga hugwi quinhentos itambere'ia – po gaha itambere'ia mondo'ãhara'ga arõ hete. A'ereki gaconta hugwi imondo'ãhara'ga ohy he'yiva'ea, ei ga. —Na tuhẽ, ei Jesus'ga. Kiroki ga gweroho koji'iva'ea – gaha oarõ hete itambere'ia mondo'ãhara'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Kiro Jesus'ga ojirova hẽa koty. Simão'ga pe ga ea'javi: —Erehepia nde hẽa? Ji ruri nenonga pype nde repiaga. Ndehe nerembuhuri yhya ji ve jipyheitava ekoe'yma nhaneramonhava'ea mog̃itagwera rehe – kiroki a'ea e'i nahanahã ahe omboapy ojipe'g̃a javo. Hẽa ki a'e te hẽareahya omoakỹ jipya. Omonduvynduvy hẽa jipya o'ava pyvõ. Nahã hẽa roryroryvamo ji rehe, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","—Ndehe nanhibeijai tuhẽ ekoe'yma nhaneramonhava'ea mog̃itagwera rehe – kiroki a'ea e'i nahanahã ahe omboapy ojipe'g̃a javo. Hẽa ki a'e te jipya nobeijabeijapigi ji rurirẽ nenonga pype. Nahã hẽa roryroryvamo ji rehe, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","—Ndehe neremongyi ikava nhiakag̃a rehe ekoe'yma nhaneramonhava'ea mog̃itagwera rehe – kiroki a'ea e'i nahanahã ahe omboapy ojipe'g̃a javo. Hẽa ki a'e te omongy perfume jipya rehe. Nahã hẽa roryroryvamo ji rehe, ei Jesus'ga fariseu'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","—Nurã ji ei nde ve: Tupana'ga ihyjipei hẽarekote'varuhua ikwahava'jave'yma. He'yjuhu hẽarekote'varuhua, ei Jesus'ga. Hẽa hugwi Tupana'ga imombori. Nurã hẽa Tupana'ga arõhetei gworygworyva repiuka nhandepyteri pe, ei Jesus'ga. Po ojipe'ga okote'va gwere. Tupana'ga garekoteva'ria hypavame oarõ gwere ga Tupana'ga gwory'viro ga rehe, ei Jesus'ga Simão'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Hẽa pe Jesus'ga ei kiro: —Amomboripe ji nderekote'varuhua nde hugwi, ei ga. ");
INSERT INTO pahNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Kiroki g̃a oapy mesa pyri ga pavẽi – g̃a ei oyvyteri pe: “Ma'g̃a Jesus'ga naerũ? Maranuhũrame ga hẽarekote'varuhua mombori naerũ?” ei g̃a. ");
INSERT INTO pahNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","A'ero Jesus'ga ei hẽa pe: —Nde jikoga g̃waramo ji rehe ji imombori nderekote'varuhua nde hugwi. Tu katu ndepy'a nde horame a'ero, ei ga. ");
INSERT INTO pahNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Aere'ĩ Jesus'ga imbojoapiapi cidades repiapava cidades'ia repiapava. He'yjuhu cidades cidades'ia pavẽi. Pyryva'ea ga imombe'ui cidadespeve'g̃a pe. G̃a pe ga ei: —Perojijyjijyjuka ti pejeaporog̃ita Tupana'ga pe pejikoga ga rehe. A'ero po ti ga pe pokokatui nehẽ imomboa pendekote'varuhua pe hugwi okovo penduvihavuhuhetero nehẽ. Nahã Jesus'ga ei g̃a pe ogwovo g̃a pyg̃apyri. Ga rupi dozeve'g̃a hog̃ahoi. ");
INSERT INTO pahNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Kunhangwera'g̃a g̃a hog̃ahoi ga rupi no. Jara'g̃a hugwi Jesus'ga ombojipe'a jipe anhag̃a. Jara'g̃a hugwi ga imombigi karugwara. Mariahẽa hugwi Jesus'ga ombojipe'a jipe sete anhag̃a Diabo'gapyriva'ea. Mariahẽa pe ahe ei: Madalapevehẽa. ");
INSERT INTO pahNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Ojipehẽa rera Joana. Joanahẽa rembireko'ga ko Cuza'ga. Ga ko Herodes'ga mbatera repiakatuhara'ga. Ojipehẽa rera Susana. G̃ahã oho Jesus'ga rupi. Ojipe'g̃a kunhangwera'g̃a hoi ga rupi no. Imondovo ga pe ombatera g̃a Jesus'ga repiakatui. Dozeve'g̃a pe g̃a imondoi no. ");
INSERT INTO pahNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Cidades nanani ojipejipea hugwi he'yjuhuve'g̃a nduri Jesus'ga pyri. Ojo'java'ea pyvõ ga g̃a mbo'embo'ei. G̃a pe ga ei: ");
INSERT INTO pahNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","—Ha'ynha mohãihara'ga hoi ko pe imohaina ha'ynha. Nahã ga itymi ha'ynha. Ga imohãirame ha'ynha jara indurugi pehea rembeyvyra rupi. A'ero ahe pyrug̃i hehe ohorame pehea rupi. Ua gwyra'ia i'ui imokona, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","—Ga imohãirame ha'ynha jara indurugi yja rehe ita arimo. A'ereki ita onhimongyheteuhu pevo. Xunhi yja a'ero ha'ynha pe yhya no. Henhunhame kotihĩ he'ouhũ omanomo. A'ereki ahã yhya jupe. ");
INSERT INTO pahNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","—Ga imohãirame ha'ynha jara indurugi nhungwava ra'ynha pyteri pe hatĩava'ea ra'ynha pyteri pe. Aerẽ ga'apoa ha'ynha renhunhamo nhungwava ra'ynha pavẽi. A'ero nhungwava nhambyguhui garemityma, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","—Ga imohãirame ha'ynha jara indurugi yjakatua pype. A'ero henhunhamo o'ao'aheteramo. He'yjuhu ahara a'ero. Ahara pype turi cem ha'ynha, ei Jesus'ga ha'ynha mohãihara'ga mombe'gwovo. Onhi'ig̃a mondovo Jesus'ga ei g̃a pe: —Peapyakwa pe. Pehendu katu ti ji'ea a'ero! ei Jesus'ga g̃a pe imombe'gwovo ojo'java'ea. ");
INSERT INTO pahNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","A'ero Jesus'ga remimbo'ehara'g̃a ei ga pe: —Orohendu ore novĩa nde'eagwera ojo'java'ea. Ndorokwahavi reki ore. Ore ve ti emombe'u a'ea. ");
INSERT INTO pahNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","A'ero Jesus'ga ei g̃a pe: —Pe me Tupana'ga ei tokwaha ti g̃a onhimiva'ea nhirembiepiakatuhava javo, ei Jesus'ga. Marã hekoi kiro Tupana'ga yvyakotyve'g̃a ndepiakaturame okovo g̃anduvihavuhuhetero? A'earupiva'ea kiro ga ikwahakwahavukari pe me, ei Jesus'ga g̃wemimbo'ehara'g̃a pe. Ojipe'g̃a pe ji imombe'ui ojo'java'ea. A'ero “hepiagame g̃a gwepia tehe reki. A'ereki g̃a nombaragwahapotari hehe. Henduvame g̃a g̃wendu tehe reki. A'ereki g̃a ndokwahapotari”, ei Jesus'ga g̃wemimbo'ehara'g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","12","—Kiro po ti ji imombe'ukatui pe me ikwahavuka ha'ynha mohãihara'ga mombe'ua nehẽ, ei Jesus'ga g̃wemimbo'ehara'g̃a pe. —Ha'ynha ko Tupana'ga nhi'ig̃a, ei Jesus'ga. Kiroki g̃a g̃wendu Tupana'ga nhi'ig̃a novĩa ikwahave'yma – g̃a pyri ahemoandyandyihara'ga Diabo'ga ruri a'ero ipe'avo imombe'ua g̃apy'a hugwi imoka'nhymbavuka g̃a pe tomomborukaryme ti g̃a Tupana'ga pe okote'varuhua javo, ei Jesus'ga. G̃a pe ji ei a'ero imombe'urame ha'ynha indurugagwera pehea rembeyvyra rupi. ");
INSERT INTO pahNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","—Amombe'u jipe ko ji ha'ynha indurugagwera – kiroki a'ea onduru ita rehe. Henhui ha'ynha novĩa. A'ereki yhya rerekoe'yma g̃waramo, kotihĩ nonhimomiranami a'ero omanomo, ei ga. A'ereki ndokihetei hapoa yvya pype. —A'ea ja g̃a ndekoi – kiroki g̃a g̃wendu nhanderuvihavuhuhete'ga mombe'ua gworygworyvamo hehe novĩa. Aerẽ ojipe'g̃a mbote'varuhu pota g̃a imohepia'ngiavo ite'varuhuva'ea g̃a pe. Nurãro g̃waramo g̃a nonhimomiranami a'ero kotihĩ opohia nhanderuvihavuhuhete'ga mombe'ua hugwi. A'ereki ndokihetei nhanderuvihavuhuhete'ga mombe'ua g̃ayvyteri pe. ");
INSERT INTO pahNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","—Amombe'u jipe ko ji ha'ynha indurugagwera – kiroki a'ea onduru nhungwava ra'ynha pyteri pe hatĩava'ea ra'ynha pyteri pe. Aerẽ igwaigwavete hatĩava'ea nhambyguhui garemityma jukavo, ei Jesus'ga. —A'ea ja ojipe'g̃a ndekoi nhungwava pyteripeva'ea ja. G̃a g̃wendu ojipe'g̃a erame g̃a pe: “Tupana'ga nhande poko katu kiro nhanderuvihavuhuhete'ga.” A'ea g̃a g̃wendu katu novĩa. Aerẽ g̃a ag̃ataruhuramo ojihe javo: “Maramarã po ti nhande rekoi nehẽ naerũ?” ei g̃a oyvyteri pe. A'ea nonog̃atuukari g̃apy'a. A'ereki g̃a opotaruhu itambere'ia a'ero, ei Jesus'ga. “Koji'i nhande tipotaruhu itambere'ia,” e'iuhu g̃a, ei Jesus'ga. Toryva rehe ikatuva'ea rehe g̃a japyakauhui. A'ea nhaporemo nohenduva'javukari nhanderuvihavuhuhete'ga mombe'ua. A'ero igwaigwavete g̃a ndojapyakaa'javi tuhẽ gamombe'ua rehe. A'ero g̃a ndokoa'javi reki gamombe'ua rupi okokatue'yma ojipe'g̃a pe oporavykye'yma ga pe. ");
INSERT INTO pahNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","—Amombe'u jipe ko ji ha'ynha indurugagwera – kiroki onduru yjakatua pype. A'ea ja ojipe'g̃a ndekoi yjakatuapypeva'ea ja. G̃wendu katu g̃a nhanderuvihavuhuhete'ga mombe'ua ojikoheteavo ga rehe gweaporog̃itakaturo. Onhimomirana hete g̃a oporavykyavo ga pe ga nhi'ĩpo'rupava okokatuavo ojipe'g̃a pe. A'ea Jesus'ga ei imombe'gwovo pa ojo'java'ea ikwahavuka g̃wemimbo'ehara'g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","—Imondygame lamparina nhande ndihovapygi hyrua pyvõ, ei Jesus'ga. Nimondoi nhande lamparina nhanenhinongava gwyri pe cama gwyri pe. Pyte'mbia rehe nhande timondo lamparina. Nurã okirame onga pype ojipe'g̃a gwepia kojahua. ");
INSERT INTO pahNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","—Na jitehe po ti Tupana'ga imboukwahavi nehẽ. Onhimiva'ea po ti ga hepiukari ikwahavuka henduvukapava nehẽ. ");
INSERT INTO pahNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","—Ji rendu katu ti a'ero pejeaporog̃itaro. Kiroki ga okwaha – ga pe po ti Tupana'ga ikwahavukari koji'iva'ea nehẽ. A'ero po ti ga ikwahahetei nehẽ, ei Jesus'ga. Kiroki ga ndokwahavi – po ga ikwahavi xunhiva'ea, a'ea vehevi po ti Tupana'ga ikwahava'jave'ymukari ga pe nehẽ, ei Jesus'ga g̃wemimbo'ehara'g̃a mbo'eavo. ");
INSERT INTO pahNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Kiro Jesus'ga yembora ruri Jesus'ga repiaga gairũ'g̃a pavẽi. Ndoki g̃a onga pype ga pyri. A'ereki pevove'g̃a ga mbotymboty gwe'yjuhuro. ");
INSERT INTO pahNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","G̃apyteripeve'g̃a e'i Jesus'ga pe: —Neyhẽa uhu nde repiaga neirũ'g̃a pavẽi. Pevo g̃a ami okari pe. ");
INSERT INTO pahNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","A'ero Jesus'ga ei g̃a pe: —Kiroki g̃a Tupana'ga nhi'ig̃a rendu katu ga nhi'ĩpo'ruavo – g̃a pe ji ei nhiy'g̃a. A'e ji g̃a pe no nhiirũ'g̃a, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Aerẽ Jesus'ga avi yharuhua pype g̃wemimbo'ehara'g̃a pavẽi. G̃a pe ga ei: —He xaho ypiahua aherovai. A'ero g̃a imoanhani herogwovo. ");
INSERT INTO pahNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","G̃a gwerohorame Jesus'ga ropehyiro okia. Yvyturanuhũa ruri ojyva ypiahua rehe. Yharuhua pype yvytua yhya mbo'ambo'avi. Gweroho g̃werĩ ypy pe. ");
INSERT INTO pahNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","A'ero g̃a hoi Jesus'ga pyri ga mongirahiva. —Kiro nhande hoi ypy pe nhandepapava nehẽ! ei g̃a ga pe ombo'ehara'ga pe. A'ero ga ma'ẽi onhi'ig̃a yvyturanuhũa pe typepemuhũa pe no topi ti javo. A'ero yvytua ipigi. Notymynha'javi yhya no. ");
INSERT INTO pahNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","G̃a pe Jesus'ga ei: —Ndapejikogi ji rehe naerũ? ei ga. A'ero g̃a kyhyji onhimomby'avo javo ojohupe: —Marã te ga rekoi naerũ? Yvytua vehevi re po g̃wendu katu ganhi'ig̃a yhya pavẽi, ei g̃a. ");
INSERT INTO pahNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Aerẽ g̃a hoi ypiahua aherovai Galiléia aherovai ovahema Gerasapeve'g̃a gwyri pe. ");
INSERT INTO pahNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Jesus'ga hemame yharuhua hugwi cidadepeve'ga ruri Jesus'ga repenhana. He'yjuhu anhag̃a Diabo'gapyriva'ea onhimongyavo ga pojykavo. Ymyahũ ga ndipiri. Ga nduva'javi onga pype. Itaruvihavuhua kwaruhua pyteri pe ga ruvi aheryvya pyteri pe. ");
INSERT INTO pahNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Jesus'ga repiagame ga hapukai g̃wenypy'anduruga Jesus'ga rovai pyteri pe. Ga hapukajahivi javo: —Jesus! ei ga. Terejori ji avykyavo Tupana'ga ra'yramo huvihavuhu'g̃ahoheve'ga ra'yramo? ei ga Jesus'ga pe. A'e hete ji nde ve: Terembuhuri ti hahyva'ea ji ve. ");
INSERT INTO pahNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","A'ea ga ei. A'ereki Jesus'ga e'i jipe anhag̃a pe: —Ejipe'a ga hugwi. Ymyahũ anhag̃a ga pyhypokãpokag̃i ga pojykavo jipi. Nurã pevove'g̃a itanhuramuhũa pyvõ gapoa kwari. G̃a gapya kwari no. Nahã g̃a ga mombytapotari ga repiakatuavo novĩa. Ga omondohondoho itanhuramuhũa reki. Anhag̃a ga pojykai ga renonhaheteavo ga mondovo ongae'ỹi me. Nahã ga rerekoi ymya. ");
INSERT INTO pahNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Kiro Jesus'ga ei ga pe: —Gara nderera? A'ero ga ei: —He'yjuhu. Nahã garera. A'ereki he'yjuhuva'ea anhag̃a opojyka ga. ");
INSERT INTO pahNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Anhag̃a e'i hete Jesus'ga pe: —Toremondoi ti yvykwara ruvihavuhua pype hahyva'ea ruvihava pype, e'i ga pe. ");
INSERT INTO pahNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Yvytyra rehe porcos tuvi i'gwovo onhimongyavo. He'yjuhu hete porcos. Jesus'ga pe anhag̃a ehetei: —Ore mondouka ti porcos pojykauka ore ve, e'i. —Peho ti a'ero, ei Jesus'ga jupe. ");
INSERT INTO pahNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Cidadepeve'ga hugwi anhag̃a jipe'ai a'ero ogwovo Jesus'ga nhi'ĩpo'ruavo porcos pojykavo herogwovo. Porcos nhaporemo inhahetei ojyva yvyty'ramuhũa hugwi ogwovo ypiahua pype otypyvygamo omanomo. ");
INSERT INTO pahNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Porcos manoa repiagame porcos repiakatuhara'g̃a nhani ogwovo jugwi. Ogwovo g̃a imombe'upavi cidadepeve'g̃a pe cidadekotyive'g̃a pe no. ");
INSERT INTO pahNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","A'ero pevove'g̃a nduri ua torohepia katu javo. Ovahemame Jesus'g̃a pyri g̃a ga repiagi anhag̃a rembipojykaagwera'ga. Oapy ga Jesus'ga pya pyri tapy'ynhapira mongijipeavo ojapyakakatuavo. A'ero g̃a kyhyji. ");
INSERT INTO pahNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Kiroki g̃a gwepia Jesus'ga anhag̃a mbojipe'arame ga hugwi – g̃a imombe'upavi g̃a pe javo: —Ga pyryvamo reki kiro. A'ereki Jesus'ga ombojipe'a anhag̃a ga hugwi imondovo, ei g̃a ga mombe'gwovo g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Okyhyji hete pa g̃a Gerasapeve'g̃a. Nurã g̃a ei Jesus'ga pe: —Heregwovo ore hugwi! A'ero Jesus'ga avi yharuhua pype tajivy javo. ");
INSERT INTO pahNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","A'ero anhag̃a rembipojykaagwera'ga ehetei Jesus'ga pe: —Taho ti nde rupi jijikoty'a nde pavẽi! ei ga. Jesus'ga ndogwerohoi ga reki. A'ereki ga e'i ga pe: ");
INSERT INTO pahNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","—Epyta. Ejivy ti enhonga pe imombe'gwovo. Ere ti g̃a pe: “Tupana'ga ipopoaka hete. Ji poko hete ga!” Nahã ti ere g̃a pe, ei Jesus'ga ga pe. A'ero ga hoi imombe'gwovo g̃a pe nhaporemo cidadepeve'g̃a pe. —Pyry hete Jesus'ga ji ve ji pokoga anhag̃a mbojipe'avo ji hugwi. Ga popoakahetero, ei ga imombe'gwovo. ");
INSERT INTO pahNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Gerasapeve'g̃a hugwi Jesus'ga jivyri ua ovahema aherovai. G̃a nhaporemo ga repenhani gworygworyvamo ga rehe. A'ereki pevo g̃a oko tuhu tuhẽ ti ga javo. ");
INSERT INTO pahNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Nanime ga pyri Jairo'ga ruri. Jairo'ga ko huvihavamo oko judeus'g̃a jatykahava pype. Ga ruri onhinog̃a ojovapyvo yvyvo Jesus'ga pya pyri jihoheva'ero ji poko javo. —Herejo nhironga pe, ei ga Jesus'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","A'ereki jira'yrahẽa omano g̃werĩ, ei ga. Hehã jate ko gara'yra. Ivoja hẽa. Doze anos hẽa imbokwara'ari ojihe. Jesus'ga horame tahepia ti ji tayrihẽa javo, he'yive'g̃a ga mbotyvahivi ua ga rupi onhimongyavo. ");
INSERT INTO pahNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ga reviri hẽa ruri no itetirũavehẽa gwypovehẽa. He'yi doze anos hẽatetirũa imbokwara'ari hẽa rehe opige'yma hẽa hugwi. Omondo pa hẽa opohanohara'g̃a pe novĩa. A'ereki g̃a nomombigi reki hẽatetirũa. ");
INSERT INTO pahNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Kiro hẽa ruri Jesus'ga reviri opokoga gapira rembeyvyra rehe. Kotihĩ hẽa ndagwypora'javi a'ero. ");
INSERT INTO pahNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","—Ma'g̃a opoko ji rehe? ei Jesus'ga. A'ero g̃a epavi: —Ore rũi! Ndoropokogi nde rehe, ei g̃a. —Nde mbotymboty pa g̃a nde atimana he'yive'g̃a! Nde mbotyva g̃waramo g̃a pokogi nde rehe. Nahã Pedro'g̃a ei Jesus'ga pe ombo'ehara'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","A'ero Jesus'ga ei: —A'ea rũi. Opoko aha g̃a ji rehe. Akwaha ji jiyvyteri pe. A'ereki ji hugwi ihoi jipopoakara g̃a ndehe, ei ga. ");
INSERT INTO pahNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","A'ero hẽa ei oyvyteri pe: “Okwaha reki ga ji pokogame ga rehe.” A'ero hẽa ruri ohyhyipava okyhyjiavo g̃wenypy'anduruga yvyvo garovai pyteri pe onhimombe'gwovo g̃andovaki pa. Hẽa e'i: —Ymyahũ ji tetirũaramo gwyporo. Nurã ji pokogi nde rehe tomombi ti ga ji hugwi javo. Kotihĩ nhitetirũa pigi tuhẽ ko, ei hẽa. ");
INSERT INTO pahNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","—Kui'i, ei Jesus'ga hẽa pe. Erejiko nde ji rehe. Nurã netetirũa pigi nde hugwi. Ndepy'a rukaturo g̃waramo kiro heregwovo katu, ei ga. ");
INSERT INTO pahNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Jesus'ga nhi'imbige'ymame hẽa pe Jairo'ga rongapypeve'ga ruri javo Jairo'ga pe: —Ndera'yrava'ea omano. Tohoa'javyme ti nhanembo'ehara'ga kiro neronga pe. A'ereki ahe omano jipe. ");
INSERT INTO pahNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Ga renduvame Jesus'ga ei Jairo'ga pe: —Teremomyi ti epy'a. Ejiko hete jitehe ji rehe. A'ero po ti hẽa kwerava'javi nehẽ, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Ovahemame Jairo'ga ronga pe Jesus'ga g̃a mongiukari ojupi onga pype Pedro'ga João'ga no Tiagova'ea no. Kujahẽa ruva'ga ga ga mongiukari kujahẽa yhẽa no. Ojipe'g̃a pe Jesus'ga ei: —Tapeki ti onga pype, ei ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Ojehe'o hete pevove'g̃a kujahẽa rehe okovo. A'ero Jesus'ga ei g̃a pe: —Tapejehe'oi! Nomanoi hẽa. Oki reki hẽa upa. ");
INSERT INTO pahNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","A'ero g̃a ga jai ga rerekovo ga rerekomemuamo. A'ereki g̃a okwaha ahemanoa. ");
INSERT INTO pahNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","G̃a mondopavirẽ onga hugwi ga kujahẽa popyhygi. Hẽa pe ga ei: —Kui'i! Epo'ã! ");
INSERT INTO pahNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Kiro hẽa kweravi. Kotihĩ hẽa po'ami. A'ero Jesus'ga ei g̃a pe: —Pemondo ti mbatera hẽa pe to'u ti hẽa. ");
INSERT INTO pahNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Onhimomby'a hẽaruva'ga hẽayhẽa pavẽi. Jesus'ga ei g̃a pe: —Tapemombe'ui tuhẽ ti nhiremimbogweravahẽa nhiremimonhimomby'ava'ea ojipe'g̃a pe, ei ga. ");
INSERT INTO pahNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Aerẽ Jesus'ga g̃a mbuhurukari ojipyri g̃wemimbo'ehara'g̃a dozeve'g̃a g̃a mbopopoaka. Ga ombopopoaka g̃a tombojipe'a ti g̃a anhag̃a Diabo'gapyriva'ea ojipe'g̃a hugwi javo. Nahã g̃a popoakaramo anhag̃a hohe pa. Ga ombopopoaka g̃a tokwaha pa ti g̃a karugwara imombiga itetirũave'g̃a hugwi javo. ");
INSERT INTO pahNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","—Kiro po ti ji pe mondoi ojipe'g̃a pyri nehẽ, ei Jesus'ga. Pemombe'u katu ti Tupana'ga g̃a pe. Pe'ji ti g̃a pe: “Tupana'ga oko g̃werĩ nhanderuvihavuhuhetero nhande repiakatuavo yvya koty nhande mongovo onhi'ig̃a rupi.” A'ea ti pe'ji g̃a pe, ei Jesus'ga dozeve'g̃a pe. Pemombi ti karugwara itetirũave'g̃a hugwi. ");
INSERT INTO pahNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Taperohoi ti mbatera pejive pehorame imombe'gwovo g̃a pe. Taperohoi ti yvyra pejikohavamo. Taperohoi ti sacola, pão, itambere'ia. Taperohoi ti irũa tapy'ynhapira camisa'java'ea, ei Jesus'ga dozeve'g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","—Pe vahemame g̃acidades pe po g̃ande'yja'ga ei pe me: “Hepejijo pejipytavo nhironga pype.” Ga erame na pe me peho ti garonga pe a'ero, ei Jesus'ga g̃a pe. Ga pyri jate ti peju. Aerẽ po ti pe hoi ojipe pe cidade pe nehẽ. A'ero jate po ti pejijyi garonga hugwi pejigwovo a'ero nehẽ, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Po ongapypeve'g̃a ndohoryvi pe ndehe tapepytai ti javo pe me pe vahemame g̃acidade pe. Pehorame g̃acidade hugwi ti pemonduru otimbuguhua pejipya hugwi oropohi ore pe hugwi javo. Pe'ji ti g̃a pe: “Peko te'varuhu pe hendupotare'yma Tupana'ga nhi'ig̃a,” ei Jesus'ga g̃wemimbo'ehara'g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Kiro g̃a hoi a'ero Jesus'ga nhi'ig̃a rupi cidades pe imbojoapiapiavo. Pevove'g̃a pe g̃a imombe'ui pyryva'ea Jesus'ga mombe'ua. Itetirũave'g̃a hugwi g̃a imombimombigi karugwara. ");
INSERT INTO pahNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","A'ea rupi Herodes'ga hendupavi Jesus'ga rembiapoa mombe'ua garemimonhimomby'ava'ea mombe'ua. Herodes'ga omondomondo g̃wemimbotarimova'ea rupi Galiléiapeve'g̃a gwyri pe. —Marã Jesus'ga naerũ? ei ga. A'ea ga ei ikwahave'yma. A'ereki jara'g̃a e'i: —Jesus'ga ko João Batista'ga reki. João Batista'ga ovy gwyvya hugwi, ei g̃a. ");
INSERT INTO pahNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Jara'g̃a e'i: —Jesus'ga ko Elias'ga. Elias'ga ojipiuka ore ve ko, ei g̃a. Ojipe'g̃a e'i: —Jesus'ga ko Tupana'ga nhi'ig̃a mombe'uharava'ea pyteripeve'ga – kiroki ymyahũve'ga. Ovy ga gwyvya hugwi, ei g̃a. ");
INSERT INTO pahNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","A'ero Herodes'ga ei: —Jesus'ga ko João Batistava'ea rũi. A'ereki ji Joãova'ea akag̃a momboruka ikwehe'i. Maranuhũ Jesus'ga naerũ? Omombe'u g̃a ji ve garemimonhimomby'ava'ea. Tahepia ji gara'oa a'ero, ei ga. Herodes'ga gwepia pota hete Jesus'ga okovo. ");
INSERT INTO pahNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Aerẽ ojivyrame Jesus'ga pyri Jesus'ga moirũhara'g̃a dozeve'g̃a imombe'upavi g̃wembiapoa ga pe. Ojupi Jesus'ga g̃a nderohoi jara'g̃a hugwi a'ero g̃a nderogwovo ongae'ỹi me cidade kotyi ve Betsaida kotyi ve. ");
INSERT INTO pahNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Gahoa kwahavame he'yive'g̃a hoi gareviri tihendu ti ga javo. G̃a ndurame ga pyri ga roryvamo g̃a ndehe Tupana'ga mombe'gwovo g̃a pe. Ga e'i: —Perojijyjijyjuka ti pejeaporog̃ita Tupana'ga pe pejikoga ga rehe. A'ero po ti ga pe pokokatui nehẽ imomboa pendekote'varuhua pe hugwi okovo penduvihavuhuhetero nehẽ, ei Jesus'ga g̃a pe. Itetirũave'g̃a hugwi Jesus'ga imombigi karugwara. ");
INSERT INTO pahNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Ka'arugame dozeve'g̃a Jesus'ga remimbo'ehara'g̃a, kiro g̃a nduri Jesus'ga pyri javo: —Ahã onga avo. A'ero ti toho agwa'g̃a cidades'i pe kopeve'g̃a pyri no. Pevo ti g̃a to'u okia. A'ea Jesus'ga remimbo'ehara'g̃a ei Jesus'ga pe g̃a mondoukapota ga pe. ");
INSERT INTO pahNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","—Pehe ti pemondo mbatera g̃a pe to'u ti g̃a javo, ei Jesus'ga g̃a pe. A'ero g̃a ei: —Ndorogwerekoi te! Cinco pães orogwereko dois pira reheve. Ndohygi'i'i po ti g̃a ndehe nehẽ. Toropyhy po ti ore nehẽ naerũ? Orohorame jate ipyhyga mbatera nehẽ itambere'ia rehe g̃a pe nehẽ, po ti ore imbohygi mbatera g̃a ndehe nehẽ to'u pa ti g̃a javo, ei Jesus'ga remimbo'ehara'g̃a Jesus'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","A'ereki he'yjuhuve'g̃a cinco milve'g̃a uhu pevo Jesus'g̃a pyri akwaimba'ero. Kiro Jesus'ga ei g̃wemimbo'ehara'g̃a pe: —Pemboapy ti g̃a yvyvo g̃a mbojatykavo. Cinquentave'g̃a ti pemboapy avo. Cinquentave'g̃a ti pemboapy pevo. Cinquentave'g̃a ti pemboapy irupe'i. Nahã ti pemboapy pa g̃a ojohugwi, ei ga. ");
INSERT INTO pahNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Ganhi'ig̃a rupi g̃a g̃a mboapypavi a'ero. ");
INSERT INTO pahNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Kiro ga ipyhygi mbatera – kiroki cinco pães dois pira reheve. Ojovavu ga yvaga repiaga. —Ndepyry hete nde imbuhua ore ve, ei Jesus'ga Tupana'ga pe. Kiro Jesus'ga haygwe'rogwe'rogi pães pira reheve imondomondovo g̃wemimbo'ehara'g̃a pe tomondo ti g̃a g̃a pe javo. A'ero g̃a imondomondoi g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","G̃a nhaporemo g̃a i'ui onhimoytaromouka. G̃a i'urẽ Jesus'ga moirũhara'g̃a imono'og̃i hembyruera imondovo yrua pype. He'yjuhuva'ea hembyruera opyta reki garembihaygwe'rogagwera. A'ereki g̃a ndo'upavi. He'yjuhuva'ea dozeva'ea yrua tynahẽ. Nahã Jesus'ga japoi ahemonhimomby'ava'ea he'yje'ỹva'ea imbovua imondovo g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Aerẽ Jesus'ga hoi he'yjuhuve'g̃a hugwi. Ga jate ga nhi'ig̃i Tupana'ga pe. Ga nhi'ig̃ame garemimbo'ehara'g̃a oko ga pyri. G̃a pe ga ei: —Marãi g̃a ji ve jipi? ");
INSERT INTO pahNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","A'ero garemimbo'ehara'g̃a ei ga pe: —“Ga ko João Batista'ga,” ei g̃a nde ve, ei g̃a Jesus'ga pe. Ojipe'g̃a e'i nde ve: “Ga ko Elias'ga.” Ojipe'g̃a e'i nde ve: “Ga ko Tupana'ga nhi'ig̃a mombe'uharava'ea pyteripeve'ga – kiroki ga ovy gwyvya hugwi ymyahũve'ga.” Nahã g̃a ei nde ve, ei Jesus'ga remimbo'ehara'g̃a Jesus'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","A'ero Jesus'ga ei g̃a pe: —Pehe, marãi pe ji ve jipi? A'ero Pedro'ga ei: —Nde ko Cristoramo Tupana'ga remimbuhurukaramo ereko. ");
INSERT INTO pahNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","A'ero Jesus'ga ei g̃a pe: —A'e tuhẽ ji pe me: Tape'ei tuhẽ ti ojipe'g̃a pe ga ko Cristo'ga Tupana'ga remimbuhurukara'ga javo. A'ea ti tape'ei ji mombe'gwovo. ");
INSERT INTO pahNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","He'yiva'ea po ti g̃a imondomondoi hahyva'ea ji ve nehẽ ei Jesus'ga yvyakotyva'ero yvagipeva'ero no. Nanhiarõi po ti xava'eve'g̃a ikwava'ẽhara'g̃a nduvihava'g̃a pavẽi judeus'g̃a mbo'ehara'g̃a pavẽi, ei ga. Nanhiarombavi po ti g̃a ji rendukatue'yma nehẽ. A'ero po ti g̃a ji jukaukari nehẽ. Mokõi ji kirirẽ po ti nhimbogwerahava nehẽ, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Kiro Jesus'ga ei g̃wemimbo'ehara'g̃a pe he'yjuhuve'g̃a pe no. G̃a pe nhaporemo ga ei: —Kiroki g̃a oko pota nhiremimbo'eharamo – tokoyme ti g̃a g̃wemimbotarimova'ea rupi okovo nhiremimbotarimova'ea rupi, ei Jesus'ga g̃a pe. Po ti ojipe'g̃a imbohahyukari g̃a pe g̃a jukavo vehevi nehẽ peko pe Jesus'gareheva'ero javo g̃a pe, toko jitehe ti g̃a jipi nhiremimbotarimova'ea rupi opohire'yma ji hugwi, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","—Kiroki g̃a ndokopotari nhiremimbo'eharamo tajijukayme ti g̃a javo – g̃a po ti omano ogwovo hahyva'ea ruvihava pype nehẽ, ei Jesus'ga. —Kiroki g̃a ojipe'g̃a g̃a jukai g̃ajikoga g̃waramo ji rehe – omanorẽ po ti g̃a oho upa avuirama Tupana'ga pyri nehẽ, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","—Ojipe'g̃a – kiroki g̃a e'i: “Ndakoi ti ji Jesus'ga remimbo'eharamo tamono'ono'õ ti ji mbatera jijive javo” – po g̃a imono'ono'ombavi mbatera ojive avo yvya koty, a'ero g̃a imono'ono'õtehei ojive novĩa ogwovo hahyva'ea ruvihava pype, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","—Aerẽ po ti ji rura'javi avo yvyakotyve'g̃a pyri nehẽ. Orerendy'jandy'java pyteri pe po ti ji rekoi jijoa nehẽ yvyakotyva'ero yvagipeva'ero no, ei Jesus'ga. Orerendy'jandy'java ko jikatua, jiruva'ga katua, gapyrive'g̃a katua. Po pe ei: “Ji Jesus'ga remimbo'eharamo rũi ako,” heroviare'yma nhinhi'ig̃a, a'ero jirura'javame po ti ji ei nehẽ: G̃a ko nhiremimbo'eharamo rũi oko, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","—Kiroki g̃a o'ã Jesus'ga pyri – g̃a pe Jesus'ga ei: A'itituhẽva'ea mombe'ukatuavo ji ei pe me: Omanoe'ymame po ti agwa'g̃a pyteripeve'g̃a ikwahavi nehẽ Tupana'ga oko yvyakotyve'g̃a nduvihavuhuhetero kiro javo, ei Jesus'ga g̃a pe nhaporemo. ");
INSERT INTO pahNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Aerẽ oito g̃werĩ okirirẽ Jesus'ga g̃a nderohoi ojupi Pedro'ga João'ga reheve Tiagova'ea reheve no. Jesus'ga g̃a nderohoi g̃a nderojiupia yvytyruhua rupi tanhi'ĩ ti ji Tupana'ga pe javo. ");
INSERT INTO pahNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Pevo Jesus'ga nhi'ig̃ame Tupana'ga pe Jesus'ga rova jirojijyi. Ga'apoa tapy'ynhapira hendy'jandy'ja otig̃ahivuhuhetero. ");
INSERT INTO pahNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Nanime mokonhava'ea jipiukari yvagahugwiva'ea Moisésva'ea Eliasva'ea pavẽi onhi'ig̃a Jesus'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Ahe katukaturo g̃wendy'jandy'javamo. Jesus'ga pe ahe ei: —Nahanahã po ti ga manoi cidade de Jerusalém me nehẽ, ei Tupana'ga nde mombe'gwovo ore ve. Nahã g̃a ei onhomonhi'ig̃a Jesus'ga pavẽi. —Nahã tuhẽ po ti nehẽ, ei Jesus'ga ikwahavipeavo. ");
INSERT INTO pahNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pedro'g̃a hopehyi okia reki. Kiro g̃a ma'eg̃atui hepiaga Jesus'ga katua garendy'jandy'java. Gwepia g̃a mokonhava'ea amame Jesus'ga pyri. ");
INSERT INTO pahNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Kiro ahe hoi Jesus'ga hugwi. Ahe horame Pedro'ga ei Jesus'ga pe ga renoina nde ko orembo'eharamo javo: —Pyry nhanderekoa avo, ei Pedro'ga. Na ore japoi três tapyimbovyra pe me: ojipeji nde ve, ojipeji Moisés'ga pe, ojipeji Elias'ga pe. A'ea Pedro'ga ei kotihĩ onhi'inhi'ig̃a ikwahave'yma. ");
INSERT INTO pahNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Ga nhi'ig̃ame yvag̃atig̃a ijyvi g̃a arimo g̃a mongovo o'ag̃i pe ua tuhẽ. A'ero Pedro'g̃a kyhyjihetei. ");
INSERT INTO pahNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Kiro yvag̃atig̃a hugwi Tupana'ga nhi'ig̃i. Jesus'ga mombe'gwovo ga ei: —Agwa'ga ko jira'yra'ga nhiremia'nguhete'ga. Pehendu katu ti ganhi'ig̃a, ei Tupana'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Ga nhi'imbavame Jesus'ga jate Pedro'g̃a ga repiagi. Ojipe'g̃a pe g̃a nonhi'ig̃i a'ea rehe. Manameuhũ g̃a imombe'ui onhimbiepiaga. ");
INSERT INTO pahNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ko'emame Jesus'ga jyvi yvytyra hugwi g̃wemimbo'ehara'g̃a pavẽi ogwovo. G̃a jyvirẽ he'yive'g̃a Jesus'ga repenhani. ");
INSERT INTO pahNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Nanime g̃apyteripeve'ga hapukai Jesus'ga pe. —A'e hete ji nde ve ahembo'ehara pe, ei ga Jesus'ga pe. Ehepia ti jira'yra'ga ga monhimohig̃atuavo. A'ereki gaha jate jira'yra'ga, ei ga Jesus'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Ji rendu ti. Anhag̃a ga pojyka jipi Diabo'gapyriva'ea. Opojykarame kotihĩ ga ohapukai. Anhag̃a omombomombo ga mohendyipoipoa okote'varuhuavo ga pe. Ndojipe'apotari ga hugwi. Ga mu'umu'umbavame jate ihoi ga hugwi, ei ga Jesus'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","—Neremimbo'ehara'g̃a pyri ji ga reruri. A'e hete ji g̃a pe novĩa: Pembojipe'a ti anhag̃a jira'yra'ga hugwi. Nombojipe'ai reki g̃a ga hugwi. A'ereki g̃a ndipopoakari jupe, ei ga Jesus'ga pe imombe'gwovo. ");
INSERT INTO pahNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","A'ero Jesus'ga ei pevove'g̃a pe nhaporemo: —Ndapejikogiuhu pe ji rehe pejikote'varuhuavo. Pe ji mombitu pejijuva. Manameuhũ po ti pe jikogi ji rehe nehẽ naerũ? ei Jesus'ga g̃a pe. A'ero Jesus'ga ei garuva'ga pe: —Eru ti ndera'yra'ga avo ji pyri. ");
INSERT INTO pahNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Gara'yra'ga rurame anhag̃a ga mbo'ari ga moheõ'a. A'ero Jesus'ga ei jupe: —Ejipe'a ga hugwi. Nahã Jesus'ga ga monhimohig̃atui ga mondoa'java garuva'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","A'ero pevove'g̃a nhimomby'ai Tupana'ga popoakahetea rehe. G̃a nhimomby'apavame Jesus'ga rembiapopava rehe, Jesus'ga ei g̃wemimbo'ehara'g̃a pe: ");
INSERT INTO pahNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","—Pehe ti peapyakwapupu hete nhinhi'ig̃a rehe. Ji rendu ti kiro. Uhu g̃werĩ nhimondohava apiavo g̃apo pe nehẽ. Ji pyhy po ti g̃a nehẽ, ei Jesus'ga yvyakotyva'ero yvagipeva'ero no. ");
INSERT INTO pahNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Jesus'ga remimbo'ehara'g̃a ndohekatui ga'ea rehe. A'ereki onhimiva'ea ganhimombe'ua g̃a pe. Nurã g̃a ei oyvyteri pe: “Ma gara pe ga ei?” Oyvyteri pe g̃a ei a'ea. A'ereki Jesus'ga pe g̃a nde'ia'uvi: “Ore mbo'e ti nde'ea rehe.” Nde'i g̃a a'ero. ");
INSERT INTO pahNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Aerẽ garemimbo'ehara'g̃a nhomonhi'ig̃i. Ojohupe g̃a ei: —Manamo nhande joheva'ero huvihavamo? Oyvyteri pe g̃a ei ojive: “Jihi ko.” ");
INSERT INTO pahNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Jesus'ga okwaha g̃a erame nahã oyvyteri pe. A'ero ga tayri'ga pyhygi ga rerekovo ojipyri. ");
INSERT INTO pahNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","A'ero ga ei g̃wemimbo'ehara'g̃a pe: —Kiroki g̃a jireheva'ero g̃waramo gwereko katu tayri'ga – jihi tuhẽ reki g̃a ji rerekokatui. Kiroki g̃a ji rereko katu nde ko Tupana'ga repykaramo javo – g̃a nhimbuhurukara'ga rerekokatui reki. Pepyteripeve'ga – kiroki ga nonhimbohetei tayri'ga ja – ga pe po ti Tupana'ga ei nehẽ: “Gaha huvihavuhua.” Nahã po ti Tupana'ga ei ga pe ga mboheteavo nehẽ, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Jesus'ga pe João'ga ei: —Oji'i ore orohepia akwaimbae'ga. Ombojipe'ape'a ga anhag̃a Diabo'gapyriva'ea ojipe'g̃a hugwi ndepopoakara pyvõ nde renoina. Jupe ga ei: “Jesus'ga pe mondo pe mbojipe'avo g̃a hugwi.” Nurã ore ei ga pe: Terei ti nahã Jesus'ga renoina, oro'e ore. A'ereki ga nhandereheva'ea rũi, ei ga Jesus'ga pe ombo'ehara'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","A'ero Jesus'ga ei g̃a pe: —Tapemombigi ga. A'ereki kiroki ga nianemovahĩ – gaha nhande repy a'ero, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Aerẽ oho g̃werĩ Jesus'ga hohava agwa hugwi yvya hugwi yvagi pe. Nurã ga ei: —Aho aha po ti ji kiro Jerusalém me na'ẽ nehẽ, ei ga. ");
INSERT INTO pahNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","A'ero ga jara'g̃a mondoi g̃wenonde. A'ero g̃a hoi ga renonde ovahema Samariapeve'g̃a cidade pe timboavujikwe ti Jesus'ga pe javo. ");
INSERT INTO pahNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Cidadepeve'g̃a ndohoryoryvi Jesus'ga rehe reki. A'ereki g̃a e'i ojohupe: —Aerẽ po ti ga hoi Jerusalém me nehẽ ta'u ti ji Páscoa pevo javo, ei g̃a. Nurã g̃a ei Jesus'ga remimbo'ehara'g̃a pe: —Topytayme ti Jesus'ga avo a'ero, ei g̃a g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Ikwahavame g̃a'ea Jesus'ga remimbo'ehara'g̃a hoi imombe'gwovo Jesus'ga pe Tiagova'ea João'ga pavẽi. Nde ko orepojykaharetero javo g̃a ei Jesus'ga pe: —Orombojy pota ore tata yvaga hugwi g̃a ndehe g̃a mbokaipava a'ero. Ymyahũ nahã Eliasva'ea ombojy. Marã po? A'ea pyry nde ve? ");
INSERT INTO pahNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","A'ero Jesus'ga pyryrymi g̃a novatiamo javo hete g̃a pe: —Ndapyryvi ji ve! ei ga. Napembaragwahavi pejihe. ");
INSERT INTO pahNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Tapoko yvyakotyve'g̃a javo ji ruri imomboa g̃andekote'varuhua g̃a hugwi. G̃a jukae'yma ji ruri yvyakotyva'ero yvagipeva'ero no, ei Jesus'ga g̃a pe. Ojipe pe cidade pe g̃a hoi ogwovo a'ero. ");
INSERT INTO pahNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","G̃a horame pea rupi ojipe'ga ei Jesus'ga pe: —Ji po ti neremimbo'ehara'ga nehẽ. Ndehoa nanani po ti ji hoi nde rupi nehẽ. ");
INSERT INTO pahNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","A'ero Jesus'ga ei ga pe: —Ereho pota tuhẽ nde ji rupi? ei Jesus'ga. Ja'gwara'java'ea raposas gwyvykoi okwara yvy pe okia ipype. Gwyra'ia ikiri hakã rehe, ei Jesus'ga. Jihi reki ndarekoi jikihava yvyakotyva'ero yvagipeva'ero no, ei Jesus'ga ga pe. Nde horame ji rupi ji javijitehe po ti nde ndererekoi nehẽ no, ei Jesus'ga ga pe. ");
INSERT INTO pahNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Ojipe'ga pe Jesus'ga ei: —Ji rupi nanani ti ejo, ei Jesus'ga. A'ero ga ei reki Jesus'ga pe: —Aerẽ po ti ji hoi ndehoa nanani nehẽ. Na ji hoi na'ẽ jipo'ria tyma, ei ga nde ko jipojykaharetero javo Jesus'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Emo Jesus'ga ei ga pe: —Terehoi ti pevo. Omanove'g̃a'jave'g̃a – kiroki g̃a noarõi Tupana'ga nhi'ig̃a – g̃a tuhẽ ti totỹ gwe'yja'g̃a. Ndehe, ehoeho ti imombe'gwombe'gwovo he'yjuhuve'g̃a pe. Ere ti g̃a pe: “Perojijyjijyjuka ti pejeaporog̃ita Tupana'ga pe pejikoga ga rehe. A'ero po ti ga pe pokokatui nehẽ imomboa pendekote'varuhua pe hugwi okovo penduvihavuhuhetero nehẽ.” A'ea ti ere g̃a pe, ei Jesus'ga ga pe. ");
INSERT INTO pahNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Kiro ojipe'ga ei Jesus'ga pe: —Ji po ti neremimbo'ehara'ga nehẽ. Na ji hoi na'ẽ nhirongapypeve'g̃a pe javo. Kiro ji hoi, ta'e ti ji g̃a pe, ei ga nde ko jipojykaharetero javo Jesus'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Emo Jesus'ga ei ga pe: —Oporavykyrame ji ve ahe tomohepia'ngiukaryme ti ojipea ojive. Ojipea imohepia'ngiukarame ojive ahe ndapyryvi nhirembipo'ruhavamo. Ndapo'rui ji ahe a'ero. ");
INSERT INTO pahNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Aerẽ Jesus'ga nhandepojykaharete'ga g̃a mo'emo'ẽi ojipe'g̃a setentave'g̃a. G̃a pe ga ei: —Penhomoirũ ti Tupana'ga nhi'ig̃a mombe'gwovo ojipe'g̃a pe. A'ea ga ei mokonha'g̃a mondomondovo g̃wenonde. Cidades pe nanani – perope ga oho pota – pevo nanani ga setentave'g̃a mondoi. Mokomokõi g̃a hoi onhomoiruamo a'ero. ");
INSERT INTO pahNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","G̃ahoa renonde Jesus'ga ei g̃a pe: —Pevove'g̃a ko koapora ja g̃anemimondorog̃werĩva'ea ja – kiroki g̃a tohendu Tupana'ga nhi'ig̃a, ei Jesus'ga g̃a pe. He'yi hete koapora gworygworyvamo. Imondorove'g̃a ndohygi reki hehe. A'ereki g̃a ndahe'yi. A'ero ahe ei koapora jara'ga pe: “Koji'i jitehe ti embuhurukara'ja imondorove'g̃a g̃a pyri imondoroguka ko pe.” A'ea ahe ei koapora jara'ga pe, ei Jesus'ga. —Na jitehe pevove'g̃a koapora ja. A'ereki g̃a he'yjuhu ranuhũ. Ndahe'yi reki imondorove'g̃a'jave'g̃a – kiroki g̃a oporavyky imombe'gwovo Tupana'ga nhi'ig̃a g̃a pe tojiko ti g̃a Tupana'ga rehe javo, ei Jesus'ga. Pe'ji ti Tupana'ga pe a'ero koapora jara'ga'jave'ga pe: “Koji'i jitehe ti embuhurukara'ja ejiheve'g̃a g̃a pyri. Tomombe'u ti g̃a nenhi'ig̃a he'yjuhuve'g̃a pe tojiko ti g̃a nde rehe. A'ero po ti g̃a ndekoi nde pyri upa avuirama nehẽ.” A'ea ti pe'ji Tupana'ga pe, ei Jesus'ga setentave'g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","—Kiro po ti ji pe mondoi nehẽ. Ji rendu ti. Jihi kiro po ti pe mondo okote'varuhuve'g̃a pyteri pe. Peko po ti pe cordeiros ja ipopoakare'ỹva'ea ja pejigwovo g̃apyteri pe nehẽ. Onharõ ja'gwara'java'ea lobos cordeiros pyhyga otiruahũro jupe. Na jitehe po ti okote'varuhuve'g̃a tiruahũro pe me nehẽ, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","—Taperohoi ti sacola, itambere'ia, sandálias irũa. Tapepytai'i'i ti pea rupi penhinhi'ig̃e'yma ojipe'g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Pevahemame onga pe ti pe'ji na'ẽ ongapypeve'g̃a pe: “Tu katu ti pepy'a!” ");
INSERT INTO pahNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Po ongapypeve'ga ipota tu katu ti jipy'a a'ero javo, a'ero po ti gapy'a rukatui tuhẽ nehẽ, ei Jesus'ga. Po ongapypeve'ga ndopotari, a'ero po ti gapy'a ndukatui nehẽ, ei Jesus'ga setentave'g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","—Ongapypeve'g̃a ipotarame pekia g̃wonga pype ti pepyta g̃anonga pype a'ero. Pe'u ti g̃ambatera – kiroki a'ea g̃a ombuhu pe me. A'ereki po g̃a pe poraka pe pokoga hamo. Pepyta ti g̃anonga pype jate pejijyjijyje'yma ojipejipea pype onga pype, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","—Po g̃a horyory pe ndehe pe mboapyga imondovo pe me pe vahemame cidade pe, a'ero ti pe'u g̃ambatera – kiroki a'ea g̃a ombuhu pe me. ");
INSERT INTO pahNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Pemombi ti karugwara itetirũave'g̃a hugwi pevo. Pe'ji ti g̃a pe: “Koro Tupana'ga gwepiuka opopoakara pe me okovo g̃werĩ penduvihavuhuhetero.” A'ea ti pe'ji g̃a pe imombe'gwovo, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","—Po g̃a ndohoryoryvi pe ndehe pe mboapyge'yma imondoe'yma pe me pe vahemame cidade pe, a'ero ti peho pehea rupi cidade rapea rupi. Pe'ji ti: ");
INSERT INTO pahNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Pehepia ti otimbuguhua orepya rehe pecidadeva'ea. Koa otimbuguhua ore ihyvi kiro javo: Napehendupotari pe Tupana'ga nhi'ig̃a ore imombe'urame pe me. Pe hendupotare'ymame ti pekwaha: Koro Tupana'ga gwepiuka opopoakara okovo g̃werĩ huvihavuhuhetero pe pyri.” A'ea ti pe'ji g̃a pe, ei Jesus'ga setentave'g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","—A'e ji pe me, ei Jesus'ga. Aerẽ mbapava koty po ti g̃a hepiagi hahyva'ea ojihe Tupana'ga omanove'g̃a mono'ombavame g̃a ndeheve nehẽ. G̃a mono'ombava po ti ga ei g̃a pe nhaporemo peko te'varuhu pe javo. A'ereki g̃a nohendupotari ganhi'ig̃a. Koji'i po ti hahy g̃a pe Sodomapeve'g̃a pe hohe, ei Jesus'ga setentave'g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Kiro Jesus'ga nhi'ig̃ahyi cidadespeve'g̃a pe Corazimmeve'g̃a pe Betsaidapeve'g̃a pe no. Javo g̃a pe ga ei: —Tiruahũ ti pe me nehẽ! ei Jesus'ga. A'ereki pe ndapepohiri pejikote'varuhua hugwi. Pehepia ko pe Tupana'ga popoakara novĩa ji japorame ahemonhimomby'aheteva'ea. Hepiagame po pe pepohi pejite'varuhua hugwi hamo. A'ea Jesus'ga ei cidadespeve'g̃a pe Corazimmeve'g̃a pe Betsaidapeve'g̃a pe no. —Ymyahũ Tiropeva'ea Sidommeva'ea pavẽi ndohepiagi Tupana'ga popoakara ahemonhimomby'ava'ea repiage'yma, ei Jesus'ga. Po ymyahũ ji japoi ahemonhimomby'ava'ea ahepyteri pe, po kotihĩ ahe pohiri okote'varuhua hugwi po raka'e hamo. Omongi po ahe opite'varuhua imondovo tanimbuga oakag̃a rehe po raka'e hamo ndorovy'ari ore orerekote'varuhua rehe javo, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","—Ymyahũ Tiropeva'ea ndohepiagi reki Tupana'ga popoakara ahemonhimomby'ava'ea repiage'yma Sidommeva'ea pavẽi, ei Jesus'ga. Ndopohiri ahe a'ero okote'varuhua hugwi. Nurã po ti ahe hepiagi hahyva'ea ojihe nehẽ Tupana'ga omanove'g̃a mono'ombavame nehẽ ahe reheve nehẽ. G̃a mono'ombavame po ti ga ei ahe ve nhaporemo nehẽ peko te'varuhu pe javo, ei Jesus'ga cidadepeva'ea mombe'gwovo. —A'ea rupi koji'i po ti hahy pe me nehẽ, a'e ji pe me, ei Jesus'ga Corazimmeve'g̃a pe Betsaidapeve'g̃a pe no. Igwyre'i po ti hahy Tiropeva'ea pe Sidommeva'ea pe nehẽ no, ei Jesus'ga. A'ereki Tupana'ga popoakara repiakaturame pe ndapepohiri reki pejikote'varuhua hugwi, ei Jesus'ga Corazimmeve'g̃a pe Betsaidapeve'g̃a pe no. Kiro Jesus'ga ei ojipe'g̃a pe cidadepeve'g̃a pe Cafarnaummeve'g̃a pe. E'i ga: ");
INSERT INTO pahNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","—Marãi pe pejive? “Nhande huvihava jara'g̃a hohe pa.” Nahã ko pe ei pejohupe penhimboheteavouhu pejikovo. Pe peho hete hahyva'ea ruvihava pype nehẽ, ei Jesus'ga Cafarnaummeve'g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Setentave'g̃a pe Jesus'ga ei: —Kiroki ga pe nendu – gaha ji rendu reki. Kiroki ga napenendukatui pe arõe'yma – gaha nanhirendukatui reki. Kiroki ga nanhirendukatui ji arõe'yma – gaha nohendukatui nhimbuhurukara'ga, ei Jesus'ga setentave'g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Kiro setentave'g̃a hog̃ahoi a'ero ogwovo Jesus'ga nhi'ĩpo'ruavo imombe'gwombe'gwovo Tupana'ga nhi'ig̃a. Aerẽ g̃a jivyri Jesus'ga pyri gworygworyvamo. Orepojykaharetero javo Jesus'ga pe g̃a ei: —Nderera pyvõ ore erame anhag̃a pe Diabo'gapyriva'ea pe a'ea oko orenhi'ig̃a rupi ojipe'avo g̃a hugwi. ");
INSERT INTO pahNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","A'ero Jesus'ga ei g̃a pe: —Kwa. Ahepia katu ji Satanás'ga hira yvaga hugwi okote'varuhuva'ea ruvihavuhu'ga hira. Kotihĩ ga hihetei overavava'ea ja. ");
INSERT INTO pahNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Ji rendu ti. Opombopopoaka ji. Nurã pe pyrug̃ame mboja rehe jagwa'jyra rehe po ti ndahahyi pe me nehẽ. Opombopopoaka ji. Nurã pe popoakaramo Satanás'ga hohe Diabo'ga hohe. A'ero Satanás'ga imondorame hahyva'ea pe me po ti pe nhimomiranami nehẽ, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","—Pe nhi'ig̃a rupi anhag̃a rekoro g̃waramo rũi ti pejory. Tupana'ga okwatija pendera inog̃a ga'apoa rehe livro rehe yvagi pe. Pendera nog̃a g̃waramo ti pejoryjory, ei Jesus'ga setentave'g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","A'ea rupi Tupana'ga ra'uva Jesus'ga mbohoryoryvi. A'ero Jesus'ga roryroryvamo Tupana'ga mboheteavo javo ga pe: —Apĩ, ei ga. Ndepyry hete nde ekovo yvagipeve'g̃a nduvihavuhuhetero yvyakotyve'g̃a nduvihavuhuhetero no. A'ereki nde nderekwahavukari a'itituhẽva'ea ikwahapyra'g̃a pe heaporog̃itave'g̃a pe no. Onhimbo'ee'ỹve'g̃a pe tayri'g̃a'jave'g̃a pe nde erekwahavuka a'itituhẽva'ea. Na tuhẽ, Apĩ. A'ereki nahã nde erepota, ei Jesus'ga Tupana'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Kiro Jesus'ga ei: —Jiruva'ga ombuhu pa ji ve ji mbopopoaka. A'ero ji popoakaramo ojipe'g̃a hohe pa. Gaha jate ji kwaha hete. Ojipe'g̃a ndajikwahakatui. Jihi jate ji akwaha hete jiruva'ga. Okwaha g̃a ga ji ga mboukwahapotarame jate g̃a pe, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","A'ero Jesus'ga pyryrymi g̃wemimbo'ehara'g̃a pe. Onhi'ig̃a g̃a pe jate ga ei: —Pe me pyry hete. A'ereki pe pejirokwa ikwahava aherembikwahavipyre'yma Tupana'ga rembiapoa repiaga. Pyry hete ti g̃a pe no – kiroki g̃a gwepia penembiepiaga ikwahava, ei Jesus'ga g̃wemimbo'ehara'g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","A'ereki ymyahũ ko Tupana'ga nhi'ig̃a mombe'uharava'ea gwepia pota hete penembiepiaga aheruvihavuhuva'ea pavẽi. He'yiva'ea gwepia pota. Ahe ndohepiagi reki. G̃wendu pota hete ahe penemienduva no. Ahe nohenduvi reki, ei Jesus'ga g̃wemimbo'ehara'g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Aerẽ judeus'g̃a mbo'ehara'ga o'ã Jesus'ga pyri. “Tahepia ti Jesus'ga reaporog̃ita,” ei ga oyvyteri pe. “Mara'ngu po ti ga onhimbotegweteavouka ji ve ga nhi'ig̃ame nehẽ?” ei ga. A'ero ga ei Jesus'ga pe: —Marã po ti jipyryhetea hamo nehẽ? A'ero po ti ji rekoi avuirama Tupana'ga pyri nehẽ, ei ga Jesus'ga pe ombo'ehara'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","A'ero Jesus'ga ei ga pe: —Marãi Moisésva'ea rembikwatijara? Marã nde imonhi'ig̃i aherembikwatijara? ");
INSERT INTO pahNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","A'ero ga ei Jesus'ga pe: —Nahã Moisésva'ea rembikwatijara e'i: “Pearõ hete tuhẽ ti pejipojykaharete'ga Tupana'ga. Pearõ hete tuhẽ ti ga pejipy'a pe. Pearõ hete tuhẽ ti ga imondovo pejeaporog̃ita imohina ga rehe. Pearõ hete tuhẽ ti ga pejirokwa pejikovo ga nhi'ĩpo'ruavo. Pearõ hete tuhẽ ti ga tako ti ji garemimbotarimova'ea rupi jate javo. Penhiarõ hete pe. Na jitehe ti pearõ pejikotyve'g̃a.” A'ea Moisésva'ea rembikwatijara ei, ei g̃ambo'ehara'ga Jesus'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","A'ero Jesus'ga ei ga pe: —Na tuhẽ. Eko pyry ti Moisésva'ea rembikwatijara rendukatuavo, a'ero po ti nde rekoi Tupana'ga pyri avuirama nehẽ, ei Jesus'ga ga pe. ");
INSERT INTO pahNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Oyvyteri pe g̃ambo'ehara'ga ei: “Po nhirenduve'g̃a ei ji mombe'gwovo hamo gaha okwaha hete javo ji ve hamo,” ei ga oyvyteri pe. Nurã ga ei Jesus'ga pe: —“Pearõ ti pejikotyve'g̃a,” ei Moisésva'ea, ei ga. Ma'g̃a ko jikotyve'g̃a naerũ? Ta'arõ ji g̃a a'ero, ei ga Jesus'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","A'ero Jesus'ga ei imombe'gwovo ga pe ga mbo'eavo. —Judeu'ga hoi pea rupi cidade de Jerusalém hugwi ogwovo, ei Jesus'ga. Ojipe pe ga hoi cidade de Jericó pe. Ga horame pea rupi iporomive'g̃a ndekoi ga rehe imima ga hugwi ga mu'umu'uma ga nog̃a. Gwekyi g̃a gapira vehevi ga hugwi herogwovo ga reja. Kiro ga manog̃werĩ. ");
INSERT INTO pahNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","—Kiro ikwava'ẽhara'ga ruri pea rupi judeu'ga. Imu'umu'umbyra'ga repiagame ga hoi pea aherovai ga hugwi okwava ogwovo. ");
INSERT INTO pahNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Na jitehe levita'ga rekoi judeu'ga. Uhu ga pea rupi. Urame ga imu'umu'umbyra'ga repiagi no. Pea aherovai ga hoi ga hugwi okwava ogwovo. ");
INSERT INTO pahNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","—Aerẽ Samariapeve'ga ruri pea rupi no, ei Jesus'ga. Samariapeve'g̃a noarõi judeus'g̃a. —Emo imu'umu'umbyra'ga repiagame Samariapeve'ga ga porogwetygi reki. “Po hahy hete ga pe,” ei ga, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Uhurame ga pyri ga ga pohanog̃i a'ero. Gweka'vo ga óleo vinho reheve gamohumbygagwera rehe ga pohanog̃a. Ouvã ga gamohumbygagwera tapy'ynhapira pyvõ. A'ero ga ga mondoi g̃wenymbava arimo yuhua'javuhuva'ea arimo ga rerogwovo. Onga pype ahekihavuhua pype ga ga rerohoi ga repiakatuavo pevo. ");
INSERT INTO pahNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","—Ko'emame ohorame ga ipe'ai oitambere'ia hugwi mokõi moeda pratava'ea. He'yi hehe moeda rehe itambere'ia rehe. Onga jara'ga pe ga imondoi. “Ehepia katu ti ga,” ei ga imondovo ga pe. “Mara'ngu po ti mokõi itambere'ia ihyge'yma nehẽ nde ipyhygame mbatera ga pe nehẽ? Po ti ndohygi itambere'ia ndehe ipyhygame mbatera ga pe nehẽ, a'ero po ti ji imondoi koji'iva'ea nde ve nehẽ jirura'javame nde pyri nehẽ,” ei Samariapeve'ga onga jara'ga pe, ei Jesus'ga imombe'gwovo g̃ambo'ehara'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","—Ejapyaka ti. Manamo trêsve'g̃a – kiroki g̃a gwepia imu'umu'umbyra'ga pea rupi – manamo g̃a gwereko katu ga gakotyva'ero? ei Jesus'ga ga pe. ");
INSERT INTO pahNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","A'ero g̃ambo'ehara'ga ei Jesus'ga pe: —Kiroki ga ga pohano – gaha oko gakotyva'ero ga pokoga. A'ero Jesus'ga ei ga pe: —Ga ja ti eko ojipe'g̃a pokoga – kiroki g̃a iporia'i. ");
INSERT INTO pahNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Aerẽ Jesus'ga hogahoi g̃wemimbo'ehara'g̃a pavẽi pea rupi ogwovo cidade'i pe. Pevo Marta'g̃a nonga pe ga hoi ovahema. Martahẽa ga mboapygi g̃wonga pype gworygworyvamo ga rehe. ");
INSERT INTO pahNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Gwereko hẽa oirũhẽa. Hẽarera ko Maria. Mariahẽa apygi Jesus'ga pyri gapya koty hendukatuavo ganhi'ig̃a. ");
INSERT INTO pahNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Kiro Martahẽa nhimbaekwahivi japovo mbatera ti'u ti javo. Nurã hẽa ruri opytaahi'viavo Jesus'ga pyri javo ga pe: —Pyry nde ve nhiirũhẽa ji pokoge'ymame? Jihi jate ji poravykyi. Orepojykaharetero ere hẽa pe a'ero tajipoko hẽa japovo. ");
INSERT INTO pahNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","A'ero Jesus'ga nhandepojykaharete'ga ei: —Marta! ei ga hẽa pe. Nda'ei po ti ji nahã hẽa pe nehẽ. Ndehe, terenhimbaekwahivuhui ti ejapyakauhuavo mbatera rehe! ei Jesus'ga Martahẽa pe. ");
INSERT INTO pahNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Koji'i ko pyryvamo ahe nhinhi'ig̃a renduvi. Mariahẽa ji rendu potaripe okovo. Na hẽa ji renduvi a'ero, ei ga Martahẽa pe. G̃a ndepiapavirẽ ga oho ogwovo. ");
INSERT INTO pahNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Aerẽ Jesus'ga nhi'ig̃i Tupana'ga pe okovo. Ga nhi'imbavirẽ garemimbo'ehara'ga ei Jesus'ga pe: —João'ga ombo'e g̃wemimbo'ehara'g̃a nahanahã ahe nhi'ig̃i Tupana'ga pe javo. Oro ore, marã ore nhi'ig̃i Tupana'ga pe? Ndehe ore mbo'e ti hehe jipojykaharetero, ei ga Jesus'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","A'ero Jesus'ga ei g̃wemimbo'ehara'g̃a pe: —Kwa. Opombo'e po ti ji kiro. Penhi'ig̃ame Tupana'ga pe ti pe'ji ga pe: “Apĩ, nde ereko katu hete. Tanerenoig̃atu ti g̃a nhaporemo a'ero nde mboheteavo ga ko Tupanete'ga javo nde ve. Herejo ti yvyakotyve'g̃a nduvihavuhuhetero ekovo. ");
INSERT INTO pahNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Nane'ymi ti embuhu ore ve mbatera toro'u ti. ");
INSERT INTO pahNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Ore ndorokwahava'javi ojipe'g̃a ndekote'varuhua orojive henonhe'yma g̃a pe nhaporemo. Na jitehe ti orerekote'varuhua emombo ore hugwi ikwahava'jave'yma henonhe'yma. Ore poko ti toronhi'ĩpo'ruyme ti Satanás'ga orokoe'yma garemimbotarimova'ea rupi.” A'ea Jesus'ga ei g̃wemimbo'ehara'g̃a mbo'eavo nahã ti penhi'ĩ Tupana'ga pe javo. ");
INSERT INTO pahNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","6","Koji'iva'ea ga ei g̃a pe: —Po ga – kiroki ga ojikoty'a pe pavẽi – po ga uhu penonga pe ohoa pyteri pe ypyhaji katu pe ndepiaga, ei Jesus'ga. Momina po pembatera. Nurã ahã imondoa ga pe. Marã po pe ndekoi a'ero? Peho po pe ojipe'ga ronga pe – kiroki ga ojikoty'a pe pavẽi no. Pe'e po pe ga pe: “Embuhu'ri ore ve três pães. A'ereki ojipe'ga uhu oreronga pe ohoa pyteri pe – kiroki ga ojikoty'a ore pavẽi. Ndorogwerekoi ore mbatera to'u ti ga javo.” ");
INSERT INTO pahNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","—A'ero po ga ei pe me: “Ndavypotari ji jikira g̃waramo. Ahovapytymbavipe ji. Anhino ji jira'yra'g̃a pavẽi. Nurã ji ndavyri imondovo pe me,” e po ga pe me, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","—A'e ji pe me, ei Jesus'ga. Pe pavẽi ojikoty'aro g̃waramo rũi ga vyri imondovo pe me. Pe porandupige'yma g̃waramo ga hugwi ga vyri imondopava penemimbotarimova'ea, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","—Penhi'ig̃ame Tupana'ga pe na jitehe ti peporandurandu ga pe pejikovo. A'ero po ti Tupana'ga imondoukari pe me nehẽ. Pehekaeka ti tihepia ti javo. A'ero po ti pe hepiagi nehẽ. Pekwapekwa ti porta rehe pejikovo taho ti ji jurukwara rupi javo. A'ero po ti pe hoi hupi nehẽ, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","A'ereki kiroki g̃a onhi'ĩ Tupana'ga pe ore poko javo – g̃a pe nhaporemo Tupana'ga omondouka okovo imombyryva oporanduve'g̃a pe hekahara'g̃a pe okwaokwave'g̃a pe, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","—Po penda'yra'ga ei pe me embuhu ji ve pira javo, a'ero mboja rũi po pe imondoi ga pe. ");
INSERT INTO pahNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Po penda'yra'ga ei pe me embuhu ji ve hupi'a javo, a'ero jagwa'jyra rũi po pe imondoi ga pe. ");
INSERT INTO pahNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","—Ite'varuhue'ỹve'ga ja po pe pekwaha imondovo peja'yra'g̃a pe. Peko te'varuhu pe reki. Po pe g̃anduvamo pekwaha imondovo peja'yra'g̃a pe, a'ero koji'i penduvete'ga yvagipeve'ga pyryheteve'ga ikwahahetei gwa'uva mondovouka pe me pe poranduvame ga pe. Pyry hete gara'uva, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Aerẽ anhag̃a opojyka akwaimbae'ga okovo. Nonhi'ig̃i anhag̃a Diabo'gapyriva'ea. Nurã nomonhi'ig̃ukari akwaimbae'ga pe. Jesus'ga anhag̃a mbojipe'arame ga hugwi akwaimbae'ga nhi'ig̃i reki. A'ero pevove'g̃a nhimomby'ai onhimongyavo. ");
INSERT INTO pahNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Hepiaga jara'g̃a ei: —Belzebu'ga anhag̃a ruvihavuhu'ga opokogame Jesus'ga popoakaro. Nurã Jesus'ga anhag̃a mbojipe'ai g̃a hugwi imondovouka, ei g̃a o'mbero. Belzebu, ei g̃a Diabo'ga pe. Irũa garera Satanás. ");
INSERT INTO pahNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ojohupe ojipe'g̃a ei: —Tihepia ti Jesus'ga popoakara, ei g̃a. Mara'ngu po Tupana'ga okovo ga pyri ga mbopopoaka? Tupana'ga ga mbopopoakare'ymame po ti nhande ga mbotegwetei nehẽ, ei g̃a ojohupe. Nurã g̃a ei Jesus'ga pe: —Eapo ti ahemonhimomby'ava'ea. Mara'ngu po Tupana'ga japouka nde ve nde pokoga? Torohepia ti, ei g̃a ga pe. ");
INSERT INTO pahNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Jesus'ga okwaha g̃andeaporog̃itate'varuhua. A'ero ga ei g̃a pe: —Po g̃agwyripeve'g̃a otavuka ojohupe, a'ero po ti g̃a nhomoka'nhymbavi nehẽ. Po ongapypeve'g̃a otavuka ojohupe, a'ero po ti g̃a nhomoka'nhymbavi nehẽ no, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Po na jitehe Satanás'gapyriva'ea otavuka ojohupe, a'ero po ti inhomoka'nhymbavi jovai nehẽ no. Marã po ti Satanás'ga huvihava a'ero ojipyriva'ea ahana'javame nehẽ? ei Jesus'ga g̃a pe. A'ea ji ei. A'ereki pe pe'e: “Belzebu'ga Jesus'ga pokogi ojipyriva'ea mbojipe'auka ga pe.” Nahã pe pe'e, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","—Ma'g̃a ombojipe'auka Satanás'gapyriva'ea pendeheve'g̃a pe naerũ? ei Jesus'ga. Ndape'ji reki pe g̃a pe: “Belzebu'ga ombojipe'auka g̃a pe.” A'ea rũi pe ei, ei Jesus'ga. Po ga rũi g̃a poko ojipyriva'ea mbojipe'auka g̃a pe, a'ero ga rũi ji poko no, ei Jesus'ga. Tape'ei ti ji ve a'ero: “Belzebu'ga Jesus'ga poko.” Po pe'ji a'ea ji ve, a'ero po ti pendeheve'g̃a ete'varuhui pe me nehẽ no pe'mbe pe javo pe me nehẽ, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","—Tupana'ga ipopoaka hete. Gapopoakara ombojipe'auka Satanás'gapyriva'ea ji ve, ei Jesus'ga. Pekwaha pe a'ero Tupana'ga ko nhanderuvihavuhuhetero kiro javo, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Kiro Jesus'ga Tupana'ga popoakara mombe'ui ga ojipe'g̃a hohe javo. Imombe'gwovo ga ei g̃a pe g̃a mbo'eavo: —Ipopoakave'ga opyhy pa gwy'yva toavykyyme ti ojipe'ga nhironga javo. Ga hepiakaturame g̃wonga u katu gambatera. ");
INSERT INTO pahNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ojiko ga gwy'yva rehe. Aerẽ ojipe'ga ruri otavuka ipopoakave'ga pe. Gaha koji'i ipopoaka ipopoakave'ga hohe. Nurã ga gapopoakara mombigi ipyhypava gary'yva ga hugwi gambatera no. A'ero ga ima'ẽi gambatera. A'ea Jesus'ga imombe'ui nahã Tupana'ga ipopoaka Satanás'ga hohe javo. ");
INSERT INTO pahNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","—Kiroki ga ndajirepygi – gaha ji movahĩ, ei Jesus'ga. Kiroki ga nomono'og̃i ji pavẽi – gaha ombokwaki'o. A'ea Jesus'ga ei ga nombojikogukari g̃a ji rehe javo. ");
INSERT INTO pahNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","—Kiro po ti ji imombe'ui anhag̃a rembipyhyga'ga pe me, ei Jesus'ga. Nahã ja ag̃wamove'g̃a ndekoi ite'varuhuve'g̃a – kiroki g̃a opohi okote'varuhua hugwi novĩa ojikoge'yma ji rehe, ei Jesus'ga. Anhag̃a Diabo'gapyriva'ea ite'varuhu hete akwaimbae'ga pyhyga otiruahũro ga pe. Aerẽ anhag̃a jipe'ai ga hugwi ogwovo yhye'ỹi me okwaokwava. “Mome po ti ji ruvi nehẽ?” e'i oyvyteri pe heka. Ndohepiagi reki. Nurã i'ei: “Ajivy po ti ji nhironga pe ipojykaa'java akwaimbae'ga pojykaa'java,” e'i. Akwaimbae'ga pe anhag̃a i'ei nhironga. ");
INSERT INTO pahNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","—A'ero ituri ojivya akwaimbae'ga pyri. Ovahemame ga pyri anhag̃a i'ei: “Ikatu hete nhironga imboavujikweripyra,” e'i anhag̃a. ");
INSERT INTO pahNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","—A'ero ihoi seteva'ea rerua anhag̃a rerua. Akoja hohe seteva'ea tiruahũ hete, ei Jesus'ga. Ovahemame akwaimbae'ga pyri ga pojykai otiruahũro ga pe. A'ero kiro koji'i tiruahũ hete akwaimbae'ga pe. Ymya tiruahũ ga pe ojipejiva'ea ga pojykarame. Aerẽ koji'i tiruahũ hete ga pe seteva'ea ga pojykarame, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Ga nhi'ig̃ame hahyahi pevove'g̃a pyteripevehẽa nhi'ig̃a ga pe: —Pyry hete hẽa pe – kiroki hẽa nde mbo'a nde moka'mbuka'mbuavo, ei hẽa. ");
INSERT INTO pahNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","A'ero Jesus'ga ei: —Na tuhẽ. Emo koji'i pyry hete g̃a pe – kiroki g̃a Tupana'ga nhi'ig̃a rendu katu okovo ganhi'ig̃a rupi, ei ga. ");
INSERT INTO pahNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","He'yive'g̃a nhombotymbotyvame Jesus'ga pyri ga ei g̃a pe: —Peko te'varuhu pe ag̃wamova'ero! A'ereki pe pe'e: “Jesus'ga japorame jate nhande ve ahemonhimomby'ava'ea, a'ero po ti nhande ei ikwahava nehẽ: Tupana'ga ga poko. A'ea po ti nhande xa'e hepiagame nehẽ.” A'ea pe ei, ei Jesus'ga g̃a pe. —Ndoapoukari po ti Tupana'ga ojipea ahemonhimomby'ava'ea pe me nehẽ. Ojikwe ga oapo ahemonhimomby'ava'ea Jonasva'ea mohemukarame ymyahũ hako. A'ea jate po ti ga ikwahavukara'javi pe me nehẽ jihi Jesus'ga poko javo, ei Jesus'ga. Ymyahũ Jonasva'ea ko Tupana'ga nhi'ig̃a mombe'uharava'ea hako. ");
INSERT INTO pahNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Pekwahava'ja ti Jonasva'ea pejapyakavo. Ymyahũ Tupana'ga Jonasva'ea mondoukari cidadepeva'ea pyri Nínivepeva'ea pyri tokwaha ti g̃a jipopoakara javo. Na jitehe Tupana'ga ji mbuhurukari pe pyri ag̃wamova'ea pyri tokwaha ti g̃a jipopoakara javo, ei Jesus'ga yvyakotyva'ero yvagipeva'ero no. Nahã Jesus'ga Jonasva'ea mombe'ui ahe ve tokwahava'ja ti g̃a Tupana'ga popoakara Jonas'ga mbogwerava reheve javo. A'ero ga ei: ");
INSERT INTO pahNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","—Aerẽ mbapava koty po ti Tupana'ga omanove'g̃a mono'ono'ombavi nehẽ pe ndeheve nehẽ, ei Jesus'ga. Pe mono'ombavame po ti ga ei pe me g̃a pe nhaporemo nehẽ peko te'varuhu pe javo. A'ea rupi po ti tyapyrakotyva'ea ruvihavuhuva'ea kweravi nehẽ no kunhangwerava'ea. Ojipiukarame po ti ahe imboukwahavukari pendekote'varuhua nehẽ. A'ereki ymyahũ ahe uhu Salomãova'ea pyri paivohuhetea hugwi hako tahendu ti ganhi'ig̃a javo. “A'ereki ga okwaha hete,” ei ahe ua, ei Jesus'ga imombe'gwovo. —Ji rendu ti! ei Jesus'ga g̃a pe. Jihi kaitu akwaha hete Salomãova'ea hohe, ei Jesus'ga. Ag̃wamova'ero pe napehendupotari nhinhi'ig̃a ikwahapotare'yma a'itituhẽva'ea. Nurã po ti tyapyrakotyva'ea ruvihavuhuva'ea imboukwahavukari pendekote'varuhua nehẽ, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","—Mbapava koty po ti Tupana'ga omanove'g̃a mono'ono'ombavi pe ndeheve nehẽ, ei Jesus'ga. Pe mono'ombavame po ti ga ei pe me g̃a pe nhaporemo nehẽ peko te'varuhu pe javo. A'ea rupi po ti Nínivepeva'ea kweravi nehẽ no. Ojipiukarame po ti ahe imboukwahavukari pendekote'varuhua nehẽ. A'ereki ymyahũ Nínivepeva'ea g̃wendu katu Tupana'ga nhi'ig̃a hako. Opohi ahe okote'varuhua hugwi ymyahũ hendukatuavo Tupana'ga nhi'ig̃a Jonasva'ea imombe'uro g̃waramo hako, ei Jesus'ga g̃a pe imombe'gwovo. —Ji rendu ti! ei Jesus'ga g̃a pe. Jihi kaitu amombe'u katu Tupana'ga nhi'ig̃a Jonasva'ea hohe, ei Jesus'ga. Ag̃wamova'ero pe napehendupotari nhinhi'ig̃a pepohire'yma pejikote'varuhua hugwi. Nurã po ti Nínivepeva'ea imboukwahavukari pendekote'varuhua nehẽ, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","—Imondygame lamparina ahe nomondoi imihava pype. Ndohovapygi ahe lamparina hyrua pyvõ. Pyte'mbia rehe ahe omondo lamparina. Nurã okirame onga pype ahe gwepia kojahua, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","—Ndereakwara ko lamparina ja nde ve. Ejeakwakaturame po ti nde hepiakatui egwovo kojahua rupi ikwahava nehẽ. Na jitehe ejeaporog̃itakaturame ekovo pota Tupana'ga remimbotarimova'ea rupi po ti nde rekokatukwahavi nehẽ, ei Jesus'ga. —Ejeakwate'varuhurame po ti nde nderehepiagi egwovo ypytuna rupi ikwahave'yma nehẽ. Na jitehe ejeaporog̃itate'varuhurame ekopotare'yma Tupana'ga remimbotarimova'ea rupi po ti nde nderekokatukwahavi nehẽ, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","—Ekwaha ti a'ero imbaragwahava mara'ngu po ji jireaporog̃itakatue'yma javo. Ejeaporog̃ita katu ti takote'varuhuyme ti javo. ");
INSERT INTO pahNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Lamparina imbokojahuheterame nde ve nde hoi pehea rupi katu ikwahava. Na jitehe ekokatukwahavame po ti nde ikwahahetei nehẽ nahanahã Tupana'ga opota ji ve javo. Po nandereaporog̃itate'varuhui'i'i, a'ero po ti nde rekokatukwahapavi nehẽ. ");
INSERT INTO pahNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Jesus'ga nhi'ig̃irẽ fariseu'ga ei ga pe: —Herejo nhironga pype i'gwovo ji pyri. A'ero Jesus'ga hoi ga rupi garonga pype oapyga mesa pyri. ");
INSERT INTO pahNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Jesus'ga ndojipogwei na'ẽ ojikwakuve'yma. A'ero fariseu'ga ei oyvyteri pe: “Garamo Jesus'ga nohendukatui nhaneramonhava'ea remimbo'eagwera naerũ? Nhaneramonhava'ea e'i: ‘Nahanahã nhande xajipogwei katu. Nhandejipogweikaturo g̃waramo nhande nhimombyryvi Tupana'ga pe,’ ei ahe.” A'ea ga ei oyvyteri pe onhimomby'avo Jesus'ga rehe ga ndojipogwei i'ua renonde javo. ");
INSERT INTO pahNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","A'ero Jesus'ga nhandepojykaharete'ga ei fariseu'ga pe: —Pe'ara tehe oko Tupana'ga nhi'ig̃a rupi pendekoe'ymame ganhi'ig̃a rupi pejiyvyteri pe fariseusva'ero, ei Jesus'ga. A'ea pe ji ei ji'erame pe me: Copo ara prato ara reheve pepyhei hete pe. G̃waimbya pe ndapepyhei reki. Nahã ji ei, ei Jesus'ga. Peyvytera ite'varuhu pa. A'ereki pe pepotaruhu pa ipyhygahyavo mbatera pejive pejikote'varuhuavo. ");
INSERT INTO pahNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Peko ikwahave'ymuhũva'ero! ei Jesus'ga imombe'gwovo fariseus'g̃a pe. —Tupana'ga oapo pa. Oapo ga ahe'ara. Oapo ga aheyvytera no. ");
INSERT INTO pahNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Po peyvytera ikatu, a'ero po ti pe ima'ẽi jara penhimbatera imbatere'ỹve'g̃a pe nehẽ. A'ero po ti pyrypavamo pembatera pe me nehẽ. A'ero po ti ndapejikwakuva'javi nehẽ, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","—Tiruahũ ti pe me! A'ereki fariseusva'ero pe ndapekokatui pejikokatue'yma ojipe'g̃a pe. Tiruahũ ti pe me. A'ereki napearõi Tupana'ga. Pemondo pe Tupana'ga pe novĩa. Petỹ imboheva'ea: hortelã, arruda, verduras. Pe herekorame dez itymipyra pe pemondo ojipeji ga pe. A'ea pyry Tupana'ga pe. Emo pe ndapekokatupavi pejikokatue'yma ojipe'g̃a pe, ei Jesus'ga. A'ea ndapyryvi Tupana'ga pe. Peko katu po pe pejikokatuavo ojipe'g̃a pe hamo. Pearõ hete po pe Tupana'ga hamo no. Pemondo ti Tupana'ga pe pejikokatuavo ojipe'g̃a pe no Tupana'ga arõheteavo no. Nahã pyry hete Tupana'ga pe, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","—Tiruahũ ti pe me! ei Jesus'ga. A'ereki fariseusva'ero pe pe'e: “Tianderepia pa ti g̃a nhande mboheteavo. A'ereki nhande g̃anduvihavuhuro xako,” pe'e pe pejiyvyteri pe. Nurã pe apypotaruhui nhanderuvihava'g̃a apykava rehe nhandejatykahava pype, ei Jesus'ga. Ikatuuhu pe me g̃a mbaragwahavame pe ndehe ima'ẽhai pe feira pe onhi'ig̃atuavo pe me pe ko orembo'eharamo javo pe me, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","—Pe ko ahemoandyandyiva'ero! ei Jesus'ga judeus'g̃a mbo'ehara'g̃a pe fariseus'g̃a pe no. Tiruahũ ti pe me nehẽ! A'ereki pe aheryvya ja. Ndiukwahavame aheryvya ahe ndohepiagi. A'ero ahe pyrug̃i hehe ikwahave'yma inema ipype. Na jitehe pe kwavame ahe ndokwahavi pendekote'varuhua peyvyteri pe, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","A'ero judeus'g̃a mbo'ehara'ga ei Jesus'ga pe: —Orembo'eharamo nde erame na g̃a pe, ore ve nde ei nava'ea rehe no ore mbotegweteavo. ");
INSERT INTO pahNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","A'ero Jesus'ga ei ga pe: —Pe me ti tiruahũ no! ei Jesus'ga judeus'g̃a mbo'ehara'g̃a pe. A'ereki pe ojipe'g̃a mbo'e hahyva'ea rehe. A'ereki penhi'ig̃a rupi g̃a ndekorame hahy g̃a pe. Pe'e pe g̃a pe: “Nahanahã ti peko Moisésva'ea nhi'ig̃agwera rupi orenhi'ig̃a rupi no,” pe'e hete pe g̃a pe. Pe tuhẽ ndapekopavi ahenhi'ig̃agwera rupi reki. Peko pa po pe hupi hamo. Penhimbi'eagwera pe pepirĩa reki no. G̃a ja pe peko – kiroki g̃a omondo ipohyjuhuva'ea ojipe'g̃a arimo g̃a pokoge'yma, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","—Tiruahũ ti pe me! A'ereki pe peapo katu tehe tapyja aheryvya rehe Tupana'ga nhi'ig̃a mombe'uharava'ea ryvya rehe. Ymyahũ penamonhava'ea Tupana'ga nhi'ig̃a mombe'uharava'ea jukai. ");
INSERT INTO pahNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Pehe peapo katu aheryvya. Jukwaha reki ahemanoa pyryvamo pe me. A'ereki pe napehendukatui imombe'uharava'ea nhi'ig̃a no, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","—Nurã ymyahũ Tupana'ga reaporog̃itaro. Ga e'i: “Amondouka po ti ji g̃a pyri nhinhi'ig̃a mombe'uhara'g̃a nhimoirũhara'g̃a ndeheve nehẽ. Jara'g̃a po ti g̃a g̃a jukai nehẽ nhinhi'ig̃a mombe'uhara'g̃a nhimoirũhara'g̃a ndeheve nehẽ. Jara'g̃a po ti g̃a g̃a monhani okote'varuhuavo g̃a pe nhinhi'ig̃a mombe'uhara'g̃a pe nhimoirũhara'g̃a pe nehẽ no ogwovo g̃a ndeviri nehẽ,” ei Tupana'ga ymyahũ, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","—A'ero ahemanoa rehe nhaporemo po ti Tupana'ga imondoi hahyva'ea pe me nehẽ, ei Jesus'ga g̃a pe. “Pejuka pa pe nhinhi'ig̃a mombe'uharava'ea,” e po ti Tupana'ga pe me ag̃wamova'ea pe nehẽ. “Ji japoypyrẽ yvya yvaga reheve penamonhava'ea ahe jukai. ");
INSERT INTO pahNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Penamonhava'ea ojuka ypy Abelva'ea. Aerẽ penamonhava'ea he'yiva'ea jukai. Mbapavamo ahe ojuka Zacariasva'ea ymyahũ hako. Omano Zacariasva'ea pejatykahavuhua pyri templo pyri okara pyteri pe ikwava'ẽhava pyri.” Nahã po ti Tupana'ga ei pe me imondovo hahyva'ea pe me imboja ahejukaagwera pe ndehe nehẽ, ei Jesus'ga imombe'gwovo. ");
INSERT INTO pahNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","—Tiruahũ ti pe me nehẽ! ei Jesus'ga judeus'g̃a mbo'ehara'g̃a pe. A'ereki pe napembo'ekatui Tupana'ga nhi'ig̃a rehe herojijyita. Nurã hajihea rehe pe g̃a mbo'ei g̃a moandyandyita. Pereko pe Tupana'ga nhi'ig̃a aherembikwatijara novĩa timonhi'ĩ javo. A'ereki pe ndapekoi Tupana'ga nhi'ig̃a rupi pejikoge'yma ga rehe. G̃a ndekopotarame ganhi'ig̃a rupi pe napemombe'ukatui g̃a pe. Nahã pe napemongoi g̃a ganhi'ig̃a rupi g̃a mbojikoge'yma ga rehe, ei Jesus'ga fariseus'g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Nanime g̃ambo'ehara'g̃a ndekote'varuhui ga pe ga arõe'yma fariseus'g̃a pavẽi. A'ero g̃a ei ga pe: —Herejo ore mbo'eavo he'yiva'ea rehe. Maramarã po? Koji'i ore mbo'e. Nahã g̃a ei ga pe. ");
INSERT INTO pahNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","A'ereki g̃a e'i ojohupe: —He timombe'uuka ti ga pe. Po ti ga nde'ikatui he'yjuhuva'ea mombe'urame nehẽ, a'ero po ti ore ga mbotegwetei nehẽ, ei g̃a ojohupe. ");
INSERT INTO pahNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","A'ea rupi he'yjuhuranuhũve'g̃a ndug̃anduri onhimono'ono'og̃a tihendu Jesus'ga javo. Opyrũpyrũ g̃a ojogwehe onhimongyavo. Kiro Jesus'ga nhi'ina'ẽi g̃wemimbo'ehara'g̃a pe. A'ero ga ei g̃a pe: —Penhimboko'i ti pão mbovuhava rehe fariseus'g̃a apoa rehe. A'ea ji ei tapehendukatui ti fariseus'g̃a nemimbo'ea javo. A'ereki g̃a ahe moandyandyi ojihe. Nurã ahe ei pyry hete g̃a javo novĩa. Emo g̃a oko te'varuhu reki. G̃a ja rũi ti peko. Pão mbovuhava onhinhamba pão pype. Na jitehe fariseus'g̃a ndekote'varuhua oki pa peyvyteri pe g̃a pe mbo'erame. ");
INSERT INTO pahNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","—Jahovipyra ahe ohaja'vo hepiuka. Na jitehe po ti Tupana'ga imboukwahavi nehẽ. Onhimiva'ea po ti ga hepiukari ikwahavuka henduvukapava nehẽ, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Kiroki a'ea pe pemombe'u ypytunimo ahe ve – a'ea jitehe po ti ahe imombe'ui arimo ojipe'g̃a pe nehẽ. Kiroki a'ea pe pemombe'u nhimi okipe ahe ve – a'ea jitehe ti ahe imombe'uahyahivi g̃andovaki tohendu pa ti g̃a javo. ");
INSERT INTO pahNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","—Pejikoty'a pe ji pavẽi, ei Jesus'ga g̃wemimbo'ehara'g̃a pe. A'e ji pe me: Tapekyhyji ti pejukapotave'g̃a hugwi. Pe jukarẽ tegwete g̃a pemondohavag̃wama hahyva'ea ruvihava pype, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Kiro ji Tupana'ga mombe'ui pe me. Ga hugwi ti pekyhyji. Gaha ipopoaka hete. Ahe jukarẽ ga omombo ahe tata pype hahyva'ea ruvihava pype ipotarame. A'e ji pe me: Ga hugwi ti pekyhyji, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","—Maramomi itambere'ia gwyra'ia rehe? Ndahe'yi po hehe. Cinco rehe gwyra'ia rehe po ojipeji'i jate itambere'ia. Tupana'ga gwyra'ia repiapavi herekovo ikwahapava. Nurã ga nomoka'nhymi ojipeji gwyra'ia! ");
INSERT INTO pahNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","—Koji'i hete reki Tupana'ga pe ndepiakatui. A'ereki ga okwaha jitehe reki pe'ava nhaporemo vehevi he'yjuhuva'ea. Okwaha pa ga pe'ava nhaporemo vehevi he'yje'ỹva'ea. Nahã ga pe kwahahetei pe ndepiakatuavo. Tapekyhyji ti a'ero. A'ereki Tupana'ga e'i pe me: “Ahepia katu ji gwyra'ia he'yjuhuva'ea. Koji'i ji rekoi pe ndehe pe ndepiakatuavo,” ei Tupana'ga, ei Jesus'ga g̃wemimbo'ehara'g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","—G̃wemimbo'ehara'g̃a pe Jesus'ga ei: A'e ji pe me: Po ahe ei ji mombe'gwovo: “Ajiko ji Jesus Cristo'ga rehe. Ga ko jipojykaharetero.” Po nahã ahe ji mombe'ui, a'ero po ti ji ei Tupana'gapyrive'g̃a pe yvagipeve'g̃a pe nehẽ: G̃a oko jireheva'ero. A'ea po ti ji ei ahe mombe'gwovo nehẽ, ei Jesus'ga yvyakotyva'ero yvagipeva'ero no. ");
INSERT INTO pahNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","—Po ojipe'g̃a ei ji mombe'gwovo: “Ndajikogi ji Jesus'ga rehe. Ga ndokoi jipojykaharetero.” Po nahã g̃a ei ji mombe'gwovo, a'ero po ti ji ei Tupana'gapyrive'g̃a pe yvagipeve'g̃a pe g̃a mombe'gwovo nehẽ: G̃a ndokoi jireheva'ero. A'ea po ti ji ei nehẽ, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","—Po g̃a ete'varuhui ji ve vehevi okote'varuhuavo, a'ero po ti Tupana'ga imombori g̃andekote'varuhua g̃a hugwi nehẽ, ei Jesus'ga yvyakotyva'ero yvagipeva'ero no. Po g̃a ete'varuhui Tupana'ga ra'uva pe reki okote'varuhuavo, a'ero po ti Tupana'ga nomomborag̃wami tuhẽ g̃andekote'varuhua nehẽ, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","—Aerẽ po ti ojipe'g̃a pe nderohoahyi ahejatykahava pype ipypeve'g̃a nduvihava'g̃a ndovai pyteri pe governador'g̃a ndovai pyteri pe no huvihavuhu'g̃a ndovai pyteri pe nehẽ no. G̃andovai pyteri pe po ti g̃a pe nderohoi timboja tehe ti g̃a ndehe javo. —G̃a pe nderohorame tape'ei na'ẽ ti pejiyvyteri pe: “Maramarã po ti nhande nhi'ig̃i g̃a pe nehẽ? Gara po ti nhande ei g̃a pe nehẽ?” A'ea ti tape'ei pevy'are'yma. ");
INSERT INTO pahNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","G̃a pe nderohorame po ti Tupana'ga ra'uva pe mbo'euka nehẽ nahanahã ti pe'ji g̃a pe javo. ");
INSERT INTO pahNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Kiro he'yjuhuve'g̃a pyteripeve'ga ei Jesus'ga pe: —Ahembo'eharamo ere ti nhiirũ'ga pe ima'ẽuka ga pe. Toma'ẽ ga orepo'ria mbateragwera ore ve memei. ");
INSERT INTO pahNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","A'ero Jesus'ga ei ga pe: —Ji rũi ko ima'ẽharamo ahe ve. ");
INSERT INTO pahNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Pevove'g̃a pe Jesus'ga ei: —Penhimboko'i ti! Tapepotaruhuhetei itambere'ia mbatera reheve. A'ereki mbaterahetea g̃waramo rũi pe ndekoi, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Kiro Jesus'ga imombe'ui ojo'java'ea g̃a pe. G̃a mbo'eavo ga ei: —Imbateve'ga gwereko yvykatua. Horyory garemityma. Ohy hete! ");
INSERT INTO pahNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Oyvyteri pe ga japyakai javo: “Marã re po ti ji herekoi koapora a'ero nehẽ? Mome po ti ji imondoi hepiakatuavo nehẽ imono'ono'og̃ame nehẽ?” ei ga ojapyaka. ");
INSERT INTO pahNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","—Aerẽ ga ei oyvyteri pe: “Nahã po ti ji rekoi a'ero nehẽ,” ei ga. “Apivohi po ti ji nhimbatera tuha'via nehẽ. A'ero po ti ji japoi hehanhuhũva'ea tuhava nehẽ. A'ea pype po ti ji imongipavi nehẽ jiapoa: trigo ojipea reheve nhimbatera reheve nehẽ. ");
INSERT INTO pahNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","A'ero po ti ji ei jiyvyteri pe nehẽ: Mbaterahetea ji herekoi hepiakatuavo. Mbaigwe po ti ipavi nhimbatera nehẽ. Nurã po ti ji ndaporavykya'javi nehẽ. Toryva rehe jate po ti ji rekoi nehẽ i'uheteavo vinho gwovo jiroryroryvamo nehẽ. Nahã po ti ji ei jiyvyteri pe nehẽ,” ei imbateve'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","—A'ero Tupana'ga ei ga pe: “Kiro ypytunimo po ti nde manoi nehẽ ikwahave'ymuhũva'ero! Oro nembatera po ti nehẽ naerũ? – kiroki a'ea nde eremono'ono'og̃uhũ. A'ea po ti ojipe'ga gwereko nde manorame nehẽ,” ei Tupana'ga ga pe, ei Jesus'ga imombe'gwovo. ");
INSERT INTO pahNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","—Na jitehe ga rekoi – kiroki ga omono'ono'og̃uhũ mbatera ojive jate okoe'yma Tupana'ga nhi'ig̃a rupi. Oko tehe po ti ga Tupana'ga rovai pyteri pe nehẽ, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Kiro Jesus'ga ei g̃wemimbo'ehara'g̃a pe: —Nurã ji ei pe me: Tape'ag̃ataruhui ti mbatera rehe. Tape'ei ti: “Maramarã po ti ji rekoi nehẽ? Gara po ti ji a'u nehẽ? Ahã po ti ji ve mbatera nehẽ. Gara po ti ji amongi nehẽ? Aerẽ po ti jipira itoropavi nehẽ.” Tape'ei ti nahã penhi'ag̃ataruhue'yma. ");
INSERT INTO pahNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","—Tapekouhui ti penhimbi'ua rehe, ei Jesus'ga. Tupana'ga pe apo. A'ero po ti ga imondoukari pe me mbatera nehẽ to'u ti g̃a javo. A'ereki Tupana'ga pe koji'i pyry pendekoa. Tapekouhui ti pejipira rehe. Oapo ga penda'oa. A'ero po ti ga imondoukari pepira pe me nehẽ. A'ereki Tupana'ga pe koji'i pyry penda'oa, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","—Pehepia te gwyra'ia corvos ikwahava. Notymi ojive corvos. Ndohetygi g̃wemityma i'gwovo a'ero. Nomono'og̃i mbatera opoitava ryrua pype aerẽ po ti ti'u javo. O'u reki corvos. A'ereki Tupana'ga ouka jupe. Pe me ga ei: “Koji'i ji rekoi pe ndehe,” ei Tupana'ga pe me. Nurã po ti ga imondoi pe me nehẽ no, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","—Pe'ag̃ataruhu po pe javo: “Koji'i po ji nhimomboakari hamo. Um meio metro po ti ji nhimomboakara'javi nehẽ.” Nahã po pe ei. Pe'ag̃ataruhu po pe a'ea rehe javo novĩa. Napenhimomboakara'javi tuhẽ po ti pe nehẽ, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Nenhimomboakahava nonhimimi'i'i Tupana'ga pe. Pehe reki ndapekwahavi a'ea pejikovo. A'ero ti ojipea rehe tape'ag̃ataruhui no! ");
INSERT INTO pahNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","—Pehepia ti yvoty'ria. Henhui onhimomboaka onhimongyavo yvoty'ria. Ndoporavykyi ipyhyga i'gwovo. Ndoapoi opi'ria. A'e ji pe me: Ymya aheruvihavuhuva'ea Salomãova'ea omongi tapy'ynhapipyryva jipi. Ikatu hete tuhẽ ahepipyryva onhimongyavo. Ahepipyryva hohe reki yvoty'ria ikatuhetero. ");
INSERT INTO pahNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Tupana'ga ombokatu ipira nhungwavuhua pira okovo hehe. Nhungwavuhua horyory nhuhũ me kiro. Ko'emame ahe omombo nhungwavuhua tata pype tamohendy ti tata javo. Nombokwara'ari nhungwava. —Koji'i Tupana'ga pe arõi imondoukari tapy'ynhapira pe me pemongi ti javo. Xunhi hete pe pejiko ga rehe! ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","—Tape'ag̃ataruhui ti penhimbi'ua rehe! Tape'ag̃ataruhui ti hehe pejipy'a nog̃atuukare'yma. ");
INSERT INTO pahNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","A'ereki yvyakotyve'g̃a gwyripeve'g̃a nhag̃ataruhu a'ea rehe nhaporemo – kiroki g̃a ndojikogi Tupana'ga rehe. Tape'ag̃ataruhui ti hehe a'ero. A'ereki gaha penduvete'ga okwaha pe mbatere'ymame togwereko ti g̃a g̃wig̃wia javo, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","—Tupana'ga ko penduvihavuhuhete'ga. Pejirokwa ti pejikovo ganhi'ig̃a rupi gaha ko jiruvihavuhuhete'ga javo, ei Jesus'ga. Pe ndekorame ganhi'ig̃a rupi po ti Tupana'ga imbuhupavi mbatera pe me nehẽ togwereko paravuhu ti g̃a javo, ei Jesus'ga g̃wemimbo'ehara'g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Kiro Jesus'ga ei g̃wemimbo'ehara'g̃a pe: —Pe ko napende'yi jireheva'ero. Tapekyhyji ti. A'ereki Tupana'ga e'i pe me: “Opomongo pota ji huvihavamo ji pavẽi.” ");
INSERT INTO pahNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Pemondo ti penhimbatera ojipe'g̃a pe itambere'ia pyhyga g̃a hugwi. Itambere'ia ti pemondo a'ero imbatere'ỹve'g̃a pe. Po nahã pe ndekokatui, a'ero po ti pe herekoi pejive yvagi pe nehẽ. Ikatu hete po ti peapoa pevo gwe'yjamo a'ero nehẽ. Niymyani po ti nehẽ. Namomini po ti nehẽ. Iporomive'ga ndohoi yvagi pe imima aheapoa. Mbatera nombote'vari aheapoa yvagi pe. ");
INSERT INTO pahNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","—Nurã ji ei pe me: Penhiitambere'ia ti pemondo imbatere'ỹve'g̃a pe. Po avo yvya koty peapoa uvame, a'ero yvyakotyva'ea rehe pe pemondo pejeaporog̃ita jipi. Po yvagi pe peapoa uvame, a'ero yvagipeva'ea rehe pe pemondo pejeaporog̃ita imohina jipi, ei Jesus'ga g̃wemimbo'ehara'g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","—Peko katu ti jirura'jahava pota. Peko ti g̃a ja – kiroki g̃a omongi oku'ayvira xanhimboavujikwe ti javo, ei Jesus'ga g̃wemimbo'ehara'g̃a pe. Peko ti g̃a ja no – kiroki g̃a ombojapy'u lamparina tihepia katu ti ikwahava javo. ");
INSERT INTO pahNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Peko ti g̃a ja – kiroki g̃a e'i: “Aerẽ po ti nhandepojykahara'ga ruri. Uhu po ti ga toryva hugwi ojipe'g̃a mohembirekohava hugwi,” ei g̃a gajivyhava pota. Ga rurame okwaokwa porta rehe, kotihĩ g̃a ipe'ai ga pe. ");
INSERT INTO pahNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","—Pyry hete po ti g̃a pe nehẽ – kiroki g̃a ndokiri opojykahara'ga rurame, ei Jesus'ga g̃a pe. Amombe'u katu ji pe me: Onhimboavujikwe ti g̃apojykahara'ga imongiavo oku'ayvira nehẽ ta'apo ti ji mbatera g̃a pe javo. A'ero po ti ga g̃a mboapygi mesa pyri herua mbatera imondovo g̃a pe nehẽ to'u ti g̃a javo. “Pepyry hete pe jirura potari,” e po ti ga nehẽ imondovo g̃a pe nehẽ. ");
INSERT INTO pahNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","—Po g̃apojykahara'ga jivyrame toryva hugwi ypyhaji'i, pyry hete po ti ndokirive'g̃a pe nehẽ. A'ereki ga gwepia g̃akire'yma. Pyry hete po ti ndokirive'g̃a pe nehẽ ga jivyrame ko'ema koty. A'ereki ga gwepia g̃akire'yma, ei Jesus'ga g̃a pe g̃a mbo'eavo ojo'java'ea pyvõ. ");
INSERT INTO pahNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","—Onga jara'ga ndokwahavi iporomive'ga rura g̃wonga pe, ei Jesus'ga. Po ga okwaha, gwepia katu po ga g̃wonga a'ea rupi hamo iporomive'ga mongiukare'yma hamo, ei Jesus'ga. A'ea pe pekwaha, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","—Nurã ji ei pe me: Penhimboko'i ti a'ero penhimboavujikwea jirura'java pota ji mbuhua, ei Jesus'ga g̃wemimbo'ehara'g̃a pe. Pe nhimboha'uve'ymame po ti ji ruri yvyakotyva'ero yvagipeva'ero no, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","A'ero Pedro'ga ei Jesus'ga pe: —Ma'g̃a pe nde imombe'ui a'ea ojo'java'ea? Mara'ngu po ore ve jate nde imombe'gwovo torohendu katu ti? Mara'ngu po ojipe'g̃a pe no nde imombe'gwovo tohendu katu ti g̃a ore pavẽi? ei ga Jesus'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","A'ero Jesus'ga nhandepojykaharete'ga ei Pedro'ga pe: —Kiroki ga ombojikoguka opojykahara'ga pe ojihe gweaporog̃itakaturo – marã ga rekokatui? ei Jesus'ga. Kiro po ti ji garekokatua mombe'ukatui pe me pe mbo'eavo ojo'java'ea pyvõ. Gwepia katu ga opojykahara'ga mbatera, ei Jesus'ga. Ga pe gapojykahara'ga ei a'ero ohorame: “Nde po ti jipyrive'g̃a ndepiakatuharamo. Ema'ẽ ti nhimbatera g̃a pe g̃andetakwera ja jipi to'u ti g̃a javo.” Nahã ga ei ojipyrive'ga pe ogwovo. ");
INSERT INTO pahNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","—A'ero gapyrive'ga jara'g̃a ndepiakatui imondovo g̃a pe g̃a nderekovo g̃andepiakatuharamo ga horame. —Aerẽ gapojykahara'ga jivyri ua. G̃a ndepiagame ga ei: “G̃a ndepia katu reki ga imondovo g̃a pe,” ei ga. —Pyry hete g̃andepiakatuhara'ga pe a'ero, ei Jesus'ga imombe'gwovo. ");
INSERT INTO pahNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Imombe'ukatuavo ji ei pe me: Aerẽ po ti gapojykahara'ga ei ga pe nehẽ: “Ehepia katu pa ti a'ero nhironga jigwyra reheve nhimbatera reheve no.” Nahã po ti ga ei nehẽ toko ti ga herekohavamo ji ve javo, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","—Po g̃andepiakatuhara'ga ei oyvyteri pe opojykahara'ga rure'ymame: “Mbaigwe po ti jipojykahara'ga jivyri nehẽ,” e po ga. A'ero po ga ndohepiakatui opojykahara'gapyrive'g̃a, ei Jesus'ga. Onupã po ga g̃a akwaimbae'g̃a kunhangwera'g̃a ndeheve g̃a poravykyrame. O'u hete po ga gambatera. Heagwyry po ga no. ");
INSERT INTO pahNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Nomboha'uvi ga ga upa nduri po ti jipojykahara'ga kiro nehẽ javo. —A'ea rupi po ti gapojykahara'ga ruri ovahema nehẽ, ei Jesus'ga. Gapojykahara'ga ga rovaja'rogukari. A'ereki ga ndokoi ganhi'ig̃a rupi. Nahã po ti gapojykahara'ga ga mongoukari ahe pyri nehẽ – kiroki ahe nohendukatui, ei Jesus'ga imombe'gwovo g̃wemimbo'ehara'g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Kiro Jesus'ga imombe'ui ojipea g̃a pe. G̃a mbo'eavo ga ei: —Ojipe'ga okwaha opojykahara'ga remimbotarimova'ea. Emo ga ndokoi ganhi'ig̃a rupi onhimboavujikwere'yma. A'ero po ti gapojykahara'ga ga nupanupãheteukari nehẽ, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Ojipe'ga ndokwahavi opojykahara'ga remimbotarimova'ea. Ga rekote'varuhurame po ti gapojykahara'ga ga nupãi hamo. Emo po ti gapojykahara'ga ga nupa'ĩukari nehẽ, ei Jesus'ga. —Na tuhẽ. Kiroki g̃a pe ahe omondo hete – g̃a na jitehe po ti tomondo hete hamo. Kiroki g̃a pe ahe koji'i omondo – g̃a po ti koji'i tomondo hamo, ei Jesus'ga imombe'gwovo. ");
INSERT INTO pahNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","—Ajo ji yvya koty jitekovo tamboukwaha yvyakotyve'g̃a ndeaporog̃ita javo. Po kiro g̃andeaporog̃ita ji amboukwaha ojikwe ramo. A'ereki nahã jiporavykyhava, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Tupana'ga e'i ji ve: “Aerẽ po ti ojipe'g̃a imondoi hahyva'ea nde ve nde jukavo nehẽ,” ei ga ji ve. Tuhu ti hahyva'ea ji ve a'ero. A'ereki ji ga nhi'ĩpo'ru pota. Anhimbaekwahi ji jivy'are'yma hahyva'ea imbuhua. ");
INSERT INTO pahNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","—Marãi pe ji mombe'gwovo? ei Jesus'ga. “Jesus'ga rura g̃waramo po ti yvyakotyve'g̃a py'a rukatui nehẽ.” Nahã po pe ei pejiyvyteri pe naerũ? A'e ji pe me: Tape'ei ti a'ea. Jirura g̃waramo po ti g̃apy'a ndukatui nehẽ. Ojogwayva po ti g̃a ji rehe nehẽ, ei Jesus'ga. —Ojipe'g̃a po ti ji arõhetei nehẽ. Ojipe'g̃a po ti nanhiarõi nehẽ. Nurã po ti g̃a jogwayvari ji rehe nehẽ. ");
INSERT INTO pahNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Kiro po ti ongapypeve'g̃a cincove'g̃a jogwayvari nehẽ. Trêsve'g̃a po ti doisve'g̃a rayvari nehẽ. Doisve'g̃a po ti trêsve'g̃a rayvari nehẽ. ");
INSERT INTO pahNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Akwaimbae'ga po ti gwayva gwa'yra'ga nehẽ. Gara'yra'ga po ti ga rayva nehẽ no. Kunhangwerahẽa po ti gwayva gwa'yrahẽa nehẽ. Hẽara'yrahẽa po ti hẽa rayva nehẽ no. Gwayva po ti kunhangwerahẽa o'aihẽa nehẽ. Hẽa'aihẽa po ti hẽa rayva nehẽ no, ei Jesus'ga g̃wemimbo'ehara'g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Kiro Jesus'ga ei pevove'g̃a pe: —Po kwara ihoa koty hovagwevagwe g̃werĩ kwara, a'ero pe ei: “Nimbegwei amana,” pe'e pe. Oky tuhẽ a'ero. ");
INSERT INTO pahNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Po nhimbya hugwi yvytua uhu, a'ero pe ei: “Kwarahyahi po ti nehẽ.” Kwarahyahi tuhẽ a'ero. ");
INSERT INTO pahNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Pe pehepia yvaga ikwahava aerẽva'ea. Nurã pe ei: “Aerẽ po ti ikyri nehẽ.” Pe pehepia avova'ea ikwahava aerẽva'ea. Nurã pe ei: “Aerẽ po ti kwarahyahi nehẽ.” A'ea pe pekwaha katu. —Emo imbaragwahave'ỹve'g̃a ja po pe reki. Pehepia tehe pe ojipeva'ea ag̃wamova'ea – kiroki a'ea ikwahavuka aerẽva'ea. Emo pe napembaragwahavi reki aerẽva'ea rehe, ei Jesus'ga g̃a pe. Pe ko ahemoandyandyiva'ero! ei Jesus'ga. Maranameuhũ pe napembaragwahavi ag̃wamova'ea rehe nhinhi'ig̃a renduvame! Onhimiva'ea nhinhi'ig̃a pe me naerũ? ");
INSERT INTO pahNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","—Pe tuhẽ pekwaha hamo! ei Jesus'ga. Maranameuhũ pe napendeaporog̃itakatui naerũ ikwahave'yma? Pekwaha ti! ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Kiro po ti ji imombe'ui pe me ikwahavuka pe me nahã ti pejeaporog̃ita katu javo. Ji rendu ti a'ero. —Po nde te'varuhuro ojipe'ga pe, a'ero po ti ga ei nde ve nehẽ: “Xaho tuhẽ ji rupi juiz'ga pyri,” e po ti ga nehẽ. “Ga pe po ti ji nderekote'varuhua mombe'ui nehẽ te'i ti ga nhandereaporog̃ita pe javo,” e po ti ga nde ve nehẽ. Ga nde rerohorame juiz'ga pyri ejirokwa ti javo ga pe ga ma'ngoma'ngoga ga rupi egwovo. Ere ti ga pe: “Nhande tuhẽ ti xanhimbovyvy na'ẽ.” A'ea ti ere ga pe. Po ti nde nerema'ngoma'ngogi ga pehea rupi nehẽ, a'ero po ti ga nde rerohoahyi juiz'ga pyri. A'ero po ti juiz'ga nde mondoukari guarda'ga pe nehẽ. Guarda'ga po ti nde mongi cadeia pype nehẽ. ");
INSERT INTO pahNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","A'e ji pe me: A'ea pype po ti nde pytai nehẽ. Nde imondokatupave'ymame ikwepykava, a'ero po ti guarda'ga nanerenohema'javi nehẽ, ei Jesus'ga imombe'gwovo g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","A'ea Jesus'ga imombe'urẽ pevove'g̃a pyteripeve'g̃a ei Jesus'ga pe: —Pilatos'ga ahe jukaukari ojiheva'ea Galiléiapeva'ea ko. Okwava'ẽ pota Galiléiapeva'ea mbatepyryva ikwava'ẽhava rehe Tupana'ga pe okovo. Ahe mbatepyryva jukarame Pilatos'ga ahe jukaukari. Aherekoa ono'õ mbatepyryva rekoa pavẽi ga ahe jukaukarame, ei g̃a Jesus'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","A'ero Jesus'ga ei g̃a pe: —Pe'e po pe pejiyvyteri pe: “Tiruahũ ahe Galiléiapeva'ea ogwyripeve'g̃a hohe. Nurã Pilatos'ga ahe jukaukari.” A'ea po pe ei naerũ? ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","—A'e ji pe me: Pe ndapekwahavi pe'erame nanongara. A'ereki ahegwyripeve'g̃a oko te'varuhu ahe ja. Pepohi ti pejikote'varuhua hugwi pejikovo. Pepohire'ymame jugwi pe nhaporemo po ti pemano no pejigwovo hahyva'ea ruvihava pype nehẽ. ");
INSERT INTO pahNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","—O'a onga jo'ajo'ara Jerusalémmeva'ea rehe dezoitova'ea rehe ahe jukavo Siloépeve'g̃a gwyri pe. Pe'e po pe pejiyvyteri pe: “Tiruahũ dezoitova'ea ojipe'g̃a hohe Jerusalémmeve'g̃a hohe. Nurã ahe rehe onga jo'ajo'ara ari.” A'ea po pe ei naerũ? ");
INSERT INTO pahNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","—A'e ji pe me: Pe ndapejapyakakatui ahe rehe. A'ereki Jerusalémmeve'g̃a oko te'varuhu ahe ja. Pepohi ti pejikote'varuhua hugwi. Pepohire'ymame jugwi pe nhaporemo po ti pemano no pejigwovo hahyva'ea ruvihava pype nehẽ, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Kiro Jesus'ga imombe'ui g̃a pe ojo'java'ea. G̃a mbo'eavo ga ei g̃a pe: —Akwaimbae'ga oho ko pe uva tymipyra pype. Pevo i'yva ami figueira. Oho ga heka hehe yva'ia figo ta'u ti javo. Ndogwerekoi yva'ia figo hehe reki. ");
INSERT INTO pahNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","A'ero ga ei g̃wemitymipyra repiakatuhara'ga pe: “Três anos imbokwara'ara'ari ji rujirurame avo heka figo figueira rehe. Ahã reki. Eha ti a'ero. A'ereki o'ã novĩa yvya po'ruavo,” ei ga. ");
INSERT INTO pahNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","—A'ero garemitymipyra repiakatuhara'ga ei: “Na ti ojipeji um ano imbokwara'ari hehe nehẽ. Kiro po ti ji hyvykoi yvya imondovo i'atagwera yvapoa pyri nehẽ. ");
INSERT INTO pahNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Po i'a nehẽ, a'ero pyry. Po ndi'ai nehẽ, a'ero ti emboharuka,” ei ga ga pe, ei Jesus'ga imombe'gwovo. ");
INSERT INTO pahNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Aerẽ sábado rupi kiro Jesus'ga g̃a mbo'ei gwe'yja'g̃a jatykahava pype. ");
INSERT INTO pahNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Ipype kunhangwerahẽa rekoi. He'yiva'ea dezoito anos imbokwara'ari hẽatetirũa rehe. A'ea rupi hẽa nopo'ag̃atui. Onhimombe hẽa okovo. A'ereki anhag̃a nomopo'ag̃atuukari hẽa pe. ");
INSERT INTO pahNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Hẽa repiagame Jesus'ga ei hẽa pe: —Kunha, ei ga. Avo ejo. Hẽa rurame ga pyri ga ei hẽa pe: —Ndepiro'y nde netetirũa hugwi kiro, ei ga. ");
INSERT INTO pahNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Hẽa rehe ga pokogi kiro. A'ero kotihĩ hẽa po'ag̃atui. Tupana'ga mboheteavo hẽa ei: —Pyry hete Tupana'ga ji ve, ei hẽa gworygworyvamo ga rehe. ");
INSERT INTO pahNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Kiro huvihava'ga judeus'g̃a jatykahava pype ga nhimboahivi Jesus'ga pe. A'ereki sábado rupi Jesus'ga omombi hẽatetirũa judeus'g̃a poravykye'yma rupi. A'ero huvihava'ga ei ipypeve'g̃a pe: —Oporavyky po ahe ojipea rupi seis dias rupi hamo. A'ea rupi ti pejo tomombi ga petetirũa. Sábado rupi rũi po ti ga tomombi petetirũa nehẽ, ei ga g̃ajatykahava jaramo. ");
INSERT INTO pahNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","A'ero Jesus'ga nhandepojykaharete'ga ei ijara'ga pe ipypeve'g̃a pe no: —Pe'e pe ji ve: “Oko te'varuhu ga. A'ereki ga oporavyky sábado rupi.” Nahã pe ei ji ve, ei Jesus'ga. Pehe reki okokatu'ãva'ero peko. Pe nhaporemo peporavyky sábado rupi no! A'ereki sábado rupi pembopiro'y penhenymbava boi burro reheve hapyja hugwi herogwovo y pe imboy'gwovo. ");
INSERT INTO pahNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","—Hẽa reki, Abraãova'ea rakykwepoharamo ko hẽa, ei Jesus'ga. Satanás'ga okote'varuhuva'ea ruvihavuhu'ga anhag̃a ruvihavuhu'ga, gaha hẽa pojykauka ojipyriva'ea pe. Nurã hẽa nopo'ag̃atua'javi. He'yiva'ea dezoito anos imbokwara'ara'ari hẽa pojykaukarame. Jihi a'e: Pyry ji imbopiro'yi karugwara hẽa hugwi sábado rupi, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Ga nhi'ig̃ame ga'arõe'ỹve'g̃a ndipoyjayjari. Ipypeve'g̃a reki g̃a ndoryndoryvamo Jesus'ga rehe onhimongyavo. A'ero g̃a ei: —Oapo hete Jesus'ga ahemonhimomby'ava'ea pyryva'ea. Ipopoaka hete ga, ei g̃a gworyvamo garembiapopava rehe. ");
INSERT INTO pahNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Ojo'java'ea pyvõ Jesus'ga g̃a mbo'ei. A'ero ga ei: —Marã hekoi kiro yvyakotyve'g̃a pe g̃a erame Tupana'ga nhanderuvihavuhuhetero oko javo? A'ea rehe po ti ji pe mbo'ei ikwahavuka pe me imombe'gwovo a'ea'java'ea, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Akwaimbae'ga gwereko mostarda ra'ynha. A'ea ga itymi ko pe, ei Jesus'ga. Henhunhame mostarda roryroryvamo. Aerẽ yvovouhuro tuhẽ. A'ero gwyra'ia ruri onhimongyavo upa hakã rehe japovo gwaityga, ei Jesus'ga he'yje'ỹve'g̃a po ti he'yjuhu nehẽ javo. ");
INSERT INTO pahNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Ojipea pyvõ ojo'java'ea pyvõ Jesus'ga g̃a mbo'ei. A'ero ga ei: —Marã hekoi kiro yvyakotyve'g̃a pe g̃a erame Tupana'ga nhanderuvihavuhuhetero oko javo? A'ea rehe po ti ji pe mbo'ei ikwahavuka pe me imombe'gwovo a'ea'java'ea, ei ga. ");
INSERT INTO pahNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Kunhangwerahẽa opyhy he'yiva'ea vinte e cinco quilos de farinha de trigo, ei ga. Trigo pype hẽa imbojihe'ari imbovuhava ta'apo ti ji pão javo. A'ero hẽa igwaragwarai humbirimbiriga trigo ru'uma. Igwaigwavete imbovuhava onhinhamba trigo ru'uma pype imbovuvupava, ei Jesus'ga igwaigwavete po ti g̃a herojijyi ojeaporog̃ita nehẽ javo. ");
INSERT INTO pahNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Aerẽ Jesus'ga hogahoi ojipejipe pe cidades pe. Cidades'i pe ga hoi no. Pevopevo ga g̃a mbo'embo'eavo ogwovo Jerusalém me. ");
INSERT INTO pahNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Pevove'ga e'i Jesus'ga pe: —Orepojykaharetero emombe'u ore ve. Tupana'ga omombo aherekote'varuhua ahe hugwi okovo. Maramomi g̃a hugwi po ti Tupana'ga imombori g̃andekote'varuhua g̃a nderogwovo yvagi pe nehẽ toko ti g̃a jireheva'ero javo? Ndahe'yi po g̃a? ei ga Jesus'ga pe. A'ero Jesus'ga ei g̃a pe: ");
INSERT INTO pahNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","—Ndipypiriva'ea ko porta Tupana'ga ronga apoa. Pejirokwa hete ti penhimongiavo Tupana'ga ronga pype porta'ia rupi ndipypiriva'ea rupi ga pyri. A'e ji pe me: Pejirokwa hete ti penhimongiavo. A'ereki he'yjuhuve'g̃a oki pota garonga pype novĩa. Emo g̃a ndoki. ");
INSERT INTO pahNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","—Aerẽ po ti Tupana'ga po'ami hovapytyma porta nehẽ. Po pe ami mytu'ẽ me a'ea rupi, a'ero po ti pe kwapekwari porta rehe novĩa nehẽ. A'ero po ti pe ei nehẽ: “Ehovapytymba'vo ti porta ore ve orepojykaharetero.” —A'ero po ti ga ei pe me nehẽ: “Nahovapytymba'vogi po ti ji pe me nehẽ. Peko pe ambotehero ji hugwi pejikoangave'yma jireheva'ero,” e po ti ga nehẽ. ");
INSERT INTO pahNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","—A'ero po ti pe ei nehẽ: “Oro'u ko ore nde pyri ikwehe. Erembo'e nde pehea rupi orecidade rapea rupi ikwehe.” ");
INSERT INTO pahNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","—A'ero po ti ga ei pe me nehẽ: “A'e ji pe me: Peko pe ambotehero ji hugwi pejikoangave'yma jireheva'ero. Pejipe'a pa ti ji hugwi pejigwovo. A'ereki nane'ymi pe pekote'varuhu.” A'ea po ti ga ei pe me nehẽ, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","A'ea rupi po ti pe g̃a ndepiagi nehẽ: Abraão'ga, Isaque'ga, Jacó'ga nehẽ. Pe g̃a ndepiapavi Tupana'ga nhi'ig̃a mombe'uhara'g̃a nehẽ no. Okipavipe po ti g̃a Tupana'ga ronga pype pe g̃a ndepiagame nehẽ. Tupana'ga napemongiukari g̃wonga pe nehẽ. A'ea rupi po ti pe jehe'oi pejihe penhimonha'ngavo hahyrame pejive pevo nehẽ, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","—Uhu po ti ojipe'g̃a nehẽ. Kwara ipora hugwi po ti g̃a ndug̃anduri kwara ihoa hugwi no, tyapyra hugwi no, nhimbya hugwi no. G̃a uhu oapyga nehẽ ti'u ti Tupana'ga ronga pype javo, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","—Pehendu ti! ei Jesus'ga. Kiroki g̃a huvihava rũi ag̃wamo – jara'g̃a po ti huvihava nehẽ. Kiroki g̃a huvihava ag̃wamo – jara'g̃a po ti ndokoa'javi huvihavamo nehẽ, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Kiro fariseus'g̃a nduri ovahema Jesus'ga pyri. Ga pe g̃a ei: —Heregwovo avo hugwi. A'ereki Herodes'ga nde juka pota, ei g̃a. ");
INSERT INTO pahNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","A'ero Jesus'ga ei g̃a pe: —Ga ko huvihavatehea jagwa'ria'java'ea ja raposa ja. Peho ji mombe'gwovo ga pe. Pe'ji ti ga pe: “‘Ehendu ti!’ ei Jesus'ga nde ve. ‘Kiro ji ambojipe'ape'a ahe hugwi anhag̃a Diabo'gapyriva'ea. Amombimombi ji ahetetirũa ahe hugwi no ag̃wamo. Nahã ji poravykyi kiro. Ko'emame na jitehe ti. A'ea py'rovo po ti ji poravykypavi nehẽ.’ A'ea Jesus'ga ei nde ve.” A'ea ti pe'ji Herodes'ga pe, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","—Pe'e katu pe pe'erame ji ve: “Heregwovo.” Na tuhẽ. Taho ti ji jigwovo pea rupi kiro ko'emame no a'ea py'rovo no jigwovo cidade de Jerusalém me. A'ereki Jerusalém me jate g̃a Tupana'ga nhi'ig̃a mombe'uharava'ea juka pota jipi. Pevo jitehe po ti g̃a tajijuka nehẽ naerũ! ei Jesus'ga g̃a pe. Kiro Jesus'ga ei cidadepeve'g̃a pe Jerusalémmeve'g̃a pe: ");
INSERT INTO pahNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","—Jerusalémmeva'ero pe pejuka Tupana'ga nhi'ig̃a mombe'uharava'ea jipi, ei Jesus'ga. Tupana'ga ahe mondoukarame pe pyri pe peapiapi ahe jipi ahe jukavo, ei Jesus'ga. Inamutig̃a omono'ono'õ gway'ria opepoa gwyri pe. Na jitehe he'yjuhuva'ea rupi ji pe mono'ombotara'jara'javi ji pyri inamutig̃a ja pe nderekokatupota novĩa. Emo pe ndapepotaruhui, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","—Pehendu ti a'ero! Kiro po ti Tupana'ga pohiri pe hugwi nehẽ. Ga ndohepiakatua'javi pejatykahavuhua a'ero nehẽ. Pe tehe po ti peko a'ero nehẽ. Pe ndajirepiaga'javi nehẽ, a'e katu ji pe me. Aerẽ jate po ti ji rura'javi nehẽ. A'ea rupi po ti pe ei nehẽ: “Tupana'ga ti tomombyry Jesus'ga pe. Gaha Tupana'ga ga mbuhuruka,” pe'e po ti pe nehẽ, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Aerẽ sábado rupi Jesus'ga hoi fariseus'g̃a nduvihava'ga ronga pe ta'u ji pevo javo. Ga vahemame garonga pe g̃a Jesus'ga repiahetei fariseu'ga fariseu'ga pavẽive'g̃a pavẽi javo ojohupe: —Mara'ngu po ti Jesus'ga okote'varuhuavo nehẽ? Po nahã, a'ero po ti nhande ga mbotegwetei nehẽ, ei g̃a ojohupe. ");
INSERT INTO pahNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Jesus'ga rovai pyteri pe oko itetirũave'ga. Ovuvu pa ga hugwi gapya gajyva. ");
INSERT INTO pahNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Kiro Jesus'ga ei judeus'g̃a mbo'ehara'g̃a pe a'ero – kiroki g̃a ombo'e jipi Moisésva'ea rembikwatijara rehe. G̃a pe fariseus'g̃a pe no Jesus'ga ei: —Mahã po pyry? Mara'ngu po sábado rupi ahe imombiga g̃atetirũa g̃a hugwi? Mara'ngu po ahe imombige'yma g̃atetirũa sábado rupi? Mahã po pyry? A'ea Jesus'ga ei g̃a pe tonhi'ĩpondekwa ti g̃a javo. ");
INSERT INTO pahNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Emo g̃a nonhi'ĩpondekwavi. A'ero Jesus'ga pokogi itetirũave'ga rehe imombiga gavuvura ga mondouka garonga pe. ");
INSERT INTO pahNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","G̃a pe Jesus'ga ei: —Erereko po nde jumento. Boi po nde erereko. Po nerenymbava ihiri ikwaruhua pype, a'ero po kotihĩ nde ipyhygi enhenymbava henohema jugwi sábado rupi. Nahã nde enhenymbava rereko katu. A'ereki pyry nerenymbava nde ve. A'ea Jesus'ga ei fariseus'g̃a pe judeus'g̃a mbo'ehara'g̃a pe no pyry ji itetirũave'ga pokogi sábado rupi no javo. ");
INSERT INTO pahNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Nonhi'ĩpondekwavi g̃a. A'ereki g̃a g̃wenohẽ tuhẽ sábado rupi. ");
INSERT INTO pahNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Kiro g̃a nduri fariseus'g̃a ojipe'g̃a ndeheve – kiroki g̃a fariseu'ga g̃a mono'og̃uka g̃a mbuhuruka g̃wonga pe i'gwovouka g̃a pe. Oapy g̃a huvihava'g̃a apykava rehe ikatuva'ea rehe. “Tianderepia pa ti g̃a nhande mboheteavo,” ei g̃a. “A'ereki nhande g̃a hohe,” ei g̃a oyvyteri pe. G̃a apygame hehe Jesus'ga g̃a ndepiagi. A'ero ga ei imombe'gwovo ojo'java'ea g̃a pe. G̃a pe ga ei: ");
INSERT INTO pahNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","—Po toryva jara'ga pe mono'og̃ukari pe'u ti javo toryvi pe g̃amohembirekohai pe. Pehorame toryva repiaga ti tapeapygi huvihava'g̃a apykava rehe ikatuva'ea rehe tianderepia pa ti g̃a jave'yma. Mara'ngu po ijara'ga javo ndehoheve'ga pe: “Herejo toryva repiaga”? ");
INSERT INTO pahNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","A'ero po ti ga ruri nehẽ. Nurã po ti ijara'ga ei pe me nehẽ: “Na ga apygi pe py'rovo huvihava'ga apykava rehe ikatuva'ea rehe.” Ga erame na pe me, a'ero po ti pe ndapepoyjayjari nehẽ pejigwovo peapyga irupe okoteheve'g̃a apykava rehe nehẽ, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","—Po toryva jara'ga pe mono'og̃ukari toryva repiagauka pe me nehẽ. Peapy na'ẽ ti okoteheve'g̃a apykava rehe. Aerẽ po ti ijara'ga ruri javo pe me nehẽ. “Pejikoty'a pe ji pavẽi,” e po ti ga pe me nehẽ. “Ikatuva'ea rehe ti peapy huvihava'g̃a apykava rehe.” Ga erame na, po ti ojipe'g̃a ga renduvi – kiroki g̃a oapy pe pyri. A'ero po ti g̃a ei pe mombe'gwovo: “G̃ahã ore hohe.” Nahã po ti g̃a ei pe mboheteavo nehẽ, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","—Po pe ei: “Jihi ko huvihavamo ojipe'g̃a hohe pa.” Po pe ei a'ea penhimboheteavo pepopoakaramo pejikovo aha huvihavamo, a'ero po ti Tupana'ga ei pe me nehẽ: “Pe ndapekoi huvihavamo. Napenhimbohetei po pe hamo a'ero!” A'ea po ti Tupana'ga ei pe me nehẽ, ei Jesus'ga. Po pe napenhimbohetei ojipe'g̃a pokokatuavo, a'ero po ti Tupana'ga ei pe me nehẽ: “Peko ti huvihavamo.” A'ea po ti ga ei pe me nehẽ, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Jesus'ga ei fariseu'ga pe – kiroki ga ombuhuruka ga g̃wonga pe e'u ti ji pyri javo. Ga pe Jesus'ga ei: —Nde japorame mbatera to'u ti g̃a javo, terembuhurukari ti g̃a ejipyri – kiroki g̃a ojikoty'a nde pavẽi. Terembuhurukari ti neirũ'g̃a, eje'yja'g̃a, imbateve'g̃a. Terembuhurukari ti nanongara'g̃a arimo ypytunimo no to'u ti g̃a javo. Po nde g̃a mbuhurukari, aerẽ po ti g̃a ei nde ve nehẽ: “Herejo i'gwovo kiro oreronga pe.” Nahã po ti g̃a toryva kwepygi nde ve nehẽ, ei Jesus'ga ga pe. ");
INSERT INTO pahNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","—Po nde japorame toryva koji'i pyry nde g̃a mbuhurukari imbatere'ỹve'g̃a, ika'naka'nauhũve'g̃a, ipyka'naka'nave'g̃a, heakwagweve'g̃a. Nanongara'g̃a embuhuruka ti to'u ti g̃a ji pyri javo. ");
INSERT INTO pahNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","A'ero po ti pyryhetero nde ve nehẽ. G̃a po ti ndokwepygi toryva nde ve nehẽ. Tupana'ga reki ga pyryhetero nde ve nehẽ omanove'g̃a mbogweravame pyryve'g̃a mbogweravame nehẽ, ei Jesus'ga ga pe. ");
INSERT INTO pahNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Jesus'ga pyri g̃a i'ui oapyga mesa pyri Jesus'ga renduva. G̃apyteripeve'ga ei Jesus'ga pe: —Horyory po ti ga nehẽ – kiroki ga o'u Tupana'ga ruhava pype Tupana'ga rekorame nhanderuvihavuhuhetero, ei ga Jesus'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","A'ero Jesus'ga ga mbo'ei ojo'java'ea pyvõ. Imombe'gwovo ga ei ga pe: —Marã Tupana'ga yvyakotyve'g̃a nderekoukari okorame g̃anduvihavuhuhetero? A'ea rehe po ti ji nde mbo'ei ikwahavuka nde ve imombe'gwovo a'ea'java'ea, ei Jesus'ga ga pe. Akwaimbae'ga ei he'yjuhuve'g̃a pe: “Kiro po ti ji japoukari toryva. Pe'u ti ji pyri,” ei ga g̃a pe. A'ero ga hoi japovouka, ei Jesus'ga imombe'gwovo. ");
INSERT INTO pahNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Omboavujikwepavuka ga inog̃uka. A'ero ga ojipyrive'ga mondoukari g̃a pyri. Ga pe ga ei: “Eho javo g̃a pe: ‘Hepejijo kirog̃we. A'ereki ga omboavujikwepavuka mbatera pe me’.” —“Kwa,” ei ga ogwovo javo g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","—Ganhi'ig̃a renduvame g̃a ndohopotari toryvi pe. Ga pe g̃a eg̃a'ei: “Ndorohoi ore. A'ereki nahanahã ore oroko,” ei g̃a. —Peropero gapyrive'ga hoi g̃a momorandupava novĩa a'ero. Ojipe'ga pyri na'ẽ gapyrive'ga hoi javo ga pe: “Herejo i'gwovo. Omboavujikwepavuka jiruvihava'ga nde ve.” —Emo ga ei gapyrive'ga pe: “Apyhy ko ji kohoa itambere'ia mondovo. Taho ji hepiaga. Nurã ji ei nde ve: Ji mombe'u katu ti nderuvihava'ga pe tonhimonha'ngayme ti ga ji hoe'ymame i'gwovo ga pyri.” —“Kwa,” ei ga a'ero ogwovo. ");
INSERT INTO pahNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","—Ojipe'ga pyri ga hoi ovahema a'ero javo: “Herejo i'gwovo.” —Emo ga ei gapyrive'ga pe: “Apyhy ko ji he'yiva'ea nhirenymbava dez boi itambere'ia mondovo. Taho ti ji hepiaga ipopoakara toporavyky boi ji ve. Nurã ji ei nde ve: Ji mombe'u katu ti nderuvihava'ga pe tonhimonha'ngayme ti ga ji hoe'ymame i'gwovo ga pyri.” —“Kwa,” ei ga a'ero ogwovo. ");
INSERT INTO pahNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","—Ojipe'ga pyri ga hoi ovahema a'ero. —Emo gaha e'i gapyrive'ga pe: “Nhirembireko ji hẽa pavẽi ko. Nurã ji ndahoi i'gwovo ga pyri,” ei ga gapyrive'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","—A'ero gapyrive'ga jivyri ua gwuvihava'ga pyri. Omombe'u pa ga ga pe g̃anhi'ig̃agwera. “Nduri tuhẽ g̃a,” ei ga. “A'ereki nahanahã g̃a oko.” —A'ero garuvihava'ga nhimboahivi g̃anhi'ig̃agwera renduvame. A'ero ga ei ojipyrive'ga pe: “Haite! Eho ti pehea rupi cidade rapea rupi ja'oga rupi cidade pe. Eru ti g̃a: imbatere'ỹve'g̃a, ika'naka'nauhũve'g̃a, ipyka'naka'nave'g̃a, heakwagweve'g̃a. Emongi ti g̃a nhironga pype to'u ti g̃a.” ");
INSERT INTO pahNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","—Kotihĩ gapyrive'ga hoi ga nhi'ĩpo'ruavo. Iporia'ive'g̃a pe nhaporemo ga ei: “Hepejijo ji rupi. Pe'u ti jiruvihava'ga pyri.” Nahã ga g̃a nderuri gwuvihava'ga ronga pe g̃a nderovahema g̃a mongiavo ipype. A'ero ga hoi gwuvihava'ga pyri javo: “Aru pa ji g̃a. Ndohygi reki g̃a mesa rehe,” ei ga gwuvihava'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","—A'ero garuvihava'ga ei ga pe: “Eho ti cidade hugwi pepukuhua rupi pehe'ia rupi no pevove'g̃a mbuhuruka tuhẽ nhironga pe. Ohygahi ti g̃a nhironga rehe nehẽ. ");
INSERT INTO pahNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","A'ereki ji a'e nde ve: Jypyve'g̃a – kiroki g̃a nde hoypyrame nduri – g̃a ndo'ui'i'i po ti nhiremimboavujikwerukava'ea. Iporia'ive'g̃a jate po ti o'u,” ei ga, ei Jesus'ga imombe'gwovo g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Aerẽ Jesus'ga hogahoi pehea rupi taho ti ji Jerusalém me javo. Ga rupi he'yjuhuve'g̃a hog̃ahoi. Opyryryma Jesus'ga ei g̃a pe: ");
INSERT INTO pahNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","—Po ga uhu ji pyri tako ji neremimbo'eharamo javo. Ji arõheterame po ti ga rekoi nhiremimbo'eharamo nehẽ. Koji'i ti ga tanhiarõ hete gwuva'ga arõa hohe, oyhẽa arõa hohe, g̃wembirekohẽa arõa hohe, gwa'yra'g̃a arõa hohe, oirũ'g̃a arõa hohe, okuvyra'g̃a arõa hohe g̃wendyra'g̃a arõa hohe. Koji'i ji arõheterame g̃a'arõa hohe po ti ga rekoi nhiremimbo'eharamo nehẽ. Koji'i ga g̃a arõrame nhiarõa hohe, namongoi po ti ji ga nhiremimbo'eharamo nehẽ. G̃wemimbotarimo rehe ga rekorame po ti ji namongoi ga nhiremimbo'eharamo nehẽ. Ji rehe jate ti ga toko ji arõheteavo, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","—Po ti ojipe'g̃a imbohahyukari ga pe ga jukavo vehevi nehẽ ereko nde Jesus'gareheva'ero javo ga pe, toko jitehe ti ga nhiremimbotarimova'ea rehe opohire'yma ji hugwi. Okoe'ymame nhiremimbotarimova'ea rehe ti ga tokoyme nhiremimbo'eharamo nehẽ, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","—Po peapo pota onga jo'ara, a'ero pe peapyna'ẽi pejapyakakatuavo hehe. Pejiyvyteri pe pe ei nehẽ: “Marã? Ohy re po ti hehe nhiitambere'ia ikwepykavamo ji japorame nehẽ? Marã? Ndohygi po ti nhiitambere'ia hehe ikwepykavamo nehẽ?” A'ea pe ei pejapyakakatuavo ikwahava. Ihygame jate po ti pe japoi nehẽ, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","—Pejapyakakatue'ymame ikwahave'ymame po ti pe imbovyri okyta tehe japopave'yma nehẽ herekoa'jave'ymame itambere'ia nehẽ. Hepiagame g̃a nhaporemo g̃a e'ie'i pe me pe jaita a'ero nehẽ. ");
INSERT INTO pahNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","“Pehepia ti g̃a! Ndoapoi gweuhu g̃a,” e po ti g̃a pe mombe'gwovo nehẽ, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","—Po huvihavuhu'ga oho pota ojipe'g̃a nduvihavuhu'ga rovatiamo ga rurame otavuka ga pe, a'ero ga apyna'ẽi ojapyakakatuavo hehe. Oyvyteri pe ga ei nehẽ: —“Nhipavẽive'g̃a ko he'yive'g̃a dez milve'g̃a soldados'g̃a. Emo vinte milve'g̃a soldados'g̃a ko gapavẽive'g̃a. Gapavẽive'g̃a he'yjuhu hete nhipavẽive'g̃a hohe reki. Marã po ti nhipavẽive'g̃a g̃a nderekoi g̃a novatiamo g̃a ndurame otavuka ji ve nehẽ? Mara'ngu po ti g̃a g̃a jukavo nehẽ?” ei ga oyvyteri pe. ");
INSERT INTO pahNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","—Ojapyakarẽ hehe ga ei oyvyteri pe: “Nhipavẽive'g̃a po ti ndipopoakari g̃a pe nehẽ. Nduri ve ga. Irupe hete ga ji hugwi. Amondouka po ti ji ojipejipejiteve'g̃a nhipavẽive'g̃a ga pyri nehẽ te'i katu ti g̃a ga pe ga ma'ngoma'ngoga. Nurã ndura'javi po ti ga otavuka ji ve nehẽ.” A'ea huvihavuhu'ga ei ikwahava ojapyakakatuavo, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","—Na jitehe penhimbopiro'y ti pejeaporog̃ita hugwi peapoa hugwi no pejapyakakatuavo na'ẽ. Pe'ji ti: “Kiro ti ji tako Jesus'ga remimbotarimova'ea rupi jate. Jiapoa ko ga'apoa kiro.” Po pe ndape'ei a'ea penhimbopiro'ye'yma pejeaporog̃ita hugwi, a'ero po ti pe ndapekoi nhiremimbo'eharamo nehẽ, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","—Jukyra ko pyry. A'ereki omongo katu mbatera imonemukare'yma jupe. Pyry mbatera a'ero, ei Jesus'ga. Po jukyra ndapyryva'javi, marã po ti ahe imombyryva'javi jukyra a'ero nehẽ? Ahe nombyryva'javi tuhẽ jukyra! ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","A'ero ahe ndopo'rua'javi jukyra. Ahe nomondoi yja pype tombohory nhiremityma javo. A'ereki nombohoryvi aheremityma. Ahe nombojihe'arukari i'atagwera rehe imondovo yja pype nhiremityma tombohory javo. A'ereki jukyra ndapyryva'javi. Omombo ahe a'ero. —Po na jitehe pe ndapepyryva'javi, maranuhũ pe ojipe'g̃a mongokatui naerũ? Maranuhũ po ti ji nhimoirũukara'javi pe me nehẽ pehepiuka ti Tupana'ga pyryva g̃a pe javo pe me naerũ? Peapyakwa pe. Pehendu katu ti ji'ea a'ero! ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Aerẽ itambere'ia mono'õhara'g̃a ndug̃anduri Jesus'ga pyri okote'varuhuve'g̃a pavẽi. G̃a uhu pa onhimono'og̃a Jesus'ga pyri tihendu Jesus'ga javo. ");
INSERT INTO pahNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Fariseus'g̃a g̃ambo'ehara'g̃a pavẽi ndopotari okote'varuhuve'g̃a ndurame Jesus'ga pyri. A'ero g̃a ei: —Ojihe'a Jesus'ga okote'varuhuve'g̃a ndehe gworygworyvamo g̃a ndehe! G̃a pyri ga i'ui no, ei g̃a. ");
INSERT INTO pahNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Nurã Jesus'ga imombe'ui fariseus'g̃a pe ojo'java'ea. G̃a mbo'eavo ga ei: ");
INSERT INTO pahNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","—Po pe pereko penhenymbava cem ovelhas. Po ojipeji oka'nhy pe hugwi, ndapehoi re po pe heka naerũ? Peheja po pe naerũ he'yiva'ea noventa e nove ovelhas ongae'ỹi me pejigwovo hekapige'yma ojipeji ika'nhymava'ea repiaga. ");
INSERT INTO pahNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Hepiagame po pe imondoi peahavi pejoryjoryvamo herua. ");
INSERT INTO pahNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Pevahemame penhonga pe po pe g̃a mbuhurukari pejipyri pejikoty'ave'g̃a pejikotyve'g̃a ndeheve. Pe'e po pe g̃a pe: “Pejoryjory ti ore pavẽi. A'ereki ore orohepia orerenymbava ovelha ika'nhymipyra.” Nahã po pe ei, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","—Na jitehe yvagipeve'g̃a ndoryndoryhetero yvagi pe okote'varuhuve'ga pohirame okote'varuhua hugwi. Tupana'ga ga rerura'ja ojipyri. Noka'nhyma'javi ga Tupana'ga hugwi. Oka'nhyve'g̃a ja rũi noventa e nove pyryve'g̃a ndekoi, ei Jesus'ga. A'e ji pe me: Koji'i yvagipeve'g̃a ndoryndoryvamo ojipeji'ga rehe oka'nhymipyra'ga rehe ga pohirame okote'varuhua hugwi, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Kiro Jesus'ga imombe'ui ojipea. G̃a mbo'eavo ga ei: —Po kunhangwerahẽa gwereko itambere'ia dez moedas de prata, ei Jesus'ga. Po hẽa omoka'nhy ojipeji g̃wonga pype, a'ero po hẽa imondygi lamparina tahepia ti itambere'ia javo. Opehipehi katu po hẽa g̃wonga pype ytya mbojatyka itambere'ia rekapige'yma hepiaga, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Itambere'ia repiagame po hẽa g̃a mbuhurukari ojipyri ojikoty'ave'g̃a okotyve'g̃a no. A'ero po hẽa ei g̃a pe: “Pejoryjory ti ji pavẽi. A'ereki ji ahepia itambere'ia nhiremimoka'nhymipyra,” e po hẽa, ei Jesus'ga imombe'gwovo g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","—Na jitehe Tupana'gapyrive'g̃a yvagipeve'g̃a ndoryndoryvamo okote'varuhuve'ga pohirame okote'varuhua hugwi ojipejive'ga. Noka'nhyma'javi ga Tupana'ga hugwi. A'ereki Tupana'ga ga rerura'ja ojipyri, ei Jesus'ga imombe'gwovo fariseus'g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Kiro Jesus'ga imombe'ui ojipea. G̃a mbo'eavo ga ei: —Mokõi akwaimbae'ga ra'yra'g̃a. ");
INSERT INTO pahNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Uva'ga pe ipyahuve'ga ei: “Apĩ,” ei ga. “Aheruva'ga ti tomo'ẽ ombatera gwa'yra'g̃a pe g̃a yvuakarame. Emo'ẽ ti kiro a'ero. Embuhu ji ve kiro jiapoa,” ei ga. A'ero garuva'ga imo'embavi ombatera he'yiva'ea gwa'yra'g̃a pe imondovo, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","—Aere'ĩ ipyahuve'ga imono'ombavi ombatera. Kiro ga herohoi. Paivo ga hoi upa. Pevo gwe ga hogahoi hepia'ngia rehe. Nharuiveuhũ ga okovo. ");
INSERT INTO pahNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","—Oitambere'ia ga imondopavi a'ero hehe. A'ea rupi tiruahũ g̃agwyri pe. A'ereki itymipyra nahenhui. Ahã tuhẽ mbatera pevo a'ero. Kiro g̃a jukapahetei ty'ara. Ga ndogwerekoa'javi ojive no. A'ero ty'ara ga jukai. ");
INSERT INTO pahNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Nurã ga hoi oporavykyavo pevove'ga pe tapyhy mbatera jijive javo. Pevove'ga omboporavyky ga a'ero ga mondovo nhuhũ me. “Ehepia katu ti porcos tohoyme ti a'ea hugwi i'urame,” ei ga ga pe. ");
INSERT INTO pahNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","—A'ero ga hepiakatui porcos ga pe okovo. Ougwei ga ipoitava reki tanhimoytaromouka javo novĩa. A'ereki g̃a nomondoi ga pe, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","—Aerẽ ga japyakwapupugamo. “Garamo ji pytauhui avo naerũ?” ei ga oyvyteri pe. “O'u katu g̃a mbatera – kiroki g̃a oporavyky jiruva'ga pe. G̃a ndohygi reki hehe. He'yiva'ea hembyruera g̃a gwereko a'ero. Emo jihi kiro po ti amano avo jitekovo. A'ereki ji juka hete ty'ara,” ei ga oyvyteri pe. ");
INSERT INTO pahNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","—“Aho aha po ti ji nhivahema apina'ga pyri nehẽ. A'e po ti ji ga pe nehẽ: Apĩ, ji rekote'varuhui Tupana'ga pe yvagipeve'ga pe. Nde ve ji rekote'varuhui no. ");
INSERT INTO pahNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ere'e po nde ji ve hamo: ‘Jira'yra'ga rũi kiro ga rekoi ji ve.’ A'ea po nde ei ji ve hamo. Na ji poravykyi nde ve nehẽ oporavykyve'g̃a ja a'ero nehẽ. A'ea po ti ji ei jiruva'ga pe nehẽ.” A'ea ga ei oyvyteri pe ojapyakavo oina, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Ovy ga a'ero opohia oporavykya hugwi porcos reja ua pea hugwi. —Ovahẽ g̃werĩ ga uva'ga ronga pe ua. Irupe garuva'ga gwa'yra'ga repiagi. “Kirog̃we jira'yra'ga jivyra'javi ji pyri. Aporogwety ji ga,” ei ga. A'ero ga nhani ga repenhana. Obeija ga ga gworygworyvamo ga rehe ga anhuvana. ");
INSERT INTO pahNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","—Kiro ipyahuve'ga ei uva'ga pe: “Apĩ,” ei ga. “Ji rekote'varuhui Tupana'ga pe yvagipeve'ga pe oji'i. Nde ve ji rekote'varuhui no. Ere'e po nde ji ve hamo: ‘Jira'yra'ga rũi kiro ga rekoi ji ve.’ A'ea po nde ei ji ve hamo,” ei ga. ");
INSERT INTO pahNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","—Emo garuva'ga e'i ojipyrive'g̃a pe: “Haite! Peru ti tapy'ynhapikatua – kiroki a'ea koji'i ikatu. Pemongiuka ti ga pe. Pemondo ti gapoakag̃areheva'ea gapoakag̃a rehe. Pemondo ti ga pe sandálias no,” ei ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","“Peho ti herua imboky'rauhu'iva'ea bezerro yuranuhũa ra'yra. A'ea nhande iporakahetei. A'ea pejuka ti,” ei ga. “Ti'u ti. Tiapo ti toryva. ");
INSERT INTO pahNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","A'ereki jira'yra'ga horame ji hugwi ji ei: Omano ga. A'ereki ji a'e ikwehe'i: Ji ndahepiaga'javi po ti ga nehẽ. Kiro ga jivyra'javame ji pyri ji ei: Okwerava'ja ga. Oka'nhymypy ko ga ji hugwi ohorame ji hugwi. Kiro ji ga repiaga'javi,” ei ga ojipyrive'g̃a pe. —“Kwa,” ei g̃a ogwovo. Kiro g̃a japoi toryva. ");
INSERT INTO pahNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","—Ojihuvypyve'ga rekoi ko pe. Kiro ga ruri ojivya onga pe. Ovahemame ga henduvi. A'ero ga ei oyvyteri pe: “Opy po g̃a imonhi'ig̃a,” ei ga. ");
INSERT INTO pahNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","—Ojipyri ga ojipyrive'ga mbuhurukari javo ga pe: “Maraname g̃a japoi toryva?” ei ga. ");
INSERT INTO pahNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","—“Neirũ'ga uhu,” ei gapyrive'ga ga pe. “Nderuva'ga ga rerekokatua'ja. ‘Nitetirũi ga,’ ei nderuva'ga. ‘Okoji jira'yra'ga,’ ei ga. Nurã nderuva'ga ojukauka imboky'rauhu'iva'ea bezerro,” ei ga. ");
INSERT INTO pahNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","—Ojihuvypyve'ga onhimonha'nga henduvame. Ndokipotari tuhẽ ga onga pype toryva repiaga. A'ero garuva'ga hemi ua ga pyri. “Herejo tuhẽ,” ei ga gwa'yra'ga pe. A'ea ga ega'ei ga pe. ");
INSERT INTO pahNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","—A'ero ojihuvypyve'ga ei uva'ga pe: “Ji rendu ti! Imbokwara'ara'arame jihi aporavyky hete nde ve jitekovo. Nane'ymi nenhi'ig̃a rupi ji ako katu. Ji ve nde nerembuhuri'i'i xunhiva'ea cabrito. Poi nde nerembuhuri ji ve toapo ti ga toryva javo ojikoty'ave'g̃a pavẽi. ");
INSERT INTO pahNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Gaha reki, ndera'yra'ga, ga jigwaraipavi neitambere'ia rehe imondovo ahe'upahara'g̃a pe. Ga rura'javame nde ijukaukari ga pe imboky'rauhu'iva'ea bezerro,” ei ojihuvypyve'ga uva'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","—“Pi'a,” ei garuva'ga ga pe. “Nane'ymi nde ruvi ji pyri. Nhimbatepava nembatera tuhẽ okovo. ");
INSERT INTO pahNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Pyry nhande roryroryvamo. Nurã ti tiapo toryva. A'ereki neirũ'ga horame nhande hugwi nhande ei: Omano ga. A'ereki nhande xa'e ikwehe'i: Ndihepiaga'javi po ti nhande ga nehẽ. Kiro ga jivyra'javame nhande pyri nhande ei: Okwerava'ja ga. Oka'nhymypy ko ga nhande hugwi ohorame nhande hugwi. Kiro nhande ga repiaga'javi,” ei garuva'ga, ei Jesus'ga imombe'gwovo. ");
INSERT INTO pahNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Kiro Jesus'ga ei g̃wemimbo'ehara'g̃a pe imombe'gwovo ojipea. G̃a mbo'eavo ga ei: —Imbateheteve'ga ei ojipyrive'ga pe: “Ehepia katu nhimbatera ji ve ima'eamo ipyhyga itambere'ia ji ve,” ei ga ga pe. —“Kwa,” ei ga. —Aerẽ imbateve'ga pyri g̃a uhu javo ga pe: “Ndepyrive'ga ojigwarajuhu nembatera rehe,” ei g̃a imbateve'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","—Imbateve'ga ombuhuruka ojipyrive'ga a'ero. Ga pe ga ei: “Garamo nde rekouhui? Nde mombe'u g̃a ji ve. Maraname nde jigwarai nhimbatera rehe? Ekwatija ti ji ve imombe'gwovo enhimima'ẽa. Tahepia ji. Nde po ti ndereporavykya'javi ji ve hepiage'yma nhimbatera ji ve nehẽ,” ei ga ga pe. ");
INSERT INTO pahNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","—A'ero gapyrive'ga ei oyvyteri pe: “Marã po ti ji rekoi a'ero nehẽ? Kiro po ti jiruvihava'ga ji mondohetei ojihugwi ji mboporavykya'jave'yma ojive nehẽ. Ndajipopoakari ji. Nurã ndahyvykoi ko pe. Naporanduva'uvi ji mbatera ojipe'g̃a hugwi. Marã po ti ji rekoi ipyhyga mbatera jijive nehẽ?” ei ga. ");
INSERT INTO pahNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ojapyaka ga. “Ah! Kiro ji akwaha!” ei ga. “Nahanahã po ti ji rekoi g̃a mbohoryoryva ji rehe nehẽ. A'ero po ti g̃a ji mboapygi g̃wonga pype ji rerekokatuavo nehẽ ji poravykya'jave'ymame ga pe nehẽ,” ei ga oyvyteri pe. ");
INSERT INTO pahNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","—A'ero g̃a mbojopy'rupy'ruavo ga g̃a mbuhupavukari ojipyri – kiroki g̃a ndokwepygi ve garuvihava'ga pe. Urypyve'ga rurame ga ei ga pe: “Maramomi nde nderekwepygi ve jiruvihava'ga pe?” ei ga. ");
INSERT INTO pahNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","—A'ero ga ei gapyrive'ga pe: “He'yiva'ea ikava cem tambores de azeite,” ei ga. —A'ero gapyrive'ga ei ga pe: “Koro neconta ikwatijara. Haite! Eapy ti ikwatijara'java he'yiva'ea rerojijyita. Ndahe'yiva'ea cinquenta tambores jate ti ekwatija. A'ea po ti nde ikwepygi ga pe nehẽ,” ei ga. A'ero a'ea ga ikwatijari. ");
INSERT INTO pahNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","—Ojipe'ga pe ga ei ga rurame: “Maramomi nderekwepygi ve jiruvihava'ga pe?” —A'ero ga ei ga pe: “He'yiva'ea ha'ynha cem alqueires de trigo.” —A'ero gapyrive'ga ei ga pe: “Koro neconta ikwatijara. Haite! Eapy ti ikwatijara'java he'yiva'ea rerojijyita. Ndahe'yiva'ea oitenta alqueires jate ti ekwatija. A'ea po ti nde ikwepygi ga pe nehẽ,” ei ga. A'ero a'ea ga ikwatijari. ");
INSERT INTO pahNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","—Aerẽ ikwahavame garuvihava'ga ei: “Heaporog̃ita jipyrive'ga ojapyakaheteavo ji moandyita ikwahava.” A'ea ga ei ojipyrive'ga omoandyirame, ei Jesus'ga imombe'gwovo. —A'ereki okote'varuhuve'g̃a okwaha ojogwerekovo gweaporog̃itaro. A'ea g̃a ikwahavi pyryve'g̃a hohe jireheve'g̃a hohe kojahuarupive'g̃a hohe, ei Jesus'ga imombe'gwovo g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","—Jihi a'e pe me, ei Jesus'ga g̃a pe. Pemondo ti iporia'ive'g̃a pe penhiitambere'ia tohoryory ti g̃a pejihe. A'ero aerẽ pe manorame ipyhyga'jave'yma itambere'ia, po ti g̃a ndoryndoryvamo jitehe pe ndehe nehẽ pe mboapyga ojipyri pevo yvagi pe nehẽ – kiroki a'ea ndopavi nehẽ. Pevo nane'ymi po ti nde ruvi g̃a pyri nehẽ, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","—Kiroki ga ndahe'yiva'ea repia katu – gaha he'yjuhuva'ea repia katu no ahe mbojikoga ojihe. Kiroki ga ndahe'yiva'ea rehe omotetirũa – gaha he'yjuhuva'ea rehe omotetirũa no ahe mbojikoge'yma ojihe, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Po pe ndapepo'rukatui yvyakotyva'ea penhiitambere'ia, a'ero po ti Tupana'ga nomondoi oapoa pyryheteva'ea yvagipeva'ea pe me nehẽ topo'ruyme ti g̃a javo. ");
INSERT INTO pahNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Po pe ndapehepiakatui aheapoa ahe ve ahe mbojikoge'yma ojihe, a'ero po ti Tupana'ga nomondoi peapoa pe me nehẽ, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","—Kiro po ti ji g̃a mombe'ui mokonha'g̃a ahepojykahara'g̃a pe me pe mbo'eavo, ei Jesus'ga. Tiruahũ ahe poravykyrame mokonha'g̃a pe opojykahara'g̃a pe. Po ahe oporavyky mokonha'g̃a pe, a'ero po ahe ojipe'ga arõhetei ojipe'ga arõe'yma. Ovy'a hete po ahe onhimiarõve'ga rehe ojipe'ga koty ojirovage'yma. —Na jitehe ahe nonhi'ĩpo'rukatui Tupana'ga ovy'aheterame itambere'ia rehe. Tupana'ga potaheterame ahe ndovy'ahetei itambere'ia rehe. Itambere'ia potaheterame ahe ndojirovagi Tupana'ga koty, ei Jesus'ga g̃wemimbo'ehara'g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Jesus'ga imombe'urame g̃wemimbo'ehara'g̃a pe fariseus'g̃a ga rendupavi. Fariseus'g̃a opotaruhu itambere'ia. Nurã g̃a ndopotari Jesus'ga remimombe'ua. A'ero g̃a Jesus'ga jaihetei ga rerekomemuamo. ");
INSERT INTO pahNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Kiro Jesus'ga ei fariseus'g̃a pe: —Pehe peko katu ahe pejepiagame jate. A'ero ahe ei: “Tupana'ga roryroryvamo g̃a ndehe g̃andekokatua rehe.” Ikwahave'yma ahe ei nahã ombaragwahave'yma g̃waramo pendekote'varuhua rehe. Tupana'ga ki a'e te okwaha pendekote'varuhua. Aheremimboheteva'ea pe Tupana'ga ei: “Ite'varuhu hete!” ei ga. ");
INSERT INTO pahNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","—Ymyahũ ymyahũva'ea ahe mbo'ei Moisésva'ea remimbo'eagwera rehe Tupana'ga nhi'ig̃a mombe'uharava'ea nhi'ig̃agwera rehe no. A'ea rehe ymyahũve'g̃a g̃a mbo'ei ikwehe'i no nahanahã ti peko katu javo. Kiro João Batista'ga ag̃wamove'g̃a mbo'ei pyryva'ea rehe ji pavẽi, ei Jesus'ga. G̃a mbo'eavo ore ei g̃a pe: Kiro Tupana'ga oko nhanderuvihavuhuhetero nhande repiakatuavo. Orerenduve'g̃a heroviapotahetei orenhi'ig̃a. A'ero g̃a ei: “Toko ti ga oreruvihavuhuhetero.” A'ea g̃a ei ipotaheteavo ojikoga Tupana'ga rehe. ");
INSERT INTO pahNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","—Po yvaga opa. Po yvya opa. Moisésva'ea remimbo'eagwera ki a'e te ndopavi'i'i. Xunhi'i'ĩva'ea rũi po ti ipavi jugwi nehẽ, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","—Kiroki ga opohi g̃wembirekohẽa hugwi hẽa mondoheteavo – gaha ite'varuhu ojipehẽa rerekorame. Tupana'ga ndopotari ga ojipehẽa rerekorame. Hẽa rerekorame ga ajuajuri. A'ereki ga hembireko jitehe jypyvehẽa pavẽi. Na jitehe – kiroki ga gwereko garembirekoypyvehẽa ga pohirame hẽa hugwi – gaha ite'varuhu hẽa rerekorame. A'ereki ga gwereko garembirekohẽa. Tupana'ga ndopotari nanongara, ei Jesus'ga g̃a mbo'eavo. ");
INSERT INTO pahNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Kiro Jesus'ga imombe'ui g̃a mbo'eavo. A'ero ga ei: —Ahe gwereko pa imbateheteva'ea. Nane'ymi ahe omongi tapy'ynhapipyryva ikatuheteva'ea. He'yi hehe. Huvihava'g̃a pira'java'ea ko ahepira hovy'iva'ea linho apopyra no pyryva'ea. Nane'ymi ahe herekoi ikatukatuva'ea jate i'gwoi'gwovo gworygworyvamo. ");
INSERT INTO pahNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","—Aherongauhua apoa pyri porta pyri Lázarova'ea nhinog̃i. Ono g̃a ahe pevo jipi. Iporia'i Lázarova'ea ombatere'ymamo ojagwuhuro. He'yjuhu ahejagwa. ");
INSERT INTO pahNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Ougwei ahe imbateva'ea rembi'uagwera. “Po ga imbuhurukari ji ve hamo – kiroki ohiohi gajurua hugwi yvyvo ga i'urame,” ei ahe oyvyteri pe. Nhag̃watig̃a uhu ahejagwa rererereva okovo! ");
INSERT INTO pahNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","—Aerẽ iporia'iva'ea manoi Lázarova'ea. A'ero Tupana'gapyrive'ga ahera'uva rerohoi imondovo Abraãova'ea pyri yvagi pe. —Imbateva'ea manoi no. A'ero g̃a ahe tymi. ");
INSERT INTO pahNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Omanove'g̃a gwyri pe imbateva'ea ra'uva rekoi. Hahy hete imbateva'ea pe pevo. Kiro ahe jovavuri. Paivo ihoi ahema'ẽa Abraãova'ea repiaga. Ahe gwepia Lázarova'ea rekorame Abraãova'ea pyri hete. ");
INSERT INTO pahNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","A'ero imbateva'ea onhi'ig̃a mondoi: “Amoi! Abraão!” ei ahe. “Ji porogwety po nde hamo! Embuhuruka ti Lázarova'ea ji pyri. Tomonde ti ahe opoakãtĩapy'ria yhya pype herua imbuhua nhikũa rehe imbohakuvia nhikũa. A'ereki hahyuhu ji ve tata pype.” ");
INSERT INTO pahNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","—A'ero Abraãova'ea ei: “Pi'a,” ei ahe. “Nahembuhurukari ji. Ekwahava'ja ti. Emanoe'ymame nde erereko embatera ikatuva'ea ejoryjoryvamo. Lázarova'ea pe ki a'e te ite'varuhu hete omanoe'ymame. Kiro Lázarova'ea py'a u katu avo ji pyri. Nde ve kiro hahy hete. ");
INSERT INTO pahNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Nhanema'õ me oko yvya kwaruhua. Nurã ahe ndohahavi ore hugwi pe pyri. Na jitehe ahe ndohahavi pe hugwi ore pyri,” ei Abraãova'ea ahe ve. ");
INSERT INTO pahNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","28","—A'ero imbateva'ea ei: “Amoi!” ei ga. “Ji rendu! Emondouka ti Lázarova'ea jiruva'ga ronga pe a'ero nhiirũ'g̃a pyri cincove'g̃a pyri. Tomombe'u ti ahe g̃a pe jirekote'varuhua kwepykava topohi ti g̃a okote'varuhua hugwi. A'ero nduri po ti g̃a avo ji pyri hahyva'ea ruvihava pype nehẽ,” ei imbateva'ea Abraãova'ea pe. ");
INSERT INTO pahNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","—A'ero Abraãova'ea ei: “Gwereko g̃a Moisésva'ea remimbo'eagwera aherembikwatijara. Gwereko g̃a Tupana'ga nhi'ig̃a mombe'uharava'ea nhi'ig̃agwera aherembikwatijara. Na g̃a aherembikwatijara rendukatui xako hehe javo,” ei Abraãova'ea ahe ve. ");
INSERT INTO pahNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","—“Amoi,” ei ahe Abraãova'ea pe. “Nohenduvi po ti g̃a aherembikwatijara okoe'yma hehe. Po ti ahe vyri omanoa hugwi ogwovo g̃a pyri imombe'gwovo g̃a pe nehẽ, a'ero po ti g̃a pohiri okote'varuhua hugwi nehẽ,” ei imbateva'ea. ");
INSERT INTO pahNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","—A'ero Abraãova'ea ei ahe ve: “Po g̃a nohendukatui Moisésva'ea remimbo'eagwera Tupana'ga nhi'ig̃a mombe'uharava'ea nhi'ig̃agwera reheve, a'ero po ti g̃a ndogweroviari ahe vyrame omanoa hugwi ogwovo g̃a pyri imombe'gwovo g̃a pe nehẽ. Nurã po ti ji namondoukari ahe pevo nehẽ,” ei Abraãova'ea imbateva'ea pe. A'ea Jesus'ga imombe'ui fariseus'g̃a pe g̃a mbo'eavo. ");
INSERT INTO pahNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","G̃wemimbo'ehara'g̃a pe Jesus'ga ei: —Jara'g̃a ombote'varuhu jipi. Na tuhẽ po ti jipi nehẽ, ei Jesus'ga. G̃a pe ti tiruahũ hete nehẽ – kiroki g̃a ombote'va ojipe'g̃a mbopogweavo ite'varuhuva'ea rehe, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Omano jipe po g̃a hamo tombote'varyme ti g̃a jireheve'g̃a – kiroki jireheve'g̃a ag̃wamo gwe ojiko Tupana'ga rehe ikwahapave'yma Tupana'ga nhi'ig̃a, ei Jesus'ga. Po ahe opytĩ g̃ajurimo itaruvihavuhua ipohyiva'ea yngu'a'javuhuva'ea g̃a momboa ypiahua ruvihava pype g̃a mbotypyvyga, a'ea ko tiruahũhetero g̃a pe. Koji'i tiruahũ hete g̃a pe g̃a jireheve'g̃a mbote'varuhurame, ei Jesus'ga g̃wemimbo'ehara'g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","—Eko katu ti! Po ndekotyve'ga ite'varuhu nde ve – kiroki ga ojiko ji rehe nde ja. Po ga ite'varuhu nde ve, a'ero ti ere ga pe: “Nahanahã nderekote'varuhua ji ve. Na rũi ahe japoi.” A'ea ti ere ga pe, ei Jesus'ga. —Po ga ei nde ve: “Jite'varuhu ko ji ko. Ndajite'varuhua'javi po ti ji nde ve a'ero nehẽ,” e po ga nde ve. Po ga pohiri okote'varuhua hugwi, a'ero terehenonha'javi ti garekote'varuhua. ");
INSERT INTO pahNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","—Po he'yjuhurame po seterame ga te'varuhua'jaa'javamo nde ve ara rupi ve. Po he'yjuhurame po seterame ga ea'jaa'javi nde ve: “Jite'varuhu ko ji ko,” e po ga nde ve. “Ndajite'varuhua'javi po ti ji nde ve a'ero nehẽ. Apohi ji kiro jirekote'varuhua hugwi,” e po ga. A'ero he'yjuhurame seterame ti erea'jaa'ja ga pe: “Nahenonha'javi po ti ji nderekote'varuhua nehẽ.” Nahã ti ere ga pe, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","A'ero Jesus'ga remimbo'ehara'g̃a – kiroki gamoirũhara'g̃a – g̃a ei Jesus'ga pe nhandepojykaharete'ga pe: —Orojiko ore Tupana'ga rehe gapopoakara rehe no. Ore poko ti. Koji'i ti embojikoguka ore ve. ");
INSERT INTO pahNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","A'ero Jesus'ga ei g̃a pe: —Po pe jikogi gwere jitehe Tupana'ga rehe gapopoakara rehe no, a'ero po pe ei agwava'ea pe i'yva pe figueira brava pe: “Ipya rehe vehevi ti ejijyi enhityma'java typya pype ypiahua ruvihava pype.” Po pe ei a'ea, a'ero ijijyi onhityma'java typya pype, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Kiro Jesus'ga ei: —Po pepyrive'ga gwyvykoi ko pe oporavykyavo. Po ga penenymbava repia katu ovelhas repia katu oporavykyavo. Ga rurame onga pe oporavykyhava hugwi pe ndape'ei ga pe: “Haite! Herejo eapyga mesa pyri. E'u ti.” Pe ndape'ei na ga pe. ");
INSERT INTO pahNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Pe pe'e ga pe: “Emboavujikwe pa ti mbatera ji ve ta'u. A'ero ti enhimboavujikwe herua mbatera imbuhua ji ve. Ji i'urẽ po ti nde i'ui ji py'rovo nehẽ,” pe'e pe pejipyrive'ga pe, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","—Pe ndape'ei ga pe: “Ndepyry hete nde eporavykyavo ji ve ekoheteavo nhinhi'ig̃a rupi.” A'ea rũi pe ei ga pe. Pepyriva'ero g̃waramo oporavyky po ga pe me hamo. ");
INSERT INTO pahNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","—Na jitehe pejipyrive'ga ja pe tuhẽ ti peko. Pekopavame Tupana'ga nhi'ig̃a rupi ti pe'ji Tupana'ga pe: “Ore rekopavame enhi'ig̃a rupi, terei ti ore ve pepyry hete pe javo. Ndepyriva'ero g̃waramo oroporavyky po ore nde ve hamo.” A'ea ti pe'ji Tupana'ga pe, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Aerẽ Jesus'ga hogahoi taho ji Jerusalém me javo. Ohorame ga okwa Galiléiapeve'g̃a gwyri pe Samariapeve'g̃a gwyri pe no. ");
INSERT INTO pahNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Pevo ga vahemi cidade'i pe. Cidade'ia rembeyvyri pe ijaijauhuve'g̃a ga rovatĩ dezve'g̃a. Irupe g̃a pytai ga hugwi. ");
INSERT INTO pahNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Jesus'ga pe g̃a onhi'ig̃a mondoi javo: —Jesus! ei g̃a ga pe. Ore porogwety po nde hamo, ei g̃a Jesus'ga pe ga renoina nde ko orembo'eharamo javo ga pe. ");
INSERT INTO pahNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","G̃a ndepiagame Jesus'ga ei g̃a pe: —Peho ti pejipiuka ikwava'ẽhara'g̃a pe pejijagwa repiuka g̃a pe. G̃a horame g̃ajagwa pigi g̃a hugwi. ");
INSERT INTO pahNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Ojagwapihava repiagame ojipeji'ga jivyri Jesus'ga pyri. Hahyahi ganhi'ig̃a ga erame Tupana'ga mboheteavo gworygworyvamo ga rehe. ");
INSERT INTO pahNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","—Ndepyry hete nde! ei ga Jesus'ga pe. Erepohano kwaha hete nde. A'ea ga ei onhinog̃a upa ojovapyvo Jesus'ga pyri ndehe koji'i ji hohe javo. Ga ko Samariapeve'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","18","Nurã Jesus'ga ei: —Nhandegwyripeve'ga rũi – gaha jate ga jivyri ji pyri gworygworyvamo Tupana'ga rehe ga mboheteavo. Amombi ji dezve'g̃a jagwa g̃a hugwi. Ma jara'g̃a naerũ, noveve'g̃a judeus'g̃a? Po g̃a jivyri Tupana'ga mboheteavo hamo! ");
INSERT INTO pahNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Samariapeve'ga pe Jesus'ga ei: —Epo'ã heregwovo enhonga pe. Erejiko nde ji rehe. Nurã ndejagwa pigi nde hugwi. ");
INSERT INTO pahNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Aerẽ fariseus'g̃a ei Jesus'ga pe: —Maname po ti Tupana'ga oko nhanderuvihavuhuhetero avo yvya koty nehẽ? A'ero Jesus'ga ei g̃a pe: —Ndiukwahavi Tupana'ga rekorame huvihavuhuhetero yvya koty nehẽ. ");
INSERT INTO pahNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Nurã po ti g̃a nde'i nehẽ: “Pehepia! Avo ko ga rekoi huvihavuhuhetero! Pehepia! Pevo ko ga rekoi huvihavuhuhetero!” A'ea rũi po ti g̃a ei nehẽ. A'ereki Tupana'ga oko jipe huvihavuhuhetero aheyvyteri pe ahe jikogame ga rehe, ei Jesus'ga fariseus'g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","G̃wemimbo'ehara'g̃a pe Jesus'ga ei: —Aerẽ po ti pe ei nehẽ: “Po ti ga rura'javi opytaahi'viavo nhande pyri nehẽ hamo.” Nahã po ti pe ei ji repiaga'japotaheteavo nehẽ novĩa. Pe ndajirepiagi nehẽ, ei Jesus'ga yvyakotyva'ero yvagipeva'ero no. ");
INSERT INTO pahNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","—O'mbero po ti g̃a ei pe me nehẽ: “Pehepia! Pevo ko Cristo'ga! Pehepia! Avo ko Cristo'ga!” Nahã po ti g̃a ei pe me o'mbero nehẽ. Tapehoi ti g̃a ndupi hepiaga. Taperoviari ti g̃a. ");
INSERT INTO pahNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","—Jijipiukarame ji rura'jahava rupi tupã verava ja po ti ji rekoi nehẽ. Tupã veraveravame kikoty yvaga rehe ombokojahu pa kokoty yvaga rehe no. A'ero ahe gwepia pa kojahua. Na jitehe po ti g̃a nhaporemo ji repiagi ji rura'javame yvaga hugwi nehẽ, ei Jesus'ga yvyakotyva'ero yvagipeva'ero no. ");
INSERT INTO pahNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Kiro po ti g̃a imbuhuna'ẽi he'yiva'ea hahyva'ea ji ve avo nehẽ. Ag̃wamove'g̃a po ti nanhiarõi ji reroviare'yma kiro nehẽ. ");
INSERT INTO pahNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","—Noéva'ea nhinhag̃a renondehava yhara ruvihavuhua pype ojo'ja jirura'java renondehava pavẽi, ei Jesus'ga yvyakotyva'ero yvagipeva'ero no. ");
INSERT INTO pahNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Ymyahũ Noéva'ea nhinhag̃a renonde yhara ruvihavuhua pype ahegwyripeva'ea i'ui'ui jipi gworygworyvamo hako. Ahegwyripeva'ea rembirekoro akwaimba'eva'ea jipi no. Ojipeva'ea kunhava'ea mohembirekoi no. Nahã ahegwyripeva'ea rekoi okovo imboha'uve'yma Noéva'ea avame yhara ruvihavuhua pype yhya hehanhuhũa rurame ahegwyripeva'ea mbotypyvypava nhatymbava hako – kiroki ahegwyripeva'ea ndo'avi yhara ruvihavuhua pype. ");
INSERT INTO pahNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","—Na jitehe Lóva'ea hoa renondehava Sodoma hugwi. Sodomapeva'ea i'ui'ui jipi gworygworyvamo. Mbatera ahe ipyhygi itambere'ia pyvõ aerẽ imondovo mbatera itambere'ia rehe. Ko pe ahe itymi. Onga ahe japoi. Nahã Sodomapeva'ea rekoi okovo ikwahave'yma ombokajag̃wama. ");
INSERT INTO pahNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Lóva'ea hemame cidade hugwi Sodoma hugwi ogwovo Tupana'ga imbohirukari yvaga hugwi tata enxofre reheve ojapy'uva'ea reheve Sodomapeva'ea rehe ahe jukapavuka. ");
INSERT INTO pahNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","—Na jitehe po ti yvyakotyve'g̃a ndekoi okovo ikwahave'yma jirura'javag̃wama nehẽ, ei Jesus'ga yvyakotyva'ero yvagipeva'ero no. ");
INSERT INTO pahNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","—Ji jipiukarame ti ga tokiyme g̃wonga pype ombatera renoheme'yma jugwi – kiroki ga oko ongapereuhua arimo. Na jitehe ti ga tohoa'javyme g̃wonga pe nehẽ – kiroki ga oko ko pe ji jipiukarame nehẽ, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Tapemoka'nhymi ti Lóva'ea rembirekova'ea! Ohoa'ja pota ahe g̃wonga pe omanomo, ei Jesus'ga imombe'gwovo. ");
INSERT INTO pahNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Kiroki g̃a e'i: “Ndakoi ti ji Jesus'ga remimbo'eharamo tajijukayme ti javo” – a'ero po ti g̃a manoi ogwovo hahyva'ea ruvihava pype nehẽ, ei Jesus'ga. Kiroki g̃a ojipe'g̃a g̃a jukai g̃a jikoga g̃waramo ji rehe – omanorẽ po ti g̃a oho upa avuirama Tupana'ga pyri nehẽ, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","—A'e ji pe me, ei Jesus'ga. Ji rura'javame po ti mokonha'g̃a kiri onhinongava rehe ypytunimo. Ojipeji g̃anhinongava. Kiro po ti ojipe'ga rerohohava nehẽ. Kiro po ti ojipe'ga rejahava nehẽ, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Kunhangwera'g̃a mokonha'g̃a po ti ombo'i ombo'ihava pyvõ ojopyri. Kiro po ti ojipehẽa rerohohava nehẽ. Kiro po ti ojipehẽa rejahava nehẽ, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Mokonha'g̃a po ti oko ko pe akwaimbae'g̃a nehẽ. Kiro po ti ojipe'ga rerohohava nehẽ. Kiro po ti ojipe'ga rejahava nehẽ, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","A'ero Jesus'ga remimbo'ehara'g̃a ei ga pe: —Nhandepojykaharetero emombe'u ti ore ve. Mome po ti nanongara nehẽ? A'ero Jesus'ga ei g̃a pe: —Jukwaha po ti nehẽ. Ahe manorame po ti huruvua onhimongy ahera'oa pyri nehẽ ti'u javo. A'ea Jesus'ga ei na jitehe po ti jukwaha ji rura'javame nehẽ javo. ");
INSERT INTO pahNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Kiro Jesus'ga imombe'ui ojo'java'ea g̃a pe. A'ea pyvõ ga g̃a mbo'ei g̃anhi'ig̃a rehe Tupana'ga pe tapenhi'ĩ jipi pejikweraje'ymamo javo g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","G̃a mbo'eavo hehe ga ei: —Juiz'ga oko cidade pype upa. Ndokoi ga Tupana'ga nhi'ig̃a rupi okyhyjie'yma ga hugwi. Ndojirovagi ga akwaimbae'g̃a koty no okyhyjie'yma g̃a hugwi. ");
INSERT INTO pahNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Aherembirekokwerahẽa oko akoja pype cidade pype upa no. Uhuuhura'ja hẽa juiz'ga pyri jipi ja'javo ga pe: “Ji repy ti ga rehe. A'ereki ga ite'varuhu ji ve,” ei hẽa juiz'ga pe jipi. ");
INSERT INTO pahNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","—Ndohepypotari ga hẽa. Ga ndopokona'ẽi hẽa. Aerẽ reki ga ei oyvyteri pe: “Ndakyhyji ji Tupana'ga hugwi akwaimbae'g̃a hugwi no g̃a mbopogwee'yma. Jikyhyjiavo g̃waramo rũi po ti ji aherembirekokwerahẽa pokogi nehẽ. ");
INSERT INTO pahNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Nhimbokweraja g̃waramo po ti ji hẽa pokogi nehẽ. Po ti ji ndahepygi hẽa nehẽ, a'ero po ti hẽa ji mohe'ouhũ u'ua ji pyri nehẽ. Kiro po ti ji hẽa repygi a'ero,” ei ga oyvyteri pe, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","—Pejapyaka ti juiz'ga nhi'ig̃a rehe ndapyryvive'ga nhi'ig̃a rehe, ei Jesus'ga nhandepojykaharete'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Marã po ti Tupana'ga hekoi g̃wemimo'ẽhara'g̃a nderekovo nehẽ? Gwepy po ti ga g̃a naerũ? – kiroki g̃a onhi'ĩ hete ga pe arimo ypytunimo no ore poko ti javo. Marãi pe? Mbegwe po ti ga g̃a pokoga nehẽ naerũ? Marãi pe? ");
INSERT INTO pahNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","A'e ji pe me: Ga kaitu g̃a pokogi kotihĩ nehẽ ji mbuhura'java avo yvya koty nehẽ. Ji rura'javame mara'ngu po ti yvyakotyve'g̃a ojikoga ji rehe nehẽ? ei Jesus'ga yvyakotyva'ero yvagipeva'ero no. ");
INSERT INTO pahNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Kiro Jesus'ga imombe'ui ojipea ojo'java'ea jara'g̃a pe – kiroki g̃a e'i oyvyteri pe: “Orepyry hete ore. Ojipe'g̃a tiruahumba.” A'ea g̃a ei ojirovage'yma g̃a koty. G̃a pe Jesus'ga ei pehe po ti ji pe mombe'ui kiro javo. ");
INSERT INTO pahNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","—Mokonha'g̃a oho ojatykahavuhua pype templo pype xanhi'ĩ ti Tupana'ga pe javo. Ojipe'ga ko fariseu'ga. Ojipe'ga ko itambere'ia mono'õhara'ga, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","—Fariseu'ga o'ã onhi'ig̃a oyvyteri pe. “Tupana,” ei ga Tupana'ga pe. “Jiroryrory ji nde rehe. A'ereki nde ji mongo ojipe'g̃ahoheva'ero. Nurã g̃a ja rũi ji rekoi. A'ereki g̃ahã ahe moandyandyi ipyhyga g̃ambatera. Ndapyryvi g̃a. Gwereko g̃a ojipe'g̃a nembireko'g̃a. Avove'ga ja rũi itambere'ia mono'õhara'ga ja rũi ji rekoi nohõ. ");
INSERT INTO pahNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","A'u ji cinco jikira rupi. Dois jikira rupi ji nda'ui tanhi'ĩ Tupana'ga pe javo. Nahã ji rekoi jipi. Amondo ji nde ve nhimbatera jipi. Ji herekorame dez mbatera ji amondo nde ve ojipeji,” ei fariseu'ga, ei Jesus'ga ga mombe'gwovo g̃a mbo'eavo. ");
INSERT INTO pahNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","—Itambere'ia mono'õhara'ga ki a'e te irupe ga o'ã ojipe'g̃a hugwi. Ndojovavuri ga hepiage'yma yvaga koty. Onupanupã ga opoti'a opoa pyvõ ovy'are'yma g̃waramo. Tupana'ga pe ga ei: “Tupana, ako te'varuhu ji. Terenhimonha'ngai ji rehe. Ji porogwety kiro!” ei itambere'ia mono'õhara'ga Tupana'ga pe, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","—A'e katu ji pe me, ei Jesus'ga. Itambere'ia mono'õhara'ga hugwi Tupana'ga imombori garekote'varuhua. A'ero ga jivyrame g̃wonga pe Tupana'ga ei ga mombe'gwovo: “Pyry kiro itambere'ia mono'õhara'ga.” —Ojipe'ga pe fariseu'ga pe Tupana'ga nde'i: “Ndepyry nde.” A'ea rũi Tupana'ga ei. Kiroki ga e'i jihi ko huvihavamo ojipe'g̃a hohe pa javo – po ga ei a'ea onhimboheteavo onhimongovo aha huvihavamo, a'ero po ti Tupana'ga ei ga pe nehẽ: “Nderekoi nde huvihavamo. Nerenhimbohetei po nde hamo a'ero.” A'ea po ti Tupana'ga ei ga pe nehẽ, ei Jesus'ga. —Po ga nonhimbohetei ojipe'g̃a nderekokatuavo, a'ero po ti Tupana'ga ei ga pe nehẽ: “Eko ti huvihavamo.” A'ea po ti Tupana'ga ei ga pe nehẽ, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Aerẽ tayri'g̃a no, ojipe'g̃a g̃a nderuri Jesus'ga pyri topoko ti ga g̃a ndehe imombyryva g̃a pe javo. Tayri'g̃a nderura repiagame Jesus'ga remimbo'ehara'g̃a ei g̃a pe: —Taperuri tayri'g̃a Jesus'ga pyri, ei g̃a. ");
INSERT INTO pahNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Jesus'ga ki a'e te e'i: —Tuhu tuhẽ ti tayri'g̃a ji pyri, ei ga. Tapemombigi ti g̃andura. A'ereki Tupana'ga pyry hete nanongara'g̃a'jave'g̃a pe okovo g̃anduvihavuhuhetero g̃a jikogame ojihe, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Imombe'ukatuavo ji ei pe me: Tayri'g̃a ojiko uva'g̃a ndehe okovo g̃anemimbotarimova'ea rehe. Kiroki g̃a oko tayri'g̃a ja rũi – g̃a ndojikogi Tupana'ga rehe okoe'yma garemimbotarimova'ea rehe. G̃a po ti nomongoi Tupana'ga gwuvihavuhuhetero a'ero nehẽ, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","A'ero huvihava'ga ei Jesus'ga pe ombo'ehara'ga pe: —Marãva'ea rupi pyryva'ea rupi po ti ji rekoi nehẽ jirekoag̃wamamo Tupana'ga pyri avuirama nehẽ? ei ga Jesus'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","A'ero Jesus'ga ei ga pe: —Maraname nde ei pyryva'ea rehe? Tupana'ga nhi'ig̃a jate ko pyry, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Erekwaha ko nde Tupana'ga remimbo'eukaragwera Moisésva'ea pe ymyahũ. Ga e'i ahe ve: “Tererekoi ti ojipe'g̃a nembireko'g̃a. Terejukai ti ojipe'g̃a. Teremimi ti ojipe'g̃a hugwi. Tane'mbei ti ojipe'g̃a mombe'gwovo tehe. Emondo ti ejeaporog̃ita imohina ejuva'ga rehe eyhẽa rehe no,” ei Tupana'ga, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","A'ero ga ei Jesus'ga pe: —Jivoja'irame ji hendukatupavi Moisésva'ea remimbo'eagwera. Kiro ji heronhimomboakari ahendu katu ve ji, ei ga. ");
INSERT INTO pahNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Ga renduvame Jesus'ga ei ga pe: —Ojipeji rehe nderehygi ve Tupana'ga remimbotarimova'ea rehe. Emondo pa ti embatera itambere'ia pyhyga. Kirẽ ti ema'ẽ eitambere'ia imbatere'ỹve'g̃a pe, ei Jesus'ga. A'ero po ti Tupana'ga imombyryvi nde ve yvagi pe nehẽ, ei Jesus'ga. Nurã ji ei nde ve: Emondo pa ti eitambere'ia kiro. Imondopavirẽ ti ejo ji rupi ekovo nhiremimbo'eharamo ejikoga ji rehe jate, ei Jesus'ga ga pe. ");
INSERT INTO pahNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Jesus'ga renduvame ga ndovy'ahetei. A'ereki ga nomondopapotari ombatehetero g̃waramo. ");
INSERT INTO pahNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Gavy'are'yma repiaga Jesus'ga ei: —Hahy imbateve'g̃a pe g̃a erame Tupana'ga pe eko ti oreruvihavuhuhetero javo. Po g̃a nde'ipotari te a'ea. Ndokopotari g̃a garemimbo'ea rupi okoheteavo ombatera rehe, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Tegwete yuranuhũa'javuhuva'ea hohava camelo hohava agulha kwa'ria rupi. Tegwete hete imbateheteve'g̃a hohava Tupana'ga nhi'ig̃a rupi okoheterame ombatera rehe. Nurã po ti g̃a ndojikogi ga rehe, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","A'ero garenduve'g̃a ei: —Ma'g̃a po ti oho Tupana'ga pyri yvagi pe nehẽ naerũ? ");
INSERT INTO pahNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","A'ero Jesus'ga ei: —Na tuhẽ yvyakotyve'g̃a nonhimondoi yvagi pe. A'ereki tegwete g̃a pe. Tupana'ga pe reki nonhimimi. A'ereki ga g̃a mbojiko ojihe g̃a mbuhuruka ojipyri, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","A'ero Pedro'ga ei Jesus'ga pe: —Ji rendu ti, ei ga. Ore oropohi pa ore orombatera hugwi orojikovo neremimbo'eharamo. ");
INSERT INTO pahNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","A'ero Jesus'ga ei g̃a pe: —Imombe'ukatuavo ji ei pe me pe'jave'g̃a pe no – kiroki g̃a pe ja opohi ombatera hugwi gwe'yja'g̃a hugwi no xako ti Tupana'ga remimbotarimova'ea rupi javo. A'e ji: Pyry hete po ti ga pe nehẽ – kiroki ga opohi g̃wonga hugwi, gwuva'ga hugwi, oyhẽa hugwi, oirũ'g̃a hugwi, g̃wembirekohẽa hugwi, gwa'yra'g̃a hugwi. ");
INSERT INTO pahNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","Po ga opohi pa g̃wonga hugwi g̃a hugwi no taho ti Jesus'ga rupi javo, a'ero ag̃wamo koji'i Tupana'ga imombyryhetei ga pe nehẽ. Aerẽ po ti Tupana'ga ga mongoi ojipyri ga mombytavo avuirama nehẽ, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Kiro Jesus'ga dozeve'g̃a nderohoi irupe'i jara'g̃a hugwi. Dozeve'g̃a pe ga ei a'ero: —Ji rendu ti. Kiro nhande hoi cidade de Jerusalém me. A'ero ihoi Tupana'ga nhi'ig̃a mombe'uharava'ea rembikwatijapava rupi – kiroki a'ea ji mombe'u, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Aerẽ Jerusalém me po ti nhimondoukahava judeus'g̃arũive'g̃a pe nehẽ. A'ero po ti g̃a ji rerekomemui okote'varuhuavo ji ve onyvuna ji rehe nehẽ. ");
INSERT INTO pahNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Ipira apopyra pyvõ po ti g̃a ji nupanupãi ji mondohondohoga nehẽ. Kirẽ po ti g̃a ji jukai nehẽ. Ko'emameva'ea py'rovo mokõi jikira py'rovo po ti ji kweravi nehẽ yvyakotyva'ero yvagipeva'ero no, ei Jesus'ga dozeve'g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Dozeve'g̃a nombaragwahavi ganhimombe'ua rehe reki. A'ereki onhimiva'ea g̃a pe. Oyvyteri pe g̃a ei: —Marã ga'ea? Maraname ga ei na onhimombe'gwovo? ei g̃a. ");
INSERT INTO pahNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Aerẽ Jesus'ga hogahoi. Kiro ga vahemi g̃werĩ cidade de Jericó pe. Pevo heakwagweve'ga apygi pehea rembeyvyri pe oporanduva itambere'ia rehe. ");
INSERT INTO pahNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","G̃wendu ga he'yive'g̃a kwavame onhipyvõ onhimongyavo. A'ero ga ei: —Maraname g̃a kwag̃akwavi? ");
INSERT INTO pahNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","A'ero g̃a ei ga pe: —Jesus'ga kwavi kiro Nazarépeve'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","A'ero ga onhi'ig̃a mondoi tanhirendu ti Jesus'ga javo. —Jesus! Nde ko Daviva'ea rymyminoro! ei ga. Nahã ga ei Jesus'ga pe. A'ereki ga e'i oyvyteri pe: “Jesus'ga pe Tupana'ga e'i eko ti g̃anduvihavuhuhetero javo.” —Ji poko ti! ei ga Jesus'ga pe. A'ea ga ei tanhimboheakwa katu ti ga opopoakara pyvõ javo. ");
INSERT INTO pahNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","A'ero tenondeve'g̃a ei ga pe: —Epi! ei g̃a ga pe tonhi'imbi ga javo. Koji'i ga onhi'ig̃a mondoi reki. —Daviva'ea rymyminoro ji poko ti! ei ga Jesus'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","A'ero Jesus'ga pytai ga reruruka ojipyri. Ga rurame Jesus'ga ei ga pe: ");
INSERT INTO pahNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","—Marã po ti ji nde rerekoi nehẽ? Gara nde erepota? A'ero ga ei: —Ji mboheakwa katu jipojykaharetero, ei ga. ");
INSERT INTO pahNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","—Ehepia ti a'ero! ei Jesus'ga ga pe. Erejiko nde ji rehe. Nurã nde reakwakaturo kiro, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Kotihĩ hete ga hepiagi a'ero. Ogwovo Jesus'ga rupi ga Tupana'ga mbohetei. —Ndepyry hete nde ji ve, ei ga Tupana'ga pe. Pevove'g̃a na jitehe g̃a ei gareakwakatua repiagame: —Ndepyry hete nde ga mboheakwakatuavo! ei g̃a Tupana'ga pe onhimongyavo. ");
INSERT INTO pahNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Kiro Jesus'ga hoi ovahema cidade de Jericó pype ogwovo mbytera rupi. ");
INSERT INTO pahNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Pevo Zaqueu'ga ruvi itambere'ia mono'õhara'g̃a nduvihava'ga. Imbate hete ko ga. ");
INSERT INTO pahNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ga Jesus'ga repia pota. “Marã po ga rekoi?” ei ga oyvyteri pe. Zaqueu'ga yvyive. Nurã ga ndohepiagi Jesus'ga he'yive'g̃a ga mbotyvahivame. ");
INSERT INTO pahNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Nurã ga nhani g̃a pyvõ okwava ogwovo g̃a nenonde ojiupia i'yva rehe amoreira rehe. “Avo hugwi po ti ji Jesus'ga repiagi nehẽ,” ei ga oyvyteri pe. A'ereki Jesus'ga okwa g̃werĩ i'yva pyvõ. ");
INSERT INTO pahNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Ovahemame Jesus'ga rovavuri Zaqueu'ga koty ga repiaga javo ga pe: —Zaqueu! Haite! Ejy! Ag̃wamo ji tapyta neronga pype, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Kotihĩ ga jyvi i'yva hugwi a'ero gworygworyvamo Jesus'ga rehe ga rerogwovo g̃wonga pype. ");
INSERT INTO pahNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","A'ea ojipe'g̃a ndopotaruhui onhimongyavo. A'ero g̃a ei: —Maranameuhũ okote'varuhuve'ga ronga pype Jesus'ga oki opytapota pevo? ");
INSERT INTO pahNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Aerẽ Zaqueu'ga ami onhi'ig̃a nhandepojykaharete'ga pe Jesus'ga pe. —Ji rendu jipojykaharetero, ei ga Jesus'ga pe. Ambohovaja ti nhimbatepava imondovo hovajara imbatere'ỹve'g̃a pe nehẽ. Ji ojipe'g̃a moandyandyi ipyhygahyavo g̃a hugwi ikwehe. Kiro po ti ji imondoa'javi g̃a pe a'ero nehẽ. Po ojipeji mbatera ji apyhygahy g̃a hugwi, a'ero po ti ji imondoi quatro g̃a pe nehẽ. Nahã po ti ji imondoa'javi koji'i hete g̃a pe nehẽ, ei ga Jesus'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","—Zaqueu, ei Jesus'ga ga pe. Ag̃wamo pe pejiko ji rehe, ndehe nenongapypeve'g̃a pavẽi, imomboruka ji ve pejikote'varuhua pe hugwi. Orombojikoguka ji jijihe. A'ereki nde ko Abraãova'ea rakykwepohara no, ei Jesus'ga Zaqueu'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","A'ereki ji ajo yvya koty taheka ti ji yvyakotyve'g̃a imomboa g̃andekote'varuhua g̃a hugwi g̃a mbojikoguka jijihe javo. Kiroki g̃a ndogwerekoi gwepiakatuhara'g̃a oka'nhyve'g̃a ja – g̃andekote'varuhua ti ji tamombo, a'e ji jijoa yvyakotyva'ero yvagipeva'ero no, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","G̃a g̃wenduvame ga imombe'ui ojo'java'ea. A'ereki ga uhu g̃werĩ Jerusalém me. Omombe'u katu ga g̃a pe. A'ereki g̃a e'i oyvyteri pe: “Nambegwei po ti Tupana'ga oko yvyakotyve'g̃a nduvihavuhuhetero Jerusalém me ore pyri nehẽ,” ei g̃a hepiapota. ");
INSERT INTO pahNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Nurã Jesus'ga ei g̃a pe: —Marã po ti hekoi yvyakotyve'g̃a pe g̃a erame Tupana'ga nhanderuvihavuhuhetero oko javo? A'ea rehe po ti ji pe mbo'ei ikwahavuka pe me imombe'gwovo a'ea'java'ea, ei Jesus'ga. Huvihava'ga hoi paivouhu ojipe'g̃a gwyri pe. A'ereki ga e'i: “Pevove'ga huvihavuhu'ga ti te'i ji ve eko ti kiro ejigwyripeve'g̃a nduvihavuhuro javo,” ei ga. ");
INSERT INTO pahNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","—Ohoa renonde ga g̃a mbuhurukari ojipyri dezve'g̃a ojipyrive'g̃a. G̃a pe ga imondomondoi ojipeji itambere'ia g̃a ndetakwera'ja tombohe'yjuhu ti g̃a ji ve javo. A'ero ga ei g̃a pe: “Pepyhypyhy ti mbatera nhiitambere'ia pyvõ. Aerẽ ti pema'ema'ẽ mbatera itambere'ia pyhyga koji'iva'ea. Nahanahã ti peporavyky nhiitambere'ia pyvõ koji'iva'ea imono'ono'og̃a aerẽ imbuhua ji ve,” ei ga g̃a pe. —Kiro ga hoi g̃a hugwi a'ero ogwovo paivouhu ojipe'g̃a gwyri pe, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","—Gagwyripeve'g̃a noarõhetei ga. Nurã g̃a ei: “Tokoyme ti ga oreruvihavuhuro. Jararamo nhande xaho ga reviri javo a'ea huvihavuhu'ga pe,” ei g̃a. A'ero paivouhu g̃a hoi ovahema imombe'gwovo huvihavuhu'ga pe novĩa. ");
INSERT INTO pahNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","A'ereki ga e'i jipe ga pe eko ti g̃anduvihavuhuro javo. —A'ero g̃anduvihavuhuro ga jivyri paivouhua hugwi ua ogwyri pe. Ovahemame kiro ga ojipyrive'g̃a mbuhurukari ojipyri – kiroki g̃a pe ga omondo ojipeji oitambere'ia. A'ereki ga e'i oyvyteri pe: “Maramomi kiro nhiitambere'ia g̃a imbohe'yjuhurame? Koji'iva'ea po g̃a ipyhygi ji ve jirakykweri,” ei ga oyvyteri pe, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","—Kiro gapyrive'ga ruri ga pyri javo ga pe: “Jipojykaharetero nde erembuhu ji ve ojipeji itambere'ia ikwehe'i. Ikwepygame ji ipyhygi dez,” ei ga. ");
INSERT INTO pahNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","—A'ero ga ei ojipyrive'ga pe: “Ereporavyky katu nde! Ndepyry nde eporavykykatuavo ji ve. Ojipeji te nde erembohe'yjuhu ji ve. Pevo ko dez cidades teni. Akojapeve'g̃a nduvihavamo ti eko kiro,” ei ga ojipyrive'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","—Kiro ojipe'ga gapyrive'ga ruri ga pyri javo ga pe: “Jipojykaharetero nde erembuhu ji ve ojipeji itambere'ia ikwehe'i. Ikwepygame ji ipyhygi cinco,” ei ga. ");
INSERT INTO pahNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","—A'ero ga ei ojipyrive'ga pe: —“Kwa. Pevo ko cinco cidades teni. Akojapeve'g̃a nduvihavamo ti eko kiro,” ei ga ojipyrive'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","—Kiro ojipe'ga gapyrive'ga ruri ga pyri javo ga pe: “Jipojykaharetero nde erembuhu ji ve ojipeji itambere'ia ikwehe'i. Ehepia neitambere'ia – akoja jitehe!” ei ga opojykahara'ga pe. “Auvã ji neitambere'ia tapy'ynhapira pyvõ hepiakatuavo. ");
INSERT INTO pahNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","A'ereki ji akyhyji nde hugwi. A'ereki nde netiruahũ. Nde ndereporavykyi. Emo nde erepyhy ojipe'g̃a hugwi ejive. Nde neretymi. Emo nde eremondoro ojipe'g̃a nemitymipyra ejive,” ei ga opojykahara'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","—A'ero ga ei ojipyrive'ga pe: “Ereko te'varuhu nde! Oja nde rehe nde ero g̃waramo ji ve. Nde tuhẽ ere ji ve: ‘Netiruahũ nde ipyhyga ejive eporavykye'yma. Nde neretymi. Emo nde eremondoro ojipe'g̃a nemitymipyra ejive.’ Nahã nde ei ji ve. Nde ji kwahavipe ji imondorame nhiitambere'ia nde ve embohe'yi ti javo. ");
INSERT INTO pahNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Maraname nde neremondoi nhiitambere'ia ikwepykara'g̃a pe banco pype? A'ero imbuhu'rag̃irẽ ojipe'g̃a pe po g̃a ombuhu koji'iva'ea nde ve ramo. Nahã po nde herekoi nhiitambere'ia jirakykweri ramo. A'ero jirura'javame po ji ipyhyga'javi nde hugwi nhiitambere'ia koji'iva'ea reheve ramo,” ei ga ojipyrive'ga pe, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","—G̃a pe – kiroki g̃a o'ã ga pyri – g̃a pe ga ei: “Pepyhy nhiitambere'ia ga hugwi imondovo akoja'ga pe – kiroki ga ombohe'yi nhiitambere'ia nahã herekovo dez itambere'ia,” ei gapojykahara'ga, ei Jesus'ga. Kiro Jesus'ga renduve'g̃a ei Jesus'ga pe: ");
INSERT INTO pahNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","—Tere'ei na orepojykaharetero. Gwereko jipe ga dez itambere'ia. ");
INSERT INTO pahNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","A'ero Jesus'ga ei g̃a pe: —A'e ji pe me: Kiroki ga gwereko a'ea pyvõ oporavykypota ji ve – ga pe po ti ji koji'iva'ea imondoi toporavyky ti ga a'ea pyvõ javo, ei Jesus'ga. Kiroki ga ndogwerekoi gwerevi oporavykypotare'yma – aru po ti ji ga hugwi a'ero toporavykya'javyme ti ga ji ve javo, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","—Nurã g̃apojykahara'ga ei javo ojipyrive'g̃a pe, ei Jesus'ga. Koji'iva'ea ga ei javo: “Nhiarõe'ỹve'g̃a – kiroki g̃a ndopotari tokoyme ti ga nhanderuvihavuhuro javo ji ve – peho ti g̃a nderua avo g̃a jukavo jirovai pyteri pe,” ei ga, ei Jesus'ga. A'ea Jesus'ga imombe'ui g̃a pe ojo'java'ea. ");
INSERT INTO pahNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Imombe'urẽ ga hoi g̃a nenonde taho ji Jerusalém me javo. ");
INSERT INTO pahNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Ogwovo ga vahemi cidades'ia kotyi ve. Mokõi cidades'ia teni pevo. Ojipea ko Betfagé. Ojipea ko Betânia. Ohĩ cidades'ia yvytyra rembeyvyri pe monte das Oliveiras rembeyvyri pe. Kiro ga ei mokonha'g̃a pe g̃wemimbo'ehara'g̃a pe g̃a mondouka. ");
INSERT INTO pahNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","—Peho ti cidade'i pe pendovai pyteripeva'e pe, ei Jesus'ga. Pevahemame po ti pe hepiagi yuhua'javuhuva'ea ra'yra jumentinho nehẽ. Ojugwa g̃a imo'ama yva rehe pevo. Ahe ndohoi ve i'arimo. Pekwahara ti herua avo. ");
INSERT INTO pahNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Po ti g̃a ei pe me nehẽ: “Maraname pe ikwaharavi?” Po g̃a ei na, a'ero ti pe'ji g̃a pe: “Gaha – kiroki ga pe nhande ei nhandepojykaharete'ga – gaha e'i: ‘Tareko'ã ti ji taho ti ji i'arimo javo’.” Nahã ti pe'ji g̃a pe imbuhuruka, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","—Kwa, ei g̃a. Ogwovo g̃a vahemi hepiapava garemimombe'ua. ");
INSERT INTO pahNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","G̃a jumentinho kwaharavame ijara'g̃a g̃a ndepiagi. A'ero ijara'g̃a ei: —Maraname pe ikwaharavi ta'yra? ");
INSERT INTO pahNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","A'ero g̃a ei: —Gaha – kiroki ga pe nhande ei nhandepojykaharete'ga – gaha e'i: “Tareko'ã ti ji taho ti ji i'arimo javo.” —Kwa, ei g̃a. ");
INSERT INTO pahNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Jesus'ga pe g̃a heruri a'ero herovahema. Oapoa tapy'ynhapira i'arimova'ea g̃a heropori inog̃a ikupepytera rehe eho i'arimo javo Jesus'ga pe. A'ero ga hoi i'arimo. ");
INSERT INTO pahNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Kiro ta'yra ga rerohoi pea rupi. Ga rerohorame g̃a heroporopori opira i'arimova'ea pea rupi imbokatuavo pehea ga pe. Nahã g̃a Jesus'ga mbojiroviari ga rerua nhanderuvihavuhuhete'ga kiro u javo. ");
INSERT INTO pahNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Nahã Jesus'ga rerohoi pea rupi ga rerogwovo yvytyra hugwi ga rerojyva g̃werĩ monte das Oliveiras hugwi. Nahã ga rerovahemi g̃werĩ Jerusalém me. A'ea rupi garemimbo'ehara'g̃a ndoryndoryvamo Tupana'ga mboheteavo he'yjuhuve'g̃a. Hahyahi hete g̃anhi'ig̃a g̃a erame ga mboheteavo garemimonhimomby'aheteva'ea rehe nhaporemo gapopoakara rehe g̃wembiepiaga rehe nhaporemo. ");
INSERT INTO pahNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","G̃a e'i: —“Ga pe ti nhandepojykaharete'ga tomombyry! A'ereki nhandepojykaharete'ga ga mbuhuruka avo eko ti g̃anduvihavuhuhetero javo ga pe,” ei g̃a. “U katu yvagipeve'ga py'a ga rehe. Timbohete ti Tupana'ga yvagipeheteve'ga!” ei g̃a. ");
INSERT INTO pahNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","He'yive'g̃a pyteri pe fariseus'g̃a oko. Ndopotari jara'g̃a Jesus'ga remimbo'ehara'g̃a erame Jesus'ga mboheteavo. Nurã g̃a ei Jesus'ga pe: —Ahembo'eharamo emombi ti neremimbo'ehara'g̃a, ei fariseus'g̃a. ");
INSERT INTO pahNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","A'ero Jesus'ga ei fariseus'g̃a pe: —A'e ji pe me: Po g̃a ji mbohetepigi jave'yma, a'ero hahyahi po ti ita nhi'ig̃a a'ea tuhẽ i'erame ji mboheteavo nehẽ, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Kiro Jesus'ga vahẽg̃werĩ cidade de Jerusalém me. Hepiagame ga jehe'oi hehe ipypeve'g̃a ndehe no. ");
INSERT INTO pahNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Ojehe'gwovo ga ei: —Jerusalémmeva'ero po ag̃wamo vehevi pe pemongiuka Tupana'ga nhi'ig̃a pejipype ramo nahã imbaragwahava pepy'a nog̃atua rehe ramo. A'ea ji apota novĩa. Emo pe napehendukatui. A'ero kiro pepy'a nog̃atua onhimiva'ea pe me, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","—Aerẽ po ti pearõe'ỹve'g̃a pecidade apẽi yja japovo hovapiaramo pecidade rekihyma nehẽ. Nahã po ti g̃a pe atimani pe mohemukare'yma jugwi otavuka pe me nehẽ, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","A'ero po ti g̃a imondurupavi pecidade pe moka'nhymbava ipype nehẽ. Ndojikojikoga'javi ita ojogwehe penonga rehe ita apopyra rehe. Tupana'ga ji mbuhuruka pe pyri emombo ti g̃andekote'varuhua g̃a hugwi javo. Emo pe napemomborukari ji ve pejikote'varuhua pemongiukare'yma Tupana'ga nhi'ig̃a pejipype penhimombaragwahapotare'yma pepy'a nog̃atupotara rehe. Nurã po ti ga pe moka'nhymbavukari g̃a pe nehẽ, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Kiro Jesus'ga hoi oje'yja'g̃a jatykahavuhu pe Tupana'ga mbohetehai pe ovahema. Pevo okara hugwi mytu'ẽva'ea hugwi ga g̃a mo'embavi ima'ẽhara'g̃a ipyhyhara'g̃a ndeheve – kiroki g̃a oma'ẽ mbatera ipyhyga pevo ojatykahavuhua pyri. ");
INSERT INTO pahNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","G̃a pe ga ei: —Ymyahũ Tupana'ga ei ikwatijaruka hako: “Tonhi'ĩ ti g̃a ji ve nhironga pype yvya koty ji mboheteavo,” ei Tupana'ga hako, ei Jesus'ga g̃a pe. —Pe ki a'e te pe'ji pejohupe: “Timoandyandyjuhu ti g̃a ikwepykwepyga mbatera pyvõ Tupana'ga ronga pype,” pe'ji pe, ei Jesus'ga. Nahã pe Tupana'ga ronga mongoukari iporomive'g̃a nduhavamo, ei Jesus'ga ikwepykara'g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Nane'ymi Jesus'ga judeus'g̃a mbo'embo'ei g̃ajatykahavuhua pype. Emo ikwava'ẽhara'g̃a nduvihava'g̃a ojuka pota Jesus'ga judeus'g̃a mbo'ehara'g̃a pavẽi huvihava'g̃a pavẽi no. ");
INSERT INTO pahNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","—Maramarã po ti nhande ga jukai nehẽ? ei g̃a ojohupe. Ndohekatui g̃a gajukahava rehe. A'ereki pevove'g̃a g̃wendu pota hete Jesus'ga nhi'ig̃a ovy'aheteavo ga rehe onhimongyavo. ");
INSERT INTO pahNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Aerẽ Jesus'ga g̃a mbo'ei g̃ajatykahavuhua pype templo pype. Omombe'u katu ga g̃a pe pyryva'ea onhimombe'ua. Ga nhi'ig̃ame uhu ikwava'ẽhara'g̃a nduvihava'g̃a judeus'g̃a mbo'ehara'g̃a pavẽi xava'eve'g̃a pavẽi no. ");
INSERT INTO pahNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Jesus'ga pe g̃a ei: —Emombe'u ti ore ve. Ma'g̃a nde mbuhurukaruhu avo nahanahã ti eko javo? Ma'g̃a e'i a'ea nde ve? ei g̃a Jesus'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","A'ero Jesus'ga ei g̃a pe: —Ji nhi'ĩpondekwa ti imombe'gwovo ji ve. ");
INSERT INTO pahNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Ma'g̃a ombuhuruka João Batistava'ea? A'ero ga g̃a mobatiza okovo garemimbotarimova'ea rupi. “Tupana'ga yvagipeve'ga ombuhuruka ahe,” pe'ji po pe. “Yvyakotyve'ga ombuhuruka ahe,” pe'ji po pe. Marã pendeaporog̃ita a'ero naerũ? ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","A'ero g̃a eg̃a'ei ojohupe: —Po ti nhande ei: Tupana'ga ombuhuruka ahe, a'ero po ti Jesus'ga ei nhande ve nehẽ: “Maraname pe ndaperoviari João Batistava'ea nhi'ig̃agwera naerũ?” Nahã po ti Jesus'ga ei nhande ve nehẽ. ");
INSERT INTO pahNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Po ti nhande ei: Yvyakotyve'ga ombuhuruka João Batistava'ea, a'ero po ti nhandegwyripeve'g̃a henduvi nhanenhi'ig̃a imombomomboa ita nhande rehe nhande jukavo ipyvõ nehẽ. A'ereki nhandegwyripeve'g̃a e'i oyvyteri pe: “João Batistava'ea ko Tupana'ga nhi'ig̃a mombe'uharamo. Tupana'ga ahe mbuhuruka nhande pyri. A'iti a.” Nahã nhandegwyripeve'g̃a heroviari javo ahe ve oyvyteri pe, ei g̃a ojohupe. ");
INSERT INTO pahNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Nurã g̃a ei Jesus'ga pe: —Ma'g̃a po ombuhuruka João Batistava'ea? Ma'g̃a e'i ga pe, a'ero ga omobatiza g̃a? Ndorokwahavi, ei g̃a javo tehe ga pe. ");
INSERT INTO pahNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","A'ero Jesus'ga ei g̃a pe: —Ji po ti na jitehe namombe'ui ga pe me a'ero nehẽ – kiroki ga ji mbuhu avo ji rerekovo – gaha po ti ji namombe'ui pe me nehẽ, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","A'ero pevove'g̃a pe Jesus'ga imombe'ui ojo'java'ea. G̃a mbo'eavo ga ei: —Akwaimbae'ga itymi yhypoa'javuhuva'ea uva'yva ko pe, ei Jesus'ga. Aerẽ ga ei ojipe'g̃a pe: “Pehepia katu ti nhiremitymipyra jikohoa. A'ero jykyhava rupi he'yjuhu po ti yva'ia peapoaramo ikwepykavamo a'ero nehẽ. He'yjuhu po ti yva'ia jiapoaramo a'ero nehẽ no,” ei kohoa jara'ga g̃a pe. —“Pyry,” ei g̃a. A'ero g̃a pytai ko pe hepiakatuavo ga pe, ei Jesus'ga. —Paivohu kohoa jara'ga hoi a'ero mbaigwehu po ti jijivyra'java nehẽ javo, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","—Aerẽ kiro jykyhava reki, ei Jesus'ga. A'ero kohoa jara'ga ei ojipyrive'ga pe: “Eho ti g̃a pyri nhiremitymipyra repiakatuhara'g̃a pyri. Toyky ti g̃a yva'ia imbuhuruka jiapoa ji ve,” ei ga. —“Kwa,” ei ga. Ogwovo ga vahemi g̃a pyri imombe'gwovo ganhi'ig̃a g̃a pe. —Emo g̃a nomondopotari yva'ia ga pe ga nupanupamo ga mondovo ojihugwi. Gapojate oho g̃a hugwi a'ero. ");
INSERT INTO pahNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","—Aerẽ kohoa jara'ga ojipe'ga mondoi ojipyrive'ga togweru ti ga yva'ia g̃a hugwi javo novĩa. A'ero gapyrive'ga hoi. Ga vahemame pevo garemitymipyra repiakatuhara'g̃a ga nupanupãi ojigwaraita ga rehe ga mondovo ojihugwi. Gapojate oho g̃a hugwi a'ero. ");
INSERT INTO pahNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","—Aerẽ kohoa jara'ga ojipe'ga mondoi g̃a pyri novĩa ojipyrive'ga. Gapyrive'ga vahemame g̃a pyri g̃a ga kyti ga mu'umu'uma ga momboa. ");
INSERT INTO pahNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","—A'ero kohoa jara'ga ei: “Marã po ti ji nhiremitymipyra repiakatuhara'g̃a nderekoi? Amondo po ti ji jira'yra'ga g̃a pyri nhiremia'nguhete'ga nehẽ. Po ti g̃a ga rerekokatui imondovo ga pe ga repiagame nehẽ,” ei ga gwa'yra'ga mondovo novĩa. ");
INSERT INTO pahNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","—Ogwovo gara'yra'ga vahemi uva'ga remitymipyra repiakatuhara'g̃a pyri. Gara'yra'ga repiagame g̃a ei ojohupe: “Avova'ea ko gayvyag̃wama. Tijuka ti ga. A'ero po ti nhande tireko pa yvya nehẽ,” ei g̃a. ");
INSERT INTO pahNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","—A'ero g̃a gara'yra'ga mombori kohoa hugwi ga jukavo, ei Jesus'ga imombe'gwovo. Marã po ti kohoa jara'ga g̃a nderekoi a'ero nehẽ? ");
INSERT INTO pahNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Ovahẽ po ti ga onhimitymipyra repiakatuhara'g̃a moka'nhymbava gwa'yra'ga repyga nehẽ. A'ero ga ojipe'g̃a mongoi g̃wemitymipyra repiakatuharamo, ei Jesus'ga. Jesus'ga nhi'ig̃a renduvame pevove'g̃a ei: —Po ti na rũi nehẽ hamo! ");
INSERT INTO pahNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","G̃a ndepiaheteavo Jesus'ga ei g̃a pe: —Nahã tuhẽ po ti nehẽ. Tupana'ga rembikwatijarukara e'i: “Onga apohara'g̃a japorame onga ita apopyra hepiagi ojipeji ita. A'ea g̃a imombori ipo'rue'yma tiruahũ javo jupe. Aerẽ akoja jitehe hekoi huvihavamo jara hohe opyryhetero onga pyhykatuavo.” A'ea ikwatijaripyra e'i, ei Jesus'ga oarõe'yma mombe'gwovo g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","—Kiroki g̃a o'a akoja rehe ita rehe – g̃ahã po ti onhika'mbika'mbi nehẽ, ei Jesus'ga. Po ti akoja ita ihiri g̃a ndehe nehẽ, a'ero po ti ita g̃a ka'mbika'mbigi g̃a mongu'iuhuavo nehẽ. A'ea Jesus'ga ei ikwahavuka oarõe'ỹve'g̃a mbote'vara. ");
INSERT INTO pahNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","A'ea rupi g̃a ei ojohupe Jesus'ga mombe'gwovo judeus'g̃a mbo'ehara'g̃a ikwava'ẽhara'g̃a nduvihava'g̃a pavẽi. Ga arõe'yma g̃a ei: —Jesus'ga nhande mombe'u o'ete'varuhuavo nhande ve imombe'urame ojo'java'ea peko akoja'g̃a ja javo nhande ve, ei g̃a. Nurã g̃a Jesus'ga pyhypotarahivi kiro. Emo g̃a okyhyji pevove'g̃a hugwi. A'ereki pevove'g̃a oarõ hete Jesus'ga onhimongyavo ga ko Tupana'ga nhi'ig̃a mombe'uhara'ga javo. ");
INSERT INTO pahNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Nurã g̃ambo'ehara'g̃a ikwava'ẽhara'g̃a nduvihava'g̃a pavẽi Jesus'ga rapekouhui okovo ganhi'ig̃a rerojijyi pota. Ojipe'g̃a pe g̃a enhimimi: —Peho ti Jesus'ga pyri ga renduva. Pekokatu'ã ti ga pyri tokwahavyme ti ga omoandyandyja. Po ti ga nomombe'ukatui a'itiheteva'ea, a'ero po ti ore ga mbotegwetei ga mondovo governador'ga pyri nehẽ. A'ero po ti ga ga pyhygukari ga rerekovo nehẽ, ei g̃a g̃a mondovouka Jesus'ga pyri. —Kwa, ei g̃a ogwovo. Ovahẽ g̃a Jesus'ga pyri. ");
INSERT INTO pahNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Kiro g̃a ei Jesus'ga pe: —Hupi hete nde eremombe'u orembo'eharamo. A'itituhẽva'ea rehe nde ore mbo'e. A'ea rehe jate nde rekoi ekyhyjie'yma ojipe'g̃a hugwi ekoe'yma huvihava'g̃a ndehe jate. Nderekoi nde embohetetehea rehe no. Tupana'ga remimbotarimova'ea rehe nde ore mbo'e katu, ei g̃a Jesus'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Marã ndereaporog̃ita? César'gareheve'g̃a e'i: “Pemondomondo ti itambere'ia César'ga pe nhanderuvihavuhu'ga pe ga imono'og̃ukarame,” ei g̃a. Mara'ngu po nde javo: “Timondo ti”? Mara'ngu po nde javo: “Timondoyme ti”? Marãi nde? ei g̃a Jesus'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Ojohupe g̃a ei: —“Tapemondoi ti César'ga pe,” e po ti ga nhande ve nehẽ hamo, ei g̃a ojohupe. A'ero po ti nhande ga'eagwera mombe'ui César'ga pe nehẽ. A'ero po ti César'ga onhimonha'nga ga rehe nehẽ, ei g̃a ojohupe. Jesus'ga ombaragwaha omoandyandyipotara rehe. Nurã ga ei g̃a pe: ");
INSERT INTO pahNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","—Pehepiuka ti ji ve itambere'ia moeda. A'ero g̃a hepiukari ga pe. A'ero ga ei: —Ma'g̃a ra'angava hehe? Ma'g̃a ndera g̃a okwatija inog̃a hehe? ei Jesus'ga. A'ero g̃a ei: —César'ga ra'angava. Garera tuhẽ g̃a okwatija inog̃a hehe. ");
INSERT INTO pahNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","A'ero Jesus'ga ei g̃a pe: —Pemondoa'ja ti César'ga rembiapoa ga pe a'ero. Tupana'ga rembiapoa ki a'e te pemondoa'ja Tupana'ga pe, ei Jesus'ga g̃a pe. Yvyakotyve'g̃a pe Jesus'ga ei Tupana'ga rembiapoa tonhimondo ti g̃a onhikwava'eg̃a ga pe javo. ");
INSERT INTO pahNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Hupi hete Jesus'ga imombe'ui tomondo ti g̃a César'ga pe javo. A'ero tegwete g̃a pe Jesus'ga moandyandyihava pevove'g̃a ga renduvame a'ero. Onhimomby'avo Jesus'ga nhi'ig̃a rehe g̃a nonhi'ig̃a'javi. ");
INSERT INTO pahNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Kiro saduceus'g̃a nduri Jesus'ga pyri. Saduceus'g̃a ndogweroviari omanove'g̃a mbogwerahava. Ua g̃a ei ojohupe: —Mara'ngu po ti Jesus'ga onhimbotegweteavouka nhande ve onhi'ig̃ame nehẽ? A'ea g̃a ei ojohupe ua ovahema Jesus'ga pyri. ");
INSERT INTO pahNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Nde ko orembo'eharamo javo, g̃a ei Jesus'ga pe: —Ymyahũ Moisésva'ea okwatija hako tokwaha ti g̃a javo. Aherembikwatijara e'i: “Po akwaimbae'ga irũ'ga manoi ta'yre'ymame g̃wembirekohẽa pe, a'ero ti ga tahembireko hẽa pavẽi. Ta'y ti ga hẽa pe nhiirũva'ea togwereko gwakykwepohara'g̃a javo.” A'ea Moisésva'ea ikwatijari hako, ei g̃a Jesus'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Kiro g̃a imombe'ui omanove'g̃a Jesus'ga pe. G̃a e'i: —Ymya seteva'ea onhoirũva'ea hako, ei g̃a Jesus'ga pe. Ojihuvypyva'ea rembirekoro kako. Ndata'yri ahe kunhangwerava'ea pe. Aerẽ akwaimba'eva'ea manoi. ");
INSERT INTO pahNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","A'ero aheakoindava rembirekoro aherembirekokwerava'ea pavẽi oirũva'ea py'rovo Moisésva'ea nhi'ĩpo'ruavo. Ndata'yri ahe aherembirekokwerava'ea pe. Aerẽ ahe manoi no. ");
INSERT INTO pahNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Na jitehe aheakoindava pe a'ero. Omano ahe ta'yre'yma aherembirekokwerava'ea pe, ei g̃a. Na jitehe jarava'ea onhoirũva'ea nhaporemo ahe rembirekoro aherembirekokwerava'ea pavẽi. Ndata'ypavi reki seteva'ea aherembirekokwerava'ea pe. Omanomba ahe kako. Nahã ahe rekoi ojopy'ropy'rovo. ");
INSERT INTO pahNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Aerẽ mbapavamo aherembirekokwerava'ea manoi kunhangwerava'ea kako, ei g̃a Jesus'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","—Marã po ti a'ero nehẽ? ei g̃a Jesus'ga pe. Omanove'g̃a mbogweravame po ti Tupana'ga seteva'ea mbogweravi kunhangwerava'ea reheve nehẽ. Ma'g̃a nembirekoro po kunhangwerava'ea rekoi nehẽ ahe kwerava'javame nehẽ? A'ereki seteva'ea onhoirũva'ea hembireko kunhangwerava'ea pavẽi, ei g̃a. Emombe'u ti ore ve. Marã po ti a'ero nehẽ? ei g̃a Jesus'ga pe. A'ea g̃a imombe'utehei heroviare'yma g̃waramo omanove'g̃a mbogwerahava. ");
INSERT INTO pahNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Kiro Jesus'ga ei g̃a pe: —Avo yvya koty akwaimbae'g̃a nembirekoro. Ojipe'g̃a kunhangwera'g̃a mohembirekoi no. ");
INSERT INTO pahNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Jara'g̃a pe po ti Tupana'ga ei nehẽ: “Jihi a'e pe me: Pepyry pe. A'ero po ti ji pe mbogweravi omanove'g̃a mbogwerahava rupi pe mombytavo ji pyri nehẽ.” Nahã po ti Tupana'ga ei g̃a pe nehẽ. G̃ahã kirẽ nahembirekoa'javi nehẽ akwaimbae'g̃a kunhangwera'g̃a no. ");
INSERT INTO pahNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Tegwete g̃amanoa'java no. A'ereki g̃a oko Tupana'gapyrive'g̃a ja yvagipeve'g̃a ja. Yvagi pe Tupana'gapyrive'g̃a oko omanoe'yma. Na jitehe po ti Tupana'ga remimbogwerave'g̃a nomanoa'javi nehẽ no. Tupana'ga ra'yramo g̃a ndekoi Tupana'ga remimbogwerava'ero g̃waramo, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","—Moisésva'ea vehevi imboukwahavi nhande ve ikwahavuka ahembogwerahava ikwatijarame i'yva mombe'ua ikaja pyteripeva'ea mombe'ua. A'ereki imombe'urame a'ea ahe okwatija javo: “Tupana'ga ei: ‘Jihi ko Tupanamo. Abraão'ga ji mbohete. Isaque'ga ji mbohete. Jacó'ga ji mbohete’.” A'ea Moisésva'ea okwatija Abraãova'ea manorẽ Isaqueva'ea manorẽ Jacóva'ea manorẽ. Ikwatijarame nahã Moisésva'ea ikwahavukari nhande ve g̃a okoji javo. ");
INSERT INTO pahNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","A'ereki Moisésva'ea nde'i: “Tupana'ga ei: ‘Abraãova'ea ji mbohete’.” A'ea rũi ahe e'i ikwatija. A'ereki Tupana'ga pe g̃a okoji. “Oko pa g̃a avuirama,” ei Tupana'ga ikwahava, ei Jesus'ga saduceus'g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Kiro judeus'g̃a mbo'ehara'g̃a ei Jesus'ga pe: —Ahembo'eharamo hupi hete nde nhi'ig̃i ahembogwerahava mombe'gwovo, ei g̃a Jesus'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","A'ero g̃a nhaporemo nde'ia'javag̃wami tuhẽ Jesus'ga pe maramarã jave'yma. A'ereki g̃a okyhyji ga hugwi ga okwaha pa javo. ");
INSERT INTO pahNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","A'ero Jesus'ga ei g̃a pe: —He'yive'g̃a ei: “Cristo'ga Tupana'ga remimbuhurukara'ga ko Daviva'ea rymyminoa.” A'ea g̃a ei, ei Jesus'ga. Maraname g̃a ei a'ea ga pe? ");
INSERT INTO pahNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","A'ereki ymyahũ Daviva'ea tuhẽ okwatija inog̃a livro de Salmos rehe. Ikwatijarame ahe ei hako: “Tupana'ga e'i jipojykaharete'ga pe: ‘Eapy na'ẽ ji pyri jijohukoty rũi ekovo huvihavamo epytavo. ");
INSERT INTO pahNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Tamongo ti ji nearõe'ỹve'g̃a neremimbotarimova'ea rehe nehẽ,’ ei Tupana'ga,” ei Daviva'ea ikwatija hako, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","A'ea Daviva'ea ei imombe'gwovo Cristo'ga ko jipojykaharetero oko javo. Ga ko Daviva'ea rymymino'ga jate rũi naerũ, ei Jesus'ga onhimombe'gwovo g̃a pe g̃a mbojapyakavo. ");
INSERT INTO pahNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Pevove'g̃a nhaporemo g̃wenduvame Jesus'ga ei g̃wemimbo'ehara'g̃a pe: ");
INSERT INTO pahNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","—Penhimboko'i ti. Tapekoi ti judeus'g̃a mbo'ehara'g̃a ja. A'ereki g̃a onhimboheteuhu. Omongi pota g̃a opipukuhua tianderepia ti g̃a nhande mboheteavo javo. Ikatuuhu g̃a pe ojipe'g̃a mbaragwahavame g̃a ndehe ima'ẽhai pe feira pe onhi'ig̃atuavo g̃a pe orembo'ehara javo g̃a pe. —Nhandejatykahava pype g̃a oapy nhanderuvihava'g̃a apykava rehe. A'ereki g̃a e'i oyvyteri pe: “Tianderepia pa ti g̃a nhande mboheteavo,” ei g̃a. “A'ereki nhande g̃anduvihavuhuhetero xako.” Na jitehe g̃a ei oyvyteri pe i'upota toryva jara'g̃a pyri toryva repiagame. ");
INSERT INTO pahNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","—Opojykaahy g̃a mbatera aherembirekokwera'g̃a hugwi, ei Jesus'ga. Onhi'imbukuhu tehe g̃a Tupana'ga pe. Oyvyteri pe g̃a ei: “Nhande renduvame po ti ojipe'g̃a ei nhande ve oarõ hete g̃a Tupana'ga javo,” ei g̃a oyvyteri pe. Nurã jate g̃a nhi'inhi'ig̃i Tupana'ga pe ahe moandyandyita, ei Jesus'ga. A'ero kaitu po ti hahy hete g̃a pe nehẽ, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Kiro judeus'g̃a jatykahavuhu pe Jesus'ga imbateve'g̃a ndepiagi g̃a imondorame itambere'ia hyrua pype. ");
INSERT INTO pahNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ga aherembirekokwerahẽa repiagi hẽa imondorame oitambere'ia ipype imbatere'ỹvehẽa. Mokõi itambere'ia hẽa imondoi ipype duas moedas. ");
INSERT INTO pahNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","A'ero Jesus'ga ei: —A'e katu ji nde ve: Kia aherembirekokwerahẽa remimondoa imbatere'ỹvehẽa remimondoa koji'i pyry Tupana'ga pe g̃anemimondoa hohe pa. ");
INSERT INTO pahNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","A'ereki he'yiva'ea g̃a omombyta itambere'ia ojive imondorame Tupana'ga pe hyrua pype. Hẽa ki a'e te mokoi'ĩ te hẽa herekoi itambere'ia. Hẽa imondopavi reki oapoa ipype, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Aerẽ ojipe'g̃a ei: —Ikatu hete nhandejatykahavuhua ita apopyra. Omondo g̃a itauhua pyryva'ea japokaturame ymyahũ. Ombojigwa g̃a ojatykahavuhua a'ea pyvõ ojipea pyvõ no timbohete Tupana'ga javo. A'ero Jesus'ga ei: ");
INSERT INTO pahNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","—Pehepia pe nhandejatykahavuhua avo. Aerẽ po ti ndojikojikoga'javi ojogwehe itauhua nehẽ. Omonduru pa po ti g̃a inog̃a nehẽ, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","A'ero g̃a ei ga pe: —Orembo'eharamo emombe'u ore ve, ei g̃a Jesus'ga pe. Maname po ti g̃a imondurugi nhandejatykahavuhua nehẽ? Marãva'ea po ti Tupana'ga hepiukari na'ẽ ahemonhimomby'ava'ea nehẽ ikwahavuka nhande ve nehẽ? A'ero po ti nhande ikwahavi imondurug̃werĩhava po ti kiro javo, ei g̃a. ");
INSERT INTO pahNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","A'ero Jesus'ga ei: —Penhimboko'i ti! Tapenhimoandyjukari ti g̃a pe. Aerẽ po ti he'yjuhuve'g̃a uhu ji ra'ãra'ãteheavo javo nehẽ: “Jihi ko Cristoramo Tupana'ga remimbuhurukaramo. Kiro mbapava uhu ahemoka'nhymbahava a'ero,” e'i po ti g̃a o'mbero nehẽ, ei Jesus'ga. Tapehendukatui ti g̃a a'ero. ");
INSERT INTO pahNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","—Aerẽ po ti ojipe'g̃a tavukari ojipe'g̃a pe nehẽ. Ojipe'g̃a po ti ndokopotari gwuvihavuhu'g̃a nhi'ig̃a rupi nehẽ. A'ero po ti g̃a ndekoi ojogwehe nehẽ. Imombe'urame pe me ti tapenhimongyhyjiukari g̃a pe. Otavuka tuhẽ po ti g̃a nehẽ. A'ea rupi rũi po ti mbapavakotyva'ea nehẽ, ei Jesus'ga. Ojipea Jesus'ga ei g̃a pe: ");
INSERT INTO pahNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","—G̃agwyripeve'g̃a po ti oko na'ẽ ojipe'g̃a gwyripeve'g̃a ndehe otavuka g̃a pe nehẽ. Ojipe'g̃a nduvihavuhu'g̃a po ti omondo ojigwyripeve'g̃a otavuka ojipe'g̃a nduvihavuhu'g̃a gwyripeve'g̃a pe nehẽ, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Omyomyi po ti yvya avo nehẽ. Pevo po ti yvya imyimyi nehẽ no, ei Jesus'ga. Ahã po ti g̃a pe mbatera avo nehẽ. Pevo po ti ty'ara g̃a jukai nehẽ no, ei Jesus'ga. Itetiruamba po ti g̃a nehẽ. Opihipihi po ti g̃a karugwara ojohugwi nehẽ, ei Jesus'ga. Yvaga hugwi ahemongyhyjiva'ea jipiukari ikwahavukava'ea ahe mongyhyjiavo nehẽ, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","—A'ea renonde po ti g̃a pe pyhygi okote'varuhuavo pe me nehẽ. G̃a po ti pe nderohoahyi pende'yja'g̃a jatykahai pe ipypeve'g̃a nduvihava'g̃a ndovai pyteri pe pe mondovouka cadeia pype nehẽ. G̃a po ti pe nderohoukari huvihavuhu'g̃a ndovai pyteri pe nehẽ governador'g̃a ndovai pyteri pe no. G̃andovai pyteri pe po ti g̃a pe nderohoukari nehẽ timboja tehe ti g̃a ndehe javo. Nahã po ti g̃a ndekote'varuhui pe me pejikoga g̃waramo ji rehe nehẽ, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","—A'ea rupi po ti pe ji mombe'ui g̃a pe nehẽ tojiko ti g̃a Jesus'ga rehe javo. Nahã po ti pe pyryva'ea mombe'ui g̃a pe nehẽ. ");
INSERT INTO pahNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Tape'ei na'ẽ ti pejiyvyteri pe: “Maramarã po ti nhande nhi'ig̃i g̃a pe nehẽ?” A'ea ti tape'ei pevy'are'yma. Pe'ji ti kiro pejiyvyteri pe: “Ndiajapyakai nhande nhanenhi'ig̃a rehe.” A'ea ti pe'ji, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Jihi po ti akwahaheteuka pe me pe mbo'eavo nehẽ. Nurã po ti pe ekatui penhiarõe'ỹve'g̃a pe nehẽ. A'ero po ti g̃a ndipopoakari pe me pe nhi'ig̃ame nahã. Tegwete po ti g̃a'ete'varuhua penhi'ig̃a pe nehẽ, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","—Penduva'g̃a vehevi po ti pe pyhygukari pey'g̃a vehevi peirũ'g̃a vehevi pende'yja'g̃a vehevi. Kiroki g̃a ojikoty'a pe pavẽi – g̃ahã pe pyhyguka no. G̃a nhaporemo po ti pe pyhygukari pe mondouka gwuvihavuhu'g̃a pe nehẽ. Jararamo pe g̃a pe jukauka nehẽ. ");
INSERT INTO pahNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Nahã po ti g̃a ndekopavi pe ndehe pe arõhetee'yma nehẽ pendekoro g̃waramo jireheva'ero, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","—A'ero po ti Tupana'ga pe pokogi pe moka'nhymbavukare'yma g̃a pe nehẽ. Pe'ava vehevi po ti Tupana'ga hepiakatui nehẽ. ");
INSERT INTO pahNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Penhimboitaro g̃waramo pejikoga ga rehe po ti pe ndekoi avuirama Tupana'ga pyri nehẽ, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","—Aerẽ po ti pe hepiagi soldados'g̃a cidade de Jerusalém atimaname nehẽ. Nahã po ti he'yjuhuve'g̃a tavukari Jerusalémmeve'g̃a pe nehẽ. A'ea repiagame po ti pe ikwahavi Jerusalém mondurug̃werĩhava nehẽ, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","A'ero Judéiapeve'g̃a ti toka'nhy onhana yvytyruhu pe onhimima nehẽ xamanoyme ti javo, ei Jesus'ga. Jerusalémmeve'g̃a ti toho Jerusalém hugwi nehẽ. Nhuhumeve'g̃a ti tokiyme Jerusalém me nehẽ xamanoyme ti javo, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","A'ereki Jerusalém monduruga rupi po ti Tupana'ga jipygi nehẽ. Nahã po ti hekoi Tupana'ga nhi'ĩpo'ruavo pa ymyahũva'ea po'ruavo pa. A'ereki ymyahũ ga e'i ikwatijaruka nahanahã po ti ji jipygi nhiarõe'ỹve'g̃a ndehe nehẽ javo, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","—Iporia'i po ti ipuru'ave'g̃a a'ea rupi oka'nhypotarame nehẽ. Iporia'i po ti g̃a nehẽ no – kiroki g̃a omoka'mbuka'mbu gwa'yra'g̃a nenonhapotarame, ei Jesus'ga. —Tiruahũ hete po ti judeus'g̃a pe nehẽ. Ndukatui po ti g̃apy'a nehẽ. Onhimonha'nga hete po ti Tupana'ga okovouka g̃a ndehe nehẽ. ");
INSERT INTO pahNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Judeus'g̃arũive'g̃a pe ti Tupana'ga g̃a jukaukari nehẽ. Itakyhea'javuhuva'ea pyvõ po ti judeus'g̃arũive'g̃a jara'g̃a jukai nehẽ. G̃a po ti opyhy jara'g̃a nderogwovo ogwyri pe nhaporemo nehẽ no. Nahanahã po ti g̃a g̃a mbokwaki'opavi Jerusalém hugwi nehẽ. A'ero Jerusalém g̃a imondurupavi nehẽ. Nahanahã po ti Tupana'ga Jerusalém rerekote'vate'varuhuukari judeus'g̃arũive'g̃a pe nehẽ. Emo po ti aerẽ ga ndogwerekoa'javukari g̃a pe g̃a mombiguka nehẽ, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","—Aerẽ po ti ahemongyhyjiva'ea jipiukari okovo kwara rehe jahya rehe jaytata'ia rehe ikwahavuka nehẽ. A'ero po ti yvyakotyve'g̃a gwyripeve'g̃a py'a ndukatui nehẽ. Ndovy'arihu po ti g̃a nehẽ. —Ipyambu paranauhũa nehẽ. Moumbe hete po ti typepemuhũa nehẽ. A'ero po ti g̃a nhimomby'ai ikwahave'yma javo nehẽ: “Maraname po?” e po ti g̃a. ");
INSERT INTO pahNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","—Og̃wyg̃wy po ti ipopoakava'ea yvagipeva'ea nehẽ, ei Jesus'ga. A'ero po ti yvyakotyve'g̃a mano'ãtehei okyhyjiavo nehẽ. “Marã po ti nhande rekoi nehẽ?” e po ti g̃a onhimboko'iavo nehẽ. ");
INSERT INTO pahNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","—A'ero po ti g̃a ji repiagi ji rura'javame yvag̃atig̃a pyteri pe nehẽ yvyakotyva'ero yvagipeva'ero. Jipopoakara po ti g̃a gwepia nehẽ no. Nhirendy'jandy'java po ti g̃a hepiagi nehẽ no jikatuhetea, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Ahemongyhyjihava ug̃werĩrame Tupana'ga po ti pe mbopiro'yg̃werĩ pendekote'varuhua hugwi nehẽ. Nurã po ti pepo'ã pejovavua tahepia ti ji Jesus'ga rura javo pejoryjoryvamo nehẽ, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Kiro Jesus'ga g̃a mbo'ei ojo'java'ea pyvõ. Imombe'gwovo ga ei: —Pekwahava'ja ti figo'yva ojipea'yva reheve nhaporemo. ");
INSERT INTO pahNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Henhunhame huangyra pe tuhẽ pe'e hepiaga: “Kwaria g̃werĩ kiro,” pe'e pe. ");
INSERT INTO pahNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Na jitehe hepiagame akoja ahemongyhyjiva'ea po ti pe ikwahavi nehẽ, kiro Tupana'ga oko g̃werĩ yvyakotyve'g̃a nduvihavuhuhetero javo, ei Jesus'ga imombe'gwovo g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","—Imombe'ukatuavo ji ei pe me, ei Jesus'ga. Ag̃wamove'g̃a ndekojirame po ti akoja ihopavi japiavo, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Opa po ti yvaga yvya pavẽi nehẽ. Nhinhi'ig̃a po ti ndopavag̃wami opopoakapige'yma okovo a'itituhẽva'ero avuirama nehẽ, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","—Penhimboko'i ti ite'varuhuva'ea hugwi pejikokatuavo ji mboha'uva. Tape'ui ti ahemboheagwyryva'ea pejigwojigwovo toryvi pe. A'ereki i'urame ahe ndojapyakakatui jirura'java rehe. Tape'ei ti pejiyvyteri pe: “Maramarã po ti nhande rekoi nehẽ?” Tape'ei ti na. Tapejapyakauhui ti pejihe mbatera rehe no. A'ereki hehe pa pejapyakauhurame pe napenhimboko'i ji mboha'uve'yma. Naname po ti ji pe mo'mag̃i a'ero ji rurame pendekote'varuhua repiaga nehẽ. ");
INSERT INTO pahNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Nahã po ti yvyakotyve'g̃a pe nhaporemo g̃a ji mboha'uve'ymame. Noka'nhymi g̃a ji hugwi jirura'javame nehẽ, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","—Penhimboko'i ti ite'varuhuva'ea hugwi pejikokatuavo ji mboha'uva. Pe'ji ti Tupana'ga pe jipi nehẽ: “Ore mbopopoaka ti toromboita ti oroka'nhyma hahyva'ea hugwi nehẽ aerẽva'ea hugwi nehẽ. Ore mbopopoaka ti torepoyja hete ti oro'ama Jesus'ga rovai pyteri pe orokoheteavo g̃waramo ganhi'ig̃a rupi.” Nahã ti pe'ji Tupana'ga pe jipi nehẽ, ei Jesus'ga yvyakotyva'ero yvagipeva'ero no. ");
INSERT INTO pahNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Nane'ymi arimo Jesus'ga g̃a mbo'ei g̃ajatykahavuhua pype templo pype. Ypytuna nanani ga hoi Jerusalém hugwi ogwovo yvytyri pe monte das Oliveiras pe opytavo pevo ypytunimo. ");
INSERT INTO pahNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ypyhajive ojatykave'g̃a uhu pa ga pyri ojatykahavuhua pype tihendu ti ganhi'ig̃a javo. ");
INSERT INTO pahNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Kiro judeus'g̃a japoi g̃werĩ toryva – kiroki toryva pe g̃a ei: Páscoa. Toryvi pe g̃a i'ui pão ndovuriva'ea. ");
INSERT INTO pahNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Ikwava'ẽhara'g̃a nduvihava'g̃a e'i judeus'g̃a mbo'ehara'g̃a pavẽi: —Marã po ti nhande Jesus'ga jukaukari nehẽ? Nahã g̃a ei novĩa. Emo g̃a okyhyji ojatykave'g̃a hugwi. A'ereki ojatykave'g̃a oarõ hete Jesus'ga onhimongyavo. ");
INSERT INTO pahNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Kiro Satanás'ga Judasva'ea pojykai. Judas Iscariotes, ei g̃a ahe ve. Ahe ko Jesus'ga remimbo'eharava'ea dozeve'g̃a pyteripeva'ea novĩa. ");
INSERT INTO pahNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Judasva'ea hoi Jesus'ga hugwi ogwovo ikwava'ẽhara'g̃a nduvihava'g̃a pyri guardas'g̃a pyri no – kiroki guardas'g̃a gwepia katu judeus'g̃a jatykahavuhua. Ovahemame g̃a pyri ahe ei g̃a pe: —Tapyhyguka ti ji Jesus'ga mondovouka pe me. Marã po ti a'ero nehẽ? A'ea ahe ei g̃a pe g̃a monhi'ig̃a a'ea rehe. ");
INSERT INTO pahNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Horyory g̃a ahe renduvame. A'ero g̃a ei ahe ve: —Toromondo ti itambere'ia nde ve a'ero. ");
INSERT INTO pahNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","—Kwa, ei ahe. Apyhyguka po ti ji ga pe me nehẽ, ei ahe herogwovo. Aerẽ ahe ei oyvyteri pe gweaporog̃itaro: “Marag̃atu po ti ji Jesus'ga rerekoukari ga pyhygauka g̃a pe ojatykave'g̃a ndakykweri nehẽ?” ei ahe oyvyteri pe. ");
INSERT INTO pahNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Aerẽ kiro toryva Páscoa. A'ea rupi jitehe nanani judeus'g̃a i'ui pão ndovuriva'ea. A'ea rupi jitehe g̃a ojuka mbatepyryva cordeiro. ");
INSERT INTO pahNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Nurã Jesus'ga ei Pedro'ga pe João'ga pe no: —Peho ti imboavujikwea mbatera nhande ve ti'u ti Páscoa rupi, ei ga. ");
INSERT INTO pahNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","A'ero g̃a ei ga pe: —Mome po ti ore hoi mbatera mboavujikwea nehẽ? ");
INSERT INTO pahNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","A'ero ga ei g̃a pe: —Ji rendu ti. Peho ti cidade pe. Pe horame po ti akwaimbae'ga pe novatĩ yhya rerua yhya reruhava pype nehẽ. Peho ti ga reviri. Ga horame onga pype ti peho ga reviri ipype no. ");
INSERT INTO pahNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Pe'ji ti onga jara'ga pe: “Nhanembo'ehara'ga ei nde ve: ‘Mome po hyrua ruvi? Ta'u ti mbatera ipype nhiremimbo'ehara'g̃a pavẽi Páscoa rupi,’ ei nhanembo'ehara'ga nde ve.” A'ea ti pe'ji ga pe, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","A'ero po ti ga hepiukari pe me hyruhua i'ukava ruhava onga jo'ari pe nehẽ. Pevo ti pemboavujikwe. A'ea Jesus'ga ei Pedro'ga pe João'ga pe g̃a mondovo. ");
INSERT INTO pahNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","A'ero g̃a hoi cidade pe hepiapava garemimombe'ua. A'ero g̃a japoi mbatera imboavujikwea Páscoa rupi okovo Jesus'ga nhi'ig̃a rupi. A'ero Jesus'g̃a hoi pevo no ovahema. ");
INSERT INTO pahNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Kiro g̃a o'u g̃werĩ. A'ero Jesus'ga apygi mesa pyri. Dozeve'g̃a gamoirũhara'g̃a oapy ga pyri mesa pyri. ");
INSERT INTO pahNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Kiro ga ei g̃a pe: —Kirog̃weva'ea rupi ji a'u pota hete mbatera pe pavẽi Páscoa rupi jijukahava renonde. ");
INSERT INTO pahNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","A'ereki a'e ji pe me: Kirẽ po ti ji nda'ua'javi te Páscoa rupi nehẽ. Aerẽ nhanderuvihavuhuhetero Tupana'ga imondopavame g̃wemimbotarimova'ea rupi jate po ti gareheve'g̃a mbopiro'ypahava apiavo ihoi nehẽ. A'ea rupi po ti ji japoi toryva jiroryvamo g̃a pavẽi nehẽ, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Copo ga ipyhygi. Ipype oko vinho. Hehe ga nhi'ig̃i Tupana'ga pe nde pyry hete nde imbuhua ore ve javo. Onhi'ig̃irẽ ga pe ga ei omoirũhara'g̃a pe: —Koro, ei ga g̃a pe imondovo copo g̃a pe. Pema'ema'ẽ ti pejive i'gwoi'gwovo, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","A'e ji pe me: Nda'ua'javi te po ti ji vinho nehẽ, ei Jesus'ga. Aerẽ huvihavuhuhetero Tupana'ga imondopavame g̃wemimbotarimova'ea rupi jate po ti ji japoi toryva jiroryvamo gareheve'g̃a pavẽi nehẽ, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Kiro ga ipyhygi pão. Hehe ga nhi'ig̃i Tupana'ga pe ndepyry hete nde imbuhua ore ve javo. Onhi'ig̃irẽ ga haygwe'rogwe'rogi pão imondomondovo omoirũhara'g̃a pe pe'u ti javo. A'ero ga ei: —A'ea ko jira'oa, ei ga imondomondovo pão g̃a pe. Aere'ĩ po ti hajiheve'g̃a ji pyhygi nehẽ ojigwaraita jira'oa rehe ji jukavo nehẽ. Nahã po ti ji manoi pe me pendepykaramo nehẽ. Ji manorẽ nahã ti pe'ua'ja'ja ojipea pão imoka'nhyme'yma nhimanoa pe me nehẽ, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Aerẽ g̃a i'ui mbatera imboavujikweva'ea. G̃a i'urẽ mbatera ga ipyhygi copo. Oko vinho ipype. Kiro ga imondoi vinho g̃a pe. A'ero ga ei: —A'ea ko jirekoa, ei ga imondovo vinho g̃a pe. Aheka'voguka po ti ji jirekoa g̃a pe jijukauka nehẽ. Nahã po ti ji manoi yvyakotyve'g̃a ndepyga nehẽ. A'ereki Tupana'ga ipyahuva'ea mombe'gwovo e'i: “Garekoa reka'vogame po ti ji imombori g̃andekote'varuhua g̃a hugwi,” ei ga. Nurã jirekoa reka'voga g̃waramo a'iti hete tuhẽ po ti Tupana'ga imombori pendekote'varuhua pe hugwi nehẽ g̃wembi'ea rupi nehẽ, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","—Pehepia ti! Kiroki ga ji pyhyguka g̃werĩ jijukahara'g̃a pe – gaha oapy ji pyri imondovo opoa mesa rehe! ");
INSERT INTO pahNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","A'iti a. Tamano ti ji yvyakotyva'ero yvagipeva'ero no. A'ereki Tupana'ga e'i ymyahũ aerẽ ti emano javo ji ve. Ga pe – kiroki ga ji pyhyguka ji mondovouka jijukahara'g̃a pe – ga pe po ti tiruahũ hete nehẽ, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","A'ero g̃a eg̃a'ei ojohupe: —Manamo po ti nhande Jesus'ga pyhygukari nehẽ? ei g̃a ojohupe onhimomby'avo. ");
INSERT INTO pahNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Aere'ĩ Jesus'ga moirũhara'g̃a jogwayvari ojogwehe. Ojohupe g̃a ei: —Manamo nhande johe? ");
INSERT INTO pahNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","A'ero Jesus'ga ei g̃a pe: —Judeus'g̃arũive'g̃a nduvihavuhu'g̃a ipopoaka okote'varuhuavo ogwyripeve'g̃a pe g̃a mboporavykyheteavo ojive. Jara'g̃a inog̃i ojihe Ahepokohara. Nahã g̃a ipotari ojeraramo onhimboheteavo ji apoko jigwyripeve'g̃a javo tehe, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","—G̃a ja rũi ti pejogwereko pejikovo g̃waramo jireheva'ero. Kiroki ga oko penduvihavamo jireheva'ero – gaha ti toko pejipyrive'ga ja, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Manamo g̃a johe? ei Jesus'ga. Mara'ngu po pe javo: “Kiroki ga oapy na'ẽ i'gwovo mbatera ojipyrive'g̃a imboavujikwerirẽ ga pe”? Mara'ngu po pe javo: “Kiroki ga omboavujikwe mbatera imondovo mesa rehe to'u na'ẽ ojipe'g̃a aerẽ jihi javo”? Marãi pe? ei Jesus'ga. Manamo g̃a johe? —Jihi amombe'u pe me: Gaha – kiroki ga oapy i'gwovo na'ẽ – gaha oko g̃a hohe pa. Na tuhẽ. Jihi ako penduvihavamo. Emo pepyrive'ga ja reki ji pe pokogi, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","—Pehe ag̃wamo vehevi pepyta ji moiruamo jipi pepohire'yma ji hugwi hahyrame ji ve. ");
INSERT INTO pahNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Nurã po ti ji tuhẽ pe mongoi nehẽ peko ti huvihavuhuro javo. Tupana'ga jiruva'ga ei ji ve: “Ereko ti nde g̃anduvihavuhuhetero nehẽ.” Nahã ga ei ji ve. Na jitehe po ti ji pe mongoi nehẽ peko ti huvihavuhuro javo. ");
INSERT INTO pahNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","—A'ero po ti pe i'ui jiapoa pyri mesa pyri ji rekorame yvyakotyve'g̃a nduvihavuhuhetero nehẽ. Pe po ti peapy ikatuva'ea rehe huvihavuhu'g̃a apykava rehe nehẽ pejikovo peje'yja'g̃a nduvihavuhuro Israelva'ea rakykwepohara'g̃a nduvihavuhuro. Doze ko g̃a oko huvihavamo ojiheve'g̃a pavẽi pende'yja'g̃a israelitas'g̃a. Pehe po ti peapy oina nehẽ xa'e ti g̃a pe g̃andeaporog̃ita rehe javo, ei Jesus'ga omoirũhara'g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Kiro Jesus'ga ei Simão Pedro'ga pe: —Simão, ei Jesus'ga. Ehendu hete. Ombogwa ahe trigo yrupema pyvõ tape'a ti ji ite'varuhuva'ea ikatuva'ea hugwi javo. Na jitehe Satanás'ga pe nderekopotari tahepia ti ji g̃ajikoga Jesus'ga rehe javo. A'ero Tupana'ga ei Satanás'ga pe: “Ehepia ti g̃ajikoga a'ero,” ei ga. Kiro po ti Satanás'ga pe nderekoi pe mbopohipota ji hugwi a'ero nehẽ ojigwaraita pe ndehe nehẽ, ei Jesus'ga Simão Pedro'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","—Ji ikwahavame Satanás'ga penderekopotara, ji nhi'ig̃i Tupana'ga pe nde mombe'gwovo ga pe nde repyga, ei Jesus'ga Simão'ga pe. A'e ji ga pe: Tojiko hete jitehe ti Simão'ga ji rehe nehẽ. Terembojikopigukari ti ga Satanás'ga pe a'ero. A'ea ji ei Tupana'ga pe, ei Jesus'ga Simão Pedro'ga pe. A'ereki hahy hete nde ve Satanás'ga nde mbopohirame. Aerẽ po ti nde reaporog̃itakatua'javamo ejikoga ji rehe nehẽ. Kirẽ ti enhi'ĩ g̃a pe nemoirũhara'g̃a pe g̃a mbovy'a g̃a monhimomiranama – kiroki avove'g̃a nhiremimbo'ehara'g̃a, ei Jesus'ga Simão Pedro'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","A'ero Simão'ga ei Jesus'ga pe opojykaharete'ga pe: —Nde pavẽi po ti ji hoi nehẽ. Po ti g̃a nde mongi cadeia pype nehẽ, na g̃a ji mongi a'ero nehẽ no. Po ti g̃a nde jukai nehẽ, na g̃a ji jukai a'ero nehẽ no, ei ga. ");
INSERT INTO pahNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","—Pedro, ei Jesus'ga Simão Pedro'ga pe. A'e ji nde ve: Kiro ypytunimo po ti nde ei ji ve nehẽ: “Ji ndakwahavi Jesus'ga.” Três po ti nde ea'jaa'javi a'ea ji ve inamutig̃a nhi'ig̃a renonde nehẽ, ei Jesus'ga Pedro'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Kiro Jesus'ga ei omoirũhara'g̃a pe: —Ymya'ĩ ji pe mondoukari Tupana'ga nhi'ig̃a mombe'gwovouka ahe ve. A'ea rupi a'e ji pe me: Taperohoi ti itambere'ia, sacola, sandálias irũa. Marã pe me a'ea rupi raikwehe? Napembateri? Marã pe ndekoi raikwehe? A'ero g̃a ei ga pe: —Orogwereko ore a'ea rupi, ei g̃a. ");
INSERT INTO pahNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","—Kiro hajihea ji imombe'ui pe me, ei Jesus'ga g̃a pe. Po pe pereko itambere'ia, a'ero ti peroho. Po pe pereko sacola, a'ero ti peroho. Po pe ndaperekoi itakyhea'javuhuva'ea, a'ero ti pemondo peapoa pepira arimova'ea paletó ipyhyga itambere'ia. A'ero ti pepyhy itakyhea'javuhuva'ea pejive itambere'ia rehe. ");
INSERT INTO pahNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","A'ereki ji a'e pe me: Kiro po ti nhimombe'ua po'ruavo toho nehẽ – kiroki Tupana'ga rembikwatijarukara e'i: “Ga jukauka po ti g̃a ei nehẽ: ‘Ga ko okote'varuhu’.” A'ea ikwatijaripyra e'i ji mombe'gwovo, ei Jesus'ga. Nahã kiro hekoi nehẽ. A'ereki ji ahygahi pa g̃werĩ nhimombe'ua rehe, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","A'ero Jesus'ga moirũhara'g̃a ei Jesus'ga pe: —Ehepia orepojykaharetero, ei g̃a. Agwa ko mokõi itakyhea'javuhuva'ea. A'ero ga ei g̃a pe: —Kirupi te! ");
INSERT INTO pahNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Kiro ga hoi ogwovo yvytyri pe oliveiras ndyvi pe monte das Oliveiras pe. Oho ga pevo jipi. Kiro garemimbo'ehara'g̃a hoi ga rupi. ");
INSERT INTO pahNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ovahemame pevo Jesus'ga ei g̃a pe: —Penhi'ĩ ti Tupana'ga pe. Pe'ji ti ga pe: “Ore poko ti torokote'varuhupotaryme ti.” Nahã ti pe'ji Tupana'ga pe, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Hehemo'i ga hoi g̃a hugwi g̃wenypy'anduruga tanhi'ĩ ti Tupana'ga pe javo. Onhi'ĩ ga ga pe a'ero. ");
INSERT INTO pahNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","—Apĩ, ei ga Tupana'ga pe. Nde ipotarame ti terembuhurukari hahyva'ea ji ve ji jukaukare'yma g̃a pe. Emo nhiremimbotarimova'ea rupi rũi ji tako, a'e reki nde ve. Po nde erepota nhimanoa tamano ti ji a'ero, ei Jesus'ga Tupana'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Kiro Tupana'gapyrive'ga jipiukari Jesus'ga pe ua yvaga hugwi Jesus'ga mbopopoaka. ");
INSERT INTO pahNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Hahy hete Jesus'ga yvyteri pe ga rekoveveuhuavo g̃waramo. Nurã ga nhi'ĩhetei Tupana'ga pe. Gwy'ajyguhu ga. Otururu hete ga hugwi yvyvo gary'aja. Garekoa ja hete itururui. ");
INSERT INTO pahNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Aerẽ ga nhi'imbavi Tupana'ga pe opo'ama'java ojivya g̃wemimbo'ehara'g̃a pyri g̃a ndepiaga. Oki g̃a g̃we'ouhũro okoveveuhuavo g̃waramo. ");
INSERT INTO pahNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","A'ero ga ei g̃a pe: —Maraname pe kiri? Pevy ti penhinhi'ig̃a Tupana'ga pe. Pe'ji ti ga pe: “Ore poko ti torokote'varuhupotaryme ti.” Nahã ti pe'ji Tupana'ga pe, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Ga nhi'imbige'ymame nanime he'yive'g̃a nduri. Judasva'ea ruri g̃a nenonde g̃a nderua g̃a nderovahema. Judasva'ea ko Jesus'ga remimbo'eharava'ea dozeve'g̃a pyteripeva'ea. Kiro ahe ruri Jesus'ga beijavo. ");
INSERT INTO pahNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","—Judas, ei Jesus'ga ahe ve. Ji beijavo nde ruri. Nahã nde ji repiukari g̃a pe naerũ togweroho ti g̃a ga javo? ei Jesus'ga yvyakotyva'ero yvagipeva'ero no. ");
INSERT INTO pahNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Hepiagame Jesus'gapavẽive'g̃a ei oyvyteri pe: “Kiro po ti g̃a Jesus'ga pyhygi!” ei g̃a. A'ero g̃a ei Jesus'ga pe: —Marã? Torokyti g̃a itakyhea'javuhuva'ea pyvõ a'ero naerũ? ei g̃a Jesus'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Nanime Jesus'gapavẽive'g̃a pyteripeve'ga imondoi itakyhea'javuhuva'ea ikwava'ẽhara'g̃a nduvihavuhu'gapyrive'ga apiavo ga nambi'oga gajohukoty rũi. ");
INSERT INTO pahNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","A'ero Jesus'ga ei onhipavẽive'ga pe: —Kirupi te! Jesus'ga pokogi ganamihymuhũa rehe ganambia apokatua'java. ");
INSERT INTO pahNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Kiro Jesus'ga nhi'ig̃i ikwava'ẽhara'g̃a nduvihava'g̃a pe xava'eve'g̃a pe no guardas'g̃a pe no – kiroki guardas'g̃a gwepia katu judeus'g̃a jatykahavuhua. A'ereki g̃a nhaporemo uhu ga pyri tipyhy ti ga javo. G̃a pe Jesus'ga ei: —Amovahĩ po ji governo naerũ? Nurã pe heruri itakyhea'javuhuva'ea mbuahava reheve ji pyhyga naerũ? ");
INSERT INTO pahNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Nane'ymi ji rekoi pe pavẽi nhandejatykahavuhua pype templo pype ikwehe'i. A'ea rupi pe ndajipyhygi, ei Jesus'ga. Korogwe Tupana'ga ji pyhygukari pe me. Diabo'ga omondomondo ypytunarupive'g̃a'jave'g̃a. Gaha pe mbuhu ji pyhypota, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","A'ero g̃a ga pyhygi ga rerogwovo. Ikwava'ẽhara'g̃a nduvihavuhu'ga rongauhu pe g̃a ga rerohoi ga rerovahema. Ga reviri Pedro'ga hoi onhimboyha'iavo ga hugwi tajipyhygyme ti g̃a javo. ");
INSERT INTO pahNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Imondygirẽ tata okara pyteri pe g̃a oapy ojogwerekovo ipyri. A'ero Pedro'ga oapy g̃a pyri no. ");
INSERT INTO pahNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Ga apygame pevo tata pyri ikwava'ẽhara'g̃a nduvihavuhu'gapyrivehẽa ga repiagi. Hẽa gwepia hete ga. A'ero hẽa ei ga mombe'gwovo: —Agwa'ga ko Jesus'ga pavẽive'ga no, ei hẽa. ");
INSERT INTO pahNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Pedro'ga nonhimombe'ui reki. —Kunha, ei ga hẽa pe. Ji ndakwahavi ga, ei ga o'mbero. ");
INSERT INTO pahNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Aere'ĩ ojipe'ga ga repiagi. Pedro'ga pe ga ei: —Ndehe no Jesus'ga pavẽiva'ea. A'ero Pedro'ga ei ga pe o'mbero: —Ji rũi ko! ei ga. ");
INSERT INTO pahNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Aerẽ uma hora ikwavame ojipe'ga ehetei Pedro'ga mombe'gwovo: —Ga tuhẽ Jesus'ga pavẽive'ga no. A'iti a. A'ereki ga Galiléiapeva'ero oko, ei ga. ");
INSERT INTO pahNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","A'ero Pedro'ga ei: —Gara pe nde ei? A'ereki ji ndakwahavi, ei ga. Ga nhi'imbige'ymame kotihĩ inamutig̃a nhi'ig̃i. ");
INSERT INTO pahNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","A'ero nhandepojykaharete'ga Jesus'ga pyryrymi Pedro'ga repiaga. A'ero Pedro'ga ikwahava'javi ga'eagwera ojive. A'ereki Jesus'ga e'i jipe ga pe: “Kiro ypytunimo po ti nde ei ji ve nehẽ ji ndakwahavi Jesus'ga javo. Três po ti nde ea'jaa'javi a'ea ji ve inamutig̃a nhi'ig̃a renonde nehẽ,” e'i jipe Jesus'ga ga pe. ");
INSERT INTO pahNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Jesus'ga eagwera kwahava'javame Pedro'ga hoi ogwovo. Ga ojehe'o ranuhũ. ");
INSERT INTO pahNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Kiroki g̃a Jesus'ga mombyta ikwava'ẽhara'g̃a nduvihavuhu'ga ronga pype – kiro g̃a eg̃a'ei ga pe ga jagajaita ga nupanupamo. ");
INSERT INTO pahNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Tohepiagyme ti ga javo g̃a ga reakwapygi. A'ero garova nupãrame g̃a ei ga pe: —Eko ti Tupana'ga nhi'ig̃a mombe'uhara'ga ja. Emombe'u ti mbatera ore ve a'ero. Ma'g̃a nde nupã? ");
INSERT INTO pahNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Nahanahã g̃a ete'varuhui Jesus'ga pe ga mbotegweteavo. ");
INSERT INTO pahNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Iko'emame xava'eve'g̃a nhimono'og̃i ikwava'ẽhara'g̃a nduvihava'g̃a pavẽi judeus'g̃a mbo'ehara'g̃a pavẽi no. G̃a ko judeus'g̃a mog̃itahara'g̃a. Kiro g̃a Jesus'ga mbuhurukari gwovai pyteri pe. Ga pe g̃a ei: ");
INSERT INTO pahNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","—Enhimombe'u ti ore ve. Ma gara ndehe? Nde ko Cristo Tupana'ga remimbuhurukara? Nde ko Cristo rũi? Emombe'u ti ore ve, ei g̃a. A'ero Jesus'ga ei g̃a pe: —Po ji ei pe me: Jihi Cristoramo, a'ero po ti pe ndaperoviari nhinhi'ig̃a nehẽ. ");
INSERT INTO pahNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Po ji ei pe me: Pemombe'u ti mbatera ji ve, a'ero po ti pe napemombe'ui ji ve nehẽ. Pe napenhimohemukari nehẽ no. ");
INSERT INTO pahNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Aere'ĩ po ti ji apygi avuirama ipopoakaheteve'ga pyri Tupana'ga pyri gajohukoty rũi jitekovo huvihavamo nehẽ yvyakotyva'ero yvagipeva'ero no, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","A'ero g̃a epavi ga pe: —Marãi po nde? Nde ko Tupana'ga ra'yra a'ero naerũ? ei g̃a. A'ero ga ei g̃a pe: —Pehe ko pe'ji poha, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","A'ero g̃a ei ojohupe: —Kirupi ojipe'g̃a nemimbojara Jesus'ga rehe a'ero! Ore tuhẽ ga rendu ko. Ga e'i ji Tupana'ga ra'yramo ako javo, ei g̃a ojohupe. ");
INSERT INTO pahNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","A'ero g̃a po'ambavi Jesus'ga rerogwovo Pilatos'ga rovai pyteri pe ga rerovahema. Pilatos'ga ko governador'ga Judéiapeve'g̃a gwyri pe. ");
INSERT INTO pahNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Kiro g̃a imbojambojari ite'varuhuva'ea Jesus'ga rehe Pilatos'ga rovai pyteri pe. O'mbero g̃a ei ga pe: —Oropyhy ore Jesus'ga ga orere'yja'g̃a mongoukarame oreruvihava'g̃a nhi'ig̃a rupi rũi. E'i ga g̃a pe: “Tapemondoi ti itambere'ia César'ga pe nhande ruvihavuhu'ga pe.” A'ea ga ei, ei g̃a. Ojipea ga ei: “Ji tuhẽ ko Cristo huvihavuhuhetea.” A'ea Jesus'ga ei g̃a pe, ei g̃a Pilatos'ga pe o'mbero. ");
INSERT INTO pahNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","A'ero Pilatos'ga ei Jesus'ga pe: —Marãi nde? Ndehe ko judeus'g̃a nduvihavuhuhetero ra'e? A'ero Jesus'ga ei ga pe: —Ndehe ko ere poha, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","A'ero Pilatos'ga ei ikwava'ẽhara'g̃a nduvihava'g̃a pe pevove'g̃a pe no: —Kiro ji ga mohemukari. A'ereki ndojari ga rehe. Ga ndokote'varuhui governo pe, ei Pilatos'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Koji'i g̃a eg̃a'ehetei reki Pilatos'ga pe: —Nombuhukatuukari ga orere'yja'g̃a py'a pe g̃a mbo'eavo g̃waramo. Ga ombo'e pa Judéiapeve'g̃a. Galiléiapeve'g̃a na'ẽ ga g̃a mbo'ei. Avove'g̃a vehevi ga g̃a mbo'ei ag̃wamo, ei g̃a Pilatos'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","A'ea renduvame Pilatos'ga ei g̃a pe: —Ga po Galiléiapeve'ga ra'e? ");
INSERT INTO pahNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","—Pevove'ga tuhẽ ko, ei g̃a. A'ea kwahavame Pilatos'ga Jesus'ga mondoukari Herodes'ga pyri. A'ereki Herodes'ga omondomondo Galiléiapeve'g̃a g̃wemimbotarimova'ea rupi g̃agwyri pe. A'ea rupi ga opytaahi'vi Jerusalém me no. ");
INSERT INTO pahNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Kiro Pilatos'ga Jesus'ga mondoukari Herodes'ga pyri a'ero. Horyory Herodes'ga Jesus'ga repiagame. A'ereki ymya ga ga repia pota gamombe'umbe'ua renduva g̃waramo. Ga gwepia pota Jesus'ga remimonhimomby'ava'ea no. ");
INSERT INTO pahNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","A'ero ga nhi'imbukui Jesus'ga pe. “Maramarã?” ei ga ga pe novĩa. Jesus'ga nonhi'ig̃i reki ga pe. ");
INSERT INTO pahNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Kiro ikwava'ẽhara'g̃a nduvihava'g̃a ami judeus'g̃a mbo'ehara'g̃a pavẽi onhi'ĩranuhũavo imbojamboja Jesus'ga rehe. ");
INSERT INTO pahNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","A'ero Herodes'ga Jesus'ga mbotegwetei ga jagajaita onhipavẽive'g̃a pavẽi soldados'g̃a pavẽi. Omongiuka g̃a Jesus'ga pe tapy'ynhapipyryva i'arimova'ea hendy'java'ea tirekomemua Jesus'ga javo. Aerẽ ga Jesus'ga mondoukari ga mbojivyruka Pilatos'ga pyri. ");
INSERT INTO pahNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","G̃a nonhoarõhetei ymya Herodes'ga Pilatos'ga pavẽi. Kiro g̃a nhoarõi Jesus'ga arõe'yma g̃waramo. ");
INSERT INTO pahNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Kiro Pilatos'ga g̃a mono'ono'og̃ukari ikwava'ẽhara'g̃a nduvihava'g̃a judeus'g̃a nduvihava'g̃a ndeheve ojipe'g̃a ndeheve. ");
INSERT INTO pahNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","G̃a pe ga ei: —Pe Jesus'ga reruri jirovai pyteri pe tokwaha ga garekote'varuhua javo. A'ereki pe pe'e: “Ga he'yjuhuve'g̃a pe'a g̃anduvihava'g̃a hugwi,” pe'e tehe pe. Ji rendu! Ji pendovaki pe nendupavirẽ ji ei ga pe: Marãi nde naerũ? a'e ji ga pe. Erepe'a nde g̃a g̃anduvihava'g̃a hugwi? Marãi? Nanongara ji eji'ei ga pe takwaha ti ji garekote'varuhua javo. Akwaha ji a'ero. Ndojari ga rehe a'ea – kiroki a'ea pe ei imbojateheavo ga rehe. ");
INSERT INTO pahNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Herodes'ga na jitehe ga ei no ndojari ga rehe javo. A'ereki ga omondoukara'ja Jesus'ga nhande pyri imbojare'yma ga rehe. —Ji rendu ti! ei Pilatos'ga. Jukwaha Jesus'ga pyryva. Tojukayme ti ahe Jesus'ga a'ero. ");
INSERT INTO pahNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Nurã po ti ji ndajukaukari ga nehẽ. Anupanupãuka po ti ji ga mbo'eavo nehẽ tokote'varuhua'javyme ti ga nehẽ javo. A'ea Pilatos'ga ei g̃a pe g̃a mbohorypota ojihe. —A'ero po ti ji ga mohemukari ga mondouka garonga pe nehẽ, ei ga. ");
INSERT INTO pahNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","A'ereki ga ombopiro'y cadeiapypeve'ga mohemuka toryva rupi nanani Páscoa rupi nanani. A'ereki ymyahũ judeus'g̃a e'i ga pe: “Emohemuka ti ore ve cadeiapypeve'ga Páscoa rupi nanani tojivyra'ja ti ga g̃wonga pe,” ei judeus'g̃a ymyahũ. Nurã kiro Pilatos'ga ei amohemuka po ti ji Jesus'ga nehẽ javo. ");
INSERT INTO pahNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","A'ero g̃a nhaporemo hapukai. —Ejukauka Jesus'ga, ei g̃a. Emohemuka Barrabás'ga ore ve, ei g̃a ohapukaita. ");
INSERT INTO pahNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Omongia renonde Barrabás'ga ahe juka. Omovahĩ Barrabás'g̃a gwuvihavuhuva'ea cidade de Jerusalém me no. Nurã Pilatos'ga ga mondoukari cadeia pype. ");
INSERT INTO pahNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Kiro Pilatos'ga ea'javi g̃a pe. A'ereki ga Jesus'ga mohemuka pota. ");
INSERT INTO pahNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Ga renduvame g̃a hapukajahiva'javi ga pe: —Embovyruka ga! Embovyruka ga! A'ea g̃a ei ga pe tomano ti Jesus'ga yva rehe javo. ");
INSERT INTO pahNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Mokõi Pilatos'ga onhi'ig̃ipe g̃a pe. Kiro ga ea'javi: —Maranameuhũ naerũ! Gara garekote'varuhua naerũ? Ndojari ga rehe, a'e ji pe me ko. Tojukayme ti ahe Jesus'ga. A'ereki ga pyry. Nurã po ti ji ndajukaukari ga nehẽ. Anupanupãuka po ti ji ga mbo'eavo nehẽ tokote'varuhua'javyme ti ga nehẽ javo. A'ero po ti ji ga mohemukari nehẽ, ei ga. ");
INSERT INTO pahNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Koji'i g̃a hapukapukajahivi a'ero ikwava'ẽhara'g̃a nduvihava'g̃a pavẽi. Ga nhi'ig̃ayvayvari ko g̃a. —Embovyruka ga! Embovyruka ga! A'ea g̃a ei ohapukaita tomano ti Jesus'ga yva rehe javo. G̃a hapukapukaita g̃waramo Pilatos'ga ei: —Kwa. ");
INSERT INTO pahNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Na tuhẽ po ti a'ero nehẽ naerũ! ei ga okovo g̃anhi'ig̃a rupi. ");
INSERT INTO pahNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Nurã Pilatos'ga Barrabás'ga mohemukari cadeia hugwi ga mondovo g̃a pyri – kiroki ga ahe juka gwuvihavuhuva'ea movahĩ no. Ga rehe g̃a oporandu tomohemuka ga javo. Soldados'g̃a pe Pilatos'ga Jesus'ga mondoukari reki tojuka ti g̃a ga javo. A'ereki judeus'g̃a nduvihava'g̃a g̃andeheve'g̃a pavẽi e'ie'i embovyruka ga javo. ");
INSERT INTO pahNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Kiro soldados'g̃a Jesus'ga rerohoi a'ero tijuka ti ga javo. Uhu Simão'ga cidadepeve'ga Cirenepeve'ga pea rupi nhuhũa hugwi. Ga rurame g̃a ga pyhyguhui imondovo yva ga arimo Jesus'ga jukahava rupiara togweroho ti ga Jesus'ga reviri javo. ");
INSERT INTO pahNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","He'yjuhuve'g̃a hoi Jesus'ga reviri. Kunhangwera'g̃a hoi g̃a pavẽi ga reviri no ojehe'oranuhũavo kiro po ti ga manoi nehẽ javo. ");
INSERT INTO pahNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","A'ero Jesus'ga pyryrymi g̃andovai. —Kunha, Jerusalémmeva'ero ti tapejehe'oi ji rehe. Pejihe ti pejehe'o peja'yra'g̃a ndehe no. ");
INSERT INTO pahNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Ji rendu! Aerẽ po ti avove'g̃a ei nehẽ: “Pyry hete kunhangwera'g̃a ndekorame ndata'yriva'ero g̃ambo'are'ỹva'ero g̃amoka'mbue'ỹva'ero,” e po ti g̃a nehẽ. ");
INSERT INTO pahNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Aerẽ po ti avove'g̃a manopotari hahyhetero g̃waramo g̃a pe nehẽ. A'ero po ti g̃a ei yvytyruhua pe nehẽ: “E'a ore rehe.” Nhyvyapyna pe po ti g̃a ei nehẽ: “Ore tỹ ti,” e po ti g̃a jupe nehẽ, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Po ag̃wamo ji ve okopyryva'ea pe turi hahyva'ea, a'ero kaitu po ti hahyheteva'ea ruri pe me penda'yra'g̃a pe nehẽ no, ei Jesus'ga kunhangwera'g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Jesus'ga reheve soldados'g̃a mokonhava'ea rerohoi no tijuka ti g̃a javo. A'ereki mokonhava'ea ndokoi gwuvihava'ga nhi'ig̃a rupi okote'varuhuavo. ");
INSERT INTO pahNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","A'ero g̃a ahe rerohoi pevo yvytyri pe A Caveira pe ahe rerogwovo i'arimo Jesus'ga reheve. Xa'e nhande A Caveira pe Aheapina. Pevo g̃a Jesus'ga kutugi yva rehe ga mbovya hehe. Ombovy g̃a mokonhava'ea yva rehe no – kiroki mokonhava'ea okote'varuhu. Soldados'g̃a ojipeva'ea mbovyri Jesus'ga pyri gajohukoty rũi. Gajohukoty g̃a ojipeva'ea mbovyri. ");
INSERT INTO pahNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Kiro Jesus'ga nhi'ig̃i Tupana'ga pe. —Apĩ, ei ga Tupana'ga pe. Emombo g̃andekote'varuhua g̃a hugwi ikwahava'jave'yma. A'ereki g̃a ndokwahavi okote'varuhuavo ji ve, ei Jesus'ga. Kiro soldados'g̃a ima'ẽi Jesus'ga pira imombomomboa ita'java'ea dados'java'ea manamo nhande tipojyka gapira javo. Nahã g̃a ima'ẽi gapira ojive. ");
INSERT INTO pahNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Kiro he'yjuhuve'g̃a ndekoi hepiaga onhimongyavo. G̃anduvihava'g̃a ete'varuhui Jesus'ga rerekomemuamo no javo ga pe: —Jesus'ga opoko ojipe'g̃a tomanoyme ti g̃a javo, ei g̃a. Po ga oko tuhẽ Cristoramo Tupana'ga remimbuhurukaramo, a'ero po ga pe Tupana'ga e'i katu eko ti nhiremimbotarimova'ea rupi javo. Po nahã ga rekoi, a'ero po ti ga tojipoko kiro tamanoyme ti ji javo, ei g̃a. ");
INSERT INTO pahNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","G̃a pavẽi soldados'g̃a Jesus'ga rerekomemui no herua vinho tajahiva'ea ga pe ey'u ti javo. ");
INSERT INTO pahNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","—Po nde ereko judeus'g̃a nduvihavuhuhetero, a'ero ejipoko tamanoyme ti ji javo, ei soldados'g̃a Jesus'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Okwatijaripe ko g̃a imondovo Jesus'ga akag̃a arimo yva rehe. Ikwatijaripyra omombe'u Jesus'ga. Imombe'gwovo i'ei: —Agwa'ga ko judeus'g̃a nduvihavuhuhete'ga. Nahã g̃a imondoi ikwatija gregos'g̃a nhi'ig̃imo romanos'g̃a nhi'ig̃imo no hebreus'g̃a nhi'ig̃imo no Jesus'ga mombe'gwovo. ");
INSERT INTO pahNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Ojipeva'ea g̃anemimbovyva'ea ete'varuhui Jesus'ga mbotegweteavo. Jesus'ga pe ahe ei: —Po nde Cristo Tupana'ga remimbuhurukara, ejipoko ti naerũ. Ore poko no xamanoyme ti, ei ahe heroviare'yma. ");
INSERT INTO pahNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ojipeva'ea g̃anemimbovyva'ea, ahe ki a'e te e'i ga pe: —Tere'ei ti a'ea Jesus'ga pe! Nderekyhyji nde Tupana'ga hugwi naerũ? Po nde erekyhyji ga hugwi hamo. A'ereki g̃a nhande mbovyruka yva rehe ga reheve peko te'varuhu pe javo. ");
INSERT INTO pahNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Oja hete tuhẽ nhande rehe. Pyry hahyro nhande ve a'ero. A'ereki nhande xako te'varuhu. Jesus'ga ki a'e te ndokote'varuhui, ei ahe. ");
INSERT INTO pahNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Jesus'ga pe ga ei: —Jipojykaharetero ji kwahava'ja ti imombyryva ji ve ekorame huvihavuhuhetero nehẽ, ei ga Jesus'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","A'ero Jesus'ga ei ga pe: —Imombe'ukatuavo ji ei nde ve: Ag̃wamo po ti nde rekoi ji pyri ahererekokatuhai pe yvagi pe nehẽ, ei Jesus'ga ga pe. ");
INSERT INTO pahNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","45","Ahaji katu kwara igwehetei reki ipyryrymame. Ypytunahimba hete yvya koty nhaporemo. Ka'arug̃werĩa rupi às três horas kwara imbokojahua'javi. G̃ajatykahavuhua pype tapy'ynhapira hovapiahava itararagi mbytera rupi. ");
INSERT INTO pahNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Tupana'ga pe Jesus'ga hapukajahivi. —Apĩ, ei ga Tupana'ga pe. Kiro ji imondoukari jira'uva nde ve herekokatuuka. Onhi'ig̃irẽ ga pytupavamo omanomo. ");
INSERT INTO pahNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Soldados'g̃a nduvihava'ga gwepia pa hahyhava Jesus'ga pe gajukahava. Hepiagame ga ei: —Ahe ko pyryheteva'ea. A'iti a! ei ga Tupana'ga mboheteavo. ");
INSERT INTO pahNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Kiroki g̃a uhu tihepia katu gajukahava javo – g̃a gwepia pa. Ojivy g̃a kiro ogwovo g̃wonga pe. Ojipoti'a rehe okwaokwa g̃a opoa pyvõ okoveveuhuavo g̃waramo. ");
INSERT INTO pahNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Jesus'ga kwahakatuve'g̃a nhaporemo g̃a ami irupe Jesus'ga hugwi hepiapava kunhangwera'g̃a pavẽi – kiroki kunhangwera'g̃a uhu Jesus'ga rupi Galiléiapeve'g̃a gwyra hugwi ga pokoga. ");
INSERT INTO pahNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Kiro José'ga hoi Pilatos'ga pyri. José'ga ko judeus'g̃a mog̃itaharamo. Ojihe'a ko ga judeus'g̃a mog̃itahara'g̃a ndehe javo judeus'g̃a pe nahanahã ti peko javo g̃a pe. Pyry hete gareaporog̃ita. A'ereki ga oko Tupana'ga nhi'ig̃a rupi. ");
INSERT INTO pahNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Nurã ga noarõi ojipe'g̃a ndeaporog̃ita judeus'g̃a mog̃itahara'g̃a ndeaporog̃ita g̃a erame ojohupe tijukauka Jesus'ga javo. Ga nde'i a'ea. A'ereki ga ndopotari gajukahava. G̃a Jesus'ga jukaukarame ga nomoirũi g̃a no. Nahã José'ga oko. Gacidadegwera ko Arimatéia gwe'yja'g̃a cidade judeus'g̃a cidade. Ymya José'ga Cristo'ga rura pota aerẽ po ti ga rekoi nhanderuvihavuhuhetero avo yvya koty nehẽ javo. ");
INSERT INTO pahNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Kiro José'ga hoi Pilatos'ga pyri ogwovo ovahema javo ga pe: —Taroho ti Jesusva'ea ra'oa, ei ga Pilatos'ga pe. —Kwa. Eroho ti, ei ga José'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","A'ero José'g̃a jivyri ua Jesus'ga pyri. Yva hugwi José'g̃a Jesus'ga ra'oa mbojyvi. A'ero g̃a gara'oa uvani tapy'ynhapipyryva pyvõ linho apopyra pyvõ. A'ero g̃a gara'oa rerohoi inog̃a itaruvihavuhua kwaruhua pype imbogwaipyra pype. Ndogwerekoi ve ojipeva'ea ra'oa ipype. Kiro g̃a Jesus'ga ra'oa rerohoi inog̃a ipype. ");
INSERT INTO pahNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Mbatera mboavujikwehava sexta-feira g̃a inog̃i ipype ka'arugame. A'ero g̃aporavykye'yma g̃werĩ sábado g̃werĩ. ");
INSERT INTO pahNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Kunhangwera'g̃a – kiroki g̃a uhu Jesus'ga rupi Galiléiapeve'g̃a gwyra hugwi – g̃ahã oho José'ga rupi ikwaruhu pe. A'ero g̃a hepiagi ikwaruhua Jesus'ga ra'oa nongava. José'g̃a gara'oa nog̃ame ipype kunhangwera'g̃a hepiakatui nahã g̃a ono ahera'oa javo. ");
INSERT INTO pahNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Aerẽ g̃a jivyri ogwovo g̃wonga pe imboavujikwea perfume timongy ti ahera'oa rehe imbojigwaga javo. Perfume ko mohag̃a'java'ea nhandya'java'ea reheve. Oporavykye'yma rupi sábado rupi g̃a pytu'ui oporavykyhava hugwi. A'ereki ymyahũ Tupana'ga e'i judeus'g̃a mbo'eavo tapeporavykyi ti sábado rupi javo. ");
INSERT INTO pahNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","G̃aporavykye'yma py'rovo domingo rupi kunhangwera'g̃a heruri Jesus'ga ra'oa nongai pe itaruvihavuhua kwaruhu pe. Ypyhajive kwara ipog̃werĩrame g̃a heruri pevo perfume – kiroki a'ea g̃a omboavujikweripe. ");
INSERT INTO pahNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Herovahemame g̃a hepiagi ikwaruhua rovapytymbava imoanhanipyra. Irupe'i ikwaruhua hugwi reki iteni hovapytymbava. ");
INSERT INTO pahNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","A'ero g̃a ki ikwaruhua pype. G̃a ndohepiagi reki Jesus'ga ra'oa nhandepojykaharete'ga ra'oa ipype. ");
INSERT INTO pahNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","—Marã naerũ? Mome ahera'oa? ei g̃a ojohupe. Nanime mokonha'g̃a jipiukari g̃a pe o'ama akwaimbae'g̃a'jave'g̃a. Overavera g̃a'apoa tapy'ynhapira. ");
INSERT INTO pahNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","A'ero kunhangwera'g̃a nhova'apỹhetei g̃andovai pyteri pe okyhyjiavo g̃waramo. A'ero g̃a ei kunhangwera'g̃a pe: —Po pe ndapehekari okojive'ga omanove'g̃a nongai pe hamo. ");
INSERT INTO pahNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Nduvi Jesus'ga avo onongavagwera pype. Ovy reki ga jugwi. Pekwahava'ja ti ganhi'ig̃agwera. Ymya uvame Galiléia pe ga omombe'u pe me. ");
INSERT INTO pahNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Ga e'i pe me: “Okote'varuhuve'g̃a po pe ti g̃a tanhimondouka nehẽ. G̃a ti tajijuka ji mbovyruka yva rehe nehẽ. Nhimanorẽ mokõi jikira py'rovo ti ji takwera nehẽ yvyakotyva'ero yvagipeva'ero no.” A'ea Jesus'ga e'i onhimombe'gwovo pe me ikwehe'i, ei g̃a kunhangwera'g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","A'ero kunhangwera'g̃a ikwahava'javi Jesus'ga nhi'ig̃agwera. ");
INSERT INTO pahNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","G̃a hemi ikwaruhua hugwi Jesus'ga ryvyagwera hugwi ogwovo onzeve'g̃a pyri Jesus'ga moirũhara'g̃a pyri. Ovahemame g̃a imombe'upavi g̃a pe Jesus'gareheve'g̃a pe nhaporemo no. ");
INSERT INTO pahNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Maria Madalenahẽa omombe'u Joanahẽa pavẽi. Tiago'ga yhẽa Mariahẽa omombe'u g̃apavẽive'g̃a pavẽi kunhangwera'g̃a. G̃a nhaporemo omombe'u Jesus'ga moirũhara'g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Emo g̃a ndogweroviari kunhangwera'g̃a remimombe'ua. —Onhi'ĩ tehe g̃a, ei g̃a. ");
INSERT INTO pahNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Pedro'ga ki a'e te ga vyri onhana ogwovo ikwaruhua pyri Jesus'ga ryvyagwera pyri tahepia ti ji javo. Ovahemame ga apyni hepiaga ikwaruhua pype. A'ero ga hepiagi Jesus'ga ra'oa hokava. Linho apopyra Jesus'ga ra'oa hokava. A'ea jate ga hepiagi ipype. A'ero ga hoi g̃wonga pe ojapyakaheteavo hehe onhimomby'avo. ");
INSERT INTO pahNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","A'ea rupi te kiro Cleopas'g̃a homemei cidade'i pe Emaús pe Jesus'gareheve'g̃a. Emaús oko irupe dez quilômetros gwerevi cidade de Jerusalém hugwi. ");
INSERT INTO pahNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Ohorame g̃a nhomonhi'imbavi Jesus'ga rehe gajukahava rehe onhonhi'ĩpondekwava hehe. ");
INSERT INTO pahNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","G̃a nhomonhi'ig̃ame Jesus'ga tuhẽ g̃a ndupitigi ogwovo g̃a ndupi. ");
INSERT INTO pahNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","G̃a nombaragwahavi Jesus'ga rehe. ");
INSERT INTO pahNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Kiro Jesus'ga ei g̃a pe: —Gara rehe pe nhonhi'ĩpondekwavi pejigwovo ve pea rupi pevy'are'yma? ei Jesus'ga. A'ero g̃a pytai. ");
INSERT INTO pahNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Kiro Cleopas'ga ei Jesus'ga pe: —Nde ko ojipeahugwiva'ero erepytaahi'vi kiro Jerusalém me ikwahave'yma tiruahũva'ea ag̃wamova'ea Jerusalém me naerũ? Nde jate po nderekwahavi! ei ga. ");
INSERT INTO pahNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","—Gara pe pe ei? ei Jesus'ga. Ombaragwahave'yma ga rehe g̃a ei: —Tiruahũva'ea Jesusva'ea pe Nazarépeva'ea pe, ei g̃a. Jesusva'ea ko Tupana'ga nhi'ig̃a mombe'uharava'ea, ei g̃a. Ipopoaka hete ahe japovo ahemonhimomby'ava'ea nhandegwyripeve'g̃a mbo'eavo Tupana'ga nhi'ig̃a rehe. Jukwaha a'ero Tupana'ga nhimohema ahe rehe. Horyory nhandegwyripeve'g̃a ahe rehe no ga ipopoaka hete javo. ");
INSERT INTO pahNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Ikwava'ẽhara'g̃a nduvihava'g̃a nhanderuvihava'g̃a pavẽi omondo Jesusva'ea Pilatos'ga po pe te'i ti ga pembovy ti Jesus'ga javo. G̃a ahe mbovyruka yva rehe ahe jukauka. ");
INSERT INTO pahNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","—Ore ki a'e te ore roryroryvamo ahe rehe novĩa. Oroyvyteri pe ore ei: Tupana'ga ga mbuhuruka nhande pyri israelitasva'ea pyri embopiro'y ti g̃a javo. A'ea ore ei novĩa. A'ereki g̃a ahe jukauka. Kiro mokõi ahe kiri omanorẽ. ");
INSERT INTO pahNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","—Oro kunhangwera'g̃a – kiroki g̃a ojiko Jesusva'ea rehe ore ja – g̃ahã ore monhimomby'a hete oji'i. Oho jipe g̃a ypyhaji ve ovahema itaruvihavuhua kwaruhu pe ahenongai pe oji'i. ");
INSERT INTO pahNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Ndohepiagi g̃a Jesusva'ea ra'oa ipype. A'ero g̃a jivyri ore pyri imombe'gwovo. E'i g̃a: “Yvagipeve'g̃a Tupana'gapyrive'g̃a ojipiuka ore ve Jesus'ga mombe'gwovo!” ei g̃a. “‘Okoji Jesus'ga,’ ei Tupana'gapyrive'g̃a ore ve.” A'ea kunhangwera'g̃a ei oji'i. ");
INSERT INTO pahNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","A'ero orepyteripeve'g̃a hoi ikwaruhu pe ahenongai pe hepiaga. “Kunhangwera'g̃a omombe'u katu reki ahenongavagwera ore ve ko,” ei g̃a imombe'gwovo ore ve. G̃a ndohepiagi Jesusva'ea, ei mokonha'g̃a Jesus'ga pe imombe'gwovo. ");
INSERT INTO pahNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","—Ikwahave'ymuhũva'ero pe ndaperoviapapotari Tupana'ga nhi'ig̃a mombe'uharava'ea nhi'ig̃a, ei Jesus'ga mokonha'g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Ymyahũ ahe e'i ganhi'ig̃a mombe'gwovo: “‘He'yiva'ea ti tahahy Cristo'ga pe nehẽ. Toki ti ga yvagi pe okovo g̃anduvihavuhuhetero ji pavẽi nehẽ,’ ei Tupana'ga,” ei ahe. A'ea Tupana'ga opota, ei Jesus'ga imombe'gwovo g̃a pe. A'ea pe ndaperoviari naerũ? ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","A'ero ogwovo ve g̃a pavẽi pea rupi Jesus'ga g̃a mbo'e ypy Moisésva'ea rembikwatijara rehe – kiroki a'ea omombe'u ga. Aerẽ ga g̃a mbo'ei Tupana'ga nhi'ig̃a mombe'uharava'ea rembikwatijara rehe nhaporemo – kiroki a'ea omombe'u ga no. ");
INSERT INTO pahNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Kiro g̃a ndug̃werĩ cidade'i pe. A'ea pe mokonha'g̃a ei toropyta avo javo. Jesus'ga oho g̃werĩ a'ero g̃a hugwi. ");
INSERT INTO pahNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","A'ero g̃a eg̃a'ei ga pe: —Epyta ore pyri. A'ereki ka'aru hete kiro. Ypytũ g̃werĩ. A'ea g̃a ei ga pe ga mombytavo ojipyri. Oki ga g̃anonga pype g̃a ndupi a'ero opytavo g̃a pyri. ");
INSERT INTO pahNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Aerẽ oapygame mesa pyri g̃a pavẽi ga ipyhygi pão onhi'ig̃a Tupana'ga pe hehe ndepyry hete nde imbuhua ore ve javo. Kirẽ ga haygwe'rogwe'rogi pão imondomondovo g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Kiro g̃a mbaragwahavi ga rehe a'ero ga repiaga ve. —Jesus'ga tuhẽ reki! ei g̃a. Nanime ga ndiukwahavi oka'nhyma g̃a hugwi. —Tenagwe! e te ga. ");
INSERT INTO pahNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ojohupe g̃a ei: —Ikatu hete nhandeyvyteri pe nhande mbohoryoryva ga nhi'ig̃ame nhande ve onhimombe'gwovo pea rupi nhande mbo'eavo Tupana'ga rembikwatijarukara rehe, ei g̃a. ");
INSERT INTO pahNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Kotihĩ g̃a po'ami ojivya ogwovo Jerusalém me. Ovahemame g̃a onzeve'g̃a ndepiagi. Onhimono'og̃ipe onzeve'g̃a onhipavẽive'g̃a pavẽi. Mokonha'g̃a pe g̃a ei: ");
INSERT INTO pahNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","—Nhandepojykaharete'ga okwera tuhẽ ovya onongava hugwi Jesus'ga. A'iti a! Okoji ga. Ojipiuka ga Simão Pedro'ga pe heaji'i, ei g̃a mokonha'g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","A'ero mokonha'g̃a ei g̃a pe: —Ore ga repia no. Ore horame pea rupi Jesus'ga hoi ore rupi onhimombe'gwovo ore mbo'eavo Tupana'ga nhi'ig̃a rehe. A'ea rupi ore norombaragwahavi ve ga rehe. Aerẽ ga haygwe'rogame pão ore mbaragwahavi ga rehe, ei g̃a imombe'gwovo. ");
INSERT INTO pahNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","G̃a a'ea mombe'urame nanime Jesus'ga jipiukari o'ama g̃apyteri pe. Ga e'i: —Tupana'ga ti tonog̃atu pepy'a! ei ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Anhag̃a po javo g̃a piryiro okyhyjiheteavo. ");
INSERT INTO pahNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","A'ero Jesus'ga ei g̃a pe: —Maraname pepy'a oko tehe? A'ero pe kyhyjihetei. Maraname pe ndaperoviari? “Mara'ngu po Jesus'ga tuhẽ?” pe'e pe pejiyvyteri pe, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Pehepia ti jipoa jipya reheve. Hepiagame po ti pe mbaragwahavi ji rehe a'ero. Pepyhy ti jira'oa nhikag̃a reheve ji kwahava. A'ereki anhag̃a ndaha'oi. Nikag̃i. Ji ki a'e te ji ra'oro. Ji kag̃amo, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Onhi'ig̃irẽ ga hepiukari g̃a pe opoa opya reheve. ");
INSERT INTO pahNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Gworygworyva g̃waramo g̃a ndogweroviari ve. A'ereki g̃a e'i oyvyteri pe onhimomby'avo: “Po Jesus'ga tuhẽ, a'ero pyry hete!” ei g̃a. G̃a nhimomby'arame Jesus'ga ei g̃a pe: —Ndaperekoi pe mbatera? Ta'u ji. ");
INSERT INTO pahNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Pira g̃a imondoi ga pe a'ero hehyripyra heiretea reheve. ");
INSERT INTO pahNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Ipyhyga ga i'ui g̃a gwepiagame. ");
INSERT INTO pahNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Aerẽ ga ei g̃a pe: —Ymya'ĩ ji nhimombe'umbe'ui pe me jiruvame pe pyri. A'e ji pe me: Moisésva'ea remimbo'eagwera aherembikwatijaripyra ji mombe'u Tupana'ga nhi'ig̃a mombe'uharava'ea rembikwatijaripyra pavẽi, a'e ji pe me. Ji mombe'ui no ikwatijaripyra Salmos, a'e ji ikwehe. Tako pa ti ji ikwatijaripyra rupi nehẽ – kiroki a'ea ji mombe'u, a'ea'e ji pe me ikwehe, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Kiro ga ikwahavukari g̃a pe Tupana'ga nhi'ig̃a aherembikwatijaripyra. ");
INSERT INTO pahNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Imombe'gwovo ga ei: —Ikwatijaripyra e'i: “Tahahy ti Cristo'ga pe. Omano po ti ga nehẽ. Mokõi okira py'rovo ti ga tokwerava'ja gwyvyagwera hugwi. ");
INSERT INTO pahNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Cristo'gareheva'ero ti g̃a tomombe'u katu Cristo'ga yvyakotyve'g̃a gwyripeve'g̃a pe nhaporemo. Te'i ti g̃a g̃a pe: ‘Tapevy'ari ti pejikote'varuhua rehe pejipohia jugwi herojijyjijyita pejeaporog̃ita. A'ero po ti Tupana'ga imombohetei pendekote'varuhua pe hugwi nehẽ ikwahava'jave'yma nehẽ.’ A'ea po ti g̃a tomombe'u katu Jerusalémmeve'g̃a pe na'ẽ. Aerẽ po ti g̃a tomombe'u katu ojipe'g̃a pe nhaporemo.” A'ea ikwatijaripyra e'i, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","—Oro pe, ei Jesus'ga g̃a pe. A'ea pe ikwahapavi. A'ero ti pemombe'u. ");
INSERT INTO pahNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Ji rendu ti! ei Jesus'ga. Ymyahũ Tupana'ga ei: “Jira'uva po ti pe pojykai nehẽ,” ei jiruva'ga pe me, ei Jesus'ga. Pepyta ti cidade de Jerusalém me gara'uva rura pota aerẽ po ti gara'uva tuhu nehẽ javo. A'ero jihi po ti gara'uva mondoukari yvaga hugwi pe pojykauka jupe pe mbopopoakaruka nehẽ, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","A'ero Jesus'ga hoi g̃a nenonde g̃a nderogwovo cidade de Betânia kotyi ve. Opoa mondovo g̃a pe ga ei Tupana'ga pe: —Emombyry ti g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Onhi'ig̃a ve Tupana'ga pe ga hoi g̃a hugwi. Kiro garerohohava yvaga pype. ");
INSERT INTO pahNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ombohete g̃a ga. Kirẽ g̃a jivyri ogwovo Jerusalém me gworygworyhetero. ");
INSERT INTO pahNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Nane'ymi g̃a hoi opytavo ojatykahavuhua pype Tupana'ga mboheteavo ndepyry hete nde javo.");
INSERT INTO pahNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Jypya yvya apoa renonde Tupana'ga reaporog̃ita kwahavukahara'ga rekojipei hako. Tupana'ga pyri ga ruvi ga rerekovo. Ga ko Tupanamo tuhẽ oko. ");
INSERT INTO pahNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Yvya apoa renonde akoja'ga rekoi Tupana'ga pavẽi gakwahavukahara'ga. ");
INSERT INTO pahNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Ga pe Tupana'ga oapopavuka mbatera. Ojipe'g̃a pe rũi Tupana'ga oapouka. Okwahavukahara'ga pe jate ga oapouka mbatera hako. ");
INSERT INTO pahNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Tupana'ga kwahavukahara'ga tuhẽ oko po rimba'e. A'ero ga jara'g̃a mongopavi g̃a monguva. Ga yvyakotyve'g̃a mongoi. A'ero ga Tupana'ga kwahavukari g̃a pe no. Arimo nhande tihepia katu mbatera kwahavag̃wama mytu'ẽro g̃waramo. Na ja ga imomytu'ẽi yvyakotyve'g̃a akag̃i pe tokwaha ti g̃a Tupana'ga javo. ");
INSERT INTO pahNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ypytunarupive'g̃a ndokwahavi hepiage'yma g̃waramo. Ypytunarupive'g̃a'jave'g̃a – g̃a ndokwahavi Tupana'ga okote'varuhuavo – g̃a pe ga Tupana'ga mombe'umbe'ui no tokwaha ti g̃a ga javo. G̃a omombi pota Tupana'ga kwahavag̃wama novĩa. Ndopigi reki. A'ereki Tupana'ga mombe'ua ikwahy ve ojipe'g̃a ndehe ga kwahavuka g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Nahã ko ahe ikwehe. Ahe ve g̃a ei João Batista. Tupana'ga e'i ahe ve: —Emombe'u ti g̃a pe jikwahavukahara'ga, ei Tupana'ga ahe ve. ");
INSERT INTO pahNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","A'ero Joãova'ea ruri ga mombe'gwovo ikwehe. —Tamombe'u ti ga pe me tapejiko pa ti ga rehe javoji, ei ahe, kiroki ga Tupana'ga kwahavuka nhande ve, ei Joãova'ea ikwehe. ");
INSERT INTO pahNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Ahe ko imomytu'ẽhara'ga rũi. —Akoja'ga mombe'gwovo reki ji ruri, ei ahe, kiroki ga omomytu'ẽ Tupana'ga kwahavuka nhande ve, ei Joãova'ea ikwehe. ");
INSERT INTO pahNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Gaha ko imomytu'ẽharetero. A'ero ga ruri imomytu'embava yvyakotyve'g̃a akag̃i pe tokwaha pa ti g̃a Tupana'ga javo. ");
INSERT INTO pahNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Yvya koty ga ruvi ikwehe. A'ea tuhẽ Tupana'ga oapouka ga pe hako yvyakotyve'g̃a ndeheve. Yvyakotyve'g̃a ki a'e te ndogweroviari ga. ");
INSERT INTO pahNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ogwyri pe ga ruri ikwehe gwe'yja'g̃a pyri judeus'g̃a pyri. G̃a ki a'e te ndokoi ga rehe. ");
INSERT INTO pahNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Kiroki g̃a oko reki ga rehe – g̃a pe ga ei a'ero: “Pejiko pe ji rehe,” ei ga. “Kiro ji pe mongoi Tupana'ga ra'yramo a'ero,” ei ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Yvyakotyve'g̃a ko na ta'y. Akwaimbae'g̃a ta'y pota g̃wembireko'g̃a nderekovo. Aerẽ g̃anda'yra'g̃a ari g̃a hugwi a'ero. Na rũi reki ga nhande mongoi Tupana'ga ra'yramo. Nhande xajiko Tupana'ga kwahavukahara'ga rehe. A'ero Tupana'ga ei nhande ve: “Jira'yramo ko pe ndekoi kiro pejikoga g̃waramo ga rehe,” ei Tupana'ga. ");
INSERT INTO pahNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Tupana'ga kwahavukahara'ga onhimongouka yvyakotyva'ero a'ero ikwehe Jesus Cristo'ga. Igwete ga ruvi orepyteri pe ikwehe. Ga nhande arõ hete imombyryva nhande ve. Ga okwahavuka katu Tupana'ga nhande ve no. A'ereki ga jate ko Tupana'ga ra'yretero. Igwete ore nhimombaragwahavi garuvihavuhuhetea rehe garuva'ga ruvihavuhuhetea rehe. ");
INSERT INTO pahNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","João Batistava'ea omombe'umbe'u ga ikwehe. Ahe e'iahy g̃a pe ikwehe: —Gaha ji amombe'u pe me oji'i, ei ahe. “Aerẽ po ti ga ruri pe nderekovo nehẽ,” a'e ji oji'i, ei ahe. “Ga huvihavuhuhetero. Ji ki a'e te ako tehe reki. Jypya vehevi ji rekoe'ymame ga okoe'ymi,” a'e ji pe me oji'i, ei Joãova'ea ikwehe. ");
INSERT INTO pahNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Ga pyry hete tuhẽ nhande aromo. A'ero nhande ve nhaporemo ga imombyryvi jipi. Igwaigwavete ga imombyryva'ja'javi nhande ve. ");
INSERT INTO pahNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Moisésva'ea pe Tupana'ga ombuhuruka onhi'ig̃a hako tohendu katu ti g̃a javo. Jesus Cristo'ga pe ki a'e te Tupana'ga nhande arõheteuka. —Emombyry ti g̃a pe, ei Tupana'ga ga pe. Ji kwahavuka katu ti g̃a pe no, ei ga Jesus Cristo'ga pe. Na tuhẽ Jesus Cristo'ga rekoi a'ero. ");
INSERT INTO pahNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Yvyakotyve'g̃a ndohepiagangavi Tupana'ga. Gara'yra'ga jate – ga tehe ko Tupana'ga ra'yretero – gaha jate koi ojikoty'a Tupana'ga pavẽi. Gaha okwahakatuuka Tupana'ga nhande ve a'ero. ");
INSERT INTO pahNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","28","Igwete judeus'g̃a nduvihava'g̃a g̃a mbuhurukari ojipyri mbatera kwava'ẽhara'g̃a – g̃a okwava'ẽ mbatera Tupana'ga pe jipi. Igwete g̃a ei g̃a pe g̃apokohara'g̃a pe no levitas'g̃a pe. G̃a pe – g̃a ko fariseus'g̃a – g̃a pe judeus'g̃a nduvihava'g̃a ei: —Peho ti João Batista'ga pyri tonhimombe'u ti ga pe me nehẽ, ei g̃a g̃a pe. A'ero g̃a hoi cidade de Jerusalém hugwi ogwovo João Batistava'ea pyri – perope ahe g̃a mobatiza paranahũa aherovai Jordão aherovai. Cidade de Betânia ira'agwe te jugwi. Pevo g̃a hoi javo Joãova'ea pe. —Mome ahe nde? ei g̃a ahe ve. Enhimombe'u ti ore ve torokwaha ti nde, ei g̃a. Ahe ni'mbei g̃a pe a'ero. Onhimombe'u katu ahe g̃a pe tajikwaha ti g̃a javo. —Ji ko ga rũi – kiroki ga pe Tupana'ga e'i: “Amondo po ti ga yvyakotyve'g̃a pyri g̃anduvihavuhuhetero nehẽ Cristo'ga,” ei ga. Ji ko ga rũi, ei ahe. —Marã naerũ? ei g̃a ahe ve. Nde po Eliasva'ea ekwerava ejyvya hugwi? ei g̃a. —Ji ko ahe rũi, ei ahe. —Nde ereko Tupana'ga nhi'ig̃a mombe'uharamo a'ero – kiroki ga Moisésva'ea omombe'u hako uhu ti ga javo hako? ei g̃a ahe ve. —A'ea rũi ko ji, ei ahe. —Mome ahe nde naerũ? Enhimombe'u ti ore ve toromombe'u ti g̃a pe – kiroki g̃a ore mbuhu nde pyri, ei g̃a. Marã ti nde nhimombe'ui ore ve nehẽ? ei g̃a ahe ve. —Pehendu ti nhinhi'ig̃a a'ero, ei ahe. Tupana'ga nhi'ig̃a mombe'uharava'ea Isaíasva'ea omombe'u nhog̃wenonde ojipe'ga rembi'eag̃wama hako, ei Joãova'ea. Nahã Isaíasva'ea ei hako: “Ojipe'ga nhi'ig̃a po ti hahyahi ga erame g̃a mbo'eavo ongae'ỹi me nehẽ,” ei ahe. “E'i po ti ga g̃a pe: ‘Pemboavujikwe ti pehea imbohupikatuavo huvihava'ga pe tuhu ti ga nhande pyri javo,’ e po ti ga,” ei Isaíasva'ea hako, ei ahe. Jihi ko a'ea, ei Joãova'ea onhimombe'gwovo g̃a pe. A'eahy ji javo ojipe'g̃a pe: “Penhimboavujikwe ti pejipohia pejikote'varuhua hugwi tuhu ti nhandepojykaharete'ga nhande pyri javo,” a'e ji, ei Joãova'ea onhimombe'gwovo g̃a pe. A'ero g̃a ei ahe ve: —Marã a'ero? Nahã nde ei ore ve: “Ji ko Cristo'ga rũi Tupana'ga remimbuhurukara'ga rũi,” ere ko nde, ei g̃a. “Eliasva'ea rũi ko ji no,” ere ko nde, ei g̃a. “Ji ko akoja'ga rũi Tupana'ga nhi'ig̃a mombe'uhara'ga rũi,” ere ko nde ore ve, ei g̃a. Maranuhũrame nde okoteheva'ero g̃a mobatizai naerũ? ei g̃a Joãova'ea pe. —Jihi amobatiza g̃a yhya pyvõ jipi, ei ahe. Pepyteri pe ojipe'ga ami okovo. Emo pe ndapekwahavi ga, ei ahe g̃a pe. Gaha po ti oko pe pyri huvihavuhuhetero nehẽ, ei ahe. Huvihavuhu hete tuhẽ ga, ei ahe. Ji ki a'e te okoteheva'ea, ei Joãova'ea g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Ko'emame Joãova'ea Jesus'ga repiagi ga rurame ojipyri. A'ero ahe ei jara'g̃a pe: —Pehepia ga! ei ahe. Pevo ga rekoi – kiroki ga cordeiro ja, ei ahe. Ikwava'ẽhara'g̃a ojuka cordeiros jipi Tupana'ga ti tomombo nhanderekote'varuhua a'ero javo, ei ahe. Cordeiro ja po ti ga manoi nehẽ no. A'ereki Tupana'ga ga mbuhuruka nhande pyri tomano ti ga imomboa yvyakotyve'g̃a ndekote'varuhua javo, ei Joãova'ea g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Amombe'u ji ga pe me oji'i cordeiro'jave'ga, ei ahe. “Pe pyri po ti ga rekoi jihoheva'ero. A'ereki jypya vehevi ji rekoe'ymame ga okoe'ymi po rimba'e,” a'e ji pe me oji'i, ei ahe Jesus'ga mombe'gwovo g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","—Ymya ji ei: “Ma'g̃a po ti Tupana'ga ombuhuruka nhande pyri nehẽ tomombo ti ga g̃andekote'varuhua javo?” ei ahe. Kirog̃we ji ga kwahavi. A'ero ji ga kwahavukari jire'yja'g̃a pe israelitas'g̃a pe. Nurã ji ruri pe mobatizavo yhya pyvõ tapekwaha ti ga javo, ei Joãova'ea g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","33","Igwete Joãova'ea Jesus'ga mombe'ukatui g̃a pe: —Ndakwahavi ypy ji ga ma'g̃a po ti Tupana'ga ombuhuruka javo, ei ahe. Emo Tupana'ga – gaha ji mbuhuruka g̃a mobatizauka yhya pyvõ – ga e'i ji ve: “Erehepia po ti nde jira'uva rura ga pyri nehẽ. Ojy po ti jira'uva opytavo ga pyri nehẽ,” ei Tupana'ga ji ve, ei ahe. “Gaha po ti aerẽ pe pojykauka jira'uva pe nehẽ a'ea ti tapemongo Jesus'gareheva'ea javo,” ei Tupana'ga ji ve, ei ahe. Ahepia tuhẽ ji Tupana'ga ra'uva rura a'ero oji'i, ei ahe. Inambua ja koi ijyvi yvaga hugwi opytavo ga pyri oji'i. ");
INSERT INTO pahNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ahepia tuhẽ ko ji oji'i, a'e ji, ei ahe. Nurã ji ei pe me: Akoja'ga tuhẽ koi Tupana'ga ra'yra'ga, ei Joãova'ea. ");
INSERT INTO pahNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Ko'emame Joãova'ea rekoa'javi onhi'ig̃a mokonha'g̃a pavẽi g̃wemimbo'ehara'g̃a pavẽi o'ama. ");
INSERT INTO pahNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Igwete ahe hepiagi Jesus'ga kwava. —Pevo ga hoi cordeiro'jave'ga! ei Joãova'ea ga mombe'gwovo g̃a pe. Cordeiro ja po ti ga manoi nehẽ. A'ereki Tupana'ga ombuhuruka ga nhande pyri tomano ti ga g̃andekote'varuhua imomboa javo, ei ahe. ");
INSERT INTO pahNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","40","Joãova'ea remimbo'ehara'g̃a g̃wendu memei ahenhi'ig̃a André'g̃a. A'ero g̃a hoi Jesus'ga reviri. Igwete Jesus'ga jirovagi g̃a ndepiaga gweviri. —Gara? ei ga. —Mome nde ruvi? ei g̃a ga pe. —He pejijo hepiaga, ei ga g̃a pe. A'ero g̃a hoi ga rupi garuhava repiaga. Ka'aru quatro horas rupi g̃a hoi. Igwete g̃a nhomonhi'inhi'ig̃i upa kwara hoa rupi. ");
INSERT INTO pahNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Kiro André'ga hoi na'ẽ oirũ'ga pyri Simão Pedro'ga pyri. —Orohepia ore Messias'ga Tupana'ga remimbuhurukara'ga, ei ga Simão'ga pe. (Cristo'ga pe judeus'g̃a e'i Messias.) ");
INSERT INTO pahNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","A'ero André'ga Simão'ga reruri Jesus'ga pyri. Simão'ga repiagame Jesus'ga ei ga pe: —Ndehe ko Simão João'ga ra'yra, ei Jesus'ga ga pe. Cefas po ti nderera nehẽ, ei ga Simão'ga pe. (Cefas'ga pe judeus'g̃a e'i Pedro. A'ea ko Ita.) ");
INSERT INTO pahNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Ko'emame Jesus'ga ei: —Taho ti Galiléiapeve'g̃a gwyri pe. Oho na'ẽ ga Filipe'ga pyri. —Herejo ji rupi nhiremimbo'eharamo, ei ga Filipe'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filipe'ga ko cidade de Betsaidapeve'ga – perope André'ga u Pedro'ga pavẽi. ");
INSERT INTO pahNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Aerẽ Filipe'ga hoi Natanael'ga pyri javo. —Orohepia ore ga – kiroki ga Moisésva'ea omombe'u ikwatijarame g̃wemimbo'eagwera hako, ei Filipe'ga ga pe. Tupana'ga nhi'ig̃a mombe'uharava'ea okwatija ga no ga mombe'gwovo hako, ei ga. Ga tuhẽ ore orohepia. Ga ko Jesus'ga Joséva'ea ra'yra'ga. Cidade de Nazaré pe ga ruvi, ei ga Natanael'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","—Nazaré! ei Natanael'ga. Imombyryva'ea nduri tuhẽ pea hugwi, ei ga ga pe. —Herejo xaho ji rupi a'ero terehepia ti ga, ei Filipe'ga ga pe. ");
INSERT INTO pahNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Natanael'ga rurame Jesus'ga ga repiagi. —Kiro ki ga u israelitapyryvamo, ei Jesus'ga ga mombe'gwovo. Ga ni'mbeangavi jipi ojipe'g̃a moandyje'yma, ei ga Natanael'ga mombe'gwovo. ");
INSERT INTO pahNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","—Marã nde ikwahavi jireaporog̃ita naerũ? ei Natanael'ga ga pe. A'ero Jesus'ga ei ga pe: —Irupe ko nde rekoi oji'i novĩa, ei ga. Filipe'ga ea renonde nde ve ji orohepia reki. Figueira ag̃i pe nde reni, ei Jesus'ga ga pe. ");
INSERT INTO pahNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","—Jesus, ei Natanael'ga. Tupana'ga ra'yra tuhẽ ko nde! ei ga. Nde ko israelitas'g̃a nduvihavuhuhetea tuhẽ! ei ga Jesus'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Igwete Jesus'ga ei ga pe a'ero: —A'e ko ji nde ve ko: “Orohepia ko ji nde rename figueira ag̃i pe.” A'ero nde jikogi ji rehe, ei Jesus'ga ga pe. Aerẽ po ti ji koji'iheteva'ea japoi nehẽ ahemonhimomby'aheteva'ea nehẽ. A'ea po ti nde erehepia nehẽ no, ei ga Natanael'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Igwete Jesus'ga ei g̃a pe: —Tamombe'u katu tuhẽ kiro pe me, ei ga. Tamombe'u ti jijihe'ara Tupana'ga rehe, ei ga. A'ea'java'ea ko nahã a'ero. Pehepia po ti pe yvaga rovapytymba'vogipyra, ei ga. Pehepia po ti pe Tupana'gapyrive'g̃a jiupiupira g̃ajivyjivyra ji pyri nehẽ no, ei ga. Nahã ko ji ajihe'a Tupana'ga rehe nhiremimbuhurukara'ga rehe, ei Jesus'ga. Oronhomonhi'inhi'ig̃e'ymi ore orojogwerekokatuavo ga pavẽi. Nahã po ti pe me nehẽ no, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","2","Mokõi Jesus'g̃a kiri ogwovo toryvi pe cidade de Caná pe – perope Galiléiapeve'g̃a gwyri pe. A'ereki g̃a Jesus'ga mondouka g̃anembirekohava repiagauka. G̃a Jesus'ga remimbo'ehara'g̃a mondouka no. Igwete Jesus'g̃a hoi hepiaga toryva. Jesus'ga yembora pevo oko g̃a pyri no. Toryva apopave'ymame momina g̃a hugwi vinho. ");
INSERT INTO pahNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","A'ero Jesus'ga yembora ei Jesus'ga pe: —Momina kiro vinho g̃a hugwi, ei ahe Jesus'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","—Maraname nde ei ji ve kiro a'ea rehe? ei ga ahe ve. A'ereki ndohoi ve hepiukara apiavo. Ag̃wamo rũi po ti ji hepiukapavi Tupana'ga popoakara g̃a pe nehẽ, ei ga o'yembora pe. ");
INSERT INTO pahNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Igwete ahe ei g̃a pe – kiroki g̃a opoko toryva repiakatuhara'ga – g̃a pe ahe ei: —Jira'yra'ga erame pe me penhi'ĩpo'ru ti ga, ei ahe g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Pevo gwereko yhya ryrua ita apopyra. A'ereki judeus'g̃a nane'ymi ojipyhepyhei. Oheohei g̃a mbatera jipi no nahã nhande nhimombyryvi Tupana'ga pe javo. Nurã gwereko pevo mbohapyrete seis yhya ryrua. Inainani gwereko he'yjuhu cem litros gwerevi ipype tynahemame. ");
INSERT INTO pahNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Igwete Jesus'ga ei hepiakatuhara'ga pokohara'g̃a pe a'ero: —Peheka'voka'vo ti yhya ipype. Pemotynahẽ hete ti imohina, ei ga. A'ero g̃a imotynahenahẽhetei inog̃a hyrua pype. ");
INSERT INTO pahNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Igwete ga ei g̃a pe: —Pejara ti kiro yhya herogwovo toryva repiakatuhara'ga pe, ei ga g̃a pe. A'ero g̃a herohoi yhya ga pe to'u ti ga hepiaga javo. ");
INSERT INTO pahNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Yhya rũi reki ga i'urame. Vinho reki yhya mbotepyra ga i'ui hepiaga. Ndokwahavi ga yhya mbotea vinhoramo. Gapokohara'g̃a ki a'e te okwaha hete Jesus'ga remimbotea. Igwete ga i'ui hepiaga. A'ero ga hembirekove'ga mbuhurukari ojipyri javo ga pe. ");
INSERT INTO pahNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","—Nde ko ore atyvi, ei ga hembirekove'ga pe. Ore oromondo ypy vinho heheva'ea toryvarupive'g̃a pe, ei ga. Kirẽ g̃a i'uheterame ore imondoi ndaheiva'ea g̃a pe. A'ereki i'uheterame g̃a nonhimombaragwahavi ndaheiva'ea rehe. Nde ki a'e te nerembuhuri ypy heheheteva'ea kirog̃we imbuhua ore ve, ei ga ga pe. ");
INSERT INTO pahNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Jesus'ga ombote yhya vinhoramo cidade de Caná pe Galiléiapeve'g̃a gwyri pe ikwehe. A'ea ypy ga oapo ahemonhimomby'ava'ea hepiuka g̃a pe gweaporog̃ita Tupanamo. Nurã garemimbo'ehara'g̃a jikohetei ga rehe. ");
INSERT INTO pahNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Aerẽ Jesus'g̃a hoi cidade de Cafarnaum me. Ga'yembora oho gairũ'g̃a pavẽi. Garemimbo'ehara'g̃a oho g̃a ndupi no. Pevo g̃a pytaahi'vi upa. ");
INSERT INTO pahNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Aerẽ Jesus'g̃a hoi cidade de Jerusalém me. A'ereki judeus'g̃a toryva gwereko g̃werĩ. Páscoa ei g̃a akoja pe. A'ea rupie'ymi judeus'g̃a japyakai uragwera rehe Egitopeve'g̃a gwyra hugwi. ");
INSERT INTO pahNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Igwete Jesus'ga hoi judeus'g̃a jatykahavuhua rokari pe g̃a ndepiaga. Pevo g̃a ndekoi ima'ema'eamo mbatepyryva itambere'ia pyhyga g̃a hugwi. Yuranuhũa bois g̃a ima'ema'ẽi ovelhas. Inambu'ia g̃a ima'ema'ẽi upa. Mesa pyri jara'g̃a neg̃aneni hajiheve'g̃a itambere'ia ipyhypyhyga judeus'g̃a itambere'ia ikwepykwepyga imondovo g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","G̃a ndepiagame Jesus'ga japoi yhypohama g̃a nupanupamo ipyvõ g̃a mo'embava g̃a mondovo ojatykahavuhua rokara hugwi. Ovelhas ga imo'emo'ẽi, bois ga imo'emo'ẽi imonhamonhana imondovo. Ombojirejire ga itambere'ia kwepykara'g̃a mesa heka'voka'vogauka g̃aitambere'ia jugwi. ");
INSERT INTO pahNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Igwete ga ei g̃a pe – kiroki g̃a oma'ema'ẽ inambu'ia: —Peroho ti kia jugwi! a'e te ji, ei ga. Tapema'ema'ẽa'javuhui mbatera avo jiruva'ga ronga pe! ei ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","A'ero garemimbo'ehara'g̃a ikwahava'javi Tupana'ga rembikwatijarukara. Igwete g̃a ei ojohupe: —A'ea pe reki ikwatijara i'ei Cristo'ga nhi'ig̃a mombe'gwovo, ei g̃a. Nahã Cristo'ga nhi'ig̃a Tupana'ga pe hako: “Nhi'ag̃ataruhu ji neronga rehe jipi toko katu ti g̃a ipype javoji,” ei ga. “Nhi'ag̃ataruhua ji juka hete,” ei ga, ei g̃a. Ikwatijara omombe'u jipe Cristo'ga nhi'ig̃ag̃wama, ei Jesus'ga remimbo'ehara'g̃a. ");
INSERT INTO pahNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Kiro judeus'g̃a nduvihava'g̃a nduri javo Jesus'ga pe a'ero. —Ma'g̃a nde mbuhurukaruhu g̃a mo'ẽukarag̃wama avo hugwi? ei g̃a. Po Tupana'ga nde mbuhurukari, a'ero po ti nde hepiukari gapopoakara ore ve ahemonhimomby'ava'ea japovo, ei g̃a. A'ero po ti ore nde reroviari nehẽ Tupana'ga tuhẽ ga mbuhuruka javo, ei g̃a Jesus'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Igwete Jesus'ga ei g̃a pe a'ero: —Po ti pe imbojypavi ag̃a Tupana'ga ruhava imbote'varuhuavo nehẽ, aerẽ mokõi nhande kirame ti ji imbovyra'javi imohina nehẽ, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Igwete judeus'g̃a nduvihava'g̃a ei ga pe: —Nde ki ere'eteheuhu, ei g̃a. He'yjuhuva'ea rupi quarenta e seis anos rupi g̃a poravykyvykyi japovo ag̃a Tupana'ga ryrua, ei g̃a. Marã po nde gwehu kotihĩ japoa'javuhui imohina mokõi nhande kirame naerũ? ei g̃a ga pe. ");
INSERT INTO pahNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Gwa'oa pe reki Jesus'ga ei a'ea ko Tupana'ga ruhava javo. ");
INSERT INTO pahNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Aerẽ Jesus'ga vyrame omanoa hugwi garemimbo'ehara'g̃a ikwahava'javi ga'eagwera. A'ero g̃a heroviari ga'eagwera Jesus'ga onhimombe'u katu javo. Igwete g̃a heroviari Tupana'ga rembikwatijarukara ahe ve no Jesus'ga ahe omombe'u ga kwatija javo. ");
INSERT INTO pahNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Toryva rupi Páscoa rupi Jesus'ga rekoi cidade de Jerusalém me a'ero. Igwete ga hepiukari Tupana'ga popoakara g̃a pe ahemonhimomby'ava'ea japovo. Nurã g̃a jikojikogi ga rehe onhimongyavo. ");
INSERT INTO pahNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Jesus'ga ki a'e te ndojikogi g̃a ndehe a. A'ereki ga okwahapavipe yvyakotyve'g̃a py'a. ");
INSERT INTO pahNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Ga nde'i ojipe'g̃a pe: “Marã g̃andeaporog̃ita?” A'ea ga nde'i. A'ereki ga okwahapavipe g̃a a. ");
INSERT INTO pahNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","2","Aerẽ Nicodemos'ga ruri Jesus'ga pyri ypytunimo. Ga ko judeus'g̃a mog̃itahara'ga fariseu'ga. Aerẽ ga ruri Jesus'ga pyri xanhomonhi'ĩ ti javo. —“Gaha ko nhanembo'ehara,” oro'e ore nde ve, ei ga Jesus'ga pe. “A'ereki Tupana'ga ga mbuhuruka nhande pyri tombo'e ti ga g̃a javo,” oro'e ore nde ve, ei ga. Tupana'ga opokogame jate g̃a hepiukari Tupana'ga popoakara nde ja ahemonhimomby'ava'ea japovo, ei ga ga pe. Nurã ore ei: “Tupana'ga ombuhuruka ga rerekovo,” oro'e ore, ei Nicodemos'ga ga pe. ");
INSERT INTO pahNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Igwete Jesus'ga ei ga pe a'ero: —Tamombe'u katu tuhẽ kiro nde ve, ei ga. Kiroki g̃a ojihuva'ja – g̃a pe jate po ti Tupana'ga ei: “Jihi ko g̃anduvihavuhuhetero,” ei Jesus'ga ga pe. ");
INSERT INTO pahNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Igwete Nicodemos'ga ei a'ero: —Marã po jyvuakave'g̃a jihuvi naerũ? ei ga. Maranuhũ po g̃a kia'javi oy'g̃a yvyteri pe o'ara'java naerũ? ei ga Jesus'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Igwete Jesus'ga ei ga pe: —Tamombe'u katu tuhẽ nde ve. Penhimobatizauka po pe yhya pyvõ imomboruka pejikote'varuhua pejihugwi hamo, ei ga. Tupana'ga ra'uva po pe mboheaporog̃ita pyahu hamo no, ei ga. Nane'ymame po ti Tupana'ga ndokoi penduvihavuhuhetero nehẽ penhimobatizaukare'ymame yhya pyvõ gara'uva pe mboheaporog̃itapyahue'ymame nehẽ no, ei Jesus'ga ga pe. ");
INSERT INTO pahNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Nhaney'g̃a nhande mbojihuvame nhande mbo'a, nhandera'o nhande a'ero yvyakotyva'ero, ei ga. Tupana'ga ra'uva nhande mboheaporog̃itapyahurame jate nhande reaporog̃itapyahuro a'ero, ei Jesus'ga ga pe. ");
INSERT INTO pahNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Terenhimomby'auhui ti nhiremimombe'uagwera rehe ji erame nde ve: “Pejihuva'ja ti.” Nahã ti pe ndeaporog̃itapyahuro nehẽ. Erovia ti nhinhi'ig̃a, ei ga Nicodemos'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Nahã ko yvytua, ei ga. G̃wemimbotarimo uhu okookovo. Pehendu pe tura novĩa. Emo pe ndapekwahavi ma hugwi te turi javo. “Mome po ti ihoi nehẽ?” pe'ji pe no, ei ga. A'ea javijitehe ko Tupana'ga ra'uva ahe mboheaporog̃itapyahurame, ei ga. G̃wemimbotarimo gara'uva rekorekoi. Emo pe ndapekwahavi marã javo. “Ma'g̃a po ti gara'uva g̃a mboheaporog̃itapyahu kiro nehẽ?” pe'ji pe, ei Jesus'ga ga pe. ");
INSERT INTO pahNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","—Maranuhũ nanongara? ei Nicodemos'ga. Ndakwahavi ji a'ea, ei ga ga pe. ");
INSERT INTO pahNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","—Ndehe ko israelitas'g̃a mbo'ehara novĩa. Nde nderekwahavi a'ea naerũ? ei ga Nicodemos'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Tamombe'u katu tuhẽ nde ve, ei ga. Oromombe'u ore pe me orerembikwahavipyra. Orerembiepiagipyra ore oromombe'u pe me novĩa. Emo pe ndaperoviarihu oreremimombe'uagwera, ei Jesus'ga ga pe. ");
INSERT INTO pahNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Yvyakotyva'ea ji amombe'u pe me. Emo pe ndaperoviari, ei ga. Ndaperoviari kaitu po ti pe nhinhi'ig̃a nehẽ ji imombe'urame yvagipeva'ea pe me nehẽ, ei ga Nicodemos'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Ndajiupihavi yvagi pe ikwahava mbatera ojyva imombe'gwovo, ei ga. Jihi jate reki ajy pea hugwi imombe'gwovo a'itituhẽva'ea pe me. A'ereki Tupana'ga ji mbuhuruka kokoty, ei Jesus'ga imombe'gwovo Nicodemos'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Igwete Jesus'ga Moisésva'ea mombe'ui no. A'ereki ymya Tupana'ga e'i Moisésva'ea pe hako: “Eapouka ti mboja ra'angava imbovya yva rehe imo'ama,” ei ga ahe ve hako. Ongae'ỹi me ahe imbovyri ha'angava imohina a'ero tohepia ti mboja rembihu'upyra'g̃a javo. Kiroki ahe ojovavu hepiaga imohinipyra – oka'ẽ ahe hugwi. Nomanoi ahe a'ero. Aerẽ Tupana'ga ei: “Moisésva'ea ombovyruka mboja ra'angava yva rehe hako,” ei ga. “Na jitehe po ti g̃a ga mbovyri yva rehe no. A'ero po ti g̃a ga jukai nehẽ,” ei Tupana'ga gwa'yra'ga mombe'gwovo hako. ");
INSERT INTO pahNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Nahã Tupana'ga ga momanoukari toko pyahu ti g̃a javo – kiroki g̃a ojiko ga rehe. Aerẽ po ti g̃a ndekoi Tupana'ga pyri yvagi pe nehẽ no. ");
INSERT INTO pahNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","A'ereki Tupana'ga oarõ hete yvyakotyve'g̃a. A'ero ga gwa'yra'ga mbuhuri yvyakotyve'g̃a pyri ikwehe. Gara'yra'ga ko ojipeji hete ko ga rekoi ga pe. Emo Tupana'ga ga mbuhuri nhande pyri ga momanomouka nhande repyga toho ti g̃a yvagi pe nehẽ javo. Nurã nhandejikogame Tupana'ga ra'yra'ga rehe po ti nhande rekoi Tupana'ga pyri avuirama nehẽ. Ndiahoi po ti nhande hahyva'ea ruvihava pype a'ero nehẽ nhanemanorame nehẽ. ");
INSERT INTO pahNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Gwa'yra'ga mbuhurame nhande koty Tupana'ga nde'i ga pe: “Eho ti g̃a pyri peko te'varuhu pe javo g̃a pe.” Tupana'ga nde'i a'ea gwa'yra'ga mbuhurukarame nhande koty. A'ereki ga gwa'yra'ga mbuhuruka avo togweru po ti ga g̃a ji pyri nehẽ javo. ");
INSERT INTO pahNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","G̃a jikogame gara'yra'ga rehe Tupana'ga nde'ia'javi g̃a pe: “Peko te'varuhu pe.” G̃a jikoge'ymame Tupana'ga e'i jipe a'ea g̃a pe. Oko te'varuhu tuhẽ nanongara'g̃a. A'ereki g̃a ndojikogi Tupana'ga ra'yra'ga rehe – ga ojipeji oko gara'yretero. ");
INSERT INTO pahNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Nahã a'ero. Mytu'ẽrame nhande ve nhande hepiagi mbatera ikwahava. A'ea'java'ea pe Cristo'ga ei a'ero urame yvya koty. “Tamomytu'ẽ ti g̃a pe, ei ga. A'ero po ti g̃a Tupana'ga kwahavi okovo katu nehẽ,” ei ga novĩa. Emo g̃a ndokwahapotari Tupana'ga. A'ereki g̃a okote'varuhue'ymi. Oko hete g̃a okote'varuhua rehe jate a'ero – a'ea ypytuna ja ndokwahavukari g̃a pe. Nurã ko Tupana'ga eag̃wama g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Okote'varuhurame g̃a ndokoi ga rehe – kiroki ga omomytu'ẽ ahe ve Cristo'ga. G̃a ndokopotari tuhẽ ga pavẽi. A'ereki g̃a e'i ojive: “Po ti ji rekoi Cristo'ga pavẽi, a'ero po ti ga imboukwahavi jirekote'varuhua nehẽ,” ei g̃a ojive. ");
INSERT INTO pahNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Jararamo ki g̃a a'e te oko Tupana'ga reaporog̃ita rupi okovo katu. Nanongara'g̃a oko pota tuhẽ Cristo'ga pavẽi – gaha okwahapavuka ahe ve. A'ereki g̃a e'i: “Ji rekorame Cristo'ga pavẽi po ti ojipe'g̃a ikwahavi jirekokatua nehẽ. A'ero po ti g̃a ei ji mombe'gwovo: ‘Tupana'ga ga poko ga mongovo g̃wemimbotarimova'ea rehe,’ e po ti g̃a ji mombe'gwovo a'ero nehẽ,” ei g̃a. Nanongara Jesus'ga imombe'umbe'ui Nicodemos'ga pe ikwehe. ");
INSERT INTO pahNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Aerẽ Jesus'ga hoi Judéiapeve'g̃a gwyri pe g̃wemimbo'ehara'g̃a pavẽi. Igwete Jesus'g̃a pytaahi'vi pevove'g̃a pavẽi g̃a mobatizatizavo. ");
INSERT INTO pahNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","A'ea rupi João Batistava'ea rekoi ojipe'g̃a mobatizavo cidade de Enom me – a'ea ojopyri u cidade de Salim pavẽi. A'ereki gwereko hete yhya pevo. Igwete pevove'g̃a hog̃ahoi ahe pyri a'ero onhimobatizavouka ahe ve. ");
INSERT INTO pahNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","A'ereki a'ea rupi soldados'g̃a nomongiukari ve Joãova'ea cadeia pype. ");
INSERT INTO pahNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Aerẽ jararamo Joãova'ea remimbo'ehara'g̃a nhi'ig̃ayvari ojipe'ga pavẽi judeu'ga pavẽi. —João'ga g̃a mobatizarame pyry hete okwahyro g̃a ndehe, ei aheremimbo'ehara'g̃a ga pe. A'ero judeu'ga ei g̃a pe: —A'ea hohe te ikwahyro g̃a ndehe Jesus'ga g̃a mobatizarame, ei ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Nurã Joãova'ea remimbo'ehara'g̃a hoi ahe pyri javo ahe ve. —Akoja'ga, ei g̃a, kiroki ga oko nde pyri paranauhũa aherovai Jordão aherovai – kiroki ga nde eremombe'u ore ve oji'i, ei g̃a, kiro ga g̃a mobatizauhui no. Ohopavuhu reki g̃a ga pyri a'ero, ei g̃a imombe'gwovo ahe ve novĩa. ");
INSERT INTO pahNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Igwete Joãova'ea ei g̃a pe a'ero: —Pyry hete reki ji ve g̃a hopavame ga pyri, ei ahe. Tupana'ga jate ombopopoakarame ahe popoakaramo a'ero okovo Tupana'ga remimbotarimova'ea rehe, ei ahe. Nurã g̃a hopavi ga pyri. A'ea ko pyry hete ji ve, ei ahe g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Pehe tuhẽ pehendu nhinhi'ig̃agwera oji'i, ei ahe. A'ereki ji a'e katu nhinhimombe'gwovo pe me oji'i. “Ji ko Cristo'ga rũi nhanderekote'varuhua mombohara'ga rũi,” a'e ko ji pe me oji'i, ei ahe. Ga renonde Tupana'ga ji mbuhurukari, ei Joãova'ea g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","—Nahã g̃a nembirekorame jipi, ei Joãova'ea. Hẽapotahara'ga tuhẽ gwereko hẽa, ei ahe. Gairũ'ga reki hẽapotahara'ga pokogi g̃anembirekoag̃wama. A'ero ga roryvamo hẽapotahara'ga nhi'ig̃a renduva hẽa rerekoa mombe'urame, ei ahe g̃a pe. Hẽapotahara'ga irũ'ga ja ko ji, a'e ji pe me. A'ereki ji Jesus'ga poko. A'ero ji roryhetero g̃a hopavame Jesus'ga pyri ga rerekovo, ei ahe g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","A'ea ko pyry a'ero, ei ahe. Igwaigwavete po ti ga rekoi tuhẽ huvihavuhuhetero nehẽ. Ji ki a'e te igwaigwavete ji rekotehei tuhẽ nehẽ, ei Joãova'ea g̃wemimbo'ehara'g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Yvateahugwive'ga ko huvihavuhuhetero oko yvyakotyve'g̃a hohe. Yvyakotyve'g̃a yvyakotyva'ea rehe jate g̃a ndekoi. A'ea rehe jate g̃a nhi'ig̃i no. Yvagahugwive'ga ko huvihavuhuhetero tuhẽ oko g̃a hohe pa. ");
INSERT INTO pahNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ga omombe'u g̃wembiepiagipyra g̃wemienduvipyra reheve. G̃a ki a'e te ndogweroviarihu ganhi'ig̃a. ");
INSERT INTO pahNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Kiroki g̃a gwerovia ganhi'ig̃a – g̃a e'i a'ero: “A'itituhẽva'ea tuhẽ Tupana'ga nhi'ig̃a,” ei g̃a. ");
INSERT INTO pahNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","A'ereki Tupana'ga remimbuhurukara'ga omombe'u katu Tupana'ga nhi'ig̃a. A'ereki Tupana'ga omondo gwa'uva ga pyri a'ea ti tokwahavuka pa ga pe javo. Nurã ga omombe'u katu Tupana'ga nhi'ig̃a. ");
INSERT INTO pahNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Tupana'ga oarõ hete gwa'yra'ga. A'ero ga ga mbopopoakarukari togwereko pa ti ga g̃wemimbotarimo. ");
INSERT INTO pahNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Kiroki g̃a ojiko Tupana'ga ra'yra'ga rehe hendukatuavo ganhi'ig̃a – g̃a ndeaporog̃itapyahuro a'ero aerẽ okovo Tupana'ga pyri nehẽ. Kiroki g̃a nohendukatui ganhi'ig̃a ojikoge'yma ga rehe – g̃a po ti ndohoi yvagi pe upa Tupana'ga pyri nehẽ. Ga e'i g̃a pe jipi peko te'varuhu pe javo. ");
INSERT INTO pahNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Aerẽ Jesus'ga g̃wemimbo'ehara'g̃a nderohoi Judéiapeve'g̃a gwyra hugwi. A'ereki ga okwaha ojipe'g̃a nhi'ig̃a fariseus'g̃a pe. A'ereki g̃a e'iuhu fariseus'g̃a pe: —João'ga omongo ojipe'g̃a ojiheva'ero g̃a mobatizavo, ei g̃a. João'gareheve'g̃a hohe'i tehe reki Jesus'gareheve'g̃a nde'yjuhuro – kiroki g̃a Jesus'ga omobatizauhu, e'iuhu g̃a g̃a mombe'gwovo fariseus'g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Jesus'ga nomobatizai reki g̃a. Ga omobatizauka g̃a g̃wemimbo'ehara'g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","G̃anhi'ig̃a ikwahavame Jesus'ga g̃wemimbo'ehara'g̃a nderohoi Judéiapeve'g̃a gwyra hugwi a'ero. —Xajivy ti Galiléiapeve'g̃a gwyri pe a'ero, ei ga. ");
INSERT INTO pahNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","G̃a horame Jesus'ga ei: —Samariapeve'g̃a gwyra rupi po ti nhande hona'ẽi nehẽ hamo, ei ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Aerẽ g̃a nduri cidade de Sicar pe a'ero Samariapeve'g̃a gwyri pe. Ira'agwe u Jacóva'ea koagwera hugwi. Jacóva'ea omondo a'ea gwa'yrava'ea pe Joséva'ea pe hako. ");
INSERT INTO pahNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Jacóva'ea apoagwera ykwara pevo u no. Ahaji katu g̃a nduri. Igwete Jesus'ga apygi oina ykwara pyri. A'ereki ga ipykane'õ. ");
INSERT INTO pahNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Igwete garemimbo'ehara'g̃a hoi cidade pe mbatera pyhyga. Nanime Samariapevehẽa ruri yhya ti tajara javo. Igwete Jesus'ga ei hẽa pe: —Embuhu ji ve ya tay'u, ei ga hẽa pe. ");
INSERT INTO pahNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","—Garamo judeuramo nde euhui ji ve embuhu yhya javo ji ve? Ji ki a'e te Samariapeva'ea, ei hẽa ga pe. (A'ereki judeus'g̃a ndojihe'ari Samariapeve'g̃a ndehe g̃a arõe'yma.) ");
INSERT INTO pahNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","A'ero Jesus'ga ei hẽa pe: —A'e ji nde ve: “Embuhu ji ve ya.” Emo nde ndajikwahavi, ei ga. Nde nderekwahavi Tupana'ga remimbuhutehea no, ei ga hẽa pe. Po nde ikwahavi hamo a'ero po nde ei ji ve embuhu ji ve akoja javo hamo, ei ga. A'ero po ji imondoi yhya ahemongohara nde ve hamo, ei ga hẽa pe. ");
INSERT INTO pahNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","A'ero hẽa ei ga pe: —Ndererekoi reki nde ijarahava, ei hẽa. Irupehu yhya reni ykwara pype. Ma hugwi nde herekoi yhya a'ero ahemongohara? ei hẽa ga pe. ");
INSERT INTO pahNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Nhaneramonhava'ea Jacóva'ea gweja ag̃a imohina nhandeygwavamo hako, ei hẽa. Ahe tuhẽ oy'u avova'ea pyvõ gwa'yrava'ea pavẽi hako. G̃wenymbava yuranuhũa ahe omboy'u ipyvõ no, ei hẽa. “Ji ko koji'i tehe jiruvihavuhu nhaneramonhava'ea hohe'i tehe,” ere po nde ji ve naerũ? ei hẽa ga pe. ");
INSERT INTO pahNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Igwete Jesus'ga ei hẽa pe: —Ag̃a pyvõ oy'urẽ po ti g̃a ygweja'javamo nehẽ, ei ga. ");
INSERT INTO pahNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Nhiremimondoa herekorame po ti g̃a ndiygweja'javi nehẽ. Nhiremimondoa po ti ikwahy hete g̃a ndehe nehẽ okookovo g̃ayvyteri pe nehẽ, ei ga. A'ea po ti g̃a mboheaporog̃itapyahui nehẽ, ei ga. A'ero po ti g̃a mongoi avuirama Tupana'ga pyri nehẽ no, ei Jesus'ga hẽa pe. ");
INSERT INTO pahNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","—Embuhu ji ve nanongara yhya a'ero tajiygweja'javyme ti a'ero nehẽ, ei hẽa ga pe. A'ero po ti ji ndajora'javi avo ijara jipi nehẽ, ei hẽa ga pe. ");
INSERT INTO pahNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","—Eho ti enhimbireko'ga rerua, ei ga hẽa pe. ");
INSERT INTO pahNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","—Ji ko nanhirembirekoi, ei hẽa. —Erenhimombe'u katu nde ji nanhirembirekoi javo, ei ga hẽa pe. ");
INSERT INTO pahNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","A'ereki cinco nerembirekokwera'g̃a. Korogweve'ga nde erereko tehe, ei ga. Nde nane'mbei tuhẽ javo ji ve, ei ga hẽa pe. ");
INSERT INTO pahNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","—Kirog̃we ji nde kwahavi, ei hẽa. Tupana'ga nhi'ig̃a mombe'uhara ndehe. Nurã nde ikwahahetei mbatera, ei hẽa ga pe. ");
INSERT INTO pahNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Marã naerũ? Emombe'u ti ji ve, ei hẽa. Samariapeva'ero oreramonhava'ea ei pea pe yvytyruhua pe hako: “Avo jate po nhande Tupana'ga mbohetei hamo,” ei ahe hako, ei hẽa ga pe. Pehe judeusramo pe'ji: “Jerusalém me jate po nhande Tupana'ga mbohetei hamo,” pe'ji pe, ei hẽa ga pe. ");
INSERT INTO pahNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Igwete Jesus'ga ei hẽa pe a'ero: —Erovia ti nhinhi'ig̃a, ei ga. Aerẽ po ti g̃a nde'i avova'ea pe avo ti timbohete nhanderuvete'ga nehẽ javo. Jerusalém me po ti g̃a nde'i nehẽ no pevo ti timbohete ga javo, ei ga. ");
INSERT INTO pahNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Samariapeva'ero pemboheteteheuhu pe ga kwahave'yma. Ore judeusramo orokwaha Tupana'ga mboheteavo, ei ga. Ore ve ga ojikwahavuka. Tupana'ga e'i ore ve hako: “Yvyakotyve'g̃a ndekote'varuhua mombohara'ga po ti o'a judeuramo,” ei Tupana'ga, ei ga. “Gaha po ti pe nderu ji pyri yvagi pe nehẽ,” ei Tupana'ga ore ve hako, ei Jesus'ga imombe'gwovo hẽa pe. ");
INSERT INTO pahNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Aerẽ po ti g̃a nhanderuvete'ga mbohetekatui a'ero nehẽ, ei ga. Ag̃wamo vehevi po ti g̃a ga mbohetei ga kwahaheteavo nehẽ. Gara'uva po ti ga mboheteukari g̃a pe nehẽ. A'ea Tupana'ga opota nanongara'g̃a omboheterame, ei Jesus'ga hẽa pe. ");
INSERT INTO pahNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Ndaha'oi Tupana'ga, ei ga. Kiroki g̃a ga mbohete – tojipokoguka ti g̃a gara'uva pe a'ero ga mboheteavo. Tokwaha hete ti g̃a ga mboheteavo, ei Jesus'ga imombe'gwovo hẽa pe. ");
INSERT INTO pahNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","A'ero hẽa ei ga pe: —Messias'ga po ti uhu tuhẽ nehẽ Tupana'ga remimbuhurukara'ga Cristo'ga, ei hẽa. Urame po ti gaha imombe'upavi mbatera nhande ve nehẽ, ei hẽa Jesus'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","—Ji tuhẽ Messiasramo kiro ji nhi'ig̃i nde ve, ei ga onhimombe'gwovo hẽa pe. ");
INSERT INTO pahNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Nanime Jesus'ga remimbo'ehara'g̃a jivyri cidade hugwi ua ga pyri. Igwete g̃a nhimomby'ai ga repiaga hẽa monhi'ig̃ame. A'ereki judeus'g̃a mbo'ehara'g̃a nonhi'ig̃i kunhangwera'g̃a pe jipi. A'ero g̃a nhimomby'ai Jesus'ga repiaga. G̃a nde'i reki ga pe: “Maraname nde nhi'ig̃uhũi hẽa pe?” nde'i g̃a. “Gara nde erepota hẽa hugwi?” A'ea g̃a nde'i Jesus'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Kiro hẽa hejari imohina yhya ryrua a'ero ojivya ogwovo cidade pe. Igwete hẽa ei ga mombe'gwovo pevove'g̃a pe: ");
INSERT INTO pahNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","—He pejijo xaho ji rupi ga repiaga, ei hẽa. A'ereki ga omombe'u pa ji ve jirekoagwera, ei hẽa g̃a pe. Mara'ngu po Messias'ga tuhẽ Tupana'ga remimbuhurukara'ga tuhẽ? ei hẽa g̃a pe ga mombe'gwovo. ");
INSERT INTO pahNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","A'ero g̃a nduri cidade hugwi ua Jesus'ga pyri tihepia ti ga javo. ");
INSERT INTO pahNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","G̃a vahema renonde Jesus'ga remimbo'ehara'g̃a eg̃a'ei ga pe: —Jesus, here i'gwovo. ");
INSERT INTO pahNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","—Nhirembi'ua pe ndapekwahavi reki, ei ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","—Marã? ei g̃a ojohupe a'ero. Mara'ngu po g̃a herua mbatera ga pe ra'e garembi'uramo? ei g̃a ojohupe. ");
INSERT INTO pahNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Igwete ga ei g̃a pe: —Garemimbotarimova'ea rehe ji rekoi – kiroki ga ji mbuhuruka yvya koty, ei ga. Ga ji mboporavyky avo. A'ero ji taporavyky pa katu ga pe, ei ga. A'ea pe ji ei a'ero nhirembi'ua. A'ereki ji rekorame garemimbotarimova'ea rehe a'ea ji mbopopoaka nhirembi'ua ja, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","—Pe'ji pe: “Quatro jahya ipora rehe po ti itinig̃i koapora nehẽ,” pe'ji pe, ei ga. Ji ki a'e te a'e pe me: Pehepia ti kohoa. Kirog̃we tuhẽ itinig̃i koapora. Kirog̃we po ahe imopeni herua hamo, ei ga g̃a pe. Tamombe'u katu pe me, ei ga. Ji rehe g̃ambojikoga pe ji ei reki koapora imopena imombe'urame, ei Jesus'ga. Nahã ji ei a'ero: Pe'ji pe pejiyvyteri pe: “Aerẽji po ti nhande g̃a mbojikojikogi Jesus'ga rehe nehẽ,” pe'ji pe, ei ga. Ji ki a'e te a'e pe me: Tape'ei poro. Pehepia ti g̃a. Kirog̃we g̃a jikogi g̃werĩ ji rehe, a'e ji, ei ga. Kirog̃we tuhẽ po pe g̃a mbojikojikogi ji rehe hamo, ei ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","—Kiroki ga omopemopẽ koapora herua – ga mbohory a'ero koapora, ei ga. Ga javijitehe ojipe'ga roryvamo no – kiroki ga otỹ na'ẽ, ei ga. G̃a memei hory hete a'ero ojogwerekovo itỹhara'ga imopẽhara'ga pavẽi, ei ga. Imopẽhara'ga javijitehe ko g̃a ndoryvamo no – kiroki g̃a ombojiko ojipe'g̃a ji rehe. Ojikogame ji rehe po ti g̃a ndekoi yvagi pe nehẽ no, ei ga g̃a pe. Kiroki g̃a ji mombe'u ypy ojipe'g̃a pe tojiko ti g̃a ga rehe javo – itỹhara'ga javijitehe ko g̃a ndoryvamo g̃ambojikohara'g̃a pavẽi. G̃a hory hete a'ero ojogwerekovo nhimombe'uypyhara'g̃a g̃ambojikohara'g̃a pavẽi, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","—Nahã ko nhanenhi'ig̃a jipi, ei ga. “Gaha otỹ. Ojipe'ga reki omopẽ herua ojive,” xa'e nhande, ei ga. A'itituhẽva'ea tuhẽ ko nhanenhi'ig̃a. ");
INSERT INTO pahNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","A'ereki na ja jara'g̃a ji mombe'umbe'u tojiko ti g̃a ga rehe javo. Pehe reki g̃a mbojikojiko ji rehe, ei ga. Ymya pe nanhimombe'ui pejikovo, ei ga. Aerẽ ji pe mondoukari g̃a mbojikojikogukarag̃wama jijihe, ei Jesus'ga imombe'gwovo g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","40","Kiro Samariapeve'g̃a nduri ovahema Jesus'ga pyri a'ero. A'ereki Samariapevehẽa omombe'u jipe ga ocidadepeve'g̃a pe. “Jesus'ga omombe'u pa ji ve jirekoagwera,” ei hẽa ga mombe'gwovo g̃a pe. Hẽanhi'ig̃a renduva g̃waramo g̃a jikojikogi Jesus'ga rehe a'ero onhimongyavo. Kiro g̃a nduri Jesus'ga pyri a'ero tihepia ti ga javo. —Epytaahi'vi ti ore pyri, e'ie'i g̃a ga pe. —Kwa, ei ga. Mokõi ga kiri g̃a pyri a'ero. ");
INSERT INTO pahNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Igwete ga nhimombe'umbe'ui g̃a pe. Ganhi'ig̃a renduva g̃waramo jara'g̃a jikojikogi ga rehe no onhimongyheteavo. ");
INSERT INTO pahNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","A'ero g̃a ei hẽa pe: —Nenhi'ig̃a renduva g̃waramo jate rũi ore jikogi ga rehe kiro, ei g̃a hẽa pe. Ganhi'ig̃a tuhẽ ore orohendu ikwahava kiro, ei g̃a. Nurã ore ei: “Ga ko yvyakotyve'g̃a ndekote'varuhua momboharamo tuhẽ,” ei g̃a hẽa pe. ");
INSERT INTO pahNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Mokõi Jesus'ga kiri pevo. A'ero ga hoi Galiléiapeve'g̃a gwyri pe upa. ");
INSERT INTO pahNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","A'ereki Jesus'ga e'i jipe: “Kiroki g̃a pevo u Tupana'ga nhi'ig̃a mombe'uhara'ga gwyri pe – g̃a nomondoi imohina ga rehe jipi,” ei ga. ");
INSERT INTO pahNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","A'ero Jesus'ga hoi Galiléiapeve'g̃a gwyri pe. Ga repiagame g̃a ndoryndoryvamo ga rehe. A'ereki g̃a gwepia na'ẽ Jesus'ga cidade de Jerusalém me. A'ereki g̃a oho na'ẽ pevo toryva repiaga. Pevo g̃a hepiapavi Jesus'ga japoparavuhurame ahemonhimomby'ava'ea. Nurã g̃a ndoryndoryvamo Jesus'ga rehe ga repiaga ogwyri pe. ");
INSERT INTO pahNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Aerẽ Jesus'ga hoa'javi cidade de Caná pe Galiléiapeve'g̃a gwyri pe jitehe – perope ga ombote yhya vinhoramo ikwehe. A'evo jitehe Jesus'ga hoi. A'ero ga ruri Jesus'ga pyri g̃anduvihava'gareheve'ga. Gara'yra'ga itetirũa hete ojipe'g̃a cidade pe Cafarnaum me. ");
INSERT INTO pahNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Galiléiapeve'g̃a e'i ga pe a'ero: —Uhu Jesus'ga kiro nhande pyri Judéiapeve'g̃a gwyra hugwi, ei g̃a ga mombe'gwovo ga pe. A'ero ga ruri Jesus'ga pyri javo. —Herejo xaho ji rupi jira'yra'ga repiaga teremombi ti karugwara ga hugwi, ei ga. A'ereki ga omano g̃werĩ, ei ga Jesus'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Igwete Jesus'ga ei: —Hepiage'ymame ahemonhimomby'aheteva'ea po pe ndapejikogi tuhẽ ji rehe, ei ga ga pe. ");
INSERT INTO pahNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","—Xaho tuhẽ ti ji rupi, ei ga Jesus'ga pe. Nde hoe'ymame po ti jira'yra'ga manoi a'ero nehẽ, ei ga. ");
INSERT INTO pahNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","—Kiro ndera'yra'ga nhimohig̃atui, ei Jesus'ga ga pe. Heregwovo ga pyri a'ero ga repiaga, ei ga. Gwerovia ga Jesus'ga nhi'ig̃a a'ero ogwovo tahepia ti javo. ");
INSERT INTO pahNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Ga horame pea rupi gapyrive'g̃a nduri ga rovatiamo. —Onhimohig̃atu kiro ndera'yra'ga, ei g̃a ga pe. ");
INSERT INTO pahNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","—Marananime kwara nhimonaname ga rehe raji'i? ei ga g̃a pe. —Kirame ahaji katu nhimonaname ga rehe oji'i, ei g̃a imombe'gwovo ga pe. ");
INSERT INTO pahNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","A'ero ga ikwahavi javo. —A'ea rupi tuhẽ Jesus'ga ei ji ve oji'i: “Kiro ndera'yra'ga nhimohig̃atui,” ei ga. A'ero g̃a jikopavi Jesus'ga rehe gaha g̃wongapeve'g̃a pavẽi. ");
INSERT INTO pahNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Mokõi a'ero Jesus'ga rura'java Galiléiapeve'g̃a gwyri pe Judéiapeve'g̃a gwyra hugwi. Urypyrame ga ojipeji oapo ahemonhimomby'ava'ea hepiuka g̃a pe. Kiro ura'javame ga ojipea oapo imombiga karugwara ga hugwi. ");
INSERT INTO pahNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Aerẽ judeus'g̃a japoi toryva Jerusalém me. A'ero Jesus'ga hoi tahepia javo. Igwete Jesus'ga ipyka'nauhũve'ga repiagi ypia'ia pyri. ");
INSERT INTO pahNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Jerusalém jupihava pyri ypia'ia u – perope hovapytymbava pyri. Jurukwara rupi g̃a heno'eno'ẽi ovelhas jipi. Betezata ei judeus'g̃a ypia'ia pe. Gwereko mbohapyrete cinco tapyi'ia ypia'ia pyri. ");
INSERT INTO pahNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","A'ea gwyri pe itetirũave'g̃a nhinog̃i upa ypia'ia pyri onhimongyavo jipi. Hehae'ỹve'g̃a ko pevo u jipi ipyka'naka'nauhũve'g̃a pavẽi nomyive'g̃a pavẽi.  ");
INSERT INTO pahNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","A'ereki amoamome Tupana'gapyrive'ga ojy yhya pype ya momyina. Kirẽ kiroki g̃a oho ypy yhya pype – g̃ahã onhimohig̃atu a'ero. Nahã g̃a horame ipype ga rugarurirẽ g̃atetirũaparavuhua ipigi g̃a hugwi a'ero. Nurã itetirũave'g̃a nhinog̃i upa ypia'ia pyri jipi taho ypy ti ipype javo. ");
INSERT INTO pahNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","6","Igwete Jesus'ga ipyka'nahũve'ga repiagi pevo. “Ymyahũ hete ga ka'nauhũro,” ei Jesus'ga. A'ereki he'yjuhu trinta e oito kwara gaka'na rehe. Ikwahavame Jesus'ga ei ga pe: —Ndepyry hete pota nde? ei ga. ");
INSERT INTO pahNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","—Jipyry pota ji novĩa, ei ipyka'nauhũve'ga ga pe. A'ereki nanhimbojyhavi ipype ya momyiname jipi, ei ga. Ji hopotarame ipype ojipe'ga hojipei ipype ji renonde jipi, ei ga Jesus'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","A'ero Jesus'ga ei ga pe: —Epo'ã! Epyhy ti ejikupeupava herogwovo, ei ga. ");
INSERT INTO pahNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Kotihĩ ga pyryvamo a'ero opo'ama herogwovo. A'ea ko sábado judeus'g̃a poravykye'yma. ");
INSERT INTO pahNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Nurã judeus'g̃a nduvihava'g̃a ei ika'nauhũgwera'ga pe: —Kirog̃we ko sábado, ei g̃a. Ndapyryvi nde herohoi ejikupeupava kirog̃we, ei g̃a ga pe. A'ereki Moisésva'ea e'i: “Po ahe ndogwerohoi te mbatera sábado rupi nhandeporavykye'yma rupi,” ei ahe ikwatija, ei g̃a ga pe. ");
INSERT INTO pahNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Igwete ga ei: —Akoja'ga – kiroki ga ji mopo'ã ko – gaha e'i ji ve: “Epyhy ti herogwovo,” ei ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","—Ma'g̃a e'iuhu nde ve naerũ herohoukarag̃wama? ei g̃a ga pe. ");
INSERT INTO pahNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Ika'nauhũgwera'ga ndokwahavi reki Jesus'ga. A'ereki Jesus'ga oho jipe g̃ande'yjuhua pytera rupi ogwovo. ");
INSERT INTO pahNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Aerẽ Jesus'ga ga repiagi judeus'g̃a jatykahavuhua pype. Igwete ga ei ga pe: —Ji rendu ti, ei ga ga pe. Erepo'ag̃atu nde kiro, ei ga. Terekote'varuhua'javi ti a'ero, ei ga. Po ti nde nderepohiri ejikote'varuhua hugwi, a'ero po ti koji'i tehe nde mbatera rahya hepiagi nehẽ, ei Jesus'ga ga pe. ");
INSERT INTO pahNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","A'ero ika'nauhũgwera'ga hoi imombe'gwovo judeus'g̃a nduvihava'g̃a pe. —Gaha ji mopo'ã Jesus'ga, ei ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Nurã g̃a imbote'varuhupotari Jesus'ga pe. A'ereki ga omombimombi g̃atetirũa g̃a hugwi sábado rupi jipi. ");
INSERT INTO pahNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Igwete Jesus'ga ei: —Jiruva'ga oporavykye'ymi jipi g̃a pokopokoga, ei ga. Ga javijitehe ji aporavykye'ymi g̃a pokoga no, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Ganhi'ig̃a renduvame koji'i g̃a Jesus'ga jukapotari a'ero. —A'ereki sábado rupi ga oporavykyuhu imombiga g̃atetirũa g̃a hugwi nhaneramonhava'ea nhi'ig̃a rendukatue'yma, ei g̃a. Johe'i tehe garekote'varuhua. Jiruva'ga ei ga Tupana'ga pe no, ei g̃a. Nahã ga nhimongopotaruhui Tupanamo a'ero, ei g̃a. Nurã g̃a Jesus'ga jukapotari a'ero. ");
INSERT INTO pahNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Igwete Jesus'ga ei g̃a pe: —Tamombe'u katu tuhẽ pe me, ei ga. Jihi Tupana'ga ra'yramo ndakoi nhiremimbotarimova'ea rehe. Akwaha ji Tupana'ga reaporog̃itakatua jitekovo. A'ea rehe jate ji reaporog̃itaro a'ero, ei ga. Okoe'ymi ga g̃wemimbotarimova'ea rehe. Garemimbotarimova'ea rehe javijitehe ji rekoe'ymi no gara'yramo, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","A'ereki jiruva'ga ji arõ hete, ei ga. A'ero ga ikwahapavukari ji ve gweaporog̃itakatua, ei ga. Koji'i po ti ga ikwahavukari ji ve nehẽ no, ei ga. “Nahanahã po ti nde rekoi g̃a monhimomby'avo nehẽ,” e po ti ga ji ve nehẽ, ei Jesus'ga g̃a pe. —Pyry hete tuhẽ ji ika'nauhũve'ga mopo'ami, ei ga. Johe'i tehe po ti ji japoi pyryheteva'ea nehẽ. A'ero po ti pe nhimomby'ahetei a'ea rehe nehẽ, ei ga. ");
INSERT INTO pahNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","A'ereki jiruva'ga omanove'g̃a mbogwera g̃a mongovo, ei ga. Ga javijitehe jihi gara'yramo g̃a mbogwerapotarame ji g̃a mbogweravi g̃a mongovo no, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","23","Jihi a'e jara'g̃a pe: “Ereko te'varuhu nde. Eho ti hahyva'ea ruvihava pype a'ero nehẽ,” a'e ji, ei ga. Jara'g̃a pe ji ei: “Ndepyry nde ejikoga ji rehe. Yvagi pe ti nde ruvi avuirama nehẽ,” a'e ji, ei ga. Tupana'ga tuhẽ nde'i g̃a pe. A'ereki ga e'i ji ve gwa'yramo: “Ndehe ti ere g̃a pe tanembohete ti g̃a,” ei ga ji ve a'ero, ei Jesus'ga. Ombohete g̃a Tupana'ga. Na jitehe po ti g̃a tanhimbohete nehẽ no, ei ga. Kiroki g̃a nanhimbohetei – g̃a nombohetei jiruva'ga no nhimbuhurukara'ga, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","—Tamombe'u katu tuhẽ pe me, ei ga. G̃a hendukaturame nhinhi'ig̃a ojikoga Tupana'ga rehe nhimbuhurukara'ga rehe, gweaporog̃ita pyahu ko g̃a a'ero, ei ga. A'ero po ti g̃a ndekoi avuirama Tupana'ga pyri nehẽ no, ei ga. Nda'ei po ti ji g̃a pe nehẽ: “Peko te'varuhu pe,” ei ga. A'ereki g̃a ndohoa'javi kiro hahyva'ea ruvihava viara rupi. Yvaga viara rupi g̃a hoi a'ero Tupana'ga pyri nehẽ, ei ga. ");
INSERT INTO pahNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Tamombe'u katu tuhẽ pe me, ei Jesus'ga. Ji ko Tupana'ga ra'yramo ako. Okote'varuhuve'g̃a po ti henduvi nhinhi'ig̃a nehẽ ag̃wamo vehevi reki. Hendukaturame po ti g̃a ndeaporog̃itapyahuro nehẽ, ei ga. ");
INSERT INTO pahNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Tupana'ga hete ahe mongoi ahe monguva. Ga javijitehe ji gara'yramo ahe mongoi no. A'ereki ga ahe mongoukari ji ve. ");
INSERT INTO pahNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Na jitehe Tupana'ga ei ji ve: “Ndehe ti ere okote'varuhuve'g̃a pe peko te'varuhu pe javo,” ei ga ji ve, ei Jesus'ga. A'ereki ji ko yvagipeva'ea. Yvyakotyva'ea ko ji no, ei ga. ");
INSERT INTO pahNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","—Tapenhimomby'auhui ti nhinhi'ig̃a renduva, ei ga. Aerẽ po ti ahe nhaporemo henduvi nhinhi'ig̃a nehẽ. ");
INSERT INTO pahNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Henduvame po ti omanove'g̃a kwerava'javi nehẽ. Okokatuve'g̃a po ti okwera okovo Tupana'ga pyri avuirama nehẽ, ei ga. Okote'varuhuve'g̃a po ti okwera nehẽ no. A'ero po ti ji ei g̃a pe: “Pendekote'varuhuro g̃waramo po ti pe hoi hahyva'ea ruvihava pype a'ero nehẽ,” a'e po ti ji g̃a pe nehẽ, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Igwete Jesus'ga ei g̃a pe no: —Nhiremimbotarimo rũi ji ei g̃a pe peko te'varuhu pe javo. Tupana'ga ji mbo'euka. Garemimbo'ea rupi jate ji ei a'ero, ei Jesus'ga. Nurã hupi katu ji ei jara'g̃a pe peko te'varuhu pe javo. Hupi katu ji ei jara'g̃a pe no pepyry hete pe javo, ei ga. A'ereki nhiremimbotarimova'ea rehe rũi ji rekoi. Jiruva'ga remimbotarimova'ea rehe ji rekoi nhimbuhurukara'ga rehe, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","—Po ti jihi tehe anhimombe'u pe me, a'ero po ti pe ndajireroviari nehẽ hamo ga hete onhimombe'u javo ji ve, ei ga. ");
INSERT INTO pahNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Ojipe'ga ji mombe'u no jiruva'ga, ei ga. Akwaha hete ji nhimombe'ukatua. A'ereki a'itituhẽva'ea garemimombe'ua, ei ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","—Pehe pemondo g̃a João Batista'ga pyri raikwehe tonhimombe'u ti ga javo, ei ga. Onhimombe'urame a'ero ga ei a'itituhẽva'ea pe. A'ereki ga ji mombe'u katu no, ei ga. ");
INSERT INTO pahNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Ji ve rũi po ojipe'g̃a ji mombe'ukatui hamo, a'e ji. Pe me po g̃a ji mombe'ukatui hamo tokwaha ti g̃a ga javo, ei ga g̃a pe. Nurã ji ei João'ga remimombe'uagwera pe taperovia ti. Heroviarame po ti pe jikogi ji rehe nehẽ pejigwove'yma hahyva'ea ruvihava pype nehẽ, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","—João'ga ko hyapehava ja. A'ea hendy'javame gwepiuka nhande ve tokwaha ti g̃a javo, ei ga. Na jitehe João'ga ji repiukari pe me ikwehe tokwaha ti g̃a Jesus'ga javo, ei ga. Ga pe mbo'e katu novĩa. A'ero pe ndoryvamo jiji garemimbo'ea rehe novĩa, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","—A'apo ji ahemonhimomby'ava'ea jipi. A'ereki Tupana'ga oapoapouka ji ve, ei ga. Nhirembiapoa tuhẽ ji kwahavukari pe me a'ero, ei Jesus'ga. João'ga nhi'ig̃a ji kwahavukari pe me no. Koji'i reki nhirembiapoa ji kwahavuka pe me João'ga nhi'ig̃a hohe, ei Jesus'ga. Nhirembiapoa repiaga g̃waramo po pe'ji hamo: “Tupana'ga ga mbuhuruka tuhẽ kokoty a'ea apovouka ga pe,” pe'ji po pe hamo, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Nhimbuhurukara'ga jiruva'ga ji mombe'u katu no, ei ga. Ndapehepiagangavi pe gara'oa. Pejiapyakwara pyvõ pe napehenduvangavi ga nhi'ig̃ame no, ei ga. ");
INSERT INTO pahNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Pe ndapekopotari ganhi'ig̃a rupi, ei ga g̃a pe. A'ereki pe ndaperoviari nhinhi'ig̃a. Gaha reki ji mbuhuruka kokoty, ei ga. ");
INSERT INTO pahNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Pehepiepia katu pe aherembikwatijara novĩa Tupana'ga mombe'uhara, ei ga. “A'ea repiagame po ti nhande ikwahavi nhanderekoag̃wama yvagi pe Tupana'ga pyri nehẽ,” pe'ji po pe pejohupe novĩa, ei ga. Aherembikwatijara jitehe reki ji mombe'u pe me novĩa, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Emo pe ndapejikopotari ji rehe. Ndapejori ko pe ji pyri toroko ti Tupana'ga pyri nehẽ jave'yma ji ve, ei ga. ");
INSERT INTO pahNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","—Ji nda'ei ahe ve tanhimbohete ti g̃a javo, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Pe ki a'e te ji atyvihu, ei ga. Anhimombaragwaha ji pe ndehe. Pe napearõi tuhẽ Tupana'ga, ei ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Ajo ji jiruva'ga hugwi. A'ereki gaha ji mbuhuruka pepyteri pe ji mombe'u ti g̃a pe javo, ei ga. Pe ki a'e te ndapekoi ji rehe. Ojipe'g̃a ko onhimbuhuteheuhu pepyteri pe. G̃a ndehe pe ndekoi a, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Pyry pe me pe nhomboheteheteuhui a. Pe ndapekoi reki Tupana'ga remimbohetea rehe. Ga jate ko Tupanamo, ei ga. Emo pe ndape'ei: “Xako katu ti Tupana'ga ti tianembohete.” A'ea pe ndape'ei. Nurã tegwete pe me pejikoga ji rehe, ei ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","—Ji rũi po ti imombe'umbe'ui Tupana'ga pe pendekote'varuhua nehẽ, ei Jesus'ga g̃a pe. Moisésva'ea po ti imombe'ui a'ea ga pe nehẽ, ei ga g̃a pe. Pe'ji po pe novĩa: “Aerẽ po ti Moisésva'ea vavagahivi nhande rehe Tupana'ga pyri nehẽ,” pe'ji po pe novĩa, ei ga. Emo po ti ahe omombe'u Tupana'ga pe pendekote'varuhua nehẽ, a'e ji, ei ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Moisésva'ea ji mombe'ukatui reki ji kwatija hako. Po pe Moisésva'ea nhi'ig̃a reroviari tuhẽ hamo, a'ero po pe nhinhi'ig̃a reroviari hamo no, ei ga. ");
INSERT INTO pahNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Pe ndaperoviari reki ahenhi'ig̃a – kiroki a'ea ahe okwatija inog̃a. Nurã pe ndaperoviari tuhẽ nhinhi'ig̃a no, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Aerẽ Jesus'g̃a hero'yahavi ypiahua aherovai Galiléiapeva'ea aherovai. Tiberíadespeva'ea ei g̃a ypiahua pe no. ");
INSERT INTO pahNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","He'yjuhu hete ko g̃a ogwoogwovo Jesus'g̃a ndeviri. A'ereki g̃a gwepigwepia ahemonhimomby'ava'ea – kiroki Jesus'ga oapoapouka imombiga g̃atetirũa g̃a hugwi. ");
INSERT INTO pahNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Igwete Jesus'ga hoi yvytyruhua rehe oina g̃wemimbo'ehara'g̃a pavẽi. ");
INSERT INTO pahNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","A'ea rupi judeus'g̃a oapo g̃werĩ toryva cidade de Jerusalém me. Páscoa ko toryva rera. ");
INSERT INTO pahNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Igwete Jesus'ga jovavuri he'yive'g̃a ndepiaga – kiroki g̃a u ga pyri okovo. A'ero ga ei Filipe'ga pe: —Mome po ti nhande ipyhygi mbatera akoja'g̃a nembi'uag̃wama nehẽ? ei Jesus'ga ga pe. ");
INSERT INTO pahNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Jesus'ga okwahavipe reki g̃wemimondoag̃wama g̃a pe. Emo oyvyteri pe ga ei tahendu ti Filipe'ga nhi'ig̃a ji ve javo. Nurã ga ei Filipe'ga pe: “Mome po ti nhande ipyhygi mbatera g̃anembi'uag̃wama?” ");
INSERT INTO pahNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Igwete Filipe'ga ei ga pe: —Po ti he'yjuhuva'ea duzentos nhande imondoi itambere'ia hehe nehẽ ndohygi'i'i po ti mbatera g̃a ndehe nehẽ, ei ga. A'ereki g̃a he'yjuhu hete. ");
INSERT INTO pahNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Igwete André'ga – ga ko Jesus'ga remimbo'eharamo no Simão Pedro'ga irũ'ga – igwete ga ei Jesus'ga pe: ");
INSERT INTO pahNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","—Avo tapihama'ga mbohapyrete cinco herekoi pães trigo'java'ea apopyra cevada apopyra, ei ga imombe'gwovo Jesus'ga pe. Dois ga pira'ia herekoi no. Emo mbohapyretero g̃waramo ndohygi tuhẽ g̃a ndehe nhaporemo, ei ga ga pe. ");
INSERT INTO pahNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Igwete Jesus'ga ei g̃wemimbo'ehara'g̃a pe: —Pe'ji ti g̃a pe toapyapy ti g̃a upa, ei ga. G̃a erame g̃a pe g̃a apygi nhungwa'via rehe a'ero. A'ereki nhungwava gwereko pa pevo. He'yjuhu hete ko akwaimbae'g̃a cinco mil. Kunhangwera'g̃a ndehe koji'i tehe g̃a nde'yjuhuhetero tayri'g̃a ndehe no. ");
INSERT INTO pahNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","12","Kiro Jesus'ga ipyhygi tapihama'ga apoa pães javo Tupana'ga pe. —Ndepyry hete nde imbuhuruka pão ore ve, ei ga ga pe. A'ero ga ima'ema'ẽukari imondovouka g̃apo pe – kiroki g̃a oapyapy upa. Na jitehe ga ipyhygi pira'ia javo Tupana'ga pe. A'ero ga ima'ema'ẽukari g̃a pe. Ombohe'yjuhu hete reki ga pães pira'ia reheve g̃a moytaromouka. Aerẽ Jesus'ga ei g̃wemimbo'ehara'g̃a pe: —Pemono'ono'õ ti hembyruera tipo'ru ti aerẽ nehẽ javo, ei ga. ");
INSERT INTO pahNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Kiro g̃a hoi imono'ono'og̃a hembyruera a'ero imotynahema yrua. He'yiva'ea doze g̃a imotynahemi yrua. A'ereki he'yi pães rembyruera cincova'ea rembyruera g̃a i'upavirẽ. ");
INSERT INTO pahNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Hepiagame pevove'g̃a ei a'ero: —Ahemonhimomby'ava'ea Jesus'ga oapo pão imbohe'yja nhande ve, ei g̃a. Ga ko Tupana'ga nhi'ig̃a mombe'uhara'ga tuhẽ! Moisésva'ea omombe'u ga hako uhu po ti ga yvya koty javo. Ga tuhẽ reki, ei g̃a ojohupe. ");
INSERT INTO pahNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Jesus'ga okwahavipe g̃andeaporog̃ita. A'ero ga ei oyvyteri pe: “Kiro po ti g̃a nduri ji pyhygahyavo ji rerogwovo oreruvihavuhuhetero ti eko javo ji ve nehẽ,” ei ga. “A'ea rehe rũi ji ruri yvya koty,” ei ga oyvyteri pe. Nurã Jesus'ga hoa'javi ogwovo g̃a hugwi. Ga tehe oho a'ero yvytyruhua rupi. ");
INSERT INTO pahNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Ka'aruheterame Jesus'ga remimbo'ehara'g̃a hoi ypiahu pe. ");
INSERT INTO pahNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Igwete g̃a avi yhara pype xajivy ti Cafarnaum me javo. Ypytunamo g̃a pe a'ero g̃a horame. Jesus'ga nduri ve g̃a pyri. ");
INSERT INTO pahNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Kiro yvyruhua ruri imotypepemuhuamo g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Igwete g̃a ipyvupyvuri a'ero. Irupe cinco quilômetros g̃a hoi ypyteri pe. A'ero g̃a Jesus'ga repiagi ga rurame. Yhya japea rehe ga pyrũpyrug̃i ua yhara pyri. —Gara katu? ei g̃a. A'ereki g̃a okyhyji hete hepiagame garura yjapea rupi. ");
INSERT INTO pahNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","—Tapekyhyji ti, ei Jesus'ga g̃a pe. Jihi ko koro ako, ei ga. ");
INSERT INTO pahNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","A'ero g̃a ndoryvamo here'ava ipype javo ga pe. Nanime g̃a vahemi aherovai a'ero. ");
INSERT INTO pahNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","23","Ko'emame jara'g̃a ei – kiroki g̃a opyta ypiahua aherovai – perope g̃a o'u pão Jesus'ga nhi'ig̃irẽ Tupana'ga pe hehe. Ko'emame g̃a ei o'ama: —Mome po Jesus'ga hoi? ei g̃a ojohupe. A'ereki ojipeji g̃a herekoi yhara oji'i. Jesus'ga remimbo'ehara'g̃a avame ipype herogwovo Jesus'ga ndohoi g̃a ndupi kirame oji'i. Ahã ojipea yhara gahohava, ei g̃a. Mome po ga rekoi a'ero? ei g̃a ojohupe. Ojipe'g̃a gweru yhara cidade de Tiberíades hugwi kiro imboja pevo g̃a pyri. ");
INSERT INTO pahNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","G̃ayhara pype g̃a ag̃a'avi upa a'ero xajivy javo. A'ereki g̃a ndohepiaga'javi Jesus'g̃a pevo. Aerẽ g̃a vahemi cidade de Cafarnaum me tiheka ti Jesus'ga avo javo. ");
INSERT INTO pahNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Jesus'ga repiagame g̃a ei a'ero: —Jesus, maname nde ruri kokoty raji'i? ei g̃a ga pe. ");
INSERT INTO pahNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Igwete Jesus'ga ei: —Tamombe'u katu tuhẽ pe me, ei ga. Ahemonhimomby'ava'ea repiaga pe ndape'ei reki ji ve: “Jesus'ga ko Tupana'ga remimbuhurukaramo oko. Nurã ti tiheka ga repiaga ga kwahava.” Ndape'ei pe a'ea, ei ga. Pe'uuhu pe pão nhiremimondoa penhimoytaromouka oji'i. Nurã ko pe ji rekaruhui toro'ua'ja ti javo, ei ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Tape'ag̃atarahivuhui po pe mbatera rehe hamo tiugweugwei nhande javo. Nanongara mbatera opa pa jipi. Tamombe'u katu ti pe me, ei Jesus'ga g̃a pe. A'ea rehe po pe ag̃atarahivamo hamo – kiroki a'ea ahe mboheaporog̃ita pyahu avuirama ahe mongoag̃wama – a'ea rehe po pe ag̃atarahivamo hamo a'ea tipota hete javo, ei ga. Pejikogame ji rehe po ti ji pe mboheaporog̃itapyahui pe mongovo Tupana'ga pyri a'ero nehẽ. A'ereki Tupana'ga jiruva'ga ji mbopopoaka ahemonhimomby'ava'ea japovouka ji ve, ei ga. Nahã ga hepiukari pe me jihi Jesus'ga mondouka pe pyri javo pe me, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","A'ero g̃a ei ga pe: —Marã po ti ore rekoi jipi nehẽ Tupana'ga remimbotarimova'ea rehe orokovo nehẽ? ei g̃a. ");
INSERT INTO pahNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Igwete Jesus'ga ei: —Nahã po pe ndekoi hamo, ei ga. Pejiko ti ji rehe. A'ereki Tupana'ga ji mbuhuruka kokoty, ei ga. Nahã po ti pe ndekoi garemimbotarimova'ea rehe nehẽ, ei ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","A'ero g̃a ei ga pe: —Marãva'ea po ti nde ereapo ore ve ore monhimomby'avo nehẽ ndereroviarag̃wama nehẽ? ei g̃a Jesus'ga pe. Gara ti nde ereapo hepiuka ore ve nehẽ? ei g̃a. ");
INSERT INTO pahNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Nhaneramonhava'ea o'uo'u maná mbeju'ia'javuhuva'ea pãoramo ongae'ỹi me hako. Nahã ikwatijara ei imombe'gwovo: “Yvaga hugwi ahe imbuhurukari pão ahe ve to'u g̃a javo,” e'i, ei g̃a. ");
INSERT INTO pahNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Igwete Jesus'ga ei g̃a pe: —Tamombe'u katu tuhẽ pe me, ei ga. Moisésva'ea rũi ombuhuruka pe me pão yvaga hugwi. Jiruva'ga ko ombuhuruka pe me pãohetea yvaga hugwi, ei ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","A'ereki Tupana'ga remimbuhura ojy yvaga hugwi yvyakotyve'g̃a mboheaporog̃itapyahuavo g̃a mongovo avuirama, ei ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","A'ero g̃a ei ga pe: —Kotihĩtihĩ ti embuhu a'ea ore ve a'ero, ei g̃a. ");
INSERT INTO pahNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Igwete Jesus'ga ei g̃a pe: —Jijive ko ji ei pãohetea. A'ereki jihi ajy Tupana'ga hugwi ikwehe, ei ga. Jihi po ti g̃a mboheaporog̃itapyahui g̃a mongovo nehẽ. G̃a i'urame pão avova'ea po ti g̃a jugweja'javi nehẽ. Oy'urame po ti g̃a ygweja'javamo nehẽ, ei ga. Po ti ji rehe g̃a jikogame a'ero po ti g̃a ndopotara'javi hajiheve'g̃a omombyryharamo. “Jesus'ga jate nhande mombyry nhande mboheaporog̃itapyahuavo,” e po ti g̃a nehẽ. G̃a po ti horyoryve'ymi a'ero jireheva'ero nehẽ, ei ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","—A'e ko ji pe me ko, ei ga. Ji repia ko pe novĩa. Emo pe ndapejikogi ji rehe, ei ga. ");
INSERT INTO pahNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Jiruva'ga ombuhurukarame ji pyri po ti g̃a nduri ojikoga ji rehe. Kiroki g̃a uhu toroko ti ndereheva'ero javo ji ve – ji ti nda'eag̃wami g̃a pe ji ndopopotari pe jireheva'ero jave'yma g̃a pe, ei ga. ");
INSERT INTO pahNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","A'ereki ji ajy yvaga hugwi tako ti Tupana'ga remimbotarimova'ea rehe javo. A'ereki gaha ji mbuhuruka kokoty, ei ga. Ji ndakoi nhiremimbotarimova'ea rehe a'ero, ei ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Nahã ga ei ji ve nhimbuhurukara'ga: “Kiroki g̃a ji g̃a mondouka nde pyri ndereheva'ero – ereko katu pa ti g̃a tohoyme ti g̃a hahyva'ea ruvihava pype a'ero nehẽ,” ei ga ji ve, ei Jesus'ga. “Embogwera pa ti g̃a g̃amanoa hugwi ejivyra'javame yvya koty nehẽ,” ei ga ji ve, ei ga. ");
INSERT INTO pahNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","“Kiroki g̃a nhimombaragwahavi nde rehe ojikoga – g̃a po ti oko pyahu okovo ji pyri nehẽ,” ei jiruva'ga ji ve, ei ga g̃a pe. Jihi po ti ambogwera g̃a a'ero jijivyra'javame nehẽ, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Kiro judeus'g̃a nduvihava'g̃a ete'varuhui ga mombe'gwovo ojohupe a'ero. —Maranuhũrame ga euhui jihi ko pãohetea javo? “Yvaga hugwi ji jyvi ikwehe,” e'iuhu ga, ei g̃a. ");
INSERT INTO pahNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Ga ko Jesus'ga rũi naerũ José'ga ra'yramo? Orokwaha memei ore g̃a garuva'ga gayhẽa reheve, ei g̃a. Maraname te ga euhui naerũ: “Ji ko ajy yvaga hugwi ikwehe”? ei g̃a. ");
INSERT INTO pahNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Igwete Jesus'ga ei g̃a pe: —Pepi ti pe'ete'varuhua hugwi, ei ga. ");
INSERT INTO pahNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Jiruva'ga ombojikoge'ymame po g̃a ndojikogi ji rehe a'ero. G̃a jikogame ji rehe po ti ji g̃a mbogweravi g̃amanoa hugwi jijivyra'javame nehẽ, ei ga. ");
INSERT INTO pahNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Nahã Tupana'ga nhi'ig̃a mombe'uharava'ea ei ikwatija hako: “Tupana'ga po ti g̃a mbo'epavi nehẽ,” ei ahe hako, ei Jesus'ga. Kiroki g̃a g̃wendu katu jiruva'ga nhi'ig̃a ga ombo'erame – g̃a ojiko ji rehe a'ero, ei ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Ji nda'ei: “Gwepia g̃a jiruva'ga.” A'ereki ndohepiagi tuhẽ g̃a ga a, ei ga. Jihi jate ahepia jiruva'ga. A'ereki Tupana'ga hugwi ji ruri ikwehe, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","—Tamombe'u katu tuhẽ pe me, ei ga. Kiroki g̃a ojiko ji rehe – g̃a heaporog̃ita pyahu kiro. Aerẽ po ti g̃a ndekoi avuirama Tupana'ga pyri nehẽ no, ei ga. ");
INSERT INTO pahNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Jihi ko pãoheteramo ako. Jihi amboheaporog̃ita pyahu g̃a mongovo avuirama, ei ga. ");
INSERT INTO pahNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Penamonhava'ea o'uo'u maná pãoramo ongae'ỹi me jipi, ei ga. Emo ahe omano, ei ga. ");
INSERT INTO pahNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Pãohetea ki a'e te ojy yvaga hugwi. Nanongara i'urame po ti g̃a ndekoi Tupana'ga pyri okovo nehẽ, ei ga. ");
INSERT INTO pahNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Jihi ko pãoheteramo ako jijyva yvaga hugwi g̃a mongovouka. Po g̃a jikogame ji rehe a'ero po ti g̃a ndekoi avuirama Tupana'ga pyri nehẽ, ei ga. Pãohetea – akoja ti ji amondo pe me nehẽ tape'u ti javo – a'ea ko jira'oramo, ei ga. A'ea po ti ji imondoi yvyakotyve'g̃a ndepyga g̃a mongovouka nhimanorame nehẽ, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Ganhi'ig̃a renduvame judeus'g̃a nduvihava'g̃a nhonhi'ig̃ayvari a'ero. —Marã po ti ga imbuhurukaruhui gwa'oa nhande ve nehẽ tape'u ti javo? ei g̃a ojohupe. ");
INSERT INTO pahNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Igwete Jesus'ga ei g̃a pe: —Tamombe'u katu tuhẽ pe me, ei ga. Tupana'ga ji mbuhuruka kokoty, ei ga g̃a pe. Po ti pe i'ue'ymame jira'oa jirekoa reheve, a'ero po ti pe napendeaporog̃itapyahui avuirama nehẽ, ei ga. ");
INSERT INTO pahNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Kiroki g̃a o'u jira'oa jirekoa reheve – g̃a ko heaporog̃ita pyahu avuirama. Aerẽ po ti ji g̃a mbogweravi jijivyra'javame nehẽ, ei ga. A'ero po ti g̃a ndekoi avuirama Tupana'ga pyri nehẽ, ei ga. ");
INSERT INTO pahNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","A'ereki jira'oa g̃anembi'ua tuhẽ jirekoa pavẽi. ");
INSERT INTO pahNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Kiroki g̃a o'u jira'oa jirekoa reheve – g̃ahã ojihe'a hete ji rehe. Jihi ajihe'a hete g̃a ndehe no, ei ga. ");
INSERT INTO pahNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Jiruva'ga ji mbuhuruka kokoty. Gaha ojipe'g̃a mongouka. Gaha ji mongouka no, ei ga. Na jitehe kiroki g̃a o'u jira'oa – jihi ti g̃a mongo pyahu nehẽ no, ei ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Jira'oa ko pãoheteramo – a'ea ojy yvaga hugwi. A'ea ko akoja atyvi – kiroki penamonhava'ea o'u aerẽ omanomo hako, ei ga. Pãohetea g̃a i'urame po ti g̃a ndeaporog̃itapyahuro nehẽ. Aerẽ po ti g̃a ndekoi Tupana'ga pyri nehẽ, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","A'ea Jesus'ga ei judeus'g̃a jatykahava pype Cafarnaum me. Onhimi reki Jesus'ga nhi'ig̃a g̃a pe ga erame to'u ti g̃a jira'oa jirekoa reheve javo. A'ereki Jesus'ga e'i reki g̃ajikoga pe ojihe. ");
INSERT INTO pahNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Nahã Jesus'ga he'yive'g̃a mbo'embo'ei g̃a nderekovo. Henduvame ganhi'ig̃a g̃a ei ojohupe: —Onhimi hete ganhi'ig̃a nhande ve, ei g̃a. Nohendukatui po ahe a'ea, ei g̃a. ");
INSERT INTO pahNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Jesus'ga oyvyteri pe okwahavipe g̃a'ete'varuhua ojive. A'ero ga ei g̃a pe: —Nhinhi'ig̃a pe monhimboahivuhui naerũ? ei ga. ");
INSERT INTO pahNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Po ti pe hepiagi jijiupira yvagi pe nehẽ – perope ji ajuvypy – marãi po ti pe nehẽ naerũ? ei ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Tupana'ga ra'uva omboheaporog̃ita pyahu yvyakotyve'g̃a mongovo. Yvyakotyve'g̃a nomboheaporog̃itapyahui ojipe'g̃a mongovo, ei ga. Pe nhinhi'ig̃a rendukaturame ji pe mboheaporog̃itapyahuukari Tupana'ga ra'uva pe pe mongovouka. ");
INSERT INTO pahNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Jararamo ko pe ndaperoviari nhinhi'ig̃a, ei ga g̃a pe. A'ereki Jesus'ga okwahavipe g̃andeaporog̃ita. G̃a mbo'eypyrame vehevi ko ga okwahavipe gweroviare'ỹve'g̃a. Okwahavipe ga ga no – kiroki ga aerẽ ga mondouka guardas'g̃a po pe ga pyhygauka g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Igwete Jesus'ga ei g̃a pe: —Jararamo pe ndaperoviari nhinhi'ig̃a, ei ga. Nurã ji ei pe me ko: “Jiruva'ga ombojikoge'ymame po g̃a ndojikogi ji rehe,” ei ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","A'ero jara'g̃a pohiri Jesus'ga hugwi onhimongyavo. Ombo'embo'e ga g̃a novĩa. Kiro g̃a ndohopotara'javi ga rupi. ");
INSERT INTO pahNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","A'ero Jesus'ga ei dozeve'g̃a pe g̃wemimbo'ehara'g̃a pe: —Pehe peho pota ji hugwi no? ei ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Igwete Simão Pedro'ga ei ga pe: —Jesus, ma'g̃a pyri po ore hoi? ei ga. Ndehe jate ere'e ore ve: “Nahã ti pe ndeaporog̃itapyahuro pejikovo nehẽ,” ere ko nde ore ve, ei ga. ");
INSERT INTO pahNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Orokwaha hete ore nde rerovia. Nde ko pyryheteva'ero ereko Tupana'ga remimbuhurukaramo, ei Pedro'ga ga pe. ");
INSERT INTO pahNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Igwete Jesus'ga ei g̃a pe: —Opomo'emo'ẽ ji jijive dozeva'ero ikwehe novĩa, ei ga g̃a pe. Pepyteripeve'ga reki Diabo'gareheva'ero oko, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Judasva'ea pe Jesus'ga e'i Simão Iscariotes'ga ra'yrava'ea pe. Jesus'ga remimbo'ehara'g̃a ko dozeve'g̃a novĩa. Judasva'ea ki a'e te aerẽ Jesus'ga pyhyguka ga mondovouka. ");
INSERT INTO pahNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Aerẽ Jesus'ga hoi imbojoapiapiavo cidades repirepiaga Galiléiapeve'g̃a gwyri pe. Ga ndohopotari Judéiapeve'g̃a gwyri pe. A'ereki pevove'g̃a nduvihava'g̃a e'i tijuka ga javo. ");
INSERT INTO pahNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","A'ea rupi ko judeus'g̃a oapo g̃werĩ toryva huvihava. A'ea japorame g̃a oapo tapyi'ia okihavamo. ");
INSERT INTO pahNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Igwete Jesus'ga irũ'g̃a ei ga pe: —Pevo ti eho Judéiapeve'g̃a gwyri pe, ei g̃a. Nde erembo'embo'e g̃a pevo ikwehe. Ehoa'ja ti g̃a pyri a'ero tohepia ti g̃a nerembiapoa ahemonhimomby'ava'ea, ei g̃a Jesus'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Oukwahahetepotarame po ahe hepiukari ojipe'g̃a pe g̃wembiapoa hamo. Nde japorame ahemonhimomby'ava'ea ejipiuka ti g̃a pe nhaporemo a'ero, e'i tehe g̃a Jesus'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","A'ereki gairũ'g̃a vehevi ndojikogi reki ga rehe. ");
INSERT INTO pahNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Igwete Jesus'ga ei g̃a pe: —Ndohoi ve jihohava apiavo toryvi pe, ei ga. Kiromo jate pyryvamo pehoa, ei ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Kiroki g̃a noarõi Tupana'ga – g̃a nonhimonha'ngai pe ndehe. Emo ji rehe ko g̃a nhimonha'ngauhui jipi. A'ereki ji amombe'u katu g̃a pe jipi g̃andekote'varuhua, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Pehe ti peho toryvi pe a'ero, ei ga. Jihi ndahoi ve kiro. A'ereki ndohoi ve jihohava apiavo, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Onhi'ig̃irẽ g̃a pe Jesus'ga pytaahi'vi pevo a'ero Galiléiapeve'g̃a gwyri pe. ");
INSERT INTO pahNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Igwete Jesus'ga irũ'g̃a hoi toryvi pe. Aerẽ Jesus'ga hoi no. Ojipiukare'yma ga hoi ojipe'g̃a ndovakie'ỹ. ");
INSERT INTO pahNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Igwete judeus'g̃a nduvihava'g̃a ga rekarekaruhui toryva rupi mahã akoja'ga naerũ javo. ");
INSERT INTO pahNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Igwete he'yive'g̃a nhonhi'ig̃ayvayvari Jesus'ga rehe. Jara'g̃a ei: —Pyry hete ga. Jara'g̃a etehei ga pe: —Ga iporomoandyandyjuhu, ei g̃a o'eavo tehe ga pe. ");
INSERT INTO pahNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Okyhyji reki judeus'g̃a gwuvihava'g̃a hugwi. Nurã g̃a nonhi'ig̃i ojipe'g̃a ndovaki Jesus'ga mombe'gwovo tianerenduvyme ti g̃a javo g̃waramo. ");
INSERT INTO pahNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Três Jesus'ga kiri g̃a japorame toryva. Japopave'ymame ga hoi g̃ajatykahavuhua pyri pevove'g̃a mbo'eavo. ");
INSERT INTO pahNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Igwete judeus'g̃a nduvihava'g̃a nhimomby'ai ganhi'ig̃a renduva. —Marã po ga ikwahahetei mbatera? ei g̃a. A'ereki ikwahavipyra'g̃a nombo'eangavuhui ga, ei g̃a. ");
INSERT INTO pahNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Igwete Jesus'ga ei g̃a pe: —Nhiremimbo'ea rũi reki. A'ea ko Tupana'ga remimbo'ea nhimbuhurukara'ga remimbo'ea, ei ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Kiroki g̃a oko pota Tupana'ga remimbotarimova'ea rehe – g̃ahã po ti onhimombaragwaha Tupana'ga remimbo'ea rehe ji imombe'urame g̃a pe nehẽ, ei ga. “Tupana'ga remimbo'ea tuhẽ ga imombe'ui,” e po ti g̃a ji ve nehẽ, ei ga. “G̃wemimbo'etehea rũi ga omombe'u,” e po ti g̃a nehẽ ji mombe'urame g̃a pe nehẽ, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","—Kiroki g̃a omombe'u g̃wemimbo'etehea – g̃ahã e'i ji mbohete ti javo, ei ga. Jara'g̃a ki a'e te e'i: “Gaha ti pembohete ga – kiroki ga ji mbuhuruka avo.” Kiroki g̃a e'i poro – g̃a nomoandyandyi ojipe'g̃a. A'itituhẽva'ea g̃a omombe'u, ei ga. ");
INSERT INTO pahNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Moisésva'ea okwatija Tupana'ga nhi'ig̃a inog̃a pe me hako. Emo pe napehendukatupavi aheremimbo'eagwera, ei ga. Maraname pe ji jukapotaruhutehei? ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","A'ero he'yjuhuve'g̃a ei ga pe: —Anhag̃a nde pojykauhu nde mboheagwyryva Diabo'gapyriva'ea! Nurã po nde ei poro, ei g̃a. Ma'g̃a nde juka potaruhu naerũ? e'i tehe g̃a Jesus'ga pe. A'ereki g̃a ndokwahavi ve gwuvihava'g̃a nembijukapotara ga rehe. ");
INSERT INTO pahNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Igwete Jesus'ga ei: —Ojipeji ji japoi ahemonhimomby'ava'ea sábado rupi, ei ga. Hepiagame pe euhui ji ve: “Maraname ga japouhui sábado rupi nhandeporavykye'yma rupi?” pe'euhu pe ji ve, ei ga. ");
INSERT INTO pahNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Pehe na jitehe peapo mbatera sábado rupi no. A'ereki a'ea rupi pe peja'yra'g̃a nakwanha ikyti no Moisésva'ea nhi'ĩpo'rurame, ei ga. Moisésva'ea rũi reki e'i ypy jupe. Aherenondeva'ea penemboypya e'i ypy jupe hako, ei ga. “Pekyti ti peja'yra'g̃a nakwanha pi'ria sete pekirirẽ g̃a'ara rehe,” ei ahe hako, ei ga. ");
INSERT INTO pahNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Po pekipava horame sábado apiavo a'ero sábado rupi tuhẽ pe g̃a kyti tihendu katu ti Moisésva'ea remimbo'eagwera javo. Ji ki a'e te sábado rupi amombi pa akoja'ga ka'nahũa gara'oa hugwi, ei ga. Maraname pe nhimonha'ngauhui ji rehe naerũ? ei ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Tape'euhui ti ikwahahetee'ymame i'ara tehe hepiagame. A'itituhẽva'ea rupi katu po pe ei hamo, ei ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Igwete jara'g̃a Jerusalémmeve'g̃a ei ojohupe: —Akoja'ga rũi naerũ – kiroki ga nhanderuvihava'g̃a ojuka potaruhu ga? ei g̃a. ");
INSERT INTO pahNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Pehepia ti, ei g̃a. G̃andovaki hete ga nhi'inhi'ig̃i. Emo g̃a nde'i reki ga pe, ei g̃a. Mara'ngu po g̃a javo kiro ga pe: “Ga ko Cristoramo tuhẽ Tupana'ga remimbuhurukaramo”? Poha po g̃a euhui ga pe naerũ? ei g̃a ojohupe. ");
INSERT INTO pahNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Ga ko a'ea rũi reki. Cristo'ga jipiukarame po ti nhande ndikwahavi garura ma hugwi po ga ruri javo, ei g̃a. Akoja'ga gwyruera reki nhande tikwaha hete, ei g̃a ojohupe. ");
INSERT INTO pahNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","A'ero Jesus'ga eahyahivi g̃a mbo'erame g̃ajatykahavuhua pype. —“Tikwaha hete nhande ga,” pe'jiuhu pe ji ve naerũ? ei Jesus'ga. “Tikwaha hete nhande gagwyruera,” pe'jiuhu pe no, ei ga. Nhiremimbotarimo rũi reki ji ruri. Kiroki ga ji mbuhuruka kokoty – ga ko a'itituhẽve'ga. Gaha pe ndapekwahavihu, ei ga. ");
INSERT INTO pahNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Jihi reki akwaha ga. A'ereki ga hugwi ji ajo. Gaha ji mbuhuruka kokoty, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","A'ero jara'g̃a Jesus'ga pyhypotari. Ndopokogi reki g̃a ga rehe ga pyhyga. A'ereki ndohoi ve gapyhyhava apiavo. ");
INSERT INTO pahNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","He'yjuhu hete reki g̃a – kiroki g̃a ojiko Jesus'ga rehe. A'ero g̃a ei ojohupe: —Jesus'ga oapo pa ahemonhimomby'ava'ea, ei g̃a. Ndia'ei po nhande a'ero: “Cristo'ga rurame koji'i tehe po ti ga japoi ahemonhimomby'ava'ea Jesus'ga hohe nehẽ.” Poa po nhande ndia'ei, ei g̃a. A'ereki Jesus'ga oapopavipe ahemonhimomby'ava'ea jipi, ei g̃a. Ga ko Cristoramo tuhẽ a'ero, ei g̃a. ");
INSERT INTO pahNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Igwete he'yjuhuve'g̃a imombe'ui nahanahã ko Jesus'ga rekoi javo. G̃anhi'ig̃a renduvame fariseus'g̃a ei a'ero ikwava'ẽhara'g̃a nduvihava'g̃a pavẽi: —Tipyhyguka ti Jesus'ga. A'ero g̃a ei guardas'g̃a pe – kiroki g̃a gwepia katu judeus'g̃a jatykahavuhua. A'ero g̃a ei g̃a pe: —Pepyhy ti Jesus'ga rerua ore pyri, ei g̃a. ");
INSERT INTO pahNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Igwete Jesus'ga ei onhimombe'gwovo pevove'g̃a pe: —Apytaahi'vi po ti ji pe pyri nehẽ, ei ga. A'ero po ti ji hoa'javi ga pyri nehẽ – kiroki ga ji mbuhuruka kokoty, ei ga. ");
INSERT INTO pahNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Pe po ti ji rekarekari nehẽ tiandepoko ti ga javo ji ve nehẽ novĩa. Emo po ti pe ndajirepiaga'javi nehẽ, ei ga. A'ereki tegwete pehohava ji pyri – perope ji aju, ei ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Igwete judeus'g̃a nduvihava'g̃a ei ojohupe: —Marã ga euhui ndajirepiaga'javi po ti pe nehẽ javo? Mome tuhẽ po ti ga houhui a'ero nehẽ naerũ? ei g̃a. Nhandere'yja'g̃a pyri po ti ga hoi nehẽ naerũ? ei g̃a, kiroki g̃a okwaki'o judeus'g̃arũive'g̃a gwyri pe? ei g̃a. Ombo'e po ti ga judeus'g̃arũive'g̃a pevo nehẽ naerũ? ei g̃a novĩa. ");
INSERT INTO pahNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","A'ereki ga e'i: “Ji rekareka po ti pe nehẽ novĩa. Emo po ti pe ndajirepiaga'javi tuhẽ nehẽ,” ei ga, ei g̃a. “Tegwete pehohava ji pyri – perope ji aju,” ei ga, ei g̃a. Gara pe po ga euhui naerũ? ei g̃a ojohupe. ");
INSERT INTO pahNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Okioki g̃a toryva apovo. Aerẽ mbapavava'ea rupi huvihava rupi Jesus'ga po'ami onhi'ig̃a hahyahi g̃a pe: —Kiroki g̃a yhya pota oygwejamo – tuhu ti g̃a ji pyri oy'gwovo a'ero, ei ga g̃a pe. Nahã a'ero, a'e ji, ei ga. Kiroki g̃a opota Tupana'ga ra'uva rekoa onhipavẽi – tojiko ti g̃a ji rehe a'ero. A'ero po ti g̃a herekoi a'ea nehẽ yhya'java'ea – kiroki a'ea g̃a mboheaporog̃ita pyahu g̃a mongovo, ei ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","G̃a jikogame ji rehe po ti g̃a herekohetei yhya'java'ea nehẽ. Ji mombe'umbe'u po ti g̃a ojipe'g̃ape'g̃a pe nehẽ, ei ga. Henduvame po ti g̃a jikogi ji rehe no herekoheteavo yhya'java'ea. A'ea po ti g̃a mboheaporog̃itapyahui g̃a mongovo Tupana'ga pyri nehẽ no, ei ga. A'ea jitehe Tupana'ga rembikwatijarukara omombe'u no, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Tupana'ga ra'uva pe Jesus'ga ei a'ero a'ea ko yhya'java'ea javo. A'ereki ga e'i: —G̃a jikogame ji rehe yhya'java'ea po ti ji imondoi g̃a pyri nehẽ a'ea ti togwereko katu g̃a javo nehẽ, ei ga. A'ea rupi Jesus'ga nomondoi ve gara'uva ojiheve'g̃a pyri. A'ereki ga nomanoi ve. A'ero Tupana'ga nombogweravi ve ga rupia ojipyri ga mboheteavo. Ohoe'ymame Jesus'ga nomondoi ve gara'uva ojiheve'g̃a pyri. ");
INSERT INTO pahNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","He'yive'g̃a g̃wendu Jesus'ga nhi'ig̃ame. A'ero jara'g̃a ei: —Ga ko Tupana'ga nhi'ig̃a mombe'uharamo tuhẽ Moisésva'ea remimombe'uhara'ga, ei g̃a. ");
INSERT INTO pahNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Jara'g̃a ei: —Ga ko Cristoramo Tupana'ga remimbuhurukaramo. —Ahã, e'i tehe jara'g̃a g̃a pe. Jesus'ga ko Galiléiapeve'ga. Cristo'ga po ti Galiléiapeve'ga rũi nehẽ! ei g̃a. ");
INSERT INTO pahNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Tupana'ga rembikwatijarukara e'i: “Cristo'ga po ti oko Daviva'ea rymyminoro nehẽ,” e'i. “O'a po ti ga cidade de Belém me – perope Daviva'ea uvypy,” e'i ikwatijara, ei g̃a. ");
INSERT INTO pahNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Nahã g̃a nhonhi'ig̃ayvayvari Jesus'ga rehe upa. ");
INSERT INTO pahNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Jara'g̃a ga pyhy pota novĩa. Emo g̃a ndopokogi ve ga rehe a. ");
INSERT INTO pahNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","A'ero guardas'g̃a jivyri ikwava'ẽhara'g̃a nduvihava'g̃a pyri fariseus'g̃a pyri no. Igwete g̃a ei guardas'g̃a pe: —Maranuhũrame pe ndapepyhygi Jesus'ga rerua ra'e? ei g̃a g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Igwete guardas'g̃a ei: —A'ea ko jara'g̃a nhi'ig̃a ja rũi ga nhi'ig̃ame, ei g̃a. Norohenduvangavi ore nanongara, ei g̃a g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Igwete fariseus'g̃a ei g̃a pe: —Pehe na jitehe ga pe moandyandyjuhu? ");
INSERT INTO pahNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Ndapekwahavihu pe? ei g̃a g̃a pe. Judeus'g̃a nduvihava'g̃a ndojikogi pa ga rehe. Ore na jitehe fariseusramo ndorojikogi pa ga rehe no, ei g̃a. ");
INSERT INTO pahNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Avove'g̃a ki a'e te okoteheuhu onhimongyavo. G̃ahã ndokwahavihu Moisésva'ea remimbo'eagwera, ei g̃a g̃a pe. Nanongara'g̃a reki ojiko Jesus'ga rehe. Tupana'ga po ti imbohahyi g̃a pe nehẽ peko te'varuhu pe javo, etehei g̃a guardas'g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Igwete Nicodemos'ga ei fariseus'g̃a pe javo. Nicodemos'ga ko fariseuramo oko no. Gaha ko oho na'ẽ Jesus'ga pyri raikwehe tahendu ti ganhi'ig̃a javo. Igwete ga ei g̃a pe: ");
INSERT INTO pahNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","—Moisésva'ea remimbo'eagwera e'i nhande ve: “Pehendu na'ẽ ti g̃a nhimombe'urame pe me. Ikwahavirẽ g̃andeaporog̃ita ti pyry pe ei g̃a pe,” e'i aherembikwatijara nhande ve, ei ga g̃a pe. Jesus'ga nhi'ig̃a renduve'ymame xa'ete'varuhuyme ti ga pe a'ero, ei Nicodemos'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Nurã g̃a ei Nicodemos'ga pe: —Nde ko Galiléiapeva'ero jitehe naerũ? Nurã nde vavagahivuhui ga rehe a, ei g̃a Nicodemos'ga pe. Ehepia ti Tupana'ga rembikwatijarukara ikwahava a'ero, ei g̃a. A'ereki a'ea nde'iangavi: “Tupana'ga nhi'ig̃a mombe'uhara'g̃a Galiléiapeva'ero oko,” nde'i, e'i tehe g̃a. Jesus'ga ki a'e te Galiléiapeva'ero, ei g̃a ga pe.  ");
INSERT INTO pahNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Igwete g̃a kwaki'opavi ogwovo g̃wonga pype upa. ");
INSERT INTO pahNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Kiro Jesus'ga hoi oliveira ndyvuhu pe monte das Oliveiras pe. ");
INSERT INTO pahNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Ypyhajive ga rura'javi judeus'g̃a jatykahavuhua rokari pe. Kiro g̃a ndupavi a'ero onhimongyavo ga pyri. A'ero ga reni g̃a mbo'embo'eavo. ");
INSERT INTO pahNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","A'ea rupi judeus'g̃a mbo'ehara'g̃a hẽa pyhygi hẽa rerua fariseus'g̃a pavẽi. Hẽa g̃wembireko'garũive'ga rerekorame g̃a hẽa pyhygi hẽa rerua hẽa mo'ama Jesus'g̃a pyteri pe. ");
INSERT INTO pahNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Igwete g̃a ei Jesus'ga pe: —Jesus, gwereko hẽa g̃wembireko'garũive'ga. Nurã ore hẽa pyhygi hẽa rerua, ei g̃a. ");
INSERT INTO pahNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Ahe mbo'erame Moisésva'ea ei ikwatija hako: “Peapi ti nanongara'g̃a jukavo kunhangwera'g̃a,” ei ahe hako. Oro nde? ei g̃a Jesus'ga pe. Marãi re po nde naerũ? Toroapi ti hẽa naerũ? ei g̃a. ");
INSERT INTO pahNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","A'ereki g̃a e'i jipe ojohupe: —Tihendu ti ganhi'ig̃a, ei g̃a. Ga nhanenhi'ĩpondekwate'varuhurame po ti nhande imombe'ui nhanderuvihava'g̃a pe nehẽ. “Nohendukatui ga Moisésva'ea nhi'ig̃a,” xa'e ti ga mombe'gwovo a'ero g̃a pe nehẽ, ei g̃a ojohupe. Nurã g̃a ei Jesus'ga pe: “Marãi re po nde naerũ?” Kiro Jesus'ga nhova'apyni oina opũa pyvõ ikwatija yvya rehe. ");
INSERT INTO pahNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Ndopigi reki g̃a ja'javo ga pe. A'ero ga po'ami javo g̃a pe: —Kiroki ga ndokote'varuhuangavi – ga ypy ti toapi hẽa, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Igwete ga nhova'apyna'javi oina a'ero yvya rehe ikwatijara'java. ");
INSERT INTO pahNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Ganhi'ig̃a renduvame kiro onhinanhinani g̃a hog̃ahoi. Xava'eve'g̃a ypy oho. A'ero g̃a hopavi Jesus'ga reja – kiroki g̃a gweru hẽa. Pevo hẽa ami a'ero ga pyri jara'g̃a pyteri pe. ");
INSERT INTO pahNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Kiro Jesus'ga po'ama'javi javo hẽa pe. —Mahã akoja'g̃a naerũ? ei ga. G̃a nde'ia'javi nde ve teremano javo? ei ga hẽa pe. ");
INSERT INTO pahNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","—Ahã tuhẽ, ei hẽa. —Ji na jitehe nda'ei nde ve, ei ga. Heregwovo a'ero, ei ga. Epohi ti kiro ekote'varuhua hugwi, ei Jesus'ga hẽa pe. ");
INSERT INTO pahNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Aerẽ Jesus'ga nhi'ig̃a'javi he'yive'g̃a pe: —Arimo ko nhande hepiakatui mbatera ikwahavag̃wama. A'ereki mytu'ẽ nhande ve, ei ga. Na jitehe ji amomytu'ẽ yvyakotyve'g̃a pe. A'ereki ji akwahavuka Tupana'ga g̃a pe, ei Jesus'ga g̃a pe. Kiroki g̃a ojiko ji rehe ji nhi'ĩpo'ruavo – g̃a po ti nde'ia'javi: “Ndakwahavi ji Tupana'ga,” ei ga. Okwaha tuhẽ po ti g̃a Tupana'ga gweaporog̃itapyahuro nehẽ, ei ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Igwete fariseus'g̃a ei ga pe: —Nde tehe erenhimombe'u, ei g̃a. Nurã ore ndorogweroviari nenhi'ig̃a ndetehero g̃waramo, ei g̃a ga pe. ");
INSERT INTO pahNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","A'ero ga ei g̃a pe: —A'iti ji tehe anhimombe'u pe me. Emo a'itituhẽva'ea rupi katu nhinhimombe'ua a, ei ga. A'ereki ji hete tuhẽ akwaha jiruhava – perope ji ajo jugwi – perope ji aho jupe no, ei ga. Pe ki a'e te ndapekwahavi pea – perope ji ajo jugwi – perope ji aho jupe, ei ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Ojipe'g̃a ara tehe pe pehepia. Ikwahahetee'yma pe etehei g̃a pe a'ero peko te'varuhu pe javo, ei ga. Nahã ko yvyakotyve'g̃a jipi. Ji ki a'e te nda'ei poa ojipe'g̃a pe, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Ji erame poa g̃a pe a'itituhẽva'ea rupi katu nhirembi'ea a'ero. A'ereki ji tehe rũi a'e. Ore memei oro'e jihi jiruva'ga pavẽi nhimbuhurukara'ga pavẽi, ei ga. ");
INSERT INTO pahNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Peapoa aherembikwatijara e'i no: “Mokonha'g̃a imombe'urame mbatera na tuhẽ javo a'ero hupi katu g̃anembi'ea,” e'i. “A'ereki g̃a memei e'i a jupe,” e'i ikwatijara, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Jihi anhimombe'u, ei ga. Jiruva'ga ji mombe'u jitehe no nhimbuhurukara'ga, ei ga. Ore memei ji mombe'u a'ero, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","A'ero g̃a ei ga pe: —Mahã nderuva'ga naerũ? ei g̃a ga pe. —Pe ndajikwahavi tuhẽ, ei Jesus'ga. Ndapekwahavi jitehe pe jiruva'ga a'ero, ei ga g̃a pe. Po pe ji kwahavi tuhẽ hamo, a'ero po pe jiruva'ga kwahavi hamo no, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","A'ea Jesus'ga ei g̃a mbo'erame judeus'g̃a jatykahavuhua pype – perope hyru'ia pyri. A'ea pype judeus'g̃a omondomondo itambere'ia Tupana'ga pe jipi. Pevo Jesus'ga ei g̃a pe g̃a mbo'eavo. A'ero jara'g̃a ga pyhypotari novĩa. Emo g̃a ndopyhygi ga. A'ereki ndohoi ve gapyhyhava apiavo. ");
INSERT INTO pahNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Aerẽ Jesus'ga nhi'ig̃a'javi judeus'g̃a nduvihava'g̃a pe: —Aho po ti ji avo hugwi nehẽ, ei ga. Ji reka po ti pe nehẽ ore poko ti javo nehẽ novĩa. Pejikote'varuhua momborukare'ymame po ti pe manoi pejigwovo hahyva'ea ruvihava pype nehẽ, ei ga. Perope ji aho – pevo ki a'e te tegwete pehohava ji pyri, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Igwete judeus'g̃a nduvihava'g̃a ei ojohupe: —Marãi ga a'ero? Ojijukauhu po ti ga nehẽ naerũ? ei g̃a. A'ereki ga e'i: “Perope ji aho – tegwete pehohava ji pyri,” ei ga, ei g̃a. Gara pe po ga ei? ei g̃a ojohupe. ");
INSERT INTO pahNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Igwete Jesus'ga ei g̃a pe: —Pe ko yvyakotyva'ea. Ji ki a'e te yvagipeva'ea, ei ga. Pendeaporog̃ita te'varuhu pe yvyakotyva'ero g̃waramo. Ji ko na rũi, ei ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Nurã ji ei pe me ko: “Pemano po ti pe imomborukare'ymame pejikote'varuhua nehẽ,” ei ga g̃a pe. Na tuhẽ, ei ga. Ji ko Tupanamo ako. Po ti pe ndaperoviari a'ea nehẽ, a'ero po ti pe manoi pejikote'varuhuro g̃waramo nehẽ, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","—Mome ahe tuhẽ nde naerũ? ei g̃a ga pe. —A'ea ypy tuhẽ ko ji a'e pe me, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Opomombe'uahivuhu tuhẽ po ji hamo pe ndekote'varuhuro g̃waramo. Emo ganhi'ig̃a jate ko ji amombe'u yvyakotyve'g̃a pe nhiremienduvamo, ei ga. Ganhi'ig̃a ko a'itituhẽva'ea nhimbuhurukara'ga nhi'ig̃a, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Gwuva'ga pe Tupana'ga pe Jesus'ga ei gaha ji mbuhuruka javo. A'ea onhimi reki judeus'g̃a nduvihava'g̃a pe ga erame g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Nurã Jesus'ga ei g̃a pe: —Ji ko Tupana'ga remimbuhurukara, ei ga. Pe ji mbovyrame ji mo'ama yva rehe po ti pe ji kwahavi nehẽ, ei ga. “Ga ko Tupanamo tuhẽ oko,” pe'ji po ti pe ji ve nehẽ, ei ga. “Ga ko ndokoi g̃wemimbotarimova'ea rehe. Uva'ga remimbo'ea jate ga omombe'u okovo,” pe'ji po ti pe ji ve nehẽ, ei ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Kiroki ga ji mbuhuruka – gaha ji pavẽi oko jipi. Ga ndopohiri ji hugwi, ei ga. A'ereki ji ako garemimbotarimova'ea rehe jipi ganhimohemag̃wama ji rehe, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Henduvame ganhi'ig̃a jara'g̃a jikogi ga rehe onhimongyavo. ");
INSERT INTO pahNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Igwete Jesus'ga ei judeus'g̃a pe – kiroki g̃a ojiko ga rehe: —Po ti pe ndekoi nhinhi'ig̃a rupi jipi jireheva'ea tuhẽ po ti pe ndekoi nehẽ, ei ga. ");
INSERT INTO pahNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Igwete po ti pe Tupana'ga kwahavi nehẽ a'itituhẽve'ga. Ga kwahava g̃waramo po ti pe piro'yro nehẽ, ei ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Igwete g̃a ei ga pe: —Maraname nde euhui poha ore ve? ei g̃a ga pe. Oreremimbotarimova'ea rehe jate tuhẽ ore rekoi. Ore ko Abraãova'ea rymyminoro oroko, ei g̃a. Orepiro'y tuhẽ ore ojipe'g̃a hugwi jipi. Ndipopoakari tuhẽ g̃a ore rehe, ei g̃a. Marãi nde ore ve naerũ: “Pepiro'y po ti pe nehẽ”? ei g̃a ga pe. ");
INSERT INTO pahNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Igwete Jesus'ga ei g̃a pe: —Tamombe'u katu tuhẽ pe me, ei ga. Kiroki g̃a oko te'varuhu jipi – g̃a ndipiro'yi tuhẽ okote'varuhua hugwi. G̃andekote'varuhua ipopoaka hete g̃a ndehe a'ero, ei ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Nahã aherongapypeve'g̃a, ei ga. Xava'eve'ga po omondomondo ojipyrive'g̃a okoteheve'g̃a jipi. G̃a potara'jave'ymame ga g̃a mondohetei ojihugwi, ei ga. Gwa'yra'ga ki a'e te ga nomondoi tuhẽ. Gae'ỹe'ymi opyta uva'ga pyri gara'yra'ga g̃waramo, ei ga. ");
INSERT INTO pahNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Ji ko Tupana'ga ra'yramo, ei ga g̃a pe. Gara'yra g̃waramo ji imombigi aherekote'varuhua popoakara ahe hugwi. Po ti ji imombigi pe hugwi nehẽ, a'ero po ti ndipopoakari tuhẽ pe ndehe nehẽ, ei ga. ");
INSERT INTO pahNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Pe ko Abraãova'ea rymyminoro peko novĩa. Emo pe ji juka pota reki. A'ereki pe me ndatekwavi nhiremimbo'ea rehe, ei ga. ");
INSERT INTO pahNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Ahepia ji jiruva'ga rekoa. Nhirembiepiaga ji amombe'u katu pe me a'ero, ei ga. Pehe pehendu penduva'ga Diabo'ga. Penemienduva pe pehendu katu a'ero, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","—Abraãova'ea ko oreramonhava'ea, ei g̃a ga pe. Igwete Jesus'ga ei: —Abraãova'ea rymyminoro po pe ndekoi, a'ero po ahe javijitehe pe ndekokatui hamo, a'e ji pe me, ei ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Pe ki a'e te ji juka potaruhu, ei ga. Amombe'umbe'u ji pe me a'itituhẽva'ea Tupana'ga remimombe'ua. Pe ki a'e te ji juka potaruhu, ei ga. Na rũi ko Abraãova'ea rekoi hako! ");
INSERT INTO pahNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Pejijuvete'ga javijitehe ko pe ndekote'varuhui! ei ga g̃a pe. A'ero g̃a ei ga pe: —Tupana'ga ra'yreteramo jate ore rekoi, ei g̃a. Ndorogwerekoi ore jara'ga orojuvetero, ei g̃a ga pe. ");
INSERT INTO pahNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Igwete Jesus'ga ei g̃a pe: —Po Tupana'ga penduvetero oko hamo, a'ero po pe ji arõhetei hamo, ei ga g̃a pe. A'ereki ji Tupana'ga hugwi ajo. Ji nanhimbuhuri avo. Gaha ji mbuhuruka kokoty, ei ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Marã pe ndapekwahavihu nhinhi'ig̃a naerũ? ei ga. Pe napehendupotari nhiremimombe'ua. Nurã pe ndapekwahavihu, ei ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Pe ko Diabo'ga ra'yramo tuhẽ peko okote'varuhuve'ga ra'yramo. A'ero pe ndekote'vapotaruhui Diabo'ga remimbotarimova'ea rehe pejikovo, ei ga g̃a pe. Tupana'ga rembiapoypyagwera jate Diabo'ga ahe momanomanoukari kiromo jate. Ga ndokoi a'itituhẽva'ea rehe. A'ereki a'itituhẽva'ea rehe ndatekwava'javi ga pe, ei ga g̃a pe. O'mberame ga rekoi gweaporog̃ita rupi. A'ereki ga i'mbeuhuve'ga tuhẽ. Gaha ahe mo'mbeuhu okovo no, ei ga. ");
INSERT INTO pahNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Peroviaruhu pe ga'mbea jipi. Nurã ko pe ndajireroviarihu reki a'ero. A'ereki ji a'itituhẽva'ea mombe'u pe me, ei ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Manamo po ti pe hepiukari jirekote'varuhua naerũ? Ndapehepiukari tuhẽ po ti pe jirekote'varuhue'yma g̃waramo, ei ga. Marã naerũ? Ji a'itituhẽva'ea mombe'urame pe me maraname pe ndajireroviarihu naerũ? ei ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Tupana'gareheve'g̃a g̃wendu katu ganhi'ig̃a. Pe ki a'e te napehendukatui ganhi'ig̃a gareheva'ero pejikoe'yma g̃waramo, ei ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Igwete judeus'g̃a nduvihava'g̃a ei Jesus'ga pe: —Nde ko judeuramo rũi reki, e'i tehe g̃a. Nde ko Samariapeva'ea ekote'varuhuva'ea. Anhag̃a nde pojykauhu Diabo'gapyriva'ea, ei g̃a. Oromombe'u katu nde a, e'i tehe g̃a Jesus'ga pe. ");
INSERT INTO pahNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Igwete Jesus'ga ei g̃a pe: —Anhag̃a ndajipojykai tuhẽ, ei ga. Jihi ambohete jiruva'ga. Pe ki a'e te ji mbotegweteuhu, ei ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Ji nda'ei reki ojipe'g̃a pe tanhimbohete ti g̃a javo. Ojipe'ga e'i nhimbohetea rehe tombohete ti g̃a ga javo. Gaha okwaha hete javo a'itituhẽva'ea rupi katu Tupana'ga, ei ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Tamombe'u katu tuhẽ pe me, ei ga. Kiroki g̃a g̃wendu katu nhinhi'ig̃a – okoe'ymi po ti g̃a nehẽ, ei ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Igwete g̃a ei Jesus'ga pe: —Nurã ore kiro ikwahahetei a'ero. Anhag̃a nde pojyka tuhẽ, ei g̃a ga pe. Abraãova'ea omano hako. Tupana'ga nhi'ig̃a mombe'uharava'ea na jitehe omanomba hako, ei g̃a. Marã kiro nde euhui naerũ? “Kiroki g̃a g̃wendu katu nhinhi'ig̃a – g̃a po ti okoe'ymi nehẽ,” ereteheuhu nde, ei g̃a ga pe. ");
INSERT INTO pahNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Omano ko oreramonhava'ea Abraãova'ea hako. Tupana'ga nhi'ig̃a mombe'uharava'ea omano jitehe no, ei g̃a. Nde po nderuvihavuhu Abraãova'ea hohe naerũ nhirendukatuve'g̃a po ti okoe'ymi javo naerũ? ei g̃a. Mome ahe tuhẽ nde naerũ poha nde eag̃wama? ei g̃a ga pe. ");
INSERT INTO pahNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Igwete Jesus'ga ei g̃a pe: —Po jiteheuhu anhimbohete, a'ea po ndapyryvi hamo, ei ga. Jiruva'ga reki ji mbohete Tupana'ga – ga pe jitehe pe'e tehe reki orombohete ore ga javo tehe, ei ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Pe ndapekwahavi reki ga. Ji ki a'e te akwaha ga. Po ji ei hamo ji ndakwahavi ga javo, a'ero po ji mbero pe javijitehe hamo no, ei ga g̃a pe. Ji ki a'e te akwaha tuhẽ ga. Igwete ji hendukatui ganhi'ig̃a no, ei ga. ");
INSERT INTO pahNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Penamonhava'ea Abraãova'ea jirurag̃wama gwepia potarahi hete hako. Igwete ahe hepiagi reki gworygworyvamo hehe, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Igwete g̃a ei ga pe: —Nandexava'ejuhu nde. Cinquenta kwara ndohoi ve nde rehe, ei g̃a. Marã nde Abraãova'ea repiaguhui naerũ? ei g̃a ga pe. ");
INSERT INTO pahNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","—Tamombe'u katu tuhẽ ti pe me, ei Jesus'ga g̃a pe. Abraãova'ea are'ymame kiromo tuhẽ ji rekoi Tupanamo, ei ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","A'ero g̃a ipyhygi ita tiapi ti ga javo. “A'ereki ga onhimongo Tupanamo o'mbero,” ei g̃a ojohupe. Kiro Jesus'ga nhimimi g̃a hugwi a'ero ogwovo judeus'g̃a jatykahavuhua rokara hugwi. ");
INSERT INTO pahNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Aerẽ ohorame Jesus'ga hehae'ỹve'ga repiagi. O'arypyrame vehevi ga ndahehai. ");
INSERT INTO pahNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Kiro Jesus'ga remimbo'ehara'g̃a ei Jesus'ga pe a'ero: —Ma'g̃a ndekote'varuhua ga mbohehate'varuhui? Garekote'varuhua tuhẽ? ei g̃a. Mara'ngu po garuva'g̃a ndekote'varuhua ga mbohehate'varuhuavo? Marã? ei g̃a ga pe. ");
INSERT INTO pahNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","A'ero Jesus'ga ei g̃a pe: —Garekote'varuhua rũi ga mbohehate'varuhui, ei ga g̃a pe. Garuva'g̃a ndekote'varuhua rũi ga mbohehate'varuhui no, ei Jesus'ga. Tupana'ga omboukwaha pota nhande ve opopoakara ga rehe nehẽ. Nurã ga ndahehai, ei ga. ");
INSERT INTO pahNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Igwete Jesus'ga ei no: —Kiro arimo nhande poravykyi nhandekovo, ei ga. A'ereki aerẽ ypytunimo tegwete nhandeporavykyhava. A'ea rupi nhande ndiaporavykya'javi a'ero, ei ga. Na jitehe ag̃wamo ti xaporavyky a'ero. Timboukwaha ti g̃a pe Tupana'ga popoakara nhimbuhurukara'ga popoakara, ei ga. A'ereki aerẽ nhande manorẽ tegwete nhande ve Tupana'ga mboukwahahava, ei ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Arimo mytu'ẽ nhande ve. Nurã nhande hepiagi ikwahavag̃wama. Na jitehe ji ruvame yvya koty ji imomytu'ẽi yvyakotyve'g̃a akag̃i pe tokwaha ti g̃a Tupana'ga javo. ");
INSERT INTO pahNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Onhi'ig̃irẽ Jesus'ga nyvuni yja rehe ikotiamo. A'ea ga imongyi hehae'ỹve'ga ropepira rehe a'ero. ");
INSERT INTO pahNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","—Heregwovo ejovaheita kiro, ei Jesus'ga ga pe. Pevo ypia'i pe Siloé pe ti eho, ei ga. (Siloé ko Imondopyra.) Pevo hehae'ỹve'ga hoi a'ero. Ojovaheirẽ ga hepiakatui ua. Judeus'g̃a poravykye'yma rupi sábado rupi Jesus'ga japoi yja kotimbyra a'ea pyvõ ga mbohehavo katu. ");
INSERT INTO pahNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Aerẽ hehae'ỹgwera'ga rongakotyve'g̃a ga repiagi. Igwete g̃a ei jara'g̃a pavẽi – kiroki g̃a hehae'ỹve'ga repia ga poranduranduvame itambere'ia rehe jipi – igwete g̃a ei: —Akoja'ga rũi novĩa? ei g̃a ojohupe, kiroki ga oporandurandu itambere'ia rehe jipi oina, ei g̃a. ");
INSERT INTO pahNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","—Ga tuhẽ, ei jara'g̃a. Emo jara'g̃a e'i: —Akoja'ga'jave'ga tehe, ei g̃a. Hehae'ỹgwera'ga e'i g̃a pe a'ero: —Ji tuhẽ ko a'ea, ei ga. ");
INSERT INTO pahNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","—Marã nde rehakaturamo kirog̃we a'ero? ei g̃a ga pe. ");
INSERT INTO pahNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","—Uhu ga ji pyri – Jesus ei g̃a ga pe, ei ga. Igwete ga ikotĩ yja g̃wendya pyvõ imongyavo jiropepira rehe, ei ga. A'ero ga ji mondoi ypia'i pe Siloé pe ji mbojovaheita, ei ga. Ganhi'ig̃a rupi ji hoi a'ero. Jijovaheipavame kiro ji ma'eg̃atui, ei ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","—Mahã ga naerũ? ei g̃a ga pe. —Ji ndakwahavi, ei ga. ");
INSERT INTO pahNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","14","Judeus'g̃a poravykye'yma rupi sábado rupi Jesus'ga japoi yja kotimbyra a'ea pyvõ ga mbohehavo katu. Kiro g̃a hehae'ỹgwera'ga rerohoi fariseus'g̃a pyri a'ero. ");
INSERT INTO pahNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Igwete fariseus'g̃a ei ga pe no: —Marã nde rehakaturamo ag̃wamo naerũ? —Omongy ga yja kotimbyra jiropepira rehe, ei ga. Igwete ji jovahei nhima'eg̃atuag̃wama, ei ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Jararamo g̃a ei ga pe a'ero: —Akoja'ga koi Tupana'ga nombuhurukari ga, ei g̃a. A'ereki ga oapo mbatera sábado rupi nhaneramonhava'ea nhi'ĩpo'rue'ymamo. Oko te'varuhu ga a'ero, ei g̃a. Jara'g̃a e'i: —Po ga rekote'varuhui hamo, a'ero po ga ndoapoi nanongara ahemonhimomby'ava'ea jipi hamo, ei g̃a. A'ero g̃a nhonhi'ig̃ayvari ga rehe. ");
INSERT INTO pahNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Igwete g̃a ea'javi hehae'ỹgwera'ga pe: —Oro nde? ei g̃a ga pe. Po ga nde mbohehakatui marãi re po nde ga pe a'ero? ei g̃a. —Tupana'ga nhi'ig̃a mombe'uhara'ga po, a'e ji, ei ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Emo judeus'g̃a nduvihava'g̃a ndogweroviapotari ga mbohehakatua. —Ndahehai po ga raji'i, ei g̃a novĩa. A'ero g̃a hehae'ỹgwera'ga ruva'ga mbuhurukari ojipyri gayhẽa reheve. ");
INSERT INTO pahNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","—Pe'ji katu ti ore ve, ei g̃a g̃a pe. Gaha ko ndera'yramo? A'iti ga ndahehai o'arame novĩa? ei g̃a. Pe'ji ti ore ve. Marã kiro ga rehauhuro naerũ? ei g̃a g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","—Ga orera'yra'ga tuhẽ, ei g̃a. A'iti tuhẽ ko ga ndahehai o'arame ikwehe novĩa. A'ea ore orokwaha hete, ei g̃a g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Emo gambohehakatuagwera – a'ea ore ndorokwahavi. Marã po ga ma'eg̃atui kiro? oro'e ore, ei g̃a. Ma'g̃a omboheha katu ga naerũ? oro'e ore. A'ereki ore ndorokwahavi gambohehakatuagwera, ei g̃a g̃a pe. Pe'ji ti ga pe a'ero. A'ereki ga yvuakaruhu. Gaha po ti onhimombe'u pe me nehẽ, ei g̃a g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","A'ea g̃a ei okyhyjiavo. A'ereki ojikwe judeus'g̃a nduvihava'g̃a e'i ojohupe: “Kiroki g̃a e'i Jesus'ga pe: ‘Ga ko Cristoramo Tupana'ga remimbuhurukaramo’ – timo'ẽuka hete ti g̃a mondovouka avuirama nhandejatykahava hugwi nehẽ tura'javyme ti g̃a ipype javo nehẽ,” e'i jipe judeus'g̃a nduvihava'g̃a ojohupe. ");
INSERT INTO pahNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Nurã hehae'ỹgwera'ga ruva'g̃a ei g̃a pe: “Orera'yra'ga yvuakaruhu. Pe'ji ti ga pe a'ero tomombe'u ti ga ombohehakatuagwera javo,” ei g̃a g̃a pe. A'ereki g̃a okyhyji hete gwuvihava'g̃a hugwi. ");
INSERT INTO pahNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Kiro fariseus'g̃a hehae'ỹgwera'ga mbuhurukara'javi ojipyri a'ero. —Ere ti kiro ore ve: “A'itituhẽva'ea jate ti ji amombe'u. A'ereki Tupana'ga ji rendu.” Ere ti poro kiro, ei g̃a ga pe. A'ereki ore orokwaha hete akoja'ga rekote'varuhua, ei g̃a. Jesus'ga pe g̃a ei o'mbero oko te'varuhu ga javo. ");
INSERT INTO pahNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","—A'ea ji ndakwahavi, ei ga. Mara'ngu po ga okote'varuhuavo? ei ga. Emo ymya ji ndajirehai hepiage'yma. Ag̃wamo ji rehakaturo hepiakatuavo. A'ea ji akwaha hete reki jitekovo, ei ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Igwete g̃a ei ga pe: —Marã ga nde rerekoi nde mbohehakatuavo? ei g̃a ga pe. ");
INSERT INTO pahNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","—Amombe'u ko ji pe me ko, ei ga g̃a pe. Pe ki a'e te napehendukatui, ei ga g̃a pe. Maranuhũrame pe hendupotara'javuhui naerũ? Peko pota pe gareheva'ero no naerũ? ei ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","A'ero g̃a ete'varuhuhetei ja'javo ga pe. —Ndehe tehe reki erekouhu akoja'gareheva'ero, ei g̃a ga pe. Ore ki a'e te Moisésva'eareheva'ero oroko, ei g̃a. ");
INSERT INTO pahNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Tupana'ga e'i Moisésva'ea pe ahe rerekovo hako. A'ea ore orokwaha orokovo, ei g̃a. Akoja'ga reki ma'g̃a e'i ga pe ga mbuhurukarag̃wama? A'ea ore ndorokwahavi, ei g̃a ga pe. ");
INSERT INTO pahNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","—Mbiperanuhũ ko a'ea! Anhimomby'a hete ji pe nenduvame, ei ga g̃a pe. Ga ji mboheha katu. Emo pe ndapekwahavi ga ma'g̃a ga mbuhuruka javo, ei ga g̃a pe g̃a nderekomemuamo. ");
INSERT INTO pahNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Tupana'ga nohenduvi te okote'varuhuve'g̃a nhi'ig̃a jipi. Tikwaha pa nhande a'ea, ei ga. G̃a ki a'e te – kiroki g̃a ga mbohete tuhẽ okovo garemimbotarimova'ea rehe – nanongara'g̃a Tupana'ga g̃wendu katu, ei ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Yvya apoagwera jate ahe nohenduvangavi hehae'ỹve'g̃a moma'eg̃atua – kiroki g̃a ndahehai o'arame. Kiromo jate nhande nihenduvi no, ei ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Po Tupana'ga rũi ga mbuhuruka hamo, a'ero po ga ndoapoi ahemonhimomby'ava'ea hepiuka nhande ve hamo, ei ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Igwete g̃a ei ga pe: —Na tuhẽ ko nde e'a ereko te'varuhu, ei g̃a. Kiro nde ore mbo'epotaruhui naerũ? ei g̃a ga pe. A'ero g̃a ga mombori pea hugwi. ");
INSERT INTO pahNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Aerẽ Jesus'ga henduvi ga mombe'ua. —Omombo g̃a hehae'ỹgwera'ga onga hugwi, ei g̃a ga mombe'gwovo. Igwete Jesus'ga hoi ga reka. Ga repiagame ga ei ga pe: —Erejiko pota nde Tupana'ga remimbuhurukara'ga rehe? ei Jesus'ga ga pe. ");
INSERT INTO pahNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","—Ma'g̃a naerũ? ei hehae'ỹgwera'ga. Tajiko ti ga rehe a'ero javoji, ei ga ga pe. ");
INSERT INTO pahNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","—Erehepia nde ga'ama ejipyri a, ei Jesus'ga. Erehendu nde ganhi'ig̃a no, ei ga. Jihi ko a'ea, ei ga ga pe. ");
INSERT INTO pahNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","—Ajiko ji nde rehe, ei ga Jesus'ga pe a'ero. Igwete ga Jesus'ga mbohetei jipojykahara'ga javo ga pe. ");
INSERT INTO pahNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Aerẽ Jesus'ga ei: —Jirura g̃waramo ti ji avove'g̃a mboja'oja'ogi ojohugwi, ei ga. Jara'g̃a po ti ojiko ji rehe. Jara'g̃a po ti ndojikogi ji rehe, a'e ji, ei ga. Jukwaha reki g̃andekote'varuhua a'ero, ei ga. Nahã, ei Jesus'ga. Hehae'ỹve'g̃a ndokwahavi jipi hepiage'yma g̃waramo. Yvyakotyve'g̃a hehae'ỹve'g̃a ja a'ero, ei ga g̃a pe. Jara'g̃a e'i reki: “Ore ko hehae'ỹve'g̃a ja ikwahave'yma. Ekwahavuka ti ore ve a'ero,” ei g̃a ji ve, ei ga. Nurã po ti g̃a Tupana'ga kwahavi tuhẽ a'ero nehẽ ojikogame ji rehe nehẽ, ei ga. Jara'g̃a ki a'e te e'i tehe ojive: “Ore ko hehae'ỹve'g̃a ja rũi oroko. Orokwaha hete ore,” ei g̃a novĩa, ei ga. Ki g̃a tuhẽ po ti ndokwahavi Tupana'ga a'ero nehẽ. A'ereki g̃a ndojikopotari ji rehe. G̃a nde'i ji ve: “Ekwahavuka ti ore ve,” ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Jararamo fariseus'g̃a g̃wendu ganhi'ig̃a okovo ga pyri. Igwete g̃a ei ga pe: —Ore ve po nde ei naerũ: “G̃a ko hehae'ỹve'g̃a ja ndokwahavi”? ei g̃a ga pe. ");
INSERT INTO pahNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Igwete Jesus'ga ei g̃a pe: —Pyry po pe ei hamo: “Ore ko hehae'ỹve'g̃a ja ndorokwahavi. Ekwahavuka ti ore ve a'ero,” pe'ji po pe hamo, ei ga g̃a pe. Po pe ei poha hamo, a'ero po pe napenhimongote'varuhui hamo. Emo pe pe'ji: “Ore ko hehae'ỹve'g̃a ja rũi. Orokwaha hete ore,” pe'ji pe, ei ga. A'ero pe nhimongote'varuhui jipi, ei ga. Naname Tupana'ga nomombori pendekote'varuhua pe hugwi a'ero, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","2","Igwete Jesus'ga ei g̃a pe g̃a mbo'eavo: —Tamombe'u katu tuhẽ ti pe me, ei ga. Ovelhas repiakatuhara'ga oki ogwovo ovelhas rokaja pype jurukwara rupi, ei ga. Kiroki ga jurukwara rupi rũi oki ipype – ga ko iporomive'ga ahe moandyandyita. Ojiupi ga hokairungava rehe tapyhygahyahi ti herogwovo javo, ei ga. Hepiakatuhara'ga ki a'e te uhu hovapytymbava rerekohara'ga pyri. ");
INSERT INTO pahNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","A'ero ga hovapytymba'vogi hepiakatuhara'ga pe toki ti ga ipype javo, ei ga. Igwete hepiakatuhara'ga ki ua g̃wenymbava pyri hera nanani henoina heno'eamo tokaja hugwi herogwovo, ei ga. A'ea g̃wendu katu ganhi'ig̃a. ");
INSERT INTO pahNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Herohorame ga hoi henonde okovo ji reviri tuhu katu javo. A'ereki garenymbava okwaha ganhi'ig̃a, ei ga. ");
INSERT INTO pahNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Hajiheve'ga reviri ovelhas ndohoi tuhẽ. A'ereki ndokwahavi hajiheve'ga nhi'ig̃a. Oka'nhy reki nanongara'ga hugwi a'ero, ei ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Nahã Jesus'ga ei morog̃itapyahua mombe'gwovo ojo'java'ea mombe'gwovo g̃a pe. Emo g̃a ndokwahavi okovo. —Maraname ga imombe'ui poa nhande ve? ei g̃a ojohupe. ");
INSERT INTO pahNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","A'ero Jesus'ga ei g̃a pe no: —Tamombe'u katu tuhẽ pe me, ei ga. Jurukwara rupi ovelhas oho okovo tokaja pype. A'ea rupi jitehe hepiakatuhara'g̃a hoi ovelhas pyri herekovo, ei ga. Ji ko jurukwara'java'ea, ei Jesus'ga. A'ereki ji rupi jate yvyakotyve'g̃a oho Tupana'ga viara rupi. A'ereki jihi jate g̃a mongo gareheva'ero, ei ga. Jihi jate g̃a mbo'euka g̃andepiakatuhara'g̃a pe no, ei ga. ");
INSERT INTO pahNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Kiroki g̃a ji renonde oko timbo'e ti Tupana'gareheve'g̃a javo novĩa – iporomive'g̃a ja g̃a ahe moandyandyi pota, ei ga. Onhimbuhu tehe g̃a Tupana'gareheve'g̃a pyri g̃a nderekote'varuhuavo. Tupana'gareheve'g̃a ki a'e te nohenduvi g̃anhi'ig̃a, ei ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Ji ko jurukwara'java'ea, a'e ji, ei Jesus'ga g̃a pe. Ji pyri g̃a nduri javo. “Nde rupi ti toroho Tupana'ga pyri,” ei g̃a ji ve, ei ga. G̃a erame ji ve po ti ji g̃a mongoi Tupana'gareheva'ero g̃a nderekokatuavo nehẽ. A'ero po ti g̃a inog̃atui opy'a okovo nehẽ, ei ga. Igwete po ti ji imombyryvi g̃a pe nehẽ g̃a ndepiakatuavo g̃a nderekovo nehẽ, ei ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Iporomive'g̃a uhu jipi tapyhy ti herogwovo javo. “Tajuka ti,” ei g̃a. A'ea rehe jate g̃a nduri. Ji ki a'e te ajo tamboheaporog̃ita pyahu ti g̃a mbohoryva javo, ei ga. Tamongo ti g̃a Tupana'ga pyri nehẽ no, a'e ji, ei ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","—Ji ko ovelhas repiakatuhara'ga'java'ea jipyryheteva'ea jitekovo, ei Jesus'ga javo g̃a pe. A'ereki ji ahepia katu jijiheve'g̃a. G̃andepykavamo po ti ji manoi nehẽ tomanoyme ti g̃a javoji, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Ji ko ojipe'ga ja rũi – kiroki ga e'i tehe ovelhas repiakatuhara'ga pe tahepia ti nerenymbava nde ve javo tehe, ei ga. G̃wenymbava rũi g̃waramo ga ndogwerekokatui reki ovelhas. Nurã ja'gwara'java'ea lobo rurame hehe ta'u javo, kiro ga pohipavi ovelhas hugwi a'ero onhana ogwovo, ei ga. A'ero lobo ruri ipyhyga ovelhas herogwovo ojive. Jara okwaki'o pa ojohugwiugwi, ei ga. ");
INSERT INTO pahNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Oka'nhy ga ogwovo ovelhas reja. A'ereki ga ni'ag̃ataruhui ovelhas rehe hepiakatuhara'ga rũi okovo g̃waramo, ei ga g̃a pe. Ji ko ga ja rũi a'ero, ei Jesus'ga. ");
INSERT INTO pahNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","—Jihi ko hepiakatuhara'ga'java'ea jipyryheteva'ea, ei Jesus'ga. Jiruva'ga ji kwaha hete. Akwaha hete ji ga no, ei ga. Na jitehe ji akwaha hete jijiheve'g̃a. G̃a ji kwaha hete no. Aerẽ ti ji manoi g̃andepykavamo nehẽ no, ei ga. ");
INSERT INTO pahNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","G̃a ndeheve ji areko hajiheve'g̃a jijiheva'ero no. G̃a ko judeus'g̃arũive'g̃a, ei ga. Ambojikoguka po ti ji g̃a jijihe nehẽ. A'ero po ti g̃a hendukatui nhinhi'ig̃a nehẽ, ei ga. A'ero po ti g̃a nhaporemo g̃a ndekoi jireheva'ero nehẽ ojihe'ae'a ojogwehe ojipenhindyvamo nehẽ judeus'g̃a judeus'g̃arũive'g̃a, ei ga. Ji tehe po ti g̃andepiakatuhara nehẽ g̃a ndepiakatupava nehẽ, ei ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","—Jiruva'ga ji arõ hete, ei ga. A'ereki ji a'e: Ji ti amano jiji g̃andepykavamo nehẽ takwerava'ja ti ji javo, ei ga. ");
INSERT INTO pahNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Ji jijukaukare'ymame nhiarõe'ỹve'g̃a pe po ti tegwete g̃a pe jijukahava nehẽ. Emo nhiremimbotarimo po ti ji jijukaukari g̃a pe nehẽ, ei ga. Jipopoaka ji jijijukavouka nhinhimbogweravuka no, ei ga. A'ereki jiruva'ga e'i ji ve a'ea rehe: “Nahã po ti nde rekoi nehẽ”, ei Jesus'ga g̃a pe. ");
INSERT INTO pahNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Kiro judeus'g̃a nduvihava'g̃a nhonhi'ig̃ayvara'javi Jesus'ga nhi'ig̃a renduva. Jara'g̃a e'i onhimongyavo: ");
INSERT INTO pahNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","—Anhag̃a opojyka ga mboheagwyryvuhuavo Diabo'gapyriva'ea, ei g̃a. Maraname pe henduvuhui ganhi'ig̃a naerũ? ei g̃a jara'g̃a pe. Jara'g̃a ki a'e te e'i: ");
INSERT INTO pahNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","—G̃a nde'i te nanongara pe anhag̃a opojykarame, ei ga. Anhag̃a nomoma'eg̃atui reki hehae'ỹve'g̃a a, ei g̃a. Nahã judeus'g̃a nduvihava'g̃a nhonhi'ig̃ayvari Jesus'ga nhi'ig̃a rehe. ");